﻿USE sofia;
DROP TABLE IF EXISTS sofia.nbq_vpl;
CREATE TABLE nbq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nbq_vpl WRITE;
INSERT INTO nbq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","At Yesus Keretus Ala abut en o endak ogagagi wene sek menda ako yusogon. ");
INSERT INTO nbq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","O endak erogo, Yesus ao wagatek hegek, at navi Yesaya Ala wene yugirigya lagagi ako en sek wene yugirigya dugwit, “At Ala en ‘Hat laup sup yarupwak yiluk, Anen ap ambi yonggo endak lakbagya hil neyayogon’, ");
INSERT INTO nbq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ap ambi o harumu ap akwa dekma andoma dugwit, yanggup iri dugwit, ‘Nenasin inis ombok At warup sup sek erogo yagu dogwes, At lagya dogop sup amot erogo yagu dogwes’, yagagi,” Yesaya en dirup watigi. ");
INSERT INTO nbq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Dirup watigi ako wane-wane ap Yaya ap akwa ima wombabisaliga menda o harumu ap akwa dekma andoma wagagi. Wagya lagagirik, ap akwa yugirigya dugwit, “At Ala en hit weyak ogasagwi ako dek erogo bigigapwak en yiluk henendawi wenggebaluk weyak ako nggelabisines. Nggelabugu hiniselok ima wombabigigayogon,” yiluk, yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yugirigya akoma, werekma, it yi ap ndi ap o Yudeya inim, Yerusalem menda inim, ovok erogo at Yaya adema wagu lagagwarik it weyak ogagu lagagwa ako vaganggu-selok at Yaya en is Yoredan ima wombabugu lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","At Yaya ako wam unta iris vaga asum manggadogo yikhidigya, eke agamut vaga mboranis yikhidigya lagagi. At agarom ako idam inim, nggin owangga inim, ninggya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","It ako yugirigya dugwit “At hivis nambetaga warisogon andi, ap ombok aro. Eke an andi maduk. Maduk atma, At isok sepatu sovalek dugwit anen nggolalup andi meyan. ");
INSERT INTO nbq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","An un i-vaga wombabigigaliga ovara, At andi, Averiniki vaga henovaga bigigagiluk warisogon,” yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","At Yaya en ima wombabuguma, At Yesus o Galilea kota Nasaret en adema lagagi. Lagya lagagimu at Yaya en is Yoredan ima wombabagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wombabagya lagagimu At Yesus ima en mondok iri dugwit, mbogot elo heyarogo Averiniki swa suwa wane-wane wigak yagan At ovaga wambu wagya hagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Higya lagagimu, At Ala ane mbogot vaga en iri dugwit “Hat nabut nendawi hunik atma, nendawi adenggen ogagya heyagi o,” yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iri lagagimu, Averiniki en Yesus o harumu ap akwa dekma wolok lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Werekma, at sile en endawi avut mbanggu hegek, ndugwis 40 hudi, swa bagas inim enamwa andoma welagagi. Inim werekma it malaikat mbogot vaga yonggo nelagwi menda en wagu lagagwarik, inim dugwit endawi aik watbagwi, yonggat hugwi, ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Andi okbaluk, at Yaya ako heda magago lembaga mabagagwa. Mabagu lagagwama At Yesus o Galilea At Ala wene sek wene ako yugeregek nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yugirigya dugwit, “At Ala ogarup endawi imbitigi ako vage atma ari waga o. At Ala avema bigigaup ako vage vanggo yagaliga. Hit weyak ogasagwi ako henendawi wenggebaluk nggelabisines. Nggelabugu dogomundik sek wene ako henendawi avyarat umbutu dogwes o,” yiluk, yugeregek nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yugeregek nagu lagagirik is Galilea namut imbilimu lagya dugwit at Simon aot Andreas inim ikan wasagwi menda, yum yarin ikan wasagwi menda ikan waruguluk ima wombabagusim At Yesus en il enegegi. ");
INSERT INTO nbq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wombabagwi il inugu lagagirik, yugirigya dugwit, “Ikan wasagwi hak, ap akwa belalivit nagu dogovovok yiluk yukherayogon. Andi halok An ninim lasogon omanes o,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","yugirigya lagagimu yum ikan wasagwi menda hekbaluk mbikit Yesus inim lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Horok andoma At lagya lagagirik at Sebedeyus aburi Yakobus aot Yaya inim, enasin inim, mburi-vaga dugwit yum yarin ikan wasagwi menda ako manggatwis sek ogagwi il inugu lagagirik ");
INSERT INTO nbq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","“Ninim lasogon o,” yiluk, yanggup yugeragagi. Yanggup yugirigya halok it enasin Sebedeyus eyaganggom inim mburi-vaga andoma hekbisiluk Yesus inim lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","It ako inim lagu lagagwarik, o Kapernaum nonggagagwa. Nunggugu lagagwarik, it Yakuri samban ogasagwima akoma At Yesus samban ogagwi vaga nunggwigya lagagirik, wene mamuleragagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","It At ane enaruk hunggu lagagwarik, ‘Ap yi wii’ yiluk, vok yagagwa. “At ap yi it guru-guru agama en yagalagwi wane-wane dek o, ata At endawi anye vaga mamuneraliga wii!” yiluk vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","At wene mamulirigya hegek, ap ambi madis agoda werek endawima nonggagagirikmu it ap Yakuri samban ogasagwima akoma nunggwigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","naik hunik iri dugwit, “Yesus wai, Hat ap Nasaret menda nggarogo okbininaguluk wagen? Hat dek okbininaguluk wagen a?” yugugu lagagirik “Ala abut weyak ogasigadek mondok sek adigat denek menda heyave an nilup,” ");
INSERT INTO nbq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","yugugu lagagimu At Yesus ako en “Hat hane dek, wilin!” yiluk ");
INSERT INTO nbq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","yugugu lagagimu, at madis ap endawima nonggagagi ako en eyave wuruk-wuruk dede iri dugwit, naik iri lagagirik, nggigilogo winggigi. ");
INSERT INTO nbq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wunggu lagagimu, it ovok erogo “Ayai” yiluk, enalon wisane agu lagagwarik, at ambi en yegek, at ambi en yegek yugu dugwit, “Avyak. Nggarogonggan winggas? Wene adik swi mamulik vaga ane anye vaga ‘Wilin’ yugugu halok, madis ako endawi hobaluk ap endawima en winggas,” yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yugu lagagwarik, Yesus ogagagi wene ako wolok o Galilea avilis ambot akoma inilup ogovit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","It Yakuri samban ogasagwima en wulu wagu lagagwarik, Yesus inim Yakobus Yaya inim, it Simon Andreas enamwa nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nunggugu lagagwama, at Simon ogwa isa aup edup en nggilik werekma Yesus yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yugugu lagagwama At Yesus hwa ako adema lagya lagagirik, inggis vagago mondok okbagagi. Vagago mondok okbagya lagagimu, hwa ako sek agya lagagirik enake ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","O howam mo huruk irisim it ap akwa andoma en it aup warek menda inim, madis enendawima werek menda inim woginiviluk Yesus adema lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","It ap akwa andoma menda ovok erogo sup mbanggutmu mbumbumu homagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Homagu inigik, At Yesus en ap akwa yi aup ndi aup adik-adik menda akoma ovok erogo sek okbogogi, ap akwa madis enendawima werek menda akoma nggigilogo wibogogi. It madis At Yesus inilup atma At Yesus en “Hit henane dek mbup erek dogwes!” yugirigya lagagimu enane dek mbup erek dugwit wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","O yanggo yigiluk o hwis okbaliga andi vaga, Yesus iluk agya lagagirik ap akwa dekma andoma samban ogari winggigi. ");
INSERT INTO nbq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Samban ogagya akoma werekma at Simon aswei inim belalit lagu dugwit At eyave hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","At eyave hugu lagagwarik, “Hat ako aroma heyagek it ap akwa ovok erogo Hat heyave belalhetek nelagwi!” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yugugu lagagwama, At Yesus en “Ap enawi o adik-adik andoma yugeregek lagiluk wagirikmu, lasogon,” yiluk yugirigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","o Galilea yi awi ndi awi andoma it ap Yakuri samban ogasagwima yugeregek lagya dugwit, madis enendawima werek menda halok, nggigilogo wibisilin nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ogarit naguma ap amu hunik welagagi ambi erambo yunggulogo Yesus avema hora yi lagagi. Hora iri lagagirik “Haren an sek okbanup imbitya heyalok sek okbanin o,” nggino yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yugugu lagagimu At Yesus en abwa imbitya dugwit inggis ovaga vagago, “An sek okbagaup himbitirikmu sek okbagagi o,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ao yugu hegek amu ako dek agagi. Dek agya lagagirik sek agagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Sek agya lagagimu At Yesus endawi vaga ane anye erogo yugugu dugwit “Ap akwa yugerabuk. At ap imam ako hat avyarat sek aga andi il heyapwak yiluk adema elak. Hat sek okbagagirikmu, at Musa en ‘Ala ake anderogo baup o’ yiluk yagagi ako it ap akwa heyapwak yiluk Ala ake ba lak,” yiluk lakbagagi. ");
INSERT INTO nbq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aruk warogo lakbagagi ovara, ap ako amwa akoma en wunggu lagagirik, at sek okbagagi wene ako ovok erogo yi awi ndi awi vagalogo yugeregek lagagi. Vagalogo yugeregek lagya lagagimu, At Yesus ako ap akwa enanggelekma selekma nagu dogop andoma dek halok, ap akwa dek werekma, ap akwa yi awi ndi awi en At adema homari lagek adigat ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","At Yesus ap akwa dekma akoma welagagirik, o Kapernaum wagagirikmu “Amwa wagya lagarik agarik o,” yugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ap akwa wisane homari wagagwa ako amwa o hobo-hobo agya lagagimu, sup mbanggut vaga inim werekma At Yesus en Ala wene sek wene ako yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yugirigyama, ap ambi isok weyak, ap eneyave 4 en yo durogo wolok Yesus adema ba wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ba wagu lagagwarik, ap akwa wisane wagu lagagwarik sup nggolo dek halok, o viril vaga wolok unggu lagagwarik, o wake mbeyatbaluk o viril ndendalogo ap ako yo durik wolok wagagwa ako vaga nggilik hegek, mbauk erogo Yesus amor-amot wombabagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wombabagu lagagwama, At Yesus ako en it enendawima At ovaga avyarat umbutu dugwit wolok wagagwa, yedok inugu lagagirik, ap isok weyak ako yugugu dugwit, “Nabut wai. Hat weyak ogagya lagen ako dek erogo bagagi o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yugugu lagagimu, it guru agama andoma horaik dugwit enendawima umbutu dugwit ");
INSERT INTO nbq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ap yi nggarogo yiluk, anderogo yagaliga embetep? Nit weyak ogasagwi dek erogo biniliga ako At Ala adigat agarik. Ambi im dek. Ala weyak-weyak erogo baliga yi,” it enendawi vaga umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","It enendawi anderogo umbutwi ako, At Yesus endawima yedok inugu lagagirik, “Hit nggarogo yiluk, henendawi anderogo winggilisagwi? ");
INSERT INTO nbq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","At ap isok weyak yi ako, ‘Hat weyak ogagya lagen ako dek erogo bagagi o’, yugerup andi iya a, ata ‘Hat hagone ndalek nogoliga menda hedelok elak’, yugerup andi iya a? Yukneres!” yugirigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“An ap at endaklagagis wen vaga yoma dugwit, ap akwa weyak ogasagwi dek erogo okbisapwak en yiluk, Ala en An at mondok okbaninggigi hinilup erogo yukherayogon o,” yiluk, yugirigya lagagirik, at ap isok weyak ako yugugu dugwit ");
INSERT INTO nbq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mondok iri dogomindik, hagone ndalek nogoliga ako hedelok, hamwa lanok yiluk yukisiga,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ap ako ao yugugu hegek, mondok iri lagagirik, at agone ndalek nogo yiliga ako hedelok, it ap akwa ovok inil vaga wasim wunggu lagagimu, “Nit ninil hegetek menda, At ovok ogaga yi, wii,” yiluk, At Ala inis siyabagu dugwit vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Vok yugu-sigik Yesus ako wunggu lagagirik, ndugwis ambi vaga ambi inim is Galilea namut omban vaga lagya lagagimu, ap akwa ovok erogo At adema wagwi, Ala wene yugirigya, ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ala wene yugirigya lagagirik, suvaga lagya dugwit ap ambi inis Lewi, Alepeyus abut, at it pemerintah enake yoparip wonggalisagwima horaik dugwit, yavup ogagya il hagagi. Il higya lagagirik, “Ninim lasogon, oma,” yugugu lagagimu, mondok iri lagagirik, Yesus inim lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Andi okbaluk hivis Yesus inim, At eyaganggom ane welagwi menda ako inim, it pemerintah enake yoparip wonggalisagwi menda inim, it weyak ogasagwi menda inim, it wisane Yesus inim nagu lagagwa ako at Lewi amwa lagu lagagwarik Yesus inim erom nunggusim, ");
INSERT INTO nbq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","it ap Parisi menda guru agama nin akoma en Yesus it weyak menda ako inim At erom nunggwi inil inugu lagagwarik, At eyaganggom yugurugu dugwit, “It pemerintah enake yoparip wonggalisagwi menda inim, it weyak ogasagwi menda inim, Yesus nggarogo yiluk inim dambulik dugwit erom naliga?” enavok mbalogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yugurugwi ako At Yesus aruk hunggu lagagirik, “It ap aup edup dek halok andi, dokter adema laup ombasagwidek. Ata, aup edup halok enadigat dokter adema lendagwi. Andi ndatak, Anen it ap ‘an sek’ ombasagwi menda enake ogarigiluk wagatek o, ata weyak ogasagwi menda enake ogarigiluk wagagis,” yiluk, At Yesus en it Parisi menda enadema yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ndugwis ambi vaga o akoma dugwit, it Yaya ane welagwi menda inim, it Parisi menda ako inim, samban ogagu dugwit, erom nenggetek enelagap moga hak welagagwa. Werekma, Yesus ane welagwi menda erom ugun nunggu-selok, ap akwa Yesus adema wagu lagagwarik, “It Yaya ane welagwi menda inim, it Parisi enane welagwi menda inim, samban ogagu dugwit, erom nenggetek moga hak agarwik ovara, Hat hane welagwi menda andi nggarogo yiluk, ugun erom nelagwi?” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yugugu lagagwama, At Yesus en, “Ap ambi en hwa hedigyama, owa-aot isogo isagu dugwit, enendawi anggin vaga erom nenggetek enelagap moga hak, dogop sek embetep? Andi dek o. Agun inim dugwit, enendawi adenggen vaga naup sek o. ");
INSERT INTO nbq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hivis owa aot inigik, agun ako heda magago wolok laup horok vanggo yi wagya hegek, enendawi anggin vaga erom nenggetek enelagap moga hak dogosogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yugirigya lagagirik, “Yum endak yugup digi swi dalwogo monggatu halok, digi swi dalik werek hegek, yum endak yugup ako ombok erogo libik asigama, digi swi dalwogo yum endak atok hunogo monggadisagwidek o. Swi yugup endak yugup vaga lombalogo monggadisagwi halok, swi yugup lombalek werek ako libilagya dugwit, endak yugup libilik ako ombok erogo at libis yagaliga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yugirigya lagagirik, “Wam kambing agamut ogovak higirik is owak endak menda atma, yo enggen anggur amburup swi menda nudisagwidek o. Nudup halok andi, amburup ako en is owak endak menda yanggalogo maklagya dugwit, yo enggen amburup inim, is owak inim dek arisogon. Wam kambing agamut is owak swi ogovak higirik ako andi yo enggen amburup nudup sek o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Andi okbaluk, ndugwis ambi vaga it ap Yakuri samban ogasagwi vaga At Yesus gandum yagoma suvaga lagyama, At ane welagwi menda ako inim, lagu dugwit, gandum enggen hoda atma, naguluk mbalit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mbalit lagusim, it Parisi menda ako en inugu lagagwarik, “Yesus wai. Ala en, ‘Hit samban ogasagwi vaga yavup anderogo ogarubuk o’, yagagi hegek, nggarogo yiluk ogarit lendagwi?” ");
INSERT INTO nbq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yugugu lagagwama, At Yesus ako en, “Wene at Daut arwi inim, erom dekma, erom uvup dugwit, ogagagwa wene ako, Ala wene vaga hinil dibagatek dugwit yagalagwi? ");
INSERT INTO nbq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Andi o endak ap Abyatar it imam-imam enasin werekma, at Daut ako at Ala awi valekma nunggwigya lagagirik, erom roti Ala ake bago ako, ninggigi. Erom roti ako it ugun naup dek o. It imam-imam adigat nunggu dogopwak yiluk, yugeragagi hegek, at ninggigi. Ninggya lagagirik, it inim welagagwa ako wogirigya lagagimu, it ovok nunggugwa o, yiluk, wene ako hinil dibagatek dugwit yagalagwi?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yugirigya lagagirik, “Ala en o samban ogasagwi vaga yi yavup ndi yavup ogarubuk o, yagagi ako nit ap akwa nenake okbagagi o. Eke, nit ap akwa samban ogasagwi vaga yi ogarubuk ndi ogarubuk ogarupwak yiluk, okbininggitek o. ");
INSERT INTO nbq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Andi atma, samban ogasagwi vaga ogarup andok andi, An ap at endaklagagis yi aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hivis it Yakuri samban ogasagwima umwa akoma ap inggis venak weyak werekma At Yesus nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nunggwigya lagagimu, ap akwa ambetap akoma en, “Samban ogasagwi vaga yavup moga hegek At Yesus ap inggis weyak ako sek okbagya hamwi a dek a?” yiluk, enane wonggalogo ovaga baguluk, inil vik-vak welagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Inil vik-vak werekma At Yesus ako en, ap inggis weyak ako yugugu dugwit, “Mondok iri dogomindik, o ilim yenam oma,” yugugu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","it ako yugirigya dugwit, “Samban ogasagwi vaga sek oginivup andi sek a, eke, weyak oginivup andi sek a? Eneyave inidi yup andi sek a, eke inirup andi sek a?” yugeragagi ovara, enane dek at, mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus mbet iri dugwit il dombalinivit lagagi. Il dombalinivit lagya lagagirik, “Enendawi lakot ai,” yiluk, endawi burup iri dugwit, ap inggis weyak ako yugugu dugwit, “Hinggis welalhanen,” yugugu lagagimu, inggis welalhagagi. Inggis welalhigya lagagimu, inggis ako sek agagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sek agya lagagimu, it Parisi menda ako en wulu wagu lagagwarik, it Herodes menda inim homakbaluk, “Nggarogo waruk o?” yiluk wene mbangguguwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","At Yesus ane welagwi menda ako inim inamut Galilea omban vaga lagu lagagwama, ap akwa wisane o Galilea en At inim lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","It At Yesus ogarit lagya ako enaruk hunggu lagagwarik o Yudeya en, Yerusalem en, o Idumeya en, o Yoredan elavikit en, o Tirus Sidon yi awi ndi awi andoma en ap akwa wisane At adema homari wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ap akwa wisane homari wagu lagagwama, At Yesus en At eyaganggom yugirigya dugwit, “It ap akwa wisane hobo-hobo erogo okbanunggusawen, mburis ambi An hora yumenda amot okbomanes,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","At Mburis ambi amot okbomanes yugeragagi ako, it ap akwa wisane erogo sek oginipigirikmu, it aup warera ako en Yesus ininggis vagaruguluk horok-horok nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Horok-horok werekma, it madis enendawima nonggagagwa ako it madis ako en Yesus inil hugu lagagwarik, Ala abut Hat aro, yiluk, na yugu dugwit, yeve-reve yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yeve-reve yugu lagagwama, At Yesus en ane abet vaga it madis ako yugirigya dugwit, Hit yedok neyagipikmu ap akwa mondok yonggo yugerabuk! yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yugirigya lagagirik, At Yesus ako hulikmu inggya lagagirik, akona en inim dogoguluk endawi hologo bagya lagagirik, warupwak yiluk yanggup iri lagagimu, adema homari wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Homari wagu lagagwama, it ap 12 ako mondok okbugu lagagirik, wene yugirigya dugwit, “Ninim dambulik dogoguluk, mondok okbigigis o. Eke Ala wene yugurugwi, madis ap endawima nonggagagi halok, An ninis vaga nggigilogo wibugwis, ogagu dogovovok yiluk, lakbigigaliga o,” yiluk, enogo mondok okbogogi. ");
INSERT INTO nbq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","It enogo mondok okbogogi ako yi: at Simon inis hivis Peterus sanggigi ako inim, ");
INSERT INTO nbq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedeyus aburi Yakobus aot Yaya inim, ininis andi it enane vaga Boaneges sabogogi, eke nit nenane vaga ‘Unggul Ane Aburi menda’ sabogogi, ako inim, ");
INSERT INTO nbq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas inim, Pilipus inim, Batolomeyus inim, Matius inim, Tomas inim, Alepeyus abut Yakobus inim, Tadeyus inim, at Simon ap Selot menda inim, ");
INSERT INTO nbq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","at Yudas Ikariot ‘Yesus warup’ avok mbanggigi ako inim, ako at enogo mondok okbogogi. ");
INSERT INTO nbq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Enogo mondok okbisiluk, hivis umwa nunggwigya lagagirik, andoma werekma, ap akwa wisane At adema homari wagu lagagwama, Yesus At ane welagwi menda inim ‘Erom naup dek higyo’ yugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ap akwa en “Ap yi nenek yagan naliga yi, wii!” yugu lagagwama At owa aot enaruk hunggu lagagwarik vagaruguluk lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vagaruguluk ogagusim, it guru agama ako o Yerusalem en wagu lagagwarik, “Ap yi sile Belesebul endawima nonggagagi. Sile ako vaga At madis nggigilogo wibisaliga,” yiluk, yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yugu lagagwa ako, At Yesus en it ap akwa warupwak yiluk, yanggup yugirigya lagagirik, At adema homari wagu lagagwama, wene wakhegek yugirigya dugwit, “At sile atma, ap akwa enendawima nonggagagi andi, at sile nggarogo wibaup embetep?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yugirigya lagagirik, “It ap ako enavema bisaligama, ir-it ogotbaluk, adik-adik wunggu-selok andi, sek dogosogon dek o, weyak dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Eke, it o yapwi ambiat agarwik atma, ir-it ogotbaluk, adik-adik wunggu-selok andi, enawi yapwi ambi atma, andoma sek dogosogon dek o, o ako um asogon o. ");
INSERT INTO nbq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Andi halok, at sile inim at avema agarwik menda inim, ir-it ogorek dugwit halok andi, dambulik dogosogonbuk. Ovok dek at arisogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yugirigya lagagirik, “Ap ambi aninis wisane heda magatek hegek, at angge ndiyali nunggup andi dek o. Heda makbaluk andi ndiyali nunggup andi sek o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Yugirigya lagagirik, “An wene avyarat ambi yukherayogon o. Ap akwa yi weyak ndi weyak ogasagwi inim, ap enavok weyak-weyak erogo biselagwi inim, At Ala en mbo baluk, dek erogo bisaup ndak ovara, Averiniki avok weyak-weyak erogo belagwi halok andi, At Ala en enomaluk ako andi dek erogo bisayogon mondok dek o. Andi vaga weyak enovaga dinggilik hegek mondok dogosogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Andi yugeragagi ako andi iren, “Madis endawima nonggagagi o,” yagagwa halok, anderogo at yugeragagi.) ");
INSERT INTO nbq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Anderogo yugirigyama, At isa inim, arwi inim, wagu lagagwarik, wamu andenam mendek dugwit, “Yesus wulu warupwak yiluk, yugeres,” yiluk, yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yugurugu lagagwama, it ap akwa wisane At adema homago horaik agarwik ako en, “Yesus wai. Hisa inim, harwi inim, wamu dugwit, habyam agarwik,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yugugu lagagwama, At Yesus ako en, “An nisa, An narwi andi sa embetep?” yugirigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","At adema horaik welagagwa ako il yambenipu dugwit, “Dek o. An nisai, An narwi, hit heneyave yi aro. ");
INSERT INTO nbq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hit Ala endawi ombasiga wane-wane ogagu hiniselok andi, nisai narwi andi hit aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Hivis ambi inim is Galilea namut yanggadekma omban vaga wene mamuleragagi. Wene mamulirigya werekma, ap akwa iya erogo At adema homagagwarikmu, inamutmu mburi-vaga hora yi nonggagagi. Mburi-vaga horaik dugwit, it ap akwa horok is omban vaga ombok homago wisane at inigik, ");
INSERT INTO nbq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","yi wene ndi wene ovok at wene wakhegek vaga mamuleragagi. Wene mamulirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Henaruk holek dogwes, wene ambi yisogon!” yugirigya lagagirik, “Ap ambi en awi lisiligiluk lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lisilit lagya hegek, nin suvaga wombagagi. Suvaga wombagagi ako andi, swa wagu dugwit, ovok nenggek lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nin andi wen helep iri vaga wombagagi. Wambigya lagagirik, helep iri vaga wombagagi ako andi, wen ambukumat halok, avuduk inggigi ovara, ");
INSERT INTO nbq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","helep iri vaga atma, omanggen sek erogo yago dekma, mo en dis iri lagagirik, mbuk agagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eke, ambitap iringga adok werek anggelekma wombagagi. Iringga anggelekma wombagagi ako, vudanggigi ovara, iringga adok ako inggya dugwit, mbalogo wombanggigirikmu enggen yigitek at welagagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nin wen mudis vaga wombagagi. Wen mudis vaga wombagagi ako vudanggu lagagirik, adem mudis-mudis inggya lagagirik, andi okbaluk, enggen at yikligya dugwit, adem ambi en 30 yugu, adem ambi en 60 yugu, adem ambi en 100 yugu, ogarit lagagi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yugirigya lagagirik, “Henaruk werek halok andi, des erogo at henaruk hunggu dogwes o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yugirigya lagagirik, adik werekma, At inim agarwik ako inim, it ap 12 inim, it ako en Yesus hemetugu dugwit, “Hat wene wakhegek vaga yukneregen ako, des erogo yuknerano,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yugugu lagagwama, At ako en, “At Ala avema bigigaup wene ako At endawima hwilago welagagirikmu, vagalogo yukheraliga ovara, it ugun andi, yi wene ndi wene wakhegek vaga yugeraliga o. ");
INSERT INTO nbq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Andi, ‘Inil helagwi ovara, dibagatek agarwik o. Enaruk hulisagwi ovara, enendawima en wegetek agarwik o. Enendawima wenggenggu iniselok, it yi weyak ndi weyak ogasagwi ako hekbaluk, At Ala en dek erogo bagya hawen’, yiluk, wene atok wakhegek vaga yugeraliga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yugirigya lagagirik, “Wene wakhegek vaga yukhirigi yi, wegetek dugwit, yagalagwi? Wegetek hiniselok, hivis wene wakhegek yukhirigya halok nggarogo waup embetep?” yiluk, yugugu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Wene wakhegek ako adem yerogo: At ap awi lisilisiga menda ako en, awi lisilit lagagi ako hak andi, Ala wene sek wene yugeregek nelagwi andi aro. ");
INSERT INTO nbq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Eke, awi suvaga wombagagimu swa nenggek lagagwa ako hak, it ap akwa ambetap sek wene ako hunggu lagagwama, at sile mbikit wagya lagagirik awi Ala wene ako enendawima lisilik agarik ako henogo wolok wilisiga aro. ");
INSERT INTO nbq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Awi wene helep iri vaga wombagagi ako hak andi, it ap akwa nin sek wene ako enaruk hunggu dugwit, enendawi adenggen vaga welagwi ovara, ");
INSERT INTO nbq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","hivis en enendawima omanggen yagatek dugwit, ndugwis ambi dukluk, wene wagas ako vaga aninggin-mbaninggin erogo oginipwis, edup-mbedup erogo bugwis, ogagu-selok, “Wene andi, nenanggon o,” yiluk, helabisiluk wilisagwi. ");
INSERT INTO nbq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Awi iringga adok werek anggelekma lisilogo wombagagi ako hak andi, ap akwa nin sek wene enaruk hulisagwi ovara, ");
INSERT INTO nbq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wen vaga menda adigat enendawi anggin vaga wenggelit lagwi, yi menda ndi menda dek arup hegek enendawi wenggelit lagwi, yi menda ndi menda enendawi hogop ombarit lagwi, andi ogarit lendagwi vaga andi, awi nin ako iringga en mbalogo wombagagi ako hak, wene ako sovalogo belagwima, andi vaga enggen yigitek aro. ");
INSERT INTO nbq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Eke awi wen mudis vaga lisilogo wombagagi ako hak, andi, ap akwa nin wene enaruk hobaluk, wogogwarikmu, enggen yugu dugwit, adem ambi enggen 30 yugu, adem ambi enggen 60 yugu, adem ambi enggen 100 yugu, ogasagwi o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yugirigya lagagirik, it yugirigya dugwit, “Lambu wulilogo sogolowak avema baup embetep? Mbanggu avema baup embetep? Dek o. Sigam wulilogo baup andi sek. ");
INSERT INTO nbq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anderogo hak, yi menda ndi menda hwilago agarik andi sigam arigiluk, agarik o. Yi wene ndi wene endawima sovalek agarik ako andi, sigam arigiluk agarik o. ");
INSERT INTO nbq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Henaruk werek halok andi, des erogo at henaruk hunggu dogwes o.” ");
INSERT INTO nbq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yugirigya lagagirik, “Hit henaruk hulisagwi ako, henendawi dibagu dogwes. Wakhegek ako vaga wakelok, ap akwa wogerelagwi ako ndatak wakelok wokirigya hasogon. Andi halok, ambi inim ovaga ndulogo wokirigya hasogon. ");
INSERT INTO nbq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hit menda ambi agarik halok andi, ambi inim ovaga ndulogo wokirigya hasogon. Eke, hit menda ambi dek halok andi, ambukumat agarik ako ndiyalogo hedigya hasogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yugirigya lagagirik, “Ala avema bisaup ako andi, ap ambi awi lisilit lagya lagagirik enggen yiliga hak aro. ");
INSERT INTO nbq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","At ako o hup agya halok nogo yugu, eke o yanggo iri halok, yi ogagek ndi ogagek ogagya hegek awi angge ako avuduk inggya lagarik, adem ombok asiga. Adem ombok asiga andi, nggarogo ombok asiga? At unggut. ");
INSERT INTO nbq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Wen vaga lisilik atma, endagen enggen yiliga. Endak andi avuduk dagasiga. Avuduk inggya lagarik, angga mbigalisiga. Angga mbiganggu lagarik enggen yiliga. ");
INSERT INTO nbq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Enggen yugup sok agya halok, mbalup hudi agarikmu, ap en yaga vaga mbalisagwi ako hak andi, At Ala avema bisaup wene andi aro,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yugirigya lagagirik, ambi yugirigya dugwit, “At Ala avema bisaup ako andi, nano ndatak wakaup embetep? At Ala avema bisaup ako ndatak wene wakhegek ngga yukheraik?” yugirigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Dek o. Ala avema bisaup andi vudok enggen hak aro. Yi awi ndi awi enggen ombok ovara, yo vudok andi enggen maduk. Awi yagwi halok, ");
INSERT INTO nbq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","enggen maduk ovara ombok yiliga. Ombok yugu lagagirik, abwak mbiganggu halok, yirwa ndirwa avema andoma enawi valheda nunggwisagwi hak andi, nit Ala avema bininaup wene andi ndatak aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus ako yi wene ndi wene nggarogo inilup arupwak yiluk, Ala wene wakhegek vaga yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wene selekma vagalogo yugeregetek, wakhegek adigat yugirigya lagagi ovara, it At ane welagwi menda ako andi At inim enadik dugwit, yi wene ndi wene yugeragagi ako vogalogo yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yugirigya lagagirik, o howam agya halok, At Yesus en At ane welagwi menda ako yugirigya dugwit, “Is ambo elavokot lasogon en,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yugirigya lagagirik, it At ane welagwi menda ako ap akwa wisane akoma hetbisiluk, At Yesus mburi-vaga werekma, adema nunggugu lagagwarik, At inim lagagwa. Mburis nin inim lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lagusim o havut endengga ombok wagya dugwit, is legamuk ogagya dugwit, mburis elola akoma is yanggadi nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yanggadi nunggwigya hegek, At Yesus ako mburis atokma yum unggul didibaluk, nogo yuguma, it akoma en iluk okugu lagagwarik, “Nenasin guru wai. Is vage ndokalninivisiga en, Hat nano yiluk nenabwa haligadek nogo yiliga?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yugugu lagagwama, iluk agya lagagirik, havut ako, “Moga,” yugugu lagagirik, is ako “Havolok dek mbup iru,” yugugu lagagimu, havut inim, is inim avolok dek agagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dek agya lagagimu, “Hit nggarogo yiluk henalon yagalagwi? Hit henendawi An novaga vanggabaluk, avyarat nembetetek dugwit yagalagwi?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yugirigya lagagimu, it ako enalon agu lagagwarik, ap ambi en ap ambi yugigik yugu dugwit, “Eya! Ap yi is inim, havut inim, At ane hulisiga yi sa?” yiluk, vok yagagawa. ");
INSERT INTO nbq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Inamut yanggadek ako ambo elavikit ap o Gerasa menda werekma lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lagu lagagwarik, mburi-vaga en ao wunggu lagagwama, ap madis nenek endawima nonggagagi menda ap hambugu-selok wimu biselagwima akoma en, Yesus adema wagagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","At ap ako, hambugu-selok wimu biselagwima akoma welagagi. Welagagirikmu inggis isok mbusi heda magek adigat ogagu lagagwa ovara, heda mabagwi, libinggu, heda mabagwi, libinggu, hunik ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Inggis isok inim, mbusi heda magek adigat ogagu lagagwa ovara, yimbi-mandok iri dugwit, inggis isok mbusi heda mago ako libik-ndendok erogo lakbagek adigat ogagya halok, it ap akwa ovok en ap ako vagarup meyan hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hup dingga hunik wimu biselagwima akoma inim, hulikmu inim, naik yagan, helep vaga wakhedegek nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Akoma dugwit, o adumu en Yesus wagya il hagagi. Il higya lagagirik, At adema vupuk lagya lagagirik avema seve yiluk, ");
INSERT INTO nbq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Yesus wai. Hat Ala mondok siyalek agarik ako abut yi an nggayok okneragiluk wagen?” yiluk ane ombok vaga naik iri dugwit “Ala inis vaga mondok narubuk,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(“Ala inis vaga mondok narubuk” yagagi andi At Yesus en “Hat madis yi ap yi endawima en wilin,” yugogogirikmu at ap ako at “Ala inis vaga” yagagi.) ");
INSERT INTO nbq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","“Wilin,” yugugu lagagirik, “Hat hinis sa?” yugugu lagagimu, “An ninis Wisane salek agirik, neneyave wisane halok,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","“Nasin ai! An nendawima yoma en eneyave nggigilogo o isugut o hunogoma andoma wibisabuk,” yiluk, ane ambi inim nggino yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yugugu lagagirik, hulik avema andoma wam wisane buris yilin nagusim werekma, ");
INSERT INTO nbq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","it madis ako en “Ai, wam enendawima nungguguluk lakbininin,” yiluk yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus ako yugugu lagagwama, At ako en “E o. Elales,” yiluk, yugeragagi. “Elales,” yugirigya lagagimu, madis ap endawima en wunggu lagagwarik, wam enendawima nunggugu lagagwama, wam wisane 2000 hudi o lapik-lapikmu akoma en yulup yagan, inamutmu nunggugu lagagwama, is ako en ndokalipigi. ");
INSERT INTO nbq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Is ndokalipu lagagimu, it wam wogenaviluk nelagwi menda ako hoda sak yagan wunggu dugwit, wam is ndokalipigi wene ako o ombokma im, madukma im, yugeregek lagagwama, it ap akwa ako en, “Nggarogo agamu?” yiluk bigisa wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesus adema wagu lagagwarik, ap madis endawima nonggagagi ako, eve ap endawi sek agya lagagirik, yum yikbetaluk werekma, andoma at horaik hugu lagagwarik, enalon agagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Enalon agu lagagwama, it endak oklagagi inil hagagwa ako en madis at endawima nonggagagi wene inim wam ako is ndokalipigi wene inim, mbilinogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yugurugu lagagwama, it ap akwa akoma en Yesus it enamwa en wulupwak yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","At Yesus mburi-vaga nunggigiluk ogagya lagagimu, ap madis endawima welagagi ako en, “Ninim lasogon o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yugugu lagagimu, At Yesus en, “Dek o. Hat hamwa howa-hasin werekma lagya dogomindik, hat Hasin habwa en sek oketas ako yugerelak,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yugugu lagagimu, lagya lagagirik, o inis Dekapolis akoma, Yesus ogagagi wene ako yugeregek nagu lagagimu, ap akwa ovok erogo vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mburi-vaga At Yesus ako is ambo elavikit en eyami vaga wulu wagya lagagirik, is embet vaga werekma, ap akwa wisane At adema homari wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Homagu lagagwarik werekma, it ap Yakuri samban ogasagwima vagenombogo agarik menda ambi inis Yairus wagya lagagirik, Yesus avema seve yiluk, ");
INSERT INTO nbq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","abwa edik abwa edok iri dugwit, “Yesus wai. An nabut hwavyak edup en hambup atma, hinggis vakbaluk sek iluk ogaitnok en yiluk, oma o,” hunik adigat yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hunik adigat yugugu lagagimu, At inim lagagwa. It mberen lagusim, it ap akwa wisane inim lagu dugwit, linggililuk lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Linggililuk lagu lagagwama, hwa ambi amep ogagya helan, 12 tahun welagagi ako, ");
INSERT INTO nbq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","angge-angge ovok erogo dokter-mandiri it ap sek oginivisagwi menda ako wogirigya lagagimu, sek oknerapwak yiluk ogagu lagagwa ovara, edup ako dek agatek evenuk agya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","At hwa ako en Yesus sek oginavit nagu ako aruk hunggu lagagirik, ap akwa wisane enanggelekma Yesus ambutmu nunggwigya lagagirik, asum inggis vakbagagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Asum ninggis vakbagya neyalok, sek oknerayogon o,” imbitya lagagirik, inggis vakbagagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Asum inggis vakbagya lagagirik, amep ogagya lagagi ako dek agya lagagimu, “Namep ogagya lagi ako yogak andi sek oknitya higi o,” yiluk, imbitigi. ");
INSERT INTO nbq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Imbitya hegek, At Yesus ako en, “Anen ambi ogagi higi,” yiluk, yedok higya lagagirik, ap akwa linggililuk wagwi ako, avilimu ambutmu dagalogo bigupu dugwit, “An nasum sa en inggis vagatas?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yugirigya lagagimu, At eyaganggom ako en, “Ap akwa linggilik welagao inigin ovara, Hat nggarogo yiluk, sa en vaketamu yiluk, yagaliga?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yugugu lagagwama, At Yesus il yen woginipu dugwit, “Sa en nasum inggis vagatas?” yiluk yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yugirigya lagagimu, at hwa ako “Sek oknetas higi,” imbitya lagagirik, alon en owak wuruk iri dugwit, At avema seve yiluk at ogagagi ako vagalogo yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Vagalogo yugugu lagagimu, At Yesus en, “Ai, naot o. Hat hendawi An novaga vanggabaluk, avyarat nembeten vaga sek agen o. Sek dogosogon atma, hendawi ugun elak o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ao yugugu hegek, ap Yairus amwa en wagu lagagwarik, “Yairus, habut ovok hombagas helan, Yesus un anggodo wolok wandiga o,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yugogogwa ako Yesus aruk hunggigi ovara, enane sovalogo bagya dugwit, at Yairus ako yugugu dugwit, “Hendawi An novaga vanggabaluk, avyarat nimbitya dogwen. Halon ombarubuk,” yiluk ");
INSERT INTO nbq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","yugugu lagagirik, “It ap akwa ugun ninim warubuk,” yiluk, at Peterus inim, Yakobus aot Yaya it mberen inim, Yesus inim enadik lagu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ap Yairus ako amwa wagu lagagwarik, ap akwa nane-hane yugu dugwit, de wene yugwi, yup yagwi, inugu lagagirik, umwa akoma nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Umwa nunggwigya lagagirik, yugirigya dugwit, “Hwavyak yi hambegetek, un nogo yiligama, nggarogo yiluk nane-hane yup yagwi, ogasagwi?” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yugirigya lagagimu, it ako en At agonda yagagwa ovara, ap akwa ovok nggigilogo wasim wibisiluk, hwavyak asin-isa inim, At arwi henggam ako inim, At wogenombolok hwavyak werekma akoma nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nunggugu lagagwarik, inggis vakigya dugwit, “Talita hum,” yugogogi. Eke, nit nenane vaga “Hwavyak i. Mondok yinok yiluk yukisiga o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yugugu lagagimu, at hwavyak ako mondok iri lagagirik, amwa akoma nagu lagagi. Hwavyak ako sawe agatek hegek, umur 12 tahun welagagi. At nagu lagagimu, ap akwa ovok erogo “Wii,” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","At Yesus en ane avuput vaga ap akwa enadema yugirigya dugwit, “At hwavyak sek ogagi yi, ap akwa yugerabuk,” yugirigya lagagirik, “Erom napwak yiluk wogeres,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","O andoma en Yesus At ane welagwi menda ako inim, awi adem vaga lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lagu lagagwarik, samban vaga it ap Yakuri menda samban ogasagwima, nunggwigya lagagirik, wene mamuleragagi. Wene ao mamulirigya hegek, it At ane enaruk hunggugwa ako en, “Ap yi wene nggoma en wagas vaga yagaliga? Ap endawi werek hak yagaliga yi, nano wene wagas vaga yagaliga o? Ogarubuk menda ogasiga ako, nggarogo erogo ogasiga embetep? Wii,” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Vok yugu lagagwarik, “At hwa Maria eyak o valisiga menda yi arwi Yakobus inim, Yoses inim, Yudas inim, Simon inim, At arwi hwavyak inim agarwik yi ako, dek?” yiluk, At Yesus enanggon umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Enanggon umbutu lagagwama, At Yesus en, “It ap navi-navi Ala wene yugerelagwi menda andi yi awi ndi awi en siyabiselagwi ovara, at awi adem vaga menda inim, enowa-enaot inim, avuk agarwik menda en ininis siyabiselagwidek o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yugirigya lagagirik, ogarubuk menda andoma en ogarup meyan halok, un ambitap-ambitap, aup idumu, inggis inunggul vakbisiluk, sek okbogogi ovara, ");
INSERT INTO nbq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","it enendawi At avyarat embetetek halok, Yesus “Wii,” imbitigi. Yesus yi awi ndi awi yanonggwegek-ndanonggwegek wene mamuleregek nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nagu lagagirik arwi 12 menda ako warupwak yiluk, eneyanggup yugeragagi. Wagu lagagwama, madis agoda werek menda nggigilogo wibigik nagu dogopwak yiluk, wene yugirigya lagagirik, mberen hondok lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Lakbugu dugwit, “Erom inim, yum inim, yoparip inim, wolok labuk. Un hit henowanggun adigat hedelok elales. ");
INSERT INTO nbq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hinarupato yikedaup, andi sek ovara, heneyave atma yum mberen yirup dek o,” yiluk, enaruk watigi. ");
INSERT INTO nbq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Enaruk watya lagagirik, yugirigya dugwit, “O ambima lamundikmu, wokinupu-selok, hinim andoma dogomundik, elalo. ");
INSERT INTO nbq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","O ambima en hit wokinapitek halok, hinane inim enaruk hunggitek halok, inil vaga hinilamundinek hinisok vaga mupak hak horogo baluk, andoma en wilitalo o,” yiluk, lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Lakbugu lagagimu, lagu lagagwarik, “Hit weyak ogagu lagep ako, henendawi hobaluk, mbo bas o,” yiluk, yugeregek nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nagu dugwit, yi madis ndi madis wisane nggigilogo wibigik, aup edup enovaga amburup minyak zaitun ndibisiluk sek oginipwis, ogenavit nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Oginavit nagu lagagwa ako vaga, At Yesus inis yi awi ndi awi inaruk hunggugwarikmu, ap inis ombok Herodes ako inim aruk hunggigi. Inaruk hobagu lagagwarik, it nin en, “At Yaya ima wombabugu lagagi ako hambisagwima en iluk akluk, mendok yagas ako vaga, ogarubuk menda ogarit lagya higyo o,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","It nin en, “Dek o. Eliya aro,” yugwi, eke it nin en “It endak Ala wene yugurugu lagagwa navi-navi ako hak, yogak yagaliga o,” yugwi, yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yugwi ako, at Herodes aruk hobagya lagagirik, “Avyak. Yaya avup mbanggigis ako, iluk akluk, mendok yagas higi o,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Andi, hwa Herodiyas at Herodes aot Pilipus ogwa hegek, at Herodes en hedagagirikmu, at Yaya en Herodes yugugu dugwit, “Hat haot ogwa hegek, wegindikmu hinim dogop moga o,” yiluk, yugugu lagagi. Yugugu lagagirikmu, at Herodes en hwa ako endawi sek arupwak yiluk, Yaya heda marupwak yiluk, ap enayegen werek lakbugu lagagimu, lagu lagagwarik, heda makbaluk, lembaga mabagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Mabagu lagagwama, at Yaya yagagi ako vaga at hwa Herodiyas ako endawi aninis wisane agagi. Endawi aninis wisane agya dugwit “Yaya watbaup,” imbitya hegek ap Herodes ako en “Yaya ako weyak ogagetek, endawi sek atma warup dek,” imbitigi. At Yaya en wene yugugu hegek, ap Herodes aruk hunggu dugwit endawi anggin ovara, hulup endawi adenggen imbitya dugwit, “Watya hawen,” yiluk Yaya hwilakbagagi. Hwilakbagya lagagimu, watbaup ako dek agagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Warup dek agagi ovara, at Herodes endaklagagi hudi ari wagagirikmu, at arwi, kepala-kepala mondok okbogogi inim, it enayegen werek menda inim, it ap Galilea menda enasini ap ombok-ombok inim, adenggen isogo isagusim, hwa Herodiyas ako en, “Ee! yogak andi nanonggal homagaoma,” imbitigirikmu, ");
INSERT INTO nbq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","at Herodiyas eyak ako nunggwigya lagagirik, vilino-veleno iri halok, at Herodes aswei enayonggo lakbogogi wagagwa ako inim, “Hwa yi yagaliga a, wii,” yiluk vok yugu lagagwama, at Herodes en hwavyak ako yugugu dugwit, “Hat nano menda nggino yuknugu heyalok, an wokirisogon o.” ");
INSERT INTO nbq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yugugu lagagirik, “Hat an nano wokirup embeten? O yoma an nandok agirik atma, ‘Hudi mbalogo banin’, yuknugu heyalok, anen venak higirogo bagasogon o, Ala inis vaga avyarat yukisiga,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iri lagagimu, wunggu lagagirik, hwavyak ako isa hemetigya dugwit, “An nano menda nggino yugirik?” yugugu lagagimu, isa ako en “At Yaya ima wombabisaliga menda unggul mbalhirumwak yiluk yugiri elak,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yugugu lagagimu, at hwavyak ako vupuk lagya lagagirik ap ombok adema, “Yogak Yaya ima wombabisaliga menda avup mbalogo unggul walup vaga mbo erogo wokniri omano,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yugugu lagagimu, ap ombok Herodes ako endawi weyak agagi ovara, it isogo isagusim inil vaga at Ala inis vaga yagagi halok, hekbaup anggon embetek, ");
INSERT INTO nbq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ap yegen werek ambi Yaya avup mbalogo unggul wolok warupwak yiluk, lakbagya lagagimu, lagya lagagirik, lembaga nunggwigya lagagirik, adonggop mbalogo ");
INSERT INTO nbq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","unggul walup vaga mbo erogo wolok wagagi. Wolok wagya lagagirik, hwavyak ako wogugu lagagimu, isa wogogogi. ");
INSERT INTO nbq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Andi en at Yaya ane welagwi menda ako en, Yaya avup mbanggugwa inaruk hobaluk lagu lagagwarik, eyave wolok wimu balagagwa ovara Yesus yagan nagwis ako Herodes aruk hunggu lagagirik “Yaya iluk akluk mendok yagas higi o,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","At Yesus lakbogogi ako eneyami vaga At Yesus adema wagu lagagwarik, it ogarit nagu lagagwa wene inim, mamuleregek nagu lagagwa wene inim, wene mbilinogo yugiri wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mbilinogo yugiri wagu lagagwama, ap akwa wisane erogo At adema lagwi-wagwi ogagusim, erom naup dek agya lagagimu, At Yesus ako en, “Sat yanggalhedaguluk, nenadikmu ap akwa dekma lasogon en omanes,” ");
INSERT INTO nbq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","yugirigya lagagimu, it ako mburi-vaga nunggugu lagagwarik, enadik ap akwa dekma, andoma lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yesus asweimuni inim lagwi ako ap akwa wisane yedok inugu lagagwarik, o yi awi ndi awi en it wen vaga vupuk enendak enabyam ari lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","At Yesus ako mburi-vaga en is embetma wulu wagya dugwit, ap akwa wisane homago ako il inugu lagagirik, “It wam ndomba vagenombogo dek menda ako hak, it yi anderogo at inigis o,” imbitya lagagirik, “Enabwa o,” imbitya dugwit, yi wene ndi wene mamulirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wene mamulirigya hegek, o vage hup agya lagagimu, At ane welagwi menda ako At adema wagu lagagwarik, “O ovok hup agya halok, o yoma ap akwa dekma wagyoma, ");
INSERT INTO nbq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ap akwa yi enagarom onggo hunhedapwak yiluk, o ombokma inim, o adik-adik valekma inim lakbisino,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yugugu lagagwama, At Yesus en, “Hiren at enagarom wogeranes,” yugirigya lagagimu, iren, “Nit erom hunogo menageraup andi onggo andi onggo ombok yoparip 200 denari baup embeten?” ");
INSERT INTO nbq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yugugu lagagwama, At Yesus en, “Hit henagarom maren agarik? Yokanes.” Yugirigya lagagimu, yokugu lagagwarik, “Erom roti un lima, eke ikan mberen at agarik,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yugugu lagagwama At Yesus en it yugirigya dugwit, “Ap inarwi dombok mbeyambup vaga andena bisam ndalogo hora yi elales,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yugirigya lagagimu, it ap homago ako, nin 100 vaga ambima hora yugwi, nin 50 vaga ambima hora yugwi, ogarit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hora yi lagu lagagwama, At Yesus ako en erom roti lima ikan mberen inim, wigya lagagirik, il mbogot vaga iligik dugwit, “Ala Nasin wa!” yiluk, samban ogagagi. Samban ogagya lagagirik, erom roti ugurogo ap akwa ako sumburerapwak yiluk, At ane welagwi menda wogeragagi. Wogirigya lagagirik, ikan 2 wogogo it ovok erogo napwak yiluk, sumbureragagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sumburirigya lagagimu, it ako ovok nunggu lagagwarik, enagaum agagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Enagaum agya lagagimu, erom inim, ikan inim, nin higirogo bagagwa ako, mburin yum 12 vaga yedogo mbin erogo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","It ap erom roti nunggugwa ako, eneyave dambulik andi 5000 nunggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Erom roti nunggu lagagwarik, At Yesus en At ane welagwi menda ako yugirigya dugwit, “Mburi-vaga nunggugu dogomundik, o Besaida henendak lagu dogwes,” yiluk ane avuput vaga yugirigya lagagirik, lagu-sigik, ap akwa ako enamwa lakbigigi. ");
INSERT INTO nbq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ap akwa ako lakbugu lagagirik, hulikmu andoma samban ogari inggigi. ");
INSERT INTO nbq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Akoma samban ogagya lagagirik, o hup agagirikmu, mburis ako is namutmu ilim ari wagya lagagimu, At Yesus ako wambu wagya lagagirik, adik is omban vaga welagagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Is omban vaga andoma dugwit, o havut elavokot en wagya dugwit, mburis ndililhagagwa ndililhagagwa meyan at hagagwa, Yesus en il inogogi. O hup o yanggo yigiluk ogagya hegek, At Yesus is iri vaga isok yabagek-ndabagek enadema lagagi. Lagya lagagirik, it mburi-vaga inigik mbikit lagiluk ogagya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","iren is iri vaga isok bagek lagya inil hugu lagagwarik, enendawima en “Yi isawi ai!” umbutu lagagwarik, na yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","It ovok At wagya inil hugu lagagwarik, enowak wuruk iri lagagimu, “Henanggela wulubuk. An neyave at wandiga atma, henugut habuk,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yugirigya lagagirik, mburi-vaga enadema wagya lagagimu, o havut ako avuput dek agagi. O havut ako dek agya lagagimu, “Wii,” yiluk, enalon iya erogo hugu lagagwarik, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","It vok yagagwa andi, At erom roti ugureragagi ako adem dibagatek dugwit enendawi obak ugun welagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Is elavokot o Genesaret wunggu lagagwarik, mburis is omban vaga andenam heda yidilogo baluk, ");
INSERT INTO nbq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","weram wunggu lagagwama, it ap akwa akoma en At Yesus wagya ako mbikit yedok hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yedok hugu lagagwarik, yi awi ndi awi andoma yonggo vupuk lagu lagagwarik, “Yesus nggenam agarik, yugusamwi?” yiluk, it aup warek ako yo vaga agone ndabaluk Yesus adema wogenombolok lagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","O madukma inim, o ombokma inim, o adik-adik andoma inim, nagu hawen, it aup warek ako vasat vaga bisa wagu lagagwa. Bisa wagu lagagwarik, un Yesus ayum atok ininggis vagarupwak yiluk, nggino yugugu lagagwama, vakugu-selok, Aren ovok sek oginipu lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","It ap Parisi menda inim, it guru agama inim, Yerusalem en Yesus adema wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wagu lagagwarik, At ane welagwi menda ako ininggis adat vaga horekdek, un ugun dugwit erom nunggwi inil inogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(It Parisi menda ako inim, it Yakuri ovok erogo inim adat it enombawi ogagu lagagwa mamulik ogagu lagagwarikmu, ininggis adat vaga horekdek halok andi erom nenggetek wulugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Erom hunisagwima akoma en wagu dukluk, ininggis adat vaga horekdek dugwit, erom nelagwi dekma. It enombawi ogagu lagagwa mamulikmu ogagu dugwit manggok inim, sogolowak ombok-mariduk inim, adat vaga hurisagwima.) ");
INSERT INTO nbq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Anderogo ogasagwi atma, it Parisi menda ako inim, it guru agama ako inim, Yesus yugugu dugwit, “Hat hane welagwi menda yi, adat nit nenombawi ogagu lagagwa ogasagwi hak, ogagetek, nggarogo yiluk ininggis adat vaga horekdek ugun at erom nelagwi?” yiluk yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yugugu lagagwama, At Yesus en it yugirigya dugwit, “At Ala en yagagi ako hit henendawi sek ovagada erogo at Yesaya en endak avyarat dirup watigi: “Hit ap akwa yi, henane vaga An Ala siyabanilagwi ovara, henendawi andi adumu erogo agipik o. ");
INSERT INTO nbq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hit mamulerelagwi ako andi, ap akwa enane yugup hegek, mamulerelagwima, enam warogo nggarogo yiluk An ninis adup ogasagwi o.” ");
INSERT INTO nbq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yugirigya lagagirik ambi inim yugirigya dugwit “Ala wene yugup ako sovalogo baluk, hit henombawi ogagu lagagwa mamulik atma ogasagwi hinigis o,” yiluk yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yugirigya lagagirik, “Hit henombawi ogagu lagagwa mamulikmu ogagu dogoguluk, At Ala yagagi wene hekbelagwi atma, hit sek at hinigis o. ");
INSERT INTO nbq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","At Musa en iri dugwit ‘Henasini hinisai enane des erogo hunggu dogwes'. Eke, ‘Enane mbidarogo bamwi halok, mondok mondok inirup aro' yiluk, yagagi ovara, ");
INSERT INTO nbq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","hit andi henasini-hinisai yugurugu dugwit, ‘An nangge wokirup imbiti ovara, Kurban. Andi, Ala ake betagagis o’, yugurugwi halok, ");
INSERT INTO nbq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","andi okbaluk, henasini hinisai enake okbisaup andi dek yugu hinigis o. ");
INSERT INTO nbq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Adat hit henombawi ogagu lagagwa mamulik vaga, ap akwa yugerelagwi ako ogarit lagwi vaga, Ala wene andi dek erogo baguluk ogagu hisaliga o. Hit ogasagwi ako andi, iya erogo at ogasagwi higi o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yugirigya lagagirik, it ap akwa ovok erogo yanggup yugeragagi ako, wagu lagagwama yugirigya dugwit, “Hit ovok erogo An nane henaruk hobaluk, des erogo ogagu dogwes o,” ");
INSERT INTO nbq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","yugirigya lagagirik, “Nelagwi menda andi vaga weyak okinivisigadek ovara, henendawima en weyak menda wenggelogo baluk wilisiga ako vaga weyak okinivisiga. ");
INSERT INTO nbq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Henaruk werek halok andi, des erogo at henaruk hunggu dogwes o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yugirigya lagagirik, ap akwa ako hekbisiluk, umwa nunggwigya lagagimu, At ane welagwi menda ako en, “Hat wene atok hwilagago heda yukneregen ako andi, des erogo yukneran o,” ");
INSERT INTO nbq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","yugu lagagwama, At Yesus en iri dugwit “Hit ogo henendawi obak dugwit, yuknisagwi? Yi menda ndi menda nelagwi menda ako henendawima nunggwisigadek. Ata, yi menda ndi menda nelagwi ako henagaum elola en wilisiga andi, henendawi weyak okinivisigadek, yi hegep?” yiluk, yugeragagi. (Wene yugeragagi andi, nelagwi menda ovok erogo moga dek yiluk yugeragagi.) ");
INSERT INTO nbq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yugirigya lagagirik, ambi yugirigya dugwit, “Henendawima en wenggelogo baluk wilisiga ako vaga weyak at okinivisiga. ");
INSERT INTO nbq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Henendawi weyak wenggenggwis; wanggis wugwi; henonggop wugwi; ap watwis; ");
INSERT INTO nbq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ap ogwa werekma inim hwa agun werekma inim ogagwi; ap enangge hogop-hogop umbutwi; yi weyak ndi weyak ogagwi; henane agil-amok vaga ap enendawi wugwi; henendawi hwa vaga adigat wenggelek dugwit, ugun-ugun ogarit lagwis; henendawi enaninis umbutwi; ap enavok mbangwis; an iya umbutwi; ap wes okidugwi; ");
INSERT INTO nbq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","andi menda henendawima en winggas ako vaga, ogarit nagu dugwit weyak okinivisiga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yugerelok, o andoma en lagya lagagirik, o ambi inis Tirus nonggagagi. Nonggagagirikmu, o ambiat valekma nonggagagi, akoma dugwit, “Ap akwa inil neyagusawen yiluk, hwilaklarisogon” imbitigi ovara, dek agagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Dek agya lagagimu, hwa ambi eyak hwavyak madis endawima nonggagagirikmu, Yesus wagagi ako aruk hobaluk, Yesus adema lagya lagagirik, avema seve yiluk ane yugugu dugwit, “Ai, Nasin o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Hwa ako en abwa edok erogo Yesus adema yugugu dugwit, “An neyak madis endawima nonggagagi andi, nggigilogo wibanogen yiluk, yukisiga,” yugogogi. At hwa ako eyave Yakuri menda dek. At Yunani menda ovara, o Penisia, propinsi Siria vaga endaklagagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yugugu lagagimu, At Yesus en it ap Yakuri enavok iri dugwit, “Avyak enagarom enendak enagaum erogo napwak yiluk iya erogo wogeraup o,” iri lagagirik, it ap weram menda enavok iri dugwit, “It avyak ako nenggetek inigik it enagarom ako harwogo it eneyangge wogeraup moga,” ");
INSERT INTO nbq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","yugugu lagagimu, at hwa ako en, “E o Nasin. Yo mbanggu ndalek vaga avyak enagarom nunggu dugwit enggen liso-liso wambisiga andi eneyangge at nelagwi o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yugugu lagagimu, Aren, “Harenen wene sek anderogo yegen vaga heyak madis endawima nonggagagi ako vage nggigilogo winggarikmu hamwa elak o.” ");
INSERT INTO nbq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yugugu lagagimu, hwa ako amwa lagya lagagirik eyak ako madis endawima nggigilogo winggigirikmu nggilik werekma il halagagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Andi okbagya lagagirik, At Yesus ako o Tirus hetbaluk, sup o Sidonggan en o Dekapolis andoma nunggwigya lagagirik is Galilea omban vaga nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Andoma nunggwigya lagagirikmu, it ap akwa andoma ako en, ap aruk nggulup ane dek ambi wolok At Yesus adema ba wagu lagagwarik, At Yesus en inggis ovaga vagarupwak yiluk, enabwa edok erogo dugwit, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yugugu lagagwama, it ap akwa ovok homago ako hetbisiluk, Yesus en at aruk nggulup ako wolok lagya lagagirik, aruk elola inggis mabagya lagagirik, waris inggi-vaga suvutbaluk abya vaga lombabagagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lombabagya lagagirik, elose mbogot vaga iligik dugwit, “Ai” imbitya dugwit, “Epata,” yugogogi. Yugogogi andi nit nenane vaga “Haruk hutlaru o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yugugu lagagimu, aruk hutlagya, ane dek ako ane werek agya, agya lagagirik, ane sek agagi. ");
INSERT INTO nbq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ane sek agya lagagimu, At Yesus en ap akwa andoma ako yugirigya dugwit, “Ap akwa mondok yugerabuk, moga!” yiluk yugeragagi ovara, hegek, ane sovabaluk, yugeregek adigat nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yugeregek nagwis ako enaruk hunggu lagagwarik, “Enaruk nggulup ako enaruk hurogo bugu, enane dek ako, enane werek erogo bugu, oginavit lagya dugwit, yi ogagek ndi ogagek sek adigat ogarit naliga yi, wii,” yiluk, enalon agu dugwit, vok yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Andi ogarit nagu lagagirik, werekma ap akwa iya erogo At adema homari wagagwa. Homari wagagwa ako, enagarom naup dek atma, At ane welagwi menda ako yanggup yugeragagi. Yanggup yugirigya lagagimu, wagu-selok, it ako yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“It ap akwa homago yi, ninim dugwit, ndugwis henggam erom nenggetek nogo yigao yi, enabwa o. ");
INSERT INTO nbq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","It nin enawi adumu en wagaorikmu, enamwa lakbugu neyalok, lagu dugwit, erom uvup en inuvuput basogon ombasiga.” ");
INSERT INTO nbq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yugirigya lagagimu, At ane welagwi menda ako en, “O yoma ap akwa dekma, erom nggomava wogeramwima it ndatak nasogon embeten?” ");
INSERT INTO nbq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yugugu lagagwama At Yesus en iri dugwit, “Hit roti werago maren vagago agipik?” Yugirigya lagagimu, “Dek. 7 at vagago agurik,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yugugu lagagwama, At Yesus ako en ap akwa iya erogo homago ako wema hora yupwak yiluk, yugirigya lagagirik, erom roti 7 inggimu dugwit, “Ala Nasin wa,” yiluk, erom ugurogo ap akwa sumburerapwak yiluk, At ane welagwi menda ako wogirigya lagagimu, sumbureragagwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sumbururugu dugwit, ikan mariduk mberen at werekma, “Ala Nasin wa,” yiluk samban ogagya lagagirik, “Ikan yi inim sumbureranes,” yiluk, wogeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wogirigya lagagimu, nunggu lagagwarik, enagaum agagi. Enagaum agya lagagimu, erom ugurik nin inim higirogo bagagwa ako mburin yum 7 hudi yedogo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","It nunggugwa ako ap eneyave 4,000 hudi nunggugwarikmu, enamwa lakbugu lagagarik, ");
INSERT INTO nbq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yesus At ane welagwi menda ako inim, mburis vaga nunggugu lagagwarik, o Dalamanuta lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","O Dalamanuta lagu lagagwama, it Parisi menda Yesus adema wagu lagagwarik, inim wene mbanggu dugwit, “Ninilup arup mbogot vaga menda ambi ogagya heyasogon o,” yiluk, At ogagya avut mbaluguluk yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yugugu lagagwama, At Yesus en, “Ai,” yiluk, yugirigya dugwit, “Hit ap akwa yi, nggarogo yiluk, ninilup arup mbogot vaga menda ambi ogagya heyasogon adigat yuknisagwi? Hinilup arup menda ambi ogagya neyasogon mondok dek o, An avyarat yukheraliga.” ");
INSERT INTO nbq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yugirigya lagagirik, it ako hetbisiluk, mburi-vaga nunggwigya lagagirik, is ambo elavikit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","It mburis vaga lagu dugwit, Yesus ane welagwi menda ako roti werago ako enunggut akluk, ambiat wolok lagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus en yugirigya dugwit, “Avyak wai. It ap Parisi menda inim, at Herodes inim, enane andi, ragi roti virisiga menda ako hak, henendawima nunggwigya hawen, henendawi hwalogo dogwes o,” yiluk, enaruk watigi. ");
INSERT INTO nbq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Enaruk watya dugwit yugeragagi ako, it wene mbanggu dugwit, “Nenagarom dek halok, yagas higi,” ");
INSERT INTO nbq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","it yugwi ako Yesus inugu lagagirik, “Hit nggarogo yiluk roti dek andi yagalagwi? An yukhirigi ako ao dibagatek henunggut dugwit, yagalagwi? Hit henendawi obak ugun dugwit, yagalagwi? ");
INSERT INTO nbq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Hit hinil werek ovara, hegetek dugwit, yagalagwi? Henaruk werek ovara, henaruk hunggitek dugwit, yagalagwi? Roti 5 vaga ap akwa 5000 homago ako ugurogo wogeragagis nogo, henendawi henunggut akluk, yagalagwi? Roti ugurik higirogo bagagwa ako, wonggalogo mburin yum maren yedogo bagagup? Yugirigya lagagimu, it ako, “Dek o. Mburin yum 12 hudi yedogo bagagup.” ");
INSERT INTO nbq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yugu lagagwama, “Hivis andi, it ap akwa 4,000 homago ako roti 7 ugurogo wokirigya lagagimu, ugurik higirogo bagao ako, hiren mburin yum maren yedogo bagep? Yugirigya lagagimu, it ako en, “Yum 7 at bagyo.” ");
INSERT INTO nbq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yugugu lagagwama, Aren yugirigya dugwit, “Yogak ogo hit henendawi An ao dibanenggetek agipik?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hivis, andi okbaluk, it ako o Besaida andoma wagagwa. Wagu lagagwama, it ap akwa andoma en ap il muk werekma At adema wolok wagu lagagwarik, At Yesus en at eyave inggis vagarupwak yiluk, enabwa edok erogo Yesus yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yugugu lagagwama, At Yesus ako en o kampung andoma en inggis vagakluk wolok, werama winggigi. Wunggu lagagirik, Yesus ako waris ap il vaga suvutbagya, eyave inggis vakbagya, okbagya lagagirik, “Yogak yi menda ndi menda vage hil hegen a dek a?” ");
INSERT INTO nbq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","yiluk, yugugu lagagimu, at il venggenlagya dugwit, “Ap akwa inisaliga ovara, yovagak nagu-siliga o,” yiluk yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iri lagagimu, At inggis il vaga lombabagya lagagimu, ap ako il yokigya dugwit, avyarat il venggenligya lagagirik, yi menda ndi menda ovok erogo selekma il hagagi. ");
INSERT INTO nbq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Il sek okbagya lagagirik, “O kampung andoma nunggubuk, hamwa elak,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus At ane welagwi menda inim o andoma en o Kaisareya-Pilipi o desa-desa kampung-kampung andoma nagu lagagwa. Suvaga lagu dugwit, Aren “It ap akwa yi An sa numbutu dugwit, yagalagwi?” yiluk, At ane welagwi menda ako yugirigya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","irenen yugu dugwit, “It nin en, Hat Yaya ap akwa ima wombabugu lagagi ako at yugwi, eke it nin en, Hat Eliya o endak erogo welagagi ako yugwi, eke, it nin en, ap ambi Ala wene yugurugu lagagwa menda navi-navi ako at, yugwi, yagalagwi o,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yugugu lagagwama, Aren it yugirigya dugwit, “Hiren, An sa numbutu dugwit, yagalagwi?” Yugirigya lagagimu, at Peterus en, “Dek. Ala en ap akwa enagap wendarumwak yiluk enogo lakba wagagi Keretus ako andi, Hat at,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yugugu lagagimu, “An navok andi ap akwa enadema mondok yugerabuk!” yiluk, enaruk watigi. ");
INSERT INTO nbq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Enaruk watya lagagirik, wene yugirigya dugwit, “An ap at endaklagagis ako, mondok nova anggin-mbanggin erogo banusogon. It ap ombok-ombok inim, it imam-imam enasini inim, it guru agama inim, An it enanggon numbutu dugwit natu dogomwima, hambigya dogomindik ndugwis mberen dukluk ndugwis ambi vaga niluk arisogon o,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","wene sigam erogo yugeragagi. Sigam erogo yugirigya lagagimu, at Peterus en Yesus inggis lirogo wolok lagya lagagirik, yugugu dugwit “Anderogo yubuk,” iri hegek ");
INSERT INTO nbq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","At Yesus en At ane welagwi menda ako il ambutmu dagalogo yogenugu lagagirik, Peterus mbet yugugu dugwit, “Hat Sile yi, Ala endawi ombasiga ako ndatak ombasigadek, ovara, ap akwa enendawi ombasagwi ndatak ombasigama, mondok-mondok wilin,” yiluk, mbet yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mbet yugugu lagagimu, it ap akwa homago ako inim, At ane welagwi menda ako inim, eneyanggup yugeragagi, ako, wagu lagagwama yugirigya dugwit, “Hit An ninim nagu dogop umbutu dugwit halok, yi menda ndi menda ogarup ombasagwi ako hetbisiluk, agyo winik lombalek ako hedelok, An ninim at nagu dogosogon. ");
INSERT INTO nbq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Heneyave idi okedasogon halok, heneyave yelemele yusogon. An ninis inim sek wene inim, ombok arupwak yiluk, heneyave idi dek okbetamwi halok, hinidi erek dogosogon. ");
INSERT INTO nbq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hit yi menda ndi menda ovok erogo hedugu dogomundik, heneyave yelemele yusogon halok, nggayoklarup embetep? ");
INSERT INTO nbq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Heneyave yelemele yusogon halok, aveloma nano betaup ombasagwi? ");
INSERT INTO nbq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","It ap akwa ovok erogo Ala mbo baluk, weyak adigat ogarit lendagwi ako enanggelekma dugwit, ap ambi sa en An ninis An nane inim, alon en yegetek dogosogon halok, An ap at endaklagagis yi An Nasin iris ovagangge yikedelok it malaikat mbogot vaga Ala ayonggo lakbisa wendagwi menda ako inim, wagu dugwit, An ap ako inis yisogonbuk o.” ");
INSERT INTO nbq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yugirigya lagagirik, “Dibas! Hit ap akwa yoma agipik ako, nin ao hambegetek hinigik At Ala anye iya atma, ap akwa At avema bisa wagya ako hinil hasogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nogo enam yikbaluk, At Yesus en it Peterus o, Yakobus Yaya inim, wogenombolok ndom adup vaga unggu lagagwarik, it enadik andoma werekma, inil vaga At elose adik agagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Elose adik agya lagagirik, asum mudu amumulip digavok ovagak ogagagi. It yum mudu amumulip arupwak yiluk, hurisagwi ako hak andi dek o. Mondok mudu amumulip agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","at Eliya o, Musa o, Yesus inim avuk agu lagagwarik, wene mbanggwis inogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Wene mbanggwis inugu lagagwarik, at Peterus ako en Yesus yugugu dugwit, “Nasin Guru wai! Nit yoma agurik yi sek atma, eravo henggam ambi Hat, ambi Musa, ambi Eliya at valogo bigigasogon,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","At ako, “Wii,” yiluk, enalon iya agya lagagimu, endawi apik agya dugwit nggarogo yubuk halok, anderogo yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yugugu lagagimu, hena hwilak inipu lagagirik, hena anggelekma akoma en ane iri dugwit, “An Nabut nendawi hunik yi atma, At ane henaruk hunggu dogwes o,” yiluk, iri hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Iri lagagimu, inil bigya baga erogo bikugu lagagwama, it mberen ako dek Yesus adigat inil hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ndom vaga akoma en wambu wagu dugwit, At Yesus en, “An ap at endaklagagis yi, hambuluk lendagwima akoma en ao iluk akluk mendok yegetek neyagek, ogagya hinil neyagep ako, ap akwa mondok yugerabuk.” ");
INSERT INTO nbq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yugirigya lagagimu ogagya hagagwa ako ap akwa yugeregetek ovara, enadik dugwit, “'An hambuluk lendagwima en niluk akluk mendok yisogon o’ yiluk, yukneraga ako, nggarogo yiluk yagas embetep?” yiluk, wene mbanggu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yesus yugugu dugwit, “It guru agama en, ‘Mesias ako ao wagatek hegek, Navi Eliya endak mbogot vaga en warisogon o’, yagalagwi ako, nggarogo yiluk warisogon yagalagwi?” yiluk, Yesus aigwakma wogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus en yugirigya dugwit, “Navi Eliya endak warisogon yagalagwi andi, yi ogagwi ndi ogagwi nggeraligiluk warisogon ovara, An ap at endaklagagis ako novaga anggin-mbanggin erogo banunggwi, weyak-weyak erogo banunggwi, ogarup dirup watugwa ako andi, nggarogo yiluk watugwa embetep?” ");
INSERT INTO nbq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Iri lagagirik, “At navi Eliya vage wagagi. Ninim hegek navi-navi o endak dirup watugwa ako ndatak ap akwa en it enendawi umbutu dugwit at weyak okbalin nagu lagagwa, An yukheraliga o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wene anderogo at yugeregek wambu wagusim, At ane welagwi menda nin bisiluk lagagwa ako inim, it guru agama inim, ap akwa iya erogo homago inigik, winimuk yugwi inil inogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Inil inugu lagagwama, it ap akwa ako, Yesus At wagya heyakbagu lagagwarik, “Wii,” yiluk enendawi adenggen umbutu dugwit, vupuk At adema “Wa” yugiri lagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus en “Hit ap yi hinim nano avok yagalagwi?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yugirigya lagagimu, ap akwa iya erogo homago welagagwa ako, ap ambi en At yugugu dugwit, “Nasin Guru wai! An nabut madis endawima nunggwigya lagagirik, ane dek ogagagirikmu, Hat hadema wolok wagi o. ");
INSERT INTO nbq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Madis endawima dugwit, eyave yagavet-yagavek ogagya, elagapma olan hauk-hauk iris, aik hambunggu ogagya dugwit, endawi anyedek agya dugwit, eyave habop ogagya, anderogo ogagya halok, Hat hane welagwi menda ako madis nggigilogo wibapwak yiluk, yugirigi ovara, iren wibaup meyan inigis o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yugugu lagagimu, At Yesus en, “Hit ap akwa yogak avyarat nembetetek agipikma, avyak! An hit hinim ndugwis maren dogop, eke An ndugwis maren hit hinim nendawi sagain erogo dogop?” yiluk, yugirigya lagagirik, “Avyak andi, wolok omanes,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yugirigya lagagimu, avyak ako At adema wolok wagu lagagwama, madis at endawima agarik ako en, Yesus il higya lagagirik, avyak ako inggis isok irup-wadok ogagya dugwit, legogo wen vaga wombabagya lagagirik, ena enden-vanden ogagya dugwit, elagapma olan hauk-hauk yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Anderogo ogagyaim, At Yesus en avyak asin ako yugugu dugwit, “Hat habut yi o mera hudi yerogo ogagya lagagi?” yiluk, yugugu lagagimu, asin ako en, “At madukma en, itok arerogo ogasiga. ");
INSERT INTO nbq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Madis ako ovaga agya dugwit, ndugwis ambi vaga hali hunikmu mabagya, ndugwis ambi vaga ima mabagya, ogasigama, Hat yi ogagek ndi ogagek ogasiga menda halok, nenabwa imbitya dugwit, okbininin o.” ");
INSERT INTO nbq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yugugu lagagimu, At Yesus ako en, “Hat nggarogo yiluk ‘Hat yi ogagek ndi ogagek ogasiga menda halok’ yuknigin? Avyarat umbutwi vaga yi menda ndi menda hogop ombasagwi ako andi atma asiga,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yugugu lagagimu, avyak asin ako en ane ombok vaga yugugu dugwit, “Avyarat imbiti ovara, nendawima en ambi im avyarat ombarigiluk okbanin o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yugugu lagagimu, andena en ap akwa wisane vupuk wagwi ako il inugu lagagirik, Yesus en madis ako mbet yugugu dugwit, “Madis enaruk nggulup enane dek oginivisiga menda yi wilitak! O baluk wilimi andi heyami vaga mondok nunggu warubuk!” ");
INSERT INTO nbq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","yiluk, mbet yugugu lagagimu, madis ako na iri lagagirik, avyak ako inggis isok irup-wadok ogagya lagagirik, winggigi. Wunggu hegek, avyak ako nggorak ovagak werekma, it ap akwa wisane akoma en yugu dugwit “Wii! Avyak yi nogo hombagas,” yagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","At Yesus en inggis vagago lekbagya lagagimu avyak ako mondok yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mondok iri lagagimu, At Yesus umwa nonggagagirik werekma, At ane welagwi menda wagu lagagwarik, enadik dugwit, “Nit nggarogo yiluk madis nggigilogo wibaup dek welagyo, embeten?” ");
INSERT INTO nbq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yugugu lagagwama, At Yesus en yugirigya dugwit, “Madis anderogo menda andi nano vaga wibaup erek ovara, samban ogagu dugwit halok, ndak wibaup,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","O andoma en hetbaluk, sup Galileanggan nonggagagwa. Nunggugu lagagwarik, At ane welagwi menda ako mamulirigya dugwit, “An ap at endaklagagis yi, Ala endawi imbitigirikmu neyave vagago ap akwa ininggimu agya neyalok, natu dogomundik, ndugwis henggam vaga niluk arisogon o,” yiluk, wene andi mamulirigyaim atma, At Galilea nonggagagi ako ap akwa inilup arup anggon imbitigi. ");
INSERT INTO nbq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yugeragagi ako dibagatek dugwit At aigwakma waup enalon en mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","O andoma en o Kapernaum lagagwa. Lagu lagagwarik, umwa dugwit, At Yesus en it yugirigya dugwit, “Hit suvaga wagu dugwit, nano wene yagan wagu hinigis?” yugirigya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","it suvaga wagu dugwit, “An iya, hat iya?” yagan wagagwarikmu, enane dek mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mbup yugu lagagwama, At ako hora yiluk, At aburi 12 menda ako yanggup yugeragagi. Wagu lagagwama, yugirigya dugwit, “Ap ambi sa en ‘an ap ombok dogosogon o’, imbitya halok, ap akwa ovok enavema dugwit, enayeloman at dogop.” ");
INSERT INTO nbq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yugirigya lagagirik, avyak ambi wolok it enanggelekma ba wakluk, elola okbagya lagagirik, it yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“At avyak yi hak, An ninis vaga wugu hiniselok, An at woknerasogon. An nadik woknerasogon dek ovara, An lakbani wagagi ako inim at welagwi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yugirigya lagagimu, at Yaya en iri dugwit, “Nasin Guru wai. Ap ambi nit ninim nagu lagatek ovara, aren Hat hinis vaga madis nggigilogo wibagya ninil hugu lagurik, ‘Moga’ yugugup,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yugugu lagagimu, At Yesus ako en, “‘Moga’ yugurubuk. An ninis vaga ogarubuk menda ogagu dugwit halok, andi okbaluk, weyak okbanusogonbuk. ");
INSERT INTO nbq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","It ninim ogorekdek halok andi, nit menda aro. ");
INSERT INTO nbq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","It ap akwa en, Keretus aburi at yiluk, is nudik wokerugu-selok andi, avyarat onggo andi hedasogon, avyarat yukhirigi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yugirigya lagagirik, “It ap akwa sa en avyak mariduk ambi endawi novaga vanggabaluk avyarat nombasagwi menda yi, weyak ogarumwak yiluk enendawi nomalogo yugerelagwi vaga, it avyak ako weyak ogagu-selok, ap ako avup vaga helep ombok yidibaluk is namut agurutmu wombabiselap en andi sek o. ");
INSERT INTO nbq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Hininggis vaga en weyak ogarup okinipu halok, venak mbalogo lakbas. Hininggis mberen hegek, hali munukmu nagaup yagaligadekma akoma nunggup andi weyak. Eke, mbalogo lakbaluk, venak mbalek hegek mondok iniluk agarwikmu andoma nunggup halok, sek o. ");
INSERT INTO nbq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Hinisok vaga en weyak ogarup okinipu halok, venak mbalogo lakbas. Hinisok mberen hegek, hali munukmu akoma mbo lakbigigaup andi weyak. Eke, mbalogo lakbaluk, venak mbalek sidakduk yagan mondok iniluk agarwikmu akoma nunggup halok, sek. ");
INSERT INTO nbq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Hinil vaga en weyak ogarup okinipu halok, venak hulirogo bas. Hinil mberen hegek, hali munukmu mbo lakbigigaup andi weyak. Eke, hinil ambi hurilogo okbaluk, venak vaga adigat Ala avema nunggup halok andi sek o. ");
INSERT INTO nbq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","O hali munukmu akoma ‘nggot enggen logovik-logovek adigat yagaligama, hali nagaup yagaligadekma’, lakbisaup dek o.” ");
INSERT INTO nbq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ikan vidis arugwi en yiluk, garam ilivuli erogo belagwi ako hak, anderogo at Ala en hali vaga walok hinisayogon o.” ");
INSERT INTO nbq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Garam sek ovara, edup dek agya halok, nggarogonggan en edup werek ogarup? Garam edup werek henendawima dugwit, hinim henendawi dambulik at dogwes o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yugirigya lagagirik, o andoma hekbaluk, sup o Yudeya vaga en is Yoredan mbalogo elavikit lagagi. Lagya lagagirik, ap akwa iya erogo At adema homari wagagwarikmu, At wene mamuleraliga ako wane-wane, mamuleragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mamulirigyaim, it ap Parisi menda ako At adema wagu lagagwarik, avut mbaluguluk yugugu dugwit, “Ap ambi ogwa wogoma nanggon o, yiluk, hetbaup andi sek embeten?” ");
INSERT INTO nbq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yugugu lagagwama, At Yesus en iri dugwit, “Musa en wene nggarogo yukheragagi?” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yugirigya lagagimu, it ako en yugugu dugwit, “At Musa en, ‘Surat watbaluk hwa andi hetbisaup sek o’, yiluk, yagagi o.” ");
INSERT INTO nbq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yugugu lagagwama, At Yesus en, “Henendawi lakot hiniselok, wene andi dirup warogo yukheragagi ovara, ");
INSERT INTO nbq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","‘At Ala en o endak yi menda ndi menda ogagya dugwit, ap ogagya, hwa ogagya’, ogagagirikmu, ");
INSERT INTO nbq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","andi halok ‘Ap en asin-isa hetbisiluk ogwa inim dambulakluk, ");
INSERT INTO nbq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","it eneyave mberen ovara ambiat arisogon o’, Ala wene warek atma, it eneyave mberen dek, ambiat dogosogon. ");
INSERT INTO nbq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Andi halok, At Ala en mondok mondok hondabigigirikmu, ap akwa en weralogo bisaup andi, mondok dek o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yugirigya lagagirik, umwa nunggwigya lagagimu, At ane welagwi menda ako en wene yugeragagi ako, ambi inim hemetugwa. ");
INSERT INTO nbq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hemetu lagagwama, Yesus en yugirigya dugwit, “Ap en ogwa hetbaluk, hwa adik ambi hedigya halok, ap en hwa endak ako alyak waliga. ");
INSERT INTO nbq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Eke, hwa en agun hetbaluk ap adik ambi hedigya halok andi, hwa en agun endak ako alyak waliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yugirigya lagagimu, avyak mariduk At adenggen enovaga bisapwak yiluk At adema woginiviluk wagu lagagwama, At ane welagwi menda en ap akwa ako mbet yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mbet yugerugu lagagwama, At Yesus en aninis wisane agya lagagirik, “Hit nggarogo yiluk yagalagwi! Hekbisines! Ala avema dogop andi, it avyak mariduk yi hakma, An nadema wagusim moga yugerabuk. ");
INSERT INTO nbq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Dibas! It avyak mariduk Ala avema dogopwak yiluk nunggwisagwi anderogo hak, hit anderogo nunggegetek hiniselok andi, nunggusogon dek o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Anderogo yiluk yugirigya lagagirik, avyak mariduk ako elola okbugu lagagirik, inggis vagupu dugwit, adenggen enovaga bogogi. ");
INSERT INTO nbq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Enovaga bugu lagagirik, sup ambi inim lagiluk ogagya lagagimu, ap ambi At adema vupuk wagya lagagirik, erambo yunggubaluk Yesus yugugu dugwit, “Guru. Hat sek adigat agindik yi, an niluk mondok mondok dogop menda andi nggarogo ogarik?” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yugugu lagagimu, At Yesus ako en, “Nano yiluk An sek adigat agirik yiluk yuknigin? Ap ambi sek adigat agarik andi dek, Ala adigat sek agarik,” yugugu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“At Ala en wene yagagi ako hat ovok hilup. ‘Ap warup moga. Ap ogwa werek hegek, hwa agun werek hegek, ogarup moga. Ap enangge enonggop waup moga. Henane huluk ap enovaga bisaup andi moga. Ap enangge nomalup moga. Henasin-hinisa enane henaruk hunggu dogwes o’, ");
INSERT INTO nbq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yugugu lagagimu, at ako en, “Dek o, Nasin Guru. Wene andi an madukma en des erogo ogagya lagagis,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yugugu lagagimu, At Yesus il vu erogo yokigya lagagirik, abwa imbitya dugwit, “Wene ambiat andi ao ogagetek heyagi. Hat hangge-hangge onggo hunogo it ap enangge dek menda ako wogerelak. Wogirigya heyalok, hat hangge eyave andi hivis mbogot vaga en ombok at hedayogon. Andi okbagya dogomindik, ninim nagu dogoguluk, omano,” ");
INSERT INTO nbq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","yugogogi menda, angge iya erogo werekma, endawi “Ai” imbitya lagagirik, endawi burup yagan lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Lagya hegek, At Yesus ako il ambutmu dagalogo, At ane welagwi menda ako yoginipu dugwit, “It ap ininggis werek menda ako, At Ala avema dogop andi nggarogo nunggup erek higi o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yugirigya lagagimu At ane welagwi menda ako en vok yugu lagagwama, At Yesus en yugirigya dugwit, “Naburi. At Ala avema dogop andi nggarogo nunggup erek higi o.” ");
INSERT INTO nbq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yugirigya lagagirik, “Wam ombok unta dirup yarum elo maduk andi ndak nunggup ovara, ap ininggis werek halok ako andi, Ala avema dogop, nggarogo nunggup erek higi,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus ane yagagi ako enaruk hunggu lagagwarik, vok yugu dugwit, “Andi halok, ap sa maren enagap wendarup embeten?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yugugu lagagwama, At Yesus ako en il yoginugu dugwit, “It ap akwa ogarup dek ovara, Ala andi yi menda ndi menda ogarup sek adigat agarik.” ");
INSERT INTO nbq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yugirigya lagagimu, at Peterus en iri dugwit, “Haruk hulu! Nita, yi menda ndi menda ovok erogo hetbaluk, wagyo, Hat hinim nagu dogoguluk,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yugugu lagagimu, At Yesus en, “An wene avyarat ambi yukherayogon o. An nabwa en sek wene ako ombok arupwak yiluk, henawi valek inim, henowa-henaot inim, henasin-hinisa inim, henaburi inim, heneyavup yago inim, ovok at hetbisiluk wagu hiniselok, ");
INSERT INTO nbq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yogak aveloma henawi valek inim, henowai-henarwi inim, hinisai inim, heneyavup ogarek inim, 100 hudi hedasogon, anderogo ovara, ap akwa en anggin henovaga bigigasogon, okbigigamima hivis andi hiniluk mondok menda hedasogon o,” ");
INSERT INTO nbq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","yugirigya lagagirik, “Ap iyarogo enendak lendagwi ako andi, hivis arusogon. Eke, hivis lendagwi ako andi, enendak arusogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus At ane welagwi menda ako inim o Yerusalem suvaga lagu dugwit, At Yesus endak lagyaim, it At eyaganggom ako enendawi anggin agya, it ap akwa nin enambetaga lagagwa ako enalon agya, agya lagagimu At Yesus en it ap 12 ako sup alilimu wogenombolok lagya lagagirik, At hivis nano arup wene ako at yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yugirigya dugwit, “Avyak. Nit ako vage Yerusalem dagasagwi atma, An ap at endaklagagis ako, it ap imam-imam enasini inim, it guru agama inim ininggimu asogon, ininggimu agya neyalok, wene mbabaluk, narupwak yiluk, it ap weram menda An wogerasogon. ");
INSERT INTO nbq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wogurugu dogomwima nanggadi watbanunggwi, enowaris novaga suvurogo banunggwi, nabirok natwis, okbaniluk, mondok narusogon. Natu dogomwima, ndugwis henggam vaga, niluk arisogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yugirigya lagagimu, at Sebedeyus aburi, Yakobus Yaya it mberen At Yesus adema wagu lagagwarik, “Guru wai. Nit nenendawi hobaluk, yukurusogon andi okbininanok yiluk, wagyo,” yiluk yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yugugu lagagwama, At Yesus en, “An nggarogo okbigigaigiluk wagep o?” ");
INSERT INTO nbq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yugirigya lagagimu, it ako en “Hat hivis hiris hovagangge yikedelok wagya heyalok, nit Hat hinggis venak-venak vaga hora okbininanok yiluk, yukhiri wagyo,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yugugu lagagwama, At Yesus en, “Hit yuknisagwi andi, henunggut dugwit yuknisagwima, An nagas nudik nayogon andi, hit hinim naup sek embetep? An anggin-mbanggin okbanusogon ako andi, hit hinim okbigigaup sek embetep?” ");
INSERT INTO nbq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yugirigya lagagimu it ako en, “E o. Ninim naup andi sek aro,” yugugu lagagwama At Yesus en iri dugwit, “An nagas nudik naup hit ninim naup at. Eke, An anggin-mbanggin okbanusogon andi, hit hinim okbigigaup ovara, ");
INSERT INTO nbq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ninggis venak-venak bigigaup ako andi, Anen yukherayogonbuk. An ninggis venak-venak hora okbisaup ako andi At Ala en yukheragwi,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yugirigya lagagimu it eneve 10 ako enaruk hunggu lagagwarik, it Yakobus Yaya mbet yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mbet yugeragagwa ovara, At Yesus en it ovok erogo yanggup yugeragagi, wagu lagagwama, yugirigya dugwit, “Hit hinilup, it ap weram menda enasini ako ap akwa sovabiselagwi, eke ap ombok ombok enavema akoma enane avuput vaga yugerelagwi, ");
INSERT INTO nbq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","45","ovara, hit andi anderogo ogarup moga. An ap at endaklagagis yi hiren An nake ogagu dogovovok en yiluk, wagatek. Anen henake ogagya dugwit, hit ap akwa ovok erogo heda visilogo bigigagiluk, neyave henonggo ba wagagirikmu, hit ap yi ambi ombok arup ombasagwi halok, enayeloman at arupwak o. Hit yi ambi en, ‘An nadik ombok dogosogon o’, imbitya halok, hit ovok henayeloman dogopwak o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","It ako o kota Yeriko ari lagagwa. Hivis, Yesus At eyaganggom inim, ap akwa wisane inim, o andoma en wunggusim ap ambi il muk ambenggino yagaliga menda suvaga horaik welagagi. Ap ako inis Batimeyus, at asin inis andi Timeyus. ");
INSERT INTO nbq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","At Yesus Nasaret menda wagya, aruk hunggu lagagirik, “Yesus wai. Daut ombao wagen yi, an nabwa nombaru,” yiluk, ane ombok erogo yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yugugu lagagimu, it ap akwa en “Mbup iru,” yiluk mbet yugu lagagwama, aren iri dugwit, “Daut ombao wai. Nabwa nombaru o,” yiluk, ane ombok vaga ambi inim yugigik adigat ogagya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","At Yesus ako mbup iri dugwit, “Eyanggup eres,” iri lagagimu, iren ap il muk ako eyanggup yugugu dugwit, “Heyanggup yukisigama, halon dek, mondok iru,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yugugu lagagwama, asum sogwes-yum menda nggolalogo hetbaluk, yiluk-wuluk mondok iri lagagirik, Yesus adema lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","At adema lagya lagagimu, At Yesus en, “An hat nggarogo okbanupwak yiluk, embeten?” Yugugu lagagimu, at il muk ako en, “Nasin guru, nil sek okbaninok yiluk, yigi,” yiluk ");
INSERT INTO nbq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","yugugu lagagimu, At Yesus en, “Hat hendawi avyarat nembeten ako vaga, hil sek agindikmu, hamwa elak.” Yugugu lagagimu, il muk welagagi ako sek agya lagagirik, At Yesus inim suvaga lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","At Yesus inim lagagwa ako o Yerusalem horok ari lagu dugwit nungguguluk o Betepage inim, Betaniya inim, ndom Saitun andi avema ari lagagwarik, andoma en At ane welagwi menda mberen lakbugu dugwit ");
INSERT INTO nbq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“O valekma akilisim ari lamwira, wam keledai eyak ap ao ovaga hora yegetek menda ambi hugu dogomundik, yunggwi yidugup akom veralogo wolok omano. ");
INSERT INTO nbq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eke it ap akwa andoma en, ‘Hit nggarogo yiluk wam keledai veralisagwi’, yukurugu-selok, hiren ‘Nit nenowa wam keledai dekma, welales o, yukneragamu, wolok lagu dogomundik, aveloma ba warusogon’, yiluk, yugerano,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yugirigya lagagimu, it ako lagu lagagwarik, wam keledai eyak o mbanggutmu sup alilimu yunggwi yidugup inil hugu lagagwarik, veranggu lagagwama ");
INSERT INTO nbq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","it ap andenam un mendek werekma, “Hit wam keledai eyak nggayok ogaruguluk veralisagwi?” yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yugu lagagwama, it ako en At Yesus en anderogo yugerano yugeragagi ako at yugurugu lagagwama, iren “E o,” yiluk yugu lagagwama, wolok lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wam keledai ako wolok Yesus adema lagu lagagwarik, it ako enasum nggolalogo wam keledai ambot vaga ndabagu lagagwama, Yesus ako andi vaga hora yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hora iri lagagimu, it ap akwa iya erogo enasum mbigalogo sup ombok vaga ndalit lagwi, it nin en yo angga yavup wadimu en mbalogo ndalit lagwi, okbaluk, ");
INSERT INTO nbq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","At ako lagya hegek, it nin enendak lagwi, nin ambetaga lagwi, ogarit lagu dugwit, “Hosana!” “Nenasin inis ombok en, At lakba wandiga yi, inis siyabasogon o!” ");
INSERT INTO nbq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Nenombao Daut avema sek welagagup ako wane-wane At avema bininagiluk wandigama, inis siyabasogon o.” “Ala o mbogot vaga agarik ako, wa, wa, hosana,” yiluk, amikmit yagan lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Amikmit yagan o Yerusalem nunggu lagagwarik, o Ala awi valekma nonggagagwa. Nunggugu lagagwarik, At Yesus ako yi menda ndi menda yenaga wegek nagu hegek, o hup agya halok it ap 12 menda ako inim, eneyami vaga o Betaniya lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nogo yikbaluk hutun o Betaniya en suvaga lagu dugwit, Yesus erom uvup ogagagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ogagya lagagimu, andenam en yo ara ambi angga savulik il higya lagagirik, yo ako enggen yugup a, dek a, yiluk adema At lagya lagagirik, enggen yup yiligama ao ari wagatek atma, angga adigat hagagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Angga adigat halok, yo eyave ako yugugu dugwit, “Yogak yi hudi en, hat henggen ap akwa ambi nunggu dogosogon mondok dek o,” yugugu At ane welagwi menda ako, enaruk hunggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","At Yesus ane welagwi menda inim o Yerusalem ari lagu lagagwarik, Ala awi valekma nunggwigya lagagirik, it Ala awi valekma yi menda ndi menda onggo hunggik yagalagwi menda akoma, silogo wibugu dugwit, it yoparip onggo-onggo ogagu lagagwa menda ako, yo ndalek inim, it swa suwa onggo hunggu lagagwa menda, yo hora yugu lagagwa menda inim, avut enden-vanden erogo mbombo hagagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mbombo higya lagagirik, “Hit Ala awi valekma yi, yi menda ndi menda wolok nunggugwi, wunggwis ogarubuk o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yugirigya lagagirik, wene mamulirigya dugwit, “An nawi valek yi, yi ap ndi ap ininis unggul adik-adik menda en ‘Samban ogasagwima yi at’ yugu dogosogon o,” yiluk dirup warek ako dek embetep? Dirup warek ovara, hit andi, ‘o yi ap enonggop wokbaluk, hwilaklari lendagwima ovagak' ogagep o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yugirigya lagagimu, it ap akwa ovok homago ako Yesus wene mamulirigya ako vok yugu-selok, it imam-imam enasini inim, it guru agama inim, Yesus yagagi ako enaruk hunggu lagagwarik, enalon agya dugwit, “Nggarogo heda okbaluk warup embetep,” yiluk, avok mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Andenam en, o howam agya halok, Yesus At ane welagwi menda inim, o Yerusalem en wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wunggu lagagwarik, nogo yiluk, hutun suvaga lagu dugwit, yo ara ako omanggen inim eyave inim ovok erogo mbuk agagi inil hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Inil hugu lagagwarik, Peterus en yo yugugu hagagi ako, endawi wenggeligya dugwit, “Nasin Guru wai. Yo ara vudilogo bagen ako ovok mbuk aga yi, hil yokanen.” ");
INSERT INTO nbq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yugugu lagagimu, At Yesus en iri dugwit, “Henendawi Ala ovaga vanggabaluk, avyarat umbutu dogwes o. ");
INSERT INTO nbq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Henendawi yunggup yegetek, henane yugwi, ndatak arisogon umbutu dugwit, ‘Ndom ombok yi legogo is namutmu nunggwilak’ yugu hiniselok, anderogo at okligya hasogon o, yiluk, avyarat yukhirigi o. ");
INSERT INTO nbq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Andi halok, hit samban ogagu dugwit, yi menda ndi menda Ala nggino yugugu dugwit, vage hedigi o, yiluk, avyarat ombasagwi andi vaga wokirigya hasogon o. ");
INSERT INTO nbq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Hit mendek yiluk, samban ogagu dugwit ap ambi inim ogorek agipik halok, henasin mbogot vaga agarik ako en, hit weyak menda dek erogo bigigapwak yiluk, at inim ogorek agipik ako weyak menda andi hiren henunggut akluk dogwes o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Andi en, o Yerusalem nunggugu lagagwarik, At Yesus ako Ala awi valekma nunggwigya lagagirik, naguim, it imam-imam enasini inim, guru agama inim, it ap ombok-ombok inim, At adema wagu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Hat yi ogagek ndi ogagek ogasiga ako sa inis vaga ogasiga? Sa en yukigamu ogasiga?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yugugu lagagwama, At Yesus en iri dugwit, “Anen ambi hemekinisayogon. Onggo yuknugu hiniselok andi, sa inis vaga ogasiga ako yukherayogon.” ");
INSERT INTO nbq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yugirigya lagagirik, “At Yaya ima wombabugu lagagi andi, mbogot vaga en yugogogi vaga wombabugu lagagi a, ata ap en yugogogwa vaga wombabugu lagagi a? Hit yukneres!” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yugeragagi ako, wene mbanggu dugwit, “Niren ‘Mbogot vaga en yugogogi vaga ogagagi o’, yugu niselok, Aren ‘Nggarogo yiluk at avyarat embetetek welagagup’, yuknerayogon. ");
INSERT INTO nbq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","33","Eke, niren ‘Yaya andi ap akwa en yugogogwa vaga ogagagi o’, yup andi nggarogo yup erek,” umbutu lagagwarik Yesus yugugu dugwit “Nit nenunggut o,” yugogogwa. It ‘Nggarogo yup erek’ umbutugwa andi it ap akwa ovok erogo en Yaya andi navi Ala wene yugeraliga menda avyarat umbutugwa atma, enalon wisane welagagwa. Yugugu lagagwama, Yesus en “Andi halok, An ogo sa inis vaga ogasiga ako yukherayogonbuk,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yugirigya lagagirik, it imam-imam enasini inim, guru-guru agama inim, it ap ombok-ombok inim Yesus en wene il wakhegek yugeragagi. Yugirigya dugwit, “Ap ambi en anggur awi yakbaluk, leget wigya, owangga mbetalogo yanggatlarumenda walup mendagya, eke, suwam watu dogopwak yiluk, mbeda leyanggya, okbagya lagagirik, at eyavup yagoma ap malogo dogomwak yiluk bisiluk, o adumu andoma lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lagya lagagirik, andoma dugwit, anggur enggen yugup ako mbalup agya lagagimu, at eyavup ogasagwi menda ambi angge enggen mbalogo wogurupwak yiluk, it at eyavup ogarekma malogo welagagwarikmu akoma lakba wagagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lakba wagagi ako wagya lagagimu, it at eyavup malogo welagagwa ako en vakbaluk, yo yawi vaga wakbagu lagagwarik, enggen wogigitek at eyami vaga lakbagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Warogo lakbagu lagagwama, hivis aveloma ap ambi enadema lakba wagagi. Lakba wagya lagagimu, it ako en yo yawi vaga unggul nggagalogo wakbagu lagagwarik, anggadi watugwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Anggadi wakbagu lagagwama, ambetaga ambi lakba wagagi. Wagya lagagimu, mondok watu lagagwama, andi okbaluk, iya erogo lakbisa wagagirikmu, it akoma en nin un yo yawi vaga initwis, nin mondok initwis ogarit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ovok initu lagagwama, abut ambi at endawi hunik ako lakbagatek, it mberen welagagwarik, ‘An nabut yi, agayuk wutu dugwit, ‘Wa’ yugugu dugwit wasogon higi o’, yiluk, enadema lakba wagagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lakbagagi wagya lagagimu, it at eyavup yago malogo welagagwa ako en wene mbanggu dugwit, ‘Mavorangge hedaup ako at abut yi atma, mavorangge nit hedaugen mondok warusogon o’, yiluk yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yugu lagagwarik, eyave vakbaluk, watu lagagwarik, wolok anggur yavup ogarekma awakma weram andoma at ba wunggugugwa,” yiluk, wene andi At Yesus en wakhegek yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yugirigya lagagirik, “At anggur yago andok ako en nggarogo oginivisogon embetep? Dek o. Lagya dogomindik, yavup malogo welagagwa ako enarogo bisiluk, enaveloma ap adik menda malogo dogomwak yiluk, mondok bisayogon o. ");
INSERT INTO nbq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Ala wene yi, ‘It helep o valisagwi menda ako o vanggu dugwit, helep ambi hetbagagwa ako andi, mondok-mondok owanggi ndalaga o. At Nenasin inis ombok ogagagi ako ninil hugu lagagurik, ‘Wii!’ yiluk, vok yagalagwi o’, yiluk, Ala wene dirup warek ako hinil yokegetek dugwit, yagalagwi?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yugirigya lagagimu, it ako en, “Wene wakhegek yi nit niniselok, yagaliga yi,” yiluk, yedok hugu lagagwarik, vagaruguluk ogagagwa ovara, ap akwa wisane iniselok, enalon en hetbaluk lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hekbaluk, lagu lagagwarik, it Parisi menda nin inim, it Herodes menda nin inim, Yesus ane yupum-ndupum iri halok ovaga yidilogo baguluk lakbogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Lakbogogwa ako, At Yesus adema wagu lagagwarik, “Guru wai. Hat andi avyarat adigat ogasiga menda atma, Haren ap enelosema dombabigitek, ambi sek ambi weyak embetetek dugwit, Ala wene avyarat des erogo yugirigya heyagyo. Ap inis ombok Pemerintah Kaisar andi ake baup sek a weyak a? Hekbaup sek a, weyak a? Haren yukneran!” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yugugu lagagwama, it enendawi lakot dugwit, yugwi ako yedok inugu lagagirik, “Hit nggarogo yiluk, heda magago banilagwi? Yoparip mbusi ambi An nil hagiluk, wokneres.” ");
INSERT INTO nbq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yugirigya lagagimu, wogogogwa. Wogugu lagagwama, At ako en “Yi sa elese ovagak helagwi? Sa inis dirup warek helagwi?” Yugirigya lagagimu, it ako en, “Dek o. Andi Kaisar aro,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yugugu lagagwama At Yesus ako en, “Andi halok, Kaisar angge halok andi, Kaisar at wogugwis, eke, Ala angge halok andi Ala at wogugwis, ogagu dogwes o,” yiluk, yugirigya lagagimu, it ako en “Wii” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Vok yugu lagagwama, it Saduki menda ako, it ap akwa hambuluk, iniluk akluk mendok yusogon dek yagalagwi menda ako en Yesus adema lagu lagagwarik, hemetu dugwit, ");
INSERT INTO nbq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Guru wai. At Musa en dirup watya dugwit, ‘Ap ambi hwa wokbaluk abut endagetek dugwit hambigya halok, at owa aveloma, aburi endarupwak yiluk, aot at hedaup o’, yiluk, dirup watigirikmu, ");
INSERT INTO nbq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ap ambi aburi eneyave 7 endaginipigirikmu, at manggum ako hwa ambi wigya lagagirik, abut endagetek dugwit, hombagagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hambigya lagagimu, at aot ambetaga menda en hwa ako wigya lagagirik abut endagetek dugwit hombagagi, hambigya lagagimu, at aot ambetaga menda ambi wogogi ako, anderogo at endagetek dugwit hombagagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","It eneyave 7 ako enaburi endaginipitek dugwit adigat hombagagwarikmu, at hwa ako eyave hivis hombagagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","It ap eneyave 7 ako hwa ako wugwi, hambugwi, adigat ogagu lagagwarikmu, ap akwa hambuluk iniluk erogo mendok okbisaup hudi vaga, hivis ap sa ogwa arisogon embeten?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yugugu lagagwama, At Yesus en, “Hit Ala wene warek inim, At Ala avuput inim, dibagetek dugwit, wene andi adigat umbutu dugwit yagalagwi? ");
INSERT INTO nbq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hivis ap akwa hambuluk lendagwima en iniluk erogo mendok okbugu vaga, ap en hwa hedugwi hwa en ap hedugwi ogagu dogogubuk. It mbogot vaga yonggo nelagwi menda malaikat ako hak at dogogup o. ");
INSERT INTO nbq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Eke, it ap akwa hombagagwa ako iniluk erogo mendok okbisayogon ako andi, mbuku Musa wene mbalek yo aik werek adema hali abya hagagi wene ako vaga Ala en Musa yugugu dugwit, ‘Hat hombawi endak hombagagwa ako, Averaham inim, Isak inim, Yakup inim enasin inis ombok Ala An aro’, yagagi dirup watigi ako yokegetek agipik a? ");
INSERT INTO nbq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","It Averaham inim, Isak inim, Yakup inim, hambuluk dek aklipmu en, Ala en ‘It enasin inis ombok Ala An aro’, yilipuk. At Ala andi it ap hambuluk dek agagi menda enasin dek o, ata, it ap hambuluk iniluk agarwik menda enasin inis ombok At aro, yiluk, hit henendawi apik hinisaliga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yugirigyama, ap guru agama ambi enadema wagagi. Wagya lagagirik, it wene mbanggwis aruk hobaluk, At Yesus en wene onggo sek erogo yugirigya il higya lagagirik, “Yesus wai. Ala wene yerogo ogarup, nderogo ogarup avok wene ovok dambulik yukneragagi ako wene adem ombok ngga haliga?” yiluk, hemetigi. ");
INSERT INTO nbq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Hemetigya lagagimu, At Yesus en yugugu dugwit, “Wene adem ombok ako yi o, ‘Hit ap Iserali yi, henaruk sek erogo hunggu dogwes o. Nenasin inis ombok Ala andi, Ala adigat At agarik. ");
INSERT INTO nbq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Heneyave henanye inim, henendawi henanggela inim, ovok at henasin Ala adigat henendawi hunik ogagu dogwes o.’ Wene adem ombok ako andi, andi aro. ");
INSERT INTO nbq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Eke, wene aswe ambetaga andi, ‘Hit heneyave henendawi hunik okedelagwi ako hak, it hinim agipik ako anderogo at henendawi hunik oginipu dogwes o’, yiluk, wene mberen yagagi yi nin ambi iya heda agarik dek o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yugugu lagagimu, at guru agama ako en, “E o Guru. Sek at yegen o. Ala adigat agarik. Ala adik ambi mondok dek. ");
INSERT INTO nbq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Eke, neneyave nenanye inim, nenendawi nenanggela inim, ovok at nenasin adigat nenendawi hunik dogop o. Neneyave nenendawi hunik okedelagwi andi hak, ninim agurik ako anderogo at nenendawi hunik oginipu dogop andi, mondok ombok o. Ala anggom warogo hali ovok napwak yiluk, hali hunbagwi, Ala ake bagwi, ovok erogo ogasagwi andi, maduk atma, Hat yegen andi avyarat,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yugugu lagagimu, At Yesus en ap ako endawi werek en iri higya lagagirik, “Hat heyave Ala avema vanggabetaliga higi o,” yugugu lagagimu, it ovok ako en, ambi inim At hemetaup enugut agagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","At Yesus ako Ala awi valekma andoma en Ala wene ambi inim mamulirigya dugwit, “It guru agama ako en ‘At Ala en enogo lakba wagagi Keretus ako andi, Daut ombao’, yagalagwi andi, nggarogo yiluk yagalagwi ombasagwi?” yiluk, ");
INSERT INTO nbq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“O endak, at Daut en At Averiniki endawima en iri dugwit, ‘At nenasin inis ombok en an nasin inis ombok yugugu dugwit, It hinim ndup ogorek agindik menda, An sovalogo havema bigitek neyagek, ninggis amot vikit dogenyok yiluk, oma’, yiluk, at Daut en yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","At Daut ako en, At Keretus ako ‘An nasin inis ombok’ yagagi ako, nggarogo yiluk irenen At Keretus ako ‘at ombao adigat’ yagalagwi embetep?” yiluk, yugeragagi. It ap akwa wisane homago adema ako en wene iris ako enendawi sek umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Enendawi sek umbutwi werekma, mamulirigya dugwit, “It guru agama ako henambutmu unggusawen, hit henendawi suwam watu dogwes o. Enasum adup segedok yikbetaluk, ap akwa vasat ogasagwima andoma en vok yuknerapwak yiluk nagwis, ");
INSERT INTO nbq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","it Yakuri samban ogasagwima akoma ap ombok-ombok hora yagalagwima hora yugwi, isogo isugu dugwit, ap ombok-ombok hora yagalagwima hora yugwi, ogarup adigat enendawi sek ombasagwi. ");
INSERT INTO nbq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","It ap andi, akwa sogwa enangge ovok erogo wugwi, ap akwa sek enombarupwak yiluk, samban adup at ogagwi, ogasagwi andi vaga anggin mondok ombok at oginivisogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yugirigya lagagirik At Yesus Ala ake yoparip belagwima akoma horaik dugwit ap akwa wisane yoparip belagwima, ba wagwi il enegegi. It ap ininggis werek menda yoparip wisane bagu-sigik ");
INSERT INTO nbq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","hwa sogwa ambi inggis dek menda yoparip enggen maduk mberen Ala ake belagwima bagya hagagi. Ako andi seratus angga ndatak ovagak bagagi. ");
INSERT INTO nbq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Bagya il higya lagagirik Yesus At eyaganggom “Omanes” yugirigya lagagirik, wagu lagagwama yugirigya dugwit, “Dibas! It ap akwa enangge wisane hegek ba wagao ovara, hwa sogwa inggis dek menda yi, at agarom hunogo naup dek hegek ovok erogo betagarikmu, it ap akwa ininggis werek menda un horok maduk at bagao ovara, at hwa sogwa angge dek dugwit ba waga yi verak eve ombok at bagas o,” yiluk yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","At Yesus Ala awi valekma akoma en wunggwiam, At ane welagwi menda ambi en, “Guru wai. Helep ombok inim, o valek inim, mondok sek yi hil okanen, wii,” yiluk, vok yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Vok iri lagagimu, At Yesus ako en iri dugwit, “O helep vaga valek yi iya helagwi ovara, helep ovaga dambuk ogarek iligik andi ambiat ogo dogosogonbuk. Ovok erogo masalasogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yugirigya lagagirik, hivis, Yesus ndom Saitun vaga hora iri lagagirik, Ala awi valek amokmot werekma, it Peterus Yakobus inim, Yaya Andreas inim, enadikmu en hemetu dugwit, ");
INSERT INTO nbq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Hat yukneregen ako, o mera oklarimi? Anderogo ogarup yukneregen ako, horok ari wagya hegek, nit nenendawi dibamunda, eyave ngga menda ogarumwi yukneran o,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yugugu lagagwama At Yesus ako en, “Ap akwa nomalhinipusawen, henendawi suwam watu dogwes. ");
INSERT INTO nbq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","It ap akwa wisane An ninis vaga, ‘Keretus ako an arat o’, yiluk, ap akwa wisane enendawi nomalinivusogon. ");
INSERT INTO nbq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ndup nggaganggwis, ndup sumbutwis ovok henaruk hulumwi ovara, henendawi dek arubuk o. Andi avyarat oklarisogon ovara, ‘E ako vage horok ari wandiga’, yiluk avyarat ombarubuk. ");
INSERT INTO nbq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yi ap ndi ap ininis unggul adik-adik ndup sumbutwis, o negara adik-adik ndup sumbutwis, o nggoma-nggoma o wadok iris, erom uvup agya, andi ogarisogon andi, akwa avyak baguluk yavul wasagwi wane-wane aro. ");
INSERT INTO nbq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Wene owak dilisagwima enadema wokenombolok lagwi, it ap Yakuri samban ogasagwima en yawi hinitwis, it ap ombok inim, it ap ininis ombok inim, An ogagagis ako inil vaga vagalogo yugeravovok yiluk, wokenombolok enadoma bigiga lasogonma, henendawi suwam wakedugu dogwes. ");
INSERT INTO nbq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","O hivis ogarup ao hegek, sek wene yi endak akwa ap ininis unggul digosek yugeregek lagu dogop. ");
INSERT INTO nbq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wene owak dilisagwima wokenombolok lagu-selok, wene ngga yup henendawi anggin arubuk. Hit henadik henendawi hobaluk yugeragupuk. Ata andi hudi At Averiniki en yukhirigya hegek yugeragup. ");
INSERT INTO nbq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aswe en aswe at warupwak yiluk, vagago wogirigya, asin en abut warumwak yiluk vagago wogirigya, eke enaburi en enasin-inisa inim ogotbaluk inirupwak yiluk, wogurugwi, ogarusogon o. ");
INSERT INTO nbq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","An ninis hit avyarat wegep vaga it ap akwa ovok erogo enanggon henombarusogon ovara, o hivis vaga henendawi wadok dek okbaluk, dogomwi halok henagap wendakinivisogon o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Hit Ala wene dirup warek yi yokelagwi menda andi, henendawi dibagu dogwes! Yesus en iri dugwit “'Alon werek adik menda weyak adigat okbisaliga menda' o mogama mendek hinil hugu dugwit, ‘Wii’ yiluk, it Yudeya menda ndom vaga andoma hoda wunggu dogomwak. ");
INSERT INTO nbq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Eke hoda wunggu dugwit enangge enangge umwa heda nunggubuk.” ");
INSERT INTO nbq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","“It yavupmu agarwik ako, eneyami vaga enasum enamwa heda labuk. ");
INSERT INTO nbq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","O andi vaga akwa enavula inim, eneyagi ao idyak wogerelagwi inim, nggarogo vupuk labuk atma, enabwa o! ");
INSERT INTO nbq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","O musu hunik ninggyaim, ogagya hawen samban ogagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","At Ala en yi menda ndi menda bagagi hudi en yogak yi hudi ap akwa enovaga anggin-mbanggin okbugu lagagwa ovara, andi horok at okbugu lagagwa. Yogak ogo maduk at okbiselagwi ovara, o andi vaga enovaga anggin-mbanggin adik mondok iya erogo okbugu hasogon. ");
INSERT INTO nbq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","O andi vaga Ala en anggin-mbanggin ako dek erogo balipuk en ap enagap mondok wendaklaklipuk ovara, ap akwa mikbaluk enogo bogogi ako enake hudi bayogon.” ");
INSERT INTO nbq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yugirigya lagagirik, “O andi vaga ap ambi en ‘Yokanes, Keretus ako yoma agarik’, eke, ap ambi en ‘Yokanes, Keretus ako andi ilumu agarik’, yukirugu-selok, henendawi avyarat ombarubuk. ");
INSERT INTO nbq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","It huluk wene yukurugu dugwit, ‘An Keretus aro’, eke, ‘An navi Ala wene yukheraliga menda aro’, yiluk, yagan wagu dogomundik, ap akwa Ala aburi enogo bogogi ako nomalhinivuguluk, enalon werek menda inim, ogarubuk menda inim, ogarusogon ovara, dek. ");
INSERT INTO nbq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Andi halok, henendawi suwam watu dogwes. Ogarup ako ao ogagetek hegek, wene endak ovok erogo vagalogo yukhirigi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yugirigya lagagirik, “O andi vaga anggin-mbanggin ako okbaluk, ‘Mo il hwis iris, saut abya dek agya, ");
INSERT INTO nbq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","dadiwap mbogot vaga en wema wambu wagya, mbogot vaga enanye werek menda ako wadok-wadok iris, ogarugwi o’, ");
INSERT INTO nbq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ogagya hegek An ap at endaklagagis ako niris novagangge yikedelok, nagayuk werek dugwit, hena anggelekma wambu wagya neyagup. ");
INSERT INTO nbq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wagya dogogurik, it malaikat mbogot vaga yonggo nelagwi menda ako o adem venak-venak lakbugu dogogurik, it Ala en enogo bogogi ako o atok-atok andoma en wonggalogo bisaguluk warugup o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yugirigya lagagirik, “Yo ara anggup savuligiluk ogasiga ako wene henendawi dibas. Anggup savunggya lagarik, angga savuligiluk ogagya halok, o adem o hivi bagiluk ogasiga o, yagalagwi ako hak, ");
INSERT INTO nbq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","‘anderogo ogarugwi o’, yiluk, yukhirigi ako ogagya hinil hugu dogogupik, horok vanggo yagas higi o, yiluk, ombarugup.” ");
INSERT INTO nbq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Hit yogak agipik ako, ao dek agatek hinigik hivis ogarup avok yukhirigi ako, ovok erogo atma agya hagup o, yiluk, avyarat yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mbogot inim, wen inim andi, dek arugwi ovara, An nane andi mondok-mondok dek arisogon dek o,” yiluk yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yugirigya lagagirik, “An ap at endaklagagis ako o ngga vaga warup inim, mo il ngga vaga warup inim, ap akwa ovok enunggut. It mbogot vaga nelagwi menda ogo enunggut. Eke, An Ala abut ogo nunggut at agirik. Ilup andi, An Nasin Ala adigat agarik,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yugirigya lagagirik, “O mera hudi oklarup andi hit henunggut atma, henendawi dibagu dugwit suwam watu dogwes o. ");
INSERT INTO nbq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ap ambi o adumu lagiluk, ogagya dugwit at ayeloman o malogo dogopwak yiluk, yavup adik-adik ogagu dogopwak yiluk vulogo bugu, at sup mbanggutmu dogopwak yiluk, yugugu, ogarogo bisiluk wilisiga ako hak, ");
INSERT INTO nbq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","at awi werek ako howam warimi a, hup agako warimi a, o yanggok swa ane irisim warimi a, mo nggao irisim warimi a, o andi vaga warisogon henunggut atma, henendawi anggin vaga dugwit suwam watu dogwes. ");
INSERT INTO nbq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","At warisogon ako hit ambi ugun nogo yugusim supuk erogo wagya hawen, henendawi dibaluk, suwam watu dogwes, ");
INSERT INTO nbq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","yiluk, An wene henendawi suwam watu dogop yukhirigi yi, ap akwa ovok erogo yugeraliga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Isogo ambi inis Pasika inim, isogo ambi inis ‘Erom roti virisigadek menda’ ako inim, adenggen isagu lagagwa hudi vage ndugwis mberen dukluk isaruguluk ogagusim, it imam-imam enasini inim, it guru-guru agama inim en, “At Yesus nggarogo hilagago at vakbaluk, warumwi?” yiluk, avok mbanggu dugwit, ");
INSERT INTO nbq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Ap akwa war-wat yugwi inisao, isogo isagwi vaga vagarup andi dek,” yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","At Yesus o Betaniya ap ambi inis Simon o endak amu wisane hunik welagagi amwa hora yiluk, erom ninggyama, hwa ambi amburup inis narwastu amben sek onggo ombok menda iwak helep menda vaga nudik wolok nunggu wagagi. Nunggu wagya lagagirik, iwak ako atok hedalogo “Wa” yiluk amburup Yesus unggul vaga ndibagagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Unggul vaga ndibagya lagagimu, it ap akwa nin en yugu dugwit, “Yo amburup nggarogo enam warogo ndibagas embetep? Amburup iwak yi ako andi onggo ombok yoparip 300 denari vaga onggo hunogo it ininggis dek menda wogeraup sek ovara, ogaga yi hinil yokanes,” yiluk, enaninis en hwa ako mbet yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mbet yugugu lagagwama, At Yesus ako en “Mondok sek oknetarikmu, nggarogo yiluk mbet yugisagwi? Hekbas! ");
INSERT INTO nbq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","It ap ininggis dek menda andi, hinim mondok mondok dogosogonma, yi menda ndi menda wogeraup umbutu hiniselok, wogeraup sek ovara, An andi, hit ninim mondok dogosogon dek. ");
INSERT INTO nbq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hwa yi An okneraup atma, oknetas higi o. An kubur okbanup horok vanggalek atma novaga amburup ndibenanggas. ");
INSERT INTO nbq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Hivis sek wene wolok yi awi ndi awi yugeregek lagu dugwit hwa yi oknetas ako enendawi wenggelek dogomwak yiluk yugeregek nagu dogosogon o, yiluk avyarat yukheraliga o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yugirigya lagagimu, Yesus ane welagwi menda 12 ako ambi inis Yudas Ikariot ako Yesus warupwak yiluk wogerayogon imbitya lagagirik it imam-imam enasini Yesus wogeragiluk enadema lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Enadema lagya lagagirik, yugirigya lagagimu, it ako enendawi adenggen umbutu lagagwarik, “Onggo wokurusogon o,” yiluk, yugugu lagagwama, “O ngga hudi selekma agya halok wokerayogon?” yiluk, sok higya lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Adenggen ‘Erom roti virisigadek menda’ ako ogagusim, ndugwis endak vaga wam ndomba warogo isogo Pasika isagu-sigik, Yesus eyaganggom ako en, “Yesus wai. Hadenggen wam ndomba warogo Pasika vipuk-vapuk okbaluk, nggoma isagago belamwi embeten?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yugugu lagagwama, At eyaganggom mberen lakbugu dugwit, “Hit o kota andoma nunggugu dogomundik, ap ambi sogolowak is nudik wolok lagya hinim avuk agu dogomundik, hinim at elalo o. ");
INSERT INTO nbq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Umwa andoma nunggwigya halok, ap awi werek ako yugugu dugwit, “At nenasin Guru en, ‘An nane welagwi menda ninim isogo Pasika naguluk, o hamat nggoma vokot benanggao o’, yiluk, yagas,” yugurup. ");
INSERT INTO nbq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yugugu hiniselok, at ako en o handimen hamat ombok ogorek ovok vipuk werek, yukhirigya halok, andoma at isagago ba elalo o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yugirigya lagagimu, At ane welagwi menda ap mberen ako, lagu lagagwarik, o kota andoma nunggugu lagagwarik, yugeragagi ako ndatak at inil hugu lagagwarik andoma isogo Pasika isagago ba nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Isagago ba nunggu lagagwarik, werekma, o hup agya lagagimu, At Yesus arwi 12 ako inim, wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wagu lagagwarik, hora yiluk, erom nunggu dugwit, At Yesus ako en “Hit An ninim erom nelagwi yi, at ambi en narumwak yiluk, An neyave wogerayogon higi o, avyarat yukhirigi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yugirigya lagagimu, it enendawi burup agu lagagwarik, iren Yesus adema yugugu dugwit at ambi en yugigik at ambi en yugigik ogagu dugwit, “An dek ai,” ");
INSERT INTO nbq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","yiluk, yugugu lagagwama, At ako en, “Hit narwi 12 yi en at ambi roti ambi ninim virin ambiat vaga eralogo ninggya halok araro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","An ap at endaklagagis yi Ala wene dirup warek atma arisogon ovara, at An neyave wogerayogon andi adigat abwa o. Eyave endaklaklipuk en, at sek duklip o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yugirigya lagagirik, erom nunggu dugwit, At Yesus ako roti ambi inggimu wigya lagagirik, “Nasin Ala wa,” yiluk samban ogagya lagagirik, “Yi An neyave atma, womanes o,” yiluk, ugurogo wogeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wogirigya lagagirik, anggur amburup nudik inggimu wigya lagagirik, “Nasin Ala wa,” yiluk, wogirigya lagagimu, it ovok at nunggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nunggu lagagwarik, “Ala hinim dambubigagiluk yukheragagi ako, hit avyarat ombarovovok yiluk, hit ap akwa wisane henake namuya wilisogon ako yi aro. ");
INSERT INTO nbq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","An yogak yi hudi en hivis Ala avema bisaligama andoma en anggur amburup swi menda naup ako hudi ao ari wagatek hegek, An nayogon mondok dek o, avyarat yukhirigi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yugirigya lagagirik, it ako ndawi wakbaluk, wunggu lagagwarik, ndom Saitun vaga unggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Unggu lagagwarik, At Yesus ako yugurugu dugwit, “'An Ala en At wam ndomba vagenombogo agarik ako watya dogomima, wam ndomba hoda wulusogon o’, yiluk, Ala wene vaga dirup watigirikmu, hit ovok at henanggon en hekbaniluk, hoda wulusogon ovara, ");
INSERT INTO nbq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","An niluk erogo mendok okbaninggya halok, nendak o Galilea ari layogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yugirigya lagagimu, at Peterus ako en “Dek o. It ovok, nenanggon o, yiluk, hekbagaluk hoda wunggu-selok ovara, An andi hekbagaluk hoda wilisogon dek o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yugugu lagagimu, At Yesus en “Yogak o hup swa ayam ane mberen ao yegetek hegek, hat ‘Eyave an nunggut’ hane henggam vaga yisogon, avyarat yukisiga o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yugugu lagagimu, at ako en, “An Hat ninim narup andi sek ovara, ‘Heyave an nunggut’ andi mondok yisogon dek o,” yiluk, ane avuput vaga At yugugu lagagimu, it ovok en anderogo adigat yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yugugu lagagwarik o inis Nggesemani lagagwa. Lagu lagagwarik, At Yesus ane welagwi menda ako yugirigya dugwit, “Hit yoma dogwes. An samban ogari landiga,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yugirigya lagagirik, it Peterus, Yakobus, Yaya inim, wogenombolok lagya lagagirik, At ako alon iya agya lagagirik endawi anggin wisane agagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Endawi anggin agya lagagirik, “Ap yoma, An nendawi burup iri dugwit, hambup okneraligama, hit yoma dugwit suwam watu dogwes.” ");
INSERT INTO nbq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Yugirigya lagagirik, horok lagani lagya lagagirik, elese ape somalek, Ala yugugu dugwit, “Ai Abba Nain. Yogak okneraup ako, dek okbaup imbitya heyalok, dek okbain. Hat yi menda ndi menda ambi ogarup ovok sek adigatma, it anggin-mbanggin oknerasogon ako dek okbain. Ovara, An nendawi ombasiga yi, Hat ‘Dek’ imbitya heyalok asugen. Hat hendawi ombasiga ako ogaitnok,” yiluk samban ogagagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Samban okbaluk, it enadema wagya lagagirik, nogo yugusim il inugu lagagirik, Peterus ako yugugu dugwit, “Simon wai. Hat nogo yiliga a? Un satu jam suwam warup meyan embeten?” ");
INSERT INTO nbq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","iri lagagirik, “Weyak ogarup henendawi nggagali wagya hawen, suwam watu dugwit samban ogagu dogwes. Henendawi en sek ogarup ombasagwi ovara, heneyave en ogarup dek okinivisiga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yugirigya lagagirik endak samban ogari lagagi ako hivis ambi inim ogari lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hivis samban okbaluk, wagya lagagirik, it ako nogo yup oginipigirikmu nogo yugwis il inugu lagagirik, nogo mumu nggarogo yuguruk yiluk, enane dek mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mbup yugu lagagwama samban henggam hudi samban ogari lagya lagagirik wagya dugwit, yugeragagi. Yugirigya dugwit, “Hit sat yanggalhedugwi, nogo yugwis adigat ogasagwi. Ovok aro! It weyak ogasagwi menda An ap at endaklagagis yi neyave narupwak yiluk wogeraup hudi mondok vanggo yi waga o. ");
INSERT INTO nbq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hodorogo hiniluk ares. An neyave narupwak yiluk, An nonggo mbanggas ako wandiga atma, lasogon en,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ao yugirigyama, it 12 menda ambi Yudas ako it imam-imam enasini inim, it guru agama inim, it ap ombok-ombok inim it ako en ap ambi homago veram wugwi, yo yawi mbalek wugwi, ogakluk, lakbisa wagagwa ako wagu lagagwama, at Yudas ako inim at wagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","At Yesus warup avok mbanggigi ako en endak it yugirigya dugwit, “Yedok havovok yiluk, ap eyave “Wa,” yugugu neyalok, ap ako andi at umbutu dugwit, vagakluk, des erogo wolok elalo o,” yiluk, wene inim mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wene mbanggugwarikmu, at ako wagya lagagirik, mbikit Yesus adema lagya lagagirik, “Guru wa,” yiluk, wa yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wa yugugu lagagimu, it ako en yedok hugu lagagwarik mbikit ininggi-vaga vagatugwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Vagatu lagagwama, ap ambi ugun welagagi ako en veram nggigilogo ap ombok Ala wene vagago agarik menda enasin ayeloman aruk sobalhagagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sobalhigya lagagimu, At Yesus ako en, “Ap enonggop hwilarisagwi menda vaginipi lendagwi ako hak An anderogo at vaknerapwak yiluk, veram inim, yo yawi mbalek inim, wolok wagep ye? ");
INSERT INTO nbq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hutun-howam ninim At Ala awi valekma mamulhirigya neyagek, vaknetetek welagep ovara, yogak Ala wene dirup warek ako atma des yumwak yiluk, vaknera wagep andi sek aro,” yiluk, yugirigya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","At arwi ovok erogo at hekbaluk, hoda wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hoda wunggu-sigik, apsawe ambi Yesus inim lagagi ako asum eyave vaga adigat veralekma, vage vagatu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","asum nggolalogo baluk, agap sigam hoda winggigi. ");
INSERT INTO nbq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hoda wunggu-sigik, Yesus vagakluk at imam-imam enasin ap ombok adema lagu lagagwama, it imam-imam enasini inim, it ap ombok-ombok inim, it guru agama inim, it ovok erogo at adema homagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","At Yesus wolok lagu inigik, at Peterus enambetaga yalambok lagya lagagirik imam-imam enasin awi mbumbumu mbikit nonggagagi. Nunggwigya lagagirik, at ap ako ayeloman inim horaik dugwit, hali hunikmu sogwes isakedagagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sogwes isakedigya werekma, it imam-imam enasini inim, it wene amburup mbanggu lagagwa menda ovok inim homago dugwit, “At Yesus waruguluk, At ogaga adem sa en dibagen o?” yugogogwa menda, dek at hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","It ap iya erogo en huluk wene ovaga bagagwa ovara, it ambi en wene des erogo yegetek un nadok-hadok erogo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","It nin ako mondok yugu lagagwarik, huluk at ovaga lombalogo bagu dugwit, ");
INSERT INTO nbq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“At ako en, ‘Dek o. Ala awi ap akwa ininggis vaga vanggugwa ako, An masalogo baluk, ndugwis henggam vaga aveloma ap ininggis vaga ogarup dek menda ambi valugwis’, yagas o,” yiluk, yagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","wene yi ogo adem ambi en des erogo yegetek hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ambi en des erogo yegetek at ogagu lagagwama, at imam-imam enasin ap ombok ako enanggelekma ilim mondok iri lagagirik, Yesus yugugu dugwit, “It ap yi enane hovaga lombalogo bagalagwi atma, Hat wene onggo yugeraup ombasiga a, dek a?” ");
INSERT INTO nbq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yugugu lagagimu, At Yesus wene onggo ambi yegetek mbup erek at welagagi. Mbup erek welagagimu, at imam-imam enasin ako en “At mondok sek adigat agarik ako, abut ap akwa enagap wendarumwak yiluk enogo lakba wagagi Keretus ako andi Hat at ai?” yiluk, aigwakma wogogi. ");
INSERT INTO nbq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aigwakma wigya lagagimu, At Yesus en, “Andi ako An aro. An ap at endaklagagis ako, hivis An At avuput iya erogo agarik menda ako inggis amot vikit horaik dugwit, mbogot vaga en hena anggelekma, wambu wagya neyagup,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yugirigya lagagimu, at imam-imam enasin ako at asum libilhidigya lagagirik, “Nit ambi inim ovaga lombalogo baup dek! ");
INSERT INTO nbq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","At Ala weyak-weyak baup atma ovok henaruk hunggip halok eres,” yugirigya lagagimu, it ovok en “Mondok warup aro!” yagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yugu lagagwama it nin ako en waris ovaga suvutbagwi, il hwilakbaluk ininggis vugut vaga watwis, ogagu dugwit “Hat sa en hatas hegen? Hodorogo iru,” yiluk yugugu lagagwama, it imam-imam enayeloman ako en ogo ininggis obak vaga watugwa. ");
INSERT INTO nbq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Watu lagagwama, at Peterus ako olakma wenamen vikit andoma werekma, hwavyak ap imam-imam enasin ap ombok ako ayeloman ambi wagagi. ");
INSERT INTO nbq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wagya lagagirik, at Peterus sogwes isakedigya il higya lagagirik, yokigya dugwit, “Hat ogo Yesus Nasaret menda hinim nagu lagagin ako heyagi o,” yiluk yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yugugu lagagimu, at ako en, “Hat yagaliga andi an mondok nunggut,” yiluk, sup mbanggutmu nunggwisagwima akoma winggigi. ");
INSERT INTO nbq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Winggigirik werekma, hwavyak ako il higya lagagirik, it ap akwa ugun welagagwa ako yugirigya dugwit, “Dek o. At ap yi At arwi ako menda aro.” ");
INSERT INTO nbq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yugirigya lagagimu, at Peterus ako en ambi inim “An mondok dek hegek yuknisagwi,” yiluk, yagagi. Iri lagagimu, akoma dugwit, iya erogo welagatekma it ugun welagagwa ako en, at Peterus ako yugugu dugwit, “Hat Galilea menda atma, it menda avyarat heyagyo.” ");
INSERT INTO nbq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yugugu lagagwama, at ako en, “Hit ap yegep andi, an nunggut atma, Nasin hanum o,” yiluk, Ala hanum mbanggu hegek, ");
INSERT INTO nbq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ayam ane ndugwis mberen vaga yagagi. Iri lagagimu, at Peterus ako, “Swa ayam ane ndugwis mberen vaga yegetek hegek, hane henggam vaga ‘Yesus an nunggut’ yisogon o,” Yesus en at yugogogi ako, endawi wenggeligya dugwit, endawi burup iri lagagirik, yup yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hutun erogo it imam-imam enasini inim, it ap ombok-ombok inim, it guru agama inim, it wene amburup mbanggu lagagwa menda ovok inim homagu lagagwarik, wene mbanggugwa. Wene mbanggu lagagwarik, At Yesus ako heda makluk, wolok at Gubernor Pilatus adema ba lagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","at Pilatus ako en, “It Yakuri enowa inis ombok Hat at ai?” yugugu lagagimu, Yesus ako en, “Hat yegen andi aro,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yugugu lagagimu, it imam-imam enasini ako en yi wene ndi wene ovaga lombanggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ovaga lombanggu lagagwama, at Pilatus ako en “Yi wene ndi wene Hat hovaga lombalogo bagalagwi yi, hil yokanen. Hat wene onggo yugeraup ambi ombasigadek a?” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yugogogi ovara, At Yesus ane dek mbup erek welagagimu, at Pilatus ako, “Wii, nalon,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Eke, it ap Yakuri isogo Pasika isagu dugwit adigat, “Ap heda mago ambi andi visilogo woknerano,” yugu-selok, at Pilatus ako en visilogo wogirigya, ogagya lagagirikmu, ");
INSERT INTO nbq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","akoma dugwit, it nin, “Pemerintah enane hulup nenanggon o,” yiluk, ndup ogagu dugwit, ap watu lagagwama heda magago lembaga mabogogwa ako ambi inis Barabas inim welagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ap Barabas heda mago werekma, ap ombok homago Pilatus adema homari wagu lagagwarik, isogo ombok isagu dugwit, “Ap heda visilogo wokneraliga ako hak, yogak ambi visilnerano.” ");
INSERT INTO nbq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yugugu lagagwama, at Pilatus ako en, “Hit Yakuri henowa inis ombok ako visilogo wokeraup umbutu dugwit yagalagwi a?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yugeragagi ako, it ap imam-imam enasini ako enaninis umbutu dugwit, Yesus wolok wagwi, yedok inugu lagagirik, anderogo at yugeragagi ovara, ");
INSERT INTO nbq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","it imam-imam enasini ako en “Yesus aveloma Barabas heda visilogo woknerapwak yiluk, yugeres o,” yiluk, it ap akwa homago welagagwa ako enendawima molanggu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","andi okbaluk, at Pilatus en ambi inim iri dugwit, “Andi halok, hiren, ap Yakuri henowa inis ombok yagalagwi yi, an nggarogo ogarik? Yukneres.” ");
INSERT INTO nbq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yugirigya lagagimu, it ako en, “Yo winik vaga lombalogo wakbas!” yiluk, enane ombok vaga yugugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","at Pilatus ako en, “At weyak ngga ogaga vaga yagalagwi o?” yugirigya lagagimu, it ap akwa yandyak-handyak yugu dugwit, “Yo vaga lombalogo wakbas!” yiluk, evenuk enane ombok vaga at yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Enane ombok vaga at yugugu lagagwama, at Pilatus ako en it ap akwa homagagwa ako, enendawi sek arumwak yiluk, Barabas ako heda visilogo wogirigya lagagirik, At Yesus andi, yo nabirok nggoralogo wakbaluk, yo vaga lombalogo bapwak yiluk, ap enayegen werek menda wogeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wogirigya lagagimu, it ap yegen werek ako en it enasin ombok werekma, wene amburup mbalisagwima akoma, wolok nunggugu lagagwarik, it ako ovok homari warupwak yiluk, enayonggo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Enayonggo bagagwa ako homari wagu lagagwarik, At Yesus ako yum mudu elokwe ndimbup-ndimbup enggen hak yikbagwi, waren-waren adok-adok werek menda unggul vaga walinogo danggubagwi, ");
INSERT INTO nbq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","bagu lagagwarik, enane lakot vaga heyaga watu dugwit, “Wa. It ap Yakuri enowa inis ombok Hat at heyagyo o,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","yo yawi vaga unggul nggagalogo bagwi, enowaris ovaga suvurogo bagwi, okbagu lagagwarik, enerambo yunggubaluk, enendawi lakot dugwit, agayuk wutugwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Anderogo at enda hambugu lagagwarik, yum mudu ako nggolalogo baluk, aveloma At asum yikbagagwa. Ayum yikbagu lagagwarik, eyave yo vaga lombalogo baguluk, wolok lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wolok lagu lagagwarik, ap ambi inis Simon awi Kirene menda Aleksandet Urupus enasin ako andi, kampung en endawi ugun wagyama inim dambunggu lagagwarik, “Yo winik ogarek yi woman,” yiluk, enane vanggalogo yugugu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesus wolok, o inis it enane vaga Nggologota. Eke, nit nenane vaga andi Unggul Owakma, hulikmu akoma unggugwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wolok unggu lagagwarik, anggur amburup inim, nggami inim, nanggelek-hanggelek okbaluk, napwak yiluk, wogogogwa ovara, hekbagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hekbagya lagagimu, it ako en yo winik vaga lombalogo bagagwa. Lombalogo bagu lagagwarik, “At ayum, sa hedigya hami?” yiluk, helep enggen vaga avut mbanggu dugwit, “Avut endenogo ligya halok, an hedayogon o. Eke, avut endenogo lagatek halok, hat at hedoman o,” sumbukedagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","At Yesus yo winik vaga lombalogo bagagwa ako o hutun yam 9 vaga At lombalogo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lombalogo bagu lagagwarik, “Yakuri enowa inis ombok ako yi aro,” yiluk, wene At ovaga lombanggugwa ako dirup warogo Yesus unggumu winimen yo vaga lombabagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Lombabagu lagagwarik, ap enonggop iya menda mberen Yesus eyave venak-venak inim yo winik vaga lombalogo bogogwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Venak-venak inim bugu lagagwama, it ap akwa nin lagwi-wagwi ako, lagwi-wagwi ogagu dugwit, enut wadok yugu dugwit, “Inyagot! Nabirok ale. Hat ‘Ala awi valek masalogo baluk, hivis aveloma ndugwis henggam vaga valugwis’, yegen ako heyave yo winik vaga lombalogo bagagao andi, yo winik vaga en hagap wendakedelok, soklok wambuma,” yiluk, weyak-weyak erogo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Weyak-weyak inim bagu lagagwama, it imam-imam enasini inim, it Ala wene mamuleraliga menda inim, it ako ogo inim At Yesus weyak-weyak ogagu dugwit, “Aren it ap akwa enagap wendarenavit lagagi ovara, At eyave agap wendakedaup andi, dek at higyo. ");
INSERT INTO nbq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","At Keretus nit ap akwa Yakuri menda nenowa inis ombok yi nit avyarat ombarugen yiluk, ninil vaga yogak At yo winik vaga en wambuma,” yiluk, enda hambugu lagagwama it ap mberen At inim yo vaga lombalogo bogogwa ako inim Yesus anggadi wakbagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Anggadi wakbagu lagagwama, o dingga yam 12 vaga yi awi ndi awi andoma, o hup agagi hegek, mbikit yam 3 howam vaga o awiya agagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","O awiya agya lagagirik, o howam agya helan, yam 3 vaga At Yesus ako na iri dugwit, “Eloyi, Eloyi, lama sabakatani!” yagagi. Andi nit nenane vaga, “Nasin Ala o! Nasin Ala o! An nano yiluk hekbanenggen o?” yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Anderogo iri lagagimu, it nin enendawi ugun welagagwa ako en ane iris enaruk hobagu lagagwarik, “Avyak wai. At Eliya ako yanggup yugisiga o,” yiluk, yugu lagagwama ");
INSERT INTO nbq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ap ambi en vupuk lagya lagagirik, suk wombamok yo atok vaga anggur amburup eda menda inim, yomarogo Yesus napwak yiluk, ndaun okbagya lagagirik, wogugu dugwit, “Yogak hekbas. At Eliya en visilogo wombaba wagya hawen sokhugu dogosogon o,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iri lagagirik, At Yesus ako en na iri dugwit, endawi weranggigi. ");
INSERT INTO nbq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Endawi weranggu lagagimu, yum At Ala awi valekma ilim amot sivinik welagagi ako, winiminggan nggagalogo wambu wagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eke, at yegen werek enowa Yesus elesema mendek dugwit Yesus anderogo endawi weranggu il higya lagagirik, “Ap yi Ala abut avyarat higi o,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Eke it akwa wisane Yesus o Galilea welagagi hegek eneyak heda okbaluk Yesus avuk Yerusalem lagu lagagwarik, Yesus yo winik vaga lombanggugwa ako o adumu en inil lakagagwa. It akwa wisane ako enanggelekma hwa Maria awi Makdala menda inim, hwa Salome inim, hwa Maria Yoses Yakobus ao sawe it mberen inisa inim, inil lakagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","At Yesus ako hambigya lagagimu, heveret hutun samban ogaruguluk vipuk-vapuk erogo bagwi vaga, o hup agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","it wene amburup mbalisagwi menda ako ap ambi inis Yusup awi Arimateya menda agayuk werek dombok atma, at “Ala avema banupwak o” yiluk, sokhigya werekma, alon dek akluk, at Pilatus adema lagya lagagirik, Yesus eyave warek woknirupwak yiluk, “Wokniru o,” yugiri lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","“Wokniru o,” iri lagagimu, at Pilatus ako en, “Mondok hombagas,” yugwi ako aruk hobagya lagagirik, “Ayai?” yiluk, it yegen werek enowa yonggo lakbagagi ako wagya lagagimu, “Yesus mondok hombagas a dek a?” yiluk, hemekagagi. ");
INSERT INTO nbq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hemekagagi menda at ako en, “Mondok hombagas o,” yugugu lagagimu, eyave warek ako wa lapwak yiluk, at Pilatus ako en Yusup ako yugogogi. ");
INSERT INTO nbq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yugugu lagagimu, yum mudu obak ambi onggo hunggu lagagirik, wolok eyave warek ako visilogo wombaba wagya lagagirik, yum mudu obak ako vaga lobarogo helep wis mendagoma mabaluk, helep sigilogo sup lakbagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sup lakbagagwa ako, at hwa Maria awi Makdala menda ako inim, Maria Yoses isa inim, inil hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","It Yakuri samban okbaluk, o hup agya lagagimu, hwa Maria awi Makdala menda ako inim, Maria Yakobus isa ako inim, hwa Salome inim, it ako en yo enggen amben sek menda Yesus ovaga eralogo bamunda onggo huni lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Onggo huni lagu lagagwarik, nogo yiluk hari minggu vaga hutun hup mo daga wagya helan, helep wimu akoma lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lagu dugwit, “Sa en helep larik ako hurogo bininayogon embetep?” ");
INSERT INTO nbq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","yiluk, inil yokugu lagagwarik, helep ombok sup larik ako sigilogo lagagi inil hagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hugu lagagwarik, wimu akoma nunggugu lagagwama, ilumu ininggis amot vokot apsawe ambi yum mudu yirik horaik werekma inil hugu lagagwarik, enanggela wunggu dugwit “Ap yi sava agarik?” umbutu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","at ako en “Hit henanggela wulubuk. Hit Yesus awi Nasaret menda yo vaga lombalogo bagao ako hinil yokaguluk wagep ovara, eyave yoma agarik dek. At vage iluk akluk mendok yagas. At eyave warek agarikmu, avela adigat yi hinil yokanes. ");
INSERT INTO nbq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","‘An endak Galilea andoma lamindikmu neya lasogon’, yiluk, wene yukheragagi ako ndatak at ogagarikmu, At ane welagwi menda nin inim, Peterus inim, yugerelales,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yugirigya lagagimu, “Wii,” yiluk, enowak wuruk yagan wimu en lagu lagagwarik, hoda wunggu dugwit, enalon en ap akwa ambi yugeregetek mbauk enane dek lagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hari minggu o hutun hup en At Yesus ako iluk akluk mendok iri lagagirik, at hwa Maria awi Makdala menda madis 7 endawima welagagi wibagagi ako, Yesus eyave il neyapwak yiluk, sigam agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","At aswei inim, arupwi inim welagagwa ako yup yi-yi wo-wo yugu-sigik, at hwa ako yonggo yugera lagagi. ");
INSERT INTO nbq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yesus iluk akluk, mendok yagas il higya lagagirik, yugera lagagi ako enaruk hunggugwa ovara, enendawi avyarat embetetek welagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Andi okbagu lagagwarik, werekma, Yesus aswei menda mberen o umwa en wunggu lagagwarik, suvaga lagusim, At Yesus eyave adik hunogo heda okbaluk, sigam agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","eneyami vaga wagu lagagwarik, enaswei nin yugera wagagwa menda it ako ogo avyarat embetetek adigat welagagwa. ");
INSERT INTO nbq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Andi okbaluk, hivis en At ane welagwi menda eneve 11 ako erom nunggwi werekma, neyapwak yiluk, enadema sigam ari wagagi. Sigam ari wagya lagagirik, enendawi lakot atma, At iluk akluk mendok yagagi inil halok yugera wagagwa ako, enendawi avyarat embetetek iniselok, enanggadi watigi. ");
INSERT INTO nbq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Enanggadi watya lagagirik, it ako yugirigya dugwit, “Hit yi awi ndi awi lagu dogomundik, it yi ap ndi ap andoma ovok erogo sek wene yugeregek nagu dogop o. ");
INSERT INTO nbq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sek wene yugeregek lamwi ako andi, enendawima en avyarat umbutu dogomundik, ima wombabugu-selok, enagap wendarisogon. Eke, wene andi enendawima avyarat embetetek iniselok andi, Ala en enowak dibaluk weyak okbisayogon o. ");
INSERT INTO nbq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","An nane enendawima avyarat umbutu-selok, it ogarubuk menda ogarusogon, it madis enendawima nonggagagi ako An ninis vaga nggigilogo wibugwis, it enane adik-adik enunggut menda yugurugwi, ");
INSERT INTO nbq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mbas huli ininggis vagatwis, heda nalis amburup nunggu-selok, hambegetek at inugwis, aup idup iniselok, enovaga ininggis vakbisiluk, sek okbugwis ogarit lagu dogosogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yugirigya lagagimu, nenowa Yesus inis ombok ako At Ala en wolok mbogot vaga ba inggya lagagimu, At inggis amot vaga hora yagagi. ");
INSERT INTO nbq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ba inggya lagagimu, it ako yi awi ndi awi sek wene yugeregek nagusim, ogarubuk menda ogarit nagwis vaga it ap akwa ovok erogo, “Wene yi avyarat o,” ombarupwak yiluk, nenowa inis ombok yonggat inivit nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nenasin Teyopilus wai. It ap wisane en yi wene ndi wene nit nenanggelekma oklagagi ako mbilinogo dirup mbaluguluk ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dirup mbaluguluk ogagu dugwit, Yesus asinggigi hudi en oklagagi inil hugu lagagwarik sek wene yugeregek nagu lagagwa ako, mbilinogo yukneragagwa ako ndatak, it dirup mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Dirup mbanggu lagagwarikmu, an ogo, endak asinggigi hudi en oklagagi ovok ilim erogo adem senbaluk, yi wene ndi wene hat mamulhogogwa ako, “Yi avyarat,” ombarinok yiluk, mbilinogo dirup mbalhirup oknita halok, mbalhisiga o. ");
INSERT INTO nbq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ap Herodes o Yudea inis ombok vagago werekma, ap imam ambi inis Sakaria inis unggul Avia menda welagagi. Eke, at ogwa andi, Harun ombawi wigalek menda inis Elisavet welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iperen Nenasin Ala en, “Yerogo ogarup, nderogo ogarup,” wene yugup adik ogagetek mondok atma nggedok ogarit nagu lagagwarikmu, Ala en it enendawi mondok mot inigu lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Enendawi mondok mot welagagwa ovara, hwa Elisavet ako, wimbu welagagirikmu, eneyak-enabut mondok dek hegek iperen enanggok agagwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ndugwis ambi vaga, ap Sakaria ako owa-aot imam-imam Avia menda inim Ala awi valekma ogarup vanggo iri lagagimu, at Sakaria ako Ala awi valekma andoma yavup imam menda ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ogagyama, it ap imam en, “Ala awi valekma ilim akoma amben eve sek menda ako, sa en hali ba nunggwigya hamwi,” yiluk, helep enggen vaga avut mbanggu lagagwa enandogon ogagu lagagwa ako, ogagu-sigik, helep enggen vaga ap Sakaria inis mekbagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mekbagu lagagwama, ap Sakaria ako Ala awi valekma ilim o mogama akoma nunggwigya lagagirik, amben eve sek menda hali bagya hegek, ap akwa homago ako ovok erogo wasim dugwit, samban ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Samban ogagusigik, amben eve sek menda ako hali bagyama, Ala yonggo malaikat ambi amben eve sek menda hali belagwima inggis amot vikit adema mendek yi wagya hagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Higya lagagirik, anggela wunggu dugwit, alon wisane agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","at malaikat ako en iri dugwit, “Sakaria wai. Halon habuk. Hat samban ogagya lagagin ako Ala ovok aruk hunggigirikmu, hogwa Elisavet ako habut ap at endarisogon. Endatya halok, inis Yohanes salinok yiluk, yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Hat hendawi mondok adenggen wisane hayogon. Eke, at endaklasogon andi vaga, Nenasin Ala en at ap ombok ombarisogon atma avakwa wisane enendawi adenggen umbutu dogosogom. Eke, anggur amburup inim, amburup anye nenek oginivisiga menda inim, at mondok ninggya dogobuk. At ao isa endawima en Averiniki endawima mondok werek endaklasogon. ");
INSERT INTO nbq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aren avakwa Iserael menda wisane eneyami vaga suguliluk Enasin Ala avema warupwak yiluk, okbugu dogosogon. ");
INSERT INTO nbq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Averiniki ap Elia ovaga agya lagagirik, anye vaga ogagya lagagi ako, Yohanes ovaga akluk, anderogo ogagya dogosogon. Nenasin warigiluk ogagya hegek, at endak okbigik lagya dugwit, enasini enendawi enaburi inim dambubugu, it avakwa enendawi mbuk agarwik ako, it ap enendawi werek dugwit, Ala Wene dibaluk sek adigat ogasagwi ako it ndatak ogagu dogopwak yiluk, okbugu, eke, Nenasin warup ako avakwa enendawi dik-duk erek dogopwak yiluk, at ake vipuk erogo bugu, ogarit lagya dogosogon o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Andi yugugu lagagimu, malaikat yagagi ako Sakaria endawi avyarat embetetek dugwit, “An ovok nanggok agirik o. Eke, nogwa ogo, anderogo agarik atma, yuknigin ako avyarat ogarup andi, wakhegek ngga ogarimi vaga nelup arimi?” ");
INSERT INTO nbq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yugugu lagagimu, malaikat ako en, “An andi, Nggaviriel aro. An Ala inim agirik atma, sek wene yi, wolok, ‘Yuguri elak o,’ yuknugu lagama, yukhiri wagi o. ");
INSERT INTO nbq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Anen wene yukhigis ako eyave oklarup hudi vaga ndatak ogarisogon ovara, hat an yukhigis andi avyarat embetetekma, eyave oklarup atma des yi wagetek hegek, yogak andi, hane mondok dek agya dogomindik, hane yup meyan hayogon o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Andi yugu-sigik, avakwa weram Sakaria sokhugwi ako en yugu dugwit, “Ala awi valekma en wulu wagetek adigat yi, nggarogonggan aga? Wi!” yiluk, yugusim, ");
INSERT INTO nbq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakaria wulu wagya lagagimu, ane yugeraup meyan hugu lagagwarik, “Ala awi valekma dugwit, nogo heda abi heda higya lagarik, ane dek aga ai?” umbutu-sigik, at ako anedek we un inggi wene vaga adigat yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Andi en, at Sakaria ako Ala eyavup ogarup ako ovok dek agya lagagimu, amwa winggigi. ");
INSERT INTO nbq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Amwa wunggu lagagirik, werekma, hivis, ogwa Elisavet ako avula agya lagagirik, “Nasin Ala en nabwa nimbita dugwit, avakwa enanggelekma nanggadi embetek lagya lagagis ako, dek arupwak yiluk, o yogak yi vaga okbanenggas ai,” yiluk, mbauk amwa hegek, saut 5 welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisavet ako avula agagi hegek, saut 6 agya lagagimu, Ala en malaikat Nggaviriel ako o Nggaliliya kota Nasaret andoma lakba lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hwa sawe ambi ap hagap mbanggitek inis Maria adema lakba lagagi. At Maria ako ap ambi inis Yusup, Daut ombao wigalek menda onggo bago mirik welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaikat ako en Maria adema lagya lagagirik, at yugugu dugwit, “Narup Maria wa! Nenasin Ala habwa imbita dugwit, adenggen wisane hovaga bagagas. At hinim at agarik o!” ");
INSERT INTO nbq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yugogogi ako, Maria mondok endawi obak agya lagagirik, “Nggarogo yiluk anderogo yuknigas?” ");
INSERT INTO nbq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","imbita lagagimu, at malaikat ako en at yugugu dugwit, “Maria wai. Halon habuk. Ala habwa imbita dugwit, adenggen hovaga bagaup embetarikmu, ");
INSERT INTO nbq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","havula agya dogomindik, ap at endarisogon o. Endakbaluk, At inis Yesus salop. ");
INSERT INTO nbq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","At mondok ap ombok at dogosogon. Avakwa en, ‘At Mondok Siyalek Dombok Agarik abut yi aro,’ yugu dogosogom. At ombao Daut inis ombok dugwit, wene yugirigya lagagi ako, aveloma wene yugirigya dogopwak yiluk Nenasin Ala en mekbayogon. ");
INSERT INTO nbq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","At Yakup ombawi wigalek enowa inis ombok dugwit wene mondok-mondok yugirigya dogosogon. Eke, At avema bisaligama ako, dek asogonbuk mondok-mondok dogosogon.” ");
INSERT INTO nbq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yugugu lagagimu, at Maria en malaikat ako yugugu dugwit, “An ap ao nagap mbanggitekma, yuknigin ako andi, nggarogo navula arimi?” ");
INSERT INTO nbq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yugugu lagagimu, malaikat ako en, “Averiniki hovaga wambu wagya hegek, at Mondok Siyalek Dombok Agarik anye okbaga wagya dogomima, havula agya dogomindik, hat heyak endarisogon ako avakwa en, ‘Wii, mondok sek adik denek agarik yi, Ala abut aro,’ yugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Eke, howa Elisavet ako ovok anggok agagi hegek, at ogo avula aga o. ‘Hwa wimbu o,’ yugu lagagwa ako ovara, avula agagi hegek, vage saut 6 agarikmu, yukhisiga o. ");
INSERT INTO nbq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ala en ambi ogarup ombasiga halok, ambi meyan asiga dek, atma at ogasiga o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yugugu lagagimu, at Maria en, “E o. Nasin Ala ayeloman an atma, yuknigin ako andi, mondok ndatak okbanupwak o,” yiluk, yugugu lagagimu, malaikat ako en Maria hekbaluk, winggigi. ");
INSERT INTO nbq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Malaikat ako vage wunggu lagagimu, hwa Maria ako amwa en lagya lagagirik, Sakaria amwa o kota ambi o Yudea andoma ndom vaga vupuk inggigi. ");
INSERT INTO nbq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Inggya lagagirik, ap Sakaria amwa nunggwigya dugwit, ogwa Elisavet ako wa yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria wa yugogogi Elisavet en aruk hunggu hegek, isa endawima en avyak ako wadok iri hagagi. Wadok iri halok, Averiniki ako hwa Elisavet endawima hobo-hobo ari nunggigya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","at ane ombok vaga iri dugwit, “It akwa nin inigik arova, Ala adenggen hat hadigat ombok erogo hovaga agarik o. Eke, heyak hendawima agarik ako ogo, Ala en adenggen ovaga bagya dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","An sa nombakluk nadema wagen? Hat an Nasin Inis Ombok isa aro. ");
INSERT INTO nbq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wa yuknigin ako naruk hunggu neyagek, avyak nendawima en adenggen imbita dugwit, wadok iri higi o. ");
INSERT INTO nbq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nasin Ala yukhigas ako atma asogon avyarat embeten vaga, hadenggen wisane hayogon o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yugugu lagagimu, at hwa Maria ako en iri dugwit, “An nendawi vaga Nasin Ala siyabaliga o. ");
INSERT INTO nbq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","Nagap wendarisiga menda Ala ako en, An At ayeloman sovalek neyagek il neyagagirikmu, At vaga nendawi adenggen wisane haliga o. At Ala Mondok Anye Werek ako en iya erogo okbaninggigirikmu, Avakwa ovok erogo yogak yi hudi en hivis mondok-mondok ‘Endawi adenggen wisane okbagagi o,’ yiluk, yugu dogosogom o. At inis Sek Adik Denek agarik o. ");
INSERT INTO nbq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","It avakwa At enalon umbutu-selok, yogak endago inim, vivis endago inim, ovok erogo at Ala aigwak abet en okbugu dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","At Ala inggis anye vaga it avakwa enendawi siyabetaup wenggelit lagwi ako haryogo wibugu, ");
INSERT INTO nbq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","It ap ininis ombok wene yugerelagwima akoma en sovalogo bugu, Eke, it enendawi sovalek agarwik ako siyabugu, ");
INSERT INTO nbq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","It uvup agarwik ako eve sek menda wisane enagaum erogo wogorigya, It ap ininggi werek ako wogeregetek we un lakbugu, Ogagya lagagi o. ");
INSERT INTO nbq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Eke, wene o muk nenasini Averaham ombawi wigalek menda inim mondok-mondok naigwak abet en okbugugu dogosogon yugeragagi ako, wenggenggu dugwit, nit at ayelomani Iserael menda yonggat ninivi wagagi o,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Iri lagagirik, hwa Maria ako Elisavet inim dugwit, saut henggam welagagirik, amwa eyami vaga winggigi. ");
INSERT INTO nbq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Andi en, hwa Elisavet eyak endaklarup hudi agya lagagirik, eyak ap at endaklagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Endaklagya lagagimu, at inim agarwik, at owa-asin inim, Nenasin Ala aigwak abet en okbagas hunggu lagagwarik, at inim enendawi adenggen agu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Enendawi adenggen agu lagagwama, endaklagagi hegek, ndugwis 7 dukluk, hutun avyak ako agap mbaluguluk, adema lagagwa. Adema lagu lagagwarik, agap mbabaluk, “Inis andi, asin Sakaria inis ndatak salusogom,” umbutugwa ovara, ");
INSERT INTO nbq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","at isa en, “Dek o. At inis andi, Yohanes aro,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yugirigya lagagimu, iren, “Howa-hasin ininis anderogo ambi salek dekma, inis Yohanes andi, nano yiluk salup yegen?” ");
INSERT INTO nbq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yugu lagagwarik, ininggi vaga wakhegek asin yugugu dugwit, “Inis ngga salup embeten?” ");
INSERT INTO nbq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yugugu lagagwama, Sakaria en papan tulis ambi nggino yugirigya lagagirik, wogugu lagagwama, “At inis Yohanes aro,” yiluk, dirup mbanggigi. Mbanggya lagagimu, avakwa ovok en, “Wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","“Inis Yohanes aro,” yiluk, dirup ao mbanggya hegek, asin ako ane hutlagya lagagimu, ane yigiluk ogagya dugwit, siyabagagi. ");
INSERT INTO nbq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Andi ogagagi vaga it inim agarwik ako enalon wisane agagwa. Eke, it avakwa o Yudea ndom vaga agarwik ako en yi wene ndi wene oklagagi ako mbilinogo yugeregek lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wene yagan nagwis ako it ovok erogo enaruk hunggu lagagwarik, dibaluk, Nenasin Ala avyak ako inim agarik hugu lagagwarik, “Avyak yi, sawe agya dogomindik, nggarogo dogogwi?” yiluk, enendawi umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","At Yohanes asin Sakaria ako Averiniki endawima hobo-hobo ari nunggwigya lagagirik, yugugu hegek, iri dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","75","“Nit avakwa Iserael menda Nenasin Ala siyabagu dogosogom o. Aren wene mondok adik denek At inis vaga nenombao Averaham yugogogi ako, Eke nenombawi aigwak abet en okbisaup, yugeragagi ako, atma des yupwak yiluk, endawi wenggenggu dugwit, It ninim aik mbalek ininggimu en wender erogo bininiluk, Nit nenalon embetetek At eyavup ogarit lagwi, Eke, At il hegek, nit weyak ogagetek At ake denek nenendawi mot dugwit, hambugup hudi ogarit lagwi, Ogagu dogopwak yiluk, okbininaup endawi wenggelaga o. O endak erogo it ap navi-navi at ake denek Ala en yugirigya hegek avakwa yugurugu dugwit, ‘It ninim ogorek ininggimu en ndiyalogo nenagap wendatya, it avakwa ovok erogo enanggon ninombarisagwi ininggimu en visilogo bininggu, Ogasogon o,’ Yugu lagagwa ako ndatak ogagya dugwit, Nenagap wendakninivupwak yiluk, at ayeloman Daut ombao wigalek anye werek dombok ambi mekbagagi o. Ogagagi andi, Nenasin Ala ako ninisa wagya lagarik, wender erogo bininggarikmu, siyabagu dogosogom o.” ");
INSERT INTO nbq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Iri lagagirik, Sakaria en at abut Yohanes yugugu dugwit, “Hat nabut yi, Nenasin ogarit lagya dogop sup yarit lagya dogonyok yiluk, hendak lagya dugwit, Ala en avakwa enomaduk dek erogo bugu vaga, enagap wendarisiga wene ako, enelup arupwak yiluk, yugeregek lami vaga hinis, At Mondok Siyalek Dombok Agarik Ane Yugeraliga yi aro, yiluk, yukhugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nenasin Ala en hekbininaligadek des-erogo nenabwa en okbininaligama, O het lagasiga andi hak, mbogot vaga eloma en At awiya hak agarik ako, wambu wagya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","It o hwiserekma dugwit, hambup enalon ombasagwi ako awiya okbugu, Eke, ‘Sup enendawi ugun adenggen wadok dek dogop ako yi aro,’ yiluk, yuknirigya, Ogasogon, yukhisiga o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Eke, avyak Yohanes ako sawe agya dugwit, endawi mondok hoda agagi. Aren avakwa Iserael menda enadema sigam agatek hegek, o mbedama avakwa dekma andoma welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yohanes ao nggedera helan, ap inis ombok Kaisar Agustus yi awi ndi awi O Oroma ovok erogo vagago welagagi. Vagago werekma it avakwa ovok erogo eneyave maren hudi agarwik, ilup arigiluk, ininis dirup mbalupwak yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ininis endak dirup mbanggugwa ako andi, ap Kirenius o Siriya gubernur hegek, mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ininis dirup mbalupwak yiluk, it avakwa ovok erogo enawi adem vaga adik-adik lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","At Yusup ako, Daut ombawi wigalek menda atma, o Nggaliliya kota Nasaret en o Yudea Daut endaklagagirikmu o kota Betelehem akoma lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hwa Maria Yusup migup avula agagi ako iperen ininis dirup mbalupwak yiluk, lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lagu lagagwarik, werekma, eyak endaklarup hudi agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","eyak manggum ap at endaklagagi. Endaklagya lagagirik, o avakwa nogo yilagwima hobo iri lagagimu, avyak ako yum dinggilogo kambin-ndomba enamwa iringga nelagwima akoma nggik okbagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","O Betlehem horok andoma o hup weram harumu ap ndomba unde werekma, ");
INSERT INTO nbq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","it Ala yonggo malaikat ambi verak erogo enadema mendok yi wagya hegek, Nenasin Ala awiya okbugu lagagimu, enalon wisane okbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Enalon wisane okbugu lagagimu, malaikat ako en yugirigya dugwit, “Henalon habuk. It avakwa ovok erogo enendawi adenggen ombok ombarup sek wene wolok yukhera wagi o. ");
INSERT INTO nbq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sek wene andi, henagap wendarisiga menda Daut endaklagagirikmu amunerama akoma henake o yogak endaklaga o. At andi, Nenasin inis ombok Keretus Ala en denogo bagagi ako aro. ");
INSERT INTO nbq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Avyak ambi yum kain dinggilogo ndomba iringga nelagwima nggilik agarik hinil bikhelagu dogomundik, ako yi aro, ombarusogom o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ao yugirigyama, it mbogot-vaga menda eneyave wisane homago yukdekma homari wagu lagagwarik, at malaikat ako inim Ala inis siyabagu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“At mbogot winimen agarik Ala ako, inis siyabagu dogosogom o. Eke, o wen vaga yoma it avakwa Ala endawi sek enombasiga ako, enendawi ugun wadokdek dogopwak o,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yugu lagagwarik, it malaikat ako en ap ndomba unde ako bisiluk, eneyami vaga mbogot-vaga unggu-sigik, it ap ndomba unde ako at ambi en at ambi yugigik ogagu dugwit, “Nenasin Ala en oklaga yukneraga ako, o Betlehem bikha lasogom o.” ");
INSERT INTO nbq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yugu lagagwarik, Maria Yusup ako, avyak ndomba iringga nelagwima nggilik werekma, vupuk bigisa lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bigisa lagu lagagwarik, malaikat ako en avyak endago avok yugeragagi wene ako, avakwa nin andoma mbilinogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","It ndomba unde en wene mbilinogo yugeragagwa ako, avakwa hunggu lagagwarik, it ovok erogo, “Wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Vok yagagwa ovara, at Maria andi, wene yagagwa ako ovok erogo endawima wigya dugwit, wenggenggu lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eke, it ap ndomba unde ako eneyami vaga lagu dugwit, malaikat en it yugeragagi ako ndatak enaruk hunggwis, inil hugwi, ogagagwarikmu, Ala agayuk wurogo inis siyabagek lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ndugwis 8 vaga avyak ako agap mbalup agya lagagimu, mbanggu lagagwama, at isa ao avula agatek hegek at malaikat ako en, “Inis Yesus salop o,” yugogogi ako At inis Yesus sanggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Inis sabagu lagagwarik, “Akwa eneyagi endaginipwis selok, ndugwis anderogo hudi avyak sovalek dogop o,” yiluk, Ala wene yugup Musa en dirup mbanggigi ako ndatak okbaluk, avyak ako Nenasin Ala woguruguluk, wolok o Yerusalem lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ala woguruguluk wolok lagagwa ako andi, Nenasin Ala en, “Ap manggum endaklagya halok andi, An henasin nake denogo banup o,” yugirigya, ");
INSERT INTO nbq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","eke, ambi yugirigya dugwit, “Swa suwa mberen a, swa wurum mberen a, An henasin nake warogo baup o,” yiluk, yugirigya, yagagi dirup warek ako ndatak ogaruguluk, avyak asin-isa ako en wolok lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","O Yerusalem andoma ap ambi inis Simeon welagagi. At ap andi, endawi mondok sek Ala wene dibaluk ogagya lagagi. Ogagya dugwit, it avakwa Iserael menda at ap enagap wendari warup ako sokhigya lagagirikmu, Averiniki at ovaga welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Averiniki at ovaga dugwit, Nenasin Ala en denogo mondok okbagagi Keretus ako, il hegetek hegek hambisogonbuk elup okbagagima, ");
INSERT INTO nbq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Averiniki en Simeon endawima yugugu halok, Ala awi valekma mbumbumu nonggagagi. Nunggigya lagagirik, werekma, Yesus isa-asin en Ala wene yugup dirup mbalek ogagu lagagwa ako, ndatak ogaruguluk, avyak Yesus ako wolok nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nunggugu lagagwama, at Simeon ako en avyak inggimu wigya lagagirik, Ala siyabagya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“Nasin wa! Hat hendawi ombasiga ako it Yakuri dek weram menda awiya okbugu, Eke, haburi Iserael menda ininis siyabugu, Ogarupwak yiluk, Ap enagap wendarisiga menda yi avakwa ndi avakwa inil hapwak yiluk vipuk erogo bagagin ako, an ovok nil higirikmu, Hat yuknigigin ako ndatak yogak at hayeloman an ako, nendawi horaik dugwit, hadema warigiluk, hekbanin o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Avyak avok yagagi ako isa-asin en hunggu lagagwarik, “Wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Vok yugu-sigik, at Simeon ako en adenggen isa-asin enovaga bisapwak yiluk, Ala yugogogi. Yugugu lagagirik, At isa Maria ako yugugu dugwit, “Avyak yi, it avakwa Iserael menda wisane mekbugu-sovabugu, ogagya dogopwak yiluk, at Ala en denogo bagagi. Avakwa enelup arupwak yiluk, denogo bagagi hegek, avakwa wisane, ‘Nenanggon o,’ yiluk, yugwi ako vaga ");
INSERT INTO nbq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","enendawima ombasagwi ako sigam agya dogosogon. Eke, hat ogo, segowa vaga hendawi sapok erogo hatwis sayogon o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hwa navi menda ambi inis Hana, ap Vanuel abut inis unggul Asiet menda welagagi. Hwa ako agun hidigya lagagirik, iperen inigik 7 tahun welagagirik, ");
INSERT INTO nbq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","hivis, sogwa hegek 84 tahun ogagagirikmu, ovok hwa anggok agagi. Ala awi valekma en winggitek mondok andoma at o hup dingga Ala ake yiluk, erom hunis dugwit, samban adigat ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","O andi hudi vaga hwa ako wagya lagagirik, “Nasin Ala wa!” yiluk, yagagi. Eke, it avakwa “Ala en nit Yerusalem menda heda visilogo binina warup ai,” yiluk, sokhugu lagagwa ako, Hana en avyak endaklagagi avok vagalogo yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","“Avyak endaklagya halok, yerogo ogagu dogop,” yiluk, Nenasin Ala wene yugup dirup mbalek ako, isa-asin en ovok erogo dikduk-dakduk okbagu lagagwarik, eneyami vaga enamwa o Nggaliliya o kota Nasaret wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eke, avyak ako ombok agya, anye agya, ogagya dugwit, endawi werek hoda agagi. Eke, Ala endawi at inim hunik welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesus isa-asin ako en tahun ambi wagya vaga it Yakuri Isogo Ombok Vasika isagusim, o Yerusalem lagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lagu lagagwa ako, avyak Yesus endago hegek 12 tahun agya lagagimu, Isogo Ombok Vasika isagusim, lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Isogo isago ako nelok, isa-asin enamwa enendawi ugun lagu-sigik, Yesus ako inim lagetek o Yerusalem mbup yagagi. Asin-isa ako ininggut dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","avakwa ovok wagwi enanggelekma inim wandiga embetek lagu lagagwarik, nogo yuguluk ogagu dugwit, avyak ako eyave dek halok, owa-asin, asuwei inim werek hao en yiluk, belanggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Belanggugwa menda, eyave dek halok, eneyami vaga o Yerusalem belalit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Belanggu dugwit, ndugwis henggam okbaluk, Ala awi valekma, it ap ngguru agama enanggelekma horaik dugwit, enane hunggu, aren it enaigwakma wigya, ogagyama belanggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","It ap ovok erogo ane hunggugwa ako en At yi wene ndi wene ovok elup dugwit, wene onggo yugirigya ako hunggu lagagwarik, “Avyak yi, ovok elup dugwit, yagaliga wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Asin-isa ako en At ako havitu lagagwarik, “Wi!” yiluk, isa en, “Neyak o. Hat nggarogo yiluk, anderogo okbininggin? Hasin niperen nenendawi anggin dugwit, belalhetek wagyo.” ");
INSERT INTO nbq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yugugu lagagimu, aren, “Hit nggarogo yiluk, an belalnetek wagep? An nasin awi valekma dogop aga andi, hit hininggutmu belalnetek wagep?” ");
INSERT INTO nbq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yugeragagi ovara, it dibagetek welagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Andi en, at inim o Nasaret lagu lagagwarik, at isa-asin enavema dugwit, enane des erogo hunggu hegek, at isa ako en andi, it avakwa yugwi ako endawima wigya dugwit, wenggenggu lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Eke, at Yesus andi, endawi werek agya, eyave sawe agya, ogagya hegek, Ala inim, avakwa inim, at vaga enadenggen umbutu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ap Kaisar Siverius inis ombok dugwit, yi awi ndi awi Oroma menda ovok erogo at avema vagago welagagi. Vagago werekma, 15 tahun ogagya vaga at avema welagagwa menda andi, ap Pondiyus Pilatus o Yudea gubernur vagago welagagi. Eke, ambi, ap Herodes o Nggaliliya vagogo welagagi. At aot Pilipus o Itureya Serakonitis vagogo welagagi. Eke, ambi, ap Litanias o Abilene vagogo welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Andi vagago werekma, it ap Hanas Kayapas iperen imam-imam ininis ombok winimen inigik, Sakaria abut Yohanes ako o mbedama avakwa dekma andoma hegek, Ala en wene ambi at endawima yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yugugu hegek, Yohanes en avakwa yugirigya dugwit, “Henomaduk dek erogo bigigaupwak en yiluk, weyak ogasagwi ako henasam hanes. Henasam hugu hiniselok, ima wombabigigaup o,” yiluk, wene andi, is Yorodan liris ambut ovok erogo yugeregek lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ap navi Yesaya en o endak dirup mbanggigi ako Yohanes en ndatak ogagagi. Yesaya en Yohanes avok yagagi andi, yi: “Ap ambi o mbedama avakwa dekma naik iri dugwit, ‘Nenasin inis ombok warup sup ogovak higirogo yagwi, Eke, At lagya dogop sup mot erogo yagwi, Ogagu dogones o. ");
INSERT INTO nbq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ndonggo halok, lekbagwi, Ndom inim, hulik inim, sovabagwi, Sup mbirik halok, mot okbagwi, Adok-adok werek halok, amot okbagwi, Ogagu dogones o. ");
INSERT INTO nbq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ala en henagap wendarisiga menda lakbigiga wasogon ako, avakwa ovok erogo inil hagup o,’ yiluk, yagan wasogon,” yugeragagi dirup mbanggigi ako ndatak Yohanes en yugeregek lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yugirigyama, avakwa wisane at adema wagagwa. It avakwa wisane en, “Nit ima wombabininapwak o,” yiluk, at adema homari lagagwa ako yugirigya dugwit, “Mbas edup aburi wigalek menda hit yi aro. Ala aninis okbigigya wasogon ako, hoda wolovovok yiluk, sa en hurimbis yukheraga? ");
INSERT INTO nbq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hit weyak ogasagwi ako, henasam hegep halok, yo enggen eyave yiliga andi hak, ndatak ogagu dogones. Hit henendawima en umbutu dugwit, ‘Averaham andi, nit nenombao atma, nit sek adigat agurik o,’ ombasagwi andi, anderogo ombarubuk. At Ala en, ‘Helep yi, at Averaham ombawi aru,’ yiluk, yugirigya halok, arup sek inigik, hit adigat iya dekma, nggarogo yiluk yagalagwi? ");
INSERT INTO nbq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yaga yo adema murumenda ovok agarik atma, yigyo ndigyo enggen yugudek halok, murogo halima mabayogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yugirigya lagagimu, avakwa ovok en, “Anderogo halok, nit nggarogo ogaruk?” ");
INSERT INTO nbq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yugu lagagwama, Yohanes en, “Hit henasum yikhedelagwi mberen werek halok, ap ambi asum dek halok, ambi wogugwis, eke, henagarom werek halok andi, anderogo wogirugwi, ogagu dogones,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yugirigya lagagirik, werekma, it pemerintah enake yoparip wonggalisagwi menda ako en ogo, “Ima wombabininapwak o,” yiluk, at adema wagu lagagwarik, “Ngguru wai. Nit nggarogo ogaruk o?” ");
INSERT INTO nbq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yugugu lagagwama, Yohanes en yugirigya dugwit, “Henasini en, ‘Yoparip anderogo hudi wongganggu dogones,’ yukheralagwi ako, adigat wongganggu dogones,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yugirigya lagagimu, it ap yegen werek menda ako en at yugugu dugwit, “Eke, nit ogo, nggarogo ogaruk?” yugugu lagagwama, Yohanes en, “Avakwa enangge wokneraupwak yiluk, henane anye vaga yugeraup andi moga. Eke huluk wene avakwa enovaga bisaup andi moga. Ata, yavup ogasagwi onggo wokhirugwi-selok, ‘Yi sek at wokneragao,’ yiluk, wugu dogones,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Andi yugeragagi ako, it avakwa ovok enendawi adenggen umbutu dugwit, “Avyak! At Ala en nenowa inis ombok denogo mendok okbayogon Keretus yagagi ako, at Yohanes yi ai?” umbutusim, ");
INSERT INTO nbq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohanes en it ovok yugirigya dugwit, “An we un is vaga adigat wombabigigaliga. Eke, At ambi wasogon ako andi, At mondok ombok aro. An horok atma, At arepatu nggolalup meyan o. At Averiniki inim, hali inim, henovaga bigiga warisogon. ");
INSERT INTO nbq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nggandum dinisagwima en ovok denbaluk, eyave halok, wonggalogo winimen ba inggya, eke, iluvulu halok, hali nagaup yagaligadekma lakbagya, ogarupwak yiluk, walup at inggimu vagogo agarik o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sek Wene ako it avakwa yugirigya dugwit, Yohanes en anderogo wene wisane enaruk watigi. ");
INSERT INTO nbq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Enaruk watya lagagimu, ap inis ombok Herodes ako en at owa ogwa Herodias ndiyanggya, eke, yi weyak ndi weyak wisane ogarit lagya, ogagya lagagimu, Yohanes en “Hat ogo weyak,” yiluk mberogogi. ");
INSERT INTO nbq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mberugu lagagimu, Herodes en yi weyak ndi weyak ogarit lagya dugwit, Yohanes eyave vagogo heda marogo mabiselagwima mabagagi andi, weyak ambi labok wisane ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yohanes en avakwa ovok ima wombabugu lagagirik, Yesus inim ima wombabagya lagagimu, Yesus samban ogagyama, mbogot heyatu lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Averiniki eyave swa wurum ovagak wigak yagan Yesus ovaga wambu wagagi. Ovaga wambu wagya lagagimu, mbogot-vaga en ane iri dugwit, “Hat nabut nendawi hunik atma, nendawi adenggen ogagya heyagi o,” yiluk, yugugu hagagi. ");
INSERT INTO nbq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus ogarigiluk wagagi ako 30 tahun okbaluk asinggigi. It avakwa en Yesus andi, Yusup abut umbutu lagagwa. Eke, Yusup andi, Eli abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli andi, Matat abut. Matat andi, Lewi abut. Lewi andi, Maliki abut. Maliki andi, Yanai abut. Yanai andi, Yusup abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusup andi, Matika abut. Matika andi, Amos abut. Amos andi, Nahum abut. Nahum andi, Heseli abut. Heseli andi, Nagai abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai andi, Mat abut. Mat andi, Matika abut. Matika andi, Simei abut. Simei andi, Yosek abut. Yosek andi, Yoda abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda andi, Yohanan abut. Yohanan andi, Eresa abut. Eresa andi, Serubavel abut. Serubavel andi, Selatiel abut. Selatiel andi, Neri abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri andi, Maliki abut. Maliki andi, Adi abut. Adi andi, Kosam abut. Kosam andi, Emadam abut. Emadam andi, Er abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er andi, Yosua abut. Yosua andi, Elieser abut. Elieser andi, Yorim abut. Yorim andi, Matat abut. Matat andi, Lewi abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi andi, Simeon abut. Simeon andi, Yakura abut. Yakura andi, Yusup abut. Yusup andi, Yonam abut. Yonam andi, Eliakim abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim andi, Meleya abut. Meleya andi, Mina abut. Mina andi, Matata abut. Matata andi, Natan abut. Natan andi, Daut abut. Daut andi, Isai abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Isai andi, Ovet abut. Ovet andi, Mboas abut. Mboas andi, Salomon abut. Salomon andi, Nahason abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason andi, Aminadap abut. Aminadap andi, Adimin abut. Adimin andi, Arini abut. Arini andi, Heseron abut. Heseron andi, Veres abut. Veres andi, Yakura abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yakura andi, Yakup abut. Yakup andi, Isak abut. Isak andi, Averaham abut. Averaham andi, Sera abut. Sera andi, Nahor abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor andi, Seruk abut. Seruk andi, Erehu abut. Erehu andi, Velek abut. Velek andi, Eber abut. Eber andi, Sela abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela andi, Kenan abut. Kenan andi, Arapakasat abut. Arapakasat andi, Sem abut. Sem andi, Nuh abut. Nuh andi, Lamek abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek andi, Metusala abut. Metusala andi, Henok abut. Henok andi, Yaret abut. Yaret andi, Mahalalel abut. Mahalalel andi, Kenan abut. ");
INSERT INTO nbq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan andi, Enos abut. Enos andi, Set abut. Set andi, Adam abut. Eke, Adam andi, Ala abut at. ");
INSERT INTO nbq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Averiniki ako Yesus endawima hobo-hobo ari nunggwigya lagagimu, is Yorodan ima en wunggu lagagimu, Averiniki en wolok o mbedama avakwa dekma andoma lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wolok lagya lagagirik, werekma, madis enasin Sile en At avut mbanggya hegek, ndugwis 40 hudi welagagi. Avut mbanggya hegek, Yesus erom nenggetek ndugwis 40 hari welagagirikmu, erom uvup agagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Erom uvup agagirik werekma, Sile ako wagya lagagirik, At yugugu dugwit, “Hat avyarat Ala abut halok, helep yi, erom arupwak yiluk, yuguru!” ");
INSERT INTO nbq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yugugu lagagimu, At Yesus en, “Ala en iri dugwit, ‘Avakwa erom adigat nunggu-selok, iniluk dogosogom dek o,’ yiluk, yugogogi dirup mbalek agarik.” ");
INSERT INTO nbq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yugugu lagagimu, at Sile ako en Yesus wolok ndom vaga inggya lagagirik, andoma en wen vaga yoma yi avakwa ndi avakwa ininis werek enavema biselagwima ovok erogo o bigavok yagaliga hak ambivaga inukhagagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Inukhiga lagagirik, “It ap ininis werek enavema biselagwima andi ovok sek halok, avakwa en, ‘Wi’, yagalagwi yi ako, an vagogo dogopwak yiluk, woknogogirikmu, an nendawi ombakluk en wogeraliga. ");
INSERT INTO nbq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Anderogo atma, hat navema seve yiluk, siyabaningga heyalok, hil hegen ako ovok erogo hat vagogo dogonyok yiluk, wokhisogon o.” ");
INSERT INTO nbq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yugugu lagagimu, at Yesus en, “Ala en iri dugwit, ‘Henasin Ala avema seve yiluk, at adigat siyabagwi, at yagaliga halok adigat dibaluk ogarit lagwi, ogagu dogones,’ yiluk, yugogogi dirup mbalek agarik.” ");
INSERT INTO nbq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Yugugu lagagimu, Sile en Yesus wolok o Yerusalem Ala awi valekma o virimu ba inggya lagagirik, Ala wene mbalek vaga yugugu dugwit, “‘Ala en it malaikat yonggo ako, Haruwam dogopwak yiluk, yugeramima wagu dogomundik, Helep vaga hisok hado yi wambigya hao en, Ininggis ndalek vaga enewogogo ari wambisogon o,’ yiluk, yugogogi dirup mbalek agarikma, hat Ala abut avyarat halok, yoma en soklok wambin.” ");
INSERT INTO nbq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yugugu lagagimu, at Yesus en, “Ala en iri dugwit, ‘Henasin Ala An navut mbalubuk,’ yagagi o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Yugugu lagagimu, at Sile en Yesus avut mbaligiluk ogagagi ako ovok at okbagya lagagirik, “Hivis yugurup ambi nanonggal werek agya hami a?” yiluk, hekbaluk, winggigi. ");
INSERT INTO nbq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Wunggu lagagimu, at Yesus ako Averiniki anye endawima dugwit eyami vaga o Nggaliliya lagagi. Lagya lagagirik, werekma, At avok ako o andoma ovok erogo wigak yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","O Nggaliliya andoma dugwit, it Yakuri samban ogasagwima wene mamuleregek lagya halok avakwa ovok erogo inis siyabagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Andi en, At Yesus sawe agagirikmu o Nasaret akoma lagagi. Lagya lagagirik, it Yakuri samban ogasagwi vaga it samban ogasagwima akoma nonggegek iri lagagi ndatak, at nunggwigya lagagirik, Ala wene dirup mbalek vaga bikhegek yugeragiluk, mendek yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mendek iri lagagimu, mbuku virik-verek ap navi Yesaya en Ala wene dirup mbanggigi Yesus wogogogi. Wogugu lagagimu, mbuku ako mbigalogo baluk Ala denogo mondok okbagagi Keretus ako avok yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“It avakwa ininggidek ako Sek Wene yugirigya dogopwak yiluk, denogo baninggigima, Nasin Ala Averiniki novaga agarik o. It avakwa heda mago agarwik ako, visilogo bisayogon o, yiluk, yugirigya, Inil mbuk ako, Hinil sek okbigigaup andi, ndak, yiluk, yugeregek lagya, It avakwa sovabisiluk agarwik ako wender erogo bugu, ");
INSERT INTO nbq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Eke, Nenasin Ala nenabwa en okbininaup ako, yogak yi at aga o, yiluk, yagan lagya, ogagya dogopwak yiluk, lakbani waga,” yiluk, yagagi dirup mbanggigi ako heyak bagya lagagirik, bikhegek yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Wene ako ovok yugirigya lagagirik, mbuku ako yunggulogo yonggaragak wogugu lagagirik hora yagagi. Hora iri lagagimu, it avakwa Yakuri samban ogasagwima homagagwa ako, ovok erogo inil At adigat vurek welagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Inil vurek werekma, Yesus en it yugirigya dugwit, “Ala wene dirup mbalek bikhegek yukhirigi ako, o yogak yi henaruk hunggu hinigik, atma des yagas o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yugirigya lagagimu, it avakwa ovok en, “Ap yi iya,” yiluk, At wene eve sek iri halok, “Wi!” yiluk, vok yagagwa ovara, irenen at umbutu dugwit, “A! Yi adik, Yusup abut ako dek?” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yugu lagagwama, Yesus en it yugirigya dugwit, “It avakwa en, ‘Dokter wai. Hat heyave sek okhedomano,’ mbilape yagalagwi ako, eke, ‘O Kaperenaum ogagya lagen, hunggup ako, hat hawi adem vaga endaklagagindikmu yoma anderogo ogagya dogwen,’ an yuknirup yiluk, yugu hinigis.” ");
INSERT INTO nbq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yugirigya lagagirik, “Henaruk vipak holek dogones! It ap navi-navi enawi adem vaga dugwit, Ala en yugirigya hegek yugurugu-selok, enowa-enasin en enane sek erogo hulisagwi dek o, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ap Elia eyom vaga musu nenggetek hegek, tiga setengah tahun vaga yi awi ndi awi ovok erogo erom uvup werekma, Iserael enamwa andoma akwa sogwa eneyave wisane welagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ala en ap Elia ako akwa sogwa Iserael menda ambi enadema lapwak yiluk, lakbagetek. Ata, hwa sogwa ambi o Tiron kota Saravat Yakuri dek menda werekma, adema lakbagagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eke, navi Elisa eyom vaga avakwa Iserael enamwa andoma amu hunik wisane welagagwa ovara, it ambi amu hunik sek okbigitek aro. Ap Naaman o Siriya Yakuri dek menda ako, adik at amu hunik sek okbagagi o, yiluk, avyarat yukheraliga.” ");
INSERT INTO nbq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yugeragagi ako it ap Yakuri samban ogasagwima welagagwa ako ovok enaruk hunggu lagagwarik, Yesus en ambi okbininayogon buk yedok hugu lagagwarik, enaninis wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Enaninis wisane agu lagagwarik, mendek yiluk, At eyave enamwa en vagogo wasim wibagu lagagwarik, enawi awek andugumu valekma, vedalogo wombaba laguluk, wolok lagusim, ");
INSERT INTO nbq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","it ovok andenam inigik enanggelekma en winggigi. ");
INSERT INTO nbq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Andi en, vivis, o Nggaliliya kota ambi Kaperenaum lagagi. Lagya lagagirik, it Yakuri samban ogasagwi vaga wene mamulirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wene mamulirigya dugwit, at ane anye vaga yugirigyama, avakwa en, “Wi!” yiluk, enalon agagwa. ");
INSERT INTO nbq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ndugwis ambi vaga ap ambi madis edup agoda werek endawima nonggagagirikmu, it Yakuri samban ogasagwima welagagi. At ap ako ane naik hunik iri dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesus wai. Hat ap Nasaret menda nit madis nggarogo okbininagiluk wagen? Nit dek okbininigiluk wagen a? Hat Ala abut mondok weyak ogasigadek sek adik denek agindik ako, hat an nelup aro”. ");
INSERT INTO nbq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yugugu lagagimu, Yesus en mberugu dugwit, “Hane dek wilin!” Yugugu lagagimu, madis ako en ap eyave avakwa enanggelekma wen vaga andoma ndun okbagya lagagirik, eyave edup yagan watitek hegek, madis nggigilogo winggigi. ");
INSERT INTO nbq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nggigilogo wunggu lagagimu, avakwa ovok enalon en, “Wi!” yiluk, at ambi en at ambi yugigik yugu dugwit, “Avyak! Ap yi, ane yagaliga, ayai! At ane avuput anye vaga madis edup agoda werek menda, ‘Wilin,’ yugirigya halok, wibisaliga wi!” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eke, Yesus avok ako o andoma ovok erogo wigak yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","At Yesus it Yakuri samban ogasagwima en wunggu lagagirik, Simon amwa lagagi. Lagya lagagirik, Simon ogwa isa aup sogwes-sogwes wisane werekma, Yesus en sek ogarupwak yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yugugu lagagwama, at eyave nogo yiligama lagya lagagirik, alilimu mendek dugwit, “Aup edup dek aru,” ao yugugu hegek, dek agagi. Dek agya lagagimu, hwa ako mbikit mendek yiluk, it enake ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Andi hudi vaga, o mo il huruk irisim, avakwa en enaswei aup edup adik-adik warek werekma, wogonombolok Yesus adema bisa wagagwa. Bisa wagu lagagwama, it ovok erogo inggis vakbugu dugwit, sek okbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eke, it avakwa ovok madis enendawima nonggagagi ako ogo, sek okbugu dugwit, “Wilitales!” yiluk, madis ako yugirigya lagagimu, enane na yugu dugwit, “Ala abut harat o!” yiluk, nggigilogo wunggugwa. Ala en ap inis ombok denogo mondok okbagagi Keretus ako enelupma, enane yugu-sigik ovara, at Yesus en mberirigya dugwit, “Henane ambi yup mondok dek!” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","O hutun, mo il nggao iri lagagimu, Yesus o andoma en wunggu lagagirik, avakwa dekma lagagi. Lagagi ovara, it avakwa wisane en At belanggugwa. Belanggu lagagwarik, inim dogoguluk, sovabasogon yiluk ogagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yesus en it yugirigya dugwit, “Ala denogo mendok okbagagi ako avakwa at avema dogopwak yiluk sup hutbayogon Sek Wene ako, o kota nin inim yugeregek lagya dogogiluk, lakbani wagagirikmu, mondok yugeregek landiga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yugirigya lagagirik, o Yudea it Yakuri samban ogasagwima dombok akoma yugeregek nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Andi en, hivis ndugwis ambi vaga At Yesus ako inamut Nggenesaret yanggadek omban vaga mendek werekma, it avakwa wisane Ala wene enaruk huluguluk, hobo-hobo homari wagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hobo-hobo homari wagu lagagwama, Yesus en it ap ikan wasagwi menda enamburis mberen is omban vaga bago hagagi. It ap ikan wasagwi menda ako en enamburis hekbaluk, yum yarin ikan wasagwi menda ako hutusim, mburis hagagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Higya lagagirik, mburis ambi Simon amburis ako vaga nunggwigya lagagirik, Simon yugugu dugwit, “Is ombanma horok ambukum vanggo yi nunggusogom,” yiluk, nunggugu lagagwarik, Simon iperen mburi-vaga horaik dugwit, it avakwa wisane homago ako wene mamuleragagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wene mamulirigya lagagirik, Simon aswei inim yugirigya dugwit, “Is agurukmu andenam ari nunggugu dogomundik, ikan warovovok yiluk, heneyarin ako wombaba lales.” ");
INSERT INTO nbq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wombaba lales yugirigya lagagimu, Simon en, “Ai, Nasin. O hup en wombanggusat ninigik o yanggo yagas ambiat ogo mondok watitek at, ovara, yuknirigindikmu, wombaba lasogom o.” ");
INSERT INTO nbq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yiluk, wombaba lagagwarikmu, ikan mondok wisane erogo watu lagagwama, yarin ako mondok libis iri menda ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yarin ako mondok libis iri menda agya lagagimu, enaswei nin mburis ambi vaga akoma werekma yonggwarinivi warupwak yiluk, ininggi wene vaga yugurugu lagagwama, wagu lagagwarik, ikan warogo mburis mberen mbin erogo bagagwama, anggin en mburis mberen is endawima sovalivilip. ");
INSERT INTO nbq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Peterus en mburis ako sovanggya menda higya lagagirik, Yesus avema seve yiluk, “Nasin o. An ap yi mondok weyak ogasiga mendama, baniluk wilin o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yugogogi andi, ikan wisane watugwa ako vaga at aswei inim mondok vok yagagwa yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simon aswei Yakubus Yohanes, Sevedius aburi iperen ako inim vok yagagwa. Eke, Yesus en Simon yugugu dugwit, “Halon habuk. Hat ikan belalogo wasiga hak, o yogak en avakwa belalinipu dogosogon,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yugugu lagagimu, mburis ako is omban vaga bagu lagagwarik, yi menda ndi menda ovok erogo hekbaluk, Yesus inim lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Andi en, hivis ndugwis ambi vaga Yesus o kota ambima werekma, ap ambi amu hunik welagagi. Ap ako Yesus il higya lagagirik, elese wen vaga samup yiluk nggino yugugu dugwit, “Ai, Nasin. Haren sek okbanup imbita heyalok, ndak sek okbanup o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yugugu lagagimu, Yesus inggis welalogo vagatya dugwit, “Sek okbagaup imbitirikmu, sek aru!” wene ao yugugu hegek, at amu hunik ako dek agagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dek agya lagagimu, Yesus en, “Avakwa mondok yugerabuk. At imam en il heyaupwak yiluk, adema elak. An sek okbagagirikmu, Musa en, ‘Ala ake anderogo baup,’ yagagi ako, it avakwa en bagya heyaupwak yiluk, belak,” yiluk, aruk warogo lakbalagagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aruk warogo lakbalagagi ovara, Yesus ogarit landiga wene ako evenuk wigak iri lagagimu, yi avakwa ndi avakwa wisane At ane hunggwis, edup-mbedup halok eneyave sek okbugu, ogarupwak yiluk, At adema homari wagek yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Anderogo ogagu lagagwa ovara, Yesus o avakwa dekma akoma wunggu lagagirik, samban ogari lagek ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ndugwis ambi vaga Yesus umwa en wene mamulirigyama, it ap Parisi menda inim, it ap Musa wene mbalek mamulerelagwi menda inim, yi awi ndi awi o Nggaliliya en, Yudea en, Yerusalem en, wagu lagagwarik, we ugun horaik dugwit, Yesus ane hunggu lagagwa. Avakwa aup warek sek oginivupwak yiluk, Nenasin Ala anye ako Yesus okbagya hegek, ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Akoma werekma, ap ambi inggis-isok yidugup werekma, ap en yo duriluk, Yesus adema ba nungguluk, ogagagwa menda ");
INSERT INTO nbq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","it avakwa ovok hobo-hobo erek werekma, ba nunggup meyan agya lagagimu, wolok o winimen o viril vaga unggugwa. Unggu lagagwarik, viril heyarogo yo durik enewogo avakwa ovok enanggelekma Yesus adema wombabagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wombabagu lagagwama, Yesus en it enendawi at ovaga vanggabaluk, avyarat umbutwi yedok inugu lagagirik, ap ako yugugu dugwit, “Avyak! Hat homaduk dek erogo bagagi.” ");
INSERT INTO nbq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yugugu lagagimu, it ap Musa wene mbalek mamulerelagwi menda ako inim, it ap Parisi menda inim, iren enendawi umbutu dugwit, “A! Nit nenomaduk dek erogo biniliga ako At Ala adigat agarik. Ambi inim dek. Ap Ala wiyiknom-weyaknom erogo baliga yi sa embetep?” yiluk, umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Enendawi umbutwi ako Yesus yedok inugu lagagirik, yugirigya dugwit, “Hit nggarogo yiluk henendawi anderogo winggilisagwi? ");
INSERT INTO nbq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Homaduk dek erogo bagagi,’ yugurup andi, iya a, ata ‘Mendek yiluk lagya dogwen,’ yugurup andi, iya a? Hit eres!” ");
INSERT INTO nbq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yugirigya lagagirik, “An Ap At Endaklagagis wen vaga yoma dugwit, avakwa enomaduk dek erogo bisapwak en yiluk, Ala en An yuknogogi ako hinilup arovovok yiluk sek okbayogon,” yiluk, yugeragagi. Yugirigya lagagirik, ap inggis-isok yidugup ako yugugu dugwit, “Mendek iri dogomindik, hat hagone ndalek nogo yiliga menda ako, hedelok hamwa wilinok yiluk, yukhisiga.” ");
INSERT INTO nbq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ao yugugu hegek, ap ako it ovok erogo inivaga mendek iri lagagirik, at agone ndalek nogo yiliga menda ako hedelok amwa wunggu dugwit, Ala inis siyabagek lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ako lagya hegek, it ogagya hagagwa ako vaga Ala inis siyabagu dugwit, “Yogak ninil helagudek menda higyoma, nenalon wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Andi en, Yesus wunggu lagagirik, ap pemerintah enake yoparip wonggalisiga menda ambi inis Lewi yoparip wonggalisagwima horaik il hagagi. Higya lagagirik, Yesus en at yugugu dugwit, “Ninim lasogom, oma,” ");
INSERT INTO nbq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","yugugu lagagimu, at Lewi ako yi menda ndi menda ovok erogo hekbaluk, mendek iri lagagirik, Yesus inim lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Andi en, ap Lewi ako at amwa Yesus adenggen isogo ombok isagagi. Isagagirikmu, it avakwa homago wisane ap pemerintah enake yoparip wonggalisagwi menda inim, avakwa nin inim, Yesus Lewi inim erom nunggusim, ");
INSERT INTO nbq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","it ap Parisi menda inim, ap Parisi menda Musa wene mamulerelagwi menda inim, iren Yesus ane welagwi menda ako enanggin-enanggon yiluk, yugurugu dugwit, “A! It pemerintah enake yoparip wonggalisagwi menda inim, it weyak ogasagwi menda nin inim, hit nggarogo yiluk hinim dambulik dugwit erom is nelagwi?” ");
INSERT INTO nbq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yugurugu lagagwama, At Yesus en, it yugirigya dugwit, “It ap aup edup dek halok andi, ap ndokter adema laup ombasagudek. Ata, aup edup halok sek oginivupwak yiluk, ndokter adema laup ombasagwi. ");
INSERT INTO nbq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Andi ndatak, Anen it ap ‘An sek’ ombasagwi menda eneyanggup yugeragiluk wagatek. Ata, it weyak ogasagwi menda enasam helok, enomaduk mbo baupwak yiluk, eneyanggup yugera wagagis o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yugirigya lagagimu, it ap Parisi menda ako en Yesus yugugu dugwit, “It ap Yohanes ane welagwi menda andi, Ala ake yiluk, erom hunis dugwit, samban ogasagwi. Eke, nit ap Parisi nenane welagwi menda andi, anderogo ogasagwi ovara, hat hane welagwi menda andi, we ugun erom nunggwi, is ugun nunggwi, ogagu-selagwi.” ");
INSERT INTO nbq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yugu lagagwama, Yesus en, “Ap ogwa hidigyama, owa-asin inim isogo isagu dugwit, ‘Hit erom nenggetek dogones,’ yiluk, owa-asin yugeraup sek embetep? Dek! ");
INSERT INTO nbq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Owa-asin inigik, agun wolok laup vanggo yi wagya ako vaga andi, erom hunis dogosogom,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yugirigya lagagirik, wene wakhegek yugirigya dugwit, “Yum hain swi menda ambi libilogo yum mbadis endak menda ambi vaga lobalogo monggadisagwidek. Lobalogo monggatu halok, yum hain swi libilisagwi ako weyak asiga. Eke, yum swi menda ako, yum endak menda vaga lobalogo monggadek halok, elese iperen ndatak asigadek adik asiga. Anderogoma, yum hain swi menda ambi libilogo yum mbadis endak menda ako vaga lobalogo monggadesagudek o.” ");
INSERT INTO nbq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yugirigya lagagirik, wene wakhegek ambi iri dugwit, “Anggur amburup swi menda iwak kambin agamut endak ogovak higirik vaga, nudisagudek. Anggur amburup swi menda iwak kambin agamut endak ogovak higirik vaga nudup halok, anggur amburup swi menda en iwak endak menda ako viklagya dugwit, yanggalandiga. Yanggalagya dugwit, anggur amburup dek agya, eke, iwak ako weyak agya, oklandigama, anggur amburup swi menda iwak kambin agamut endak ogovak higirik vaga, nudisagudek. ");
INSERT INTO nbq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Anggur amburup swi menda andi, iwak kambin agamut swi ogovak higirik vaga adigat nudisagwi. ");
INSERT INTO nbq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Eke, anggur amburup endak menda andi, ‘Ai weyak,’ yiluk, yagalagwima, anggur amburup endak menda nelok, swi menda, ‘Wokniru,’ yiluk, yagalagwidek o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ndugwis ambi it ap Yakuri samban ogasagwi vaga Yesus ane welagwi menda inim gandum yagoma sup vaga lagu dugwit, At ane welagwi menda en gandum ininggis vaga mbalogombo agamut bonggalogo wikbagek nenggek lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nenggek lagu-selok, it Parisi menda nin en, “Samban ogasagwi vaga yavup anderogo ogarup moga yugup hegek, hit nggarogo yiluk ogasagwi?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yugurugu lagagwama, Yesus en, “Wene at Daut arwi inim, erom uvup dugwit, ogagagwa wene ako, Ala wene mbalek vaga hit bikhegetek dugwit yagalagwi yei? ");
INSERT INTO nbq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","At Daut ako Ala awi valekma nunggigya lagagirik, roti Ala ake bago ako it ugun naup moga, it imam-imam halok adigat nunggu dogop yugup hegek ovara, wogogo ninggya lagagirik, nin at inim lagagwa ako wogoragagi, wene dirup mbalek ako hit bikhegetek agipik yei? Naup moga hegek nunggugwa ovara, Ala en mbet yugeragagibuk,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yugirigya lagagirik, “Samban ogasagwi vaga yerogo ogarup nderogo ogarup yugu dogop andok ako andi, An Ap At Endaklagagis aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Andi en, ndugwis ambi Yakuri samban ogasagwi vaga Yesus ako it samban ogasagwima nunggwigya lagagirik, wene mamuleragagi. Wene mamulirigyama, ap inggis amot weyak nggorak ovagak andenam werekma, ");
INSERT INTO nbq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yesus wene mamulirigya hegek, it ap Musa wene mbalek mamulerelagwi menda inim, it ap Parisi menda inim, iren, enane wonggalogo At ovaga baguluk, “Yesus samban ogasagwi vaga yavup ogarup moga yugup hegek ap sek ogagya hamwi a?” yiluk, inil bik-bak ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Inil bik-bak ogagu-sigik, it umbutwi ako Yesus yedok inugu lagagirik, ap inggis weyak ako yugugu dugwit, “Mendek yiluk, ilim yenam oma,” yugugu lagagimu, ap ako mendek yiluk, ilim mendek yi lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mendek yi lagya lagagimu, Yesus en it yugurigya dugwit, “Samban ogasagwi vaga sek oginivup andi, sek a, ata weyak oginivup andi, sek a? Avakwa eneyave inidi yup andi, sek a, ata enarup andi, sek a? Hit eres!” yiluk, ");
INSERT INTO nbq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","it ovok erogo il dombalinipu lagagirik, ap ako yugugu dugwit, “Hinggis ngges okhanen,” yugugu lagagimu, ngges okhigya lagagirik, inggis mondok sek agagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Inggis mondok sek agagi ovara, it andi, enendawi enaninis wisane agya dugwit, “Yesus nggarogo okbauk?” yiluk, wene mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Andi hudi vaga Yesus samban ogarigiluk, hulikmu inggigi. Inggya lagagirik, o hup Ala yugugu hegek, o yanggo yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","O yanggo iri lagagimu, At ane welagwi menda ako warupwak yiluk, yanggup yugeragagi, wagu lagagwama, ap eneyave 12 miginipu lagagirik, ininis “Lakbigik menda”, sabigigi. ");
INSERT INTO nbq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","It miginipigi ako andi yi: Simon inis ambi Peterus sanggigi ako inim, at Simon aot Andereas inim, Yakubus inim, Yohanes inim, Pilipus inim, Mbarotolomeus inim, ");
INSERT INTO nbq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius inim, Tomas inim, Alepius abut Yakubus inim, Simon ap Selot menda inim, ");
INSERT INTO nbq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yakubus adik menda ambi abut Yudas inim, eke, Yudas Ikariot Yesus hivis warupwak yiluk onggo hunggigi ako inim, miginipigi. ");
INSERT INTO nbq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","At Yesus ap miginipigi ako inim hulikmu en wambu wagu lagagwarik, o huris vaga andoma mbup yagagwa. Mbup yugu lagagwama, At ane welagwi menda wisane inim, avakwa nin evena o Yudea en, o kota Yerusalem en, o Tirus Sidon is yanggadek laut amban vaga akoma en, ");
INSERT INTO nbq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yesus ane hunggwis, aup edup iniselok sek okbugu, ogarupwak yiluk, At adema homari wagagwa. Eke, it avakwa madis edup agoda werek menda enendawima nonggegek ogagu lagagwa ako sek okbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yesus anye endawima agarik ako wulu wagya dugwit, avakwa sek ogonivit lagyama, it avakwa ovok erogo sek arusogon yiluk, Yesus ininggis vakhaguluk, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Anderogo ogasagwima, Yesus en At ane welagwi menda ako il biginigu lagagirik, yugirigya dugwit, “Hit ap henangge dek yi, Ala en hit at avema bigigaliga atma, Henendawi adenggen umbutu dogosogom o. ");
INSERT INTO nbq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hit yogak uvup agipik yi, henagaum asogonma, Henendawi adenggen umbutu dogosogom. Hit yogak yup yasagwi yi, enda yarup okhivinisogonma, Henendawi adenggen umbutu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","It avakwa yi, enombawi en navi-navi weyak okbugu lagagwa ako ovagak, An Ap At Endaklagagis ako nane wegep vaga enanggon adigat hinumbutu dugwit, ‘Hit nit menda dek,’ yiluk, hekbugugwis, wiyiknom-weyaknom erogo bugugwis, ‘Ap yi weyak o,’ yiluk, hininis sovabugugwis, ogagu-selok, henendawi adenggen umbutu dogosogom. Henake ago mbogot vaga wisane agarik atma, anggin anderogo okbugugu-selok, henendawi adenggen en agasogot wugu dugwit ndawi luvuk yugu dogop. ");
INSERT INTO nbq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Eke, hit hininggis werek yi andi, henendawi ugun wadokdek sek welagupikmu, anggin henovaga arugup! ");
INSERT INTO nbq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hit yogak henagaum agipik yi, hivis uvup arugup! Hit yogak enda yasagwi yi, hivis henendawi burup agya dugwit, yup yagu dogogup! ");
INSERT INTO nbq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","It avakwa yi, enombawi en ap Ala inis vaga huluk wene yugurugu-sigik ovara, siyabugu lagagwa ako ndatak, it ap ovok en hininis siyabugugu-selok anggin henovaga arugup!” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yugirigya lagagirik Yesus en ambi yugirigya dugwit, “Hit an nane henaruk holek agipik yi, wene ambi yukherayogon. It hinim ogorek agipik andi, henendawi hunik okbugwis, enanggon henombasagwi ako sek okbugwis, ");
INSERT INTO nbq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","it homan okbugugwis ako, Ala en adenggen okbisapwak yiluk, yugugwis, it weyak okbigelagwi ako, enake samban ogagwi, ogagu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Eke, henelagandin venak vaga henatwis-selok, venak enakbatugwi, henasum sogwes yum wugu-selok, henasum bayu yirik idi yubuk. Ata, inim wogorugwi, ");
INSERT INTO nbq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","nggino yukirugu-selok, wogorugwi, ogagu dogones. Henangge wugu-selok, Wokneres, yugeraup andi moga. ");
INSERT INTO nbq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hiren, ‘Anderogo okbininup sek ai,’ ombasagwi ako ndatak avakwa sek adigat okbigik lagu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","It henabwa ombasagwi ako, enadigat hit henendawi hunik okbugu halok, onggo ngga hedaup embetep? Dek o. It weyak ogasagwi menda ogo, enabwa ombasagwi menda ako enendawi hunik okbiselagwi. Anderogo atma, it henabwa ombasagwi dek menda inim henendawi hunik oginipu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","It hinim yonggat-yonggat yagalagwi ako, hiren it enadigat sek okbugu hiniselok, onggo ngga hedaup embetep? Dek o. It weyak ogasagwi menda ogo, it yonggat-yonggat yagalagwi menda sek okbiselagwi. Anderogo atma, it yonggathinivisagwidek menda inim, sek okbugu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hiren, ‘Hivis ndatak woknerasogom,’ umbutu dugwit, henaswei wogorugu hiniselok, andi vaga nggarogo okhedaup embetep? Mondok dek. It ap weyak ogasagwi ako en, ‘Hivis ndatak woknerasogom o,’ yiluk, enaswei wogerelagwi. Anderogo atma, ‘Hivis ndatak woknerasogom,’ embetetek dugwit, ugun at wogurugu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","At Mondok Siyalek Dombok Agarik ako en it ap weyak menda enendawi lakot dambe-vambe erek agarwik ako enabwa ombasiga. Enabwa ombasiga atma, hit ogo, it hinim ogorek agipik ako enabwa umbutu dugwit, sek okbugwis, eke ‘Hivis woknerasogom,’ embetetek dugwit, ugun wogorugwi, ogagu dogones. Ogagu hiniselok, ‘Hit An naburi aro,’ yiluk, onggo mondok iya erogo wokhirigya hagup o. ");
INSERT INTO nbq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Henasin en avakwa aigwak abet en sek okbisaliga hak, hit ndatak avakwa henaigwak abet en sek okbigik lagu dogones,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yugirigya lagagirik, ambi yugirigya dugwit, “Hit henane anye vaga avakwa enowak dilubuk. Henane anye vaga enowak dinggitek hiniselok, hit ogo, Ala en ane anye vaga henowak dilisogonbuk. Eke, hiren avakwa ‘Hit weyak o,’ yiluk, anggin enovaga bisabuk. ‘Hit weyak o,’ yiluk, anggin enovaga bigitek hiniselok, Ala en ‘Hit weyak o,’ yiluk, anggin henovaga bigigayogon buk. Eke, hiren it avakwa weyak okbigelagwi ako enomaduk dek erogo bugu dogones. Enomaduk dek erogo bugu hiniselok, Ala en hit henomaduk dek erogo bigigayogon. ");
INSERT INTO nbq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ugun wogorugwi hiniselok, ugun at wokhirigya hagup o. Sogolowak elola mbin erogo yekbaluk, nggwe-nggwes ogagya, sovalogo wombabagya, okbaluk, nggilup-nggilup wambigya hegek, henadema ndilogo wokherelagwi hak, ndatak wokhirigya hagup o. Wakhegek ako vaga wakhelok avakwa wogerelagwi ako andi, ndatak wakhelok wokhirigya hagup o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yugirigya lagagirik, wene wakhegek ambi yugirigya dugwit, “It ap inil mbuk ir-it ininggi vapak laup sek embetep? Eke iperen nggilin eloma nggedek wambup dek embetep? ");
INSERT INTO nbq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","It wene mamulerelagwi ako sovalek inigik, wene mamulhedelagwi ako siyalek agarwikbuk. It mamulhedelagwi ako mondok mamulhidugu dogomundik andi, it mamulerelagwi ndatak dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Yo agako mbalek hinimu winik agarik ako dibagetek dugwit, hit henaswe yo iluvulu imu nonggagas ako nggarogonggan dibelagwi? ");
INSERT INTO nbq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Eke, yo agako mbalek hit hinimu wikhegetek dugwit, ‘Naswe. Yo iluvulu himu nonggagas ako wikheyayogon,’ andi nggarogonggan yugurup embetep? Ee! Henagavoval yagalagwi! Yo agako mbalek hit hinimu winik agarik ako endak wikhelok, henaswe imu wikhaup andi, sek hagup o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wene wakhegek ambi yugirigya dugwit, “Yo sek menda en yo enggen weyak menda yiligadek. Eke, yo weyak menda en yo enggen sek menda yiligadek. ");
INSERT INTO nbq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yi yo ndi yo eyave enggen yiliga vaga enelup asagwi. Hit yo widis enggen ako yo bondo adok-adok vaga yugumu heralisagudek. Eke, anggur enggen ako heda sogonaik vaga yugumu welagudek. ");
INSERT INTO nbq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ap sek menda endawima enggen yugup sek menda ako vaga sek adigat ogasiga. Eke, ap weyak menda endawima enggen yugup weyak menda ako vaga weyak adigat ogasiga. Endawima en nggeker-erek wunggu dugwit, abis vaga en yagaliga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yugirigya lagagirik, ambi yugirigya dugwit, “Hit An yukheraliga ako ogagetek dugwit, nggarogo yiluk, ‘Ai, Nasin! Ai, Nasin!’ adigat yuknisagwi? ");
INSERT INTO nbq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","It avakwa An nadema wagu lagarwik, An nane hobaluk, ogasagwi hak yukherayogon. ");
INSERT INTO nbq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ap o valisagwi ako ovagak, it aro. Ap ambi wen ilim erogo bavunggu lagagirik, helep owak ndalek vaga owak wombabagagi. Wombabagagirikmu, hivis is nggut ogakluk wagya dugwit, o valek masaligiluk ogagagi menda owak modo erogo wombalekma, wadokdek welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Andi wadokdek welagagi ovara, it ap An nane hobaluk, ogasagudek ako andi, ap ambi o owak wen ilim erogo wombabagatekma un ovaga wombabaluk o vanggigigirikmu, is nggut ogakluk wagya dugwit, yigitik-wagatik danggo erogo wolok wunggu dugwit, mondok masalogo bagagi ako ovagak it aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus avakwa inivaga wene ovok yugirigya lagagirik, o Kaperenaum lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lagya lagagirik, werekma, it ap yegen werek menda enasin ambi ayeloman mondok endawi hunikmu, aup edup mondok hambigiluk ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ap yegen werek menda enasin ako ap Yakuri dek weram menda. Aren Yesus ogarit lagya aruk hunggu lagagirik, ayeloman sek okba warupwak yiluk, Yakuri enasini nin yuguri laupwak yiluk yonggo lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Yonggo Yesus adema lakbogogi, lagu lagagwarik, it Yakuri enasini ako en enane enabwa edik enabwa edok seve erogo Yesus yugugu dugwit, “Ai, at ap yegen werek menda enasin andi, nit avakwa Yakuri menda ninim endawi mondok hunik okninivisigama, eke, arenen nit Yakuri samban ogasagwima o vabininggigirikmu, anderogo atma, ayeloman sek ogari laup andi sek o.” ");
INSERT INTO nbq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yugugu lagagwama, Yesus inim lagagwa. It ako ao enamwa ari wagetekma, ap yegen werek enasin ako en asweimuni it nin yonggo lakbogogi. Lakbogogi, Yesus adema lagu lagagwarik, “Ai, Nenasin! Ap nenaswe yegen werek en iri dugwit, ‘At un anggodo warugwi en. An ap madukma, Yesus an namwa nunggu warup meyan. ");
INSERT INTO nbq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Eke, an ap horok atma, At adema laup ogo, embetetek. Ata, sup vaga lagya dugwit “Sek aru,” ane iri halok nayeloman sek asogon. ");
INSERT INTO nbq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","An ogo, nasini enavema dugwit, enane hunggu, eke, an narwi yegen werek ako navema dugwit, an nane hunggwis, ogasagwima, narwi ambi, “Elak,” yugugu neyalok andi, lagya, ambi, “Oma,” yugugu neyalok andi, wagya, eke, nayeloman, “Yi ogaru,” yugugu neyalok andi, ogagya, ogasagwima, Yesus ogo “Sek aru,” iri halok, atma asogon, yiluk, yuguri elales,’ yiluk, lakbinina wagarikmu yukhisagwi,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yugogogwa Yesus aruk hunggu lagagirik, “An avyarat nembetas, wi!” yiluk, vok yagagi. Vok iri lagagirik, avakwa At ambetaga lagwi ako ena endenogo biginigu dugwit, “It avakwa Iserael menda ogo, nin horok at avyarat numbutu-sigik, at weram Yakuri dek menda andi adigat novaga vanggabaluk avyarat ombok erogo nembetas, yiluk, yukheraliga.” ");
INSERT INTO nbq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yugirigya lagagimu, yonggo lagagwa ako eneyami vaga enamwa wagu lagagwarik, ayeloman aup warek ako vage sek agagirik werekma, ha wagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Andi en, hivis Yesus o kota ambi inis Nain lagyama, At ane welagwi menda inim, avakwa wisane inim, lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","O kota sup mbanggut leget wogoma ari lagusim, hwa sogwa ambi eyak ap adik ambenggama hambigya lagagimu, yo duriluk wulu wagusim, it avakwa wisane o kota andoma agarwik inim, isa inim, lagu sogogi. ");
INSERT INTO nbq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nenasin Yesus en hwa ako higya lagagirik, abwa wisane imbitya dugwit, “Yup yagya buk,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yugugu lagagirik, apsawe nggorak yo durik wolok wagusim vanggo yi lagya lagagirik, inggis vagatigi. Inggis vagatya lagagimu, apsawe yo durik wolok wagwi ako mbup yugu lagagwama, Yesus en, “Nabut! Hiluk aru! An Yesus en yukhisiga.” ");
INSERT INTO nbq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yugugu lagagimu, apsawe hombagagi ako iluk akluk yo durik ako vaga hora iri lagagirik, ane yagagi. Ane iri lagagimu, Yesus en apsawe ako isa wogogogi. ");
INSERT INTO nbq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wogugu lagagimu, it avakwa wisane enalon akluk, Ala siyabagu dugwit, “Ap navi Ala en yugugu hegek yugeraliga menda ombok ambi nenanggelekma en mendek yagas o,” yugu lagagwarik, “At Ala en at aburi bikninisa waga higyo o,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eke, Yesus ogagagi wene ako o Yudea avilis ambot ovok wigalagagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yesus ogagagi wene yagan nagwis ako Yohanes ane welagwi menda en Yohanes heda mago werekma yugiri lagagwa. Yugiri lagu lagagwama, Yohanes en at ane welagwi menda mberen yanggup yugirigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","wagu lagagwama, it yugirigya dugwit, “At warup ako arat waga a, ata adik ambi wasogon yiluk sokhugu dogomwi a? Yesus ako hemetha elales,” yiluk, At Nenasin adema lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lakbogogi ako Yesus adema lagu lagagwarik, At yugugu dugwit, “Ap Ima Wombabisaliga menda Yohanes en yuknirigya dugwit, ‘Ala en lakba warup yagagi ako harat wagen a, ata adik ambi wasogon yiluk, sokhugu dogomwi a?’ yiluk, hemetha elales, yuknirigya lagama, yukhiri wagyo,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","O andi hudi Yesus en avakwa wisane aup warek inim, aup edup yagan warit lagwi inim, madis edup agoda werek enendawima nonggagagi inim, sek okbugu, inil mbuk wisane sek okbugu, ogagyama, lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lagagwa ako en Yesus yugugu lagagwama, Yesus en, “Ogagya hinil neyagep inim, yagan lagya henaruk hunggip inim, andi, heneyami vaga Yohanes yuguri elales. Inil mbuk menda inil hugwi, inisok weyak menda sup sek erogo lagwi, amu hunik menda sek agwi, enaruk nggulup menda enaruk hunggwis, nggorak menda iniluk erogo bugu, eke, ap ininggi dek ako Sek Wene yugirigya, ogasiga ako yuguri elales. ");
INSERT INTO nbq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Eke, hit An henanggon nombakluk hekbanenggetek halok andi, Ala en adenggen okbugugu dogosogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yugirigya lagagimu, it Yohanes en yonggo lakbogogi ako enamwa lagu-sigik, Yesus en Yohanes avok avakwa yugirigya dugwit, “Hit nano menda haguluk, o mbedama avakwa dekma lagep? Don angga havut en wolok lagek-wagek yagaliga hak, ap endawi ndaik anderogo haguluk, lagep? ");
INSERT INTO nbq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Dek! Ap endawi modo haguluk lagep. Nano menda haguluk lagep? Ap ambi asum sek yirik haguluk, lagep? Avyak! It enasum sek adigat yikhidugwi, segedok amburup werek menda adigat nunggwi, ogasagwi ako andi, ap ininis ombok enamwa akoma adigat agarwik. ");
INSERT INTO nbq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nano haguluk, lagep? Ap navi Ala en yugirigya hegek yugeraliga menda ambi haguluk, lagep? Avyak! Hit hegep ako andi, at navi ovara, it navi nin andi, un sovalek inigik, at ako andi, mondok iya dombok hegep, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","At Ala en iri dugwit, ‘Hat laup sup yarogo bagaupwak yiluk, Anen yonggo endak lakbagya hil neyayogon,’ yiluk, yagagi dirup mbalek ako andi, at Yohanes yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yi avakwa ndi avakwa enanggelekma en, at Yohanes iya dombok ako hak ambi endaklagatek. Anderogo ovara, Ala avema dugwit ininis sovalek agarwik andi, Yohanes horok at sovalek hegek, it mondok ombok dombok dogosogom o,” yiluk, Yesus en avakwa yugeragagi. ( ");
INSERT INTO nbq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","At Yesus yugeragagi ako andi, it avakwa ovok erogo ap pemerintah enake yoparip wonggalisagwi menda inim hunggu lagagwarik, Yohanes en it endak ima wombabogogirikmu, “Ala andi, endawi mot adigat agarik,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Anderogo ovara, it ap Parisi menda inim, Musa wene mamulerelagwi menda inim, it ako andi, Yohanes en it ima wombabininaup nenanggon umbutugwarikmu, Ala en it ogagu dogop inimbitigi ako ogo mbo bagagwa.) ");
INSERT INTO nbq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus en wene ambi yugirigya dugwit, “It avakwa o yogak agarwik yi, nano ndatak wakhaik? It ngga hak ogasagwi? ");
INSERT INTO nbq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Dek. Avyak mariduk avakwa pasar ogasagwima hora yiluk, wene onggo-onggo yugu dugwit, ‘Nit ndawi viyanggup ovara, hit eyave yegetek. Eke, de wene viyanggup ovara, hit yup yagatek,’ yiluk, yagalagwi andi hak hit anderogo ogagu hinigis. ");
INSERT INTO nbq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hit avakwa yogak agipik ako andi avyak ndatak agipik. Andi, at Yohanes Ima Wombabisaliga ako is nenggetek erom nenggetek welagagi ovara, hiren, ‘Madis endawima nonggagas,’ yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Eke, An Ap At Endaklagagis yi erom inim, amburup inim, ugun nenggek wagya lagagima, hiren yugu dugwit, ‘Erom inim, is anggur amburup inim, ovadek en nenggek lagya dugwit, it ap pemerintah enake yoparip wonggalisagwi inim, ap weyak ogasagwi menda inim, it inim hunik oginivit lagya yi, hinil hanes o,’ yiluk, yagalagwima, Anen, ‘Hit avyak ndatak agipik,’ yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hit avyak ndatak agipik ovara, Ala endawi werek en ombasiga ako andi, it ogasagwi ovok erogo ogagwi vaga, sek at hugu dogosogom,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ap Parisi menda ambi inis Simon en Yesus inim erom naguluk, “Oma,” yugugu lagagimu, at amwa nunggigya lagagirik, inim erom naguluk, hora yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hora iri lagagimu, o kota andoma hwa weyak ogagya lagagi menda ambi en Yesus ap Parisi menda amwa erom naliga aruk hunggigi. Aruk hunggu lagagirik, amburup amben segedok menda iwak helep vaga mendagoma, nudik wolok nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wolok nunggwigya lagagirik, Yesus ambukmu andenam mendek yiluk, yup yagya dugwit, yup o angga vaga Yesus isok min okbagagi. Okbagya lagagirik, iris vaga hutu, isok vaga virik-verek iris, ogagya lagagirik, amburup segedok ako isok vaga ndibagagi. ");
INSERT INTO nbq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ap Parisi menda, “Yesus ninim erom naup,” yugogogi ako en hwa ako ogagya higya lagagirik, endawi imbita dugwit, “Hwa yi, weyak ogasiga menda atma, ap Yesus yi ako navi avyarat duklip en, ‘Hwa weyak ogasiga menda en vaknita higi,’ yiluk, andi vage yedok helap,” imbitigi. ");
INSERT INTO nbq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Imbita hegek, Yesus en, “Simon wai. An wene ambi yukhirup imbitirikmu, yukhisogon.” Yugugu lagagimu, at ako en, “Yukniru, Nasin.” ");
INSERT INTO nbq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yugugu lagagimu, Yesus en, “Ap mberen en ap ambi enanomar mbalek welagagwa. Ambi yoparip 500 denari mbalek, eke, ambi yoparip 50 denari mbalek welagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iperen enanomar mbalek onggo wogorup meyan halok, enabwa en, ‘Asugen. Un onggo dek hedomanes,’ yiluk, yugeragagi. At asugen yugeragagi ako andi, ap eneyave mberen ako, anomat ombok mbalek welagagi akova mondok endawi hunik imbitigi a, ata anomat maduk mbalek welagagi akova mondok endawi hunik imbitigi a?” ");
INSERT INTO nbq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yugugu lagagimu, Simon en, “Dek. Ap anomat ombok mbalek welagagi ako en mondok endawi hunik imbitigi ai?” yugugu lagagimu, Yesus en, “Yegen andi aro.” ");
INSERT INTO nbq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yugugu lagagirik, Yesus en hwa ako bikhigya lagagirik, Simon yugugu dugwit, “Simon wai. Hwa yi hil hegen a? An hamwa nunggu wagya lagima, nisok hurigiluk, haren is woknigitek ovara, at hwa yi ako andi, yup o angga vaga nisok min okbagya, iris vaga hotnita, ogaga. ");
INSERT INTO nbq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Haren An dinggik-hambup oknetetek ovara, at andi, An nunggu wagi hudi en yogak yi hudi mbup yegetek nisok vaga virik-verek adigat yagaliga. ");
INSERT INTO nbq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Haren amburup nunggul vaga erabanenggetek ovara, at ako andi, amburup amben sek onggo ombok menda nisok vaga ndibaluk hogabenanggas. ");
INSERT INTO nbq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Andi vaga en hwa yi, weyak wisane ogagya laga ovara, omaduk dek erogo bagirikmu, mondok endawi hunik iya erogo oknetas. Nit weyak horogat ogagu lagagup ako dek erogo bininggigi, umbutu iniselok andi, un horogat enendawi hunik ombasagwi.” ");
INSERT INTO nbq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yugugu lagagirik, hwa ako yugugu dugwit, “Homaduk dek erogo bagagi,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yugogogi ako, it erom naguluk inim horaik welagagwa ako ir-it yugu dugwit, “Avakwa enomaduk dek erogo bisaliga ako andi Ala adigatma, ap yi sa embetep?” ");
INSERT INTO nbq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yugu-sigik, Yesus en hwa ako yugugu dugwit, “Hendawi novaga vanggabaluk avyarat nembeten vaga Ala en hagap wendakhetas, hendawi ugun hamwa elak,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Andi en, at Yesus en Ala avema bisaup Sek Wene ako o kota ombokma inim, madukma inim, yugeregek nagu lagagi. Nagu dugwit, At ane welagwi menda 12 ako inim nagusim, ");
INSERT INTO nbq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","it akwa nin madis enendawima nonggagagi ogo, nin aup edup welagagwa ogo, Yesus en sek okbogogi ako andi, inim nagu lagagwa. It akwa sek okbogogi ako andi, hwa Maria inis ambi Makdalena yugu lagagwa endawima en madis eneyave 7 hudi wibogogi ako inim, ");
INSERT INTO nbq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","hwa ambi Yohana, agun inis Kusa ap ombok Herodes awi aruwam welagagi ako inim, hwa Sutana inim, eke, akwa nin wisane inim nagu lagagwa. It akwa ako enangge-enangge vaga Yesus at aswei inim enake ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","It avakwa wisane yi awi ndi awi en Yesus adema homari wagu-sigik, At wene wakhegek ambi yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ap awi lisilisiga menda en awi lisiligiluk, winggigi. Wunggu lagagirik, lisilit lagya hegek, nin sup vaga wombagagi. Sup vaga wombagagi ako avakwa inisok vaga sovalogo baik lagagwarikmu, swa en nunggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nin helep iri vaga wombagagi. Helep iri vaga wombagagi ako andi, avuduk inggigi ovara, wen mbuk atma, mbuk agagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nin iringga aigyangge werek anggelekma wombagagi. Iringga aigyangge werekma wombagagi ako andi iringga inim inggigirikmu, iringga en mbalogo wombanggigi. ");
INSERT INTO nbq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eke, nin wen mudis vaga wombagagi. Wen mudis vaga wombagagi ako andi, avuduk inggya lagagirik mudi-mudis inggya dugwit, adem ambi en enggen 100 yugu, ambi en 100 yugu, ogagagi o,” yiluk, yugeragagi. Wene andi yugirigya lagagirik, ane ombok vaga iri dugwit “Avyak! Henaruk werek halok andi, des erogo at hunggu dogones o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yugirigya lagagimu, At ane welagwi menda ako en Yesus hemethugu dugwit, “Hat wene wakhegek yukneregen ako adem nggarogo yiluk yukneregen?” ");
INSERT INTO nbq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yugugu lagagwama, At Yesus en, “Ala avema bigigaup wene At endawima hwilago welagagi ako henelup arovovok yiluk An vagalogo yukheraup ombasiga ovara, it ap nin ako en andi, ‘Inil helagwi ovara yedok hegetek, Eke, enaruk hulisagwi ovara enendawima dibagatek, Dogopwak yiluk,’ wene atok hwilagago heda adigat yugeraliga o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yugirigya lagagirik, “Wene wakhegek yukhirigi ako eyave sigam erogo yukherayogon. Awi lisilit lagagi ako andi Ala wene aro. ");
INSERT INTO nbq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sup vaga wombagagi ako andi, avakwa en Ala wene hunggu lagaoma, Sile en wagya lagarik, wene hunggugwa ako avyarat ombasagwi vaga enagap wendatya hao en yiluk, ndiyaliluk wolok wilisiga. ");
INSERT INTO nbq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Eke, helep iri vaga wombagagi ako andi, it avakwa Ala wene hobaluk enadenggen dugwit, wugu lagarwik, sidok avyarat ombasagwi ovara, enendawima omanggen vipak erogo yagetekma hivis enendawi avut mbanggya vaga hekbelagwi aro. ");
INSERT INTO nbq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Iringga aigyangge werekma wombagagi ako andi, it avakwa wene enaruk hulisagwi ovara, eneyave dogop vaga enendawi virik werekma, ininggi werek okhedaup adigat enendawi wenggelit lagwi, wen vaga sek dogop adigat enendawi wenggelit lagwi, ogarit lagu dugwit, wene yugup ako mbalogo wombalisagwi aro. Enggen eve sek menda mondok yiligadek. ");
INSERT INTO nbq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Eke, wen mudis vaga wombagagi ako andi, it avakwa wene hobaluk enendawi eve sek vaga vipak erogo wugu lagarwik, hunik adigat ogagu dugwit, enggen yiliga ako aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yugirigya lagagirik, ambi yugirigya dugwit, “Lambu yevedogo baluk sogolowak vaga vi wogogo belagudek, eke mbanggu avema belagudek. Ata, yevedogo baluk, it avakwa sup nunggu wandagwi ako awia haupwak yiluk, winimen sigama belagwi. ");
INSERT INTO nbq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yi menda ndi menda hwilago agarik halok, sigam agya, eke, wene hose agarik halok, ombok vaga vagalagya, ogarisogon. ");
INSERT INTO nbq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Henendawi dibavovok yiluk, An nane henaruk des erogo holek dogwes. It ap avyarat wene dibelagwi halok andi, vivis ambi inim erogo dibapwak yiluk, okbugu dogosogon. Eke, it avyarat wene dibelagwi dek halok andi, horagat inilup dugwit, ‘An dibagi,’ ombasagwi andi, vivis mondok enunggut okbisayogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yugirigyama, Yesus isa-arwi inim At adema wagu lagagwarik, avakwa wisane homagoma, Yesus werekma umwa nunggup meyan agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","avakwa en, “Hisa-harwi bikheyaguluk wagao ovara wasim agarwik,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yugugu lagagwama, Yesus en, “Nisai-narwi andi, it Ala wene hobaluk, ogasagwi yi aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hivis ndugwis ambi vaga Yesus ane welagwi menda inim mburi-vaga nunggugu lagagwarik, yugirigya dugwit, “Inamut yanggadek ambo ela vikit lasogom o,” yiluk, lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lagu dugwit, Yesus ako nogo yogogi. Nogo yugu hegek, inamut yanggadekma o havut endengga ombok wagya dugwit, mburis elola is yanggadi nunggigya hegek, mburis seve yagan wambup ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Seve yagan wambigya lagagimu, Yesus adema lagu lagagwarik, iluk okbaluk, “Nenasin wai! Nenasin wai! Is mondok ndokal ninivisiga!” Yugugu lagagwama, At iluk akluk, o havut endengga inim, inamut mogoliluk ogagya inim, mberugu lagagimu, havut mbup iri lagagirik, is ako avolok dek agagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dek agya lagagimu, Yesus en At ane welagwi menda yugirigya dugwit, “Henendawi novaga vanggabaluk avyarat nombasagwi ako nggayok lagipik yagalagwi?” Yugirigya lagagimu, enalon en at ambi en at ambi yugigik yugu dugwit, “Avyak! Is o havut endengga yugugu hegek, At ane hulisiga yi sa embetep? Wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Andoma en, is Nggaliliya mbalogo ambo ela vikit en o Nggerasa menda werekma wombagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wambugu lagagwarik, At Yesus mburi-vaga en wen-vaga wunggu lagagimu, ap ambi kota andoma menda madis endawima nonggagagi Yesus adema lagagi. O muk en umwa welagetek ayum yirikdek, avakwa hambugu-selok wimu bisa landagwima andoma welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aren Yesus higya lagagirik, avema seve iri lagagirik, ane ombok vaga, “Yesus wai! At Mondok Siyalek Dombok Agarik Ala abut Hat Yesus yi, an nggarogo okbanigiluk wagen? An edup-mbedup okbaninggya hao en yiluk, yukhisiga,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yugogogi ako andi, Yesus en madis edup agoda werek menda ap endawima en wulupwak yiluk, yuguguma, ap ako en Yesus yugogogi. O muk erogo madis en ap ako vagari wagek adigat ogagya halok, inggis-isok mbusi heda vaga makbaluk, aruwam inigik ovara heda libilogo hekbaluk madis en ap ako viyaliluk o avakwa dekma andoma ba lagek ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Madis ako en Yesus yugugu lagagimu, Yesus en, “Hat hinis iru!” Yugugu lagagimu, madis eneyave wisane ap ako endawima nonggagagwarik werekma, “An ninis Wisane o,” ");
INSERT INTO nbq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","yiluk, “Ap yi, endawima en wunggu niniselok, wen nggilin eloma wombabininabuk,” enane ngges erogo yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hulik averop andoma wam wisane ambekma buris yigik nagusim werekma, it madis ako en “Ai, wam enendawima andoma nungguguluk lakbininin,” yiluk, enane avuput vaga Yesus yugugu lagagwama, Yesus en “E o. Andoma nunggwi lales.” ");
INSERT INTO nbq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yugirigya lagagimu, madis ako ap endawima en wunggu lagagwarik, wam enendawima nunggugu lagagwama, wam ovok erogo lapik-lapikmu andoma en yulup yagan inamut yanggadekma nunggugu lagagwama, is ako en ndokal inipigi. ");
INSERT INTO nbq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","It wam endak hedugu lagagwa menda en wam is ndokal inipu ako hugu lagagwarik hoda sak yagan wunggu dugwit, wam is ndokal inipigi wene ako o ombokma im, o madukma im, yugeregek nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yugeregek nagu lagagwama, ogagagi ako avakwa bikhaguluk enamwa en wunggu lagagwarik, Yesus adema lagagwa. Lagu lagagwarik, ap madis endawima en wunggugwa ako endawi sek eve ap akluk yum yirik Yesus avema horaik werekma hagagwa. Hugu lagagwarik, enalon umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Enalon umbutu lagagwama, it endak oklagagi inil hagagwa ako en madis wisane ap endawima nonggagagwa Yesus en wibogogi wene mbilinogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yugurugu lagagwama, it avakwa o Nggerasa menda yi awi ndi awi andoma ovok erogo mondok enalon wisane agu lagagwarik, Yesus amwa wulupwak yiluk, yugogogwa. Yugugu lagagwama, Yesus mburi-vaga nunggigya lagagirik eyami vaga winggigi. ");
INSERT INTO nbq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wungguma, at ap madis endawima wunggugwa ako en, “Ninim lasogom,” yiluk ane avuput vaga Yesus yugogogi ovara, Yesus en at amwa lakbagya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hamwa heyami vaga lagya dogomindik, Ala en okbagagas ako mbilinogo yugerelak.” Yugugu lagagimu, lagya lagagirik, at amwa o kota andoma ovok erogo, “Yesus en yerogo okbenanggas,” yiluk, mbilinogo yugeregek nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","It avakwa wisane Yesus warupwak yiluk, sokhugusim, eyami vaga inggya lagagimu, heyaga warogo wogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wugu lagagwama, ap ambi it Yakuri samban ogasagwima enasin inis Yairus Yesus adema wagya lagagirik, avema seve yiluk, “An namwa niperen lasogom en, oma o,” yiluk, ane avuput vaga Yesus yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","At abut ambilom adik ambenggama hwavyak endago sawe hegek 12 tahun ogagagirikmu, mondok hambigiluk ogagyama yugogogi. Yugugu lagagimu, Yesus ako lagya hegek, it avakwa wisane inim linggililuk lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lagusim, hwa ambi amuya ogagya hegek, 12 tahun ogagagirikmu, sek arigiluk angge ovok erogo ndokter wogoragagi ovara, sek agetek welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hwa ako Yesus ambetaga lagya lagagirik, asum atok inggi vagatya lagagimu, amuya ogagya lagagi ako dek agagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dek agya lagagimu, Yesus en, “Sa en vaknetas?” Yugirigya lagagimu, it wisane erogo dik-dek yugu-sigik, Peterus en at yugugu dugwit, “Nasin o. It avakwa wisane yi linggilherelok wagu dugwit, sagambit erogo bagagu-sigis!” ");
INSERT INTO nbq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yugugu lagagimu, Yesus en, “Dek. An nanye ambi dek agya higirikmu, sa en vaknetas?” ");
INSERT INTO nbq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yugugu lagagimu, hwa ako en, “Vage yedok neyagas higi o,” yiluk, alon en owak de-de iri dugwit, Yesus avema seve iri lagagirik, avakwa ovok inivaga adem ngga vaga Yesus ayum vagatigi inim, eke ao vagatya hegek eyave sek agagi ako inim, vagalogo yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yugugu lagagimu, Yesus en, “Nabut o. Hendawi An novaga vanggabaluk avyarat nembeten vaga sek agenma, hendawi ugun hamwa elak,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ao yugugu hegek, ap ambi it Yakuri samban ogasagwi enasin amwa akoma en wagya lagagirik, ap Yairus ako yugugu dugwit, “Habut vage hombagarikmu Nenasin Ngguru yi sup enam warogo wolok lagun en.” ");
INSERT INTO nbq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yugugu ako At Yesus aruk hobaluk, Yairus yugugu dugwit, “Halon ombarubuk. Hendawi novaga vanggabaluk avyarat nombasiga halok, habut sek asogon,” yugukluk, ");
INSERT INTO nbq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ap ako amwa lagagwa. Lagu lagagwarik, it avakwa ovok erogo wasim dogopwak yiluk, yugirigya lagagirik, Peterus o, Yohanes o, Yakubus o, hwavyak isa-asin o, ako adigat woginiviluk amwa nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nunggwigya lagagirik, avakwa ovok yup yagu dugwit eneyave wakhidugwi inugu lagagirik, “Yup yarubuk. Hwavyak yi hombagabuk un nogo yiligama, yup yarubuk.” ");
INSERT INTO nbq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yugirigya lagagimu, it avakwa en hwavyak ako hombagas ovok enelupma, At aganda yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aganda yagagwa ovara, Yesus en hwavyak ako inggis vagatya dugwit, “Nabut mendek iru!” ");
INSERT INTO nbq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yugugu lagagimu, hwavyak ako mondok hombagagi ovara endawi yaklari wagya dugwit, mendek yagagi. Mendek iri lagagimu Yesus en, “Hwavyak yi erom naupwak yiluk wogeres.” ");
INSERT INTO nbq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yugirigya lagagimu, hwavyak isa-asin ako en, “Wi!” yiluk, vok yugu lagagwama, Yesus en, “Ogagya neyagep ako avakwa mondok yugerabuk,” yiluk, inaruk watigi. ");
INSERT INTO nbq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ndugwis ambi vaga, at Yesus en it ap 12 menda ako homari warupwak yiluk, yanggup yugirigya lagagirik, wagu lagagwama, At anye vaga it enanye okbisiluk, yi madis ndi madis ovok erogo avakwa enendawima en nggigilogo wibugwis, yi aup ndi aup edup halok, sek okbugwis, At inis vaga ogonivit nagu dogopwak yiluk, awene yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Awene yugirigya lagagirik, Ala avema bisaup wene yugeregek lagwi, avakwa sek ogonivit lagwi, ogarit nagu dogopwak yiluk, lakbugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Hit lagu dugwit, yi menda ndi menda henowanggun inim, yerek-terek wokhirugu-selok yekhedamenda yum inim, henagarom henayoparip inim, henasum vakean mberen inim, wolok labuk heneyave adigat elales. ");
INSERT INTO nbq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hit o hunogoma lamundikmu, ap ambi en wokhinipu-selok, hinim adigat o kota andoma dogomundik, o kota adikmu andoma laup halok andi, laup. ");
INSERT INTO nbq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yi awi ndi awi lamundikmu, heyaga warogo wokhinipitek halok andi, enamwa o kota en wunggu dugwit, inil vaga inilamundinek hinisok vaga mupak hak horogo baluk, andoma en wilitalo o.” ");
INSERT INTO nbq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yugirigya lagagimu, lakbogogi ako lagu lagagwarik, yi awi ndi awi lagu dugwit, Sek Wene yugurugwi, avakwa sek okbugwis, ogarit nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Ogarit lagwi ako it avakwa en inigu lagagwarik, Yesus andi sa yiluk, it nin en “At andi, at Yohanes Herodes en mondok watigirikmu hambuluk bisa lendagwima en iluk akluk, mendek yagas ai,” yugwi, eke, it nin en, “Dek. Ap navi endak welagagi Elia ako sigam aga ai,” yugwi, eke, it nin en, “Dek. Ap muk Ala en yugirigya hegek yugurugu lagagwa navi-navi akoma menda ambi iluk akluk, mendek yagas o,” yugwi, yagan lagwi ako ap inis ombok Herodes ako aruk hunggu lagagirik, endawi obak agagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Endawi obak dugwit, “Anen Yohanes unggul mbalupwak yiluk yugirigya lagagimu, mondok watugwa ovara, ogarit landiga naruk hunggis yi, sa en ogarit landiga?” yiluk, Yesus bikhagiluk, ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","It ap lakbogogi ako eneyami vaga wagu lagagwarik, ogarit nagu lagagwa ako Yesus mbilinogo yugogogwa. Yugugu lagagwama, At Yesus en woginiviluk o kota ambi inis Mbesaida enadikmu ari lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Enadikmu ari lagagwa menda, avakwa wisane “Yesus andoma laga,” enaruk hunggu lagagwarik, amusek lagagwa. Amusek lagu lagagwama, Yesus en heyaga wakbugu lagagirik, Ap Ala en denogo mendok okbagagi ako avakwa at avema dogopwak yiluk sup hutbayogon wene yugirigya, eke, eneyave aup edup halok, sek okbugu, ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ogagya hegek, mo il vage huruk yigiluk ogagya hegek, it ap 12 ako At adema wagu lagagwarik, yugugu dugwit, “Nenasin. O yoma avakwa enawi dekma wagyo atma, it avakwa wisane homari wagao yi, o ombokma inim, o madukma inim, andoma enagarom onggo hunogombo nunggwi nogo yupwak en, lakbisin.” ");
INSERT INTO nbq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yugugu lagagwama, At Yesus en iri dugwit, “Enagarom naupwak yiluk, hiren wogeranes.” Yugirigya lagagimu, iren, “Nit roti 5, eke, ikan mberen at agarikma, avakwa wisane yi, enagarom huni laup sek yiluk yagaliga a?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Yugogogwa andi, ap eneyave adigat lima ribu hudi werek yiluk, yugogogwa.) Yugugu lagagwama, Yesus en At ane welagwi menda ako yugirigya dugwit, “It avakwa enarwi 50 dombok ogorogo hora yupwak yiluk, yugeranes.” ");
INSERT INTO nbq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yugirigya lagagimu, anderogo at hora okbogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hora okbugu lagagwama, At Yesus en roti 5, ikan mberen inim, inggimu wigya lagagirik, elese mbogot vaga ilik lagya dugwit, “Nasin Ala wa!” yiluk, ugutigi. Ugurogo At ane welagwi menda en avakwa homago ako sumbureraupwak yiluk, wogoragagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wogoragagi sumburirugu lagagwama, it ovok erogo nunggu lagagwarik, enagaum agagi. Enagaum agya lagagimu, nin higitlagagi ako yum mburin yedogo 12 hudi bagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Andi en, hivis ndugwis ambi vaga Yesus adikmu samban ogagyama, At ane welagwi menda ako adema wagu lagagwama, Yesus en enaigwakma wigya dugwit, “It avakwa en An sa numbutu dugwit, yagalagwi?” ");
INSERT INTO nbq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yugirigya lagagimu, iren yugugu dugwit, “Avakwa nin en, ‘At Ima Wombabisaliga menda Yohanes ako aro,’ yugwi, eke nin en, ‘Elia aro,’ yugwi, eke, nin en, ‘Ap muk Ala en yugirigya hegek yugurugu lagagwa navi-navi ako menda ambi iluk akluk, mendek yagas,’ yugwi, yagalagwi o.” ");
INSERT INTO nbq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yugugu lagagwama, Aren it yugirigya dugwit, “Eke, hit andi, An sa numbutu dugwit, yagalagwi?” Yugirigya lagagimu, at Peterus en, “Ala en denogo bagagi Keretus andi Hat at higyo o.” ");
INSERT INTO nbq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yugugu lagagimu, At Yesus en, “An navok yegep andi, avakwa mondok yugera labuk,” yiluk, enaruk watigi. ");
INSERT INTO nbq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Enaruk wakbaluk, yugirigya dugwit, “An Ap At Endaklagagis ako mondok novaga anggin-mbanggin erogo banusogom. It ap ombok-ombok inim, it imam-imam enasini inim, Musa wene mbalek mamulerelagwi menda inim, enanggon en hekbanunggu dugwit, narusogom. Natu dogomima, hambigya dogomindik ndugwis mberen dukluk ndugwis ambi vaga Ala en niluk erogo mondok okbanisogon o.” ");
INSERT INTO nbq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yugirigya lagagirik, it avakwa ovok erogo wene yugirigya dugwit, “Hit An nane wokbaluk ninim nagu dogop umbutu dugwit halok, yi menda ndi menda ogarup ombasagwi ako hetbisiluk, ndugerek-ndagarek yo winik ako hedelok, An ninim at nagu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hit heneyave hinidi okhidugu dugwit, an nane mbo bamwi halok, heneyave yelemele yusogom. Eke, An ninis ombok arupwak yiluk, heneyave idi dek okbetamwi halok, hinidi erek dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hit yi awi ndi awi ovok erogo andok okhidugu dogomundik, heneyave yelemele yusogom halok, andi vaga nano okhedaguluk, yagan nagu dogop embetep? ");
INSERT INTO nbq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ap ambi sa en An ninis inim, An avakwa inivaga alon en yegetek dogosogon halok, hivis An ninim, an Nasin inim, it Ala ake ogagu dogop denek agarwik malaikat inim, mondok abinak werek dugwit niniris nenovagangge yikedelok wagu dugwit, An Ap At Endaklagagis yi en ap ako inis yisogonbuk. ");
INSERT INTO nbq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Dibas! Hit avakwa yoma agipik andi, nin ao hambegetek hinigik, avakwa Ala avema bisa wagya ako hinil hasogom o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wene andi yugirigya lagagirik, samban ambi okbaluk, Yesus en Peterus o, Yohanes o, Yakubus o, woginiviluk samban ogaruguluk, ndom vaga unggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Unggu lagagwarik, Yesus samban ogagyama, At elese adik agya lagagirik, asum mudu amumulip digavok ovagak agya hegek, ");
INSERT INTO nbq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","abinak yevedek vaga ap mberen Musa Eliya eneyave sigam ari wakluk, Yesus o Yerusalem hambup atma des yup agagi wene ako, Yesus inim wene mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wene mbanggu-sinigik, ap Peterus aswei inim mondok nogo yup okbogogi ovara, iniluk agu lagagwarik, Yesus mondok abinak ovaga werekma, ap mberen inim enogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Inigu lagagwarik, it ap mberen ako Yesus hekbaluk, dagaguluk ogagusim, Peterus en Yesus yugugu dugwit, “Nasin guru wai. Nit yoma agurik yi sek atma, eravo henggam ambi Hat, ambi Musa, ambi Eliya at valogo bigigasogom,” yugogogi. (Andi yugogogi ako we ugun inggutmu, yugogogi.) ");
INSERT INTO nbq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ako ao yugugu hegek, hena wagya dugwit, lovarogo bogogi. Hena enovaga lovakbisa wagya lagagimu, enalon wisane agu-sigik, ");
INSERT INTO nbq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","hena anggelekma en ane iri dugwit, “An nabut denogo bagagis ako yi atma, At ane des erogo hunggu dogones.” ");
INSERT INTO nbq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Iri lagagimu, bikhugu lagagwarik, Yesus adigat hagagwa. Hugu lagagwarik, ogagya hagagwa ako, andi hudi vaga avakwa mondok yugeregetek mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hutun At Yesus ane welagwi menda inim ndom vaga akoma en wambu wagu lagagwama, avakwa wisane At adema lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Adema lagu lagagwarik, avakwa wisane homari lagagwa ako ambi en ane ombok vaga Yesus yugugu dugwit, “Ngguru wai. Nabut ambilom endagoma bikhanok yiluk, yukhisiga, nasin! ");
INSERT INTO nbq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Madis en avyak ako vagari wagek adigat ogagya halok, na iri hegek, legogo wen vaga ane ndun okbagya lagarik, inggis-isok ndogom-ndogom yupwak yiluk okbagya, owari-lagap ogarupwak yiluk, okbagya, ogagya lagarik, wasiga. Hekbaluk, wulup andi, ombasigadek aro. ");
INSERT INTO nbq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Anen hat hane welagwi menda ako madis nggigilogo wibaupwak yiluk, yugirigi ovara, iren nggigilogo wibaup meyan.” ");
INSERT INTO nbq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yugugu lagagimu, At Yesus en, “Hit avakwa yogak agipik yi, henendawi novaga vanggabaluk, avyarat embetetek weyak adigat ogarup ombarit nagwis yi, An ndugwis maren nendawi seve yiluk hit hinim dogop?” yiluk, yugirigya lagagirik, ap abut edup werek ako yugugu dugwit, “Habut wolok oma.” ");
INSERT INTO nbq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yugugu lagagimu, ao wolok wagya hegek, madis ako en avyak eyave legogo wen vaga ndun okbagya lagagirik, inggis-isok ndogom-ndogom yupwak yiluk okbagagi. Okbagya hegek, At Yesus en madis edup agoda werek menda ako mberugu lagagirik, avyak ako sek okbagya dugwit asin wogogogi. ");
INSERT INTO nbq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wogugu lagagimu, it avakwa en Ala anye wisane hugu lagagwarik, “Wi!” yiluk, vok yagagwa. Yesus yi ogagek ndi ogagek ovok ogarit lagya vaga, it avakwa ovok en, “Wi!” yiluk, vok yugu-sigik, Yesus en At ane welagwi menda ako yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“An wene yukheraliga yi, des erogo henaruk holes. An Ap At Endaklagagis yi, narupwak yiluk neyave vagogo ap wogirigya hagup.” ");
INSERT INTO nbq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yugeragagi ovara, it dibagatek welagagwa. Eke, wene andi, hwilago ovagak yugeragagima, yedok hegetek ovara, “Yukneregen ako andi, nggarogo yukneregen?” yiluk, enalon en aigwakma wegetek mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Andi en, hivis Yesus ane welagwi menda en, “An iya hat iya,” yugu dugwit, wene alelo watugwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","It enendawi umbutu dugwit, wene alelo watwis ako At Yesus yedok inugu lagagirik, avyak maduk ambi wogogo alilimu mendek okbaluk, ");
INSERT INTO nbq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","it ako yugirigya dugwit, “At ambi henanggelekma mondok sovalek agarik halok andi, at ap ombok adigat agarik. Anderogo atma, ap ambi an nane wokbaluk, at avyak yi, waliga halok andi, An at wokneraliga, eke, An wokneraliga halok andi, At lakbani wagagi ako waliga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yugirigya lagagimu, Yohanes en, “Nasin wai. Ap ambi nit ninim nelagwi dek ovara, aren Hat hinis vaga madis nggigilogo wibagya ninil hugu lagurik, ‘Moga’ yugugup,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yugugu lagagimu, At Yesus en, “‘Moga,’ yugurubuk. It hinim ogorek dek halok andi, hit menda aro,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Andi en, hivis At Yesus mbogot vaga wolok dagaup vage vanggo yi wagya lagagimu, Yesus o Yerusalem laup yiluk, endawi mondok mbuk agya lagagirik dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","yonggo endak lakbisa lagagi lagu lagagwarik, at wagyama ake vipuk erogo baupwak yiluk, avakwa Samaria menda enamwa o desa andoma ambi nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nunggugu lagagwama, avakwa o Samaria menda en, Yesus o Yerusalem mondok laup imbitya yedok hugu lagagwarik, enendawi weyak umbutu dugwit “Yerusalem laup embetarikmu, ninim dogop nenanggon, laupwak,” umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","It anderogo umbutwi At ane welagwi menda Yakubus Yohanes iperen inigu lagagwarik, “Nenasin wai! Hali mbogot vaga en yevedogo iniri wambu warupwak yiluk, yuguruk ai?” ");
INSERT INTO nbq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yugugu lagagwama, ena endenogo biginugu dugwit, mbereragagi. ");
INSERT INTO nbq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mberirigya lagagirik, o adik ambima lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sup vaga lagusim, ap ambi en Yesus yugugu dugwit, “Hat yi awi ndi awi nagu dogop imbita heyalok, an hat hinim at nagu dogosogon.” ");
INSERT INTO nbq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yugugu lagagimu, At Yesus en, “Yangge do andi, enawi yo masalekma homoma agarwik, eke, swa mbogot vaga nelagwi ako, enawi yo vaga valek agarwik, ovara, An Ap At Endaklagagis yi andi, nogo yiligama mondok dek,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yugugu lagagirik, Yesus en ap adik ambi yugugu dugwit, “An hat hinim nagu dogosogom o,” yugogogi ovara, ap ako en, “Ai, nasin! Endak nasin wen sabaluk, hinim lasogom en, ‘Sek,’ yukniru.” ");
INSERT INTO nbq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yugugu lagagimu, At Yesus en, “It avakwa Ala wene enendawima dek halok andi, nggorak ndatak at agarwik ako menda en enowa-enasin hambugu-selok, wen sabugu dogopwak yiluk, hekbisin. Hat andi, Ala en avakwa At avema dogop sup hutbagagi wene ako, yi awi ndi awi yugeregek nagu dogwen,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yugugu lagagimu, ap adik ambi en Yesus yugugu dugwit, “Nasin. Hat hinim nagu dogosogon imbiti ovara, lagiluk, endak nowa-nasin yugera lapim, ‘Sek,’ yukniru.” ");
INSERT INTO nbq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yugugu lagagimu, At Yesus en, “It avakwa en an ninim nagu dogop yugu dugwit, enambokan biginugu-selok, Ala avema dugwit Ala eyavup ogarit lagya dogop meyan,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Andi en, hivis Nenasin Yesus en ap adik 70 denogo lakbugu dugwit, yi awi ndi awi o kota dombok laup imbitigirikmu akoma it enendak mberen hondok lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lakbugu dugwit, “Enggen yugup wisane aga ovara, mbalisagwi menda eneyave horok ambukumat atma, at enggen yugup andok werek Ala ako en, enggen mbalisagwi menda lakbisaupwak yiluk, yugugu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eke, hit andi, elales. Hit ndomba ovagak yi, avakwa yangge do ovagak werekma, enanggelekma lakbigigaliga. ");
INSERT INTO nbq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lakbigigaligama, henayoparip wonggalek inim, yerek-terek wokhirugu-selok yekhedamenda yum inim, henaropato ambi adik inim, andi wolok labuk heneyave adigat elales. Eke, suvaga lagu dugwit, it avakwa iniselok, heyaga wakbigik labuk. ");
INSERT INTO nbq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Avakwa enamwa ambima nunggugu dogomundik, endak heyaga wakbugu dugwit, ‘Wa! Ala en adenggen ombok erogo henovaga okbugugu dogopwak o,’ yiluk, yugerano. ");
INSERT INTO nbq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ap enawi werek ako enendawi sek vaga, ‘Yi nit nenaswei aro,’ yiluk, wokhinipu-selok, adenggen enovaga bisamwi ako enovaga asogon. Eke ap ako enendawi weyak en wokhinivup enanggon umbutu-selok andi, adenggen enovaga bisamwi ako, enovaga asogonbuk sugulogo hit henovaga at okhedelok, wilitalo. ");
INSERT INTO nbq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","It avakwa en hit wokhinivup umbutu-selok, enamwa hinim andoma at dogop. It ap yavup ogasagwi yavup onggo waup sek atma, hinim dugwit, henagarom yi menda ndi menda menakhirugu-selok, andi nunggu dogop. Ya nogo yigik nda nogo yigik yagan nagu dogobuk. ");
INSERT INTO nbq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Hit o kota ambima nunggumundikmu, heyaga warogo wokhinipu-selok, enagarom menakheramwi andi at nunggu dogop. ");
INSERT INTO nbq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Eke, avakwa andoma aup warek iniselok, sek okbugu dugwit, ‘Ala avema bigigaup vage henadema vanggo yi waga o,’ yiluk, yugurugu dogop. ");
INSERT INTO nbq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Eke, o kota ambima nunggumundikmu, it avakwa en wokhinipitek iniselok andi, weram sup ombok vaga wunggu dogomundik, yugurugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Henovaga asogon ako andi, henovadombok, henelup arovovok yiluk, nit henamwa dugwit, ninisok vaga mupwak hondo yagas ako horogo bigelagwi. Ala avema bigigaup vage henadema vanggo yi waga, avyarat umbutu dogones,’ yiluk, yugerano. ");
INSERT INTO nbq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","O hivis avakwa enowak dilup hudi vaga it avakwa o Sodom endak welagagwa andi horogat enasogon ovara, it ap o kota andoma menda ako andi, mondok iya erogo enasogon, yiluk, yukheraliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wene ambi iri dugwit, “Hit avakwa Korasim menda andi, anggin henovaga arugup! Eke hit avakwa Mbesaida menda andi, anggin henovaga arugup! Nggarogo ogarubuk menda henamwa ogagya neyagagup ako, an o Tirus Sidon andoma ogagatek. An ogagatek ovara, o Tirus Sidon andoma ogagya dukli en, it avakwa andoma menda en it weyak ogasagwi ako enasam helap. Enasam hugu dugwit, hora yiluk enayum weyak yikhidugwi, isaben enagap vaga wakhidugwi, ogaklip. ");
INSERT INTO nbq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anderogo atma, hivis enowak dilup agya vaga avakwa Tirus Sidon menda andi, we un horogat enasogon ovara, hit Korasim Mbesaida menda ako andi, mondok iya erogo henasogon. ");
INSERT INTO nbq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eke, hit avakwa Kaperenaum menda andi, ‘Nit mbogot vaga siyabininayogon,’ yiluk, yagalagwi yi? Mondok dek. It hambuluk landagwima yagamu andoma mbo womba bigigayogon, umbutu dogwes,” yiluk, yagagi ");
INSERT INTO nbq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iri lagagirik, At ane welagwi menda ambi yugirigya dugwit, “It avakwa hit henane hunggu-selok andi, An nane hulisagwi, hit hekbugugu iniselok andi, An hekbanunggwi, eke, iren An hekbanunggu-selok andi, At lakbani wagagi ako hekbelagwi aro,” yiluk, yugirigya lagagirik, lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Andi en, hivis it ap 70 lakbogogi ako enadenggen embetek eneyami vaga wagu dugwit, “Nenasin! Madis ogo Hat hinis vaga yugurugu niniselok, hunggu-sugup.” ");
INSERT INTO nbq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yugugu lagagwama, At Yesus en, “Hit madis avakwa enendawima en nggigilogo wibugu hinigik, An en at Sile o bigavok ogasiga ako ovagak mbogot vaga en anye dek agya dugwit wambu wigya hagagis. ");
INSERT INTO nbq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mbas avakwa enasiga inim, hagudi inim, hinisok vaga sovalogo bagwi, at hinim ndup ogorek ako anye dek erogo bagwi, ogagu dogovovok yiluk, An nawene yukhirigi. Nawene yukhirigima, weyak edup menda ambi henovaga asogon mondok dek aro. ");
INSERT INTO nbq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Anderogo ovara, it madis henane hulisagwi ako vaga henendawi adenggen ombarubuk. Ata, hininis mbogot vaga eloma dirup mbalek agarik ako vaga henendawi adenggen umbutu dogones,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ndugwis andi vaga Yesus endawima Averiniki en adenggen wisane okbagya lagagimu, Ala heyaga watya dugwit, “Wen-mbogot andok Hat Nasin wa yukhisiga. Hat ogarup yi ako, it ap enendawi werek inim, enendawi anggat inim, enelup agusao en, hwilak baluk, mariduk swi endago ovagak vagalogo yugeragaginma wa. Anderogo ogarup hendawi sek ombakluk ogagaginma, Nasin wa, yukhisiga o.” ");
INSERT INTO nbq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yugugu lagagirik, “An Nasin en yi menda ndi menda ovok erogo An nandok dogopwak yiluk, woknigas. Ala abut andi sa? It avakwa ininggut Nasin adigat elup agarik. Eke, Nasin andi sa? Andi, At abut An nelup agirik. Eke, abut An en it avakwa Nasin enelup arupwak yiluk, vagalogo yugeraup imbitya neyalok, it ogo, enelup asagwi,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yugirigya lagagirik, At ane welagwi menda il biginigu lagagirik, enadikmu yugirigya dugwit, “An ogarit lagya hit hinil neyalagwi ako, it avakwa hugu-selok, hit hinim henendawi adenggen erogo hugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Andi, hit hinil helagwi ako, it o muk welagagwa Ala en yugirigya hegek yugeraliga menda navi-navi inim, it ap ombok-ombok ininis werek inim, it wisane en, ‘Helao dek ai,’ umbutu lagagwa ovara, ao halok, hegetek welagagwa. Eke, hit hulisagwi ako, iren, nenaruk ‘Hulup dek ai,’ umbutu lagagwa ovara, hunggitek welagagwa, yiluk, yukheraliga o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Andi en, hivis ndugwis ambi vaga ap Musa wene mamuleraliga menda ambi en Yesus avut mbaligiluk, wagya lagagirik, yugugu dugwit, “Ngguru wai. An mondok-mondok niluk dogogiluk, nggarogo ogarik?” ");
INSERT INTO nbq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yugugu lagagimu, At Yesus en, “Musa wene mbalek andi, nggarogo mbalek agarik? Hat hil nggarogo haliga?” ");
INSERT INTO nbq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yugugu lagagimu, ap ako en, “‘Heneyave henanye inim, henendawi henanggela inim, ovok at henasin Ala adigat henendawi hunik ogagu dogwes.’ Eke, ambi, ‘Hit heneyave henendawi hunik okhedelagwi ako hak, it hinim agipik ako anderogo at henendawi hunik oginipu dogwes, Ala wene anderogo mbalek agarik,’” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yugugu lagagimu, At Yesus en, “Sek yegen. Yegen ako ndatak ogagya heyalok, hiluk mondok-mondok dogogun.” ");
INSERT INTO nbq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yugugu lagagimu, ap ako, “An sek-sek,” nombarupwak yiluk, Yesus yugugu dugwit, “Eke, nendawi hunik oginivik en it ninim agirik andi sa?” ");
INSERT INTO nbq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yugugu lagagimu, At Yesus en wene wakhegek vaga at onggo yugugu dugwit, “Ap ambi Yakuri menda o Yerusalem en o Yeriko wombagagi. Wambigyama, ap enonggop welagwi menda en vagarogo ndun okbaluk, asum angge-angge ovok erogo ndiyanggu dugwit, eyave watu lagagwarik, andenam hambupwak yiluk, hekbaluk wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wunggu-sigik, hivis ap imam ambi we ugun sup andi vaga lagya dugwit, ap warek ako higya lagagirik, hegek lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lagya hegek, hivis ap Lewi menda ambi anderogo sup andi vaga ugun lagyama, ap watugwarikmu ari lagya dugwit, eyave warek andenam hegek, alilirup mbikit lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lagya hegek, hivis ap Samaria menda ambi sup andi vaga wagagi. It Samaria menda andi, it avakwa Iserael menda inim ogorek welagagwa. Wagya dugwit, ap warek ako il hagagi. Il higya lagagirik, abwa ombakluk, ");
INSERT INTO nbq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","adema lagya lagagirik, agavelo libik-lobak erek ako hotbaluk, anggur amburup inim, amburup adik menda inim, eralogo heda makbagya lagagirik, eyave wogogo at anggom keledai vaga hora okbaluk avakwa nogo yilagwima hunogoma ba nonggagagi. Ba nunggwigya lagagirik, andoma aruwam welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Eke, hutun at ayoparip mbusi verak mberen wogogo ap nogo yilagwima awi werek ako wogugu dugwit, ‘Ap yi aruwam dogwen. Aruwam dugwit, wokhigis yi ako dek agya halok, hat hangge ambi lobalogo hunggu dogomi halok, an wagya dogomindik, avoloma wokhisogon,’ yugogogi,” yiluk, Yesus en ap Musa wene mbalek mamuleraliga menda ako yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yugugu lagagirik, “Ap henggam ako it avakwa inim dugwit, enendawi hunik ombasagwi ovagak ap onggop welagwi menda en watugwa ako, ap ambi sa en endawi hunik okbagagi embeten?” ");
INSERT INTO nbq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yugugu lagagimu, at ap Musa wene mbalek mamuleraliga menda ako en, “At ap aigwak abet en abwa ombakluk sek okbagagi ako aro.” Yugugu lagagimu, At Yesus en, “Hat andi, ndatak ogarit nagu dogwen,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus At ane welagwi menda inim lagu dugwit, o ambima nunggugu lagagwama, hwa ambi inis Mareta en Yesus at amwa nunggu warupwak yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yugugu lagagimu, nonggagagirik werekma, hwa Mareta aot inis Maria ako, Yesus avema horaik dugwit, ane hunggigi ovara, ");
INSERT INTO nbq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mareta andi, Yesus ake yi walagek, ndi walagek aburuk ogagya lagagi. Ogarit lagya dugwit, Yesus adema lagya lagagirik, yugugu dugwit, “Nasin wai. Hat hake an nadigat ogagya dogopwak yiluk, naot hekbenanggarikmu Hat neyagetek agindik? Yonggatneyaupwak yiluk, yuguru!” ");
INSERT INTO nbq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yugugu lagagimu, Yesus en, “Mareta, Mareta. Hat yi ogarup ndi ogarup adigat hendawi anggin dugwit, aburuk-mbaburuk ogarit lagya heyagi. ");
INSERT INTO nbq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ambiat mikbaluk, ogarup andi sek. Eke, hat haot Maria en sek ogarup mitarikmu, An, ‘Moga,’ yugisogon buk,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hivis ndugwis ambi vaga At Yesus ambima samban ogagagi. Ogagya lagagimu, At ane welagwi menda ambi en Yesus yugugu dugwit, “Nasin. Ap Yohanes en At ane welagwi menda samban ogarupwak yiluk, mamuleragagi ako hak nit samban ogaruguluk, Hat mamulneran.” ");
INSERT INTO nbq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yugugu lagagimu, At Yesus en, “Hit samban ogagu dugwit, Ala yerogo yugugu dogones: ‘Nenasin! Hat hinis mondok adik denek agindikma, siyabagalagwi o. Nit Hat havema dogoguluk, okbininanok. ");
INSERT INTO nbq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nenagarom nunggu dogop o ninggi-nanggi woknirigya dogwen o. ");
INSERT INTO nbq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","It ap nit weyak erogo bininelagwi ako niren enomaduk dek erogo biselagwima, haren nit nenomaduk dek erogo bininggu dogwen o. Eke, weyak ogarupwak en yiluk, nenavut mbanggya hao en, nenaruwam dogwen o,’ yiluk, anderogo yugugu dogones,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yugirigya lagagirik, At ane welagwi menda ako ambi inim yugirigya dugwit, “Ap hit menda ambi en nogo endawi mberen agya vaga at aswe ambi adema lagya dogomindik, yugugu dugwit, ‘Naswe wai. An naswe ambi o ambima lagya dugwit, bikneyagek waga ovara, erom wogorup mondok dekma, hat roti henggam wokniru o,’ yugugu halok, ");
INSERT INTO nbq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","at aswe amwa agarik ako en iri dugwit, ‘Nogo mondok agako agirikmu, an hane ngginggis yuknirubuk. Sup ovok lakhidigi. Eke, naburi ninim nogo yugusim, mendek yiluk wokhirup andi meyan,’ yiluk, anderogo yugisogon. ");
INSERT INTO nbq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Andi, nogo mondok agako agagirikmu, wogorup anggon ombarisogon ovara, alon embetetek ane hunik adigat yugugu vaga at mendek yiluk, ‘Wokniru o,’ yugugu ako wogisogon buk embetep? Wogosogon aro, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Anderogo hak, an wene ambi yukherayogon. It avakwa en nggino yugugu-selok, wogirigya, belanggu-selok, havethedugwi, sogop vupuk ogagu-selok, sup hutbugu, ogasagwi. Ogasagwima, hiren Ala nggino yugugu dogop. Nggino yugugu hiniselok, aren wokherayogon. Sek menda at ovaga belanggu dogones. Belanggu hiniselok, at elola en havethedasogom. Sup vupuk ogagu dogones. Sup vupuk ogagu hiniselok, aren sup hurogo bigigayogon o. ");
INSERT INTO nbq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hit henabut ambi en, ‘Erom wokniru o,’ yukhirigya halok, helep wogorup embetep? ‘Ikan ambi wokniru o,’ yukhirigya halok, mbas edup menda wogorup embetep? ");
INSERT INTO nbq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","‘Swa enggen ambi wokniru o,’ yukhirigya halok, hagudi wogorup embetep? ");
INSERT INTO nbq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dekma, hit ap weyak menda ovara, henaburi en nggino yukhirugu-selok, sek menda wogerelagwi ako ndatak, hit henasin mbogot vaga menda en, ‘Averiniki wokniru o,’ yugugu hiniselok, wokherayogon buk embetep? Avyarat wokherayogon aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hivis ndugwis ambi vaga Yesus en madis ambi ane dek okbisaliga menda ap endawima en nggigilogo wibagya lagagimu, wunggu hegek, ap ane dek ako ane werek agagi. Ane werek agya lagagimu, it avakwa en, “Wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Vok yagagwa ovara, it nin en yugu dugwit, “At Yesus andi, madis enasin Mbelesebul anye vaga en nggigilogo wibisaliga,” yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Eke, it nin en At endawi avut mbalusogom, umbutu dugwit, “Mbogot vaga ninelup arup nenalon werek menda ambi ogaru o,” yiluk, at yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","It enendawi umbutwi At Yesus yedok inugu lagagirik, it yugirigya dugwit, “Ap enowa ambi at avema agarwik inim ir-it ogokhedelok sak yugu-selok, at avema bisaligama anye dek asogon. Eke, o yapwi ambiat agarwik atma, ir-it ogokhedelok wunggu-selok, enawi andi um dogosogon. ");
INSERT INTO nbq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hiren yugu dugwit, ‘At madis Mbelesebul anye vaga nggigilogo wibisaliga o,’ yagalagwima, anen ‘At Sile en at avema menda inim ogokhedugu dugwit hoda wunggu-selok, at avema bisaligama andi, nggarogonggan anye dogop,’ yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eke, hiren An madis Mbelesebul yuknugu vaga madis nggigilogo wibisaliga yagalagwi ako, avyarat halok enda, hit henarwi en ogo madis nggigilogo wibisalagwi ako madis Mbelesebul en yugeraliga vaga wibiselap. Ovara dek. Hit henarwi en madis Mbelesebul yugirigya vaga nggigilogo wibiselagwi dek. Anderogo atma, hit henarwi en, henanggadi wakbigigasogom. ");
INSERT INTO nbq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Anen Ala inggis anye vaga madis nggigilogo wibugu neyalok andi, Ala avema bigigaup vage henadema waga umbutu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ap ambi anye werek en yegen mbagerek dugwit awi aruwam halok, at angge ugun andoma sek dogosogon. Angge sek dogosogon ovara, ");
INSERT INTO nbq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ap adik ambi anye wisane en ap ako awi vaga miklari nunggigya dugwit, at eyave sovalogo bagya halok andi, ayegen-ndugudis ako vaga endawi vanggabaluk, dogomi ako ndiyalogo angge-angge ako amororo okbaluk, sumbureraliga. ");
INSERT INTO nbq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","It An ninim dambulik wagetek iniselok andi, ninim ogorek agarwik. Eke, An ninim homakbiselagwidek ako en haryogo wibisalagwi aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yugirigya lagagirik, Yesus en ambi yugirigya dugwit, “Madis edup agoda werek menda ap endawima en wunggu lagarik, ‘Nggoma sat yanggal hedaik,’ yiluk, is adem dekma belalit naliga. Belalit naliga ovara sat yanggal hedaup dek halok, ‘Namwa wulu wagirikmu akoma neyami vaga nunggisogon,’ yiluk, ");
INSERT INTO nbq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","nunggigya dogomindik, o um ovara at wulu wagarikmu akoma mupwak horek nggarik-nggarek erek halok, ");
INSERT INTO nbq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","andi en, wunggu lagarik, at madis ako weyak ovara, madis mondok weyak dombok eneyave 7 homakbisiluk, woginiviluk eyami vaga nunggu wandiga. Nunggu wigya lagarik, akoma inim werekma, ap ako endak madis ambiat endawima werekma horogat sek welagagi ovara, hivis wisane erogo hobo-hobo ari nunggugu-selok, ap ako mondok evelela weyak at dogosogon,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wene andi yugirigya lagagimu, avakwa wisane homago enanggelekma en hwa ambi en ane ombok erogo Yesus yugugu dugwit, “Hwa eyak endakhitya lagagirik, agadyak wokhugu lagagi ako, endawi adenggen himbita dogosogon.” ");
INSERT INTO nbq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yugugu lagagimu, At Yesus en, “At ako endawi adenggen imbita dogosogon ovara, it Ala wene des erogo hobaluk, ogarit lagu-selok andi, enendawi mondok adenggen wisane umbutu dogosogom,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Andi yugirigya lagagirik, it avakwa wisane homari wagek yugu-sigik, Yesus en it yugirigya dugwit, “Hit avakwa o yogak agipik yi, hit weyak dombok ogarit lagu hinigis. ‘Hat avyarat mbogot vaga en Ala en lakbaga wagagi, nit ninelup arup menda ambi ogagya heyasogom,’ yiluk, yuknisagwi ovara, Anen adik ambi ogagya neyasogom buk. Ata, ap Yunus ako en enelup arup menda ogagagi ako andi adigat ogagya neyagup. ");
INSERT INTO nbq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","At Yunus ako avakwa o Niniwe enelup agek welagagi ako hak, An Ap At Endaklagagis ako hit avakwa o yogak agipik yi, henelup agek agirik. ");
INSERT INTO nbq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","O endak, hwa ombok ambi at amwa o adumu selatan vikit en at ap Salomo endawi werek dugwit, wene hulisiga menda ako aruk huligiluk wagagi. Wagagi ovara, at Salomo andi, ap horogat welagagi, eke, At ambi yoma agarik yi andi, mondok ombok erogo agarik. At hwa ombok ako en ap horogat ane huligiluk wagagi ovara, hit andi, At ombok agarik ako ane hunggitek agipik. Anderogo atma, hivis avakwa enowak dilup hudi vaga at hwa ombok ako en mendek yiluk, hit yogak agipik yi yukhirigya dugwit, ‘An ap horogat Salomo ako ane hunggwigis ovara, hit en ap ombok yi ane hunggitek atma, henanggadi ares,’ yiluk, yukhirigya hagup. ");
INSERT INTO nbq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","At Yunus andi, ap maduk ovagak dugwit, avakwa o Niniwe menda Ala wene yugirigya lagagimu, it ovok erogo enasam helok, enomaduk mbo bagagwa. Mbo bagagwa ovara, at ambi yoma agarik yi andi, ap mondok ombok atma, wene yukheraliga ako hobaluk, henomaduk mbo baup sek hegek, henendawi mbuk agipik. Anderogo atma, hivis it avakwa enowak dilup hudi it o Niniwe menda ako en mendek yiluk, hit yogak agipik yi yukhurugu dugwit, ‘Nit ap maduk Yunus ako yuknirigya lagagimu, nenomaduk mbo bagagup ovara, hit ap ombok ane hunggitek atma, henanggadi ares,’ yiluk, yukhurugu inisasogom,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yugirigya lagagirik, ambi yugirigya dugwit, “Avakwa en unda yevedogo baluk, mbedak avema a, sogolowak avema a, hwilak belagudek. Ata, yevedogo baluk, it avakwa sup nunggu wendagwi ako awia haupwak yiluk, winimen sigama belagwi. ");
INSERT INTO nbq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hit heneyave unda yevedek ovagak awia ako andi, hinil at. Hit hinil sek agipik halok, heneyave ovok erogo awia dogogup. Eke, hit hinil weyak werek halok andi, heneyave ovok erogo o hwiserek ovagak dogogup. ");
INSERT INTO nbq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Andi halok, henendawima awia agarik ako dek agya dugwit, o hwiserek ovagak agya hao en, dibagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hit heneyave venak vikit ambi o hwiserek ovagak dek ovok awia adigat agarik halok, unda awia yovalevet higya dugwit, heneyave awia erogo bigaliga hak, heneyave ovok awia erogo dogogup,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wene andi yugirigya lagagimu, ap Parisi menda ambi en, “Ninim erom naguluk, oma,” yiluk, Yesus yugogogi. Yugugu lagagimu, At Yesus ap ako amwa nunggwigya lagagirik, erom nagiluk, hora yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Erom nagiluk, At inggis adat vaga horekdek dugwit, we un hora yagagi ap Parisi ako il higya lagagirik, “Ap yi nggarogo ogasiga wi!” imbitigi. ");
INSERT INTO nbq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ap Parisi ako imbitya lagagimu, At Nenasin Yesus ako en, “Hit ap Parisi menda en Ala sek nenombarupwak yiluk, henagas owak sogolowak inim, henowalup inim, agavelo weram adigat hurisagwi ovara hegek, henendawi ilim andi avakwa enangge ndiyalogo hedaup inim, yi weyak ndi weyak ogarup inim, henendawima wisane hobo-hobo erek agipik. ");
INSERT INTO nbq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hit ap wes ovagak yi! At Ala agavolo weram ogovak higitigi ako en enendawima inim ogovak higitigi dek yiluk yagalagwi? ");
INSERT INTO nbq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dek! Henendawima ilim en it ap ininggis dek wogorugu hiniselok andi, Ala en sek henombarisogon. ");
INSERT INTO nbq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hit Parisi menda yi, we un divu angga, hibi angga, erom angga, mbinde angga ako wogogo Ala ake sek belagwi ovara, hegek, avakwa enowak sek erogo dilisagwidek, eke, Ala hinim henendawi hunik ogasagwidek. Anderogo atma, anggin henovaga arugup! Wene adem ombok andi, ogagu dugwit, maridik-mariduk andi inim lobalogo ogarup sek atma, ogagu dogop. ");
INSERT INTO nbq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hit Parisi menda yi, it Yakuri samban ogasagwima akoma ap ombok-ombok hora yagalagwima hora yugwi, o vasat ogasagwima nit adigat vok yuknerapwak yiluk, nagwis, ogagu dogop henendawi hogop adigat ombasagwima, anggin henovaga arugup! ");
INSERT INTO nbq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Avakwa enunggut inigik, hiren weyak ogarupwak yiluk, enendawi nomalisagwi atma, anggin henovaga arugup.” ");
INSERT INTO nbq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yugugu lagagimu, ap Musa wene mamuleraliga menda ambi en wene onggo Yesus yugugu dugwit, “Ngguru wai. It wiyiknom-weyaknom okbisaliga vaga nit ninim nenanggadi asiga.” ");
INSERT INTO nbq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yugugu lagagimu, Yesus en, “Hit ap Musa wene mamulerelagwi menda ogo, Yakuri wene yugup yerogo ogarup nderogo ogarup wene anggin wisane menda avakwa yugeralagwi ako, avakwa enomado vaga ndan okbaluk, wene ako anggin adigat viyaliluk nagu-sigik, yonggarinisaup embetetek, hinil biginigik hoda wilisagwi atma, anggin henovaga arugup! ");
INSERT INTO nbq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","It navi-navi hit henombawi en enarogo bogogwa ako, hiren it enowak o wimu bagagwa akoma sek erogo wet ogasagwi. Enowak o wimu sek erogo wet ogasagwi ovara, it wene yagagwa ako ogasagwi dek atma, hit henombawi en navi-navi enatugwa ako andi, ‘Sek at ogagagwa’ yiluk, yugu hinigis. Anderogo atma, anggin henovaga arugup. ");
INSERT INTO nbq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anderogo yiluk, At yi menda ndi menda ovok ilup agarik Ala ako en iri dugwit, ‘Navi-navi inim, lakbigik menda inim, lakbisa wagya neyalok, hit Iserael menda en nin initwis, nin anggin enovaga bisaguluk enamusek lagwi, ogagu hinisayogon o,’ yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Anderogo atma, o wen yi wakagagi hudi en lenak-lenak it ap navi-navi enamuya wombagagi ako hit avakwa o yogak agipik yi henovadombok, yiluk, henarisogon. ");
INSERT INTO nbq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","O muk Habel amuya wombagagi hudi en vivis ap Sakariya o Ala awi valekma Ala ake warogo hali hunisagwima ilim andoma amuya wombagagi hudi andi, ovok erogo andi hit yogak agipik yi henovadombok, yiluk, henarisogon, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Hit Musa wene mamulerelagwi menda yi, yi wene ndi wene avakwa enelup agu sao en, sup kunci hit at hwilagogo vakbaluk werekma, anggin henovaga arugup! Nirat wene ninelup arup, embetetek dugwit, it nin enelup arup ombasagwi ako enelup agu sao en, sup ando mbabiselagwi,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yugirigya lagagirik, o andoma en wunggu lagagimu, it Musa wene mamulerelagwi menda inim, ap Parisi menda inim, o andi hudi en At ane yupum-ndupum yimi vaga yidilogo baluk, vagaruguluk, enaninis en aigwakma dirit-darit wugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","It Musa wene mamulerelagwi menda inim, ap Parisi menda inim, Yesus vagaruguluk, enaninis en aigwakma dirit-darit wugu-sigik, it avakwa eneyave wisane ininggis dinggilup meyan homakbaluk, hobo-hobo en enovaga sep yagan lagagwa. Sep yagan lagu-sigik, At Yesus en At ane welagwi menda enendak yugirigya dugwit, “It ap Parisi ako en enendawi enagavoval amulisagwi yukherelagwi. Enagavoval amulisagwi yukheralagwi ako andi ragi roti virisiga menda hak. Ragi ako, horok maduk atma yedok helagwi dek ovara, andi vaga roti ombok vikbaluk sigam helagwi. Anderogo hak, it enagavoval amulisagwi yukheralagwi ako andi, wene andi menda wugu hisao, suwam watu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yi wene ndi wene enendawima sovalek agarik halok andi sigam agya, eke yi ogagwi ndi ogagwi hwilago agarik halok andi vagalagya, ogarisogon o. ");
INSERT INTO nbq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Anderogoma, hit o hwiserekma dugwit, yugu lagagup ako o awia vaga yugu hunggwis, eke, umwa ilim andoma dugwit, wene madi ngguruk yugu lagagup ako, o selekma winimen andoma en hum-naik vaga vagalagya, ogagya hagup,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yugirigya lagagirik, ambi yugirigya dugwit, “Ai naswei. An wene ambi yukherayogon. Avakwa en henagavelo adigat henasagwi ako andi, henalon ombarubuk. Henakbaluk, nggarogo okbigigaup embetep? Dek aro. ");
INSERT INTO nbq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hit henalon ombasagwi ako andi, An hurimbis yukherayogon. At henagavelo mondok henakbaluk, hali abya wuluk-herek yagaligama lakbigigaup andok ako andi, henalon umbutu dogones. At mondok henalon umbutu dogones o, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Yoparip mariduk mberen vaga swa wudue 5 eneyave dambup erogo hunisagwi ako dek a? Onggo maduk at hunisagwi ovara, At Ala en swa ambiat ambi mondok inggut asigadek. ");
INSERT INTO nbq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hiniris ogo ovok erogo At Ala inggis dinggilik agarik. Anderogoma, swa mariduk eneyave wisane dambulogo at endawi hunik horogat agarik ovara, hit ako andi, At endawi hunik ombok erogo henombasigama, henalon umbutu dogobuk,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Wene yugirigya lagagirik, ambi yugirigya dugwit, “Hiren avakwa inivaga, ‘Yesus andi Nenasin aro,’ yiluk, vaganggu hiniselok, An Ap At Endaklagagis ako en it Ala yonggo lakbisa wandiga menda malaikat ako inivaga, ‘It avakwa yi, an narwi aro,’ yiluk, yisogon. ");
INSERT INTO nbq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Eke, hit avakwa inivaga, ‘Yesus andi, nininggut,’ yugu hiniselok andi, an ogo, it Ala yonggo lakbisa wandiga menda malaikat ako inivaga, ‘It avakwa andi, An ninggut o,’ yiluk, iri neyagup, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","An Ap At Endaklagagis ako enane wiyiknom-weyaknom erogo banunggu-selok, enomaduk andi, Ala en dek erogo bisayogon ovara, Averiniki wiyiknom-weyaknom erogo bagu-selok andi, enomaduk andi, Ala en dek erogo bisayogon mondok dek aro. ");
INSERT INTO nbq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","It avakwa Yakuri samban ogasagwima homago inim, it ap ininis werek inim, it ap ombok-ombok inim, enadema wokhiniviluk bigiga lagu-selok, henendawi anggin dugwit, ‘Nenagap wendakhedaup yiluk, wene ngga yugerami?’ yiluk, henendawi wenggelubuk. ");
INSERT INTO nbq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Andi hudi wene yugeraup yiluk, Averiniki en, ‘Anderogo yugeran o,’ yiluk, yukhirigya hagup,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yugirigya lagagimu, it avakwa wisane homago ako ambi en Yesus yugugu dugwit, “Ngguru wai. An nowa en nasin eyase nin higirogo woknirupwak yiluk, yuguru.” ");
INSERT INTO nbq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yugugu lagagimu, At Yesus en, “Avyak! Henowak dilogo heneyase sumbukheraupwak yiluk, an at denogo baninggigi embeten?” ");
INSERT INTO nbq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yugugu lagagirik, Yesus en avakwa yugirigya dugwit, “Angge wisane agarik ako vaga hiniluk dogosogom dekma, ap enangge hogop-hogop umbutu hinisao en, henendawi suwam watu dugwit, dibagu dogwes,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yugirigya lagagirik, wene wakhegek yugirigya dugwit, “Ap inggi werek ambi en awi-angge wen mudis vaga yagagirikmu, enggen yugup wisane agagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Enggen yugup wisane agya lagagimu, endawi imbita dugwit, ‘Yagagis enggen yugup mbalek baup o dekma, nggarogo ogarik?’ ");
INSERT INTO nbq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Imbitya lagagirik, ‘Yerogo ogasogon. An o maduk yi, masalogo bagya dogomindik, o ombok erogo vabaluk, nangge inim, yagagis enggen yugup ako inim, andoma ba nunggigya dogosogon. ");
INSERT INTO nbq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ba nunggigya dogomindik, nangge wisane wonggalek agarik ako ninggya neyagek yi tahun ndi tahun ogarupwak yiluk, yogak sat yanggal hedigya dugwit, erom ninggya, amburup ninggya, enda adigat yagan lagya, ogagya dogosogon, yiluk, nendawi dibaluk ogasogon o,’ yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yagagi ovara, At Ala en, at ap ako yugugu dugwit, ‘Hat ap wes yi, wai! Yogak o hup yi vaga hat henendawi An wa warisogonma, hat vipuk erogo bagen ako hivis sa en andok arisogon embeten?’ yiluk, yugisogon. ");
INSERT INTO nbq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Anderogo atma, it avakwa enangge wen vaga menda adigat wisane okhidugu dugwit ovara, enangge eyave mbogot vaga menda okhedegetek iniselok, at ap andi ndatak aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yugirigya lagagirik, Yesus en At ane welagwi menda ako yugirigya dugwit, “Niniluk dogop yiluk, nenagarom nano namwi? Eke, neneyave vaga nenayum nano yikhedamwi? yiluk, henendawi umbutu dugwit, henendawi anggin dogobuk, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nelagwi menda andi, horogat ovara, hiniluk dogop andi, iya. Eke, yikhedelagwi menda andi, horogat ovara, heneyave ako andi, iya aro. ");
INSERT INTO nbq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Swa ngguragas ogasagwi ako dibas. Awi yakhidugwi, enggen mbanggwis, andi ogasagudek. Eke, o ndanggi enggen mbalogo beta nunggwisagwima ogo, dek adigat ovara, at Ala en enagarom wogeraliga. Swa andi, at endawi hunik horogat hegek, Ala en enagarom wogeraliga ovara, hit andi, at endawi mondok hunik atma, wokherayogon dek ombasagwi? Wokherayogon aro. ");
INSERT INTO nbq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hit ambi hambup vanggo yi wagya hegek, ‘Niluk ambukumat inim dukluk, hambup sek ai,’ yiluk, henendawi anggin wenggelit lagwi vaga ndatak okbugugu hagup embetep? Dek. ");
INSERT INTO nbq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Henendawi anggin wenggelit lagwi vaga ambukumat dukluk hambup okbigigaup meyan atma, henagarom naup inim, henasum yikhedaup inim, henendawi anggin wenggelek dogobuk. ");
INSERT INTO nbq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yo hundumbuk mot inggya lagarik, agare enggen yiliga ako dibas. Salomo ap mondok ombok yum pakian sek adigat yirik halok, avakwa en, ‘Wi,’ yiluk, vok yugu lagagwa ako ovara, at horogat o. Yo hundumbuk agare enggen halok andi, yavup ogagya, digi danggya, ogasigadek ovara, Ala en unde watya hegek, agare enggen mondok segedok yiligama yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yo-angga heda-angga weram yogak mudi-mudis inggya, heveret sakni bagu-selok, hali ninggya, ogasiga ovara, At Ala en elese sek erogo baligama, aren yo-angga ako maduk okbagya, eke, hit avakwa Ala horogat avyarat ombasagwi menda yi, hit mondok iya dombok heneyaga dogosogon buk embetep? ");
INSERT INTO nbq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Anderogoma, ‘Nenagarom-nenagas nano namwi?’ yiluk, henendawi wenggelit lendagwi andi, moga. Henendawi anggin dogobuk. ");
INSERT INTO nbq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","It avakwa weram menda ako en, andi menda ovok erogo belalit nelagwi ovara, hit andi, ‘Nit andi menda dek,’ yiluk, hogop ombasagwi ako At henasin elup agarik. ");
INSERT INTO nbq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hiren ‘An Ala avema dogop, ai,’ ombakluk, endak musek lagu hiniselok, vivis andi menda ovok erogo ovaga dulogo wokhirigya hagup,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yugirigya lagagirik, At Yesus en, “Naburi wai! Ala en hit at avema dogop imbitigi ako, sek menda dikduk erogo okbigigaup endawi sek imbitigirikmu, henalon habuk. ");
INSERT INTO nbq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Henangge vaga onggo hunggu dogomundik, ap ininggis dek halok, yoparip wogoranes. It ap enonggop en wa nunggugwi, hudu-hudup libilit nunggwigya, ogasigadekma mbogot vaga andoma henangge eyave sek, dek arup dek ako menda yidik dogopwak yiluk, yum awi libik yagaliga dek ako menda yikhidugu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Henangge wonggalek werekma, henendawi ogo, andoma at dogosogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Wene ambi yugirigya dugwit, “Henayum, henamboranis nggitik-nggetok yirik dugwit, hininggimu unda mondok yevedek dikduk erek dogones. ");
INSERT INTO nbq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ap hwa hidigyama isogo isagusim akoma en ap ombok amwa sup vupuk ogari wagya hao en, ayelomani en mbikit sup huthaguluk, sokhelagwi hak dogones. ");
INSERT INTO nbq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Enasin en ayelomani ako iniluk dugwit, suwam watusim isa wagya halok, adenggen enombarisogon. Suwam watusim isa wagya halok, asin en asum nggolabaluk, at ayelomani isogo naupwak yiluk, ambekma horabisiluk, enake ogagya dogosogon, yiluk, avyarat yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","O hup agako vaga warimi a, o yanggo irisim warimi a, wagya dogomindik, ayeloman anderogo iniselok, adenggen enombarisogon o. ");
INSERT INTO nbq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hit dibas! At ap awi werek en, ap onggop waliga menda ako mo il andi vaga wasogon, elup aklip en, ‘Sup lakbaluk, nangge onggop wa nunggu wagu sao en,’ yiluk, nogo yigitek mondok-mondok suwam watya duklip. ");
INSERT INTO nbq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Anderogo hak, An Ap At Endaklagagis ako mo il andi vaga warup nembetetekma hinigik, wasogonma, hit ogo mondok dikduk okbaluk, dogones o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yugirigya lagagimu, Peterus en Yesus yugugu dugwit, “Nasin wai. Wene wakhegek yukneregen yi andi, nit adigat yukneregen a, ata it avakwa ovok erogo yugeregen a?” ");
INSERT INTO nbq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yugugu lagagimu, At Nenasin Yesus en, “Andi halok, Ap ombok ayeloman ambi endawi werek yavup dikduk ogagya halok andi, at asin ap ombok ako en at ayelomani nin andi yugirigya dogopwak yiluk, mondok okbagagi. Mondok okbaluk, winggigi. Wunggu hegek, ayeloman ako en, it nin ako enagarom wogeraup agya halok, enagarom des erogo wogeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Vivis it enasin ako wagya dugwit, at ayeloman ambi ako anderogo dikduk ogagya halok, asin ako endawi adenggen ombarisogon. ");
INSERT INTO nbq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Asin en ayeloman ako anderogo ogagyama adema wagya halok, angge-angge ovok erogo aruwam dogopwak yiluk, mendok okbayogon, yiluk, avyarat yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Eke, ayeloman ako en endawima imbitya dugwit, ‘An nasin arabu dukluk wasogon ai,’ yiluk, at asin ayelomani nin ap inim akwa inim yo yawi enatya, yi menda ndi menda ugun nenggek adigat lagya, amburup nenek oginivisiga menda ninggya dugwit, nenek ogarit lagya, ogarit lagya halok andi, nggarogo oklarup ombasagwi? ");
INSERT INTO nbq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ayeloman ako en, ‘Nasin ndugwis andi vaga wasogon,’ eke, ‘Mo il andi vaga wasogon,’ embetetek ugun inggutmu at asin ako wagya dogomindik, ayeloman ako eyave libik-lobak erogo it ap avyarat ombasagwidek menda bisaligama akoma at lakbayogon. ");
INSERT INTO nbq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ap ayeloman ambi asin ogarup ombasiga ako elup ovara, dikduk okbaluk, ogagetek halok, yo yawi vaga hegek-kegek watya hagup. ");
INSERT INTO nbq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Eke, ayeloman ambi asin ogarup ombasiga ako inggut dugwit, weyak ogarimi vaga onggo yo yawi warup ovara, horogat watya hagup. Ala en ombok erogo wokhirigya dogomindik, hivis, ‘Ombok erogo wokheragagis ako vaga, ombok erogo ogagagup a dek a?’ yiluk, yukhirigya, eke, vagago dogovovok yiluk, ombok erogo hininggimu bigigya dogomindik, hivis evenuk, ‘Ombok erogo hininggimu begegis ako vaga, iya erogo ogagagup a dek a?’ yiluk, yukhirigya, ogagya hagup o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yugirigya lagagirik, ambi yugirigya dugwit, “Anen o wen vaga yoma ovok erogo hali bagiluk wagagisma, mbikit hali abya bagibuk, ai, ombasiga. ");
INSERT INTO nbq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Avakwa ima wombabiselagwi hak an anggin-mbanggin okbanup yiluk agirik ovara, wotok erogo okbanup hudi aoma, nendawi mondok anggin dombok okneraliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","It avakwa o wen vaga yoma enendawi ugun adenggen erogo dambubisagiluk, wambu wagagis embetep? Dek. Ogorogo bisagiluk, wambu wagagis o, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yogak en ap ambi aburi 5 halok, henggam en mberen inim ogorek, eke, mberen en henggam inim ogorek, inisagup. ");
INSERT INTO nbq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Inim ogorek dugwit, asin en abut inim ogorek, abut en asin inim ogorek, isa en eyak inim ogorek, eyak en isa inim ogorek, ombak en, abut inim ogorek, abut en, ombak inim ogorek, inisagup,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yugirigya lagagirik, Yesus en it avakwa wisane yugirigya dugwit, “O Iserael yoma hena mo il huruk yi landigama barat vikit en daga wagya halok, ‘Wi! Andi musu nagiluk, ogasiga ai,’ yigipikmu, musu naliga. ");
INSERT INTO nbq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Eke, havut o selatan vikit en warit wagya halok, ‘Wi! Heveret o hivi asogon higi,’ yigipikmu, heveret hivi at asiga. ");
INSERT INTO nbq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wen-mbogot elese dibaluk, ‘Andi anderogo asogon higi o,’ yiluk, hinilup ovara, yogak yi hudi vaga arup ako hit nggarogo yiluk dibagatek, ‘Wi! Ala anderogo ogasiga higi,’ yiluk, yegetek at agipik? Hit henagavoval at ovagak yagalagwi yi!” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yugirigya lagagirik, ambi yugirigya dugwit, “‘Sek ogarup yi at higi,’ yiluk, henadik-henadik dibaup sek hegek ovara, nano yiluk sek ogarup dibagatek agipik? ");
INSERT INTO nbq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ap hinim ogorek ako hinim at ap enowak dilisiga menda adema lamwi halok, sup vaga ao hinim lagu dugwit, hodo erogo vagalogo hinim henendawi dambulhedaup. Dek halok, at hinim ogorek en likhiniviluk ap owak dilisiga menda adema bigigya lagya, andi en, ap enowak dilisiga menda en ap ayegen werek adema bigigya lagya, andi en, ap ayegen werek ako en ap heda marogo mabiselagwima mabugugu, ogagu sao en, sup vaga ao hinim nagu dugwit, hodo erogo vagalogo hinim henendawi dambulhedaup. ");
INSERT INTO nbq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Heda marogo mabiselagwima mabugugu-selok, at hinim ogorek agarik ako en, ‘Onggo anderogo baup,’ yiluk, yukheragagi ako mondok ovok erogo bagetek hegek, andoma en wibigigasogom mondok dek aro, yiluk, yukheraliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","O andi hudi avakwa nin en, “Avakwa Nggaliliya menda en Ala ake warogo hali bagusim, ap Gubernor Pilatus en enetas,” yiluk, Yesus yuguri lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yuguri lagu lagagwama, At Yesus en, “It ap Nggaliliya menda nin enomaduk horogat halok, hekbugu, eke, it enetas andi, enomaduk wisane ogagu lagaorikmu, anderogo enatya, ogaga embetep? ");
INSERT INTO nbq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mondok dek o. It enomaduk andi it nin ndatak welagao. Anderogo ovara, hit weyak ogasagwi ako henasam helok, mbo bagetek hiniselok, hit ogo, anderogo dek okbugugu hagup, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O Siloam o adup valek ndun iri dugwit, it ap 18 hudi sopalinipigi ako andi, it avakwa ugun Yerusalem agarwikmu andi, weyak ogagatek enomaduk horogat inigik, eke, it sopalinipigi andi, enomaduk wisane erogo ogagagwarikmu, sopalinipigi embetep? ");
INSERT INTO nbq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mondok dek. It enomaduk ndatak aro. Anderogo ovara, hit weyak ogasagwi ako henasam helok, mbo bagetek hiniselok, hit ogo, anderogo at dek okbugugu hagup, yiluk, yukheraliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yugirigya lagagirik, wene wakhegek yi, yugirigya dugwit, “Ap ambi eyavupmu, yo widis ambi yago welagagi. Welagagirikmu, enggen yugup mbaligiluk, bikhelagagi ovara, enggen yugup dek adigat higya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Enggen yugup dek adigat higya lagagirik, at ayeloman eyavup ogasiga ako yugugu dugwit, ‘Yo widis yi ako enggen yugup mbaligiluk, bikha wagek ogagya neyagek, 3 tahun ogagagi ovara, enggen yugup dek adigatma, wen enam warogo dogogwi en, murogo bain.’ ");
INSERT INTO nbq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yugugu lagagimu, at ayeloman ako en, ‘Nasin! Tahun yi vaga anen va yugu, adem mogot mbanggya, ogarup imbitirikmu, hekbaup. ");
INSERT INTO nbq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Eke, tahun yi okbaluk, ambi agya vaga enggen yugu halok andi sek. Eke, enggen yugu dek halok andi, murogo banok o,’ yiluk, yugogogi o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Andi en, hivis At Yesus it Yakuri samban ogasagwi vaga it samban ogasagwima ambi wene mamulirigyama, ");
INSERT INTO nbq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","hwa ambi madis endawima nunggwigya lagagirik, aup edup hegek, tahun 18 ogagagima, ambor hedalek atmamendek yup meyan at welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Meyan at werekma, At Yesus en hwa ako il higya lagagirik, yanggup yugogogi wagya lagagimu, yugugu dugwit, “Hwa yi wai! Edup ako mondok dek okbagagi o,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","inggis ao vakbagya hegek, hwa ako ambor edup akodek agya lagagimu mendek yiluk, Ala inis siyabagagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Andi ogagya lagagimu, ap Yakuri samban ogasagwima enasin ako it samban ogagwi vaga Yesus en hwa ako sek ogagya higya lagagirik, aninis en avakwa yugirigya dugwit, “Yavup ogarup yiluk ndugwis 6 hudi denek werekma, ndugwis 6 hudi denek andi vaga ugun edup sek okbigigaup yiluk, wagu dogop andi sek. Eke, nit samban ogasagwi yi vaga wagek yup andi dek.” ");
INSERT INTO nbq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yugirigya lagagimu, Nenasin Yesus ako en at yugugu dugwit, “Hit avakwa henendawi henagavoval ovagak yugerelagwi yi wai! Hit ovok samban ogasagwi vaga henanggom sapi a, henanggom keledai a, davoma larikmu, is naupwak yiluk, sogop hurugo baluk woginiviluk landagwi ako dek? ");
INSERT INTO nbq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eke, andi halok, Averaham ombao hwa yi, Sile en heda marogo vagogo welagagi hegek, 18 tahun ogagagirikmu, hit samban ogasagwi vaga heda visilogo hekbaup andi, moga atma yiluk, yagalagwi? Heda visilogo hekbaup andi, sek at.” ");
INSERT INTO nbq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Andi yugeragagi vaga at inim ogorek welagagwa ako enanggadi erogo bogogi ovara, it avakwa nin en At Yesus eve iya nggarogo ogarubuk menda ogarit lagya lagagi ako vaga enadenggen umbutu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Andi, At Yesus en, “Ala avema bisaup ako andi, nano ndatak? Eke, nano vaga wakhaik? ");
INSERT INTO nbq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dek. Ala avema bigigaup ako andi, ap ambi vudok enggen yatya lagagimu, oklagagi hak. Vudok enggen yatya lagagimu, avuduk ingga dugwit, yo ako ombok agagi. Ombok agya lagagarik, abwak vaga yi swa ndi swa mbogot vaga nelagwi menda enawi valheda nunggugu lagagwa o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Andi yugirigya lagagirik, ambi yugirigya dugwit, “Ala en avakwa at avema bugu lagagimu eneyave wisane wigalarup ako nano vaga wakhaik? ");
INSERT INTO nbq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Avakwa Ala avema ako andi, ragi roti virisiga menda ovagak. Andi, hwa ambi en ragi roti virisiga menda ako horok maduk at tepung wisane inim hudilogo wombabaluk, ragi roti virisiga menda ako menda inim muduk-medak ogagya halok, ovok erogo virisiga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Andi en, At Yesus ako o Yerusalem lagya dugwit, o kota ombokma inim, o madukma inim, ambima nonggegek ogarit lagya dugwit, wene mamuleregek lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lagyama, ap ambi en, “Nasin wai! Avakwa ovok erogo enagap wendarimi a, ata ambitap adigat enagap wendarimi a?” Yugugu lagagimu, At Yesus en it yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Sup maduk vaga nunggup yiluk, dil watu dogones. It avakwa wisane nunggup yiluk, ogarugup ovara, meyan at hagup o, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","At awi werek ako en mendek yiluk, sup latya dogomima, hit weram sup vupuk ogagu dugwit, ‘Nasin! Sup hut neran,’ yugurugup ovara, Aren, ‘Hit ap nggoma en wagep? Hit An ninggut,’ yukheragwi. Yukhirigya halok, ");
INSERT INTO nbq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","hiren At yugugu dugwit, ‘Dek. Isogo ninim nunggu lagyo ako. Dek. Ninawi mbumbumu wene mamulnirigya lagen ako o,’ At yugurugup ovara, ");
INSERT INTO nbq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aren, ‘Hit nggoma en wagep? Hit An ninggut. Hit weyak ogasagwi yi, hodo wilitales o,’ yiluk ");
INSERT INTO nbq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","weram wikbigigagwi. Weram wibigigamindikmu, andoma dugwit, ap Averaham o, Isak o, Yakup o, eke, it ap Ala en yugirigya hegek yugeralagwi menda navi-navi ovok erogo Ala avema agarwik inugu dogogupik, henaninis en yup yagwi, henaik nggidit-nggidit yugwi, ogagu dogogup o. ");
INSERT INTO nbq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","It avakwa o weram en o mo daga wandiga venak-venak vikit en, o mo huruk yagaligama vikit en, Ala avema bisaligama isogo naguluk, homari warugup. ");
INSERT INTO nbq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Homari wagu dogogupik, it ap hivis agarwik ako andi, nin enendak agwi, eke, enendak agarwik ako andi, nin hivis agwi, ogagu inisagup,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","O andi hudi vaga, it ap Parisi menda nin en Yesus adema lagu lagagwarik, At yugugu dugwit, “Ap Herodes harup imbitama, yoma en hodo erogo wilin.” ");
INSERT INTO nbq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yugugu lagagwama, Yesus en, “At ap yangge do ovagak andi, wene yi yuguri elales: An yogak inim, heveret inim, madis ap enendawima agarwik halok, nggigilogo wibugu, aup edup halok, sek okbugu, ogagya dogomindik, ndugwis mberen dukluk ndugwis ambi vaga An ogarigiluk wagagis ako andi, mondok wotok erogo ogasogon. ");
INSERT INTO nbq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Anderogo ovara, ap navi ambi o hunogoma en hambup meyan, o Yerusalem adigat hambup sek atma, yogak inim, heveret inim, dogovit inim, An andoma lagya dogosogon aro. ");
INSERT INTO nbq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ai! Yerusalem, Yerusalem! It ap navi-navi ako initwis, ap Ala en yonggo henadema lakbisa wagagi andi, helep vaga initwis, ogasagwi menda atma ai! Swa ayam isa en eyagi alup amik avema sovalbisiluk agarik hak, anen hit heneyagi anderogo at wonggalogo bisaup ndugerek-ndagarek imbita lagagis ovara, hiren, ‘Nenanggon,’ umbutu lagagupmu, ai! ");
INSERT INTO nbq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hit Yerusalem menda hit henawi yoma Ala en hekbigigamima, hit hinil nggale yusogom. Hiren, ‘Nenasin Ala en lakba waga yi, inis siyabasogom o,’ yiluk, yegetek hegek, hinil mondok neyagetek dogogup o, yiluk, yukheraliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Hivis it Yakuri samban ogasagwi ambi vaga At Yesus en erom naguluk ap Parisi enasin ambi amwa nonggagagirikmu, avakwa en at inil vurek welagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Inil vurek inigik, ap ambi edup inggis-isok virik Yesus adema werekma, ");
INSERT INTO nbq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","At Yesus en Musa wene mamulerelagwi menda inim, it Parisi menda inim, yugirigya dugwit, “Yakuri samban ogasagwi vaga avakwa sek oginivup andi, sek a, weyak a? Ala wene yugup Musa dirup mbanggigi ako vaga bikhugu dugwit nggarek helagwi?” ");
INSERT INTO nbq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yugirigya lagagimu, it ovok erogo enane mondok dek mbup yagagwa. Mbup yugu lagagwama, At Yesus en ap ako inggis vagogo sek okbagya lagagirik, lakbalagagi. ");
INSERT INTO nbq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lakbalagagi lagya hegek, At Yesus en it yugirigya dugwit, “Hit samban ogasagwi vaga hit ambi henabut a, henanggom sapi a, wen bavulikmu is yanggadekma nggedek wambigya halok, hit mbikit vagogo badaga warup sek a, weyak a?” ");
INSERT INTO nbq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yugirigya lagagimu, enane onggo yugurup meyan agya lagagimu, mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","At Yesus ap Parisi amwa erom nunggu dugwit, it avakwa erom naup enayonggo bagagi ako, At Yesus en it ap ombok hora yagalagwima adigat hora yi wagwi inugu lagagirik, wene wakhegek yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ap hwa hidigya dugwit, isogo naguluk, henayonggo bagya halok, ako lagu dogomundik, ap ombok hora yagalagwima andoma hora yubuk. Hit ap horogatma, eke, ap ambi mondok ombok ayonggo bamindikmu wagya halok, ");
INSERT INTO nbq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","at hinim henayonggo bamindikmu ako en hit yukhera wagya dugwit, ‘Avyak! Ap yi, hit henaveloma hora yipim hit witlares,’ yukhirigya halok, henanggadi embetek ap ugun hora yagalagwima hora yi laup agya hao en, ap ombok hora yagalagwima hora yubuk. ");
INSERT INTO nbq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Henayonggo bagya halok, ako lagu dogomundik, ap ugun hora yagalagwima andoma hora yup. Horaik werekma, at henayonggo bami ako en hit yukhera wagya dugwit, ‘Nowa-nasin. Hit ap ombok hora yagalagwima yoma hora yi omanes,’ yukhirigya halok, it avakwa ovok erogo erom naup hinim agarwik ako inivaga hit siyalek at hinisaupwak, ap ugun hora yagalagwima andoma hora yugu dogop. ");
INSERT INTO nbq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hit henendawi siyabatugu hiniselok, sovabugugu, eke, henendawi sovabatugu hiniselok, siyabugugu, ogagya hagup,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yugirigya lagagirik, Yesus en ap at ayonggo bagagi ako yugugu dugwit, “Hat isogo isagya dugwit halok, hinim hendawi hunik agindik inim, haswei inim, howa-haot inim, ininggis werek hat hinim agindik inim, it enadigat enayonggo bagya dogobuk. It enadigat enayonggo bagya heyalok, hivis it anderogo isogo isagu dugwit, onggo-onggo hat hayonggo bagu sao en, it enadigat enayonggo bagya dogobuk. ");
INSERT INTO nbq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ata, isogo isagya dugwit, ininggis dek halok, inisok venak weyak-venak weyak halok, enerambo weyak halok, inil mbuk halok, enayonggo bagya dogop. ");
INSERT INTO nbq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Enayonggo bagya heyalok andi, hendawi adenggen wisane hayogon. Eke, iren onggo wokhirup meyanma, vivis, it avakwa sek menda hombagagwa ako iniluk okbisaup hudi ako vaga onggo wokhugu hagup,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ap erom naup inim horaik welagagwa ako ambi en Yesus yugogogi ako aruk hunggu lagagirik, Yesus yugugu dugwit, “It Ala avema bisaligama dugwit, isogo namwi ako enadenggen umbutu dogosogom.” ");
INSERT INTO nbq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yugugu lagagimu, Yesus en wakhegek yugirigya dugwit, “Ap ambi isogo ombok isarup imbita lagagirik, avakwa wisane enayonggo bagagi. ");
INSERT INTO nbq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Enayonggo bagya lagagirik, isakbaluk, ayeloman ambi yugugu dugwit, ‘Isogo isago yi, mondok vedarup agyama, naup ap enayonggo bagi ako warupwak yiluk, yugeregek elak,’ yiluk, lakbalagagi. ");
INSERT INTO nbq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lakbalagagi ako en yugeregek lagagi ovara, it enadik-enadik at enanggin-enanggon yugugu dugwit, at ambi en, ‘An yavup ogarek ambi onggo bagirikmu bikha laupma, isogo isago nalaup andi, meyan o, nasin,’ yugugu, ");
INSERT INTO nbq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","eke, ambi en, ‘An sapi ninggis anggangga venak-venak hudi onggo hunggis wen ndililit wal okha lagek yipim, isogo isago nalaup andi, meyan o, nasin,’ yugugu, ");
INSERT INTO nbq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","eke, ambi en, ‘An nogwa swi at hidigirikmu, isogo nalaup meyan o,’ yugugu, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ogagagwa ako ayeloman en asin mbilinogo yuguri wagya lagagimu, asin aninis en ayeloman yugugu dugwit, ‘O kota yoma sup andogon-andogon ovok erogo lagya dogomindik, ap ininggidek halok, inggis-inisok weyak halok, inil mbuk halok, enerambo weyak halok, hodo erogo woginiviluk omano.’ ");
INSERT INTO nbq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Yugugu lagagimu, woginiviluk wagya lagagirik, asin yugugu dugwit, ‘Nasin. Yuknigin ako woginiviluk wagi ovara, hora yup nggolo wisane agarik.’ ");
INSERT INTO nbq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yugugu lagagimu, asin ako en ayeloman yugugu dugwit, ‘Andi halok, avakwa o weram sup andogon-andogon ugun agarwik ako an namwa hobo-hobo ogari nunggu warupwak yiluk, hane anye vaga eneyanggup erogo bisa wagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Isogo naguluk, endak enayonggo bagi ako ovok erogo an nagasogo isago na nunggu warup mondok dek aro,’ yugogogi,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Avakwa wisane Yesus inim nagusim, Yesus en elese ambukmu laklagya lagagirik, it yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Hit hinisai-henasini inim, henabur-henogwa inim, henowai-henarwi inim, eke, hit heneyave dombok inim, henendawi inim hunik ombok erogo dugwit, an ninim henendawi hunik horagat dugwit, an nadema wagu hiniselok, an nane welagwi menda arusogom mondok dek o. ");
INSERT INTO nbq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Henagyo winik hedelok an ninim warup embetetek hiniselok, an nane welagwi menda arusogom mondok dek o. ");
INSERT INTO nbq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Hit an nane waup umbutu hiniselok, endak ogarup andi wakhegek ambi yisogon. Hit o adup valit dagaup ombasagwi halok, ‘Valup onggo baup ovok werek a, dek a?’ yiluk, hininggis dingginggitek hegek, valisagwi embetep? ");
INSERT INTO nbq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Yoparip hininggis dingginggitek hegek vanggu hiniselok, wen bavulogo owak wombabaluk, wake ao sambunggitek hegek yoparip dek agya halok, ap nin en inil hugu dogomundik, ‘Ap yi, o valup yiluk ogaga ovara, atok dek agya halok, hekbagas yi, hanes o,’ yiluk, henaganda hambusogom ako dek? ");
INSERT INTO nbq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Eke, ap ndugandok ambi en ndup ogari laup yiluk, ndup ako avok wililisiga halok, arwi endak dibisiluk, ‘An narwi eneyave sepuluh ribu en it ninim ndup ogorek eneyave dua puluh ribu werekma, ndak enari laup a, meyan a?’ yiluk, wal okhegetek hegek, yamburi landiga embetep? ");
INSERT INTO nbq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wal okhelok meyan agya halok, it inim ndup ogorek ako ao wagu-sigik, ‘Ndup vage moga erogo yo ngguvunggup o,’ yiluk, yonggo lakbisa landiga ako dek a? ");
INSERT INTO nbq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Andi ogasagwi ovagak, hit ambi henangge-henangge ovok erogo hek baup henendawi wal okhegetek hegek an nane welagwi menda arusogom mondok dek,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Wene ambi yugirigya dugwit, “Garam sek ovara, aitek agya halok andi, nggarogonggan en edup werek ogarup? ");
INSERT INTO nbq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Garam aitek ako andi, wen mudis arupwak yiluk, yavup yagoma a, wen weyakma a, balip ovara, ambi ogarup dekma, mondok mbo belagwi. Henaruk werek halok andi, des erogo at henaruk hunggu dogwes,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","It ap pemerintah enake yoparip wonggalisagwi menda inim, weyak ogasagwi menda inim, ovok erogo Yesus ane hulusogom yiluk, at adema lagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Adema lagu lagagwama, it Parisi menda inim, it Musa wene mamulerelagwi menda inim, iren Yesus it ap weyak ogasagwi menda andi inim inigu lagagwarik, enanggin-enanggon yugu dugwit, “Ap yi, avakwa weyak ogasagwi menda woginipu lagarik, inim erom naliga hinil yokhanes!” yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yugu lagagwama, At Yesus wene wakhegek it yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hit ambi henandomba eneyave 100 werekma, ambiat bolagya halok, 99 adigat iringga nenggek nelagwima nenggek nagu-sigik, ambiat bolagagi ako hekbagetek ilik lagek-wombalagek belalit nagu lagipik, havethedelagwi ako dek? ");
INSERT INTO nbq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Eke, havethedugu lagipik, henomado vaga sambiniluk henendawi adenggen vaga, hai warit ");
INSERT INTO nbq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","henamwa wolok lagu lagipik, henaswi, henowa-henaot inim, homakbisiluk, ‘Nandomba bolagagi ako belalhidigya lagirik havethidigirikmu, hit ninim adenggen ogarusogom,’ yiluk, yugerelagwi ako dek? ");
INSERT INTO nbq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Andi wane-wane ap 99 umbutu dugwit nenendawi mondok sek adigat halok nenomaduk mbo baup dek ombasagwi halok, it mbogot vaga agarwik enendawi adenggen horogat ombarusogom ovara, it ap weyak ogasagwi ambi en weyak ogagya lagagi ako, asam helok, mbo bagya halok andi, it mbogot vaga agarwik ako enendawi adenggen ombok erogo umbutu dogosogom o, yiluk, yukheraliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Andi yugirigya lagagirik, ambi yugirigya dugwit, “Hwa ambi yoparip 10 vagogo werekma, ambiat bolagya halok, unda yevetbaluk, mupwak horogo lakbagek ogagya dugwit, mbup yegetek belalit-belalit ogagya lagarik, havethedaliga ako dek? ");
INSERT INTO nbq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Eke, havethedelok, aswei inim, at inim agarwik inim, homakbisiluk, ‘Nayoparip bolagagi ako havethidigirikmu, ninim adenggen ogarusogom,’ yugeraliga ako dek? ");
INSERT INTO nbq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ako andi ndatak ap weyak ogasiga ambiat en weyak ogagya lagagi ako asam helok, mbo bagya halok, it Ala yonggo lakbisa wandiga menda malaikat ako en enendawi adenggen umbutu dogosogom, yiluk, yukheraliga o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yugirigya lagagirik, wene ambi iri dugwit, “Ap ambi aburi mberen welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ambetaga menda ako en asin yugugu dugwit, ‘Nasin. Heyase an woknirup embeten ako hodo erogo wokniru,’ yugugu lagagimu, asin en angge eyase ako mogologo iperen wogoragagi.” ");
INSERT INTO nbq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Wogirigya lagagimu, ndugwis ambukum dukluk, abut elavo ako en asin angge wogogogi ako ovok erogo wonggalogo onggo hundutu lagagirik, ayoparip hedelok o adumu andoma winggigi. Wunggu lagagirik andoma dugwit, endawi dibagetek ugun ogarit lagya dugwit, ayoparip ako dek okhedagagi. ");
INSERT INTO nbq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ayoparip ako dek okhidigya lagagirik, werekma, avakwa andoma ovok erom uvup wisane agagirikmu, at ogo erom uvup wisane ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Erom uvup ogagya lagagimu, ap awerek ambi awi andoma menda eyavup ogagya dogogiluk, adema lagagi. Adema lagya lagagimu, at ap andi en anggomi o weram andoma eyaga dogopwak yiluk, lakbagagi. ");
INSERT INTO nbq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Lakbagagi lagya lagagirik, eyaga dugwit, ‘Nagaum arupwak yiluk, erom agamut wamnau yi, an ninggya dogosogon,’ imbitigi ovara, dek, it nin en ambiat ogo mondok wogigitek at welagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Andi en, ndugwis ambi vaga endawi wenggelagya lagagirik, ‘A! An nasin ayelomani en yavup ogasagwi onggo hedelagwi ako, eneyave wisane dugwit, erom higirogo bagek nelagwi ovara, an andi, erom uvup en hambup atma, ");
INSERT INTO nbq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","an yoma en nasin adema lagya dogomindik, “Nasin. At mbogot vaga menda inim, hat inim, weyak okbugugu lagi o. ");
INSERT INTO nbq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Weyak okbugugu lagima, Yi an nabur, yuknirup andi dek. Ata, hayeloman en yavup ogasagwi onggo hedelagwi ako ovagak okbanin,” yuguri laik,’ imbitigi. ");
INSERT INTO nbq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Imbitya lagagirik, o andoma hekbaluk, asin adema wagagi. Adema wagya lagagirik, ao ari wagyama, asin ako il yokhigya lagagirik, abwa en venggen lagya dugwit, dimit-domat okbaluk, ayup yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ayup yagya hegek, abut en asin yugugu dugwit, ‘Nasin. At mbogot vaga menda inim, hat inim, weyak okbugugu lagi. Weyak okbugugu lagima, “Yi an nabut,” yuknirup andi dek,’ yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yugogogi ovara, asin en ayelomani yugirigya dugwit, ‘Yum mondok segedok adigat wogogo yikbagwi, sanggan at inggis vaga yikbagwi, arepatu yikbagwi, hodo erogo ogares. ");
INSERT INTO nbq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Okbaluk, sapi eyak amok werek ambi wa lagu dogomundik, warogo isogo isagu dugwit, adenggen ogarusogom. ");
INSERT INTO nbq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","An nabut yi, hombagagi ovagak ovara, iluk aga. Eke, bolagagi ovara, havethidigi o,’ yiluk, adenggen ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Adenggen ogagu-sigik, owa ako yavumu welagagirik, amwa ari nunggu wagya dugwit, ndawi nggidis watwis aruk hunggigi. ");
INSERT INTO nbq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hunggu lagagirik, ayeloman ambi yanggup yugogogi wagya lagagimu, yugugu dugwit, ‘Yi nano ogasagwi?’ yiluk, ");
INSERT INTO nbq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","hemethigya lagagimu, ayeloman ako en, ‘Dek. Haot ako vage nunggu waga. Eke, eyave sek nunggu wagarikmu, hasin ako en sapi eyak amok werek ambi warogo isagu dugwit, adenggen ogasagwi.’ ");
INSERT INTO nbq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yugugu lagagimu, owa ako aninis agya lagagirik, amwa nunggup anggon akluk, werekma, asin wunggu lagagirik, ane sagain erogo, ‘Nungguma,’ yugogogi ovara, ");
INSERT INTO nbq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","owa ako en asin yugugu dugwit, ‘Haruk dogwen. An yi tahun ndi tahun heyavup ogasiga. Eke, ogagya dugwit, “Yerogo ogarup, nderogo ogarup,” yuknugu ako nanggon mondok yagaligadek ogarit adigat landiga ovara, kambin eyak ambiat an naswei ninim nenendawi adenggen dugwit, isarogo naguluk, mondok woknigitek agindik ovara, ");
INSERT INTO nbq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","habut yi andi, akwa ugun wurinivit nagu dugwit, hayoparip wogogogin ako dek ogarit nagu laga ako wagyama, sapi eyak amok werek menda warogo isagigin.’ ");
INSERT INTO nbq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yugugu lagagimu, asin en, ‘Nabut o. Hat mondok-mondok ninim agindikma, nangge-nangge ovok erogo andi, hat hangge aro. ");
INSERT INTO nbq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Eke, hat haot yi andi, hombagagi ovagak ovara, iluk aga o. Eke, bolagagi ovara, havethidigima, nenendawi adenggen dugwit, isogo yi sek isagyo,’ yugogogi,” yiluk, Yesus en it avakwa yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Andi en, hivis At Yesus en At ane welagwi menda ako yugirigya dugwit, “Ap inggi werek ambi ayeloman en at awi aruwam welagagi. Aruwam werekma, avakwa en, ‘Dek. Hayeloman ako en hangge mondok dek erogo baik landiga,’ ");
INSERT INTO nbq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","yiluk, asin ako yugugu lagagwama, ayeloman ako yanggup yugogogi wagya lagagimu, yugugu dugwit, ‘Hat ogarit landiga hunggis andi, nggarogo ogarit landigama, yuknigao? Hat yogak namwa o aruwam ambi inim dogop dekma, hat yoma dugwit, ogarit lagya lagen ako mbilinogo yukniru.’ ");
INSERT INTO nbq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yugugu lagagimu, ayeloman ako endawi wenggenggu dugwit, ‘Nasin en o aruwam dogop dek, yuknigarikmu, an nggarogo ogarik? Nanye dekma, wen bavunggu dogop andi, meyan. Eke, nambenggino yugeregek lagya dogop andi ogo, nanggadi werek. ");
INSERT INTO nbq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ata, weram wibaninggya dogomima, avakwa en an woknerapwak yiluk, yerogo ogarup sek ai?’ yiluk, endawi wenggenggigi. ");
INSERT INTO nbq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wenggenggu lagagirik, at ap ayeloman ako en it avakwa at asin anomarangge dirup mbalek welagagwa ako enadik-endadik mbauk erogo at adema warupwak yiluk, yanggup yugeragagi. Yanggup yugirigya lagagimu, ambi endak wagagi ako yugugu dugwit, ‘An nasin anomarangge dirup mbalek wogurup maren agarik?’ ");
INSERT INTO nbq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yugugu lagagimu, ap ako en, ‘Hasin anomarangge an wogurup andi, saitun amburup 15 nderem nudik mbalek agarik.’ Yugugu lagagimu, ayeloman ako en, vivis woknerapwak yiluk, ‘Nasin anomarangge dirup mbalek hat wogurup andi, wogogo aveloma 7 nderem nudik adigat hodo erogo mbauk erogo dirup waru.’ ");
INSERT INTO nbq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yugugu lagagirik, at ayeloman ako en at ambi yugugu dugwit, ‘Eke, hat ogo, nasin anomarangge dirup mbalek wogurup andi maren agarik?’ Yugugu lagagimu, ap ako en, ‘Gandum 100 harun yidik dirup mbalek agarik.’ Yugugu lagagimu, ayeloman en, ‘Nasin anomarangge dirup mbalek agarik yi, wogogo aveloma 80 harun adigat mbauk erogo dirup waru,’ yogogogi. Yugugu lagagirik, vivis woknerapwak yiluk at ayeloman ako en it nin asin anomarangge dirup mbalek welagagwa ako ovok erogo anderogo adigat yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ayeloman ogagagi asin ako hunggu lagagirik, ayeloman at ambukmu inggigi hegek ovara, endawi anggat vaga iya erogo wenggenggu lagagi halok, ayeloman adema ‘Wi!’ yugogogi.” Wene wakhegek ako yugirigya lagagirik, Yesus en at ane welagwi menda yugirigya dugwit, “It avakwa enendawi ugun wen vaga menda yogak agarwik ako it menda inim ogagu dugwit, enendawi anggat vaga iya erogo wenggelisagwi ovara, it Ala aburi enendawi awia okbogogi ako andi, it wen vaga menda inim ogagu dugwit, enendawi dek dugwit, horogat wenggenggu-sigis,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Henangge-henayoparip wen vaga menda avakwa enendawi hunik okhinivupwak yiluk, yonggarinigik nagu dogop. Anderogo ogagu hiniselok, dek agya halok, vivis o sekma andoma mondok-mondok dogovovok yiluk heyaga warogo wokhinivisogon, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ap ambi en horogat ogarup menda adik ogagatek des erogo ogagya halok, ombok ogarup menda ogo ndatak des erogo ogagya dogosogon. Eke, ap ambi en horogat ogarup menda des erogo ogagetek halok, ombok ogarup menda ogo ndatak des erogo ogasogon dek aro. ");
INSERT INTO nbq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Anderogoma, henangge-henayoparip wen vaga menda ako des erogo vagago agipik dek halok, eve sek menda vagago dogovovok yiluk, Ala en bigigayogonbuk. ");
INSERT INTO nbq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eke, hiren ap ambi angge des erogo vagogo welagetek halok, hit henadik henangge vagago dogovovok yiluk, Ala en wokherayogon embetep? Dek aro. ");
INSERT INTO nbq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ap ambi en asini mberen enayeloman akluk, enake ogagya dogop meyan. Iperen enake ogarit lagya halok, ambi anggon imbitya dugwit, ambi endawi hunik imbitya, ata, ambi en ogarup yugugu ako seve erogo ogagya dugwit, ambi en ogarup yugugu ako anggon adigat imbitya, ogasogon. Hiren At Ala inim, henangge-henayoparip wen vaga menda ako inim, iperen henendawi dambulik vaga musek laup andi, meyan,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yugirigya lagagimu, it ap Parisi en Yesus wene yugeragagi ako hunggu lagagwarik, yoparip enendawi hunikma, Yesus aganda yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aganda yagu lagagwama, At Yesus en it yugirigya dugwit, “Hiren avakwa sek henombarupwak yiluk, henanggangga hedelagwi ovara, Ala en andi, henendawi ombasagwi ako elup agarik. Yi menda ndi menda iya ombasagwi andi, At Ala anggon ombasiga,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yugirigya lagagirik, ambi yugirigya dugwit, “Ap Yohanes wagetek hegek, Musa wene yugup dirup mbalek ako inim, it ap Ala en yugirigya hegek yugurugu lagagwa navi-navi enane ako inim, ogarit nagu lagagwa. Eke, ap Yohanes wagagi hudi andi, avakwa Ala avema dogopwak yiluk sup hutbagagi Sek Wene ako yugeregek nagusim, it avakwa ovok erogo dil watu dugwit, Ala avema bisaligama nunggu wendagwi. ");
INSERT INTO nbq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Anderogo ogasagwi ovara, wen inim, mbogot inim, dek arup andi, ndak ovara, Musa wene yugup dirup mbalek ako andi, nin maduk mbalek ambi dek asogon andi mondok dek aro. ");
INSERT INTO nbq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ap ambi ogwa hekbaluk, hwa adik ambi wigya halok andi, at en hwa endak ako alyak waliga. Eke, ap ambi hwa bonggalek ako wigya halok, at ogo, alyak waliga,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yugirigya lagagirik, Yesus en wene ambi yugirigya dugwit, “Ap ambi inggi werek menda, ayum segedok onggo ombok adigat yikhidigya lagagi. At ninggi-nanggi segedok amburup werek menda adigat ningga dugwit, adenggen wisane welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eke, ap adik ambi ambenggino iri lagagi menda inis Lasarus eyave vaga amu hunik atma, ap inggi werek awi sup mbanggutmu andenam horaik adigat welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","At ako en, ‘Ap inggi werek ako ambi ninggya hegek, ilivulu wambigya ako, naik dek ai,’ imbitya lagagi. Eke, yangge wagu lagagwarik, at amu ako enabya melan-melan nunggu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Andi en, ndugwis ambi vaga ap ambenggino yagaliga menda ako hombagagi. Hambigya lagagimu, it malaikat ako en eyave wolok Averaham adema ba lagagwa. Ba lagagwa hegek, hivis ap inggi werek ako ogo hombagagi. Hambigya lagagimu, eyave wen sabalagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Saba lagu lagagwama, hali hunikmu ari lakluk, andoma yagan watya dugwit, elese ilik lagya lagagirik, o adumu andoma ap Lasarus Averaham iperen werek enogogi. ");
INSERT INTO nbq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Inugu lagagirik, At ane ombok vaga yugugu dugwit, ‘Nasin Averaham wai! An hali abya edup adik wisane yagan wasigama, nabwa nimbitya dugwit, ap Lasarus en inggis atok vaga is erabaluk, nabya eraba warupwak yiluk, lakbaoma!’ ");
INSERT INTO nbq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yugogogi ovara, Averaham en at yugugu dugwit, ‘Nabut. Hat hiluk dugwit, segedok adigat welagagin. Eke, Lasarus yi andi, anggin-mbanggin welagagi ako hendawi wenggelu. Yogak Lasarus yoma dugwit, endawi seyo yagas ovara, hat andi, yagan wasiga. ");
INSERT INTO nbq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eke, ambi, it ap yoma en hat heya wagwi, andoma en nit ninisa wagwi, ogarup ombasagwi ako meyan haupwak yiluk, ilim andoma nggedek ombok bagagi.’ ");
INSERT INTO nbq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Yugugu lagagimu, ap inggi werek ako en, ‘Eke, andi halok nasin. An nowa-naot eneyave 5 nasin amwa agarwikma, yagan wasagwima yoma wagu sao en, an nasini enamwa hurimbis yugera laupwak yiluk, ap Lasarus andi, lakbanok yiluk, yukhisiga.’ ");
INSERT INTO nbq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Yugugu lagagimu, Averaham en at yugugu dugwit, ‘Musa yagagi wene inim, it navi-navi enane inim, yugerelagwi ako hunggu dogopwak.’ ");
INSERT INTO nbq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yugugu lagagimu, ap ako en, ‘Meyan, nasin Averaham. Ap ambi hambuluk lendagwima en yugere lagya halok andi, it weyak ogasagwi ako enasam helok, mbo bagu dogosogom!’ ");
INSERT INTO nbq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yugugu lagagimu, Averaham en, ‘It howa-hasin ako en Musa yagagi wene inim, it navi-navi enane inim, hulisagudek halok, ap ambi hambuluk lendagwima en iluk akluk, yugera lagya halok ogo, it weyak ogasagwi ako enasam helok, mbo bagu dogosogombuk,’ yugogogi,” yiluk, Yesus en yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yugirigya lagagirik, Yesus en At ane welagwi menda ako yugirigya dugwit, “Hit weyak ogarovovok yiluk, henendawima mabigiga warisogon ovara, at henendawima mabigiga wandiga ako andi, anggin ovaga arugwi! ");
INSERT INTO nbq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ap ambi en avyak mariduk yi, weyak ogarupwak yiluk, enendawima mali wagao vaga avyak ako weyak ogagu-sao en, ap andi helep ombok gandum yanggalisagwi menda ako vaga avupmu, heda yidilogo is namut agurukmu wombabiselapmu en sek aro. ");
INSERT INTO nbq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Anderogoma, henendawi suwam watu dogwes. Hit henaswe ambi en weyak ogagya halok, anggadi warup. Anggadi wakbaluk, weyak ogaga ako asam helok, mbo bagya dogomima, at omaduk andi, dek erogo bagu dogop o. ");
INSERT INTO nbq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eke, ap ambi en ndugwis ambi vaga weyak 7 hudi okbugugu dogomindik, asam helok, ‘Ai, an weyak okbigigis o,’ yiluk, ogaga ndatak 7 hudi yukhera wagya halok, hirenen 7 hudi at omaduk dek erogo bagu dogop,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yugirigya lagagimu, it lakbigik menda ako en, “Nenasin o. Nenendawi hova vanggabaluk, avyarat hombasagwi ako ambi hoda arupwak yiluk, okbininin.” ");
INSERT INTO nbq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yugugu lagagwama, At Nenasin Yesus en it yugirigya dugwit, “Hit henendawi novaga vanggabaluk, avyarat nombasagwi ako maduk yo vudok enggen ovagak henendawima duklip en, yo wane ombok yi, ‘Hadem hen hedelok is endawima yaklarit lagya heyayogon o,’ yugugu hiniselok, yaklarit lagya helap,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yugirigya lagagirik, ambi yugirigya dugwit, “Hit henayeloman ambi en yavup ogagya a, ata henandomba unde waginipu a, ogarit lagya dogomindik, wasim en henamwa nunggwigya halok, hiren, ‘Hagarom hodo na oma,’ yiluk, yugurup andi dek. ");
INSERT INTO nbq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ata, hit en henayeloman ako yugugu dugwit, ‘Nit nenagarom isagogo biniluk, hayum yikhidigya dogomindik, nit nunggu ninigik, hat nit nenake yi welagek ndi welagek ogagya dogop. Eke, nit ovok nunggu niniselok andi, hat erom na omano,’ yiluk, anderogo yugisagwi. ");
INSERT INTO nbq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Asin en ayeloman ‘Yerogo ogarup, nderogo ogarup,’ wene yugigas ako adigat ogagya halok, at eyavup atma, asin en, ‘Wa!’ yugisigadek. ");
INSERT INTO nbq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Andi halok, hit ndatak, wene, ‘Yerogo ogarup, nderogo ogarup,’ yukheraliga ako ovok okbagu dogomindik, ‘Dek. Nit un hayeloman adigat agurik. Havema dugwit, hat yuknirigya halok adigat ogagyoma, wa yuknerabuk,’ yugugu dogop sek,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hivis ndugwis ambi vaga At Yesus o Yerusalem lagya dugwit, o Samaria wombabagek, o Nggaliliya ilik bagek, sup ilim vaga lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Lagya dugwit, o asoragoma nunggwigya hegek, ap eneyave 10 amu hunik ako menda en Yesus nunggu wagya inil hugu lagagwarik, ap eneyave sek menda enovaga arugwi en yiluk, horok-horok ari warup moga, yiluk, adumu lenak en ");
INSERT INTO nbq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","enane ombok vaga At yugugu dugwit, “Nenasin Yesus wai! Nenabwa ombaru o.” ");
INSERT INTO nbq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yugugu lagagwama, at Yesus il biginugu lagagirik, “Musa wene yugup dirup mbalek ako ndatak, it ap imam-imam en inil hinisaupwak yiluk, heneyave inugera lales.” Yugirigya lagagimu, it ako, lagu-sigik, enamu hunik ako dek agagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Enamu hunik dek agya lagagimu, at ambi en imbita dugwit, “An sek agi,” yiluk, imbita lagagirik, suguliluk, eyami vaga wagya dugwit, ane ombok vaga Ala inis siyabagek wagagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ala inis siyabagek Yesus avema seve yi wagya lagagirik, endawi adenggen en, Yesus “Wa!” yugogogi. Eke, ap andi, awi o Samaria menda aro. ");
INSERT INTO nbq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ap ako Yesus, “Wa!” yugugu lagagimu, At Yesus en, “Ap eneyave 10 sek aga ako dek? Eke nin eneyave 9 ako nggoma lagao? ");
INSERT INTO nbq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","It nin Yakuri menda ako dek inigik ap weram Samaria menda yi adigat Ala inis siyabagiluk, eyami vaga suguliluk waga yi?” ");
INSERT INTO nbq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yiluk, Yesus en ap ako yugugu dugwit, “Hendawi novaga vanggabaluk, avyarat nembeten vaga sek agindikmu, mendek yiluk elak o,” yiluk, lakbagagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Andi en, hivis it Parisi menda en Yesus yugugu dugwit, “At Ala en nit mera avema binina warimi?” yiluk, Yesus aigwakma wugu lagagwama, Yesus en it yugirigya dugwit, “At Ala en avakwa at avema bigiga warup ako andi, avakwa yedok haupwak yiluk, ogagetekma warugwi. ");
INSERT INTO nbq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","It avakwa en ogo, ‘Yoma wandiga yi hanes.’ ‘Andoma wandiga andi hanes,’ yukheregetekma warugwi. Ala avema bisaup andi, vage hit henanggelekma agarik umbutu dogones,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Andi yugirigya lagagirik, At ane welagwi menda ako yugirigya dugwit, “An Ap At Endaklagagis yi, ‘Ndugwis ambiat eyave haupwak ai,’ nombarumwi ovara, hinil neyaup dek andi, hudi vanggo yi wasogon. ");
INSERT INTO nbq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","It avakwa en, ‘Eyave yoma wandigama, bikha manes.’ ‘Andoma wandigama, bikha lales,’ yukhurugu-selok, enamusek labuk. ");
INSERT INTO nbq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Andi, o bigavok mbogot vaga en yovalevet higya halok, o atok-atokma ovok erogo awia agya dugwit ovok sigam asiga hak, An Ap At Endaklagagis warup ako hudi anderogo ogarugwis. ");
INSERT INTO nbq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Anderogo ogarugwis ovara, endak, avakwa en mondok novaga edup-mbedup erogo banunggwi, avakwa yogak agarwik ako en An enanggon yiluk, mbo banunggwi, ogarusogom aro. ");
INSERT INTO nbq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ap Nu werek hegek, avakwa ugun ogarit lagu lagagwa ako ndatak, An Ap At Endaklagagis warup hudi it avakwa anderogo ugun at ogarit lagu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","It avakwa en ugun at erom nunggwi, is nunggwi, ap en hwa hidugwi, hwa en ap hidugwi, ogarit lagu-sigik, ap Nu mburis aveta elola nunggwigya lagagimu, is yanggadit inggya dugwit, it eneyave ovok erogo is ndokalinipigi. ");
INSERT INTO nbq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","At Lot werek hegek, ogagagi ako ndatak avakwa en erom nunggwi, is nunggwi, enangge-enangge hunggun okhidugwi, yavup ogagwi, o vanggwis, ugun ogarit lagu-sigik, ");
INSERT INTO nbq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ap Lot o Sodom en wunggu lagagimu, Ala mbogot vaga en helep enggen hali inim womba ba wagya dugwit, it eneyave ovok dek erogo bogogi. ");
INSERT INTO nbq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","It ugun ogarit lagusim, dek erogo bogogi ako ndatak, An Ap At Endaklagagis ako avakwa anderogo ugun ogarit lagusim, andi hudi sigam ari warugwis. ");
INSERT INTO nbq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Henangge handimen werekma, heneyave mbedakma werekma, An wagya neyalok, henangge handimen agarik ako heda dagabuk, eke, hit nin yavumu agipik ako heneyami vaga suguliluk, henamwa labuk. ");
INSERT INTO nbq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","At Lot ogwa ogagagi ako henendawi wenggeles! ");
INSERT INTO nbq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hit heneyave hinidi okhedugu dugwit, an nane mbo bamwi halok, heneyave yelemele yusogom. Eke, an ninis ombok arupwak yiluk, heneyave idi dek okbetamwi halok, hinidi erek dogosogom. ");
INSERT INTO nbq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ndugwis andi vaga hup ap mberen handimen nogo yugusim ambi wigya, ambi hekbagya, ");
INSERT INTO nbq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","akwa mberen erom weragusim ambi wigya, ambi hekbagya, ");
INSERT INTO nbq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(eke, ap mberen yavumu werekma, ambi wigya, ambi hekbagya,) ogagya hagup, yiluk, yukheraliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yugirigya lagagimu, At ane welagwi menda en, “Nenasin. Andi o nggoma en ogarup yiluk yegen?” Yugugu lagagwama, At Yesus en, “Wam vidis agarikmu werekma akoma swa ikakuk linggilisagwi,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Andi yugirigya lagagirik, avakwa anggon-mbanggon okbigitek samban adigat ogagu dogopwak yiluk, Yesus wene yi, wakhegek At ane welagwi menda ako yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“O kota ambima ap wene owak dilisiga menda ambi welagagi. Ap andi en Ala alon imbita, eke, avakwa enane alon imbita, ogagetek at welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Eke, hwa sogwa ambi o kota andoma welagagi. Hwa andi en hunik-kunik ap wene owak dilisiga ako yuguri lagek adigat ogagya dugwit, ‘At ninim ogorek ako en ando mbalogo baninggyama, an ugun ogarit lagya dogogiluk, an nawene mbaniru,’ yugugu lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yugugu lagagi ako ap owak dilisiga en endak anggon imbitigi ovara, yuguri lagek adigat ogagya lagagimu, hivis endawi wenggenggu dugwit, ‘An Ala nalon ombasigadek, eke, avakwa enane nalon ombasigadek ovara, ");
INSERT INTO nbq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","hwa sogwa yi, hunik adigat yukniri wagyama, aburuk okbaninggya hao en, nggatuk erogo awene mbalisogon,’ imbitigi,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yugirigya lagagirik, At Nenasin Yesus ako en “At ap wene owak sek erogo dilisiga dek menda yagagi ako holes. ");
INSERT INTO nbq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Anderogo ndatak Ala en at aburi miginipigi ako enane hup-dingga at yugugu-selok, enowak dilogo enawene nggatuk erogo mbalisogon dek embetep? Dukluk heveretmbo, ndogovitmbo, adigat wolok lagya dugwit, enawene mbalup embetep? ");
INSERT INTO nbq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Dek. Mbikit enowak dilogo enawene nggatuk erogo mbalisogon, yiluk, yukheraliga. Anderogo oginivup ovara, An Ap At Endaklagagis wagya neyalok, it avakwa wen vaga yoma enendawi novaga vanggabaluk, avyarat numbutu-sami a, dek a?” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yugirigya lagagirik, it avakwa nin enendawi en, “Avakwa nin andi, mondok meyan, eke, nit andi, Ala wene dibaluk, sek adigat ogasagwi o,” umbutu lagagwarikmu, Yesus en wene yi wakhegek yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ap mberen samban ogaruguluk, Ala awi valekma nonggagagwa. Ambi andi, Parisi menda, eke, ambi andi, ap weyak pemerintah enake yoparip wonggalisiga menda. ");
INSERT INTO nbq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Iperen Ala awi valekma nunggugu lagagwarik, ap Parisi ako en mendek yiluk, samban okhidigya dugwit, ‘Ai, Nasin Ala! It avakwa enonggop welagwi menda inim, weyak ogasagwi menda inim, wanggi welagwi menda inim, eke, ap pemerintah enake yoparip wonggalisiga menda yi ako inim, an anderogo hak dekma, wa yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","An samban ambi vaga ndugwis mberen Ala ake yiluk, erom hunis agirik o. Eke, nangge agarik halok, nin higirogo Hat Ala hake baliga o,’ yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yugogogi ovara, ap pemerintah enake yoparip wonggalisiga ako en andi, adumu erogo mendek iri lagagirik, alon en il mbogot vaga bikhegetek eyave wakhidigya dugwit, ‘Ai, Nasin Ala! An weyak ogasiga mendama, nabwa ombaru o,’ yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iperen samban anderogo ogagagwa ovara, at samban endak ogagagi ako dek. Ata, hivis ogagagi ako adigat Ala en, ‘Ap andi, endawi sek higi o,’ imbita hegek, amwa lagagi. Andi, ap ambi endawi siyabatigya halok, sovabagya, eke, endawi sovabatigya halok andi, siyabagya, ogasogon o, yiluk, yukheraliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Andi en, hivis avakwa en avyak mariduk Yesus inggis vakbisiluk enadenggen enovaga bisapwak yiluk, At adema woginiviluk wagagwa. Woginiviluk wagwi ako, At ane welagwi menda en inigu lagagwarik, mbereragagwa. ");
INSERT INTO nbq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mberirugu lagagwama, At Yesus en avyak ako warupwak yiluk, yanggup yugirigya lagagirik, wagu-sigik, At ane welagwi menda ako yugirigya dugwit, “Hekbisines! Ala avema dogop andi, it avyak mariduk yi hakma, An nadema wagusim, moga yugerabuk. ");
INSERT INTO nbq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Dibas! It avyak mariduk Ala avema dogopwak yiluk nunggwisagwi anderogo hak, hit anderogo nunggegetek hiniselok andi, nunggusogon dek o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","It ap Yakuri enasin ambi en Yesus yugugu dugwit, “Ngguru wai! Hat sek adigat agindik yi, an mondok-mondok niluk dogogiluk, nggarogo ogarik?” ");
INSERT INTO nbq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yugugu lagagimu, At Yesus ako en, “Nano yiluk An sek adigat agirik yiluk, yuknigin? Ap ambi sek adigat agarik andi dek, Ala adigat sek agarik,” ");
INSERT INTO nbq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","yugugu lagagirik, “Wene yerogo ogarup, nderogo ogarup, Ala wene yugup ako andi, hat ovok hilup. ‘Ap ogwa werek hegek, hwa agun werek hegek, ogarup moga. Ap warup moga. Ap enangge-enangge enonggop waup moga. Henane huluk ap enovaga bisaup andi moga. Hinisa-henasin enagayuk wutu dugwit, enane des erogo hunggu dogones,’ yiluk, wene yagagi yugup ako hat ovok hilup aro.” ");
INSERT INTO nbq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yugugu lagagimu, ap ako en, “Wene andi an madukma en des erogo ogagya lagagis,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yugugu ako At Yesus hunggu lagagirik, “Wene andi ovok erogo ogasiga ovara, ambi at andi, ogagetek higi ako yukhisogon. Hat hangge ovok erogo onggo hunogo it ap enangge dek menda ako sumburerelak. Sumburera lagya heyalok, hat hivis hangge eyave sek menda o mbogot vaga en ombok at onggo hedayogon. Andi ogagya dogomindik, ninim nagu dogoguluk, omano,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yesus en ap ako yugogogi aruk hunggu lagagirik, at angge-angge wisane ako vaga endawi hunik atma, wogeraup anggon imbitya dugwit, endawi mondok wakhedagagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Endawi wakhidigya hegek, At Yesus en bikhigya lagagirik, at yugugu dugwit, “It ap ininggi werek menda ako, At Ala avema dogop andi nggarogo nunggup erek higi o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","“Wam ombok unta dirup yarum elo maduk andi ndak nunggup ovara, ap ininggis werek halok ako andi, Ala avema dogop, nggarogo nunggup erek higi o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yugeragagi it hunggugwa ako en Yesus yugugu dugwit, “Andi halok, ap sa maren enagap wendarup embeten?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yugugu lagagwama, At Yesus en, “It avakwa en ogarup meyan helagwi ako, Ala en ogarup sek at haliga,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yugirigya lagagimu, at Peterus en At yugugu dugwit, “Nit nenangge-nenangge ovok erogo hekbisiluk, hinim nagu dogoguluk, wagyo akora?” ");
INSERT INTO nbq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yugugu lagagimu, At Yesus en, “Ap ambi sa en Ala avema dugwit Ala eyavup ogarit lagya dogogiluk, awi valek inim, ogwa inim, owa-aot inim, asin-isa inim, aburi inim, ovok erogo hekbagya halok andi, ");
INSERT INTO nbq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","o yogak at, aveloma wisane wogosogon. Eke, hivis atok vaga at mondok-mondok iluk dogosogon o, yiluk, avyarat yukhirigi o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yugirigya lagagirik, andi en, ap 12 ako woginiviluk enadikmu ari lagu lagagwarik, it yugirigya dugwit, “Avyak yoma wai! Nit o Yerusalem dagasagwi. Dagasagwima, it ap Ala yugirigya hegek yugurugu lagagwa navi-navi en An Ap At Endaklagagis okbanup dirup mbanggugwa ako ovok erogo andoma en atma des iri hasogom. ");
INSERT INTO nbq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","An Ap At Endaklagagis ako narupwak yiluk, avakwa weram Yakuri dek menda wogerasogom. Wogurugu dogomwima, An nanggadi watbanunggwi, wiyiknom-weyaknom erogo banunggwi, enowaris novaga suvurogo banunggwi, okbaniluk, ");
INSERT INTO nbq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","nabirok natu dogomundik, neyave mondok narusogom. Natu dogomwima, ndugwis mberen dukluk ndugwis ambi vaga niluk akluk mendek yisogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wene adem hwilago ovagak yugeragagima, wene ako ovok erogo it yedok hegetek enendawi obak welagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","At Yesus o Yeriko horok ari wagya hegek, ap ambi il mbukma, sup ombok vaga horaik ambenggino iri lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","At ap ako it avakwa wisane enane yagan wagwi aruk hunggu lagagirik, “Yi nano yagan wandagwi?” ");
INSERT INTO nbq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yugirigya lagagimu, it avakwa en, “Dek! Yesus awi Nasaret menda ako, sup ari vaga wagya halok, yagan wendagwi.” ");
INSERT INTO nbq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yugugu lagagwama, ap ako ane ombok vaga iri dugwit, “Yesus Daut ombao wai. An nabwa nombaru!” ");
INSERT INTO nbq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yugugu lagagimu, it enendak wagwi ako en ap ako ane mbup yumwak yiluk, mberogogwa ovara, hegek, aren iri dugwit, “Daut ombao wai. Nabwa nombaru o,” yiluk, ane ombok vaga ambi inim yugigik adigat ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yugigik adigat iri lagagimu, At Yesus mbup iri lagagirik, ap ako At adema wolok warupwak yiluk, yugirigya lagagimu, wolok At adema ba wagu lagagwama, Yesus en ap ako yugugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“An hat nggarogo okbanupwak yiluk, embeten?” Yugugu lagagimu, ap ako en, “Nasin. Nil sek okbanup yiluk, yukhisiga.” ");
INSERT INTO nbq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yugugu lagagimu, Yesus en, “Hat hendawi novaga vanggabaluk avyarat nembeten ako vaga, hil sek akluk, elak.” ");
INSERT INTO nbq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ako ao yugugu hegek, at il sek agagi. Il sek agya lagagimu, Yesus inim lagu dugwit, Ala inis siyabagek lagagi. Eke, Yesus ogagagi ako it avakwa ovok erogo hugu lagagwarik, Ala siyabagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","At Yesus o Yeriko nunggwigya lagagirik, mbikit wagyama, ");
INSERT INTO nbq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ap ambi inis Sakius pemerintah enake yoparip wonggalisagwi menda enasin mondok inggis werek dombok welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","At ako en, “Yesus andi, nggarogo ovagak?” yiluk, bikhagiluk, ogagagi menda eyave dul, eke, avakwa wisane homagoma, bikhaup meyan agagi. ");
INSERT INTO nbq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Meyan agya lagagimu, “Yesus sup yi vaga wasogon higi,” yiluk, il hagiluk, at endak vupuk lagya lagagirik, yo vaga inggigi. ");
INSERT INTO nbq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yo vaga inggigirik werekma, At Yesus ndan iri lagagirik, il ilik lagya dugwit, “Sakius wai. Yogak an hat hamwa laupma, hodo wambuma.” ");
INSERT INTO nbq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yugugu lagagimu, Sakius ako mbikit yo vaga en wambu wagya lagagirik, heyaga wakbaluk, endawi adenggen embetek amwa lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","It avakwa en Yesus iperen lagwi inugu lagagwarik, enanggin-enanggon yugu dugwit, “Ap weyak ogasiga menda inim at amwa lendagwi yi inisenes!” ");
INSERT INTO nbq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yugu lagagwama, at Sakius en it wisane inivaga Nenasin Yesus yugugu dugwit, “Ai Nasin. An nangge-nangge higirogo ap ininggidek halok, wogerayogon. Eke, ap we-wes okbugu lagi ako, enangge ambi dek okbugu lagi halok, aveloma 4 hudi wogirigya, ap ambi adik angge dek okbugu lagi halok, aveloma 4 hudi wogirigya, ogarisogon o.” ");
INSERT INTO nbq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yugugu lagagimu, At Yesus en, “Hat ogo hat hombao Averaham Ala ovaga vanggabaluk avyarat imbitigi ako hak, hat yogak an novaga vanggabaluk avyarat nembeten andi vaga, hat haburi hinim yogak yi vaga Ala en henagap wendakhinipas. ");
INSERT INTO nbq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","An Ap At Endaklagagis yi, it avakwa yelemele yagagwa ako havedogo enagap wendarigiluk, wambu wagagis o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","It avakwa ako enaruk hunggu-sigik, Yesus en wene wakhegek ambi yugeragagi. Andi, at Yesus o Yerusalem vage horok ari wagya lagagimu, it avakwa en “Ala avema bisaligama mbikit sigam arisogon ai,” umbutwi yedok inigu lagagirik, wene wakhegek yi yugeragagi. Yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Ap inis werek ambi en, ‘O adumu andoma lagya neyalok, ap ombok o yoma vagago dogogiluk mondok okbaninggya dogomwima, neyami vaga wasogon,’ yiluk, ");
INSERT INTO nbq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","lagiluk, ogagya dugwit, at ayelomani eneyave 10 yanggup yugirigya lagagirik, wagu lagagwama, ayoparip mbusi emas menda 10 higirogo, ap ambi yoparip mbusi emas ambi wogorigya, ap ambi yoparip mbusi emas ambi wogirigya, wogirigya dugwit, ‘An wagatek neyagek, nayoparip yi vaga yi menda ndi menda hunit nagu dugwit, ambi lobalhidugu dogones.’ ");
INSERT INTO nbq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yugirigya lagagirik, lagagi. Lagya hegek, it nin at avema menda en at enanggon dombok umbutu dugwit, ‘At ap yi, nenasin inis ombok akluk, o yoma vagago dogop nenanggon,’ yiluk, yugera laupwak yiluk, enarwi lakbogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Lakbogogwa yugera lagagwa ovara, hegek, ap ako inis ombok it enamwa andoma vagago dogopwak yiluk mondok okbagu lagagwama, amwa eyami vaga wagya lagagirik, ‘Nayoparip ako vaga it maren lobalhedagao hami?’ yiluk, ayelomani ayoparip wogoragagi ako yanggup yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yanggup yugurigya lagagimu, ayeloman endak wagagi ako en, ‘Ai nasin. Hayoparip woknigigin ako vaga ambi inim 10 lobanggis.’ ");
INSERT INTO nbq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yugugu lagagimu, asin en, ‘Ai nabut wa! Nayeloman hat sek, mondok sek dombok ogagen. Maduk ogarup ovara, hegek, des erogo ogarit lagya lagenma, yogak o kota 10 hudi vagago dogonyok yiluk, mondok okbagaliga.’ ");
INSERT INTO nbq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yugugu lagagimu, ayeloman ambi ambetaga wagya lagagirik, ‘Ai nasin. Hayoparip woknogogin ako vaga ambi inim 5 lobanggis.’ ");
INSERT INTO nbq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yugugu lagagimu, asin en, ‘Andi halok, hat o kota 5 hudi vagago dogop.’ ");
INSERT INTO nbq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Yugugu lagagimu, ambi ambetaga wagya lagagirik, ‘Ai nasin. Hat hendawi hanggidik an nilup atma, eke, hendawi hanggidik dugwit, hat en bagetek ovara, wigya, eke, awi lisinggitek ovara, enggen yugup mbalhidigya, ogasigama, nalon en hayoparip nasula yidik vagago welagi ako yi o,’ yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yugugu lagagimu, asin en ayeloman ako yugugu dugwit, ‘An ogarup yukhogogis ovara, an nane sagalisiga hat nayeloman yi, hane yegen ako vaga hanggadi watbagasogon. Nendawi nanggidik dugwit, bagetek ovara, wigya, eke, awi lisinggitek ovara, enggen yugup mbalhidigya, ogasiga hat helup agindik ovara, ");
INSERT INTO nbq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","an wagya neyalok, nayoparip inim, vagago dogop onggo inim, an wa wasogon ai, yiluk, it avakwa enayoparip ombok arupwak yiluk, ogasagwi ako, wogoregetek nggarogo yiluk welagagin?’ ");
INSERT INTO nbq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yugugu lagagirik, avakwa at inim agarwik ako yugirigya dugwit, ‘Nayoparip vagago agarik ako ndiyalogo ap yoparip 10 lobalhedagagi ako wogores.’ ");
INSERT INTO nbq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yugirigya lagagimu, iren, ‘Ai nasin. At andi, ayoparip ovok 10 agarik!’ ");
INSERT INTO nbq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yugugu lagagwama, aren, ‘Hit menda ambi agarik halok andi, ambi inim ovaga ndulogo wokhirigya hasogom. Eke, hit menda ambi dek halok andi, ambukumat agarik ako ndiyalogo hedigya hasogom o. ");
INSERT INTO nbq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Eke, it ninim ogorek dugwit, “At nenasin inis ombok akluk, o yoma vagago dogop, nenanggon,” yagao ako andi, woginiviluk wagu dogomundik, nil neyagek, enares,’ yugeragagi,” yiluk, Yesus en avakwa ako yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus en wene andi yugirigya lagagirik, at endak o Yerusalem lagyama, ane welagwi menda inim lagu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","o Betepage inim, Betania inim, ndom inis Saitun avema andoma horok ari lagagwarik, At ane welagwi menda mberen lakbugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“O valekma akilisim ari lamwira, wam keledai eyak, ap ao ovaga hora yegetek menda ambi hugu dogomundik, yunggwi yidugup akom veralogo yoma wolok omano. ");
INSERT INTO nbq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Eke it avakwa andoma en, ‘Hit nggarogo yiluk keledai andi veralisagwi?’ yukhurugu-selok, hiren yugurugu dugwit, ‘Nit Nenasin keledai dekma, “Walales,” yuknirigya lagama, wa wagyo,’ yugerano,” yiluk, lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","It lakbogogi ako, lagu lagagwarik, yugeragagi ako ndatak hagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hugu lagagwarik, keledai eyak ako veranggusim, it ap enanggom keledai werek ako en, “Keledai andi, nggarogo yiluk, veralisagwi?” ");
INSERT INTO nbq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yugurugu lagagwama, iren, “Nit Nenasin keledai dekma, ‘Walales,’ yuknirigya lagama, wa wagyo,” yugurugu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","wolok Yesus adema ba lagagwa. Ba lagu lagagwarik, enayum weram menda nggolalogo wam keledai ambot vaga ndabagu lagagwarik, Yesus ako wam keledai ambot vaga hora okbagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hora okbagu lagagwama, Yesus lagya hegek, it avakwa enayum sogwes yum mbigalogo sup ombok vaga ndabalin lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ndabalin lagu lagagwama, o Yerusalem vanggo yi lagu-sigik, sup ndom Saitun wambu wandagwima akoma avakwa At ane welagwi menda ovok en nggarogo ogarubuk menda wisane ogarit lagya ako inil hugu lagagwarikmu, enadenggen en amikmit yagan lagu dugwit, Ala inis siyabaik lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ala inis siyabaik lagu dugwit, “Nenasin Ala en Nenowa inis ombok lakba waga yi, inis siyabaliga o. At mbogot vaga winimen agarik ako en, nenendawi dambubininggas atma, At Ala inis mondok siyabelagwi o,” yiluk, yagan lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yagan lagwi ako, it Parisi menda nin en avakwa wisane wonggalari wagagwa ako enanggelekma en Yesus yugugu dugwit, “Ngguru wai. Hane welagwi menda yi, mbereran.” ");
INSERT INTO nbq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yugugu lagagwama, Yesus en, “Avyak! It avakwa yi, enane yegetek duklipmu en, helep yi, Ala inis siyabagu duklip, yiluk, yukheraliga,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yugirigya lagagirik, o kota Yerusalem vanggo yi lagya lagagirik, il higya dugwit, yup yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yup yagya dugwit, “Hit Yerusalem yi, yogak yi vaga henendawi ugun wadok dek adenggen dogop yiluk, nggarogo okbigigaup hinilup duklipmu en, ai, okbigigelap ovara, yogak hinil hinisao en, hwilago agarik. ");
INSERT INTO nbq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Hirenen Ala yi hudi at ninisa waga o, yiluk, yedok hegetekma, henamwa Yerusalem en wunggu hinisao en, it hinim ndup ogorek en eve helep leget walinogo bugugwis, eloma-yoma en, yumu-yagamu en, ndup okhinivuguluk, horok ari wagwi, ogagu dugwit, henawi helep vaga valek yi, helep ambi ovaga duduk erek dogosogon buk. Masalogo bagu dugwit, Ala yi hudi at ninisa waga o, yiluk, yedok hegetekma, habut-hogwa hinim ovok erogo mondok dek erogo bigigaup vage vanggo yi wasogon o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Andi yugerelok, Ala awi valek mbumbumu nunggwigya lagagirik, it avakwa yi menda ndi menda onggo hunggik yagalagwi menda akoma haryogo wibugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Ala en ‘An nawi valek yi, “Samban ogasagwima yi at dogosogon” ’, yiluk, yagagi dirup mbanggigi ovara, hit andi, o yi ap enonggop wokbaluk, hwilaklari lendagwima ovagak ogagep,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesus hup-dingga Ala awi valekma wene mamulirigya lagagi. Mamulirigya lagagi ovara, it imam-imam enasini inim, it Musa wene mamulerelagwi menda inim, it avakwa enasini inim, At Yesus warup yiluk, ogagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","avakwa en at wene yugirigya ako enendawi hunik dombok ogagu dugwit, inil at adigat vurek atma, nggarogo warubuk erek halok, mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Hivis ndugwis ambi vaga At Yesus Ala awi valekma mbumbumu dugwit, wene mamulirigya, Sek Wene yugirigya, ogagyama, ap imam-imam enasini inim, it Musa wene mbalek mamulerelagwi menda inim, ap ombok-ombok inim, At adema wagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Adema wagu lagagwarik, At yugugu dugwit, “Hat yi ogagek ndi ogagek ogasiga ako, sa inis vaga ogasiga? Sa en hat yukhogogi vaga ogasiga? Yukneran.” ");
INSERT INTO nbq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yugugu lagagwama, At Yesus en iri dugwit, “An ogo, wene ambi hemekhinisayogon. ");
INSERT INTO nbq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","At Yohanes ima wombabugu lagagi ako andi, mbogot vaga en yugogogi vaga wombabugu lagagi a, ata avakwa en yugogogwa vaga wombabugu lagagi a? Yukneres!” ");
INSERT INTO nbq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yugirigya lagagimu, ir-it wene mbanggu dugwit, “Niren, ‘Mbogot vaga en yugogogi vaga ima wombabugu lagagi,’ yugugu niniselok, aren iri dugwit, ‘Eke, andi halok, hit hinilup helan, nggarogo yiluk at avyarat embetetek welagagup?’ yuknerayogon. ");
INSERT INTO nbq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Eke, it avakwa ovok erogo, ‘At Yohanes andi, navi Ala en yugugu hegek yugeraliga menda’ ombasagwima, niren ‘Un avakwa en yugogogwa vaga ima wombabugu lagagi,’ yugugu niniselok, Iya! Helep vaga nenarusogom o,” yiluk, ir-it wene mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wene mbanggu lagagwarik, at yugugu dugwit, “At Yohanes ako, sa en yugogogi vaga ima wombabugu lagagi ako nit nininggut,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yugugu lagagwama, At Yesus en, “Eke, andi halok, An ogo, sa en yuknogogi vaga ogasiga yi, wene onggo yukherayogon buk,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Andi yugirigya lagagirik, wene wakhegek it avakwa wisane yugeragagi ambi yi aro. “Ap ambi en anggur awi yatu lagagirik, enggen mbalogo nin it hidugwi, nin at wogogwis, ogagu dogopwak yiluk, at eyavup yagoma aruwam bisiluk, o adumu andoma dukluk, wasogon yiluk, lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lagagirik andoma dugwit, anggur enggen yugup ako hoda agya lagagimu, it at eyavup yago aruwam bisiluk lagagi ako en enggen yugup mbalogo wogorupwak yiluk, ayeloman ambi enadema lakba wagagi. Lakba wagagi wagya lagagimu, it at eyavup yagoma aruwam agarwik ako en ayeloman wagagi ako yo yawi vaga wakbagu lagagwarik, enggen mbalogo bagagwa ako wogogitek un ovadik eyami vaga lakbagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Un ovadik eyami vaga lakbagagwa amwa lagya lagagimu, ayeloman adik ambi lakba wagagi. Lakba wagagi wagya lagagimu, at ogo, eyave yo wakbagu lagagwarik, anggadi warogo enggen mbalogo wogogitek un ovadik lakbagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lakbagagwa amwa lagya lagagimu, ayeloman adik ambi hunogo lakba wagagi. Lakba wagagi wagya lagagimu, at ako ogo, yo warogo wibagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ap lakbisa wagagi ako anderogo adigat okbugu lagagwama, ap eyavup yago werek ako en iri dugwit, ‘An nggarogo ogarik? An nabut nendawi hunik yi, lakbayogon. Lakbagya neyalok, at agayuk wutu dugwit wugwi-sami a, dek a?’ yiluk, lakba wagagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lakba wagagi wagya lagagimu, it ap at eyavup yago aruwam welagagwa ako en abut wagya inil hugu lagagwarik, ir-it wene mbanggu dugwit, ‘Abut mavurangge hedaup yi atma, yavup yago yi mavorangge nit hedapim, abut yi mondok warusogom o,’ yiluk, ");
INSERT INTO nbq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","avyak ako wagya lagagimu, eyave yavup yagoma en haryogo weram wibaluk, mondok watugwa,” yiluk, wene andi Yesus en wakhegek yugeragagi. Wakhegek yugirigya lagagirik, ambi yugirigya dugwit, “Andi ogagagwa ako at eyavup yago werek en it ap andi, nggarogo okbisami embetep? ");
INSERT INTO nbq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dek. At wagya dogomindik, it eyavup aruwam agarwik ako enarogo bisiluk, enaveloma it ap adik aruwam dogopwak yiluk, mondok okbisayogon o,” yiluk, yugeragagi. Yugirigya ako it avakwa hunggu lagagwarik, wakhegek andi it Iserael menda enavok iri halok, anderogo okbininaup ai, yiluk “Anderogo ogarup moga o, Nenasin,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yugugu lagagwama, At Yesus en it biginigu lagagirik, wene yugirigya dugwit, “‘It helep o valisagwi menda ako en, O vanggu dugwit, helep ambi mbo bagagwa ako, mondok-mondok owanggi ndalaga o,’ yiluk, yagagi Ala wene dirup mbalek ako andi, nggarogo yiluk mbanggigi embetep? ");
INSERT INTO nbq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","It avakwa helep andi vaga yakhedugwis halok, eneyave hadik-hadok erogo wambusogom o. Eke, helep andi en avut dagauk erogo avakwa enovaga ndun yi wagya halok andi, eneyave mondok ilumutmut erak-dak-dak erogo bisayogon,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","It Musa wene mbalek mamulerelagwi menda inim, it ap imam-imam enasini inim, en, “Wene wakhegek yagas andi, nit niniselok yagas ai,” yiluk, yedok hugu lagagwarik, o andi hudi vaga Yesus vagaruguluk, ogagagwa ovara, avakwa enalon en mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","It Musa wene mbalek mamulerelagwi menda inim, it ap imam-imam enasini inim, ako en Yesus inil wolok-wolok nagu dogopwak yiluk, enarwi lakbogogwa. Enarwi lakbogogwa ako en, “Nit ap avyarat nenombarupwak,” ombakluk, enane enagavoval yagan nagu lagagwa. Enane enagavoval yagan nagu dugwit, “Yesus ane yupum-ndupum yimi vaga yidibaluk, eyave vagarogo avakwa enaruwam menda gubernur ako en awene mbalup at ovadombok atma, awene mbalupwak yiluk, ba lasogom,” umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yagan Yesus adema lagu lagagwarik, hemetu dugwit, “Ngguru wai! Hat wene yagaliga inim, mamuleraliga inim, andi avyarat adigat iri dugwit, ap ambi iya, eke, ambi meyan, andi embetetek Ala wene avyarat des erogo mamulnirigya heyagyo. ");
INSERT INTO nbq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Anderogo heyagyoma, ap inis ombok Pemerintah Oroma enasin Kaisar ake yoparip baup andi, sek a, weyak a?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yugugu lagagwama, At Yesus en it at ambokan unggwi yedok inigu lagagirik, yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Yoparip mbusi ambi enukneres,” yugirigya lagagimu, wogugu lagagwama, it yugirigya dugwit, “Sa elese ovagak ogarek inis dirup mbalek helagwi?” ");
INSERT INTO nbq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yugirigya lagagimu, iren, “Dek. Andi Kaisar aro.” Yugugu lagagwama, At Yesus en, “Andi halok, Kaisar angge halok andi, Kaisar at wogogwis, eke, Ala angge halok andi, Ala at wogogwis, ogagu dogones,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","At wene yugeragagi ako vaga avakwa inivaga wene ambi yidilogo ovaga baup meyan halok, un, “Wi!” yiluk, mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Andi en, it ap Saduki menda nin Yesus adema wagagwa. It Saduki menda ako, avakwa hambuluk, iniluk akluk mendek yusogom buk yugu lagagwa. It ako, Yesus adema wagu lagagwarik, at hemetu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ngguru wai. At Musa en, ‘Ap ambi hwa wolok, abut dek hegek hambigya halok, owa aveloma abut endarupwak yiluk, aot en owa sogwa hedaupwak o,’ yiluk, dirup mbaniragagima, ");
INSERT INTO nbq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ap ambi aburi eneyave 7 endaginipigi. At manggum ako en hwa wigya lagagirik, abut dek hegek hombagagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hambigya lagagimu, aot manggum ambetaga menda inim, ");
INSERT INTO nbq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","andi en, at aot ambukmu menda inim, andi en, it eneyave 7 endago ovok erogo anderogo adigat hwa ako wugwi, enaburi dek hegek enadigat hambugwi, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Eke, hivis, hwa ako ogo hombagagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","It ap eneyave 7 ako en hwa ako wugwi-hambugwi ogagu lagagwama, hivis avakwa hambuluk iniluk erogo mondok okbisaup hudi vaga hwa andi, ap sa ogwa arisogon embeten?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yugugu lagagwama, At Yesus en, “It avakwa yogak wema agarwik yi, ap en hwa hedugwi, akwa en ap hedugwi, ogasagwi. ");
INSERT INTO nbq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Anderogo ogasagwi ovara, At Ala en, ‘It avakwa sek menda enombasiga andi, ninim dogoguluk, hambuluk landagwima en iniluk erogo mondok okbisayogon,’ ombasiga ako andi, Ala en mondok okbisagwi. Mondok okbugu dogogwimu inim dugwit, ap en hwa hedugwi, akwa en ap hedugwi, ogagu dogogup mondok dek aro. ");
INSERT INTO nbq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ala en it avakwa ako iniluk erogo mondok okbisagwi hudi vaga, Ala aburi dombok dugwit, malaikat ako ndatak arugup atma, hivis hambugup mondok dek. ");
INSERT INTO nbq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","It avakwa hombagagwa iniluk erogo mondok okbisagwi ako andi, ambi yisogon. At Musa yo aik werek adema en hali abya wuluk kerek iri hegek iris hagagi wene ako mbilinogo dirup mbanggya dugwit, ‘Nasin Ala andi, ap Averaham inim, Isak inim, Yakup inim, enasin Ala aro,’ yiluk, dirup mbanggigi andi vaga it hombagagwa ako Ala en avyarat iniluk erogo mondok okbisaliga helagwi o. ");
INSERT INTO nbq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dirup mbanggigi ako, At Ala en it avakwa hombagagwa ovara, mondok iniluk agarwik inisaligama, at andi, it avakwa hambuluk dek agagwa menda enasin Ala dek. Ata, iniluk menda enasin Ala aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Anderogo yugirigya lagagimu, it Musa wene mbalek mamulerelagwi menda nin en, “E o Ngguru. Hat sek yegen,” yiluk, yugugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","it ovok en ambi inim At hemethaup enalon en mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","At ambi inim hemethaup enalon umbutu lagagwama, At Yesus en it yugirigya dugwit, “‘At Ala en denogo mondok okbagagi Keretus ako andi, Daut avema menda ombao,’ yagalagwi andi, nggarogo yiluk yagalagwi embetep? ");
INSERT INTO nbq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","At Daut adik en mbuku Ndawi wene vaga dirup mbanggya dugwit, ‘At Nenasin inis ombok Ala en an Nasin inis ombok yugugu dugwit, “It hinim ndup ogorek menda ako, An sovalogo havema bigitek neyagek, Ninggis amotkan hora yima,” yugogogi,’ yiluk, dirup mbanggigi ako andi, ");
INSERT INTO nbq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","at Daut en, At Keretus ako, ‘An Nasin inis ombok,’ yagagi. Anderogo atma, avakwa en ‘Keretus andi, un At Daut avema menda ombao adigat’ yup andi dek,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yugirigya lagagirik, avakwa ovok erogo enaruk hunggu-sigik, Yesus en at ane welagwi menda ako yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“It Musa wene mbalek mamulerelagwi menda ako en henambukmu unggu sao en, henendawi suwam wathidugu dogones. Enasum adup segedok yikbetaluk, ap akwa vasat ogasagwima andoma en nit adigat wogobininapwak yiluk nagwis, it Yakuri samban ogasagwima akoma ap ombok-ombok hora yagalagwima hora yugwi, isogo isugu dugwit, ap ombok-ombok hora yagalagwima hora yugwi, ogarup adigat enendawi sek ombasagwi. ");
INSERT INTO nbq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","It ap andi, akwa sogwa enangge dek okbugwis, avakwa iya nenombarupwak yiluk, samban adup erogo ogagwi, ogasagwi andi vaga, it avakwa nin enomaduk onggo horogat enovaga bugu dugwit, it ap andi ako, enomaduk onggo ombok erogo enovaga bisayogon,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Andi yugirigya lagagirik, Yesus ena laklagya dugwit, avakwa ininggi werek menda en enangge Ala awi valekma yoparip belagwima enayoparip Ala ake ba wagu sogogi. ");
INSERT INTO nbq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bagusim, hwa sogwa inggidek ambi wagya lagagirik, yoparip mbusi enggen mariduk mberen Ala ake belagwima ba wagya hagagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Ba wagya higya lagagirik, it avakwa yugirigya dugwit, “Dibas! It avakwa enangge wisane hegek ba wagao ovara, hwa sogwa inggidek menda yi, at agarom hunogo naup dek hegek ovok erogo betagarikmu, it ap akwa ininggis werek menda un horok maduk at bagao ovara, at hwa sogwa angge dek hegek ba waga yi andi eve ombok at bagas o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yugirigya lagagimu, at ane welagwi menda nin en yugu dugwit, “Ala awi valek andi, helep mondok sek inim, yi menda ndi menda mondok segedok menda Ala ake bago inim, ako vaga, mondok mondok sek valek,” yiluk, yagan lagusim, ");
INSERT INTO nbq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesus en it yugirigya dugwit, “Hit hinil helagwi yi ako andi, helep ovaga dambuk ogarek iligik andi ambiat ogo dogosogonbuk. Ovok erogo masalogo lakbaup hudi vanggo yi wasogon,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yugirigya lagagimu, iren at hemethugu dugwit, “Ngguru wai. Hat yukneregen ako o mera oklarimi? Eke, ‘Anderogo ogarup’ yukneregen ako atma des yup hudi horok vanggo yi wagya halok, adem ngga oklagya vaga nenelup arup?” ");
INSERT INTO nbq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yugugu lagagwama, At Yesus en yugirigya dugwit, “Avakwa nomalhinipu-sao en, henendawi suwam wathidugu dogones. It ap wisane huluk at An ninis vaga wagu dugwit, at ambi en, ‘At Keretus ako andi, an aro,’ iris, eke, at ambi en, ‘Hivis oklarup ako vage vanggo yi waga o,’ iris, yagan warusogoma, enane hobaluk, enamusek labuk. ");
INSERT INTO nbq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","‘Dek. Ndup sumburisagwi o. Dek. Haryogo wibisaupwak yiluk, ndup ogasagwi,’ yugwi henaruk hunggu dugwit halok, henalon habuk. Ogarup ako andi, endak oklarisogon ovara, o hivis oklarup ako mbikit oklarisogon buk o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yugirigya lagagirik, ambi yugirigya dugwit, “Ap ininis unggul adik-adik ndup sumbutwis, ap inis ombok ambi arwi en ap inis ombok ambi arwi inim ndup ombok ogagwi, ogarusogon. ");
INSERT INTO nbq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ogagu-sigik, o wadok mondok ombok wisane ogagya, yi awi ndi awi erom uvup ogagya, o yi awi ndi awi adwanggak wisane oklagya, eke, mbogot vaga mondok enalon werek menda ogagya, henelup arup elose adik menda ogagya, ogagya hasogom. ");
INSERT INTO nbq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Anderogo ovara, ogagetek hegek, ap en hit vakbigigiluk, edup-mbedup okbugugwis, it ap Yakuri samban ogasagwima bigiga lagwi, heda marogo mabiselagwima mabugugwis, eke, an nane wagagup vaga it ap ininis werek inim, it ap ombok-ombok inim, enadema wokhiniviluk lagwi, ogarusogom. ");
INSERT INTO nbq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Anderogo okbugugu-selok, ‘Yugeraup nanonggal aga o,’ yiluk, ogagya neyagu lagagup ako, yugurugu dogogup. ");
INSERT INTO nbq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Henagap wendakhedaup yiluk, wene onggo ngga yugeraup andi henendawi anggin dogobuk. ");
INSERT INTO nbq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Anen henendawi werek okbugugu dugwit wene ngga yugeraup yukheramima, yugurugu hiniselok, it hinim ogorek ako onggo yukhurugwi, henane saganggwis, okbigigasogom mondok dek. ");
INSERT INTO nbq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hinisai-henasini inim, henowa-henaot inim, henowa-henasin inim, henaswei inim, it ako en wokhiniviluk ap enowak dilisagwima bigiga lagwi, hit nin henatwis, ogarusogom. ");
INSERT INTO nbq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Eke, An ninis wagagup vaga avakwa ovok en enanggon henombarusogom ovara, ");
INSERT INTO nbq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","hinirisenggen ambiat ogo bolarugwi mondok dek atma, ");
INSERT INTO nbq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","henendawi mbuk dogomwi vaga Ala en henagap wendarisogon,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“It ap enayegen werek wisane homago o Yerusalem walinggwis inigu dogogupik, ‘O Yerusalem dek erogo baup vage vanggo yi waga higi,’ ombarugup. ");
INSERT INTO nbq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Andi hudi vanggo yi wagya halok, yi ogarup ndi ogarup Ala wene dirup mbalek ovok erogo atma des yupwak yiluk, avakwa Yerusalem menda weyak ogasagwi onggo wogeraup andi hudima, it o Yudea agarwik ako, ndom vaga andoma hoda hwilak lari wunggwis, o kota agarwik ako, o andoma hekbaluk, wunggwis, ogarupwak. Eke, o kota weram agarwik ako o kota nunggubuk. ");
INSERT INTO nbq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Andi hudi vaga Ala en o wen vaga yoma anggin-mbanggin mondok adik dombok okbugu dugwit, it avakwa yi, aninis okbisagwirikmu, akwa enavula agarwik inim, eneyak enagadyak wogerelagwi inim, hoda wulup meyan atma, enabwa. ");
INSERT INTO nbq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nin mbusinggarep vaga inutu-selok hambugwi, nin heda marogo avakwa ininis unggul adik-adik enamwa andoma bisa lagwi, ogarugup. Eke, it avakwa weram Yakuri dek menda en o Yerusalem inisok sovalogo bigik lagu dogogup. At Ala en, ‘It avakwa weram Yakuri dek menda andok dugwit, tahun anderogo o Yerusalem vagago dogosogom,’ imbitigi ako atma des yegetek hegek, sovalogo bigik lagu dogogup,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yugirigya lagagirik, ambi yugirigya dugwit, “Henelup arovovok yiluk, mo il inim, saut inim, dadiwap inim, andi mondok elokwe adik ogagya hagup. Eke, o wen vaga yoma is laut yanggadek ane ombok iri dugwit, mondok mogoliluk ogagya halok, it avakwa ininis unggul dombok ovok erogo, ‘Yi nggarogo ogarit wandiga wi!’ yiluk, enendawi mondok obak arugup. ");
INSERT INTO nbq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","It mbogot vaga enanye werek menda ako enowak dede wisane ogagya halok, it ap ovok en yi menda ndi menda o wen vaga oklarit warup ako, ‘Yi at oklarit wagya higyo,’ yiluk, enalon en enendawi mondok obak arugup. ");
INSERT INTO nbq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Andi ogagya halok, An Ap At Endaklagagis ako mondok nabinak werek niris-novagangge nagayuk werek dugwit, hena anggelekma en wagya neyagup. ");
INSERT INTO nbq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yi menda ndi menda oklarup ako asinggu halok andi, ‘Wender erogo bininaliga vage sigam ari wagya higyo o,’ yiluk, henut leklakluk, hinil iligik dogop,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yugirigya lagagirik, wene yi, wakhegek yugirigya dugwit, “Yi yo ndi yo inim, yo ara inim, o Iserael yoma ogasiga ako dibas. ");
INSERT INTO nbq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yo anggup savuligiluk, ogagya hinil hugu lagipik, ‘O vage hivi bagiluk ogasiga higi o,’ yiluk, yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ako yagalagwi ndatak, mo il inim, saut inim, dadiwap inim, mondok elokwe adik oklarup endak yukhirigi ako, oklagya hinil hugu dogogupik, ‘Ala avema bininaup ako vage vanggo yagas higi,’ yiluk, ombarugup. ");
INSERT INTO nbq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hit avakwa yogak agipik yi, ao dek agetek hinigik, hivis ogarup avok yukhirigi ako ovok erogo atma des iri hagup yiluk, avyarat yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wen inim, mbogot inim andi, dek arugwi ovara, An nane andi, mondok-mondok dek arisogon dek o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Yesus en wene ambi yugirigya dugwit, “Bagas sakno bagoma mbikit sopal landiga hak, ‘Ndugwis andi vaga anderogo okhinivisogon,’ yiluk, wene yukhirigi ako, hit avakwa o wen vaga yoma ovok erogo ndugwis ambi vaga mbikit supuk erogo okbigigya wasogonma, henendawi suwam wathidugu dogones. Yi menda ndi menda henagaum dek heda nenggek nagwis, amburup nenek ogivisiga menda nenggek nagwis, ‘Nangge nggarogo okhedaik o,’ yiluk, henendawi anggin wisane wenggelit nagwis, ogagu dugwit, henendawi ugun obak hinisao en, henendawi suwam wathidugu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Samban adigat ogagu dugwit, henendawi suwam wathidugu dogones. Andi ogagu hiniselok, anggin-mbanggin okhinivup ako henendawi mbuk dugwit, henanye erogo wugu dogomundik, An Ap At Endaklagagis nivaga henanggadi dek dugwit mendek yusogom,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","At Yesus en o dinggya Ala awi valekma wene mamulirigya, eke, o hup agya halok, wunggu lagagwarik, ndom inis Saitun akoma nogo yi lagya, ogagya lagagima, ");
INSERT INTO nbq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","o hutun hetlagatya vaga avakwa ovok At ane huluguluk, adema Ala awi valekma wonggalari wagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Isogo Erom Roti Virisigadek Menda inis Vasika ako, adenggen isarup vage vanggo yi wagagirikmu, ");
INSERT INTO nbq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","it imam-imam enasini inim, it ap Musa wene mbalek mamulerelagwi menda inim, iren avakwa wisane enalon en, “Yesus nggarogonggan waruk?” yiluk, mbauk erogo wene mbalit nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mbauk erogo mbalit nagusim, at Sile en it ap 12 menda ambi inis Yudas Ikariot endawima nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nunggwigya lagagimu, it ap imam-imam enasini inim, it Ala awi valek suwam watu lagagwa enasini inim, at Yudas en yugirigya dugwit, “Yesus warovovok yiluk, nggarogo wokheraik o,” yiluk, inim wene mbali lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Inim wene mbali lagya lagagimu, it enendawi enadenggen umbutu dugwit, “Onggo yoparip wokhurusogom,” yugugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","at Yudas ako en, “E o,” iri lagagirik, “Avakwa inil vaga dekma oklarup o ngga hudi eyave vagago wogeraup nanonggal agya hami?” yiluk, sokhigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Adenggen Erom Roti Virisigadek Menda ogagusim, isogo Vasika isaruguluk ndomba warup hudi agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","At Yesus en Peterus Yohanes iperen lakbugu dugwit, “Isogo Vasika nit naup vipuk-vapuk erogo ba lales.” ");
INSERT INTO nbq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yugirigya lagagimu, iren, “O nggoma nit vipuk erogo balauk?” ");
INSERT INTO nbq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yugugu lagagwama, At Yesus en, “Hit o kota andoma nunggugu dogomundik, ap ambi is sogolowak vaga nudik wolok lagyama, hinim avuk akluk, ap enamwa nunggwigya halok, hinim nunggwi lalo. ");
INSERT INTO nbq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Hinim nunggugu dogomundik, ap awi werek ako yugugu dugwit, ‘Nenasin Ngguru en, “An nane welagwi menda ako ninim isogo Vasika naguluk, o hamat nggoma vokot werek? yugurup,” yukneragarikmu, yukhisagwi.’ ");
INSERT INTO nbq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yugugu hiniselok, at ap awi werek ako en o handimen hamat ombok ogorek ambi ovok werek yukhirigya halok, andoma at isagogo bagu dogop,” yiluk, lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Lakbogogi lagu lagagwarik, Yesus en it yugeragagi ako ndatak at hugu lagagwarik, andoma isogo Vasika ako isagogo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Isogo bagagwa ako ovok naup vanggo iri lagagimu, Yesus en lakbigik denogo bogogi ako inim hora yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hora yugu lagagwarik, Yesus en it yugirigya dugwit, “An nova edup-mbedup okbanenggetek hegek, isogo Vasika isago yi, ninim naup ai, yiluk, hinim nasogom. ");
INSERT INTO nbq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nunggu dogomundik, hivis Ala en avakwa at avema mondok-mondok okbugu dugwit, ‘Isogo Vasika eve menda adem yi aro,’ yiluk, yedok hagup atma des yi lagatek hegek, An isogo Vasika yi nenggetek wiligya dogosogon atma, yogak ninim nasogom ai, ombasiga o, yiluk, avyarat yukheraliga.” ");
INSERT INTO nbq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Andi yugirigya lagagirik, is owak inggimu wigya lagagirik, “Ai Nasin Ala wa!” yiluk, “An yogak ninim okbaluk hivis Ala en avakwa at avema mondok-mondok bisaup ari wagetek hegek An anggur enggen amburup yi, nenggetek dogosogonma, wogogo sumbukhedomanes, yiluk, yukheraliga.” ");
INSERT INTO nbq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yugirigya lagagirik, roti inggimu wigya lagagirik, “Ai Nasin Ala wa!” yiluk, ugurogo sumburirigya dugwit, “Yi An neyave hit henake denek ako yi atma, novaga wenggenitu dugwit, nunggu dogones.” ");
INSERT INTO nbq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yugirigya lagagirik, nunggu lagagwama, amburup nudik anderogo at sumburirigya dugwit, “Hit visilogo bigigagiluk henonggo bagya dugwit namuya wilisogon ako andi, amburup yi aro. Wene swi menda Ala hinim dambubigigaup yiluk, nggatuk erogo yukheragagi ako, an namuya vaga mondok atma nggedo yisogon,” yiluk, sumbureragagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sumburirigya lagagirik, “Avyak! An narupwak yiluk, ap yugerayogon ako ninim erom naliga yoma agarik. ");
INSERT INTO nbq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","An Ap At Endaklagagis okbanup ako holek ndatak at okbanisogon ovara, at narupwak yiluk avakwa yugerayogon ako andi mondok anggin iya erogo ovaga arugwi o.” ");
INSERT INTO nbq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yugirigya lagagimu, “Sa en ogarup halok yagas?” yiluk, ir-it at ambi yugigik, at ambi yugigik yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","At ambi yugigik, at ambi yugigik yugu lagagwarik, andi en, “An iya, hat iya,” yugu dugwit, wene watu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wene watusim, at Yesus en it yugirigya dugwit, “It ap weram menda enasini ininis ombok en enane anye vaga enaburi yerogo ogarup nderogo ogarup wene yugirugwi, eke, it ap ombok-ombok en avakwa ‘Nenasini sek menda wa,’ yukneraup umbutwi, ogasagwi ovara, ");
INSERT INTO nbq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","hit andi, anderogo yugu dogobuk. Ap ombok ambi henanggelekma agarik halok, at avyak maduk ovagak arupwak. Eke, at wene yugeraliga menda ako ogo, henayeloman at arupwak. ");
INSERT INTO nbq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sa en iya agarik embetep? At erom naliga andi, iya a, ata at naliga ako ake yi welagek ndi welagek ogasiga andi iya a? Dek. At naliga menda ako iya agarik. Anderogo ovara, An henanggelekma dugwit, henayeloman ovagak akluk, henake yi welagek ndi welagek ogasiga. ");
INSERT INTO nbq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Anggin-mbanggin okbanunggu-sigik, hit An hekbanilagudek mondok ninim agipikma, ");
INSERT INTO nbq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Nasin en avakwa navema bisapwak yiluk, andok okbaninggigi ako ndatak, hit An navema bisaligama erom nunggwi, is nunggwi, eke, avakwa wene yugeralagwima dugwit, avakwa Iserael menda ininis unggul 12 ako enowak dinggwis, ogagu dogovovok yiluk, andok okbigigaliga,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yugirigya lagagirik, Yesus en, “Simon, Simon wai! Haruk dogwen. Gandum eyave delarupwak yiluk, avudit halok wibelagwi hak, at Sile en hit anderogo henavut mbalogo okbigigagiluk, Ala yugugu lagama, ‘E o,’ yagas ovara, ");
INSERT INTO nbq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","hat hendawi novaga vanggabaluk, avyarat nembeten ako, dek agya hao, An hake samban ogagi. Heyami vaga suguliluk nadema wagya dogomindik andi, harwi yi, enendawi aik wakbugu dogogun,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yugugu lagagimu, at Simon en iri dugwit, “Ai Nasin. Heda marogo mabiselagwima mabagagwi, mondok hatwis, ogagu-selok, an niperen okbininaup sek imbiti.” ");
INSERT INTO nbq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yugugu lagagimu, At Yesus en, “Peterus wai. O yogak yi vaga ayam ane ao yegetek hegek, hat hane henggam vaga, ‘Yesus andi, an ninggut,’ iri heyayogon, yiluk, yukhisiga,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yugugu lagagirik, it ovok yugirigya dugwit, “Endak lakbigigis ako, henayoparip wonggalek inim, yerek-terek wokhirugu-selok yekhedaumenda yum inim, henaropato ambi adik inim, An en ‘Wolok labuk,’ yukhirigya lagagimu, ‘Ai,’ umbutu lagagup a, dek a?” Yugirigya lagagimu, iren, “Dek. Nit nenangge ambi dek welagagetek, Nenasin.” ");
INSERT INTO nbq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yugugu lagagwama, At Yesus en, “Anderogo ovara, yogak en henayoparip wonggalek agarik halok wugwi, yerek-terek wokhirugu-selok yekhedaumenda yum werek halok wugwi, eke, mbusinggarep erasul dek halok, henayum sogwes yum weram menda vaga ambi hunhidugwi, ogagu dogones,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Andi, Ala en iri dugwit, ‘At ap weyak menda inim ininggis dingginggugwa,’ yiluk, yagagi dirup mbalek ako, An ogarimi vaga atma des yisogon, yiluk, yukheraliga. An okbanup yiluk, dirup mbanggugwa ako o yogak yi atma des yi wandiga halok, yukheraliga.” ");
INSERT INTO nbq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yugirigya lagagimu, iren, “Mbusinggarep erasul mberen yi agarik, Nenasin.” Yugugu lagagwama, At Yesus en, “Ovok at,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yugerelok akoma en wunggu lagagimu, ndom Saitun vaga enggek yagaligama, andi hudi ogo arat inggigi. Inggya lagagimu, at ane welagwi menda ako inim unggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dagaup imbitigirikmu akoma lagu lagagwarik, it yugirigya dugwit, “Weyak ogarup henendawi nggagali wagya hao, samban adigat ogagu dogones.” ");
INSERT INTO nbq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yugerelok, helep lagani beyak helendagwi ako hak, At horok adumu erogo lagya lagagirik, erambo yunggubaluk, samban ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Samban ogagya dugwit, “Ai, Nasin! Yogak edup-mbedup okneraup ako, dek okbaup imbitya heyalok, dek okbain. Eke, dek halok, An ogarup ombasiga ako hekbaluk, Hat ogarup ombasiga ako adigat ogasogon.” ");
INSERT INTO nbq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yugugu lagagimu, malaikat ambi mbogot vaga en At adema sigam ari wagya lagagirik, endawi modo okbagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Endawi modo okbagya lagagimu, endawi mondok wakhidigya dugwit, abwa edok erogo samban ambi inim ogagagi. Ogagya hegek, digak winggigi ako amuya enggen ovagak ndetek wen vaga wombagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Samban okbaluk, mendek iri lagagirik, At ane welagwi menda enadema eyami vaga lagya lagagirik, it enendawi mondok burup iri halok, nogo yugwis enegegi. ");
INSERT INTO nbq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nogo yugwis inigu lagagirik, it yugirigya dugwit, “Hit nano nogo yilagwi? Weyak ogarup henendawi nggagali wagya hao en, mendek yiluk, samban ogagu dogones,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wene andi ao yugirigyama, it ap 12 menda ambi inis Yudas ako endak wagya hegek, ap eneyave ambi homago ambetaga wagagwa. It ambetega wagu-sigik, at Yudas endak Yesus wa yugurigiluk, adema horok ari wagya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","At Yesus en, “Yudas wai! Hat wa yuknirimi ako vaga An Ap At Endaklagagis yi, avakwa en narupwak yiluk, wogeraup embeten, yei?” ");
INSERT INTO nbq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yugugu lagagimu, it Yesus inim welagagwa ako en it Yudas melen ogaruguluk, wagagwa ako yedok inigu lagagwarik, “Nenasin wai. Mbusinggarep vaga enaruk?” ");
INSERT INTO nbq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yugu-sigik, it ambi en ap imam-imam enasin ombok ayeloman aruk amot vikit sobalogo lakbagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sobalogo lakbagya lagagimu, At Yesus en, “Anderogo ogarubuk,” yiluk, ap ako aruk inggis vakbagya lagagirik, sek okbagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sek okbagya lagagirik, At Yesus en it At vagaruguluk wagagwa imam-imam enasini inim, it Ala awi valek aruwam watu lagagwa enasini inim, it ap ombok-ombok inim, ako yugirigya dugwit, “Ap enonggop welagwi menda vaginivi landagwi hak, An anderogo vakneraguluk, mbusinggarep inim, yo mbandugul inim, wolok wagep yi? ");
INSERT INTO nbq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hup-dinggya Ala awi valekma ninim neyagek, vaknetetek welagep ovara, at o hwiserek andok ako hinim okbanup yogak yi atma, ogares,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yugirigya lagagimu, Yesus vagatu lagagwarik, wolok ap imam-imam enasin ombok amwa akoma ba lagagwa. Ba lagu-sigik, Peterus ako enambetaga ya horopo lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Imam-imam enasin ombok ako amwa ba lagu lagagwarik, at awi mbumbumu andoma hali hubaluk, horaik werekma, Peterus ako enanggelekma hora yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hora yagagirik werekma, hwavyak ambi hali hunik awia vaga Peterus eyave horaik werekma higya lagagirik, at il vurek dugwit, “Ap yi ogo inim wiligya laga.” ");
INSERT INTO nbq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Iri lagagimu, Peterus en an dik-dek iri dugwit, “Hwavyak yi! Ap andi, an ninggut,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yugugu lagagimu, hivis ap ambi adik en Peterus higya lagagirik, yugugu dugwit, “Hat ogo, At menda heyagi!” Yugugu lagagimu, at Peterus en, “Avyak! An mondok dek!” ");
INSERT INTO nbq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yugugu lagagimu, andi en hivis, mo il ambi okbaluk, ap ambi adik en ane vanggo erogo yugu dugwit, “Ap yi, Nggaliliya mendama, at ogo inim avyarat wulugu lagao.” ");
INSERT INTO nbq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yagagi ovara, Peterus en, “Avyak! Hat yegen andi, an mondok ninggut aro.” Ao yuguguma, ayam ane yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ane iri lagagimu, Nenasin Yesus elokwe endenogo Peterus bikhigya lagagimu, Peterus ako en, “‘O yogak yi vaga ayam ane ao yegetek hegek, hat hane henggam vaga, Yesus an ninggut, yisogon o,’ yuknigas ako, yi at yagas,” yiluk, wenggenggu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","weram wunggu lagagirik, endawi wakhidigya dugwit yup wisane yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","It ap Yesus vagago welagagwa ako en Yesus aganda yagu dugwit, yo yawi watugwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","At il hain vaga vwi okbaluk, ambi inim watu dugwit, “Sa en hatya hegen? Iru!” ");
INSERT INTO nbq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yiluk, at wiyiknom-weyaknom erogo bagu dugwit, wene andi menda adigat wisane erogo yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Eke, o yanggo iri lagagimu, it Yakuri enawene amburup mbalisagwima ap ombok-ombok inim, ap imam-imam enasini inim, ap Musa wene mbalek mamulerelagwi menda inim, homakbaluk, werekma, Yesus awene amburup mbalupwak yiluk, At eyave wolok it enadema ba lagu lagagwama, At yugugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ala en denogo mondok okbagagi Mesias ako, Hat halok, yukneran.” Yugugu lagagwama, At Yesus en, “An yukhirigya neyalok, hit avyarat nombarusogombuk, ");
INSERT INTO nbq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","eke, Anen hit hemethinitu neyalok, hiren onggo yuknirisogombukma, An nggarogo yukheraik? ");
INSERT INTO nbq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yogak yi hudi en andi, An Ap At Endaklagagis yi, At anye iya erogo agarik Ala ako inggis amot vikit horaik dogosogon.” ");
INSERT INTO nbq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yugirigya lagagimu, it ovok erogo At yugugu dugwit, “Eke, andi halok, Hat yi Ala abut a, dek a?” Yugugu lagagwama, Aren, “Hit yegep andi aro.” ");
INSERT INTO nbq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yugirigya lagagimu, iren, “At dombok adik en yagas nit vage hunggupma, wene ambi ngga yukneraupwak yiluk, yagalagwi? Dek aro!” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","It Yakuri enawene amburup mbalisagwi menda anderogo yugu lagagwarik, avakwa homago ako ovok erogo mendek yiluk, Yesus vakbaluk Gubernur Pilatus adema wolok lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wolok lagu lagagwarik, enane huluk ova-ova yugu dugwit, “Ap yi, nit avakwa ovok nenavut dagalit lagya dugwit, ‘Ap inis ombok Kaisar o vagago agarik onggo yoparip wogorup moga o. Henasin inis ombok Keretus An aro,’ yagan lagyama, heyakbagyo.” ");
INSERT INTO nbq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yugugu lagagwama, at Pilatus en Yesus yugugu dugwit, “Ap Yakuri enasin inis ombok hat at ai?” Yugugu lagagimu, At Yesus en, “Yegen andi aro.” ");
INSERT INTO nbq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yugugu lagagimu, at Pilatus en it ap imam-imam enasini inim, avakwa wisane homago ako inim, yugirigya dugwit, “Ap yi, at avyarat weyak ogaga halok andi, At warup sek ovara, At ogaga ambi an mondok nil hegetek.” ");
INSERT INTO nbq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yugeragagi ovara, it enane vanggo erogo hunik adigat yugu dugwit, “Dek. Ap yi, wene mamuleregek lagya dugwit, avakwa o Yudea menda ovok erogo o Nggaliliya en o yi hudi at enavut dagalit landiga,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Yugugwis ako at Pilatus aruk hunggu lagagirik, “At ap yi, Nggaliliya menda ai?” yiluk, avakwa yugirigya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Yu,” yugogogwa. Yugugu lagagwama, Pilatus en ap inis ombok Herodes o Nggaliliya vagago agarik yiluk, O Yerusalem sidok wagagirik werekma, aren Yesus owak dilupwak yiluk, adema lakbagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Lakbagagi lagya lagagimu, ap Herodes ako en Yesus ogarit lagya aruk hunggu lagagirik, “Enelup arup enalon werek menda ambi ogagya haik en ai,” o muk en hogop imbita lagagima, Yesus higya lagagirik, endawi adenggen imbitigi. ");
INSERT INTO nbq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Endawi adenggen imbita lagagirik, yi wene ndi wene wisane Yesus hemethagagi ovara, Yesus wene onggo yegetek mbup erek welagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mbup erek werekma, it imam-imam enasini inim, it ap Musa wene mbalek mamulerelagwi menda inim, huluk ova-ova yugu dugwit At ovaga bagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eke, at Herodes arwi yegen werek menda inim Yesus wiyiknom-weyaknom erogo bagu dugwit, aganda yagagwa. Andi ovok okbagu lagagwarik, yum mondok segedok menda yikbaluk, eyami vaga Pilatus adema lakba lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","At Herodes Pilatus endak iperen ogorek welagagwa ovara, andi hudi iperen dambulagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesus eyami vaga lakba wagagirikmu, at Pilatus en it ap imam-imam enasini inim, Yakuri ap ombok-ombok inim, avakwa ugun inim, homakbugu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","yugirigya dugwit, “Ap yi, avakwa enavut dagalit landiga yiluk, nadema wolok wagep ovara, henane At ovaga bagep ako, hinivaga owak dinggirikmu, at weyak ogaga halok andi at warup sek ovara, At weyak ogaga ambi an mondok hegetek. ");
INSERT INTO nbq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Eke, Herodes ogo, At weyak ambi ogagatek higya lagarik, eyami vaga lakba wagama, weyak ogagu-selok, enasagwi ovara, At weyak ambi mondok ogagetek o, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Anderogoma, asam hapwak yiluk, yo adigat warogo hekbayogon,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yugeragagi ako, Isogo Vasika isagu-selok, ap heda mago ambi visilogo hekbagek ogagya lagagima, yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wene ako yugirigya lagagimu, it ovok ambivaga yugu dugwit, “A! Ap yi warogo bas. Ap Mbarabas visilogo hekbininin,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ap Mbarabas ako avakwa nin inim en, “Nenadik dogosogom,” yiluk, o kota andoma ndup ogagu dugwit, ap ambi watya lagagimu, heda magogo mabiselagwima mabagagwa werekma, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yugugu lagagwama, at Pilatus en Yesus hekbaup imbita dugwit, ane mberen vaga it yugeragagi ovara, ");
INSERT INTO nbq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","enane yanjak-hanjak yugu dugwit, “At yo winik vaga lobalogo watbas. Yo winik lobalogo watbas.” ");
INSERT INTO nbq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yugu lagagwama, at Pilatus en ane henggam vaga ambi inim yugirigya dugwit, “Nggarogo yiluk? At weyak ogaga ngga vaga yegep? Weyak ogagu-selok enasagwi ovara, weyak ogaga eve ngga halok, ‘Warup,’ yagalagwi? At weyak ogaga ambi, an hegetekma, un asam hapwak yiluk yo warogo hekbayogon.” ");
INSERT INTO nbq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yugeragagi ovara, yo winik vaga lobalogo baupwak yiluk, enane hunik adigat yanjak-hanjak yugu dugwit, Pilatus ane ako sagalogo bagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","at okbaup yugogogwa ako Pilatus en anggon imbita dugwit ovara, “Sek aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yugirigya lagagimu, at ap, “Nenadik dogosogom,” yiluk, ndup ogagya dugwit, ap watya lagagimu, heda magogo mabiselagwima mabagagwa ako, “Visilogo hekbininin,” yugogogwa ako visilogo wibagagi ovara, Yesus andi, it umbutugwa ako ndatak okbamwak yiluk, wogeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wogorigya lagagimu, vagakluk lagu dugwit, ap ambi inis Simon awi Kirene mendama, weram en endawi ugun o kota akoma nunggu wagyama, vagarogo yo winik ako Yesus ambetaga wolok laupwak yiluk, omado vaga bagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","It avakwa wisane at amusek lagu dugwit, akwa nin en ayup yagwi, eneyave wakhidugwi, ogarit inim lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ogarit lagusim, At Yesus elokwe endenogo biginigu lagagirik, it yugirigya dugwit, “Hit akwa O Yerusalem menda yi, An nayup yarubuk. Ata, hit heneyagi hinim henayup yakhidugu dogones. ");
INSERT INTO nbq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Anggin henovaga arisogonma, it avakwa en yugu dugwit, ‘Akwa wimbu inim, eneyak betelagudek inim, enagadyak wogorugwi ininggut inim, enadenggen ombasagwi o,’ yiluk, yugu dogop hudi wasogon, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Andi hudi it avakwa en ndom ombok yugugu dugwit, ‘Endenogo sopalogo bininin o,’ yiluk, yugugwis, eke, ndom maduk yugugu dugwit, ‘Neneyave sovalogo bininin o,’ yiluk, yugugwis, ogarusogom. ");
INSERT INTO nbq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Andi, avakwa en yo iluk hegek anderogo okbagu-selok, yo mbuk agya halok, nggarogo okbaup embetep?” yiluk yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yesus vagakluk lagu dugwit, it ap weyak ogasagwi menda eneyave mberen Yesus inim enaruguluk, vaginiviluk lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Vaginiviluk o inis Unggul Owakma akoma lagu lagagwarik, At Yesus it ap weyak ogasagwi ako inim yo winik vaga lobalogo bugu dugwit, ambi inggis amot vikit bagwi, ambi inggis hware vikit bagwi, ogarogo bogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lobalogo bugu lagagwama, At Yesus en, “Ai Nasin o. It ininggut dugwit, obanilagwima, it weyak ogasagwi yi, enomaduk dek erogo bisin o,” yugogogi. Eke, it ap ako en helep enggen vaga wakhegek ogagu dugwit, asum sumbukhedagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","It avakwa ako andenam inil vurek werekma, it ap Yakuri enasini ako en At wiyiknom-weyaknom erogo bagu dugwit, “At avakwa enagap wendatya lagama, At Ala en denogo mondok okbagagi Keretus ako avyarat halok andi, agap wendakhedapwak,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Eke, it ap yegen werek menda ako ogo, At aganda yagu dugwit, anggur amburup eda menda At situn okhagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Situn okhugu dugwit, “Hat ap Yakuri enasin hinis ombok halok andi, hagap wendakhedoman!” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Eke, wene ambi, “Yakuri enasin inis ombok yi aro,” yiluk, dirup warogo unggumu yo winik vaga lobabagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Lobabaluk werekma, ap mberen inim lobalogo bogogwa ako ap ambi en At Yesus wiyiknom-weyaknom erogo bagya dugwit, “Ala en denogo mondok okbagagi Keretus harat ako dek? Harat halok andi, hat hagap wendakhidigya, eke, nit nenagap wendatya, ogaru.” ");
INSERT INTO nbq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yugogogi ovara, aswe ako en at mberugu dugwit, “At ovaga lobalogo baup embetao ndatak hat ogo wane-wane hovaga lobalogo bagagaoma, hat Ala halon embetetek yi? ");
INSERT INTO nbq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nit okbininalagwi ako andi, ogagyo onggo ndatak okbininalagwima, sek at ovara, at yi andi, weyak mondok ogagetek o.” ");
INSERT INTO nbq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yugugu lagagirik, Yesus yugugu dugwit, “Ai, Nasin Yesus. Hinis ombok akluk wagya halok, An vaga hendawi wenggenerano.” ");
INSERT INTO nbq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yugugu lagagimu, At Yesus en at yugugu dugwit, “Yogak hambuluk, landagwima o mondok segedokma akoma hat niperen dogosogom o, yiluk, avyarat yukhisiga o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Eke, o dingga yam 12 vaga yi awi ndi awi andoma, mo il awia mondok dek agya lagagimu, o hup hak agagi hegek, mbikit yam 3 howam vaga o awiya agagi. Eke, Ala awi valekma yum obak ilim sivinik welagagi ako, ilim wane erogo nggago yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nggago iri lagagimu, At Yesus ane ombok vaga iri dugwit, “Ai Nasin o. Nendawi Hat hinggimu dogonyok yiluk, wokhisiga o,” yiluk, endawi weralhidigya lagagirik, hombagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","At yegen werek enasin ako en ogagya higya lagagirik, at Ala inis siyabagya dugwit, “Ap yi, at avyarat weyak ogagatek higi o,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Eke, it avakwa wisane inil dogoguluk, wonggalari lagagwa ako ogagwi hugu lagagwarik, eneyave wakhedegek eneyami vaga suguliluk enamwa wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Eke, At Yesus inim hunik ako, it akwa o Nggaliliya en at inim wagagwa ako inim, o adumu en andenam mendek dugwit, ogagwi ako ovok erogo inil lakhagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","O Yudea kota ambi inis Arimatea andoma ap ambi inis Yusup welagagi. At ap andi it Yakuri enawene amburup mbalisiga ako menda welagagi ovara, aswei wene amburup mbalisagwi menda ako en, “Yesus watbaup,” hobaluk ogagagwa ako at endawi sek atma nggedok ogasiga mendama, at ane inim mondok lobanggitek. Eke, aren “Ala avema bininapwak o,” yiluk, sokhigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","At ap ako en Pilatus adema lagya lagagirik, “Yesus eve warek wokniru o,” yiluk, nggino yugogogi, “E o,” yugugu lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","eyave warek ako visilogo wombaba wagya lagagirik, yum mudu obak vaga dinggilogo helep wis swi mendagoma avakwa ao mabigitek akoma maba lagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hutun it Yakuri samban ogarup yiluk, vipuk erogo bagwi ako vaga ogagagi. ");
INSERT INTO nbq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Eke, it akwa Yesus inim o Nggaliliya en wagagwa ako Yusup amusek lagu lagagwarik, wimu mendago inim, Yesus eyave welalogo bagagwa inim, inil hagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Inil helok, eneyami vaga enamwa wunggu lagagwarik, yo enggen amburup sek menda inim, amburup amben segedok menda inim, vipuk erogo bagagwa. Vipuk erogo bagu lagagwarik, Ala en, “Yerogo ogarup, nderogo ogarup,” yagagi dirup mbalek ako ndatak it Yakuri samban ogasagwi vaga wolok lagatek sat yanggal hedagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Eke, it Yakuri samban okbaluk, nogo yiluk hari minggu vaga hutun en it akwa en amburup vipuk erogo bagagwa ako, wolok wimu akoma lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lagu lagagwarik, helep sup larik ako higilogo hurik hugu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","nonggagagwa ovara, Nenasin Yesus eyave warek bagagwa ako inil hegetek. ");
INSERT INTO nbq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Eyave dek halok, “Yi nggarogonggan oklaga?” yiluk, werekma, yukdekma ap mberen enasum mudu amumulip digavok ovagak yirik enadema mendek yi wagu enogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Inigu lagagwarik, enalon wisane oginipu dugwit, enelese wen vaga samup yiluk, inigik, it ap ako en akwa ako yugurugu dugwit, “At iluk agarik ako it hombagagwa enanggelekma agarik hao en yiluk, belalubuk. ");
INSERT INTO nbq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Eyave yoma dek. At vage iluk akluk, mendek yagas. At o Nggaliliya dugwit, ‘An Ap At Endaklagagis ako narupwak yiluk, neyave vagarogo it ap weyak menda wogirigya dogomima, yo winik vaga lobalogo banunggu-selok, ndugwis mberen dukluk ndugwis ambi vaga Ala en niluk erogo mondok okbanisogon o,’ yiluk, wene yukheragagi ako henendawi wenggeles.” ");
INSERT INTO nbq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yugurugu lagagwama, At yagagi ako enape wenggelagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wenggenggu lagagwarik, wimu en eneyami vaga wunggu lagagwarik, inil hagagwa ako ovok erogo it ap 11 inim, enaswei inim nagu lagagwa ako ovok erogo inim, mbilinogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","It akwa en ap lakbigik menda mbilinogo yugeragagwa ako andi, hwa Maria awi Madalena menda inim, hwa Yohana inim, Yakubus isa Maria inim, it akwa adik inim, iren mbilinogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yugeragagwa ako, it lakbigik menda en, “It akwa yi wes ovagak yagalagwi,” yiluk, it avyarat embetetek welagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","At Peterus, mendek yiluk, vupuk wimu akoma lagya lagagirik, ena seve yiluk, il malhigya lagagirik, yum nggolalek ako adigat andenam hagagi. Higya lagagirik, “Yi nggarogonggan aga wii!” yiluk, endawima wenggelit amwa winggigi. ");
INSERT INTO nbq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ndugwis andi vaga Yesus ane welagwi menda mberen o Yerusalem en o ambi inis Emaus lagagwa. O kota Yerusalem en o Emaus laup andi, o adumu 11 kilometer atma, lagu dugwit, ");
INSERT INTO nbq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","oklagya hagagwa ako ovok erogo mbilinit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mbilinggu dugwit, wene nidi-hidi mbalit lagusim, Yesus adik enadema lagya lagagirik, inim lagagi ovara, ");
INSERT INTO nbq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","At yedok hagup en yiluk, enendawi apik erogo bogogi. ");
INSERT INTO nbq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Inil hwilagogo bogogi inigik, At Yesus en it yugirigya dugwit, “Hit suvaga lagu dugwit, wene ngga mbalit landagwi?” Yugirigya lagagimu, enelese enabwa edok erek mbup yugu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","iperen ako ambi inis Keliopas en At Yesus yugugu dugwit, “It ap huru yi awi ndi awi en o Yerusalem nunggu wagao agarwik ako yogak ogaga yi, ovok erogo enelup ovara, hat hadik hinggutma wagya lagindik, yegen yi?” ");
INSERT INTO nbq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yugugu lagagimu, At Yesus en, “Nggarogo agarikmu yegep?” Yugirigya lagagimu, iren, “Ap Yesus awi Nasaret menda. At andi, Ala en yugugu hegek yugeraliga menda navi dugwit, wene yugirigya laga inim, ogagya laga inim, andi Ala ogo, nit avakwa ovok ogo, ninivaga mondok anye iya erogo ogarit lagya hugu lagyo. ");
INSERT INTO nbq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Andi ovara, it ap imam-imam nenasini inim, nit Yakuri nenasini inim, iren warup wene mbabaluk, yo winik vaga lobalogo baupwak yiluk, wogirugu lagaoma, yo winik vaga lobalogo bagao ako. ");
INSERT INTO nbq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nit avakwa Iserael menda wender erogo binani warup ako Arat imbitoma, ai. Anderogo ovara, okbagao hegek, yogak ndugwis mberen welagyo. ");
INSERT INTO nbq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Eke, ambi, it akwa nit ninisai ako en nenanggela wibininggao. It akwa ako o hutun en wimu akoma lagu lagaorik, ");
INSERT INTO nbq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","At eyave warek dek hagao. Eyave dek halok, wagu lagaorik, nit yuknirugu dugwit, ‘It malaikat menda en, “Dek. At iluk agarik,” yiluk, nogo heda nenabi heda higyo,’ yuknirugu inigup. ");
INSERT INTO nbq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yuknirugu lagaoma, it nin ninim welagyo en wimu bikha lagu lagaorik, akwa yukneragao ako ndatak hagao ovara, At eyave andi, dek hagao,” yiluk, Yesus mbilinogo yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yugugu lagagwama, At Yesus en it yugirigya dugwit, “Hit henendawi wes yundup erek higi. It ap navi-navi Ala en yugirigya hegek henombawi yugurugu lagagwa ako ovok erogo henendawi obak avyarat embetetek nggarogo yiluk agipik? ");
INSERT INTO nbq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","At Ala en denogo mondok okbagagi Keretus ako anggin-mbanggin ovaga bagao yegep ako, ovaga bagetek hegek, at siyabaup embetep? Dek. Ovaga baup agarikmu, bagao,” yiluk, yugirigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","At Ala en denogo mondok okbagagi ako wagya halok, “Anderogo ogasogon,” yiluk, Musa wene dirup mbanggigi ako hudi en it ap navi-navi Ala en yugirigya hegek yugurugu lagagwa dirup mbanggugwa ako ovok erogo amburup mbalogo yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Amburup mbalogo yugirigya hegek, o it laup umbutugwarikmu akoma ndan yi lagu lagagwarik, At mbikit layogon yiluk, ogagagi menda, ");
INSERT INTO nbq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","sovabaluk, yugugu dugwit, “O mo il huruk iri dugwit o hup asogon atma, ninim dogosogom o,” yugugu lagagwama, inim dogogiluk, enamwa nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nunggwigya lagagimu, inim erom naguluk, hora yiluk, erom inggimu wigya lagagirik, “Nasin Ala wa,” yiluk, ugurogo sumbureragiluk ogagya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","“At ako yi at higyo o,” yiluk, yedok hagagwa. Yedok hugu lagagwama, inil inigik, enanggelekma andenam en dek agagi. ");
INSERT INTO nbq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Enanggelekma en dek agya lagagimu, iperen wene mbanggu dugwit, “Avyak! Sup vaga wagu dugwit, wene yuknirigya, Ala wene dirup mbalek amburup mbalogo yuknirigya, ogagya hegek, nit nenendawi mondok adenggen wisane okninivit nunggwigya higyo ako ai?” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Yugu lagagwarik, andi hudi vaga mbikit mendek yiluk, eneyami vaga o Yerusalem wagagwa. Wagu lagagwarik, it ap 11 inim, avakwa nin inim, homakbaluk dugwit, “Nenasin Yesus avyarat iluk akluk, mendek iri lagarik, eyave ap Simon adema sigam ari waga o,” yiluk, mbilinggu sogogwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Inigu lagagwarik, it ap mberen ako suvaga lagu dugwit, ogagagwa inim, erom ugurogo sumburirigya hegek At yedok hagagwa ako inim, ovok erogo mbilinogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mbilinirigusim, supuk erogo, Yesus adik enanggelekma mendek yi nunggwigya lagagirik, “Henendawi hora eres,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yugirigya lagagimu, inil hugu lagagwarik, enanggela wunggu dugwit, “Yi madis ai?” yiluk, enalon wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Enalon wisane agu lagagwama, Yesus en it yugirigya dugwit, “Hit nggarogo yiluk henendawi anggin dugwit, henendawi yunggup yegek yagalagwi? ");
INSERT INTO nbq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hit An at neyaguluk, ninggis-nisok yi, bikneyanes. An ninyo-nowak werek neyagep ndatak it madis andi ininyo enowak werek dekma, An vaknitu dugwit, An neyave at nombares,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yugirigya lagagirik, inggis-isok sigam inuk eragagi. ");
INSERT INTO nbq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Inuk irigya lagagimu, enendawi adenggen en, “Wii, nenalon! Yi nggarogonggan oklaga!” yiluk, umbutu dugwit, “Yi At eyave at,” ao embetetek inigik, it yugirigya dugwit, “Erom ambi werek a, dek a?” ");
INSERT INTO nbq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yugirigya lagagimu, ikan isogo ambi wogugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","hedigya lagagirik, it inil inigik ninggigi. ");
INSERT INTO nbq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ninggya lagagirik, yugirigya dugwit, “Ninim dugwit, An ogarup wene ako Ala wene yugup Musa en dirup mbanggigi ako inim, it ap Ala en yugirigya hegek yugurugu lagagwa navi-navi dirup mbanggugwa inim, mbuku Ndawi wene dirup mbalek inim, ovok erogo atma des yisogon o, yiluk, yukhirigya lagi ako yi okbenanggao o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yugirigya lagagirik, Ala wene mbalek sigam haupwak yiluk, enendawi awia okbogogi. ");
INSERT INTO nbq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Enendawi awia erogo okbugu lagagirik, yugirigya dugwit, “Ala wene mbalek vaga iri dugwit, ‘At Ala en denogo mondok okbagagi Keretus ako edup-mbedup ovaga bagu-selok, ndugwis mberen dukluk, ndugwis ambi vaga hambuluk bisa lendagwima en iluk agya dogomindik, mendek yisogon. ");
INSERT INTO nbq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hit weyak ogasagwi ako henasam helok, henomaduk mbo bagu dogomima, Ala en henomaduk dek erogo bigigayogon o,’ yiluk, wene ako At inis vaga, eve endak o Yerusalem en yi awi ndi awi ovok erogo yugeregek wunggu dogosogom o, yiluk, Ala wene dirup mbanggugwa ako yi at okbenanggao. ");
INSERT INTO nbq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ogagya neyagep yi ako, ovok erogo vagalogo yugeregek nagu dogop andi hit atma, ");
INSERT INTO nbq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nasin en wokheraup avok yukheragagi ako, Anen henovaga wombabigiga wasogon. Wombabigiga wasogonma, Ala anye eloma en henovaga mondok dikduk okba wagetek hegek, o kota yoma dogop,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yugirigya lagagirik, o kota en wulukluk, woginiviluk o Betania horok andoma ari lagu lagagwarik, inggis ilik bagya dugwit, adenggen enovaga bogogi. ");
INSERT INTO nbq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Adenggen enovaga ao bugu hegek, At eyave wolok mbogot vaga inggya hagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Inggya hugu lagagwarik, Ala avema seve yiluk inis siyabagu lagagwarik, enadenggen wisane embetek eneyami vaga o Yerusalem lagagwa. ");
INSERT INTO nbq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wunggu lagagwarik, Ala awi valekma akoma adigat dugwit, enendawi adenggen en Ala inis siyabagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teyopilus wai. At Yesus en yi ogagek ndi ogagek ogagya, wene mamulirigya, ogarigiluk wagagi ako asinggigi hudi en Averiniki endawima dugwit, At aori denogo lakbogogi ako wene denggalinupu lagagirik, mbogot-vaga wolok inggigi hudi ogagya lagagi ako ovok at mbuku endak ako vaga dirup watigis. ");
INSERT INTO nbq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","At watu lagagwama, hombagagi ako iluk agya lagagirik, “It naori en An avyarat niluk agi, enelup arumwak o,” yiluk, sigam agagi, eke, Nenowa Inis Ombok Ala en denogo bagagi ako avema bininaup wene ako yugirigya, ogarit lagya hegek, ndugwis 40 hudi welagagi. ");
INSERT INTO nbq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Ndugwis ambi vaga at aori inim erom nunggu dugwit, it yugirigya, “At Yohanes en ap akwa weyak ogasagwi ako mbo baguselok, ima wombabugu lagagi ovara, horok yi at Nenasin en Averiniki henovaga wombabigigya warisogon atma, hit o Yerusalem hekbaluk labuk. Nenasin en, ‘Avyarat wokherayogon o’, yiluk, yagagi An yukhirigya lagi ako, wokherapwak yiluk, sokhugu dogones,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","It ako Yesus inim homakbaluk dugwit, At yugugu dugwit, “Nenasin wai. Endak nit Iserali menda en nenasin inis ombok Daut avema ninigik, nenendawi ugun seyalek welagagup hak, nit yogak anderogo ap Oroma menda sovabininiluk agarwik ako wibisiluk nit sek okbininaup a?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yugugu lagagwama, Yesus en wene onggo it yugirigya dugwit, “O ninggi-nanggi ogagu dogop Nasin Ala adigat andok dugwit, hit Iserali menda sek okbigigaup hologo bagagi andi, hit henelup arup dek. ");
INSERT INTO nbq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hit ako Averiniki henovaga wambu wagya dugwit, At anye okbugugu halok, o Yerusalem inim, o Yudeya ovok inim, o Samariya inim, yi awi ndi awi atok-atokma andoma ovok erogo inim, An ogarit nagu hinil neyagu lagagup wene ako yugeregek nagu dogop,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wene andi yugirigya lagagirik, inil iligik inigik, wolok inggya lagagimu, hena anggelekma hwilatigi. ");
INSERT INTO nbq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","At mbogot-vaga inggya hegek, it inil ao iligik werekma, ap mberen yum mudu yanggwi iris hak yirik supuk erogo enadema mendek yi wakluk, ");
INSERT INTO nbq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","yugurugu dugwit, “Hit ap Nggalileya menda yi wai. Nggarogo yiluk mbogot-vaga hinil iligik adigat agipik? At Yesus eyave hit hinigik mbogot-vaga wolok inggya hinil hegep andi, wane-wane hivis At eyave anderogo at wambu wagya hinil hagup,” yiluk, yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yugurugu lagagwama, it lakbogogi ako o ndom Saitun vaga en o Yerusalem horok satu kilometer at eneyami vaga wambu wagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","O kota Yerusalem nunggu wagu lagagwarik, it agarwikmu handimen akoma unggugwa. It unggugwa ako eneyave andi, Peterus, Yohanes, Yakubus, Andereyas, Pilipus, Tomas, Mbarotolomeyus, Matiyus inim. Alepiyus abut Yakubus ako inim, at Simon ap Selot menda inim, Yakubus ambi abut Yudas inim, ako at. ");
INSERT INTO nbq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","It akwa nin inim, At Yesus isa Maria inim, Yesus aori ambetaga menda inim, andoma inim dambulik dugwit, enendawi ambiat akluk samban adigat ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","It andoma inigik, ndugwis ambi vaga it ap akwa Yesus Ala abut denek menda avyarat umbutugwa menda ako eneyave seratus dua puluh hudi homagagwa enanggelekma en, at Peterus ako mendek iri lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","yugirigya dugwit, “Nowa-nasin. At Yudas ako ninim Yesus ane wokbaluk, at eyavup ogagu dogosogon yiluk denogo mondok okbininggigi ovara, at Yudas ogarup wene ako o endak erogo Averiniki en Daut yugugu hegek yagagi Ala wene dirup warek ako, atma des yumwak yiluk, at Yudas en yugirigya lagagimu, Yesus eyave vagatugwa o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(At Yudas weyak ogagagi onggo yoparip bago ako vaga wen onggo bagagirikmu andenam at ape samup yi wambigya lagagirik, agaum supulagya dugwit, alor ovok erogo hudilogo wulu wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hudilogo wulu wagagi yagagwa ako, it Yerusalem menda ovok enaruk hunggugwarikmu wen onggo bagagi ako inis it enane vaga andi, “Akendama at,” yugu lagagwa. Eke nit nenane vaga andi, Amuya Wombagagirikmu, yagalagwi.) ");
INSERT INTO nbq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","At Peterus ako en wene andi yugirigya lagagirik, Ndawi Wene mbalek Ala wene ambi yugirigya dugwit, “At welagagirikmu ap akwa winggik-nonggegek yegetek werekma, o andi um dogopwak,” yiluk, yagagi. Eke, ambi iri dugwit, “At avoloma ogagya dogopwak yiluk, ap adik ambi mondok okbapwak o,” yiluk, mbuku Ndawi Wene ako vaga dirup warek agarik. ");
INSERT INTO nbq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Agarik atma, ap ambi Yesus iluk akluk mendok yagagi il hagagi halok, ninim Yesus Ala abut hambigya lagagirik iluk akluk mendok yagagi wene ako vagalogo yugeregek nagu dogoguluk, denogo baup agarikmu, okbasogon o. Ap andi at Yohanes en ap akwa ima wombabugu lagagi hudi en Yesus nenanggelekma en mbogot-vaga wolok inggigi hudi ndugurek-ndagarek Nenasin Yesus ninim nagu lagagup ako menda ambi mondok okbasogon,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yugirigya lagagimu, ap ambi denogo basogon yiluk ap mberen endak miginipugwa. Ap ambi mitugwa andi inis Yusup. Yusup andi inis henggam, inis ambi Mbaresabas, inis ambi hivis salek andi Yutus. At ako mirogo bagwi, eke, ap ambi inis Matiyas mirogo bagwi, ");
INSERT INTO nbq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","okbugu lagagwarik, samban ogagu dugwit, “Nenasin o. At Yudas ninim hat heyavup ogarit nagu dogosogon yiluk denogo bininggigin ovara, hetbininiluk at laup mikedagirikmu akoma at lagagirikmu, yi ap akwa ndi ap akwa enendawi ombasagwi ovok helup atma, it ap mberen miginipup yi, at avoloma denogo baup hologo bagen ako, yuknerano,” yiluk, samban ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Samban okbagu lagagwarik, helep enggen vaga enavut mbanggu dugwit, ‘Avut endenogo lagya halok, Yusup mondok okbaup. Eke, avut endenogo lagatek halok, Matiyas mondok okbaup,’ yiluk, ogagu lagagwama, avut endenogo lagatek halok, it ap 11 lakbogogi ako inim dogopwak yiluk Matiyas at denogo mondok okbagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","O Pendakota ogarup hudi agya lagagimu, it avyarat umbutugwa menda ako ovok erogo ambekma homakbaluk, ");
INSERT INTO nbq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","o ambekma akoma horaik werekma, havut adengga ane yagan landiga hak, mbikit supuk erogo mbogot-vaga en ane yagan umwa akoma hobo-hobo ari nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nunggwigya lagagirik, hali abya ovagak mogologo it enadik-enadik enovaga ari wagya hagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Enovaga ari wagya hugusigik, ovok erogo Averiniki enendawima hobo-hobo ari nunggigya lagagirik, yugirigya hegek, it ap akwa enane unggut adik-adik menda mbikit inilup agya halok yugurugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","O andi hudi vaga, it ap Yakuri Ala enalon ombasagwi menda, o yi awi ndi awi ovok en o Yerusalem wagu lagagwarik werekma, ");
INSERT INTO nbq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ane iris ako enaruk hobaluk, homari wagu lagagwarik, it andi enane dombok vaga yugwi ako enaruk hunggu dugwit, “Wi! Yi andi nggarogonggan aga u!” yiluk, enendawi obak agagi. ");
INSERT INTO nbq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","It ovok erogo enalon en, “Wi!” yiluk, vok yugu dugwit, “It ap Nggalileya menda en adigat enane adik-adik yagalagwi yi, dek a? It Nggalileya menda at ovara, ");
INSERT INTO nbq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","nit nenane vaga dombok yagalagwi hulisagwi yi, nggarogonggan wokbaluk yagalagwi embetep? ");
INSERT INTO nbq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nit Paratiya menda inim, Mediya menda inim, Elam menda inim, Mesopotamiya agarwik menda inim, o Yudeya en, Kapadokiya en, Pondus en, Asia en, ");
INSERT INTO nbq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Virigiya en, Pambiliya en, Mesir en, o Libiya kota Kirene avilis ambot andoma en, it Oroma menda wagao inim, ");
INSERT INTO nbq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","nit Yakuri menda inim, it Yakuri menda dek ovara, Yakuri enawene wokbaluk it ogasagwi menda inim ogarit lagagwa inim, Kereta menda inim, Arap menda inim, nit ovok erogo Ala nggarogo ogarubuk menda ombok dombok ogaga ako nenane adik-adik vaga mbilinogo yuknirugwi ovok hulisagwi o,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","It enalon en, “Yi nggarogo ogarup yiluk yagalagwi?” yiluk, at ambi yugigik ogagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","it nin en, “Dek o. Is anggur amburup nunggu lagarwik, nenek-nenek hak yagan nagwis yi hinil bigisenes,” yiluk enaganda yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Enaganda yagu lagagwama, at Peterus aswi 11 inim mondok iri lagagirik, ane ombok vaga yugirigya dugwit, “Hit nowa-nasin Yakuri menda inim, hit o Yerusalem agipik menda ovok erogo inim, wene ambi yukherayogon yiluk, henaruk hunggu dugwit, dibagu dogwes.” ");
INSERT INTO nbq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yugirigya lagagirik, “Hutun mo ao daga wagya hegek, jam 9 vaga at yiluk, it yi, anggur amburup nelok nenek-nenek hak yagan nagwis embetep andi dek o. ");
INSERT INTO nbq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nit nenane adik-adik yagalagwi yi, at Navi Yoel Ala en yugugu hegek yagagi ako atma asiga yi aro: ");
INSERT INTO nbq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ala en iri dugwit, O hivis ogarup hudi yi ap akwa ndi ap akwa ovok erogo Averiniki enovaga wombabisa warisogon. Henaburi ap inim akwa inim enendawima yugirigya neyagek, an iris ako yugeregek nagwis, Henaburi apsawe en yugirigya neyagek nogo heda enabi heda hugwi, Henasini enanggok en yugirigya neyagek enabi vaga hugwi, Ogarusogon o. ");
INSERT INTO nbq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hivis andi hudi vaga, it an nayeloman muni akwa inim, ap inim, it ogo ovok erogo Averiniki enovaga wombabisa warisogonma, an nane yugeregek nagu dogosogon. ");
INSERT INTO nbq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mbogot-vaga eloma en elose adik-adik menda ogagya, yagamu wen vaga en nggarogo ogarubuk menda ogagya, Ogagya dugwit, Enamuya inim, yivuk aveta inim, hali abya inim, ogarisogon o. ");
INSERT INTO nbq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","An Henasin Ninis Ombok warup ako vanggo yi wagya neyagek, mo il hup agya, saut andi muya ovagak agya, ogarimindikmu, An niris novangge dikduk ogakluk wagya neyalok, Wi! yiluk, siyabanusogon o. ");
INSERT INTO nbq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Andi ogagya dogomima, ap ambi sa en, Nenasin Inis Ombok o, yiluk, an neyanggup iri dogomima, agap wendarisogon, yiluk, at Navi Yoel en yugeragagi ako ari wagya yi arat o. ");
INSERT INTO nbq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hit ap Iserali menda yi, wai. An yukheraliga yi, des erogo hunggu dogones. Ala en At Yesus Nasaret menda denogo lakba wagagi hit dibavovok yiluk, Ala en anye okbagya hegek, at hinim dugwit nggarogo ogarubuk menda ogagya, enalon werek menda ogagya, elose adik menda ogagya, ogagya lagagi ako henelup. ");
INSERT INTO nbq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","At Ala en hivis ogarup hologo bagagi musek Yesus ako vagogo hit Iserali menda wokhurugu lagagwama, hambupwak yiluk, it ap weyak ogasagwi menda hinim eyave yo vaga lobalogo bagagup ovara, ");
INSERT INTO nbq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","at hambisagwima andoma mondok sovalek dogop meyan atma, hambuluk lendagwima andoma yagan watya lagagi ako agap wendarogo Ala en iluk erogo mondok okbagagi,” yiluk, Peterus en yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yugirigya lagagirik, it Yesus hambisagwima en iluk erogo mondok yagagi avyarat ombarupwak yiluk, Ndawi Wene ambi yugirigya dugwit, “O endak erogo at inis ombok Daut en Yesus vivis ogarup wene iri dugwit, ‘An Nasin Ala mondok-mondok nelosema agarik higi o. Nenasin ninim atma, an mondok wadok dek at agirik o. ");
INSERT INTO nbq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Anderogo atma, an nendawi vaga adenggen imbitya, Nane vaga siyabagagya, Ogasiga o. An hambisagwima lagiluk hetbaninggya, Habut Endawi Sek Adigat Denek ako ogo, hambuluk, vidis agya neyagek, hetbaninggya, Ogarisogon dekma, An neyave hambisogon halok, nendawi dulik dugwit, nendawi seyalek at dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Niluk dogogiluk, sup yi o, yuknogogin, Hat ninim werekma nadenggen ombok dombok okbanugun o,’ yiluk, yagagi wene ako andi, eyave Yesus en ogarup yiluk avok vagalogo yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nowa-nasin. Nit nenombao Daut ogagagi wene an vagalogo yukheraliga. At Daut ako hambigya lagagimu, wimu mabagagwarikmu akoma ninil helagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","At Daut ako andi, Ala en yugugu hegek yugeraliga menda navi atma, Ala en wene hanum mbalogo Daut yugugu dugwit, ‘Daut wai. Hat hombawi ambi wene yugeraligama havoloma dogopwak yiluk anen mondok okbayogon o’, yiluk, yugogogi. Yugogogi wene ako elup dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","At Ala denogo bagagi Keretus ako hambimima iluk erogo mondok okbayogon, Daut elup atma iri dugwit, An hambisagwima lagiluk hetbaninggya, An hambuluk, vidis agya neyagek, hetbaninggya, Ogarisogon dek o, yiluk, yagagi o. ");
INSERT INTO nbq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesus warogo bagagup ako andi, Ala en iluk erogo mondok okbagagi nit ovok ninil hagagup atma, vagalogo yukherelagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ala en iluk erogo mondok okbagya lagagirik, inggis amotkan dogopwak yiluk, siyabagagirikmu, Asin en, Averiniki wokherayogon o, yiluk, yagagi ako wigya lagagirik, woknera wagagi vaga nit ogasagwi hinil ninugwis, yugwi henaruk hunggwis, ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","At Daut ako mbogot-vaga enggetek ovara, aren iri dugwit, ‘At Nenasin Inis Ombok Ala en, an Nasin Inis Ombok yugugu dugwit, It ap ombok-ombok hinim ndup ogorek agindik menda, An havema sovalogo bigitek neyagek, ninggis amot vikit hora yima’ yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Daut en anderogo yagagi atma, at yo winik vaga hit lobalogo bagagup Yesus ako andi, Ala en hit Henasin Inis Ombok dogopwak yiluk, okbagya, eke, An denogo bagagis Keretus yi aro, yiluk, yukhirigya, ogagagi ako, hit Iserali menda ovok en, Yi avyarat, henelup arovovok yiluk yukheraliga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Yugirigya ako hobaluk, “Yesus watugup andi, nit weyak ogagagup atma,” yiluk, enendawi wakidugu lagagwarik, Peterus inim, it lakbogogi nin inim, hemerinigu dugwit, “Ayai, nenaswei. Nit weyak ogagagurikmu, nit nggarogo ogaruk o?” ");
INSERT INTO nbq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yugurugu lagagwama, at Peterus ako en, “Henomaluk dek erogo bigigapwak yiluk, hit henadik-henadik weyak ogasagwi ako henendawi wenggebaluk mbo bagu dogomundik, Yesus ambetaga lagu dogwes. Mbo bagwi hiniselok, Yesus Keretus inis vaga ima wombabigigaup. Eke, andi ogagu hiniselok, Ala en Averiniki ako un onggo dek wokherayogon o. ");
INSERT INTO nbq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ala en, ‘Henendawi wenggelogo henomaluk mbo baluk, Yesus ambetaga lagu hiniselok, Averiniki wokherayogon o,’ yiluk, avyarat nggatuk erogo yukheragagi ako andi, hit inim, hit henaburi inim, it ap adumu menda inim, hivis Nenasin Ala en yanggup yukherayogon ako ovok henake at yukheragagi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yugirigya lagagirik, wene nin wisane erogo yugirigya dugwit, “It ap Iserali o yogak endago menda weyak ogasagwi Yesus wegetek agarwik andi, hinim weyak okhinivugwi en yiluk, henagap wendak-hedavovok yiluk, hit Yesus welagwi menda inim mondok ogorek dogones o,” yiluk, ane avuput vaga enaruk watya dugwit yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yugirigya lagagimu, it ap akwa en at ane wogogwa ako ima wombabogogwa. O andi vaga inim hondalari nonggagagwa ako, eneyave dambulik ap wisane tiga ribu hudi agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","It andi en enendawi ambiat dambulik dugwit, it lakbogogi en wene mamulirugwi ako des erogo hunggwis, inim erom amburup nunggwi, samban ogagwi, anderogo adigat ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","It lakbogogi ako en nggarogo ogarubuk menda ogagwi, inilup arup enalon werek menda ogagwi, ogaguselok, it ako ovok en, “Wi! Ninigut o,” yiluk, vok yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","It avakwa Yesus Ala abut denek menda avyarat umbutugwa menda ako ovok erogo enendawi ambiat dambulik dugwit, yi menda ndi menda ako, “Nit ovok ninangge aro,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","it ambi enangge dek halok, it enangge-enangge ako, onggo hubaluk, sumburirugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","It ako enendawi ambiat akluk, ndugerek-ndagarek Ala awi valekma mbumbumu homari nunggugwi, enendawi sagain vaga adenggen dugwit enamwa adik-adik dugwit erom ugurogo baluk nunggwi, ");
INSERT INTO nbq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ala siyabagwi, ogagusigik ap akwa Yesus ao avyarat embetetek menda ovok en it Ala aburi andi, enendawi adenggen umbutwi, ogagu lagagwa. Eke, Nenasin Inis Ombok ako en ndugerek-ndagarek it ap akwa enagap wendarogo ambi labok homakbugu lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ndugwis ambi vaga o howam jam 3 it samban ogasagwi vaga, samban ogarusogon yiluk, Peterus Yohanes Ala awi valekma ungguggwa. ");
INSERT INTO nbq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ala awi valekma sup mbanggutmu inis ‘Sup Sek’, sanggugwarikmu akoma, ap erambo yidugup endaklagagi ambi en, it ap akwa Ala awi valekma nunggugu-selok, ambenggino iri dogopwak yiluk, ndugerek-ndagarek wolok ba lagu lagagwa. O andi hudi vaga vage ba lagagwa andoma werekma, ");
INSERT INTO nbq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","it Peterus Yohanes Ala awi valekma nunggugwi il inugu lagagirik, “Yoparip wokneres,” yiluk, nggino yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nggino yugirigya lagagimu, Peterus Yohanes en ap ako inil vurogo yokugu dugwit, Peterus en, “Hil bikninisin,” yugugu lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","“Nano woknirumwi?” yiluk, il yoginigigi. ");
INSERT INTO nbq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Il yoginigu lagagimu, at Peterus ako en, “Ninayoparip mbusi perak inim, emas inim, mondok dek ovara, an nandok agarik andi, ambi werekma, wokhirisogon o,” yugugu lagagirik, “At Nasaret menda Yesus Keretus inis vaga mondok iri dogomindik lagya dogwen.” ");
INSERT INTO nbq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yugugu lagagirik, at Peterus ako en inggis amotkan vagogo ao mondok okbagya hegek, ap ako isok inim, erambo inim, mbikit anye agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","soklok erogo mondok iri lagagirik, akoma nagu-wagu ogarit lagya lagagi. Nagu-wagu ogarit lagya lagagirik, soklok-soklok enggek wambegek yagan Ala siyabagek ogarit lagya dugwit Peterus Yohanes inim Ala awi valekma nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nunggwigya lagagimu, ap akwa ovok erogo ap ako isok vaga lagya dugwit, Ala inis siyabagek lagya, inil hugu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","“Ap yi, Ala awi valekma sup mbanggutmu inis Sup Sek sanggugwarikmu akoma dugwit, ambenggino iri laga ako sek aga yi, wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","At ap ako en Peterus Yohanes ininggis vagogo werekma, it ap akwa ovok Ala awi ombok valek awi ambi adik ogarek ilim andoma inis Salomo sanggugwarikmua vupuk enadema ari lagu dugwit, “Wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Homari wagwi ako at Peterus il inugu lagagirik, it yugirigya dugwit, “Hit ap Iserali menda yi wai. Ap yi sek aga andi, nggarogo yiluk vok yagalagwi? Nit nenanye vaga sek ogagatek, ata, nit sek ogasagwi menda vaga sek ogagatek, halok, vok yuknerabuk! ");
INSERT INTO nbq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ninombawi Averaham inim, Isak inim, Yakup inim, Enasin Ala ayeloman Yesus ako, at Pilatus en hetbaup imbitya hegek, hit en, At yi, nenanggon o, yiluk, warupwak yiluk, wogoragagup ovara, Ala en vage siyabagagi o. ");
INSERT INTO nbq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","At Endawi Mot, Sek Adigat Denek Agarik ako, “Nenanggon o,” yiluk, aveloma ap enasiga menda ambi hetbaup yiluk yagagup ako, hit Iserali menda aro. ");
INSERT INTO nbq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Niniluk okninivisiga menda adem ako arat hegek hirenen watugup ovara, Ala en hambisagwima en iluk erogo mondok okbagagi ako ninil hagagup atma, vagalogo yukherelagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesus en ogarup sek o, yiluk, nenendawi at ova vanggabaluk avyarat imbito ako vaga ap isok weyak hit hinilup hinil helagwi yi ako, sek erogo anye okbagas. Nenendawi Yesus avyarat imbito vaga at sek aga hinim agarik yi, hit ovok hinil hegep o. ");
INSERT INTO nbq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ai, nowa-nasin. Henasini ap ombok-ombok hinim ogagagup ako andi, hininggut dugwit ogagagup an nelup aro. ");
INSERT INTO nbq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","O muk Ala en iri dugwit, ‘An Henowa Inis Ombok denogo bagagis Keretus ako, idup-mbidup erogo yagan warisogon o,’ yiluk, yagagi ako, atma agatek hegek it ap navi-navi Ala yugirigya hegek yugu lagagwa ako, hit ogagagup vaga atma des yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Des iri lagagimu, Henasin Ala en hit henomaluk dek erogo bugugu vaga, henendawi adenggen ugun dogovovok yiluk, henendawi wenggebaluk henomaluk mbo bagu dogomundik Yesus ambetaga lagu dogwes. Andi ogagu hiniselok, henake denogo bagagi Keretus ako andi, Yesus atma, lakba wasogon o. ");
INSERT INTO nbq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","O muk erogo At Ala en, Anderogo ogarisogon o, yiluk, it navi-navi at ane yugurugu lagagwa menda mondok adik denek yugu lagagwa ako, atma des yumwak yiluk, At Ala en wen-mbogot, yi menda ndi menda, ovok erogo adik swi menda ogarup ao helan, At Yesus mbogot-vaga andoma dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","At Musa en iri dugwit, ‘Henasin Ala en an lakbani wagagi hak, ap Ala en navi yugugu hegek yukheraliga menda ambi, hit menda at, henake henadema lakba warisogon o. Lakba warisogon ako en yi wene ndi wene yukhirigya halok, henaruk des erogo hunggu dogop o. ");
INSERT INTO nbq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","At yukheramima hit ambi en henaruk des erogo hunggitek dogosogon halok, henanggelekma en denogo baluk elose dek erogo bayogon o,’” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“It ap navi-navi Ala en yugirigya hegek yugu lagagwa menda, Samuel en yugirigya lagagi hudi en, at ambetaga wene yugurugu lagagwa hudi, it ako ovok erogo en yogak Yesus eyave vaga oklandiga yi, agatek hegek, yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","It navi-navi Ala en yugirigya hegek yugu lagagwa ako, enombawi hit aro. Ala en at Averaham yugugu dugwit, ‘Yi ap akwa ndi ap akwa o wen vaga yoma ako ovok erogo hat endaginivisogon vaga enadenggen hugu dogosogon o’, yiluk, wene avyarat nggatuk erogo henombawi yugeragagi ako, hit menda mavorangge at yugeragagi o. ");
INSERT INTO nbq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Andi halok, At Ala en at ayeloman mondok okbagya lagagarik, hit weyak ogasagwima en wokhiniviluk wagya dugwit, adenggen henovaga bigigapwak yiluk, endak hit at henadema lakba wagagi o,” yiluk, at Peterus en wene andi at yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peterus Yohanes en it ap akwa ao yugurugu-sigik, it ap imam-imam agama Yakuri vagago welagagwa menda inim, Ala awi valekma suwam watu lagagwa menda enowa inim, it Saduki menda inim, enadema wagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","“At Yesus ap akwa hambisagwima en iluk erogo mondok okbagagi o,” yiluk, Peterus Yohanes en ap akwa Yesus vaga hambuguselok, iniluk erogo mondok okbisaup wene ako mamulirugu lagagwama, enaninis en ");
INSERT INTO nbq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","eneyave vaginipu lagagwarik, o hup agya lagagimu, hutun en yugeraguluk wogenombolok lagu lagagwarik lembaga mabogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mabogogwa ovara, it wene ako yugurugu-sigik hunggugwa ako eneyave wisane Yesus Ala abut denek avyarat umbutugwa. It ap adigat avyarat umbutugwa andi eneyave ovok dambulik lima ribu hudi agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Nogo yiluk, hutun en it Yakuri enasini inim, ap ombok-ombok inim, it Musa wene mbalek mamulurugu lagagwa menda inim, homagagwa. At imam inis ombok winimen agarik Hanas inim, Kayapas inim, Yohanes inim, Alesander inim, at Hanas ako owa-aot nin inim, it ovok erogo o Yerusalem homakbaluk, ");
INSERT INTO nbq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Peterus Yohanes enadema bisa wagu lagagwarik, yugurugu dugwit, “Hit en ap sek ogagep ako, sa inis vaga ogagep? Sa anye vaga ogagep?” yiluk, enaigwakma wogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Enaigwakma wugu lagagwama, Averiniki en anye okbagya hegek Peterus en yugirigya dugwit, “Hit ap akwa Yakuri enasini inim, ap ombok-ombok inim, wene ambi yukheraliga o. ");
INSERT INTO nbq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ap isok weyak abwa umbutu dugwit, sek ogagyo ako andi, nggarogonggan sek ogagep o? yiluk, hit yogwak nenaigwakma welagwi andi, ");
INSERT INTO nbq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","hit inim, ap akwa Iserali menda ovok inim, henelup arovovok yiluk adem des erogo yukheraliga o. At ap sek aga henadema mendek agarik yi, At Yesus Keretus Nasaret menda hit yo winik vaga lobalogo watu lagagupmu, Ala en hambuluk lendagwima en iluk erogo mondok okbagagi ako inis vaga mondok sek aga o, yiluk, yukheraliga o. ");
INSERT INTO nbq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ala en iri dugwit, ‘Hit o valisagwi menda en helep vaga vanggu dugwit, helep ambi mbo bagagwa ako, mondok-mondok helep owak ndalaga o,’ yiluk, yagagi andi, At Yesus at yiluk yagagi o. ");
INSERT INTO nbq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","It ap akwa yi awi ndi awi o wen vaga yoma menda ovok erogo, ‘Ap yi en at henagap wendarisogon o’, yiluk, inis ambi adik yukneregetek. Ata, ‘At Yesus adik en at, henagap wendarisogon,’ yiluk, yukneragagi.” ");
INSERT INTO nbq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Yugirigya lagagimu, it homagagwa en Peterus Yohanes ako, sekolah ogagetek un ap menda welagagwa ovara, enalon dek dugwit, yugurugwi yedok inigu lagagwarik, “Yesus inim nagu lagagwa yi at inigup o,” yiluk, vok yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ap sek aga ako Peterus Yohanes enadema mendek hugu lagagwarik, “Wene onggo nggarogo yuguruk?” yiluk, mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mbup yugu lagagwarik, “Wene amburup mbalisagwima en weram wilitales,” yugurugu lagagwama, wunggu-sigik, enadik en wene mbanggu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ap yi, nggarogonggan okbisamwi? Nggarogo ogarubuk menda iya ogagao ako it Yerusalem menda ovok erogo inilup agaorikmu, nit en, ap sek ogagetek, yup andi, meyan. ");
INSERT INTO nbq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ata, ombok vaga mbigalit lagup en, Ap andi inis vaga ambi inim yugeregek nagu dogop mondok moga. Ambi inim yugeregek nagu hiniselok, weyak erogo bigigasogon, yugerauk,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yugu lagagwarik, yanggup yugeragagwa wagu lagagwama, yugurugu dugwit, “At Yesus inis ambi inim yugurugwi, mamulirugwi, ogarit laup mondok moga,” yiluk, mbereragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mbererugu lagagwa ovara Peterus Yohanes en it yugurugu dugwit, “Nit Ala ane hulup a, hit henane hulup a? Ala ivaga hiren wene nggatuk hanes. ");
INSERT INTO nbq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nenaruk hunggwis, ninil hugwi, ogagyo wene andi, yugeregetek mbup yup meyan okninivisigama, yugurugu dogosogon o.” ");
INSERT INTO nbq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yugurugu lagagwama, ap ako sek aga halok, it ap akwa ovok en Ala siyabagwi inigu lagagwarik, enalon en, “Adem nano vaga yidilogo weyak okbisamwi o?” yiluk, we un enalon ombarupwak yiluk enane anye vaga mbererugu lagagwarik, heda visilogo wibogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","At ap nggarogo ogarubuk menda vaga sek ogagagwa ako, endago hegek 40 tahun at ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Visilogo wibugu lagagwama, Peterus Yohanes ako enaswei werekma lagu lagagwarik, it ap imam-imam agama Yakuri vagago agarwik menda enasini inim, ap ombok-ombok inim, yugeragagwa wene ako mbilinogo enaswei yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yugurugwi ako it enaruk hunggu lagagwarik, it inim enendawi ambiat akluk samban ogagu dugwit, “Nenasin Ala wa. Wen-mbogot inim, is ombok yanggadek inim, yi menda ndi menda ovok harenen hadigat ogagagin o. ");
INSERT INTO nbq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ninombao Daut hat hayeloman ako Averiniki endawima des iri lagagimu, Hat Ala en yugugu heyagek, aren Yesus oklarisogon avok iri dugwit, It yi ap akwa ndi ap akwa naninis-haninis yagan lagu dugwit, weyak erogo bigik nagwis, Ap ininis unggul adik-adik menda wene enam warogo hwilak-hwilak mbalit nagwis, Ogagwi andi, Nggarogo yiluk ogasagwi? ");
INSERT INTO nbq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","At Nenasin Ala inim, At denogo bagagi ako inim weyak okbisaguluk, Ap ininis ombok yi awi ndi awi en dikduk ogagwi, Ap akwa enasini ap ombok-ombok homakbaluk, wene hologo bagwi, ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yagagi ako, o kota yoma it Herodes inim, Pondiyus Pilatus inim, it weram Yakuri dek menda inim, it Iserali menda inim, iren hat hayeloman Endawi Sek Adik Denek Yesus, hat denogo mondok okbagagin ako, at warupwak yiluk avyarat o kota yoma homagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hat hinggis anye vaga yi ogagek ndi ogagek ogarup endak hologo bagagin ako, ogarusogon yiluk ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nenaruguluk ogasagwi andi hil bigisin o, Nenasin. Inugu dogomindik, nenalon dek dugwit hat hane yugurugu dogosogon yiluk, nit hayelomani nenendawi wadok dek erogo bininin o. ");
INSERT INTO nbq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","It aup warek andi iniselok, sek arupwak yiluk hinggis vakbisin. Eke, hayeloman Endawi Sek Adik Denek Yesus ako inis vaga nggarogo ogarubuk menda inim, inilup arup enalon werek menda inim, ogasiga menda ako, nit ogaruguluk okbininin o,” yiluk, samban ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Samban ogagu lagagwama, o it werekma ako wadok iri dugwit, Averiniki en anye okbugu lagagimu, inugutek dugwit, Ala wene yugeregek nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","It avakwa Yesus Ala abut denek menda avyarat umbutugwa menda ako ovok erogo enendawi ambiat dambulik dugwit, enangge-enangge ako, “Yi hat menda o. Yi an menda o,” yegetek ovara, we un, “Nit ovok ninangge o,” yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","It lakbogogi ako en, “Nenasin Yesus hombagagirik iluk akluk mondok yagagi o,” yiluk, enalon embetetek enane anye vaga wene ako vagalogo yugeregek nagu lagagwa. Yugeregek lagu-sigik, Ala en adenggen wisane enovaga bugu lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","It enawen werek halok, ata it enawi valek werek halok, onggo hubaluk, yoparip ako it lakbogogi enadema ba laguselok, it ambi enangge dek halok sumburirugu lagagwa vaga, it enangge dek ambi welagetek. ");
INSERT INTO nbq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Anderogo ogagusim, ap Lewi menda ambi inis Yusup, awi adem Sipurus mendama, it lakbogogi en inis ambi Mbarenabas yugu lagagwa. Nit nenane vaga inis andi, “Enendawi Aik Wakbisaliga o,” yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","At ap ako awen yavup yasigama ambi werekma, onggo hunggu lagagirik, yoparip ako wolok it lakbogogi enadema ba wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ap ambi inis Ananiyas, at ogwa Savira inim it enawen ambi werekma, at Ananiyas en it enawen ako onggo hunggigi. ");
INSERT INTO nbq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Onggo hunggu lagagirik, yoparip ako, at ogwa elup hegek, agun ako en nin higirogo it batugu lagagwarik, nin wolok lakbogogi ako enadema ba wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ogagya lagagimu, at Peterus en, “Ananiyas wai. Hawen onggo wokhigao nin higirogo hekbategen ako andi, hat nggarogo yiluk Sile hendawima des yi nunggigya lagama, hat hane huluk yegen vaga Averiniki ambukmu enggen? ");
INSERT INTO nbq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hawen andi, onggo wokhigitek hegek, hat hawen at welaga ako dek a? Eke, yoparip wegen ako andi, hat hayoparip atma, Yoparip yi vaga nggarogo ogarik o, yiluk, hova dombok hulup sek ovara, hegek, venak vikit adigat wolok wagya dugwit, ovok ba waga nombarupwak yiluk, nggarogo yiluk nin adigat ba wagen? Nit ap akwa ninambukmu enggen dek o. Ata, Ala at ambukmu enggen,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yugugu ako Ananiyas aruk hobaluk, wen vaga ndun iri lagagirik, andenam at hombagagi. Hombagas o, yugwi ako enaruk hunggugwarikmu it ovok en, “Wi!” yiluk, enalon wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Eke, hombagagi ako it ap sawe wagu lagagwarik, eyave yum hain vaga dinggibaluk, wolok wunggu lagagwarik, wenma huvur okba lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Huvur okba lagagwa inigik, mo il henggam welagagwarik, ogwa ako agun hombagagi unggut dugwit, ugun nunggu wagya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peterus en hwa ako yugugu dugwit, “Savira wai. Hit henawen onggo hunditip ako, yoparip yerogo at wokheraga? Iru o.” Yugugu lagagimu, “E o. Anderogo at wokneraga,” ane huluk at yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yugugu lagagimu, Peterus en at yugugu dugwit, “Hagun hit mberen wene ambiat mbabagu lagipik, nggarogo yiluk Nenasin Averiniki ambukmu enggep? Hit mberen Averiniki ambukmu enggep atma, it ap hat hagun wen huvur okba lagao ako en yogak hat ogo wokombolok laguluk, sup mbanggutmu nunggu wendagwi yi yogisin o.” ");
INSERT INTO nbq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ao yugugu hegek, hwa ako Peterus adema andenam at ndun iri lagagirik, hombagagi. Hambigya lagagimu, it ap sawe ako en nunggugu lagagwarik, nggorak hagagwa. Nggorak hugu lagagwarik, eyave wolok, agun adema akonam wen huvur okba lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ala aburi inim, it anderogo aga yugwi hunggugwarikmu ako inim, it ovok erogo, “Wi!” yiluk, enalon wisane ogonipigi. ");
INSERT INTO nbq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","It lakbogogi ako en ap akwa wisane enanggelekma inilup arup enalon werek menda inim, nggarogo ogarubuk menda inim, wisane at ogagu lagagwa. Eke, it avakwa Yesus Ala abut denek menda avyarat umbutugwa menda ako ovok erogo Ala awi valekma awi ogarek inis Salomo sanggugwarikmu akoma, homari lagek ogagu dugwit, enendawi ambiat welagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","It ap akwa nin ako en, “It yi andi sek at ogwasagwi o,” yiluk, enadenggen umbutu lagagwa ovara, enalon en inim homagetek at welagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Anderogo at ovara, it ap inim, akwa inim, Nenasin Yesus ovaga vanggabaluk avyarat umbutu lagagwarik, ambi labok nonggegek adik at ogagu dugwit, eneyave wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","It lakbogogi anderogo ogarit lagwima, Peterus wagya halok at agur-agut enovaga arupwak yiluk, ap akwa aup warek sup vaga wogonombolok wagu lagagwarik, nogo yilagwi menda vaga ndalogo bogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","It kota Yerusalem avilis ambot en ap akwa wisane homakluk wagu dugwit, it aup warek inim, it madis enendawima nonggagagi inim, wogonombolok bisa wagu lagagwarikmu, ovok sek agu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Andi okbaluk, at ap imam inis ombok winimen agarik ako inim, aori ap Saduki menda ovok inim en, “A! It ap akwa en it Yesus ane welagwi menda vok yugurugu dugwit, nit ako vok yukneralagwi dek andi nenanggon!” yiluk, enaninis en ");
INSERT INTO nbq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","it lakbogogi ako vaginipu lagagwarik, lembaga mabogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mabogogwarikmu o hup akoma werekma, Ala yonggo lakbisa wandiga menda malaikat ambi wagya lagagirik, lembaga sogop hurogo wibisiluk yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Hit Ala awi valekma andoma lagu dogomundik, Yesus avyarat umbutu-hiniselok, mondok hiniluk dogop wene ako ap akwa ovok yugerano,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yugirigya lagagimu, o hutun en Ala awi valekma nunggugu lagagwarik, malaikat en wene yugeragagi wane-wane ap akwa wene mamulirigu lagagwa. Mamulirugusim, ap imam inis ombok ako inim, aori inim, it Iserali enasini wene amburup mbalisagwi menda ovok homari warupwak yiluk, yonggo lagagwa wagu lagagwama, it lakbogogi lembaga werekma ako wogonombolok warupwak yiluk, ap Ala awi valekma suwam agarwik ako lakbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lakbogogwa ako lagu lagagwarik, lembaga andoma belalinipugwa menda, eneyave dek agu lagagwama, wagu lagagwarik, yugurugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“O lembaga sogop mondok larik hugwi, eke, it ap sup suwam agarwik menda ogo, sup mbanggutmu mendek werekma inugwis, ogagyo ovara, sup hurugo yoginigu lagurik, eneyave dek at inugup o,” yiluk, it wene amburup mbalisagwi menda ako yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wene ako hunggu lagagwarik, At Ala awi valek suwam agarwik menda enowa inim, it imam-imam enasini ap ombok-ombok inim, enendawi obak dugwit, “Eneyave nggarogonggan winggao embetep?” yiluk, yugusim, ");
INSERT INTO nbq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ap ambi wagya lagagirik, it yugirigya dugwit, “Avyak wai! Ap heda marogo lembaga mabigip ako, Ala awi valekma lagu lagaorik, wene mamulirugu-sigik, wagi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yugirigya lagagimu, ap Ala awi valek suwam agarwik menda enowa aori inim en it lakbogogi ako wogonivi lagu lagagwarik, “Ap akwa en helep vaga ninitwis hawen,” yiluk, enalon en inititek enewogo at wogonombolok wagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wogonombolok it wene amburup mbalisagwi menda enadema bisa wagu lagagwama, at ap imam inis ombok ako en hemerinipu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ap andi inis vaga mamuliraup moga, yiluk, mbet yukhurugu ninigik, hit wene mamuleregep vaga o Yerusalem ovok hulit lagao andi, ap watugwa andi nit nenovaga dogopwak yiluk, yugeregek lendagwi yi?” ");
INSERT INTO nbq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Yugirigya lagagimu, at Peterus inim, it lakbogogi nin ako inim, iren wene onggo yugurugu dugwit, “Nasini. Ap akwa en yuknirugwi andi, nit hulup dek o. Ala en yuknirigya halok adigat hulup o. ");
INSERT INTO nbq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Hit Yesus yo vaga lobalogo watugup ako, nenombawi Enasin Ala en hambisagwima en, iluk erogo mondok okbagagi o. ");
INSERT INTO nbq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mondok okbagya lagagirik, nit Nenowa inis ombok, nit nenagap wendarisiga menda ako, At Ala inggis amotkan dogopwak yiluk siyabagagi. Nit ap akwa Iserali menda weyak ogasagwi ako, nenendawi wenggebaluk weyak ako mbo bagu dogomundik, Yesus ambetaga lagu niniselok, nenomaluk dek erogo bininaupwak yiluk siyabagagi o. ");
INSERT INTO nbq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ala en yuknirigya nit des erogo ogagu niniselok, Averiniki wokneragagi. At Averiniki ako ninim dugwit, nit wene yi ovok erogo vagalogo yukherelagwi o,” yiluk, yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wene andi hunggu lagagwarik, enendawi weyak en enaninis ane yugu dugwit, ‘Mondok inurusogon,’ umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Umbutugwa ovara, ap Parisi menda ambi Musa wene mamuleraliga menda, ap akwa ovok en agayuk wutu lagagwa, inis Nggamaliyel. Aren it ap wene amburup mbalisagwi menda inivaga mondok iri lagagirik, yugirigya dugwit, “It sidok dukluk nunggu warupwak yiluk, wulupwak.” ");
INSERT INTO nbq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yugirigya lagagimu, Peterus Yohanes wunggu-sigik, it wene amburup mbalisagwi menda ako yugirigya dugwit, “Hit ap Iserali menda yi, wene ambi yukherayogon o. Ap yi, okbisaup ako henendawi des erogo wenggenggu dogones. ");
INSERT INTO nbq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","O endak en ap Teudas ako mendek iri lagagirik, An iya atma, vok yuknirupwak, imbitya dugwit, yagan wagya lagagimu, ap eneyave empat ratus at ane waguluk musek lagagwa ovara, at ako watwis, eke, at musek lagagwa ako sak okbugwis, ogagu lagagwama, ane ako dek agagi. ");
INSERT INTO nbq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hivis, ap akwa ovok ininis dirup warupwak yiluk ogagusim, ap Nggalileya menda ambi inis Yudas, wagya lagagirik, ap nin at ane hulupwak yiluk nomalinipigi menda, watu lagagwama, at ane wogogwa ako hoda sak yagan lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Anderogo atma, ap yogak mendek yagao yi, hetbisavovok yiluk, yukheraliga o. Enendawi hologo ogarit nagwis ako andi, we un ap akwa enendawi ombasagwi menda ogasagwi halok andi, mondok dek arisogon o. ");
INSERT INTO nbq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Eke, Ala ombasiga menda ogasagwi halok andi, it enane sagalup meyan atma, Ala en, An ninim ogorek dugwit ogasagwi, hinimbitya hao en, hekbisenes o, yiluk, yukheraliga o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yugirigya lagagimu, it wene amburup mbalisagwi menda en, “Avyarat yagas,” yiluk, it lakbogogi ako, yanggup yugeragagwa wagu lagagwama, yugurugu dugwit, “Yesus inis ap akwa yugeregek laup mondok moga o,” yiluk, yo labirok initu lagagwarik, wibogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wene amburup mbalisagwima akoma en wibugu lagagwama, lagu dugwit, “Nit at inis yagan nagwis vaga nenanggadi warogo bininggao andi, sek aro,” yiluk, enendawi adenggen wisane ombarit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lagu lagagwarik, Ala awi valekma en, umwa en, ovok erogo ndugerek-ndagarek wene mamulirugwi, “Nenowa Inis Ombok Ala en denogo bagagi Keretus ako andi, Yesus aro,” yiluk, sek wene ako yugurugwi, ogarit nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","O andi hudi vaga Yesus ane wapwak yiluk ambi labok nonggegek adigat ogagu dugwit, it ap Yakuri menda ovara, Yunani enane yugu lagagwa en, “Ndugerek-ndagarek erom sumburirugu dugwit, nit ninisai akwa sogwa nggarogo yiluk erom wogeregetek hekbisalagwi?” yiluk, it Yakuri enawerek Iberani enane yugu lagagwa menda ako inim naburuk-haburuk yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Anderogo yugwi ako it ap 12 menda enaruk hobaluk, Yesus ane wogogwa menda ovok erogo homakbugu lagagwarik, yugurugu dugwit, “Naswei o. Nit Ala wene mamulherelagwi ako hekbaluk, erom sumbukirugu dogop meyan atma, ");
INSERT INTO nbq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","it ap Averiniki enendawima des yi nonggagagi, enendawi werek dugwit yagalagwi, henelup adigat, henanggelekma en ap eneyave 7 denogo mondok okbisines. Mondok okbisasogon yi, iren adigat ogagusigik, ");
INSERT INTO nbq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","nit andi, Ala wene adigat yugurugwi, samban adigat ogagwi, ogagu dogosogon o,” yiluk, yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yugeragagwa ako it ap akwa ovok homagagwa enaruk hobaluk, “Sek at yegep o,” yiluk, denogo mondok okbogogwa ako, ininis yi o: Ap ambi endawi avyarat imbitigi vaga yunggup yegetek, Averiniki endawima des yi nonggagagi Sepanus inim, Pilipus inim, Porokorus inim, Nikanor inim, Timon inim, Paremenas inim, ap ambi Yakuri menda dek, awi adem Andiyokiya welagagi ovara, it Yakuri enawene wokbaluk it ogasagwi menda inim ogarit lagagi, inis Nikolaus inim, ");
INSERT INTO nbq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","denogo bugu lagagwarik, it lakbogogi ako enadema bisa wagu lagagwama, inunggul ininggis vakbisiluk samban okbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eke, Ala wene ako ombok at mbigalit lagya hegek, o Yerusalem andoma it at ane wapwak yiluk ambi labok nonggegek adigat ogagu dugwit, wisane at agwi, eke, it ap imam-imam agama Yakuri vagago welagagwa menda ogo wisane at, “Wene wasogon o,” yiluk, Yesus Ala abut denek menda avyarat umbutwi, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","At Sepanus ako Ala en adenggen eve wisane ovaga bagya, anye wisane okbagya, ogagya lagagimu, nggarogo ogarubuk menda ogagya, enelup arup enalon werek menda ogagya, ogarit lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ogarit lagya hegek ovara, o it Yakuri samban ogasagwima ambi inis Heda Pisilogo Bigigigirikmu sanggugwarikmu akoma, it Yakuri menda o Kirene en, Alekandiriya en, Kilikiya en, Asia en, akoma homagu lagagwa. Ndugwis ambi vaga homari wagu lagagwarik, Sepanus inim wene watugwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Inim wene watugwa ovara, at Sepanus ako Averiniki en hologo yugugu hegek endawi werek dugwit, yugeragagi vaga iren onggo yugurup meyan agya lagagimu, mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wene onggo yugurup meyan agya lagagimu, it andi en, “At Sepanus andi, Ala inim, Musa inim, wiyiknom-weyaknom erogo bagya higyo o,” yiluk, ako enane huluk yegek lagu dogopwak yiluk, ap nin onggo wogeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wogerugu lagagwama, wene andi yugwi it ap akwa inim, ap ombok-ombok inim, it Musa wene mbalek mamulurugu lagagwa menda inim, enendawima mali wagu lagagwama, enaninis en ap Sepanus ako vagakluk, ap wene amburup mbalisagwi menda enadema ba lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba lagu lagagwama, it huluk wene molalogo yugerapwak yiluk, mondok okbogogwa ako en, ap wene amburup mbalisagwi menda yugurugu dugwit, “Ap yi, hutun-howam mbup yegetek Ala awi valek mogama inim, Ala wene yugup Musa en dirup watigi wene ako inim, weyak erogo bagya higyo o. ");
INSERT INTO nbq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","At ap yi en iri dugwit, Yesus Nasaret menda ako en Ala awi valek yi, masalogo bagya, eke, Musa wene yerogo ogarup nderogo ogarup yukneragagi ninitok hunik ogasagwi menda ako adik okbagya, ogarisogon o, yiluk, iri higyo o.” ");
INSERT INTO nbq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yugurugu lagagwama, it wene amburup mbalisagwima horaik welagagwa ako ovok en, at Sepanus eyave inil vurogo yokugu dugwit, at elose andi, malaikat elose ovagak hagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Eke at ap imam inis ombok ako en Sepanus yugugu dugwit, “Ap wene yagas andi, hat avyarat yegen yi?” Yugugu lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","at Sepanus ako en wene onggo yugirigya dugwit, “Nowa-nasin, henaruk holek dogones. Nenombao Averaham o Haran wagetek dugwit, ao o Mesopotamiya werekma, at mondok siyalek agarik Ala ako adema lagya lagagirik, Averaham yugugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Hawen inim, howa-hasin inim, hekbugu dogomindik, hat dogopim ambi yukhugu neyalok, andoma at elalo o,’ yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yugugu lagagimu, at Averaham ako ap akwa o Kasim enamwa o Mesopotamiya akoma nggelabisiluk, o adumu Haran mbup yi wagagi. Mbup yi wagagirik werekma, asin hombagagi. Hambigya lagagimu, o Haran hekbaluk yogak nit Iserali werekma yoma Ala en o adumu en at lakba wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Lakba wagagirik werekma, At Ala en Averaham andok dogopwak yiluk wen ambi mbanggitek, we un maduk mbalek ambi dogopwak yiluk wogigitek, ogagetek at ovara, at aburi mondok dek inigik, yugugu dugwit, ‘Wen yi, hat inim, hat vaga wigalek inim, andok dogosogon o’, yiluk, wene avyarat nggatuk erogo yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yugugu lagagirik, Ala en ambi inim yugogogi ako yi aro. ‘Hat hombawi ako, o ap akwa hunogo enamwa andoma ap huru ovagak nagusim, it enayeloman okbisiluk, anggin-mbanggin enovaga bigik adigat okbugusigik, 400 tahun arisogon o. ");
INSERT INTO nbq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Anderogo ogaruson ovara, it ap akwa hat hombawi en, it enayeloman ogonivusogon ako, anen enowak dilogo anggin-mbanggin okbugu neyalok, nin wisane enamwa akoma en wulu wagu dogomundik, o yoma wakluk, An siyabanunggu dogosogon o,’ yiluk, Ala en Averaham yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yugugu lagagirik, Ala en ‘Wen yi, hat inim, hat vaga wigalek inim, andok dogosogon o’, yiluk, wene avyarat nggatuk erogo Averaham yugogogi ako elup dogopwak yiluk, enagamut mbanggu dogop wene ako yugogogi. Yugogogi vaga Isak at endaklagya lagagimu, nogo 7 yikbaluk, hutun agamut mbanggigi. Andi okbaluk, hivis Isak en Yakup endagya, eke, at Yakup en nit nenombawi 12 ako endaginipu, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nit nenombawi en yugu dugwit, Nenasin en nenaot Yusup adigat sek okbagya yi, Nenanggon o! yiluk, it Mesir menda enayeloman arupwak yiluk, onggo hunggu lagagwama, o Mesir wolok lagagwa. Wolok lagu lagagwama, o andoma Ala inim werekma, ");
INSERT INTO nbq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","anggin-mbanggin higya ako Ala en dek erogo bagagi. Eke, at Yusup ako ap inis ombok o Mesir vagago welagagi Viraon ivaga sek adigat ogarit lagya hegek, Avyak yi, endawi werek atma, yiluk, Viraon adenggen ombarupwak yiluk, Ala en yonggathigya lagagi. Andi halok, at Yusup ako ap Viraon avema o Mesir vagogo welagya, eke, at Viraon awi ombok valek ako suwam welagya, ogagya dogopwak yiluk Viraon en Yusup ako mendok okbagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mendok okbagagi werekma, o Mesir yi awi ndi awi andoma inim, o Kanaan inim, o hivi adigat dugwit wen mbuk agya halok erom uvup en enovalenggen sigam erogo okbigik lagya lagagimu, it ap nenombawi ako en erom belanggugwa menda, mondok dek agya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","at Yakup ako en o Mesir erom gandum werek aruk hunggu lagagirik, at aburi nit nenombawi ako erom hunupwak yiluk o Mesir andoma lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Eke, hivis ndugwis ambi vaga lakbogogi lagu lagagwama, Yusup ako en, Henaot ako an aro, yiluk, owai enelup okbugu lagagimu, at Viraon ako ogo, at Yusup owa-aot yi at inigis, imbitigi. ");
INSERT INTO nbq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Andi ogagu lagagwarik, Yusup en at asin Yakup inim, at aburi ovok dambulik eneyave 75 atma, Woginivi elales o, yiluk, lakbisa lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Lakbisa lagagi ako wagu lagagwarik, at Yakup aburi inim o Mesir at lagagwa andoma dugwit, at inim, at aburi nenombawi inim, hambit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hambit lagagwa ako enowak wolok, o Sikem wagu lagagwarik, ap Sikem menda ambi inis Hemor aburi enadema, Averaham ap hambuguselok wimu mabisalagwima, yoparip vaga onggo bagagirikmu akoma, mabisa wagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Andi okbaluk, Ala en Averaham wene avyarat nggatuk erogo yugogogi ako ogarup hudi horok vanggo yi wagya hegek, nit nenasini ako o Mesir andoma dugwit, eneyave wisane wigalagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wigalarit lagu-sigik, enasin inis ombok Viraon adik ambi Yusup ogagya lagagi ako unggut hegek, o Mesir andoma vagago dogogiluk mondok yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mondok iri lagagirik, nenasini enambutmu inggya dugwit, nadok-hadok oginipu, avyak endaklagu iniselok, hambupwak yiluk, weram mbo bigik ogagu dogop o, yiluk, yugirigya, ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ogarit lagya andi hudi vaga Musa endaklagagi, avyak ako mondok segedok endago hugu lagagwarik, asin amwa hwilago hegek saut henggam okbaluk, ");
INSERT INTO nbq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","weram belagagwarikmu, hwa ndugum Viraon abut ako en heyakbagya lagagirik, An neyak at okhedayogon o, yiluk, amwa ba wagya lagagirik, sawe okhedagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Avyak ako sawe agya dugwit, it Mesir menda enendawi werek dugwit ogagu lagagwa ovok erogo mamulhedagagi atma, ane iri halok iya umbutwi, ogarit lagya halok, Wi, yugwi, ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","At umur 40 tahun ogagya dugwit, ‘Nowa-nasin Iserali menda bigisa layogon o,’ yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","biginisa lagya lagagirik, andoma inim werekma, ap Mesir menda ambi en at Musa it menda ambi we un watya higya lagagirik, avikit agya dugwit, ap Mesir menda ako mondok watigi. ");
INSERT INTO nbq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","At endawi imbitya dugwit, an Viraon inim agirik atma, it Iserali menda en an nowa-nasin enagap wendarupwak yiluk Ala en lakbani wagagi nombarumwi a? imbitigi ovara, anderogo embetetek at welagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nogo ambi yikbaluk, hutun en at aori Iserali menda mberen yawi bagwi il inugu lagagirik, wendarinipu dugwit, ‘Naori o. Hit mberen naswe-haswe at ovara, nano yiluk yawi war-wat yagalagwi o?’ yiluk, yugirigya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","it yawi bagwi ako ambi en at Musa vedalogo baluk, yugugu dugwit, ‘Hat nenaruwam dugwit, nit ogasagwi amburup mbanggya dogop, sa en mondok okbagagamu, yagaliga yi? ");
INSERT INTO nbq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Hat son ap Mesir menda watin ako hak, an narigiluk yagaliga yi?’ ");
INSERT INTO nbq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yugugu ako aruk hunggu lagagirik, o Mesir hekbaluk, o Midiyan hoda winggigi. Hoda wunggu lagagirik, ap huru hak andoma dugwit, aburi mberen endaginipigi. ");
INSERT INTO nbq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Akoma dugwit, 40 tahun at welagagi. Welagagirik, ndugwis ambi vaga harumu ndom Sinai akoma werekma, yo adok werek vaga, hali abya inggya anggelekma Ala yonggo lakbisa wandiga menda malaikat ambi hagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","At Musa en hali abya inggya ako il higya lagagirik, Wi! Nano en ogagya hami? yiluk, bikkagiluk horok ari lagya lagagimu, Nenasin Ala ane iri dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Hat hombawi Averaham inim, Isak inim, Yakup inim, Enasin Ala ako an aro,’ yugugu ako Musa aruk hunggu lagagirik, alon en owak wuruk iri dugwit, il bikaup mbup yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mbup iri lagagimu, Nenasin Ala en, ‘Wen hat agindikmu andenam o mogama atma haropato heda visilogo bain. ");
INSERT INTO nbq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","An naburi o Mesir agarwik ako enarit lagwi nil inugu, yagan warit lagu dugwit enane yugwi ako naruk hunggu, ogasigama, enagap wendarogo bisagiluk wambu wagi o. Hat o Mesir lakbagagyama, elak o,’ yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Wene andi yugirigya lagagirik, Sepanus en adem vagalogo yugirigya dugwit, “It ap Iserali menda en, ‘Nenaruwam dugwit, nit nenawene amburup mbanggya dogop, sa en mondok okbagagas? yiluk, Nenanggon’, yugu lagagwa ako andi, at Musa at. It Iserali enowa enaruwam dugwit, enagap wendarupwak yiluk malaikat en yo adok werek adema yugogogi vaga Ala en lakba wagagi ako andi, at Musa aro. ");
INSERT INTO nbq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","At ako, ninombawi o Mesir akoma en wogonombolok wulu wagya dugwit, o Mesir inim, Is Yanggadek Merah embet vaga inim, o harumu andoma nagu dugwit 40 tahun ogagagi inim, nggarogo ogarubuk menda ogagya, enelup arup enalon werek menda ogagya, ogarit lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","At ‘Henasin Ala en an lakbani wagagi hak, ap navi Ala en yugugu hegek yukheraliga menda ambi, hit menda at, henake henadema lakba warisogon o,’ yiluk, it Iserali menda yugeragagi ako andi, at Musa aro. ");
INSERT INTO nbq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","O harumu it Iserali homarek werekma enanggelekma welagagi inim, ndom Sinai vaga malaikat en wene yugogogi ako inim, nit nenombawi o andoma inim, welagagi ako andi, at Musa aro. Eke, nit yuknirigya dogopwak yiluk Ala wene mondok-mondok dogop wene wegegi ako andi, at Musa adigat. ");
INSERT INTO nbq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Anderogo at ovara, nenombawi ako en, ‘At yukneraliga ako hulup nenanggon,’ yiluk, mbo bagu lagagwarik, eneyami vaga o Mesir laup enendawi wenggelek adigat dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","at Musa ao ndom Sinai vaga andoma inggigi hegek at Harun yugugu dugwit, ‘At o Mesir en woknenombolok waga Musa ako, nggoma laga nininggut atma, nit woknenombolok lagya dogopwak yiluk, nenagavuwak ambi ogovak higitneneran o,’ yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yugugu lagagwama, sapi eyak agur-amolok ogovak higitbaluk, anggom watu dugwit, it ininggi-vaga ogovak higitugwa ako agayuk wutwis, adenggen ogagwi, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ogagu lagagwama, At Ala endawi hologo baluk, mo il inim, saut inim, dadiwap inim, mbogot-vaga menda ovok at, siyabagek ogagu dogopwak yiluk hekbogogi. Andi ogagagwa ako andi, Ala en navi-navi yugirigya hegek yugu dugwit, Hit Iserali menda andi, o harumu wokhenombolok wagya dugwit, 40 tahun ogagya hegek, henanggomi An nake warogo woknogogup, embetep yi! ");
INSERT INTO nbq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Dek ovara, henagavuwak Molok awi valek inim, henomadis Erepan dadiwap agur-amolok ogovak higirik ako inim, Siyabagek wolok nagwis hinigigirikmu, An en wokhenombolok o Mbaben adumu andoma mbo bigiga layogon o, yiluk, yugeragagwa dirup watugwa ako wane-wane at haryogo lakbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ala ninim agarik umbutu dogop Ala awi valupwak yiluk, Ala en, ‘Agut wakhegek hil hegen ako wane-wane valup o’, yiluk, Musa yugogogi ako, wane-wane vabaluk, nenombawi o harumu wolok nagu dugwit, ya vabagek-nda vabagek ogarit nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eke, awi valek ako nit nenombawi hivis andok agu lagagwarik, ap Yosua it inim Ala en ap weram Iserali dek menda haryogo wibigigirikmu yoma sovabigik nunggu wagu dugwit, o valek ako wolok ba nonggagagwa ao werek hegek at Daut inis ombok mondok okbagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Mondok okbagu lagagwama, at Daut ogarit lagya vaga Ala adenggen ovaga bagya lagagi atma, Daut en iri dugwit, ‘Yakup Asin Ala dogopim o valisogon o,’ yiluk, yugogogi ovara, ");
INSERT INTO nbq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","aren vanggitek, Salomo enat Ala awi vanggigi. ");
INSERT INTO nbq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ala awi vanggigi ovara, At Siyalek Dombok Agarik ako, ap akwa enawi valekma agarikbuk o. Ala en yugugu hegek at navi en it yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nenasin Ala en, Mbogot vaga andi, an nane denggalogo yugeraligama aro, Eke, wen vaga andi, navema bisaligama aro. An nawi nggarogonggan valup yiluk yagalagwi? Eke, an nambor sar yangganggya dogop, nggoma o? ");
INSERT INTO nbq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yi menda ndi menda ogovak higirik yi andi, anen adigat ogovak higitigis ako dek? yiluk, yugeragagi ako wane-wane, ap akwa enawi valekma agarikbuk o.” ");
INSERT INTO nbq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Yugirigya lagagirik, Sepanus en it wene amburup mbalisagwi menda ako ambi yugirigya dugwit, “Henendawimbuk henendawi anye dugwit, Ala ane hunggitek hit at. Henombawi Ala ane saganggu lagagwa hak, Averiniki ane sagalisagwi hit aro. ");
INSERT INTO nbq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hit henombawi en it endak Ala yugirigya hegek yugu lagagwa navi-navi ako ambi wiyiknom-weyaknom okbigitek andi sa embetep? Dek o. Iren yugu dugwit, ‘At Endawi Mot Sek Adigat Agarik ako warisogon o,’ yiluk, wene avok vagalogo yugurugu lagagwa ako initu lagagwa. Eke, yogak hirenenat At wagagirikmu onggo mbabaluk watugup! ");
INSERT INTO nbq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ala wene yugup Musa en dirup watigi ako it malaikat enat yukhera wagagwa wogogup ovara, ogagetek agipik hit aro,” yiluk, Sepanus en it wene amburup mbalisagwi menda yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Yugeragagi it wene amburup mbalisagwi menda ako enaruk hunggu lagagwarik, enaninis ane yagan lagu dugwit, enabis mam hambubaluk inigik, ");
INSERT INTO nbq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","at Sepanus ako Averiniki endawima des iri lagagimu, elose mbogot-vaga ilik lagya dugwit, Ala siyalek agarikmu andoma Yesus inim inggis amotkan werek il inigigi. ");
INSERT INTO nbq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Inugu lagagirik, yugirigya dugwit, “Hinil yokanes! Mbogot heyatas anggelekma at mbogot-vaga en ap at endaklarupwak yiluk lakba wambu wagagi ako Ala inggis amotkan agarik higi o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yugirigya lagagimu, it ako en enaruk nggedalhedelok enane ombok erogo yandyak-handyak yagan lagu dugwit, at Sepanus mbikit vagari lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","o kota weram nggigilogo wibaluk, helep vaga watugwa. It enane at ovaga bagagwa ako en sogwes yum weram menda nggolalogo ap sawe ambi inis Saulus adema bagu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","helep vaga watu-sigik, at Sepanus ako en, “Nasin Yesus wai, an nendawi woman o,” ");
INSERT INTO nbq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","yiluk, erambo yunggubaluk ane ombok vaga iri dugwit, “It weyak ogasagwi yi, onggo okbisabuk! Hekbisin o, Nasin!” yiluk, yugugu lagagirik, hombagagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","At Saulus ogo Sepanus wasagwi andi sek imbitigi. At Sepanus ako watu lagagwama, it ap Ala enalon ombasagwi menda en Sepanus warek wolok hambuguselok, bisa lendagwima ba lagu lagagwarik, abwa en, ayup ombok erogo yagagwa. Eke, at watugwa andi hudi vaga, it Ala aburi o Yerusalem welagagwa ako, inurusogon yiluk, iya erogo anggin-mbanggin ogonivit nagu lagagwama, it ovok o Yudeya Samariya avilis ambot andoma hoda sak yagan lagagwa ovara, it lakbogogi ako andi hoda winggitek at enamwa mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ayup yagu-sigik ovara, at Saulus en andi, it Ala aburi ako ap inim akwa inim dek erogo bigik lagya dugwit, o ambima nunggwigya, nggigilogo wibisa wagya, ambima nunggwigya, nggigilogo wibisa wagya, ogarit wogonombolok heda marogo lembaga mabiselagwima akoma bisa lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","It Ala aburi hoda sak yagan lagagwa ako en, yi awi ndi awi sek wene yugeregek nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Eke at Pilipus ako o Samariya kota ambima lagya lagagirik, Ala en denogo bagagi Keretus avok it ap akwa andoma menda vagalogo yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yugirigyama, ap akwa wisane homagu lagagwarik, Pilipus en yugirigya ako enaruk hunggwis, enelup arup enalon werek menda ogagya ako inil hugwi, ogagu lagagwarik, wene yugeragagi ako enendawi sek erogo dibagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","It madis agoda werek menda enendawima nonggagagi ako, na hunik yugusigik nggigilogo wibugu, ininggis-inisok yidugup menda inim, enerambo weyak inim sek okbugu, ogagya halok, ");
INSERT INTO nbq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","it o kota andoma menda enendawi adenggen wisane agagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Eke, o kota andoma ap ambi inis Simon, o endak en madis inis vaga oginivit lagya halok, it Samariya menda ako en, “Ap ogasiga yi, wi!” yiluk, vok yugu lagagwa. “An nadigat iya,” yiluk, okhidigya halok, ");
INSERT INTO nbq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","it ap akwa ovok ininis werek ininis dek iren at ogagya dibaluk yugu dugwit, “At Ala Anye Wisane Agarik yagalagwi ako andi ap yi atma, wi!” yiluk, vok yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","O muk en madis inis vaga oginivit lagya halok, vok yugu dugwit at ane adigat hunggu lagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","at Pilipus ako en Nenowa Inis Ombok Ala en denogo bagagi ako avema bisaup sek wene ako inim, Yesus Keretus wene inim, yugeragagi ako enendawi avyarat umbutu lagagwama, ap inim, akwa inim ima wombabigigi. ");
INSERT INTO nbq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","At Simon ogo endawi avyarat imbitigi halok, ima wombabagya lagagimu, at Pilipus inim lagya dugwit, Pilipus en enelup arup enalon werek menda ogagya, nggarogo ogarubuk menda ogagya, ogarit lagya il higya lagagirik, “Wi!” yiluk, vok yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eke, “It Samariya menda en Ala wene avyarat ombakluk wagao o,” yiluk, yugwi ako, it lakbogogi menda o Yerusalem agarwik ako enaruk hunggu lagagwarik, Peterus Yohanes it mberen enadema lakbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lakbogogwa ako lagu lagagwarik, it ap akwa Samariya menda ako Averiniki wapwak yiluk, enake samban ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","It ako Nenasin Yesus inis vaga adigat ima wombabogogwa ovara, Averiniki ao enovaga wombabisa wagetekma, ");
INSERT INTO nbq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","inunggul ininggis vakbugu-sigik Averiniki wogeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","It lakbogogi en ap akwa ininggul ininggis vakbugu-sigik Averiniki wogorigya, at Simon ako inugu lagagirik, onggo yoparip wogeraup ogagya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ninggis inunggul vakbisiluk Averiniki wogorigya dogogiluk, an hit ogasagwi anderogo wane-wane ogagya dogoik en henawene andi, an ambi yukneres o,” yiluk, nggino yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nggino yugirigya lagagimu, Peterus ako en at yugugu dugwit, “Ala en onggo dek un wokneraliga menda hegek, hayoparip vaga onggo baup, yiluk, hat yagaliga yi? Hayoparip andi, hedelok hali hunikmu lagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ala en hendawi eve sek dek heyagas atma, wene yi menda ambi hat andok arisogon mondok dek aro. ");
INSERT INTO nbq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hat weyak ogarup embeten andi mbo baluk, hendawi embeten Hasin Ala en dek erogo bagapwak yiluk yuguru. ");
INSERT INTO nbq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Homaluk hova durik-marek werek hegek, wam amumudi eda ovagak hane weyak iri heyagi o.” ");
INSERT INTO nbq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Yiluk, mberugu lagagimu, at Simon en, “Ai! Hit yegep ako an oknitya hawen, Henasin Ala yugugu dogones o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","It Peterus Yohanes ako en, Nenowa Inis Ombok Ala en denogo bagagi Yesus ako vagalogo yugurugwi, Ala wene yugurugwi, ogagu lagagwarik, enamwa Yerusalem eneyami vaga wagu dugwit, o Samariya o asoragoma wisane akoma sek wene yugeregek ya nonggegek nda nonggegek wagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yugeregek wagusim, Nenasin Ala yonggo lakbisa wandiga menda malaikat ambi en at Pilipus ako yugugu dugwit, “Sup o Yerusalem en o Nggasa lendagwima o selatan vikit, ap akwa dekma andoma elak,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Andi yugugu lagagimu, lagyama, ap pegawai ambi owadi wogo Etiyopiya menda inim avuk agagi. O negara Etiopiya akoma it ovok inisa inis ombok inis Handake avema welagagwa, eke, ap ako hwa Handake ayoparip vagago welagagi. At o Yerusalem Ala siyaba wagya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","andi okbaluk amwa eyami vaga wunggu lagagimu, kuda kereta vaga horaik dugwit, mbuku navi Yesaya en dirup watigi ako dombalit lagyama, Pilipus inim avuk agagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Avuk agya lagagimu, Averiniki ako en Pilipus yugugu dugwit, Kuda kereta andi adema lagya dogomindik hinim elak. ");
INSERT INTO nbq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Yugugu lagagimu, Pilipus ako en at adema vupuk lagya lagagimu, navi Yesaya dirup watigi ako dombanggu dugwit iris aruk hunggu lagagirik, “Nasin wai. Hat mbuku warek dombalit lagya yi, dibaliga a, dek a?” ");
INSERT INTO nbq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yugugu lagagimu, “Ap en sek erogo mamulurugwi iselok adigat dibelagwi atma an nadik nggarogonggan dibaup. Dek atma, yuknirinok yiluk nadema horayi dagama o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Dirup warek dombanggigi ako eyave yi aro: ‘Ndomba waruguluk wolok lagu-sigik, mbup erek agarik hak, Eke ndomba eyak iris mbanggusigik, Ane dek mbauk agarik andi hak, At ane dek mbauk at welagagi o. At anggadi warogo bagu dugwit, ogaga wane-wane okbagetek enane yimbu-dambuk erogo wolok lagagwa. Eke at vaga wigalek ako dek atma, at awene mbanggitek aro. Ap akwa agarwikmu o wen vaga yoma eloke dek at aga o,’ yiluk dirup warek ako mamungguma, horayi inggigi. ");
INSERT INTO nbq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Inggya lagagimu ap ako en Pilipus yugugu dugwit, “Ala en yugugu hegek navi yugirigya ako en yagagi yi, aren ogagagirikmu yagaliga a, ata ap adik en ogagagirikmu yagaliga a? Iru o,” ");
INSERT INTO nbq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","yiluk, yugugu lagagimu, at Pilipus en “Yukirisogon o,” yugugu lagagirik, wene dirup warek andi vaga At Yesus avok sek wene ako mbilinogo yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Yugurit it mberen sup vaga lagu dugwit, inamut yanggadekma ari lagu lagagwarik, ap ako en, “Inamut yi hil yokanen! An ima wombabanup meyan embeten a?” ");
INSERT INTO nbq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Yugugu lagagimu, Pilipus en, “Hat hendawi nggatuk erogo Yesus avyarat embeten halok ima wombabagaup sek aro.” Yugugu lagagimu, at ap Etiyopiya menda ako en, “Yesus Keretus andi Ala abut avyarat ombasiga o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yugugu lagagirik, kuda ako mbup yupwak yiluk yogogogi, mbup iri lagagimu, it mberen ima nunggugu lagagwarik, Pilipus en ap ako ima wombabagagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wombabagya lagagirik, wulu wagyama, at Pilipus ako Averiniki en supuk erogo wolok wunggu lagagimu, ap ako en Pilipus ako ambi inim il hegetek ovara, endawi adenggen embetek amwa lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Eke, at Pilipus ako o Asotus akoma sigam ari lagya lagagirik, yi awi ndi awi o kota dombok andoma sek wene yugeregek o Kaisareya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Andi ogagya hegek, at Saulus en it Nenasin Yesus ane wogogwa menda ako enarigiluk aninis ane yagan lagya lagagimu, at imam inis ombok winimen agarik ako adema lagya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","yugugu dugwit, “Nasin wai. O kota Ndamasik it Yakuri samban ogasagwima enasini en inil hapwak yiluk, haren it ap akwa Yesus ane musek laguselok, vagogo heda magenombolok Yerusalem warigiluk, dirup ambi mbaniru o.” ");
INSERT INTO nbq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yugogogi ako, wogugu lagagimu, lagya lagagirik, o kota Ndamasik vanggo yi lagya lagagimu, supuk erogo mbogot-vaga en abya yovalogo at adema wombaba wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wombaba wagya lagagimu, at Saulus ako wema ndun yi wambigya hegek, ane ambi yugugu dugwit, “Saulus wai, Saulus wai. Hat nggarogo yiluk anggin-mbanggin erogo narit landiga?” Yugugu ako aruk hunggu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Ai, Nasin, hat sa o?” Yugugu lagagimu, “Dek o. Hat anggin-mbanggin erogo narit landiga ako an Yesus aro. ");
INSERT INTO nbq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","An atma, hat mondok iri dogomindik o kota ombokma andoma lagya heyalok ogarup wene yukhirisogonma, andoma elak o,” yiluk yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","At aswei inim lagagwa ako en ap eyave hegetek ovara, un ane iris adigat hunggu lagagwarik, enane dek mbuperek welagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","at Saulus ako mondok iri lagagirik, il venggenek ovara, yi menda ndi menda il haup meyan atma inggis vagakluk wolok o kota Ndamasik balagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Balagagwa akoma dugwit, il mbuk agagi hegek, erom inim, is inim, nenggetek we un at nogo henggam yigigi. ");
INSERT INTO nbq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","O kota Ndamasik andoma ap Yesus ane wogogi menda ambi inis Ananiyas. At ako en abi higya dugwit, At Nenasin Yesus en, “Ananiyas wai.” Yugugu lagagimu Ananiyas en “Yukniru o, Nasin.” ");
INSERT INTO nbq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yugugu lagagimu, At Nenasin ako en at yugugu dugwit, “Mondok yiluk, sup inis Mot-Mot yagalagwima ap Yudas amwa andoma ap ambi inis Saulus awi Tarusus menda belalit elak. Aren samban ogagyama, ");
INSERT INTO nbq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","hat Ananiyas en at adema nunggigya dogomindik, unggul hinggis vakbaluk, il mbuk aga ako sek ogagya abi vaga higyama, andoma elak o.” ");
INSERT INTO nbq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yugugu lagagimu, at Ananiyas ako en, “Nasin. At ap ako o Yerusalem hat haburi adik denek weyak ogonavit lagya yugwi ako an naruk hunggwis. ");
INSERT INTO nbq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Eke, yogak it hinis vaga samban ogasagwi menda ovok erogo vaginivit laik o, yiluk, it imam-imam enasini yugirigya lagama, E o, yagaorikmu, waga o.” ");
INSERT INTO nbq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yugogogi ovara, Nenasin en at Ananiyas yugugu dugwit, “Elak! Ap andi it weram Yakuri dek menda inim, it enasini ap ombok ininis werek menda inim, it Iserali ovok erogo inim, An ninis enelup erogo yugirigya dogopwak yiluk, nayeloman denogo bagirikmu, yugirilak. ");
INSERT INTO nbq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eke, at Saulus ako, an navikit agyama, anggin-mbanggin okbagu dogop ako anen yugugu dogosogon o,” yiluk, abi vaga yugugu hagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yugugu higya lagagimu, o andoma lagagi. Lagya lagagirik, ap ako amwa nunggigya lagagirik, inggis Saulus unggul vakbaluk, yugugu dugwit, “Naswe Saulus wai. Hat hil sek agya, Averiniki hendawima des yi nunggwigya, ogagya hanok yiluk, hat sup vaga yoma wagyama At Nenasin Yesus hegen ako en, lakbani waga o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ao yugugu hegek, il agut agagi lobalek ako bonggo erogo wambigya dugwit, il sek agagi. Il sek agya lagagirik, mondok iri lagagimu, ima wombabagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ima wombabagya lagagimu, erom ninggya lagagirik anye agagi. Saulus ako it Yesus ane wogogwa menda o Ndamasik welagagwa ako ndugwis maren hudi inim welagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Inim dugwit ‘Yesus andi Ala abut aro,’ yiluk, it ap Yakuri samban ogasagwima wene ako yugeregek lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yugeragagi enaruk hunggugwarikmu, it ovok erogo “Wi,” yiluk vok yugu dugwit, “Avyak! O Yerusalem it Yesus inis vaga samban ogasagwi menda ovok enarit lagya laga andi, yogak o yoma it anderogo menda hawen, heda maginiviluk it ap imam-imam enasini enadema bisa lagiluk waga ako en yagaliga yi dek a?” yiluk, yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Anderogo at yugu lagagwa ovara, at Saulus ako en, wene yugirigya dugwit, ‘Yesus andi Nenowa Inis Ombok Ala en denogo bagagi Keretus aro’, yiluk, avyarat ombarupwak yiluk, ‘Anderogo ogagya lagagi o,’ yiluk, yagan lagya ako adigat mbigalit lagu dugwit, it Yakuri menda o Ndamasik welagagwa ako enane nggarogo yubuk erogo okbogogi. ");
INSERT INTO nbq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Andi halok, hivis it Yakuri menda en, ‘Saulus warusogon o,’ yiluk, hologo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Hologo bagagwa ako at Saulus aruk hobaluk werekma, ndugwis ambi vaga waruguluk, o kota nunggwisagwima o hup dingga hanjalek welagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Welagagwa ovara, at Saulus aori en o hup mburin yum yugup vaga yedogo baluk, heda yidilogo leget ovasugorok weram wibagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wibagu lagagwama, o Yerusalem lagya lagagirik, it Yesus ane wogogwa menda ako inim dambuligiluk ogagagi ovara, it ovok en at Yesus ane waliga menda dek atma yiluk, enalon en, ‘Oma,’ yugigitek mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mbup yugu lagagwama, at Mbarenabas ako en wolok it lakbogogi ako enadema lagya lagagirik, at Saulus sup vaga lagya dugwit, Nenasin Yesus il hagagi wene inim, At Nenasin en yugogogi wene inim, eke, Ndamasik andoma alon dek dugwit Yesus inis vaga yugirigya lagagi wene inim, mbilinogo yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yugirigya lagagimu at inim dambulik dugwit, at mondok alon dek, Nenasin Yesus inis vaga o Yerusalem wene vagalogo yugeregek lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yugeregek lagya dugwit, it ap Yakuri menda ovara, Yunani enane yagalagwi menda ako inim enane yugu dugwit, wene onggo-onggo yugu-selok, it ako en at warup umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","‘Warusogon o,’ yugwi ako, it nenaswei Ala aburi enaruk hunggu lagagwarik, Saulus wolok, Kaisareya lakluk, andoma en o Tarusus lakbagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Lakbagu lagagwarik, it Ala aburi o Yudeya menda inim, o Nggalileya menda inim, o Samariya menda inim, nadok-kadok ogonivit lagatek iniselok, enendawi ugun dugwit, enendawi hoda agwi, Averiniki en yonggarinipu hegek Enasin Yesus enalon umbutu dugwit, eneyave wisane wigalagwi, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Wigalagu-sigik, at Peterus ako yi awi ndi awi andoma yogonigik lagya dugwit, Ala aburi adik denek o Lida agarwik ako bigisa lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Bigisa lagya lagagirik, andoma dugwit, ap ambi inis Eneas inggis-isok yidugup menda nggilik hegek 8 tahun ogagagi werekma, il hagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Higya lagagirik, Peterus en at yugugu dugwit, “Eneas wai. Yesus Keretus en sek okhetarikmu, mondok iri dogomindik, ndalek nogo yiliga menda andi yunggul hedoman o,” yiluk, ao yugugu hegek, mondok yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","At mondok yagagi ako, it o Lida menda inim, o Saron menda inim, ovok erogo inil hugu lagagwarik, it weyak ogagu lagagwa mbo baluk, Nenasin Yesus ane wogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Eke, hwa Yesus ane wogogi ambi inis Tabita o Yope welagagi. (Hwa inis andi Yunani enane vaga, Ndorokas.) At hwa ako ap akwa sek adigat ogarit lagya, ininggis dek iniselok yonggarinipu, ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ogagya werekma, eyave aup edup agya lagagirik hombagagi. Hambigya lagagimu, nggamo warogo handimen kamar ogorekma hombalogo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","O Lida en Yope horok atma, “Peterus waga o Lida agarik,” yiluk, yugwi it Yesus ane wogogwa enaruk hunggu lagagwarik, at ako hodorogo warupwak yiluk ap mberen yonggo lakbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Lakbogogwa yugiri lagu lagagwama, at Peterus inim wagu lagagwarik, wolok handimen kamar ogorek ap nggorakma akoma unggugwa. Akoma it akwa sogwa ako en, “Hwa yi, ninim dugwit, yum ilim inim, weram inim manggatu laga yi hil o,” yiluk likugu dugwit, yup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Yup yagusim Peterus en, “Hit ovok erogo wilitales,” yugirigya lagagirik, erambo yunggubaluk, samban ogagagi. Samban okbaluk, at hombagagi ako avikit bikhigya dugwit, “Tabita wai. Mondok iru,” yugugu lagagimu, il huvunik ako venggenogo Peterus il higya lagagirik, nggilik ako mondok yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Mondok iri lagagimu, at Peterus ako en inggis vagogo mondok okbagya lagagirik, it akwa sogwa ako inim, it avyarat umbutugwa ako inim, “Omanes,” yugeragagi wagu lagagwama, “Iluk aga yi, bikkanes,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","At Peterus hwa iluk erogo mendok okbagagi wene o Yope andoma ovok erogo wigalarit lagya lagagimu, ap akwa wisane enendawi Nenasin Yesus ovaga vanggabaluk avyarat umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Eke, at Peterus ako, o Yope andoma ap sapi agamut bunggulik sek ogagya lagagi menda inis Simon inim dugwit, ndugwis wisane welagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","O Kaisareya ap enayegen werek menda ambi homago “Italiya menda,” yugu lagagwa enasin inis Korenelius o andoma welagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","At ap ako aburi inim it weram Yakuri dek menda ovara ovok erogo Ala enalon umbutu dugwit, Ala wene Musa inim, it navi-navi inim dirup watugwa ako dibaluk ogagu lagagwa. Aren it Yakuri menda wisane erogo enangge dek halok, yonggarinipu, samban adigat ogagya, ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ndugwis ambi vaga o howam mo il yam 3 ari wagya hegek, nogo heda abi vaga sigam hagagi. Higya dugwit, Ala yonggo lakbisa wandiga menda malaikat ambi at adema wagya lagagirik, yugugu dugwit, “Korenelius wai.” ");
INSERT INTO nbq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Yugugu lagagimu, at Korenelius anggela wunggu lagagirik, alon en il vurek yugugu dugwit, “Nasin. Nggarogo yiluk wagen?” Yugugu lagagimu, at malaikat en “Dek o. Ap akwa ininggidek halok yonggarinipu, samban ogagya, ogasiga ako vaga At Ala il heyakbagagirikmu, endawi hovaga wenggelek agarik. ");
INSERT INTO nbq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","Hovaga wenggelek werekma, yogak ap ambi inis Simon, inis ambi Peterus yagalagwi ako, ap ambi adik inis Simon sapi agamut bunggulogo sek ogasiga menda awi inamut yanggadek amban vaga valekma, it mberen andoma werekma, warupwak yiluk, harwi yonggo o Yope lakbisin,” yiluk, abi vaga yugugu hagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","At malaikat wene yugogogi ako lagya hegek, at Korenelius ayeloman mberen inim, at aot yegen werek menda Ala wene dibaluk ogasiga ambi inim, “Warupwak o,” yiluk, yanggup yugeragagi wagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","abi vaga yugogogi wene ovok mbilinogo yugirigya lagagirik, yonggo o Yope lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lakbogogi ako, nogo yiluk suvaga o Yope horok vanggo yi lagu-sigik, at Peterus ako, o dingga mo il yam 12 vaga samban ogarigiluk, o helep vaga valek viril vaga andoma inggigi. ");
INSERT INTO nbq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Andoma inggya lagagirik samban ogagya dugwit, erom uvup agya lagagimu, “Nano nami?” imbitya lagagirik, erom isagu-sigik, nogo heda abi vaga hagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","12","Abi higyaim, mbogot heyakbaluk yum obak atok venak-venak vakbagu lagagwarik, swa-bagas inim, ndimbu-nggusa inim, mindom-mbolom inim, ovok erogo yum ndalek vaga bagao ako wen vaga wombaba wagya hagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Higyama, ane ambi at yugugu dugwit, “Peterus wai. Mondok yiluk, yi ambi warogo namin,” yiluk, yugugu aruk hunggigi. ");
INSERT INTO nbq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Aruk hunggu lagagirik, “A, Nasin. Nelagwidek menda inim, naup moga yugup hegek inim, an mondok naligadekma naup nanggon.” ");
INSERT INTO nbq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yugugu lagagimu, ambi inim at yugugu dugwit, “Dek o. At Ala en we ugun nunggu dogop bagagi hegek, haren ‘Naup moga’ yubuk,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","abi henggam vaga higya lagagirik, yum obak ako mbikit mbogot-vaga wolok inggya hagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","At Peterus ako, ‘Nabi higi yi, eyave nggarogonggan higi,’ yiluk, endawi ao wenggengguma it Korenelius lakbisa wagagi ako “Simon awi ngga agarik?” yiluk, hemerinivit sup mbanggut vaga ari wagu lagagwarik, enane ombok vaga yugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","“Ap yoma, wai. Ap huru Simon inis Peterus yagalagwi ako, o yoma werek a dek a?” ");
INSERT INTO nbq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Yiluk, yugu-sigik, at Peterus ako en, “Nabi andi nggarogo higi o?” yiluk, endawi ao wenggengguma, Averiniki en at yugugu dugwit, “Simon wai, ap henggam belalhetek wagao wasim agarwik atma, ");
INSERT INTO nbq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","hat mondok yiluk wambigya dogomindik, ap andi anen at lakbisa wagima, it weram Yakuri dek menda ovara, hendawi yunggup yegetek hinim elalo.” ");
INSERT INTO nbq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yugugu lagagimu, it enadema wambigya lagagirik, yugirigya dugwit, “Belalnetek wagep ako an atma, nggarogo ogarup yiluk, nadema wagep?” ");
INSERT INTO nbq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yugirigya lagagimu, it ako en “Dek o. Ap yegen werek menda enasin Korenelius en, lakbinina waga o. At ako endawi mot Ala alon ombasiga halok, it Yakuri menda ovok erogo at andogon sek yugwi atma, Ala ayonggo malaikat adik denek menda ambi wagya lagarik, at Korenelius ako yugugu dugwit, ‘Peterus en wene yukhiri warupwak yiluk yonggo lakbisin o,’ yiluk, yugigas. Yugugu lagama yonggo lakbinina wagarikmu belalhetek wendagwi o,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yugugu lagagwama, “Andi halok nunggumanes,” yugirigya lagagimu nunggugu lagagwarik, inim nogo yogogwa. Nogo yiluk, iluk agya lagagirik, Peterus it wagagwa ako inim at aswei Yope menda nin maren inim lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lagu dugwit, suvaga nogo ambi yiluk o Kaisareya nonggagagwa. At Korenelius ako at owa-aot inim, aswei inim, it wagusawen, homakbaluk inil werekma ");
INSERT INTO nbq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peterus o mbumbumu nunggu wagya lagagimu, at Korenelius ako en at adema lagya lagagirik, agayuk wutu dugwit, avema seve yi lagya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","at Peterus ako en “An ogo un ap atma, mondok iru,” yiluk, inggis vagogo mondok okbagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mondok okbigya lagagirik, it mberen wene mbanggwis umwa nunggugu lagagwarik, at Peterus ako ap akwa wisane homago inugu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","yugirigya dugwit, “Nit Yakuri hit weram Yakuri dek menda ako ninim dambunggwis, bikhinisa wagwi, ogarup moga yagalagwi ako henelup ovara, Ala en ‘“It ap akwa weram menda andi, inim avuk arubuk,” yup andi moga,’ yiluk, yuknigarikmu, ");
INSERT INTO nbq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","an belalnetek wagep ako nanggon yegetek, mbikit at wagi. Nggarogo yiluk, belalnetek wagep?” ");
INSERT INTO nbq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Yugugu lagagimu, at Korenelius ako en “Dek o. O inikak howam mo il yam 3 yerogo vaga wane-wane an namwa samban ogagya lagima, nabi higya lagi ako yukhirisogon o. Nabi higya neyagek mbikit supuk erogo ap ambi yum mudu abya amumulip abigal werek an nadema mondok yi wagya lagarik, yuknugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Korenelius wai. Hat samban ogagen ako Ala aruk hunggu, eke, ap akwa ininggidek menda yonggarinipu lagen ako Ala il heyakbagagya, ogagya lagarikmu, ");
INSERT INTO nbq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ap Simon inis ambi Peterus ako o Yope werekma, warupwak yiluk, yonggo lakbisin o. At ako ap Simon ap sapi agamut bunggulik sek ogasiga menda awi inamut yanggadek omban vaga valekma, inim andoma agarik o,’ yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","yuknugu lagama, mbikit yonggo lakbigis yukhiri lagu lagaoma, neya wagenma, naswe wa. Neya wagenma, yogak Hasin Ala en, ‘Anderogo yugerano’ yukhigas ako ovok yukneranok yiluk, Ala ivaga homagyo o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Yugugu lagagimu, at Peterus ako en yugirigya dugwit, “Naswei o, At Ala en, ap ambi anggon, eke, ap ambi endawi hunik ombasigadek, andi avyarat imbiti o. ");
INSERT INTO nbq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nit yi ap akwa ndi ap akwa ovok en at vaga nenalon umbutu dugwit, sek adigat ogagu niniselok, At Ala endawi hunik ninombarisiga. ");
INSERT INTO nbq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yi ap akwa ndi ap akwa ovok Nenasin ako andi, Yesus Keretus ako, At vaga Ala ninim dambulogo bininaliga o, yiluk, sek wene ako nit Iserali menda nenelup arupwak yiluk, lakba wagagi ako henelup aro. ");
INSERT INTO nbq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","At Yohanes ima wombabisaup wene yugeregek lagya lagagimu, o Nggalileya en Yudeya yi awi ndi awi ovok oklagagi ako ogo henelup aro. ");
INSERT INTO nbq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","At Ala en Yesus Nasaret menda Averiniki ovaga wombaba wagya dugwit, denogo bugu, anye wogugu, ogagya lagagirik, Ala inim atma, sek ogarit lagya, it madis sile ap akwa enendawima dugwit, molok-molok okbisilin landiga menda ako haryogo wibisa wagya, ogarit lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Eke, it ap akwa Yakuri enamwa andoma inim, o Yerusalem inim, ogonavit lagya lagagi ako ovok at ninil helok, yukherelagwi o. At Yesus ako yo winik vaga lobalogo watugwa hombagagi ovara, ");
INSERT INTO nbq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","nogo mberen yikbaluk, hutun, Ala en iluk erogo mendok okbagagi ako eyave ninil hapwak yiluk inuk neragagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","It ap akwa ugun inil hapwak yiluk, inuk eregetek. Ata, at iluk akluk mondok iri lagagirik, nit endak denogo bininggigi ako ninim erom nunggwi, is nunggwi, ogagagup ako adigat ninil helok yugurugu dogosogon yiluk, inuk neragagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iluk agya lagagimu, ‘It iniluk agarwik inim, hombagagwa inim, enowak dilinivup Ala en denogo mondok okbagagi ako andi Yesus aro, yiluk, des erogo vagalogo yugeregek nagu dogones o,' yukneragagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","It ap navi-navi Ala en yugirigya hegek yugu lagagwa ako ovok erogo at avok adigat vaganggu dugwit, ‘Henendawi at ovaga vanggabaluk avyarat umbutu hiniselok, At Yesus anye vaga henomaluk dek erogo bigigayogon o,’ yiluk, yugurugu lagagwa o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","At Peterus ao anderogo yugirigya hegek, it wene hunggugwarikmu ako ovok erogo Averiniki enovaga agagi. ");
INSERT INTO nbq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Averiniki enovaga agya lagagimu, it ap enagamut mbalek avyarat umbutugwa menda Peterus inim lagagwa ako en, it ap akwa enane unggut adik-adik menda yugwi, Ala inis siyabagwi, ogagagwa ako enaruk hobaluk, it ap weram Yakuri dek menda hegek, Ala en it ogo Averiniki wane-wane wogeraga yiluk, “Wi,” yiluk, vok yagagwa. Vok yugu lagagwarik, at Peterus ako en it yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ala en Averiniki nit wokneragagi hak it wogeragarikmu, ima wombabisaup andi, moga embetep? ");
INSERT INTO nbq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dek o. Yesus Keretus inis vaga ima wombabisenes,” yiluk, yugirigya lagagimu, “Ninim ambukum dogomundik lanok o,” yiluk, Peterus yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","It lakbogogi inim, enaswei o Yudeya andoma menda inim, iren ap weram Yakuri dek menda ogo Ala wene welagwi enaruk hunggugwarikmu, ");
INSERT INTO nbq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","at Peterus o Yerusalem inggya lagagimu, it enagamut mbalek menda nin en at Peterus enane weyak yugugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Hat nggarogo yiluk it enagamut mbalek dek menda enamwa isa nunggwigya lagindik, hinim dambulik erom nenggen?” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Enane weyak yugugu lagagwama, at Peterus ako en wene eyave adem oklagagi ako ovok des erogo mbilinogo yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Dek o, nasini. An o kota Yope akoma samban ogagya lagima, nogo heda nabi vaga higya dugwit, yum obak atok venak-venak vakbaluk mbogot-vaga en nadema wombaba wagya nil higi. ");
INSERT INTO nbq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nil higya lagirik, swa-bagas inim, ndimbu-nggusa inim, mindom-mbolom inim, ovok erogo yidik higi. ");
INSERT INTO nbq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Higya lagima, ane yuknugu dugwit, ‘Peterus wai. Mondok iri dogomindik, yi ambi warogo namin,’ yuknugu naruk hunggis.” ");
INSERT INTO nbq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Yuknugu naruk hunggis ovara, ‘A, dek o, Nasin. Nelagwi dek menda inim, naup moga yugup hegek inim, an mondok naligadekma, naup nanggon o,’ yugugu lagima, ");
INSERT INTO nbq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","mbogot-vaga en ane ambi inim yuknugu dugwit, ‘Dek o. At Ala en we ugun nunggu dogop bagagi hegek, haren “Naup moga” yubuk,’ yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Abi henggam vaga higya lagirik, yum obak ako mbogot-vaga wolok inggya higi.” ");
INSERT INTO nbq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Wolok inggya higya lagirik, an umwa andoma werekma ap henggam o Kaisareya en an belalnetek lakbisa waga wasim ari wagao inigik, ");
INSERT INTO nbq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Averiniki en an yuknugu dugwit, ‘Hendawi yunggup yegetek, ap andi hinim at elalo,’ yuknugu lagama, naswei eneyave 6 yi, ninim lagu lagurik, ap Korenelius amwa nunggwigyo. ");
INSERT INTO nbq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nunggugu lagyoma, at Korenelius ako en wene mbilinogo yuknirigya dugwit, ‘Malaikat ambi an namwa nonggagagi mendek werekma nil higya lagima, yuknugu dugwit, “Ap Simon inis ambi salek Peterus ako warupwak yiluk belalit o Yope lakbisin. Lakbisamima yugiri lagu iniselok, wagya dogomindik, ");
INSERT INTO nbq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","hat haburi hinim henagap wendarupwak yiluk, wene yukhera wasogon o,” ’ yiluk, malaikat en yugigas wene ako Korenelius en an yuknigas.” ");
INSERT INTO nbq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Yuknugu lagama, an it yugeragiluk ogagya neyagek, endak Averiniki nenovaga wombabinina wagagi hak, it ogo enovaga wombabisa waga. ");
INSERT INTO nbq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wombabisa wagya lagama, Nenasin Yesus en iri dugwit, ‘At Yohanes ima wombabugu lagagi ovara, hivis anen Averiniki henovaga wombabigiga wasogon,’ yagagi wene ako at, nendawi wenggelaga o. ");
INSERT INTO nbq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Anderogo atma, nenendawi Nenasin Yesus Keretus ovaga vanggabaluk avyarat umbutu lagagupmu, Averiniki we un at wokneragagi hak, it weram Yakuri dek menda ako wogeragarikmu, Ala en ogarup imbitirikmu, an ogarubuk yup meyan atma, mbup yigi o,” yiluk, Peterus en enagamut mbalek menda yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Yugirigya ako enaruk hobaluk, it ogo enane dek mbup yagagwa. Mbup yugu lagagwarik, “Andi halok, Ala en it weram Yakuri dek menda ako ogo, it weyak ogwasagwi menda enendawi wenggelogo mbo baluk Yesus ambetaga lagu-selok, mondok iniluk dogop hologo bogogi higyo o,” yiluk, Ala siyabagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","At Sepanus helep vaga watu lagagwarik, it nin inurusogon yiluk anggin-mbanggin ogonivit lagu lagagwama, enugut en hoda sak yagan wunggu lagagwarik, o adumu andoma yanonggegek yagan lagu dugwit, o Venisiya inim, Sipurus inim, Andiyokiya inim, it Yakuri menda adigat wene enaruk hulupwak yiluk, yugeregek nagu lagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","it nin o Sipurus menda inim, o Kirene menda inim, o Andiyokiya nunggugu lagagwarik, it ap akwa Yunani menda ako inim enaruk hulupwak yiluk, Nenasin Yesus sek wene ako yugurugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nenasin Ala anye okbugu hegek yugurugu lagagwama, ap akwa wisane enendawi hobaluk, avyarat umbutu lagagwarik, Nenasin Yesus ane wugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","It Ala aburi o Yerusalem homago ako en wene it Yunani menda o Andiyokiya avyarat umbutu lagagwa ako enaruk hunggu lagagwarik, at Mbarenabas o Andiyokiya lakbagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","At Mbarenabas ako endawi sek, Yesus ovaga vanggabaluk mondok avyarat imbitigi vaga Averiniki endawima des yagagi atma lakbagagwa. Lakbagagwa lagya lagagirik, At Ala enabwa en okbugu ako il higya lagagirik, endawi adenggen wisane akluk, “Hit henendawi mondok wadok dek dugwit, Nenowa inis ombok Yesus ovaga vanggabaluk dogones o,” yiluk, enendawi aik wakbugu lagagi. Enendawi aik wakbugwiam, ambi labok nonggegek adigat ogagu dugwit, Ala aburi wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Eke, hivis, at Mbarenabas ako en Saulus belaligiluk o Tarusus lagya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","havedogo o Andiyokiya wolok wagagi. Wolok wagya lagagirik, it mberen tahun ambiat ogagu dugwit, Ala aburi inim homagwi, ap akwa wisane wene mamulirugwi, ogagagwa. It Yesus ane welagwi menda ako, ‘Avakwa Kerisen menda’ yagalagwi ako andi, endak o Andiyokiya enat yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Andoma mamulirugu-sigik, it navi Ala en yugirigya hegek yugerelagwi menda nin o Yerusalem en o Andiyokiya unggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","It unggugwa ako ap ambi inis Agabus mendek iri lagagirik, yugirigya dugwit, “It ap yi awi ndi awi o Oroma avema agarwik menda ovok erogo erom uvup wisane arisogon o,” yiluk, Averiniki en endawi hologo yugugu hegek, yugeragagi. (Andi arisogon yugeragagi ako andi, at Kaisar Kolaudiyus inis ombok dugwit wene denggalogo yugirigya hegek, atma agagi.) ");
INSERT INTO nbq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yugeragagi ako erom uvup agya lagagimu, it Yesus ane wogogwa menda o Andiyokiya ako en enendawi hologo bugugu dugwit, “Nit nenadik ninangge agarik bikegek, wonggabaluk, nenaswei Ala aburi o Yudeya agarwik ako enake lakbisasogon o,” ");
INSERT INTO nbq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","yiluk, wonggalogo baluk, Mbarenabas Saulus inim lakbugu lagagwama, iren wolok, Ala aburi enasini o Yerusalem ako wogora lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wogora wagu lagagwarik akoma werekma, ap inis ombok o Yudeya vagago welagagi Herodes ako en it Ala aburi nin edup-mbedup erogo bisagiluk vaginivit lagu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","“At Yohanes owa Yakubus ako, yaga vaga wares,” yiluk, yugeragagi ako vaga watu lagagwama, hombagagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yakubus watugwa andi vaga it Yakuri enendawi adenggen agya inugu lagagirik, at Peterus ogo, heda marigiluk lakbegegi. (It Erom Roti Virisigadek Menda ako isogo ogagu-sigik ogagagi.) ");
INSERT INTO nbq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lakbisa lagya lagagirik, heda marogo lembaga mabaluk, isogo ombok Pasika nelok, selekma avakwa inivaga owak dilup imbitya dugwit, it ap enayegen werek menda 4 homago eneyave 4 denek adigat aruwam dogopwak yiluk bogogi. ");
INSERT INTO nbq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","At Peterus ako lembaga akoma aruwam inigik ovara, it Ala aburi en enendawi hora yiluk, at ake samban adigat ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","At Herodes en hutun owak diluguluk at Peterus o hup mbusi heda vaga inggis venak-venak mago nogo yugu hegek, it ap enayegen werek menda eneyave mberen venak-venak inigik, it nin sup mbanggut vaga aruwam werekma, ");
INSERT INTO nbq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ala yonggo lakbisa wandiga menda malaikat ambi, it kamar ilim akoma werekma, yukdekma mondok yi nunggwigya lagagirik, abya yevedogo bagya lagagirik, ombandu vaga inggis yogovot-yogovot ogagya dugwit, “Peterus wai. Hodorogo mondok iru,” yiluk, ao yugugu hegek, inggis mbusi heda vaga mago ako endagen visilogo wombagagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Visilogo wambigya lagagimu, malaikat ako en at yugugu dugwit, “Hayum yikidgya, haropato yikhidigya, ogaru,” yugugu lagagimu, yikedagagi. Yikhidigya lagagimu, “Sogwes yum weram yikhidigya dogomindik, ninim lasogon yiluk oma,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Yugugu lagagimu, wunggu lagagirik, it mberen lagagwa. At malaikat ako en avyarat okbagya hegek, Peterus endawi en, “Un nabi haliga ai?” embetek it mberen lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ilim-weram suwam watu-sigik wulu wagu lagagwarik, o kota nunggwisagwima sogop mbusi vaga larik ako andenam ari lagusigik, endagen hutlagya lagagimu, it ako wunggu lagagwarik, sup atokma ari lagu lagagwarik, at malaikat ako andenam en hekbaluk winggigi. ");
INSERT INTO nbq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Wunggu lagagimu, at Peterus ako endawi anggat agya lagagirik, “Wi! yiluk, “It Yakuri menda inim, Herodes ako inim, okbanup embetao ako ovok erogo ao ogagetek inigik, At Ala yonggo lakbisa wandiga menda malaikat ambi lakba wagya lagarik, nagap wendatnetas avyarat higi o,” yiluk, imbitigi. ");
INSERT INTO nbq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Imbitya lagagirik, at Yohanes inis ambi salek Marakus ako, isa Maria amwa ap akwa wisane homakbaluk, samban ogagusim enadema lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Enadema lagya lagagirik, sogop weram vikit larik ako inggi-vaga suvupuk ogagya lagagimu, hwavyak enayeloman inis Orode en, “Sa wagya lagarik, ogasiga?” yiluk, bika winggigi. ");
INSERT INTO nbq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bika wunggu lagagirik, “Peterus ane iri higi,” yiluk, endawi adenggen en sogop huthegetek, “Peterus ako wasim agarik o,” yiluk, yugera nonggagagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yugera nunggwigya lagagimu, it ako en, “Hwavyak yi nenek hovaga danggup yagarik yagaliga?” yiluk, yugugu lagagwama, at hwavyak ako en, “Dek o. Avyarat waga higi!” yiluk, ane avuput vaga yugirigya lagagimu, “Andi halok, malaikat ambi at aruwam dogopwak yiluk lakba waga hegen a?” ");
INSERT INTO nbq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yugusigik, at Peterus ako suvupuk hunik adigat ogagya lagagimu, sogop huthugu lagagwama, at eyave at halok, “Wi!” yiluk, vok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Vok yugu lagagwama, at ako inggis lap-lap iri dugwit, “Mbauk dogones,” yugirigya lagagirik, Asin Ala en lembaga akoma en wolok wulu waga ako mbilinogo yugeragagi. Yugurigya lagagirik, “At Yakubus inim, nenaswei nin inim, wene andi yugeregek elales,” yugirigya lagagirik, hekbisiluk, o adikmu lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Hutun o yanggo iri lagagimu, it ap yegen werek menda ako en, “Peterus nggarogonggan winggas?” yiluk, nane-hane yugu dugwit belalit nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","At Herodes en, “Des erogo belalit elales,” yugirigya lagagimu, belalit lagagwa menda, dek halok, we un wagu lagagwama, “Hit nano ogagu hinigik, winggas?” yiluk, yugirigya lagagirik ap en it aruwam welagagwa ako inurupwak yiluk yugeragagi. Andi okbaluk at Herodes o Yudeya en o Kaisareya lagya lagagirik, andoma welagagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Andoma dugwit, it ap akwa o Tirus menda inim, Sidon menda inim, mbet irigya dugwit, inim ogorek welagagwa. Welagagwa ovara, it ako enendawi ambiat agu lagagwarik, Herodes inim dambuluguluk, homari wagu lagagwarik, at Herodes yugiri nungguguluk, ap ambi Herodes eyavup ogasiga menda endawi hunik inis Belatus ako yugogogwa. Yugugu dugwit, “Nit erom nelagwi ako andi, Herodes andok agarikmu, ogorek dogop andi weyak atma, ninim dambuluguluk wagyoma, yuguru,” yiluk, yugugu lagagwama, “Eo! Yugirisogon o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","“Wene andi o yi vaga ogarusogon o,” yiluk, iri lagagirik, o andi vaga at Herodes ako yum ap ininis ombok yikedelagwi menda yikhidigya lagagirik, wene amburup mbalisigama akoma hora inggya lagagirik, avakwa andoma wene yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yugurigya lagagimu, it ap akwa ako en, “Wi! Yi ap en yagaliga dek. Madis ane vaga yagaliga,” yiluk, enane naik-naik yugu dugwit siyabagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Siyabagu lagagwama, aren Ala siyabagetek, ‘An iya neyalok, yagao’ yiluk, siyabatiga lagagimu, Ala yonggo lakbisa wandiga menda malaikat ambi mbikit wagya lagagirik, warogo bagagi. Warogo bagya lagagimu, wanggo en endawi libinggu-sigik, hombagagi. ");
INSERT INTO nbq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nenasin Ala wene Yesus avok ako ombok at mbigalit lagya hegek, it ap akwa wisane avyarat umbutu dugwit, wugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Eke, at Mbarenabas Saulus it mberen o Yerusalem ogaruguluk lakbogogwa ako, mondok at ogagu lagagwarik, at Yohanes inis ambi salek Marakus ako wolok eneyami vaga o Andiyokiya lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","O Andiyokiya andoma it Ala aburi homagu lagagwa enanggelekma it nin en navi-navi Ala en yugirigya hegek yugurugwi, nin en wene mamulirugwi, ogagu lagagwa ininis andi, Mbarenabas inim; Simion inis ambi salek 'Mudis' inim; ap awi Kirene menda Lukiyus inim; ap ambi ap inis ombok Herodes ako inim dugwit sawe agagi inis Manahem inim; Saulus inim; it ako enat ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","It ako erom nenggetek dugwit Nenasin Ala siyabagusigik, at Averiniki en yugirigya dugwit, “Mbarenabas Saulus it mberen an neyavup ogagu dogop hologo bogogis ako, ogagu dogopwak yiluk denogo mondok okbisines o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yugirigya lagagimu, it ovok erogo erom nenggetek dugwit, inunggul ininggis vakbisiluk, samban okbugu lagagwarik, lakbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","It Mbarenabas Saulus it mberen Averiniki en lakbugu lagagimu, o Seleukiya wambugu lagagwarik, andoma en, mburis ombok vaga o is enggema Sipurus andoma lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lagu lagagwarik, o kota Salamis nonggagagwa. Andoma dugwit, it Yakuri samban ogasagwima adigat Ala wene yugeregek nagu lagagwa. Yugeregek nagusim, at Yohanes Marakus ako inim yonggarinigik lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","O is enggema akoma en ambima nonggegek ogarit o Papos nonggagagwa. Nunggugu lagagwarik, ap Yakuri menda ambi inis Mbareyesus madis inis vaga ogagya dugwit, ‘An navi Ala wene yagaliga menda’ yiluk, ane huluk molalit landiga ako inim avuk agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","At aswe andi ap endawi anggat menda inis Seregiyus Paulus, at o is enggema andoma Gubenur welagagi. At ako en Mbarenabas Saulus it mberen Ala wene yuknerapwak yiluk enayonggo bagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Enayonggo bagagi ovara, at madis inis vaga ogasiga ako, inis it Yunani enane vaga Elimas, eke, nit nenane vaga ‘Madis Inis vaga Ogasiga’ yagalagwi ako en, Mbarenabas Saulus inim ogorek dugwit, Ala wene avyarat ombarugwi en yiluk, ap Gubenur ako wene adik menda endawima mabagiluk yugigik adigat ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ap Elimas ako en wene adik menda ap Gubernur endawima yugigik adigat ogagya lagagimu, at Saulus inis ambi salek Paulus ako Averiniki endawima des iri lagagimu, ap Elimas ako il vurek dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ee! Hat sile abut yi, hane huluk wisane erogo yugeregek naliga, eke sek ogarup hanggon dugwit weyak ogarup adigat ombasiga andi, hat aro. Hat Ala arup mot ova mbirik ogasiga ako mera hudi mbup yimi? ");
INSERT INTO nbq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yogak hat hil dogop! At Nenasin Ala en anggin hovaga bagasogon! Hil mbuk akluk, o awiya hil hegetek heyagek, ndugwis maren hudi dogogun o,” yiluk, ao yugugu hegek, il agut agya lagagirik, hwis agagi. Il hwis agya lagagimu, “An ninggis vakbanupwak o,” yiluk, inggirenden ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Enowa Gubernur ako en ap il mbuk agagi higya lagagirik, Enasin Yesus wene mamulirugwi andi “Wi” yiluk vok iri dugwit, Yesus Ala abut denek menda avyarat imbitigi. ");
INSERT INTO nbq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","At Paulus aswei inim o Papos hekbaluk, mburi-vaga nunggugu lagagwarik, inamut ombok laut yanggadek vaga o Pambiliya wunggu lagagwarik, o kota Peraga andoma lagagwa. Andoma inigik, at Yohanes Marakus ako it hekbisiluk, o Yerusalem eyami vaga lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","O kota Peraga andoma en lagagwa, lagagwa, o Pisidiya Andiyokiya lagu lagagwarik, it Yakuri samban ogasagwi vaga it samban ogasagwima nunggugu lagagwarik hora yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Hora yiluk werekma, it samban ogasagwima vagago agarwik menda ako en Ala wene yugup Musa en dirup watigi wene inim, navi-navi wene dirup warek inim, bikegek yugurugu lagagwarik, “Nit nenendawi aik wakbininaup wene ambi werek halok yuknerapwak yiluk, nenaswei andi, hemerisenes o,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Yagagwa ako hemerinigu lagagwama, at Paulus ako mondok iri lagagirik, inggis lap-lap ogagya dugwit “Mbauk dogones,” yugeragagi. Yugirigya lagagirik, “Hit ap Iserali menda inim, hit Yakuri dek menda ovara Ala henalon ombasagwi andi inim, henaruk holek dogwes o, naswei. ");
INSERT INTO nbq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nit Iserali menda Nenasin Ala en nenombawi miginipu lagagirik, o Mesir andoma huru hak inigik, ininis unggul ombok arupwak yiluk, enaruwam welagagirik, Ala en anye ombok vaga o andoma en wogonombolok wulu wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","O harumu ap akwa dekma akoma 40 tahun ogagu dugwit, enandogon weyak ogarit lagu-sigik ovara, Ala endawi seve yiluk welagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Eke, it ap akwa o Kanaan menda ininis unggul 7 ako dek erogo bisiluk, enavoloma at aburi nenombawi ako andok dogopwak yiluk mavorangge hak it enawen mbalogo bogogi. ");
INSERT INTO nbq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yakup aburi o Mesir lagagwa hudi en, Ala en wogenombolok wulu wagya hegek o Kanaan nonggagagwa hudi andi, ara-dek a 450 tahun ogagagwa. Ogagu lagagwama, vivis, yi wene ndi wene yugurugu dogopwak yiluk, wene ambi agya halok enowak dilisagwi menda ambi avoloma, ambi mondok okbagek, ogarit lagu dugwit hivis atok vaga Ala en yugugu hegek yugirigya lagagi navi Samuel ako at yi wene ndi wene yugirigya dogopwak yiluk, mendok okbagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mendok okbagya lagagimu, vivis, it ap akwa en, 'Nit at avema dogop nenowa inis ombok ambi mondok okbininin o,' yiluk, yugugu lagagwama, At Ala en Kis abut Saul inis unggul Mbenyamin menda ako, mondok okbagya lagagimu, wene denggalogo yugirigya hegek, 40 tahun at ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eke, at Saul ako hekbaluk, avoloma, ‘At Isai abut Daut ako an nendawi ombasiga ndatak, wane-wane ombasiga menda atma, an nendawi ombasiga adigat ogagya dogosogon higi o,’ yiluk, enowa inis ombok Daut at mendok okbagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ala en avyarat nggatuk erogo yagagi wane-wane Daut ombawi wigalek ambi vaga en ap akwa Iserali enagap wendarisiga menda, At Yesus at endaklagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","At Yesus ako ao warigiluk ogagya hegek, at Yohanes en it Iserali menda ovok erogo yugirigya dugwit, ‘Hit henomaluk andi, henendawi wenggebaluk mbo bagu hiniselok, ima wombabigigayogon o,’ yiluk, yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yugirigya lagagirik, vivis, at ogagya lagagi ako mondok atok mbup yup agya hegek, at Yohanes en iri dugwit, ‘An sa, nombasagwi o? At warup sokhelagwi ako, an dek o. Andi an dek ovara, at an nambetaga warisogon ako, wagya halok, at ap ombok atma, anen arepato nggolalogo baup meyan,’ yugirigya lagagi o,” Paulus en yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Yugirigya lagagirik, “Naswei. Hit Averaham ombawi inim, hit Yakuri dek ovara Ala henalon ombasagwi menda ogo inim, hit ninim nenagap wendarupwak yiluk, nenake wene yi at lakba wagagi o! ");
INSERT INTO nbq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Anderogo at ovara, it ap akwa Yerusalem menda enasini ap ombok-ombok inim ako en, 'At Yesus andi, nenagap wendarisiga menda aro,' yiluk, yedok hegetek ovara, ndugurek-ndagarek it Yakuri samban ogasagwi vaga, it ap navi-navi wene dirup warek bikegek yagalagwi ako, at warup hobaluk, warogo bagagwa vaga, wene andi atma at agagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","'At ngga ogaga vaga waruk?' yiluk, adem belanggugwa menda, adem dek at hegek ovara, waruguluk, at Pilatus yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Eke, 'Anderogo okbasogon o,' yiluk, yugu lagagwa dirup watugwa ako wane-wane okbagu lagagwama, yo winik vaga lobalogo bagagwa ako visilogo wombaba wagu lagagwarik, hambuguselok wimu mabiselagwima akoma mabagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wimu mabagagwa ovara, Ala en hambuluk lendagwima en iluk erogo mendok okbagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","At ao watitek hegek, at inim Nggalileya en Yerusalem lagagwa ako, at mendok okbagya lagagimu, eyave inil neyapwak yiluk inugirigya dugwit, ndugwis wisane welagagi. Eke, it inil hagagwa ako en yogak nit ap akwa Iserali menda vagalogo yukneregek lendagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Ala en nit nenombawi avyarat nggatuk erogo yugeragagi ako, Yesus hambuluk lendagwima en iluk erogo mendok okbagagi ako vaga, it enombawi nit nenake atma des iri lagagimu, sek wene yi at yukheralagwi. Anderogo atma, At Ala en iri dugwit, O yogak hat An nabut agya, Eke, An hat Hasin agya, Ogagyo o, yiluk, Mbuku Ndawi Wene pasal 2 vaga dirup watigi. ");
INSERT INTO nbq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ala en ‘At hambuluk lendagwima en iluk erogo mondok okbagya neyalok, hivis vidis arisogon dek o,’ yiluk, iluk erogo mendok okbagagi ako andi, At Ala en iri dugwit, An sek okbayogon o, yiluk, Wene eve adik denek mondok avyarat ombarup menda Daut yugogogis ako, hit at okbigigayogon o, yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Eke, Daut en ambi inim iri dugwit, Habut Endawi Sek Adigat Denek ako, Eyave hambuluk, vidis agya hawen, hekbayogon dek o, yiluk, yagagi ako dirup warek agarik. ");
INSERT INTO nbq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ala en at Daut ogagya dogopwak yiluk vulogo bagagi ako, wane-wane at ogagya lagagirik, hombagagi. Hambigya lagagimu, ombawi hombagagwa inim saba lagagwa vidis agagi ovara, ");
INSERT INTO nbq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","At Ala en iluk erogo mendok okbagagi ako andi, vidis agetek. ");
INSERT INTO nbq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Vidis agetek, iluk at werekma, hit weyak ogasagwi andi, At Yesus vaga Ala en dek erogo bigigaup hinilup arovovok yiluk, yukheraliga o, naswei. ");
INSERT INTO nbq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ala wene yugup Musa en dirup watigi ako vaga nenendawi mot okbininaliga dek. Ata, Yesus ovaga vanggabaluk avyarat ombasagwi vaga andi, Ala en nenendawi mot okbininaliga, yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Anderogo atma, Ala en yugirigya hegek yugurugu lagagwa navi-navi ako en yugu dugwit, Hit Ala weyak-edok erogo belagwi yi, Hit agipik yi hudi vaga an ambi okbigigaup ako, Hit yukheraup ovara, avyarat ombarusogon dek menda ogarisogon atma, Hit vok yugu dugwit, mondok dek at arusogon o, yiluk, yugeragagwa ako, hit anderogo at okbugugu hao en, henendawi suwam watu dogones o,” yiluk, at Paulus ako en yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Yugirigya lagagimu, Paulus Mbarenabas it mberen it Yakuri samban ogasagwima akoma wunggu-sigik, it ap akwa en, “Wene yukneregep ako, nin hivis samban vaga yukneravovok,” yiluk, yugurugu lagagwama, wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","It ap akwa samban okbaluk wunggu lagagwarik, it Yakuri menda inim, it weram Yakuri dek menda Ala enalon umbutu dugwit Yakuri wene wugu lagagwa inim, wisane erogo Paulus Mbarenabas inim lagu dugwit, “Ala henabwa en Yesus vaga henomaluk dek okbigigiluk henagap wendarisiga ako, henendawi dibaluk, ogarit lagu dogones,” yiluk, wene mamulirugwi, enendawi aik wakbugwis, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hivis samban ogasagwi vaga o kota andoma ap akwa ovok erogo Nenasin Yesus wene huluguluk, homagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Homagwi ako vaga it Yakuri menda inil inigu lagagwarik, “A! Nit nenane hulup ova hera, it enane adigat hulup, nenanggon!” yiluk, enaninis en at Paulus ane iris ako saganggu dugwit, wiyiknom-weyaknom yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Wiyiknom-weyaknom yugu-sigik, it Paulus Mbarenabas enalon dek yugurugu dugwit, “Ala wene hit Yakuri menda henendak yukheraup ovara, ‘Nit niniluk dogop wene andi, waup ndak dek o, yiluk, nenanggon,’ yegep atma, hit hekbigiluk, it weram Yakuri dek menda ako at yugeregek nagu dogosogon. ");
INSERT INTO nbq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nenasin Ala en iri dugwit, ‘Ap akwa enagap wendarogo bisaup wene hologo bogogis ako, It ap akwa ininis unggul adik-adik o atok-atokma andoma enanggelekma awiya erogo bugu dogonyok yiluk, anenen denogo bagagigis o,’ yiluk, yagagi ako, yogak yukneraliga atma, it weram Yakuri dek menda yugeregek lendagwi o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Yugeragagi ako, it weram Yakuri dek menda ako en enaruk hobaluk, enendawi adenggen wisane umbutu dugwit, “Nenasin Ala wene yi andi, iya!” yiluk, siyabagagwa. Eke, it ap akwa iniluk mondok-mondok dogop denogo bogogi ako en wene andi vaga enendawi vanggabaluk Yesus ako avyarat umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nenasin wene ako, o andoma ovok at wigak yagagi ovara, ");
INSERT INTO nbq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Paulus Mbarenabas it mberen anggin-mbanggin okbisapwak yiluk, it Yakuri menda ako en akwa ininis werek menda Ala enalon umbutu lagagwa inim, it o kota andoma menda enasini ap ombok-ombok inim, enendawima mali wagu lagagwama, o andoma en haryogo wibogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Haryogo wibugu lagagwama, it ako en, “Hirenen” yiluk, inisok vaga mupwak hak horogo mbo bisiluk, o Ikoniyum lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Lagu lagagwama, it o Andiyokiya andoma Yesus ane wogogwa ako, Averiniki enendawima des yi nunggwigya lagagimu, enendawi adenggen wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","O Ikoniyum andoma o Andiyokiya ogagagwa ako wane-wane ogagagwa. Paulus, Mbarenabas ogo, it Yakuri samban ogasagwima nunggugu lagagwarik, wene eve des erogo yugeragagwa vaga it Yakuri menda inim, Yunani menda inim, wisane enendawi Yesus Ala abut denek menda ako avyarat umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Avyarat umbutu lagagwama, it Yakuri nin 'Yesus andi Ala abut dek atma, nenanggon,' umbutugwa ako en it weram Yakuri dek menda ako enaninis okbugu dogomundik, Yesus aburi inim ogot larupwak yiluk enendawima mali lagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","at Paulus Mbarenabas it mberen andoma ipi erogo dugwit, enalon dek Nenasin Yesus avok vagalogo yugurugu lagagwa. Eke, vagalogo yugurugu dugwit, Ala enabwa en okbisaliga wene avyarat ombarupwak yiluk, Paulus Mbarenabas it mberen Ala anye wogoragagi vaga, enelup arup enalon werek menda ogagwi, nggarogo ogarubuk menda ogagwi, ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","It o kota andoma menda ako ogot lagu dugwit, it nin Yakuri enane wugwi, eke, it nin lakbogogi ako enane wugwi, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ogagu dugwit, it weram Yakuri dek menda ako inim, it ap Yakuri menda inim, it enasini ap ombok-ombok inim, enendawi ambiat okbaluk, Paulus Mbarenabas it mberen nadok-hadok erogo helep vaga inurusogon yiluk, hologo bagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hologo bagagwa ovara, it okbisaup hologo bagagwa wene ako Paulus Mbarenabas it mberen enaruk hobaluk, hoda o Likawoniya lagu lagagwarik, o kota Lisera inim, o kota Nderebe inim, o andoma avilis ambot yanonggegek lagu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","sek wene andoma yugeregek nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","O Lisera andoma ap ambi isok weyak endaklagagirikmu, isok anye dek en sup mondok lagatek welagagi. ");
INSERT INTO nbq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ap ako at Paulus wene yugirigya aruk hunggwiyam, Paulus en il vurek dugwit, “Ap yi Ala ova vanggabaluk avyarat imbitya dugwit sek okbanup ombasiga,” yedok higya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","at yugugu dugwit, “Hisok ngges erogo mondok iru,” yiluk, ane ombok vaga yugugu lagagimu, at ako soklok erogo mondok iri lagagirik, sup lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","At Paulus ogagagi ako, it ap akwa homagagwa ako inil hugu lagagwarik, it Likawoniya enane vaga, “Madis ap ova hak agu lagaruk, ninisa wambu wagao o,” yiluk, enamitmit yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Enamitmit yugu lagagwarik, enomadis inis ako at Mbarenabas inis Seus sanggwis, eke, Paulus wene wisane yagaliga menda halok, inis Heremes sanggwis, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ogagu lagagwama, ap madis Seus moga awi valek o kota weram vikit vagago welagagi ako en, “Ap akwa ninim en it lakbogogi ako enanggom warogo wogorasogon o,” yiluk, sapi nggulok inim, mbungga mudi-mudu mendago inim, sup o kota nunggwisagwima andenam wolok wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","“Wogoraguluk ogasagwi” ako it lakbogogi Mbarenabas Paulus it mberen enaruk hunggu lagagwarik, enasum yirik libilogo baluk, ap wisane homarek werekma vupuk nunggugu lagagwarik, enane ombok vaga yugurugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Avyak wai. Nit eve ap at, hit ndatak atma, hit nggarogo yiluk yerogo ogasagwi? Hit yi ogagek ndi ogagek enam warogo ogwasagwi menda yi, mbo baluk, at mbogot inim, wen inim, inamut yanggadek inim, yi menda ndi menda ovok Ala iluk agarik ako en bagagi at awene wavovok yiluk, sek wene wolok yukhera wagyo hegek ovara, ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","O muk en, yogak yi hudi vaga yi ap akwa ndi ap akwa enendawi ombakluk ogarit lagu-sigik, Ala en hekbisaliga ovara, ");
INSERT INTO nbq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","at ako yedok havovok yiluk, okbigigaliga. Henabwa en sek okbugugu dugwit, mbogot-vaga en musu wokhirigya, yi menda ndi menda enggen yupwak yiluk, ogagya, erom wisane erogo wokhirigya, henendawi adenggen okbugugu, ogasiga o,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","enane anderogo yugeragagwa ovara, hegek, enanggom warogo wogeraguluk ogagagwa menda, moga hunik adigat yugurugu lagagwama, hetbagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Yugu lagagwama, it ap Yakuri menda o Andiyokiya inim, o Ikoniyum inim, wagu lagagwarik, nit ninim aruguluk, ap akwa enendawima manggu lagagwama, Paulus helep vaga wakbagu lagagwarik, “Mondok hombagas,” yiluk, nggigilogo o kota weram vikit mbo ha wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mbo ha wunggu lagagwama, it Yesus ane wogogwa ako en at eyave ilim hegek, walinbaluk welagagwama mondok iri lagagirik, o kota akoma nonggagagi. Nunggwigya lagagirik, nogo yiluk, hutun Mbarenabas im o Nderebe lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ap akwa o kota Nderebe andoma sek wene yugeragagwa vaga ap akwa wisane avyarat ombakluk Yesus ane wogogwa. Wugu lagagwama, eneyami vaga lagu dugwit, o Lisera nunggugwi, Ikoniyum nunggugwi, ogarit o Andiyokiya nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","O akoma yanonggegek lagu dugwit, “At Nenowa Inis Ombok Ala en denogo bagagi ako avema nunggup andi, anggin-mbanggin wisane nenovaga ari wagya hegek nunggusogon,” yiluk, it Yesus ane wogogwa ako, enendawi hoda okbugwis, “Wene avyarat embetep ako hekbaup moga o. Ata, henendawi wadok dek okbaluk dogones,” yiluk, mbilape yugurugwi, ogarit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ap akwa Ala wene homarisagwima adik-adik akoma enasini dogopwak yiluk, Paulus Mbarenabas it mberen en ap denogo mondok okbugu lagagwarik, erom nenggetek samban ogagu dugwit, “Nenasin o. It ap yi, enendawi hovaga vanggabaluk avyarat embetao atma, ogarit nagu-sigik, des erogo enengge dogenyok,” yiluk, enake samban ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Enake samban okbaluk, o Pisidiya nonggegek, o Pambiliya nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","O kota Peraga akoma wene yugurugu lagagwarik, o Ataliya wombagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Andoma en mburi-vaga o Andiyokiya nonggagagwa. “Ala eyavup ogarit lavovok yiluk, Ala henabwa en okbugugu dogosogon o,” yiluk, lakbogogwa ako ogarit lagu lagagwarik, mondok nggabup erogo okbaluk, lakbogogwarikmu akoma at wagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","O Andiyokiya nunggu wagu lagagwarik, Ala aburi ako homakbisiluk, Ala okbugu hegek ogonivit lagu lagagwa ako inim, eke, Ala en it weram Yakuri dek menda Nenasin Yesus ane avyarat ombarupwak yiluk, sup hurogo bogogi ako inim, wene mbilinogo yugurugu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","it o Andiyokiya Yesus ane wogogwa menda ako inim dugwit, ndugwis wisane welagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Akoma werekma, ap ambetap o Yudeya en o Andiyokiya unggu lagagwarik, nenaswei Ala aburi andoma mamulurugu dugwit, “At Musa en, Ap enagamut mbalup wene yukneragagi ako andi, wane-wane hit okbigitek halok, henagap wendarisogon dek,” yiluk, mamulurugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","it Paulus Mbarenabas ako en, it Yudeya en unggugwa ako inim wenemuk ombok erogo onggo-onggo yagagwa. Yugu lagagwama it mberen inim, it Andiyokiya menda avyarat umbutugwa ambetap inim, denogo bisiluk, yugurugu dugwit, “Hit Yerusalem lagu dogomundik, it lakbogogi ako inim, Ala aburi enasini ako inim, wene andi hinim mbali lales,” yiluk yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yugurugu lagagwarik, it Ala aburi andoma homago ako en lakbugu lagagwama, o Venisiya, Samariya inim, ya nonggegek lagu dugwit, it weram Yakuri dek menda enomaluk mbo baluk Ala wene wogogwa ako, mbilinogo yugeregek lagu dugwit, nenaswei Ala aburi andoma agarwik ako enendawi adenggen wisane okbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Okbisilin it ako o Yerusalem nunggugu lagagwama, it Ala aburi o Yerusalem homago inim, it lakbogogi inim, it Ala aburi enasini inim, ako en heyaga wakbugu lagagwama, “Ala en okbininggu hegek anderogo at ogagyo,” yiluk, ovok erogo mbilinogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mbilinogo yugeragagwa ovara, it Parisi menda Yesus Ala abut denek menda avyarat umbutugwa nin ako en mendok yugu lagagwarik, “Dek o. It weram menda ogo, enagamut mbabaluk, Ala wene yugup Musa dirup watigi ako ogagu dogopwak yiluk yugeraup,” yiluk, yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yugurugu lagagwama, it lakbogogi inim, it Ala aburi enasini inim, wene andi mbaluguluk, homagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wene ako wisane erogo mbanggugwarikmu, at Peterus mendek iri lagagirik, yugirigya dugwit, “Naswei. O muk erogo Ala en, it weram Yakuri dek menda sek wene hobaluk avyarat ombarupwak en yiluk, yugeregek lagya dogogiluk, denogo baninggigi ako henelup o. ");
INSERT INTO nbq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ap akwa enendawi Ala ovok elup atma, it ap weram menda ogo, Averiniki nit wokneragagi ako hak, it wogeragagi. Andi vaga, Ala en it ap weram Yakuri dek menda at aburi okbigas ako yedok helagwi. ");
INSERT INTO nbq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ala en, it yi iya, it andi meyan, nenombasigadek, nit ovok ndatak nenombasiga atma, irogo, enendawi Yesus avyarat ombasagwi vaga enomaluk dek erogo bisaliga. ");
INSERT INTO nbq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Anderogo atma, nit ninim, nenasini-nenombawi inim, Musa wene anggin nenovaga durik hegek ogarup mondok meyan hugu lagagup ako, hit yogak nggarogo yiluk wene andi, it Yesus ane welagwi menda anggin enovaga durogo bisiluk, Ala nggarogo okbugu hamwi? yiluk, avut mbaluguluk yagalagwi? ");
INSERT INTO nbq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Enagap wendarup andi, anderogo dek! Nit Nenasin Yesus nenabwa en okbininaliga andi vaga, nit avyarat umbutu niniselok, nenagap wendakninivisiga hak, it anderogo avyarat umbutu-selok, enagap wendaginivisiga, yiluk, avyarat ombasagwi o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Yugirigya lagagimu, it ap homagagwa ako ovok enane dek mbup yugu lagagwarik, enaruk hunggu-sigik, Mbarenabas Paulus en yugurugu dugwit, Ala en okbugu hegek, it weram Yakuri dek menda ova, enanggelekma enelup arup enalon werek menda ogagwi, nggarogo ogarubuk menda ogagwi, ogagagwa wene mbilinogo yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wene andi, enaruk hunggu lagagwarik, Yakubus en it lakbogogi menda inim, it Ala aburi enasini inim, yugirigya dugwit, “Nowa-nasin. An nane yukheraliga yi, henaruk holes. ");
INSERT INTO nbq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ala en endak it ap akwa weram Yakuri dek menda enanggelekma en nin At aburi denek belalogo miginipigi wene ako Simon en mbilinogo yukneraga. ");
INSERT INTO nbq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Wene Simon yukneraga andi, it navi-navi Ala yugirigya hegek yagagwa en dirup watugwa ako wane-wane at yukneraga o. Dirup watugwa ako andi ambi yi: ");
INSERT INTO nbq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","18","Eke, hivis an wagya dogomindik, It Iserali agako higirek, avakwa enanggelekma agarwik ako inim, Eke, it ap akwa weram Yakuri dek menda An naburi denek dogopwak yiluk yanggup yugeragagis ovok erogo inim, it ako en Enasin Ala An namusek wagu dogopwak yiluk, Daut awi valek masalagagi ako avoloma vanggya, O danggop avoloma vanggya dugwit, endak valek welagagi hak ogarogo bagya, Ogarisogon. At anderogo ogasiga menda o muk yagagi ako Henasin Ala enat yagagima, yukheraliga o, yiluk, yugeragagi wene dirup watugwa atma, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakubus en ambi yugirigya dugwit, “Dirup anderogo watugwarikmu, an ombasiga andi, it weram Yakuri dek menda enendawi wenggebaluk Ala wene welagwi ako, enendawi anggin erogo okbisaup dek ovara, ");
INSERT INTO nbq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","nit un surat vaga dirup watu dugwit, ‘Wam madis anggom warek naup moga. Wanggi waup moga. Yi menda ndi menda honak warek amuya winggitek halok naup moga. Amuya naup moga,’ yiluk, dirup warogo wogorasogom o. ");
INSERT INTO nbq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Musa wene ako o muk endak en yogwak yi hudi yi awi ndi awi ndugerek-ndagarek Yakuri samban ogasagwi vaga it samban ogasagwima bikegek yugerelagwi atma, dirup anderogo warogo wogeraup sek ombasiga,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yugirigya lagagimu, it lakbogogi inim, it Ala aburi enasini inim, Ala aburi andoma homagu lagagwa ovok erogo inim, “Paulus Mbarenabas it mberen nit yoma menda inim denogo o Andiyokiya lakbisasogom o,” yiluk, Ala aburi enasini ap ombok-ombok ambi Yudas, inis ambi Mbaresabas inim, ap ambi Silas inim, denogo bogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Denogo bisiluk, dirup watu dugwit, “Nenaswei wa. Henaswei nit Yesus en lakbininggigi inim, Ala aburi enasini inim, ako en nenaswei hit Yakuri dek menda avyarat ombasagwi o Andiyokiya, Siriya inim, o Kilikiya inim, hit andoma agipik ovok erogo wa yukherelagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","It nin ninim welagagup ako, niren yugeregetek hegek, henadema wagu lagarwik, yukhurugu dugwit, “At Musa en, Ap enagamut mbalup wene yukneragagi ako andi, wane-wane hit okbigitek halok, henagap wendarisogon dek,” yiluk, yukheragao ako vaga, henendawi weyak okbugugu lagaoma, henendawi anggin agipik ako, nenaruk hunggup. ");
INSERT INTO nbq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Nenaruk hunggurikmu, yogak nit homagu dugwit nenendawi ambi at okbaluk, ap ambetap denogo bisiluk henadema lak bigiga wendagwi. It ako nenaswei nenendawi hunik Paulus Mbarenabas ako, Nenowa Yesus Keretus ake yiluk enalon dek hambup sek at umbutu dugwit Ala wene yugeregek nelagwi menda inim lakbisa wendagwi. ");
INSERT INTO nbq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Anderogoma, it ap Yudas Silas en dirup warek yi wane-wane mbilinogo yukheramwak yiluk wolok lakbigiga wendagwi. ");
INSERT INTO nbq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Averiniki ninim en hit ogagu dogop imbito ako andi, nit Yakuri nenombawi ogagu lagagwa mamulik menda ako anggin menda ambi inim henovaga durogo bigigitek, we un, ogarup menda halok adigat ogagu dogop imbito ako yi aro: ");
INSERT INTO nbq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Madis anggom warek nunggwi, amuya nunggwi, yi menda ndi menda honak warek amuya winggitek halok, ugun nunggwi, wanggi wugwi, ogasagwi ako, mondok ogarubuk. Mondok ogagatek halok andi, hit mondok sek at ogagu dogosogon o. Wene andi at yukhirigyo o, nenaswei wa.” yiluk, dirup warogo, it ap 4 ako inim lakbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Lakbugu lagagwama, o Andiyokiya nunggugu lagagwarik, it Ala aburi andoma ako homakbisiluk, dirup warek andi wogeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wogurugu lagagwama, bikugu dugwit, wene enendawi aik warogo dirup warek hugu lagagwarik, enendawi adenggen wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","It Yudas Silas ogo, navi-navi Ala en yugirigya hegek yagalagwi menda atma, it enaswei Ala aburi andoma ako yi wene ndi wene wisane yugurugu dugwit, enendawi aik wakbugwis, enendawi hoda okbugwis, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Andoma maren hudi welagagwarik, it enaswei Ala aburi andoma en “Yogo, hit sek erogo elalo,” yiluk, it Ala aburi enasini lakbisa wagagwa ako enadema eneyami vaga lakbogogwa.  ");
INSERT INTO nbq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lakbogogwa ako wagagwa ovara, at Silas andi, “Mbup yisogon,” yiluk, andoma at mbup yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","It Paulus Mbarenabas it mberen o hunogoma lagetek, o Andiyokiya andoma dugwit, it inim, ap nin wisane inim, Nenasin Yesus ogagya lagagi wene ako mamulirugwi, yugurugwi, ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Akoma welagagwarik, hivis Paulus en Mbarenabas yugugu dugwit, “Yi awi ndi awi Nenasin Yesus wene ako yugeregek nagu lagagurikmu akoma, nenaswei Ala aburi ako, Nggarogo agarwik inisamwi? yiluk, biginigik lasogom o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Yugugu lagagimu, at Mbarenabas en, Yohanes inis ambi salek Marakus ako ninim lasogom, yagagi ovara, ");
INSERT INTO nbq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paulus en, “At ninim laup meyan,” yiluk, yugugu dugwit, “Nit o Pambiliya dugwit, ninim wene yugeregek laup ovara hekbiniluk winggigirikmu, yogak ninim laup dek,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Yugugu lagagimu, it wenemuk yugu lagagwarik, it mberen ogot-hidugu lagagwarik, at Mbarenabas en Marakus wolok mburi-vaga o Sipurus lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Eke, at Paulus ako andi, Silas migitu lagagimu, it nenaswei Ala aburi en, “Nenasin Ala henabwa ombasigama, hinim lasogon,” yiluk, yugurugu lagagwama, lagu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","o Siriya inim, Kilikiya inim, yi awi ndi awi ya nonggegek nagu dugwit, at Paulus ako en it Ala aburi homago ako enendawi wadok dek dogopwak yiluk, yugeregek nagu lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Yugeregek nagu dugwit, o Nderebe lagya lagagirik, o Lisera lagagi. O Lisera andoma ap ambi Yesus ane wogogi inis Timotius. At isa andi, Yakuri menda ovara, avyarat imbitigi, eke, asin andi, Yunani menda. ");
INSERT INTO nbq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","It nenaswei Ala aburi o Lisera menda inim, o Ikoniyum menda inim, Timotius andi endawi sagain hugu lagagwarikmu, ");
INSERT INTO nbq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus en, “Timotius nit mberen nagu dogosogon,” imbitya lagagirik, it Yakuri o andoma menda ovok erogo Timotius asin andi, ap Yunani menda enelup atma, Paulus en agamut mbalupwak yiluk yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","It Paulus Timotius it mberen yi awi ndi awi o kota adik-adik nagu dugwit, wene o Yerusalem it lakbogogi inim, Ala aburi enasini inim, o Yerusalem nggatuk erogo mbanggugwa ako, it dibaluk ogagu dogopwak yiluk yugeregek nagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Anderogo yugeregek nagu lagagwa vaga, it Ala aburi o adik-adik homagu lagagwa andoma it Yesus avyarat ombasagwi ako enendawi wadok dek agya lagagimu, ndugerek-ndagarek ambi labok, ambi labok, ogagu dugwit, Ala aburi wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Eke, at Averiniki en, “O Asia andoma Ala wene yugeregek labuk,” yugirigya lagagimu, Paulus eyaganggom inim lagwi ako, o Virigiya en o Nggalatiya nagu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","o Misiya nungguguluk hudi mbalekma vanggo yi lagu lagagwarik, o Mbitiniya nungguguluk ogagagwa menda, At Yesus Averiniki en, “Nunggup,” yugeregetekma, ");
INSERT INTO nbq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","o Misiya hegek mbikit o Terowas nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","O Terowas nunggugu lagagwarik, andoma nogo yugu dugwit, at Paulus abi vaga ap Makedoniya menda ambi mendek dugwit, “Nit yonggatninisanok yiluk, o Makedoniya yoma oma,” yiluk, nggino yugugu hagagi. ");
INSERT INTO nbq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Higya lagagirik, “Ala en nit sek wene ap Makedoniya menda yugeregek laguluk, ninayonggo bagas higyo,” yiluk, Paulus, Silas, Timotiyus, an Lukas ninim, nit mbikit laguluk vipuk ogagagup. ");
INSERT INTO nbq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","O Terowas en mburi vaga nunggugu lagagurik, mbikit o Samotarake wunggu lagagurik, hutun en, o Neyapolis lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Lagu lagagurik, o Makedoniya kota eve iya inis Pilipi, it ap Oroma menda en vagago welagagwarikmu akoma, nunggugu lagagurik, andoma dugwit, ndugwis maren hudi welagagup. ");
INSERT INTO nbq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","It Yakuri samban ogasagwi vaga o kota sup nunggwisagwima en wunggu lagagurik, “Is amban vaga samban ogasagwima andoma werek,” yiluk, lagu lagagurik, it akwa homago werekma ninim hora yiluk, wene yugeragagup. ");
INSERT INTO nbq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Yugeragagup hunggugwarikmu ako, hwa o kota Tiyatira menda ambi yum mudu heda ndimbup-ndimbup enggen hak sek adigat onggo hundutu lagagi menda inis Lidiya ako en Ala inis siyabaligama, at Paulus yugeragagi wene ako wapwak yiluk Nenasin Ala en endawi sup hurugo bagagi. Endawi sup hurugo bagagi vaga wene wigya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","hwa ako at amwa agarwik menda inim ima wombabogogi. Ima wombabugu lagagimu, at hwa ako en, “Hiren, Hwa yi, Nenasin Yesus avyarat embetas o, nembetep halok, an namwa ninim dogoguluk omanes,” yiluk, hunik adigat yuknirigya lagagimu, “E o,” yiluk, amwa nonggagagup. ");
INSERT INTO nbq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ndugwis ambi vaga samban ogasagwima lagusim, hwavyak ap enayeloman ambi madis endawima nonggagagirikmu, madis inis vaga wene enunggut vivis arup menda yugirigya halok yoparip wisane erogo lugurogo asini wogoraligama, suvaga ninim avuk agu lagagurik, lagusim, ");
INSERT INTO nbq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","hwavyak ako en, “At Siyalek Adigat Agarik Ala ayeloman henagap wendarup wene yukhera wendagwi yi, yogisenes o,” yiluk, hwidyak hunik yagan Paulus ninim nenambetaga wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Anderogo adigat iri hegek, ndugwis wisane ogagya lagagimu, ndugwis ambi vaga at Paulus anggon imbitya lagagirik, hwavyak avikit elose nomalogo madis ako yugugu dugwit, “Yesus Keretus inis vaga hwavyak yi endawima en wilinyok yiluk, yukhisiga,” ao yugugu hegek, madis ako nggigilogo winggigi. ");
INSERT INTO nbq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wunggu lagagimu, hwavyak ako asini en, “Ai! Yoparip lugurogo woknirigya dogop nenape wenggelek agurik ako dek aga o,” umbutu lagagwarik, at Paulus Silas it mberen vakbisiluk, liginiviluk, o pasar hunisagwima ambi agya halok wene mbalisagwima akoma enasini ap ombok-ombok enadema bisa lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","It enasini ap ombok-ombok o kota andok ako enadema bisa lagu lagagwarik, yugurugu dugwit, “Nit ap Oroma menda en ogagu dogop moga yugup hegek, ap Yakuri yi, it ogwasagwi menda mamulnirugu dugwit, nit nenawi o kota yoma nadok-kadok erogo bagwi inigup,” yiluk, yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yugurugu lagagwarik, ap apik homarek mondok yugu dugwit, inurusogon yiluk ogagu lagagwama, enasini ap ombok-ombok o kota vagogo ako en, “Enasum yirik andi libilogo bisiluk, yo enares,” yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Yugurugu lagagwama, yo sagalogo initu lagagwarik, nggigilogo o heda marogo mabiselagwima mabugu lagagwarik, ap enaruwam welagagi ako, “Mondok des erogo enaruwam watya dogwen,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Yugogogwa ako hobaluk, o kamar ogorek o ilim akma andoma mabugu lagagirik, inisok yo vaga silup okbisiluk sovalogo bogogi. bogogi. ");
INSERT INTO nbq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sovalogo bogogi andoma welagagwa ovara, o hup agako vaga it nin heda mago andoma enaruk hunggusigik, it Paulus Silas it mberen samban ogagwi, Ala inis siyabagu dugwit ndawi watwis, ogagusim, ");
INSERT INTO nbq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","mbikit supuk erogo o wadok ombok iri dugwit, o valek heda marogo mabiselagwima akoma o owak ngguvulik ovok wadok yagagi. Iri lagagimu mbikit sogop ovok erogo hut lagya, mbusi heda mago ovok erogo visilogo lagya, ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ogagya lagagimu, at ap heda mago enaruwam welagagi ako en iluk akluk, heda marogo mabiselagwima sogop hutlagagi il higya lagagirik, “It heda mago ako mondok winggyao higi,” imbitya lagagirik, yaga varam nggigis erogo wakedagiluk ogagyama, ");
INSERT INTO nbq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","at Paulus en, “Nasin! Hat wakedabuk! Nit ovok erogo yoma agurik,” yiluk, ane ombok vaga yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Yugugu lagagimu, at heda mago enaruwam welagagi ako en, “Yunda yividiluk wolok omanes,” yugirigya lagagirik, alon en owak dede yagan vupuk Paulus Silas it mberen enavema hora yi lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Hora yi lagya lagagirik, it mberen wogonombolok weram wibugu lagagirik, “Ai nasini, an nagap wendak-hedagiluk, nggarogo ogarik?” ");
INSERT INTO nbq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yugirigya lagagimu, it ako en, “Dek o. Hendawi Nenasin Yesus ovaga vanggabaluk avyarat imbitya heyalok, hat hinim, hat hamwa agipik inim, henagap wendarisogon o,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Yugugu lagagwarik, at inim, it ap akwa at amwa agarwik inim, it ovok erogo Ala wene yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","O hup andi vaga at heda mago enaruwam welagagi ako en it wogonombolok lagya lagagirik, heda mago dugwit enagamut mbalarit lagagi ako horinipu lagagimu, at inim, at amwa agarwik inim, ima wombabogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ima wombabugu lagagwama, wogonombolok at amwa nunggugu lagagwarik erom wogoragagi. At inim, at aburi inim, enendawi Ala ovaga vanggabaluk avyarat umbutugwa vaga enendawi adenggen wisane agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","O yanggo iri lagagimu, it enasini ap ombok-ombok o kota andok ako en, “Ap heda mago enaruwam agarik en it ap mberen heda marek ako heda visilogo wibisapwak yiluk, yugiri elales,” yiluk, it inarwi yegen werek menda lakbisa lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Lakbisa lagagwa yugiri lagu lagagwama, ap heda marek mabiselagwima aruwam welagagi en Paulus yugugu dugwit, “Nasini o kota vagogo agarwik ako en hit mberen heda visilogo wibisaup, yagao, yukniri wagaoma, wunggu dogomundik, henendawi ugun at elales o.” ");
INSERT INTO nbq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Yugeragagi ovara, at Paulus en it yegen werek menda yugirigya dugwit, “Dek o. Nit Oroma menda arovara, adem sek erogo yenaga wokbaluk nenowak dinggitek dugwit, ombok vaga yo yawi nenakbaluk lembaga mabininggaoma, nit yogak yonggo yegetek mbauk erogo wibininaup yiluk yagaoma, yagalagwi yi? Dek! It enadigat en nit woknenombolok wulupwak yiluk warupwak.” ");
INSERT INTO nbq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Yugeragagi ako, it yegen werek menda en it o kota vagogo agarwik enasini ap ombok-ombok ako enadema lagu lagagwarik, “Paulus Silas ako it Oroma menda hegek oginivup,” yugeragagwa ako enaruk hunggu lagagwarik, “Nit ogagyo wi,” yiluk, enalon agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Enalon agu dugwit, it ako enadema wagu lagagwarik, “Ai, nenaswei! Weyak okbugugup atma,” yiluk, it ako lembaga en mo bisa lagu lagagwarik, “O kota yoma dogop dek. Elales o,” yugurugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","akoma en, wulu wagu lagagwarik, hwa Lidiya amwa akoma nonggagagwa. Nunggugu lagagwarik, andoma enaswei nin inim dambunggu lagagwarik, enendawi aik wakbisiluk, lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lagu lagagwarik, o Ambipolis nunggugwi, Apoloniya nunggugwi, ogarit o Setalonika nonggagagwa. Nunggugu lagagwarik, it Yakuri samban ogasagwima andoma werekma, ");
INSERT INTO nbq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","at Paulus itok it Yakuri samban ogasagwi vaga inim samban ogasigama, nonggagagi. Ndugwis henggam it samban ogasagwi vaga aren Ala wene dirup warek vaga at inim it inim wene amburup mbalogo yugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Yugirigya dugwit, “At Ala en Nenowa Inis Ombok denogo bagagi Keretus ako, edup yagan wakbaluk, hambuluk lendagwima en iluk akluk mondok yup mirik welagagirikmu, mondok yagagi o,” yiluk, yedok hapwak yiluk des erogo yugirigya lagagirik, “An Paulus en Yesus avok yukheraliga yi, Nenowa Inis Ombok Ala en denogo bagagi Mesias ako, araro,” yiluk, mbilinogo yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yugeragagi ako, wene andi avyarat enendawima ndun yi nunggwigya lagagirik, it Yakuri menda nin inim, it Yunani menda Ala enalon umbutu lagagwa nin wisane inim, akwa ininis werek eneyave wisane inim, Paulus Silas inim hondo yi lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Hondo yi lagu lagagwama, it ap Yakuri en, “Nit hekbininiluk it inim hondo yi lagao andi, nit nenanggon!” yiluk, enendawi weyak yugu dugwit, ap enendawi weyak vasat dagalek agarwik menda homakbisiluk, it avakwa o kota andoma nadok-kadok okbisapwak yiluk, enendawima manggugwa. Manggu lagagwama, iren avakwa andoma agarwik ako enendawima malit lagu lagagwama, avakwa wisane nadok-hadok yagan, at Paulus Silas it mberen ombokma enawene mbaluguluk, ap Yason awi enda mbanggugwa menda, ");
INSERT INTO nbq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","it mberen eneyave dek iniselok, at Yason inim, nenaswei nin inim, ligenombolok enasini ap ombok-ombok o kota vagogo agarwik menda enadema bisa lagagwa. Bisa lagu lagagwarik, it yugurugu dugwit, “O yi awi ndi awi ovok erogo weyak ogarit lendagwi menda ako, eneyave yoma wagaoma, ");
INSERT INTO nbq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","at Yason en wogonipas. It ap andi, at Kaisar en wene yugup ako weyak erogo bagu dugwit, Nenasin inis ombok adik ambi Kaisar hak agarik ako andi, inis Yesus aro, yiluk, yagalagwi o,” yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Yugeragagwa ako it enasini ap ombok-ombok o kota vagogo agarwik menda inim, avakwa homagagwa ako inim, enaruk hunggu lagagwarik, nane-hane yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Eke, at Yason aswei inim en heda marek onggo bagu lagagwama, visilogo hekbogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","O hup agya lagagimu, it nenaswei Ala aburi andoma en Paulus Silas it mberen o Mbereya lakbogogwa. Lakbugu lagagwama, o hup lagu lagagwarik, it Yakuri samban ogasagwima nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","It avakwa Setalonika menda andi, enendawi mbuk ovara, it Mbereya menda andi, enendawi mondok sekma, Ala wene yugeragagwa ako, enendawi adenggen vaga wugu lagagwarik, “At Paulus en wene yukneraliga yi, avyarat a, dek a,” yiluk, hutun-howam Ala wene dirup warek bikugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bikugu dugwit, it Yakuri menda wisane avyarat umbutugwa. It Yunani menda akwa ininis werek inim, ap inim, it ogo, wisane at avyarat umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Avyarat umbutu lagagwama, it Yakuri menda o Setalonika ako en at Paulus o Mbereya Ala wene yugeraliga yugwi ako enaruk hunggu lagagwarik, ap akwa o Mbereya menda enendawi burup yupwak yiluk wene enendawima mali wagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","it nenaswei Ala aburi o Mbereya menda ako en Silas Timotius it mberen andoma inigik, Paulus inamut ombok yanggadek embet vaga wolok balagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","It ap Paulus wolok balagagwa ako en o Atena balagu lagagwama, Paulus en, “Timotius Silas it mberen hodo erogo warupwak yiluk, lakbisa omano,” yiluk, wene sadi erogo lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","At Paulus ako it Timotius Silas it mberen wagusawen, o Atena enabyam dugwit, o kota andoma huvuwak moga-moga ap ininggi-vaga ogarek wisane umwa-wasim werek higya lagagirik, endawima en mondok anggon imbitigi. ");
INSERT INTO nbq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Anggon imbitya lagagirik, it Yakuri menda inim, it avakwa Yunani Ala enalon ombasagwi menda inim, it Yakuri samban ogasagwima andoma, “Wene yi avyarat higi,” ombarupwak yiluk, wene mbanggwis, hutun-howam erom hunisagwima andoma inim avuk agya lagagirik, wene yugirigya, ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ogagyama, o akoma it ap yi wene ndi wene adem hivilisagwi menda Epikuros wene vagago welagagwa inim, Setoa wene vagago welagagwa inim, yagan nagu lagagwa ako, werekma, iren, Paulus inim wene onggo-onggo yugu dugwit, “Wene yugwi ako eke hambok yagan landiga menda yi, nggarogonggan wokbaluk yagan landiga embetep?” yugwi, eke, at Paulus en At Yesus avok sek wene ako inim, at iluk akluk mondok yagagi wene inim, yugirigya halok, it nin en, “Dek o. Avakwa adik enomadis awene wolok wagya lagarik, iri higyo o,” yiluk, yugwi, ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Yugu lagagwarik, Paulus wolok, o Areyopagus wene amburup mbalisagwi menda enadema ba wagu lagagwarik, yugu dugwit, “Hat wene adik swi menda mamuleraliga andi, nit ninelup aruguluk yukneran. ");
INSERT INTO nbq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hat wene adik hak yagan lagya hunggurikmu, 'Wene eyave adem yi at yagaliga,' ombaruguluk, iru o,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Andi, yugogogwa ako, enawerek Atena menda inim, huru inisa wagagwa welagagwa inim, it ako en wene adik swi menda adigat hunggwis, yugwi, ogagu dugwit, yi ogagek ndi ogagek ogagatek at welagagwa.) ");
INSERT INTO nbq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","“Iru o,” yugu lagagwama, Paulus ako en o Areyopagus it wene amburup mbalisagwi menda enanggelekma mendek yiluk, yugirigya dugwit, “Hit naswei o Atena menda yi wai. Hit huvuwak amuli hubaluk, henendawi andi vaga adigat vanggabaluk musek lagu hinigis o. ");
INSERT INTO nbq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","O kota yoma hit huvuwak awi valek nil hegek lagya dugwit, huvuwak awi valek ambi, inis ‘Nenasin Inis Nininggut’ salek dirup warek nil higi. Hit hininggut dugwit, inis siyabelagwi ako andi anen yukheraliga o.” ");
INSERT INTO nbq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yugirigya lagagirik, “At wen inim, yi menda ndi menda wen vaga menda ovok inim, ogagagi Ala ako andi, wen-mbogot vagogo aratma, at huvuwak awi ap en vanggugwarikmu akoma agarikbuk o. ");
INSERT INTO nbq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","At adigat en yi ap akwa ndi ap akwa iniluk oginipu, enelagap agavuk wogirigya, yi menda ndi menda wogirigya, ogasigama, At angge ambi dek halok, avakwa enangge ambi At wogorup andi mondok dek o. ");
INSERT INTO nbq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ala en adem ap ambiat vaga yi ap akwa ndi ap akwa ininis unggul adik-adik dombok yi awi ndi awi wigalarupwak yiluk ogagya, o ndugerek-ndagarek ogarit nagu dogopwak yiluk, hologo bagya, eke o yi awi ndi awi dogop hudi ogorogo bugu, ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","At ogagagi ako andi, At Ala adumu dek horok-korok ninim at agarik hegek, belalit lagu dogomundik, 'Avyarat ai,' yiluk enendawima yedok hapwak yiluk ogagagi o. ");
INSERT INTO nbq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Eke, ap hit menda ambi ndawi bagya dugwit, ‘Nit ogo at vaga wigalek aro,’ yiluk, yagagi ako wane-wane, niniluk agurik inim, o wen vaga nagwis inim, nit agurik inim, andi, at vanggabaluk dugwit ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Andi halok, nit Ala vaga wigalek agurik atma, at eyave adem andi, avakwa enendawi hologo baluk mbusi emas vaga, mbusi perak vaga, helep vaga, huvuwak ogovak higirik andi hak, ombarubuk o. ");
INSERT INTO nbq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","O muk en nininggut dugwit ogagu ninigik, Ala en ugun welagagi ovara, yogak andi, nit yi ap akwa ndi ap akwa ovok erogo nenomaluk mondok mbo baluk Yesus ambetaga lagu dogop yiluk yukneraliga. ");
INSERT INTO nbq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ap ambi denogo mondok okbagagi en avakwa ovok ogasagwi wane-wane enowak dilinivup ndugwis ambi hologo bagagi o. Eke, nenowak dilninivisogon ako, nit avakwa ovok nenelup dogoguluk, At ako andi, hambuluk lendagwima en iluk erogo mendok okbagagi o, yiluk, yukheraliga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","At Paulus en hambuluk iniluk arup wene ako iri hugu lagagwarik, it nin ako en Paulus wiyiknom-weyaknom erogo agonda yagagwa ovara, it nin en andi, “Wene andi, vivis ambi inim yukneranok,” yiluk, yugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","at Paulus ako it wene amburup mbalisagwi menda enanggelekma en winggigi. ");
INSERT INTO nbq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wunggu lagagimu, ap ambetap andoma Paulus inim dambunggu lagagwarik, avyarat umbutugwa. Ambi andi ap wene amburup mbalisiga menda inis Dionisius. Ambi andi hwa ambi inis Damaris, eke it nin inim, avyarat umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Andi ogagya lagagirik, at Paulus ako o Atena hekbaluk, o Korendus lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","O Korendus lagya lagagirik, andoma dugwit, ap Yakuri menda ambi o Pondus endaklagagi inis Akwila, eke, ogwa inis Pirikila it mberen inim avuk agagwa. Ap inis ombok Kaisar Kolaudiyus en, “It Yakuri menda o Oroma yoma dogop dek o,” yiluk, wene yugeragagi vaga, ap andi ogwaim ao swi at o Italiya hekbaluk, o Korendus wagagwa. Wagu lagagwarik, andoma inigik, Paulus biginisa lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","It yum tenda eravo valuguluk monggadisagwi menda halok, at Paulus ogo ilup atma, inim dugwit, inim yum tenda eravo valumenda monggatu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ogagu dugwit, at Paulus ako ndugurek-ndagarek it Yakuri samban ogasagwi vaga it samban ogasagwima nonggegek iri dugwit, it Yakuri inim, it Yunani menda inim, it enendawi Yesus avyarat ombarupwak yiluk, Ala wene amburup mbalogo yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Andenam werekma, Silas, Timotius inim, o Makedoniya en wagu lagagwarik, inim dugwit, at Paulus ako yavup adik ambi ogagya lagetek, Ala wene andi adigat yugirigya lagagi. Yugirigya dugwit, “Nenowa Inis Ombok Ala en denogo bagagi Keretus ako andi, Yesus aro,” yiluk, it Yakuri menda yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Yugirigyama, it ako inim ogot-hidugu dugwit, wiyiknom-weyaknom erogo bagu lagagwama, Paulus en, “Hit dek erogo bigigaup andi, an novavut vaga dek o. Hit henovadombok okhedasogom vaga dek erogo bigigayogon. Eke, an yogwak en it ap weram Yakuri dek menda yugeregek nagu dogosogon,” yiluk, it dibapwak yiluk, yum mupwak davulagagi ako yumbulogo enovaga lakbalagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Andi ogagya lagagirik, it Yakuri samban ogasagwima akoma en wulukluk, ap Ala inis siyabaliga menda inis Titiyus Yutus amwa it Yakuri samban ogasagwima horok andenam werekma adema lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","It Yakuri samban ogasagwima enasin Kiripus ako inim, at abut ogwa at amwa agarwik menda inim, enendawi Nenasin Yesus ovaga vanggabaluk avyarat umbutugwa. Eke, it Korendus menda wisane at Paulus en yugeragagi ako hobaluk, avyarat umbutu lagagwama, ivaga wombabogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Andi okbaluk, ndugwis ambi vaga o hup Nenasin Yesus en at Paulus abi vaga yugugu dugwit, “An hinim werekma, ap akwa en vakbagaluk harusogom dekma, halon en mbauk dogobuk. O kota yoma an naburi wisane agarwikmu, yugirigya dogwen,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","yugogogirikmu, Ala wene mamulirigya hegek saut 18 hudi ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ala wene mamulirigya werekma, ap inis Nggaliyo avakwa Akaya menda enowa gubernur mendek hegek, it Yakuri menda ovok dambubaluk ambivaga mendek yugu lagagwarik, Paulus vakbaluk eyave wolok, wene amburup mbalisagwima ba lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Balagu lagagwarik, “At ap yi, Musa wene yugup ako hegek, Ala siyabagu dogop adik ogagu dogopwak yiluk, avakwa enendawi nomalinivit lagya halok, wolok wagyo o.” ");
INSERT INTO nbq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Yugurugu lagagwama, Paulus ako yugeragiluk ogagya hegek, Nggaliyo en it Yakuri ako yugirigya dugwit, “At weyak ambi ombok ogagya, ata it o Oroma menda en wene yugup hegek, mondok adik ogagya, ogaklipmu en, hit ap Yakuri en yuknisagwi andi, naruk des erogo hulili ovara, ");
INSERT INTO nbq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","hit Yakuri wene yugup ogagu dugwit maduk-maduk ogasagwi ako vaga yidibaluk wene wasagwima, anen wene amburup mbalogo yukheraup nanggon. Hit henadik henovadombok hologo bugu dogones,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","wene amburup mbalisagwima andoma en haryogo wibisapwak yiluk yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yugirigya lagagimu, wibugu lagagwama, it ovok en it Yakuri samban ogasagwima enasin at Sotenes ako, vagogo, wene amburup mbalisagwima andenam en watu-sigik, at Nggaliyo en, “It inovadombok,” yiluk, at asuk, mbup yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","At Paulus o Korendus andoma dugwit, ndugwis wisane welagagirik, nenaswei Ala aburi andoma inigik, at Akwila ogwa Pirikila it mberen inim mburi-vaga o Siriya laguluk, ogagu dugwit, at Paulus en ambi ogarup Ala ivaga yugogogi atma, ovok ogagya lagagirik, o Kanggereya andenam en iris mbanggigi. ");
INSERT INTO nbq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Iris mbanggya lagagirik, o Epesus lagagwa. Lagu lagagwarik, Paulus en Pirikila Akwila it mberen andoma bisiluk, at adigat it Yakuri samban ogasagwima nunggwigya lagagirik, it Yakuri menda andoma en hemetugwi, onggo yugirigya, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yugirigya lagagimu, “Ninim yoma ambi inim dogosogom o,” yugogogwa ovara, “Dek o,” yugirigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","lagiluk ogagya dugwit, “Ala en, 'Warup,' imbitya halok, hivis henadema wasogon o,” yiluk, heyaga wakbisiluk, o Epesus andoma en mburi-vaga ");
INSERT INTO nbq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","o Kaisareya lagagi. Lagya lagagirik, akoma en at Paulus o Yerusalem wagya lagagirik, it Ala aburi andoma homagwi ako heyaga wakbisiluk, o Andiyokiya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Andoma ndugwis wisane welagagirik, hivis o andoma hekbaluk, yi awi ndi awi o Nggalatiya, o Virigiya inim, yanonggegek lagya dugwit, Yesus ane wogogwa menda ako enendawi wadok dek dogopwak yiluk, yugeregek lagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Andi yugeregek lagya hegek, ap Yakuri menda ambi awi adem Alesandiriya inis Apolos ako en, Ala wene dirup mbalek ovok elup dugwit, wene enendawi ndin yagaliga menda o Epesus lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Endak At Nenasin Yesus wene at yugugu iniselok, des erogo wogogima, o Epesus lagya lagagirik, Yesus wene avyarat mamulirigya, endawi adenggen vaga yugirigya, ogagya lagagi ovara, Averiniki wambu wagagi inggut atma, we un Yohanes ima wombabugu lagagi wene ako adigat elupma yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","At alon dek dugwit, it Yakuri samban ogasagwima akoma wene yugirigya lagagi. Yugirigyama, it Pirikila Akwila it mberen enaruk hunggu lagagwarik, at Apolos wolok, enamwa lagu lagagwarik, Ala ap akwa enapwa en enagap wendarinivisiga wene ako des erogo mbiluk-mbaluk yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Hivis at Apolos en o Akaya lagiluk ogagya lagagimu, it nenaswei Ala aburi o Epesus menda andoma en, at laup sek yiluk, Yesus ane wogogwa menda o Akaya agarwik en at heyaga warogo wapwak yiluk, dirup mbalogo lakbagagwa. Lakbagu lagagwama, wolok lagya lagagirik, Ala enabwa en okbogogi vaga Yesus avyarat umbutugwa ako inim dugwit, mondok iya dombok yonggarinipu lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","It Yakuri menda at inim ombokma wene onggo-onggo yugu dugwit, at Apolos en Ala wene dirup mbalek vaga, “Nenowa Inis Ombok Ala en denogo bagagi Keretus ako andi, Yesus aro,” yiluk, onggo yugurup dek mondok ane hunik yugirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","At Apolos o Korendus hegek, Paulus ako o Nggalatiya-Virigiya o ndom vaga andoma lagya lagagirik, o Epesus nonggagagi. Nunggwigya lagagirik, Ala wene wogogwa menda nin andoma avuk agu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","it yugirigya dugwit, “Hit avyarat umbutu lagagupmu, Averiniki wogogup a, dek a?” Yugirigya lagagimu, iren, “Dek o. Averiniki andi werek a, dek a? Nit ao ninunggut at agurik o.” ");
INSERT INTO nbq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Yugugu lagagwama, “Andi halok, nano wene hunggu lagagupmu, ima wombabigigagwa?” Yugirigya lagagimu, iren, “Dek o. At Yohanes yagagi wene hunggugup ako vaga ima wombabininggugwa,” yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Yugugu lagagwama, at Paulus en, “At Yohanes ima wombabugu lagagi andi, enomaluk mbo bagu-selok, ima wombabugu lagagi. Aren avakwa wisane yugirigya dugwit, ‘At an nambetaga warisogon andi, henendawi ovaga vanggabaluk avyarat umbutu dogones,’ yugirigya lagagi andi, eyave Yesus aro.” ");
INSERT INTO nbq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Yiluk yugeragagi ako enaruk hunggu lagagwama, Nenasin Yesus inis vaga ima wombabogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ima wombabugu lagagwama, Paulus inggis inunggul vakbugu hegek, Averiniki enovaga wambu wagya lagagimu, it ap akwa enane unggut adik-adik menda yugwi, Ala en enendawima yugirigya hegek, yugurugwi, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","It ap Averiniki enovaga wambu wagagi ako andi, eneyave dambulik, 12 hudi agagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Andi okbaluk, at Paulus en it Yakuri samban ogasagwima nunggwigya lagagirik, alon dek dugwit, Nenowa Inis Ombok Ala en denogo bagagi ako avema bininaup wene andi, “Avyarat yagaliga,” ombarupwak yiluk, wene mbilinogo yugeregek adigat ogagya hegek, saut henggam ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Yugirigya lagagi ovara, it nin enendawi lakot dugwit, “Avyarat ombarup, nenanggon,” yiluk, ombok vaga Sup Yesus Ambetaga Lagu Dugwit Iniluk Mondok Dogop Wene ako, wiyiknom-weyaknom erogo bagu lagagwama, at Paulus en it hekbisiluk, Yesus ane wogogwa menda ako enadigat wogonombolok, ap Tiranus sekolah awi vanggigirikmu andoma nunggwigya lagagirik, ndugerek-ndagarek inim wene yugirigya, iren hemetugwi, ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ala wene yugirigya hegek, tahun mberen ogagagirikmu, it Yakuri menda inim, it Yunani menda inim, o Asia welagagwa ako ovok erogo Nenasin Yesus wene enaruk hunggu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ala en okbagya hegek, Paulus en nggarogo ogarubuk menda mondok iya erogo ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nggarogo ogarubuk menda iya erogo ogagya lagagi andi, at adigakot inim, asum mudis arugwi en yiluk yirik welagagi menda inim, wolok lagu lagagwarik, it ap akwa aup edup ako, enovaga bugusigik, aup edup ako dek agwi, madis enendawima nonggagagi ako nggigilogo wibugu, ogagya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ogagusigik, ap Yakuri madis ap akwa enendawima nggigilogo wikbigik nagu lagagwa menda en, avakwa madis enendawima nonggagagi halok, Nenasin Yesus inis vaga, madis nggigilogo wibisaguluk yugurugu dugwit, “Paulus yugeraliga menda Yesus ako inis vaga wilin,” yiluk, ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ogagagwa ako andi, it ap imam Yakuri menda enasin Sekewa aburi eneyave 7 en, anderogo at ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Anderogo ogagagwa ovara, madis ako en, “Yesus andi nelup, eke, Paulus ogasiga menda ogo, an nelup ovara, hit yi andi, sani?” ");
INSERT INTO nbq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yugirigya lagagirik, ap madis alon edok erek endawima welagagi ako en soklok erogo enovaga ndan iri lagagirik, sovalogo bisiluk, inita lagagimu, it ako umwa akoma en enagap sigam enamuya ndek yagan, hoda sak yagan lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ogagao yugwi ako, it ap akwa o Epesus agarwik Yakuri menda inim, Yunani menda inim, ovok erogo enaruk hobaluk enalon agu lagagwarik, Nenasin Yesus inis siyabagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Avakwa avyarat umbutugwa menda wisane wagu lagagwarik, “Nit ogo weyak ogagu lagyo o,” yiluk, ombok vaga enomaluk vaganggu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","It madis vagogo nin ogo, madis inis vaga ogwaruguluk mbuku mbalek bikegek ogagu lagagwa ako, wolok ap akwa ovok inivaga hali hunggugwa. Eke, enambuku hali hunggugwa ako onggo ininggis dingginggu dugwit, yoparip wisane, satu milyar wane-wane hagagwa ovara, hegek hali hunggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nenasin inis ombok Yesus ane wokbaluk anderogo ogagu lagagwa vaga, Ala wene andi wigalit lagya halok, avakwa en wene andi, dibagwi, wugwi, ogarit lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","O Epesus andoma anderogo ogagu lagagwama, at Paulus ako o Makedoniya inim, o Akaya inim, yanonggegek ogarit o Yerusalem lagiluk, endawi imbitigirikmu, “O andoma lagya dogomindik, o Oroma akoma ogo layogon aro,” yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Iri lagagirik, at yonggat hegek eneyave mberen Timotius Eratus enendak o Makedoniya lakbugu lagagirik, lagusigik, at o Asia ambukum dogogiluk mbup yagagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","O andi hudi Sup Yesus Ambetaga Lagu Dugwit Iniluk Mondok Dogop Wene ako vaga nane-hane ombok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ap mbusi perak ogasiga menda ambi inis Ndemeteriyus en enomadis Aretimis awi mbusi perak agut ogovak higirisiga mendama, onggo lugut hedaguluk arwi wisane yugirigya hegek ogovak higitwis selok, onggo ombok wogirigya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","At arwi ako inim, it ap nin yavup andi menda ogagu lagagwa inim, homakbisiluk, yugirigya dugwit, “Narwi o, nit ogasagwi yi vaga onggo ombok hedelagwi henelup ovara, ");
INSERT INTO nbq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ap inis Paulus ako en, ‘Huvuwak avakwa en yi ininggi-vaga ogovak higirik andi, eve menda dek,’ yagaliga ako, o Epesus yoma en adigat dek. Ata, o Asia yi awi ndi awi andoma ovok erogo avakwa wisane enendawima malit lagya dugwit, nomalinivit lagya hinil hugwi, henaruk hunggwis, ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Anderogo atma, nit onggo hedelagwi yi adigat inis dek arisogon dek ovara, nit o Asia yoma ovok agurik inim, it yi awi ndi awi ovok agarwik inim, nenomadis hwa ombok Aretimis nit ovok erogo ninisa siyabelagwi ako, at awi valek meyan umbutu dugwit, at agayuk dek, anye werek ako dek aga higyo, yugusawen yiluk, nenalon aga o,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Yugeragagi ako enaruk hunggu lagagwarik, enaninis ane yagan lagu dugwit, “Nit Epesus menda nenomadis Aretimis ombok aro,” yiluk, yanjak-hanjak yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Yanjak-hanjak yugu lagagwama, o kota andoma en ovok nane-hane yugu dugwit, it ap o Makedoniya menda Paulus inim nagu lagagwa, Nggayus Aritakus it mberen vaginiviluk, wene homarisagwima ambi homago hoda vupuk bisa nonggagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bisa nonggagagwarik werekma, at Paulus ako, ap wisane homari lagagwa ako enanggelekma nunggwigiluk ogagagi ovara, it Yesus ane wogogwa menda ako en, “Vuk,” yiluk, sovabaluk werekma, ");
INSERT INTO nbq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","it o Asia menda enasini ap ombok-ombok at Paulus inim hunik welagagwa ako en, o wene homarisagwima akoma nunggwigya hawen, Moga, yugurupwak yiluk, enarwi lakbisa lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Yugusigik, it homagagwa nin wisane ako en, 'Nggarogo yiluk homagyo' ininggutmu, wene ambi yegek, ambi yegek, yugu dugwit, nadok-kadok yugusim, ");
INSERT INTO nbq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","it Yakuri menda en ap inis Alesander ako vagago vokal hegek enelesema mendok okba nonggagagwarikmu, it avakwa nin en, “Yukneran o,” yugugu lagagwama, wene sigam erogo yugeragiluk inggi-vaga, “Mbauk dogones,” yugeragagi ovara, ");
INSERT INTO nbq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","at Alesander ako ap Yakuri menda yedok hugu lagagwarik, “Nit Epesus menda nenomadis Aretimis ombok aro,” yiluk, enane ombok vaga hunik adigat yugusigik, mo il mberen agagi. ");
INSERT INTO nbq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mo il mberen agya lagagimu, ap sekerataris kota Epesus en, “Henane moga o,” yugirigya lagagimu, mbup erek inigik, yugirigya dugwit, “Hit ap Epesus menda yi, wene ambi yukheraliga o. At nenomadis inis ombok Aretimis awi valek inim, helep mbogot-vaga en wambu wagagi, “Nenomadis yi aro,” yiluk, agut vagogo agurik ako inim, andok ako nit Epesus menda atma, yi ap akwa ndi ap akwa ininggutmu, yagalagwi? ");
INSERT INTO nbq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Dek o. Wene yi huluk dek, avyaratma, hit henendawi dek ovagak akluk yi ogagek ndi ogagek ogarubuk. Mbauk dogones o. ");
INSERT INTO nbq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","It ap yi, nenomadis awi valekma yi menda ndi menda agarik ako wugwi, eyave miyuk-meyak erogo bagwi, ogagetek inigik, wogonombolok wagepma, ");
INSERT INTO nbq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","it wene amburup mbalisagwi menda inim, it nenasini pemerintah menda inim, agarwik atma, at Ndemeteriyus inim, aori mbusi perak ogovak higirisagwi menda inim, ako en, 'Ninawene amburup mbalupwak o,' umbutwi selok, it enadema andoma yugera lapwak o. ");
INSERT INTO nbq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Eke, wene ambi adik werek umbutu hiniselok, hivis nenasini inim ovok homakbaluk amburup mbalusogom o. ");
INSERT INTO nbq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Wene yogak avok yagalagwi yi, iren ‘Nggarogo yiluk nane-hane yugu dugwit, weyak ogagep o?’ yuknirugwi selok, adem dek hegek, ap yi wogonombolok wagyoma, nit onggo nggarogo yugerabuk erek,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","yugirigya lagagirik, it ap akwa homago ako “Wilitales o,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Wene nane-hane yugu lagagwa ako dek agya lagagimu, Paulus en Yesus ane wogogwa menda ako warupwak yiluk, eneyanggup yugeragagi, wagu lagagwama, enendawi aik wakbugu lagagirik, “Yogo,” yugerelok, o Makedoniya lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Lagya lagagirik, o yi awi ndi awi andoma ya nonggegek lagya dugwit, enendawi aik wakbigik lagagi-lagagi o Yunani ari lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Andoma hegek saut henggam nggao iri lagagimu, o Siriya mburi-vaga lagiluk ogagya lagagimu, it Yakuri en enendawi ambi okbaluk, “Warup,” hunggu lagagwama, “Sup neyami vaga o Makedoniya laup,” imbitigi. ");
INSERT INTO nbq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","At inim lagagwa ako andi, ap Mbereya menda Pirus abut Sopater inim, o Setalonika menda Aritakus, Sekundus inim, o Nderebe menda Nggayus, Timotius inim, eke, o Asia menda Tikikus, Toropimus inim, lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","It andi, ovok enendak o Terowas lagu lagagwarik, nenabyam welagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Eke, nit ako isogo Roti Virisigadek Menda ako nelok, o Pilipi en mburi vaga lagu dugwit, ndugwis 5 hudi welagagurik, o Terowas nenaswei nenabyam werekma avuk agagup. O Terowas andoma ndugwis 7 hudi welagagup. ");
INSERT INTO nbq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","O hari minggu vaga erom ugurogo naguluk homagagurikmu, at Paulus hutun lagiluk ogagya dugwit, wene adup yugurigya hegek, o hup ilikis agagi. ");
INSERT INTO nbq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Eke, nit homagagup o tingkat winimen akoma hali undwa wisane yevetbaluk, ");
INSERT INTO nbq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","at ako wene adup likelok lagya dugwit, apsawe ambi inis Eyotikus yendela mbalek vaga horaik werekma, nggungguk nogo yugu lagagimu, nogo agako agya dugwit tingkat tiga en nggedek wombagagi. Nggedek wombagagirikmu, hombagagi. Hambigya lagagimu, lekugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulus ako wambigya lagagirik, ambor seve yiluk, elola wigya lagagirik, “Henendawi mbigya yubuk. Eyave iluk agarik,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Yugerelok, eyami vaga inggya lagagirik, roti ugurogo nelok, at inim wene mbanggu-sigik, o yanggo yigiluk het lagatu hegek, hekbisiluk winggigi. ");
INSERT INTO nbq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wunggu hegek, it avakwa en avyak ako iluk wolok lagu lagagwarik, enendawi sek adenggen wisane hagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Eke, Paulus en, “An wen vaga o Asos laup imbitirikmu, hit henendak o Asos andoma nabyam ari lales,” yuknirigya lagagimu, at wen vaga lagya hegek, nit nenendak mburi-vaga o Asos abyam ari lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","O Asos andoma avuk agya lagagimu, Paulus mburi-vaga nunggwigya lagagirik, ninim o Metilene wagagup. ");
INSERT INTO nbq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Andoma en wagu lagagurik, heveret o laut is enggema inis Kios malhegek, dogovit o Samos ari wagagup. Eke, dogovikak o Miletus ari wagagup. ");
INSERT INTO nbq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ari wakluk, at Paulus en, “Hari Pendakota o Yerusalem neyagek ogarup atma, o Asia adigat arabu neyagek horok vanggo iri hawen, o Epesus nonggegetek mbikit o Yerusalem hodo erogo lasogom,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Anderogo, imbita lagagirik, Miletus nunggugu lagagurik, andoma en at Paulus ako, it Ala aburi enasini ako warupwak yiluk, o Epesus enayonggo lakbogogi. ");
INSERT INTO nbq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Enayonggo lakbugu lagagwarik, at adema wagu lagagwama, yugurigya dugwit, “An o Asia yoma henadema wagagis hudi en ninim dugwit ogagya lagagis ako henelup. ");
INSERT INTO nbq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","It Yakuri en enendawi ambiat okbaluk, an naruguluk hologo baluk anggin novaga banunggu-sigik ovara, Nasin ayeloman dugwit, nendawi seve yiluk, henayup yagya dugwit, yonggat hinipu lagagis. ");
INSERT INTO nbq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Sek okbigigaup wene ako, nin yup nalon en hekbagya, nin yukhirigya, ogagya lagetek. Ombok vaga inim, henamwa vaga inim, mamulheregek lagya lagagis henelup. ");
INSERT INTO nbq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mamulhirigya lagagis ako andi, hit Yakuri menda inim, hit Yunani menda inim, hit weyak ogasagwi henendawi wenggelogo, mbo bagu dogomundik, Ala adema wagwi, henendawi Nenasin Yesus Keretus ovaga vanggabaluk avyarat umbutwi, ogarovovok yiluk, des erogo yukhirigya lagagis.” ");
INSERT INTO nbq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Eke, yogak andi, Averiniki en nomalik-nomalek yuknugu halok, o Yerusalem en okneraup ninggut hegek ovara, layogon. ");
INSERT INTO nbq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ndugwis ambi vaga o ambima yugirigya, ndugwis ambi vaga o ambima yugirigya, ogarit lagyama, ‘Heda makitwis, anggin-mbanggin hovaga bagagwi, ogarusogom,’ yiluk, Averiniki en vagalogo yuknisiga nelup aro. ");
INSERT INTO nbq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Anderogo ovara, An neyave niluk dogop iya dek. Ata, Ala nenabwa en we un okbininaliga menda sek wene yugurigya dogogiluk, Nasin Yesus en yavup andok okbaninggigi ako, hekbagetek weralogo ogarup andi adigat iya ombasigama, ogarit landiga.” ");
INSERT INTO nbq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Eke, yogak andi, an ako Nenowa Inis Ombok Ala en denogo bagagi ako avema bigigaup wene yukhirigya lagagis hit yi, hivis ambi yukheregek wagya hinil neyagupuk andi, an nelup. ");
INSERT INTO nbq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Ala endawi hologo bagagi wene ako nin hekbagetek, ovok yukhirigya lagagisma, hit ambi dek erogo bigigaup halok andi, an novadombok dek. Hit henovadombok okhedasogom vaga dek erogo bigigayogon, yiluk, o yogak yi vaga avyarat yukheraliga.” ");
INSERT INTO nbq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“At Nenasin Yesus amuya vaga Ala aburi homago enonggo bagagi ako andi, at andomba ovagak atma, enaruwam dogovovok yiluk, Averiniki en mikkinipigima, hit henendawi suwam wakidugu dugwit, it inim des erogo yugurugu dogones. ");
INSERT INTO nbq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","An hekbigiluk lagya neyagek, yangge do henanggelekma nunggu wagu dogomundik, hekbigigasogom dek hivit hinivusogom andi, an nelup aro. ");
INSERT INTO nbq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hit menda en ogo, henanggelekma en mendok yiluk, hit Yesus ane welagwi menda henendawi nomalhinivuguluk, huluk wene ako andi sek wene heda yukhurugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Anderogo atma, henendawi suwam wakidugu dogones! O hup dingga mbup yegetek henayup yagya dugwit, henadik-henadik hurimbis yukhirigya neyagek, tiga tahun ogagagis ako henendawi wenggenggu dogones. ");
INSERT INTO nbq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Eke, yogwak andi, At Ala henabwa en okbigigaup wene andi vaga, henendawi hoda erogo bigigiluk at aburi at ake denek halok, mavorangge hak enake vulogo bogogi ako hinim andok arovovok yiluk, Ala avema bigigigis o. ");
INSERT INTO nbq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Hit henayoparip mbusi perak emas inim, henasum inim, an hogop imbitya lagibuk o. ");
INSERT INTO nbq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ninangge dek halok, 'Wokneres,' andi yukhirigya lagibuk. Ata, an nake inim, it ninim lagya lagagis enake inim, andi, an ninggis anye vaga en adigat ogarogo hidigya lagagis henelup aro. ");
INSERT INTO nbq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","At Nenasin Yesus en iri dugwit, 'Hedelagwi vaga enadenggen maduk hugwi, eke, wogorugwi vaga andi, enadenggen wisane hugwi, ogasagwi o,' yagagi ako, imbitya dugwit, an ovok erogo ogagya lagagis ako andi, yavup sadida-mbakdida ogagu dugwit, it enanye dek menda yonggarinipu dogop, higyo, yiluk, ombarovovok yiluk, ogagya lagagis,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Wene andi mondok yugirigya lagagirik, it ovok inim enerambo yunggubaluk hora yiluk, samban ogagagi. ");
INSERT INTO nbq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Samban okbugu lagagirik, Paulus eyave enelola okbaluk, ayup yagwi, heyaga warogo dinggik-hambuk okbagwi, ogagek adigat ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","At Paulus en, “An hivis nelose ambi neyagup dek,” yugeragagi andi vaga enendawi mondok mburup yugu lagagwarik, ayup yagwi, heyaga wakbagwi, okbagu lagagwarik, wolok mburis is amban vaga werekma andenam ba lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nenendawi it vaga ngges iri hegek, hekbisiluk, mburi-vaga nunggugu lagagurik, andoma en mbikit o is enggema Kos lagu lagagurik, hutun en o Orodos nunggugwi, andi okbaluk, o Patara nunggugwi, ogagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","O Vatara akoma werekma, mburis adik o Venisiya laguluk ogagu lagagwama, ninim nunggugu lagagurik, lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Lagu lagagurik, o Sipurus neneyave hwarenggan ninil malhegek lagu dugwit, yi menda ndi menda mburi-vaga yidik ako o Tirus hudilogo womba bagek laguluk, o Siriya nonggagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Andoma nunggugu lagagurik, Yesus ane wogogwa menda andoma haverinipu lagagurik, ninim dugwit, ndugwis 7 welagagup. It andoma menda ako Averiniki en yugurigya hegek Paulus yugugu dugwit, “Hat Yerusalem labuk o,” yugogogwa ovara, ");
INSERT INTO nbq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","andoma dukluk laup ako ndatak agya lagagimu, it Yesus ane wogogwa menda ako enabur-enogwa inim ovok erogo o kota en woknenombolok is omban vaga binani lagu lagagwama, nenerambo yunggubaluk samban ogagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Samban okbaluk, it ninim deden war-wat yugu lagagurik, enamwa lagusigik, nit mburi vaga nonggagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","O Tirus andoma en wagu lagagurik, o Votolemais nunggu wakluk, andoma nenaswei Ala aburi heyaga wakbisiluk, ninim ndugwis ambi welagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ndugwis ambi welagagurik, heveret wunggu lagagurik o Kaisareya nonggagagup. Nunggugu lagagurik, o Yerusalem en it ap 7 erom sumburerapwak yiluk miginipugwa menda ako ambi sek wene yugeregek landiga menda Pilipus ako amwa nunggu lagagurik, ninim welagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","At aburi hwavyak ndugum eneyave 4 Ala en enendawima yugurigya hegek yugurugu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ninim dugwit, ndugwis maren hudi welagagurikmu, ap navi Ala en yugugu hegek yugirigya lagagi menda ambi inis Agabus o Yudeya en nenadema wambu wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nenadema wambu wagya lagagirik, at Paulus amboranis visilogo inggis-isok heda makidiga lagagirik, iri dugwit, “An hamboranis vaga makidigi yi hak, it Yakuri o Yerusalem menda en ap amboranis werek ako, anderogo at heda marogo it weram Yakuri dek menda wogorasogom, yiluk, at Averiniki en yuknugu halok, yukheraliga o,” yukneragagi. ");
INSERT INTO nbq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Yukneragagi ako nenaruk hobaluk, it andoma menda ninim en Paulus yugugu dugwit, “O Yerusalem andoma dagabuk,” yiluk, nenabwa edok dugwit, yugugu lagagumu, ");
INSERT INTO nbq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","at Paulus en, “Hit an nayup yagwi vaga nendawi anggin arupwak yiluk, nggarogo yiluk yagalagwi? An Yerusalem dagasogon atma, andoma neyagek Nasin Yesus ake heda maknitu-selok andi, sek aro ombasiga. Eke, narusogom halok ogo, sek atma, hit nggarogo yiluk yagalagwi?” yukneragagi. ");
INSERT INTO nbq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Yuknirigya lagagimu, yugigik adigat ogagagup ovara, hunggitek welagagimu, “Ala endawi ombasiga adigat arumwak,” yiluk, mbup yagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Andoma welagagurik, nenayum yubetaup mbalogo hedelok Yerusalem unggugup. ");
INSERT INTO nbq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","It Kaisareya menda Yesus ane wogogwa menda nin ako en ap Sipurus menda ambi o endak Yesus ane wogogi inis Manason amwa akoma ninim dogoguluk, woknenombolok binani unggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","O Yerusalem nunggu lagagumu, nenaswei Ala aburi ako en enendawi adenggen vaga wokninipugwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wokninipu lagagwama, nogo yiluk, hutun at Paulus ninim it Ala aburi enasini ovok erogo werekma Yakubus bika lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bikugu lagagurik, at Paulus ako en heyaga wakbisiluk, Ala en okbagya hegek, it weram Yakuri dek menda ogonivit lagya lagagi ako ovok erogo mbilinogo yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Mbilinogo yugeragagi ako enaruk hunggu lagagwarik, Ala siyabagagwa. Siyabagu lagagwarik, it Ala aburi enasini ako Paulus yugugu dugwit, “Nenaswe, Paulus wai. It Yakuri menda yi ap ndi ap ovok Yesus avyarat umbutugwa ovara, it ovok Ala wene Musa dirup watigi ako enendawi andi adigat wenggelek dugwit, ogarit lagwi yi, inisaliga? ");
INSERT INTO nbq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ap en yugurugu dugwit, ‘At Paulus en, it Yakuri menda ap-akwa weram menda enanggelekma agarwik ako mamulirigya dugwit, “Ala wene Musa dirup watigi ako mbo bas,” iri dugwit, “Hit henaburi enagamut mbanggwis, it ap Yakuri ogasagwi menda ako ogagwi, ogarubuk,” yugeraliga,’ yiluk, yugeregek nagwis ako it enaruk honggao. ");
INSERT INTO nbq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Eke, hat wagen enaruk hulusogom atma, nit nggarogo ogaruk? ");
INSERT INTO nbq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","yiluk, wene mbanggup yukhisagwi yi ogaru.” “Ap eneyave 4 en ambi ogarup hologo Ala yugigao ninim werekma, ");
INSERT INTO nbq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","yogak hat hinim lagya dogomindik, nit Yakuri nenandogon it ap imam en neneyave ‘horek’ hak arupwak yiluk is ndilisagwi andi, it eneyave is ndibugwis, hat ogo heyave anderogo is ndibagagwi, ogagu dogomundik, it iniris mbalupwak yiluk, Ala ake belagwi ako haren belalo. Andi ogarimi vaga Ala wene yugup Musa dirup mbanggigi ako hat ogo ogagya heyalok, Paulus ogasiga hunggup ako, adem dek hegek yagalagwi inigup, ombarusugom atma, anderogo ogarit elalo. ");
INSERT INTO nbq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Eke, it weram Yakuri dek menda en Yesus ane avyarat ombasagwi ako andi, nit un surat vaga watu dugwit: Wam madis anggom warek naup moga. Amuya naup moga. Yi menda ndi menda honak warek amuya winggitek halok naup moga. Wanggis waup moga, yiluk, hologo bagagup ako vage dirup mbalogo lakbogogup,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yugugu lagagwama, nogo yiluk, hutun, Paulus en ap eneyave 4 ako wogonombolok lagya lagagirik, it inim is enovaga ndibogogwa. Ndibugu lagagwama, Ala awi valekma nunggugu lagagwarik, it is enovaga ndibisiluk dogop hudi andi, o ngga vaga atma akluk enadik-enadik Ala ake baup ako yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ndugwis 7 hudi agya hegek, it Yakuri o Asia menda Paulus eyave Ala awi valekma andoma inil hugu lagagwarik, it avakwa ombok homago ovok enendawima manggu dugwit, eyave vakbaluk, ");
INSERT INTO nbq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Ap Iserali menda wai! Hodo erogo vagarimanes! Ap yi en, yi awi ndi awi mamuleregek lagya dugwit, nit nenavok mbalit lagya, Ala wene yugup Musa dirup mbanggigi ako inim, Ala awi valek yi inim, weyak erogo baik lagya, ogasiga menda yi vakneranes. Eke at ako en ap Yunani menda wogonombolok, Ala awi valekma nunggu wagu lagarwik, o mogama weyak erogo bagas,” yiluk, enane yanjak-hanjak yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(At Toropimus o Epesus menda Paulus it mberen o kota Yerusalem nagwis inigu lagagwarik, Paulus en wolok, Ala awi valekma nonggagao ai, ombakluk, yagagwa.) ");
INSERT INTO nbq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Yugurugu lagagwama, o kota akoma avakwa ovok mendok yiluk, vupuk homari wagu lagagwarik, Paulus ininggis vakbaluk, Ala awi valekma en nggigilogo wibaluk, sogop latugwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nggigilogo wibagu lagagwarik, waruguluk ogagusigik, “O kota Yerusalem ovok nadok-kadok ogasagwi,” yiluk, it yegen werek Oroma menda enasin ako yugiri lagu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","at ako en arwi yegen werek menda inim, it enowai enaruwam agarwik inim, wogonombolok, vupuk it avakwa homago ako enadema lagagwa. Avakwa en it yegen werek menda enasin inim wagwi inil inigu lagagwarik, it Paulus watwis ako mbup yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mbup yugu lagagwama, at yegen werek menda enasin ako wagya lagagirik, Paulus inggis vagogo, “Mbusi heda mberen vaga mares,” yiluk, yugirigya lagagirik, “Ap yi sa? Eke, at ngga ogaga halok yagalagwi? Eres,” yiluk, hemerinipigi. ");
INSERT INTO nbq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Hemerinipu lagagimu, it avakwa wisane homago ako enane ombok vaga ambi yegek, ambi yegek, yugu dugwit, enane nadok-kadok yugu-selok, adem belalup meyan agya lagagimu, “Wolok o nit yegen werek menda nenamwa akoma elales,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Yugeragagi wolok ndanggi vaga ari wagusim, it avakwa wisane homago ako waruguluk linggililuk lagu lagagwama, it yegen werek menda ako en Paulus eyave legogo o it enamwa maba laguluk, wolok lagusigik, ");
INSERT INTO nbq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","it avakwa wisane homago ako musek yanjak-hanjak yagan wagu dugwit, “Mondok elese dek erogo basogom!” yagan lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","O yegen werek menda enamwa mabaguluk ogagusigik, Paulus en it ap yegen werek menda enasin ako yugugu dugwit, “Nasin o. An wene ambi yukhisogon.” Yugugu lagagimu, Paulus yugugu dugwit, “Hat Yunani enane helup a?” ");
INSERT INTO nbq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Yugugu lagagirik, “O endak, ap Mesir menda ambi en, 'Nenadik dogop,' yiluk, avakwa enendawi nggaganggu dugwit, sale-vale ogonetek lagya lagagirik, ap enedup enayegen werek menda wisane empat ribu wogonombolok, harumu avakwa dekma bisa lagao ako andi, hat a dek a?” ");
INSERT INTO nbq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Yugugu lagagimu, Paulus en, “Andi an dek o. An ap Yakuri menda aro. Eke, o Kilikiya kota Tarusus akoma, 'Ai, andoma dukli ale,' ombasagwima endaklagagis nawerek atma, it avakwa an wene ambi yugeraup sek a?” ");
INSERT INTO nbq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yugugu lagagimu, it yegen werek menda enasin ako en, “E o. Yugeran,” yugugu lagagimu, Paulus ndanggi vaga mendek dugwit, inggi-vaga, “Mbauk dogones,” yugurigya lagagirik, enane mbup yugu lagagwama, Iberani enane vaga yugurigya dugwit: ");
INSERT INTO nbq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Nowa-nasin o. Hit wene novaga lobalogo bagep ako adem mbilinogo yukherayogon, henaruk holek dogwes,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Iberani enane vaga yugirigya enaruk hunggu lagagwarik, enane ovok mbup yugu lagagwama, at Paulus en yugurigya dugwit ");
INSERT INTO nbq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“An yi, ap Yakuri menda. Eke, o Kilikiya kota Tarusus endaklagagis ovara, o kota yoma dugwit sawe agagis. Ap Nggamaliyel en wene des erogo mamulnugu dugwit, Musa wene yugup nenasini nenombawi ogagu lagagwa ako inim yuknugu lagagi. Yuknugu lagagi andi vaga hit yogak henendawi henanggon dek dugwit Ala ake yiluk ogasagwi hak, an ogo anderogo at Ala ake yiluk, nendawi nanggon dek dugwit ogagya lagagis. ");
INSERT INTO nbq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ogagya dugwit, it avakwa Sup Iniluk Dogop Wene musek lagwi ako, enarigiluk anggin-mbanggin oginipu dugwit, ap inim, akwa inim, heda magago lembaga mabugu lagagis. ");
INSERT INTO nbq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","An ogagya lagagis andi, at imam inis ombok winimen agarik ako inim, nenasini wene amburup mbalisagwi menda inim, inil neyagu lagagwama, iren yukheramwak. Eke, it ako en enaswei o Ndamasik agarwik ako inil hapwak yiluk, dirup warogo woknugu lagagwama, wolok, it ap Sup Iniluk Dogop Wene musek lendagwi ako heda magogo o Yerusalem o yoma en anggin-mbanggin okbisauguluk, enamusek o Ndamasik lagagis,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Yugirigya lagagi ambi inim yugirigya dugwit, “O Ndamasik horok vanggo yi lagya lagagimu, o dingga supuk erogo mbogot-vaga en abya yovalevet higya lagagimu nil amumwis igya dugwit nadema wombaba wagagi. ");
INSERT INTO nbq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Wombaba wagya lagagimu, an wema ndun yi wombagagirik werekma, ane ambi iri dugwit, ‘Saulus. Saulus. Hat nggarogo yiluk anggin-mbanggin erogo narit landiga?’ yiluk, ane iris naruk hunggigis. ");
INSERT INTO nbq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Iris naruk hunggu lagagirik, ‘Ai, Nasin. Hat sa o?’ Yugugu lagagimu, ‘Dek o. Hat anggin-mbanggin erogo narit landiga Yesus Nasaret menda an aro,’ yiluk, yuknogogi. ");
INSERT INTO nbq_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","An ninim lagagup ako abya adigat hagagwa ovara, at ane yuknogogi ako andi, dibagatek at welagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Yuknugu lagagimu, ‘Nasin o. An nggarogo ogarik?’ yugugu lagagimu, At Nasin en, ‘Mendok yiluk, o Ndamasik andoma elak. Andoma nunggwigya heyalok, hat yi ogagek ndi ogagek ogagya dogop hologo bagagi ako yukhirisogon.’ ");
INSERT INTO nbq_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Yuknugu lagagimu, abya yevedogo mo inggis-anggangga hak ogagagi vaga nil mbuk agya lagagimu, an ninim wagagis ako en ninggis vaknombolok Ndamasik bani lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Bani lagagwa, o Ndamasik andoma werekma ap ambi inis Ananiyas nadoma wagagi. Ap andi, Ala alon imbitya dugwit, Ala wene yugup Musa en dirup watigi ako des erogo ogagya lagagi, it ap Yakuri andoma ovok erogo agayuk wutu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","At ako an nadoma mendek yi wagya lagagirik, ‘Naswe Saulus wai, hil awiya akluk yokanen,’ yiluk, ao yuknugu hegek nil awiya agya lagagirik, eyave hagagis. ");
INSERT INTO nbq_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Higya lagagimu, aren yuknugu dugwit, ‘Nenombawi Enasin Ala endawi ombasiga menda helup agya, At Endawi Mot Sek Adigat Agarik ako hil higya, eke, At ane iris ako haruk hunggu, ogagya dogonyok yiluk denogo bagagagi o. ");
INSERT INTO nbq_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Hil higya, iris haruk hunggu, ogagen ako vagalogo yi avakwa ndi avakwa ovok yugeregek lagya dogonyok yiluk, denogo bagagagi. ");
INSERT INTO nbq_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Eke, yogwak andi, hendawi yunggup yegek ogarubuk. Mendok yiluk, ima wombabagasogon. Homaluk ako Hasin Inis Ombok Yesus en hotheramwak yiluk, hodo erogo nggino yuguru,’ yiluk, yuknogogi o” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Yugurigya lagagirik, Paulus en ambi inim yugurigya dugwit, “Andi okbaluk, neyami vaga o Yerusalem yoma wagya lagagirik, Ala awi valekma samban ogagyama nogo heda nabi vaga higya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nasin en yuknugu dugwit, ‘An navok vagalogo yugerami ako hulusogom dekma, o Yerusalem hekbaluk, hodo erogo o adikmu hunogoma elak.’ ");
INSERT INTO nbq_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Yuknugu lagagimu, ‘Nasin o. Avakwa Yakuri samban ogasagwima dombok it ap enendawi hovaga vanggabaluk avyarat umbutugwa ako, heda marogo lembaga mabugu, yawi inita, ogagya lagagis ako, enelup o. ");
INSERT INTO nbq_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Eke, Hat havok yugirigya lagagi Sepanus ako, watu-sigik, an andenam dugwit, “At ogo Warup”, ombakluk, sogwes yum weram menda nggolalek andenam vagogo welagagis,' yiluk, yugogogis. ");
INSERT INTO nbq_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Yugugu lagagimu, Nasin en an yuknugu dugwit, ‘It ap weram Yakuri dek menda agarwikmu o adumu andoma lakbagaup, imbitirikmu, elak,’ yuknugu hagagis,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","It avakwa homago ako at Paulus ap weram Yakuri dek menda Yesus wene ako yugeregek laup wene andi iris enaruk hobaluk, “Ap yerogo menda yi, iluk dogop dek. Mondok elese dek erogo basogom,” yiluk, enane yanjak-kanjak yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Enane yanjak-kanjak yugu dugwit, sogwes yum nggolalogo mbo bagwi, wen mupwak havedogo lisilogo lakbagwi, ogagusigik, ");
INSERT INTO nbq_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","it ap yegen werek menda enasin ako en, “Ap yi, o nit yegen werek menda nenamwa mabagu dogomundik, mbup yawi watu dugwit, adem ngga ogaga vaga warupwak yiluk yanjak-kanjak yagalagwi ako, aigwakma womanes!” ");
INSERT INTO nbq_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Aori yugurigya lagagimu, wolok lagu lagagwarik, yawi warupwak yiluk heda magu lagagwama, it ap yegen werek menda enasin avema menda ambi o andenam werekma, Paulus en at yugugu dugwit, “Hiren ap Oroma menda sek ogaga weyak ogaga owak dibagetek dugwit, yawi initu dogop wene yugup ambi werek a, dek a?” ");
INSERT INTO nbq_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yugugu ako aruk hobaluk, at yegen werek menda ako owa adema lagya lagagirik, yugugu dugwit, “At ap andi, Oroma menda atma, hat nggarogo ogarup yiluk yagaliga?” Yugugu lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Paulus adema lagya lagagirik, yugugu dugwit, “Hat Oroma menda avyarat a? Yukniru o.” Yiluk, hemet higya lagagimu, “Avyarat,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Yugugu lagagimu, it yegen werek enasin ako en, “Ninis unggul Oroma menda arigiluk onggo ombok bagagis o.” Yugugu lagagimu, at Paulus ako en, “Hat Oroma menda arigiluk onggo bagagin ovara, an andi, an nasin-nisa Oroma menda atma, an ogo Oroma menda endaklagagis,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","It at aigwakma waguluk yiluk ogagagwa menda, yugogogi ako enaruk hunggu lagagwarik, “Avyak! Hekbasogom,” yiluk, mbup yi lagagwa. Eke, at yegen werek menda enasin ako en ogo, “Paulus o Oroma menda hegek, heda magima, wi!” yiluk, alon wisane agagi. ");
INSERT INTO nbq_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nogo yiluk, hutun ap yegen werek menda enasin ako en, “It Yakuri nggarogo yiluk enane ovaga lobalogo bagao des erogo nelup arisogon,” imbita dugwit, Paulus visilogo hekbagya lagagirik, it ap imam-imam enasini inim, it wene amburup mbalisagwi menda inim, homari warupwak yiluk enayonggo bagya lagagimu, homari wagagwama, Paulus ako wolok, enadema ilim mendok okbagagi. ");
INSERT INTO nbq_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","At Paulus ako wolok, ilim mendok okbagya lagagimu, it wene amburup mbalisagwi menda ako il vurek dugwit, “Naswei o. An Ala avema dugwit, o muk en yogak hudi ogarit lagya dugwit an ogagya lagi ako ambi weyak ogagatek nendawi ugun seyalek at agirik o.” ");
INSERT INTO nbq_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Yugeragagi andi vaga, at imam inis ombok winimen agarik Ananiyas en it ap Paulus adema mendek welagagwa ako yugirigya dugwit, “Abis sagalogo wares,” ");
INSERT INTO nbq_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","yugirigya lagagimu, Paulus ako en at yugugu dugwit, “Yo weyak hegek agamut adigat amburup warek sek agarik hak, hagamut adigat sek agindik yi, Ala en mondok harisogon aro. 'At Ala wene yugup Musa dirup mbanggigi ako wane-wane ogaga a, dek a?' yiluk, nawene amburup des erogo mbaluguluk horaik agindik ovara, an narupwak yiluk ap yugeregen andi vaga haren wene yugup ako weyak erogo bagya heyagi o,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Yugugu lagagimu, Paulus adema welagagwa ako en at Paulus yugugu dugwit, “Hat Ala ayeloman ap imam nenasin inis ombok yi meyan imbitya dugwit, yagaliga yi?” ");
INSERT INTO nbq_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Yugugu lagagwama, at Paulus en, “At imam inis ombok winimen agarik ako andi, ninggutma yigi o, naswei. Ap akwa enasin hinim agarik ako, henane weyak at ovaga babuk, yiluk, dirup mbalek agarik ako an nelup aro,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Yugirigya lagagirik, at Paulus ako en it wene amburup mbalisagwi menda nin andi, Saduki menda, it nin andi, Parisi menda inim, werek yedok inugu lagagirik, “Naswei. An ap Parisi menda aro. Eke, nasini ogo Parisi menda adigat. Nit hambuluk niniluk erogo mendok yup wene andi, avyarat arugwi atma yiluk, nape wenggelek neyalok, nawene amburup mbaluguluk agipik hinigis,” yiluk, ane ombok vaga yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Yugirigya lagagimu, it Parisi menda inim, Saduki menda inim, wenemuk yugu lagagwarik, it homagagwa ako, ir-it ogot-hedagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(It Saduki menda ako en, “Ap akwa hambuluk iniluk erogo mendok yusogonbuk. Malaikat inim, ap akwa enanggela inim, andi ogo agarwik mondok dek o,” yagalagwi ovara, it Parisi menda en andi, “Andi ovok erogo agarwik, eke ap akwa hambuluk iniluk erogo mendok yusogon,” yugu dugwit, inim ogot-hedagagwa.) ");
INSERT INTO nbq_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ogotbaluk, enane yanjak-hanjak yugu dugwit, it Parisi menda Musa wene mbalek mamulurugu lagagwa menda nin en, mendek yiluk yugurugu dugwit, “At yi, weyak ambi ogagetek higyo o. Ap akwa enanggela ambi en yugogogi vaga yagaliga a, malaikat ambi en yugogogi vaga yagaliga a?” yiluk, enane winimuk ombok yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Enane winimuk yugu dugwit, it wene ombok alelo watu-selok, it ap yegen werek menda enasin en Paulus liriluk-mariluk ogagu-sawen, at aori ako yugirigya dugwit, “It homago enanggelekma wa nunggugu dogomundik, eyave wolok o nit nenamwa akoma mabelales,” yiluk, yugirigya lagagimu, ndatak ogagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nogo yiluk, heveret hup akoma werekma, Nenasin Yesus at Paulus adema wagya lagagirik, mendek dugwit, “An Yesus Henowa Inis Ombok dogogiluk Ala en denogo baninggigi wene ako o Yerusalem des erogo yugirigya lagen ako wane-wane, hivis o Oroma andoma yugeregek laupma, hendawi wadok dek dogwen,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Hutun o yanggo iri lagagimu, it Yakuri menda homakbaluk wene mbauk erogo mbanggu dugwit, “At Paulus watitek dugwit, nit erom inim, is inim, andi naup mondok dek,” yiluk, Ala inis vaga hanum mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","It eneyave dambulik 40 nin inim homakbaluk, eyave warup yiluk wene mbauk erogo mbanggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Wene mbabaluk, it ap imam-imam enasini ap ombok-ombok ako inim, it Yakuri enasini inim, it werekma, enadema lagu lagagwarik, yugurugu dugwit, “At Paulus watitek dugwit, nit yi menda ndi menda naup mondok dek o, yiluk, Ala inis vaga mondok hanum mbanggup. ");
INSERT INTO nbq_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Andi atma, yogak hit inim, it wene amburup mbalisagwi menda inim, un huluk Paulus ambi inim des erogo aigwakma wapwak yiluk, at yegen werek menda enasin ako en wolok warupwak yiluk, yonggo lakbisamima yuguri lagusigik, nit sup vaga hanjalek werekma, wolok yoma ari wagetekma, sup vaga andenam wakbasogom aro,” yiluk, yugeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","At Paulus waruguluk sup vaga hanjali laup yagagwa ako ambonggo en aruk hunggu lagagirik, at Paulus it yegen werek menda enamwa werekma nunggwigya lagagirik, hurimbis yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Hurimbis yugugu lagagimu, at Paulus ako en it yegen werek menda enasin avema menda ambi, yanggup yugogogi wagya lagagimu, yugugu dugwit, “At apsawe yi en, henasin wene ambi yugurupwak yiluk wagarikmu, wolok elak.” ");
INSERT INTO nbq_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yugugu lagagimu, apsawe ako wolok it enasin adema balagya lagagirik, yugugu dugwit, “At Paulus heda mago ako, neyanggup yuknugu lagama, lagya lagirik, ‘Apsawe yi en, henasin wene ambi yugurupwak yiluk wagama, wolok elak,’ yuknugu lagama, yukhurupwak yiluk wolok wagi.” ");
INSERT INTO nbq_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yugugu lagagimu, enasin ako en apsawe ako inggis vagakluk, enadikmu lagu lagagwarik, mbauk erogo yugugu dugwit, “Hat wene yuknirigiluk wagen ako iru o.” ");
INSERT INTO nbq_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yugugu lagagimu, at apsawe ako en, “It ap Yakuri en un huluk hutun hat Paulus wolok, it wene amburup mbalisagwi menda en ambi inim des erogo aigwakma waup wolok lanok yiluk yukhiri warup hologo bagaorikmu, ");
INSERT INTO nbq_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","yukhiri waguselok, enane hulup mondok dek. It Yakuri menda eneyave dambulik 40 nin inim en, ‘At Paulus watitek dugwit, erom inim, is inim, nit naup mondok dek,’ yiluk, Ala inis vaga hanum mbabaluk hanjalek dugwit, hat iri heyao adigat enaruk agarwik,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Yugugu lagagimu, enasin ako en apsawe yugugu dugwit, “Hat yuknigin andi, ap hunogo ambi mondok yugerabuk,” yiluk, aruk wakbaluk, “Elak,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Yugugu lagagirik, it yegen werek menda enasin at avema menda mberen eneyanggup yugirigya lagagirik, wagu lagagwama, yugirigya dugwit, “O hup jam 9 vaga o Kaisareya laguluk ap yegen werek menda eneyave 200 inim, ap yegen werek kuda ambot-vaga horaik lendagwi menda eneyave 70 inim, eke, ap enaregowa werek eneyave 200 inim, mondok dikduk ogagu dogomundik, ");
INSERT INTO nbq_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","at Paulus ako, kuda ambot-vaga horabaluk, enewogogo ap nenowa gubernur Velikis adema balapwak yiluk yugeranes,” yiluk, yugurigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","vipuk ogagusigik, surat-vaga dirup mbanggya dugwit, yerogo yagagi: ");
INSERT INTO nbq_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Hinis mondok siyalek agindik nenasin Gubernur Velikis wa. An Kolaudiyus Lisiyas en wene ambi yukhisogon. ");
INSERT INTO nbq_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ap yi, it Yakuri menda en vakbaluk, mondok waruguluk ogagao menda, 'An Oroma menda,' iris ako naruk hobaluk, naori yegen werek menda ninim agap wendari lagu lagurik, ");
INSERT INTO nbq_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Adem ngga vaga warup yugu-samwi? yiluk, wolok it wene amburup mbalisagwi menda enadema lagi. ");
INSERT INTO nbq_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Enadema lagya lagimu, iren yugu dugwit, ‘At ako nit Yakuri wene yugup dirup mbalek yerogo-nderogo ogarup wene saganggas’, yiluk, yugu-sigik ovara, ‘Mondok warup. Heda marogo lembaga mabaup’, yagao andi, adem dek hegek yagao higi. ");
INSERT INTO nbq_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Eke, 'Warup, wene mbauk erogo mbanggao,' yiluk, yuknugu naruk hunggu lagirik, mbikit hat hadema lakba wagya, eke, it enane ovaga lobalogo bagao ako, vagalogo yukhurupwak yiluk, Yuguri elales, yiluk, yugurigya, ogagi o, yiluk, an Kolaudiyus Lisiyas en yukhisiga, nasin wa,” yiluk, dirup mbanggigi. ambot-vaga horaik lendagwi menda. ");
INSERT INTO nbq_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Dirup mbanggya lagagirik, “Wolok elales,” yugeragagi wane-wane it yegen werek menda ako o hup Paulus wolok, o Andipatiris hudi balagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Eke, nogo yiluk, hutun en it yegen werek kuda ambot-vaga nelagwi menda ako en Paulus ba lapwak yiluk, lakbugu lagagwarik, wolok lagusigik, it yegen werek menda ako en eneyami-vaga enamwa lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","It kuda ambot-vaga lendagwi menda en Paulus wolok o Kaisareya nunggugu lagagwarik, ap enowa gubernur ako dirup mbalek ako wogugu dugwit, Paulus eyave ako at inggimu bagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Dirup warek ako bikhigya lagagirik, “Hat hawi ngga menda?” yiluk, hemetigya lagagimu, “Dek! An nawi Kilikiya aro,” yugugu lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Enane hovaga lobalogo bagao ako, waguselok, adem belalusogom,” yugugu lagagirik, “Herodes awi ombok valekma wolok lagu dogomundik, aruwam dogones,” yiluk, aburi yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ndugwis 5 nogo yiluk, ap imam inis ombok Ananiyas inim, it Yakuri enasini ap ombok-ombok inim, ap Oroma wene yugup ilup it Yakuri enavikit agagi menda inis Terutulus inim, ako en enowa gubernur ako adema lagu lagagwarik, “Paulus weyak ogagagi ako yi o,” yiluk, wene yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Yugugu lagagwama, Paulus warupwak yiluk ayonggo bagagi wagya lagagimu, at Terutulus en, “Paulus ogagagi ako yi o,” yiluk, gubernur yugugu dugwit, “Ai wa! Nenasin Velikis hat nenengge heyagek o muk en yogak hudi nenendawi ugun adenggen vaga agurik. Hat wene sek hulisiga vaga, o yoma ovok nenake sek erogo bininggigin. ");
INSERT INTO nbq_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Yi awi ndi awi yi ogagek ndi ogagek mot-mot adigat ogagya heyalok, Nenasin, wa! yukhisagwi. ");
INSERT INTO nbq_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","An wene adup yagan lagya neyalok, hanggon okhita hao en, dul erogo iri neyagek, hendawi sagain vaga haruk hunggu dogonyok yiluk, Yu, yukniru.” ");
INSERT INTO nbq_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","7","Iri lagagirik, “Ap yi, avakwa nadok-hadok ogonivit lagya dugwit, it Yakuri yi awi ndi awi ovok enendawima malit lagya higyo. Ap Nasaret menda ane welagwi ako enasin araro. Eke, Ala awi valekma weyak erogo bagiluk ogagyama vagatup. ");
INSERT INTO nbq_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","At yerogo ogaga, nderogo ogaga, yiluk, ovaga bagyo ako, ovok erogo hat des erogo adem senggu dogomindik, ‘Avyarat weyak ogaga,’ ombarugun.” ");
INSERT INTO nbq_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yugugu lagagimu, it Yakuri homagagwa ako en ogo, “At wene ovaga bagas andi, avyarat higyo,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Yugu lagagwama, it enasin gubernur ako inggi wene vaga, “Hat iru,” yugugu lagagimu, Paulus ako en yugugu dugwit, “Nit avakwa Yakuri menda ovok haren ninawene amburup mbanggya heyagek, yi tahun ndi tahun oklaga an nelupma, nalon dek dugwit, an novaga lobalogo bagao wene ako vagalogo yukhisogon.” ");
INSERT INTO nbq_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Yugugu lagagirik, “An ndugwis 12 hudi endak vaga o Yerusalem samban ogarigiluk lagagis andi, haren, 'Yi avyarat yuknigas,' embetetek halok, it avakwa hemet inisaup sek aro. ");
INSERT INTO nbq_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","An andoma dugwit, Ala awi valekma ninim wene watya, eke, it Yakuri samban ogasagwima inim, o kota Yerusalem inim, andoma ap homago nane-hane yagan lagu dogopwak yiluk enendawima molanggu, ogagya ambi neyagetek. ");
INSERT INTO nbq_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Eke, yogak wene an novaga banilagwi andi ogo, adem dekma, it yugwi hat avyarat ombarinyok yiluk yukhirup andi, dek hayogon o, nasin. ");
INSERT INTO nbq_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ala wene yugup Musa dirup mbanggigi inim, buku navi-navi dirup warek ako inim, ovok avyarat ombasigama, Sup Yesus Ambetaga Lagu Dugwit Iniluk Mondok Dogop Wene ako musek landiga andi, it Yakuri menda ako en, ‘Wene andi huluk wene aro,’ yiluk, yagalagwi ovara, an wene andi ndatak musek lagya dugwit, nenombawi Enasin Ala siyabaliga, andi avyarat vagalogo yukhisiga, nasin. ");
INSERT INTO nbq_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","It weyak ogasagwi menda inim, sek ogasagwi menda inim, hambuluk lendagwima Ala en iniluk erogo mendok okbisaup, nape wenggelek agirik andi, irogo enape wenggelek agarwik. ");
INSERT INTO nbq_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Anderogoma, Ala inim, avakwa inim, inivaga an okbisayogon vaga nendawi ugun seyalek ogagya dogogiluk dibaluk ogasiga. ");
INSERT INTO nbq_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Eke, tahun maren hudi o hunogoma welagagirik, an naswei Yakuri menda enabwa en un wogeraup inim, Ala ake bago inim, wolok neyami vaga o Yerusalem wogora lagi. ");
INSERT INTO nbq_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Wogora lagya lagirik, Ala awi valekma avakwa wisane ninim homagwi, nadok-kadok ogagya, ogagetek, ugun horek hak neyagek, ");
INSERT INTO nbq_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","it ap Yakuri Asia menda nin andenam werek inigis ako en an ambi ogagya neyagao hawen, iren hat hivaga enane novaga banup sek ovara, nanggadi wakbani wagaobuk! ");
INSERT INTO nbq_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","21","Yi wene ndi wene yugirigi vaga dek. Ata, it wisane inivaga, ‘Nit hambuluk niniluk erogo mendok yup andi, nendawi wenggelek halok, nawene mbaluguluk wagu hinigis,’ yiluk, wene maduk andi nane ombok vaga yugirigi andi nelup ovara, ambi inim ogagya neyagao hawen, iren adigat vagalogo yukhurupwak,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Yugirigya lagagimu, Velikis ako en Sup Yesus Ambetaga Lagu Dugwit Iniluk Mondok Dogop Wene yugwi ako, des erogo elup werekma, “Hivis it yegen werek menda wisane homago enasin Lisiyas ako wagya halok, awene an amburup mbalisogonma, wilitales.” ");
INSERT INTO nbq_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Yugirigya lagagirik, at yegen werek menda enowa ako yugugu dugwit, “Paulus andi, heda mago hak enewogogo vagogo werekma, aswei en ake wogori waguselok andi, sek, yugerano,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ndugwis maren hudi welagagwarikmu, Velikis ogwa Ndurusila hwa Yakuri menda it mberen wagagwa. Wagu lagagwarik, Paulus warupwak yiluk ayonggo bagya lagagimu, wagya lagagirik, Yesus Keretus avyarat ombasagwi wene iris enaruk hunggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Eke, Paulus en sek adigat ogagu dogop wene inim, enendawi en ogarup oginivisiga ovara, sovalogo baup wene inim, hivis owak dilinivup wene ako inim, yugirigya lagagimu, at Velikis ako alon agya lagagirik, “Ovok yugurikmu, elak. Ndugwis ambi vaga yup nanonggal werek agya halok, warinyok yiluk yanggup yukhisogon,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Andi yugogogi ako, “Heda mago ako visilup onggo woknirumwak,” ombakluk, ape wenggelek dugwit, Paulus eyanggup yimi wagya halok, it mberen wene mbanggwis ogagu lagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Anderogo ogagya lagagimu, tahun mberen okbaluk, at Velikis aveloma Perikiyus Vetus mondok okbagagwa. Eke, at Velikis en, “It Yakuri enendawi hunik nombarupwak o,” yiluk, Paulus heda mago ako visilogo wibagetek winggigi. ");
INSERT INTO nbq_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","At Vetus ako mondok okbagu lagagwama, o provinsi andoma wagya lagagirik, ndugwis henggam nogo yiluk, o Kaisareya en o Yerusalem inggigi. ");
INSERT INTO nbq_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Yerusalem inggya lagagirik, werekma, it imam-imam enasini inim, it Yakuri enasini ap ombok-ombok inim, ako en Vetus adema wakluk, Paulus wene ovaga bagagwa ako mbilinogo yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Sup vaga wagyama, hanjabaluk, Paulus waruguluk wene mbanggu lagagwarik, at Vetus en, “E o,” yumwak yiluk, ambukmu unggu dugwit, “Nasin. Hendawi hunik okninipu dugwit, Paulus o Yerusalem warupwak yiluk, ayonggo bain,” yiluk, enane hunik adigat yugugu lagagwama, ");
INSERT INTO nbq_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","“Dek o. Paulus ako, o Kaisareya vagogo agarwik atma, an vage dogomindik andoma layogon halok, ");
INSERT INTO nbq_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","henasini ap ombok-ombok wene hulisagwi menda nin ninim lagu dogomindik, avyarat weyak ogagagi halok, andoma en adigat yugurupwak,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","It inim dugwit, ndugwis 8 vaga a, 10 vaga a, inim welagagirik, o Kaisareya eyami vaga wambigya lagagirik, hutun en wene owak dilupma, owak dilisagwima nunggwigya lagagirik, Paulus wolok warupwak yiluk yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Wolok wagu lagagwama, at eyave ilim hegek, it Yakuri Yerusalem en wagagwa ako, walibaluk, adem dek hegek, “Yerogo ogagagi, nderogo ogagagi,” yiluk, wene iya erogo adik ovaga bagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ovaga bagu lagagwama, Paulus ako sek-sek okhidiga dugwit, “Dek o, naswei. Ala wene yugup Musa wene mbalek it Yakuri ogasagwi ako saganggya; Ala awi valekma weyak erogo bagya; eke, nenasin Kaisar inis weyak erogo bagya; ogagagi, yuknisagwi yi, an ambiat mondok weyak ogagetek aro,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Yugurigya lagagimu, at Vetus ako en it Yakuri enendawi hunik ombarupwak yiluk, Paulus ako yugugu dugwit, “Hat anderogo ogagagin, yukhisagwi yi, Yerusalem lagya dogomindik, an nivaga andoma howak dili laup sek a?” ");
INSERT INTO nbq_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Yugugu lagagimu, Paulus en, “At nenasin inis ombok Kaisar owak dilisagwima yi atma, an novaga bagao yi, yoma en nowak dineraup. Anen it ap Yakuri menda ambi weyak okbugu lagetek andi, hat mondok helup aro. ");
INSERT INTO nbq_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Weyak ogaguselok, enasagwi ako menda ambi avyarat ogagagis halok andi, narup sek ovara, wene adem dek hegek yuknuguma, it narupwak yiluk, neyave wogeraup hiren ambi yup mondok dek aro. At Kaisar o Oroma agarik ako en nawene amburup mbalupwak,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Yugugu lagagimu, Vetus ako en at arwi wene amburup mbalisagwi menda ako inim wene mbabagu lagagwarik, at Paulus yugugu dugwit, “'Kaisar en adigat nawene amburup mbalupwak o,' yiluk, yegenma, Kaisar werekma at labagasogon o,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Andi okbaluk, ndugwis maren hudi welagagirik, it Yakuri enasin inis ombok Agiripa arup hwa Mberenike it mberen en at Vetus heyaga waruguluk, o Kaisareya wagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Wagu lagagwarik, it andoma ndugwis maren hudi dukluk eneyami vaga laup umbutugwarikmu, Vetus ako en, “At Velikis wunggu dugwit, ap ambi heda mago hekbagas yoma agarik,” yiluk, Paulus avok mbilinogo it Yakuri enasin inis ombok ako yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Yugugu dugwit, “An o Yerusalem lagya lagirik, werekma, it ap imam-imam enasini inim, ap ombok-ombok inim, ako en, ‘Anderogo ogagagi o,’ yiluk, enane ovaga lobalogo baluk, waruguluk, ‘Haren owak dilu,’ yuknigao.” ");
INSERT INTO nbq_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Yuknugu lagaoma, anen it yugirigya dugwit, ‘Nit Oroma menda ninitok andi, ap ambi en it nin en wene ovaga lobalogo bagao halok andi, aren it at ovaga bagao ako enadema “Wene novaga bagep yuknires o,” yugeregetek hegek, eyave weyak okbapwak yiluk wogerelagudek,’ yugirigya lagima, ");
INSERT INTO nbq_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","it ovok ninim yoma homari wagu lagarwik, werekma, an arabu dek, heveret hutun wene owak dilisagwima nunggwigya lagirik, eyave wolok warupwak yiluk yugirigi. ");
INSERT INTO nbq_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Yugirigya lagima wolok wagao, it ovaga bagagwa ako en mendok yiluk, ‘Weyak anderogo ogagagi o,’ yusogon imbiti andi, ndatak yegetek inigis. ");
INSERT INTO nbq_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ata, un, it Yakuri en Ala inim hunik dogoguluk ogasagwi menda inim, eke, ap ambi inis Yesus mondok hombagagi ovara, Paulus en, ‘Iluk agarik,’ yagan landiga wene inim, yugu dugwit, nawene-hawene yagaoma, ");
INSERT INTO nbq_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","wene andi menda, an dibagetek halok, nggarogonggan adem belalimi, imbitya lagirik, ‘Hat hovaga bagao yagalagwi andi, o Yerusalem en hawene mbalupwak yiluk lakbagaup sek a?’ ");
INSERT INTO nbq_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Yugugu lagima, Paulus ako en, ‘At Kaisar enat nawene mbalupwak yiluk, heda marogo mabiselagwima yoma dogosogon,' yuknugu lagama, anen, hivis Kaisar adema lakbaup atma, vagogo dogones, yugirigi,” yiluk, mbilinogo yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Mbilinogo yugugu lagagimu, Agiripa ako en Vetus yugugu dugwit, “At ap andi, wene iris ako an ogo hulup hogop ai, ombasiga,” yugugu lagagimu, Vetus ako en, “Heveret aren iri halok, hulisogon,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Yugugu lagagimu, heveret hutun en Agiripa Mberenike it mberen inim, it yegen werek menda enasini ininis werek inim, it o kota andoma menda enasini ap ombok-ombok inim, mondok iniris inovagangge yirik, ap akwa enagayuk wutusigik o wene mbalisagwima akoma nunggugu lagagwarik, Vetus ako en, “Paulus wolok ba omanes,” yugirigya lagagimu, bawagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Bawagu lagagwama, Vetus ako en, “Nenasin hinis ombok Agiripa inim, hit yoma homagyo inim, hit ovok, Wa! yukheraliga. It Yakuri o Yerusalem en, o Kaisareya yoma en, yanjak-hanjak yugu dugwit, ‘Ap yi iluk dogop dek. Wares’, yuknigao ako eyave yi bikhanes. ");
INSERT INTO nbq_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Wares, yuknigao ovara, weyak ogaguselok, enasagwi andi menda ndatak ambi ogagetek higi ovara, at ako en, Inis ombok Kaisar en adigat nawene mbalupwak, yuknugu lagama, o Oroma andoma Kaisar werekma lakbaup imbiti. ");
INSERT INTO nbq_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Anderogo imbiti ovara, at ogaga ambi an dirup mbalogo nasin Kaisar ake lakbaup dek atma, at ogaga ambi adem des erogo yuknugu hiniselok, dirup Kaisar ake mbalogo lakbaup yiluk, at eyave wolok hit ovok henadema wagi. Wene adem des erogo andi, hat nenasin Agiripa en belalinyok yiluk hadema wolok wagi. ");
INSERT INTO nbq_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Wene ovaga bagao ako adem des erogo belanggitek hegek, inggis heda marogo lakbaup andi, meyan higi,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Yugirigya lagagimu, at Agiripa en Paulus yugugu dugwit, “Hat ogagagin ako iru,” yiluk, yugugu lagagimu, Paulus agap wendak-hedagiluk wene adem sigam erogo avyarat yugeragiluk, inggi-vaga en, “Mbauk dogones,” yugirigya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ai, nasin RajaAgiripa wa. It Yakuri en, 'Yerogo ogagagi, nderogo ogagagi,' novaga belagwi andi, o yogak hat hivaga vagalogo yukhirisogon andi, nendawi adenggen agirik o. ");
INSERT INTO nbq_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nit Yakuri ogasagwi menda inim, wene ngga menda yidibaluk yagalagwi inim, hat ovok helup atma, yegek lagya neyagek, 'Hanggon,' nombarubuk, nasin.” ");
INSERT INTO nbq_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“O muk avyak maduk nawi adem vaga dugwit, ogarit lagya, andi okbaluk, o Yerusalem dugwit ogagya, ogagya lagagis ako, it Yakuri menda ovok enelup aro. ");
INSERT INTO nbq_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nit Yakuri wene yugup wokbaluk ogasagwi menda andi, it nin enane anye vaga yagan nagu lagagwa Parisi menda ako, an ogo it ninim yagan lagya lagagis ako, o muk en enelupma, vagalogo yukheraup embetao halok andi, yukheramwak.” ");
INSERT INTO nbq_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","“Eke, yogak Ala en nenasini avyarat nggatuk erogo yugeragagi ako wene nape wenggelek agirik andi vaga woknombolok nawene diluguluk, bani wagao inigis. ");
INSERT INTO nbq_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Avyarat nggatuk erogo yugeragagi ako nit Yakup aburi nininis unggul 12 suku ako en, ‘Atma arisogon, ai!’ yiluk, umbutu dugwit, o hup-dingga, nenendawi eve vaga, Ala siyabelagwi. An ogo wene andi, nape wenggelek agirik andi vaga it Yakuri en naruguluk, wene novaga bagaoma, nasin! ");
INSERT INTO nbq_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Anderogoma, hit nggarogo yiluk At Ala en avakwa hambisagwima en iniluk erogo mondok okbisaup andi meyan ombasagwi?” ");
INSERT INTO nbq_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Eke an ogo endak At Yesus Nasaret menda andi, inis wiyiknom-weyaknom erogo bayogon imbitya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","o Yerusalem dugwit, anderogo ogagya lagagis. Ogagya dugwit, it ap imam-imam enasini ako en yuknogogwa vaga it Ala aburi adik denek eneyave wisane heda marogo lembaga mabisa lagya, eke, 'Enarup a, dek a?' yugu-selok, anen, 'Enarup aro,' yugirigya, ogagya lagagis. ");
INSERT INTO nbq_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","It Yakuri samban ogasagwima dombok edup-mbedup okbugu, eke, 'At Yesus inis wiyiknom-weyaknom erogo bas o,' yiluk, nane anye vaga yugirigya, ogagya lagagis. It avyarat ombasagwi andi, mondok nanggon inimbita dugwit, naninis ane yagan lagya neyalok, avakwa nin wisane enamwa o adumu andoma at enarigiluk, enamusek-enamusek lagya lagagis,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Yugirigya lagagirik, “Anderogo ogarit lagyama, o ambi vaga it imam-imam enasini en, 'Anderogo ogwarup o,' yiluk, lakbanunggu lagagwama, o Ndamasik sup vaga lagya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","dingga naswei ninim lagusim, mbogot-vaga en abinak yevedogo nit nenadema wambu wagagi. Mo il abya andi horok maduk, nasin. Eke, andi ogagagi ako andi, abya mondok eve iya erogo higya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","nit ovok wen vaga ndun yugu lagagumu, Iberani enane vaga yuknugu dugwit, ‘Saulus wai. Saulus wai. Hat nggarogo yiluk an anggin-mbanggin erogo nasiga? Hat ninim ogorek dogosogon halok, hat hivis hilup arisogon atma, hat nggarogo yiluk anderogo ogarit landiga yi?’ yiluk, iris naruk hunggu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘Ai, Nasin. Hat sa o?’ Yugugu lagagimu, ‘Dek o. Haren anggin-mbanggin erogo narit landiga ako An Yesus aro. ");
INSERT INTO nbq_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Hat nayeloman akluk, yogak ogagya neyagen inim, hivis ogarit lagya dogop yukhirisogon ako inim, wene andi menda yugeregek lagya dogop denogo bagagiluk, yukhiri wagima, mendek iru. ");
INSERT INTO nbq_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","It ap Yakuri inim, it weram Yakuri dek menda inim, enadema lakbagamima, iren andoma weyak okbagagu-selok, hagap wendatya dogosogon. ");
INSERT INTO nbq_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","It o hup ovagak agarwik ako, inil venggenogo bisiluk, awiyama nunggu wagwi, eke, at ibilis avema bogogirikmu en wulukluk, Ala avema nunggu wagwi, ogarusogom, yumwak yiluk, lakbagasogon. It ako enendawi novaga vanggabaluk avyarat numbutwi-selok, enomaluk Ala en dek erogo bisiluk, at aburi denogo bogogirikmu inim lobalogo bisamwak yiluk, lakbagasogon,’ yiluk, yuknogogi,” yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Yugirigya lagagirik, ambi inim yugirigya dugwit, Nasin Agiripa. Mbogot vaga en an nogo heda nabi heda yuknugu sigam hagagis ako, an ogagetek agirik andi dek. ");
INSERT INTO nbq_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Yuknogogi ako endak erogo it o Ndamasik agarwik ako yugirigya, o Yerusalem agarwik ako yugirigya, andi okbaluk, o Yudeya avilis ambot inim, it weram Yakuri dek menda inim, yugeregek lagya, ogagya dugwit, Hit ovok henendawi wenggebaluk, henomaluk vagalogo mbo bagu dogones. Eke, henomaluk mbo baluk, Ala musek lagwi avyarat henombarupwak yiluk, yi ogagek ndi ogagek eyave adigat ogarit lagu dogones, yiluk, yugirigya lagagis. ");
INSERT INTO nbq_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","“Anderogo yugeregek lagya lagagis andi vaga it Yakuri en Ala awi valekma andoma vakbaniluk, naruguluk ogagagwa menda, ");
INSERT INTO nbq_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","o endak en yogak hudi, Ala en yonggatnita hegek niluk dugwit, it ap ininis werek inim, ininis dek inim, yugeraliga. Yugeraliga andi, wene adik menda ambi yugeregetek. Ata, ap Ala en yugirigya hegek yugurugu lagagwa navi-navi ako inim, at Musa inim, 'Anderogo ogarisogon o,' yiluk, avok yugurugu lagagwa wene ako vagalogo yugeraliga. ");
INSERT INTO nbq_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","At Ala en denogo mekbagagi Keretus ako, nit Yakuri menda inim, it weram Yakuri dek menda inim, o awiya erogo bugu dogogiluk, yagan warogo hambigya dogomindik, hambuluk lendagwima en endak iluk akluk mendok yisogon o, yiluk, yugu lagagwa ako yugeraliga,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulus en wene andi ao yugirigya hegek, at Vetus ako ane ombok vaga iri dugwit, “Paulus wai. Hat nenek heyagi! Yi wene ndi wene mamulhedegek lagya vaga nenek hak yagan lagya heyagi.” ");
INSERT INTO nbq_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Yugugu lagagimu, Paulus en, “Hinis mondok siyalek agindik nasin Vetus wai. An nenek dek o. An nendawi sek en avyarat yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nasin Agiripa wai. An wene yugeraliga andi, mbauk hwilago yugirigya lagibuk o. Wene an yugeraliga ako andi, hat nasin Agiripa ogo, hinggut andi dek, mondok helup imbiti. Wene andi ovok helupma, nalon dek dugwit, yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nenasin Agiripa. It ap navi-navi Ala en yugirigya hegek yugurugu lagagwa wene ako, hat avyarat ombasiga a, dek a? Avyarat ombasiga an nelup.” ");
INSERT INTO nbq_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Yugugu lagagimu, at Agiripa en Paulus yugugu dugwit, “O yogak yi vaga at un mbikit an ap Kerisen menda okbanup embeten?” ");
INSERT INTO nbq_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Yugugu lagagimu, at Paulus en, “Nasin o. Hat hadigat wanok yiluk yukhisigadek. Hat inim, it yogak hulisagwi ovok inim, an heda maknetao hak makinivup dek ovara, an Keretus wene wagagis hak, yogak waup halok, yogak at wugwi, eke, hivis waup halok, hivis at wugwi, ogarovovok yiluk, an henake Ala yugisiga,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Yugugu lagagimu, enasin inis ombok ako inim, enasin gubernur ako inim, hwa Mberenike inim, it avakwa horaik welagagwa ako inim, ovok mendok yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","wunggu lagagwarik, “Weyak ogaguselok, heda marogo mabiselagwima mabugwis, initwis, ogasagwi menda anderogo ambi ogagetek higyo,” yiluk, ambi yugigik ogagu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","at Agiripa en Vetus ako yugugu dugwit, “At ap andi, nasin Kaisar nawene amburup mbalupwak o, yilipuk en, yogak heda mago agarik ako visilogo balip,” yiluk, yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","O Italiya woknenombolok laup yiluk wene mbabaluk, Paulus inim, ap nin heda mago inim, at Kaisar avema menda yegen werek enowa inis Yulius en wogonombolok lapwak yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Yugu lagagwama, mburis ombok o Adaramitiyum en wagya lagagirik, andoma werekma, o Asia inamut ombok yanggadek laut amban vaga kota andoma ya nonggegek ogagyama, nonggagagup. Ap Aritakus o Makedoniya awi Setalonika menda ninim nunggugu lagagurik, lagu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","hutun en nogo yiluk, o Sidon ari lagagup. Ari lagu lagagurik, at Yulius ako en Paulus abwa imbitya dugwit, “Haswei yi menda ndi menda wokhirupwak en biginigik lagya dogomindik, warup sek,” yugogogi. ");
INSERT INTO nbq_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mburi-vaga nungguluk, andoma en lagusim havut en mburis abi nomalhegek iri dugwit, nomaliluk lagya lagagimu, o Sipurus nenena malegek alilis o havut dekma, andoma lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Lagu lagagurik, o Kilikiya, Pambiliya inim, nenena malegek lagu dugwit, o Likiya kota Mira andoma ari lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Andoma ari lagagurik, werekma, ap yegen werek menda enowa ako en mburis Alekandiriya menda ambi, o Italiya lagiluk ogagya higya lagagirik, mburis andi vaga mabininggu lagagimu, lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Lagu dugwit, mburis ako havut en nomaliluk lagek ogagya dugwit, mondok meyan okninipu hegek, nogo wisane yigik, o Kinidus vanggo yi lagagup. O havut ako hunik anderogo adigat ogagya halok, dilwarit lagu dugwit, o Kereta alilis andoma o Salomone nenena malegek lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Lagu lagagurik, mondok meyan okninipu hegek, o inis Avolok Dek Sek Agarikmu o, yagalagwima o kota Laseya horok andoma ari lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Sup vaga ya nogo yigik lagu ninigik, it Yakuri Hari Puasa adenggen ogagu lagagwarikmu o havut endengga ogasigama, mburi-vaga laup alon edok werek agya halok, Paulus en enelup arupwak yiluk yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Naswei o. Nit lasogom halok, mondok weyak okninivisogon higi. Nenangge inim, mburis inim, ako adigat dek arisogon andi dek. Ata, neneyave inim dek okninivisogon higi,” yugeragagi menda, ");
INSERT INTO nbq_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","at yegen werek Yulius ako en Paulus iris ako meyan imbita lagagirik, at mburis eyave wolok naliga menda ako inim, at amburis werek inim, it yugwi adigat musek lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Lagya lagagimu, o sogwes ogagyama, mburis andoma dogop meyan agya lagagimu, it nin wisane mbikit andoma en lakluk o Venikis dogop, umbutugwa. O is enggema Kereta o Venikis mburis nunggwisigama andi, mo huruk yagaligama amot vikit inim, hware vikit inim, ogarekma o sogwes hegek dogop sek o, umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Anderogo umbutugwa ovara, o selatan vikit en havut anye dek mbauk-mbauk wagya lagagimu, “Nit yerogo ogagya hegek laup imbitoma, lauk en,” yiluk, mburis is en wolok lagwi en yiluk mbusi wombalek agarik ako nggolalogo mburi-vaga baluk lagu lagagurik, o Kereta horok is amban vaga andoma nenena wombalhegek lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lagusim, iya erogo lagatekma, ndom is enggema mo il daga wandigama amot vikit en havut endengga ombok ogakluk wagya hegek, ");
INSERT INTO nbq_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","laguluk ogagagup menda, mburis ako abi nomaliluk lagek adigat ogagya lagagimu, “Woknenombolok lapwak aro,” yiluk, yugu lagagurik mburis ako lek-yamuk ogarit wolok lagya hegek, mbauk mbup yagagup. ");
INSERT INTO nbq_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Woknenombolok, wen ilim is enggema maduk ambi inis Kauda alilimu andoma lagu lagagurik, havut en meyan okninipu hegek, mburis ombok ako en maduk ambi heda likelok lagyama, libilogo lagya hawen, ");
INSERT INTO nbq_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","viyalogo mburis ombok vaga mabagagup. Mabagu lagagurik, mburis ombok ako eyave yanggo iri hawen, heda anye erogo makbaluk, o Siritis alilimu andoma en mburis abi yinggi-vaga denggwes yilagya hawen yiluk, enalon en yum havut wolok landiga menda sivinik ako owatu lagagumu, havut en adigat woknenombolok lagagi. ");
INSERT INTO nbq_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Havut endengga en mburis ako mondok lek-yamuk okninipu lagagimu, ndugwis ambi nogo yiluk, hutun en yi menda ndi menda yidik ako hudilogo ima mbo wombabagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Andi okbaluk, ndugwis henggam vaga, mburis sek ogasagwi ako menda nin andi bagu dugwit, nin andi anggin halok ininggi-vaga wogogo ima mbo wombabagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ndugwis wisane ninigik, mo il inim, dwadiwap inim, wulu wagetek hegek, havut adigat ogagya lagagimu, “Ai, nit is en ndokalninivisogon atma, nenagap wendak-hedaup meyan higyo o,” yiluk, umbutugup. ");
INSERT INTO nbq_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","It ovok erom nenggetek ndugwis wisane welagagwama, Paulus ilim mendek iri lagagirik, yugirigya dugwit, “Naswei o. O Kereta en laup dek yukheragagis ako hulilipmu en nenangge dek agya, weyak okninipu, anderogo okbininelapuk enewogo duklu ovara, ");
INSERT INTO nbq_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","heneyave ambi is mondok-mondok wambusogom dek. Mburis adigat weyak asogonma, henendawi wadok dek dogovovok yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","An Ala abutma, avema dugwit, at eyavup ogasiga ako en yonggo lakbisa wandiga menda malaikat ambi hup ilikis nadoma lakba waga ako, yuknugu dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","'Paulus wai. Halon habuk. Hat Kaisar adema mendek yisogonma, Ala habwa en hinim mburis vaga agipik yi, hat vaga ovok enagap wendarisogon', yiluk, yuknigasma, ");
INSERT INTO nbq_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","26","wen is enggema ambi vaga mburis abi denggwes yimi ovara, Ala en yuknigas andi avyarat arisogon ombasigama, henendawi wadok dek dogones, naswei,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Is ombok yanggadek laut inis Adiriya o havut en lek-yamuk okninivit lagya hegek, ndugwis 14 welagagurikmu, eke, o hup ilikis agya hegek, it mburis wolok nelagwi menda ako, enendawi en, “Is amban vaga mondok vanggo yi wagyo,” yiluk, umbutu lagagwarik, ");
INSERT INTO nbq_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","helep heda magogo, “Is agurukmu ngga hudi hamwi?” yiluk, wakhegek ako wombabagu lagagwarik, agurukmu 37 meter hudi agya hagagwa. Andi okbaluk, ambukum dukluk wakugu lagagwarik, agurukmu 27 meter hudi agya hagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Hugu lagagwarik, helep vaga vanggo iri dugwit, abi denggwes iri hawen, enalon en mburis mbup yupwak yiluk, mbusi anggin werek menda 4 hudi mburis elakamu heda magogo is endawima wombabagu lagagwarik, “O hodo erogo yanggo yupwak dek, ai,” umbutugwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Umbutwi dugwit, it mburis wolok nelagwi menda ako enagap wendak-hedaguluk hoda wulup umbutu dugwit, huluk at mbusi anggin werek menda sivinik ako mburis abima en is endawima wombabaup yagagwa ovara, wuluguluk mburis maduk ako ima wombabaguluk ogaguselok, Paulus en yedok inugu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","“It mburis wolok nelagwi menda yi, mburis elola dogop dek halok andi, nenagap wendak-hedasogom dek,” yiluk, at yegen werek arwi inim yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yugirigya lagagimu, it yegen werek ako en mburis maduk ako is wolok lapwak yiluk, heda mbalogo wombabagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","O yanggo yigiluk ogagya hegek, Paulus en it ako erom napwak yiluk ane hunik yugirigya dugwit, “Erom nenggetek henendawi virik hinigik, ndugwis 14 hudi nogo yigik wagepma, erom nanes. ");
INSERT INTO nbq_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Erom nelok, henanye vaga henagap wendak-hedelok wolovovok yiluk, erom yi nanes. Hiniris ambiat ambi dek asogon dek.” ");
INSERT INTO nbq_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Yugirigya lagagirik, erom ambi wogogo it inivaga, “Ala wa,” yiluk, ugurogo ninggya lagagimu, ");
INSERT INTO nbq_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","it enendawi hora yiluk, ovok erogo inim erom nunggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nit avakwa mburis vaga lendagwi ako, neneyave dambulik 276 hudi. ");
INSERT INTO nbq_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Eke, erom enagaum erogo nunggu lagagwarik, mburis so arupwak yiluk, erom gandum awi yidik ako hudilogo ima mbo wombabagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","O yanggo iri lagagimu, o andoma ininggut ovara, wen is yinggi leyalek inil hugu lagagwarik, “Mburis vaga andoma duk erogo lasogom,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","mbusi heda mago ako mbalogo hekbagwi, mburis abi amot ogasiga menda elakas vokot sivinik ako visinggwis, ogagagwa. Okbaluk, havut en woknenombolok yinggi leyalekma lapwak yiluk, yum sivinik abima ilikbagu lagagwama, lagagup menda, ");
INSERT INTO nbq_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","is anye en mburis ako yinggima aguruk dekma dililup yi lagya lagagimu, is ombak en elakamu ndino-ndano yegek ogagya dugwit, mburis elakas ako yanggalagya hegek, ");
INSERT INTO nbq_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","it yegen werek menda ako en, “It ap heda mago ako sambu vaga wunggu-sawen, ovok inarusogom,” umbutugwa menda, ");
INSERT INTO nbq_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","it yegen werek menda enasin ako en, “Paulus agap wendarisogon,” imbita dugwit, “Enarubuk,” yugeragagi. Yugirigya lagagirik, “Hit sambu wasagwi henelup halok, henendak is endawima andoma soklok-soklok wambuluk, sambu vaga, is amban vaga andoma wilitales. ");
INSERT INTO nbq_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Eke, hit nin sambu wasagwi hininggut halok andi, mburis hobat masalek inim, yo masalek inim, andi vaga hininggis vakbaluk, enambutmu elales,” yiluk, yugirigya lagagimu, nit ovok sek is amban vaga wunggugup. ");
INSERT INTO nbq_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Is amban vaga sek wunggu lagagurik, “Wen is enggema yi inis Malata at higyo,” yiluk, nenelup agagup. ");
INSERT INTO nbq_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wunggugurik werekma, musu wagya dugwit, sogwes wisane okninipigirikmu, it avakwa enawerek andoma menda en nenabwa wisane hugu lagagwarik, hali monggalbaluk, heyaga warogo sogwes werakninipugwa. ");
INSERT INTO nbq_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Eke, Paulus hali erasak havedogo wolok wagya lagagirik, hubagyama, hali edup en mbas avakwa enasiga menda nggigis erogo wulu wagya dugwit, Paulus inggis mbas en aik hivitigi. ");
INSERT INTO nbq_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","It avakwa enawerek andoma menda ako en, Paulus inggis mbas hivitigi ako ao aik hunik inil hugu lagagwarik, ambi yugigik yugu dugwit, “Ap yi, ima en sek wulu waga ovara, mbas edup watas yi vaga ap enasiga menda sigam higyoma, madis inis ‘Enowak Dilisiga menda’ ako at iluk dogop dek imbitirikmu, avyarat hambisogon o,” yagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","mbas ako inggis weralogo hali hunikmu mabagagi. Hali ninggya hegek, edup yagan watitek sek welagagi. ");
INSERT INTO nbq_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","It ako en, “Inggis virimi a, ata supuk erogo ndun yiluk, hambimi a,” yiluk, inil welagagwa menda, ugun sek at welagagimu, “Ap yi, madis higyo,” yiluk, yagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Wen is enggema andok enasin ombok inis Pupiliyus ako eyavup adumu dek horok atma, helagu lagagumu, heyage wakninipu lagagirik, enendawi adenggen vaga erom menaknerelok, ninim sek ninigik, ndugwis henggam welagagup. ");
INSERT INTO nbq_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ako hudi vaga at Pupiliyus asin amwa dugwit, sogwes-sogwes ogagya, irut inim ogagya lagagimu, Paulus ako adema nunggigya lagagirik, unggul inggis vakbaluk ake samban ogagya lagagimu, sek agagi. ");
INSERT INTO nbq_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Sek agya lagagimu, it avakwa wen is enggema edup welagagwa menda Paulus adema wagu lagagwama, sek okbogogi. ");
INSERT INTO nbq_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Okbugu lagagimu, it avakwa ako en, “Sek okbininggas,” yiluk, enadenggen en, yi menda ndi menda woknera wagek yagagwa, eke hivis nit mburi-vaga laguluk ogagu lagagumu, yi menda ndi menda dek menda, wolok woknera wagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Mburis Alekandiriya menda enomadis embeklabwa inis Diyosikuri abi vaga agur-agut ogovak higirogo bagoma, wagya lagagirik, o sogwes ogagya halok, wen is enggema andoma abyam werekma, nit ako saut henggam welagagup. Welagagurik, mburis ako vaga nungguluk, lagu lagagurik, ");
INSERT INTO nbq_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","o Sirakusa ari lagagurik, andoma ndugwis henggam welagagup. ");
INSERT INTO nbq_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ndugwis henggam welagagurik, mburis vaga nunggugu lagagurik, o kota Eregiyum ari lagagup. Lagu lagagurik, hutun o selatan vikit en havut lavuliluk ogagya halok, nogo ambi yiluk, o Putioli ari lagagup. ");
INSERT INTO nbq_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ari lagu lagagurik, nenaswei it Ala aburi andoma menda ninim avuk agu lagagurik, “Ninim dogosogom,” yiluk, yuknurugu lagagwama, ninim samban ambiat welagagup. Anderogo ogarit o Oroma nonggagagup. ");
INSERT INTO nbq_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","It nenaswei Ala aburi Oroma menda ako nit wendagwi enaruk hunggu lagagwarik, o vasat Apiyus, sup vaga lagu dugwit nogo yilagwima inis O Henggam Valek, andenam en wokninivi wagu lagagwama, Paulus il inugu lagagirik, “Nasin Ala wa,” yiluk, endawi adenggen agagi. ");
INSERT INTO nbq_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","O Oroma nunggugu lagagumu, at Paulus ako o adikmu dogop sek yagagwa ovara ap ayegen werek menda ambi aruwam dogopwak yiluk bagagwa. ");
INSERT INTO nbq_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ndugwis henggam nogo yiluk, Paulus en it Yakuri enasini ap ombok-ombok andoma menda enayonggo bogogi homari wagu lagagwama, yugirigya dugwit, “Nowa-nasin. An nowa-nasin Yakuri menda sovalogo bugu, nenasini-nenombawi ogagu lagagwa ninitok hunik ogasagwi ako, sale-vale erogo bagya, ogagya lagagibuk ovara, o Yerusalem andoma en neyave vagogo heda maknitu lagagwarik, it ap Oroma menda en nawene mbalupwak yiluk, neyave wogeragagwa. ");
INSERT INTO nbq_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","An ogagagis adem belanggu lagagwarik, weyak ogaguselok, enasagwi ako menda novaga agagi ambi dek halok, visilogo banup yiluk ogagagwa ovara, ");
INSERT INTO nbq_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","it Yakuri ako en, ‘Heda visilogo hekbaup moga,’ yiluk, hunik adigat yugu lagagwama, 'Kaisar en adigat nawene mbalupwak,' yugeragagis. Yugeragagis ako andi, it nowa-nasin en weyak okbanunggugwa, yiluk, yugirigiluk, yugeregetek. We un, nawene amburup mbalupwak yiluk, yugeragagis. ");
INSERT INTO nbq_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Wene andi yukheragiluk, wagya lagirik, 'Warupwak,' yiluk, henayonggo bagi. Eke, nit Iserali nenape wenggelek agurik nenagap wendarisiga menda ako vaga mbusi heda maknitugwa wene yukheragiluk henayonggo bagi,” yiluk, yugeragagi. ");
INSERT INTO nbq_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Yugirigya lagagimu, it ako en, “Hat ogagagin wene Yudeya en dirup mbalogo lakba waga ambi hegetek. Eke, nit nenaswei andoma en wagu lagarwik, Paulus weyak anderogo ogaga, yiluk, yuknera wagetek ovara, ");
INSERT INTO nbq_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","avakwa yi awi ndi awi ovok en hit wene yugup musek lendagwi menda andi enanggon henombasagwi ninelupma, hat hendawi nggarogo yiluk yagaliga ako, iri heyaguluk wagyo,” yiluk, yugogogwa. ");
INSERT INTO nbq_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Eke, “O andi vaga ambi inim yuknerapwak,” yiluk, hologo bagagwa hudi ari wagya lagagimu, Paulus werekma eneyave wisane homari wagu lagagwama, Paulus ako o hutun en Nenowa Inis Ombok Ala en denogo bagagi avema dogop wene ako sigam erogo yugirigya, eke, Yesus wene ako des erogo enelup arupwak yiluk, Ala wene yugup Musa dirup mbanggigi wene inim, navi-navi wene inim, mbilinogo yugirigya, wisane ogagya hegek, o hup agagi. ");
INSERT INTO nbq_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Yugeragagi ako it nin en, “Avyarat ai?” umbutugwa ovara, it nin en andi, avyarat embetetek dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","wene visibaik-danggabaik yugu lagagwarik, wuluguluk ogagusigik, Paulus en atok vaga yugeragagi ako yi: “Averiniki en navi Yesaya yugugu hegek hit henombawi yugeragagi ako andi, avyarat yugogogi. Andi, ");
INSERT INTO nbq_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","27","‘It avakwa yi, inil hugwi, enaruk hunggwis, Enomaluk mbo baluk, namusek wagwis, Ogaguselok, An en sek okbugu neyawen, ‘Nenendawimbuk agwi, nenaruk nggulup agwi, Ninil huvulagwi, Ogarup andi it mikedagagwarikmu, Enaruk hunggik adigat ogarusogom ovara, dibasogom dek. Eke, inil hegek adigat ogarusogom ovara, yedok hasogom dek, Yiluk, yugeregek elak.’ yiluk, Yesaya wene ako yugirigya lagagirik, ambi inim yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Anderogoma, Ala en nenagap wendarup wene yi ako andi, it weram Yakuri dek menda hulupwak yiluk yugeregek lasogom atma, it andi, hulusogom hinilup arovovok yiluk yukheraliga,” yiluk, yugeragagi.  ");
INSERT INTO nbq_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Wene andi, yugirigya lagagimu, it Yakuri menda ako wenemuk yagan wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Tahun mberen elola en, o sidok dogop onggo bagek ogagya akoma werekma, at adema wagu-selok, ovok erogo endawi sek vaga woginipu lagagirik, ");
INSERT INTO nbq_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","alon dek dugwit Nenowa Inis Ombok Ala en denogo bagagi avema dogop wene ako yugirigya, Nenowa inis ombok Yesus Keretus wene mamulirigya, vagalogo yugirigya hegek, yeok-teok okbagatek welagagwa. Amin Lakbogogi wene ako andi, ovok yi hudi belagwi o. ");
INSERT INTO nbq_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Ai wa, nowa-nasin. Hit Ala aburi, Nenasin Ala Nenowa Inis Ombok Yesus Keretus Ala en denogo lakba wagagi ako, hinim hunik dugwit o Tesalonika homarisagwi ako, an Paulus ogo, Silas ogo, Timotius ogo, niren wene ambi yukherasogom o. Ala henabwa en okbugugu, henendawi ugun seyalek adenggen dogovovok yiluk, okhinipu, ogagya dogopwak o. ");
INSERT INTO nbq_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Nit hit henake samban ogagu dugwit, hit ovok agipik andi vaga ninggi-nanggi Ala, “Wa,” yugisagwi. ");
INSERT INTO nbq_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Hit Yesus ovaga vanggabaluk avyarat ombakluk ogarit lagwi; ap akwa henendawi hunik en sek okbigik lagwi; eke, Nenasin Inis Ombok Yesus Keretus Ala en denogo lakba wagagi ako vaga vonggabaluk wenggelek werekma, anggin henovaga agya hegek henendawi mbuk dugwit wugwi; ogasagwi ako andi, o ndugerek-ndagarek nenendawi wenggelek dugwit, Nenasin Ala yugisagwi o. ");
INSERT INTO nbq_vpl VALUES ("H11_4","082_1_4","1TH","1","4","5","Ai, nowa-nasin wa, Ala henabwa ombasiga. Niren Yesus ninim hunik dugwit, niniluk mondok dogop sek wene yukhera wagagup ako andi, we un nit nenane menda yukheregetek. Ata, Averiniki anye okbininggu hegek, yukhurugu ninigik, henendawima en, “Wene yi, mondok avyarat yukneralagwi o,” umbutu dugwit wogogup. Anderogo wugu lagagupmu, Ala mikhinipigi andi, ninelup aro. Nit henanggelekma dugwit, hit henake nggarogo ogarit lagu lagagup ako andi, henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Avakwa en mondok anggin-mbanggin okbugugu-sigik, Averiniki en henendawi adenggen okhinipu hegek, wene Yesus ninim hunik dugwit, niniluk mondok dogop sek wene yukhera wagagup ako, wugu lagagupik, nit Nenasin Inis Ombok Yesus ogasiga inim, nit ogasagwi inim, hit ndatak at ogagu lagagup. ");
INSERT INTO nbq_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Anderogo ogagu lagagupmu, it ap akwa avyarat ombasagwi ako o Makedoniya inim, o Akaya inim, ovok erogo hit Tesalonika menda ogasagwi vaga il wakhegek ogasagwi. ");
INSERT INTO nbq_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Hit ogasagwi vaga Nenasin ane ako o Makedoniya inim, o Akaya inim, andoma adigat mbigalit lagetek. Ata, yi awi ndi awi ovok erogo hit Ala avyarat umbutugup ako mbigalit lagagima, nit wene ambi yugurugu dogop dek at higyo o. ");
INSERT INTO nbq_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","It avyarat umbutugwa menda akoma en yugu dugwit, “Paulus melen it Tesalonika menda enadema wagu lagagumu, wokhinipwis, huvuwak ogagu lagagwa ako mbo baluk, Ala iluk agarik avyarat ako At ake denek dugwit eyavup ogagu dogoguluk mikedugwi, ogagagwa o,” yiluk, yugu-selagwi. ");
INSERT INTO nbq_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Eke, Ala en At abut Yesus hambuluk lendagwima en iluk erogo mondok okbagya lagagimu, hivis aninis en nit weyak okbininggu hao en, nenagap wendasiga Yesus mbogot vaga en wambu warup yiluk, it sokhelagwi o,” yiluk, hit ogasagwi ako ovok erogo nit yugu-selagwi. ");
INSERT INTO nbq_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Ai wa nowa-nasin. Nit un enam warogo bikhinisa wagetek ako, hit andi, henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Nit o Pilipi werekma, anggin-mbanggin nenovaga bininggwis, wiyiknom-weyaknom erogo okninipwis, ogagagwa henelup ako ovara, vivis, o Tesalonika dugwit, Ala wene sek wene ako it wisane en, “Nenanggon o,” yiluk, ninim ogorek inigik, Ala yonggat ninivisigama, nenalon embetetek yukhurugu lagagup. ");
INSERT INTO nbq_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Andi, nit henaruk watu dugwit, yukherelagwi ako andi, nit nininggut dugwit yukhirugwi, nit ambi hedaguluk yukhirugwi, henambutmu dagaluguluk, huluk wene yukhirugwi, ogasagwidek. ");
INSERT INTO nbq_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Ata, Ala en ninavut mbabaluk, niren Yesus ninim hunik dugwit, niniluk mondok dogop sek wene andok okbininggigi ako ndatak at yukherelagwi. Hit henendawi sek nenombarovovok yiluk yukherelagwi dek. Ata, at nenendawi avut mbalisiga Ala ako endawi sek nenombarupwak yiluk, yukherelagwi. ");
INSERT INTO nbq_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Nenane agilamok yukhurugu lagetek andi, henelup aro. Hit henangge ambi hedaguluk, nenane, “Ai-au” yagalagwi andi, at Ala elupma, yiluk, nenane yukhurugu lagatek. ");
INSERT INTO nbq_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Hit inim, it ap akwa adik inim, nit nininis wogobininapwak yiluk, wagetek. Eke, Keretus wene yugeregek nagu dogoguluk lakbigik menda bininggigi halok, nenane anye vaga yukheraup sek ovara, dek. ");
INSERT INTO nbq_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Ata, hwa ambi at eyak abwa en elola okbaluk yonggonisiga hak, nit henanggelekma dugwit, anderogo at nenane sagain erogo yukhurugu lagagup. ");
INSERT INTO nbq_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Henabwa adigat umbutu dugwit, hit nenendawi hunik okhinipugup atma, sek wene Ala en yukneragagi ako adigat yukheraup embetetek. Ata hit hinim hondo yup halok andi, sek at umbutugup. ");
INSERT INTO nbq_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Ai, nowa-nasin. Nit ogarit adigat lagu dugwit, nenanyedek erogo bininggigi ako andi, henendawi wenggeles. Sek wene Ala en yukneragagi ako yukhurugu dugwit, “Hit ambi anggin henovaga bugugu sao en,” ombakluk, niren hit henadema ambi nggino yukheregetek, ata, o hup-dingga nenadigat neneyavup okhedegek nagu lagagup. ");
INSERT INTO nbq_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Nit hit avyarat ombasagwi menda henanggelekma dugwit, Ala wene dibaluk ogagwi, eke, weyak ogagetek mondok sek ogagagup vaga henane ambi nenovaga bininggitek dugwit, ogarit lagagup ako andi, Ala ogo nenugu, eke hit ogo ninugwis, ogagagup. ");
INSERT INTO nbq_vpl VALUES ("H12_11","082_2_11","1TH","2","11","12","Ala mondok siyalek dugwit, “Hit An siyalek nabinak agirikmu yoma, navema omanes,” yiluk, yanggup yukheraliga ako, endawi ombasiga ndatak ogarit lagu dogovovok yiluk, ap ambi aburi halok yugeraliga ako hak, nit anderogo at hit henadik-henadik henendawi yonggonhinipwis, henendawi aik wakbugugwis, hit henaruk watwis, ogagu lagagup ako henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Anderogo atma, Ala wene yukheragagup hunggu dugwit, “Yi we un avakwa enane dek o. Yi Ala wene nit avyarat ombasagwi menda nenendawima holbininaliga wene avyarat o,” yiluk, wagagupma, nit mbup yegetek ndugurek-ndagarek “Ala wa,” yugisagwi. ");
INSERT INTO nbq_vpl VALUES ("H12_14","082_2_14","1TH","2","14","15","Ai, nowa-nasin. It ap Yakuri ako en it Ala yugirigya hegek yugurugu lagagwa navi-navi ako inutwis, Nenasin Yesus warogo bagwi, eke, nit ogo haryogo lakbinunggwis, ogagu lagagwa ako en it Ala aburi o Yudeya homarisagwi Keretus Yesus inim hunik agarwik ako, weyak okbigik lagu lagagwa. Anderogo ndatak, it henowa-henasin en hit anderogo at okbugugu-sigik henendawi mbuk dugwit, wugu lagagupma, it enendawi mbuk dugwit, wugu lagagwa ndatak, hit anderogo at welagwi hinigis o. It Yakuri menda ogagu lagagwa ako andi, it ap akwa ovok enanggon umbutu dugwit, inim ogorek werekma, Ala ogo, endawi sek enombasigadek, anggon ombasiga. ");
INSERT INTO nbq_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","It ako andi, avakwa weram Yakuri dek menda Ala en enagap wendarup wene, nit yugurugu dogogup en yiluk, sup ando mbalogo bininilagwi halok, it weyak ambi labok adigat ogarit wagagwa-wagagwa, “Andi hudi ari labuk,” hudi bagoma ako ari lagya halok, Ala aninis ap akwa enovaga bisaliga ako ndatak, yogwak ogo aninis mondok it enovaga bisaliga o. ");
INSERT INTO nbq_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Ai, nowa-nasin. Nit andi, nenendawi henovaga wenggelek adigat agurik ovara, ndugwis ambiat neneyave adik-adik welagagup, vage bikhinisa warup, “Ai,” adigat umbutu dugwit, wal okhegek adigat ogagagup ovara, dek agagi. ");
INSERT INTO nbq_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Naswei ninim bikhinisa warup ombasagwi, eke, an Paulus nadik ndugwis ambi vaga bikhinisaup dek o. Ata, ninggi-nanggi bikhinisa warup yiluk, wal okhagagis ovara, madis sile en sup monggalogo bininaliga halok, agurik. ");
INSERT INTO nbq_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Nit nenape wenggelek inim, nenendawi adenggen ombasagwi inim, sek ogagu niniselok nggudit-nggudit mendago yikbininggu halok, nenendawi sek ombarup ako inim, andi sa vaga embetep? Dek o. Hit vaga yikbininayogon o. Nit Nenasin Yesus wagya halok okbininup ako andi, hit avyarat ombakluk ogarit lendagwi vaga aro. ");
INSERT INTO nbq_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Nit siyabinunggwis, nenendawi adenggen erogo bininggwis, ogarup andi, hit heneyave vaga aro. ");
INSERT INTO nbq_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Anderogo atma, hit nggarogo agipik nininggut dogop meyan agya lagagimu, nit nenadik o Atena andenam mbup yup umbutu lagagurik, ");
INSERT INTO nbq_vpl VALUES ("H13_2","082_3_2","1TH","3","2","3","at nenaot Ala ayeloman dugwit, sek wene Nenasin Inis Ombok Yesus Keretus Ala en denogo lakba wagagi wene ako ninim yugeralagwi menda Timotius ako henadema lakba wagagup. At ako en, it avakwa anggin henovaga bigilagwi vaga wene andi, “Nenanggon o,” yiluk, mbo bagu hinisao, hit Yesus avyarat ombasagwi ako wadok dek erogo bugugu, hit henendawi aik wakbugugu, ogagya dogopwak yiluk, at henake lakba wagagup. Nit anggin-mbanggin nenovaga okbininup denek agurik ako andi henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Eke, hit ninim dugwit, ao okbininggitek hegek, “Anggin okbinunggu dogosogom o,” yukhurugu lagagup ako, ovok oklagagi andi, henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Anderogo atma, hit nggarogo agipik nunggut dogop meyan oknita lagagimu, at nit weyak ogarupwak yiluk nenendawi nggagalisiga menda ako en hit henendawi nggagalup hegek nit enam warogo wene yukhurugu lagagup hao en, nendawi anggin dugwit, hit henendawi Yesus ovaga vanggabaluk avyarat ombasagwi ako nggarogo ogasagwi an nelup arigiluk, henake ap Timotius lakba wagagis. ");
INSERT INTO nbq_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Eke, yogwak andi, at Timotius vage hit werekma en nit nenadema waga o. Nenadema wagya lagarik, hit Yesus avyarat ombasagwi wene inim, ap akwa hinim henendawi hunik okbugwis wene inim, eke, niren, “Hit bikhisaup ai,” ombasagwi hak, hiren, “It bigisaup ai,” nenombakluk, ninggi-nanggi henendawi nenovaga wenggenggu dugwit, henadenggen ombasagwi ako inim, sek wene andi yuknera waga o. ");
INSERT INTO nbq_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Anderogo ma, ai, nowa-nasin. Anggin-mbanggin nenovaga bininggu-selok, nenendawi anggin duvup yagan hulit lagusim, Yesus vaga avyarat ombakluk hit musek lagwi ako yuknera wagya lagama, nenendawi hora yigyo o. ");
INSERT INTO nbq_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Eke, yogwak hit Henasin Inis Ombok henendawi hunik dugwit, mondok wadok dek hiniselok, nit anggin en nenendawi wakedasogom dek. Nenadenggen dugwit, ogarit lagu dogosogom aro. ");
INSERT INTO nbq_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Hit ogarit lagwi vaga nit nenendawi adenggen wisane okninivisiga ma, nit Ala ombok erogo “Wa, wa, wa” yiluk, yugisagwi. ");
INSERT INTO nbq_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Nit heneloke hinugu dogomindik, Yesus vaga vanggabaluk hit avyarat ombasagwi ako ambi ao henendawi hoda agatek halok, ambi inim yukheraguluk, hup-dingga nenendawi adenggen ombok erogo umbutu dugwit henake samban ogasagwi. ");
INSERT INTO nbq_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Nit bikhinisa warup ako Nenasin Ala Nenowa Yesus iperen en sup mbilogo amot erogo okbininapwak yiluk, samban ogasagwi. ");
INSERT INTO nbq_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Niren hit nenendawi mondok hunik okbigilagwi ako ndatak, hit-hit inim, ap akwa ovok inim, ambi inim nendawi-hendawi hunik ogonupu dogop Nenasin Inis Ombok en okbugugu, ");
INSERT INTO nbq_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","eke, Nenasin Yesus at aburi ake denek menda inim wagu dogomundik, hit weyak ogagetek mondok sek adigat ogagu hiniselok, Nenasin Ala anggin henovaga bigigayogon buk yiluk, henendawi wadok dek okbugugu, ogagya dogopwak o. ");
INSERT INTO nbq_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Ai, nowa-nasin o. Wene atok vaga ambi yukheraup umbuturikmu yukherasogom. Ala endawi sek henombarupwak yiluk, “Nggarogo ogarit lagu dogop?” mamulheragagup ako, ovok ogarit lendagwi ovara, ambi inim mondok ombok erogo ogarit lagu dogovovok yiluk, Nenasin Inis Ombok Yesus en yuknirigya halok yukheralagwi. ");
INSERT INTO nbq_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Nenasin Yesus en, “Yugeranes o,” yiluk, yuknirigya lagagimu, wene, “Yerogo ogarup, nderogo ogarup,” yiluk, yukhurugu lagagup andi, henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","At Ala en hit weyak ogagetek At ake denek adik dogop ombasiga ako andi, hit avakwa ugun ogarup moga yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("H14_4","082_4_4","1TH","4","4","5","It avakwa weram menda ako en Ala ininggut dugwit, enendawi ninggya halok akwa ugun-ugun ogonivit nagwis ako hak, hit anderogo ogagu dogop dek. Ata, hininis sek dogopwak yiluk, “Ala inis vaga dambubininaup o,” yiluk, weyak ogagetek enabwa umbutu dugwit, henogwai hidugu dogop. ");
INSERT INTO nbq_vpl VALUES ("H14_6","082_4_6","1TH","4","6","7","Nit weyak ogagu dogopwak yiluk, at Ala en mikninipigibuk. Ata, weyak ogagetek at ake denek adik dogoguluk, mikninipigirikmu, nit endak nenane anye vaga yukhurugu lagagup ako ndatak, it avakwa weyak anderogo ogaguselok, Ala en onggo hologo okbininiliga atma, henaswei weyak okbugu dugwit, wanggis waup moga. ");
INSERT INTO nbq_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Anderogo atma, ap ambi en, “Wene yi, Ala en yagas dek. Ap enat yagao o,” yiluk, weyak erogo mbo bagya halok, aren ap akwa mbo bisaliga andi dek. Ata, at sek adik denek Averiniki wokneraliga Ala ako at mbo baliga. ");
INSERT INTO nbq_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Henaswei Yesus avyarat ombasagwi menda hinim henendawi hunik okbisilin lendagwi ako andi, Ala en ovok mamulheragagirikmu, wene andi menda ambi dirup mbalheraup dek higi. ");
INSERT INTO nbq_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Hit henowa-henasin ovok erogo o Makedoniya menda ako, avyarat henendawi hunik okbisalagwi ovara, ambi inim henendawi hunik oginipu dogovovok yiluk, yukheralagwi. ");
INSERT INTO nbq_vpl VALUES ("H14_11","082_4_11","1TH","4","11","12","It ap akwa Yesus avyarat ombasagwidek menda en hit des erogo ogarit lagu hiniselok, henagayuk wutu dogopwak yiluk, it nin enawene ako ilimik-ilimik yubuk. Ata, hit hininis sek dogovovok yiluk, henamwa des erogo dugwit, ap it nin enovaga henendawi vonggabigitek hit hininggis en okbetaluk nunggwi, eke, nit endak henaruk watugup ako des erogo ogagwi, ogagu dogovovok yiluk, yukheralagwi. ");
INSERT INTO nbq_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Ai, nowa-nasin. It ap akwa hambuluk nggarogo oklendagwi wene ako, hininggut dogop andi, nenanggon. Avakwa nin hambuluk iniluk okbisaup wene ako enendawi Yesus vaga vonggabagatek halok, enaswe ambi hambigya halok enendawi wakedelagwi hak, hit henendawi anderogo at wakidugu dogogup en yiluk mbilinogo yukherasogom. ");
INSERT INTO nbq_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","At Yesus hambigya lagagirik, iluk mendok yagagi ako nit avyarat ombasagwi halok, it ap akwa Yesus inim hunik dugwit, hombagagwa ako at Ala en iniluk erogo mendok okbisaup avyarat ombasagwi. ");
INSERT INTO nbq_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Nenasin Inis Ombok yagagi ndatak, niren yukheralagwi o. At wagya halok, it ap akwa hombagagwa ako ao iniluk mondok yegetek inigik, nit ao niniluk agurik ako nenendak dagasogom buk. ");
INSERT INTO nbq_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Ata Nenasin Inis Ombok ako en hum iris, yonggo lakbisa wandiga menda enowa ombok malaikat ako en ane iris, Ala angge ane ombok ogasiga menda trompet ako ane ogagya, ogagu dugwit, Nenasin mbogot vaga en wambu wagya hegek, it ap Keretus inim hunik dugwit, hombagagwa ako, at Ala en enendak iniluk mendok okbisayogon. ");
INSERT INTO nbq_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Iniluk mendok okbugu dogomindik, nit niniluk ao agurik ako, it ninim hena anggelekma ilim andenam Nenasin Yesus ninim dambuluguluk, woknenombolok dagasogon. Woknenombolok inggya halok, Nenasin Yesus ninim mondok-mondok dogosogom. ");
INSERT INTO nbq_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Wene andi, Nenasin enat yukneragagirikmu, andi vaga henendawi aik war-wat yugu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Ai, nowa-nasin. Yi ogarup wene yukhirigyo ako andi, “O ngga vaga warimi, saut nggao irisim warimi a, tahun ogagusim warimi a?” henelup arovovok yiluk, dirup mbalheraup dek. ");
INSERT INTO nbq_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","At Nenasin warup hudi ako andi, ap enonggop welagwi menda en o hup wendagwi ako hak wasogon andi, ovok henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","It ap akwa en, “Wene ambi nenovaga agatek nit ovok sek atma, nenendawi ugun adenggen at agurik o,” yugu-sigik, hwa avula eyak endaklarup unggutmu, idup en yagan wasiga ako hak, Nenasin mbikit supuk erogo wagya dugwit, mondok weyak erogo bisa warisogon atma, it ambi hoda wulusogon mondok dek aro. ");
INSERT INTO nbq_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Anderogoma, nowa-nasin. Hit andi, henendawi o hup ovagak hininggut agipik dek. Ap enonggop welagwi menda en o hunogoma nunggigya halok, enanggela wilisiga ako hak, o andi hudi hit anderogo henanggela wilisogon dek. ");
INSERT INTO nbq_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Hit ovok erogo avakwa o hup vaga dugwit ogasagwi ako hak dek. Ata, dingga vaga dugwit ogasagwi menda ako hit aro. Eke, it ap akwa o hwiserek vaga dugwit ogasagwi hak hit dek. Ata, it o awia vaga dugwit, ogasagwi ako hak hit atma, ");
INSERT INTO nbq_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","it ap akwa nin nogo yilagwi menda ako hak nit anderogo nogo yugu dogop dek. Nit nggungguk nogo yigitek suam watu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","It ap akwa nogo yilagwi menda ako andi, o hup at nogo yilagwi. Eke, it amburup nenek okninivupwak yiluk, nelagwi menda ako andi, o hup at nelagwi ovara, ");
INSERT INTO nbq_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","it dingga ogasagwi ako menda nit atma, nit nggungguk nogo yigitek suam adigat watu dogosogom. Ap yegen werek en, meda narugup en yiluk, sin agap vaga yikedalagwi andi hak, niren, madis sile, weyak okbininagwi en yiluk, nenendawi Yesus vaga vonggabaluk avyarat umbutwi, ap akwa nenendawi hunik okbugwis, ogagu dogosogom. Eke, ap yegen werek menda narugup en yiluk, unggul agasum mbusi menda danggulik ako vonggabaluk agarik hak, nit ogo, madis sile ako en, ninarugwi en yiluk, Ala en nenagap wendakninivisogon umbutu dugwit nenendawi vonggabelagwi. Roman Soldier LB 000196 ");
INSERT INTO nbq_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","At Ala en aninis nenovaga bininigiluk, denogo bininggitek. Ata, at Nenasin Yesus Keretus en nenagap wendarupwak yiluk, denogo bininggigi. ");
INSERT INTO nbq_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Nit niniluk agurik halok, ata hambugu niniselok, at ninim niniluk mondok dogoguluk, nit nenake hombagagi. ");
INSERT INTO nbq_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Anderogoma, hit henendawi aik war-wat yugwi, eke, at ambi en at ambi endawi hoda okbagwi, ogarit lagwi ako yogwak ndatak ogarit lagu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Ai nowa-nasin. It ap Ala aburi enasini henanggelekma enanyedek erogo okbugugwis, Nenasin inim hunik dugwit henaruwam agarwik, eke, mbilape yukhurugwi, ogasagwi ako enagayuk wutu dogovovok yiluk, yukheralagwi. ");
INSERT INTO nbq_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","It ogarit lagwi andi vaga hit henendawi hunik okbugu dugwit, wogobugu dogovovok yiluk, yukheralagwi. Hit henendawi ambiat dambulik dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Ai, nowa-nasin. It ap yavup okhedaup enanggatek iniselok, enaruk watwis, eke, it Yesus avyarat umbutu dugwit ogagu dogop inugut adigat embetek nagu-selok, enendawi hora okbugwis, enendawi ao hoda agatek halok, enendawi hoda okbugwis, eke, avakwa ovok henane sagain yugurugwi, ogagu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Weyak onggo-onggo ogagu hinisao en, dibatugu dogones. Hit-hit inim, it ap akwa ovok erogo inim, sek adigat ogagek yumwak yiluk, dibatugu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Henendawi adenggen adigat umbutu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Mbup yegetek samban adigat ogagu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Hit Keretus Yesus hinim hunik dugwit, ogarit lagu dogop hinimbitigi ako andi, yi menda ndi menda okbigigalagwi ako, Ala adigat “Wa,” yugugu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Hali nagaup yagaliga hak, henendawi Averiniki yukheraliga ako nagalogo baup andi moga. ");
INSERT INTO nbq_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Eke, Averiniki en yugirigya hegek, yukherelagwi wene ako, wiyiknom-weyaknom erogo baup andi, moga. ");
INSERT INTO nbq_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Yi wene ndi wene yagalagwi ako avut mbabaluk, eyave halok adigat nggitik-nggetok erogo vagogo dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Yi weyak ndi weyak andogon yedok halok, mbo bagu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Nenendawi ugun seyalek adenggen okbininaliga Ala ako, hit heneyave at ake denogo bugugu dugwit, henendawi weyak mondok horogo bigigapwak. Eke, Nenasin Yesus Keretus warugwi hudi, hit heneyave-henendawi ovok erogo weyak ogagatek dogosogon vaga, ane ambi henovaga bigigagwi en yiluk, okbugugu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","At yanggup yukneragagi ako en, yagaliga ako andi adik ambi asigadek, ovok des erogo ogasigama, ako at ogagya dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Ai, nowa-nasin. Nenake samban ogagu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Heyaga war-wat yugu dugwit, henendawi hunik vaga dinggik-hambup yugu dogones. ");
INSERT INTO nbq_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Nit dirup mbanggup yi, it nenowa-nenasin avyarat ombasagwi ovok inivaga mbilinogo yugeravovok yiluk, Nenasin inis vaga yukheraliga o. ");
INSERT INTO nbq_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Nit Nenasin Yesus Keretus henabwa en okbugugu dogopwak o. Wa nowa-nasin! ");
INSERT INTO nbq_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Ai nowa-nasin. Hit Ala aburi Nenasin Ala Nenowa Inis Ombok Yesus Keretus Ala en denogo lakba wagagi ako hinim hunik dugwit o Tesalonika homarisagwi ako, an Paulus inim, Silas inim, Timotius inim, niren wene ambi yukherasogom o. ");
INSERT INTO nbq_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Nenasin Ala Nenowa Yesus Keretus iperen henabwa en okbugugwis, hit henendawi ugun seyalek adenggen dogovovok yiluk, okhinipwis, ogagu dogopwak o. ");
INSERT INTO nbq_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Ai, nenowa-nenasin. Hit vaga Ala “Wa,” yugurup adigat okninivisiga. Hit Yesus vaga vanggabaluk avyarat ombasagwi ako, hoda arit lagya, eke, nendawi-hendawi hunik okbugwis andi, wisane arit lagya, ogasagwima, “Ala wa,” yugisagwi ako andi, sek at ogasagwi. ");
INSERT INTO nbq_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Anderogo atma, hit edup-mbedup okbugugu-sigik, henendawi mondok wadok dek dugwit Yesus vaga avyarat umbutwi, eke, anggin henovaga agya hegek, henendawi mbuk dugwit wugwi, ogasagwima, nit Ala aburi yi awi di awi homarit lendagwi yugeregek lagu dugwit, siyabigilin nelagwi o. ");
INSERT INTO nbq_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Hit Ala avema dogop mikedagagup halok, edup-mbedup okbugugwis ako andi, henendawi mbuk dugwit welagwima, Ala en, “Hit sek atma, an werekma yoma nunggu warup sek aro,” yukherayogon halok, Ala en nenowak dilisogon ako andi, weyak dek sek at nenowak ndilisogon yedok hagup. ");
INSERT INTO nbq_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","At Ala ilup dugwit atma nggedok ogasigama, iren anggin hit henovaga bigigalagwi ako, onggo aren it anggin enovaga bisayogon. ");
INSERT INTO nbq_vpl VALUES ("H21_7","083_1_7","2TH","1","7","8","At Nenowa Yesus, it malaikat wakangget mondok enagayuk werek ako inim mbogot vaga en hali abya anggelekma wambu wagu dugwit, it ap akwa Ala enanggon dugwit, sek wene Nenowa Inis Ombok Yesus Keretus yagagi wene ako sek erogo wegetek halok, weyak onggo wogora wasogon. Yogwak anggin hit henovaga agarik ako, o andi hudi, nit ninim nenendawi seyabininayogon. ");
INSERT INTO nbq_vpl VALUES ("H21_9","083_1_9","2TH","1","9","10","Andi hudi vaga nit at aburi ake denek ako en at eyave siyabagwi, eke, nit wene vagalogo yukheragagup vaga avyarat umbutugup atma, hit ninim avyarat ombasagwi menda ovok at, “Vok!” yugwi, ogarupwak yiluk, warisogon. Wagya halok, it Ala enanggon dugwit sek wene wegetek menda ako, weyak onggo mondok-mondok hunik oginipu dogopwak yiluk, at Ala en, “An nabinak segedokma nanye agirikmu nelese vaga yenam dogop dek o,” yiluk, weram haryogo wibisayogon. ");
INSERT INTO nbq_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Andi atma, At Nenasin Ala en sek ogarit lagu dogovovok yiluk, henayanggup yukheragagi ako, hit ndatak ogarit lagu hiniselok, “Sek ogagep o,” yiluk, yukhirigya dogopwak yiluk, henake samban hunik ogasagwi. Eke, Yesus vaga avyarat ombakluk sek ogarup embetep ako, ndatak ogarovovok yiluk, henanye okbugugu dogopwak yiluk, henake samban hunik ogasagwi. ");
INSERT INTO nbq_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Nenasin Ala At Nenowa Yesus Keretus iperen henabwa en okbugugu-sigik, hit anderogo at ogarit lagu dugwit, At inis siyabagwi, aren hit ogo wogobigigu, ogagu dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Ai wa, nenowa-nenasin. At Nenasin Yesus Keretus wagya halok, nit at ninim homakbininup wene ako yukherasogom. ");
INSERT INTO nbq_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","It ap akwa en, “Nenasin warup ako ovok vanggo yi waga o,” yiluk, yagan wagu dugwit, at ambi en, “Ala en wene yuknugu halok, yukheraliga o,” eke, at ambi en, “Dek o. Paulus en yuknogogimu, yisogon o,” ata, “Paulus en dirup mbanggigirikmu, yukherayogon o,” yiluk, it yagan wagu-selok, mbikit henalon en henendawi dek agu hinisao en yiluk, yukheraliga o. ");
INSERT INTO nbq_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","It ap akwa huluk anderogo yagan wagu dugwit, henambutmu dagagup en, dibugu dogones. Nenasin warup ako andi, ap akwa wisane en Ala wene, “Nenanggon o,” yiluk, mbo bagatek hegek, eke, at ap mondok weyak dombok ogasiga, elese dek erogo baup ake denek ako, sigam ari wagatek hegek, warisogon buk o. ");
INSERT INTO nbq_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","It avakwa en yi menda ndi menda mikbaluk, “Nenasin Ala aro,” yiluk, agayuk wutwis, huvuwak ogovak higirogo baluk, siyabagwi, ogasagwi menda ovok erogo at ap mondok weyak dombok ogasiga ako en sovalogo bisiluk, at adigat siyabatigya dugwit, Ala awi valekma o Yerusalem mendok yi nunggigya dogomindik, “Henasin Ala an aro,” yiluk, yugirigya dogosogon. ");
INSERT INTO nbq_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","An endak hit ninim dugwit, wene yi ovok yukheragagis ako henunggut agagup a, ao hinilup agipik a? ");
INSERT INTO nbq_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","At mondok weyak dombok ogasiga ako andi, o ngga vaga sigam ari warup mirik agarik ako vaga warupwak yiluk, at ambi sa en sovabaluk agarik ako henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","At madis sile anye vaga weyak ogarit lendagwi ako andi, avakwa vage ogarit lendagwi ovara, at sovalogo baliga ako wolok enggetek hegek, weyak ombok wigalarisogon buk. At sovalogo balin lagyama, sovalogo balin lagya dogosogon aro. ");
INSERT INTO nbq_vpl VALUES ("H22_8","083_2_8","2TH","2","8","12","At wolok inggya halok andi, at mondok weyak dombok ogasiga ako sigam ari wasogon. Sigam ari wagya dogomindik, sile ogasiga wane-wane at anye vaga ogarit lagya dugwit, “Ala anye vaga ogasiga,” ombarupwak yiluk, huluk enalon werek menda ogagya, nggarogo ogarubuk menda ogagya, nadok-hadok wisane ogagya, ogarisogon. Ogagya dugwit, it avakwa Ala en enagap wendarupwak yiluk, avyarat wene Yesus avok ako enendawi sek embetetek waup enanggon dogosogom vaga weyak erogo bisaup ako, enambokan dagaligiluk, ane adik wisane molalogo yugirigya dogosogon. It ako, huluk wene yagan wagya ako avyarat ombarupwak yiluk, Ala en enendawi apik erogo bisayogon. Eke, it avakwa avyarat wene ako wegetek weyak ogarup adigat enendawi hogop ombarit lendagwi ako ovok erogo enowak dibaluk, weyak enovaga bisayogon. Andi en, at mondok weyak dombok ogasiga anderogo ogarit lagyama, Nenasin Yesus mondok siyalek agayuk werek wagya dugwit, elagap agavuk vaga eyave mondok dek erogo warogo ba wasogon. ");
INSERT INTO nbq_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Ai wa, nowa-nasin. Hit Ala henabwa ombasiga ako vaga Ala wa yugurup adigat okninivisiga. Ala en, henagap wendarigiluk, hit endak erogo mikhinipigi. Mikhinipigima, Averiniki en hit henendawi weyak horogo bugugu, avyarat wene Yesus avok avyarat umbutwi, ogasagwi ako vaga henagap wendarisiga. Anderogo atma, hit vaga “Ala wa,” hunik-hunik yugisagwi. ");
INSERT INTO nbq_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Hit anderogo at henagap wendarigiluk, nit sek wene yukheragagup ako vaga yanggup yukheragagi. Nit Nenasin Yesus Keretus mondok abinak agarik ako hit hinim ndatak abinak dogovovok yiluk, yanggup yukheragagi. ");
INSERT INTO nbq_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Anderogo atma, naswei o. Yi wene ndi wene nenane vaga yukhurugu lagagup inim, dirup warek vaga yukhurugu lagagup ako inim, henendawi wadok dek dugwit, wene andi, nggitik-nggetok erogo vagogo dogones. ");
INSERT INTO nbq_vpl VALUES ("H22_16","083_2_16","2TH","2","16","17","Nenasin Ala ako nenabwa en endawi hunik okbininggu dugwit, nenendawi mondok-mondok aik wakbininggu, nenendawi wenggelek mbogot vaga menda ako woknirigya, ogasiga ako andi, At Nenasin Yesus Keretus inim it mberen en hit sek ogarit lagwi, henane sek adigat yugeregek lagwi, ogagu dogovovok yiluk, henendawi aik wakbugugwis, henanye erogo okbugugwis, ogagu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Ai, nowa-nasin. Wene ovok at yukhirigyo ovara, atok vaga ambi yukherasogom o. Nenasin Yesus ninim hunik dugwit, niniluk mondok dogop wene ako hit wugu lagagupik, mbigalit lagu dugwit, wene ako wogobalin nagu lagagup ako ndatak, nit anderogo at yi awi di awi hodo erogo yugeregek nagu dogoguluk, nenake samban ogagu dogones. ");
INSERT INTO nbq_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Eke, it ap akwa wisane Ala en denogo bagagi Yesus ako avyarat embetetekma, it ap weyak ogasagwi menda ovok weyak adigat ogarit lendagwi andi en, nit weyak erogo bininggu hao en, Nenasin en nenagap wendarupwak yiluk, nenake samban ogagu dogones. ");
INSERT INTO nbq_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","At Nenasin andi, at yagaliga andi adik asigadek, mondok des erogo ogasigama, Aren henanye okbugugu, eke, at weyak ogasiga menda ako en weyak okbigigagwi en yiluk, henaruwam watya, ogagya dogosogon. ");
INSERT INTO nbq_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Hit ogagu dogop wene yukherelagwi ako andi, vage ogasagwi ninelup. Eke, hit ambi inim ogagu dogovovok yiluk, Nenasin en okbigigayogon. ");
INSERT INTO nbq_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","At Ala en yi ap akwa ndi ap akwa endawi hunik oginivisiga ako hinilup okbugugu, eke, Keretus anggin-mbanggin ovaga agya hegek, endawi mbuk dugwit wogogi ako ndatak, hit anderogo at henendawi mbuk dugwit wugu dogovovok yiluk, okbugugu, Nenasin en ogagya dogopwak o. ");
INSERT INTO nbq_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Ai wa, nowa-nasin. Nit Nenasin Yesus Keretus inis vaga wene ambi yukherasogon o. Wene, “Anderogo ogagu dogones,” yukhurugu lagagup ako, henaswei nin ogagetek yavup enanggon en un nagu hiniselok, hinim nagu dogop dek. ");
INSERT INTO nbq_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Hit ninim dugwit, nit un welagetek sadida ogarit lagagup ako, hit wakhegek ndatak ogarit nagu dogop andi hinilup aro. ");
INSERT INTO nbq_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Nit hit hinim dugwit, henagarom onggo dek un nunggu lagetek. Nit andoma wagu lagagurik, hit anggin ambi inim henovaga bugugu ninasao en, nenagarom namunda nggino yukheregetek hutun-howam nininggis vaga okhedegek nagu dugwit, nenanyedek erogo bininggugwa ako henelup aro. ");
INSERT INTO nbq_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Henangge-henangge nggino yukherelok un naup sek ovara, nit ogarit lendagwi vaga wakhegek hit ndatak ogagu dogovovok yiluk, ogagu lagagup. ");
INSERT INTO nbq_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Ninim dugwit, “Ap ambi yavup ogagetek halok, erom wogurubuk,” yukhurugu lagagup. ");
INSERT INTO nbq_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Hit nin henovadombok okhedegetek it nin enawene ako ilimik-ilimik yegek nagu dugwit, yavup ogagetek enanggatek ugun-ugun ogarit lendagwi yugu-sugupma yiluk, yukherelagwi. ");
INSERT INTO nbq_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","“It ap anderogo ogasagwi andi, eneyavup des erogo okhudugu dugwit, it enagarom adigat nunggu dogopwak,” yiluk, wene andi Nenasin Yesus Keretus inis vaga henaruk wasagwi. ");
INSERT INTO nbq_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Ai wa, nowa-nasin. Hit andi, sek okbigik lendagwi ako henanggon okbugugu halok, “Nenanggon,” ombarubuk. ");
INSERT INTO nbq_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Nit wene yukherelagwi dirup warek yi, at ambi en, “Ogarup, nanggon o,” iri halok, ap andi, eyave dibagu dogomundik, anggadi arupwak yiluk, hinim avuk arubuk. ");
INSERT INTO nbq_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Ninim ndup ogorek ovagak dogop andi dek. Ata, “Nenaswe atma,” yiluk, wene aruk des erogo wares. ");
INSERT INTO nbq_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Yogwak nenendawi ugun wadok dek adenggen okbininaliga menda Nenasin ako en yi ogagek di ogagek ovok erogo ogarit lagu hinigik, henendawi ugun wadok dek adenggen dogovovok yiluk, okbisilin lagya dogopwak. Hit ovok erogo Nenasin hinim dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","“At Paulus enat dirup yi lakba waga higi,” ombarupwak yiluk, atok vaga heyaga wakbisiliga wene andi, an ninggis vaga en mbalisigama, dirup yi, “At enat yukneraga,” ombarovovok yiluk, atok vaga heyaga wakbigigaliga wene yi, an ninggis vaga enat mbalheraliga o. ");
INSERT INTO nbq_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Nit Nenasin Yesus Keretus hit ovok erogo henabwa en okbugugu dogopwak o. Ai wa, wa! ");
INSERT INTO nbq_vpl VALUES ("T11_1","084_1_1","1TI","1","1","2","Nabut Timotius wai. At nenagap wendarisiga menda Ala inim, Nenowa Inis Ombok Yesus Keretus Ala en denogo lakba wagagi ako nenape wenggelek agurik ako inim, iperen en wene denggalogo yuknogogwa vaga an Paulus Keretus Yesus lakbigik menda okbanunggugwa ako en, nit Yesus avyarat ombasagwi ako vaga nabut dombok agagindikmu, wene ambi yukhisogon o. At Nenasin Ala, Nenowa Keretus Yesus iperen habwa en okbagagwi, enaigwak abet en okhitwis, eke, hendawi ugun adenggen wadok dek dogonyok yiluk, okbagagwi, ogagu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","An o Makedoniya warigiluk, ogagya dugwit, “Hat o Epesus yenam dogwen o,” yiluk, nane abet erogo yukhogogis ako andi, ambi inim yukhisiga. It ap nin avyarat wene enunggut dugwit wene adik huluk wene yagalagwi ako, “Mamuleraup moga,” yiluk, yugirigya, ");
INSERT INTO nbq_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","eke, “It avakwa mukpilin mbilinggwis, ap enadem endago mbilinggu dugwit, mbup yegetek likhelok lagwi, ogasagwi andi, moga,” yiluk, yugirigya dogonyok yiluk, yenam dogwen yukhogogis ako ambi inim yukhisiga. Wene andi menda mbilinggu dugwit, nenendawi Yesus vaga vanggabaluk avyarat ombasagwi vaga Ala en okbininup imbitigi ako nenelup arumwak yiluk yuknerelagudek un wene adem belanggu dugwit, nane-hane yagalagwima, moga, yiluk, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Eke an wene yukhisiga yi, avakwa nabwa-habwa ombarupwak yiluk, yukhisiga. It enendawi weyak embetetek sek adigat ogagwi, enendawi eyave vaga Yesus avyarat umbutwi, ogasagwi ako vaga avakwa enabwa ombasagwi atma, anderogo ogagu dogopwak yiluk “Yugirigya dogwen,” yiluk, yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Avakwa nabwa-habwa ombarup wene an yukhisiga yi, ogarup hegek avakwa nin en nomalogo hekbaluk, wene dek arup menda adigat enam warogo mbilinisagwi. ");
INSERT INTO nbq_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","It ap andi en, “Musa wene mamuleralagwi menda nirat dogosogom,” ombasagwi ovara, it mamuleralagwi inim, eke, enane anye vaga, “Andi avyarat ninilup o,” yiluk, yagalagwi inim, it enendawi we ugun ininggut dugwit, yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Ala wene yugup Musa en dirup mbanggigi ako des erogo ogaruguluk, welagwi halok andi, sek helagwi. ");
INSERT INTO nbq_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Musa wene ako andi, ap enendawi sek iniselok yugeregetek andi, ninilup. Eke, it ap Ala wene yugup sagalisagwi menda inim, enasini enane hulup enanggon ombasagwi menda inim, Ala agayuk wurup enanggon ombasagwi menda inim, it weyak ogasagwi menda inim, samban ogarup enanggon umbutu dugwit ugun-ugun ogarit lendagwi menda inim, inisai-enasini enasagwi menda inim, avakwa ugun-ugun enarit lendagwi menda inim, ");
INSERT INTO nbq_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","avakwa wanggis welagwi menda inim, ap-ap ogasagwi menda inim, avakwa eneyak enaburi hwilak inivisagwi menda inim, enane huluk yagalagwi menda inim, enane huluk wene enovaga biselagwi menda inim, andi ogasagwi ovok erogo wene Ala aburi nggarogo ogarit lagu dogop modo wene ako hegek adik ogaguselok, Musa wene ako enake yugeragagi nenelup aro. ");
INSERT INTO nbq_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Modo wene ako at Ala siyalek abinak agarik ako en sek wene Yesus ninim hunik dugwit, niniluk mondok dogop wene ako, an vagogo dogopwak yiluk, andok okbaninggigi ako, aro. ");
INSERT INTO nbq_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","An nanye okbaniliga menda Nasin Keretus Yesus ako en, “Ap yi, ambi ogagya dogopwak yiluk, denogo bayogon halok, des erogo at ogagya dogosogon,” nimbita lagagirik, an yavup ambi ogagya dogopwak yiluk, denogo baninggigima, “Wa,” yugisiga. ");
INSERT INTO nbq_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","An endak “Yesus andi Ala abut dek,” yiluk, wiyiknom-weyaknom erogo bagya, naninis en, at ane welagwi menda enarit lagya, wiyiknom-weyaknom erogo bugu, ogagya lagagis ovara, an Yesus vaga vanggabaluk avyarat embetetek un ninggut dugwit, ogagya lagagimu, Ala aigwak abet en hekbaninggigi. ");
INSERT INTO nbq_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Nenasin Keretus Yesus nabwa en okbanenggek adigat ogagya dugwit, Yesus ako Ala abut an avyarat ombarupwak yiluk okbaninggya, eke, avakwa nendawi hunik ogonipu dogogiluk okbaninggya, ogagagi. ");
INSERT INTO nbq_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","“Avakwa weyak ogasagwi menda ako enagap wendarigiluk, Keretus Yesus o yoma wambu wagagi,” yiluk, yagalagwi ako andi, avyarat wene atma, waup sek aro. Avakwa ovok erogo weyak ogasagwi ovara, an ako mondok eve weyak ogagya lagagis, ");
INSERT INTO nbq_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","adem andi vaga At aigwak abet en hekbaninggigi. Hivis it avakwa iniluk mondok dogop ombasiga ako en enenedawi At ovaga vanggabaluk, avyarat ombasagwi vaga wugu dogop ako, il wakhegek ogagu dogop an neyave aro. Niren Yesus Keretus weyak okbelagwi ovara, onggo mbikit okbininaliga dek dibaluk okbininaliga ako, weyak ogagya eyave iya an neyave ako vaga sigam arupwak yiluk, aigwak abet en hekbaninggigi. ");
INSERT INTO nbq_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Eke, avakwa endak welagagwa inim, yogak agarwik inim, o hivis dogogup inim, Nenasin inis ombok hambisigadek iluk mondok itok menda ninil helagudek Ala adigat agarik ako inis mondok-mondok abinak agayuk werek dogopwak o. Amin! ");
INSERT INTO nbq_vpl VALUES ("T11_18","084_1_18","1TI","1","18","19","Eke, nabut Timotius wai. Hat ao ogagetek heyagek, Averiniki en Ala aburi enasini yugirigya hegek yukhugu dugwit, “Hivis anderogo ogagya dogogun o,” yiluk, yukhogogwa wene ako hat vagago dogonyok yiluk ambi inim yukhisiga. Vagago dugwit ogagya heyalok, ap ndup wakangget agarik ovagak, hat anderogo hanye erogo halon dek dugwit ogarit lagya dogosogon. Hat hendawi Yesus avyarat ombasiga inim, hendawi sek ombasiga halok adigat ogarup inim, mondok nggitik-nggetok erogo vagogo dogosogon. It ap Himeneyus, Alekander ogo, ap nin inim Yesus vaga vanggabaluk avyarat umbutugwa ako mbo baluk, adik ogarit lendagwi. ");
INSERT INTO nbq_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","It anderogo ogasagwima, anen Ala inis miyuk-meyan erogo baup enalon ombarupwak yiluk, madis sile inggimu okbogogis. ");
INSERT INTO nbq_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Andi halok, wene endak yukhirup imbiti ako yukhisogon o. Yi avakwa ndi avakwa ovok erogo enake samban ogarup. It vaga Ala wa yugugwis, enake nggino yugugwis, ogagu dogovovok yiluk, nane avuput vaga yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","It ap ombok-ombok inim, ap ininis werek ovok erogo inim, enake samban ogagu dogwes. Iren sek erogo nenaruwam inigik, nenendawi sek vaga Ala musek lagu dugwit, ugun adenggen wadok dek dogoguluk, it enake samban ogagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Anderogo ogagu hiniselok, sek at ogasagwi. Eke, nenagap wendarisiga Ala ako endawi adenggen nenombasiga. ");
INSERT INTO nbq_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Aren yi avakwa ndi avakwa ovok erogo At avyarat wene Yesus avok ako enelup akluk enagap wendarup ai, ombasiga. ");
INSERT INTO nbq_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Andi, At Ala ambiat agarik. Eke, avakwa inim, Ala inim, serak enake yonggo lakbagek ap ambiat Keretus Yesus aro. ");
INSERT INTO nbq_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","Yi avakwa ndi avakwa ovok erogo heda visilogo bisagiluk, eyave vaga enonggo bagagi. Enonggo bagagi ako andi, At abut lakba warup imbitigi ako sigam arup hudi vanggo iri lagagimu, sigam agagi. ");
INSERT INTO nbq_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Ala en yi avakwa ndi avakwa ovok okbisaup imbitigi ako, it ap weram Yakuri dek menda avyarat wene Yesus ovaga vanggabagu-selok, enagap wendarisogon wene ako mamuleregek lagya dogogiluk mendok okbaninggigi. Eke, yi awi ndi awi yugeregek lagya dogogiluk, lakbigik menda baninggigi. Wene andi, huluk dek mondok avyarat yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Anderogoma, it ap yi awi ndi awi ovok erogo enaninis umbutwi, winimuk yugwi, yegetek sek adigat dugwit, ininggis ilikbaluk, samban ogagu dogopwak yiluk, “Ai!” dombok ombasiga. ");
INSERT INTO nbq_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Eke, it akwa enendawi werek en enayum des erogo yikhedelagwi hak, yi akwa ndi akwa ovok erogo enendawi werek akluk, anderogo at enayum enanggem nggitik-nggetok erogo yikhidugu dogopwak o. Ap enendawi napwak yiluk iniris heda makbaluk danggwis, mbusi abinak werek menda yiritwis, laut helep enggen mudu segedok ako ");
INSERT INTO nbq_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Ata, it akwa Ala wene wokbaluk, musek lendagwi menda en enayum dibaluk yikhedelagwi hak, yi sek ndi sek ogarup ako andi, ndatak dibaluk ogagu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","It akwa ako andi, enane dek dugwit, ap enavema seve yiluk wene mamulhidugu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("T12_12","084_2_12","1TI","2","12","14","At Hawa endak wakhegetek o. Ap Adam endak wakhagagi. Eke, sile ako en ap Adam ambokan enggetek. Ata, hwa Hawa ambokan inggigirikmu, hwa ako en weyak ogagagi. Andi atma, anen “Akwa andi, enane dek dugwit, Ala wene des erogo hunggu dogopwak. Ap mamulirugwi, eke, it akwa en ap enavema bisiluk, Yi ogaru, ndi ogaru, yugurugwi, ogagu dogop andi dek,” yiluk, yagaliga. ");
INSERT INTO nbq_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Hwa ako andi weyak ogagagi ovara, it akwa ako enendawi werek dugwit, Yesus avyarat umbutwi, avakwa enendawi hunik okbugwis, eke, weyak ogagetek Ala ake denek dugwit, ogaguselok andi, it eneyagi endak inipu-sinigik, Ala en enagap wendarinipu dogosogon. ");
INSERT INTO nbq_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","“Ap ambi en, an Ala aburi enaruwam dogosogon o, ombasiga halok, yavup ogarup embetas andi, iya aro,” yiluk, avakwa en yagalagwi menda ako andi, avyarat yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Ap ambi Ala aburi enaruwam dogop mendok okbaup ombasagwi halok andi, avakwa enane at ovaga belagudek halok, ogwa ambiat wogo halok, endawi suam watya halok, endawi werek halok, endawi luvuk erek halok, enaganiya isagya halok, avakwa sek mamulirigya halok, ");
INSERT INTO nbq_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","amburup nenek oginivisiga menda agaum erogo naligadek halok, aninis mbikit agya dek, endawi yanggalek halok, yo yawi war-wat iridek halok, yoparip endawi hogoup ombasigadek halok, ap anderogo menda andi, Ala aburi enaruwam dogopwak yiluk mendok okbisaup sek aro. ");
INSERT INTO nbq_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Ap ambi Ala aburi enaruwam dogop andi, at aburi des erogo unde waginipu, mamulirigya, aburi en at ane hunggwis, ogagya halok adigat mendok okbaup. ");
INSERT INTO nbq_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Ap ambi en at aburi des erogo unde waginivup inggut halok, Ala aburi andi, nggarogonggan holinipu dogosogon embetep? ");
INSERT INTO nbq_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Ap ao swi at Yesus vaga vanggabaluk avyarat embetas halok mendok okbaup dek. Sile endawi siyabatigya lagagimu, anggin ovaga okbagagi ako hak, ap andi, anderogo endawi siyabetaliga vaga anggin ovaga okbagya hao en, mendok okbaup dek. ");
INSERT INTO nbq_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","At mendok okbaup ako, it ap avyarat ombasagwi dek menda en at ogasiga vaga avok mbanggu dugwit, “Ap andi, andogon sek aro,” yagalagwi halok adigat mendok okbaup. Ata, at weyak ogarimi vaga, it ap avyarat ombasagwi dek menda en at ogasiga vaga avok mbanggu dugwit, “Ap andi, andogon weyak,” yugu-sigik mendok okbaup halok, bagas heda bagoma adonggop nggeto yagaliga hak, sile en ap andi, anderogo endawi nomalisogon. ");
INSERT INTO nbq_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Eke, it ap yonggaragak ako, anderogo it enovavut sek halok, enane mberen dek ambiat adigat yagalagwi halok, anggur amburup nenek oginivisiga menda enagaum erogo nelagwidek halok, yoparip hogop ombakluk avakwa we-wes oginavisagudek halok, ");
INSERT INTO nbq_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","eke, Ala en ninim dambubininagiluk at abut Yesus lakba wagagi wene mbauk hwilago welagagi ovara yogak sigam agagi ako, vagago dugwit, enomaluk horogo baluk enendawi seyalek vaga ogagu-selok, ap andi menda mendok okbisaup sek aro. ");
INSERT INTO nbq_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","It ap yonggaragak dogop andi, endak enavut mbabaluk, enane enovaga biselagudek halok, mendok okbisaup sek. ");
INSERT INTO nbq_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","It enogwai andi anderogo enovavut sek dugwit, wene enabis atok vaga wolok nelagwidek halok, enendawi werek halok, eke, it yagalagwi ndatak ininggis anye vaga ogagu-selok, akwa anderogo menda iniselok, it enaguni ap yonggaragak mendok okbisaup sek aro. ");
INSERT INTO nbq_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","It ap yonggaragak andi, enogwa ambiat wogo halok, eke, inaburi inim, it inim agarwik menda inim, unde waginipu iniselok adigat mendok okbisaup sek aro. ");
INSERT INTO nbq_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","It ap yonggaragak ogarit lendagwi menda ako it eneyave hwalogo ogaguselok, ininis werek dogosogom o. Eke, it eneyave hwalogo ogaguselok, nit nenendawi Keretus Yesus ovaga vanggabaluk avyarat ombasagwi wene ako, it enalon embetetek dugwit, yugeregek nagu dogosogom aro. ");
INSERT INTO nbq_vpl VALUES ("T13_14","084_3_14","1TI","3","14","15","An vage hadema warup ombasiga ovara, an ambi yidup iri hao en, Ala aburi dugwit, nggarogo ogarit lagu dogop helup arinyok yiluk, nape wenggelek dugwit, dirup yi mbalhisiga. Nit Ala aburi ako Ala mondok iluk itok menda angge aro. Eke, o valek ako owak sek ngguvulik vaga ndun yagaliga dek itok-itok agarik hak, avyarat wene Yesus avok ako nit Ala aburi vaga sigam erogo itok-itok agarik. ");
INSERT INTO nbq_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Ala wene wokbaluk nenendawi eve vaga ogarit lagu dogop wene mbauk hwilago dombok welagagi ako mondok iya aro. Andi, “At ap at ari wagya lagagimu, Yi Ala abut, ombarupwak yiluk, Averiniki en sigam okbagagi. Sigam okbagya lagagimu, it malaikat en At eyave inil hugwi, At awene it weram Yakuri dek menda werekma yugeregek lagwi, It ap yi awi ndi awi Yesus Ala abut avyarat ai, umbutwi, ogagu lagagwama, O segedokma abinak adigat agarikmu wolok inggigi o,” yiluk, yagalagwi menda ako mondok avyarat higyo. ");
INSERT INTO nbq_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","At Averiniki en sigam erogo iri dugwit, “O hivis arup hudi vaga ap en avakwa enambukmu dagaguluk, madis en huluk wene yugirigya hegek mamulirugu-sigik, it nin en wene ako dibaluk, musek lagu dugwit, Yesus avyarat umbutugwa ako mondok hekbasogom o,” yiluk, yagaliga. ");
INSERT INTO nbq_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","It ap wene andi menda yagan nagwis ako andi, enagavoval sek ova heda enane huluk molalogo yagalagwi. Nenagavelo yaga mbalekma omap agarikmu edup helagwi dek andi hak, it ap andi, enendawima anderogo at, yi sek, yi weyak, enendawi dibelagwi dek. ");
INSERT INTO nbq_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","It ap huluk wene yagalagwi menda ako en, “Ap murik adigat dogop,” yiluk, yugurugwi, eke, yi menda ndi menda nelagwi menda “Naup moga,” yiluk, mamulurugwi, ogasagwi. Naup moga yagalagwi andi, nit ap avyarat wene Yesus avok nenelup akluk avyarat ombasagwi menda ako en, “Ugun naup sek yiluk Ala en bagagima, Wa, yiluk, menak-menak naup sek,” umbutu-ninigik, it ako moga yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Yi menda ndi menda Ala en wakhagagi ako andi, sek adigat bagagima, nit nenendawi en, “Wa,” yugugu dugwit, welagwi halok andi, moga dek. ");
INSERT INTO nbq_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Ala wene inim, samban ogasagwi inim, andi vaga sek asigama, yi menda ndi menda ugun naup sek aro. ");
INSERT INTO nbq_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","An wene yukhisiga yi, howa-hasin Ala aburi mamulirigya heyalok, hat Keretus Yesus ayeloman mondok segedok menda dogogun. Eke, Yesus avyarat ombasagwi wene inim, wene Ala aburi nggarogo ogarit lagu dogop modo wene mamulik musek landiga inim, wogogo hendawi wenggelit landiga vaga, hendawi mondok wadokdek hoda at dogogun. ");
INSERT INTO nbq_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","It akwa enanggok enarivit mbilinisagwi hak, yi wene ndi wene mondok eve sek menda dek hegek enam warogo yagalagwi andi menda ako, wabuk. Ala wene wogogin ako, hendawi eve vaga ogarit lagya dogonyok yiluk, hunik-hunik mamulhidigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","An wakhegek ambi yukhisogon. Avakwa nin andi eneyave anye aruguluk wal okhelagwi, eke, it nin andi Ala wene wokbaluk, enendawi eve vaga ndatak ogarit lagu dogoguluk, wal okhelagwi. Neneyave anye aruguluk wal okhelagwi andi sek ovara, un horok at okninivisiga. Eke, Ala wene ndatak ogaruguluk wal okhelagwi andi Ala en o yogak inim, o hivis inim, mondok ombok erogo sek okninivisiga ninilupma, ogasagwi. ");
INSERT INTO nbq_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Anderogoma, wene wakhegek nit Ala wene ndatak ogaruguluk wal okhelagwi andi, avyarat wene atma, waup sek aro. ");
INSERT INTO nbq_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","At Ala mondok iluk itok agarik ako, yi avakwa ndi avakwa ovok erogo enagap wendarup yiluk ombasiga ovara, nit nenendawi Yesus ovaga vanggabaluk avyarat ombasagwi andi nenagap wendarisiga. Andi vaga nenendawi vonggabaluk wenggelek agurik atma, dilwatu dugwit, hunik-hunik adigat ogarit landagwi. ");
INSERT INTO nbq_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","An wene yukhisiga yi ako yugirigya, mamulirigya, ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Hat heyave ao sawe atma yiluk, avakwa en sovalogo bagaup andi moga. Yagaliga inim, ogasiga menda inim, avakwa hendawi hunik oginivisiga inim, Yesus Keretus avyarat ombasiga inim, weyak ogagya heyao en hil sovalek landiga ako inim, ogasiga andi vaga it ap avyarat ombasagwi menda hat il wakhegek dugwit, ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","An ao wagetek neyagek, mbuku Ala wene ombok vaga dombanggya, avakwa mbilinirigya, enaruk watya, wene mamulirigya, ogagya dugwit, des erogo ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Endak, it Ala aburi enasini ako en hunggul sovabagagu-sigik, Averiniki en yukhugu hegek, “Hat hivis Ala eyavup ambi anderogo ogagya dogop,” yiluk, Averiniki anye wokhogogi ako, moma erogo hekbaup andi moga. ");
INSERT INTO nbq_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Hendawi hoda agya avakwa ovok erogo yedok heyapwak yiluk, wene yukhigis andi vaga avyarat vanggabaluk, ogarit lagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Handogon hovavut ogasiga menda inim, wene mamuleraliga menda inim, dibagya dogwen. Wene yi, mondok vipak erogo vagogo dogwen. Vipak erogo vagogo heyalok, it avakwa hat hane hulisagwi ako enagap wendatya, eke, harogo hagap wendakhidigya, ogagu dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","It ap enanggok iniselok, hane anye vaga mbererabuk. “Yi nasini ndatak atma,” yiluk, enendawi aik wakbugu dogwen. It ap sawe andi, hat haswei ndatak, ");
INSERT INTO nbq_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","it akwa enanggok andi, hat hisai ndatak, eke, akwa sawe andi, hat harupwi ndatak, it vaga hendawima weyak mondok embetetek dugwit, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","It akwa sogwa eneyagi-enwai enarum des erogo agarwikbuk halok, dibugu dogwen. ");
INSERT INTO nbq_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Akwa sogwa eneyagi-enwai werek iniselok verak, it ako en Ala wene ndatak ogarupwak yiluk, inisai-enambeyagi it enendak yonggarinipu dogopwak. It inisai-enambeyagi en eneyagi-enwai endarinipu lagagwa ako onggo yogak it anderogo yonggarinipu dogopwak. Anderogo ogaguselok, Ala endawi sek ombasiga. ");
INSERT INTO nbq_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Hwa ambi sogwa ovara, eyagi en yonggat hegetek halok, “Ala en yonggatnita dogopwak,” yiluk, Ala ovaga vanggabaluk endawi wenggelek dugwit, hup dingga Ala adema hunik adigat nggino yugugu, samban ogagya, ogasiga menda halok, hwa andi, eyave sogwa aro. ");
INSERT INTO nbq_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","It akwa sogwa ininggis-vaga yavup ogagetek dugwit, amburup werek adigat nela ombarit nagu iselok andi, iniluk agarwik ovara, Ala wene enendawima dek halok, nggorak ndatak at agarwik. ");
INSERT INTO nbq_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Akwa sogwa anderogo ogaguselok, avakwa enane enovaga bisaguven, wene yi, enaruk watya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Ap ambi, ata hwa ambi, at owa-aot unde waginivisigadek andi, weyak ovara, at abut-ogwa, isa-asin, agun-eyak dombok unde waginivisigadek halok andi, weyak mondok ombok ogasiga. It avakwa Yesus Keretus avyarat embetetek menda andi, un weyak horok at ovara, at verak, weyak mondok ombok ogasiga. At Yesus Keretus avyarat imbitigi ako andi, hekbogogi agarik. ");
INSERT INTO nbq_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","It akwa sogwa Ala aburi en yonggarisaguluk ininis dirup wasagwi andi, hwa ambi endaklagagi hegek 60 tahun agetek halok, inis dirup warup dek. Ata, hwa sogwa ambi, agun ambi nggelabigitek sogwa bago halok, ");
INSERT INTO nbq_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","“Hwa andi sek ogasiga menda,” yuguselok, eyagi des erogo sawe oginipu halok, ap huru enaganiya isagya halok, it Ala ake denek menda enayeloman ndatak oginipu halok, it avakwa anggin enovaga agya yonggarinipu halok, eke, yi yavup ndi yavup sek okbisaup ovok erogo “An neyavup at,” yiluk, ogasiga halok, inis dirup warup sek ovara, ");
INSERT INTO nbq_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","it akwa sogwa ao ndugum iniselok andi, ininis dirup warup dek. It akwa andi, enendawi ninggya halok, Keretus wene wogogwa ako hekbaluk, ap adik hedaup ombarusogoma, ininis dirup warubuk. ");
INSERT INTO nbq_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","It endak “An Ala eyavup adigat ogagya dugwit an hwa sogwa mondok dogosogon,” yagagwa ako Yesus adigat musek laup umbutugwa ako hekbagwi vaga weyak okhedugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","O ya nogo yigik nagu dugwit, yavup ogarup enanggon okhedelagwi. Andi adigat ogarit nagwis andi dek. Ata, wene enabis atok vaga wolok nagwis, o ambima ya nggao yagan nagu dugwit, it nin enawene ako it ilimik-ilimik yugwi, ogarit nagu dugwit, wene yup dek ako menda hegek ugun yagan nelagwi. ");
INSERT INTO nbq_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Anderogoma, it akwa andi en ambi ogarusogom vaga it ninim ogorek ako en nenanggadi wakbinanuguven, it akwa ndugum sogwa bisamwi ako, enaguni hidugwi, eneyagi endak inipwis, enaguni eneyagi unde waginipwis, ogagu dogop sek ombasiga. ");
INSERT INTO nbq_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Akwa sogwa nin andi, madis sile musek nagu dogoguluk, vage inisok vaga yungguliluk wendagwi. ");
INSERT INTO nbq_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Hwa endawi avyarat ombasiga ambi en isa sogwa werek halok, it Ala aburi evenuk anggin enovaga bisaguven yiluk, at eyak ako en yonggatigya dogopwak. Eke, it akwa sogwa ovara, eneyagi dek iniselok verak, it Ala aburi en yonggarinipu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Ala aburi enasini enavok ambi yisogon. It ap Ala aburi enasini enagayuk werek ovara, sek erogo enaruwam iniselok, ambi inim onggo enagayuk wurup andi sek aro. It Ala wene ombok vaga yugurugwi, wene mamulirugwi, mondok hunik adigat ogaguselok andi, evenuk ambi inim onggo enagayuk wutu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Andi, Ala wene andi, “Sapi en inisok gandum enggen enggenit lagya hegek nin naguven yiluk, enelagap heda marogo bisaup moga,” eke, ambi, “It ap yavup ogasagwi menda yavup onggo hedaup sek aro,” yiluk, yagagwa dirup mbalek agarik. ");
INSERT INTO nbq_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Ap mberen a, henggam a, “Anderogo ogaga o,” yiluk, yegetekma, at ambi en adigat ap Ala aburi enasin ambi ane ovaga bagya halok, at ane hulup andi, dek. ");
INSERT INTO nbq_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Ala Aburi enasin ambi en weyak ogagya dogosogon halok, it avakwa ovok erogo enalon ombarupwak yiluk, avakwa ombokma anggadi watya dogop. ");
INSERT INTO nbq_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Avakwa yerogo ogarup, nderogo ogarup, wene yukhisiga yi, ovok ogagya dugwit, hat hinim hunik halok ogagu dogop yugeregetek hekbigya, eke, avakwa ugun halok ogagu dogop yugirigya, ogagya dogobuk. Ata, avakwa ovok erogo enelup akluk, ogagu dogopwak yiluk, yugirigya dogwen. An ako, Ala inim, Keretus Yesus inim, it Ala ake denek malaikat ako inim, ovok inivaga an wene yi, yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Avakwa hinggis vakbugu, ininggul sovabugu, mbikit ogarubuk. Avakwa weyak ogaguselok, hat hinim avuk arup andi moga. Hat hendawi mondok sek adik denek dogwen. ");
INSERT INTO nbq_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Hagaum edup okhita, heyave anyedek okhita, ogasigama, hat is adigat ninggya dogobuk. Ata, anggur amburup ambukumat inim ninggya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","It ap mendok okbisaup yiluk, enavut mbanggya dugwit, ap nin weyak ogagao sigam agya halok, hekbiselagwi ovara, it ap nin andi, enomaluk hwilago hegek, mekbigarikmu, hivis enomaluk sigam asiga. ");
INSERT INTO nbq_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Anderogo hak, it sek ogasagwi andi, yedok iniselagwi. Eke, it nin sek ogasagwi hwilago agarik andi, vivis hwilago anderogo dogosogon buk. Sigam arisogon o. ");
INSERT INTO nbq_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","It avakwa enayeloman andi, it nin en Ala inis inim, nit wene mamuleralagwi ako inim, miyuk-meyan erogo bagusao en, iren “Nenasini aro,” yiluk, enane hunggu dugwit, enagayuk wutu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","It avakwa enayeloman andi, it nin enasini avyarat ombasagwi menda, it nin enasini avyarat ombasagwidek menda. Eke, it enayeloman ako en enasini avyarat ombasagwi menda halok, “Nit ogo avyarat ombasagwima, Ala aburi ninim ndatak aro,” yiluk, enane sovabisaup moga. Ata, it ako en, “Nenasini yavup okbiselagwi andi, avakwa it nin andi dek. Nit ninim ndatak avyarat ombasagwi atma nenendawi hunik aro,” yiluk, ambi inim enake ombok erogo ogarit nagu dogopwak. Wene yukhisiga yi ako ovok erogo mamulirigya, enaruk watya, ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Ap ambi modo wene Nenasin Yesus Keretus wene ako inim, eke, nit Ala wene wokbaluk, ogarit lagu dogop mamuleralagwi wene ako inim, anggon imbita dugwit, wene adik huluk menda mamulirigya halok, ");
INSERT INTO nbq_vpl VALUES ("T16_4","084_6_4","1TI","6","4","5","aren, “An nelup o,” yiluk, siyabategek landiga ovara, inggut hegek ugun yagan landiga. At ap andi en wene, “Yi yerogoma ndi anderogoma,” iri dugwit, wene watya, eke wene maduk yup hegek wenemuk iris, ogarit lagya dogop andi mondok endawi hunik dombok ombasiga. At anderogo ogarit lagya halok, it ap nin en avyarat wene Yesus avok ako mondok enunggut dugwit, weyak adigat ombasagwi ako en “An iya, hat iya,” yugu dugwit, ogotlagwi, meyan umbutu dugwit avok mbalit lagwi, eke, huluk enova-enova bagwi, inim mondok war-wat yugwi, ogasagwi. It ap wene adik huluk yagalagwi menda ako, “Nit Ala wene ogarit lagu dugwit, nininggis mondok werek okhedasogon,” ombasagwi ovara, ");
INSERT INTO nbq_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","nit andi, yoparip werek hegek, dek hegek, Ala wene wokbaluk, nenendawi eve vaga ogarit lagu dugwit, nenendawi ugun adenggen agurik halok andi, Ala en mondok iya erogo okbininaliga o. ");
INSERT INTO nbq_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Ninisai enendawima en endaklagu dugwit, nenangge-nenanangge ambi nininggimu wolok wulu wagetekma, lagu dugwit ogo, ambi nininggimu hedelok lasogombuk. ");
INSERT INTO nbq_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Nenagarom-nenayum ambi werek halok andi, “Yi ovok aro,” yiluk, nenendawi ugun adenggen dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","It ap, “Nininggis werek okhedaup,” umbutu-selok, Sile en, “Nanonggal aga o,” yiluk, enendawi nggaganggu hegek, bagas heda bagoma adonggop nggeto erogo waklandiga hak, it ap andi anderogo at verak erogo weyak ogagwi, eke, “Yi an neyave weyak okhedaliga,” embetetek enendawi ugun nenggek lagwi, ogarit lagwi vaga nggedek wambugu dugwit, eneyave mondok wakhedasogom aro. ");
INSERT INTO nbq_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Yi weyak-ndi weyak adem andi, yoparip adigat hogoup ombarit lendagwi andi aro. It avakwa nin en hogoup yiluk, belalit lagu dugwit, Yesus ovaga vanggabaluk avyarat umbutugwa ako hekbaluk, sup adik vaga nomaliluk lagusim, ap segowa vaga nagalhidugu lagarwik, edup helagwi andi hak, it ap andi, anderogo enendawi wakhedelagwi. ");
INSERT INTO nbq_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Hat verak, Ala angge atma, ogasagwi andi menda wagun en yiluk, agoda wunggu dogwen. Sek halok adigat ogagwi, Ala wene wokbaluk ogarit lagwi, enendawi avyarat umbutwi, avakwa enendawi hunik okbugwis, anggin enovaga agya hegek, enendawi mbuk dugwit wugwi, enendawi yanggalek vaga yugurugwi, ogasagwi andi menda musek lagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Nit Yesus avyarat ombakluk musek lendagwi ako, harogo nin ogorek inigik, mondok hanye erogo musek adigat lagya dogwen. Eke, hiluk mondok dogonyok yiluk, heyanggup iri lagagimu, hat Keretus avyarat imbitigin avakwa wisane inivaga hane vaganggigin ako, nggirik-nggerok erogo vagogo dogwen. ");
INSERT INTO nbq_vpl VALUES ("T16_13","084_6_13","1TI","6","13","14","Wene endak hat ogarit lagya dogop yukhugu lagagis ako inim, yogak yukhisiga yi inim, ambi wombabagetek ovok erogo enewogogo vagogo dugwit, Nenasin Yesus Keretus sigam ari warugwi hudi des erogo ogarit lagya dogwen. Ala yi menda ndi menda iniluk oginivisiga menda adem ako inim, eke, at avyarat wene Pondiyus Pilatus adema vaganggigi Keretus Yesus ako inim, iperen inivaga nane anye erogo yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Ala en Nenasin Yesus Keretus, “O andi hudi vaga sigam okba warup,” hologo bagagi ako ndatak sigam okba warisogon. Nit siyabelagwi At adigat mondok anye werek menda andi, Ala aro. Avakwa enasini ap ombok-ombok enasin Araro. Yi ap ndi ap ininis werek enasin inis ombok andi, At adigat o. ");
INSERT INTO nbq_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","At hambisigadek mondok iluk itok agarik Araro. At werekma andoma awia wisane atma, avakwa At adema ari laup meyan o. Avakwa en endak At eyave inil hegetekma, yogak ogo inil hegetek adigat agarwik o. At inis mondok siyalek yi avakwa ndi avakwa ovok erogo avema seve yiluk, At ane adigat hunggu dogopwak o, yiluk, amin. ");
INSERT INTO nbq_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","It avakwa o yogak ininggis werek agarwik ako, andi vaga enendawi wogobatugu dugwit, yi menda ndi menda dek arup hegek, enendawi andi vaga vanggabaluk wenggelek dogoguven, yugirigya dogwen. Nit adenggen ombaruguluk, At yi menda ndi menda nggilup-nggilup erogo wokneraliga Ala vaga vanggabaluk wenggelek dogopwak yiluk, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","It avakwa ininggis werek agarwik ako yi sek ndi sek ogagu dugwit, avakwa sek okbigik nagwis, enendawi dek avunya weyak avakwa wogeraup adigat enendawi hunik okbugwis, ogagu dogopwak yiluk, mamulirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Andi ogaguselok, heveret o eyave valuguluk, yogak o owak wadok dek wombalisagwi ako andi ndatak, it hivis iniluk mondok segedok menda hidugu dogop enendawi anggin dek, “Okbininayogon,” ombakluk, enangge eyave hunhedaguluk, enayoparip wonggal hedelagwi hak, yogak sek adigat ogarit lagu dogopwak yiluk, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timotius wai. Wene des erogo yegetek enane agil amok amburup werek vaga yagan nagwis, huluk wene arovara, “Wene swi menda yi aro,” yiluk yagan wagwi vaga winimuk yugwi, yagalagwi ako menda wabuk. Ata, hat vagogo dogonyok yiluk, Ala en mikbagagagi ako des erogo ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Wene andi menda yagan nagwis vaga avakwa nin wugu lagagwarik, Yesus Keretus ovaga vanggabaluk avyarat umbutugwa ako hekbaluk, sup adik vaga nomaliluk lendagwi. Nenasin habwa en okbagagya dogopwak o. ");
INSERT INTO nbq_vpl VALUES ("T21_1","085_1_1","2TI","1","1","2","Nabut Timotius nendawi hunik wai. An Paulus Ala endawi imbitigi vaga Keretus Yesus en yonggo lakbigik menda baninggigi ako wene ambi yukhisogon o. An ako, Ala en Keretus Yesus ninim hunik dugwit niniluk mondok-mondok dogop yagagi ako yugirigya dogogiluk an lakbigik menda banininggigi yi ako en yukhisiga. At Nenasin Ala, Nenowa Keretus Yesus iperen habwa en okbagagwi, enaigwak abet en okhitwis, eke, hendawi ugun adenggen wadok dek dogonyok yiluk, okbagagwi, ogagu dogopwak o. ");
INSERT INTO nbq_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","An hup-dingga samban ogagyama, hat vaga nape wenggelek dugwit, “Nenasin Ala wa,” yiluk, yugisiga. An nombawi weyak embetetek enendawi eve vaga Ala ake ogagu lagagwa ako hak, an ndatak at ogasiga o. ");
INSERT INTO nbq_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Hat yup de yagagin ako nendawi wenggel lagya halok, an nendawi adenggen iya erogo hagiluk, “Bikeya warik dek ai,” ombasiga. ");
INSERT INTO nbq_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Hat hendawi eyave vaga Yesus ovaga vanggabaluk avyarat imbitigin ako, nendawi wenggelek agirik o. Hambeyak Lois inim, hisa Eunike inim, iperen endak avyarat umbutugwa ndatak, harogo avyarat ombasiga andi, an nilup aro. ");
INSERT INTO nbq_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Anderogoma, an ninggis hunggul vakbagagya neyagek, Ala eyavup ambi ogarinok yiluk, Averiniki anye wokhogogi ako, hali nagaup iri halok monggalisagwi ako hak, Averiniki anye hendawima andi ombok erogo okhedanok yiluk, yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Andi, At Ala en nenendawi nenalon werek menda wokneregetek. Ata, Averiniki anye okbininggu hegek nenalon dek dugwit ogagu dogop inim, avakwa enendawi hunik oginivup inim, nenendawi werek inim, wokneragagi. ");
INSERT INTO nbq_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Anderogoma, Nenasin Inis Ombok ninim hunik dugwit, niniluk mondok dogop wene yugirigya dogop ako hanggadi habuk. Eke, an wene andi yugirigya lagagis vaga heda maknitugwa ako ogo, hanggadi habuk. Ata sek wene ako yugurugwi vaga anggin-mbanggin nenovaga bininalagwi ako, an nadik dek. Ala anye woknirigya hegek, niperen ndatak anggin hugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","At Ala en nenagap wendatya lagagirik, nit At aburi ake denek dogoguluk, neneyanggup yukneragagi. Nit ambi ogagagup vaga andi dek. Ata, At okbininaup imbitigi ako ndatak, nenabwa en okbininggu dugwit, nenagap wendatigi. At aigwak abet en okbininaliga menda ako andi, o yi ao wakegetek hegek, “Keretus Yesus vaga okbisayogon o,” yiluk, hologo bininggigi ako, ");
INSERT INTO nbq_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","yogak yi nenagap wendarisiga menda Keretus Yesus wagagi ako vaga sigam agagi. At hambugwi adem nenovaga denggelek welagagup ako, dek erogo baluk, sek wene vaga niniluk mondok-mondok dogop wene ako ombok vaga sigam agagi. ");
INSERT INTO nbq_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Sek wene Yesus ninim hunik dugwit, niniluk mondok dogop wene andi, yi awi ndi awi yugeregek lagya, mamuleregek lagya, ogagya dogogiluk, lakbigik menda denogo baninggigi. ");
INSERT INTO nbq_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Denogo baninggigirikmu, ogarit lagya neyagek, avakwa en anggin okbanilagwi ovara, nanggadi embetetek agirik. An nendawi at ovaga vanggabaluk avyarat imbitigis Yesus ako andi, an ovok nelup aro. Eke, an ogagya dogogiluk, yavup ninggimu okbaninggigi ako Nenasin warup ako wagetek hegek, dek arisogon andi dek. “Yugurugu dogosogon aro,” yiluk, avyarat ombasiga. ");
INSERT INTO nbq_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Wene Ala wene modo menda yukhugu lagagis ako wane-wane haren des erogo vagago dugwit, yugirigya dogwen. Yugirigya dugwit, Keretus Yesus avyarat imbita, eke, avakwa hinim hendawi hunik okbugu, ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Eve menda Ala en hinggimu bagagagi ako, Averiniki nenendawima agarik ako en anye okbagagya hegek, des erogo vagogo dogwen. ");
INSERT INTO nbq_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","It o Asia agarwikmu ovok erogo ap Vigelus ogo, ap Heromogenes ogo, an hekbaniluk wunggugwa ako andi, hat helup aro. ");
INSERT INTO nbq_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Arap Onesivorus andi, an mbusi heda mago neyagek, anggadi en hekbanenggetek hunik adigat nendawi aik wakbani wagek ogagagirikmu, at amwa agarwik ovok erogo Nenasin aigwak abet en okbugu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","At o Oroma nunggwigya lagagirik mondok belalnetek adigat lagya dugwit, avuk agagup. ");
INSERT INTO nbq_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","At o Epesus dugwit iya erogo yonggatnita lagagi ako hat mondok helup aro. O hivis arup hudi vaga Nenasin en ap andi, aigwak abet en okbapwak ai. ");
INSERT INTO nbq_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Nabut hat verak, Keretus Yesus ninim hunik dugwit, habwa en anye okbagagya hegek, hendawi wadok dek dugwit ogarit lagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Avakwa wisane inivaga yi wene ndi wene yukhugu neyagek hunggigin ako, it ap enandogon sek, avakwa des erogo mamuleraup sek inigin halok, it ogo vagago dugwit avakwa yugurugu dogopwak yiluk, mamulirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Yegen werek menda anggin-mbanggin hegek enendawi mbuk dugwit welagwi hak, hat Keretus Yesus aot yegen werek menda eyave hak dugwit, ninim ndatak wugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Ap yegen werek menda en, ndup ogagu dugwit, nowa ndup mamunogogi ako endawi sek nombarupwak yiluk, at adik eyavup inim, angge-angge inim, hekbaluk, ndup ogarup adigat endawi wenggelek dugwit ogarit landiga aro. ");
INSERT INTO nbq_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Eke, olah raga ogagu dugwit, ap ambi, “Sa endak onggo hedami?” yiluk, wakhugu dugwit, “Anderogo ogaru o,” yiluk, wene yugup ako ndatak ogasigadek halok, onggo hedaligadek. ");
INSERT INTO nbq_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Ap ambi inggis anye vaga yavup ogagya halok, enggen yugup ako at endak hedaup sek. ");
INSERT INTO nbq_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","An yukhisiga yi ako vaga hendawi wenggelit lagya dogwen. Hat ovok erogo yedok hanok yiluk, Nenasin en helup okbagasogon. ");
INSERT INTO nbq_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","An sek wene yugeraliga ako andi, yi: Ala en Daut ombao vivis inis ombok dogosogon yagagi ako, Yesus aro. Eke, At Yesus ako Ala en hambuluk lendagwima en iluk erogo mendok okbagagi. At Yesus ako vaga hendawi wenggelek dogwen. ");
INSERT INTO nbq_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","An wene andi yugirigya neyalok, anggin-mbanggin okbanenggek adigat ogarit wagagwa, wagagwa, atok vaga, “Ap mondok weyak ogasiga o,” yiluk, heda marogo mabanunggugwa yoma agirik ovara, Ala wene verak, heda marup meyan. ");
INSERT INTO nbq_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Anderogoma, it avakwa Ala miginipigi enendawi Keretus Yesus ovaga vanggabaluk, avyarat umbutu-selok, enagap wendakbaluk abinak mondok-mondok dogopwak yiluk, anggin-mbanggin okbanunggu-sigik, ovok erogo it enake nendawi mbuk dugwit waliga. ");
INSERT INTO nbq_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Wene yi andi avyarat: “Nit At ninim hambusogon halok, At ninim niniluk dogogup o. ");
INSERT INTO nbq_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Anggin-mbanggin okbinunggu-sigik, nenendawi mbuk dugwit, welagwi halok, nit at avema siyalek dugwit, avakwa nin nenavema bisiluk, yerogo nderogo yugurugu dogogup o. Niren 'At nininggut o', yugu niniselok, At ogo 'Hit an ninggut o', yuknerayogon o. ");
INSERT INTO nbq_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Nit At yagaliga andi adik ogasagwi ovara hegek, At yagaliga andi ndatak at ogasiga o. Andi, At itok inggut akluk adik ogarup meyan o,” yiluk, yagalagwi ako andi mondok avyarat o. ");
INSERT INTO nbq_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Wene yukhisiga yi ako andi, avakwa en enendawi wenggenggu dogopwak yiluk, yugirigya dogwen. Wene maduk yup hegek wenemuk yugwi ako vaga it hulisagwi ako un enam warogo nadok-hadok okbiselagwi atma, “Anderogo ogarubuk o,” yiluk, Ala ivaga enaruk watya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Ap ambi yavup eve sek ogagya dugwit, anggadi ombasigadek ako hak, hat avyarat wene Yesus avok ako mamulirigya dugwit, hendawi en hologo adik ambi inim lobalogo yugeregetek At ane adigat des erogo yugirigya heyalok, Ala en endawi sek hombarupwak yiluk, eve sek erogo ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Wene des erogo yegetek enane agil amok amburup werek yagan nagwis vaga sek okhedaup dek weyak ogarup adigat okbininup atma, hekbaup aro. ");
INSERT INTO nbq_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","It ap enawin amu wisane hunggu lagarik, eneyave vaga ombok mbigalisiga ako hak, it ap andi, enane huluk wene ako anderogo at ombok mbigalit landiga. It huluk wene yagan nelagwi menda ako andi, it ap Himeneyus Viletus inim akluk yagan nelagwi. ");
INSERT INTO nbq_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","It ap andi, avyarat wene Yesus avok ako nomalogo hekbaluk, “Avakwa hambuluk lendagwima en vage iniluk erogo mendok okbogogi o,” yiluk, yugu dugwit, it nin Yesus Keretus avyarat umbutugwa menda ako enendawi avut dagalisagwi ovara, hegek, ");
INSERT INTO nbq_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Ala imbitigi andi, mondok avyarat atma arisogon andi, yi: “Nenasin ako At aburi halok andi, elup agarik aro.” Eke, ambi, “Yi ap ndi ap ovok erogo, 'Ala abut inis ombok denogo bagagi andi, Yesus aro,' yugu-selok, It weyak ogasagwi ako mbo baupwak,” yiluk, Ala imbitigi ako, mondok dek agatek dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Ala aburi ovok dambulik andi o ombok valek ndatak agarwik. O ombok valek ilim andi, mbusi emas vaga inim, mbusi perak vaga inim, sogolowak andi menda adigat ogovak higirik menda dek. Ata, nin yo vaga, nin wen-vaga, ogovak higirik agarik. Sogolowak eve segedok halok andi, iya menda ambi ogarup yiluk, denek agarik. Eke, nin halok andi, we ugun ogagek yup yiluk agarik. ");
INSERT INTO nbq_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Anderogo at agarik atma, ap ambi sogolowak horek mondok sek agarik ndatak, at omaluk mbo bagya halok, at asin ake yi menda ndi menda sek iya dombok ogagya dogopwak yiluk, mondok denek agarik. ");
INSERT INTO nbq_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Andi halok, ap sawe enendawi nelagwi ako ndatak, hat anderogo okbagagya hao en, hekbaluk wunggu dogwen. Eve sek halok ogasagwi inim, enendawi Yesus vaga vanggabaluk avyarat ombasagwi inim, avakwa enabwa ombasagwi inim, enendawi ambiat dambulik dogop inim, it avakwa enendawi eve vaga, “Nenasin Yesus aro,” yiluk, yagalagwi ako, hinim akluk it ogasagwi andi menda adigat musek lagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Ap enunggut dugwit avoloklok wene vaga onggo-onggo yugu dugwit war-wat yagalagwi ako hat helupma, helabugu dogwen. ");
INSERT INTO nbq_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Ap ambi Nenasin ayeloman halok, war-wat yup andi moga. Ata, yi avakwa ndi avakwa ovok erogo endawi sagain vaga oginipu, wene sek mamulirigya, weyak okbamwi ovara, onggo yugeregetek mbup iris, ogagya dogop. ");
INSERT INTO nbq_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","It hinim ogorek dugwit, wene adik yagan nagwis ako, mbo bisiluk, avyarat wene Yesus avok enelup arupwak yiluk, Ala en okbisaup hegek ogarup ai? yiluk, hane seve erogo mamulirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Ala en anderogo okbugu halok, sile ombasiga menda ogagu dogopwak yiluk, heda magogo bogogi hegek, enendawi werek akluk, heda mago ako visilogo wunggu dogosogom o. ");
INSERT INTO nbq_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Andi atma, an wene ambi helup arinyok yiluk, yukhisogon o. O hivis oklarup hudi vaga anggin mondok iya erogo nenovaga ari wasogon. ");
INSERT INTO nbq_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Andi hudi vaga ogarup ako, avakwa enendawi enanggidik agwi, yoparip adigat hogoup ombarit lagwi, “Wi!” vok yukneraupwak yiluk wogobategek lagwi, enendawi siyabategek lagwi, avakwa miyuk-meyak erogo bigik lagwi, inisa-enasin enane des erogo hunggitek nagwis, wogeraup ovara, wa yegetek lagwi, Ala wene sagalogo baik lagwi, ogagu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","Andi ogarit lagu dugwit, enowa-enaot enabwa dek umbutwi, wene adem enendawima werek halok, ap ako inim dambulup enanggon umbutwi, ogagu dogosogom o. Avakwa enavok mbalit lagwi, ogarup oginipu halok sovalogo bagetek mondok ogarit lagwi, enaninis adigat dugwit, avakwa mondok enarit lagwi, sek ogarup mondok enanggon ombarit lagwi, ");
INSERT INTO nbq_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","avakwa enaruguluk, inil yonggoninipwis, enendawi holhegetek ugun-ugun ogarit lagwi, “An nadigat iya,” yiluk, wogokbategek lagwi, Ala inim hunik dogop embetetek enendawi ninggya halok musek laup adigat umbutwi, andi menda adigat ogarit nagu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Eke, andi ogarit lagu dugwit, Ala wene wokbaluk ogarit lendagwi elesenggen ovagak okhedelagwi ovara, enendawi andi, “Ala wene andi anye dek, nenanggon o,” ombakluk, ogarit lagu dogosogom. It ap andi ogagu-selok, inim horok-horok arubuk. ");
INSERT INTO nbq_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","It ap andi en enamwa nungguguluk, enane amburup nditik yugurugu dogomundik, nunggugu-selok, it akwa weyak ogagu lagagwa vaga enomaluk wisane enovaga durik agarwik ako, enendawi ndaik enendawi ninggya halok musek lagu-sigik, it ap andi en enane seve erogo yugurugu dugwit, enendawi nomalinivisagwi. ");
INSERT INTO nbq_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","It akwa andi en enane hunik-hunik yugu dugwit, “Ala wene andi, ambi mamuneranes o,” yiluk, yagalagwi ovara, avyarat wene Yesus avok ako inilup asagwi dek. ");
INSERT INTO nbq_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","O muk erogo it ap Yanes, Yamberes iperen en Musa ako, “Nenanggon o,” yiluk, yagagwa ako hak, yogak it ap andi, avyarat wene Yesus avok ako, “Nenanggon o,” yiluk, yagalagwi. It enendawi mondok weyak adigat ombasagwi atma, it wene avyarat ombakluk ogasagwi yugwi ako enavut mbanggu-selok weyak at ogagu-sugup. ");
INSERT INTO nbq_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","It ap Yanes Yamberes iperen en ogarit lagagwa sigam agagi ako hak, it ap andi ogo, enendawi obak ugun wes dugwit, yagan nagwis ako avakwa ovok inivaga sigam agya halok, ambi inim ogagu dogosogom buk. ");
INSERT INTO nbq_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Hat verak, an wene mamulirigya, an ogarit lagya, ogarup nendawi wenggenggu, nendawi At ovaga vanggabaluk avyarat imbita, weyak okbanunggu-sigik, nendawi wadok dek agirik, avakwa nendawi hunik okbugu, anggin-mbanggin novaga agya hegek, nendawi mbuk dugwit wigya, ogarit lagya neyagya lagagin. ");
INSERT INTO nbq_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","An o Andiokiya, Ikoniyum, Lisera inim, werekma, edup-mbedup okbanunggu-sigik, wakhidigya lagagis ako ovok helup aro. Iya erogo okbanunggu-sigik, nendawi mbuk dugwit wigya neyagek ovara, Nasin en nagap wendatnitigi. ");
INSERT INTO nbq_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Yi avakwa ndi avakwa Keretus Yesus inim hunik dugwit, Ala wene wokbaluk ogarit lagu dogosogom umbutu-selok, edup-mbedup erogo bigik nagu dogosogom aro. ");
INSERT INTO nbq_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Anderogo ovara, it avakwa weyak ogasagwi menda inim, enane huluk yagalagwi menda inim, weyak ambi inim ombok ogarit nagu dugwit, ir-it enambokan dagalhidugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Eke, hat verak, yi wene ndi wene, “Yi avyarat o,” yiluk, mamulhedagagin ako, nggirik-nggerok erogo vagogo dogwen. Sani en mamulhogogwa ako helup aro. ");
INSERT INTO nbq_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Eke, hat Ala Wene Mbalek madukma en hilup agindik. Ala wene andi, Keretus Yesus vaga vanggabaluk avyarat umbutu niniselok, nenagap wendarup ako ninelup okbininaliga. ");
INSERT INTO nbq_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Ala Wene dirup mbalek ovok erogo Averiniki avakwa enendawima des iri lagagirik, yugirigya hegek, dirup mbanggugwarikmu, wene mbalek yi ako vaga en avakwa mamulirugwi, weyak ogagu-selok enaruk watya, enane adik yagan nagwis ako hol inipwis, eke, sek adigat ogagu dogop yugirigya, ogagu dogopwak yiluk, Ala Wene mbalek agarik o. ");
INSERT INTO nbq_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","At Ala en dirup mbalek wokneragagi ako andi, nit Ala aburi dugwit, yi menda ndi menda sek ogagu dogopwak yiluk, dik-duk erogo bininggigi. ");
INSERT INTO nbq_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Avakwa At avema bisaup yiluk, Nenasin Keretus Yesus sigam ari wagya lagagirik, it iniluk agarwik inim, hombagagwa inim, enowak dili warup Keretus Yesus inim, Ala inim, iperen inivaga an wene yi yukhisogon o. ");
INSERT INTO nbq_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Ala wene yugeregek lagya dogwen. O sek hegek, o weyak hegek, ugun yugirigya dogonyok yiluk, vipuk erek dogwen. “E o,” yumwak yiluk yugirigya, weyak ogagu-selok enanggadi watya, enendawi aik wakbugu, ogagya dugwit, hendawi mondok hora yiluk mamulirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Avakwa wene adem Ala aburi vagago dogop modo wene ako hulup, “Nenanggon o,” yup hudi vanggo yi wasogon. Vanggo yi wagya halok, iren, “Wene ngga yugu samwi?” yiluk, enaruk hulit nagu dugwit, wene it enendawi hogop ombasagwi adigat yuknerapwak yiluk, guru-guru homakbugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","It avakwa andi en avyarat wene Yesus avok halok, enaruk nggedal hedelok, mupilin halok adigat mbililit nagu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Anderogo ovara, hat verak, yi wene ndi wene wagya hao en, hendawi suam watya dogwen. Edup-mbedup okbagagu-sigik, hendawi mbuk dugwit wigya, ap sek wene yugeregek landagwi hak, hat ndatak yugeregek lagya, eke, hat Ala eyavup ogagya dogonyok yiluk, mendok okbagagagwa ako weralogo ogagya, ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Eke, an verak, Ala ake yiluk, narusogon andi mondok vulogo baninggigi werekma, an hambup ako vage vanggalek agarik. ");
INSERT INTO nbq_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","Ap ndup ogasagwi hak, an Ala wene sek erogo ogarigiluk, ndup ogagya lagi. Hudi atok vaga vupuk lendagwi ako hak, an vage hudi atok vaga ari wagi o. Nit Yesus avyarat ombakluk musek lendagwi ako andi, an sek erogo vagogo welagagis. ");
INSERT INTO nbq_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Eke, yogak at wene atma nggedok owak dilisiga Nenasin en it avakwa yavup sek okbagu-selok, onggo nggare-nggare mendago mahkota yikbisaliga menda, At warup hudi an ambi yikbanupwak yiluk, baninggigi agarik o. An nadik yikbanisogon dek. Ata, yi avakwa ndi avakwa en, “At sigam ari warupwak dek, ai,” yiluk, sokhelagwi ako ovok erogo yikbisayogon. ");
INSERT INTO nbq_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","It nin ovok hekbaniluk wungguguwama, hat hodo erogo nadema warigiluk ya wal nda wal ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Andi, ap Demas wen-vaga menda adigat endawi hunik agagima, hekbaniluk o Tesalonika winggigi. Eke, ap Kerekes o Nggalatiya lagya, ap Titus o Dalamatiya lagya, ogagu-sigik, ");
INSERT INTO nbq_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","ap Lukas adigat ninim agarik. Ap Markus ako yavup an yonggatnita dogop sek atma, hat wagya dugwit, wegek-wegek omano. ");
INSERT INTO nbq_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Ap Tikikus ako, o Epesus lakbagi. ");
INSERT INTO nbq_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Hat wagya dugwit halok, sogwes yum o Terowas ap Karupus umwa hegek wagagis ako inim, nambuku virik-verek ogarek ako inim, eke, mbuku ndomba agamut vaga dirup mbalek andi iyama, andi inim, ovok erogo woknombolok omano. ");
INSERT INTO nbq_vpl VALUES ("T24_14","085_4_14","2TI","4","14","15","Ap mbusi vaga yi menda ndi menda ogovak higirisiga Alekander ako en wene nit yugerelagwi ako at mondok anggon dombok imbita dugwit, weyak iya erogo okbaninggigima, harogo weyak okbagagwi en, suam watya dogwen. At okbaninggigi ako andi, Nasin en onggo ndatak wogirisogon. ");
INSERT INTO nbq_vpl VALUES ("T24_16","085_4_16","2TI","4","16","17","Endak, it Yakuri menda en enane novaga banunggugwarikmu, it Oroma menda en navok mbanggusim, naswei ambi mondok nadema wagetek ovok at hekbanunggugwa ovara, Nasin Yesus en andi, ninim welagagi. Ninim dugwit, it avakwa weram Yakuri dek menda ovok erogo hulupwak yiluk, anen sek wene ambi wombabagatek ovok saborogo yugirigya dogogiluk, nanye okbaninggigi. Anderogoma, weyak okbanup embetao ako singa elagapma en diyalisagwi hak, diyanitugwa. Eke, naswei hekbaniluk wunggugwa ako weyak enovaga bugu hao en, Ala yugisiga. ");
INSERT INTO nbq_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Yi weyak ndi weyak okbanup ombasagwi ako okbanunggu sao en, Nasin en nagap wendarisogon. Eke, At avema bisaligama mbogot vaga andoma enewogogo bani layogon o. At inis mondok-mondok siyalek at dogopwak! Amin. ");
INSERT INTO nbq_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Pirikila, Akwila iperen, eke, ap Onesivorus abur-ogwa inim, wa yugeranok yiluk yukhisiga o. ");
INSERT INTO nbq_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Ap Eratus o Korendus andoma mbup yagas. Ap Torovimus aup agagirikmu, o Miletus andoma hegek wagagis. ");
INSERT INTO nbq_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","O sogwes ogagya mbeda ao vanggo yi wagetek hegek, hat hodo erogo nadema warup hendawi wenggenggu dogwen. Ap Ebulus ogo, Pudes ogo, Linus ogo, Kolaudiya ogo, eke, nenowa-nenasin Ala aburi ogo, it ovok erogo en wa yukhigao. ");
INSERT INTO nbq_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Nenasin Yesus habwa en okbagagya dugwit, hinim at dogopwak o. Ai wa! ");
INSERT INTO nbq_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Nabut Titus wai. An Paulus Ala ayeloman Yesus Keretus en lakbigik menda baninggigi ako yukhisogon o. It avakwa Ala en miginipigi ako enendawi Yesus avyarat ombakluk des erogo wugwi, eke, avyarat wene ako wokbaluk, enendawi eve vaga ogarit lagwi, ogagu dogopwak yiluk, lakbigik menda baninggigi. ");
INSERT INTO nbq_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Avyarat wene nit nenendawi Yesus ovaga vanggabaluk, avyarat umbutu-niniselok, niniluk mondok-mondok dogosogon o, Ala en yagagi ako, okninivupwak yiluk, nenendawi vonggabaluk wenggelek agurik. Ala huluk yagaligadek avyarat adigat yagaliga ako en, “Iniluk mondok-mondok dogosogom o,” yiluk, o yi ao wakegetek hegek, hologo bagagi ako, o muk erogo hologo bagagi ovara, ");
INSERT INTO nbq_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","“O andi hudi vaga sigam asogon,” imbitigi ako nenagap wendarisiga menda Ala en, “Paulus An nawene yugirigya dogopwak o,” yiluk, yavup ninggimu baninggigi ako avakwa wisane yugirigya vaga, sigam aga o. ");
INSERT INTO nbq_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Ai nabut Titus wai. Niperen Yesus avyarat ombasagwi ako vaga hat nabut dombok agagindikmu, wene yi yukhisogon. Nenasin Ala, nenagap wendarisiga menda Yesus Keretus Ala en denogo lakba wagagi ako iperen habwa en okhitwis, hendawi ugun wadok dek adenggen dogonyok yiluk, okbagagwi, ogagu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","An ogagetek baluk wagagis ako hologo bugu, eke, o kota adik-adik Ala aburi enasini dogopwak yiluk, “Ap andi menda mondok okbisaup,” yukhogogis ako mondok okbugu, ogagya dogonyok yiluk, hat ovok o Kereta bagaluk, an wulu wagagis. ");
INSERT INTO nbq_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Ala aburi enasini dogopwak yiluk mondok okbisaup ako andi, avakwa en weyak ogagatek vaga enane enovaga biselagwidek halok, enogwa ambiat wogo halok, enaburi avyarat ombasagwi halok, avakwa en, “Ap andi aburi en ugun-ugun ogarit nagu dugwit, inisai-enasini enane hulisagwi dek ovara, enaruk wakitek ayai!” yagalagwi dek halok, adigat mondok okbisaup sek. ");
INSERT INTO nbq_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","It ap Ala aburi enarum dogop ako andi, Ala eyavup ogasagwi atma, weyak ogagu-selok avakwa enane enovaga bisaguven, sek adigat ogarit lagu dogopwak o. It ombasagwi adigat ogarup umbutwi, enaninis mbikit agwi, amburup nenek oginivisiga menda enagaum erogo nunggwi, war-wat yugwi, avakwa enayoparip hedaguluk, wewes okbugwis, ogasagwi halok, ap andi menda mondok okbisaup dek. ");
INSERT INTO nbq_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Ata, ap enaganiya isagu-selok, sek ogarup enendawi hunik umbutu-selok, enendawi werek halok, atma nggedok ogagu-selok, Ala wene wokbaluk sek adigat ogagu-selok, ogarup agya hegek ovara, enendawi yunggubaluk, mbup yugu-selok, ap andi menda mondok okbisaup sek. ");
INSERT INTO nbq_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Avyarat wene Yesus avok mamulik andi, it ndatak nggirik-nggerok vagogo iniselok mondok okbisaup sek aro. Vagago dugwit, wene adem Ala aburi vagago dogop modo wene andi vaga avakwa enendawi aik watbugu dogopwak. Eke, it nin modo wene ako waup enanggon ombasagwi halok, wapwak yiluk, ambi inim enaruk watu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Ap enane, “E o,” yiluk, hunggitek dugwit, enane amburup dititik yagan nagwis, avakwa enambutmu unggwi, ogasagwi andi, it eneyave wisane ovara, it Yakuri menda nin en huluk wene yugurugu dugwit, 'Henagap wendarupwak yiluk, henagamut mbales,' yiluk, yagalagwi menda andi, eneve iya iren ogo anderogo ogarit nelagwi. ");
INSERT INTO nbq_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","It ap andi, wene mamulup dek menda mamulirugu dugwit, ap enabut-enogwa wisane inim enendawi avut dagauk-mbagauk oginivit lendagwi. Eke, it avakwa enangge hedaguluk, enanggadi arup menda hegek, ogasagwi. Anderogo atma, it enane mondok dek erogo bugu dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Ap navi Kereta menda ambi en iri dugwit, “It ap o Kereta menda andi, mondok enane huluk yagalagwi menda aro. Yangge edup en ap ugun hivirinivisiga hak, it anderogo dugwit, enanggatek en enovadek agarwik o,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","yugeragagi ako andi, avyarat yagagi o. Anderogoma, it huluk wene musek lendagwi andi, Yesus Keretus wene avyarat umbutugwa ako mondok wadok dek vagogo dogopwak yiluk, hane anye vaga enaruk watya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","Eke, Yakuri menda enarivit mbilinisagwi wene inim, it ap avyarat wene hekbaluk, enendawi ugun wenggelogo, “Yerogo ogarup, nderogo ogarup,” yagan nelagwi wene ako inim, “Dibaup moga,” yiluk, hane anye vaga enaruk watya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","It avakwa enendawi sek adigat dugwit weyak ombasagwi dek, Averiniki enendawima yi sek, yi weyak, yugirigya hegek ogasagwi halok, yi menda ndi menda Ala en naup moga dek bagagima, it huluk wene yagalagwi menda en, “Naup moga,” yugu-sigik nunggu-selok, enendawi weyak asigadek. Sek aro. Eke, it avakwa Yesus avyarat embetetek weyak adigat ogasagwi halok andi, it ambi nano vaga enendawi sek okhedabuk. It ogarup enendawima wenggelisagwi inim, enendawi ombasagwi inim, andi weyak adigat dogosogon. ");
INSERT INTO nbq_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","It ap huluk wene 'Henagap wendarupwak yiluk, henagamut mbalup,' eke, 'Andi naup moga,' mamuleralagwi menda andi en yugu dugwit, “Ala ninelup,” yagalagwi ovara, it ogarit lendagwi vaga en, “Ala nenanggon,” umbutu dugwit, yagalagwi, yiluk, yedok iniselagwi. Ala wene hunggitek sovalogo baik lagu dugwit, sek ambi ogasagudek weyak adigat ogasagwima, alon edok werek iniselagwi. ");
INSERT INTO nbq_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Hat verak, Ala aburi Yesus ovaga vanggabaluk nggarogo ogarit lagu dogop modo wene ako ndatak mamulirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","It ap enanggok andi, enendawi suam watwis, enovavut sek agwi, enendawi werek agwi, it enendawi Yesus avyarat ombasagwi ako wadok dek agwi, anderogo dogopwak yiluk, yugirigya dogwen. Avakwa ovok erogo avyarat enendawi hunik okbugwis, eke, anggin enovaga agya halok enendawi mbuk dugwit, wugwi, ogagu dogopwak yiluk, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","It akwa enanggok andi, yi menda ndi menda ogagu dugwit, Ala agayuk wutu dogopwak yiluk, ap enanggok yugeraup yukhigis ako ndatak yugirigya dogwen. Enabis atok vaga wolok nagwis, amburup nenek oginivisiga menda enagaum erogo nunggwi, andi ogagu dogop dek. Ata, eve wene halok adigat mamulirugu dogopwak yiluk, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","5","Avakwa en Ala wene miyuk-meyan erogo bagu sao en, it akwa ndugum ako en enaguni inim, eneyagi inim, enendawi hunik agwi, enendawi werek agwi, avakwa enabwa en sek okbugwis, enawi sek erogo unde wakedugwi, akwa enendawi sek adigat dugwit, enaguni enavema seve yiluk, enane hunggwis, ogagu dogopwak yiluk, it akwa enanggok ako en akwa ndugum mamulirugu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Eke, it ap sawe andi, anderogo enendawi werek dogopwak yiluk, enaruk watya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","Avakwa hat vaga il wakhegek ogagu dogopwak yiluk, hat yi ogagek ndi ogagek ogagya dugwit, sek adigat ogarit lagya dogwen. Ogarit lagya dugwit, wene mamuleraliga ako, hat hane inim lobalogo ugun-ugun mamulirigya, hagayuk dek un enda-enda wene adigat yugirigya, ogagya dogobuk. ");
INSERT INTO nbq_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Ata, hat wene yugirigya dugwit it ap hane waup “Nenanggon,” ombasagwi ako en, 'Hat wene weyak yagas,' yiluk, nenavok yusogombuk ma, it enanggadi arupwak yiluk, hane sek adigat yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","It avakwa enayeloman ako andi, enasini en yugurugwi ako, enavema seve yiluk, enane hobaluk, wene onggo yugeregetek iniselok, enasini enendawi hunik dogopwak yiluk, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","It avakwa enayeloman ako andi, enasini enangge enonggop wugu dogop dek. It ako andi, yi ogagek ndi ogagek ogagu dugwit sek ogarit lagwi vaga avakwa nin ako en, “Nenagap wendarisiga menda Ala wene wasogom,” ombarupwak yiluk, “Henasini enangge wegetek vipak erogo dogones,” yiluk, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Andi, Ala nenabwa en okbininaliga wene ako, avakwa enagap wendarupwak yiluk, it ovok erogo enake sigam agagi. ");
INSERT INTO nbq_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Sigam agya halok, wene andi vaga Ala en, “Hit o wen-vaga yoma dugwit Ala henalon embetetek weyak ogasagwi inim, wen-vaga ogarup henendawi ninggya inim, hekbaluk, henendawi werek akluk, weyak ogagetek sek adigat dugwit, Ala wene wokbaluk ogarit lagu dogones o,” yiluk, yukneraliga. ");
INSERT INTO nbq_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","Yukneraligama, yogak ogagu dugwit, Nenasin Ala ombok nenagap wendarisiga menda Yesus Keretus, mondok abinak werek dugwit sigam ari warup ako vaga nenendawi vonggabaluk wenggelek werekma, nenadenggen vaga sokhelagwi o. ");
INSERT INTO nbq_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Nit yi weyak ndi weyak ogasagwi ako ogagu dogoguven yiluk, At Yesus ako nit avyarat ombasagwi menda nenonggo mbalogo heda visibininigiluk, At eyave wogeragagi. Eke, “An naburi nake denek dugwit, sek ogarup enendawi adenggen vaga ogarit lagu dogopwak,” ombakluk, nenomaluk horogo bininigiluk, nit nenake At eyave wogeragagi. ");
INSERT INTO nbq_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Yi wene ndi wene yukhisiga yi, yugirigya dogwen. Ala en hat yavup yi andok okbagagagima, hane anye vaga enaruk watya, enanggadi watya, ogagya dogwen. Eke, ap ambi en hat sovalogo bagaup meyan. ");
INSERT INTO nbq_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Avakwa en it o arum agarwik pemerintah inim, it ap o vagogo agarwik inim, enavema dugwit, enane hunggwis, eke, sek ogarup ambi werek agya halok, “Ogagu dogosogom o,” umbutwi, ogagu dogopwak yiluk enelup erogo yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Ap ambi miyuk-meyan erogo bagwi, war-wat yugwi, ogarubuk. Ata, enendawi yanggalek dugwit, yi ap ndi ap ovok erogo enendawi sovalek vaga woginipu dogopwak yiluk, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Nit ogo, muk anderogo ndatak, wes ovagak werekma, wene yuknirugwi ako hunggitek, sup adikmu nomo yagan lagwi, ap ambi ayeloman yugugu halok, “E o,” yiluk, ogasiga andi hak, nit nenendawi ninggya halok ogarup nenendawi hogop ombasagwi ako dombok ogagwi, ogagu lagagup. Yi menda ndi menda ogarit lagu dugwit, weyak dombok ogagwi, nanggon-hanggon yugwi, naninis-haninis yugwi, andi menda adigat ogagu lagagup ovara, ");
INSERT INTO nbq_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","nenagap wendarisiga menda Ala en yi avakwa ndi avakwa enabwa en sek okbininaup ako, sigam ari wagya lagagirik, ");
INSERT INTO nbq_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","nenagap wendakninipigi. Nit sek ogagu lagagup vaga nenagap wendakninipigibuk. Ata, At aigwak abet en nit Yesus avyarat ombasagwi ako nenendawi weyak horogo baluk, swi endarogo bininggu, Averiniki en nenendawi swi ogovak higitninipu, ogagagi andi vaga nenagap wendakninipigi. ");
INSERT INTO nbq_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","At nenagap wendarisiga menda Yesus Keretus vaga Ala en Averiniki nggilup-nggilup erogo wokneragagi. ");
INSERT INTO nbq_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","At Ala nenabwa en okbininggigi vaga, “Wene enovaga bisaup dek o,” yiluk, mondok sek okbininggu lagagirik, ap ambi asin eyase hedaliga hak, nit niniluk mondok-mondok dogop nenape wenggelek ako hedaguluk, Averiniki nggilup-nggilup erogo wokneragagi. ");
INSERT INTO nbq_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","An wene yukhisiga yi, avyarat o. It avakwa enendawi Ala ovaga vanggabaluk, avyarat ombasagwi ako enendawi dibaluk, yi yavup ndi yavup sek menda ogagu dogopwak yiluk, an yukhisiga yi, ninggi-nanggi hane anye vaga yugirigya dogwen. Avakwa ovok erogo “Wene yi, sek aro,” yiluk, welagwi vaga sek ambi okhedaup atma, yugirigya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Ap wes ovagak enunggut dugwit wene onggo-onggo yugwi inim, ap enadem mbilinggwis inim, Musa wene mbalek vaga, “Yerogo-nderogo,” yugu dugwit wunumuk yugwi inim, andi ogarit lagu dugwit, atok vaga andoma ambi okhedaup dek hegek un enam warogo yugusim, hekbaup aro. ");
INSERT INTO nbq_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","11","Ap ogotbisaliga menda ako en eve wene hekbaluk, weyak adigat ogarit lagya vaga weyak onggo ovaga horabetagas hegek, ogarit landiga helupma, elap mberen vaga aruk watbaluk, hekbaup aro. ");
INSERT INTO nbq_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","An o sogwes ogagya mbeda o Nikopolis andoma dogop imbitirikmu, an en ap Aretemas a, ap Tikikus a, ambi lakba wagya neyalok, andoma werekma, hat hodo erogo nadema warinok yiluk, ogagya dogwen. ");
INSERT INTO nbq_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Ap Apolos ako inim, wene amburup mbalisiga menda ap Senas ako inim, hodo erogo lakbisa wagya dugwit, it enangge-enangge dek halok, wogerano. ");
INSERT INTO nbq_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","It nit menda andi en, avakwa enangge dek halok, okbugu dogopwak yiluk, yavup sek erogo ogarup mamulhidugu dogopwak. Andi ogagu-selok, enggen yigitek dogosogom buk o. ");
INSERT INTO nbq_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","It ap ninim agurik ovok erogo an ninim en “Wa,” yukhisagwi o. Eke, it Yesus Keretus avyarat umbutu dugwit, enendawi hunik okbininalagwi hinim agipik andoma ovok erogo “At Paulus en 'Wa,' yukheraga o,” yiluk, yugerano. Ala henabwa en okbugugu dogopwak o. Nabut wa! ");
INSERT INTO nbq_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Hit Yakop aburi enombawi wigalek hininis unggul 12, yi awi ndi awi sak yagagup ako, an Yakobus en Nenasin Ala, Nenowa Yesus Keretus inis ombok, enayeloman dugwit, “Wa,” yukheraliga o. ");
INSERT INTO nbq_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Nowa-nasin. Anggin-mbanggin adik-adik menda henovaga agya halok, henendawi mondok adenggen umbutu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Hit avyarat umbutu hiniselok, henavut mbangguma, anggin-mbanggin henovaga agya hegek, henendawi horaik dugwit, “Nenendawi ndipuk-wadok dek oknenavupwak yiluk, ogagya higi,” yiluk, adenggen umbutu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Anggin mbanggin henovaga agya hegek, hit henendawi ndipuk-wadok dek horaik dugwit ogagu dogosogon halok, hit henendawi hoda okhinipu, eke mondok sek okhinipu, henendawi werek okhinipu, ogagya dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Ogagya dogosogon ovara, hiren ogarup ambi henunggut halok andi, Ala yugeres. Yugugu hiniselok, At Ala endawi mbuk dek sagain vaga yi ap ndi ap ovok at wogeraliga ako en ogarumwak yiluk, hinelup okhinivisogon o. ");
INSERT INTO nbq_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Hit Ala yugugu dugwit, henendawi yunggup yegetek mondok avyarat umbutu dugwit, yugugu dogwes. Ap ambi endawi yunggubaluk ogagya dugwit, Ala yugugu halok andi, o havut wagya dugwit is mogoliluk ogasiga andi wane-wane, ap ako endawi anderogo at agarik. ");
INSERT INTO nbq_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","8","Ap andi endawi mberen dugwit, yi ogarup ndi ogarup endawi wenggelit landigama, endawi seyalek dogosogonbuk. Ap andi Ala yuguguma, ‘An nendawi mberen halok, at woknirisogon dek higi,’ yiluk, imbitya dogopwak. ");
INSERT INTO nbq_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Hit nasuwi Ala aburi hininggis dekma, hininis sovalek agipik ako, hininis Ala il vaga siyalek agarik atma, henendawi sovalek dugwit, adenggen umbutu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Eke, hit nin hininggis werekma, hininis siyalek agipik ako, Ala il vaga hininis sovalek isaligama, “Yo angga hedangga dek asiga andi hak, nininis anderogo at dek arisogonma, sek aro,” yiluk, henendawi sovalek dugwit, adenggen umbutu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Andi, mo daga wagya dugwit, mo idup en yo angga-hedangga dis iri dugwit, mbuk agya lagarik mbililis erogo wambigya dugwit, elose weyak asiga hak, it ap ininggis werek okhedaguluk ogarit lagu-selok, eneyave anderogo at dek arusogon o. ");
INSERT INTO nbq_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Hit ap akwa henavut mbanggu hegek ndipuk-wadok dek agipik halok, 'An sek at agirik' umbutu dogwes. Hit ap akwa henavut mbanggu hegek, ndipuk-wadok dek agipik ako sek ogagu hiniselok, nggenak iris nggudit-nggudit mendago makota yikbiselagwi ako hak, Ala en “Hit ap akwa henendawi hunik okbanilagwi ako, An en hiniluk mondok-mondok dogop menda wokherayogon o,” yiluk, avok yagagi ako wokherayogon. ");
INSERT INTO nbq_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","At Ala en, “An weyak ambi ogarisogon,” ombasigadek, eke ap akwa weyak ogarupwak yiluk, enendawi nggagalogo bugu, okbisaligadekma, ap ambi endawi nggaganggu halok, “Yi Ala en nendawi nggagalogo baniliga,” yiluk, yup andi mondok dek o. ");
INSERT INTO nbq_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Nit nenendawi nggagalisiga andi, ap ambi weyak ogarupwak yiluk, ane agil-amok likelok landiga ako hak, nit nenendawi en at, weyak ogarup hogop, 'Ai' umbutu dugwit ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Eke, hwa ambi eyak avula akluk, endaklagya lagarik, andi en, avyak ako hambisiga hak, nit nenendawi en at, weyak ogarup hogop, 'Ai,' umbutu dugwit halok, weyak ako nenendawi ombok agya lagarik, neneyave at hambup okninivisiga. ");
INSERT INTO nbq_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Nowa-nasin, hit an nendawi hunik ako, hit henendawi nomalhedabuk. ");
INSERT INTO nbq_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Nenabwa en sek okbininiliga inim, wokneraup ombasiga ako mondok wane-wane wokneraliga inim, ovok erogo mbogot vaga en woknera wambu wandiga. Yi awi ndi awi ovok erogo awiya ogasiga adem andi, At nenasin Ala en at, woknera wambu wandiga. At ambi agek ogagya dugwit, ndugwis ambi vaga mo munggumu hak agya, ndugwis ambi vaga mo yasigama hak agya, ogasiga dek o, at mondok-mondok itok awiya adigat agarik. ");
INSERT INTO nbq_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","At Ala en yi menda ndi menda ogagagi ako sovalek hegek, nit At angge enek dogopwak yiluk mikninipu lagagirik wene avyarat yagagi vaga okbininggigi. ");
INSERT INTO nbq_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","20","Nowa-nasin, hit an nendawi hunik ako, wene yi des erogo wugu dogwes. Nit eyave mondok sek adigat ogagu dogop Ala en ninimbitigi ako andi, nenaninis vaga ogarup dek atma, hit ovok at wene yiluk-wuluk erogo henaruk hunggu dogop sek ovara, yup halok andi, dibaluk yugwi, henaninis yiluk-wuluk erogo winggitek, des erogo ogagwi, ogagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Andi halok, ogarup dek menda bo-bo ugup ovagak hegek ugun ogagwi, eke yi weyak ndi weyak ogagwi, ogasagwi ako ovok at hekbaluk, henendawi sagain vaga dugwit, nenagap wendarup wene Ala en nenendawima awi yakbininiliga wene ako, adigat des erogo wugu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Ala wene henaruk hobaluk ogagatek halok andi, hit at henambutmu dagalhedelagwi atma, henaruk adigat hunggik ogagu dogop andi moga o. Ata, henaruk hobaluk, eyave inim at ogagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Hit Ala wene dibaluk, ogagetek dugwit, un henaruk adigat hulisagwi halok andi, ap ambi wukagak vaga elose bikaliga ako hak, hit aro. ");
INSERT INTO nbq_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Elose bikhigya lagarik, lagya dugwit, “Nelose anderogo higi,” yiluk, endawi wenggenggitek vage unggut asiga ovara, ");
INSERT INTO nbq_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Ala en wene denggalogo dik-duk erogo yukneragagi ako vaga, visilogo sigam erogo bininiliga wene ako, hit sek erogo yenaga wugu dogomundik, henunggut agetek des erogo wokbaluk, ogagu dogosogon halok, At Ala en henendawi adenggen at okbigagayogon o. ");
INSERT INTO nbq_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Hit ambi en, “An Ala wene dibaluk ogasiga o,” yagalagwi ovara, henabya atok vaga ugun yagan nelagwi ako henelagap des erogo aruwam welagetek halok, hit henambutmu dagalhedugu dugwit, “An Ala wene dibaluk, ogasiga o,” yagalagwi ako andi, un enam warogo at ogagu hinigis. ");
INSERT INTO nbq_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Nenasin Ala il vaga At ane dibaluk eyave mondok sek adigat ogagu dogop andi, it avyak hwavyak wenaborangge inim, akwa sogwa inim, enendawi wakedugu-selok, enabwa en yonggarinipwis, eke it ap akwa enendawi weyak en weyak ogarupwak yiluk, henendawi nggagalhinivit wagwi inisawen, henendawi suwam wakidugwi, ogagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Nowa-nasin. Hit henendawi nenowa inis ombok Yesus Keretus mondok siyalek agarik ako vaga ovaga vanggabaluk, avyarat ombakluk, ogarit lagu dugwit, ap akwa enelose vaga dibisiluk, ambi sek okbagwi, eke ambi henanggon okbagwi, ogagu dogobuk o. ");
INSERT INTO nbq_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Ap ambi mbusi emas amumulip cincin ambelat enggen ovagak inim, yum mondok sek inim, yikbaluk, hit samban ogasagwima nunggu wagya, eke ap ambi inggis dek yum weyak yirik nunggu wagya, ogagu-selok, ");
INSERT INTO nbq_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","ap ambi yum eyave sek yirik ako agayuk wukbaluk, yugu dugwit, “Nasin o, mbanggu-vaga sekma yenam hora yima o,” yugwi, eke ap inggis dek ako agayuk wutitek dugwit, “Un andenam mendek dogomi a, nggulumu wen vaga andenam hora yimi a?” yugwi, ogagu hiniselok, ");
INSERT INTO nbq_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","hit henendawi en ap ambi weyak, ap ambi sek, umbutu dugwit, yagalagwi ako dek? Eke, enelose vaga dibisiluk, okbiselagwima, ap wene owak dilisigama ogasagwi ako hak, ogagu dugwit, weyak at hologo belagwi ako dek? ");
INSERT INTO nbq_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Nowa-nasin, hit an nendawi hunik ako, wene yi des erogo henaruk hunggu dogwes. It ap ininggis dek umbutu-sigik, Ala en miginipigi ako andi, it Yesus avyarat ombasagwi ako vaga Ala en it ininggis werek enombasiga. Eke, ap ovok erogo, “Nasin ai,” yiluk, “Enendawi hunik okbanunggu-selok, navema bisayogon,” yiluk, avok yagagi ako, Ala avema bisaligama mavorangge hak andok okbugu, ogarupwak yiluk, miginipigi. ");
INSERT INTO nbq_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Ala en it at miginipigi hegek, hiren ap ininggis dek halok, mbidarogo biselagwi. Mbidarogo bugu hinigik, wiyik-nom weyak-nom okhinipu dugwit, likenombolok wene owak dilisagwima bigi lendagwi ako andi, it ap ininggis werek en okhinivisagwi ako dek? ");
INSERT INTO nbq_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Eke, it ininggis werek menda en Yesus inis siyalek agarik wokheragagi ako, mbidarogo belagwi! ");
INSERT INTO nbq_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Ala wene warek wane-wane ogagu dugwit, “Hit heneyave henendawi hunik okhedelagwi ako hak, it hinim agipik ako anderogo at henendawi hunik oginipu dogwes o,” yiluk, nenasin inis ombok en wene denggalogo yukneragagi ako ogagu hiniselok andi, sek at ogasagwi ovara, ");
INSERT INTO nbq_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","ap akwa enelose vaga dibisiluk, okbiselagwi halok andi, weyak ogasagwi aro. Andi ogasagwi vaga wene denggalek sagalogo belagwima, Ala en, “Hit weyak ogasagwi o,” yiluk, yukherayogon o. ");
INSERT INTO nbq_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Hit Ala en wene denggalogo yukneragagi ako ovok erogo ogagu dugwit ovara, wene ambiat ogagetek hiniselok andi, wene andi ovok erogo ogagetekma, weyak at ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","At Ala en, “Hwa ap enogwa hegek ogarup moga o,” iri dugwit, “Ap warup moga o,” inim yagagirikmu, hit ambi hwa ogagatek dugwit, ap watwis hiniselok andi, Ala wene yugup sagalogo belagwima, weyak ogasagwi andi aro. ");
INSERT INTO nbq_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","It ap akwa, “Ala wene yugup visilogo bininaliga wene ako andi vaga nenowak dilisogon o,” yiluk, enendawi wenggenggu dugwit, enane yugwi, ogarit lagwi, ogasagwi ako hak, hirogo, ogagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Hit ap akwa enabwa en sek okbigitek hiniselok, Ala en at henowak dinggu dugwit, henabwa en sek okbigigayogon dek o. Eke, ap akwa enabwa en sek okbugwis hiniselok andi, henowak dilup ako, henalon dek at dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Nowa-nasin o. Hiren, “An nendawi avyarat ombasiga o,” yagalagwi ovara, eyave ogagetek hiniselok, nano ogaruguluk yagalagwi embetep? Ala wene eyave ogagetek dugwit, un avyarat ombasagwi vaga adigat Ala en henagap wendarisogon embetep? ");
INSERT INTO nbq_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Henarup ambi a, henowa ambi a, asum inim, o hutun-howam nelagwi menda inim, agarik dek halok, ");
INSERT INTO nbq_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","hit ambi en, eyave sek dogopwak yiluk, ambi wogigitek dugwit, ane adigat “Ai nowa. Hagarom iya erogo ninggya, hasum sek dombok yikhidigya, hendawi adenggen vaga elak o,” yiluk, yugugu hiniselok, andi sek embetep? Dek, un at yagalagwi o. ");
INSERT INTO nbq_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Anderogo hak, nit nenendawi avyarat ombasagwi ako wane-wane eve inim ogagetek dugwit, avyarat adigat umbutu niniselok, nit ambi okbininup dek atma, un enam warogo avyarat ombasagwi o. ");
INSERT INTO nbq_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Anderogo ovara, hit ambi en, “Hat avyarat ombasiga ovara, an andi eve inim ogasiga o,” yiluk, yugu hinigirikmu, avyak wai. Hit avyarat ombasagwi ako, eve inim ogagetek hiniselok, “Yi ap avyarat embetetek aro,” henombasagwi ovara, an andi, avyarat imbitya dugwit, eve inim at ogasigama, “Yi ap avyarat ombasiga, yi” nombasagwi, yi helagwi? ");
INSERT INTO nbq_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Hiren, “Ala andi, adigat agarik avyarat ombasagwi,” yiluk, ombasagwi andi sek at ovara, it madis inim wene andi anderogo at avyarat umbutu dugwit, enalon en enowak wuruk-wuruk yagalagwi ovara, hit andi avyarat umbutu dugwit, mbup erek adigat agipik hinigis o. ");
INSERT INTO nbq_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Nowa-nasin, hit ap wes hak yagan nelagwi. Eve ogagetek hegek, avyarat ombakluk, mbup erek hiniselok andi, “Yi un enam warogo at avyarat ombasagwi o,” yiluk, embetetek agipik yi? ");
INSERT INTO nbq_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Nit nenombao Averaham ako en Ala ake anggom warogo hali hunisagwima, ogovak higirogo baluk, at abut Isak Ala ake bagiluk ogagagi ako vaga, at Ala en, “Ap yi endawi mot o,” yiluk, wogogi. ");
INSERT INTO nbq_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Ala avyarat imbitya dugwit, eve inim ogagya lagagimu andi yedok higyo. Eke, eve at ogagagi vaga at endawi avyarat imbitigi ako dek agetek, mondok atma at agagi o. ");
INSERT INTO nbq_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Andi ogagagi vaga, Ala wene dirup warek yi: “Ap Averaham en Ala avyarat ombakluk, endawi At ovaga vanggabagagi vaga, Ala en ‘Ap yi endawi mot aro,” ’ yiluk, Ala wene dirup warek ako atma des iri lagagimu, At Ala en, “Ap Averaham ako andi, An naswe aro,” yiluk, yagagi. ");
INSERT INTO nbq_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Andi halok, nenendawi avyarat umbutu dugwit ogasagwi ovara, eve inim ogagetek hegek, Ala en nenendawi mot nenombarisogonbuk o. Ata, avyarat umbutu dugwit, eve inim ogasagwi vaga, nenendawi mot okbininaliga helagwi o. ");
INSERT INTO nbq_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Andi ogagagi wane-wane hwa yanenggek landiga menda Rahab ako en, it ap Yakuri menda o yokaguluk wagagwa ako initwis hawen yiluk, umwa hwilakbugu lagagirik, sup digot vaga lakbigigi ako vaga, at Ala en, “Hwa yi endawi mot o,” yiluk, wogogi. ");
INSERT INTO nbq_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Neneyave yi hegek, nenendawi nggigis erogo lagya halok, “Ap andi hombagas o,” yagalagwi ako ndatak nenendawi avyarat ombasagwi ovara, Ala wene andi eve inim ogagetek halok andi, un enam warogo at avyarat ombasagwi o. ");
INSERT INTO nbq_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Nowa-nasin. Ala en nenowak dinggu dugwit, anggin ombok erogo nit ap akwa mamuleralagwi menda ako nenovaga bininayogon ninelup atma, hit wisane, “An guru dogosogon o,” ombarubuk. ");
INSERT INTO nbq_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Nit ovok erogo yi weyak ndi weyak ogasagwi menda aro. Nit mondok sek duklurik en, nit nenane yagalagwi atok vaga weyak agya duklipuk. Nit nenane yagalagwi atok vaga weyak agya duklipuk en, neneyave nininggis-ninisok vaga en weyak ogarup okninivisiga ako ovok erogo sovalogo bagu duklu o. ");
INSERT INTO nbq_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Anderogo hak, wam kuda woginiviluk lagu dugwit, yo bogalek elagapma baluk, atok venak-venak vaga mbunggwi yidibaluk, nit laup ombasagwima akoma woginiviluk lendagwi. ");
INSERT INTO nbq_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Eke, mburis kapal layar ako mondok ombok atma, o havut anye ombok erogo iri dugwit, wolok landiga ovara, mburis andok pilot ako en, “Andoma laup,” imbitya dugwit, abi amot okhegek yupwak yiluk, yo mondok maduk elakas vokot sivinik agarik ako vaga nomalogo wolok landiga o. ");
INSERT INTO nbq_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Andi hak, nenabya aro. Nininggis ninisok ombok hegek, nenabya maduk ako en yagalagwi vaga wene ndugwi ombok wigya landiga o. Hali enggen maduk en, yavup sakni ombok hali naliga ako, henendawi dibas. ");
INSERT INTO nbq_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Nenabya andi hali abya hak aro. Yi weyak ndi weyak inis unggul ovok erogo adem andi, nenabya aro. Nenabya andi neneyave atok hunik atma, neneyave ovok at weyak erogo bininaliga. Hali munukmu en hali enggen wolok nenabya vaga yevedogo ba wendagwi vaga, nit ap akwa wen vaga menda ogasagwi ovok at ogarit lagu dugwit, weyak adigat ogarit lagu dogopwak yiluk, nenovaga yevedogo bininggik landiga adem andi, nenabya aro. ");
INSERT INTO nbq_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Swa-bagas, ndimbu-nggusa, mindom-mbas, duk-ikan, yi menda ndi menda ogagagi ako, ovok erogo vagago inil yonggoninivisagwima, yonggoninivup sek ovara, ");
INSERT INTO nbq_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","nenabya andi, il yonggunup andi meya o. Nenabya andi mondok weyak, ap akwa iniruguluk heda nalis oangga hak mondok hobo-hobo erogo agarik atma, sovalogo baup dek aro. ");
INSERT INTO nbq_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Nenane venak vaga nenasin Ala inis siyabagwi, eke venak vaga ap akwa Ala elose wane-wane ogovak higirogo bigigi helan, vudilogo bugwis, ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Nenelagap ambi at en wulu wagya dugwit, Ala inis siyabagwi, andi en, vudilogo bugwis, ogasagwima anderogo ogarup mondok moga o, nowa-nasin. ");
INSERT INTO nbq_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Is liris ambi at elola en, ambi sek menda wulu wagya, eke ambi eda menda wulu wagya, ogasiga dek o! ");
INSERT INTO nbq_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Eke, nggaris en saup yugu, sawe en nggaris yugu, ogarup sek embetep? Ata, is eda menda en, is sek menda wulu warup, sek embetep? Anderogo mondok ogasiga dek, nowa-nasin. ");
INSERT INTO nbq_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Hit ap ambi henanggelekma endawi werek dugwit, yi wene ndi wene vage yedok haliga halok, ap andi endawi werek helagwima, endawi sovalek dugwit sek ogarit lagya hinil havovok yiluk, ogarit lagya dogopwak o. ");
INSERT INTO nbq_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Anderogo ovara, hit henaninis umbutu dugwit, henendawi lakot dugwit yagan nagwis, “An hologo baliga adik ogarup,” umbutu dugwit, yagan nagwis, ogasagwima, henendawi wogobetaup andi moga o. Ala yagaliga wene hegek, avut dagalisagwima, huluk wene molalogo yagan nelagwi aro. ");
INSERT INTO nbq_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","16","Hit henaswe ambi aninis okbagu dugwit, henendawi lakot yagan nagwis, “An hologo baliga adigat ogarup,” umbutu dugwit, ogarit nagwis, ogagu hiniselok, mondok nadok-hadok agya dugwit, yi weyak ndi weyak ovok at agya helagwi ako andi, At endawi werek mbogot vaga agarik Ala ako en hologo bugu hegek ogasagwi dek. Ata, at sile en it ap akwa wen vaga menda enendawi hologo bugu hegek, henendawi ninggya halok, eyave at ogasagwi hinigis o. ");
INSERT INTO nbq_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Eke, At endawi werek mbogot vaga agarik ako en hologo bininaliga ako andi, adem ombok andi, nit nenendawi weyak agetek mondok sek adigat dogop. Aswe ambetaga andi, ap akwa sek ugun dambulik dogopwak yiluk, moga yugurugwi; nenendawi sagain vaga yugurugwi; yuknirugu-selok, “E o,” yiluk, ogarit lagwi; ap akwa enabwa en sek okbugwis; yo enggen eyave yiklandiga ako hak, nit anderogo at sek ogarit lagwi; ap ambi sek okbagwi, ap ambi weyak okbagwi, ogagetek wane-wane okbugwis; nenendawi lakot dugwit yugeregetek, nenendawi sagain vaga adigat yugurugwi; ogagu dogopwak yiluk, okbininaliga o. ");
INSERT INTO nbq_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","It ap akwa enendawi dambubigik nelagwi ako en enendawi dambulik dogopwak yiluk okbigik nagu dugwit, enggen yupwak yiluk awi angge yasagwi ako hak, ap akwa sek adigat ogagu dogopwak yiluk, enendawima mabigik nagwis, agarwik o. ");
INSERT INTO nbq_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Hit yawi bagwi, winimuk yugwi, ogasagwi adem andi ngga vaga embetep? Henendawi naliga adem ovok erogo henendawima dugwit, “An nendak ogarisogon, hat hendak ogarisogon,” henendawima en nidi-hidi yugu dugwit, ogasagwi ako dek? ");
INSERT INTO nbq_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Yi menda ndi menda waup henendawi naliga ovara, waup dek agya halok, ap at wasagwi. Eke, yi menda ndi menda hogop ombasagwi ovara, wegetek halok andi, winimuk yugwi, yawi-bagwi, ogasagwi. Hit hogop ombasagwi ako, Ala nggino yugegetekma, wegetek at agipik o. ");
INSERT INTO nbq_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Eke, hit nin en Ala wokherapwak yiluk, nggino yugisagwi ovara, henendawi naliga ako amusek lagu dugwit, dek erogo betaguluk, henendawi mondok adik hobaluk yagalagwima, wokheraligadek o. ");
INSERT INTO nbq_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Hwa ambi en ap ya hedegek nda hedegek ogarit landiga hak ogasagwi yi, it ap akwa wen vaga menda weyak ogasagwi inim, weyak ombasagwi inim, ako hinim henendawi hunik okhidugu hiniselok, Ala hit mberen ogot hedelagwi ako henunggutmu, ogasagwi? Anderogo atma, ap ambi, “It ap wen vaga menda weyak ogasagwi inim, weyak ombasagwi inim, ako ninim hunhedayogon o,” imbitya dugwit, ogagya halok, Ala im ogot hedaliga aro. ");
INSERT INTO nbq_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","“Ala en Averiniki nenendawima mabininggigi hegek, nenendawi naliga ako amusek lagu niniselok, Averiniki ako en, 'Ai', yiluk, endawi wakedaliga o,” yiluk, Ala wene dirup watigi ako andi, un watigi embetep? ");
INSERT INTO nbq_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Averiniki endawi anderogo at wakedaliga ovara, weyak hekbapwak yiluk, Ala endawi hunik en ombok at okbininaliga. “It ap akwa en enendawi wogobetelagwi halok, Ala en ogorogo bisaliga ovara, enendawi sovalek agarwik halok andi, Ala endawi hunik en ombok at okbisaliga,” yiluk, Ala wene dirup warek agarik o. ");
INSERT INTO nbq_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Anderogo atma, Ala avema seve eres. Ala avema seve yiluk, werekma, at sile madis ako en, weyak okhinivi wagya halok, hinim ndup sumbutu dogwes. Hinim ndup sumbutu dogosogon halok, at hoda wilisogon. ");
INSERT INTO nbq_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Hit Ala hinim horok-horok dogosogon halok, At Ala ogo hinim at dogosogon. Hit weyak ogasagwi yi, hininggis hutwis, eke henendawi mberen yi, henendawi ambi at okbaluk, yi weyak ndi weyak hekbagwi, ogagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Hit weyak ogasagwi ako vaga, henendawi mburup yugu dugwit, yup yagu dogwes. Hit enda yagwi, henadenggen yugwi, ogasagwi andi, hekbisiluk, henendawi mburup yugu dugwit, de wene yugu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Ala avema henendawi seve eres. Seve yugu hiniselok, At en hit siyabigigayogon o. ");
INSERT INTO nbq_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Nowa-nasin o. Henane huluk molalogo navok-havok yup andi moga. Hit ambi en henowa-henasin henane huluk molalogo enavok mbanggwis, enowak dinggwis, ogasagwi andi, “Ala en wene denggalogo yukneragagi andi weyak yagagi o,” yiluk, ogagu dugwit, At Ala wene owak dilisagwi hak ogasagwima, hit wene denggalek ogasagwi menda dek o. Hit Ala wene owak dilisagwi menda at henombasagwima, anderogo ogarubuk. ");
INSERT INTO nbq_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Wene denggalogo yukneragagi ako, nenowak dilisiga ako andi, At Ala adik aro. At adik en nenagap wendatu, dek erogo binininggu, ogarup sek ovara, hit Ala hak okhidugu dugwit, henowa-henasin enowak diluguluk ogasagwi ya? Moga, nowa-nasin. ");
INSERT INTO nbq_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Avyak! Hit wene mbanggu dugwit, “Yogak a, heveret a, o kota andoma lagu dogomundik, yoparip wonggalhedaguluk, yi menda ndi menda hunit lagu ninigik satu tahun at ogarusogon o,” yiluk, yagalagwi ako, henendawi dibagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Hit heveret okhinivup ako henunggut dugwit, yugwi hinigis. Niniluk agurik ako andi, isogo agarero hak aro. Isogo agarero dagasiga ako andi, sidok inggya ninil helagwi ovara, dek asiga ako hak andi, neneyave anderogo at okninivisiga o. ");
INSERT INTO nbq_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Andi halok, hiren yugu dugwit, “Nenasin en sek imbitya halok, neneyave sek dugwit, 'Yerogo ogarup nderogo ogarup',” yugu dogop andi sek. ");
INSERT INTO nbq_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Hivis ogarup henunggut dugwit, hinelup ovagak okhidugu dugwit wogobetelagwi andi, weyak at ogagu hinigis. ");
INSERT INTO nbq_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Eke, hit ambi sek ogarup hinelup dugwit ogagetek hiniselok andi, weyak aro. ");
INSERT INTO nbq_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Hit ap hininggis werek yi, henaruk hunggu dogwes. Hit idup yagan wakidugu dogop hudi vanggo yi wandigama, yup inim, na inim, yakidugu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Henangge iya ako andi weyak lagya, henasum sek ako andi, hudup-hudup en elo mbanggya, ");
INSERT INTO nbq_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","henayoparip enggen emas inim, verak inim, ogovak higirik ako andi, vage isip vaklagya ogarit landiga. Henayoparip isip vaklaga andi vaga, henabet heda, hwilakbetaluk welagagup ako, sigam arisogon. Eke, isip vaklarit landiga hak, hit henagap anderogo at, hali en nenggek layogon. O vivis oklarup ako vage vanggo yi wandigama, yi menda ndi menda henendawi hunik wonggalogo betugu lagagupikmu, henanggadi en henayup yakidugu dogosogon. ");
INSERT INTO nbq_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Wii! Iren hit heneyavup okbigigalagwi ako, onggo wane-wane wogirugu lagetekma, winimuk yukherelagwi. It nin heneyavumu en enggen mbalogo wolok wokhera wendagwi ako, inim onggo sek erogo wogeregetekma, winimuk yukheralagwi andi, nenasin ombok adigat anye werek ako, vage aruk hulisiga. ");
INSERT INTO nbq_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Hit wen vaga menda henangge-henangge vaga sek adigat dogop umbutu dugwit, henendawi hogop menda adigat amusek nagu lagagup. Wam amok werek agya halok, naguluk wasagwi ako hak, hit hininggis werek okhedelagwima, onggo hinirisogon. ");
INSERT INTO nbq_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","It ap akwa enendawi sek ako en wene onggo yukheregetek inigik, hiren henane huluk at enovaga bisiluk, initu lagagup. ");
INSERT INTO nbq_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Anderogo atma, nowa-nasin, nenowa warisogon atma, henendawi hora yiluk dogwes. Ap ambi en erom awi yakbagya lagarik, musu higya, hivi higya, ogagya dugwit, lengge yupwak yiluk endawi hora yiluk, sokhigya agarik ako dibas. ");
INSERT INTO nbq_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Andi wane-wane, hit hinim henendawi horaik dogwes. Nenasin warup ako vage vanggo yi wagarikmu, henendawi ndipuk-wadok dek okbetaluk dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Nowa-nasin o. Ala en weyak onggo henovaga okbigiga wagya hawen, henane mbaket yugu dugwit ap avok mbanggu dogobuk o. Hinelup dogop! Nenowak dilisogon ako andi, warigiluk vage sup mbanggutmu mendek agarik! ");
INSERT INTO nbq_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Nowa-nasin. It ap o endak erogo Ala en yugirigya hegek wene yugurugu lagagwa navi-navi ako, wiyik-nom weyak-nom okbugu-sigik, enendawi horaik wadok dek dugwit yugurugu lagagwa ako hak, hit enagut wakhegek wane-wane ogagu dogwes. ");
INSERT INTO nbq_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","It anggin enovaga agya hegek, enendawi horaik iniselok, Ala adenggen enovaga bugu lagagi ako ninelup aro. Ap Ayup inim anggin ovaga agya hegek, endawi horaik wadok dek welagagi ako andi, ovok henaruk hunggugup. Ala en ap akwa ovok enabwa en sek okbisaligama, ap Ayup anggin ovaga agya hegek endawi hora yiluk mondok wigya lagagimu, Ala en atok vaga okbagagi ako andi, hinelup aro. ");
INSERT INTO nbq_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Anderogo atma, nowa-nasin, an wene iya ambi yukherayogon o. Ala inis ugun yup andi moga. Mbogot inis inim, wen inis inim, yi menda ndi menda inis ovok at inis vaga “Yukeraliga o,” yiluk, yugeraup andi moga. Hit weyak yagalagwi vaga, Ala en weyak onggo henovaga bugugu hawen, “E o,” imbitya halok andi, “E o,” at yup. Eke, “Dek o,” imbitya halok andi, “Dek o,” yup. ");
INSERT INTO nbq_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Ap ambi henanggelekma en anggin-mbanggin ovaga agya halok, samban ogagya dogopwak. Eke, ap ambi endawi adenggen imbitya halok, ndawi vaga Ala inis siyabagya dogopwak. ");
INSERT INTO nbq_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Eke, ap ambi aup idup warek halok, ap Ala aburi vagago agarwik menda enayonggo yugeraup. Enayonggo yugurugu dogomundik, wagu iniselok, ap aup warek ako amburup ovaga ndibaluk, Ala inis vaga ake samban ogagu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Eke, it enendawi Ala avyarat umbutu dugwit samban ogagu iniselok, nenasin en ap aup warek ako legego sek okbayogon o. At weyak ogagya halok, weyak ako dek okbayogon o. ");
INSERT INTO nbq_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Anderogo halok, hit weyak ogasagwi ako, at ambi en at ambi adema aruk holek hegek vaganggwis, at ambi en at ambi ake samban ogagya, ogagu dogomwi vaga, aup idup okhinipu halok, sek okhinipu dogosogon o. Ap ambi endawi mot Ala inim hunik dugwit samban ogagya halok, Ala anye iya atma, atma ogarisogon o. ");
INSERT INTO nbq_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","At ap Eliya andi, nit ndatak welagagi. At “Musu wambu warubuk,” yiluk, ane avyarat des erogo samban ogagagirikmu, musu wen vaga wambu wagetek hegek, tiga tahun okbaluk, saut enam hudi welagagi. ");
INSERT INTO nbq_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Andi okbaluk, vivis samban ogagya lagagimu, musu ombok erogo wambu wagya dugwit, yo heda awi ako mondok iluk agya dugwit, enggen yogogi o. ");
INSERT INTO nbq_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Nowa-nasin. Ap ambi henanggelekma Ala wene wokbaluk, vivis “Nanggon,” yiluk, endawi nomaliluk lagya halok, hit ambi en ap ako endawi yonggonogo wolok wagu hiniselok, ");
INSERT INTO nbq_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","Ala en iri dugwit, “Ap andi weyak ogasiga ako hekbaluk, an nane wapwak yiluk, endawi yonggonogo wolok wagen vaga, ap andi hambuluk lendagwima lagyama, at weyak menda dek erogo agap wendarupwak yiluk, ogagen atma, sek at ogagen o,” yiluk, wa yukherayogon o. Wene Yakobus en dirup watigi ako, andi aro ");
INSERT INTO nbq_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Mbogot-wen yi, ao wakhegetek hegek, At endak erogo welagagi avakwa iniluk oginivisiga menda Eve Wene ako, avok vagalogo yukherelagwi o. At ane nenaruk hunggwis, eke ninil eyave en hugwi, ogarit lagya ako dibagwi, eyave nininggis vagatwis, ogagagup ako at yukheralagwi o. ");
INSERT INTO nbq_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","At mondok iluk agarik menda sigam agya lagagimu, ninil hagagup ako at vagalogo yukherelagwi. Eke, nit modok-modok niniluk dogoguluk, okninivisiga menda Yesus ako, nenasin Ala inim welagagi. At sigam agagi ako, “Yi aro,” yiluk, yukheralagwi. ");
INSERT INTO nbq_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Nit nenasin Ala abut Yesus Keretus inim hunik agurik. Hunik werekma, hit ogo, ninim nenendawi ambiat hunik dogoguluk, ninil hugwi, nenaruk hunggwis, ogagagup ako at yukherelagwi. ");
INSERT INTO nbq_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Eke, vagalogo yukherelagwi yi ako ovok erogo, nit nenendawi adenggen modok ombok arupwak yiluk, dirup yi, warisagwi. ");
INSERT INTO nbq_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","At Ala abut Yesus ako en yuknirigya dugwit, “At Ala andi, o awiya hak agarik atma, At endawima o hwiserek ovagak agarik modok dek o,” yiluk, yukneregagi ako, nenaruk hobaluk, yukherelagwi andi aro. ");
INSERT INTO nbq_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Anderogo atma, nit o hwiserek vaga nagu dugwit, “An Ala inim hunik agirik o,” yugu niniselok, avyarat wene ako wane-wane ogagetek dugwit yagalagwima, nenane huluk at yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Anderogo ovara, At Ala o awiya vaga agarik andi hak, nit o awiya vaga lagu niniselok andi, nenaswei ninim nenendawi hunik werekma, At abut Yesus amuya vaga nenomaluk ovok dek erogo bininggik ogagya dogosogon. ");
INSERT INTO nbq_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Nit weyak ogagu dugwit arova, “Nit weyak ogasagwidek o,” yugwi niniselok, huluk at nenambukmu dagal hedelagwima, avyarat wene Yesus avok ako nenendawima agarik modok dek aro. ");
INSERT INTO nbq_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Eke, nit nenomaluk avyarat vaganggu niniselok andi, At mondok des erogo atma nggedok sek adigat ogasiga menda atma, nit sek ogagatek weyak adigat ogarit lendagwi ako nenomaluk dek erogo bagya, eke weyak nenendawima agarik ako horogo bininggu, ogagya dogosogon. ");
INSERT INTO nbq_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","“Nit modok weyak ogwasagwidek aro,” yugwi halok, At Yesus huluk yagaliga menda okbelagwi atma, At Yesus awene ako nit nenendawima agarik modok dek aro. ");
INSERT INTO nbq_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Naburi o. Hit weyak ogagwi hinisaowen, wene yi, dirup mbalheraliga o. Anderogo ovara, nit ambi en weyak ogagwi niniselok, At atma nggedok sek adigat ogasiga Yesus Keretus ako en nit nenavokot agya dugwit, nenake wene wolok Nenasin yuguri lagek ogasiga o. ");
INSERT INTO nbq_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","At Yesus ako, nenomaluk dek erogo baluk, Ala ninim dambulogo bininaup nenake ogasiga andi, At aro. Nit nenadigat nenomaluk dek erogo baluk, Ala ninim dambulogo bininaup yiluk, nenake ogasiga andi dek o. Ata, nit yi avakwa ndi avakwa o wen vaga yoma agurik ovok erogo nenomaluk dek erogo baluk, Ala ninim dambulogo bininaup yiluk, nenake ogasiga. ");
INSERT INTO nbq_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Ala en, “Yerogo ogwarup, nderogo ogwarup,” wene yukneragagi ako wane-wane ogasagwi vaga, “It ap yi, avyarat Ala inilup inugup o,” yiluk, yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Yagalagwi ovara, ap ambi en Ala wene yukneraliga ako ogagetek dugwit, “An Ala nilup aro,” iri halok andi, avyarat wene Yesus avok ako at endawima dek. At endawima dek hegek irisim atma, ap andi huluk yagaliga menda araro. ");
INSERT INTO nbq_vpl VALUES ("J12_5","092_2_5","1JN","2","5","6","Eke, ap ambi en Ala wene yugup ako wane-wane ogagya halok andi, ap andi modok avyarat Ala endawi hunik wisane ogasiga. “Nit Ala ninim hunik agurwik o,” yugu dugwit, At Yesus Ala wene yugup ako wane-wane ogagagi hak, nit ogo, Ala wene yugup wane-wane ogasagwi andi vaga, Ala ninim avyarat hunik agurwik ninelup arisagwi. ");
INSERT INTO nbq_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Naswei nendawi hunik yi, wai. Anen, “Yerogo ogagu dogones o,” yiluk, dirup warisiga yi andi, wene o muk erogo Yesus en “Yerogo ogagu dogones o,” yiluk, yagagi ako at dirup warisiga. Wene yi, wene swi menda dek o. Wene yi, o muk erogo Yesus en yagagi henaruk hobaluk avyarat umbutugup ako at dirup mbalheraliga. ");
INSERT INTO nbq_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Mbalheraliga ovara, o hup dek agya hegek, o awiya eve sek menda nunggu wagya dugwit, wene muk yugup ako At Keretus en ogarit lagya, eke, hiren nendawi-hendawi hunik okhedegek nagwis, ogasagwi vaga sigam asiga. Andi atma, wene swi yugup ovagak halok, dirup mbalheraliga o. ");
INSERT INTO nbq_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Ap ambi sa en, “An o awiya vaga landiga o,” iri dugwit ovara, at asuwe Ala wene waliga menda anggon imbita halok, ap andi, endawi ao hwiserek ovagak agarik. ");
INSERT INTO nbq_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Eke, ap ambi en at asuwe Ala wene waliga menda endawi hunik ogagya halok andi, at o awiya vaga lagyama, lagya dugwit, owak dede iri dugwit weyak ogwasogon dek o. ");
INSERT INTO nbq_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Eke, ap ambi en at asuwe Ala wene waliga menda anggon imbitya halok andi, ap andi, endawi o hwiserek vaga lagyama, o hwiserek ako en at il mbuk erogo bagagi atma, “An o andoma vikit landiga,” embetetek at agarik o. ");
INSERT INTO nbq_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Naburi nendawi hunik yi wai. Hit henendawi Ala abut ovaga vanggabaluk avyarat ombasagwi ako vaga, Ala en henomaluk dek erogo bigigi atma, henake dirup yi, mbalheraliga o. ");
INSERT INTO nbq_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Nasini yi wai. At o endak yi dekma ndi dekma en werek adigat hegek, yogak hudi itok modok agarik hit hinilup agagupikmu, henake dirup yi, mbalheraliga. Narwi yi, wai. At Sile weyak okninivisiga ako hit vage sovalogo bagep atma, dirup yi, mbalheraliga. ");
INSERT INTO nbq_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Hit An naburi nendawi hunik yi, wai. Nenasin Ala henelup agagupikmu, dirup yi mbalheraliga. Hit nasini yi wai. At o endak yi dekma ndi dekma en werek adigat hegek, yogak hudi itok modok agarik hit hinilup agagupikmu, dirup yi, mbalheraliga. Hit an naori yi, wai. Hit Ala wene henendawima hidugu lagagupik, henendawi hoda agagup ako vaga en at Sile weyak okninivisiga ako sovalogo bagagup atma, dirup yi, mbalheraliga o. ");
INSERT INTO nbq_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","It ap wen vaga menda en enendawi ningga halok wenggebaluk ogasagwi inim, yi menda ndi menda wen vaga weyak menda inim, ovok erogo henendawi hunik dogobuk. It ap wen vaga menda en enendawi wenggebaluk ogasagwi ako henendawi hunik umbutwi hiniselok, Nenasin inim henendawi hunik ogagu dogosogom mondok dek aro. ");
INSERT INTO nbq_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","It ap wen vaga menda en enendawi ninggya halok musek lagwi ako inim, inil hugu dugwit hogop ombasagwi ako inim, ogarit nagu dogopwak yiluk, Nenasin en ombasigadek. Eke, iren, “An wenggelisiga adigat iya o,” yiluk, wogobategek nagwis ako ogo, ogarit nagu dogopwak yiluk, Nenasin en ombasigadek o. Ata, it ap wen vaga menda en at, enendawi wenggebaluk, ogasagwi o. ");
INSERT INTO nbq_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","It ap wen vaga menda en enendawi wenggebaluk ogasagwi inim, yi menda ndi menda enendawi ninggya halok musek lagwi inim, ovok erogo dek arisogon. Dek arisogon ovara, Ala endawi ombasiga menda ako, hit wane-wane ogagwi hiniselok andi, modok-modok hiniluk at dogogup o. ");
INSERT INTO nbq_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Naburi nendawi hunik yi wai. O hivis vaga ogarup ako vage vanggo yagas o. Eke, “Vivis it nin At Ala denogo mondok okbagagi Keretus ako, inim mondok ogorek menda wasogon,” hit henaruk hunggugup. Hit hunggugup ako, yogak Keretus Ogorek ako menda eneyave wisane vage mondok yagao. It mondok yagao agarwik andi vaga, “Wi! O hivis vaga ogarup ako vage vanggo yagas higi,” yiluk, ombasagwi. ");
INSERT INTO nbq_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","It ap Keretus Ogorek andi, endak ninim homagu lagagup ovara, “It andi, nit menda dek o,” yiluk, hetbininiluk wunggugwa. “It ap andi, nit menda aro,” yiluk ombatlipmu en, ninim at duklip ovara, Ala en, “It andi, ovok erogo hit menda dek, hunogo menda agarwik, yiluk, sigam arupwak,” yiluk, imbitigi vaga anderogo hekbininiluk wunggugwa. ");
INSERT INTO nbq_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Anderogo ovara, hit andi, At Yesus Keretus mondok sek adik denek ako en hit denogo bigiluk, Ala Averiniki wokheragagimu, avyarat wene ako hit ovok erogo hinilup at hinigis o. ");
INSERT INTO nbq_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Avyarat wene Yesus avok ako hit hinilup atma, dirup yi mbalheraliga. Eke, adem avyarat wene ako vaga en, huluk wene yagalagwi mondok dek andi, hit hinilup aro. ");
INSERT INTO nbq_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Ap huluk yagaliga menda andi, sa embetep? Dek o. Ap ambi en, “Yesus andi, nenowa inis ombok Keretus Ala en denogo bagagi ako, at dek aro,” iri halok, ap huluk yagaliga menda araro. “Yesus andi, nenowa inis ombok Keretus Ala en denogo bagagi ako, at dek aro,” yagalagwi ako vaga Ala abut Yesus inim, asin Ala inim, “Nenanggon o,” yiluk, hekbelagwi. Hekbelagwima, Keretus Ogorek menda it aro. ");
INSERT INTO nbq_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Abut Yesus hekbagwi halok, asin ogo hekbelagwi, eke, “Yesus andi, nenowa inis ombok Keretus Ala en denogo bagagi ako, araro,” yiluk, welagwi halok andi, asin ogo welagwi, aro. ");
INSERT INTO nbq_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Hit andi, wene o muk endak erogo henaruk hobaluk, wagagup ako, henendawima modok wenggelek dugwit, vagogo dogones o. Modok wadok dek vagogo hiniselok, Nenasin Ala abut iperen hinim hunik at dogosogom o. ");
INSERT INTO nbq_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","Nit okbininaup Yesus en avyarat nggatuk erogo yagagi ako andi, “Hit modok-modok hiniluk dogovovok yiluk, okbigigayogon o,” yiluk, yukneregagi andi aro. ");
INSERT INTO nbq_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Iren henambutmu unggu dugwit, nomalhinivit lagwi isawen, dirup yi mbalheraliga o. ");
INSERT INTO nbq_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Naburi o. Ala Averiniki henovaga wombabigiga wagagi henendawima werekma, ap ambi en hit mamulheraup dek aro. At Ala Averiniki en yi wene ndi wene ovok erogo mamulhirigya dugwit, huluk wene mamulheraligadek avyarat adigat mamulheraliga. Avyarat adigat mamulheraliga atma, at mamulheraliga ako andi, wane-wane ogagu dugwit, Keretus hinim mondok-mondok hunik okhedugu dugwit, vagago dogones o. ");
INSERT INTO nbq_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Anderogo atma, naburi. (Hit Yesus inim mondik hunik at okhedugu dogones.) Hivis At warup ako hudi vaga nit nenanggadi dek nenendawi seyalek dogoguluk, yogak en hit Yesus inim mondok hunik at okhedugu dogones. ");
INSERT INTO nbq_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","At Keretus andi, At atma nggedok sek adigat ogasiga henelup atma, it avakwa sek ogasagwi ako, “Yi At Ala en at endaginipigi higi o,” yiluk, hinilup arusogom o. ");
INSERT INTO nbq_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","At Ala en, “Hit An naburi aro,” yuknirigya andi vaga At nenasin nenabwa ombok modok wisane ombasiga andi, dibas. Nit avyarat At aburi agurik o. It avakwa wen vaga menda adigat musek lendagwi ako en endak Ala yedok hegetek welagagwa andi vaga, yogak ogo, nit At aburi yedok ninigitek at agarwik. ");
INSERT INTO nbq_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Naswei o. Hit An nendawi hunik atma, wene ambi yukherayogon. Nit yogak at Ala aburi agurik o. Eke, nit hivis nggarogo okbininaup ako, nit ao sigam hegetek ovara, At wagya halok, “At eve anderogo agarik,” yiluk, yedok hagup ako ndatak at neneve okbininup ninilup o. ");
INSERT INTO nbq_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Nit okbininup ako nenape wenggelek agurik halok, At Keretus endawi sek adigat agarik ako ovagak, nit wane-wane nenomaluk horogo nenendawi sek adigat okhedugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Ap weyak ogasagwi andi, Ala wene yugup ako at sagalisagwi atma, ap ambi weyak ogarit lagya halok andi, Ala wene yugup ako at weyak erogo baliga. ");
INSERT INTO nbq_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","At Keretus weyak modok ogasigadek atma, nit nenomaluk dek erogo bininaigen yiluk, wambu wagagi ako henelup at agipik. ");
INSERT INTO nbq_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Anderogo atma, ap ambi at Keretus inim hunik agarik halok andi, at o ndugurek-ndagarek weyak ogarit landigadek. Eke, ap ambi weyak ogarit landiga menda halok andi, Keretus il higya, eyave elup agya, ogagetek at agarik o. ");
INSERT INTO nbq_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Naburi nenendawi hunik yi, wai. It avakwa ugun en hit nomalhinivit wagwi hinisaowen, dibagu dogwes o. Ap ambi weyak ogagetek sek adigat ogarit lagya halok, at Keretus weyak ogasigadek modok sek adigat agarik ako ovagak agarik o. ");
INSERT INTO nbq_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","At Sile o muk endak en weyak ogarit wulu wandiga aratma, ap ambi weyak adigat ogarit lagya halok, at Sile abut at agarik. Eke, at Sile ako weyak adigat ogarit landigama, At Ala abut wambu wagagi ako andi, at Sile en ogasiga ako modok dek erogo bagiluk, wambu wagagi. ");
INSERT INTO nbq_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Ap ambi Ala en endagya halok, endawi swi vaga At Ala andogon at waliga atma, at weyak ogagya dogosogon dek o. At Ala en at endagagirikmu, at o ndugurek-ndagarek weyak ogarit lagya dogosogon dek aro. ");
INSERT INTO nbq_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Ala aburi inim, Sile aburi inim, nano vaga ninelup arup ako yerogo: It avakwa sek ogagetek weyak adigat ogagwi, enowa-enaot inim enendawi hunik oginipitek enanggon umbutwi, ogagu-selok andi, Ala aburi erogo dek andi yedogat iniselagwi. ");
INSERT INTO nbq_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","O endak en Yesus wene yuknirigya hunggu lagagup ako andi, “Nendawi-hendawi hunik ogagu dogones o,” yiluk, yukneragagi andi aro. ");
INSERT INTO nbq_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","At Hain en ogagagi ako ovagak, hit anderogo ogarup moga o. At Sile weyak okninivisiga ako abut aratma, aot modok watigi. Nano yiluk aot watigi embetep? Dek. At Hain weyak adigat ogasiga menda atma, aot sek adigat ogagya higya lagagirik, aninis en at aot watigi. ");
INSERT INTO nbq_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Anderogo halok, naswei o. It avakwa wen vaga menda adigat musek lendagwi ako en enanggon hinumbutwi iniselok, “Wi,” yiluk, henalon ombarubuk. ");
INSERT INTO nbq_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Nit nenendawi nggorak ndatak welagagup ovara, Ala en nenendawi niniluk okbininggigi ako, avyarat mondok niniluk agurik halok, nit nenaswi nenarupwi Ala wene welagwi menda ninim nenendawi hunik oginivisagwi ako vaga yedok helagwi o. Ap ambi sa en avakwa endawi hunik oginivisigadek halok andi, at endawi nggorak ovagak ao agarik. ");
INSERT INTO nbq_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Ap ambi at asuwe Ala wene waliga menda anggon imbita halok, at avakwa inirisiga menda araro. Eke, avakwa inirisiga menda ako andi, at modok-modok iniluk dogop menda andok okhedegetek andi, henelup aro. ");
INSERT INTO nbq_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Nano ogasagwi vaga nenaswei ninim nenendawi hunik okbugwis ako ninelup arup embetep? Dek o. At Yesus endawi hunik en, “An avakwa enake narupwak aro,” imbita lagagirik, nenake hombagagi andi wane-wane, nit ogo, “Nenaswi enabwa en enake hambup sek aro,” yiluk, umbutu dogones. ");
INSERT INTO nbq_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Ap ambi yi menda ndi menda werek en, aswe ambi yi menda ndi menda dek il haliga ovara, abwa embetetek, “Nanggon,” yiluk, hekbagya halok, Ala en avakwa enabwa ombasiga ako menda endawima agarik modok dek aro. ");
INSERT INTO nbq_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Naburi nendawi hunik yi wai. Nit nenane vaga en adigat, “Avakwa ninim nenendawi hunik agurik o,” yiluk, yup moga o. Ata, nenendawi vaga en enabwa ombok wisane erogo umbutu dugwit, sek okbigik lagu dogosogom o. ");
INSERT INTO nbq_vpl VALUES ("J13_19","092_3_19","1JN","3","19","20","Nit ogasagwi menda ako Ala ivaga wenggelagya dugwit, weyak ambi ogagyo vaga nenendawi en nenanggadi wakbininggu halok, nenalon ombasagwi. Nenalon ombasagwi ovara, nit yi ogagek ndi ogagek ogasagwi menda ako inim, nenendawima okninivisiga menda ako inim, ovok erogo at Ala elup. At ovok ilup atma, nit Ala ivaga, “An avakwa enabwa en sek okbigik lagya lagagis ako vaga Hat Ala yagaliga menda ako an wane-wane ogagya lagagis o,” ombakluk, nenalon dek dugwit, at yugurup sek aro. ");
INSERT INTO nbq_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Naswei nendawi hunik yi wai. Nit weyak ambi ogagatek vaga nenendawima en nenanggadi wakbininggitek halok, Ala ivaga nenalon ombarup dek o. ");
INSERT INTO nbq_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Anderogo atma, At Ala en, “Yerogo ogwarup, nderogo ogwarup,” yiluk, yukneraliga menda wene inim, nit ogarup endawi sek ombasiga menda ako inim, wane-wane ogagu niniselok, nit yi menda ndi menda woknerapwak yiluk, nggino yugisagwi ako, at woknirigya dogosogon aro. ");
INSERT INTO nbq_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","At Ala en “Hit henendawi An nabut Yesus Keretus ovaga vanggabaluk avyarat umbutwi, eke, Anen yukheragagis ako wane-wane hit-hit henendawi hunik oginipwis, ogagu dogones o,” yiluk, wene ombok yukneraliga ako, andi aro. ");
INSERT INTO nbq_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Wene, “Yerogo ogwarup, nderogo ogwarup,” yukneraliga menda wene ako, hit ambi en wane-wane ogagwi hiniselok, At hit hinim hunik agarik, eke, hit At inim hunik agipik o. Eke, Ala Averiniki wokneragagi nenendawima yuknirigya andi vaga At Ala avyarat nit ninim hunik agarik ako ninelup agurik o. ");
INSERT INTO nbq_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Naswei nendawi hunik yi wai. Avakwa huluk wene yugerelagwi menda wisane en yi awi ndi awi ovok erogo yugeregek lendagwi atma, ap ambi henadema wagya dugwit, “Ala Averiniki en yuknirigya halok, yukhera wagyo o,” yiluk, yukhera wagu iniselok, enane avyarat umbutu dugwit ugun waup moga o. Ata, “At Ala Averiniki en avyarat lakbisa wagao atma yagan wendagwi a, ata it enendawi en wenggebaluk yagan wendagwi a?” yiluk, enavut mbabaluk enane hunggu dogop sek aro. ");
INSERT INTO nbq_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Eke, “Ala Averiniki enendawima dugwit, yagan wendagwi a,” yiluk, yedok hugu dogop ako yerogo: “At Yesus andi, Ala en denogo baluk lakba wagagi Keretus ako at avyarat wen vaga wambu wagya lagagirik, eve ap at endaklagagi o,” yiluk, vaganggu iniselok, “Ap andi, Ala en avyarat lakbisa wagagi Averiniki enendawima dugwit, yugwi inugup o,” yiluk, enane hunggu dogop sek. ");
INSERT INTO nbq_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Anderogo ovara, it ap andi en, “Yesus andi, at Ala en denogo baluk lakba wagagi Keretus ako eve ap at endaklagagi,” vagalisagwidek iniselok andi, “Ap andi, Ala en lakbisa wagetek, it enadik en, enendawi wenggebaluk yugeregek wagao,” ombarop. “O hivis erogo Keretus Ogorek menda wagya dogomindik, ‘Yesus wagya lagagirik, ap at endaklagagi andi dek o,’ yiluk, yagan wagya dogosogon o,” yiluk, yugwi henaruk hunggugup ako, “Ovok waga yi at inugup o,” yiluk, ombarop. ");
INSERT INTO nbq_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Naburi nendawi hunik yi wai. It avakwa Keretus Ogorek menda Ala wene enanggon ombasagwi ako, enendawima agarik andi, anye dek ovara, hit andi, hit Ala aburi atma, at Ala Averiniki anye mondok wisane henendawima agarik andi en, it ap huluk wene yugerelagwi menda ako sovalogo bugugup o. ");
INSERT INTO nbq_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","It Keretus Ogorek menda andi, wen vaga menda atma, iren wene wen vaga menda enane yugu-selok, it ap wen vaga menda nin en enane yagalagwi ako enaruk hulisagwi. ");
INSERT INTO nbq_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Eke, nit andi, Ala aburi atma, nit nenane yagalagwi ako, it avyarat Ala inilup menda ako en enadigat enaruk hulisagwi. Eke, Ala aburi dek halok andi, nit nenane yagalagwi ako hulisagudek aro. Nit nenane hulisagwi a, ata hulisagwidek a, andi vaga niren, “Ala Averiniki avyarat adigat yagaliga ako it enendawima agarik a, ata, madis ane huluk yagaliga ako enendawima agarik a,” yiluk, ninilup asagwi. ");
INSERT INTO nbq_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Naswei nendawi hunik yi, wai. Avakwa nenendawi hunik ogonupu dogoguluk, Ala en at okbininiliga atma, nendawi-hendawi hunik ogagu dogones o. Ap ambi sa en nendawi-hendawi hunik ogagwi iniselok, Ala en at endaginipigi ma, At aburi dugwit, At Ala andi avyarat inilup at agarwik o. ");
INSERT INTO nbq_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Eke, at Ala en yi ap ndi ap ovok erogo enabwa imbitya dugwit, endawi hunik ombok erogo oginivisigama, ap ambi sa en nendawi-hendawi hunik oginivisagwidek halok andi, it Ala inunggut at agarwik o. ");
INSERT INTO nbq_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","Nit Ala abut vaga mondok-mondok niniluk dogoguluk, Ala en At abut ambiat ako wen vaga lakba wagagi. At abut ambiat lakba wagagi andi vaga, Ala avyarat nenabwa imbitya dugwit, endawi hunik okninivisiga ako andi, yedok helagwi. ");
INSERT INTO nbq_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Nenaswei nenendawi hunik okbisaup ako andi, ngga ndatak embetep? Dek o. Niren Ala nenendawi hunik ogagetek. Ata, Ala nenabwa en endawi hunik okbininggu lagagirik, nenomaluk dek erogo bagya dugwit, ninim dambubininupwak yiluk, At abut at lakba wagagi. ");
INSERT INTO nbq_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Anderogoma, naswei, At Ala en anderogo at nenabwa imbitya dugwit, endawi hunik okbininggigirikmu, nit ogo wane-wane nendawi-hendawi hunik ogagu dogop sek aro. ");
INSERT INTO nbq_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Nit ovok erogo Ala eyave ninil hegetek at agurik ovara, nit nendawi-hendawi hunik ogagu niniselok andi, Ala ninim mondok hunik dogosogon o. Anderogo werekma, nit nenendawi Ala inim hunik arup Ala imbitigi ako andi, mondok avyarat ogagu dogosogom o. ");
INSERT INTO nbq_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","At Ala en Averiniki wokneragagi nenendawima werek andi vaga, At Ala avyarat nit ninim hunik agarik, eke nit At ninim hunik agurik, ako ninelup aro. ");
INSERT INTO nbq_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Eke, nenasin en yi avakwa ndi avakwa enagap wendarupwak yiluk, At abut lakba wagagi ako ninil hugu lagagurik, vagalogo yukherelagwi. ");
INSERT INTO nbq_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Ap ambi sa en, “Yesus andi, Ala abut aro,” yiluk, vaganggu halok, Ala at inim hunik agarik, eke, at andi, Ala inim hunik agarik o. ");
INSERT INTO nbq_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","At Ala nenabwa imbitya dugwit, endawi hunik okninipigi ako, nit avyarat ombasagwi. Eke, nit nenabwa imbitigi andi vaga nit nenendawi at ovaga vanggabaluk, agurik. At Ala en yi ap ndi ap ovok erogo nenabwa imbitya dugwit, endawi hunik ombok erogo okninivisigama, hit nendawi-hendawi hunik oginipwis hiniselok, Ala hit hinim hunik agarik, eke, hit Ala hinim hunik agipik o. ");
INSERT INTO nbq_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Nit Ala inim hunik dugwit, Keretus ogagya lagagi ako hak, nit o wema yoma dugwit anderogo mondok avyarat nendawi-hendawi hunik okhedugu dogosogom. Nendawi-hendawi hunik okhedugu dogosogom andi vaga, o vivis nenowak dininivup ako hudi vaga, nenalon dek nenendawi seyalek hora yisogom o. ");
INSERT INTO nbq_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Nit nenendawi Ala ninim hunik halok, nit nenalon dek dogosogom. Nit weyak ogagu niniselok, Ala en weyak onggo okninivup ako vaga nenalon agurik ovara, nit avyarat nenendawi Ala inim hunik ogagu niniselok, nenalon ombasagwi ako dek asiga. Ap ambi en ao alon ombasiga halok andi, at endawi Ala inim hunik ogasiga ako, ao hoda erogo ogagatek. ");
INSERT INTO nbq_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Endak At Ala en nit nenabwa imbita dugwit, endawi hunik okninipigirikmu, yogak nit ogo anderogo at avakwa enabwa umbutu dugwit, nenendawi hunik ogonupu dogosogom o. ");
INSERT INTO nbq_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Ap ambi at asuwe Ala wene waliga menda il higya dugwit ovara, endawi hunik ogasigadek halok, At Ala il hegetek atma nggarogonggan endawi Ala inim hunik ogarup embetep? Modok meyan atma, at asuwe anggon imbitya dugwit, “An Ala nendawi hunik agirik o,” iri halok, ap andi huluk yagaliga menda aro. ");
INSERT INTO nbq_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","At Yesus en iri dugwit, “Hit Ala henendawi hunik ogagwi hiniselok, henaswei ogo enabwa umbutu dugwit, henendawi hunik ogonupu dogones o,” yiluk, wene yukneragagi ako andi aro. ");
INSERT INTO nbq_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Niren, “ “Yesus andi, nenowa inis ombok Keretus Ala en denogo bagagi ako, araro,” yiluk, avyarat umbutwi niniselok, Ala enat endakninipigirikmu, nit At aburi at agurik. Eke, nenasin Ala nenendawi hunik ogagu dugwit halok andi, aburi endago ako inim nenendawi hunik oginivisagwi. ");
INSERT INTO nbq_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Anderogo atma, nit nenendawi Ala inim hunik dugwit, wene “Yerogo ogarup, nderogo ogarup,” yukneragagi ako ogagu dugwit halok, nit at aburi nenendawi hunik oginivisagwi. ");
INSERT INTO nbq_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Nit At Ala nenendawi hunik ogasagwi halok andi, niren At “Yerogo ogarup, nderogo ogarup,” yukneraliga ako andi, ogasagwi o. Eke, At Ala en wene, “Yerogo ogwarup, nderogo ogwarup,” yukneraliga ako andi, anggin modok dek aro. ");
INSERT INTO nbq_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","Andi, nit Ala endakninipigi ako en it avakwa wen vaga menda Ala ogorek agarwik ako sovalogo biselagwi. It avakwa wen vaga menda Ala ogorek agarwik sovalogo biselagwi ako andi, nit Yesus ovaga vanggabaluk avyarat ombasagwi vaga enat sovalogo bisiluk, nit siyalek at agurik. ");
INSERT INTO nbq_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Sani en it ap wen vaga menda Ala ogorek agarwik ako, sovalogo biselagwi embetep? Dek. Niren, “Yesus andi, Ala abut aro,” yiluk, avyarat ombasagwi ako enat sovalogo biselagwi. ");
INSERT INTO nbq_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","At ima wombabagya hagagup ako inim, eke, hambigya dugwit, amuya wambigya hagagup ako inim, andi, Yesus Keretus eyave aro. Ima wombabagya hagagup ako adigat andi dek o. Ata, at amuya wombagagi ako inim hugu lagagurik, “Yi Yesus Keretus avyarat o,” yiluk, umbutugup. Eke, Ala Averiniki ako andi, Ala yagaliga wane-wane avyarat adigat yagaligama, aren ogo, “Yi Yesus Keretus avyarat o,” yiluk, avok vagalogo yukneraliga. ");
INSERT INTO nbq_vpl VALUES ("J15_7","092_5_7","1JN","5","7","8","Anderogo atma, wene henggam agarik. Wene ambi andi, Ala Averiniki en yukneraliga ako. Wene ambi andi, ima wombabagya hagagup ako, eke, wene ambi andi, amuya wambigya ninil hagagup ako, wene henggam andi at agarik. Wene henggam andi at agarik ovara, adem ambiat, “Yesus andi, nenowa inis ombok Keretus Ala en denogo bagagi ako, araro,” yiluk, ninelup aruguluk, agarik. ");
INSERT INTO nbq_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Ala en wene yuknirigya dugwit, “Yesus andi, An nabut aro,” yiluk, yukneraliga. Anderogo atma, Avakwa en vagalogo yuknirugwi iniselok andi, avyarat ombakluk waup sek ombasagwi ovara, nit avyarat ombaruguluk Ala en wene yuknirigya dugwit, “Yesus andi, An nabut aro,” yiluk, yukneraliga andi, modok iyama, “Yi avyarat o,” yiluk, wugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Nit nenendawi Ala abut ovaga vanggabaluk, avyarat umbutwi niniselok, nenendawima en, “Yi Ala abut avyarat wigo,” yiluk, ombasagwi. Eke, it Ala avyarat embetetek dugwit, wene At Abut avok vagalogo yugeragagi ako ogo avyarat embetetekma, Ala huluk yagaliga ovagak okbelagwi o. ");
INSERT INTO nbq_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","At Ala en wene vagalogo yukneragagi ako yi aro: Nit niniluk modok-modok dogoguluk, Ala en okbininggigima, at abut wugu niniselok, modok-modok niniluk dogosogom. ");
INSERT INTO nbq_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Eke, ap ambi sa en Ala abut waliga halok, niniluk modok-modok dogosogom ovara, ap ambi sa en Ala abut waligadek halok andi, iluk dogosogom modok dek aro. ");
INSERT INTO nbq_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Hit henendawi Ala abut ovaga vanggabaluk avyarat ombasagwi ako, Ala en hiniluk modok-modok dogop andok okbininggigi henelup arovovok yiluk, dirup yi mbalheraliga o. ");
INSERT INTO nbq_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","At Ala endawi ombasiga ako wane-wane woknerapwak yiluk, nggino yugugu niniselok, At aruk hulisiga andi ninilupma, nenalon embetetek At nggino yugugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","Andi en, niren at nggino yugugwis ako, at avyarat aruk hulisiga ninilup atma, nit nggino yugisagwi ako andi avyarat woknerayogon ninilup aro. ");
INSERT INTO nbq_vpl VALUES ("J15_16","092_5_16","1JN","5","16","17","Yi weyak ndi weyak ogasagwi ako andi, ovok erogo inis weyak arovara, weyak menda andi adem mberen agarik. Weyak menda adem ambi andi, enasam helok Ala en enomaluk ako dek erogo baup ndak ovara, adem ambi andi, mondok weyak atma, Ala en omaluk andi dek erogo baup mondok dek, mondok-mondok hambup menda at agarik o. Anderogo atma, ap ambi en mondok weyak hambup menda ako andi mikbetaluk ogarit lagya halok, ap ako ake Ala yugeravovok yiluk, yukheraliga dek. Ata, henasuwe ambi weyak menda ogagya hinil helagwi halok, weyak ogagya andi Ala en nenomaluk dek erogo bininaup ndak ako menda halok, Ala en ap ako omaluk dek erogo baluk, iluk mondok dogop menda okbapwak yiluk, “Ap ako ake Ala yugugu dogones o,” yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Ap ambi Ala en endatigi halok, At weyak ogarit landigadek andi, ninelup aro. Ala abut Yesus en ap andi, des erogo at vagogo agarik atma, at Sile mondok weyak ogasiga ako en ap andi, weyak okbayogon mondok dek aro. ");
INSERT INTO nbq_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","Yi avakwa ndi avakwa weyak ogasagwi ako ovok erogo at weyak ogonivisiga Sile ako avema agarwik ninelup ovara, nit andi, Ala aburi at agurik o. ");
INSERT INTO nbq_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","At Ala abut wambu wagya lagagirik, Ala modok avyarat agarik ako nit dibapwak yiluk ninelup okbininggigi. Eke, At modok avyarat agarik Ala, abut Yesus Keretus iperen ninim nenendawi mondok hunik at agurik o. At Yesus Keretus andi, at mondok avyarat agarik Ala ako aratma, niniluk modok dogop andok okbininiliga menda adem araro. ");
INSERT INTO nbq_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Naburi nendawi hunik yi wa! At Ala mondok avyarat agarik ako hekbaluk, avoloma huvuwak adik ambi mikbaluk, inis siyabagwi hinisaowen, dibagu dogwes yiluk, yukheraliga o. Ai naburi wa! ");
INSERT INTO nbq_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","Ai wa narup. Hat Ala en mikhitigi ako inim, hat heyagi inim, an Yohanes en wene ambi yukherayogon. An Ala aburi heneyaga agirik yi ako en hit avyarat nendawi hunik okhinivisigama, yukheraliga. Anen adigat nendawi hunik okhinivisiga andi dek o. Ata, it avakwa en avyarat wene Yesus avok wene wagagwa ako ovok ninim en nenendawi hunik okhinivisagwi o. ");
INSERT INTO nbq_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","Avyarat wene Yesus avok wogogup ako nenendawima agarik atma nit nenendawi hunik okhinivisagwi. Eke, avyarat wene ako mondok-mondok ninim dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","Nit avyarat wene Yesus avok ako wokbaluk, musek lagu dugwit, nenaswei ninim nendawi-hendawi hunik ogarit lagwi ninigik, nenasin Ala At abut Yesus Keretus inim nenabwa en okbinunggwis, enaigwak abet en okbinunggwis, nenendawi sek wadok dek adenggen dogoguluk, okbinunggwis, ogagu dogopwak. ");
INSERT INTO nbq_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","At nenasin Ala en, “Yerogo ogares o,” yiluk, avyarat wene yukneregagi ako hat heyagi nin hinim wane-wane ogarit lendagwi naruk hunggu lagirik, an nendawi modok adenggen wisane ombasiga. ");
INSERT INTO nbq_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","Eke, narup o. Yogak ambi ogagya dogonyok yiluk, yukhisogon. “Nendawi-hendawi hunik ogagu dogones o,” yiluk, yukhisiga yi ako andi, wene swi menda dek. O endak en Yesus wene yuknirigya hunggu lagagup ako at yukhisiga o. ");
INSERT INTO nbq_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","Nendawi-hendawi hunik ogagu dogop ako andi, Ala wene yugup wane-wane ogagu dogop andi aro. Eke, nendawi-hendawi hunik ogarit lagu dogop wene andi, o endak en Yesus wene yuknirigya hunggu lagagup ako at yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","It ap nin en, enane huluk yugu dugwit, “At Yesus andi, Ala en denogo baluk lakba wagagi Keretus ako ap ovagak wen vaga yoma endaklagetek o,” yiluk, avakwa enambutmu dagaguluk yugeregek lendagwi menda yi awi ndi awi eneyave wisane at agarwik. It ap andi, Ala abut denogo mondok okbagagi Keretus ako, inim mondok ogorek agarwik. It ako Keretus Ogorek menda hak dugwit, huluk-huluk at avakwa enambutmu dagalisagwi atma, ");
INSERT INTO nbq_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","hit Ala aburi henendawi des erogo suwam wakhidugu dogones. Niren wene Yesus avok yukheragagup wagagup ako, hiren hininggut akluk mbo bagwi hiniselok, sek ogasagwi vaga Ala en onggo wane-wane wokheraup imbitigi ako, dek erogo bayogon. Anderogo atma, Ala en onggo wokheraup imbitigi ako, dek erogo bagu-sawen, henendawi des erogo suwam wakhidugu dogones o. ");
INSERT INTO nbq_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Ap ambi Keretus wene mamulik ako adigat vagago dek at endawi wenggebaluk, wene adik inim lobalogo yugeregek lagya halok, at Ala inim hunik dugwit yagaliga dek o. Ata, Keretus wene mamulik ako wane-wane ogagya halok andi, nenasin Ala abut iperen inim hunik dugwit yagaliga ombarusogom. ");
INSERT INTO nbq_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","Ap ambi wene yi menda dek wene adik menda wolok yukhera wagya halok, hai warogo henamwa mabaup moga. ");
INSERT INTO nbq_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","Hai warogo henamwa mabagwi hiniselok, at omaluk hit hinim wane-wane at lobalhedagup. ");
INSERT INTO nbq_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","An wene wisane yukheraup yiluk agirik ovara, dirup mbalheraup nanggon oknitama, henadema wagya dogomindik, ninim nenelose hubaluk, nenadenggen vaga wene sek erogo mbalup hogop ombasiga o. ");
INSERT INTO nbq_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","Howa Ala mitigi eyagi ako ninim dugwit, hai wakhinivisagwi o. Wa! ");
INSERT INTO nbq_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","Nasuwe Nggayus wai. An Ala aburi eneyaga agirik Yohanes yi en, hat nasuwe nendawi mondok avyarat hunik atma, wene ambi yukhirisogon o. ");
INSERT INTO nbq_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Nasuwe nendawi hunik. Hat Ala wene des erogo musek lagya dugwit, hendawi eyave sek erogo wenggebaluk ogarit landiga. Anderogo ndatak, hat heyave edup dek modok sek adigat dugwit, yi menda ndi menda ogasiga ako sek adigat higya dogonyok yiluk, hake samban ogasiga. ");
INSERT INTO nbq_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","Hat avyarat wene Yesus avok ako wokbaluk, ogarit landiga ako, naswei Ala aburi nin nadoma wagu lagaorik, “At Nggayus ako avyarat wene des erogo wane-wane at ogarit landiga o,” yiluk, mbilinogo yukniri wagu lagaoma, an nendawi adenggen wisane at ombasiga. ");
INSERT INTO nbq_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","Yi menda ndi menda ogarit lendagwi ako andi, nadenggen herok maduk at ombasiga ovara, an naburi ako en, avyarat wene Yesus avok ako wokbaluk, mondok wane-wane ogarit lendagwi naruk hunggu neyalok andi, nendawi adenggen ombok wisane ombasiga. ");
INSERT INTO nbq_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Nasuwe nendawi hunik, an wene ambi yukhisogon o. Hat ndugurek-ndagarek nenaswei Ala aburi ako sek okbugu dugwit, nenaswei nin huru ininis hunggut menda hadema wagu iniselok, modok iya erogo okbisaliga ako vaga, “Wa!” yukhisiga. ");
INSERT INTO nbq_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","It ako en eneyami vaga wagu lagaorik, Ala aburi o gereja homasagwima yoma inivaga mbilinggu dugwit, “Ap Nggayus endawi hunik okninipu dugwit, anderogo okbininggas o,” yiluk, yukneragao. Yukneragaoma, ap huru ininis hunggut menda nin ambi hat Nggayus hadema wagu iniselok, Ala endawi sek hombarupwak yiluk, enangge ambi dek halok, wogirigya dogomindik, lakbisaup andi sek aro. ");
INSERT INTO nbq_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","It ap andi, Keretus wene yugeregek laguluk, nagu dugwit, “It ap avyarat ombasagwidek menda enangge waup nenanggon o,” yiluk, yagaorikmu, hat yonggarinipu dogop andi, sek at yiluk, yukhisiga o, nasuwe. ");
INSERT INTO nbq_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","It ap avyarat wene Yesus avok ako ombok mbigalit lagya dogopwak yiluk, ogarit lagwi ako en, “Ninim wane-wane ogasagwi o,” yiluk, nenombarupwak yiluk, yonggarinipu dogop andi sek aro. ");
INSERT INTO nbq_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","Ala aburi nggereya andoma homasagwima ako, enake dirup maduk ambi mbalogo lakba wagagis ovara, ap Diyotereves ako en, “Enanggelekma ap ombok an nadigat dogosogon,” yiluk, endawi hogop imbita dugwit, nane wegetek. ");
INSERT INTO nbq_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","Anderogo atma, nit weyak ogagetek ninigik ovara, ap Diyotereves en ane modok weyak nenovaga bininggigima, an wagya dogomindik, at yagagi ako sigam erogo mbilinogo yukhugu neyayogon. At Diyotereves en ane weyak andi adigat nenovaga baluk, mbup yagaliga andi dek. Ata, at weyak ogasiga ambi yi: nenaswei Ala ayelomani ako wagu iniselok, at Diyotereves en eneyave woginipitek. Eke, woginipitek dugwit, it nin wogonuvup ombasagwi ako, at Diyotereves en “Wogonuvup dek o,” yiluk, yugeraliga. Yugirigya dugwit, it wogonuvup ombasagwi ako inim, enanggelekma en wibisaliga atma, des erogo yukhugu neyayogon. ");
INSERT INTO nbq_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Nasuwe nendawi hunik yi wai! It weyak ogasagwi ako hat wane-wane ogagya dogobuk. Ata, it ap sek ogasagwi ako wane-wane adigat ogarit lagya dogwen. Ap ambi sek ogasiga halok andi, avyarat Ala abut at agarik ombarup ovara, at weyak adigat ogasiga ako en andi, Ala modok dibagetek at agarik o. ");
INSERT INTO nbq_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Ap Demeterius ako, avyarat wene Yesus avok ako dibaluk, wane-wane ogarit lagya halok, Ala inim, it avakwa ovok erogo inim, iren, “Ap andi, modok sek aro,” yiluk, yagalagwi. Eke, nit huluk dek, avyarat yagalagwi hat helup atma, nit ogo, ap andi, iya erogo ogagya helagwi andi vaga, yukhisagwi o. ");
INSERT INTO nbq_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","An wene wisane yukhurup imbiti ovara, dirup mbalhirup nanggon oknitama, ");
INSERT INTO nbq_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","an hodo erogo hadema wagya dogomindik, nit mberen nenelose hubaluk, wene wane-wane mbalup hogop ombasiga o. ");
INSERT INTO nbq_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Ala hinim werekma, hendawi sek wadok dek adenggen dogogun o. Haswei ninim agarwik ako en “Wa,” yukhugu lagaorik, heyaga watbagagao. Eke, an naswei hinim agarwik ako andi, “Yohanes en adik-adik hininis erogombo ‘Wa,’ yukheragasma,” hat Nggayus en yugerano. An Yohanes en hat Nggayus ovok at yukhigis o. Nasuwe wa! ");
INSERT INTO nbq_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","At Ala en yi ogarup ndi ogarup vage mbikit ogarup wene ako, yi aro. Wene yi nit at ayelomani ninelup okbininapwak yiluk, Ala en nenowa inis ombok denogo mendok okbagagi Yesus Keretus ako yugugu lagagimu, aren vagalogo yukneraliga yi aro. Ala en Yesus Keretus yugugu lagagimu, Ala ayeloman an Yohanes ako nelup okbanupwak yiluk, Yesus Keretus en at ayonggo malaikat ambi wombaba wagagi. ");
INSERT INTO nbq_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","Eke, malaikat wombaba wagagi ako en, an yuknugu lagagimu, Ala wene Yesus Keretus en vagalogo yuknugu hagagis ako ovok erogo mbilinogo dirup mbanggigis yi aro. ");
INSERT INTO nbq_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","Anderogo atma, wene yi ogarup ako mondok horok vanggo yagarikmu, it avakwa en hivis ogarup wene dirup mbalek yi, bikhegek mbilinogo yugurugwi-selok, Ala en adenggen enovaga bugu dogosogon. Eke, yugurugwi inigik, enaruk hobaluk, des erogo wugwi-selok, it ogo Ala en adenggen enovaga bugu dogosogon o. ");
INSERT INTO nbq_vpl VALUES ("RV1_4","096_1_4","REV","1","4","5","Wa. An Yohanes en hit Yesus aburi o Propinsi Asia gereja 7 vaga homarisagwi ako, wa yukheraliga o. Nenasin Ala inim, Averiniki inim, At Yesus Keretus inim, it ovok erogo enendawi henabwa en okbugugwis, eke, henendawi ugun seyalek wadok dek adenggen dogovovok yiluk, okbugugwis, ogagu dogopwak o. At Ala andi, endak welagagi, yogak agarik, hivis dogosogon mondok itok agarik. Eke, Ala Averiniki andi, at andogon adem 7 ogasiga ako Ala ane yugeraligama avema agarik. At Yesus Keretus andi, avyarat wene adigat mondok des erogo vagalogo yugeraliga menda araro. At Yesus Keretus ako hambuluk lendagwi enanggelekma en at endak mendek iri lagagirik, yogak it ap wen vaga menda enasini ininis werek menda ako enasin inis ombok agarik o. At nenabwa en endawi hunik okninipigi. At amuya vaga nenomaluk visilogo bininggigi. ");
INSERT INTO nbq_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","Eke, nit avakwa at avema dugwit, imam-imam hak at asin Ala ake ogagu dogoguluk, denogo bininggigi. Anderogo okbininggigirikmu, at anye wisane atma, nit yi ovok erogo at inis adigat siyabagwi, at ane adigat hunggwis, mondok-mondok ogagu dogosogom o, yiluk, amin! ");
INSERT INTO nbq_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","Dibagu dogones! At Yesus hena anggelekma wagya halok, it avakwa o wen vaga agarwik ininis unggul adik-adik At watugwa ako menda inim ovok erogo enadik-enadik en inil hugu dogomundik, yup yarusogom atma, avyarat yukheraliga o. Amin. ");
INSERT INTO nbq_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","Endak welagagi, yogak agarik, hivis dogosogon At anye adigat agarik nenasin Ala en iri dugwit, “O muk endak erogo welagagis adem Alpa inim, eke, hivis atok vaga mondok dogop Omega inim, andi an aro,” yiluk, yagaliga o. ");
INSERT INTO nbq_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","Hit anggin-mbanggin henovaga bugugu inigik ovara, “Ala avema bininggigima, sek aro,” yiluk, Yesus hinim hunik henendawi wadok dek dugwit, welagwi. An henaswe Yohanes ogo, anderogo wane-wane anggin-mbanggin okbanunggu inigik, wigya lagagis. Andi, anen Ala wene yugirigya, eke, Yesus wene iri lagagi ako vagalogo yugirigya, ogasiga ako vaga, is yanggadek ilim is enggema o inis Vatmos bani wagagwa andoma welagagis. ");
INSERT INTO nbq_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","Andoma werekma, o samban vaga Ala Averiniki nendawima des iri lagagimu, nambukmu en ane ombok ogasiga trompet ako ovagak ane ombok iri naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","Hunggu neyagek, yuknugu dugwit, “Vivis ogarup inuk hugu neyagek, mbuku virik-verek ogarek vaga dirup mbalup. Dirup mbanggya dogomindik, it Ala aburi o Epesus inim, Simirana inim, Veragamus inim, Siyatira inim, Saridis inim, Viladelipiya inim, Laodokiya inim, gereja 7 vaga homarisagwi ako ovok erogo bikhapwak yiluk, lakbain o,” yiluk, yuknugu hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","Naruk hunggu lagirik, “Sa en yuknisiga,” yiluk, eyave nil haigen yiluk, neloke endenogo bikhigya lagirik, hali yevedogo bagek 7 mbusi emas vaga ogovak higirik higi. ");
INSERT INTO nbq_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","Eke, hali yevedogo bagek 7 ogovak higirik ako anggelekma ilim andenam avakwa enelose ovagak ambi werek higi. Ap ako andi, asum adup unggumu en isokmu hudi yirik, eke mbup nggetalek mbusi emas menda ogo eyave vaga yirik higi. ");
INSERT INTO nbq_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","At iris andi, swa yanggwi iris mudu ako ovagak higi. At il andi, hali abya wuluk yagaliga ovagak higi. ");
INSERT INTO nbq_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","Eke, at isok andi, mbusi tembaga hali hunikmu mabagwi iniselok, mudu dede erogo yiklagarikmu, amumulip wisane ogasiga hak, isok anderogo at amumulip wisane ogagya higi. At ane andi, is satut ane wisane yagaliga ovagak, At ane anderogo at iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","At inggis amotkan vaga dadiwap 7 vagogo agarik higi. Mbusinggarep erasul ovagak venak-venak ovat marek elagapma sisik erek, eke, At elose andi, mo ovagak, amumulip ogagya higi o. ");
INSERT INTO nbq_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","At eyave anderogo ogarek nil higya lagirik, an Yohanes nggorak ovagak at avema ndun yi lagi. Ndun yi lagya lagima, At inggis amotkan vaga vaknita dugwit, “Endak erogo welagagis inim, hivis atok vaga mondok dogop inim, andi An atma, halon ombarubuk. ");
INSERT INTO nbq_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","Niluk nitok agirik An aro. Yokneyan! An endak hombagagis ovara, yogak andi, niluk modok-modok agirik o. Hambisagwi inim, Hambuluk Lendagwima inim, iperen An nadigat vagogo dugwit, sup huririsagwi hunsi vagogo agirik o. ");
INSERT INTO nbq_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","“Anderogo atma, an hali yevedogo bagek 7 ogovak higirik ako anggelekma ogarit lagya hil hegen inim, yogak ogasiga hil haliga inim, eke, hivis oklarup hil hayogon inim, ovok erogo dirup warogo bagya dogwen o. ");
INSERT INTO nbq_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","Dadiwap 7 ninggis amotkan vaga hegen ako inim, eke, hali yevedogo bagek 7 mbusi emas vaga ogovak higirik hegen ako inim, andi wene hwilago ovagak werekma, adem des erogo yukhisogon: Dadiwap 7 ako andi, it malaikat 7 An naburi gereja 7 vaga homarisagwi enengge agarwik ako at inigin. Eke, hali yevedogo bagek 7 ako andi, An naburi gereja 7 vaga homarisagwima ako at inigin o,” yiluk, yuknugu higi o. ");
INSERT INTO nbq_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","Yuknugu higya lagirik, werekma, At Yesus dadiwap 7 inggis amotkan vaga vagago agarik ako en ambi inim yuknigas. Yuknugu dugwit, “An wene ambi yukhisogon. Yukhugu dogomima, At malaikat An naburi o Epesus homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbanok yiluk, yukhisogon o. “An yi, ninggis amotkan vaga dadiwap 7 vagogo dugwit, hali yevedogo bagek mbusi emas vaga ogovak higirik 7 anggelekma landiga An ako en, it An naburi o Epesus menda wene yi yugeraliga: ");
INSERT INTO nbq_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","Hit An naburi o Epesus ogarit lendagwi ako an nelup aro. Hit an namusek wagu dugwit, henanyedek okhinipu hegek hekbagetek mondok hunik adigat ogarit lagwi, it ap weyak menda nit nenanggelekma yoma dogop mondok dek o, yiluk, henanggon umbutwi, ogarit lendagwi ako andi, an nilup aro. Eke, it ap nin lakbigik menda dek ovara, wagu lagaorik, ‘Ala en lakbinini waga o,’ yiluk, yugurugwi selok, hiren enavut mbabaluk, ‘Yi huluk yagan wagao,’ yiluk, mbo bisalagwi ako andi, an nilup aro. ");
INSERT INTO nbq_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","Eke, An ninis adigat yi awi ndi awi wigak yumwak yiluk, ogarit lagwi vaga anggin-mbanggin okbigigik lagu-sigik, henendawi wadok dek hora yiluk wugu dugwit, sadida okhinipu hegek mondok hunik adigat ogarit lendagwi ako andi, An nelup aro. ");
INSERT INTO nbq_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","Nilup arovara, weyak ambi ogagu hinigis ako andi, yukherayogon. Endak hit nendawi-hendawi hunik wisane dugwit okbanunggu lagagup ovara, yogak andi, ninim hunik dek mbo banunggwis hinugu lagirik, yukhirigi o. ");
INSERT INTO nbq_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","Hit endak An ninim hunik dugwit, henendawi adenggen vaga nane musek lagu lagagup ako hekbaluk, yogak mondok adik ogarit lendagwi. Hit adik ogarit lendagwi ako, henasam helok, henomaduk mbo bagu dogomundik, yungguliluk heneyami vaga wakluk, endak hit nendawi-hendawi hunik wisane dugwit okbanunggu lagagup ako wane-wane ogarit lagu dogones. Hit henasam hegetek henomaduk mbo bagatek hiniselok andi, An wagya dogomindik, hali yevedogo bagek mbusi emas vaga ogovak higirik hit menda ako, avoloma en nggigilogo wibayogon. ");
INSERT INTO nbq_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","Eke, ambi sek ogagu hinigis ako andi, yi: It ap Nikolaus ane musek nagu dugwit, ogarit lendagwi andi, An nanggon adigat ombasiga ako, hit wane-wane henanggon ombasagwi ako andi sek aro. ");
INSERT INTO nbq_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","Henaruk werek a dek a? Henaruk werek halok, Ala Averiniki en An naburi yi awi ndi awi homasagwima yugeraliga ako andi, des erogo at hunggu dogones. Eke, hit ap sani en An nane mbo bagetek mondok henendawi wadok dek vagago dugwit des erogo musek lagu hiniselok, yo enggen avakwa iniluk oginivisiga menda Ala eyavupmu agarik ako, ‘It naup sek at,’ yugerayogon o, yiluk, wene yi yigi ako ovok erogo at malaikat An naburi o Epesus homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbain o,” yiluk, yuknigas. ");
INSERT INTO nbq_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","Anderogo yuknugu lagarik, ambi yuknugu dugwit, “At malaikat An naburi o Simirana homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbanok yiluk, yukhisogon o. “An endak erogo welagagis, hivis atok vaga mondok dogosogon, eke, hombagagis ovara, niluk akluk agirik yi, wene yi it An naburi o Simirana menda yugeraliga: ");
INSERT INTO nbq_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","Hit An naburi o Simirana ogarit lendagwi ako, An nelup aro. Hit anggin-mbanggin henovaga agya dugwit, hininggis dek asiga ovara, eloma menda vaga hininggis werek ovagak agipik ako An nelup aro. Eke, it Yakuri dek menda Sile ogasiga wane-wane ogwaruguluk homarisagwi ako menda en, we un huluk, ‘Nit Yakuri menda aro,’ yiluk, An naburi o Simirana menda enane wiyiknom-weyaknom erogo bigigalagwi andi, nelup adigat agirik. ");
INSERT INTO nbq_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","At Sile en hit henavut mbaligiluk, avakwa enendawi nggaganggu lagagimu, hit nin heda marogo mabisalagwima mabugugwis, eke nogo 10 vaga anggin-mbanggin okbigigasogom ovara, henalon habuk. Anggin-mbanggin anderogo okbugugu inigik, hiren ‘Hambup hudi arup sek aro,’ yiluk, An nane mondok vagago dogosogom halok andi, mondok-mondok hiniluk dogop menda nggudit-nggudit mendarek hak onggo yikbigigayogon o. ");
INSERT INTO nbq_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","Henaruk werek a dek a? Henaruk werek halok, Ala Averiniki en An naburi yi awi ndi awi homasagwima yugeraliga ako andi, des erogo at hunggu dogones. Eke, hit ap sani en anggin-mbanggin ako menda henovaga agya hegek ovara, An nane mbo bagetek mondok henendawi wadok dek vagago dugwit des erogo musek lagu hiniselok, ndugwis mberen vaga hambusogom dek o, yiluk, wene yi yigi ako ovok erogo at malaikat An naburi o Simirana homarisagwi enengge agarik ako en aburi yugerapwak yiluk dirup warogo lakbain o,” yiluk, yuknigas. ");
INSERT INTO nbq_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","Yuknugu lagarik, ambi yuknugu dugwit, “At malaikat An naburi o Veragamus homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbanok yiluk, yukhisogon o. “An mbusinggarep erasul ovagak venak-venak ovat marek vagago agirik ako en, it An naburi o Veragamus menda wene yi yugeraliga: ");
INSERT INTO nbq_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","Hit at Sile anye werek dugwit o vagago agarikmu agipik andi an nelup. Sile vagago agarikmu akoma agipik ovara hegek, An nane wogogup ako mondok vagago agipik. Eke, An nabut ambi nane des erogo wokbaluk hutun-howam yugeregek lagya lagagi inis Andipas ako, watugwa. Hit henanggelekma Sile agarikmu henawi kota andoma at watugwa. Watu lagagwama, hit henendawi avyarat ombakluk, An nane wogogup ako, ‘Musek laup nenanggon o,’ yiluk, yup ovara, dek o. ‘Nit nenowa Keretus atma, at ane wigo ako andi, mondok at vagogo dogosogom o,’ yiluk, yugwi hinigis o. ");
INSERT INTO nbq_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","Anderogo at yugwi hinigis ovara, wene ambi yipi-nipi ogagu hinigis ako andi, yukheraliga. O endak erogo en at Mbileyam en it avakwa Iserali menda Ala wene mbo baluk madis anggom warek nunggwi, eke, akwa we un ugun-ugun oginivit lagwi, ogagu dogopwak yiluk, at Mbileyam en ap Mbalak mamulogogi. Mamulugu lagagimu, ap Mbalak en Iserali menda mamuleragagi. Wene ako, hit An naburi o Veragamus agipik henanggelekma it ambetap hinim homarisagwi nin en wene ako musek lendagwi. ");
INSERT INTO nbq_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","Anderogo ndatak, hit nin en at Nikolaus ane musek lendagwi. ");
INSERT INTO nbq_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","Anderogo ogagwi hinigirikmu, henasam helok, hit weyak ogasagwi ako andi, mbo bagu dogones o. Mbo bagetek hiniselok andi, An hodo erogo wagya dogomindik, mbusinggarep erasul An nelagapma agarik yi ako vaga hiniri wambu wasogon o. ");
INSERT INTO nbq_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","Henaruk werek a dek a? Henaruk werek halok, Ala Averiniki en An naburi yi awi ndi awi homasagwima yugeraliga ako andi, des erogo at hunggu dogones. Hit ap sani en An nane mbo bagetek mondok henendawi wadok dek vagago dugwit des erogo musek lagu hiniselok, an onggo mberen wokherayogon. Ambi andi, erom mbogot vaga menda inis mana hwilago agarik ako wokherayogon. Ambi andi, hininis swi salogo helep mudu yanggwi hak ako vaga dirup warogo wokherayogon. Hininis warek ako andi, it nin andi inilup asogombuk, ovara, it ininis warek wogerayogon ako adigat inilup asogon, yiluk, wene yi yigi ako ovok erogo at malaikat Ala aburi o Veragamus homarisagwi enengge agarik ako en aburi yugerapwak yiluk dirup warogo lakbain.” ");
INSERT INTO nbq_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","Yuknugu lagarik, ambi yuknugu dugwit, “At malaikat An naburi o Siyatira homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbanok yiluk, yukhisogon o. “An Ala Abut, nil hali abya wuluk yagaliga ovagak dugwit, an nisok andi, mbusi tembaga amumulip wisane ogasiga hak, nisok anderogo wane-wane wisane ogasiga ako en, it An naburi o Siyatira menda wene yi yugeraliga: ");
INSERT INTO nbq_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","Hit An naburi o Siyatira ogarit lendagwi ako An nelup aro. Hit avakwa henendawi hunik oginipwis, avyarat ombakluk henendawi novaga vanggabagwi, henaswei yonggar-inigik nagwis, anggin-mbanggin okbugugu hinigik, henendawi wadok dek dugwit wugwi, ogarit lagwi ako ovok nelup aro. Eke, endak herok maduk at ogagu lagagup ovara, yogak ombok erogo ogarit lagwi andi, nelup adigat ovara, ");
INSERT INTO nbq_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","maduk ambi yipi-nipi ogagu hinigirikmu, yukheraliga. Hwa Isebel ako en ane huluk iri dugwit, ‘An navi, Ala Averiniki en yuknugu hegek Ala wene yukheraliga menda aro,’ yiluk, yukheraliga ovara, hit mbereregetek, ‘Sek aro,’ yiluk hetbagwi hinigirikmu, modok an nanggon oknita halok yukheraliga. Hwa ako en an nayelomani eneyave wisane nomaliniviluk lagya dugwit, akwa we ugun-ugun oginivit lagwi, eke, madis anggom warek nunggwi, ogarit lagu dogopwak yiluk, mamuleraliga ako andi, modok an nanggon aro. ");
INSERT INTO nbq_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","At hwa andi, asam helok, omaluk mbo baup yiluk, hekbagagis ovara, aren ‘An okneraup, embetek lagya ako hekbaup nanggon o,’ yiluk, ogarit landiga. ");
INSERT INTO nbq_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","Ogarit lagyama, edup en yimbilok-mendalok iri dogopwak yiluk, an anggin ombok ovaga okbayogon. Okbagya dugwit, it nin hwa andi inim weyak ogarit lendagwi ako ogo, enasam helok enomaduk mbo bagatek iniselok, it anderogo at anggin mondok durik-marek erogo enovaga ndan okbugu neyasogom. ");
INSERT INTO nbq_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","Hwa andi, eyagi at ane welagwi menda ako it ovok erogo enarit lagya neyasogom. Enarit lagya neyalok, it An naburi yi awi ndi awi homasagwima ako ovok en, ‘Nit nenendawi ombasagwi inim, nenendawi hobaluk ogarit lagwi inim, ovok erogo dibininiluk onggo wane-wane wokneraliga Yesus andi, arat higyo o,’ yiluk, An neyave enelup arusogom o. ");
INSERT INTO nbq_vpl VALUES ("RV2_24","096_2_24","REV","2","24","24","Eke, hit nin o Siyatira agipik ako, hwa ako ane inim, Sile ogasiga mbauk hwilago yagalagwi wene inim, hit musek lagatek hekbagagup andi, An wene ambi yi yukheraliga: ‘Anen anggin menda ambi henovaga bigigaup embetetek ovara, ");
INSERT INTO nbq_vpl VALUES ("RV2_25","096_2_25","REV","2","25","25","An warup hudi andi hit An nane avyarat ombakluk wogogup ako mondok wadok dek vagago dogones,’ yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("RV2_26","096_2_26","REV","2","26","27","Hit ap sani en An nane mbo bagetek henendawi modok wadok dek vagogo dugwit, An ogarup ombasiga ako ogarit lagu-sigik, o hivis ari wagya halok, An yerogo okbisayogon: An nasin en avakwa ininis unggul dombok navema bisiluk An enasin dogogiluk, mondok okbaninggigi ako ndatak, an okbisayogon. It anderogo at, yi avakwa ndi avakwa enavema bisiluk, it enasini dogopwak yiluk, mondok okbisayogon o. O muk erogo Ala en Yesus avok iri dugwit, ‘Mbusi manggen bogalek inggimu dugwit, ane anye vaga wene yugirigya, Eke, yi menda ndi menda wen nggabok vaga ogovak higirik ako, lekhelok savulbagusim yuvulik-nggalalek yagaliga hak, ogarogo bugu, ogarisogon o,’ yiluk, yagagi ako wane-wane an okbaninggigi, eke it anderogo at, yi avakwa ndi avakwa enavema bisiluk, enane enanye vaga yugurugu dogosogom o. ");
INSERT INTO nbq_vpl VALUES ("RV2_28","096_2_28","REV","2","28","28","Eke, it Ala wene modok wadok dek vagogo werekma, An wagya dogomindik, o yanggo yigiluk ogagya hegek wap amumulip ogasiga ako at wogora wasogon o. ");
INSERT INTO nbq_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","Henaruk werek a dek a? Henaruk werek halok, Ala Averiniki en An naburi yi awi ndi awi homasagwima yugeraliga ako andi, des erogo at hunggu dogones o, yiluk, wene yigi ako ovok erogo at malaikat An naburi o Siyatira homarisagwi enengge agarik ako en aburi yugerapwak yiluk dirup warogo lakbain.” ");
INSERT INTO nbq_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","Yuknugu lagarik, ambi yuknugu dugwit, “At malaikat An naburi o Saridis homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbanok yiluk, yukhisogon o. “An dadiwap 7 ninggimu vagogo dugwit, Ala Averiniki ogasiga menda andogon adem 7 ako ogo vagago agirik yi ako en, it an aburi o Saridis menda wene yi yugeraliga: Hit An naburi o Saridis ogarit lendagwi ako An nelup aro. Avakwa en henavok yugu dugwit, ‘Ap iluk anye landiga hak, it Yesus aburi gereja andi vaga homarisagwi ako modok enanye at agarwik inigup o,’ yiluk, yagalagwi ovara, hit anderogo ogasagwi dek andi an nelup. Hit andi, an namusek lagu dugwit, modok henanyedek henendawi nggorak ovagak sek ogasagwidek weyak ogasagwi andi, An nelup. ");
INSERT INTO nbq_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","Hit ogarit lendagwi ako An nasin Ala en, ‘Sek at ogasagwi,’ henembetetekma, hit modok henanyedek hambup ovagak okhinivisiga ako hodo erogo iniluk akluk, Ala wene maduk musek lagu hinigis ako ombok erogo musek lagu dogovovok yiluk, henanye okhedomanes. ");
INSERT INTO nbq_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","It endak sek wene an navok ako mamulhirugwi inigik, henaruk hobaluk wagagup ako henendawi wenggeles. Henendawi wenggebaluk, henomaduk mbo bagu dogomundik, wene hunggugup ako at des erogo vagogo dogovovok yiluk yukheraliga. Eke, hiren hiniluk erogo henanye okhedegetek halok andi, ap onggop wagiluk wandiga hak, An hininggut hinigik, supuk erogo hit Saridis menda anggin okbigigagiluk henadema wasogon o. ");
INSERT INTO nbq_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","Anderogo ovara, hit Saridis menda nin ambukumat henasum mudis okhedegetek sek adigat ogarit nagwis atma, ‘Hit sek aro,’ yiluk, henasum mudu eyave yirik ninim nagu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","Eke, hit sani en An nane mbo bagetek modok henendawi wadok dek vagogo dugwit, des erogo musek lagu hiniselok, An wagya dogomindik, avakwa modok-modok iniluk dogop ininis mbuku vaga dirup mbalek agarik ako, An horisogon dek. It anderogo at enasum modok mudu yikbugu dogomindik, An nasin inim, At ayonggo malaikat inim, inil vaga, ‘It ap yi, An naori aro,’ yiluk, yugerayogon. ");
INSERT INTO nbq_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","Henaruk werek a dek a? Henaruk werek halok, Ala Averiniki en An naburi yi awi ndi awi homasagwima yugeraliga ako andi, des erogo at hunggu dogones. Wene yi yigi ako ovok erogo at malaikat An naburi o Epesus homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbain o,” yiluk, yuknigas. ");
INSERT INTO nbq_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","Yuknugu lagarik, wene ambi yuknugu dugwit, “At malaikat An naburi o Viladelipiya homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbanok yiluk, yukhisogon o. “An huluk yagaligadek avyarat adigat yagaliga Ala ake nadik denek agirik yi ako en, Daut agunci ako vagogo dugwit, sup hurutu neyalok avakwa en larup meyan, eke, latya neyalok avakwa en hururup meyan, an nadigat vagago agirik yi ako en, it An naburi o Viladelipiya menda wene yi yugeraliga: ");
INSERT INTO nbq_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","Hit An naburi o Viladelipiya ogarit lendagwi ako An nelup aro. Hit An ninis weyak erogo bagatek, sek erogo vagogo dugwit, henanye maduk agarik ako vaga An nane musek lendagwi. Anderogo atma, hit ambi ogagu dogopwak yiluk, sup hurugo bigigis ako, avakwa en larogo bigigaup modok dek aro. ");
INSERT INTO nbq_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","It ap Sile ogasiga menda wane-wane ogagu dogoguluk, homasagwi ako, it Yakuri menda dek hegek we un huluk, ‘Nit Yakuri menda aro,’ yiluk, yagalagwi ako, an sovalogo bugu neyasogom. Iren, hit henadema ‘Ala avyarat endawi hunik okhinipu higyo,’ yiluk, hit An naburi o Viladelipiya menda henavema seve yi warupwak yiluk, okbugu neyasogom o. ");
INSERT INTO nbq_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","Eke, ‘Hit henendawi wadok dek horaik dugwit ogagu dogones o,’ yiluk, yukheragagis ako, hobaluk des erogo at ogasagwima, hivis yi avakwa ndi avakwa wen vaga agarwik ovok erogo enavut mbalik en yiluk, anggin-mbanggin enovaga bisa warup hudi ako vaga, hit An naburi andi, henovaga arugwi en yiluk, An en heneyaga dogosogon. ");
INSERT INTO nbq_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","An vage mbikit warisogon o. Eke, wagya dogomindik, hit An nane avyarat ombakluk wagagup ako des erogo vagogo hiniselok, nggudit-nggudit mendarek ako menda yikbigiga warisogonma, avakwa en wugu isawen, dibaluk, suwam watu dogones. ");
INSERT INTO nbq_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","It sani en An nane mbo bagetek modok enendawi wadok dek vagogo dugwit, des erogo musek lagu iniselok, An wagya dogomindik, o anye dogopwak yiluk, sirup ilim ngguvulisagwi hak, it avakwa andi, An nasin Ala awi valekma anderogo at mondok okbisayogon. Okbisiluk, it Ala aburi yedok inisapwak yiluk, An nasin Ala inis inim, An nasin Ala awi valek o kota Yerusalem swi menda nasin Ala mbogot vaga en wombaba wasogon ako inis inim, eke, An ninis swi salek ako inim, enadik-enadik enovaga dirup mbalogo bisayogon. Bisayogon werekma, it hivis andoma en wulusogon lasogom modok dek o. ");
INSERT INTO nbq_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","Henaruk werek a dek a? Henaruk werek halok, Ala Averiniki en An naburi yi awi ndi awi homasagwima yugeraliga ako andi, des erogo at hunggu dogones. Wene yi yigi ako ovok erogo at malaikat An naburi o Viladelipiya homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbain o,” yiluk, yuknigas. ");
INSERT INTO nbq_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","Yuknugu lagarik, ambi yuknugu dugwit, “At malaikat An naburi o Laodokiya homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbanok yiluk, yukhisogon o. “At Ala en wen-mbogot werek ogarup imbitya hegek, wakhagagis adem An atma, avyarat wene adigat modok des erogo avyarat vagalogo yugeraliga An Amin yi ako en, it An naburi o Laodokiya menda wene yi yugeraliga: ");
INSERT INTO nbq_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","Hit An naburi o Laodokiya ogarit lendagwi ako An nelup aro. Henendawi hol dek edup erogo dek we un is saragas nudik ovagak agipik hinigirikmu, henendawi edup dogop ombasagwi halok, edup at dogop, eke, henendawi hol dogop ombasagwi halok, hol at dogop, ogagu dogop sek at ombasiga. ");
INSERT INTO nbq_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","Ogagu dogop sek at ombasiga ovara, henendawi edup dek, hol dek, we un is saragas nudik ovagak agipikma, is aidek halok enelagapma en suvurogo beyakhelagwi andi hak, hit ako an nelagapma en suvurogo beyakhinisaup ombasiga o. ");
INSERT INTO nbq_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","Hit ako andi, henendawi weyak, hininggis dek, hinil mbuk, henagap mbedan, henanggadi werek, anderogo hinisaliga ovara, dibagatek dugwit, hiren, ‘Nininggis mondok werek, nenangge dek ambi andi dek, ovok erogo werek,’ yiluk, yagalagwima, ");
INSERT INTO nbq_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","hit sek erogo ambi inim ogagu dogovovok yiluk yukheraliga. Hit henagap mbedan nagwis atma avakwa en inil hinugu-selok, henanggadi agu-sawen, henasum mudu yanggwi hak yikhedaguluk an nadema hunhedavovok yiluk, yukheraliga. Hinil mbuk ako sek akluk yi menda ndi menda hinil hapwak yiluk, amburup hinil mu baup an nadema hunhedavovok yiluk, yukheraliga. Eke, eyave menda vaga hininggis werek arovovok yiluk, An nayoparip mbusi emas eyave hali vaga werago ako menda inim an nadema onggo hunhedavovok yiluk, yukheraliga. ");
INSERT INTO nbq_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","It avakwa An nendawi hunik oginivisiga ako andi, enaruk watya, enendawi wenggelupwak yiluk yo yawi inita, ogasigama, enasam helok, enomaduk nggatuk erogo mbo bapwak. ");
INSERT INTO nbq_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","An sup mbanggutmu mendek dugwit, hit henendawima an sup nggolen-nggolen ogasiga ako dibas. Ap ambi An sup nggolen-nggolen ogagya ako, aruk hobaluk, endawima sup hutbigya halok, An adema nunggigya dogomindik, niperen nenendawi ambiat dambulik naswe-haswe dugwit, erom nunggu dogosogom o. ");
INSERT INTO nbq_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","Eke, An nasin yuknogogi ako mbo bagatek modok wotok erogo okbaluk, At wene yugeraligama niperen horaik agurik. Anderogo wane-wane, it sani en An nane mbo bagetek modok enendawi wadok dek vagogo dugwit, des erogo musek lagu iniselok, it ogo An nane yugeraligama ninim horaik dogoguluk, ‘Nadema omanes,’ yiluk, yugerayogon. ");
INSERT INTO nbq_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","Henaruk werek a dek a? Henaruk werek halok, Ala Averiniki en An naburi yi awi ndi awi homasagwima yugeraliga ako andi, des erogo at hunggu dogones. Wene yi yigi ako ovok erogo at malaikat An naburi o Laodokiya homarisagwi enengge agarik ako en aburi yugerapwak yiluk, dirup warogo lakbain o,” yiluk, yuknigas. ");
INSERT INTO nbq_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","Andi yuknugu lagama, nabi ambi higya dugwit, o mbogot vaga andoma sup mbanggut ambi hurik higi. Higya neyagek, akoma en ap ambi en ane ombok ogasiga trompet ako hak, ane ombok endak yuknugu hunggis ako ambi inim yuknugu dugwit, “Yogak ogarup hegen ako okbaluk, hivis ogarup ako yukhisogon yiluk dagama o,” yiluk, yuknigas. ");
INSERT INTO nbq_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","Ao at andenam yuknuguma, Ala Averiniki nendawima dis iri lagarik, woknombolok bani anggas higi. Bani anggas werekma, mbogot vaga andoma wene yugeraligama kursi sek vaga, ap ambi horaik werek higi. ");
INSERT INTO nbq_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","O awiya amumulip herek damok ogasiga hak, ap horaik agarik ako andi, helep onggo ombok elose mondok sekyaspis ovagak, helep sardis ovagak, ogarek werek higi. Eke, at horaik agarikmu yuwaru mondok abinak helep zamrud ovagak yilin-walin werek higi. ");
INSERT INTO nbq_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","Werekma, it mbogot vaga agarwik enanggok ap ombok-ombok eneyave 24 en At wene yugeraliga menda ako ilim hegek, it wene yugerelagwima kursi sek ako vaga 24 walinogo horaik dugwit, enasum yanggwi hak yirik, eke, nggudit-nggudit mbusi emas vaga enunggul vaga yirik, okbaluk inigis. ");
INSERT INTO nbq_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","At wene yugeraligama andoma en o bigavok yovalevet higya hegek, unggulane yagan wulu wagya higi. Eke, wene yugeraligama elosema vikit andenam yunda 7 yevedek werek higi. Yunda 7 yevedek ako andi, Ala Averiniki andogon adem 7 ogasiga ako arat. ");
INSERT INTO nbq_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","Wene yugeraligama kursi sek avema andenam kaca yendela modok eyave obak inamut ombok yanggadek laut ovagak ovara, elose wukagak mondok awiya ogasiga ovagak higi. Eke, o andenam avakwa en iniselagwidek menda eneyave 4 enavilis enambot enombandu venak-venak andoma inil yago wisane werekma, wene yugeraligama ilim andenam walinek werek inigis. ");
INSERT INTO nbq_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","Eneyave ako andi, ambi yangge singga elose ovagak, ambi sapi nggulok elose ovagak, ambi andi, elose avakwa enelose ovagak, eke, ambi andi, swa eram mbongga amik wigalek ako ovagak, werek inigis. ");
INSERT INTO nbq_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","Avakwa en iniselagwidek menda eneyave 4 ako andi, enadik-enadik enamik 6 werek atma, eneyave inim enamik avema andenam inim ovok at inil yago werek inigis. It ako mbup yegetek hutun-howam enane yugu dugwit, “Nenasin Ala hanye adigat agindik, Hat mondok sek adik denek, Muk welagagin, Yogak agindik, Hivis dogogun, Hat mondok sek adik denek aro,” yiluk, yugigik adigat ogagu inigis. ");
INSERT INTO nbq_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","Ogagu dugwit, At modok-modok iluk itok agarik wene yugeraligama horaik agarik ako, “Wa,” yiluk, inis siyabagwi, hai watwis, ogagu inigis. ");
INSERT INTO nbq_vpl VALUES ("RV4_10","096_4_10","REV","4","10","11","Ogagu-sigik, it enanggok ap ombok-ombok eneyave 24 ako en At modok-modok iluk itok agarik wene yugeraligama kursi sek vaga horaik agarik ako, avema seve yiluk, siyabagek ogagu inigis. Siyabagek ogagu dugwit, “Nenasin Ala wa. Hat hendawi wenggebaluk, yi menda ndi menda ovok erogo werek ogarisogon o, yiluk, ogagagin. Hat hadigat mondok eve ombok atma, Yi avakwa ndi avakwa ovok Hat havema seve yiluk, Hinis siyabagagwi, Hai watwis, ogagu dogopwak o,” yiluk, nggudit-nggudit mendarek yirik ako, nggolalogo At avema ba wagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","Andi ogasagwi inugu lagirik, ambi higya dugwit, mbuku virik-verek ogarek ambi adup venak-venak dirup mbalekma, At wene yugeraligama kursi sek vaga horaik agarik ako inggis amotkan vagogo agarik higi. Eke, mbuku virik-verek vaga dirup warek ako, inil hagup en yiluk, lilin amburup ako vaga ambi heda mabagek ambi heda mabagek, ogarit heda 7 vaga marek ogarek higi. ");
INSERT INTO nbq_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","Higya neyagek, malaikat anye werek ambi en ane ombok iri dugwit, “Mbuku mbalek virik-verek ogarek yi, ap ambi sa en heda visilogo bikhaup sek o?” ");
INSERT INTO nbq_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","Iri lagama, mbogot vaga inim, wen vaga inim, wen avema inim, avakwa wisane at agarwik ovara, it ambi en heda visilogo bikha warup sek inigitek atma, ambi bikha wagya hegetek o. ");
INSERT INTO nbq_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","Ap ambi visilogo bikha warup sek inigitek atma, visilogo bikha wagetek at welagama, “Nit ap ovok weyak ogasagwi mendama, nit visilogo bikhaup meyan at higi o,” yiluk, nendawi modok wakhidigya dugwit, yup ombok yagi. ");
INSERT INTO nbq_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","Ao yup yigya lagima, mbogot vaga agarwik enanggok ap ombok-ombok ako ambi en an yuknugu dugwit, “Yup yarup moga o. Yo ambi aruknuk dagasiga andi hak, inis unggul Yekura en Daut ombao yangge singga ovagak endaklagagi ako, ayegen anye agagirikmu, aren mbuku virik-verek heda 7 marek ako, visilogo bikhaup sek atma, bikha wigya hayogon o.” ");
INSERT INTO nbq_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","Yuknugu lagama, enanggok ap ombok-ombok 24 ako inim, avakwa en iniselagwidek menda eneyave 4 ako inim, wene yugeraligama andenam walinek inigik, Ndomba Eyak ambi eyave warek hak ovara, it enanggelekma mendek higi. Wam Ndomba Eyak ako andi, aruk adema aik 7, eke, il 7, agarik higi. Aruk adema aik 7 inim, il 7 inim, ako andi, Ala Averiniki andogon adem 7 ogasiga ako o wen vaga yi awi ndi awi lakbisaliga ako aro. ");
INSERT INTO nbq_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","Andi en, an Yohanes en higya dugwit, Ndomba Eyak ako wagya lagarik, wene yugeraligama kursi sek vaga horaik mbuku inggis amotkan vagogo agarik ako inggimu en wigya higi. ");
INSERT INTO nbq_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","Wigya lagama, it avakwa en iniselagwidek menda eneyave 4 ako inim, mbogot vaga agarwik enanggok ap ombok-ombok eneyave 24 ako inim, Ndomba Eyak ako avema seve yagagwa. Seve yiluk, it enanggok ap ombok-ombok ako en nggindar inim, sogolowak mbusi emas vaga mendarek amben eyave sek menda nudik ako inim, enadik-enadik vagogo dugwit, ndawi vaga yugugwis inigis o. Amben eyave sek menda sogolowak mbusi emas vaga nudik ako andi, it Ala aburi At ake denek samban ogasagwi enane nudik ovagak higi. ");
INSERT INTO nbq_vpl VALUES ("RV5_9","096_5_9","REV","5","9","9","It avakwa en iniselagwidek menda eneyave 4 ako inim, mbogot vaga agarwik enanggok ap ombok-ombok eneyave 24 ako inim, ndawi swi menda watugwa. Ndawi swi menda watu dugwit, ndawi eyave yi watao: “It avakwa ininis unggul adik-adik inim, enane adik-adik inim, enagamut adik-adik inim, Enanggelekma en ambitap nggigilogo Ala aburi arupwak yiluk, Hat hatu lagagwama, hamwiya vaga enonggo mbanggigin andi vaga mbuku virik-verek heda marek ako, haren wogogo wigya dogomindik visilup sek aro. ");
INSERT INTO nbq_vpl VALUES ("RV5_10","096_5_10","REV","5","10","10","It avakwa ininis unggul adik-adik enanggelekma en hat hamuya vaga enonggo mbanggigin ako, nenasin Ala avema bisiluk, Imam hak At ake ogagu dogopwak yiluk denogo mondok okbigigindikmu, Ininis ombok dugwit, avakwa wen vaga yagamu andoma agarwik ako enavema bisiluk, ‘Yi ogares, ndi ogares,’ yugurugu dogosogom o,” yiluk, ndawi swi menda watwis naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","Andi ogagu inugu neyagek, it malaikat eneyave wisane yoangga hedangga leyalek hak nit nininggis dinggilup meyan andi ndatak inigis. It malaikat ako en, wene yugeraligama kursi sek ako inim, it avakwa en iniselagwidek menda eneyave ako inim, it mbogot vaga agarwik enanggok ap ombok-ombok ako inim, ilim werek inigik, malaikat ako en walinogo enane ombok vaga ndawi watao. Ndawi eyave watao andi yi: ");
INSERT INTO nbq_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","“Ndomba Eyak watugwa ako, Yi avakwa ndi avakwa avema seve yi nunggugwi, ‘At inggis mondok werek, Yi wene ndi wene ovok ilup, At adik mondok anye aro,’ yiluk, agayuk wutwis, inis siyabagwi, hai watwis, Ogagu dogop sek aro,” yiluk, ndawi watao. ");
INSERT INTO nbq_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","Anderogo hak, it mbogot vaga agarwik inim, wen vaga agarwik inim, wen avema agarwik inim, is ombok yanggadek laut endawima nagwis inim, Ala en ogovakhigitigi yi menda ndi menda yi avakwa ndi avakwa ovok erogo enane ombok vaga ndawi watao. Ndawi eyave watao ako andi yi o: “At wene yukneraligama horaik agarik ako inim, At Ndomba Eyak ako inim, iperen enanye mondok werek atma, Enavema seve yiluk, hai watwis, enagayuk wutwis, ininis siyabugwis, modok-modok ogagu dogosogom o,” yiluk, ndawi watao. ");
INSERT INTO nbq_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","Ndawi watu-sigik, it iniselagwidek menda eneyave 4 ako en, “Avyarat yagao o,” yiluk, “Amin,” yugwi, eke, it enanggok ap ombok-ombok 24 ako en enavema seve yiluk, ininis siyabugwis, ogagu inigis o. ");
INSERT INTO nbq_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","Andi ogagwi inugu neyagek, Ndomba Eyak ako en mbuku virik-verek heda 7 marek ako ambi endak marek visinggigi. Visinggu hegek, avakwa iniselagwidek menda eneyave 4 ako ambi en ane o unggulane ovagak iri dugwit, “Oma,” iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","Naruk hunggu lagirik, nil neyagek, kuda iris mudu swa yanggwi ovagak atma, ambor vaga ambi horaik ayegen inggimu wigya higi. Wigya lagama, nggudit-nggudit ambi yikbaluk, lakbagya lagama, avakwa sovalbisaigen yiluk, ndup ogari lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","Okbaluk, Ndomba Eyak ako en heda endak marek visinggu lagarik, ambi marek ako visinggu higi. Visinggu hegek, eneyave 4 ako enaswe ambi en iri dugwit, “Oma,” iris naruk hunggu lagirik, nil neyagek, ");
INSERT INTO nbq_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","kuda adik ambi iris mudu hali abya hak atma, ambor vaga ambi horaik wagya higi. Wagya lagama, Ala en, “It avakwa o wen vaga yagamu andoma enendawi ugun seyalek adenggen nagu dogop dek. Ata, ir-it war-wat yugu dogopwak o,” yiluk, Ala en at kuda ambor vaga wagya ako andok dogop mendek okbagya dugwit, mbusinggarep erasul adup ambi wogogu higi o. ");
INSERT INTO nbq_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","Eke, Ndomba Eyak ako en heda mberen marek ako visinggu lagarik, ambi marek visinggu higi. Visinggu hegek, avakwa iniselagwidek menda eneyave 4 ako enaswe ambi en iri dugwit, “Oma,” iris naruk hunggu lagirik, nil neyagek kuda mudis ovagak atma, ambor vaga ambi horaik anggin wakhegek ako menda inggimu wolok wagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","Wolok wagyama it avakwa iniselagwidek menda eneyave 4 ako, enanggelekma en ane ambi iri dugwit, “Tepung gandum kaleng ambiat yidik ako andi, onggo ombok yoparip ndugwis ambiat vaga it yavup ogasagwi onggo wogorelagwi wane-wane ako vaga hunggu dogosogom. Eke, beras kaleng henggam yidik ako andi, wane-wane onggo ombok yoparip ndugwis ambiat vaga it yavup ogasagwi onggo wogorelagwi ako vaga hunggu dogosogom. Anderogo ovara, yo saitun amburup inim, anggur amburup inim andi, weyak erogo baup moga o,” yiluk, iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","Andi okbaluk, Ndomba Eyak ako en heda henggam marek ako visinggu lagarik, ambi marek ako visinggas. Visinggu hegek, avakwa iniselagwidek menda eneyave 4 ako enaswe ambi en iri dugwit, “Oma,” iris naruk hunggis. Iri lagirik, ");
INSERT INTO nbq_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","nil neyagek, ap hambigiluk ogagya dugwit, elose mudu deyalogo baliga andi hak, kuda iris anderogo at ambi inis Hambisagwi Andok ako kuda ambor vaga horaik wagya higi. Wagya hegek, ambi inis Hambuluk Lendagwima ambetaga labo erogo wagya higi. Iperen wagu lagaoma, iren avakwa o wen vaga nin mogologo hetbugu dugwit, nin mogologo seperempat ako segowa vaga enarit lagwi, hambupwak yiluk, uvup erogo bugwis, adwanggak idup-idup ogwarogo bugwis, eke, wam nggusa inim, yangge do inim en, hivirinuvupwak yiluk, enaninis ogwarogo bugwis, ogarit lagu dogopwak yiluk, andok okbugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","Andi okbaluk, Ndomba Eyak ako en heda 4 marek visinggu lagarik, ambi marek ako visinggu higi Visinggu lagama, it avakwa Ala wene wokbaluk, Keretus awene mondok des erogo vagalogo yugeregek lagu-selok, initu lagagwa ako, enanggela Ala ake warogo hali hunisagwima avema andenam werek inigis. ");
INSERT INTO nbq_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","It initu lagagwa enanggela ako en enane ombok yugugu dugwit, “Nenasin Hinis ombok Ala wai. Hat hadik modok ombok avyarat adik denek agindik atma, it avakwa o wen vaga menda en ninitugwa nenamuya wambegek lagagi ako, enowak dilogo onggo inititek heyagek, ndugwis maren arisogon o,” yiluk, yugugu inigis. Yugugu lagaoma, ");
INSERT INTO nbq_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","“Dek o. Hit henowa-henasin inim, it hinim Ala wene modok dibaluk musek lagwi inim, hit hinitugwa ndatak inurusogom halok andi, onggo ambivaga dambup erogo inirisogon atma, we un ndugwis ambiat mbauk dogosogon o,” yiluk, enasum mudu adup enadik-enadik yikbugu inigis. ");
INSERT INTO nbq_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","Andi okbaluk, Ndomba Eyak ako en heda 5 marek visinggu lagarik, ambi marek ako visinggas. Visinggu lagama, o wadok ombok yukul-yukul iris, hain hali agadya mbetalek hak mo il hwis iris, saut muya ovagak agya, ");
INSERT INTO nbq_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","o havut endengga ombok wagya dugwit yo widis enggen ao bao hegek heralogo wen vaga ya ndun nda ndun wambegek wandiga hak, dadiwap mbogot vaga en wen vaga wambu wagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","Wambu wagya lagama, mbuku virik-verek ogasagwi andi hak mbogot nggago iri dugwit, virik-verek ari lagya, eke, ndom inim, is enggema wen hudi mbalekma inim, ovok erogo wolok adikmu ari lagek ogagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV6_15","096_6_15","REV","6","15","17","Andi ogagya higya lagirik, it avakwa wen vaga menda enasini ininis ombok inim, ap ombok-ombok inim, it ap ndugandok inim, ap ininggis werek inim, ap enane anye inim, avakwa enayeloman inim, avakwa un agarwik menda inim, ovok en yugu dugwit, “Ala Yesus iperen enaninis en okbininup hudi vage vanggo yagarikmu, nit niniluk dogop dek at helagwi o,” yiluk, enalon en, “Nggoma lauk?” yiluk, wis elola inim, helep elola inim, hwilak lari lagao. Hwilak lari lagu lagaorik, “At wene yugeraligama horaik agarik ako inim, Ndomba Eyak inim, iperen nit ninisagup en, ndom yi vaga inim, helep ombok yi vaga inim, nit sopalninivu o,” yiluk, ndom inim, helep inim, yugugwis inigis. ");
INSERT INTO nbq_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","Andi ogagwi inugu lagirik, an Yohanes en malaikat eneyave 4 inigis. It malaikat eneyave 4 ako, o wema yoma atok venak-venak 4 mendek agarwik inigis. Mendek werekma, o wen atok venak-venak 4 ako o havut wane-wane 4 at warit wulu wandigama, o wen vaga inim, is ombok yanggadek laut inim, yoangga-hedangga inim, o havut en avolok ogarit lagya hawen, o havut vagago agarwik inigis. ");
INSERT INTO nbq_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","Inugu lagirik, werekma, malaikat adik ambi mo il daga wandigama en wulu wagya higi. Wulu wagya dugwit, Ala iluk agarik ako aburi denogo bisiluk, amburup yedok erogo okbigik wolok wagya higi. Wolok wagya lagarik, it malaikat eneyave 4 wen inim, is ombok yanggadek laut inim, weyak erogo baup andok okbogogi ako, ane ombok vaga yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","“Nit nenasin Ala ayelomani denek ako yedok dogopwak yiluk, amburup enembet vaga erabigitek neyagek, wen inim, is ombok yanggadek laut inim, yoangga-heda angga inim, weyak erogo baup moga o,” yiluk, yugirigya higi. ");
INSERT INTO nbq_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","Yugirigya lagama, ane ambi iri dugwit, “It Iserali vaga Yakup aburi wigalek ininis unggul adik-adik ovok eneyave dambup erogo 144.000 denogo bisayogon o,” yiluk, iris naruk hunggu lagirik, ");
INSERT INTO nbq_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","inis unggul Yekura menda 12.000 denogo bugu, inis unggul Uruben menda 12.000 denogo bugu, inis unggul Nggat menda 12.000 denogo bugu, ");
INSERT INTO nbq_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","inis unggul Asiyet menda 12.000 denogo bugu, inis unggul Naptali menda 12.000 denogo bugu, inis unggul Manase menda 12.000 denogo bugu, ");
INSERT INTO nbq_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","inis unggul Simeyon menda 12.000 denogo bugu, inis unggul Lewi menda 12.000 denogo bugu, inis unggul Isakat menda 12.000 denogo bugu, ");
INSERT INTO nbq_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","inis unggul Sebulon menda 12.000 denogo bugu, inis unggul Yusup menda 12.000 denogo bugu, inis unggul Benyamin menda 12.000 denogo bugu, ogagya dugwit, ayelomani denek ako yedok dogopwak yiluk, amburup enembet vaga erabigik laga ako andi, eneyave dambup erogo 144.000 at inigis o. ");
INSERT INTO nbq_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","Andi ogagya higya lagirik, it avakwa ininis unggul adik-adik inim, enane adik-adik inim, enagamut adik-adik inim, enanggelekma en ambi nggigik homago ako andi, eneyave wisane ininggis dinggilup ogo modok meyan inigis. It avakwa andi, enasum adup mudu yanggwi iris hak yikbaluk yo ndila angga hedalek ininggimu vagago dugwit, At wene yugeraligama kursi sek vaga horaik agarik ako inim, Ndomba Eyak ako inim, iperen enavema mendek yiluk, ");
INSERT INTO nbq_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","enane ombok yugu dugwit, “Wene yugeraligama horaik agindik Hat nenasin Ala ako inim, Hat Ndomba Eyak ako inim, Hiperen en nenagap wendatugupma, wa,” yiluk, yugurugwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","Yugurugwi inigik, At wene yugeraligama inim, it mbogot vaga agarwik enanggok ap ombok-ombok eneyave 24 ako inim, it avakwa en iniselagwidek menda eneyave 4 ako inim, ilim werek inigik, it malaikat yilin-walin ogarek mendek agarwik ako ovok erogo At wene yugeraligama horaik agarik ako, enape samulik avema seve yiluk, Ala inis siyabagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","Ala inis siyabagu dugwit, ndawi eyave yi watao: “Avyarat Amin! Hat nenasin Ala atma, Yi wene ndi wene ovok hilup, Hat hadik mondok hanye aro, yiluk, ‘Wa,’ yukhugu dugwit, hagayuk wutwis, hinis siyabagagwi, hai watwis, Modok-modok ogagu dogosogom o, amin,” yiluk, yugugwis inigis. ");
INSERT INTO nbq_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","Yugugu lagaoma, it mbogot vaga agarwik enanggok ambi en an yuknugu dugwit, “It avakwa enasum mudu yirik andi, sani? Eke, nggoma en wagao embeten?” ");
INSERT INTO nbq_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","Yuknugu lagama, “Nasin. An nunggut atma, haren enat eru,” yugugu lagima, aren an yuknugu dugwit, “Dek o. It yi, avakwa anggin-mbanggin modok wisane okbugu inigik, enanggelekma en wulu wagao ako eneyave yi aro. It ako andi, enasum mondok mudu arupwak yiluk, Ndomba Eyak amuya ako vaga enasum hothedagao. Hothedagaorikmu, ");
INSERT INTO nbq_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","‘Wene yugeraligama Ala ivaga andoma dugwit, Hutun-howam Ala awi valekma ake ogagu-sigik, At wene yugeraligama kursi sek vaga horaik agarik nenasin Ala ako en weyak enovaga agya hawen, avema bisiluk agarik o. ");
INSERT INTO nbq_vpl VALUES ("RV7_16","096_7_16","REV","7","16","17","Eke, wene yugeraligama ilim adigat agarik Ndomba Eyak ako en eneyave des erogo at vagenombogo agarik. Iniluk modok dogopwak yiluk, is il eyave mudis wogenombolok layogonma, Erom uvup ogonupu, is uvup ogonupu, mo edup en inita, o heket en enanyedek erogo bugu, ogwasogon modok dek o. It yup yagwi iniselok, Ala en at yup oangga dek erogo bisayogon o,’” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","Ndomba Eyak ako en heda vivis marek 7 ako visinggu lagama, setengah jam ovagak agya dugwit, mbogot vaga andoma enane dek, enavologane dek, inisogane dek, mbauk adigat ogagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","Ogagya lagarik, it malaikat eneyave 7 Ala avema mendek agarwik ako ane ombok ogasiga trompet 7 wogirigya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","Higya neyagek, malaikat adik ambi sogolowak mbusi emas vaga ogovak higirik inggimu wolok, Ala ake warogo hali hunisagwima mendek yi wagya higi. Mendek yi wagya lagama, amben eyave segedok menda wisane wogugu higi. Wogugu lagama, Ala ake hali hunisagwima mbusi emas vaga ogovak higirik Ala wene yugeraligama avema akoma, amben eyave segedok menda ako inim, it Ala aburi ake denek samban ogasagwi enane yugugwis ako inim, Ala ake bagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","At malaikat en Ala ake anderogo bagya hegek, amben eyave sek menda hali ninggama yuvuk inim, Ala aburi samban ogasagwi enane yugugwis inim, inggimu en Ala adema inggya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","Ako ogagya higya neyagek, at malaikat ako en amben eyave sek menda sogolowak vaga nudik welaga ako, hali hunisigama akoma en hali hunik wigya lagarik, sogolowak ako vaga mabaluk, wen vaga mbo wombaba wagya higi. Wen vaga mbo wombaba wagya lagama, o unggulane iris, o bigavok yovalevet higya, ogagya hegek, o wen wadok yukul-yukul ogagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","Andi ogagya higya lagirik, it malaikat eneyave 7 enadik-enadik ane ombok ogasiga menda trompet wogeraga vagogo agarwik ako, ane ogwaruguluk, dik-duk dak-duk ogagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","Ane ombok ogasiga trompet vagogo agarwik ako, ambi endak trompet ane ogagya lagama, musu hol es salyu inim, hali inim, amuya inim, nanggibuk-hanggibuk erogo baluk, o wen vaga mbo wombabaik wagya higi. Wombabaik wagyalagama, wen inim, yo inim, nin agako higirogo mberen hekbaluk, nin ambi higirek hali ninggya dugwit, yoangga-heda angga swi ogo ovok erogo nenggek lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","Malaikat ambi ane ombok ogasiga trompet ako, ane ogagya lagama, okbaluk, enaswe ambi en trompet ane ogagya hegek, ndom ombok ambi hali wuluk yagan is ombok yanggadek laut ako vaga mbeyak ha wambigya higi. Mbeyak ha wambigya lagama, is ombok yanggadek nin agako higirogo mberen hekbagya dugwit, nin ambi higirek ako amuya ogwarogo bagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","Ogwarogo bagarikmu, yi menda ndi menda iluk menda is elola agarik ako nin mberen higirogo hekbagya dugwit, nin agako higirogo ako hambit lagwi, eke, yi mburis ndi mburis is agakoma nagwis ako nin mberen higirogo hekbagya dugwit, nin agako higirogo ako windilek-hedalek oklarit lagya, ogwagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","Malaikat mberen ane ombok ogasiga trompet ako, ane ogagu lagaoma, okbaluk, at ambi en trompet ane ogagya hegek, dadiwap ombok ambi hali wuluk yagaliga ako ovagak mbogot vaga en wuluk yagan wambu wagya higi. Wambu wagya lagarik, is landigama inim, iliris wulu wandigama inim, ovok erogo nin mberen higirogo hekbagya dugwit, nin agako higirek ako eda erogo baik lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","Dadiwap ako andi, inis Eda atma, is nin agako higirek ako eda ogwarogo baik lagarikmu, avakwa nunggu lagaorik, eneve wisane hambit lagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","Malaikat henggam ane ombok ogasiga trompet ako, ane ogagu lagaoma, at ambi en trompet ane ogagya hegek, mo il awiya inim, saut awiya inim, dadiwap awiya inim, venak agako higirek ako, abya dek ogwarogo bagya higi. Abya dek ogwarogo bagya lagama, o dingga ako awiya maduk agya, eke, o hup halok, o modok hwis iris, ogagya dogopwak yiluk, mo il awiya inim, saut awiya inim, dadiwap awiya inim, nin mberen higirogo hekbagya dugwit, nin agako higirek ako, awiya dek agya higi. ");
INSERT INTO nbq_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","Andi agya higya neyagek, swa eram mbongga mbogot ilim yoma wigak-wigak yagan lagya dugwit, ane ombok vaga iri higi. Iri dugwit, “Malaikat eneyave 7 ako, it eneyave 4 ane ombok ogasiga trompet ane vage ogagao ovara, eneyave henggam andi, ane ogwaruguluk, modok diduk ogasagwi. Ogasagwima, it avakwa ovok erogo wen vaga agarwik andi, ayai, enabwa, enabwa o,” yiluk, ane ombok vaga yagan lagya naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","Hunggu lagirik, werekma, malaikat eneyave 4 ane ombok ogasiga trompet ako ane ogagu lagaoma, okbaluk, at malaikat ambi en trompet ane ogagya hegek, dadiwap ambi mbogot vaga en wen vaga wambu wagya higi. Dadiwap wambu waga ako, hambuluk lendagwima nggilin elola yagamu andoma adigat sup hurigiluk, hunsi wigya higi. ");
INSERT INTO nbq_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","Hunsi wigya lagarik, hambuluk lendagwima nggilin elo ako dadiwap ako en sup huritas. Sup hurutu lagama, helep yugup yuvuk yendok wandok ogasiga hak, nggilin elola en yuvuk wisane daga wagya dugwit, mo il inim, o ilim yoma inim, hwis erogo bagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","Higya neyagek, yuvuk anggelekma en idam wisane daga wagu lagaorik, hagudi aik hiviriniparikmu edup helagwi hak, idam ako en avakwa aik hivirinivit lagwi vaga edup en yagan watu dogopwak yiluk, enanye okbugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","Enanye okbugu lagarik, yugirigya dugwit, “Yoangga yi menda ndi menda angga ako ovok erogo henaik libilogo nenggek nagu dogop moga. Ata, it avakwa Ala en amburup enembet vaga hondalekdek halok adigat henaik hivirinivit nagu dogones. ");
INSERT INTO nbq_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","Eke, eneyave hambupwak yiluk, hivirinivup andi moga. Ata, we un edup en yagan watwis inigik, saut 5 nggao yupwak yiluk, henaik hivirinivit nagu dogones,” yiluk, yugirigya higi. Yugirigya lagama, hagudi ako en aik hivirinitarikmu edup en yagan warisagwi hak, wane-wane at aik hivirinivit lagusigik, edup en yimbilok-mendalok yagan lagu inigis. ");
INSERT INTO nbq_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","Andi hudi vaga it avakwa edup en yagan watu dugwit, “Mbikit hambik dek ai, nano yiluk niluk agirik,” yusogom ovara, hambup enadema ari wasogon mondok dekma, hambegetek un iniluk adigat dugwit, yimbilok-mendalok adigat yugu dogosogom. ");
INSERT INTO nbq_vpl VALUES ("RV9_7","096_9_7","REV","9","7","8","Idam ako andi, enelose ap ndatak ovara, iniris andi, akwa iniris dalwik ako ovagak, eke, aik andi, yangge singga aik ako ovagak, agarwik inigis. Kuda ambor vaga hora yiluk ndup sumburuguluk, diduk ogwarogo biselagwi hak, it idam eneyave ako andi, anderogo at diduk ogwarogo bugu dugwit, nggudit-nggudit mbusi emas vaga ogovak higirik inim, ");
INSERT INTO nbq_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","sin mbusi vaga yago inim, yikbugu higi. Eke, ndup sumburuguluk, kuda adonggop vaga yidibaluk, kereta likhelok ndup sumburi nunggugu dugwit, kuda eneyave wisane atma enavulagane wisane yagan lagwi enaruk hulisagwi hak, anderogo at idam ako enamik wigak-wigak yagan lagu dugwit, enamik ane andi, ane ombok yagan lagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","Enagya andi, hagudi aik ako ovagak atma, aik avakwa hivirinipu halok, edup en yagan watwis inigik, saut 5 nggao iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","Eke, at malaikat hambuluk lendagwima nggilin elola vagogo agarik ako andi, it idam enowa inis ombok vagago agarik araro. At inis andi, avakwa Iberani enane vaga, “Abadon,” yagalagwi, eke, Yunani enane vaga, “Apoliyon,” yagalagwi. ");
INSERT INTO nbq_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","“Avakwa mondok anggin okbisaup menda ako, ambi idam en vage ogagya hegen ako arovara, mberen andi ao ogagetek atma, hil dogwen o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","Yuknugu lagama, nil werekma, malaikat eneyave 5 ane ombok ogasiga trompet ako ane ogagu lagaoma, okbaluk, at ambi en trompet ane ogaga. Ogagya lagama, amben eyave sek menda Ala siyabamunda hali hunisagwima mbusi emas vaga ogovak higirik Ala avema agarik ako, atok-atokma sapi aik ovagak aik ombok 4 akoma en ane ambi iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","Iri dugwit, “Malaikat eneyave 4 is ombok Evarat omban vaga heda marek agarwik ako, hodo erogo heda visilogo lakbisin,” yiluk, at malaikat trompet ane ogaga ako yugogogi. ");
INSERT INTO nbq_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","Yugugu lagama, it malaikat eneyave 4 ako en tahun andi vaga, saut andi vaga, ndugwis andi vaga, mo il andi vaga, modok wane-wane ari lagya halok, avakwa nin mberen higirogo hetbugu dugwit, nin ambi agako higirogo ako enarit lagu dogopwak yiluk, vipuk ogwarogo bogogi ako at enarit lagu dogopwak yiluk, visilogo hekbugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","Higya lagirik, “It malaikat 4 enaori yegen werek menda kuda ambot vaga hora yugu lagaorik, ndup sumburi lagao ako andi, eneyave dua ratus juta aro,” yiluk, iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","Eke, kuda inim, ap eneyave kuda ambot vaga horaik agarwik inim, nabi higya dugwit, inigis ako andi yi o. Enarin yirik ako andi, heda melaka enggen mudu ovagak, mbogot mudis ovagak, eke vule angga mudu ovagak, enarin elose anderogo at higi. Kuda ininggul ako andi, yangge singga unggul ako ovagak atma, adwanggak idup-mbidup erogo baik lapwak yiluk, enelagapma en hali abya inim, yuvuk inim, helep belerang agap sule sukup yagaliga menda inim, wulu wagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","Enelagapma en wulu waga ako vaga en, adwanggak idup-mbidup erogo baik lagarikmu, avakwa nin higirogo mberen hekbugu dugwit, nin ambi agako higirogo andi aup edup en mondok hambit lagu inigis. ");
INSERT INTO nbq_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","It kuda enelagapma en hali wulu wagya ovara, it enagya andi, mbas awigovak unggul ako ovagak en avakwa enarit lagaorikmu, enelagap inim, enagya inim, andi mondok anye wisane at inigis o. ");
INSERT INTO nbq_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","It nin edup en hambegetek hetbigas iniluk agarwik ako en it weyak ogasagwi ako enasam hegetek at inigis. Iren, “Nit anderogo at hambit lagu ninisau, nenomadis ako andi, ininis siyabagwi, madis ininis wogobugwis, ogasagwi ako menda mbo basogom,” yup sek hegek ovara, dek, enasam hegetek ao ogarit lagao. It enomadis andi, yi menda ndi menda inil helagwi dek, enane enaruk hulisagwidek, sup lendagwidek, ogwasagwidek hegek we un inam warogo enomadis mbusi emas vaga, mbusi perak ako vaga, mbusi sembaga ako vaga, helep vaga, yo vaga, ogovak higirik atma, mbo baup sek ovara, dek, enasam hegetek ao ogarit lagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","Eke, “Avakwa initwis, mum vaga initwis, ovat vaga initwis, avakwa ugun ogonupwis, enonggop wugwi, ogasagwi menda ovok erogo nenasam helok, mbo basogom o,” yiluk, yup sek arovara, mbo bagetek enendawi hunik dugwit, ogarit lagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV10_1","096_10_1","REV","10","1","1","Ogwasagwi ako an Yohanes en inugu lagirik, werekma, malaikat anye werek ambi, ayum hena vaga virik-verek ogarek mbogot vaga en wambu wagya higi. Unggul vaga andi, yuwaru danggulik. Elose andi, mo il ovagak, eke, isok andi, yo mot adup vaga hali abya wuluk herek yagaliga ovagak iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV10_2","096_10_2","REV","10","2","2","At inggimu mbuku virik-verek ogarek maduk ambi mbigabaluk agarik higi. Isok amotkan is ombok yanggadek laut ako agakoma bagya, eke, isok hwarenggan wen vaga bagya, okbaluk, ");
INSERT INTO nbq_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","yangge singga ane mondok ndun yagaliga hak, ane ombok anderogo iri lagama, o unggulane ndugwis 7 hudi iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","O unggulane ndugwis 7 vaga iris naruk hobaluk, iris ako dirup mbalik en yiluk ogagyaim, mbogot vaga en ane ambi yuknugu dugwit, “O unggulane ndugwis 7 vaga iris hunggin ako andi, dirup mbalubuk. Ata, hendawima adigat hwilakbaluk dogwen o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV10_5","096_10_5","REV","10","5","6","Yuknugu lagama, nil neyagek, malaikat isok ambi is ombok yanggadek laut agakoma bagya, ambi wen vaga bagya, okbaluk, mendek agarik higi ako en, mbogot inim, mbogot vaga agarwik inim, wen inim, wen vaga agarwik inim, is ombok yanggadek laut inim, is ombok yanggadek laut endawima agarwik inim, ovok erogo wakhagagi mondok-mondok itok iluk agarik ako inis vaga iri dugwit, “Ala en anggin okbisaup andi, epimbo ogarisogonbuk. Mbikit ogarisogon!” yiluk, avyarat ombarupwak yiluk, inggis amotkan mbogot vaga ilikbagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV10_7","096_10_7","REV","10","7","7","Iri lagarik, malaikat ako en ambi iri dugwit, “It malaikat eneve 6 en ane ombok ogasiga trompet ako ovok enane ogagaorikmu, ambi 7 ako, trompet ane ogagya halok, wene mbauk hwilago Ala en at ayelomani navi-navi yugeragagi ako, atma arisogon o!” yiluk, iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","Naruk hunggu lagirik, werekma, mbogot vaga andoma en ane ambi yuknugu higi ako en ambi inim an Yohanes yuknugu dugwit, “Mbuku mbalek ako heda elak. At malaikat isok venak wen vaga bagya, venak is ombok yanggadek laut vaga bagya, okbaluk, mendek agarik ako adema lagya dogomindik, mbuku mbalek inggimu mbigabaluk agarik andi, heda elak.” ");
INSERT INTO nbq_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","Yuknugu lagama, malaikat ako adema lagya lagirik, “Mbuku maduk andi, wokniru o,” yugugu lagima, at malaikat ako en woknigas. Woknugu dugwit, “Hidigya dogomindik namin. Ningga heyagek, habis vaga nggin amburup hak ai weyak hayogon ovara, halotma andi, eda arit lagya hayogon,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","Yuknugu lagama, mbuku malaikat inggimu agarik ako vagarogo ninggya neyagek, nabis vaga nggin amburup hak ai weyak higi ovara, nalotma andi, eda arit lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","Mbuku ako an Yohanes ninggya lagima, mbogot vaga ane yuknugu higi ako en ambi inim yuknugu dugwit, “Avakwa ininis unggul adik-adik inim, enagamut adik-adik inim, enane adik-adik inim, ap ininis ombok inim, yi avakwa ndi avakwa wisane, vivis oginivisogon wene andi, yugirigya dogwen o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","Andi yuknugu higya lagirik, werekma, wakhegek wanggun meter ogovak higirik ambi woknugu dugwit, “Ala awi valekma inim, Ala ake warogo hali hunisagwima inim, adup maren hudi yiluk, meter wal okha lak. Eke, avakwa Ala awi valekma siyabagek ogarit nunggugusim akoma, eneyave hinggis dinggil inivit elak. ");
INSERT INTO nbq_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","Ogwarit lagya dugwit, Ala awi valekma mbumbumu ako meter wal okhabuk. It avakwa weram Yakuri dek menda en o kota eyave adik denek agarikmu akoma inisok sovalogo bigik lagu dugwit, Ala awi valekma mbumbumu andoma inim sovalogo bigik lagu-sigik, saut 42 hudi hekbagarikmu, meter wal okhaup moga. ");
INSERT INTO nbq_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","Eke, it ap eneyave mberen An Ala nane vagalogo yugurugu dogopwak yiluk, lakbisayogon ako en enasum libilik weyak menda yirik dugwit, An Ala nane yugurugwi-sigik, ndugwis 1.260 hudi dogosogon o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","It ap eneyave mberen andi, yo saitun mberen ovagak, hali yevedogo bagek mberen ovagak, dugwit, nenasin inis ombok yi menda ndi menda adem andok ako elokwema agarwik andi, it ap andi aro. ");
INSERT INTO nbq_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","It ap mberen andi, enelagapma en hali wuluk yagan wulu wagya dugwit, it inim ogorek agarwik ako inirisagwi atma, “Ap mberen andi, inirusogom o,” yiluk, inirup yiluk ogagusigik, it enelagapma en hali wuluk yagan wulu wagya dugwit, it inirup ogasagwi eneyave ako hali abya yevedogo hali nunggu inigis o. ");
INSERT INTO nbq_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","It ap eneyave mberen ako andi, enendawi hobaluk, “O hivi vaga wene yugurugu dogopim musu wambu warubuk o,” yiluk, yugwi iniselok, musu wagetek mbup iris, “Is yi, amuya aru o,” yugwi iniselok, amuya at agya, eke, “O wen vaga yoma adwanggak wisane oklaru o,” yugwi iniselok, adwanggak wisane agya, anderogo at it ap mberen ako ogarit lagu dogopwak yiluk, Ala en andok okbugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","Higya lagima, At wene yuknugu ako en ambi inim yuknugu dugwit, “Wene yugurugu dogopwak yiluk, lakbisayogon ako hivis erogo yugeramundikmu, yangge do ovagak aninis werek ambi hambuluk lendagwima nggilin elola en daga warisogon. Daga wagya dogomindik, ap eneyave mberen ako hait enombolok enambetaga lagya dugwit, hivirinivisogon. Hivirinipu halok, hambugu dogomwima, ");
INSERT INTO nbq_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","eneyave o kota ombok enowa yo winik vaga warogo bagagwarikmu sup ombok yago ako vaga, vidis agu dogopwak yiluk, mbo bisasogom. O kota ombok ako, it nin wene atok lovarogo yugu dugwit, ‘O Sodom inim, o Mesir inim,’ yiluk, yagalagwima, akoma at eneyave mbo bisasogom. ");
INSERT INTO nbq_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","Mbo bugu dogomundik, it avakwa ininis unggul adik-adik inim, enane adik-adik inim, enagamut adik-adik inim, yi avakwa ndi avakwa ovok en, ‘Vok!’ yiluk, bigisa warusogom. Tiga setengah hari vaga wen sabisaup sek hegek ovara, ‘Hekbisines,’ yiluk, sabigitek dogosogom. ");
INSERT INTO nbq_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","“Eke, it avakwa wen vaga agarwik ako ovok en, ‘It ap Ala wene yagalagwi mberen yi en enane yugu lagao vaga nit edup-mbedup mondok wisane okbinilin nagu lagaorikmu, Nabirok! Sek at hombagao o,’ yiluk, enadenggen ogagwi, yi menda ndi menda un at wok-wok yugwi, ogarusogom o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","Higya lagirik, nil neyagek, tiga setengah hari okbaluk, Ala en elagap agarero ap mberen ako enendawima mabugu lagama, iniluk akluk, mondok yagao. Mondok yugu lagaoma, avakwa inil agarwik ako enendawi obak agu dugwit enalon wisane agwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","Enalon wisane inigik, mbogot vaga en ane ombok iri dugwit, “Dagamanis,” yugirigya lagama, enaruk hobaluk, it inim ogorek ako inil inigik, mbogot anggelekma hena vaga unggwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","Ao unggu-sigik, o wadok ombok ogagya hegek, o kota andoma avakwa enawi wisane valek ako nin hekbagya, nin agako sepersepuluh higirogo masok-danggok erogo lagya, ogagya dugwit, avakwa ovok eneyave tujuh ribu at sopalinipu lagama, it nin hetbigas ako enalon en At mbogot vaga agarik Ala ako mondok siyabagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","Inugu lagirik, nil werekma, At mbogot vaga en ane iris ako ambi inim yuknugu dugwit, “Avakwa mondok anggin okbisaup menda ako andi, mberen vage ogagya hegen ovara, ambiat ako hodo erogo ogarigiluk ogagyama, hil dogwen o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","Yuknugu lagama, nil werekma, malaikat 6 ane ombok ogasiga trompet ako ane ogagu lagaoma, ambi ako en trompet ako ane ogaga. Ogagya lagama, it mbogot vaga andoma en enane ombok yugu dugwit, “O wema andoma pemerintah enavema agarwik avakwa ovok erogo ako, At Nenasin inim, At denogo mondok okbogogi Keretus inim, iperen enane hunggu dogoguluk, enavema ari wagao o. Ari wagwi iniselok, Keretus ako en enowa inis ombok dugwit, mondok-mondok wene yugirigya dogosogon o,” yiluk, yugwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV11_16","096_11_16","REV","11","16","16","Yugu lagaoma, nil neyagek, it mbogot vaga agarwik enanggok ap ombok-ombok eneyave 24 wene yugerelagwima kursi sek vaga Ala avema horaik agarwik ako en enelose samup Ala avema ndun yi lagu lagaorik, siyabagao. Siyabagu dugwit, ndawi yerogo watugwa: ");
INSERT INTO nbq_vpl VALUES ("RV11_17","096_11_17","REV","11","17","17","“Hat Hanye Hadigat agindik Nenasin Ala, Endak welagagin, yogak mondok agindik, hararo. Yogak hat Hinis ombok dugwit, Hat hanye wisane atma, Avakwa ovok erogo havema bisiluk, Wene yugirigya dogosogon andi vaga, Nit ‘Wa, wa,’ yukhisagwi o. ");
INSERT INTO nbq_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","Yi avakwa ndi avakwa ininis unggul adik-adik en, enaninis umbutu dugwit, ‘At nenowa inis ombok dogop nenanggon o,’ yiluk, yagan wagwi ako, Haninis enovaga bugu, it hambit lagagwa ako enowak dilogo bugu, It hayelomani navi-navi inim, haburi hake denek ako inim, it hinis siyabagalagwi inim, ininis dek ininis werek ovok erogo sek ogagu-selok onggo wogirigya, eke, it o wen vaga andoma weyak ogwarogo biselagwi ako, dek erogo bugu, Ogwarup hudi vage vanggo yi wagarikmu, wa,” yiluk, yugugwis inigis. ");
INSERT INTO nbq_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","Yugugu lagaoma, Ala awi valek mbogot vaga akoma sup hut lagya lagama, wene Ala en nggatuk erogo yugeragagi 10 hukum mbalek yo peti ogarek vaga yidik agarik ako, sigam agya higi. Sigam agya hegek, o bigavok ogagya, unggulane iris, o wadok iris, musu hol es salyu mondok yuvulogombo wambigya, ogagya higi o. ");
INSERT INTO nbq_vpl VALUES ("RV12_1","096_12_1","REV","12","1","1","Ogagya higya lagirik, mbogot vaga andoma ninilup arup menda modok iya erogo ambi ogwagya higi. Higya dugwit, hwa ambi saut eyave vaga mendek werekma, sogwes yum hak andi, mo il at yirik, eke, unggul vaga nggudit-nggudit mendarek anggelekma dadiwap 12 hudi hunik agarik higi. ");
INSERT INTO nbq_vpl VALUES ("RV12_2","096_12_2","REV","12","2","2","Hwa ako, avula werekma, eyak iluk igya dugwit endak hedagiluk edup en yagan watya dugwit, na iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","Na iri lagama, mbogot vaga andoma ninilup arup enalon werek menda adik ambi ogwagya higi. Higya dugwit, mbas ombok awigovak ovagak agamut mudu swa nggenak iris ovagak atma, eyave ambiat arovara, unggul 7. Unggul ako vaga aruk adema aik 10 yago werek higi, eke, unggul 7 ako vaga nggudit-nggudit maduk sivovo ovagak mendarek ovok erogo yirik higi. ");
INSERT INTO nbq_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","At mbas ako agya vaga dadiwap mbogot vaga agarik ako nin mberen inigik, nin ambi agako higirogo ako vedalogo wen vaga mbo wombabaik wagya higi. Higya lagirik, mbas ombok ako en, “Hwa ako eyak endaklagya halok, nayogon o,” yiluk, hwa ako adema hanjalek welaga. ");
INSERT INTO nbq_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","Hanjalak welaga ovara, at hwa ako en ap at endaklagya lagama, avyak ako haru ogo wolok wene yugeraligama At Ala adema ba inggya higi. Avyak ako yi ap akwa ndi avakwa ovok erogo enasin inis ombok dugwit ane anye vaga wene yugirigya dogosogon. ");
INSERT INTO nbq_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","Eke, avyak ako ba ingga lagama, isa ako, dogopim Ala en dikduk okbagarikmu harumu avakwa dekma andoma hoda laga werekma, Ala en eyaga hegek, ndugwis 1.260 hudi ari lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV12_7","096_12_7","REV","12","7","7","Andi ogagya higya lagirik, o mbogot vaga andoma ndup sumbutu inigis. At Mikael aori malaikat menda inim en at mbas ombok awigovak ovagak ako, aori malaikat weyak menda inim mbogot vaga andoma ndup sumbutu dugwit war-wat yugu inigis. ");
INSERT INTO nbq_vpl VALUES ("RV12_8","096_12_8","REV","12","8","8","Ndup sumbutu dugwit, iren mbas ombok ako aori inim enanye dek erogo bugu lagaorik, “O mbogot vaga yoma dogop dek o,” yiluk, ");
INSERT INTO nbq_vpl VALUES ("RV12_9","096_12_9","REV","12","9","9","at mbas ombok ako aori inim haryogo wen vaga mbo wombabisa wagwi inigis. At mbas ombok awigovak ovagak wombaba waga ako andi, o muk en yi avakwa ndi avakwa ovok erogo enambutmu dagasiga menda inis Sile ako andi, inis ambi setan aratma, at aori inim ovok erogo mbogot vaga en haryogo wen vaga wombabisa wagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","Haryogo wombabisa wagu lagaoma, ane ombok ambi mbogot vaga andoma en iri dugwit, “At Ala ivaga nenaswei Ala aburi hutun-howam huluk wene enovaga bisaliga ako, vage wombaba wagarikmu, At Ala anye vaga Sile sovalogo baluk, aburi enagap wendatya, Nenasin Ala en it yi avakwa ndi avakwa ovok At avema bugu, At abut denogo bagagi Keretus ako, enasin inis ombok dugwit wene yugirigya, Ogagu dogop hudi ako, ovok oklandiga yi aro. ");
INSERT INTO nbq_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","It nenaswei Ala aburi ako andi, ‘Ninirup halok sek aro,’ yiluk, inugutek hegek Sile aburi en initao, Wam Ndomba Eyak amuya winggigi ako enendawi andi vaga vanggabaluk dugwit, Yesus wene iri lagagi ako vagalogo yugeregek nagwis vaga Sile sovalogo bagao o. ");
INSERT INTO nbq_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","Hat mbogot inim, hit mbogot vaga agipik inim, henendawi adenggen umbutu dogones o. Eke, hit wen vaga agipik ako inim, is ombok yanggadek laut vaga agipik ako inim, hit ako andi, Henanggelekma at Sile wombaba waga ako en, ‘An dek okbanup andi, o vage horok ari wandiga o,’ yiluk, Aninis wisane en hit avakwa sale-vale erogo bigigayogon atma, Henabwa o!” yiluk, iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","Eke, at mbas ombok ako en, “An wen vaga modok at mbo wombabani waga higi,” imbitya lagarik, hwa ako amusek laga. At hwa eyak avyak endak laga ako at amusek laga. ");
INSERT INTO nbq_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","Amusek lagya lagama, watya hawen, o at hwa ako dogopim Ala en dikduk okbagarikmu harumu avakwa dekma akoma lapwak yiluk, Ala en swa eram mbongga amik ndatak, hwa ako, amik werek okbagya lagama, wigak-wigak yagan o akoma laga. O akoma lagya lagarik werekma, Ala en eyaga hegek, tiga setengah tahun ogagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","Eke, lagya hegek, is en hwa andi wolok lapwak yiluk, is ombok nggut landiga hak, at mbas ombok ako elagapma en is suvurogo adoma lakbagas. ");
INSERT INTO nbq_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","Lakbagas ovara, wen ako en hwa ako yonggat higya dugwit, elagap bisak baluk, is ombok mbas elagapma en suvurogo lakbagas ako, wen elo mbedekma andoma wombabagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","Andi ogagya lagama, at mbas ombok ako en hwa ako inim aninis wisane iri lagarik, hwa ako eyagi nin inim ndup sumburi lagya higi. At hwa eyagi andi, at Ala en wene yukneraliga menda des erogo ogarit lagwi inim, Yesus en vagalogo yugeragagi wene avyarat ombakluk musek lagwi inim, at hwa eyagi andi it aro. ");
INSERT INTO nbq_vpl VALUES ("RV12_18","096_12_18","REV","12","18","18","Eke at mbas ako andi, is ombok yanggadek laut omban vaga mendek yi lagya lagarik werek higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_1","096_13_1","REV","13","1","1","Andi ogagya higya lagirik, yangge do hak aninis werek ambi is ombok yanggadek laut endawima en wulu wagya higi. At yangge do hak ako andi, aruk adema aik 10, eke, unggul 7, werek higi. Aik 10 ako vaga nggudit-nggudit sivovo ovagak mendarek ovok yirik, eke, unggul 7 ako vaga Ala inis wiyiknom-weyaknom erogo bagao dirup mbalek ovok agarik higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_2","096_13_2","REV","13","2","2","Yangge do ovagak aninis wisane ima en wulu wagya higi eyave ako andi, yangge harimau ovagak. At isok andi, ombok wam beruang isok ovagak, eke, elagap ako andi, yangge singga elagap ban ogarek ako ovagak werek higi. At mbas ombok awigovak ovagak ako en, “An nanye vaga ogarit lagya, an wene yugeraligama dugwit, wene yugirigya, ogagya dogonyok yiluk, ovok erogo hat handok okbagagi o,” yiluk, yugugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","Yugugu higya lagirik, yangge unggul nin ako hegek, unggul ambi ako watu lagama, modok hambigiluk ogwagya higi. Mondok hambigiluk ogagya ovara, sek agya lagarik, it avakwa wen vaga menda ovok erogo, “Vok!” yugugu dugwit, at adigat amusek lagu inigis. ");
INSERT INTO nbq_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","Eke, mbas ombok ako en at yangge do hak ima en wulu waga ako, awene yugigas ma, avakwa en mbas ombok ako at inis ombok yiluk, inis siyabagao. Eke, yangge ako ogo inis siyabagu dugwit, “Yangge yi ndatak ambi agarwik modok dekma, sani en at inim ndup sumburup embetep? Modok dek aro,” yiluk, at inis siyabagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV13_5","096_13_5","REV","13","5","5","At yangge aninis werek ima en wulu waga ako siyabatigya dugwit, Ala wiyiknom-weyaknom erogo bagya, eke, avakwa enasin inis ombok dugwit wene yugirigya, ogagya dogopwak yiluk, saut 42 nggao yigiluk, hek bagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_6","096_13_6","REV","13","6","6","Ogagya dugwit, yangge ako en at Ala eyave inim, at inis inim, at agarikmu inim, eke, it mbogot vaga agarwik menda inim, it ovok erogo at ane vaga wiyiknom-weyaknom erogo bigik lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","It ap ininis unggul adik-adik inim, enane adik-adik inim, enagamut adik-adik inim, yi avakwa ndi avakwa ovok erogo at yangge ako en enasin inis ombok dugwit avema sovalogo bisapwak yiluk, mondok okbagya higi. Eke, at yangge ako en it Yesus aburi ake denek ako inim ndup sumbutu dugwit, inirit lagya dogopwak yiluk, mondok okbagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","At Ala en o muk mbogot-wen yi ao wakhegetek dugwit, “It avakwa mondok-mondok iniluk okbisaup o,” yiluk, ininis Ndomba Eyak watugwa ako ambuku vaga dirup watigi. It avakwa ininis mbuku vaga dirup mbalek agarik dek halok andi, it ovok erogo at yangge ako inis siyabagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV13_9","096_13_9","REV","13","9","10","“It heda maginivup denek halok heda maginipwis, Hambupwak yiluk mbusi segowa vaga enarup denek halok, initwis, Ogwagu dogosogom o, yiluk, yagagi ako at oginivit lasogom ma, oginivit lagusigik, it Ala aburi ake denek ako en, enendawi hora yiluk, enendawi wadok dek dugwit, wugu dogopwak o. “Henaruk werek a dek a? Henaruk werek halok, wene andi des erogo at hunggu dogones o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","Andi okbaluk, hivis en yangge do ovagak adik ambi wen elola en daga wagya higi. At yangge ako aruk adema aik mberen ndomba aik ovagak ovara, ane andi, mbas ombok ane ako ovagak iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","Yangge endak is yanggadekma en daga waga awene yugugu lagama, yangge vivis ako wene anye menda yugigas ako wigya lagarik, it avakwa wen vaga agarwik ovok erogo yugeraga. Yugirigya dugwit, “Hit en yangge endak daga waga unggul ambi watu lagaoma, hambigiluk ogaga ovara, sek aga ako adigat inis siyabagu dogones o,” yiluk, ane anye vaga abet erogo yugirigya higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","Eke, yangge hivis wen elola daga waga ako en nggarogo ogarubuk menda iya erogo ogarit lagya dugwit, avakwa ovok inivaga hali hunik mbogot vaga en wen vaga wombaba wagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","At yangge endak daga waga ane yugigas vaga, yangge vivis ako en nggarogo ogarubuk menda iya erogo ogarit lagya dugwit, avakwa wen vaga agarwik ako Yesus amusek lagup en yiluk, enambutmu inggya dugwit ane huluk yugirigya higi. Avakwa wen vaga agarwik ako enambutmu inggya dugwit, “Yangge hak ambi mbusi segowa vaga watao ovara, iluk aga ako, agut wakhegek huvuwak ambi ogovak higirogo baluk, at adigat inis siyabagu dogones o,” yiluk, it yugirigya higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","Yugirigya lagama, yangge endak daga waga agut wakhegek huvuwak ogovak higirik ako ane yumwak yiluk, yangge vivis ako en elagap agarero endawima vup erogo mabaup andok okbagas ma, vup erogo mabagya higi. At agarero endawima vup erogo ma bagya lagama, agut wakhegek ogovak higirik ako ane werek agya lagarik, it avakwa at inis siyabagetek ako aninis en enarit lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","At yangge andi en it ap ininis werek inim, ininis dek inim, ininggis werek inim, ininggis dek inim, un agarwik menda inim, avakwa enayeloman inim, ovok erogo enelup agek ambi ininggis amotkan vaga a, enembet vaga a, dirup mbalogo bogogi. Dirup mbalogo bugu lagarik, yugirigya dugwit, ");
INSERT INTO nbq_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","“It avakwa andi, yangge endak daga waga ako, at inis a, ata at anomor a, eneyave vaga dirup mbalek agarwik dek halok andi, enangge onggo mbalirigwi, eke, yi menda ndi menda hunggwis, ogagu dogop modok moga o,” yiluk, wene mbilinogo yugirigya higi. ");
INSERT INTO nbq_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","Higya lagirik, at wene yuknugu ako en ambi inim yuknugu higya dugwit, “Wene mbilinogo yugirigya hegen ako andi, it ap enendawi werek en adigat sigam hugu dogosogom. At yangge ako en dirup mbanggas ako andi, ap ambi inisanomor dirup mbalek 666 atma, it avakwa enendawi werek halok, ‘Nomor weyak andi, yi at higi o,’ yiluk, dibagu dogopwak o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","Yuknugu higya lagirik, werekma, at Ndomba Eyak ako ndom Sion vaga mendek werekma nil higi. Eke, it avakwa 144.000 ako, enembet vaga Ndomba Eyak inis inim, At asin inis inim, iperen ininis enadik-enadik enembet vaga dirip mbalek menda ako, Ndomba Eyak inim mendek werekma inigis. ");
INSERT INTO nbq_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","Inugu lagirik, is satut wambigya dugwit ane ombok iris, o unggulane ombok erogo ogagya, ogagya ako ovagak, mbogot vaga en nggindar ombok wisane ane ogasagwi ako ovagak, ane ombok ambi iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","Hunggu lagirik, At wene yugeraligama agarik eyave ako inim, it avakwa en iniselagwidek menda eneyave 4 ako inim, eke, it mbogot vaga agarwik enanggok ap ombok-ombok 24 ako inim, werek inigik, it eneyave 144.000 ako en enadoma dugwit, ndawi swi menda watwis inigis. Eke, ndawi watwis inigis ako andi, it avakwa ugun en mamulbaluk viyalup mondok meyan o. Ata, At Ala en, it eneyave 144.000 avakwa wen vaga menda enanggelekma en enomaluk dek okbagya dugwit enonggo mbalogo enagap wendatigi ako en adigat viyalup andi sek atma, viyanggwis inigis o. ");
INSERT INTO nbq_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","It ap 144.000 ako andi, enendawi sek adik denek dugwit, akwa inim mondok dambulik dek at agarwik. It Ndomba Eyak ako adigat inim lendagwi. Yi menda ndi menda endak menda Ala ake belagwi hak, avakwa nin inigik, it ako adigat Ala inim, At Ndomba Eyak inim, enake denek dogopwak yiluk, enonggo mbalogo enagap wendatigi. ");
INSERT INTO nbq_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","It ako huluk wene ambi mondok yagalagudek atma, weyak ambi enovaga mondok dek at inigis o. ");
INSERT INTO nbq_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","Andi inugu lagirik, werekma, malaikat adik ambi en mbogot ilim yoma lagya higi. At malaikat adik andi en, wene dek asigadek mondok itok agarik Sek Wene Yesus avok ako, avakwa wen vaga menda ininis unggul adik-adik inim, enane adik-adik inim, enagamut adik-adik inim, yi avakwa ndi avakwa wen vaga agipik ovok erogo yugeragiluk mbogot ilim yoma lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","Lagya dugwit, “Mbogot inim, wen inim, is ombok yanggadek laut inim, is liris wulu wandigama inim, At Ala en adigat wakhagagi atma, at avema seve yiluk, at inis siyabagu dogones. Yogak Ala en henowak dilhinivup hudi vage horok vanggo yagarikmu, henalon en At Ala agayuk wutu dugwit, At avema seve yiluk, inis siyabagu dogones,” yiluk, ane ombok vaga yagan lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","Yagan lagya lagama, aswe ambi wagya dugwit, “It avakwa o kota ombok Babel andi, hwa yanenggek ovagak agarwik. It hwa yanenggek ovagak atma, amburup nenek ogivisiga nelok, ugun-ugun ogarit lendagwi hak, enendawi ninggya halok weyak ugun ogarit nelagwi. Ogarit nagu dugwit, ‘Nit ogasagwi yi, it yi avakwa ndi avakwa ininis unggul dombok ovok erogo wane-wane ogagu dogopwak o,’ yiluk, mamulerelagwima, enawi inim, eneyave inim, mondok dek erogo bigis o. Mondok dek erogo bigis o,” yiluk, iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV14_9","096_14_9","REV","14","9","9","It malaikat mberen ako wene andi, yugurugu lagaoma, adik ambi wagya lagarik, ane ombok vaga iri dugwit, “It avakwa en yangge do ovagak ako inim, at agut wakhegek huvuwak ogovak higirik ako inim, ininis siyabugu dugwit, it enaburi yedok hapwak yiluk, ininggis vaga a, enembet vaga a, yangge inis dirup mbalek agarik halok, ");
INSERT INTO nbq_vpl VALUES ("RV14_10","096_14_10","REV","14","10","10","aninis modok wisane enovaga bugu dogosogon. Anggur amburup is inim nudik dek, ata amburup adigat nudik nunggu dugwit eda wisane helagwi hak, At Ala en it avakwa andi, enabwa embetetek aninis mondok wisane enovaga bugu dogosogon. Aninis wisane enovaga bugu dugwit, hali monggalek helep enggen belerang inim hora okbugu dogomima, it Ala ake denek agarwik malaikat inim, At Ndomba Eyak inim, inil inigik, mondok edup wisane en yagan yimbilok-mendalok yugu dogosogom o,” yiluk, iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","“It avakwa ininggis vaga a, enembet vaga a, yangge inis dirup mbalek dugwit, yangge inim, at agut wakhegek huvuwak ogovak higirik ako inim, ininis siyabugu dogosogon ako, hali hunik helep enggen inim enovaga dan okbayogon yuvuk ako nggatuk yegetek modok-modok enovaga en wunggu dogosogon. Wunggu hegek, dingga inim, o hup inim, sat yanggal hedegetek modok-modok yagan watu dogosogom o,” yiluk, iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","Iris naruk hunggu lagima, At ane yuknugu ako en, “It enendawi Yesus ovaga vanggabaluk, ane yugup ndatak ogarit lagwi, eke, Ala en, yerogo ogwarup nderogo ogwarup, yagagi wene des erogo musek lagwi, ogasagwi At aburi ake denek ako, edup-mbedup enovaga bisasogom. Edup-mbedup enovaga bugu-sigik ovara, enendawi wadok dek dugwit, wugu dogopwak o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","Andi yuknugu lagama, mbogot vaga en wene ambi inim yuknugu dugwit, “Yogak en, it ap Nenasin inis ombok inim hunik dugwit hambisagwi ako, enendawi adenggen at umbutu dogosogom o, yiluk, dirup mbalu,” yuknigas. Yuknugu lagama, Ala Averiniki en, “Avyarat o. It hambugu-selok, iniluk dugwit, sadida oginipu hegek yavup ogarit lendagwi ako, Ala en unggut akluk hekbisayogon dekma, enendawi adenggen umbutu dugwit, sat yanggal hidugu dogosogom o,” yiluk, iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","Wene iris ako naruk hunggu lagirik, werekma, avakwa enelose ovagak ambi nggudit-nggudit mendarek mbusi emas menda unggul vaga yirik, eke, yaga savit ovat wisane inggimu vagogo dugwit, hena mudu vaga horaik agarik nil higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","Higya lagima, malaikat adik ambi Ala awi valekma en wulu wagya lagarik, ane ombok vaga At hena vaga horaik agarik ako yugugu dugwit, “O wen vaga yagamu andoma enggen yugup modok hoda aga vage mbalup hudi agarikmu, heyaga savit hedelok, hodo erogo enggen mbali wambilak o,” yiluk, yugigas. ");
INSERT INTO nbq_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","Yugugu lagama, At hena vaga horaik agarik ako en eyaga savit ako vaga o wen vaga andoma enggen yugup mondok hoda aga ako, ovok erogo enggen mbali wambigya higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","Wambigya lagama, mbogot vaga Ala awi valekma akoma en malaikat adik ambi wulu wagya lagarik, at ogo, yaga savit ovat wisane inggimu werek higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","Andi en, malaikat adik ambi hali hunisiga menda vagago agarik ako hali hunisigama akoma en wulu wagya lagarik, at malaikat eyaga savit ovat wisane endak inggimu wulu waga ako, yugugu dugwit, “O wen vaga yagamu andoma anggur enggen yugup ako, mondok hoda agarikmu, heyaga savit ovat wisane andi vaga mbalogo yidi wambilak o,” yiluk, yugugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","Yugugu lagama, at malaikat ako en anggur enggen mbalik en yiluk eyaga savit ako wolok wen vaga wambu wagya higi. Wambu wagya lagarik, anggur enggen ako ovok erogo mbalogo baluk, wonggalogo Ala aninis en sovalinivupwak yiluk, sovalinivisigama ombok akoma mabagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","Mabagya lagama, anggur enggen amburup sovalinivisigama o kota leget weram akoma sovalbugu hegek, avakwa enamuya is nggut hak yanggadit inggya dugwit, aguruk wisane kuda unggul wane-wane agya lagarik, atok o adumu tiga ratus kilometer wane-wane ari lagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","Andi okbaluk, hivis mbogot vaga andoma ninilup arup enalon werek menda modok iya ogagya higi. Ogagya higya dugwit, malaikat eneyave 7 en atok vaga avakwa edup ogonuvupwak yiluk, adwanggak adem 7 andok agarwik inigis. It malaikat 7 yi en avakwa edup ogonuvupwak yiluk, adwanggak adem 7 enovaga bisa warimi ako, atok vaga okbisaup menda aro. Atok vaga okbugu iniselok, okbaluk, Ala aninis ombasiga ako wotok erogo dek agya dogomindik, endawi seve yisogon, higi. ");
INSERT INTO nbq_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","Higya lagirik, inamut ombok yanggadek laut ovagak ovara, elose wukagak kaca yendela ogarek herek damok ogasiga anggelekma en hali abya wunggu higi. Higya lagirik, werekma, avakwa inamut ombok yanggadek ako omban vaga mendek agarwik inigis. It avakwa ako en yangge endak daga waga ako inim, agut wakhegek huvuwak ogovak higirik ako inim, ininis siyabagatek. Eke, at inis ininggis enembet vaga dirup warup ako wegetek dugwit, Ala inis adigat siyabagao ako en, inamut ombok yanggadek ako omban vaga mendek agarwik inigis. Nggindar ombok Ala en wogeraga ininggimu vagogo dugwit, nggindar ako ane ogagwi, ");
INSERT INTO nbq_vpl VALUES ("RV15_3","096_15_3","REV","15","3","3","eke, Ala inis siyabagu dugwit, ndawi watwis, ogagu-sigis. Ndawi watu dugwit, ndawi Ndomba Eyak ako en yagagi inim, ndawi Ala ayeloman Musa en yagagi inim, watu-sigis. Ndawi watao andi eyave yerogo: “Nenasin Ala hanye adigat agindik, Hat ogasiga ako andi, mondok iya erogo ogagya, nggarogo ogarubuk menda ogagya, Yi avakwa ndi avakwa enasin hinis ombok dugwit, mondok eyave atma nggedok adigat ogagya, ogasiga o. ");
INSERT INTO nbq_vpl VALUES ("RV15_4","096_15_4","REV","15","4","4","Nenasin o, Hat hadigat sek adik denekma, Avakwa ovok erogo hat hagayuk wutwis, Hat hinis siyabagagwi, ogarusogom o. Hat modok atma nggedok adigat ogasiga ako, sigam agyama, yi avakwa ndi avakwa ovok erogo Havema seve yi wakluk, hinis siyabagagu dogosogom o,” yiluk, ndawi watwis inigis. ");
INSERT INTO nbq_vpl VALUES ("RV15_5","096_15_5","REV","15","5","5","Andi watwis inugu lagirik, Ala ninim agarik ombarupwak yiluk, Ala awi eravo valek mbogot vaga agarik ako, sup hurik higi. ");
INSERT INTO nbq_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","Higya lagirik, akoma en malaikat eneyave 7 ako en avakwa edup-mbedup okbisaup adwanggak adem 7 ako, wolok wulu wagu inigis. It ako sogwes yum adup modok mudu abya amumulip ogarek yirik, eke, mbup nggetalek obak mbusi emas vaga ogovak higirik eneyave vaga yirik agarwik inigis. ");
INSERT INTO nbq_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","Inugu lagirik, nil neyagek, it avakwa en iniselagwidek menda eneyave 4 ako ambi en sogolowak mbusi emas vaga ogovak higirik 7 akoma it malaikat eneyave 7 ako wogirigya higi. Sogolowak 7 ako at Ala iluk modok itok agarik aninis avakwa enovaga bisamwak yiluk, elagap vaga erogo nudik higi. ");
INSERT INTO nbq_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","Wogirigya lagama, Ala modok anye wisanema, eyave awiya wisane ogagya vaga en yuvuk wisane wunggu dugwit, Ala awi valekma akoma hobo-hobo agya higi. It malaikat eneyave 7 ako en edup okbisaup adwanggak adem 7 avakwa enovaga okbisaup ako, wotok erogo okbigitek inigik, avakwa o mbogot vaga andoma Ala awi valekma andoma nunggup dek at agya higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","Andi ogagya higya lagirik, Ala awi valekma en ane ombok ambi it malaikat eneyave 7 ako yugirigya dugwit, “Ala aninis sogolowak 7 vaga nudik andi, wolok, avakwa wen vaga agarwik andi, enovaga ndilogo wombabisa elales o,” yiluk, yugirigya hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","Yugirigya lagama, at malaikat ambi en Ala aninis sogolowak vaga nudik ako, wolok wen vaga ndilogo wombabagya higi. Ndilogo wombabagya lagama, it avakwa yangge inis enembet vaga dirup mbalek agarwik ako inim, at agut wakhegek ogovak higirik inis siyabagwi ako inim, ovok erogo himbis edup ombok enovaga ndan iri lagama, avakwa en agoda wisane yugwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","Malaikat en Ala aninis sogolowak vaga nudik ako ndilogo wombabagya lagama, aswe ambi en sogolowak vaga nudik ako is ombok yanggadek laut ako vaga ndilogo wombabagya higi. Ndilogo wombabagya lagama, is ako ap nggorak enamuya ovagak agya dugwit, is endawima yi menda ndi menda iniluk agaruk menda ovok erogo hambit lagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","Malaikat mberen ako en Ala aninis sogolowak vaga nudik ako, mondok ndilogo wombabagu lagaoma, aswe ambi en sogolowak vaga nudik ako wolok is landigama inim, is liri-liris wulu wandigama inim, ndilogo wombabagya higi. Ndilogo wombabagya lagama, is andi ovok erogo muya ovagak agya lagama, ");
INSERT INTO nbq_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","at malaikat is andi, vagago agarik ako en iri dugwit, “Endak welagagin, yogak agindik, Hat nasin Ala hadik denek sek adigat dugwit, mondok eyave atma nggedok adigat ogasiga atma, It weyak ogwagao enowak ndilogo onggo haninis enovaga baliga yi andi, sek at ogagya heyagi o. ");
INSERT INTO nbq_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","It Hat Ala haburi hake denek inim, navi-navi inim, enamuya erogo initugwa ako, Onggo avakwa enamuya yi, is ovagak nunggu dogopwak yiluk, okbigin atma, sek at ogwagen o,” yiluk, iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","Iri lagama, Ala ake warogo hali hunisagwima akoma en ane iri dugwit, “Wene andi, avyarat yagas o. Hanye wisane adigat agindik nenasin Ala harat o. Avakwa ogasagwi enowak ndinggu dugwit, onggo modok wane-wane atma nggedok adigat okbisaliga atma, avyarat yagas o,” yiluk, iris naruk hunggis. ");
INSERT INTO nbq_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","Malaikat eneyave 3 ako en Ala aninis sogolowak vaga nudik ako ndilogo wombabagu lagaoma, ambi en sogolowak vaga nudik ako mo il vaga ndilogo lakbagas. Ndilogo lakbagya lagama, mo ako edup wisane agya dugwit, mo edup en avakwa yagal inivit lagya dogopwak yiluk, anye okbagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","Okbagya lagama, avakwa yagal inivit lagya halok, iren yugu dugwit, “Idup-mbedup yerogo obininaliga atma, nenomaluk mbo baluk, Ala inis siyabagu dogosogom o,” yiluk, yup sek arovara, hegek, enasam hegetek, enomaluk enendawi hunik okbetaluk dugwit, at edup-mbedup okbisaliga vagogo agarik Ala ako inis wiyiknom-weyaknom erogo baik lagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV16_10","096_16_10","REV","16","10","11","Eke, it malaikat eneyave 4 ako en Ala aninis sogolowak vaga nudik ako avakwa enovaga ndilogo wombabagu lagaoma, aswe ambi en sogolowak vaga ako yangge do ovagak ako wene yugeraligama akoma ndilogo wombabagya higi. Ndilogo wombabagya higya lagirik, nil neyagek, yangge ako avema bisaligama andoma o hwis iri lagama, at avema dugwit, ane welagwi menda ako, aup edup ombok enovaga agya, womak edup ombok enovaga ndan iris, oginipas. Oginipas ako, edup en enabya yaun hivitu dugwit, “Nenomaluk mbo basogon o,” yiluk, mbo baup sek arovara, hegek, enomaluk enendawi hunik okbetaluk dugwit, Ala inis wiyiknom-weyaknom erogo bagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV16_12","096_16_12","REV","16","12","12","It malaikat eneyave 5 ako en Ala aninis sogolowak vaga nudik ako sogolowak enadik-enadik ndilogo wombabagu lagaoma, aswe ambi en sogolowak vaga nudik ako is ombok inis Evarat vaga ndilogo wombabagya higi. Ndilogo wombabagya lagama, is ako betlaga. Is betlaga andi vaga it ap ininis ombok mo il wulu wandigama en warupwak yiluk, enarup yagogo bugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_13","096_16_13","REV","16","13","13","Higya lagirik, nil neyagek, duk ovagak madis weyak adigat eneyave henggam wulu wagwi inigis. Duk ovagak ambi andi, mbas ombok awigovak ovagak ako elagapma en wulu wagya, duk ovagak ambi, yangge do ovagak aninis werek ima en wulu waga ako elagapma en wulu wagya, eke, duk ovagak ambi andi yangge do ovagak vivis wen elola daga waga ako huluk wene molalogo yugeraliga menda ako elagapma en wulu wagya, wulu wagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV16_14","096_16_14","REV","16","14","14","It duk ovagak enelagapma en wulu wagao ako andi, madis Sile aori atma, avakwa enamusek warupwak yiluk, nggarogo ogarubuk menda ogarit lagwi inigis. Eke, it yi ap ndi ap ininis ombok o wen vaga agarwik ovok erogo At Ala ako inim ndup sumburuguluk homari warupwak yiluk, it duk ovagak ako andi yonggo lagwi inigis. Homari wagu dogomindik, At Anye Adigat Agarik Ala avakwa enowak ndilogo okbisaup hudi ako vaga, ndup sumburuguluk ogagu inigis. ");
INSERT INTO nbq_vpl VALUES ("RV16_15","096_16_15","REV","16","15","15","Andi higya lagirik, Nenasin en yuknugu dugwit, “Dibas! An ap onggop waliga ovagak mbikit supuk erogo warisogonma, avakwa inivaga ombokma en henagap mbedan lagwi hiniselok, henanggadi agwi hinisaowen, dibagu dogwes o. Henasum modok nggitik-nggetok okbetaluk, an nabyam werekma, An wagya neyalok, henendawi adenggen okhinipu hagup o,” yiluk, yuknugu higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_16","096_16_16","REV","16","16","16","Eke, it madis duk ovagak ako en ap wen vaga ininis ombok ovok erogo o inis Iberani enane vaga Haramagedon akoma at homakbisa wagwi inigis. ");
INSERT INTO nbq_vpl VALUES ("RV16_17","096_16_17","REV","16","17","17","Malaikat eneyave 6 ako en Ala aninis sogolowak vaga nudik ako modok ndilogo wombabagu lagaoma, ambi en sogolowak vaga nudik ako o ilim herok hena vaga yenam ndilogo wombabagya higi. Ndilogo wombabagya lagama, Ala wene yugeraligama Ala awi valekma en ane ombok ambi iri dugwit, “Ovok erogo ogwagi o,” yiluk, iri higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_18","096_16_18","REV","16","18","18","Iri lagama, o bigavok modok hunik-hunik ogagya, o unggulane ombok wisane iris, o wadok modok ombok ogagya, higi. O wadok andi, muk avakwa wakhagagi hudi en, waga-waga, yogak hudi vaga anderogo ogagatek ovara, o wadok modok ombok wisane ogarit wagya dugwit, wen modok avut enden-vanden ogagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_19","096_16_19","REV","16","19","19","Andi ogagya higya lagirik, werekma, o kota ombok ako wen modok mbet lagya dugwit, henggam etap mogolagya, eke, yi awi ndi awi wen vaga kota-kota ako ovok erogo mondok masok-danggok erogo dek erogo bagya, ogagya higi. Ogagya hegek, At Ala en, “O kota ombok Babel ako andi, at weyak ogasiga onggo anggur amburup nudik hak An naninis adigat ombasiga nudik ako, yogak at ovaga ndilogo baliga,” yiluk, ndilogo wombabagya higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_20","096_16_20","REV","16","20","20","Ndilogo wombabagya hegek, is enggema wen hudi mbalekma inim, ndom-ndom inim, ovok erogo dek agya higi. ");
INSERT INTO nbq_vpl VALUES ("RV16_21","096_16_21","REV","16","21","21","Dek agya hegek, o musu hol es salyu ombok-ombok adigat anggin wakhigya dugwit, 40 kilo hak mbogot vag