﻿USE sofia;
DROP TABLE IF EXISTS sofia.naw_vpl;
CREATE TABLE naw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES naw_vpl WRITE;
INSERT INTO naw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kanan mʋ nɩɩ Yesu Krisito kakʋʋgɛ tɔ kɩnaana ki du ndee. Yesu Krisito lɩɩ Owura Dawidi kanaan tɔ, nɩɩ Dawidi mɔɔ lɩɩ Abraham kanaan tɔ. ");
INSERT INTO naw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham mu‐bii ɩ gyɛ Isaki, nɩɩ Isaki mu‐bii ɩ gyɛ Gyekobu, nɩɩ Gyekobu mɔɔ mu‐bii ana ɩ gyɛ Gyuda maa mu‐supu ana. ");
INSERT INTO naw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Gyuda mu‐bii ana ɩ gyɛ Peresi maa Sera, nɩɩ bamʋ‐nyi ɩ gyɛ Tama. Peresi mu‐bii ɩ gyɛ Hesiron, nɩɩ Hesiron mɔɔ mu‐bii ɩ gyɛ Ram. ");
INSERT INTO naw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Nɩɩ Ram mu‐bii ɩ gyɛ Aminada, nɩɩ Aminada mu‐bii ɩ gyɛ Naason, nɩɩ Naason mu‐bii ɩ gyɛ Salimon. ");
INSERT INTO naw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nɩɩ Salimon mu‐bii ɩ gyɛ Bowasi, nɩɩ mu‐nyi ɩ gyɛ Rahabu, nɩɩ Bowasi mu‐bii ɩ gyɛ Obedi, nɩɩ mu‐nyi ɩ gyɛ Rufu, nɩɩ Obedi mu‐bii ɩ gyɛ Gyeese. ");
INSERT INTO naw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Nɩɩ Gyeese mu‐bii ɩ gyɛ Owura Dawidi. Nɩɩ Owura Dawidi taa ɔkyɩɩ mʋ nɩɩ ɔ daa ɔ gyɛ Yuriya mʋ‐ka kʋʋgɛ Solomon. ");
INSERT INTO naw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon mu‐bii ɩ gyɛ Rehobowam, nɩɩ Rehobowam mu‐bii ɩ gyɛ Abigya, nɩɩ Abigya mu‐bii ɩ gyɛ Asa. ");
INSERT INTO naw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Nɩɩ Asa mu‐bii ɩ gyɛ Gyehosafati, nɩɩ Gyehosafati mu‐bii ɩ gyɛ Gyehoram, nɩɩ Gyehoram mu‐bii ɩ gyɛ Yusiya. ");
INSERT INTO naw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Nɩɩ Yusiya mu‐bii ɩ gyɛ Gyotam, nɩɩ Gyotam mu‐bii ɩ gyɛ Ahasi, nɩɩ Ahasi mu‐bii ɩ gyɛ Hesekiya. ");
INSERT INTO naw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Nɩɩ Hesekiya mu‐bii ɩ gyɛ Manase, nɩɩ Manase mu‐bii ɩ gyɛ Amon, nɩɩ Amon mu‐bii ɩ gyɛ Gyosiya. ");
INSERT INTO naw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nɩɩ Gyosiya mu‐bii ɩ gyɛ Gyekoniya maa mu‐supu ana. Kanan saŋa maŋa nɩɩ Babilon abi ba kɔ kɩtaa Ɩsɩrayɩ abi waa bamʋ anyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nɩɩ lɩɩ saŋa mʋ nɩɩ ba yɛgɛ Ɩsɩrayɩ abi mʋ nɩɩ ba kɩtaa kpee Babilon naa fʋʋ saŋa mʋ nɩɩ ba kʋʋgɛ Yesu mʋ, ɩmʋ kakʋʋgɛ tɔ nkyaga sʋ ndee. Gyekoniya mu‐bii ɩ gyɛ Selatiye, nɩɩ Selatiye mu‐bii ɩ gyɛ Serubabeli. ");
INSERT INTO naw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nɩɩ Serubabeli mu‐bii ɩ gyɛ Abiyudi, nɩɩ Abiyudi, mu‐bii ɩ gyɛ Eliyakim, nɩɩ Eliyakim mu‐bii ɩ gyɛ Aso. ");
INSERT INTO naw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso mu‐bii ɩ gyɛ Sadoki, nɩɩ Sadoki mu‐bii ɩ gyɛ Akim, nɩɩ Akim mu‐bii ɩ gyɛ Eliyudi. ");
INSERT INTO naw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Nɩɩ Eliyudi mu‐bii ɩ gyɛ Eleyasa, nɩɩ Eleyasa mu‐bii ɩ gyɛ Matan, nɩɩ Matan mu‐bii ɩ gyɛ Gyekobu. ");
INSERT INTO naw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nɩɩ Gyekobu mu‐bii ɩ gyɛ Gyosefu, Mɛɛrɩ mu‐kuli mʋ. Nɩɩ Mɛɛrɩ maŋa ɩ kʋʋgɛ Yesu mʋ nɩɩ bɛɛ tɩɩ yɛ Krisito mʋ. ");
INSERT INTO naw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ɩmʋ sʋ lɩɩ Abraham saŋa naa fʋʋ Owura Dawidi kanaana tɔ kakʋʋgɛ nkyaga sʋ mʋ ɩ gyɛ kudu ana. Nɩɩ lɩɩ Dawidi naa fʋʋ saŋa mʋ nɩɩ ba kɩtaa bamʋ waa anyɛ mʋ kanaana tɔ kakʋʋgɛ nkyaga sʋ ɩ gyɛ kudu ana. Nɩɩ lɩɩ saŋa mʋ nɩɩ ba yɛgɛ Ɩsɩrayɩ abi lɩɩ Babilon naa fʋʋ Krisito kakʋʋgɛ saŋa mʋ gbaa gyɛ kanaana tɔ kakʋʋgɛ nkyaga sʋ kudu ana. ");
INSERT INTO naw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Krisito kakʋʋgɛ asɩn ndee. Ba taa mu‐nyi Mɛɛrɩ sa Gyosefu kekili, amaa pɔyɩ kɛ ba bɩɩ abaa mʋ, ɩ ba fɛɛ ɔkyɩɩ mʋ sʋ ɔtɔ, nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ ɩ yɛgɛ nɩɩ ɩ ba kanɩn. ");
INSERT INTO naw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gyosefu mʋ nɩɩ ɔ gyɛ mu‐kuli mʋ gyɛ ɔsa mʋ nɩɩ mʋ ɩkpa i kyiigi, nɩɩ maa mee biti fɛɛ ɔ ŋaabaa Mɛɛrɩ asa nsana tɔ sʋ mʋ, ɔ waa mʋ nfɛɛrɛ fɛɛ ee biti ɔ baala kina mʋ. ");
INSERT INTO naw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Amaa Gyosefu, maa fɛ falɛ nfɛɛrɛ mʋ, nɩɩ Ɔnyɩrɩpɛ Ɩbwaarɛ kabɔɔ lɛɛ mʋ n‐yɩɩ kaapʋ mʋ idee tɔ tɔwɛ mʋ yɛ, “Gyosefu, Dawidi kanaana‐bii, man waa kufuu fɛɛ fʋ mɛɛ yɛ fʋ taa Mɛɛrɩ kili, lɩɩ fɛɛ Kayaayu Kyɩrɛkyɩrɛ mʋ ɩ yɛgɛ nɩɩ ɔ nyɛ ɔtɔ. ");
INSERT INTO naw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ee biti ɔ kʋʋgɛ obii‐nyɩnsa, kɛ fʋ yɩla mʋ kɩtɩɩ yɛ Yesu, kpalɩ fɛɛ mʋ ii biti ɔ ba mɔlɩgɛ mʋ asa lɩɩ bamʋ alibi tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɩnɩmʋ kpini ɩ ba waa, kɛ ɩ ba tɔ fɛɛ kanan mʋ nɩɩ Ɔnyɩrɩpɛ bɔla mʋ ɔtɔwɛpʋ sʋ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kibite mʋ nɩɩ ɔ man nyi ɔnyɩn ii biti ɔ nyɛ ɔtɔ kʋʋgɛ obii‐nyɩnsa, kɛ ba tɩɩ mʋ yɛ Emanuweli,” kɩmʋ kasɛ ɩ gyɛ yɛ, “Ɩbwaarɛ bʋ anɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ɩmʋ sʋ Gyosefu maa kyiŋi mʋ, o kili Mɛɛrɩ taa mʋ kpee mʋ kɩkpaara sʋ fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ kabɔɔ sa kɔnɔ yɛ ɔ waa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amaa Gyosefu man dɛ yɛ Mɛɛrɩ halɩɩ naa fʋʋ saŋa mʋ nɩɩ ɔ kʋʋgɛ obii‐nyɩnsa mʋ. Nɩɩ Gyosefu yɩla mʋ kɩtɩɩ yɛ Yesu. ");
INSERT INTO naw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Saŋa mʋ nɩɩ ba kʋʋgɛ Yesu Krisito Betilehem kadɛ mʋ nɩɩ kɩ bʋ Gyudeya ɔsʋwʋlɛ sʋ mʋ, kanɩn saŋa maa mʋ Herodi ɩ gyɛ owura. Nɩɩ ɩ ba fɛɛ, anyaasɩnpʋ akʋ ba lɩɩ kyɔwɛ ɩlɩɩ ba Gyerusalem kadɛ tɔ, ");
INSERT INTO naw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nɩɩ ba taasɛ yɛ, “Nkɩɩ kebii mʋ nɩɩ ba kʋʋgɛ mʋ yɛ o be gyii Gyiwu abi kuwura mʋ? An wu mu kikyikpebi maa paatɛ lɩɩ kyɔwɛ kɩlɩɩ, nɩɩ an ba yɛ an be muŋa bʋnyaa mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Owura Herodi maa nu falɛ asɩn mʋ ɩɩ tɔɔrɔɔ mʋ gaa yɛ Gyerusalem abi kpini. ");
INSERT INTO naw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nɩɩ ɔ tɩɩ Ɩbwaarɛ aseepu abɩlɩsa yɛ nbara akaapʋpʋ ba gyaŋɛ, nɩɩ ɔ taasɛ bamʋ yɛ, “Fɩnɛ nɩɩ bee biti ba kʋʋgɛ Krisito abɛɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ?” ");
INSERT INTO naw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nɩɩ ba lɛɛ mʋ kɔnɔ yɛ, “Bee biti ba kʋʋgɛ mʋ Betilehem kadɛ tɔ Gyudeya Ɔsʋwʋlɛ sʋ.” Lɩɩ fɛɛ Ɩbwaarɛ ɔtɔwɛpʋ kʋ wʋla kyʋrɔɔ yɩla yɛ, ");
INSERT INTO naw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Fʋ Betilehem mʋ nɩɩ fʋ bʋ Gyudeya ɔsʋwʋlɛ sʋ, halɩɩ fʋ maa gyɛ pɩɩ gbaa mʋ, fʋ gyɛ ɔkparɛ lɩɩ fɛɛ fʋ tɔ nɩɩ owura lala mʋ ii biti ɔ lɩɩ, nɩɩ mʋ ee biti ɔ baa ɔ gyɛ fɛɛ nbʋlʋpʋ ɔkpapʋ sa mɛ asa Ɩsɩrayɩ abi.” ");
INSERT INTO naw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tʋtɔ nɩɩ Owura Herodi tɩɩ anyaasɩnpʋ mʋ lɩɩ ɩkaa sʋ, nɩɩ ɔ taasɛ bamʋ kɛ ɔ bɩɩ saŋa mʋ nɩɩ ba wu kikyikpebi maa lɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nɩɩ o sun bamʋ Betilehem tɔwɛ yɛ, “Fan kpee naa kɩɩ danbɩrasa biti kebii mʋ. Nɩɩ fan kan wu mʋ mʋ fan ba tɔwɛ mɛ, kɛ ngbaa mɛ n kpee naa muŋa bʋnyaa mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ba maa nu Owura mʋ asɛ lʋwɛ nɩɩ ba maa sʋ bee kpee mʋ, opula tɔ nɩɩ ba bwii wu kikyikpebi mʋ nɩɩ ba daa wu kyɔwɛ kɩlɩɩ mʋ, nɩɩ kɩ gyankpaa bamʋ kpee naa yɩlɛ opula mʋ nɩɩ kebii mʋ bʋ mʋ sʋsʋ kyɛɛkyɛɛ. ");
INSERT INTO naw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Saŋa mʋ nɩɩ ba wu kikyikpebi mʋ, bamʋ ansi i gyii naa kyʋn sʋ. ");
INSERT INTO naw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba maa loo kɩkpaara mʋ sʋ mʋ, ba wu kebii mʋ maa mu‐nyi Mɛɛrɩ, nɩɩ ba kyʋn muŋa sun mʋ. Nɩɩ ba saŋɛ bamʋ ɩsʋla nɩɩ ba lɛɛ suwa yɛ tulale mʋ nɩɩ bɛɛ tɩɩ yɛ firanki‐ɩnsɛnsɩ yɛ tulale mʋ nɩɩ bɛɛ tɩɩ yɛ mɩɩrɛ kɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kamaa tɔ mʋ Ɩbwaarɛ da bamʋ amu tɔ idee tɔ yɛ ba man bɩla bwii kpee Owura Herodi asɛ, ɩmʋ sʋ ba bɔla ɔkpa pʋpwɛ sʋ bwii kpee bamʋ ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ba maa kyʋn kamaa mʋ, Ɔnyɩrɩpɛ Ɩbwaarɛ kabɔɔ ba lɛɛ mʋ n‐yɩɩ kaapʋ Gyosefu idee tɔ tɔwɛ mʋ yɛ, “Kʋsʋ taa kebii mʋ maa mu‐nyi sɩlɛ kpee Egyipiti naa kyɩna tʋtɔ naa fʋʋ saŋa mʋ nɩɩ n biti n tɔwɛ fanɛ yɛ fan lɩɩ tʋtɔ. Lɩɩ fɛɛ Herodi ɩɩ kɩɩ ee biti kebii mʋ ɔ mɔɔ.” ");
INSERT INTO naw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ɩmʋ sʋ ɔ kʋsʋ taa kebii mʋ maa mu‐nyi kagyanbwɛ nɩɩ ba sɩlɛ kpee Egyipiti. ");
INSERT INTO naw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tʋtɔ nɩɩ ba kyɩna naa fʋʋ saŋa mʋ nɩɩ Herodi wu. Ɩnɩmʋ ɩ yɛgɛ nɩɩ asɩn mʋ nɩɩ Ɔnyɩrɩpɛ Ɩbwaarɛ bɔla mʋ ɔtɔwɛpʋ sʋ tɔwɛ mʋ ba tɔ. Ɩmʋ ɩ gyɛ yɛ, “Lɩɩ Egyipiti tɔ nɩɩ n tɩɩ Mi‐bii.” ");
INSERT INTO naw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Owura Herodi maa bɩɩ fɛɛ anyaasɩnpʋ mʋ ba pɩna mʋ mʋ, ɔ nyɛ agbʋ gaa. Nɩɩ ɔ sa kɔnɔ yɛ ba mɔɔ nbii‐nyɩnsa‐bii mʋ nɩɩ ba man pɩɩta kyʋn nsu nnyɔ sʋ, nɩɩ ba bʋ Betilehem yɛ ndɛ mʋ nɩɩ ɩ kyaabɔɔ kɩmʋ mʋ kpini. Ɔ yɛgɛ nɩɩ ba waa kanɩn nɩn lɩɩ fɛɛ saŋa mʋ nɩɩ anyaasɩnpʋ mʋ ba tɔwɛ mʋ yɛ ba wu kikyikpebi mʋ, ii biti ɩ waa fɛɛ nsu nnyɔ. ");
INSERT INTO naw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ɩmʋ sʋ asɩn mʋ nɩɩ Ɔnyɩrɩpɛ Ɩbwaarɛ bɔla mʋ ɔtɔwɛpʋ Gyeremiya sʋ tɔwɛ mʋ ba tɔ. Ɩmʋ ɩ gyɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ba nu kusu ɩlʋn kʋ lɩɩ Rama kadɛ tɔ, ɩɩ saawʋ yɛgɛ ɩ sʋ kʋwɛɛ, Raheli ɛɛ sawʋ ee su mu‐bii ana sʋ. Asa ba tɔwɛ yuula mʋ kɔkɔlɔ kpɩnɛ, lɩɩ fɛɛ mu‐bii ana ba wu.” ");
INSERT INTO naw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Owura Herodi kelewu kamaa mʋ, Ɔnyɩrɩpɛ Ɩbwaarɛ kabɔɔ lɛɛ mʋ n‐yɩɩ kaapʋ Gyosefu idee tɔ Egyipiti ɔsʋwʋlɛ sʋ, ");
INSERT INTO naw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","nɩɩ ɔ tɔwɛ mʋ yɛ, “Kʋsʋ taa kebii mʋ maa mu‐nyi bwii kpee Ɩsɩrayɩ ɔsʋwʋlɛ sʋ, lɩɩ fɛɛ bamʋ nɩɩ ba daa bee biti ba mɔɔ kebii mʋ ba wu.” ");
INSERT INTO naw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ɩmʋ sʋ ɔ kʋsʋ taa kebii mʋ maa mu‐nyi kpee Ɩsɩrayɩ ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amaa maa nu yɛ Akelasi i yii mʋ‐sɛ Herodi ayaa tɔ ee gyii kuwura Gyudeya mʋ, kufuu kɩ kɩtaa mʋ yɛ tʋtɔ kikpe. Ɩbwaarɛ maa da mu kumu tɔ idee tɔ sʋ mʋ, o kpeli kpee Galile kɩbaafʋn. ");
INSERT INTO naw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nɩɩ ɔ naa kyɩna Nasareti kadɛ mʋ tɔ. Ɩnɩmʋ ɩ yɛgɛ nɩɩ asɩn mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ tɔwɛ lɩɩ kebii mʋ sʋ mʋ ba tɔ. Asɩn mʋ ɩ gyɛ yɛ, “Bee biti ba tɩɩ mʋ yɛ Kanasareti‐nyɩn.” ");
INSERT INTO naw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kanɩn saŋa maa mʋ, Gyɔn mʋ nɩɩ ee gyee asa Ɩbwaarɛ kekyugyee mʋ, ba Gyudeya ofuli sʋ ɛɛ tɔwɛ abwaarɛsɩn ɛɛ sa asa ");
INSERT INTO naw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","yɛ, “Fan yɛgɛ alibi kɩwaa, lɩɩ fɛɛ Ɩbwaarɛ kuwura‐gyii mʋ ki tiri tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Gyɔn nɩmʋ asɩn nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Isaya wʋla kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ mʋ yɛ, “Ɔsa kʋ bʋ ofuli sʋ ee kuusi ɛɛ tɔwɛ yɛ, ‘Fan lɔŋɔ Ɔnyɩrɩpɛ ɔkpa mʋ, kɛ fan waa ɔkpa mʋ ntintin sa mʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nyɔɔma ifuu nɩɩ ba taa waa Gyɔn atɔ bunsa, nɩɩ kʋtɔbwaaya ɔwʋlɛ kɩrɩsʋ i ŋmina mʋ kasɩyɛ tɔ. Mʋ agyitɔ‐gyisa mɔɔ ɩ gyɛ ntuntunbi yɛ ŋmasan. ");
INSERT INTO naw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Asa ba lɩɩ Gyerusalem kadɛ tɔ yɛ Gyudeya ɩsʋwʋlɛ sʋ yɛ Gyɔdan kabaafʋn kpini ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba lɛɛ bamʋ alibi tɔwɛ, nɩɩ o gyee bamʋ Ɩbwaarɛ kekyugyee Gyɔdan ɔbʋn mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Gyɔn maa wu Farasii yɛ Sadusi abi gaalaagaa ba maa ba mʋ asɛ, kɛ o gyee bamʋ kekyugyee mʋ, ɔ taasɛ bamʋ yɛ, “Fanɛ anansɛ banɩmʋ, anɩmʋ ɩ tɔwɛ waa fanɛ yɛ fan sɩlɛ lɩɩ Ɩbwaarɛ agbʋ mʋ nɩɩ ɩɩ ba asa sʋ mʋ tɔ? ");
INSERT INTO naw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Fan waa atɔ mʋ nɩɩ ɩ dagaa kɛ ɩɩ kaapʋ fɛɛ fan yɛgɛ alibi kɩwaa. ");
INSERT INTO naw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Fan man da fanɛ nkɔlɔ sʋ tɔwɛ yɛ, ‘Anɛ naana ɩ gyɛ Abraham ɩmʋ sʋ an sʋ kamɔlɩgɛ.’ N tɔwɛ fanɛ kesintin fɛɛ Ɩbwaarɛ ɩ taalɛ taa abuu nɩmʋ biliŋi anaana‐bii sa Abraham. ");
INSERT INTO naw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nbɩɩnbɩɩ bɩrɛ, Ɩbwaarɛ wʋla taa kpanfa yɩla iyu mʋ ilin tɔ o gyoo. Nɩɩ oyu kʋmaa mʋ nɩɩ kɩ mɛɛ sɔyɩ abi mʋ, bee biti ba ŋɛ kɩmʋ tʋʋ kɛ ba taa waa fʋlɔn tɔ. ");
INSERT INTO naw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nkyu nɩɩ mɛɛ mɛ n sʋ n gyee fanɛ Ɩbwaarɛ kekyugyee kɛ ɩɩ kaapʋ fɛɛ fan yɛgɛ alibi kɩwaa. Amaa ɔmʋ nɩɩ ɔ bʋ mɛ kamaa ɛɛ ba mʋ kyɔ mɛ gaa, nɩɩ n man dagaa gbaa fɛɛ n sʋla mʋ asɩbɩta. Mɛɛ mʋ bɩrɛ Kayaayu Kyɩrɛkyɩrɛ yɛ fʋlɔn nɩɩ ee biti ɔ taa gyee fanɛ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɔ sʋ mʋ kʋtɔ kyaalɛsa mʋ kɩbaa tɔ, kɛ ɔ kyaalɛ ayubi mʋ lɛɛ afʋnfʋntɛɛ mʋ tɔ waa kikyunkun tɔ. Ee biti ɔ taa afʋnfʋntɛɛ mʋ waa fʋlɔn mʋ nɩɩ i mee dun mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tʋtɔ nɩɩ Yesu lɩɩ Galile ɔsʋwʋlɛ sʋ ba Gyɔdan ɔbʋn mʋ tɔ Gyɔn asɛ, kɛ o gyee mʋ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amaa Gyɔn kpan mʋ n‐yɩɩ kɛ ɔ kyɛɛgɛ Yesu nfɛɛrɛ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Fɛɛ fʋ ɩ dagaa fɛɛ fu gyee mɛ kekyugyee, nɩɩ fʋ ɩ ba mɛ asɛ yɛ n gyee fʋ?” ");
INSERT INTO naw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Yɛgɛ ɩ waa kanɩn nbɩɩnbɩɩ nɩmʋ, lɩɩ fɛɛ ɔkpa nɩmʋ sʋ nɩɩ ɩ dagaa a maa waa ɩmʋ nɩɩ Ɩbwaarɛ biti mʋ kpini.” Nɩɩ Gyɔn kyula gyee Yesu Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gyɔn maa dan gyee Yesu Ɩbwaarɛ kekyugyee lʋwɛ mʋ, Yesu lɩɩ ɔbʋn mʋ tɔ. Opula maŋa tɔ nɩɩ sʋsʋ bugi tɔ, nɩɩ o wu Ɩbwaarɛ Kayaayu Kyɩrɛkyɩrɛ maa kpɩlɩgɛ fɛɛ kuwura‐lɔpɔ ba gyɔŋɔ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nɩɩ ɔbʋlɛ kʋ lɩɩ sʋsʋ tɔwɛ yɛ, “Ɔnɩmʋ ɩ gyɛ mɛ kɔkɔlɔ tɔ obii‐bitisa, nɩɩ mʋ ɩ bɔla mi ansi.” ");
INSERT INTO naw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tʋtɔ nɩɩ Kayaayu mʋ sʋla Yesu kpee ofuli sʋ, kɛ Sɩtaanɛ ɔ naa tʋʋ mʋ tɔ kɩɩ. ");
INSERT INTO naw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Maa waa noŋmina nkɛ adɩna kakyʋwapɛ yɛ kagyanbwɛ mʋ, akʋn ɩɩ mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nɩɩ Sɩtaanɛ ba mʋ asɛ ba tɔwɛ mʋ yɛ, “Nɩɩ fʋ kan fʋ gyɛ Ɩbwaarɛ Mu‐Bii mʋ, tɔwɛ abuu nɩmʋ kɛ i biliŋi agyitɔ.” ");
INSERT INTO naw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ba kyʋrɔɔ waa Asɩnkyan yɩlɛsa mʋ tɔ yɛ, ‘Man gyɛ agyitɔ wʋlɛ nkʋn ɩɩ sa nyɩmɩsa nkpa, amɔɔ asɩn mʋ nɩɩ ɩɩ lɩɩ Ɩbwaarɛ kɔnɔ tɔ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tʋtɔ nɩɩ Sɩtaanɛ taa mʋ kpee Gyerusalem, kadɛ kyɩrɛkyɩrɛ mʋ tɔ naa yɩlɛ kabwaarɛ‐sunkpa ayɛ mʋ ketin tɔ sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nɩɩ ɔ tɔwɛ yɛ, “Nɩɩ fʋ kan fʋ gyɛ Ɩbwaarɛ Mu‐Bii mʋ, fugi tɩyɛ kasɛ. Lɩɩ fɛɛ ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘Ɩbwaarɛ ii biti ɔ sa mʋ nbɔɔ kɔnɔ lɩɩ fʋ sʋ, nɩɩ bee biti ba taa bamʋ abaa sɔgɩta fʋ, kɛ fʋ kɩyaa kɩ man nyɛ watɛ abuu.’ ” ");
INSERT INTO naw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu bwii lɛɛ kɔnɔ yɛ, “Ba bɩla kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘Man tʋʋ fʋ‐Nyɩrɩpɛ Ɩbwaarɛ tɔ kɩɩ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sɩtaanɛ bɩla taa mʋ kpee kɩbɩɩ lala kʋ sʋ, nɩɩ ɔ kaapʋ mu kuwura‐gyii kʋmaa mʋ nɩɩ kɩ bʋ dulinyaa nɩmʋ tɔ yɛ ɩmʋ bʋnyaa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nɩɩ ɔ tɔwɛ yɛ, “Nɩɩ fʋ kan muŋa sun mɛ mʋ, n biti n taa ɩnɩmʋ kpini sa fʋ.” ");
INSERT INTO naw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Sɩtaanɛ, natɛ lɩɩ mɛ asɛ. Lɩɩ fɛɛ ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘Muŋa sun fʋ‐Nyɩrɩpɛ Ɩbwaarɛ, nɩɩ mʋ nkʋn nɩɩ fu sun.’ ” ");
INSERT INTO naw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tʋtɔ nɩɩ Sɩtaanɛ yɛgɛ mʋ, nɩɩ Ɩbwaarɛ nbɔɔ ba ba kyɛ Yesu tɔ. ");
INSERT INTO naw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu maa nu yɛ ba kɩtaa Gyɔn tii obu mʋ, o bwii kpee Galile. ");
INSERT INTO naw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nɩɩ ɔ lɩɩ Nasareti kpee Kapanum kadɛ tɔ naa kyɩna. Kadɛ maŋa bʋ Galile ɔbʋn lala ɔkaa, Sebulun maa Nafitali kabaafʋn mʋ. ");
INSERT INTO naw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɩ waa kanan nɩn kɛ asɩn mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Isaya tɔwɛ lɩɩ ndɛ maŋa sʋ mʋ ɩ ba tɔ. Asɩn mʋ ɩ gyɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun ɔsʋwʋlɛ yɛ Nafitali ɔsʋwʋlɛ, ndɛ mʋ nɩɩ ɩ bʋ ɔkpa mʋ nɩɩ kii kpee ɔpʋ asɛ, ndɛ mʋ nɩɩ ɩ bʋ Gyɔdan benbe mʋ, bamʋ nɩɩ ba man gyɛ Gyiwu abi nɩɩ ba bʋ Galile, ");
INSERT INTO naw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","asa mʋ nɩɩ ba tɛ kitentenbiri tɔ mʋ, ba wu kɩŋmaŋɛsa kparɛ mʋ. Asa mʋ nɩɩ ba tɩyɛ lewu kitentenbiri ɔsʋwʋlɛ sʋ mʋ, kɩŋmaŋɛsa kɩ lɩɩ bamʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lɩɩ kanɩn saŋa maŋa nɩɩ Yesu piili ɛɛ tɔwɛ asɩn danbɩrasa mʋ yɛ, “Fan yɛgɛ alibi kɩwaa, lɩɩ fɛɛ sʋsʋ kuwura‐gyii mʋ ki tiri tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu maa kyɩna ɔ naa Galile ɔpʋ sʋ mʋ, o wu ɩkɩn akɩtapʋ anyɔ, Simon mʋ nɩɩ ba bɩla bɛɛ tɩɩ mʋ yɛ Pita yɛ mu‐supu Andiruwu yɛgɛ bɛɛ tʋʋ kɩsawu ɔpʋ mʋ tɔ bɛɛ kɩtaa ɩkɩn. ");
INSERT INTO naw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan ba buu mɛ, kɛ n waa fanɛ asa akɩtapʋ.” ");
INSERT INTO naw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nɩɩ opula maŋa tɔ ba yɛgɛ bamʋ asawu mʋ, nɩɩ ba buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Maa kyaga sʋ ee kpee mʋ, nɩɩ ɔ naa wu ɔkʋ maa mu‐supu, bamʋ ɩ gyɛ Gyemisi maa Gyɔn, Sebedi mu‐bii ana. Ba maa bamʋ‐sɛ Sebedi ba bʋ ɔkʋlɩ tɔ bɛɛ lɔŋɔ bamʋ asawu. Nɩɩ Yesu tɩɩ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Opula maŋa tɔ ba yɛgɛ ɔkʋlɩ mʋ yɛ bamʋ‐sɛ nɩɩ ba buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nɩɩ Yesu natɛ kyaabɔɔ Galile ɔsʋwʋlɛ sʋ ɛɛ kaapʋ asa asɩn danbɩrasa mʋ lɩɩ Ɩbwaarɛ kuwura‐gyii mʋ sʋ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa kʋmaa nɩmʋ tɔ yɛgɛ ɛɛ kyɛ alɔ kʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mʋ kɩtɩɩ ɩ yaasɛ loo Siriya ɔsʋwʋlɛ sʋ kpini, nɩɩ asa ba taa alɔpʋ mʋ nɩɩ ba sʋ alɔ yiri‐yiri bɩya mʋ. Akʋ bamʋ n‐yɩɩ tɔ ɩɩ kɔ bamʋ gaa, nɩɩ akʋ mɔɔ nbwɩɩ libi bɛɛ tɔɔrɔɔ bamʋ, akʋ bɛɛ lɔ kigbingbin, nɩɩ akʋ mɔɔ ba gyɛ amʋgʋlɛ‐mʋgʋlɛ, nɩɩ Yesu kyɛ bamʋ kpini. ");
INSERT INTO naw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Asa damantɛ ba lɩɩ Galile yɛ Dekapoli yɛ Gyerusalem yɛ Gyudeya yɛ Gyɔdan benbe kpini ba buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu maa wu sakyɔ mʋ, o dii kpee kɩbɩɩ‐bi kʋ sʋ naa kyɩna kɩmʋ sʋ, nɩɩ mʋ abɩɩlapʋ ba ba mʋ asɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nɩɩ o piili ɛɛ kaapʋ bamʋ ɛɛ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kusee ɩ gyɛ sa bamʋ nɩɩ ba taa bamʋ n‐yɩɩ tʋʋ Ɩbwaarɛ nkʋn sʋ, lɩɩ fɛɛ sʋsʋ kuwura‐gyii mʋ kɩ gyɛ bamʋ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kusee ɩ gyɛ sa bamʋ nɩɩ bɛɛ bɔɔta tɔ, lɩɩ fɛɛ bamʋ nɩɩ Ɩbwaarɛ ii biti o yuula bamʋ nkɔlɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kusee ɩ gyɛ sa bamʋ nɩɩ bɛɛ bɩya bamʋ n‐yɩɩ kasɛ, lɩɩ fɛɛ bamʋ ii biti ba gyii kasɛ mʋ fɛɛ bamʋ kapatɩyɛ. ");
INSERT INTO naw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kusee ɩ gyɛ sa bamʋ nɩɩ bamʋ ansi ɩɩ payɩ ɩkpa kikyiigi sʋ, lɩɩ fɛɛ bamʋ nɩɩ Ɩbwaarɛ ii biti ɔ yɛgɛ ba ŋmɛ lɩɩ bamʋ atɔ bitisa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kusee ɩ gyɛ sa bamʋ nɩɩ bee wu bamʋ bɩrɩsa ana kʋwɛɛ, lɩɩ fɛɛ bamʋ nɩɩ Ɩbwaarɛ ii biti o wu kʋwɛɛ. ");
INSERT INTO naw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kusee ɩ gyɛ sa bamʋ nɩɩ ineesi kʋ man bʋ bamʋ kɔkɔlɔ tɔ, lɩɩ fɛɛ bamʋ ii biti ba wu Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kusee ɩ gyɛ sa bamʋ nɩɩ bɛɛ bɩya keyuula asa nsana, lɩɩ fɛɛ bamʋ nɩɩ Ɩbwaarɛ ii biti ɔ tɩɩ yɛ Mu‐bii ana. ");
INSERT INTO naw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kusee ɩ gyɛ sa bamʋ nɩɩ ba nyanla bamʋ fɛɛ bamʋ ɩkpa maa kyiigi Ɩbwaarɛ asɛ sʋ mʋ, lɩɩ fɛɛ bamʋ nɩɩ sʋsʋ kuwura‐gyii mʋ kɩ gyɛ bamʋ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kusee ɩ gyɛ sa fanɛ mʋ nɩɩ asa bɛɛ saalɛ, nɩɩ bɛɛ nyanla fanɛ nɩɩ bɛɛ tɩn antɩŋɛsa bɛɛ tɔwɛ asɩn libi bɛɛ gyaga fanɛ sʋ, fɛɛ fan maa gyɛ mɛ abɩɩlapʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Fan yɛgɛ ɩ waa fanɛ ɔkɔn kɛ fanɛ ansi i gyii, lɩɩ fɛɛ fanɛ kʋkɔka lala kɩ dɛ ki gyoo fanɛ Ɩbwaarɛ ayɛ. Kpalɩ fɛɛ kanɩn maŋa nɩɩ ba daa nyanla Ɩbwaarɛ atɔwɛpʋ mʋ nɩɩ ba wʋla gyankpaa fanɛ ba mʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Fan du nɩn fɛɛ nfɔlɛ sa asa dulinyaa tɔ. Amaa nɩɩ nfɔlɛ kan pan ɩmʋ ɔkɔn mʋ, mɩnɛ nɩɩ fɩɩ bɩla taalɛ taa waa ɩmʋ kɛ ɩ waa ɔkɔn? Ɩ man bɩla ɩ sʋ kyaarɛ, amɔɔ ba taa kyɛɛgɛ fɔyɩ kɛ asa ba natɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Fan du nɩn fɛɛ ɩŋmaŋɛsa sa asa dulinyaa tɔ. Kadɛ lala mʋ nɩɩ kɩ gyan kɩbɩɩ sʋ mʋ mɛɛ taalɛ baala. ");
INSERT INTO naw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nɩɩ ɔkʋ mee tuwa fɩtɩla, kɛ ɔ taa waa kolobi tɔ. Amɔɔ ɔ taa gyaga fɩtɩla ɔgyagakpa kɛ kɩ baa kɩ kɩɩ ɔkʋmaa nɩmʋ tɔ kɩkpaara mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ɔkpa kʋlʋn maŋa sʋ fan yɛgɛ fanɛ ɩŋmaŋɛsa ɩ baa ɩ kɩɩ tɔ sa asa, kɛ ba wu fanɛ asun danbɩrasa mʋ nɩɩ fɛn waa mʋ, kɛ ba yɩn fanɛ‐Sɛ Ɩbwaarɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Fan man fɛ nfɛɛrɛ fɛɛ n ba nɩn kɛ n ba lɛɛ Mosesi nbara mʋ yɛ Ɩbwaarɛ atɔwɛpʋ kɩkaapʋ mʋ lɩɩ tɔ. N man ba nɩn kɛ n ba lɛɛ ɩmʋ lɩɩ tɔ, amaa n ba nɩn kɛ bamʋ kɩkaapʋ mʋ ɩ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","N tɔwɛ fanɛ kesintin yɛ, naa fʋʋ saŋa mʋ nɩɩ sʋsʋ yɛ kasɛ ii biti i muuri mʋ, halɩɩ nbara mʋ tɔ kʋkyʋrɔɔ‐bi pii gbaa, abɛɛ ɩmʋ kitobi mɛɛ yɛ ɩ kɔɔgɛ sʋ, amɔɔ kʋtɔ kʋmaa ii biti ɩ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ɩmʋ sʋ ɔkʋmaa mʋ nɩɩ o kina kibuu nbara mʋ tɔ kipii, nɩɩ ɛɛ kaapʋ asansa yɛ ba waa kanɩn mʋ, ee biti ɔ baa ɔ gyɛ ɔsa pii Ɩbwaarɛ kuwura‐gyii mʋ tɔ. Amaa ɔkʋmaa mʋ nɩɩ o buu nbara mʋ, nɩɩ ɛɛ kaapʋ asansa gbaa yɛ ba buu ɩmʋ mʋ, ee biti ɔ baa ɔ gyɛ nyɩmɩsa kparɛ Ɩbwaarɛ kuwura‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ɩmʋ sʋ n tɔwɛ fanɛ fɛɛ, nɩɩ fanɛ ɩkpa ɩ man kyiigi ɩ kyɔ nbara akaapʋpʋ yɛ Farasii abi mʋ, fan mɛɛ yɛ fan nyɛ loo Ɩbwaarɛ kuwura‐gyii mʋ tɔ kakaakʋ.” ");
INSERT INTO naw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesu bɩla tɔwɛ yɛ, “Fan nu Mosesi nbara mʋ maa tɔwɛ adɩdaapʋ mʋ yɛ, ‘Man kan mɔɔ nyɩmɩsa. Ɔkʋmaa mʋ nɩɩ ɔ mɔɔ nyɩmɩsa mʋ, bee biti ba bun mʋ kʋpwɛ.’ ");
INSERT INTO naw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amaa n tɔwɛ fanɛ yɛ, ɔkʋmaa mʋ nɩɩ ɔ nyɛ agbʋ waa mʋ tɔmaa mʋ, bee biti ba bun mʋ kʋpwɛ. Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ saalɛ mʋ tɔɔmaa yɛ ɔ man bʋ sɛhn tɔ mʋ, ee biti ɔ nyɛ asɩn Gyiwu kʋbʋ‐kʋbʋ abɩlɩsa mʋ nɩɩ bɛɛ tɩɩ yɛ Sanhediri mu ansi. Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ saalɛ mʋ tɔɔmaa yɛ, ‘Fʋ omelensipu nɩmʋ’ mʋ, ii biti o loo awʋrʋfɔ fʋlɔn yen‐yen tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ɩmʋ sʋ, nɩɩ fʋ kan bɩya fʋ saraga kɛ fʋ ba lɛɛ Ɩbwaarɛ kaswɩɩ sʋ, nɩɩ fu nyiŋi fɛɛ fʋ waa fʋ bɩrɩsa alibi kʋ mʋ, ");
INSERT INTO naw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yɛgɛ fʋ saraga yɩla tʋtɔ kɛ fu bwii kpee, kɛ faa fʋ bɩrɩsa mʋ fan lɔŋɔ abaa nsana, pɔyɩ kɛ fʋ bwii ba lɛɛ fʋ saraga mʋ sa Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nɩɩ ɔkʋ kan samaa fʋ asɩn ogyikpa mʋ, sun mata mʋ pɔyɩ asɩn kigyii kakɛ mʋ kɩ fʋʋ. Amaa nɩɩ ɩ man kan ba kanɩn mʋ, ee biti ɔ taa fʋ sa asɩn ogyipu mʋ, kɛ mɔɔ mʋ ɔ taa fʋ waa abu tiipu ɔkɩɩsʋpʋ abaa tɔ kɛ o tii fʋ obu. ");
INSERT INTO naw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","N tɔwɛ fʋ kesintin fɛɛ, fii biti fʋ baa fʋ bʋ tʋtɔ naa fʋʋ saŋa mʋ nɩɩ fii biti fʋ‐ka fʋ kʋkɔ mʋ lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Fan nu Mosesi nbara mʋ maa tɔwɛ yɛ, ‘Man waa kanyɩn biti abɛɛ kɩkyɩɩ biti kɩgyagaa.’ ");
INSERT INTO naw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amaa mɛ ɩ tɔwɛ fanɛ nɩn fɛɛ, ɔkʋmaa mʋ nɩɩ ɔ kɩɩ ɔkyɩɩ waa mʋ nfɛɛrɛ fɛɛ ɔ dɩn nyɛ maa mʋ ba bʋga nɩn, ɔ tɩyɛ waa kɩkyɩɩ biti alibi mʋ kɔkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ɩmʋ sʋ nɩɩ fu gyisa kinsi kii biti kɩ yɛgɛ kɛ fʋ waa alibi mʋ, kyɔlɛ kɩmʋ fɔyɩ. Ɩ bʋrɔn sa fʋ fɛɛ fʋ maa pan fʋ katɩn kʋ, ɩ kyɔ fɛɛ ba maa taa fʋ n‐yɩɩ kpini naa tʋʋ awʋrʋfɔ fʋlɔn yen‐yen tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nɩɩ fu gyisa kɩbaa kii biti kɩ yɛgɛ kɛ fʋ waa alibi mʋ, tɩn kɩmʋ fɔyɩ. Ɩ bʋrɔn sa fʋ fɛɛ fʋ maa pan fʋ katɩn kʋ, ɩ kyɔ fɛɛ ba maa taa fʋ n‐yɩɩ kpini naa tʋʋ awʋrʋfɔ fʋlɔn yen‐yen tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nɩɩ Mosesi nbara mʋ ba bɩla tɔwɛ yɛ, ‘Ɔkʋmaa mʋ nɩɩ o kina mʋ‐ka mʋ, dagaa maa kyʋrɔɔ kekina ɔwʋlɛ sa mʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amaa mɛ ɩ tɔwɛ fanɛ yɛ, ɔkʋmaa mʋ nɩɩ o kina mʋ‐ka nɩɩ ɩ man gyɛ yɛ ɔkyɩɩ mʋ lɩɩ mʋ kamaa mʋ, ɔ yɛgɛ ɔkyɩɩ mʋ waa alibi kekili tɔ. Nɩɩ ɔnyɩn kʋmaa mʋ nɩɩ o kili ɔkyɩɩ maŋa gbaa mʋ waa alibi kekili tɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Fan bɩla nu Mosesi nbara mʋ maa tɔwɛ adɩdaapʋ mʋ yɛ, ‘Man bɔ ntan kɛ fʋ laaŋɛ, amaa ɩ dagaa fʋ maa waa kanan mʋ nɩɩ fʋ bɔ ntan sa Ɔnyɩrɩpɛ Ɩbwaarɛ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amaa nbɩɩnbɩɩ mɛ ɩ tɔwɛ fanɛ yɛ, fan man bɔ ntan kpini‐kpini. Fan man taa sʋsʋ bɔ ntan, lɩɩ fɛɛ tʋtɔ ɩ gyɛ Ɩbwaarɛ kuwura‐gya. ");
INSERT INTO naw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Fan man taa kasɛ bɔ ntan, lɩɩ fɛɛ tʋtɔ ɩ gyɛ Ɩbwaarɛ ayaa ɔgyagakpa. Fan man taa Gyerusalem kadɛ bɔ ntan, lɩɩ fɛɛ kɩmʋ ɩ gyɛ Owura kparɛ mʋ kadɛ lala. ");
INSERT INTO naw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Man taa fu kumu bɔ ntan, lɩɩ fɛɛ fʋ mɛɛ taalɛ waa kinyinibi kʋlʋn kifufuli abɛɛ kilenbiri. ");
INSERT INTO naw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amaa fan yɛgɛ fanɛ katɔwɛ kɩ baa kɩ gyɛ Ɛɛhn abɛɛ ayee. Nɩɩ fʋ kan bɔ ntan kʋ tii sʋ mʋ, ɩ lɩɩ Sɩtaanɛ asɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nɩɩ fan bɩla nu Mosesi nbara maa tɔwɛ yɛ, ‘Nɩɩ ɔkʋ kan boyi ɔkʋ kinsi mʋ, ɩ dagaa be boyi ngbaa mʋ lɛɛ. Nɩɩ ɔkʋ kyiigi ɔkʋ kinyi mʋ, ɩ dagaa be kyiigi ngbaa mʋ lɛɛ.’ ");
INSERT INTO naw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amaa mɛ ɩ tɔwɛ fanɛ yɛ, nɩɩ ɔkʋ kan waa fʋ alibi mʋ, man taa alibi ka mʋ kʋkɔ. Nɩɩ ɔkʋ kan kpa fʋ ɔtan gyisa sʋ mʋ, biliŋaa bɩna sʋ sa mʋ kɛ ɔ kpa tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nɩɩ ɔkʋ kan taa fʋ kpee asɩn ogyikpa kɛ ɔ kɔɔlɛ fʋ kaalɛ mʋ, taa fʋ balɩmaasʋ tii mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nɩɩ ɔkʋ kan nyan fʋ, fɛɛ fʋ sʋla mʋ ɩsʋla kpiya mʋ mayɩlɩ kʋlʋn mʋ, sʋla ɩmʋ kpiya mʋ ɩmayɩlɩ anyɔ. ");
INSERT INTO naw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nɩɩ ɔkʋ kan ba kʋlɛ fʋ kʋtɔ kʋ mʋ, sa mʋ. Abɛɛ nɩɩ ɔkʋ kan ba yɛ fʋ paala mʋ kʋtɔ kʋ mʋ, sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Fan nu Mosesi nbara mʋ maa bɩla tɔwɛ yɛ, ‘Fan nyɛ kebiti sa fanɛ tɔɔmaa ana, kɛ fan kisi fanɛ‐dʋn ana.’ ");
INSERT INTO naw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amaa mɛ ɩ tɔwɛ fan yɛ, fan nyɛ kebiti sa fanɛ‐dʋn ana, kɛ fan kʋlɛ kabwaarɛ kʋlɛ sa fanɛ anyanlapʋ, ");
INSERT INTO naw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kɛ fan baa fan du fɛɛ fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ. Mʋ ɩ yɛgɛ nɩɩ mʋ kyɔwɛ ɩɩ lɩɩ ɛɛ sa alibi awaapʋ yɛ adanbɩrasa awaapʋ, nɩɩ ɛɛ yɛgɛ bʋlayɩ ɩɩ da ɛɛ sa bamʋ nɩɩ bamʋ ɩkpa ii kyiigi, yɛ bamʋ nɩɩ bamʋ ɩkpa ɩ man kyiigi. ");
INSERT INTO naw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nɩɩ fan kan fan sʋ kebiti sa bamʋ nɩɩ bee biti fanɛ nkʋn mʋ, mɩnɛ kʋkɔka nɩɩ fen biti fan nyɛ? Man gyɛ kanɩn maŋa nɩɩ alibi awaapʋ gbaa bɛɛ waa nɩn abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nɩɩ fan kan fɛn fwaala fanɛ tɔmaa ana nkʋn mʋ, mɩnɛ kʋtɔ nɩɩ fan waa fan kyɔ kʋtɔ mʋ nɩɩ ɔkʋmaa nɩmʋ ɩɩ waa? Man gyɛ kanɩn nɩɩ ɩdakpa asunpu gbaa bɛɛ waa nɩn? ");
INSERT INTO naw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ɩmʋ sʋ ɩ dagaa fanɛ kɩbaabʋtɔ maa du kyɛɛkyɛɛ, fɛɛ kanan mʋ nɩɩ fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ du kyɛɛkyɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Fan baa fan da sʋ kɛ fan man waa fanɛ adanbɩrasa asa ansi sʋ, kɛ ba nyɛ wu fanɛ. Nɩɩ fan kan waa kanɩn mʋ, fan mɛɛ yɛ fan nyɛ kʋkɔka lɩɩ fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ɩmʋ sʋ nɩɩ fʋ kan kɛɛ otiripu atɔ mʋ, man taa da kibonbon fɛɛ kanan mʋ nɩɩ nnɔ nnyɔ‐nnyɔ wuya ana mʋ bɛɛ waa kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa yɛ agbenbi sʋ kɛ asa ba nyɛ yɩn bamʋ mʋ. N tɔwɛ fanɛ kesintin fɛɛ ba tɛɛ wʋla nyɛ bamʋ kʋkɔka lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amaa nɩɩ fʋ kan kɛɛ atiripu afulee mʋ, man yɛgɛ fʋ‐bɩna kɩbaa ɔ bɩɩ kʋtɔ mʋ nɩɩ fu gyisa kɩbaa mʋ waa mʋ, ");
INSERT INTO naw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kɛ fʋ kakɛɛ ɩ waa asiiri tɔ. Saamʋ fʋ‐Sɛ mʋ nɩɩ ee wu kʋtɔ mʋ nɩɩ fɩɩ waa asiiri tɔ mʋ, ii biti ɔ ka fʋ kʋkɔ. ");
INSERT INTO naw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nɩɩ fɛn kan fɛn kʋlɛ kabwaarɛ‐kʋlɛ mʋ, fan man waa fɛɛ nnɔ nnyɔ‐nnyɔ wuya ana mʋ, lɩɩ fɛɛ bee biti kɩyɩlɛ kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa yɛ agbenbi nkpankyɛɛrɛ bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ, kɛ asa ba nyɛ wu bamʋ. N tɔwɛ fanɛ kesintin fɛɛ, ba wʋla nyɛ bamʋ kʋkɔka lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amaa nɩɩ fʋ kan fɩɩ kʋlɛ kabwaarɛ‐kʋlɛ mʋ, loo fu obu to kɛ fu tii, kɛ fʋ kʋlɛ kabwaarɛ‐kʋlɛ sa fʋ‐Sɛ mʋ nɩɩ ɔkʋ mee wu mʋ mʋ. Saamʋ fʋ‐Sɛ mʋ nɩɩ ee wu kʋtɔ mʋ nɩɩ fɩɩ waa asiiri tɔ mʋ, ii biti ɔ ka fʋ kʋkɔ. ");
INSERT INTO naw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nɩɩ fan kan fen kʋlɛ kabwaarɛ‐kʋlɛ mʋ, fan man tɔwɛ ntɔwɛ bʋnswɩɩsa mʋ nɩɩ ɩ man sʋ kasɛ fɛɛ ɩdakpa asunpu lɛɛ mʋ. Lɩɩ fɛɛ bɛɛ fɛ nfɛɛrɛ nɩn fɛɛ bamʋ kʋkʋlɛ bʋnswɩɩsa mʋ, ii biti ɩ yɛgɛ kɛ ɩ ba tɔ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ɩmʋ sʋ fan man waa fɛɛ bamʋ, lɩɩ fɛɛ fanɛ‐Sɛ nyi kʋtɔ mʋ nɩɩ kii tiri fanɛ pɔyɩ nɩɩ fɛn kʋlɛ mʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Nɩɩ fen biti fan kʋlɛ kabwaarɛ‐kʋlɛ mʋ, falɛ nɩɩ ɩ dagaa fan maa tɔwɛ. ‘Anɛ‐Sɛ Ɩbwaarɛ mʋ nɩɩ fʋ bʋ sʋsʋ, yɛgɛ asa ba bʋnyaa fʋ kɩtɩɩ. ");
INSERT INTO naw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yɛgɛ fu kuwura‐gyii mʋ kɩ ba, kɛ fʋ yɛgɛ fu kebiti kɩ waa kasɛ sʋ nfɩɩ, fɛɛ kanan mʋ nɩɩ ki du sʋsʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sa anɛ kakɛ kʋmaa agyitɔ. ");
INSERT INTO naw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Taa anɛ alibi kɛɛ anɛ, fɛɛ kanan mʋ nɩɩ anɛ gbaa anɛ an taa bamʋ nɩɩ bɛɛ waa anɛ alibi kɛɛ bamʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Man yɛgɛ a loo kʋtʋʋ tɔ kɩɩ tɔ, amaa lɛɛ anɛ lɩɩ olibilibi mʋ abaa tɔ. Lɩɩ fɛɛ kuwura‐gyii yɛ ɔlʋn, yɛ bʋnyaa ɩ gyɛ fʋ lɛɛ kakpaa.’ ");
INSERT INTO naw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Lɩɩ fɛɛ nɩɩ asa ba waa fanɛ alibi nɩɩ fan taa kɛɛ bamʋ mʋ, fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ gbaa ii biti ɔ taa kɛɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amaa nɩɩ fan kan fan man taa asa alibi kɛɛ bamʋ bɩrɛ, fanɛ‐Sɛ mɛɛ yɛ ɔ taa fanɛ alibi kɛɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nɩɩ fan kan waa noŋmina mʋ, fan man waa fanɛ ansi tɔ kʋwɛɛ kuwu fɛɛ kanan mʋ nɩɩ nnɔ nnyɔ‐nnyɔ wuya ana bɛɛ waa mʋ. Bɛɛ nyaaŋɛ bamʋ ansi tɔ kɛ asa ba nyɛ wu yɛ ba ŋmina kɔnɔ. N tɔwɛ fanɛ kesintin fɛɛ ba wʋla nyɛ bamʋ kʋkɔka lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amaa nɩɩ fʋ kan ŋmina kɔnɔ mʋ, fwɩɩ fu ansi tɔ, sʋswa nfɔ kɛ fʋ sɛyɩ fu kumu tɔ. ");
INSERT INTO naw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Saamʋ, asa ba mɛɛ yɛ ba wu fɛɛ fu ŋmina kɔnɔ, amɔɔ fʋ‐Sɛ mʋ nɩɩ ɔkʋ mee wu mʋ mʋ nkʋn. Fʋ‐Sɛ mʋ nɩɩ ee wu kʋtɔ mʋ nɩɩ fɩɩ waa asiri tɔ, ii biti ɔ ka fʋ kʋkɔ. ");
INSERT INTO naw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Fan man kʋʋla kapatɩyɛ yɩla kasɛ sʋ nfɩɩ sa fanɛ n‐yɩɩ, nfɩɩ nɩmʋ nɩɩ ɩtabɩrɩta yɛ nkandɩra ii nyita ɩmʋ, nɩɩ ayu bee loo bee yuuri ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amaa fan kʋʋla kapatɩyɛ yɩla sʋsʋ sa fanɛ n‐yɩɩ, katɩn mʋ nɩɩ ɩtabɩrɩta yɛ nkadʋrɔ ɩ mɛɛ taalɛ nyita ɩmʋ, nɩɩ ayu ba mɛɛ taalɛ loo naa yuuri ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lɩɩ fɛɛ katɩn mʋ nɩɩ fʋ kapatɩyɛ bʋ mʋ, tʋtɔ nɩɩ fʋ nfɛɛrɛ gbaa ɩ bʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nyɩmɩsa ansi ɩ gyɛ mʋ kayɩɩ‐wʋlɛ mʋ fɩtɩla. Nɩɩ fu ansi ɩ kan ɩ bʋrɔn bɩrɛ, fʋ kayɩɩ‐wʋlɛ mʋ kpini gyɛ ɩŋmaŋɛsa nɩn. ");
INSERT INTO naw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amaa nɩɩ fu ansi ɩ kan ɩ man bʋrɔn bɩrɛ, fʋ kayɩɩ‐wʋlɛ mʋ kpini bʋ kitentenbiri tɔ nɩn. Ɩmʋ sʋ nɩɩ fɩtɩla mʋ nɩɩ kɩ bʋ fʋ tɔ mʋ gyɛ kitentenbiri mʋ, ii biti ɩ waa kitentenbiri tumm. ");
INSERT INTO naw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ɔkʋ ɩ gyɛ ɔkʋ mɛɛ taalɛ sun anyɩrɩpɛ anyɔ. Ee biti o kisi ɔkʋ kɛ ɔ nyɛ kebiti sa ɔkʋ, abɛɛ ee biti ɔ nyɛ saŋa sa ɔkʋ kɛ ɔ yɛgɛ ɔkʋ. Fan mɛɛ taalɛ sun Ɩbwaarɛ maa afulee. ");
INSERT INTO naw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ɩmʋ sʋ n tɔwɛ fanɛ yɛ, fan man yɛgɛ fanɛ nkpa yɛ agyitɔ mʋ nɩɩ fen biti fan gyii, abɛɛ ɩmʋ nɩɩ fen nuu, abɛɛ fanɛ kayɩɩ‐wʋlɛ yɛ atɔ bunsa asɩn ɩ tɔɔrɔɔ fanɛ. Nkpa ɩ man kyɔ agyitɔ abɛɛ? Nɩɩ kayɩɩ‐wʋlɛ mɔɔ man kyɔ atɔ bunsa? ");
INSERT INTO naw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Fan kɩɩ nbwiibi mʋ nɩɩ ba bʋ afuu tɔ mʋ, be mee duu nɩɩ ba mɛɛ tɩŋɛ, nɩɩ ba mɛɛ kʋʋla agyitɔ bɛɛ gyaga agyan sʋ, amaa fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ ɩɩ sa bamʋ agyitɔ. Fanɛ asɩn ɩ man tiri ɩ kyɔ bamʋ nɩn abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Fanɛ tɔ ɔmɔɔ nɩɩ asɩn ɩ maa tɔɔrɔɔ mʋ sʋ mʋ, nɩɩ ɛɛ taalɛ taa kerefi kʋlʋn tii mʋ nkpa sʋ? ");
INSERT INTO naw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Nɩɩ mɩnɛ ɩ waa nɩɩ atɔ bunsa asɩn ɩ tɔɔrɔɔ fanɛ? Fan kɩɩ kanan mʋ nɩɩ iyu ntʋtʋlɛ ɩ dan mʋ. I mee sun kusun nɩɩ ɩ mɛɛ lʋʋ atɔ bunsa ɩ sa ɩmʋ n‐yɩɩ. ");
INSERT INTO naw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amaa n tɔwɛ fanɛ yɛ, halɩɩ Owura Solomon maa mʋ atɔ bunsa danbɩrasa kpini mʋ, ɩ man bʋrɔn fʋʋ ntʋtʋlɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nɩɩ falɛ nɩɩ Ɩbwaarɛ ɩɩ lɔŋɔ afitiri mʋ nɩɩ ndaga ɩ bʋ tɔ, nɩɩ ɔkɛ bɛɛ taa ɩmʋ funti waa fʋlɔn tɔ mʋ, mɩnɛ waa nɩɩ ɔ mɛɛ yɛ ɔ sa fanɛ atɔ bunsa kʋkyɔ? O, fanɛ kɩkɔɔlɛ‐gyii kɩ man kyɔ? ");
INSERT INTO naw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ɩmʋ sʋ fan man tɔɔrɔɔ fanɛ n‐yɩɩ fɛn taasɛ yɛ, ‘Mɩnɛ nɩɩ an biti a gyii?’ abɛɛ ‘Mɩnɛ nɩɩ an biti a nuu?’ abɛɛ ‘Mɩnɛ nɩɩ an biti a bun?’ ");
INSERT INTO naw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bamʋ nɩɩ be mee nyi Ɩbwaarɛ mʋ falɛ atɔ kpini sʋ nɩɩ bamʋ ansi ɩ payɩ. Nɩɩ fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ nyi fɛɛ falɛ atɔ nɩmʋ maa tiri fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","“Amaa fan gyankpaa kɩɩ biti Ɩbwaarɛ kuwura‐gyii mʋ ɩkpa yɛ mʋ ɩkpa kikyiigisa mʋ, kɛ ɔ taa atɔ nɩmʋ kpini tii sʋ sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kanɩn sʋ fan man tɔɔrɔɔ fanɛ n‐yɩɩ lɩɩ atɔ mʋ nɩɩ ii biti ɩ ba ɔkɛ. Fan yɛgɛ ɔkɛ atɔ ɩ kɩɩ ɩmʋ gbaa‐gbaa ɩmʋ asɩn tirisa sʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Fan man bun kʋpwɛ, kɛ Ɩbwaarɛ ɔ man bun fanɛ gbaa kʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lɩɩ fɛɛ ɔkpa mʋ nɩɩ fɛn bɔla sʋ fen bun fanɛ bɩrɩsa ana kʋpwɛ mʋ, nɩɩ Ɩbwaarɛ gbaa ii biti ɔ bɔla sʋ bun ngbaa fanɛ kʋpwɛ. Nɩɩ kʋtɔ kaalasa mʋ nɩɩ fan taa kaala sa fanɛ bɩrɩsa ana mʋ, kanɩn nɩɩ Ɩbwaarɛ ii biti ɔ kaala sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Mɩnɛ ɩ waa nɩɩ fii wu keyuubi mʋ nɩɩ kɩ bʋ fʋ bɩrɩsa kinsi tɔ, nɩɩ fu mee wu kagyakpoti mʋ nɩɩ kɩ dɛ fu kinsi tɔ? ");
INSERT INTO naw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nɛnɛ sʋ nɩɩ fɩɩ taalɛ tɔwɛ fʋ bɩrɩsa yɛ yɛgɛ n lɛɛ keyuubi fu kinsi tɔ, yɛgɛ kagyakpoti dɛ ngbaa‐gbaa fu kinsi tɔ? ");
INSERT INTO naw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Fʋ nnɔ nnyɔ‐nnyɔ wuya, gyankpaa lɛɛ kagyakpoti mʋ nɩɩ kɩ bʋ fu kinsi tɔ mʋ, pɔyɩ kɛ fʋ lan wu danbɩrasa, kɛ fʋ lɛɛ keyuubi mʋ nɩɩ kɩ bʋ fʋ bɩrɩsa kinsi tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Fan man taa kʋtɔ mʋ nɩɩ ki du kyɩrɛkyɩrɛ mʋ sa igyoonɔ, lɩɩ fɛɛ bee biti ba biliŋi yɩlɛ fanɛ sʋ duŋi fanɛ waa kyabɩlɛ‐kyabɩlɛ. Nɩɩ fan man taa fanɛ atɔ kparɛ tʋʋ sa akuuri, kɛ be kyigya ɩmʋ sʋ nyita. ");
INSERT INTO naw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Fan kʋlɛ lɩɩ Ɩbwaarɛ asɛ, ee biti ɔ sa fanɛ. Fan kɩɩ biti Ɩbwaarɛ asɛ, fen biti fan wu. Fan da mʋ kebunɔ, ee biti o tigi sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɛɛ kʋlɛ ɛɛ lɩɩ Ɩbwaarɛ asɛ mʋ, ɛɛ nyɛ, nɩɩ ɔkʋmaa mʋ nɩɩ ɛɛ kɩɩ ee biti mʋ, ee wu, nɩɩ ɔkʋmaa mʋ nɩɩ ɛɛ da kebunɔ mʋ, ee tigi ɛɛ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Fanɛ anɩmʋ nɩɩ mu‐bii ɩɩ kʋlɛ mʋ bodobodo kɛ ɔ taa kubuu sa mʋ? ");
INSERT INTO naw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Abɛɛ nɩɩ ɛɛ kʋlɛ mʋ ɔkɩn nɩɩ ɛɛ taa kɩnansɛ ɛɛ sa mʋ? ");
INSERT INTO naw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nɩɩ fanɛ mʋ nɩɩ fan gyɛ alibi awaapʋ mʋ gbaa fen nyi atɔ danbɩrasa kɩtaa sa fanɛ‐bii ana mʋ, mɩnɛ sʋ nɩɩ fanɛ‐Sɛ Ɩbwaarɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ mɛɛ yɛ o kyula sa ɔkʋmaa mʋ nɩɩ ɛɛ kʋlɛ mʋ atɔ danbɩrasa mʋ? ");
INSERT INTO naw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ɩmʋ sʋ kʋtɔ kʋmaa mʋ nɩɩ fen biti asa ba waa sa fanɛ mʋ, fanɛ gbaa fanɛ fan baa fɛn waa kanɩn fɛn sa bamʋ. Ɩnɩmʋ ɩ gyɛ Mosesi nbara yɛ Ɩbwaarɛ atɔwɛpʋ kɩkaapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Fan bɔla kebunɔ pii mʋ tɔ loo. Lɩɩ fɛɛ kebunɔ yɛlɩgɛsa mʋ ɔkpa gbaa yɛlɩgɛ yɛ kɩnatɛ sʋ, nɩɩ kii kpee kinyita kakpaa tɔ nɩn, nɩɩ asa mʋ nɩɩ bɛɛ bɔla bee loo kɩmʋ tɔ mʋ ba kyɔ. ");
INSERT INTO naw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amaa ɔkpa mʋ nɩɩ kii kpee nkpa tɔ mʋ bɩrɛ kɩ bɔntɛ, nɩɩ kɩmʋ kebunɔ gbaa man yɛlɩgɛ, nɩɩ asa mʋ nɩɩ bee wu kɩmʋ bɛɛ bɔla mʋ ba man kyɔ. ");
INSERT INTO naw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Fan baa fan da atɩŋɛsa atɔwɛpʋ sʋ. Ansi sʋ mʋ be du bɔhn fɛɛ nbʋlʋpʋ mʋ, amaa bamʋ nkɔlɔ tɔ mʋ, be du nɩn fɛɛ agboogboo mʋ nɩɩ ba nyɛ agbʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bamʋ atɔ waasa nɩɩ fen biti fan taa bɩɩ bamʋ. Kididobi oyu sʋ nɩɩ bɛɛ tɩyɛ kimango abi abɛɛ? Abɛɛ kɩkpalɛ oyu sʋ nɩɩ bɛɛ tɩyɛ akutu? ");
INSERT INTO naw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kanɩn nɩɩ oyu danbɩrasa ɩɩ sɔyɩ abi danbɩrasa, nɩɩ oyu libi mɔɔ ɩɩ sɔyɩ abi libi. ");
INSERT INTO naw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Oyu danbɩrasa mɛɛ taalɛ sɔyɩ abi libi, nɩɩ oyu libi mɛɛ taalɛ sɔyɩ abi danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Oyu kʋmaa mʋ nɩɩ kɩ mɛɛ sɔyɩ abi danbɩrasa mʋ, bɛɛ ŋɛ kɩmʋ nɩn tʋʋ, kɛ ba taa waa fʋlɔn tɔ. ");
INSERT INTO naw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kanɩn sʋ fen biti fan bɩɩ antɩŋɛsa atɔwɛpʋ mʋ lɩɩ bamʋ awaasa sʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Man gyɛ ɔkʋmaa mʋ nɩɩ ɛɛ tɩɩ mɛ yɛ, ‘Ɔnyɩrɩpɛ, Ɔnyɩrɩpɛ’ mʋ, ii biti o loo sʋsʋ kuwura‐gyii mʋ tɔ, amɔɔ ɔmʋ nɩɩ ɛɛ waa mɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ kebiti mʋ nkʋn. ");
INSERT INTO naw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ɩbwaarɛ kakɛ talɛsa maŋa kan fʋʋ mʋ, asa gaalaagaa bee biti ba tɔwɛ mɛ yɛ ‘Ɔnyɩrɩpɛ, Ɔnyɩrɩpɛ, an bɔla fʋ kɩtɩɩ sʋ tɔwɛ abwaarɛsɩn sa asa, nɩɩ lɩɩ fʋ kɩtɩɩ tɔ sʋ mʋ an gya nbwɩɩ libi, nɩɩ an waa asɩn kyinkyinsa gaalaagaa.’ ");
INSERT INTO naw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Amaa n biti tɔwɛ tigi bamʋ yɛ, ‘Man nyi fanɛ. Fanɛ alibi awaapʋ banɩmʋ, fan lɩɩ mɛ sʋ natɛ.’ ");
INSERT INTO naw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ɩmʋ sʋ ɔkʋmaa mʋ nɩɩ ee nu mɛ asɩn nɩmʋ, nɩɩ ee buu ɩmʋ mʋ, du nɩn fɛɛ ɔnyaasɩnpʋ mʋ nɩɩ ɔ pɔyɩ mʋ kɩkpaara gyaga kɩfʋlɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bʋlayɩ da nɩɩ ɩbʋn ɩ bɔla, nɩɩ afuu lala ɩ da obu mʋ, amaa kɩ man tɩyɛ, lɩɩ fɛɛ ba pɔyɩ kɩmʋ gyaga kɩfʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amaa ɔkʋmaa mʋ nɩɩ ee nu mɛ asɩn nɩmʋ, nɩɩ o mee buu ɩmʋ mʋ, du nɩn fɛɛ omelensipu mʋ nɩɩ ɔ pɔyɩ mu obu gyaga kusipu sʋ. ");
INSERT INTO naw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bʋlayɩ da nɩɩ ɩbʋn ɩ bɔla, nɩɩ afuu lala ɩ da nɩɩ obu mʋ lɩɩ tɩyɛ ɔlʋn tɔ birimm.” ");
INSERT INTO naw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu maa tɔwɛ asɩn nɩmʋ lʋwɛ mʋ, mʋ kɩkaapʋ mʋ i kyinkyin sakyɔ mʋ gaa. ");
INSERT INTO naw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Lɩɩ fɛɛ mʋ kɩkaapʋ mʋ tɔ sʋ ɔlʋn, nɩɩ ɩ man du fɛɛ nbara akaapʋpʋ lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu maa kpɩlɩgɛ lɩɩ kɩbɩɩ mʋ sʋ ba mʋ, asa damantɛ ba buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tʋtɔ nɩɩ ɔnyɩn kʋ mʋ nɩɩ ɛɛ lɔ kibootoo ba muŋa mu amulii sʋ mu ansi tɔ nɩɩ ɔ tɔwɛ yɛ, “Ɔnyɩrɩpɛ nɩɩ ɩ pɩrɛ fʋ mʋ, fɩɩ taalɛ yɛgɛ mɛ n‐yɩɩ ɩ lɔŋɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nɩɩ Yesu tɛɛŋɛ mʋ kɩbaa mata ɔnyɩn mʋ. Nɩɩ ɔ tɔwɛ mʋ yɛ, “Ɩ pɩrɛ mɛ, fʋ n‐yɩɩ ɩ lɔŋɔ sʋ.” Opula tɔ nɩɩ mʋ kibootoo mʋ kɩ lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Man waa fʋ tɔwɛ ɔkʋ, amaa taa fʋ n‐yɩɩ naa kaapʋ Ɩbwaarɛ Oseepu, kɛ fʋ lɛɛ saraga fɛɛ kanan mʋ nɩɩ Mosesi nbara ɩ kaapʋ mʋ, kɛ ɔkʋmaa nɩmʋ o wu fɛɛ fʋ n‐yɩɩ ɩ lɔŋɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu maa loo Kapanum kadɛ tɔ mʋ, Roma anaakɔpʋ ɔbɩlɩsa kʋ ba mʋ asɛ ba kʋlɛ mʋ yɛ ɔ kyɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ɔ tɔwɛ mʋ yɛ, “Ɔnyɩrɩpɛ, mɛ kɩyaafɔlɛ dɛ mɛ kɩkpaara sʋ ɛɛ lɔ mʋgʋlɛ‐mʋgʋlɛ, ɩɩ tɔɔrɔɔ mʋ gaa.” ");
INSERT INTO naw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ɩmʋ sʋ, Yesu tɔwɛ mʋ yɛ, “N biti n naa kyɛ mʋ kʋlɔ.” ");
INSERT INTO naw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nɩɩ anaakɔpʋ ɔbɩlɩsa mʋ lɛɛ mʋ kɔnɔ yɛ, “Ɔnyɩrɩpɛ n man dagaa fɛɛ fʋ ba mɛ kɩkpaara sʋ. Amaa dan sa kɔnɔ, mɛ kɩyaafɔlɛ mʋ ii biti ɔ kpaarɛ. ");
INSERT INTO naw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Lɩɩ fɛɛ ngbaa mɛ n bʋ akʋ ɔlʋn kasɛ nɩn, yɛgɛ anaakɔpʋ ba bʋ mɛ kasɛ. N kan tɔwɛ ɔkʋ yɛ, ‘Kpe nfɩɩ,’ nɩɩ ee kpee. Nɩɩ n tɔwɛ ɔkʋ yɛ, ‘Ba nfɩɩ,’ nɩɩ ɛɛ ba. Nɩɩ n tɔwɛ mɛ kɩyaafɔlɛ yɛ, ‘Waa ɩnɩmʋ,’ nɩɩ ɛɛ waa ɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu maa nu kanɩn mʋ, i kyinkyin mʋ, nɩɩ ɔ tɔwɛ bamʋ nɩɩ ba buu mʋ mʋ yɛ, “N tɔwɛ fanɛ kesintin fɛɛ Ɩsɩrayɩ abi kpini tɔ mʋ, n man pɩɩta wu ɔsa mʋ nɩɩ ɔ sʋ falɛ kɩkɔɔlɛ‐gyii damantɛ nɩmʋ kedubi. ");
INSERT INTO naw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N tɔwɛ fanɛ yɛ asa gaalaagaa bee biti ba lɩɩ kyɔwɛ kɩlɩɩ yɛ kyɔwɛ kɩtɩyɛ, kɛ ba maa Abraham maa Isaki yɛ Gyekobu ba ba bʋga kyɩna bamʋ ɩkyɩnakpa mʋ nɩɩ ɩ gyɛ kuwura‐gyii kensi‐gyii ngyaŋɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amaa fanɛ mʋ nɩɩ naafɔɔ fan gyɛ kuwura‐gyii abi mʋ, bee biti ba taa fanɛ funti kewu tɔ kitentenbiri tɔ katɩn mʋ nɩɩ kusu yɛ anobi keduŋi bʋ.” ");
INSERT INTO naw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nɩɩ Yesu tɔwɛ anaakɔpʋ ɔbɩlɩsa mʋ yɛ, “Kpewu! Ii biti ɩ waa sa fʋ fɛɛ kanan mʋ nɩɩ fʋ kɔɔlɛ gyii mʋ.” Nɩɩ kanɩn saŋa maŋa tɔ kyɛɛkyɛɛ nɩɩ mʋ kɩyaafɔlɛ mʋ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu maa ba Pita kɩkpaara sʋ mʋ, o wu fɛɛ Pita mʋ‐saa kyɩɩsa dɛ ɛɛ lɔ kibirima. ");
INSERT INTO naw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ɔ kɩtaa mʋ kɩbaa tɔ nɩɩ kibirima mʋ kɩ yɛgɛ mʋ, nɩɩ ɔ kʋsʋ kɩtaa bamʋ kɩfɔ. ");
INSERT INTO naw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Saŋa mʋ nɩɩ kyɔwɛ tɩyɛ mʋ, nɩɩ asa ba taa alɔpʋ kʋkyɔ mʋ nɩɩ nbwɩɩ libi ba tɛ bamʋ sʋ mʋ bɩya Yesu. Nɩɩ ɔ sa nbwɩɩ libi mʋ kɔnɔ gya bamʋ kʋsaa alɔpʋ mʋ sʋ, nɩɩ ɔ kyɛ alɔpʋ mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɩnɩmʋ ɩ yɛgɛ nɩɩ asɩn mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Isaya tɔwɛ Asɩnkyan yɩlasa mʋ tɔ mʋ ɩ ba tɔ. Asɩn mʋ ɩ gyɛ yɛ, “Ɔ kɔɔlɛ anɛ alɔ, nɩɩ ɔ taa anɛ alobi sʋla.” ");
INSERT INTO naw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu maa wu asa damantɛ ba maa kyaabɔɔ mʋ mʋ, ɔ tɔwɛ mu asunpu mʋ yɛ ba faa kpee benbe. ");
INSERT INTO naw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nɩɩ nbara ɔkaapʋpʋ kʋ ba mʋ asɛ ba tɔwɛ yɛ, “Ɔkaapʋpʋ n biti n buu fʋ kpee katɩn kʋmaa mʋ nɩɩ fii kpee mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Agboogboo ba sʋ ɩbɔ bɛɛ dɛ tɔ, nɩɩ nbwiibi ba sʋ nsʋswaa, amaa mɛ, Daadimaadi Obii‐nyɩnsa mʋ bɩrɛ, n man sʋ katɩn mʋ nɩɩ n dɛ fʋʋtɛ.” ");
INSERT INTO naw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mʋ ɔbɩɩlapʋ kʋ gbaa tɔwɛ mʋ yɛ, “Ɔnyɩrɩpɛ, yɛgɛ n naa pula mɛ‐sɛ pɔyɩ.” ");
INSERT INTO naw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Amaa Yesu tɔwɛ mʋ yɛ, “Buu mɛ kɛ fʋ yɛgɛ bamʋ nɩɩ be du fɛɛ alewupu mʋ, be kpee naa pula bamʋ alewupu.” ");
INSERT INTO naw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nɩɩ o loo ɔkʋlɩ tɔ nɩɩ mʋ abɩɩlapʋ mʋ ba buu mʋ loo. ");
INSERT INTO naw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ba maa gyan ɔbʋn lala mʋ sʋ bee kpee mʋ, opula tɔ nɩɩ afuu lala i tigi yɛgɛ ɩɩ da apaa ii loo ɔkʋlɩ mʋ tɔ. Amaa yɛgɛ Yesu dɛ nsɩɩrɛ. ");
INSERT INTO naw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abɩɩlapʋ mʋ ba naa kyiŋi mʋ, nɩɩ ba tɔwɛ mʋ yɛ, “Ɔnyɩrɩpɛ, mɔlɩgɛ anɛ! An biti a muuri!” ");
INSERT INTO naw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ɔ lɛɛ bamʋ kɔnɔ yɛ, “Fanɛ mʋ nɩɩ fanɛ kɩkɔɔlɛ‐gyii kɩ man kyɔ, mɩnɛ ɩ waa nɩɩ fan sʋ kufuu kanɩn?” Nɩɩ ɔ kʋsʋ pʋntɛ afuu yɛ apaa mʋ sʋ, nɩɩ ɩ waa diin. ");
INSERT INTO naw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nɩɩ i kyinkyin asa mʋ, nɩɩ ba taasɛ yɛ, “Mɩnɛ nyɩmɩsa ndee? Halɩɩ afuu yɛ apaa gbaa ii nu mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu maa fʋʋ ɔbʋn mʋ benbe mʋ nɩɩ kɩ gyɛ Gadara ɔsʋwʋlɛ mʋ, anyɩn anyɔ kʋ mʋ nɩɩ nbwɩɩ libi ba tɛ bamʋ sʋ mʋ ba lɩɩ nkyan tɔ ba gyaŋa mʋ. Ba kyɩna ba libi gaa fɛɛ ndʋnbwɛ, nɩɩ ɔkʋ mɛɛ taalɛ bɔla kanɩn ɔkpa maŋa sʋ. ");
INSERT INTO naw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba kuusi yɛ, “Ɩbwaarɛ mu‐Bii, mɩnɛ nɩɩ fii biti anɛ asɛ? Fʋ ba nɩn yɛ fʋ ba waa anɛ awʋrʋfɔ pɔyɩ kɛ ɩmʋ saŋa mʋ ɩ fʋʋ, abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akuuri damantɛ kʋ ba yɩlɛ tʋtɔ kɩbaafʋn bee gyii. ");
INSERT INTO naw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nɩɩ nbwɩɩ libi mʋ ba kʋlɛ Yesu yɛ, “Nɩɩ fʋ kan fii biti fʋ gya anɛ bɩrɛ, yɛgɛ a naa loo akuuri damantɛ nɩmʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ɔ tɔwɛ bamʋ yɛ, “Fan natɛ!” Nɩɩ ba lɩɩ anyɩn mʋ tɔ naa loo akuuri mʋ tɔ. Nɩɩ akuuri damantɛ mʋ kpini ba sɩlɛ kpɩlɩgɛ kidenbi mʋ naa tɩyɛ ɔbʋn lala mʋ tɔ nɩɩ ba wu. ");
INSERT INTO naw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nɩɩ bamʋ nɩɩ bɛɛ kɩɩ akuuri mʋ sʋ mʋ, ba sɩlɛ kpee kadɛ tɔ, naa tɔwɛ kʋtɔ mʋ nɩɩ kɩ waa kpini yɛ ɩmʋ nɩɩ ɩ waa anyɩn anyɔ mʋ nɩɩ nbwɩɩ libi ba tɛ bamʋ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kanɩn sʋ kadɛ mʋ tɔ asa kpini ba lɩɩ ba naa gyaŋa Yesu. Ba maa wu mʋ mʋ, ba kʋlɛ mʋ yɛ ɔ lɩɩ bamʋ ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu dii loo ɔkʋlɩ tɔ, faa ɔbʋn mʋ ba mʋ gbaa‐gbaa mʋ kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nɩɩ asa akʋ ba taa ɔnyɩn mʋgʋlɛ‐mʋgʋlɛ wuya mʋ nɩɩ ɔ dɛ kɩkpaata sʋ bɩya mʋ. Yesu maa wu bamʋ kɩkɔɔlɛ‐gyii mʋ, ɔ tɔwɛ mʋgʋlɛ‐mʋgʋlɛ wuya mʋ yɛ, “Mi‐bii, yɛgɛ fʋ kɔkɔlɔ kɩ dɛ fʋ. N taa fʋ alibi kɛɛ fʋ.” ");
INSERT INTO naw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tʋtɔ nɩɩ nbara akaapʋpʋ mʋ akʋ bɛɛ tɔwɛ abaa asɛ yɛ, “Ɔnyɩn nɩmʋ ɩ tɔwɛ nbusaa asɩn ee yii Ɩbwaarɛ!” ");
INSERT INTO naw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu maa bɩɩ nfɛɛrɛ mʋ nɩɩ bɛɛ fɛ mʋ, nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ nfɛɛrɛ libi nɩɩ fɛn fɛ fanɛ nkɔlɔ tɔ kanɩn? ");
INSERT INTO naw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ɩmʋ kɩmɔmɔ ɩ bʋlʋn kɩtɔwɛ? Fɛɛ n tɔwɛ ɔnyɩn nɩmʋ yɛ, ‘N taa fʋ alibi kɛɛ fʋ’, abɛɛ n tɔwɛ mʋ yɛ, ‘Kʋsʋ, kɛ fʋ natɛ?’ ");
INSERT INTO naw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amaa n biti fan bɩɩ fɛɛ, mɛ, Daadimaadi Obii‐nyɩnsa mʋ n sʋ ɔlʋn kasɛ sʋ n taa alibi kɛɛ.” Tʋtɔ nɩɩ ɔ tɔwɛ mʋgʋlɛ‐mʋgʋlɛ wuya mʋ yɛ, “Kʋsʋ, taa fʋ kalan kɛ fu kpewu.” ");
INSERT INTO naw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nɩɩ ɔnyɩn mʋ kʋsʋ nɩɩ o kpewu. ");
INSERT INTO naw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sakyɔ mʋ ba maa wu ɩnɩmʋ mʋ ɩ waa bamʋ kufuu, nɩɩ ba yɩn Ɩbwaarɛ fɛɛ maa taa kanɩn ɔlʋn sa nyɩmɩsa. ");
INSERT INTO naw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu maa lɩɩ tʋtɔ ee kpee mʋ, o wu lenpoo ɔkɔɔlɛpʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Matiwu maa tɛ lenpoo ɔkɔɔlɛkpa. Nɩɩ ɔ tɔwɛ mʋ yɛ, “Buu mɛ,” nɩɩ Matiwu kʋsʋ buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Saŋa mʋ nɩɩ Yesu maa mʋ abɩɩlapʋ ba kpee Matiwu kɩkpaara sʋ bee gyii mʋ, lenpoo akɔɔlɛpʋ gaalaagaa yɛ alibi awaapʋ ba ba, nɩɩ ba maa bamʋ kpini ba bʋga gyii. ");
INSERT INTO naw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasii abi ba maa wu kanɩn mʋ, ba taasɛ Yesu abɩɩlapʋ mʋ yɛ, “Mɩnɛ ɩ waa sʋ nɩɩ fanɛ ɔkaapʋpʋ maa lenpoo akɔɔlɛpʋ yɛ alibi awaapʋ bɛɛ bʋga bee gyii?” ");
INSERT INTO naw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu maa nu kanɩn mʋ, ɔ lɛɛ Farasii abi mʋ kɔnɔ yɛ, “Man gyɛ alanfɩya wuya nɩɩ ɔkyɛpʋ tiri sa, amɔɔ ɔlɔpʋ nkʋn. ");
INSERT INTO naw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Fan naa kɩɩ biti Asɩnkyan yɩlasa kasɛ. Asɩn mʋ ɩ gyɛ yɛ, ‘Abaa kʋwɛɛ kuwu nɩɩ mɛ, Ɩbwaarɛ n biti, man gyɛ atɔbwaaya kɩtaa lɛɛ saraga sa mɛ.’ ” Nɩɩ Yesu kyaga sʋ yɛ, “N man ba nɩn kɛ n ba tɩɩ bamʋ nɩɩ bɛɛ kɩɩ fɛɛ bamʋ ɩkpa i kyiigi Ɩbwaarɛ asɛ, amɔɔ alibi awaapʋ.” ");
INSERT INTO naw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kakaakʋ Gyɔn Okyugyeepu abɩɩlapʋ ba ba taasɛ Yesu yɛ, “Mɩnɛ ɩ waa sʋ nɩɩ anɛ yɛ Farasii abi mʋ a ŋmina kɔnɔ, nɩɩ fʋ abɩɩlapʋ bɩrɛ be mee ŋmina kɔnɔ?” ");
INSERT INTO naw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Nɛnɛ sʋ nɩɩ kɩkyɩɩfɔ tɔ afɔ bee biti ba bɔɔta tɔ, yɛgɛ ɔkyɩɩfɔ mu‐kuli mʋ bʋ bamʋ asɛ? Ɩ mɛɛ ba kanɩn. Amaa saŋa kʋ ii biti ɔ ba nɩɩ bee biti ba taa ɔkyɩɩfɔ mu‐kuli mʋ lɩɩ bamʋ asɛ. Kanɩn saŋa maŋa nɩɩ bee biti ba ŋmina kɔnɔ.” ");
INSERT INTO naw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesu bɩla tɔwɛ yɛ, “Ɔkʋ mɛɛ tɩn kikyibi pʋpwɛ taa baata tii kaalɛ dɩdaa ɔkyatɛkpa ɔbɔ. Nɩɩ ɔ kan waa kanɩn mʋ kikyibi pʋpwɛ mʋ kii biti kɩ kyatɛ lɩɩ, kɛ ɔkyatɛkpa mʋ kɩɩ yɛlɩgɛ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kanɩn maŋa nɩɩ ɔkʋ mɛɛ taa nta pʋpwɛ waa kʋtɔbwaaya ɔwʋlɛ taakpe dɩdaa tɔ. Nɩɩ ɔ kan waa kanɩn, nɩɩ nta mʋ ɩɩ bɩlɛ mʋ, ii biti ɩ kyatɛ taakpe dɩdaa mʋ nyita, kɛ nta mʋ ɩ kyɛɛgɛ fɔyɩ. Amaa bɛɛ taa nta pʋpwɛ waa taakpe pʋpwɛ tɔ, kɛ ɩmʋ anyɔ mʋ ɩ man nyita.” ");
INSERT INTO naw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu maa san ɔ maa sʋ ɛɛ tɔwɛ ɩnɩmʋ mʋ, nɩɩ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa ɔbɩlɩsa kʋ ba Yesu asɛ, ba muŋa mu ansi tɔ kʋlɛ mʋ yɛ, “Mi‐bii‐kyɩɩsa dan wu nɩmʋ. Amaa dan waa aniya ba taa fʋ kɩbaa mata mʋ, ee biti o kyiŋi lɩɩ lewu tɔ ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ɩmʋ sʋ Yesu kʋsʋ buu mʋ, nɩɩ mʋ abɩɩlapʋ gbaa ba buu mʋ kpee. ");
INSERT INTO naw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ba maa kpee mʋ, ɔkyɩɩ kʋ mʋ nɩɩ nkalan ɩɩ da mʋ nsu kudu anyɔ mʋ, ba bɔla Yesu kamaa nɩɩ ɔ taa mʋ kɩbaa mata Yesu kaalɛ anobi. ");
INSERT INTO naw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Lɩɩ fɛɛ ɔkyɩɩ mʋ fɛ mʋ nfɛɛrɛ tɔ yɛ, “Nɩɩ n dan nyɛ mata mʋ kaalɛ gbaa, n biti n nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nɩɩ Yesu biliŋi nɩɩ o wu ɔkyɩɩ mʋ, tɔwɛ mʋ yɛ, “Mi‐bii‐kyɩɩsa, yɛgɛ fʋ kɔkɔlɔ kɩ dɛ fʋ. Fʋ kɩkɔɔlɛ‐gyii ɩ yɛgɛ nɩɩ fʋ nyɛ alanfɩya.” Nɩɩ ɔkyɩɩ mʋ nyɛ alanfɩya opula maŋa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Saŋa mʋ nɩɩ Yesu naa loo ɔgyaŋɛkpa ɔbɩlɩsa mʋ kɩkpaara sʋ, nɩɩ o wu nleebi afʋlɛpʋ keli mʋ tɔ yɛ asa damantɛ mʋ nɩɩ bee su mʋ, ");
INSERT INTO naw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ɔ tɔwɛ bamʋ yɛ, “Ɔkʋmaa nɩmʋ ɔ lɩɩ nfɩɩ, kebii mʋ man wu nɩn, ɔ dɛ nsɩɩrɛ nɩn.” Amaa ba ŋmasɛ Yesu. ");
INSERT INTO naw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ba maa gya asa damantɛ mʋ lɩɩ kamaa tɔ mʋ, Yesu loo kebii kyɩɩsa‐bi mʋ asɛ, nɩɩ ɔ kɩtaa mʋ kɩbaa tɔ, nɩɩ ɔ kʋsʋ kyɩna. ");
INSERT INTO naw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nɩɩ falɛ asɩn nɩmʋ yaasɛ kpee kanɩn ɔsʋwʋlɛ maŋa sʋ kpini. ");
INSERT INTO naw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu maa lɩɩ tʋtɔ ee kpee mʋ, nɩɩ agyaatanapʋ anyɔ akʋ ba buu mʋ, bee kuusi bɛɛ tɔwɛ yɛ, “Dawidi kanaana‐bii, wu anɛ kʋwɛɛ!” ");
INSERT INTO naw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu maa naa loo katɩn mʋ nɩɩ ɔ tɛ mʋ, nɩɩ agyaatanapʋ anyɔ mʋ ba kpee mʋ asɛ, nɩɩ ɔ taasɛ bamʋ yɛ, “Fan kɔɔlɛ gyii fɛɛ n taalɛ kyɛ fanɛ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Ɛɛhn, Ɔnyɩrɩpɛ, an kɔɔlɛ gyii.” ");
INSERT INTO naw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tʋtɔ nɩɩ ɔ mata bamʋ ansi tɔwɛ bamʋ yɛ, “Ɩ waa sa fanɛ, fɛɛ kanan mʋ nɩɩ fanɛ kɩkɔɔlɛ‐gyii ki du mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nɩɩ bamʋ ansi i bugi. Nɩɩ Yesu da bamʋ amu tɔ kenken yɛ, “Fan man tɔwɛ ɩnɩmʋ sa ɔkʋ.” ");
INSERT INTO naw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amaa ba lɩɩ tʋtɔ nɩɩ ba yaasɛ asɩn nɩmʋ lɩɩ Yesu sʋ kanɩn ɔsʋwʋlɛ maŋa sʋ kabaafʋn kpini. ");
INSERT INTO naw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Agyaatanapʋ anyɔ mʋ ba maa kpee mʋ, asa akʋ ba bɩya ɔnyɩn mʋ nɩɩ nbwɩɩ libi ba tɛ mʋ sʋ nɩɩ ɔ mɛɛ taalɛ ɛɛ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu maa dan gya nbwɩɩ libi lɩɩ ɔnyɩn mʋ sʋ mʋ, nɩɩ ɔnyɩn mʋ piili ɛɛ tɔwɛ. Nɩɩ ɩ waa asa damantɛ mʋ kɩyan, nɩɩ ba tɔwɛ yɛ, “A man pɩɩ wu ɩnɩmʋ kudubi Ɩsɩrayɩ ɔsʋwʋlɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amaa Farasii abi mʋ ba tɔwɛ yɛ, “Nbwɩɩ libi ɔbɩlɩsa ɔlʋn nɩɩ ɔ sʋ ɛɛ gya nbwɩɩ libi falɛ.” ");
INSERT INTO naw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nɩɩ Yesu natɛ ndɛ lala yɛ ndɛ‐bii tɔ kpini kyaabɔɔ, yɛgɛ ɛɛ kaapʋ bamʋ kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa mʋ tɔ, nɩɩ ɛɛ tɔwɛ bamʋ asɩn danbɩrasa lɩɩ Ɩbwaarɛ kuwura‐gyii mʋ sʋ, nɩɩ ɛɛ kyɛ alɔ yiri‐yiri kʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu maa wu sakyɔ mʋ, bamʋ asɩn ɩ waa mʋ kʋwɛɛ, lɩɩ fɛɛ bɛɛ yɩyɛɛ nɩɩ ba man nyi kanan mʋ nɩɩ ba waa. Be du nɩn fɛɛ nbʋlʋpʋ mʋ nɩɩ ba man sʋ ɔkpapʋ. ");
INSERT INTO naw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kanɩn sʋ ɔ tɔwɛ sa mʋ abɩɩlapʋ mʋ yɛ, “Kesintin tɔ mʋ, ayu kɩtɩŋɛ mʋ kyɔ, amaa kusun awaapʋ mʋ ba du gbɛrɛɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ɩmʋ sʋ fan kʋlɛ Ɔnyɩrɩpɛ, kadɔɔ wuya mʋ kɛ o sun kusun awaapʋ kpee mʋ ayu kɩtɩŋɛ mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu tɩɩ mʋ abɩɩlapʋ kudu anyɔ ba gyaŋɛ, nɩɩ ɔ sa bamʋ ɔlʋn yɛ ba taa gya nbwɩɩ libi, kɛ ba kyɛ alɔ yiri‐yiri kʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Abɩɩlapʋ kudu anyɔ mʋ atɩɩ ndee. Ɔgyankpaapʋ mʋ ɩ gyɛ Simon (mʋ nɩɩ ba bɩla bɛɛ tɩɩ mʋ yɛ Pita) maa mu‐supu Andiruwu, yɛ Gyemisi maa mu‐supu Gyɔn, Sebedi mu‐bii ana, ");
INSERT INTO naw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","yɛ Filipu maa Batolome, yɛ Tomasi maa Matiwu, lenpoo ɔkɔɔlɛpʋ mʋ, yɛ Gyemisi Alifeyo mu‐bii, yɛ Tadiyosi, ");
INSERT INTO naw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","yɛ Simon mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Seloti mʋ, yɛ Gyudasi Isikariyoti, mʋ nɩɩ ɔ ba lɛɛ Yesu sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nɩɩ Yesu sun abɩɩlapʋ kudu anyɔ mʋ tɔwɛ bamʋ yɛ, “Fan man kpee bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ kɩbaafʋn abɛɛ Samariya abi kadɛ kʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amaa fan kpee Ɩsɩrayɩ abi mʋ nɩɩ ba du fɛɛ nbʋlʋpʋ fɔyɩsa mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Fan kpee naa tɔwɛ bamʋ asɩn danbɩrasa mʋ yɛ, ‘Ɩbwaarɛ kuwura‐gyii mʋ ki tiri tɔ.’ ");
INSERT INTO naw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Fan kan kpee mʋ fan kyɛ alɔpʋ, kɛ fan kyiŋi alewupu, kɛ fan yɛgɛ abootipu n‐yɩɩ ɩ lɔŋɔ sʋ, kɛ fan gya nbwɩɩ libi lɩɩ asa sʋ. Ba taa ɔlʋn maŋa kɛɛ fanɛ nɩn, ɩmʋ sʋ fanɛ gbaa fanɛ fan taa kɛɛ. ");
INSERT INTO naw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Fan man taa afulee kʋ waa fanɛ igyifa tɔ, ");
INSERT INTO naw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nɩɩ fan man taa taakpe abɛɛ kaalɛ nyɔsapʋ, abɛɛ asɩbɩta, abɛɛ kikpebi, kpee ɔkpa maŋa. Osunpu dagaa fɛɛ ba sa mʋ kʋtɔ mʋ nɩɩ ki tiri mʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kadɛ lala abɛɛ kadɛ‐bi kʋmaa mʋ nɩɩ fan loo kɩmʋ tɔ mʋ, fan biti ɔsa mʋ nɩɩ mʋ ɩkpa i kyiigi, kɛ fan kyɩna mʋ kɩkpaara sʋ naa fʋʋ saŋa mʋ nɩɩ fen biti fan ba lɩɩ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nɩɩ fan kan loo mʋ sʋ mʋ, fan kʋlɛ keyuula sa kɩkpaara mʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nɩɩ kɩkpaara mʋ sʋ abi ba kan kɔɔlɛ fanɛ mʋ, fan yɛgɛ fanɛ keyuula mʋ ki sii kɩkpaara mʋ sʋ. Amaa nɩɩ ba man kan kɔɔlɛ fanɛ bɩrɛ, fan yɛgɛ fanɛ keyuula ki bwii ba fanɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nɩɩ kadɛ kʋ abɛɛ kɩkpaara kʋ asa ba man kan kɔɔlɛ fanɛ abɛɛ ba man nu fanɛ asɛ mʋ, fan kpɩkpaa fanɛ ayaa tɔ ɩsɛ wʋrɩgɛ bamʋ sʋ, kɛ fan lɩɩ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","N tɔwɛ fanɛ kesintin fɛɛ, kakɛ mʋ nɩɩ Ɩbwaarɛ ii biti o be gyii asa asɩn mʋ, Sodom maa Gomora abi kʋsʋ bɩɩtɛ gbaa ii biti ɩ baa ɩ bɔ bamʋ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Fan kɩɩ! N sun fanɛ nɩn fɛɛ nbʋlʋpʋ n kpee akuntun tɔ. Fan baa fan sʋ kanyaasɩn fɛɛ anansɛ, yɛgɛ fan du bwahn fɛɛ awura‐lɔpɔ. ");
INSERT INTO naw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Fan baa fan da sʋ, lɩɩ fɛɛ asa kʋ bee biti ba kɩtaa fanɛ kpee asɩn ogyikpa, kɛ ba tɩŋɛ fanɛ Gyiwu abi kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa. ");
INSERT INTO naw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lɩɩ mɛ sʋ, bee biti ba kpiya fanɛ awura yɛ alʋlʋnpʋ ansi tɔ, kɛ fan nyɛ ɔkpa tɔwɛ asɩn danbɩrasa mʋ lɩɩ mɛ sʋ sa bamʋ, yɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nɩɩ ba kan kpiya fanɛ asɩn ogyikpa mʋ, fan man yɩyɛɛ lɩɩ kʋtɔ mʋ nɩɩ fen biti fan tɔwɛ, abɛɛ kanan mʋ nɩɩ fan tɔwɛ mʋ sʋ. Saŋa mʋ kan fʋʋ mʋ, fen biti fan nyɛ asɩn mʋ nɩɩ fan tɔwɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Lɩɩ fɛɛ man gyɛ fanɛ gbaa‐gbaa ii biti fan tɔwɛ, amaa fanɛ‐Sɛ Ɩbwaarɛ Kayaayu mʋ ii biti ɔ bɔla fanɛ sʋ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kanɩn nkɛ maa tɔ mʋ, nyɩmɩsa ii biti o gyii mʋ gbaa‐gbaa mu‐supu kadɛ‐boyi, kɛ ba mɔɔ mʋ, kɛ ɔsɛ gbaa ɔ waa obii kanɩn. Nbii bee biti ba kʋsʋ yɩlɛ akʋʋgɛpʋ ana sʋ, kɛ ba yɛgɛ kɛ ba mɔɔ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Asa kpini bee biti ba kisi fanɛ lɩɩ mɛ sʋ, amaa ɔkʋmaa mʋ nɩɩ ɔ taalɛ yɩlɛ tɔ kenken naa fʋʋ laalaalʋwɛ mʋ, ii biti ɔ nyɛ kamɔlɩgɛ. ");
INSERT INTO naw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nɩɩ ba kan nyanla fanɛ kadɛ kʋ tɔ mʋ, fan sɩlɛ lɩɩ tʋtɔ kpee kadɛ kʋ tɔ. N tɔwɛ fanɛ kesintin fɛɛ, fɛn mɛɛ yɛ fan sɩlɛ kanɩn kyaabɔɔ Ɩsɩrayɩ ndɛ mʋ kpini sʋ, pɔyɩ kɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n ba. ");
INSERT INTO naw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ɔbɩɩlapʋ man kyɔ mʋ ɔkaapʋpʋ, nɩɩ kɩnyɛ man kyɔ mʋ‐nyɩrɩpɛ. ");
INSERT INTO naw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ɩ dagaa ɩ maa kʋkwɛ ɔbɩɩlapʋ fɛɛ maa ba waa fɛɛ mʋ ɔkaapʋpʋ. Nɩɩ kɩyaafɔlɛ mɔɔ ɔ ba waa fɛɛ mʋ‐nyɩrɩpɛ. Nɩɩ ba kan bɛɛ tɩn asɩn bɛɛ gyaga mɛ, kɩkpaara sʋ ɔbɩlɩsa sʋ yɛ n gyɛ Beelisebu mʋ, kanɩn bɩrɛ bee biti ba taa atɩɩ libi gyaga fanɛ mʋ nɩɩ fan gyɛ mɛ kɩkpaara sʋ abi mʋ ɩ kyɔ mɛ lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ɩmʋ sʋ fan man sɩlɛ asa. Kʋtɔ kʋmaa mʋ nɩɩ ki bun sʋ mʋ, ii biti i bugi sʋ, nɩɩ kʋtɔ kʋmaa mʋ nɩɩ kɩ baala mʋ, ii biti ɩ lɩɩ ifuli. ");
INSERT INTO naw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Asɩn kʋmaa mʋ nɩɩ n tɔwɛ fanɛ kitentenbiri tɔ mʋ, fan tɔwɛ ɩmʋ kakyʋwapɛ, nɩɩ asɩn kʋmaa mʋ nɩɩ n kuli waa fanɛ asʋ tɔ mʋ, fan da ɩmʋ kibonbon. ");
INSERT INTO naw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Fan man sɩlɛ bamʋ nɩɩ bɛɛ mɔɔ kayɩɩ‐wʋlɛ nkʋn, yɛgɛ ba mɛɛ taalɛ mɔɔ ɔkala. Amaa fan sɩlɛ Ɩbwaarɛ mʋ nɩɩ ɛɛ taalɛ nyita ɔkala yɛ kayɩɩ‐wʋlɛ, Sɩtaanɛ fʋlɔn tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Man gyɛ kobo kʋlʋn nɩɩ bɛɛ sʋ bɛɛ sɔɔ alangba anyɔ, amaa bamʋ tɔ ɔkʋlʋn mɛɛ yɛ ɔ tɩyɛ kasɛ sʋ wu, yɛgɛ fanɛ‐Sɛ Ɩbwaarɛ man sa ɔkpa. ");
INSERT INTO naw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Halɩɩ fanɛ ɔkʋmaa nɩmʋ kumu tɔ inyini gbaa, Ɩbwaarɛ nyi ɩmʋ kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ɩmʋ sʋ fan man waa kufuu, lɩɩ fɛɛ fan sʋ kyaarɛ fan kyɔ alangba damantɛ. ");
INSERT INTO naw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ɔkʋmaa mʋ nɩɩ ɛɛ lɛɛ ɛɛ tɔwɛ asa tɔ yɛ n gyɛ mʋ‐Nyɩrɩpɛ mʋ, kanɩn nɩɩ ngbaa mɛ n biti n lɛɛ mʋ kaapʋ mɛ‐Sɛ ansi tɔ sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amaa ɔkʋmaa mʋ nɩɩ o kina mɛ asa tɔ yɛ n man gyɛ mʋ‐Nyɩrɩpɛ mʋ, ngbaa mɛ n biti, n kina mʋ mɛ‐sɛ ansi tɔ sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Fan man fɛ nfɛɛrɛ fɛɛ n ba nɩn kɛ ɩ bɩya keyuula dulinyaa nɩmʋ tɔ. Man gyɛ keyuula nɩɩ n bɩya, amaa keluu nɩɩ n bɩya. ");
INSERT INTO naw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Lɩɩ fɛɛ n ba nɩn, ‘kɛ nbii‐nyɩnsa ba kʋsʋ yɩlɛ bamʋ‐sɛ ana sʋ, kɛ nbii‐kyɩɩsa gbaa ba kʋsʋ yɩlɛ bamʋ‐nyi ana sʋ, kɛ asaa‐kyɩɩsa ba kʋsʋ yɩlɛ bamʋ‐saa ana sʋ, ");
INSERT INTO naw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kɛ nyɩmɩsa mʋ dʋn ana ba baa ba gyɛ mʋ kɩkpaara sʋ asa.’ ");
INSERT INTO naw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ɔkʋmaa mʋ nɩɩ ee biti mʋ‐sɛ abɛɛ mu‐nyi ɔ kyɔ mɛ mʋ, ɔ man dagaa maa waa mɛ obuupu. Nɩɩ ɔkʋmaa mʋ nɩɩ ee biti mu‐bii‐nyɩnsa abɛɛ ɔkyɩɩsa ɔ kyɔ mɛ mʋ, man dagaa maa waa mɛ obuupu. ");
INSERT INTO naw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ man taa mu oyu laasa sʋla buu mɛ mʋ, man dagaa maa waa mɛ obuupu. ");
INSERT INTO naw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nɩɩ ɔkʋmaa mʋ nɩɩ ee biti mʋ nkpa mʋ kɩbaa sʋ mʋ, ee biti ɔ pan ɩmʋ, amaa ɔkʋmaa mʋ nɩɩ ɔ pan mʋ nkpa lɩɩ mɛ sʋ mʋ, ee biti ɔ nyɛ ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ fanɛ mʋ, kɔɔlɛ mɛ nɩmʋ, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ mʋ, kɔɔlɛ ɔmʋ nɩɩ o sun mɛ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ Ɩbwaarɛ ɔtɔwɛpʋ lɩɩ maa gyɛ Ɩbwaarɛ atɔwɛpʋ sʋ mʋ, ee biti ɔ nyɛ kʋkɔka mʋ nɩɩ Ɩbwaarɛ ii biti ɔ ka mʋ ɔtɔwɛpʋ mʋ. Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ ɔsa mʋ nɩɩ mʋ ɩkpa i kyiigi lɩɩ maa gyɛ ɩkpa kyiigisa wuya sʋ mʋ, ee biti ɔ nyɛ kʋkɔka mʋ nɩɩ Ɩbwaarɛ ii biti ɔ ka ɔsa mʋ nɩɩ mʋ ɩkpa i kyiigi mʋ. ");
INSERT INTO naw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ sa mɛ abɩɩlapʋ nɩmʋ tɔ ɔkʋ nkyu yuulisa kawɛ tɔ, lɩɩ fɛɛ maa gyɛ mɛ ɔbɩɩlapʋ sʋ mʋ, n tɔwɛ fanɛ kesintin fɛɛ, ɔ man yɛ ɔ pan mʋ kʋkɔka kpaa.” ");
INSERT INTO naw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu maa kaapʋ mʋ abɩɩlapʋ kudu anyɔ mʋ asɛ lʋwɛ mʋ, ɔ lɩɩ tʋtɔ kpee ɔ naa kaapʋ kɛ ɔ tɔwɛ asɩn danbɩrasa mʋ ndɛ mʋ nɩɩ ɩ san Galile ɔsʋwʋlɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Saŋa maa tɔ mʋ Gyɔn Okyugyeepu mʋ bʋ obu kitii tɔ. Maa nu kʋtɔ mʋ nɩɩ Krisito ɩɩ waa mʋ, o sun mʋ abɩɩlapʋ, ");
INSERT INTO naw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ba naa taasɛ mʋ yɛ, “Fʋ ɩ gyɛ ɔmʋ nɩɩ ba tɔwɛ anɛ yɛ ee biti ɔ ba mʋ, abɛɛ a kɩɩ ɔpʋpwɛ ɔkpa?” ");
INSERT INTO naw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fen bwii naa tɔwɛ Gyɔn asɩn mʋ nɩɩ fan nu yɛ ɩmʋ nɩɩ fan wu, ");
INSERT INTO naw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","fɛɛ agyaatanapʋ ansi i bugi, nɩɩ ayaa yɛ abaa wusa wuya ana ba kʋsʋ natɛ, nɩɩ abootipu n‐yɩɩ lɔŋɔ sʋ, nɩɩ atikpiri asʋ a tigi, nɩɩ alewupu ba kyiŋi ba nkpa tɔ, nɩɩ ba tɔwɛ Asɩn Danbɩrasa mʋ sa atiripu. ");
INSERT INTO naw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kusee ɩ gyɛ sa ɔsa mʋ nɩɩ ɔ man yɛgɛ mɛ kɩkɔɔlɛ‐gyii.” ");
INSERT INTO naw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Gyɔn Okyugyeepu abɩɩlapʋ mʋ ba maa bwii bee kpee mʋ, nɩɩ Yesu piili ɛɛ tɔwɛ Gyɔn n‐yɩɩ sʋ asɩn ɛɛ sa sakyɔ mʋ yɛ, “Mɩnɛ nɩɩ fan kpee Gyɔn asɛ kiperi mʋ sʋ fanaa kɩɩ? Fan kpee naa kɩɩ kifitiri mʋ nɩɩ afuu ɩɩ da kɩmʋ ii biliŋi tɔ nɩn? ");
INSERT INTO naw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nɩɩ man gyɛ kanɩn mʋ, mɩnɛ nɩɩ fen kpee naa kɩɩ? Nyɩmɩsa mʋ nɩɩ o bun ataa danbɩrasa mʋ, nɩɩ fan naa kɩɩ? Ayee, asa mʋ nɩɩ bee bun ataa danbɩrasa mʋ, ba tɛ iwurakpa nɩn. ");
INSERT INTO naw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nɩɩ mɩnɛ gbaa nɩɩ fan kpee naa kɩɩ? Ɩbwaarɛ ɔtɔwɛpʋ abɛɛ? Ɛɛhn, n tɔwɛ fanɛ yɛ ɔ kyɔ Ɩbwaarɛ ɔtɔwɛpʋ. ");
INSERT INTO naw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Lɩɩ fɛɛ Gyɔn nɩmʋ asɩn nɩɩ ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘N biti n sun mɛ kabɔɔ kɛ ɔ gyankpaa fʋ, mʋ ii biti ɔ ba lɔŋɔ fʋ ɔkpa yɩla fʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nɩɩ Yesu bɩla tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin yɛ, nyɩmɩsa kʋ man bʋ tɔ nɩɩ ba kʋʋgɛ mʋ kasɛ sʋ nfɩɩ, nɩɩ ɔ kyɔ Gyɔn okyugyeepu mʋ. Ɩmʋ kpini gbaa mʋ, ɔmʋ nɩɩ ɔ gyɛ pii sʋsʋ kuwura‐gyii mʋ tɔ mʋ kyɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Lɩɩ Gyɔn okyugyeepu saŋa ba lɩɩ ndaga mʋ, bamʋ nɩɩ bamʋ ansi ɩ payɩ yɛ bee biti ba loo sʋsʋ kuwura‐gyii mʋ tɔ mʋ, ba sʋ ɔlʋn yɛ kensi payɩ bee loo kɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lɩɩ fɛɛ Ɩbwaarɛ atɔwɛpʋ mʋ yɛ nbara mʋ, ɩ wʋla tɔwɛ lɩɩ kuwura‐gyii mʋ sʋ naa fʋʋ saŋa mʋ nɩɩ Gyɔn ba. ");
INSERT INTO naw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nɩɩ fan kan fen biti fan kɔɔlɛ kyula mʋ, Gyɔn ɩ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ Eligya mʋ nɩɩ ba tɔwɛ yɩla yɛ ee biti ɔ ba mʋ. ");
INSERT INTO naw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ɔmʋ nɩɩ ɔ sʋ asʋ nɩɩ ee biti o nu mʋ, o nu. ");
INSERT INTO naw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Mɩnɛ nɩɩ n taalɛ taa kaala ndaga asa? Ba du nɩn fɛɛ nbii ba maa tɛ agya tɔ bɛɛ tɩɩ abaa bɛɛ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘An fʋlɛ nleebi sa fanɛ, amaa fan man kyaa, nɩɩ an bɩɩ alengyi ɩlʋn, amaa fan man su.’ ");
INSERT INTO naw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Lɩɩ fɛɛ Gyɔn maa ba mʋ, o mee gyii nɩɩ o mee nuu, nɩɩ ba yɛ, ‘Nbwɩɩ libi ba tɛ Gyɔn sʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mɛ, Daadimaadi Obii‐nyɩnsa mʋ n maa ba mʋ, n gyii nɩɩ n nuu, nɩɩ ba yɛ, ‘Ee gyii gaa nɩɩ ɔ gyɛ ɔtabʋʋpʋ yɛ lenpoo akɔɔlɛpʋ yɛ alibi awaapʋ bamʋ kyɛmɩnɛ.’ Amaa nɩɩ ɔkʋ kan o buu Ɩbwaarɛ kanyaasɩn ɩkpa sʋ mʋ, ɩ kaapʋ fɛɛ mʋ kanyaasɩn mʋ gyɛ kesintin.” ");
INSERT INTO naw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Asa mʋ nɩɩ ba bʋ ndɛ mʋ nɩɩ Yesu waa mʋ asɩn kyinkyinsa gaalaagaa mʋ, ba man yɛgɛ bamʋ alibi kɩwaa, kanɩn sʋ Yesu tɔwɛ yii bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasin abi, fanɛ laakʋ! Betisayida abi, fanɛ laakʋ! Asɩn kyinkyinsa mʋ nɩɩ n waa fanɛ ndɛ nɩmʋ sʋ mʋ, nɩɩ ɩ daa ɩ gyɛ Tayi maa Sidon nɩn, naafɔɔ ba wʋla dɩla ɩbɔɔta, kɛ ba taa ndaara bun bamʋ amu, kɛ ɩ kaapʋ fɛɛ ba kyɛɛgɛ bamʋ nfɛɛrɛ lɩɩ alibi tɔ. ");
INSERT INTO naw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Amaa n tɔwɛ fanɛ yɛ, Tayi abi yɛ Sidon abi kʋsʋ bɩɩtɛ ii biti ɩ baa ɩ bɔ fanɛ lɛɛ kakɛ talɛsa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nɩɩ fanɛ Kapanum abi, fen biti fɛɛ ba kʋsaa fanɛ kpee sʋsʋ Ɩbwaarɛ ayɛ nɩn abɛɛ? Ayee, bee biti ba tʋʋ fanɛ waa awʋrʋfɔ fʋlɔn yen‐yen tɔ. Lɩɩ fɛɛ asɩn kyinkyinsa mʋ nɩɩ n waa fanɛ kadɛ tɔ mʋ, nɩɩ ɩ daa ɩ gyɛ Sodom nɩɩ n daa waa ɩmʋ nɩn, naafɔɔ kadɛ mʋ san kɩ bʋ tɔ ba lɩɩ ndaga. ");
INSERT INTO naw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amaa n tɔwɛ fanɛ yɛ, Sodom abi kʋsʋ bɩɩtɛ ii biti ɩ baa ɩ bɔ fanɛ lɛɛ kakɛ talɛsa mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saŋa maŋa nɩɩ Yesu tɔwɛ yɛ, “Mɛ‐Sɛ, fʋ gyɛ sʋsʋ yɛ kasɛ Ɔnyɩrɩpɛ, n yɩn fʋ, lɩɩ fɛɛ fʋ taa falɛ asɩn baala anyaasɩnpʋ yɛ anyipu sʋ, nɩɩ fʋ lɛɛ ɩmʋ kaapʋ nbii wuribi. ");
INSERT INTO naw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɩ gyɛ kanɩn nɩn, nɩɩ kanɩn ɩ gyɛ fʋ kɔkɔlɔ biti. ");
INSERT INTO naw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Mɛ‐Sɛ taa kʋtɔ kʋmaa nɩmʋ waa mɛ abaa tɔ. Ɔkʋ man nyi obii mʋ amɔɔ Ɔsɛ mʋ, nɩɩ ɔkʋ man nyi Ɔsɛ mʋ amɔɔ Obii mʋ, yɛ bamʋ nɩɩ Obii mʋ ii biti ɔ lɛɛ mʋ kaapʋ bamʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Fanɛ mʋ nɩɩ fan sʋ nsʋla budusa nɩɩ fan kpɩnɛ mʋ, fan ba mɛ asɛ, kɛ n sa fanɛ ɔfʋʋtɛ. ");
INSERT INTO naw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Fan kyula kɛ fan buu mɛ, kɛ fan kasɛ mɛ tɔ, kɛ fan nyɛ ɔfʋʋtɛ sa fanɛ kala ana, lɩɩ fɛɛ n du bwahn nɩɩ n bɩya mɛ n‐yɩɩ kasɛ lɩɩ mɛ kɔkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nɩɩ fan kan fan buu mɛ mʋ, ɩ man bʋlʋn nɩɩ mɛ kasʋla gbaa man budu.” ");
INSERT INTO naw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Saŋa maŋa nɩɩ Yesu maa mʋ abɩɩlapʋ ba naa alʋn kadɔɔ tɔ kakɛ fʋʋtɛsa akɛ kʋ. Nɩɩ akʋn a mɔɔ mʋ abɩɩlapʋ mʋ, nɩɩ ba piili bɛɛ gyayɩ alʋn mʋ ɩkʋ bɛɛ wɛ. ");
INSERT INTO naw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farasii abi mʋ ba maa wu ɩnɩmʋ mʋ, ba tɔwɛ Yesu yɛ, “Kɩɩ! Mɩnɛ ɩ waa sʋ nɩɩ fʋ abɩɩlapʋ bɛɛ waa kʋtɔ mʋ nɩɩ ɩ man dɛ ɔkpa kakɛ fʋʋtɛsa akɛ.” ");
INSERT INTO naw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu lɛɛ bamʋ kɔnɔ yɛ, “Fan man pɩɩta kalɛ kʋtɔ mʋ nɩɩ Owura Dawidi maa mʋ kamaa tɔ abi ba waa saŋa mʋ nɩɩ akʋn a mɔɔ bamʋ mʋ nɩn? ");
INSERT INTO naw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O loo kabwaarɛ‐sunkpa ayɛ naa taa bodobodo mʋ nɩɩ ba lɛɛ saraga sa Ɩbwaarɛ mʋ, nɩɩ maa mʋ asa mʋ ba wɛ. Nɩɩ Ɩbwaarɛ nbara tɔ mʋ ɩ man dɛ ɔkpa fɛɛ Dawidi maa bamʋ ba waa kanɩn, amɔɔ Ɩbwaarɛ aseepu nkʋn. ");
INSERT INTO naw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Abɛɛ fan man pɩɩta kalɛ Mosesi nbara mʋ tɔ wu fɛɛ, Ɩbwaarɛ aseepu ba maa sun kabwaarɛ‐sunkpa ayɛ mʋ tɔ, kakɛ fʋʋtɛsa akɛ mʋ, bee nyita nbara, amaa ɔkʋ man bun bamʋ kʋpwɛ? ");
INSERT INTO naw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","N tɔwɛ fanɛ fɛɛ ɔkʋ bʋ nfɩɩ ɔ kyɔ kabwaarɛ‐sunkpa ayɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ɩbwaarɛ tɔwɛ Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘Man gyɛ atɔbwaaya kɩtaa lɛɛ saraga sa mɛ nɩɩ n biti, amaa kuwu abaa kʋwɛɛ nɩɩ n biti.’ Nɩɩ fan kan nu asɩn nɩmʋ kasɛ nɩn, naafɔɔ fen mee bun asa mʋ nɩɩ ba man waa alibi mʋ kʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Lɩɩ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ, ɩ gyɛ kakɛ fʋʋtɛsa mʋ Ɔnyɩrɩpɛ.” ");
INSERT INTO naw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu maa lɩɩ tʋtɔ ee kpee mʋ, ɔ naa loo bamʋ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa. ");
INSERT INTO naw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nɩɩ ɔnyɩn kʋ bʋ tʋtɔ nɩɩ mʋ kɩbaa ki wu. Asa kʋ ba bʋ tʋtɔ nɩɩ ba maa biti ɔkpa ba nyɛ pwɩɩ Yesu sʋ mʋ, ba taasɛ mʋ yɛ, “Ɩ dɛ ɔkpa fɛɛ ba kyɛ alɔpʋ kakɛ fʋʋtɛsa akɛ abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nɩɩ Yesu taasɛ bamʋ yɛ, “Nɩɩ ɩ kan ba fɛɛ fanɛ tɔ ɔkʋ sʋ kabʋlʋpʋ nɩɩ ɔ tɩyɛ kɩkyabɔ tɔ kakɛ fʋʋtɛsa akɛ mʋ, ɔ mɛɛ lɛɛ mʋ lɩɩ kɩmʋ tɔ abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nɩɩ nyɩmɩsa kyɔ kabʋlʋpʋ naa ban sʋ falɛ mʋ, ɩmʋ sʋ ɩ dɛ ɔkpa nbara mʋ tɔ fɛɛ a waa adanbɩrasa kakɛ fʋʋtɛsa akɛ sa asa.” ");
INSERT INTO naw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tʋtɔ nɩɩ Yesu tɔwɛ ɔnyɩn mʋ yɛ, “Tɛɛŋɛ fʋ kɩbaa mʋ.” Nɩɩ ɔ tɛɛŋɛ kɩmʋ, opula tɔ nɩɩ kɩ nyɛ ɔlʋn fɛɛ kɩbanban mʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amaa Farasii abi mʋ ba lɩɩ kpee naa ŋmina kanan mʋ nɩɩ ba nyɛ ɔkpa mɔɔ Yesu. ");
INSERT INTO naw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu maa bɩɩ ɩnɩmʋ mʋ ɔ lɩɩ kanɩn opula maŋa, nɩɩ asa gaalaagaa ba buu mʋ, nɩɩ ɔ kyɛ bamʋ nɩɩ bɛɛ lɔ mʋ alɔ kpini. ");
INSERT INTO naw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Amaa ɔ da bamʋ amu tɔ yɛ ba man tɔwɛ ɔkʋ ɔsa mʋ nɩɩ ɔ gyɛ. ");
INSERT INTO naw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɩnɩmʋ ɩ waa nɩn kɛ asɩn mʋ nɩɩ Ɩbwaarɛ bɔla mʋ ɔtɔwɛpʋ Isaya sʋ tɔwɛ mʋ ɩ ba tɔ. Ɩmʋ ɩ gyɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kɩɩ! Mɛ kɩyaafɔlɛ mʋ nɩɩ n lɛɛ mʋ ndee, mʋ, nɩɩ n sʋ kebiti sa nɩɩ ɔ bɔla mi ansi. N biti n taa mɛ Kayaayu waa mʋ tɔ, kɛ ɔ tɔwɛ asɩn kyiigisa sa ndɛndɛmandɛ kpini. ");
INSERT INTO naw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɔ mɛɛ yɛ o gyii ɩmɔɔrɛ abɛɛ ɔ pʋntɛ tɔ, nɩɩ ɔ mɛɛ yɛ ɔ natɛ waa ɔlanba agbenbi sʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ɔ mɛɛ yɛ ɔ gya oyu‐bi nyɔnsa tɔ tii sʋ lʋwɛ nɩɩ o mee dun fɩtɩla mʋ nɩɩ kɩ man kɩɩ tɔ mʋ. Ee biti ɔ yɩlɛ tɔ kɛ ɔ yɛgɛ asɩn kyiigisa mʋ i gyii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nɩɩ asa kpini bee biti ba taa bamʋ tamaa tʋʋ mʋ nkʋn sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kakaakʋ asa akʋ ba taa ɔnyɩn kʋ bɩya Yesu. Ɔ gyɛ gyaatanapʋ yɛ naamuu lɩɩ fɛɛ nbwɩɩ libi ba tɛ mʋ sʋ. Yesu kyɛ mʋ, nɩɩ mu ansi i bugi nɩɩ ɔ bɩla ɛɛ taalɛ ɛɛ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nɩɩ ii kyinkyin asa mʋ kpini, nɩɩ ba taasɛ abaa yɛ, “Ɔnyɩn nɩmʋ ɩ gyɛ Dawidi kanaana‐bii mʋ do?” ");
INSERT INTO naw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amaa Farasii abi mʋ ba maa nu ɩnɩmʋ mʋ, ba tɔwɛ nɩn yɛ, “Nbwɩɩ libi kumu mʋ nɩɩ bɛɛ tɩɩ yɛ Beelisebu mʋ ɩɩ sa ɔnyɩn nɩmʋ ɔlʋn, nɩɩ ɛɛ taalɛ ɛɛ gya nbwɩɩ libi ɛɛ kʋsʋ asa sʋ kanɩn mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu bɩɩ bamʋ nfɛɛrɛ nɩɩ ɔ tɔwɛ bamʋ yɛ, “Nɩɩ Kuwura‐gyii kʋmaa tɔ asa ba kan barɩgɛ tɔ bɛɛ kɔ yɛ abaa mʋ, kɩ mɛɛ kyɛɛrɛɛ nɩɩ kɩ tɩyɛ. Nɩɩ kadɛ abɛɛ kɩkpaara sʋ abi ba kan barɩgɛ tɔ bɛɛ kɔ yɛ abaa mʋ, kadɛ abɛɛ kɩkpaara maŋa kii biti ki boyi. ");
INSERT INTO naw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nɩɩ ɩ kan ɩ gyɛ kesintin fɛɛ Sɩtaanɛ ɩɩ gya Sɩtaanɛ mʋ, ɩɩ kaapʋ fɛɛ ɔ barɩgɛ mʋ n‐yɩɩ tɔ kɩnyɔ nɩn. Ɩmʋ sʋ nɛnɛ nɩɩ mu kuwura‐gyii mʋ kɩ bɩla taalɛ yɩlɛ? ");
INSERT INTO naw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Fan yɛ Beelisebu ɩɩ sa mɛ ɔlʋn nɩɩ n sʋ n gya nbwɩɩ libi n kʋsaa asa sʋ. To, kanɩn bɩrɛ anɩmʋ ɩɩ sa fanɛ abɩɩlapʋ ɔlʋn nɩɩ bɛɛ taalɛ bɛɛ gya nbwɩɩ libi bɛɛ kʋsaa asa sʋ? Fanɛ gbaa‐gbaa fanɛ abɩɩlapʋ ii biti ba bun fanɛ kʋpwɛ fɛɛ fan man sʋ kesintin. ");
INSERT INTO naw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amaa nɩɩ ɩ gyɛ Ɩbwaarɛ Kayaayu nɩɩ n sʋ n gya nbwɩɩ libi n kʋsaa asa sʋ mʋ, kanɩn bɩrɛ fan bɩɩ fɛɛ Ɩbwaarɛ kuwura‐gyii mʋ kɩ wʋla kɩ bʋ fanɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nɩɩ Yesu bɩla kyaga sʋ yɛ, “Ɔkʋ mɛɛ taalɛ loo ɔlʋlʋnpʋ kʋ kɩkpaara sʋ naa swii mʋ kapatɩyɛ, amɔɔ ɔ gyankpaa ŋmina mʋ yɩla pɔyɩ kɛ ɔ lan taalɛ naa swii mʋ kapatɩyɛ lɩɩ kɩkpaara mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ɔkʋmaa mʋ nɩɩ ɔ man tii mɛ sʋ mʋ, ii kisi mɛ nɩn, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ mɛɛ kʋʋla ɛɛ kyɛ mɛ tɔ mʋ, ɛɛ yaasɛ asa mʋ nɩɩ n kʋʋla mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ɩmʋ sʋ, n tɔwɛ fanɛ yɛ, ɔkʋmaa mʋ nɩɩ ɔ waa alibi abɛɛ ɔ tɔwɛ yii Ɩbwaarɛ mʋ, Ɩbwaarɛ ii biti ɔ taa kɛɛ mʋ. Amaa ɔkʋmaa mʋ nɩɩ ɔ tɔwɛ yii Kayaayu Kyɩrɛkyɩrɛ mʋ, Ɩbwaarɛ mɛɛ yɛ ɔ taa kɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ tɔwɛ asɩn kʋ yii mɛ, Daadimaadi Obii‐nyɩnsa mʋ, Ɩbwaarɛ ii biti ɔ taa kɛɛ mʋ, amaa ɔkʋmaa mʋ nɩɩ ɔ tɔwɛ asɩn yii Kayaayu Kyɩrɛkyɩrɛ mʋ bɩrɛ, Ɩbwaarɛ mɛɛ yɛ ɔ taa kɛɛ mʋ nbɩɩnbɩɩ saŋa nɩmʋ tɔ abɛɛ saŋa mʋ nɩɩ ii biti ɩ ba mʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nɩɩ fʋ kan kyula yɛ oyu kʋ abi ɩ gyɛ abi danbɩrasa mʋ, oyu maa gbaa gyɛ oyu danbɩrasa nɩn, amaa nɩɩ fʋ kan kina yɛ oyu kʋ abi man gyɛ abi danbɩrasa bɩrɛ, oyu maa gbaa man gyɛ oyu danbɩrasa. Lɩɩ fɛɛ oyu abi sɔyɩsa nɩɩ bɛɛ sʋ bɛɛ bɩɩ kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Fanɛ asa libi fɛɛ anansɛ, nɛnɛ nɩɩ fɛn taalɛ tɔwɛ ɩmʋ nɩɩ ɩ bʋrɔn, yɛgɛ fanɛ atɔ waasa gyɛ alibi? Lɩɩ fɛɛ kʋtɔ mʋ nɩɩ kɩ bʋ nyɩmɩsa kɔkɔlɔ tɔ mʋ, kɩmʋ ɩɩ lɩɩ mʋ kɔnɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nyɩmɩsa danbɩrasa bɩrɛ, atɔ danbɩrasa mʋ nɩɩ ɩ bʋ mʋ tɔ mʋ, nɩɩ ɛɛ lɛɛ ɛɛ tɔwɛ, nɩɩ nyɩmɩsa libi mɔɔ, atɔ libi mʋ nɩɩ ɩ bʋ mʋ tɔ mʋ, nɩɩ ɛɛ lɛɛ ɛɛ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Amaa n tɔwɛ fanɛ fɛɛ, katɔwɛ gyaga kʋmaa mʋ nɩɩ ɔsa kʋmaa nɩmʋ tɔwɛ mʋ, ee biti ɔ lɛɛ kɩmʋ kɔnɔ Ɩbwaarɛ ansi tɔ, kakɛ mʋ nɩɩ Ɩbwaarɛ ii biti ɔ talɛ asa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Lɩɩ fɛɛ fʋ ntɔwɛ nɩɩ Ɩbwaarɛ ii biti ɔ yɩlɛ sʋ talɛ fʋ fɛɛ fu gyii asʋ abɛɛ fu gyii kʋpwɛ.” ");
INSERT INTO naw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tʋtɔ nɩɩ nbara akaapʋpʋ akʋ yɛ Farasii abi akʋ ba tɔwɛ yɛ, “Ɔkaapʋpʋ an biti fɛɛ fʋ waa asɩn kyinkyinsa kaapʋ anɛ.” ");
INSERT INTO naw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ndaga kakyɩna nɩmʋ tɔ alibi awaapʋ yɛ bamʋ nɩɩ be mee sun Ɩbwaarɛ ɩɩ kɩɩ bee biti asɩn kyinkyinsa. Amaa baa mɛɛ nyɛ ɩmʋ, amɔɔ sɩnkaala mʋ nɩɩ ɩ ba Ɩbwaarɛ ɔtɔwɛpʋ Gyona sʋ mʋ, nɩɩ n biti n waa kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Fɛɛ kanan mʋ nɩɩ Gyona gyii nkɛ nsa ibiri ɔkɩn lala ɔtɔ tɔ mʋ, kanɩn maŋa nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ gbaa n biti n gyii nkɛ nsa ibiri kasɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kakɛ mʋ nɩɩ Ɩbwaarɛ ii biti ɔ talɛ asa kpini mʋ, Ninewe abi bee biti ba kʋsʋ, kɛ ba bun ndaga kakyɩna nɩmʋ tɔ asa kʋpwɛ. Lɩɩ fɛɛ saŋa mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Gyona naa tɔwɛ bamʋ Ɩbwaarɛ asɩn mʋ ba yɛgɛ alibi kɩwaa. Amaa mɛ, mʋ nɩɩ n kyɔ Ɩbwaarɛ ɔtɔwɛpʋ Gyona mʋ n bʋ nfɩɩ. ");
INSERT INTO naw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nɩɩ kakɛ mʋ nɩɩ Ɩbwaarɛ ii biti ɔ talɛ asa kpini mʋ, Seeba Owura‐kyɩɩsa mʋ nɩɩ ɔ lɩɩ kata‐kata mʋ, ii biti ɔ kʋsʋ yɩlɛ kɛ o bun ndaga kakyɩna nɩmʋ tɔ asa kʋpwɛ. Lɩɩ fɛɛ ɔ lɩɩ koo kata‐kata ba nu Owura Solomon kanyaasɩn kɩkaapʋ mʋ. Amaa mɛ mʋ nɩɩ n kyɔ Solomon mʋ n bʋ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesu kyaga sʋ yɛ, “Nɩɩ kayaayu libi dan kʋsʋ nyɩmɩsa sʋ mʋ, kɩ naa kɩ naa ofuli sʋ nɩn kii biti ɔkyɩnakpa. Amaa nɩɩ kɩ man kan nyɛ mʋ, ");
INSERT INTO naw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kɩ tɔwɛ sa kɩmʋ n‐yɩɩ yɛ, ‘N biti n bwii kpee mɛ kɩkpaara mʋ nɩɩ n lɩɩ mʋ sʋ.’ Nɩɩ ɔ kan ba fʋʋ nɩɩ o wu fɛɛ sɛhn man bʋ kɩmʋ tɔ, yɛgɛ kɩ lɔŋɔ kɩ dɛ yɛ ɔdan mʋ, ");
INSERT INTO naw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tʋtɔ nɩɩ ɛɛ lɩɩ kpee kɛ ɔ naa taa mʋ tɔɔmaa ana n‐yaayu libi asunɔ mʋ nɩɩ ba libi ba kyɔ mʋ tii mʋ n‐yɩɩ sʋ, kɛ ba kpee naa kyɩna tʋtɔ. Saamʋ, kanan mʋ nɩɩ ɔ daa o du mʋ, ii biti ɩ baa ɩ kyɔ kanɩn. Kanɩn nɩɩ ii biti ɩ baa i du sa ndaga kakyɩna kanɩmʋ tɔ asa libi.” ");
INSERT INTO naw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu maa san ɔ maa sʋ ɛɛ tɔwɛ ɛɛ sa sakyɔ mʋ, mu‐nyi yɛ mu‐supu ana ba ba yɩlɛ nbwama bee biti fɛɛ ba tɔwɛ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nɩɩ ɔkʋ tɔwɛ Yesu yɛ, “Fu‐nyi yɛ fu‐supu ana ba yɩlɛ nbwama bee biti fɛɛ ba tɔwɛ fʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Anɩmʋ ɩ gyɛ mi‐nyi, nɩɩ anɩmʋ ana ɩ gyɛ mu‐supu ana?” ");
INSERT INTO naw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tʋtɔ nɩɩ ɔ tɛɛŋɛ mʋ kɩbaa kaapʋ mʋ abɩɩlapʋ, tɔwɛ yɛ, “Fan kɩɩ! Mi‐nyi yɛ mi‐supu ana ndee. ");
INSERT INTO naw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɛɛ waa mɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ kɔkɔlɔ biti mʋ, ɩ gyɛ mi‐supu yɛ mɛ‐pɩɩkyɩɩ yɛ mi‐nyi.” ");
INSERT INTO naw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kanɩn kakɛ maŋa nɩɩ Yesu lɩɩ kɩkpaara sʋ kpee naa kyɩna ɔbʋn kaa ɛɛ kaapʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Asa damantɛ ba maa kyaabɔɔ mʋ mʋ, o loo ɔkʋlɩ tɔ naa kyɩna yɛgɛ asa mʋ ba yɩlɛ ɔbʋn‐kaa. ");
INSERT INTO naw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nɩɩ ɔ taa aŋasan tɔ kaapʋ bamʋ atɔ damantɛ. Ɔ bɔ bamʋ kɩŋasan kʋ yɛ, “Ɔdɔɔpʋ kʋ ɩ bʋ tɔ nɩɩ o kpee ɔ naa ŋmatɛ ayu. ");
INSERT INTO naw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Maa naa ŋmatɛ ɩmʋ mʋ, ɩkʋ ɩ tɩyɛ ɔkpakaa, nɩɩ nbwiibi ba ba tasɛ ɩmʋ gyii. ");
INSERT INTO naw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nɩɩ ɩkʋ ɩ tɩyɛ afʋlɛ sʋ, katɩn mʋ nɩɩ ɩsɛ ɩ man kyɔ. Nɩɩ ɩ kɔyɩ bilen kpalɩ fɛɛ ɩsɛ mʋ maa man bʋnyɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amaa kyɔwɛ maa ba ɛɛ da mʋ, i fugya ɩmʋ, nɩɩ i wu lɩɩ fɛɛ ɩmʋ ilin ɩ man kyɔ. ");
INSERT INTO naw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nɩɩ ɩkʋ mɔɔ ɩ tɩyɛ iwii tɔ, nɩɩ iwii mʋ ɩ dan nyan kɩtaa ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amaa ayu mʋ ɩkʋ ɩ tɩyɛ kasɛ danbɩrasa sʋ, nɩɩ ɩ sɔyɩ amu lala‐lala. Ɩkʋ ɩ gyɛ kɩlɩfa, nɩɩ ɩkʋ ɩ gyɛ adisiye, nɩɩ ɩkʋ mɔɔ adɩsa. ");
INSERT INTO naw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ɔmʋ nɩɩ ɔ sʋ asʋ nɩɩ ee biti o nu mʋ o nu.” ");
INSERT INTO naw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nɩɩ Yesu abɩɩlapʋ mʋ ba ba mʋ asɛ ba taasɛ mʋ yɛ, “Mɩnɛ ɩ waa nɩɩ aŋasan tɔ nɩɩ fʋ sʋ fɩɩ kaapʋ asa?” ");
INSERT INTO naw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Fanɛɛ fanɛ bɩrɛ ɔkpa bugi sa fanɛ fɛɛ fan bɩɩ Ɩbwaarɛ kuwura‐gyii mʋ tɔ asiri asɩn mʋ, amaa bamɛɛ bamʋ bɩrɛ ɩ man bugi sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɔ sʋ Ɩbwaarɛ asɩn mʋ, bee biti ba sa mʋ gaa tii sʋ, kɛ ɔ nyɛ kyʋn sʋ. Amaa ɔkʋmaa mʋ nɩɩ ɔ man sʋ mʋ, halɩɩ pii kʋmaa mʋ nɩɩ ɔ sʋ mʋ gbaa mʋ, bee biti ba kɔɔlɛ lɩɩ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kʋtɔ mʋ sʋ nɩɩ n sʋ aŋasan n kaapʋ bamʋ mʋ ɩ gyɛ fɛɛ, Bɛɛ kɩɩ amaa be mee wu, bee nu, amaa be mee nu danbɩrasa abɛɛ be nu ɩmʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ɩmʋ sʋ asɩn mʋ nɩɩ Ɩbwaarɛ bɔla mʋ ɔtɔwɛpʋ Isaya sʋ tɔwɛ yɩla mʋ, ɩ ba tɔ asa nɩmʋ sʋ. Ɩmʋ ɩ gyɛ yɛ, ‘Fen biti fan nu kɛ fan nu, amaa fɛn mɛɛ yɛ fan nu kasɛ. Fen biti fan kɩɩ kɛ fan kɩɩ, amaa fɛn mɛɛ yɛ fan wu sɛhn. ");
INSERT INTO naw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Lɩɩ fɛɛ asa banɩmʋ bamʋ nkɔlɔ ɩ bʋlʋn, nɩɩ ba tii bamʋ asʋ, nɩɩ ba bun bamʋ ansi sʋ. Naafɔɔ bamʋ ansi ii biti i wu, kɛ bamʋ asʋ ii nu, kɛ bamʋ nkɔlɔ tɔ ii nu asɩn kasɛ, kɛ ba bwii ba mɛ, Ɩbwaarɛ asɛ kɛ n kyɛ bamʋ alɔ.’ ");
INSERT INTO naw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kusee ɩ gyɛ sa fanɛ mʋ nɩɩ fanɛ ansi ii wu nɩɩ fanɛ asʋ ii nu. ");
INSERT INTO naw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","N tɔwɛ fanɛ kesintin yɛ Ɩbwaarɛ atɔwɛpʋ gaalaagaa yɛ asa mʋ nɩɩ bamʋ ɩkpa i kyiigi Ɩbwaarɛ asɛ mʋ, bee biti gaa fɛɛ ba wu atɔ mʋ nɩɩ fen wu yɛ ɩmʋ nɩɩ fen nu falɛ, amaa ba man nyɛ ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nbɩɩnbɩɩ fan nu kɩŋasan lɩɩ ayu ɔŋmatɛpʋ mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ayubi mʋ nɩɩ ɩ tɩyɛ ɔkpakaa mʋ du nɩn fɛɛ, bamʋ nɩɩ bee nu Ɩbwaarɛ kuwura‐gyii mʋ asɩn, nɩɩ ba man nu ɩmʋ kasɛ mʋ, nɩɩ Sɩtaanɛ ɛɛ ba bɛ lɛɛ abi mʋ nɩɩ ba ŋmatɛ mʋ lɩɩ bamʋ nkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ayubi mʋ nɩɩ ɩ tɩyɛ afʋlɛ sʋ mɔɔ mʋ, i du nɩn fɛɛ bamʋ nɩɩ bee nu asɩn danbɩrasa mʋ, nɩɩ ba taa kɔkɔlɔ fuuli kɔɔlɛ ɩmʋ opula tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amaa ɩ maa man loo bamʋ nkɔlɔ tɔ kyɛɛkyɛɛ sʋ mʋ, asɩn mʋ mɛɛ kyɛɛrɛɛ bamʋ tɔ. Ɩmʋ sʋ nɩɩ awʋrʋfɔ abɛɛ kanyanla dan ɩ ba bamʋ sʋ lɩɩ asɩn mʋ sʋ mʋ, opula tɔ nɩɩ bɛɛ tɩyɛ lɩɩ bamʋ kɩkɔɔlɛ‐gyii tɔ. ");
INSERT INTO naw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ayubi mʋ nɩɩ ɩ tɩyɛ iwii tɔ mʋ ɩ gyɛ bamʋ nɩɩ bee nu asɩn danbɩrasa mʋ, amaa dulinyaa nɩmʋ tɔ atɔ tɔɔrɔɔsa yɛ kafulee biti bansa mʋ, ɩɩ nyan kɩtaa asɩn danbɩrasa mʋ, nɩɩ ɩ mɛɛ sɔyɩ abi. ");
INSERT INTO naw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amaa ayubi mʋ nɩɩ ɩ tɩyɛ kasɛ danbɩrasa tɔ mʋ, ɩ gyɛ bamʋ nɩɩ bee nu asɩn danbɩrasa mʋ nɩɩ bee nu ɩmʋ kasɛ mʋ, ɩmʋ sʋ bɛɛ waa atɔ danbɩrasa gaa fɛɛ ayubi mʋ nɩɩ ɩɩ sɔyɩ abi kɩlɩfa nɩɩ ɩkʋ adisiye nɩɩ ɩkʋ mɔɔ adɩsa mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nɩɩ Yesu bɩla bɔ bamʋ kɩŋasan kʋ yɛ, “Sʋsʋ kuwura‐gyii mʋ du nɩn fɛɛ ɔnyɩn kʋ maa naa ŋmatɛ ayubi danbɩrasa mʋ ndɔɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Asa ba maa dɛ lʋwɛ kagyanbwɛ mʋ, ɔdɔɔpʋ maŋa mʋ‐dʋn naa taa afitiri libi ŋmatɛ waa ayu mʋ tɔ, nɩɩ ɔ natɛ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ayu mʋ maa nyɛ ɩtɔ ɩɩ kʋʋgɛ mʋ, nɩɩ afitiri libi mʋ gbaa ɩɩ dan. ");
INSERT INTO naw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Nɩɩ kadɔɔ wuya mʋ ayaafɔlɛ ba ba mʋ asɛ ba tɔwɛ mʋ yɛ, ‘Ɔnyɩrɩpɛ, man gyɛ ayubi danbɩrasa nɩɩ fʋ ŋmatɛ fʋ ndɔɔ mʋ tɔ? Fɩnɛ nɩɩ afitiri libi nɩmʋ ɩ lɩɩ?’ ");
INSERT INTO naw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Nɩɩ ɔ lɛɛ bamʋ kɔnɔ yɛ, ‘Mɛ‐dʋn kʋ ɩ waa kanɩn.’ “Nɩɩ mʋ ayaafɔlɛ mʋ ba taasɛ mʋ yɛ, ‘Fii biti fɛɛ a naa kyiigi ɩmʋ abɛɛ?’ ");
INSERT INTO naw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Nɩɩ bamʋ‐nyɩrɩpɛ mʋ lɛɛ bamʋ kɔnɔ yɛ, ‘Ayee, fan yɛgɛ ɩmʋ kikyiigi, lɩɩ fɛɛ fan kan yɛ fen kyiigi afitiri libi mʋ, fen biti fan kyiigi bʋga yɛ ayu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Fan yɛgɛ ɩmʋ kpini ɩ bʋga dan naa fʋʋ kɩtɩŋɛ saŋa. Kanɩn saŋa maa mʋ, n biti n tɔwɛ atɩŋɛpʋ mʋ yɛ, ba daa kɩkpantɛ afitiri libi mʋ ŋmina ntun‐ntun kɛ ba tuwa ɩmʋ. Kɛ ba laata ayu mʋ naa waa mɛ kɩkyagɩla tɔ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nɩɩ Yesu bɩla bɔ bamʋ kɩŋasan kʋ yɛ, “Sʋsʋ kuwura‐gyii mʋ du nɩn fɛɛ ɔnyɩn kʋ maa taa masitadi oyu kibi pii naa duu mʋ ndɔɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Halɩɩ oyu maŋa kibi kɩ maa du pii iyu abi kpini tɔ gbaa mʋ, kɩɩ dan kɩ kyɔ apʋnfa kpini, nɩɩ kɩɩ ba waa oyu nɩɩ nbwiibi bɛɛ ba waa bamʋ nsʋswaa kɩmʋ n‐yaabi sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nɩɩ Yesu bɩla bɔ bamʋ kɩŋasan yɛ, “Sʋsʋ kuwura‐gyii mʋ ki du nɩn fɛɛ ɔkyɩɩ kʋ maa taa kɩfa‐tinsa kyagɩlɛ bodobodo inyifo ɩkyɛmɩsɛ ɩlala ɩsa tɔ mʋ, nɩɩ inyifo mʋ i tin nyɛ akyɔ.” ");
INSERT INTO naw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aŋasan tɔ nɩɩ Yesu tɔwɛ ɩnɩmʋ sa sakyɔ mʋ. Ɔ man tɔwɛ sɛhn sa bamʋ yɛgɛ ɩ man gyɛ aŋasan tɔ. ");
INSERT INTO naw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yesu waa kanɩn nɩn kɛ asɩn mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ tɔwɛ yɩla mʋ ɩ ba tɔ. Asɩn mʋ ɩ gyɛ yɛ, “Aŋasan tɔ nɩɩ n biti n tɔwɛ bamʋ asɛ, N biti n tɔwɛ bamʋ asɩn baalasa mʋ nɩɩ ɔkʋ man nyi ɩmʋ lɩɩ koo dulinyaa npiili asɛ.” ");
INSERT INTO naw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nɩɩ Yesu lɩɩ sakyɔ mʋ asɛ nɩɩ ɔ kyʋn kɩkpaara sʋ, nɩɩ mʋ abɩɩlapʋ mʋ ba ba mʋ asɛ ba tɔwɛ mʋ yɛ, “Kaapʋ anɛ kɩŋasan mʋ nɩɩ fʋ bɔ lɩɩ ayu yɛ afitiri libi mʋ kasɛ.” ");
INSERT INTO naw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Ɔdɔɔpʋ mʋ nɩɩ o duu ayubi danbɩrasa mʋ ɩ gyɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ndɔɔ mʋ ɩ gyɛ dulinyaa, nɩɩ ayubi danbɩrasa mʋ ɩ gyɛ Ɩbwaarɛ kuwura‐gyii mʋ tɔ asa. Afitiri libi mʋ mɔɔ ɩ gyɛ bamʋ nɩɩ ba gyɛ Sɩtaanɛ asa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nɩɩ ɔdʋn mʋ nɩɩ o duu afitiri libi mʋ ɩ gyɛ Sɩtaanɛ. Ayu mʋ kɩtɩŋɛ saŋa mʋ ɩ gyɛ dulinyaa laalaalʋwɛ. Nɩɩ atɩŋɛpʋ mʋ ɩ gyɛ Ɩbwaarɛ nbɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ɩmʋ sʋ fɛɛ kanan mʋ nɩɩ ba kpantɛ afitiri libi mʋ tuwa mʋ, kanɩn nɩɩ ii biti ɩ waa dulinyaa laalaalʋwɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mɛ, Daadimaadi Obii‐nyɩnsa mʋ, n biti n sun mɛ sʋsʋ nbɔɔ, kɛ ba ba tasɛ kʋtɔ kʋmaa mʋ nɩɩ kɩɩ pɩna asa nɩɩ bɛɛ waa alibi mʋ, yɛ bamʋ nɩɩ bɛɛ waa alibi mʋ, lɩɩ mi kuwura‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kɛ ba taa bamʋ tʋʋ waa awʋrʋfɔ fʋlɔn yen‐yen mʋ tɔ, opula mʋ nɩɩ kusu yɛ anobi kiduŋi bʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amaa bamʋ nɩɩ bamʋ ɩkpa i kyiigi Ɩbwaarɛ asɛ mʋ bee biti ba ŋalɩgɛ sʋ fɛɛ kyɔwɛ bamʋ‐Sɛ kuwura‐gyii mʋ tɔ. Ɔmʋ nɩɩ ɔ sʋ asʋ nɩɩ ee biti o nu mʋ o nu.” ");
INSERT INTO naw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nɩɩ Yesu bɩla bɔ bamʋ kɩŋasan kʋ yɛ, “Sʋsʋ kuwura‐gyii mʋ ki du nɩn fɛɛ atɔ kparɛ fɛɛ suwa mʋ nɩɩ ba taa baala nɩɩ ɔnyɩn kʋ naa benti kasɛ kʋ sʋ. Maa wu ɩmʋ mʋ, nɩɩ o bwii bun ɩmʋ sʋ. Ɩ maa waa mʋ ɔkɔn gaa sʋ mʋ, nɩɩ ɔ naa taa mʋ atɔ kpini fɛɛ nɩɩ ɔ naa sɔɔ kanɩn kasɛ maŋa. ");
INSERT INTO naw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Sʋsʋ kuwura‐gyii mʋ kɩ bɩla ki du nɩn fɛɛ, ɔyaawʋ‐gyipu maa naa ee biti kigyibi kparɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nɩɩ maa naa nyɛ kʋkʋ nɩɩ kɩ gyɛ kɩkparɛ mʋ, ɔ naa fɛ mʋ atɔ mʋ nɩɩ ɔ sʋ mʋ kpini, nɩɩ ɔ naa sɔɔ kɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nɩɩ Yesu bɩla tɔwɛ yɛ, “Sʋsʋ kuwura‐gyii mʋ bɩla ki du nɩn fɛɛ, ɩkɩn ɔkɩtapʋ maa tʋʋ mʋ kisewu kɩtaa ɩkɩn kʋkwɩɩ‐kʋkwɩɩ. ");
INSERT INTO naw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ɩkɩn mʋ ba maa bɔla kisewu mʋ nɩɩ akɩtapʋ mʋ ba bɩɩtɛ kɩmʋ ba ɔlɩɩkaa nɩɩ ba kyɩna tasɛ adanbɩrasa mʋ waa alantan tɔ, nɩɩ ba taa bamʋ nɩɩ ba man bʋrɔn mʋ fɔyɩ. ");
INSERT INTO naw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kanɩn nɩɩ ii biti ɩ ba waa dulinyaa laalaalʋwɛ mʋ. Ɩbwaarɛ nbɔɔ mʋ bee biti ba ba tasɛ asa libi lɛɛ asa danbɩrasa tɔ, ");
INSERT INTO naw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kɛ ba taa bamʋ tʋʋ waa awʋrʋfɔ fʋlɔn yen‐yen mʋ tɔ, opula mʋ nɩɩ kusu yɛ anobi kiduŋi bʋ.” ");
INSERT INTO naw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nɩɩ Yesu taasɛ bamʋ yɛ, “Fan nu ɩmʋ nɩɩ n tɔwɛ fanɛ kpini kasɛ?” Nɩɩ ba yɛ, “Ɛɛhn, an nu ɩmʋ kasɛ.” ");
INSERT INTO naw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Kanɩn sʋ, nbara ɔkaapʋpʋ kʋmaa mʋ nɩɩ ɔ ba waa ɔbɩɩlapʋ lɩɩ sʋsʋ kuwura‐gyii sʋ mʋ, du nɩn fɛɛ kɩkpaara wuya mʋ nɩɩ ɔ lɛɛ mʋ atɔ kparɛ pʋpwɛ yɛ adɩdaa lɩɩ mu obu to mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu maa bɔ bamʋ aŋasan anɩmʋ lʋwɛ mʋ, ɔ lɩɩ kadɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nɩɩ o kpee mʋ gbaa‐gbaa mʋ kadɛ tɔ. Nɩɩ ɔ naa piili ɛɛ kaapʋ asa bamʋ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa, nɩɩ i kyinkyin bamʋ. Nɩɩ ba taasɛ yɛ, “Fɩnɛ nɩɩ ɔnyɩn nɩmʋ nyɛ falɛ kanyaasɩn yɛ asɩn kyinkyinsa nɩmʋ lɩɩ? ");
INSERT INTO naw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Man gyɛ kapinta mu‐bii mʋ ndee? Man gyɛ mu‐nyi ɩ gyɛ Mɛɛrɩ mʋ? Nɩɩ man gyɛ mu‐supu ana ɩ gyɛ Gyemisi yɛ Gyosefu yɛ Simon yɛ Gyudasi mʋ? ");
INSERT INTO naw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Man gyɛ mʋ pɩɩkyɩɩ ana kpini ɩ bʋ ana asɛ nfɩɩ? Nɩɩ fɩnɛ nɩɩ ɔ nyɛ falɛ asɩn nɩmʋ kpini lɩɩ?” ");
INSERT INTO naw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɩmʋ sʋ ba kina kɩkɔɔlɛ mʋ. Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Ɩbwaarɛ ɔtɔwɛpʋ kʋmaa nɩmʋ sʋ bɛɛrɛɛ katɩn kʋmaa, amɔɔ mʋ kadɛ tɔ yɛ mʋ kɩkpaara sʋ abi nkʋn asɛ nɩɩ ɔ man sʋ bɛɛrɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesu man waa asɩn kyinkyinsa gaalaagaa tʋtɔ, lɩɩ fɛɛ asa mʋ ba maa man sʋ kɩkɔɔlɛ‐gyii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Saŋa maa tɔ nɩɩ owura Herodi mʋ nɩɩ ɛɛ kɩɩ Galile sʋ mʋ nu asɩn lɩɩ Yesu sʋ, ");
INSERT INTO naw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nɩɩ ɔ tɔwɛ mʋ kamaa abi mʋ yɛ, “N kɔɔlɛ gyii fɛɛ Gyɔn okyugyeepu mʋ i kyiŋi lɩɩ lewu tɔ ba, ɩmʋ sʋ nɩɩ ɔ sʋ falɛ ɔlʋn ɛɛ waa asɩn kyinkyinsa nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodi nɩmʋ wʋla yɛgɛ nɩɩ ba kɩtaa Gyɔn ŋmina taa mʋ tii obu, lɩɩ Herodiya mʋ nɩɩ naafɔɔ ɔ daa ɔ gyɛ Herodi maŋa mu‐supu Filipu mʋ‐ka mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Lɩɩ fɛɛ Gyɔn daa kyɩna ɛɛ tɔwɛ mʋ yɛ, “Ɩ man dɛ ɔkpa fɛɛ fʋ kɔɔlɛ fu‐supu mʋ‐ka Herodiya kili.” ");
INSERT INTO naw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Naafɔɔ Herodi daa ee biti ɔ mɔɔ Gyɔn nɩn, amaa ɔ kyɩna ɔ sɩlɛ asa mʋ, lɩɩ fɛɛ Gyiwu abi ba wu fɛɛ Gyɔn gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Amaa kakaakʋ Herodi maa kyɩna ee gyii mʋ kakɛ kʋʋgɛsa akɛ kinsigyi mʋ, Herodiya mu‐bii kyɩɩsa kyaa sa bamʋ, nɩɩ ɩ waa Herodi ɔkɔn naa kyʋn sʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nɩɩ ɔ da mʋ kɔkɔlɔ sʋ bɔ ntan tɔwɛ mʋ yɛ, kʋtɔ kʋmaa mʋ nɩɩ ɔ kan tɔwɛ yɛ ee biti mʋ, ee biti ɔ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nɩɩ mu‐nyi tɔwɛ waa mʋ yɛ ɔ naa tɔwɛ Herodi yɛ, “Sa mɛ Gyɔn Okyugyeepu kumu tangɩran tɔ nfɩɩ nbɩɩnbɩɩ nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Asɩn mʋ ɩ tɔɔrɔɔ Owura Herodi gaa, amaa lɩɩ mʋ ntan mʋ nɩɩ ɔ bɔ, yɛ mʋ kinsigyi tɔ afɔ mʋ sʋ mʋ, ɔ sa kɔnɔ yɛ ba waa kanɩn sa kebii kyɩɩsa‐bi mʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nɩɩ ɔ yɛgɛ ba naa tɩn Gyɔn kumu obu tiisa mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba bɩya Gyɔn kumu mʋ tangɩran tɔ ba sa kebii kyɩɩsa‐bi mʋ, nɩɩ ɔ taa kɩmʋ naa sa mu‐nyi. ");
INSERT INTO naw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nɩɩ mʋ abɩɩlapʋ ba ba taa mʋ kubuni naa pula. Nɩɩ ba naa tɔwɛ Yesu. ");
INSERT INTO naw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu maa nu kʋtɔ mʋ nɩɩ kɩ waa mʋ, nɩɩ ɔ taa ɔkʋlɩ lɩɩ tʋtɔ mʋ nkʋn kpee opula mʋ nɩɩ i du surum. Sakyɔ mʋ ba maa nu kanɩn mʋ ba taa ayaa tɔ lɩɩ ndɛ sʋ ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu maa kpɩlɩgɛ lɩɩ ɔkʋlɩ mʋ tɔ nɩɩ o wu asa damantɛ mʋ, bamʋ asɩn ɩ waa mʋ kʋwɛɛ nɩɩ ɔ kyɛ bamʋ nɩɩ bɛɛ lɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɩmʋ kalaatɩpwɛ asɛ mʋ, mʋ abɩɩlapʋ ba ba mʋ asɛ ba tɔwɛ mʋ yɛ, “Opula nɩmʋ bʋ kata yɛ kadɛ, nɩɩ kyɔwɛ mɔɔ tɛɛ lʋwɛ. Yɛgɛ sakyɔ mʋ ba kpee ndɛ‐bi‐ndɛ‐bi tɔ kɛ ba nyɛ naa sɔɔ agyitɔ gyii.” ");
INSERT INTO naw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu lɛɛ kɔnɔ yɛ, “Ɩ man dagaa fɛɛ ba kpee. Fanɛ nɩn fan sa bamʋ agyitɔ kɛ ba gyii.” ");
INSERT INTO naw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nɩɩ abɩɩlapʋ mʋ ba lɛɛ kɔnɔ yɛ, “Bodobodo anuu yɛ ɩkɩn ɩnyɔ nkʋn nɩɩ an sʋ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan taa ɩmʋ bɩya mɛ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ɔ tɔwɛ asa mʋ yɛ ba kyɩna afitiri sʋ. Ɔ taa bodobodo anuu mʋ yɛ ɩkɩn ɩnyɔ mʋ, kɩɩ sʋsʋ nɩɩ ɔ taa afwaala sa Ɩbwaarɛ. Nɩɩ ɔ kpɛɛ bodobodo mʋ tɔ taa sa mʋ abɩɩlapʋ mʋ, nɩɩ abɩɩlapʋ mʋ mɔɔ ba taa sa asa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bamʋ kpini ba gyii ŋmɛ, nɩɩ abɩɩlapʋ mʋ ba ba tasɛ awuribi mʋ nɩɩ ba gyii san mʋ bɔla alantan kudu anyɔ. ");
INSERT INTO naw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Asa mʋ nɩɩ ba gyii bodobodo mʋ kɔnɔ ɩ waa fɛɛ anyɩn ngbɩn nnuu, yɛgɛ ba man kalɛ akyɩɩ yɛ nbii gbaa tii su. ");
INSERT INTO naw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɩnɩmʋ kamaa mʋ opula tɔ nɩɩ Yesu yɛgɛ nɩɩ mʋ abɩɩlapʋ mʋ ba loo ɔkʋlɩ tɔ gyankpaa mʋ faa kpee benbe, nɩɩ ɔ sa sakyɔ mʋ ɔkpa yɛ ba natɛ. ");
INSERT INTO naw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Maa yɛgɛ nɩɩ ba kyʋn mʋ, o dii kpee kɩbɩɩ sʋ mʋ nkʋn ɔ naa kʋlɛ kabwaarɛ‐kʋlɛ. Kalaatɩpwɛ asɛ mʋ, mʋ nkʋn ɩ bʋ tʋtɔ, ");
INSERT INTO naw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","amaa saŋa maa tɔ mʋ ɔkʋlɩ mʋ tɛɛ wʋla fʋʋ nkyu nsana, nɩɩ afuu a maa waa mʋ, nɩɩ apaa a daa a kyenkpen ɔkʋlɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ɩ ba fʋʋ kɩbwayɩkɛ sʋ kerefi asa naa fʋʋ kerefi asiye nsana mʋ, Yesu natɛ nkyu sʋ ee kpee mʋ abɩɩlapʋ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba maa wu maa naa nkyu sʋ ɛɛ ba mʋ, bamʋ nkɔlɔ ɩ ŋmaa bamʋ. Nɩɩ ba tɔwɛ yɛ, “Obuni nɩn.” Nɩɩ ba kuusi lɩɩ fɛɛ kufuu kɩ kɩtaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Amaa Yesu tɔwɛ bamʋ opula tɔ yɛ, “Fan nyɛ nkɔlɔ, mɛ nɩn. Fan man sɩlɛ kufuu.” ");
INSERT INTO naw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nɩɩ Pita lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, nɩɩ ɩ kan ɩ gyɛ fʋ mʋ, yɛgɛ n natɛ nkyu mʋ sʋ ba fʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nɩɩ ɔ tɔwɛ mʋ yɛ, “Ba!” Nɩɩ Pita lɩɩ ɔkʋlɩ mʋ tɔ ɔ naa nkyu mʋ sʋ ee kpee Yesu asɛ. ");
INSERT INTO naw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amaa maa wu apaa mʋ, kufuu kɩ kɩtaa mʋ, nɩɩ o piili ee munla, nɩɩ o kuusi yɛ, “Ɔnyɩrɩpɛ, mɔlɩgɛ mɛ!” ");
INSERT INTO naw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Opula tɔ nɩɩ Yesu tɛɛŋɛ mʋ kɩbaa kɩtaa mʋ tɔ. Nɩɩ ɔ tɔwɛ mʋ yɛ, “Fu kɩkɔɔlɛ‐gyii man kyɔ. Mɩnɛ ɩ waa nɩɩ fʋ man kɔɔlɛ gyii?” ");
INSERT INTO naw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ba maa dii loo ɔkʋlɩ mʋ tɔ mʋ, nɩɩ afuu mʋ ɩ yɛgɛ. ");
INSERT INTO naw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nɩɩ bamʋ nɩɩ ba bʋ ɔkʋlɩ mʋ tɔ mʋ, ba muŋa sun mʋ nɩɩ ba tɔwɛ yɛ, “Kesintin, fʋ gyɛ Ɩbwaarɛ mu‐Bii nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ba maa faa ɔbʋn mʋ, nɩɩ ba naa dan Kanesareti ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nɩɩ asa mʋ nɩɩ ba bʋ tʋtɔ mʋ ba maa bɩɩ Yesu mʋ, ba sun tɔwɛ ndɛ mʋ nɩɩ ɩ kyaabɔɔ bamʋ mʋ kpini. Nɩɩ asa ba taa bamʋ alɔpʋ kpini ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nɩɩ ba kʋlɛ mʋ yɛ, ɔ dan yɛgɛ kɛ alɔpʋ mʋ ba dan taa bamʋ abaa mata mʋ kaalɛ kɔnɔ‐bi, nɩɩ bamʋ nɩɩ ba mata maŋa kpini ba nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tʋtɔ nɩɩ Farasii abi mʋ akʋ yɛ nbara akaapʋpʋ ba lɩɩ Gyerusalem ba Yesu asɛ ba taasɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mɩnɛ waa nɩɩ fʋ abɩɩlapʋ be mee buu anɛ anaana tɔ kɩkaapʋ mʋ? Lɩɩ fɛɛ ba mɛɛ fwɩɩ bamʋ abaa pɔyɩ nɩɩ bee gyii.” ");
INSERT INTO naw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu lɛɛ kɔnɔ yɛ, “Mɩnɛ ɩ waa nɩɩ lɩɩ fanɛ anaana tɔ kɩkaapʋ sʋ, fen mee buu Ɩbwaarɛ kɔnɔsa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Lɩɩ fɛɛ Ɩbwaarɛ tɔwɛ yɛ, ‘Bu fʋ‐sɛ yɛ fu‐nyi’ nɩɩ ɔ bɩla yɛ, ‘Ɔkʋmaa mʋ nɩɩ ɔ tɔwɛ mʋ‐sɛ abɛɛ mu‐nyi kɔnɔ mʋ, ba mɔɔ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amaa fɛn kaapʋ yɛ, nɩɩ ɔkʋ kan tɔwɛ mʋ‐sɛ abɛɛ mu‐nyi yɛ, ‘Kakɛɛ mʋ nɩɩ ɩ dagaa fɛɛ fʋ nyɛ lɩɩ mɛ asɛ mʋ, n taa waa saraga sa Ɩbwaarɛ mʋ,’ ");
INSERT INTO naw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ɩ man bɩla i tiri fɛɛ o buu mʋ‐sɛ yɛ mu‐nyi kɛ ɔ kɩɩ bamʋ sʋ. Ɩmʋ sʋ lɩɩ fanɛ anaana tɔ kɩkaapʋ sʋ mʋ, fen mee buu Ɩbwaarɛ asɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Fanɛ kebunbun ansi wuya ana! Fanɛ asɩn mʋ nɩɩ Ɩbwaarɛ bɔla mʋ ɔtɔwɛpʋ Isaya sʋ tɔwɛ mʋ gyɛ kesintin. Ɔ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Asa nɩmʋ ba sʋ bamʋ nnɔ nɩn bɛɛ bʋnyaa mɛ amaa bamʋ nkɔlɔ ɩ man bʋ mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bee sun mɛ kɩyan nɩn, lɩɩ fɛɛ nyɩmɩsa nbara nɩɩ bɛ sʋ bɛɛ kaapʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nɩɩ Yesu tɩɩ sakyɔ mʋ ba mʋ asɛ nɩɩ ɔ tɔwɛ yɛ, “Fan nu mɛ asɛ kɛ fan nu ɩmʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Man gyɛ kʋtɔ mʋ nɩɩ kii loo nyɩmɩsa kɔnɔ tɔ mʋ ɩɩ waa mʋ ineesi, amɔɔ kʋtɔ mʋ nɩɩ kɩɩ lɩɩ mʋ kɔnɔ tɔ mʋ ɩɩ waa mʋ ineesi.” ");
INSERT INTO naw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nɩɩ mʋ abɩɩlapʋ mʋ ba ba mʋ asɛ nɩɩ ba taasɛ mʋ yɛ, “Fu nyi yɛ Farasii abi mʋ ba maa nu falɛ asɩn mʋ ɩ tɔɔrɔɔ bamʋ?” ");
INSERT INTO naw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Oyu kʋmaa mʋ nɩɩ ɩ man gyɛ mɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ i du kɩmʋ mʋ, ee biti o kyiigi kɩmʋ tʋʋ. ");
INSERT INTO naw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Fan man tʋwɛ bamʋ, ba du nɩn fɛɛ agyaatanapʋ mʋ nɩɩ bɛɛ gyankpaa agyaatanapʋ nɩn. Nɩɩ gyaatanapʋ kan ɛɛ gyankpaa gyaatanapʋ mʋ, bamʋ kpini bee biti ba tɩyɛ ɔbɔ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nɩɩ Pita tɔwɛ yɛ, “Lɛɛ kɩŋasan maŋa kasɛ kaapʋ anɛ.” ");
INSERT INTO naw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu taasɛ bamʋ yɛ, “Ɩmʋ sʋ fanɛ nfɛɛrɛ ɩ man pɩɩta bugi? ");
INSERT INTO naw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Fan man nyi yɛ kʋtɔ kʋmaa mʋ nɩɩ kii loo nyɩmɩsa kɔnɔ tɔ mʋ, ii kpee mʋ ɔtɔ tɔ nɩn nɩɩ ɩɩ lɩɩ mʋ ɔpɩɩ tɔ? ");
INSERT INTO naw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amaa atɔ mʋ nɩɩ ɩɩ lɩɩ mʋ kɔnɔ tɔ mʋ lɩɩ mʋ kɔkɔlɔ tɔ nɩn, ɩnɩmʋ ɩɩ waa nyɩmɩsa ineesi. ");
INSERT INTO naw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Lɩɩ fɛɛ kɔkɔlɔ tɔ nɩɩ nfɛɛrɛ libi fɛɛ, nyɩmɩsa kɩmɔɔ, yɛ kɩlɩɩ okuli abɛɛ ɔkaa kamaa, yɛ kɩkyɩɩ yɛ kɩnyɩn biti kɩgyagaa, yɛ keyu, yɛ antɩŋɛsa kɩtɩn, yɛ kɩtɔwɛ asɩn libi gyaga asa sʋ. ");
INSERT INTO naw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɩnɩmʋ waa nyɩmɩsa ineesi, amaa nɩɩ nyɩmɩsa mɛɛ fwɩɩ mʋ abaa nɩɩ ee gyii mʋ mɛɛ waa mʋ ineesi.” ");
INSERT INTO naw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu lɩɩ tʋtɔ, nɩɩ o kpee Tayi maa Sidon ɔsʋwʋlɛ kɩbaafʋn. ");
INSERT INTO naw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nɩɩ Kakanaan‐kyɩɩ kʋ mʋ nɩɩ ɔ lɩɩ tʋtɔ ba mʋ asɛ ɛɛ saawʋ yɛ, “Ɔnyɩrɩpɛ, Dawidi kanaana‐bii, wu mɛ kʋwɛɛ! Nbwɩɩ libi ba tɛ mi kebii kyɩɩsa‐bi sʋ bɛɛ tɔɔrɔɔ mʋ gaa.” ");
INSERT INTO naw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu man bugi kɔnɔ tɔwɛ mʋ sɛhn. Nɩɩ mʋ abɩɩlapʋ mʋ ba ba mʋ asɛ ba kʋlɛ mʋ yɛ, “Tɔwɛ ɔkyɩɩ mʋ ɔ natɛ, lɩɩ fɛɛ ɛɛ saawʋ ee tii anɛ asʋ.” ");
INSERT INTO naw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɩsɩrayɩ abi mʋ nɩɩ ba du fɛɛ nbʋlʋpʋ fɔyɩsa mʋ, nkʋn asɛ nɩɩ Ɩbwaarɛ sun mɛ.” ");
INSERT INTO naw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nɩɩ ɔkyɩɩ mʋ ba muŋa mu ansi tɔ. Nɩɩ ɔ tɔwɛ yɛ, “Ɔnyɩrɩpɛ, kyɛ mɛ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ɩ man dagaa ba maa taa nbii agyitɔ tʋʋ sa igyoonɔ.” ");
INSERT INTO naw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nɩɩ ɔkyɩɩ mʋ yɛ, “Ɔnyɩrɩpɛ, ɩ bʋ tɔ kanɩn, amaa igyoonɔ mʋ gbaa bee gyii agyitɔ wuribi mʋ nɩɩ ɩɩ lɩɩ bamʋ‐nyɩrɩpɛ ana iteeburu sʋ ɩɩ tɩyɛ kasɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɔkyɩɩ, fʋ kɩkɔɔlɛ‐gyii kɩ kyɔ gaa! Kanan mʋ nɩɩ fii biti mʋ ɩ waa kanɩn sa fʋ.” Nɩɩ opula maa tɔ kebii kyɩɩsa‐bi mʋ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu lɩɩ tʋtɔ nɩɩ ɔ naa ɔ naa Galile ɔpʋ mʋ ɩkaa sʋ. Nɩɩ o dii kpee kɩbɩɩ sʋ naa kyɩna. ");
INSERT INTO naw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Asa damantɛ ba ba mʋ asɛ, nɩɩ ba bɩya alɔpʋ fɛɛ, ayaa yɛ abaa wusa wuya ana, yɛ agyaatanapʋ, yɛ aboobi, yɛ atikpiri, yɛ alɔpʋ gaalaagaa, nɩɩ ba taa bamʋ naa yɩla mu ansi tɔ, nɩɩ ɔ kyɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Asa damantɛ mʋ ba maa wu anaamuu ba maa tɔwɛ, yɛ boobi yɛ ayaa yɛ abaa wusa wuya ana ba maa natɛ, yɛ agyaatanapʋ ansi ɩ maa bugi mʋ, i kyinkyin bamʋ, nɩɩ ba yɩn Ɩsɩrayɩ abi Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu tɩɩ mʋ abɩɩlapʋ mʋ ba mʋ asɛ nɩɩ ɔ tɔwɛ bamʋ yɛ, “Asa nɩmʋ asɩn ɩ sʋ mɛ kʋwɛɛ, lɩɩ fɛɛ ba maa bʋ mɛ asɛ ndaga nkɛ nsa ndee ba man sʋ agyitɔ ba gyii. N mee biti fɛɛ ba taa akʋn kpewu, man gyɛ kanɩn bee biti ba lɩɩ tɩyɛ ɔkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mʋ abɩɩlapʋ mʋ ba lɛɛ kɔnɔ yɛ, “Fɩnɛ nɩɩ an biti a nyɛ agyitɔ kɩkyɔ afitiri nɩmʋ tɔ sa asa damantɛ banɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nɩɩ Yesu taasɛ bamʋ yɛ, “Bodobodo afɩnɛ nɩɩ fan sʋ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “An sʋ asunɔ yɛ ɩkɩn‐bi gbɛrɛɛ kʋ.” ");
INSERT INTO naw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nɩɩ ɔ tɔwɛ asa damantɛ mʋ yɛ ba kyɩna kasɛ. ");
INSERT INTO naw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nɩɩ ɔ taa bodobodo asunɔ mʋ yɛ ɩkɩn‐bi gbɛrɛɛ mʋ, nɩɩ ɔ taa afwaala sa Ɩbwaarɛ, nɩɩ ɔ gyayɩ‐gyayɩ ɩmʋ tɔ taa sa mʋ abɩɩlapʋ mʋ, nɩɩ ba mɔɔ bamʋ ba taa sa asa mʋ ");
INSERT INTO naw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bamʋ kpini ba gyii nɩɩ ba ŋmɛ. Nɩɩ mʋ abɩɩlapʋ mʋ ba taasɛ ɩmʋ agyisan wuribi mʋ bɔla alantan asunɔ. ");
INSERT INTO naw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Anyɩn mʋ nɩɩ ba gyii agyitɔ mʋ ba gyɛ ngbɩn nna, yɛgɛ ba man karagɛ akyɩɩ yɛ nbii tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu maa kala sakyɔ mʋ lʋwɛ mʋ, nɩɩ o loo ɔkʋlɩ tɔ, nɩɩ ɔ faa kpee Magadan kɩbaafʋn. ");
INSERT INTO naw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nɩɩ Farasii abi yɛ Sadusi abi ba ba Yesu asɛ ba ba tʋʋ mʋ tɔ kɩɩ, ɩmʋ sʋ ba tɔwɛ mʋ yɛ ɔ waa asɩn kyinkyinsa kʋ lɩɩ sʋsʋ kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Kyɔwɛ maa kpee ɔ naa tɩyɛ mʋ, fɛn taalɛ fɛn bɩɩ fɛn tɔwɛ yɛ, ‘Ɔkɛ kyɔwɛ ii biti ɔ da, lɩɩ fɛɛ abwaarɛ‐wʋlɛ ɩ payɩ kɔɔ’. ");
INSERT INTO naw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nɩɩ nyenyenfuu mɔɔ fɛn taalɛ fɛn tɔwɛ yɛ, ‘Ndaga bʋlayɩ ii biti ɔ da, lɩɩ fɛɛ abwaarɛ‐wʋlɛ ɩ payɩ nɩɩ i bii tɔ.’ Fɛn taalɛ fen wu abwaarɛ‐wʋlɛ mʋ kanan mʋ nɩɩ i du, nɩɩ fɛɛ lɛɛ ɩmʋ kasɛ, amaa fɛn mɛɛ taalɛ fɛn bɩɩ nkɛ nɩmʋ tɔ asɩn, kɛ fɛn lɛɛ ɩmʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Fanɛ ndaga kakyɩna nɩmʋ tɔ alibi awaapʋ mʋ nɩɩ fan kina Ɩbwaarɛ. Fɛn taasɛ fen biti asɩn kyinkyinsa lɩɩ mɛ asɛ, amaa fan man yɛ fan wu asɩn kyinkyinsa kʋ, amɔɔ ɩmʋ nɩɩ ɩ waa Ɩbwaarɛ ɔtɔwɛpʋ Gyona mʋ.” Yesu maa tɔwɛ kanɩn mʋ, nɩɩ ɔ yɛgɛ bamʋ nɩɩ ɔ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Abɩɩlapʋ mʋ ba maa faa kpee benbe mʋ, ba nyiŋi fɛɛ ba man taa bodobodo. ");
INSERT INTO naw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan kɩɩ danbɩrasa, kɛ fan baa fɛn da Farasii abi yɛ Sadusi abi kɩfɛ mʋ nɩɩ kii tin bodobodo mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tʋtɔ nɩɩ ba piili bɛɛ tɔwɛ abaa asɛ yɛ, “A maa man bɩya bodobodo mʋ sʋ nɩɩ ɛɛ tɔwɛ kanɩn mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu maa nyi kʋtɔ mʋ nɩɩ bɛɛ tɔwɛ sʋ mʋ ɔ taasɛ bamʋ yɛ, “Fanɛ mʋ nɩɩ fanɛ kɩkɔɔlɛ‐gyii kɩ man kyɔ! Mɩnɛ ɩ waa nɩɩ fɛn tɔwɛ, fanɛ kɩ man sʋ bodobodo asɩn? ");
INSERT INTO naw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Fan san fan man pɩɩta nu asɩn nɩmʋ kasɛ? Saŋa mʋ nɩɩ n daa gyayɩ bodobodo anuu tɔ sa anyɩn ngbɩn nnuu mʋ, fen mee nyiŋi? Agyisan alantan afɩnɛ nɩɩ fan daa tasɛ bɔla mʋ? ");
INSERT INTO naw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Abɛɛ n maa daa gyayɩ bodobodo asunɔ tɔ sa asa ngbɩn nna mʋ, agyisan alantan afɩnɛ nɩɩ fan daa taasɛ bɔla mʋ? ");
INSERT INTO naw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mɩnɛ ɩɩ waa sʋ nɩɩ fɛn mɛɛ taalɛ bɩɩ fɛɛ man gyɛ bodobodo asɩn nɩɩ n tɔwɛ? Amaa fan baa fan da fanɛ n‐yɩɩ sʋ lɩɩ Farasii yɛ Sadusi abi kɩfɛ tinsa mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tʋtɔ nɩɩ abɩɩlapʋ mʋ ba lan nu kasɛ fɛɛ man gyɛ kɩfɛ tin agyitɔ mʋ asɩn nɩɩ ɛɛ tɔwɛ bamʋ yɛ ba baa ba da sʋ, amaa Farasii yɛ Sadusi abi asɩn kaapʋsa nɩɩ ɔ dɩyɛ. ");
INSERT INTO naw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nɩɩ Yesu kpee kabaafʋn mʋ nɩɩ kɩ bʋ tiri Kasariya Filipi kadɛ tɔ mʋ. Maa bʋ tʋtɔ mʋ, nɩɩ ɔ taasɛ mʋ abɩɩlapʋ mʋ yɛ, “Anɩmʋ nɩɩ asa ba yɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n gyɛ?” ");
INSERT INTO naw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Akʋ ba yɛ fʋ ɩ gyɛ Gyɔn Okyugyeepu mʋ, nɩɩ akʋ ba yɛ fʋ ɩ gyɛ Eligya, nɩɩ akʋ mɔɔ ba yɛ fʋ ɩ gyɛ Gyeremiya abɛɛ Ɩbwaarɛ atɔwɛpʋ mʋ tɔ ɔkʋ.” ");
INSERT INTO naw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nɩɩ Yesu taasɛ bamʋ yɛ, “Nɩɩ fanɔɔ fan fa? Anɩmʋ nɩɩ fan yɛ n gyɛ?” ");
INSERT INTO naw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nɩɩ Simon Pita lɛɛ kɔnɔ yɛ, “Fʋ ɩ gyɛ Krisito, Ɩbwaarɛ mʋ nɩɩ ɔ tɛ kakpaa mʋ Mu‐Bii.” ");
INSERT INTO naw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Fʋ Simon, Gyona mu‐bii! Kusee ɩ gyɛ sa fʋ, lɩɩ fɛɛ man gyɛ nyɩmɩsa ɩ lɛɛ falɛ kesintin asɩn nɩmʋ kaapʋ fʋ, amaa mɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ ɩ lɛɛ falɛ asɩn mʋ kaapʋ fʋ. ");
INSERT INTO naw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ɩmʋ sʋ n tɔwɛ fʋ yɛ, fʋ gyɛ Pita, nɩɩ kanɩn kɩfʋlɛ maŋa sʋ nɩɩ n biti n pɔyɩ mɛ, Krisito kʋbʋ mʋ, nɩɩ lewu gbaa mɛɛ taalɛ gyii kɩmʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","N biti n taa sʋsʋ kuwura‐gyii ɩsafwɩɩ kpini sa fʋ. Kʋtɔ kʋmaa mʋ nɩɩ fu kyula kasɛ sʋ nfɩɩ mʋ, Ɩbwaarɛ gbaa kyula kɩmʋ sʋsʋ. Nɩɩ kʋtɔ kʋmaa mʋ nɩɩ fu kina kasɛ sʋ nfɩɩ mʋ, Ɩbwaarɛ gbaa kina kɩmʋ sʋsʋ.” ");
INSERT INTO naw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tʋtɔ nɩɩ Yesu da mʋ abɩɩlapʋ mʋ amu tɔ yɛ, ba man kan waa tɔwɛ ɔkʋ yɛ mʋ ɩ gyɛ Krisito. ");
INSERT INTO naw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lɩɩ kanɩn saŋa maŋa ɩɩ sʋ ii kpee mʋ, Yesu piili bugi tɔ ɛɛ tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “I tiri fɛɛ n maa kpee Gyerusalem naa gyii awʋrʋfɔ gaa lɩɩ abɩlɩsa, yɛ aseepu‐bɩlɩsa yɛ nbara akaapʋpʋ kpini abaa tɔ. Bee biti ba mɔɔ mɛ, kɛ kakɛ sasapʋ mʋ, n kyiŋi ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nɩɩ Pita taa Yesu kpee ɩkaa sʋ tɔwɛ yii mʋ yɛ, “Afuloo! Ɔnyɩrɩpɛ! Ɩbwaarɛ ɔ taa ɩmʋ kpee kata‐kata. Ɩnɩmʋ ɩ mɛɛ yɛ ɩ ba fʋ sʋ kakaakʋ.” ");
INSERT INTO naw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nɩɩ Yesu biliŋi tɔwɛ Pita yɛ, “Sɩtaanɛ, taa lɩɩ mɛ sʋ! Fii kun mɛ ɔkpa nɩn, lɩɩ fɛɛ fʋ nfɛɛrɛ ɩ man gyan Ɩbwaarɛ atɔ sʋ, amɔɔ ɩ gyan nyɩmɩsa lɛɛ sʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tʋtɔ nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Nɩɩ ɔkʋ kan ee biti o buu mɛ mʋ, ɩ dagaa maa kina mʋ n‐yɩɩ, kɛ ɔ sʋla mʋ gbaa‐gbaa mʋ oyu‐laasa kɛ o buu mɛ. ");
INSERT INTO naw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ee biti ɔ mɔlɩgɛ mʋ gbaa‐gbaa mʋ nkpa mʋ, ii biti ɔ pan ɩmʋ, amaa ɔkʋmaa mʋ nɩɩ ɔ pan mʋ nkpa lɩɩ mɛ sʋ mʋ, ii biti o bwii nyɛ mʋ nkpa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nɩɩ nyɩmɩsa kan nyɛ dulinyaa tɔ kʋtɔ kʋmaa, nɩɩ ɔ pan mʋ nkpa mʋ, mɩnɛ tɔnɔ nɩɩ ɔ nyɛ? Abɛɛ mɩnɛ nɩɩ nyɩmɩsa ɩ taalɛ taa kyɛrɛ mʋ nkpa? ");
INSERT INTO naw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Lɩɩ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n biti n baa yɛ Ɔsɛ mʋ bʋnyaa, yɛ mɛ nbɔɔ, kɛ n ba ka ɔkʋmaa nɩmʋ kʋkɔ lɩɩ mu kusun mʋ nɩɩ ɔ waa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","N tɔwɛ fanɛ kesintin nɩn fɛɛ asa kʋ ba yɩla nfɩɩ, nɩɩ ba mɛɛ yɛ ba wu, naa fʋʋ saŋa mʋ nɩɩ bee biti ba wu mɛ, Daadimaadi Obii‐nyɩnsa maa ba yɛ mu kuwura‐gyii mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nkɛ nsiye kamaa tɔ mʋ, Yesu taa Pita yɛ Gyemisi maa mu‐supu Gyɔn, nɩɩ ba dii kpee kɩbɩɩ lala kʋ sʋ bamʋ nkʋn. ");
INSERT INTO naw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tʋtɔ nɩɩ Yesu kyɛɛgɛ bamʋ ansi sʋ. Mu ansi sʋ ɩɩ ŋalɩgɛ fɛɛ kyɔwɛ, nɩɩ mʋ atɔ bunsa ɩ kyɛɛgɛ waa parɛparɛ ɩɩ ŋalɩgɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tʋtɔ nɩɩ ba wu Ɩbwaarɛ atɔwɛpʋ anyɔ, Mosesi maa Eligya ba lɩɩ opula tɔ bɛɛ tɔwɛ Yesu asɛ. ");
INSERT INTO naw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nɩɩ Pita tɔwɛ Yesu yɛ, “Ɔnyɩrɩpɛ, ɩ bʋrɔn fɛɛ a maa bʋ nfɩɩ. Nɩɩ fʋ kan fii biti mʋ, n biti n yii abu asa, fʋ lɛɛ kʋkʋ, Mosesi lɛɛ kʋkʋ nɩɩ Eligya lɛɛ kʋkʋ.” ");
INSERT INTO naw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita maa san ɔ maa sʋ ɛɛ tɔwɛ mʋ, nɩɩ kabwaarɛ‐wʋlɛ ŋalɩgɛsa ba bun bamʋ sʋ. Nɩɩ ɔbʋlɛ kʋ tɔwɛ kabwaarɛ‐wʋlɛ mʋ tɔ yɛ, “Ɔnɩmʋ ɩ gyɛ Mi‐Bii‐nyɩnsa mʋ nɩɩ n sʋ kebiti sa, nɩɩ mʋ ɩ bɔla mi ansi. Fan nu mʋ asɛ!” ");
INSERT INTO naw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Abɩɩlapʋ asa mʋ ba maa nu falɛ mʋ, kufuu kɩ kɩtaa bamʋ gaa, nɩɩ ba kyʋn bun kasɛ. ");
INSERT INTO naw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Amaa Yesu ba bamʋ asɛ taa mʋ kɩbaa mata bamʋ, tɔwɛ yɛ, “Fan kʋsʋ, fan man waa kufuu.” ");
INSERT INTO naw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba maa kʋsʋ kɩɩ mʋ, ba man wu ɔkʋ, amɔɔ Yesu nkʋn. ");
INSERT INTO naw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ba maa kpɩlɩgɛ kɩbɩɩ mʋ sʋ bɛɛ ba mʋ, Yesu da bamʋ amu tɔ yɛ, “Fan man tɔwɛ ɔkʋ kʋtɔ mʋ nɩɩ fan wu mʋ, naa fʋʋ saŋa mʋ nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n kyiŋi lɩɩ lewu tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nɩɩ abɩɩlapʋ mʋ ba taasɛ Yesu yɛ, “Mɩnɛ sʋ nɩɩ nbara akaapʋpʋ mʋ bɛɛ tɔwɛ yɛ ɩ dagaa Ɩbwaarɛ ɔtɔwɛpʋ Eligya maa gyankpaa ba pɔyɩ?” ");
INSERT INTO naw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Kesintin nɩn, ɩ dagaa Eligya maa gyankpaa ba, kɛ ɔ lɔŋɔ kʋtɔ kʋmaa yɩla o gyoo. ");
INSERT INTO naw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amaa n tɔwɛ fanɛ nɩmʋ, Eligya tɛɛ wʋla ba nɩɩ asa ba man bɩɩ mʋ, amaa ba waa mʋ kanan kʋmaa mʋ nɩɩ bee biti. Nɩɩ kanɩn maŋa nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ gbaa ii biti o gyii awʋrʋfɔ bamʋ abaa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nɩɩ Yesu abɩɩlapʋ mʋ ba nu kasɛ nɩn fɛɛ, Gyɔn okyugyeepu asɩn nɩɩ Yesu ɩɩ tɔwɛ ɛɛ sa bamʋ kanɩn. ");
INSERT INTO naw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ba maa bwii ba sakyɔ mʋ asɛ mʋ, ɔnyɩn kʋ ba Yesu asɛ ba muŋa mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Nɩɩ ɔ tɔwɛ yɛ, “Ɔnyɩrɩpɛ, wu mi‐bii‐nyɩnsa kʋwɛɛ. Lɩɩ fɛɛ ɔ gyɛ kigbingbin wuya nɩɩ ee gyii awʋrʋfɔ gaa. Ɛɛ taalɛ ɛɛ tɩyɛ fʋlɔn tɔ abɛɛ nkyu tɔ. ");
INSERT INTO naw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N taa mʋ ba fʋʋ abɩɩlapʋ mʋ asɛ, amaa ba man taalɛ kyɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “O, fanɛ ndaga kakyɩna nɩmʋ tɔ asa mʋ nɩɩ fan man sʋ kɩkɔɔlɛ‐gyii, nɩɩ fanɛ ɩkpa ɩ man kyiigi! Nkɛ nfɩnɛ nɩɩ n biti n gyii fanɛ asɛ? Nɛnɛ nɩɩ n biti n bɩla nyɛ kenyiita sa fanɛ? Fan taa kebii mʋ bɩya mɛ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nɩɩ Yesu pʋntɛ kabwɩɩ libi mʋ sʋ, nɩɩ kɩ kʋsʋ kebii‐nyɩnsa mʋ sʋ, nɩɩ opula maŋa tɔ ɔ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tʋtɔ nɩɩ abɩɩlapʋ mʋ ba ba Yesu asɛ bamʋ nkʋn ba taasɛ mʋ yɛ, “Mɩnɛ sʋ nɩɩ an man taalɛ gyan kabwɩɩ libi mʋ lɩɩ kebii‐nyɩnsa mʋ sʋ?” ");
INSERT INTO naw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu lɛɛ bamʋ kɔnɔ yɛ, “Lɩɩ fɛɛ fanɛ kɩkɔɔlɛ‐gyii kɩ maa man kyɔ mʋ sʋ. N tɔwɛ fanɛ kesintin tɔ fɛɛ, nɩɩ fan kan fan sʋ kɩkɔɔlɛ‐gyii pii fɛɛ masitadi oyu kibi gbaa mʋ, fɛn taalɛ tɔwɛ kɩbɩɩ nɩmʋ yɛ, ‘Kʋsʋ lɩɩ nfɩɩ kpee falɛ’ kɛ kɩ kʋsʋ. Sɛhn man bʋ tɔ nɩɩ fɛn mɛɛ taalɛ waa.” ");
INSERT INTO naw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Amaa amɔɔ kabwaarɛ‐kʋlɛ yɛ noŋmina ɩɩ taalɛ waa falɛ asɩn nɩmʋ kedubi.) ");
INSERT INTO naw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Saŋa mʋ nɩɩ abɩɩlapʋ mʋ kpini ba ba Galile ɔsʋwʋlɛ sʋ mʋ, Yesu tɔwɛ bamʋ yɛ, “Bee biti ba lɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ waa asa abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bee biti ba mɔɔ mɛ, kɛ kakɛ sasapʋ mʋ, n kyiŋi ba nkpa tɔ.” Abɩɩlapʋ mʋ ba maa nu kanɩn mʋ, bamʋ nkɔlɔ i nyita bamʋ gaa. ");
INSERT INTO naw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu maa mʋ abɩɩlapʋ ba maa ba Kapanum kadɛ tɔ mʋ, kabwaarɛ‐sunkpa ayɛ tʋʋtʋʋ akɔɔlɛpʋ mʋ ba ba Pita asɛ ba taasɛ mʋ yɛ, “Fanɛ ɔkaapʋpʋ ɩɩ ka kabwaarɛ‐sunkpa ayɛ tʋʋtʋʋ mʋ?” ");
INSERT INTO naw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nɩɩ Pita lɛɛ kɔnɔ yɛ, “Ɛɛhn, ɛɛ ka.” Pita maa ba kɩkpaara sʋ mʋ, nɩɩ Yesu daa kɩtaasɛ yɛ, “Simon fʋ nfɛɛrɛ ɩ gyɛ nɛnɛ? Bamɔɔ asɛ nɩɩ dulinyaa tɔ awura bɛɛ kɔɔlɛ bamʋ kagya kasɛ tʋʋtʋʋ? Bɛɛ kɔɔlɛ bɛɛ lɩɩ bamʋ gbaa‐gbaa bamʋ‐bii ana asɛ nɩn abɛɛ afɔ asɛ?” ");
INSERT INTO naw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita lɛɛ kɔnɔ yɛ, “Bɛɛ kɔɔlɛ bɛɛ lɩɩ afɔ asɛ nɩn.” Nɩɩ Yesu tɔwɛ Pita yɛ, “Kanɩn bɩrɛ ndɛ‐bii ba man tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amaa a maa mee biti a maa waa bamʋ agbʋ sʋ mʋ, kpee ɔpʋ tɔ naa tʋʋ fʋ darʋwa. Ɔkɩn mʋ nɩɩ fii biti fʋ daa kɩkɩta mʋ, bugi mʋ kɔnɔ, fii biti fu wu kederebi mʋ nɩɩ kii biti kɩ fʋʋ maa fʋ tʋʋtʋʋ. Kɛ fʋ taa naa ka bamʋ.” ");
INSERT INTO naw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kanɩn saŋa maŋa tɔ mʋ, abɩɩlapʋ mʋ ba ba Yesu asɛ ba taasɛ mʋ yɛ, “Anɛ tɔ mʋ, anɩmʋ ɩ gyɛ ɔkparɛ sʋsʋ kuwura‐gyii mʋ tɔ?” ");
INSERT INTO naw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nɩɩ Yesu tɩɩ kebii pii kʋ ba yɩlɛ bamʋ nsana‐nsana. ");
INSERT INTO naw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin nɩn fɛɛ, fan dan fan man kyɛɛgɛ kɛ fan waa fɛɛ nbii pii‐pii mʋ, fɛn mɛɛ yɛ fan loo sʋsʋ kuwura‐gyii mʋ tɔ kakaakʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ɩmʋ sʋ ɔkʋmaa mʋ nɩɩ ɔ bɩya mʋ n‐yɩɩ kasɛ fɛɛ kebii pii nɩmʋ mʋ, ɩ gyɛ ɔkparɛ sʋsʋ kuwura‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ kebii pii fɛɛ ɔnɩmʋ mɛ kɩtɩɩ tɔ mʋ, ɔ kɔɔlɛ mɛ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Amaa ɔkʋmaa mʋ nɩɩ ɩ kan bɔla mʋ sʋ, kɛ nbii mʋ nɩɩ ba kɔɔlɛ mɛ gyii falɛ tɔ ɔkʋ waa alibi mʋ, ɩ bɔ sa mʋ fɛɛ ba taa kubuu lala ŋmina mʋ ɔbʋlɛ tɔ naa tʋʋ ɔpʋ bunkyinsa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Dulinya nɩmʋ tɔ asa, bamʋ laakʋ! Lɩɩ fɛɛ atɔ mʋ nɩɩ ɩ yɛgɛ nɩɩ bɛɛ tɩyɛ bamʋ kɩkɔɔlɛ gyii tɔ mʋ, ɩ nyɛ akyɔ. Falɛ atɔ ii biti ɩ ba, amaa ɔkʋmaa mʋ nɩɩ ɩɩ bɔla mʋ sʋ ba mʋ, mʋ laakʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nɩɩ fʋ kɩbaa abɛɛ fʋ kɩyaa ɩɩ yɛgɛ nɩɩ fɩɩ waa alibi mʋ, tɩn kɩmʋ tʋʋ. Ɩ bʋrɔn sa fʋ fɛɛ fʋ maa taa kɩbaa abɛɛ kɩyaa dɩyɛ loo nkpa kakpaa tɔ, ɩ kyɔ fʋ maa sʋ abaa anyɔ yɛ ayaa anyɔ kɛ ba taa fʋ tʋʋ fʋlɔn mʋ nɩɩ ki mee dun kakaakʋ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nɩɩ fu kinsi ɩɩ yɛgɛ nɩɩ fʋ waa alibi mʋ, kyɔlɛ kɩmʋ tʋʋ. Ɩ bʋrɔn sa fʋ fɛɛ fʋ maa taa kinsi kʋlʋn loo nkpa kakpaa tɔ, ɩ kyɔ fʋ maa sʋ ansi anyɔ kɛ ba taa fʋ tʋʋ awʋrʋfɔ fʋlɔn yen‐yen tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan baa fan da sʋ kɛ fan man kɩɩ apii‐pii mʋ tɔ ɔkʋ fɛɛ ɔ man gyɛ sɛhn. N tɔwɛ fanɛ fɛɛ bamʋ nbɔɔ mʋ nɩɩ ba bʋ sʋsʋ mʋ, ii wu mɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mu ansi tɔ saŋa kʋmaa. ");
INSERT INTO naw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Lɩɩ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ ba nɩn kɛ n ba mɔlɩgɛ asa mʋ nɩɩ ba fɔyɩ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Nɩɩ ɔnyɩn kʋ kan ɔ sʋ nbʋlʋpʋ kɩlɩfa, nɩɩ bamʋ tɔ ɔkʋlʋn fɔyɩ mʋ, mɩnɛ nɩɩ fii nyi maa biti ɔ waa? Ɔ mɛɛ yɛ ɔ yɛgɛ adɩkpanɔ yɛ akpanɔ mʋ kɩbɩɩ ɔbʋlɛ tɔ, kɛ ɔ naa biti ɔkʋlʋn mʋ nɩɩ ɔ fɔyɩ mʋ abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","N tɔwɛ fanɛ kesintin tɔ nɩɩ fɛɛ, nɩɩ ɔ kan wu mʋ mʋ, mu ansi ii biti i gyii mʋ sʋ, ɩ kyɔ adɩkpanɔ yɛ akpanɔ mʋ nɩɩ ba man fɔyɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kanɩn ɔkpa maŋa sʋ nɩɩ fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ gbaa mee biti fɛɛ apii‐pii nɩmʋ tɔ ɔkʋlʋn maa fɔyɩ. ");
INSERT INTO naw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nɩɩ fu‐supu abɛɛ fʋ‐daa kan waa fʋ alibi mʋ, kpee mʋ asɛ naa lɛɛ mu alibi mʋ kaapʋ mʋ fanɛ asa nyɔ. Nɩɩ ɔ kan nu kasɛ sa fʋ mʋ, fʋ bɩla bɩya mʋ ba ɔkpa danbɩrasa mʋ sʋ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amaa nɩɩ ɔ man kan nu sa mʋ, biti nyɩmɩsa kʋlʋn abɛɛ asa anyɔ tii fʋ n‐yɩɩ sʋ kɛ fen kpee mʋ asɛ. Saamʋ, asɩn mʋ ɩ nyɛ yɩlɛ fɛɛ kanan mʋ nɩɩ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ, ‘Ɩ dagaa asɩn kʋmaa ɩ nyɛ asa anyɔ abɛɛ asa asá be gyii ɩmʋ adansɛ.’ ");
INSERT INTO naw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nɩɩ ɔ man kan bɩla nu sa bamʋ mʋ, taa asɩn mʋ naa tʋʋ Krisito kʋbʋ mu ansi tɔ. Nɩɩ ɔ bɩla kina kunu sa bamʋ bɩrɛ, taa mʋ fɛɛ ɔdakpa osunpu abɛɛ apoo lenpoo ɔkɔɔlɛpʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“N tɔwɛ fanɛ kesintin fɛɛ, kʋtɔ kʋmaa mʋ nɩɩ fan ŋmina kasɛ sʋ nfɩɩ mʋ, Ɩbwaarɛ ii biti o ŋmina kɩmʋ sʋsʋ, nɩɩ kʋtɔ kʋmaa mʋ nɩɩ fan kina kasɛ sʋ nfɩɩ mʋ, Ɩbwaarɛ ii biti o kina kɩmʋ sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“N bɩla n tɔwɛ fanɛ yɛ, nɩɩ fanɛ tɔ anyɔ ba kan waa kɔnɔ kʋlʋn kʋlɛ Ɩbwaarɛ yɛ bee biti kʋtɔ kʋ mʋ, Mɛ‐Sɛ Ɩbwaarɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ ii biti ɔ waa sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Lɩɩ fɛɛ katɩn kʋmaa mʋ nɩɩ asa anyɔ abɛɛ asa asá ba gyaŋɛ mɛ kɩtɩɩ tɔ mʋ, n bʋ bamʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nɩɩ Pita ba Yesu asɛ ba taasɛ mʋ yɛ, “Ɔnyɩrɩpɛ, ɩlɩɩ ɩfɩnɛ nɩɩ mɛ‐bɩrɩsa waa mɛ alibi nɩɩ ɩ dagaa fɛɛ n taa kɛɛ mʋ? Ilii isunɔ abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ayee, man gyɛ ɩlɩɩ isunɔ, amaa adusunɔ kanɩn ɩlɩɩ isunɔ. ");
INSERT INTO naw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Lɩɩ fɛɛ sʋsʋ kuwura‐gyii mʋ du nɩn fɛɛ owura kʋ maa biti mʋ ayaafɔlɛ ba ba kaapʋ mʋ akɔ mʋ nɩɩ ba sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Maa piili ɛɛ taasɛ mʋ akɔ mʋ, nɩɩ ba taa ɔnyɩn kʋ bɩya mʋ. Ɔnyɩn mʋ sʋ owura mʋ kʋkɔ afulee nderebi ngbɩn‐ngbɩn. ");
INSERT INTO naw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Maa man taalɛ ka mʋ, nɩɩ mʋ owura mʋ yɛ, ba taa maa mʋ‐ka yɛ mu‐bii ana yɛ kʋtɔ kʋmaa mʋ nɩɩ ɔ sʋ mʋ naa fɛ kɛ ba ba ka kʋkɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Nɩɩ kɩyaafɔlɛ mʋ kyʋn muŋa mu amulii sʋ kʋlɛ mʋ yɛ, ‘Ɔbɩlɩsa, nyɛ kenyiita sa mɛ, n biti n ka fʋ kʋkɔ maŋa kpini.’ ");
INSERT INTO naw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nɩɩ kɩyaafɔlɛ mʋ asɩn ɩ waa mʋ owura mʋ kʋwɛɛ, nɩɩ ɔ taa kʋkɔ mʋ kpini kɛɛ mʋ, nɩɩ ɔ yɛgɛ nɩɩ ɔ natɛ. ");
INSERT INTO naw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Amaa kɩyaafɔlɛ mʋ maa lɩɩ mʋ, ɔ naa wu mʋ bɩrɩsa kɩyaafɔlɛ mʋ nɩɩ mɔɔ mʋ ɔ sʋ mu afulee nderebi kɩlɩfa. Nɩɩ ɔ naa kɩtaa mʋ ɔbʋlɛ tɔ tɔwɛ mʋ yɛ, ‘Ka mɛ kʋkɔ mʋ nɩɩ fʋ sʋ mɛ.’ ");
INSERT INTO naw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Nɩɩ mʋ bɩrɩsa kɩyaafɔlɛ mʋ muŋa mu amulii sʋ kʋlɛ mʋ yɛ, ‘Nyɛ kenyiita sa mɛ, n biti n ka kʋkɔ mʋ kpini.’ ");
INSERT INTO naw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Amaa o kina mʋ bɩrɩsa maŋa kɩkʋlɛ mʋ, nɩɩ ɔ taa mʋ naa tii obu naa fʋʋ saŋa mʋ nɩɩ ee biti ɔ nyɛ afulee ba ka mʋ kʋkɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mʋ bɩrɩsa ayaafɔlɛ mʋ nɩɩ ba san mʋ ba maa wu kanan mʋ nɩɩ ɔ waa mʋ bɩrɩsa mʋ, ɩ tɔɔrɔɔ bamʋ gaa nɩɩ ba naa tɔwɛ asɩn mʋ kpini sa bamʋ owura mʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Tʋtɔ nɩɩ owura mʋ tɩɩ mʋ kɩyaafɔlɛ maŋa ba nɩɩ ɔ tɔwɛ mʋ yɛ, ‘Fʋ gyɛ kɩyaafɔlɛ kumu tɔ ɔlʋn wuya. N taa fʋ kʋkɔ kpini nɩmʋ kɛɛ fʋ, kpalɩ fɛɛ fʋ maa kʋlɛ mɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ɩ man dagaa fʋ gbaa fʋ maa wu fʋ bɩrɩsa mʋ kʋwɛɛ fɛɛ kanan mʋ nɩɩ ngbaa mɛ n wu fʋ kʋwɛɛ mʋ?’ ");
INSERT INTO naw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tʋtɔ mʋ ɔnyɩrɩpɛ mʋ nyɛ agbʋ gaa, nɩɩ ɔ taa mʋ naa tii obu yɛ ba nyanla mʋ naa fʋʋ saŋa mʋ nɩɩ ee biti ɔ ka kʋkɔ mʋ kpini.” ");
INSERT INTO naw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Falɛ nɩɩ Mɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ ii biti ɔ waa fanɛ ɔkʋmaa nɩmʋ, amɔɔ fʋ kan taa fʋ bɩrɩsa alibi kɛɛ mʋ lɩɩ fʋ kɔkɔlɔ tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ ɔ lɩɩ Galile kpee Gyudeya kɩbaafʋn, Gyɔdan ɔpʋ mʋ benbe. ");
INSERT INTO naw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Asa damantɛ ba buu mʋ nɩɩ ɔ kyɛ bamʋ alɔ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nɩɩ Farasii abi akʋ ba ba mʋ asɛ ba ba tʋʋ mʋ tɔ kɩɩ. Ba taasɛ mʋ yɛ, “Ɩ dɛ ɔkpa sa ɔnyɩn fɛɛ ɔ yɩlɛ asɩn kʋmaa nɩmʋ sʋ kina mʋ‐ka?” ");
INSERT INTO naw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu lɛɛ kɔnɔ yɛ, “Fan man karagɛ Asɩnkyan yɩlasa mʋ tɔ wu fɛɛ, ‘Lɩɩ npiili asɛ mʋ, Ɩbwaarɛ waa bamʋ ɔnyɩn yɛ ɔkyɩɩ’ nɩn abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nɩɩ Ɩbwaarɛ tɔwɛ yɛ, ‘Lɩɩ falɛ sʋ, ɔnyɩn ii biti ɔ yɛgɛ mu‐nyi yɛ mʋ‐sɛ, kɛ maa mʋ‐ka ba bʋga kɛ bamʋ anyɔ ba waa kayɩɩ‐wʋlɛ kʋlʋn?’ ");
INSERT INTO naw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ɩmʋ sʋ ba man bɩla ba gyɛ anyɔ, amaa ba gyɛ nyɩmɩsa kʋlʋn. Kanɩn sʋ kʋtɔ mʋ nɩɩ Ɩbwaarɛ taa bʋga waa kʋkʋlʋn mʋ, ɔkʋ ɔ man barɩgɛ ɩmʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nɩɩ ba taasɛ mʋ yɛ, “Mɩnɛ sʋ nɩɩ Mosesi sa kɔnɔ yɛ ɔnyɩn ɩ taalɛ sa mʋ‐ka kekili kikina ɔwʋlɛ kɛ o kina mʋ?” ");
INSERT INTO naw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu lɛɛ kɔnɔ yɛ, “Mosesi sa fanɛ ɔkpa yɛ fan kina fanɛ‐ka ana, lɩɩ fɛɛ fanɛ nkɔlɔ ɩ bʋlʋn nɩn. Amaa man gyɛ falɛ nɩɩ ɩ kyɩna i du lɩɩ npiili asɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","N tɔwɛ fanɛ kesintin yɛ, nɩɩ ɩ man gyɛ yɛ ɔkyɩɩ lɩɩ mu‐kuli kamaa, nɩɩ ɔnyɩn mʋ kina mʋ naa kili ɔkyɩɩ pʋpwɛ mʋ, ɔnyɩn mʋ nyita kekili.” ");
INSERT INTO naw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mʋ abɩɩlapʋ mʋ ba tɔwɛ mʋ yɛ, “Nɩɩ ɩ kan ɩ gyɛ kanɩn nɩɩ i du okuli maa ɔkaa nsana mʋ bɩrɛ, nɩɩ nyɩmɩsa man kili gbaa ɩ bɔ.” ");
INSERT INTO naw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Man gyɛ ɔkʋmaa nɩmʋ ɩ taalɛ kɔɔlɛ falɛ asɩn kyula, amɔɔ bamʋ nɩɩ ba taa asɩn mʋ sa bamʋ nkʋn. ");
INSERT INTO naw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Anyɩn akʋ ba bʋ tɔ nɩɩ be mee taalɛ kili, lɩɩ fɛɛ kanɩn nɩɩ ba kʋʋgɛ bamʋ, nɩɩ akʋ mɔɔ asa ɩ waa bamʋ kanɩn, nɩɩ akʋ mɔɔ ba kina kekili lɩɩ sʋsʋ kuwura‐gyii mʋ kusun sʋ. Ɔmʋ nɩɩ ɛɛ taalɛ kɔɔlɛ kɩkaapʋ nɩmʋ kyula mʋ, ɔ kɔɔlɛ.” ");
INSERT INTO naw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tʋtɔ nɩɩ asa kʋ ba taa nbii wuribi ba Yesu asɛ yɛ ɔ taa mʋ abaa gyaga bamʋ sʋ, kʋlɛ kabwaarɛ‐kʋlɛ sa bamʋ. Amaa mʋ abɩɩlapʋ mʋ ba gya asa mʋ nɩɩ bɛɛ bɩya bamʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu tɔwɛ yɛ, “Fan yɛgɛ nbii wuribi mʋ ba ba mɛ asɛ, fan man tii bamʋ ɔkpa, lɩɩ fɛɛ sʋsʋ kuwura‐gyii mʋ kɩ gyɛ sa asa mʋ nɩɩ be du fɛɛ nbii‐wuribi mʋ lɛɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Maa taa mʋ abaa gyaga bamʋ sʋ lʋwɛ mʋ, nɩɩ ɔ lɩɩ tʋtɔ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nɩɩ ɔnyɩn kʋ ba Yesu asɛ ba taasɛ mʋ yɛ, “Ɔkaapʋpʋ, mɩnɛ kʋtɔ danbɩrasa nɩɩ ɩ dagaa n maa waa kɛ n nyɛ nkpa kakpaa?” ");
INSERT INTO naw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu lɛɛ kɔnɔ yɛ, “Mɩnɛ sʋ nɩɩ fɩɩ taasɛ mɛ kʋtɔ mʋ nɩɩ kɩ bʋrɔn sʋ? Ɔkʋ man gyɛ ɔdanbɩrasa, amɔɔ Ɩbwaarɛ nkʋn. Nɩɩ fii biti fʋ nyɛ nkpa kakpaa mʋ, buu Mosesi nbara mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nɩɩ ɔnyɩn mʋ taasɛ yɛ, “Ɩmɔɔ?” Yesu lɛɛ kɔnɔ yɛ, “ ‘Man mɔɔ, man lɩɩ fʋ‐ka abɛɛ fu‐kuli kamaa, man yuuri, man yɩlɛ antɩŋɛsa kamaa, ");
INSERT INTO naw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","buu fʋ‐sɛ yɛ fu‐nyi,’ kɛ ‘fu biti fʋ bɩrɩsa fɛɛ fʋ n‐yɩɩ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nɩɩ kɩyaafɔlɛ mʋ tɔwɛ yɛ, “N buu ɩnɩmʋ kpini. Mɩnɛ kʋtɔ ɩ san mɛ?” ");
INSERT INTO naw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu lɛɛ kɔnɔ yɛ, “Nɩɩ fʋ kan fii biti yɛ fʋ baa fu du kyɛɛkyɛɛ bɩrɛ, kpee naa fɛ fʋ atɔ kpini kɛ fʋ taa afulee mʋ sa atiripu, fii biti fʋ nyɛ kapatɩyɛ sʋsʋ, kɛ fʋ lan ba buu mɛ.” ");
INSERT INTO naw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɔnyɩn mʋ maa nu falɛ mʋ ɩ tɔɔrɔɔ mʋ gaa, nɩɩ ɔ lɩɩ tʋtɔ kyʋn lɩɩ fɛɛ ɔ sʋ atɔ gaa. ");
INSERT INTO naw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “N tɔwɛ fanɛ kesintin yɛ, ɩ bʋlʋn sa atɔ wuya fɛɛ o loo sʋsʋ kuwura‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","N bɩla n tɔwɛ fanɛ yɛ, ɩ bʋpɔɔ sa nyɔɔma fɛɛ o loo baasa ɔbɔ tɔ ɩ kyɔ atɔ wuya o loo Ɩbwaarɛ kuwura‐gyii mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Abɩɩlapʋ mʋ ba maa nu kanɩn mʋ, i kyinkyin bamʋ gaa nɩɩ ba taasɛ abaa yɛ, “Kanɩn bɩrɛ anɩmʋ nɩɩ Ɩbwaarɛ ii biti ɔ mɔlɩgɛ nɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu kɩɩ bamʋ nɩɩ ɔ tɔwɛ yɛ, “Nyɩmɩsa asɛ bɩrɛ ɩnɩmʋ ɩ mɛɛ taalɛ waa, amaa Ɩbwaarɛ asɛ bɩrɛ kʋtɔ kʋmaa nɩmʋ ɩ taalɛ waa.” ");
INSERT INTO naw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita lɛɛ mʋ kɔnɔ yɛ, “Kɩɩ! A maa yɛgɛ kʋtɔ kʋmaa nɩmʋ an buu fʋ falɛ, mɩnɛ nɩɩ an biti a nyɛ?” ");
INSERT INTO naw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin yɛ, nɩɩ Ɩbwaarɛ kan bun dulinyaa pʋpwɛ, nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa kyɩna mɛ bʋnyaa kuwura‐gya mʋ sʋ, fanɛ mʋ nɩɩ fan buu mɛ mʋ gbaa, fen biti fan kyɩna nwuragya kudu anyɔ sʋ, kɛ fan gyii Ɩsɩrayɩ nbunɔ kudu anyɔ mʋ sʋ kuwura. ");
INSERT INTO naw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ yɛgɛ akpaara, abɛɛ pɩɩkyɩɩ, abɛɛ mʋ‐sɛ, abɛɛ mu‐nyi, abɛɛ mu‐bii ana, abɛɛ adɔɔ lɩɩ mɛ sʋ mʋ, ee biti ɔ nyɛ ɩmʋ ɩlɩɩ kɩlɩfa, kɛ ɔ bɩla nyɛ nkpa kakpaa. ");
INSERT INTO naw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amaa asa gaalaagaa mʋ nɩɩ ba gyankpaa mʋ, bee biti be sii kamaa, nɩɩ asa gaalaagaa mʋ nɩɩ ba bʋ kamaa mʋ, bee biti ba ba gyankpaa.” ");
INSERT INTO naw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nɩɩ Yesu bɩla tɔwɛ bamʋ yɛ, “Sʋsʋ kuwura‐gyii mʋ ki du nɩn fɛɛ ɔnyɩn kʋ maa kʋsʋ kakaakʋ nyenyenfuu, ɔ naa biti asa kɛ ba sun kusun mʋ ndɔɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Maa naa nyɛ bamʋ mʋ, nɩɩ maa bamʋ ba tɔwɛ kyula abaa yɛ ee biti ɔ ka bamʋ kederebi kʋlʋn kakɛ kʋlʋn ibiri mʋ, nɩɩ ɔ taa bamʋ kpee mʋ ndɔɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Kyɔwɛ maa waa fɛɛ kerefi akpanɔ mʋ, ɔ bɩla kpee kadɛ mʋ kɩgya asɛ naa wu akʋ ba maa yɩlɛ ba mɛɛ waa sɛhn. ");
INSERT INTO naw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nɩɩ ɔ tɔwɛ bamʋ yɛ, ‘Fanɛ gbaa fanɛ fan kpee naa waa kusun mɛ ndɔɔ tɔ, kɛ n ka fanɛ kʋtɔ mʋ nɩɩ kɩ dagaa.’ ");
INSERT INTO naw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nɩɩ ba kpee. “Kyɔwɛ amu nsana yɛ kerefi asa tɔ mʋ, nɩɩ ɔ bɩla taa akʋ kpee kanɩn. ");
INSERT INTO naw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kalaatɩpwɛ sʋ kyɔwɛ maa tɩyɛ ɛɛ mata afatɛɛ tɔ mʋ, nɩɩ ɔ bɩla kpee naa wu akʋ ba maa yɩlɛ ba mɛɛ waa sɛhn. Nɩɩ ɔ taasɛ bamʋ yɛ, ‘Mɩnɛ ɩ waa sʋ nɩɩ fan yɩlɛ nfɩɩ kakɛ ibiri nɩɩ fan man sʋ kusun.’ ");
INSERT INTO naw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Nɩɩ ba lɛɛ mʋ kɔnɔ yɛ, ‘Ɔkʋ man taa anɛ yɛ a naa sun sa mʋ.’ “Nɩɩ ɔ tɔwɛ bamʋ yɛ, ‘Kanɩn bɩrɛ fanɛ gbaa fanɛ fan ba kyʋn kpee naa waa kusun mɛ ndɔɔ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kalaatɩpwɛ maa fʋʋ mʋ, nɩɩ ndɔɔ wuya mʋ tɔwɛ asunpu mʋ ɔkɩɩsʋpʋ yɛ, ‘Tɩɩ asunpu mʋ, kɛ fʋ ka bamʋ kʋkɔ. Piili lɩɩ bamʋ nɩɩ ba sii kamaa ba mʋ sʋ naa fʋʋ bamʋ nɩɩ ba gyankpaa ba mʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Tʋtɔ nɩɩ ɔ yɛgɛ nɩɩ asunpu mʋ nɩɩ ba kpee ndɔɔ mʋ tɔ saŋa mʋ nɩɩ kyɔwɛ mata afatɛɛ tɔ mʋ, ba ba kɔɔlɛ kederebi kʋlʋn‐kʋlʋn mʋ nɩɩ ɩ gyɛ kakɛ ibiri kʋkɔka. ");
INSERT INTO naw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ɩ maa fʋʋ agyankpaapʋ mʋ sʋ mʋ, be nyi fɛɛ bee biti ba nyɛ ba kyɔ kamaa tɔ wuya ana mʋ, amaa ngbaa bamʋ kederebi kʋlʋn‐kʋlʋn maŋa nɩɩ ba nyɛ. ");
INSERT INTO naw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba maa kɔɔlɛ kederebi kʋlʋn‐kʋlʋn mʋ, nɩɩ be piili bɛɛ kɔlɩtɛ bɛɛ sa ndɔɔ wuya mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Bamʋ nɩɩ ba sii kamaa ba falɛ bɩrɛ, saŋa gbɛrɛɛ nɩɩ ba sun kusun, yɛgɛ anɛɛnɛ bɩrɛ an yɩlɛ kyɔwɛ kenken nɩmʋ sʋ waa kusun ibiri. Amaa ana bamʋ kpini nɩɩ fʋ ka kyɛɛkyɛɛ?’ ");
INSERT INTO naw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Nɩɩ kadɔɔ wuya mʋ lɛɛ bamʋ ɔkʋ kɔnɔ yɛ, ‘Kyɛmɩnɛ, n man sisii fʋ. Man gyɛ kederebi kʋlʋn kʋkɔka nɩɩ maa fʋ an tɔwɛ kyula kakɛ ibiri kusun? ");
INSERT INTO naw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ɩmʋ sʋ taa fu kederebi natɛ. Kanan mʋ nɩɩ ɩ pɩrɛ mɛ yɛ n ka asii‐amaapʋ mʋ, kanɩn nɩɩ maŋa nɩɩ n biti n ka fʋ gbaa. ");
INSERT INTO naw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","N man sʋ ɔkpa fɛɛ n waa mɛ kɔkɔlɔ biti lɩɩ mɛ afulee sʋ abɛɛ? Abɛɛ fʋ sʋ kayɩɩ basa lɩɩ mɛ kɩdanbɩrasa kɩwaa sʋ nɩn?’ ” ");
INSERT INTO naw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Asii‐amaapʋ bee biti ba biliŋi agyankpaapʋ kɛ agyankpaapʋ ba biliŋi asii‐amaapʋ.” ");
INSERT INTO naw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu maa kpee Gyerusalem mʋ, nɩɩ ɔ taa mʋ abɩɩlapʋ kudu anyɔ mʋ lɩɩ ɩkaa sʋ, nɩɩ ɔ tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Fan nu! An kpee Gyerusalem nɩmʋ, tʋtɔ nɩɩ bee biti ba naa lɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ sa aseepu bɩlɩsa yɛ nbara akaapʋpʋ. Kɛ ba bun mɛ lewu kʋpwɛ, ");
INSERT INTO naw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kɛ ba taa mɛ waa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ abaa tɔ, kɛ ba waa mɛ ɩbasasɩn kɛ ba tɩŋɛ mɛ, kɛ ba da mɛ mata oyu laasa sʋ. Amaa nkɛ nsa akɛ mʋ, n biti n kyiŋi lɩɩ lewu tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nɩɩ Sebedi mʋ‐ka maa mu‐bii ana anyɩnsa anyɔ mʋ ba ba Yesu asɛ, nɩɩ bamʋ‐nyi ba muŋa Yesu ayaa tɔ kʋlɛ mʋ kʋtɔ kʋ. ");
INSERT INTO naw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nɩɩ Yesu taasɛ mʋ yɛ, “Mɩnɛ nɩɩ fii biti?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Kyula sa mɛ fɛɛ, mi nbii nnyɔ nɩmʋ, ɔkʋ ɔ kyɩna fu‐gyisa sʋ kɛ ɔkʋ mɔɔ ɔ kyɩna fʋ‐bɩna sʋ fu kuwura‐gyii mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan man nyi kʋtɔ mʋ nɩɩ fɛn kʋlɛ falɛ. Fɛn taalɛ gyii awʋrʋfɔ mʋ nɩɩ n biti n gyii mʋ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Ɛɛhn, an taalɛ.” ");
INSERT INTO naw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tʋtɔ nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fɛn taalɛ gyii awʋrʋfɔ mʋ nɩɩ n biti n gyii mʋ, amaa n man sʋ ɔkpa fɛɛ n lɛɛ ɔmʋ nɩɩ ee biti ɔ kyɩna mi‐gyisa sʋ abɛɛ mɛ‐bɩna sʋ. Ɩkyɩnakpa ɩnɩmʋ ɩ gyɛ sa bamʋ nɩɩ mɛ‐Sɛ wʋla lɔŋɔ yɩla sa bamʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Abɩɩlapʋ kudu mʋ nɩɩ ba san mʋ, ba maa nu ɩnɩmʋ mʋ, ba nyɛ agbʋ waa Gyemisi maa mu‐supu Gyɔn. ");
INSERT INTO naw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nɩɩ Yesu tɩɩ bamʋ ba bʋga nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fen nyi fɛɛ dulinyaa nɩmʋ tɔ agyankpaapʋ mʋ bɛɛ kaapʋ bamʋ ɔlʋn asa sʋ, nɩɩ alʋlʋnpʋ gbaa bɛɛ kaapʋ bamʋ ɔlʋn asa sʋ. ");
INSERT INTO naw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amaa fanɛɛ fanɛ tɔ bɩrɛ, ɩ man dagaa ɩ maa waa kanɩn. Nɩɩ fanɛ tɔ ɔkʋ kan ii biti kɩbɩlɩsa mʋ, ɩ dagaa maa waa fanɛ kɩyaafɔlɛ, ");
INSERT INTO naw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","nɩɩ fanɛ ɔkʋmaa mʋ nɩɩ ee biti fɛɛ ɔ waa ɔgyankpaapʋ mʋ, ɩ dagaa maa waa fanɛ kɩnyɛ, ");
INSERT INTO naw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","fɛɛ kanan mʋ nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa gbaa n man ba nɩn kɛ ba sun mɛ, amaa n ba nɩn kɛ n ba sun, kɛ n taa mɛ nkpa kɛɛ, kɛ ɩ ka asa gaalaagaa alibi kʋkɔ.” ");
INSERT INTO naw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu maa mʋ abɩɩlapʋ ba maa lɩɩ Gyeriko kadɛ tɔ mʋ, asa gaalaagaa ba buu bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tʋtɔ mʋ, agyaatanapʋ anyɔ kʋ ba tɛ ɔkpakaa, nɩɩ ba nu fɛɛ Yesu ɩɩ kyʋn mʋ, ba kuusi tɩɩ mʋ yɛ, “Ɔnyɩrɩpɛ, Dawidi kanaana‐bii, wu anɛ kʋwɛɛ?” ");
INSERT INTO naw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nɩɩ asa mʋ ba pʋntɛ bamʋ sʋ yɛ ba bun bamʋ nnɔ sʋ, amaa ba kuusi kenken yɛ, “Ɔnyɩrɩpɛ, Dawidi kanaana‐bii, wu anɛ kʋwɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nɩɩ Yesu yɩlɛ nɩɩ ɔ tɩɩ bamʋ, nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ nɩɩ fen biti fɛɛ n waa sa fanɛ?” ");
INSERT INTO naw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, an biti fɛɛ anɛ ansi i bugi nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nɩɩ Yesu wu bamʋ kʋwɛɛ nɩɩ ɔ mata bamʋ ansi. Opula maŋa tɔ nɩɩ bamʋ ansi i bugi nɩɩ ba buu Yesu. ");
INSERT INTO naw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu maa mʋ abɩɩlapʋ ba maa tiri Gyerusalem tɔ, nɩɩ ba fʋʋ Betifage kadɛ tɔ mʋ nɩɩ kɩ bʋ Olifu kɩbɩɩ‐bi mʋ asɛ mʋ, Yesu sun mʋ abɩɩlapʋ anyɔ, ");
INSERT INTO naw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fen kpee kadɛ‐bi mʋ nɩɩ kɩ bʋ fanɛ ansi tɔ mʋ, fen biti fen wu kuruma kʋ maa kyaa tʋtɔ maa mu‐bii. Fan saŋɛ bamʋ bɩya mɛ. ");
INSERT INTO naw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nɩɩ ɔkʋ kan taasɛ fanɛ kʋtɔ kʋ mʋ, fan tɔwɛ mʋ yɛ, ‘Ɔnyɩrɩpɛ Yesu ii biti bamʋ.’ Nɩɩ ee biti ɔ yɛgɛ fan taa bamʋ bɩya mɛ.” ");
INSERT INTO naw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɩnɩmʋ ɩ waa kanɩn nɩn kɛ asɩn mʋ nɩɩ Ɩbwaarɛ bɔla mʋ ɔtɔwɛpʋ sʋ tɔwɛ yɩla mʋ ɩ ba tɔ. Asɩn mʋ ɩ gyɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tɔwɛ Siyon abii mʋ yɛ, ‘Fan kɩɩ, fanɛ owura ɩɩ ba fanɛ asɛ, O du bɔhn nɩɩ ɔ tɛ kuruma sʋ, kesintin tɔ ɔ tɛ kuruma kadanba sʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mʋ abɩɩlapʋ mʋ ba naa waa fɛɛ kanan mʋ nɩɩ Yesu sa bamʋ kɔnɔ yɛ ba waa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba taa kuruma yɛ mu‐bii mʋ ba, nɩɩ ba taa bamʋ atɔ bunsa gyaga bamʋ sʋ, nɩɩ Yesu dii kyɩna kadanba mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Asa damantɛ ba taa bamʋ atɔ bunsa tʋʋ kigbenbi sʋ, nɩɩ akʋ mɔɔ ba kyatɛ iyu n‐yaabi wʋrɩgɛ kigbenbi mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Asa damantɛ mʋ nɩɩ ba bʋ mu ansi tɔ mʋ, yɛ bamʋ nɩɩ ba buu mʋ mʋ bee kuusi bɛɛ tɔwɛ yɛ, “Hosana ɩ gyɛ sa Owura Dawidi kanaana‐bii mʋ.” “Kusee ɩ gyɛ sa ɔmʋnɩ ɛɛ ba Ɔnyɩrɩpɛ kɩtɩɩ mʋ sʋ!” “Hosana ɩ gyɛ sa Ɩbwaarɛ mʋ nɩɩ ɔ bʋ sʋsʋ.” ");
INSERT INTO naw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu maa loo Gyerusalem kadɛ mʋ tɔ mʋ, kadɛ mʋ kpini kɔɔlɛ ɔlanba, nɩɩ asa bɛɛ taasɛ yɛ, “Anɩmʋ nɩn?” ");
INSERT INTO naw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nɩɩ sakyɔ mʋ ba lɛɛ kɔnɔ yɛ, “Ɔnɩmʋ ɩ gyɛ Yesu, Ɩbwaarɛ ɔtɔwɛpʋ mʋ nɩɩ ɔ lɩɩ Nasareti kadɛ tɔ nɩɩ kɩ bʋ Galile kɩbaafʋn mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu loo kabwaarɛ‐sunkpa ayɛ mʋ opula, nɩɩ ɔ gya asa mʋ nɩɩ bɛɛ fɛ, yɛ bamʋ nɩɩ bɛɛ sɔɔ mʋ kpini lɩɩ tʋtɔ. Ɔ bala afulee akyɛrɛpʋ mʋ iteeburu yɛ alɔpɔ afɛpʋ mʋ ibenkyii bun. ");
INSERT INTO naw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ yɛ Ɩbwaarɛ yɛ, ‘Bee biti ba tɩɩ mɛ kɩkpaara yɛ kabwaarɛ kʋlɛkpa’, amaa fan taa tʋtɔ biliŋi bamʋ nɩɩ bee yuuri ɔlʋn sʋ ɔbaalakpa.” ");
INSERT INTO naw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Agyaatanapʋ yɛ ayaa yɛ abaa wusa wuya ana ba ba mʋ asɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, nɩɩ ɔ kyɛ bamʋ alɔ. ");
INSERT INTO naw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amaa Ɩbwaarɛ aseepu abɩlɩsa yɛ nbara akaapʋpʋ ba maa wu atɔ kyinkyinsa mʋ nɩɩ ɔ waa, yɛ nbii mʋ kikuusi kabwaarɛ‐sunkpa ayɛ bɛɛ tɔwɛ yɛ, “Hosana ɩ gyɛ sa Dawidi mʋ kanaana‐bii mʋ”, nɩɩ ba nyɛ agbʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nɩɩ ba taasɛ mʋ yɛ, “Fu nu asɩn mʋ nɩɩ nbii mʋ bɛɛ tɔwɛ mʋ?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ “Ɛɛhn, fan man pɩɩta kalɛ lɩɩ Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘Fʋ kaapʋ nbii yɛ nbii wuribi yɛ ba yɩn fʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nɩɩ ɔ lɩɩ tʋtɔ kpee Betani kadɛ tɔ nɩɩ ɔ dɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lɩɩ kaakɛ nyenyenfuu Yesu maa bwii ee kpee Gyerusalem mʋ, akʋn ɩɩ mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Maa wu figi oyu maa yɩlɛ ɔkpa kaa mʋ o kpee kɩmʋ asɛ, amaa ɔ man wu sɛhn kɩmʋ sʋ amɔɔ afatɛɛ nkʋn. Nɩɩ ɔ tɔwɛ kɩmʋ yɛ, “Fʋ man bɩla yɛ fʋ sɔyɩ abi kpini‐kpini!” Opula tɔ nɩɩ oyu mʋ wʋlɛ. ");
INSERT INTO naw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Abɩɩlapʋ mʋ ba maa wu kanɩn mʋ, i kyinkyin bamʋ. Nɩɩ ba taasɛ yɛ, “Nɛnɛ sʋ nɩɩ figi oyu mʋ wʋlɛ bilen kanɩn?” ");
INSERT INTO naw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu lɛɛ kɔnɔ yɛ, “N tɔwɛ fanɛ kesintin yɛ, nɩɩ fan kan kɔɔlɛ mɛ gyii, nɩɩ fan man gyii ɩmɔɔrɛ mʋ, man gyɛ yɛ fen biti fan taalɛ waa kʋtɔ mʋ nɩɩ kɩ waa figi oyu nɩmʋ nkʋn. Amaa fɛn taalɛ tɔwɛ kɩbɩɩ nɩmʋ yɛ, ‘Kʋsʋ lɩɩ nfɩɩ naa tɩyɛ ɔpʋ tɔ,’ kɛ ɩ waa kanɩn. ");
INSERT INTO naw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nɩɩ fan kan kɔɔlɛ mɛ gyii mʋ, fen biti fan nyɛ kʋtɔ kʋmaa mʋ nɩɩ fan kʋlɛ kabwaarɛ‐kʋlɛ tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu loo kabwaarɛ‐sunkpa ayɛ mʋ. Maa bʋ tʋtɔ ɛɛ kaapʋ mʋ, Ɩbwaarɛ aseepu abɩlɩsa yɛ kadɛ mʋ abɩlɩsa ba ba mʋ asɛ, nɩɩ ba taasɛ mʋ yɛ, “Mɩnɛ ɔlʋn nɩɩ fʋ sʋ fɩɩ waa atɔ nɩmʋ? Nɩɩ anɩmʋ ɩ sa fʋ falɛ ɔlʋn.” ");
INSERT INTO naw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu lɛɛ kɔnɔ yɛ, “Ngbaa mɛ n biti n taasɛ fanɛ asɩn kʋ, nɩɩ fan kan lɛɛ mɛ kɔnɔ mʋ, n biti n tɔwɛ fanɛ ɔlʋn mʋ nɩɩ n sʋ n waa ɩnɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Gyɔn kekyugyee mʋ, fɩnɛ nɩɩ kɩ lɩɩ? Ɩ kyɩna lɩɩ sʋsʋ nɩn abɛɛ ɩ lɩɩ asa asɛ nɩn?” Ba tɔwɛ bamʋ wʋlɛ‐wʋlɛ tɔ yɛ, “Nɩɩ an kan tɔwɛ yɛ, ‘Kɩ lɩɩ sʋsʋ nɩn’, ee biti ɔ taasɛ anɛ yɛ, ‘Nɩɩ mɩnɛ ɩ waa nɩɩ fan man kɔɔlɛ mʋ gyii?’ ");
INSERT INTO naw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amaa an kan tɔwɛ yɛ, ‘Kɩ lɩɩ asa asɛ mʋ’, an sɩlɛ asa mʋ kufuu, lɩɩ fɛɛ bamʋ kpini ba kɔɔlɛ gyii fɛɛ Gyɔn kyɩna ɔ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɩmʋ sʋ ba lɛɛ Yesu kɔnɔ yɛ, “A man nyi.” Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Kanɩn bɩrɛ ngbaa mɛ, n mɛɛ yɛ n tɔwɛ fanɛ ɔlʋn mʋ nɩɩ n sʋ n waa ɩnɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nɩɩ Yesu taasɛ bamʋ yɛ, “Ɩmʋ nɩɩ n biti n tɔwɛ falɛ, nɛnɛ ɩ gyɛ fanɛ nfɛɛrɛ? Ɔnyɩn kʋ ɩ kyɩna ɔ bʋ tɔ nɩɩ ɔ sʋ nbii‐nyɩnsa anyɔ. O kpee ɔgyankpaapʋ mʋ asɛ naa tɔwɛ mʋ yɛ, ‘Mi‐bii, ndaga kpee mɛ kadɔɔ mʋ tɔ naa sun kusun.’ ");
INSERT INTO naw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Nɩɩ ɔ lɛɛ kɔnɔ yɛ, ‘N mɛɛ yɛ n kpee.’ Amaa kamaa tɔ mʋ ɔ kyɛɛgɛ mʋ nfɛɛrɛ nɩɩ o kpee. ");
INSERT INTO naw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Nɩɩ ɔsɛ mʋ kpee mu‐bii banban mʋ asɛ naa tɔwɛ mʋ kanɩn asɩn kʋlʋn maŋa. Nɩɩ ɔ lɛɛ kɔnɔ yɛ, ‘Nsɛ, n biti n kpee.’ Amaa ɔ man kpee. ");
INSERT INTO naw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Bamʋ anyɔ maŋa, anɩmʋ ɩ waa kʋtɔ mʋ nɩɩ mʋ‐sɛ ii biti?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Ɔgyankpaapʋ mʋ.” Nɩɩ Yesu lɛɛ tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin yɛ, apoo lenpoo akɔɔlɛpʋ yɛ agyamilo‐kyɩɩ bɛɛ gyankpaa fanɛ bee loo Ɩbwaarɛ kuwura‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Lɩɩ fɛɛ Gyɔn ba fanɛ asɛ nɩn yɛ ɔ ba kaapʋ fanɛ ɩkpa kyiigisa ɔkpa, nɩɩ fan man kɔɔlɛ mʋ gyii, amaa lenpoo akɔɔlɛpʋ yɛ agyamilo‐kyɩɩ ba kɔɔlɛ mʋ gyii. Nɩɩ halɩɩ fan maa wu ɩnɩmʋ kamaa tɔ mʋ, fan man yɛgɛ alibi kɩwaa kɛ fan kɔɔlɛ mʋ gyii.” ");
INSERT INTO naw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan bɩla nu kɩŋasan kʋ. Ɔnyɩn kʋ kyɩna dɔɔ oyu sɔyɩ abisa. Nɩɩ o ŋmina iyu kyaabɔɔ kɩmʋ, nɩɩ o kuu wayɩn ɔnyɩyɛkpa ɔbɔ kʋdɔɔ mʋ tɔ, nɩɩ ɔ pɔyɩ opula mʋ nɩɩ akɩɩsʋpʋ bee dii bɛɛ kɩɩ kʋdɔɔ mʋ sʋ. Nɩɩ ɔ taa kʋdɔɔ mʋ waa paa agyipu kʋ abaa tɔ, nɩɩ o kpee ɔsʋwʋlɛ kʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kɩtɩŋɛ saŋa maa fʋʋ mʋ, nɩɩ o sun mʋ ayaafɔlɛ yɛ ba kpee paa agyipu mʋ asɛ naa kɔɔlɛ mu ogyikpa mʋ nɩɩ ee biti ɔ nyɛ mʋ bɩya mʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Nɩɩ paa agyipu mʋ ba kɩtaa mʋ ayaafɔlɛ mʋ, nɩɩ ba dayɩ ɔkʋ, nɩɩ ba mɔɔ ɔkʋ, nɩɩ ba twɩɩ ɔsasapʋ mʋ abuu. ");
INSERT INTO naw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nɩɩ o bwii sun mʋ ayaafɔlɛ akʋ nɩɩ ba kyɔ bamʋ nɩɩ ɔ gyankpaa sun mʋ, nɩɩ paa agyipu mʋ ba waa bamʋ fɛɛ kanan mʋ nɩɩ ba waa abanban mʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Laalaalʋwɛ mʋ, o sun mu‐bii‐nyɩnsa bamʋ asɛ tɔwɛ yɛ ‘Bee biti ba taa bɛɛrɛɛ sa mi‐bii.’ ");
INSERT INTO naw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Amaa paa agyipu mʋ ba maa wu mu‐bii maa ba mʋ, ba tɔwɛ abaa yɛ, ‘Ɔnɩmʋ ɩ gyɛ kapatɩyɛ ogyipu mʋ’. Fan ba kɛ a mɔɔ mʋ kɛ a taa mʋ kapatɩyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ɩmʋ sʋ ba kɩtaa kebii mʋ, bɩɩtɛ mʋ lɩɩ kadɔɔ mʋ tɔ, nɩɩ ba mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ɩmʋ sʋ, nɩɩ kadɔɔ wuya mʋ kan ba mʋ, mɩnɛ nɩɩ ee biti ɔ waa paa agyipu mʋ?” ");
INSERT INTO naw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Ɩ waa kanan kʋmaa ee biti ɔ mɔɔ kanɩn asa libi maŋa, kɛ ɔ taa kadɔɔ mʋ sa paa agyipu pʋpwɛ kʋ, mʋ nɩɩ bee biti ba baa bɛɛ sa mʋ mʋ ogyikpa lɩɩ adɔɔ‐gyitɔ mʋ tɔ kɩtɩŋɛ saŋa.” ");
INSERT INTO naw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nɩɩ Yesu taasɛ bamʋ yɛ, “Fan man pɩɩta kalɛ Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘Kubuu mʋ nɩɩ apɔyɩpʋ ba kina mʋ, kɩmʋ ɩ ba biliŋi kɩbɔntɔnbʋlɔntɔ kubuu kparɛ mʋ nɩɩ kɩ sʋ obu mʋ tɔ. Ɔnyɩrɩpɛ mʋ ɩ waa ɩnɩmʋ, nɩɩ i kyinkyin anɛ.’ ");
INSERT INTO naw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ɩmʋ sʋ n tɔwɛ fanɛ yɛ, Ɩbwaarɛ ii biti ɔ taa mu kuwura‐gyii mʋ lɩɩ fanɛ asɛ, kɛ ɔ taa sa asa mʋ nɩɩ bee biti ba waa mu kebiti mʋ. ");
INSERT INTO naw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ɔkʋmaa mʋ nɩɩ ɔ tɩyɛ kubuu nɩmʋ sʋ mʋ, ii biti o boyi tɔ buriburi, amaa ɔmʋ nɩɩ kɩ lɩɩ tɩyɛ mʋ sʋ mʋ, ii biti ɔ patɩyɛ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ɩbwaarɛ aseepu abɩlɩsa yɛ Farasii abi ba maa nu Yesu aŋasan mʋ, ba bɩɩ fɛɛ bamʋ asɩn nɩɩ ɛɛ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ba biti ɔkpa mʋ nɩɩ ba taa kɩtaa mʋ, amaa ba sɩlɛ sakyɔ mʋ, lɩɩ fɛɛ asa mʋ be nyi maa gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nɩɩ Yesu bɩla taa aŋasan tɔ tɔwɛ sa asa mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sʋsʋ kuwura‐gyii mʋ du nɩn fɛɛ, owura kʋ maa waa kɩkyɩɩfɔ kensi‐gyii lala sa mu‐bii‐nyɩnsa. ");
INSERT INTO naw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nɩɩ o sun mʋ ayaafɔlɛ yɛ ba kpee naa tɩɩ bamʋ nɩɩ ɔ da kɩbaa tɩɩ bamʋ yɛ ba be kensi‐gyii mʋ tɔ, amaa ba kina kɩ ba. ");
INSERT INTO naw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Tʋtɔ nɩɩ ɔ bɩla sun ayaafɔlɛ akʋ tɔwɛ bamʋ yɛ, ‘Fan naa tɔwɛ bamʋ nɩɩ n da kɩbaa tɩɩ mʋ fɛɛ n kʋʋla lʋwɛ. N mɔɔ ɩnaatɛ gbelu yɛ akpensen‐kpesen mʋ nɩɩ ba sʋ nfɔ, nɩɩ n kʋʋla kʋtɔ kʋmaa lʋwɛ. Fan ba kɩkyɩɩfɔ kensi‐gyii mʋ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Amaa asa mʋ nɩɩ ɔ da kɩbaa tɩɩ mʋ, ba man tʋwɛ mʋ. Akʋ ba kyʋn bamʋ ndɔɔ ana tɔ, nɩɩ akʋ mɔɔ ba kyʋn asun tɔ. ");
INSERT INTO naw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nɩɩ bamʋ nɩɩ ba san mʋ mɔɔ ba kɩtaa owura mʋ ayaafɔlɛ mʋ dayɩ nɩɩ ba mɔɔ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Owura mʋ nyɛ agbʋ gaa. Nɩɩ o sun mʋ anaakɔpʋ, nɩɩ ba naa mɔɔ kanɩn amɔɔpʋ maŋa nɩɩ ba tuwa bamʋ kadɛ. ");
INSERT INTO naw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Tʋtɔ nɩɩ ɔ tɔwɛ mʋ ayaafɔlɛ yɛ, ‘N lʋwɛ kɩkyɩɩfɔ kensi‐gyii agyitɔ mʋ, amaa bamʋ nɩɩ n da kɩbaa tɩɩ mʋ, ba man tʋwɛ, ɩmʋ sʋ ba man dagaa agyitɔ mʋ kigyii. ");
INSERT INTO naw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kanɩn sʋ fan loo kadɛ tɔ kpee agbenbi sʋ, naa tɩɩ ɔkʋmaa mʋ nɩɩ fen wu mʋ ba kɩkyɩɩfɔ kensi‐gyii mʋ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɩmʋ sʋ ayaafɔlɛ mʋ ba lɩɩ kpee agbenbi sʋ yɛ katɩn kʋmaa natɛ tɩɩ ɔsa kʋmaa mʋ nɩɩ ba wu, asa adanbɩrasa yɛ alibi kpini bʋga tɔ, nɩɩ asa ba ba bɔla kɩkyɩɩfɔ lenbu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Amaa saŋa mʋ nɩɩ owura mʋ ba kɩɩ lenbu mʋ tɔ mʋ, o wu ɔnyɩn kʋ maa man bun kɩkyɩɩfɔ tɔ atɔ bunsa. ");
INSERT INTO naw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nɩɩ owura mʋ taasɛ ɔnyɩn mʋ yɛ, ‘Kyɛmɩnɛ, nɛnɛ nɩɩ fʋ waa fʋʋ nfɩɩ yɛgɛ fʋ man bun kɩkyɩɩfɔ atɔ bunsa?’ Amaa ɔnyɩn mʋ man taalɛ bugi kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ɩmʋ sʋ owura mʋ tɔwɛ mʋ ayaafɔlɛ yɛ, ‘Fan ŋmina mʋ abaa yɛ ayaa, kɛ fan lɛɛ mʋ tʋʋ nbwama kitentenbiri mʋ tɔ, tʋtɔ nɩɩ kusu yɛ anobi kiduŋi bʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nɩɩ Yesu lʋwɛ yɛ, “Ba tɩɩ asa gaalaagaa, amaa gbɛrɛɛ falɛ nɩɩ ba lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɩnɩmʋ kamaa mʋ, Farasii abi ba naa gyaŋɛ ŋmina kanan mʋ nɩɩ ba sʋʋ mʋ ɔdʋʋ lɩɩ mʋ asɩn tɔwɛsa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tʋtɔ nɩɩ ba sun bamʋ abɩɩlapʋ yɛ owura Herodi kamaa tɔ abi kpee Yesu asɛ. Ba tɔwɛ mʋ yɛ, “Ɔkaapʋpʋ an nyi fʋ maa gyɛ kesintin gyipu, nɩɩ fɩɩ kaapʋ asa Ɩbwaarɛ asɩn bɔla kesintin ɔkpa sʋ, yɛgɛ fʋ mɛɛ tʋwɛ lɩɩ nfɛɛrɛ mʋ nɩɩ asa bɛɛ fɛ, nɩɩ fʋ mɛɛ kɩɩ nyɩmɩsa kɩkparɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ɩmʋ sʋ an biti a nu lɩɩ fʋ asɛ yɛ, ɩ dɛ ɔkpa fɛɛ a ka lenpoo sa Roma abi Owura Kasaro, abɛɛ a man ka?” ");
INSERT INTO naw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amaa Yesu maa wʋla o nyi bamʋ nfɛɛrɛ libi sʋ mʋ, ɔ tɔwɛ bamʋ yɛ, “Fanɛ kebunbun ansi wuya ana! Mɩnɛ waa sʋ nɩɩ fɛn sʋʋ mɛ ɔdʋʋ? ");
INSERT INTO naw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Fan taa kederebi mʋ nɩɩ fɛn sʋ fɛn ka lenpoo mʋ kaapʋ mɛ.” Nɩɩ ba taa kederebi mʋ ba sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nɩɩ ɔ taasɛ bamʋ yɛ, “Anɩmʋ foto yɛ kɩtɩɩ ɩ gyan kɩmʋ sʋ falɛ?” ");
INSERT INTO naw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ba lɛɛ kɔnɔ yɛ, “Owura lala Kasaro.” Ɩmʋ sʋ, Yesu tɔwɛ bamʋ yɛ, “Kʋtɔ mʋ nɩɩ kɩ gyɛ Kasaro lɛɛ mʋ, fan ka sa Kasaro, nɩɩ kʋtɔ mʋ nɩɩ kɩ gyɛ Ɩbwaarɛ lɛɛ mʋ, fan taa sa Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ba maa nu falɛ sʋ mʋ, ɩ waa bamʋ kɩyan, nɩɩ ba yɛgɛ mʋ, nɩɩ ba natɛ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kanɩn kakɛ kʋlʋn maŋa mʋ Sadusi abi akʋ ba ba Yesu asɛ. Sadusi abi ba gyɛ Gyiwu abi mʋ nɩɩ bɛɛ kaapʋ yɛ kikyiŋi ba nkpa tɔ kʋ man bʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ba ba taasɛ mʋ yɛ, “Ɔkaapʋpʋ, anɛ naana Mosesi kɩkaapʋ mʋ tɔ mʋ, ɔ tɔwɛ yɛ, nɩɩ ɔnyɩn kan kili nɩɩ ɔ man kʋʋgɛ nɩɩ o wu mʋ, ɩ dagaa mu‐supu maa bwii kili okulapu‐kyɩɩ mʋ, kɛ ba kʋʋgɛ nbii sa olewupu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To! Ɔnyɩn kʋ maa mu‐supu ana asunɔ ba kyɩna ba bʋ anɛ asɛ nfɩɩ. Ɔbɩlɩsa asɛ mʋ kili nɩɩ o wu, yɛgɛ ba man kʋʋgɛ nbii, nɩɩ mu‐supu mʋ taa okulapu‐kyɩɩ mʋ kili. ");
INSERT INTO naw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kanɩn maŋa nɩɩ ɔnyɔsapʋ mʋ yɛ ɔsasapʋ gbaa ba kili mʋ, halɩɩ naa fʋʋ osunɔsapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Laalaalʋwɛ mʋ, ɔkyɩɩ mʋ gbaa ba wu. ");
INSERT INTO naw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Saamʋ, kakɛ lala mʋ nɩɩ asa bee biti ba kyiŋi lɩɩ lewu tɔ ba nkpa tɔ mʋ, anyɩn asunɔ banɩmʋ tɔ mʋ, anɩmʋ mʋ‐ka ɩ gyɛ ɔkyɩɩ mʋ? Lɩɩ fɛɛ bamʋ kpini ba kili mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu lɛɛ bamʋ kɔnɔ yɛ, “Fan fɔyɩ ɔkpa! Lɩɩ fɛɛ fan maa man nu Asɩnkyan yɩlasa mʋ kasɛ, nɩɩ fan man nyi Ɩbwaarɛ ɔlʋn mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kpalɩ fɛɛ saŋa mʋ nɩɩ alewupu bee biti ba kyiŋi ba nkpa tɔ mʋ, asa ba mɛɛ yɛ ba kili, amaa bee biti ba baa ba du nɩn fɛɛ Ɩbwaarɛ nbɔɔ mʋ nɩɩ ba bʋ sʋsʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Amaa lɩɩ alewupu kikyiŋi ba nkpa tɔ asɩn mʋ, fan man kalɛ wu asɩn mʋ nɩɩ Ɩbwaarɛ tɔwɛ sa fanɛ mʋ nɩn? ");
INSERT INTO naw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ɔ tɔwɛ yɛ, ‘Mɛ ɩ gyɛ Abraham Ɩbwaarɛ yɛ Isaki Ɩbwaarɛ yɛ Gyekobu Ɩbwaarɛ.’ Ɩnɩmʋ ɩ kaapʋ nɩn fɛɛ, asa banɩmʋ ba maa wu gbaa mʋ ba san ba gyɛ asa kɩɩsa Ɩbwaarɛ asɛ, nɩɩ ɔ gyɛ bamʋ Ɩbwaarɛ, man gyɛ alewupu lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sakyɔ mʋ maa nu falɛ mʋ, mʋ kɩkaapʋ mʋ ɩ waa bamʋ kɩyan. ");
INSERT INTO naw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Amaa Farasii abi mʋ ba maa nu fɛɛ, Yesu man yɛgɛ nɩɩ Sadusi abi mʋ ba nyɛ bugi kɔnɔ mʋ, ba tɩɩ abaa gyaŋɛ. ");
INSERT INTO naw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nɩɩ bamʋ tɔ ɔkʋ mʋ nɩɩ ɔ gyɛ nbara onyipu mʋ taa asɩn taasɛsa sʋʋ Yesu ɔdʋʋ. ");
INSERT INTO naw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ɔ taasɛ mʋ yɛ, “Ɔkaapʋpʋ, Ɩbwaarɛ nbara mʋ tɔ mʋ, kɩmɔmɔ ɩ gyɛ kɩkparɛ?” ");
INSERT INTO naw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu lɛɛ mʋ kɔnɔ yɛ, “ ‘Taa fʋ kɔkɔlɔ yɛ fʋ kala yɛ fʋ nfɛɛrɛ kpini nyɛ kebiti sa fʋ‐Nyɩrɩpɛ Ɩbwaarɛ.’ ");
INSERT INTO naw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kɩnɩmʋ ɩ gyɛ nbara mʋ tɔ kɩgyankpaasa yɛ kɩkparɛ. ");
INSERT INTO naw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nɩɩ kɩnyɔsapʋ mʋ du nɩn fɛɛ kɩmʋ. Ɩmʋ ɩ gyɛ yɛ, ‘Nyɛ kebiti sa fʋ tɔmaa fɛɛ fʋ n‐yɩɩ.’ ");
INSERT INTO naw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosesi nbara mʋ kpini yɛ Ɩbwaarɛ atɔwɛpʋ asɩn kaapʋsa mʋ ɩ yɩlɛ nbara nnyɔ nɩmʋ sʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farasii abi ba maa ba gyaŋɛ mʋ, Yesu taasɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mɩnɛ nfɛɛrɛ nɩɩ fan sʋ lɩɩ Krisito mʋ sʋ? Anɩmʋ kanaana‐bii ɩ gyɛ mʋ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Owura Dawidi kanaana‐bii.” ");
INSERT INTO naw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nɩɩ Yesu taasɛ bamʋ yɛ, “Ɩ waa nɛnɛ sʋ nɩɩ Kayaayu tɔ Dawidi tɩɩ mʋ yɛ, ‘Ɔnyɩrɩpɛ?’ Lɩɩ fɛɛ Dawidi tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ɔnyɩrɩpɛ mʋ tɔwɛ mɛ‐Nyɩrɩpɛ yɛ, “kyɩna mɛ kɩbaa gyisa sʋ, naa fʋʋ saŋa mʋ nɩɩ n biti n taa fʋ dʋn ana waa fʋ ayaa kasɛ.” ’ ");
INSERT INTO naw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nɩɩ Owura Dawidi maa tɩɩ Krisito yɛ, ‘Mɛ‐Nyɩrɩpɛ’ mʋ, nɛnɛ sʋ nɩɩ ɛɛ bɩla taalɛ waa mʋ kanaana‐bii?” ");
INSERT INTO naw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bamʋ ɔkʋ man taalɛ bugi kɔnɔ tɔwɛ asɩn akʋ, nɩɩ lɩɩ kanɩn kakɛ maŋa taa kyʋn, ɔkʋ man bɩla taalɛ yɩlɛ tɔ taasɛ mʋ asɩn‐taasɛsa kʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nɩɩ Yesu tɔwɛ kʋbʋ damantɛ yɛ mʋ abɩɩlapʋ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nbara akaapʋpʋ yɛ Farasii abi mʋ ii yii anɛ naana Mosesi ayaa tɔ bɛɛ lɛɛ nbara mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ɩmʋ sʋ kʋtɔ kʋmaa mʋ nɩɩ ba tɔwɛ fanɛ yɛ fan waa mʋ, fan nu sa bamʋ kɛ fan waa. Amaa fan man waa atɔ mʋ nɩɩ bɛɛ waa mʋ, kpalɩ fɛɛ be mee buu atɔ mʋ nɩɩ bɛɛ tɔwɛ fanɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bee ŋmina ɩsʋla budusa nɩn bɛɛ sa asa yɛ ba sʋla, amaa bamʋ gbaa‐gbaa bamʋ bɩrɛ, ba mɛɛ yɛ ba taa bamʋ kɩbaa‐bi kyɛ asa mʋ tɔ kɛ ba sʋla. ");
INSERT INTO naw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Nɩɩ kʋtɔ kʋmaa mʋ nɩɩ bɛɛ waa mʋ, bɛɛ waa kɛ asa ba nyɛ wu bamʋ. Nɩɩ ba kyʋrɔɔ abwaarɛsɩn gyaga ɔwʋlɛ sʋ, nɩɩ ba taa ɩmʋ mata bamʋ asɩkpɩɩ yɛ abaa sʋ, nɩɩ ba waa bamʋ ɩkaalɛ nnɔ ayolobi bʋnswɩɩsa. ");
INSERT INTO naw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nɩɩ ba kpee kigyii nsarɛ tɔ abɛɛ kabwaarɛ kʋlɛ ɩgyaŋɛkpa tɔ mʋ, ɩkyɩnakpa kparɛ‐kparɛ nɩɩ bee biti ba kyɩna. ");
INSERT INTO naw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nɩɩ bee biti fɛɛ ɔkʋmaa mʋ nɩɩ ɔ gyaŋa bamʋ kadɛ tɔ mʋ, ɔ gyɔŋɔ fwaala bamʋ, nɩɩ ba bɩla bee biti asa ba tɩɩ bamʋ yɛ ‘Akaapʋpʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Amaa fanɛɛ fanɛ bɩrɛ, fan man yɛgɛ ba tɩɩ fanɛ yɛ, ‘Akaapʋpʋ,’ kpalɩ fɛɛ fan sʋ Ɔkaapʋpʋ kʋlʋn nɩn, fanɛ kpini fan gyɛ asupu yɛ adaa nɩn. ");
INSERT INTO naw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Fan man tɩɩ ɔkʋ yɛ ‘Ɔsɛ’ dulinyaa nɩmʋ tɔ, lɩɩ fɛɛ Ɔsɛ kʋlʋn nɩɩ fan sʋ, nɩɩ mʋ ɩ bʋ sʋsʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Abɛɛ fan man yɛgɛ ba tɩɩ fanɛ ɔkʋ yɛ ‘Ɔkaapʋpʋ’, kpalɩ fɛɛ Ɔkaapʋpʋ kʋlʋn nɩɩ fan sʋ, nɩɩ mʋ ɩ gyɛ Krisito mʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ɔmʋ nɩɩ ɔ gyɛ ɔbɩlɩsa fanɛ tɔ mʋ, ɩ dagaa maa gyɛ fanɛ kɩyaafɔlɛ. ");
INSERT INTO naw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɔ kʋsaa mʋ n‐yɩɩ sʋsʋ mʋ, Ɩbwaarɛ ii biti ɔ bɩya mʋ kasɛ, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ bɩya mʋ n‐yɩɩ kasɛ mʋ, Ɩbwaarɛ ii biti ɔ kʋsaa mʋ sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Fanɛ nbara akaapʋpʋ yɛ Farasii abi, fan gyɛ kebunbun ansi wuya ana, fanɛ laakʋ. Lɩɩ fɛɛ fen tii asa ɔkpa kanan mʋ nɩɩ ba man nyɛ loo sʋsʋ kuwura‐gyii mʋ tɔ. Fanɛ gbaa‐gbaa fanɛ fen mee loo to, nɩɩ fɛn mɛɛ yɛgɛ bamʋ nɩɩ bee biti ba loo mʋ, ba nyɛ loo to. ");
INSERT INTO naw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Fanɛ nbara akaapʋpʋ yɛ Farasii abi, fan gyɛ kebunbun ansi wuya ana, fanɛ laakʋ. Lɩɩ fɛɛ fen puni akulapu‐kyɩɩ fɛn gyii bamʋ akpaara, yɛgɛ fɛn kʋlɛ kabwaarɛ‐kʋlɛ bʋnswɩɩsa, kɛ asa ba nyɛ wu yɛ fen sun Ɩbwaarɛ kyɛɛkyɛɛ. Lɩɩ falɛ sʋ mʋ fanɛ kʋsʋ bɩɩtɛ ii biti ɩ baa ɩ kyɔ gaa. ");
INSERT INTO naw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Fanɛ nbara akaapʋpʋ yɛ Farasii abi, fan gyɛ kebunbun ansi wuya ana, fanɛ laakʋ. Lɩɩ fɛɛ fɛn natɛ nkyu sʋ yɛ ndɛ‐ndɛ sʋ, kɛ fɛn nyɛ kyɛɛgɛ nyɩmɩsa kʋlʋn ɔ ba sun Ɩbwaarɛ kanan mʋ nɩɩ fen sun mʋ. Amaa nɩɩ fan kan nyɛ mʋ mʋ, fɛn waa ɔsa mʋ ɔ dagaa awʋrʋfɔ fʋlɔn yen‐yen tɔ ɩlɩɩ ɩnyɔ fɛɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Fanɛ akaapʋpʋ mʋ nɩɩ fen du fɛɛ agyaatanapʋ nɩɩ fɛn gyankpaa asa mʋ, fanɛ laakʋ. Lɩɩ fɛɛ fɛn kaapʋ yɛ, ‘Nɩɩ ɔkʋ taa kabwaarɛ‐sunkpa ayɛ mʋ bɔ ntan mʋ, ɩ man gyɛ sɛhn, amaa nɩɩ ɔ kan taa kabwaarɛ‐sunkpa ayɛ mʋ tɔ suwa bɔ ntan mʋ, ɩ dagaa maa buu ntan mʋ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Fanɛ agyaatanapʋ melensipu! Suwa mʋ ɩ kyɔ abɛɛ kabwaarɛ‐sunkpa ayɛ mʋ? Nɩɩ man gyɛ suwa mʋ maa bʋ kabwaarɛ‐sunkpa ayɛ mʋ tɔ sʋ nɩɩ suwa mʋ biliŋi Ɩbwaarɛ lɛɛ abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nɩɩ fan bɩla tɔwɛ yɛ, ‘Nɩɩ ɔkʋ taa saraga kaswɩɩ bɔ ntan mʋ, ɩ man gyɛ sɛhn, amaa nɩɩ ɔ kan taa kakɛɛ mʋ nɩɩ kɩ gyan saraga kaswɩɩ mʋ sʋ bɔ ntan mʋ bɩrɛ, ɩ dagaa maa buu ntan mʋ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Fanɛ agyaatanapʋ banɩmʋ! Kakɛɛ mʋ ɩ kyɔ abɛɛ saraga kaswɩɩ mʋ? Nɩɩ man gyɛ kakɛɛ mʋ maa gyan saraga kaswɩɩ mʋ sʋ nɩɩ kɩ ba biliŋi Ɩbwaarɛ lɛɛ abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ɩmʋ sʋ ɔkʋmaa mʋ nɩɩ ɔ taa saraga kaswɩɩ bɔ ntan mʋ, ɔ taa kaswɩɩ mʋ maa kʋtɔ kʋmaa mʋ nɩɩ kɩ gyan kɩmʋ sʋ mʋ bɔ ntan nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ taa kabwaarɛ‐sunkpa ayɛ mʋ bɔ ntan mʋ, ɔ taa kɩmʋ yɛ Ɩbwaarɛ mʋ nɩɩ ɔ bʋ kɩmʋ tɔ mʋ bɔ ntan nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ taa sʋsʋ bɔ ntan mʋ, ɔ taa sʋsʋ kuwura‐gya yɛ ɔmʋ nɩɩ ɔ tɛ kɩmʋ sʋ mʋ bɔ ntan nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Fanɛ nbara akaapʋpʋ yɛ Farasii abi, fan gyɛ kebunbun ansi wuya ana, fanɛ laakʋ. Lɩɩ fɛɛ fɛn barɩgɛ fanɛ ɩpʋ atɔ, fɛɛ akatɛ, yɛ gaabu, yɛ akolonku ntun kudu‐kudu, nɩɩ fɛn taa ɩmʋ ketun kʋlʋn‐kʋlʋn fɛn sa Ɩbwaarɛ, amaa fɛn mɛɛ tʋwɛ asɩn kaapʋsa kparɛ mʋ nɩɩ ɩ bʋ nbara mʋ tɔ, fɛɛ kigyii asɩn ɩmʋ ɔkpa sʋ, kʋwɛɛ kuwu, yɛ kɩkɔɔlɛ‐gyii danbɩrasa. Falɛ atɔ nɩmʋ ɩ dagaa fan maa waa, yɛgɛ fɛn taa ntun kudu sʋ kutun kʋlʋn mʋ fɛn sa Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Fanɛ agyaatanapʋ agyankpaapʋ! Fɛn taalɛ fen wu kisusonbi kɛ fen fura mʋ fɔyɩ, amaa fɛn mɩyɛ nyɔɔma. ");
INSERT INTO naw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Fanɛ nbara akaapʋpʋ yɛ Farasii abi, fan gyɛ kebunbun ansi wuya ana, fanɛ laakʋ. Lɩɩ fɛɛ fɛn fwɩɩ fanɛ ɩlapɛ yɛ nwɛ‐bi nmaa kyɩrɛkyɩrɛ, yɛgɛ ɩmʋ ɩtɔ tɔ ɩ gyɛ atɔ mʋ nɩɩ fan taa kensi payɩ libi yɛ kekisi bɔla ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fanɛ Farasii agyaatanapʋ! Fan gyankpaa fwɩɩ nwɛ‐bi yɛ ɩlapɛ mʋ ɩtɔ tɔ, kɛ ɩmʋ nmaa gbaa ɩ lɩɩ kyɩrɛkyɩrɛ. ");
INSERT INTO naw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Fanɛ nbara akaapʋpʋ yɛ Farasii abi, fan gyɛ kebunbun ansi wuya ana, fanɛ laakʋ. Lɩɩ fɛɛ fan du nɩn fɛɛ nkyan mʋ nɩɩ ba pɔyɩ nɩɩ ba fuuli ɩmʋ sʋ parɛparɛ, nɩɩ ɩ bʋrɔn yɛgɛ ɩmʋ ɩtɔ tɔ bɩrɛ, abuni awuya yɛ atɔ mʋ nɩɩ ɩ gyɔɔ ɩ bɔla ɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kanɩn maŋa nɩɩ fan du. Asa ansi sʋ mʋ, fan gyɛ ɩkpa kyiigisa wuya ana, amaa fanɛ nkɔlɔ tɔ mʋ, fan gyɛ kebunbun ansi yɛ kumu tɔ ɔlʋn wuya ana nɩn. ");
INSERT INTO naw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Fanɛ nbara akaapʋpʋ yɛ Farasii abi, fan gyɛ kebunbun ansi wuya ana, fanɛ laakʋ. Lɩɩ fɛɛ fɛn pɔyɩ Ɩbwaarɛ atɔwɛpʋ mʋ nkyan, nɩɩ fan lɔŋɔ ɩkpa kyiigisa wuya ana nkyan sʋ yɛ ɔdan. ");
INSERT INTO naw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nɩɩ fɛn tɔwɛ yɛ, ‘Nɩɩ an daa an bʋ tɔ anɛ naana ana saŋa mʋ nɩn, naafɔɔ a mɛɛ yɛ a tii bamʋ sʋ kɛ a mɔɔ Ɩbwaarɛ atɔwɛpʋ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Fanɛ gbaa‐gbaa fanɛ ii gyii kesintin lɩɩ asɩn nɩmʋ sʋ yɛ bamʋ nɩɩ ba mɔɔ Ɩbwaarɛ atɔwɛpʋ mʋ, bamʋ‐bii ana ɩ gyɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kanɩn bɩrɛ fan tiisi lʋwɛ fanɛ naana ana alibi kusun mʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Fanɛ anansɛ yɛ anansɛ bamʋ‐bii ana! Nɛnɛ nɩɩ fɛn taalɛ sɩlɛ lɩɩ kɩpwɛ kibun yɛ awʋrʋfɔ fʋlɔn yen‐yen nɩmʋ tɔ? ");
INSERT INTO naw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kanɩn sʋ, n biti n sun Ɩbwaarɛ atɔwɛpʋ yɛ anyaasɩnpʋ yɛ akaapʋpʋ fanɛ asɛ. Amaa fen biti fan mɔɔ bamʋ akʋ, kɛ fan da akʋ mata iyu laasa sʋ, kɛ fan dayɩ akʋ fanɛ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa, kɛ fan gya bamʋ lɩɩ ndɛ sʋ kpee ndɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ɩmʋ sʋ kʋsʋ bɩɩtɛ lɩɩ ɩkpa kyiigisa wuya ana mʋ nɩɩ fanɛ asa ba kyɩna mɔɔ mʋ kpini, ii biti ɩ ba fanɛ sʋ. Lɩɩ ɩkpa kyiigisa wuya Abeli naa fʋʋ Barakiya mu‐bii Sakariya mʋ nɩɩ fanɛ Gyiwu abi ba daa mɔɔ mʋ, kabwaarɛ‐sunkpa ayɛ maa saraga kaswɩɩ nsana mʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","N tɔwɛ fanɛ kesintin fɛɛ, ɩnɩmʋ kpini kʋsʋ bɩɩtɛ ii biti ɩ ba ndaga kakyɩna nɩmʋ tɔ asa sʋ. ");
INSERT INTO naw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Oo! Gyerusalem asa! Fanɛ mʋ nɩɩ fɛn mɔɔ Ɩbwaarɛ atɔwɛpʋ, nɩɩ fɛn tʋʋ abuu fɛn mɔɔ bamʋ nɩɩ Ɩbwaarɛ sun fanɛ asɛ mʋ. N kpan mɛ n‐yɩɩ saŋa gaalaagaa fɛɛ n bʋga fanɛ‐bii ana, fɛɛ kanan mʋ nɩɩ kakyaasɛ‐nyi ɩɩ bʋga mu‐bii ana ɛɛ waa mʋ atɛɛ tɔ mʋ, amaa fen mee kyula. ");
INSERT INTO naw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Fanɛ kɩɩ, Ɩbwaarɛ lɩɩ fanɛ kabwaarɛ‐sunkpa ayɛ mʋ, nɩɩ ki biliŋi kɩtakpan. ");
INSERT INTO naw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","N tɔwɛ fanɛ nɩn yɛ fan man bɩla yɛ fan wu mɛ naa fʋʋ saŋa mʋ nɩɩ fen biti fan tɔwɛ yɛ, ‘Kusee ɩ gyɛ sa ɔmʋ nɩɩ ɛɛ ba Ɔnyɩrɩpɛ Ɩbwaarɛ kɩtɩɩ tɔ mʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu maa lɩɩ kabwaarɛ‐sunkpa ayɛ ee kpee mʋ, mʋ abɩɩlapʋ ba ba mʋ asɛ bɛɛ kaapʋ mʋ kanan mʋ nɩɩ kabwaarɛ‐sunkpa ayɛ ibu mʋ i du. ");
INSERT INTO naw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Yɛ fan wu atɔ nɩmʋ kpini? N tɔwɛ fanɛ kesintin yɛ halɩɩ kubuu kʋlʋn gbaa mɛɛ yɛ o sii kɩmʋ bɩrɩsa sʋ, kɛ ba man nin kɩmʋ tʋʋ.” ");
INSERT INTO naw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu maa tɛ olifu kɩbɩɩ mʋ sʋ mʋ, mʋ abɩɩlapʋ mʋ nkʋn ɩ ba mʋ asɛ ba taasɛ mʋ yɛ, “Tɔwɛ anɛ saŋa mʋ nɩɩ ɩnɩmʋ ii biti ɩ ba? Nɩɩ mɩnɛ ii biti ɩ baa ɩ gyɛ fʋ kɩba mʋ yɛ laalaalʋwɛ mʋ sɩnkaala?” ");
INSERT INTO naw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu lɛɛ kɔnɔ yɛ, “Fan baa fan da sʋ, kɛ ɔkʋ ɔ man pɩna fanɛ. ");
INSERT INTO naw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lɩɩ fɛɛ asa gaalaagaa bee biti ba ba mɛ kɩtɩɩ tɔ ba tɔwɛ yɛ, ‘Mɛ, ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ’, kɛ ba pɩna asa gaalaagaa. ");
INSERT INTO naw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Fen biti fan nu ɩkɔ sʋ kusakusa, kɛ fan nu ɩkɔ asɩn kata‐kata, amaa fan man yɛgɛ fanɛ nkɔlɔ ɩ ŋmaa fanɛ. Kanɩn atɔ maŋa ɩ dagaa ɩ maa waa, amaa ɩ mɛɛ kaapʋ fɛɛ laalaalʋwɛ mʋ tɛɛ fʋʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ndɛndɛmandɛ bee biti ba kɔ yɛ ndɛndɛmandɛ, kɛ kuwura‐gyii kɩ kɔ yɛ kuwura‐gyii. Akʋn lala yɛ kasɛ kigyingyen ii biti ɩ baa ɩ bʋ katɩn kʋmaa. ");
INSERT INTO naw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɩnɩmʋ kpini i du nɩn fɛɛ keduŋidi gyankpaasa. ");
INSERT INTO naw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nɩɩ bee biti ba taa fanɛ sa kɛ ba nyanla fanɛ kɛ ba mɔɔ fanɛ. Nɩɩ ɔsʋwʋlɛ sʋ asa kpini bee biti ba kisi fanɛ lɩɩ mɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kanɩn saŋa maŋa asa gaalaagaa bee biti ba biliŋi lɩɩ kɩkɔɔlɛ mɛ gyii tɔ, kɛ ba lɛɛ abaa sa kɛ ba kisi abaa, ");
INSERT INTO naw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","nɩɩ antɩŋɛsa atɔwɛpʋ gaalaagaa bee biti ba ba pɩna asa gaalaagaa. ");
INSERT INTO naw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lɩɩ kanan mʋ nɩɩ alibi kɩwaa ɩ lɔŋɔ tii sʋ sʋ mʋ, kɩnyɛ kebiti sa abaa ii biti ɩ ba kasɛ, ");
INSERT INTO naw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","amaa ɔmʋnɩ ɔ yɩlɛ tɔ kenken naa lʋwɛ mʋ, ii biti ɔ nyɛ kamɔlɩgɛ. ");
INSERT INTO naw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nɩɩ asa bee biti ba tɔwɛ Ɩbwaarɛ asɩn danbɩrasa nɩmʋ lɩɩ mu kuwura‐gyii mʋ sʋ dulinyaa tɔ kpini, kɛ ndɛndɛmandɛ kpini ba nu ɩmʋ, pɔyɩ kɛ laalaalʋwɛ mʋ ɔ baa. ");
INSERT INTO naw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ɩmʋ sʋ nɩɩ fan kan wu kʋtɔ kisisa mʋ nɩɩ kɩɩ bɩya alibi kɩ maa yɩlɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Daneli wʋla tɔwɛ yɩla lɩɩ koo dɩdaa mʋ, (Ɩ dagaa ɔkalɛpʋ mʋ maa nu ɩnɩmʋ kasɛ) ");
INSERT INTO naw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","saamʋ bamʋ nɩɩ ba bʋ Gyudeya mʋ ba sɩlɛ kpee abɩɩ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nɩɩ ɔkʋ kan ɔ bʋ obu ketin tɔ mʋ, ɔ man kpɩlɩgɛ ba kasɛ naa taa kʋtɔ kʋ lɩɩ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nɩɩ ɔkʋ kan ɔ bʋ ndɔɔ tɔ mʋ, ɔ man bwii kpee naa taa mʋ kaalɛ. ");
INSERT INTO naw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kanɩn nkɛ maŋa tɔ mʋ, ɩtɔ wuya ana yɛ atalapʋ, bamʋ laakʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Fan kʋlɛ Ɩbwaarɛ fɛɛ fanɛ kɩkʋsʋ sɩlɛ ɩnɩmʋ ɩ man ba waa awɔɔ saŋa, abɛɛ Kakɛ fʋʋtɛsa akɛ. ");
INSERT INTO naw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lɩɩ fɛɛ kanɩn saŋa maa awʋrʋfɔ ii biti ɩ baa ɩ bʋlʋn, nɩɩ awʋrʋfɔ kʋ man pɩɩ ba kanɩn lɩɩ koo dulinyaa npiili asɛ, nɩɩ ɩkʋ man bʋ tɔ ɩ bɩla ba kanɩn. ");
INSERT INTO naw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nɩɩ Ɩbwaarɛ man kan tɩn nkɛ mʋ sʋ bɩrɛ, naafɔɔ ɔkʋ man bʋ tɔ ɔ nyɛ kamɔlɩgɛ, amaa lɩɩ bamʋ nɩɩ ɔ lɛɛ mʋ sʋ mʋ, ee biti ɔ tɩn nkɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kanɩn saŋa maŋa nɩɩ ɔkʋ kan tɔwɛ fʋ yɛ, ‘Kɩɩ, Krisito mʋ bʋ nfɩɩ’ abɛɛ ‘Mʋ ɩ bʋ falɛ’ mʋ, man kɔɔlɛ ɩmʋ gyii. ");
INSERT INTO naw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Lɩɩ fɛɛ antɩŋɛsa Krisito yɛ antɩŋɛsa Ɩbwaarɛ atɔwɛpʋ bee biti ba ba, kɛ ba waa ɩsɩnkaala lala yɛ adangana kɛ ɩ nyɛ taalɛ pɩna bamʋ nɩɩ Ɩbwaarɛ lɛɛ mʋ gbaa. ");
INSERT INTO naw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Fan kɩɩ, n gyankpaa n tɔwɛ fanɛ ɩnɩmʋ nɩn pɔyɩ kɛ ɩ ba. ");
INSERT INTO naw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ɩmʋ sʋ nɩɩ ɔkʋ kan tɔwɛ fanɛ yɛ, ‘Krisito mʋ ɩ lɩɩ ɔ bʋ keperi sʋ falɛ’ mʋ, fan man kpee tʋtɔ, abɛɛ ɔkʋ kan tɔwɛ yɛ, ‘Krisito mʋ baala nfɩɩ’ mʋ, fan man kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Lɩɩ fɛɛ, kanan mʋ nɩɩ bʋlayɩ ɩ wɛɛ ɩsɛɛ lɩɩ kyɔwɛ kɩlɩɩ, nɩɩ bee wu kɩmʋ halɩɩ kyɔwɛ kɩtɩyɛ mʋ, kanɩn maŋa nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ kɩba ii biti ɩ baa i du. ");
INSERT INTO naw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Katɩn kʋmaa mʋ nɩɩ kʋtɔ belenbuni ɔsa bʋ mʋ, tʋtɔ maŋa nɩɩ agyinbwii bɛɛ lantɛ. ");
INSERT INTO naw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Saŋa maŋa awʋrʋfɔ mʋ kamaa mʋ, opula tɔ ‘nɩɩ kyɔwɛ ii biti o bii tɔ, nɩɩ ɔbwaayɩ mɛɛ yɛ ɔ baa ɔ kɩɩ tɔ, nɩɩ akyikpebi ii biti ɩɩ lɩɩ sʋsʋ tɩyɛ, kɛ atɔ kʋmaa mʋ nɩɩ ɩ bʋ sʋsʋ mʋ i gyingyen.’ ");
INSERT INTO naw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Kanɩn saŋa maŋa mɛ, Daadimaadi Obii‐nyɩnsa mʋ sɩnkaala ii biti ɩ lɩɩ sʋsʋ, nɩɩ ndɛndɛmandɛ asa mʋ nɩɩ ba bʋ kasɛ sʋ mʋ bee biti ba bɔɔta tɔ, fɛɛ ba maa wu mɛ, Daadimaadi Obii‐nyɩnsa mʋ n maa lɩɩ abwaarɛ‐wʋlɛ tɔ sʋsʋ n ba yɛ ɔlʋn yɛ bʋnyaa lala mʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nɩɩ n biti n sun mɛ nbɔɔ, kɛ ba fʋlɛ nbɩlɛ kenken, kɛ ba bʋga bamʋ nɩɩ n lɛɛ mʋ lɩɩ dulinyaa abɔntɔnbʋlɔn kpini. ");
INSERT INTO naw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nbɩɩnbɩɩ, fan bɩɩla asɩn lɩɩ figi oyu mʋ asɛ. Nɩɩ ɩmʋ n‐yaabi ɩ kan ɩɩ pɔrɔgɛ nɩɩ ɩɩ lɛɛ afatɛɛ pʋpwɛ mʋ, fɛn bɩɩ fɛɛ kɩbɩlɛ saŋa tiri tɔ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kanɩn maŋa nɩɩ fan wu ɩnɩmʋ kpini mʋ, fan bɩɩ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa kɩba mʋ ki tiri tɔ, fɛɛ n ba. ");
INSERT INTO naw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","N tɔwɛ fanɛ kesintin fɛɛ ndaga kakyɩna nɩmʋ tɔ asa ba mɛɛ yɛ ba wu lʋwɛ, pɔyɩ kɛ falɛ asɩn nɩmʋ kpini ɩ waa. ");
INSERT INTO naw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sʋsʋ yɛ kasɛ ii biti ɩ kyʋn, amaa mɛ asɩn ɩ man bʋ tɔ ɩ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Amaa lɩɩ kakɛ mʋ abɛɛ kerefi mʋ nɩɩ ɩnɩmʋ ii biti ɩ waa mʋ ɔkʋ man nyi. Sʋsʋ nbɔɔ ba man nyi, halɩɩ mɛ, Ɩbwaarɛ mu‐Bii mʋ gbaa man nyi, amɔɔ Ɔsɛ mʋ nkʋn. ");
INSERT INTO naw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kanan mʋ nɩɩ ɩ kyɩna i du Nowa saŋa mʋ, kanɩn maŋa nɩɩ ii biti ɩ baa i du mɛ, Daadimaadi Obii‐nyɩnsa mʋ kɩba saŋa. ");
INSERT INTO naw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lɩɩ fɛɛ pɔyɩ kɛ nkyu i muuri dulinyaa mʋ, asa ba kyɩna ba maa sʋ bee gyii yɛgɛ bee nuu, anyɩn yɛ akyɩɩ bee kili, naa fʋʋ kakɛ mʋ nɩɩ Nowa loo ɔkʋlɩ mʋ tɔ, ");
INSERT INTO naw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","yɛgɛ ba man nyi kʋtɔ mʋ nɩɩ kii biti kɩ ba, halɩɩ nkyu ɩ ba taa bamʋ kpini kyʋn. Kanɩn maŋa nɩɩ ii biti ɩ waa mɛ, Daadimaadi Obii‐nyɩnsa kɩba mʋ saŋa. ");
INSERT INTO naw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Anyɩn anyɔ bee biti ba baa ba bʋ ndɔɔ tɔ, n biti n taa ɔkʋ kɛ n yɛgɛ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akyɩɩ anyɔ bee biti ba baa bɛɛ kɔyɩ kubuu sʋ, n biti n taa ɔkʋ yɛgɛ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kanɩn sʋ fan baa fan da sʋ, lɩɩ fɛɛ fan man nyi kakɛ mʋ nɩɩ mɛ, fanɛ‐Nyɩrɩpɛ mʋ ii biti ɔ ba. ");
INSERT INTO naw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Fan baa fen nyi ɩnɩmʋ fɛɛ, nɩɩ kɩkpaara wuya dɩn o nyi kagyanbwɛ saŋa mʋ nɩɩ oyu ii biti ɔ ba nɩn, naafɔɔ ɔ dɩn kyɩna kun, kɛ oyu mʋ ɔ man ba nyɛ boyi loo mʋ kɩkpaara sʋ yuuri. ");
INSERT INTO naw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ɩmʋ sʋ fanɛ gbaa fanɛ fan kʋʋla fan gyoo, lɩɩ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa n biti n ba saŋa mʋ nɩɩ fan man kɩɩ mɛ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Anɩmʋ ɩ gyɛ kɩyaafɔlɛ kesintin gyipu yɛ kanyaasɩn wuya? Mʋ ɩ gyɛ ɔmʋ nɩɩ mʋ‐nyɩrɩpɛ taa mʋ waa mʋ ayaafɔlɛ mʋ nɩɩ ba bʋ kɩkpaara sʋ mʋ ɔkɩɩsʋpʋ fɛɛ ɔ sa bamʋ agyitɔ saŋa kyɛɛkyɛɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ii biti ɩ baa ɩ bʋrɔn sa kanɩn kɩyaafɔlɛ maŋa fɛɛ mʋ‐nyɩrɩpɛ maa ba tu mʋ yɛgɛ ɛɛ waa kanɩn. ");
INSERT INTO naw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","N tɔwɛ fanɛ kesintin yɛ, mʋ‐nyɩrɩpɛ mʋ ii biti ɔ taa mʋ kʋtɔ kʋmaa nɩmʋ waa mʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amaa a taa fɛɛ kanɩn kɩyaafɔlɛ maŋa libi nɩɩ ɔ tɔwɛ yɛ, ‘Mɛ‐nyɩrɩpɛ ii biti ɔ kyɩna tʋtɔ kyɛɛrɛɛ,’ ");
INSERT INTO naw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kɛ o piili ɛɛ dayɩ mʋ bɩrɩsa ana ayaafɔlɛ mʋ, yɛgɛ ee gyii ee nuu maa atabʋʋpʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kanɩn kɩyaafɔlɛ maŋa mʋ‐nyɩrɩpɛ ii biti ɔ ba kakɛ mʋ nɩɩ ɔ man kɩɩ mʋ ɔkpa, yɛ saŋa mʋ nɩɩ ɔ man nyi sʋ. ");
INSERT INTO naw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ee biti ɔ bɩɩtɛ kɩyaafɔlɛ mʋ kʋsʋ gaa, kɛ ɔ gya mʋ naa waa kebunbun ansi wuya opula, katɩn mʋ nɩɩ bee biti ba baa bɛɛ saawʋ yɛgɛ bee duŋi bamʋ anobi mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nɩɩ Yesu bɩla bɔ kɩŋasan kʋ yɛ, “Kanɩn saŋa maŋa mʋ sʋsʋ kuwura‐gyii mʋ ii biti ɩ baa i du nɩn fɛɛ, abite kudu mʋ nɩɩ ba taa bamʋ ɩfɩtɩla lɩɩ kyʋn ba naa gyaŋa ɔkyɩɩfɔ mu‐kuli. ");
INSERT INTO naw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bamʋ tɔ anu ba gyɛ amelensipu nɩɩ anu mɔɔ ba gyɛ anyaasɩnpʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nɩɩ amelensipu anu mʋ ba maa dan taa bamʋ ɩfɩtɩla mʋ, ba man taa fɩtɩla nfɔ kɩtaa tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amaa anyaasɩnpʋ anu mʋ bɩrɛ ba kɩtaa fɩtɩla nfɔ ɩpʋrʋntʋwa tɔ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɔkyɩɩfɔ mu‐kuli mʋ maa man ba bilen sʋ mʋ, nsɩɩrɛ ɩ kɩtaa bamʋ, nɩɩ ba dɛ. ");
INSERT INTO naw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ɩ maa ba fʋʋ kiyiridi nsana mʋ, nɩɩ ɔkʋ kuusi tɔwɛ yɛ, ‘Ɔkyɩɩfɔ mu‐kuli mʋ ɩɩ ba! Fan lɩɩ ba gyaŋa mʋ!’ ");
INSERT INTO naw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Nɩɩ abite kudu mʋ kpini ba kʋsʋ diyaa bamʋ ɩfɩtɩla. ");
INSERT INTO naw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tʋtɔ nɩɩ amelensipu mʋ ba tɔwɛ anyaasɩnpʋ mʋ yɛ, ‘Fan sa anɛ fanɛ nfɔ mʋ ɩkʋ, kpalɩ fɛɛ anɛ ɩfɩtɩla tɔ nfɔ ɩ lʋwɛ.’ ");
INSERT INTO naw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Nɩɩ anyaasɩnpʋ ba lɛɛ kɔnɔ yɛ, ‘Ayee! Anɛ gbaa anɛ lɛɛ ɩ man kyɔ kɛ ɩ fʋʋ ana fanɛ. Amɔɔ, fen kpee bamʋ nɩɩ bɛɛ fɛɛ mʋ asɛ kɛ fan naa sɔɔ.’ ");
INSERT INTO naw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Amaa ba maa kpee ba naa sɔɔ mʋ, nɩɩ ɔkyɩɩfɔ mu‐kuli mʋ ba. Nɩɩ anyaasɩnpʋ anu mʋ nɩɩ ba kʋʋla ba gyoo mʋ mʋ, ba nyɛ buu mʋ loo kɩkyɩɩfɔ kensi‐gyii kɩkpaara mʋ sʋ. Nɩɩ ba kɩtaa ɔpʋnʋ mʋ tii. ");
INSERT INTO naw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kamaa tɔ abite amelensipu anu mʋ ba maa ba mʋ, ba tɔwɛ yɛ, ‘Ɔbɩlɩsa! Ɔbɩlɩsa! Tigi ɔpʋnʋ mʋ sa anɛ kɛ a loo.’ ");
INSERT INTO naw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Amaa ɔ lɛɛ bamʋ kɔnɔ yɛ, ‘N tɔwɛ fanɛ kesintin fɛɛ, n man nyi fanɛ!’ ” ");
INSERT INTO naw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu lʋwɛ yɛ, “Ɩmʋ sʋ fɛn baa fan da sʋ, lɩɩ fɛɛ fan man nyi kakɛ abɛɛ saŋa mʋ nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n biti n ba.” ");
INSERT INTO naw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu bwii bɔ kɩŋasan kʋ yɛ, “Sʋsʋ kuwura‐gyii mʋ ii biti ɩ baa i du fɛɛ ɔnyɩn kʋ maa kpee ɔkpa, nɩɩ ɔ tɩɩ mʋ ayaafɔlɛ taa mʋ kapatɩyɛ waa bamʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɔ sa bamʋ kanan mʋ nɩɩ ɔkʋmaa nɩmʋ ɔlʋn du. Ɔ sa ɔkʋ afulee ngbɩn nnuu, nɩɩ ɔ sa ɔkʋ mɔɔ afulee ngbɩn nnyɔ, lan sa ɔkʋ mɔɔ afulee kagbɩn kʋlʋn, nɩɩ ɔ kyʋn mʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nɩɩ kɩyaafɔlɛ mʋ nɩɩ ɔ nyɛ afulee ngbɩn nnuu mʋ taa piili kusun opula tɔ, nɩɩ ɔ nyɛ agyaga ngbɩn nnuu tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kanɩn nɩn, nɩɩ ɔmʋ nɩɩ ɔ nyɛ ngbɩn nnyɔ mʋ gbaa taa waa kusun, nɩɩ ɔ nyɛ ngbɩn nnyɔ agyaga tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amaa kɩyaafɔlɛ mʋ nɩɩ ɔ nyɛ kagbɩn kʋlʋn mʋ bɩrɛ, taa mʋ‐nyɩrɩpɛ afulee mʋ naa kuu pula. ");
INSERT INTO naw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ɩ maa kyɛɛrɛɛ kamaa tɔ mʋ, bamʋ‐nyɩrɩpɛ mʋ naa bwii ba, nɩɩ ɔ tɩɩ bamʋ yɛ ba ba kaapʋ tɔ kanan mʋ nɩɩ ba nyɛ agyaga tii afulee mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kɩyaafɔlɛ mʋ nɩɩ ɔ sa mu afulee ngbɩn nnuu mʋ loo ba, nɩɩ ɔ taa ngbɩn nnuu tii sʋ sa mʋ. Nɩɩ ɔ tɔwɛ yɛ, ‘Mɛ‐nyɩrɩpɛ, fʋ taa ngbɩn nnuu nɩn sa mɛ. Kɩɩ, n nyɛ agyaga ngbɩn nnuu tii sʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Mʋ‐nyɩrɩpɛ mʋ yɩn mʋ tɔwɛ yɛ, ‘Fʋ waa kusun, fʋ gyɛ kɩyaafɔlɛ danbɩrasa yɛ kesintin gyipu. Fʋ gyii kesintin lɩɩ atɔ pii anɩmʋ sʋ. Ɩmʋ sʋ n biti n taa atɔ damantɛ waa fʋ abaa tɔ kɛ fʋ kɩɩ sʋ. Ba kɛ a bʋga gyii kensi‐gyii mʋ nɩɩ n gyii mʋ!’ ");
INSERT INTO naw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nɩɩ kɩyaafɔlɛ mʋ nɩɩ ɔ sa mʋ ngbɩn nnyɔ mʋ gbaa ba, nɩɩ ɔ tɔwɛ yɛ, ‘Mɛ‐nyɩrɩpɛ, fʋ taa ngbɩn nnyɔ nɩɩ waa mɛ abaa tɔ, kɩɩ, n nyɛ agyaga ngbɩn nnyɔ tii sʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Mʋ‐nyɩrɩpɛ mʋ yɩn mʋ tɔwɛ yɛ, ‘Fʋ waa kusun, fʋ gyɛ kɩyaafɔlɛ danbɩrasa yɛ kesintin gyipu. Fʋ gyii kesintin lɩɩ atɔ pii anɩmʋ sʋ. Ɩmʋ sʋ n biti n taa atɔ damantɛ waa fʋ abaa tɔ kɛ fʋ kɩɩ sʋ. Ba kɛ a bʋga gyii kensi‐gyii mʋ nɩɩ n gyii mʋ!’ ");
INSERT INTO naw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tʋtɔ nɩɩ kɩyaafɔlɛ mʋ nɩɩ ɔ nyɛ kagbɩn kʋlʋn mʋ ba, nɩɩ ɔ yɛ, ‘Mɛ‐nyɩrɩpɛ, n nyi fʋ asɩn ɩ maa bʋlʋn, nɩɩ fɩɩ tɩŋɛ katɩn mʋ nɩɩ fʋ man duu, nɩɩ fɩɩ kʋʋla fɩɩ waa ɩbɔɔta tɔ, ɩmʋ nɩɩ fʋ man kyaalɛ. ");
INSERT INTO naw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ɩmʋ sʋ n sʋ kufuu nɩɩ n taa afulee mʋ nɩɩ fʋ taa waa mɛ abaa tɔ mʋ, naa kuu ɩmʋ pula. Kɩɩ, fu afulee ndee.’ ");
INSERT INTO naw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nɩɩ mʋ‐nyɩrɩpɛ mʋ lɛɛ kɔnɔ yɛ, ‘Fʋ gyɛ kɩyaafɔlɛ libi yɛ ɔwʋlɛgyɔpʋ. Fu nyi n maa tɩŋɛ katɩn mʋ nɩɩ n man duu, nɩɩ n kʋʋla n waa ɩbɔɔta tɔ, katɩn mʋ nɩɩ n man kyaalɛ. ");
INSERT INTO naw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kanɩn bɩrɛ, naafɔɔ ɩ dagaa fɛɛ fʋ taa mɛ afulee mʋ naa yɩla afulee ɔyɩlɛkpa, kɛ n maa bwii ba falɛ mʋ, n nyɛ mɛ afulee kibi yɛ agyaga tii sʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Tʋtɔ nɩɩ ɔnyɩrɩpɛ mʋ tɔwɛ mʋ ayaafɔlɛ mʋ yɛ, ‘Fan kɔɔlɛ afulee kagbɩn kʋlʋn mʋ lɩɩ mʋ asɛ, kɛ fɛn taa sa ɔmʋ nɩɩ ɔ nyɛ ngbɩn kudu mʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɔ sʋ mʋ, bee biti ba sa mʋ tii sʋ, kɛ ɔ nyɛ naa bansʋ, amaa ɔkʋmaa mʋ nɩɩ ɔ man sʋ, nɩɩ halɩɩ gbɛrɛɛ mʋ nɩɩ ɔ sʋ gbaa mʋ, bee biti ba kɔɔlɛ lɩɩ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Fan taa kɩyaafɔlɛ gyaga mʋ nɩɩ ɔ man sʋ kyaarɛ falɛ, naa tʋʋ kitentenbiri tumm mʋ tɔ. Tʋtɔ nɩɩ ee biti ɔ sawʋ kɛ o duŋi mʋ anobi.’ ” ");
INSERT INTO naw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nɩɩ Yesu bɩla tɔwɛ yɛ, “Saŋa mʋ nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa n biti n ba yɛ mɛ bʋnyaa, maa sʋsʋ nbɔɔ kpini mʋ, n biti n kyɩna mɛ kuwura‐gya mʋ sʋ bʋnyaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","N biti ɩ bɩya ndɛndɛmandɛ kpini ba gyaŋɛ mi ansi tɔ, nɩɩ n biti n barɩgɛ asa mʋ tɔ ntun nnyɔ, fɛɛ kanan mʋ nɩɩ atɔbwaaya ɔkpapʋ ɩɩ barɩgɛ nbʋlʋpʋ ɛɛ lɩɩ nbwɛ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","N biti n taa nbʋlʋpʋ yɩlɛ mɛ gyisa sʋ, kɛ n taa nbwɛ mɔɔ yɩlɛ mɛ bɩna sʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Tʋtɔ nɩɩ mɛ, mʋ nɩɩ n gyɛ Owura mʋ n biti n tɔwɛ bamʋ nɩɩ ba yɩlɛ mɛ gyisa sʋ mʋ yɛ, ‘Fanɛ ɩ gyɛ bamʋ nɩɩ mɛ‐Sɛ Ɩbwaarɛ waa kusee mʋ, fan ba kuwura‐gyii mʋ nɩɩ ɔ yɩla sa fanɛ lɩɩ koo saŋa mʋ nɩɩ ɔ tʋʋ dulinyaa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Lɩɩ fɛɛ akʋn ɩ maa sʋ mɛ mʋ, fanɛ ɩ sa mɛ agyitɔ nɩɩ n gyii, bʋlɩfɔ maa sʋ mɛ mʋ, fanɛ ɩ sa mɛ nkyu nɩɩ n nuu, n maa gyɛ ɔfɔ mʋ, fanɛ ɩ kɔɔlɛ mɛ fanɛ ayɛ. ");
INSERT INTO naw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","N maa man sʋ atɔ bunsa mʋ, fanɛ ɩ sa mɛ nɩɩ n bun, n maa lɔ mʋ, fanɛ ɩ kɩɩ mɛ sʋ, n maa bʋ obu tiisa tɔ mʋ, fanɛ ɩ bɔɔ mɛ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tʋtɔ nɩɩ bamʋ nɩɩ bamʋ ɩkpa i kyiigi mʋ bee biti ba lɛɛ kɔnɔ yɛ, ‘Ɔnyɩrɩpɛ, saŋa mɔɔ nɩɩ an wu fʋ akʋn ɩ maa sʋ fʋ, nɩɩ an sa fʋ agyitɔ nɩɩ fu gyii, abɛɛ bʋlɩfɔ maa sʋ fʋ, nɩɩ an sa fʋ nkyu nɩɩ fʋ nuu? ");
INSERT INTO naw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Saŋa mɔɔ nɩɩ an wu fʋ maa gyɛ ɔfɔ, nɩɩ an kɔɔlɛ fʋ ba anɛ ayɛ, abɛɛ atɔ bunsa ɩ maa tiri, nɩɩ an sa fʋ nɩɩ fʋ bun? ");
INSERT INTO naw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Saŋa mɔɔ nɩɩ an wu fʋ maa lɔ, abɛɛ fʋ maa tii obu tiisa tɔ nɩɩ an naa bɔɔ fʋ sʋ?’ ");
INSERT INTO naw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Nɩɩ mɛ, mʋ nɩɩ n gyɛ Owura mʋ, n biti n lɛɛ kɔnɔ yɛ, ‘N tɔwɛ fanɛ kesintin fɛɛ kʋtɔ kʋmaa mʋ nɩɩ fan waa sa mɛ asa, halɩɩ bamʋ tɔ opii gbaa mʋ, mɛ nɩɩ fan waa sa.’ ");
INSERT INTO naw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tʋtɔ nɩɩ n biti n tɔwɛ bamʋ nɩɩ ba yɩlɛ mɛ bɩna sʋ mʋ yɛ, ‘Fan taa lɩɩ mɛ sʋ, fanɛ nɩɩ mɛ‐Sɛ Ɩbwaarɛ tɔwɛ nnɔ waa mʋ. Fan natɛ loo awʋrʋfɔ fʋlɔn yen‐yen mʋ nɩɩ ii mee dun, nɩɩ mɛ‐Sɛ Ɩbwaarɛ dɛɛla yɩla Sɩtaanɛ maa mʋ nbɔɔ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Lɩɩ fɛɛ akʋn ɩ maa sʋ mɛ mʋ, fan man sa mɛ agyitɔ nɩɩ n gyii, bʋlɩfɔ maa sʋ mɛ mʋ, fan man sa mɛ nkyu nɩɩ n nuu. ");
INSERT INTO naw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","N maa gyɛ ɔfɔ mʋ, fan man kɔɔlɛ mɛ fanɛ ayɛ, atɔ bunsa ɩ maa tiri mɛ mʋ, fan man sa mɛ nɩɩ n bun, n maa lɔ, abɛɛ n maa bʋ obu tii tɔ mʋ, fan man ba bɔɔ mɛ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ngbaa bamʋ bee biti ba lɛɛ kɔnɔ yɛ, ‘Ɔnyɩrɩpɛ, saŋa mɔɔ nɩɩ an wu akʋn ɩ maa sʋ fʋ, abɛɛ bʋlɩfɔ maa sʋ fʋ, abɛɛ fʋ maa gyɛ ɔfɔ, abɛɛ atɔ bunsa ɩ maa tiri fʋ, abɛɛ fʋ maa lɔ, abɛɛ fʋ maa bʋ obu tii tɔ, nɩɩ an man kyɛ fʋ tɔ?’ ");
INSERT INTO naw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Nɩɩ mɛ, mʋ nɩɩ n gyɛ Owura mʋ n biti n lɛɛ bamʋ kɔnɔ yɛ, ‘N tɔwɛ fanɛ kesintin nɩn fɛɛ, kʋtɔ kʋmaa mʋ nɩɩ fan kina kɩwaa sa mɛ asa, halɩɩ bamʋ tɔ opii gbaa mʋ, mɛ nɩɩ fan kina kɩwaa sa.’ ");
INSERT INTO naw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Tʋtɔ mʋ, bee biti ba naa loo kʋsʋ bɩɩtɛ kakpaa tɔ, amaa ɩkpa kyiigisa wuya ana bɩrɛ bee biti ba kyɩna nkpa kakpaa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu maa tɔwɛ ɩnɩmʋ kpini lʋwɛ mʋ, ɔ tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Fɛɛ kanan mʋ nɩɩ fen nyi mʋ, ɩ san nkɛ nnyɔ kɛ kanyaŋɛ nbunɔ kensi kigyii saŋa mʋ ɔ fʋʋ. Saŋa maa nɩɩ bee biti ba lɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ sa, kɛ ba da mɛ mata oyu laasa sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kanɩn saŋa maŋa nɩɩ aseepu bɩlɩsa yɛ asa mʋ abɩlɩsa ba naa sarɛ oseepu bɩlɩsa asɛ mʋ nɩɩ bɛɛ tɩɩ yɛ Kayifasi mʋ lenbu tɔ, ");
INSERT INTO naw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","naa ŋmina kanan mʋ nɩɩ ba taa kanyaasɩn ɔkpa sʋ kɩtaa Yesu kɛ ba mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amaa ba tɔwɛ yɛ, “A man waa kanɩn kensi‐gyii saŋa nɩmʋ tɔ, nɩɩ man gyɛ kanɩn mʋ, sʋgʋrɛ‐sʋgʋrɛ ii biti ɔ ba kadɛ mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu maa kyɩna ɔ bʋ Betani ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Simon, nɩɩ ɔ kyɩna ɔ gyɛ bootipu mʋ ayɛ mʋ, ");
INSERT INTO naw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nɩɩ ɔkyɩɩ kʋ taa tulale mʋ nɩɩ kɩ sʋ ɔgyalɩn pʋrʋntʋwa bɔla, ba mʋ asɛ saŋa mʋ nɩɩ ɔ tɛ ee gyii mʋ. Nɩɩ ɔ kyɛɛgɛ tulale mʋ wʋrɩgɛ Yesu kumu tɔ. ");
INSERT INTO naw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesu abɩɩlapʋ ba maa wu kanɩn mʋ, ɩ basa bamʋ nɩɩ ba taasɛ yɛ, “Mɩnɛ ɩ waa nɩɩ ɔkyɩɩ mʋ ii nyita tulale maa kanɩn? ");
INSERT INTO naw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Naafɔɔ bɛ taalɛ fɛ tulale nɩmʋ nyɛ afulee damantɛ kɛ ba taa ɩmʋ sa atiripu.” ");
INSERT INTO naw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu maa bɩɩ asɩn mʋ nɩɩ bɛɛ tɔwɛ mʋ, nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ ɩ waa nɩɩ fɛn tɔɔrɔɔ ɔkyɩɩ maŋa? Kʋtɔ danbɩrasa nɩɩ ɔ waa sa mɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Atiripu mʋ bɩrɛ ba bʋ fanɛ asɛ saŋa kʋmaa, amaa mɛɛmɛ bɩrɛ n mɛɛ yɛ n kyɩna fanɛ asɛ saŋa kʋmaa. ");
INSERT INTO naw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Maa kyɛɛgɛ tulale nɩmʋ wʋrɩgɛ mɛ n‐yɩɩ sʋ mʋ, ɛɛ lɔŋɔ mɛ n‐yɩɩ ɛɛ yɩla mi kepula. ");
INSERT INTO naw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","N tɔwɛ fanɛ kesintin nɩn fɛɛ, dulinyaa tɔ katɩn kʋmaa mʋ nɩɩ ba tɔwɛ asɩn danbɩrasa mʋ, bee biti ba tɔwɛ kʋtɔ mʋ nɩɩ ɔ waa falɛ taa nyiŋi mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nɩɩ abɩɩlapʋ kudu anyɔ mʋ tɔ ɔkʋ, mʋ nɩɩ bɛɛ tɩɩ yɛ Gyudasi Isikariyoti mʋ kpee aseepu abɩlɩsa mʋ asɛ, ");
INSERT INTO naw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","naa taasɛ bamʋ yɛ, “N kan lɛɛ mʋ sa fanɛ mʋ, mɩnɛ nɩɩ fen biti fan sa mɛ?” Tʋtɔ nɩɩ ba karagɛ afulee nderebi adɩsa sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Lɩɩ kanɩn saŋa maŋa taa kyʋn mʋ, Gyudasi piili ee biti ɔkpa mʋ nɩɩ ɔ bɔla sʋ lɛɛ Yesu sa. ");
INSERT INTO naw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bodobodo mʋ nɩɩ kɩ man sʋ kɩfɛ tinsa kigyii kakɛ gyankpaasa mʋ, Yesu abɩɩlapʋ mʋ ba ba mʋ asɛ ba taasɛ mʋ yɛ, “Fɩnɛ nɩɩ fii biti fɛɛ a naa lɔŋɔ yɩla, kɛ a naa gyii Kanyaŋɛ nbunɔ kesu kensi‐gyii mʋ?” ");
INSERT INTO naw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan kpee kadɛ mʋ tɔ ɔnyɩn kʋ asɛ naa tɔwɛ mʋ yɛ, ‘Ɔkaapʋpʋ mʋ yɛ, Mɛ saŋa tiri tɔ. N biti fɛɛ n maa mɛ abɩɩlapʋ an biti a ba gyii Kanyaŋɛ nbunɔ kensi‐gyii mʋ fʋ ayɛ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nɩɩ mʋ abɩɩlapʋ mʋ ba kpee naa waa kanan mʋ nɩɩ ɔ tɔwɛ bamʋ mʋ, nɩɩ ba waa Kanyaŋɛ nbunɔ kensi‐gyii mʋ agyitɔ mʋ yɩla. ");
INSERT INTO naw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɩ maa fʋʋ kalaatɩpwɛ sʋ mʋ, Yesu maa mʋ abɩɩlapʋ kudu anyɔ mʋ, ba tɛ bee gyii. ");
INSERT INTO naw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ba maa gyii mʋ nɩɩ Yesu tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin fɛɛ, fanɛ tɔ ɔkʋ ii biti ɔ lɛɛ mɛ sa.” ");
INSERT INTO naw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nɩɩ bamʋ nfɛɛrɛ tɔ ii nyita bamʋ gaa, nɩɩ ba piili bɛɛ taasɛ mʋ kʋkʋlʋn‐kʋkʋlʋn yɛ “Ɔnyɩrɩpɛ, kesintin tɔ, man gyɛ mɛ nɩɩ fʋ dɛɛ?” ");
INSERT INTO naw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Ɔmʋ nɩɩ maa mʋ abaa ɩ bʋga ii loo lapɛ kʋlʋn tɔ mʋ, ii biti ɔ lɛɛ mɛ sa. ");
INSERT INTO naw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Fɛɛ kanan mʋ nɩɩ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ mɛ, Daadimaadi Obii‐nyɩnsa n biti n wu mʋ, kanɩn nɩɩ ii biti ɩ waa. Amaa kanɩn nyɩmɩsa mʋ nɩɩ ee biti ɔ lɛɛ mɛ sa mʋ, laakʋ. Nɩɩ ba man da kʋʋgɛ mʋ gbaa nɩn, naafɔɔ ɩ bɔ.” ");
INSERT INTO naw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tʋtɔ nɩɩ Gyudasi mʋ nɩɩ ee biti ɔ lɛɛ mʋ sa mʋ gbaa taasɛ Yesu yɛ, “Ɔkaapʋpʋ mɛ nɩɩ fʋ dɛɛ?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɛɛhn, kanɩn nɩɩ fʋ tɔwɛ maa?” ");
INSERT INTO naw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ba maa gyii mʋ Yesu taa bodobodo, nɩɩ ɔ fwaala Ɩbwaarɛ nɩɩ ɔ gyayɩ kɩmʋ tɔ, nɩɩ ɔ taa sa mʋ abɩɩlapʋ tɔwɛ yɛ, “Fan kɔɔlɛ kɛ fan gyii, kɩnɩmʋ ɩ gyɛ mɛ kayɩɩ‐wʋlɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nɩɩ ɔ taa kɔɔpʋ mʋ, nɩɩ ɔ fwaala Ɩbwaarɛ, nɩɩ ɔ taa sa mʋ abɩɩlapʋ mʋ tɔwɛ yɛ, “Fanɛ kpini fan kɔɔlɛ kɛ fan nuu lɩɩ kɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kɩnɩmʋ ɩ gyɛ mɛ nkalan mʋ nɩɩ ki ŋmina Ɩbwaarɛ katɔwɛ kyula pʋpwɛ mʋ, nɩɩ ɩ kyɛɛgɛ wʋrɩgɛ sa asa gaalaagaa alibi kɩtaa kɛɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N tɔwɛ fanɛ nɩn yɛ, n man bɩla yɛ n nuu falɛ nta nɩmʋ naa fʋʋ kakɛ mʋ nɩɩ n maa fanɛ an biti a nuu nta pʋpwɛ mɛ‐Sɛ kuwura‐gyii mʋ tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nɩɩ ba maa bɩɩ ɔlʋn lʋwɛ mʋ, ba kʋsʋ kyʋn olifu kɩbɩɩ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Kagyanbwɛ nɩmʋ fanɛ kpini fen biti fan sɩlɛ yɛgɛ mɛ, fɛɛ kanan mʋ nɩɩ ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘N biti n mɔɔ nbʋlʋpʋ ɔkpapʋ mʋ, kɛ nbʋlʋpʋ mʋ ba yaasɛ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amaa nɩɩ n kyiŋi lɩɩ lewu tɔ mʋ, n biti n gyankpaa fanɛ kpee Galile.” ");
INSERT INTO naw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nɩɩ Pita tɔwɛ mʋ yɛ, “Halɩɩ nɩɩ ɔkʋmaa nɩmʋ sɩlɛ yɛgɛ fʋ gbaa, mɛɛ mɛ n mɛɛ yɛ n sɩlɛ yɛgɛ fʋ.” ");
INSERT INTO naw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nɩɩ Yesu lɛɛ mʋ kɔnɔ yɛ, “N tɔwɛ fʋ kesintin yɛ, kagyanbwɛ nɩmʋ pɔyɩ kɛ kyaasɛ ɔ bʋn mʋ, fii biti fu kina mɛ ɩlɩɩ ɩsa.” ");
INSERT INTO naw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nɩɩ Pita lɛɛ mʋ kɔnɔ yɛ, “Halɩɩ bee biti ba mɔɔ n maa fʋ gbaa n mɛɛ yɛ n tɔwɛ kanɩn kpini‐kpini.” Nɩɩ abɩɩlapʋ abanban mʋ gbaa ba tɔwɛ kanɩn. ");
INSERT INTO naw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nɩɩ Yesu maa mʋ abɩɩlapʋ mʋ ba kpee katɩn mʋ nɩɩ bɛɛ tɩɩ yɛ Gesemani, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan kyɩna nfɩɩ kɛ n kpee falɛ naa kʋlɛ kabwaarɛ‐kʋlɛ.” ");
INSERT INTO naw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nɩɩ ɔ taa Pita maa Sebedi mu‐bii ana anyɔ buu mʋ n‐yɩɩ kpee. Tʋtɔ nɩɩ mʋ kɔkɔlɔ nyita mʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Mɛ kɔkɔlɔ tɔ ɩɩ kɔ mɛ lewu‐lewu, halɩɩ ii biti ɩ mɔɔ mɛ. Ɩmʋ sʋ fan kyɩna nfɩɩ tii mɛ sʋ kɛ fan man dɛ.” ");
INSERT INTO naw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tʋtɔ nɩɩ o nin kpee ansi tɔ gbɛrɛɛ naa kyʋn bun ɛɛ kʋlɛ kabwaarɛ‐kʋlɛ yɛ, “Mɛ‐Sɛ, nɩɩ ii biti ɩ waa mʋ, lɛɛ awʋrʋfɔ mʋ nɩɩ ɩɩ ba mɛ sʋ falɛ lɩɩ mɛ sʋ. Amaa yɛgɛ ɩ waa fu kebiti, man gyɛ mi kebiti.” ");
INSERT INTO naw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nɩɩ o bwii ba abɩɩlapʋ asa mʋ asɛ ba tu ba maa dɛ nsɩɩrɛ, nɩɩ ɔ taasɛ Pita yɛ, “Amɔɔ fɛn mɛɛ taalɛ kyɩna yɛ mɛ kerefi kʋlʋn yɛgɛ fan man dɛ? ");
INSERT INTO naw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Fan kyɩna fan man dɛ, yɛgɛ fan kʋlɛ kabwaarɛ‐kʋlɛ, kɛ fan man tɩyɛ kʋtʋʋ tɔ kɩɩ tɔ. Fanɛ n‐yaayu ii biti ɩ waa kʋtɔ mʋ nɩɩ kɩ bʋrɔn, amaa fanɛ n‐yɩɩ‐wʋlɛ pɔɔ.” ");
INSERT INTO naw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu bɩla bwii kpee ɩlɩɩ nyɔsapʋ naa kʋlɛ kabwaarɛ‐kʋlɛ yɛ, “Mɛ‐Sɛ, nɩɩ ɩ mɛɛ yɛ ɩ waa fʋ fɛɛ fʋ lɛɛ falɛ awʋrʋfɔ kɔɔpʋ nɩmʋ lɩɩ mɛ sʋ, nɩɩ ɩ dagaa fɛɛ n gyii awʋrʋfɔ maa mʋ, yɛgɛ fu kebiti kɩ waa kanɩn.” ");
INSERT INTO naw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Maa bɩla bwii ba abɩɩlapʋ asa mʋ asɛ mʋ, o be tu bamʋ ba maa dɛ nsɩɩrɛ. Lɩɩ fɛɛ ba man taalɛ galɛ nsɩɩrɛ. ");
INSERT INTO naw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nɩɩ Yesu bɩla yɛgɛ bamʋ nɩɩ o kpee naa kʋlɛ kabwaarɛ‐kʋlɛ kɩsasapʋ ɛɛ tɔwɛ asɩn kʋlʋn maŋa. ");
INSERT INTO naw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nɩɩ o bwii ba mʋ abɩɩlapʋ asɛ ba taasɛ bamʋ yɛ, “Fan san fan dɛ fɛn fʋʋtɛ nɩn? Fan kɩɩ, saŋa mʋ fʋʋ fɛɛ ba taa mɛ, Daadimaadi Obii‐nyɩnsa mʋ waa alibi awaapʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fan kʋsʋ kɛ a kpee. Fan kɩɩ ɔmʋ nɩɩ ee biti ɔ lɛɛ mɛ sa mʋ tiri tɔ.” ");
INSERT INTO naw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Maa san ɛɛ tɔwɛ mʋ, nɩɩ mʋ abɩɩlapʋ kudu anyɔ mʋ tɔ, ɔmʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gyudasi mʋ ba tʋtɔ. Asa damantɛ akʋ ba buu mʋ, yɛgɛ ba sʋ isakunde yɛ agulungu. Aseepu bɩlɩsa yɛ asa mʋ abɩlɩsa i sun bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gyudasi mʋ nɩɩ ee biti ɔ lɛɛ Yesu sa mʋ, wʋla tɔwɛ bamʋ yɛ, “Ɔnyɩn mʋ nɩɩ n dan naa baari mʋ tɔ mʋ, mʋ nɩmʋ, fan kɩtaa mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ba maa fʋʋ tʋtɔ mʋ, nɩɩ opula tɔ Gyudasi kpee Yesu asɛ nɩɩ ɔ yɛ, “Ɔkaapʋpʋ, n fwaala fʋ.” Nɩɩ o baari Yesu tɔ. ");
INSERT INTO naw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nɩɩ Yesu lɛɛ mʋ kɔnɔ yɛ, “Kyɛmɩnɛ, waa kʋtɔ mʋ nɩɩ fʋ ba kɩmʋ sʋ mʋ.” Tʋtɔ nɩɩ asa mʋ ba kyʋn naa kɩtaa Yesu tɔ kinkin. ");
INSERT INTO naw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tʋtɔ mʋ, asa mʋ nɩɩ ba bʋ Yesu asɛ mʋ ɔkʋ bɩɩtɛ mʋ sakunde lɛɛ, nɩɩ ɔ ŋɛ oseepu bɩlɩsa asɛ mʋ kɩyaafɔlɛ kʋsʋ tɩn. ");
INSERT INTO naw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Bwiiyaa fʋ sakunde mʋ waa kɩmʋ kikufe tɔ. Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɛɛ kɩtaa sakunde ɛɛ kɔ mʋ, sakunde lewu nɩɩ ee biti o wu. ");
INSERT INTO naw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fʋ man nyi fɛɛ n taalɛ tɩɩ mɛ‐Sɛ, kɛ ɔ yɛgɛ sʋsʋ nbɔɔ ngbɩn‐ngbɩn kudu anyɔ ba ba opula nɩmʋ tɔ ba kyɛ mɛ tɔ abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amaa nɩɩ ɩ kan waa kanɩn mʋ, nɛnɛ nɩɩ asɩn mʋ nɩɩ ba kyʋrɔɔ waa Asɩnkyan yɩlɛsa mʋ tɔ yɛ ɩ dagaa ɩ maa waa mʋ, ɩ ba tɔ?” ");
INSERT INTO naw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tʋtɔ nɩɩ Yesu taasɛ sakyɔ mʋ yɛ, “Fan taa isakunde yɛ agulungu fan ba kɩtaa mɛ fɛɛ ɔsa mʋ nɩɩ ɛɛ kʋsʋ yɩlɛ kɩbanɛ sʋ. Kakɛ kʋmaa n kyɩna kabwaarɛ‐sunkpa ayɛ tɔ n kaapʋ, fan man kɩtaa mɛ. ");
INSERT INTO naw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amaa ɩnɩmʋ kpini ɩ waa nɩn kɛ asɩn mʋ nɩɩ Ɩbwaarɛ atɔwɛpʋ ba kyʋrɔɔ yɩla mʋ ɩ nyɛ ba ɩmʋ tɔ.” Tʋtɔ nɩɩ mʋ abɩɩlapʋ mʋ kpini ba sɩlɛ yɛgɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bamʋ nɩɩ ba kɩtaa Yesu mʋ ba taa mʋ kpee Kefasi, oseepu bɩlɩsa asɛ mʋ kɩkpaara sʋ, katɩn mʋ nɩɩ nbara akaapʋpʋ yɛ asa mʋ abɩlɩsa ba gyaŋɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Amaa Pita buu bamʋ kɩyaa‐kɩyaa, halɩɩ ba naa fʋʋ oseepu bɩlɩsa asɛ mʋ kɩkpaara sʋ. Nɩɩ Pita sii kyɩna kɩkpaara mʋ akɩɩsʋpʋ mʋ asɛ, kɛ o wu kanan mʋ nɩɩ ii biti ɩ naa lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aseepu bɩlɩsa yɛ Gyiwu abi abɩlɩsa amu‐amu ngyaŋɛ mʋ kpini ba tɔwɛ kɔnɔ waa Yesu bee biti antɩŋɛsa ba tɩn gyaga mʋ sʋ, kɛ ba nyɛ ɔkpa mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Antɩŋɛsa adansɛ agyipu gaalaagaa ba ba tɔwɛ, amaa ba man nyɛ asɩn mʋ nɩɩ ba taa gyaga mʋ sʋ. Kamaa tɔ mʋ, nɩɩ anyɩn anyɔ akʋ ba lɩɩ ba yɩlɛ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ɔnyɩn nɩmʋ tɔwɛ yɛ, ‘N taalɛ boyi kabwaarɛ‐sunkpa ayɛ nɩmʋ, kɛ n taa nkɛ nsa bwii pɔyɩ kɩmʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nɩɩ Oseepu bɩlɩsa asɛ mʋ kʋsʋ yɩlɛ nɩɩ ɔ taasɛ Yesu yɛ, “Fʋ mɛɛ yɛ fʋ lɛɛ kɔnɔ lɩɩ asɩn mʋ nɩɩ anyɩn nɩmʋ ba sʋ bɛɛ gyaga fʋ sʋ falɛ?” ");
INSERT INTO naw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amaa Yesu man tɔwɛ sɛhn. Nɩɩ Oseepu bɩlɩsa asɛ mʋ bwii tɔwɛ mʋ yɛ, “N bɔ Ɩbwaarɛ mʋ nɩɩ ɔ tɛ kakpaa mʋ ntan yɛ tɔwɛ anɛ. Fʋ ɩ gyɛ Krisito, Ɩbwaarɛ mu‐bii mʋ?” ");
INSERT INTO naw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɩmʋ nɩɩ fʋ tɔwɛ mʋ. Amaa n tɔwɛ fanɛ nɩn yɛ, lɩɩ ndaga ɩ sʋ ii kpee mʋ, fen biti fan wu mɛ, Daadimaadi Obii‐nyɩnsa mʋ n maa tɛ Ɔlʋnpʋ Owura lala mʋ gyisa sʋ, nɩɩ fen biti fan bɩla wu maa lɩɩ abwaarɛ‐wʋlɛ tɔ sʋsʋ n ba.” ");
INSERT INTO naw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nɩɩ Oseepu bɩlɩsa asɛ mʋ kɩtaa mʋ kaalɛ kyatɛ nɩɩ ɔ tɔwɛ mʋ yɛ, “Nbusaa asɩn! A man bɩla an biti adansɛ kʋ. Fan nu nbusaa asɩn mʋ nɩɩ ɔ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nɛnɛ nɩɩ fɛn fɛ kɩmʋ nfɛɛrɛ?” Nɩɩ asa mʋ ba lɛɛ kɔnɔ yɛ, “Ɩ dagaa maa wu?” ");
INSERT INTO naw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nɩɩ ba tʋʋ nkyɔlɛ waa mu ansi tɔ nɩɩ ba dayɩ mʋ, nɩɩ akʋ mɔɔ ba kpa mʋ ɩtan. ");
INSERT INTO naw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nɩɩ ba tɔwɛ mʋ yɛ, “Krisito, nɩɩ fʋ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ mʋ, bɩɩ tɔwɛ anɛ, ɔsa mʋ nɩɩ ɔ da fʋ falɛ?” ");
INSERT INTO naw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita maa tɛ kɩkpaara mʋ, nɩɩ oseepu bɩlɩsa asɛ mʋ kibite kʋ tɔwɛ mʋ yɛ, “Ngbaa fʋ, fu tii Yesu, Kagalile‐nyɩn nɩmʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amaa Pita kyɛɛ bamʋ kpini ansi tɔ yɛ, “Asɩn mʋ nɩɩ fɩɩ tɔwɛ falɛ, n man nyi ɩmʋ sʋ gbaa kpini‐kpini.” ");
INSERT INTO naw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Maa lɩɩ kpee kewusunɔ mʋ, nɩɩ kibite kʋ mɔɔ bɩla wu mʋ, nɩɩ ɔ tɔwɛ asa mʋ nɩɩ ba yɩlɛ tʋtɔ mʋ yɛ, “Ɔnyɩn nɩmʋ daa o tii Yesu Kanasareti‐nyɩn mʋ sʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nɩɩ Pita bɔ ntan kyɛɛ yɛ, “N man nyi ɔnyɩn maŋa gbaa kpini‐kpini.” ");
INSERT INTO naw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɩ maa waa gbɛrɛɛ mʋ, nɩɩ anyɩn mʋ nɩɩ ba yɩlɛ tʋtɔ mʋ ba tɔwɛ Pita yɛ, “Kesintin tɔ mʋ, fʋ gyɛ mʋ abɩɩlapʋ mʋ tɔ ɔkʋ, lɩɩ fɛɛ fʋ katɔwɛ tɔ ɩɩ kaapʋ kanɩn.” ");
INSERT INTO naw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tʋtɔ nɩɩ Pita tɔwɛ nnɔ gyaga mʋ n‐yɩɩ sʋ, nɩɩ ɔ bɔ ntan tɔwɛ yɛ, “N man nyi ɔnyɩn maa kpini‐kpini.” Opula maŋa tɔ nɩɩ kyaasɛ bʋn. ");
INSERT INTO naw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nɩɩ Pita nyiŋi asɩn mʋ nɩɩ Yesu daa tɔwɛ mʋ mʋ, fɛɛ “Pɔyɩ kɛ kyaasɛ ɔ bʋn mʋ, fii biti fu kina mɛ ɩlɩɩ ɩsa.” Nɩɩ Pita lɩɩ ɩkaa sʋ naa su gaa. ");
INSERT INTO naw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kayɩ maa kɛ nyenyenfuu mʋ, Ɩbwaarɛ aseepu abɩlɩsa mʋ kpini yɛ asa mʋ abɩlɩsa mʋ ba bʋga ŋmina yɛ ba mɔɔ Yesu. ");
INSERT INTO naw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba ŋmina mʋ, nɩɩ ba taa mʋ kyʋn, nɩɩ ba taa mʋ waa ɔsʋwʋlɛ ɔkɩɩsʋpʋ Paleti abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gyudasi mʋ nɩɩ ɔ lɛɛ mʋ sa mʋ, maa wu fɛɛ ba bun Yesu lewu kʋpwɛ mʋ, nɩɩ o nu mʋ n‐yɩɩ, nɩɩ o bwiiyaa gbiti nderebi adɩsa mʋ naa sa Ɩbwaarɛ aseepu abɩlɩsa yɛ kadɛ abɩlɩsa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “N waa alibi fɛɛ n maa lɛɛ ɔmʋnɩ ɔ man waa alibi akʋ mʋ sa fanɛ.” Nɩɩ ba tɔwɛ yɛ, “Ɩnɩmʋ ɩ man gyɛ anɛ asɩn. Fʋ nkʋn asɩn nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ɩmʋ sʋ Gyudasi funti afulee mʋ waa kabwaarɛ‐sunkpa ayɛ mʋ, nɩɩ ɔ kyʋn. Nɩɩ ɔ naa kyaga mʋ n‐yɩɩ ɔfɛ. ");
INSERT INTO naw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ɩbwaarɛ aseepu abɩlɩsa mʋ ba tasɛ nderebi mʋ, nɩɩ ba tɔwɛ yɛ, “Nbara mʋ ɩ mɛɛ sa ɔkpa fɛɛ a taa afulee nɩmʋ bʋga yɛ kabwaarɛ‐sunkpa ayɛ afulee mʋ tɔ. Lɩɩ fɛɛ ɩ gyɛ nkalan afulee nɩn.” ");
INSERT INTO naw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ɩmʋ sʋ ba tɔwɛ kyula abaa nɩɩ ba taa afulee maŋa naa sɔɔ nlobi apɔyɩpʋ kʋ kasɛ, kɛ ba baa bee pula afɔ‐kyilim tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanɩn sʋ nɩɩ bɛɛ tɩɩ tʋtɔ yɛ, Nkalan kasɛ ba lɩɩ halɩɩ ndaga. ");
INSERT INTO naw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ɩmʋ asɩn mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Gyeremiya tɔwɛ mʋ ba tɔ. Ɩmʋ ɩ gyɛ yɛ, “Ɩsɩrayɩ abi ba taa gbiti nderebi adɩsa mʋ, ɩmʋ ɩ gyɛ afulee mʋ nɩɩ ba tɔwɛ kyula yɛ ba taa sɔɔ mʋ mʋ, kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nɩɩ ba taa ɩmʋ sɔɔ nlobi apɔyɩpʋ kʋ kasɛ fɛɛ kanan mʋ nɩɩ Ɔnyɩrɩpɛ mʋ sa kɔnɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Saŋa maŋa yɛgɛ Yesu yɩlɛ ɔsʋwʋlɛ ɔkɩɩsʋpʋ Paleti ansi tɔ, nɩɩ ɔ taasɛ mʋ yɛ, “Fʋ ɩ gyɛ Gyiwu abi owura lala mʋ?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɛɛhn, fɛɛ kanan mʋ nɩɩ fʋ tɔwɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amaa saŋa mʋ nɩɩ Ɩbwaarɛ aseepu abɩlɩsa yɛ kadɛ mʋ abɩlɩsa bɛɛ pwɩɩ mʋ mʋ, ɔ man lɛɛ kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nɩɩ Paleti taasɛ yɛ, “Fʋ man nu asɩn pwɩɩsa mʋ nɩɩ ba sʋ bɛɛ pwɩɩ fʋ mʋ?” ");
INSERT INTO naw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amaa Yesu man lɛɛ kɔnɔ lɩɩ asɩn mʋ nɩɩ bɛɛ sʋ bɛɛ pwɩɩ mʋ mʋ tɔ kʋkʋlʋn gbaa. Nɩɩ i kyinkyin Paleti gaa. ");
INSERT INTO naw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nɩɩ ɩ wʋla ɩ dɛ fɛɛ, kesu kɔnɔ kanyaŋɛ nbunɔ kensi‐gyii kʋmaa nɩmʋ tɔ mʋ, Roma abi ɔkɩɩsʋpʋ mʋ, ɩɩ lɛɛ bamʋ nɩɩ ba tii bamʋ obu mʋ tɔ ɔkʋlʋn mʋ nɩɩ sakyɔ mʋ ii biti mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kanɩn saŋa maŋa mʋ, kumu tɔ ɔlʋn wuya kʋ kyɩna o tii obu nɩɩ bɛɛ tɩɩ mʋ yɛ Barabasi. ");
INSERT INTO naw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ɩmʋ sʋ sakyɔ mʋ ba maa gyaŋɛ mʋ, Paleti taasɛ bamʋ yɛ, “Anɩmʋ nɩɩ fen biti n lɛɛ sa fanɛ? Barabasi, abɛɛ Yesu mʋ nɩɩ bɛɛ tɩɩ mʋ Krisito mʋ?” ");
INSERT INTO naw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Lɩɩ fɛɛ o nyi ɩ maa gyɛ kayɩɩ basa sʋ, nɩɩ ba taa Yesu waa mʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paleti maa san ɔ tɛ asɩn kigyii kagya sʋ mʋ, mʋ‐ka sun ba tɔwɛ mʋ yɛ, “Man waa ɔnyɩn nɩmʋ, mʋ nɩɩ ɔ man waa alibi akʋ kʋtɔ kʋ, lɩɩ fɛɛ n wu awʋrʋfɔ mɛ idee tɔ ndaga gaa lɩɩ mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amaa Ɩbwaarɛ aseepu bɩlɩsa yɛ kadɛ abɩlɩsa mʋ ba tɔwɛ waa sakyɔ mʋ yɛ, ba kʋlɛ yɛ bee biti Barabasi, kɛ ɔ yɛgɛ ba mɔɔ Yesu. ");
INSERT INTO naw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nɩɩ Ɔsʋwʋlɛ ɔkɩɩsʋpʋ taasɛ bamʋ yɛ, “Bamʋ anyɔ nɩmʋ tɔ mʋ, ɔmɔɔ nɩɩ fen biti fɛɛ n lɛɛ mʋ sa fanɛ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Barabasi.” ");
INSERT INTO naw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nɩɩ Paleti taasɛ bamʋ yɛ, “Mɩnɛ nɩɩ n waa Yesu mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Krisito mʋ?” Nɩɩ bamʋ kpini ba lɛɛ kɔnɔ yɛ, “Da mʋ mata oyu laasa sʋ.” ");
INSERT INTO naw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nɩɩ ɔ bɩla taasɛ bamʋ yɛ, “Mɩnɛ sʋ? Mɩnɛ alibi nɩɩ ɔ waa?” Amaa ba lɔŋɔ kuusi kenken tii sʋ yɛ, “Da mʋ mata oyu laasa sʋ!” ");
INSERT INTO naw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paleti maa wu fɛɛ ɔ mɛɛ bɩla taalɛ waa asɩn mʋ sɛhn mʋ, yɛgɛ ɩ sʋ sʋgʋrɛ‐sʋgʋrɛ ɩɩ ba mʋ, ɔ taa nkyu fwɩɩ mʋ abaa sakyɔ mu ansi tɔ, nɩɩ ɔ tɔwɛ yɛ, “Mɛ abaa ɩ man tii kanyɩn nɩmʋ lewu sʋ, ɩ gyɛ fanɛ asɩn nɩn!” ");
INSERT INTO naw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Asa mʋ kpini ba lɛɛ kɔnɔ yɛ, “Yɛgɛ mu lewu kʋsʋ bɩɩtɛ ɩ baa ɩ gyan anɛ yɛ anɛ‐bii ana sʋ!” ");
INSERT INTO naw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nɩɩ ɔ taa Barabasi sa bamʋ. Amaa ɔ yɛgɛ nɩɩ ba tɩŋɛ Yesu awulibi, nɩɩ ɔ taa mʋ sa yɛ ba naa da mʋ mata oyu laasa sʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tʋtɔ nɩɩ ɔkɩɩsʋpʋ mʋ anaakɔpʋ ba taa Yesu loo bamʋ opula, nɩɩ ba tɩɩ anaakɔpʋ mʋ kpini ba kyaabɔɔ Yesu. ");
INSERT INTO naw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba bugi mʋ kaalɛ mʋ, nɩɩ ba taa kaalɛ pɩpɛɛ bʋnswɩɩsa kʋ ba bun mʋ, ");
INSERT INTO naw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","nɩɩ ba taa iwii bɔɔ fɛɛ kuwura‐wʋrʋ gyaga mu kumu sʋ, nɩɩ ba taa owura kikpebi waa mʋ gyisa kɩbaa tɔ, nɩɩ ba muŋa mu ansi tɔ nɩɩ ba ŋmasɛ mʋ tɔwɛ yɛ, “Gyiwu abi Owura! An muŋa fʋ” ");
INSERT INTO naw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba tʋʋ nkyɔlɛ wʋrɩgɛ mʋ sʋ, nɩɩ ba kɔɔlɛ owura kikpebi mʋ da mu kumu tɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ba maa ŋmasɛ mʋ lʋwɛ mʋ, ba bugi kaalɛ pɩpɛɛ mʋ, nɩɩ ba bwii taa mʋ atɔ bunsa mʋ bun mʋ. Nɩɩ ba taa mʋ bee kpee ba naa da mʋ mata oyu laasa sʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ba maa naa bee kpee mʋ, ba gyaŋa Simon Kesirene‐nyɩn, nɩɩ ba nyan mʋ yɛ ɔ sʋla Yesu oyu laasa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba ba fʋʋ opula mʋ nɩɩ bɛɛ tɩɩ yɛ Goligota (kɩmʋ kasɛ ɩ gyɛ yɛ kumu kawɛ opula). ");
INSERT INTO naw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tʋtɔ nɩɩ ba sa Yesu nta mʋ nɩɩ ba taa kɩfɛ bʋlɩlɩsa kʋ kyagɩlɛ tɔ, maa daa kɩɩ mʋ, nɩɩ o kina kinuu. ");
INSERT INTO naw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba maa da mʋ mata oyu laasa sʋ lʋwɛ mʋ, ba tʋʋ nbii barɩgɛ mʋ atɔ bunsa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nɩɩ ba kyʋn kyɩna bee kun mʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ba kyʋrɔɔ asɩn mʋ nɩɩ ba taa bun mʋ kʋpwɛ mʋ gyaga mu amu sʋ yɛ, ƆNƖMƲ Ɩ GYƐ YESU, GYIWU ABI OWURA MƲ. ");
INSERT INTO naw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba da bamʋ nɩɩ bee yuuri ɔlʋn sʋ anyɔ akʋ iyu laasa sʋ tii mʋ sʋ. Ɔkʋ bʋ mʋ gyisa sʋ nɩɩ ɔkʋ mɔɔ bʋ mʋ bɩna sʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Asa mʋ nɩɩ bɛɛ kyʋn mʋ, bɛɛ sʋ asebi bɛɛ wʋrɩgɛ mʋ sʋ yɛgɛ bee fi‐fi bamʋ amu, ");
INSERT INTO naw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yɛgɛ bɛɛ tɔwɛ yɛ, “Fʋ mʋ nɩɩ fʋ tɔwɛ yɛ fii biti fʋ boyi kabwaarɛ‐sunkpa ayɛ, kɛ fʋ pɔyɩ kɩmʋ nkɛ nsa mʋ, mɔlɩgɛ fʋ n‐yɩɩ! Nɩɩ fʋ ɩ gyɛ Ɩbwaarɛ mu‐Bii‐nyɩnsa mʋ, kpɩlɩgɛ lɩɩ oyu laasa mʋ sʋ!” ");
INSERT INTO naw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kanɩn maŋa nɩɩ Ɩbwaarɛ aseepu abɩlɩsa yɛ nbara akaapʋpʋ yɛ abɩlɩsa mʋ ba ŋmasɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ba tɔwɛ yɛ, “Ɔ mɔlɩgɛ akʋ, amaa ɔ mɛɛ taalɛ mɔlɩgɛ mʋ n‐yɩɩ. Mʋ ɩ gyɛ Ɩsɩrayɩ owura! Fan yɛgɛ ɔ kpɩlɩgɛ lɩɩ oyu laasa mʋ sʋ ba nbɩɩnbɩɩ, kɛ a kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɔ taa mʋ n‐yɩɩ tʋʋ Ɩbwaarɛ sʋ, nɩɩ ɔ tɔwɛ yɛ mʋ ɩ gyɛ Ɩbwaarɛ mu‐Bii mʋ. Fan yɛgɛ a kɩɩ fɛɛ Ɩbwaarɛ ii biti ɔ mɔlɩgɛ mʋ nbɩɩnbɩɩ nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ɔkpa kʋlʋn maŋa sʋ nɩɩ bamʋ nɩɩ bee yuuri ɔlʋn sʋ, mʋ nɩɩ ba da bamʋ mata iyu laasa yɛ mʋ mʋ, gbaa ba taa asebi wʋrɩgɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lɩɩ kyɔwɛ amu nsana naa fʋʋ kalaatɩpwɛ kerefi asa tɔ mʋ, kitentenbiri bun ɔsʋwʋlɛ sʋ kpini. ");
INSERT INTO naw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nɩɩ kerefi asa maŋa tɔ mʋ, Yesu kuusi kenken yɛ, “Eli, Eli lamaa sabatani?” Ɩmʋ kasɛ ɩ gyɛ yɛ, “Mɛ‐Sɛ, mɛ‐Sɛ, mɩnɛ ɩ waa nɩɩ fu kina mɛ?” ");
INSERT INTO naw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Asa mʋ nɩɩ ba yɩlɛ tʋtɔ mʋ, ba maa nu asɩn mʋ, nɩɩ akʋ ba yɛ, “Ɛɛ tɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Eligya.” ");
INSERT INTO naw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Opula maŋa tɔ nɩɩ bamʋ tɔ ɔkʋ sɩlɛ naa taa ɔkyɛɛ dufudufu taa naa nyɔ nta nyaŋɛsa kʋ tɔ, nɩɩ ɔ taa ŋmina oyu sʋ, nɩɩ ɔ kʋsaa naa tii Yesu kɔnɔ yɛ o nuu. ");
INSERT INTO naw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Asansa mʋ ba yɛ, “Nbɩɩnbɩɩ fan yɛgɛ mʋ, kɛ a kɩɩ fɛɛ Eligya ee biti ɔ ba mɔlɩgɛ mʋ abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu maa bɩla kuusi kenken mʋ, ɔ tɩn ɔŋɛɛ. ");
INSERT INTO naw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kanɩn saŋa maŋa kɩtaa kunsa mʋ nɩɩ kɩ barɩgɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ mʋ, kyatɛ tɔ anyɔ lɩɩ sʋsʋ ba yii kasɛ. Nɩɩ kasɛ gyingyen, nɩɩ afʋlɛ ɩ baaŋɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nkyan i bugi‐bugi tɔ, nɩɩ Ɩbwaarɛ asa mʋ nɩɩ ba wu mʋ, gaalaagaa ba kyiŋi ba nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Saŋa mʋ nɩɩ Yesu kyiŋi lɩɩ lewu tɔ mʋ, Ɩbwaarɛ asa mʋ nɩɩ ba kyiŋi lɩɩ lewu tɔ mʋ, ba tii Yesu sʋ kpee kadɛ kyɩrɛkyɩrɛ mʋ tɔ, nɩɩ asa gaalaagaa ba wu bamʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Anaakɔpʋ kɩlɩfa ɔbɩlɩsa yɛ bamʋ nɩɩ ba bʋ mʋ asɛ bee kun Yesu mʋ, ba maa wu kasɛ maa gyingyen, yɛ ɩmʋ nɩɩ ɩ waa maŋa kpini mʋ, kufuu kɩ kɩtaa bamʋ gaa, nɩɩ ba tɔwɛ yɛ, “Kesintin tɔ, ɔ kyɩna ɔ gyɛ Ɩbwaarɛ mu‐Bii nɩn!” ");
INSERT INTO naw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Akyɩɩ gaalaagaa ba bʋ tʋtɔ ba yɩlɛ kata‐kata bɛɛ kɩɩ. Bamʋ ɩ kyɩna ba gyɛ akyɩɩ mʋ nɩɩ ba buu Yesu lɩɩ Galile nɩɩ ba kyɛ mʋ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bamʋ tɔ akʋ ɩ gyɛ Mɛɛrɩ Magidalen mʋ, yɛ Gyemisi maa Gyosefu bamʋ‐nyi Mɛɛrɩ, yɛ Sebedi mu‐bii ana bamʋ nyi. ");
INSERT INTO naw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ɩ maa fʋʋ kalaatɩpwɛ sʋ mʋ, atɔ wuya kʋ mʋ nɩɩ ɔ lɩɩ Arimatiya kadɛ tɔ, nɩɩ bɛɛ tɩɩ mʋ yɛ Gyosefu, nɩɩ mʋ gbaa mʋ gyɛ Yesu ɔbɩɩlapʋ mʋ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O kpee Paleti asɛ naa kʋlɛ Yesu kubuni, nɩɩ Paleti sa kɔnɔ yɛ ba taa sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Gyosefu taa kibuni mʋ, nɩɩ ɔ taa kɩkalala pʋpwɛ maalɛ mʋ, ");
INSERT INTO naw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nɩɩ ɔ taa mʋ pula mʋ gbaa‐gbaa mʋ kakyan pʋpwɛ mʋ nɩɩ ɔ ŋɛ kɩfʋlɛ waa ɔbɔ yɩla mʋ tɔ. Nɩɩ o gbiliti kubuu lala kʋ tii kakyan mʋ kɔnɔ nɩɩ ɔ natɛ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mɛɛrɩ Magidalen maa Mɛɛrɩ banban mʋ, be sii bɛ tɛ, yɛgɛ bamʋ ansi ɩ kaapʋ kakyan mʋ. ");
INSERT INTO naw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ɩmʋ lɩɩkaakɛ maa gyɛ Kakɛ fʋʋtɛsa akɛ mʋ, aseepu bɩlɩsa yɛ Farasii abi mʋ ba kpee Paleti asɛ naa tɔwɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ɔbɩlɩsa! An nyiŋi fɛɛ saŋa mʋ nɩɩ ɔpɩnapʋ mʋ tɛ nkpa tɔ mʋ, ɔ tɔwɛ yɛ, ‘Nkɛ nsa kamaa mʋ, n biti n kyiŋi lɩɩ lewu tɔ ba nkpa tɔ.’ ");
INSERT INTO naw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ɩmʋ sʋ wʋla sa kɔnɔ kɛ asa ba naa kyɩna kun mʋ kakyan mʋ naa fʋʋ kakɛ sasapʋ mʋ. Nɩɩ man gyɛ kanɩn mʋ abɩɩlapʋ mʋ bee biti ba be yuuri mu kibuni mʋ, kɛ ba tɔwɛ asa yɛ o kyiŋi lɩɩ lewu tɔ. Nɩɩ ɩ kan ba kanɩn mʋ, mʋ npɩna mʋ ii biti ɩ ŋara ɩmʋ nɩɩ ɔ wʋla pɩna falɛ.” ");
INSERT INTO naw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nɩɩ Paleti lɛɛ kɔnɔ yɛ, “Fan taa anaakɔpʋ, kɛ ba naa yɩlɛ kun kakyan mʋ kanan mʋ nɩɩ fen nyi fɛɛ fɛn taalɛ waa mʋ.” ");
INSERT INTO naw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɩmʋ sʋ ba kpee kakyan mʋ asɛ naa waa kʋtɔ kʋ tarɩ kubuu mʋ, nɩɩ ba lɛɛ akɩɩsʋpʋ yɩla yɛ ba kun kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kakɛ fʋʋtɛsa akɛ kamaa tɔ, ɩmʋ Kwasida akɛ nyenyenfuu mʋ, Mɛɛrɩ Magidalen maa Mɛɛrɩ banban mʋ, ba kpee naa kɩɩ kakyan mʋ. ");
INSERT INTO naw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Opula maŋa tɔ nɩɩ kasɛ ki gyingyen gaa. Lɩɩ fɛɛ Ɩbwaarɛ kabɔɔ kpɩlɩgɛ lɩɩ sʋsʋ ba gbiliti kubuu mʋ nɩɩ ki tii kakyan mʋ kɔnɔ mʋ, nɩɩ ɔ kyʋn kyɩna kɩmʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ɩbwaarɛ kabɔɔ mʋ ɩɩ ŋalɩgɛ sʋ fɛɛ bʋlayɩ maa wɛɛ ɩsɛɛ, nɩɩ mʋ atɔ bunsa mɔɔ ii fuuli parɛparɛ fɛɛ ateebi. ");
INSERT INTO naw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nɩɩ bamʋ nɩɩ bee kun kakyan mʋ, ba maa wu kabɔɔ mʋ, kufuu kɩ kɩtaa bamʋ, nɩɩ ba kyɩkyaa tɩyɛ fɛɛ asa wusa mʋ. ");
INSERT INTO naw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nɩɩ kabɔɔ mʋ tɔwɛ akyɩɩ mʋ yɛ, “Fan man waa kufuu, lɩɩ fɛɛ n nyi fan maa kɩɩ fen biti Yesu mʋ nɩɩ ba da mʋ mata oyu laasa sʋ mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔ man bʋ nfɩɩ, o kyiŋi lɩɩ lewu tɔ, fɛɛ kanan mʋ nɩɩ ɔ wʋla tɔwɛ mʋ. Fan ba kɩɩ katɩn mʋ nɩɩ ba daa taa mʋ yɩla mʋ. ");
INSERT INTO naw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Fan bwii bilen naa tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, ‘O kyiŋi lɩɩ lewu tɔ ba nkpa tɔ, nɩɩ ɔ gyankpaa fanɛ ee kpee Galile ɔsʋwʋlɛ sʋ. Tʋtɔ nɩɩ fen biti fan wu mʋ.’ Fan nu, n tɔwɛ fanɛ nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɩmʋ sʋ akyɩɩ mʋ, ba kpala lɩɩ kakyan mʋ asɛ, ba sʋ kufuu, yɛgɛ bamʋ ansi i gyii. Nɩɩ ba sɩlɛ ba naa tɔwɛ Yesu abɩɩlapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Opula tɔ nɩɩ Yesu gyaŋa bamʋ ɔkpa tɔ, nɩɩ ɔ yɛ, “N fwaala fanɛ.” Nɩɩ ba nin tiri mʋ tɔ, kɩtaa mʋ ayaa tɔ muŋa sun mʋ. ");
INSERT INTO naw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan man waa kufuu! Fan kpee naa tɔwɛ mɛ bɩrɩsa ana yɛ ba kpee Galile ɔsʋwʋlɛ sʋ, tʋtɔ nɩɩ bee biti ba wu mɛ.” ");
INSERT INTO naw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Akyɩɩ mʋ ba maa san ba bʋ ɔkpa tɔ bee kpee mʋ, kakyan mʋ akunpu mʋ akʋ ba kpee Gyerusalem kadɛ tɔ naa buu sa aseepu abɩlɩsa kʋtɔ kʋmaa mʋ nɩɩ kɩ waa. ");
INSERT INTO naw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aseepu bɩlɩsa yɛ abɩlɩsa ba maa ba gyaŋɛ mʋ, ba ŋmina yɩla kʋtɔ mʋ nɩɩ ba waa. Ɩmʋ sʋ ba sa anaakɔpʋ akunpu mu afulee kʋkyɔ, ");
INSERT INTO naw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","lan tɔwɛ bamʋ yɛ, “Fan tɔwɛ yɛ, ‘Mʋ abɩɩlapʋ mʋ ɩ ba kagyanbwɛ ba yuuri Yesu kibuni mʋ taa kyʋn, saŋa mʋ nɩɩ an dɛ nsɩɩrɛ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nɩɩ falɛ asɩn nɩmʋ kan naa fʋʋ Ɔkɩɩsʋpʋ Paleti asɛ mʋ, anɛ ii biti a tɔwɛ yɩlɛ fanɛ kamaa, kɛ ɔ man waa fanɛ sɛhn.” ");
INSERT INTO naw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ɩmʋ sʋ anaakɔpʋ mʋ ba kɔɔlɛ afulee mʋ, nɩɩ ba waa fɛɛ kanan mʋ nɩɩ ba tɔwɛ bamʋ yɛ ba waa mʋ. Nɩɩ falɛ asɩn nɩmʋ ɩ yaasɛ loo Gyiwu abi mʋ tɔ ba lɩɩ halɩɩ ndaga. ");
INSERT INTO naw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nɩɩ abɩɩlapʋ kudu ɔkʋ mʋ ba kpee kɩbɩɩ mʋ nɩɩ kɩ bʋ Galile ɔsʋwʋlɛ sʋ, katɩn mʋ nɩɩ Yesu wʋla tɔwɛ bamʋ yɛ ba kpee mʋ. ");
INSERT INTO naw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ba maa wu Yesu mʋ, ba muŋa sun mʋ, nɩɩ bamʋ akʋ ba gyii ɩmɔɔrɛ yɛ man gyɛ mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nɩɩ Yesu nin tiri bamʋ, tɔwɛ yɛ, “Ɩbwaarɛ taa sʋsʋ yɛ kasɛ sʋ ɔlʋn kpini sa mɛ. ");
INSERT INTO naw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ɩmʋ sʋ fan kpee dulinyaa tɔ katɩn kʋmaa, naa waa asa kpini mɛ abɩɩlapʋ. Fan gyee bamʋ Ɩbwaarɛ kekyugyee, lɩɩ Ɔsɛ yɛ Obii yɛ Kayaayu Kyɩrɛkyɩrɛ kɩtɩɩ tɔ, ");
INSERT INTO naw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kɛ fan kaapʋ bamʋ kɛ ba buu kʋtɔ kʋmaa mʋ nɩɩ n sa fanɛ kɔnɔ yɛ fan waa mʋ. Fan nyiŋi fɛɛ n bʋ fanɛ asɛ saŋa kʋmaa naa fʋʋ dulinyaa laalaalʋwɛ.”");
INSERT INTO naw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Asɩn danbɩrasa lɩɩ Yesu Krisito, Ɩbwaarɛ Mu‐Bii mʋ sʋ mʋ ndee. ");
INSERT INTO naw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Asɩn danbɩrasa mʋ i piili fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Isaya wʋla kyʋrɔɔ yɩla mʋ. Ɔ kyʋrɔɔ asɩn mʋ nɩɩ Ɩbwaarɛ wʋla tɔwɛ Mu‐Bii Yesu Krisito mʋ yɛ, “Kɩɩ, n biti n sun mɛ kabɔɔ kɛ ɔ gyankpaa fʋ, mʋ ii biti ɔ ba lɔŋɔ fʋ ɔkpa mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Isaya bɩla kyʋrɔɔ lɩɩ Gyɔn sʋ yɛ, “Ɔnyɩn kʋ bʋ ofuli sʋ ee kuusi ɛɛ tɔwɛ yɛ, ‘Fan lɔŋɔ Ɔnyɩrɩpɛ ɔkpa mʋ, kɛ fan kyiigi mʋ ɩkpa‐bi mʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Asɩn mʋ ɩ ba kanɩn. Ɩmʋ ɩ gyɛ yɛ Gyɔn maa ba ɔ naa ofuli sʋ ee gyee asa Ɩbwaarɛ kekyugyee, yɛgɛ ɛɛ tɔwɛ Ɩbwaarɛ asɩn ɛɛ sa asa yɛ, “Fan yɛgɛ alibi kɩwaa, kɛ n gyee fanɛ Ɩbwaarɛ kekyugyee, kɛ Ɩbwaarɛ ɔ taa fanɛ alibi kɛɛ fanɛ.” ");
INSERT INTO naw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kesintin mɔɔ, asa gaalaagaa ba lɩɩ Gyudeya ɩsʋwʋlɛ sʋ yɛ Gyerusalem kadɛ lala mʋ tɔ bee kpee Gyɔn asɛ ofuli maŋa sʋ, bɛɛ tɔwɛ alibi mʋ nɩɩ ba waa, yɛgɛ Gyɔn i gyee bamʋ Ɩbwaarɛ kekyugyee Gyɔdan ɔbʋn mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nyɔɔma ifuu nɩɩ ba taa lʋʋ Gyɔn kaalɛ bunsa, nɩɩ atɔbwaaya ɔwʋlɛ mɔɔ nɩɩ ɔ kyaŋɛ waa mʋ kɩrɩsʋ. Mʋ agyitɔ gyisa mɔɔ ɩ gyɛ ntuntunbi yɛ ŋmasan. ");
INSERT INTO naw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Gyɔn ɩɩ tɔwɛ asa mʋ yɛ, “Ɔmʋ nɩɩ ɔ bʋ mɛ kamaa ɛɛ ba mʋ, kyɔ mɛ gaa, nɩɩ n man dagaa gbaa fɛɛ n muŋa lɛɛ mʋ asɩbɩta. ");
INSERT INTO naw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɛɛ mɛ, nkyu nɩɩ n sʋ n gyee fanɛ Ɩbwaarɛ kekyugyee, amaa mɛɛ mʋ bɩrɛ, ee biti ɔ taa Kayaayu Kyɩrɛkyɩrɛ mʋ ee gyee fanɛ.” ");
INSERT INTO naw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tʋtɔ mʋ, Yesu lɩɩ Nasareti kadɛ mʋ nɩɩ kɩ bʋ Galile kasɛ sʋ mʋ ba Gyɔn asɛ. Nɩɩ Gyɔn gyee mʋ Ɩbwaarɛ kekyugyee Gyɔdan ɔbʋn mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu maa dan lɩɩ ɔbʋn mʋ tɔ yɩlɛ mʋ, o wu sʋsʋ maa bugi tɔ, nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ kpɩlɩgɛ lɩɩ sʋsʋ fɛɛ kuwura‐lɔpɔ ba gyɔŋɔ Yesu sʋ. ");
INSERT INTO naw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nɩɩ ɔbʋlɛ tɔwɛ lɩɩ sʋsʋ yɛ, “Fʋ ɩ gyɛ mɛ kɔkɔlɔ tɔ obii bitisa. Nɩɩ fʋ ɩ bɔla mi ansi.” ");
INSERT INTO naw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Opula maŋa tɔ nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ yɛgɛ nɩɩ Yesu kpee ofuli sʋ. ");
INSERT INTO naw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesu kyɩna ofuli maŋa sʋ nkɛ adɩna. Maa bʋ tʋtɔ mʋ, Sɩtaanɛ naa tʋʋ mʋ tɔ kɩɩ. Maa nfatabwɛ nkʋn ɩ bʋ tʋtɔ. Nɩɩ Ɩbwaarɛ nbɔɔ ba ba kyɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Saŋa mʋ nɩɩ ba kɩtaa Gyɔn tii obu kamaa mʋ, Yesu kpee Galile kasɛ sʋ, ɔ naa ɛɛ tɔwɛ Ɩbwaarɛ asɩn danbɩrasa mʋ ɛɛ sa asa. ");
INSERT INTO naw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nɩɩ Yesu tɔwɛ yɛ, “Ɩbwaarɛ kuwura‐gyii mʋ ki tiri tɔ. Ɩmʋ sʋ fan yɛgɛ alibi kɩwaa kɛ fan kɔɔlɛ Ɩbwaarɛ Asɩn danbɩrasa mʋ gyii.” ");
INSERT INTO naw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu maa naa Galile ɔbʋn kaa mʋ, o wu ɩkɩn akɩtapʋ anyɔ akʋ, Simon maa mu‐supu Andiruwu, ba maa tʋʋ kisewu ɔbʋn mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan ba buu mɛ, kɛ n waa fanɛ asa akɩtapʋ.” ");
INSERT INTO naw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Opula maŋa tɔ nɩɩ ba yɛgɛ bamʋ asewu mʋ yɩla, nɩɩ ba buu Yesu. ");
INSERT INTO naw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu maa bɩla kpee mu ansi tɔ gbɛrɛɛ mʋ, ɔ bɩla wu Gyemisi maa mu‐supu Gyɔn, Sebedi mu‐bii ana, ba bʋ bamʋ ɔkʋlɩ tɔ bɛɛ lɔŋɔ bamʋ asewu. ");
INSERT INTO naw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu maa dan wu bamʋ mʋ, nɩɩ ɔ tɩɩ bamʋ. Nɩɩ ba bwiiyaa bamʋ‐sɛ Sebedi maa mʋ ayaafɔlɛ yɛgɛ ɔkʋlɩ tɔ, nɩɩ ba natɛ buu Yesu. ");
INSERT INTO naw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu maa mʋ abɩɩlapʋ mʋ ba natɛ ba Kapanum kadɛ tɔ. Kakɛ fʋʋtɛsa akɛ maa fʋʋ mʋ, Yesu kpee kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa naa kaapʋ bamʋ abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Asa mʋ ba maa nu mʋ kɩkaapʋ mʋ, ɩ waa bamʋ kɩyan, lɩɩ fɛɛ mʋ kɩkaapʋ mʋ sʋ ɔlʋn, nɩɩ kɩ kwɩɩ yɛ nbara akaapʋpʋ mʋ lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bamʋ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa mʋ tɔ mʋ, ɔnyɩn kʋ mʋ nɩɩ nbwɩɩ libi ba tɛ mʋ sʋ mʋ, kuusi kenken taasɛ Yesu yɛ, ");
INSERT INTO naw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu, Kanasareti‐nyɩn, mɩnɛ nɩɩ fii biti anɛ asɛ nfɩɩ? Fʋ ba kɛ fʋ ba nyita anɛ nɩn, abɛɛ nɛnɛ? N nyi ɔsa mʋ nɩɩ fʋ gyɛ. Fʋ gyɛ Ɩbwaarɛ Nyɩmɩsa kyɩrɛkyɩrɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tʋtɔ nɩɩ Yesu pʋntɛ kabwɩɩ libi mʋ sʋ yɛ, “Laatɔ, kɛ fʋ kʋsʋ ɔnyɩn mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nɩɩ kabwɩɩ libi mʋ ki gyingyen ɔnyɩn mʋ, nɩɩ o kuusi kenken kʋsʋ ɔnyɩn mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kanɩn asɩn nɩmʋ ɩ waa asa mʋ kɩyan, nɩɩ bɛɛ taasɛ abaa yɛ, “Mɩnɛ asɩn ndee? Ɩnɩmʋ ɩ bɩla ɩ gyɛ kɩkaapʋ pʋpwɛ kʋ nɩn? Kɩɩ, ɔnyɩn nɩmʋ sʋ ɔlʋn mʋ nɩɩ ɛɛ pʋntɛ nbwɩɩ libi sʋ nɩɩ bee nu mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tʋtɔ mʋ, Yesu asɩn nɩmʋ a tɛɛ naa nu Galile ɔsʋwʋlɛ mʋ kpini gyaŋɛ. ");
INSERT INTO naw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nɩɩ Yesu maa mʋ abɩɩlapʋ mʋ ba lɩɩ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa mʋ tɔ kpee Simon maa Andiruwu kɩkpaara sʋ, nɩɩ Gyemisi maa Gyɔn gbaa ba tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon mʋ‐saa‐kyɩɩsa ɩɩ lɔ kibirima ɔ dɛ kalan sʋ. Ɩmʋ sʋ Yesu maa loo kɩkpaara mʋ sʋ mʋ, nɩɩ ba buu sa mʋ yɛ ɔkyɩɩ maŋa ɩɩ lɔ. ");
INSERT INTO naw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tʋtɔ nɩɩ Yesu loo ɔkyɩɩ mʋ asɛ obu‐to, kɩtaa mʋ kɩbaa tɔ, kʋsaa mʋ kyɩna. Nɩɩ ɔkyɩɩ mʋ nyɛ alanfɩya, nɩɩ ɔ waa agyitɔ kɩtaa bamʋ kɩfɔ. ");
INSERT INTO naw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kalaatɩpwɛɛ maŋa kyɔwɛ maa dan ɛɛ tɩyɛ mʋ, nɩɩ asa ba taa alɔpʋ yɛ bamʋ nɩɩ nbwɩɩ libi ba tɛ bamʋ sʋ bɩya Yesu. ");
INSERT INTO naw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kadɛ mʋ asa kpini ba ba gyaŋɛ kɩkpaara maŋa kebunɔ. ");
INSERT INTO naw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kyɛ asa gaalaagaa alobi, nɩɩ ɔ gya nbwɩɩ libi lɩɩ asa gaalaagaa sʋ. Nbwɩɩ libi mʋ maa nyi Yesu sʋ mʋ, ɔ man sa bamʋ ɔkpa yɛ ba tɔwɛ kʋtɔ kʋ. ");
INSERT INTO naw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kyaasɛ gyankpaasa maa dan bʋn mʋ, nɩɩ Yesu kʋsʋ lɩɩ kɩkpaara kpee opula mʋ nɩɩ ki du surum, kʋlɛ kabwaarɛ kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tʋtɔ mʋ, Simon maa mʋ bɩrɩsa ana ba naa bee biti Yesu. ");
INSERT INTO naw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba maa naa wu mʋ mʋ, nɩɩ ba tɔwɛ mʋ yɛ, “Ɔkʋmaa nɩmʋ naa ee biti fʋ.” ");
INSERT INTO naw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nɩɩ Yesu biliŋi tɔwɛ bamʋ yɛ, “Fan yɛgɛ kɛ a kpee ndɛ‐bii mʋ nɩɩ ɩ bʋ tiri nfɩɩ mʋ, kɛ n nyɛ naa tɔwɛ abwaarɛsɩn tʋtɔ. Ɩnɩmʋ sʋ nɩɩ n lɩɩ sʋsʋ ba kasɛ sʋ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɩmʋ sʋ ɔ natɛ Galile ɩsʋwʋlɛ mʋ kpini gyaŋɛ ɛɛ tɔwɛ abwaarɛsɩn bamʋ kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa, yɛgɛ ɛɛ gya nbwɩɩ libi ɛɛ lɩɩ asa sʋ ɛɛ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tʋtɔ mʋ, bootipu kʋ ba muŋa Yesu ayaa tɔ yɛ, “Ɔnyɩrɩpɛ, nɩɩ ɩ gyɛ fʋ kɩpɩrɛ tɔ mʋ, fɩɩ taalɛ yɛgɛ mɛ n‐yɩɩ ɩ lɔŋɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nɩɩ mʋ asɩn ɩ waa Yesu kʋwɛɛ, nɩɩ ɔ taa mʋ kɩbaa mata mʋ tɔwɛ yɛ, “Ɩ gyɛ mɛ kɩpɩrɛ tɔ, ɩmʋ sʋ fʋ n‐yɩɩ ɩ lɔŋɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Opula maŋa tɔ, nɩɩ kibootoo kɩ yɛgɛ mʋ, nɩɩ ɔ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pɔyɩ kɛ Yesu ɔ yɛgɛ ɔ natɛ mʋ, ɔ da mu kumu tɔ yɛ, ");
INSERT INTO naw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Man kan waa kɛ fʋ tɔwɛ falɛ asɩn nɩmʋ sa ɔkʋ. Amaa taa fʋ n‐yɩɩ naa kaapʋ Ɩbwaarɛ oseepu, kɛ ɔ taa fʋ atɔ waa saraga sa fʋ fɛɛ kanan mʋ nɩɩ Mosesi kaapʋ yɩla mʋ, kɛ ɔkʋmaa nɩmʋ o wu fɛɛ fʋ kʋlɔ mʋ kɩ lʋwɛ.” ");
INSERT INTO naw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amaa ɔnyɩn mʋ dan lɩɩ kpee katɩn kʋmaa nɩmʋ ɛɛ da kibonbon ɛɛ sa asa yɛ Yesu ɩ kyɛ mʋ kibootoo. Ɩmʋ sʋ ɩ yɛgɛ nɩɩ Yesu man bɩla ɛɛ nyɛ ee loo kadɛ kʋ tɔ tentengilen. O kpee katɩn mʋ nɩɩ i du diin, yɛgɛ asa bɛɛ lɩɩ katɩn kʋmaa nɩmʋ bɛɛ ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ɩ man gyii nkɛ nkʋ nɩɩ Yesu bwii kpee Kapanum, nɩɩ asa ba nu fɛɛ ɔ baa ɔ bʋ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nɩɩ asa kʋkyɔ ba ba bɔla tʋtɔ, nɩɩ ɔkpa man bɩla ɔ bʋ tɔ, halɩɩ kebunɔ gbaa, yɛgɛ Yesu ɩ tɔwɛ bamʋ abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nɩɩ asa ana akʋ ba sʋla mʋgʋlɛ‐mʋgʋlɛ‐nyɩn boobi kʋ bɛɛ bɩya Yesu. ");
INSERT INTO naw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Amaa sakyɔ sʋ mʋ, ba man nyɛ ɔkpa, nɩɩ ba taa ɔnyɩn mʋ dii obu mʋ sʋsʋ, katɩn mʋ nɩɩ ba taa ɩsɛ nyalɛ munla mʋ sʋ, nɩɩ ba foti ɔbɔ opula mʋ nɩɩ Yesu bʋ mʋ kyɛɛkyɛɛ, nɩɩ ba kpɩlɩgaa ɔlɔpʋ mʋ, yɛgɛ ɔ dɛ mʋ kalan sʋ ba yɩla kasɛ. ");
INSERT INTO naw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu maa wu kanan mʋ nɩɩ ba kɔɔlɛ mʋ gyii mʋ, nɩɩ ɔ tɔwɛ ɔnyɩn mʋ yɛ, “Mi‐bii, n taa fʋ alibi kɛɛ fʋ.” ");
INSERT INTO naw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nɩɩ Ɩbwaarɛ nbara akaapʋpʋ akʋ mʋ nɩɩ ba tɛ tʋtɔ mʋ bɛɛ fɛ nfɛɛrɛ bamʋ amu tɔ yɛ, ");
INSERT INTO naw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mɩnɛ kʋtɔ nbusaa asɩn nɩɩ ɔnyɩn nɩmʋ ɩ tɔwɛ falɛ? Anɩmʋ ɩɩ taalɛ taa alibi ɛɛ kɛɛ tii Ɩbwaarɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Opula tɔ nɩɩ Yesu bɩɩ mʋ nfɛɛrɛ tɔ kʋtɔ mʋ nɩɩ bɛɛ fɛ, nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ sʋ nɩɩ fɛn fɛ kanɩn nfɛɛrɛ? ");
INSERT INTO naw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɩmʋ ɩmɔɔ ɩ bʋsɩn kɩtɔwɛ? Fɛɛ n tɔwɛ mʋgʋlɛ‐mʋgʋlɛ mʋ yɛ, ‘N taa fʋ alibi kɛɛ fʋ,’ abɛɛ n tɔwɛ mʋ yɛ, ‘Kʋsʋ kɛ fʋ taa fʋ kalan natɛ?’ ");
INSERT INTO naw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","N biti n kaapʋ fanɛ yɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n sʋ ɔlʋn mʋ nɩɩ n taalɛ taa alibi kɛɛ dulinyaa nɩmʋ tɔ.” Ɩmʋ sʋ ɔ tɔwɛ mʋgʋlɛ‐mʋgʋlɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mɛ ɩ tɔwɛ fʋ fɛɛ, kʋsʋ taa fʋ kalan kɛ fu kpewu.” ");
INSERT INTO naw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nɩɩ ɔ kʋsʋ taa mʋ kalan waa bilen kpewu, yɛgɛ asa ba kɩɩ mʋ, nɩɩ i kyinkyin bamʋ gaa, nɩɩ ba yɩn Ɩbwaarɛ tɔwɛ fɛɛ, “An man pɩɩta wu falɛ asɩn nɩmʋ kakaakʋ.” ");
INSERT INTO naw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu bwii kpee Galile ɔbʋn‐kaa, nɩɩ asa damantɛ ba ba mʋ asɛ, nɩɩ o piili ɛɛ kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Maa kyʋn ee kpee mʋ, o wu Alifeyo mu‐bii Lewi maa tɛ lenpoo ɔkɔɔlɛkpa. Nɩɩ Yesu tɔwɛ mʋ yɛ, “Ba buu mɛ.” Nɩɩ Lewi kʋsʋ buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɩmʋ kamaa tɔ, Yesu maa mʋ abɩɩlapʋ ba tɛ bee gyii Lewi kɩkpaara sʋ, nɩɩ lenpoo akɔɔlɛpʋ yɛ alibi awaapʋ damantɛ ba buu mʋ, nɩɩ bamʋ gaalaagaa ba be tii mʋ sʋ bee gyii agyitɔ. ");
INSERT INTO naw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nɩɩ nbara akaapʋpʋ mʋ nɩɩ ba gyɛ Farasii abi mʋ, ba maa wu fɛɛ Yesu maa alibi awaapʋ yɛ lenpoo akɔɔlɛpʋ ba maa gyii mʋ, ba taasɛ yɛ, “Mɩnɛ kʋtɔ sʋ nɩɩ maa falɛ asa ɩ tɛ bee gyii?” ");
INSERT INTO naw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu nu kʋtɔ mʋ nɩɩ bɛɛ tɔwɛ mʋ, nɩɩ ɔ lɛɛ bamʋ kɔnɔ yɛ, “Bamʋ nɩɩ ba mɛɛ lɔ mʋ, be mee biti ɔkyɛpʋ, amɔɔ bamʋ nɩɩ bɛɛ lɔ. N man ba nɩn kɛ n ba tɩɩ adanbɩrasa awaapʋ, amɔɔ alibi awaapʋ.” ");
INSERT INTO naw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gyɔn Okyugyeepu abɩɩlapʋ yɛ Farasii abi bee ŋmina kɔnɔ. Nɩɩ asa akʋ ba kpee Yesu asɛ naa taasɛ mʋ yɛ, “Mɩnɛ sʋ nɩɩ Gyɔn Okyugyeepu abɩɩlapʋ yɛ Farasii abi abɩɩlapʋ bee ŋmina kɔnɔ, nɩɩ fʋ abɩɩlapʋ mʋ bɩrɛ be mee ŋmina?” ");
INSERT INTO naw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nɩɩ Yesu taasɛ bamʋ yɛ, “Kɩkyɩɩfɔ tɔ asa bɛɛ taalɛ ŋmina kɔnɔ yɛgɛ ɔkyɩɩfɔ mu‐kuli san ɔ bʋ bamʋ asɛ? Ɩ mɛɛ yɛ ɩ waa kanɩn. Fɛɛ ɔkyɩɩfɔ mu‐kuli san bʋ bamʋ asɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amaa saŋa kʋ ɩɩ ba nɩɩ bee biti ba taa ɔkyɩɩfɔ mu‐kuli mʋ lɩɩ bamʋ asɛ. Kanɩn saŋa maŋa tɔ nɩɩ bee biti ba ŋmina kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ba mɛɛ taa kikyibi pʋpwɛ bɛɛ mata kaalɛ dɩdaa ɔbɔ, lɩɩ fɛɛ kii biti kɩ kyatɛ kaalɛ mʋ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kanɩn maŋa nɩɩ ɔkʋ mɛɛ taa nta pʋpwɛ waa kʋtɔbwaaya ɔwʋlɛ taakpe dɩdaa tɔ. Nɩɩ ɔ kan waa kanɩn, nɩɩ nta mʋ ɩɩ bɩlɛ mʋ, ii biti ɩ kyatɛ taakpe dɩdaa mʋ nyita, kɛ nta mʋ ɩ kyɛɛgɛ fɔyɩ. Amaa bɛɛ taa nta pʋpwɛ waa taakpe pʋpwɛ tɔ, kɛ ɩmʋ anyɔ mʋ ɩ man nyita.” ");
INSERT INTO naw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kakɛ fʋʋtɛsa kʋ, nɩɩ Yesu maa mʋ abɩɩlapʋ ba naa alʋn kadɔɔ kʋ tɔ, nɩɩ mʋ abɩɩlapʋ ba piili bɛɛ gyayɩ alʋn mʋ ɩkʋ. ");
INSERT INTO naw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nɩɩ Farasii abi mʋ ba yɛ, “Kɩɩ, mɩnɛ sʋ nɩɩ fʋ abɩɩlapʋ bɛɛ waa kʋtɔ mʋ nɩɩ ɩ man dɛ ɔkpa kakɛ fʋʋtɛsa?” ");
INSERT INTO naw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Fan man pɩɩta kalɛ kʋtɔ mʋ nɩɩ Owura Dawidi maa mʋ kamaa tɔ abi ba waa saŋa mʋ nɩɩ akʋn a mɔɔ bamʋ mʋ nɩn? ");
INSERT INTO naw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Saŋa mʋ nɩɩ Abiyata kyɩna ɔ gyɛ Ɩbwaarɛ oseepu bɩlɩsa asɛ mʋ, Owura Dawidi loo Kabwaarɛ‐sunkpa obu mʋ tɔ naa taa bodobodo mʋ nɩɩ ba taa lɛɛ saraga sa Ɩbwaarɛ mʋ wɛ, nɩɩ ɔ sa mʋ kamaa tɔ abi, yɛgɛ ɩ man dɛ ɔkpa fɛɛ ba wɛ ɩmʋ, amɔɔ aseepu mʋ nkʋn.” ");
INSERT INTO naw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nɩɩ Yesu tɔwɛ bamʋ fɛɛ, “Nyɩmɩsa kɩdanbɩrasa sʋ nɩɩ Ɩbwaarɛ waa kakɛ fʋʋtɛsa mʋ, man gyɛ nyɩmɩsa nɩɩ ba waa sa kakɛ fʋʋtɛsa mʋ sa. ");
INSERT INTO naw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ɩmʋ sʋ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n kyɔ kakɛ fʋʋtɛsa mʋ gbaa.” ");
INSERT INTO naw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu bwii kpee kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa. Ɔnyɩn kʋ mʋ nɩɩ mʋ kɩbaa ki wu mʋ bʋ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Asa akʋ mɔɔ ba bʋ tʋtɔ nɩɩ bee biti kanan mʋ nɩɩ ba nyɛ asɩn akʋ taa pwɩɩ Yesu. Ɩmʋ sʋ ba tɛ bee gyoo fɛɛ Yesu ii biti ɔ kyɛ ɔnyɩn mʋ kakɛ fʋʋtɛsa akɛ, abɛɛ ɔ mɛɛ yɛ ɔ kyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nɩɩ Yesu tɔwɛ ɔnyɩn mʋ yɛ, “Kʋsʋ yɩlɛ bamʋ ansi tɔ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nɩɩ ɔ taasɛ asa mʋ yɛ, “Kɩmɔmɔ nɩɩ anɛ nbara mʋ ɩɩ sa ɔkpa fɛɛ a waa kakɛ fʋʋtɛsa akɛ? Adanbɩrasa abɛɛ alibi? A mɔlɩgɛ asa abɛɛ a mɔɔ?” Asa mʋ ba man taalɛ tɔwɛ sɛhn. ");
INSERT INTO naw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nɩɩ Yesu kɩɩ bamʋ kyaabɔɔ agbʋ sʋ, nɩɩ ɩ kɔ mʋ gaa lɩɩ bamʋ kʋsʋ tɔ ɔlʋn sʋ. Nɩɩ ɔ tɔwɛ ɔnyɩn mʋ yɛ, “Tɛɛŋɛ fʋ kɩbaa.” Nɩɩ ɔ tɛɛŋɛ mʋ kɩbaa, nɩɩ ki kyiŋi. ");
INSERT INTO naw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tʋtɔ nɩɩ Farasii abi mʋ ba lɩɩ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa mʋ tɔ, nɩɩ ba maa Herodi kamaa abi ba naa waa kɔnɔ kʋlʋn ɔkpa mʋ nɩɩ ba taa kɛ ba mɔɔ Yesu. ");
INSERT INTO naw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu maa mʋ abɩɩlapʋ ba lɩɩ ɩkaa sʋ kpee Galile ɔbʋn ɔkaa, nɩɩ asa damantɛ ba lɩɩ Galile yɛ Gyudeya ɩsʋwʋlɛ sʋ ba buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Akʋ ba lɩɩ Gyerusalem kadɛ lala yɛ ɩsʋwʋlɛ mʋ nɩɩ ɩ bʋ Idumiya, yɛ Gyɔdan ɔbʋn kyɔwɛ kɩlɩɩ yɛ Taayi maa Sidon ndɛ lala mʋ abaafʋn. Asa damantɛ ba ba Yesu asɛ, lɩɩ fɛɛ ba nu kʋtɔ mʋ nɩɩ ɛɛ waa. ");
INSERT INTO naw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sakyɔ mʋ sʋ mʋ, Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ ba lɔŋɔ ɔkʋlɩ yɩla mʋ, kɛ ba man nyɛ nin tiri mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lɩɩ fɛɛ ɔ kyɛ asa damantɛ, nɩɩ bamʋ nɩɩ bɛɛ san bɛɛ lɔ mʋ kpini, bee nin bee tiri mʋ, kɛ ba nyɛ mata mʋ. ");
INSERT INTO naw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nɩɩ nbwɩɩ libi wuya ana ba kan wu mʋ mʋ, bɛɛ lɩɩ bɛɛ tɩyɛ mu ansi tɔ, kɛ ba kuusi tɔwɛ fɛɛ, “Fʋ ɩ gyɛ Ɩbwaarɛ Mu‐Bii mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nɩɩ Yesu ɩ gya bamʋ fɛɛ ba man tɔwɛ ɔkʋ ɔsa mʋ nɩɩ ɔ gyɛ. ");
INSERT INTO naw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nɩɩ Yesu kpee kɩbɩɩ sʋ, nɩɩ ɔ tɩɩ asa mʋ nɩɩ ee biti, nɩɩ ba ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nɩɩ ɔ lɛɛ bamʋ tɔ asa kudu anyɔ, nɩɩ ɔ tɩɩ bamʋ fɛɛ asunpu. Nɩɩ ɔ tɔwɛ bamʋ yɛ, “N lɛɛ fanɛ fɛɛ fan baa fan bʋ mɛ asɛ, kɛ n sun fanɛ fan naa tɔwɛ abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","N biti n sa fanɛ ɔlʋn mʋ nɩɩ fen biti fan taalɛ taa gya nbwɩɩ libi.” ");
INSERT INTO naw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Asa kudu anyɔ mʋ nɩɩ Yesu lɛɛ mʋ atɩɩ ndee. Simon (mʋ nɩɩ Yesu yɩla mʋ kɩtɩɩ yɛ Pita). ");
INSERT INTO naw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi mu‐bii ana Gyemisi yɛ Gyɔn, (mʋ nɩɩ Yesu yɩla bamʋ kɩtɩɩ yɛ Bwanegesi ɩmʋ kasɛ ɩ gyɛ yɛ, Bʋlayɩ kikpira nbii). ");
INSERT INTO naw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bamʋ akʋ ɩ gyɛ Andiruwu yɛ Filipu yɛ Batolome yɛ Matiwu yɛ Tomasi yɛ Alifeyo mu‐bii Gyemisi yɛ Simon Seloti, ");
INSERT INTO naw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yɛ Gyuda Isikariyoti, mʋ nɩɩ ɔ ba lɛɛ Yesu sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nɩɩ Yesu bwii kpee kewu tɔ. Nɩɩ sakyɔ bɩla ba mʋ asɛ, halɩɩ maa mʋ abɩɩlapʋ ba man nyɛ saŋa kɛ ba gyii. ");
INSERT INTO naw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mʋ kʋʋpʋ ana ba maa nu falɛ mʋ, ba sun ba naa kɩtaa mʋ ba, lɩɩ fɛɛ ba nu asa bɛɛ tɔwɛ yɛ mʋ nfɛɛrɛ i nyita. ");
INSERT INTO naw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nɩɩ nbara akaapʋpʋ mʋ nɩɩ ba lɩɩ Gyerusalem mʋ akʋ ba yɛ, “Yesu sʋ Beelisebu mʋ nɩɩ ɔ gyɛ nbwɩɩ libi kumu mʋ ɔlʋn. Mʋ ɩɩ sa mʋ ɔlʋn nɩɩ ɛɛ taalɛ ɛɛ gya nbwɩɩ libi falɛ.” ");
INSERT INTO naw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ɩmʋ sʋ Yesu tɩɩ bamʋ, nɩɩ ɔ tɔwɛ bamʋ kɩŋasan tɔ yɛ, “Ɔkpa mɔɔ sʋ nɩɩ Sɩtaanɛ ɩ taalɛ gya Sɩtaanɛ? ");
INSERT INTO naw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nɩɩ ɔsʋwʋlɛ asa ba kan ba barɩgɛ tɔ bɛɛ kɔ yɛ abaa mʋ, ɔsʋwʋlɛ maŋa i boyi. ");
INSERT INTO naw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nɩɩ kɩkpaara sʋ asa ba kan bɛɛ barɩgɛ tɔ bɛɛ kɔ yɛ abaa mʋ, kɩkpaara maŋa i boyi. ");
INSERT INTO naw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ɩmʋ sʋ mʋ, nɩɩ Sɩtaanɛ kuwura‐gyii kɩ kan kɩ barɩgɛ tɔ kɩɩ kɔ yɛ abaa mʋ, kɩɩ tɩyɛ kakpaa. ");
INSERT INTO naw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ɔkʋ mɛɛ taalɛ loo ɔlʋnpʋ kɩkpaara sʋ naa swii mʋ atɔ natɛ. Amɔɔ ɩ dagaa maa gyankpaa ŋmina mʋ pɔyɩ, kɛ ɔ nyɛ ɔkpa loo mʋ kɩkpaara sʋ yuuri mʋ atɔ. ");
INSERT INTO naw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","N gyii fanɛ kesintin fɛɛ, Ɩbwaarɛ ɩɩ taa nyɩmɩsa alibi kʋmaa yɛ mʋ kɩtɔwɛ yii mʋ kʋmaa ɛɛ kɛɛ. ");
INSERT INTO naw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amaa nyɩmɩsa kɩtɔwɛ yii Kayaayu Kyɩrɛkyɩrɛ mʋ bɩrɛ, Ɩbwaarɛ mɛɛ yɛ ɔ taa kɛɛ mʋ, lɩɩ fɛɛ ɔ waa alibi mʋ nɩɩ ɩ dɛ kakpaa nɩn.” ");
INSERT INTO naw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu tɔwɛ ɩnɩmʋ nɩn, lɩɩ fɛɛ akʋ bɛɛ yɛ ɔ sʋ nbwɩɩ libi. ");
INSERT INTO naw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nɩɩ Yesu mu‐nyi yɛ mu‐supu ana ba ba yɩla nbwama, nɩɩ ba sun mʋ asɛ yɛ ba tɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Saŋa maŋa mʋ, asa ba kyɩna kyaabɔɔ mʋ, nɩɩ ba tɔwɛ mʋ yɛ, “Kɩɩ fu‐nyi yɛ fu‐supu ana ba bʋ nbwama bee biti fʋ.” ");
INSERT INTO naw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nɩɩ Yesu taasɛ bamʋ yɛ, “Anɩmʋ ɩ gyɛ mi‐nyi yɛ mu‐supu ana?” ");
INSERT INTO naw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nɩɩ ɔ kɩɩ asa mʋ nɩɩ ba tɛ kyaabɔɔ mʋ gyaŋɛ, nɩɩ ɔ yɛ, “Fan kɩɩ! Banɩmʋ ɩ gyɛ Mi‐nyi yɛ mi‐supu ana. ");
INSERT INTO naw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɔkʋmaa mʋ nɩɩ ɛɛ waa Ɩbwaarɛ kebiti mʋ, mʋ ɩ gyɛ mi‐supu, yɛ mɛ‐daa, yɛ mɛ‐pɩɩkyɩɩ yɛ mi‐nyi.” ");
INSERT INTO naw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nɩɩ Yesu bɩla piili ɛɛ kaapʋ Galile ɔbʋn kaa, nɩɩ asa damantɛ ba ba kyaabɔɔ mʋ bɛɛ nu mʋ asɛ. Sakyɔ sʋ mʋ, o loo ɔkʋlɩ mʋ nɩɩ kɩ gyan nkyu sʋ ɔbʋn kaa, yɛgɛ asa ba yɩla kidenbi sʋ. ");
INSERT INTO naw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nɩɩ ɔ taa aŋasan tɔ kaapʋ bamʋ atɔ damantɛ. Mʋ kɩkaapʋ tɔ mʋ nɩɩ ɔ tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Fan nu, ɔdɔɔpʋ kʋ ɩ kyɩna kpee ɔ naa ŋmatɛ ayu. ");
INSERT INTO naw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Saŋa mʋ nɩɩ ɛɛ ŋmatɛ ayu mʋ, ɩmʋ ɩkʋ ɩ tɩyɛ ɔkpa kaa, nɩɩ nbwiibi ba ba tasɛ gyii. ");
INSERT INTO naw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nɩɩ ɩkʋ ɩ tɩyɛ fʋlɛ sʋ, katɩn mʋ nɩɩ ɩsɛ ɩ man bʋnyɛ, ɩmʋ sʋ ɩ kɔyɩ bilen. ");
INSERT INTO naw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ɩmʋ sʋ kyɔwɛ maa da mʋ, ɩ bwɩɩ, nɩɩ i wu lɩɩ fɛɛ ɩ man sʋ ilin. ");
INSERT INTO naw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nɩɩ ɩkʋ ɩ tɩyɛ iwii tɔ, nɩɩ iwii mʋ ɩ dan nyan ɩmʋ, nɩɩ ɩ man talɛ sɔyɩ abi. ");
INSERT INTO naw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nɩɩ ɩkʋ mɔɔ ɩ tɩyɛ kasɛ danbɩrasa tɔ. Nɩɩ ɩ kɔyɩ dan nɩɩ ɩ sɔyɩ abii. Ɩkʋ ɩ sɔyɩ abi adɩsa, ɩkʋ mɔɔ adisiye, nɩɩ ɩkʋ mɔɔ kɩlɩfa.” ");
INSERT INTO naw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nɩɩ Yesu lʋwɛ tɔwɛ yɛ, “Ɔmʋ nɩɩ ɔ sʋ asʋ nɩɩ ee biti o nu mʋ, o nu.” ");
INSERT INTO naw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɩ maa ba san Yesu nkʋn mʋ, mʋ abɩɩlapʋ kudu anyɔ yɛ asa mʋ nɩɩ ba nu mʋ asɩn tɔwɛsa mʋ akʋ ba ba taasɛ mʋ kɩŋasan mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fanɛ bɩrɛ, Ɩbwaarɛ lɛɛ kuwura‐gyii mʋ asiri asɩn kaapʋ fanɛ, amaa bamʋ nɩɩ ba man tii fanɛ sʋ bɩrɛ mʋ, aŋasan tɔ nɩɩ bɛɛ sʋ bɛɛ kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ɩmʋ sʋ, ‘bee biti ba kɩɩ kɛ ba kɩɩ, ba mɛɛ yɛ ba wu, bee biti ba nu, amaa ba mɛɛ yɛ ba nu kasɛ. Nɩɩ ɩ man gyɛ kanɩn sʋ, naafɔɔ ba tee bwii ba Ɩbwaarɛ asɛ, kɛ ɔ taa bamʋ alibi kɛɛ bamʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nɩɩ Yesu taasɛ bamʋ yɛ, “Fan man nu kɩŋasan nɩmʋ kasɛ? Nɛnɛ nɩɩ fen biti fan nu kɩŋasan kʋ kasɛ? ");
INSERT INTO naw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ɔdɔɔpʋ mʋ ɩ gyɛ abwaarɛsɩn ɔtɔwɛpʋ. ");
INSERT INTO naw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Asa akʋ ba du nɩn fɛɛ ayu mʋ nɩɩ ɩ tɩyɛ ɔkpa kaa mʋ. Ba dan bee nu abwaarɛsɩn mʋ, yɛgɛ Sɩtaanɛ ɩ ba lɛɛ abwaarɛsɩn mʋ lɩɩ bamʋ nfɛɛrɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Akʋ mɔɔ ba du nɩn fɛɛ abi mʋ nɩɩ ɩ tɩyɛ afʋlɛ sʋ mʋ. Ba dan nu abwaarɛsɩn mʋ, bɛɛ taa kensi‐gyii kɔɔlɛ ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amaa ɩ maa mee loo bamʋ nkɔlɔ kasɛ tɔ sʋ mʋ, ɩ mɛɛ kyɛɛrɛɛ bamʋ tɔ. Ɩmʋ sʋ nɩɩ awʋrʋfɔ abɛɛ kanyanla dan ba bamʋ sʋ lɩɩ abwaarɛsɩn sʋ mʋ, bɛɛ yɛgɛ Ɩbwaarɛ kesun. ");
INSERT INTO naw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Akʋ mɔɔ ba du nɩn fɛɛ abi mʋ nɩɩ ɩ tɩyɛ iwii tɔ mʋ. Kanɩn asa mʋ bee nu abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Amaa kakyɩna kanɩmʋ tɔ tɔɔrɔɔ yɛ kefulee biti kensi payɩ yɛ dulinyaa atɔ kebiti libi, ɩ ba nyan abwaarɛsɩn mʋ, nɩɩ ɩ man taalɛ sɔyɩ abi. ");
INSERT INTO naw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nɩɩ akʋ mɔɔ ba du nɩn fɛɛ abi mʋ nɩɩ ɩ tɩyɛ ɩsɛ danbɩrasa tɔ mʋ. Ba dan nu abwaarɛsɩn mʋ, bɛɛ kɔɔlɛ ɩmʋ kɛ bɛɛ sɔyɩ abi. Akʋ bɛɛ sɔyɩ adɩsa, akʋ adisiye, nɩɩ akʋ gbaa kɩlɩfa.” ");
INSERT INTO naw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nɩɩ Yesu bɩla bɔ kɩŋasan kʋ yɛ, “Be mee tuwa fɩtɩla kɛ ba taa waa kolobi tɔ, abɛɛ ba taa waa npaa kasɛ. Bee tuwa fɩtɩla ba sʋ bɛɛ gyaga kɩmʋ ɔgyagakpa nɩn. ");
INSERT INTO naw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ɩmʋ sʋ kʋtɔ kʋmaa mʋ nɩɩ kɩ baala mʋ, kii biti kɩ lɩɩ ifuli, kɛ kɩmʋ nɩɩ kii bun sʋ mʋ kii biti ki bugi tɔ. ");
INSERT INTO naw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɔkʋmaa mʋ nɩɩ ɔ sʋ asʋ mʋ o nu.” ");
INSERT INTO naw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nɩɩ ɔ tɔwɛ bamʋ fɛɛ, “Fan fɛ nfɛɛrɛ danbɩrasa lɩɩ asɩn mʋ nɩɩ fan nu mʋ sʋ. Kʋtɔ kaalasa mʋ nɩɩ fʋ taa kaala sa fʋ tɔɔmaa mʋ, kɩmʋ nɩɩ Ɩbwaarɛ gbaa ii biti ɔ kaala sa fʋ, kɛ ɩ ŋara fʋ lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ɔsa mʋ nɩɩ ɔ sʋ mʋ, ee biti ɔ nyɛ tii sʋ, nɩɩ ɔmʋ nɩɩ ɔ man sʋ mʋ, halɩɩ pii mʋ nɩɩ ɔ sʋ mʋ, bee biti ba kɔɔlɛ lɩɩ mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nɩɩ Yesu tɔwɛ fɛɛ, “Ɩbwaarɛ kuwura‐gyii du nɩn fɛɛ ɔnyɩn kʋ mʋ nɩɩ ɔ ŋmatɛ ayu mʋ ndɔɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ɛɛ dɛ kɛ o kyiŋi kagyanbwɛ yɛ kakyʋwapɛ, yɛgɛ ɔ man nyi kanan mʋ nɩɩ ayu mʋ ɩ waa nɩɩ ɩ kɔyɩ nɩɩ ɩ dan. ");
INSERT INTO naw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kasɛ mʋ ɩ yɛgɛ ayu mʋ ɩɩ dan nɩɩ ɩɩ kɔyɩ. Oyu mʋ ɩ gyankpaa kɔyɩ kɛ ɩ nyɛ ɔtɔ kɛ ɩ kʋʋgɛ abi. ");
INSERT INTO naw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ɩ dan mʋ, nɩɩ ɔnyɩn mʋ ɩ taa deebi naa tɩŋɛ ɩmʋ lɩɩ fɛɛ ɩmʋ saŋa fʋʋ.” ");
INSERT INTO naw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nɩɩ Yesu taasɛ fɛɛ, “Mɩnɛ kʋtɔ nɩɩ an biti a taa Ɩbwaarɛ kuwura‐gyii mʋ waa sɩnkaala? Mɩnɛ kɩŋasan nɩɩ an biti a taa kaapʋ tɔ? ");
INSERT INTO naw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ki du nɩn fɛɛ sinapi oyu kibi atɔ duusa tɔ kpini kibi pii, nɩɩ bee duu kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nɩɩ ba kan duu kɩmʋ mʋ, kɩ kɔyɩ, nɩɩ kɩɩ dan kɩ gyɔɔ apʋnfa kpini, nɩɩ kɩɩ waa n‐yaabi lala halɩɩ nbwiibi ba ba waa nsʋswaa kɩmʋ onyin tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aŋasan tɔ falɛ nɩɩ Yesu taa tɔwɛ bamʋ abwaarɛsɩn. Ɔ tɔwɛ bamʋ kanan mʋ nɩɩ bɛɛ taalɛ nu kasɛ. ");
INSERT INTO naw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Asɩn akʋ ɩ man bʋ tɔ nɩɩ ɔ tɔwɛ bamʋ, nɩɩ ɩ man gyɛ kɩŋasan. Amaa saŋa kʋmaa nɩɩ ɩ ba san maa mʋ abɩɩlapʋ nkʋn mʋ, ɛɛ lɛɛ ɩmʋ kasɛ ɛɛ kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kakɛ maŋa kalaatɩpwɛɛ asɛ nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ fɛɛ, “Fan yɛgɛ a faa kpee benbe.” ");
INSERT INTO naw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nɩɩ ba loo ɔkʋlɩ mʋ nɩɩ Yesu tɛ kɩmʋ tɔ mʋ, nɩɩ ba yɛgɛ sakyɔ mʋ ɔbʋn kaa, ɩkʋlɩ ɩkʋ gbaa i tii bamʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ba maa kpee mʋ, nɩɩ afuu i tigi kɔnɔ kʋlʋn, nɩɩ apaa ɩ waa nɩɩ ɩ da nkyu ɩ waa ɔkʋlɩ mʋ tɔ naa san gbɛrɛɛ kɛ ɔkʋlɩ mʋ ɔ bɔla. ");
INSERT INTO naw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Amaa Yesu taa mu kumu gyaga keputu sʋ dɛ nsɩɩrɛ ɔkʋlɩ kɔnɔ. Nɩɩ abɩɩlapʋ mʋ ba kyiŋi mʋ, nɩɩ ba taasɛ mʋ yɛ, “Ɔnyɩrɩpɛ, a maa biti a wu mʋ, ɩ man tiri fʋ?” ");
INSERT INTO naw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nɩɩ Yesu kʋsʋ yɩlɛ. Nɩɩ ɔ tɔwɛ afuu mʋ fɛɛ, “Waa diin.” Nɩɩ katɩn kʋmaa waa diin. ");
INSERT INTO naw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nɩɩ Yesu taasɛ mʋ abɩɩlapʋ mʋ yɛ, “Mɩnɛ sʋ nɩɩ fan sʋ kufuu? Fan man sʋ kɩkɔɔlɛ‐gyii nɩn?” ");
INSERT INTO naw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nɩɩ kufuu kɩ kɩtaa bamʋ gaa nɩɩ ba taasɛ abaa yɛ, “Mɩnɛ Nyɩmɩsa ndee? Halɩɩ afuu yɛ apaa gbaa i nu mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu maa mʋ abɩɩlapʋ ba faa kpee Galile ɔbʋn benbe, Gerasene kabaafʋn. ");
INSERT INTO naw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu maa dan ɛɛ lɩɩ ɔkʋlɩ tɔ, nɩɩ ɔnyɩn kʋ mʋ nɩɩ nbwɩɩ libi ba tɛ mʋ sʋ mʋ, lɩɩ nkyan tɔ ba gyaŋa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ɔnyɩn maŋa tɛ nkyan mʋ tɔ nɩn. Ɔkʋ man bɩla taalɛ da mʋ ɩgbɛɛ. ");
INSERT INTO naw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lɩɩ fɛɛ saŋa kʋmaa nɩɩ ba da mʋ ayaa yɛ abaa ɩgbɛɛ mʋ, ɛɛ tɩŋɛ ɩmʋ nɩn. Nɩɩ ɔkʋ man bʋ tɔ kɛ ɔ taalɛ gyii mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ɔ naa ɔ naa nkyan yɛ abɩɩ tɔ kyʋwapɛ yɛ kagyanbwɛ, nɩɩ ɛɛ taa afʋlɛ ɛɛ kyaŋɛ mʋ n‐yɩɩ yɛgɛ ee kuusi. ");
INSERT INTO naw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Maa wu Yesu kata mʋ, ɔ sɩlɛ naa gyaŋa mʋ, nɩɩ o muŋa mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nɩɩ o kuusi kenken tɔwɛ yɛ, “Yesu, fʋ ɩ gyɛ Ɩbwaarɛ mʋ nɩɩ ɔ gyɛ Owura lala Mu‐Bii. Maa fʋ an sʋ mɩnɛ? Bɔ Ɩbwaarɛ fɛɛ fʋ mɛɛ yɛ fʋ tɔɔrɔɔ mɛ.” ");
INSERT INTO naw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ɔnyɩn mʋ tɔwɛ kanɩn nɩn lɩɩ fɛɛ Yesu wʋla tɔwɛ nbwɩɩ libi mʋ yɛ, “Nbwɩɩ libi, fan lɩɩ ɔnyɩn mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nɩɩ Yesu taasɛ mʋ yɛ, “Fʋ kɩtɩɩ?” Nɩɩ ɔ yɛ, “Bɛɛ tɩɩ mɛ yɛ Kʋkyɔ, lɩɩ fɛɛ an kyɔ.” ");
INSERT INTO naw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nɩɩ ɔ mata sʋ ɛɛ kʋlɛ Yesu gaa fɛɛ ɔ man gya nbwɩɩ libi mʋ lɩɩ ɔsʋwʋlɛ maŋa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Akuuri damantɛ akʋ ba bʋ tiri tʋtɔ kɩbɩɩ kʋ sʋ bee gyii. ");
INSERT INTO naw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nɩɩ nbwɩɩ libi mʋ ba kʋlɛ Yesu yɛ, “Yɛgɛ a naa loo akuuri mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nɩɩ Yesu sa bamʋ ɔkpa, nɩɩ ba lɩɩ ɔnyɩn mʋ tɔ naa loo akuuri mʋ tɔ. Nɩɩ akuuri mʋ kpini bamʋ kɔnɔ ɩ waa fɛɛ ngbɩn nyɔ mʋ, ba sɩlɛ kpɩlɩgɛ kɩbɩɩ mʋ ogee tɔ naa loo nkyu tɔ muuri. ");
INSERT INTO naw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nɩɩ asa mʋ nɩɩ bɛɛ kɩɩ akuuri mʋ sʋ mʋ, ba sɩlɛ kpee kadɛ tɔ yɛ ndɔɔ ana tɔ naa tɔwɛ asa. Nɩɩ asa ba ba kɩɩ kʋtɔ mʋ nɩɩ kɩ waa. ");
INSERT INTO naw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba maa ba Yesu asɛ mʋ, ba wu ɔnyɩn mʋ nɩɩ ɔ daa ɔ sʋ nbwɩɩ libi mʋ, bun ɩkaalɛ danbɩrasa ɔ tɛ, nɩɩ mʋ nfɛɛrɛ tɔ ɩ dɛ. Nɩɩ kufuu kɩ kɩtaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bamʋ nɩɩ ba taa bamʋ ansi wu kʋtɔ mʋ nɩɩ Yesu waa mʋ, ba tɔwɛ ɔnyɩn mʋ nɩɩ nbwɩɩ libi ba tɛ mʋ sʋ, yɛ akuuri mʋ asɩn sa asa. ");
INSERT INTO naw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nɩɩ asa mʋ ba yɛ Yesu ɔ lɩɩ bamʋ ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu maa loo ɔkʋlɩ tɔ mʋ, ɔnyɩn mʋ nɩɩ nbwɩɩ libi ba daa ba tɛ mʋ sʋ mʋ, kʋlɛ mʋ yɛ ɔ yɛgɛ ɔ buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nɩɩ Yesu kina, nɩɩ ɔ tɔwɛ mʋ yɛ, “Bwii kpee kewu naa tɔwɛ fʋ asa kʋtɔ mʋ nɩɩ Ɔnyɩrɩpɛ Ɩbwaarɛ waa sa fʋ, yɛ kanan mʋ nɩɩ o wu fʋ kʋwɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nɩɩ ɔnyɩn mʋ lɩɩ tʋtɔ naa natɛ kabaafʋn mʋ nɩɩ bɛɛ tɩɩ yɛ Ndɛ Kudu mʋ sʋ kpini, ɛɛ tɔwɛ asa kʋtɔ mʋ nɩɩ Yesu waa sa mʋ. Nɩɩ i kyinkyin bamʋ nɩɩ ba nu mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nɩɩ Yesu bwii loo ɔkʋlɩ tɔ faa kpee ɔbʋn mʋ benbe, nɩɩ asa kʋkyɔ ba ba sarɛ kyaabɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nɩɩ Gyarosi mʋ nɩɩ ɔ gyɛ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa abɩlɩsa mʋ tɔ ɔkʋ ba tʋtɔ. Maa wu Yesu mʋ, nɩɩ ɔ tɩyɛ mʋ ayaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nɩɩ ɔ kʋlɛ mʋ gaa yɛ, “N kʋlɛ fʋ nɩn, mi kebii kyɩɩsa‐bi ɛɛ lɔ ee biti o wu, ba taa fʋ abaa gyaga mʋ sʋ kɛ ɔ nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nɩɩ maa Yesu ba yii sʋ bee kpee, yɛgɛ sakyɔ ba mili Yesu sʋ ba buu mʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ɔkyɩɩ kʋ nɩɩ nkalan ɩɩ da mʋ, nsu kudu anyɔ, bʋ sakyɔ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɔkyɩɩ mʋ nyita mu afulee mʋ nɩɩ ɔ sʋ kpini akyɛpʋ asɛ kpɩnɛ, fɛɛ naafɔɔ kʋlɔ mʋ kɩ bɔɔsɛ mʋ, amaa kʋlɔ mʋ kɩ san kii tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","O nu Yesu sʋ nɩɩ o loo sakyɔ mʋ tɔ ba Yesu kamaa. ");
INSERT INTO naw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nɩɩ ɔkyɩɩ mʋ fɛ nfɛɛrɛ mu kumu tɔ yɛ, “Naafɔɔ n daa nyɛ mata mʋ kaalɛ gbaa nɩn, n biti n nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nɩɩ ɔ mata Yesu kaalɛ, nɩɩ nkalan mʋ ɩ tɩn opula tɔ. Nɩɩ o wu mʋ n‐yɩɩ tɔ fɛɛ mʋ awʋrʋfɔ kpini ɩ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Opula tɔ nɩɩ Yesu bɩɩ fɛɛ ɔlʋn kʋ lɩɩ mʋ tɔ, nɩɩ o biliŋi kɩɩ sakyɔ mʋ, nɩɩ ɔ taasɛ yɛ, “Anɩmʋ ɩ mata mɛ kaalɛ?” ");
INSERT INTO naw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nɩɩ mʋ abɩɩlapʋ ba ba sa mʋ kɔnɔ fɛɛ, “Fu wu kanan mʋ nɩɩ sakyɔ mʋ mili fʋ sʋ, nɩɩ fʋ taasɛ yɛ, ‘Anɩmʋ ɩ mata mɛ kaalɛ?’ ” ");
INSERT INTO naw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nɩɩ Yesu biliŋi ɔ dan san ɛɛ kɩɩ ee biti ɔsa mʋ nɩɩ ɔ mata mʋ kaalɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nɩɩ ɔkyɩɩ mʋ maa wu kʋtɔ mʋ nɩɩ kɩ waa mʋ mʋ, nɩɩ ɔ taa kufuu kyɩkyaa natɛ ba Yesu ansi tɔ, ba muŋa mʋ ayaa tɔ, nɩɩ ɔ lɛɛ asɩn mʋ kesintin kpini tɔwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nɩɩ Yesu tɔwɛ ɔkyɩɩ mʋ fɛɛ, “Mi‐bii, fʋ kɩkɔɔlɛ‐gyii kɩ yɛgɛ nɩɩ fʋ nyɛ alanfɩya, kpewu kɔkɔlɔ yuuli sʋ, fʋ awʋrʋfɔ ɩ lʋwɛ.” ");
INSERT INTO naw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu maa san ɛɛ tɔwɛ mʋ, nɩɩ nbɔɔ ba lɩɩ ɔbɩlɩsa Gyarosi kɩkpaara sʋ ba tɔwɛ Gyarosi yɛ, “Fu kebii kyɩɩsa‐bi mʋ wu, mɩnɛ sʋ nɩɩ fɩɩ san fɩɩ tɔɔrɔɔ ɔkaapʋpʋ mʋ?” ");
INSERT INTO naw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nɩɩ Yesu lɛɛ mu ansi yɛgɛ bamʋ, nɩɩ ɔ tɔwɛ Gyarosi yɛ, “Man waa kufuu, dan kɔɔlɛ gyii kanɩn.” ");
INSERT INTO naw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nɩɩ ɔ man bɩla yɛgɛ ɔkʋ buu mʋ tii Pita yɛ Gyemisi yɛ mu‐supu Gyɔn sʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ba maa fʋʋ Gyarosi kɩkpaara sʋ mʋ, ba wu asa ba maa waa ɩlawʋ bɛɛ sawʋ kenken. ");
INSERT INTO naw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nɩɩ Yesu loo taasɛ bamʋ fɛɛ, “Mɩnɛ nɩɩ fɛn waa kanɩn? Mɩnɛ kusu nɩɩ fen su kanɩn? Kebii mʋ man wu, ɔ dɛ nsɩɩrɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nɩɩ asa mʋ ba ŋmasɛ mʋ. Nɩɩ ɔ gya bamʋ kpini lɩɩ kewu, nɩɩ maa kebii mʋ mʋ‐sɛ yɛ mu‐nyi yɛ mʋ abɩɩlapʋ asa mʋ ba loo obu mʋ nɩɩ kebii kyɩɩsa‐bi mʋ dɛ kɩmʋ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nɩɩ ɔ kɩtaa kebii kyɩɩsa‐bi mʋ kɩbaa tɔ nɩɩ ɔ tɔwɛ yɛ, “Talita kuum.” Kɩmʋ kasɛ ɩ gyɛ fɛɛ, “Kebii kyɩɩsa‐bi, n yɛ fʋ kʋsʋ.” ");
INSERT INTO naw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Opula tɔ nɩɩ kebii mʋ kʋsʋ, nɩɩ ɔ natɛ. Kebii mʋ gyii nsu kudu anyɔ. Nɩɩ asɩn mʋ i kyinkyin bamʋ gaa. ");
INSERT INTO naw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nɩɩ Yesu sa bamʋ kɔnɔ yɛ ba man kan tɔwɛ ɔkʋ kanɩn asɩn nɩmʋ. Nɩɩ ɔ tɔwɛ bamʋ fɛɛ ba sa kebii mʋ agyitɔ kɛ o gyii. ");
INSERT INTO naw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nɩɩ Yesu lɩɩ tʋtɔ bwii kpee mʋ gbaa‐gbaa kadɛ tɔ, nɩɩ mʋ abɩɩlapʋ ba buu mʋ kpee. ");
INSERT INTO naw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kakɛ fʋʋtɛsa akɛ, o kpee kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa ɛɛ kaapʋ. Nɩɩ mʋ kɩkaapʋ mʋ ki kyinkyin asa mʋ nɩɩ ba nu mʋ gaa, nɩɩ ba taasɛ abaa yɛ, “Fɩnɛ nɩɩ ɔ nyɛ kɩkaapʋ nɩmʋ lɩɩ? Fɩnɛ nɩɩ ɔ nyɛ kanyaasɩn nɩmʋ lɩɩ halɩɩ ɛɛ waa asɩn kyinkyinsa anɩmʋ? ");
INSERT INTO naw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Man gyɛ kapinta mʋ ndee? Man gyɛ Mɛɛrɩ mu‐bii mʋ nɩn? Man gyɛ mu‐supu ana ɩ gyɛ Gyemisi yɛ Gyosefu yɛ Gyuda yɛ Simon? Man gyɛ anaa mʋ‐pɩɩkyɩɩ ana ɩ bʋ nfɩɩ?” Nɩɩ ba kina kɩkɔɔlɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Ɩbwaarɛ ɔtɔwɛpʋ kʋmaa nɩmʋ sʋ bɛɛrɛɛ katɩn kʋmaa, amɔɔ mʋ kadɛ tɔ yɛ mʋ kɩkpaara sʋ abi nkʋn asɛ nɩɩ ɔ man sʋ bɛɛrɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kanɩn sʋ mʋ, ɔ man taalɛ waa adangana tʋtɔ kʋkyɔ, amɔɔ asa kalɩsa akʋ nɩɩ ɔ taa mʋ abaa gyaga bamʋ sʋ nɩɩ ba nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nɩɩ i kyinkyin mʋ gaa lɩɩ fɛɛ asa mʋ ba man kɔɔlɛ mʋ gyii. Nɩɩ Yesu kpee ndɛ‐bii mʋ nɩɩ ɩ maa mʋ kadɛ, ɛɛ kaapʋ bamʋ abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nɩɩ ɔ tɩɩ mʋ abɩɩlapʋ kudu anyɔ mʋ, o sun bamʋ anyɔ‐anyɔ, nɩɩ ɔ sa bamʋ ɔlʋn yɛ ba taa gya nbwɩɩ libi. ");
INSERT INTO naw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nɩɩ ɔ tɔwɛ bamʋ fɛɛ, “Fan maa kpee falɛ, fan man taa sɛhn, amɔɔ fanɛ akpebi nkʋn. Fan man taa agyitɔ abɛɛ adiikun abɛɛ afulee waa fanɛ igyifa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Fan waa asɩbɩta, amaa fan man taa ɩkaalɛ ɩkʋ kɩtaa tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kɩkpaara kʋmaa mʋ nɩɩ ba kɔɔlɛ fanɛ mʋ, fan kyɩna tʋtɔ naa fʋʋ saŋa mʋ nɩɩ fen biti fan lɩɩ kadɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nɩɩ fan kan kpee kadɛ kʋ tɔ, nɩɩ ɔkʋ man kɔɔlɛ fanɛ abɛɛ nu fanɛ asɛ mʋ, nɩɩ fan kan fɛn lɩɩ kanɩn kadɛ maŋa tɔ mʋ, fan kpɩkpaa fanɛ ayaa tɔ ɩsɛ wʋrɩgɛ tʋtɔ, kɛ ɩmʋ ii biti i gyii bamʋ.” ");
INSERT INTO naw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nɩɩ ba kpee naa tɔwɛ abwaarɛsɩn sa asa yɛ ba yɛgɛ alibi kɩwaa. ");
INSERT INTO naw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nɩɩ ba gya nbwɩɩ libi damantɛ kʋsʋ asa sʋ, nɩɩ ba sʋswa alɔpʋ damantɛ olifu nfɔ nɩɩ ba nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Owura Herodi nu kʋtɔ mʋ nɩɩ kii kpee sʋ kpini, lɩɩ fɛɛ Yesu kɔɔlɛ kɩtɩɩ katɩn kʋmaa. Akʋ ba tɔwɛ yɛ Gyɔn okyugyeepu mʋ ɩ bɩla kyiŋi, ɩmʋ sʋ nɩɩ ɛɛ taalɛ ɛɛ waa kanɩn asɩn kyinkyinsa. ");
INSERT INTO naw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Akʋ mɔɔ ba yɛ ɔ gyɛ Eligya nɩn, nɩɩ akʋ mɔɔ ba yɛ ɔ gyɛ Ɩbwaarɛ atɔwɛpʋ dɩdaa mʋ tɔ ɔkʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodi maa nu Yesu asɩn mʋ, nɩɩ ɔ yɛ, “Ɔ gyɛ Gyɔn okyugyeepu nɩn. Mɛ ɩ yɛgɛ nɩɩ ba tɩn mu kumu, amaa o bwii ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodi ɩ daa yɛgɛ nɩɩ ba kɩtaa Gyɔn okyugyeepu, nɩɩ ba taa agbeeleebi da mʋ, nɩɩ ba taa mʋ tii obu. Kʋtɔ mʋ sʋ nɩɩ ɔ waa kanɩn mʋ ɩ gyɛ fɛɛ, mʋ‐ka Herodiya mʋ nɩɩ o kili mʋ, ɔ kɔɔlɛ mʋ lɩɩ mu‐supu Filipu asɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Lɩɩ fɛɛ saŋa kʋmaa Gyɔn okyugyeepu ɩɩ tɔwɛ mʋ yɛ ɩ man dagaa maa kɔɔlɛ mu‐supu mʋ‐ka kili. ");
INSERT INTO naw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kanɩn sʋ nɩɩ Gyɔn okyugyeepu nyɛ kilibi Herodiya asɛ, nɩɩ ee biti ɔ mɔɔ mʋ, amaa ɔ man taalɛ. ");
INSERT INTO naw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodi sɩlɛ Gyɔn okyugyeepu, lɩɩ fɛɛ o nyi maa gyɛ nyɩmɩsa danbɩrasa yɛ nyɩmɩsa kyɩrɛkyɩrɛ, ɩmʋ sʋ nɩɩ o kun mʋ. Herodi ii biti Gyɔn abwaarɛsɩn kunu, amaa saŋa kʋmaa mʋ nɩɩ o nu ɩmʋ mʋ ɩɩ tɔɔrɔɔ mʋ gaa. ");
INSERT INTO naw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodiya ba nyɛ mu kebiti saŋa mʋ nɩɩ mu‐kuli Herodi i gyii mʋ kakɛ kʋʋgɛsa akɛ. Owura Herodi dɩŋa agyitɔ, nɩɩ ɔ tɩɩ kɩbanɛ abɩlɩsa yɛ anaakɔpʋ abɩlɩsa yɛ Galile abɩlɩsa kparɛ‐kparɛ yɛ ba be gyii bamʋ ansi. ");
INSERT INTO naw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nɩɩ Herodiya mu‐bii kyɩɩsa lɩɩ ba kyaa, nɩɩ i gyii Herodi yɛ mʋ afɔ ansi gaa. Nɩɩ ɔ tɔwɛ kebii mʋ yɛ, “Taasɛ mɛ kʋtɔ kʋmaa mʋ nɩɩ fii biti kɛ n sa fʋ.” ");
INSERT INTO naw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nɩɩ ɔ bɔ ntan yɛ, “Kʋtɔ kʋmaa mʋ nɩɩ fii biti mʋ n biti n sa fʋ, halɩɩ mi kuwura‐gyii mʋ kɩbaafʋn gbaa.” ");
INSERT INTO naw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nɩɩ kebii mʋ lɩɩ ɩkaa sʋ naa taasɛ mu‐nyi kʋtɔ mʋ nɩɩ ɔ kɔɔlɛ lɩɩ Owura Herodi asɛ. Nɩɩ ɔ yɛ, “Tɔwɛ mʋ yɛ fii biti Gyɔn okyugyeepu mu kumu.” ");
INSERT INTO naw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nɩɩ kebii mʋ waa bilen bwii kpee Owura Herodi asɛ naa tɔwɛ mʋ yɛ, “N biti Gyɔn okyugyeepu kumu tangɩran sʋ nbɩɩnbɩɩ nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nɩɩ Owura Herodi kɔkɔlɔ ki nyita mʋ gaa, amaa ɔ man taalɛ kina lɩɩ kanan mʋ nɩɩ ɔ tɛɛ bɔ ntan mʋ afɔ ansi tɔ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nɩɩ o sun ɔnaakɔpʋ kʋlʋn yɛ ɔ naa bɩya Gyɔn kumu. Nɩɩ o kpee obu tiisa mʋ tɔ naa tɩn mʋ Gyɔn kumu. ");
INSERT INTO naw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nɩɩ ɔ taa gyaga tangɩran sʋ taa ba sa kebii kyɩɩsa‐bi mʋ. Nɩɩ kebii mʋ taa naa sa mu‐nyi. ");
INSERT INTO naw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gyɔn okyugyeepu abɩɩlapʋ ba maa nu kanɩn mʋ, nɩɩ ba ba taa mu kibuni sansa naa pula. ");
INSERT INTO naw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu asunpu mʋ ba bwii ba Yesu asɛ ba tɔwɛ mʋ kʋtɔ mʋ nɩɩ ba waa yɛ ɩmʋ nɩɩ ba kaapʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lɩɩ kanan mʋ nɩɩ asa kʋkyɔ bɛɛ ba Yesu asɛ bee bwii sʋ mʋ, ba man nyɛ saŋa ba gyii. Nɩɩ Yesu tɔwɛ bamʋ fɛɛ, “Fan yɛgɛ a lɩɩ ɩkaa sʋ kpee opula mʋ nɩɩ asa ba man bʋ, kɛ fan nyɛ saŋa fʋʋtɛ gbɛrɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nɩɩ ba loo ɔkʋlɩ tɔ bamʋ nkʋn bee kpee katɩn mʋ nɩɩ ɔkʋ man bʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amaa asa damantɛ ba wu bamʋ, nɩɩ ba bɩɩ bamʋ, nɩɩ ba waa bilen taa ayaa tɔ sɩlɛ lɩɩ ndɛ mʋ tɔ kpini gyankpaa naa gyoo bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu maa lɩɩ ɔkʋlɩ tɔ, nɩɩ o wu sakyɔ mʋ, bamʋ asɩn ɩ kɩtaa mʋ kʋwɛɛ, lɩɩ fɛɛ ba du nɩn fɛɛ nbʋlʋpʋ mʋ nɩɩ ba man sʋ ɔkpapʋ. Tʋtɔ nɩɩ o piili ɛɛ kaapʋ bamʋ atɔ damantɛ. ");
INSERT INTO naw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɩ maa sʋ ii kpee kalaatɩpwɛɛ asɛ mʋ, Yesu abɩɩlapʋ ba ba tɔwɛ mʋ yɛ, “Kyɔwɛ tɛɛ ɛɛ lʋwɛ. Nɩɩ nfɩɩ mɔɔ waa opula mʋ nɩɩ ɩ waa ɩkaa sʋ, nɩɩ sɛhn man bʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ɩmʋ sʋ yɛgɛ ba kpee ndɔɔ ana tɔ yɛ ndɛ‐bii mʋ nɩɩ ɩ maa anɛ mʋ naa sɔɔ kʋtɔ kʋ gyii.” ");
INSERT INTO naw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fanɛ gbaa‐gbaa fan sa bamʋ kʋtɔ kʋ kɛ ba gyii.” Nɩɩ ba taasɛ Yesu yɛ, “Fii biti fɛɛ a taa gbiti nderebi anyɔ naa sɔɔ bodobodo sa bamʋ?” ");
INSERT INTO naw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nɩɩ Yesu taasɛ bamʋ yɛ, “Bodobodo afɩnɛ nɩɩ fan su? Fan naa kɩɩ.” Ba maa naa kɩɩ mʋ, nɩɩ ba ba tɔwɛ mʋ yɛ, “Bodobodo inuu yɛ ɩkɩn ɩnyɔ nɩɩ an sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ ba yɛgɛ asa mʋ ba kyɩna kʋbʋ‐kʋbʋ afitiri bunboli sʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nɩɩ asa mʋ ba kyɩna kʋbʋ‐kʋbʋ buu abaa, akʋ kɩlɩfa akʋ mɔɔ adunuu. ");
INSERT INTO naw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nɩɩ Yesu taa bodobodo inuu yɛ ɩkɩn ɩnyɔ mʋ, nɩɩ o diyaa mu ansi kɩɩ sʋsʋ, nɩɩ ɔ fwaala Ɩbwaarɛ. Nɩɩ ɔ taa sa abɩɩlapʋ mʋ, nɩɩ ba barɩgɛ sa asa mʋ kpini. Nɩɩ ɔ bɩla barɩgɛ ɩkɩn mʋ tɔ sa asa mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nɩɩ ɔkʋmaa nɩmʋ gyii naa fʋʋ mʋ ɔkaa. ");
INSERT INTO naw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nɩɩ abɩɩlapʋ mʋ ba tasɛ bodobodo yɛ ɩkɩn mʋ nɩɩ ɩ san mʋ waa alantan kudu anyɔ tɔ, nɩɩ ɩ bɔla. ");
INSERT INTO naw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Anyɩn mʋ nɩɩ ba gyii agyitɔ mʋ ba gyɛ ngbɩn nnuu. ");
INSERT INTO naw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Opula maŋa tɔ nɩɩ Yesu yɛgɛ nɩɩ mʋ abɩɩlapʋ ba taa ɔkʋlɩ gyankpaa mʋ, bee kpee Betisayida mʋ nɩɩ kɩ bʋ benbe. Nɩɩ mɔɔ mʋ lɛɛ asa mʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Maa kala bamʋ lʋwɛ mʋ, nɩɩ o kpee kɩbɩɩ sʋ, ɛɛ kʋlɛ Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ɩ maa ba fʋʋ kalaatɩpwɛɛ asɛ mʋ, abɩɩlapʋ mʋ ba fʋʋ nkyu mʋ nsana, yɛgɛ Yesu nkʋn mɔɔ bʋ kidenbi sʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nɩɩ Yesu wu fɛɛ kɩpalɛ mʋ ki nu abɩɩlapʋ mʋ, lɩɩ fɛɛ apaa mʋ ɩ gyaŋa bamʋ. Kɩbwaayɩkɛ sʋ mʋ, Yesu natɛ nkyu sʋ naa fʋʋ bamʋ asɛ nɩɩ ee biti ɔ kyʋn bamʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Amaa ba wu maa naa nkyu mʋ sʋ, be nyi fɛɛ obuni nɩn, nɩɩ ba waa ɩlawʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Saŋa mʋ nɩɩ ba wu Yesu mʋ, kufuu kɩ kɩtaa bamʋ kpini gaa. Nɩɩ Yesu tɔwɛ bamʋ asɛ opula tɔ yɛ, “Fan nyɛ nkɔlɔ, fan man waa kufuu, mɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nɩɩ Yesu loo bamʋ asɛ ɔkʋlɩ mʋ tɔ, nɩɩ afuu mʋ a yɔɔ opula tɔ. Nɩɩ i kyinkyin abɩɩlapʋ mʋ gaa, ");
INSERT INTO naw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","lɩɩ fɛɛ ba man taalɛ nu kanan mʋ nɩɩ Yesu sa anyɩn ngbɩn nnuu agyitɔ mʋ kasɛ. Nɩɩ ɩ kɩtaa bamʋ nfɛɛrɛ gaa. ");
INSERT INTO naw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nɩɩ ba faa kpee benbe ɔsʋwʋlɛ mʋ nɩɩ ba tɩɩ yɛ Kanesareti, nɩɩ ba taa bamʋ ɔkʋlɩ dan. ");
INSERT INTO naw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba maa dan bɛɛ lɩɩ ɔkʋlɩ tɔ mʋ, asa ba bɩɩ Yesu. ");
INSERT INTO naw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nɩɩ asa ba sɩlɛ lɩɩ ɔsʋwʋlɛ maŋa sʋ kpini bɛɛ ba Yesu asɛ, nɩɩ ba taa alɔpʋ mʋ nɩɩ ba dɛ ɩkalan sʋ bɩya mʋ. ");
INSERT INTO naw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Katɩn kʋmaa mʋ nɩɩ Yesu kpee ndɛ‐bii abɛɛ ndɛ lala tɔ yɛ ndɔɔ ana tɔ mʋ, asa bɛɛ kpiya alɔpʋ agya tɔ yɛgɛ bɛɛ kʋlɛ mʋ yɛ ɔ yɛgɛ ba mata mʋ kaalɛ. Bamʋ nɩɩ ba mata mʋ kaalɛ kpini mʋ, ba nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farasii abi yɛ nbara akaapʋpʋ mʋ akʋ, mʋ nɩɩ ba lɩɩ Gyerusalem ba Yesu asɛ mʋ, ba sarɛ kyaabɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tʋtɔ nɩɩ ba wu fɛɛ Yesu abɩɩlapʋ ba tɛ bee gyii agyitɔ yɛgɛ ba man fwɩɩ bamʋ abaa kanan mʋ nɩɩ bamʋ adɩdaasɩn ɩɩ kaapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Lɩɩ fɛɛ Farasii abi mʋ yɛ Gyiwu abi kpini ba buu bamʋ naana ana kɩkaapʋ dɩdaa mʋ nɩn, ba mɛɛ yɛ ba gyii agyitɔ, amɔɔ ba fwɩɩ bamʋ abaa kanan mʋ nɩɩ bamʋ adɩdaasɩn mʋ ɩɩ kaapʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nɩɩ ba kan lɩɩ kɩgya tɔ ba mʋ, ba mɛɛ yɛ ba gyii, amɔɔ ba fwɩɩ bamʋ n‐yɩɩ pɔyɩ. Nɩɩ ba bɩla ba sʋ ikisii lɩɩ ɩkɔɔpʋ yɛ npulii yɛ ɩtasa atɔ kɩfwɩɩ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ɩmʋ sʋ, nɩɩ Farasii abi mʋ yɛ Ɩbwaarɛ nbara akaapʋpʋ mʋ ba taasɛ Yesu yɛ, “Mɩnɛ kʋtɔ sʋ nɩɩ fʋ abɩɩlapʋ bɩrɛ be mee buu anɛ naana ana kɩkaapʋ dɩdaa mʋ, nɩɩ ba mɛɛ bamʋ bɩrɛ ba sʋ abaa mʋ nɩɩ ɩ man du kyɩrɛkyɩrɛ bee gyii agyitɔ?” ");
INSERT INTO naw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Asɩn mʋ nɩɩ Ɩbwaarɛ bɔla mʋ ɔtɔwɛpʋ Isaya sʋ nɩɩ ɔ kyʋrɔɔ yɩla lɩɩ fanɛ sʋ mʋ, ɩ gyɛ kesintin. Ɩbwaarɛ tɔwɛ yɛ, ‘Fan sʋ fanɛ nnɔ fɛn tɔwɛ yɛ fen sun mɛ, yɛgɛ ɩ man lɩɩ fanɛ nkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kɩyan nɩɩ fen sun mɛ, lɩɩ fɛɛ nyɩmɩsa ɩkpa nɩɩ fɛn sʋ fɛn kaapʋ fɛɛ mɛ, Ɩbwaarɛ lɛɛ.’ ” ");
INSERT INTO naw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nɩɩ Yesu kyaga sʋ tɔwɛ yɛ, “Fan kina Ɩbwaarɛ nbara mʋ, nɩɩ fan buu nyɩmɩsa lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nɩɩ Yesu bɩla tɔwɛ yɛ, “Fan sʋ kanyaasɩn ɩkpa libi mʋ nɩɩ fɛn sʋ fɛn taa Ɩbwaarɛ nbara yɩlɛ ɩkaa sʋ, kɛ fan nyɛ buu nyɩmɩsa kɩkaapʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesi kaapʋ yɛ, ‘Taa bɛɛrɛɛ sa fʋ‐sɛ yɛ fu‐nyi, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ tɔwɛ nnɔ wʋrɩgɛ mʋ‐sɛ abɛɛ mu‐nyi sʋ mʋ, ba mɔɔ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amaa fanɛɛ fanɛ, fɛn yɛ nɩɩ ɔkʋ kan tɔwɛ mʋ‐sɛ abɛɛ mu‐nyi yɛ, ‘Kʋtɔ mʋ nɩɩ naafɔɔ fii biti fʋ nyɛ lɩɩ mɛ asɛ mʋ ɩ gyɛ Koriban.’ (Kɩmʋ kasɛ ɩ gyɛ kʋtɔ mʋ nɩɩ ba taa kɛɛ Ɩbwaarɛ). ");
INSERT INTO naw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kanɩn sʋ mʋ, ɔ sʋ ɔkpa fɛɛ o kina kɩkyɛ mʋ‐sɛ yɛ mu‐nyi tɔ. ");
INSERT INTO naw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kanɩn kɩkaapʋ mʋ nɩɩ fan sʋ fɛn kaapʋ asa falɛ ɩɩ yɛgɛ abwaarɛsɩn mʋ ii biliŋi kɩyan. Atɔ damantɛ fɛɛ ɩnɩmʋ nɩɩ fɛn waa.” ");
INSERT INTO naw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nɩɩ Yesu bɩla tɩɩ asa ba sarɛ mʋ asɛ, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Ɔkʋmaa nɩmʋ o nu mɛ asɛ, kɛ ɔ bɩɩ asɩn nɩmʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sɛhn man bʋ tɔ nɩɩ ɩɩ lɩɩ kewu ii loo nyɩmɩsa tɔ nɩɩ ɩɩ waa mʋ ineesi, amɔɔ asɩn mʋ nɩɩ ɩɩ lɩɩ mʋ tɔ mʋ ɩɩ waa mʋ ineesi. ");
INSERT INTO naw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ɔkʋmaa mʋ nɩɩ ɔ sʋ asʋ mʋ o nu.” ");
INSERT INTO naw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu maa lɩɩ asa mʋ asɛ kpee kɩkpaara sʋ mʋ, nɩɩ mʋ abɩɩlapʋ mʋ ba taasɛ mʋ kɩŋasan mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nɩɩ Yesu taasɛ bamʋ fɛɛ, “Ɩmʋ sʋ, fanɛ gbaa fen mee nu asɩn kasɛ bilen? Fan man nyi fɛɛ kʋtɔ kʋ man bʋ tɔ kɩɩ lɩɩ kewu nɩɩ kii loo nyɩmɩsa tɔ nɩɩ kɩɩ waa mʋ ineesi. ");
INSERT INTO naw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Lɩɩ fɛɛ kʋtɔ kʋmaa mʋ nɩɩ kii loo nyɩmɩsa tɔ mʋ, ki mee kpee mʋ kɔkɔlɔ tɔ, amɔɔ mʋ ɔtɔ tɔ, kɛ kɩ bɩla bɔla lɩɩ mʋ n‐yɩɩ tɔ.” (Yesu katɔwɛ mʋ kɩ kaapʋ fɛɛ agyitɔ gyisa kʋmaa i du kyɩrɛkyɩrɛ.) ");
INSERT INTO naw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nɩɩ Yesu kyaga sʋ tɔwɛ yɛ, “Kʋtɔ mʋ nɩɩ kɩɩ lɩɩ nyɩmɩsa tɔ mʋ, kɩmʋ ɩɩ waa mʋ ineesi. ");
INSERT INTO naw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lɩɩ fɛɛ lɩɩ nyɩmɩsa tɔ, yɛ mʋ kɔkɔlɔ tɔ nɩɩ nfɛɛrɛ libi yɛ kɩbawʋlɛ kigyii, yɛ keyu, yɛ asa kɩmɔɔ yɛ kɩlɩɩ okuli abɛɛ ɔkaa kamaa, ");
INSERT INTO naw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yɛ kensi payɩ libi yɛ kumu tɔ ɔlʋn, yɛ kapɩna asa, yɛ kɩgyagaa, yɛ kayɩɩ basa yɛ nyɩmɩsa kinyita yɛ alala‐sɩn yɛ kimelensi. ");
INSERT INTO naw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ɩnɩmʋ kpini ɩɩ lɩɩ nyɩmɩsa kɔkɔlɔ tɔ nɩn, nɩɩ ɩɩ waa mʋ ineesi.” ");
INSERT INTO naw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nɩɩ Yesu lɩɩ Galile kpee Taayi katɩnɛ. Nɩɩ o loo kɩkpaara kʋ sʋ, ɔ man daa ee biti fɛɛ ɔkʋ o wu mʋ, amaa ɔ man taalɛ baala mʋ n‐yɩɩ. ");
INSERT INTO naw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ɔkyɩɩ kʋ mʋ nɩɩ nbwɩɩ libi ba tɛ mu‐bii sʋ mʋ nu Yesu sʋ, nɩɩ ɔ ba mʋ asɛ bilen ba muŋa mʋ ayaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ɔkyɩɩ mʋ man gyɛ Gyiwu obii, ɔ lɩɩ Fonesiya mʋ nɩɩ kɩ bʋ Siriya ɔsʋwʋlɛ sʋ mʋ nɩn. Nɩɩ ɔ kʋlɛ Yesu yɛ ɔ gya nbwɩɩ libi mʋ lɩɩ mu kebii kyɩɩsa‐bi mʋ sʋ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nɩɩ Yesu tɔwɛ ɔkyɩɩ mʋ yɛ, “Ɩ dagaa nbii mʋ ba maa gyii ŋmɛ pɔyɩ. Ɩ man bʋrɔn fɛɛ ba taa nbii agyitɔ sa igyoonɔ.” ");
INSERT INTO naw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nɩɩ ɔkyɩɩ mʋ sa kɔnɔ yɛ, “Ɔnyɩrɩpɛ, ɩ gyɛ kesintin nɩn, amaa nbii ba kan bee gyii agyitɔ nɩɩ ɩkʋ ɩ lɩɩ tɩyɛ kasɛ mʋ, igyoonɔ bɛɛ tasɛ bee gyii.” ");
INSERT INTO naw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nɩɩ Yesu sa ɔkyɩɩ mʋ kɔnɔ yɛ, “Lɩɩ kanan mʋ nɩɩ fʋ sa mɛ kɔnɔ sʋ mʋ, bwii kpewu, nbwɩɩ libi mʋ ba lɩɩ fu kebii kyɩɩsa‐bi mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nɩɩ ɔkyɩɩ mʋ bwii kpewu naa wu kebii mʋ maa dɛ npaa sʋ yɛgɛ nbwɩɩ libi mʋ ba tɛɛ wʋla lɩɩ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nɩɩ Yesu lɩɩ Taayi katɩnɛ, nɩɩ ɔ bɔla Sidon kpee Galile ɔbʋn‐kaa naa fʋʋ Dekapoli (Ndɛ kudu) ɩsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tʋtɔ nɩɩ asa akʋ ba taa kpawu kʋ nɩɩ ɔ mɛɛ taalɛ ɔ tɔwɛ yɛ ɔ dan ba Yesu asɛ ba kʋlɛ mʋ yɛ ɔ taa mʋ abaa gyaga mʋ sʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nɩɩ Yesu taa kpawu mʋ lɩɩ asa tɔ kpee ɩkaa sʋ, taa mʋ abaa‐bi waa mʋ asʋ tɔ. Nɩɩ ɔ tʋʋ nkyɔlɛ nɩɩ ɔ mata mʋ kanandʋlʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nɩɩ Yesu diyaa mu ansi kɩɩ sʋsʋ, nɩɩ o muusi. Nɩɩ ɔ tɔwɛ ɔnyɩn mʋ yɛ, “Ɩfata.” Kɩmʋ kasɛ ɩ gyɛ yɛ, “Bugi tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Opula tɔ nɩɩ ɔnyɩn mʋ asʋ a tigi, nɩɩ ee nu katɔwɛ, nɩɩ ɛɛ taalɛ ɛɛ tɔwɛ danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nɩɩ Yesu tɔwɛ asa mʋ yɛ ba man kan tɔwɛ sa ɔkʋ. Amaa kɩgya damantɛ nɩɩ ɔ gya bamʋ mʋ, saamʋ nɩɩ bɛɛ lɔŋɔ bɛɛ tɔwɛ bee tii sʋ. ");
INSERT INTO naw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nɩɩ i kyinkyin asa mʋ gaa nɩɩ ba yɛ, “Ɔ waa kʋtɔ kʋmaa nɩmʋ danbɩrasa. Ɔ yɛgɛ nɩɩ akpawu bee nu, nɩɩ anaamuu bɛɛ tɔwɛ.” ");
INSERT INTO naw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kanɩn nkɛ maŋa tɔ mʋ, sakyɔ damantɛ kʋ bɩla ba sarɛ Yesu asɛ. Nɩɩ ba maa man sʋ agyitɔ akʋ ba gyii mʋ, Yesu tɩɩ mʋ abɩɩlapʋ mʋ ba mʋ asɛ nɩɩ ɔ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Asa nɩmʋ asɩn ɩ sʋ mɛ kʋwɛɛ, lɩɩ fɛɛ ndaga nkɛ nsa ndee ba maa bʋ mɛ asɛ, nɩɩ ba man sʋ agyitɔ akʋ ba gyii. ");
INSERT INTO naw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nɩɩ n kan tɔwɛ bamʋ yɛ ba bwii kpewu mʋ, bee biti ba naa kirin‐kirin ɔkpa tɔ, lɩɩ fɛɛ bamʋ akʋ ba lɩɩ kata‐kata.” ");
INSERT INTO naw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nɩɩ abɩɩlapʋ mʋ ba taasɛ Yesu yɛ, “Fɩnɛ nɩɩ an biti a nyɛ agyitɔ kiperi kɩnɩmʋ sʋ sa asa damantɛ nɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nɩɩ Yesu taasɛ bamʋ yɛ, “Bodobodo afɩnɛ nɩɩ fan sʋ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Asunɔ nɩɩ an sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nɩɩ Yesu yɛgɛ nɩɩ asa mʋ ba kyʋn kyɩna kasɛ. Nɩɩ ɔ taa bodobodo asunɔ mʋ, nɩɩ ɔ fwaala Ɩbwaarɛ nɩɩ ɔ kpɛɛ‐kpɛɛ ɩmʋ tɔ taa sa mʋ abɩɩlapʋ mʋ yɛ ba barɩgɛ tɔ sa asa mʋ ba gyii, nɩɩ ba barɩgɛ tɔ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nɩɩ Yesu bɩla taa ɩkɩn gbɛrɛɛ mʋ nɩɩ ba sʋ mʋ, fwaala Ɩbwaarɛ bɩla sa mʋ abɩɩlapʋ yɛ ba barɩgɛ ɩmʋ tɔ sa asa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nɩɩ asa mʋ kpini ba gyii ŋmɛ. Nɩɩ mʋ abɩɩlapʋ mʋ ba tasɛ‐tasɛ bamʋ agyisan mʋ bɔla alantan asunɔ. ");
INSERT INTO naw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Asa mʋ nɩɩ ba gyii kanɩn agyitɔ maŋa mʋ, ba gyɛ asa ngbɩn nna. Ɩmʋ kamaa tɔ, nɩɩ Yesu yɛgɛ bamʋ, nɩɩ ba kpewu. ");
INSERT INTO naw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Opula maŋa tɔ, nɩɩ Yesu maa mʋ abɩɩlapʋ mʋ ba loo ɔkʋlɩ tɔ faa kyʋn Dalimanuta ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farasii abi akʋ ba ba Yesu asɛ ba gyii mʋ ɩmɔɔrɛ, kɛ ba nyɛ wu mʋ kilibi. Nɩɩ ba tʋʋ Yesu tɔ kɩɩ yɛ ɔ waa sʋsʋ adangana akʋ kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tʋtɔ nɩɩ o muusi, nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ sʋ nɩɩ fanɛ nbɩɩnbɩɩ asa fen biti adangana fen wu? N biti n tɔwɛ fanɛ kesintin yɛ, n mɛɛ yɛ n waa kanɩn adangana maŋa kaapʋ fanɛ kpaa.” ");
INSERT INTO naw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nɩɩ Yesu yɛgɛ bamʋ tʋtɔ naa loo mʋ ɔkʋlɩ tɔ faa kyʋn benbe. ");
INSERT INTO naw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu abɩɩlapʋ mʋ ba tan sʋ fɛɛ ba maa man taa bodobodo kʋkyɔ, amaa bodobodo kukuli kʋlʋn ɩ bʋ bamʋ asɛ ɔkʋlɩ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan kɩɩ danbɩrasa kɛ fan baa fan da fanɛ n‐yɩɩ sʋ, lɩɩ Farasii abi yɛ Herodi asa bamʋ kɩfɛ mʋ nɩɩ kii tin bodobodo mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nɩɩ mʋ abɩɩlapʋ ba piili bɛɛ tɔwɛ abaa yɛ, “A maa man lɛɛ bodobodo kʋkyɔ sʋ nɩɩ ɛɛ tɔwɛ kanɩn mʋ abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu maa bɩɩ kʋtɔ mʋ nɩɩ bɛɛ tɔwɛ mʋ, nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ sʋ nɩɩ fɛn tɔwɛ fanɛ kɩman sʋ bodobodo kʋkyɔ mʋ asɩn? Ɩmʋ sʋ, fan man pɩɩta bɩɩ mɛ awaasa kasɛ? Mɩnɛ ɩ waa nɩɩ fanɛ nfɛɛrɛ ɩ mɛɛ taalɛ ɩ kɩtaa atɔ bilen kanɩn? ");
INSERT INTO naw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Fan sʋ ansi, fan man kɩɩ? Nɩɩ fan sʋ asʋ, fan mee nu? Fen mee nyiŋi asɩn nɩn abɛɛ? ");
INSERT INTO naw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Saŋa mʋ nɩɩ n taa bodobodo anuu barɩgɛ sa asa ngbɩn nnuu nɩɩ ba gyii mʋ, alantan afɩnɛ nɩɩ fan tasɛ agyisan mʋ bɔla?” Nɩɩ ba yɛ, “Alantan kudu anyɔ.” ");
INSERT INTO naw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nɩɩ Yesu bɩla taasɛ yɛ, “N maa taa bodobodo asunɔ barɩgɛ tɔ sa asa ngbɩn nna nɩɩ ba gyii mʋ, alantan afɩnɛ nɩɩ fan tasɛ agyisan mʋ bɔla?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Alantan asunɔ.” ");
INSERT INTO naw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nɩɩ Yesu yɛ, “Ɩnɩmʋ kpini kamaa mʋ, fan man taalɛ bɩɩ ɩmʋ kasɛ?” ");
INSERT INTO naw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nɩɩ Yesu maa mʋ abɩɩlapʋ mʋ ba kpee Betisayida kadɛ tɔ, nɩɩ asa akʋ ba taa gyaatanapʋ kʋ ba kʋlɛ Yesu fɛɛ ɔ taa mʋ kɩbaa mata mʋ. ");
INSERT INTO naw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nɩɩ Yesu kɩtaa gyaatanapʋ mʋ kɩbaa tɔ, taa mʋ lɩɩ kadɛ mʋ nbwama. Nɩɩ Yesu tʋʋ nkyɔlɛ waa mu ansi tɔ, nɩɩ ɔ taa mʋ abaa gyaga mʋ sʋ, nɩɩ ɔ taasɛ mʋ yɛ, “Fɩɩ wu atɔ?” ");
INSERT INTO naw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nɩɩ gyaatanapʋ mʋ diyaa mu ansi sʋsʋ, nɩɩ ɔ yɛ, “N wu asa ba maa naa, nɩɩ ba du fɛɛ iyu ɩ maa naa mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nɩɩ Yesu bɩla taa mʋ abaa gyaga ɔnyɩn mu ansi sʋ, nɩɩ mu ansi mʋ i bugi, nɩɩ mu ansi mʋ ɩ nyɛ alanfɩya, ɩɩ kɩɩ danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nɩɩ Yesu tɔwɛ gyaatanapʋ mʋ yɛ, “Kpewu! Amaa man bɩla bwii kpee kadɛ mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nɩɩ Yesu maa mʋ abɩɩlapʋ mʋ ba kpee ndɛ‐bii mʋ nɩɩ ɩ bʋ Kasariya Filipi kadɛ mʋ asɛ. Ba maa kpee mʋ, nɩɩ Yesu taasɛ mʋ abɩɩlapʋ yɛ, “Anɩmʋ nɩɩ asa ba yɛ n gyɛ?” ");
INSERT INTO naw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Akʋ ba yɛ fʋ ɩ gyɛ Gyɔn okyugyeepu mʋ, akʋ mɔɔ ba yɛ fʋ ɩ gyɛ Eligya, nɩɩ akʋ mɔɔ ba yɛ fʋ ɩ gyɛ Ɩbwaarɛ atɔwɛpʋ mʋ tɔ ɔkʋ.” ");
INSERT INTO naw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nɩɩ Yesu taasɛ yɛ, “Nɩɩ fanɛ mɔɔ, fan yɛ anɩmʋ nɩɩ n gyɛ?” Nɩɩ Pita lɛɛ kɔnɔ yɛ, “Fʋ ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nɩɩ Yesu gya bamʋ yɛ ba man kan tɔwɛ ɔkʋ ɔsa mʋ nɩɩ ɔ gyɛ. ");
INSERT INTO naw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nɩɩ Yesu piili ɛɛ tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Ɩ dagaa fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa maa wu awʋrʋfɔ gaa, kɛ Gyiwu abɩlɩsa yɛ Ɩbwaarɛ aseepu abɩlɩsa yɛ Ɩbwaarɛ nbara akaapʋpʋ ba kina mɛ. Bee biti ba mɔɔ mɛ, kɛ nkɛ nsa kamaa mʋ, n biti n kyiŋi lɩɩ lewu tɔ ba.” ");
INSERT INTO naw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Amaa Yesu maa bugi mʋ asɩn mʋ tɔ pensen kaapʋ mʋ abɩɩlapʋ mʋ, nɩɩ Pita tɩɩ mʋ lɩɩ ɩkaa sʋ ɛɛ tɔwɛ yii mʋ. ");
INSERT INTO naw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amaa Yesu, biliŋi kɩɩ mʋ abɩɩlapʋ mʋ, nɩɩ ɔ tɔwɛ Pita yɛ, “Lɩɩ mɛ sʋ, fʋ Sɩtaanɛ nɩmʋ. Fʋ nfɛɛrɛ ɩ man lɩɩ Ɩbwaarɛ asɛ, ɩ lɩɩ nyɩmɩsa asɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nɩɩ Yesu tɩɩ sakyɔ mʋ yɛ mʋ abɩɩlapʋ mʋ nɩɩ ba ba mʋ asɛ mʋ, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Ɔkʋmaa mʋ nɩɩ ee biti fɛɛ o buu mɛ mʋ, ɩ dagaa fɛɛ o kina mʋ n‐yɩɩ, kɛ ɔ sʋla mʋ oyu laasa kɛ o buu mɛ. ");
INSERT INTO naw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ee biti fɛɛ o kun mʋ gbaa‐gbaa mʋ nkpa mʋ, ee biti ɔ pan nkpa mʋ. Amaa ɔkʋmaa mʋ nɩɩ ɔ pan mʋ nkpa lɩɩ mɛ yɛ asɩn danbɩrasa mʋ sʋ mʋ, ee biti ɔ nyɛ mʋ nkpa. ");
INSERT INTO naw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nɩɩ fʋ kan nyɛ dulinyaa tɔ kʋtɔ kʋmaa, nɩɩ fʋ pan fʋ nkpa mʋ, mɩnɛ nɩɩ fʋ nyɛ? ");
INSERT INTO naw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Abɛɛ mɩnɛ nɩɩ nyɩmɩsa ɩ taalɛ ɔ taa kyarɛ mʋ nkpa? ");
INSERT INTO naw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nɩɩ ɔkʋ kan waa ipeeli lɩɩ mɛ yɛ mɛ kɩkaapʋ sʋ, nbɩɩnbɩɩ kakyɩna nɩmʋ tɔ abi mʋ nɩɩ alibi yɛ Ɩbwaarɛ kɩman‐sɩlɛ kɩ bʋ bamʋ tɔ falɛ mʋ, kanɩn maŋa nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ kan ba yɛ Ɩbwaarɛ bʋnyaa yɛ mʋ sʋsʋ nbɔɔ mʋ, ngbaa mɛ ii biti ɩ baa ɩ sʋ mɛ ipeeli sa kanɩn ɔsa maŋa.” ");
INSERT INTO naw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nɩɩ Yesu bwii kyaga sʋ yɛ, “N tɔwɛ fanɛ fɛɛ akʋ ba bʋ fanɛ tɔ nfɩɩ nɩɩ ba mɛɛ yɛ ba wu lewu, amɔɔ ba wu Ɩbwaarɛ kuwura‐gyii mʋ kɩ maa ba ɔlʋn sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nkɛ nsiye kamaa tɔ mʋ, Yesu taa mʋ abɩɩlapʋ mʋ asa, Pita yɛ Gyemisi yɛ Gyɔn tii mʋ n‐yɩɩ sʋ dii kɩbɩɩ lala kʋ kpee, nɩɩ ba bʋ tʋtɔ bamʋ nkʋn. Nɩɩ Yesu kayɩɩ‐wʋlɛ kyɛɛgɛ bamʋ ansi sʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nɩɩ mʋ ɩkaalɛ bunsa gbaa ɩ lɔŋɔ fuuli parɛparɛ ɩ ŋalɩgɛ sʋ. Ɔkʋ man bʋ dulinyaa nɩmʋ tɔ nɩɩ ɛɛ taalɛ fwɩɩ kaalɛ kɛ ki fuuli parɛparɛ kanɩn kudubi. ");
INSERT INTO naw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Opula maŋa tɔ mʋ, ba ba kɩɩ mʋ, Ɩbwaarɛ asa dɩdaa anyɔ, Eligya yɛ Mosesi, ba lɩɩ ba, nɩɩ ba maa Yesu bɛɛ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nɩɩ Pita tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, ɩ bʋrɔn gaa fɛɛ a maa bʋ nfɩɩ. Ɩmʋ sʋ, yɛgɛ kɛ a yii abu asa, fʋ lɛɛ kʋkʋ, Eligya lɛɛ kʋkʋ, Mosesi lɛɛ kʋkʋ.” ");
INSERT INTO naw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nɩɩ kufuu kɩ kɩtaa Pita maa abɩɩlapʋ banban mʋ gaa, nɩɩ ba man bɩla be nyi kʋtɔ mʋ nɩɩ ba tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nɩɩ kabwaarɛ wʋlɛ ba bun bamʋ sʋ, nɩɩ ɔbʋlɛ kʋ lɩɩ abwaarɛ‐wʋlɛ mʋ tɔ tɔwɛ yɛ, “Ɔnɩmʋ ɩ gyɛ mi‐Bii‐nyɩnsa mʋ nɩɩ n sʋ kebiti sa. Fan nu mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Opula maŋa tɔ, abɩɩlapʋ mʋ ba maa kɩɩ kyaabɔɔ mʋ, ba man bɩla wu ɔkʋ bamʋ asɛ, amɔɔ Yesu nkʋn. ");
INSERT INTO naw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba maa kpɩlɩgɛ kɩbɩɩ mʋ sʋ bɛɛ ba mʋ, nɩɩ Yesu da bamʋ amu tɔ yɛ, “Fan man tɔwɛ ɔkʋ yɛ ɔkʋ kʋtɔ mʋ nɩɩ fan wu, naa fʋʋ saŋa mʋ nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n bwii kyiŋi lɩɩ lewu tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nɩɩ ba nu sa mʋ, amaa bamʋ wʋlɛ‐wʋlɛ ɩɩ taasɛ abaa yɛ, “Kikyiŋi lɩɩ lewu tɔ nɩmʋ kasɛ kaapʋ nɛnɛ?” ");
INSERT INTO naw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nɩɩ ba taasɛ Yesu yɛ, “Mɩnɛ sʋ nɩɩ nbara akaapʋpʋ mʋ bɛɛ tɔwɛ yɛ ɩ dagaa Ɩbwaarɛ ɔtɔwɛpʋ Eligya maa gyankpaa ba pɔyɩ?” ");
INSERT INTO naw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɩ gyɛ kesintin fɛɛ Eligya ii biti ɔ gyankpaa ba, kɛ ɔ ba lɔŋɔ kʋtɔ kʋmaa kɩnɩmʋ. Amaa mɩnɛ sʋ nɩɩ ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ yɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n biti n wu awʋrʋfɔ gaa kɛ asa ba kina mɛ? ");
INSERT INTO naw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","N tɔwɛ fanɛ yɛ Eligya tee bwii ba, nɩɩ kʋtɔ mʋ nɩɩ asa bee biti mʋ, ba tɛɛ taa waa mʋ fɛɛ kanan mʋ nɩɩ ba wʋla kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ lɩɩ mʋ sʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ba maa kpɩlɩgɛ kɩbɩɩ mʋ sʋ bɛɛ ba abɩɩlapʋ asansa mʋ asɛ mʋ, ba wu sakyɔ damantɛ kʋ maa yɩlɛ kyaabɔɔ bamʋ, yɛgɛ ba maa nbara akaapʋpʋ mʋ bee gyii ɩmɔɔrɛ. ");
INSERT INTO naw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Asa mʋ ba maa wu Yesu maa ba mʋ, i kyinkyin bamʋ, nɩɩ ba sɩlɛ kpee mʋ asɛ naa fwaala mʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nɩɩ Yesu taasɛ bamʋ yɛ, “Mɩnɛ ɩmɔɔrɛ nɩɩ fanaa bamʋ fen gyii mʋ?” ");
INSERT INTO naw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nɩɩ ɔkʋ lɛɛ kɔnɔ lɩɩ sakyɔ mʋ tɔ yɛ, “Ɔkaapʋpʋ, kabwɩɩ libi kʋ tɛ mi‐bii sʋ, nɩɩ ɔ mɛɛ taalɛ ɛɛ tɔwɛ, nɩɩ n taa mʋ ba fʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ɩ dan kan kyɩna mʋ sʋ de, ɩ sʋ mʋ ɩ tʋʋ kasɛ, yɛgɛ mʋ kɔnɔ tɔ kii fuu afʋfʋʋ, yɛgɛ ɛɛ wɛ mʋ anyi tɔ, nɩɩ ee kirin. N ba kʋlɛ fʋ abɩɩlapʋ mʋ yɛ ba kʋsaa kanɩn nbwɩɩ libi maŋa lɩɩ mi‐bii mʋ sʋ, amaa ba man taalɛ.” ");
INSERT INTO naw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “O! Fanɛ ndaga kakyɩna nɩmʋ tɔ asa mʋ nɩɩ fan man sʋ kɩkɔɔlɛ‐gyii. Nɛnɛ nɩɩ fen biti yɛ n nyɛ kenyiita sa fanɛ? Fan taa kebii mʋ bɩya mɛ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ba maa taa kebii mʋ bɩya mʋ, nɩɩ nbwɩɩ libi mʋ maa wu Yesu mʋ, opula maŋa tɔ nɩɩ ɩ taa kebii mʋ tʋʋ kasɛ fɛɛ kigbingbin. Ɔ dɛ ee gbiliti yɛgɛ mʋ kɔnɔ tɔ kii fuu afʋfʋʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nɩɩ Yesu taasɛ kebii mʋ mʋ‐sɛ yɛ, “Kanan mʋ nɩɩ ɩ waa mʋ falɛ mʋ, ɩ tɛɛ kyɛɛrɛɛ do?” Nɩɩ mʋ‐sɛ lɛɛ kɔnɔ yɛ, “Lɩɩ koo mu kebii tɔ nɩɩ ɩ waa mʋ kanɩn. ");
INSERT INTO naw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɩ taalɛ ɩ taa mʋ ɩ tʋʋ fʋlɔn yɛ nkyu tɔ ii biti ɩ mɔɔ mʋ. Ɩmʋ sʋ, nɩɩ fɩɩ taalɛ waa kʋtɔ kʋ mʋ, wu anɛ kʋwɛɛ kɛ fʋ mɔlɩgɛ anɛ.” ");
INSERT INTO naw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nɩɩ Yesu taasɛ mʋ‐sɛ yɛ, “Fʋ yɛ nɩɩ n biti n taalɛ mʋ? Nu kasɛ fɛɛ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ Ɩbwaarɛ gyii mʋ, kʋtɔ kʋmaa kii biti kɩ waa sa mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kebii mʋ mʋ‐sɛ taa kensi payɩ kʋlɛ Yesu yɛ, “N kɔɔlɛ Ɩbwaarɛ gyii, amaa kyɛ mɛ tɔ kɛ n nyɛ kɩkɔɔlɛ‐gyii tii sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu maa wu sakyɔ mʋ maa nyɛ akyɔ ii tii sʋ mʋ, nɩɩ ɔ pʋntɛ nbwɩɩ libi mʋ sʋ tɔwɛ ɩmʋ yɛ, “Fanɛ naamuu yɛ akpawu nbwɩɩ libi, n yɛ fan kʋsʋ lɩɩ mʋ sʋ nbɩɩnbɩɩ nɩmʋ, kɛ fan man bɩla bwii ba mʋ sʋ kakaakʋ.” ");
INSERT INTO naw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nɩɩ nbwɩɩ libi mʋ ba nyaŋɛ tɔ muusi tɔ taa kebii mʋ tʋʋ ɔlʋn fɛɛ kigbingbin, nɩɩ ba kʋsʋ mʋ sʋ. Kebii mʋ dɛ fɛɛ obuni, nɩɩ asa mʋ ba yɛ o wu. ");
INSERT INTO naw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tʋtɔ nɩɩ Yesu kɩtaa kebii mʋ kɩbaa tɔ kʋsaa mʋ yɩlɛ mʋ ayaa sʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ɩmʋ kamaa tɔ, nɩɩ Yesu loo kɩkpaara sʋ, nɩɩ mʋ abɩɩlapʋ mʋ nkʋn ba naa taasɛ mʋ yɛ, “Mɩnɛ ɩ waa sʋ nɩɩ anɛɛnɛ a man taalɛ kʋsaa nbwɩɩ libi mʋ lɩɩ kebii mʋ sʋ?” ");
INSERT INTO naw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Sɛhn man bʋ tɔ nɩɩ ɩ taalɛ gya ɩnɩmʋ ana kudubi, amɔɔ kabwaarɛ‐kʋlɛ nkʋn.” ");
INSERT INTO naw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ɩmʋ kamaa nɩɩ Yesu maa mʋ abɩɩlapʋ ba lɩɩ tʋtɔ bɔla Galile ɔsʋwʋlɛ sʋ. Nɩɩ Yesu mee biti fɛɛ ba bɩɩ katɩn mʋ nɩɩ ɔ bʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Lɩɩ fɛɛ kanɩn saŋa maŋa mʋ ɛɛ kaapʋ mʋ abɩɩlapʋ mʋ nɩn. Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Bee biti ba lɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ sa asa, kɛ ba mɔɔ mɛ, amaa nkɛ nsa kamaa tɔ mʋ, n biti n kyiŋi ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Maa tɔwɛ bamʋ kanɩn mʋ, ba man nu ɩmʋ kasɛ, nɩɩ ɩ sʋ bamʋ kufuu fɛɛ ba taasɛ mʋ ɩmʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu maa mʋ abɩɩlapʋ mʋ ba kpee Kapanum kadɛ lala tɔ. Ba maa bʋ kɩkpaara sʋ mʋ, nɩɩ Yesu taasɛ bamʋ yɛ, “Fan maa naa ɔkpa tɔ fɛn ba mʋ, mɩnɛ ɩmɔɔrɛ nɩɩ fen gyii mʋ?” ");
INSERT INTO naw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ba laatɔ nɩn ba man lɛɛ kɔnɔ, lɩɩ fɛɛ saŋa mʋ nɩɩ ba naa ɔkpa tɔ bee kpee mʋ, bee gyii abaa ɩmɔɔrɛ yɛ ɔmɔmɔ ɩ gyɛ bamʋ tɔ ɔlala. ");
INSERT INTO naw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu maa kyʋn kyɩna mʋ, nɩɩ ɔ tɩɩ mʋ abɩɩlapʋ kudu anyɔ mʋ ba mʋ asɛ, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Nɩɩ fanɛ tɔ ɔkʋ kan ee biti fɛɛ o biliŋi ɔlala mʋ, ɔ waa mʋ n‐yɩɩ kalʋwɛ yɛ kɩyaafɔlɛ sa mʋ tɔɔmaa ana.” ");
INSERT INTO naw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tʋtɔ nɩɩ Yesu taa kebii kʋ ba yɩlɛ bamʋ ansi tɔ. Nɩɩ ɔ taa kebii mʋ abaa tɔ, nɩɩ ɔ tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ɔkʋmaa mʋ nɩɩ ɔ kan kɔɔlɛ kebii kɩnɩmʋ dubi mɛ kɩtɩɩ tɔ sʋ mʋ, mɛ nɩɩ ɔ kɔɔlɛ, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ kan kɔɔlɛ mɛ mɔɔ mʋ, man gyɛ mɛ nkʋn nɩɩ ɔ kɔɔlɛ, amaa ɔ kɔɔlɛ ɔmʋnɩ o sun mɛ mʋ gbaa.” ");
INSERT INTO naw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nɩɩ Gyɔn tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, an wu ɔnyɩn kʋ maa sʋ fʋ kɩtɩɩ ɛɛ kʋsaa nbwɩɩ libi ɛɛ lɩɩ asa sʋ, yɛgɛ ɔ man tii anɛ sʋ. Ɩmʋ sʋ an gya mʋ yɛ ɔ man bɩla waa kanɩn.” ");
INSERT INTO naw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan man gya kanɩn ɔsa maŋa. Ɔsa kʋmaa mʋ nɩɩ ɛɛ waa asɩn kyinkyinsa lɩɩ mɛ kɩtɩɩ tɔ mʋ, ɩmʋ kamaa mʋ ɔ mɛɛ bɩla taalɛ tɔwɛ asɩn kʋ nyita mɛ kɩtɩɩ. ");
INSERT INTO naw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ɔkʋmaa mʋ nɩɩ o mee nyita anɛ kusun mʋ, o tii anɛ sʋ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","N tɔwɛ fanɛ kesintin yɛ ɔkʋ kan sa fanɛ nkyu nuusa lɩɩ fan maa gyɛ mɛ lɛɛ sʋ mʋ, ee biti ɔ nyɛ ɩmʋ kʋkɔka. ");
INSERT INTO naw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nɩɩ ɔkʋ kan yɛgɛ nɩɩ nbii mʋ nɩɩ ba kɔɔlɛ mɛ gyii falɛ tɔ ɔkʋ kan waa alibi mʋ, kanɩn odunwura maŋa, nɩɩ ba kan taa kɩfʋlɛ‐buu lala ŋmina kyaga mʋ ɔbʋlɛ tɔ taa mʋ tʋʋ ɔpʋ tɔ gbaa mʋ, ɩ bɔ. ");
INSERT INTO naw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nɩɩ fʋ kɩbaa kɩ kan kɩɩ yɛgɛ nɩɩ fɩɩ waa libi mʋ, tɩn kɩmʋ fɔyɩ. Ɩ bɔ sa fʋ fɛɛ fʋ maa taa kɩbaa dɩyɛ loo Ɩbwaarɛ ayɛ, ɩ kyɔ fɛɛ fʋ maa taa abaa anyɔ naa loo awʋrʋfɔ fʋlɔn mʋ nɩɩ i mee dun kpaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tʋtɔ nɩɩ asʋnswɛɛ mʋ nɩɩ be mee wu, nɩɩ fʋlɔn mʋ gbaa mee dun kakaakʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Nɩɩ fʋ kɩyaa kɩ kan kɩɩ yɛgɛ nɩɩ fɩɩ waa alibi mʋ, tɩn kɩmʋ fɔyɩ. Ɩ bɔ sa fʋ fɛɛ fʋ maa gyɛ boobi nɩɩ fu loo Ɩbwaarɛ ayɛ, ɩ kyɔ fɛɛ fʋ maa taa ayaa anyɔ naa loo awʋrʋfɔ fʋlɔn tɔ. ");
INSERT INTO naw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tʋtɔ nɩɩ asʋnswɛɛ mʋ nɩɩ be mee wu, nɩɩ fʋlɔn mʋ gbaa mee dun kakaakʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Nɩɩ fu kinsi kɩ kan kɩɩ yɛgɛ nɩɩ fɩɩ waa alibi mʋ, kyɔlɛ kɩmʋ tʋʋ. Ɩ bɔ sa fʋ fɛɛ fʋ maa taa kinsi kʋlʋn kpee Ɩbwaarɛ ayɛ, ɩ kyɔ fɛɛ fʋ maa taa ansi anyɔ naa loo awʋrʋfɔ tɔ kakpaa. ");
INSERT INTO naw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tʋtɔ nɩɩ, asʋnswɛɛ mʋ nɩɩ be mee wu, nɩɩ fʋlɔn mʋ gbaa mee dun kakaakʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ɩbwaarɛ ii biti ɔ taa fʋlɔn bɔɔlɛ ɔkʋmaa kɛ ɔ waa kyɩrɛkyɩrɛ fɛɛ kanan mʋ nɩɩ ba sʋ nfɔlɛ bɛɛ bɔɔlɛ inun nɩɩ ɩ waa kyɩrɛkyɩrɛ pɔyɩ nɩɩ ba sʋ bɛɛ waa saraga bɛɛ sa Ɩbwaarɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Nfɔlɛ ɩ bʋrɔn, amaa nɩɩ nfɔlɛ kan fɔyɩ ɩmʋ ɔkɔn bɩrɛ, nɛnɛ nɩɩ fɛn bɩla taalɛ waa mʋ kɛ ɩ nyɛ ɩmʋ ɔkɔn? Ɩmʋ sʋ fan yɛgɛ fanɛ awaasa ɩ baa ɩ bʋkɔn fɛɛ nfɔlɛ, kɛ fan kyɩna yɛ abaa kayɩɩ yuuli tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu maa lɩɩ tʋtɔ mʋ, o kpee Gyudeya ɔsʋwʋlɛ sʋ, nɩɩ ɔ faa Gyɔdan ɔbʋn mʋ kpee benbe. Nɩɩ sakyɔ damantɛ kʋ kɩ ba kyaabɔɔ mʋ, nɩɩ ɔ kaapʋ bamʋ abwaarɛsɩn fɛɛ kanan mʋ nɩɩ ɔ wʋla ɛɛ waa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tʋtɔ mʋ Farasii abi akʋ ba ba sʋʋ Yesu ɔdʋʋ sɩntaasɛ tɔ yɛ, “Ɩ dɛ ɔkpa sa ɔnyɩn fɛ o kina mʋ‐ka?” ");
INSERT INTO naw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nɩɩ Yesu bwii taasɛ bamʋ yɛ, “Mɩnɛ nbara nɩɩ Mosesi kaapʋ fanɛ?” ");
INSERT INTO naw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Mosesi sa ɔkpa fɛɛ ɔnyɩn ɔ kyʋrɔɔ kekina ɔwʋlɛ sa mʋ‐ka kɛ o kina mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fanɛ nkɔlɔ ɩ maa bʋlʋn sʋ nɩɩ Mosesi kyʋrɔɔ kanɩn nbara mʋ sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Naafɔɔ lɩɩ koo npiili asɛ, atɔ kʋtʋʋ tɔ mʋ, Ɩbwaarɛ waa bamʋ ɔnyɩn yɛ ɔkyɩɩ. ");
INSERT INTO naw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɩmʋ sʋ nɩɩ ɔnyɩn ii biti ɔ yɛgɛ mʋ‐sɛ yɛ mu‐nyi, kɛ ɔ taa mʋ n‐yɩɩ mata mʋ‐ka, ");
INSERT INTO naw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kɛ bamʋ asa anyɔ ba biliŋi nyɩmɩsa kʋlʋn, yɛgɛ ba man bɩla ba gyɛ asa anyɔ, amaa ba gyɛ ɔkʋlʋn nɩn. ");
INSERT INTO naw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ɩmʋ sʋ, ɩmʋ nɩɩ Ɩbwaarɛ taa waa kʋkʋlʋn mʋ, ɔkʋ man kan barɩgɛ ɩmʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu maa mʋ abɩɩlapʋ ba maa loo kɩkpaara sʋ mʋ, nɩɩ mʋ abɩɩlapʋ ba lɔŋɔ taasɛ mʋ asɩn lɩɩ kekili mʋ asɩn sʋ. ");
INSERT INTO naw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Ɔkʋmaa mʋ nɩɩ ɔ kan kina mʋ‐ka nɩɩ ɔ naa kili ɔkyɩɩ pʋpwɛ mʋ, o nyita kekili, nɩɩ ɔ waa mʋ‐ka mu alibi. ");
INSERT INTO naw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kanɩn ɔkpa kʋlʋn sʋ nɩɩ ɔkyɩɩ kan kina mu‐kuli naa kili ɔnyɩn pʋpwɛ mʋ, o nyita kekili.” ");
INSERT INTO naw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tʋtɔ nɩɩ asa akʋ ba taa bamʋ nbii wuribi bɛɛ ba Yesu asɛ yɛ ɔ taa mʋ kɩbaa gyaga bamʋ sʋ, yɛgɛ mʋ abɩɩlapʋ mʋ bɛɛ gya bamʋ nɩɩ bɛɛ bɩya nbii mʋ. ");
INSERT INTO naw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu maa wu ɩmʋ kanɩn mʋ, nɩɩ ɔ nyɛ agbʋ, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan yɛgɛ nbii wuribi mʋ ba ba mɛ asɛ, kɛ fan man tii bamʋ ɔkpa, lɩɩ fɛɛ sʋsʋ kuwura‐gyii mʋ kɩ gyɛ sa asa mʋ nɩɩ ba du fɛɛ nbii wuribi mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","N tɔwɛ fanɛ kesintin fɛɛ ɔkʋmaa mʋ nɩɩ ɔ man kɔɔlɛ Ɩbwaarɛ kuwura‐gyii mʋ fɛɛ kebii mʋ, ɔ mɛɛ yɛ ɔ nyɛ loo kɩmʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nɩɩ ɔ kɔɔlɛ bamʋ puga, taa mʋ abaa gyaga‐gyaga bamʋ sʋ nɩɩ ɔ waa bamʋ kusee. ");
INSERT INTO naw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu maa dan yii ɔkpa mʋ sʋ mʋ, nɩɩ ɔnyɩn kʋ sɩlɛ ba muŋa mu ansi tɔ tɔwɛ mʋ yɛ, “Ɔkaapʋpʋ danbɩrasa, mɩnɛ nɩɩ ɩ dagaa n maa waa kɛ n nyɛ nkpa kakpaa?” ");
INSERT INTO naw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nɩɩ Yesu taasɛ mʋ yɛ, “Mɩnɛ sʋ nɩɩ fʋ tɩɩ mɛ ɔdanbɩrasa? Ɔkʋ man gyɛ ɔdanbɩrasa, amɔɔ Ɩbwaarɛ nkʋn. ");
INSERT INTO naw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fu nyi Ɩbwaarɛ nbara mʋ nɩɩ ɩɩ tɔwɛ yɛ, ‘Man mɔɔ nyɩmɩsa, man kan lɩɩ fʋ‐ka abɛɛ fu‐kuli kamaa, man yuuri, man tɩn antɩŋɛsa, man puni fʋ tɔɔmaa, taa bɛɛrɛɛ sa fʋ‐sɛ yɛ fu‐nyi.’ ” ");
INSERT INTO naw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tʋtɔ nɩɩ ɔnyɩn mʋ lɛɛ kɔnɔ yɛ, “Ɔkaapʋpʋ, n wʋla n buu ɩnɩmʋ kpini lɩɩ koo mi kibii tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nɩɩ Yesu kɩɩ ɔnyɩn mʋ diin, mʋ asɩn ɩ pɩrɛ mʋ. Nɩɩ ɔ tɔwɛ mʋ yɛ, “Ɩ san fʋ kʋtɔ kʋlʋn, kpee naa fɛ fʋ kapatɩyɛ kpini, kɛ fʋ taa afulee mʋ sa atiripu. Ɩmʋ ii biti ɩ yɛgɛ fʋ nyɛ ɩmʋ kʋkɔka, kɛ fʋ ba buu mɛ.” ");
INSERT INTO naw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɔnyɩn mʋ maa nu kanan mʋ, nɩɩ ɔ nyaŋɛ mu ansi tɔ taa kɔkɔlɔ nyita kpewu, lɩɩ fɛɛ ɔ gyɛ atɔ wuya gaa nɩn. ");
INSERT INTO naw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nɩɩ Yesu kɩɩ mʋ abɩɩlapʋ mʋ tɔ kyaabɔɔ nɩɩ ɔ tɔwɛ bamʋ yɛ, “Ɩ bʋlʋn gaa sa atɔ wuya ana fɛɛ ba loo Ɩbwaarɛ kuwura‐gyii mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Asɩn mʋ i kyinkyin abɩɩlapʋ mʋ. Amaa Yesu bɩla tɔwɛ bamʋ yɛ, “Mi‐bii ana, yɛ fan wu kanan mʋ nɩɩ Ɩbwaarɛ kuwura‐gyii mʋ tɔ kiloo bʋlʋn. ");
INSERT INTO naw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɩ bʋpɔɔ sa nyɔɔma fɛɛ ɔ taalɛ loo baasa ɔbɔ tɔ bʋlɛ, ɩ kyɔ atɔ wuya o loo Ɩbwaarɛ kuwura‐gyii mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Asɩn nɩmʋ ɩ dɛ bamʋ kɔnɔ gaa, bɛɛ taasɛ abaa yɛ, “Anɩmʋ nɩɩ Ɩbwaarɛ ii biti ɔ mɔlɩgɛ?” ");
INSERT INTO naw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nɩɩ Yesu kɩɩ mʋ abɩɩlapʋ mʋ surum, nɩɩ ɔ yɛ, “Nyɩmɩsa asɛ nɩɩ ɩnɩmʋ ɩ mɛɛ taalɛ waa, man gyɛ Ɩbwaarɛ asɛ. Ɩbwaarɛ asɛ bɩrɛ kʋtɔ kʋmaa nɩmʋ ɩɩ taalɛ waa.” ");
INSERT INTO naw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nɩɩ Pita tɔwɛ yɛ, “An bwiiyaa kʋtɔ kʋmaa yɛgɛ nɩɩ an baa an buu fʋ?” ");
INSERT INTO naw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tʋtɔ nɩɩ Yesu tɔwɛ yɛ, “N tɔwɛ fanɛ kesintin yɛ ɔkʋ man pɩɩ yɛgɛ mʋ kɩkpaara yɛ mʋ‐daa ana yɛ mu‐supu ana yɛ mʋ‐pɩɩkyɩɩ ana mu‐nyi yɛ mʋ‐sɛ yɛ mu‐bii ana yɛ mʋ ndɔɔ ana, lɩɩ nmaa mɛ asɩn danbɩrasa mʋ sʋ, ");
INSERT INTO naw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nɩɩ ɔ mɛɛ yɛ o bwii nyɛ kɩkpaara yɛ mʋ‐daa ana yɛ mu‐supu ana yɛ mʋ‐pɩɩkyɩɩ ana mu‐nyi yɛ mʋ‐sɛ yɛ mu‐bii ana yɛ mʋ ndɔɔ ana kpini kɩlɩfa sʋ. Ee biti ɔ nyɛ kekisi ndaga kakyɩna nɩmʋ tɔ bɩrɛ, amaa ee biti ɔ ba nyɛ nkpa kakpaa.” ");
INSERT INTO naw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nɩɩ Yesu bɩla tɔwɛ bamʋ yɛ, “Agyankpaapʋ gaalaagaa, bee biti ba be biliŋi asii‐amaapʋ, kɛ asii‐amaapʋ ba be biliŋi agyankpaapʋ.” ");
INSERT INTO naw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu maa mʋ abɩɩlapʋ ba naa bee kpee Gyerusalem nɩɩ Yesu ɩ gyankpaa bamʋ bee kpee. Asɩn mʋ i kyinkyin abɩɩlapʋ mʋ, nɩɩ kufuu kɩ sʋ asa mʋ nɩɩ ba buu bamʋ mʋ. Nɩɩ Yesu bɩla lɛɛ mʋ abɩɩlapʋ kudu anyɔ mʋ ɩkaa sʋ, nɩɩ ɔ tɔwɛ bamʋ kʋtɔ mʋ nɩɩ kii biti ki tu mʋ. ");
INSERT INTO naw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nɩɩ Yesu tɔwɛ abɩɩlapʋ mʋ yɛ, “An kpee Gyerusalem, nɩɩ bee biti ba lɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ sa Gyiwu aseepu bɩlɩsa yɛ nbara akaapʋpʋ. Bee biti ba bun mɛ lewu kʋpwɛ, kɛ ba taa mɛ waa bamʋ nɩɩ ba man gyɛ Gyiwu abi abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kanɩn asa maŋa bee biti ba waa mɛ yɛrɛyɛrɛ, kɛ ba tʋʋ nkyɔlɛ bun mɛ, kɛ tɩŋɛ mɛ awʋlɛ‐bi kɛ ba mɔɔ mɛ. Amaa nkɛ asá kamaa mʋ, n biti n kyiŋi ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nɩɩ Sebedi mu‐bii ana Gyemisi maa Gyɔn, ba ba Yesu asɛ ba kʋlɛ mʋ yɛ, “Ɔkaapʋpʋ, an kʋlɛ fʋ yɛ fʋ waa kʋtɔ mʋ nɩɩ an biti a kʋlɛ fʋ falɛ mʋ sa anɛ.” ");
INSERT INTO naw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nɩɩ Yesu taasɛ bamʋ yɛ, “Mɩnɛ nɩɩ fen biti fɛɛ n waa sa fanɛ?” ");
INSERT INTO naw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Nɩɩ fʋ kan ba kyɩna fʋ kuwura‐gya, fʋ bʋnyaa kuwura‐gyii mʋ tɔ mʋ, fʋ yɛgɛ anɛ ɔkʋ ɔ kyɩna fu gyisa sʋ, kɛ ɔkʋ mɔɔ ɔ kyɩna fʋ‐bɩna sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan man nyi kʋtɔ mʋ nɩɩ fɛn kʋlɛ falɛ. Fɛn taalɛ gyii awʋrʋfɔ mʋ nɩɩ n biti n gyii falɛ, nɩɩ kekyugyee mʋ nɩɩ bee biti ba gyee mɛ mʋ, fɛn taalɛ gyee kanɩn kekyugyee maŋa?” ");
INSERT INTO naw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nɩɩ ba kyula yɛ, “An taalɛ.” Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fen biti fan gyii awʋrʋfɔ mʋ nɩɩ n biti n gyii falɛ, kɛ fan gyee mɛ kekyugyee mʋ nɩɩ n gyee mʋ. ");
INSERT INTO naw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amaa ɔmʋ nɩɩ ɔ kyɩna mɛ gyisa sʋ abɛɛ mɛ bɩna sʋ bɩrɛ, man gyɛ mɛ ii biti n sa. Ɩbwaarɛ ii biti ɔ taa sa bamʋ nɩɩ ɔ lɔŋɔ yɩla mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu abɩɩlapʋ kudu mʋ nɩɩ ba san mʋ, ba maa nu asɩn mʋ, ba nyɛ agbʋ waa Gyemisi maa Gyɔn. ");
INSERT INTO naw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tʋtɔ nɩɩ Yesu tɩɩ bamʋ kpini sarɛ mʋ asɛ nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fɛɛ kanan mʋ nɩɩ fan nyi mʋ, bamʋ nɩɩ ba man gyɛ Gyiwu abi bamʋ agyankpaapʋ mʋ, bɛɛ kaapʋ bamʋ ɔlʋn asa sʋ, nɩɩ bamʋ alʋlʋnpʋ gbaa bɛɛ kaapʋ ɔlʋn asa sʋ. ");
INSERT INTO naw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amaa fanɛ bɩrɛ, fan man waa kanɩn. Ɔmʋ nɩɩ ee biti fɛɛ ɔ waa nyɩmɩsa kparɛ mʋ, o biliŋi kɩyaafɔlɛ sa mʋ tɔɔmaa ana. ");
INSERT INTO naw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nɩɩ ɔmʋ nɩɩ ee biti ɔ waa ɔgyankpaapʋ mʋ, ɩ dagaa maa waa fɛɛ kɩnyɛ sa ɔkʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Halɩɩ mɛ, Daadimaadi Obii‐nyɩnsa gbaa n man ba yɛ asa ba sun mɛ nɩn. N ba n ba sun asa nɩn, kɛ n taa mɛ nkpa kɛɛ, kɛ ɩ ka asa gaalaagaa alibi kʋkɔ.” ");
INSERT INTO naw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nɩɩ Yesu maa mʋ abɩɩlapʋ ba kpee Gyeriko kadɛ tɔ. Maa mʋ abɩɩlapʋ yɛ kʋbʋ damantɛ ba maa lɩɩ kadɛ mʋ tɔ mʋ, ba wu gyaatanapʋ kʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Batimayu, (ɩmʋ kasɛ ɩ gyɛ Timayu mu‐bii) maa tɛ ɔkpa kaa ɛɛ kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Gyaatanapʋ mʋ maa nu fɛɛ Yesu Kanasareti‐nyɩn mʋ ɩ kyʋn mʋ, nɩɩ o kuusi tɩɩ mʋ yɛ, “Yesu, Dawidi kanaana‐bii, wu mɛ kʋwɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Maa kuusi kenken sʋ mʋ, asa ba pʋntɛ mʋ sʋ yɛ o bun mʋ kɔnɔ sʋ, yɛgɛ ɛɛ lɔŋɔ ee kuusi kenken ɛɛ tɔwɛ yɛ, “Dawidi kanaana‐bii, wu mɛ kʋwɛɛ!” ");
INSERT INTO naw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nɩɩ Yesu yɩlɛ, nɩɩ ɔ tɔwɛ yɛ, “Fan tɩɩ mʋ sa mɛ.” Nɩɩ ba tɩɩ mʋ tɔwɛ yɛ, “Yɛgɛ fʋ kɔkɔlɔ kɩ yuuli fʋ, Yesu yɛ fʋ ba.” ");
INSERT INTO naw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nɩɩ ɔ kʋsʋ fugi yii mʋ ayaa sʋ ŋmanyan mʋ kɩtaa tʋʋ ɩkaa sʋ nɩɩ o kpee Yesu asɛ. ");
INSERT INTO naw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nɩɩ Yesu taasɛ mʋ yɛ, “Mɩnɛ nɩɩ fii biti yɛ n waa sa fʋ?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ɔkaapʋpʋ, n biti n baa n kɩɩ nɩn.” ");
INSERT INTO naw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Natɛ! Fʋ kɩkɔɔlɛ‐gyii kɩ yɛgɛ nɩɩ fʋ nyɛ alanfɩya.” Opula maŋa tɔ nɩɩ mu ansi mʋ a bugi, nɩɩ o buu Yesu kpee ɔkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu maa mʋ abɩɩlapʋ ba maa tiri Gyerusalem, nɩɩ ba ba fʋʋ Olifu kɩbɩɩ mʋ nɩɩ kɩ maa Betifage maa Betani mʋ, Yesu sun mʋ abɩɩlapʋ anyɔ, ");
INSERT INTO naw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan kpee kadɛ‐bi mʋ nɩɩ kɩ bʋ fanɛ ansi tɔ, fan maa dan fɛn fʋʋ mʋ, fen biti fan wu kekuruma‐bi mʋ nɩɩ ba man pɩɩ dii mʋ maa kyaa, kɛ fan saŋɛ mʋ bɩya mɛ nfɩɩ. ");
INSERT INTO naw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nɩɩ ɔkʋ kan taasɛ fanɛ kʋtɔ mʋ sʋ nɩɩ fan saŋɛ mʋ mʋ, fan tɔwɛ odunwura maŋa yɛ, ‘Ɔnyɩrɩpɛ mʋ ii biti mʋ, amaa ee biti o bwiiyaa mʋ ba nbɩɩnbɩɩ nɩmʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kesintin, nɩɩ ba naa wu kekuruma‐bi mʋ maa kyaa kigbenbi sʋ kɩkpaara kʋkʋ kebunɔ. Ba maa saŋɛ mʋ mʋ, ");
INSERT INTO naw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nɩɩ asa mʋ nɩɩ ba yɩlɛ tʋtɔ mʋ ba taasɛ bamʋ yɛ, “Mɩnɛ sʋ nɩɩ fɛn saŋɛ kekuruma‐bi mʋ?” ");
INSERT INTO naw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nɩɩ ba lɛɛ kɔnɔ kanan mʋ nɩɩ Yesu dan tɔwɛ mʋ, nɩɩ asa mʋ ba yɛgɛ ba taa natɛ. ");
INSERT INTO naw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba taa kekuruma‐bi mʋ bɩya Yesu, taa bamʋ ataa gyaga kuruma mʋ sʋ, nɩɩ Yesu dii kyɩna sʋ. ");
INSERT INTO naw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Asa gaalaagaa ba taa bamʋ ataa tʋʋtʋʋ ɔkpa tɔ, nɩɩ asansa mɔɔ ba ŋɛlɛ afatɛɛ wʋrɩgɛ ɔkpa mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Asa mʋ nɩɩ ba gyankpaa yɛ bamʋ nɩɩ ba buu kamaa mʋ kpini bee kuusi yɛ, “Hosana! Kusee ɩ gyɛ sa ɔmʋ nɩɩ ɔ naa Ɔnyɩrɩpɛ kɩtɩɩ tɔ ɛɛ ba mʋ! ");
INSERT INTO naw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kusee ɩ gyɛ sa anɛ‐Sɛ Owura Dawidi kuwura‐gyii mʋ nɩɩ kɩ ba mʋ! Hosana ɩ gyɛ sa anɛ‐Sɛ Ɩbwaarɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ!” ");
INSERT INTO naw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu maa fʋʋ Gyerusalem mʋ, ɔ naa loo kabwaarɛ‐sunkpa ayɛ, nɩɩ ɔ kɩɩ kʋtɔ kʋmaa kyaabɔɔ. Amaa kpalɩ fɛɛ kyɔwɛ maa tɛɛ lʋwɛ sʋ mʋ, nɩɩ ɔ lɩɩ taa mʋ abɩɩlapʋ kudu anyɔ mʋ kpee Betani. ");
INSERT INTO naw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lɩɩkaakɛ, ba maa lɩɩ Betani bɛɛ ba mʋ, akʋn a kɩtaa Yesu. ");
INSERT INTO naw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Maa kɩɩ kata‐kata mʋ, o wu figi oyu maa pɔrɔgɛ kɩ yɩlɛ, nɩɩ o kpee kɩmʋ asɛ naa kɩɩ fɛɛ ɩ sɔyɩ abii, amaa afatɛɛ nkʋn nɩn, kpalɩ fɛɛ ɩmʋ saŋa sɔyɩsa man pɩɩ fʋʋ. ");
INSERT INTO naw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nɩɩ Yesu tɔwɛ figi oyu mʋ yɛ, “Ɔkʋ man bɩla yɛ o gyii fʋ abii mʋ kakaakʋ!” Mʋ abɩɩlapʋ mʋ ba nu kanan mʋ nɩɩ ɔ tɔwɛ oyu mʋ. ");
INSERT INTO naw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ba maa fʋʋ Gyerusalem mʋ, Yesu kpee kabwaarɛ‐sunkpa ayɛ obu mʋ tɔ naa, nɩɩ o piili ɛɛ gya atɔ afɛpʋ yɛ asɔɔpʋ. Nɩɩ o biliŋaa‐biliŋaa afulee akyarɩpʋ iteeburu yɛ awura‐lɔpɔ afɛpʋ ngya taŋa‐taŋa. ");
INSERT INTO naw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nɩɩ o tii ɔkpa fɛɛ ɔkʋ ɔ man bɩla taa kʋtɔ kʋ bɔla kabwaarɛ‐sunkpa ayɛ mʋ opula. ");
INSERT INTO naw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nɩɩ ɔ lan kaapʋ bamʋ yɛ, “Ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘Bee biti ba tɩɩ mɛ kakpaara yɛ kabwaarɛ kʋlɛkpa sa dulinyaa tɔ asa kpini.’ Amaa fan taa kɩmʋ biliŋaa bamʋ nɩɩ bee yuuri ɔlʋn sʋ ɔbaalakpa.” ");
INSERT INTO naw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aseepu bɩlɩsa yɛ nbara akaapʋpʋ ba nu kanɩn asɩn mʋ, nɩɩ ba piili bee biti ɔkpa mʋ nɩɩ ba taa mɔɔ mʋ, lɩɩ fɛɛ mʋ kɩkaapʋ ki kyinkyin asa damantɛ mʋ kpini, nɩɩ ɩnɩmʋ ɩ yɛgɛ nɩɩ ba sɩlɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kalaatɩpwɛɛ asɛ nɩɩ Yesu maa mʋ abɩɩlapʋ mʋ ba lɩɩ kadɛ lala mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lɩɩkaakɛ nyenyenfuu ba maa naa ɔkpa tɔ mʋ, ba wu figi oyu mʋ kɩ maa wu naa fʋʋ kɩmʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nɩɩ Pita nyiŋi kʋtɔ mʋ nɩɩ kɩ waa, nɩɩ ɔ tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, kɩɩ figi oyu mʋ nɩɩ fʋ tɔwɛ nnɔ mʋ, kɩ maa wu!” ");
INSERT INTO naw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nɩɩ Yesu lɛɛ mʋ kɔnɔ yɛ, “Kɔɔlɛ Ɩbwaarɛ gyii. ");
INSERT INTO naw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","N tɔwɛ fanɛ kesintin yɛ, ɔkʋmaa mʋ nɩɩ ɔ tɔwɛ kɩbɩɩ kɩnɩmʋ yɛ, ‘Taa fʋ n‐yɩɩ naa tʋʋ ɔpʋ tɔ,’ nɩɩ ɔ mɛɛ waa sika‐sika mʋ kɔkɔlɔ tɔ, nɩɩ ɔ kɔɔlɛ gyii fɛɛ kʋtɔ mʋ nɩɩ ɔ tɔwɛ falɛ kii biti kɩ waa mʋ, ii biti i waa kanɩn nɩn sa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ɩmʋ sʋ n tɔwɛ fanɛ yɛ, nɩɩ fan kan kʋlɛ kʋtɔ kʋmaa fanɛ kabwaarɛ‐kʋlɛ tɔ mʋ, fan kɔɔlɛ gyii fɛɛ fan tɛɛ nyɛ kɩmʋ, nɩɩ fen biti fan nyɛ kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nɩɩ fʋ kan yɩlɛ fɩɩ kʋlɛ kabwaarɛ‐kʋlɛ mʋ, taa alibi kʋmaa mʋ nɩɩ ɔkʋ kan waa fʋ mʋ kɛɛ mʋ, kɛ fʋ‐Sɛ Ɩbwaarɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ gbaa ɔ taa fʋ lɛɛ kɛɛ fʋ. ");
INSERT INTO naw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nɩɩ fan kan fan man taa fanɛ tɔɔmaa ana alibi kɛɛ bamʋ mʋ, fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ gbaa mɛɛ yɛ ɔ taa fanɛ lɛɛ kɛɛ fanɛ.” ");
INSERT INTO naw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nɩɩ ba bɩla bwii naa fʋʋ Gyerusalem. Tʋtɔ mʋ, Yesu maa naa kabwaarɛ‐sunkpa ayɛ mʋ tɔ mʋ, Ɩbwaarɛ aseepu bɩlɩsa, yɛ nbara akaapʋpʋ, yɛ abɩlɩsa ba ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nɩɩ ba taasɛ mʋ yɛ, “Mɩnɛ ɔlʋn nɩɩ fʋ sʋ fɩɩ waa ɩnɩmʋ kpini? Anɩmʋ ɩ sa fʋ kanɩn ɔlʋn maŋa?” ");
INSERT INTO naw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “N biti n taasɛ fanɛ asɩn, nɩɩ fan kan lɛɛ kɔnɔ kyɛɛkyɛɛ sa mɛ bɩrɛ, n biti n tɔwɛ fanɛ ɔlʋn kʋlʋn mʋ nɩɩ n sʋ n waa ɩnɩmʋ kpini. ");
INSERT INTO naw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gyɔn kekyugyee mʋ, ɩ lɩɩ Ɩbwaarɛ asɛ abɛɛ nyɩmɩsa asɛ?” ");
INSERT INTO naw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nɩɩ ba yii kasɛ bee gyii abaa ɩmɔɔrɛ yɛ, “Nɩɩ an kan lɛɛ kɔnɔ yɛ, ‘Ɩbwaarɛ asɛ mʋ’ ee biti ɔ taasɛ anɛ yɛ, ‘Mɩnɛ ɩ waa sʋ nɩɩ a man kɔɔlɛ Gyɔn gyii?’ ");
INSERT INTO naw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Amaa nɩɩ an kan tɔwɛ yɛ, ‘Ɩ lɩɩ nyɩmɩsa asɛ mɔɔ mʋ.’ ” (Ba sɩlɛ asa mʋ, kpalɩ fɛɛ ɔkʋmaa nɩmʋ kɔɔlɛ gyii fɛɛ Gyɔn kyɩna ɔ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn.) ");
INSERT INTO naw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɩmʋ sʋ ba sii lɛɛ Yesu kɔnɔ nɩn yɛ, “A man nyi.” Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Kanɩn bɩrɛ, ngbaa mɛ, n mɛɛ yɛ n tɔwɛ fanɛ ɔlʋn kʋlʋn mʋ nɩɩ n sʋ n waa ɩnɩmʋ kpini.” ");
INSERT INTO naw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu bɔ bamʋ kɩŋasan yɛ, “Ɔnyɩn kʋ kyɩna dɔɔ wayɩn kʋdɔɔ kʋ. Nɩɩ ɔ pɔyɩ kɩbandɩyɛ kyaabɔɔ kɩmʋ, nɩɩ o kuu wayɩn ɔnyɩyɛkpa ɔbɔ kʋdɔɔ mʋ tɔ, nɩɩ ɔ pɔyɩ opula bʋnswɩɩsa mʋ nɩɩ akɩɩsʋpʋ bee dii bɛɛ kɩɩ kʋdɔɔ mʋ sʋ. Nɩɩ ɔ taa mʋ kadɔɔ maŋa waa paa agyipu kʋ abaa tɔ, nɩɩ o kpee ɔkpa. ");
INSERT INTO naw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kɩtɩŋɛ saŋa maa fʋʋ mʋ, nɩɩ o sun mʋ kɩyaafɔlɛ kʋ paa agyipu mʋ asɛ, kɛ ɔ naa kɔɔlɛ ɩmʋ nɩɩ ɩ gyɛ mʋ lɛɛ mʋ bɩya mʋ. ");
INSERT INTO naw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Amaa paa agyipu mʋ ba kɩtaa mʋ kɩyaafɔlɛ mʋ, dayɩ mʋ bwiiyaa mʋ abaakpan. ");
INSERT INTO naw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nɩɩ kadɔɔ wuya mʋ bwii sun ɔkʋ, nɩɩ paa agyipu mʋ ba dayɩ mʋ paatɛ mu kumu gyila mʋ ipeeli. ");
INSERT INTO naw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kadɔɔ wuya mʋ bɩla sun ɔkʋ, nɩɩ paa agyipu mʋ ba dayɩ mʋ mɔɔ. Ɔ bɩla sun gaalaagaa, nɩɩ ba dayɩ akʋ, nɩɩ ba mɔɔ akʋ mɔɔ. ");
INSERT INTO naw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ɔkʋlʋn mʋ nɩɩ ɔ dan san kɛ o sun mʋ ɩ gyɛ mu‐bii mʋ nɩɩ ɔ sʋ kebiti sa. Laalaalʋwɛ mʋ o sun mʋ nɩɩ tɔwɛ yɛ, ‘Ɔ maa gyɛ mi‐bii gbaa‐gbaa falɛ bɩrɛ, bee biti ba taa bɛɛrɛɛ sa mʋ.’ ");
INSERT INTO naw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Amaa paa agyipu mʋ ba tɔwɛ abaa nɩn yɛ, ‘Ɔnɩmʋ ɩ gyɛ kapatɩyɛ ogyipu mʋ. Fan ba kɛ a mɔɔ mʋ, kɛ kapatɩyɛ mʋ ki biliŋi anɛ lɛɛ!’ ");
INSERT INTO naw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɩmʋ sʋ ba kɩtaa mu‐bii mʋ, nɩɩ ba mɔɔ, lɛɛ mʋ lɩɩ kadɔɔ mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nɩɩ Yesu taasɛ bamʋ yɛ, “Ɩnɩmʋ falɛ kudubi mʋ, mɩnɛ nɩɩ kadɔɔ wuya mʋ ii biti ɔ waa?” Nɩɩ ba yɛ, “Ee biti ɔ ba mɔɔ paa agyipu mʋ kpini, kɛ ɔ taa kadɔɔ mʋ waa paa agyipu pʋpwɛ abaa tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nɩɩ Yesu yɛ, “Fan man pɩɩta kalɛ Asɩnkyan yɩlasa mʋ? Asɩn mʋ ɩ gyɛ yɛ, ‘Kibuu mʋ nɩɩ apɔyɩpʋ ba kina mʋ, kɩmʋ ɩ ba biliŋi kɩbɔntɔnbʋlɔntɔ kubuu kparɛ mʋ nɩɩ kɩ sʋ obu mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɔnyɩrɩpɛ ɩ waa ɩnɩmʋ, nɩɩ i kyinkyin anɛ.’ ” ");
INSERT INTO naw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gyiwu abɩlɩsa mʋ ba paa Yesu kɩkɩta, kpalɩ fɛɛ ba bɩɩ yɛ bamʋ nɩɩ Yesu bɔ kanɩn kɩŋasan maŋa. Amaa ba sɩlɛ sakyɔ mʋ, ɩmʋ sʋ ba yɛgɛ mʋ, nɩɩ ɔ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Farasii abi yɛ owura Herodi asa akʋ ba ba Yesu asɛ ba sʋʋ mʋ ɔdʋʋ lɩɩ mʋ asɩn tɔwɛsa sʋ. ");
INSERT INTO naw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba ba mʋ asɛ ba tɔwɛ mʋ yɛ, “Ɔkaapʋpʋ, an nyi fʋ maa gyɛ kesintin ogyipu, nɩɩ fʋ mɛɛ tʋwɛ lɩɩ nfɛɛrɛ mʋ nɩɩ asa bɛɛ fɛ, nɩɩ fʋ mɛɛ kɩɩ nyɩmɩsa kɩkparɛ sʋ, amaa fɩɩ kaapʋ asa Ɩbwaarɛ asɩn bɔla kesintin ɔkpa sʋ. An biti a nu lɩɩ fʋ asɛ yɛ, ɩ dɛ ɔkpa fɛɛ a ka lenpoo sa Roma abi Owura lala Kasaro? ");
INSERT INTO naw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ɩ dagaa fɛɛ a ka abɛɛ a man ka?” Amaa Yesu wʋla o nyi ba maa gyɛ kebunbun ansi wuya ana nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ ɩ waa sʋ nɩɩ fan sʋʋ mɛ ɔdʋʋ? Fan sa mɛ kefulee nderebi kɛ n kɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba maa sa mʋ kefulee nɩɩ ɔ kɩɩ mʋ, ɔ taasɛ bamʋ yɛ, “Anɩmʋ foto yɛ kɩtɩɩ ɩ gyan kefulee mʋ sʋ falɛ?” Nɩɩ ba yɛ, “Owura lala Kasaro lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ɩmʋ sʋ nɩɩ Yesu yɛ, “To! Kʋtɔ mʋ nɩɩ kɩ gyɛ Kasaro lɛɛ mʋ, fan ka sa mʋ, nɩɩ kʋtɔ mʋ nɩɩ kɩ gyɛ Ɩbwaarɛ mɔɔ lɛɛ mʋ, fan taa sa mʋ.” Nɩɩ Yesu asɩn a waa bamʋ kanankʋ. ");
INSERT INTO naw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tʋtɔ nɩɩ Sadusi abi mʋ nɩɩ ba yɛ kelewu kyiŋi man bʋ tɔ mʋ, ba ba Yesu asɛ ba tɔwɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ɔkaapʋpʋ, Mosesi kyʋrɔɔ nbara ɩnɩmʋ sa anɛ yɛ, nɩɩ ɔnyɩn kan wu yɛgɛ mʋ‐ka, nɩɩ maa mʋ ba man kʋʋgɛ nbii mʋ, mu‐supu ɩ taalɛ taa okulapu‐kyɩɩ maŋa kili kɛ ba kʋʋgɛ nbii sa olewupu mʋ. ");
INSERT INTO naw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ɔnyɩn kʋ maa mu‐supu ana asunɔ ɩ kyɩna ba bʋ tɔ. Nɩɩ ɔdaa mʋ kili ɔkyɩɩ, nɩɩ o wu, yɛgɛ maa mʋ‐ka mʋ ba man kʋʋgɛ. ");
INSERT INTO naw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Osupu mʋ nɩɩ ɔ gyan sʋ taa okulapu‐kyɩɩ maŋa kili, nɩɩ ngbaa mʋ wu, yɛgɛ maa ɔkyɩɩ mʋ ba man kʋʋgɛ. Ɔsasapʋ maa bɩla taa mʋ, kʋkʋlʋn maŋa nɩn. ");
INSERT INTO naw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bamʋ asunɔ maŋa kpini ba kili ɔkyɩɩ mʋ gyaŋɛ yɛgɛ bamʋ ɔkʋ maa ɔkyɩɩ mʋ ba man kʋʋgɛ. Laalaalʋwɛ mʋ, nɩɩ ɔkyɩɩ mʋ gbaa wu. ");
INSERT INTO naw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nbɩɩnbɩɩ nɩmʋ, bamʋ asunɔ kpini ba maa kili mʋ falɛ, nɩɩ kelewu kyiŋi kakɛ mʋ, bamʋ tɔ ɔmɔɔ mʋ‐ka ii biti ɩ baa ɩ gyɛ ɔkyɩɩ mʋ?” ");
INSERT INTO naw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Man gyɛ fan maa man nyi abwaarɛsɩn abɛɛ Ɩbwaarɛ ɔlʋn mʋ sʋ nɩɩ fan fɔyɩ falɛ? ");
INSERT INTO naw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɩmʋ kasɛ ɩ gyɛ fɛɛ kelewu kyiŋi saŋa mʋ, asa ba man bɩla yɛ ba kili, bee biti ba biliŋi fɛɛ sʋsʋ nbɔɔ mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nbɩɩnbɩɩ, lɩɩ bamʋ nɩɩ bee biti ba kyiŋi lɩɩ lewu tɔ mʋ, fan man pɩɩ kalɛ Mosesi ɔwʋlɛ tɔ lɩɩ kanan mʋ nɩɩ o wu fʋlɔn maa dɛɛ apʋnfa mʋ, nɩɩ Ɩbwaarɛ tɔwɛ mʋ yɛ, ‘Mɛ ɩ gyɛ Abraham Ɩbwaarɛ, Isaki maa Gyekobu Ɩbwaarɛ mʋ!’ ");
INSERT INTO naw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɔ gyɛ asa kɩɩsa Ɩbwaarɛ nɩn, man gyɛ alewupu lɛɛ. Fan fɔyɩ kesintin sʋ!” ");
INSERT INTO naw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nbara ɔkaapʋpʋ kʋ bʋ tʋtɔ nɩɩ o nu ɩmɔɔrɛ mʋ nɩɩ bee gyii. O wu fɛɛ Yesu lɛɛ Sadusi abi mʋ kɔnɔ danbɩrasa. Ɩmʋ sʋ ɔ ba mʋ asɛ ba taasɛ mʋ yɛ, “Nbara mʋ kpini tɔ mʋ, kɩmɔɔ kɩ gyɛ kɩkparɛ?” ");
INSERT INTO naw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Nbara mʋ tɔ kɩkparɛ mʋ ɩ gyɛ kɩnɩmʋ mʋ nɩɩ kɩɩ tɔwɛ yɛ, Oo! Ɩsɩrayɩ nu! Ɔnyɩrɩpɛ anɛ Ɩbwaarɛ mʋ, Ɔnyɩrɩpɛ ɩ gyɛ ɔkʋlʋn nɩn. ");
INSERT INTO naw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Taa fʋ kɔkɔlɔ yɛ fʋ kala yɛ fʋ nfɛɛrɛ yɛ fʋ ɔlʋn kpini nyɛ kebiti sa fʋ‐Nyɩrɩpɛ Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kɩnyɔsapʋ mʋ ɩ gyɛ yɛ, ‘Biti fʋ bɩrɩsa fɛɛ fʋ n‐yɩɩ!’ Nbara kʋ n man bɩla ɔ bʋ tɔ nɩɩ ɩ kyɔ ɩnɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nɩɩ nbara ɔkaapʋpʋ mʋ tɔwɛ Yesu yɛ, “Fʋ waa atɔ gaa, Ɔkaapʋpʋ! Ɩ gyɛ kesintin fɛɛ kanan mʋ nɩɩ fʋ tɔwɛ yɛ, Ɔnyɩrɩpɛ mʋ nkʋn ɩ gyɛ Ɩbwaarɛ, nɩɩ Ɩbwaarɛ kʋ man bɩla ɔ bʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nɩɩ ɔkʋ kan ɔ taa mʋ kɔkɔlɔ yɛ mʋ nfɛɛrɛ yɛ mʋ ɔlʋn nyɛ kebiti sa Ɩbwaarɛ, nɩɩ o biti mʋ‐bɩrɩsa fɛɛ mʋ n‐yɩɩ mʋ, ɩ bʋrɔn ɩ kyɔ fɛɛ ɔ maa waa saraga yɛ kakɛɛ sa Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu maa wu fɛɛ ɔnyɩn mʋ lɛɛ kɔnɔ kanyaasɩn tɔ mʋ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Fʋ man bʋ kata yɛ sʋsʋ Ɩbwaarɛ kuwura‐gyii mʋ.” Ɩnɩmʋ kamaa mʋ, ɔkʋ man bɩla nyɛ kɔkɔlɔ taasɛ Yesu asɩn kʋ. ");
INSERT INTO naw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu maa kaapʋ kabwaarɛ‐sunkpa ayɛ mʋ tɔ mʋ, nɩɩ ɔ taasɛ yɛ, “Nɛnɛ sʋ nɩɩ nbara akaapʋpʋ mʋ bɛɛ tɔwɛ yɛ Krisito mʋ ii biti ɔ lɩɩ Dawidi kanaana tɔ? ");
INSERT INTO naw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kayaayu Kyɩrɛkyɩrɛ mʋ yɛgɛ nɩɩ Dawidi tɔwɛ yɛ, ‘Ɔnyɩrɩpɛ mʋ ɩ tɔwɛ mɛ‐Nyɩrɩpɛ yɛ, Kyɩna mɛ gyisa sʋ naa fʋʋ saŋa mʋ nɩɩ n biti n taa fʋ dʋn ana kpini waa fʋ ayaa kasɛ!’ ");
INSERT INTO naw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawidi gbaa‐gbaa ɩ tɩɩ mʋ ‘Ɔnyɩrɩpɛ.’ Ɩmʋ sʋ, nɛnɛ sʋ nɩɩ Krisito mʋ ii biti ɔ lɩɩ Dawidi kanaana tɔ?” Nɩɩ sakyɔ damantɛ mʋ kpini ba nu Yesu asɛ yɛ kinsigyi. ");
INSERT INTO naw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu maa san ɛɛ kaapʋ bamʋ mʋ, ɔ tɔwɛ yɛ, “Fan baa fan da nbara akaapʋpʋ mʋ nɩɩ ba bun bamʋ ɩbalɩmasʋ ba naa bee biti afwaala yɛ bɛɛrɛɛ agya tɔ mʋ sʋ, ");
INSERT INTO naw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","yɛgɛ bɛɛ kɩɩ bɛɛ lɛɛ ɩkyɩnakpa kparɛ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa yɛ kensi‐gyii ipula mʋ. ");
INSERT INTO naw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bɛɛ naa bee puni akulapu‐kyɩɩ bee gyii bamʋ atɔ, yɛgɛ bɛɛ yɩlɛ asa tɔ bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ bʋnswɩɩsa. Bee biti ba nyɛ kʋsʋ bɩɩtɛ gaa ɩ kyɔ asa kpini!” ");
INSERT INTO naw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kabwaarɛ‐sunkpa ayɛ mʋ, Yesu kyɩna yɛgɛ mu ansi ɩɩ kɩɩ afulee kɩdakaa katɩnɛ, nɩɩ ɛɛ kɩɩ asa ba maa sʋ afulee bɛɛ waa tɔ. Afulee wuya ana gaalaagaa ba waa afulee gaa. ");
INSERT INTO naw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tʋtɔ nɩɩ okulapu‐kyɩɩ tiripu kʋ taa nderebi anyɔ ba waa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nɩɩ ɔ tɩɩ mʋ abɩɩlapʋ ba sarɛ tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin fɛɛ, okulapu‐kyɩɩ tiripu nɩmʋ waa afulee kɩdakaa mʋ tɔ ɔ kyɔ asa mʋ kpini, ");
INSERT INTO naw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","lɩɩ fɛɛ bamʋ nɩɩ ba waa gaa‐gaa mʋ, ba gyii san ɩkʋ yɩla bamʋ ibu to nɩn, amaa okulapu‐kyɩɩ tiripu nɩmʋ bɩrɛ, mu afulee kpini mʋ nɩɩ ɔ dan ɔ sʋ mu obu to mʋ kpini‐kpini nɩɩ ɔ taa ba waa tɔ falɛ.” ");
INSERT INTO naw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu maa dan ɛɛ lɩɩ Kabwaarɛ‐sunkpa ayɛ mʋ, nɩɩ mʋ ɔbɩɩlapʋ kʋ tɔwɛ mʋ yɛ, “Ɔkaapʋpʋ! Kɩɩ abuu danbɩrasa yɛ ibu bʋrɔnsa mʋ nɩɩ ba pɔyɩ falɛ.” ");
INSERT INTO naw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nɩɩ Yesu lɛɛ mʋ kɔnɔ yɛ, “Yɛ fu wu ibu kparɛ‐kparɛ maŋa? Kibuu kʋlʋn gbaa kɩ mɛɛ yɛ ki sii kɩ gyan kʋkʋ sʋ yɛ be mee nin kɩmʋ tʋʋ.” ");
INSERT INTO naw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu maa tɛ Olifu kɩbɩɩ‐bi mʋ sʋ yɛgɛ mu ansi ɩɩ kɩɩ Kabwaarɛ‐sunkpa ayɛ mʋ, Pita yɛ Gyemisi yɛ Gyɔn yɛ Andiruwu ba ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nɩɩ ba taasɛ mʋ yɛ, “Saŋa mɔɔ nɩɩ ɩnɩmʋ ii biti ɩ ba? Mɩnɛ sɩnkaala ii biti ɩ waa kaapʋ saŋa mʋ nɩɩ ɩnɩmʋ ii biti ɩ ba?” ");
INSERT INTO naw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nɩɩ Yesu piili ɛɛ tɔwɛ bamʋ yɛ, “Fan baa fan da sʋ, kɛ fan man yɛgɛ ɔkʋ ɔ pɩna fanɛ. ");
INSERT INTO naw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Asa gaalaagaa bee biti ba ba mɛ kɩtɩɩ tɔ ba tɔwɛ yɛ, ‘Mɛ, ɩ gyɛ Krisito mʋ!’ kɛ ba pɩna asa gaalaagaa. ");
INSERT INTO naw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nɩɩ fan kan nu anaa sʋ yɛ anaa asɩn mʋ, fan man yɛgɛ fanɛ nkɔlɔ ɩ ŋmaa fanɛ. Ɩ dagaa ɩnɩmʋ ɩ maa ba kanɩn, amaa ɩ mɛɛ kaapʋ fɛɛ laalaalʋwɛ mʋ tee tiri tɔ nɩn. ");
INSERT INTO naw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɔsʋwʋlɛ ii biti ɔ kɔ yɛ ɔsʋwʋlɛ, kɛ kuwura‐gyii ɔ kɔ yɛ kuwura‐gyii. Kasɛ kii biti ki gyingyen katɩn kʋmaa nɩmʋ, kɛ akʋn a tɩyɛ. Kanɩn asɩn nɩmʋ kpini i du nɩn fɛɛ ɔkyɩɩ keduŋidi gyankpaasa. ");
INSERT INTO naw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Fan baa fan da sʋ. Bee biti ba kɩtaa fanɛ kpee asɩn ogyikpa, kɛ ba dayɩ fanɛ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa. Lɩɩ mɛ sʋ bee biti ba tɩɩ fanɛ alʋnpʋ yɛ awura ansi tɔ, kɛ fan nyɛ ɔkpa tɔwɛ bamʋ mɛ asɩn danbɩrasa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amaa pɔyɩ kɛ laalaalʋwɛ ɔ ba mʋ, ɩ dagaa fɛɛ ba tɔwɛ asɩn danbɩrasa mʋ sa asa yiri kʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nɩɩ ba kan kɩtaa fanɛ kpee asɩn ogyikpa mʋ, fan man yɛgɛ ɩ tɔɔrɔɔ fanɛ lɩɩ kʋtɔ mʋ nɩɩ fen biti fan naa tɔwɛ mʋ sʋ. Saŋa mʋ kan fʋʋ mʋ, fan tɔwɛ kʋtɔ kʋmaa mʋ nɩɩ Ɩbwaarɛ taa waa fanɛ nnɔ tɔ mʋ. Lɩɩ fɛɛ man gyɛ fanɛ ɩɩ tɔwɛ, amaa Kayaayu Kyɩrɛkyɩrɛ mʋ ɩɩ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Osupu ii biti ɔ ba lɛɛ ɔdaa sa kɛ ba mɔɔ mʋ, kɛ ɔsɛ gbaa ɔ lɛɛ mu‐bii sa. Nɩɩ nbii bee biti ba kʋsʋ yɩlɛ bamʋ akʋʋgɛpʋ sʋ kɛ ba yɛgɛ ba mɔɔ bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","“Ɔkʋmaa nɩmʋ ii biti o kisi fanɛ lɩɩ mɛ sʋ. Amaa ɔkʋmaa mʋ nɩɩ ɔ kɩtaa tɔ kenken naa fʋʋ laalaalʋwɛ mʋ, ii biti ɔ nyɛ kamɔlɩgɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kanɩn saŋa maŋa mʋ, nɩɩ fan kan wu ɔdaatapʋ libi‐libi mʋ maa yɩlɛ katɩn mʋ nɩɩ ɩ gyɛ ikisii yɛ kɩsɩkpa sa Ɩbwaarɛ fɛɛ maa yɩlɛ tʋtɔ mʋ, (ɔsa kʋmaa mʋ nɩɩ ɔ kan kalɛ asɩn nɩmʋ mʋ, o nu kasɛ yɛ ɔdan) saŋa maŋa mʋ, bamʋ nɩɩ ba bʋ Gyudeya mʋ, ba sɩlɛ kpee abɩɩ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɔsa mʋ nɩɩ ɔ bʋ obu to mʋ, ɔ man bɩla bwii loo obu to ɔ naa taa mʋ atɔ kɛ ɔ sɩlɛ. ");
INSERT INTO naw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ bʋ ndɔɔ tɔ mʋ, ɔ man bɩla bwii mʋ kɩkpaara sʋ naa taa mʋ atɔ bunsa. ");
INSERT INTO naw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kanɩn nkɛ maŋa tɔ mʋ, ɩ mɛɛ yɛ ɩ baa ɩ bʋrɔn sa akyɩɩ ɩtɔ wuya ana, yɛ akyɩɩ atalapʋ mʋ nɩɩ ba sʋ nbii wuribi abaa tɔ mʋ! ");
INSERT INTO naw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ɩmʋ sʋ fan kʋlɛ kabwaarɛ‐kʋlɛ kɛ kanɩn asɩn nɩmʋ a man ba kɩkyɛ saŋa. ");
INSERT INTO naw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kanɩn saŋa maŋa ii biti ɩ baa i libi ɩ kyɔ awʋrʋfɔ mʋ nɩɩ dulinyaa wʋla wu lɩɩ koo saŋa mʋ nɩɩ Ɩbwaarɛ tʋʋ dulinyaa ba fʋʋ ndaga saŋa nɩmʋ ii sʋ ii kpee. ");
INSERT INTO naw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Amaa nɩɩ Ɔnyɩrɩpɛ mʋ man dɩn kɔɔgɛ kanɩn awʋrʋfɔ nkɛ mʋ sʋ nɩn, naafɔɔ ɔkʋ mɛɛ yɛ ɔ nyɛ kamɔlɩgɛ. Amaa lɩɩ mʋ asa mʋ nɩɩ ɔ lɛɛ mʋ sʋ mʋ, nɩɩ ɔ kɔɔgɛ kanɩn nkɛ maŋa sʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kanɩn saŋa maa mʋ, nɩɩ ɔkʋ kan tɔwɛ fanɛ yɛ, ‘Fan kɩɩ! Krisito mʋ ndee!’ abɛɛ ‘Fan kɩɩ! Mʋ ɩ bʋ falɛ mʋ!’ fan man kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Lɩɩ fɛɛ antɩŋɛsa Krisito ana yɛ antɩŋɛsa atɔwɛpʋ bee biti ba ba. Bee biti ba ba waa asɩn kyinkyinsa yɛ adangana pɩna asa. Naafɔɔ nɩɩ ɩ nyɛ waa nɩn, bɛɛ pɩna asa mʋ nɩɩ Ɩbwaarɛ lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ɩmʋ sʋ fan baa fan da sʋ, lɩɩ fɛɛ n wʋla tɔwɛ fanɛ kʋtɔ kʋmaa pɔyɩ kanɩn nkɛ maŋa ɩ fʋʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kanɩn awʋrʋfɔ nkɛ maŋa kamaa mʋ, ‘kyɔwɛ man bɩla yɛ ɔ lɩɩ, ɔbwaayɩ gbaa man bɩla yɛ o fuuli. ");
INSERT INTO naw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Akyikpebi gbaa ii biti ɩ tɩyɛ lɩɩ sʋsʋ ba kasɛ, nɩɩ sʋsʋ ɔlʋn atɔ kpini ii biti i gyingyen.’ ");
INSERT INTO naw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Kɛ asa kpini ba wu mɛ, Daadimaadi Obii‐nyɩnsa mʋ n maa lɩɩ abwaarɛ‐wʋlɛ tɔ n ba yɛ ɔlʋn yɛ bɛɛrɛɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kɛ n sun sʋsʋ nbɔɔ dulinyaa tɔ katɩn kʋmaa, kyɔwɛ kɩlɩɩ yɛ kyɔwɛ kɩtɩyɛ, adii yɛ akpɩlɩgɛ, kɛ ba natɛ kʋʋla Ɩbwaarɛ asa mʋ nɩɩ ɔ lɛɛ lɩɩ dulinyaa tɔ kpini. ");
INSERT INTO naw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Fan yɛgɛ iyu afatɛɛ kɩpɔrɔgɛ ɩ waa asɩn baalasa sa fanɛ. Lɩɩ fɛɛ fan kan wu iyu ɩ maa pɔrɔgɛ mʋ, fan bɩɩ fɛɛ kɩkyɛ ki tee tiri tɔ. ");
INSERT INTO naw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kanɩn maŋa nɩɩ fan kan wu fɛɛ asɩn mʋ nɩɩ n tɔwɛ fanɛ falɛ kpini ɩ kan ɩ waa mʋ, fan baa fan nyi fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa kibwii ba mʋ ki tiri tɔ, nɩɩ i du fɛɛ ɔ yɩlɛ kebunɔ. ");
INSERT INTO naw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","N tɔwɛ fanɛ kesintin fɛɛ atɔ nɩmʋ kpini ii biti ɩ waa pɔyɩ, kɛ asa mʋ nɩɩ ba san ba tɛ nkpa tɔ falɛ kpini ba wu. ");
INSERT INTO naw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sʋsʋ yɛ kasɛ kpini ii biti ɔ kyʋn, amaa mɛ atɔwɛsa bɩrɛ ɩ mɛɛ yɛ ɩ kyʋn kakaakʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ɔkʋ man bʋ tɔ o nyi kanɩn kakɛ abɛɛ saŋa. Sʋsʋ nbɔɔ yɛ mɛ, Obii mʋ gbaa a mee nyi, amɔɔ Ɔsɛ mʋ nkʋn i nyi. ");
INSERT INTO naw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Fan kɩɩ danbɩrasa yɛgɛ fan da sʋ, lɩɩ fɛɛ fen mee nyi saŋa mʋ nɩɩ n biti n ba. ");
INSERT INTO naw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ii biti ɩ waa nɩn fɛɛ nyɩmɩsa maa kpee ɔkpa kata, kɛ ɔ taa kʋtɔ kʋmaa waa mʋ ayaafɔlɛ abaa tɔ, nɩɩ ɔ sa ɔkʋmaa nɩmʋ mu kusun sunsa. Nɩɩ ɔ tɔwɛ kebunɔ ɔkɩɩsʋpʋ yɛ ɔ baa ɔ da sʋ. ");
INSERT INTO naw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ɩmʋ sʋ fan baa fan da sʋ, kpalɩ fɛɛ fen mee nyi saŋa mʋ nɩɩ mɛ, fanɛ kɩkpaara wuya mʋ n biti n ba. N taalɛ n ba fɛɛ kalaatɩpwɛ abɛɛ kiyiridi nsana abɛɛ kɩbwayɩkɛ abɛɛ nyenyenfuu. ");
INSERT INTO naw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nɩɩ n kan ba purigi fanɛ mʋ, n man ba tu fanɛ fan maa dɛ nsɩɩrɛ. ");
INSERT INTO naw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Asɩn mʋ nɩɩ n tɔwɛ fanɛ falɛ, n tɔwɛ n sa ɔkʋmaa nɩmʋ yɛ, ‘Ba fʋ da sʋ!’ ” ");
INSERT INTO naw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ɩ maa san nkɛ nyɔ kɛ Gyiwu abi bee gyii bamʋ kanyaŋɛ nbunɔ yɛ bodobodo mʋ nɩɩ kɩ man sʋ kɩfɛ tinsa mʋ, nɩɩ Ɩbwaarɛ aseepu bɩlɩsa yɛ Ɩbwaarɛ nbara akaapʋpʋ bee biti ɔkpa mʋ nɩɩ ba baala taa kɩtaa Yesu kɛ ba mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nɩɩ bɛɛ yɛ, “Fan man yɛgɛ a waa kanɩn saŋa nɩmʋ tɔ, akʋtɔ akʋ bee biti bɛɛ waa ɩlawʋ.” ");
INSERT INTO naw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu maa bʋ Betani mʋ, nɩɩ o kpee Simon mʋ nɩɩ ɔ gyɛ bootipu mʋ kɩkpaara sʋ. Maa tɛ tʋtɔ ee gyii mʋ, nɩɩ ɔkyɩɩ kʋ naa taa tuulaale pʋrʋntʋwa tɔ ba mʋ asɛ. Kanɩn tuulaale maŋa sʋ ɔgyalɩn nɩn gaa, lɩɩ fɛɛ nadi nɩɩ ba taa waa ɩmʋ. Nɩɩ ɔkyɩɩ mʋ tigi pʋrʋntʋwa mʋ kyɛɛgɛ tuulaale mʋ kpini wʋrɩgɛ Yesu kumu tɔ. ");
INSERT INTO naw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nɩɩ asa mʋ nɩɩ ba bʋ tʋtɔ mʋ akʋ ba nyɛ agbʋ bɛɛ taasɛ abaa yɛ, “Saamʋ maa dan taa tuulaale nɩmʋ kyɛɛgɛ wʋrɩgɛ kɩyan falɛ, mɩnɛ kyaarɛ nɩɩ ɩ sʋ? ");
INSERT INTO naw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Naafɔɔ nɩɩ ba taa tuulaale nɩmʋ fɛ nɩn, ɩ waa fɛɛ nyɩmɩsa kesu laalaamuu kʋkɔka, kɛ baa taa afulee mʋ sa atiripu.” Nɩɩ ba nyɛ agbʋ bɛɛ pwɩɩ ɔkyɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amaa Yesu yɛ, “Fan yɛgɛ ɔkyɩɩ mʋ! Mɩnɛ ɩ waa sʋ nɩɩ fɛn pwɩɩ mʋ? Kʋtɔ mʋ nɩɩ ɔ waa mʋ gyɛ kʋtɔ danbɩrasa sa mɛ. ");
INSERT INTO naw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Atiripu mʋ bɩrɛ, ba bʋ fanɛ asɛ saŋa kʋmaa. Kanɩn sʋ, saŋa kʋmaa fɛn taalɛ waa bamʋ adanbɩrasa. Amaa mɛɛ mɛ bɩrɛ, n man yɛ n baa n bʋ fanɛ asɛ saŋa kʋmaa. ");
INSERT INTO naw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɔkyɩɩ nɩmʋ waa ɩmʋ nɩɩ ɛɛ taalɛ nɩn. Ɔ kyɛɛgɛ tuulaale nɩmʋ wʋrɩgɛ mɛ sʋ, ɔ gyankpaa ɛɛ sʋswa mɛ kayɩɩ‐wʋlɛ sa mi kepula kakɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","N tɔwɛ fanɛ nɩmʋ, dulinyaa tɔ katɩn kʋmaa mʋ nɩɩ bee biti ba tɔwɛ asɩn danbɩrasa mʋ, bee biti ba tɔwɛ kʋtɔ mʋ nɩɩ ɔ waa falɛ taa nyiŋi mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nɩɩ Yesu abɩɩlapʋ mʋ tɔ ɔkʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gyudasi Isikariyoti kpee Ɩbwaarɛ aseepu bɩlɩsa mʋ asɛ, kɛ ɔ lɛɛ Yesu sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kʋtɔ mʋ nɩɩ ɔ tɔwɛ bamʋ mʋ, waa bamʋ ɔkɔn gaa, nɩɩ ba yɛ bee biti ba sa mu afulee. Ɩmʋ sʋ Gyudasi piili ee biti ɔkpa mʋ nɩɩ ɔ bɔla sʋ lɛɛ mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kakɛ gyankpaasa mʋ nɩɩ bee gyii kanyaŋɛ nbunɔ bodobodo mʋ nɩɩ kɩ man sʋ kɩfɛ tinsa, nɩɩ ba mɔɔ kɩmʋ saraga nbʋlʋpʋ mʋ, nɩɩ Yesu abɩɩlapʋ ba taasɛ mʋ yɛ, “Fɩnɛ nɩɩ fii biti a lɔŋɔ sa fʋ, kɛ fu gyii kanyaŋɛ nbunɔ agyitɔ mʋ?” ");
INSERT INTO naw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nɩɩ Yesu sun mʋ abɩɩlapʋ anyɔ, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan kpee kadɛ lala mʋ tɔ, fen biti fan gyaŋa kanyɩn kʋ maa sʋ kolobi yɛ nkyu, fan buu mʋ ");
INSERT INTO naw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","naa loo kɩkpaara mʋ nɩɩ ee biti o loo mʋ sʋ, kɛ fan taasɛ kɩkpaara wuya mʋ yɛ, ‘Ɔkaapʋpʋ mʋ yɛ, obu mɔɔ tɔ nɩɩ n maa mɛ abɩɩlapʋ an biti a gyii kanyaŋɛ nbunɔ agyitɔ mʋ?’ ");
INSERT INTO naw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kɩkpaara wuya mʋ ii biti ɔ kaapʋ fanɛ obu lala kʋ abansʋrʋ sʋ, mʋ nɩɩ ɔ kʋʋla lɔŋɔ yɩla. Tʋtɔ nɩn fan lɔŋɔ kʋtɔ kʋmaa sa anɛ.” ");
INSERT INTO naw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nɩɩ mʋ abɩɩlapʋ mʋ ba kpee kadɛ lala mʋ tɔ naa wu kʋtɔ kʋmaa nɩmʋ, fɛɛ kanan mʋ nɩɩ Yesu tɔwɛ bamʋ mʋ. Nɩɩ ba waa kanyaŋɛ nbunɔ agyitɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ɩ maa fʋʋ kalaatɩpwɛ asɛ mʋ, nɩɩ Yesu maa mʋ abɩɩlapʋ kudu anyɔ mʋ ba ba abansʋrʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ba maa gyii mʋ, nɩɩ Yesu yɛ, “N tɔwɛ fanɛ kesintin yɛ, n maa fanɛ mʋ nɩɩ an gyii falɛ, fanɛ tɔ ɔkʋ ii biti ɔ lɛɛ mɛ sa.” ");
INSERT INTO naw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Asɩn mʋ a nyita bamʋ nkɔlɔ tɔ, nɩɩ ba piili bɛɛ taasɛ Yesu kʋkʋlʋn‐kʋkʋlʋn yɛ, “Ɩ gyɛ mɛ nɩn, abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fanɛ kudu anyɔ mʋ tɔ ɔkʋ, ɔmʋ nɩɩ n maa mʋ abaa ɩ bʋga ii loo lapɛ kʋlʋn tɔ mʋ, ii biti ɔ lɛɛ mɛ sa. ");
INSERT INTO naw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mɛ, Daadimaadi Obii‐nyɩnsa n biti n wu fɛɛ kanan mʋ nɩɩ ba wʋla kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ mʋ. Amaa ɔmʋ nɩɩ ee biti ɔ lɛɛ mɛ sa mʋ, mʋ laakʋ. Naafɔɔ ba daa ba man kʋʋgɛ mʋ gbaa mʋ, ɩ bɔ.” ");
INSERT INTO naw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yesu maa mʋ abɩɩlapʋ ba maa san bee gyii mʋ, nɩɩ Yesu taa bodobodo, nɩɩ ɔ taa afwaala sa Ɩbwaarɛ, nɩɩ ɔ kpɛɛ bodobodo mʋ tɔ, taa sa mʋ abɩɩlapʋ tɔwɛ bamʋ yɛ, “Fan kɔɔlɛ bodobodo nɩmʋ gyii, ɩmʋ ɩ gyɛ mɛ kayɩɩ‐wʋlɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tʋtɔ nɩɩ Yesu taa kɔɔpʋ mʋ, nɩɩ ɔ taa afwaala sa mʋ‐Sɛ Ɩbwaarɛ. Nɩɩ ɔ taa sa bamʋ kpini yɛ ba nuu. ");
INSERT INTO naw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nɩɩ Yesu tɔwɛ yɛ, “Ɩnɩmʋ ɩ gyɛ mɛ nkalan mʋ nɩɩ Ɩbwaarɛ taa yɩlɛ sa katɔwɛ kyula mʋ, kɛ ɩ kyɛɛgɛ wʋrɩgɛ sa asa gaalaagaa. ");
INSERT INTO naw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","N tɔwɛ fanɛ yɛ n man bɩla yɛ n nuu wayɩn nta nɩmʋ kakaakʋ, naa fʋʋ kakɛ mʋ nɩɩ n biti n bɩla nuu nta pʋpwɛ Ɩbwaarɛ kuwura‐gyii mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nɩɩ ba maa bɩɩ ɔlʋn yɩn Ɩbwaarɛ mʋ, ba lɩɩ kyʋn Olifu kɩbɩɩ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fanɛ kpini fen biti fan sɩlɛ yɛgɛ mɛ. Lɩɩ fɛɛ Ɩbwaarɛ tɔwɛ Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘N biti n mɔɔ nbʋlʋpʋ ɔkpapʋ mʋ, kɛ nbʋlʋpʋ mʋ ba yaasɛ tɔ.’ ” ");
INSERT INTO naw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yesu kyaga sʋ tɔwɛ yɛ, “Amaa mi kelewu kyiŋi kamaa mʋ, n biti n gyankpaa fanɛ kpee Galile.” ");
INSERT INTO naw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nɩɩ Pita lɛɛ Yesu kɔnɔ ɛɛ, “Nɩɩ ɔkʋmaa nɩmʋ sɩlɛ yɛgɛ fʋ gbaa, mɛɛ mɛ n man yɛ n sɩlɛ yɛgɛ fʋ!” ");
INSERT INTO naw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nɩɩ Yesu tɔwɛ Pita yɛ, “N tɔwɛ fʋ kɛ fu nu yɛ, ndaga, pɔyɩ kɛ kyaasɛ ɔ bʋn ɩlɩɩ ɩnyɔ mʋ, fii biti fʋ kyɛɛ ɩlɩɩ ɩsa yɛ fu mee nyi mɛ.” ");
INSERT INTO naw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amaa Pita payɩ ansi yɛ, “Halɩɩ ɩ gyɛ yɛ n maa fʋ an biti a wu gbaa mʋ, n mɛɛ yɛ n tɔwɛ yɛ n man nyi fʋ.” Kanɩn maŋa nɩɩ abɩɩlapʋ abanban mʋ kpini ba tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nɩɩ Yesu maa mʋ abɩɩlapʋ mʋ ba kpee katɩn mʋ nɩɩ bɛɛ tɩɩ yɛ Gesemani, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan kyɩna nfɩɩ kɛ n kpee naa kʋlɛ kabwaarɛ‐kʋlɛ.” ");
INSERT INTO naw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nɩɩ Yesu taa Pita yɛ Gyemisi yɛ Gyɔn buu mʋ n‐yɩɩ. Tʋtɔ nɩɩ Yesu kɔkɔlɔ nyita mʋ, nɩɩ mʋ n‐yɩɩ gbaa ɩ yɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Mɛ kɔkɔlɔ tɔ ɩ dɩyɛ mɛ lewu‐lewu. Fan sii nfɩɩ yɛgɛ fan da sʋ!” ");
INSERT INTO naw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Maa kpee ansi tɔ gbɛrɛɛ mʋ, nɩɩ ɔ naa kyʋn tɩyɛ kasɛ kʋlɛ Ɩbwaarɛ yɛ, “Nɩɩ ɩ nyɛ waa bɩrɛ, falɛ awʋrʋfɔ ɩnɩmʋ ɩ man tu mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nɩɩ Yesu kʋlɛ Ɩbwaarɛ tɔwɛ yɛ, “Nsɛ, kʋtɔ kʋmaa kɩ man bʋlʋn fʋ asɛ. Kɔɔlɛ kanɩn awʋrʋfɔ nɩmʋ lɩɩ mɛ sʋ. Amaa man gyɛ mɛ kɔkɔlɔ biti, amaa fʋ yɛgɛ fʋ kɔkɔlɔ biti kɩ waa.” ");
INSERT INTO naw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu maa bwii kpee mʋ abɩɩlapʋ asɛ mʋ, ɔ naa tu ba maa dɛ nsɩɩrɛ. Nɩɩ Yesu tɔwɛ Pita yɛ, “Simon, fʋ dɛ nɩn? Amɔɔ fan mɛɛ bɩla taalɛ kyɩna kerefi kʋlʋn yɛgɛ fan man dɛ? ");
INSERT INTO naw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Fan baa fan da sʋ, fan kʋlɛ kabwaarɛ kʋlɛ, kɛ fan man tɩyɛ kʋtʋʋ tɔ kɩɩ tɔ. Kpalɩ fɛɛ fanɛ n‐yaayu bɩrɛ ii biti ɩ waa kʋ tɔ mʋ nɩɩ kɩ bʋrɔn, amaa fanɛ n‐yɩɩ‐wʋlɛ mɔɔ ɩ pɔɔ.” ");
INSERT INTO naw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nɩɩ Yesu bɩla bwii kpee ɛɛ kʋlɛ kabwaarɛ‐kʋlɛ kʋkʋlʋn maŋa. ");
INSERT INTO naw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Maa bɩla bwii ba mʋ, o wu ba maa dɛ, lɩɩ fɛɛ nsɩɩrɛ ɩɩ sʋ bamʋ. Nɩɩ ba man bɩla be nyi kʋtɔ mʋ nɩɩ ba tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Saŋa mʋ nɩɩ Yesu naa bwii ba kili sasapʋ mʋ, nɩɩ ɔ taasɛ bamʋ yɛ, “Fan san fan dɛ fɛn fʋʋtɛ nɩn? Fan kɩɩ! Saŋa mʋ fʋʋ fɛɛ ba taa mɛ, Daadimaadi Obii‐nyɩnsa mʋ waa alibi awaapʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fan kɩɩ, ɔmʋ nɩɩ ɛɛ lɛɛ mɛ ɛɛ sa mʋ ndee. Fan kʋsʋ kɛ a kpee.” ");
INSERT INTO naw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu maa dan san ɛɛ tɔwɛ mʋ, opula tɔ nɩɩ Gyudasi, abɩɩlapʋ kudu anyɔ mʋ tɔ ɔkʋ, ba fʋʋ tʋtɔ yɛ sakyɔ damantɛ kʋ. Ba sʋ isakunde yɛ agulungu. Ɩbwaarɛ aseepu bɩlɩsa yɛ Ɩbwaarɛ nbara akaapʋpʋ yɛ kadɛ mʋ abɩlɩsa i sun bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nɩɩ Gyudasi mʋ nɩɩ ee biti ɔ lɛɛ Yesu sa mʋ, wʋla kaapʋ asa sɩnkaala kʋ tɔwɛ bamʋ yɛ, “Ɔmʋ nɩɩ n naa baari mʋ tɔ mʋ, mʋ nɩmʋ. Fan kɩtaa mʋ kɛ fan kun mʋ taa natɛ.” ");
INSERT INTO naw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gyudasi maa dan fʋʋ Yesu asɛ mʋ, nɩɩ ɔ yɛ, “Ɔkaapʋpʋ!” Nɩɩ o baari mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tʋtɔ nɩɩ ba kɩtaa Yesu ba sʋ mʋ tɔ kinkin. ");
INSERT INTO naw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Amaa bamʋ nɩɩ ba yɩlɛ tʋtɔ mʋ, ɔkʋ lɛɛ mu sakunde ŋɛ Ɩbwaarɛ oseepu bɩlɩsa asɛ kɩnyɛ kʋsʋ tɩn. ");
INSERT INTO naw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Amɔɔ isakunde yɛ ngulungun nɩɩ fɛn taa ba kɛ fan ba kɩtaa mɛ, fɛɛ n maa gyɛ kumu tɔ ɔlʋn oyu? ");
INSERT INTO naw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kakɛ kʋmaa, n maa fanɛ nɩn kabwaarɛ‐sunkpa ayɛ yɛgɛ n kaapʋ, nkɛɛ fan man kɩtaa mɛ. Amaa ɩ dagaa ɩnɩmʋ ɩ waa kanɩn, kɛ asɩn mʋ nɩɩ ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ mʋ, ɩ ba tɔ.” ");
INSERT INTO naw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tʋtɔ nɩɩ mʋ abɩɩlapʋ mʋ kpini ba yɛgɛ mʋ sɩlɛ kyʋn. ");
INSERT INTO naw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nɩɩ kɩyaafɔlɛ kʋ mʋ nɩɩ o bun kɩkalala nkʋn mʋ o buu Yesu, nɩɩ ba paa yɛ ba kɩtaa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nɩɩ ɔ sɩlɛ kibulunkpan yɛgɛ mʋ kɩkalala mʋ. ");
INSERT INTO naw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nɩɩ ba taa Yesu kpee oseepu bɩlɩsa asɛ kɩkpaara sʋ. Tʋtɔ nɩɩ aseepu bɩlɩsa yɛ kadɛ abɩlɩsa yɛ nbara akaapʋpʋ mʋ kpini ba sarɛ. ");
INSERT INTO naw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nɩɩ Pita buu Yesu kɩyaa‐kɩyaa naa loo oseepu bɩlɩsa asɛ kɩkpaara sʋ asɩn ogyikpa tʋtɔ. Nɩɩ o sii kyɩna kabwaarɛ‐sunkpa ayɛ akɩɩsʋpʋ mʋ asɛ ɛɛ wʋlɛ fʋlɔn. ");
INSERT INTO naw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nɩɩ aseepu bɩlɩsa mʋ yɛ kʋbʋ‐kʋbʋ abɩlɩsa mʋ kpini ba biti asɩn mʋ nɩɩ ba tɩn gyaga Yesu sʋ, kɛ ba nyɛ mɔɔ mʋ. Amaa ba kpɩnɛ, ba man nyɛ. ");
INSERT INTO naw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nɩɩ asa gaalaagaa ba tɩn antɩŋɛsa gyaga Yesu sʋ, amaa bamʋ nnɔ tɔwɛsa ɩ man gyɛ kʋlʋn. ");
INSERT INTO naw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nɩɩ anyɩn akʋ ba kʋsʋ yɩlɛ tɩn antɩŋɛsa gyaga Yesu sʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“An nu maa tɔwɛ yɛ, ‘N biti n boyi kabwaarɛ‐sunkpa ayɛ mʋ nɩɩ asa ba pɔyɩ mʋ, kɛ nkɛ nsa kamaa mʋ, n biti n pɔyɩ kɩpʋpwɛ mʋ nɩɩ man gyɛ asa ba pɔyɩ kɩmʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nkɛɛ bamʋ gbaa‐gbaa bamʋ nnɔ ɩ kwɩɩ yɛ abaa. ");
INSERT INTO naw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nɩɩ oseepu bɩlɩsa asɛ mʋ kʋsʋ yɩlɛ bamʋ kpini ansi tɔ, taasɛ Yesu yɛ, “Amɔɔ fʋ man sʋ kɔnɔ fʋ lɛɛ lɩɩ asɩn mʋ nɩɩ ba sʋ bɛɛ pwɩɩ fʋ falɛ?” ");
INSERT INTO naw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amaa Yesu laatɔ ɔ man bugi mʋ kɔnɔ. Nɩɩ oseepu bɩlɩsa asɛ mʋ bɩla bwii taasɛ Yesu yɛ, “Fʋ ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ? Fʋ ɩ gyɛ Ɩbwaarɛ mʋ nɩɩ anɛ ayenbi ɩ gyɛ mʋ lɛɛ mʋ Mu‐Bii?” ");
INSERT INTO naw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Mɛ ɩ gyɛ mʋ. Nɩɩ fen biti fan wu mɛ, Daadimaadi Obii‐nyɩnsa n tɛ Ɔlʋnpʋ Ɩbwaarɛ gyisa sʋ abwaarɛ‐wʋlɛ tɔ ɛɛ ba.” ");
INSERT INTO naw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nɩɩ oseepu bɩlɩsa asɛ mʋ kyatɛ mʋ gbaa‐gbaa ɩkaalɛ, nɩɩ ɔ yɛ, “Ɩnɩmʋ bɩrɛ, an man bɩla an biti ɔkʋ ɔ ba tɔwɛ anɛ asɩn pwɩɩsa kʋ lɩɩ mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan nu yɛ fanɛ asʋ. Ɔ tɔwɛ nbusaa asɩn yii Ɩbwaarɛ. Kanɩn sʋ fan yɛ a waa mʋ nɛnɛ?” Bamʋ kpini ba tɔwɛ yɛ, “O gyii kʋpwɛ, nɩɩ ɩ dagaa maa wu.” ");
INSERT INTO naw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nɩɩ asa mʋ akʋ ba tʋʋ nkyɔlɛ bee bun Yesu, nɩɩ ba bun mu ansi yɛgɛ akʋ mɔɔ bɛɛ da mʋ, nɩɩ ba taasɛ mʋ yɛ ɔ bɩɩ ɔmʋ nɩɩ ɔ da mʋ? Nɩɩ kabwaarɛ‐sunkpa ayɛ akɩɩsʋpʋ mʋ ba taa mʋ lɩɩ bɛɛ kpa mʋ ɩtan. ");
INSERT INTO naw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita maa dan san ɔ bʋ tʋtɔ mʋ, nɩɩ aseepu ɔbɩlɩsa kɩnyɛ kyɩɩsa kʋ ba tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Maa wu Pita maa san ɛɛ wʋlɛ fʋlɔn mʋ, nɩɩ ɔ kɩɩ mʋ surum. Nɩɩ ɔ taasɛ Pita yɛ, “Yɛ ngbaa fʋ fu buu Yesu mʋ nɩɩ ɔ gyɛ Kanasareti‐nyɩn mʋ nɩn?” ");
INSERT INTO naw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amaa Pita kyɛɛ nɩɩ ɔ tɔwɛ yɛ, “N man nyi mʋ, nɩɩ n man nyi asɩn mʋ nɩɩ fɩɩ tɔwɛ falɛ kasɛ.” Nɩɩ Pita lɩɩ ba lenbu. ");
INSERT INTO naw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nɩɩ kɩnyɛ kyɩɩsa mʋ bɩla wu Pita tʋtɔ. Nɩɩ ɔ tɔwɛ bamʋ nɩɩ ba yɩla tʋtɔ mʋ yɛ, “Ɔnɩmʋ gbaa tii bamʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nɩɩ Pita bɩla kyɛɛ. Kamaa tɔ mʋ, bamʋ nɩɩ ba yɩlɛ tʋtɔ mʋ ba tɔwɛ Pita yɛ, “Kesintin tɔ mʋ, fʋ gyɛ bamʋ tɔ ɔkʋ nɩn. Kpalɩ fɛɛ ngbaa fʋ, fʋ lɩɩ Galile nɩn!” ");
INSERT INTO naw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nɩɩ Pita piili ɛɛ tɔwɛ nnɔ ɛɛ gyaga mʋ n‐yɩɩ sʋ, nɩɩ ɔ bɔ ntan tɔwɛ yɛ, “Ɔnyɩn mʋ nɩɩ fɛn tɔwɛ mʋ asɩn falɛ gbaa, n man nyi mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tʋtɔ nɩɩ kyaasɛ bʋn kɩnyɔsapʋ. Nɩɩ Pita nyiŋi asɩn mʋ nɩɩ Yesu wʋla tɔwɛ mʋ yɛ, “Pɔyɩ kɛ kyaasɛ ɔ bʋn ɩlɩɩ ɩnyɔ mʋ, fii biti fʋ kyɛɛ ɩlɩɩ ɩsa yɛ fʋ man nyi mɛ” mʋ. Nɩɩ Pita tɩyɛ kusu sʋ ɛɛ sawʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lɩɩkaakɛ nyenyenfuu, nɩɩ aseepu bɩlɩsa yɛ Gyiwu abɩlɩsa yɛ nbara akaapʋpʋ yɛ kʋbʋ‐kʋbʋ abɩlɩsa mʋ kpini, ba gyaŋɛ nɩɩ ba taa nfɛɛrɛ kʋlʋn. Nɩɩ ba ŋmina Yesu nɩɩ ba taa mʋ kyʋn naa sa Paleti mʋ nɩɩ ɔ gyɛ Roma obii, nɩɩ ɛɛ kɩɩ Ɩsɩrayɩ ɔsʋwʋlɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nɩɩ Paleti taasɛ Yesu yɛ, “Fʋ ɩ gyɛ Gyiwu abi owura mʋ?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Kanan mʋ nɩɩ fʋ tɔwɛ mʋ, kanɩn nɩn.” ");
INSERT INTO naw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɩbwaarɛ aseepu bɩlɩsa asɛ mʋ mɔɔ ba pwɩɩ Yesu lɩɩ asɩn gaalaagaa sʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ɩmʋ sʋ nɩɩ ɔbɩlɩsa Paleti bɩla taasɛ Yesu yɛ, “Fʋ mɛɛ yɛ fʋ lɛɛ kɔnɔ? Nɩɩ asɩn damantɛ mʋ nɩɩ ba pwɩɩ fʋ lɩɩ ɩmʋ sʋ falɛ fa?” ");
INSERT INTO naw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nɩɩ Yesu kina kɩlɛɛ kɔnɔ. Nɩɩ ɩ waa Paleti kanankʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kesu kʋmaa, ngyaŋɛ nbunɔ saŋa mʋ, ɔbɩlɩsa Paleti ɩ yɛgɛ nɩɩ bɛɛ lɛɛ asa mʋ nɩɩ ba tii obu mʋ tɔ ɔkʋlʋn mʋ nɩɩ sakyɔ mʋ bee biti mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kanɩn saŋa maŋa tɔ mʋ, ba tii ɔnyɩn kʋ obu, bɛɛ tɩɩ mʋ yɛ Barabasi. O tii bamʋ nɩɩ ba man biti kɩbanɛ nɩɩ ba kɔ keluu mɔɔ nyɩmɩsa mʋ sʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nɩɩ asa mʋ ba ba Paleti asɛ, ba tɔwɛ mʋ yɛ, ɔ waa sa bamʋ fɛɛ kanan mʋ nɩɩ ɛɛ wʋla ɛɛ waa mʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nɩɩ Paleti taasɛ bamʋ yɛ, “Fen biti fɛɛ n yɛgɛ Gyiwu abi owura mʋ?” ");
INSERT INTO naw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paleti dan o nyi kesintin fɛɛ aseepu abɩlɩsa ba taa Yesu ba sa mʋ lɩɩ kayɩɩ basa. ");
INSERT INTO naw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amaa aseepu bɩlɩsa mʋ ba fun waa asa mʋ yɛ ba kʋlɛ Paleti kɛ ɔ yɛgɛ Barabasi sa bamʋ, man gyɛ Yesu. ");
INSERT INTO naw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nɩɩ Paleti bɩla bwii taasɛ bamʋ yɛ, “Nɩɩ mɩnɛ nɩɩ fen biti fɛɛ n waa ɔmʋ nɩɩ fɛn tɩɩ yɛ Gyiwu abi owura mʋ?” ");
INSERT INTO naw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nɩɩ ba kuusi yɛ, “Da mʋ oyu laasa sʋ mɔɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nɩɩ Paleti taasɛ yɛ, “Nɩɩ mɩnɛ kilibi nɩɩ ɔ dan waa nɩn?” Nɩɩ ba kuusi kenken tii sʋ yɛ, ba da mʋ oyu laasa sʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paleti mɔɔ bwii ee biti ɔ waa asa mʋ kɔkɔlɔ biti sʋ, nɩɩ o tigi Barabasi sa bamʋ. Nɩɩ ɔ yɛgɛ nɩɩ ba taa tɩŋɛ Yesu, nɩɩ ɔ taa mʋ waa bamʋ abaa tɔ yɛ ba naa da mʋ mata oyu laasa sʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nɩɩ anaakɔpʋ mʋ ba taa Yesu naa loo Ɔbɩlɩsa Paleti lenbu tɔ. Nɩɩ ba tɩɩ bamʋ tɔɔmaa ana asansa. ");
INSERT INTO naw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nɩɩ ba bun Yesu kɩrɩman‐kyu kɩtaa fɛɛ awura lɛɛ mʋ, nɩɩ ba taa iwii waa kuwura‐wʋrʋ bun mʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nɩɩ ba piili bɛɛ fwaala mʋ bɛɛ tɔwɛ mʋ yɛ, “Gyiwu abi owura mʋ, nyɛ nkpa bʋnswɩɩsa.” ");
INSERT INTO naw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nɩɩ ba taa oyu bɛɛ da mu kumu tɔ, nɩɩ bɛɛ tʋʋ nkyɔlɛ ba bun mʋ, nɩɩ ba gya muŋa bamʋ ayaa muli sʋ sa mʋ fɛɛ ba maa sun owura mʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ba maa tɛɛ waa Yesu ahin‐sɩn lʋwɛ mʋ, nɩɩ ba bugi bamʋ kɩrɩman‐kyu kɩtaa mʋ, nɩɩ ba taa Yesu gbaa‐gbaa lɛɛ bun mʋ. Nɩɩ ba taa mʋ kyʋn ba naa da mʋ oyu laasa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ba maa kpee mʋ, ba gyaŋa Simon mʋ nɩɩ ɔ lɩɩ Siren ɔsʋwʋlɛ sʋ, ɛɛ ba kadɛ lala mʋ tɔ. Nɩɩ anaakɔpʋ mʋ ba nyan mʋ yɛ ɔ sʋla Yesu oyu laasa mʋ. Simon nɩmʋ mu‐bii ana ɩ gyɛ Alekisanda maa Rufusi. ");
INSERT INTO naw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nɩɩ ba taa Yesu kpee katɩn mʋ nɩɩ bɛɛ tɩɩ yɛ Goligota mʋ. Goligota kasɛ ɩ gyɛ yɛ, “Kumu kawɛ opula.” ");
INSERT INTO naw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tʋtɔ nɩɩ ba taa kɩfɛ mʋ nɩɩ bɛɛ tɩɩ yɛ mɩɩrɛ waa nta tɔ sa Yesu yɛ o nuu. Amaa Yesu kina ɔ man nuu. ");
INSERT INTO naw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nɩɩ ba da Yesu oyu laasa sʋ. Ba maa biti ba barɩgɛ Yesu ɩkaalɛ tɔ mʋ, ba tʋʋ nbii barɩgɛ mʋ ɩkaalɛ mʋ tɔ sa bamʋ n‐yɩɩ kanan mʋ nɩɩ ɔkʋmaa gyii mʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nyenyenfuu, ɩ waa fɛɛ kerefi akpanɔ saŋa, nɩɩ ba da Yesu mata oyu laasa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nɩɩ ba kyʋrɔɔ asɩn mʋ nɩɩ ba taa bun Yesu kʋpwɛ mʋ taa da mata mu amu sʋ yɛ, “ƆNƖMƲ Ɩ GYƐ GYIWU ABI OWURA MƲ.” ");
INSERT INTO naw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kanɩn saŋa maŋa mʋ, ba da bamʋ nɩɩ bee yuuri ɔlʋn sʋ anyɔ akʋ iyu laasa sʋ Yesu asɛ. Ɔkʋ bʋ mʋ gyisa sʋ, nɩɩ ɔkʋ mɔɔ bʋ mʋ bɩna sʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ɩnɩmʋ ɩ yɛgɛ nɩɩ asɩn mʋ nɩɩ ba kyʋrɔɔ waa Asɩnkyan yɩlasa mʋ tɔ mʋ ɩ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɔkʋmaa mʋ nɩɩ ɛɛ ba ɛɛ kyʋn tʋtɔ gbaa bɛɛ sʋ asebi bɛɛ wʋrɩgɛ Yesu sʋ, yɛgɛ bee fi‐fi bamʋ amu bɛɛ tɔwɛ yɛ, “To, yɛ fʋ yɛ fii biti fu boyi kabwaarɛ‐sunkpa ayɛ kɛ fʋ bɩla bwii pɔyɩ kɩmʋ nkɛ nsa akɛ mʋ? ");
INSERT INTO naw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kanɩn bɩrɛ kpɩlɩgɛ lɩɩ oyu laasa mʋ sʋ kɛ fʋ mɔlɩgɛ fʋ n‐yɩɩ!” ");
INSERT INTO naw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kanɩn nɩɩ aseepu bɩlɩsa yɛ nbara akaapʋpʋ mʋ gbaa ba ŋmasɛ Yesu nɩn. Bɛɛ tɔwɛ abaa yɛ, “Ɛɛ mɔlɩgɛ asa amaa ɔ mɛɛ taalɛ mɔlɩgɛ mʋ n‐yɩɩ.” ");
INSERT INTO naw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nɩɩ ba yɛ, “Fʋ nyɛ nɩɩ fʋ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ lɛɛ yɛ ɔ ba mɔlɩgɛ asa, nɩɩ fʋ bɩla fʋ gyɛ Gyiwu abi owura mʋ de, kpɩlɩgɛ lɩɩ oyu laasa mʋ sʋ, saamʋ an nyɛ kɔɔlɛ fu gyii.” Asa anyɔ mʋ nɩɩ ba da bamʋ iyu laasa mʋ sʋ gbaa bɛɛ saalɛ Yesu. ");
INSERT INTO naw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kyɔwɛ maa fʋʋ amu nsana mʋ, nɩɩ kitentenbiri ki bun ɔsʋwʋlɛ mʋ kpini sʋ naa fʋʋ kalaatɩpwɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ɩ maa fʋʋ kerefi asa kalaatɩpwɛɛ asɛ mʋ, nɩɩ Yesu kuusi kenken yɛ, “Eli, Eli, lamaa sabatani?” Ɩmʋ kasɛ ɩ gyɛ yɛ, “Mɛ Ɩbwaarɛ, mɛ Ɩbwaarɛ, mɩnɛ ɩ waa nɩɩ fʋ yɛgɛ mɛ kanɩn?” ");
INSERT INTO naw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Asa mʋ nɩɩ ba yɩlɛ tʋtɔ mʋ i nu ɩnɩmʋ, nɩɩ ba yɛ, “Fan nu! Ɛɛ tɩɩ Ɩbwaarɛ Ɔtɔwɛpʋ Eligya.” ");
INSERT INTO naw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nɩɩ bamʋ ɔkʋ sɩlɛ naa taa ɔkyɛɛ dufudufu nyɔ nta nyaŋɛsa tɔ, nɩɩ ɔ taa ŋmina oyu sʋ kʋsaa naa tii Yesu kɔnɔ yɛ o nuu. Nɩɩ ɔ tɔwɛ yɛ, “Fan yɛgɛ a kɩɩ fɛɛ Eligya ii biti ɔ ba kpɩlɩgɛ mʋ oyu laasa mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nɩɩ Yesu sawʋ kenken, nɩɩ o wu. ");
INSERT INTO naw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nɩɩ kɩtaa kunsa mʋ nɩɩ kɩ barɩgɛ kabwaarɛ‐sunkpa ayɛ ɔtɔ tɔ mʋ kyatɛ tɔ kɩnyɔ lɩɩ sʋsʋ ba yii kasɛ. ");
INSERT INTO naw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nɩɩ anaakɔpʋ ɔbɩlɩsa mʋ nɩɩ ɔ yɩlɛ tʋtɔ mʋ wu kanan mʋ nɩɩ Yesu sawʋ nɩɩ o wu mʋ, nɩɩ ɔ tɔwɛ yɛ, “Kesintin, ɔnyɩn nɩmʋ gyɛ Ɩbwaarɛ Mu‐Bii nɩn.” ");
INSERT INTO naw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Akyɩɩ akʋ ba yɩlɛ kata bɛɛ kɩɩ. Bamʋ tɔ akʋ ɩ gyɛ Mɛɛrɩ Magidalen yɛ Mɛɛrɩ, Gyemisi pii asɛ maa Gyosefu bamʋ‐nyi, yɛ Solome. ");
INSERT INTO naw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Saŋa mʋ nɩɩ Yesu bʋ Galile mʋ, ba buu mʋ, nɩɩ ba kyɛ mʋ tɔ. Akyɩɩ gaalaagaa mʋ nɩɩ ba buu mʋ ba Gyerusalem mʋ gbaa ba yɩlɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kanɩn kakɛ maŋa kɩ gyɛ kakɛ kʋlasa gyoo kakɛ fʋʋtɛsa mʋ. Kyɔwɛ maa kpee ɔ naa tɩyɛ mʋ, ");
INSERT INTO naw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","nɩɩ Gyosefu mʋ nɩɩ ɔ lɩɩ Arimatiya mʋ naa ba. Ɔ gyɛ nyɩmɩsa kparɛ nɩn, nɩɩ o tii kadɛ abɩlɩsa mʋ sʋ, nɩɩ ɔ sʋ bɛɛrɛɛ asa asɛ. Nɩɩ ɔ gyɛ ɔsa mʋ nɩɩ ee gyoo Ɩbwaarɛ kuwura‐gyii mʋ kɩba saŋa mʋ. Nɩɩ Gyosefu waa kɔkɔlɔ kpee Paleti asɛ naa kʋlɛ Yesu kibuni mʋ. ");
INSERT INTO naw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paleti maa nu fɛɛ Yesu tɛɛ wʋla wu mʋ, nɩɩ i kyinkyin mʋ. Nɩɩ ɔ tɩɩ anaakɔpʋ ɔbɩlɩsa mʋ taasɛ mʋ yɛ, “Yesu tee wu?” ");
INSERT INTO naw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Paleti maa nu anaakɔpʋ bɩlɩsa asɛ yɛ ɩ gyɛ kanɩn mʋ, nɩɩ ɔ sa ɔkpa yɛ Gyosefu ɔ naa taa Yesu kebuni mʋ naa pula. ");
INSERT INTO naw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nɩɩ Gyosefu naa sɔɔ taafuli, nɩɩ ɔ naa saatɛ Yesu, taa taafuli mʋ maalɛ mʋ. Nɩɩ ɔ taa mʋ naa pula kakyan mʋ nɩɩ ba ŋɛ kɩfʋlɛ tɔ waa ɔbɔ mʋ tɔ. Nɩɩ Gyosefu gbiliti kubuu lala tii kakyan mʋ kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nɩɩ Mɛɛrɩ Magidalen yɛ Gyose mu‐nyi Mɛɛrɩ ba yɩlɛ kɩɩ katɩn mʋ nɩɩ ba taa Yesu naa pula mʋ. ");
INSERT INTO naw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kakɛ fʋʋtɛsa akɛ kamaa tɔ mʋ, Mɛɛrɩ Magidalen yɛ Mɛɛrɩ Gyemisi mu‐nyi yɛ Solome ba bɩya atɔ liifensa mʋ nɩɩ ba sɔɔ mʋ, kɛ ba taa naa sʋswa Yesu kebuni mʋ. ");
INSERT INTO naw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lɩɩkaakɛ, nawɔkyɩ kakɛ gyankpaasa akɛ nyenyenfuu, kyɔwɛ maa dan lɩɩ mʋ, nɩɩ ba kʋsʋ bee kpee Yesu kakyan mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba maa naa bee kpee ɔkpa tɔ mʋ, nɩɩ ba taasɛ abaa yɛ, “Anɩmʋ ii biti ɔ naa gbiliti kubuu mʋ lɩɩ kakyan mʋ kɔnɔ sa anɛ?” Kpalɩ fɛɛ kubuu mʋ kɩ kyɔ gaa. ");
INSERT INTO naw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ba maa kɩɩ mʋ, ba wu fɛɛ kubuu mʋ kɩ tɛɛ wʋla gbiliti kɩ dɛ. ");
INSERT INTO naw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nɩɩ ba loo kakyan mʋ tɔ, nɩɩ ba wu kɩyaafɔlɛ kʋ maa bun atɔ fufuli ɔ tɛ kakyan mʋ tɔ gyisa sʋ, nɩɩ bamʋ nkɔlɔ ɩ ŋmaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nɩɩ kɩyaafɔlɛ mʋ yɛ, “Fan man yɛgɛ fanɛ nkɔlɔ ɩ ŋmaa fanɛ. N nyi yɛ Yesu mʋ nɩɩ ɔ lɩɩ Nasareti, mʋ nɩɩ ba da mʋ oyu laasa sʋ mʋ nɩɩ fen biti. Ɔ man bʋ nfɩɩ. O kyiŋi lɩɩ lewu tɔ. Fan kɩɩ, nfɩɩ nɩɩ ba daa taa mʋ yɩla. ");
INSERT INTO naw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ɩmʋ sʋ fan natɛ naa tɔwɛ mʋ abɩɩlapʋ mʋ yɛ Pita yɛ, Yesu gyankpaa fanɛ ee kpee Galile. Tʋtɔ nɩɩ fen biti fan wu mʋ fɛɛ kanan mʋ nɩɩ ɔ wʋla tɔwɛ fanɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nɩɩ ba sɩlɛ lɩɩ kakyan mʋ tɔ lɩɩ fɛɛ kufuu kɩ kɩtaa bamʋ, nɩɩ bɛɛ kyɩkyaa. Ba man tɔwɛ ɔkʋ sɛhn kpalɩ fɛɛ kufuu kɩ maa sʋ bamʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu maa kʋsʋ lɩɩ lewu tɔ kakɛ fʋʋtɛsa akɛ lɩɩkaakɛ nyenyenfuu mʋ, ɔ daa kɩlɛɛ mʋ n‐yɩɩ nɩn kaapʋ Mɛɛrɩ Magidalen mʋ nɩɩ ɔ gya nbwɩɩ libi asunɔ lɩɩ mʋ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nɩɩ o kpee naa tɔwɛ mʋ bɩrɩsa ana mʋ nɩɩ ba bɔɔta tɔ ba tɛ bɛɛ sawʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ba maa nu lɩɩ Magidalen asɛ yɛ Yesu tɛ nkpa tɔ nɩɩ o wu mʋ mʋ, ba man kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɩnɩmʋ kamaa mʋ, Yesu taa ɔkpa pʋpwɛ kʋ sʋ lɛɛ mʋ n‐yɩɩ kaapʋ bamʋ tɔ asa anyɔ akʋ mʋ nɩɩ ba naa bee kpee bamʋ kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nɩɩ ba bwii ba tɔwɛ abanban mʋ, amaa ba man kɔɔlɛ bamʋ gyii. ");
INSERT INTO naw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ɩnɩmʋ kpini kamaa mʋ, Yesu lɛɛ mʋ n‐yɩɩ kaapʋ mʋ abɩɩlapʋ kudu ɔkʋ mʋ, yɛgɛ ba tɛ bee gyii. Yesu pwɩɩ bamʋ lɩɩ fɛɛ bamʋ nkɔlɔ ɩ maa bʋlʋn gaa, nɩɩ ba man kɔɔlɛ bamʋ nɩɩ ba wu mʋ maa tɛ nkpa tɔ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan kpee dulinyaa tɔ katɩn kʋmaa naa tɔwɛ asɩn danbɩrasa mʋ sa daadimaadi. ");
INSERT INTO naw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ gyii, nɩɩ ba gyee mʋ Ɩbwaarɛ kekyugyee mʋ, ee biti ɔ nyɛ kamɔlɩgɛ. Amaa ɔkʋmaa mʋ nɩɩ ɔ man kɔɔlɛ gyii mʋ, bee biti ba bun mʋ lewu kʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bamʋ nɩɩ ba kɔɔlɛ gyii mʋ falɛ ɩsɩnkaala ii biti i buu bamʋ. Lɩɩ mɛ kɩtɩɩ tɔ sʋ mʋ, bee biti ba gya nbwɩɩ libi, kɛ ba tɔwɛ ntɔwɛ pʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Fɛɛ nɩɩ ba kan kɩtaa anansɛ tɔ abɛɛ ba kan nuu kʋbwɛ gbaa mʋ, ɩ mɛɛ yɛ ɩ waa bamʋ sɛhn. Bee biti ba taa bamʋ abaa gyaga alɔpʋ sʋ kɛ ba nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ɔnyɩrɩpɛ Yesu maa tɔwɛ bamʋ asɛ lʋwɛ mʋ, nɩɩ Ɩbwaarɛ taa mʋ kpee sʋsʋ naa kyɩna mʋ gyisa sʋ. ");
INSERT INTO naw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nɩɩ Yesu abɩɩlapʋ ba kpee katɩn kʋmaa naa tɔwɛ asɩn danbɩrasa mʋ, yɛgɛ Ɔnyɩrɩpɛ Yesu ɔlʋn tii bamʋ sʋ, nɩɩ ba waa adangana, nɩɩ ɩ kaapʋ fɛɛ bamʋ asɩn danbɩrasa katɔwɛ mʋ ɩ gyɛ kesintin.");
INSERT INTO naw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mɛ‐kyɛmɩnɛ Tiyofolisi, asa damantɛ ba taa tʋʋ bamʋ n‐yɩɩ sʋ kyʋrɔɔ asɩn mʋ nɩɩ ɩ waa anɛ tɔ mʋ yɩla. ");
INSERT INTO naw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ba kyʋrɔɔ kʋtɔ kʋmaa mʋ nɩɩ asa ba wu yɛ ansi, lɩɩ saŋa mʋ nɩɩ Yesu asɩn mʋ i yii kasɛ, nɩɩ ba da ɩmʋ kibonbon tɔwɛ anɛ mʋ, yɩla. ");
INSERT INTO naw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ɩmʋ sʋ bɛɛrɛɛ wuya Tiyofolisi, fɛɛ kanan mʋ nɩɩ mɛ gbaa‐gbaa mɛ n loo asɩn mʋ tɔ kɩɩ lɩɩ ɩmʋ npiili mʋ, ɩ dagaa fɛɛ n kyʋrɔɔ ɩmʋ kɩgyasʋ‐kɩgyasʋ kyɛɛkyɛɛ sʋ sa fʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kɛ fʋ nyɛ bɩɩ asɩn mʋ kesintin fɛɛ kanan mʋ nɩɩ ba kaapʋ fʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Saŋa mʋ nɩɩ Herodi gyɛ owura Gyudeya ɔsʋwʋlɛ sʋ mʋ, nɩɩ ɔnyɩn kʋ bʋ tɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Sakariya. Ɔ gyɛ Ɩbwaarɛ aseepu kʋbʋ mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ Abigya mʋ tɔ ɔkʋ. Nɩɩ bɛɛ tɩɩ mʋ‐ka Elisabeti, nɩɩ ngbaa mʋ lɩɩ oseepu bɩlɩsa asɛ Aron kɩnaana tɔ. ");
INSERT INTO naw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakariya maa Elisabeti kakyɩna tɔ ɩkpa i kyiigi Ɩbwaarɛ asɛ, nɩɩ ba buu Ɩbwaarɛ nbara yɛ kanan mʋ nɩɩ mʋ nnɔsa mʋ ɩ kaapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ba bɩlɛ, amaa ba man kʋʋgɛ kebii, lɩɩ fɛɛ Elisabeti maa gyɛ ogbentipu sʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Saŋa kʋ ɩ ba fʋʋ aseepu kʋbʋ mʋ nɩɩ Sakariya bʋ kɩmʋ tɔ mʋ, nɩɩ bee sun Ɩbwaarɛ ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nɩɩ ba tʋʋ nbii lɛɛ mʋ, fɛɛ kanan mʋ nɩɩ aseepu ɩkpa ɩ kaapʋ mʋ, fɛɛ o loo kabwaarɛ‐sunkpa ayɛ mʋ tɔ naa tuwa nlaa. ");
INSERT INTO naw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Saŋa mʋ nɩɩ o loo ee tuwa nlaa mʋ, yɛgɛ asa damantɛ ba bʋ kewusunɔ bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nɩɩ Ɔnyɩrɩpɛ kabɔɔ ba mʋ asɛ, ba yɩlɛ nlaa kaswɩɩ mʋ gyisa sʋ, katɩn mʋ nɩɩ ee tuwa nlaa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Saŋa mʋ nɩɩ Sakariya wu kabɔɔ mʋ, mʋ kɔkɔlɔ kɩ ŋmaa mʋ, nɩɩ ɩ kɩtaa mʋ kufuu. ");
INSERT INTO naw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amaa nɩɩ kabɔɔ mʋ tɔwɛ Sakariya yɛ, “Man waa kufuu, Ɩbwaarɛ nu fʋ kabwaarɛ‐kʋlɛ. Fʋ‐ka Elisabeti ii biti ɔ kʋʋgɛ Obii‐nyɩnsa kɛ fʋ yɩla mʋ kɩtɩɩ yɛ Gyɔn. ");
INSERT INTO naw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lɩɩ mʋ sʋ mʋ, fanɛ ansi ii biti i gyii, kɛ asa damantɛ gbaa ansi i gyii lɩɩ mʋ kakʋʋgɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ee biti ɔ waa nyɩmɩsa kparɛ Ɔnyɩrɩpɛ Ɩbwaarɛ ansi tɔ. Ɔ man kan waa nuu nta abɛɛ nta bʋlʋnsa. Kayaayu Kyɩrɛkyɩrɛ mʋ biti o loo bɔla mʋ tɔ, lɩɩ saŋa mʋ nɩɩ ɔ bʋ mu‐nyi ɔtɔ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nɩɩ ee biti ɔ yɛgɛ Ɩsɩrayɩ abi gaalaagaa ba nyɛ nfɛɛrɛ kɩkyɛɛgɛ, kɛ ba bwii ba Ɔnyɩrɩpɛ bamʋ Ɩbwaarɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Fu kebii Gyɔn nɩmʋ ii biti ɔ taa Kayaayu tɔ ɔlʋn gyankpaa Ɔnyɩrɩpɛ mʋ fɛɛ Ɩbwaarɛ ɔtɔwɛpʋ Eligya. Ee biti ɔ lɔŋɔ asɛ yɛ nbii bʋga tɔ, kɛ ɔ taa bamʋ nɩɩ bɛɛ waa kʋsʋ tɔ ɔlʋn mʋ, ba ba nyɛ kanyaasɩn kɛ bamʋ nfɛɛrɛ ɩ ba Ɩbwaarɛ ɩkpa kyiigisa mʋ sʋ. Ee biti ɔ waa ɩnɩmʋ lɔŋɔ asa mʋ gyoo Ɔnyɩrɩpɛ.” ");
INSERT INTO naw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nɩɩ Sakariya taasɛ Ɩbwaarɛ kabɔɔ mʋ yɛ, “Nɛnɛ nɩɩ n biti n waa bɩɩ fɛɛ ɩ gyɛ kesintin? Lɩɩ fɛɛ n bɩlɛ, nɩɩ mɛ‐ka gbaa bɩlɛ yɛ kebii kɩnyɛ.” ");
INSERT INTO naw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nɩɩ kabɔɔ mʋ lɛɛ kɔnɔ yɛ, “Mɛ ɩ gyɛ Gabireli mʋ nɩɩ n yɩlɛ Ɩbwaarɛ ansi tɔ sʋsʋ mʋ. Nɩɩ o sun mɛ yɛ n ba tɔwɛ fʋ asɩn danbɩrasa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kpalɩ fɛɛ fʋ maa man kɔɔlɛ mɛ asɩn mʋ nɩɩ ii biti ɩ ba ɩmʋ saŋa tɔ kyɛɛkyɛɛ gyii sʋ mʋ, n tɔwɛ fʋ yɛ fʋ man bɩla yɛ fʋ taalɛ tɔwɛ sɛhn, naa fʋʋ saŋa mʋ nɩɩ mɛ katɔwɛ yɩla mʋ kii biti kɩ ba tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Saŋa kʋlʋn maa tɔ, yɛgɛ asa mʋ nɩɩ ba bʋ kabwaarɛ‐sunkpa ayɛ kewusunɔ mʋ, bɛɛ fɛ nfɛɛrɛ kʋtɔ mʋ sʋ nɩɩ Sakariya kyɛɛrɛɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nɩɩ saŋa mʋ nɩɩ ɔ lɩɩ obu mʋ tɔ mʋ, ɔ man bɩla ɛɛ taalɛ ɛɛ tɔwɛ bamʋ asɛ, nɩɩ ba bɩɩ fɛɛ, o wu ansi sʋ kɩlɛɛkaapʋ kabwaarɛ‐sunkpa ayɛ mʋ tɔ. Lɩɩ fɛɛ abaa nɩɩ o sii ɔ sʋ ɛɛ tɔwɛ bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakariya maa sun mu kiseepu kusun lʋwɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ mʋ, ɔ lɩɩ tʋtɔ kpewu mʋ ayɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ɩnɩmʋ kamaa mʋ, nɩɩ mʋ‐ka Elisabeti nyɛ ɔtɔ. Nɩɩ ɔ taa mʋ n‐yɩɩ baala kɩkpaara sʋ kanɩn ɩbwaayɩ inuu. ");
INSERT INTO naw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nɩɩ Elisabeti yɛ, “Ɔnyɩrɩpɛ Ɩbwaarɛ mʋ ɩ waa ɩnɩmʋ sa mɛ. O su mɛ kʋwɛɛ, nɩɩ ɔ lɛɛ ipeeli lɩɩ mɛ sʋ lɩɩ mɛ tɔɔmaa ana tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Saŋa mʋ nɩɩ Elisabeti sʋ mʋ ɔtɔ ɩbwaayɩ isiye mʋ, nɩɩ Ɩbwaarɛ sun mʋ kabɔɔ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gabireli kpee Nasareti kadɛ tɔ, mʋ nɩɩ kɩ bʋ Galile ɔsʋwʋlɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ɩbwaarɛ sun mʋ kpee kibite mʋ nɩɩ o mee nyi ɔnyɩn nɩɩ bɛɛ tɩɩ mʋ yɛ Mɛɛrɩ mʋ asɛ. Ba taa mʋ sa ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gyosefu kekili, nɩɩ ɔ lɩɩ Dawidi kɩnaana tɔ. ");
INSERT INTO naw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nɩɩ Ɩbwaarɛ kabɔɔ mʋ kpee mʋ asɛ naa fwaala mʋ yɛ, “Faa kumu ɔkɔn! Ɩbwaarɛ bʋ fʋ asɛ, nɩɩ ɔ waa fʋ kusee gaa.” ");
INSERT INTO naw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nɩɩ ɩ kɩtaa Mɛɛrɩ nfɛɛrɛ lɩɩ asɩn mʋ nɩɩ kabɔɔ mʋ tɔwɛ mʋ mʋ, nɩɩ ɛɛ fɛ kanɩn afwaala mʋ nfɛɛrɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nɩɩ kabɔɔ mʋ tɔwɛ mʋ yɛ, “Mɛɛrɩ man waa kufuu, lɩɩ fɛɛ fʋ nyɛ Ɩbwaarɛ asɛ kabwaala. ");
INSERT INTO naw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fii biti fʋ nyɛ ɔtɔ kɛ fʋ kʋʋgɛ Obii‐nyɩnsa, kɛ fʋ yɩla mʋ kɩtɩɩ yɛ Yesu. ");
INSERT INTO naw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ee biti ɔ waa nyɩmɩsa kparɛ kɛ ba tɩɩ mʋ yɛ Ɩbwaarɛ Owura lala Mu‐Bii. Ɔnyɩrɩpɛ Ɩbwaarɛ ii biti ɔ taa Yesu mʋ naana Dawidi kuwura‐gya mʋ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nɩɩ ee biti o gyii Ɩsɩrayɩ abi sʋ kuwura‐gyii naa fʋʋ saŋa mʋ nɩɩ ɩ man sʋ ɔkaa.” ");
INSERT INTO naw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nɩɩ Mɛɛrɩ taasɛ Ɩbwaarɛ kabɔɔ mʋ yɛ, “Nɛnɛ nɩɩ ɩnɩmʋ ii biti ɩ bɔla sʋ waa, yɛgɛ n gyɛ kibite mʋ nɩɩ n man nyi ɔnyɩn?” ");
INSERT INTO naw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nɩɩ Ɩbwaarɛ kabɔɔ mʋ lɛɛ mʋ kɔnɔ yɛ, “Kayaayu Kyɩrɛkyɩrɛ mʋ ii biti ɔ ba fʋ sʋ, kɛ Ɩbwaarɛ Owura lala mʋ ɔlʋn o bun fʋ sʋ. Ɩmʋ sʋ bee biti ba tɩɩ obii kyɩrɛkyɩrɛ mʋ nɩɩ fii biti fʋ kʋʋgɛ mʋ mʋ, yɛ Ɩbwaarɛ mu‐bii. ");
INSERT INTO naw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Fʋ kʋʋpʋ Elisabeti mʋ nɩɩ asa bɛɛ tɩɩ mʋ yɛ ogbentipu nɩɩ ɔ waa kakyɩɩ bɩlɩsa gbaa mʋ, sʋ obii‐nyɩnsa‐bii ɔtɔ ɩbwaayɩ isiye. ");
INSERT INTO naw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Lɩɩ fɛɛ kʋtɔ kʋ kɩ man bʋ tɔ yɛ Ɩbwaarɛ mɛɛ taalɛ waa.” ");
INSERT INTO naw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nɩɩ Mɛɛrɩ lɛɛ kɔnɔ yɛ, “N gyɛ Ɔnyɩrɩpɛ nɩn, yɛgɛ ɩ waa kanɩn sa mɛ fɛɛ kanan mʋ nɩɩ fʋ tɔwɛ mʋ.” Nɩɩ Ɩbwaarɛ kabɔɔ mʋ lɩɩ tʋtɔ kyʋn. ");
INSERT INTO naw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ɩmʋ nkɛ gbɛrɛɛ kamaa mʋ, Mɛɛrɩ kʋʋla mʋ n‐yɩɩ ɛɛ waa bilen o kpee kadɛ mʋ nɩɩ kɩ bʋ abɩɩ tɔ Gyudeya ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nɩɩ ɔ naa loo Sakariya kɩkpaara sʋ naa fwaala mʋ‐ka Elisabeti. ");
INSERT INTO naw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeti maa nu Mɛɛrɩ afwaala mʋ, kebii mʋ nɩɩ ɔ bʋ mʋ ɔtɔ tɔ mʋ fitii. Kayaayu Kyɩrɛkyɩrɛ kɩ maa loo bɔla Elisabeti mʋ, ");
INSERT INTO naw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nɩɩ ɔ pʋntɛ kenken tɔwɛ yɛ, “Akyɩɩ kpini tɔ mʋ, fʋ nɩɩ Ɩbwaarɛ waa kusee kʋkyɔ, nɩɩ kusee bun fu kebii mʋ nɩɩ fii biti fʋ kʋʋgɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mɩnɛ kusee lala nɩɩ Ɩbwaarɛ taa bwaala mɛ yɛ mɛ‐Nyɩrɩpɛ mu‐nyi ɔ ba bɔɔ mɛ sʋ? ");
INSERT INTO naw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","N maa dan nu fʋ afwaala mʋ, kebii mʋ nɩɩ ɔ bʋ mɛ ɔtɔ tɔ mʋ taa kensi‐gyii fitii. ");
INSERT INTO naw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kusee ɩ gyɛ fʋ lɛɛ, lɩɩ fɛɛ fʋ maa kɔɔlɛ gyii fɛɛ asɩn mʋ nɩɩ Ɩbwaarɛ tɔwɛ fʋ mʋ, ii biti ɩ ba tɔ kesintin.” ");
INSERT INTO naw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nɩɩ Mɛɛrɩ tɔwɛ yɛ, “N yɩn Ɔnyɩrɩpɛ Ɩbwaarɛ lɩɩ mɛ kɔkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ɩbwaarɛ mɛ Ɔmɔlɩgɛpʋ sʋ mʋ, mi ansi i gyii lɩɩ mɛ kɔkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kpalɩ fɛɛ mɛ, Ɩbwaarɛ kibite mʋ nɩɩ n man bʋ sɛhn tɔ mʋ, mɛ asɩn i tiri Ɩbwaarɛ. Nɩɩ lɩɩ ndaga sʋ i kpee mʋ, ɔkʋmaa nɩmʋ ii biti ɔ tɩɩ mɛ yɛ kumu ɔkɔn wuya. ");
INSERT INTO naw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Lɩɩ fɛɛ Ɔlʋnpʋ lala Ɩbwaarɛ waa atɔ kparɛ sa mɛ. Mʋ kɩtɩɩ ɩ gyɛ Kɩkyɩrɛkyɩrɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nɩɩ asa kʋmaa mʋ nɩɩ ba sɩlɛ Ɩbwaarɛ mʋ, ee wu bamʋ kʋwɛɛ, san sa abii san yɛ anaana. ");
INSERT INTO naw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɔ taa mʋ kɩbaa bʋlʋnsa mʋ waa asɩn kyinkyinsa, nɩɩ ɔ yaasɛ bamʋ nɩɩ bɛɛ kʋsaa bamʋ n‐yɩɩ bamʋ nfɛɛrɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɔ kʋsaa awura‐gyipu bamʋ ngya sʋ, amaa nɩɩ o diyaa abʋlʋpʋ mʋ sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɔ yɛgɛ nɩɩ atiripu ba nyɛ atɔ danbɩrasa mʋ nɩɩ i tiri bamʋ. Amaa atɔ wuya ana bɩrɛ, o bwiiyaa bamʋ yɛ abaa kpan. ");
INSERT INTO naw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɩbwaarɛ nyiŋi mʋ asa Ɩsɩrayɩ abi sʋ, nɩɩ o wu bamʋ kʋwɛɛ kyɛ bamʋ tɔ, ");
INSERT INTO naw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","fɛɛ kanan mʋ nɩɩ ɔ tɔwɛ yɩla anɛ naana ana agyankpaapʋ mʋ. Ɔ tɔwɛ Abraham yɛ ee biti o wu maa mʋ kanaana tɔ abi kpini kʋwɛɛ.” ");
INSERT INTO naw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nɩɩ Mɛɛrɩ kyɩna Elisabeti asɛ ɩ waa fɛɛ ɩbwaayɩ ɩsa pɔyɩ nɩɩ o bwii kpewu. ");
INSERT INTO naw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeti kakɛ kʋʋgɛsa maa fʋʋ mʋ, nɩɩ ɔ kʋʋgɛ kebii‐nyɩnsa‐bii. ");
INSERT INTO naw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nɩɩ Elisabeti mʋ tɔɔmaa ana yɛ mʋ kʋʋpʋ ana ba maa nu kanan mʋ nɩɩ Ɔnyɩrɩpɛ Ɩbwaarɛ mʋ wu mʋ kʋwɛɛ mʋ, nɩɩ bamʋ kpini ba bʋga gyii bamʋ ansi. ");
INSERT INTO naw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ɩmʋ kakɛ buruwasapu mʋ ba gyaŋɛ, kɛ ba tɩn kebii mʋ oduu. Naafɔɔ bee biti ba taa mʋ‐sɛ kɩtɩɩ Sakariya mʋ yɩla mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Amaa nɩɩ mu‐nyi kina kɩtɩɩ mʋ, nɩɩ ɔ yɛ, “Ba tɩɩ mʋ yɛ Gyɔn.” ");
INSERT INTO naw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nɩɩ ba tɔwɛ Elisabeti yɛ, “Fan man sʋ ɔkʋ nɩɩ ɔ sʋ kanɩn kɩtɩɩ fanɛ kanan tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nɩɩ ba waa abaa tɔwɛ mʋ‐sɛ Sakariya asɛ, kɛ ba bɩɩ kɩtɩɩ mʋ nɩɩ ba taa yɩla kebii mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nɩɩ ɔ yɛgɛ nɩɩ ba taa kɩgyantan‐bi sa mʋ. Nɩɩ ɔ kyʋrɔɔ sʋ yɛ, “Mʋ kɩtɩɩ ɩ gyɛ Gyɔn.” Nɩɩ i kyinkyin bamʋ gaa. ");
INSERT INTO naw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Opula maŋa tɔ nɩɩ Sakariya kɔnɔ bugi, nɩɩ mʋ kanandʋlʋ gbaa saŋɛ, nɩɩ o piili ɛɛ tɔwɛ ɛɛ yɩn Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nɩɩ kufuu kɩ kɩtaa mʋ tɔɔmaa ana mʋ kpini, nɩɩ asɩn nɩmʋ ɩ yalagɛ ndɛ mʋ nɩɩ ɩ bʋ abɩɩ tɔ Gyudeya Ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nɩɩ ɔkʋmaa mʋ nɩɩ o nu kanɩn asɩn mʋ ɩɩ fɛ kɩmʋ nfɛɛrɛ, nɩɩ ɛɛ taasɛ yɛ, “Mɩnɛ nɩɩ kanɩn kebii nɩmʋ ba ɔ ba waa?” Lɩɩ fɛɛ Ɩbwaarɛ kɩbaa kɩ gyan mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ bɔla kebii mʋ mʋ‐sɛ Sakariya tɔ, nɩɩ ɛɛ tɔwɛ abwaarɛsɩn yɛ, ");
INSERT INTO naw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Fan yɛgɛ a yɩn anɛ Ɩsɩrayɩ abi Ɔnyɩrɩpɛ Ɩbwaarɛ, lɩɩ fɛɛ ɔ ba nɩn ɔ ba kyɛ mʋ asa tɔ kɛ ɔ mɔlɩgɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lɩɩ mʋ kɩyaafɔlɛ Dawidi kanan tɔ mʋ, ɔ lɛɛ Ɔmɔlɩgɛpʋ Lʋnpʋ sa anɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ atɔwɛpʋ kyɩrɛkyɩrɛ mʋ ba wʋla tɔwɛ yɩla fɛɛ, ");
INSERT INTO naw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ee biti ɔ ba mɔlɩgɛ anɛ lɩɩ anɛ dʋn ana yɛ anɛ akisipu kpini abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɩbwaarɛ tɔwɛ yɛ ee biti o wu anɛ naana ana kʋwɛɛ kɛ o nyiŋi mʋ katɔwɛ kyula kyɩrɛkyɩrɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Katɔwɛ kyula nɩmʋ nɩɩ Ɩbwaarɛ bɔ ntan sa anɛ naana Abraham yɛ, ");
INSERT INTO naw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ee biti ɔ kɔɔlɛ anɛ lɩɩ anɛ akisipu abaa tɔ, kɛ ɔ yɛgɛ a nyɛ ɔlʋn sun mʋ yɛgɛ a man sʋ kufuu. ");
INSERT INTO naw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kɛ a ba an gyɛ asa kyɩrɛkyɩrɛ kɛ anɛ ɩkpa i kyiigi, mʋ Ɩbwaarɛ ansi tɔ lɩɩ anɛ kakyɩna kpini.” ");
INSERT INTO naw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nɩɩ Sakariya tɔwɛ mu‐bii Gyɔn yɛ, “Mi‐bii, bee biti ba tɩɩ fʋ yɛ Ɩbwaarɛ Ɔlʋnpʋ mʋ ɔtɔwɛpʋ. Lɩɩ fɛɛ fii biti fʋ gyankpaa Ɔnyɩrɩpɛ mʋ naa lɔŋɔ mʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Fii biti fʋ ba yɛgɛ mʋ asa ba bɩɩ fɛɛ ɩ lɩɩ alibi kɩtaakɛɛ sʋ nɩɩ bee biti ba nyɛ kamɔlɩgɛ. ");
INSERT INTO naw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Lɩɩ fɛɛ Ɩbwaarɛ maa wu anɛ kʋwɛɛ sʋ mʋ, nɩɩ ɔ yɛgɛ nɩɩ Ɔmɔlɩgɛpʋ mʋ ba anɛ asɛ, fɛɛ kanan mʋ nɩɩ kyɔwɛ ɩ lɩɩ sʋsʋ ba ɛɛ da kasɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kɛ ɩ ŋmaŋɛ sa bamʋ nɩɩ ba bʋ kitentenbiri mʋ nɩɩ kɩ sʋ bamʋ kii kpee lewu tɔ, kɛ ɩ ŋmaŋɛ tɔ kaapʋ anɛ ɔkpa mʋ nɩɩ ɩ sʋ i kpee keyuula tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nɩɩ kebii mʋ dan nɩɩ ɔ nyɛ Ɩbwaarɛ Kayaayu tɔ ɔlʋn, nɩɩ ɔ kyɩna ofuli sʋ naa fʋʋ saŋa mʋ nɩɩ ɔ lɛɛ mʋ n‐yɩɩ kaapʋ Ɩsɩrayɩ abi. ");
INSERT INTO naw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kanɩn nkɛ maŋa tɔ mʋ, Owura Kasaro Agusitu sa kɔnɔ yii sʋ tɔwɛ yɛ, ɔkʋmaa mʋ nɩɩ ɔ bʋ Roma kuwura‐gyii kasɛ mʋ kpini ɔ naa kyʋrɔɔ mʋ kɩtɩɩ kɛ ba kalɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kɩmʋ ɩ gyɛ asa kɩkalɛ gyankpaasa mʋ nɩɩ ba waa Roma kuwura‐gyii tɔ, saŋa maŋa tɔ nɩɩ Kwirinisi gyɛ Siriya ɔsʋwʋlɛ ɔkɩɩsʋpʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kanɩn sʋ ɔkʋmaa nɩmʋ kpee mʋ kadɛ tɔ kɛ ɔ naa kyʋrɔɔ mʋ kɩtɩɩ. ");
INSERT INTO naw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nɩɩ Gyosefu gbaa kʋsʋ Nasareti kadɛ mʋ nɩɩ kɩ bʋ Galile ɔsʋwʋlɛ sʋ, kpee kadɛ mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ Betilehem mʋ nɩɩ kɩ bʋ Gyudeya ɔsʋwʋlɛ sʋ. Betilehem ɩ gyɛ kadɛ mʋ nɩɩ owura Dawidi lɩɩ. Gyosefu kpee Betilehem kpalɩ fɛɛ ɔ lɩɩ Dawidi kebunɔ nɩn. ");
INSERT INTO naw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Gyosefu taa Mɛɛrɩ mʋ nɩɩ ɔ da mʋ kɔkɔlɔ sʋ yɛ ee biti o kili mʋ mʋ, nɩɩ ba kpee Betilehem ba naa kyʋrɔɔ bamʋ atɩɩ. Kanɩn saŋa maŋa mʋ Mɛɛrɩ sʋ ɔtɔ. ");
INSERT INTO naw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Saŋa mʋ nɩɩ ba bʋ Betilehem mʋ, nɩɩ Mɛɛrɩ saŋa kʋʋgɛsa kɛ fʋʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nɩɩ Mɛɛrɩ kʋʋgɛ mu‐bii‐nyɩnsa gyankpaasa. Nɩɩ ɔ taa akyibi mili kebii mʋ sʋ, nɩɩ ɔ taa mʋ dɩɩla kʋtɔ mʋ nɩɩ atɔbwaaya bee gyii mʋ tɔ. Kpalɩ fɛɛ afɔ ba maa ba kɩkyɔ sʋ mʋ Mɛɛrɩ maa Gyosefu ba man nyɛ opula afɔ obu mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Saŋa maŋa tɔ, nbʋlʋpʋ akpapʋ akʋ ba bʋ kadɛ mʋ afitiri tɔ bɛɛ kɩɩ bamʋ nbʋlʋpʋ sʋ kagyanbwɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nɩɩ opula maa tɔ Ɩbwaarɛ kabɔɔ kʋ kɩ ba bamʋ asɛ, nɩɩ Ɩbwaarɛ bʋnyaa mʋ ŋmaŋɛ tɔ kyaabɔɔ bamʋ. Nɩɩ kufuu kɩ kɩtaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Amaa nɩɩ Ɩbwaarɛ kabɔɔ mʋ tɔwɛ bamʋ yɛ, “Fan man waa kufuu. N bɩya fanɛ asɩn danbɩrasa mʋ nɩɩ ii biti a waa asa kpini ɔkɔn. ");
INSERT INTO naw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ndaga kakɛ nɩmʋ ba kʋʋgɛ Ɔmɔlɩgɛpʋ mʋ Dawidi kadɛ tɔ. Mʋ ɩ gyɛ Ɔnyɩrɩpɛ, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Falɛ nɩɩ fen biti fan wu kesintin mʋ. Fen biti fan wu fɛɛ ba maa taa akyibi mili kebii pʋpwɛ mʋ, nɩɩ ɔ dɛ kʋtɔ mʋ nɩɩ atɔbwaaya bee gyii mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Opula maŋa tɔ nɩɩ Ɩbwaarɛ nbɔɔ kʋbʋ lala kʋ ba lɩɩ sʋsʋ ba tii kabɔɔ mʋ sʋ, nɩɩ ba yɩn Ɩbwaarɛ bɛɛ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Bʋnyaa bʋ Ɩbwaarɛ mʋ nɩɩ ɔ bʋ sʋsʋ mʋ asɛ. Kɛ keyuula ki bun bamʋ nɩɩ ba bɔla mu ansi mʋ kasɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Saŋa mʋ nɩɩ Ɩbwaarɛ nbɔɔ ba lɩɩ bamʋ asɛ kpee sʋsʋ mʋ, nbʋlʋpʋ akpapʋ mʋ ba tɔwɛ abaa yɛ, “Fan yɛgɛ a kpee Betilehem naa kɩɩ kʋtɔ mʋ nɩɩ kɩ waa nɩɩ Ɔnyɩrɩpɛ Ɩbwaarɛ tɔwɛ anɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kanɩn sʋ nɩɩ ba kpaala kpee nɩɩ ba naa wu Mɛɛrɩ maa Gyosefu yɛ kebii pʋpwɛ mʋ maa dɛ kʋtɔ mʋ nɩɩ atɔbwaaya bee gyii tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nbʋlʋpʋ akpaapʋ mʋ ba maa naa wu kebii mʋ, nɩɩ ba tɔwɛ asa kʋtɔ mʋ nɩɩ Ɩbwaarɛ kabɔɔ mʋ ba tɔwɛ bamʋ lɩɩ kebii mʋ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nɩɩ i kyinkyin bamʋ nɩɩ ba nu asɩn mʋ nɩɩ atɔbwaaya akpaapʋ mʋ ba tɔwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nɩɩ Mɛɛrɩ taa asɩn mʋ kpini waa mʋ kɔkɔlɔ tɔ, ɛɛ fɛ ɩmʋ nfɛɛrɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nɩɩ nbʋlʋpʋ akpaapʋ mʋ ba maa bwii bee kpee mʋ, yɛgɛ bɛɛ bɩɩ ɩlʋn bɛɛ yɩn Ɩbwaarɛ, lɩɩ fɛɛ kʋtɔ kʋmaa mʋ nɩɩ ba nu nɩɩ ba wu mʋ, ɩ bɔla sʋ fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ kabɔɔ mʋ kɩ tɔwɛ bamʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kebii mʋ maa fʋʋ nkɛ nburuwa akɛ kɛ ba tɩn mu oduu mʋ, nɩɩ ba yɩla mʋ kɩtɩɩ yɛ Yesu, fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ kabɔɔ mʋ wʋla tɔwɛ yɩla pɔyɩ nɩɩ ba nyɛ mʋ ɔtɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nɩɩ saŋa mʋ maa fʋʋ fɛɛ Gyosefu maa Mɛɛrɩ ba fwɩɩ bamʋ n‐yɩɩ ineesi, fɛɛ kanɩn mʋ nɩɩ Mosesi nbara mʋ ɩ kaapʋ mʋ, kanan sʋ ba taa kebii mʋ kpee Gyerusalem ba naa taa mʋ waa Ɩbwaarɛ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Lɩɩ fɛɛ ba kyʋrɔɔ yɩla Ɩbwaarɛ nbara mʋ tɔ yɛ, “Ɩ dagaa fɛɛ ba taa kebii‐nyɩnsa gyankpaasa kʋmaa nɩmʋ naa sa Ɔnyɩrɩpɛ Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nɩɩ Mɛɛrɩ maa Gyosefu ba naa lɛɛ saraga fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ nbara ɩ kaapʋ mʋ. Nbara mʋ ɩ kaapʋ yɛ, (Ba taa alɔpɔ anyɔ abɛɛ awura‐lɔpɔ pii‐pii anyɔ kpee naa lɛɛ saraga sa Ɩbwaarɛ). ");
INSERT INTO naw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kanan saŋa mʋ ɔnyɩn kʋ bʋ Gyerusalem nɩɩ bɛɛ tɩɩ mʋ yɛ Simeyon. Ɔ gyɛ ɔsa mʋ nɩɩ mʋ ɩkpa i kyiigi nɩɩ ee sun Ɩbwaarɛ yɛ kɔkɔlɔ kʋlʋn, nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ kɩ bɔla mʋ tɔ. Nɩɩ o gyoo saŋa mʋ nɩɩ Ɩbwaarɛ ii biti ɔ bɩya Ɩsɩrayɩ abi kamɔlɩgɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kayaayu Kyɩrɛkyɩrɛ mʋ kɩ lɛɛ kaapʋ mʋ fɛɛ, ɔ mɛɛ yɛ o wu, amɔɔ o wu Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ pɔyɩ kɛ o wu. ");
INSERT INTO naw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Saŋa mʋ nɩɩ Mɛɛrɩ maa Gyosefu ba taa kebii mʋ kpee kabwaarɛ‐sunkpa ayɛ tɔ, kɛ ba naa waa mu kumu sʋ fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ nbara ɩ kaapʋ mʋ, nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ kpiya Simeyon kabwaarɛ‐sunkpa ayɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nɩɩ Simeyon kɔɔlɛ kebii mʋ kɩtaa mʋ abaa tɔ nɩɩ ɔ yɩn Ɩbwaarɛ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ɔnyɩrɩpɛ Ɩbwaarɛ fʋ yɛgɛ nɩɩ asɩn mʋ nɩɩ fʋ tɔwɛ mʋ ɩ ba tɔ, kanɩn sʋ nbɩɩnbɩɩ fɩɩ taalɛ yɛgɛ mɛ, fʋ kɩyaafɔlɛ n wu kayɩɩ yuuli tɔ. ");
INSERT INTO naw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lɩɩ fɛɛ mi ansi i wu Ɔmɔlɩgɛpʋ mʋ nɩɩ fʋ sa asa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mʋ ɩ gyɛ Ɔmʋ nɩɩ fʋ wʋla lɔŋɔ sa asa kpini mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mʋ ɩ gyɛ kaŋmaŋɛ mʋ nɩɩ kii biti kɩ yɛgɛ asa mʋ nɩɩ ba man gyɛ Ɩsɩrayɩ abi mʋ ba bɩɩ fʋ ɔkpa mʋ, kɛ kɩ yɛgɛ fʋ asa, Ɩsɩrayɩ abi gbaa ba nyɛ bʋnyaa.” ");
INSERT INTO naw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Asɩn mʋ nɩɩ Simeyon tɔwɛ lɩɩ kebii mʋ sʋ mʋ, i kyinkyin mu‐nyi yɛ mʋ‐sɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nɩɩ Simeyon waa Mɛɛrɩ maa Gyosefu kusee, nɩɩ ɔ tɔwɛ Mɛɛrɩ yɛ, “Ɩbwaarɛ lɛɛ kebii nɩmʋ nɩn, yɛ kpalɩ mʋ sʋ mʋ, Ɩsɩrayɩ abi gaalaagaa bee biti ba tɩyɛ, kɛ akʋ mɔɔ ba nyɛ kamɔlɩgɛ. Mʋ ii biti ɔ lɛɛ Ɩbwaarɛ asɩn mʋ kaapʋ, kɛ asa ba gyii ɩmʋ ɩmɔɔrɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kɛ asa gaalaagaa nfɛɛrɛ mʋ nɩɩ ɩ bʋ bamʋ amu tɔ mʋ ɩ lɩɩ ifuli. Kɛ fʋ Mɛɛrɩ mɔɔ, fʋ kayɩyɛɛ kii biti kɩ waa fɛɛ deebi bʋyɛsa nɩɩ ba taa yii fʋ kɔkɔlɔ tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Saŋa maŋa mʋ, kakyɩɩ bɩlɩsa kʋ bʋ tɔ, bɛɛ tɩɩ mʋ yɛ Ana nɩɩ ɔ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ. O kili nsu nsunɔ nɩɩ mu‐kuli wu. Mʋ‐sɛ ɩ gyɛ Fanuweli, nɩɩ ɔ lɩɩ Asee kebunɔ. ");
INSERT INTO naw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ɔ kyɩna kukula mʋ tɔ naa fʋʋ saŋa mʋ nɩɩ o gyii nsu aduburuwa yɛ ana. Saŋa kʋmaa kagyanbwɛ yɛ kakyʋwapɛ ee sun Ɩbwaarɛ. Ɔ mɛɛ lɩɩ kabwaarɛ‐sunkpa ayɛ tɔ. Ɔ bʋ tʋtɔ nɩn ee ŋmina kɔnɔ yɛgɛ ɛɛ kʋlɛ kabwaarɛ‐kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Opula maŋa tɔ nɩɩ Ana ba Gyosefu maa Mɛɛrɩ asɛ nɩɩ ɔ fwaala Ɩbwaarɛ, nɩɩ ɔ tɔwɛ kebii mʋ asɩn sa bamʋ nɩɩ ba tɛ ba gyoo Ɔmɔlɩgɛpʋ mʋ nɩɩ ee biti ɔ ba lɛɛ Gyerusalem abi lɩɩ awʋrʋfɔ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Saŋa mʋ nɩɩ Mɛɛrɩ maa Gyosefu ba lʋwɛ kʋtɔ mʋ nɩɩ kɩ dagaa fɛɛ ba waa fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ nbara ɩ kaapʋ mʋ, ba bwii kpewu bamʋ kadɛ tɔ Nasareti mʋ nɩɩ kɩ bʋ Galile ɔsʋwʋlɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nɩɩ Yesu dan nɩɩ ɔ nyɛ ɔlʋn, nɩɩ kanyaasɩn kɩ bɔla mʋ tɔ, nɩɩ Ɩbwaarɛ kabwaala kɩ bʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kesu kʋmaa Gyosefu maa Mɛɛrɩ bee kpee Gyerusalem ba naa gyii Kanyaŋɛ nbunɔ kesu kɔnɔ kɔlɔŋɔ. ");
INSERT INTO naw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu maa gyii nsu kudu anyɔ mʋ, o buu Mɛɛrɩ maa Gyosefu kpee naa gyii kanɩn Kanyaŋɛ nbunɔ mʋ fɛɛ kanan mʋ nɩɩ bamʋ anaana‐tɔ ɩ kaapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ba maa gyii bamʋ nkɛ lʋwɛ nɩɩ ba bwii bee kpewu mʋ, Yesu sii kamaa Gyerusalem tɔ yɛgɛ mʋ akʋʋgɛpʋ ana mʋ ba man nyi. ");
INSERT INTO naw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba nyi fɛɛ ɔ tii kʋbʋ mʋ nɩɩ ba maa bamʋ ba naa mʋ sʋ nɩn, nɩɩ ba natɛ kakɛ ibiri pɔyɩ nɩɩ ba piili bee biti mʋ bamʋ kʋʋpʋ ana yɛ bamʋ kyɛmɩnɛ ana mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba maa man wu mʋ mʋ, nɩɩ ba bwii kpee Gyerusalem ba naa biti mʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kakɛ sasapʋ akɛ mʋ, ba naa wu mʋ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, maa tɛ nbara akaapʋpʋ mʋ asɛ, yɛgɛ ee nu bamʋ asɛ yɛgɛ ɛɛ taasɛ bamʋ asɩn mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bamʋ nɩɩ ba bʋ tʋtɔ nɩɩ ba nu kanan mʋ nɩɩ Yesu lɛɛ asɩn mʋ kasɛ mʋ, i kyinkyin bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Saŋa mʋ nɩɩ mʋ akʋʋgɛpʋ ba naa wu mʋ mʋ, i kyinkyin bamʋ, nɩɩ Mɛɛrɩ taasɛ Yesu yɛ, “Mi‐bii, mɩnɛ nɩɩ fʋ waa anɛ kanɩn? N maa fʋ‐sɛ ansi ɩ payɩ an biti fʋ.” ");
INSERT INTO naw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Mɩnɛ sʋ nɩɩ fan naa fen biti mɛ? Fan man nyi fɛɛ ɩ dagaa fɛɛ n baa n bʋ mɛ‐sɛ ayɛ?” ");
INSERT INTO naw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amaa ba man nu asɩn mʋ nɩɩ ɔ tɔwɛ mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nɩɩ o buu Mɛɛrɩ maa Gyosefu kpee Nasareti, yɛgɛ saŋa kʋmaa ee nu bamʋ asɛ. Amaa mu‐nyi taa asɩn nɩmʋ kpini waa mʋ kɔkɔlɔ tɔ ɛɛ fɛ ɩmʋ nfɛɛrɛ. ");
INSERT INTO naw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nɩɩ Yesu dan n‐yɩɩ tɔ yɛ kanyaasɩn tɔ, nɩɩ ɔ bɔla Ɩbwaarɛ yɛ asa ansi. ");
INSERT INTO naw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Saŋa mʋ nɩɩ Tiberiyu kyɩna ɔ gyɛ Roma ɔsʋwʋlɛ sʋ owura lala nsu kudu anusapu mʋ, saŋa maŋa tɔ mʋ Pontiyu Paleti ɩ kyɩna ɔ gyɛ Gyudeya Kuwura‐bii, nɩɩ Herodi mɔɔ gyɛ Galile Kuwura‐bii, yɛgɛ mu‐supu Filipu mɔɔ ɛɛ kɩɩ Itureya yɛ Tirakoniti ɩsʋwʋlɛ sʋ, nɩɩ Lisaniya mɔɔ ɩ gyɛ Abilene ɔsʋwʋlɛ sʋ Kuwura‐bii. ");
INSERT INTO naw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kanɩn saŋa maa nɩɩ Anasi maa Kayifasi ba gyɛ Ɩbwaarɛ aseepu bɩlɩsa asɛ mʋ. Nɩɩ Ɩbwaarɛ tɔwɛ mʋ asɩn sa Sakariya mu‐bii Gyɔn, saŋa mʋ nɩɩ ɔ bʋ ofuli sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ɩmʋ sʋ Gyɔn natɛ kyaabɔɔ ɔsʋwʋlɛ mʋ nɩɩ kɩ maa Gyɔdan ɔbʋn mʋ ɛɛ tɔwɛ abwaarɛsɩn ɛɛ sa asa yɛ, “Fan kyɛɛgɛ fanɛ nfɛɛrɛ lɩɩ fanɛ alibi tɔ kɛ fan bwii ba Ɩbwaarɛ asɛ, kɛ fan yɛgɛ ba gyee fanɛ Ɩbwaarɛ kekyugyee, kɛ fan nyɛ alibi kɩtaa kɛɛ.” ");
INSERT INTO naw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gyɔn nɩmʋ asɩn nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Isaya wʋla kyʋrɔɔ yɩla mʋ ɔwʋlɛ tɔ mʋ yɛ, “Ɔkʋ bʋ ofuli sʋ ee kuusi ɛɛ tɔwɛ yɛ, ‘Fan lɔŋɔ Ɔnyɩrɩpɛ Ɩbwaarɛ mʋ ɔkpa, kɛ fan kyiigi mʋ ɩkpa‐bi mʋ. ");
INSERT INTO naw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kɛ fan tii‐tii igee mʋ, kɛ fan tɩtɛ abɩɩ yɛ abɩɩ‐bi mʋ ba kasɛ waa kyɛɛkyɛɛ. Kɛ fan kyiigi ɩkpa nyɔnsa mʋ, kɛ ɩkpa gogyigogyi mʋ i tii waa tɔlɩtɔlɩ. ");
INSERT INTO naw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kɛ daadimaadi kpini ba wu Ɔmʋ nɩɩ Ɩbwaarɛ lɛɛ yɛ ɔ ba mɔlɩgɛ asa mʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nɩɩ Gyɔn tɔwɛ sakyɔ mʋ nɩɩ bɛɛ ba mʋ asɛ yɛ o gyee bamʋ Ɩbwaarɛ kekyugyee mʋ yɛ, “Fan du fɛɛ anansɛ mʋ nɩɩ ba sʋ kʋbwɛ. Nbɩɩnbɩɩ bɩrɛ anɩmʋ ɩ da fanɛ amu tɔ yɛ fan sɩlɛ lɩɩ Ɩbwaarɛ agbʋ mʋ nɩɩ ɩ gyɛ fanɛ kʋsʋ bɩɩtɛ mʋ mʋ tɔ? ");
INSERT INTO naw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Fan waa adanbɩrasa mʋ nɩɩ ɩɩ kaapʋ fɛɛ fan kyɛɛgɛ fanɛ nfɛɛrɛ lɩɩ fanɛ alibi tɔ ba Ɩbwaarɛ asɛ. Kɛ fan yɛgɛ kɩtɔwɛ yɛ, ‘An lɩɩ Abraham kɩnaana tɔ nɩn, ɩmʋ sʋ Ɩbwaarɛ mɛɛ yɛ ɔ bɩɩtɛ anɛ kʋsʋ.’ N tɔwɛ fanɛ yɛ Ɩbwaarɛ ɩ taalɛ yɛgɛ abuu nɩmʋ a biliŋi Abraham anaana‐bii. ");
INSERT INTO naw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ba tɛɛ wʋla taa kpanfa waa oyu mʋ ilin tɔ, lɩɩ fɛɛ oyu kʋmaa mʋ nɩɩ kɩ mɛɛ sɔyɩ abi danbɩrasa mʋ, bee biti ba ŋɛ kɩmʋ tʋʋ kasɛ, kɛ ba taa tʋʋ waa fʋlɔn tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gyɔn maa tɔwɛ kanɩn mʋ, nɩɩ sakyɔ mʋ taasɛ mʋ yɛ, “Ɩmʋ sʋ nɛnɛ nɩɩ an biti a waa?” ");
INSERT INTO naw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nɩɩ Gyɔn lɛɛ kɔnɔ yɛ, “Ɔkʋmaa mʋ nɩɩ ɔ sʋ ɩkaalɛ ɩnyɔ mʋ, ɔ barɩgɛ tɔ sa mʋ tɔmaa mʋ nɩɩ ɔ man sʋ, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ sʋ agyitɔ gbaa, ɔ waa kanɩn.” ");
INSERT INTO naw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lenpoo akɔɔlɛpʋ akʋ gbaa ba ba yɛ o gyee bamʋ Ɩbwaarɛ kekyugyee. Nɩɩ ba taasɛ mʋ yɛ, “Ɔkaapʋpʋ, nɛnɛ nɩɩ an biti a waa?” ");
INSERT INTO naw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nɩɩ ɔ lɛɛ bamʋ kɔnɔ yɛ, “Fan man kɔɔlɛ afulee kyʋn kanan mʋ nɩɩ ɩ dagaa fɛɛ fan kɔɔlɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nɩɩ anaakɔpʋ mʋ akʋ ba ba taasɛ Gyɔn yɛ, “Nɛnɛ nɩɩ anɛ gbaa anɛ an biti a waa?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Fan man nyan ɔkʋ kɔɔlɛ mu afulee, kɛ fan man pwɩɩ asa mʋ nɩɩ bamʋ asɩn a dɛ ɔkpa, amaa ɩmʋ nɩɩ bɛɛ ka fanɛ mʋ ɩ kʋkwɛ fanɛ.” ");
INSERT INTO naw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɩ maa waa fɛɛ asa mʋ kpini bɛɛ kɩɩ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ ɔkpa mʋ, ɔkʋmaa nɩmʋ ɩɩ fɛ nfɛɛrɛ fɛɛ akʋtɔ fɛɛ Gyɔn ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ɩmʋ sʋ Gyɔn tɔwɛ asa mʋ kpini yɛ, “Nkyu nɩɩ n sʋ n gyee fanɛ Ɩbwaarɛ kekyugyee, amaa ɔmʋ nɩɩ ɔ kyɔ mɛ gaa mʋ ɩɩ ba. Nɩɩ n man dagaa gbaa fɛɛ n muŋa saŋɛ mʋ asɩbɩta ɩfɛ. Nɩɩ mɛɛ mʋ ii biti ɔ taa Kayaayu Kyɩrɛkyɩrɛ yɛ fʋlɔn gyee fanɛ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nɩɩ ɔ sʋ mʋ kʋtɔ kyaalɛsa mʋ kɩbaa tɔ, ee biti ɔ ba kyaalɛ ayu lɩɩ ayu‐waatɛ tɔ, kɛ ɔ laata ayubi mʋ waa kikyunkun tɔ, kɛ o tuwa ayu‐waatɛ mʋ fʋlɔn mʋ nɩɩ ii mee dun kpaa.” ");
INSERT INTO naw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ɩkpa damantɛ sʋ nɩɩ Gyɔn taa kɩtaa asa mʋ nkɔlɔ, nɩɩ ɔ tɔwɛ asɩn danbɩrasa mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ɩmʋ kamaa mʋ Gyɔn pwɩɩ owura Herodi, lɩɩ fɛɛ ɔ taa mu‐supu Filipu mʋ‐ka Herodiya kili, yɛ asɩn libi mʋ nɩɩ ɔ waa tii sʋ. ");
INSERT INTO naw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Amaa alibi mʋ nɩɩ Herodi bɩla waa tii sʋ mʋ ɩ gyɛ fɛɛ kamaa tɔ mʋ ɔ kɩtaa Gyɔn tii obu. ");
INSERT INTO naw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Saŋa mʋ nɩɩ Gyɔn i gyee asa Ɩbwaarɛ kekyugyee mʋ, o gyee Yesu gbaa. Nɩɩ Yesu maa kʋlɛ kabwaarɛ‐kʋlɛ mʋ, nɩɩ sʋsʋ bugi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ kɩ kpɩlɩgɛ fɛɛ kuwura‐lɔpɔ ba gyɔŋɔ mʋ sʋ. Nɩɩ ɔbʋlɛ kʋ lɩɩ sʋsʋ tɔwɛ yɛ, “Fʋ ɩ gyɛ mi‐bii bitisa mʋ, nɩɩ fʋ ɩ bɔla mi ansi.” ");
INSERT INTO naw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Saŋa mʋ nɩɩ Yesu gyii nsu adɩsa mʋ, nɩɩ o piili mu kusun mʋ nɩɩ Ɩbwaarɛ sun mʋ yɛ ɔ ba waa mʋ. Nɩɩ asa bɛɛ kɩɩ fɛɛ Yesu gyɛ Gyosefu mu‐bii. Gyosefu mʋ gyɛ Heli mu‐bii. ");
INSERT INTO naw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nɩɩ Heli mʋ‐sɛ ɩ gyɛ Matati, nɩɩ Matati mʋ‐sɛ ɩ gyɛ Lewi, nɩɩ Lewi mʋ‐sɛ ɩ gyɛ Malikin, nɩɩ Maliki mʋ‐sɛ ɩ gyɛ Gyanayi, Gyanayi mʋ‐sɛ ɩ gyɛ Gyosefu kʋ. ");
INSERT INTO naw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Gyosefu nɩmʋ mʋ‐sɛ ɩ gyɛ Matatiya, Matatiya mʋ‐sɛ ɩ gyɛ Amosi, nɩɩ Amosi mʋ‐sɛ ɩ gyɛ Nahum, nɩɩ Nahum mʋ‐sɛ ɩ gyɛ Isili, nɩɩ Isili mʋ‐sɛ ɩ gyɛ Nagayi. ");
INSERT INTO naw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nɩɩ Nagayi mʋ‐sɛ ɩ gyɛ Mati, nɩɩ Mati mʋ‐sɛ ɩ gyɛ Matatiya, nɩɩ Matatiya mʋ‐sɛ ɩ gyɛ Semen, nɩɩ Semen mʋ‐sɛ ɩ gyɛ Gyoseki, nɩɩ Gyoseki mʋ‐sɛ ɩ gyɛ Gyoda. ");
INSERT INTO naw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Nɩɩ Gyoda mʋ‐sɛ ɩ gyɛ Gyowanan, nɩɩ Gyowanan mʋ‐sɛ ɩ gyɛ Resa, nɩɩ Resa mʋ‐sɛ ɩ gyɛ Serubabeli, nɩɩ Serubabeli mʋ‐sɛ ɩ gyɛ Selatiye, nɩɩ Selatiye mʋ‐sɛ ɩ gyɛ Neri. ");
INSERT INTO naw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mʋ‐sɛ ɩ gyɛ Maliki, nɩɩ Maliki mʋ‐sɛ ɩ gyɛ Adi, nɩɩ Adi mʋ‐sɛ ɩ gyɛ Kosam, nɩɩ Kosam mʋ‐sɛ ɩ gyɛ Elimadam, nɩɩ Elimadam mʋ‐sɛ ɩ gyɛ Eri. ");
INSERT INTO naw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Nɩɩ Eri mʋ‐sɛ ɩ gyɛ Gyosuwa, nɩɩ Gyosuwa mʋ‐sɛ ɩ gyɛ Eliyasa, nɩɩ Eliyasa mʋ‐sɛ ɩ gyɛ Gyorim, nɩɩ Gyorim mʋ‐sɛ ɩ gyɛ Matati, nɩɩ Matati mʋ‐sɛ ɩ gyɛ Lewi. ");
INSERT INTO naw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nɩɩ Lewi mʋ‐sɛ ɩ gyɛ Simeyon, nɩɩ Semiyon mʋ‐sɛ ɩ gyɛ Gyuda, nɩɩ Gyuda mʋ‐sɛ ɩ gyɛ Gyosefu, nɩɩ Gyosefu mʋ‐sɛ ɩ gyɛ Gyonam, nɩɩ Gyonam mʋ‐sɛ ɩ gyɛ Eliyakim. ");
INSERT INTO naw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Nɩɩ Eliyakim mʋ‐sɛ ɩ gyɛ Meliya, nɩɩ Meliya mʋ‐sɛ ɩ gyɛ Mena, nɩɩ Mena mʋ‐sɛ ɩ gyɛ Matata, nɩɩ Matata mʋ‐sɛ ɩ gyɛ Natan, nɩɩ Natan mʋ‐sɛ ɩ gyɛ Dawidi. ");
INSERT INTO naw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nɩɩ Dawidi mʋ‐sɛ ɩ gyɛ Gyeese, nɩɩ Gyeese mʋ‐sɛ ɩ gyɛ Obedi, Obedi mʋ‐sɛ ɩ gyɛ Bowasi, nɩɩ Bowasi mʋ‐sɛ ɩ gyɛ Salimon, nɩɩ Salimon mʋ‐sɛ ɩ gyɛ Naason. ");
INSERT INTO naw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nɩɩ Naason mʋ‐sɛ ɩ gyɛ Aminadabi, nɩɩ Aminadabi mʋ‐sɛ ɩ gyɛ Ram, nɩɩ Ram mʋ‐sɛ ɩ gyɛ Hesiron, nɩɩ Hesiron mʋ‐sɛ ɩ gyɛ Peresi, nɩɩ Peresi mʋ‐sɛ ɩ gyɛ Gyuda. ");
INSERT INTO naw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Nɩɩ Gyuda mʋ‐sɛ ɩ gyɛ Gyekobu, Gyekobu mʋ‐sɛ ɩ gyɛ Isaki, Isaki mʋ‐sɛ ɩ gyɛ Abraham, nɩɩ Abraham mʋ‐sɛ ɩ gyɛ Tera, nɩɩ Tera mʋ‐sɛ ɩ gyɛ Naho. ");
INSERT INTO naw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nɩɩ Naho mʋ‐sɛ ɩ gyɛ Serugi, nɩɩ Serugi mʋ‐sɛ ɩ gyɛ Rewu, Rewu mʋ‐sɛ ɩ gyɛ Pelegi, nɩɩ Pelegi mʋ‐sɛ ɩ gyɛ Ebe, nɩɩ Ebe mʋ‐sɛ ɩ gyɛ Sela. ");
INSERT INTO naw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Nɩɩ Sela mʋ‐sɛ ɩ gyɛ Kenan, nɩɩ Kenan mʋ‐sɛ ɩ gyɛ Afahadi, nɩɩ Afahadi mʋ‐sɛ ɩ gyɛ Sem, nɩɩ Sem mʋ‐sɛ ɩ gyɛ Nowa, nɩɩ Nowa mʋ‐sɛ ɩ gyɛ Lameki. ");
INSERT INTO naw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nɩɩ Lameki mʋ‐sɛ ɩ gyɛ Metusala, Metusala mʋ‐sɛ ɩ gyɛ Enoki, nɩɩ Enoki mʋ‐sɛ ɩ gyɛ Gyaredi, nɩɩ Gyaredi mʋ‐sɛ ɩ gyɛ Mahalale, nɩɩ Mahalale mʋ‐sɛ ɩ gyɛ Keyinan. ");
INSERT INTO naw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Nɩɩ Keyinan mʋ‐sɛ ɩ gyɛ Enosi, nɩɩ Enosi mʋ‐sɛ ɩ gyɛ Seti, nɩɩ Seti mʋ‐sɛ ɩ gyɛ Adam. Nɩɩ Adam gyɛ Ɩbwaarɛ mu‐bii. ");
INSERT INTO naw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu maa lɩɩ Gyɔdan ɔbʋn mʋ tɔ ba mʋ, yɛgɛ Kayaayu Kyɩrɛkyɩrɛ mʋ kɩ bɔla mʋ, nɩɩ Kayaayu maŋa yɛgɛ nɩɩ o kpee ofuli sʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Maa bʋ ofuli mʋ sʋ nkɛ adɩna mʋ, nɩɩ Sɩtaanɛ ii kpee ɛɛ tʋʋ mʋ tɔ ɩɩ kɩɩ. Kanɩn nkɛ nɩmʋ kpini mʋ ɔ man gyii sɛhn, ɩmʋ sʋ laalaalʋwɛ mʋ akʋn a kɩtaa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nɩɩ ɩ tɔwɛ mʋ yɛ, “Nɩɩ fʋ gyɛ Ɩbwaarɛ mu‐bii kʋlʋn mʋ de, yɛgɛ kubuu nɩmʋ ki biliŋi bodobodo.” ");
INSERT INTO naw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɩbwaarɛ Asɩnkyan yɩlasa mʋ ɩɩ tɔwɛ yɛ, ‘Ɩ man gyɛ agyitɔ nkʋn sʋ nɩɩ nyɩmɩsa ii biti ɔ nyɛ nkpa.’ ” ");
INSERT INTO naw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nɩɩ ɔ taa mʋ kpee kɩbɩɩ bʋnswɩɩsa kʋ sʋ, nɩɩ ɔ taa awuragyi mʋ nɩɩ ɩ bʋ dulinyaa tɔ mʋ kpini kaapʋ mʋ opula tɔ. ");
INSERT INTO naw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nɩɩ ɔ tɔwɛ Yesu yɛ, “N biti n sa fʋ awuragyi mʋ ɔlʋn yɛ ɩmʋ bʋnyaa lɩɩ atɔ nɩmʋ kpini sʋ. Lɩɩ fɛɛ ɩmʋ kpini ba taa waa mɛ abaa tɔ nɩn, nɩɩ n taalɛ taa sa ɔkʋmaa mʋ nɩɩ n biti. ");
INSERT INTO naw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ɩmʋ sʋ nɩɩ fʋ kan muŋa sun mɛ mʋ, ɩmʋ kpini ii biti i biliŋi fʋ lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɩbwaarɛ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ, ‘Muŋa fʋ‐Nyɩrɩpɛ Ɩbwaarɛ, nɩɩ mʋ nkʋn nɩɩ ɩ dagaa fɛɛ fʋ maa sun.’ ” ");
INSERT INTO naw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tʋtɔ ɔ nɩɩ bɩla kpiya mʋ Gyerusalem naa yɩlɛ kabwaarɛ‐sunkpa ayɛ mʋ ketin tɔ. Nɩɩ ɔ tɔwɛ mʋ yɛ, “Nɩɩ fʋ kan fʋ gyɛ Ɩbwaarɛ mu‐bii kʋlʋn mʋ, yɛgɛ fʋ n‐yɩɩ tɔ lɩɩ tʋtɔ ba tɩyɛ kasɛ. ");
INSERT INTO naw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Lɩɩ fɛɛ Ɩbwaarɛ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ, ‘Ɩbwaarɛ ii biti o sun mʋ nbɔɔ kɛ ba be kun fʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bee biti ba sɔgɩta fʋ, kɛ fʋ man tɩyɛ kasɛ kɛ fʋ ayaa a man da abuu.” ");
INSERT INTO naw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɩbwaarɛ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ, ‘Man kan tʋʋ fʋ‐Nyɩrɩpɛ Ɩbwaarɛ tɔ kɩɩ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saŋa mʋ nɩɩ ɔ tʋʋ mʋ tɔ ɔkpa kʋmaa sʋ kpɩnɛ mʋ, ɔ san yɛgɛ mʋ o gyoo saŋa mʋ nɩɩ ee biti ɔ nyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lɩɩ Kayaayu Kyɩrɛkyɩrɛ ɔlʋn tɔ sʋ mʋ, Yesu bwii kpee Galile ɔsʋwʋlɛ sʋ, nɩɩ mʋ asɩn ɩ yalagɛ ɩsʋwʋlɛ mʋ nɩɩ ɩ kyaabɔ tʋtɔ kpini. ");
INSERT INTO naw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nɩɩ ɔ kaapʋ Abwaarɛsɩn Gyiwu abi kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa, nɩɩ ɔkʋmaa nɩmʋ yɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nɩɩ o kpee Nasareti katɩn mʋ nɩɩ ba bɩla mʋ mʋ, nɩɩ kakɛ fʋʋtɛsa akɛ mʋ, o kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa fɛɛ kanan mʋ nɩɩ ɔ wʋla ɛɛ waa mʋ. Nɩɩ ɔ kʋsʋ yɩlɛ kɛ ɔ kalɛ Abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nɩɩ ba taa Ɩbwaarɛ ɔtɔwɛpʋ Isaya ɔwʋlɛ mʋ bɔɔta mʋ. Maa bugi tɔ mʋ, o biti wu nɩɩ ɔ kalɛ katɩn mʋ nɩɩ ba kyʋrɔɔ yɩla yɛ, ");
INSERT INTO naw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ɩbwaarɛ Kayaayu Kyɩrɛkyɩrɛ mʋ kɩ bʋ mɛ asɛ, lɩɩ fɛɛ ɔ lɛɛ mɛ nɩn fɛɛ n tɔwɛ asɩn danbɩrasa mʋ sa atiripu. O sun mɛ yɛ n ba tɔwɛ kamɔlɩgɛ asɩn sa bamʋ nɩɩ ba tii bamʋ ibu mʋ. O sun mɛ yɛ n ba bugi agyaatanapʋ ansi, kɛ bamʋ nɩɩ asa bee sisii bamʋ mʋ, bee biti ba nyɛ bamʋ n‐yɩɩ. ");
INSERT INTO naw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","O sun mɛ yɛ n ba da kibonbon fɛɛ Ɔnyɩrɩpɛ Ɩbwaarɛ kamɔlɩgɛ saŋa mʋ fʋʋ.” ");
INSERT INTO naw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu maa kalɛ lʋwɛ mʋ, ɔ bɔɔ ɔwʋlɛ mʋ bwiiyaa sa ɔmʋnɩ ɛɛ kɩɩ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa mʋ sʋ mʋ, nɩɩ ɔ naa kyɩna. Nɩɩ bamʋ nɩɩ ba bʋ ɔgyaŋɛkpa mʋ kpini ansi i yii mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nɩɩ ɔ tɔwɛ yɛ, “Ndaga Ɩbwaarɛ Asɩnkyan yɩlasa ɩnɩmʋ ɩ ba tɔ nɩɩ ɩ gyɛ mɛ asɩn fɛɛ kanan mʋ nɩɩ fan nu n maa kalɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nɩɩ Yesu kɔnɔ tɔ asɩn danbɩrasa mʋ i kyinkyin bamʋ nɩɩ ba bʋ tʋtɔ mʋ kpini, nɩɩ ba yɩn mʋ. Nɩɩ ba taasɛ abaa yɛ, man gyɛ Gyosefu mu‐bii mʋ nɩn? ");
INSERT INTO naw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N nyi fɛɛ fen biti fan bɔ mɛ kɩŋasan nɩmʋ yɛ ‘Ɔkyɛpʋ, kyɛ fʋ n‐yɩɩ.’ Nɩɩ fen biti fan bɩla tɔwɛ yɛ, ‘Atɔ mʋ nɩɩ an nu fɛɛ fʋ waa Kapanum kadɛ tɔ mʋ, waa ɩmʋ fʋ kadɛ tɔ nfɩɩ.’ ");
INSERT INTO naw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“N tɔwɛ fanɛ kesintin yɛ Ɩbwaarɛ ɔtɔwɛpʋ kʋmaa nɩmʋ man sʋ bɛɛrɛɛ mʋ ayɛ. ");
INSERT INTO naw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nɩɩ n biti fan wu kesintin fɛɛ, Ɩbwaarɛ ɔtɔwɛpʋ Eligya saŋa mʋ, akulapu‐kyɩɩ ba kyɩna ba kyɔ Ɩsɩrayɩ ɔsʋwʋlɛ mʋ sʋ. Saŋa maŋa tɔ bʋlayɩ yɩlɛ nsu nsa yɛ ɩbwaayɩ isiye nɩɩ akʋn a ba ɔsʋwʋlɛ mʋ kpini sʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amaa Ɩbwaarɛ man sun Eligya bamʋ ɔkʋlʋn gbaa asɛ, amɔɔ okulapu‐kyɩɩ mʋ nɩɩ ɔ bʋ Sarefati kadɛ mʋ nɩɩ kɩ bʋ Sidon kabaafʋn sʋ mʋ nkʋn asɛ. ");
INSERT INTO naw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Elisa saŋa mʋ, abootipu ba kyɔ Ɩsɩrayɩ ɔsʋwʋlɛ sʋ, amaa Elisa man kyɛ bamʋ ɔkʋ, amɔɔ ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Naaman mʋ nɩɩ ɔ gyɛ Kesiriya‐nyɩn mʋ nkʋn nɩɩ ɔ kyɛ.” ");
INSERT INTO naw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Asa mʋ nɩɩ ba bʋ ɔgyaŋɛkpa tʋtɔ mʋ, ba maa nu asɩn nɩmʋ mʋ, nɩɩ agbʋ a kɩtaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nɩɩ ba kʋsʋ bɩɩtɛ Yesu lɛɛ kadɛ mʋ tɔ, nɩɩ ba taa mʋ dii kpee kɩbɩɩ mʋ nɩɩ bamʋ kadɛ kɩ gyan sʋ mu kumu tɔ, paa fɛɛ ba yɛgɛ mʋ tʋʋ kɩbɩɩ maŋa ogee tɔ. ");
INSERT INTO naw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amaa ɔ dan natɛ bʋlɛ asa damantɛ mʋ nsana kyʋn. ");
INSERT INTO naw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lɩɩ tʋtɔ mʋ nɩɩ Yesu kpee Kapanum kadɛ mʋ nɩɩ kɩ bʋ Galile ɔsʋwʋlɛ sʋ mʋ tɔ, nɩɩ kakɛ fʋʋtɛsa akɛ mʋ, o piili ɛɛ kaapʋ asa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mʋ kɩkaapʋ mʋ ki kyinkyin bamʋ, lɩɩ fɛɛ ɩ sʋ ɔlʋn. ");
INSERT INTO naw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nɩɩ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa mʋ tɔ mʋ, ɔnyɩn kʋ kyɩna ɔ sʋ nbwɩɩ libi, nɩɩ kayaayu bʋ mʋ sʋ, maa wu Yesu mʋ, nɩɩ o kuusi kenken yɛ, ");
INSERT INTO naw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ndo! Yesu Kanasareti‐nyɩn, mɩnɛ nɩɩ fii biti anɛ asɛ? Fʋ ba fʋ ba nyita anɛ nɩn? N nyi ɔsa mʋ nɩɩ fʋ gyɛ, fʋ ɩ gyɛ Ɩbwaarɛ Nyɩmɩsa Kyɩrɛkyɩrɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tʋtɔ nɩɩ Yesu pʋntɛ kabwɩɩ libi mʋ sʋ yɛ, “Laatɔ, kɛ fʋ lɩɩ ɔnyɩn mʋ tɔ.” Nɩɩ kabwɩɩ libi mʋ taa kanyɩn mʋ tʋʋ kasɛ bamʋ ansi tɔ, nɩɩ ɔ lɩɩ mʋ tɔ kyʋn yɛgɛ ɔ man taalɛ waa mʋ sɛhn. ");
INSERT INTO naw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nɩɩ ɩ waa asa mʋ kpini kɩyan nɩɩ bɛɛ tɔwɛ abaa yɛ, “Mɩnɛ kɩkaapʋ ndee? Ɔnyɩn nɩmʋ taa kɩnyɩn yɛ ɔlʋn ɛɛ pʋntɛ n‐yaayu libi sʋ nɩɩ bɛɛ lɩɩ asa tɔ!” ");
INSERT INTO naw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nɩɩ Yesu n‐yɩɩ sʋ asɩn mʋ ɩ yɛlɩgɛ kyaabɔɔ ɔsʋwʋlɛ maŋa sʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu maa lɩɩ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa obu mʋ tɔ mʋ, o kpee Simon ayɛ. Yɛgɛ Simon mʋ‐saa kyɩɩsa dɛ ɛɛ lɔ kibirima bʋlʋnsa, nɩɩ ba kʋlɛ Yesu yɛ ɔ ba kɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nɩɩ ɔ naa yɩlɛ mʋ asɛ nɩɩ ɔ tɔwɛ kibirima mʋ yɛ kɩ lɩɩ ɔkyɩɩ mʋ tɔ, nɩɩ kibirima mʋ kɩ yɛgɛ mʋ. Nɩɩ ɔkyɩɩ mʋ kɩtaa bamʋ kɩfɔ. Nɩɩ ɔ kʋsʋ kɩtaa bamʋ kɩfɔ. ");
INSERT INTO naw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Saŋa mʋ nɩɩ kyɔwɛ kpee ɔ naa tɩyɛ mʋ, asa mʋ ba taa alɔpʋ mʋ nɩɩ bɛɛ lɔ alɔ yiri‐yiri mʋ ba Yesu asɛ. Nɩɩ ɔ taa mʋ abaa gyaga bamʋ ɔkʋmaa nɩmʋ sʋ nɩɩ ɔ kyɛ bamʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nɩɩ ɔ bɩla gya nbwɩɩ libi lɩɩ asa gaalaagaa tɔ, yɛgɛ bee kuusi kenken bɛɛ tɔwɛ yɛ, “Fʋ ɩ gyɛ Ɩbwaarɛ Mu‐Bii mʋ.” Amaa nɩɩ ɔ pʋntɛ bamʋ sʋ, nɩɩ ɔ man yɛgɛ bamʋ ba tɔwɛ sɛhn, lɩɩ fɛɛ be nyi maa gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kayɩɩ maa kɛ mʋ Yesu kpee opula mʋ nɩɩ i du surum, nɩɩ asa mʋ ba lɩɩ ba naa bee biti mʋ. Ba maa ba wu mʋ mʋ, ba man bɩla bee biti fɛɛ ɔ lɩɩ bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amaa ɔ tɔwɛ bamʋ yɛ, “Ɩ dagaa fɛɛ n maa tɔwɛ Ɩbwaarɛ kuwura‐gyii asɩn danbɩrasa mʋ sa ndɛ kʋ asa gbaa, lɩɩ fɛɛ ɩmʋ sʋ nɩɩ Ɩbwaarɛ sun mɛ.” ");
INSERT INTO naw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nɩɩ Yesu kyaga sʋ ɛɛ tɔwɛ asɩn danbɩrasa mʋ Gyiwu abi kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa, mʋ nɩɩ ɩ bʋ Gyudeya ɔsʋwʋlɛ sʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kakaakʋ nɩɩ Yesu kpee ɔ yɩlɛ Kanesareti ɔbʋn mʋ nɩɩ ba bɩla bɛɛ tɩɩ yɛ Galile mʋ ɔbʋn‐kaa. Nɩɩ asa ba naa kyaabɔɔ mʋ bee nin abaa kɛ ba naa nu abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu wu ɩkʋlɩ ɩnyɔ ɩ maa dan kebunɔ maŋa yɛgɛ ɩkɩn akɩtapʋ mʋ bɛɛ fwɩɩ bamʋ asawu. ");
INSERT INTO naw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nɩɩ Yesu loo ɔkʋlɩ mʋ kʋkʋ, mʋ nɩɩ kɩ gyɛ Simon lɛɛ tɔ. Nɩɩ ɔ tɔwɛ mʋ yɛ o nin waa tɔ gbɛrɛɛ. Ɔkʋlɩ maŋa tɔ nɩɩ Yesu kyʋn kyɩna yɛgɛ ɛɛ tɔwɛ kʋbʋ mʋ nɩɩ kɩ sarɛ tʋtɔ mʋ abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesu maa tɔwɛ abwaarɛsɩn mʋ lʋwɛ mʋ, nɩɩ ɔ tɔwɛ Simon yɛ “Palɛ fʋ ɔkʋlɩ mʋ kpee katɩn mʋ nɩɩ ɩ bʋnyɛ, kɛ faa fʋ tɔɔmaa ana mʋ fan tʋʋ fanɛ asawu kɩtaa ɩkɩn.” ");
INSERT INTO naw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nɩɩ Simon lɛɛ kɔnɔ yɛ, “Mɛ ɔbɩlɩsa, an tʋʋ nɩn halɩɩ ba kalayɩ, a man kɩtaa sɛhn, amaa nɩɩ fʋ tɔwɛ kanɩn bɩrɛ, n biti n tʋʋ.” ");
INSERT INTO naw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nɩɩ ba maa tʋʋ asawu mʋ, ba kɩtaa ɩkɩn kɩbansa halɩɩ bamʋ asawu mʋ ɩ san gbaa kyatɛ. ");
INSERT INTO naw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tʋtɔ nɩɩ ba da abaa tɩɩ bamʋ tɔɔmaa ana mʋ nɩɩ ba bʋ ɔkʋlɩ nyɔsapʋ mʋ tɔ yɛ ba ba kyɛ bamʋ tɔ. Ɩkʋlɩ ɩnyɔ mʋ kpini yɛ ɩmaa ɩmʋ ɩkɩn mʋ ɩ san gbaa muuri. ");
INSERT INTO naw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Pita maa wu kʋtɔ mʋ nɩɩ ɩ waa mʋ, nɩɩ ɔ kyʋn muŋa mu amulii sʋ Yesu ansi tɔ tɔwɛ yɛ, “Ɔnyɩrɩpɛ, lɩɩ mɛ asɛ, n gyɛ alibi ɔwaapʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Lɩɩ ɩkɩn damantɛ mʋ nɩɩ ba kɩtaa mʋ sʋ mʋ, i kyinkyin maa mʋ tɔmaa ana kpini. ");
INSERT INTO naw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ɩkɩn mʋ kɩkɩta mʋ gbaa ki kyinkyin Gyemisi maa Gyɔn, Sebedi mu‐bii ana mʋ nɩɩ ba maa Simon bee sun kusun mʋ. Nɩɩ Yesu tɔwɛ Simon yɛ, “Man waa kufuu, lɩɩ ndaga ɩ sʋ ii kpee mʋ, fii biti fʋ ba fɩɩ kɩtaa asa fɩɩ bɩya mɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nɩɩ ba bɩɩtɛ ɩkʋlɩ mʋ ba dan kidenbi sʋ, nɩɩ ba yɛgɛ kʋtɔ kʋmaa nɩmʋ nɩɩ ba buu Yesu. ");
INSERT INTO naw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu maa bʋ kadɛ kʋ sʋ mʋ, ɔnyɩn kʋ gbaa bʋ tʋtɔ nɩɩ kibootoo kɩtaa mʋ n‐yɩɩ sʋ kpini. Saŋa mʋ nɩɩ o wu Yesu mʋ, o be muŋa mu ansi tɔ kʋlɛ mʋ yɛ, “Ɔnyɩrɩpɛ, nɩɩ fii biti mʋ, fɩɩ taalɛ yɛgɛ mɛ n‐yɩɩ ɩ lɔŋɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nɩɩ Yesu tɛɛŋɛ mʋ kɩbaa mata mʋ. Nɩɩ ɔ tɔwɛ mʋ yɛ, “N biti, lɔŋɔ sʋ.” Nɩɩ opula maŋa tɔ kibootoo mʋ kɩ yɛgɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nɩɩ Yesu da ɔnyɩn mu kumu tɔ yɛ, “Man kan waa tɔwɛ ɔkʋ, amaa taa fʋ n‐yɩɩ kaapʋ Ɩbwaarɛ oseepu mʋ, kɛ fʋ naa lɛɛ saraga fɛɛ kanan mʋ nɩɩ Mosesi nbara mʋ ɩ kaapʋ mʋ, kɛ ɩ kaapʋ tɔ sa ɔkʋmaa nɩmʋ fɛɛ fʋ n‐yɩɩ ɩ lɔŋɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amaa Yesu n‐yɩɩ sʋ asɩn mʋ ɩ lɔŋɔ yalagɛ tɔ, nɩɩ ɩ yɛgɛ nɩɩ asa damantɛ ba be nu mʋ asɛ, nɩɩ ɔ kyɛ bamʋ nɩɩ bɛɛ lɔ mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amaa saŋa kʋmaa Yesu ɩɩ lɩɩ mʋ nkʋn ee kpee ɛɛ kʋlɛ kabwaarɛ‐kʋlɛ, opula mʋ nɩɩ o du surum. ");
INSERT INTO naw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kakaakʋ Yesu maa kaapʋ abwaarɛsɩn mʋ, Farasii abi yɛ nbara akaapʋpʋ mʋ nɩɩ ba lɩɩ Galile yɛ Gyudeya ɩsʋwʋlɛ sʋ yɛ Gyerusalem kadɛ tɔ mʋ ba tɛ tʋtɔ. Ɔnyɩrɩpɛ Ɩbwaarɛ ɔlɔn mʋ bʋ mʋ asɛ fɛɛ ɔ taa kyɛ alɔpʋ. ");
INSERT INTO naw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nɩɩ anyɩn akʋ ba sʋla ɔnyɩn mʋ nɩɩ mʋ n‐yɩɩ i wu nɩɩ ɔ dɛ kalan sʋ. Ba kpan bamʋ n‐yɩɩ ba taa mʋ loo kɩkpaara mʋ sʋ, naa yɩla Yesu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lɩɩ sakyɔ mʋ sʋ mʋ, ba man nyɛ ɔkpa ba taa mʋ loo kɩkpaara mʋ sʋ. Ɩmʋ sʋ ba dii kpee obu mʋ sʋsʋ, katɩn mʋ nɩɩ ba taa ɩsɛɛ nyalɛ munla mʋ sʋ, nɩɩ ba foti ɔbɔ kpɩlɩgaa mʋ yɛgɛ ɔ dɛ mʋ kalan sʋ sakyɔ mʋ nsana yɩla Yesu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu maa wu kɩkɔɔlɛ‐gyii mʋ nɩɩ ba sʋ mʋ sʋ mʋ, ɔ tɔwɛ ɔnyɩn mʋ yɛ “Mɛ kyɛmɩnɛ n taa fu alibi kɛɛ fu.” ");
INSERT INTO naw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nɩɩ Farasii abi yɛ nbara akaapʋpʋ mʋ ba piili bɛɛ fɛ nfɛɛrɛ bamʋ amu tɔ yɛ “Anɩmʋ ɩ gyɛ ɔsa nɩmʋ nɩɩ ɛɛ tɔwɛ nbusaa asɩn kanɩn? Anɩmʋ ɩ taalɛ taa alibi kɛɛ tii Ɩbwaarɛ sʋ?” ");
INSERT INTO naw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu nyi nfɛɛrɛ mʋ nɩɩ bɛɛ fɛ, nɩɩ ɔ taasɛ bamʋ yɛ “Mɩnɛ ɩ waa nɩɩ fɛn fɛ falɛ nfɛɛrɛ fanɛ nkɔlɔ tɔ? ");
INSERT INTO naw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ɩmʋ kɩmɔɔ ɩ bʋsɩn kɩtɔwɛ. N taa fʋ alibi kɛɛ fʋ, abɛɛ kʋsʋ natɛ? ");
INSERT INTO naw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","N biti fan bɩɩ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa n sʋ ɔlʋn dulinyaa nɩmʋ tɔ nɩɩ n taalɛ taa alibi kɛɛ.” Ɩmʋ sʋ ɔ tɔwɛ ɔnyɩn mʋ nɩɩ mʋ n‐yɩɩ i wu mʋ yɛ, “N tɔwɛ fʋ yɛ, Kʋsʋ! Taa fʋ kalan kpewu.” ");
INSERT INTO naw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Opula maŋa tɔ nɩɩ ɔ kʋsʋ yɩlɛ bamʋ ansi tɔ, nɩɩ ɔ taa mʋ kalan nɩɩ ɔ dɛ sʋ mʋ, nɩɩ ɛɛ yɩn Ɩbwaarɛ ee kpewu. ");
INSERT INTO naw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nɩɩ i kyinkyin ɔkʋmaa nɩmʋ, nɩɩ ba yɩn Ɩbwaarɛ, nɩɩ ɩ kɩtaa bamʋ kufuu nɩɩ ba tɔwɛ yɛ, “Ndaga an wu asɩn kyinkyinsa.” ");
INSERT INTO naw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ɩnɩmʋ kamaa mʋ, Yesu lɩɩ nɩɩ ɔ naa wu lenpoo ɔkɔɔlɛpʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Lewi mu kusun obu to. Nɩɩ Yesu tɔwɛ mʋ yɛ, “Kʋsʋ buu mɛ.” ");
INSERT INTO naw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nɩɩ ɔnyɩn mʋ kʋsʋ yɛgɛ kʋtɔ kʋmaa nɩɩ o buu Yesu. ");
INSERT INTO naw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nɩɩ Lewi dɩŋa agyitɔ kʋkyɔ mʋ kɩkpaara sʋ sa Yesu, nɩɩ lenpoo akɔɔlɛpʋ gaalaagaa yɛ asa akʋ ba bʋga tʋtɔ, nɩɩ ba maa Yesu bee gyii. ");
INSERT INTO naw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amaa nɩɩ Farasii abi mʋ yɛ nbara akaapʋpʋ mʋ nɩɩ bamʋ gbaa bamʋ gyɛ Farasii abi mʋ bɛɛ kɔlɩtɛ bɛɛ sa Yesu abɩɩlapʋ mʋ yɛ, “Mɩnɛ ɩ waa nɩɩ fanaa lenpoo akɔɔlɛpʋ yɛ alibi awaapʋ fen bʋga fen gyii fen nuu kanɩn?” ");
INSERT INTO naw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɔkyɛpʋ man tiri sa bamʋ nɩɩ ba sʋ alanfɩya, amɔɔ bamʋ nɩɩ bɛɛ lɔ mʋ nkʋn. ");
INSERT INTO naw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","N man ba yɛ n ba tɩɩ bamʋ nɩɩ ba mʋ ɩkpa i kyiigi nɩn. Amaa n ba nɩn yɛ n ba tɩɩ alibi awaapʋ kɛ ba kyɛɛgɛ bamʋ nfɛɛrɛ ba Ɩbwaarɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nɩɩ asa akʋ ba tɔwɛ Yesu yɛ, “Gyɔn okyugyeepu abɩɩlapʋ bee ŋmina kɔnɔ yɛgɛ bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ saŋa kʋmaa, kanɩn nɩɩ Farasii abi abɩɩlapʋ mʋ gbaa bɛɛ waa nɩn. Amaa fɛɛ fʋ abɩɩlapʋ mʋ bɩrɛ ba dan bee gyii bee nuu nɩn saŋa kʋmaa.” ");
INSERT INTO naw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fɩɩ taalɛ yɛgɛ kɩkyɩɩfɔ tɔ afɔ ba ŋmina kɔnɔ yɛgɛ ɔkyɩɩfɔ mu‐kuli bʋ bamʋ asɛ? ");
INSERT INTO naw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amaa saŋa kʋ ii biti ɔ ba, kɛ ba taa ɔkyɩɩfɔ mu‐kuli lɩɩ bamʋ asɛ, kanɩn nkɛ maŋa tɔ bɩrɛ bee biti ba ŋmina kɔnɔ.” ");
INSERT INTO naw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nɩɩ Yesu bɔ bamʋ kɩŋasan kɩnɩmʋ yɛ, “Ɔkʋ mɛɛ tɩn kikyibi pʋpwɛ naa baata mata kaalɛ dɩdaa ɔbɔ. Nɩɩ ɔkʋ kan waa kanɩn mʋ, ɩ yɛgɛ nɩɩ kikyibi pʋpwɛ mʋ ɩ kyatɛ kaalɛ dɩdaa mʋ i tii sʋ nɩn, nɩɩ kikyibi dɩdaa mʋ yɛ kɩpʋpwɛ mʋ ɩ mɛɛ yɛ ɩ baa i duli abaa. ");
INSERT INTO naw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kanɩn nɩɩ ɔkʋ mɛɛ taa ɔwʋlɛ dɩdaa ee sun kʋkɔrɛ pʋpwɛ. Nɩɩ ɔ kan waa kanɩn bɩrɛ, ɔwʋlɛ dɩdaa mʋ ii biti ɔ kyatɛ, nɩɩ ɩ mɛɛ yɛ ɩ yɛgɛ kʋkɔrɛ pʋpwɛ mʋ kɩ waa ɔdan. ");
INSERT INTO naw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kanɩn sʋ ɩ dagaa fɛɛ ɔwʋlɛ pʋpwɛ nɩɩ bɛɛ sʋ bee sun kʋkɔrɛ pʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ lan kʋkɔrɛ dɩdaa nɩɩ ɩ dɩn mʋ mʋ, ɔ man bɩla ee biti kʋkɔrɛ pʋpwɛ kɩlan. Ee biti ɔ tɔwɛ yɛ, ‘Kʋkɔrɛ dɩdaa mʋ kɩ bɔɔ mʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kakɛ fʋʋtɛsa akɛ kʋ nɩɩ Yesu naa ayu kʋdɔɔ kʋ tɔ, nɩɩ mʋ abɩɩlapʋ ba tɩŋɛ ayu mʋ pʋsa bamʋ abaa tɔ wɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nɩɩ Farasii abi mʋ akʋ ba taasɛ yɛ, “Mɩnɛ ɩ waa nɩɩ fan waa kakɛ fʋʋtɛsa akɛ ikisii?” ");
INSERT INTO naw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Fan man pɩɩta kalɛ Ɩbwaarɛ Asɩnkyan yɩlasa mʋ, kɛ fan wu kʋtɔ mʋ nɩɩ Dawidi waa saŋa mʋ nɩɩ akʋn a mɔɔ maa mʋ asa mʋ? ");
INSERT INTO naw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Fan man wu kanan mʋ nɩɩ o loo kabwaarɛ‐sunkpa obu to naa taa saraga bodobodo mʋ wɛ, nɩɩ ɔ taa ɩkʋ sa mʋ asa gbaa nɩɩ ba wɛ, yɛgɛ ɩ man gyɛ anɛ nbara sʋ fɛɛ ɔkʋ o gyii ɩmʋ, amɔɔ Ɩbwaarɛ aseepu nkʋn?” ");
INSERT INTO naw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nɩɩ Yesu bɩla tɔwɛ yɛ, “Mɛ, Daadimaadi Obii‐nyɩnsa gbaa n gyɛ Ɔnyɩrɩpɛ sa kakɛ fʋʋtɛsa mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kakɛ fʋʋtɛsa akɛ kʋ biyo Yesu bɩla kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa ɛɛ kaapʋ. Nɩɩ ɔnyɩn kʋ bʋ tʋtɔ nɩɩ mʋ gyisa kɩbaa ki wu. ");
INSERT INTO naw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Farasii abi mʋ yɛ nbara akaapʋpʋ mʋ bee biti kanan mʋ nɩɩ ba waa kɛ ba bun Yesu kʋpwɛ. Ɩmʋ sʋ ba tɛ ba gyoo bɛɛ kɩɩ fɛɛ Yesu ii biti ɔ kyɛ mʋ kakɛ fʋʋtɛsa akɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amaa Yesu wʋla o n‐yɩɩ bamʋ nfɛɛrɛ mʋ nɩɩ bɛɛ fɛ, nɩɩ ɔ tɔwɛ ɔnyɩn mʋ nɩɩ mʋ kɩbaa ki wu mʋ yɛ, “Kʋsʋ yɩlɛ asa mʋ kpini ansi tɔ.” Nɩɩ ɔ kʋsʋ yɩlɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N taasɛ fanɛ, mɩnɛ kʋtɔ nɩɩ anɛ nbara mʋ ɩ kaapʋ fɛɛ a waa kakɛ fʋʋtɛsa akɛ? A waa adanbɩrasa abɛɛ alibi? A mɔlɩgɛ asa nkpa abɛɛ a nyita ɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nɩɩ ɔ kɩɩ bamʋ kpini kyaabɔɔ, nɩɩ ɔ tɔwɛ ɔnyɩn mʋ yɛ, “Tɛɛŋɛ fʋ kɩbaa.” Nɩɩ ɔnyɩn mʋ tɛɛŋɛ mʋ kɩbaa, nɩɩ mʋ kɩbaa mʋ kɩ nyɛ ɔlʋn. ");
INSERT INTO naw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Amaa agbʋ a kɩtaa bamʋ, nɩɩ ba piili bɛɛ bee ŋmina kanan mʋ nɩɩ bee biti ba waa Yesu. ");
INSERT INTO naw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nkɛ maŋa tɔ mʋ, Yesu kpee abɩɩ tɔ ɔ naa kʋlɛ kabwaarɛ‐kʋlɛ, nɩɩ kagyanbwɛ maŋa kpini mʋ, ɔ bʋ tʋtɔ ɛɛ kʋlɛ Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nɩɩ kayɩɩ kɩ maa kɛ mʋ, nɩɩ ɔ tɩɩ mʋ abɩɩlapʋ kpini ba mʋ asɛ, nɩɩ ɔ lɛɛ bamʋ tɔ kudu anyɔ, nɩɩ ɔ yɩla bamʋ kɩtɩɩ yɛ asunpu. ");
INSERT INTO naw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bamʋ ɩ gyɛ Simon (mʋ nɩɩ ɔ yɩla mʋ kɩtɩɩ yɛ Pita), yɛ mu‐supu Andiruwu, yɛ Gyemisi maa Gyɔn, yɛ Filipu maa Batolome, ");
INSERT INTO naw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","yɛ Matiwu maa Tomasi, yɛ Alifeyo mu‐bii Gyemisi, yɛ Simon mʋ nɩɩ bɛɛ tɩɩ yɛ Seloti, ");
INSERT INTO naw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","yɛ Gyemisi mu‐bii Gyudasi, yɛ Gyudasi Isikariyoti mʋ nɩɩ ɔ ba lɛɛ Yesu sa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu maa mu asunpu ba kpɩlɩgɛ kɩbɩɩ mʋ sʋ ba kipentenpiren kʋ sʋ. Nɩɩ abɩɩlapʋ gaalaagaa ba be tu mʋ tʋtɔ, nɩɩ asa damantɛ ba lɩɩ Gyudeya yɛ Gyerusalem yɛ ndɛ mʋ nɩɩ bɛɛ tɩɩ yɛ Tayi maa Sidon ɔpʋ nbunɔ mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ba ba nu mʋ asɛ kɛ ba nyɛ bamʋ alɔ kɩ kyɛ. Bamʋ nɩɩ n‐yaayu libi bɛɛ tɔɔrɔɔ bamʋ ba nyɛ bamʋ n‐yɩɩ. ");
INSERT INTO naw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nɩɩ asa mʋ kpini ba kpan bamʋ n‐yɩɩ fɛɛ ba mata mʋ, lɩɩ fɛɛ ɔlʋn kʋ bʋ mʋ tɔ nɩɩ ɩ lɩɩ ɩ kyɛ bamʋ kpini alɔ. ");
INSERT INTO naw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tʋtɔ nɩɩ Yesu kɩɩ mʋ abɩɩlapʋ mʋ nɩɩ ɔ tɔwɛ yɛ, “Amu ɔkɔn wuya ana ɩ gyɛ fanɛ mʋ nɩɩ fan gyɛ atiripu, lɩɩ fɛɛ Ɩbwaarɛ kuwura‐gyii mʋ kɩ gyɛ fanɛ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Amu ɔkɔn wuya ana ɩ gyɛ fanɛ mʋ nɩɩ akʋn a mɔɔ fanɛ nbɩɩnbɩɩ nɩmʋ mʋ, lɩɩ fɛɛ Ɩbwaarɛ ii biti ɔ yɛgɛ fan ŋmɛ. Amu ɔkɔn wuya ana ɩ gyɛ fanɛ mʋ nɩɩ fen su nbɩɩnbɩɩ, lɩɩ fɛɛ Ɩbwaarɛ ii biti ɔ yɛgɛ fan ŋmasɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Amu ɔkɔn wuya ana ɩ gyɛ fanɛ mʋ nɩɩ asa bee kisi fanɛ, bee kina fanɛ, bɛɛ saalɛ fanɛ, nɩɩ bɛɛ tɩn antɩŋɛsa libi bɛɛ gyaga fanɛ sʋ, lɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Nɩɩ ba kan waa fanɛ kanɩn mʋ fan yɛgɛ ɩ waa fanɛ ɔkɔn, kɛ fan taa kensi‐gyii kyaa, lɩɩ fɛɛ kɛkɛɛ lala kɩ dɛ sʋsʋ kii gyoo fanɛ. Kpalɩ fɛɛ kanɩn nɩɩ bamʋ naana ana gbaa ba taa waa Ɩbwaarɛ atɔwɛpʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amaa fanɛ atɔ wuya ana, fanɛ laakʋ, fɛɛ fan maa wʋla nyɛ fanɛ ɔkɔn dulinyaa nɩmʋ tɔ nbɩɩnbɩɩ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Fanɛ mʋ nɩɩ fan gyii ŋmɛ nbɩɩnbɩɩ nɩmʋ falɛ mɔɔ, fanɛ laakʋ, lɩɩ fɛɛ akʋn ii biti ɩɩ tɩyɛ fanɛ sʋ. Fanɛ mʋ nɩɩ fɛn ŋmasɛ nbɩɩnbɩɩ falɛ mɔɔ mʋ, fanɛ laakʋ, lɩɩ fɛɛ fen biti fan su kɛ fan bɔɔta tɔ. ");
INSERT INTO naw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nɩɩ fanɛ mʋ nɩɩ asa bɛɛ tɔwɛ fanɛ n‐yɩɩ sʋ asɩn danbɩrasa mʋ, fanɛ laakʋ. Kanɩn nɩɩ bamʋ naana ana ba tɔwɛ asɩn danbɩrasa lɩɩ atɔwɛpʋ mʋ nɩɩ bɛɛ tɩn atɩŋɛsa bɛɛ gyaga Ɩbwaarɛ sʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nɩɩ Yesu yɛ, “Amaa n tɔwɛ fanɛ mʋ nɩɩ fen nu mɛ asɛ yɛ, fan biti fanɛ dʋn ana, kɛ fan waa adanbɩrasa sa fanɛ akisipu ana. ");
INSERT INTO naw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kɛ fan waa bamʋ nɩɩ bɛɛ tɔwɛ fanɛ nnɔ mʋ kusee, kɛ fan kʋlɛ kabwaarɛ‐kʋlɛ sa bamʋ nɩɩ bɛɛ nyanla fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nɩɩ ɔkʋ kan da fʋ ɔtan mʋ, biliŋi kɩnyɔsapʋ mʋ sa mʋ. Nɩɩ ɔkʋ kan kɔɔlɛ fʋ balɩmaasʋ mʋ, yɛgɛ ɔ taa fʋ kaalɛ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nɩɩ ɔkʋ kan ba kʋlɛ fʋ kʋtɔ kʋ mʋ, sa mʋ. Nɩɩ ɔkʋ kan taa fʋ kʋtɔ kʋ mʋ, man bɩla naa taasɛ kʋtɔ maŋa sʋ lɩɩ odunwura mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kɛ fan waa fanɛ tɔɔmaa ana fɛɛ kanan mʋ nɩɩ fen biti fɛɛ ba waa sa fanɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Fɛɛ nɩɩ fan kan fen biti bamʋ nɩɩ bee biti fanɛ nkʋn mʋ, mɩnɛ sʋ nɩɩ ɩ dagaa fɛɛ Ɩbwaarɛ ɔ bɩla yɩn fanɛ? Halɩɩ alibi awaapʋ gbaa bee biti bamʋ nɩɩ bee biti bamʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nɩɩ fan kan waa kɩdanbɩrasa sa bamʋ nɩɩ bɛɛ waa fanɛ adanbɩrasa nkʋn mʋ, mɩnɛ sʋ nɩɩ ɩ dagaa fɛɛ Ɩbwaarɛ ɔ bɩla yɩn fanɛ? Alibi awaapʋ gbaa bɛɛ waa kanɩn. ");
INSERT INTO naw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nɩɩ fan kan fɛn paala bamʋ nɩɩ fan kɔɔlɛ gyii fɛɛ bee biti ba ba nyɛ ka fanɛ mʋ, mɩnɛ sʋ nɩɩ ɩ dagaa fɛɛ Ɩbwaarɛ ɔ bɩla yɩn fanɛ? Halɩɩ alibi awaapʋ gbaa bɛɛ paala bamʋ tɔmaa ana kɛ bee bwii ka bamʋ afulee maŋa kɔnɔ kyɛɛkyɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amaa fan biti fanɛ dʋn ana kɛ fan waa bamʋ adanbɩrasa. Nɩɩ fan kan paala bamʋ mʋ, fan man fɛ ɩmʋ kɩba ka nfɛɛrɛ. Nɩɩ fɛn waa kanɩn mʋ, fen biti fan nyɛ kɛkɛɛ lala, kɛ fen biti fan baa fan gyɛ Ɩbwaarɛ Owura lala mʋ nbii ana. Lɩɩ fɛɛ ɔ sʋ kebiti sa asa, nɩɩ ɛɛ waa kɩdanbɩrasa ɛɛ sa bamʋ nɩɩ ba mɛɛ fwaala, nɩɩ ba gyɛ amu tɔ ɔlʋn wuya ana. ");
INSERT INTO naw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ɩmʋ sʋ fan wu asa kʋwɛɛ fɛɛ kanan mʋ nɩɩ fanɛ‐Sɛ Ɩbwaarɛ gbaa ii wu asa kʋwɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Fan man talɛ fanɛ tɔɔmaa ana, kɛ Ɩbwaarɛ gbaa ɔ man talɛ fanɛ. Fan man bun asa kʋpwɛ, kɛ Ɩbwaarɛ gbaa ɔ man bun fanɛ kʋpwɛ. Fan taa kɛɛ abaa, kɛ Ɩbwaarɛ gbaa ɔ taa kɛɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fan sa, kɛ Ɩbwaarɛ gbaa ɔ sa fanɛ. Ee biti ɔ kaala, bɔla kʋtɔ kaalasa mʋ, kɛ ɔ nyɛɛ sʋ, kɛ o gyingyen kɩmʋ, kɛ ɩ bɔla wʋrɩgɛ fanɛ abaa tɔ. Kʋtɔ kaalasa mʋ nɩɩ fan taa kaala mʋ, kɩmʋ maa nɩɩ Ɩbwaarɛ ii biti ɔ taa kaala sa fanɛ.” ");
INSERT INTO naw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nɩɩ Yesu bɔ bamʋ kɩŋasan nɩmʋ yɛ, “Gyaatanapʋ ɩ taalɛ gyankpaa mʋ tɔɔmaa gyaatanapʋ ɔkpa? Nɩɩ ɩ kan ba kanɩn mʋ, bamʋ asa anyɔ kpini bee biti ba naa lɩɩ tɩyɛ kɩkyabɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nɩɩ ɔbɩɩlapʋ mɛɛ taalɛ ŋara mʋ ɔkaapʋpʋ, amaa nɩɩ ɔkʋmaa mʋ nɩɩ ɔ bɩla bɩɩ bɩrɛ ɛɛ taalɛ waa fɛɛ mʋ ɔkaapʋpʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mɩnɛ ɩ waa nɩɩ fu wu keyuubi kɩ maa bʋ fʋ tɔɔmaa kensi tɔ, nɩɩ fu mee wu kagyapoti mʋ nɩɩ kɩ bʋ fʋ lɛɛ tɔ? ");
INSERT INTO naw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mɩnɛ sʋ nɩɩ fɩɩ taalɛ tɔwɛ fʋ tɔɔmaa yɛ, ‘Mɛ tɔɔmaa, yɛgɛ n lɛɛ keyuubi mʋ nɩɩ kɩ bʋ fu kensi tɔ falɛ! Yɛgɛ fʋ mɛɛ kɩɩ kagyapoti mʋ nɩɩ kɩ bʋ fʋ gbaa‐gbaa fu kensi tɔ?’ Fʋ kebunbun ansi wuya, gyankpaa lɛɛ kagyapoti mʋ nɩɩ kɩ bʋ fʋ kensi tɔ, pɔyɩ kɛ fʋ taalɛ kɩɩ danbɩrasa lɛɛ keyuubi mʋ nɩɩ kɩ bʋ fʋ tɔɔmaa lɛɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nɩɩ oyu danbɩrasa kʋ man bʋ tɔ kɩ sɔyɩ abi libi, abɛɛ oyu libi mɛɛ sɔyɩ abi danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Oyu kʋmaa nɩmʋ kɩmʋ abi sʋ nɩɩ bɛɛ sʋ bɛɛ bɩɩ kɩmʋ. Nɩɩ ɔkʋ mɛɛ tɩyɛ akutu ɛɛ lɩɩ kɩkpalɛ oyu sʋ, abɛɛ kididobi lɩɩ kimango oyu sʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nyɩmɩsa danbɩrasa ɩɩ waa atɔ danbɩrasa mʋ nɩɩ ɔ kʋʋla yɩla mʋ kɔkɔlɔ tɔ, nɩɩ nyɩmɩsa libi mɔɔ ɩɩ waa atɔ libi mʋ nɩɩ ɔ kʋʋla yɩla mʋ kɔkɔlɔ tɔ. Lɩɩ fɛɛ nyɩmɩsa kɔnɔ ɩɩ tɔwɛ kʋtɔ mʋ nɩɩ kɩ bʋ mʋ kɔkɔlɔ tɔ nɩn. ");
INSERT INTO naw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mɩnɛ ɩ waa sʋ nɩɩ fan tɩɩ mɛ yɛ, ‘Ɔnyɩrɩpɛ, Ɔnyɩrɩpɛ,’ yɛgɛ fan mɛɛ waa kʋtɔ mʋ nɩɩ n tɔwɛ fanɛ yɛ fan waa? ");
INSERT INTO naw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ɔkʋmaa mʋ nɩɩ ɔ ba mɛ asɛ, ba nu mɛ asɩn, nɩɩ ɔ waa ɩmʋ mʋ, n biti n kaapʋ fanɛ ɔsa mʋ nɩɩ o duli. ");
INSERT INTO naw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kanɩn ɔsa maŋa du nɩn fɛɛ ɔsa mʋ nɩɩ ee biti ɔ pɔyɩ kɩkpaara, nɩɩ o kuu loo kasɛ nɩɩ ɔ pɔyɩ ɔpɔrɛ gyankpaasa mʋ gyaga kɩfʋlɛ sʋ. Nɩɩ nkyu n bɔla nɩɩ ɩ da kɩkpaara mʋ, amaa kɩ man gyingyen lɩɩ fɛɛ maa pɔyɩ kɩmʋ danbɩrasa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amaa ɔkʋmaa mʋ nɩɩ o nu mɛ asɩn, nɩɩ ɔ man buu ɩmʋ mʋ, o du nɩn fɛɛ ɔsa mʋ nɩɩ ɔ man kuu ɔbɔ pɔyɩ nɩɩ ɔ pɔ́yɩ́ kɩkpaara mʋ gyaga kusuupu sʋ. Nɩɩ nkyu maa bɔla da kɩkpaara mʋ, nɩɩ kɩ lɩɩ tɩyɛ yaasɛ tɔ kpini‐kpini.” ");
INSERT INTO naw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Saŋa mʋ nɩɩ Yesu tɔwɛ ɩnɩmʋ lʋwɛ, nɩɩ asa ba nu mʋ katɔwɛ mʋ, o kpee Kapanum kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roma anaakɔpʋ kɩlɩfa ɔkɩɩsʋpʋ kʋ kyɩna ɔ bʋ tʋtɔ, nɩɩ ɔ sʋ kɩyaafɔlɛ kʋ mʋ nɩɩ ee biti mʋ asɩn, nɩɩ ɛɛ lɔ nɩɩ ee biti o wu. ");
INSERT INTO naw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ɔkɩɩsʋpʋ mʋ maa nu Yesu sʋ mʋ, nɩɩ o sun Gyiwu abi abɩlɩsa akʋ mʋ asɛ, yɛ ɔ ba kyɛ mʋ kɩyaafɔlɛ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba maa ba Yesu asɛ mʋ, ba dan baasɛ kʋlɛ mʋ gaa tɔwɛ yɛ, “Ɔnyɩn nɩmʋ dagaa fɛɛ fʋ maa kyɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Lɩɩ fɛɛ ɔ sʋ kebiti sa anɛ Gyiwu abi, halɩɩ ɔ pɔyɩ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa sa anɛ.” ");
INSERT INTO naw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ɩmʋ sʋ Yesu buu bamʋ ee kpee tʋtɔ. Saŋa mʋ nɩɩ o tiri kɩkpaara mʋ tɔ mʋ, nɩɩ Roma anaakɔpʋ ɔbɩlɩsa mʋ sun mʋ kyɛmɩnɛ ana ba naa tɔwɛ Yesu yɛ, “Ɔnyɩrɩpɛ man nyanla fʋ n‐yɩɩ. Lɩɩ fɛɛ n man dagaa fɛɛ fʋ ba mɛ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kanɩn gbaa nɩɩ n wu fɛɛ n man dagaa fɛɛ n ba fʋ asɛ. Fɛɛ fʋ dan sa kɔnɔ mɛ kɩyaafɔlɛ ii biti ɔ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Lɩɩ fɛɛ ngbaa mɛ n bʋ ɔbɩlɩsa ɔkʋ kasɛ, nɩɩ anaakɔpʋ ɔkʋ gbaa ba bʋ mɛ kasɛ. Nɩɩ n tɔwɛ nɩmʋ yɛ, ‘Kpe nfɩɩ’ nɩɩ ee kpee, nɩɩ n bɩla tɔwɛ ɔnɩmʋ yɛ, ‘Ba nfɩɩ,’ nɩɩ ɛɛ ba, nɩɩ n tɔwɛ mɛ kɩyaafɔlɛ yɛ, ‘Waa falɛ,’ nɩɩ ɛɛ waa.” ");
INSERT INTO naw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu maa nu kanɩn mʋ, i kyinkyin mʋ, nɩɩ o biliŋi mu ansi kɩɩ kʋbʋ damantɛ mʋ nɩɩ ba buu mʋ mʋ, nɩɩ ɔ tɔwɛ yɛ, “N tɔwɛ fanɛ kesintin fɛɛ, Ɩsɩrayɩ abi kpini tɔ mʋ, n man pɩɩta wu ɔsa mʋ nɩɩ ɔ sʋ falɛ kɩkɔɔlɛ‐gyii damantɛ nɩmʋ kedubi.” ");
INSERT INTO naw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nbɔɔ mʋ nɩɩ o sun mʋ ba maa bwii kpewu mʋ, ba naa tu kɩyaafɔlɛ mʋ maa nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ɩmʋ kamaa mʋ Yesu lɩɩ tʋtɔ kpee kadɛ mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ Nayin, nɩɩ mʋ abɩɩlapʋ yɛ asa damantɛ ba buu mʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Saŋa mʋ nɩɩ o tiri kadɛ mʋ nbwama mʋ, o wu ba maa sʋ obuni ba lɩɩ kadɛ mʋ tɔ, nɩɩ obuni maŋa gyɛ okulapu‐kyɩɩ kebii‐nyɩnsa kʋlʋn mʋ nɩɩ ɔ kʋʋgɛ. Nɩɩ asa damantɛ mʋ nɩɩ ba bʋ kadɛ mʋ tɔ ba buu okulapu‐kyɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ɔnyɩrɩpɛ Yesu maa wu okulapu‐kyɩɩ mʋ, mʋ asɩn a kɩtaa mʋ kʋwɛɛ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Man bɩla su.” ");
INSERT INTO naw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nɩɩ Yesu taa mʋ kɩbaa naa mata kɩdakaa mʋ, nɩɩ asʋlapʋ mʋ ba sii ba yɩlɛ, nɩɩ ɔ tɔwɛ yɛ, “Kɩyaafɔlɛ! N tɔwɛ fʋ yɛ, kʋsʋ!” ");
INSERT INTO naw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nɩɩ olewupu mʋ kʋsʋ kyɩna, nɩɩ o piili ɛɛ tɔwɛ, nɩɩ Yesu taa mʋ sa mu‐nyi. ");
INSERT INTO naw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nɩɩ i kyinkyin bamʋ kpini nɩɩ ba yɩn Ɩbwaarɛ. Nɩɩ ba tɔwɛ yɛ, “Ɩbwaarɛ ɔtɔwɛpʋ lala kʋ lɩɩ anɛ sʋ. Ɩbwaarɛ ba ɔ ba kyɛ mʋ asa tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu asɩn nɩmʋ ɩ yalagɛ Gyudeya ɔsʋwʋlɛ sʋ, yɛ ɩsʋwʋlɛ mʋ nɩɩ ɩ dɛ ɩ maa kɩmʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nɩɩ Gyɔn abɩɩlapʋ ba naa tɔwɛ mʋ Yesu awaasa mʋ kpini. Ɩmʋ sʋ ɔ tɩɩ mʋ abɩɩlapʋ anyɔ, ");
INSERT INTO naw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nɩɩ o sun bamʋ Ɔnyɩrɩpɛ Yesu asɛ yɛ ba naa taasɛ mʋ yɛ, “Fʋ ɩ gyɛ Ɔmʋ nɩɩ, Ɩbwaarɛ yɛ ee biti ɔ ba mʋ abɛɛ a gyoo kɩɩ ɔkʋ ɔkpa?” ");
INSERT INTO naw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Saŋa mʋ nɩɩ anyɩn mʋ ba ba Yesu asɛ mʋ ba tɔwɛ mʋ yɛ, Gyɔn okyugyeepu i sun anɛ fʋ asɛ yɛ abaa taasɛ fʋ yɛ, “Fʋ ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ yɛ ee biti ɔ ba mʋ abɛɛ a gyoo kɩɩ ɔkʋ ɔkpa?” ");
INSERT INTO naw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kanɩn saŋa maa tɔ mʋ Yesu kyɛ asa gaalaagaa alobi, nɩɩ ɔ gya nbwɩɩ libi lɩɩ asa tɔ, nɩɩ o bugi agyaatanapʋ gaalaagaa ansi. ");
INSERT INTO naw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɩmʋ sʋ ɔ lɛɛ Gyɔn nbɔɔ mʋ kɔnɔ yɛ, “Fan bwii naa tɔwɛ Gyɔn kʋtɔ mʋ nɩɩ fan wu yɛ ɩmʋ nɩɩ fan nu. Agyaatanapʋ ansi ii bugi, nɩɩ aboobi bɛɛ kʋsʋ natɛ, nɩɩ abootipu bɛɛ nyɛ alanfɩya, nɩɩ akpawu asu ii tigi, nɩɩ alewupu bee kyiŋi bɛɛ ba nkpa tɔ, nɩɩ atiripu bee nu asɩn danbɩrasa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Fan bɩla tɔwɛ mʋ yɛ, kusee ɩ gyɛ sa ɔsa kʋmaa mʋ nɩɩ ɔ san ɔ sʋ kɩkɔɔlɛ‐gyii mɛ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Saŋa mʋ nɩɩ Gyɔn nbɔɔ ba lɩɩ mʋ asɛ mʋ, nɩɩ Yesu piili ɛɛ tɔwɛ Gyɔn asɩn ɛɛ sa kʋbʋ mʋ, nɩɩ ɔ taasɛ bamʋ yɛ, “Fan maa lɩɩ kpee Gyɔn asɛ ofuli mʋ sʋ mʋ, mɩnɛ nɩɩ fan waa nfɛɛrɛ fɛɛ fen kpee fɛn naa kɩɩ? Kʋkyɔ mʋ nɩɩ afuu a da ii fiilaa mʋ? ");
INSERT INTO naw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nɩɩ ɩ man gyɛ kanɩn bɩrɛ mʋ, mɩnɛ nɩɩ fan kpee naa wu? Abɛɛ ɔnyɩn mʋ nɩɩ o bun ɔgyalɩn atɔ? Ayee! Asa mʋ nɩɩ ba bun ɔgyalɩn atɔ nɩɩ ba sʋ kakyɩna danbɩrasa mʋ, ba bʋ awurakpa nɩn. ");
INSERT INTO naw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Amaa mɩnɛ nɩɩ fan kpee naa kɩɩ? Ɩbwaarɛ ɔtɔwɛpʋ abɛɛ? Ɛɛhn, n tɔwɛ fanɛ kesintin fɛɛ ɔ kyɔ Ɩbwaarɛ ɔtɔwɛpʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gyɔn nɩmʋ asɩn nɩɩ Ɩbwaarɛ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ, ‘N biti n sun mɛ kabɔɔ kɛ ɔ gyankpaa fʋ, mʋ ii biti ɔ lɔŋɔ fʋ ɔkpa gyoo fʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","N tɔwɛ fanɛ fɛɛ, ɔkʋmaa mʋ nɩɩ ba kʋʋgɛ mʋ mʋ, man kyɔ Gyɔn, amaa ɔkʋmaa mʋ nɩɩ o du pii sʋsʋ kuwura‐gyii tɔ mʋ kyɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Asa mʋ kpini yɛ lenpoo akɔɔlɛpʋ mʋ nɩɩ ba nu Gyɔn asɩn tɔwɛsa mʋ, ba kɔɔlɛ gyii fɛɛ Ɩbwaarɛ asɩn mʋ i kyiigi, lɩɩ fɛɛ ba yɛgɛ nɩɩ Gyɔn gyee bamʋ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amaa Farasii abi yɛ nbara akaapʋpʋ anyipu ba kina nfɛɛrɛ mʋ nɩɩ Ɩbwaarɛ sʋ sa bamʋ mʋ. Ɩmʋ sʋ nɩɩ ba man yɛgɛ nɩɩ Gyɔn gyee bamʋ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nɩɩ Yesu taasɛ yɛ, “Anɩmʋ nɩɩ n biti n taa ndaga kakyɩna kanɩmʋ tɔ asa kaala. Anɩmʋ ana nɩɩ ba duli? ");
INSERT INTO naw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba du nɩn fɛɛ nbii mʋ nɩɩ ba tɛ kɩgya tɔ bɛɛ tɩɩ abaa bɛɛ tɔwɛ yɛ, ‘An fʋlɛ kensi‐gyii nbɩlɛ sa fanɛ, amaa fan man kyaa, nɩɩ an sawʋ keli alengyi sa fanɛ, amaa fan man su’. ");
INSERT INTO naw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Lɩɩ fɛɛ Gyɔn okyugyeepu maa ba mʋ, ee ŋmina kɔnɔ gaa, nɩɩ ɔ man nuu nta, nɩɩ fan yɛ ‘Ɔ sʋ nbwɩɩ libi.’ ");
INSERT INTO naw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nɩɩ Mɛ, Daadimaadi Obii‐nyɩnsa n maa ba mʋ, n gyii nɩɩ n nuu, nɩɩ fan yɛ, ‘N gyɛ ogyipu lala yɛ ɔtabʋʋpʋ, nɩɩ n bɩla n gyɛ lenpoo akɔɔlɛpʋ yɛ alibi awaapʋ bamʋ kyɛmɩnɛ.’ ");
INSERT INTO naw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amaa bamʋ nɩɩ bee buu Ɩbwaarɛ kanyaasɩn, lɩɩ bamʋ‐daa sʋ mʋ, ɩɩ kaapʋ fɛɛ kanyaasɩn mʋ bʋrɔn.” ");
INSERT INTO naw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Saŋa kʋ tɔ nɩɩ Kafarasii‐nyɩn kʋ tɩɩ Yesu yɛ ɔ ba kɛ ba naa bʋga gyii. Nɩɩ Yesu kpee mʋ kɩkpaara sʋ nɩɩ ɔ naa kyɩna o gyii. ");
INSERT INTO naw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kanɩn kadɛ maŋa tɔ mʋ ɔkyɩɩ gyaga kʋ bʋ tʋtɔ. Ɔkyɩɩ mʋ maa nu fɛɛ Yesu bʋ Kafarasii‐nyɩn mʋ kɩkpaara sʋ ee gyii mʋ, nɩɩ ɔ bɩya tulale liifensa pʋrʋntʋwa bɔla. ");
INSERT INTO naw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nɩɩ ɔkyɩɩ mʋ ba yɩlɛ Yesu kamaa tiri mʋ ayaa asɛ ee su ansikyu ɛɛ pɔɔla mʋ ayaa. Nɩɩ ɔ taa mu inyini ɛɛ kpayɩ Yesu ayaa sʋ, nɩɩ o munkura ɩmʋ bɛɛrɛɛ sʋ, nɩɩ ɔ kyɛɛgɛ tulale mʋ wʋrɩgɛ mʋ ayaa sʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nɩɩ Kafarasii‐nyɩn mʋ nɩɩ ɔ tɩɩ Yesu mʋ maa wu ɩnɩmʋ mʋ, ɔ tɔwɛ mʋ nfɛɛrɛ tɔ yɛ, “Fɛɛ ɔnyɩn nɩmʋ dɩn dan ɔ gyɛ ɔtɔwɛpʋ kesintin nɩn, ɔ dɩn bɩɩ ɔkyɩɩ kʋlʋn mʋ nɩɩ ɛɛ mata mʋ falɛ, ɔ dɩn bɩɩ kɩbaabʋtɔ gyaga mʋ nɩɩ ɔ bʋ kɩmʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nɩɩ Yesu tɔwɛ Simon yɛ, “N sʋ kʋtɔ kʋ kɛ n tɔwɛ fʋ.” Nɩɩ Simon yɛ, “N nu, Ɔkaapʋpʋ, tɔwɛ mɛ.” ");
INSERT INTO naw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nɩɩ Yesu bɔɔ mʋ kɩŋasan yɛ, “Anyɩn anyɔ akʋ ɩ naa paala afulee lɩɩ afulee wuya kʋ asɛ. Ɔkʋ paala gbiti nderebi anu, ɔnyɔsapʋ mɔɔ adunuu. ");
INSERT INTO naw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bamʋ ɔkʋ man taalɛ nyɛ ɔ naa ka mʋ kʋkɔ. Nɩɩ afulee wuya mʋ taa kɛɛ bamʋ asa anyɔ. Asa anyɔ maŋa tɔ mʋ, anɩmʋ ii biti o biti afulee wuya mʋ asɩn gaa?” ");
INSERT INTO naw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon lɛɛ kɔnɔ yɛ, “N waa nfɛɛrɛ fɛɛ ɔmʋ nɩɩ mu afulee akyɔ mʋ.” Nɩɩ Yesu yɛ, “Fʋ lɛɛ kɔnɔ kesintin.” ");
INSERT INTO naw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nɩɩ Yesu biliŋi kɩɩ ɔkyɩɩ mʋ, nɩɩ ɔ tɔwɛ Simon yɛ, “Yɛ fu wu ɔkyɩɩ nɩmʋ? N maa ba fʋ kɩkpaara sʋ mʋ, fʋ man sa mɛ nkyu kɛ n fwɩɩ mɛ ayaa sʋ, amaa ɔkyɩɩ nɩmʋ taa mʋ ansikyu fwɩɩ mɛ ayaa, nɩɩ ɔ taa mu inyini kpayɩ ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fʋ man baari mɛ waa mɛ nsa‐nsa, amaa lɩɩ koo saŋa mʋ nɩɩ n ba nfɩɩ mʋ, ɔkyɩɩ nɩmʋ man pɩɩ yɛgɛ mɛ ayaa sʋ kimunkura. ");
INSERT INTO naw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fʋ man taa olifu nfɔ wʋrɩgɛ mi kumu tɔ, amaa ɔkyɩɩ nɩmʋ taa tulale wʋrɩgɛ mɛ ayaa sʋ. ");
INSERT INTO naw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ɩmʋ sʋ n tɔwɛ fʋ yɛ, kebiti lala mʋ nɩɩ ɔ kaapʋ falɛ sʋ mʋ, ɩɩ kaapʋ fɛɛ ba taa mu alibi damantɛ mʋ kɛɛ mʋ. Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ mu alibi a man kyɔ nɩɩ ɔ nyɛ kɩtaakɛɛ mʋ, ɛɛ kaapʋ kebiti mʋ gbaa gbɛrɛɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tʋtɔ nɩɩ Yesu tɔwɛ ɔkyɩɩ mʋ yɛ, “N taa fu alibi kɛɛ fʋ.” ");
INSERT INTO naw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nɩɩ bamʋ nɩɩ ba san ba tɛ ogyikpa mʋ bɛɛ tɔwɛ abaa yɛ, “Anɩmʋ ɩ gyɛ ɔnɩmʋ, halɩɩ ɔ sʋ alibi ɛɛ kɛɛ?” ");
INSERT INTO naw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Amaa Yesu tɔwɛ ɔkyɩɩ mʋ yɛ, “Fʋ kɩkɔɔlɛ‐gyii kɩ mɔlɩgɛ fʋ. Natɛ yɛ kɔkɔlɔ yuuli.” ");
INSERT INTO naw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ɩnɩmʋ kamaa mʋ, Yesu natɛ ndɛ lala yɛ ndɛ‐bii sʋ ɛɛ tɔwɛ asɩn danbɩrasa lɩɩ kuwura‐gyii mʋ sʋ, yɛgɛ abɩɩlapʋ kudu anyɔ mʋ ba tii mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nɩɩ akyɩɩ ɔkʋ mʋ nɩɩ ɔ gya n‐yaayu libi lɩɩ bamʋ tɔ nɩɩ ɔ kyɛ bamʋ alɔ mʋ, gbaa ba buu mʋ. Bamʋ ɔkʋ ɩ gyɛ Mɛɛrɩ (mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Magidalen) mʋ nɩɩ Yesu gya nbwɩɩ libi asunɔ lɩɩ mʋ tɔ mʋ, ");
INSERT INTO naw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","yɛ Gyowana mʋ nɩɩ mu‐kuli ɩ gyɛ Kyusa. Mʋ ɩ gyɛ owura Herodi kɩkpaara sʋ ɔkɩɩsʋpʋ ɔbɩlɩsa mʋ, yɛ Susana yɛ akʋ. Akyɩɩ anɩmʋ ɩ sʋ bamʋ gbaa‐gbaa atɔ bɛɛ kyɛ Yesu maa mʋ abɩɩlapʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Saŋa mʋ nɩɩ asa bɛɛ lɩɩ ndɛ sʋ ndɛ sʋ ba ba gyaŋɛ Yesu asɛ, nɩɩ ba ba nyɛ akyɔ mʋ, Yesu bɔ bamʋ kɩŋasan yɛ, ");
INSERT INTO naw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ɔdɔɔpʋ kʋ ɩ kyɩna kpee ɔ naa ŋmatɛ ayu. Saŋa mʋ nɩɩ ɛɛ ŋmatɛ ayu mʋ ɩmʋ ɩkʋ ɩ tɩyɛ ɔkpa tɔ nɩɩ asa ba natɛ ɩmʋ sʋ nɩɩ nbwiibi ba ba tasɛ gyii. ");
INSERT INTO naw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nɩɩ ɩkʋ ɩ tɩyɛ afʋlɛ sʋ katɩn mʋ nɩɩ ɩsɛ ɩ man kyɔ sa ɩmʋ. Ɩmʋ sʋ ɩ maa kɔyɩ mʋ, ɩmʋ ilin ɩ man taalɛ kpee kata. Ɩmʋ sʋ kyɔwɛ maa daa ɩmʋ mʋ nɩɩ i fugya. ");
INSERT INTO naw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nɩɩ ɩkʋ mɔɔ ɩ tɩyɛ iwii tɔ nɩɩ ɩmaa ɩmʋ ɩ bʋga dan nɩɩ iwii mʋ ɩ dan nyan ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nɩɩ abi akʋ mɔɔ ɩ tɩyɛ kasɛ danbɩrasa tɔ nɩɩ ɩ kɔyɩ dan. Nɩɩ ɩ dan sɔyɩ abi kɩlɩfa‐kɩlɩfa.” Maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ, nɩɩ o diyaa mʋ ɔbʋlɛ tɔwɛ yɛ, “Ɔmʋ nɩɩ ɔ sʋ asʋ nɩɩ ee biti o nu mʋ, o nu.” ");
INSERT INTO naw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nɩɩ mʋ abɩɩlapʋ mʋ ba taasɛ mʋ kɩŋasan mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fanɛ bɩrɛ Ɩbwaarɛ lɛɛ mu kuwura‐gyii mʋ asiri asɩn kaapʋ fanɛ, amaa asansa bɩrɛ aŋasan tɔ nɩɩ n biti n tɔwɛ sa bamʋ. Ɩmʋ sʋ, ‘bee biti ba ba bɛɛ kɩɩ, amaa ba mɛɛ yɛ ba wu, kɛ ba ba bee nu, amaa ba mɛɛ yɛ ba nu kasɛ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nɩɩ Yesu tɔwɛ yɛ, “Kɩŋasan mʋ kasɛ ɩ gyɛ yɛ, abi mʋ nɩɩ ɔ ŋmatɛ mʋ ɩ gyɛ abwaarɛsɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nɩɩ ɩmʋ nɩɩ ɩ tɩyɛ ɔkpa tɔ mʋ, ɩ gyɛ bamʋ nɩɩ bee nu asɩn mʋ, nɩɩ Sɩtaanɛ ɩ lɛɛ ɩmʋ ɛɛ lɩɩ bamʋ nkɔlɔ tɔ, nɩɩ ba mɛɛ taalɛ kɔɔlɛ gyii kɛ ba nyɛ kamɔlɩgɛ. ");
INSERT INTO naw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nɩɩ ɩmʋ nɩɩ ɩ tɩyɛ afʋlɛ sʋ mʋ, ɩ gyɛ bamʋ nɩɩ bee nu asɩn mʋ, nɩɩ bɛɛ taa kensi‐gyii kɔɔlɛ ɩmʋ. Amaa asɩn mʋ man loo bamʋ nkɔlɔ tɔ. Bamʋ kɩkɔɔlɛ‐gyii kɩ mɛɛ kyɛɛrɛɛ, ɩmʋ sʋ nɩɩ kʋtʋʋ tɔ kɩɩ kɩ kan ba tu bamʋ de, bɛɛ lɩɩ tɩyɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nɩɩ ɩmʋ nɩɩ ɩ tɩyɛ iwii tɔ mɔɔ mʋ ɩ yɩlɛ sa bamʋ nɩɩ bee nu asɩn mʋ, amaa lɩɩ kakyɩna tɔ nfɛɛrɛ kɩfɛ, kufulee biti yɛ kensi‐gyii bansa i kun bamʋ, nɩɩ ba mɛɛ taalɛ dan kɩkɔɔlɛ‐gyii tɔ. ");
INSERT INTO naw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nɩɩ ɩmʋ nɩɩ ɩ tɩyɛ kasɛ danbɩrasa tɔ mʋ mɔɔ, ɩ gyɛ bamʋ nɩɩ ba taa kɔkɔlɔ kʋlʋn kɔɔlɛ asɩn mʋ gyii, nɩɩ ba sʋ kenyiita yɩlɛ tɔ kɛ ba waa adanbɩrasa.” ");
INSERT INTO naw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nɩɩ Yesu bɩla tɔwɛ bamʋ kɩŋasan kʋ yɛ, “Ɔkʋ mee tuwa fɩtɩla kɛ ɔ taa waa kolobi tɔ abɛɛ ɔ taa yii npaa kasɛ, amaa ɛɛ taa ɛɛ gyaga kɩmʋ ɔgyagakpa nɩn, kɛ bamʋ nɩɩ bɛɛ ba mʋ ba wu fɩtɩla mʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nɩɩ kʋtɔ kʋmaa mʋ nɩɩ kɩ baala gbaa kii biti kɩ lɩɩ ifuli, nɩɩ atɔ mʋ nɩɩ ɩ gyɛ asiri atɔ kpini ii biti ɩ lɩɩ ifuli. ");
INSERT INTO naw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ɩmʋ sʋ fan baa fan da sʋ kanan mʋ nɩɩ fen nu asɩn, nɩɩ ɔkʋmaa mʋ nɩɩ ee nu asɩn kasɛ mʋ, ii biti ɩ sa mʋ tii sʋ, nɩɩ ɔmʋ nɩɩ o mee nu asɩn mʋ kasɛ mʋ, ii biti ɩ kɔɔlɛ ipii mʋ nɩɩ ɔ sʋ mʋ gbaa lɩɩ mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nɩɩ Yesu mu‐nyi yɛ mu‐supu ana ba ba yɛ ba be wu mʋ, amaa lɩɩ sakyɔ sʋ mʋ, ba man nyɛ nin tiri mʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tʋtɔ nɩɩ ɔkʋ tɔwɛ Yesu yɛ, “Fu‐nyi yɛ fu‐supu ana ba yɩlɛ kewu bee biti fɛɛ ba wu fʋ.” ");
INSERT INTO naw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nɩɩ ɔ lɛɛ mʋ kɔnɔ yɛ, “Mi‐nyi yɛ mi‐supu ana ɩ gyɛ asa mʋ nɩɩ bee nu abwaarɛsɩn nɩɩ bɛɛ sʋ bɛɛ waa kusun mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kakaakʋ nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Fan yɛgɛ a faa kpee benbe.” Nɩɩ ba loo ɔkʋlɩ tɔ faa kyʋn. ");
INSERT INTO naw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Saŋa mʋ nɩɩ bɛɛ palɛ bee kpee mʋ Yesu dɛ nsɩɩrɛ. Nɩɩ afuu lala akʋ a tigi lɩɩ bamʋ sʋ, nɩɩ apaa a da a loo ɔkʋlɩ mʋ tɔ. Nɩɩ ɩ san gbɛrɛɛ kɛ ɔkʋlɩ mʋ o muuri, nɩɩ bamʋ nkɔlɔ ɩ ŋmaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nɩɩ abɩɩlapʋ mʋ ba naa kyiŋi mʋ tɔwɛ mʋ yɛ, “Ɔnyɩrɩpɛ, Ɔnyɩrɩpɛ! An biti a sii nkyu tɔ!” Nɩɩ ɔ kʋsʋ yɩlɛ, pʋntɛ afuu mʋ yɛ apaa mʋ sʋ, nɩɩ ɩ waa diin. ");
INSERT INTO naw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nɩɩ Yesu taasɛ mʋ abɩɩlapʋ mʋ yɛ, “Fanɛ kɩkɔɔlɛ‐gyii bʋ fɩnɛ?” Nɩɩ kufuu kɩ kɩtaa bamʋ, nɩɩ i kyinkyin bamʋ nɩɩ bɛɛ taasɛ abaa yɛ, “Nyɩmɩsa mɔɔ ndee nɩɩ ɛɛ sa afuu yɛ apaa kɔnɔ nɩɩ i nu mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nɩɩ ba palɛ naa fʋʋ Gerasene abi ɔsʋwʋlɛ sʋ, kɩbaafʋn mʋ nɩɩ kɩ bʋ Galile benbe. ");
INSERT INTO naw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu maa dan ɛɛ lɩɩ ɛɛ yɩlɛ ɔbʋn kaa mʋ, nɩɩ Kagerasene‐nyɩn kʋ mʋ nɩɩ nbwɩɩ libi ba bʋ mʋ tɔ mʋ ba gyaŋa mʋ. Ɔnyɩn nɩmʋ natɛ kubolonkpan kyɛɛrɛɛ yɛgɛ ɔ mɛɛ kyɩna kɩkpaara sʋ, amɔɔ nkyan tɔ nɩɩ ɔ bʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Saŋa mʋ nɩɩ ɔnyɩn mʋ wu Yesu mʋ, ɔ pʋntɛ tɩyɛ mʋ ayaa tɔ, nɩɩ o kuusi kenken tɔwɛ yɛ, “Yesu, sʋsʋ Owura Lala mu‐bii! Mɩnɛ nɩɩ fii biti mɛ asɛ? N kʋlɛ fʋ nɩn, man nyanla mɛ!” ");
INSERT INTO naw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Lɩɩ fɛɛ Yesu wʋla sa nbwɩɩ libi mʋ kɔnɔ fɛɛ ba lɩɩ ɔnyɩn mʋ tɔ. Saŋa kʋmaa nɩmʋ nbwɩɩ libi mʋ bɛɛ ba mʋ sʋ. Nɩɩ ɩ kan ba mʋ sʋ mʋ, bɛɛ taa agbeeleebi ŋmina mʋ abaa yɛ mʋ ayaa, yɛgɛ bee kun mʋ. Amaa ɛɛ tɩŋɛ agbeeleebi mʋ nɩɩ ba taa ŋmina mʋ mʋ, nɩɩ nbwɩɩ libi mʋ bɛɛ sʋla mʋ kpee ofuli sʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nɩɩ Yesu taasɛ mʋ yɛ, “Nɛnɛ nɩɩ bɛɛ tɩɩ fʋ?” Nɩɩ ɔ yɛ bɛɛ tɩɩ mɛ yɛ, “Kʋbʋ!” Lɩɩ fɛɛ nbwɩɩ libi kʋkyɔ ba tɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nɩɩ nbwɩɩ libi mʋ ba kʋlɛ Yesu yɛ, ɔ man taa bamʋ naa waa ɔbɔ kyinkyingilin mʋ nɩɩ kɩ man sʋ ɔkaa mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nɩɩ akuuri damantɛ akʋ ba bʋ kɩbɩɩ mʋ sʋ bee gyii. Nɩɩ nbwɩɩ libi mʋ ba kʋlɛ Yesu fɛɛ ɔ yɛgɛ ba naa loo akuuri mʋ tɔ, nɩɩ Yesu sa bamʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nbwɩɩ libi mʋ ba maa lɩɩ ɔnyɩn mʋ tɔ mʋ, ba naa loo akuuri mʋ tɔ, nɩɩ ba sɩlɛ kpɩlɩgɛ kɩbɩɩ mʋ sʋ naa loo ɔbʋn lala mʋ tɔ nɩɩ ba muuri. ");
INSERT INTO naw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nɩɩ asa mʋ nɩɩ bɛɛ kɩɩ akuuri mʋ sʋ ba maa wu kʋtɔ mʋ nɩɩ kɩ waa mʋ, ba sɩlɛ kpee kadɛ tɔ yɛ ndɔɔ ana tɔ naa tɔwɛ asa. ");
INSERT INTO naw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nɩɩ asa mʋ ba ba kɩɩ kʋtɔ mʋ nɩɩ kɩ waa. Ba maa ba Yesu asɛ mʋ, ba wu ɔnyɩn mʋ nɩɩ nbwɩɩ libi ba kʋsʋ mʋ sʋ mʋ, o bun kaalɛ ɔ tɛ Yesu ayaa kasɛ yɛgɛ mʋ nfɛɛrɛ tɔ i du kyɛɛkyɛɛ, nɩɩ kufuu kɩ kɩtaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bamʋ nɩɩ ba taa bamʋ ansi wu mʋ, ba tɔwɛ asa kanan mʋ nɩɩ ɔnyɩn mʋ nɩɩ nbwɩɩ libi ba daa ba tɛ mʋ sʋ mʋ nyɛ kɩkyɛ. ");
INSERT INTO naw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kanɩn sʋ Gerasene abi mʋ nɩɩ ba bʋ kɩbaafʋn maŋa sʋ kpini, ba kʋlɛ Yesu yɛ ɔ lɩɩ bamʋ ɔsʋwʋlɛ maŋa sʋ, lɩɩ fɛɛ kufuu kɩ kɩtaa bamʋ. Nɩɩ o loo ɔkʋlɩ tɔ bwii. ");
INSERT INTO naw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pɔyɩ kɛ ba bwii mʋ, ɔnyɩn mʋ nɩɩ nbwɩɩ libi ba kʋsʋ mʋ sʋ mʋ kʋlɛ Yesu yɛ ɔ yɛgɛ o buu mʋ. Amaa Yesu kina tɔwɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bwii kpee kewu naa tɔwɛ kʋtɔ lala mʋ nɩɩ Ɩbwaarɛ waa sa fʋ.” Ɩmʋ sʋ ɔnyɩn mʋ kpee kadɛ mʋ tɔ katɩn kʋmaa nɩmʋ naa tɔwɛ kʋtɔ lala mʋ nɩɩ Yesu waa sa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Saŋa mʋ nɩɩ Yesu bwii faa kpee ɔbʋn benbe mʋ, sakyɔ mʋ ba waa mʋ nsa‐nsa kɔɔlɛ mʋ, lɩɩ fɛɛ ba wʋla ba tɛ ba gyoo mʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tʋtɔ nɩɩ ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gyarosi, mʋ nɩɩ ɔ gyɛ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa ɔbɩlɩsa mʋ ba tɩyɛ Yesu ayaa kasɛ, nɩɩ ɔ kʋlɛ mʋ yɛ ɔ ba mʋ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Lɩɩ fɛɛ mu kebii kyɩɩsa‐bi kʋlʋn mʋ nɩɩ o gyii nsu kudu anyɔ ii biti o wu. Yesu maa yii sʋ ee kpee mʋ, sakyɔ mʋ mili mʋ sʋ ba buu mʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ɔkyɩɩ kʋ bʋ sakyɔ mʋ tɔ nɩɩ nkalan ɩ da mʋ nsu kudu anyɔ, amaa ɔkʋ man taalɛ kyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nɩɩ ɔkyɩɩ mʋ loo sakyɔ mʋ tɔ ba Yesu kamaa ba mata mʋ kaalɛ kɔnɔ‐bi, nɩɩ opula maŋa tɔ mʋ nkalan mʋ ɩ tɩn. ");
INSERT INTO naw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nɩɩ Yesu taasɛ yɛ, “Anɩmʋ ɩ mata mɛ?” Bamʋ kpini ba maa kina yɛ ɩ man gyɛ bamʋ mʋ, nɩɩ Pita tɔwɛ yɛ, “Ɔnyɩrɩpɛ, sakyɔ bee mili fʋ sʋ, bɛɛ mata fʋ.” ");
INSERT INTO naw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Amaa Yesu tɔwɛ yɛ, “Ɔsa kʋ mata mɛ, lɩɩ fɛɛ n wu nɩɩ n bɩɩ fɛɛ ɔlʋn kʋ maa lɩɩ mɛ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nɩɩ ɔkyɩɩ mʋ maa wu fɛɛ ɔ mɛɛ taalɛ taa baala mʋ, ɔ kyɩkyaa ba tɩyɛ Yesu ansi tɔ. Nɩɩ ɔkyɩɩ mʋ yɩlɛ sakyɔ mʋ tɔ tɔwɛ kʋtɔ mʋ sʋ nɩɩ ɔ mata Yesu, yɛ kanan mʋ nɩɩ ɔ nyɛ kɩkyɛ opula maŋa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nɩɩ Yesu tɔwɛ ɔkyɩɩ mʋ yɛ, “Mi‐bii kyɩɩsa, fʋ kɩkɔɔlɛ‐gyii kɩ yɛgɛ nɩɩ fʋ nyɛ alanfɩya, kpewu kayɩɩ yuuli tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Saŋa mʋ nɩɩ Yesu san ɛɛ tɔwɛ kanɩn mʋ, nɩɩ kabɔɔ kɩ lɩɩ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa ɔbɩlɩsa Gyarosi kɩkpaara sʋ, ba tɔwɛ mʋ yɛ, “Man bɩla tɔɔrɔɔ ɔkaapʋpʋ mʋ, fu kebii kyɩɩsa‐bi mʋ wu.” ");
INSERT INTO naw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu maa nu kanɩn mʋ, nɩɩ ɔ tɔwɛ Gyarosi yɛ, “Man waa kufuu, fɛɛ fʋ dan nyɛ kɩkɔɔlɛ‐gyii ee biti ɔ nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu fʋʋ Gyarosi kɩkpaara sʋ mʋ, ɔ man yɛgɛ nɩɩ ɔkʋ buu mʋ loo obu to, amɔɔ Pita maa Gyɔn yɛ Gyemisi yɛ kebii mʋ, mʋ‐sɛ yɛ mu‐nyi nkʋn. ");
INSERT INTO naw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Saŋa maa kpini yɛgɛ asa bɛɛ sawʋ bɛɛ waa ɩlawʋ, bee su kebii mʋ keli. Nɩɩ Yesu tɔwɛ yɛ, “Fan yɛgɛ kusu, ɔ man wu, ɔ dɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nɩɩ asa mʋ ba ŋmasɛ Yesu, lɩɩ fɛɛ be nyi kebii mʋ maa wu. ");
INSERT INTO naw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Amaa Yesu kɩtaa kebii mʋ kɩbaa tɔ tɔwɛ yɛ, “Mi‐bii, kʋsʋ!” ");
INSERT INTO naw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nɩɩ kebii mʋ, mʋ kala bwii ba mʋ tɔ, nɩɩ ɔ kʋsʋ yɩlɛ opula maŋa tɔ. Tʋtɔ nɩɩ Yesu tɔwɛ bamʋ yɛ, ba sa kebii mʋ agyitɔ kɛ o gyii. ");
INSERT INTO naw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nɩɩ ɩ waa kebii mʋ akʋʋgɛpʋ kɩyan, amaa nɩɩ ɔ da bamʋ amu tɔ yɛ ba man waa kɛ ba tɔwɛ asɩn mʋ nɩɩ ɩ waa falɛ sa ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu maa tɩɩ abɩɩlapʋ kudu‐anyɔ mʋ ba gyaŋɛ mʋ, ɔ sa bamʋ ɔlʋn nɩɩ ɔ waa bamʋ kɩnyɩn tɔ yɛ ba gya nbwɩɩ libi lɩɩ asa tɔ kɛ ba kyɛ alɔ. ");
INSERT INTO naw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tʋtɔ nɩɩ o sun bamʋ yɛ, ba naa tɔwɛ kuwura‐gyii mʋ asɩn kɛ ba kyɛ alɔpʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan maa kpee falɛ, fan man taa sɛhn tii sʋ. Fan man taa kikpebi abɛɛ adiikun abɛɛ agyitɔ abɛɛ afulee abɛɛ kaalɛ nyɔsapʋ kʋ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nɩɩ kɩkpaara kʋmaa mʋ nɩɩ fan loo kɩmʋ sʋ, nɩɩ ba kɔɔlɛ fanɛ mʋ, fan kyɩna tʋtɔ naa fʋʋ saŋa mʋ nɩɩ fen biti fan lɩɩ kadɛ maŋa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nɩɩ kadɛ mʋ nɩɩ ba kina fanɛ kɩkɔɔlɛ, nɩɩ fan lɩɩ tʋtɔ fen kpee mʋ, fan kpɩkpaa fanɛ ayaa sʋ apurutiti, kɛ ɩ kaapʋ fɛɛ kʋtɔ mʋ nɩɩ fan waa mʋ, ɩ man bʋrɔn.” ");
INSERT INTO naw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ɩmʋ sʋ abɩɩlapʋ mʋ ba natɛ ndɛ‐bi‐ndɛ‐bi mʋ sʋ kpini bɛɛ tɔwɛ asɩn danbɩrasa mʋ, yɛgɛ bɛɛ kyɛ asa katɩn kʋmaa mʋ nɩɩ bee kpee mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kanɩn saŋa maŋa mʋ Owura Herodi maa nu atɔ mʋ nɩɩ ɩ waa kpini mʋ ɩ tɔɔrɔɔ mʋ gaa. Lɩɩ fɛɛ akʋ bɛɛ tɔwɛ yɛ Gyɔn okyugyeepu mʋ i kyiŋi ba nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nɩɩ akʋ mɔɔ ba yɛ, olewupu Eligya i bwii kyiŋi ba nkpa tɔ, nɩɩ akʋ mɔɔ ba bɩla tɔwɛ yɛ, atɔwɛpʋ dɩdaa mʋ ɔkʋ i bwii kyiŋi ba nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Amaa Herodi tɔwɛ yɛ, “N yɛgɛ nɩɩ ba tɩn Gyɔn okyugyeepu kumu. Anɩmʋ nɩɩ n bɩla n nu mʋ n‐yɩɩ sʋ asɩn falɛ?” Nɩɩ ɔ kpan mʋ n‐yɩɩ fɛɛ o wu Yesu. ");
INSERT INTO naw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nɩɩ asunpu mʋ ba maa bwii ba mʋ, ba ba tɔwɛ Yesu kʋtɔ kʋmaa mʋ nɩɩ ba naa waa. Tʋtɔ nɩɩ ɔ taa bamʋ nkʋn ba lɩɩ kpee kadɛ mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ Betisayida mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sakyɔ mʋ ba maa nu kanɩn mʋ, ba buu mʋ kpee tʋtɔ. Nɩɩ ɔ kɔɔlɛ bamʋ tɔwɛ kuwura‐gyii asɩn sa bamʋ, nɩɩ ɔ kyɛ bamʋ nɩɩ bee biti kɩkyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kyɔwɛ maa biti ɔ lʋwɛ mʋ, nɩɩ abɩɩlapʋ kudu anyɔ mʋ ba ba mʋ asɛ. Nɩɩ ba tɔwɛ mʋ yɛ, “Yɛgɛ asa mʋ ba kpee ndɛ‐bi‐ndɛ‐bi yɛ ndɔɔ ana mʋ nɩɩ ɩ bʋ tiri nfɩɩ mʋ, kɛ ba naa nyɛ ilookpa yɛ agyitɔ gyii. Lɩɩ fɛɛ katɩn mʋ nɩɩ an bʋ falɛ gyɛ kiyii nsana.” ");
INSERT INTO naw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Amaa Yesu tɔwɛ bamʋ yɛ, “Fanɛ gbaa‐gbaa fan sa bamʋ kʋtɔ kʋ kɛ ba gyii.” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Kʋtɔ mʋ nɩɩ an sʋ ɩ gyɛ bodobodo anuu yɛ ɩkɩn ɩnyɔ, abɛɛ fii biti fɛɛ a naa sɔɔ agyitɔ sa asa damantɛ banɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Nɩɩ anyɩn mʋ nɩɩ ba bʋ tʋtɔ mʋ, bɛɛ waa fɛɛ ngbɩn nnuu). Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Fan yɛgɛ asa mʋ ba kyɩna ntun adunuu‐adunuu.” ");
INSERT INTO naw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nɩɩ abɩɩlapʋ mʋ ba waa kanɩn, nɩɩ ba yɛgɛ asa mʋ kpini ba kyɩna‐kyɩna kasɛ. ");
INSERT INTO naw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nɩɩ Yesu taa bodobodo yɛ ɩkɩn ɩnyɔ mʋ diyaa mu ansi kɩɩ sʋsʋ taa afwaala sa Ɩbwaarɛ. Nɩɩ ɔ kpɛɛ‐kpɛɛ tɔ taa sa mʋ abɩɩlapʋ mʋ yɛ ba barɩgɛ tɔ sa asa mʋ kɛ ba gyii. ");
INSERT INTO naw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Asa mʋ kpini ba gyii ŋmɛ, nɩɩ abɩɩlapʋ mʋ ba tasɛ‐tasɛ agyisan mʋ bɔla alantan kudu anyɔ. ");
INSERT INTO naw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kakaakʋ Yesu maa kʋlɛ kabwaarɛ‐kʋlɛ mʋ nkʋn mʋ, nɩɩ mʋ abɩɩlapʋ mʋ ba ba mʋ asɛ nɩɩ ɔ taasɛ bamʋ yɛ, “Anɩmʋ nɩɩ asa bɛɛ tɔwɛ yɛ, n gyɛ?” ");
INSERT INTO naw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Akʋ bɛɛ tɔwɛ yɛ fʋ ɩ gyɛ Gyɔn okyugyeepu, nɩɩ akʋ mɔɔ bɛɛ tɔwɛ yɛ ɔtɔwɛpʋ Eligya ɩ gyɛ fʋ, nɩɩ asansa mɔɔ bɛɛ tɔwɛ yɛ, fʋ ɩ gyɛ atɔwɛpʋ dɩdaa mʋ nɩɩ ba wu mʋ tɔ ɔkʋ i bwii ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nɩɩ ɔ taasɛ bamʋ yɛ, “Fanɔɔ fanɛ mɔɔ, anɩmʋ nɩɩ fan yɛ n gyɛ?” Nɩɩ Pita lɛɛ kɔnɔ yɛ, “Fʋ ɩ gyɛ ɔmɔlɩgɛpʋ mʋ nɩɩ Ɩbwaarɛ Wʋla lɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tʋtɔ nɩɩ Yesu da bamʋ amu tɔ yɛ ba man kan waa tɔwɛ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nɩɩ ɔ bɩla tɔwɛ bamʋ yɛ, “Mɛ, Daadimaadi Obii‐nyɩnsa dagaa maa gyii awʋrʋfɔ gaa, kɛ abɩlɩsa yɛ aseepu bɩlɩsa yɛ nbara akaapʋpʋ kpini ba kina mɛ. Bee biti ba mɔɔ mɛ, amaa nkɛ nsa kamaa mʋ n biti n kyiŋi lɩɩ lewu tɔ ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nɩɩ ɔ bɩla tɔwɛ bamʋ yɛ, “Ɔkʋmaa mʋ nɩɩ ee biti fɛɛ o buu mɛ mʋ, ɩ dagaa fɛɛ o kina mʋ kɔkɔlɔ biti, kɛ o kukuri mu oyu laasa sʋla buu mɛ kakɛ kʋmaa. ");
INSERT INTO naw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ɩmʋ ɩ gyɛ fɛɛ ɔkʋmaa mʋ nɩɩ ee biti fɛɛ ɔ mɔlɩgɛ mʋ gbaa‐gbaa mʋ nkpa mʋ, ii biti ɩ lɩɩ mʋ abaa tɔ, amaa ɔkʋmaa mʋ nɩɩ ɔ taa mʋ nkpa sa lɩɩ mɛ sʋ mʋ, ee biti o bwii nyɛ mʋ nkpa. ");
INSERT INTO naw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Fɛɛ nɩɩ nyɩmɩsa kan nyɛ dulinyaa tɔ atɔ kpini nɩɩ ɔ pan mʋ nkpa mʋ, mɩnɛ nɩɩ ɔ nyɛ? ");
INSERT INTO naw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nɩɩ ɔkʋmaa mʋ nɩɩ ɩ sʋ mʋ ipeeli lɩɩ mɛ yɛ mɛ asɩn mʋ sʋ mʋ, kanɩn maŋa nɩɩ ii biti ɩ baa ɩ sʋ mɛ, Daadimaadi Obii‐nyɩnsa mʋ ipeeli sa kanɩn ɔsa maŋa, lɩɩ kakɛ mʋ nɩɩ maa Mɛ‐Sɛ yɛ mʋ nbɔɔ kyɩrɛkyɩrɛ mʋ an biti a ba bʋnyaa tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","N tɔwɛ fanɛ kesintin fɛɛ fanɛ mʋ nɩɩ fan yɩlɛ nfɩɩ falɛ tɔ akʋ ba mɛɛ yɛ ba wu lewu, amɔɔ ba dan wu kuwura‐gyii mʋ pɔyɩ.” ");
INSERT INTO naw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu maa tɔwɛ asɩn nɩmʋ lʋwɛ nkɛ nsunɔ kamaa mʋ, ɔ taa Pita maa Gyɔn yɛ Gyemisi nɩɩ maa bamʋ ba kpee kɩbɩɩ kʋkʋ sʋ ba naa kʋlɛ kabwaarɛ‐kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Maa san ɔ maa sʋ ɛɛ kʋlɛ kabwaarɛ‐kʋlɛ mʋ, nɩɩ mu ansi tɔ a biliŋi, nɩɩ mʋ ɩkaalɛ gbaa ɩ lɔŋɔ fuuli parɛparɛ nɩɩ ɩ ŋalɩgɛ fɛɛ bʋlayɩ maa wɛɛ ɩsɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Opula maŋa tɔ asa anyɔ akʋ ba ba mʋ asɛ. Bamʋ ɩ gyɛ Mosesi maa Eligya. ");
INSERT INTO naw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ba taa bʋnyaa sʋ ba Yesu asɛ, nɩɩ maa bamʋ bɛɛ tɔwɛ kanan mʋ nɩɩ Ɩbwaarɛ tɔwɛ yɩla fɛɛ ee biti o kpee Gyerusalem naa wu mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita maa mʋ tɔɔmaa ana mʋ ba dɛ nsɩɩrɛ, amaa ba maa kyiŋi mʋ, ba wu Yesu bʋnyaa mʋ yɛ asa anyɔ mʋ ba maa yɩlɛ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Asa anyɔ mʋ ba maa lɩɩ Yesu asɛ bee kpee mʋ, Pita tɔwɛ Yesu yɛ, “Ɔnyɩrɩpɛ, ɩ bʋrɔn gaa fɛɛ a maa bʋ nfɩɩ. Yɛgɛ a waa abu asa, fʋ lɛɛ kʋkʋ. Mosesi lɛɛ yɛ Eligya lɛɛ. (Yɛgɛ ɔ man nyi kʋtɔ mʋ nɩɩ ɛɛ tɔwɛ).” ");
INSERT INTO naw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ɔ dan san ɛɛ tɔwɛ nɩɩ abwaarɛ‐wʋlɛ a ba bun bamʋ sʋ. Nɩɩ ɩ kɩtaa abɩɩlapʋ mʋ kufuu kanan mʋ nɩɩ abwaarɛ‐wʋlɛ mʋ a bun bamʋ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nɩɩ ɔbʋlɛ kʋ tɔwɛ abwaarɛ‐wʋlɛ tɔ yɛ, “Ɔnɩmʋ ɩ gyɛ mi‐bii mʋ nɩɩ n wʋla lɛɛ. Fen nu mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ɔbʋlɛ mʋ maa tɔwɛ lʋwɛ mʋ, ba wu fɛɛ ɩ san Yesu nkʋn nɩn. Nɩɩ mʋ abɩɩlapʋ mʋ ba yɛgɛ nɩɩ asɩn mʋ a sii yɛ bamʋ nkʋn, ba man tɔwɛ ɔkʋ kʋtɔ mʋ nɩɩ ba wu saŋa maŋa. ");
INSERT INTO naw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ɩmʋ lɩɩkaakɛ mʋ ba maa lɩɩ kɩbɩɩ mʋ sʋ bɛɛ ba mʋ, sakyɔ damantɛ kʋ ba gyaŋa Yesu. ");
INSERT INTO naw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nɩɩ ɔnyɩn kʋ bʋ sakyɔ mʋ tɔ kuusi tɩɩ yɛ, “Ɔkaapʋpʋ! N kʋlɛ fʋ nɩn, kɩɩ mi kebii‐nyɩnsa‐bii nɩmʋ sa mɛ, mʋ nkʋn ɩ dan ɔ gyɛ mi‐bii. ");
INSERT INTO naw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kayaayu libi kʋ ɩɩ taalɛ ɛɛ ba mʋ sʋ, nɩɩ opula tɔ ee kuusi yɛgɛ ɩɩ sʋ mʋ ɩɩ tʋʋ kasɛ, ɩɩ bɩɩtɛ mʋ fɛɛ kabwɩɩ mʋ, yɛgɛ mʋ kɔnɔ tɔ ɩ lɩɩ afʋfʋʋ ɩ taa mʋ i kpii nɩɩ ɩ waa mʋ ɩ kyɛɛrɛɛ pɔyɩ kɛ ɩ yɛgɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nɩɩ n kʋlɛ fʋ abɩɩlapʋ yɛ ba gya kayaayu libi mʋ lɩɩ mʋ tɔ, amaa ba man taalɛ.” ");
INSERT INTO naw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “O! Fanɛ ndaga asa, fan man kɔɔlɛ Ɩbwaarɛ gyii, nɩɩ fanɛ ɩkpa ɩ man du kyɛɛkyɛɛ. Nkɛ nfɩnɛ nɩɩ n biti n kyɩna fanɛ asɛ nyɛ kenyiita sa fanɛ?” Nɩɩ ɔ tɔwɛ ɔnyɩn mʋ yɛ, “Taa fu‐bii mʋ ba nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nɩɩ kebii mʋ maa ba Yesu asɛ mʋ, nɩɩ kayaayu libi mʋ ba taa mʋ tʋʋ kasɛ nɩɩ i kpii mʋ fɛɛ kigbingbin mʋ. Amaa Yesu pʋntɛ kayaayu libi mʋ sʋ, nɩɩ ɔ kyɛ kebii mʋ bwiiyaa mʋ sa mʋ‐sɛ. ");
INSERT INTO naw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lɩɩ kanan mʋ nɩɩ Yesu lɛɛ Ɩbwaarɛ ɔlʋn kparɛ mʋ kaapʋ mʋ, ɩ waa asa mʋ kpini kɩyan. Ɩ maa san i kyinkyin asa mʋ lɩɩ kʋtɔ kʋmaa mʋ nɩɩ Yesu waa sʋ mʋ, ɔ tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Fan kan fanɛ asʋ kɛ fan nu yɛ ɔdan. Bee biti ba lɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ waa asa abaa tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amaa mʋ abɩɩlapʋ mʋ ba man nu ɩmʋ kasɛ. Ɩ gyɛ asɩn baalasa mʋ nɩɩ Ɩbwaarɛ man lɛɛ kaapʋ bamʋ, amaa nɩɩ ba sʋ kufuu fɛɛ ba taasɛ mʋ asɩn mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nɩɩ ɩmɔɔrɛ ɩ tɩyɛ mʋ abɩɩlapʋ mʋ nsana fɛɛ bamʋ tɔ mʋ, anɩmʋ ɩ gyɛ ɔlala. ");
INSERT INTO naw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Amaa Yesu maa bɩɩ nfɛɛrɛ mʋ nɩɩ bɛɛ fɛ mʋ, ɔ taa kebii pii ba yɩlɛ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fʋ kʋmaa mʋ nɩɩ fʋ kɔɔlɛ kebii nɩmʋ dubi mɛ kɩtɩɩ tɔ sʋ mʋ, fʋ kɔɔlɛ mɛ nɩmʋ. Nɩɩ fʋ kʋmaa mʋ nɩɩ fʋ kɔɔlɛ mɛ mʋ, fʋ kɔɔlɛ ɔmʋnɩ o sun mɛ mʋ. Nɩɩ ɔmʋnɩ ɔ gyɛ pii fanɛ kpini tɔ mʋ, mʋ ɩ gyɛ fanɛ tɔ ɔlala.” ");
INSERT INTO naw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nɩɩ Gyɔn tɔwɛ sa Yesu yɛ, “Ɔnyɩrɩpɛ! An wu ɔnyɩn kʋ maa sʋ fʋ kɩtɩɩ ɛɛ gya nbwɩɩ libi. Ɩmʋ sʋ an gya mʋ lɩɩ kɩmʋ tɔ. Lɩɩ fɛɛ ɔ man tii anɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan man gya mʋ. Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɔ mɛɛ tɔwɛ ee yii fanɛ mʋ, o tii fanɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu kibwii kpee sʋsʋ saŋa maa tiri tɔ mʋ, nɩɩ ɔ waa mʋ nfɛɛrɛ, nɩɩ o yii sʋ kpee Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tʋtɔ nɩɩ ɔ lɛɛ nbɔɔ sun yɛ ba gyankpaa mʋ kpee Samariya kadɛ‐bi tɔ naa kʋʋla gyoo mʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amaa tʋtɔ asa mʋ ba man kɔɔlɛ mʋ, lɩɩ fɛɛ ba dan be nyi maa kpee Gyerusalem nɩn. ");
INSERT INTO naw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nɩɩ mʋ abɩɩlapʋ anyɔ, Gyemisi maa Gyɔn ba maa wu kanɩn mʋ, nɩɩ ba yɛ, “Ɔnyɩrɩpɛ, fii biti fɛɛ a tɩɩ fʋlɔn lɩɩ sʋsʋ ba tuwa bamʋ abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Amaa nɩɩ Yesu biliŋi kɩɩ bamʋ, nɩɩ ɔ yɛ, “Fanɛ katɔwɛ maŋa man bʋrɔn.” ");
INSERT INTO naw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nɩɩ Yesu maa mʋ abɩɩlapʋ ba lɩɩ tʋtɔ taa kpee kadɛ‐bi pʋpwɛ kʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ba maa naa ɔkpa tɔ bee kpee mʋ, nɩɩ ɔnyɩn kʋ tɔwɛ Yesu yɛ, “N biti n buu fʋ kpee katɩn kʋmaa mʋ nɩɩ fii kpee mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nɩɩ Yesu tɔwɛ ɔnyɩn mʋ yɛ, “Agboogboo bɛɛ dɛ ɩbɔ tɔ, nɩɩ nbwiibi ba sʋ nsʋswaa, amaa mɛ, Daadimaadi Obii‐nyɩnsa bɩrɛ n man sʋ katɩn mʋ nɩɩ n dɛ fʋʋtɛ.” ");
INSERT INTO naw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nɩɩ Yesu bɩla tɔwɛ ɔnyɩn kʋ mɔɔ yɛ, “Buu mɛ.” Amaa ɔnyɩn mʋ tɔwɛ Yesu nɩn yɛ, “Ɔnyɩrɩpɛ, yɛgɛ n bwii kpee naa pula nsɛ pɔyɩ.” ");
INSERT INTO naw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Amaa Yesu tɔwɛ mʋ yɛ, “Yɛgɛ bamʋ nɩɩ ba du fɛɛ alewupu, lɩɩ fɛɛ ba man nyi Ɩbwaarɛ mʋ ba kpee naa pula bamʋ alewupu. Kɛ fɛɛ fʋ, fu kpee naa tɔwɛ Ɩbwaarɛ kuwura‐gyii mʋ asɩn.” ");
INSERT INTO naw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nɩɩ ɔnyɩn kʋ mɔɔ bɩla yɛ, “Ɔnyɩrɩpɛ n biti n buu fʋ, amaa yɛgɛ kɛ n bwii kpee naa kala mɛ kɩkpaara sʋ asa kɛ n ba.” ");
INSERT INTO naw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Fʋ kʋmaa mʋ nɩɩ fii biliŋi fɩɩ kɩɩ kamaa mʋ, nɩɩ fʋ nfɛɛrɛ man dɛ katɩn kʋlʋn mʋ, fʋ man dagaa Ɩbwaarɛ kuwura‐gyii.” ");
INSERT INTO naw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ɩnɩmʋ kamaa Ɔnyɩrɩpɛ Yesu lɛɛ asa adusunɔ yɛ anyɔ akʋ nɩɩ o sun bamʋ asa anyɔ‐anyɔ, yɛ ba gyankpaa mʋ kpee kadɛ kʋmaa yɛ katɩn kʋmaa mʋ nɩɩ ee biti o kpee mʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nɩɩ ɔ bɔ bamʋ kɩŋasan yɛ, “Ndɔɔ tɔ atɔ sɔyɩsa mʋ nɩɩ ɩ dagaa a tɩŋɛ mʋ ɩ kyɔ gaa, amaa atɩŋɛpʋ mʋ ba man kyɔ. Fan kʋlɛ Ɔnyɩrɩpɛ kusun mʋ wuya, kɛ ɔ bɩya atɩŋɛpʋ ba tii su kɛ ba ba waa mu kusun mʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Fan kpee, n sun fanɛ nɩn fɛɛ nbʋlʋpʋ‐bi ba maa kpee akuntun tɔ. ");
INSERT INTO naw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Fan man waa fan taa afulee abɛɛ adiikun abɛɛ asɩbɩta, kɛ fan man fwaala ɔkʋ ɔkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nɩɩ fan kan loo kɩkpaara kʋmaa sʋ mʋ, fan daa kɩtɔwɛ yɛ, ‘Keyuula kɩ ba kɩkpaara nɩmʋ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nɩɩ keyuula nyɩmɩsa kan ɔ bʋ tʋtɔ mʋ, fanɛ keyuula ii biti ɔ ba mʋ sʋ, nɩɩ ɩ man gyɛ kanɩn mʋ, ii biti i bwii ba fanɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Fan kyɩna kɩkpaara maŋa sʋ, kɛ fen gyii kɛ fen nuu kʋtɔ kʋmaa mʋ nɩɩ ba sa fanɛ. Lɩɩ fɛɛ osunpu kʋmaa kʋkɔka dagaa mʋ. Fan man ba fen loo fen loo akpaara‐akpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nɩɩ kadɛ kʋmaa mʋ nɩɩ fan loo kɩmʋ tɔ nɩɩ ba kɔɔlɛ fanɛ mʋ, fan gyii agyitɔ kʋmaa mʋ nɩɩ ba sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Fan kyɛ alɔpʋ mʋ nɩɩ ba bʋ kadɛ mʋ tɔ, kɛ fan tɔwɛ ɔkʋmaa yɛ, ‘Nbɩɩnbɩɩ, Ɩbwaarɛ kuwura‐gyii ki tiri fanɛ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amaa nɩɩ fan kan loo kadɛ kʋ tɔ nɩɩ ba man kɔɔlɛ fanɛ mʋ, fan lɩɩ kpee kadɛ mʋ agbenbi sʋ kɛ fan tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘An kpɩkpaa fanɛ kadɛ tɔ apurutiti mʋ nɩɩ ɩ bʋ anɛ ayaa sʋ mʋ gbaa an wʋrɩgɛ fanɛ sʋ, kɛ ɩ kaapʋ fɛɛ kʋtɔ mʋ nɩɩ fan waa mʋ, ɩ man bʋrɔn. Amaa fan baa fan nyi fɛɛ Ɩbwaarɛ kuwura‐gyii ki tiri tɔ.’ ");
INSERT INTO naw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nɩɩ n tɔwɛ fanɛ yɛ, katalɛ lala kakɛ mʋ, kadɛ maa kii biti kɩ nyɛ kʋsʋ bɩɩtɛ kɩ kyɔ kʋsʋ bɩɩtɛ mʋ nɩɩ kɩ ba Sodom kadɛ tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nɩɩ Yesu tɔwɛ yɛ, “Korasin abi fanɛ laakʋ, Basayida abi fanɛ laakʋ, adangana mʋ nɩɩ n waa fanɛ asɛ falɛ mʋ, nɩɩ ɩ daa ɩ gyɛ Taayi yɛ Sidon nɩɩ n waa kanɩn nɩn, naafɔɔ ba wʋla kyɩna kɛ ba dɩla ɩbɔɔta kɛ ba taa nsɔ bun bamʋ amu kɛ ɩ kaapʋ fɛɛ ba kyɛɛgɛ bamʋ nfɛɛrɛ lɩɩ alibi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Amaa katalɛ lala kakɛ mʋ, Taayi maa Sidon abi kʋsʋ bɩɩtɛ mʋ ii biti ɩ baa ɩ bɔɔ fanɛ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Fanɛ Kapanum abi, bee biti ba kukuri fanɛ kpee sʋsʋ nɩn abɛɛ? Ayee, bee biti ba bɩya fanɛ kasɛ kamandɛ.” ");
INSERT INTO naw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nɩɩ ɔ tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Ɔkʋmaa mʋ nɩɩ o nu fanɛ asɛ mʋ, nu mɛ asɛ, nɩɩ ɔkʋmaa mʋ nɩɩ o kina fanɛ mʋ, o kina mɛ, nɩɩ ɔkʋmaa mʋ nɩɩ o kina mɛ mʋ, o kina ɔmʋ nɩɩ o sun mɛ mʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Abɩɩlapʋ adusunɔ yɛ anyɔ mʋ nɩɩ Yesu sun mʋ ba bwii ba yɛ kensi‐gyii nɩɩ ba tɔwɛ yɛ, “Ɔnyɩrɩpɛ, fʋ kɩtɩɩ tɔ sʋ nbwɩɩ libi gbaa ba bɩya bamʋ n‐yɩɩ kasɛ sa anɛ.” ");
INSERT INTO naw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N wu Sɩtaanɛ maa lɩɩ sʋsʋ ba tɩyɛ kasɛ fɛɛ bʋlayɩ maa wɛɛ ɩsɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","N sa fanɛ ɔlʋn fɛɛ fen biti fan kyigya anansɛ yɛ ɩkyankpatɛ sʋ, kɛ fan nyɛ ɔlʋn fanɛ dʋn Sɩtaanɛ sʋ, nɩɩ sɛhn mɛɛ yɛ ɔ waa fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amaa fan man yɛgɛ ɩ waa fanɛ ɔkɔn fɛɛ n‐yaayu libi ba bɩya bamʋ n‐yɩɩ kasɛ sa fanɛ. Amaa fan yɛgɛ ɩ waa fanɛ ɔkɔn fɛɛ ba maa kyʋrɔɔ fanɛ atɩɩ yɩla Ɩbwaarɛ ayɛ.” ");
INSERT INTO naw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kanɩn saŋa maŋa Yesu kɔkɔlɔ ki fuuli mʋ lɩɩ Kayaayu Kyɩrɛkyɩrɛ sʋ, nɩɩ ɔ tɔwɛ yɛ, “Mɛ‐Sɛ, sʋsʋ yɛ kasɛ Ɔnyɩrɩpɛ, n fwaala fʋ lɩɩ fɛɛ fʋ taa atɔ nɩmʋ baala anyaasɩnpʋ yɛ ɩwʋlɛ anyipu sʋ, nɩɩ fʋ lɛɛ kaapʋ nbii wuribi. Nsɛ, fʋ kɩpɩrɛ sʋ nɩɩ fʋ waa ɩnɩmʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Mɛ‐Sɛ taa atɔ nɩmʋ kpini waa mɛ kɩbaa tɔ. Ɔkʋ mee nyi ɔmʋ nɩɩ mɛ, Obii mʋ n gyɛ, amɔɔ Ɔsɛ mʋ nkʋn, nɩɩ ɔkʋ mee nyi Ɔsɛ mʋ, amɔɔ bamʋ nɩɩ n biti n lɛɛ kaapʋ bamʋ mʋ nkʋn i nyi Ɔsɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tʋtɔ nɩɩ Yesu biliŋi tɔwɛ mʋ abɩɩlapʋ nkʋn yɛ, “Kumu ɔkɔn ɩ gyɛ sa fanɛ mʋ nɩɩ fan wu atɔ mʋ nɩɩ fan wu falɛ. ");
INSERT INTO naw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N bɩla n tɔwɛ fanɛ fɛɛ Ɩbwaarɛ atɔwɛpʋ gaalaagaa yɛ awura, ba daa bee biti ba wu atɔ mu nɩɩ fen wu falɛ amaa ba man wu. Nɩɩ ba daa bee biti ba nu asɩn mʋ nɩɩ fen nu falɛ, amaa ba man nu ɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kakaakʋ nbara ɔkaapʋpʋ onyipu kʋ kʋsʋ ba Yesu asɛ o be nu mʋ kɔnɔ tɔ asɩn. Nɩɩ ɔ taasɛ mʋ yɛ, “Ɔkaapʋpʋ, mɩnɛ nɩɩ n biti n waa kɛ n nyɛ nkpa kakpaa?” ");
INSERT INTO naw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Nɛnɛ nɩɩ ba kyʋrɔɔ Asɩnkyan yɩlasa mʋ tɔ? Nɛnɛ nɩɩ fʋ kalɛ ɩmʋ nu kasɛ?” ");
INSERT INTO naw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nɩɩ ɔnyɩn mʋ lɛɛ kɔnɔ yɛ, “Taa fʋ kɔkɔlɔ yɛ fʋ kala yɛ fʋ ɔlʋn yɛ fʋ nfɛɛrɛ kpini biti fʋ‐Nyɩrɩpɛ Ɩbwaarɛ, kɛ fu biti fʋ tɔɔmaa fɛɛ fʋ n‐yɩɩ.” ");
INSERT INTO naw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Fʋ lɛɛ kɔnɔ kyɛɛkyɛɛ sʋ. Waa ɩmʋ kɛ fʋ nyɛ nkpa.” ");
INSERT INTO naw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amaa ɔnyɩn mʋ ii biti ɔ kaapʋ fɛɛ mʋ ɩkpa i kyiigi sʋ mʋ, ɔ taasɛ Yesu yɛ, “Anɩmʋ ɩ gyɛ mɛ tɔɔmaa?” ");
INSERT INTO naw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nɩɩ Yesu kɔnɔ kɩlɛɛ tɔ mʋ, ɔ bɔɔ mʋ kɩŋasan yɛ, “Kakaakʋ nɩɩ ɔnyɩn kʋ lɩɩ Gyerusalem ee kpee Gyeriko. Nɩɩ ɔ naa tɩyɛ kumu ɔlʋn tɔ ayu abaa tɔ, nɩɩ ba dayɩ mʋ dɩlɩgɛ mʋ, nɩɩ ɩ san gbɛrɛɛ kɛ o wu nɩɩ ba yɛgɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɩ ba fɛɛ Ɩbwaarɛ oseepu kʋ naa ɔkpa maŋa sʋ ɛɛ ba. Maa wu ɔnyɩn mʋ, nɩɩ ɔ kɩlɩgɛ taa ɔkpa mʋ kɩbaafʋn kyʋn yɛgɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kanɩn ɔkpa kʋlʋn maŋa nɩɩ Lewi‐nyɩn kʋ gbaa bɔla ba wu mʋ, nɩɩ ɔ kɩlɩgɛ mʋ kyʋn. ");
INSERT INTO naw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amaa Kasamariya‐nyɩn kʋ gbaa bɔla ɔkpa maŋa ba lɩɩ mʋ sʋ. Maa ba wu ɔnyɩn mʋ, ɩ kɩtaa mʋ kʋwɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nɩɩ Kasamariya‐nyɩn mʋ natɛ kpee mʋ asɛ, nɩɩ ɔ taa wayɩn nta kpayɩ mʋ ɩlɔ ana mʋ tɔ, nɩɩ ɔ waa kɩfɛ mʋ ɩlɔ mʋ tɔ nɩɩ o ŋmina ɩmʋ. Nɩɩ ɔ taa mʋ gyaga mʋ kuruma sʋ kpee kɩkpaara mʋ nɩɩ afɔ bee loo kɩmʋ sʋ mʋ, nɩɩ ɔ kɩɩ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lɩɩkaakɛ, Kasamariya‐nyɩn mʋ maa biti ɔ kʋsʋ kpee mʋ, ɔ lɛɛ afulee sa afɔ kɩkpaara ɔkɩɩsʋpʋ mʋ. Nɩɩ ɔ tɔwɛ mʋ yɛ, ‘Kɩɩ ɔlɔpʋ nɩmʋ sʋ sa mɛ, nɩɩ fu kan nyita afulee akʋ tii ɩnɩmʋ sʋ mʋ, nɩɩ n kan bwii ba mʋ n biti n ba ka fʋ ɩmʋ kpini.’ ” ");
INSERT INTO naw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nɩɩ Yesu taasɛ nbara ɔkaapʋpʋ mʋ yɛ, “To, fʋ asɛ mʋ, asa asá nɩmʋ tɔ mʋ, ɔmɔɔ ɩ kaapʋ fɛɛ mʋ tɔɔmaa ɩ gyɛ ɔnyɩn mʋ nɩɩ amu tɔ ɔlʋn ayu ba dayɩ mʋ mʋ?” ");
INSERT INTO naw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nɩɩ nbara ɔkaapʋpʋ onyipu mʋ lɛɛ kɔnɔ yɛ, “Ɔmʋ nɩɩ o wu ɔnyɩn mʋ kʋwɛɛ mʋ.” Nɩɩ Yesu tɔwɛ mʋ yɛ, “Fʋ gbaa fʋ naa waa kanɩn.” ");
INSERT INTO naw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Saŋa mʋ nɩɩ Yesu maa mʋ abɩɩlapʋ bee kpee mʋ, ba naa fʋʋ kadɛ‐bi kʋ. Tʋtɔ nɩɩ ɔkyɩɩ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Maata waa mʋ nsa‐nsa taa mʋ kpee mʋ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maata sʋ osupu mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Mɛɛrɩ. Nɩɩ Mɛɛrɩ naa kyɩna Yesu asɛ ee nu mʋ kɩkaapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Amaa kanɩn asɩn mʋ ɩ tɔɔrɔɔ Maata lɩɩ fɛɛ mʋ nkʋn ɩɩ dɩŋa afɔ mʋ agyitɔ. Ɩmʋ sʋ ɔ ba Yesu asɛ ba tɔwɛ mʋ yɛ, “Mɛ‐Nyɩrɩpɛ, ɩ man tiri fʋ fɛɛ mi‐supu maa yɛgɛ mɛ nkʋn n waa kusun mʋ kpini? Tɔwɛ mʋ kɛ ɔ ba kyɛ mɛ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nɩɩ Ɔnyɩrɩpɛ Yesu lɛɛ mʋ kɔnɔ yɛ, “Maata, Maata! Asɩn gaalaagaa ɩ tɔɔrɔɔ fʋ, nɩɩ i tiri fʋ.” ");
INSERT INTO naw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Amaa kʋtɔ kʋlʋn i tiri. Mɛɛrɩ lɛɛ kɩmʋ nɩɩ kɩ bʋrɔn, nɩɩ ba mɛɛ yɛ ba taalɛ kɔɔlɛ ɩmʋ lɩɩ mʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kakaakʋ nɩɩ Yesu bʋ katɩn kʋ ɛɛ kʋlɛ Ɩbwaarɛ. Maa lʋwɛ mʋ, nɩɩ mʋ abɩɩlapʋ mʋ tɔ ɔkʋ tɔwɛ mʋ yɛ, “Ɔnyɩrɩpɛ, kaapʋ anɛ kabwaarɛ‐kʋlɛ fɛɛ kanan mʋ nɩɩ Gyɔn kaapʋ mʋ abɩɩlapʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan kan fen biti fan kʋlɛ kabwaarɛ‐kʋlɛ mʋ, fan tɔwɛ yɛ, ‘Anɛ‐Sɛ Ɩbwaarɛ, yɛgɛ asa ba bʋnyaa fʋ kɩtɩɩ, yɛgɛ fu kuwura‐gyii mʋ kɩ ba kasɛ sʋ nfɩɩ. ");
INSERT INTO naw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kɛ fʋ sa anɛ kakɛ kʋmaa agyitɔ gyisa. ");
INSERT INTO naw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Taa anɛ alibi kɛɛ anɛ, lɩɩ fɛɛ anɛ gbaa anɛ an sʋ an kɛɛ ɔkʋmaa mʋ nɩɩ ɔ waa anɛ alibi mʋ. Kɛ fʋ man yɛgɛ a loo kʋtʋʋ tɔ kɩɩ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “A taa fɛɛ fanɛ tɔ ɔkʋ kan kpee mʋ kyɛmɩnɛ asɛ kagyanbwɛ kiyiridi nsana yɛ, ‘Mɛ kyɛmɩnɛ, paala mɛ bodobodo asa. ");
INSERT INTO naw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Lɩɩ fɛɛ mɛ kyɛmɩnɛ kʋ ɩ dan lɩɩ ɔkpa sʋ ba sʋgɛ mɛ sʋ nbɩɩnbɩɩ nɩmʋ. Nɩɩ mɛɛ mɛ n man sʋ sɛhn n sa mʋ kɛ o gyii.’ ");
INSERT INTO naw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“A taa fɛɛ, mʋ kyɛmɩnɛ mʋ ɔ lɛɛ kɔnɔ obu to yɛ, ‘Man tɔɔrɔɔ mɛ, lɩɩ fɛɛ n tɩyɛ tii biri sʋ, nɩɩ maa mi‐bii ana an tɩyɛ dɛ, ɩmʋ sʋ n mɛɛ yɛ n bɩla taalɛ kʋsʋ sa fʋ sɛhn.’ ");
INSERT INTO naw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","N tɔwɛ fanɛ fɛɛ, nɩɩ ɩ kan ɩ gyɛ kakyɛmɩnɛ nkʋn sʋ mʋ, ɔ mɛɛ yɛ ɔ kʋsʋ sa mʋ sɛhn. Amaa kpalɩ fɛɛ maa man sʋ ipeeli nɩɩ ɔ san ɔ maa sʋ ɛɛ kʋlɛ mʋ, ɩ waa nɛnɛ ee biti ɔ kʋsʋ sa mʋ kʋtɔ kʋmaa mʋ nɩɩ i tiri sa mʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ɩmʋ sʋ n tɔwɛ fanɛ yɛ, Fan kyaga sʋ fɛn kʋlɛ Ɩbwaarɛ, ee biti ɔ sa fanɛ, fan kyaga sʋ fen biti, fen biti fan nyɛ, fan kyaga sʋ fɛn da ɔpʋnʋ, ee biti o tigi sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɛɛ kʋlɛ mʋ, bɛɛ sa mʋ, nɩɩ ɔmʋ nɩɩ ee biti mʋ, ɛɛ nyɛ, nɩɩ ɔmʋ nɩɩ ɛɛ da ɔpʋnʋ sʋ mʋ, bee tigi sa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nɩɩ fanɛ tɔ ɔsɛ mɔɔ nɩɩ mu‐bii ɩɩ kʋlɛ mʋ ɔkɩn, nɩɩ ɛɛ taa kɩnansɛ sa mʋ? ");
INSERT INTO naw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Abɛɛ ɛɛ kʋlɛ fʋ kibesi kɛ fʋ kɩtaa kyankpatɩ sa mʋ? ");
INSERT INTO naw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Fanɛ mʋ nɩɩ fɛn gyɛ alibi awaapʋ gbaa mʋ, fen nyi atɔ danbɩrasa kɩtaa sa fanɛ‐bii ana. Ɩ waa nɛnɛ sʋ nɩɩ fanɛ‐Sɛ mʋ nɩɩ ɔ bʋ sʋsʋ mɛɛ yɛ ɔ taa mʋ Kayaayu Kyɩrɛkyɩrɛ sa bamʋ nɩɩ ba kʋlɛ mʋ mʋ?” ");
INSERT INTO naw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kakaakʋ Yesu maa gya kabwɩɩ libi mʋ nɩɩ ɔ mɛɛ yɛgɛ nyɩmɩsa ɔ tɔwɛ. Saŋa mʋ nɩɩ kabwɩɩ libi mʋ lɩɩ mʋ tɔ mʋ, ɔnyɩn mʋ nɩɩ ɔ daa ɔ gyɛ naamuu mʋ, piili ɛɛ tɔwɛ. Nɩɩ i kyinkyin asa mʋ nɩɩ ba bʋ tʋtɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amaa asa mʋ tɔ akʋ ba tɔwɛ yɛ, “Nbwɩɩ libi kpini kumu mʋ nɩɩ bɛɛ tɩɩ Beelisebu mʋ, ɩɩ sa Yesu ɔlʋn nɩɩ ɛɛ taalɛ ɛɛ gya nbwɩɩ libi kanɩn mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nɩɩ akʋ mɔɔ ba tʋʋ mʋ tɔ kɩɩ, lan tɔwɛ yɛ, nɩɩ ɩ gyɛ yɛ Ɩbwaarɛ asɛ nɩɩ ɔ nyɛ mʋ ɔlʋn maŋa lɩɩ mʋ, ɔ waa asɩn kyinkyinsa kɛ ba kɩɩ. ");
INSERT INTO naw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amaa Yesu maa wʋla bɩɩ nfɛɛrɛ mʋ nɩɩ bɛɛ fɛ sʋ mʋ, ɔ tɔwɛ bamʋ yɛ, “Kuwura‐gyii mʋ nɩɩ kɩɩ barɩgɛ tɔ kɩɩ kɔ yɛ abaa mʋ, kɩ mɛɛ yɛ kɩ taalɛ yɩlɛ. Nɩɩ kɩkpaara mʋ nɩɩ kɩɩ barɩgɛ tɔ kɩɩ kɔ yɛ abaa mʋ gbaa, kɩ mɛɛ yɛ kɩ taalɛ yɩlɛ. ");
INSERT INTO naw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nɩɩ fɛɛ Sɩtaanɛ gbaa barɩgɛ tɔ kɩɩ kɔ yɛ kɩmʋ n‐yɩɩ mʋ, nɛnɛ nɩɩ kɩmʋ kuwura‐gyii ɩ taalɛ yɩlɛ? Lɩɩ fɛɛ fɛn tɔwɛ yɛ, Beelisebu ɔlʋn nɩɩ n sʋ n gya nbwɩɩ libi sʋ nɩɩ n tɔwɛ kanɩn. ");
INSERT INTO naw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nɩɩ ɩ gyɛ Beelisebu ɔlʋn nɩɩ n sʋ n gya nbwɩɩ libi mʋ, anɩmʋ ɔlʋn nɩɩ fanɛ abuupu bɩrɛ ba sʋ bɛɛ gya nbwɩɩ libi bɛɛ lɩɩ asa tɔ? Ɩnɩmʋ ɩ yɛgɛ kɛ fanɛ gbaa‐gbaa fanɛ abuupu ba talɛ fanɛ fɛɛ fanɛ lɛɛ man dɛ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amaa nɩɩ Ɩbwaarɛ ɔlʋn nɩɩ n sʋ n gya nbwɩɩ libi n lɩɩ asa tɔ mʋ, kɩmʋ ɩɩ kaapʋ fɛɛ Ɩbwaarɛ kuwura‐gyii kɩ ba fanɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Fɛɛ nɩɩ nyɩmɩsa bʋlʋnsa wʋla kʋʋla mʋ adʋntɔ ee kun mʋ kɩkpaara bɩrɛ, mʋ kapatɩyɛ kɩ dɛ sa mʋ bwahn. ");
INSERT INTO naw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amaa fɛɛ nɩɩ ɔkʋ ɔlʋn ɩ kyɔ mʋ lɛɛ mʋ, nɩɩ o tii mʋ waa tɔ taalɛ mʋ mʋ, ɛɛ kɔɔlɛ mʋ adʋntɔ mʋ nɩɩ mʋ tamaa gyan sʋ mʋ kpini, kɛ ɔ barɩgɛ mʋ kapatɩyɛ mʋ tɔ kɛɛ asa. ");
INSERT INTO naw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ man bʋ mɛ asɛ mʋ, ɛɛ kʋsʋ yɩlɛ mɛ sʋ nɩn, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ mɛɛ kʋʋla ɛɛ kyɛ mɛ tɔ mʋ, ɩɩ yaasɛ tɔ nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Fɛɛ nɩɩ kabwɩɩ libi kan lɩɩ nyɩmɩsa tɔ mʋ, ee kpee ɛɛ naa ɛɛ kyaabɔɔ ifuli sʋ ee biti ɔfʋʋtɛkpa. Nɩɩ ɔ man kan nyɛ mʋ, ɛɛ tɔwɛ sa mʋ n‐yɩɩ yɛ, ‘N biti n bwii kpee mɛ kɩkpaara mʋ nɩɩ n lɩɩ kɩmʋ sʋ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Maa ba mʋ o be wu fɛɛ ba fɔgɛ kɩkpaara mʋ, lɔŋɔ kɩmʋ atɔ kʋmaa yɩla kyɛɛkyɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kɛ ɔ bɩla naa taa nbwɩɩ libi asunɔ mʋ nɩɩ ba libi ba kyɔ mʋ tii mʋ n‐yɩɩ sʋ, kɛ ba kpee naa kyɩna tʋtɔ. Kɛ ɩ yɛgɛ kanɩn nyɩmɩsa maŋa kakyɩna tɔ ki nyita ɩ kyɔ kanan mʋ nɩɩ ɔ daa o du mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu maa tɔwɛ kanɩn mʋ, sakyɔ mʋ tɔ ɔkyɩɩ kʋ diyaa mʋ ɔbʋlɛ tɔwɛ mʋ yɛ, “Kusee ɩ gyɛ sa onyi mʋ nɩɩ ɔ kʋʋgɛ fʋ, nɩɩ ɔ sa fʋ mʋ kɩnyapʋ‐kyu mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Amaa Yesu lɛɛ mʋ kɔnɔ yɛ, “Kusee ɩ gyɛ sa bamʋ nɩɩ ba nu abwaarɛsɩn nɩɩ ba buu ɩmʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Asa mʋ ba maa nyɛ akyɔ bee tii sʋ mʋ, Yesu tɔwɛ yɛ, “Ndaga asa libi kakyɩna kanɩmʋ tɔ bɛɛ taasɛ bee biti asɩn kyinkyinsa, amaa mɛɛ yɛ n waa sɛhn sa bamʋ, amɔɔ Ɩbwaarɛ Ɔtɔwɛpʋ Gyona lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ yɛgɛ nɩɩ Gyona kyɩna ɔ gyɛ sɩnkaala sa Ninewe abi mʋ, kanɩn maŋa sʋ nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa gbaa n biti n ba waa Ɩbwaarɛ sɩnkaala sa ndaga asa kakyɩna nɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nɩɩ Ɩbwaarɛ katalɛ akɛ mʋ, Owura kyɩɩsa mʋ nɩɩ ɔ kyɩna lɩɩ akpɩlɩgɛ mʋ, ii biti ɔ kʋsʋ yɩlɛ kɛ o bun ndaga kakyɩna nɩmʋ tɔ asa kʋpwɛ. Kpalɩ fɛɛ ɔ lɩɩ kata‐kata dulinyaa ɔkaa o be nu Solomon mʋ nɩɩ ɔ kyɩna ɔ gyɛ Ɩsɩrayɩ owura mʋ kanyaasɩn. Amaa n tɔwɛ fanɛ yɛ n kyɔ Owura Solomon mʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nɩɩ katalɛ akɛ mʋ Ninewe abi mʋ nɩɩ ba daa kyɩna dɩdaa mʋ, bee biti ba kʋsʋ yɩlɛ talɛ fanɛ ndaga asa nɩmʋ tɔ, kɛ ba bun fanɛ kʋpwɛ. Kpalɩ fɛɛ saŋa mʋ nɩɩ Gyona tɔwɛ abwaarɛsɩn sa bamʋ mʋ, ba yɛgɛ alibi kɩwaa. Amaa n tɔwɛ fanɛ yɛ n kyɔ Gyona mʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ɔkʋ mee tuwa fɩtɩla ɔ sʋ ɛɛ yɩla katɩn mʋ nɩɩ kii biti kɩ baala, abɛɛ ɔ taa waa kolobi tɔ. Amaa ɛɛ taa gyaga kɩmʋ ɔgyagakpa nɩn, kɛ asa mʋ nɩɩ bee biti ba ba tʋtɔ mʋ, ɩ baa ɩ kɩɩ bamʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Fu ansi ɩ gyɛ fɩtɩla sa fʋ n‐yɩɩ. Nɩɩ fu ansi ɩ kan ɩ bʋrɔn mʋ, fʋ n‐yɩɩ kpini gbaa gyɛ fɩtɩla nɩn. Amaa nɩɩ fu ansi ɩ man kan ɩ bʋrɔn mʋ, fʋ n‐yɩɩ kpini gbaa bʋ kitentenbiri tɔ. ");
INSERT INTO naw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kanɩn sʋ kɩɩ sʋ yɛ ɔdan, kɛ fɩtɩla mʋ nɩɩ ɔ bʋ fʋ tɔ mʋ kɩ man biliŋi kitentenbiri. ");
INSERT INTO naw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ɩmʋ sʋ fɛɛ nɩɩ fʋ n‐yɩɩ kpini gyɛ fɩtɩla, nɩɩ ɩmʋ kɩbaafʋn kʋ man gyɛ kitentenbiri mʋ, ii biti ɩ baa ɩ kɩɩ tɔ gaa, fɛɛ fɩtɩla maa kɩɩ tɔ kɩ ŋalɩgɛ fanɛ sʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Saŋa mʋ nɩɩ Yesu tɔwɛ lʋwɛ mʋ, Kafarasii‐nyɩn kʋ tɩɩ Yesu yɛ, ɔ ba kɛ maa mʋ ba bʋga gyii. Ɩmʋ sʋ o kpee nɩɩ maa mʋ ba naa bʋga bee gyii. ");
INSERT INTO naw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Amaa ɩ waa Kafarasii‐nyɩn mʋ kanankʋ, fɛɛ Yesu maa man fwɩɩ mʋ abaa fɛɛ kanan mʋ nɩɩ anaana tɔ ɩ kaapʋ mʋ pɔyɩ nɩɩ ee gyii. ");
INSERT INTO naw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tʋtɔ nɩɩ Ɔnyɩrɩpɛ Yesu mʋ tɔwɛ mʋ yɛ, “Fanɛ Farasii abi falɛ nɩɩ fen du, fɛn fwɩɩ nwɛ‐bi yɛ ɩlapɛ nmaa, amaa kumu tɔ ɔlʋn yɛ kensi payɩ libi ɩ bɔla fanɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Fanɛ amelensipu nɩmʋ! Fan man nyi fɛɛ Ɩbwaarɛ mʋ nɩɩ ɔ pɔyɩ kɩmʋ kamaa yɛ ɔtɔ tɔ mʋ, kpini asɩn i tiri sa mʋ? ");
INSERT INTO naw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Amaa fan taa ɩmʋ nɩɩ ɩ bʋ fanɛ nwɛ‐bi yɛ ɩlapɛ mʋ tɔ sa atiripu, kɛ kʋtɔ kʋmaa kɩnɩmʋ ɩ waa kyɩrɛkyɩrɛ sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Fanɛ Farasii abi fanɛ laakʋ, lɩɩ fɛɛ fan barɩgɛ fanɛ adɔɔ‐gyitɔ ntun kudu nɩɩ fan taa ketun kʋlʋn fɛn sa Ɩbwaarɛ. Amaa fan kina fen mee gyii asɩn ɩmʋ ɔkpa sʋ, nɩɩ fen mee biti Ɩbwaarɛ. Ɩ dagaa fɛɛ fan daa kɩwaa ɩnɩmʋ, kɛ fan taa ketun kʋlʋn mʋ sa Ɩbwaarɛ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Fanɛ Farasii abi fanɛ laakʋ, lɩɩ fɛɛ fen biti ɩkyɩnakpa kparɛ‐kparɛ Gyiwu abi kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa, nɩɩ fen biti bɛɛrɛɛ afwaala agya tɔ ipula. ");
INSERT INTO naw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Fanɛ laakʋ, lɩɩ fɛɛ fen du nɩn fɛɛ nkyan mʋ nɩɩ ba man daasɛ ɩmʋ fɛɛ nkyan, nɩɩ asa ba naa ɩmʋ sʋ yɛgɛ ba man nyi fɛɛ ɩ gyɛ nkyan.” ");
INSERT INTO naw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nɩɩ nbara ɔkaapʋpʋ onyipu kʋ lɛɛ kɔnɔ yɛ, “Ɔkaapʋpʋ, ɩmʋ nɩɩ fɩɩ tɔwɛ falɛ mʋ, fɩɩ saalɛ anɛ gbaa anɛ tii sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu lɛɛ kɔnɔ yɛ, “Fanɛ nbara akaapʋpʋ anyipu, fanɛ laakʋ, lɩɩ fɛɛ fan taa ɩsʋla budusa mʋ nɩɩ ɩ bʋsɩn kasʋla mʋ sʋla asa. Nɩɩ fanɛ gbaa‐gbaa fanɛ fan mɛɛ taa kɩbaa‐bi kʋlʋn gbaa kyɛ bamʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Fanɛ laakʋ, lɩɩ fɛɛ fan pɔyɩ nkyan sa Ɩbwaarɛ atɔwɛpʋ, nɩɩ fanɛ naana ana ɩ gyɛ asa mʋ nɩɩ ba mɔɔ bamʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ɩmʋ sʋ ɩnɩmʋ ɩ lɛɛ kaapʋ kesintin fɛɛ kʋtɔ mʋ nɩɩ fanɛ naana ana ba waa mʋ, fan kɔɔlɛ kyula. Lɩɩ fɛɛ ba mɔɔ Ɩbwaarɛ atɔwɛpʋ mʋ nɩɩ fanɛ mɔɔ fan pɔyɩ bamʋ nkyan. ");
INSERT INTO naw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Lɩɩ ɩnɩmʋ sʋ, nɩɩ Ɩbwaarɛ tɔwɛ lɩɩ mʋ kanyaasɩn tɔ yɛ, ‘N biti n sun mɛ atɔwɛpʋ yɛ mi asunpu ba kpee bamʋ asɛ, kɛ ba mɔɔ mɛ asa mʋ akʋ kɛ ba nyanla asansa.’ ");
INSERT INTO naw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ɩmʋ sʋ kʋsʋ bɩɩtɛ mʋ nɩɩ kɩ dɛ sa asa mʋ nɩɩ ba mɔɔ mʋ atɔwɛpʋ mʋ nɩɩ ba kyɩna kasɛ sʋ lɩɩ koo dulinyaa npiili mʋ, ee biti ɔ taa kanɩn kʋsʋ bɩɩtɛ mʋ bɩɩtɛ ndaga asa libi kakyɩna nɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Asa mʋ nɩɩ ba mɔɔ lɩɩ Abeli sʋ naa fʋʋ Sakariya mʋ nɩɩ ba mɔɔ mʋ kaswɩɩ yɛ kabwaarɛ‐sunkpa ayɛ nsana mʋ, n tɔwɛ fanɛ kesintin fɛɛ, Ɩbwaarɛ ii biti ɔ taa amɔɔpʋ mʋ kʋsʋ bɩɩtɛ mʋ ɔ bɩɩtɛ fanɛ ndaga kakyɩna tɔ asa libi banɩmʋ. ");
INSERT INTO naw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Fanɛ nbara akaapʋpʋ anyipu, fanɛ laakʋ, lɩɩ fɛɛ fan taa ɔkpa mʋ nɩɩ asa bee biti ba bɔla sʋ bɩɩ Ɩbwaarɛ mʋ baala. Nɩɩ fanɛ gbaa‐gbaa fanɛ fan man naa ɔkpa maa sʋ, nɩɩ fen tii bamʋ nɩɩ bee biti ba natɛ kɩmʋ sʋ mʋ ɔkpa.” ");
INSERT INTO naw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu maa lɩɩ tʋtɔ mʋ, nɩɩ Farasii abi yɛ nbara akaapʋpʋ ba piili bɛɛ pwɩɩ mʋ kenken, yɛgɛ bɛɛ taasɛ mʋ asɩn lɩɩ atɔ gaalaagaa sʋ, ");
INSERT INTO naw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","yɛgɛ ba gyoo fɛɛ bee biti ba nyɛ mʋ kɔnɔ tɔ asɩn tɔwɛsa akʋ mʋ nɩɩ ɩ man dagaa kɛ ba kɩtaa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Saŋa maŋa tɔ mʋ, asa mʋ ba maa nyɛ akyɔ bee tii sʋ, halɩɩ bee kyigya abaa ayaa sʋ mʋ, nɩɩ Yesu piili ɛɛ tɔwɛ mʋ abɩɩlapʋ asɛ, nɩɩ ɔ gyankpaa ɛɛ tɔwɛ yɛ, “Fan baa fan da fanɛ n‐yɩɩ sʋ lɩɩ Farasii abi kebunbun ansi wuya ana sʋ. Bamʋ akaapʋsa i du nɩn fɛɛ bodobodo kɩfɛ tinsa. ");
INSERT INTO naw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kʋtɔ kʋ man bʋ tɔ nɩɩ kɩ baala yɛgɛ ba mɛɛ yɛ ba bɩɩ, abɛɛ asiri kʋ man bʋ tɔ nɩɩ ɩ mɛɛ yɛ ɩ lɩɩ ifuli. ");
INSERT INTO naw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ɩmʋ sʋ asɩn kʋmaa mʋ nɩɩ fʋ tɔwɛ kitentenbiri tɔ mʋ, kayɩ kakɛ mʋ ii biti ɩ lɩɩ ifuli, nɩɩ asɩn mʋ nɩɩ fu‐kuli waa kʋsʋ tɔ obu to mʋ, bee biti ba taa ɩmʋ da kibonbon.” ");
INSERT INTO naw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nɩɩ Yesu kyaga sʋ tɔwɛ yɛ, “Mɛ kyɛmɩnɛ ana, fan man sɩlɛ bamʋ nɩɩ bɛɛ taalɛ mɔɔ kayɩɩ‐wʋlɛ, nɩɩ ɩmʋ kamaa mʋ ba mɛɛ bɩla taalɛ waa kɩmʋ sɛhn. ");
INSERT INTO naw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Amaa n biti n kaapʋ fanɛ ɔmʋ nɩɩ ɩ dagaa yɛ fan sɩlɛ. Fan sɩlɛ ɔmʋ nɩɩ ɛɛ taalɛ mɔɔ fanɛ kayɩɩ‐wʋlɛ kɛ ɔ bɩla taa fanɛ waa fʋlɔn tɔ. N tɔwɛ fanɛ fan sɩlɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Afɩnɛ ɩ gyɛ langba kɩgya? Kobo anyɔ ɩ taalɛ sɔɔ bamʋ anuu. Amaa n mɛɛ tan bamʋ ɔkʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Halɩɩ fanɛ kumu tɔ inyini kpini gbaa Ɩbwaarɛ nyi ɩmʋ kɔnɔ. Ɩmʋ sʋ fan man waa kufuu, lɩɩ fɛɛ fan gyɛ akparɩ fan kyɔ alangba ngbɩn‐ngbɩn. ");
INSERT INTO naw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“N tɔwɛ fanɛ yɛ, ɔkʋmaa mʋ nɩɩ ɛɛ tɔwɛ sakyɔ tɔ yɛ ɔ gyɛ mɛ lɛɛ mʋ, mɛ, Daadimaadi Obii‐nyɩnsa gbaa n biti n tɔwɛ Ɩbwaarɛ nbɔɔ ansi tɔ yɛ ɔ gyɛ mɛ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amaa ɔkʋmaa mʋ nɩɩ o kina mɛ sakyɔ tɔ mʋ, ngbaa mɛ n biti n kina mʋ Ɩbwaarɛ nbɔɔ ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Nɩɩ ɔkʋmaa mʋ nɩɩ ɛɛ tɔwɛ asɩn libi ee yii mɛ, Daadimaadi Obii‐nyɩnsa mʋ, Ɩbwaarɛ ɩɩ taalɛ taa kɛɛ mʋ, amaa ɔkʋmaa mʋ nɩɩ ɛɛ tɔwɛ asɩn libi ee yii Kayaayu Kyɩrɛkyɩrɛ mʋ, Ɩbwaarɛ mɛɛ yɛ ɔ taa kɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nɩɩ ba kan bɩya fanɛ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa abɩlɩsa, abɛɛ awura abɛɛ ɔsʋwʋlɛ alʋnpʋ ansi tɔ mʋ, fan man kan fɛ nfɛɛrɛ kanan mʋ nɩɩ fen biti fan lɛɛ fanɛ asɩn mʋ kɔnɔ, abɛɛ asɩn mʋ nɩɩ fan tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lɩɩ fɛɛ Kayaayu Kyɩrɛkyɩrɛ mʋ ii biti ɔ kaapʋ fanɛ asɩn mʋ nɩɩ fan tɔwɛ saŋa maŋa.” ");
INSERT INTO naw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nɩɩ sakyɔ mʋ tɔ ɔkʋ tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, tɔwɛ sa mɛ‐daa kɛ ɔ yɛgɛ maa mʋ a barɩgɛ kapatɩyɛ mʋ nɩɩ anɛ‐sɛ wu yɛgɛ sa anɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɔnyɩn, anɩmʋ i yii mɛ asɩn ogyipu abɛɛ kapatɩyɛ ɔbarɩgɛpʋ?” ");
INSERT INTO naw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nɩɩ ɔ kyaga sʋ tɔwɛ bamʋ yɛ, “Fan kɩɩ danbɩrasa kɛ fan baa fan da fanɛ n‐yɩɩ sʋ lɩɩ kensi payɩ libi sʋ. Lɩɩ fɛɛ nyɩmɩsa nkpa man gyɛ mʋ atɔ damantɛ mʋ nɩɩ ɔ sʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nɩɩ ɔ bɔ bamʋ kɩŋasan kɩnɩmʋ yɛ, “Afulee wuya kʋ sʋ ndɔɔ nɩɩ kɩ waa agyitɔ gaa. ");
INSERT INTO naw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɔnyɩn mʋ fɛ nfɛɛrɛ fɛɛ, ‘Nɛnɛ nɩɩ n biti n waa? N man sʋ katɩn mʋ nɩɩ n taa mɛ agyitɔ anɩmʋ kpini waa.’ ");
INSERT INTO naw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Nɩɩ ɔ tɔwɛ yɛ, ‘Falɛ nɩɩ n biti n waa. N biti n nyita mɛ agyitɔ ɩwaakpa mʋ, kɛ n lɔŋɔ waa ɩmʋ alala‐alala. Kɛ n taa mɛ adɔɔ‐gyitɔ yɛ mɛ atɔ kpini waa tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nɩɩ n biti n tɔwɛ sa mɛ n‐yɩɩ yɛ, “Fʋ sʋ atɔ damantɛ nɩɩ ɩ dɛ sa fʋ nsu‐nsu. Kanɩn sʋ fʋʋtɛ kɛ fu gyii, kɛ fu nuu kɛ fu gyii fu ansi.” ’ ");
INSERT INTO naw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Amaa Ɩbwaarɛ tɔwɛ mʋ yɛ, ‘Omelensipu nɩmʋ, kagyanbwɛ nɩmʋ fʋ nkpa ii biti ɩ lɩɩ fʋ abaa tɔ. Nɩɩ atɔ mʋ nɩɩ fʋ kʋʋla sa fʋ n‐yɩɩ yɩla mʋ ii biti i biliŋi anɩmʋ lɛɛ?’ ” ");
INSERT INTO naw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nɩɩ Yesu tɔwɛ yɛ, “Ɔkʋmaa mʋ nɩɩ ɛɛ kʋʋla atɔ ɛɛ yɩla ɛɛ sa mʋ n‐yɩɩ, nɩɩ Ɩbwaarɛ asɛ bɩrɛ ɔ man gyɛ atɔ wuya, falɛ nɩɩ ii biti ɩ waa mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ yɛ, “Kanɩn sʋ nɩɩ n tɔwɛ fanɛ yɛ, fan man fɛ nfɛɛrɛ lɩɩ kakyɩna kanɩmʋ tɔ atɔ tirisa fɛɛ atɔ mʋ nɩɩ fen biti fan gyii, abɛɛ atɔ mʋ nɩɩ fan nyɛ bun fanɛ n‐yɩɩ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nkpa i tiri ɩ kyɔ agyitɔ, kanɩn nɩɩ kayɩɩ‐wʋlɛ gbaa ki tiri kɩ kyɔ atɔ bunsa. ");
INSERT INTO naw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Fan taa fanɛ ansi kɩɩ nbwiibi, ba mɛɛ duu nɩɩ ba mɛɛ tɩŋɛ, nɩɩ ba mɛɛ sʋ abu kɛ ba kʋʋla bamʋ agyitɔ yɩla, amaa Ɩbwaarɛ ɩɩ kɩɩ bamʋ sʋ. Fan man gyɛ akparɩ fan kyɔ nbwiibi? ");
INSERT INTO naw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Fanɛ anɩmʋ lɩɩ mʋ kayɩyɛɛ sʋ nɩɩ ɛɛ taalɛ taa kakɛ kʋlʋn tii mʋ nkpa sʋ? ");
INSERT INTO naw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nɩɩ fan maa mɛɛ taalɛ waa atɔ pii anɩmʋ mʋ, mɩnɛ waa nɩɩ fɛn yɩyɛɛ asansa sʋ? ");
INSERT INTO naw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Fan kɩɩ kanan mʋ nɩɩ iyu ntʋtʋlɛ i du, i mee sun nɩɩ ɩ mɛɛ lʋʋ ataa ɩ sa ɩmʋ n‐yɩɩ. Amaa n tɔwɛ fanɛ fɛɛ, Owura lala Solomon maa mʋ atɔ danbɩrasa kpini gbaa mʋ, ɔ man taalɛ nyɛ atɔ bunsa danbɩrasa fɛɛ ntʋtʋlɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Fanɛ kɩkɔɔlɛ‐gyii pii wuya ana, nɩɩ ɩ kan ɩ gyɛ falɛ nɩɩ Ɩbwaarɛ i bun afitiri tɔ ntʋtʋlɛ mʋ nɩɩ ɩ bʋ tɔ ndaga kɛ ɔkɛ ba taa tʋʋ fʋlɔn tɔ mʋ, mɩnɛ ɩ waa nɩɩ Ɩbwaarɛ mɛɛ yɛ ɔ sa fanɛ atɔ bunsa? ");
INSERT INTO naw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Fan man yɛgɛ fanɛ nkɔlɔ ɩ baa ɩ gyan atɔ mʋ nɩɩ fen biti fan gyii abɛɛ fan nuu mʋ sʋ, fan man yɛgɛ ɩnɩmʋ ɩ tɔɔrɔɔ fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Lɩɩ fɛɛ bamʋ nɩɩ ba mɛɛ sun Ɩbwaarɛ mʋ, ɩ fɛ ɩnɩmʋ ana kpini nfɛɛrɛ. Nɩɩ fanɛ‐Sɛ Ɩbwaarɛ nyi fɛɛ ɩnɩmʋ ana kpini i tiri fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Amaa fan kɩɩ biti Ɩbwaarɛ kuwura‐gyii mʋ, kɛ ɔ sa fanɛ ɩnɩmʋ kpini tii sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nɩɩ Yesu bɩla tɔwɛ yɛ, “Kʋbʋ pii, fan man waa kufuu, lɩɩ fɛɛ ɩ bɔla fanɛ‐Sɛ Ɩbwaarɛ ansi fɛɛ ɔ waa fanɛ awura‐bii mu kuwura‐gyii tɔ. ");
INSERT INTO naw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Fan fɛ fanɛ npatɩyɛ kpini, kɛ fan taa afulee mʋ sa atiripu. Fan nyɛ afulee mʋ nɩɩ ɩ mɛɛ yɛ ɩ lʋwɛ mʋ yɩla sʋsʋ, ntɩn mʋ nɩɩ oyu mɛɛ yɛ ɔ taalɛ nin tiri tɔ, nɩɩ tabɩrɩta mɛɛ taalɛ nyita ɩmʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lɩɩ fɛɛ ntɩn mʋ nɩɩ fʋ kapatɩyɛ kɩ bʋ mʋ, tʋtɔ nɩɩ fʋ kɔkɔlɔ gbaa kɩ bʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Fan kʋʋla fanɛ n‐yɩɩ kɩrɩsʋ fan gyoo, kɛ fan yɛgɛ fanɛ ɩfɩtɩla ɩ baa ɩ kɩɩ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Fɛɛ ayaafɔlɛ ba maa gyoo bamʋ‐nyɩrɩpɛ ɔ lɩɩ kɩkyɩɩfɔ tɔ ba, nɩɩ ɔ kan ba da kebunɔ mʋ, kɛ ba nyɛ tigi mʋ bilen. ");
INSERT INTO naw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ayaafɔlɛ mʋ nɩɩ bamʋ‐nyɩrɩpɛ ba tu bamʋ yɛgɛ ba tɛ ba gyoo mʋ, bamʋ ansi ii biti i gyii. N tɔwɛ fanɛ kesintin fɛɛ ee biti ɔ kʋʋla mʋ n‐yɩɩ kɛ mʋ gbaa‐gbaa mʋ ɔ taa agyitɔ naa yii bamʋ kɛ ba gyii. ");
INSERT INTO naw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ayaafɔlɛ mʋ nɩɩ bamʋ‐nyɩrɩpɛ ba tu bamʋ kagyanbwɛ kiyiridi nsana abɛɛ kɩbwayɩkɛ yɛgɛ ba kʋʋla ba gyoo mʋ mʋ, bamʋ ansi ii biti i gyii. ");
INSERT INTO naw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Amaa fan baa fen nyi fɛɛ, nɩɩ kɩkpaara wuya daa o nyi saŋa mʋ nɩɩ oyu ii biti o be yuuri nɩn, naafɔɔ ɔ mɛɛ yɛ ɔ yɛgɛ ba be boyi loo mʋ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ɩ dagaa fɛɛ fanɛ gbaa fanɛ fan kʋʋla fanɛ n‐yɩɩ fan gyoo. Lɩɩ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n biti n ba saŋa mʋ nɩɩ fan mɛɛ fɛ mɛ kɩba mʋ nfɛɛrɛ.” ");
INSERT INTO naw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nɩɩ Pita taasɛ yɛ, “Ɔnyɩrɩpɛ, anɛ nɩɩ fɩɩ bɔɔ kɩŋasan kanɩmʋ fɩɩ sa abɛɛ ɔkʋmaa nɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nɩɩ Ɔnyɩrɩpɛ lɛɛ kɔnɔ yɛ, “Anɩmʋ bɩrɛ ɩ gyɛ kɩyaafɔlɛ mʋ nɩɩ ɔ sʋ kesintin yɛ kanyaasɩn? Mʋ ɩ gyɛ ɔmʋnɩ mʋ‐nyɩrɩpɛ taa mʋ ayaafɔlɛ waa mʋ abaa tɔ, yɛ ɔ sa bamʋ agyitɔ saŋa mʋ nɩɩ ɩ dagaa. ");
INSERT INTO naw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kensi‐gyii ɩ gyɛ sa kɩyaafɔlɛ mʋ nɩɩ mʋ‐nyɩrɩpɛ ba tu mʋ yɛgɛ ɛɛ waa kanɩn. ");
INSERT INTO naw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","N tɔwɛ fanɛ kesintin fɛɛ mʋ‐nyɩrɩpɛ mʋ ii biti ɔ taa mʋ kapatɩyɛ kpini‐kpini waa mʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amaa a taa fɛɛ nɩɩ kɩyaafɔlɛ mʋ kan tɔwɛ mʋ n‐yɩɩ fɛɛ, ‘Mɛ‐nyɩrɩpɛ ii biti ɔ kyɛɛrɛɛ!’ Nɩɩ o piili ɛɛ dayɩ mʋ‐nyɩrɩpɛ ayaafɔlɛ yɛ abite, nɩɩ ee gyii nɩɩ ee nuu bʋʋ bɩrɛ, ");
INSERT INTO naw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kanɩn kɩyaafɔlɛ maŋa mʋ‐nyɩrɩpɛ ii biti o be purigi mʋ saŋa mʋ nɩɩ ɔ man fɛ nfɛɛrɛ fɛɛ ee biti ɔ ba, yɛ saŋa mʋ nɩɩ ɔ man nyi sʋ. Mʋ‐nyɩrɩpɛ mʋ biti ɔ tɩŋɛ mʋ kʋkyʋkyʋʋ, kɛ ɔ bɩɩtɛ mʋ kʋsʋ fɛɛ kanan mʋ nɩɩ ɛɛ bɩɩtɛ asʋ tɔ ɔlʋn wuya ana kʋsʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kɩyaafɔlɛ mʋ nɩɩ o nyi kʋtɔ mʋ nɩɩ mʋ‐nyɩrɩpɛ ii biti, nɩɩ ɔ man kʋʋla mʋ n‐yɩɩ ɔ waa kʋtɔ mʋ nɩɩ ee biti mʋ, bee biti ba tɩŋɛ mʋ kʋkyʋkyʋʋ gaa. ");
INSERT INTO naw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amaa ɔmʋnɩ ɔ man nyi nɩɩ ɔ waa atɔ mʋ nɩɩ ɩ dagaa kʋsʋ bɩɩtɛ mʋ, bee biti ba tɩŋɛ mʋ pii. Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ba sa mʋ gaa mʋ, bee biti ba kɔɔlɛ gaa lɩɩ mʋ asɛ. Nɩɩ ɔkʋmaa mʋ nɩɩ ba taa gaa waa mʋ kɩbaa tɔ mʋ, bee biti ba kɔɔlɛ kʋkyɔ lɩɩ mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“N ba nɩn yɛ n ba yɛgɛ fʋlɔn ɔ dɛɛ kasɛ sʋ, naafɔɔ n daa n biti gbaa fɛɛ fʋlɔn mʋ tɛɛ ɩ dɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Awʋrʋfɔ lala ii biti i munla mɛ, nɩɩ ɩ tɔɔrɔɔ mɛ gaa fɛɛ ɩ ba kɛ ɩ ba kyʋn. ");
INSERT INTO naw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Fen nyi fɛɛ keyuula nɩɩ n bɩya kasɛ sʋ? Ayee, n tɔwɛ fanɛ yɛ nbarɩgɛ tɔ nɩɩ n bɩya. ");
INSERT INTO naw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Lɩɩ ndaga ɩ sʋ ii kpee mʋ, kɩkpaara kʋlʋn sʋ mʋ, asa anuu bee biti ba barɩgɛ tɔ yɛ abaa, kɛ asa asá ba kɔ yɛ asa anyɔ, kɛ asa anyɔ ba kɔ yɛ asa asá. ");
INSERT INTO naw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nbarɩgɛ tɔ ii biti ɩ ba ɔsɛ yɛ obii‐nyɩnsa nsana, obii‐nyɩnsa yɛ ɔsɛ nsana, onyi yɛ obii‐kyɩɩsa nsana, obii‐kyɩɩsa yɛ onyi nsana, ɔsaa‐kyɩɩsa yɛ ɔsaa nsana, ɔsaa yɛ ɔsaa‐kyɩɩsa nsana.” ");
INSERT INTO naw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu tɔwɛ sakyɔ mʋ yɛ, “Saŋa kʋmaa mʋ nɩɩ fen wu kabwaarɛ wʋlɛ maa gyaga kyɔwɛ kɩtɩyɛ mʋ, opula maŋa tɔ nɩɩ fɛn tɔwɛ yɛ, ‘Bʋlayɩ ii biti ɔ daa,’ nɩɩ ɛɛ daa. ");
INSERT INTO naw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nɩɩ afuu a daa a lɩɩ akpɩlɩgɛ mʋ fɛn tɔwɛ yɛ, ‘Kududuu kii biti kɩ waa,’ nɩɩ ɩ waa. ");
INSERT INTO naw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Fanɛ kebunbun ansi wuya ana fɛn taalɛ fɛn kɩɩ kasɛ yɛ sʋsʋ fɛn kaapʋ ɩmʋ kasɛ. Nɩɩ mɩnɛ ɩ waa nɩɩ fɛn mɛɛ taalɛ bɩɩ atɔ mʋ nɩɩ Ɩbwaarɛ ɩɩ waa nbɩɩnbɩɩ nɩmʋ kasɛ? ");
INSERT INTO naw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mɩnɛ waa nɩɩ fɛn mɛɛ taalɛ talɛ fanɛ n‐yɩɩ bɩɩ kʋtɔ mʋ nɩɩ kɩ bʋrɔn kɛ fan waa? ");
INSERT INTO naw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nɩɩ ɔkʋ kan pwɩɩ fʋ, nɩɩ faa mʋ fen kpee asɩn ogyikpa mʋ, kpan fʋ n‐yɩɩ kɛ faa mʋ fan tɔwɛ lɔŋɔ abaa ɔkpa tɔ pɔyɩ kɛ fan fʋʋ tʋtɔ. Nɩɩ ɩ man gyɛ kanɩn bɩrɛ, ee biti ɔ taa fʋ naa sa asɩn ogyipu kɛ o bun fʋ kʋpwɛ, kɛ ɔ taa fʋ naa sa obu otiipu, kɛ mɔɔ mʋ ɔ taa fʋ naa tii obu. ");
INSERT INTO naw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N tɔwɛ fʋ fɛɛ fii biti fu sii obu maŋa tɔ, naa fʋʋ saŋa mʋ nɩɩ fii biti fʋ ka kʋkɔ mʋ kpini‐kpini.” ");
INSERT INTO naw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kanɩn saŋa maŋa tɔ asa akʋ ba ba tɔwɛ Yesu yɛ Galile abi akʋ ba taa atɔbwaaya ba bɛɛ lɛɛ saraga bɛɛ sa kabwaarɛ‐sunkpa ayɛ mʋ tɔ. Nɩɩ Paleti yɛgɛ nɩɩ ba mɔɔ bamʋ, nɩɩ bamʋ nkalan ɩ bʋga yɛ atɔbwaaya nkalan maa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu lɛɛ kɔnɔ yɛ, “Fan nyi fɛɛ kanɩn Galile abi maŋa awʋrʋfɔ mʋ nɩɩ ba gyii mʋ, ɩ kaapʋ nɩɩ fɛɛ ba gyɛ alibi awaapʋ ba kyɔ Galile abi kpini? ");
INSERT INTO naw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ayee! N tɔwɛ fanɛ yɛ nɩɩ fan man kan lɛɛ fanɛ n‐yɩɩ lɩɩ alibi tɔ bɩrɛ, fanɛ gbaa fanɛ fen biti fan wu fɛɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Abɛɛ asa kudu aburuwa mʋ nɩɩ Silon kɩbansʋrʋ kyɩna tɩyɛ bamʋ sʋ nɩɩ ba wu mʋ, ɩɩ kaapʋ fɛɛ bamʋ ɩ kyɩna waa alibi ba kyɔ asa mʋ nɩɩ ba bʋ Gyerusalem kpini saŋa maŋa? ");
INSERT INTO naw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ayee! N tɔwɛ fanɛ yɛ nɩɩ fan man kan lɛɛ fanɛ n‐yɩɩ lɩɩ alibi tɔ bɩrɛ, fanɛ gbaa fanɛ kpini fen biti fan wu fɛɛ bamʋ.” ");
INSERT INTO naw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tʋtɔ nɩɩ ɔ bɔ bamʋ kɩŋasan nɩmʋ yɛ, “Ɔnyɩn kʋ ɩ kyɩna duu figi oyu mʋ kʋdɔɔ tɔ, nɩɩ o kpee ɔ naa biti kɩmʋ abi amaa ɔ man nyɛ. ");
INSERT INTO naw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nɩɩ ɔ tɔwɛ ɔnyɩn mʋ nɩɩ ɛɛ kɩɩ kʋdɔɔ mʋ sʋ yɛ, ‘Ɩ waa fɛɛ nsu nsa ndee n maa ba n ba biti abi oyu nɩmʋ sʋ yɛgɛ n mɛɛ nyɛ. Ŋɛ kɩmʋ tʋʋ! Mɩnɛ nɩɩ kɩ yɩlɛ kɩ waa kasɛ nɩmʋ sʋ?’ ");
INSERT INTO naw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nɩɩ ɔnyɩn mʋ lɛɛ kɔnɔ yɛ, ‘Ɔnyɩrɩpɛ yɛgɛ kɩmʋ kɛ kɩ yɩlɛ kesu kʋlʋn tii sʋ. N biti n kuu kyaabɔɔ kɩmʋ kɛ n waa kɩmʋ atɔbwaaya ibini.’ ");
INSERT INTO naw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nɩɩ kɩ kan sɔyɩ abi kesu kakʋ mʋ, ɩ bʋrɔn, nɩɩ kɩ kan kɩ man sɔyɩ bɩrɛ kɛ fʋ ŋɛ kɩmʋ tʋʋ.” ");
INSERT INTO naw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kakɛ fʋʋtɛsa akɛ kʋ Yesu ɩ kaapʋ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa kʋ. ");
INSERT INTO naw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nɩɩ ɔkyɩɩ mʋ nɩɩ kabwɩɩ libi ki biliŋaa mʋ waa boobi nsu kudu aburuwa mʋ bʋ tʋtɔ. Kabwɩɩ libi mʋ bɩɩtɛ mʋ muŋa nɩɩ ɔ mɛɛ taalɛ tɛɛŋɛ tɔ kpini‐kpini. ");
INSERT INTO naw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu maa wu mʋ mʋ, ɔ tɩɩ mʋ ba ansi tɔ nɩɩ ɔ tɔwɛ mʋ yɛ, “Ɔkyɩɩ, fʋ nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nɩɩ ɔ taa mʋ abaa gyaga mʋ sʋ, nɩɩ opula maŋa tɔ ɔkyɩɩ mʋ kyiigi tɔ, nɩɩ ɔ yɩn Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lɩɩ kanan mʋ nɩɩ Yesu kyɛ ɔlɔpʋ kakɛ fʋʋtɛsa akɛ mʋ sʋ mʋ, Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa ɔbɩlɩsa mʋ nyɛ agbʋ nɩɩ ɔ tɔwɛ asa mʋ yɛ, “Nkɛ nsiye ɩ gyɛ kusun nkɛ, ɩmʋ sʋ fan ba kanɩn nkɛ maŋa tɔ kɛ ba kyɛ fanɛ alɔ, man gyɛ kakɛ fʋʋtɛsa akɛ.” ");
INSERT INTO naw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nɩɩ Ɔnyɩrɩpɛ Yesu lɛɛ mʋ kɔnɔ yɛ, “Fanɛ kebunbun ansi wuya ana! Fanɛ anɩmʋ ɩ mɛɛ saaŋɛ mʋ naatɛ‐nyɩnsa abɛɛ mu kuruma kakɛ fʋʋtɛsa akɛ, nɩɩ ɔ mɛɛ sʋ mʋ ee kpee ɛɛ sa mʋ nkyu? ");
INSERT INTO naw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ɔkyɩɩ nɩmʋ gyɛ Abraham kanaana‐bii mʋ nɩɩ Sɩtaanɛ ŋmina mʋ nsu kudu aburuwa. Mɩnɛ waa nɩɩ ɩ man dagaa maa nyɛ kamɔlɩgɛ kakɛ fʋʋtɛsa akɛ lɩɩ kʋtɔ mʋ nɩɩ ki nyita mʋ sʋ?” ");
INSERT INTO naw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Maa tɔwɛ falɛ lʋwɛ mʋ, nɩɩ ipeeli ɩ kɩtaa mʋ akisipu kpini. Amaa asa mʋ bɩrɛ ansi i gyii lɩɩ adangana damantɛ mʋ nɩɩ ɔ waa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nɩɩ Yesu taasɛ yɛ, “Nɛnɛ nɩɩ Ɩbwaarɛ kuwura‐gyii mʋ ki du? Mɩnɛ nɩɩ n biti n taa kɩmʋ kaala? ");
INSERT INTO naw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ki du nɩn fɛɛ gowa kibi mʋ nɩɩ ɔdɔɔpʋ taa du mʋ kʋdɔɔ tɔ nɩɩ kɩ dan biliŋi oyu, nɩɩ nbwiibi bɛɛ ba bɛɛ kyɩna kɩmʋ n‐yaabi sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nɩɩ ɔ bɩlaa bwii taasɛ yɛ, “Mɩnɛ nɩɩ n biti n taa Ɩbwaarɛ kuwura‐gyii mʋ kaala? ");
INSERT INTO naw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ki du nɩn fɛɛ kɩfɛ tinsa mʋ nɩɩ ɔkyɩɩ taa bʋga kyagɩlɛ bodobodo nnyifo damantɛ tɔ, kɛ kɩfɛ tinsa mʋ ɩɩ yɛgɛ nnyifo maŋa kpini i tin.” ");
INSERT INTO naw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nɩɩ Yesu maa kpee Gyerusalem mʋ, ɔ bɔla ndɛ yɛ ndɛ‐bii mʋ sʋ ɛɛ kaapʋ abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nɩɩ ɔkʋ taasɛ mʋ yɛ, “Ɔnyɩrɩpɛ, amɔɔ asa gbɛrɛɛ ii biti ba ba nyɛ kamɔlɩgɛ?” Nɩɩ ɔ tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Fan kpan fanɛ n‐yɩɩ kenken kɛ fan bɔla kebunɔ‐bii mʋ tɔ loo to. N tɔwɛ fanɛ yɛ asa gaalaagaa bee biti ba kpan bamʋ n‐yɩɩ, amaa ba mɛɛ yɛ ba taalɛ. ");
INSERT INTO naw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nɩɩ kɩkpaara wuya kan kʋsʋ tii kebunɔ mʋ, fen biti fan ba yɩlɛ kewusunɔ fen daa ɔpʋnʋ yɛgɛ fɛn kʋlɛ yɛ, ‘Ɔnyɩrɩpɛ tigi kebunɔ sa anɛ.’ “Amaa ee biti ɔ lɛɛ kɔnɔ yɛ, ‘N man nyi fanɛ, n man nyi katɩn mʋ nɩɩ fan lɩɩ.’ ");
INSERT INTO naw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Fen biti fan tɔwɛ yɛ, ‘Anaa fʋ ɩ bʋga gyii, nɩɩ an bʋga nuu, nɩɩ fʋ kaapʋ anɛ ndɛ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amaa ee biti ɔ tɔwɛ fanɛ yɛ, ‘N man nyi fanɛ abɛɛ katɩn mʋ nɩɩ fan lɩɩ. Fanɛ alibi awaapʋ kpini fan lɩɩ mɛ asɛ!’ ");
INSERT INTO naw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Saŋa mʋ nɩɩ fen biti fan wu Abraham maa Isaki yɛ Gyekobu yɛ Ɩbwaarɛ atɔwɛpʋ mʋ kpini, ba maa bʋ Ɩbwaarɛ kuwura‐gyii mʋ tɔ, nɩɩ fan man nyɛ ɔkpa loo to mʋ, tʋtɔ nɩɩ fen biti fan su kɛ fan wɛ fanɛ anyi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Asa bee biti ba lɩɩ kyɔwɛ kɩlɩɩ yɛ kyɔwɛ kɩtɩyɛ, kɛ akʋ ba lɩɩ adii yɛ akpɩlɩgɛ, kɛ ba ba kyɩna bamʋ ɩkyɩnakpa Ɩbwaarɛ kuwura‐gyii kensi‐gyii ngyaŋɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","N tɔwɛ fanɛ kesintin yɛ bamʋ nɩɩ ba bʋ kamaa mʋ akʋ, bee biti ba ba gyankpaa, nɩɩ bamʋ nɩɩ ba gyankpaa mʋ mɔɔ akʋ bee biti ba sii kamaa.” ");
INSERT INTO naw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Saŋa maŋa tɔ nɩɩ Farasii abi akʋ ba ba Yesu asɛ ba tɔwɛ mʋ yɛ, “Lɩɩ nfɩɩ kpee katɩn kʋ. Lɩɩ fɛɛ Owura Herodi ii biti fɛɛ ɔ mɔɔ fʋ.” ");
INSERT INTO naw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Fan kpee naa tɔwɛ kanɩn gboogboo mʋ yɛ, n biti n gya nbwɩɩ libi kɛ n kyɛ asa ndaga yɛ ɔkɛ kɛ kakɛ sasapʋ mʋ n lʋwɛ mɛ kusun.” ");
INSERT INTO naw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nɩɩ kanan kʋmaa sʋ mʋ, ɩ dagaa fɛɛ n maa kyaga mɛ ɔkpa sʋ n kpee ndaga yɛ ɔkɛ yɛ kakɛ sasapʋ. Ɩ waa nɛnɛ, Gyerusalem ɩ gyɛ kadɛ mʋ nɩɩ bee biti ba mɔɔ Ɩbwaarɛ ɔtɔwɛpʋ. ");
INSERT INTO naw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Gyerusalem abi, Gyerusalem abi, fanɛ mʋ nɩɩ fan mɔɔ Ɩbwaarɛ atɔwɛpʋ, nɩɩ fan tʋʋ bamʋ nɩɩ Ɩbwaarɛ sun fanɛ asɛ mʋ abuu. N kpan mɛ n‐yɩɩ saŋa kʋmaa fɛɛ n kʋʋla fanɛ waa mɛ ɔtɔ tɔ fɛɛ kanan mʋ nɩɩ kakyaasɛ‐nyi maa bʋga mu‐bii ana mʋ atɛɛ tɔ mʋ. Amaa fan mɛɛ sa mɛ ɔkpa!” ");
INSERT INTO naw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kɩɩ, fanɛ kabwaarɛ‐sunkpa ayɛ kii biti ki sii kɩ dɛ kɩkpan sa fanɛ. N tɔwɛ fanɛ, fanɛ man bɩla yɛ fan wu mɛ kakɛ akʋ, naa fʋʋ saŋa mʋ nɩɩ fen biti fan tɔwɛ yɛ, “Kusee ɩ gyɛ sa ɔmʋnɩ ɔ ba Ɔnyɩrɩpɛ Ɩbwaarɛ kɩtɩɩ tɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ɩ baa fɛɛ kakɛ fʋʋtɛsa kʋ nɩɩ Yesu kpee Farasii abi ɔbɩlɩsa kʋ ayɛ ɔ naa gyii, yɛgɛ bɛɛ pɛɛtɛ mʋ fɛɛ ee biti o nyita Gyiwu abi nbara mʋ. ");
INSERT INTO naw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nɩɩ ɔnyɩn kʋ bʋ mu ansi tɔ tʋtɔ, ɛɛ lɔɔ kyankpan. ");
INSERT INTO naw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nɩɩ Yesu taasɛ nbara akaapʋpʋ anyipu mʋ ba maa Farasii abi mʋ yɛ, “Ɔkpa dɛ fɛɛ a kyɛ ɔkʋ kakɛ fʋʋtɛsa akɛ abɛɛ a man kyɛ?” ");
INSERT INTO naw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amaa ba man tɔwɛ sɛhn nɩɩ Yesu kɩtaa ɔnyɩn mʋ, kyɛ mʋ, nɩɩ ɔ yɛgɛ mʋ, nɩɩ ɔ natɛ. ");
INSERT INTO naw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nɩɩ ɔ taasɛ bamʋ yɛ, “Fɛɛ nɩɩ fanɛ ɔkʋ sʋ kebii abɛɛ naatɛ‐nyɩnsa nɩɩ ɔ tɩyɛ kitiribo tɔ kakɛ fʋʋtɛsa akɛ mʋ, fʋ mɛɛ yɛ fʋ lɛɛ mʋ?” ");
INSERT INTO naw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Amaa ba man taalɛ lɛɛ ɩmʋ kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu maa wu fɛɛ asa mʋ nɩɩ ba tɩɩ bamʋ ogyikpa mʋ bɛɛ ŋmaarɛ ɩkyɩnakpa kparɛ‐kparɛ mʋ, nɩɩ ɔ bɔ bamʋ kɩŋasan nɩmʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Fɛɛ nɩɩ ɔkʋ kan tɩɩ fʋ mʋ kɩkyɩɩfɔ tɔ mʋ, man naa kyɩna ɔkyɩnakpa kparɛ, akʋtɔ fɛɛ ɔ tɩɩ ɔsa kparɛ mʋ nɩɩ ɔ bɩla ɔ kyɔ fʋ. ");
INSERT INTO naw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kɛ ɔmʋ nɩɩ ɔ tɩɩ faa mʋ mʋ, ɔ ba tɔwɛ fʋ yɛ, ‘Taa fʋ kagya sa ɔnyɩn nɩmʋ.’ Tʋtɔ nɩɩ fii biti fʋ taa ipeeli naa kyɩna katɩn mʋ nɩɩ ɩ man sʋ bɛɛrɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amaa nɩɩ ɔkʋ kan tɩɩ fʋ mʋ, naa kyɩna katɩn mʋ nɩɩ kɩ man sʋ bɛɛrɛɛ, kɛ ɔ ba tɔwɛ fʋ yɛ, ‘Kyɛmɩnɛ, ba kyɩna kagya kparɛ sʋ nfɩɩ.’ Saŋa mʋ, fɩɩ nyɛ bɛɛrɛɛ lɩɩ fʋ tɔɔmaa ana mʋ nɩɩ ɔ da kɩbaa tɩɩ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɔ kʋsaa mʋ n‐yɩɩ sʋsʋ mʋ, Ɩbwaarɛ ii biti ɔ bɩya mʋ kasɛ, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ bɩya mʋ n‐yɩɩ kasɛ mʋ, Ɩbwaarɛ ii biti ɔ kʋsaa mʋ sʋsʋ.” ");
INSERT INTO naw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tʋtɔ nɩɩ Yesu tɔwɛ ɔmʋ nɩɩ ɔ tɩɩ mʋ mʋ, mɔɔ yɛ, “Nɩɩ fʋ kan tɩɩ asa yɛ ba be gyii kakyʋwapɛ abɛɛ kalaatɩpwɛ agyitɔ mʋ, man kan waa fʋ tɩɩ fʋ kyɛmɩnɛ ana abɛɛ fʋ‐daa abɛɛ fʋ kʋʋpʋ ana abɛɛ afulee wuya ana mʋ nɩɩ ba tɛ tiri fʋ mʋ. Nɩɩ fʋ kan waa kanɩn mʋ, akʋtɔ fɛɛ bee biti ba tɩɩ fʋ gbaa fʋ ba bamʋ lɛɛ tɔ kɛ ɩ ka fʋ kʋkɔ. ");
INSERT INTO naw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amaa nɩɩ fʋ kan dɩŋa kensi‐gyii agyitɔ mʋ, tɩɩ atiripu yɛ aboobi yɛ amʋgʋlɛ‐mʋgʋlɛ yɛ agyaatanapʋ, ");
INSERT INTO naw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","kɛ fʋ nyɛ kusee, lɩɩ fɛɛ bamʋ ɩ mɛɛ taalɛ ka fʋ kʋkɔ. Nɩɩ Ɩbwaarɛ ii biti ɔ ka fʋ kʋkɔ saŋa mʋ nɩɩ akyɩrɛkyɩrɛpʋ bee biti ba kʋsʋ lɩɩ lewu tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nɩɩ bamʋ nɩɩ maa bamʋ ba tɛ bee gyii mʋ ɔkʋ maa nu asɩn mʋ, nɩɩ ɔ tɔwɛ Yesu yɛ, “Kusee ɩ gyɛ nyɩmɩsa mʋ nɩɩ ee biti o gyii Ɩbwaarɛ kuwura‐gyii mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nɩɩ Yesu lɛɛ mʋ kɔnɔ yɛ, “Ɔnyɩn kʋ ɩ dɩŋa kensi‐gyii agyitɔ nɩɩ ɔ tɩɩ asa damantɛ yɛ ba be gyii. ");
INSERT INTO naw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Saŋa mʋ maa fʋʋ fɛɛ ba be gyii mʋ, nɩɩ o sun mʋ kɩyaafɔlɛ yɛ ɔ naa tɔwɛ asa mʋ nɩɩ ɔ tɩɩ bamʋ mʋ yɛ, ba waa kʋtɔ kʋmaa lʋwɛ, ɩmʋ sʋ ba ba. ");
INSERT INTO naw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Nɩɩ bamʋ kpini ba piili bɛɛ tɔwɛ asɩn bɛɛ lɛɛ bamʋ n‐yɩɩ. Ɔgyankpaapʋ mʋ yɛ, ‘N dan sɔɔ kasɛ nɩn, nɩɩ ɩ daaga fɛɛ n naa kɩɩ kɩmʋ, ɩmʋ sʋ n kʋlɛ fʋ nɩn n mɛɛ yɛ n taalɛ ba.’ ");
INSERT INTO naw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Nɩɩ ɔkʋ mɔɔ yɛ, ‘N dan sɔɔ ɩnaatɛ‐nyɩnsa kudu nɩn, nɩɩ n dan kpee n naa taa bamʋ dɔɔ kɩɩ, ɩmʋ sʋ n mɛɛ yɛ n taalɛ ba.’ ");
INSERT INTO naw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Nɩɩ ɔkʋ mɔɔ bɩla yɛ, ‘N dan kili ɔkyɩɩ nɩn, n mɛɛ yɛ n taalɛ ba.’ ");
INSERT INTO naw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Nɩɩ kɩyaafɔlɛ mʋ taa asɩn mʋ ba tɔwɛ mʋ‐nyɩrɩpɛ. Nɩɩ kɩkpaara wuya mʋ nyɛ agbʋ, nɩɩ ɔ sa mʋ kɩyaafɔlɛ mʋ kɔnɔ yɛ, ‘Bilen, kpee kadɛ mʋ tɔ agbenbi sʋ yɛ ɩkpa‐bi naa bɩya atiripu yɛ aboobi yɛ agyaatanapʋ yɛ amʋgʋlɛ‐mʋgʋlɛ wuya ana.’ ");
INSERT INTO naw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ɩ man kyɛɛrɛɛ nɩɩ kɩyaafɔlɛ mʋ ba tɔwɛ mʋ yɛ, ‘Ɔnyɩrɩpɛ n waa fɛɛ kanan mʋ nɩɩ fʋ sa kɔnɔ mʋ, amaa ɩkyɩnakpa san ɩ bʋ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Nɩɩ ɔnyɩrɩpɛ mʋ bwii tɔwɛ mʋ kɩyaafɔlɛ yɛ, ‘Kpe ɩkpa mʋ nɩɩ ii kpee ndɛ sʋ, yɛ ndɔɔ ana tɔ, kɛ fʋ yɛgɛ ba ba kɛ mɛ kɩkpaara kɩ bɔla. ");
INSERT INTO naw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N tɔwɛ fanɛ fɛɛ, asa mʋ nɩɩ n tɩɩ bamʋ Sososi mʋ ɔkʋ mɛɛ yɛ ɔ daa mɛ kensi‐gyii agyitɔ mʋ kɩɩ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesu maa kʋbʋ damantɛ kʋkʋ ba maa naa mʋ, nɩɩ o biliŋi tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nɩɩ ɔkʋ kan ɛɛ ba mɛ asɛ, nɩɩ o mee biti mɛ ɔ kyɔ mʋ‐sɛ yɛ mu‐nyi, mʋ‐ka yɛ mu‐bii ana, mʋ‐daa ana yɛ mu‐supu ana, apɩɩkyɩɩ yɛ apɩɩnyɩn, halɩɩ mʋ gbaa‐gbaa mʋ nkpa dee, ɔ mɛɛ taalɛ waa mɛ obuupu. ");
INSERT INTO naw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ mɛɛ sʋla mu oyu laasa, kɛ o buu mɛ mʋ, ɔ mɛɛ taalɛ waa mɛ obuupu. ");
INSERT INTO naw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Fɛɛ nɩɩ fanɛ ɔkʋ ii biti ɔ pɔyɩ kɩkpaara lala mʋ, nɛnɛ nɩɩ ɛɛ waa? Pɔyɩ kɛ o piili mʋ ɔ mɛɛ gyankpaa kɩɩ mu afulee mʋ nɩɩ ee biti ɔ taa pɔyɩ, kɛ o wu fɛɛ mu afulee mʋ ii biti ɩ fʋʋ kɩpɔyɩ mʋ abɛɛ ɩ mɛɛ yɛ ɩ fʋʋ? ");
INSERT INTO naw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nɩɩ akʋtɔ ee piili ɔpɔrɛ gyankpaasa, nɩɩ ɔ man taalɛ lʋwɛ mʋ, ɔkʋmaa mʋ nɩɩ o wu kɩmʋ mʋ, ee biti ɔ ŋmasɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Odunwura nɩmʋ piili kɩkpaara kɩpɔyɩ amaa ɔ man taalɛ pɔyɩ lʋwɛ.’ ");
INSERT INTO naw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Abɛɛ owura mɔɔ, nɩɩ maa owura kʋ bee biti ba ba kɔ, nɩɩ ɔ mɛɛ kyɩna kɩɩ tɔ yɛ ɛ taalɛ taa mʋ anaakɔpʋ ngbɩn kudu naa gyaŋa owura banban mʋ maa mʋ anaakɔpʋ ngbɩn adʋnyɔ? ");
INSERT INTO naw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nɩɩ ɔ mɛɛ taalɛ kɔ yɛ mʋ mʋ, ee biti ɔ lɛɛ asa sun ɔbanban mʋ asɛ saŋa mʋ nɩɩ ɔ san ɔ bʋ kata‐kata, kɛ ɔ taasɛ kanan mʋ nɩɩ ba waa kɛ keyuula kɩ ba bamʋ nsana. ");
INSERT INTO naw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kanɩn ɔkpa kʋlʋn maŋa sʋ, ɔkʋmaa mʋ nɩɩ ɔ man yɛgɛ kʋtɔ kʋmaa mʋ nɩɩ ɔ sʋ mʋ, ɔ mɛɛ taalɛ waa mɛ obuupu. ");
INSERT INTO naw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nfɔlɛ ɩ bʋrɔn, amaa nɩɩ nfɔlɛ ɔkɔn kan lʋwɛ mʋ, mɩnɛ kʋtɔ nɩɩ bee biti ba taalɛ taa waa kɛ ɩ bɩla ɩ waa ɔkɔn? ");
INSERT INTO naw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɩ man sʋ kyaarɛ sa kʋtɔ kʋ kɩlɔŋɔ, amɔɔ bɛɛ taa kyɛɛgɛ fɔyɩ. Ɔkʋmaa mʋ nɩɩ ɔ sʋ asʋ mʋ, o nu.” ");
INSERT INTO naw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kakaakʋ nɩɩ lenpoo akɔɔlɛpʋ yɛ alibi awaapʋ ba ba sarɛ bee nu Yesu asɛ. ");
INSERT INTO naw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nɩɩ Farasii abi yɛ nbara akaapʋpʋ bɛɛ kɔlɩtɛ yɛ, “Ɔnyɩn nɩmʋ ɩɩ kɔɔlɛ alibi awaapʋ halɩɩ maa bamʋ bee bʋga bee gyii.” ");
INSERT INTO naw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tʋtɔ nɩɩ Yesu bɔ bamʋ kɩŋasan kɩnɩmʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“A taa fɛɛ nɩɩ fanɛ tɔ ɔkʋ kan ɔ sʋ nbʋlʋpʋ kɩlɩfa kɛ bamʋ tɔ ɔkʋlʋn ɔ fɔyɩ. Nɩɩ ɔ mɛɛ yɛ ɔ yɛgɛ adɩkpanɔ yɛ akpanɔ mʋ afitiri tɔ, kɛ ɔ natɛ biti ɔmʋnɩ ɔ fɔyɩ mʋ naa fʋʋ saŋa mʋ nɩɩ ee biti o wu mʋ? ");
INSERT INTO naw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nɩɩ ɔ kan wu mʋ mʋ, ɩ yɛgɛ nɩɩ mu ansi i gyii, kɛ ɔ taa mʋ gyaga mʋ abaakpan sʋ, ");
INSERT INTO naw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","kɛ ɔ taa mʋ ba kewu. Kɛ ɔ tɩɩ mʋ kyɛmɩnɛ ana yɛ mʋ kɩkpaara sʋ abi sarɛ, kɛ ɔ tɔwɛ bamʋ yɛ, ‘Fan ba tii mɛ sʋ kɛ i gyii ansi, lɩɩ fɛɛ n wu mɛ kabʋlʋpʋ mʋ nɩɩ ɔ fɔyɩ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","N tɔwɛ fanɛ kesintin, ɔkpa kʋlʋn maŋa sʋ kensi‐gyii kii biti kɩ baa kɩ bʋ sʋsʋ, fɛɛ alibi ɔwaapʋ kʋlʋn maa kyɛɛgɛ mʋ nfɛɛrɛ ɩ kyɔ gaa fɛɛ asa adɩkpanɔ yɛ akpanɔ mʋ nɩɩ bɛɛ kɩɩ bamʋ n‐yɩɩ fɛɛ bamʋ ɩkpa i kyiigi nɩɩ ɩ man tiri fɛɛ ba kyɛɛgɛ bamʋ nfɛɛrɛ. ");
INSERT INTO naw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Abɛɛ a taa fɛɛ ɔkyɩɩ kʋ mʋ nɩɩ ɔ sʋ gbiti nderebi kudu nɩɩ ɩmʋ kʋkʋlʋn fɔyɩ. Nɩɩ o mee tuwa fɩtɩla kɛ ɔ fɔgɛ kɩkpaara kɩɩ biti kɩmʋ naa fʋʋ saŋa mʋ nɩɩ ee biti o wu kɩmʋ? ");
INSERT INTO naw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nɩɩ ɔ kan wu kɩmʋ mʋ, ɛɛ tɩɩ mʋ kyɛmɩnɛ ana yɛ mʋ kɩkpaara sʋ abi ba sarɛ tɔ, kɛ ɔ tɔwɛ bamʋ yɛ, ‘Fan ba tii mɛ sʋ kɛ i gyii ansi, lɩɩ fɛɛ n wu mɛ kederebi mʋ nɩɩ kɩ fɔyɩ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","N tɔwɛ fanɛ kesintin fɛɛ, ɔkpa kʋlʋn maŋa sʋ kensi‐gyii ii biti ɩ baa ɩ bʋ Ɩbwaarɛ nbɔɔ asɛ fɛɛ alibi ɔwaapʋ kʋlʋn maa kyɛɛgɛ mʋ nfɛɛrɛ.” ");
INSERT INTO naw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nɩɩ Yesu kyaga sʋ yɛ, “Ɔnyɩn kʋ kyɩna ɔ bʋ tɔ nɩɩ ɔ sʋ nbii‐nyɩnsa‐bii anyɔ. ");
INSERT INTO naw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nɩɩ kebii asɛ mʋ tɔwɛ mʋ‐sɛ yɛ, ‘Mɛ‐Sɛ, barɩgɛ fʋ kapatɩyɛ mʋ kpini tɔ kɛ fʋ taa mɛ lɛɛ sa mɛ.’ Ɩmʋ sʋ, mʋ‐sɛ barɩgɛ kapatɩyɛ mʋ tɔ ntun nyɔ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nkɛ gbɛrɛɛ kamaa tɔ mʋ, kebii asɛ fɛ mʋ kapatɩyɛ mʋ kpini, kʋʋla kʋsʋ loo to kpee ɔsʋwʋlɛ kʋ sʋ kata‐kata. Tʋtɔ nɩɩ ɔ naa gyii mu afulee mʋ kpini kʋsʋbɔ tɔ lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Saŋa mʋ nɩɩ o gyii mu afulee mʋ kpini lʋwɛ mʋ, nɩɩ akʋn damantɛ a tɩyɛ ɔsʋwʋlɛ maŋa sʋ kpini, nɩɩ kitiri fufuli kɩ kɩtaa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɩmʋ sʋ o kpee naa waa kusun sa kasɛ maŋa sʋ ɔdɛ‐bi kʋ mʋ nɩɩ ɔ taa mʋ fɛɛ ɔ kɩɩ mu akuuri sʋ. ");
INSERT INTO naw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ee biti agyitɔ mʋ nɩɩ akuuri bee gyii mʋ kigyii, amaa ɔ man nyɛ. ");
INSERT INTO naw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Saŋa mʋ nɩɩ mʋ nfɛɛrɛ ɩ ba mʋ tɔ mʋ, ɔ tɔwɛ sa mʋ n‐yɩɩ yɛ, ‘Mɛ‐Sɛ adɔɔpʋ mʋ kpini agyitɔ a gbigi bamʋ, yɛgɛ n bʋ nfɩɩ n biti n wu akʋn lewu. ");
INSERT INTO naw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","N biti n kʋsʋ bwii kpee nsɛ asɛ kɛ n naa tɔwɛ mʋ yɛ, Nsɛ, n waa Ɩbwaarɛ yɛ fʋ alibi. ");
INSERT INTO naw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ɩmʋ sʋ n man bɩla dagaa gbaa fɛɛ fʋ tɩɩ mɛ yɛ fu‐bii, taa mɛ waa fɛɛ fʋ adɔɔpʋ mʋ tɔ ɔkʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kanɩn sʋ ɔ kʋsʋ yii sʋ bwii ɛɛ ba mʋ‐sɛ asɛ. “Amaa saŋa mʋ nɩɩ ɔ dan san ɔ bʋ kata yɛ kewu mʋ, mʋ‐sɛ wu mʋ, nɩɩ o wu mʋ kʋwɛɛ. Nɩɩ ɔ sɩlɛ naa gyaŋa mu‐bii mʋ, nɩɩ o baari mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Nɩɩ kebii mʋ tɔwɛ mʋ‐sɛ yɛ, ‘Nsɛ n waa Ɩbwaarɛ yɛ fu alibi. Nɩɩ n man bɩla dagaa gbaa fɛɛ fʋ tɩɩ mɛ yɛ fu‐bii.’ ");
INSERT INTO naw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Amaa nɩɩ mʋ‐sɛ tɔwɛ mʋ ayaafɔlɛ yɛ, ‘Fan waa bilen! Fan taa kɩtaa kparɛ ba bun mʋ, fan lɛɛ kepini ba waa mʋ kɩbaa‐bi tɔ, kɛ fan waa mʋ asɩbɩta. ");
INSERT INTO naw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kɛ fan naa kɩtaa naatɛ bonbi‐nyɩnsa mʋ ba mɔɔ kɛ a gyii, kɛ a kyaa gyii anɛ ansi. ");
INSERT INTO naw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Lɩɩ fɛɛ mi kebii‐nyɩnsa‐bii nɩmʋ daa wu nɩn, nɩɩ o bwii kyiŋi, ɔ fɔyɩ nɩn, nɩɩ n bwii benti mʋ.’ Tʋtɔ nɩɩ ba piili bee gyii bamʋ ansi. ");
INSERT INTO naw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Saŋa maa tɔ mʋ yɛgɛ obii bɩlɩsa asɛ mʋ bʋ ndɔɔ tɔ. Maa lɩɩ ndɔɔ ɛɛ ba nɩɩ o be tiri kewu tɔ mʋ, o nu ɩlʋn yɛ kakyaa ɩ maa kpira mʋ‐sɛ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɩmʋ sʋ ɔ tɩɩ mʋ‐sɛ ayaafɔlɛ mʋ tɔ ɔkʋ, nɩɩ ɔ taasɛ mʋ kʋtɔ mʋ nɩɩ kɩɩ waa. ");
INSERT INTO naw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nɩɩ ɔ lɛɛ kɔnɔ yɛ, ‘Fu‐supu i bwii ba, nɩɩ fʋ‐sɛ mɔɔ mʋ naatɛ bonbi‐nyɩnsa mʋ. Lɩɩ fɛɛ fu‐supu bwii ba kewu yɛ kumu nkpa yɛ alanfɩya.’ ");
INSERT INTO naw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Tʋtɔ nɩɩ ɔdaa mʋ nyɛ agbʋ yɛ ɔ man bɩla yɛ o loo kɩkpaara sʋ. Kanɩn sʋ mʋ‐sɛ lɩɩ kpee naa tɔwɛ waa mʋ yɛ o loo ba. ");
INSERT INTO naw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amaa ɔ lɛɛ mʋ‐sɛ kɔnɔ yɛ, ‘Kɩɩ! Nsu ɩnɩmʋ kpini n maa sun fʋ fɛɛ kɩnyɛ. Nɩɩ n man kina fʋ kɔnɔ kunu. Mɩnɛ kʋtɔ nɩɩ fʋ pɩɩta sa mɛ? Fʋ man sa mɛ halɩɩ kabwɩɩ gbaa kɛ maa mɛ kyɛmɩnɛ ana a mɔɔ gyii anɛ ansi. ");
INSERT INTO naw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amaa fu kebii‐nyɩnsa nɩmʋ mʋ nɩɩ ɔ naa nyita fʋ kapatɩyɛ lɩɩ akyɩɩ gyaga sʋ, nɩɩ ɔ naa bwii ba kewu mʋ, fʋ mɔɔ naatɛ bonbi‐nyɩnsa sa mʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Nɩɩ ɔsɛ mʋ lɛɛ kɔnɔ yɛ, ‘Mi‐bii, fʋ bʋ mɛ asɛ nfɩɩ saŋa kʋmaa, nɩɩ kʋtɔ kʋmaa mʋ nɩɩ n sʋ mʋ gyɛ fʋ lɛɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ɩmʋ sʋ yɛgɛ ɩ waa anɛ ɔkɔn kɛ a kyaa gyii anɛ ansi, lɩɩ fɛɛ fu‐supu nɩmʋ daa wu nɩn, nɩɩ o bwii kyiŋi, ɔ fɔyɩ nɩn, nɩɩ n bwii benti mʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu tɔwɛ mʋ abɩɩlapʋ yɛ, “Atɔ wuya kʋ ɩ kyɩna ɔ bʋ tɔ nɩɩ ɔ sʋ ɔkɩɩsʋpʋ mʋ nɩɩ ɛɛ kɩɩ mʋ kapatɩyɛ sʋ. Nɩɩ atɔ wuya mʋ nu fɛɛ ɔkɩɩsʋpʋ mʋ ii nyita mʋ kapatɩyɛ. ");
INSERT INTO naw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ɩmʋ sʋ ɔ tɩɩ mʋ nɩɩ ɔ taasɛ mʋ yɛ, ‘Mɩnɛ asɩn nɩɩ n nu n lɩɩ fʋ sʋ falɛ? Taa mɛ kapatɩyɛ mʋ nɩɩ n taa waa fʋ kɩbaa tɔ mʋ kpini bɩya mɛ, kɛ fʋ karagɛ ɩmʋ kɔnɔ sa mɛ, lɩɩ fɛɛ fʋ man bɩla yɛ fʋ kɩɩ mɛ kapatɩyɛ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Nɩɩ ɔkɩɩsʋpʋ mʋ fɛ nfɛɛrɛ yɛ, ‘Nbɩɩnbɩɩ nɛnɛ nɩɩ n biti n waa? Mɛ‐nyɩrɩpɛ ɩɩ kɔɔlɛ mi kusun ɛɛ lɩɩ mɛ asɛ, nɩɩ n man bʋlʋn kɛ n waa kasɛ kukuu kusun, nɩɩ ɩ sʋ mɛ ipeeli yɛ n naa kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","N nyi kanan mʋ nɩɩ n biti n waa nɩɩ kusun mʋ kɩ kan lɩɩ mɛ kɩbaa tɔ mʋ, asa bee biti ba kɔɔlɛ mɛ bamʋ akpaara sʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ɩmʋ sʋ ɔ tɩɩ mʋ‐nyɩrɩpɛ akɔ wuya ana nɩɩ ɔ taasɛ ɔgyankpaapʋ mʋ yɛ, ‘Mɛ‐nyɩrɩpɛ kʋkɔ afɩnɛ nɩɩ fʋ sʋ?’ ");
INSERT INTO naw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Nɩɩ ɔ lɛɛ kɔnɔ yɛ, ‘N sʋ kʋkɔ olifu nfɔ galɔn alɩfa aburuwa.’ “Nɩɩ ɔkɩɩsʋpʋ mʋ tɔwɛ mʋ yɛ, ‘Kɔɔlɛ fʋ ɔwʋlɛ, kɛ fʋ kyɩna bilen kɛ fʋ kyʋrɔɔ ana.’ ");
INSERT INTO naw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Nɩɩ ɔ taasɛ ɔnyɔsapʋ mʋ yɛ, ‘Afɩnɛ kʋkɔ nɩɩ fʋ sʋ?’ Nɩɩ ɔ lɛɛ kɔnɔ yɛ, ‘Akyembee ɩbɔɔta kagbɩn kʋlʋn.’ “Nɩɩ ɔ tɔwɛ mʋ yɛ, ‘Kɔɔlɛ fʋ ɔwʋlɛ kɛ fʋ kyʋrɔɔ aduburuwa.’ ");
INSERT INTO naw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Atɔ wuya mʋ ba yɩn ɔkɩɩsʋpʋ mʋ nɩɩ mu ansi ɩ tɩn fɛɛ maa sʋ kanyaasɩn. Lɩɩ fɛɛ kanɩn nɩɩ dulinyaa nɩmʋ tɔ asa ba sʋ kensi tɩn kɩkyɔ bɛɛ waa asa ɩ kyɔ kanan mʋ nɩɩ Ɩbwaarɛ asa ba sʋ bɛɛ waa asa mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nɩɩ Yesu kyaga sʋ tɔwɛ yɛ, “Fan taa fanɛ dulinyaa tɔ atɔ kyɛ asa tɔ biti akyɛmɩnɛ sa fanɛ n‐yɩɩ, nɩɩ ɩ kan ba fɛɛ atɔ mʋ saŋa ɩ kyʋn mʋ, Ɩbwaarɛ ii biti ɔ kɔɔlɛ fanɛ ba nkpa kakpaa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ɔmʋ nɩɩ ee gyii kesintin atɔ gbɛrɛɛ sʋ mʋ, ɔ bɩla ee gyii kesintin atɔ kɩkyɔ sʋ. Nɩɩ ɔmʋ nɩɩ o mee gyii kesintin atɔ gbɛrɛɛ sʋ mʋ, kanɩn maa nɩɩ ɔ mɛɛ yɛ o gyii kesintin atɔ kɩkyɔ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ɩmʋ sʋ nɩɩ fu mee gyii kesintin dulinyaa atɔ sʋ mʋ, anɩmʋ ii biti ɔ taa Ɩbwaarɛ kuwura‐gyii mʋ atɔ mʋ nɩɩ ɩ man sʋ ɔkaa mʋ waa fʋ abaa tɔ? ");
INSERT INTO naw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nɩɩ fʋ mee gyii kesintin ɔkʋ kapatɩyɛ sʋ mʋ, Ɩbwaarɛ mɛɛ yɛ sa fʋ mʋ atɔ mʋ nɩɩ ɔ da yɛ ɔ sa fʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kɩyaafɔlɛ kʋlʋn mɛɛ taalɛ sun anyɩrɩpɛ anyɔ. Nɩɩ ɩ kan ba kanɩn mʋ, ee biti o kisi ɔkʋ kɛ ɔ ba ee biti ɔkʋ, abɛɛ ee biti ɔ baa ee sun ɔkʋ kɛ o kina ɔkʋ. Fɛn mɛɛ taalɛ sun Ɩbwaarɛ yɛ afulee.” ");
INSERT INTO naw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farasii abi mʋ nɩɩ bee biti afulee gaa ba maa nu ɩnɩmʋ kpini mʋ, ba gbɛɛlɛɛ Yesu. ");
INSERT INTO naw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fanɛ banɩmʋ ɩ gyɛ asa mʋ nɩɩ fɛn waa fɛɛ fanɛ ɩkpa i kyiigi asa ansi tɔ, amaa Ɩbwaarɛ nyi kanan mʋ nɩɩ fanɛ nkɔlɔ tɔ i du. Lɩɩ fɛɛ kʋtɔ mʋ nɩɩ kɩ gyɛ kʋtɔ kparɛ asa ansi tɔ mʋ, kɩ gyɛ kʋtɔ kisisa sa Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ba tɔwɛ Ɩbwaarɛ Asɩnkyan yɩlasa mʋ nɩɩ ɩ gyɛ Mosesi nbara yɛ Ɩbwaarɛ atɔwɛpʋ mʋ kɩkaapʋ naa fʋʋ Gyɔn saŋa. Lɩɩ kanɩn saŋa maŋa ɩ sʋ ii kpee mʋ, ba tɔwɛ asɩn danbɩrasa lɩɩ Ɩbwaarɛ kuwura‐gyii mʋ sʋ, nɩɩ ɔkʋmaa nɩmʋ kpan mʋ n‐yɩɩ ee loo to. ");
INSERT INTO naw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ii biti ɩ baa ɩ bʋpɔɔ sa sʋsʋ yɛ kasɛ ɩ maa nyaa, ɩ kyɔ fɛɛ Ɩbwaarɛ nbara mʋ pii ɩ maa lɩɩ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ɔkʋmaa mʋ nɩɩ o kina mʋ‐ka nɩɩ ɔ naa kili ɔkyɩɩ kʋ mʋ, o nyita kekili, nɩɩ ɔnyɩn mʋ nɩɩ o kili ɔkyɩɩ mʋ nɩɩ mu‐kuli kina mʋ mʋ gbaa ɔ kɔɔlɛ ɔkʋ mʋ‐ka.” ");
INSERT INTO naw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nɩɩ Yesu kyaga sʋ tɔwɛ yɛ, “Afulee wuya kʋ ɩ kyɩna ɔ bʋ tɔ. Kakɛ kʋmaa ee bun atɔ bunsa danbɩrasa fɛɛ agoo maa kente, yɛgɛ ee gyii mʋ n‐yɩɩ kakɛ kʋmaa. ");
INSERT INTO naw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Odibapu kʋ gbaa kyɩna ɔ bʋ tɔ, nɩɩ bɛɛ tɩɩ mʋ yɛ Lasarusi mʋ nɩɩ mʋ n‐yɩɩ sʋ kpini, ɩ sʋ ɩlɔ. Nɩɩ kakɛ kʋmaa bɛɛ sʋla mʋ ba bɛɛ yɩla atɔ wuya nɩmʋ kebunɔ. ");
INSERT INTO naw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nɩɩ ee biti fɛɛ ɔ daa nyɛ agyitɔ mʋ nɩɩ ɩ lɩɩ atɔ wuya mʋ teeburi sʋ ɩ tɩyɛ kasɛ mʋ gbaa gyii. Halɩɩ igyoonɔ gbaa bɛɛ ba bee nyita mʋ ɩlɔ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Saŋa kʋ tɔ mʋ odibapu mʋ be wu, nɩɩ Ɩbwaarɛ nbɔɔ ba taa mʋ kpee Ɩbwaarɛ nyɩmɩsa Abraham asɛ sʋsʋ. Atɔ wuya mʋ gbaa be wu nɩɩ ba pula mʋ. ");
INSERT INTO naw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ɔ naa loo Sɩtaanɛ fʋlɔn tɔ yɛgɛ ɔ bʋ awʋrʋfɔ tɔ. O diyaa mu ansi mʋ, o wu Lasarusi maa tɛ Abraham asɛ kata‐kata. ");
INSERT INTO naw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɩmʋ sʋ, ɔ tɩɩ mʋ yɛ, ‘Ɔsɛ Abraham, wu mɛ kʋwɛɛ kɛ fʋ sun Lasarusi kɛ ɔ taa mʋ kɩbaa‐bi nyɔ nkyu tɔ, kɛ ɔ taa ba yuula mɛ kanandʋlʋ, lɩɩ fɛɛ n gyii awʋrʋfɔ fʋlɔn nɩmʋ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Amaa Abraham lɛɛ kɔnɔ yɛ. ‘Mi‐bii, nyiŋi fɛɛ saŋa mʋ nɩɩ fʋ kyɩna fʋ tɛ nkpa tɔ kasɛ sʋ mʋ fʋ nyɛ atɔ danbɩrasa nɩɩ Lasarusi mɔɔ nyɛ atɔ libi, amaa nbɩɩnbɩɩ mʋ ee gyii ɔkɔn yɛgɛ fɛɛ fii gyii awʋrʋfɔ. ");
INSERT INTO naw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɩnɩmʋ kpini kamaa mʋ, kɩkyɔbɔɔ lala kʋ kɩ dɛ ana fanɛ nsana, nɩɩ ɔkʋmaa mʋ nɩɩ ee biti ɔ lɩɩ nfɩɩ kpee fanɛ asɛ mʋ mɛɛ yɛ ɔ taalɛ, nɩɩ ɔkʋ mɛɛ taalɛ lɩɩ fanɛ asɛ ba anɛ asɛ nfɩɩ.’ ");
INSERT INTO naw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nɩɩ atɔ wuya mʋ lɛɛ kɔnɔ yɛ, ‘Kanɩn bɩrɛ mɛ‐sɛ n kʋlɛ fʋ nɩn, sun Lasarusi o bwii kpee mɛ‐sɛ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Lɩɩ fɛɛ, n sʋ mi‐supu ana anuu. Yɛgɛ ɔ naa da bamʋ amu tɔ kɛ ba man ba katɩn mʋ nɩɩ n bʋ n gyii awʋrʋfɔ falɛ.’ ");
INSERT INTO naw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham lɛɛ kɔnɔ yɛ, ‘Mosesi nbara yɛ Ɩbwaarɛ atɔwɛpʋ kɩkaapʋ mʋ ɩ bʋ bamʋ asɛ, bɛ taalɛ nu lɩɩ ɩmʋ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Nɩɩ ɔ tɔwɛ yɛ, ‘Ayee, mɛ‐sɛ Abraham, nɩɩ ɔkʋ kan lɩɩ lewu tɔ naa tɔwɛ bamʋ mʋ, bee biti ba yɛgɛ alibi kɩwaa.’ ");
INSERT INTO naw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Nɩɩ ɔ tɔwɛ mʋ yɛ, ‘Ba kan ba man nu Mosesi nbara yɛ Ɩbwaarɛ atɔwɛpʋ kɩkaapʋ mʋ, halɩɩ nɩɩ ɔkʋ kan kyiŋi lɩɩ lewu tɔ gbaa kpee bamʋ asɛ mʋ, ba mɛɛ yɛ ba kɔɔlɛ mʋ gyii.’ ” ");
INSERT INTO naw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ yɛ, “Ɩ waa nɛnɛ, atɔ mʋ nɩɩ ɩ yɛgɛ nɩɩ nyɩmɩsa ɩ waa alibi mʋ ii biti ɩ ba. Amaa ɔsa mʋ nɩɩ ii biti ɩ bɔla mʋ sʋ kɛ ɩ ba mʋ, mʋ laakʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Fɛɛ nɩɩ mʋ kʋsʋ bɩɩtɛ ɩ gyɛ yɛ, ba taa kubuu lala ŋmina mʋ ɔbʋlɛ tɔ naa tʋʋ ɔpʋ tɔ gbaa mʋ, ɩ bɔ sa mʋ fɛɛ ɩ maa bɔla mʋ sʋ nɩɩ nbii wuribi nɩmʋ ɔkʋ naa waa alibi. ");
INSERT INTO naw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ɩmʋ sʋ fan baa fan da fanɛ n‐yɩɩ sʋ. Nɩɩ fu‐supu kan waa fʋ alibi mʋ taasɛ mʋ, nɩɩ ɔ kan nu mʋ n‐yɩɩ kasɛ mʋ, kɛ fʋ taa mu alibi kɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nɩɩ ɔ kan waa fʋ alibi ɩlɩɩ isunɔ kakɛ kʋlʋn, nɩɩ ɔ kan nu mʋ n‐yɩɩ kasɛ ba tɔwɛ fʋ ɩlɩɩ isunɔ yɛ, ‘N man waa danbɩrasa mʋ,’ taa mu alibi kɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nɩɩ asunpu mʋ ba tɔwɛ Ɔnyɩrɩpɛ yɛ, “Tii anɛ kɩkɔɔlɛ‐gyii sʋ kɛ kɩ nyɛ akyɔ.” ");
INSERT INTO naw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nɩɩ Ɔnyɩrɩpɛ lɛɛ kɔnɔ yɛ, “Nɩɩ fan kan fan sʋ kɩkɔɔlɛ‐gyii pii fɛɛ gowa abi gbaa mʋ, fɛn taalɛ tɔwɛ oyu lala nɩmʋ yɛ, ‘Faa fu ilin kpini fii kyiigi naa yii ɔpʋ tɔ,’ kɛ i nu fanɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nɩɩ fɛɛ fanɛ ɔkʋ sʋ kɩyaafɔlɛ nɩɩ ɛɛ dɔɔ abɛɛ ɛɛ kɩɩ nbʋlʋpʋ sʋ mʋ, nɩɩ ɔ kan lɩɩ ndɔɔ tɔ ba mʋ, fɩɩ dan taalɛ tɔwɛ mʋ yɛ, ‘Waa bilen kɛ fʋ ba kyɩna gyii?’ ");
INSERT INTO naw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ayee! Fii biti fʋ tɔwɛ mʋ yɛ, ‘Dɩŋa mɛ kalaatɩpwɛ agyitɔ ba yii mɛ kɛ n gyii kɛ n nuu. N kan lʋwɛ mʋ, kɛ ngbaa fʋ, fʋ naa gyii kɛ fu nuu.’ ");
INSERT INTO naw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɩmʋ sʋ i tiri fɛɛ ɔ fwaala kɩyaafɔlɛ mʋ kʋtɔ mʋ nɩɩ ɔ tɔwɛ yɛ ɔ waa sa mʋ abɛɛ? ");
INSERT INTO naw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kanɩn maŋa nɩɩ fanɛ gbaa fanɛ, nɩɩ fan kan waa kʋtɔ kʋmaa mʋ nɩɩ Ɩbwaarɛ tɔwɛ fanɛ yɛ fan waa mʋ, fan tɔwɛ yɛ, ‘An gyɛ Ɩbwaarɛ ayaafɔlɛ mʋ nɩɩ a man sʋ kyaarɛ, an dan waa kʋtɔ mʋ nɩɩ ɩ dagaa a maa waa mʋ nɩn.’ ” ");
INSERT INTO naw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Saŋa mʋ nɩɩ Yesu ii kpee Gyerusalem mʋ, ɔ bɔla Samariya yɛ Galile ɩsʋwʋlɛ ngyaŋɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Maa kpee kadɛ‐bi kʋ sʋ mʋ, ɔ gyaŋa anyɩn kudu nɩɩ bɛɛ lɔ kibootoo. Nɩɩ anyɩn mʋ ba yɩlɛ kata, ");
INSERT INTO naw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nɩɩ ba kuusi kenken yɛ, “Ɔnyɩrɩpɛ Yesu, wu anɛ kʋwɛɛ.” ");
INSERT INTO naw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu maa wu bamʋ mʋ, nɩɩ ɔ tɔwɛ bamʋ yɛ “Fan taa fanɛ n‐yɩɩ naa kaapʋ aseepu.” Ba maa kpee mʋ nɩɩ ba nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bamʋ tɔ ɔkʋ, maa wu fɛɛ ɔ nyɛ alanfɩya mʋ, o bwii ba ee kuusi kenken ɛɛ yɩn Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nɩɩ o be muŋa Yesu ayaa tɔ, nɩɩ ɔ fwaala mʋ lɩɩ kʋtɔ mʋ nɩɩ ɔ waa sa mʋ mʋ sʋ. Nɩɩ kanɩn kanyɩn maŋa gyɛ Kasamariya‐nyɩn nɩn. ");
INSERT INTO naw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nɩɩ Yesu taasɛ yɛ, “Man gyɛ asa kudu ɩ nyɛ alanfɩya. Fɩnɛ nɩɩ asansa akpanɔ mʋ ba bʋ? ");
INSERT INTO naw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mɩnɛ sʋ nɩɩ kadɛndɛmandɛ nɩmʋ nkʋn ɩ taalɛ bwii ba fwaala Ɩbwaarɛ?” ");
INSERT INTO naw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nɩɩ ɔ tɔwɛ mʋ yɛ, “Kʋsʋ natɛ, fʋ kɩkɔɔlɛ‐gyii kɩ yɛgɛ nɩɩ fʋ nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Saŋa kʋ nɩɩ Farasii abi ba taasɛ Yesu yɛ, “Kakɛ mɔɔ nɩɩ Ɩbwaarɛ kuwura‐gyii mʋ kii biti kɩ ba?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɩbwaarɛ kuwura‐gyii mʋ fɛn mɛɛ yɛ fan taa fanɛ ansi wu kɩ maa ba. ");
INSERT INTO naw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nɩɩ ɔkʋ mɛɛ yɛ ɔ taalɛ tɔwɛ yɛ, ‘Kɩɩ kɩmʋ ndee’ abɛɛ ‘kɩ bʋ falɛ’. Lɩɩ fɛɛ Ɩbwaarɛ kuwura mʋ kɩ bʋ fanɛ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Saŋa kʋ ii biti ɔ ba, nɩɩ fen biti fɛɛ fan wu mɛ, Daadimaadi Obii‐nyɩnsa mʋ mɛ nkɛ mʋ kʋkʋ, amaa fan mɛɛ yɛ fen wu. ");
INSERT INTO naw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nɩɩ asa bee biti ba tɔwɛ fanɛ yɛ, ‘Mʋ ɩ bʋ falɛ mʋ’ abɛɛ ‘Mʋ ndee’. Amaa fan man waa fan buu bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","N tɔwɛ fanɛ ɩnɩmʋ lɩɩ fɛɛ, mɛ, Daadimaadi Obii‐nyɩnsa kibwii ba mʋ, ii biti ɩ baa i du nɩn fɛɛ bʋlayɩ maa gyii ɩsɛɛ ŋmaŋɛ sʋsʋ lɩɩ kɩbaafʋn nɩmʋ naa lɩɩ kɩbanban nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amaa ɩ dagaa fɛɛ n gyankpaa wu awʋrʋfɔ gaa, kɛ kɩnaana nɩmʋ tɔ abi ba kina mɛ. ");
INSERT INTO naw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Fɛɛ kanan mʋ nɩɩ ɩ waa anɛ naana Nowa saŋa mʋ, kanɩn nɩɩ ii biti ɩ waa mɛ, Daadimaadi Obii‐nyɩnsa kibwii ba saŋa mʋ gbaa. ");
INSERT INTO naw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Anɛ naana Nowa saŋa mʋ, asa ba kyɩna bee gyii yɛgɛ bee nuu, bee kili naa fʋʋ kakɛ mʋ nɩɩ anɛ naana Nowa loo ɔkʋlɩ mʋ tɔ. Nɩɩ nkyu ɩ ba muuri bamʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Kanɩn nɩɩ ɩ waa Loti saŋa mʋ, asa ba kyɩna bee gyii yɛgɛ bee nuu, bɛɛ fɛ yɛgɛ bɛɛ sɔɔ, bee duu yɛgɛ bɛɛ pɔyɩ. ");
INSERT INTO naw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amaa kakɛ mʋ nɩɩ Loti lɩɩ Sodom kadɛ tɔ mʋ, nɩɩ fʋlɔn yɛ kuduri lɩɩ sʋsʋ ba dɩyɛ bamʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Kanɩn nɩɩ ii biti ɩ waa kakɛ mʋ nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n biti n lɛɛ mɛ n‐yɩɩ kaapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kanɩn kakɛ maa nɩɩ ɔkʋ kan ɔ bʋ kewusunɔ mʋ, nɩɩ mʋ atɔ a bʋ kɩkpaara mʋ sʋ mʋ, ɔ man bɩla kpee kɩkpaara sʋ naa taa atɔ. Kanɩn ɩ gyɛ sa ɔmʋ nɩɩ ɔ bʋ ndɔɔ tɔ mʋ, ɔ man bɩla bwii kpee kewu kɛ ɔ naa taa kʋtɔ kʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Fan nyiŋi Loti mʋ‐ka. ");
INSERT INTO naw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɔkʋmaa mʋ nɩɩ ee biti fɛɛ ɔ mɔlɩgɛ mʋ gbaa‐gbaa mʋ nkpa mʋ, ii biti ɩ lɩɩ mʋ abaa tɔ. Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ taa mʋ nkpa sa lɩɩ mɛ sʋ mʋ, ee biti ɔ nyɛ kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kanɩn kagyanbwɛ maŋa mʋ, asa anyɔ bee biti ba baa ba dɛ kalan kʋlʋn sʋ, kɛ Ɩbwaarɛ ɔ taa ɔkʋ yɛgɛ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akyɩɩ anyɔ bee biti ba baa bɛɛ kɔyɩ atɔ, kɛ Ɩbwaarɛ ɔ taa ɔkʋ yɛgɛ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Anyɩn anyɔ bee biti ba baa bee sun kusun ndɔɔ tɔ, kɛ Ɩbwaarɛ ɔ ba taa ɔkʋ yɛgɛ ɔkʋ.” ");
INSERT INTO naw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nɩɩ abɩɩlapʋ mʋ ba taasɛ Ɔnyɩrɩpɛ Yesu yɛ, “Fɩnɛ nɩɩ ii biti ɩ waa.” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Katɩn kʋmaa mʋ nɩɩ belenbuni bʋ mʋ, tʋtɔ nɩɩ agyinbwii gbaa ba ba gyaŋɛ.” ");
INSERT INTO naw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nɩɩ Yesu bɔ mʋ abɩɩlapʋ kɩŋasan mʋ nɩɩ kɩɩ kaapʋ bamʋ fɛɛ, ba ba bɛɛ kʋlɛ kabwaarɛ kʋlɛ saŋa kʋmaa, kɛ ba man yɛgɛ bamʋ n‐yɩɩ nnyɔ bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Asɩn ogyipu kʋ ɩ bʋ kadɛ kʋkʋ sʋ, nɩɩ ɔ man sɩlɛ Ɩbwaarɛ nɩɩ ɔ man taa nyɩmɩsa tɩɩ sɛhn. ");
INSERT INTO naw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nɩɩ okulapu‐kyɩɩ kʋ gbaa bʋ kadɛ maŋa tɔ, ɔ maa sʋ ɛɛ ba asɩn ogyipu mʋ asɛ ɛɛ kʋlɛ mʋ yɛ, ‘Kyɛ mɛ tɔ kɛ n gyii biri mɛ dʋn ana.’ ");
INSERT INTO naw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ɩ kyɛɛrɛɛ gaa nɩɩ ɔ mɛɛ waa sɛhn ɛɛ sa mʋ. Amaa kamaa tɔ mʋ, asɩn ogyipu mʋ tɔwɛ waa mʋ n‐yɩɩ yɛ, ‘Ɩ gyɛ kesintin fɛɛ man sɩlɛ Ɩbwaarɛ nɩɩ man taa nyɩmɩsa tɩɩ sɛhn. ");
INSERT INTO naw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Amaa lɩɩ kitintin mʋ nɩɩ okulapu‐kyɩɩ nɩmʋ i tintin mɛ falɛ sʋ mʋ, n biti n kɩɩ kɛ n taa mu kesintin sa mʋ. Man gyɛ kanɩn mʋ kɩba mʋ nɩɩ ɛɛ ba nfɩɩ falɛ, ii biti ɩ kan sa mɛ kʋlɔ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nɩɩ Ɔnyɩrɩpɛ Yesu tɔwɛ yɛ, “Fan nu kʋtɔ mʋ nɩɩ asɩn ogyipu mʋ nɩɩ o mee gyii kesintin mʋ gbaa tɔwɛ? ");
INSERT INTO naw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nɩɩ ɩ gyɛ kanɩn bɩrɛ mʋ, mɩnɛ ɩ waa nɩɩ Ɩbwaarɛ mɛɛ yɛ o gyii kesintin sa bamʋ nɩɩ ba gyɛ mʋ lɛɛ mʋ, nɩɩ bee su bɛɛ tɩɩ mʋ kakyʋwapɛ yɛ kagyanbwɛ? Abɛɛ ee biti ɔ kyaga sʋ ee kina? ");
INSERT INTO naw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","N tɔwɛ fanɛ kesintin yɛ, Ɩbwaarɛ ii biti ɔ kɩɩ sʋ bilen‐bilen fɛɛ ɔ taa bamʋ kesintin sa bamʋ. Amaa saŋa mʋ nɩɩ mɛ, Daadimaadi Obii‐nyɩnsa n kan ba mʋ, n biti n nyɛ bamʋ nɩɩ ba kɔɔlɛ mɛ gyii kasɛ sʋ?” ");
INSERT INTO naw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nɩɩ Yesu bɩla bɔ kɩŋasan nɩmʋ sa asa mʋ nɩɩ bɛɛ kɩɩ fɛɛ bamʋ ɩkpa i kyiigi, yɛgɛ bɛɛ kɩɩ ɔkʋmaa nɩmʋ kɩyan. Ɔ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Asa anyɔ akʋ ba kpee kabwaarɛ‐sunkpa ayɛ ba naa kʋlɛ Ɩbwaarɛ. Bamʋ tɔ ɔkʋ gyɛ Kafarasii nɩn, nɩɩ ɔkʋ mɔɔ gyɛ lenpoo ɔkɔɔlɛpʋ. ");
INSERT INTO naw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nɩɩ Kafarasii‐nyɩn mʋ yɩlɛ mʋ kʋkwɩɩ kʋlɛ Ɩbwaarɛ ɛɛ yɩn mʋ n‐yɩɩ yɛ, ‘Ɩbwaarɛ, n fwaala fʋ gaa fɛɛ maa n man du fɛɛ asa mʋ nɩɩ ba san mʋ, n mee yuuri, abɛɛ n mee puni asa abɛɛ n man gyɛ ɔsa mʋ nɩɩ n nyita kekili abɛɛ n man du fɛɛ lenpoo ɔkɔɔlɛpʋ mʋ nɩɩ ɔ yɩlɛ nfɩɩ falɛ. ");
INSERT INTO naw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","N ŋmina kɔnɔ nkɛ nnyɔ, nkɛ nsunɔ kʋmaa tɔ, nɩɩ n barɩgɛ mɛ atɔ tɔ ntun kudu, nɩɩ n taa ketun kʋlʋn n sa fʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Amaa lenpoo ɔkɔɔlɛpʋ mʋ bɩrɛ yɩlɛ kata yɛ mʋ. Nɩɩ ɔ man diyaa mu ansi kɩɩ sʋsʋ, amaa ɔ taa mʋ kɩbaa gyaga mʋ kɔkɔlɔ sʋ tɔwɛ yɛ, ‘Ɩbwaarɛ, alibi ɔwaapʋ ɩ gyɛ mɛ, wu mɛ kʋwɛɛ.’ ");
INSERT INTO naw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ba bwii kpewu. Amaa n tɔwɛ fanɛ kesintin fɛɛ, lenpoo ɔkɔɔlɛpʋ mʋ i gyii asʋ Ɩbwaarɛ asɛ, man gyɛ Kafarasii‐nyɩn mʋ. Ɩmʋ sʋ fanɛ ɔkʋmaa mʋ nɩɩ ɔ kʋsaa mʋ n‐yɩɩ sʋsʋ mʋ, Ɩbwaarɛ ɩ bɩya mʋ kasɛ, nɩɩ fanɛ ɔkʋmaa mʋ nɩɩ ɔ bɩya mʋ n‐yɩɩ kasɛ mʋ, Ɩbwaarɛ ɩ kʋsaa mʋ sʋsʋ.” ");
INSERT INTO naw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tʋtɔ nɩɩ asa akʋ gbaa ba sʋ bamʋ nbii wuribi bɛɛ ba Yesu asɛ, kɛ ɔ taa mʋ abaa gyaga bamʋ sʋ. Mʋ abɩɩlapʋ mʋ ba maa wu kanɩn mʋ, ba gya bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amaa Yesu tɩɩ nbii mʋ ba mʋ asɛ nɩɩ ɔ tɔwɛ yɛ, “Fan yɛgɛ nbii mʋ ba ba mɛ asɛ, kɛ fan man tii bamʋ ɔkpa. Lɩɩ fɛɛ banɩmʋ falɛ daa kudubi nɩɩ Ɩbwaarɛ kuwura‐gyii mʋ gyɛ bamʋ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","N tɔwɛ fanɛ kesintin yɛ, ɔkʋmaa mʋ nɩɩ ɔ mɛɛ yɛ ɔ kɔɔlɛ Ɩbwaarɛ kuwura‐gyii fɛɛ kebii mʋ, ɔ mɛɛ yɛ o loo kɩmʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nɩɩ Gyiwu abi ɔgyankpaapʋ kʋ taasɛ Yesu yɛ, “Ɔkaapʋpʋ danbɩrasa, mɩnɛ nɩɩ n biti n waa kɛ n nyɛ nkpa kakpaa?” ");
INSERT INTO naw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nɩɩ Yesu taasɛ mʋ yɛ, “Mɩnɛ sʋ nɩɩ fɩɩ tɩɩ mɛ yɛ ɔdanbɩrasa? Ɔkʋ man gyɛ ɔdanbɩrasa, amɔɔ Ɩbwaarɛ nkʋn. ");
INSERT INTO naw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Fu nyi Ɩbwaarɛ nbara asɩn mʋ nɩɩ kaapʋ yɛ, ‘Man nyita kekili, man mɔɔ nyɩmɩsa, man kan yuuri, man waa nyama yɩlɛpʋ antɩŋɛsa wuya, kɛ fʋ taa bɛɛrɛɛ sa fʋ‐sɛ yɛ fu‐nyi?’ ” ");
INSERT INTO naw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nɩɩ ɔnyɩn mʋ lɛɛ kɔnɔ yɛ, “N buu nbara ɩnɩmʋ kpini lɩɩ mi kibii tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu maa nu kanɩn mʋ, ɔ tɔwɛ mʋ yɛ, “Ɩ san fʋ kʋtɔ kʋlʋn. Naa fɛ kʋtɔ kʋmaa mʋ nɩɩ fʋ sʋ kɛ fʋ taa afulee mʋ sa atiripu, ii biti ɩ yɛgɛ fu biliŋi atɔ wuya sʋsʋ. Kɛ fʋ ba buu mɛ.” ");
INSERT INTO naw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Amaa maa nu falɛ mʋ, ɩ kɔ mʋ. Lɩɩ fɛɛ ɔ gyɛ atɔ wuya gaa. ");
INSERT INTO naw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nɩɩ Yesu kɩɩ mʋ kyiim, tɔwɛ yɛ, “I biti ɩ baa ɩ bʋlʋn sa atɔ wuya ana fɛɛ ba yɛgɛ bamʋ n‐yɩɩ kɛ ba buu Ɩbwaarɛ kuwura‐gyii mʋ kɩkaapʋ. ");
INSERT INTO naw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kesintin ii biti ɩ baa ɩ bʋpɔɔ sa nyɔɔma fɛɛ ɔ taalɛ loo baasa ɔbɔ tɔ bʋlɛ, ɩ kyɔ fɛɛ atɔ wuya maa yɛgɛ mʋ n‐yɩɩ kɛ o buu Ɩbwaarɛ kuwura‐gyii mʋ kɩkaapʋ.” ");
INSERT INTO naw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nɩɩ bamʋ nɩɩ ba nu mʋ ba taasɛ yɛ, “Kanɩn bɩrɛ anɩmʋ ɩɩ taalɛ nyɛ kamɔlɩgɛ?” ");
INSERT INTO naw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Kʋtɔ mʋ nɩɩ nyɩmɩsa mɛɛ taalɛ waa mʋ, Ɩbwaarɛ bɩrɛ ɛɛ taalɛ waa.” ");
INSERT INTO naw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nɩɩ Pita tɔwɛ mʋ yɛ, “Kɩɩ! An yɛgɛ kʋtɔ kʋmaa nɩɩ an baa an buu fʋ falɛ!” ");
INSERT INTO naw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin fɛɛ, ɔkʋmaa mʋ nɩɩ ɔ kʋsʋ yɛgɛ kewu abɛɛ mʋ‐ka abɛɛ mʋ‐daa ana yɛ asupu abɛɛ akʋʋgɛpʋ abɛɛ mu‐bii ana lɩɩ Ɩbwaarɛ kuwura‐gyii kɩkaapʋ mʋ sʋ mʋ, ");
INSERT INTO naw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ee biti ɔ nyɛ falɛ atɔ gaa, nbɩɩnbɩɩ kakyɩna nɩmʋ tɔ yɛ nkpa kakpaa mʋ nɩɩ ii biti ɩ ba kamaa tɔ mʋ?” ");
INSERT INTO naw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Saŋa kʋ Yesu taa abɩɩlapʋ kudu anyɔ mʋ lɩɩ ɩkaa sʋ, nɩɩ ɔ tɔwɛ bamʋ yɛ, “An kpee Gyerusalem kɛ kʋtɔ kʋmaa mʋ nɩɩ Ɩbwaarɛ atɔwɛpʋ mʋ ba kyʋrɔɔ yɩla lɩɩ mɛ, Daadimaadi Obii‐nyɩnsa sʋ mʋ ɩ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bee biti ba lɛɛ mɛ sa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ kɛ ba waa mɛ yɛrɛyɛrɛ, kɛ ba saalɛ mɛ, kɛ ba tʋʋ nkyɔlɛ wʋrɩgɛ mɛ sʋ, kɛ ba taa awulibi tɩŋɛ mɛ kɛ ba mɔɔ mɛ. ");
INSERT INTO naw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kɛ ɩmʋ kakɛ sasapʋ mʋ kɛ n bwii kyiŋi ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amaa abɩɩlapʋ mʋ ba man nu ɩnɩmʋ kasɛ. Lɩɩ fɛɛ asɩn mʋ kasɛ baala bamʋ sʋ, nɩɩ ba man nyi kʋtɔ mʋ nɩɩ ɛɛ tɔwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu maa tiri Gyeriko tɔ mʋ, yɛgɛ gyaatanapʋ kʋ tɛ ɔkpa asɛ ɛɛ kʋlɛ atɔ. ");
INSERT INTO naw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Maa nu asa damantɛ ba maa kyʋn mʋ, ɔ taasɛ yɛ, “Mɩnɛ ɩɩ waa?” ");
INSERT INTO naw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nɩɩ ba tɔwɛ mʋ yɛ, “Yesu Kanasareti‐nyɩn mʋ ɩ kyʋn kanɩn maŋa.” ");
INSERT INTO naw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nɩɩ o kuusi tɩɩ yɛ, “Yesu, Owura Dawidi kanaana‐bii, wu mɛ kʋwɛɛ!” ");
INSERT INTO naw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nɩɩ asa mʋ nɩɩ ba bʋ Yesu ansi tɔ mʋ, ba gya mʋ yɛ o bun mʋ kɔnɔ sʋ, amaa ɔ dan san ɔ maa sʋ ee kuusi kenken yɛ, “Owura Dawidi kanaana‐bii, wu mɛ kʋwɛɛ!” ");
INSERT INTO naw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nɩɩ Yesu yɩlɛ nɩɩ ɔ sa kɔnɔ yɛ ba taa mʋ bɩya mʋ. Maa tiri mʋ tɔ mʋ, Yesu taasɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Mɩnɛ nɩɩ fii biti fɛɛ n waa sa fʋ?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, n biti fɛɛ mi ansi ɩ bɩla bugi.” ");
INSERT INTO naw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Fu ansi i bugi! Fʋ kɩkɔɔlɛ‐gyii kɩ yɛgɛ nɩɩ fʋ nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Opula maŋa tɔ mu ansi ɩ bɩla bugi nɩɩ o buu Yesu, yɛgɛ ɛɛ yɩn Ɩbwaarɛ. Nɩɩ asa mʋ kpini ba maa wu kanɩn mʋ, ngbaa bamʋ ba yɩn Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu loo Gyeriko kadɛ tɔ bɔla ɛɛ kyʋn. ");
INSERT INTO naw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ɔnyɩn kʋ kyɩna ɔ bʋ tʋtɔ mʋ kɩtɩɩ ɩ gyɛ Sakiyosi. Ɔ kyɩna ɔ gyɛ lenpoo akɔɔlɛpʋ ɔbɩlɩsa nɩn, nɩɩ ɔ gyɛ atɔ wuya. ");
INSERT INTO naw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɔ kyɩna ee biti o wu Yesu yɛ mu ansi, amaa maa gyɛ nyɩmɩsa dɛɛ sʋ mʋ, ɔ man taalɛ, lɩɩ sakyɔ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɩmʋ sʋ ɔ sɩlɛ kpee ansi tɔ naa dii oyu kʋ kɛ ɔ nyɛ wu Yesu, lɩɩ fɛɛ tʋtɔ sʋ nɩɩ Yesu ii biti ɔ bɔla. ");
INSERT INTO naw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu maa fʋʋ opula maŋa mʋ ɔ kɩɩ sʋsʋ wu mʋ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Sakiyosi, kpɩlɩgɛ ba bilen. N biti n sʋgɛ fʋ ayɛ ndaga.” ");
INSERT INTO naw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ɩmʋ sʋ nɩɩ ɔ kpɩlɩgɛ bilen taa kinsi gyii waa mʋ nsa‐nsa. ");
INSERT INTO naw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Asa ba wu ɩnɩmʋ nɩɩ ba piili bɛɛ kɔlɩtɛ yɛ, “O kpee naa sʋgɛ alibi ɔwaapʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Amaa Sakiyosi kʋsʋ yɩlɛ nɩɩ ɔ tɔwɛ Ɔnyɩrɩpɛ Yesu yɛ, “Kɩɩ Ɔnyɩrɩpɛ, n biti n barɩgɛ mɛ kapatɩyɛ tɔ kɩnyɔ, kɛ n taa kɩbaafʋn sa atiripu. Nɩɩ n kan kɔɔlɛ afulee lɩɩ ɔkʋ asɛ ɩ kyɔ kanan mʋ nɩɩ ɩ dagaa fɛɛ n kɔɔlɛ mʋ, n biti n ka mʋ kanɩn kʋkɔ maŋa kɩlɩɩ kɩnaa.” ");
INSERT INTO naw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Kamɔlɩgɛ kɩ ba fʋ ayɛ ndaga, lɩɩ fɛɛ ngbaa fʋ, fʋ gyɛ Abraham kanaana‐bii nɩn. ");
INSERT INTO naw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Lɩɩ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ n ba nɩn yɛ n ba biti kɛ n mɔlɩgɛ bamʋ nɩɩ ba fɔyɩ.” ");
INSERT INTO naw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Saŋa mʋ nɩɩ bɛɛ san bee nu falɛ asɩn mʋ, nɩɩ ɔ maa tiri Gyerusalem tɔ mʋ, asa mʋ ba fɛ nfɛɛrɛ fɛɛ Ɩbwaarɛ kuwura‐gyii mʋ kii biti ki piili opula tɔ, ɩmʋ sʋ ɔ bɔ bamʋ kɩŋasan ");
INSERT INTO naw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","yɛ, “Ɔsa kparɛ kʋ i kpee kata‐kata kadɛ kʋ, ɔ naa gyii kuwura kɛ o bwii ba. ");
INSERT INTO naw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ɩmʋ sʋ ɔ tɩɩ mʋ ayaafɔlɛ kudu nɩɩ ɔ sa bamʋ ɔkʋmaa nɩmʋ afulee mʋ nɩɩ i budu, nɩɩ ɔ tɔwɛ bamʋ yɛ, ‘Fan taa kanɩn afulee maŋa sun kusun naa fʋʋ saŋa mʋ nɩɩ n biti n bwii ba.’ ");
INSERT INTO naw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Amaa ɔsʋwʋlɛ mʋ sʋ asa ba kisi mʋ, nɩɩ ba sun gya mʋ sʋ naa tɔwɛ katɩn mʋ nɩɩ ee kpee mʋ owura lala mʋ yɛ, ‘A mɛɛ biti ɔnyɩn nɩmʋ o be gyii anɛ sʋ kuwura.’ ");
INSERT INTO naw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tʋtɔ abɩlɩsa mʋ ba bun mʋ kuwura bɩrɛ, nɩɩ o bwii ba kewu. Nɩɩ o sun tɩɩ mʋ ayaafɔlɛ mʋ nɩɩ ɔ taa afulee mʋ sa bamʋ mʋ, kɛ o wu tɔnɔ mʋ nɩɩ ba nyɛ lɩɩ kanɩn afulee maŋa sʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ɔgyankpaasa mʋ ba tɔwɛ yɛ, ‘Ɔnyɩrɩpɛ, fu afulee mʋ, ɩ kʋʋgɛ kanɩn ɩlɩɩ kudu tii sʋ’. ");
INSERT INTO naw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Nɩɩ mʋ‐nyɩrɩpɛ mʋ tɔwɛ mʋ yɛ, ‘Nsa yɛ kusun, mɛ kɩyaafɔlɛ danbɩrasa. Lɩɩ kanan mʋ nɩɩ fʋ taalɛ gyii atɔ pii nɩmʋ sʋ yɛ kesintin mʋ, n taa ndɛ kudu waa fʋ kɩbaa tɔ yɛ fʋ kɩɩ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ɔnyɔsapʋ mʋ ba tɔwɛ yɛ, ‘Ɔnyɩrɩpɛ fu afulee mʋ i bwii kʋʋgɛ ɩlɩɩ kunuu tii sʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Nɩɩ mʋ‐nyɩrɩpɛ lɛɛ kɔnɔ yɛ, ‘N taa ndɛ nnuu waa fʋ kɩbaa tɔ yɛ fʋ kɩɩ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nɩɩ mʋ kɩyaafɔlɛ kʋ gbaa ba tɔwɛ yɛ, ‘Ɔnyɩrɩpɛ, fu afulee ndee. N taa kɩmʋ ŋmina kikyibi tɔ taa yɩla katɩnkʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","N sɩlɛ fʋ nɩn, lɩɩ fɛɛ fʋ asɩn ɩ bʋlʋn gaa. Nɩɩ fɩɩ taa kʋtɔ mʋ nɩɩ kɩ man gyɛ fʋ lɛɛ, nɩɩ fɩɩ kpa atɔ mʋ nɩɩ man gyɛ fu i duu.’ ");
INSERT INTO naw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mʋ‐nyɩrɩpɛ mʋ lɛɛ kɔnɔ yɛ, ‘Fʋ gyɛ kɩyaafɔlɛ kumu tɔ ɔlʋn wuya. Fʋ gbaa‐gbaa fʋ kɔnɔ tɔ asɩn nɩɩ n biti n taa talɛ fʋ. Fu nyi fɛɛ mɛ asɩn ɩ bʋlʋn, nɩɩ n taa atɔ mʋ nɩɩ ɩ man gyɛ mɛ lɛɛ, nɩɩ n kpa atɔ mʋ nɩɩ man gyɛ mɛ i duu. ");
INSERT INTO naw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mɩnɛ ɩ waa nɩɩ fʋ man taa mɛ afulee maŋa naa yɩla afulee ɔyɩlɛkpa kɛ ɩ kʋʋgɛ agyaga sa mɛ? Naafɔɔ n maa ba falɛ kɛ n ba kɔɔlɛ ɩmaa ɩmʋ agyaga.’ ");
INSERT INTO naw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nɩɩ ɔ tɔwɛ bamʋ nɩɩ ba yɩlɛ tʋtɔ mʋ yɛ, ‘Fan kɔɔlɛ afulee mʋ lɩɩ mʋ asɛ, kɛ fan taa sa ɔmʋ nɩɩ ɔ nyɛ ɩlɩɩ kudu tii sʋ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Nɩɩ ba tɔwɛ yɛ, ‘Ɔnyɩrɩpɛ, ɔ wʋla nyɛ afulee mʋ nɩɩ i budu.’ ");
INSERT INTO naw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Nɩɩ ɔnyɩrɩpɛ mʋ lɛɛ kɔnɔ yɛ, ‘N tɔwɛ fanɛ yɛ, ɔkʋmaa mʋ nɩɩ ɛɛ kɩɩ ɩmʋ nɩɩ ba taa waa mʋ abaa tɔ sʋ danbɩrasa mʋ, bee biti ba taa gaa tii mʋ sʋ. Amaa ɔmʋ nɩɩ ba man taa ɩkʋ waa mʋ abaa tɔ kpini‐kpini mʋ, gbɛrɛɛ kʋmaa mʋ nɩɩ ɔ sʋ mʋ bee biti ba kɔɔlɛ lɩɩ mʋ asɛ.’ ");
INSERT INTO naw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amaa ɔnyɩrɩpɛ mʋ taa agbʋ tɔwɛ yɛ, ‘Bamʋ nɩɩ ba gyɛ mɛ dʋn ana, nɩɩ be mee biti n maa gyii bamʋ sʋ kuwura mʋ, fan taa bamʋ ba mɔɔ mi ansi tɔ nfɩɩ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nɩɩ Yesu maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ, ɔ gyankpaa kʋbʋ mʋ ee kpee Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Maa tiri Betifage maa Betani ndɛ mʋ nɩɩ ɩ bʋ Olifu kɩbɩɩ ɔbʋlɛ tɔ mʋ, o sun mʋ abɩɩlapʋ anyɔ nɩɩ ɔ tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Fan kpee kadɛ mʋ nɩɩ kɩ bʋ fanɛ ansi tɔ mʋ. Nɩɩ fan maa dan fen loo kɩmʋ tɔ mʋ, fen biti fan wu kekuruma‐bon kʋ mʋ nɩɩ ɔkʋ man pɩɩta dii mʋ maa kyaa oyu. Fan Saaŋɛ mʋ bɩya mɛ nfɩɩ. ");
INSERT INTO naw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nɩɩ ɔkʋ kan taasɛ fanɛ yɛ, ‘Mɩnɛ ɩ waa nɩɩ fen saaŋɛ mʋ mʋ?’ fan tɔwɛ mʋ yɛ, ‘Ɔnyɩrɩpɛ mʋ ii biti mʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bamʋ nɩɩ Yesu sun mʋ, ba naa wu mʋ fɛɛ kanan mʋ nɩɩ ɔ tɔwɛ bamʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba maa saaŋɛ kuruma mʋ, mʋ wuya ana ba taasɛ bamʋ yɛ, “Mɩnɛ ɩ waa nɩɩ fen saaŋɛ kuruma mʋ?” ");
INSERT INTO naw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ mʋ ii biti mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ba taa mʋ ba sa Yesu, nɩɩ ba taa bamʋ ataa gyaga mʋ sʋ. Nɩɩ ba kyɛ Yesu tɔ nɩɩ o dii kyɩna mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Maa kpee mʋ, asa ba taa bamʋ ataa tʋʋ ɔkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesu maa tiri Gyerusalem opula mʋ nɩɩ ɔkpa ɩɩ kpɩlɩgɛ tɔ ii kpee Olifu kɩbɩɩ mʋ sʋ mʋ, abɩɩlapʋ yɛ kʋbʋ damantɛ ba piili bee kuusi bɛɛ yɩn Ɩbwaarɛ kinsigyi tɔ lɩɩ adangana mʋ nɩɩ ba wu Yesu maa wʋla waa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bɛɛ tɔwɛ yɛ, “Ɩbwaarɛ ɩ waa Owura mʋ nɩɩ ɛɛ ba mʋ kɩtɩɩ tɔ sʋ mʋ kusee. Keyuula kɩ bʋ sʋsʋ. Nɩɩ bʋnyaa ɩ dagaa Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farasii abi akʋ mʋ nɩɩ ba bʋ sakyɔ mʋ tɔ mʋ ba tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, tɔwɛ fu abuupu yɛ ba bun bamʋ nnɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “N tɔwɛ fanɛ kɛ fan nu fɛɛ, nɩɩ ba kan bun bamʋ nnɔ sʋ gbaa, halɩɩ abuu gbaa ii biti i kuusi.” ");
INSERT INTO naw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ba maa tiri Gyerusalem tɔ nɩɩ o wu kadɛ mʋ, o su sa kɩmʋ asa. ");
INSERT INTO naw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nɩɩ ɔ tɔwɛ yɛ, “Nɩɩ fan daa fan nyi ɔkpa mʋ nɩɩ kii biti kɩ bɩya fanɛ keyuula ndaga kakɛ nɩmʋ mʋ, naafɔɔ ɩ bʋrɔn. Amaa nbɩɩnbɩɩ fen mee yɛ fen wu ɔkpa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kakaakʋ ii biti ɩ ba, kɛ fanɛ akisipu ba kʋsʋ yɩlɛ fanɛ sʋ, kyaabɔɔ fanɛ kɛ ba nyan fanɛ lɩɩ fanɛ abaafʋn kpini. ");
INSERT INTO naw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bee biti ba da fanɛ kasɛ, fanɛ yɛ nbii mʋ nɩɩ ba bʋ fanɛ asɛ kpini. Bɛ mɛɛ yɛ ba yɛgɛ fanɛ ɔpɔrɛ kubuu kʋlʋn kɩ gyaga kɩmʋ bɩrɩsa sʋ. Lɩɩ fɛɛ saŋa mʋ nɩɩ Ɩbwaarɛ ba fanɛ asɛ mʋ, fan man taalɛ pɛɛsɛ bɩɩ.” ");
INSERT INTO naw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nɩɩ Yesu loo kabwaarɛ‐sunkpa ayɛ mʋ opula tɔ, nɩɩ o piili ɛɛ gya bamʋ nɩɩ bɛɛ fɛ atɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ɔ tɔwɛ bamʋ yɛ, “Ba tɔwɛ yɩla Asɩnkyan yɩlasa mʋ tɔ yɛ, ‘Mɛ kɩkpaara kii biti kɩ baa kɩ gyɛ kabwaarɛ‐kʋlɛ kɩkpaara nɩn, amaa fan taa kɩmʋ biliŋi bamʋ nɩɩ bee yuuri ɔlʋn sʋ mʋ ɔbaalakpa.’ ” ");
INSERT INTO naw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kakɛ kʋmaa nɩmʋ ɛɛ kaapʋ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, amaa Ɩbwaarɛ aseepu bɩlɩsa yɛ nbara akaapʋpʋ yɛ asa mʋ tɔ agyankpaapʋ bee biti fɛɛ ba mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amaa ba man taalɛ nyɛ ɔkpa mʋ nɩɩ ba bɔla sʋ kɛ ba waa kanɩn, lɩɩ fɛɛ asa mʋ kpini ba taa bamʋ n‐yɩɩ mata mʋ bee nu mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nɩɩ ɩ ba fɛɛ kakaakʋ Yesu bʋ kabwaarɛ‐sunkpa kasɔrɔga tɔ ɛɛ kaapʋ asa yɛgɛ ɛɛ tɔwɛ bamʋ asɩn danbɩrasa mʋ. Nɩɩ Aseepu abɩlɩsa yɛ nbara akaapʋpʋ yɛ kadɛ tɔ abɩlɩsa gbaa ba tii sʋ, nɩɩ ba ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nɩɩ ba taasɛ mʋ yɛ, “Tɔwɛ anɛ, anɩmʋ ɔlʋn sʋ nɩɩ fʋ sʋ fɩɩ waa atɔ nɩmʋ? Anɩmʋ ɩ sa fʋ ɔlʋn maŋa?” ");
INSERT INTO naw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Ngbaa mɛ n biti n taasɛ fanɛ asɩn kʋ kɛ fan lɛɛ mɛ kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ɩbwaarɛ kekyugyee mʋ nɩɩ Gyɔn gyee asa mʋ, kɩ lɩɩ sʋsʋ nɩn abɛɛ kɩ lɩɩ asa asɛ?” ");
INSERT INTO naw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nɩɩ bamʋ gbaa‐gbaa bamʋ ba taa kɩmʋ sʋ nfɛɛrɛ nɩɩ ba yɛ, “Nɩɩ an kan tɔwɛ yɛ, ‘Kɩ lɩɩ sʋsʋ mʋ’, ee biti ɔ taasɛ yɛ, ‘Mɩnɛ ɩ waa sʋ nɩɩ fan man kɔɔlɛ gyii?’ ");
INSERT INTO naw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amaa nɩɩ an kan tɔwɛ yɛ, ‘Ɩ lɩɩ asa asɛ mʋ’, asa mʋ kpini bee biti ba twɩɩ anɛ abuu, lɩɩ fɛɛ ba kɔɔlɛ gyii fɛɛ Gyɔn gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɩmʋ sʋ, ba lɛɛ Yesu kɔnɔ yɛ, “An man nyi ntɩn mʋ nɩɩ Gyɔn kekyugyee mʋ lɩɩ.” ");
INSERT INTO naw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Kanɩn bɩrɛ, ngbaa mɛ n mɛɛ yɛ n tɔwɛ fanɛ ɔlʋn mʋ nɩɩ n sʋ n waa ɩnɩmʋ kpini.” ");
INSERT INTO naw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nɩɩ Yesu bɔ bamʋ kɩŋasan nɩmʋ yɛ, “Ɔnyɩn kʋ dɔɔ wayɩn kʋdɔɔ. Nɩɩ ɔ taa hayɩɩ sa adɔɔpʋ kʋ, nɩɩ o kpee ɔkpa naa kyɛɛrɛɛ. ");
INSERT INTO naw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Saŋa mʋ nɩɩ oyu mʋ abi kɩtɩyɛ fʋʋ mʋ, nɩɩ kʋdɔɔ wuya mʋ sun mʋ kɩyaafɔlɛ, kpee ahayɩɩpʋ mʋ asɛ yɛ ba sa mʋ wayɩn oyu abi mʋ ɩkʋ lɩɩ mʋ kʋdɔɔ mʋ tɔ. Amaa ahayɩɩpʋ mʋ ba dayɩ kɩyaafɔlɛ mʋ bwiiyaa mʋ abaa kpan. ");
INSERT INTO naw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nɩɩ ɔ bɩla bwii sun kɩyaafɔlɛ pʋpwɛ, nɩɩ ba bɩla bwii dayɩ mʋ, waa mʋ ipeeli tɔ, bwiiyaa mʋ abaa kpan. ");
INSERT INTO naw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nɩɩ ɔ bɩla bwii sun ɔsasapʋ, nɩɩ ba bɩla dayɩ larɩgɛ mʋ, lɛɛ mʋ lɩɩ kʋdɔɔ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ɩnɩmʋ kamaa mʋ, kʋdɔɔ wuya mʋ yɛ, ‘Nɛnɛ nɩɩ n biti n waa? N biti n sun mɛ kɔkɔlɔ tɔ obii, akʋtɔ bee biti ba taa bɛɛrɛɛ sa mʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Amaa saŋa mʋ nɩɩ kʋdɔɔ mʋ ahayɩɩpʋ ba wu obii mʋ, ba taa nfɛɛrɛ mʋ sʋ tɔwɛ yɛ, ‘Ɔnɩmʋ ɩ gyɛ kapatɩyɛ ogyipu mʋ, fan yɛgɛ a mɔɔ mʋ, kɛ atɔ mʋ a biliŋi anɛ lɛɛ.’ ");
INSERT INTO naw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tʋtɔ nɩɩ ba lɛɛ mʋ lɩɩ wayɩn kʋdɔɔ mʋ tɔ nɩɩ ba mɔɔ mʋ. “Nbɩɩnbɩɩ, mɩnɛ gbaa nɩɩ oyu kʋdɔɔ wuya mʋ ii biti ɔ waa ahayɩɩpʋ mʋ? ");
INSERT INTO naw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kʋdɔɔ wuya mʋ ii biti ɔ ba mɔɔ ahayɩɩpʋ mʋ, kɛ ɔ taa oyu kʋdɔɔ mʋ sa akʋ.” Nɩɩ asa mʋ ba maa nu falɛ mʋ ba tɔwɛ yɛ “Ɩbwaarɛ ɔ taa kanɩn kpee kata.” ");
INSERT INTO naw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nɩɩ Yesu kɩɩ bamʋ ansi tɔ, taasɛ bamʋ yɛ, “Asɩnkyan yɩlasa maa tɔwɛ yɛ, ‘Kubuu mʋ nɩɩ apɔyɩpʋ ba kina mʋ, kɩmʋ ɩ ba biliŋi kɩbɔntɔnbʋlɔntɔ kubuu kparɛ mʋ’ mʋ, nɛnɛ nɩɩ ɩɩ kaapʋ? ");
INSERT INTO naw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ tɩyɛ kubuu maŋa sʋ mʋ, ee biti ɔ gyayɩ tɔ buriburi. Nɩɩ ɔkʋmaa mʋ nɩɩ kubuu mʋ kɩ tɩyɛ mʋ sʋ mʋ, ee biti ɔ patɩyɛ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nɩɩ nbara akaapʋpʋ mʋ yɛ aseepu abɩlɩsa mʋ ba bɩɩ fɛɛ kɩŋasan mʋ nɩɩ ɔ bɔɔ mʋ i yii bamʋ nɩn. Nɩɩ bee biti ɔkpa ba kɩtaa mʋ opula maŋa tɔ. Amaa ba sɩlɛ asa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yɛgɛ abɩlɩsa mʋ ba taa bamʋ ansi yii Yesu sʋ, nɩɩ ba lɛɛ apɛɛtɩpʋ akʋ yɛ ba waa mu ansi sʋ kɩdanbɩrasa. Bɛɛ fɛ nfɛɛrɛ fɛɛ bee biti ba nyɛ Yesu kɩtaa lɩɩ mʋ asɩn tɔwɛsa sʋ, kɛ ba taa mʋ sa ɔsʋwʋlɛ ɔkɩɩsʋpʋ alʋlʋnpʋ. ");
INSERT INTO naw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɩmʋ sʋ apɛɛtɩpʋ mʋ ba tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, an nyi fɛɛ fʋ ɩ tɔwɛ nɩɩ fɩɩ kaapʋ kʋtɔ mʋ nɩɩ kɩ bʋrɔn, nɩɩ fʋ mɛɛ mɛɛgɛ tɔ, amaa nɩɩ fɩɩ kaapʋ Ɩbwaarɛ ɔkpa mʋ kyɛɛkyɛɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ɩmʋ sʋ ɩ daaga fɛɛ a ka tʋʋtʋʋ sa Roma Ɩsʋwʋlɛ Owura lala Kayisa, abɛɛ a man ka?” ");
INSERT INTO naw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nɩɩ Yesu bɩɩ fɛɛ apɛɛtɩpʋ mʋ bɛɛ da mʋ ɔtɔ tɔ nɩn, kɛ ba nyɛ nu mʋ kɔnɔ tɔ asɩn. Ɩmʋ sʋ ɔ tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Fan taa nderebi mʋ ba kɛ n kɩɩ.” Maa wu kɩmʋ mʋ, nɩɩ ɔ taasɛ yɛ, “Anɩmʋ foto yɛ kɩtɩɩ ɩ gyan kɩmʋ sʋ?” ");
INSERT INTO naw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Owura lala Kayisa lɛɛ nɩn.” Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Kanɩn bɩrɛ fan taa kʋtɔ mʋ nɩɩ kɩ gyɛ Owura lala Kayisa lɛɛ mʋ sa mʋ, kɛ fan taa kʋtɔ mʋ nɩɩ kɩ gyɛ Ɩbwaarɛ lɛɛ mʋ sa Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lɩɩ kanan mʋ nɩɩ ɔ lɛɛ bamʋ kɔnɔ sʋ mʋ, i kyinkyin apɛɛtɩpʋ mʋ, nɩɩ ba laatɔ. Ɩmʋ sʋ ba man taalɛ ba nyɛ mʋ kɔnɔ tɔ asɩn kʋ ba taa kɩtaa mʋ sakyɔ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Gyiwu abi kʋbʋ mʋ nɩɩ bɛɛ tɩɩ yɛ Sadusi mʋ nɩɩ ba yɛ kelewu kyiŋi man bʋ tɔ mʋ, akʋ ba ba Yesu asɛ yɛ asɩn taasɛsa. Nɩɩ ba tɔwɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ɔkaapʋpʋ, anɛ naana Mosesi kyʋrɔɔ sa anɛ yɛ, nɩɩ ɔkʋ kan wu san okulapu‐kyɩɩ, nɩɩ ba man kʋʋgɛ mʋ, i tiri fɛɛ mu‐supu ɔ taa mʋ kili, kʋʋgɛ nbii sa mʋ‐daa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","To! Anyibii asunɔ akʋ ba kyɩna ba bʋ tɔ. Nɩɩ ɔgyankpaapʋ mʋ kili ɔkyɩɩ mʋ nɩɩ ɔ man kʋʋgɛ nɩɩ o wu. ");
INSERT INTO naw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nɩɩ ɔnyɔsapʋ mʋ kili okulapu‐kyɩɩ mʋ, nɩɩ mʋ gbaa mʋ wu. ");
INSERT INTO naw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nɩɩ ɔsasapʋ mʋ gbaa kili mʋ, nɩɩ o wu. Nɩɩ ɩ waa kanan halɩɩ asa asunɔ mʋ kpini ba kili mʋ, yɛgɛ bamʋ tɔ ɔkʋ maa ɔkyɩɩ mʋ ba man kʋʋgɛ. ");
INSERT INTO naw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɩmʋ laalaalʋwɛ mʋ okulapu‐kyɩɩ mʋ gbaa ba wu. ");
INSERT INTO naw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ɩmʋ sʋ an biti a taasɛ yɛ fɛɛ nɩɩ kakɛ lala mʋ nɩɩ asa kpini ba kan kyiŋi lɩɩ lewu tɔ mʋ, bamʋ tɔ ɔmɔɔ ii biti ɔ baa ɔ gyɛ mu‐kuli? Lɩɩ fɛɛ bamʋ asunɔ maŋa kpini ba wʋla kyɩna kili mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Dulinya nɩmʋ tɔ bɩrɛ asa bee kili. ");
INSERT INTO naw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amaa bamʋ nɩɩ Ɩbwaarɛ wu yɛ ɩ dagaa fɛɛ ba nyɛ kelewu kyiŋi, kɛ ba kyɩna dulinyaa pʋpwɛ tɔ mʋ, ba man bɩla yɛ ba kili. ");
INSERT INTO naw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba man bɩla yɛ ba wu kakaakʋ, lɩɩ fɛɛ bee biti ba baa be du nɩn fɛɛ Ɩbwaarɛ nbɔɔ. Ba gyɛ Ɩbwaarɛ nbii lɩɩ fɛɛ ba maa kyiŋi lɩɩ lewu tɔ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nɩɩ lɩɩ kelewu kyiŋi asɩn bɩrɛ, Mosesi gbaa kɔɔlɛ gyii. Kanɩn sʋ, saŋa mʋ nɩɩ o wu kɩpʋnfa maa dɩyɛ mʋ, ɔ tɔwɛ lɩɩ Ɩbwaarɛ sʋ yɛ, mʋ ɩ gyɛ Abraham maa Isaki yɛ Gyekobu Ɩbwaarɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ɔ man gyɛ alewupu Ɩbwaarɛ nɩn, amaa ɔ gyɛ asa kɩɩsa lɛɛ nɩn. Lɩɩ fɛɛ Ɩbwaarɛ ansi tɔ mʋ alewupu banɩmʋ ba san ba tɛ nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nɩɩ nbara akaapʋpʋ mʋ akʋ ba tɔwɛ yɛ, “Ɔkaapʋpʋ, fʋ tɔwɛ kɩmʋ kyɛɛkyɛɛ.” ");
INSERT INTO naw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ɩnɩmʋ kamaa mʋ ɔkʋ man bɩla taalɛ nyɛ kɔkɔlɔ ɔsɩɩ taasɛ mʋ sɛhn. ");
INSERT INTO naw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nɩɩ Yesu taasɛ bamʋ yɛ, “Mɩnɛ sʋ nɩɩ bɛɛ taalɛ bɛɛ tɔwɛ yɛ, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ gyɛ Owura Dawidi kanaana‐bii? ");
INSERT INTO naw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Lɩɩ fɛɛ Dawidi gbaa‐gbaa tɔwɛ mʋ Ɩlʋn ɔwʋlɛ mʋ tɔ yɛ, ‘Ɔnyɩrɩpɛ Ɩbwaarɛ tɔwɛ mɛ‐Nyɩrɩpɛ yɛ, “Kyɩna mɛ gyisa sʋ nfɩɩ, ");
INSERT INTO naw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","naa fʋʋ saŋa mʋ nɩɩ n biti n taa fʋ dʋn ana ba waa fʋ ayaa ɔgyagakpa.” ’ ");
INSERT INTO naw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nɩɩ Dawidi gbaa‐gbaa ɩɩ tɩɩ mʋ yɛ, ‘Ɔnyɩrɩpɛ’ bɩrɛ, nɛnɛ ɩ waa sʋ nɩɩ ɔ gyɛ mʋ kanaana‐bii?” ");
INSERT INTO naw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Saŋa mʋ nɩɩ asa mʋ ba san bee nu mʋ, Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Fan kɩɩ fan n‐yɩɩ sʋ danbɩrasa lɩɩ nbara akaapʋpʋ mʋ sʋ. Ba gyɛ bamʋ nɩɩ bee biti ɩkaalɛ lala kubun bɛɛ kyaabɔɔ tɔ, nɩɩ bee biti fɛɛ ba taa bɛɛrɛɛ fwaala bamʋ agya tɔ, bee biti ba kyɩna ngya kparɛ sʋ kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa yɛ ɔgyaŋɛ gyiikpa. ");
INSERT INTO naw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bee pɩna akulapu‐kyɩɩ bɛɛ kɔɔlɛ bamʋ akpaara, nɩɩ bɛɛ yɩlɛ ipula bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ bʋnswɩɩsa mʋ nɩɩ ɩ nyɛ pɩna asa fɛɛ ba gyɛ asa danbɩrasa. Ɩbwaarɛ ii biti ɔ bɩɩtɛ kanɩn asa maŋa asʋ gaa.” ");
INSERT INTO naw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu maa bʋ kabwaarɛ‐sunkpa ayɛ mʋ tɔ mʋ, nɩɩ o diyaa mu ansi wu atɔ wuya ana ba maa sʋ afulee bɛɛ waa kakɛɛ kɩdakaa tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nɩɩ ɔ bɩla wu okulapu‐kyɩɩ otiripu kʋ gbaa maa taa nderebi anyɔ ba waa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nɩɩ Yesu yɛ, “N tɔwɛ fanɛ kesintin fɛɛ, okulapu‐kyɩɩ otiripu nɩmʋ waa tɔ afulee ɔ kyɔ bamʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Asa banɩmʋ kpini, ba lɛɛ lɩɩ bamʋ afulee gaa mʋ nɩɩ ba sʋ mʋ tɔ nɩn. Amaa ɔkyɩɩ nɩmʋ bɩrɛ halɩɩ maa mʋ kitiri kɩnɩmʋ mʋ, ɔ taa mu afulee mʋ nɩɩ ɔ sʋ mʋ kpini ba waa tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nɩɩ Yesu abɩɩlapʋ mʋ akʋ bee biri kiligyima bɛɛ lɩɩ kabwaarɛ‐sunkpa ayɛ mʋ, kanan mʋ nɩɩ kɩ bʋrɔn, yɛ abuu danbɩrasa mʋ nɩɩ ba taa pɔyɩ, yɛ atɔ mʋ nɩɩ asa ba kɛɛ nɩɩ ba taa lɔŋɔ obu mʋ sa Ɩbwaarɛ. Amaa Yesu tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ɩmʋ nɩɩ fan wu falɛ kpini, saŋa kʋ ii biti ɔ ba yɛgɛ fɛn mɛɛ bɩla yɛ fen wu kubuu kʋlʋn gbaa kɩ maa gyan kʋkʋ sʋ, bee biti ba nɩn kubuu kʋmaa nɩmʋ tʋʋ kasɛ.” ");
INSERT INTO naw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nɩɩ ba taasɛ mʋ yɛ, “Ɔkaapʋpʋ, saŋa mɔmɔ nɩɩ falɛ atɔ nɩmʋ a biti a waa? Nɩɩ mɩnɛ sɩnkaala ii biti ɩ waa kaapʋ fɛɛ saŋa mʋ fʋʋ fɛɛ kanɩn atɔ nɩmʋ ii biti ɩ waa?” ");
INSERT INTO naw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fan baa fan da sʋ, kɛ ɔkʋ ɔ man pɩna fanɛ. Lɩɩ fɛɛ asa gaalaagaa bee biti ba ba mɛ kɩtɩɩ tɔ ba tɔwɛ yɛ, ‘Mɛ ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ’. Nɩɩ bee biti ba bɩla tɔwɛ yɛ, ‘Laalaalʋwɛ saŋa mʋ tee tiri tɔ’. Amaa fan man buu bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Fan kan nu kɩnaa yɛ ɩkɔ sʋ mʋ, fan man waa kufuu. Ɩ dagaa fɛɛ falɛ atɔ nɩmʋ ɩ maa gyankpaa ba kanɩn pɔyɩ. Amaa ɩ mɛɛ kaapʋ fɛɛ laalaalʋwɛ mʋ tee tiri tɔ nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nɩɩ Yesu bɩla kyaga sʋ yɛ, “Ɔsʋwʋlɛ ii biti ɔ kɔ yɛ ɔsʋwʋlɛ, kɛ awuragyi yɛ awuragyi ba kɔ yɛ abaa. ");
INSERT INTO naw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kɛ kasɛ ki gyingyen ipula kʋkwɩɩ‐kʋkwɩɩ, kɛ akʋn yɛ alɔ kyaŋɛsa a tɩyɛ katɩn kʋmaa nɩmʋ, kɛ atɔ mʋ nɩɩ a sʋ kufuu yɛ ɩsɩnkaala lala‐lala a lɩɩ sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Amaa pɔyɩ kɛ ɩnɩmʋ kpini ɩ ba mʋ, bee biti ba kɩtaa fanɛ kɛ ba nyanla fanɛ. Bee biti ba taa fanɛ kpee kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa naa gyii fanɛ asɩn, kɛ ba naa tii fanɛ ibu. Bee biti ba taa fanɛ kpee awura yɛ alʋnpʋ ansi tɔ, lɩɩ mɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɩnɩmʋ ii biti ɩ yɛgɛ kɛ fan nyɛ ɔkpa tɔwɛ asɩn danbɩrasa mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Amaa fan yɛgɛ ɩ baa ɩ bʋ fanɛ nfɛɛrɛ tɔ fɛɛ, ɩ man dagaa fan yɩyɛɛ lɩɩ asɩn mʋ nɩɩ fen biti fan naa tɔwɛ kɔɔlɛ fanɛ n‐yɩɩ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kpalɩ fɛɛ n biti n sa fanɛ kanyaasɩn, kɛ n kaapʋ fanɛ asɩn mʋ nɩɩ fen biti fan naa tɔwɛ, yɛgɛ fanɛ akisipu ɔkʋ mɛɛ taalɛ kina abɛɛ o gyii ɩmɔɔrɛ lɩɩ kʋtɔ mʋ nɩɩ fan tɔwɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Fanɛ akʋʋgɛpʋ abɛɛ adaa yɛ asupu abɛɛ fanɛ kʋʋpʋ ana abɛɛ akyɛmɩnɛ bee biti ba lɛɛ fanɛ sa, kɛ ba mɔɔ fanɛ tɔ akʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nɩɩ ɔkʋmaa nɩmʋ ii biti o kisi fanɛ, lɩɩ mɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amaa halɩɩ fanɛ ɔkʋ kinyinibi kʋlʋn gbaa mɛɛ yɛ ɔ fɔyɩ. ");
INSERT INTO naw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Fan kan nyɛ nɩɩ fan yɩlɛ fanɛ kɩkɔɔlɛ‐gyii tɔ kenken mʋ, ii biti ɩ mɔlɩgɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nɩɩ fan kan wu fɛɛ anaakɔpʋ ba kyaabɔɔ Gyerusalem kadɛ mʋ, fen biti fan bɩɩ fɛɛ kɩmʋ kinyita ki tiri tɔ. ");
INSERT INTO naw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kanɩn sʋ bamʋ nɩɩ ba bʋ Gyudeya kasɛ sʋ mʋ, ba lɩɩ sɩlɛ kpee abɩɩ tɔ, nɩɩ bamʋ nɩɩ ba bʋ Gyerusalem kadɛ tɔ mɔɔ ba lɩɩ, nɩɩ bamʋ nɩɩ ba man bʋ kadɛ mʋ tɔ mʋ, ba man loo Gyerusalem kadɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kpalɩ fɛɛ ɩnɩmʋ ɩ gyɛ Ɩbwaarɛ kʋsʋ bɩɩtɛ nkɛ mʋ, ɩmʋ ii biti ɩ yɛgɛ Ɩbwaarɛ Asɩnkyan yɩlasa mʋ kpini ɩ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nɩɩ akyɩɩ mʋ nɩɩ ba sʋ ɩtɔ yɛ bamʋ nɩɩ ba sʋ nbii‐nyɛpʋsa mʋ laakʋ! Lɩɩ fɛɛ awʋrʋfɔ lala a biti a ba tɩyɛ kasɛ maŋa sʋ, kɛ Ɩbwaarɛ agbʋ lala mʋ ɩ ba Gyiwu abi sʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Isakunde nɩɩ bee biti ba taa mɔɔ Gyiwu abi mʋ akʋ, kɛ ba kɩtaa bamʋ akʋ naa biliŋi anyɛ ndɛndɛmandɛ ɩsʋwʋlɛ sʋ. Nɩɩ bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ bee biti ba taa Gyerusalem waa bamʋ kebiti naa fʋʋ saŋa mʋ nɩɩ Ɩbwaarɛ ŋmina sa bamʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nɩɩ ɩsɩnkaala ii biti ɩ waa kyɔwɛ yɛ ɔbwaayɩ yɛ akyikpebi tɔ. Nɩɩ ɔpʋ ɩlawʋ yɛ apaa a maa da sʋ mʋ, ɩ yɛgɛ nɩɩ kufuu kɩ kɩtaa asa mʋ nɩɩ ba bʋ kasɛ sʋ kpini, kɛ ba waa yɛrɛyɛrɛ. ");
INSERT INTO naw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nɩɩ ba maa kɩɩ ba gyoo kanɩn atɔ mʋ nɩɩ ii biti ɩ waa falɛ mʋ, kufuu ii biti ɩ yɛgɛ asa ba kirin‐kirin, kpalɩ fɛɛ atɔ mʋ nɩɩ ɩ bʋ sʋsʋ mʋ kpini ii biti i gyingyen lɩɩ ɩmʋ ipula. ");
INSERT INTO naw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kanɩn saŋa maŋa mʋ bee biti ba wu mɛ, Daadimaadi Obii‐nyɩnsa maa sʋ ɔlʋn yɛ bʋnyaa lala n lɩɩ abwaarɛ‐wʋlɛ tɔ n ba. ");
INSERT INTO naw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nɩɩ fan kan wu saŋa mʋ nɩɩ falɛ atɔ nɩmʋ ii biti i piili mʋ, fan kʋsʋ yɩlɛ kɛ fan diyaa fanɛ ansi sʋsʋ, lɩɩ fɛɛ fanɛ kamɔlɩgɛ mʋ ki tiri tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nɩɩ Yesu bɔɔ bamʋ kɩŋasan nɩmʋ yɛ, “Fan kɩɩ kɩdɩnpɔ oyu yɛ iyu mʋ nɩɩ ɩ san mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Saŋa mʋ nɩɩ fan wu ɩ maa pɔrɔgɛ mʋ, fen nyi fɛɛ kɩkyɛ ki tiri tɔ. ");
INSERT INTO naw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kanɩn ɔkpa maŋa sʋ, nɩɩ fan kan wu atɔ nɩmʋ a maa waa mʋ, fan bɩɩ fɛɛ Ɩbwaarɛ kuwura‐gyii mʋ ki tiri tɔ. ");
INSERT INTO naw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“N tɔwɛ fanɛ kesintin fɛɛ, ndaga kakyɩna nɩmʋ tɔ asa ba mɛɛ yɛ ba wu lʋwɛ, pɔyɩ kɛ atɔ nɩmʋ kpini ɩ waa. ");
INSERT INTO naw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sʋsʋ yɛ kasɛ kpini ii biti ɩ kyʋn, amaa mɛ kɔnɔ tɔ asɩn mʋ bɩrɛ, ɩ mɛɛ yɛ ɩ kyʋn kpaa. ");
INSERT INTO naw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Fan baa fan da fanɛ n‐yɩɩ sʋ, kɛ fan man taa fan n‐yɩɩ sa kensi‐gyii gaa, yɛ kata‐bʋʋ yɛ kakyɩna tɔ atɔ bitisa kʋkyɔ, kɛ kanɩn kakɛ maŋa kɩ man ba purigi fanɛ fɛɛ ɔdʋʋ maa da kunun mʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kpalɩ fɛɛ ii biti i purigi asa mʋ nɩɩ ba tɛ kasɛ sʋ mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ɩmʋ sʋ saŋa kʋmaa fan baa fan da sʋ, kɛ fɛn kʋlɛ kabwaarɛ‐kʋlɛ kɛ ɩ lɛɛ fanɛ lɩɩ atɔ mʋ nɩɩ ii biti ɩ ba falɛ, kɛ fan taalɛ yɩlɛ mɛ, Daadimaadi Obii‐nyɩnsa mu ansi tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kakɛ kʋmaa nɩmʋ Yesu ɩɩ kaapʋ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, nɩɩ kalaatɩpwɛ kʋmaa nɩmʋ mɔɔ ee kpee ɛɛ dɛ Olifu kɩbɩɩ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nɩɩ nyenyenfuu kʋmaa nɩmʋ mɔɔ asa mʋ bee kpee kabwaarɛ‐sunkpa ayɛ mʋ tɔ bee nu mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nkɛ mʋ nɩɩ Gyiwu abi bee gyii Kesu kɔnɔ kɔlɔŋɔ bodobodo mʋ nɩɩ ba man taa kɩfɛ tinsa waa tɔ mʋ tiri tɔ. Kanɩn saŋa maŋa nɩɩ bɛɛ tɩɩ yɛ Kanyaŋɛ nbunɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nɩɩ aseepu bɩlɩsa yɛ nbara akaapʋpʋ bee biti ɩkpa mʋ nɩɩ ba taa kɩtaa Yesu mɔɔ kɛ ɔkʋ ɔ man wu, lɩɩ fɛɛ ba sɩlɛ sakyɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tʋtɔ nɩɩ Sɩtaanɛ taa nfɛɛrɛ libi waa Gyudasi mʋ nɩɩ bɛɛ tɩɩ Isikariyoti mʋ tɔ. Ɔ gyɛ asunpu kudu anyɔ mʋ tɔ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nɩɩ Gyudasi kpee aseepu bɩlɩsa yɛ kabwaarɛ‐sunkpa kɩkpaara akunpu bɩlɩsa mʋ asɛ, nɩɩ maa bamʋ ba naa taa nfɛɛrɛ ɔkpa mʋ nɩɩ ee biti ɔ lɛɛ Yesu sa. ");
INSERT INTO naw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nɩɩ ɩ waa bamʋ ɔkɔn, nɩɩ ba tɔwɛ kyula yɛ bee biti ba sa mu afulee. ");
INSERT INTO naw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nɩɩ o kyula nɩɩ ee biti ɔkpa mʋ nɩɩ ɔ taa lɛɛ Yesu sa bamʋ, kanan mʋ nɩɩ sakyɔ mʋ ba man nyɛ wu. ");
INSERT INTO naw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kakɛ mʋ nɩɩ Gyiwu abi bee gyii bamʋ Bodobodo mʋ nɩɩ ba man taa kɩfɛ tinsa waa tɔ, yɛ Kanyaŋɛ nbunɔ kabʋlʋpʋ mʋ kɩmɔɔ fʋʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nɩɩ Yesu sun Pita maa Gyɔn nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan naa lɔŋɔ atɔ mʋ nɩɩ an biti a taa gyii Kanyaŋɛ nbunɔ agyitɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nɩɩ ba taasɛ Yesu yɛ, “Fɩnɛ nɩɩ fii biti fɛɛ a naa lɔŋɔ ɩmʋ yɩla?” ");
INSERT INTO naw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fan maa dan fen loo kadɛ lala mʋ tɔ mʋ, fen biti fan gyaŋa ɔnyɩn kʋ maa sʋ kolobi yɛ nkyu. Fan buu mʋ loo kɩkpaara mʋ nɩɩ ee loo mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kɛ fan tɔwɛ kɩkpaara wuya mʋ yɛ, ɔkaapʋpʋ mʋ yɛ, ‘Nkɩɩ afɔ obu mʋ nɩɩ maa mɛ abɩɩlapʋ an biti a kyɩna tɔ gyii Kanyaŋɛ nbunɔ mʋ?’ ");
INSERT INTO naw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ee biti ɔ kaapʋ fanɛ obu lala kʋ mʋ nɩɩ kɩ bʋ abansʋrʋ mʋ sʋ, nɩɩ ɔ lɔŋɔ kɩmʋ tɔ waa kɩmʋ kʋtɔ kʋmaa. Fan lɔŋɔ agyitɔ mʋ yɩla tʋtɔ.” ");
INSERT INTO naw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ba lɩɩ naa wu atɔ mʋ kpini fɛɛ kanan mʋ nɩɩ Yesu tɔwɛ bamʋ mʋ. Nɩɩ ba kʋʋla Kanyaŋɛ nbunɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saŋa mʋ maa fʋʋ mʋ, Yesu maa mu asunpu ba naa kyɩna tʋtɔ bee gyii. ");
INSERT INTO naw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nɩɩ ɔ tɔwɛ bamʋ yɛ, naafɔɔ n biti gaa fɛɛ maa fanɛ an gyii Kanyaŋɛ nbunɔ agyitɔ anɩmʋ pɔyɩ kɛ n gyii mɛ awʋrʋfɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Lɩɩ fɛɛ n tɔwɛ fanɛ yɛ, n man bɩla yɛ n gyii falɛ agyitɔ anɩmʋ, naa fʋʋ kʋtɔ mʋ nɩɩ agyitɔ nɩmʋ kigyii kasɛ ɩɩ kaapʋ ɩ waa Ɩbwaarɛ kuwura‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tʋtɔ nɩɩ Yesu taa kɔɔpʋ mʋ, nɩɩ ɔ taa afwaala sa Ɩbwaarɛ nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan kɔɔlɛ kɩnɩmʋ barɩgɛ tɔ sa abaa. ");
INSERT INTO naw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Lɩɩ fɛɛ n wʋla tɔwɛ fanɛ yɛ, n man bɩla yɛ n nuu falɛ nta nɩmʋ naa fʋʋ saŋa mʋ nɩɩ Ɩbwaarɛ kuwura‐gyii mʋ kɩ ba mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nɩɩ ɔ taa bodobodo, nɩɩ ɔ fwaala Ɩbwaarɛ, nɩɩ ɔ kpɛɛ kɩmʋ tɔ sa bamʋ, tɔwɛ bamʋ yɛ, “Kɩnɩmʋ ɩ gyɛ mɛ kayɩɩ‐wʋlɛ mʋ nɩɩ fanɛ sʋ, n taa lɛɛ saraga. Fan gyii kɩmʋ taa nyiŋi mɛ.” ");
INSERT INTO naw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ɔkpa kʋlʋn maŋa sʋ ba maa gyii kalaatɩpwɛ agyitɔ lʋwɛ mʋ, nɩɩ ɔ taa kɔɔpʋ sa bamʋ tɔwɛ yɛ, “Nta nɩmʋ ɩ gyɛ Ɩbwaarɛ katɔwɛ kyula pʋpwɛ mʋ nɩɩ n taa mɛ nkalan tii ɩmʋ kɔnɔ, nɩɩ n kyɛɛgɛ wʋrɩgɛ sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amaa n tɔwɛ fanɛ yɛ, ɔsa mʋ nɩɩ ee biti ɔ lɛɛ mɛ sa mʋ, maa mʋ abaa ɩ bʋ agyitɔ nɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mɛ, Daadimaadi Obii‐nyɩnsa mʋ n biti n kpee Ɩbwaarɛ asɛ fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ wʋla tɔwɛ yɩla mʋ. Amaa ɔmʋ nɩɩ ee biti ɔ lɛɛ mɛ sa mʋ, mʋ laakʋ.” ");
INSERT INTO naw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tʋtɔ nɩɩ mʋ abɩɩlapʋ mʋ ba piili bɛɛ taasɛ abaa bamʋ tɔ ɔmɔɔ ii biti ɔ waa kanɩn asɩn nɩmʋ? ");
INSERT INTO naw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nɩɩ kamɔɔrɛ‐gyii kɩ tɩyɛ Yesu abɩɩlapʋ mʋ sʋ lɩɩ ɔmʋ nɩɩ ɔ gyɛ bamʋ tɔ ɔbɩlɩsa. ");
INSERT INTO naw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Dulinya nɩmʋ tɔ awura bɛɛ nyan bamʋ asa nɩn, amaa bamʋ asa mʋ bɛɛ tɩɩ bamʋ yɛ, ‘Anɛ akyɛtɔpʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amaa fan man yɛgɛ fanɛ lɛɛ ɔ baa o du kanɩn. Fanɛ tɔ ɔmʋ nɩɩ ɔ gyɛ ɔbɩlɩsa mʋ, o biliŋi fɛɛ kebii, kɛ fanɛ ɔgyankpaapʋ mɔɔ o biliŋi fɛɛ fanɛ kɩyaafɔlɛ. ");
INSERT INTO naw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ɔmɔmɔ ɩ gyɛ ɔbɩlɩsa? Ɔmʋ nɩɩ ɛɛ ba kyɩna nɩɩ ee gyii mʋ, abɛɛ ɔmɔɔ nɩɩ ɛɛ bɩya agyitɔ mʋ? Man gyɛ ɔmʋ nɩɩ ɔ ba kyɩna ee gyii mʋ? Amaa mɛɛ mɛ n bʋ fanɛ asɛ n sun fɛɛ kɩyaafɔlɛ. ");
INSERT INTO naw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mɛ awʋrʋfɔ tɔ mʋ fan yɩlɛ mɛ kamaa. ");
INSERT INTO naw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Fɛɛ kanan mʋ nɩɩ mɛ‐Sɛ sa mɛ ɔkpa fɛɛ n gyii kuwura mʋ, kanɩn ɔkpa maŋa sʋ nɩɩ ngbaa mɛ n sa fanɛ yɛ fan gyii kuwura. ");
INSERT INTO naw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nɩɩ n kan be gyii kuwura mʋ, n biti n yɛgɛ maa fanɛ an gyii, kɛ a nuu teeburi kʋlʋn sʋ, kɛ fan kyɩna nwuragya sʋ kɛ fan talɛ Ɩsɩrayɩ abi nbunɔ kudu anyɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu tɔwɛ Pita yɛ, “Simon, Simon! Nu nfɩɩ! Sɩtaanɛ kʋlɛ ɔkpa Ɩbwaarɛ asɛ, kɛ ɔ bɔla kʋtʋʋ tɔ kɩɩ sʋ kyaalɛ fanɛ fɔyɩ fɛɛ ayu waatɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amaa Simon, n kʋlɛ kabwaarɛ‐kʋlɛ sa fʋ kɛ fʋ kɩkɔɔlɛ‐gyii kɩ man tɩyɛ. Nɩɩ fʋ kan kyɛɛgɛ fʋ nfɛɛrɛ ba mɛ asɛ mʋ, waa fʋ tɔɔmaa ana abɩɩlapʋ mʋ ɔlʋn tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Amaa Pita lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, n kʋʋla mɛ n‐yɩɩ fɛɛ obu kitii tɔ gbaa n biti n buu fʋ kpee, nɩɩ halɩɩ lewu gbaa maa fʋ an biti a wu.” ");
INSERT INTO naw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nɩɩ Yesu tɔwɛ yɛ, “Pita! Pɔyɩ kɛ kyaasɛ ɔ bʋn kagyanbwɛ nɩmʋ mʋ, fii biti fu kina ɩlɩɩ ɩsa yɛ fʋ man nyi mɛ.” ");
INSERT INTO naw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tʋtɔ nɩɩ Yesu taasɛ mʋ abɩɩlapʋ mʋ yɛ, “Saŋa mʋ nɩɩ n kyɩna sun fanɛ yɛgɛ fan man sʋ afulee ɔwaakpa yɛ itaakpe yɛ asɩbɩta mʋ, fan pan kʋtɔ kʋ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “A man pan sɛhn.” ");
INSERT INTO naw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nɩɩ Yesu yɛ, “Amaa nbɩɩnbɩɩ bɩrɛ ɔkʋmaa mʋ nɩɩ ɔ sʋ afulee ɔwaakpa yɛ taakpe mʋ ɔ taa. Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ man sʋ sakunde mʋ, ɔ fɛ mʋ balɩmaasʋ kɛ ɔ taa sɔɔ kʋkʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Lɩɩ fɛɛ ba kyʋrɔɔ mɛ n‐yɩɩ sʋ asɩn yɩla yɛ, ‘Ba taa mʋ bʋga alibi awaapʋ tɔ.’ Ɩmʋ sʋ n tɔwɛ fanɛ yɛ ɩ dagaa fɛɛ kanɩn Asɩnkyan yɩlasa nɩmʋ ɩ ba tɔ kesintin nbɩɩnbɩɩ lɩɩ mɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nɩɩ ba tɔwɛ yɛ, “Ɔnyɩrɩpɛ, kɩɩ isakunde anyɔ ndee.” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ɩ kʋkwɛ.” ");
INSERT INTO naw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nɩɩ Yesu lɩɩ tʋtɔ, nɩɩ maa mʋ abɩɩlapʋ mʋ ba kpee olifu kɩbɩɩ mʋ sʋ, fɛɛ kanan mʋ nɩɩ ba wʋla bɛɛ waa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ba maa fʋʋ opula maŋa mʋ, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan kʋlɛ kabwaarɛ‐kʋlɛ kɛ fan man lɩɩ tɩyɛ kʋtʋʋ tɔ kɩɩ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Maa tɔwɛ kanɩn mʋ, nɩɩ o nin lɩɩ bamʋ asɛ gbɛrɛɛ naa yɔɔ muŋa mu amulii sʋ kʋlɛ kabwaarɛ‐kʋlɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Nsɛ, nɩɩ ɩ gyɛ fu kebiti mʋ, yɛgɛ awʋrʋfɔ anɩmʋ ɩ kɩlɩgɛ mɛ. Amaa man gyɛ mi kebiti, waa ɩmʋ nɩɩ ɩ gyɛ fu kebiti.” ");
INSERT INTO naw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nɩɩ Ɩbwaarɛ kabɔɔ lɩɩ sʋsʋ ba mʋ asɛ, ba waa mʋ ɔlʋn tɔ. ");
INSERT INTO naw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lɩɩ kayɩyɛɛ yɛ kensi payɩ sʋ mʋ, ɔ taa ɔlʋn kʋlɛ kabwaarɛ‐kʋlɛ, nɩɩ kududuu mʋ nɩɩ ɩɩ lɩɩ mʋ sʋ ɩɩ kyɔlɛ ɩ tɩyɛ kasɛ mʋ i du nɩn fɛɛ nkalan. ");
INSERT INTO naw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Maa kʋsʋ mʋ kabwaarɛ‐kʋlɛ tɔ mʋ, o bwii naa tu mʋ abɩɩlapʋ mʋ ba maa dɛ nsɩɩrɛ lɩɩ bamʋ kɩkpɩnɛ yɛ kɔkɔlɔ nyita sʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nɩɩ Yesu taasɛ bamʋ yɛ, “Mɩnɛ ɩ waa nɩɩ fan dɛ nsɩɩrɛ? Fan kʋsʋ kʋlɛ kabwaarɛ‐kʋlɛ kɛ fan man lɩɩ tɩyɛ kʋtʋʋ tɔ kɩɩ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Saŋa mʋ nɩɩ Yesu san ɛɛ maa sʋ ɛɛ tɔwɛ mʋ, nɩɩ sakyɔ kʋ ba ba lɩɩ tʋtɔ. Nɩɩ mʋ abɩɩlapʋ kudu anyɔ mʋ tɔ ɔkʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gyudasi mʋ, gyankpaa sakyɔ mʋ. Nɩɩ o nin tiri Yesu, nɩɩ ɔ baari mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tʋtɔ nɩɩ Yesu taasɛ Gyudasi yɛ, “Kibiri tɔ nɩɩ fʋ sʋ fɩɩ lɛɛ mɛ, Daadimaadi Obii‐nyɩnsa fɩɩ sa?” ");
INSERT INTO naw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tʋtɔ mʋ, Yesu abɩɩlapʋ mʋ nɩɩ ba bʋ mʋ asɛ mʋ, ba maa wu kʋtɔ mʋ nɩɩ kii biti kɩ waa mʋ, nɩɩ ba taasɛ Yesu yɛ, “Ɔnyɩrɩpɛ a lɛɛ anɛ isakunde mʋ kɔ?” ");
INSERT INTO naw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Opula maŋa tɔ nɩɩ abɩɩlapʋ mʋ tɔ ɔkʋ ŋɛ oseepu bɩlɩsa asɛ kɩyaafɔlɛ gyisa kʋsʋ tɩn. ");
INSERT INTO naw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Amaa nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Fan yɛgɛ kanɩn kɩwaa.” Nɩɩ Yesu taa mʋ kɩbaa mata ɔnyɩn mʋ kʋsʋ nɩɩ kɩ kyaga sʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nɩɩ Yesu taasɛ aseepu bɩlɩsa asɛ yɛ kabwaarɛ‐sunkpa akunpu abɩlɩsa yɛ kadɛ tɔ abɩlɩsa mʋ nɩɩ ba ba kɩtaa mʋ mʋ yɛ, “N gyɛ kumu tɔ ɔlʋn oyu nɩn nɩɩ fan sʋ isakunde yɛ agulungu kɛ fɛn ba kɔ yɛ mɛ? ");
INSERT INTO naw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kakɛ kʋmaa nɩmʋ maa fanɛ nɩn kabwaarɛ‐sunkpa ayɛ tɔ, nɩɩ fan man kɩtaa mɛ. Amaa ɩnɩmʋ ɩ gyɛ fanɛ saŋa fɛɛ Sɩtaanɛ kitentenbiri tɔ owura maa sun kusun.” ");
INSERT INTO naw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tʋtɔ nɩɩ ba kɩtaa Yesu, nɩɩ ba taa mʋ kpee Ɩbwaarɛ oseepu bɩlɩsa asɛ mʋ kɩkpaara sʋ. Nɩɩ Pita sii kamaa tɔ o buu bamʋ kɩyaa‐kɩyaa. ");
INSERT INTO naw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ba maa naa fʋʋ mʋ, ba dɛɛla fʋlɔn kɩkpaara mʋ nsana bɛɛ wʋlɛ, nɩɩ Pita naa sii kyɩna bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nɩɩ oseepu bɩlɩsa asɛ mʋ kibite wu Pita maa tɛ fʋlɔn mʋ asɛ. Ɔ kɩɩ mʋ diin nɩɩ ɔ tɔwɛ yɛ, “Ɔnyɩn nɩmʋ gbaa tii Yesu sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nɩɩ Pita kyɛɛ yɛ, “Ɔkyɩɩ, n man nyi mʋ kpini‐kpini.” ");
INSERT INTO naw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɩ maa waa kesin mʋ, ɔkʋ mɔɔ bɩla wu Pita nɩɩ ɔ yɛ, “Ngbaa fʋ, fʋ gyɛ bamʋ tɔ ɔkʋ.” Nɩɩ Pita lɛɛ kɔnɔ yɛ, “Ɔnyɩn n man tii su.” ");
INSERT INTO naw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Saŋa gbɛrɛɛ kamaa mʋ, nɩɩ ɔkʋ kyaga sʋ ɛɛ tɔwɛ yɛ, “Kesintin, ɩ man sʋ ɩmɔɔrɛ yɛ ɔnyɩn nɩmʋ man tii Yesu sʋ, lɩɩ fɛɛ ɔ gyɛ Galile obii nɩn.” ");
INSERT INTO naw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nɩɩ Pita tɔwɛ yɛ, “Ɔnyɩn, n man nyi asɩn mʋ nɩɩ fɩɩ tɔwɛ falɛ sʋ.” Saŋa mʋ nɩɩ ɔ tɔwɛ kanɩn mʋ, nɩɩ kyaasɛ bʋn. ");
INSERT INTO naw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tʋtɔ nɩɩ Yesu biliŋi kɩɩ Pita surum. Nɩɩ Pita nyiŋi asɩn mʋ nɩɩ Ɔnyɩrɩpɛ wʋla tɔwɛ mʋ yɛ, “Pɔyɩ kɛ kyaasɛ ɔ bʋn kɩbwayɩkɛ kɩnɩmʋ mʋ, fii biti fʋ kyɛɛ ɩlɩɩ ɩsa yɛ fʋ man nyi mɛ.” ");
INSERT INTO naw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nɩɩ Pita lɩɩ naa su gaa. ");
INSERT INTO naw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Asa mʋ nɩɩ Yesu bʋ bamʋ abaa tɔ mʋ, bee yooli mʋ yɛgɛ bɛɛ dayɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba waa Yesu kebunbun ansi, nɩɩ ba da‐da mʋ ɩtan nɩɩ ba yɛ, “Ɩbwaarɛ ɔtɔwɛpʋ, kaapʋ anɛ ɔmʋ nɩɩ ɔ da fʋ.” ");
INSERT INTO naw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nɩɩ ba saalɛ mʋ asebi gaalaagaa. ");
INSERT INTO naw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kayɩ maa kɛ mʋ, ɔsʋwʋlɛ abɩlɩsa yɛ aseepu bɩlɩsa yɛ nbara akaapʋpʋ ba ba gyaŋɛ nɩɩ ba taa Yesu ba bamʋ asɩn ogyikpa mʋ. ");
INSERT INTO naw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nɩɩ ba yɛ, “Tɔwɛ anɛ, fʋ ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “N kan tɔwɛ fanɛ gbaa fan mɛɛ yɛ fan kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nɩɩ n kan taasɛ fanɛ asɩn gbaa, fan mɛɛ yɛ fan lɛɛ mɛ asɩn maŋa kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amaa lɩɩ nbɩɩnbɩɩ nɩmʋ ɩɩ sʋ ii kpee mʋ, mɛ, Daadimaadi Obii‐nyɩnsa n biti n baa n tɛ Owura lala Ɔlʋnpʋ Ɩbwaarɛ gyisa sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nɩɩ bamʋ kpini ba taasɛ yɛ, “Kanɩn sʋ fʋ ɩ gyɛ Ɩbwaarɛ Mu‐Bii mʋ?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɩmʋ nɩɩ fan tɔwɛ maŋa.” ");
INSERT INTO naw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nɩɩ ba yɛ, “Mɩnɛ asɩn nɩɩ an bɩla an biti a nu tii sʋ? Lɩɩ fɛɛ an nu asɩn mʋ lɩɩ mʋ gbaa‐gbaa mʋ kɔnɔ tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nɩɩ kʋbʋ mʋ kpini ba kʋsʋ taa Yesu naa sa ɔsʋwʋlɛ ɔkɩɩsʋpʋ Paleti. ");
INSERT INTO naw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nɩɩ ba piili bɛɛ pwɩɩ mʋ asɩn nɩmʋ sʋ yɛ, “An wu kanyɩn nɩmʋ maa nyita anɛ asa yɛ ba man ka tʋʋtʋʋ sa Owura lala Kayisa. Nɩɩ ɛɛ tɩɩ mʋ n‐yɩɩ yɛ mʋ ɩ gyɛ Owura yɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tʋtɔ nɩɩ Paleti taasɛ Yesu yɛ, “Fʋ ɩ gyɛ Gyiwu abi owura mʋ?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɛɛhn, ɩmʋ nɩɩ fʋ tɔwɛ maŋa.” ");
INSERT INTO naw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nɩɩ Paleti tɔwɛ Ɩbwaarɛ aseepu bɩlɩsa mʋ yɛ kʋbʋ damantɛ mʋ yɛ, “N man wu ɔnyɩn nɩmʋ n‐yɩɩ sʋ asɩn pwɩɩsa akʋ.” ");
INSERT INTO naw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amaa ba mata sʋ yɛ, “Ɔ taa mʋ kɩkaapʋ mʋ tɔwɛ kʋsaa Gyiwu abi kpini nkɔlɔ. O piili lɩɩ Galile nɩn halɩɩ ba lɩɩ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paleti maa nu Galile kɩtɩɩ mʋ, nɩɩ ɔ taasɛ yɛ, “Kanyɩn maa gyɛ Kagalile‐nyɩn nɩn?” ");
INSERT INTO naw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Maa bɩɩ fɛɛ Yesu lɩɩ owura Herodi ɔsʋwʋlɛ sʋ mʋ, ɔ taa mʋ kpiya Herodi. Saŋa maa tɔ yɛgɛ ngbaa mʋ ɔ bʋ Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Owura Herodi maa wu Yesu mʋ, mu ansi i gyii gaa, lɩɩ fɛɛ ɔ wʋla ee biti mʋ kyɛɛrɛɛ yɛ o wu mʋ lɩɩ asɩn mʋ nɩɩ o nu lɩɩ mʋ sʋ mʋ. Ɔ sʋ tamaa fɛɛ o wu mʋ kɛ ɔ waa adangana kɛ o wu. ");
INSERT INTO naw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Owura mʋ taasɛ mʋ asɩn taasɛsa kɩkyɔ amaa Yesu man lɛɛ mʋ kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nɩɩ Ɩbwaarɛ aseepu bɩlɩsa yɛ nbara akaapʋpʋ mʋ ba maa sʋ ba yɩlɛ bɛɛ pwɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nɩɩ Herodi maa mʋ anaakɔpʋ bee yooli mʋ, nɩɩ ba ŋmasɛ mʋ. Nɩɩ ba taa kaalɛ bʋnswɩɩsa danbɩrasa kʋ bun mʋ, nɩɩ ba bwiiyaa mʋ kpee Paleti asɛ, ");
INSERT INTO naw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kanɩn kakɛ maŋa nɩɩ ɔsʋwʋlɛ ɔkɩɩsʋpʋ Paleti maa owura Herodi ba biliŋi akyɛmɩnɛpʋ. Naafɔɔ ba kyɩna ba gyɛ adʋn nɩn. ");
INSERT INTO naw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nɩɩ ɔsʋwʋlɛ ɔkɩɩsʋpʋ Paleti tɩɩ Ɩbwaarɛ aseepu bɩlɩsa mʋ yɛ kadɛ abɩlɩsa yɛ asa mʋ kpini ba gyaŋɛ. ");
INSERT INTO naw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fanɛ ɩ bɩya ɔnyɩn nɩmʋ yɛ, mʋ ɩ bɩya kʋsʋ tɔ ɔlʋn ɔsʋwʋlɛ nɩmʋ sʋ. Amaa n maa mɛɛgɛ mʋ asɩn mʋ tɔ fanɛ ansi tɔ nfɩɩ mʋ, n man wu fanɛ asɩn pwɩɩsa mʋ akʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Owura Herodi gbaa ɔ man wu alibi akʋ lɩɩ mʋ sʋ, nɩɩ o bwiiyaa mʋ bɩya anɛ. Kesintin tɔ mʋ, ɔnyɩn nɩmʋ man waa alibi mʋ nɩɩ ɩ dagaa lewu. ");
INSERT INTO naw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kanɩn sʋ n biti n yɛgɛ ba tɩŋɛ mʋ awʋlɛ‐bi kɛ n yɛgɛ mʋ ɔ natɛ. ");
INSERT INTO naw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Lɩɩ fɛɛ Kesu kɔnɔ kɔlɔŋɔ ngyaŋɛ kʋmaa mʋ, ɩ gyɛ dankaarɩ nɩn fɛɛ Paleti ɔ lɛɛ Gyiwu abi mʋ nɩɩ ba tii obu mʋ mʋ tɔ ɔkʋ sa bamʋ.)” ");
INSERT INTO naw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nɩɩ kʋbʋ damantɛ mʋ ba kuusi kɔnɔ kʋlʋn sʋ yɛ, “Fan taa ɔnyɩn maŋa naa mɔɔ, kɛ fan lɛɛ Barabasi sa anɛ.” ");
INSERT INTO naw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasi nɩmʋ tɔwɛ kʋsaa asa nkɔlɔ nɩɩ ba kɔ yɛ Roma kɩbanɛ, nɩɩ ɔ bɩla mɔɔ ɔsa kʋ ɩmʋ sʋ nɩɩ ba tii mʋ obu. ");
INSERT INTO naw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paleti maa biti yɛ ɔ lɛɛ Yesu sʋ mʋ, o bwii tɔwɛ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amaa ba maa sʋ bee kuusi yɛ, “Fan da mʋ oyu laasa sʋ, fan da mʋ oyu laasa sʋ!” ");
INSERT INTO naw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Paleti bwii tɔwɛ bamʋ asɛ kɩsasapʋ yɛ, “Mɩnɛ nɩn? Mɩnɛ alibi nɩɩ ɔnyɩn maŋa waa? N man wu alibi mʋ nɩɩ ɔ waa nɩɩ ɔ dagaa lewu. Kanɩn sʋ n biti n yɛgɛ ba tɩŋɛ mʋ awʋlɛ‐bi kɛ n yɛgɛ mʋ ɔ natɛ.” ");
INSERT INTO naw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amaa ba lɔŋɔ kuusi tɔ kenken fɛɛ ɔkpa kʋmaa sʋ mʋ ba da mʋ oyu laasa sʋ. Nɩɩ bamʋ kekuusi mʋ i gyii sʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ɩmʋ sʋ Paleti waa mʋ nfɛɛrɛ fɛɛ ɔ waa bamʋ kebiti. ");
INSERT INTO naw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kanɩn sʋ ɔmʋ nɩɩ ba tɔwɛ yɛ ɔ lɛɛ sa bamʋ mʋ, ɔ lɛɛ mʋ sa bamʋ. Mʋ ɩ gyɛ Barabasi mʋ nɩɩ ba tii mʋ obu lɩɩ mʋ kɩtɔwɛ kʋsaa asa nkɔlɔ nɩɩ ba kɔ yɛ kɩbanɛ, yɛ mʋ ɔsa kɩmɔɔ sʋ mʋ. Amaa nɩɩ ɔ taa Yesu sa bamʋ ba naa waa bamʋ kɔkɔlɔ biti. ");
INSERT INTO naw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ba maa sʋ bee kpee mʋ, ba gyaŋa Simon Kakereni‐nyɩn mʋ ɔ lɩɩ kukura ee loo Gyerusalem. Nɩɩ ba nyan mʋ nɩɩ ɔ sʋla oyu laasa mʋ o buu Yesu. ");
INSERT INTO naw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nɩɩ asa damantɛ kʋ ba buu mʋ, akyɩɩ mʋ nɩɩ bee su bɛɛ yɩyɛɛ bɛɛ sa mʋ mʋ gbaa ba tii sʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nɩɩ Yesu biliŋi tɔwɛ bamʋ yɛ, “Gyerusalem akyɩɩsa, fan man sʋ sa mɛ, fan su sa fanɛ n‐yɩɩ yɛ fanɛ‐bii ana. ");
INSERT INTO naw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Lɩɩ fɛɛ saŋa kʋ ii biti ɔ ba, kɛ ba tɔwɛ yɛ, ‘Kusee ɩ gyɛ sa agbentipu yɛ ɩtɔ mʋ nɩɩ ɩ man kʋʋgɛ kɩɩ abɛɛ anyɛpʋ mʋ nɩɩ nbii ba man nyɛpʋ.’ ");
INSERT INTO naw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nɩɩ saŋa maŋa tɔ mʋ, ‘bee biti ba tɔwɛ abɩɩ yɛ, “Fan tɩyɛ anɛ sʋ!” Kɛ ba tɔwɛ adenbi mɔɔ yɛ, “Fan bun anɛ sʋ!” ’ ");
INSERT INTO naw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nɩɩ ɩ gyɛ kanɩn nɩɩ ba sʋ bɛɛ waa oyu bunboli mʋ, nɛnɛ nɩɩ bee biti ba waa iyu wʋlɛsa mʋ?” ");
INSERT INTO naw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nɩɩ ba taa asun libi wuya ana anyɔ tii Yesu sʋ ba naa mɔɔ. ");
INSERT INTO naw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ba maa naa fʋʋ opula mʋ nɩɩ bɛɛ tɩɩ yɛ “Kumu Kɩwɛɛ mʋ”, nɩɩ ba da Yesu maa asun libi wuya ana mata iyu laasa sʋ. Ɔkʋ bʋ mʋ gyisa sʋ yɛgɛ ɔbanban mʋ mɔɔ bʋ mʋ bɩna sʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nɩɩ Yesu tɔwɛ yɛ, “Nsɛ, taa bamʋ alibi kɛɛ bamʋ, lɩɩ fɛɛ ba man nyi kʋtɔ mʋ nɩɩ bɛɛ waa.” Nɩɩ ba tʋʋ nbii barɩgɛ Yesu atɔ bunsa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Asa mʋ ba yɩlɛ tʋtɔ ba kɩɩ mʋ halɩɩ Gyiwu abi abɩlɩsa mʋ bɛɛ waa mʋ yɛrɛyɛrɛ bɛɛ tɔwɛ yɛ, “Ɔ mɔlɩgɛ akʋ, nɩɩ ɔ kan ɔ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ, ɔ mɔlɩgɛ mʋ n‐yɩɩ.” ");
INSERT INTO naw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nɩɩ anaakɔpʋ mʋ gbaa ba ba ŋmasɛ mʋ. Nɩɩ ba sa mʋ nta nyaŋɛsa. ");
INSERT INTO naw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nɩɩ ba tɔwɛ yɛ, “Nɩɩ fʋ gyɛ Gyiwu abi owura kesintin mʋ, mɔlɩgɛ fʋ n‐yɩɩ.” ");
INSERT INTO naw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nɩɩ ba kyʋrɔɔ asɩn kʋ mu amu sʋ yɛ, ƆNƖMƲ Ɩ GYƐ GYUDA ABI OWURA. ");
INSERT INTO naw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Asun libi wuya ana mʋ nɩɩ ba saa iyu laasa mʋ sʋ mʋ ɔkʋ piili ɛɛ saalɛ Yesu yɛ, “Man gyɛ fʋ ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ? Mɔlɩgɛ fʋ n‐yɩɩ kɛ fʋ mɔlɩgɛ anɛ?” ");
INSERT INTO naw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amaa ɔbanban mʋ pʋntɛ mʋ sʋ yɛ, “Fʋ man sɩlɛ Ɩbwaarɛ, fɛɛ kanan mʋ nɩɩ anɛ kpini an bʋ kʋsʋ bɩɩtɛ kʋlʋn tɔ falɛ? ");
INSERT INTO naw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Anɛ bɩrɛ ba bɩɩtɛ anɛ kʋsʋ kɩmʋ ɔkpa sʋ, fɛɛ asun libi mʋ nɩɩ an waa mʋ sʋ. Amaa ɔnyɩn nɩmʋ bɩrɛ ɔ man waa alibi akʋ.” ");
INSERT INTO naw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nɩɩ ɔ tɔwɛ yɛ, “Yesu, fʋ kan ba gyii fu kuwura mʋ, fu nyiŋi mɛ.” ");
INSERT INTO naw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nɩɩ Yesu lɛɛ mʋ kɔnɔ yɛ, “N tɔwɛ fʋ kesintin tɔ yɛ, ndaga kakɛ nɩmʋ fu biti fʋ kyɩna maa mɛ‐Sɛ, Ɩbwaarɛ asɛ Paradise tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ɩ kyɩna ɩ gyɛ kyɔwɛ amu nsana tɔ nɩn, nɩɩ kitentenbiri kɩ tɩyɛ ɔsʋwʋlɛ mʋ kpini sʋ naa fʋʋ kakyʋwapɛ kerefi asá saŋa, ");
INSERT INTO naw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","lɩɩ fɛɛ kyɔwɛ yɛgɛ kɩda. Nɩɩ kɩtaa kunsa mʋ nɩɩ kɩ barɩgɛ kabwaarɛ‐sunkpa opula kyɩrɛkyɩrɛkpa Kɩkyɩrɛkyɩrɛ mʋ tɔ mʋ, kɩ kyatɛ tɔ kɩnyɔ. ");
INSERT INTO naw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nɩɩ Yesu taa ɔbʋlɛ lala kuusi yɛ, “Nsɛ, n taa mɛ kala waa fʋ abaa tɔ.” Maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ, nɩɩ mʋ ɔfʋʋtɛ tɩn. ");
INSERT INTO naw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Anaakɔpʋ kɩlɩfa ɔkɩɩsʋpʋ maa wu atɔ mʋ nɩɩ ɩ waa mʋ, ɔ yɩn Ɩbwaarɛ nɩɩ ɔ tɔwɛ yɛ, “Kesintin, ɔnyɩn nɩmʋ ɩkpa i kyiigi.” ");
INSERT INTO naw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Asa mʋ nɩɩ ba ba gyaŋɛ tʋtɔ bɛɛ kɩɩ mʋ, ba maa wu atɔ mʋ nɩɩ ɩ waa mʋ, bamʋ kpini ba taa nkɔlɔ nyita sawʋ kpewu. ");
INSERT INTO naw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Amaa bamʋ nɩɩ be nyi Yesu mʋ, yɛ akyɩɩ mʋ nɩɩ ba buu mʋ lɩɩ Galile ɔsʋwʋlɛ sʋ ba mʋ, ba yɩlɛ kata gbɛrɛɛ bɛɛ kɩɩ atɔ mʋ nɩɩ ɩ waa maŋa kpini. ");
INSERT INTO naw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ɔnyɩn kʋ ɩ kyɩna ɔ bʋ tɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Gyosefu. Nɩɩ ɔ lɩɩ Gyuda kadɛ mʋ nɩɩ bɛɛ tɩɩ yɛ Arimatiya mʋ, nɩɩ ɔ gyɛ nyɩmɩsa mʋ nɩɩ mʋ ɩkpa i kyiigi nɩɩ ɔ sʋ bɛɛrɛɛ. Nɩɩ o tii Gyiwu abi kpini abɩlɩsa kʋbʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Amaa o man kyula bamʋ nfɛɛrɛ yɛ awaasa mʋ. Ɔ kyɩna ee gyoo Ɩbwaarɛ kuwura‐gyii mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nɩɩ o kpee Paleti asɛ naa kʋlɛ Yesu kibuni mʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nɩɩ ɔ saatɛ Yesu kibuni mʋ lɩɩ oyu laasa mʋ sʋ, nɩɩ ɔ taa kɩtaa fufuli maalɛ mʋ, nɩɩ ɔ taa mʋ naa pula kakyan mʋ nɩɩ ba baaŋɛ kɩfʋlɛ tɔ nɩɩ ba man pɩɩta pula ɔkʋ kɩmʋ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɩ kyɩna ɩ gyɛ kakɛ mʋ nɩɩ bɛɛ kʋʋla bamʋ n‐yɩɩ ba gyoo kakɛ fʋʋtɛsa akɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akyɩɩ mʋ nɩɩ ba buu Yesu lɩɩ Galile mʋ, ba buu Gyosefu nɩɩ ba naa wu kakyan mʋ, yɛ kanan mʋ nɩɩ ɔ taa Yesu kibuni mʋ pula mʋ. ");
INSERT INTO naw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nɩɩ ba kpewu naa kʋʋla atɔ liifensa yɛ ituulale mʋ nɩɩ ba taa ba sʋswa Yesu kibuni mʋ. Amaa ba taa bɛɛrɛɛ sa Mosesi nbara mʋ, nɩɩ ba fʋʋtɛ kakɛ fʋʋtɛsa kakɛ maŋa. ");
INSERT INTO naw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gyiwu abi kakɛ fʋʋtɛsa akɛ lɩɩkaakɛ kɩbwayɩkɛ mʋ, nɩɩ akyɩɩ mʋ ba taa atɔ liifensa mʋ nɩɩ ba kʋʋla yɩla mʋ kpee Yesu kakyan asɛ. ");
INSERT INTO naw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba naa wu fɛɛ kubuu mʋ nɩɩ ba taa tii kakyan mʋ, kɩ maa gbiliti lɩɩ kɩmʋ kɔnɔ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Amaa ba maa loo kakyan mʋ tɔ mʋ, ba man wu Ɔnyɩrɩpɛ Yesu kubuni mʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ɩ maa waa bamʋ kanankʋ nɩɩ ba yɩlɛ bɛɛ fɛ ɩmʋ nfɛɛrɛ mʋ, opula maŋa tɔ nɩɩ anyɩn anyɔ akʋ ba ba yɩlɛ bamʋ asɛ. Ba bun kɩkalala mʋ nɩɩ kɩɩ ŋalɩgɛ sʋ fɛɛ bʋlayɩ maa wɛɛ ɩsɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nɩɩ kufuu kɩ kɩtaa akyɩɩ mʋ gaa, nɩɩ ba nyɔn bamʋ amu yii tɔ. Nɩɩ anyɩn anyɔ mʋ ba taasɛ bamʋ yɛ, “Mɩnɛ ɩ waa nɩɩ fan baa fen biti nyɩmɩsa kɩɩsa lɩɩ alewupu tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɔ man bʋ nfɩɩ, o kyiŋi lɩɩ alewupu tɔ. Fan nyiŋi asɩn mʋ nɩɩ ɔ tɔwɛ fanɛ saŋa mʋ nɩɩ ɔ bʋ fanɛ asɛ Galile mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ɩ dagaa fɛɛ ba lɛɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ waa asa libi abaa tɔ, kɛ ba da mɛ oyu laasa sʋ mɔɔ, kɛ nkɛ nsa kamaa mʋ, n kyiŋi lɩɩ lewu tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tʋtɔ nɩɩ akyɩɩ mʋ ba nyiŋi mʋ asɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ba maa lɩɩ kakyan mʋ asɛ ba mʋ, ba tɔwɛ asɩn nɩmʋ kpini sa Yesu abɩɩlapʋ kudu akʋ mʋ yɛ asa mʋ nɩɩ ba san mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Akyɩɩ maŋa ɩ gyɛ Mɛɛrɩ Magidalen, Gyowana, Gyemisi mu‐nyi Mɛɛrɩ yɛ akyɩɩ akʋ, ɩ tɔwɛ kʋtɔ kʋmaa nɩmʋ sa abɩɩlapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amaa abɩɩlapʋ mʋ ba man kɔɔlɛ akyɩɩ mʋ asɩn mʋ gyii, lɩɩ fɛɛ bamʋ asɩn mʋ a du nɩn fɛɛ amelensi‐sɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Amaa Pita kʋsʋ sɩlɛ kpee kakyan mʋ asɛ. Maa suŋa kɩɩ kakyan mʋ tɔ mʋ, o wu kɩtaa fufuli mʋ nɩɩ ba taa maalɛ mʋ mʋ nkʋn. Nɩɩ ɔ fɛ ɩmʋ nfɛɛrɛ kʋtɔ mʋ nɩɩ kɩ waa nɩɩ o bwii kpewu. ");
INSERT INTO naw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kanɩn kakɛ maŋa mʋ, mʋ abɩɩlapʋ anyɔ ba kyɩna bee kpee Emawusi kadɛ tɔ. Lɩɩ Gyerusalem kpee tʋtɔ gyɛ ɩmaalɩ asunɔ. ");
INSERT INTO naw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba maa kyɩna ba naa bee kpee mʋ bɛɛ tɔwɛ abaa asɛ lɩɩ atɔ mʋ nɩɩ ɩ waa mʋ kpini sʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba maa tɔwɛ abaa asɛ nɩɩ bɛɛ waa kiligyima lɩɩ atɔ mʋ nɩɩ ɩ waa mʋ sʋ mʋ, Yesu gbaa‐gbaa ba bamʋ asɛ yɛgɛ maa bamʋ ba naa. ");
INSERT INTO naw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amaa Ɩbwaarɛ man yɛgɛ nɩɩ ba bɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ɔ taasɛ bamʋ yɛ, “Mɩnɛ kiligyima nɩɩ fan naa fen biri kanɩn?” Nɩɩ ba sii yɩlɛ nyaŋɛ bamʋ ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bamʋ tɔ ɔmʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Kelopasi mʋ taasɛ mʋ yɛ, “Fʋ nkʋn ɩ gyɛ ɔfɔ mʋ nɩɩ fʋ bʋ Gyerusalem nfɩɩ nɩɩ fʋ man nyi asɩn mʋ nɩɩ ɩ waa tʋtɔ nkɛ nnyɔ nɩmʋ tɔ?” ");
INSERT INTO naw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nɩɩ Yesu taasɛ bamʋ yɛ, “Mɩnɛ asɩn?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Lɩɩ Yesu Kanasareti‐nyɩn mʋ sʋ. Ɔ kyɩna ɔ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn, nɩɩ ɔlʋn bʋ mʋ atɔwɛsa yɛ mʋ awaasa kpini tɔ Ɩbwaarɛ yɛ asa kpini ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ɩbwaarɛ aseepu bɩlɩsa yɛ ɔsʋwʋlɛ akɩɩsʋpʋ ba taa mʋ sa yɛ ba mɔɔ nɩɩ ba da mʋ mata oyu laasa sʋ mɔɔ. ");
INSERT INTO naw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amaa naafɔɔ an kyɩna an sʋ tamaa fɛɛ mʋ ɩ gyɛ ɔmʋ nɩɩ ɛɛ ba ɔ ba kɔɔlɛ anɛ Ɩsɩrayɩ abi yɛgɛ. Kʋtɔ mʋ nɩɩ kɩ bɩlaa ki tii sʋ ɩ gyɛ yɛ, ndaga ɩ gyɛ kakɛ sasapʋ nɩɩ asɩn nɩmʋ a maa waa. ");
INSERT INTO naw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɩmʋ nɩɩ ɩ bɩla i tii sʋ ɩ gyɛ yɛ, anɛ akyɩɩ mʋ akʋ ba yɛgɛ nɩɩ i kyinkyin anɛ. Ba kpee kakyan mʋ asɛ naa loo to nyenyenfuu nɩmʋ, ");
INSERT INTO naw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","amaa ba man wu mu kibuni mʋ. Ba ba tɔwɛ anɛ yɛ ba nyɛ ansi sʋ kɩlɛɛkaapʋ nɩɩ ba wu Ɩbwaarɛ n bɔɔ ba maa tɔwɛ bamʋ yɛ Yesu bʋ nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nɩɩ anɛ tɔ akʋ ba kpee kakyan mʋ tɔ nɩɩ ba naa wu kanan mʋ nɩɩ akyɩɩ mʋ ba ba tɔwɛ mʋ, amaa ba man wu mʋ.” ");
INSERT INTO naw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Mɩnɛ kimelensi ndee? Mɩnɛ ɩ waa nɩɩ fanɛ nfɛɛrɛ i du swɩɩ‐swɩɩ kanɩn, nɩɩ fan mɛɛ kɔɔlɛ asɩn mʋ nɩɩ Ɩbwaarɛ atɔwɛpʋ ba wʋla tɔwɛ yɩla mʋ gyii bilen? ");
INSERT INTO naw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yɛ ɩ dagaa fɛɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ o gyii falɛ awʋrʋfɔ pɔyɩ kɛ o loo mʋ bʋnyaa tɔ?” ");
INSERT INTO naw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nɩɩ Yesu maa piili lɩɩ Mosesi nbara yɛ Ɩbwaarɛ atɔwɛpʋ kɩkaapʋ mʋ sʋ mʋ, ɔ lɛɛ asɩn mʋ nɩɩ Asɩnkyan yɩlasa mʋ kpini ɩ tɔwɛ lɩɩ mʋ sʋ mʋ kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ba maa tiri kadɛ‐bi mʋ nɩɩ bee kpee mʋ tɔ mʋ, nɩɩ Yesu waa fɛɛ maa biti ɔ kyʋn kadɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amaa ba kʋlɛ mʋ gaa tɔwɛ yɛ, “Dɛ anɛ asɛ, lɩɩ fɛɛ saŋa kyʋn, kyɔwɛ lʋwɛ.” Ɩmʋ sʋ o loo naa kyɩna bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Saŋa mʋ nɩɩ maa bamʋ ba kyɩna kɛ ba gyii mʋ, ɔ taa bodobodo nɩɩ ɔ fwaala Ɩbwaarɛ, nɩɩ ɔ kpɛɛ kɩmʋ tɔ nɩɩ ɔ taa sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tʋtɔ nɩɩ bamʋ ansi i bugi nɩɩ ba bɩɩ mʋ, nɩɩ ɔ nyaa bamʋ ansi sʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nɩɩ ba taasɛ abaa yɛ, “Saŋa mʋ nɩɩ anaa mʋ an naa ɔkpa tɔ nɩɩ ɛɛ tɔwɛ ɛɛ sa anɛ nɩɩ ɛɛ lɛɛ Ɩbwaarɛ Asɩnkyan yɩlasa mʋ ɛɛ kaapʋ anɛ mʋ, anɛ n‐yɩɩ ɩ man dii anɛ?” ");
INSERT INTO naw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nɩɩ ba kʋsʋ bwii kpee Gyerusalem bilen. Tʋtɔ maŋa nɩɩ ba naa wu kudu ɔkʋ mʋ yɛ asa mʋ nɩɩ ba bʋ bamʋ asɛ mʋ ba maa gyaŋɛ, ");
INSERT INTO naw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","nɩɩ bɛɛ tɔwɛ yɛ, “Ɩ gyɛ kesintin nɩn yɛ Ɔnyɩrɩpɛ mʋ kyiŋi nɩɩ ɔ lɛɛ mʋ n‐yɩɩ kaapʋ Simon.” ");
INSERT INTO naw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tʋtɔ nɩɩ asa anyɔ mʋ gbaa ba tɔwɛ kʋtɔ mʋ nɩɩ kɩ waa ɔkpa tɔ yɛ kanan mʋ nɩɩ ba bɩɩ Yesu saŋa mʋ nɩɩ ɔ kpɛɛ bodobodo mʋ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ba maa san ba yɩlɛ bɛɛ tɔwɛ falɛ asɩn mʋ, nɩɩ Yesu gbaa‐gbaa ba yɩlɛ bamʋ tɔ, nɩɩ ɔ tɔwɛ yɛ, “Keyuula kɩ ba fanɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bamʋ nkɔlɔ n ŋmaa bamʋ nɩɩ kufuu kɩ kɩtaa bamʋ, nɩɩ ba fɛ nfɛɛrɛ fɛɛ ba wu obuni nɩn. ");
INSERT INTO naw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Mɩnɛ ɩ waa nɩɩ ɩ tɔɔrɔɔ fanɛ, nɩɩ mɩnɛ ɩ waa nɩɩ fan san fen gyii ɩmɔɔrɛ fanɛ nfɛɛrɛ tɔ? ");
INSERT INTO naw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Fan kɩɩ mɛ abaa yɛ mɛ ayaa. Man gyɛ mɛ nɩn abɛɛ? Fan mata mɛ kɛ fan kɩɩ, obuni man sʋ kayɩɩ‐wʋlɛ yɛ awuya, fɛɛ kanan mʋ nɩɩ n sʋ falɛ?” ");
INSERT INTO naw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Maa tɔwɛ falɛ lʋwɛ mʋ, ɔ taa mʋ abaa yɛ mʋ ayaa kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ba maa man pɩɩta kɔɔlɛ mʋ gyii lɩɩ kensi‐gyii yɛ adangana nɩmʋ sʋ mʋ, ɔ taasɛ bamʋ yɛ “Fan sʋ agyitɔ kʋ nfɩɩ fan gyii?” ");
INSERT INTO naw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nɩɩ ba taa ɔkɩn ŋasɩsa kɩdɩyɛ sa mʋ, ");
INSERT INTO naw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","nɩɩ ɔ kɔɔlɛ kɩmʋ wɛ bamʋ ansi tɔ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ɔ tɔwɛ bamʋ yɛ, “Saŋa mʋ nɩɩ n kyɩna n bʋ fanɛ asɛ mʋ, n tɔwɛ fanɛ asɩn nɩmʋ yɛ, asɩn kʋmaa mʋ nɩɩ ba kyʋrɔɔ yɩla lɩɩ mɛ sʋ, Mosesi nbara tɔ yɛ Ɩbwaarɛ atɔwɛpʋ kɩkaapʋ yɛ Ɩlʋn mʋ tɔ mʋ, ɩ dagaa fɛɛ ɩ maa ba tɔ.” ");
INSERT INTO naw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nɩɩ o bugi bamʋ nfɛɛrɛ kɛ ba nyɛ nu Asɩnkyan yɩlasa mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ɔ tɔwɛ bamʋ yɛ, “Asɩn mʋ ɩ tɔwɛ yɛ, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ ii biti o gyii awʋrʋfɔ kɛ o wu, kɛ o kyiŋi lɩɩ alewupu tɔ kakɛ sasapʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nɩɩ ɩ dagaa fɛɛ ba tɔwɛ Asɩn danbɩrasa mʋ sa asa kpini mʋ kɩtɩɩ tɔ, kɛ asa ba kyɛɛgɛ bamʋ nfɛɛrɛ lɩɩ alibi tɔ ba Ɩbwaarɛ asɛ kɛ ɔ taa bamʋ alibi kɛɛ bamʋ. Nɩɩ ɩ dagaa fɛɛ ba piili asɩn nɩmʋ kɩtɔwɛ lɩɩ Gyerusalem kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Fanɛ ɩ gyɛ kesintin agyipu lɩɩ atɔ nɩmʋ kpini sʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","N biti n bɩya fanɛ Kayaayu Kyɩrɛkyɩrɛ mʋ nɩɩ mɛ‐Sɛ kyɩna da mʋ kɔkɔlɔ sʋ yɛ ee biti ɔ sa fanɛ mʋ. Amaa fan kyɩna kadɛ lala nɩmʋ tɔ naa fʋʋ saŋa mʋ nɩɩ Kayaayu mʋ ɔlʋn mʋ ii biti ɔ lɩɩ sʋsʋ ba fanɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu maa taa mʋ abɩɩlapʋ mʋ lɩɩ Gyerusalem kadɛ tɔ bee kpee naa tiri Betani kadɛ tɔ. Tʋtɔ nɩɩ ɔ kʋsaa mʋ abaa sʋsʋ nɩɩ, ɔ waa bamʋ kusee. ");
INSERT INTO naw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Maa dan san ɛɛ waa bamʋ kusee maŋa nɩɩ Ɩbwaarɛ taa mʋ lɩɩ bamʋ asɛ kpee sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nɩɩ ba muŋa sun mʋ nɩɩ ba taa kensi‐gyii lala bwii kpee Gyerusalem kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nɩɩ ba kyaga sʋ kyɩna kabwaarɛ‐sunkpa ayɛ mʋ tɔ bɛɛ yɩn Ɩbwaarɛ.");
INSERT INTO naw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lɩɩ npiili asɛ, pɔyɩ kɛ Ɩbwaarɛ ɔ tʋʋ dulinyaa mʋ, ɔmʋ nɩɩ ɔ gyɛ Ɩbwaarɛ kɔnɔ tɔ Asɩn mʋ bʋ tɔ. Nɩɩ Ɩbwaarɛ Kɔnɔ tɔ Asɩn mʋ maa Ɩbwaarɛ ɩ bʋ tɔ, nɩɩ Kɔnɔ tɔ Asɩn maŋa ɩ gyɛ Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lɩɩ koo npiili asɛ mʋ, Kɔnɔ tɔ Asɩn mʋ maa Ɩbwaarɛ ɩ bʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kɔnɔ tɔ Asɩn mʋ sʋ nɩɩ ɔ bɔla tʋʋ kʋtɔ kʋmaa. Sɛhn man bʋ tɔ nɩɩ man gyɛ mʋ kɔnɔ tɔ Asɩn mʋ sʋ nɩɩ ɔ bɔla sʋ tʋʋ kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ɩbwaarɛ Kɔnɔ tɔ Asɩn mʋ tɔ nɩɩ nkpa ɩ bʋ, nɩɩ nkpa maŋa ɩɩ ŋmaŋɛ tɔ ɩɩ sa asa kpini. ");
INSERT INTO naw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kaŋmaŋɛ mʋ ɩɩ ŋmaŋɛ kitentenbiri tɔ, nɩɩ kitentenbiri mʋ man taalɛ dunla kaŋmaŋɛ mʋ kakaakʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɔnyɩn kʋ kyɩna ɔ bʋ tɔ, nɩɩ Ɩbwaarɛ sun mʋ, bɛɛ tɩɩ mʋ yɛ Gyɔn. ");
INSERT INTO naw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Gyɔn ba nɩn ɔ ba tɔwɛ kesintin asɩn lɩɩ kaŋmaŋɛ mʋ sʋ sa asa, kɛ ɔkʋmaa nɩmʋ ɔ nyɛ nu kɛ ɔ kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Man gyɛ Gyɔn gbaa‐gbaa ɩ gyɛ kaŋmaŋɛ mʋ, mɛɛ mʋ ba nɩn kɛ ɔ ba tɔwɛ asɩn lɩɩ kaŋmaŋɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kesintin kaŋmaŋɛ mʋ nɩɩ kɩɩ ŋmaŋɛ sa asa kpini mʋ, kɩɩ ba dulinyaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dulinya nɩmʋ tɔ nɩɩ Ɩbwaarɛ kɔnɔ tɔ Asɩn mʋ wʋla ɔ bʋ. Nɩɩ mʋ sʋ nɩɩ Ɩbwaarɛ bɔla tʋʋ dulinyaa mʋ, nkɛɛ dulinyaa asa ba man bɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔ ba mʋ gbaa‐gbaa mʋ ɔsʋwʋlɛ sʋ, amaa mʋ gbaa‐gbaa asa ba man kɔɔlɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amaa asa mʋ nɩɩ ba kɔɔlɛ mʋ, nɩɩ ba kɔɔlɛ mʋ gyii mʋ kpini mʋ, ɔ sa bamʋ ɔkpa yɛ ba be biliŋi Ɩbwaarɛ mu‐bii ana. ");
INSERT INTO naw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ba man biliŋi mu‐bii ana bɔla nyɩmɩsa kakʋʋgɛ sʋ, abɛɛ nyɩmɩsa kɔkɔlɔ biti sʋ, abɛɛ ɔnyɩn kebiti sʋ. Amaa Ɩbwaarɛ gbaa‐gbaa ɩɩ yɛgɛ nɩɩ ba be biliŋi mu‐bii ana. ");
INSERT INTO naw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nɩɩ Ɔmʋ nɩɩ ɔ gyɛ Ɩbwaarɛ Kɔnɔ tɔ Asɩn mʋ ba biliŋi nyɩmɩsa, nɩɩ ɔ ba kyɩna anɛ asɛ kasɛ sʋ. An wu mʋ bʋnyaa kparɛ, mʋ nɩɩ ɩ kaapʋ fɛɛ, mʋ ɩ gyɛ Ɩbwaarɛ Mu‐Bii kʋlʋn kpen mʋ. Nɩɩ kabwaala yɛ kesintin kɩ bɔla mʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mʋ asɩn nɩɩ Gyɔn daa ɛɛ tɔwɛ ɛɛ kaapʋ tɔ, nɩɩ ɔ lɛɛ kɔnɔ kenken yɛ, “Ɔnɩmʋ asɩn nɩɩ n wʋla tɔwɛ fanɛ, nɩɩ n tɔwɛ yɛ, ‘Ɔmʋ nɩɩ ɔ bʋ mɛ kamaa tɔ ɛɛ ba mʋ kyɔ mɛ, nɩɩ ɔ wʋla ɔ bʋ tɔ pɔyɩ nɩɩ ba kʋʋgɛ mɛ mʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Lɩɩ mʋ kabwaala mʋ nɩɩ kɩ bɔla mʋ tɔ gaa sʋ mʋ, anɛ kpini an nyɛ kusee kʋkyɔ‐kʋkyɔ. ");
INSERT INTO naw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ɩbwaarɛ bɔla Mosesi sʋ taa nbara mʋ sa. Amaa kabwaala yɛ kesintin bɩrɛ bɔla Yesu Krisito sʋ nɩn ba. ");
INSERT INTO naw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nɩɩ ɔkʋ man pɩɩta wu Ɩbwaarɛ kakaakʋ, amɔɔ mu‐bii kʋlʋn mʋ nɩɩ ngbaa mʋ ɔ gyɛ Ɩbwaarɛ, nɩɩ ɔ bʋ Ɩbwaarɛ asɛ mʋ, ɩ lɛɛ Ɩbwaarɛ kedubi kaapʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nɩɩ Gyiwu abi alʋnpʋ mʋ nɩɩ ba bʋ Gyerusalem mʋ ba sun Ɩbwaarɛ aseepu yɛ Lewi abi Gyɔn asɛ ba naa taasɛ mʋ yɛ, “Fʋ ɩ gyɛ anɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nɩɩ Gyɔn man kina kɩtɔwɛ, amaa ɔ tɔwɛ bugi tɔ yɛ, “Man gyɛ mɛ ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nɩɩ ba taasɛ mʋ yɛ, “Kanɩn bɩrɛ, anɩmʋ ɩ gyɛ fʋ? Fʋ ɩ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ Eligya mʋ?” Nɩɩ ɔ yɛ, “Ayee! Man gyɛ mɛ ɩ gyɛ Eligya.” Nɩɩ ba bɩla taasɛ mʋ yɛ, “Fʋ ɩ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ mʋ nɩɩ an kɩɩ mʋ ɔkpa mʋ?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ayee.” ");
INSERT INTO naw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɩmʋ kamaa mʋ ba bɩla taasɛ yɛ, “Anɩmʋ bɩrɛ ɩ gyɛ fʋ? Lɛɛ kɔnɔ sa anɛ, kɛ a nyɛ asɩn kʋ naa tɔwɛ bamʋ nɩɩ ba sun anɛ mʋ. Ɔsa mɔɔ bɩrɛ gbaa ɩ gyɛ fʋ?” ");
INSERT INTO naw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nɩɩ Gyɔn lɛɛ kɔnɔ yɛ, “Mɛ ɩ gyɛ ɔbʋlɛ mʋ nɩɩ kii kuusi ofuli sʋ yɛ, ‘Fan kyiigi ɔkpa mʋ sa Ɔnyɩrɩpɛ mʋ.’ Falɛ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Isaya kyʋrɔɔ yɩla Ɩbwaarɛ asɩn mʋ tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nɩɩ Farasii abi akʋ ba sun nbɔɔ Gyɔn asɛ, ");
INSERT INTO naw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ba naa taasɛ mʋ yɛ, “Fʋ maa man gyɛ Krisito mʋ, abɛɛ Eligya, abɛɛ Ɩbwaarɛ ɔtɔwɛpʋ mʋ, mɩnɛ ɩ waa sʋ nɩɩ fii gyee asa Ɩbwaarɛ kekyugyee?” ");
INSERT INTO naw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Gyɔn lɛɛ bamʋ kɔnɔ yɛ, “N sʋ nkyu nɩn n gyee asa Ɩbwaarɛ kekyugyee. Amaa ɔkʋ yɩlɛ fanɛ tɔ nɩɩ fan man nyi mʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mʋ ɩ gyɛ ɔmʋ nɩɩ ɔ bʋ mɛ kamaa tɔ ɛɛ ba mʋ. Amaa n man dagaa gbaa n saŋɛ mʋ asɩbɩta ɩfɛ.” ");
INSERT INTO naw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Asɩn nɩmʋ kpini ɩ waa Betani kadɛ tɔ nɩn. Betani bʋ Gyɔdan ɔbʋn benbe kyɔwɛ ɔlɩɩkpa, katɩn mʋ nɩɩ Gyɔn ii gyee asa Ɩbwaarɛ kekyugyee mʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ɩmʋ lɩɩkaakɛ Gyɔn maa wu Yesu maa naa ɛɛ ba mʋ asɛ mʋ, ɔ tɔwɛ yɛ, “Fan kɩɩ, ɔnɩmʋ ɩ gyɛ Ɩbwaarɛ kabʋlʋpʋ, mʋ nɩɩ ee biti ɔ taa mʋ n‐yɩɩ lɛɛ saraga kɛ asa kpini ba nyɛ alibi kɩtaakɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɔnɩmʋ ɩ gyɛ ɔmʋ nɩɩ n wʋla n tɔwɛ mʋ asɩn yɛ, ‘Ɔnyɩn kʋ bʋ mɛ kamaa ɛɛ ba, nɩɩ ɔ kyɔ mɛ, lɩɩ fɛɛ ɔ wʋla ɔ bʋ tɔ pɔyɩ nɩɩ ba kʋʋgɛ mɛ.’ ");
INSERT INTO naw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mɛ gbaa‐gbaa mɛ bɩrɛ n man n daa n nyi mʋ, amaa kʋtɔ mʋ sʋ nɩɩ Ɩbwaarɛ sun mɛ yɛ n ba gyee asa Ɩbwaarɛ kekyugyee mʋ, kɛ n ba nyɛ lɛɛ mʋ ifuli kaapʋ Ɩsɩrayɩ abi mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nɩɩ Gyɔn gyii ɩmʋ kesintin tɔwɛ yɛ, “N wu Kayaayu Kyɩrɛkyɩrɛ mʋ kɩ maa kpɩlɩgɛ lɩɩ sʋsʋ fɛɛ kuwura‐lɔpɔ nɩɩ kɩ ba kyɩna sii mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Naafɔɔ ngbaa mɛ n man n wʋla n nyi mʋ, amaa Ɩbwaarɛ mʋ nɩɩ o sun mɛ yɛ n ba gyee asa Ɩbwaarɛ kekyugyee mʋ, ɩ tɔwɛ mɛ yɛ, ‘Ɔmʋ nɩɩ fʋ kan wu mɛ Kayaayu kɩ maa kpɩlɩgɛ lɩɩ sʋsʋ ba kyɩna sii mʋ sʋ mʋ, mʋ ɩ gyɛ ɔmʋ nɩɩ ee biti ɔ taa mɛ Kayaayu mʋ gyee asa.’ ");
INSERT INTO naw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","N wu ɩnɩmʋ kpini nɩɩ n gyii ɩmʋ kesintin yɛ ɔnɩmʋ ɩ gyɛ Ɩbwaarɛ Mu‐Bii mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lɩɩkaakɛ mʋ, Gyɔn maa mʋ abɩɩlapʋ anyɔ ba bɩla ba yɩlɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Maa wu Yesu maa naa ɛɛ kyʋn mʋ, ɔ tɔwɛ yɛ, “Fan kɩɩ, Ɩbwaarɛ Kabʋlʋpʋ mʋ ndee!” ");
INSERT INTO naw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gyɔn abɩɩlapʋ anyɔ mʋ ba maa nu maa tɔwɛ kanɩn mʋ, nɩɩ ba buu Yesu. ");
INSERT INTO naw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu maa biliŋi kɩɩ mʋ, o wu ba maa buu mʋ, nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ nɩɩ fen biti?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Rabi, fɩnɛ nɩɩ fʋ tɛ?” (Rabi kasɛ ɩ gyɛ yɛ Ɔkaapʋpʋ). ");
INSERT INTO naw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu tɔwɛ bamʋ yɛ, “Fan ba kɩɩ katɩn mʋ nɩɩ n tɛ.” Ɩmʋ sʋ ba buu mʋ naa wu katɩn mʋ nɩɩ ɔ tɛ. Saŋa maŋa tɔ gyɛ kalaatɩpwɛ sʋ kerefi ana tɔ. Nɩɩ ba kyɩna mʋ asɛ kakɛ maŋa. ");
INSERT INTO naw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Asa anyɔ mʋ nɩɩ ba nu asɩn mʋ nɩɩ Gyɔn tɔwɛ, nɩɩ ba buu Yesu mʋ, bamʋ tɔ ɔkʋ ɩ gyɛ Simon Pita mu‐supu Andiruwu. ");
INSERT INTO naw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kʋtɔ mʋ nɩɩ Andiruwu gyankpaa waa ɩ gyɛ yɛ, o biti mʋ‐daa Simon nɩɩ ɔ tɔwɛ mʋ yɛ, “An wu Mesaya mʋ.” Mesaya mʋ kasɛ ɩ gyɛ yɛ, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ yɛ ɔ ba mɔlɩgɛ asa. ");
INSERT INTO naw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nɩɩ Andiruwu taa mʋ‐daa Simon kpee Yesu asɛ. Yesu kɩɩ mʋ, nɩɩ ɔ tɔwɛ mʋ yɛ, “N nyi fɛɛ fʋ ɩ gyɛ Simon, Gyɔn mu‐bii‐nyɩnsa mʋ. Amaa bee biti ba tɩɩ fʋ yɛ Kefasi” (Giriki katɔwɛ tɔ ɩ gyɛ yɛ Pita, nɩɩ kɩmʋ kasɛ ɩ gyɛ yɛ kɩfʋlɛ.) ");
INSERT INTO naw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ɩmʋ lɩɩkaakɛ mʋ, Yesu waa nfɛɛrɛ fɛɛ ee biti o kpee Galile ɔsʋwʋlɛ sʋ. O wu Filipu, nɩɩ ɔ tɔwɛ mʋ yɛ, “Ba buu mɛ!” ");
INSERT INTO naw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi lɩɩ Betisayida kadɛ tɔ nɩn tʋtɔ nɩɩ Andiruwu maa Pita gbaa ba lɩɩ. ");
INSERT INTO naw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nɩɩ Filipu wu Nataneli nɩɩ ɔ tɔwɛ mʋ yɛ, “An wu ɔmʋ nɩɩ Mosesi wʋla kyʋrɔɔ mʋ asɩn waa Nbara ɩwʋlɛ tɔ, nɩɩ Ɩbwaarɛ atɔwɛpʋ gbaa ba kyʋrɔɔ mʋ asɩn yɩla mʋ. Mʋ ɩ gyɛ Yesu, Gyosefu nɩɩ ɔ lɩɩ Nasareti kadɛ tɔ mʋ mu‐bii.” ");
INSERT INTO naw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nɩɩ Nataneli taasɛ mʋ yɛ, “Amɔɔ, kʋtɔ danbɩrasa kʋ ɩ taalɛ lɩɩ Nasareti kadɛ tɔ?” Tʋtɔ nɩɩ Filipu tɔwɛ mʋ yɛ, “Ba kɩɩ.” ");
INSERT INTO naw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu maa wu Nataneli maa naa ɛɛ ba mʋ asɛ mʋ, ɔ tɔwɛ yɛ, “Kesintin tɔ, Ɩsɩrayɩ ɔnyɩn gbaa‐gbaa ndee, nɩɩ antɩŋɛsa kʋ man bʋ mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nɩɩ Nataneli taasɛ Yesu yɛ, “Nɛnɛ nɩɩ fʋ waa fii nyi mɛ?” Yesu lɛɛ mʋ kɔnɔ yɛ, “N wu fʋ saŋa mʋ nɩɩ fʋ bʋ figi onyin tɔ, pɔyɩ nɩɩ Filipu tɩɩ fʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nɩɩ Nataneli tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, fʋ ɩ gyɛ Ɩbwaarɛ Mu‐Bii mʋ! Nɩɩ fʋ ɩ bɩla fʋ gyɛ Ɩsɩrayɩ abi Owura mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tʋtɔ nɩɩ Yesu tɔwɛ mʋ yɛ, “N maa tɔwɛ fʋ yɛ, n wu fʋ fʋ maa bʋ figi onyin tɔ sʋ nɩɩ fʋ kɔɔlɛ gyii? Fii biti fʋ ba wu atɔ damantɛ mʋ nɩɩ ɩ kyɔ ɩnɩmʋ gbaa.” ");
INSERT INTO naw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nɩɩ Yesu bwii kyaga sʋ yɛ, “N tɔwɛ fanɛ kesintin yɛ, fanɛ kpini fen biti fan wu sʋsʋ maa bugi tɔ, kɛ Ɩbwaarɛ nbɔɔ ba ba bee dii bɛɛ kpɩlɩgɛ mɛ, Daadimaadi Obii‐nyɩnsa sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nkɛ nsa kamaa mʋ, ba kpɩɩ ɔkyɩɩfɔ Kena kadɛ tɔ Galile Ɔsʋwʋlɛ sʋ. Yesu mu‐nyi bʋ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nɩɩ ba da kɩbaa tɔ tɩɩ Yesu maa mʋ abɩɩlapʋ gbaa kɩkyɩɩfɔ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Saŋa mʋ nɩɩ nta ɩ pwagɛ bamʋ mʋ, Yesu mu‐nyi tɔwɛ mʋ yɛ, “Bamʋ nta ɩ lʋwɛ.” ");
INSERT INTO naw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɔkyɩɩ, man tɔwɛ mɛ kʋtɔ mʋ nɩɩ n waa. Mɛ saŋa man pɩɩ fʋʋ.” ");
INSERT INTO naw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nɩɩ mu‐nyi tɔwɛ nta ayɛpʋ mʋ yɛ, “Kʋtɔ kʋmaa mʋ nɩɩ ɔ tɔwɛ fanɛ yɛ fan waa mʋ, fan waa.” ");
INSERT INTO naw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nɩɩ nkyu afʋlɛ alan asiye ɩ yɩlɛ tʋtɔ, ɩmʋ nɩɩ ba sʋ bɛɛ waa Gyiwu abi anaana‐tɔ ineesi kɩfwɩɩ. Nɩɩ kʋfʋlɛ kɩlan kʋmaa kɩ taalɛ gyii ɩgalɔn adʋnyɔ abɛɛ adɩsa. ");
INSERT INTO naw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nɩɩ Yesu tɔwɛ nta ayɛpʋ mʋ yɛ, “Fan saa nkyu bɔla alan mʋ kpini.” Ɩmʋ sʋ ba saa nkyu bɔla alan mʋ kpini bɩlɩbɩlɩ. ");
INSERT INTO naw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nɩɩ ɔ tɔwɛ ba mʋ yɛ, “Fan nyɛ ɩmʋ ɩkʋ naa sa nta ayɛpʋ ɔbɩlɩsa mʋ.” Nɩɩ ba waa kanɩn. ");
INSERT INTO naw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nta ayɛpʋ ɔbɩlɩsa mʋ maa daa nuu nkyu mʋ nɩɩ i biliŋi nta mʋ kɩɩ mʋ, o wu fɛɛ ɩ bʋrɔn. Ɔ man nyi katɩn mʋ nɩɩ ɩ lɩɩ, amaa ayɛpʋ mʋ nɩɩ ba saa nkyu mʋ bɩrɛ be nyi. Nɩɩ ɔ tɩɩ ɔkyɩɩfɔ mu‐kuli mʋ lɩɩ ɩkaa sʋ. ");
INSERT INTO naw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nɩɩ ɔ tɔwɛ mʋ yɛ, “Ɔkʋmaa nɩmʋ ɩ daa kɩlɛɛ nta danbɩrasa pɔyɩ. Nɩɩ saŋa mʋ nɩɩ ɔkʋmaa nɩmʋ nuu bʋʋ mʋ, kɛ ɔ lan bɩya nta mʋ nɩɩ ɩ man bʋrɔn mʋ. Amaa fʋ taa ɩmʋ nɩɩ ɩ bʋrɔn yɩla ba fʋʋ saŋa nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ɩnɩmʋ ɩ gyɛ asɩn kyinkyinsa gyankpaasa mʋ nɩɩ Yesu waa. Ɔ waa ɩmʋ Kena kadɛ tɔ Galile ɔsʋwʋlɛ sʋ. Tʋtɔ nɩɩ ɔ lɛɛ mʋ bʋnyaa mʋ kaapʋ. Nɩɩ mʋ abɩɩlapʋ mʋ ba kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ɩnɩmʋ kamaa mʋ maa mu‐nyi yɛ mu‐supu ana yɛ mʋ abɩɩlapʋ ba lɩɩ tʋtɔ kpee Kapanum kadɛ tɔ. Nɩɩ ba kyɩna tʋtɔ nkɛ nkʋ. ");
INSERT INTO naw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Saŋa mʋ nɩɩ Gyiwu abi Kesu kɔnɔ Kanyaŋɛ nbunɔ kɩ san gbɛrɛɛ kɩ fʋʋ mʋ, Yesu kpee Gyerusalem kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Maa fʋʋ tʋtɔ mʋ, nɩɩ o kpee kabwaarɛ‐sunkpa opula mʋ tɔ. Nɩɩ o wu anyɩn akʋ ba maa fɛ ɩnaatɛ, yɛ nbʋlʋpʋ yɛ awura‐lɔpɔ yɛgɛ akʋ mɔɔ ba tɛ iteeburu asɛ bɛɛ kyɛrɛ afulee. ");
INSERT INTO naw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nɩɩ ɔ taa ɔfɛ waa kʋkyʋkyʋʋ gyan bamaa bamʋ ɩnaatɛ yɛ nbʋlʋpʋ lɩɩ kabwaarɛ‐sunkpa opula. Nɩɩ ɔ yasɛ bamʋ afulee abi tɔ, nɩɩ ɔ bala bamʋ iteeburu bun. ");
INSERT INTO naw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nɩɩ ɔ tɔwɛ bamʋ nɩɩ bɛɛ fɛ awura‐lɔpɔ mʋ yɛ, “Fan lɛɛ bamʋ lɩɩ nfɩɩ. Fan man taa Mɛ‐Sɛ ayɛ biliŋi kɩgya ogyikpa.” ");
INSERT INTO naw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nɩɩ mʋ abɩɩlapʋ mʋ ba nyiŋi Asɩnkyan yɩlasa mʋ nɩɩ ɩɩ tɔwɛ yɛ, “Kebiti mʋ nɩɩ n sʋ sa kabwaarɛ‐sunkpa ayɛ mʋ kii gyii mi kumu.” ");
INSERT INTO naw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nɩɩ Gyiwu abɩlɩsa mʋ ba taasɛ mʋ yɛ, “Mɩnɛ asɩn kyinkyinsa nɩɩ fɩɩ taalɛ waa kaapʋ anɛ, kɛ ɩ kaapʋ fɛɛ fʋ sʋ ɔkpa fʋ waa ɩnɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nɩɩ Yesu lɛɛ kɔnɔ kɩŋasan tɔ yɛ “Fan boyi kabwaarɛ‐sunkpa ayɛ nɩmʋ, kɛ n taa nkɛ nsa kʋsaa kɩmʋ yii.” ");
INSERT INTO naw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nɩɩ Gyiwu abi mʋ ba taasɛ mʋ yɛ, “Nsu adɩna yɛ asiye nɩɩ ba taa pɔyɩ Kabwaarɛ‐sunkpa ayɛ nɩmʋ, nɩɩ fɛɛ fʋ fʋ yɛ fɩɩ taalɛ taa nkɛ nsa kʋsaa kɩmʋ yii?” ");
INSERT INTO naw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kabwaarɛ‐sunkpa ayɛ mʋ nɩɩ Yesu tɔwɛ kɩmʋ asɩn falɛ, ɩ gyɛ mʋ gbaa‐gbaa mʋ kayɩɩ‐wʋlɛ nɩn, man gyɛ kabwaarɛ‐sunkpa ayɛ mʋ gbaa‐gbaa. ");
INSERT INTO naw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ɩmʋ sʋ saŋa mʋ nɩɩ Ɩbwaarɛ kyiŋi mʋ lɩɩ lewu tɔ mʋ, mʋ abɩɩlapʋ mʋ ba nyiŋi yɛ ɔ wʋla tɔwɛ bamʋ ɩnɩmʋ. Nɩɩ ba kɔɔlɛ Asɩnkyan yɩlasa mʋ yɛ asɩn mʋ nɩɩ Yesu tɔwɛ bamʋ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Asɩn kyinkyinsa kʋkyɔ mʋ nɩɩ ɔ waa Gyerusalem kadɛ tɔ saŋa mʋ nɩɩ Gyiwu abi bee gyii bamʋ Kesu kɔnɔ Kanyaŋɛ nbunɔ mʋ, asa gaalaagaa ba wu nɩɩ ba kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amaa Yesu bɩrɛ, ɔ man taa mʋ n‐yɩɩ tʋʋ bamʋ sʋ, lɩɩ fɛɛ o nyi kanan mʋ nɩɩ asa kpini ba du. ");
INSERT INTO naw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nɩɩ ɩ man tiri mʋ fɛɛ ɔkʋ ɔ tɔwɛ mʋ kanan mʋ nɩɩ asa ba du, lɩɩ fɛɛ o nyi kʋtɔ mʋ nɩɩ kɩ bʋ asa nkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ɔnyɩn kʋ lɩɩ Farasii kʋbʋ mʋ tɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Nikodemusi, ɔ gyɛ Gyiwu abɩlɩsa mʋ tɔ ɔkʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mʋ ɩ ba Yesu asɛ kagyanbwɛ kʋ, nɩɩ ɔ tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, an nyi yɛ Ɩbwaarɛ i sun fʋ yɛ fʋ ba kaapʋ anɛ. Lɩɩ fɛɛ ɔkʋ mɛɛ taalɛ waa asɩn kyinkyinsa mʋ nɩɩ fɩɩ waa falɛ, amɔɔ Ɩbwaarɛ tii mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nɩɩ Yesu lɩɩ kɔnɔ yɛ, “N tɔwɛ fanɛ kesintin yɛ, ɔkʋ mɛɛ taalɛ wu kɛ ɔ bɩɩ Ɩbwaarɛ kuwura‐gyii mʋ, amɔɔ ɔ yɛgɛ nɩɩ ba bwii kʋʋgɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nɩɩ Nikodemusi taasɛ yɛ, “Nɛnɛ nɩɩ ba bɩla yɛ ba kʋʋgɛ nyɩmɩsa mʋ nɩɩ ɔ tɛɛ dan? Ɛ taalɛ bɩla bwii loo mu‐nyi ɔtɔ tɔ kɛ ba kʋʋgɛ mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nɩɩ Yesu lɛɛ mʋ kɔnɔ yɛ, “N tɔwɛ fʋ kesintin yɛ ɔkʋ man bʋ tɔ ɔ taalɛ loo Ɩbwaarɛ kuwura‐gyii mʋ tɔ, amɔɔ ɔ yɛgɛ nɩɩ ba gyee mʋ Ɩbwaarɛ kekyugyee maa Kayaayu Kyɩrɛkyɩrɛ mʋ kigyee, kɛ ɔ nyɛ kakʋʋgɛ pʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nyɩmɩsa kʋʋgɛ nyɩmɩsa fɛɛ mu keduli nɩn, nɩɩ Ɩbwaarɛ Kayaayu mʋ ɩ kʋʋgɛ nyɩmɩsa fɛɛ Ɩbwaarɛ keduli nɩn. ");
INSERT INTO naw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Man yɛgɛ i kyinkyin fʋ fɛɛ, n maa tɔwɛ fʋ yɛ ɩ dagaa ba bwii kʋʋgɛ ɔkʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Afuu ɩɩ da ii kpee katɩn mʋ nɩɩ ii biti. Fii nu ɩmʋ sʋ, amaa fʋ man nyi katɩn mʋ nɩɩ ɩɩ lɩɩ yɛ katɩn mʋ nɩɩ ii kpee. Kanɩn nɩɩ ɔkʋmaa mʋ nɩɩ ba kʋʋgɛ mʋ Ɩbwaarɛ Kayaayu mʋ tɔ mʋ du.” ");
INSERT INTO naw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nɩɩ Nikodemusi taasɛ yɛ, “Nɛnɛ nɩɩ ɩnɩmʋ ɩ taalɛ waa?” ");
INSERT INTO naw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “N nyi fʋ maa gyɛ Ɩsɩrayɩ ɔkaapʋpʋ kparɛ, nɩɩ fʋ man nu ɩnɩmʋ kasɛ? ");
INSERT INTO naw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","N tɔwɛ fʋ kesintin yɛ, ɩmʋ nɩɩ an nyi mʋ nɩɩ an tɔwɛ, nɩɩ ɩmʋ nɩɩ an wu mʋ, nɩɩ an lɛɛ an tɔwɛ. Amaa fan mɛɛ kɔɔlɛ anɛ asɩn tɔwɛsa fen gyii. ");
INSERT INTO naw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","N maa tɔwɛ fanɛ kasɛ sʋ asɩn nɩɩ fan maa kɔɔlɛ gyii falɛ mʋ, nɛnɛ nɩɩ fan taalɛ kɔɔlɛ sʋsʋ asɩn gyii? ");
INSERT INTO naw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ɔkʋ man pɩɩta lɩɩ kasɛ sʋ kpee sʋsʋ, amɔɔ mɛ, Daadimaadi Obii‐nyɩnsa mʋ nɩɩ n lɩɩ sʋsʋ ba kasɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Saŋa mʋ dɩdaa mʋ, fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ yɛgɛ nɩɩ Mosesi taa ɔpɔlɛ ŋalɩgɛ waa kɩnansɛ nɩɩ ɔ maalɛ oyu, kʋsaa kɩmʋ ifuli mʋ sʋ, nɩɩ asa ba kɩɩ nɩɩ ba nyɛ nkpa mʋ, kanɩn maŋa nɩɩ ii tiri fɛɛ ba kʋsaa mɛ, Daadimaadi Obii‐nyɩnsa mʋ sʋsʋ, ");
INSERT INTO naw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kɛ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ ɔ nyɛ nkpa kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Lɩɩ kanan mʋ nɩɩ Ɩbwaarɛ sʋ kebiti sa dulinyaa tɔ asa gaa sʋ mʋ, ɔ lɛɛ mɛ, Mu‐Bii kʋlʋn kpen mʋ sa, fɛɛ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, mɛɛ yɛ ɔ fɔyɩ, amaa ee biti ɔ nyɛ nkpa kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Lɩɩ fɛɛ Ɩbwaarɛ man sun mɛ, Mu‐Bii mʋ ba dulinyaa nɩmʋ tɔ, yɛ n ba bun kɩmʋ tɔ asa kʋpwɛ, amaa o sun mɛ nɩn yɛ n ba waa bamʋ ɔmɔlɩgɛpʋ. ");
INSERT INTO naw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, Ɩbwaarɛ mɛɛ yɛ o bun mʋ kʋpwɛ, amaa ɔkʋmaa mʋ nɩɩ ɔ man kɔɔlɛ mɛ gyii mʋ, Ɩbwaarɛ wʋla bun mʋ kʋpwɛ. Lɩɩ fɛɛ ɔ man kɔɔlɛ mɛ, Ɩbwaarɛ Mu‐Bii kʋlʋn kpen mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kanan mʋ nɩɩ kʋpwɛ kubun mʋ kɩ ba mʋ ɩ gyɛ yɛ, ɩŋmaŋɛsa mʋ ɩ lɩɩ sʋsʋ nɩn ba dulinyaa tɔ, amaa asa bee biti kitentenbiri mʋ ba kyɔ ɩŋmaŋɛsa mʋ, lɩɩ fɛɛ bamʋ asunsunsa ɩ gyɛ alibi nɩn. ");
INSERT INTO naw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Lɩɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɛɛ waa alibi mʋ ii kisi ɩŋmaŋɛsa mʋ, nɩɩ ɔ mɛɛ ba ɩŋmaŋɛsa mʋ tɔ, kɛ mu alibi ɩ ba lɩɩ ifuli. ");
INSERT INTO naw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amaa ɔkʋmaa mʋ nɩɩ ɛɛ waa atɔ mʋ nɩɩ ɩ dɛ ɔkpa mʋ bɩrɛ, ɛɛ ba ɩŋmaŋɛsa mʋ tɔ, kɛ asa ba nyɛ wu fɛɛ mʋ atɔ waasa mʋ ɩ gyɛ ɩmʋ nɩɩ Ɩbwaarɛ ii biti.” ");
INSERT INTO naw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ɩnɩmʋ kamaa mʋ Yesu maa mʋ abɩɩlapʋ ba lɩɩ Gyerusalem kpee Gyudeya ɔsʋwʋlɛ sʋ. Ɔ kyɩna tʋtɔ nkɛ nyɔ kʋ maa bamʋ, nɩɩ o gyee asa Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kanɩn saŋa maŋa nɩɩ Gyɔn Okyugyeepu mʋ gbaa bʋ Anon kadɛ mʋ nɩɩ ki tiri Salim mʋ tɔ. Ee gyee asa Ɩbwaarɛ kekyugyee, lɩɩ fɛɛ nkyu ɩ kyɩna ɩ kyɔ tʋtɔ gaa, nɩɩ asa bee kpee mʋ asɛ yɛgɛ ee gyee bamʋ. ");
INSERT INTO naw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Saŋa maŋa, ba man pɩɩta tii Gyɔn obu. ");
INSERT INTO naw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nɩɩ ɩmɔɔrɛ ɩ tɩyɛ Gyɔn abuupu yɛ Gyiwu nyɩmɩsa kʋ nsana lɩɩ anaana tɔ ineesi kɩfwɩɩ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nɩɩ Gyɔn abɩɩlapʋ ba ba mʋ asɛ ba tɔwɛ mʋ yɛ, “Ɔkaapʋpʋ, ɔnyɩn mʋ nɩɩ an wu mʋ Gyɔdan ɔbʋn benbe mʋ, ɔmʋ nɩɩ fu gyii mʋ asɩn kesintin mʋ gbaa ii gyee asa Ɩbwaarɛ kekyugyee, yɛgɛ asa kpini bee kpee mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nɩɩ Gyɔn lɛɛ bamʋ kɔnɔ yɛ, “Nɩɩ Ɩbwaarɛ man kan taa kʋtɔ kʋ sa ɔkʋ mʋ, ɔ mɛɛ taalɛ nyɛ kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Fanɛ gbaa‐gbaa fanɛ fen biti fan gyii mɛ kesintin fɛɛ, n wʋla tɔwɛ fanɛ yɛ, ‘Man gyɛ mɛ ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ.’ Amaa Ɩbwaarɛ sun mɛ nɩn yɛ n gyankpaa ba lɔŋɔ ɔkpa yɩla mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nɩɩ ɔ bɔ kɩŋasan yɛ, “Ɔmʋ nɩɩ ɔ sʋ ɔkyɩɩfɔ mʋ ɩ gyɛ ɔkyɩɩfɔ mu‐kuli. Ɔkyɩɩfɔ mu‐kuli mʋ kyɛmɩnɛ bɩrɛ ɛɛ yɩlɛ ee gyoo nɩn. Nɩɩ ɔ kan nu mʋ ɔbʋlɛ mʋ, mu ansi i gyii. Kanɩn maŋa sʋ nɩɩ nbɩɩnbɩɩ mi ansi i gyii gaa. ");
INSERT INTO naw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ɩ dagaa fɛɛ Yesu kɩtɩɩ kɩ ba ki dii ki tii sʋ, kɛ mɛ Gyɔn kɩtɩɩ mɔɔ kɩ ba kasɛ. ");
INSERT INTO naw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ɔmʋ nɩɩ ɔ lɩɩ sʋsʋ ba mʋ kyɔ ɔkʋmaa nɩmʋ. Ɔmʋ nɩɩ ɔ lɩɩ kasɛ sʋ mʋ gyɛ kasɛ nɩmʋ sʋ nyɩmɩsa nɩn, nɩɩ kasɛ nɩmʋ sʋ asɩn nɩɩ ɛɛ tɔwɛ. Nɩɩ ɔmʋ nɩɩ ɔ lɩɩ sʋsʋ mʋ kyɔ ɔkʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ɩmʋ nɩɩ o wu yɛ ɩmʋ nɩɩ o nu mʋ, ɩmʋ kesintin nɩɩ ee gyii mʋ, nkɛɛ ɔkʋ mɛɛ kɔɔlɛ mʋ kesintin kigyii mʋ ee gyii. ");
INSERT INTO naw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Amaa ɔkʋmaa mʋ nɩɩ ɛɛ kɔɔlɛ mʋ asɩn mʋ gyii mʋ, ɩmʋ ɩɩ kaapʋ fɛɛ Ɩbwaarɛ gyɛ kesintin wuya. ");
INSERT INTO naw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ɔmʋ nɩɩ Ɩbwaarɛ sun mʋ mʋ, Ɩbwaarɛ asɩn nɩɩ ɛɛ tɔwɛ, lɩɩ fɛɛ Ɩbwaarɛ sa mʋ Kayaayu mʋ nɩɩ kɩ man sʋ ɔkaa. ");
INSERT INTO naw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mɛ‐Sɛ Ɩbwaarɛ mʋ ii biti Mu‐Bii kʋlʋn mʋ, nɩɩ ɔ taa kʋtɔ kʋmaa waa mʋ kɩbaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ Mu‐Bii mʋ gyii mʋ sʋ nkpa kakpaa. Amaa ɔmʋ nɩɩ ɔ man nu sa Mu‐Bii mʋ, ɔ mɛɛ yɛ ɔ nyɛ nkpa kakpaa, amaa Ɩbwaarɛ agbʋ mʋ ɩ dɛ mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ɩ maa ba fɛɛ Yesu bɩɩ fɛɛ Farasii abi mʋ ba nu yɛ ɛɛ nyɛ abɩɩlapʋ nɩɩ ee gyee bamʋ Ɩbwaarɛ kekyugyee ɔ kyɔ Gyɔn. ");
INSERT INTO naw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kesintin tɔ bɩrɛ, Yesu gbaa‐gbaa man gyee asa Ɩbwaarɛ kekyugyee, amɔɔ mʋ abɩɩlapʋ nkʋn ii gyee asa. ");
INSERT INTO naw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu maa bɩɩ kanɩn mʋ, ɔ kʋsʋ lɩɩ Gyudeya ɔsʋwʋlɛ sʋ bwii kpee Galile ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Maa kpee mʋ ɩ dagaa maa bɔla lɩɩ Samariya ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nɩɩ ɔ ba fʋʋ Samariya kadɛ mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ Sikaa mʋ. Kanɩn kadɛ maŋa kɩ bʋ tiri kasɛ mʋ nɩɩ saŋa mʋ dɩdaa mʋ, Gyekobu taa sa mu‐bii Gyosefu mʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tʋtɔ nɩɩ Gyekobu kitiribo mʋ kɩ bʋ. Yesu maa natɛ nɩɩ i nu mʋ mʋ, ɔ naa kyɩna kitiribo mʋ asɛ. Saŋa maŋa gyɛ kyɔwɛ amu nsana. ");
INSERT INTO naw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yesu maa tɛ tʋtɔ mʋ, nɩɩ Kasamariya‐kyɩɩ kʋ ba ɔ ba saa nkyu, nɩɩ Yesu tɔwɛ mʋ yɛ, “Sa mɛ nkyu kɛ n nuu.” ");
INSERT INTO naw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kanɩn saŋa maa mʋ Yesu abɩɩlapʋ ba kyʋn kadɛ tɔ ba naa sɔɔ agyitɔ. ");
INSERT INTO naw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nɩɩ ɔkyɩɩ mʋ lɛɛ Yesu kɔnɔ yɛ, “Fʋ gyɛ Gyiwu obii nɩn, nɩɩ mɛɛ mɛ n gyɛ Samariya obii nɩn. Mɩnɛ sʋ nɩɩ fʋ kʋlɛ mɛ nkyu kɛ fu nuu?” Ɔkyɩɩ mʋ tɔwɛ kanɩn lɩɩ fɛɛ Gyiwu abi yɛ Samariya abi ba mɛɛ bʋga lapɛ kʋlʋn. ");
INSERT INTO naw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fʋ daa fu nyi kakɛɛ mʋ nɩɩ Ɩbwaarɛ ɩɩ sa, yɛ mɛ mʋ nɩɩ n kʋlɛ fʋ nkyu falɛ nɩn, naafɔɔ fʋ dɩn kʋlɛ mɛ kɛ n sa fʋ nkyu mʋ nɩɩ ɩɩ sa nkpa.” ");
INSERT INTO naw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tʋtɔ nɩɩ ɔkyɩɩ mʋ taasɛ yɛ, “Ɔbɩlɩsa, fʋ man sʋ kuuka, nɩɩ kitiribo mʋ mɔɔ bʋ nyɛ. Fɩnɛ nɩɩ fii biti fʋ nyɛ falɛ nkyu mʋ nɩɩ ɩɩ sa nkpa mʋ sa mɛ? ");
INSERT INTO naw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Anɛ naana Gyekobu ɩ sa anɛ kitiribo maŋa. Mʋ gbaa‐gbaa maa mu‐bii ana yɛ mʋ atɔbwaaya kpini kɩmʋ tɔ nɩɩ ba nuu. Fɩɩ kaapʋ fɛɛ fʋ kyɔ anɛ naana Gyekobu nɩn abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu lɛɛ kɔnɔ yɛ, “Ɔkʋmaa mʋ nɩɩ o nuu nkyu nɩmʋ mʋ, bʋlɩfɔ ii biti o bwii kɩtaa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Amaa ɔkʋmaa mʋ nɩɩ o nuu nkyu mʋ nɩɩ n biti n sa mʋ mʋ, bʋlɩfɔ man bɩla yɛ ɔ kɩtaa mʋ. Kanɩn nkyu maŋa ii biti i biliŋi fɛɛ nkyu mʋ nɩɩ ɩɩ kyʋn mʋ tɔ, kɛ kɩɩ sa mʋ nkpa mʋ nɩɩ ɩ man sʋ ɔkaa.” ");
INSERT INTO naw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tʋtɔ nɩɩ ɔkyɩɩ mʋ tɔwɛ yɛ, “Ɔbɩlɩsa, n kʋlɛ fʋ nɩn, sa mɛ kanɩn nkyu maŋa kɛ bʋlɩfɔ ɔ man bɩla kɩtaa mɛ, kɛ n man bɩla n baa n sa nkyu nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nɩɩ Yesu tɔwɛ ɔkyɩɩ mʋ yɛ, “Bwii kpee naa tɩɩ fu‐kuli kɛ fan ba.” ");
INSERT INTO naw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nɩɩ ɔkyɩɩ mʋ tɔwɛ mʋ yɛ, “N man sʋ okuli.” Nɩɩ Yesu yɛ, “Fʋ tɔwɛ kesintin fɛɛ fʋ man sʋ okuli. ");
INSERT INTO naw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Fʋ wʋla kili anyɩn anu nɩɩ fʋ yɛgɛ, nɩɩ ɔnyɩn mʋ nɩɩ faa mʋ fan tɛ nbɩɩnbɩɩ falɛ gbaa, man gyɛ fu‐kuli. Ɩmʋ sʋ ɩmʋ nɩɩ fʋ tɔwɛ falɛ gyɛ kesintin nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nɩɩ ɔkyɩɩ mʋ tɔwɛ yɛ, “Ɔbɩlɩsa n wu fɛɛ fʋ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Anɛ naana ana Samariya abi bɩrɛ kɩbɩɩ nɩmʋ sʋ nɩɩ ba daa bɛɛ sun Ɩbwaarɛ, amaa fanɛ Gyiwu abi ɩɩ tɔwɛ yɛ Gyerusalem ɩ gyɛ opula mʋ nɩɩ ɩ dagaa fɛɛ a sun Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Ɔkyɩɩ, kɔɔlɛ mɛ gyii fɛɛ saŋa kʋ ii biti ɔ ba, nɩɩ man gyɛ kɩbɩɩ kɩnɩmʋ sʋ abɛɛ Gyerusalem nɩɩ asa bee biti ba sun Mɛ‐Sɛ Ɩbwaarɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Fanɛ Samariya abi ɩ man nyi Ɩbwaarɛ mʋ nɩɩ fen sun danbɩrasa, amaa anɛ Gyiwu abi bɩrɛ an nyi Ɩbwaarɛ mʋ nɩɩ an sun. Lɩɩ fɛɛ Ɩbwaarɛ kamɔlɩgɛ mʋ kɩ bɔla Gyiwu abi sʋ nɩn ba. ");
INSERT INTO naw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Saŋa kʋ ii biti ɔ ba, nɩɩ kɩ tɛɛ fʋʋ lʋwɛ, nɩɩ kesintin asunpu bee biti ba sun Mɛ‐Sɛ Ɩbwaarɛ mʋ Kayaayu Kyɩrɛkyɩrɛ yɛ kesintin tɔ. Kanɩn asunpu banɩmʋ falɛ nɩɩ Mɛ‐Sɛ Ɩbwaarɛ mʋ ii biti. ");
INSERT INTO naw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ɩbwaarɛ gyɛ kayaayu nɩn, nɩɩ bamʋ nɩɩ bee sun mʋ mʋ, ɩ dagaa fɛɛ ba sun mʋ Kayaayu yɛ kesintin tɔ.” ");
INSERT INTO naw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nɩɩ ɔkyɩɩ mʋ tɔwɛ Yesu yɛ, “N nyi fɛɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ, nɩɩ bɛɛ tɩɩ mʋ yɛ Krisito mʋ, ee biti ba. Nɩɩ ɔ kan ba mʋ, ee biti ɔ lɛɛ kʋtɔ kʋmaa mʋ nɩɩ kɩ bʋ tɔ kaapʋ anɛ.” ");
INSERT INTO naw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nɩɩ Yesu tɔwɛ yɛ, “Mɛ, mʋ nɩɩ n tɔwɛ fʋ asɛ falɛ, mɛ ɩ gyɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kanɩn saŋa maŋa nɩɩ Yesu abɩɩlapʋ mʋ ba bwii lɩɩ kadɛ tɔ ba. Nɩɩ ba maa wu Yesu maa ɔkyɩɩ mʋ ba maa tɛɛ bɛɛ tɔwɛ mʋ, i kyinkyin bamʋ. Amaa bamʋ tɔ ɔkʋ man taalɛ taasɛ ɔkyɩɩ mʋ yɛ, “Mɩnɛ nɩɩ fii biti?” Abɛɛ ba taasɛ Yesu yɛ, “Mɩnɛ ɩɩ waa sʋ nɩɩ fɩɩ tɔwɛ ɔkyɩɩ mʋ asɛ?” ");
INSERT INTO naw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tʋtɔ mʋ, ɔkyɩɩ mʋ yɛgɛ mʋ kɔlɔ‐bi yɩla sɩlɛ kpee kadɛ tɔ naa tɔwɛ asa yɛ, ");
INSERT INTO naw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Fan ba kɩɩ ɔnyɩn kʋ maa tɔwɛ mɛ atɔ mʋ nɩɩ n waa mʋ kpini. Abɛɛ mʋ ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɩmʋ sʋ asa mʋ ba lɩɩ kadɛ mʋ tɔ bee kpee ba naa kɩɩ Yesu. ");
INSERT INTO naw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Saŋa maa tɔ nɩɩ mʋ abɩɩlapʋ ba kʋlɛ mʋ yɛ, “Ɔkaapʋpʋ, waa aniya kɛ fu gyii agyitɔ.” ");
INSERT INTO naw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amaa nɩɩ Yesu tɔwɛ yɛ, “N sʋ agyitɔ mʋ nɩɩ n gyii, yɛgɛ fan man nyi ɩmʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nɩɩ abɩɩlapʋ mʋ ba taasɛ abaa yɛ, “Abɛɛ ɔsa kʋ wʋla bɩya mʋ agyitɔ nɩn nɩɩ o gyii?” ");
INSERT INTO naw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Mɛ agyitɔ ɩ gyɛ fɛɛ n maa waa Mɛ‐Sɛ Ɩbwaarɛ mʋ nɩɩ o sun mɛ mʋ kebiti, kɛ n waa kusun mʋ nɩɩ ɔ sa mɛ mʋ lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Man gyɛ fanɛ kɩŋasan ɩɩ tɔwɛ yɛ, ‘Ɩ san ɩbwaayɩ ɩna kɛ a tɩŋɛ ayu mʋ?’ Amaa n tɔwɛ fanɛ fɛɛ fan bugi fanɛ ansi kɩɩ adɔɔ mʋ, fen biti fan wu fɛɛ ɩ payɩ fʋʋ kɩtɩŋɛ. ");
INSERT INTO naw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ɔsa mʋ nɩɩ ɛɛ tɩŋɛ mʋ ɩɩ nyɛ mʋ kʋkɔka danbɩrasa, nɩɩ ayu mʋ nɩɩ ɛɛ kʋʋla ɛɛ yɩlɛ mʋ ɩ gyɛ asa mʋ nɩɩ ɔ taa ba nkpa kakpaa tɔ. Ɩmʋ sʋ ɔmʋ nɩɩ ee duu yɛ ɔ mʋ nɩɩ ɛɛ tɩŋɛ mʋ kpini bee biti ba bʋga gyii bamʋ ansi. ");
INSERT INTO naw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ɩmʋ sʋ asɩn mʋ nɩɩ bɛɛ tɔwɛ yɛ, ‘Ɔkʋ ii duu nɩɩ ɔkʋ ɩɩ kpa,’ ɩ gyɛ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","N sun fanɛ ndɔɔ tɔ yɛ fan naa tɩŋɛ ayu mʋ nɩɩ fan man duu. Akʋ ɩ waa ɩmʋ kusun nɩɩ fan ba nyɛ ɩmʋ kʋkɔka.” ");
INSERT INTO naw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariya abi gaalaagaa mʋ nɩɩ ba bʋ kadɛ mʋ tɔ mʋ ba kɔɔlɛ Yesu gyii, lɩɩ fɛɛ ɔkyɩɩ mʋ maa tɔwɛ yɛ, “Ɔ tɔwɛ mɛ kʋtɔ kʋmaa mʋ nɩɩ n wʋla waa” mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɩmʋ sʋ saŋa mʋ nɩɩ Samariya abi mʋ ba ba mʋ asɛ mʋ, ba kʋlɛ mʋ yɛ ɔ kyɩna bamʋ asɛ, nɩɩ ɔ kyɩna bamʋ asɛ nkɛ nnyɔ. ");
INSERT INTO naw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Asa gaalaagaa ba ba kɔɔlɛ mʋ gyii tii sʋ lɩɩ asɩn mʋ nɩɩ ɔ tɔwɛ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nɩɩ asa mʋ ba tɔwɛ ɔkyɩɩ mʋ yɛ, “Nbɩɩnbɩɩ bɩrɛ, an kɔɔlɛ mʋ gyii, yɛgɛ man gyɛ asɩn mʋ nɩɩ fʋ tɔwɛ anɛ mʋ sʋ, amaa kpalɩ fɛɛ anɛ gbaa‐gbaa anɛ an nu yɛ anɛ asʋ, nɩɩ an bɩɩ fɛɛ mʋ ɩ gyɛ dulinyaa tɔ asa ɔmɔlɩgɛpʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu maa gyii nkɛ nnyɔ kamaa tɔ mʋ, ɔ lɩɩ tʋtɔ kpee Galile ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu gbaa‐gbaa ɩ wʋla kyɩna tɔwɛ yɛ, “Ɩbwaarɛ ɔtɔwɛpʋ kʋmaa man sʋ bɛɛrɛɛ mʋ gbaa‐gbaa mʋ ayɛ.” ");
INSERT INTO naw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesu maa naa fʋʋ Galile mʋ, Galile abi ba kɔɔlɛ mʋ abaa anyɔ, lɩɩ fɛɛ ngbaa bamʋ, saŋa mʋ nɩɩ ba kpee Gyerusalem naa gyii Kesu kɔnɔ Kanyaŋɛ nbunɔ mʋ, ba wu kʋtɔ kʋmaa mʋ nɩɩ ɔ waa tʋtɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu maa bʋ Galile ɔsʋwʋlɛ sʋ mʋ, o bwii kpee Kena kadɛ tɔ. Tʋtɔ nɩɩ ɔ kyɩna taa nkyu biliŋi nta mʋ. Maa bʋ tʋtɔ kanɩn mʋ, kɩbanɛ ɔbɩlɩsa kʋ mu‐bii‐nyɩnsa dɛ Kapanum kadɛ tɔ ɛɛ lɔ. ");
INSERT INTO naw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ɔnyɩn mʋ maa nu fɛɛ Yesu lɩɩ Gyudeya ba Galile mʋ, ɔ ba mʋ asɛ ba kʋlɛ mʋ yɛ ɔ ba Kapanum ba kyɛ mu‐bii mʋ nɩɩ ɔ dɛ ee biti o wu mʋ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Fanɛ ɔkʋ mɛɛ yɛ ɔ kɔɔlɛ mɛ gyii, amɔɔ fen wu asɩn kyinkyinsa yɛ adangana.” ");
INSERT INTO naw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nɩɩ kɩbanɛ bɩlɩsa mʋ kʋlɛ Yesu yɛ, “Ɔbɩlɩsa, yɛgɛ a kpee mi kebii mʋ asɛ pɔyɩ kɛ o wu.” ");
INSERT INTO naw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tʋtɔ nɩɩ Yesu tɔwɛ ɔbɩlɩsa mʋ yɛ, “Natɛ, fu kebii mʋ mɛɛ yɛ o wu.” Ɔnyɩn mʋ kɔɔlɛ Yesu asɩn mʋ gyii, nɩɩ ɔ kɩtaa ɔkpa kyʋn. ");
INSERT INTO naw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Maa kpewu mʋ, mʋ ayaafɔlɛ ba ba gyaŋa mʋ ɔkpa tɔ nɩɩ ba tɔwɛ mʋ yɛ, mu‐bii mʋ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nɩɩ ɔ taasɛ bamʋ saŋa mʋ nɩɩ kebii mʋ nyɛ alanfɩya. Nɩɩ ba tɔwɛ mʋ yɛ, “Ndee kyʋwapɛ kerefi kʋlʋn saŋa mʋ, nɩɩ kibirima mʋ yɛgɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tʋtɔ nɩɩ ɔnyɩn mʋ bɩɩ yɛ kanɩn saŋa maa kyɛɛkyɛɛ nɩɩ Yesu tɔwɛ mʋ yɛ, “Fu‐kebii mʋ mɛɛ yɛ o wu” mʋ. Ɩmʋ sʋ ɔnyɩn mʋ maa mʋ kɩkpaara sʋ abi kpini ba kɔɔlɛ Yesu gyii. ");
INSERT INTO naw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu maa lɩɩ Gyudeya ba Galile mʋ, ɩnɩmʋ ɩ gyɛ asɩn kyinkyinsa nyɔsapʋ mʋ nɩɩ ɔ waa. ");
INSERT INTO naw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ɩnɩmʋ kamaa mʋ, Yesu kpee Gyerusalem naa gyii Gyiwu abi Kesu kɔnɔ ngyaŋɛ kʋ. ");
INSERT INTO naw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kɩpatɛ kʋ kɩ bʋ Gyerusalem kadɛ tɔ, nɩɩ kɩ bʋ tiri kebunɔ mʋ nɩɩ bɛɛ tɩɩ yɛ nbʋlʋpʋ kebunɔ mʋ. Bɛɛ tɩɩ kapatɩyɛ maa Hibriwu kadɛ tɔ yɛ Betesada. Nɩɩ agyan anu ɩ dɛ kyaabɔɔ kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Agyan nɩmʋ tɔ nɩɩ alɔpʋ damantɛ fɛɛ agyaatanapʋ, yɛ ayaa yɛ abaa wusa wuya ana, amʋgʋlɛ‐mʋgʋlɛ kpini ba ba tʋtɔ bee gyoo. ");
INSERT INTO naw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Lɩɩ fɛɛ Ɔnyɩrɩpɛ kabɔɔ ɩ taalɛ ɛɛ lɩɩ sʋsʋ ɛ ba ee lupu nkyu mʋ tɔ, kɛ, alɔpʋ mʋ nɩɩ ba dɛ‐dɛ mʋ, bamʋ tɔ ɔkʋmaa mʋ nɩɩ ɔ gyankpaa loo kapatɩyɛ mʋ tɔ mʋ, mʋ kʋlɔ mʋ nɩɩ kɩ bʋ mʋ tɔ mʋ ɩɩ lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ɔnyɩn kʋ bʋ tʋtɔ ɛɛ lɔ nsu adɩsa yɛ aburuwa. ");
INSERT INTO naw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu maa wu mʋ nɩɩ ɔ bɩɩ fɛɛ ɔ dɛ tʋtɔ lɔ kyɛɛrɛɛ mʋ, nɩɩ ɔ taasɛ mʋ yɛ, “Fii biti fɛɛ fʋ nyɛ alanfɩya?” ");
INSERT INTO naw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nɩɩ ɔlɔpʋ mʋ lɛɛ kɔnɔ yɛ, “Ɔbɩlɩsa, nɩɩ kabɔɔ mʋ kan lupu nkyu mʋ tɔ mʋ, n man sʋ ɔmʋ nɩɩ ɔ taa mɛ loo kapatɩyɛ mʋ tɔ. Saŋa mʋ nɩɩ n kpan mɛ n‐yɩɩ fɛɛ n loo to mʋ, nɩɩ ɔkʋ ɩ daa gyankpaa mɛ loo to.” ");
INSERT INTO naw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Kʋsʋ taa fʋ kalan kɛ fʋ natɛ.” ");
INSERT INTO naw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Opula maŋa tɔ nɩɩ ɔ nyɛ alanfɩya, nɩɩ o kukuri mʋ kalan natɛ. Kanɩn kakɛ maŋa gyɛ Gyiwu abi kakɛ fʋʋtɛsa akɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nɩɩ Gyiwu abɩlɩsa mʋ ba tɔwɛ ɔnyɩn mʋ nɩɩ ɔ nyɛ alanfɩya mʋ yɛ, “Ndaga gyɛ kakɛ fʋʋtɛsa akɛ. Anɛ nbara mʋ ɩ mɛɛ sa ɔkpa yɛ fʋ sʋla fʋ kalan.” ");
INSERT INTO naw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Amaa ɔ lɛɛ kɔnɔ yɛ, “Ɔnyɩn mʋ nɩɩ ɔ kyɛ mɛ mʋ ɩ tɔwɛ mɛ yɛ, ‘Taa fʋ kalan kɛ fʋ natɛ.’ ” ");
INSERT INTO naw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kanɩn sʋ ba taasɛ mʋ yɛ, “Anɩmʋ ɩ gyɛ kanɩn ɔnyɩn maŋa mʋ nɩɩ ɔ tɔwɛ fʋ yɛ fʋ taa fʋ kalan kɛ fʋ natɛ?” ");
INSERT INTO naw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nɩɩ ɔnyɩn mʋ man nyi kanɩn ɔnyɩn mʋ nɩɩ ɔ kyɛ mʋ mʋ, lɩɩ fɛɛ asa ba kyɔ nɩɩ Yesu loo asa damantɛ mʋ tɔ kyʋn. ");
INSERT INTO naw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kamaa tɔ mʋ Yesu wu mʋ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Kɩɩ, nbɩɩnbɩɩ fʋ nyɛ alanfɩya, ɩmʋ sʋ yɛgɛ alibi kɩwaa. Nɩɩ man gyɛ kanɩn, ɩmʋ nɩɩ ii biti ɩ ba fʋ sʋ mʋ ii biti ɩ baa ɩ kyɔ ɩnɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nɩɩ Ɔnyɩn mʋ lɩɩ tʋtɔ naa tɔwɛ Gyiwu abɩlɩsa mʋ yɛ Yesu ɩ gyɛ ɔmʋ nɩɩ ɔ kyɛ mʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lɩɩ atɔ mʋ nɩɩ Yesu waa kakɛ fʋʋtɛsa akɛ sʋ mʋ, Gyiwu abɩlɩsa mʋ ba piili bɛɛ tɔɔrɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Mɛ‐Sɛ ii sun kusun saŋa kʋmaa, ɩmʋ sʋ ngbaa mɛ n sun kusun.” ");
INSERT INTO naw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lɩɩ ɩnɩmʋ sʋ Gyiwu abi ba payɩ ansi bee biti ɩkpa ba mɔɔ mʋ. Man gyɛ kakɛ fʋʋtɛsa akɛ nbara kinyita mʋ wʋlɛ nkʋn sʋ, amaa ɛɛ tɔwɛ yɛ mʋ‐Sɛ ɩ gyɛ Ɩbwaarɛ, mʋ nɩɩ ɩɩ kaapʋ fɛɛ maa Ɩbwaarɛ kyɛɛkyɛɛ. ");
INSERT INTO naw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nɩɩ Yesu kyaga sʋ lɛɛ kɔnɔ yɛ, “N tɔwɛ fanɛ kesintin yɛ, mɛ, Ɩbwaarɛ Mu‐Bii mʋ n mɛɛ taalɛ waa sɛhn mɛ kɩba sʋ. Kʋtɔ mʋ nɩɩ n wu Mɛ‐Sɛ mʋ waa mʋ, kɩmʋ nɩɩ ngbaa mɛ n waa. ");
INSERT INTO naw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mɛ‐Sɛ mʋ sʋ kebiti sa mɛ, nɩɩ ɛɛ kaapʋ mɛ kʋtɔ kʋmaa mʋ nɩɩ ɛɛ waa mʋ. Mɛ‐Sɛ ii biti ɔ kaapʋ mɛ atɔ kparɛ mʋ nɩɩ ɩ kyɔ ɩnɩmʋ, kɛ n waa kɛ i kyinkyin fanɛ. ");
INSERT INTO naw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Fɛɛ kanan mʋ nɩɩ Mɛ‐Sɛ ii kyiŋi alewupu nɩɩ ɛɛ sa bamʋ nkpa mʋ, kanɩn maŋa sʋ nɩɩ mɛ, Obii mʋ gbaa n sa nkpa mi kebiti tɔ. ");
INSERT INTO naw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mɛ‐Sɛ gbaa‐gbaa mɛɛ talɛ ɔkʋ, amaa ɔ taa ɔkʋmaa nɩmʋ katalɛ waa mɛ kɩbaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mɛ‐Sɛ ii biti asa kpini ba taa bʋnyaa sa mɛ, Obii mʋ, fɛɛ kanan mʋ nɩɩ bɛɛ taa bʋnyaa bɛɛ sa Mɛ‐Sɛ mʋ. Ɔkʋmaa mʋ nɩɩ ɔ mɛɛ taa bʋnyaa sa mɛ, Obii mʋ, ɩɩ kaapʋ nɩn fɛɛ ɔ mɛɛ taa bʋnyaa ɛɛ sa Mɛ‐Sɛ mʋ nɩɩ o sun mɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“N tɔwɛ fanɛ kesintin fɛɛ ɔkʋmaa mʋ nɩɩ o nu mɛ asɩn, nɩɩ ɔ kɔɔlɛ ɔmʋ nɩɩ o sun mɛ mʋ gyii mʋ, sʋ nkpa kakpaa, nɩɩ Ɩbwaarɛ mɛɛ yɛ o bun mʋ kʋpwɛ. Ɔ tɛɛ faa lɩɩ lewu tɔ ba nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","N tɔwɛ fanɛ kesintin fɛɛ saŋa kʋ ɩɩ ba, nɩɩ nbɩɩnbɩɩ gbaa ɩɩ tɛɛ ba. Nɩɩ bamʋ nɩɩ ba du fɛɛ alewupu lɩɩ kanan mʋ nɩɩ ba man nyi Ɩbwaarɛ mʋ sʋ mʋ, bee biti ba nu mɛ, Ɩbwaarɛ Mu‐Bii mʋ ɔbʋlɛ, nɩɩ bamʋ nɩɩ ba nu mɛ asɛ mʋ, bee biti ba nyɛ nkpa. ");
INSERT INTO naw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Fɛɛ Kanan mʋ nɩɩ Mɛ‐Sɛ gyɛ nkpa kumu mʋ, kanɩn maŋa nɩɩ ɔ sa mɛ, Mu‐Bii mʋ ɔkpa fɛɛ n baa n gyɛ nkpa kumu. ");
INSERT INTO naw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nɩɩ ɔ sa mɛ ɔlʋn yɛ n talɛ daadimaadi kʋmaa, lɩɩ fɛɛ mɛ ɩ gyɛ Daadimaadi Obii‐nyɩnsa. ");
INSERT INTO naw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Fan man yɛgɛ ɩnɩmʋ i kyinkyin fanɛ, lɩɩ fɛɛ saŋa kʋ ii biti ɔ ba nɩɩ alewupu mʋ nɩɩ ba bʋ nkyan tɔ kpini bee biti ba nu mɛ ɔbʋlɛ, ");
INSERT INTO naw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kɛ ba lɩɩ bamʋ nkyan tɔ ba. Nɩɩ bamʋ nɩɩ ba waa adanbɩrasa mʋ, bee biti ba kyiŋi nyɛ nkpa, kɛ bamʋ nɩɩ ba waa alibi mʋ, bee biti ba kyiŋi kɛ ba gyii kʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nɩɩ mɛ gbaa‐gbaa mɛ mɛɛ taalɛ waa sɛhn mɛ kɩbaa sʋ. N talɛ kanan mʋ nɩɩ n nu lɩɩ Mɛ‐Sɛ asɛ, nɩɩ n gyii asɩn ɩmʋ ɔkpa sʋ, lɩɩ fɛɛ n mee biti n waa mɛ gbaa‐gbaa mɛ kɔkɔlɔ biti, amɔɔ ɔmʋ nɩɩ o sun mɛ mʋ lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu kyaga sʋ tɔwɛ yɛ, “Nɩɩ n gyii mɛ gbaa‐gbaa mɛ n‐yɩɩ sʋ asɩn kesintin mʋ, ɩ mɛɛ yɛ ɩ baa i budu. ");
INSERT INTO naw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amaa ɔkʋ bʋ tɔ nɩɩ ee gyii mɛ n‐yɩɩ sʋ asɩn, mʋ ɩ gyɛ mɛ‐Sɛ Ɩbwaarɛ, nɩɩ n nyi fɛɛ mɛ n‐yɩɩ asɩn mʋ nɩɩ ee gyii mʋ ɩ gyɛ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Nɩɩ fanɛ gbaa‐gbaa fan sun kpee Gyɔn asɛ, nɩɩ ɔ lɛɛ kesintin mʋ tɔwɛ fanɛ lɩɩ mɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Man gyɛ fɛɛ n biti nyɩmɩsa daadimaadi o gyii mɛ n‐yɩɩ sʋ kesintin nɩn, amaa n tɔwɛ asɩn nɩmʋ lɩɩ Gyɔn sʋ nɩn, kɛ fan nu kasɛ kɛ fan nyɛ kamɔlɩgɛ. ");
INSERT INTO naw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Gyɔn kyɩna o du nɩn fɛɛ ɩŋmaŋɛsa mʋ nɩɩ kɩ kyaŋɛ nɩɩ kɩ kɩɩ tɔ, nɩɩ fan gyii fanɛ ansi gbɛrɛɛ ɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Amaa n sʋ atɔ mʋ nɩɩ ii gyii mɛ n‐yɩɩ sʋ kesintin, nɩɩ i budu ɩ kyɔ Gyɔn lɛɛ. Lɩɩ fɛɛ kusun mʋ nɩɩ mɛ‐Sɛ mʋ taa sa mɛ nɩɩ n sun falɛ mʋ, ɩɩ lɛɛ kaapʋ kesintin fɛɛ mɛ‐Sɛ mʋ i sun mɛ. ");
INSERT INTO naw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nɩɩ mɛ‐Sɛ mʋ nɩɩ o sun mɛ mʋ gbaa gyii mɛ n‐yɩɩ sʋ kesintin. Nɩɩ fan man pɩɩta nu mʋ ɔbʋlɛ abɛɛ fan wu mʋ yɛ ansi, ");
INSERT INTO naw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","nɩɩ mʋ asɩn mʋ a man bʋ fanɛ nkɔlɔ tɔ, lɩɩ fɛɛ fan man kɔɔlɛ mɛ, ɔmʋ nɩɩ o sun mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Fan payɩ ansi bɩɩla Asɩnkyan yɩlasa mʋ, lɩɩ fɛɛ fɛn fɛ nfɛɛrɛ fɛɛ kanan ɔkpa maŋa sʋ nɩɩ fen biti fan nyɛ nkpa kakpaa, yɛgɛ kanɩn Asɩnkyan yɩlasa maŋa ii gyii mɛ n‐yɩɩ sʋ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Amaa fan kina mɛ asɛ kɩba, kɛ fan ba nyɛ nkpa. ");
INSERT INTO naw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ayɩn‐bi lɩɩ daadimaadi kʋ asɛ man tiri mɛ. ");
INSERT INTO naw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Amaa n nyi fanɛ. N nyi fan maa man sʋ kebiti sa Ɩbwaarɛ fanɛ nkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","N ba mɛ‐Sɛ kɩtɩɩ tɔ, nɩɩ fan man kɔɔlɛ mɛ, amaa nɩɩ ɔkʋ kan ba mʋ gbaa‐gbaa mʋ kɩtɩɩ tɔ mʋ, fan biti fan kɔɔlɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Fan maa biti ayɩn‐bi lɩɩ abaa asɛ falɛ, yɛgɛ fɛn mɛɛ kpan fanɛ n‐yɩɩ fan nyɛ ayɩn‐bi lɩɩ Ɩbwaarɛ nkʋn asɛ mʋ, nɛnɛ nɩɩ fen biti fan waa kɔɔlɛ gyii? ");
INSERT INTO naw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Fan man fɛ nfɛɛrɛ fɛɛ n biti n pwɩɩ fanɛ Mɛ‐Sɛ mu ansi tɔ. Fanɛ naana Mosesi mʋ nɩɩ fan taa fanɛ tamaa tʋʋ mʋ sʋ mʋ, mʋ ɩ gyɛ ɔmʋ nɩɩ ee biti ɔ pwɩɩ fanɛ. ");
INSERT INTO naw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nɩɩ fan kan kɔɔlɛ Mosesi gyii mʋ, naafɔɔ fen biti fan kɔɔlɛ ngbaa mɛ gyii, lɩɩ fɛɛ ɔ kyʋrɔɔ mɛ n‐yɩɩ sʋ asɩn. ");
INSERT INTO naw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amaa nɩɩ fan man kan kɔɔlɛ asɩn mʋ nɩɩ ɔ kyʋrɔɔ lɩɩ mɛ n‐yɩɩ sʋ mʋ gyii mʋ, nɛnɛ nɩɩ fen biti fan waa kɔɔlɛ asɩn mʋ nɩɩ n tɔwɛ falɛ gyii?” ");
INSERT INTO naw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɩnɩmʋ kamaa mʋ, Yesu faa Galile ɔbʋn lala mʋ nɩɩ ba bɩla bɛɛ tɩɩ yɛ Tiberiya mʋ kpee kɩmʋ benben. ");
INSERT INTO naw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nɩɩ asa damantɛ ba buu mʋ, lɩɩ fɛɛ ba wu mʋ asɩn kyinkyinsa mʋ nɩɩ ɔ waa ɛɛ kyɛ alɔpʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tʋtɔ nɩɩ Yesu maa mʋ abɩɩlapʋ ba dii kpee kɩbɩɩ‐bi kʋkʋ sʋ naa kyɩna. ");
INSERT INTO naw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kanɩn saŋa maŋa mʋ, Gyiwu abi Kesu kɔnɔ Kanyaŋɛ nbunɔ kensi‐gyii mʋ ki tiri tɔ. ");
INSERT INTO naw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu maa diyaa mʋ ansi kɩɩ mʋ, o wu sakyɔ damantɛ maa ba mʋ asɛ. Ɩmʋ sʋ ɔ taasɛ Filipu yɛ, “Fɩnɛ nɩɩ an biti an nyɛ agyitɔ sɔɔ sa asa banɩmʋ kpini kɛ bee gyii?” ");
INSERT INTO naw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu tʋʋ Filipu tɔ nɩn kɩɩ, lɩɩ fɛɛ ɔ tɛɛ wʋla o nyi kʋtɔ mʋ nɩɩ ee biti ɔ waa. ");
INSERT INTO naw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nɩɩ Filipu lɛɛ kɔnɔ yɛ, “Pɔyɩ kɛ a taalɛ nyɛ agyitɔ gbɛrɛɛ‐gbɛrɛɛ sa ɔkʋmaa nɩmʋ o gyii mʋ, amɔɔ an biti a nyita ɩbwaayɩ iburuwa kʋkɔka.” ");
INSERT INTO naw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yesu abɩɩlapʋ mʋ tɔ ɔmʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Andiruwu, Simon Pita mu‐supu mʋ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kebii‐nyɩnsa‐bii kʋ bʋ nfɩɩ, nɩɩ ɔ sʋ bodobodo pii‐pii anuu yɛ ɩkɩn‐bi anyɔ. Kanɩn agyitɔ pii nɩmʋ, nɛnɛ nɩɩ ii biti ɩ waa kɛ ɩ fʋʋ asa damantɛ banɩmʋ?” ");
INSERT INTO naw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Fan yɛgɛ asa mʋ ba kyɩna‐kyɩna.” Yɛgɛ afitiri pɔrɔgɛsa a bʋ tʋtɔ kʋkyɔ, ɩmʋ sʋ asa mʋ kpini ba kyʋn kyɩna. Nɩɩ anyɩn mʋ nɩɩ ba bʋ tʋtɔ mʋ kɔnɔ ɩ waa fɛɛ ngbɩn nnuu. ");
INSERT INTO naw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ba maa kyɩna kanɩn mʋ, Yesu taa bodobodo mʋ, nɩɩ ɔ fwaala Ɩbwaarɛ, nɩɩ ɔ taa sa yɛ ba barɩgɛ tɔ sa bamʋ. Kanɩn maŋa nɩɩ ɔ waa ɩkɩn mʋ gbaa. Nɩɩ ɔkʋmaa nɩmʋ nyɛ kanan mʋ nɩɩ ee biti. ");
INSERT INTO naw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ba maa gyii ŋmɛ mʋ, Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Fan tasɛ‐tasɛ agyisan mʋ, kɛ fan man yɛgɛ ɩmʋ ɩkʋ i sii.” ");
INSERT INTO naw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɩmʋ sʋ ba maa gyii bodobodo pii‐pii anu mʋ, ba tasɛ‐tasɛ ɩmʋ agyisan mʋ kpini bɔla alantan kudu anyɔ. ");
INSERT INTO naw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Asa mʋ ba maa wu asɩn kyinkyinsa mʋ nɩɩ Yesu waa mʋ, ba piili bɛɛ tɔwɛ yɛ, “Kesintin, ɔnɩmʋ ɩ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ mʋ nɩɩ ee biti ɔ ba dulinyaa tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu maa bɩɩ fɛɛ, bee biti ba ba taa mʋ ɔlʋn sʋ, kɛ ba naa bun mʋ kuwura mʋ, ɔ bɩla lɩɩ bamʋ tɔ kpee kɩbɩɩ‐bi sʋ mʋ nkʋn. ");
INSERT INTO naw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kalaatɩpwɛ asɛ maa fʋʋ mʋ, Yesu abɩɩlapʋ mʋ ba kpɩlɩgɛ kpee ɔbʋn lala kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nɩɩ ɩ maa sʋla naa fʋʋ kagyanbwɛ yɛgɛ Yesu man pɩɩta bwii ba bamʋ asɛ mʋ, ba naa loo ɔkʋlɩ tɔ bɛɛ faa bee kpee Kapanum. ");
INSERT INTO naw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nɩɩ afuu lala a tigi a daa yɛgɛ nkyu mʋ ii wuli tɔ. ");
INSERT INTO naw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yesu abɩɩlapʋ mʋ ba maa palɛ kpee ansi tɔ fɛɛ mayɩlɩ asa abɛɛ ana mʋ, ba wu Yesu maa naa nkyu mʋ sʋ ɛɛ ba bamʋ ɔkʋlɩ mʋ asɛ, nɩɩ kufuu kɩ kɩtaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Amaa Yesu tɔwɛ bamʋ yɛ, “Mɛ nɩn, fan man waa kufuu.” ");
INSERT INTO naw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nɩɩ ba maa biti fɛɛ ba taa Yesu waa ɔkʋlɩ mʋ tɔ mʋ, opula maŋa tɔ nɩɩ ɔkʋlɩ mʋ dan katɩn mʋ nɩɩ bee biti fɛɛ ba fʋʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ɩmʋ lɩɩkaakɛ mʋ, asa damantɛ mʋ nɩɩ ba sii ɔbʋn lala mʋ benben mʋ, ba wu fɛɛ ɔkʋlɩ kʋlʋn ki sii kɩ dan tʋtɔ ndee nɩɩ kɩmʋ nɩɩ abɩɩlapʋ mʋ ba taa. Amaa Yesu mɔɔ man loo mʋ abɩɩlapʋ mʋ asɛ ɔkʋlɩ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nɩɩ ɩkʋlɩ ɩkʋ mɔɔ ɩ lɩɩ Tiberiya ba dan tʋtɔ tiri katɩn mʋ nɩɩ Ɔnyɩrɩpɛ daa taa afwaala sa Ɩbwaarɛ nɩɩ asa ba gyii agyitɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ɩmʋ sʋ asa damantɛ mʋ ba maa bɩɩ fɛɛ Yesu abɛɛ mʋ abɩɩlapʋ ba man bʋ tʋtɔ mʋ, ba loo ɩkʋlɩ mʋ tɔ kpee Kapanum ba naa bee biti Yesu. ");
INSERT INTO naw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ba maa naa wu mʋ ɔbʋn mʋ benben mʋ, ba taasɛ mʋ yɛ, “Ɔkaapʋpʋ, saŋa mɔɔ nɩɩ fʋ fʋʋ nfɩɩ?” ");
INSERT INTO naw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu lɛɛ bamʋ kɔnɔ yɛ “N tɔwɛ fanɛ kesintin, man gyɛ asɩn kyinkyinsa mʋ nɩɩ fan wu sʋ nɩɩ fan naa fen biti mɛ, amaa lɩɩ fan maa nyɛ agyitɔ gyii ŋmɛ kanan sʋ nɩɩ fen biti mɛ. ");
INSERT INTO naw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Fan man waa kusun biti agyitɔ mʋ nɩɩ ii biti i nyita, amaa fan waa kusun biti agyitɔ mʋ nɩɩ ɩɩ sa nkpa kakpaa. Mɛ, Daadimaadi Obii‐nyɩnsa n biti n sa fanɛ kanɩn agyitɔ mʋ, lɩɩ fɛɛ Mɛ‐Sɛ Ɩbwaarɛ mʋ lɛɛ kaapʋ fɛɛ mʋ kɩbaa kɩ gyan mɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɩmʋ sʋ ba taasɛ Yesu yɛ, “Mɩnɛ ii tiri fɛɛ a waa kɛ a taalɛ waa kusun mʋ nɩɩ Ɩbwaarɛ ii biti?” ");
INSERT INTO naw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Kusun mʋ nɩɩ Ɩbwaarɛ ii biti fɛn waa mʋ ɩ gyɛ yɛ, fan kɔɔlɛ mɛ, ɔmʋ nɩɩ o sun mʋ gyii.” ");
INSERT INTO naw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nɩɩ ba taasɛ mʋ yɛ, “Mɩnɛ asɩn kyinkyinsa nɩɩ fii biti fʋ waa kɛ an wu kɛ a kɔɔlɛ fu gyii? Mɩnɛ nɩɩ fii biti fʋ waa? ");
INSERT INTO naw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Saŋa kʋ tɔ, anɛ naana ana ba gyii agyitɔ mʋ nɩɩ bɛɛ tɩɩ ɩmʋ yɛ Mana mʋ ofuli sʋ, fɛɛ kanan mʋ nɩɩ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ, ‘Ɔ sa bamʋ agyitɔ mʋ nɩɩ ɩ lɩɩ sʋsʋ nɩɩ ba gyii.’ ” ");
INSERT INTO naw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin, man gyɛ Mosesi ɩ sa fanɛ naana ana agyitɔ mʋ nɩɩ ɩ lɩɩ sʋsʋ mʋ. Amaa Mɛ‐Sɛ ɩ sa fanɛ naana kesintin agyitɔ mʋ nɩɩ ɩ lɩɩ sʋsʋ mʋ. Nɩɩ nbɩɩnbɩɩ Mɛ‐Sɛ gbaa ɩɩ sa fanɛ kesintin agyitɔ gbaa‐gbaa mʋ nɩɩ ɩ lɩɩ sʋsʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Lɩɩ fɛɛ Ɩbwaarɛ agyitɔ mʋ nɩɩ ɛɛ sa asa mʋ, ɩ gyɛ ɔmʋ nɩɩ ɔ kpɩlɩgɛ lɩɩ sʋsʋ ba kasɛ sʋ, nɩɩ ɛɛ sa dulinyaa tɔ asa nkpa mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tʋtɔ nɩɩ ba tɔwɛ Yesu yɛ, “Ɔnyɩrɩpɛ, lɩɩ ndaga ɩ sʋ ii kpee sa anɛ kanɩn agyitɔ maŋa saŋa kʋmaa.” ");
INSERT INTO naw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nɩɩ Yesu tɔwɛ bamʋ yɛ “Mɛ ɩ gyɛ agyitɔ mʋ nɩɩ ɩɩ sa nkpa mʋ. Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ ba mɛ asɛ mʋ, akʋn ɩ mɛɛ yɛ a mɔɔ mʋ kakaakʋ, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, bʋlɩfɔ mɛɛ yɛ ɩ kɩtaa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Fɛɛ kanan mʋ nɩɩ n wʋla tɔwɛ fanɛ mʋ, fan wu mɛ, amaa fɛn mɛɛ kɔɔlɛ mɛ fen gyii. ");
INSERT INTO naw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɔkʋmaa mʋ nɩɩ Mɛ‐Sɛ taa sa mɛ mʋ, ii biti ɔ ba mɛ asɛ. Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ ba mɛ asɛ mʋ, mɛɛ yɛ n gya mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Lɩɩ fɛɛ n lɩɩ sʋsʋ ba kasɛ sʋ, kɛ n ba waa ɔmʋ nɩɩ o sun mɛ mʋ kebiti, amaa man gyɛ mɛ gbaa‐gbaa mi kebiti. ");
INSERT INTO naw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ɔmʋ nɩɩ o sun mɛ mʋ kebiti ɩ gyɛ fɛɛ, bamʋ nɩɩ ɔ taa bamʋ sa mɛ mʋ kpini, bamʋ tɔ ɔkʋlʋn gbaa ɔ man fɔyɩ. Amaa n biti n kyiŋi bamʋ ba nkpa tɔ kakɛ laalaalʋwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Lɩɩ fɛɛ Mɛ‐Sɛ kebiti ɩ gyɛ fɛɛ, ɔkʋmaa mʋ nɩɩ o wu mɛ, Mu‐Bii mʋ, nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ ɩɩ nyɛ nkpa kakpaa. Nɩɩ n biti n kyiŋi mʋ lɩɩ lewu tɔ ba nkpa tɔ kakɛ laalaalʋwɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nɩɩ Gyiwu abi mʋ ba piili bɛɛ kɔlɩtɛ bee yii Yesu, lɩɩ fɛɛ ɔ tɔwɛ yɛ, “Mɛ ɩ gyɛ agyitɔ mʋ nɩɩ kɩ lɩɩ sʋsʋ ba kasɛ sʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nɩɩ ba tɔwɛ yɛ, “Man gyɛ Gyosefu mu‐bii mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Yesu mʋ nɩn? An nyi mʋ‐sɛ yɛ mu‐nyi a! Nɩɩ mɩnɛ sʋ nɩɩ, ɛɛ tɔwɛ yɛ, ‘N lɩɩ sʋsʋ nɩn ba?’ ” ");
INSERT INTO naw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tʋtɔ nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fan yɛgɛ fanɛ kɩkɔlɩtɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ɔkʋ mɛɛ taalɛ ba mɛ asɛ, amɔɔ Mɛ‐Sɛ mʋ nɩɩ o sun mɛ mʋ, ɩ yɛgɛ nɩɩ ɔ ba, nɩɩ n biti n kyiŋi mʋ ba nkpa tɔ kakɛ laalaalʋwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ɩbwaarɛ Atɔwɛpʋ ba kyʋrɔɔ yɩla yɛ, ‘Ɔkʋmaa nɩmʋ ii biti ɔ nyɛ Ɩbwaarɛ kɩkaapʋ.’ Nɩɩ ɔkʋmaa mʋ nɩɩ o nu Mɛ‐Sɛ mʋ asɛ, nɩɩ ɔ bɩɩla lɩɩ mʋ asɛ mʋ, ii biti ɔ ba mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ɩnɩmʋ ɩ mɛɛ kaapʋ fɛɛ ɔkʋ tee wu Mɛ‐Sɛ mʋ, amɔɔ ɔmʋ nɩɩ ɔ lɩɩ Mɛ‐Sɛ, Ɩbwaarɛ asɛ mʋ nkʋn i wu mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","N tɔwɛ fanɛ kesintin yɛ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, sʋ nkpa kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɛ ɩ gyɛ agyitɔ mʋ nɩɩ ɩɩ sa nkpa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Fanɛ naana ana ba gyii agyitɔ mʋ nɩɩ bɛɛ tɩɩ yɛ Mana mʋ ofuli sʋ, amaa ba wu. ");
INSERT INTO naw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amaa agyitɔ mʋ nɩɩ ɩ lɩɩ sʋsʋ ba kasɛ sʋ mʋ ndee, nɩɩ ɔkʋmaa mʋ nɩɩ o gyii kanɩn agyitɔ maŋa mʋ, mɛɛ yɛ o wu. ");
INSERT INTO naw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɛ ɩ gyɛ agyitɔ mʋ nɩɩ ɩɩ sa nkpa nɩɩ n kpɩlɩgɛ lɩɩ sʋsʋ ba kasɛ sʋ mʋ. Ɔkʋmaa mʋ nɩɩ o gyii kanɩn agyitɔ nɩmʋ mʋ, ee biti ɔ kyɩna kakpaa. Nɩɩ agyitɔ mʋ nɩɩ n biti n sa dulinyaa tɔ asa kɛ ba nyɛ nkpa mʋ ɩ gyɛ mɛ kayɩɩ‐wʋlɛ.” ");
INSERT INTO naw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Gyiwu abi mʋ ba maa nu Yesu asɩn tɔwɛsa kanɩn mʋ, ɩ waa bamʋ agbʋ. Nɩɩ ba piili bee gyii abaa ɩmɔɔrɛ, bɛɛ taasɛ abaa yɛ, “Nɛnɛ nɩɩ ɔnyɩn nɩmʋ ii biti ɔ waa taa mʋ kayɩɩ‐wʋlɛ sa anɛ kɛ a wɛ?” ");
INSERT INTO naw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin fɛɛ, fan kan fan man wɛ mɛ, Daadimaadi Obii‐nyɩnsa mʋ kayɩɩ‐wʋlɛ, kɛ fen nuu mɛ nkalan de, fɛn mɛɛ yɛ fan nyɛ nkpa. ");
INSERT INTO naw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɔkʋmaa mʋ nɩɩ ɔ wɛ mɛ kayɩɩ‐wʋlɛ, nɩɩ o nuu mɛ nkalan mʋ, ɔ sʋ nkpa kakpaa, nɩɩ n biti n kyiŋi mʋ ba nkpa tɔ kakɛ laalaalʋwɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kpalɩ fɛɛ mɛ kayɩɩ‐wʋlɛ ɩ gyɛ agyitɔ gbaa‐gbaa mʋ, nɩɩ mɛ nkalan ɩ gyɛ atɔ nuusa gbaa‐gbaa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ɔkʋmaa mʋ nɩɩ ɔ wɛ mɛ kayɩɩ‐wʋlɛ, nɩɩ o nuu mɛ nkalan mʋ, ɔ bʋ mɛ tɔ nɩɩ ngbaa mɛ n bʋ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Fɛɛ kanan mʋ nɩɩ Mɛ‐Sɛ mʋ nɩɩ ɔ gyɛ nkpa kumu sun mɛ, nɩɩ lɩɩ mʋ sʋ nɩɩ n sʋ nkpa mʋ, ɔkpa kʋlʋn maŋa sʋ, ɔkʋmaa mʋ nɩɩ ɔ wɛ mɛ kayɩɩ‐wʋlɛ mʋ, ii biti ɔ nyɛ nkpa lɩɩ mɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mɛ ɩ gyɛ agyitɔ mʋ nɩɩ ɩ lɩɩ sʋsʋ ba kasɛ sʋ mʋ. N man du fɛɛ mana agyitɔ mʋ nɩɩ fanɛ naana ana ba gyii, nɩɩ ɩ man sa bamʋ nkpa nɩɩ ba wu mʋ. Amaa ɔkʋmaa mʋ nɩɩ o gyii agyitɔ nɩmʋ bɩrɛ, ee biti ɔ nyɛ nkpa kakpaa.” ");
INSERT INTO naw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu maa bʋ Kapaniyum, Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa ɛɛ kaapʋ mʋ, nɩɩ ɔ tɔwɛ falɛ asɩn nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu abɩɩlapʋ gaalaagaa ba maa nu ɩnɩmʋ mʋ, ba tɔwɛ yɛ, “Falɛ kɩkaapʋ kɩnɩmʋ kɩ bʋlʋn. Anɩmʋ ɩ taalɛ kɔɔlɛ ɩmʋ kyula?” ");
INSERT INTO naw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu maa bɩɩ fɛɛ mʋ abɩɩlapʋ bɛɛ kɔlɩtɛ lɩɩ asɩn mʋ nɩɩ ɔ tɔwɛ mʋ sʋ mʋ, ɔ taasɛ bamʋ yɛ, “Ɩmʋ nɩɩ n tɔwɛ falɛ ɩ kɩtaa fanɛ nfɛɛrɛ nɩn? ");
INSERT INTO naw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kanɩn bɩrɛ nɩɩ fan kan wu mɛ, Daadimaadi Obii‐nyɩnsa n maa bwii n kpee sʋsʋ katɩn mʋ nɩɩ n lɩɩ ba kasɛ sʋ mʋ mɔɔ de? ");
INSERT INTO naw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ɩbwaarɛ Kayaayu mʋ ɩ gyɛ ɔmʋ nɩɩ ɛɛ sa nkpa, amaa kʋtɔ mʋ nɩɩ asa ba sʋ bamʋ ɔlʋn bɛɛ waa mʋ man sʋ tɔnɔ. Asɩn mʋ nɩɩ n tɔwɛ sa fanɛ mʋ, ɩ lɩɩ Kayaayu tɔ nɩn nɩɩ ɩɩ sa nkpa. ");
INSERT INTO naw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amaa yɛgɛ fanɛ tɔ akʋ ba mɛɛ kɔɔlɛ bee gyii.” Yesu tɔwɛ kanɩn lɩɩ fɛɛ ɔ wʋla o nyi lɩɩ npiili asɛ, bamʋ nɩɩ ba man kɔɔlɛ gyii yɛ ɔmʋ nɩɩ ee biti ɔ ba lɛɛ mʋ ɛ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nɩɩ Yesu kyaga sʋ yɛ, “Kpalɩ ɩnɩmʋ sʋ nɩɩ n wʋla tɔwɛ fanɛ yɛ, ɔkʋ mɛɛ taalɛ ba mɛ asɛ mʋ kɩbaa sʋ, amɔɔ Mɛ‐Sɛ Ɩbwaarɛ sa mʋ ɔkpa.” ");
INSERT INTO naw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Lɩɩ kanɩn saŋa maŋa mʋ, nɩɩ mʋ abɩɩlapʋ gaalaagaa ba bwii kamaa, nɩɩ ba man bɩla buu mʋ. ");
INSERT INTO naw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tʋtɔ nɩɩ Yesu taasɛ mʋ abɩɩlapʋ kudu anyɔ mʋ yɛ, “Fanɛ gbaa fanɛ fen biti fan bwii do?” ");
INSERT INTO naw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nɩɩ Simon Pita lɛɛ mʋ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, anɩmʋ asɛ nɩɩ an sʋ an kpee? Fʋ nkʋn ɩ sʋ asɩn mʋ nɩɩ ɩɩ sa nyɩmɩsa nkpa kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","An kɔɔlɛ gyii nɩɩ an bɩɩ fɛɛ fʋ nkʋn ɩ gyɛ Ɔkyɩrɛkyɩrɛpʋ mʋ nɩɩ Ɩbwaarɛ lɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tʋtɔ nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Man gyɛ fanɛ kudu anyɔ mʋ, nɩɩ n lɛɛ? Amaa fanɛ tɔ ɔkʋ gyɛ Sɩtaanɛ.” ");
INSERT INTO naw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gyudasi mʋ nɩɩ mʋ‐sɛ ɩ gyɛ Simon Isikariyoti mʋ asɩn nɩɩ Yesu tɔwɛ mʋ. Halɩɩ Gyudasi maa gyɛ abɩɩlapʋ kudu anyɔ mʋ tɔ ɔkʋ gbaa mʋ, kamaa tɔ mʋ, mʋ ii biti ɔ ba lɛɛ Yesu sa. ");
INSERT INTO naw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ɩnɩmʋ kpini kamaa mʋ, Yesu naa ɔ naa Galile ɔsʋwʋlɛ sʋ. Ee mee biti maa loo Gyudeya ɔsʋwʋlɛ sʋ, lɩɩ fɛɛ Gyiwu abi abɩlɩsa bee biti ba mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Saŋa mʋ nɩɩ Gyiwu abi Kesu kɔnɔ abuu kiyii kensi‐gyii a maa tiri tɔ mʋ, ");
INSERT INTO naw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu mu‐supu ana ba tɔwɛ mʋ yɛ, “Ɩ dagaa fʋ maa lɩɩ nfɩɩ kpee Gyudeya, kɛ fu abuupu ba naa wu fʋ asɩn kyinkyinsa mʋ nɩɩ fɩɩ waa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɔkʋmaa mʋ nɩɩ ee biti yɛ mʋ kɩtɩɩ ki dii mʋ, ɔ mɛɛ waa mʋ asɩn ɛɛ baala. Lɩɩ asɩn kyinkyinsa mʋ nɩɩ fɩɩ waa falɛ mʋ sʋ mʋ, ɩ dagaa fʋ maa lɛɛ fʋ n‐yɩɩ ifuli kaapʋ dulinyaa tɔ asa.” ");
INSERT INTO naw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Halɩɩ mu‐supu ana gbaa ba man kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Mɛ saŋa mʋ nɩɩ ɩ dagaa mʋ, man pɩɩ fʋʋ, fanɛɛ fanɛ saŋa kʋmaa bʋrɔn sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dulinya asa mɛɛ taalɛ kisi fanɛ. Amaa mɛ nɩɩ bee kisi, lɩɩ fɛɛ n gyii bamʋ kesintin fɛɛ bamʋ asunsunsa ɩ gyɛ alibi. ");
INSERT INTO naw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Fanɛ fanɛ fan kpee kensi‐gyii ngyaŋɛ mʋ tɔ. N mɛɛ yɛ n kpee ngyaŋɛ mʋ tɔ nbɩɩnbɩɩ, lɩɩ fɛɛ mɛ saŋa man pɩɩta fʋʋ.” ");
INSERT INTO naw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Maa tɔwɛ ɩnɩmʋ maŋa lʋwɛ mʋ o sii kyɩna Galile. ");
INSERT INTO naw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Amaa Yesu mu‐supu ana ba maa lɩɩ kyʋn kensi‐gyii ngyaŋɛ mʋ tɔ mʋ, mʋ gbaa mʋ kpee nɩɩ ɔ man lɛɛ mʋ n‐yɩɩ ifuli. ");
INSERT INTO naw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kensi‐gyii ngyaŋɛ mʋ tɔ mʋ Gyiwu abɩlɩsa mʋ bɛɛ kɩɩ bee biti mʋ, yɛgɛ bɛɛ taasɛ asa yɛ, “Fɩnɛ nɩɩ ɔnyɩn maŋa bʋ?” ");
INSERT INTO naw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sakyɔ mʋ tɔ asa damantɛ bee muni abaa asɛ lɩɩ mʋ sʋ. Akʋ ba yɛ, “Ɔ gyɛ nyɩmɩsa danbɩrasa.” Nɩɩ akʋ mɔɔ ba yɛ, “Ɛɛ pɩna asa nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amaa ɔkʋ man taalɛ lɩɩ ifuli tɔwɛ Yesu n‐yɩɩ sʋ asɩn, lɩɩ fɛɛ ba maa sɩlɛ Gyiwu abɩlɩsa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ba maa waa kensi‐gyii ngyaŋɛ mʋ naa fʋʋ nsana mʋ, Yesu kpee Kabwaarɛ‐sunkpa ayɛ mʋ tɔ nɩɩ o piili ɛɛ kaapʋ asɩn. ");
INSERT INTO naw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mʋ kɩkaapʋ mʋ i kyinkyin Gyiwu abɩlɩsa mʋ, nɩɩ ba taasɛ yɛ, “Nɛnɛ nɩɩ ɔnyɩn nɩmʋ man bɩɩla nɩɩ ɔ nyɛ falɛ kinyi?” ");
INSERT INTO naw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Mɛ kɩkaapʋ mʋ man gyɛ mɛ gbaa‐gbaa mɛ lɛɛ. Ɩ lɩɩ ɔmʋ nɩɩ o sun mɛ mʋ asɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɔkʋmaa mʋ nɩɩ ee biti ɔ waa Ɩbwaarɛ kebiti mʋ, ee biti ɔ bu fɛɛ mɛ kɩkaapʋ mʋ lɩɩ Ɩbwaarɛ asɛ, abɛɛ n tɔwɛ mɛ gbaa‐gbaa mɛ ɔlʋn sʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɔmʋ nɩɩ ɛɛ tɔwɛ mʋ gbaa‐gbaa mʋ ɔlʋn sʋ mʋ, ɩɩ waa kanɩn nɩn ee biti bʋnyaa ɛɛ sa mʋ n‐yɩɩ. Amaa ɔmʋ nɩɩ ee biti bʋnyaa ɛɛ sa ɔmʋ nɩɩ o sun mʋ mʋ, ɩ gyɛ kesintin wuya, nɩɩ antɩŋɛsa kʋ ɩ man bʋ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesi man sa fanɛ nbara mʋ? Amaa fanɛ ɔkʋ man buu nbara mʋ. Mɩnɛ waa nɩɩ fen biti fan mɔɔ mɛ?” ");
INSERT INTO naw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nɩɩ sakyɔ mʋ ba lɛɛ kɔnɔ yɛ, “Nbwɩɩ libi ba bʋ fʋ tɔ. Anɩmʋ ana ii biti fʋ kɩmɔɔ?” ");
INSERT INTO naw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu tɔwɛ bamʋ yɛ, “N maa waa adangana kʋlʋn kakɛ fʋʋtɛsa akɛ mʋ, nɩɩ ɩmʋ i kyinkyin fanɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesi sa fanɛ oduu kɩtɩn nbara, yɛgɛ kakɛ fʋʋtɛsa akɛ fɛn tɩn kebii oduu. Kesintin tɔ mʋ nbara mʋ man lɩɩ Mosesi asɛ, amaa ɩ lɩɩ anɛ naana ana asɛ. ");
INSERT INTO naw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nɩɩ fan maa tɩn kebii oduu kakɛ fʋʋtɛsa akɛ, kɛ i mee nyita Mosesi nbara mʋ, mɩnɛ ɩ waa nɩɩ n kyɛ nyɩmɩsa laalaamuu kakɛ fʋʋtɛsa akɛ nɩɩ fɛn nyɛ agbʋ waa mɛ? ");
INSERT INTO naw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Fan man kɩɩ nyɩmɩsa awaasa kɛ fan bun mʋ kʋpwɛ, amaa fan kɩɩ asɩn mʋ tɔ danbɩrasa pɔyɩ kɛ fan bun kʋpwɛ.” ");
INSERT INTO naw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nɩɩ Gyerusalem asa akʋ ba piili bɛɛ taasɛ yɛ, “Man gyɛ ɔnyɩn nɩmʋ nɩɩ bee biti mʋ yɛ ba mɔɔ mʋ? ");
INSERT INTO naw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Fan kɩɩ, mʋ ɩ yɩlɛ asa tɔ ɛɛ tɔwɛ mʋ, nɩɩ ɔkʋ mɛɛ tɔwɛ mʋ sɛhn. Abɛɛ abɩlɩsa mʋ ba bɩɩ nɩn fɛɛ mʋ ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ? ");
INSERT INTO naw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ɔnyɩn nɩmʋ bɩrɛ an nyi katɩn mʋ nu ɔ lɩɩ. Amaa Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ kan ba mʋ, ɔkʋ mɛɛ yɛ ɔ bɩɩ katɩn mʋ nɩɩ ɔ lɩɩ.” ");
INSERT INTO naw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu maa san ɔ bʋ Kabwaarɛ‐sunkpa obu lala tɔ ɛɛ kaapʋ, nɩɩ ɔ tɔwɛ kenken yɛ, “Kesintin, fan nyi mɛ, nɩɩ fan nyi katɩn mʋ nɩɩ n lɩɩ. Man gyɛ mɛ gbaa‐gbaa mɛ ɔlʋn sʋ nɩɩ n ba nfɩɩ, amaa ɔmʋ nɩɩ o sun mɛ mʋ gyɛ kesintin wuya nɩɩ fanɛɛ fanɛ fan man nyi mʋ. ");
INSERT INTO naw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amaa mɛɛ mɛ n nyi mʋ, lɩɩ fɛɛ n lɩɩ mʋ asɛ, nɩɩ mʋ i sun mɛ.” ");
INSERT INTO naw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kanɩn sʋ ba biti yɛ ba kɩtaa mʋ, amaa ɔkʋ man taa mʋ kɩbaa mata mʋ, lɩɩ fɛɛ mʋ saŋa man pɩɩta fʋʋ. ");
INSERT INTO naw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɩmʋ kpini gbaa mʋ asa gaalaagaa ba kɔɔlɛ mʋ gyii sakyɔ mʋ tɔ. Nɩɩ bɛɛ taasɛ yɛ, “Nɩɩ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ kan ba mʋ, ee biti ɔ taalɛ waa asɩn kyinkyinsa ɔ kyɔ ɩmʋ nɩɩ ɔnyɩn nɩmʋ waa falɛ?” ");
INSERT INTO naw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farasii abi mʋ ba nu sakyɔ mʋ ba maa muni falɛ asɩn lɩɩ mʋ sʋ. Nɩɩ ba maa Oseepu bɩlɩsa mʋ ba sun Kabwaarɛ‐sunkpa obu lala akɩɩsʋpʋ yɛ ba naa kɩtaa mʋ ba. ");
INSERT INTO naw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N mɛɛ yɛ n bɩla n kyɩna fanɛ asɛ kyɛɛrɛɛ, kɛ n bwii kpee ɔmʋ nɩɩ o sun mɛ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Fen biti fan kɩɩ biti mɛ amaa fan mɛɛ yɛ fan wu mɛ, nɩɩ katɩn mʋ nɩɩ n bʋ mʋ, fan mɛɛ taalɛ ba tʋtɔ.” ");
INSERT INTO naw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nɩɩ Gyiwu abɩlɩsa mʋ bɛɛ taasɛ abaa yɛ, “Fɩnɛ nɩɩ kanyɩn nɩmʋ ii biti o kpee nɩɩ a man bɩla yɛ a wu mʋ? Ee biti o kpee Giriki abi tɔ, katɩn mʋ nɩɩ anɛ asa ba yaasɛ loo, kɛ ɔ naa kaapʋ Giriki abi mʋ abɛɛ? ");
INSERT INTO naw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Maa tɔwɛ yɛ, ‘Fen biti fan biti mɛ amaa fan mɛɛ yɛ fan wu mɛ, nɩɩ katɩn mʋ nɩɩ n bʋ mʋ fan mɛɛ taalɛ ba tʋtɔ mʋ’ mɩnɛ nɩɩ ɛɛ kaapʋ?” ");
INSERT INTO naw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nɩɩ kakɛ laalaalʋwɛ mʋ nɩɩ kɩ gyɛ kakɛ kparɛ kensi‐gyii mʋ tɔ mʋ, Yesu kʋsʋ yɩlɛ nɩɩ ɔ tɔwɛ kenken yɛ, “Ɔkʋmaa mʋ nɩɩ bʋlɩfɔ kan ɔ sʋ mʋ mʋ, ɔ ba mɛ asɛ ba nuu nkyu. ");
INSERT INTO naw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, nkyu mʋ nɩɩ ɩɩ sa nkpa mʋ ii biti ɩ baa ɩ lɩɩ mʋ tɔ ɩɩ kyʋn fɛɛ ɔbʋn, fɛɛ kanan mʋ nɩɩ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nkyu mʋ nɩɩ ɩɩ sa nkpa asɩn mʋ nɩɩ Yesu tɔwɛ nfɩɩ mʋ, yɩlɛ sa Kayaayu Kyɩrɛkyɩrɛ, nɩɩ bamʋ nɩɩ ba kɔɔlɛ mʋ gyii mʋ, bee biti ba ba nyɛ. Saŋa maŋa tɔ mʋ Kayaayu Kyɩrɛkyɩrɛ mʋ man pɩɩ ba, lɩɩ fɛɛ Yesu bʋnyaa man pɩɩta lɩɩ ifuli. ");
INSERT INTO naw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sakyɔ mʋ ba maa nu maa tɔwɛ falɛ asɩn mʋ, bamʋ akʋ ba tɔwɛ yɛ, “Kesintin tɔ, ɔnyɩn nɩmʋ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Akʋ ba yɛ, “Mʋ ɩ gyɛ Krisito mʋ.” Nɩɩ akʋ mɔɔ ba taasɛ yɛ, “Nɛnɛ nɩɩ Krisito ii biti ɔ lɩɩ Galile? ");
INSERT INTO naw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ Krisito ii biti ɔ lɩɩ Owura Dawidi kanan tɔ, kɛ ba kʋʋgɛ mʋ Betilehem kadɛ tɔ katɩn mʋ nɩɩ Owura Dawidi daa kyɩna mʋ” ");
INSERT INTO naw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lɩɩ kanɩn sʋ nbarɩgɛ tɔ ɩ ba sakyɔ mʋ tɔ lɩɩ Yesu sʋ. ");
INSERT INTO naw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nɩɩ bamʋ akʋ bee biti ba kɩtaa mʋ, amaa ɔkʋ man taa kɩbaa mata mʋ. ");
INSERT INTO naw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nɩɩ Kabwaarɛ‐sunkpa akɩɩsʋpʋ mʋ ba bwii kpee Ɩbwaarɛ aseepu abɩlɩsa yɛ Farasii abi mʋ asɛ, nɩɩ ba taasɛ bamʋ yɛ, “Mɩnɛ waa nɩɩ fan man kɩtaa mʋ ba?” ");
INSERT INTO naw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nɩɩ akɩɩsʋpʋ mʋ ba lɛɛ kɔnɔ yɛ, “Nyɩmɩsa kʋ man pɩɩta tɔwɛ asɩn fɛɛ ɔnyɩn nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nɩɩ Farasii abi mʋ ba taasɛ bamʋ yɛ, “Ɩmʋ sʋ ɔ bɩla pɩna fanɛ gbaa fanɛ? ");
INSERT INTO naw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Fan wu kadɛ nɩmʋ tɔ abɩlɩsa abɛɛ Farasii abi mʋ tɔ ɔkʋ maa kɔɔlɛ mʋ gyii? Ayee! ");
INSERT INTO naw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amaa sakyɔ mʋ nɩɩ ba kɔɔlɛ mʋ gyii mʋ bɩrɛ ba man nyi Mosesi nbara mʋ, ɩmʋ sʋ Ɩbwaarɛ nnɔ mʋ nɩɩ ɔ tɔwɛ yɩla ii biti ɩ ba bamʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemusi mʋ nɩɩ ɔ wʋla ba Yesu asɛ kakaakʋ, nɩɩ ɔ gyɛ bamʋ abɩlɩsa mʋ tɔ ɔkʋ mʋ, taasɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Anɛ nbara ɩɩ sa ɔkpa fɛɛ a taalɛ bun nyɩmɩsa kʋpwɛ yɛgɛ a man nu mʋ kɔnɔ tɔ asɩn wu kʋtɔ mʋ nɩɩ ɔ waa?” ");
INSERT INTO naw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nɩɩ ba lɛɛ mʋ kɔnɔ yɛ, “Ngbaa fʋ, fʋ lɩɩ Galile nɩn? Kɩɩ Asɩnkyan yɩlasa mʋ tɔ danbɩrasa, fii biti fu wu fɛɛ Ɩbwaarɛ ɔtɔwɛpʋ kʋ man lɩɩ Galile.” ");
INSERT INTO naw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nɩɩ ba kʋsʋ ngyaŋɛ mʋ tɔ, nɩɩ ɔkʋmaa nɩmʋ kpee mʋ ayɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ɔkʋmaa nɩmʋ maa kyʋn mʋ ayɛ mʋ, nɩɩ Yesu lɩɩ tʋtɔ kpee Olifu kɩbɩɩ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ɩmʋ lɩɩkaakɛ nyenyenfuu mʋ, Yesu bwii ba Kabwaarɛ‐sunkpa obu lala mʋ tɔ. Nɩɩ asa ba ba yɩlɛ kyaabɔɔ mʋ, nɩɩ ɔ kyʋn kyɩna nɩɩ o piili ɛɛ kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Maa bʋ tʋtɔ mʋ, nɩɩ nbara akaapʋpʋ yɛ Farasii abi ba bɩya ɔkyɩɩ kilipu kʋ mʋ nɩɩ ba kɩtaa mʋ maa ɔnyɩn. Nɩɩ ba taa mʋ ba yɩlɛ bamʋ nsana. ");
INSERT INTO naw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nɩɩ ba tɔwɛ Yesu yɛ, “Ɔkaapʋpʋ, ba kɩtaa ɔkyɩɩ nɩmʋ maa ɔnyɩn. ");
INSERT INTO naw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesi nbara mʋ ɩɩ kaapʋ anɛ yɛ a tʋʋ abuu mɔɔ kanɩn akyɩɩ maŋa. Nbɩɩnbɩɩ, nɛnɛ nɩɩ fʋ sʋ fɩɩ tɔwɛ.” ");
INSERT INTO naw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba taasɛ mʋ asɩn nɩmʋ kɛ ba nu mʋ kɔnɔ tɔ alibi, kɛ ba nyɛ yɩlɛ ɩmʋ sʋ pwɩɩ mʋ. Amaa Yesu nyɔn mu kumu yii tɔ, taa mʋ kɩbaa‐bi ɛɛ kyʋrɔɔ kasɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ba maa maa sʋ bɛɛ taasɛ mʋ mʋ, ɔ kʋsaa mu kumu nɩɩ ɔ tɔwɛ bamʋ yɛ, “Nɩɩ fanɛ tɔ ɔkʋ mʋ nɩɩ ɔ man pɩɩta waa alibi mʋ, ɔ gyankpaa tʋʋ kubuu da ɔkyɩɩ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nɩɩ o bwii nyɔn mu kumu yii tɔ ɛɛ kyʋrɔɔ kasɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nɩɩ ba maa nu kanɩn mʋ, ba piili bɛɛ lɩɩ kʋkʋlʋn‐kʋkʋlʋn. Abɩlɩsa mʋ ba gyankpaa lɩɩ pɔyɩ. Nɩɩ ɩ san Yesu maa ɔkyɩɩ mʋ nkʋn yɛgɛ ɔ yɩlɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nɩɩ Yesu kusaa mu kumu nɩɩ ɔ taasɛ ɔkyɩɩ mʋ yɛ, “Ɔkyɩɩ, ba bʋ fɩnɛ? Ɔkʋ man bʋ tɔ kɛ o bun fʋ kʋpwɛ fʋ?” ");
INSERT INTO naw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, ayee, ɔkʋ man bʋ tɔ.” Nɩɩ Yesu tɔwɛ mʋ yɛ, “Ngbaa mɛ mɛɛ yɛ n bun fʋ kʋpwɛ. Natɛ, lɩɩ ndaga ɩɩ sʋ ii kpee man bɩla naa waa alibi.” ");
INSERT INTO naw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nɩɩ Yesu bwii tɔwɛ Farasii abi mʋ nɩɩ ba bʋ tʋtɔ mʋ yɛ, “Mɛ ɩ gyɛ dulinyaa tɔ ɩŋmaŋɛsa mʋ. Ɔkʋmaa mʋ nɩɩ o buu mɛ mʋ, mɛɛ yɛ ɔ natɛ kitentenbiri tɔ, amaa ee biti ɔ nyɛ ɩŋmaŋɛsa mʋ nɩɩ kɩɩ sa nkpa mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nɩɩ Farasii abi mʋ ba tɔwɛ mʋ yɛ, “Nbɩɩnbɩɩ, fii gyii fʋ gbaa‐gbaa fʋ n‐yɩɩ sʋ kesintin nɩn, ɩmʋ sʋ a mɛɛ yɛ a taalɛ kɔɔlɛ fu gyii.” ");
INSERT INTO naw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Halɩɩ nɩɩ n gyii mɛ n‐yɩɩ sʋ kesintin gbaa mʋ, mɛ asɩn mʋ ɩ gyɛ kesintin. Lɩɩ fɛɛ n nyi katɩn mʋ nɩɩ n lɩɩ nɩɩ n nyi katɩn mʋ nɩɩ n kpee. Amaa fanɛɛ fanɛ bɩrɛ, fan man nyi katɩn mʋ nɩɩ n lɩɩ, nɩɩ fan man nyi katɩn mʋ nɩɩ n kpee. ");
INSERT INTO naw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Fanɛ bɩrɛ, nyɩmɩsa ɩkpa sʋ nɩɩ fɛn yɩlɛ sʋ fen gyii asɩn. Mɛɛ mɛ bɩrɛ n mee gyii ɔkʋ asɩn. ");
INSERT INTO naw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amaa nɩɩ n kan gyii asɩn mʋ, mɛ asɩn kigyii kɩ dɛ ɔkpa, lɩɩ fɛɛ man gyɛ mɛ nkʋn ii gyii asɩn mʋ. Amaa maa Mɛ‐Sɛ mʋ nɩɩ o sun mɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ba kyʋrɔɔ fanɛ Nbara tɔ yɛ, nɩɩ asa anyɔ bee gyii kesintin lɩɩ asɩn kʋ sʋ, nɩɩ bamʋ nnɔ ɩ man kpakyarɛ mʋ, bamʋ asɩn mʋ ɩ gyɛ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mɛ gbaa‐gbaa mɛ ii gyii mɛ n‐yɩɩ sʋ kesintin, nɩɩ Mɛ‐Sɛ mʋ nɩɩ o sun mɛ mʋ gbaa ii gyii mɛ n‐yɩɩ sʋ kesintin.” ");
INSERT INTO naw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nɩɩ ba taasɛ mʋ yɛ, “Fʋ‐sɛ bʋ fɩnɛ?” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Fan man nyi mɛ, nɩɩ fan man nyi Mɛ‐Sɛ mʋ gbaa. Nɩɩ fan daa fan nyi mɛ nɩn, naafɔɔ fan bɩɩ Mɛ‐Sɛ mʋ gbaa.” ");
INSERT INTO naw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu tɔwɛ asɩn nɩmʋ saŋa mʋ nɩɩ ɛɛ kaapʋ asɩn Kabwaarɛ‐sunkpa ayɛ mʋ, katɩn mʋ nɩɩ bɛɛ tɩɩ yɛ afulee ɔyɩlɛkpa mʋ. Amaa ɔkʋ man kɩtaa mʋ, lɩɩ fɛɛ mʋ saŋa man pɩɩta fʋʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nɩɩ Yesu bwii tɔwɛ bamʋ yɛ, “N kpee nɩmʋ. Nɩɩ fen biti fan kɩɩ biti mɛ, kɛ fan wu fanɛ alibi tɔ. Nɩɩ katɩn mʋ nɩɩ n kpee mʋ fɛn mɛɛ taalɛ ba tʋtɔ.” ");
INSERT INTO naw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nɩɩ Gyiwu abi mʋ bɛɛ taasɛ abaa yɛ, “Maa tɔwɛ yɛ, ‘Katɩn mʋ nɩɩ n kpee mʋ fɛn mɛɛ taalɛ ba tʋtɔ’ mʋ, ee biti ɔ mɔɔ mʋ n‐yɩɩ nɩn abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nɩɩ ɔ kyaga sʋ tɔwɛ yɛ, “Fan lɩɩ kasɛ sʋ nfɩɩ nɩn, mɛɛ mɛ n lɩɩ sʋsʋ. Nɩɩ fan gyɛ dulinyaa nɩmʋ lɛɛ nɩn, mɛɛ mɛ bɩrɛ n man gyɛ dulinyaa nɩmʋ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kanɩn sʋ nɩɩ n tɔwɛ fanɛ yɛ, fen biti fan wu fanɛ alibi tɔ mʋ. Nɩɩ fan man kan kɔɔlɛ mɛ gyii yɛ, mɛ ɩ gyɛ ɔmʋ nɩɩ n tɔwɛ yɛ n gyɛ mʋ, fen biti fan wu fanɛ alibi tɔ kesintin.” ");
INSERT INTO naw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nɩɩ ba taasɛ mʋ yɛ, “Fʋ ɩ gyɛ anɩmʋ?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Mɛ ɩ gyɛ ɔmʋ nɩɩ n dan wʋla n tɔwɛ fanɛ yɛ n gyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N sʋ asɩn gaa n tɔwɛ lɩɩ fanɛ sʋ, kɛ n taa gyii fanɛ asɩn. Amaa ɔmʋ nɩɩ o sun mɛ mʋ gyɛ kesintin wuya, nɩɩ asɩn mʋ nɩɩ n nu lɩɩ mʋ asɛ mʋ nkʋn nɩɩ n tɔwɛ n sa dulinyaa abi.” ");
INSERT INTO naw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɩmʋ kpini gbaa mʋ ba man pɩɩta bɩɩ fɛɛ Mʋ‐Sɛ Ɩbwaarɛ asɩn nɩɩ ɛɛ tɔwɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɩmʋ sʋ Yesu tɔwɛ bamʋ yɛ, “Nɩɩ fan kan ba kʋsaa mɛ, Daadimaadi Obii‐nyɩnsa mʋ sʋsʋ mʋ, tʋtɔ nɩɩ fen biti fan bɩɩ fɛɛ n gyɛ ɔmʋ nɩɩ n wʋla tɔwɛ yɛ n gyɛ mʋ, nɩɩ n mɛɛ waa kʋtɔ kʋ mɛ gbaa‐gbaa mɛ ɔlʋn sʋ, amaa asɩn mʋ nɩɩ Mɛ‐Sɛ kaapʋ mɛ mʋ, ɩmʋ nɩɩ n sʋ n tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ɔmʋ nɩɩ o sun mɛ mʋ bʋ mɛ asɛ, ɔ man yɛgɛ mɛ nkʋn, lɩɩ fɛɛ saŋa kʋmaa n waa kʋtɔ mʋ nɩɩ ɩɩ pɩrɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nɩɩ asa mʋ nɩɩ ba nu Yesu maa tɔwɛ ɩnɩmʋ kpini mʋ gaalaagaa ba kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nɩɩ Yesu tɔwɛ Gyiwu abi mʋ nɩɩ ba kɔɔlɛ mʋ gyii mʋ yɛ, “Nɩɩ fan kan fan buu mɛ asɩn kaapʋsa mʋ, fan gyɛ mɛ abɩɩlapʋ kesintin tɔ. ");
INSERT INTO naw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nɩɩ fen biti fan bɩɩ kesintin mʋ, kɛ kesintin mʋ ɔ yɛgɛ fan nyɛ fanɛ n‐yɩɩ.” ");
INSERT INTO naw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nɩɩ ba lɛɛ kɔnɔ yɛ, “An gyɛ Abraham kɩnaana tɔ asa nɩn. Nɩɩ anɛɛnɛ bɩrɛ, kakaakʋ a man pɩɩta waa ɔkʋ kɩnyɛ. Nɩɩ mɩnɛ sʋ nɩɩ fɩɩ tɔwɛ yɛ an biti a nyɛ anɛ n‐yɩɩ?” ");
INSERT INTO naw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “N tɔwɛ fanɛ kesintin, ɔkʋmaa mʋ nɩɩ ɛɛ waa alibi mʋ gyɛ kɩnyɛ sa alibi nɩn. ");
INSERT INTO naw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nɩɩ kɩnyɛ man gyɛ ɔsa mʋ nɩɩ o tii kɩkpaara abi sʋ, amaa obii bɩrɛ gyɛ kɩkpaara mʋ sʋ obii kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ɩmʋ sʋ nɩɩ Ɩbwaarɛ Mu‐Bii mʋ yɛgɛ nɩɩ ɔkʋ nyɛ mʋ n‐yɩɩ mʋ, kesintin tɔ ɔ nyɛ mʋ n‐yɩɩ kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N nyi fan maa gyɛ Abraham anaana‐bii. Amaa ɩnɩmʋ kpini gbaa mʋ, fen biti fɛɛ fan mɔɔ mɛ, lɩɩ fɛɛ fɛn mɛɛ kɔɔlɛ mɛ asɩn mʋ fɛn waa fanɛ nkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kʋtɔ mʋ nɩɩ Mɛ‐Sɛ kaapʋ mɛ mʋ nɩɩ n tɔwɛ fanɛ falɛ. Nɩɩ fanɛɛ fanɛ fɛn waa atɔ mʋ nɩɩ fan nu lɩɩ fanɛ‐sɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Anɛ‐sɛ ɩ gyɛ Abraham.” Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan daa fan gyɛ Abraham mu‐bii ana kesintin tɔ nɩn, naafɔɔ fen biti fan waa kʋtɔ mʋ nɩɩ ɔ waa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Amaa n maa tɔwɛ fanɛ kesintin mʋ nɩɩ n nu lɩɩ Ɩbwaarɛ asɛ gbaa mʋ, fen biti fan mɔɔ mɛ. Abraham man waa falɛ atɔ. ");
INSERT INTO naw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Atɔ mʋ nɩɩ fanɛ‐sɛ waa mʋ, nɩɩ fanɛ gbaa fanɛ fɛn waa.” Nɩɩ ba lɛɛ kɔnɔ yɛ, “A man gyɛ akuyurubi, ɔsɛ kʋlʋn nɩɩ an sʋ, mʋ ɩ gyɛ Ɩbwaarɛ gbaa‐gbaa mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Ɩbwaarɛ daa ɔ gyɛ fanɛ‐Sɛ nɩn, naafɔɔ fen biti fan nyɛ kebiti sa mɛ, lɩɩ fɛɛ n lɩɩ Ɩbwaarɛ asɛ nɩn, nɩɩ n ba nfɩɩ. Man gyɛ mɛ gbaa‐gbaa mɛ ɔlʋn sʋ nɩɩ n ba, amaa mʋ i sun mɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nɩɩ mɩnɛ waa sʋ nɩɩ fen mee nu mɛ asɩn tɔwɛsa mʋ kasɛ? Lɩɩ fɛɛ fɛn mɛɛ taalɛ fen nu mɛ asɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Fan gyɛ fanɛ‐sɛ Sɩtaanɛ mu‐bii ana nɩn, ɩmʋ sʋ nɩɩ fen biti fan waa fanɛ‐sɛ mʋ kɔkɔlɔ biti. Lɩɩ npiili asɛ mʋ kpini nɩɩ ɔ gyɛ ɔmɔɔpʋ, nɩɩ ɔ man buu kesintin, lɩɩ fɛɛ kesintin man bʋ mʋ tɔ. Mʋ lɛɛ kpini ɩ gyɛ fɛɛ ɔ tɔwɛ antɩŋɛsa, lɩɩ fɛɛ ɔ gyɛ antɩŋɛsa wuya, yɛ antɩŋɛsa wuya ana bamʋ‐sɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amaa mɛɛ mɛ bɩrɛ n gyii fanɛ kesintin nɩn, ɩmʋ sʋ nɩɩ fɛɛ mɛɛ kɔɔlɛ mɛ fen gyii. ");
INSERT INTO naw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Fanɛ tɔ anɩmʋ ɩ taalɛ kaapʋ fɛɛ n gyii alibi kʋpwɛ? Nɩɩ n maa tɔwɛ kesintin mʋ, mɩnɛ waa nɩɩ fɛn mɛɛ kɔɔlɛ fen gyii? ");
INSERT INTO naw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ɔmʋ nɩɩ ɔ gyɛ Ɩbwaarɛ lɛɛ mʋ, ii nu asɩn mʋ nɩɩ Ɩbwaarɛ tɔwɛ. Kʋtɔ mʋ sʋ nɩɩ fen mee nu Ɩbwaarɛ asɩn mʋ ɩ gyɛ yɛ fan man gyɛ Ɩbwaarɛ lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nɩɩ Gyiwu abi mʋ mɔɔ ba tɔwɛ Yesu yɛ, “Nɩɩ a maa tɔwɛ yɛ fʋ gyɛ Kasamariya‐nyɩn nɩɩ nbwɩɩ libi ba tɛ fʋ tɔ mʋ, ɩ man gyɛ kesintin?” ");
INSERT INTO naw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nɩɩ Yesu lɛɛ kɔnɔ yɛ “Nbwɩɩ libi akʋ ba man tɛ mɛ tɔ, amaa n bʋnyaa mɛ‐Sɛ, yɛgɛ fanɛɛ fanɛ fɛn mɛɛ bʋnyaa mɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","N mee biti bʋnyaa n sa mɛ n‐yɩɩ. Amaa ɔkʋ bʋ tɔ ee biti kɩmʋ ɛɛ sa mɛ. Mʋ ɩ gyɛ asɩn ogyipu mʋ. ");
INSERT INTO naw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","N tɔwɛ fanɛ kesintin yɛ, ɔkʋmaa mʋ nɩɩ o buu mɛ kɩkaapʋ mʋ, ɔ mɛɛ yɛ o wu kakaakʋ.” ");
INSERT INTO naw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nɩɩ Gyiwu abi mʋ ba tɔwɛ yɛ, “Nbɩɩnbɩɩ an wu kesintin tɔ fɛɛ nbwɩɩ libi ba bʋ fʋ tɔ. Abraham wu, nɩɩ Ɩbwaarɛ atɔwɛpʋ mʋ gbaa ba wu. Amaa fʋ, fʋ tɔwɛ yɛ ɔkʋmaa mʋ nɩɩ o buu fʋ kɩkaapʋ mʋ ɔ mɛɛ yɛ o wu. ");
INSERT INTO naw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ɩmʋ sʋ fii biti fʋ kaapʋ fɛɛ fʋ kyɔ anɛ‐sɛ Abraham abɛɛ? O wu, nɩɩ Ɩbwaarɛ atɔwɛpʋ mʋ gbaa ba wu. Anɩmʋ nɩɩ fɩɩ fɛ nfɛɛrɛ fɛɛ fʋ gyɛ?” ");
INSERT INTO naw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Nɩɩ n kan sa mɛ n‐yɩɩ bʋnyaa mʋ, mɛ bʋnyaa mʋ gyɛ kɩyan. Amaa mɛ‐Sɛ, mʋ nɩɩ fɛn tɔwɛ yɛ mʋ ɩ gyɛ fanɛ Ɩbwaarɛ mʋ, ɩ gyɛ ɔmʋ nɩɩ ɛɛ bʋnyaa mɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Fan man nyi mʋ, mɛɛ mɛ bɩrɛ n nyi mʋ. Nɩɩ n kan n tɔwɛ yɛ n man n nyi mʋ mʋ, n gyɛ antɩŋɛsa wuya fɛɛ fanɛ, amaa n nyi mʋ, nɩɩ n nu mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Fanɛ‐sɛ Abraham mu ansi i gyii fɛɛ ee biti o wu mɛ kɩba. Nɩɩ o wu mɛ kɩba mʋ, nɩɩ mu ansi i gyii.” ");
INSERT INTO naw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nɩɩ Gyiwu abi mʋ ba taasɛ mʋ yɛ, “Fʋ man pɩɩta gyii nsu adunuu nɩɩ fʋ yɛ fu wu Abraham?” ");
INSERT INTO naw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “N tɔwɛ fanɛ kesintin yɛ, pɔyɩ kɛ ba kʋʋgɛ Abraham mʋ, yɛgɛ n bʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ba maa nu falɛ mʋ, nɩɩ ba kukuri abuu yɛ ba tʋʋ mʋ. Amaa Yesu loo asa mʋ tɔ bʋlɛ, nɩɩ ɔ lɩɩ Kabwaarɛ‐sunkpa ayɛ mʋ tɔ kyʋn. ");
INSERT INTO naw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu maa naa ɛɛ kyʋn mʋ, o wu ɔnyɩn mʋ nɩɩ ɔ gyɛ gyaatanapʋ lɩɩ saŋa mʋ nɩɩ ba kʋʋgɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tʋtɔ nɩɩ Yesu abɩɩlapʋ ba taasɛ mʋ yɛ, “Ɔkaapʋpʋ, mɩnɛ sʋ nɩɩ ba kʋʋgɛ ɔnyɩn nɩmʋ gyaatanapʋ? Mʋ gbaa‐gbaa alibi sʋ abɛɛ mʋ akʋʋgɛpʋ alibi sʋ?” ");
INSERT INTO naw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Mʋ kɩgyatana mʋ, ɩ man lɩɩ mu alibi sʋ abɛɛ mʋ akʋʋgɛpʋ alibi sʋ. Amaa ɩ waa kanɩn nɩn kɛ Ɩbwaarɛ ɔ yɛgɛ asa ba wu kanan mʋ nɩɩ ee biti ɔ waa asɩn kyinkyinsa sa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kyɔwɛ maa dan san ɔ bʋ tɔ falɛ bɩrɛ, ɩ dagaa a maa waa ɔmʋ nɩɩ o sun mɛ mu kusun. Kyɔwɛ ii biti ɔ lʋwɛ yɛgɛ ɔkʋ mɛɛ bɩla taalɛ sun kusun. ");
INSERT INTO naw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","N maa dan san n bʋ dulinyaa tɔ falɛ bɩrɛ, mɛ ɩ gyɛ dulinyaa tɔ ɩŋmaŋɛsa mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu maa tɔwɛ ɩnɩmʋ mʋ, nɩɩ ɔ tʋʋ nkyɔlɛ tʋʋ kasɛ nɩɩ ɔ palɛ ɩsɛ, taa tayɩ ɔnyɩn mu ansi sʋ. ");
INSERT INTO naw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nɩɩ ɔ tɔwɛ ɔnyɩn mʋ yɛ, “Kpe Silom kapatɩyɛ mʋ tɔ naa fwɩɩ fu ansi.” (Silom kasɛ ɩ gyɛ yɛ ba sun mʋ). Ɔnyɩn mʋ maa naa fwɩɩ mu ansi bwii ba mʋ, mu ansi mʋ a bugi. ");
INSERT INTO naw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mʋ bɩrɩsa ana yɛ asa mʋ nɩɩ ba wʋla be nyi mʋ maa kyɩna ɔkpa asɛ ɛɛ kʋlɛ mʋ, bɛɛ taasɛ abaa yɛ, “Man gyɛ ɔnyɩn nɩmʋ ɩɩ kyɩna ɔkpa asɛ ɛɛ kʋlɛ mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nɩɩ bamʋ akʋ ba yɛ, “Mʋ nɩn.” Nɩɩ akʋ mɔɔ ba yɛ, “Man gyɛ mʋ nɩn, o duli mʋ nɩn.” Amaa ɔnyɩn mʋ gbaa‐gbaa tɔwɛ yɛ, “Mɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nɩɩ ba taasɛ mʋ yɛ, “Ɩ waa nɛnɛ nɩɩ fu ansi i bugi?” ");
INSERT INTO naw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nɩɩ ɔ lɛɛ bamʋ kɔnɔ yɛ, “Ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Yesu mʋ, ɩ palɛ ɩsɛ tayɩ mi ansi sʋ. Nɩɩ ɔ tɔwɛ mɛ yɛ n kpee Silom kapatɩyɛ mʋ tɔ naa fwɩɩ mi ansi. Ɩmʋ sʋ n kpee tʋtɔ naa fwɩɩ mi ansi, nɩɩ opula maŋa tɔ nɩɩ mi ansi i bugi.” ");
INSERT INTO naw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nɩɩ ba taasɛ mʋ yɛ, “Ɔnyɩn mʋ bʋ fɩnɛ?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “N man nyi.” ");
INSERT INTO naw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tʋtɔ nɩɩ ba taa ɔnyɩn mʋ nɩɩ mu ansi i bugi mʋ kpee Farasii abi mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kanɩn kakɛ mʋ nɩɩ Yesu palɛ ɩsɛ tayɩ kanɩn ɔnyɩn ansi sʋ mʋ, gyɛ kakɛ fʋʋtɛsa nɩn. ");
INSERT INTO naw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nɩɩ Farasii abi mʋ mɔɔ ba taasɛ mʋ kanan mʋ nɩɩ ɩ waa nɩɩ mu ansi i bugi. Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Ɔ palɛ ɩsɛ nɩn tayɩ mi ansi sʋ, nɩɩ n naa fwɩɩ, nɩɩ mi ansi i bugi.” ");
INSERT INTO naw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tʋtɔ nɩɩ Farasii abi mʋ akʋ ba yɛ, “Ɔnyɩn mʋ nɩɩ ɔ waa kanɩn asɩn maŋa mʋ, man lɩɩ Ɩbwaarɛ asɛ, lɩɩ fɛɛ o mee buu kakɛ fʋʋtɛsa nbara mʋ.” Amaa akʋ mɔɔ ba yɛ, “Nɛnɛ nɩɩ alibi ɔwaapʋ ɩ taalɛ waa asɩn kyinkyinsa falɛ kudubi?” Nɩɩ nbarɩgɛ ɩ ba bamʋ nsana. ");
INSERT INTO naw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɩnɩmʋ kpini kamaa mʋ, Farasii abi mʋ ba bwii taasɛ ɔnyɩn mʋ yɛ, “Ɔnyɩn mʋ nɩɩ o bugi fu ansi mʋ, mɩnɛ asɩn nɩɩ fʋ sʋ fʋ tɔwɛ lɩɩ mʋ sʋ?” Nɩɩ ɔnyɩn mʋ lɛɛ kɔnɔ yɛ, “Ɔ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Gyiwu abɩlɩsa mʋ be mee biti ba kɔɔlɛ gyii fɛɛ ɔ wʋla ɔ gyɛ gyaatanapʋ, nɩɩ mu ansi i bugi, ɩmʋ sʋ ba sun tɩɩ mʋ akʋʋgɛpʋ. ");
INSERT INTO naw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ba maa ba mʋ, ba taasɛ bamʋ yɛ, “Fanɛ‐bii‐nyɩnsa ndee? Fan yɛ fan kʋʋgɛ mʋ gyaatanapʋ nɩn, nɛnɛ ɩ waa sʋ nɩɩ ɔ kɩɩ nbɩɩnbɩɩ?” ");
INSERT INTO naw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nɩɩ mʋ akʋʋgɛpʋ ba lɛɛ kɔnɔ yɛ, “An nyi maa gyɛ anɛ‐bii‐nyɩnsa nɩn, nɩɩ an kʋʋgɛ mʋ gyaatanapʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amaa a man nyi kanan mʋ nɩɩ ɩ waa nɩɩ mu ansi ɩ kɩɩ, abɛɛ ɔmʋ nɩɩ o bugi mu ansi. Ɔ man bɩla ɔ gyɛ kebii, ɩmʋ sʋ fan taasɛ mʋ gbaa‐gbaa, ɛɛ taalɛ lɛɛ kɔnɔ.” ");
INSERT INTO naw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kʋtɔ mʋ sʋ nɩɩ ba tɔwɛ kanɩn mʋ ɩ gyɛ yɛ ba sɩlɛ Gyiwu abɩlɩsa mʋ. Kpalɩ fɛɛ Gyiwu abɩlɩsa mʋ ba wʋla tɔwɛ yɩla yɛ ɔkʋmaa mʋ nɩɩ ee biti ɔ lɛɛ tɔwɛ yɛ Yesu ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ mʋ, bɛɛ gya mʋ ba lɛɛ ɔgyaŋɛkpa obu mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kanɩn sʋ nɩɩ mʋ akʋʋgɛpʋ mʋ ba tɔwɛ yɛ, “Ɔ man bɩla ɔ gyɛ kebii, fan taasɛ mʋ gbaa‐gbaa mu.” ");
INSERT INTO naw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gyiwu abɩlɩsa mʋ ba bwii tɩɩ ɔnyɩn mʋ nɩɩ naafɔɔ ɔ gyɛ gyaatanapʋ mʋ kɩnyɔsapʋ, nɩɩ ba tɔwɛ mʋ yɛ, “Bɔ Ɩbwaarɛ fɛɛ kesintin nɩɩ fɩɩ tɔwɛ. An nyi fɛɛ ɔnyɩn mʋ nɩɩ o bugi fu ansi mʋ gyɛ alibi ɔwaapʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nɩɩ ɔnyɩn mʋ lɛɛ bamʋ kɔnɔ yɛ, “Mɛɛ mɛ man nyi yɛ ɔ gyɛ alibi ɔwaapʋ abɛɛ ɔ man gyɛ. Kʋtɔ mʋ nɩɩ n nyi mʋ ɩ gyɛ fɛɛ, n kyɩna n gyɛ gyaatanapʋ, amaa nbɩɩnbɩɩ n kɩɩ.” ");
INSERT INTO naw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nɩɩ Gyiwu abɩlɩsa mʋ ba bɩla taasɛ mʋ yɛ, “Mɩnɛ nɩɩ ɔ waa fʋ? Nɛnɛ nɩɩ ɔ waa kyɛ fu ansi?” ");
INSERT INTO naw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nɩɩ ɔnyɩn mʋ lɛɛ bamʋ kɔnɔ yɛ, “N wʋla tɔwɛ fanɛ kanan mʋ nɩɩ ɩ ba, nɩɩ fan kina kunu. Mɩnɛ ɩ waa sʋ nɩɩ fen biti fan bwii nu kɩnyɔsapʋ? Abɛɛ fanɛ gbaa fanɛ fen biti fɛɛ fan biliŋi mʋ abɩɩlapʋ nɩn?” ");
INSERT INTO naw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nɩɩ ba saalɛ mʋ, tɔwɛ mʋ yɛ, “Fʋ ɩ gyɛ mu obuupu, amaa anɛɛnɛ bɩrɛ an gyɛ Mosesi abuupu nɩn. ");
INSERT INTO naw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","An nyi ɩmʋ nɩɩ Ɩbwaarɛ maa kyɩna tɔwɛ Mosesi asɛ, amaa kanɩn Yesu maŋa bɩrɛ, a man nyi mʋ ɔlɩɩkpa!” ");
INSERT INTO naw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nɩɩ ɔnyɩn mʋ lɛɛ bamʋ kɔnɔ yɛ, “Mɩnɛ alɩmankarɛ nɩɩ fɛn tɔwɛ kanɩn! Fan yɛ fan man nyi katɩn mʋ nɩɩ ɔ lɩɩ, amaa mʋ i bugi mi ansi falɛ. ");
INSERT INTO naw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","An nyi yɛ Ɩbwaarɛ mee nu alibi awaapʋ asɛ. Amaa asa mʋ nɩɩ bee sun Ɩbwaarɛ nɩɩ bɛɛ waa mʋ kɔkɔlɔ biti mʋ, bamʋ asɛ nɩɩ ee nu. ");
INSERT INTO naw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lɩɩ koo saŋa mʋ nɩɩ dulinyaa piili mʋ, a man pɩɩta nu fɛɛ ɔsa kʋ bugi nyɩmɩsa mʋ nɩɩ ba kʋʋgɛ mʋ gyaatanapʋ ansi. ");
INSERT INTO naw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nɩɩ ɔnyɩn nɩmʋ man dɩn lɩɩ Ɩbwaarɛ asɛ mʋ, naafɔɔ ɔ man dɩn taalɛ waa ɩnɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Kɩɩ, fʋ mʋ nɩɩ ba kʋʋgɛ fʋ alibi tɔ, nɛnɛ nɩɩ fʋ ii biti fʋ ba kaapʋ anɛ asɩn?” Tʋtɔ nɩɩ ba gya mʋ lɛɛ ɔgyaŋɛkpa obu mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu maa nu yɛ Gyiwu abɩlɩsa mʋ ba gya ɔnyɩn mʋ lɛɛ ɔgyaŋɛkpa obu mʋ tɔ kanɩn mʋ, ɔ naa wu mʋ, nɩɩ ɔ taasɛ mʋ yɛ, “Fɩɩ kɔɔlɛ Daadimaadi Obii‐nyɩnsa mʋ fii gyii.” ");
INSERT INTO naw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nɩɩ ɔnyɩn mʋ lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, mʋ ɩ gyɛ anɩmʋ? Tɔwɛ mɛ kɛ n kɔɔlɛ mʋ gyii.” ");
INSERT INTO naw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Fʋ tɛɛ wʋla wu mʋ, mʋ ɩ gyɛ ɔmʋ nɩɩ ɛɛ tɔwɛ fʋ asɛ nbɩɩnbɩɩ falɛ.” ");
INSERT INTO naw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tʋtɔ nɩɩ ɔnyɩn mʋ tɔwɛ yɛ, “Mɛ‐nyɩrɩpɛ, n kɔɔlɛ fu gyii.” Nɩɩ ɔ kyʋn muŋa Yesu ayaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nɩɩ Yesu tɔwɛ yɛ, “N ba dulinyaa nɩmʋ tɔ kɛ n ba gyii asa asɩn, kɛ agyaatanapʋ ansi i bugi, kɛ bamʋ nɩɩ bɛɛ kɩɩ mʋ, mɔɔ ba biliŋi agyaatanapʋ.” ");
INSERT INTO naw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farasii abi mʋ nɩɩ ba bʋ tʋtɔ, nɩɩ ba nu kʋtɔ mʋ nɩɩ ɔ tɔwɛ mʋ, ba taasɛ mʋ yɛ, “Fɩɩ kaapʋ fɛɛ anɛ gbaa anɛ an gyɛ agyaatanapʋ nɩn abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nɩɩ Yesu lɛɛ bamʋ kɔnɔ yɛ, “Fan kan fan gyɛ agyaatanapʋ bɩrɛ, naafɔɔ fan mɛɛ yɛ fan gyii alibi kʋpwɛ. Amaa fan maa tɔwɛ yɛ fan kɩɩ falɛ bɩrɛ, fan gyii alibi kʋpwɛ.” ");
INSERT INTO naw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin fɛɛ, ɔsa mʋ nɩɩ ɔ mɛɛ bɔla nbʋlʋpʋ kubunlun kebunɔ mʋ tɔ ee loo, nɩɩ ɔ naa bɔla opula pʋpwɛ loo to mʋ, gyɛ oyu yɛ ɔmʋ nɩɩ ee yuuri ɔlʋn sʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amaa ɔsa mʋ nɩɩ ɛɛ bɔla kebunɔ ee loo mʋ, mʋ ɩ gyɛ nbʋlʋpʋ mʋ ɔkpapʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nɩɩ ɔkpapʋ mʋ kan ba mʋ, kebunɔ ɔkɩɩsʋpʋ mʋ ii tigi sa mʋ, nɩɩ ee loo to. Ɛɛ tɩɩ mʋ nbʋlʋpʋ mʋ ɔkʋmaa nɩmʋ maa mʋ kɩtɩɩ, nɩɩ nbʋlʋpʋ mʋ be nyi mʋ ɔbʋlɛ, nɩɩ ɛɛ lɩɩ gyankpaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ɔkpapʋ mʋ maa tɛɛ lɛɛ bamʋ kpini lɩɩ kubunlun mʋ tɔ mʋ, nɩɩ ɛɛ kyʋn gyankpaa bamʋ yɛgɛ bee buu mʋ, lɩɩ fɛɛ be nyi mʋ ɔbʋlɛ. ");
INSERT INTO naw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Amaa ba mɛɛ yɛ ba buu ɔfɔ, bee biti ba sɩlɛ yɛgɛ mʋ, lɩɩ fɛɛ ba man nyi mʋ ɔbʋlɛ.” ");
INSERT INTO naw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu bɔ bamʋ kɩŋasan kɩnɩmʋ nɩn, amaa ba man nu kʋtɔ mʋ nɩɩ ɛɛ tɔwɛ bamʋ mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ɩmʋ sʋ Yesu bwii tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin fɛɛ mɛ ɩ gyɛ nbʋlʋpʋ kubunlun kebunɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bamʋ nɩɩ ba gyankpaa mɛ ba mʋ kpini, nɩɩ ba waa bamʋ n‐yɩɩ fɛɛ nbʋlʋpʋ akpapʋ mʋ, ba gyɛ ayu yɛ bamʋ nɩɩ bee yuuri ɔlʋn sʋ, kanɩn sʋ nɩɩ nbʋlʋpʋ mʋ ba man nu bamʋ asɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɛ ɩ gyɛ kebunɔ mʋ, ɔkʋmaa mʋ nɩɩ ɔ bɔla mɛ sʋ loo mʋ, ii biti ɔ nyɛ kamɔlɩgɛ. Mʋ kɩlɩɩ kpee yɛ mʋ kibwii ba mʋ ɛɛ nyɛ agyitɔ o gyii. ");
INSERT INTO naw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Oyu bɩrɛ, mʋ lɛɛ ɩ gyɛ fɛɛ o be yuuri, kɛ ɔ mɔɔ, kɛ o nyita. Amaa mɛɛ mɛ n ba nɩn kɛ asa ba nyɛ nkpa, kɛ ba nyɛ ɩmʋ kʋkyɔ‐kʋkyɔ. ");
INSERT INTO naw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mɛ ɩ gyɛ nbʋlʋpʋ ɔkpapʋ danbɩrasa mʋ. Mɛ, nbʋlʋpʋ ɔkpapʋ danbɩrasa mʋ n taa mɛ nkpa sa nbʋlʋpʋ mʋ halɩɩ lewu tɔ. ");
INSERT INTO naw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Paa ogyipu bɩrɛ, ɔ man du fɛɛ nbʋlʋpʋ ɔkpapʋ danbɩrasa mʋ. Nbʋlʋpʋ mʋ ba maa man gyɛ mʋ gbaa‐gbaa mʋ lɛɛ sʋ mʋ, nɩɩ ɔ kan wu fɛɛ kuntun ɩɩ ba mʋ, ɛɛ sɩlɛ yɛgɛ nbʋlʋpʋ mʋ nɩn, kɛ kuntun mʋ ɔ ba kɩtaa bamʋ ɔkʋ kɛ ɔ yaasɛ asansa. ");
INSERT INTO naw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kʋtɔ mʋ sʋ nɩɩ ɛɛ sɩlɛ ɛɛ yɛgɛ nbʋlʋpʋ mʋ ɩ gyɛ fɛɛ, ɔ gyɛ paa ogyipu nɩn, bamʋ asɩn ɩ man tiri mʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Mɛ ɩ gyɛ nbʋlʋpʋ ɔkpapʋ danbɩrasa mʋ. N nyi mɛ nbʋlʋpʋ, nɩɩ mɛ nbʋlʋpʋ gbaa be nyi mɛ. ");
INSERT INTO naw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Fɛɛ kanan mʋ nɩɩ Mɛ‐Sɛ mu nyi mɛ, nɩɩ ngbaa mɛ n nyi Mɛ‐Sɛ mʋ, ɩmʋ sʋ nɩɩ n biti n taa mɛ nkpa sa mɛ nbʋlʋpʋ mʋ halɩɩ lewu tɔ. ");
INSERT INTO naw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","N san n sʋ nbʋlʋpʋ akʋ nɩɩ mʋ ba man bʋ nbʋlʋpʋ anɩmʋ tɔ. Nɩɩ ii tiri fɛɛ n naa taa bamʋ gbaa ba. Bee biti ba be nu mɛ ɔbʋlɛ, kɛ bamʋ kpini ba ba waa kʋbʋ kʋlʋn yɛ ɔkpapʋ kʋlʋn. ");
INSERT INTO naw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kʋtɔ mʋ sʋ nɩɩ Mɛ‐Sɛ ii biti mɛ asɩn ɩ gyɛ fɛɛ, n kyula yɛ n taa mɛ nkpa sa halɩɩ lewu tɔ, kɛ n bɩla bwii nyɛ kɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ɔkʋ mɛɛ taalɛ kɔɔlɛ mɛ nkpa lɩɩ mɛ abaa tɔ. Amaa mɛ gbaa‐gbaa mi kebiti tɔ nɩɩ n kyula yɛ n wu. N sʋ ɔkpa fɛɛ n taa mɛ nkpa sa halɩɩ lewu tɔ, kɛ n bɩla bwii nyɛ kɩmʋ. Falɛ kɔnɔsa kanɩmʋ nɩɩ Mɛ‐Sɛ sa mɛ yɛ n waa.” ");
INSERT INTO naw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Asɩn mʋ nɩɩ Yesu tɔwɛ falɛ sʋ mʋ, nbarɩgɛ ɩ bɩla bwii ba Gyiwu abɩlɩsa mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Asa mʋ tɔ gaalaagaa bɛɛ tɔwɛ yɛ, “Nbwɩɩ libi ba bʋ mʋ tɔ, ɛɛ lɔ ɩbʋn. Mɩnɛ sʋ nɩɩ fen nu mʋ asɛ?” ");
INSERT INTO naw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Amaa bamʋ akʋ mɔɔ ba yɛ, “Ɔsa mʋ nɩɩ nbwɩɩ libi ba bʋ mʋ tɔ mʋ, mɛɛ tɔwɛ falɛ ntɔwɛ nɩmʋ. Nɛnɛ nɩɩ nbwɩɩ libi ɩ taalɛ bugi gyaatanapʋ ansi?” ");
INSERT INTO naw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nɩɩ saŋa fʋʋ fɛɛ Gyiwu abi ba gyii Kesu kɔnɔ mʋ nɩɩ ba sʋ nyiŋi saŋa mʋ nɩɩ ba bugi Kabwaarɛ‐sunkpa ayɛ Gyerusalem kadɛ tɔ mʋ. Saŋa maŋa ɩ gyɛ awɔɔ tɔ nɩn, ");
INSERT INTO naw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","nɩɩ Yesu bʋ Kabwaarɛ‐sunkpa ayɛ mʋ tɔ, yɛgɛ ɔ naa katɩn mʋ nɩɩ bɛɛ tɩɩ yɛ Owura Solomon kasɔrɔga mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tʋtɔ nɩɩ Gyiwu abɩlɩsa mʋ ba yɩlɛ kyaabɔɔ mʋ, nɩɩ ba taasɛ mʋ yɛ, “Saŋa mɔɔ nɩɩ fii biti fɛɛ a gyoo naa fʋʋ, pɔyɩ kɛ a wu asɩn mʋ tɔ kyɛɛkyɛɛ? Nɩɩ fʋ ɩ kan fʋ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ, dan tiisi tɔwɛ anɛ kesintin.” ");
INSERT INTO naw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “N wʋla tɔwɛ fanɛ, amaa fan man kɔɔlɛ mɛ gyii. Asɩn kyinkyinsa mʋ nɩɩ n sʋ n waa Mɛ‐Sɛ kɩtɩɩ tɔ mʋ, ɩmʋ ii gyii mɛ n‐yɩɩ sʋ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amaa fan man kɔɔlɛ mɛ gyii, lɩɩ fɛɛ fan maa man gyɛ mɛ nbʋlʋpʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mɛ nbʋlʋpʋ bee nyi mɛ ɔbʋlɛ, nɩɩ n nyi bamʋ, nɩɩ bee buu mɛ. ");
INSERT INTO naw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","N sa bamʋ nkpa kakpaa, nɩɩ ba mɛɛ yɛ ba fɔyɩ. Nɩɩ ɔkʋ mɛɛ taalɛ bɩɩtɛ bamʋ kɔɔlɛ lɩɩ mɛ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mɛ‐Sɛ Ɩbwaarɛ, mʋ nɩɩ ɔ taa bamʋ sa mɛ mʋ, kyɔ kʋtɔ kʋmaa nɩmʋ, ɩmʋ sʋ ɔkʋ mɛɛ taalɛ bɩɩtɛ bamʋ kɔɔlɛ lɩɩ Mɛ‐Sɛ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","N maa Mɛ‐Sɛ an gyɛ kʋkʋlʋn nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tʋtɔ nɩɩ Gyiwu abi ba bɩla naa taa abuu kɛ ba tʋʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Amaa nɩɩ Yesu tɔwɛ bamʋ yɛ, “N waa asɩn kyinkyinsa damantɛ mʋ nɩɩ ɩ lɩɩ Mɛ‐Sɛ asɛ kaapʋ fanɛ. Ɩmʋ ɩmɔɔ sʋ nɩɩ fen biti fan tʋʋ mɛ abuu?” ");
INSERT INTO naw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nɩɩ Gyiwu abi mʋ ba tɔwɛ mʋ yɛ, “Man gyɛ asɩn kyinkyinsa damantɛ mʋ nɩɩ fʋ waa sʋ nɩɩ an biti a tʋʋ fʋ abuu. Amaa fʋ tɔwɛ nbusaa asɩn yii Ɩbwaarɛ, lɩɩ fɛɛ fʋ gyɛ nyɩmɩsa nɩn, nɩɩ fɩɩ tɔwɛ yɛ fʋ gyɛ Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nɩɩ Yesu taasɛ bamʋ yɛ, “Fan man nyi ba maa kyʋrɔɔ waa fanɛ Nbara mʋ tɔ yɛ, Ɩbwaarɛ yɛ, ‘Fan gyɛ mɛ, Ɩbwaarɛ mɛ kedubi’? ");
INSERT INTO naw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","An nyi fɛɛ ɔkʋ mɛɛ taalɛ kyɛɛgɛ Asɩnkyan yɩlasa mʋ. Ɩbwaarɛ wʋla tɔwɛ bamʋ nɩɩ mʋ asɩn ɩ ba bamʋ asɛ mʋ yɛ ba gyɛ mu keduli mʋ, mɛɛ mɛ bɩrɛ Mɛ‐Sɛ Ɩbwaarɛ ɩ lɛɛ mɛ nɩɩ o sun mɛ ba dulinyaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mɩnɛ sʋ nɩɩ fɛn yɛ n tɔwɛ nbusaa asɩn yii Ɩbwaarɛ, fɛɛ maa tɔwɛ yɛ, ‘N gyɛ Ɩbwaarɛ Mu‐Bii mʋ’? ");
INSERT INTO naw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nɩɩ n mɛɛ kan n waa atɔ mʋ nɩɩ Mɛ‐Sɛ ii biti fɛɛ n waa mʋ, kanɩn bɩrɛ fan man kɔɔlɛ mɛ gyii. ");
INSERT INTO naw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amaa nɩɩ n kan waa ɩmʋ bɩrɛ, nɩɩ halɩɩ fan man kɔɔlɛ mɛ gyii gbaa mʋ, fan kɔɔlɛ atɔ mʋ nɩɩ n waa mʋ kpini gyii, kɛ fan nyɛ bɩɩ fɛɛ n maa Mɛ‐Sɛ an gyɛ kʋkʋlʋn.” ");
INSERT INTO naw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tʋtɔ nɩɩ asa mʋ ba biti fɛɛ ba kɩtaa mʋ, amaa ɔ bʋlɛ bamʋ tɔ lɩɩ kyʋn. ");
INSERT INTO naw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nɩɩ Yesu bwii naa faa Gyɔdan ɔbʋn kpee kɩmʋ benben, opula mʋ nɩɩ Gyɔn kyɩna gyee asa Ɩbwaarɛ kekyugyee mʋ. Ɔ maa bʋ tʋtɔ mʋ, ");
INSERT INTO naw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","nɩɩ asa damantɛ ba ba mʋ asɛ, nɩɩ bɛɛ tɔwɛ yɛ, “Halɩɩ Gyɔn maa man waa asɩn kyinkyinsa ɩkʋ gbaa mʋ, kʋtɔ kʋmaa mʋ nɩɩ ɔ tɔwɛ lɩɩ ɔnyɩn nɩmʋ sʋ mʋ, kpini gyɛ kesintin.” ");
INSERT INTO naw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nɩɩ asa mʋ nɩɩ ba bʋ tʋtɔ mʋ gaalaagaa ba kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ɔnyɩn kʋ ɩ kyɩna ɔ bʋ tɔ, nɩɩ bɛɛ tɩɩ mʋ yɛ Lasarusi, nɩɩ ɔ dɛ ɛɛ lɔɔ. Mʋ pɩɩkyɩɩ ana ɩ gyɛ Mɛɛrɩ yɛ Mata, nɩɩ bamʋ kpini ba lɩɩ Betani kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mɛɛrɩ nɩmʋ ɩ gyɛ ɔkyɩɩ ɔmʋ nɩɩ ɔ kyɩna ɔ ba kyɛɛgɛ tulale wʋrɩgɛ Yesu ayaa sʋ, nɩɩ ɔ taa mʋ inyini bʋnswɩɩsa mʋ kpayɩ‐kpayɩ ɩmʋ mʋ. Mʋ pɩɩnyɩn ɩ gyɛ Lasarusi mʋ nɩɩ ɔ dɛ ɛɛ lɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nɩɩ mʋ pɩɩkyɩɩ ana ba sun Yesu asɛ naa tɔwɛ mʋ yɛ, “Ɔnyɩrɩpɛ, fʋ kyɛmɩnɛ danbɩrasa mʋ nɩɩ fʋ sʋ kebiti sa mʋ mʋ, dɛ ɛɛ lɔ.” ");
INSERT INTO naw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu maa nu ɩnɩmʋ mʋ, nɩɩ ɔ tɔwɛ yɛ, “Kʋlɔ kɩnɩmʋ man gyɛ lewu kʋlɔ. Ii biti ɩ bɩya Ɩbwaarɛ bʋnyaa nɩn, kɛ mɛ, Mu‐Bii mʋ n nyɛ bʋnyaa lɩɩ ɩmʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu sʋ kebiti sa Mata maa Mɛɛrɩ yɛ bamʋ pɩɩnyɩn Lasarusi. ");
INSERT INTO naw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Amaa maa nu fɛɛ Lasarusi ɩɩ lɔ mʋ, o bwii kyɩna katɩn mʋ nɩɩ ɔ bʋ mʋ nkɛ nnyɔ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ɩmʋ kamaa mʋ ɔ tɔwɛ mʋ abɩɩlapʋ yɛ, “Fan yɛgɛ a bwii kpee Gyudeya ɔsʋwʋlɛ.” ");
INSERT INTO naw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nɩɩ abɩɩlapʋ mʋ ba tɔwɛ mʋ yɛ. “Ɔkaapʋpʋ, nkɛ nnyɔ nɩmʋ tɔ nɩɩ Gyiwu abi bee biti ba tʋʋ fʋ abuu mɔɔ, mɩnɛ sʋ nɩɩ fɩɩ bɩla fii kpee tʋtɔ?” ");
INSERT INTO naw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Man gyɛ kerefi kudu anyɔ ɩ bʋ kayɩkɛ tɔ? Nyɩmɩsa mʋ nɩɩ ɔ naa kayɩkɛ tɔ mʋ mee siti, lɩɩ fɛɛ kyɔwɛ kɩɩ tɔ ɛɛ sa mʋ katɩn kʋmaa. ");
INSERT INTO naw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amaa nɩɩ ɔ natɛ kagyanbwɛ bɩrɛ ee siti, lɩɩ fɛɛ ɔ man sʋ ɩŋmaŋɛsa.” ");
INSERT INTO naw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Maa tɔwɛ ɩnɩmʋ kamaa mʋ, ɔ tɔwɛ bamʋ yɛ, “Anɛ kyɛmɩnɛ Lasarusi dɛ nsɩɩrɛ nɩn, amaa n biti n kpee tʋtɔ n naa kyiŋi mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nɩɩ mʋ abɩɩlapʋ ba lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, nɩɩ ɔ kan dɛ nsɩɩrɛ bɩrɛ, ee biti ɔ nyɛ alanfɩya.” ");
INSERT INTO naw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kʋtɔ mʋ nɩɩ Yesu ɩɩ kaapʋ ɩ gyɛ yɛ Lasarusi wu, amaa mʋ abɩɩlapʋ bɩrɛ be nyi nɩn fɛɛ nsɩɩrɛ gbaa‐gbaa asɩn nɩɩ ɔ dɩyɛ. ");
INSERT INTO naw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ɩmʋ sʋ ɔ tɔwɛ tigi bamʋ yɛ, “Lasarusi wu. ");
INSERT INTO naw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Amaa lɩɩ fanɛ sʋ mʋ, mi ansi i gyii fɛɛ n maa man bʋ tʋtɔ nɩɩ o wu. Ɩnɩmʋ ii biti ɩ yɛgɛ kɛ fan nyɛ kɔɔlɛ mɛ gyii. Kanɩn sʋ fan yɛgɛ a kpee mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nɩɩ Tomasi mʋ nɩɩ bɛɛ tɩɩ mʋ Kabwaara‐bii mʋ, tɔwɛ abɩɩlapʋ asansa mʋ yɛ, “Fan yɛgɛ anɛ gbaa anɛ a kpee kɛ anaa mʋ a naa wu.” ");
INSERT INTO naw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu maa fʋʋ Betani kadɛ tɔ mʋ, o nu yɛ ba tee pula Lasarusi ɩmʋ nkɛ nna. ");
INSERT INTO naw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lɩɩ Betani kpee Gyerusalem man bʋ kata, ɩ waa fɛɛ ɩmaalɩ ɩnyɔ, ");
INSERT INTO naw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","nɩɩ Gyiwu abi mʋ gaalaagaa ba ba Mata maa Mɛɛrɩ asɛ, ba ba tɔwɛ yuula bamʋ nkɔlɔ lɩɩ bamʋ pɩɩnyɩn kelewu sʋ. ");
INSERT INTO naw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata maa nu fɛɛ Yesu ɩɩ ba mʋ, ɔ lɩɩ naa gyaŋa mʋ ɔkpa tɔ, amaa Mɛɛrɩ bɩrɛ o sii kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata maa gyaŋa mʋ mʋ, ɔ tɔwɛ mʋ yɛ, “Ɔnyɩrɩpɛ, fʋ daa fʋ bʋ nfɩɩ nɩn, naafɔɔ mɛ pɩɩnyɩn man dɩn wu. ");
INSERT INTO naw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amaa halɩɩ nbɩɩnbɩɩ gbaa n nyi yɛ, kʋtɔ kʋmaa mʋ nɩɩ fʋ taasɛ Ɩbwaarɛ mʋ, ee biti ɔ waa sa fʋ.” ");
INSERT INTO naw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Fʋ pɩɩnyɩn ii biti o bwii kyiŋi ba nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata lɛɛ kɔnɔ yɛ, “N nyi yɛ ee biti o kyiŋi ba nkpa tɔ kakɛ laalaalʋwɛ mʋ, saŋa mʋ nɩɩ Ɩbwaarɛ ii biti o kyiŋi asa ba nkpa tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Mɛ ɩ gyɛ ɔmʋ nɩɩ n kyiŋi asa n lɩɩ lewu tɔ, nɩɩ ɛɛ sa bamʋ nkpa mʋ. Ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, halɩɩ o wu gbaa ee biti ɔ nyɛ nkpa. ");
INSERT INTO naw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ tɛ nkpa tɔ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, ɔ mɛɛ yɛ o wu kakɛ akʋ. Fʋ kɔɔlɛ ɩnɩmʋ gyii?” ");
INSERT INTO naw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nɩɩ Mata kyula yɛ, “Ɛɛhn! Ɔnyɩrɩpɛ n kɔɔlɛ gyii yɛ fʋ ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ, Ɩbwaarɛ Mu‐Bii mʋ nɩɩ ɔ tɔwɛ yɛ ee biti o sun mʋ ba dulinyaa tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ, o bwii kpee kɩkpaara sʋ, nɩɩ ɔ naa tɩɩ mu‐supu Mɛɛrɩ lɩɩ ɩkaa sʋ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Ɔkaapʋpʋ mʋ bʋ nfɩɩ, nɩɩ ɔ taasɛ fʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɛɛrɩ maa nu kanɩn mʋ, nɩɩ ɔ kʋsʋ bilen ee kpee mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu man pɩɩta loo kadɛ mʋ tɔ, amaa ɔ san ɔ bʋ katɩn mʋ nɩɩ Mata naa gyaŋa mʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Gyiwu abi mʋ nɩɩ ba bʋ Mɛɛrɩ asɛ kɩkpaara sʋ bɛɛ tɔwɛ bee yuula mʋ kɔkɔlɔ mʋ, ba maa wu kanan mʋ nɩɩ ɔ kʋsʋ bilen lɩɩ kewu mʋ, ba lɩɩ buu mʋ, be nyi fɛɛ ee kpee kakyan mʋ asɛ ɔ naa kyɩna saawʋ. ");
INSERT INTO naw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɛɛrɩ maa fʋʋ katɩn mʋ nɩɩ Yesu bʋ, nɩɩ o wu mʋ mʋ, o muŋa mʋ ayaa tɔ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Ɔnyɩrɩpɛ fʋ daa fʋ bʋ nfɩɩ nɩn, naafɔɔ mɛ pɩɩnyɩn man dɩn wu.” ");
INSERT INTO naw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu maa wu kanan mʋ nɩɩ Mɛɛrɩ yɛ Gyiwu abi mʋ nɩɩ ba buu mʋ mʋ bee su mʋ, ɩ kɔ mʋ nɩɩ i duŋi mʋ ɔbʋlɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nɩɩ ɔ taasɛ bamʋ yɛ, “Fɩnɛ nɩɩ fan pula mʋ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, ba kɩɩ.” ");
INSERT INTO naw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nɩɩ Yesu su. ");
INSERT INTO naw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nɩɩ Gyiwu abi mʋ ba tɔwɛ yɛ, “Fan kɩɩ kanan mʋ nɩɩ ɔ sʋ kebiti sa mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amaa bamʋ tɔ akʋ ba tɔwɛ yɛ, “Man gyɛ Yesu nɩmʋ i bugi agyaatanapʋ ansi mʋ? Mɩnɛ ɩ waa nɩɩ ɔ man taalɛ kɔɔlɛ Lasarusi kɛ ɔ man wu?” ");
INSERT INTO naw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu ɔbʋlɛ tɔ bwii duŋi mʋ, nɩɩ o kpee kakyan mʋ asɛ. Kɩ gyɛ kɩfʋlɛbɔ nɩn, nɩɩ ba taa kubuu tii kɩmʋ kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan tigi kubuu mʋ lɩɩ tʋtɔ.” Nɩɩ Mata, olewupu mʋ pɩɩkyɩɩ mʋ tɔwɛ yɛ “Ɔnyɩrɩpɛ, ee biti ɔ ba ɛɛ lɩɩsɔn, ndaga nkɛ nna nɩmʋ a maa pula mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nɩɩ Yesu taasɛ Mata yɛ, “N man tɔwɛ fʋ yɛ nɩɩ fʋ kan kɔɔlɛ gyii mʋ, fii biti fu wu Ɩbwaarɛ bʋnyaa?” ");
INSERT INTO naw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɩmʋ sʋ ba tigi kubuu mʋ. Nɩɩ Yesu kɩɩ sʋsʋ nɩɩ ɔ tɔwɛ yɛ, “Nsɛ, n fwaala fʋ fɛɛ fʋ maa nu mɛ kɩkʋlɛ. ");
INSERT INTO naw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N nyi saŋa kʋmaa fii nu mɛ kɩkʋlɛ, amaa asa mʋ nɩɩ ba yɩlɛ nfɩɩ mʋ sʋ nɩɩ n tɔwɛ kanɩn, kɛ ba nyɛ kɔɔlɛ gyii fɛɛ fu i sun mɛ.” ");
INSERT INTO naw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Maa tɔwɛ kanɩn lʋwɛ mʋ, nɩɩ o kuusi kenken yɛ, “Lasarusi, lɩɩ ba!” ");
INSERT INTO naw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nɩɩ olewupu mʋ lɩɩ ba, yɛgɛ taafuli mili mʋ abaa yɛ ayaa sʋ, yɛgɛ kikyibi fufuli ŋmina mu ansi sʋ. Tʋtɔ nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan saŋɛ mʋ kɛ ɔ natɛ.” ");
INSERT INTO naw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Gyiwu abi adamantɛ mʋ nɩɩ ba ba Mɛɛrɩ afwaala, nɩɩ ba wu kʋtɔ mʋ nɩɩ Yesu waa mʋ, ba kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amaa bamʋ akʋ ba kpee Farasii abi asɛ naa tɔwɛ kʋtɔ mʋ nɩɩ Yesu waa. ");
INSERT INTO naw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ɩmʋ sʋ aseepu bɩlɩsa yɛ Farasii abi ba tɩɩ kadɛ mʋ tɔ Gyiwu abɩlɩsa amu‐amu ngyaŋɛ. Nɩɩ ba taasɛ abaa yɛ, “Mɩnɛ nɩɩ an biti a waa. Fan kɩɩ asɩnkaala yɛ asɩn kyinkyinsa damantɛ mʋ nɩɩ ɔnyɩn nɩmʋ ɩɩ waa falɛ.” ");
INSERT INTO naw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","An kan yɛgɛ mʋ, nɩɩ ɔ kyaga sʋ ɛɛ waa kanɩn mʋ, ɔsa kʋmaa nɩmʋ ii biti ɔ kɔɔlɛ mʋ gyii, kɛ ɩ yɛgɛ Roma abi ba ba nyita anɛ kabwaarɛ‐sunkpa ayɛ nɩmʋ kɛ ba mɔɔ anɛ asa. ");
INSERT INTO naw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nɩɩ bamʋ tɔ ɔkʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Kayifasi nɩɩ ɔ kyɩna ɔ gyɛ oseepu bɩlɩsa asɛ kesu maŋa tɔ mʋ tɔwɛ bamʋ yɛ, “Fan man nyi sɛhn! ");
INSERT INTO naw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Fan man nyi yɛ, ɩ bɔ sa fanɛ fɛɛ nyɩmɩsa kʋlʋn o wu sa asa kpini, ɩ kyɔ fɛɛ anɛ asa kpini ba maa muuri?” ");
INSERT INTO naw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kesintin tɔ man gyɛ mʋ gbaa‐gbaa mu kebiti tɔ nɩɩ ɔ tɔwɛ falɛ asɩn nɩmʋ. Amaa maa gyɛ Ɩbwaarɛ oseepu bɩlɩsa asɛ kanɩn kesu maŋa tɔ sʋ mʋ, Ɩbwaarɛ yɛgɛ nɩɩ ɔ tɔwɛ yɩla yɛ Yesu ii biti o wu sa Gyiwu abi kpini. ");
INSERT INTO naw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nɩɩ man gyɛ Gyiwu abi nkʋn, amaa yɛ Ɩbwaarɛ mu‐bii ana mʋ nɩɩ ba yaasɛ tɔ ba bʋ dulinyaa tɔ katɩn kʋmaa nɩmʋ mʋ, kɛ ba ba bʋga waa kʋkʋlʋn. ");
INSERT INTO naw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ɩmʋ sʋ lɩɩ kanɩn kakɛ maŋa Gyiwu abɩlɩsa ba ŋmina yɛ ba mɔɔ Yesu. ");
INSERT INTO naw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lɩɩ kanɩn sʋ Yesu man bɩla lɛɛ mʋ n‐yɩɩ ifuli ɛɛ natɛ Gyiwu abi mʋ tɔ. Amaa ɔ lɩɩ Gyerusalem kpee bɛɛ tɩɩ kɩmʋ yɛ Efarim kadɛ mʋ, nɩɩ kɩ bʋ tiri kiperi sʋ mʋ. Nɩɩ maa mʋ abɩɩlapʋ mʋ ba naa kyɩna tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Gyiwu abi Kesu kɔnɔ Kanyaŋɛ nbunɔ kensi‐gyii saŋa maa tiri tɔ mʋ, asa gaalaagaa ba lɩɩ bamʋ ndɛ sʋ kpee Gyerusalem. Ba gyankpaa nɩn ba naa fwɩɩ bamʋ n‐yɩɩ sʋ ineesi fɛɛ kanan mʋ nɩɩ ba wʋla bɛɛ waa, pɔyɩ kɛ bamʋ Kanyaŋɛ nbunɔ kakɛ mʋ kɩ fʋʋ. ");
INSERT INTO naw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Asa mʋ bɛɛ kɩɩ bee biti Yesu. Nɩɩ saŋa mʋ nɩɩ ba yɩlɛ kabwaarɛ‐sunkpa ayɛ asɛ mʋ, bɛɛ taasɛ abaa yɛ, “Mɩnɛ ɩ gyɛ fanɛ nfɛɛrɛ? Fen nyi fɛɛ ee biti ɔ ba Kanyaŋɛ nbunɔ ngyaŋɛ nɩmʋ tɔ?” ");
INSERT INTO naw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ɩmʋ gbaa mʋ Ɩbwaarɛ aseepu yɛ Farasii abi mʋ ba wʋla sa kɔnɔ yɛ, ɔkʋmaa mʋ nɩɩ o wu katɩn mʋ nɩɩ Yesu bʋ mʋ, ɔ ba tɔwɛ bamʋ kɛ ba nyɛ kɩtaa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ɩ maa san fɛɛ nkɛ nsiye kɛ ba gyii Kesu kɔnɔ Kanyaŋɛ nbunɔ lala mʋ, Yesu kpee Betani kadɛ tɔ. Tʋtɔ ɩ gyɛ Lasarusi mʋ nɩɩ Yesu daa kyiŋi lɩɩ lewu tɔ mʋ ayɛ. ");
INSERT INTO naw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nɩɩ ba waa agyitɔ kɩtaa Yesu kɩfɔ. Mata ɩ waa agyitɔ maŋa, Lasarusi gbaa tii asa mʋ nɩɩ ba maa Yesu bee gyii mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tʋtɔ nɩɩ Mɛɛrɩ taa tuulaale liifensa mʋ nɩɩ ɩ sʋ ɔgyalɩn pʋrʋntʋwa bɔla ba, nɩɩ nadi nɩɩ ba taa waa ɩmʋ. Mɛɛrɩ taa ba kyɛɛgɛ wʋrɩgɛ Yesu ayaa sʋ, nɩɩ ɔ taa mʋ inyini bʋnswɩɩsa kpayɩ‐kpayɩ ɩmʋ. Nɩɩ tuulaale maŋa ofen kɔɔlɛ kɩkpaara mʋ sʋ kpini femm. ");
INSERT INTO naw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Amaa mʋ abɩɩlapʋ mʋ tɔ ɔkʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gyudasi Isikariyoti bʋ tʋtɔ. Mʋ ɩɩ ba ɔ ba lɛɛ Yesu sa mʋ. Maa wu Mɛɛrɩ maa waa kanɩn mʋ, ɔ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mɩnɛ sʋ nɩɩ ba man taa tuulaale nɩmʋ fɛ, kɛ ba nyɛ afulee fɛɛ dinari asa, abɛɛ ɩbwaayɩ kudu kusun osunpu kʋkɔka, kɛ ba taa afulee mʋ kɛɛ atiripu?” ");
INSERT INTO naw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Man gyɛ atiripu mʋ asɩn i tiri mʋ sʋ nɩɩ ɔ tɔwɛ kanɩn, amaa ɔ gyɛ oyu nɩn. Nɩɩ mʋ ɩɩ kɩtaa bamʋ afulee ɔwaakpa mʋ, yɛgɛ ee yuuri afulee mʋ ɩkʋ ee gyii. ");
INSERT INTO naw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Amaa Yesu tɔwɛ yɛ, “Fan yɛgɛ ɔkyɩɩ mʋ! Ɔ waa ɩmʋ yɩla mi kepula akɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Saŋa kʋmaa fanaa atiripu anɩmʋ ii biti fan baa fan bʋ tɔ, amaa mɛɛ yɛ n baa n bʋ fanɛ asɛ saŋa kʋmaa.” ");
INSERT INTO naw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nɩɩ Gyiwu abi adamantɛ ba maa nu fɛɛ Yesu bʋ Betani kadɛ tɔ mʋ, ba kpee mʋ asɛ tʋtɔ. Man gyɛ Yesu nkʋn sʋ nɩɩ ba kpee tʋtɔ, amaa ba kpee ba naa kɩɩ Lasarusi mʋ nɩɩ Yesu kyiŋi mʋ lɩɩ lewu tɔ mʋ gbaa. ");
INSERT INTO naw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ɩmʋ sʋ Ɩbwaarɛ aseepu bɩlɩsa ba ŋmina ba mɔɔ Lasarusi gbaa, ");
INSERT INTO naw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","lɩɩ fɛɛ taa lɩɩ Lasarusi kelewu kyiŋi mʋ sʋ mʋ, Gyiwu abi mʋ gaalaagaa bee kina bamʋ abɩlɩsa mʋ, nɩɩ bee kpee bɛɛ kɔɔlɛ Yesu bee gyii. ");
INSERT INTO naw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ɩmʋ lɩɩkaakɛ mʋ, kʋbʋ damantɛ mʋ nɩɩ ba ba bamʋ Kesu kɔnɔ Kanyaŋɛ nbunɔ kensi‐gyii mʋ tɔ mʋ, ba nu fɛɛ Yesu kɩtaa ɔkpa ɛɛ ba Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɩmʋ sʋ ba taa abɩlafɛ lɩɩ kyʋn, kɛ ba naa gyaŋa mʋ, yɛgɛ bɛɛ yɩn mʋ bɛɛ tɔwɛ yɛ, “Hosana! Kusee ɩ gyɛ sa ɔmʋ nɩɩ ɔ naa Ɔnyɩrɩpɛ Ɩbwaarɛ kɩtɩɩ tɔ ɛɛ ba! Kusee ɩ gyɛ sa Ɩsɩrayɩ Owura!” ");
INSERT INTO naw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nɩɩ Yesu wu kuruma kadanba kʋ nɩɩ o dii mʋ. Ɩnɩmʋ ɩ yɛgɛ nɩɩ Asɩnkyan yɩlasa mʋ ɩ ba tɔ kesintin. Ɩmʋ ɩ gyɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O Siyon abi, fan man waa kufuu, fan kɩɩ, fanɛ owura ɩɩ ba, ɔ tɛ kuruma kadanba sʋ ɛɛ ba.” ");
INSERT INTO naw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kanɩn saŋa maŋa mʋ, mʋ abɩɩlapʋ ba man nu ɩnɩmʋ kpini kasɛ. Amɔɔ kamaa tɔ, saŋa mʋ nɩɩ Ɩbwaarɛ sa mʋ bʋnyaa mʋ, pɔyɩ nɩɩ ba lan nyiŋi fɛɛ ba kyʋrɔɔ asɩn nɩmʋ waa Asɩnkyan yɩlasa mʋ tɔ, nɩɩ ɩ ba tɔ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nɩɩ asa mʋ nɩɩ ba bʋ Yesu asɛ saŋa mʋ nɩɩ ɔ tɩɩ Lasarusi lɩɩ kakyan tɔ, nɩɩ o kyiŋi mʋ lɩɩ lewu tɔ mʋ, ɩɩ kyaga sʋ tɔwɛ asɩn nɩmʋ katɩn kʋmaa. ");
INSERT INTO naw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kanɩn sʋ nɩɩ asa damantɛ ba lɩɩ ba naa gyaŋa Yesu, lɩɩ fɛɛ ba maa nu asɩn kyinkyinsa mʋ nɩɩ ɔ waa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ɩmʋ sʋ Farasii abi ba tɔwɛ abaa yɛ, “Fan man wu, a mɛɛ bɩla taalɛ waa sɛhn. Fan kɩɩ, dulinyaa tɔ asa kpini ba biliŋi kpee ba buu mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nɩɩ Giriki abi mʋ akʋ gbaa ba tii bamʋ nɩɩ ba kpee Gyerusalem mʋ sʋ. Ba naa sun Ɩbwaarɛ Kesu kɔnɔ Kanyaŋɛ nbunɔ kensi‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kanɩn asa maŋa ba ba Filipu mʋ nɩɩ ɔ lɩɩ Betisayida kadɛ mʋ nɩɩ kɩ bʋ Galile ɔsʋwʋlɛ sʋ mʋ asɛ, ba tɔwɛ mʋ yɛ, “Ɔbɩlɩsa, an biti fɛɛ a wu Yesu.” ");
INSERT INTO naw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nɩɩ Filipu naa tɔwɛ Andiruwu, nɩɩ bamʋ anyɔ ba kpee naa tɔwɛ Yesu. ");
INSERT INTO naw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Nbɩɩnbɩɩ, saŋa mʋ fʋʋ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa bʋnyaa lala mʋ ɩ lɛɛ ifuli. ");
INSERT INTO naw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","N tɔwɛ fanɛ kesintin, kuyu kibi, nɩɩ kɩ man kan tɩyɛ ɩsɛ tɔ gyɔɔ mʋ, kɩ san kɩ gyɛ kuyubi kʋlʋn. Amaa nɩɩ kɩ kan tɩyɛ ɩsɛ tɔ gyɔɔ, nɩɩ kɩ kɔyɩ bɩrɛ, kɩɩ sɔyɩ abi damantɛ. ");
INSERT INTO naw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ɔsa kʋmaa mʋ nɩɩ ɔ sʋ kebiti sa mʋ nkpa gaa mʋ, ee biti ɔ pan kɩmʋ. Amaa ɔsa kʋmaa mʋ nɩɩ ɔ mɛɛ taa mʋ nkpa ɛɛ tɩɩ sɛhn dulinyaa nɩmʋ tɔ mʋ, ee biti ɔ lɔŋɔ mʋ n‐yɩɩ yɩla sa nkpa kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɔsa kʋmaa mʋ nɩɩ ee sun mɛ mʋ, dagaa maa buu mɛ. Nɩɩ katɩn mʋ nɩɩ n bʋ mʋ, tʋtɔ nɩɩ mi osunpu mʋ gbaa ii biti ɔ baa ɔ bʋ. Nɩɩ ɔsa mʋ nɩɩ ee sun mɛ mʋ, Mɛ‐Sɛ ii biti ɔ sa mʋ bɛɛrɛɛ.” ");
INSERT INTO naw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nɩɩ Yesu tɔwɛ yɛ, “Nbɩɩnbɩɩ, mɛ kɔkɔlɔ man dɛ mɛ. N bɩɩ kʋlɛ Mɛ‐Sɛ kɛ n tɔwɛ yɛ, Nsɛ, mɔlɩgɛ mɛ lɩɩ awʋrʋfɔ mʋ nɩɩ ii biti ɩɩ ba mɛ sʋ falɛ abɛɛ? Ayee, falɛ awʋrʋfɔ anɩmʋ sʋ nɩɩ n ba. ");
INSERT INTO naw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nsɛ, bʋnyaa fʋ kɩtɩɩ!” Tʋtɔ nɩɩ ɔbʋlɛ kʋ lɩɩ sʋsʋ tɔwɛ yɛ, “N wʋla bʋnyaa kɩmʋ nɩɩ n biti n bwii bʋnyaa kɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sakyɔ mʋ nɩɩ ba bʋ tʋtɔ mʋ ba maa nu ɔbʋlɛ mʋ, ba tɔwɛ yɛ, “Bʋlayɩ pʋntɛ!” Nɩɩ akʋ mɔɔ ba yɛ, “Ɩbwaarɛ kabɔɔ ɩ tɔwɛ mʋ asɛ!” ");
INSERT INTO naw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Ɩ man gyɛ mɛ sʋ nɩɩ ɔbʋlɛ nɩmʋ tɔwɛ, amaa lɩɩ fanɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nbɩɩnbɩɩ ɩ gyɛ saŋa mʋ nɩɩ Ɩbwaarɛ ii biti o gyii dulinyaa nɩmʋ tɔ asa asɩn. Nbɩɩnbɩɩ ɩ gyɛ saŋa mʋ nɩɩ ee biti ɔ kʋsaa dulinyaa nɩmʋ tɔ owura lɩɩ mʋ kagya sʋ. Mʋ ɩ gyɛ Sɩtaanɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Amaa nɩɩ ba kan kʋsaa mɛ sʋsʋ lɩɩ kasɛ sʋ bɩrɛ, n biti n bɩɩtɛ asa kpini ba mɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ɔ tɔwɛ ɩnɩmʋ nɩn kaapʋ tɔ lɩɩ kelewu mʋ nɩɩ ee biti o wu. ");
INSERT INTO naw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nɩɩ sakyɔ mʋ ba lɛɛ kɔnɔ yɛ, “An nu lɩɩ Asɩnkyan yɩlasa mʋ tɔ fɛɛ, Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ, ii biti ɔ kyɩna nkpa tɔ kakpaa. Mɩnɛ sʋ nɩɩ fɩɩ tɔwɛ yɛ, Ɩ dagaa ba maa kʋsaa Daadimaadi Obii‐nyɩnsa mʋ sʋsʋ? Anɩmʋ ɩ gyɛ Daadimaadi Obii‐nyɩnsa mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nɩɩ Yesu tɔwɛ bamʋ lɩɩ mʋ n‐yɩɩ sʋ yɛ, “Ɩŋmaŋɛsa mʋ ɩ man bɩla yɛ ɩ kyɛɛrɛɛ fanɛ asɛ. Ɩmʋ sʋ fan kyaga sʋ natɛ ɩŋmaŋɛsa mʋ tɔ, kɛ kitentenbiri kɩ man nyɛ loo fanɛ tɔ. Lɩɩ fɛɛ ɔsa mʋ nɩɩ ɔ naa kitentenbiri tɔ mʋ man nyi katɩn mʋ nɩɩ ee kpee. ");
INSERT INTO naw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Fan maa san fan sʋ ɩŋmaŋɛsa fanɛ asɛ falɛ bɩrɛ, fan kɔɔlɛ ɩmʋ gyii, kɛ fan baa fan gyɛ ɩŋmaŋɛsa mʋ asa.” Yesu maa tɔwɛ ɩnɩmʋ kamaa tɔ mʋ, ɔ lɩɩ tʋtɔ naa baala bamʋ sʋ mʋ nkʋn. ");
INSERT INTO naw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Halɩɩ asɩn kyinkyinsa mʋ nɩɩ Yesu waa asa ansi tɔ kpini falɛ gbaa mʋ, ba san ba mɛɛ kɔɔlɛ mʋ bee gyii. ");
INSERT INTO naw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Asɩn nɩmʋ a waa nɩn, kɛ asɩn mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Isaya wʋla tɔwɛ mʋ, ɩ ba tɔ kesintin. Falɛ nɩɩ ɔ taasɛ Ɩbwaarɛ yɛ, “Ɔnyɩrɩpɛ, anɩmʋ ɩ kɔɔlɛ asɩn mʋ nɩɩ an tɔwɛ mʋ gyii? Nɩɩ asa mɔɔ nɩɩ Ɔnyɩrɩpɛ mʋ lɛɛ mʋ ɔlʋn mʋ kaapʋ?” ");
INSERT INTO naw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kpalɩ ɩnɩmʋ sʋ mʋ, ba man taalɛ kɔɔlɛ Yesu gyii, lɩɩ fɛɛ Isaya bɩla tɔwɛ mʋ ɔwʋlɛ tɔ katɩn kʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ɩbwaarɛ waa bamʋ agyaatanapʋ, kɛ bamʋ ansi ɩ man wu. Ɔ yɛgɛ nɩɩ ba waa kʋsʋ tɔ ɔlʋn, kɛ bamʋ nfɛɛrɛ tɔ ii mee nu asɩn kasɛ, kɛ ba biliŋi ba mɛ asɛ, kɛ n kyɛ bamʋ.” ");
INSERT INTO naw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya gyankpaa wu Yesu bʋnyaa mʋ, ɩmʋ sʋ nɩɩ ɔ tɔwɛ ɩnɩmʋ lɩɩ mʋ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Halɩɩ ɩ maa ɩmʋ gbaa mʋ, Gyiwu abɩlɩsa mʋ adamantɛ ba kɔɔlɛ Yesu gyii. Amaa lɩɩ Farasii abi mʋ sʋ mʋ, ba man taalɛ lɛɛ bamʋ kɩkɔɔlɛ‐gyii mʋ ifuli, lɩɩ fɛɛ ba sʋ kufuu fɛɛ bee biti ba gya bamʋ lɩɩ ɔgyaŋɛkpa mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kpalɩ fɛɛ abɩlɩsa mʋ bee biti kɩyɩn lɩɩ nyɩmɩsa asɛ ba kyɔ Ɩbwaarɛ asɛ, ɩmʋ sʋ nɩɩ bɛɛ waa kanɩn. ");
INSERT INTO naw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tʋtɔ nɩɩ Yesu tɔwɛ kenken yɛ, “Ɔsa kʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, man gyɛ mɛ nkʋn nɩɩ ɔ kɔɔlɛ gyii, amaa ɔmʋ nɩɩ o sun mɛ mʋ, nɩɩ ɔ kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɔsa kʋmaa mʋ nɩɩ o wu mɛ mʋ, o wu ɔmʋ nɩɩ o sun mɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mɛ ɩ gyɛ ɩŋmaŋɛsa mʋ nɩɩ ɩ ba dulinyaa nɩmʋ mʋ, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ gyii mʋ, ɔ man sii kitentenbiri tɔ. ");
INSERT INTO naw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ɔkʋmaa mʋ nɩɩ o nu mɛ asɩn tɔwɛsa, nɩɩ ɔ man buu ɩmʋ mʋ, man gyɛ mɛ ii biti n bun mʋ kʋpwɛ. Lɩɩ fɛɛ n man ba nɩn yɛ n ba bun dulinyaa tɔ asa kʋpwɛ, amaa n ba nɩn kɛ n ba mɔlɩgɛ kɩmʋ asa. ");
INSERT INTO naw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ɔsa kʋmaa mʋ nɩɩ o kina mɛ, nɩɩ ɔ man kɔɔlɛ mɛ asɩn mʋ, wʋla nyɛ ɔmʋ nɩɩ ee biti o bun mʋ kʋpwɛ. Nɩɩ asɩn mʋ nɩɩ n tɔwɛ mʋ ii biti i bun mʋ kʋpwɛ kakɛ laalaalʋwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kpalɩ fɛɛ ɩ man gyɛ mɛ gbaa‐gbaa mɛ ɔlʋn tɔ nɩɩ n sʋ n tɔwɛ, amaa mɛ‐Sɛ mʋ nɩɩ o sun mɛ mʋ, sa mɛ kɔnɔsa lɩɩ kʋtɔ mʋ nɩɩ n tɔwɛ sʋ, nɩɩ ɩmʋ nɩɩ n tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nɩɩ n nyi fɛɛ mʋ kɔnɔsa mʋ ɩɩ sa nkpa kakpaa. Ɩmʋ sʋ asɩn kʋmaa mʋ nɩɩ n tɔwɛ mʋ, ɩ gyɛ asɩn mʋ nɩɩ Mɛ‐Sɛ tɔwɛ mɛ yɛ n tɔwɛ.” ");
INSERT INTO naw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ɩ maa san gbɛrɛɛ kɛ ba piili Kesu kɔnɔ Kanyaŋɛ nbunɔ kensi‐gyii mʋ, Yesu bɩɩ fɛɛ saŋa fʋʋ fɛɛ ɔ lɩɩ dulinyaa nɩmʋ tɔ bwii kpee Mʋ‐sɛ asɛ. Maa sʋ kebiti sa mʋ asa mʋ nɩɩ ba bʋ dulinyaa nɩmʋ tɔ sʋ mʋ, ɔ nyɛ kebiti sa bamʋ naa fʋʋ ɔkaa. ");
INSERT INTO naw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pɔyɩ kɛ ba piili kalaatɩpwɛ sʋ agyitɔ kigyii mʋ, Sɩtaanɛ wʋla loo Simon mu‐bii, Gyudasi Isikariyoti mʋ tɔ yɛ, ɔ lɛɛ Yesu sa. ");
INSERT INTO naw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu nyi Mʋ‐sɛ maa taa kʋtɔ kʋmaa waa mʋ kɩbaa tɔ, nɩɩ o nyi maa lɩɩ Ɩbwaarɛ asɛ nɩn, nɩɩ mʋ asɛ nɩɩ ee biti o bwii kpee. ");
INSERT INTO naw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ɩmʋ sʋ ɔ kʋsʋ lɩɩ agyitɔ mʋ asɛ, nɩɩ o bugi mʋ balɩmaasʋ, nɩɩ ɔ taa bɔrɩdɩba dɩla mʋ kasɩyɛ. ");
INSERT INTO naw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nɩɩ ɔ kyɛɛgɛ nkyu waa lapɛ gyeesa tɔ, nɩɩ o piili ɛɛ fwɩɩ mʋ abɩɩlapʋ mʋ ayaa sʋ, yɛgɛ ɔ sʋ bɔrɩdɩba mʋ nɩɩ ɔ taa maalɛ mʋ kasɩyɛ mʋ ɛɛ kpayɩ bamʋ ayaa sʋ. ");
INSERT INTO naw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Maa waa kanɩn naa fʋʋ Simon Pita sʋ mʋ, ɔ taasɛ mʋ yɛ, “Ɔnyɩrɩpɛ, fii biti fʋ fwɩɩ mɛ ayaa sʋ nɩn?” ");
INSERT INTO naw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Nbɩɩnbɩɩ ɩmʋ nɩɩ n waa falɛ fɩɩ mɛɛ yɛ fʋ nu kasɛ, amaa kamaa tɔ fii biti fʋ ba nu ɩmʋ kasɛ.” ");
INSERT INTO naw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nɩɩ Pita tɔwɛ Yesu yɛ, “Ayee, n mɛɛ yɛgɛ fʋ fwɩɩ mɛ ayaa sʋ kakaakʋ.” Nɩɩ Yesu tɔwɛ mʋ yɛ, “Nɩɩ fʋ man yɛgɛ nɩɩ n fwɩɩ fʋ ayaa sʋ bɩrɛ, fʋ man bɩla fii tii mɛ abɩɩlapʋ mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nɩɩ Simon Pita tɔwɛ Yesu yɛ, “Kanɩn bɩrɛ Ɔnyɩrɩpɛ, man fwɩɩ mɛ ayaa sʋ nkʋn, fwɩɩ mɛ abaa yɛ mi kumu tɔ gbaa tii sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Ɔkʋmaa mʋ nɩɩ ɔ tee gyee mʋ, mʋ n‐yɩɩ sʋ ɩ man bɩla ɩ sʋ ineesi, ɩmʋ sʋ mʋ ayaa sʋ nkʋn nɩɩ ɛɛ fwɩɩ. Fanɛ n‐yɩɩ sʋ ɩ man sʋ ineesi kʋ, amɔɔ fanɛ tɔ ɔkʋlʋn.” ");
INSERT INTO naw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Lɩɩ fɛɛ ɔ tɛɛ wʋla o nyi ɔmʋ nɩɩ ee biti ɔ lɛɛ mʋ sa, ɩmʋ sʋ nɩɩ ɔ tɔwɛ yɛ, “amɔɔ fanɛ tɔ ɔkʋlʋn” ɩ sʋ ineesi. ");
INSERT INTO naw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Maa fwɩɩ bamʋ ayaa sʋ lʋwɛ mʋ, nɩɩ o bwii taa mʋ balɩmaasʋ bun, nɩɩ o bwii naa kyɩna mʋ ɔkyɩnakpa. Nɩɩ ɔ taasɛ bamʋ yɛ, “Fan nu ɩmʋ nɩɩ n waa sa fanɛ falɛ kasɛ?” ");
INSERT INTO naw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Fɛn tɩɩ mɛ yɛ “Ɔkaapʋpʋ” yɛ “Ɔnyɩrɩpɛ” nɩɩ ɩ gyɛ kesintin, lɩɩ fɛɛ kanɩn nɩɩ n gyɛ. ");
INSERT INTO naw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nɩɩ mɛ, fanɛ‐Nyɩrɩpɛ yɛ fanɛ Ɔkaapʋpʋ n fwɩɩ fanɛ ayaa sʋ falɛ, ɩ dagaa fɛɛ fanɛ gbaa fanɛ fan fwɩɩ abaa ayaa sʋ. ");
INSERT INTO naw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","N waa sɩnkaala sa fanɛ, yɛ fanɛ gbaa fanɛ fan waa fɛɛ kanan mʋ nɩɩ n waa sa fanɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","N tɔwɛ fanɛ kesintin, kɩyaafɔlɛ mɛɛ taalɛ ɔ kyɔ mʋ‐nyɩrɩpɛ, nɩɩ kabɔɔ mɛɛ taalɛ ɔ kyɔ ɔmʋ nɩɩ o sun mʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nbɩɩnbɩɩ fan maa bɩɩ ɩnɩmʋ falɛ, nɩɩ fan kan waa ɩmʋ mʋ, Ɩbwaarɛ ii biti ɔ waa fanɛ kusee. ");
INSERT INTO naw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nɩɩ Yesu tɔwɛ yɛ, “Man gyɛ fanɛ kpini asɩn nɩɩ n tɔwɛ falɛ. N nyi bamʋ nɩɩ n lɛɛ mʋ. Amaa asɩn mʋ nɩɩ ba tɔwɛ waa Asɩnkyan yɩlasa mʋ tɔ mʋ, ɩ dagaa ɩ maa ba tɔ. Asɩn mʋ ɩ gyɛ yɛ, ‘Ɔnyɩn mʋ nɩɩ n maa mʋ an bʋga lapɛ kʋlʋn tɔ an gyii mʋ, biliŋi ɔmʋ nɩɩ ɔ kʋsʋ yɩlɛ mɛ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“N tɔwɛ fanɛ nɩn pɔyɩ kɛ ɩ ba waa. Nɩɩ ɩ ba mʋ, fen biti fan bɩɩ fɛɛ mɛ ɩ gyɛ ‘Ɔmʋ nɩɩ n tɔwɛ yɛ n gyɛ mʋ’. ");
INSERT INTO naw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","N tɔwɛ fanɛ kesintin, ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ ɔsa mʋ nɩɩ n sun mʋ mʋ, kɔɔlɛ mɛ gbaa mɛ nɩmʋ, nɩɩ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ mʋ, kɔɔlɛ ɔmʋ nɩɩ o sun mɛ mʋ gbaa nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu maa tɔwɛ ɩnɩmʋ kpini lʋwɛ mʋ, nɩɩ mʋ kɔkɔlɔ tɔ nyita mʋ. Nɩɩ o bugi tɔ tɔwɛ bamʋ yɛ, “N tɔwɛ fanɛ kesintin yɛ, fanɛ tɔ ɔkʋ ii biti ɔ lɛɛ mɛ sa.” ");
INSERT INTO naw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nɩɩ mʋ abɩɩlapʋ mʋ ba piili bɛɛ kɩɩ abaa ansi tɔ, fɛ nfɛɛrɛ bamʋ tɔ ɔmʋ nɩɩ ɔ dɛɛ. ");
INSERT INTO naw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mʋ abɩɩlapʋ mʋ tɔ ɔkʋlʋn, ɔmʋ nɩɩ Yesu sʋ kebiti sa mʋ mʋ, tɛ ɔ maa Yesu. ");
INSERT INTO naw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nɩɩ Simon Pita ŋabɛɛ mu ansi yɛ, “Taasɛ Ɔnyɩrɩpɛ yɛ, anɩmʋ asɩn nɩɩ ɛɛ tɔwɛ falɛ?” ");
INSERT INTO naw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Maa kpɛɛ Yesu mʋ, ɔ taasɛ mʋ yɛ, “Ɔnyɩrɩpɛ, anɩmʋ nɩɩ fʋ dɛɛ?” ");
INSERT INTO naw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “N kan taa agyitɔ waa lapɛ tɔ mʋ, ɔmʋ nɩɩ n biti n taa sa mʋ mʋ, mʋ ɩ gyɛ kanɩn nyɩmɩsa maŋa.” Maa kpɛɛ agyitɔ mʋ waa lapɛ mʋ tɔ mʋ, ɔ taa sa Gyudasi Isikariyoti. ");
INSERT INTO naw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Gyudasi maa dan kɔɔlɛ agyitɔ maŋa mʋ, nɩɩ Sɩtaanɛ loo mʋ nfɛɛrɛ tɔ. Nɩɩ Yesu tɔwɛ mʋ yɛ, “Kʋtɔ mʋ nɩɩ fii biti yɛ fʋ waa mʋ, waa bilen‐bilen.” ");
INSERT INTO naw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bamʋ nɩɩ ba tɛ ogyikpa maŋa kpini, ɔkʋ man nu asɩn mʋ nɩɩ Yesu tɔwɛ mʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Amaa Gyudasi maa gyɛ ɔmʋ nɩɩ ɛɛ kɩtaa bamʋ afulee sʋ mʋ, akʋ ba fɛ nfɛɛrɛ yɛ, Yesu sun mʋ yɛ ɔ naa sɔɔ atɔ mʋ nɩɩ ii tiri sa Kesu kɔnɔ Kanyaŋɛ nbunɔ agyitɔ mʋ. Nɩɩ akʋ mɔɔ ba fɛ nfɛɛrɛ fɛɛ o sun mʋ nɩn yɛ ɔ taa afulee naa sa atiripu. ");
INSERT INTO naw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gyudasi maa dan kɔɔlɛ agyitɔ mʋ lʋwɛ mʋ, nɩɩ ɔ lɩɩ kewu kyʋn. Saŋa maŋa gyɛ kagyanbwɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Gyudasi maa lɩɩ kyʋn mʋ, nɩɩ Yesu tɔwɛ yɛ, “Saŋa fʋʋ fɛɛ mɛ, Daadimaadi Obii‐nyɩnsa bʋnyaa ɩ lɩɩ ifuli, kɛ Ɩbwaarɛ gbaa ɔ bɔla mɛ sʋ lɛɛ mʋ bʋnyaa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nɩɩ Ɩbwaarɛ kan bɔla mɛ sʋ lɛɛ mʋ bʋnyaa mʋ ifuli mʋ, ee biti ɔ bʋnyaa mɛ, Daadimaadi Obii‐nyɩnsa mʋ. Ɩbwaarɛ ii biti ɔ waa ɩmʋ nbɩɩnbɩɩ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mi‐bii ana, saŋa gbɛrɛɛ ɩ san kɛ n kyɩna fanɛ asɛ. Fen biti fan kɩɩ biti mɛ, fɛɛ kanan mʋ nɩɩ n tɔwɛ Gyiwu abi abɩlɩsa mʋ, kanɩn nɩɩ n tɔwɛ fanɛ nbɩɩnbɩɩ falɛ yɛ, katɩn mʋ nɩɩ n biti n kpee mʋ, fan mɛɛ yɛ fan taalɛ ba tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Nbɩɩnbɩɩ n sa fanɛ kɔnɔsa pʋpwɛ yɛ, fan nyɛ kebiti sa abaa. Fɛɛ kanan mʋ nɩɩ n nyɛ kebiti sa fanɛ mʋ, kanɩn maŋa sʋ nɩɩ fan nyɛ kebiti sa abaa. ");
INSERT INTO naw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nɩɩ fan kan nyɛ kebiti sa abaa mʋ, ɩmʋ ii biti ɩ yɛgɛ asa kpini ba bɩɩ yɛ fan gyɛ mɛ abɩɩlapʋ.” ");
INSERT INTO naw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nɩɩ Simon Pita taasɛ mʋ yɛ, “Ɔnyɩrɩpɛ fɩnɛ nɩɩ fii kpee?” Yesu lɛɛ kɔnɔ yɛ, “Katɩn mʋ nɩɩ n kpee mʋ fʋ mɛɛ yɛ fʋ taalɛ buu mɛ kpee nbɩɩnbɩɩ, amaa fii biti fu buu mɛ ba kamaa tɔ.” ");
INSERT INTO naw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nɩɩ Pita taasɛ mʋ yɛ “Ɔnyɩrɩpɛ, mɩnɛ waa nɩɩ n mɛɛ taalɛ buu fʋ nbɩɩnbɩɩ. N biti n taa mɛ nkpa taga apʋ sa fʋ.” ");
INSERT INTO naw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tʋtɔ nɩɩ Yesu taasɛ mʋ yɛ, “Fii biti fu taa fʋ nkpa taga apʋ sa mɛ kesintin? N tɔwɛ fʋ kesintin yɛ, pɔyɩ kɛ kyaasɛ ɔ bʋn mʋ, fii biti fʋ kyɛɛ ɩlɩɩ ɩsa yɛ fʋ man nyi mɛ.” ");
INSERT INTO naw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Fan man yɛgɛ fanɛ nkɔlɔ ɩ ŋmaa fanɛ. Fan kɔɔlɛ Ɩbwaarɛ gyii kɛ fan kɔɔlɛ ngbaa mɛ gyii. ");
INSERT INTO naw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ibu damantɛ ɩ bʋ Mɛ‐Sɛ kɩkpaara sʋ. Nɩɩ ɩ daa ɩ man gyɛ kanɩn nɩn, naafɔɔ n tɔwɛ fanɛ. N kpee n naa lɔŋɔ ɔkyɩnakpa sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nɩɩ n kan kpee naa lɔŋɔ ɔkyɩnakpa sa fanɛ mʋ, n biti n bwii ba taa fanɛ kpee mɛ asɛ, kɛ fan naa kyɩna katɩn mʋ nɩɩ n tɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Fen nyi ɔkpa mʋ, nɩɩ fen nyi katɩn mʋ nɩɩ n kpee mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nɩɩ Tomasi tɔwɛ Yesu yɛ, “Ɔnyɩrɩpɛ, a man nyi katɩn mʋ nɩɩ fii kpee. Nɩɩ nɛnɛ nɩɩ an biti a waa bɩɩ ɔkpa mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Mɛ ɩ gyɛ ɔkpa mʋ yɛ kesintin mʋ yɛ nkpa mʋ. Ɔkʋ mɛɛ taalɛ kpee Mɛ‐Sɛ asɛ, amɔɔ ɔ bɔla mɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nɩɩ fan kan fan nyi mɛ kesintin tɔ mʋ, naafɔɔ fan nyi Mɛ‐Sɛ mʋ gbaa. Lɩɩ nbɩɩnbɩɩ nɩmʋ ɩɩ sʋ ii kpee mʋ, fen nyi mʋ, nɩɩ fen wu mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nɩɩ Filipu tɔwɛ yɛ, “Ɔnyɩrɩpɛ, kaapʋ anɛ Fʋ‐sɛ mʋ, kʋtɔ mʋ nɩɩ ki tiri anɛ nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tʋtɔ nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Filipu, amɔɔ fʋ man nyi mɛ, halɩɩ kanan mʋ nɩɩ n kyɩna fanɛ asɛ kyɛɛrɛɛ falɛ? Ɔsa kʋmaa mʋ nɩɩ o wu mɛ mʋ, o wu Mɛ‐Sɛ mʋ. Mɩnɛ ɩ waa nɩɩ fʋ bɩla fɩɩ tɔwɛ yɛ, ‘Kaapʋ anɛ Fʋ‐sɛ mʋ?’ ");
INSERT INTO naw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Abɛɛ fʋ man kɔɔlɛ gyii yɛ n maa Mɛ‐Sɛ mʋ an gyɛ kʋkʋlʋn? Asɩn mʋ nɩɩ n tɔwɛ fanɛ mʋ man gyɛ mɛ gbaa‐gbaa mɛ lɛɛ. Amaa Mɛ‐Sɛ mʋ nɩɩ ɔ bʋ mɛ tɔ mʋ ii sun mu kusun. ");
INSERT INTO naw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kanɩn sʋ fan kɔɔlɛ mɛ gyii fɛɛ n maa tɔwɛ yɛ, n maa Mɛ‐Sɛ mʋ an gyɛ kʋkʋlʋn. Nɩɩ ɩ man gyɛ kanɩn gbaa mʋ, fan kɔɔlɛ mɛ gyii lɩɩ asɩn kyinkyinsa mʋ nɩɩ fan wu n maa waa falɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","N tɔwɛ fanɛ kesintin, ɔsa kʋmaa mʋ nɩɩ ɛɛ kɔɔlɛ mɛ ee gyii mʋ, ee biti ɔ waa atɔ mʋ nɩɩ n waa mʋ. Ee biti ɔ waa ɩmʋ nɩɩ ɩ kyɔ falɛ gbaa, lɩɩ fɛɛ n kpee Mɛ‐Sɛ mʋ asɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nɩɩ kʋtɔ kʋmaa mʋ nɩɩ fan kʋlɛ mɛ kɩtɩɩ tɔ sʋ mʋ, n biti n waa sa fanɛ, kɛ mɛ, Obii mʋ n bɩya bʋnyaa sa Mɛ‐Sɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kʋtɔ kʋmaa mʋ nɩɩ fɛn kʋlɛ mɛ lɩɩ mɛ kɩtɩɩ tɔ sʋ mʋ, n biti n waa sa fanɛ.” Yesu da mʋ kɔkɔlɔ sʋ yɛ Kayaayu Kyɩrɛkyɩrɛ mʋ kii biti kɩ ba. ");
INSERT INTO naw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Nɩɩ fan kan fan sʋ kebiti sa mɛ mʋ, fen biti fan buu mɛ kɔnɔsa. ");
INSERT INTO naw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","N biti n kʋlɛ Mɛ‐Sɛ kɛ ɔ sa fanɛ Ɔkyɛtɔpʋ pʋpwɛ mʋ nɩɩ ee biti ɔ baa ɔ bʋ fanɛ asɛ kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mʋ ɩ gyɛ Kayaayu Kyɩrɛkyɩrɛ mʋ nɩɩ ɛɛ lɛɛ Ɩbwaarɛ kesintin mʋ ɛɛ kaapʋ. Dulinya abi ba mɛɛ yɛ ba taalɛ kɔɔlɛ mʋ, lɩɩ fɛɛ ba man nyi mʋ, nɩɩ be mee wu mʋ. Amaa fanɛɛ fanɛ fan nyi mʋ, lɩɩ fɛɛ ɔ bʋ fanɛ asɛ, nɩɩ ee biti ɔ baa ɔ bʋ fanɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","N mɛɛ yɛ n yɛgɛ fanɛ fɛɛ aŋmengyi, n biti n bwii ba fanɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɩ san gbɛrɛɛ, dulinyaa abi ba man bɩla yɛ ba wu mɛ. Amaa fanɛɛ fanɛ bɩrɛ fen biti fan wu mɛ. Lɩɩ fɛɛ n maa tɛ nkpa tɔ falɛ, fanɛ gbaa fanɛ fen biti fan baa fan tɛ nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kanɩn kakɛ maŋa fen biti fan bɩɩ fɛɛ n maa Mɛ‐Sɛ an gyɛ kʋkʋlʋn, nɩɩ n maa fanɛ gbaa an gyɛ kʋkʋlʋn. ");
INSERT INTO naw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mɛ kɔnɔsa, nɩɩ o buu ɩmʋ mʋ, mʋ ɩ gyɛ ɔmʋ nɩɩ ɔ sʋ kebiti sa mɛ. Ɔkʋmaa mʋ nɩɩ ɔ sʋ kebiti sa mɛ mʋ, Mɛ‐Sɛ gbaa ii biti ɔ nyɛ kebiti sa mʋ. Ngbaa mɛ n biti n nyɛ kebiti sa mʋ, kɛ n lɛɛ mɛ n‐yɩɩ kaapʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nɩɩ Gyudasi (man gyɛ Gyudasi Isikariyoti mʋ) tɔwɛ yɛ, “Ɔnyɩrɩpɛ, mɩnɛ waa nɩɩ fii biti fʋ lɛɛ fʋ n‐yɩɩ kaapʋ anɛ nkʋn, nɩɩ man gyɛ dulinyaa abi mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Ɔkʋmaa mʋ nɩɩ ɔ sʋ kebiti sa mɛ mʋ, ii biti o buu mɛ kɩkaapʋ mʋ. Mɛ‐Sɛ ii biti ɔ nyɛ kebiti sa mʋ, nɩɩ maa Mɛ‐Sɛ an biti a ba mʋ asɛ, kɛ a taa mʋ biliŋi anɛ ayɛ. ");
INSERT INTO naw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ɔkʋmaa mʋ nɩɩ ɔ man sʋ kebiti sa mɛ mʋ, mɛɛ yɛ o buu mɛ kɩkaapʋ mʋ. Kɩkaapʋ mʋ nɩɩ fen nu falɛ man gyɛ mɛ gbaa‐gbaa mɛ kɩkaapʋ, ɩɩ lɩɩ Mɛ‐Sɛ mʋ nɩɩ o sun mɛ mʋ asɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“N maa san n bʋ fanɛ asɛ falɛ sʋ nɩɩ n tɔwɛ fanɛ falɛ asɩn. ");
INSERT INTO naw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amaa Ɔkyɛtɔpʋ mʋ nɩɩ ɔ gyɛ Kayaayu Kyɩrɛkyɩrɛ, mʋ nɩɩ Mɛ‐Sɛ mʋ ii biti o sun mɛ kɩtɩɩ tɔ mʋ, ii biti ɔ kaapʋ fanɛ kʋtɔ kʋmaa kɛ o nyiŋi fanɛ kʋtɔ kʋmaa mʋ nɩɩ n tɔwɛ fanɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kayɩɩ‐yuuli kɩ baa kɩ bʋ fanɛ asɛ, mɛ gbaa‐gbaa kayɩɩ‐yuuli nɩɩ n sʋ n sa fanɛ. Amaa ɩ man du fɛɛ dulinyaa kayɩɩ‐yuuli mʋ nɩɩ bɛɛ sa mʋ. Fan man yɛgɛ fanɛ nkɔlɔ i nyita, fan man waa kufuu. ");
INSERT INTO naw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Fan nu n maa tɔwɛ fanɛ yɛ, ‘N kpee kɛ n bɩla bwii ba fanɛ asɛ.’ Nɩɩ fɛn kan fen biti mɛ asɩn mʋ, naafɔɔ fanɛ ansi ii biti i gyii fɛɛ n maa kpee Mɛ‐Sɛ mʋ asɛ, lɩɩ fɛɛ Mɛ‐Sɛ mʋ ɩ gyɛ ɔkparɛ ɔ kyɔ mɛ. ");
INSERT INTO naw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N wʋla n tɔwɛ fanɛ ɩnɩmʋ kpini nbɩɩnbɩɩ pɔyɩ kɛ ɩ ba waa, nɩɩ ɩ kan ba waa mʋ kɛ fan kɔɔlɛ mɛ gyii. ");
INSERT INTO naw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","N mɛɛ bɩla yɛ n tɔwɛ fanɛ asɛ kyɛɛrɛɛ, lɩɩ fɛɛ dulinyaa tɔ owura ɩɩ ba. Ɔ man sʋ ɔlʋn mɛ sʋ, ");
INSERT INTO naw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","amaa i tiri fɛɛ n maa waa kʋtɔ mʋ nɩɩ Mɛ‐Sɛ sa mɛ kɔnɔ yɛ n waa mʋ, kɛ dulinyaa abi ba bɩɩ fɛɛ n sʋ kebiti sa Mɛ‐Sɛ. Fan ba kɛ a lɩɩ nfɩɩ.” ");
INSERT INTO naw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nɩɩ Yesu tɔwɛ mʋ abɩɩlapʋ mʋ yɛ, “Mɛ ɩ gyɛ wayɩn oyu gbaa‐gbaa mʋ nɩɩ kɩɩ sɔyɩ abi, nɩɩ Mɛ‐Sɛ ɩ gyɛ oyu mʋ ɔdɔɔpʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kayaa‐bi kʋmaa mʋ nɩɩ kɩ kyaa mɛ sʋ nɩɩ kɩ mɛɛ sɔyɩ abi mʋ, ɛɛ ŋɛ kɩmʋ nɩn ɛɛ fɔyɩ, nɩɩ kayaa‐bi kʋmaa mʋ nɩɩ kɩɩ sɔyɩ abi mʋ, ɛɛ kpaalɛ kayaa‐bi mʋ kɛ kɩ nyɛ sɔyɩ abi tii sʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lɩɩ asɩn mʋ nɩɩ n tɔwɛ sa fanɛ sʋ mʋ, fan tɛɛ waa kyɩrɛkyɩrɛ. ");
INSERT INTO naw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Fan baa fan bʋ mɛ asɛ, kɛ ngbaa mɛ n baa n bʋ fanɛ asɛ. Kɩyaa‐bi nkʋn mɛɛ taalɛ sɔyɩ abi, amɔɔ kɩ kyaa oyu mʋ sʋ. Kanɩn maŋa nɩɩ fanɛ gbaa fanɛ fɛn mɛɛ taalɛ sɔyɩ abi, amɔɔ fan bʋ mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mɛ ɩ gyɛ oyu mʋ, nɩɩ fanɛ ɩ gyɛ kɩmʋ n‐yaabi mʋ. Ɔsa kʋmaa mʋ nɩɩ ɔ kan ɔ bʋ mɛ asɛ, nɩɩ ngbaa n bʋ mʋ asɛ sʋ mʋ, ee biti ɔ sɔyɩ abi gaa, fɛɛ kanan mʋ nɩɩ kayaa‐bi kyaa oyu sʋ nɩɩ kɩɩ sɔyɩ abi mʋ. Ɩmʋ sʋ nɩɩ fan man tii mɛ sʋ bɩrɛ, fɛn mɛɛ taalɛ waa sɛhn. ");
INSERT INTO naw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ man kan ɔ bʋ mɛ asɛ bɩrɛ, o du nɩn fɛɛ kayaa‐bi mʋ nɩɩ ba ŋɛ tʋʋ nɩɩ kɩ wʋlɛ. Kanɩn n‐yaabi nɩɩ bɛɛ tasɛ bɛɛ tʋʋ fʋlɔn tɔ, kɛ ɩ dɩyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nɩɩ fan kan fan bʋ mɛ asɛ, nɩɩ mɛ asɩn mʋ bʋ fanɛ tɔ mʋ, kʋtɔ kʋmaa mʋ nɩɩ fen biti, nɩɩ fan kʋlɛ Ɩbwaarɛ mʋ, ee biti ɔ waa sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɩɩ fan kan sɔyɩ abi gaa, mʋ nɩɩ ɩɩ kaapʋ fɛɛ fan gyɛ mɛ abɩɩlapʋ mʋ, ɩmʋ ɩ nyɛ lɛɛ Mɛ‐Sɛ bʋnyaa mʋ ifuli kaapʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Fɛɛ kanan mʋ nɩɩ Mɛ‐Sɛ mʋ sʋ kebiti sa mɛ mʋ, kanɩn maŋa nɩɩ ngbaa mɛ n sʋ kebiti sa fanɛ. Ɩmʋ sʋ fan kyaga sʋ kyɩna mi kebiti mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nɩɩ fan kan buu mɛ kɔnɔsa mʋ, n biti n kyaga sʋ nyɛ kebiti sa fanɛ, fɛɛ kanan mʋ nɩɩ n buu Mɛ‐Sɛ kɔnɔsa nɩɩ ɔ sʋ kebiti sa mɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","N tɔwɛ fanɛ ɩnɩmʋ nɩn kɛ mi kensi‐gyii ɔ kyɩna fanɛ tɔ, kɛ fanɛ kensi‐gyii mʋ ɔ naa lʋwɛ kyɛɛkyɛɛ. ");
INSERT INTO naw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mɛ kɔnɔsa ɩ gyɛ yɛ, Fan nyɛ kebiti sa abaa, fɛɛ kanan mʋ nɩɩ n nyɛ kebiti sa fanɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kebiti kɩ man bʋ tɔ kɩ kyɔ kɩnɩmʋ fɛɛ ɔkʋ maa wu sa mʋ kyɛmɩnɛ ana. ");
INSERT INTO naw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nɩɩ fan kan buu mɛ kɔnɔsa mʋ bɩrɛ, fan gyɛ mɛ kyɛmɩnɛ ana nɩn. ");
INSERT INTO naw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N mɛɛ bɩla yɛ n tɩɩ fanɛ mɛ ayaafɔlɛ, lɩɩ fɛɛ kɩyaafɔlɛ man nyi kʋtɔ mʋ nɩɩ mʋ‐nyɩrɩpɛ ɩɩ waa. Amaa n tɩɩ fanɛ mɛ kyɛmɩnɛ ana nɩn, lɩɩ fɛɛ kʋtɔ kʋmaa mʋ nɩɩ n bɩɩla lɩɩ Mɛ‐Sɛ asɛ mʋ, n lɛɛ kaapʋ fanɛ. ");
INSERT INTO naw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Man gyɛ fanɛ ɩ lɛɛ mɛ. Amaa mɛ ɩ lɛɛ fanɛ, nɩɩ n sun fanɛ yɛ fan naa sɔyɩ abi mʋ nɩɩ ii biti ɩ kyɛɛrɛɛ. Nɩɩ fan kan waa kanɩn mʋ, kʋtɔ kʋmaa mʋ nɩɩ fan kʋlɛ Mɛ‐Sɛ mɛ kɩtɩɩ tɔ mʋ, ee biti ɔ waa sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mɛ kɔnɔsa ɩ gyɛ yɛ, fan nyɛ kebiti sa abaa.” ");
INSERT INTO naw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nɩɩ Yesu tɔwɛ yɛ, “Nɩɩ dulinyaa abi ba kan bɛɛ kisi fanɛ mʋ, fan baa fan nyiŋi fɛɛ mɛ nɩɩ ba daa kikisi. ");
INSERT INTO naw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nɩɩ fan kan fan du fɛɛ dulinyaa tɔ abi bɩrɛ, naafɔɔ dulinyaa abi bee biti ba nyɛ kebiti sa fanɛ fɛɛ kɩmʋ asa. Amaa fan man gyɛ dulinyaa abi. Mɛ ɩ lɛɛ fanɛ lɩɩ dulinyaa abi tɔ. Ɩmʋ sʋ nɩɩ dulinyaa abi bee kisi fanɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Fan nyiŋi asɩn mʋ nɩɩ n tɔwɛ fanɛ mʋ yɛ, ‘Kɩyaafɔlɛ mɛɛ taalɛ ɔ kyɔ mʋ‐nyɩrɩpɛ.’ Ɩmʋ sʋ n maa wu awʋrʋfɔ bamʋ abaa tɔ falɛ, kanɩn nɩɩ fanɛ gbaa fanɛ fen biti fan wu awʋrʋfɔ bamʋ abaa tɔ. Nɩɩ ba kan buu mɛ kɩkaapʋ mʋ, bee biti ba buu fanɛ kɩkaapʋ mʋ gbaa. ");
INSERT INTO naw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lɩɩ mɛ kɩtɩɩ sʋ, nɩɩ bee biti ba waa fanɛ ɩnɩmʋ kpini, lɩɩ fɛɛ ba man nyi Ɔmʋ nɩɩ o sun mɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nɩɩ n daa man ba tɔwɛ asɩn mʋ sa bamʋ nɩn, naafɔɔ ba mɛɛ yɛ ba wu alibi kʋpwɛ. Amaa nbɩɩnbɩɩ ba man sʋ kɔnɔ kɩlɛɛ lɩɩ bamʋ alibi sʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɔkʋmaa mʋ nɩɩ ee kisi mɛ mʋ, ee kisi Mɛ‐Sɛ mʋ gbaa. ");
INSERT INTO naw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","N ba waa asɩn kyinkyinsa mʋ nɩɩ ɔkʋ man pɩɩ taalɛ waa bamʋ tɔ. Nɩɩ ba daa ba man wu ɩmʋ bɩrɛ nɩn, naafɔɔ ba mɛɛ yɛ ba wu alibi kʋpwɛ. Amaa nbɩɩnbɩɩ ba wu asɩn kyinkyinsa nɩmʋ kpini. Halɩɩ ɩmʋ kpini gbaa mʋ ba kisi maa Mɛ‐Sɛ. ");
INSERT INTO naw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Amaa ɩnɩmʋ ɩ yɛgɛ Asɩnkyan yɩlasa mʋ ɩ ba tɔ. Asɩn mʋ ɩ gyɛ yɛ, ‘Ba kisi mɛ yɛgɛ ɩ man sʋ kasɛ.’ ");
INSERT INTO naw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Amaa n biti n sun Ɔkyɛtɔpʋ mʋ lɩɩ Mɛ‐Sɛ asɛ, mʋ ɩ gyɛ Kayaayu Kyɩrɛkyɩrɛ mʋ nɩɩ ɛɛ lɛɛ kesintin lɩɩ Ɩbwaarɛ sʋ ɛɛ kaapʋ. ");
INSERT INTO naw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nɩɩ ɩ dagaa fanɛ gbaa fanɛ fan gyii mɛ n‐yɩɩ sʋ kesintin, lɩɩ fɛɛ fan bʋ mɛ asɛ lɩɩ npiili asɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“N tɔwɛ fanɛ ɩnɩmʋ kpini nɩn, kɛ fan man nyɛ yɛgɛ fanɛ kɩkɔɔlɛ‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bee biti ba gya fanɛ lɩɩ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa. Saŋa kʋ ii biti ɔ ba, nɩɩ ɔkʋ kan ba mɔɔ fanɛ gbaa mʋ, ee biti ɔ fɛ nfɛɛrɛ fɛɛ ee sun kusun ɛɛ kyɛ Ɩbwaarɛ tɔ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bee biti ba waa falɛ atɔ, lɩɩ fɛɛ ba man nyi Mɛ‐Sɛ mʋ, nɩɩ ba man nyi mɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","N tɔwɛ fanɛ ɩnɩmʋ nɩn, nɩɩ saŋa mʋ kan fʋʋ mʋ, fen biti fan nyiŋi fɛɛ n wʋla da fanɛ amu tɔ. N man tɔwɛ fanɛ ɩnɩmʋ bilen, lɩɩ fɛɛ n san n bʋ fanɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nɩɩ Yesu tɔwɛ yɛ, “Nbɩɩnbɩɩ n kpee ɔmʋ nɩɩ o sun mɛ mʋ asɛ nɩn, amaa fanɛ ɔkʋ man taasɛ mɛ katɩn mʋ nɩɩ n kpee. ");
INSERT INTO naw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Lɩɩ fɛɛ n maa tɔwɛ fanɛ ɩnɩmʋ kpini sʋ mʋ, fanɛ nkɔlɔ tɔ i nyita. ");
INSERT INTO naw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Amaa n tɔwɛ fanɛ kesintin, mi kikpe mʋ kɩ gyɛ tɔnɔ sa fanɛ nɩn. Nɩɩ n man kan kpee mʋ, Ɔkyɛtɔpʋ mʋ mɛɛ yɛ ɔ ba fanɛ asɛ. Amaa nɩɩ n kan kpee mʋ, n biti n sun mʋ fanɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nɩɩ ɔ kan ba mʋ, ee biti ɔ ba yɛgɛ dulinyaa tɔ asa ba bɩɩ fɛɛ ba fɔyɩ ɔkpa lɩɩ bamʋ alibi sʋ, yɛ ɩkpa kikyiigi mʋ sʋ yɛ Ɩbwaarɛ asɩn kigyii sʋ. ");
INSERT INTO naw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ɔkpa mʋ nɩɩ ba fɔyɩ lɩɩ bamʋ alibi sʋ mʋ ɩ gyɛ yɛ ba mɛɛ kɔɔlɛ mɛ bee gyii. ");
INSERT INTO naw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ɔkpa mʋ nɩɩ ba fɔyɩ lɩɩ ɩkpa kikyiigi sʋ mʋ, ɩ gyɛ yɛ n kpee Mɛ‐Sɛ mʋ asɛ katɩn mʋ nɩɩ fan man bɩla yɛ fan wu mɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ɔkpa mʋ nɩɩ ba fɔyɩ lɩɩ Ɩbwaarɛ asɩn kigyii sʋ mʋ, ɩ gyɛ yɛ Ɩbwaarɛ tɛɛ wʋla bun dulinyaa nɩmʋ tɔ Owura mʋ kʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“N sʋ asɩn kʋkyɔ n tɔwɛ fanɛ, amaa fan mɛɛ taalɛ kɩtaa ɩmʋ kpini nbɩɩnbɩɩ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Amaa nɩɩ Kayaayu mʋ nɩɩ ɛɛ lɛɛ kesintin ɛɛ kaapʋ kan ba mʋ, ee biti ɔ kaapʋ fanɛ kɛ fan bɩɩ kesintin mʋ kpini. Man gyɛ mʋ gbaa‐gbaa ɔlʋn sʋ nɩɩ ɛɛ tɔwɛ. Amaa kʋtɔ mʋ nɩɩ ee nu mʋ nkʋn nɩɩ ɛɛ tɔwɛ, nɩɩ ee biti ɔ tɔwɛ fanɛ kʋtɔ mʋ nɩɩ kii biti kɩ ba. ");
INSERT INTO naw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lɩɩ kʋtɔ mʋ nɩɩ o nu lɩɩ mɛ asɛ nɩɩ ee biti ɔ lɛɛ kaapʋ fanɛ, kɛ ee biti ɔ bɩya mɛ bʋnyaa. ");
INSERT INTO naw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kʋtɔ kʋmaa mʋ nɩɩ kɩ gyɛ Mɛ‐Sɛ mʋ lɛɛ mʋ, gyɛ mɛ lɛɛ nɩn. Ɩmʋ sʋ nɩɩ n tɔwɛ fanɛ yɛ Kayaayu mʋ ii biti ɔ taa kʋtɔ mʋ nɩɩ kɩ gyɛ mɛ lɛɛ mʋ ba kaapʋ fanɛ.” ");
INSERT INTO naw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nɩɩ Yesu kyaga sʋ tɔwɛ yɛ, “Ɩ san gbɛrɛɛ fan man bɩla yɛ fen wu mɛ, nɩɩ ɩ bɩla waa gbɛrɛɛ fen biti fen wu mɛ.” ");
INSERT INTO naw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tʋtɔ maŋa nɩɩ mʋ abɩɩlapʋ akʋ bɛɛ taasɛ abaa yɛ, “Mɩnɛ nɩɩ mʋ katɔwɛ mʋ ɩɩ kaapʋ? Maa tɔwɛ yɛ, ‘Ɩ san gbɛrɛɛ fan man bɩla yɛ fan wu mɛ, nɩɩ ɩ bɩla waa gbɛrɛɛ, fen biti fan wu mɛ’ nɩɩ ɔ bɩla bwii tɔwɛ yɛ, ‘N kpee Mɛ‐Sɛ mʋ asɛ’ mʋ, mɩnɛ nɩɩ ɩnɩmʋ ɩɩ kaapʋ?” ");
INSERT INTO naw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nɩɩ ba maa sʋ bɛɛ taasɛ yɛ, “ ‘Ɩ san gbɛrɛɛ’ mʋ, ɩmʋ kasɛ ɩ gyɛ nɛnɛ? A mee nu asɩn mʋ nɩɩ ɛɛ tɔwɛ mʋ kasɛ.” ");
INSERT INTO naw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nɩɩ Yesu bɩɩ fɛɛ mʋ abɩɩlapʋ mʋ bee biti ba taasɛ mʋ asɩn mʋ kasɛ, nɩɩ ɔ taasɛ bamʋ yɛ, “N maa tɔwɛ yɛ, ‘Ɩ san gbɛrɛɛ fan man bɩla yɛ fen wu mɛ, nɩɩ ɩ bɩla waa gbɛrɛɛ fen biti fan wu mɛ’ mʋ, ɩmʋ asɩn nɩɩ fɛn taasɛ abaa? ");
INSERT INTO naw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","N tɔwɛ fanɛ kesintin yɛ, fen biti fan su kɛ fan bɔta tɔ, yɛgɛ dulinyaa abi mɔɔ bee gyii bamʋ ansi. Fanɛ nkɔlɔ ii biti ii nyita fanɛ, amaa fanɛ nkɔlɔ kinyita ii biti ɩ ba biliŋi nkɔlɔ fuuli. ");
INSERT INTO naw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","I du nɩn fɛɛ keduŋidi maa kɩtaa ɔkyɩɩ mʋ, ɩ kɔ mʋ lɩɩ fɛɛ mʋ awʋrʋfɔ saŋa fʋʋ. Amaa nɩɩ ɔ kʋʋgɛ kebii mʋ, ɛɛ tan mʋ awʋrʋfɔ mʋ sʋ, lɩɩ fɛɛ ɔ kʋʋgɛ kebii waa dulinyaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kanɩn nɩɩ i du sa fanɛ gbaa fanɛ. Nbɩɩnbɩɩ fan bʋ awʋrʋfɔ tɔ. Amaa n biti n bɩla wu fanɛ, kɛ fanɛ ansi i gyii. Nɩɩ ɔkʋ mɛɛ taalɛ lɛɛ kanɩn kensi‐gyii maŋa lɩɩ fanɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nɩɩ kakɛ maŋa kan fʋʋ mʋ, fan man bɩla yɛ fan taasɛ mɛ sɛhn. N tɔwɛ fanɛ kesintin yɛ Mɛ‐Sɛ ii biti ɔ sa fanɛ kʋtɔ kʋmaa mʋ nɩɩ fan kʋlɛ lɩɩ mɛ kɩtɩɩ tɔ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Halɩɩ ba lɩɩ ndaga fan man pɩɩta kʋlɛ kʋtɔ kʋ lɩɩ mɛ kɩtɩɩ tɔ sʋ. Fan kʋlɛ, fen biti fan nyɛ, kɛ fanɛ kensi‐gyii ɔ nyɛ akyɔ. ");
INSERT INTO naw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ɩ gyɛ kesintin fɛɛ aŋasan tɔ nɩɩ n tɔwɛ asɩn nɩmʋ. Amaa saŋa kʋ ɩɩ ba nɩɩ n man bɩla yɛ n tɔwɛ fanɛ aŋasan tɔ. N biti n lɛɛ ifuli tɔwɛ fanɛ kʋtɔ kʋmaa nɩmʋ lɩɩ Mɛ‐Sɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kanɩn kakɛ maŋa fen biti fan kʋlɛ Mɛ‐Sɛ lɩɩ mɛ kɩtɩɩ tɔ sʋ. N mɛɛ tɔwɛ nɩn yɛ n biti n yɩlɛ fanɛ ayaa tɔ kʋlɛ Mɛ‐Sɛ sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Lɩɩ fɛɛ Mɛ‐Sɛ mʋ gbaa‐gbaa sʋ kebiti sa fanɛ, kpalɩ fɛɛ fan sʋ kebiti sa mɛ nɩɩ fan kɔɔlɛ gyii fɛɛ n lɩɩ Ɩbwaarɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","N lɩɩ Mɛ‐Sɛ mʋ asɛ ba dulinyaa tɔ. Nɩɩ nbɩɩnbɩɩ n lɩɩ dulinyaa nɩmʋ tɔ n bwii n kpee Mɛ‐Sɛ mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nɩɩ Yesu abɩɩlapʋ mʋ ba tɔwɛ yɛ, “Nbɩɩnbɩɩ bɩrɛ, fʋ man bɩla fɩɩ tɔwɛ aŋasan tɔ, fii sii fii bugi tɔ nɩn fɩɩ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nbɩɩnbɩɩ an wu fɛɛ fu nyi kʋtɔ kʋmaa nɩmʋ, nɩɩ ɩ man bɩla i tiri fɛɛ ɔkʋ a taasɛ fʋ kʋtɔ kʋ. Ɩnɩmʋ ɩ yɛgɛ nɩɩ an kɔɔlɛ fu gyii yɛ fʋ lɩɩ Ɩbwaarɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Nbɩɩnbɩɩ bɩrɛ fan kɔɔlɛ gyii? ");
INSERT INTO naw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Amaa saŋa kʋ ɩɩ ba, nɩɩ kɩ tɛɛ ba gbaa, nɩɩ fanɛ ɔkʋmaa nɩmʋ ii biti ɔ yaasɛ tɔ kpee mʋ ayɛ. Fen biti fan yɛgɛ mɛ nkʋn. Amaa ɩ mɛɛ yɛ ɩ san mɛ nkʋn lɩɩ fɛɛ Mɛ‐Sɛ mʋ bʋ mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“N tɔwɛ fanɛ falɛ asɩn nɩn, kɛ lɩɩ mɛ sʋ mʋ, kɛ fan nyɛ kayɩɩ‐yuuli. Fen biti fan gyii awʋrʋfɔ dulinyaa nɩmʋ tɔ. Amaa fan nyɛ nkɔlɔ, lɩɩ fɛɛ n kɔ gyii dulinyaa mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ, ɔ kʋsaa mu kumu kɩɩ sʋsʋ nɩɩ ɔ kʋlɛ Ɩbwaarɛ yɛ, “Nsɛ saŋa mʋ fʋʋ. Sa mɛ, Fu‐bii mʋ bʋnyaa, kɛ mɛ, Fu‐bii mʋ gbaa n sa fʋ bʋnyaa. ");
INSERT INTO naw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Lɩɩ fɛɛ fʋ sa mɛ ɔlʋn lɩɩ asa kpini sʋ, fɛɛ n sa asa mʋ nɩɩ fʋ taa bɔɔta mɛ mʋ kpini nkpa kakpaa. ");
INSERT INTO naw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nkpa kakpaa mʋ ɩ gyɛ yɛ asa ba bɩɩ fʋ, kesintin Ɩbwaarɛ kʋlʋn mʋ, kɛ ba bɩɩ mɛ, Yesu Krisito mʋ nɩɩ fu sun mʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","N bɩya fʋ bʋnyaa kasɛ sʋ nfɩɩ, lɩɩ n maa lʋwɛ fu kusun mʋ nɩɩ fʋ sa mɛ yɛ n ba waa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mɛ‐Sɛ, sa mɛ bʋnyaa fu ansi tɔ nbɩɩnbɩɩ nɩmʋ, bʋnyaa mʋ nɩɩ n wʋla n sʋ fʋ asɛ pɔyɩ nɩɩ fʋ tʋʋ dulinyaa mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nɩɩ Yesu kyaga sʋ yɛ, “N lɛɛ fu kedubi kaapʋ bamʋ nɩɩ fʋ lɛɛ bamʋ lɩɩ dulinyaa nɩmʋ tɔ sa mɛ mʋ. Ba daa ba gyɛ fʋ lɛɛ nɩn, nɩɩ fʋ taa bamʋ sa mɛ. Nɩɩ ba kɔɔlɛ fʋ asɩn mʋ nɩɩ ba buu ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nbɩɩnbɩɩ bɩrɛ, ba bɩɩ fɛɛ kʋtɔ kʋmaa mʋ nɩɩ n sʋ mʋ lɩɩ fʋ asɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Lɩɩ fɛɛ n tɔwɛ bamʋ asɩn mʋ nɩɩ fʋ sa mɛ mʋ, nɩɩ ba kɔɔlɛ. Ba bɩɩ kesintin tɔ fɛɛ n lɩɩ fʋ asɛ, nɩɩ ba kɔɔlɛ gyii fɛɛ fu i sun mɛ. ");
INSERT INTO naw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","N kʋlɛ kabwaarɛ‐kʋlɛ n sa bamʋ. N mɛɛ kʋlɛ n sa dulinyaa abi, amaa bamʋ nɩɩ fʋ taa sa mɛ, lɩɩ fɛɛ ba gyɛ fʋ lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Asa mʋ nɩɩ ba gyɛ mɛ lɛɛ mʋ kpini, ba gyɛ fʋ lɛɛ, nɩɩ bamʋ nɩɩ ba gyɛ fʋ lɛɛ mʋ ba gyɛ mɛ lɛɛ. Lɩɩ bamʋ sʋ nɩɩ mɛ bʋnyaa mʋ lɩɩ ifuli. ");
INSERT INTO naw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","N man bɩla yɛ n kyɩna dulinyaa nɩmʋ tɔ, n ba fʋ asɛ nɩn. Amaa bɛɛ bamʋ bɩrɛ ba san ba bʋ dulinyaa nɩmʋ tɔ. Nsɛ Kyɩrɛkyɩrɛ taa fʋ kɩtɩɩ mʋ nɩɩ fʋ sa mɛ ɔlʋn mʋ kun bamʋ, kɛ ba nyɛ waa kʋkʋlʋn fɛɛ kanan mʋ nɩɩ maa fʋ an gyɛ kʋkʋlʋn mʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Maa kyɩna n bʋ bamʋ asɛ mʋ, kɩtɩɩ mʋ nɩɩ fʋ sa mɛ mʋ, kɩmʋ ɔlʋn tɔ nɩɩ n taa kɩɩ bamʋ sʋ, nɩɩ n kun bamʋ. Ɩmʋ sʋ bamʋ tɔ ɔkʋ man fɔyɩ, amɔɔ ɔmʋ nɩɩ ɔ dagaa fɛɛ ɔ fɔyɩ mʋ, kɛ Asɩnkyan yɩlasa mʋ ɩ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Nbɩɩnbɩɩ n ba fʋ asɛ nɩmʋ. Amaa maa san n bʋ dulinyaa nɩmʋ tɔ mʋ nɩɩ n tɔwɛ ɩnɩmʋ, kɛ ba nyɛ mɛ kensi‐gyii bamʋ tɔ danbɩrasa naa lʋwɛ. ");
INSERT INTO naw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N taa fʋ asɩn mʋ sa bamʋ, nɩɩ dulinyaa abi ba kisi bamʋ, lɩɩ fɛɛ ba man bɩla ba gyɛ dulinyaa tɔ abi, fɛɛ kanan mʋ nɩɩ n man gyɛ dulinyaa tɔ obii mʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","N mɛɛ kʋlɛ fʋ nɩn yɛ fʋ lɛɛ bamʋ lɩɩ dulinyaa tɔ, amaa n kʋlɛ nɩn yɛ fu kun bamʋ lɩɩ Sɩtaanɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba man gyɛ dulinyaa nɩmʋ lɛɛ, fɛɛ kanan mʋ nɩɩ n man gyɛ kɩmʋ lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Taa fʋ asɩn kesintin lɔŋɔ bamʋ yɩla, lɩɩ fɛɛ fʋ asɩn mʋ ɩ gyɛ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Fɛɛ kanan mʋ nɩɩ fu sun mɛ dulinyaa tɔ mʋ, kanɩn nɩɩ ngbaa mɛ n sun bamʋ dulinyaa tɔ. ");
INSERT INTO naw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Lɩɩ bamʋ sʋ nɩɩ n taa mɛ n‐yɩɩ sa fʋ, kɛ ngbaa bamʋ ba nyɛ taa bamʋ n‐yɩɩ sa fʋ kesintin tɔ.” ");
INSERT INTO naw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nɩɩ Yesu bɩla kʋlɛ kabwaarɛ‐kʋlɛ, “Man gyɛ mɛ abɩɩlapʋ mʋ nkʋn nɩɩ n kʋlɛ kabwaarɛ‐kʋlɛ n sa. N kʋlɛ n sa bamʋ nɩɩ bee biti ba be nu mɛ asɩn lɩɩ bamʋ asɛ kɛ ba kɔɔlɛ mɛ gyii mʋ gbaa. ");
INSERT INTO naw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nsɛ, mɛ kabwaarɛ‐kʋlɛ ɩ gyɛ yɛ bamʋ kpini ba waa kʋkʋlʋn, fɛɛ kanan mʋ nɩɩ fʋ bʋ mɛ tɔ nɩɩ ngbaa n bʋ fʋ tɔ mʋ. N kʋlɛ fʋ yɛ, ba baa ba bʋ anɛ tɔ, kɛ dulinyaa abi ba kɔɔlɛ gyii yɛ fu i sun mɛ. ");
INSERT INTO naw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","N sa bamʋ bʋnyaa mʋ nɩɩ fʋ sa mɛ mʋ, kɛ ba nyɛ waa kʋkʋlʋn fɛɛ kanan mʋ nɩɩ an gyɛ kʋkʋlʋn mʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","N ba n bʋ bamʋ tɔ yɛgɛ fʋ bʋ mɛ tɔ, kɛ ba bʋga waa kɔnɔ kʋlʋn naa lʋwɛ. Ɩnɩmʋ ii biti ɩ yɛgɛ dulinyaa abi ba bɩɩ fɛɛ fu i sun mɛ, nɩɩ fʋ sʋ kebiti sa bamʋ fɛɛ kanan mʋ nɩɩ fʋ sʋ kebiti sa mɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Nsɛ n biti fɛɛ bamʋ nɩɩ fʋ taa sa mɛ mʋ, ba baa ba bʋ mɛ asɛ katɩn mʋ nɩɩ n bʋ mʋ. Kɛ ba wu mɛ bʋnyaa mʋ nɩɩ fʋ taa sa mɛ mʋ, lɩɩ fɛɛ fʋ sʋ kebiti sa mɛ pɔyɩ nɩɩ fʋ tʋʋ dulinyaa mʋ. ");
INSERT INTO naw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Nsɛ, ɩkpa kyiigisa wuya, dulinyaa abi ba maa man nyi fʋ, amaa mɛɛ mɛ n nyi fʋ, nɩɩ mi abuupu mʋ be nyi fɛɛ fu i sun mɛ. ");
INSERT INTO naw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N lɛɛ fu kedubi kaapʋ bamʋ, nɩɩ n biti n kyaga sʋ lɛɛ fʋ kaapʋ bamʋ, kɛ fu kebiti mʋ nɩɩ fʋ sʋ sa mɛ mʋ kɩ baa kɩ bʋ bamʋ tɔ, kɛ ngbaa mɛ n baa n bʋ bamʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu maa kʋlɛ kabwaarɛ‐kʋlɛ lʋwɛ mʋ, maa mʋ abɩɩlapʋ mʋ ba faa kɩpantan mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ Kidiron kpee kɩmʋ benbe. Kadɔɔ‐bi kʋ kʋbʋ tʋtɔ, nɩɩ ba loo kɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nɩɩ Gyudasi mʋ nɩɩ ɛɛ lɛɛ Yesu ɛɛ sa mʋ, nyi tʋtɔ. Lɩɩ fɛɛ, Yesu maa mʋ abɩɩlapʋ bɛɛ taalɛ bɛɛ gyaŋɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ɩmʋ sʋ aseepu bɩlɩsa yɛ Farasii abi ba yɛgɛ nɩɩ Gyudasi gyankpaa Roma anaakɔpʋ yɛ kabwaarɛ‐sunkpa ayɛ akɩɩsʋpʋ, yɛgɛ ba sʋ ɩgyaa yɛ ɩfɩtɩla yɛ adʋntɔ ba kadɔɔ‐bi mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu maa nyi kʋtɔ mʋ nɩɩ kii biti kɩ ba mʋ sʋ mʋ, ɔ lɩɩ abɩɩlapʋ mʋ tɔ nɩɩ ɔ taasɛ bamʋ yɛ, “Anɩmʋ nɩɩ fen biti?” ");
INSERT INTO naw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nɩɩ ba lɛɛ kɔnɔ yɛ, “An biti Yesu Kanasareti‐nyɩn mʋ nɩn.” Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Mɛ gyɛ mʋ.” Yɛgɛ Gyudasi mʋ nɩɩ ɛɛ lɛɛ mʋ sa mʋ yɩlɛ bamʋ asɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu maa tɔwɛ yɛ, “Mɛ ɩ gyɛ mʋ” mʋ, nɩɩ ba bwii kamaa tɩyɛ kasɛ. ");
INSERT INTO naw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nɩɩ ɔ bɩla taasɛ bamʋ yɛ, “Anɩmʋ nɩɩ fen biti?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “An biti Yesu Kanasareti‐nyɩn mʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “N tɔwɛ fanɛ yɛ mɛ ɩ gyɛ mʋ. Ɩmʋ sʋ nɩɩ mɛ nɩɩ fen biti bɩrɛ, fan yɛgɛ bamʋ nɩɩ ba tii mɛ sʋ falɛ ba natɛ.” ");
INSERT INTO naw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ɩnɩmʋ ɩ waa nɩn, kɛ asɩn mʋ nɩɩ ɔ wʋla tɔwɛ mʋ ɩ ba tɔ. Asɩn mʋ ɩ gyɛ yɛ, “N man yɛgɛ bamʋ nɩɩ fʋ taa bamʋ sa mɛ mʋ tɔ ɔkʋ fɔyɩ” mʋ. ");
INSERT INTO naw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Pita sʋ sakunde, nɩɩ ɔ bɩɩtɛ kɩmʋ lɔɔrɛ nɩɩ ɔ ŋɛ oseepu bɩlɩsa asɛ kɩyaafɔlɛ gyisa kʋsʋ tɩn. Kɩyaafɔlɛ maŋa kɩtɩɩ ɩ gyɛ Malikusi. ");
INSERT INTO naw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu tɔwɛ Pita yɛ, “Bwiiyaa fʋ sakunde mʋ waa kɩmʋ kukufee tɔ. Fʋ man nyi fɛɛ i tiri fɛɛ n gyii awʋrʋfɔ mʋ nɩɩ Nsɛ Ɩbwaarɛ ŋmina yɩla mɛ mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nɩɩ anaakɔpʋ mʋ yɛ bamʋ ɔbɩlɩsa yɛ kabwaarɛ‐sunkpa ayɛ akɩɩsʋpʋ mʋ ba kɩtaa Yesu, nɩɩ ba ŋmina mʋ. ");
INSERT INTO naw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nɩɩ ba gyankpaa taa mʋ kpee Anasi asɛ, mʋ ɩ gyɛ Kayifasi mʋ‐saa, mʋ nɩɩ ɔ gyɛ oseepu bɩlɩsa asɛ kanɩn kesu maŋa. ");
INSERT INTO naw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayifasi maŋa ɩ gyɛ ɔmʋ nɩɩ ɔ daa tɔwɛ waa Gyiwu abi mʋ yɛ ɩ bɔ fɛɛ nyɩmɩsa kʋlʋn o wu sa asa kpini mʋ. ");
INSERT INTO naw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pita maa ɔbɩɩlapʋ kʋ ba buu Yesu. Fɛɛ ɔbɩɩlapʋ mʋ maa nyi Oseepu bɩlɩsa asɛ mʋ sʋ mʋ, o buu Yesu loo oseepu bɩlɩsa asɛ mʋ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Amaa Pita gyoo kebunɔ. Ɔbɩɩlapʋ mʋ nɩɩ o nyi Oseepu bɩlɩsa asɛ mʋ, bwii ba tɔwɛ kibite mʋ nɩɩ ɛɛ kɩɩ kebunɔ mʋ sʋ mʋ asɛ, nɩɩ ɔ taa Pita loo. ");
INSERT INTO naw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kibite mʋ nɩɩ ɔ kɩɩ kebunɔ mʋ taasɛ Pita yɛ, “Fʋ man gyɛ Yesu abɩɩlapʋ mʋ ɔkʋ nɩn?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ayee, n man gyɛ.” ");
INSERT INTO naw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɩ kyɩna ɩ gyɛ awɔɔ tɔ nɩn, nɩɩ ayaafɔlɛ yɛ kabwaarɛ‐sunkpa ayɛ akɩɩsʋpʋ mʋ ba dɩyɛla fʋlɔn bɛɛ wʋlɛ, nɩɩ Pita gbaa ba yɩlɛ bamʋ asɛ ɛɛ wʋlɛ fʋlɔn. ");
INSERT INTO naw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Oseepu bɩlɩsa asɛ Anasi taasɛ Yesu lɩɩ mʋ abɩɩlapʋ mʋ yɛ asɩn mʋ nɩɩ ɛɛ kaapʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Saŋa kʋmaa nɩmʋ sakyɔ tɔ nɩɩ n tɔwɛ asɩn, yɛgɛ n kaapʋ atɔ kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa yɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ katɩn mʋ nɩɩ Gyiwu abi kpini bɛɛ gyaŋɛ mʋ. N man tɔwɛ kʋtɔ kʋ baala asiri tɔ. ");
INSERT INTO naw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mɩnɛ sʋ nɩɩ fɩɩ taasɛ mɛ falɛ asɩn? Taasɛ bamʋ nɩɩ ba nu mɛ asɛ mʋ. Ba nyi kʋtɔ mʋ nɩɩ n tɔwɛ.” ");
INSERT INTO naw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu maa tɔwɛ kanɩn mʋ, nɩɩ akɩɩsʋpʋ mʋ tɔ ɔkʋ mʋ nɩɩ ɔ yɩlɛ tʋtɔ mʋ kpa mʋ ɔtan, nɩɩ ɔ taasɛ mʋ yɛ, “Falɛ nɩɩ ɩ dagaa fʋ maa lɛɛ Oseepu bɩlɩsa asɛ kɔnɔ?” ");
INSERT INTO naw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Nɩɩ n kan tɔwɛ asɩn akʋ nɩɩ ɩ man bʋrɔn mʋ, tɔwɛ asɩn maŋa kɛ ɔkʋmaa nɩmʋ o nu. Amaa nɩɩ mɛ asɩn mʋ ɩ gyɛ kesintin mʋ, mɩnɛ waa nɩɩ fʋ da mɛ ɔtan?” ");
INSERT INTO naw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tʋtɔ nɩɩ ɔbɩlɩsa Anasi yɛgɛ nɩɩ ba taa Yesu yɛ kanan mʋ nɩɩ ba ŋmina mʋ mʋ naa sa Kayifasi, Oseepu bɩlɩsa asɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Pita san ɔ yɩlɛ ɛɛ wʋlɛ fʋlɔn, nɩɩ ɔkʋ ba taasɛ mʋ yɛ, “Fʋ man gyɛ mʋ abɩɩlapʋ mʋ tɔ ɔkʋ nɩn?” Nɩɩ Pita kyɛ yɛ, “Ayee, n man gyɛ.” ");
INSERT INTO naw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nɩɩ oseepu bɩlɩsa asɛ mʋ ayaafɔlɛ mʋ tɔ ɔkʋ, ɔmʋ nɩɩ Pita ŋɛ mʋ kʋsʋ tɩn mʋ, mʋ kʋʋpʋ, taasɛ mʋ yɛ, “N man wu fʋ maa bʋ mʋ asɛ kadɔɔ‐bi mʋ tɔ?” ");
INSERT INTO naw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nɩɩ Pita bwii kyɛ. Opula maŋa tɔ nɩɩ kyaasɛ bʋn. ");
INSERT INTO naw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nɩɩ ba lɛɛ Yesu lɩɩ Kayifasi asɛ nyenyenfuu, kpee Ɔsʋwʋlɛ Ɔkɩɩsʋpʋ mʋ kɩkpaara tɔ Amaa Gyiwu abi mʋ ba man loo kɩkpaara mʋ tɔ, lɩɩ fɛɛ nɩɩ ba kan loo tʋtɔ mʋ, bee biti ba waa ineesi kɛ i tii bamʋ ɔkpa kɛ ba man nyɛ gyii Kesu kɔnɔ Kanyaŋɛ nbunɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ɩmʋ sʋ Ɔsʋwʋlɛ ɔkɩɩsʋpʋ Paleti lɩɩ kɩkpaara sʋ ba bamʋ asɛ, nɩɩ ɔ taasɛ bamʋ yɛ, “Mɩnɛ asɩn pwɩɩsa nɩɩ fan sʋ lɩɩ ɔnyɩn nɩmʋ sʋ?” ");
INSERT INTO naw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Ɔ daa ɔ man waa alibi akʋ nɩn, naafɔɔ a mɛɛ yɛ a taa mʋ ba waa fʋ abaa tɔ.” ");
INSERT INTO naw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paleti tɔwɛ bamʋ yɛ, “Fan taa mʋ bwii kɛ fan naa taa fanɛ gbaa‐gbaa fanɛ nbara gyii mʋ asɩn.” Amaa ba lɛɛ kɔnɔ yɛ, “Fanɛ Roma abi fan man sa anɛ ɔkpa yɛ a mɔɔ ɔkʋ.” ");
INSERT INTO naw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ɩnɩmʋ ɩ waa nɩn kɛ asɩn mʋ nɩɩ Yesu tɔwɛ lɩɩ mu lewu mʋ nɩɩ ee biti o wu mʋ kudubi ɩ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nɩɩ Paleti bwii loo mʋ kɩkpaara tɔ. Nɩɩ ɔ tɩɩ Yesu ba yɩlɛ mu ansi tɔ, nɩɩ ɔ taasɛ mʋ yɛ, “Fʋ ɩ gyɛ Gyiwu abi Owura mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nɩɩ Yesu taasɛ mʋ yɛ, “Asɩn mʋ nɩɩ fʋ taasɛ mɛ falɛ lɩɩ fʋ asɛ nɩn abɛɛ ɔsa kʋ ɩ tɔwɛ mɛ asɩn sa fʋ?” ");
INSERT INTO naw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paleti lɛɛ kɔnɔ yɛ, “N gyɛ Gyiwu obii nɩn? Fʋ gbaa‐gbaa fʋ asa yɛ fʋ aseepu bɩlɩsa ɩ taa fʋ waa mɛ kɩbaa tɔ. Mɩnɛ nɩɩ fʋ waa?” ");
INSERT INTO naw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Mi kuwura‐gyii kɩ man gyɛ dulinyaa nɩmʋ tɔ lɛɛ. Nɩɩ n daa n gyɛ dulinyaa nɩmʋ tɔ lɛɛ nɩn, naafɔɔ mi abuupu ba dɩn kɔ sa mɛ, kɛ Gyiwu abi ba man nyɛ mɛ kɩtaa waa bamʋ abɩlɩsa abaa tɔ. Amaa mi kuwura‐gyii mʋ kɩ man gyɛ dulinyaa nɩmʋ tɔ lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nɩɩ Paleti lɛɛ kɔnɔ yɛ, “Kanɩn bɩrɛ fʋ gyɛ owura nɩn!” Yesu lɛɛ kɔnɔ yɛ, “Fʋ maa tɔwɛ yɛ n gyɛ owura mʋ, ɩ gyɛ kesintin. Ɩnɩmʋ sʋ nɩɩ ba kʋʋgɛ mɛ ba dulinyaa tɔ, kɛ n ba tɔwɛ lɩɩ kesintin mʋ sʋ. Ɔkʋmaa mʋ nɩɩ ee biti kesintin mʋ ii nu mɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nɩɩ Paleti taasɛ mʋ yɛ, “Mɩnɛ ɩ gyɛ kesintin?” Maa taasɛ mʋ lʋwɛ mʋ, nɩɩ o bwii lɩɩ kpee Gyiwu abi mʋ asɛ nɩɩ ɔ tɔwɛ bamʋ yɛ, “N man wu asɩn mʋ nɩɩ n yɩlɛ sʋ kɛ n bun ɔnyɩn nɩmʋ kʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amaa ɩ gyɛ fanɛ anaana tɔ nɩn fɛɛ Kesu kɔnɔ Kanyaŋɛ nbunɔ kensi‐gyii saŋa n yɛgɛ n lɛɛ bamʋ nɩɩ ba tii bamʋ obu mʋ ɔkʋ mʋ nɩɩ fen biti mʋ, n sa fanɛ. Ɩmʋ sʋ fen biti fɛɛ n yɛgɛ fanɛ Gyiwu abi owura mʋ sa fanɛ abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nɩɩ ba kuusi tɔwɛ yɛ, “Ayee! Man gyɛ mʋ, lɛɛ Barabasi sa anɛ.” Barabasi ɩ kyɩna ɔ kʋsʋ yɩlɛ awura sʋ bɩya keluu. ");
INSERT INTO naw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tʋtɔ nɩɩ Paleti taa Yesu sa, nɩɩ ba tɩŋɛ mʋ awulibi. ");
INSERT INTO naw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nɩɩ anaakɔpʋ mʋ ba taa iwii bɔɔ kuwura‐wʋrʋ bun mʋ, nɩɩ ba bun mʋ kɩrɩman‐kyu balɩmaasʋ fɛɛ owura. ");
INSERT INTO naw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nɩɩ bɛɛ ba mʋ asɛ bɛɛ tɔwɛ mʋ yɛ, “Eee! Gyiwu abi owura, eee, owura!” Nɩɩ bɛɛ kpee bɛɛ kpa mʋ ɩtan. ");
INSERT INTO naw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nɩɩ Paleti bɩla lɩɩ ba kewu Gyiwu abi mʋ asɛ ba tɔwɛ bamʋ yɛ, “Fan nu nfɩɩ, n sʋ mʋ n bɩya fanɛ, kɛ fan bɩɩ fɛɛ mɛɛ mɛ n man wu alibi akʋ mʋ sʋ, mʋ nɩɩ n taa bun mʋ kʋpwɛ.” ");
INSERT INTO naw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu maa lɩɩ ba mʋ, o bun iwii kuwura‐wʋrʋ yɛ kɩrɩman‐kyu balɩmaasʋ, nɩɩ Paleti tɔwɛ asa mʋ yɛ, “Fan kɩɩ, ɔnyɩn mʋ ndee!” ");
INSERT INTO naw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aseepu bɩlɩsa yɛ Gyiwu anaakɔpʋ ba maa wu Yesu mʋ ba kuusi yɛ, “Da mʋ mata oyu laasa sʋ mɔɔ. Da mʋ mata.” Nɩɩ Paleti tɔwɛ bamʋ yɛ, “Fanɛ gbaa‐gbaa fanɛ fan taa mʋ naa da mata oyu laasa sʋ. Mɛɛ mɛ n man wu alibi akʋ mʋ nɩɩ n taa bun mʋ kʋpwɛ.” ");
INSERT INTO naw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nɩɩ Gyiwu abi mʋ ba lɛɛ Paleti kɔnɔ yɛ, “An sʋ nbara kʋ nɩɩ ɩɩ kaapʋ fɛɛ ɔnyɩn nɩmʋ dagaa maa wu, lɩɩ fɛɛ ɔ tɩɩ mʋ n‐yɩɩ yɛ mʋ gyɛ Ɩbwaarɛ Mu‐Bii.” ");
INSERT INTO naw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Paleti maa nu ɩnɩmʋ mʋ kufuu kɩ kɩtaa mʋ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nɩɩ o bwiiyaa Yesu loo kɩkpaara mʋ tɔ nɩɩ ɔ taasɛ mʋ yɛ, “Fɩnɛ nɩɩ fʋ lɩɩ?” Amaa Yesu man tʋwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nɩɩ ɔ bɩla taasɛ mʋ yɛ, “Fu kina mɛ asɛ kɩ tɔwɛ? Fʋ man nyi fɛɛ n sʋ ɔlʋn n taalɛ yɛgɛ fʋ natɛ kɩyan, abɛɛ ba da fʋ mata oyu laasa sʋ mɔɔ?” ");
INSERT INTO naw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nɩɩ Yesu lɛɛ mʋ kɔnɔ yɛ, “Nɩɩ Ɩbwaarɛ daa ɔ man sa fʋ ɔlʋn mɛ sʋ nɩn, naafɔɔ fʋ mɛɛ taalɛ waa mɛ sɛhn. Amaa ɔnyɩn mʋ nɩɩ ɔ lɛɛ mɛ sa fʋ mʋ, mu alibi ɩ kyɔ fʋ lɛɛ gaa.” ");
INSERT INTO naw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Paleti maa nu kanɩn mʋ, o biti ɔkpa mʋ nɩɩ ɔ bɔla yɛgɛ Yesu ɔ natɛ kɩyan. Amaa Gyiwu abi mʋ ba kuusi yɛ, “Fʋ dan kan yɛgɛ nɩɩ ɔnyɩn nɩmʋ natɛ kɩyan bɩrɛ, fʋ man gyɛ Owura lala Kasaro mʋ kyɛmɩnɛ. Kpalɩ fɛɛ ɔkʋmaa mʋ nɩɩ ɛɛ tɩɩ mʋ n‐yɩɩ yɛ ɔ gyɛ owura mʋ, gyɛ Owura lala Kasaro mʋ dʋn nɩn.” ");
INSERT INTO naw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paleti maa nu kanɩn mʋ, ɔ taa Yesu lɩɩ ba kɩlandɛ sʋ, nɩɩ Paleti naa kyɩna kagya mʋ nɩɩ awura bɛɛ kyɩna kɩmʋ tɔ bɛɛ gyii asɩn mʋ. Bɛɛ tɩɩ tʋtɔ yɛ, “Abuu ɔtagakpa.” Gyiwu abi katɔwɛ tɔ bɛɛ tɩɩ kɩmʋ yɛ, “Gabata.” ");
INSERT INTO naw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kanɩn kakɛ maŋa gyɛ kakɛ kʋlasa sa Kesu kɔnɔ Kanyaŋɛ nbunɔ kensi‐gyii mʋ. Lɩɩ ɩ maa fʋʋ kyɔwɛ amu nsana mʋ. Nɩɩ Paleti tɔwɛ Gyiwu abi mʋ yɛ, “Fan kɩɩ fanɛ Owura!” ");
INSERT INTO naw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nɩɩ Gyiwu abi ba kuusi yɛ, “Mɔɔ mʋ, mɔɔ mʋ. Da mʋ mata oyu laasa sʋ mɔɔ.” Nɩɩ ɔ taasɛ bamʋ yɛ, “N mɔɔ fanɛ owura mʋ abɛɛ?” Nɩɩ aseepu bɩlɩsa mʋ ba lɛɛ kɔnɔ yɛ, “A man sʋ owura kʋ tii Owura lala Kasaro sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tʋtɔ maŋa nɩɩ Paleti taa mʋ sa bamʋ yɛ ba naa da mʋ mata oyu laasa sʋ mɔɔ. Ɩmʋ sʋ anaakɔpʋ mʋ ba taa Yesu kyʋn. ");
INSERT INTO naw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nɩɩ Yesu lɩɩ tʋtɔ ɔ kyɛ mʋ oyu laasa naa fʋʋ katɩn mʋ nɩɩ bɛɛ tɩɩ yɛ “Kumu kawɛ opula.” Nɩɩ bɛɛ tɩɩ kɩmʋ Gyiwu abi katɔwɛ tɔ yɛ, “Goligota” mʋ. ");
INSERT INTO naw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tʋtɔ nɩɩ ba da mʋ anyenbi mata oyu laasa sʋ. Nɩɩ ba bɩla da asa nyɔ anyenbi mata iyu laasa sʋ, ɔkʋ bʋ mʋ gyisa sʋ nɩɩ ɔkʋ mɔɔ bʋ mʋ bɩna sʋ. ");
INSERT INTO naw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nɩɩ Paleti yɛgɛ nɩɩ ba kyʋrɔɔ asɩn gyaga kʋtɔ kʋ sʋ naa mata oyu laasa mʋ sʋ yɛ, “YESU KANASARETI‐NYƖN, GYIWU ABI OWURA.” ");
INSERT INTO naw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ba kyʋrɔɔ ɩmʋ Gyiwu abi yɛ Roma abi yɛ Giriki abi ntɔwɛ tɔ, nɩɩ Gyiwu abi gaalaagaa ba kalɛ ɩmʋ, lɩɩ fɛɛ katɩn mʋ nɩɩ ba da mʋ mata oyu laasa sʋ mʋ, man bʋ kata yɛ kadɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nɩɩ Ɩbwaarɛ aseepu bɩlɩsa mʋ ba ba tɔwɛ Paleti yɛ, “Man kyʋrɔɔ yɛ ‘Gyiwu abi Owura’, amaa kyʋrɔɔ yɛ ‘Ɔnyɩn nɩmʋ ɩ tɔwɛ yɛ mʋ ɩ gyɛ Gyiwu abi owura.’ ” ");
INSERT INTO naw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nɩɩ Paleti tɔwɛ bamʋ yɛ, “Kʋtɔ mʋ nɩɩ n dan kyʋrɔɔ mʋ kɩmʋ nɩɩ n kyʋrɔɔ.” ");
INSERT INTO naw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Anaakɔpʋ mʋ ba maa da Yesu mata oyu laasa sʋ lʋwɛ mʋ, ba barɩgɛ mʋ atɔ bunsa mʋ tɔ ntun nna, nɩɩ bamʋ ɔkʋmaa nɩmʋ nyɛ katɩn kʋlʋn. Nɩɩ ɩ san mʋ kaalɛ bʋnswɩɩsa mʋ nɩɩ kɩ man sʋ ɔbaatakpa, nɩɩ ba lʋʋ kɩmʋ lɩɩ sʋsʋ ba yii kasɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nɩɩ anaakɔpʋ mʋ ba tɔwɛ abaa yɛ, “A man kyatɛ kɩmʋ barɩgɛ tɔ. Fan yɛgɛ a tʋʋ kɩmʋ sʋ nbii, kɛ a kɩɩ anɛ tɔ ɔmʋ nɩɩ ee biti o gyii kɩmʋ.” Ba maa waa kanɩn mʋ, ɩ yɛgɛ nɩɩ Asɩnkyan yɩlasa mʋ ɩ ba tɔ kesintin. Ɩmʋ ɩ gyɛ yɛ, “Ba barɩgɛ mɛ atɔ bunsa tɔ sa abaa, nɩɩ ba tʋʋ nbii mɛ kaalɛ bʋnswɩɩsa sʋ.” Ɩmʋ sʋ kanɩn nɩɩ anaakɔpʋ mʋ ba waa. ");
INSERT INTO naw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu mu‐nyi yɛ mʋ nɩkarɛ yɛ Kilopa mʋ‐ka Mɛɛrɩ yɛ Mɛɛrɩ Magidalen ba yɩlɛ Yesu oyu laasa mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu maa wu mu‐nyi yɛ mʋ ɔbɩɩlapʋ mʋ nɩɩ ɔ sʋ kebiti sa mʋ ba maa yɩlɛ tʋtɔ mʋ, ɔ tɔwɛ mu‐nyi yɛ, “Ɔkyɩɩ, fu‐bii ndee.” ");
INSERT INTO naw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nɩɩ ɔ tɔwɛ ɔbɩɩlapʋ mʋ mɔɔ yɛ, “Fɔɔ fʋ, fu‐nyi ndee.” Lɩɩ kanɩn saŋa mʋ, nɩɩ ɔbɩɩlapʋ mʋ taa mʋ naa kyɩna mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Asɩn nɩmʋ kpini kamaa mʋ, Yesu nyi fɛɛ nbɩɩnbɩɩ bɩrɛ kʋtɔ kʋmaa kɩ lʋwɛ, nɩɩ ɔ tɔwɛ yɛ, “Bʋlɩfɔ sʋ mɛ.” Ɔ tɔwɛ ɩnɩmʋ nɩn kɛ Asɩnkyan yɩlasa mʋ ɩ nyɛ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tʋtɔ mʋ, nta nyaŋɛsa ɩ bɔla kɔlɔ‐bi ɩ yɩlɛ, nɩɩ anaakɔpʋ mʋ ba taa ɔkyɛɛ ba nyɔ nta mʋ tɔ, nɩɩ ba taa sɔgɩta hisopi oyu sʋ, nɩɩ ba kʋsaa kɩmʋ naa tii mʋ kɔnɔ. ");
INSERT INTO naw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu maa kyʋkyʋʋ nta mʋ, nɩɩ ɔ tɔwɛ yɛ, “Nbɩɩnbɩɩ bɩrɛ ɩ lʋwɛ.” Nɩɩ ɔ lɛɛ ɔŋɛɛ. ");
INSERT INTO naw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kanɩn kakɛ maŋa kɩ gyɛ kakɛ kʋlasa akɛ sa Kakɛ fʋʋtɛsa. Kakɛ fʋʋtɛsa maŋa maa gyɛ Kakɛ fʋʋtɛsa lala mʋ, nɩɩ Gyiwu abɩlɩsa mʋ be mee biti fɛɛ asa mʋ ba baa ba saa iyu laasa mʋ sʋ naa fʋʋ kakɛ fʋʋtɛsa maŋa. Kanɩn sʋ Gyiwu abɩlɩsa mʋ ba naa kʋlɛ Paleti yɛ ɔ yɛgɛ ba naa gyayɩ‐gyayɩ bamʋ ayaa, kɛ ba wu bilen, kɛ ba nyɛ saatɛ bamʋ lɩɩ iyu laasa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ɩmʋ sʋ anaakɔpʋ mʋ ba ba asa anyɔ mʋ nɩɩ ba da bamʋ mata iyu laasa sʋ tii Yesu sʋ mʋ. Nɩɩ ba gyayɩ ɔgyankpaasa mʋ ayaa yɛ ɔbanban mʋ gbaa lɛɛ. ");
INSERT INTO naw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amaa ba maa fʋʋ Yesu asɛ mʋ, ba wu fɛɛ ɔ tɛɛ wʋla wu, kanɩn sʋ ba man gyayɩ mʋ ayaa. ");
INSERT INTO naw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amaa anaakɔpʋ mʋ tɔ ɔkʋ taa kɩkpɛ yii Yesu kikelebi tɔ. Opula maŋa tɔ nɩɩ nkalan yɛ nkyu ɩ lɩɩ wʋrɩgɛ. ");
INSERT INTO naw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɔmʋ nɩɩ o wu ɩmʋ yɛ ansi ɩ maa waa mʋ, mʋ ii gyii ɩmʋ kesintin, kɛ fan nyɛ kɔɔlɛ gyii. Nɩɩ ɩmʋ nɩɩ ɔ tɔwɛ mʋ ɩ gyɛ kesintin, nɩɩ o nyi fɛɛ mʋ asɩn mʋ gyɛ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɩnɩmʋ ɩ waa nɩn kaapʋ fɛɛ Asɩnkyan yɩlasa mʋ ɩ ba tɔ kesintin. Asɩn mʋ ɩ gyɛ yɛ, “Mu kuwuya kʋlʋn gbaa kɩ mɛɛ yɛ kɩ gya.” ");
INSERT INTO naw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nɩɩ bɩla kyʋrɔɔ yɩla katɩn kʋ gbaa tɔwɛ yɛ, “Asa bee biti ba kɩɩ ɔmʋ nɩɩ ba taa kɩkpɛ yii mʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɩnɩmʋ kamaa tɔ mʋ, ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gyosefu mʋ kpee Paleti asɛ naa kʋlɛ mʋ yɛ, ɔ sa mʋ ɔkpa kɛ ɔ naa saatɛ Yesu kibuni naa pula. Nɩɩ Paleti sa mʋ ɔkpa, nɩɩ o kpee naa taa Yesu kibuni mʋ. Gyosefu maŋa lɩɩ Arimatiya kadɛ tɔ mʋ, nɩɩ ɔ gyɛ Yesu ɔbɩɩlapʋ mʋ tɔ ɔkʋ. Amaa maa sɩlɛ Gyiwu abɩlɩsa sʋ mʋ, ɔ man lɛɛ mʋ n‐yɩɩ ifuli. ");
INSERT INTO naw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Gyosefu maa Nikodemusi mʋ nɩɩ ɔ kyɩna kpee naa wu Yesu kagyanbwɛ kʋ mʋ i kpee. Nikodemusi maŋa bɩya tulale mʋ nɩɩ ba taa mɩɩrɛ yɛ kibondiri waa, nɩɩ ba sʋ ba sʋswa abuni mʋ. Ɩmʋ odu ɩ waa fɛɛ akyembee bɔɔta kʋlʋn. ");
INSERT INTO naw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Anyɩn anyɔ mʋ ba taa Yesu kibuni mʋ, nɩɩ ba taa taafuli mili mʋ, nɩɩ ba bɔ mʋ tulale fɛɛ kanɩn mʋ nɩɩ Gyiwu abi bɛɛ waa bamʋ obuni, pɔyɩ nɩɩ bee pula mʋ. ");
INSERT INTO naw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kadɔɔ‐bi kʋ bʋ tiri katɩn mʋ nɩɩ ba da Yesu anyenbi mata oyu laasa sʋ mʋ. Kanɩn kadɔɔ‐bi maŋa tɔ mʋ, nɩɩ ba lɔŋɔ kakyan kʋ kʋfʋlɛ tɔ yɩla, nɩɩ ba man pɩɩta pula ɔkʋ kɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lɩɩ fɛɛ kanɩn kakɛ maŋa maa gyɛ Gyiwu abi kakɛ kʋlasa sa Kakɛ fʋʋtɛsa sʋ mʋ, nɩɩ kakyan mʋ maa tiri tʋtɔ sʋ mʋ, ba taa Yesu naa pula tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kwasida akɛ kabwaayɩkɛ ɩ maa man pɩɩ ŋmaŋɛ tɔ mʋ, Mɛɛrɩ Magidalen kpee kakyan mʋ asɛ, nɩɩ o wu fɛɛ ba lɛɛ kubuu mʋ nɩɩ ba gbiliti ba tii kɩfʋlɛ tɔ kakyan mʋ kɔnɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ɩmʋ sʋ ɔ sɩlɛ bwii kpee Simon Pita yɛ ɔbɩɩlapʋ banban mʋ nɩɩ Yesu su kebiti sa mʋ mʋ asɛ, naa tɔwɛ yɛ, “Ba taa Ɔnyɩrɩpɛ lɩɩ kakyan mʋ tɔ, nɩɩ a man nyi katɩn mʋ nɩɩ ba taa mʋ naa yɩla.” ");
INSERT INTO naw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ɩmʋ sʋ Pita maa ɔbɩɩlapʋ banban mʋ ba lɩɩ bee kpee kakyan mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nɩɩ bamʋ anyɔ maa kpini ba sɩlɛ kyɛɛkyɛɛ bee kpee, amaa ɔbɩɩlapʋ banban mʋ sɩlɛ kyʋn Pita sʋ gyankpaa naa fʋʋ kakyan mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nɩɩ o muŋa kɩɩ kakyan mʋ tɔ, nɩɩ o wu taafuli maa dɛ tɔ, amaa ɔ man loo to. ");
INSERT INTO naw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nɩɩ Simon Pita ba kamaa tɔ, nɩɩ o loo kakyan mʋ tɔ, nɩɩ o wu taafuli maa dɛ tʋtɔ, ");
INSERT INTO naw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","yɛ kikyibi fufuli mʋ nɩɩ ba taa ŋmina mu kumu mʋ. Kikyibi mʋ kɩ bɔɔ kɩ dɛ kɩmʋ kʋkwɛ. ");
INSERT INTO naw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ɔbɩɩlapʋ mʋ nɩɩ ɔ gyankpaa fʋʋ tʋtɔ gbaa maa loo to nɩɩ o wu ɩmʋ mʋ, ɔ kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ba san ba man pɩɩta nu Asɩnkyan yɩlasa mʋ kasɛ fɛɛ Yesu dagaa maa kyiŋi lɩɩ lewu tɔ. ");
INSERT INTO naw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nɩɩ abɩɩlapʋ mʋ ba bwii kpee bamʋ akpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Amaa Mɛɛrɩ bɩrɛ ɔ yɩlɛ kakyan mʋ asɛ ee su. Maa yɩlɛ ee su mʋ, nɩɩ o muŋa suŋa kɩɩ kakyan mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nɩɩ o wu Ɩbwaarɛ nbɔɔ anyɔ yɛgɛ ba bun atɔ fufuli, ba maa tɛ katɩn mʋ nɩɩ ba daa taa Yesu kibuni yɩla mʋ, ɔkʋ tɛ mu amu sʋ nɩɩ ɔkʋ mɔɔ tɛ mʋ ayaa kasɛ. ");
INSERT INTO naw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ba taasɛ mʋ yɛ, “Ɔkyɩɩ, mɩnɛ waa nɩɩ fii su?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ba taa mɛ‐Nyɩrɩpɛ kyʋn, nɩɩ n man nyi katɩn mʋ nɩɩ ba taa mʋ naa yɩla.” ");
INSERT INTO naw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɩnɩmʋ kamaa mʋ, ɔ gbɛɛ kɩɩ nɩɩ o wu Yesu maa yɩlɛ tʋtɔ, amaa ɔ man bɩɩ yɛ Yesu nɩn. ");
INSERT INTO naw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nɩɩ Yesu taasɛ mʋ yɛ, “Ɔkyɩɩ, mɩnɛ ɩ waa nɩɩ fii su? Anɩmʋ nɩɩ fii biti?” Mɛɛrɩ maa fɛ nfɛɛrɛ fɛɛ ɔ gyɛ kʋdɔɔ mʋ ɔkɩɩsʋpʋ mʋ, ɔ lɛɛ kɔnɔ yɛ, “Ɔbɩlɩsa, nɩɩ ɩ gyɛ fʋ ɩ kan taa mʋ mʋ, tɔwɛ mɛ katɩn mʋ nɩɩ fʋ taa mʋ naa yɩla kɛ n naa taa mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu tɩɩ mʋ yɛ, “Mɛɛrɩ!” Maa biliŋi kɩɩ mʋ, o kuusi tɔwɛ Hibriwu katɔwɛ tɔ yɛ, “Raboni!” (kɩmʋ kasɛ ɩ gyɛ yɛ ɔkaapʋpʋ). ");
INSERT INTO naw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu tɔwɛ mʋ yɛ, “Man mata mɛ, lɩɩ fɛɛ n man pɩɩta bwii kpee Mɛ‐Sɛ mʋ asɛ. Amaa kpee mi abuupu mʋ asɛ naa tɔwɛ bamʋ yɛ, n bwii n kpee Mɛ‐Sɛ mʋ nɩɩ ɔ gyɛ fanɛ‐Sɛ, yɛ mɛ Ɩbwaarɛ mʋ nɩɩ ɔ gyɛ fanɛ Ɩbwaarɛ mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nɩɩ Mɛɛrɩ Magidalen bwii kpee abɩɩlapʋ mʋ asɛ naa tɔwɛ bamʋ yɛ, “N wu Ɔnyɩrɩpɛ mʋ”! Nɩɩ ɔ tɔwɛ bamʋ asɩn mʋ nɩɩ Ɔnyɩrɩpɛ tɔwɛ mʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kwasida maŋa kalaatɩpwɛ sʋ mʋ, abɩɩlapʋ mʋ ba bʋ obu to, nɩɩ ba tii ɔpʋnʋ mʋ biri bamʋ n‐yɩɩ sʋ waa tɔ, lɩɩ ba maa sɩlɛ Gyiwu abɩlɩsa mʋ sʋ. Nɩɩ Yesu ba yɩlɛ bamʋ nsana, nɩɩ ɔ fwaala bamʋ yɛ, “Kayɩɩ yuuli kɩ ba fanɛ asɛ!” ");
INSERT INTO naw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ, nɩɩ ɔ taa mʋ abaa yɛ mu kikelebi kaapʋ bamʋ. Nɩɩ abɩɩlapʋ mu ansi i gyii fɛɛ ba maa wu Ɔnyɩrɩpɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nɩɩ Yesu bɩla tɔwɛ bamʋ yɛ, “Kayɩɩ yuuli kɩ ba fanɛ asɛ. Fɛɛ kanan mʋ nɩɩ Mɛ‐Sɛ sun mɛ mʋ, kanɩn maŋa nɩɩ ngbaa mɛ n sun fanɛ.” ");
INSERT INTO naw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nɩɩ ɔ fʋʋtɛ bun bamʋ, nɩɩ ɔ tɔwɛ yɛ, “Fan kɔɔlɛ Kayaayu Kyɩrɛkyɩrɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nɩɩ fan kan taa ɔkʋ alibi kɛɛ mʋ mʋ, Ɩbwaarɛ gbaa ii biti ɔ taa mu alibi kɛɛ mʋ, nɩɩ ɔkʋmaa mʋ nɩɩ fan man kan taa mu alibi kɛɛ mʋ mʋ, Ɩbwaarɛ gbaa mɛɛ yɛ ɔ taa mu alibi kɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi mʋ nɩɩ ɔ gyɛ abɩɩlapʋ kudu anyɔ mʋ tɔ ɔkʋ, nɩɩ ɔ gyɛ Kabwaarabi mʋ, ɔ man bʋ abɩɩlapʋ mʋ asɛ saŋa mʋ nɩɩ Yesu ba bamʋ asɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ɩmʋ sʋ abɩɩlapʋ banban mʋ ba tɔwɛ mʋ yɛ, “An wu Ɔnyɩrɩpɛ mʋ.” Amaa ɔ tɔwɛ bamʋ yɛ, “Nɩɩ n man kan wu anyenbi alɔpanɛ mʋ abaa tɔ, kɛ n taa mɛ kɩbaa‐bi yii ɩmʋ tɔ, kɛ n taa mɛ kɩbaa yii mʋ kikelebi tɔ mʋ, n mɛɛ yɛ n kɔɔlɛ gyii.” ");
INSERT INTO naw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ɩmʋ nkɛ nsunɔ kamaa mʋ, abɩɩlapʋ mʋ ba bɩla ba bʋ kɩkpaara mʋ sʋ, yɛgɛ Tomasi bʋ bamʋ asɛ. Ba tii bamʋ n‐yɩɩ sʋ biri sʋ waa obu to. Ba ba kɩɩ mʋ, Yesu ba yɩlɛ bamʋ nsana, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Kayɩɩ yuula ɩ ba fanɛ sʋ!” ");
INSERT INTO naw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nɩɩ Yesu tɔwɛ Tomasi yɛ, “Taa fʋ kɩbaa‐bi yii nfɩɩ, kɛ fʋ kɩɩ mɛ abaa tɔ. Tɛɛŋɛ fʋ kɩbaa yii mɛ kikelebi tɔ. Yɛgɛ sika‐sika kɩwaa kɛ fʋ kɔɔlɛ gyii.” ");
INSERT INTO naw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nɩɩ Tomasi tɔwɛ yɛ, “Fʋ ɩ gyɛ mɛ‐Nyɩrɩpɛ yɛ mɛ Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nɩɩ Yesu tɔwɛ mʋ yɛ, “Tomasi, fʋ maa wu mɛ sʋ nɩɩ fʋ kɔɔlɛ gyii? Kusee ɩ gyɛ sa bamʋ nɩɩ ba man wu mɛ nɩɩ ba kɔɔlɛ gyii.” ");
INSERT INTO naw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu waa ɩsɩnkaala gaalaagaa abɩɩlapʋ mu ansi tɔ, mʋ nɩɩ ba man kyʋrɔɔ ɩmʋ waa ɔwʋlɛ nɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amaa ba kyʋrɔɔ ɩnɩmʋ nɩn, kɛ fan nyɛ kɔɔlɛ gyii fɛɛ Yesu ɩ gyɛ Krisito, Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ, nɩɩ ɔ gyɛ Mu‐Bii mʋ. Nɩɩ fan kan kɔɔlɛ mʋ gyii mʋ, fen biti fan nyɛ nkpa. ");
INSERT INTO naw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ɩnɩmʋ kamaa mʋ, Yesu bɩla lɛɛ mʋ n‐yɩɩ kaapʋ mʋ abɩɩlapʋ ɔbʋn lala mʋ nɩɩ bɛɛ tɩɩ yɛ Tiberiya mʋ kɔnɔ. Falɛ nɩɩ ɩ ba. ");
INSERT INTO naw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kakaakʋ abɩɩlapʋ mʋ akʋ ba baa ba bʋ katɩn kʋlʋn. Bamʋ ɩ gyɛ Simon Pita maa Tomasi mʋ nɩɩ bɛɛ tɩɩ mʋ Kabwaarabi mʋ, yɛ Nataneli mʋ nɩɩ ɔ lɩɩ Kena, yɛ Sebedi mu‐bii ana anyɔ yɛ abɩɩlapʋ anyɔ akʋ. ");
INSERT INTO naw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nɩɩ Simon Pita tɔwɛ bamʋ yɛ, “N kpee n naa kɩtaa ɩkɩn.” Nɩɩ ngbaa bamʋ ba tɔwɛ mʋ yɛ, “An biti a buu fʋ kpee.” Nɩɩ bamʋ kpini ba naa loo ɔkʋlɩ tɔ, amaa kanɩn kagyanbwɛ maŋa ba man kɩtaa sɛhn. ");
INSERT INTO naw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kayɩ maa kɛ nyenyenfuu mʋ, Yesu ba nɩɩ ɔ yɩlɛ ɔlɩɩkaa, amaa abɩɩlapʋ mʋ ba man bɩɩ yɛ mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nɩɩ ɔ tɩɩ bamʋ yɛ, “Mɛ kyɛmɩnɛ ana, fan man kɩtaa ɩkɩn?” Nɩɩ ba lɛɛ mʋ kɔnɔ yɛ, “Ayee, a man kɩtaa sɛhn.” ");
INSERT INTO naw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan tʋʋ fanɛ kisewu mʋ ɔkʋlɩ mʋ gyisa sʋ, fen biti fan nyɛ akʋ kɩtaa.” Ba maa tʋʋ kisewu mʋ, ba kɩtaa ɩkɩn damantɛ, halɩɩ ba man taalɛ bɩɩtɛ kisewu mʋ waa ɔkʋlɩ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tʋtɔ nɩɩ ɔbɩɩlapʋ mʋ nɩɩ Yesu ii biti mʋ asɩn gaa mʋ tɔwɛ Pita yɛ, “Ɔnyɩrɩpɛ nɩn.” Simon maa nu yɛ Ɔnyɩrɩpɛ mʋ, nɩɩ ɔ taa mʋ kaalɛ lala mʋ nɩɩ ɔ wʋla lɛɛ yɩla mʋ bun, nɩɩ ɔ kpɩlɩgɛ loo nkyu mʋ tɔ ba kidenbi sʋ. ");
INSERT INTO naw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nɩɩ abɩɩlapʋ asansa mʋ ba palɛ ɔkʋlɩ mʋ buu mʋ, yɛgɛ bɛɛ bɩɩtɛ kisewu mʋ yɛ ɩkɩn mʋ nɩɩ ba bʋ kɩmʋ tɔ mʋ, lɩɩ fɛɛ ba maa kebunɔ mʋ ba man bʋ kata. Ɩmʋ kata ɩ waa fɛɛ abaa nswɩɩ tɔ adunuu. ");
INSERT INTO naw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ba maa dan mʋ, ba wu ɔkɩn maa gyan afʋlɔn‐gyi sʋ yɛgɛ bodobodo dɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Fan taa ɩkɩn mʋ nɩɩ fan dan kɩtaa mʋ akʋ ba.” ");
INSERT INTO naw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tʋtɔ nɩɩ Simon Pita loo ɔkʋlɩ mʋ tɔ, nɩɩ ɔ bɩɩtɛ kisewu mʋ ba kidenbi sʋ. Ɩkɩn lala mʋ nɩɩ ba bɔla kɩmʋ mʋ ba gyɛ kɩlɩfa kʋlʋn yɛ adunuu yɛ asa, amaa halɩɩ ɩkɩn damantɛ mʋ nɩɩ ba bɔla kɩmʋ falɛ gbaa mʋ kisewu mʋ kɩ man kyatɛ. ");
INSERT INTO naw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu tɔwɛ bamʋ yɛ, “Fan ba biri kɔnɔ.” Amaa abɩɩlapʋ mʋ ɔkʋ man taalɛ nyɛ kɔkɔlɔ taasɛ mʋ yɛ, “Fʋ ɩ gyɛ anɩmʋ?” Yɛgɛ be nyi yɛ Ɔnyɩrɩpɛ mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nɩɩ Yesu naa taa bodobodo mʋ sa bamʋ, nɩɩ kanɩn gbaa nɩɩ ɔ taa ɔkɩn mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu maa kyiŋi lɩɩ lewu tɔ mʋ, kɩnɩmʋ ɩ gyɛ kɩsasapʋ maa lɛɛ mʋ n‐yɩɩ kaapʋ mʋ abɩɩlapʋ. ");
INSERT INTO naw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ba maa biri kɔnɔ lʋwɛ mʋ, Yesu taasɛ Simon Pita yɛ, “Simon, Gyɔn mu‐bii, fii biti mɛ fʋ kyɔ kanan mʋ nɩɩ banɩmʋ bee biti mɛ mʋ?” Nɩɩ Pita lɛɛ kɔnɔ yɛ, “Ɛɛhn Ɔnyɩrɩpɛ, fu nyi n maa sʋ kebiti sa fʋ.” Nɩɩ Yesu tɔwɛ mʋ yɛ, “Sa mɛ nbʋlʋpʋ‐bi mʋ agyitɔ.” ");
INSERT INTO naw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nɩɩ Yesu bɩla taasɛ mʋ kɩnyɔsapʋ yɛ, “Simon, Gyɔn mu‐bii, fʋ sʋ kebiti sa mɛ?” Nɩɩ Simon lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, fu nyi n maa sʋ kebiti sa fʋ.” Nɩɩ Yesu tɔwɛ mʋ yɛ, “Kɩɩ mɛ nbʋlʋpʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nɩɩ Yesu taasɛ mʋ kɩlɩɩ sasapʋ yɛ, “Simon, Gyɔn mu‐bii, fʋ sʋ kebiti sa mɛ?” Nɩɩ ɩ tɔɔrɔɔ Pita fɛɛ Yesu maa taasɛ mʋ ɩlɩɩ ɩsa yɛ, “Fʋ sʋ kebiti sa mɛ.” Nɩɩ Pita tɔwɛ yɛ, “Ɔnyɩrɩpɛ, fu nyi kʋtɔ kʋmaa, fu nyi n maa sʋ kebiti sa fʋ.” Nɩɩ Yesu tɔwɛ mʋ yɛ, “Sa mɛ nbʋlʋpʋ mʋ agyitɔ. ");
INSERT INTO naw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","N tɔwɛ fʋ kesintin, saŋa mʋ nɩɩ fʋ gyɛ kɩyaafɔlɛ mʋ, fii bun fʋ atɔ bunsa, nɩɩ fii kpee katɩn kʋmaa mʋ nɩɩ fii biti, amaa fʋ ba waa kɩnyɩn bɩlɩsa mʋ, fɩɩ tɛɛŋɛ fʋ abaa tɔ kɛ ɔkʋ o bun fʋ, kɛ ɔ taa fʋ kpee katɩn mʋ nɩɩ fii mee biti.” ");
INSERT INTO naw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu tɔwɛ ɩnɩmʋ nɩn kaapʋ lewu mʋ nɩɩ Pita ii biti o be wu mu kedubi, kɛ ɩ lɛɛ Ɩbwaarɛ bʋnyaa kaapʋ. Yesu maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Buu mɛ!” ");
INSERT INTO naw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita maa biliŋi mu ansi kɩɩ mʋ, o wu fɛɛ ɔbɩɩlapʋ mʋ nɩɩ Yesu sʋ kebiti sa mʋ mʋ, buu bamʋ. Mʋ ɩ gyɛ ɔmʋ nɩɩ ɔ tɛ ɔ kpɛɛ Yesu saŋa mʋ nɩɩ bee gyii kalaatɩpwɛ sʋ agyitɔ mʋ, nɩɩ ɔ taasɛ Yesu yɛ, “Ɔnyɩrɩpɛ, anɩmʋ ii biti ɔ lɛɛ fʋ sa mʋ?” ");
INSERT INTO naw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita maa wu mʋ mʋ nɩɩ ɔ taasɛ yɛ, “Ɔnyɩrɩpɛ, ɔnɩmʋ mɔɔ de?” ");
INSERT INTO naw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nɩɩ Yesu lɛɛ kɔnɔ yɛ, “Nɩɩ n kan n biti yɛ ɔ baa ɔ tɛ nkpa tɔ naa fʋʋ saŋa mʋ nɩɩ n biti n bwii ba mʋ, ɩ gyɛ fʋ asɩn? Fɛɛ fʋ buu mɛ.” ");
INSERT INTO naw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lɩɩ falɛ sʋ mʋ, asɩn nɩmʋ a yaasɛ tɔ loo kpee Krisito abuupu kpini asɛ fɛɛ, ɔbɩɩlapʋ nɩmʋ man bʋ tɔ o wu. Amaa Yesu man tɔwɛ yɛ ɔ mɛɛ yɛ o wu. Asɩn mʋ nɩɩ ɔ tɔwɛ ɩ gyɛ yɛ, “Nɩɩ n kan n biti yɛ ɔ baa ɔ tɛ nkpa tɔ naa fʋʋ saŋa mʋ mʋ nɩɩ n biti n bwii ba mʋ, ɩ gyɛ fʋ asɩn?” ");
INSERT INTO naw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ɔbɩɩlapʋ nɩmʋ ɩ gyɛ mʋ nɩɩ ee gyii asɩn nɩmʋ kesintin, nɩɩ mʋ ɩ kyʋrɔɔ ɩmʋ yɩla. Nɩɩ an nyi fɛɛ ɩmʋ nɩɩ ɔ tɔwɛ mʋ gyɛ kesintin. ");
INSERT INTO naw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu waa atɔ gaalaagaa tii sʋ. Nɩɩ ba daa kyʋrɔɔ ɩmʋ kpini yɩla nɩn, naafɔɔ ɩwʋlɛ mʋ ii biti i tiri dulinyaa tɔ, nɩɩ ɩ mɛɛ yɛ ɩ nyɛ opula yɩlakpa.");
INSERT INTO naw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ɔwʋlɛ nɩmʋ lɩɩ mɛ Luka asɛ kɩ ba fʋ Tiyofilosi asɛ. Mɛ ɔwʋlɛ gyankpaasa mʋ tɔ mʋ, n kyʋrɔɔ atɔ mʋ nɩɩ Yesu kaapʋ nɩɩ ɔ waa mʋ kpini, lɩɩ saŋa mʋ nɩɩ o yii mu kusun kasɛ mʋ, ");
INSERT INTO naw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","naa fʋʋ kakɛ mʋ nɩɩ Ɩbwaarɛ taa mʋ kyʋn sʋsʋ mʋ. Pɔyɩ kɛ ɔ taa mʋ kpee sʋsʋ mʋ, Ɔnyɩrɩpɛ Yesu bɔla Kayaayu Kyɩrɛkyɩrɛ mʋ sʋ kaapʋ mu asunpu mʋ nɩɩ ɔ lɛɛ bamʋ mʋ, atɔ mʋ nɩɩ ba waa. ");
INSERT INTO naw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu kelewu kamaa nkɛ adɩna mʋ tɔ mʋ, ɔ lɛɛ mʋ n‐yɩɩ kaapʋ mu asunpu fɛɛ ɔ tɛ nkpa tɔ, nɩɩ ɩ man sʋ kamɔɔrɛ‐gyii. Nɩɩ ɔ tɔwɛ sʋsʋ kuwura‐gyii mʋ asɩn. ");
INSERT INTO naw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Maa bamʋ ba maa nsarɛ bee gyii kakaakʋ mʋ, ɔ sa bamʋ kɔnɔ yɛ, “Fan man kan waa lɩɩ Gyerusalem, amaa fan gyoo fanɛ kɛkɛɛ mʋ nɩɩ n wʋla tɔwɛ fanɛ yɛ, Nsɛ da mʋ kɔkɔlɔ sʋ yɛ ee biti ɔ sa fanɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nkyu nɩɩ Gyɔn sʋ ee gyee fanɛ Ɩbwaarɛ kekyugyee, amaa nkɛ gbɛrɛɛ mʋ nɩɩ ii biti ɩ ba falɛ tɔ mʋ, Ɩbwaarɛ ii biti ɔ taa mʋ Kayaayu Kyɩrɛkyɩrɛ mʋ gyee fanɛ.” ");
INSERT INTO naw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Saŋa mʋ nɩɩ asunpu mʋ ba maa Yesu ba bwii sarɛ mʋ, ba taasɛ mʋ yɛ, “Ɔnyɩrɩpɛ, nbɩɩnbɩɩ nɩɩ fii biti fu bwii taa kuwura‐gyii mʋ sa anɛ Ɩsɩrayɩ abi abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nɩɩ Yesu tɔwɛ bamʋ yɛ, “Saŋa abɛɛ kakɛ yɛ mʋ awaasa mʋ kpini mʋ, mɛ‐Sɛ ɩ yɩla ɩmʋ lɩɩ mʋ ɔlʋn tɔ sʋ, ɩmʋ sʋ ɩ man tiri fɛɛ fan bɩɩ saŋa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amaa nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ kan ba fanɛ sʋ mʋ, fen biti fan nyɛ ɔlʋn kɛ fan naa tɔwɛ mɛ asɩn mʋ Gyerusalem tɔ yɛ Gyudeya kpini yɛ Samariya tɔ, taa naa fʋʋ dulinyaa ɔkaa.” ");
INSERT INTO naw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Maa tɔwɛ ɩ nɩmʋ kamaa mʋ, Ɩbwaarɛ taa mʋ kpee sʋsʋ bamʋ ansi tɔ, nɩɩ abwaarɛ‐wʋlɛ a bun mʋ sʋ lɩɩ bamʋ ansi sʋ. ");
INSERT INTO naw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Saŋa mʋ nɩɩ ɩ sʋ mʋ ii kpee yɛgɛ bɛɛ kɩɩ sʋsʋ haa mʋ, opula maŋa tɔ nɩɩ anyɩn anyɔ akʋ mʋ nɩɩ ba bun atɔ fufuli ba ba yɩlɛ bamʋ asɛ, ");
INSERT INTO naw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","nɩɩ ba taasɛ bamʋ yɛ, “Galile abi, mɩnɛ ɩ waa nɩɩ fan yɩlɛ nfɩɩ fɛn kɩɩ abwaarɛ‐wʋlɛ tɔ kanɩn? Yesu mʋ nɩɩ Ɩbwaarɛ taa mʋ lɩɩ fanɛ asɛ kpee sʋsʋ mʋ, kanɩn nɩɩ ee biti o bwii ba fɛɛ kanan mʋ nɩɩ fan kɩɩ mʋ maa kpee sʋsʋ falɛ.” ");
INSERT INTO naw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tʋtɔ nɩɩ asunpu mʋ ba lɩɩ Olifu kɩbɩɩ mʋ asɛ bwii ba Gyerusalem, ɩ man bʋ kata kpini‐kpini. ");
INSERT INTO naw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba maa loo Gyerusalem kadɛ mʋ tɔ mʋ, ba dii naa loo abansʋrʋ obu, mʋ nɩɩ ba wʋla ba bʋ kɩmʋ tɔ mʋ. Asunpu mʋ ɩ gyɛ Pita maa Gyɔn, yɛ Gyemisi yɛ Andiruwu yɛ Filipu yɛ Tomasi yɛ Batolome yɛ Matiwu yɛ Alifeyo mu‐bii Gyemisi maa Simon Seloti mʋ nɩɩ ɔ gyɛ bamʋ nɩɩ ba kɔ bee kun bamʋ ɔsʋwʋlɛ mʋ bamʋ ɔkʋ, yɛ Gyemisi mu‐bii Gyudasi. ");
INSERT INTO naw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bamʋ kpini ba taalɛ ba bʋga saŋa kʋmaa yɛ akyɩɩ akʋ yɛ Yesu mu‐nyi yɛ mu‐supu ana. ");
INSERT INTO naw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nkɛ nfɩnɛ nkʋ kamaa tɔ mʋ, nɩɩ Krisito akɔɔlɛ‐gyipu bɛɛ waa fɛɛ asa kɩlɩfa yɛ adʋnyɔ ba ba sarɛ, nɩɩ Pita kʋsʋ yɩlɛ, ");
INSERT INTO naw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","nɩɩ o yii kasɛ yɛ, “Mɛ‐daa ana yɛ mi‐supu ana, asɩn mʋ nɩɩ Kayaayu Kyɩrɛkyɩrɛ bɔla owura Dawidi sʋ wʋla tɔwɛ yɩla yɛ Gyudasi ii biti ɔ gyankpaa kɛ ba kɩtaa Yesu mʋ, ɩ dagaa ɩ ba kanɩn. ");
INSERT INTO naw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Gyudasi kyɩna ɔ gyɛ anɛ kʋbʋ kudu‐anyɔ mʋ tɔ ɔkʋ nɩn, nɩɩ ɔ sʋ ɔyɩlɛkpa kusun mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Afulee mʋ nɩɩ Gyudasi nyɛ lɩɩ mu alibi mʋ nɩɩ ɔ waa sʋ mʋ, ɔ sɔɔ kasɛ, katɩn mʋ nɩɩ ɔ tɩyɛ ketulaamu nɩɩ o wu, ɔ patɩyɛ nɩɩ mʋ ipuni kpini ɩ patɩyɛ lɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Gyerusalem abi kpini ba nu asɩn nɩmʋ. Ɩmʋ sʋ ba yɩla ɔsʋwʋlɛ mʋ kɩtɩɩ bamʋ katɔwɛ tɔ yɛ Akeledama, kasɛ ɩ gyɛ yɛ, ‘Nkalan kasɛ.’ ” ");
INSERT INTO naw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nɩɩ Pita tɔwɛ yɛ owura Dawidi wʋla kyʋrɔɔ Gyudasi asɩn waa Asɩnkyan yɩlasa mʋ tɔ yɛ, “Mʋ kɩkpaara ki biliŋi kɩtakpan, kɛ ɔkʋ ɔ man kyɩna kɩmʋ tɔ.” Nɩɩ Dawidi bɩla tɔwɛ yɛ, “Ba yɛgɛ kɛ ɔkʋ o yii mu kusun kɩbɩlɩsa mʋ ayaa tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ɩmʋ sʋ ɩ dagaa fɛɛ a lɛɛ anɛ asa mʋ tɔ ɔkʋ ba tii anɛ sʋ. An biti ɔmʋ nɩɩ ɔ wʋla ɔ bʋ anɛ asɛ saŋa mʋ nɩɩ anaa Ɔnyɩrɩpɛ Yesu an dii an kpɩlɩgɛ mʋ, ");
INSERT INTO naw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","lɩɩ saŋa mʋ nɩɩ Gyɔn okyugyeepu gyee asa Ɩbwaarɛ kekyugyee, naa fʋʋ saŋa mʋ nɩɩ Ɩbwaarɛ taa Yesu kpee sʋsʋ. Ɩ dagaa fɛɛ kanɩn asa maŋa tɔ ɔkʋ maa tii anɛ sʋ fɛɛ Ɔnyɩrɩpɛ Yesu kelewu kyiŋi kesintin ogyipu. ");
INSERT INTO naw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ɩmʋ sʋ ba lɛɛ asa anyɔ yɛ ba yɩlɛ. Bamʋ ɩ gyɛ Gyosefu mʋ nɩɩ bɛ tɩɩ mʋ yɛ Basabasi, nɩɩ ba bɩla bɛɛ tɩɩ mʋ Gyusitu, nɩɩ ɔbanban mʋ mɔɔ gyɛ Matiyasi. ");
INSERT INTO naw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tʋtɔ nɩɩ ba kʋlɛ kabwaarɛ‐kʋlɛ yɛ, “Ɔnyɩrɩpɛ, fu nyi ɔkʋmaa nɩmʋ kɔkɔlɔ tɔ. Ɩmʋ sʋ fii biti fʋ kaapʋ anɛ asa anyɔ anɩmʋ tɔ ɔmʋ nɩɩ fʋ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Kɛ ɔ ba waa fu asunpu mʋ kusun mʋ nɩɩ Gyudasi yɛgɛ yɩla mʋ, kpee katɩn mʋ nɩɩ ɩ dagaa mʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nɩɩ ba tʋʋ nbii biti ɔmʋ nɩɩ ɔ ba tii bamʋ sʋ, nɩɩ Matiyasi gyii, nɩɩ ba taa mʋ tii bamʋ asunpu kudu‐ɔkʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Saŋa mʋ nɩɩ Gyiwu abi Pentekosi kakɛ gyisa maa fʋʋ mʋ, Krisito akɔɔlɛ‐gyipu mʋ kpini ba ba sarɛ opula kʋlʋn. ");
INSERT INTO naw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Opula tɔ nɩɩ ɩlawʋ ɩkʋ ɩ lɩɩ abwaarɛ‐wʋlɛ tɔ a maa kpira fɛɛ afuu bʋlʋnsa akʋ a maa da ba loo kɩkpaara mʋ nɩɩ ba tɛ kɩmʋ sʋ mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tʋtɔ nɩɩ ba wu atɔ kʋ fɛɛ fʋlɔn anobi a maa yaasɛ ba gyaga ɔsa kʋmaa mʋ nɩɩ ɔ bʋ tʋtɔ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ bɔla bamʋ kpini tɔ, nɩɩ bamʋ ɔkʋmaa nɩmʋ yii kasɛ ɛɛ tɔwɛ katɔwɛ pʋpwɛ fɛɛ kanan mʋ nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ kɩ sa bamʋ yɛ ba tɔwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Saŋa maŋa tɔ mʋ Gyiwu abi akʋ mʋ nɩɩ be sun Ɩbwaarɛ mʋ, ba lɩɩ dulinyaa tɔ ɩsʋwʋlɛ kpini sʋ ba baa ba bʋ Gyerusalem tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ba maa kanan ɩlawʋ maŋa mʋ, nɩɩ kʋbʋ damantɛ kʋkʋ kɩ sarɛ. Ɩ waa ɔkʋmaa nɩmʋ kɩyan, kpalɩ fɛɛ bamʋ ɔkʋmaa nɩmʋ nu akɔɔlɛ‐gyipu mʋ kpini ba maa tɔwɛ asa mʋ bamʋ tɔ ɔkʋmaa nɩmʋ kadɛ tɔwɛsa. ");
INSERT INTO naw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɩ waa bamʋ kanankʋ, nɩɩ ba taasɛ yɛ, “Asa mʋ nɩɩ bɛɛ tɔwɛ falɛ mʋ, ba man gyɛ Galile abi nɩn abɛɛ? ");
INSERT INTO naw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ɩ waa nɛnɛ sʋ nɩɩ anɛ kpini an nu ba maa tɔwɛ anɛ ntɔwɛ nusa? ");
INSERT INTO naw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Anɛ kpini an lɩɩ‐lɩɩ ndɛ kʋkwɩɩ‐kʋkwɩɩ fɛɛ, Patiya yɛ Medeya yɛ Elam yɛ Mesopotamiya yɛ Gyudeya yɛ Kapadosiya yɛ Pontisi yɛ Asiya yɛ ");
INSERT INTO naw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firigiya yɛ Panfiliya yɛ Egyipiti yɛ Libiya kɩbaafʋn mʋ nɩɩ kɩ bʋ ki tiri Sereni, nɩɩ Gyiwu abi yɛ asa mʋ nɩɩ ba biliŋi Gyiwu abi, nɩɩ bamʋ kpini ba lɩɩ Roma mʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Anɛ akʋ an lɩɩ Kereti nɩɩ anɛ akʋ mɔɔ an lɩɩ Arabiki. Anɛ kpini an nu asa anɩmʋ ntɔwɛ tɔ ba maa tɔwɛ asɩn kyinkyinsa mʋ nɩɩ Ɩbwaarɛ waa.” ");
INSERT INTO naw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɩ maa waa bamʋ kɩyan nɩɩ ɩ kɩtaa bamʋ nfɛɛrɛ mʋ, nɩɩ bɛ taasɛ abaa yɛ, “Mɩnɛ nɩɩ ɩnɩmʋ kasɛ ɩɩ kaapʋ?” ");
INSERT INTO naw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amaa yɛgɛ akʋ mɔɔ be keesi akɔɔlɛ‐gyipu mʋ bɛɛ tɔwɛ yɛ, “Asa maŋa ba bʋʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tʋtɔ nɩɩ Pita maa asunpu kudu‐ɔkʋ bambam mʋ, ba kʋsʋ yɩlɛ nɩɩ Pita diyaa mʋ ɔbʋlɛ sʋsʋ kenken ɔ tɔwɛ ɛɛ sa kʋbʋ mʋ yɛ, “Mɛ tɔmaa ana Gyiwu abi yɛ ɔsa kʋmaa mʋ nɩɩ ɔ tɛ Gyerusalem mʋ kpini, fan kan fanɛ asʋ kɛ n lɛɛ ɩnɩmʋ kasɛ sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Asa anɩmʋ ba man bʋʋ nɩn, fɛɛ kanan mʋ nɩɩ fan fɛ bamʋ nfɛɛrɛ falɛ, ɩ dan san ɩ gyɛ kerefi akpanɔ nyanyan nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Amaa ɩmʋ nɩɩ ɩ ba falɛ ɩ gyɛ kʋtɔ mʋ nɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Gyoweli wʋla tɔwɛ ɩmʋ asɩn yɛ, ");
INSERT INTO naw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ɩbwaarɛ tɔwɛ yɩla yɛ nkɛ laalaalʋwɛ mʋ, n biti n yɛgɛ mɛ Kayaayu Kyɩrɛkyɩrɛ mʋ ɔ ba asa kpini sʋ. N biti n bɔla fanɛ nbii‐nyɩnsa yɛ akyɩɩsa sʋ kɛ n tɔwɛ asɩn. Fanɛ ayaafɔlɛ bee biti be wu ansi sʋ kɩlɛɛkaapʋ, kɛ fanɛ anyɩn bɩlɩsa bɛ kɔɔ idee. ");
INSERT INTO naw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kakɛ laalaalʋwɛ mʋ n biti n yɛgɛ mɛ Kayaayu Kyɩrɛkyɩrɛ mʋ ɔ sa fanɛ ayaafɔlɛ yɛ abite kɛ ba tɔwɛ mɛ asɩn. ");
INSERT INTO naw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","N biti n waa asɩn kyinkyinsa sʋsʋ, kɛ n waa ɩsɩnkaala kasɛ sʋ. Nkalan yɛ fʋlɔn yɛ idiisii ii biti ɩ waa kudu‐kudu. ");
INSERT INTO naw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kyɔwɛ ii biti o biliŋi kitentenbiri, kɛ ɔbwaayɩ ɔ payɩ fɛɛ nkalan, pɔyɩ kɛ Ɔnyɩrɩpɛ kakɛ bʋnyaa lala mʋ kɩ ba. ");
INSERT INTO naw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nɩɩ ɔkʋmaa mʋ nɩɩ ɔ tɩɩ Ɔnyɩrɩpɛ Ɩbwaarɛ kɩtɩɩ mʋ, ee biti ɔ mɔlɩgɛ mʋ.’ ");
INSERT INTO naw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mɛ asa Ɩsɩrayɩ abi fan bɩla nu asɩn nɩmʋ, Ɩbwaarɛ lɛɛ Yesu mʋ nɩɩ ɔ gyɛ Kanasareti‐nyɩn yɛgɛ nɩɩ ɔ waa asɩn kyinkyinsa yɛ ɩsɩnkaala yɛ adangana nɩɩ ɩ kaapʋ tɔ fɛɛ Ɩbwaarɛ i sun mʋ. Nɩɩ fanɛ kpini fen nyi ɩmʋ nɩɩ ɔ waa falɛ. ");
INSERT INTO naw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɩbwaarɛ mʋ nɩɩ o nyi kʋtɔ kʋmaa nɩɩ ɔ tɔwɛ kyula, nɩɩ o ŋmina yɩla fɛɛ bee biti ba lɛɛ Yesu sa fanɛ, nɩɩ ɩ ba kanɩn. Fan yɛgɛ nɩɩ asa libi ba da Yesu anyenbi mata oyu laasa sʋ nɩɩ ba mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amaa Ɩbwaarɛ kyiŋi mʋ lɩɩ lewu tɔ, lɛɛ mʋ lɩɩ lewu awʋrʋfɔ tɔ, lɩɩ fɛɛ lewu man taalɛ tii mʋ yɩla. ");
INSERT INTO naw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawidi wʋla tɔwɛ Yesu n‐yɩɩ sʋ asɩn yɛ, ‘Saŋa kʋmaa nɩmʋ, n wu Ɔnyɩrɩpɛ Ɩbwaarɛ mi ansi sʋ. Lɩɩ fɛɛ o tii mɛ sʋ, ɩmʋ sʋ sɛhn mɛɛ tɔɔrɔɔ mɛ. ");
INSERT INTO naw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ɩnɩmʋ sʋ mɛ kɔkɔlɔ ki fuuli mɛ, nɩɩ kensi‐gyii kɩ bɔla mɛ atɔwɛsa tɔ, nɩɩ halɩɩ n wu gbaa mʋ, n sʋ tamaa. ");
INSERT INTO naw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Lɩɩ fɛɛ fʋ mɛɛ yɛ fʋ yɛgɛ mɛ kala o sii kamandɛ, nɩɩ fʋ mɛɛ yɛ fʋ yɛgɛ fʋ Ɔkyɩrɛkyɩrɛpʋ ɔ gyɔɔ nyita. ");
INSERT INTO naw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fʋ kaapʋ mɛ nkpa ɔkpa, nɩɩ fʋ bʋ mɛ asɛ, ɩmʋ sʋ n nyɛ kensi‐gyii gaa.’ ");
INSERT INTO naw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mɛ‐daa ana yɛ mi‐supu ana, fɛn yɛgɛ n lɛɛ anɛ naana Dawidi nɩmʋ asɩn kaapʋ fanɛ. Dawidi mʋ nɩɩ ɔ tɔwɛ falɛ asɩn nɩmʋ gbaa wu nɩn, nɩɩ ba pula mʋ, nɩɩ mʋ kakyan kɛ san kɩ dɛ anɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Amaa ɔ dan ɔ gyɛ Ɩbwaarɛ ɔtɔwɛpʋ nɩn, nɩɩ o nyi fɛɛ Ɩbwaarɛ bɔ ntan da mʋ kɔkɔlɔ sʋ yɛ ee biti ɔ yɛgɛ mʋ kɩnaana tɔ ɔkʋ ɔ ba kyɩna mʋ Dawidi kuwura‐gya sʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawidi wʋla wu kʋtɔ mʋ nɩɩ Ɩbwaarɛ ii biti ɔ waa, kanɩn sʋ ɔ tɔwɛ Krisito kiwu kyiŋi mʋ asɩn yɛ, ‘Ɔ man yɛgɛ nɩɩ o sii abuni tɔ, nɩɩ mu kibuni man gyɔɔ kakyan tɔ.’ ");
INSERT INTO naw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu nɩmʋ asɩn nɩɩ Dawidi tɔwɛ mʋ, Ɩbwaarɛ kyiŋi mʋ lɩɩ lewu tɔ. Anɛ kpini ɩ gyɛ ɩmʋ kesintin agyipu. ");
INSERT INTO naw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nɩɩ mʋ‐Sɛ Ɩbwaarɛ diyaa mʋ yɩla mʋ gyisa sʋ, sa mʋ Kayaayu Kyɩrɛkyɩrɛ mʋ fɛɛ kanan mʋ nɩɩ ɔ da mʋ kɔkɔlɔ sʋ mʋ. Ɩmʋ nɩɩ fen nu, nɩɩ fen wu falɛ ɩ gyɛ Kayaayu Kyɩrɛkyɩrɛ mʋ nɩɩ ɔ sa anɛ. ");
INSERT INTO naw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawidi gbaa‐gbaa man kpee sʋsʋ, amaa ɔ tɔwɛ fɛɛ, ‘Ɔnyɩrɩpɛ Ɩbwaarɛ mʋ tɔwɛ sa mɛ‐Nyɩrɩpɛ yɛ, “Kyɩna mɛ gyisa sʋ, ");
INSERT INTO naw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","amɔɔ n taa fu akisipu kpini waa fʋ ayaa kasɛ.” ’ ");
INSERT INTO naw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Fanɛ Ɩsɩrayɩ abi kpini, fan nu danbɩrasa fɛɛ, Yesu nɩmʋ, mʋ nɩɩ fan da mʋ oyu laasa sʋ mʋ, Ɩbwaarɛ waa mʋ Ɔnyɩrɩpɛ yɛ Krisito nɩɩ ɩɩ kaapʋ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Saŋa mʋ nɩɩ asa mʋ ba nu ɩnɩmʋ kanɩn mʋ, i loo bamʋ nkɔlɔ tɔ, nɩɩ ba taasɛ Pita maa asunpu bambam mʋ yɛ, “Anɛ‐daa ana, mɩnɛ nɩɩ an biti a waa?” ");
INSERT INTO naw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nɩɩ Pita tɔwɛ bamʋ yɛ, “Fanɛ ɔkʋmaa nɩmʋ ɔ yɛgɛ alibi kɩwaa, kɛ ba gyee mʋ Ɩbwaarɛ kekyugyee lɩɩ Yesu Krisito kɩtɩɩ tɔ, kɛ fan nyɛ alibi kɩtaakɛɛ, kɛ fan nyɛ Ɩbwaarɛ kakɛɛ mʋ nɩɩ kɩ gyɛ mʋ Kayaayu mʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ɩnɩmʋ nɩɩ Ɩbwaarɛ da mʋ kɔkɔlɔ sʋ sa fanaa fanɛ‐bii ana mʋ, yɛ asa mʋ nɩɩ ba bʋ kata‐kata mʋ kpini, bamʋ nɩɩ Ɔnyɩrɩpɛ anɛ Ɩbwaarɛ ii biti ɔ tɩɩ ba mʋ asɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nɩɩ Pita gyii bamʋ kesintin bwii tɔwɛ ntɔwɛ gaalaagaa waa bamʋ aniya tɔ yɛ, “Fan lɛɛ fanɛ n‐yɩɩ lɩɩ ndaga asa libi nɩmʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Asa mʋ gaalaagaa ba kɔɔlɛ mʋ asɩn mʋ gyii nɩɩ ba gyee bamʋ Ɩbwaarɛ kekyugyee. Asa mʋ nɩɩ ba be tii kʋbʋ mʋ sʋ kakɛ maŋa mʋ ba waa fɛɛ asa ngbɩn nsa. ");
INSERT INTO naw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nɩɩ bamʋ kpini bɛ bɩɩla bɛɛ lɩɩ asunpu mʋ asɛ, ba sʋ kakyɛmɩnɛ ɔkɔn yɛ abaa, nɩɩ bee gyii Ɔnyɩrɩpɛ agyitɔ, nɩɩ bɛɛ bʋga bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Asunpu mʋ ba waa ɩsɩnkaala yɛ asɩn kyinkyinsa gaalaagaa, nɩɩ asɩn mʋ ɩ waa ɔkʋmaa anɩmʋ kɩyan. ");
INSERT INTO naw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Akɔɔlɛ‐gyipu mʋ kpini bɛɛ bʋga katɩn kʋlʋn, nɩɩ ba sʋ kɔnɔ kʋlʋn, yɛgɛ bamʋ kʋtɔ kʋmaa nɩmʋ gyɛ bamʋ kpini lɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bɛɛ fɛ bamʋ npatɩyɛ yɛ atɔ mʋ nɩɩ ba sʋ mʋ kpini, kɛ ba barɩgɛ afulee mʋ tɔ sa abaa kanan kʋmaa mʋ nɩɩ i tiri ɔkʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kakɛ kʋmaa nɩmʋ bɛɛ naa sarɛ kabwaarɛ‐sunkpa ayɛ kasɔrɔga tɔ fɛɛ kɩbʋlɛ kʋlʋn, bɛɛ bʋga nɩn bee gyii Ɔnyɩrɩpɛ agyitɔ bamʋ akpaara sʋ, nɩɩ bɛɛ bʋga bee gyii bamʋ gbaa‐gbaa bamʋ agyitɔ kensi‐gyii yɛ nkɔlɔ fuuli, ");
INSERT INTO naw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","yɛgɛ bɛɛ yɩn Ɩbwaarɛ, nɩɩ bamʋ awaasa kpini a gyii asa ansi. Nɩɩ kakɛ kʋmaa nɩmʋ Ɔnyɩrɩpɛ sʋ bamʋ nɩɩ ɛɛ mɔlɩgɛ mʋ, ee tii bamʋ Krisito abi kʋbʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kakaakʋ ɩ waa fɛɛ kakyʋwapɛ kerefi asa nɩɩ Pita maa Gyɔn bee kpee kabwaarɛ‐sunkpa tɔ ba naa kʋlɛ kabwaarɛ‐kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kewusunɔ Danbɩrasa, fɛɛ kanan mʋ nɩɩ bɛɛ tɩɩ kɩmʋ mʋ, tʋtɔ nɩɩ ba naa tu ɔnyɩn mʋ nɩɩ ba kʋʋgɛ mʋ yɛgɛ ɔ gyɛ boobi maa tɛ. Kakɛ kʋmaa bɛɛ sʋla mʋ bee kpee naa yɩla tʋtɔ yɛgɛ ɛɛ kʋlɛ asa mʋ nɩɩ bee kpee kabwaarɛ‐sunkpa ayɛ mʋ tɔ afulee. ");
INSERT INTO naw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Maa wu Pita maa Gyɔn ba maa biti ba loo tʋtɔ mʋ, nɩɩ ɔ kʋlɛ bamʋ yɛ ba sa mu afulee. ");
INSERT INTO naw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nɩɩ Pita maa Gyɔn ba kɩɩ mʋ kyimm, nɩɩ Pita yɛ, “Diyaa ansi kɩɩ anɛ danbɩrasa.” ");
INSERT INTO naw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nɩɩ ɔnyɩn mʋ kɩɩ bamʋ kyimm, nɩɩ ɔ waa nfɛɛrɛ fɛɛ ee biti ɔ nyɛ kʋtɔ kʋ lɩɩ bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Amaa Pita tɔwɛ mʋ nɩn yɛ, “Man sʋ afulee kpini‐kpini mɛ asɛ, amaa n biti n sa fʋ kʋtɔ mʋ nɩɩ n sʋ. Lɩɩ Yesu Krisito Kanasareti‐nyɩn kɩtɩɩ tɔ sʋ mʋ n yɛ fʋ, kʋsʋ natɛ.” ");
INSERT INTO naw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tʋtɔ nɩɩ Pita kɩtaa mʋ gyisa kɩbaa tɔ kyɛ mʋ tɔ nɩɩ ɔ kʋsʋ yɩlɛ. Opula maŋa tɔ nɩɩ ɔnyɩn mʋ ayaa yɛ mu amulii ɩ waa ɔlʋn, ");
INSERT INTO naw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","nɩɩ o fugi yii mʋ ayaa sʋ, o piili ɔ naa. Tʋtɔ nɩɩ maa bamʋ ba loo obu mʋ kasɔrɔga tɔ, ɔ naa ee fugi yɛgɛ ɛɛ yɩn Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Saŋa mʋ nɩɩ asa mʋ kpini ba wu mʋ maa naa ɛɛ yɩn Ɩbwaarɛ mʋ, ");
INSERT INTO naw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","nɩɩ ba bɩɩ fɛɛ mʋ ɩ gyɛ boobi mʋ nɩɩ ɔ tɛ kewusunɔ Danbɩrasa ɛɛ kʋlɛ afulee mʋ, ɩ waa bamʋ kɩyan, nɩɩ ɩ waa bamʋ kanankʋ maa kʋsʋ ɔ naa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Lɩɩ kanan mʋ nɩɩ ɔnyɩn mʋ taa mʋ n‐yɩɩ ba Pita maa Gyɔn asɛ sʋ mʋ, ɩ waa asa mʋ kanankʋ nɩɩ ba sɩlɛ kpee bamʋ asɛ katɩn mʋ nɩɩ bɛ tɩɩ yɛ Solomon lenbu mʋ. ");
INSERT INTO naw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita maa wu asa mʋ, nɩɩ ɔ tɔwɛ bamʋ yɛ, “Ɩsɩrayɩ abi, mɩnɛ ɩ yɛgɛ sʋ nɩɩ asɩn nɩmʋ a waa fanɛ kanankʋ? Nɩɩ mɩnɛ ɩ yɛgɛ nɩɩ fan kɩɩ anɛ gbaa fɛɛ anɛ gbaa‐gbaa anɛ ɔlʋn yɛ anɛ kabwaarɛ‐sun ɩ yɛgɛ nɩɩ ɔnyɩn nɩmʋ kʋsʋ ɔ naa falɛ? ");
INSERT INTO naw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ɩ gyɛ anɛ naana Abraham maa Isaki maa Gyekobu bamʋ Ɩbwaarɛ, ɔmʋ nɩɩ ɔ gyɛ anɛ naana ana kpini Ɩbwaarɛ, mʋ nɩɩ ɔ sa mʋ kɩyaafɔlɛ Yesu bʋnyaa kparɛ. Mʋ maŋa nɩɩ fan taa mʋ sa agyankpaapʋ, nɩɩ fan kina mʋ Paleti ansi tɔ, yɛgɛ Paleti waa mʋ nfɛɛrɛ fɛɛ ee biti ɔ yɛgɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ɔmʋ nɩɩ ɔ bʋrɔn nɩɩ o du kyɩrɛkyɩrɛ mʋ, mʋ, nɩɩ fan kina, nɩɩ fan kpalɩ ɩmʋ sʋ tɔwɛ Paleti yɛ ɔ yɛgɛ asa ɔmɔɔpʋ mʋ sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Fan taa Yesu mʋ nɩɩ ɛɛ sa nkpa mʋ mɔɔ, amaa Ɩbwaarɛ kyiŋi mʋ ba nkpa tɔ. Anɛ ɩ gyɛ asɩn maŋa kesintin agyipu. ");
INSERT INTO naw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Lɩɩ Yesu Krisito kɩtɩɩ tɔ kɩkɔɔlɛ‐gyii sʋ, nɩɩ ɩ yɛgɛ nɩɩ ɔnyɩn boobi mʋ nɩɩ fen nyi nɩɩ fen wu mʋ falɛ nyɛ alanfɩya. Lɩɩ fɛɛ ɔnyɩn mʋ maa kɔɔlɛ Yesu Krisito kɩtɩɩ gyii sʋ mʋ, ɔ kpaarɛ fɛɛ kanan mʋ nɩɩ fen wu mʋ falɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mɛ‐daa ana yɛ mi‐supu ana, nbɩɩnbɩɩ n bɩɩ kʋtɔ mʋ nɩɩ fanɛ yɛ fanɛ agyankpaapʋ ba waa Yesu falɛ, ɩ lɩɩ fanɛ kɩman‐nyi sʋ. ");
INSERT INTO naw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amaa Ɩbwaarɛ wʋla bɔla mʋ atɔwɛpʋ mʋ kpini sʋ tɔwɛ asɩn nɩmʋ fɛɛ, Ɔmʋ nɩɩ Ɩbwaarɛ lɛɛ mʋ ii biti o wu awʋrʋfɔ gaa, nɩɩ ɩ ba kanɩn mɔɔ kesintin. ");
INSERT INTO naw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ɩmʋ sʋ fan yɛgɛ alibi kɩwaa fanɛ kakyɩna tɔ kɛ fɛn buu Ɩbwaarɛ, kɛ ɔ taa fanɛ alibi kɛɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Fɛn kan waa kanɩn mʋ, kayɩɩ yuuli kakyɩna ii biti ɩ lɩɩ Ɔnyɩrɩpɛ mʋ asɛ, kɛ o sun Yesu Krisito mʋ nɩɩ ɔ wʋla lɛɛ mʋ sa fanɛ mʋ kɛ ɔ ba fanɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ɩ dagaa fɛɛ Yesu maa sii sʋsʋ naa fʋʋ saŋa mʋ nɩɩ Ɩbwaarɛ ɔ waa kʋtɔ kʋmaa nɩmʋ ki biliŋi kɩpʋpwɛ fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ wʋla bɔla mʋ atɔwɛpʋ kyɩrɛkyɩrɛ mʋ sʋ tɔwɛ asɩn nɩmʋ lɩɩ koo dɩdaa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kanɩn sʋ Ɩbwaarɛ ɔtɔwɛpʋ Mosesi tɔwɛ yɛ, ‘Ɔnyɩrɩpɛ Ɩbwaarɛ ii biti ɔ lɛɛ fanɛ tɔ ɔtɔwɛpʋ fɛɛ kanan mʋ nɩɩ o sun mɛ falɛ, nɩɩ ɔ gyɛ fanɛ gbaa‐gbaa fanɛ nyɩmɩsa. Nɩɩ ɩ dagaa fɛɛ fɛn kan fanɛ asʋ, kɛ fen nu kʋtɔ kʋmaa mʋ nɩɩ ee biti ɔ tɔwɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nɩɩ ɔkʋmaa mʋ nɩɩ o mee nu kanɩn ɔtɔwɛpʋ maŋa asɛ mʋ, Ɩbwaarɛ ii biti ɔ lɛɛ mʋ lɩɩ mʋ asa tɔ kɛ o nyita mʋ.’ ");
INSERT INTO naw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Lɩɩ Ɩbwaarɛ ɔtɔwɛpʋ Samuweli yɛ atɔwɛpʋ mʋ nɩɩ ba sʋ kanɩn katɔwɛ maŋa yɛ bamʋ nɩɩ ba lɩɩ Samuweli kamaa ba mʋ kpini ba tɔwɛ kanɩn asɩn mʋ nɩɩ ɩ waa ndaga anɛ kakyɩna kanɩmʋ tɔ falɛ. ");
INSERT INTO naw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ɩbwaarɛ maa bɔla mʋ atɔwɛpʋ sʋ ɛɛ da mʋ kɔkɔlɔ sʋ mʋ kpini ɩ dɛ sa fanɛ. Kɛ katɔwɛ kyula mʋ nɩɩ fanaa Ɩbwaarɛ yɛ fanɛ naana ana ba waa mʋ, fɛɛ kanan mʋ nɩɩ ɔ tɔwɛ Abraham yɛ, ‘Lɩɩ fʋ kɩnaana sʋ mʋ, n biti n waa kasɛ sʋ asa kpini kusee.’ ");
INSERT INTO naw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɩmʋ sʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ kɩyaafɔlɛ Yesu nɩɩ ɔ gyankpaa sun mʋ fanɛ asɛ, kɛ fan yɛgɛ alibi kɩwaa ɔkpa kʋmaa sʋ kɛ ɔ waa fanɛ kusee.” ");
INSERT INTO naw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita maa Gyɔn ba san ba maa sʋ bɛɛ tɔwɛ asa mʋ asɛ mʋ, nɩɩ Ɩbwaarɛ aseepu akʋ, yɛ kabwaarɛ‐sunkpa ayɛ akunpu mʋ ɔbɩlɩsa yɛ, Sadusi abi ba ba fʋʋ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nɩɩ ba nyɛ agbʋ waa Pita maa Gyɔn fɛɛ ba maa kaapʋ bɛ tɔwɛ asa mʋ yɛ Yesu bwii kyiŋi ba nkpa tɔ, nɩɩ ɩ kaapʋ fɛɛ kelewu kyiŋi kɩ bʋ tɔ sa asa kpini. ");
INSERT INTO naw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ɩmʋ sʋ ba kɩtaa Pita maa Gyɔn naa tii bamʋ obu naa fʋʋ kayɩkɛ, lɩɩ fɛɛ kyɔwɛ maa tɛɛ lʋwɛ sʋ mʋ ba tii bamʋ obu naa fʋʋ kayɩkɛ. ");
INSERT INTO naw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amaa asa gaalaagaa mʋ nɩɩ ba nu Yesu Krisito asɩn danbɩrasa mʋ, ba kɔɔlɛ gyii nɩɩ kʋbʋ mʋ kɩ nyɛ akyɔ bɛɛ waa fɛɛ anyɩn ngbɩn‐nnuu. ");
INSERT INTO naw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lɩɩkaakɛ mʋ Gyiwu abi agyankpaapʋ yɛ abɩlɩsa yɛ Mosesi nbara akaapʋpʋ ba naa sarɛ Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bamʋ nɩɩ ba sarɛ tʋtɔ ɩ gyɛ oseepu bɩlɩsa asɛ Anasi yɛ Kefasi yɛ Gyɔn yɛ Alekisanda yɛ oseepu bɩlɩsa asɛ mʋ, mʋ kʋʋpʋ ana. ");
INSERT INTO naw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba taa Pita maa Gyɔn ba ba yɩlɛ bamʋ ansi tɔ, nɩɩ ba taasɛ bamʋ yɛ, “Mɩnɛ ɔlʋn nɩɩ fan nyɛ abɛɛ anɩmʋ kɩtɩɩ nɩɩ fan sʋ fan waa ɩnɩmʋ falɛ?” ");
INSERT INTO naw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tʋtɔ mʋ, Pita mʋ nɩɩ Kayaayu Kyɩrɛkyɩrɛ kɩ bɔla mʋ tɔ mʋ lɛɛ bamʋ kɔnɔ yɛ, “Agyankpaapʋ yɛ abɩlɩsa, ");
INSERT INTO naw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","fan taasɛ anɛ ndaga asɩn danbɩrasa mʋ nɩɩ an waa boobi nɩmʋ, nɩɩ kʋtɔ mʋ nɩɩ kɩ yɛgɛ nɩɩ ɔ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kanɩn sʋ ɩ dagaa fɛɛ fanɛ yɛ Ɩsɩrayɩ abi kpini fan bɩɩ fɛɛ ɔnyɩn mʋ nɩɩ ɔ yɩlɛ nfɩɩ falɛ, Yesu Krisito mʋ nɩɩ ɔ lɩɩ Nasareti, ɔmʋ nɩɩ fan da mʋ mata oyu laasa sʋ mʋ, nɩɩ Ɩbwaarɛ bwii kyiŋi mʋ ba nkpa tɔ mʋ, ɩ yɛgɛ nɩɩ ɔ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nɩɩ Yesu ɩ gyɛ ɔsa mʋ nɩɩ Ɩbwaarɛ Asɩnkyan yɩlasa mʋ ɩ tɔwɛ yɛ, ‘Kubuu mʋ nɩɩ fanɛ, apɔyɩpʋ fan kina yɛ kɩ man bʋrɔn mʋ, kanɩn kubuu maŋa ɩ ba biliŋi kubuu kparɛ ɩmʋ kpini tɔ.’ ");
INSERT INTO naw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nɩɩ ɔkʋ man bʋ tɔ nɩɩ ɛɛ taalɛ mɔlɩgɛ asa, amɔɔ Yesu nkʋn, lɩɩ fɛɛ kɩtɩɩ pʋpwɛ kʋ man bɩla ɔ bʋ dulinyaa tɔ nɩɩ Ɩbwaarɛ taa sa yɛ kɩ mɔlɩgɛ anɛ.” ");
INSERT INTO naw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ɩ waa abɩlɩsa mʋ kpini kanankʋ fɛɛ Pita maa Gyɔn ba maa yɩlɛ kɩnyɩn tɔ, nɩɩ ba bɩɩ fɛɛ ba man gyɛ bamʋ nɩɩ be nyi ɩwʋlɛ. Tʋtɔ nɩɩ ba wu fɛɛ ba wʋla ba gyɛ Yesu abuupu nɩn. ");
INSERT INTO naw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kpalɩ fɛɛ ba maa wu boobi mʋ nɩɩ ba kyɛ mʋ, maa yɩlɛ Pita maa Gyɔn asɛ mʋ, ba man taalɛ nyɛ asɩn kʋ ba tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɩmʋ sʋ ba dan sii tɔwɛ bamʋ nɩn yɛ ba lɩɩ nsarɛ obu mʋ tɔ, nɩɩ ba sii ba taa Pita maa Gyɔn sʋ nfɛɛrɛ. ");
INSERT INTO naw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nɩɩ ba taasɛ abaa yɛ, “Nɛnɛ nɩɩ an biti a waa asa anɩmʋ? Ɔkʋmaa mʋ nɩɩ ɔ bʋ Gyerusalem nyi yɛ bamʋ ɩ waa asɩn kyinkyinsa nɩmʋ, nɩɩ a mɛɛ taalɛ gyii ɩ mʋ ɩmɔɔrɛ. ");
INSERT INTO naw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amaa pɔyɩ kɛ a tii asɩn nɩmʋ kɛ ɩ man naa lɩɩ asa asɛ kata‐kata mʋ, a da bamʋ amu tɔ yɛ, ɩ nɩmʋ i gyii bamʋ ɔkaa, ba man bɩla taa Yesu kɩtɩɩ asɩn tɔwɛ sa asa.” ");
INSERT INTO naw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ɩmʋ sʋ nɩɩ ba bwii tɩɩ Pita maa Gyɔn ba lenbu mʋ tɔ tɔwɛ bamʋ yɛ kakaakʋ ba man bɩla lɩɩ tɔwɛ abɛɛ kaapʋ lɩɩ Yesu kɩtɩɩ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amaa Pita maa Gyɔn ba lɛɛ bamʋ kɔnɔ nɩn yɛ, “Fanɛ gbaa‐gbaa fanɛ fan kɩɩ damu maŋa tɔ ɩmʋ nɩɩ ɩ bʋrɔn lɩɩ Ɩbwaarɛ ansi tɔ. An nu fanɛ asɛ abɛɛ Ɩbwaarɛ asɛ? ");
INSERT INTO naw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Lɩɩ fɛɛ a mɛɛ taalɛ yɛgɛ kʋtɔ mʋ nɩɩ anɛ gbaa‐gbaa anɛ an wu nɩɩ an nu mʋ kɩtɔwɛ.” ");
INSERT INTO naw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ɩmʋ sʋ nɩɩ abɩlɩsa mʋ ba lɔŋɔ da Pita maa Gyɔn amu tɔ kenken nɩɩ ba yɛgɛ bamʋ yɛ ba natɛ. Ba man nyɛ ɔkpa mʋ nɩɩ ba yɩlɛ sʋ taa bɩɩtɛ bamʋ asʋ, kpalɩ fɛɛ asa kpini ba maa yɩn Ɩbwaarɛ lɩɩ kʋtɔ mʋ nɩɩ ba waa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɔnyɩn mʋ nɩɩ ba waa asɩn kyinkyinsa kyɛ mʋ mʋ, gyii ɔ kyɔ nsu adɩna. ");
INSERT INTO naw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Saŋa mʋ nɩɩ ba dan yɛgɛ Pita maa Gyɔn mʋ, ba bwii kpee bamʋ kyɛmɩnɛ ana akɔɔlɛ‐gyipu mʋ asɛ naa tɔwɛ bamʋ kʋtɔ mʋ nɩɩ abɩlɩsa yɛ aseepu‐bɩlɩsa mʋ ba tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Akɔɔlɛ‐gyipu mʋ ba maa dan nu kanɩn mʋ, nɩɩ bamʋ kpini ba waa kɔnɔ kʋlʋn kʋlɛ kabwaarɛ‐kʋlɛ yɛ, “Ɔnyɩrɩpɛ Ɩbwaarɛ, fʋ mʋ nɩɩ fʋ tʋʋ sʋsʋ yɛ kasɛ yɛ ɔpʋ yɛ kʋtɔ kʋmaa mʋ nɩɩ kɩ bʋ ɩmʋ tɔ kpini. ");
INSERT INTO naw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fʋ bɔla Kayaayu Kyɩrɛkyɩrɛ sʋ nɩɩ fʋ yɛgɛ anɛ naana Dawidi, fʋ kɩyaafɔlɛ tɔwɛ yɛ, ‘Mɩnɛ ɩ waa sʋ nɩɩ ndɛndɛmandɛ bɛɛ nyɛ agbʋ? Mɩnɛ ɩ waa sʋ nɩɩ asa anɩmʋ bɛɛ fɛ nfɛɛrɛ libi kanɩn? ");
INSERT INTO naw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kasɛ sʋ awura bɛɛ kʋʋla bamʋ n‐yɩɩ kʋsʋ yɩlɛ, nɩɩ akɩɩsʋpʋ mɔɔ bɛɛ sarɛ bɛɛ kʋsʋ yɩlɛ Ɔnyɩrɩpɛ Ɩbwaarɛ maa Ɔmʋ nɩɩ ɔ lɛɛ mʋ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kesintin, asɩn nɩmʋ a ba tɔ fɛɛ Herodi maa Pontiyu Paleti yɛ Ɩsɩrayɩ abi yɛ ndɛndɛmandɛ ba sarɛ kadɛ nɩmʋ tɔ, bee ŋmina agyina kʋsʋ yɩlɛ Yesu sʋ fʋ Kɩyaafɔlɛ Kyɩrɛkyɩrɛ mʋ nɩɩ fʋ lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kesintin ba sarɛ kanɩn nɩn ba ba waa kʋtɔ kʋmaa mʋ lɩɩ fʋ ɔlʋn sʋ, yɛ fʋ kɔkɔlɔ biti mʋ nɩɩ fʋ wʋla paa yɛ ɩ waa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ɩmʋ sʋ, Ɔnyɩrɩpɛ, nbɩɩnbɩɩ bɩɩ aŋaala mʋ nɩɩ bɛɛ ŋaala anɛ falɛ kɛ fʋ sa anɛ, fʋ ayaafɔlɛ kɔkɔlɔ ɔsɩɩ kɛ a taalɛ tɔwɛ fʋ asɩn danbɩrasa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tɛɛŋɛ fʋ abaa kɛ alɔpʋ ba nyɛ alanfɩya, kɛ fʋ waa adangana yɛ asɩn kyinkyinsa bɔla fʋ kɩyaafɔlɛ kyɩrɛkyɩrɛ Yesu kɩtɩɩ sʋ waa kaapʋ asa.” ");
INSERT INTO naw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Saŋa mʋ nɩɩ ba kʋlɛ kabwaarɛ‐kʋlɛ lʋwɛ mʋ, opula mʋ nɩɩ ba sarɛ mʋ gyingyen. Nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ loo bɔla bamʋ kpini nɩɩ ba piili bɛ tɔwɛ Ɩbwaarɛ asɩn mʋ yɛ kɔkɔlɔ ɔsɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Akɔɔlɛ‐gyipu kʋbʋ mʋ kpini ba waa nfɛɛrɛ kʋlʋn yɛ kɔkɔlɔ kʋlʋn. Bamʋ ɔkʋ mɛɛ tɔwɛ yɛ, kʋtɔ mʋ nɩɩ ɔ sʋ mʋ gyɛ mʋ lɛɛ. Kʋtɔ kʋmaa mʋ nɩɩ ba sʋ mʋ gyɛ bamʋ kpini lɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Asunpu mʋ ba tɔwɛ Ɔnyɩrɩpɛ Yesu Krisito kelewu kyiŋi mʋ asɩn ba kaapʋ lɩɩ Ɩbwaarɛ ɔlʋn lala mʋ sʋ. Nɩɩ Ɩbwaarɛ waa bamʋ kpini kusee. ");
INSERT INTO naw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ɔkʋ man bʋ bamʋ kʋbʋ mʋ tɔ nɩɩ kʋtɔ kʋ ki tiri mʋ kpaa. Lɩɩ fɛɛ bamʋ nɩɩ ba sʋ kasɛ abɛɛ akpaara mʋ, ba fɛ ɩmʋ yɛgɛ ba sʋ afulee mʋ ba ba, ");
INSERT INTO naw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ba yɩla asunpu mʋ kagya kasɛ, nɩɩ ba barɩgɛ ɩmʋ tɔ fɛɛ kanan mʋ nɩɩ i tiri ɔkʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kanɩn nɩɩ Gyosefu, mʋ nɩɩ ɔ lɩɩ Lewi kebunɔ, nɩɩ ba kʋʋgɛ mʋ Sipuru, nɩɩ asunpu mʋ bɛɛ tɩɩ mʋ yɛ Banabasi, (kɩmʋ kasɛ ɩ kaapʋ fɛɛ, Ɔmʋ nɩɩ ɛɛ waa asa aniya tɔ). ");
INSERT INTO naw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mʋ gbaa mʋ fɛ mʋ kasɛ mʋ nɩɩ ɔ sʋ mʋ, nɩɩ ɔ taa afulee mʋ ba waa asunpu mʋ kagya kasɛ. ");
INSERT INTO naw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nɩɩ ɔnyɩn kʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Ananiyasi maa mʋ‐ka Safira ba fɛ bamʋ kasɛ kʋkʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nɩɩ Ananiyasi maa mʋ‐ka ba waa kɔnɔ nɩɩ ɔ barɩgɛ afulee mʋ tɔ, nɩɩ ɔ taa ɩkʋ yɩla, nɩɩ ɔ taa asansa mʋ kpiya asunpu mʋ kagya kasɛ. ");
INSERT INTO naw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nɩɩ Pita taasɛ mʋ yɛ, “Ananiyasi, mɩnɛ ɩ waa nɩɩ fʋ yɛgɛ nɩɩ Sɩtaanɛ i gyii fu kumu nɩɩ fʋ tɩn antɩŋɛsa sa Kayaayu Kyɩrɛkyɩrɛ kanɩn? Mɩnɛ ɩ waa nɩɩ fʋ fɛ fʋ kasɛ nyɛ afulee nɩɩ fʋ barɩgɛ tɔ taa ɩkʋ yɩla? ");
INSERT INTO naw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pɔyɩ kɛ fʋ fɛ kasɛ maŋa mʋ, kɩ gyɛ fʋ lɛɛ nɩn, nɩɩ saŋa mʋ nɩɩ fʋ fɛ lʋwɛ mʋ, afulee mʋ gbaa a gyɛ fʋ lɛɛ nɩn. Mɩnɛ ɩ waa sʋ nɩɩ fʋ waa kanɩn asɩn maŋa? Man gyɛ asa nɩɩ fʋ tɩn antɩŋɛsa sa, amaa Ɩbwaarɛ nɩɩ fʋ tɩn antɩŋɛsa sa.” ");
INSERT INTO naw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyasi maa dan nu kanɩn asɩn maŋa mʋ, tʋtɔ nɩɩ ɩ tɩn mʋ tʋʋ nɩɩ o wu. Nɩɩ ɩ waa ɔkʋmaa mʋ nɩɩ o nu kanɩn mʋ kufuu gaa. ");
INSERT INTO naw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tʋtɔ nɩɩ ayaafɔlɛ ba loo bɔlɔɔ mʋ, kukuri lɩɩ naa pula. ");
INSERT INTO naw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ɩ maa waa gbɛrɛɛ mʋ, mʋ‐ka Safira gbaa loo ba ɔ man nyi kʋtɔ mʋ nɩɩ kɩ waa. ");
INSERT INTO naw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nɩɩ Pita taasɛ, mʋ yɛ, “Tɔwɛ mɛ kesintin, kasɛ afulee mʋ nɩɩ faa fu‐kuli fan fɛ mʋ kpini ndee?” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Oo, ɩmʋ afulee kpini nɩn.” ");
INSERT INTO naw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nɩɩ Pita taasɛ mʋ yɛ, “Mɩnɛ ɩ waa sʋ nɩɩ faa fu‐kuli fan waa kɔnɔ kʋlʋn yɛ fan tʋʋ Ɔnyɩrɩpɛ Kayaayu mʋ tɔ kɩɩ. Kɩɩ! Ayaafɔlɛ mʋ nɩɩ ba naa pula fu‐kuli mʋ ba yɩlɛ kebunɔ tʋtɔ nbɩɩnbɩɩ, kanɩn nɩɩ bee biti ba kukuri ngbaa fʋ lɩɩ naa pula nɩn.” ");
INSERT INTO naw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Opula tɔ, nɩɩ ɩ tɩn mʋ tʋʋ Pita ayaa tɔ nɩɩ o wu. Nɩɩ ayaafɔlɛ mʋ ba be loo, nɩɩ ba wu yɛ o wu ɔ dɛ, nɩɩ ba bɔlɔɔ mʋ kukuri lɩɩ naa pula mata mu‐kuli. ");
INSERT INTO naw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Krisito abi kʋbʋ yɛ asa mʋ nɩɩ ba bʋ tʋtɔ mʋ kpini ba maa nu kanɩn mʋ, ɩ waa bamʋ kufuu gaa. ");
INSERT INTO naw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Asunpu mʋ ba waa ɩsɩnkaala yɛ asɩn kyinkyinsa asa mu ansi tɔ. Akɔɔlɛ‐gyipu mʋ kpini bɛɛ taalɛ bɛɛ gyaŋɛ Ɩbwaarɛ osunkpa ayɛ mʋ opula mʋ nɩɩ bɛɛ tɩɩ yɛ Solomon kasɔrɔga tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Asa mʋ ba sʋ bɛɛrɛɛ bɛ sa bamʋ gaa, amaa bamʋ nɩɩ ba man kɔɔlɛ gyii mʋ ɔkʋ man taalɛ nyɛ kɔkɔlɔ naa tii bamʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Amaa kamaa tɔ mʋ, anyɩn yɛ akyɩɩ gaalaagaa ba kɔɔlɛ Ɔnyɩrɩpɛ gyii, nɩɩ ba naa tii bamʋ kʋbʋ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lɩɩ kanɩn sʋ, asa ba sʋla alɔpʋ ba yɩla agbenbi ɔkaa yɛgɛ ba dɛ bamʋ mpaa yɛ ɩkalan sʋ kanan mʋ nɩɩ ɩ waa kɛ Pita kan ɛɛ kyʋn mʋ, mʋ kayaayu kɩ natɛ bamʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ndɛ‐bii mʋ nɩɩ ɩ bʋ kyaabɔɔ Gyerusalem mʋ asa ba taa bamʋ alɔpʋ yɛ bamʋ nɩɩ nbwɩɩ libi bɛɛ tɔɔrɔɔ bamʋ kpini ba, nɩɩ ba nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nɩɩ Ɩbwaarɛ oseepu bɩlɩsa asɛ mʋ, yɛ mʋ kamaa abi mʋ nɩɩ ba lɩɩ Sadusi kʋbʋ mʋ tɔ mʋ, ba nyɛ kayɩɩ basa lɩɩ asunpu mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ba kɩtaa asunpu mʋ naa tii katɩn mʋ nɩɩ ba tii bamʋ asa obu mʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amaa kanɩn kagyanbwɛ maŋa mʋ, Ɩbwaarɛ kabɔɔ ba tigi obu mʋ kebunɔ nɩɩ ɔ lɛɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fan kpee naa yɩlɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ kɛ fan tɔwɛ asa mʋ, nkpa pʋpwɛ nɩmʋ asɩn.” ");
INSERT INTO naw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kayɩ kɩ maa kɛ mʋ Krisito asunpu mʋ ba kpee kabwaarɛ‐sunkpa ayɛ mʋ tɔ fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ kabɔɔ mʋ katɔwɛ mʋ, nɩɩ ba yii kasɛ bɛɛ tɔwɛ asa mʋ nkpa mʋ asɩn. Oseepu bɩlɩsa asɛ mʋ maa mʋ kamaa abi, ba maa ba mʋ, ɔ tɩɩ Sanhediri mʋ nɩɩ ba gyɛ Gyiwu abi kʋbʋ‐kʋbʋ abɩlɩsa mʋ kpini ba ba gyaŋɛ, nɩɩ o sun yɛ ba naa lɛɛ asunpu mʋ ba. ");
INSERT INTO naw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Apurusi mʋ nɩɩ ba sun mʋ, ba maa fʋʋ obu tiisa mʋ tɔ mʋ, ba man wu asunpu mʋ obu maŋa tɔ. Ɩmʋ sʋ ba bwii naa tɔwɛ abɩlɩsa mʋ nɩɩ bee gyoo bamʋ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“An wu obu mʋ maa biri sʋ danbɩrasa yɛgɛ akɩɩsʋpʋ mʋ ba yɩlɛ nbunɔ, amaa a maa tigi nbunɔ mʋ a man wu ɔkʋ obu mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ɔbɩlɩsa mʋ nɩɩ ɔ gyɛ kabwaarɛ‐sunkpa ayɛ mʋ akɩɩsʋpʋ mʋ, yɛ Ɩbwaarɛ oseepu bɩlɩsa ba maa nu kanɩn mʋ i kyinkyin bamʋ, kʋtɔ mʋ nɩɩ kɩ yɛgɛ nɩɩ ɩ ba kanɩn. ");
INSERT INTO naw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tʋtɔ nɩɩ ɔkʋ ba tɔwɛ bamʋ yɛ, “Fan kɩɩ! Anyɩn mʋ nɩɩ fan tii bamʋ obu mʋ bɛɛ yɩlɛ kabwaarɛ‐sunkpa ayɛ mʋ kasɔrɔga tɔ bɛɛ kaapʋ asa.” ");
INSERT INTO naw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ba maa nu kanɩn mʋ akɩɩsʋpʋ ɔbɩlɩsa mʋ yɛ mʋ ayaafɔlɛ ba kpee naa bɩya asunpu mʋ. Ba maa sɩlɛ kufuu fɛɛ asa mʋ, bee biti ba tʋʋ bamʋ abuu su mʋ, ba man taa bamʋ yɛ ɔlʋn sʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nɩɩ ba taa bamʋ ba yɩlɛ abɩlɩsa mʋ nɩɩ ba sarɛ mu ansi tɔ. Nɩɩ Ɩbwaarɛ oseepu bɩlɩsa asɛ mʋ taasɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Yɛ an da fanɛ amu tɔ yɛ, fan man bɩla taa Yesu kɩtɩɩ tɔ kaapʋ? Amaa fan taa fanɛ kɩkaapʋ kyaabɔɔ Gyerusalem kpini. Fen biti fan taa ɔnyɩn nɩmʋ kelewu ba anɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nɩɩ Pita maa asunpu banban mʋ ba lɛɛ kɔnɔ yɛ, “Ɩ dagaa fɛɛ a maa nu Ɩbwaarɛ kɔnɔ nɩn, man gyɛ nyɩmɩsa lɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Anɛ naana ana bamʋ Ɩbwaarɛ i kyiŋi Yesu mʋ nɩɩ fan da mʋ oyu laasa mɔɔ mʋ, lɩɩ lewu tɔ. ");
INSERT INTO naw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ɩbwaarɛ diyaa mʋ naa kyɩna mʋ gyisa sʋ fɛɛ Ɔgyankpaapʋ yɛ Ɔmɔlɩgɛpʋ mʋ, nɩɩ o bugi ɔkpa sa Ɩsɩrayɩ abi kɛ ba yɛgɛ alibi kɩwaa, kɛ Ɩbwaarɛ ɔ taa bamʋ alibi kɛɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kayaayu Kyɩrɛkyɩrɛ mʋ nɩɩ Ɩbwaarɛ taa sa bamʋ nɩɩ ba buu mʋ mʋ, yɛ anɛ asunpu mʋ ɩ gyɛ ɩmʋ kesintin agyipu ɩnɩmʋ kpini sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nɩɩ nbara abɩlɩsa kʋbʋ‐kʋbʋ mʋ ba maa nu kanɩn mʋ, ɩ nyɛ bamʋ agbʋ gaa nɩɩ ba waa bamʋ nfɛɛrɛ fɛɛ ba mɔɔ asunpu mʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amaa bamʋ tɔ ɔnyɩn kʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Gamaliye, nɩɩ ɔ gyɛ Farasii obii yɛ Mosesi nbara ɔkaapʋpʋ mʋ nɩɩ asa kpini bɛɛ sa mʋ bɛɛrɛɛ mʋ, kʋsʋ yɩlɛ bamʋ nsana nɩɩ ɔ tɔwɛ yɛ, ba yɛgɛ asunpu mʋ ba lɩɩ kewu gbɛrɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Ɩsɩrayɩ abi, fan lɔŋɔ fɛ nfɛɛrɛ mʋ nɩɩ fan taa lɩɩ anyɩn anɩmʋ sʋ danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Saŋa kʋ tɔ mʋ, Tewuda kʋ gbaa daa kyɩna kʋsʋ yɛ ɔ gyɛ ɔkʋ nɩn. Ɔ nyɛ kʋbʋ fɛɛ asa alɩfa ana nɩɩ ba buu mʋ. Amaa ba mɔɔ mʋ, nɩɩ mʋ kʋbʋ kɩ yaasɛ tɔ, nɩɩ mʋ awaasa kpini ɩ waa kɩyan. ");
INSERT INTO naw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mʋ kamaa mʋ Gyudasi mʋ nɩɩ ɔ lɩɩ Galile mʋ, asa kɩkalɛ saŋa mʋ ngbaa mʋ kʋsʋ yɩlɛ nɩɩ ɔ nyɛ kʋbʋ lala kʋ nɩɩ ba buu mʋ. Amaa ba mɔɔ mʋ, nɩɩ mu abuupu gbaa ba yaasɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ɩmʋ sʋ asɩn mʋ nɩɩ ndaga ɩ ba falɛ, n biti n tɔwɛ fanɛ fɛɛ fɛn yɛgɛ asa anɩmʋ ba natɛ. Lɩɩ fɛɛ nɩɩ bamʋ kusun kɩnɩmʋ kɩ gyɛ nyɩmɩsa lɛɛ bɩrɛ kii biti ki nyita. ");
INSERT INTO naw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amaa nɩɩ ɩ gyɛ Ɩbwaarɛ lɛɛ bɩrɛ fɛn mɛɛ taalɛ tii asa anɩmʋ, nɩɩ ɩ waa kanɩn bɩrɛ fen biti fen wu fɛɛ fɛn kɔ yɛ Ɩbwaarɛ.” ");
INSERT INTO naw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ba nu sa Gamaliye katɔwɛ mʋ, nɩɩ ba tɩɩ asunpu mʋ tɩŋɛ bamʋ. Nɩɩ ba da bamʋ amu tɔ yɛ, ba man bɩla tɔwɛ Yesu kɩtɩɩ tɔ asɩn. Nɩɩ ba yɛgɛ bamʋ yɛ ba natɛ. ");
INSERT INTO naw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Asunpu mʋ ba lɩɩ Ɩsɩrayɩ kʋbʋ‐kʋbʋ mʋ tɔ kpini abɩlɩsa mu ansi tɔ, taa kensi‐gyii fɛɛ, Ɩbwaarɛ kalɛ bamʋ tii bamʋ nɩɩ ba wu awʋrʋfɔ lɩɩ Yesu kɩtɩɩ tɔ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kakɛ kʋmaa nɩmʋ ba naa kabwaarɛ‐sunkpa ayɛ mʋ nsɔrɔga tɔ yɛ asa akpaara sʋ. Ba man yɛgɛ asɩn danbɩrasa mʋ kɩtɔwɛ yɛ Yesu ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Saŋa mʋ nɩɩ Yesu abuupu mʋ ba nyɛ akyɔ mʋ, kamɔɔrɛ‐gyii kɩ ba Gyiwu ndɛ‐bii mʋ nɩɩ bɛɛ tɔwɛ Giriki mʋ yɛ Gyiwu ndɛ‐bii mʋ nsana. Ba fabɩlɛ yɛ Gyiwu ndɛ‐bii mʋ ba mɛɛ sa bamʋ akulapu‐kyɩɩ atɔ barɩgɛsa kanan mʋ nɩɩ ɩ dagaa. ");
INSERT INTO naw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ɩmʋ sʋ mʋ, asunpu kudu‐anyɔ mʋ ba sarɛ Yesu abuupu mʋ kpini. Nɩɩ ba tɔwɛ bamʋ yɛ, “Ɩ man dagaa fɛɛ a yɛgɛ abwaarɛsɩn kɩtɔwɛ yɩla kɛ a ba kɩɩ atɔ kɩbarɩgɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kanɩn sʋ anɛ‐daa ana yɛ anɛ‐supu ana, fan lɛɛ fanɛ tɔ anyɩn asunɔ mʋ nɩɩ bɛ sʋ bɛɛrɛɛ yɛ kanyaasɩn nɩɩ Kayaayu Kyɩrɛkyɩrɛ kɩ bɔla bamʋ tɔ mʋ, kɛ a taa kusun nɩmʋ waa bamʋ abaa tɔ, ");
INSERT INTO naw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kɛ a nyɛ saŋa sa kabwaarɛ‐kʋlɛ yɛ abwaarɛsɩn kɩtɔwɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kanɩn nfɛɛrɛ mʋ ɩ pɩrɛ bamʋ kpini. Nɩɩ Yesu abuupu mʋ ba lɛɛ Sitefen mʋ nɩɩ mʋ kɩkɔɔlɛ‐gyii yɛ Kayaayu Kyɩrɛkyɩrɛ kɩ kyɔ mʋ tɔ mʋ, nɩɩ ba lɛɛ Filipi yɛ Pokoro yɛ Nikano yɛ Timon yɛ Pamena maa Nikolasi mʋ nɩɩ ɔ lɩɩ Antiyoki, nɩɩ ɔ taa mʋ n‐yɩɩ biliŋi Gyiwu abi, nɩɩ ɔ ba kɔɔlɛ Yesu gyii mʋ. ");
INSERT INTO naw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nɩɩ ba lɛɛ bamʋ kaapʋ asunpu mʋ, nɩɩ asunpu mʋ ba taa bamʋ abaa gyaga bamʋ sʋ nɩɩ ba kʋlɛ kabwaarɛ‐kʋlɛ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ɩmʋ sʋ abwaarɛsɩn mʋ ɩ yɛlɩgɛ. Yesu abuupu mʋ ba nyɛ akyɔ tii sʋ Gyerusalem ɔsʋwʋlɛ sʋ. Nɩɩ Ɩbwaarɛ aseepu mʋ gaalaagaa gbaa ba kɔɔlɛ Yesu gyii. ");
INSERT INTO naw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitefen mʋ nɩɩ ɔ sʋ ɔlʋn nɩɩ Ɩbwaarɛ bwaala mʋ mʋ, waa asɩn kyinkyinsa yɛ asɩnkaala asa mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Amaa Gyiwu abi mʋ nɩɩ ba lɩɩ Kirini yɛ Alekisanda kabwaarɛ kʋlɛkpa mʋ nɩɩ bɛ tɩɩ yɛ ba kɔɔlɛ bamʋ n‐yɩɩ, yɛ bamʋ nɩɩ ba lɩɩ Silisiya, Asiya ɩsʋwʋlɛ sʋ mʋ kpini ba gyii Sitefen ɩmɔɔrɛ. ");
INSERT INTO naw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lɩɩ mʋ kanyaasɩn yɛ Kayaayu Kyɩrɛkyɩrɛ ɔkpa katɔwɛ tɔ sʋ mʋ, ba man taalɛ yɩlɛ mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ba lɩɩ asiiri tɔ naa wu asa akʋ yɛ ba ba tɩn atɩntɩnsa gyaga Sitefen sʋ, kɛ ba ba tɔwɛ yɛ, “An nu Sitefen maa tɔwɛ nbusaa asɩn ɛɛ gyaga Mosesi maa Ɩbwaarɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nɩɩ amɔɔrɛ‐gyipu ba tɔwɛ fun waa abɩlɩsa mʋ yɛ Mosesi nbara akaapʋpʋ yɛ asa mʋ kpini nkɔlɔ nɩɩ ba kɩtaa Sitefen ba Ɩsɩrayɩ kʋbʋ‐kʋbʋ abɩlɩsa mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba bɩya antɩŋɛsa wuya ana nɩɩ ba tɔwɛ yɛ, “Saŋa kʋmaa ɔnyɩn nɩmʋ ɩ tɔwɛ nbusaa asɩn ee yii kabwaarɛ‐sunkpa ayɛ kyɩrɛkyɩrɛ mʋ yɛ Mosesi nbara mʋ nɩɩ ɔ sa anɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nɩɩ an bɩla nu maa tɔwɛ yɛ Yesu Kanasareti‐nyɩn mʋ biti o boyi Kabwaarɛ‐sunkpa ayɛ mʋ, kɛ ɔ kyɛɛgɛ anɛ anaana atɔ mʋ nɩɩ anɛ naana Mosesi taa sa anɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ɩsɩrayɩ kʋbʋ‐kʋbʋ abɩlɩsa mʋ kpini mʋ nɩɩ ba tɛ asɩn mʋ tɔ mʋ, ba kɩɩ Sitefen kyimm, nɩɩ ba wu mu ansi tɔ ɩ maa du fɛɛ Ɩbwaarɛ kabɔɔ ansi tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nɩɩ Ɩbwaarɛ oseepu bɩlɩsa asɛ mʋ taasɛ Sitefen yɛ, “Asɩn mʋ nɩɩ ba tɔwɛ lɩɩ fʋ sʋ falɛ kpini, ɩ gyɛ kesintin?” ");
INSERT INTO naw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefen lɛɛ kɔnɔ yɛ, “Mɛ‐Sɛ ana yɛ mɛ‐daa ana, fen nu mɛ asɛ! Ɩbwaarɛ bʋnyaa wuya mʋ lɛɛ mʋ n‐yɩɩ kaapʋ anɛ naana Abraham, saŋa mʋ nɩɩ ɔ bʋ Mesopotamiya kasɛ sʋ, pɔyɩ nɩɩ ɔ kʋsʋ ba Haran mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ɩbwaarɛ tɔwɛ mʋ yɛ, ‘Kʋsʋ lɩɩ fʋ ɔsʋwʋlɛ sʋ yɛ fʋ asa asɛ, kɛ fu kpee ɔsʋwʋlɛ mʋ nɩɩ n biti n kaapʋ fʋ falɛ sʋ.’ ");
INSERT INTO naw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ɩmʋ sʋ Abraham lɩɩ Kalidiya ɔsʋwʋlɛ mʋ sʋ nɩɩ ɔ naa kyɩna Haran. Mʋ‐sɛ lewu kamaa nɩɩ Ɩbwaarɛ yɛgɛ nɩɩ ɔ lɩɩ tʋtɔ naa kyɩna ɔsʋwʋlɛ mʋ nɩɩ ndaga fan tɛ sʋ falɛ. ");
INSERT INTO naw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ɩbwaarɛ man pɩɩta taa kasɛ mʋ ntɩn kʋ sa mʋ, halɩɩ kɩyaa tantan tɔ kasɛ gbaa man pɩɩta biliŋi mʋ lɛɛ. Amaa Ɩbwaarɛ da mʋ kɔkɔlɔ sʋ tɔwɛ yɛ ɔsʋwʋlɛ mʋ ii biti o be biliŋi maa mʋ anaana‐bii lɛɛ nɩn. Yɛgɛ saŋa maa Abraham man pɩɩta kʋʋgɛ. ");
INSERT INTO naw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Asɩn nɩmʋ nɩɩ Ɩbwaarɛ tɔwɛ Abraham yɛ, ‘Fʋ anaana‐bii bee biti ba naa biliŋi afɔ ɔkʋ ɔsʋwʋlɛ sʋ, kɛ ba taa bamʋ biliŋi anyɛ kɛ ba nyanla bamʋ nsu alɩfa ana. ");
INSERT INTO naw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","N biti n bɩɩtɛ asa mʋ nɩɩ ba biliŋaa bamʋ anyɛ mʋ asʋ, ɩmʋ kamaa mʋ, fʋ anaana‐bii mʋ bee biti ba lɩɩ kanɩn ɔsʋwʋlɛ maŋa sʋ kɛ ba be sun mɛ nfɩɩ’. ");
INSERT INTO naw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nɩɩ Ɩbwaarɛ maa Abraham ba nyɛ katɔwɛ kyula fɛɛ, mʋ yɛ mʋ kamaa tɔ kpini ba tɩŋɛ iduu. Ɩmʋ sʋ Abraham maa kʋʋgɛ Isaki mʋ ɔ tɩn mʋ oduu kakɛ buruwasapu, nɩɩ Isaki kʋʋgɛ Gyekobu nɩɩ ɔ tɩn mʋ oduu, nɩɩ Gyekobu kʋʋgɛ anɛ naana ana kudu‐anyɔ mʋ, nɩɩ ɔ tɩŋɛ bamʋ kpini iduu. ");
INSERT INTO naw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Gyosefu mʋ nɩɩ ɔ gyɛ kudu anyɔ mʋ tɔ ɔkʋ mʋ, mʋ daa ana ba nyɛ mʋ sʋ kayɩɩ basa, nɩɩ ba fɛ mʋ fɛɛ kɩnyɛ sa Egyipiti abi. ");
INSERT INTO naw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nɩɩ Ɩbwaarɛ lɛɛ Gyosefu lɩɩ mʋ awʋrʋfɔ kpini tɔ, nɩɩ ɔ sa mʋ kanyaasɩn mʋ nɩɩ ɩ yɛgɛ nɩɩ ɔ nyɛ kebiti lɩɩ Egyipiti Owura Faro asɛ. Ɩmʋ sʋ nɩɩ o yii mʋ kuwura fɛɛ ɔ kɩɩ mʋ owura‐kpa yɛ Egyipiti ɔsʋwʋlɛ kpini sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Nɩɩ akʋn damantɛ ɩ ba tɩyɛ Egyipiti yɛ Kaanan ɩsʋwʋlɛ sʋ, nɩɩ ɩ bɩya awʋrʋfɔ gaa. Nɩɩ anɛ naana ana ba man nyɛ agyitɔ. ");
INSERT INTO naw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bamʋ‐sɛ Gyekobu maa nu fɛɛ agyitɔ ɩ bʋ Egyipiti mʋ, o sun mu‐bii ana mʋ nɩɩ ba gyɛ anɛ naana ana kpee tʋtɔ kɩgyankpaasa ba naa sɔɔ agyitɔ. ");
INSERT INTO naw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ba maa bwii kpee Egyipiti kɩnyɔsapʋ ba naa sɔɔ agyitɔ mʋ, Gyosefu lɛɛ mʋ n‐yɩɩ kaapʋ mʋ‐daa ana, nɩɩ Faro gbaa nu Gyosefu mʋ kʋʋpʋ ana sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kamaa tɔ mʋ Gyosefu sun yɛ ba naa taa mʋ‐sɛ Gyekobu yɛ mʋ kʋʋpʋ ana mʋ nɩɩ bɛ waa fɛɛ asa adusunɔ yɛ anu mʋ kpini ba mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nɩɩ Gyekobu kʋsʋ kpee Egyipiti, tʋtɔ nɩɩ maa mu‐bii ana ba naa wu. ");
INSERT INTO naw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nɩɩ ba bwiiyaa bamʋ ba Sekem ba pula kakyan mʋ nɩɩ Abraham sɔɔ lɩɩ Hamo mu‐bii ana asɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Saŋa mʋ nɩɩ Ɩbwaarɛ kɔkɔlɔ kɩda sa Abraham maa tiri tɔ fɛɛ ɩ ba tɔ mʋ, anɛ asa mʋ ba nyɛ akyɔ Egyipiti ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kanɩn saŋa maa nɩɩ owura pʋpwɛ kʋ ba kyɩna Egyipiti kagya sʋ, amaa ɔ man nyi Gyosefu asɩn. ");
INSERT INTO naw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nɩɩ owura pʋpwɛ nɩmʋ nyanla anɛ asa nɩɩ ɔ waa bamʋ awʋrʋfɔ. Nɩɩ ɔ nyan bamʋ yɛ ba lɛɛ bamʋ nbii pʋpwɛ kewu kɛ ɔ mɔɔ bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Saŋa maŋa tɔ nɩɩ ba kʋʋgɛ Mosesi nɩɩ ɔ gyɛ kebii danbɩrasa Ɩbwaarɛ asɛ nɩɩ mʋ kɩbaabʋtɔ kwɩɩ. Nɩɩ ba baala mʋ, kɩɩ mʋ sʋ ɩbwaayɩ ɩsa mʋ‐sɛ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ɩmʋ kamaa tɔ mʋ, ba lɛɛ mʋ kewu nɩɩ Owura Faro mu‐bii kyɩɩsa taa mʋ naa bɩla nɩɩ o biliŋi mu‐bii. ");
INSERT INTO naw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nɩɩ ba kaapʋ Mosesi, nɩɩ ɔ nyɛ Egyipiti abi kɩbɩɩla yɛ bamʋ kanyaasɩn, nɩɩ ɔ sʋ kinyi yɛ katɔwɛ yɛ awaasa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mosesi maa gyii nsu adɩna kamaa mʋ, ɔ waa mʋ nfɛɛrɛ fɛɛ o kpee ɔ naa bɔɔ mʋ ayɛ abi Ɩsɩrayɩ abi sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tʋtɔ maa nɩɩ o wu Egyipiti ɔnyɩn kʋ maa nyanla Ɩsɩrayɩ ɔnyɩn kʋ. Ɩmʋ sʋ Mosesi naa kɔɔlɛ mʋ yɛgɛ nɩɩ ɔ mɔɔ Egyipiti ɔnyɩn mʋ ka kʋkɔ. ");
INSERT INTO naw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosesi nyi fɛɛ mʋ ayɛ abi bee biti ba bɩɩ fɛɛ, mʋ nɩɩ Ɩbwaarɛ biti ɔ bɔla sʋ mɔlɩgɛ bamʋ, amaa ba man bɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lɩɩkaakɛ mʋ, Mosesi ba tu Ɩsɩrayɩ abi asa anyɔ ba maa kɔ. Maa biti ɔ barɩgɛ bamʋ tɔ mʋ, ɔ taasɛ bamʋ yɛ, ‘Fan gyɛ asa kʋlʋn nɩn, mɩnɛ ɩ waa nɩɩ fɛn nyanla abaa kanɩn?’ ");
INSERT INTO naw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Nɩɩ ɔmʋ nɩɩ ɛɛ nyanla mʋ bɩrɩsa mʋ nin Mosesi naa yɩlɛ ɩkaa sʋ nɩɩ ɔ taasɛ yɛ, ‘Anɩmʋ ɩ yɩla fʋ yɛ fʋ kɩɩ anɛ sʋ kɛ fu gyii anɛ asɩn? ");
INSERT INTO naw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fii biti fʋ mɔɔ mɛ fɛɛ kanan mʋ nɩɩ ndee fʋ mɔɔ Egyipiti ɔnyɩn mʋ nɩn?’ ");
INSERT INTO naw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosesi maa nu kanɩn mʋ ɔ sɩlɛ lɩɩ Egyipiti kpee Midiyan ɔsʋwʋlɛ sʋ, naa kyɩna fɛɛ ɔfɔ. Tʋtɔ maŋa nɩɩ ɔ kʋʋgɛ nbii nnyɔ. ");
INSERT INTO naw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Mosesi maa kyɩna tʋtɔ nsu adɩna kamaa mʋ, Ɩbwaarɛ kabɔɔ lɛɛ mʋ n‐yɩɩ kaapʋ mʋ, kɩpʋnfa mʋ nɩɩ kɩ dɛɛ ofuli sʋ mʋ, nɩɩ ɩ maa Sinayi kɩbɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Maa wu falɛ atɔ mʋ, ɩ waa mʋ kanankʋ. Maa nin tiri kɛ ɔ kɩɩ danbɩrasa mʋ, o nu Ɩbwaarɛ maa tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mɛ ɩ gyɛ fʋ naana ana Ɩbwaarɛ, Abraham yɛ Isaki yɛ Gyekobu Ɩbwaarɛ.’ Mosesi maa yɩnŋɛ nɩɩ kufuu kɩ kɩtaa mʋ gaa sʋ mʋ, ɔ man bɩla taalɛ kɩɩ kʋtɔ maŋa. ");
INSERT INTO naw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Nɩɩ Ɩbwaarɛ tɔwɛ mʋ yɛ, ‘Lɛɛ fʋ asɩbɩta, lɩɩ fɛɛ ntɩn mʋ nɩɩ fʋ yɩlɛ mʋ gyɛ kasɛ kyɩrɛkyɩrɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kesintin, n wu kanan mʋ nɩɩ bɛɛ nyanla mɛ asa Egyipiti tɔ. Nɩɩ n nu bamʋ kusu, nɩɩ n kpɩlɩgɛ ba n ba mɔlɩgɛ bamʋ. Kanɩn sʋ n sun fʋ kɛ fʋ bwii kpee Egyipiti tɔ.’ ");
INSERT INTO naw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mosesi kʋlʋn mʋ nɩɩ mʋ asa ba kina mʋ, tɔwɛ mʋ yɛ, ‘Anɩmʋ ɩ yɩla fʋ anɛ ɔkɩɩsʋpʋ yɛ asɩn ogyipu?’ mʋ, mʋ ɩ gyɛ ɔsa mʋ nɩɩ Ɩbwaarɛ bɩla bɔla mʋ kabɔɔ sʋ fʋlɔn nnɔ‐bi tɔ yɛ, ɔ naa waa bamʋ ɔkɩɩsʋpʋ yɛ ɔmɔlɩgɛpʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ɔ lɛɛ bamʋ lɩɩ Egyipiti nɩɩ ɔ waa asɩn kyinkyinsa yɛ adangana Egyipiti tɔ yɛ ɔpʋ pɩpɛɛ mʋ asɛ, nɩɩ ba gyii nsu adɩna ofuli mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mosesi nɩmʋ ɩ tɔwɛ Ɩsɩrayɩ abi yɛ, ‘Ɩbwaarɛ ii biti ɔ lɛɛ mʋ ɔtɔwɛpʋ pʋpwɛ lɩɩ fanɛ tɔ fɛɛ kanan mʋ nɩɩ ɔ lɛɛ mɛ mʋ’. ");
INSERT INTO naw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosesi nɩmʋ tii Ɩsɩrayɩ kʋbʋ mʋ sʋ lɩɩ saŋa mʋ nɩɩ ba bʋ ofuli sʋ mʋ. Mosesi maa anɛ naana ana yɛ Ɩbwaarɛ kabɔɔ mʋ ba bʋ tʋtɔ. Sɩnayɩ kɩbɩɩ mʋ sʋ nɩɩ ɔ kɔɔlɛ nkpa asɩn mʋ lɩɩ Ɩbwaarɛ kabɔɔ mʋ asɛ yɛ ɔ taa bɩya anɛ. ");
INSERT INTO naw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ba waa kʋsʋ tɔ ɔlʋn nɩɩ ba man nu Mosesi asɛ, nɩɩ bamʋ nkɔlɔ tɔ mʋ, naafɔɔ ba daa nyɛ nɩn bee biti ba bwii kpee Egyipiti. ");
INSERT INTO naw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nɩɩ ba tɔwɛ Aron yɛ, ‘Mosesi mʋ nɩɩ ɔ lɛɛ anɛ lɩɩ Egyipiti mʋ, a man nyi kʋtɔ mʋ nɩɩ kɩ waa mʋ kɩbɩɩ Sɩnayɩ sʋ. Ɩmʋ sʋ waa ɩdakpa sa anɛ kɛ bɛɛ gyankpaa anɛ.’ ");
INSERT INTO naw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kanɩn saŋa maa tɔ mʋ nɩɩ ba pɔyɩ kanaatɛ‐bi taa biliŋi bamʋ ɔdakpa. Nɩɩ ba lɔŋɔ ɔdakpa maŋa yɛgɛ bee gyii bamʋ ansi lɩɩ kʋtɔ mʋ nɩɩ ba taa bamʋ abaa pɔyɩ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ɩmʋ sʋ Ɩbwaarɛ palɛ mʋ kamaa sa bamʋ yɛ ba kyaga sʋ be sun kyɔwɛ yɛ ɔbwaayɩ yɛ akyikpebi, fɛɛ kanan mʋ nɩɩ ba wʋla kyʋrɔɔ waa Ɩbwaarɛ atɔwɛpʋ ɩwʋlɛ tɔ yɛ, ‘Ɩsɩrayɩ abi! Man gyɛ mɛ nɩɩ fɛn daa fɛn lɔŋɔ atɔbwaaya fɛn sa nsu adɩna ofuli sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Fanɛ nkɔlɔ ɩ gyan ɔdakpa Moleki yɛ ɔdakpa Refan mʋ nɩɩ ɩ gyɛ fanɛ kikyikpebi ɔdakpa, mʋ nɩɩ fan taa fanɛ abaa pɔyɩ nɩɩ fen sun mʋ sʋ nɩn. Ɩmʋ sʋ n biti n yɛgɛ fanɛ akiisipu ba taa fanɛ kpee kata‐kata kyʋn Babilon sʋ’. ");
INSERT INTO naw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Saŋa mʋ nɩɩ anɛ naana ana ba naa ba naa ofuli mʋ sʋ mʋ, ba sʋ Ɩbwaarɛ kubuu lala mʋ nɩɩ ɩ kaapʋ fɛɛ Ɩbwaarɛ bʋ bamʋ asɛ. Ba waa kɩmʋ nɩn fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ lɛɛ kaapʋ Mosesi yɛ ɔ waa kɩmʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ɩmʋ kamaa mʋ, anɛ naana ana ba nyɛ Ɩbwaarɛ kubuu mʋ, lɩɩ bamʋ‐sɛ ana asɛ, nɩɩ Gyosuwa maa bamʋ ba sʋla Ɩbwaarɛ kubuu lala maŋa, naa fʋʋ ɩsʋwʋlɛ mʋ nɩɩ Ɩbwaarɛ gya asɛ lɩɩ ɩmʋ tɔ asa, nɩɩ ɔ yɛgɛ nɩɩ anɛ asa ba kyɩna tʋtɔ mʋ. Nɩɩ kubuu mʋ sii tʋtɔ naa fʋʋ halɩɩ Dawidi saŋa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawidi mʋ nɩɩ Ɩbwaarɛ ansi gyii mʋ sʋ mʋ kʋlɛ fɛɛ Ɩbwaarɛ ɔ yɛgɛ ɔ pɔyɩ osunkpa ayɛ sa Ɩbwaarɛ mʋ nɩɩ ɔ gyɛ anɛ naana Gyekobu Ɩbwaarɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amaa mu‐bii Solomon ɩ gyɛ ɔsa mʋ nɩɩ ɔ ba pɔyɩ kabwaarɛ‐sunkpa ayɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Amaa Ɩbwaarɛ Owura lala mɛɛ kyɩna akpaara mʋ nɩɩ asa ba taa bamʋ abaa pɔyɩ mʋ tɔ, fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ bɔla mʋ ɔtɔwɛpʋ sʋ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Sʋsʋ ɩ gyɛ mɛ kuwura gya, nɩɩ kasɛ mɔɔ ɩ gyɛ mɛ ayaa ɔgyagakpa. Mɩnɛ obu nɩɩ fen biti fan pɔyɩ sa mɛ? Abɛɛ fɩnɛ ɩ taalɛ waa mɛ ɔkyɩnakpa? ");
INSERT INTO naw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Man gyɛ mɛ gbaa‐gbaa mɛ ɩ waa ɩnɩmʋ kpini?’ ");
INSERT INTO naw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Fan gyɛ asʋ tɔ ɔlʋn wuya ana, nɩɩ fan kina Ɩbwaarɛ fanɛ nkɔlɔ tɔ, nɩɩ fan waa akpawu sa abwaarɛsɩn mʋ. Fan dan fan du nɩn fɛɛ fanɛ naana ana, mʋ nɩɩ bɛɛ kɔ bee tii Kayaayu Kyɩrɛkyɩrɛ mʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ɩbwaarɛ ɔtɔwɛpʋ mɔɔ ɩ kyɩna nɩɩ fanɛ naana ana ba man nyanla mʋ? Ba mɔɔ Ɩbwaarɛ atɔwɛpʋ gaalaagaa mʋ nɩɩ dɩdaa ba wʋla tɔwɛ ɔkpa kyiigisa wuya mʋ kɩba asɩn. Nɩɩ nbɩɩnbɩɩ fan waa mʋ kadɛ‐boyi nɩɩ fan mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Fanɛ ɩ nyɛ Ɩbwaarɛ nbara mʋ nɩɩ Ɩbwaarɛ nbɔɔ ba taa bɩya fanɛ mʋ, amaa fan kina ɩmʋ ki buu.” ");
INSERT INTO naw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ɩsɩrayɩ kʋbʋ‐kʋbʋ mʋ nɩɩ ba gyaŋɛ mʋ ba maa nu Sitefen asɛ mʋ, ba nyɛ agbʋ nɩɩ ba duŋi bamʋ anobi. ");
INSERT INTO naw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amaa Sitefen mʋ nɩɩ Kayaayu Kyɩrɛkyɩrɛ kɩ bɔla mʋ tɔ mʋ, diyaa mu ansi kɩɩ sʋsʋ nɩɩ o wu Ɩbwaarɛ bʋnyaa, nɩɩ o wu Yesu maa yɩlɛ Ɩbwaarɛ gyisa sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nɩɩ Sitefen yɛ, “Fan kɩɩ! N wu sʋsʋ maa bugi nɩɩ n wu Yesu, Daadimaadi Obii‐nyɩnsa mʋ maa yɩlɛ Ɩbwaarɛ gyisa sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Maa tɔwɛ kanɩn kamaa tɔ mʋ ba tii bamʋ asʋ nɩɩ ba kuusi kenken. Tʋtɔ nɩɩ bamʋ kpini ba naa mili mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nɩɩ ba bɩɩtɛ mʋ lɩɩ kadɛ mʋ tɔ naa twɩɩ mʋ abuu. Nyamaanyɩlɛpʋ mʋ ba taa bamʋ ɩkaalɛ sa kɩyaafɔlɛ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Sɔɔlɩ yɛ ɔ kɩɩ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Saŋa mʋ nɩɩ bɛɛ twɩɩ mʋ abuu mʋ, Sitefen kʋlɛ kabwaarɛ‐kʋlɛ yɛ, “Ɔnyɩrɩpɛ Yesu, kɔɔlɛ mɛ kala.” ");
INSERT INTO naw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nɩɩ Sitefen muŋa mʋ ayaa muli sʋ tɔwɛ kenken yɛ, “Ɔnyɩrɩpɛ Yesu, man taa alibi mʋ nɩɩ ba waa falɛ ka bamʋ kʋkɔ.” Maa tɔwɛ kanɩn mʋ nɩɩ o wu. ");
INSERT INTO naw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔɔlɩ gbaa bʋ tʋtɔ nɩɩ o kyula Sitefen kelewu mʋ. Kanɩn kakɛ maŋa nɩɩ kanyanla kɩ ba Krisito abi kʋbʋ mʋ nɩɩ ba bʋ Gyerusalem mʋ sʋ, nɩɩ bamʋ kpini ba yaasɛ tɔ loo Gyudeya maa Samariya ɩsʋwʋlɛ sʋ. Amaa Krisito asunpu mʋ nkʋn ɩ man yaasɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nɩɩ anyɩn mʋ nɩɩ bee sun Ɩbwaarɛ mʋ akʋ ɩ lɛɛ bamʋ n‐yɩɩ naa pula Sitefen, nɩɩ ba su mʋ keli. ");
INSERT INTO naw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amaa Sɔɔlɩ bɩrɛ piili ee nyita Krisito abi kʋbʋ mʋ, yɛgɛ ɔ naa akpaara‐akpaara sʋ ɛɛ bɩɩtɛ anyɩn yɛ akyɩɩ mʋ nɩɩ ba buu Yesu mʋ ee kpee ee tii ibu. ");
INSERT INTO naw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nɩɩ bamʋ nɩɩ ba yaasɛ tɔ mʋ ba naa bɛɛ tɔwɛ Yesu asɩn danbɩrasa katɩn kʋmaa mʋ nɩɩ ba kpee mʋ. ");
INSERT INTO naw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nɩɩ Filipu gbaa kpee Samariya kadɛ lala kʋ tɔ naa tɔwɛ Yesu asɩn. ");
INSERT INTO naw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Saŋa mʋ nɩɩ kʋbʋ damantɛ mʋ nu Filipu asɛ nɩɩ ba wu asɩn kyinkyinsa yɛ ɩsɩnkaala mʋ nɩɩ ɔ waa mʋ, ba kan bamʋ asʋ ba nu mʋ katɔwɛ. ");
INSERT INTO naw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nɩɩ nbwɩɩ libi ba kuusi kenken lɩɩ asa gaalaagaa tɔ, nɩɩ amʋgʋlɛ‐mʋgʋlɛ yɛ aboobi gaalaagaa ba nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ɩmʋ sʋ kensi‐gyii lala kɩ ba kadɛ lala maŋa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kanɩn saŋa maŋa tɔ mʋ, ɔnyɩn kʋ bʋ tɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Simon, nɩɩ ɔ gyɛ Sɩtaanɛ adangana ɔwaapʋ mʋ nɩɩ ɔ bʋ Samariya kadɛ mʋ tɔ. Nɩɩ mʋ awaasa mʋ ɩ waa Samariya abi kɩyan. Ɩmʋ sʋ ɛɛ kaapʋ mʋ n‐yɩɩ yɛ ɔ gyɛ nyɩmɩsa kparɛ. ");
INSERT INTO naw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Lɩɩ falɛ sʋ mʋ asa kparɛ yɛ asansa mʋ kpini bɛɛ nu mʋ asɛ nɩɩ bɛɛ tɔwɛ yɛ, “Ɔnɩmʋ ɩ gyɛ Ɩbwaarɛ ɔlʋn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ ‘Ɔlʋn lala mʋ’.” ");
INSERT INTO naw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɔ waa Sɩtaanɛ adangana ɩnɩmʋ kyɛɛrɛɛ, nɩɩ ɩ waa bamʋ kɩyan nɩɩ ɔ nyɛ asa bee nu mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amaa saŋa mʋ nɩɩ Filipu taa Yesu Krisito kɩtɩɩ tɔ tɔwɛ asɩn danbɩrasa lɩɩ Ɩbwaarɛ kuwura‐gyii sʋ mʋ, asa mʋ ba kɔɔlɛ asɩn mʋ gyii. Nɩɩ ba gyee anyɩn yɛ akyɩɩ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nɩɩ Simon mʋ gbaa wu asɩn kyinkyinsa yɛ ɩsɩnkaala mʋ nɩɩ Filipu waa mʋ, ɩ waa mʋ kanankʋ. Nɩɩ ɔ kɔɔlɛ gyii, nɩɩ ba gyee mʋ Ɩbwaarɛ kekyugyee, nɩɩ o buu Filipu kpee katɩn kʋmaa. ");
INSERT INTO naw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Saŋa mʋ nɩɩ Krisito asunpu mʋ nɩɩ ba bʋ Gyerusalem ba nu yɛ Samariya abi ba kɔɔlɛ Ɩbwaarɛ asɩn mʋ gyii mʋ, ba sun Pita maa Gyɔn bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ba maa fʋʋ bamʋ asɛ mʋ, ba kʋlɛ kabwaarɛ‐kʋlɛ sa bamʋ yɛ, Ɩbwaarɛ ɔ sa bamʋ Kayaayu Kyɩrɛkyɩrɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Lɩɩ fɛɛ saŋa mʋ nɩɩ ba taa Yesu kɩtɩɩ tɔ gyee bamʋ Ɩbwaarɛ kekyugyee mʋ, ba man pɩɩta nyɛ Kayaayu Kyɩrɛkyɩrɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tʋtɔ nɩɩ Pita maa Gyɔn ba taa bamʋ abaa gyaga bamʋ sʋ kʋlɛ kabwaarɛ‐kʋlɛ nɩɩ ba nyɛ Kayaayu Kyɩrɛkyɩrɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon mʋ maa wu fɛɛ Pita maa Gyɔn ba taa bamʋ abaa gyaga akɔɔlɛ‐gyipu mʋ sʋ nɩɩ ba nyɛ Kayaayu Kyɩrɛkyɩrɛ mʋ, Simon biti fɛɛ ɔ sa Pita maa Gyɔn afulee. Nɩɩ ɔ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Fan sa mɛ kanɩn ɔlʋn maŋa, nɩɩ saŋa kʋmaa nɩɩ ngbaa mɛ n kan taa mɛ abaa gyaga ɔkʋmaa sʋ mʋ, kɛ ɔ nyɛ Kayaayu Kyɩrɛkyɩrɛ maŋa.” ");
INSERT INTO naw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amaa Pita tɔwɛ Simon yɛ, “Faa fʋ afulee a biliŋi kɩyan. Lɩɩ fɛɛ fʋ fɛ nfɛɛrɛ fɛɛ fɩɩ taalɛ taa afulee sɔɔ Ɩbwaarɛ kakɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Fʋ man tii sʋ abɛɛ fʋ man sʋ ɔ lɛɛ lɩɩ Ɩbwaarɛ kakɛɛ kusun nɩmʋ tɔ. Lɩɩ fɛɛ fʋ kɔkɔlɔ kɩ man dɛ Ɩbwaarɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kanɩn sʋ kyɛɛgɛ fʋ nfɛɛrɛ libi kɛ fʋ kʋlɛ Ɩbwaarɛ. Akʋtɔ fɛɛ nfɛɛrɛ mʋ nɩɩ fʋ fɛ fʋ kɔkɔlɔ tɔ mʋ Ɩbwaarɛ ii biti ɔ taa kɛɛ fʋ. ");
INSERT INTO naw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ɩnɩmʋ ɩ yɛgɛ nɩɩ n wu fɛɛ kayɩɩ basa kɩ bʋ fʋ tɔ gaa, nɩɩ alibi ɩ bɔla fʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tʋtɔ nɩɩ Simon lɛɛ kɔnɔ yɛ, “Kʋlɛ Ɔnyɩrɩpɛ sa mɛ kɛ ɩmʋ nɩɩ fʋ tɔwɛ falɛ ɩ man ba mɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita maa Gyɔn ba gyii Yesu asɩn mʋ kesintin, nɩɩ ba tɔwɛ asɩn mʋ gaa sa bamʋ. Kamaa tɔ mʋ, ba bwii kpee Gyerusalem. Saŋa mʋ nɩɩ bee bwii bee kpee mʋ, ba tɔwɛ asɩn danbɩrasa mʋ Samariya ndɛ‐bii gaalaagaa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nɩɩ Ɔnyɩrɩpɛ kabɔɔ tɔwɛ Filipu yɛ, “Kʋsʋ kpee akpɩlɩgɛ ɔkpa mʋ nɩɩ kɩɩ dɛ ofuli sʋ mʋ. Kanɩn ɔkpa maŋa kɩ dɛ lɩɩ Gyerusalem naa fʋʋ Gasa kadɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ɩmʋ sʋ Filipu kʋsʋ yii ɔkpa sʋ ee kpee. Maa kpee mʋ, nɩɩ ɔ naa gyaŋa Etiyopiya ɔwʋlɛ nyipu kparɛ mʋ nɩɩ ɛɛ kɩɩ Etiyopiya owura kyɩɩsa afulee sʋ. Ɔnyɩn nɩmʋ kpee Gyerusalem naa sun Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Saŋa maŋa tɔ mʋ, ɔ tɛ mʋ ɩgbaŋɛ mʋ nɩɩ bɛɛ bɩɩtɛ asa ɔkyɩnakpa sʋ ee bwii ee kpewu yɛgɛ ɛɛ kalɛ Ɩbwaarɛ ɔtɔwɛpʋ Isaya ɔwʋlɛ. ");
INSERT INTO naw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nɩɩ Ɩbwaarɛ Kayaayu tɔwɛ Filipu yɛ, “Kpe kanɩn ɩgbaŋɛ nɩmʋ asɛ naa yɩlɛ tiri mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tʋtɔ nɩɩ Filipu sɩlɛ kpee Etiyopiya‐nyɩn mʋ asɛ, nɩɩ o nu ɔnyɩn mʋ maa kalɛ Ɩbwaarɛ ɔtɔwɛpʋ Isaya ɔwʋlɛ. Nɩɩ Filipu taasɛ mʋ yɛ, “Ɩmʋ nɩɩ fɩɩ kalɛ falɛ fii nu kasɛ?” ");
INSERT INTO naw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nɩɩ ɔnyɩn mʋ lɛɛ kɔnɔ yɛ, “Nɛnɛ nɩɩ n waa nu kasɛ amɔɔ n nyɛ ɔkʋ kɛ ɔ lɛɛ kasɛ sa mɛ.” Ɩmʋ sʋ ɔ tɩɩ Filipu yɛ ɔ ba kyɩna tiri mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nɩɩ ɔnyɩn mʋ ɩɩ kalɛ ɛɛ lɩɩ Ɩbwaarɛ Asɩnkyan yɩlɛsa mʋ tɔ yɛ, “O du fɛɛ kabʋlʋpʋ mʋ nɩɩ ba sʋ mʋ ba naa mɔɔ mʋ, abɛɛ kabʋlʋpʋ mʋ nɩɩ be kyiigi mʋ ifuu, yɛgɛ ɔ man bugi mʋ kɔnɔ halɩɩ ee su. ");
INSERT INTO naw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nɩɩ ba gyila mʋ ipeeli, nɩɩ ba man gyii kesintin sa mʋ. Nɩɩ ɔkʋ man taalɛ tɔwɛ kaapʋ mʋ kɩnaana, lɩɩ fɛɛ ba tɩn mʋ nkpa sʋ kasɛ sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nɩɩ ɔnyɩn mʋ taasɛ Filipu yɛ, “Ɔbɩlɩsa, n kʋlɛ fʋ lɛɛ kasɛ sa mɛ. Ɩbwaarɛ ɔtɔwɛpʋ mʋ, ɩ tɔwɛ mʋ n‐yɩɩ sʋ asɩn nɩn abɛɛ ɔkʋ lɛɛ nɩɩ ɛɛ tɔwɛ?” ");
INSERT INTO naw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tʋtɔ nɩɩ Filipu piili ɛɛ tɔwɛ mʋ Asɩnkyan yɩlasa mʋ nɩɩ ɔ kalɛ lɩɩ Isaya ɔwʋlɛ tɔ mʋ, nɩɩ ɔ tɔwɛ Yesu n‐yɩɩ sʋ asɩn danbɩrasa mʋ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Saŋa mʋ nɩɩ ba naa ɔkpa mʋ tɔ bee kpee mʋ, ba naa tu nkyu kʋ ɩ maa dɛ. Nɩɩ Etiyopiya‐nyɩn mʋ tɔwɛ Filipu yɛ, “Kɩɩ nkyu ndee, mɩnɛ i tii mɛ Ɩbwaarɛ kekyugyee ɔkpa?” ");
INSERT INTO naw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nɩɩ Filipu tɔwɛ mʋ yɛ, “Fʋ nyɛ nɩɩ fʋ kɔɔlɛ gyii fʋ kɔkɔlɔ tɔ bɩrɛ, fii biti fʋ nyɛ Ɩbwaarɛ kekyugyee.” Nɩɩ ɔnyɩn mʋ lɛɛ kɔnɔ yɛ, “N kɔɔlɛ gyii fɛɛ Yesu Krisito ɩ gyɛ Ɩbwaarɛ mu‐bii kʋlʋn mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nɩɩ Etiyopiya‐nyɩn mʋ yɛgɛ mʋ gbaŋɛ mʋ yɩla. Nɩɩ maa Filipu kpini ba kpɩlɩgɛ loo nkyu mʋ tɔ. Nɩɩ Filipu gyee mʋ Ɩbwaarɛ kekyu gyee. ");
INSERT INTO naw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Saŋa mʋ nɩɩ ba lɩɩ nkyu mʋ tɔ mʋ, opula maŋa tɔ nɩɩ Ɔnyɩrɩpɛ Kayaayu taa Filipu lɩɩ ɔnyɩn mu ansi sʋ, nɩɩ ɔ man bɩla wu mʋ. Nɩɩ ɔ taa kensi‐gyii kyaga mʋ ɔkpa sʋ ee kpewu. ");
INSERT INTO naw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nɩɩ ɩ taa Filipu naa lɩɩ Asotusi kadɛ tɔ. Nɩɩ ɔ natɛ ndɛ mʋ nɩɩ ɩ bʋ tʋtɔ mʋ kpini, ɛɛ tɔwɛ asɩn danbɩrasa halɩɩ ɔ naa fʋʋ Kasariya ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saŋa maŋa tɔ mʋ, Sɔɔlɩ dan san ɔ yɩlɛ sʋ, ɔ sʋ kanyanla yɛ kɩmɔɔ aŋala lɩɩ Ɔnyɩrɩpɛ Yesu abuupu mʋ sʋ. Kanɩn sʋ o kpee Ɩbwaarɛ Oseepu bɩlɩsa asɛ mʋ asɛ, ");
INSERT INTO naw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nɩɩ ɔ naa tɔwɛ mʋ yɛ ɔ sa mʋ ɩwʋlɛ mʋ nɩɩ ɩ sa ɔkpa fɛɛ o kpee kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa mʋ nɩɩ ɩ bʋ Damasiko kadɛ mʋ tɔ, kɛ ɔ naa kɩtaa anyɩn yɛ akyɩɩ mʋ nɩɩ bee buu Yesu kɩkaapʋ mʋ. Nɩɩ ɔ kan nyɛ kanɩn abuupu maŋa kɛ ɔ kɩtaa bamʋ bwii ba Gyerusalem ba tii obu. ");
INSERT INTO naw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nɩɩ Sɔɔlɩ maa naa ee kpee mʋ, ɔ naa tiri Damasiko kadɛ lala mʋ. Opula tɔ nɩɩ kʋtɔ kʋ kɩ lɩɩ sʋsʋ ba tɩn mu ansi sʋ fɛɛ bʋlayɩ maa wɛɛ ɩsɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nɩɩ ɩ tɩn mʋ tʋʋ kasɛ nɩɩ o nu ɔbʋlɛ kʋ maa taasɛ yɛ, “Sɔɔlɩ, Sɔɔlɩ, mɩnɛ waa nɩɩ fii kisi mɛ kanɩn?” ");
INSERT INTO naw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nɩɩ Sɔɔlɩ taasɛ yɛ, “Ɔnyɩrɩpɛ, fʋ anɩmʋ nɩn?” Nɩɩ ɔbʋlɛ mʋ yɛ, “Ɩ gyɛ mɛ Yesu mʋ nɩɩ fii kisi mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ɩmʋ sʋ kʋsʋ kpee Damasiko kadɛ lala mʋ tɔ, tʋtɔ nɩɩ bee biti ba tɔwɛ fʋ kʋtɔ mʋ nɩɩ fʋ waa.” ");
INSERT INTO naw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nɩɩ anyɩn mʋ nɩɩ ba maa Sɔɔlɩ ba naa mʋ, ba nu katɔwɛ mʋ, amaa ba man wu ɔkʋ. Nɩɩ kufuu kɩ kɩtaa bamʋ, nɩɩ be sii ba yɩlɛ ba man bɩla bugi bamʋ nnɔ. ");
INSERT INTO naw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nɩɩ Sɔɔlɩ kʋsʋ maa yɩlɛ nɩɩ o bugi mu ansi mʋ, ɔ man bɩla ɔ kɩɩ. Ɩmʋ sʋ ba sii kɩtaa mʋ kɩbaa tɔ nɩn taa mʋ kpee Damasiko. ");
INSERT INTO naw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nɩɩ Sɔɔlɩ biliŋi gyaatanapʋ nkɛ nsa, o mee gyii yɛgɛ o mee nu. ");
INSERT INTO naw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nɩɩ Yesu ɔbɩɩlapʋ kʋ bʋ Damasiko kadɛ tɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Ananiyasi. Nɩɩ Ɔnyɩrɩpɛ Yesu lɛɛ ansi sʋ atɔ kaapʋ mʋ, nɩɩ ɔ tɩɩ mʋ yɛ, “Ananiyasi.” Nɩɩ ɔ lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ n kyula.” ");
INSERT INTO naw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nɩɩ Ɔnyɩrɩpɛ mʋ tɔwɛ Ananiyasi yɛ, “Kʋsʋ kpee Gyudasi kɩkpaara mʋ nɩɩ kɩ bʋ kigbenbi kyiigisa mʋ sʋ, naa taasɛ ɔnyɩn mʋ nɩɩ ɔ lɩɩ Tasusi kadɛ tɔ nɩɩ bɛ tɩɩ mʋ yɛ Sɔɔlɩ mʋ. Ɔ bʋ tʋtɔ ɛɛ kʋlɛ kabwaarɛ‐kʋlɛ.” ");
INSERT INTO naw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nɩɩ Sɔɔlɩ gbaa wu ansi sʋ kɩlɛɛkaapʋ mʋ tɔ, fɛɛ ɔnyɩn mʋ nɩɩ bɛ tɩɩ mʋ yɛ Ananiyasi maa ba kɛ ɔ ba taa mʋ abaa gyaga mʋ sʋ kɛ mu ansi i bugi. ");
INSERT INTO naw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Amaa Ananiyasi lɛɛ kɔnɔ yɛ, “Ɔnyɩrɩpɛ, n nu asɩn damantɛ lɩɩ ɔnyɩn nɩmʋ sʋ, kanan mʋ nɩɩ ɔ nyanla fʋ asa kyɩrɛkyɩrɛ mʋ nɩɩ ba bʋ Gyerusalem mʋ. ");
INSERT INTO naw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","An nu yɛ Sɔɔlɩ nɩmʋ nyɛ ɔlʋn lɩɩ oseepu bɩlɩsa asɛ ba Damasiko nfɩɩ, ɔ ba kɩtaa asa mʋ nɩɩ bɛɛ tɩɩ fʋ Yesu kɩtɩɩ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amaa Ɔnyɩrɩpɛ Yesu tɔwɛ Ananiyasi yɛ, “Kʋsʋ kpee! Lɩɩ fɛɛ mɛ ɩ lɛɛ ɔnyɩn nɩmʋ fɛɛ mɛ kɩbaa tɔ nyɩmɩsa, kɛ ɔ taa mɛ asɩn mʋ naa tɔwɛ bamʋ nɩɩ be mee sun Ɩbwaarɛ, yɛ ba maa bamʋ awura, yɛ Ɩsɩrayɩ abi. ");
INSERT INTO naw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nɩɩ mɛ gbaa‐gbaa mɛ n biti n kaapʋ mʋ kanan mʋ nɩɩ ee biti o gyii awʋrʋfɔ lɩɩ mɛ kɩtɩɩ sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tʋtɔ nɩɩ Ananiyasi kpee kɩkpaara mʋ sʋ nɩɩ ɔ naa taa mʋ abaa gyaga Sɔɔlɩ sʋ. Nɩɩ ɔ tɔwɛ yɛ, “Mɛ bɩrɩsa Sɔɔlɩ, Ɔnyɩrɩpɛ Yesu mʋ nɩɩ ɔ lɛɛ mʋ n‐yɩɩ kaapʋ fʋ saŋa mʋ nɩɩ fɩɩ ba nfɩɩ mʋ, i sun mɛ fʋ asɛ kɛ fu ansi i bwii bugi, kɛ fʋ nyɛ Kayaayu Kyɩrɛkyɩrɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nɩɩ opula tɔ atɔ kʋ fɛɛ ɔkɩn agyafɔyɩ ɩ lɩɩ Sɔɔlɩ ansi tɔ tɩyɛ, nɩɩ mu ansi i bugi. Nɩɩ ɔ kʋsʋ nɩɩ ba naa gyee mʋ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Maa gyii agyitɔ kamaa tɔ mʋ, ɔ nyɛ ɔlʋn. Nɩɩ Sɔɔlɩ gyii nkɛ nkʋ Damasiko Yesu abuupu mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tʋtɔ nɩɩ ɔ lɩɩ kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa naa tɔwɛ Yesu asɩn yɛ, “Yesu ɩ gyɛ Ɩbwaarɛ mu‐bii.” ");
INSERT INTO naw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Asa mʋ nɩɩ ba nu Sɔɔlɩ katɔwɛ mʋ, ɩ waa bamʋ kɩyan nɩɩ ba taasɛ yɛ, “Man gyɛ ɔnyɩn nɩmʋ ɩ kyɩna ɛɛ nyanla asa mʋ nɩɩ ba bʋ Gyerusalem bɛɛ tɔwɛ asɩn Yesu kɩtɩɩ tɔ mʋ? Nɩɩ man gyɛ kanɩn sʋ nɩɩ o bwii ba, kɛ ɔ ba kɩtaa bamʋ naa sa Ɩbwaarɛ oseepu bɩlɩsa o tii obu?” ");
INSERT INTO naw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Amaa Sɔɔlɩ nyɛ ɔlʋn tii sʋ nɩɩ ɛɛ tɔwɛ, ɛɛ kaapʋ tɔ yɛ Yesu ɩ gyɛ ɔmʋnɩ Ɩbwaarɛ lɛɛ yɛ ɔ ba mɔlɩgɛ asa. Nɩɩ i kyinkyin Gyiwu abi mʋ nɩɩ ba bʋ Damasiko kadɛ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nɩɩ ɩmʋ kamaa tɔ ɩ maa gyii nkɛ nkʋ mʋ Gyiwu abi ba ŋmina yɛ ba mɔɔ Sɔɔlɩ. ");
INSERT INTO naw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Amaa Sɔɔlɩ bɩɩ bamʋ nfɛɛrɛ lɩɩ mʋ kɩmɔɔ mʋ sʋ lɩɩ fɛɛ ba sii ba tɛ bɛɛ kɩɩ kadɛ mʋ nwusunɔ mʋ sʋ kakyʋwapɛ yɛ kagyanbwɛ kʋmaa kanan mʋ nɩɩ ba nyɛ mʋ mɔɔ. ");
INSERT INTO naw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Amaa Yesu abuupu ba taa mʋ waa kɩlantan tɔ kakyanbwɛ, baala mʋ taa mʋ bʋlɛ kɩbandɩyɛ ɔbɔ tɔ kpɩlɩgaa mʋ yii. ");
INSERT INTO naw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saŋa mʋ nɩɩ Sɔɔlɩ kpee Gyerusalem mʋ, o biti fɛɛ ɔ taa mʋ n‐yɩɩ naa tii abɩɩlapʋ mʋ sʋ, amaa ba waa kufuu yɛ mʋ, lɩɩ fɛɛ ba man kɔɔlɛ mʋ gyii yɛ o tii Yesu abuupu mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tʋtɔ nɩɩ Banabasi taa mʋ kpee asunpu mʋ asɛ. Nɩɩ ɔ tɔwɛ bamʋ kanan mʋ nɩɩ Sɔɔlɩ wu Ɔnyɩrɩpɛ mʋ Damasiko ɔkpa tɔ, yɛ kanan mʋ nɩɩ Ɔnyɩrɩpɛ tɔwɛ Sɔɔlɩ mʋ. Nɩɩ ɔ bɩla tɔwɛ bamʋ kanan mʋ nɩɩ Sɔɔlɩ man waa kufuu, nɩɩ ɔ yɩlɛ tɔwɛ lɩɩ Yesu Krisito kɩtɩɩ tɔ Damasiko kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ɩmʋ sʋ Sɔɔlɩ kyɩna bamʋ asɛ Gyerusalem yɛgɛ ɔ sʋ Ɔnyɩrɩpɛ mʋ kɩtɩɩ tɔ ɛɛ tɔwɛ yɛgɛ ɔ man sʋ kufuu. ");
INSERT INTO naw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nɩɩ Sɔɔlɩ maa Giriki abi mʋ nɩɩ bɛɛ tɔwɛ Gyiwu katɔwɛ mʋ, ba gyii abaa ɩmɔɔrɛ, amaa yɛgɛ ba biti mʋ kɩmɔɔ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Saŋa mʋ nɩɩ mʋ tɔɔmaa ana ba bɩɩ kanɩn mʋ, ba taa mʋ kpee Kasariya kadɛ tɔ, nɩɩ ɔ naa kyaga sʋ kpee mʋ kadɛ tɔ Tasusi. ");
INSERT INTO naw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ɩmʋ sʋ Krisito abi kʋbʋ‐kʋbʋ mʋ nɩɩ ɩ bʋ Gyudeya yɛ Galile yɛ Samariya kpini ba nyɛ kayɩɩ yuuli. Nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ waa bamʋ aniya tɔ, nɩɩ ba nyɛ akyɔ bɛɛ kpan bamʋ n‐yɩɩ, yɛgɛ ba sɩlɛ Ɔnyɩrɩpɛ. ");
INSERT INTO naw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nɩɩ Pita kʋsʋ ɔ naa ɔ naa ɩsʋwʋlɛ mʋ sʋ, nɩɩ ɔ naa bɔɔ akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ Lida mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tʋtɔ nɩɩ ɔ naa wu ɔnyɩn mʋ nɩɩ mʋ n‐yɩɩ i wu, nɩɩ ɔ dɛ nsu nburuwa nɩɩ bɛ tɩɩ mʋ yɛ Aneyasi. ");
INSERT INTO naw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nɩɩ Pita tɔwɛ mʋ yɛ, “Aneyasi, kʋsʋ taa fʋ kalan, Yesu Krisito kyɛ fʋ.” Opula tɔ nɩɩ ɔ kʋsʋ. ");
INSERT INTO naw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ɩmʋ sʋ asa mʋ nɩɩ ba bʋ Lida yɛ Saron mʋ kpini ba maa wu kanɩn mʋ, nɩɩ ba kyɛɛgɛ bamʋ nfɛɛrɛ biliŋi ba Ɔnyɩrɩpɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nɩɩ Gyopa kadɛ tɔ ɔkyɩɩ kɔɔlɛ‐gyipu kʋ bʋ tʋtɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Tabita. Tabita ɩmʋ Giriki katɔwɛ ɩ gyɛ yɛ Dokasi. Dokasi maŋa ɩ waa adanbɩrasa yɛgɛ ɛɛ kyɛ atiripu tɔ saŋa kʋmaa. ");
INSERT INTO naw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kanɩn saŋa maa mʋ kɩlɔ kɩ daa ɔkyɩɩ mʋ, nɩɩ o wu. Nɩɩ ba gyee mʋ kubuni naa dɩɩla abansʋrʋ obu to. ");
INSERT INTO naw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida kadɛ kɩ man bʋ kata yɛ Gyopa kadɛ. Ɩmʋ sʋ Yesu abuupu mʋ ba maa nu fɛɛ Pita bʋ Lida mʋ, nɩɩ ba sun anyɩn anyɔ Pita asɛ naa tɔwɛ mʋ yɛ, “Waa bilen kɛ fʋ ba anɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ɩmʋ sʋ Pita maa bamʋ nɩɩ ba sun mʋ asɛ mʋ, ba bwii kpee Gyopa. Nɩɩ ba taa Pita kpee abansʋrʋ obu mʋ tɔ, ntɩn mʋ nɩɩ obuni mʋ dɛ mʋ. Nɩɩ akulapu‐kyɩɩ mʋ nɩɩ ba bʋ obu mʋ tɔ mʋ kpini, ba kyaabɔɔ Pita bɛ sawʋ yɛgɛ ba sʋ atɔ bunsa mʋ nɩɩ Dokasi baata sa bamʋ saŋa mʋ nɩɩ ɔ tɛ nkpa tɔ mʋ bɛɛ kaapʋ Pita. ");
INSERT INTO naw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Amaa nɩɩ Pita tɔwɛ bamʋ nɩɩ ba bʋ obu mʋ tɔ kpini yɛ, ba lɩɩ kewu. Nɩɩ Pita muŋa mʋ ayaa muuli sʋ kʋlɛ kabwaarɛ‐kʋlɛ, nɩɩ o biliŋi mu ansi kaapʋ obuni mʋ, nɩɩ ɔ tɔwɛ yɛ, “Tabita, kʋsʋ.” Nɩɩ o bugi mʋ ansi wu Pita, nɩɩ ɔ kʋsʋ kyɩna. ");
INSERT INTO naw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nɩɩ Pita kɩtaa mʋ kɩbaa tɔ kʋsaa mʋ yɩlɛ. Tʋtɔ nɩɩ ɔ tɩɩ akɔɔlɛ‐gyipu yɛ akulapu‐kyɩɩ mʋ taa ɔkyɩɩ mʋ nɩɩ o kyiŋi mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Falɛ asɩn nɩmʋ ɩ yaasɛ loo Gyopa kadɛ tɔ kpini. Nɩɩ asa gaalaagaa ba kɔɔlɛ Ɔnyɩrɩpɛ Yesu mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nɩɩ Pita kyɩna Gyopa kadɛ tɔ, ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ Simon nɩɩ ɔ gyɛ gbansaba mʋ asɛ nkɛ nnyɔ kʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ɔbɩlɩsa kʋ bʋ tɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Koneliyo. Nɩɩ ɔ tɛ Kasariya kadɛ tɔ. Ɔ kyɩna ɔ gyɛ anaakɔpʋ ɔbɩlɩsa sa Roma anaakɔpʋ kʋbʋ mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ Itali abi kʋbʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Maa mʋ kʋʋpʋ ana ba taa bamʋ n‐yɩɩ sa Ɩbwaarɛ nɩɩ ba sɩlɛ Ɩbwaarɛ. Ɔ gyɛ ɔsa mʋ nɩɩ ɛɛ kɛɛ atiripu atɔ nɩɩ ɔ bɩla ɔ sʋ saŋa sa kabwaarɛ‐kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kanyɩn nɩmʋ nyɛ kɩlɛɛkaapʋ kakɛ kʋ kakyʋwapɛ ɩ waa fɛɛ kerefi asa saŋa tɔ. O wu Ɩbwaarɛ kabɔɔ maa ba mʋ asɛ nɩɩ ɔ tɩɩ mʋ yɛ, “Koneliyo!” ");
INSERT INTO naw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nɩɩ ɔ kɩɩ mʋ yɛ kufuu nɩɩ ɔ taasɛ mʋ yɛ, “Ɔnyɩrɩpɛ mɩnɛ nɩn?” Nɩɩ kabɔɔ mʋ tɔwɛ mʋ yɛ, “Ɩbwaarɛ ansi i gyii fʋ kakɛɛ yɛ fʋ kabwaarɛ‐kʋlɛ mʋ sʋ, nɩɩ ee biti o kyula fʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nbɩɩnbɩɩ, sun asa kʋ kpee Gyopa ba naa tɩɩ ɔnyɩn mʋ nɩɩ bɛ tɩɩ mʋ yɛ Simon Pita mʋ ba. ");
INSERT INTO naw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɔ bʋ Simon mʋ nɩɩ ɔ gyɛ gbansaba mʋ ayɛ nɩn, nɩɩ kɩ bʋ kɩ maa ɔpʋ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Saŋa mʋ nɩɩ Ɩbwaarɛ kabɔɔ mʋ ɩ kyʋn mʋ, nɩɩ Koneliyo tɩɩ mʋ ayaafɔlɛ anyɔ yɛ mʋ anaakɔpʋ mʋ tɔ ɔkʋlʋn mʋ nɩɩ ɛɛ waa kʋtɔ kʋmaa ɛɛ sa mʋ, nɩɩ ɔ taa mʋ n‐yɩɩ sa Ɩbwaarɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nɩɩ ɔ tɔwɛ bamʋ kʋtɔ kʋmaa mʋ nɩɩ o wu nɩɩ o sun bamʋ Gyopa. ");
INSERT INTO naw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lɩɩkaakɛ mʋ Koneliyo nbɔɔ ba maa tiri Gyopa mʋ Pita mɔɔ dii kpee abansʋrʋ sʋsʋ ɔ naa kʋlɛ kabwaarɛ‐kʋlɛ kakyʋwapɛ maŋa. ");
INSERT INTO naw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Akʋn a kɩtaa mʋ, nɩɩ ee biti kʋtɔ kʋ o gyii. Saŋa mʋ nɩɩ bɛɛ waa agyitɔ mʋ, nɩɩ ɔ nyɛ ansi sʋ kɩlɛɛkaapʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","O wu sʋsʋ maa bugi nɩɩ o wu kʋtɔ kʋ, maa lɩɩ sʋsʋ fɛɛ kɩtaa lala kɩɩ kpɩlɩgɛ kɩɩ ba kasɛ. Kɩ maa kɩmʋ anobi ana. ");
INSERT INTO naw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kɩtaa mʋ sʋ mʋ, o wu atɔbwaaya kʋmaa yɛ nbwiibi yɛ atɔbwaaya mʋ nɩɩ bɛɛ kpɩɩ ɩtɔ sʋ kpini. ");
INSERT INTO naw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nɩɩ o nu ɔbʋlɛ kʋ maa tɔwɛ mʋ yɛ, “Pita! Kʋsʋ mɔɔ kɛ fu gyii.” ");
INSERT INTO naw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nɩɩ Pita tɔwɛ yɛ, “Ɔnyɩrɩpɛ ayee, n man pɩɩta gyii falɛ ineesi atɔ abɛɛ ɩmʋ nɩɩ ɩ gyɛ anɛ Gyiwu abi ikisii.” ");
INSERT INTO naw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nɩɩ ɔbʋlɛ mʋ bɩla tɔwɛ mʋ yɛ, “Man bɩla tɩɩ kʋtɔ mʋ nɩɩ Ɩbwaarɛ lɔŋɔ kɩmʋ mʋ, yɛ ineesi kʋtɔ.” ");
INSERT INTO naw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɩnɩmʋ ɩ waa kanɩn ɩlɩɩ ɩsa, nɩɩ ɩ taa kɩtaa mʋ yɛ atɔ mʋ bwii kyʋn sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Saŋa mʋ nɩɩ Pita san ɛɛ fɛ ɩmʋ nfɛɛrɛ mʋ, nɩɩ asa mʋ nɩɩ Koneliyo sun mʋ ba bɩɩ Simon kɩkpaara mʋ, nɩɩ ba ba yɩlɛ kɩmʋ kewusunɔ. ");
INSERT INTO naw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nɩɩ ba tɩɩ ɔkʋ taasɛ mʋ yɛ, “Ɔnyɩn kʋ bʋ nfɩɩ nɩɩ bɛ tɩɩ mʋ yɛ Simon Pita?” ");
INSERT INTO naw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Saŋa mʋ nɩɩ Pita san ɛɛ fɛ mʋ kɩlɛɛkaapʋ mʋ nfɛɛrɛ mʋ, nɩɩ Ɩbwaarɛ Kayaayu tɔwɛ mʋ yɛ, “Anyɩn asa akʋ bee biti fʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ɩmʋ sʋ kpɩlɩgɛ kpee bamʋ asɛ, man kan kina katɩn kʋmaa mʋ nɩɩ faa bamʋ fen biti fan kpee, lɩɩ fɛɛ mɛ ɩ sun bamʋ fʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nɩɩ Pita kpɩlɩgɛ ba kasɛ tɔ nɩɩ ɔ tɔwɛ anyɩn mʋ yɛ, “Mɛ ɩ gyɛ ɔmʋ nɩɩ fen biti mʋ. Mɩnɛ ɩ waa?” ");
INSERT INTO naw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nɩɩ anyɩn mʋ ba lɛɛ kɔnɔ yɛ “Anaakɔpʋ ɔbɩlɩsa mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Koneliyo mʋ i sun anɛ. Ɔ gyɛ ɔsa mʋ nɩɩ mʋ ɩkpa i kyiigi nɩɩ ɔ sɩlɛ Ɩbwaarɛ, nɩɩ Gyiwu abi kpini bɛ sa mʋ bɛɛrɛɛ. Ɩbwaarɛ kabɔɔ mʋ ɩ tɔwɛ mʋ yɛ ɔ tɩɩ fʋ ba mʋ kɩkpaara sʋ, kɛ o nu kʋtɔ mʋ nɩɩ fʋ sʋ sa mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nɩɩ Pita taa anyɩn mʋ loo kɩkpaara mʋ sʋ, nɩɩ ɔ kɔɔlɛ bamʋ, kɩtaa bamʋ kɩfɔ. Lɩɩkaakɛ mʋ, nɩɩ Pita maa Yesu abɩɩlapʋ akʋ mʋ nɩɩ ba lɩɩ Gyopa mʋ ba buu bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ɩmʋ lɩɩkaakɛ nɩɩ ba fʋʋ Kasariya. Yɛgɛ Koneliyo maa mʋ kʋʋpʋ ana yɛ mʋ kyɛmɩnɛ ana ba sarɛ bee gyoo mʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita maa biti o loo kɩkpaara mʋ sʋ mʋ, nɩɩ Koneliyo gyaŋa mʋ, nɩɩ o muŋa o sun mʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Amaa Pita kɩtaa mʋ kɩbaa tɔ nɩɩ ɔ tɔwɛ mʋ yɛ “Kʋsʋ yɩlɛ! Ngbaa mɛ n dan n gyɛ nyɩmɩsa nɩn fɛɛ fʋ falɛ!” ");
INSERT INTO naw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Saŋa mʋ nɩɩ maa Pita bɛɛ waa kiligyima bee loo kɩkpaara mʋ sʋ mʋ, ɔ naa tu asa ba maa sarɛ ba tɛ. ");
INSERT INTO naw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nɩɩ Pita tɔwɛ bamʋ yɛ, “Fanɛ gbaa‐gbaa fanɛ fan dan fen nyi fɛɛ naafɔɔ ɩ man dɛ ɔkpa fɛɛ Gyiwu nyɩmɩsa maa bʋga ɔmʋ nɩɩ o mee sun Ɩbwaarɛ abɛɛ ɔ bɔɔ mʋ sʋ. Amaa Ɩbwaarɛ kaapʋ mɛ fɛɛ n man tɔwɛ ɔkʋ yɛ ɔ man du kyɩrɛkyɩrɛ. ");
INSERT INTO naw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ɩmʋ sʋ fan maa sun tɩɩ mɛ mʋ n man kina, kanɩn sʋ fan tɔwɛ mɛ kʋtɔ mʋ sʋ nɩɩ fan tɩɩ mɛ.” ");
INSERT INTO naw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nɩɩ Koneliyo lɛɛ kɔnɔ yɛ, “Ndaga nkɛ nna nɩmʋ n maa kʋlɛ kabwaarɛ‐kʋlɛ kerefi asa kakyʋwapɛ saŋa mʋ. Opula tɔ nɩɩ n wu ɔnyɩn kʋ maa bun kaalɛ fufuli ba yɩlɛ mi ansi tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nɩɩ ɔ tɔwɛ mɛ yɛ, “Koneliyo Ɩbwaarɛ nu fʋ kabwaarɛ‐kʋlɛ, nɩɩ o wu fʋ kakɛɛ mʋ nɩɩ fɩɩ kɛɛ atiripu mʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ɩmʋ sʋ sun asa kpee Gyopa kɛ ba naa tɩɩ ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Simon Pita mʋ, nɩɩ ɔ gyɛ ɔfɔ ɔ bʋ Simon mʋ nɩɩ ɔ gyɛ gbansaba nɩɩ mʋ kɩkpaara bʋ mata ɔpʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɩmʋ sʋ nɩɩ n sun tɩɩ fʋ bilen, nɩɩ ɩ bʋrɔn fɛɛ fʋ maa ba. Nbɩɩnbɩɩ an gyaŋɛ Ɩbwaarɛ ansi tɔ an nu fʋ asɛ asɩn mʋ nɩɩ Ɔnyɩrɩpɛ taa sa fʋ yɛ fʋ ba tɔwɛ anɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nɩɩ Pita tɔwɛ yɛ, “Nbɩɩnbɩɩ bɩrɛ n bɩɩ fɛɛ ɩ gyɛ kesintin Ɩbwaarɛ mɛɛ kɩɩ nyɩmɩsa ansi tɔ pɔyɩ nɩɩ ɛɛ waa kʋtɔ kʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ɩbwaarɛ ɩ kɔɔlɛ ɔkʋmaa mʋ nɩɩ ɔ bʋ ndɛndɛmandɛ ɔ sɩlɛ mʋ, nɩɩ ɛɛ waa ɩmʋ nɩɩ ɩ dagaa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Fanɛ gbaa‐gbaa fan nu asɩn mʋ nɩɩ Ɩbwaarɛ taa bɩya Gyiwu abi nɩɩ ɔ bɔla Yesu Krisito mʋ nɩɩ ɔ gyɛ dulinyaa tɔ atɔ kpini Ɔnyɩrɩpɛ sʋ taa kayɩɩ yuuli asɩn danbɩrasa sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nɩɩ fan nyi asɩn kparɛ mʋ nɩɩ ɩ waa Gyiwu ɔsʋwʋlɛ sʋ nɩɩ i piili lɩɩ Galile mʋ. Ɩ waa saŋa mʋ nɩɩ Gyɔn tɔwɛ Ɩbwaarɛ kekyugyee asɩn mʋ kamaa. ");
INSERT INTO naw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Fan nu Yesu Kanasareti‐nyɩn mʋ asɩn, kanan mʋ nɩɩ Ɩbwaarɛ taa mʋ Kayaayu Kyɩrɛkyɩrɛ yɛ ɔlʋn bɔla mʋ tɔ mʋ. Lɩɩ fɛɛ Ɩbwaarɛ tii mʋ sʋ, nɩɩ katɩn kʋmaa mʋ nɩɩ o kpee mʋ ɛɛ waa adanbɩrasa yɛgɛ ɛɛ kyɛ ɔkʋmaa mʋ nɩɩ Sɩtaanɛ bʋ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Kʋtɔ mʋ nɩɩ ɔ waa Gyerusalem yɛ Ɩsɩrayɩ kpini‐kpini mʋ, anɛ asunpu nɩmʋ an gyɛ ɩmʋ kesintin agyipu. Ba da mʋ oyu laasa sʋ mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amaa nkɛ nsa kamaa tɔ mʋ Ɩbwaarɛ kyiŋi mʋ lɩɩ lewu tɔ. Nɩɩ Ɩbwaarɛ yɛgɛ nɩɩ ɔ lɛɛ mʋ n‐yɩɩ kaapʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Man gyɛ ɔkʋmaa nɩmʋ nɩɩ ɔ lɛɛ mʋ n‐yɩɩ kaapʋ amɔɔ anɛ mʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ yɛ an baa an gyɛ mʋ kesintin agyipu mʋ maa wu kyiŋi kamaa tɔ mʋ ana mʋ a bʋga gyii nɩɩ an nu. ");
INSERT INTO naw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nɩɩ Yesu sa anɛ kɔnɔ yɛ a taa tɔwɛ Abwaarɛsɩn mʋ sa Gyiwu kasɛ sʋ asa kpini. Kɛ a lɛɛ kesintin mʋ kaapʋ fɛɛ mʋ ɩ gyɛ asa kɩɩsa yɛ alewupu kpini ɔtalɛpʋ. ");
INSERT INTO naw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ɩbwaarɛ atɔwɛpʋ mʋ kpini ba tɔwɛ mʋ asɩn mʋ kaapʋ tɔ yɛ ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ mʋ gyii mʋ, lɩɩ mʋ kɩtɩɩ tɔ sʋ mʋ Ɩbwaarɛ ii biti ɔ taa mu alibi kɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita maa san ɛɛ tɔwɛ mʋ, Kayaayu Kyɩrɛkyɩrɛ mʋ ba loo bamʋ nɩɩ bee nu asɩn mʋ kpini tɔ. ");
INSERT INTO naw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","I kyinkyin Gyiwu akɔɔlɛ‐gyipu mʋ nɩɩ ba buu Pita lɩɩ Gyopa ba mʋ gaa, fɛɛ Ɩbwaarɛ maa taa mʋ Kayaayu Kyɩrɛkyɩrɛ mʋ sa bamʋ nɩɩ ba man gyɛ Gyiwu abi. ");
INSERT INTO naw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Lɩɩ fɛɛ ba nu ba maa tɔwɛ ntɔwɛ pʋpwɛ yɛgɛ bɛɛ yɩn Ɩbwaarɛ. Nɩɩ Pita taasɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ba maa nyɛ Kayaayu Kyɩrɛkyɩrɛ fɛɛ kanan mʋ nɩɩ an nyɛ falɛ mʋ, ɔkʋ ɩ taalɛ tii ɔkpa fɛɛ ba man gyee bamʋ Ɩbwaarɛ kekyugyee?” ");
INSERT INTO naw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nɩɩ Pita sa kɔnɔ yɛ ba gyee bamʋ Ɩbwaarɛ kekyugyee lɩɩ Yesu Krisito kɩtɩɩ tɔ. Nɩɩ ba kʋlɛ Pita yɛ ɔ kyɩna bamʋ asɛ nkɛ nyɔ nkʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Krisito asunpu mʋ yɛ akɔɔlɛ‐gyipu mʋ mʋ nɩɩ ba bʋ Gyudeya mʋ kpini ba nu yɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ gbaa ba kɔɔlɛ abwaarɛsɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ɩmʋ sʋ saŋa mʋ nɩɩ Pita bwii kpee Gyerusalem mʋ, akɔɔlɛ‐gyipu mʋ nɩɩ ba yɩlɛ tɔ sa iduu kɩtɩn mʋ ");
INSERT INTO naw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ba tɔwɛ mʋ yɛ, “Fu loo bamʋ nɩɩ ba man tɩn iduu mʋ akpaara sʋ nɩɩ faa bamʋ fan bʋga gyii.” ");
INSERT INTO naw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nɩɩ Pita lɛɛ kasɛ kʋtɔ kʋmaa mʋ nɩɩ kɩ waa kʋkʋlʋn‐kʋkʋlʋn sa bamʋ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kakaakʋ n bʋ Gyopa kadɛ tɔ n kʋlɛ kabwaarɛ kʋlɛ. Nɩɩ n nyɛ ansi sʋ kɩlɛɛkaapʋ wu sʋsʋ maa bugi. Nɩɩ n wu kʋtɔ kʋ maa lɩɩ sʋsʋ fɛɛ kɩtaa lʋʋsa kɩlala, nɩɩ ba sʋ kɩmʋ anobi ana mʋ tɔ ba kasɛ katɩn mʋ nɩɩ n bʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","N maa kɩɩ kɩmʋ tɔ mʋ, n wu atɔbwaaya yɛ nbwiibi yɛ atɔbwaaya mʋ nɩɩ bɛ kpɩɩ ɩtɔ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tʋtɔ nɩɩ n nu ɔbʋlɛ kʋ maa tɔwɛ mɛ yɛ, ‘Pita kʋsʋ mɔɔ kɛ fu gyii.’ ");
INSERT INTO naw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Nɩɩ n lɛɛ kɔnɔ yɛ, ‘Ɔnyɩrɩpɛ ayee, falɛ ineesi atɔ abɛɛ ɩmʋ nɩɩ ɩ gyɛ anɛ Gyiwu abi ii kisi ɩ man pɩɩta loo mɛ kɔnɔ tɔ.’ ");
INSERT INTO naw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Nɩɩ ɔbʋlɛ maŋa bɩla tɔwɛ mɛ yɛ man bɩla tɩɩ kʋtɔ mʋ nɩɩ Ɩbwaarɛ lɔŋɔ kɩmʋ kyɩrɛkyɩrɛ mʋ yɛ ineesi kʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ɩnɩmʋ ɩ waa kanɩn ɩlɩɩ ɩsa, nɩɩ ɩ taa kɩtaa mʋ yɛ atɔ mʋ bwii kyʋn sʋsʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Saŋa maŋa tɔ anyɩn asa mʋ nɩɩ ba sun bamʋ lɩɩ Kasariya ba ba mɛ asɛ mʋ, ba ba yɩlɛ kɩkpaara mʋ nɩɩ n bʋ kɩmʋ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ tɔwɛ mɛ yɛ man kan gyii ɩmɔɔrɛ, faa bamʋ fan kpee. Akɔɔlɛ‐gyipu asiye anɩmʋ mʋ nɩɩ ba lɩɩ Gyopa mʋ i sun mɛ kpee naa loo, ɔnyɩn mʋ kɩkpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ɔ tɔwɛ anɛ kanan mʋ nɩɩ o wu Ɩbwaarɛ kabɔɔ maa ba yɩlɛ mu obu to, nɩɩ ɔ tɔwɛ mʋ yɛ, ‘Sun asa akʋ kpee Gyopa ba naa tɩɩ Simon mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Pita mʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ee biti ɔ tɔwɛ fanɛ kanan mʋ nɩɩ faa fʋ kɩkpaara sʋ abi kpini fan nyɛ kamɔlɩgɛ.’ ");
INSERT INTO naw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“N maa piili n tɔwɛ bamʋ abwaarɛsɩn mʋ, Kayaayu Kyɩrɛkyɩrɛ ba bamʋ tɔ fɛɛ kanan mʋ nɩɩ o loo anɛ tɔ npiili asɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tʋtɔ nɩɩ n nyiŋi asɩn mʋ nɩɩ Ɔnyɩrɩpɛ Yesu wʋla tɔwɛ yɛ, ‘Gyɔn taa nkyu nɩn gyee asa Ɩbwaarɛ kekyugyee. Amaa fanɛɛ fanɛ bɩrɛ, Ɩbwaarɛ ii biti ɔ taa mʋ Kayaayu Kyɩrɛkyɩrɛ gyee fanɛ.’ ");
INSERT INTO naw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ɩmʋ sʋ fɛɛ nɩɩ Ɩbwaarɛ sa bamʋ kakɛɛ kʋlʋn mʋ nɩɩ ɔ sa anɛ saŋa mʋ nɩɩ an kɔɔlɛ Ɔnyɩrɩpɛ Yesu gyii mʋ, mɛ ɩ gyɛ anɩmʋ kɛ n taalɛ tii Ɩbwaarɛ ɔkpa?” ");
INSERT INTO naw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Krisito abuupu mʋ maa nu kanɩn mʋ, ba man bɩla taalɛ tɔwɛ sɛhn, nɩɩ ba yɩn Ɩbwaarɛ. Nɩɩ ba tɔwɛ yɛ Ɩbwaarɛ sa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ gbaa ɔkpa fɛɛ ba yɛgɛ alibi kɩwaa kɛ ba nyɛ nkpa. ");
INSERT INTO naw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Saŋa mʋ nɩɩ ba twɩɩ abuu mɔɔ Sitefen mʋ, kanyanla kɩ ba Yesu akɔɔlɛ‐gyipu mʋ sʋ, nɩɩ akʋ ba yaasɛ tɔ loo Fonesiya yɛ Sipuru yɛ Antiyoki kasɛ sʋ yɛgɛ bɛɛ tɔwɛ Yesu asɩn mʋ bɛɛ sa Gyiwu abi nkʋn. ");
INSERT INTO naw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Yesu akɔɔlɛ‐gyipu akʋ mʋ nɩɩ ba lɩɩ Sipuru yɛ Siren ba Antiyoki mʋ, ba tɔwɛ asɩn danbɩrasa lɩɩ Yesu Krisito sʋ sa Giriki abi gbaa. ");
INSERT INTO naw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ɔnyɩrɩpɛ kɩbaa kɩmaa gyan bamʋ sʋ sʋ mʋ, asa damantɛ ba kɔɔlɛ mʋ gyii nɩɩ ba be buu Ɔnyɩrɩpɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Krisito abi kʋbʋ mʋ nɩɩ ba bʋ Gyerusalem mʋ ba maa nu kanɩn asɩn nɩmʋ mʋ, nɩɩ ba sun Banabasi kpee Antiyoki. ");
INSERT INTO naw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Maa naa fʋʋ tʋtɔ mʋ, nɩɩ o wu kanan mʋ nɩɩ Ɩbwaarɛ bwaala bamʋ mʋ, mu ansi i gyii nɩɩ ɔ waa bamʋ aniya tɔ yɛ ba nyɛ kɔkɔlɔ kʋlʋn Ɔnyɩrɩpɛ kɩkɔɔlɛ‐gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi kyɩna ɔ gyɛ nyɩmɩsa danbɩrasa nɩɩ ɔ sʋ kɩkɔɔlɛ‐gyii kɩkyɔ nɩɩ Kayaayu Kyɩrɛkyɩrɛ bɔla mʋ tɔ lɩɩ kanɩn sʋ asa damantɛ ba ba kɔɔlɛ Ɔnyɩrɩpɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tʋtɔ nɩɩ Banabasi kpee Tasusi kadɛ tɔ ɔ naa biti Sɔɔlɩ. ");
INSERT INTO naw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Maa naa wu mʋ mʋ, o bwiiyaa mʋ ba Antiyoki. Nɩɩ maa mʋ kpini ba sii Yesu abɩɩlapʋ mʋ asɛ kesu laalaamuu yɛgɛ bɛ kaapʋ asa damantɛ. Antiyoki tʋtɔ nɩɩ ba piili kasɛ bɛɛ tɩɩ Yesu abɩɩlapʋ mʋ yɛ Krisito abi. ");
INSERT INTO naw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kanɩn saŋa maŋa tɔ mʋ Ɩbwaarɛ atɔwɛpʋ akʋ ba lɩɩ Gyerusalem kpee Antiyoki. ");
INSERT INTO naw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bamʋ tɔ ɔkʋ mʋ nɩɩ bɛɛ tɩɩ yɛ Agabu mʋ, kʋsʋ yɩlɛ lɩɩ Kayaayu Kyɩrɛkyɩrɛ ɔlʋn tɔ sʋ tɔwɛ yɩla yɛ, akʋn lala a biti a tɛ Roma Ɩsʋwʋlɛ kpini sʋ. (Kanɩn saŋa maŋa mʋ nɩɩ Kuludi gyɛ Roma Owura lala mʋ.) ");
INSERT INTO naw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kanɩn sʋ Yesu abɩɩlapʋ mʋ nɩɩ ba bʋ Antiyoki mʋ, ba taa nfɛɛrɛ fɛɛ ɔkʋmaa nɩmʋ ɔ taa kɩkyɛtɔ mʋ nɩɩ ɛɛ taalɛ nyɛ, kɛ ba taa naa sa Yesu abɩɩlapʋ mʋ nɩɩ ba bʋ Gyudeya mʋ. ");
INSERT INTO naw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nɩɩ ba taa bamʋ nkyɛtɔ mʋ sa Banabasi maa Sɔɔlɩ yɛ ba taa naa sa Krisito abɩɩlapʋ abɩlɩsa mʋ nɩɩ ba bʋ Gyerusalem mʋ. ");
INSERT INTO naw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Saŋa maŋa tɔ nɩɩ Owura Herodi yɛgɛ nɩɩ ba naa kɩtaa Krisito abɩɩlapʋ akʋ, nɩɩ ee biti fɛɛ ɔ nyanla bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ɔ yɛgɛ nɩɩ ba tɩn Gyɔn mʋ‐daa Gyemisi kumu. ");
INSERT INTO naw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Maa wu fɛɛ ɩmʋ nɩɩ ɔ waa mʋ maa pɩrɛ Gyiwu abi mʋ, ɔ kyaga sʋ naa kɩtaa Pita gbaa. Ɩnɩmʋ kpini ɩ waa saŋa mʋ nɩɩ bee gyii Kesu kɔnɔ kɔlɔŋɔ bodobodo mʋ nɩɩ kɩ man sʋ kɩfɛ tinsa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Maa kɩtaa mʋ mʋ, ɔ taa mʋ tii obu nɩɩ ɔ taa mʋ naa waa anaakɔpʋ mʋ nɩɩ ba yɩlɛ ana ntun nna mʋ abaa tɔ yɛ bɛ kɩɩ obu tiisa mʋ sʋ. Herodi waa mʋ nfɛɛrɛ fɛɛ, nɩɩ ba kan gyii Kanyaŋɛ nbunɔ Kesu kɔnɔ kɔlɔŋɔ kyʋn lʋwɛ mʋ, ee biti ɔ lɛɛ Pita ifuli kɛ ba gyii mʋ asɩn. ");
INSERT INTO naw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ɩmʋ sʋ Pita san o tii obu, amaa Krisito abi kʋbʋ mʋ ba payɩ kinsi bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ bɛ sa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ɩmʋ kagyanbwɛ pɔyɩ kayɩ kɩ kɛ, kɛ Owura Herodi lɛɛ mʋ o be gyii mʋ asɩn mʋ, ba da mʋ ɩgbɛɛ yɛgɛ ɔ dɛ anaakɔpʋ anyɔ nsana yɛgɛ anaakɔpʋ akʋ ba bɩla ba yɩlɛ kebunɔ. ");
INSERT INTO naw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Opula maŋa tɔ nɩɩ Ɩbwaarɛ kabɔɔ ba obu tiisa mʋ tɔ nɩɩ ɩ ŋmaŋɛ tɔ, nɩɩ ɔ da Pita kyiŋi, nɩɩ ɔ tɔwɛ mʋ yɛ, “Kʋsʋ yɩlɛ bilen.” Nɩɩ agbeeleebi mʋ nɩɩ ba taa da mʋ ɩgbɛɛ mʋ ɩ saŋɛ ɩ lɩɩ tɩyɛ. ");
INSERT INTO naw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nɩɩ kabɔɔ mʋ tɔwɛ mʋ yɛ, “Bun fʋ atɔ kɛ fʋ waa asɩbɩta, kɛ fu bun fʋ balɩmaasʋ kɛ fʋ buu mɛ.” ");
INSERT INTO naw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nɩɩ Pita buu kabɔɔ mʋ lɩɩ abu tiisa mʋ tɔ, amaa Pita man nyi fɛɛ kʋtɔ mʋ nɩɩ kabɔɔ mʋ ɩ waa mʋ gyɛ kesintin. Ɩ waa mʋ nɩn fɛɛ ɩ gyɛ ansi sʋ kɩlɛɛkaapʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba kyʋn nbunɔ akɩɩsʋpʋ gyankpaasa kɩnyɔsapʋ mʋ sʋ naa fʋʋ kebunɔ mʋ nɩɩ ba taa abɩlɩtɔ waa mʋ, nɩɩ lɩɩ kɩmʋ tɔ taa kpee kadɛ mʋ tɔ mʋ. Ba maa fʋʋ tʋtɔ mʋ nɩɩ kebunɔ mʋ gbaa‐gbaa tigi nɩɩ ba lɩɩ. Ba maa natɛ ɔkpa mʋ sʋ kpee ansi tɔ gbɛrɛɛ mʋ, nɩɩ Ɩbwaarɛ kabɔɔ mʋ kɩ nyaa mu ansi sʋ. ");
INSERT INTO naw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tʋtɔ nɩɩ ɩ ŋmaŋɛ Pita sʋ nɩɩ ɔ tɔwɛ yɛ, “Ɩ gyɛ kesintin nɩn fɛɛ Ɩbwaarɛ sun mʋ kabɔɔ yɛ ɔ ba kɔɔlɛ mɛ lɩɩ Owura Herodi abaa tɔ yɛ kanan mʋ nɩɩ Gyiwu abi ba da ŋmina yɛ ba waa mɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Maa fɛ ɩnɩmʋ kpini nfɛɛrɛ mʋ o kpee Maki Gyɔn mu‐nyi Mɛɛrɩ kɩkpaara sʋ, opula mʋ nɩɩ asa kʋkyɔ, ba gyaŋɛ bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nɩɩ Pita da kewusunɔ ɔpʋnʋ, nɩɩ kibite mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Roda mʋ ba suŋa kɩɩ ɔmʋ nɩɩ ɛɛ daa. ");
INSERT INTO naw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kebite mʋ maa bɩɩ yɛ ɩ gyɛ Pita ɔbʋlɛ mʋ, ɩ maa waa mʋ ɔkɔn gaa sʋ o man tigi ɔpʋnʋ mʋ. Nɩɩ ɔ sɩlɛ naa tɔwɛ bamʋ yɛ Pita ɩ yɩlɛ kewusunɔ. ");
INSERT INTO naw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Roda maa tɔwɛ kanɩn mʋ, nɩɩ ba taasɛ mʋ yɛ, “Fɩɩ lɔ ɩbʋn nɩn?” Maa dan san ɔ yɩlɛ sʋ ɛɛ tɔwɛ yɛ ɩ gyɛ kesintin mʋ, nɩɩ ba yɛ, “Falɛ ɩ gyɛ Ɩbwaarɛ kabɔɔ mʋ nɩɩ ɛɛ kɩɩ Pita sʋ nɩn.” ");
INSERT INTO naw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Amaa Pita dan san ɔ yɩlɛ kewusunɔ ɛɛ daa ɔpʋnʋ mʋ. Ba maa tigi ɔpʋnʋ mʋ, ba wu Pita, nɩɩ ɩ waa bamʋ kɩyan. ");
INSERT INTO naw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nɩɩ Pita nyɛɛ bamʋ kɩbaa yɛ ba bun bamʋ nnɔ sʋ. Nɩɩ ɔ tɔwɛ bamʋ kanan mʋ nɩɩ Ɔnyɩrɩpɛ lɛɛ mʋ lɩɩ obu tiisa mʋ tɔ mʋ. Nɩɩ ɔ yɛ, “Fan naa tɔwɛ sa Gyɔn maa akɔɔlɛ‐gyipu mʋ nɩɩ ba san mʋ, kʋtɔ mʋ nɩɩ kɩ waa.” Pita maa tɔwɛ lʋwɛ mʋ, nɩɩ ɔ lɩɩ bamʋ asɛ kpee katɩnkʋ. ");
INSERT INTO naw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ɩmʋ nyenyenfuu mʋ, nfɛɛrɛ ɩ kɩtaa anaakɔpʋ mʋ, lɩɩ fɛɛ ba man nyi kʋtɔ mʋ nɩɩ kɩ waa Pita. ");
INSERT INTO naw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Owura Herodi sa kɔnɔ yɛ ba naa biti Pita ba. Amaa ba biti mʋ kpɩnɛ nɩɩ ba man wu mʋ. Ɩmʋ sʋ Owura mʋ taasɛ bamʋ kɔnɔ tɔ asɩn kpɩnɛ, nɩɩ ɔ sa kɔnɔ yɛ ba mɔɔ bamʋ kpini. Nɩɩ Owura Herodi lɩɩ Gyudeya kpee Kasariya naa kyɩna tʋtɔ gyii nkɛ gbɛrɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Owura Herodi nyɛ agbʋ lɩɩ Tayi yɛ Sidon abi sʋ. Nɩɩ ba waa kɔnɔ kʋlʋn sun kpee Herodi asɛ. Ba bɔla Owura Herodi kɩyaafɔlɛ bɩlɩsa mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Bilasitu mʋ sʋ, sun ɩmata Herodi asɛ lɩɩ fɛɛ mʋ ɔsʋwʋlɛ sʋ nɩɩ bɛɛ nyɛ bamʋ agyitɔ bɛɛ lɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kakɛ mʋ nɩɩ ba yɩla maa fʋʋ mʋ, Owura Herodi bun mʋ awura tɔ naa kyɩna mʋ kuwura‐gya sʋ, nɩɩ ɔ lɛɛ asɩn mʋ tɔwɛ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nɩɩ asa mʋ ba kuusi nɩɩ ba gyaabii mʋ yɛ, “Ɩnɩmʋ bɩrɛ ɩ man gyɛ nyɩmɩsa ɔbʋlɛ nɩn, amaa Ɩbwaarɛ kʋ ɔbʋlɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lɩɩ fɛɛ Owura Herodi maa man taa kanɩn bʋnyaa sa Ɩbwaarɛ mʋ. Opula maŋa tɔ nɩɩ Ɩbwaarɛ kabɔɔ yɛgɛ nɩɩ kɩlɔ kɩ da mʋ, nɩɩ ɔtɔ tɔ asʋnswɛɛ ba wɛ mʋ mɔɔ. ");
INSERT INTO naw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","“Amaa abwaarɛsɩn mʋ ɩ dan san ɩ kyaga sʋ ɩ yɛlɩgɛ i tii sʋ i kpee ansi tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Saŋa mʋ nɩɩ Banabasi maa Sɔɔlɩ ba lʋwɛ bamʋ kusun mʋ, ba lɩɩ Gyerusalem bwii kpee Antiyoki, nɩɩ ba taa Gyɔn mʋ nɩɩ ba bɩla bɛɛ tɩɩ mʋ yɛ Maki mʋ tii bamʋ n‐yɩɩ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kanɩn saŋa maŋa mʋ Krisito abi kʋbʋ mʋ nɩɩ kɩ bʋ Antiyoki mʋ, Ɩbwaarɛ atɔwɛpʋ yɛ akaapʋpʋ akʋ ba bʋ tʋtɔ. Nɩɩ bamʋ ɩ gyɛ Banabasi, yɛ Simeyon mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Nigya, yɛ Lusiyu mʋ nɩɩ ɔ lɩɩ Siren, yɛ Sɔɔlɩ maa Maniya mʋ nɩɩ ba bɩla maa Herodi bʋga mʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ba maa kyaga sʋ bee sun Ɩbwaarɛ nɩɩ bee ŋmina kɔnɔ mʋ, Kayaayu Kyɩrɛkyɩrɛ mʋ ba tɔwɛ bamʋ yɛ, “Fan lɛɛ Banabasi maa Sɔɔlɩ kɛ ba naa waa kusun mʋ nɩɩ n tɩɩ bamʋ yɛ ba ba waa mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nɩɩ ba bwii ŋmina kɔnɔ kʋlɛ kabwaarɛ‐kʋlɛ taa bamʋ abaa gyaga bamʋ sʋ sa bamʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nɩɩ Kayaayu Kyɩrɛkyɩrɛ maŋa ɩ kaapʋ bamʋ, nɩɩ ɔ gyankpaa bamʋ, nɩɩ ba lɩɩ tʋtɔ kpee Selusiya, nɩɩ ba bɔla nkyu sʋ kpee Sipuru kifintin sʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ba maa fʋʋ Salami mʋ ba tɔwɛ abwaarɛsɩn mʋ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa, nɩɩ Gyɔn Maki gbaa kyɛ bamʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ɩmʋ kamaa ba natɛ kyaabɔɔ kifintin mʋ sʋ kpini naa fʋʋ Pafosi. Tʋtɔ nɩɩ ba tu Kagyiwu‐nyɩn kʋ mu nɩɩ bɛɛ tɩɩ mʋ yɛ Baa‐Yesu. Ɔ sʋ nbwɩɩ libi ɛɛ waa adangana nɩɩ ɔ waa mʋ n‐yɩɩ fɛɛ Ɩbwaarɛ ɔtɔwɛpʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kifintin mʋ sʋ owura mʋ nɩɩ bɛɛ tɩɩ yɛ Segusi Polusi kyɩna ɔ gyɛ Baa Yesu mʋ kyɛmɩnɛ nɩn. Owura mʋ sʋ kanyaasɩn gaa. O sun tɩɩ Banabasi maa Pɔɔlɩ, lɩɩ fɛɛ ee biti o nu abwaarɛsɩn lɩɩ bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Amaa nbwɩɩ libi wuya Baa‐Yesu, nɩɩ mʋ Giriki katɔwɛ tɔ ɩ gyɛ Elimasi mʋ, mee biti fɛɛ owura mʋ o nu kɛ ɔ kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nɩɩ Sɔɔlɩ mʋ nɩɩ bɛ bɩla bɛɛ tɩɩ mʋ Pɔɔlɩ, nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ bɔla mʋ tɔ mʋ, kɩɩ Elimasi kyiim nɩɩ ɔ tɔwɛ mʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Fʋ gyɛ Sɩtaanɛ obii nɩn nɩɩ fʋ gyɛ ɔdʋn sa kesintin kpini. Fʋ naa alibi ɔkpa sʋ fɩɩ pɩna asa, nɩɩ fii biti fu biliŋi Ɔnyɩrɩpɛ asɩn mʋ yɛ ɩ man waa kesintin. ");
INSERT INTO naw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kɩɩ, Ɩbwaarɛ lɛɛ mʋ kɩbaa fʋ sʋ. Fii biti fu biliŋi gyaatanapʋ kɛ fʋ man bɩla wu kyɔwɛ naa fʋʋ saŋa kʋ.” Opula maŋa tɔ nɩɩ ɩ waa mu ansi sʋ kitentenbiri. Nɩɩ o sii ɛɛ kyaabɔɔ ee biti ɔmʋ nɩɩ ɔ kɩtaa mʋ kɩbaa tɔ kaapʋ mʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Owura mʋ maa wu kʋtɔ mʋ nɩɩ kɩ waa mʋ, yɛ abwaarɛsɩn kɩkaapʋ mʋ, ɩ waa mʋ kɩyan nɩɩ ɔ kɔɔlɛ Ɔnyɩrɩpɛ asɩn mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔlɩ maa mʋ kʋbʋ ba lɩɩ Pafosi bɔla nkyu sʋ ba Pega kadɛ mʋ nɩɩ kɩ bʋ Panfiliya ɔsʋwʋlɛ sʋ mʋ. Tʋtɔ nɩɩ ba maa Gyɔn Maki ba barɩgɛ abaa nɩɩ Gyɔn bwii kpee Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Amaa Banabasi maa Pɔɔlɩ ba lɩɩ Pega kpee Antiyoki mʋ nɩɩ kɩ bʋ Pisidiya ɔsʋwʋlɛ sʋ mʋ. Kakɛ fʋʋtɛsa akɛ mʋ, ba kpee Gyiwu abi kabwaarɛ kʋlɛ ɔgyaŋɛkpa tɔ naa kyɩna. ");
INSERT INTO naw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Asa mʋ ɔkʋ maa kalɛ lɩɩ Mosesi nbara ɩwʋlɛ yɛ Ɩbwaarɛ atɔwɛpʋ ɩwʋlɛ lʋwɛ mʋ, tʋtɔ alʋlʋnpʋ ba taa tʋʋ Pɔɔlɩ maa Banabasi ansi tɔ yɛ, “Anɛ bɩrɩsa ana, nɩɩ fan sʋ asɩn tɔwɛ waa asa mʋ, fan tɔwɛ anɛ.” ");
INSERT INTO naw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nɩɩ Pɔɔlɩ kʋsʋ yɩlɛ nɩɩ ɔ kʋsaa mʋ kɩbaa nɩɩ ɔ tɔwɛ yɛ, “Gyiwu abi yɛ fanɛ mʋ nɩɩ fan man gyɛ Gyiwu abi, nɩɩ fen sun Ɩbwaarɛ mʋ, fan nu mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Anɛ Gyiwu abi anɛ Ɩbwaarɛ mʋ, lɛɛ anɛ naana ana nɩɩ ɔ sa bamʋ kanyɛ saŋa mʋ nɩɩ ba bʋ Egyipiti ɔsʋwʋlɛ sʋ, nɩɩ ɔ taa mʋ ɔlʋn lɛɛ bamʋ lɩɩ ɔsʋwʋlɛ maŋa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nɩɩ Ɩbwaarɛ kɩɩ bamʋ sʋ nsu adɩna saŋa mʋ nɩɩ ba bʋ ofuli sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ɩsʋwʋlɛ isunɔ mʋ nɩɩ ɩ bʋ Kena kasɛ sʋ mʋ, Ɩbwaarɛ gya bamʋ lɩɩ tʋtɔ, nɩɩ ɔ taa kasɛ mʋ sa Ɩsɩrayɩ abi nɩɩ ki biliŋi bamʋ kapatɩyɛ. ");
INSERT INTO naw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ɩmʋ kpini ɩ waa nsu alɩfa ana yɛ adunuu. “Kamaa mʋ, nɩɩ Ɩbwaarɛ sa bamʋ atalapʋ naa fʋʋ Ɩbwaarɛ ɔtɔwɛpʋ Samuweli sʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nɩɩ Ɩsɩrayɩ abi ba tɔwɛ Ɩbwaarɛ yɛ ɔ lɛɛ owura sa bamʋ. Nɩɩ ɔ lɛɛ Kiisi mu‐bii Sɔɔlɩ mʋ nɩɩ ɔ lɩɩ Bengyamin kanaan tɔ, nɩɩ o gyii kuwura nsu adɩna. ");
INSERT INTO naw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ɩbwaarɛ maa kʋsaa Sɔɔlɩ mʋ, nɩɩ ɔ taa Dawidi yii Ɩsɩrayɩ kuwura. Nɩɩ Ɩbwaarɛ yɛ, ‘N wu Dawidi. Gyeese mu‐bii mʋ nɩɩ mɛ kɔkɔlɔ ki biti, nɩɩ mʋ ii biti ɔ waa mɛ kɔkɔlɔ biti.’ ");
INSERT INTO naw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Dawidi kanaan tɔ nɩɩ Gyiwu abi Ɔmɔlɩgɛpʋ Yesu mʋ lɩɩ fɛɛ kanan mʋ nɩɩ Ɩbwaarɛ wʋla da mʋ kɔkɔlɔ sʋ tɔwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pɔyɩ Ɔmɔlɩgɛpʋ Yesu ɔ ba mʋ, Gyɔn wʋla gyankpaa ba tɔwɛ Gyiwu abi yɛ ba yɛgɛ alibi kɩwaa, kɛ ba nyɛ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Saŋa mʋ nɩɩ Gyɔn ii biti ɔ lʋwɛ mu kusun mʋ, nɩɩ ɔ taasɛ, ‘Fen nyi fɛɛ mɛ ɩ gyɛ Ɔmɔlɩgɛpʋ mʋ? N man gyɛ mɛ ɩ gyɛ Ɔmɔlɩgɛpʋ mʋ, mɛɛ mʋ ɔ bʋ mɛ kamaa ɛɛ ba. N man dagaa fɛɛ n saŋɛ mu asɩbɩta gbaa.’ ");
INSERT INTO naw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mɛ tɔmaa ana Abraham anaana abi yɛ fanɛ mʋ nɩɩ fan man gyɛ Gyiwu abi nɩɩ fen sun Ɩbwaarɛ mʋ, anɛ sʋ nɩɩ Ɩbwaarɛ sa kamɔlɩgɛ asɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nɩɩ Gyerusalem abi yɛ bamʋ abɩlɩsa kpini ba man bɩɩ fɛɛ Yesu ɩ gyɛ Ɔmɔlɩgɛpʋ mʋ. Yɛgɛ bee nu mʋ asɩn mʋ lɩɩ Ɩbwaarɛ atɔwɛpʋ ɔwʋlɛ tɔ mʋ kakɛ fʋʋtɛsa kʋmaa, amaa ba man nu kasɛ. Ba bun mʋ kʋpwɛ nɩɩ ɩ yɛgɛ asɩn mʋ nɩɩ Ɩbwaarɛ atɔwɛpʋ mʋ ba wʋla tɔwɛ yɩla mʋ ɩ ba tɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yɛgɛ ba man taalɛ wu mu alibi mʋ nɩɩ ɔ waa nɩɩ ɔ dagaa lewu, nɩɩ ba yɛgɛ nɩɩ Ɔbɩlɩsa Paleti mɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ba maa waa ɩmʋ nɩɩ Ɩbwaarɛ atɔwɛpʋ ba wʋla kyʋrɔɔ yɩla lɩɩ mʋ sʋ lʋwɛ mʋ, ba kpɩlɩgaa mʋ lɩɩ oyu laasa mʋ sʋ naa waa kakyan tɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amaa Ɩbwaarɛ kyiŋi mʋ lɩɩ lewu tɔ ba nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nɩɩ nkɛ gaalaagaa mʋ tɔ mʋ, ɔ lɛɛ mʋ n‐yɩɩ kaapʋ bamʋ nɩɩ maa bamʋ ba daa bɛɛ natɛ lɩɩ Galile bee kpee Gyerusalem mʋ. Bamʋ ɩ gyɛ mu kuwu kyiŋi kesintin agyipu bɛɛ sa Gyiwu abi. ");
INSERT INTO naw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Nɩɩ an tɔwɛ falɛ asɩn danbɩrasa mʋ nɩɩ Ɩbwaarɛ da mʋ kɔkɔlɔ sʋ sa anɛ naana ana mʋ sa fanɛ. ");
INSERT INTO naw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kanɩn asɩn maŋa nɩɩ Ɩbwaarɛ yɛgɛ nɩɩ ɩ ba tɔ sa anɛ, mʋ nɩɩ an gyɛ bamʋ‐bii ana mʋ, kpalɩ fɛɛ Ɩbwaarɛ kyiŋi Yesu lɩɩ lewu tɔ sʋ. Fɛɛ kanan mʋ nɩɩ ba kyʋrɔɔ waa Dawidi ɔlʋn nyɔsapʋ mʋ tɔ yɛ, ‘Ndaga n lɛɛ kaapʋ fɛɛ fʋ ɩ gyɛ mi‐bii.’ ");
INSERT INTO naw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kikyiŋi mʋ nɩɩ Ɩbwaarɛ kyiŋi Yesu lɩɩ kelewu tɔ mʋ, nɩɩ ɔ mɛɛ yɛ ɔ gyɔɔ kakaakʋ kɩɩ mʋ, Ɩbwaarɛ tɔwɛ ɩmʋ asɩn gbaa yɛ, ‘N biti n waa fanɛ kusee sa fanɛ atɔ kyɩrɛkyɩrɛ fɛɛ kanan mʋ nɩɩ n da mɛ kɔkɔlɔ sʋ tɔwɛ Dawidi mʋ’. ");
INSERT INTO naw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nɩɩ Dawidi tɔwɛ Ɩbwaarɛ yɛ, ‘Fʋ mɛɛ yɛgɛ kɛ fʋ Ɔkyɩrɛkyɩrɛpʋ mʋ ɔ gyɔɔ nyita’. ");
INSERT INTO naw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Asɩn nɩmʋ man gyɛ Dawidi asɩn, lɩɩ fɛɛ ɔ natɛ Ɩbwaarɛ kebiti sʋ, mʋ saŋa mʋ nɩɩ ɔ kyɩna, nɩɩ o wu, nɩɩ ba pula mʋ naa tii mʋ naana ana sʋ nɩɩ mʋ n‐yɩɩ ɩ gyɔɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amaa Ɔmʋ nɩɩ Ɩbwaarɛ kyiŋi mʋ lɩɩ lewu tɔ mʋ bɩrɛ man gyɔɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Kanan sʋ mɛ bɩrɩsa ana Gyiwu abi, lɩɩ Yesu kɩtɩɩ tɔ sʋ nɩɩ an tɔwɛ alibi kɩtaa kɛɛ asɩn an sa fanɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nɩɩ ɔkʋ man bʋ tɔ ɔ taalɛ gyii lɩɩ Mosesi nbara mʋ kpini sʋ, amaa ɔkʋmaa mʋ nɩɩ ɔ kɔɔlɛ Yesu gyii bɩrɛ, ee biti o gyii lɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ɩmʋ sʋ fan kɩɩ sʋ danbɩrasa kɛ asɩn mʋ nɩɩ Ɩbwaarɛ atɔwɛpʋ ba tɔwɛ yɩla mʋ, ɩ man ba fanɛ sʋ. Asɩn mʋ ɩ gyɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Fanɛ ahin‐sɩn wuya ana, ii biti ɩ waa fanɛ kɩyan fɛɛ kanan mʋ nɩɩ n biti n mɔɔ fanɛ. Lɩɩ fɛɛ fanɛ saŋa nɩmʋ tɔ n biti n waa kʋtɔ kʋ nɩɩ ɔkʋ kan ba tɔwɛ gbaa, fan mɛɛ yɛ fan kɔɔlɛ mʋ gyii’.” ");
INSERT INTO naw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔɔlɩ maa Banabasi ba maa lɩɩ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa tɔ mʋ, nɩɩ asa mʋ ba tɔwɛ bamʋ yɛ ba bɩla bwii ba kakɛ fʋʋtɛsa akɛ, kɛ ba ba tɔwɛ bamʋ asɩn nɩmʋ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Saŋa mʋ nɩɩ asa mʋ ba lɩɩ ɔgyaŋɛkpa nɩɩ ba yaasɛ tɔ mʋ, Gyiwu abi mʋ gaalaagaa, yɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi, nɩɩ ba kyɛɛgɛ bamʋ nfɛɛrɛ ba Gyiwu abi kabwaarɛ‐sunkpa tɔ mʋ, ba buu Pɔɔlɩ maa Banabasi. Nɩɩ ba waa asa mʋ ɔlʋn tɔ tɔwɛ bamʋ yɛ ba kyɩna Ɩbwaarɛ kabwaala mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nɩɩ kakɛ fʋʋtɛsa pʋpwɛ mʋ maa fʋʋ mʋ, kadɛ mʋ tɔ asa kɩbaafʋn mʋ nɩɩ ba kpee mʋ ɩ kyɔ gaa nɩɩ ba naa gyaŋɛ ba nu abwaarɛsɩn. ");
INSERT INTO naw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Amaa Gyiwu abɩlɩsa ba maa wu asa damantɛ ba maa nu Banabasi maa Pɔɔlɩ abwaarɛsɩn mʋ, ba nyɛ bamʋ kayɩɩ basa yɛgɛ bɛɛ tɔwɛ nbusaa asɩn bee nyita asɩn mʋ nɩɩ bɛɛ tɔwɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔɔlɩ maa Banabasi ba yɩlɛ kɩnyɩn tɔ tɔwɛ bamʋ yɛ, “Fanɛ Gyiwu abi nɩɩ ɩ dagaa fɛɛ a maa gyankpaa tɔwɛ abwaarɛsɩn sa pɔyɩ. Amaa fan maa man kɔɔlɛ ɩmʋ gyii nɩɩ fan kɩɩ fanɛ n‐yɩɩ fɛɛ fan man dagaa sa nkpa kakpaa mʋ, an biti a taa asɩn mʋ naa sa bamʋ nɩɩ ba man gyɛ Gyiwu abi. ");
INSERT INTO naw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ɩnɩmʋ nɩɩ Ɔnyɩrɩpɛ Ɩbwaarɛ mʋ sa kɔnɔ tɔwɛ yɛ, ‘N taa fanɛ waa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ fɩtɩla. Kɛ fan taa kamɔlɩgɛ mʋ naa sa asa dulinyaa katɩn kʋmaa’. ");
INSERT INTO naw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","“Nɩɩ bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ ba maa nu falɛ mʋ, ɩ waa bamʋ ɔkɔn gaa, nɩɩ ba taa bʋnyaa sa Ɩbwaarɛ asɩn mʋ. Nɩɩ bamʋ nɩɩ Ɩbwaarɛ lɛɛ bamʋ fɛɛ ba ba nyɛ nkpa kakpaa mʋ ba kɔɔlɛ gyii.” ");
INSERT INTO naw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ɩmʋ sʋ Ɩbwaarɛ asɩn mʋ ɩ yɛlɩgɛ kanɩn ɔsʋwʋlɛ maŋa sʋ kpini. ");
INSERT INTO naw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nɩɩ Gyiwu abi ba fun waa akyɩɩ mʋ nɩɩ ba sɩlɛ Ɩbwaarɛ nɩɩ ba sʋ bɛɛrɛɛ, yɛ anyɩn mʋ nɩɩ ba gyɛ Antiyoki kadɛ mʋ tɔ agyankpaapʋ. Nɩɩ bamʋ kpini ba kʋsʋ yɩlɛ Pɔɔlɩ maa Banabasi sʋ bɛɛ nyanla bamʋ, nɩɩ ba gya bamʋ lɩɩ kanɩn ofuli maŋa sʋ. ");
INSERT INTO naw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nɩɩ Pɔɔlɩ maa Banabasi ba kpɩkpaa bamʋ ayaa ɩsɛ, nɩɩ ba waa bamʋ ahee. Nɩɩ ba lɩɩ tʋtɔ kpee Ikoniyum kadɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yesu abɩɩlapʋ mʋ nɩɩ ba bʋ Antiyoki tʋtɔ mʋ kpini ba nyɛ kensi‐gyii gaa. Nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ bɔla bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Fɛɛ kanan mʋ nɩɩ Pɔɔlɩ maa Banabasi ba wʋla bɛɛ waa mʋ, ba kpee Ikoniyum Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa. Nɩɩ ba tɔwɛ abwaarɛsɩn mʋ, nɩɩ ɩ yɛgɛ nɩɩ Gyiwu abi yɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ gaalaagaa ba kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amaa Gyiwu abi mʋ nɩɩ ba man kɔɔlɛ asɩn mʋ gyii mʋ, ba fun waa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ, nyita bamʋ nfɛɛrɛ nɩɩ ba nyɛ nfɛɛrɛ libi lɩɩ Pɔɔlɩ maa Banabasi sʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔɔlɩ maa Banabasi ba gyii nkɛ gbɛrɛɛ tʋtɔ. Ba yɩlɛ kɩnyɩn tɔ bɛɛ tɔwɛ Ɔnyɩrɩpɛ mʋ kabwaala asɩn. Nɩɩ ngbaa mʋ yɩlɛ bamʋ kamaa nɩɩ ba waa asɩn kyinkyinsa yɛ ɩsɩnkaala. ");
INSERT INTO naw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nɩɩ ɩ yɛgɛ nɩɩ kadɛ mʋ tɔ asa mʋ ba barɩgɛ tɔ ntun nnyɔ, akʋ ba buu Gyiwu abi nɩɩ akʋ mɔɔ ba buu Yesu asunpu mʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Saŋa maŋa mʋ, bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ akʋ yɛ Gyiwu abi, taa tii bamʋ agyankpaapʋ sʋ mʋ ba waa kɔnɔ kʋlʋn fɛɛ ba tɔɔrɔɔ bamʋ kɛ ba tʋʋ bamʋ abuu mɔɔ. ");
INSERT INTO naw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Amaa Pɔɔlɩ maa Banabasi ba maa bɩɩ bamʋ nfɛɛrɛ mʋ, nɩɩ ba sɩlɛ kpee Lisitira yɛ Debe ndɛ yɛ ndɛ‐bii mʋ nɩɩ ɩ bʋ Likoniya ɔsʋwʋlɛ sʋ kpini. ");
INSERT INTO naw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tʋtɔ nɩɩ ba kyaga sʋ tɔwɛ asɩn danbɩrasa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ɔnyɩn kʋ tɛ Lisitira tʋtɔ nɩɩ ba kʋʋgɛ mʋ ayaa yɛ abaa wusa wuya ana, nɩɩ ɔ man natɛ kakaakʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ɔ tɛ tʋtɔ ee nu Pɔɔlɩ maa tɔwɛ. Nɩɩ Pɔɔlɩ kɩɩ mʋ kyimm wu fɛɛ ɔnyɩn mʋ sʋ kɩkɔɔlɛ‐gyii, nɩɩ ɔ taalɛ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nɩɩ Pɔɔlɩ pʋntɛ yɛ, “Kʋsʋ yɩlɛ fʋ ayaa sʋ.” Tʋtɔ nɩɩ ɔnyɩn mʋ fugi yɩlɛ mʋ ayaa sʋ nɩɩ o piili ɔ naa. ");
INSERT INTO naw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sakyɔ mʋ maa wu kʋtɔ mʋ nɩɩ Pɔɔlɩ waa mʋ, ba kuusi Likoniya katɔwɛ tɔ yɛ, “Anɛ ɩdakpa mʋ ba biliŋi asa ba anɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nɩɩ ba sa Banabasi kɩtɩɩ yɛ Sewu, nɩɩ ba sa Pɔɔlɩ gbaa kɩtɩɩ yɛ Hemesi lɩɩ fɛɛ mʋ ɩ gyɛ asɩn mʋ ɔtɔwɛpʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nɩɩ ɔdakpa Sewu oseepu obu yɩlɛ kadɛ mʋ ɩkaa sʋ. Nɩɩ kɩmʋ oseepu taa ɩnaa‐nyɩn yɛ ntʋtʋlɛ ba kadɛ mʋ kewusunɔ, lɩɩ fɛɛ maa sakyɔ mʋ bee biti ba waa kɔlɔŋɔ sa Krisito asunpu mʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amaa ba maa nu kanɩn mʋ, ba kɩtaa bamʋ atɔ bunsa kyatɛ sɩlɛ loo sakyɔ mʋ tɔ, bee kuusi yɛ, ");
INSERT INTO naw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Anyɩn, mɩnɛ nɩɩ fɛn waa falɛ? Anɛ gbaa anɛ an gyɛ asa nɩn fɛɛ fanɛ falɛ. An sʋ asɩn danbɩrasa mʋ an bɩya fanɛ nɩn. An tɔwɛ fanɛ yɛ fan lɛɛ fanɛ n‐yɩɩ lɩɩ atɔ gyaga sʋ, kɛ fan bwii ba Ɩbwaarɛ mʋ nɩɩ ɔ tɛ nkpa kakpaa tɔ mʋ asɛ. Mʋ ɩ tʋʋ sʋsʋ yɛ kasɛ yɛ ɔpʋ yɛ atɔ mʋ nɩɩ ɩ bʋ ɩmʋ kpini tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dɩdaa mʋ, Ɩbwaarɛ lɛɛ mu ansi yɛgɛ nɩɩ dulinyaa tɔ asa kpini ba natɛ waa bamʋ gbaa‐gbaa bamʋ nkɔlɔ biti. ");
INSERT INTO naw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Amaa Ɩbwaarɛ waa adanbɩrasa kaapʋ asa fɛɛ maa bʋ tɔ, fɛɛ maa sa bʋlayɩ nɩɩ atɔ duusa a waa saŋa kyɛɛkyɛɛ tɔ. Nɩɩ ɛɛ sa fanɛ agyitɔ kɩkyɔ nɩɩ ɛɛ yɛgɛ fanɛ ansi i gyii.” ");
INSERT INTO naw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Halɩɩ ba maa tɔwɛ ɩnɩmʋ kamaa gbaa mʋ, ɩ waa ɔlʋn pɔyɩ nɩɩ ba taalɛ gya sakyɔ mʋ yɛ ba man waa kɔlɔŋɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tʋtɔ mʋ Gyiwu abi mʋ nɩɩ ba lɩɩ Antiyoki yɛ Ikoniyum mʋ ba ba tɔwɛ kyɛɛgɛ sakyɔ mʋ nfɛɛrɛ. Nɩɩ ba tʋʋ Pɔɔlɩ abuu waa nfɛɛrɛ fɛɛ o wu nɩn, nɩɩ ba kpɩɩ mʋ lɩɩ kadɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Amaa saŋa mʋ nɩɩ akɔɔlɛ‐gyipu mʋ ba ba kyaabɔɔ Pɔɔlɩ mʋ, ɔ kʋsʋ nɩɩ o bwii kpee kadɛ mʋ tɔ. Ɩmʋ lɩɩkaakɛ mʋ Pɔɔlɩ maa Banabasi ba lɩɩ tʋtɔ kpee Debe. ");
INSERT INTO naw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nɩɩ ba tɔwɛ asɩn danbɩrasa mʋ Debe kadɛ tɔ, nɩɩ ɩ yɛgɛ asa kɩkyɔ ba be buu Yesu. Nɩɩ ba bwii kpee Lisitira yɛ Ikoniyum ndɛ yɛ Antiyoki mʋ nɩɩ kɩ bʋ Pisidiya ɔsʋwʋlɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ba tɔwɛ waa Yesu abɩɩlapʋ mʋ, waa bamʋ ɔlʋn tɔ fɛɛ ba yɩlɛ kɩkɔɔlɛ‐gyii tɔ, nɩɩ ɔ bɩla tɔwɛ yɛ, pɔyɩ kɛ ba nyɛ Ɩbwaarɛ kuwura‐gyii mʋ tɔ loo mʋ, ɩ dagaa ba maa gyii awʋrʋfɔ. ");
INSERT INTO naw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Krisito abi kʋbʋ kʋmaa tɔ mʋ, ba lɛɛ abɩlɩsa sa bamʋ. Nɩɩ ba ŋmina kɔnɔ kʋlɛ kabwaarɛ kʋlɛ taa bamʋ waa Ɔnyɩrɩpɛ mʋ nɩɩ ba kɔɔlɛ mʋ gyii mʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ɩmʋ kamaa tɔ mʋ, ba bɔla lɩɩ Pisidiya ɔsʋwʋlɛ sʋ taa ba fʋʋ Panfiliya ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nɩɩ ba tɔwɛ asɩn danbɩrasa mʋ Pega kadɛ tɔ kyaga sʋ kpee Ataliya kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ba lɩɩ Ataliya bɔla nkyu sʋ kpee Antiyoki mʋ nɩɩ kɩ bʋ Siriya. Antiyoki tʋtɔ nɩɩ Krisito abi kʋbʋ mʋ ba wʋla kʋlɛ kabwaarɛ‐kʋlɛ taa bamʋ waa Ɩbwaarɛ kɩbaa tɔ, fɛɛ ɔ bwaala bamʋ kɛ ba taalɛ waa kusun mʋ nɩɩ ba waa lʋwɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Saŋa mʋ nɩɩ ba fʋʋ Antiyoki mʋ, ba tɩɩ Krisito abi kʋbʋ mʋ ba sarɛ katɩn kʋlʋn. Nɩɩ ba tɔwɛ bamʋ kʋtɔ mʋ nɩɩ Ɩbwaarɛ bɔla bamʋ sʋ waa, yɛ kanan mʋ nɩɩ o bugi ɔkpa sa bamʋ nɩɩ ba man gyɛ Gyiwu abi, nɩɩ ba kɔɔlɛ Yesu asɩn danbɩrasa mʋ gyii mʋ. ");
INSERT INTO naw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nɩɩ Pɔɔlɩ maa Banabasi ba kyɩna Yesu abɩɩlapʋ mʋ asɛ kyɛɛrɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Amaa asa akʋ ba lɩɩ Gyudeya ba Antiyoki, nɩɩ ba ba bɛɛ kaapʋ akɔɔlɛ‐gyipu mʋ yɛ, nɩɩ ba kan man tin bamʋ iduu fɛɛ kanan mʋ nɩɩ Mosesi nbara ɩ kaapʋ mʋ, ba mɛɛ yɛ ba nyɛ kamɔlɩgɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nɩɩ ɩnɩmʋ ɩ yɛgɛ nɩɩ bɩɩtɛ yɛ kamɔɔrɛ‐gyii kɩ ba Pɔɔlɩ maa Banabasi yɛ asa mʋ nsana. Ɩmʋ sʋ ba lɛɛ Pɔɔlɩ maa Banabasi yɛ akɔɔlɛ‐gyipu mʋ akʋ fɛɛ ba kpee Gyerusalem naa wu Krisito asunpu yɛ abɩlɩsa lɩɩ kamɔɔrɛ‐gyii mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nɩɩ Krisito abi kʋbʋ mʋ ba lɛɛ bamʋ ɔkpa. Ba maa kpee mʋ ba bɔla lɩɩ Fonesiya yɛ Samariya. Yɛgɛ bɛɛ tɔwɛ bamʋ kanan mʋ nɩɩ bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ ba kɔɔlɛ Krisito gyii mʋ. Nɩɩ ɩ waa akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ tʋtɔ mʋ ɔkɔn. ");
INSERT INTO naw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Saŋa mʋ nɩɩ ba fʋʋ Gyerusalem mʋ, Krisito abi kʋbʋ yɛ Krisito asunpu yɛ kʋbʋ mʋ bamʋ abɩlɩsa mʋ ba waa bamʋ nsa‐nsa. Nɩɩ Pɔɔlɩ maa Banabasi ba lɛɛ tɔwɛ bamʋ kʋtɔ kʋmaa mʋ nɩɩ Ɩbwaarɛ bɔla bamʋ sʋ waa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amaa Farasii kʋbʋ mʋ tɔ akɔɔlɛ‐gyipu mʋ akʋ ba kʋsʋ yɩlɛ tɔ yɛ, “Ɩ dagaa fɛɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi, nɩɩ ba kɔɔlɛ Krisito gyii mʋ, ba maa tɩŋɛ iduu fɛɛ kanan mʋ nɩɩ Mosesi nbara mʋ ɩ kaapʋ tɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kanɩn sʋ Krisito asunpu mʋ yɛ abɩlɩsa mʋ ba gyaŋɛ kɛ ba taa ɩmʋ nfɛɛrɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba maa kyɩna asɩn mʋ sʋ gyii abaa ɩmɔɔrɛ kyɛɛrɛɛ mʋ, Pita kʋsʋ yɩlɛ tɔwɛ bamʋ yɛ, “Mɛ daa ana yɛ mi‐supu ana, fan nyi fɛɛ nsu nkʋ tɔ mʋ, Ɩbwaarɛ maa lɛɛ mɛ lɩɩ fanɛ tɔ yɛ n tɔwɛ asɩn danbɩrasa mʋ sa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ ba nu kɛ ba kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nɩɩ Ɩbwaarɛ mʋ nɩɩ o nyi nyɩmɩsa kɔkɔlɔ tɔ asɩn mʋ, waa nɩɩ ɩ kaapʋ fɛɛ ɔ kɔɔlɛ bamʋ, fɛɛ ɔ maa sa bamʋ Kayaayu Kyɩrɛkyɩrɛ fɛɛ kanan mʋ nɩɩ ɔ sa anɛ gbaa anɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nɩɩ Ɩbwaarɛ man sʋ nbarɩgɛ tɔ yɛ anaa bamʋ nsana tɔ. Lɩɩ fɛɛ, lɩɩ bamʋ kɩkɔɔlɛ‐gyii sʋ ɔ lɔŋɔ bamʋ nkɔlɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ɩmʋ sʋ mɩnɛ ɩ waa nɩɩ fen biti fan tʋʋ Ɩbwaarɛ tɔ kɩɩ, nɩɩ fɛn taa ɩsʋla budusa fɛn sʋla Yesu abuupu mʋ nɩɩ anɛ yɛ anɛ naana ana gbaa an man taalɛ sʋla? ");
INSERT INTO naw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","An kɔɔlɛ gyii fɛɛ, lɩɩ anɛ‐Nyɩrɩpɛ Yesu kabwaala mʋ sʋ nɩɩ Ɩbwaarɛ mɔlɩgɛ anɛ fɛɛ kanan mʋ nɩɩ bamʋ gbaa bamʋ ba nyɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nɩɩ asa mʋ nɩɩ ba sarɛ tʋtɔ mʋ kpini ba laatɔ bee nu Banabasi yɛ Pɔɔlɩ ba maa tɔwɛ ɩsɩnkaala yɛ asɩn kyinkyinsa mʋ nɩɩ Ɩbwaarɛ bɔla bamʋ sʋ waa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ba maa tɔwɛ lʋwɛ mʋ, Gyemisi kʋsʋ tɔwɛ yɛ, “Mɛ‐daa ana yɛ mi‐supu ana, fan nu mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Pita tɔwɛ kanan mʋ nɩɩ Ɩbwaarɛ gyankpaa waa, nɩɩ ɔ lɛɛ kaapʋ fɛɛ ee biti bamʋ nɩɩ ba man gyɛ Gyiwu abi gbaa, nɩɩ ɔ lɛɛ bamʋ tɔ akʋ biliŋi mʋ lɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɩmʋ sʋ asɩn nɩmʋ yɛ Ɩbwaarɛ atɔwɛpʋ Asɩnkyan yɩlasa mʋ ɩ waa kʋkʋlʋn. ");
INSERT INTO naw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Asɩn mʋ ɩ gyɛ fɛɛ Ɩbwaarɛ yɛ, ‘Ɩnɩmʋ kamaa n biti n bwii kɛ n pɔyɩ Dawidi kɩkpaara mʋ nɩɩ kɩ lɩɩ tɩyɛ mʋ. N biti n lɔŋɔ‐lɔŋɔ ɩmʋ atɔ nyitasa mʋ kɛ n bwii kʋsaa kɩmʋ yɩlɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kɛ asa mʋ nɩɩ ba san mʋ yɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi, nɩɩ mɛ, Ɔnyɩrɩpɛ Ɩbwaarɛ kɩtɩɩ kɩ gyan bamʋ sʋ mʋ, kɛ ba kɩɩ biti mɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mɛ, Ɔnyɩrɩpɛ Ɩbwaarɛ mʋ nɩɩ n wʋla lɛɛ ɩnɩmʋ kaapʋ lɩɩ koo dɩdaa mʋ, ɩ tɔwɛ kanɩn.’ ");
INSERT INTO naw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Kanɩn sʋ mɛ asɩn mʋ nɩɩ n sʋ n tɔwɛ ɩ gyɛ fɛɛ, an man nyan bamʋ nɩɩ ba man gyɛ Gyiwu abi nɩɩ ba kyɛɛgɛ ba Ɩbwaarɛ asɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Amaa ɩ dagaa a maa kyʋrɔɔ ɔwʋlɛ naa tɔwɛ bamʋ yɛ, ba lɛɛ ɩdakpa agyitɔ kigyii yɛ kagyɩɩ abɛɛ kanyɩn‐biti. Kɛ ba man gyii atɔbwaaya mʋ nɩɩ ba man tɩn bamʋ amu nɩɩ ba wu abɛɛ nkalan. ");
INSERT INTO naw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nɩɩ koo dɩdaa mʋ, ba wʋla bɛɛ kaapʋ Mosesi nbara mʋ ndɛ kʋmaa tɔ, nɩɩ bɛɛ kalɛ ɩmʋ Gyiwu abi kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa kakɛ fʋʋtɛsa kʋmaa.” ");
INSERT INTO naw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tʋtɔ nɩɩ Krisito asunpu mʋ yɛ abɩlɩsa mʋ yɛ Krisito abi kʋbʋ mʋ kpini ba tɔwɛ kyula yɛ, ba lɛɛ bamʋ tɔ anyɩn akʋ, kɛ ba sun ba maa Pɔɔlɩ yɛ Banabasi kɛ ba kpee Antiyoki. Nɩɩ ba lɛɛ Gyudasi mʋ nɩɩ bɛɛ tɩɩ mʋ Basabasi yɛ Silasi. Bamʋ anyɔ ba gyɛ Krisito abi agyankpaapʋ mʋ akʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nɩɩ ba taa falɛ ɔwʋlɛ nɩmʋ waa bamʋ abaa tɔ. Nɩɩ ba kyʋrɔɔ ɔwʋlɛ mʋ falɛ. “Ɩ gyɛ anɛ Krisito asunpu yɛ abɩlɩsa yɛ Krisito abi mʋ kpini. “An kyʋrɔɔ ɔwʋlɛ nɩmʋ an sa fanɛ mʋ nɩɩ fan man gyɛ Gyiwu abi mʋ. “Nɩɩ fan kɔɔlɛ Yesu gyii mʋ, nɩɩ fan bʋ Antiyoki yɛ Siriya yɛ Sisiliya mʋ kpini. “Anɛ fanɛ bɩrɩsa ana an fwaala fanɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“An nu fɛɛ anɛ tɔ asa akʋ ba ba fanɛ asɛ, ba sʋ asɩn akʋ ba nyan fanɛ, yɛgɛ bee nyita fanɛ nfɛɛrɛ. Yɛgɛ an man sa bamʋ ɔkpa fɛɛ ba waa kanɩn, nɩɩ an man nyi bamʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ɩmʋ sʋ anɛ kpini a tɔwɛ kyula fɛɛ a lɛɛ asa akʋ kɛ ba maa anɛ kyɛmɩnɛ ana Banabasi maa Pɔɔlɩ, an sun bamʋ ba fanɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bamʋ ɩ gyɛ asa mʋ nɩɩ ba taga apʋ lɩɩ Ɔnyɩrɩpɛ Yesu Krisito kɩtɩɩ tɔ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kanɩn sʋ an bɩla sun Gyudasi maa Silasi fanɛ asɛ an tii sʋ. Kɛ ba naa taa bamʋ kɔnɔ tɔ tɔwɛ asɩn mʋ nɩɩ an kyʋrɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nɩɩ ɩmʋ nɩɩ ɩ bʋrɔn sa anɛ yɛ Kayaayu Kyɩrɛkyɩrɛ mʋ ɩ gyɛ fɛɛ, a mee biti fɛɛ a taa kasʋla budusa kʋ sʋla fanɛ tii sʋ, lɩɩ ɩmʋ nɩɩ an biti an tɔwɛ fanɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ɩmʋ ɩ gyɛ yɛ fan lɛɛ fanɛ n‐yɩɩ lɩɩ agyitɔ mʋ nɩɩ ba taa lɔŋɔ sa ɩdakpa yɛ atɔbwaaya nkalan yɛ atɔbwaaya mʋ nɩɩ ba man tɩn bamʋ amu nɩɩ ba wu mʋ, kɛ fan bɩla lɛɛ fanɛ n‐yɩɩ lɩɩ kagyɩɩ abɛɛ kanyɩn‐biti tɔ. Ii biti ɩ waa ɔdan sa fanɛ fɛɛ fan maa lɛɛ fanɛ n‐yɩɩ lɩɩ ɩnɩmʋ tɔ. “An kala fanɛ.” ");
INSERT INTO naw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nɩɩ ba lɛɛ bamʋ, nɩɩ ba sun bamʋ ɔkpa. Nɩɩ nbɔɔ mʋ ba maa naa fʋʋ Antiyoki mʋ, ba tɩɩ Krisito abi mʋ sarɛ, nɩɩ ba lɛɛ ɔwʋlɛ mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ba maa kalɛ ɔwʋlɛ mʋ, katɔwɛ waa nkyɛtɔ asɩn mʋ, ɩ yɛgɛ nɩɩ bamʋ ansi i gyii. ");
INSERT INTO naw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Gyudasi maa Silasi mʋ nɩɩ ba gyɛ Ɩbwaarɛ atɔwɛpʋ mʋ ba tɔwɛ waa Krisito abi kʋbʋ mʋ ɔlʋn tɔ. ");
INSERT INTO naw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nɩɩ ba maa gyii nkɛ nkʋ bamʋ asɛ mʋ, ba lɛɛ bamʋ ɔkpa kayɩɩ yuuli tɔ. Nɩɩ ba bwii naa fʋʋ bamʋ nɩɩ ba sun bamʋ mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Amaa Silasi waa mʋ nfɛɛrɛ fɛɛ o sii kyɩna tʋtɔ. Nɩɩ Gyudasi nkʋn bwii kpee Gyerusalem). ");
INSERT INTO naw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Amaa Pɔɔlɩ maa Banabasi ba sii Antiyoki. Nɩɩ ba maa asa gaalaagaa bɛɛ tɔwɛ bɛɛ kaapʋ Ɔnyɩrɩpɛ asɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ɩmʋ kamaa tɔ mʋ, Pɔɔlɩ tɔwɛ Banabasi yɛ, “Yɛgɛ a bwii kpee naa bɔɔ Krisito abi mʋ nɩɩ ba bʋ ndɛ‐ndɛ sʋ mʋ, katɩn mʋ nɩɩ an wʋla tɔwɛ Ɔnyɩrɩpɛ asɩn mʋ. Kɛ a kpee naa wu kanan mʋ nɩɩ ba du.” ");
INSERT INTO naw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nɩɩ Banabasi ii biti fɛɛ ɔ taa Gyɔn mʋ nɩɩ bɛɛ tɩɩ yɛ Maki mʋ o tii bamʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Amaa Pɔɔlɩ man kyula fɛɛ ba taa Maki buu bamʋ n‐yɩɩ. Lɩɩ fɛɛ ɔ lɛɛ mʋ n‐yɩɩ lɩɩ bamʋ tɔ saŋa mʋ nɩɩ ba bʋ Panfiliya bɛɛ waa kusun mʋ, nɩɩ ɔ lɩɩ bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ɩnɩmʋ ɩ yɛgɛ nɩɩ bɩɩtɛ tɩyɛ Pɔɔlɩ maa Banabasi nsana, nɩɩ ba barɩgɛ tɔ. Nɩɩ Banabasi taa Maki buu mʋ n‐yɩɩ bɔla nkyu sʋ kpee Sipuru. ");
INSERT INTO naw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Amaa Pɔɔlɩ bɩrɛ taa Silasi tii mʋ n‐yɩɩ sʋ, nɩɩ Krisito abi mʋ ba kʋlɛ Ɔnyɩrɩpɛ fɛɛ ɔ bwaala bamʋ, nɩɩ ba kyʋn. ");
INSERT INTO naw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nɩɩ ba bɔla lɩɩ Siriya yɛ Silisiya nɩɩ ba waa Krisito abi kʋbʋ‐kʋbʋ mʋ ɔlʋn tɔ. ");
INSERT INTO naw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nɩɩ Pɔɔlɩ maa Silasi ba ba Debe, nɩɩ ba lɩɩ tʋtɔ kpee Lisitira. Tʋtɔ maa nɩɩ ba wu Yesu obuupu kʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Timoti. Nɩɩ mu‐nyi gyɛ Gyiwu obii mʋ nɩɩ ɔ kɔɔlɛ Krisito gyii, amaa mʋ‐sɛ bɩrɛ gyɛ Giriki obii nɩn. ");
INSERT INTO naw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Krisito akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ Lisitira yɛ Ikoniyum mʋ, ba tɔwɛ Timoti n‐yɩɩ sʋ asɩn danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ɩmʋ sʋ Pɔɔlɩ ii biti fɛɛ ɔ taa Timoti buu mʋ n‐yɩɩ kpee ɔkpa. Nɩɩ Gyiwu abi mʋ nɩɩ ba bʋ tʋtɔ mʋ sʋ mʋ, ɔ tɩn Timoti oduu, lɩɩ fɛɛ bamʋ kpini be nyi fɛɛ Timoti mʋ‐sɛ maa gyɛ Giriki obii nɩn. ");
INSERT INTO naw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ba maa naa ndɛ sʋ mʋ, bɛɛ kaapʋ bamʋ kɔnɔsa mʋ nɩɩ Krisito asunpu mʋ yɛ abɩlɩsa mʋ nɩɩ ba bʋ Gyerusalem ba sa bamʋ fɛɛ ɔsa kʋmaa o buu ɩmʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ɩmʋ sʋ Krisito abi ba nyɛ ɔlʋn kɩkɔɔlɛ‐gyii tɔ, yɛgɛ kakɛ kʋmaa bɛɛ nyɛ akyɔ bee tii sʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nɩɩ Pɔɔlɩ maa mʋ bɩrɩsa ana ba bɔla Firigiya maa Galati ifuli sʋ kyʋn, lɩɩ fɛɛ Kayaayu Kyɩrɛkyɩrɛ mʋ man sa bamʋ ɔkpa fɛɛ ba tɔwɛ abwaarɛsɩn Asiya ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Saŋa mʋ nɩɩ ba fʋʋ Misiya ngyaŋɛ mʋ, ba kpan bamʋ n‐yɩɩ fɛɛ ba faa loo Bitiniya, amaa Yesu Kayaayu mʋ man sa bamʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ɩmʋ sʋ ba lɩɩ Misiya kpee Trowa kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ɩmʋ kagyanbwɛ mʋ, Pɔɔlɩ nyɛ ansi sʋ kɩlɛɛkaapʋ. O wu Masedoniya ɔnyɩn kʋ maa yɩlɛ ɛɛ kʋlɛ mʋ yɛ, “Faa ba Masedoniya, ba kyɛ anɛ tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Saŋa mʋ nɩɩ Pɔɔlɩ wu ansi sʋ kɩlɛɛkaapʋ mʋ, opula maŋa tɔ nɩɩ an kʋʋla anɛ n‐yɩɩ an biti a kpee Masedoniya. Lɩɩ fɛɛ an kɔɔlɛ kyula fɛɛ Ɔnyɩrɩpɛ Ɩbwaarɛ ɩ tɩɩ anɛ yɛ a naa tɔwɛ asɩn danbɩrasa mʋ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","An lɩɩ Trowa kyɩna nkyu sʋ yii sʋ kpee Samotiri. Ɩmʋ lɩɩkaakɛ mʋ, nɩɩ an fʋʋ Neyapoli. ");
INSERT INTO naw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nɩɩ an lɩɩ tʋtɔ kyaga sʋ natɛ kpee Filipi mʋ nɩɩ kɩ gyɛ Masedoniya kabaafʋn kʋ kadɛ lala, nɩɩ tʋtɔ bʋ Roma abi kasɛ. An gyii tʋtɔ nkɛ nkʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nɩɩ kakɛ fʋʋtɛsa akɛ mʋ an lɩɩ kadɛ mʋ tɔ kpee ɔlɩɩkaa. An waa nfɛɛrɛ fɛɛ an biti an wu kabwaarɛ‐kʋlɛ opula. A maa wu kʋkʋ mʋ, an kyɩna piili an tɔwɛ an sa akyɩɩ mʋ nɩɩ ba ba gyaŋɛ tʋtɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Akyɩɩ mʋ nɩɩ bee nu asɩn mʋ bɛɛ tɩɩ bamʋ tɔ ɔkʋ yɛ Lidiya, nɩɩ ɔ gyɛ ataa kɩrɩman‐kyu ɔfɛpʋ nɩɩ ɔ lɩɩ Tatira kadɛ lala tɔ nɩɩ ɔ sɩlɛ Ɩbwaarɛ. Nɩɩ Ɔnyɩrɩpɛ mʋ bugi mʋ kɔkɔlɔ tɔ, nɩɩ ɔ kɔɔlɛ Pɔɔlɩ asɩn mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Saŋa mʋ nɩɩ an gyee maa mʋ kɩkpaara sʋ abi kpini Ɩbwaarɛ kekyugyee mʋ, ɔ tɩɩ anɛ ba mʋ ayɛ. Nɩɩ ɔ tɔwɛ anɛ yɛ, “Nɩɩ fan kɩɩ mɛ fɛɛ n kɔɔlɛ Ɔnyɩrɩpɛ mʋ gyii bɩrɛ, fan ba kyɩna mɛ kɩkpaara sʋ.” Nɩɩ ɔ dan mata sʋ halɩɩ an kyula naa kyɩna mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kakaakʋ an maa kpee kabwaarɛ‐kʋlɛ opula mʋ, an gyaŋa kɩnyɛ kibite mʋ nɩɩ ɔ sʋ kabwɩɩ libi. Nɩɩ ɛɛ kpalɩ ee wu asɩn mʋ nɩɩ ii biti ɩ ba, yɛgɛ ɛɛ nyɛ afulee gaa ɛɛ sa mʋ wuya ana. ");
INSERT INTO naw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nɩɩ kebii kyɩɩsa‐bi nɩmʋ buu anaa Pɔɔlɩ, yɛgɛ ee kuusi ɛɛ tɔwɛ yɛ, “Asa anɩmʋ ba gyɛ Ɩbwaarɛ lala mʋ nɩɩ ɔ bʋ sʋsʋ mʋ ayaafɔlɛ. Nɩɩ bɛɛ tɔwɛ fanɛ ɔkpa mʋ nɩɩ fen biti fan bɔla sʋ nyɛ kamɔlɩgɛ.” ");
INSERT INTO naw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ɔ maa sʋ ɛɛ tɔwɛ asɩn nɩmʋ kakɛ kʋmaa. Amaa kamaa tɔ mʋ kibite mʋ asɩn mʋ i fii Pɔɔlɩ, nɩɩ o biliŋi tɔwɛ kabwɩɩ libi mʋ yɛ, “N tɔwɛ fʋ yɛ, lɩɩ Yesu Krisito kɩtɩɩ tɔ sʋ mʋ, lɩɩ mʋ tɔ.” Nɩɩ opula tɔ nɩɩ kabwɩɩ libi mʋ lɩɩ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Amaa saŋa mʋ nɩɩ kebii kyɩɩsa‐bi mʋ wuya ana, ba wu fɛɛ ba man bɩla ba sʋ tamaa mʋ nɩɩ ba nyɛ afulee lɩɩ mʋ sʋ mʋ, ɩmʋ sʋ ba kɩtaa Pɔɔlɩ maa Silasi nɩɩ ba bɩɩtɛ bamʋ kpee asɩn ogyikpa alʋnpʋ mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nɩɩ ba taa bamʋ ba asɩn agyipu abɩlɩsa asɛ nɩɩ ba tɔwɛ yɛ, “Anyɩn anɩmʋ ba gyɛ Gyiwu abi nɩn nɩɩ bee biti ba boyi anɛ kadɛ, ");
INSERT INTO naw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","yɛgɛ bɛɛ kaapʋ anɛ atɔ pʋpwɛ mʋ nɩɩ ɩ man dagaa anɛ Roma abi fɛɛ a buu abɛɛ a waa.” ");
INSERT INTO naw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nɩɩ sakyɔ mʋ nyaŋɛ tɔ ba tii Pɔɔlɩ maa Silasi waa tɔ, nɩɩ asɩn agyipu mʋ ba sa ɔkpa fɛɛ ba bugi bamʋ ɩkaalɛ mʋ kɛ ba tɩŋɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Saŋa mʋ nɩɩ ba tɩŋɛ bamʋ lʋwɛ mʋ, ba taa bamʋ naa tii obu. Nɩɩ ba sa ɔmʋ nɩɩ ee kun obu mʋ sʋ kɔnɔ yɛ, ɔ kɩɩ bamʋ sʋ danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ba maa sa mʋ kɔnɔ lʋwɛ mʋ, ɔ taa bamʋ naa tii nsana tɔ obu mʋ tɔ, taa agbeeleebi ŋmina bamʋ ayaa kyaga kigbilin. ");
INSERT INTO naw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Amaa kiyiridi nsana mʋ, Pɔɔlɩ maa Silasi bɛɛ kʋlɛ kabwaarɛ‐kʋlɛ yɛgɛ bɛɛ bɩɩ ɩlʋn bɛɛ yɩn Ɩbwaarɛ, yɛgɛ bamʋ nɩɩ ba tii obu mʋ gbaa bee nu bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nɩɩ opula maŋa tɔ nɩɩ kasɛ ki gyingyen nɩɩ obu mʋ gyingyen naa lɩɩ halɩɩ kɩmʋ kasɛ. Nɩɩ saŋa maŋa tɔ obu mʋ ɩpʋnʋ i tigi nɩɩ agbeeleebi mʋ nɩɩ ba taa ŋmina bamʋ ɔkʋmaa mʋ ɩ saŋɛ. ");
INSERT INTO naw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Saŋa mʋ nɩɩ obu tiipu okunpu kyiŋi wu fɛɛ ɩpʋnʋ mʋ i tigi mʋ ɔ bɩɩtɛ deebi lɛɛ nɩɩ ee biti fɛɛ ɔ mɔɔ mʋ n‐yɩɩ, o nyi fɛɛ obu atiipu mʋ ba lɩɩ sɩlɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Amaa Pɔɔlɩ pʋntɛ mʋ sʋ yɛ, “Man waa fʋ n‐yɩɩ sɛhn, anɛ kpini a bʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nɩɩ okunpu mʋ biti fɩtɩla, sɩlɛ taa kufuu yɛ kɩkyɩkya ba tɩyɛ Pɔɔlɩ maa Silasi ayaa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nɩɩ ɔ lɛɛ bamʋ ba kewu taasɛ bamʋ yɛ, “Anyɩn, mɩnɛ ɩ dagaa n waa kɛ n nyɛ kamɔlɩgɛ?” ");
INSERT INTO naw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nɩɩ ba lɛɛ kɔnɔ yɛ, “Kɔɔlɛ Ɔnyɩrɩpɛ Yesu gyii kɛ faa fʋ kɩkpaara sʋ abi fan nyɛ kamɔlɩgɛ.” ");
INSERT INTO naw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nɩɩ ba tɔwɛ Ɔnyɩrɩpɛ mʋ asɩn sa mʋ yɛ bamʋ nɩɩ ba bʋ mʋ kɩkpaara sʋ kpini. ");
INSERT INTO naw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kanɩn kagyanbwɛ saŋa maŋa tɔ nɩɩ okunpu mʋ taa Pɔɔlɩ maa Silasi lɩɩ naa nyɛɛ bamʋ ɩlɔ. Nɩɩ kanɩn opula maŋa tɔ nɩɩ ba gyee maa mʋ kɩkpaara sʋ abi kpini Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tʋtɔ nɩɩ obu atiipu okunpu mʋ taa bamʋ kpee mʋ kɩkpaara sʋ naa dɩŋa agyitɔ sa bamʋ. Nɩɩ maa mʋ kɩkpaara sʋ abi kpini ansi i gyii lɩɩ ba maa kɔɔlɛ Ɩbwaarɛ gyii mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Amaa ɩ maa ba ŋmaŋɛ tɔ mʋ, asɩn agyipu mʋ ba sun Apurusi yɛ ba naa tɔwɛ okunpu mʋ yɛ, “O tigi anyɩn mʋ kɛ ba natɛ.” ");
INSERT INTO naw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nɩɩ okunpu mʋ tɔwɛ Pɔɔlɩ yɛ, “Asɩn agyipu mʋ ba sa kɔnɔ yɛ, n tigi faa Silasi. Ɩmʋ sʋ fɛn taalɛ natɛ kayɩɩ yuuli tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Amaa nɩɩ Pɔɔlɩ tɔwɛ Apurusi mʋ yɛ, “Ba kɩtaa anɛ ba man gyii anɛ asɩn nɩɩ ba dayɩ anɛ sakyɔ tɔ, yɛgɛ an gyɛ Roma abi nɩɩ ba kɩtaa anɛ tii. Nɩɩ bee biti ba lɛɛ anɛ lɩɩ nfɩɩ asiri tɔ? Ayee! Kanɩn sʋ yɛgɛ bamʋ gbaa‐gbaa bamʋ ba ba lɛɛ anɛ.” ");
INSERT INTO naw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nɩɩ Apurusi mʋ ba kpee naa tɔwɛ asɩn agyipu mʋ. Nɩɩ ba maa nu fɛɛ Pɔɔlɩ maa Silasi ba gyɛ Roma abi mʋ, kufuu kɩ kɩtaa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ɩmʋ sʋ asɩn agyipu mʋ ba ba kɩtaa bamʋ ayaa tɔ. Nɩɩ ba lɛɛ bamʋ lɩɩ obu tiisa mʋ tɔ, kʋlɛ bamʋ yɛ ba lɩɩ kadɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nɩɩ Pɔɔlɩ maa Silasi ba maa lɩɩ obu tiisa mʋ tɔ mʋ, ba kpee Lidiya kɩkpaara sʋ. Tʋtɔ nɩɩ ba naa tu Krisito abi mʋ, nɩɩ ba tɔwɛ waa bamʋ. Nɩɩ ba lɩɩ tʋtɔ kyʋn. ");
INSERT INTO naw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Saŋa mʋ nɩɩ Pɔɔlɩ maa Silasi ba bɔla lɩɩ Amfipolisi yɛ Apoloniya ndɛ tɔ mʋ, ba naa fʋʋ Tesalonika kadɛ tɔ, katɩn mʋ nɩɩ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa bʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Fɛɛ kanan mʋ nɩɩ ɔ wʋla ɛɛ waa mʋ, Pɔɔlɩ kpee ɔgyaŋɛkpa mʋ tɔ. Nɩɩ ɔ tɔwɛ abwaarɛsɩn sa bamʋ nkɛ fʋʋtɛsa akɛ kanɩn ɩlɩɩ ɩsa. ");
INSERT INTO naw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pɔɔlɩ lɛɛ kaapʋ tɔ fɛɛ, “Ɩ dagaa fɛɛ Ɔmʋ nɩɩ Ɩbwaarɛ Wʋla lɛɛ mʋ o gyii awʋrʋfɔ, kɛ o wu kɛ ɔ bɩla kyiŋi.” Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Yesu mʋ nɩɩ n tɔwɛ fanɛ mʋ asɩn falɛ ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ Wʋla lɛɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Gyiwu abi mʋ akʋ yɛ Giriki abi mʋ nɩɩ ba sɩlɛ Ɩbwaarɛ mʋ, yɛ akyɩɩ mʋ nɩɩ ba sʋ bɛɛrɛɛ kadɛ mʋ tɔ mʋ kpini ba kɔɔlɛ Pɔɔlɩ asɩn mʋ kyula yɛ ɩ gyɛ kesintin nɩɩ ba buu bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Amaa Gyiwu abi mʋ nɩɩ ba san mʋ ba nyɛ kayɩɩ basa. Nɩɩ ba kpee kɩgya tɔ naa biti asa gyaga. Nɩɩ ba be tii bamʋ n‐yɩɩ sʋ, nɩɩ ba piili bɛɛ waa ɩlawʋ kadɛ mʋ tɔ. Nɩɩ ba kpala kpee Yasin ayɛ ba naa biti Pɔɔlɩ maa Silasi, kɛ ba kɩtaa bamʋ ba sakyɔ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Amaa ba maa man wu bamʋ mʋ, ba kɩtaa Yasin maa Yesu akɔɔlɛ‐gyipu akʋ bɩya bamʋ kadɛ mʋ abɩlɩsa ansi tɔ. Nɩɩ ba kuusi yɛ, “Ba nɩmʋ ɩ gyɛ bamʋ nɩɩ ba biliŋaa dulinyaa bee bun mʋ, ba ba nfɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Nɩɩ Yasin kɔɔlɛ bamʋ waa mʋ kɩkpaara sʋ. Bamʋ kpini ba fɔyɩ Owura lala Kasaro kɔnɔsa nbara, nɩɩ ba tɔwɛ yɛ Owura pʋpwɛ kʋ bʋ tɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Yesu.” ");
INSERT INTO naw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sakyɔ mʋ yɛ kadɛ abɩlɩsa mʋ ba maa nu falɛ asɩn mʋ, ɩ tɔɔrɔɔ bamʋ gaa. ");
INSERT INTO naw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nɩɩ ba yɛgɛ Yasin maa mʋ tɔmaa ana ba ka afulee mʋ nɩɩ ɩ dagaa, nɩɩ ba yɛgɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kanɩn kakɛ maŋa kagyanbwɛ, nɩɩ Yesu akɔɔlɛ‐gyipu ba sun Pɔɔlɩ maa Silasi kpee Bereya kadɛ tɔ. Ba maa fʋʋ tʋtɔ mʋ ba kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa. ");
INSERT INTO naw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Asa mʋ nɩɩ ba bʋ Bereya mʋ nfɛɛrɛ ɩ dɛ kasɛ ɩ kyɔ bamʋ nɩɩ ba bʋ Tesalonika. Lɩɩ fɛɛ ba taa bamʋ nkɔlɔ kpini kɔɔlɛ asɩn mʋ yɛgɛ bɛɛ bɩla bɛɛ kɩɩ Ɩbwaarɛ Asɩnkyan yɩlasa mʋ tɔ, kakɛ kʋmaa bɛɛ kɩɩ yɛ kʋtɔ mʋ nɩɩ Pɔɔlɩ tɔwɛ mʋ ɩ bʋ tɔ kanɩn. ");
INSERT INTO naw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kanɩn sʋ Gyiwu abi damantɛ yɛ Giriki akyɩɩ mʋ nɩɩ ba sʋ bɛɛrɛɛ yɛ anyɩn gaalaagaa ba kɔɔlɛ asɩn mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Saŋa mʋ nɩɩ Gyiwu abi mʋ nɩɩ ba bʋ Tesalonika ba nu yɛ Pɔɔlɩ bʋ Bereya ɛɛ tɔwɛ abwaarɛsɩn mʋ, ba ba tʋtɔ, bee fun bɛɛ waa asa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nɩɩ Yesu akɔɔlɛ‐gyipu mʋ ba waa bilen taa Pɔɔlɩ kpee kebunɔ, amaa Silasi maa Timoti ba sii Bereya kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nɩɩ anyɩn mʋ nɩɩ ba sun Pɔɔlɩ ɔkpa mʋ, ba sun mʋ ɔkpa kpee Antensi. Nɩɩ Pɔɔlɩ kala bamʋ fɛɛ Silasi maa Timoti ba waa bilen ba tu mʋ Antensi. ");
INSERT INTO naw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Saŋa mʋ nɩɩ Pɔɔlɩ gyoo Silasi maa Timoti Antensi mʋ, maa wu fɛɛ ɩdakpa ɩ bɔla kadɛ mʋ tɔ mʋ, nɩɩ ɩ tɔɔrɔɔ mʋ gaa. ");
INSERT INTO naw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ɩmʋ sʋ saŋa kʋmaa mʋ nɩɩ o kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa mʋ, maa Gyiwu abi yɛ Giriki abi mʋ nɩɩ ba sɩlɛ Ɩbwaarɛ mʋ bee gyii abwaarɛsɩn mʋ ɩmɔɔrɛ. Kanɩn sʋ nɩɩ ee kpee kɩgya tɔ kakɛ kʋmaa yɛgɛ maa asa bee gyii ɩmɔɔrɛ. ");
INSERT INTO naw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nɩɩ Epikuriyan ɩwʋlɛ anyipu kʋbʋ yɛ Sitoki ɩwʋlɛ anyipu kʋbʋ bee piili bee gyii Pɔɔlɩ ɩmɔɔrɛ. Mʋ katɔwɛ mʋ tɔ mʋ, Pɔɔlɩ ɩ tɔwɛ asɩn danbɩrasa lɩɩ Yesu maa mu kiwu kyiŋi asɩn. Nɩɩ bamʋ akʋ ba taasɛ yɛ, “Mɩnɛ nɩɩ nyɩmɩsa gyaga nɩmʋ ii biti ɔ kaapʋ?” Nɩɩ akʋ ba lɛɛ kɔnɔ yɛ, “I du fɛɛ ɛɛ kaapʋ akʋ ɩdakpa asɩn nɩn.” ");
INSERT INTO naw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nɩɩ ba kɩtaa Pɔɔlɩ taa mʋ kpee Aropago ɔgyaŋɛkpa abɩlɩsa ansi tɔ. Nɩɩ ba taasɛ mʋ yɛ, “Fʋ taalɛ tɔwɛ anɛ kɩkaapʋ pʋpwɛ mʋ nɩɩ fʋ bɩya mʋ? ");
INSERT INTO naw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Asɩn mʋ nɩɩ fʋ sʋ fʋ bɩya anɛ mʋ ɩ gyɛ anɛ asʋ tɔ asɩn pʋpwɛ. Ɩmʋ sʋ ba kaapʋ anɛ ɩmʋ kasɛ.” ");
INSERT INTO naw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Antensi abi yɛ afɔ mʋ nɩɩ ba bʋ kadɛ mʋ tɔ mʋ gaalaagaa ba mɛɛ waa sɛhn tii asɩn pʋpwɛ mʋ kunu sʋ yɛ ɩmʋ katɔwɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ɩmʋ sʋ nɩɩ Pɔɔlɩ kʋsʋ yɩlɛ Aropago ngyaŋɛ mʋ tɔ, tɔwɛ yɛ, “Antensi anyɩn, n wu fɛɛ ɔkpa kʋmaa sʋ mʋ, kʋtɔ kʋmaa mʋ nɩɩ fen sun mʋ, fɛn sʋ kensi payɩ fen sun mʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Lɩɩ fɛɛ n maa naa kadɛ mʋ tɔ mʋ, n wu atɔ mʋ nɩɩ fen muŋa fen sun. Nɩɩ n wu saraga kaswɩɩ mʋ nɩɩ bɛ kyʋrɔɔ kɩmʋ sʋ yɛ, ƖBWAARƖ MƲ NƖƖ AN MAN NYI MƲ MƲ LƐƐ. Ɩmʋ sʋ ɔmʋ nɩɩ fen sun, nɩɩ fen mee nyi mʋ mʋ, mʋ asɩn nɩɩ n biti n tɔwɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Ɩbwaarɛ mʋ nɩɩ ɔ tʋʋ dulinyaa yɛ kʋtɔ kʋmaa mʋ nɩɩ kɩ bʋ kɩmʋ tɔ mʋ, mʋ ɩ gyɛ sʋsʋ yɛ kasɛ Ɔnyɩrɩpɛ. Ɔ mɛɛ kyɩna kʋtɔ mʋ nɩɩ ba taa abaa pɔyɩ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kʋtɔ kʋ kɩ man bʋ tɔ nɩɩ Ɩbwaarɛ mɛɛ taalɛ waa, nɩɩ ɩ dagaa fɛɛ nyɩmɩsa ɔ waa sa mʋ. Lɩɩ fɛɛ mʋ ɩ sa nyɩmɩsa nkpa yɛ ɔ fʋʋtɛ yɛ kʋtɔ kʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ɔ tʋʋ nyɩmɩsa kʋlʋn nɩɩ ɔ bɔla mʋ sʋ nɩɩ ɔ tʋʋ ndɛndɛmandɛ kpini, nɩɩ ɔ yɛgɛ nɩɩ ba kyɩna dulinyaa ɩsʋwʋlɛ mʋ sʋ kpini. Ɩbwaarɛ wʋla ŋmina yɩla opula mʋ nɩɩ asa ba kyɩna yɛ ɩmʋ saŋa. ");
INSERT INTO naw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ɔnyɩrɩpɛ Ɩbwaarɛ waa ɩnɩmʋ nɩn, lɩɩ fɛɛ ee biti fɛɛ asa ba kɩɩ biti mʋ kɛ ba wu mʋ. Amaa yɛgɛ ɔ man bʋ kata yɛ anɛ tɔ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nɩɩ mʋ sʋ nɩɩ an sʋ nkpa, nɩɩ an taalɛ an naa yɛgɛ an bʋ tɔ falɛ, fɛɛ kanan mʋ nɩɩ fanɛ ɔlʋn‐bɩɩpʋ kʋ tɔwɛ yɛ, ‘Anɛ gbaa anɛ an gyɛ mu‐bii ana nɩn’. ");
INSERT INTO naw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nɩɩ ɩ gyɛ kesintin fɛɛ anɛ ɩ gyɛ Ɩbwaarɛ mu‐bii ana bɩrɛ mʋ, an man kan fɛ nfɛɛrɛ fɛɛ Ɩbwaarɛ keduli du fɛɛ suwa abɛɛ gbiti abɛɛ kubuu nɩɩ nyɩmɩsa taalɛ taa mʋ kanyaasɩn yɛ adawʋ pɔyɩ mʋ fɛɛ ɔdakpa. ");
INSERT INTO naw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dɩdaa mʋ Ɩbwaarɛ man taa asa kimennyi waa sɛhn, amaa nbɩɩnbɩɩ ɔ sa asa kpini kɔnɔsa katɩn kʋmaa mʋ nɩɩ ba bʋ fɛɛ ba yɛgɛ alibi kɩwaa. ");
INSERT INTO naw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Lɩɩ fɛɛ ɔ lɛɛ kakɛ yɩla mʋ nɩɩ ee biti ɔ bɔla ɔnyɩn mʋ nɩɩ ɔ wʋla lɛɛ mʋ kɛ ɔ talɛ ɔkʋmaa nɩmʋ kesintin ɔkpa sʋ. O kyiŋi kanɩn nyɩmɩsa maŋa lɩɩ lewu tɔ, waa kanɩn kaapʋ sa asa kpini yɛ ɩnɩmʋ ii biti ɩ waa.” ");
INSERT INTO naw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ba maa nu Pɔɔlɩ asɛ lɩɩ kelewu kyiŋi asɩn mʋ, akʋ ba waa mʋ ahin‐sɩn, nɩɩ akʋ mɔɔ ba tɔwɛ mʋ yɛ, “An biti fɛɛ fu bwii tɔwɛ anɛ kanɩn asɩn nɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nɩɩ Pɔɔlɩ lɩɩ ɔgyaŋɛkpa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nɩɩ anyɩn akʋ ba buu mʋ nɩɩ ba kɔɔlɛ Yesu gyii. Bamʋ akʋ atɩɩ ɩ gyɛ Diyonisi mʋ nɩɩ ɔ gyɛ Aropago kʋbʋ mʋ tɔ ɔkʋ, yɛ ɔkyɩɩ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Damarisi, yɛ asa mʋ akʋ. ");
INSERT INTO naw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ɩnɩmʋ kamaa mʋ Pɔɔlɩ lɩɩ Antensi kpee Korinto kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tʋtɔ nɩɩ ɔ naa tu Gyiwu obii kʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Akwila, nɩɩ ba kʋʋgɛ mʋ Pontu kadɛ tɔ, maa mʋ‐ka Prisila. Ba lɩɩ Itali ba Korinto ɩ man pɩɩ kyɛɛrɛɛ. Lɩɩ fɛɛ Owura lala Kiladiyo maa gya Gyiwu abi kpini lɩɩ Roma kadɛ tɔ mʋ sʋ. Nɩɩ Pɔɔlɩ kpee ɔ naa kɩɩ bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Lɩɩ fɛɛ maa bamʋ kpini ba gyɛ tantɩ awaapʋ sʋ mʋ, ɔ kyɩna bamʋ asɛ nɩɩ maa bamʋ ba bʋga waa kusun. ");
INSERT INTO naw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kakɛ fʋʋtɛsa kʋmaa nɩmʋ, Pɔɔlɩ ii kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa, ɛɛ tɔwɛ asɩn danbɩrasa mʋ ɛɛ sa Gyiwu abi yɛ Giriki abi kanan mʋ nɩɩ ba kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Saŋa mʋ nɩɩ Silasi maa Timoti ba lɩɩ Masedoniya ba mʋ asɛ Korinto mʋ, Pɔɔlɩ nyɛ saŋa sa abwaarɛsɩn kɩtɔwɛ, yɛgɛ ɛɛ lɛɛ asɩn mʋ kesintin ɛɛ kaapʋ tɔ ɛɛ sa Gyiwu abi mʋ yɛ Yesu ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Amaa Gyiwu abi ba maa kina asɩn mʋ, nɩɩ ba saalɛ mʋ. Nɩɩ ɔ fwɩɩ mʋ abaa yɛ mʋ ayaa nɩɩ ɔ yɛ, “Fanɛ lewu i bwii fanɛ gbaa‐gbaa fanɛ amu sʋ. Mɛɛ mɛ bɩrɛ ɩ man gyɛ mɛ asɩn. Lɩɩ ndaga ɩ sʋ ii kpee mʋ, n biti n kpee bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ɩmʋ sʋ Pɔɔlɩ lɩɩ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa mʋ, nɩɩ o kpee ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Titusi Gyusitu mʋ asɛ. Ɔ man gyɛ Gyiwu obii, amaa ee sun Ɩbwaarɛ, nɩɩ mʋ kɩkpaara kɩ man bʋ kata yɛ ɔgyaŋɛkpa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisipu mʋ nɩɩ ɔ gyɛ ɔgyaŋɛkpa ɔbɩlɩsa mʋ yɛ mʋ kɩkpaara sʋ abi kpini ba kɔɔlɛ Ɔnyɩrɩpɛ Yesu gyii. Nɩɩ Korinto abi gaalaagaa mʋ nɩɩ ba nu abwaarɛsɩn mʋ ba kɔɔlɛ gyii, nɩɩ ba gyee bamʋ Ɩbwaarɛ kekyugyee. ");
INSERT INTO naw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kakaakʋ kagyanbwɛ nɩɩ Pɔɔlɩ nyɛ ansi sʋ kɩlɛɛkaapʋ, nɩɩ Ɔnyɩrɩpɛ tɔwɛ mʋ yɛ, “Man waa kufuu, man laatɔ, kyaga sʋ tɔwɛ. ");
INSERT INTO naw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","N tii fʋ sʋ, nɩɩ ɔkʋ mɛɛ taalɛ mata fʋ abɛɛ ɔ waa fʋ kʋtɔ kʋ. Lɩɩ fɛɛ kadɛ kɩnɩmʋ tɔ asa gaalaagaa ba gyɛ mɛ lɛɛ.” ");
INSERT INTO naw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ɩmʋ sʋ Pɔɔlɩ kyɩna tʋtɔ kesu kʋlʋn yɛ kɩdɩyɛ, ɛɛ kaapʋ abwaarɛsɩn ɛɛ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Saŋa mʋ nɩɩ Galiyo gyɛ Akiya kadɛ ɔkɩɩsʋpʋ mʋ, Gyiwu abi akʋ ba bʋga kʋsʋ naa tii Pɔɔlɩ, taa mʋ kpee asɩn ogyikpa. ");
INSERT INTO naw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nɩɩ ba pwɩɩ mʋ fɛɛ, “Ɔnyɩn nɩmʋ ɩɩ kaapʋ asa Kabwaarɛ‐sun kʋ mʋ nɩɩ ɩmaa anɛ nbara mʋ ɩ man gyɛ kʋkʋlʋn.” ");
INSERT INTO naw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Saŋa mʋ nɩɩ Pɔɔlɩ piili yɛ ɔ tɔwɛ mʋ, kadɛ ɔkɩɩsʋpʋ Galiyo tɔwɛ Gyiwu abi mʋ nɩɩ bɛɛ pwɩɩ Pɔɔlɩ mʋ yɛ, “Ɩ daa ɩ gyɛ alibi akʋ abɛɛ kʋtɔ mʋ nɩɩ kɩ man dɛ ɔkpa nɩn, naafɔɔ n daa nu fanɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amaa ɩ maa gyɛ ntɔwɛ kɩtaasɛ yɛ atɩɩ yɛ fanɛ Gyiwu abi nbara falɛ bɩrɛ, fanɛ gbaa‐gbaa fan naa gyii asɩn mʋ. Man gyɛ mɛ ɩ gyɛ kanɩn asɩn nɩmʋ ɔtalɛpʋ.” ");
INSERT INTO naw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nɩɩ ɔ gya bamʋ lɩɩ asɩn ogyikpa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nɩɩ ba kɩtaa Sotene mʋ nɩɩ ɔ gyɛ Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa ɔbɩlɩsa mʋ, dayɩ mu asɩn ogyikpa ɔkɩɩsʋpʋ Galiyo mu ansi tɔ. Amaa ɔ man tɔwɛ sɛhn. ");
INSERT INTO naw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Nɩɩ Pɔɔlɩ kyɩna akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ Korinto mʋ asɛ nkɛ nkʋ, nɩɩ ɔ lɩɩ bamʋ asɛ kpee Siriya. Maa lɩɩ tʋtɔ ee kpee mʋ, Prisila maa Akwila ba buu mʋ kpee. Pɔyɩ kɛ ba faa mʋ, Pɔɔlɩ sɩyɛ mu inyini Kenkera kadɛ tɔ, fɛɛ kanan mʋ nɩɩ ɔ bɔ ntan mʋ. ");
INSERT INTO naw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba maa fʋʋ Efeso mʋ, Pɔɔlɩ yɛgɛ Prisila maa Akwila, nɩɩ o kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa, kɛ maa Gyiwu abi ba naa gyii Yesu asɩn mʋ ɩmɔɔrɛ. ");
INSERT INTO naw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ba maa kʋlɛ mʋ yɛ ɔ kyɩna bamʋ asɛ nkɛ nnyɔ kʋ mʋ, nɩɩ o kina. ");
INSERT INTO naw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Amaa maa kpee mʋ, ɔ da mʋ kɔkɔlɔ sʋ tɔwɛ yɛ, “Nɩɩ Ɩbwaarɛ kan kyula, n biti n bwii ba.” Nɩɩ ɔ lɩɩ Efeso bɔla nkyu sʋ kyʋn. ");
INSERT INTO naw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Saŋa mʋ nɩɩ Pɔɔlɩ naa dan Kasariya mʋ, ɔ naa fwaala Krisito abi kʋbʋ mʋ nɩɩ kɩ bʋ Gyerusalem mʋ. Nɩɩ ɔ kyaga sʋ kpee Antiyoki. ");
INSERT INTO naw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pɔɔlɩ maa gyii nkɛ nkʋ Antiyoki mʋ, ɔ lɩɩ tʋtɔ ɔ naa ɛɛ bɔɔ akɔɔlɛ‐gyipu mʋ sʋ, nɩɩ o kpee Galati yɛ Firigiya yɛgɛ ɛɛ tɔwɛ ɛɛ waa bamʋ ɔlʋn tɔ. ");
INSERT INTO naw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Saŋa maa mʋ, Gyiwu ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Apolosi nɩɩ ba kʋʋgɛ mʋ Alekisanda kadɛ tɔ mʋ ba Efeso. Ɔ gyɛ ɔnyɩn mʋ nɩɩ ɔ sʋ kinyi katɔwɛ tɔ, nɩɩ o nyi Ɩbwaarɛ Asɩnkyan yɩlasa mʋ danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ba kaapʋ mʋ Ɔnyɩrɩpɛ ɔkpa mʋ, nɩɩ ɔ yɩlɛ kɩnyɩn tɔ ɛɛ tɔwɛ yɛgɛ ɛɛ kaapʋ lɩɩ Yesu sʋ kyɛɛkyɛɛ sʋ. Amaa Gyɔn kekyu gyee nkʋn nɩɩ o nyi. ");
INSERT INTO naw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Prisila maa Akwila ba maa nu Apolosi maa tɔwɛ Yesu asɩn Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa yɛ kɩnyɩn tɔ mʋ, ba tɩɩ mʋ kpee bamʋ kɩkpaara sʋ, nɩɩ ba naa lɛɛ Ɩbwaarɛ ɔkpa mʋ kaapʋ mʋ kyɛɛkyɛɛ sʋ tii sʋ. ");
INSERT INTO naw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Saŋa mʋ nɩɩ Apolosi waa mʋ nfɛɛrɛ fɛɛ ee biti o kpee Akiya mʋ, akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ Efeso mʋ ba waa mʋ ɔlʋn tɔ. Nɩɩ ba kyʋrɔɔ ɔwʋlɛ naa sa akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ Akiya mʋ yɛ ba kɔɔlɛ mʋ. Mu kikpe tʋtɔ mʋ, ɩ kyɛ bamʋ nɩɩ lɩɩ Ɩbwaarɛ kabwaala mʋ sʋ nɩɩ ba kɔɔlɛ gyii mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nɩɩ Apolosi yɩlɛ kɩnyɩn tɔ gyii biri Gyiwu abi mʋ sakyɔ tɔ. Ɔ taa Ɩbwaarɛ Asɩnkyan yɩlasa mʋ kaapʋ bamʋ fɛɛ Yesu ɩ gyɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Saŋa mʋ nɩɩ Apolosi bʋ Korinto mʋ, Pɔɔlɩ taa kasɛ sʋ halɩɩ ɔ ba fʋʋ Efeso. Tʋtɔ nɩɩ ɔ naa wu akɔɔlɛ‐gyipu akʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Nɩɩ ɔ taasɛ bamʋ yɛ, “Fan maa kɔɔlɛ gyii mʋ, fan nyɛ Kayaayu Kyɩrɛkyɩrɛ mʋ?” Nɩɩ ba yɛ, “Ayee, an man pɩɩta nu gbaa yɛ Kayaayu Kyɩrɛkyɩrɛ kʋ bʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ɩmʋ sʋ Pɔɔlɩ bɩla taasɛ bamʋ yɛ, “Kanɩn bɩrɛ, Ɩbwaarɛ kekyugyee mɔmɔ nɩɩ fan nyɛ?” Nɩɩ ba lɛɛ kɔnɔ yɛ, “Gyɔn kekyugyee mʋ nɩɩ an nyɛ.” ");
INSERT INTO naw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nɩɩ Pɔɔlɩ tɔwɛ bamʋ yɛ, “Gyɔn kekyugyee kɩ gyɛ nfɛɛrɛ kɩkyɛɛgɛ lɩɩ alibi tɔ ba Ɩbwaarɛ asɛ nɩn. Kanɩn sʋ Gyɔn tɔwɛ asa yɛ, ba kɔɔlɛ ɔmʋ nɩɩ ɔ bʋ mʋ kamaa tɔ ɛɛ ba mʋ gyii, mʋ ɩ gyɛ Yesu.” ");
INSERT INTO naw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ba maa nu kanɩn mʋ, Pɔɔlɩ gyee bamʋ Ɩbwaarɛ kekyugyee lɩɩ Ɔnyɩrɩpɛ Yesu kɩtɩɩ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔɔlɩ maa taa mʋ abaa gyaga bamʋ sʋ mʋ, Kayaayu Kyɩrɛkyɩrɛ kɩ ba bɔla bamʋ tɔ. Nɩɩ ba tɔwɛ ntɔwɛ pʋpwɛ, nɩɩ Ɩbwaarɛ bɔla bamʋ sʋ tɔwɛ asɩn. ");
INSERT INTO naw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Asa mʋ ba gyɛ anyɩn kudu‐anyɔ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ɩbwaayɩ ɩsa mʋ tɔ mʋ, Pɔɔlɩ i kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɔgyaŋɛkpa, ɔ yɩlɛ kɩnyɩn tɔ ɛɛ tɔwɛ bamʋ kɛ ba kɔɔlɛ Ɩbwaarɛ kuwura‐gyii mʋ asɩn gyii. ");
INSERT INTO naw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amaa akʋ ba waa nkɔlɔ ɔsɩɩ kina, ba man kɔɔlɛ Yesu asɩn mʋ gyii. Nɩɩ ba tɔwɛ asɩn libi yii Ɔnyɩrɩpɛ Ɔkpa mʋ sakyɔ maŋa tɔ. Nɩɩ Pɔɔlɩ lɩɩ ɔgyaŋɛkpa mʋ, nɩɩ ɔ taa akɔɔlɛ‐gyipu mʋ buu mʋ n‐yɩɩ. Kakɛ kʋmaa nɩmʋ maa akɔɔlɛ‐gyipu mʋ bee kpee Tiranu ɔkaapʋkpa nɩɩ ɛɛ kaapʋ bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ɔ kaapʋ kanɩn nsu nnyɔ nɩɩ ɩ yɛgɛ nɩɩ Gyiwu abi yɛ Giriki abi mʋ nɩɩ ba bʋ Asiya ɔsʋwʋlɛ sʋ kpini ba nu Ɔnyɩrɩpɛ Yesu asɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nɩɩ Ɩbwaarɛ bɔla Pɔɔlɩ sʋ waa asɩn kyinkyinsa gaa. ");
INSERT INTO naw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nɩɩ ɩ yɛgɛ nɩɩ asa ba taa atɔ fɛɛ bɔrɩdɩba‐bi yɛ ntaa‐bi mʋ nɩɩ ɩ wʋla mata Pɔɔlɩ n‐yɩɩ mʋ, ba taa naa mata alɔpʋ nɩɩ ba nyɛ alanfɩya, nɩɩ nbwɩɩ libi mɔɔ nɩn, kɛ ba lɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Gyiwu abi akʋ mʋ nɩɩ ba naa bɛɛ gya nbwɩɩ libi mʋ, ba waa kɔkɔlɔ ɔsɩɩ taa Ɔnyɩrɩpɛ Yesu kɩtɩɩ fɛɛ ba taalɛ gya nbwɩɩ libi lɩɩ ɔkʋmaa mʋ nɩɩ ɔ sʋ mʋ tɔ. Nɩɩ bɛɛ tɔwɛ nbwɩɩ libi yɛ, “Lɩɩ Yesu kɩtɩɩ mʋ nɩɩ Pɔɔlɩ tɔwɛ mʋ asɩn mʋ sʋ mʋ, n sa fanɛ kɔnɔ yɛ fan lɩɩ.” ");
INSERT INTO naw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ɩ gyɛ Gyiwu oseepu bɩlɩsa asɛ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Sikefa mu‐bii anaa anyɩnsa asunɔ ɩ waa kanɩn mʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kakaakʋ ba maa kpee ba naa waa kanɩn mʋ, nɩɩ kabwɩɩ libi mʋ lɛɛ kɔnɔ yɛ, “N nyi Yesu, nɩɩ n bɩla n nyi Pɔɔlɩ, amaa anɩmʋ ana ɩ gyɛ fanɛ?” ");
INSERT INTO naw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nɩɩ ɔnyɩn mʋ nɩɩ kabwɩɩ libi mʋ bʋ mʋ tɔ mʋ, tɩyɛ bamʋ sʋ, taalɛ bamʋ kpini. Nɩɩ ɔ dayɩ bamʋ larɩgɛ, nɩɩ ba taa kubolonkpan sɩlɛ lɩɩ kɩkpaara mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Gyiwu abi yɛ Giriki abi mʋ nɩɩ ba bʋ Efeso mʋ, ba maa nu kʋtɔ mʋ nɩɩ kɩ waa mʋ, ɩ kɩtaa bamʋ kufuu. Nɩɩ ba taa bɛɛrɛɛ taa sa Ɔnyɩrɩpɛ Yesu kɩtɩɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nɩɩ asa damantɛ mʋ nɩɩ ba kɔɔlɛ Yesu gyii mʋ, ba lɛɛ bamʋ nnɔ tɔ alibi mʋ nɩɩ ba waa tɔwɛ sakyɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bamʋ adamantɛ mʋ nɩɩ ba gyɛ Sɩtaanɛ adangana awaapʋ mʋ, ba taa bamʋ ɩwʋlɛ mʋ nɩɩ ɩ kaapʋ bamʋ afasɩn mʋ, ba bʋga tɔ nɩɩ ba tuwa ɩmʋ sakyɔ mʋ tɔ. Ba maa waa ɩwʋlɛ mʋ kpini afulee kɔnɔ mʋ, ɩ waa fɛɛ nderebi ngbɩn adunuu. ");
INSERT INTO naw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kanɩn sʋ Ɔnyɩrɩpɛ Yesu asɩn mʋ ɩ yɩlɛ nɩɩ ɩ nyɛ ɔlʋn. ");
INSERT INTO naw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ɩnɩmʋ kpini kamaa mʋ, Pɔɔlɩ waa nfɛɛrɛ fɛɛ ee biti ɔ bɔla lɩɩ Masedoniya yɛ Akiya kɛ o kpee Gyerusalem. Nɩɩ ɔ tɔwɛ yɛ, “Nɩɩ n kan kpee tʋtɔ kamaa mʋ, ɩ dagaa maa bɔɔ Roma gbaa sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nɩɩ o sun mʋ akyɛtɔpʋ Timoti maa Erasitu kpee Masedoniya. Nɩɩ mɛɛ mʋ sii Asiya ɔsʋwʋlɛ sʋ gbɛrɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kanɩn saŋa maŋa tɔ mʋ, lɩɩ fɛɛ Ɔnyɩrɩpɛ Ɔkpa mʋ sʋ mʋ, tɔɔrɔɔ damantɛ tɩyɛ Efeso kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Gbiti ɔŋalagɛpʋ kʋ bʋ Efeso tʋtɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Demetirisu. Ɔ sʋ gbiti ɛɛ bɩlɛ ibu‐pipi fɛɛ ɔdakpa kyɩɩsa Atemisi obu. Nɩɩ mʋ yɛ abuupu mʋ kpini ba sʋ kusun mʋ nɩɩ bɛɛ nyɛ kɩmʋ afulee. ");
INSERT INTO naw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nɩɩ Demetirisu tɩɩ abuupu mʋ kpini yɛ bamʋ nɩɩ ɩ maa bamʋ kusun kɩ gyɛ kʋkʋlʋn mʋ gyaŋɛ. Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Mɛ tɔɔmaa ana fen nyi fɛɛ an nyɛ anɛ kigyii an lɩɩ kusun nɩmʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yɛ fanɛ gbaa‐gbaa fan wu nɩɩ fan nu, fɛɛ Pɔɔlɩ nɩmʋ naa ee nyita asa damantɛ nfɛɛrɛ. Nɩɩ ɩ man gyɛ Efeso nfɩɩ nkʋn, amaa Asiya ɔsʋwʋlɛ sʋ kpini. Nɩɩ ɔ naa ɛɛ tɔwɛ yɛ, ‘Anyɩrɩpɛ mʋ nɩɩ ba taa abaa pɔyɩ mʋ, man gyɛ Ɔnyɩrɩpɛ gbaa kpini‐kpini.’ ");
INSERT INTO naw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Man gyɛ anɛ kusun wʋlɛ nkʋn ii biti i nyita. Amaa anɛ ɔdakpa kyɩɩsa obu yɛ mʋ kɩtɩɩ Atemisi mʋ, ee biti o wu. Nɩɩ asa mʋ nɩɩ ba bʋ Asiya ɔsʋwʋlɛ yɛ dulinyaa tɔ kpini, mʋ nɩɩ ba sʋ bɛɛrɛɛ bɛɛ sa ɔdakpa lala nɩmʋ mʋ, ii biti i biliŋi kɩyan.” ");
INSERT INTO naw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ba maa nu falɛ mʋ, ɩ nyɛ bamʋ agbʋ. Nɩɩ ba piili bee kuusi yɛ, “Anɛ Efeso abi, anɛ ɔdakpa Atemisi mʋ, ɩ gyɛ ɔdakpa lala!” ");
INSERT INTO naw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Opula tɔ nɩɩ kadɛ mʋ tɔ kyaŋɛ ɔlanba. Nɩɩ asa mʋ ba naa kɩtaa Gayusi maa Arisitako mʋ nɩɩ ba gyɛ Masedoniya abi, nɩɩ bee buu Pɔɔlɩ mʋ. Nɩɩ ba bʋga bamʋ kpee asa ɔgyaŋɛkpa. ");
INSERT INTO naw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nɩɩ Pɔɔlɩ daa ee biti fɛɛ o kpee sakyɔ mʋ tɔ, amaa akɔɔlɛ‐gyipu mʋ ba man sa mʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nɩɩ Pɔɔlɩ mʋ kyɛmɩnɛ ana gbaa mʋ nɩɩ ba gyɛ Asiya abɩlɩsa akʋ ba sa kɔnɔ kʋlɛ mʋ fɛɛ ɔ man waa kɛ o kpee sakyɔ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nɩɩ sakyɔ mʋ be mee nu abaa kasɛ. Akʋ bee kuusi yɛ falɛ, nɩɩ banɩmʋ mɔɔ ba yɛ bamʋ lɛɛ ndee. Nɩɩ akʋ mɔɔ ba bʋ tʋtɔ yɛgɛ ba man nyi kʋtɔ mʋ nɩɩ kii kpee sʋ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nɩɩ Gyiwu abi mʋ ba nin Alekisanda kyʋŋɛ kʋbʋ mu ansi tɔ ɔ yɩlɛ bamʋ ayaa tɔ tɔwɛ sa bamʋ. Nɩɩ ɔ nyɛɛ bamʋ kɩbaa yɛ ba laatɔ kɛ ɔ lɛɛ asa mʋ kɔnɔ sa bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Amaa asa mʋ ba maa bɩɩ fɛɛ Alekisanda gyɛ Gyiwu obii mʋ, ba kuusi kyɛɛrɛɛ fɛɛ kerefi anyɔ bɛɛ tɔwɛ yɛ, “Anɛ Efeso abi, anɛ ɔdakpa Atemisi mʋ, ɩ gyɛ ɔdakpa lala!” ");
INSERT INTO naw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nɩɩ kadɛ mʋ tɔ ɔwʋlɛ kyanpʋ yɛgɛ nɩɩ sakyɔ mʋ yɛgɛ ɔlanba mʋ. Nɩɩ ɔ yɛ, “Efeso abi, ɔkʋmaa nɩmʋ nyi fɛɛ anɛ ɔdakpa lala Atemisi, yɛ ɩmʋ kubuu mʋ nɩɩ kɩ lɩɩ sʋsʋ ba tɩyɛ mʋ, ɩmʋ kumu ɩ gyɛ Efeso kadɛ nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ɩmʋ sʋ ɩnɩmʋ ɩ man sʋ kamɔɔrɛ‐gyii, fan laatɔ kɛ fan man kpala. ");
INSERT INTO naw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Asa mʋ nɩɩ fan bɩya nfɩɩ falɛ, ba man yuuri ɔdakpa kʋtɔ kʋkʋ, nɩɩ ba man tɔwɛ da anɛ ɔdakpa kyɩɩsa mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ɩmʋ sʋ nɩɩ Demetirisu maa mʋ tɔɔmaa ana be nyi fɛɛ ba sʋ asɩn akʋ ba pwɩɩ bamʋ bɩrɛ, an sʋ kakɛ mʋ nɩɩ an gyii asɩn kɩbanɛ abɩlɩsa ansi tɔ. Kanɩn sʋ bɛɛ taalɛ ba pwɩɩ bamʋ asɩn ogyikpa tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nɩɩ fan san fan sʋ asɩn akʋ mʋ, kanɩn bɩrɛ fan naa gyii fanɛ asɩn ogyikpa fɛɛ kanan mʋ nɩɩ nbara mʋ ɩ kaapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nɩɩ an man bɩɩ mʋ, an biti an nyɛ ndaga ɔlanba nɩmʋ kɩpwɩɩ. Lɩɩ fɛɛ nɩɩ ba naa taasɛ anɛ ɩmʋ asɩn mʋ, an man sʋ asɩn akʋ nɩɩ an taalɛ taa kaapʋ tɔ lɩɩ kʋtɔ mʋ sʋ nɩɩ ɔlanba mʋ waa.” ");
INSERT INTO naw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nɩɩ kadɛ mʋ tɔ ɔwʋlɛ kyanpʋ mʋ maa tɔwɛ ɩnɩmʋ lʋwɛ mʋ, nɩɩ ɔ yɛgɛ sakyɔ mʋ yaasɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɔlanba mʋ kamaa mʋ, Pɔɔlɩ sun tɩɩ Krisito akɔɔlɛ‐gyipu mʋ, nɩɩ ɔ tɔwɛ waa bamʋ, kala bamʋ, nɩɩ ɔ lɩɩ tʋtɔ kpee Masedoniya. ");
INSERT INTO naw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ɔ natɛ tʋtɔ kyaabɔɔ, ɛɛ tɔwɛ abwaarɛsɩn yɛgɛ ɛɛ tɔwɛ ɛɛ waa asa, nɩɩ ɔ lɩɩ tʋtɔ kpee Akiya ɔsʋwʋlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nɩɩ ɔ kyɩna tʋtɔ ɩbwaayɩ ɩsa. Amaa saŋa mʋ nɩɩ ɔ waa mʋ nfɛɛrɛ fɛɛ ee biti o kpee Siriya ɔsʋwʋlɛ sʋ, nɩɩ ɔ bɩɩ fɛɛ Gyiwu abi ba ŋmina asɩn lɩɩ mʋ sʋ. Ɩmʋ sʋ ɔ kyɛɛgɛ mʋ nfɛɛrɛ bwii kamaa naa bɔla lɩɩ Masedoniya. ");
INSERT INTO naw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Asa mʋ nɩɩ ba buu mʋ kpee ɩ gyɛ Piru mʋ nɩɩ ɔ lɩɩ Bereya mu‐bii‐nyɩnsa Sofata, maa Arisitako maa Sekundu mʋ nɩɩ ba lɩɩ Tesalonika, yɛ Gayusi mʋ nɩɩ ɔ lɩɩ Debe, yɛ Timoti, taa tii Tikiku maa Tirofimu mʋ nɩɩ ba lɩɩ Asiya ɔsʋwʋlɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Asa anɩmʋ ɩ gyankpaa naa gyoo anɛ Trowa kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Amaa Kesu kɔnɔ kɔlɔŋɔ mʋ nɩɩ ɩ bodobodo mʋ nɩɩ kɩ man sʋ kɩfɛ tinsa kamaa tɔ mʋ, an bɔla nkyu sʋ lɩɩ Filipi. Lɩɩ nkɛ nnuu kamaa mʋ, an naa tu bamʋ Trowa. Nɩɩ an gyii nkɛ nsunɔ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nkɛ nsunɔ tɔ kakɛ gyankpaasa mʋ, an ba gyaŋɛ kɛ an gyii Ɔnyɩrɩpɛ agyitɔ mʋ. Pɔɔlɩ maa biti fɛɛ lɩɩkaakɛ ɔ lɩɩ Krisito abi kʋbʋ mʋ asɛ sʋ mʋ, ɔ kyaga sʋ tɔwɛ abwaarɛsɩn mʋ naa fʋʋ halɩɩ kiyiridi nsana. ");
INSERT INTO naw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ɩfɩtɩla ɩ kyɔ abansʋrʋ obu mʋ nɩɩ an gyaŋɛ kɩmʋ tɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nɩɩ kɩyaafɔlɛ kʋ bʋ tʋtɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Yutiku. Ɔ tɛ nfansɩrɛ sʋ ee nu asɩn mʋ yɛgɛ ɛɛ gyɔɔsɛ. Kpalɩ fɛɛ Pɔɔlɩ maa tɔwɛ kyɛɛrɛɛ sʋ mʋ, ɔ taa dɛ nsɩɩrɛ nɩɩ ɔ lɩɩ abansʋrʋ mʋ nɩɩ kɩ gyan sʋ kɩsasapʋ mʋ sʋ ba tɩyɛ kasɛ, nɩɩ o wu. ");
INSERT INTO naw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nɩɩ Pɔɔlɩ kpɩlɩgɛ ba mʋ asɛ, ba bun mʋ sʋ, taa mʋ abaa kyaabɔɔ mʋ, nɩɩ ɔ tɔwɛ yɛ, “Fan man yɛgɛ ɩ tɔɔrɔɔ fanɛ, ɔ san ɛɛ fʋʋtɛ.” ");
INSERT INTO naw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nɩɩ Pɔɔlɩ bwii dii kpee abansʋrʋ mʋ sʋ, naa kpɛɛ bodobodo wɛ. Nɩɩ o bwii kyaga mʋ katɔwɛ sʋ naa fʋʋ kayɩkɛ, nɩɩ ɔ lɩɩ tʋtɔ kyʋn. ");
INSERT INTO naw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nɩɩ asa mʋ ba taa kɩyaafɔlɛ mʋ nɩɩ ɔ san ɔ tɛ nkpa tɔ mʋ kpee kewu. Nɩɩ asa mʋ nkɔlɔ i fuuli bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","An gyankpaa naa taa ɔkʋlɩ lala fɛɛ pantuu bɔla nkyu sʋ kpee Asosi. Tʋtɔ nɩɩ an kpee a naa taa Pɔɔlɩ. Lɩɩ fɛɛ ɔ wʋla tɔwɛ yɛ ee biti ɔ taa ayaa tɔ naa fʋʋ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","An naa mʋ a naa gyaŋɛ Asosi mʋ, an taa mʋ, nɩɩ an ba Mitilene. ");
INSERT INTO naw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ɩmʋ lɩɩkaakɛ mʋ, an lɩɩ tʋtɔ bɔla nkyu sʋ ba Kiyo. Nɩɩ ɩmʋ kayɩ maa bɩla kɛ mʋ, an faa nkyu kpee Samosi, nɩɩ kakɛ sasapʋ mʋ, an naa fʋʋ Miletu. ");
INSERT INTO naw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔɔlɩ waa mʋ nfɛɛrɛ fɛɛ ɔ mɛɛ yɛ ɔ yɩlɛ Efeso, kɛ ɔ man nyɛ ee nyita saŋa Asiya ɔsʋwʋlɛ sʋ. Lɩɩ fɛɛ ee biti bilen, fɛɛ nɩɩ ɔ taalɛ mʋ, o loo Gyerusalem Pentekosi kensi‐gyii kakɛ. ");
INSERT INTO naw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Saŋa mʋ nɩɩ an fʋʋ Miletu mʋ, Pɔɔlɩ sun tɩɩ Efeso Krisito abi kʋbʋ abɩlɩsa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ba maa ba mʋ asɛ mʋ, ɔ tɔwɛ bamʋ yɛ, “Fanɛ gbaa‐gbaa fanɛ fen nyi kanan mʋ nɩɩ n kyɩna yɛ fanɛ, lɩɩ kakɛ gyankpaasa mʋ nɩɩ n ba fanɛ asɛ Asiya ofuli sʋ nfɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nɩɩ n bɩya mɛ n‐yɩɩ kasɛ taa ansi‐kyu, yɛ awʋrʋfɔ mʋ nɩɩ n gyii lɩɩ ɩkpa libi mʋ nɩɩ Gyiwu abi ba biti mɛ mʋ sʋ kpini sun Ɔnyɩrɩpɛ kusun. ");
INSERT INTO naw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nɩɩ fan nyi fɛɛ n man taa kʋtɔ mʋ nɩɩ kii biti kɩ kyɛ fanɛ tɔ mʋ baala fanɛ sʋ. Amaa n tɔwɛ abwaarɛsɩn nɩɩ n kaapʋ fanɛ alandɛ sʋ yɛ akpaara sʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","N lɛɛ asɩn mʋ kesintin tɔwɛ Gyiwu abi yɛ Giriki abi fɛɛ ɩ dagaa fɛɛ ba kyɛɛgɛ bamʋ nfɛɛrɛ, kɛ ba bwii ba Ɩbwaarɛ asɛ, kɛ ba kɔɔlɛ Ɔnyɩrɩpɛ Yesu gyii. ");
INSERT INTO naw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Nbɩɩnbɩɩ bɩrɛ, ɩ fʋʋ fɛɛ n kpee Gyerusalem fɛɛ kanan mʋ nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ tɔwɛ waa mɛ mʋ, amaa n mee nyi kʋtɔ mʋ nɩɩ ki biti kɩ waa mɛ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kʋtɔ mʋ nɩɩ n nyi ɩ gyɛ fɛɛ, kadɛ kʋmaa mʋ nɩɩ n kpee mʋ Kayaayu Kyɩrɛkyɩrɛ mʋ ɩ da mi kumu tɔ fɛɛ awʋrʋfɔ yɛ obu kitii ɩ dɛ i gyoo mɛ. ");
INSERT INTO naw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Amaa man taa mɛ nkpa tɩɩ sɛhn, nɩɩ n mɛɛ kɩɩ mɛ n‐yɩɩ fɛɛ n gyɛ kʋtɔ kʋ. Amɔɔ n kyaga mɛ kɩnatɛ sʋ, kɛ n waa kusun mʋ nɩɩ Ɔnyɩrɩpɛ Yesu taa sa mɛ mʋ lʋwɛ. Ɩmʋ ɩ gyɛ fɛɛ n lɛɛ Ɩbwaarɛ kabwaala Asɩn danbɩrasa mʋ kesintin kaapʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nɩɩ nbɩɩnbɩɩ n nyi fɛɛ fanɛ tɔ bamʋ nɩɩ n natɛ tɔwɛ sʋsʋ kuwura‐gyii asɩn sa mʋ, fanɛ ɔkʋ man bɩla yɛ o wu mi ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ɩmʋ sʋ ndaga, n lɛɛ n tɔwɛ fanɛ kesintin yɛ nɩɩ fanɛ ɔkʋ kan ɔ mɛɛ nyɛ nkpa kakpaa mʋ, ɩ man lɩɩ mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Lɩɩ fɛɛ n man taa Ɩbwaarɛ asɩn kʋ baala fanɛ sʋ, amaa n lɛɛ kʋtɔ kʋmaa tɔwɛ fanɛ. ");
INSERT INTO naw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ɩmʋ sʋ fɛɛ kanan mʋ nɩɩ ɔkɩɩsʋpʋ ɩɩ kɩɩ mʋ nbʋlʋpʋ sʋ mʋ, fan kɩɩ fanɛ n‐yɩɩ sʋ yɛ asa mʋ nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ taa waa fanɛ abaa tɔ, yɛ fan kɩɩ sʋ mʋ danbɩrasa. Fan bɩla Krisito abi kʋbʋ mʋ nɩɩ ɔ taa mʋ gbaa‐gbaa nkalan sɔɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nɩɩ n nyi fɛɛ nɩɩ n kan kpee kamaa tɔ mʋ, akuntun bee biti ba be loo fanɛ tɔ, nɩɩ ba mɛɛ yɛ ba yɛgɛ nbʋlʋpʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Saŋa kʋ ii biti ɔ ba nɩɩ fanɛ tɔ akʋ bee biti ba kʋsʋ yɩlɛ tɩn atɩntɩnsa biliŋaa asɩn mʋ, kɛ ba bɩɩtɛ akɔɔlɛ‐gyipu mʋ ba be buu bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ɩmʋ sʋ fan kɩɩ fanɛ n‐yɩɩ sʋ danbɩrasa, kɛ fan nyiŋi fɛɛ nsu nsa mʋ nɩɩ n maa fanɛ an kyɩna mʋ, n sʋ ansikyu n da fanɛ ɔkʋmaa nɩmʋ kumu tɔ kakyʋwapɛ yɛ kagyanbwɛ. ");
INSERT INTO naw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nbɩɩnbɩɩ n sʋ fanɛ n waa Ɩbwaarɛ kɩbaa tɔ yɛ mʋ kabwaala asɩn tɔ. Mʋ ɩ yɛgɛ nɩɩ fan dan, kɛ ɔ sa fanɛ mu kusee yɛ mʋ asa mʋ nɩɩ ɔ lɔŋɔ yɩla kpini. ");
INSERT INTO naw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nɩɩ mi ansi ɩ man payɩ ɔkʋ suwa abɛɛ mu gbiti abɛɛ mʋ kaalɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Fanɛ gbaa‐gbaa fanɛ fan nyi fɛɛ mɛ abaa nɩmʋ nɩɩ n sʋ n sun n nyɛ maa mɛ tɔɔmaa ana atɔ mʋ nɩɩ i tiri anɛ. ");
INSERT INTO naw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kʋtɔ kʋmaa tɔ mʋ, n kaapʋ fanɛ fɛɛ ɩ dagaa fan waa kusun ɔlʋn sʋ kanɩn kyɛ atiripu tɔ. Kɛ fan nyiŋi Ɔnyɩrɩpɛ Yesu kɔnɔ tɔ asɩn mʋ yɛ, ‘Kakɛɛ sʋ kusee kɩ kyɔ kɩkɔɔlɛ.’ ” ");
INSERT INTO naw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Maa tɔwɛ kanɩn lʋwɛ mʋ, maa bamʋ kpini ba muŋa amulii sʋ kʋlɛ kabwaarɛ‐kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nɩɩ bamʋ kpini ba taa ansikyu biri mʋ tɔ fwaala mʋ. ");
INSERT INTO naw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kʋtɔ mʋ nɩɩ ku duŋi bamʋ ɩbʋlɛ tɔ gaa mʋ, ɩ gyɛ maa tɔwɛ bamʋ yɛ, ba man bɩla yɛ ba wu abaa. Nɩɩ ba sun mʋ ɔkpa kpee ɔkʋlɩ lala mʋ nɩɩ ku du fɛɛ pantuu mʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Saŋa mʋ nɩɩ an barɩgɛ tɔ mʋ, an yii sʋ bɔla ɔpʋ sʋ kpee Kosi kadɛ tɔ. Nɩɩ kɩmʋ lɩɩkaakɛ mʋ, an kpee Rodo kadɛ tɔ, nɩɩ an lɩɩ tʋtɔ kpee Patara kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tʋtɔ nɩɩ an nyɛ ɔkʋlɩ lala mʋ nɩɩ kii kpee Fonesiya ofuli sʋ, nɩɩ an loo kɩmʋ tɔ naa kyʋn. ");
INSERT INTO naw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Anɛ ansi ɩ maa kɩɩ Kiporo kifintin mʋ, nɩɩ an bwii anɛ bɩna sʋ naa fʋʋ Siriya ɔsʋwʋlɛ sʋ. Nɩɩ an yɩlɛ Trowa kadɛ tɔ, tʋtɔ maa nɩɩ bee biti bɛ lɛɛ ɩsʋla ɔkʋlɩ maa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","An maa kpɩlɩgɛ tʋtɔ mʋ, an wu akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ kadɛ mʋ tɔ. Nɩɩ an kyɩna bamʋ asɛ nkɛ nsunɔ. Nɩɩ Kayaayu Kyɩrɛkyɩrɛ mʋ lɛɛ kaapʋ bamʋ, nɩɩ ba tɔwɛ Pɔɔlɩ yɛ ɔ man kpee Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Amaa anɛ saŋa maa fʋʋ mʋ, nɩɩ an bwii kyaga anɛ ɔkpa sʋ. Nɩɩ ba maa bamʋ‐ka ana yɛ bamʋ‐bii ana kpini ba sun anɛ ɔkpa lɩɩ kadɛ mʋ tɔ ba kebunɔ. Tʋtɔ nɩɩ an muŋa kʋlɛ kabwaarɛ‐kʋlɛ. ");
INSERT INTO naw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Saŋa mʋ nɩɩ an kala abaa lʋwɛ mʋ, nɩɩ an loo ɔkʋlɩ lala mʋ tɔ, nɩɩ ba bwii kyʋn kewu. ");
INSERT INTO naw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","An kyaga anɛ ɔkpa sʋ lɩɩ Tayi naa fʋʋ Polimesi. Tʋtɔ nɩɩ an fwaala akɔɔlɛ‐gyipu mʋ, nɩɩ an kyɩna bamʋ asɛ kakɛ kʋlʋn. ");
INSERT INTO naw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lɩɩkaakɛ mʋ, an kpee Kasariya naa loo Filipu mʋ nɩɩ ɔ gyɛ abwaarɛsɩn ɔtɔwɛpʋ mʋ ayɛ. Nɩɩ ɔ bɩla ɔ gyɛ asa asunɔ mʋ nɩɩ ba kyɩna lɛɛ bamʋ Gyerusalem yɛ ba barɩgɛ agyitɔ mʋ tɔ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ɔ sʋ nbii‐kyɩɩsa‐bii ana mʋ nɩɩ ba man pɩɩta bɩɩ anyɩn, nɩɩ Ɩbwaarɛ ɩ bɔla bamʋ sʋ ɛɛ tɔwɛ mʋ asɩn. ");
INSERT INTO naw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Saŋa mʋ nɩɩ an san an bʋ tʋtɔ mʋ, Ɩbwaarɛ Ɔtɔwɛpʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Agabu lɩɩ Gyudeya ba. ");
INSERT INTO naw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Maa ba anɛ asɛ mʋ, ɔ taa Pɔɔlɩ kɩrɩsʋ mʋ ŋmina mʋ gbaa‐gbaa mʋ abaa yɛ mʋ ayaa. Nɩɩ ɔ tɔwɛ yɛ, “Kayaayu Kyɩrɛkyɩrɛ mʋ yɛ, ‘Falɛ maa nɩɩ Gyiwu abi mʋ nɩɩ ba bʋ Gyerusalem mʋ, bee biti ba ŋmina kɩrɩsʋ nɩmʋ wuya, kɛ ba taa mʋ waa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ abaa tɔ.’ ” ");
INSERT INTO naw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Amaa an maa nu falɛ asɩn nɩmʋ mʋ, anaa bamʋ nɩɩ ba bʋ Kasariya kadɛ mʋ tɔ mʋ, an kʋlɛ Pɔɔlɩ yɛ ɔ man kpee Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nɩɩ Pɔɔlɩ tɔwɛ yɛ, “Mɩnɛ ɩ waa nɩɩ fen su, nɩɩ fɛn yaagɛ mɛ kɔkɔlɔ kanɩn? Man gyɛ kiŋmina mʋ nkʋn, amaa n kʋʋla mɛ n‐yɩɩ fɛɛ n wu Gyerusalem lɩɩ Ɔnyɩrɩpɛ Yesu kɩtɩɩ mʋ sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","A maa bɩɩ fɛɛ an pʋpɔlɛ mʋ kpɩnɛ mʋ, nɩɩ an tɔwɛ yɛ, “Ɔnyɩrɩpɛ kebiti nɩn kɩ waa.” ");
INSERT INTO naw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ɩnɩmʋ kamaa mʋ an kʋsʋ kʋʋla kpee Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ Kasariya mʋ akʋ ba sun anɛ kpee Gyerusalem. Nɩɩ ba taa anɛ kpee Kasiporo‐nyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Manson mʋ ayɛ nɩɩ a naa kyɩna tʋtɔ. Ɔ gyɛ akɔɔlɛ‐gyipu agyankpaapʋ mʋ tɔ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","“Saŋa mʋ nɩɩ an fʋʋ Gyerusalem mʋ, anɛ tɔɔmaa ana ba taa kensi‐gyii kʋlɛ anɛ. ");
INSERT INTO naw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lɩɩkaakɛ mʋ, anaa Pɔɔlɩ an kpee a naa wu Gyemisi, nɩɩ Krisito abi kʋbʋ abɩlɩsa mʋ gbaa ba bʋ tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔɔlɩ fwaala bamʋ nɩɩ ɔ kalɛ atɔ mʋ nɩɩ Ɩbwaarɛ bɔla mu kusun sʋ waa sa bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ tɔ kaapʋ bamʋ kʋkʋlʋn‐kʋkʋlʋn.” ");
INSERT INTO naw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ba maa nu falɛ mʋ, nɩɩ ba taa bʋnyaa sa Ɩbwaarɛ. Nɩɩ ba tɔwɛ Pɔɔlɩ yɛ, “Anɛ bɩrɩsa, yɛ fʋ gbaa‐gbaa fʋ, fu wu kanan mʋ nɩɩ Gyiwu abi ngbɩn‐ngbɩn ba kɔɔlɛ gyii ba, nɩɩ ba bɩla ba sʋ Mosesi nbara mʋ tɔ kenken. ");
INSERT INTO naw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Gyiwu abi akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ Gyerusalem nfɩɩ mʋ, ba nu yɛ fɩɩ kaapʋ Gyiwu abi mʋ nɩɩ ba bʋ ndɛndɛmandɛ sʋ mʋ, yɛ ba man buu Mosesi nbara kɛ ba man tɩŋɛ bamʋ‐bii ana iduu, kɛ ba yɛgɛ Gyiwu abi anaana tɔ mʋ kpini. ");
INSERT INTO naw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Mɩnɛ nɩɩ an biti an waa? Lɩɩ fɛɛ ɩ waa nɛnɛ bee biti ba nu fɛɛ fʋ ba. ");
INSERT INTO naw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ɩmʋ sʋ anɛ nfɛɛrɛ mʋ nɩɩ an sʋ an sa fʋ ndee. Asa ana akʋ ba bʋ anɛ asɛ nfɩɩ nɩɩ ba bɔ ntan sa Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Taa bamʋ kɛ faa bamʋ fan kpee, naa lɛɛ fanɛ ineesi, kɛ fʋ ka bamʋ amu su akɔ sa bamʋ, kɛ ba sɩyɛ bamʋ amu. Kɛ ɔkʋmaa nɩmʋ ɔ bɩɩ fɛɛ asɩn mʋ nɩɩ ba tɔwɛ lɩɩ fʋ sʋ mʋ, ɩ man gyɛ kesintin. Lɩɩ fɛɛ fʋ gbaa‐gbaa fʋ, fu buu Mosesi nbara mʋ kyɛɛkyɛɛ. ");
INSERT INTO naw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Amaa akɔɔlɛ‐gyipu mʋ nɩɩ ba man gyɛ Gyiwu abi mʋ bɩrɛ, an tɔwɛ kyula nɩɩ an kyʋrɔɔ ɔwʋlɛ naa sa bamʋ yɛ, ba man gyii agyitɔ kʋmaa mʋ nɩɩ ba dɩla sa ɔdakpa abɛɛ nkalan kʋmaa, kɛ ba man gyii atɔbwaaya mʋ nɩɩ ba man tɩn bamʋ amu nɩɩ ba wu kibelinboni, kɛ ba lɛɛ bamʋ n‐yɩɩ lɩɩ kakyɩɩ abɛɛ kanyɩn‐biti tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ɩmʋ sʋ lɩɩkaakɛ mʋ, Pɔɔlɩ taa asa ana mʋ tii mʋ n‐yɩɩ sʋ nɩɩ ba naa fwɩɩ bamʋ amu tɔ. Nɩɩ o kpee kabwaarɛ‐sunkpa ayɛ mʋ tɔ naa yɩla nkɛ mʋ nɩɩ amu tɔ kɩfwɩɩ mʋ ii biti ɩ lʋwɛ, yɛ saraga mʋ nɩɩ bee biti bɛ lɛɛ sa ɔkʋmaa nɩmʋ. ");
INSERT INTO naw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nkɛ nsunɔ mʋ ɩ maa san gbɛrɛɛ kɛ ɩ lʋwɛ mʋ, Gyiwu abi akʋ mʋ nɩɩ ba lɩɩ Asiya kɩbaafʋn kʋ sʋ mʋ, ba maa wu Pɔɔlɩ kabwaarɛ‐sunkpa ayɛ mʋ tɔ mʋ. Nɩɩ ba fun waa sakyɔ mʋ lɩɩ Pɔɔlɩ sʋ nɩɩ ba kɩtaa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Nɩɩ bee kuusi bɛɛ tɔwɛ yɛ, “Ɩsɩrayɩ abi fan kyɛ tɔ. Ɔnyɩn nɩmʋ ɩ gyɛ ɔmʋ nɩɩ ɔ naa katɩn kʋmaa, ɛɛ kaapʋ asa kpini, yɛgɛ ɛɛ tɔwɛ ee yii anɛ Ɩsɩrayɩ abi yɛ anɛ nbara mʋ yɛ kabwaarɛ‐sunkpa ayɛ mʋ. Nɩɩ ɩmʋ nɩɩ ɩ bɩla i tii sʋ mʋ ɩ gyɛ yɛ, ɔ taa bamʋ nɩɩ ba man gyɛ Gyiwu abi ba anɛ obu kyɩrɛkyɩrɛ lala nɩmʋ tɔ ba waa kɩmʋ ineesi.” ");
INSERT INTO naw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ba maa wʋla wu Efeso ɔnyɩn mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Tirofimu maa Pɔɔlɩ ba maa naa kadɛ lala mʋ tɔ mʋ, ba fɛ nfɛɛrɛ fɛɛ Pɔɔlɩ taa mʋ kpee kabwaarɛ‐sunkpa ayɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nɩɩ kadɛ mʋ kpini asa ba maa nu Pɔɔlɩ asɩn mʋ, ba sɩlɛ lɩɩ kadɛ mʋ tɔ abaafʋn kʋmaa ba. Ba kɩtaa mʋ bɩɩtɛ lɩɩ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, opula tɔ nɩɩ ba tii nbunɔ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ba maa dayɩ Pɔɔlɩ bee biti mʋ kɩmɔɔ mʋ, asɩn mʋ a naa tu Roma abi anaakɔpʋ ɔkɩɩsʋpʋ ɔbɩlɩsa fɛɛ ɩlawʋ ɩ kʋsʋ Gyerusalem kadɛ mʋ kpini tɔ. ");
INSERT INTO naw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ɔbɩlɩsa mʋ taa mʋ kamaa tɔ abi yɛ anaakɔpʋ mʋ akʋ kpee sakyɔ mʋ tɔ. Amaa asa mʋ ba maa wu ɔbɩlɩsa mʋ yɛ anaakɔpʋ mʋ, nɩɩ ba yɛgɛ Pɔɔlɩ kɩdayɛ. ");
INSERT INTO naw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nɩɩ ɔbɩlɩsa mʋ kpee naa kɩtaa Pɔɔlɩ, nɩɩ ɔ yɛgɛ nɩɩ ba taa agbeeleebi anyɔ ŋmina mʋ. Nɩɩ ɔ taasɛ asa mʋ yɛ, “Anɩmʋ nɩn, nɩɩ mɩnɛ nɩɩ ɔ waa?” ");
INSERT INTO naw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nɩɩ asa mʋ akʋ ba yɛ falɛ, nɩɩ banɩmʋ mɔɔ ba yɛ bamʋ lɛɛ ndee. Bamʋ nnɔ ɩ maa kwɩɩ‐kwɩɩ sʋ mʋ, ɩ yɛgɛ nɩɩ ɔbɩlɩsa mʋ man nu asɩn mʋ kasɛ. Nɩɩ ɔ sa kɔnɔ yɛ ba taa Pɔɔlɩ kpee anaakɔpʋ opula. ");
INSERT INTO naw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ba maa taa Pɔɔlɩ naa fʋʋ anaakɔpʋ opula mʋ, nɩɩ bee biti ba dii loo tʋtɔ mʋ, lɩɩ asa mʋ ɔlanba sʋ mʋ, anaakɔpʋ mʋ ba kukuri Pɔɔlɩ kɛ asa mʋ ba man nyɛ dayɩ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nɩɩ sakyɔ mʋ nɩɩ ba buu bamʋ mʋ, bee kuusi yɛ, “Fan mɔɔ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Saŋa mʋ nɩɩ anaakɔpʋ ba sʋ Pɔɔlɩ bee loo tʋtɔ mʋ, ɔ tɔwɛ ɔbɩlɩsa mʋ yɛ, “Naafɔɔ n biti fɛɛ n tɔwɛ fʋ asɛ.” Nɩɩ ɔbɩlɩsa mʋ taasɛ mʋ yɛ, “Fii nu Giriki katɔwɛ?” ");
INSERT INTO naw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nɩɩ ɔ bɩla bwii taasɛ mʋ yɛ, “Man gyɛ fʋ ɩ gyɛ Egyipiti kanyɩn mʋ nɩɩ ɔ kʋsʋ yɩlɛ ɛɛ kɔ yɛ anɛ, nɩɩ ɔ taa amɔɔpʋ ngbɩn nna kpee ofuli sʋ mʋ?” ");
INSERT INTO naw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Nɩɩ Pɔɔlɩ lɛɛ kɔnɔ yɛ, “Ayee, n gyɛ Gyiwu obii nɩn, nɩɩ n lɩɩ Taasu kadɛ kparɛ mʋ nɩɩ kɩ bʋ Silisiya ɔsʋwʋlɛ sʋ mʋ, nɩɩ asa be nyi kɩmʋ mʋ. N kʋlɛ fʋ nɩn, yɛgɛ n tɔwɛ asa mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ɔbɩlɩsa mʋ maa sa mʋ ɔkpa mʋ, Pɔɔlɩ kʋsʋ yɩlɛ obu adenbi diisa sʋ. Nɩɩ ɔ nyɛɛ bamʋ kɩbaa yɛ ba laatɔ. Ba maa laatɔ mʋ, nɩɩ ɔ tɔwɛ bamʋ Gyiwu abi katɔwɛ. ");
INSERT INTO naw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Nɩɩ ɔ tɔwɛ yɛ, “Nsɛ ana yɛ mɛ‐daa ana, fan nu mɛ asɩn mʋ nɩɩ n biti n lɛɛ kɔnɔ fanɛ asɛ falɛ!” ");
INSERT INTO naw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nɩɩ ba maa nu fɛɛ Gyiwu abi katɔwɛ tɔ nɩɩ ɔ sʋ ɛɛ tɔwɛ bamʋ asɛ mʋ, bamʋ kpini ba laatɔ diin. Nɩɩ Pɔɔlɩ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“N gyɛ Gyiwu obii nɩn, nɩɩ ba kʋʋgɛ mɛ Taasu, Silisiya ɔsʋwʋlɛ sʋ. Amaa ba bɩla mɛ Gyerusalem kadɛ lala nɩmʋ tɔ. Nɩɩ Gamaliye ɩ kaapʋ mɛ anɛ naana ana nbara mʋ nɩɩ ba buu mʋ. Nɩɩ n kpan mɛ n‐yɩɩ n sun Ɩbwaarɛ fɛɛ kanan mʋ nɩɩ fan sʋ tɔ falɛ. ");
INSERT INTO naw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nɩɩ n nyanla bamʋ nɩɩ ba buu Yesu ɔkpa mʋ naa fʋʋ bamʋ lewu tɔ. Nɩɩ n kɩtaa anyɩn yɛ akyɩɩ gbaa naa tii obu. ");
INSERT INTO naw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nɩɩ oseepu bɩlɩsa asɛ yɛ Gyiwu kʋbʋ abɩlɩsa mʋ gbaa bɛɛ taalɛ gyii falɛ asɩn nɩmʋ kesintin. Nɩɩ n bɩla n nyɛ ɩwʋlɛ n lɩɩ bamʋ asɛ fɛɛ n taa naa sa bamʋ bɩrɩsa ana Gyiwu abi mʋ nɩɩ ba bʋ Damasiko kadɛ tɔ. Kɛ ɩ sa mɛ ɔkpa n naa kɩtaa asa anɩmʋ, ŋmina bamʋ taa bamʋ ba Gyerusalem kɛ ba bɩɩtɛ bamʋ asʋ. ");
INSERT INTO naw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“N maa naa n kpee nɩɩ n naa tiri Damasiko kakyʋwapɛ asɛ mʋ, opula tɔ nɩɩ ɩ ŋalɩgɛ mi ansi sʋ fɛɛ bʋlayɩ maa wɛɛ ɩsɛɛ mʋ lɩɩ sʋsʋ ba kyaabɔɔ mɛ. ");
INSERT INTO naw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nɩɩ n lɩɩ tɩyɛ kasɛ nu ɔbʋlɛ kʋ maa taasɛ mɛ yɛ, ‘Sɔɔlɩ! Sɔɔlɩ! Mɩnɛ waa nɩɩ fɩɩ nyanla mɛ kanɩn?’ ");
INSERT INTO naw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Nɩɩ n taasɛ yɛ, ‘Fʋ anɩmʋ nɩn, Ɔnyɩrɩpɛ?’ Nɩɩ ɔ lɛɛ kɔnɔ yɛ, ‘Mɛ Yesu mʋ nɩɩ n gyɛ Ganasareti‐nyɩn nɩɩ fɩɩ nyanla mʋ nɩn.’ ");
INSERT INTO naw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tʋtɔ nɩɩ bamʋ nɩɩ ba bʋ mɛ asɛ mʋ, ba wu ɩŋalɩgɛsa mʋ, amaa ba man bɩɩ ɔbʋlɛ mʋ nɩɩ kɩ tɔwɛ mɛ asɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Nɩɩ n taasɛ yɛ, ‘Ɔnyɩrɩpɛ, nɛnɛ nɩɩ n waa?’ “Nɩɩ Ɔnyɩrɩpɛ mʋ tɔwɛ mɛ yɛ, ‘Kʋsʋ, kɛ fu kpee Damasiko. Tʋtɔ nɩɩ ɔkʋ ii biti ɔ ba tɔwɛ fʋ kʋtɔ mʋ nɩɩ Ɩbwaarɛ tɔwɛ yɩla yɛ fʋ waa.’ ");
INSERT INTO naw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Lɩɩ kanan mʋ nɩɩ ɩ ŋalɩgɛ mi ansi sʋ mʋ, ɩ yɛgɛ nɩɩ n biliŋi gyaatanapʋ. Nɩɩ mɛ bɩrɩsa ana mʋ nɩɩ ba bʋ mɛ asɛ mʋ ba kɩtaa mɛ kɩbaa tɔ kpee Damasiko. ");
INSERT INTO naw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Nɩɩ ɔnyɩn kʋ bʋ tʋtɔ nɩɩ bɛɛ tɩɩ mʋ yɛ Ananiyasi. Nɩɩ ee sun Ɩbwaarɛ ee buu Gyiwu abi nbara mʋ kyɛɛkyɛɛ sʋ, nɩɩ Gyiwu abi mʋ nɩɩ ba tɛ tʋtɔ mʋ, ba sʋ bɛɛrɛɛ ba sa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nɩɩ ɔ ba mɛ asɛ ba yɩlɛ tɔwɛ mɛ yɛ, ‘Mɛ bɩrɩsa Sɔɔlɩ, fu ansi i bugi.’ Nɩɩ opula tɔ nɩɩ mi ansi a bugi nɩɩ n wu mʋ. ");
INSERT INTO naw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Tʋtɔ nɩɩ ɔ tɔwɛ mɛ yɛ, ‘Anɛ naana ana Ɩbwaarɛ ɩ lɛɛ fʋ yɩla fɛɛ fʋ bɩɩ mu kebiti, kɛ fu wu mʋ kɩyaafɔlɛ kyɩrɛkyɩrɛ Yesu mʋ, kɛ fu nu mʋ asɩn mʋ lɩɩ mʋ kɔnɔ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kɛ fʋ baa fʋ gyɛ mʋ kesintin ogyipu sa asa kpini, lɩɩ kʋtɔ mʋ nɩɩ fu wu nɩɩ fu nu mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nɩɩ mɩnɛ nɩɩ fʋ bɩla fu gyoo? Kʋsʋ yɩlɛ kɛ fʋ yɛgɛ ba gyee fʋ Ɩbwaarɛ kekyugyee kɛ ɔ taa fʋ alibi kɛɛ fʋ, kɛ fʋ tɩɩ Ɔnyɩrɩpɛ kɩtɩɩ.’ ");
INSERT INTO naw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Saŋa mʋ nɩɩ n bwii kpee Gyerusalem nɩɩ n kpee n kʋlɛ kabwaarɛ‐kʋlɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ mʋ, n nyɛ ansi sʋ kɩlɛɛkaapʋ. ");
INSERT INTO naw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nɩɩ n wu Ɔnyɩrɩpɛ Yesu nɩɩ ɔ tɔwɛ mɛ yɛ, ‘Waa bilen lɩɩ Gyerusalem, lɩɩ fɛɛ fu kesintin asɩn mʋ nɩɩ fii biti fu gyii lɩɩ mɛ n‐yɩɩ sʋ mʋ, ba mɛɛ yɛ ba kɔɔlɛ gyii.’ ");
INSERT INTO naw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Nɩɩ n tɔwɛ yɛ, ‘Ɔnyɩrɩpɛ, bamʋ gbaa‐gbaa be nyi kanan mʋ nɩɩ n loo bamʋ kabwaarɛ kʋlɛkpa ibu ana tɔ, n dayɩ yɛgɛ n kɩtaa bamʋ nɩɩ ba kɔɔlɛ fu gyii mʋ n kpee n tii obu. ");
INSERT INTO naw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Saŋa mʋ nɩɩ bɛɛ mɔɔ fʋ kesintin ogyipu Sitefen mʋ, n yɩlɛ tʋtɔ kyula mu kelewu mʋ, nɩɩ mɛ ɩ kɩɩ bamʋ nɩɩ ba mɔɔ mʋ mʋ ɩkaalɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nɩɩ Ɔnyɩrɩpɛ mʋ tɔwɛ mɛ yɛ, “natɛ, n biti n sun fʋ lɩɩ nfɩɩ kpee kata‐kata bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ asɛ”.’ ” ");
INSERT INTO naw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nɩɩ asa mʋ ba nu Pɔɔlɩ katɔwɛ naa fʋʋ mʋ asɩn mʋ nɩɩ ɔ tɔwɛ falɛ sʋ. Tʋtɔ nɩɩ ba diyaa bamʋ ɩbʋlɛ kuusi yɛ, “Fan lɛɛ ɔnyɩn nɩmʋ lɩɩ kasɛ sʋ, ɔ man dagaa maa bɩla kyɩna nkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Saŋa mʋ nɩɩ bee kuusi bɛɛ lɛɛ bamʋ ɩkaalɛ bee fugiti, yɛgɛ bɛɛ waa apurutiti mʋ, ");
INSERT INTO naw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","nɩɩ anaakɔpʋ ɔbɩlɩsa mʋ sa kɔnɔ yɛ ba taa Pɔɔlɩ loo bamʋ kɩkpaara sʋ. Kɛ ba tɩŋɛ mʋ taasɛ mʋ kʋtɔ mʋ nɩɩ ɔ waa, nɩɩ bee kuusi bɛɛ wʋrɩgɛ mʋ sʋ kanɩn. ");
INSERT INTO naw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Amaa saŋa mʋ nɩɩ ba ŋmina Pɔɔlɩ kɛ ba bun mʋ tɩŋɛ mʋ mʋ, ɔ taasɛ ɔbɩlɩsa mʋ nɩɩ ɛɛ kɩɩ anaakɔpʋ kɩlɩfa sʋ mʋ yɛ, “Ɩ dɛ ɔkpa fɛɛ ba tɩŋɛ ɔmʋ nɩɩ Roma obii ba kɔɔlɛ mʋ fɛɛ odibii, nɩɩ ba man pɩɩta gyii mʋ asɩn kɛ ba bun mʋ kʋpwɛ?” ");
INSERT INTO naw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Saŋa mʋ nɩɩ ɔbɩlɩsa mʋ nɩɩ ɛɛ kɩɩ anaakɔpʋ kɩlɩfa sʋ mʋ nu kanɩn mʋ, ɔ naa kasɛ asɩn mʋ sa anaakɔpʋ kpini ɔbɩlɩsa mʋ. Nɩɩ ɔ tɔwɛ mʋ yɛ, “Roma abi ba kɔɔlɛ ɔnyɩn nɩmʋ fɛɛ odibii nɩn, amaa kɩɩ kʋtɔ mʋ nɩɩ an biti an waa?” ");
INSERT INTO naw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ɩmʋ sʋ anaakɔpʋ ɔbɩlɩsa mʋ naa taasɛ Pɔɔlɩ yɛ, “Tɔwɛ mɛ, Roma abi ba kɔɔlɛ fʋ fɛɛ odibii?” Nɩɩ Pɔɔlɩ lɛɛ kɔnɔ yɛ, “Ɛɛhn, n gyɛ.” ");
INSERT INTO naw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nɩɩ anaakɔpʋ ɔbɩlɩsa mʋ yɛ, “N nyita afulee gaa pɔyɩ nɩɩ Roma abi ba kɔɔlɛ mɛ fɛɛ odibii.” Amaa Pɔɔlɩ lɛɛ kɔnɔ yɛ, “Mɛɛ mɛ bɩrɛ ba kʋʋgɛ mɛ nɩn fɛɛ Roma odibii.” ");
INSERT INTO naw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ɩmʋ sʋ bamʋ nɩɩ ba daa bee biti fɛɛ ba taasɛ Pɔɔlɩ kɔnɔ tɔ asɩn mʋ, ba bwii kamaa bilen. Nɩɩ ɩ waa anaakɔpʋ ɔbɩlɩsa mʋ gbaa kufuu fɛɛ maa yɛgɛ nɩɩ ba ŋmina Pɔɔlɩ yɛgɛ ɔ gyɛ Roma obii. ");
INSERT INTO naw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Anaakɔpʋ ɔbɩlɩsa mʋ maa biti o wu kʋtɔ kʋlʋn mʋ nɩɩ Pɔɔlɩ dan waa sʋ nɩɩ Gyiwu abi bɛɛ pwɩɩ mʋ mʋ, ɩmʋ sʋ lɩɩkaakɛ mʋ, ɔ yɛgɛ nɩɩ ba saŋɛ Pɔɔlɩ. Nɩɩ ɔ tɩɩ Gyiwu abi aseepu bɩlɩsa yɛ bamʋ kʋbʋ‐kʋbʋ abɩlɩsa mʋ ba sarɛ. Tʋtɔ nɩɩ ɔ bɩya Pɔɔlɩ ba yɩlɛ bamʋ ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Nɩɩ Pɔɔlɩ kɩɩ kʋbʋ‐kʋbʋ abɩlɩsa mʋ kyimm, nɩɩ ɔ tɔwɛ yɛ, “Mɛ tɔɔmaa ana, n nyi mɛ kɔkɔlɔ tɔ fɛɛ lɩɩ mi kusun mʋ nɩɩ n sun sa Ɩbwaarɛ ba fʋʋ ndaga, ɩ bʋrɔn Ɩbwaarɛ asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Opula maŋa tɔ nɩɩ oseepu bɩlɩsa asɛ Ananiyasi mʋ, sa bamʋ nɩɩ ba yɩlɛ tiri Pɔɔlɩ mʋ kɔnɔ yɛ, ba da mʋ kɔnɔ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nɩɩ Pɔɔlɩ lɛɛ kɔnɔ yɛ, “Kɩda nɩɩ Ɩbwaarɛ ii biti ɔ da fʋ gbaa fʋ, fʋ kebunbun ansi wuya. Fʋ kyɩna tʋtɔ bɔla nbara sʋ talɛ mɛ, amaa yɛgɛ fʋ gbaa‐gbaa fʋ, fʋ fɔyɩ nbara, lɩɩ fɛɛ fʋ sa kɔnɔ yɛ ba da mɛ kɔnɔ sʋ.” ");
INSERT INTO naw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bamʋ nɩɩ ba yɩlɛ tiri Pɔɔlɩ mʋ, ba taasɛ mʋ yɛ, “Ɩbwaarɛ oseepu bɩlɩsa asɛ nɩɩ fʋ saalɛ falɛ?” ");
INSERT INTO naw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Nɩɩ Pɔɔlɩ lɛɛ kɔnɔ yɛ, “Mɛ tɔmaa ana, n man nyi fɛɛ ɔ gyɛ Ɩbwaarɛ oseepu bɩlɩsa asɛ nɩn. Kpalɩ fɛɛ ba kyʋrɔɔ yɩla yɛ, ‘Man tɔwɛ asɩn libi gyaga ɔbɩlɩsa mʋ nɩɩ ɛɛ kɩɩ fʋ asa sʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔɔlɩ maa ba bɩɩ fɛɛ asa mʋ akʋ ba gyɛ Sadusi nɩɩ akʋ mɔɔ ba gyɛ Farasii abi mʋ, ɔ tɔwɛ yɛ, “Mɛ tɔmaa ana, ngbaa mɛ n gyɛ Farasii nɩn, mɛ‐sɛ gbaa gyɛ Farasii obii nɩn. Kelewu kyiŋi tamaa mʋ nɩɩ n sʋ sʋ, nɩɩ bee gyii mɛ asɩn falɛ.” ");
INSERT INTO naw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Maa tɔwɛ kanɩn asɩn mʋ, nɩɩ ɩmɔɔrɛ ɩ tɩyɛ Sadusi yɛ Farasii abi mʋ nsana. Nɩɩ kʋbʋ mʋ kɩ barɩgɛ tɔ anyɔ. ");
INSERT INTO naw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sadusi abi mʋ ba man kɔɔlɛ gyii fɛɛ kiwu kyiŋi abɛɛ Ɩbwaarɛ nbɔɔ abɛɛ n‐yaayu ɩ bʋ tɔ, amaa Farasii abi bɩrɛ ba kɔɔlɛ ɩmʋ kpini gyii.) ");
INSERT INTO naw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nɩɩ ɔlanba mʋ waa ɔlʋn. Nɩɩ nbara akaapʋpʋ mʋ nɩɩ ba gyɛ Farasii abi mʋ, ba kʋsʋ yɩlɛ bee gyii ɩmɔɔrɛ ɔlʋn sʋ yɛ, “An man wu alibi akʋ lɩɩ ɔnyɩn nɩmʋ sʋ. Akʋtɔ fɛɛ Ɩbwaarɛ Kayaayu abɛɛ Ɩbwaarɛ kabɔɔ kʋ ɩ tɔwɛ mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Saŋa mʋ nɩɩ ɔlanba mʋ nyɛ akyɔ gaa mʋ, kufuu kɩ kɩtaa anaakɔpʋ ɔbɩlɩsa mʋ, fɛɛ bɛ kan bɩɩtɛ Pɔɔlɩ kyatɛ tɔ. Ɩmʋ sʋ ɔ sa mʋ anaakɔpʋ kɔnɔ fɛɛ, ba kpɩlɩgɛ loo sakyɔ mʋ tɔ naa gbebi Pɔɔlɩ kɔɔlɛ lɩɩ bamʋ asɛ, kɛ ba taa mʋ kpee anaakɔpʋ opula. ");
INSERT INTO naw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lɩɩkaakɛ kagyanbwɛ mʋ, Ɔnyɩrɩpɛ Yesu ba yɩlɛ mʋ asɛ, tɔwɛ mʋ yɛ, “Nyɛ kɔkɔlɔ! Fɛɛ kanan mʋ nɩɩ fʋ lɛɛ mɛ kesintin mʋ kaapʋ Gyerusalem mʋ, kanɩn maa nɩɩ ɩ dagaa fɛɛ fʋ bɩla lɛɛ mɛ asɩn mʋ kaapʋ Roma kadɛ gbaa.” ");
INSERT INTO naw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kayɩ maa kɛ mʋ, Gyiwu abi akʋ ba waa kɔnɔ bɔ ntan yɛ, ba man dan mɔɔ Pɔɔlɩ mʋ, ba mɛɛ yɛ be gyii nɩɩ ba mɛɛ yɛ be nuu. ");
INSERT INTO naw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bamʋ nɩɩ ba waa kanɩn kɔnɔ mʋ ba kyɔ asa adɩna. ");
INSERT INTO naw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nɩɩ ba kpee bamʋ aseepu bɩlɩsa yɛ abɩlɩsa mʋ asɛ naa tɔwɛ bamʋ yɛ, “An bɔ ntan yɛ an man dan mɔɔ Pɔɔlɩ, an mɛɛ yɛ i gyii. ");
INSERT INTO naw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ɩmʋ sʋ nbɩɩnbɩɩ fʋ yɛ kʋbʋ‐kʋbʋ abɩlɩsa mʋ, fen sun naa tɔwɛ anaakɔpʋ ɔbɩlɩsa mʋ yɛ, o bwiiyaa Pɔɔlɩ ba fanɛ ansi tɔ. Kɛ fan waa fɛɛ fen biti fan lɔŋɔ nu mʋ asɩn mʋ tɔ danbɩrasa. Ɩmʋ sʋ an kʋʋla anɛ n‐yɩɩ fɛɛ, nɩɩ ba kan ba sʋ mʋ bɛɛ ba mʋ, pɔyɩ kɛ ɔ fʋʋ nfɩɩ mʋ an biti a mɔɔ mʋ ɔkpa tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Amaa Pɔɔlɩ kawʋpa‐bii maa nu kanan mʋ nɩɩ ba ŋmina mʋ, nɩɩ o kpee naa loo anaakɔpʋ mʋ ayɛ, naa tɔwɛ Pɔɔlɩ. ");
INSERT INTO naw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Nɩɩ Pɔɔlɩ tɩɩ anaakɔpʋ abɩlɩsa mʋ ɔkʋ, nɩɩ ɔ tɔwɛ mʋ yɛ, “Taa kɩyaafɔlɛ nɩmʋ kpee fanɛ ɔkɩɩsʋpʋ ɔbɩlɩsa asɛ. Ɔ sʋ asɩn kparɛ kʋ ɔ tɔwɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ɩmʋ sʋ ɔ taa mʋ kpee ɔkɩɩsʋpʋ ɔbɩlɩsa mʋ asɛ. Nɩɩ ɔ tɔwɛ mʋ yɛ, “Pɔɔlɩ mʋ nɩɩ an taa ba tii obu mʋ, ɩ tɩɩ mɛ. Nɩɩ ɔ yɛ n taa kɩyaafɔlɛ nɩmʋ ba fʋ asɛ, lɩɩ fɛɛ ɔ sʋ asɩn akʋ ɔ tɔwɛ fʋ.” ");
INSERT INTO naw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nɩɩ Anaakɔpʋ ɔkɩɩsʋpʋ ɔbɩlɩsa mʋ, kɩtaa kɩyaafɔlɛ mʋ kɩbaa tɔ lɩɩ ɩkaa sʋ. Nɩɩ ɔ taasɛ mʋ yɛ, “Mɩnɛ asɩn nɩɩ fʋ sʋ fʋ tɔwɛ mɛ?” ");
INSERT INTO naw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nɩɩ Pɔɔlɩ kawʋpa‐bii mʋ tɔwɛ mʋ yɛ, “Gyiwu abi abɩlɩsa mʋ ba tɔwɛ kyula yɛ, bee biti ba kʋlɛ fʋ fɛɛ fʋ taa Pɔɔlɩ ba kʋbʋ‐kʋbʋ abɩlɩsa mʋ asɛ ɔkɛ. Kɛ ba pɩna fʋ yɛ bee biti ba lɔŋɔ nu mʋ asɩn mʋ tɔ danbɩrasa. ");
INSERT INTO naw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amaa man kyula sa bamʋ. Lɩɩ fɛɛ asa mʋ tɔ akʋ ba kyɔ asa adɩna be bun afitiri tɔ bee gyoo mʋ. Nɩɩ ba bɔ ntan fɛɛ ba man dan mɔɔ mʋ mʋ, ba mɛɛ yɛ be gyii nɩɩ ba mɛɛ yɛ be nuu. Ɩmʋ sʋ ba kʋʋla bamʋ n‐yɩɩ bee gyoo ba nu lɩɩ fʋ asɛ kɛ ba waa.” ");
INSERT INTO naw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nɩɩ anaakɔpʋ ɔkɩɩsʋpʋ ɔbɩlɩsa da kɩyaafɔlɛ mu kumu yɛ, “Man kan tɔwɛ ɔkʋ fɛɛ fʋ tɛɛ ba tɔwɛ falɛ asɩn nɩmʋ sa mɛ.” Nɩɩ ɔ lɛɛ mʋ ɔkpa. ");
INSERT INTO naw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tʋtɔ mʋ nɩɩ anaakɔpʋ ɔkɩɩsʋpʋ ɔbɩlɩsa mʋ, tɩɩ mʋ kamaa tɔ abɩlɩsa anyɔ sa bamʋ kɔnɔ yɛ, “Fan lɛɛ anaakɔpʋ anyɔ, yɛ ɩgbaŋɛ adiipu adusunɔ, yɛ akpɛ atʋʋpʋ alɩfa anyɔ. Kɛ fan kʋʋla fanɛ n‐yɩɩ kɛ fan lɩɩ nfɩɩ ndaga kagyanbwɛ kerefi akpanɔ kpee Kasariya. ");
INSERT INTO naw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Fan sa Pɔɔlɩ gbaa ɩgbaŋɛ akʋ, kɛ fan kɩɩ mʋ sʋ naa fʋʋ ɔsʋwʋlɛ ɔkɩɩsʋpʋ Felisi asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Nɩɩ ɔ kyʋrɔɔ ɔwʋlɛ naa sa Felisi. Ɛɛ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mɛ anaakɔpʋ ɔkɩɩsʋpʋ ɔbɩlɩsa Kilodiyo Lisiya ɩ kyʋrɔɔ falɛ ɔwʋlɛ nɩmʋ n sa fʋ Ɔsʋwʋlɛ ɔkɩɩsʋpʋ kparɛ Felisi. “N fwaala fʋ. ");
INSERT INTO naw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Gyiwu abi akʋ ɩ kɩtaa ɔnyɩn nɩmʋ yɛ bee biti ba mɔɔ mʋ. N maa bɩɩ fɛɛ ɔ gyɛ Roma odibii mʋ, nɩɩ maa mɛ ayaafɔlɛ an kɔɔlɛ mʋ yɛgɛ. ");
INSERT INTO naw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nɩɩ n maa biti n bɩɩ kʋtɔ mʋ nɩɩ ɔ waa nɩɩ bɛɛ pwɩɩ mʋ mʋ, n taa mʋ ba bamʋ kʋbʋ‐kʋbʋ abɩlɩsa mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","N bɩɩ fɛɛ asɩn mʋ nɩɩ ba sʋ bɛ pwɩɩ mʋ mʋ, ɩ gyɛ bamʋ Gyiwu abi nbara asɩn nɩn. Amaa n man wu alibi mʋ nɩɩ ɔ waa nɩɩ ɩ dagaa fɛɛ ba mɔɔ mʋ abɛɛ ba tii mʋ obu. ");
INSERT INTO naw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","N maa nu fɛɛ Gyiwu abi akʋ ba ŋmina fɛɛ ba mɔɔ mʋ mʋ, n waa bilen taa mʋ bɩya fʋ. Nɩɩ n tɔwɛ mʋ apwɩɩpʋ mʋ yɛ ba ba pwɩɩ mʋ fu ansi tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ɩmʋ sʋ anaakɔpʋ mʋ ba waa kanan mʋ nɩɩ ba sa bamʋ kɔnɔ mʋ. Kagyanbwɛ maŋa nɩɩ ba taa Pɔɔlɩ kpee naa loo Antipatirisi. ");
INSERT INTO naw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lɩɩkaakɛ mʋ anaakɔpʋ mʋ nɩɩ ba naa ayaa tɔ mʋ, ba bwii kpee bamʋ anaakɔpʋ opula. Nɩɩ ɩgbɛŋɛ adiipu mʋ ba taa mʋ kpee Kasariya. ");
INSERT INTO naw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Anaakɔpʋ mʋ ba maa fʋʋ Kasariya mʋ, ba taa ɔwʋlɛ mʋ sa Ɔsʋwʋlɛ ɔkɩɩsʋpʋ mʋ, nɩɩ ba taa Pɔɔlɩ waa mʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Maa kalɛ ɔwʋlɛ mʋ, nɩɩ ɔ taasɛ Pɔɔlɩ ɔsʋwʋlɛ kʋlʋn mʋ nɩɩ ɔ lɩɩ sʋ. Maa bɩɩ fɛɛ Pɔɔlɩ lɩɩ Silisiya ɔsʋwʋlɛ sʋ mʋ, ");
INSERT INTO naw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nɩɩ ɔ tɔwɛ Pɔɔlɩ yɛ, “Nɩɩ fʋ apwɩɩpʋ ba kan ba mʋ, n biti n nu fʋ asɛ.” Nɩɩ ɔ sa kɔnɔ fɛɛ ba naa kɩɩ mʋ sʋ Owura lala Herodi lenbu tɔ. ");
INSERT INTO naw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pɔɔlɩ maa fʋʋ Kasariya nkɛ nnuu kamaa tɔ mʋ, oseepu bɩlɩsa asɛ Ananiyasi yɛ abɩlɩsa akʋ yɛ lɔya mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Tetulu ba ba. Nɩɩ ba taa bamʋ asɩn pwɩɩsa ba pwɩɩ Pɔɔlɩ ɔsʋwʋlɛ ɔkɩɩsʋpʋ Felisi ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Saŋa mʋ nɩɩ ba tɩɩ Pɔɔlɩ ba loo tʋtɔ mʋ, nɩɩ Tetulu taa asɩn tʋʋ Ɔkɩɩsʋpʋ Felisi ansi tɔ. Nɩɩ ɔ yɛ, “Ɔsʋwʋlɛ Ɔkɩɩsʋpʋ kparɛ, fʋ ɔsʋwʋlɛ kɩkɩta danbɩrasa sʋ mʋ, an nyɛ kayɩɩ yuuli gaa, nɩɩ lɩɩ fʋ kanyaasɩn sʋ mʋ, fʋ yɛgɛ nɩɩ atɔ damantɛ a lɔŋɔ sa anɛ ɔsʋwʋlɛ nɩmʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Katɩn kʋmaa yɛ ɔkpa kʋmaa nɩmʋ sʋ mʋ, an taa kensi‐gyii kɔɔlɛ fʋ awaasa mʋ, nɩɩ an fwaala fʋ gaa. ");
INSERT INTO naw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Amaa kanan mʋ nɩɩ n man nyita fʋ saŋa sʋ mʋ, n kʋlɛ fʋ fɛɛ fu nu anɛ asɛ gbɛrɛɛ lɩɩ ɔnyɩn nɩmʋ asɩn sʋ. ");
INSERT INTO naw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","An wu ɔnyɩn nɩmʋ maa gyɛ alibi wuya, nɩɩ ɔ sʋ kamɔɔrɛ‐gyii ɛɛ kɔla Gyiwu abi dulinyaa tɔ kpini. Nɩɩ ɔ bɩla ɔ gyɛ kʋbʋ mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ Nasarene mʋ ɔgyankpaapʋ. ");
INSERT INTO naw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nɩɩ naafɔɔ o biti fɛɛ ɔ taa ineesi waa kabwaarɛ‐sunkpa ayɛ mʋ, nɩɩ an kɩtaa mʋ. Naafɔɔ an daa biti fɛɛ i gyii mʋ asɩn fɛɛ kanan mʋ nɩɩ anɛ nbara ɩ kaapʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Amaa anaakɔpʋ ɔkɩɩsʋpʋ ɔbɩlɩsa Lisiya ba bɩɩtɛ kɔɔlɛ mʋ ɔlʋn sʋ lɩɩ anɛ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nɩɩ ɔ sa kɔnɔ yɛ mʋ apwɩɩpʋ ba ba fu ansi tɔ. Nɩɩ fʋ gbaa‐gbaa fʋ tʋʋ mʋ tɔ kɩɩ mʋ, fii biti fu wu fɛɛ asɩn mʋ nɩɩ an taa an pwɩɩ mʋ mʋ, ɩ gyɛ kesintin.” ");
INSERT INTO naw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nɩɩ Gyiwu abi mʋ ba yɩlɛ kyula yɛ asɩn mʋ nɩɩ ba taa pwɩɩ mʋ mʋ, kpini ɩ bʋ tɔ kanɩn. ");
INSERT INTO naw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ɔsʋwʋlɛ ɔkɩɩsʋpʋ maa sa Pɔɔlɩ ɔkpa yɛ ɔ tɔwɛ mʋ, nɩɩ ɔ tɔwɛ yɛ, “N nyi fɛɛ fʋ ɩ gyɛ asɩn ogyipu danbɩrasa lɩɩ Gyiwu ɔsʋwʋlɛ nɩmʋ sʋ nsu damantɛ. Ɩmʋ sʋ ɩ waa mɛ ɔkɔn fɛɛ fu ansi tɔ nɩɩ n biti n tɔwɛ mɛ asɩn. ");
INSERT INTO naw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Fɩɩ taalɛ taasɛ kɛ fu wu fɛɛ ɩ waa fɛɛ nkɛ kudu anyɔ nɩmʋ nɩɩ n kpee Gyerusalem n naa sun Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nɩɩ mɛ apwɩɩpʋ banɩmʋ ba man wu n maa gyii ɩmɔɔrɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, abɛɛ n maa fun n waa asa kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa, kadɛ mʋ tɔ katɩn kʋ. ");
INSERT INTO naw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nɩɩ ba mɛɛ taalɛ kaapʋ tɔ asɩn mʋ nɩɩ ba tɩn gyaga mɛ sʋ falɛ, fɛɛ ɩ gyɛ kesintin. ");
INSERT INTO naw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Amaa n kyula fɛɛ Yesu Ɔkpa mʋ nɩɩ ba kɩɩ fɛɛ ɩ gyɛ alibi ɔkpa mʋ, kɩmʋ kɩkaapʋ nɩɩ n sʋ n sun anɛ naana ana Ɩbwaarɛ. Nɩɩ kʋtɔ kʋmaa mʋ nɩɩ ba kyʋrɔɔ waa Mosesi nbara ɩwʋlɛ tɔ, yɛ Ɩbwaarɛ Atɔwɛpʋ ɩwʋlɛ tɔ mʋ n kɔɔlɛ ɩmʋ kpini gyii. ");
INSERT INTO naw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nɩɩ n sʋ tamaa Ɩbwaarɛ asɛ fɛɛ kanan mʋ nɩɩ anyɩn banɩmʋ gbaa ba sʋ mʋ, yɛ saŋa kʋ ii biti ɔ ba nɩɩ Ɩbwaarɛ ii biti o kyiŋi bamʋ nɩɩ bamʋ ɩkpa i kyiigi yɛ bamʋ nɩɩ bamʋ ɩkpa ɩ man kyiigi lɩɩ lewu tɔ. ");
INSERT INTO naw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ɩmʋ sʋ n kpan mɛ n‐yɩɩ, n waa kʋtɔ mʋ nɩɩ kɩ bʋrɔn Ɩbwaarɛ yɛ nyɩmɩsa asɛ. ");
INSERT INTO naw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“N maa lɩɩ Gyerusalem nsu damantɛ kamaa mʋ, n bwii kpee tʋtɔ, taa afulee ba yɛ sa mɛ asa, kɛ n taa kɛkɛɛ sa Ɩbwaarɛ. ");
INSERT INTO naw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","N maa dan lʋwɛ mɛ ineesi kɩfwɩɩ mʋ, nɩɩ n waa ɩnɩmʋ mʋ, nɩɩ mɛ apwɩɩpʋ mʋ ba wu mɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ. Amaa ba man wu ɔkʋ mɛ asɛ, nɩɩ n man waa ɩlawʋ ɩkʋ. ");
INSERT INTO naw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Amaa Gyiwu abi akʋ mʋ nɩɩ ba lɩɩ Asiya kɩbaafʋn ɩ kyɩna ba bʋ tʋtɔ. Nɩɩ naafɔɔ n waa alibi akʋ mʋ, bamʋ ɩ dagaa fɛɛ ba ba pwɩɩ mɛ fu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Abɛɛ yɛgɛ asa anɩmʋ ba tɔwɛ alibi mʋ nɩɩ ba wu lɩɩ mɛ sʋ saŋa mʋ nɩɩ n kpee naa yɩlɛ kʋbʋ‐kʋbʋ abɩlɩsa mʋ asɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Amaa saŋa mʋ nɩɩ n yɩlɛ bamʋ ansi tɔ mʋ, kʋtɔ kʋlʋn nkʋn nɩɩ n kuusi tɔwɛ bamʋ yɛ, ‘Kelewu kyiŋi asɩn mʋ nɩɩ n tɔwɛ nɩɩ ndaga ba pwɩɩ mɛ fu ansi tɔ falɛ.’ ” ");
INSERT INTO naw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nɩɩ Ɔsʋwʋlɛ ɔkɩɩsʋpʋ Felisi mʋ nɩɩ ɔ wʋla o nyi Yesu Ɔkpa asɩn mʋ sʋ mʋ, o nin asɩn mʋ naa yɩla kakɛ pʋpwɛ. Nɩɩ ɔ tɔwɛ yɛ, “Anaakɔpʋ Ɔkɩɩsʋpʋ Lisiya kan ba mʋ, n biti n kɩɩ fʋ asɩn mʋ tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nɩɩ ɔ sa anaakɔpʋ mʋ ɔbɩlɩsa kɔnɔ yɛ, ɔ taa Pɔɔlɩ naa kɩɩ mʋ sʋ danbɩrasa. Kɛ ɔ man yɛgɛ mʋ n‐yɩɩ ɩ nyan mʋ, kɛ ɔ sa ɔkpa kɛ mʋ asa ba ba bɔɔ mʋ sʋ kɛ ba kyɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nkɛ kalɩsa nkʋ kamaa mʋ, Felisi maa mʋ‐ka Durusila mʋ nɩɩ ɔ gyɛ Gyiwu‐kyɩɩ mʋ ba ba. Nɩɩ o sun tɩɩ Pɔɔlɩ, nɩɩ ɔ yɛgɛ nɩɩ Pɔɔlɩ tɔwɛ Yesu Krisito kɩkɔɔlɛ‐gyii mʋ tɔ asɩn sa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pɔɔlɩ maa máá sʋ ɛɛ tɔwɛ nbara kyiigisa asɩn yɛ n‐yɩɩ kɩkɩta yɛ Ɩbwaarɛ katalɛ mʋ nɩɩ kii biti kɩ ba mʋ, ɩ waa Felisi kufuu. Nɩɩ ɔ yɛ, “Ɩ kʋkwɛ kanɩn, natɛ. Nɩɩ n kan nyɛ saŋa mʋ n biti n tɩɩ fʋ.” ");
INSERT INTO naw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tʋtɔ mʋ yɛgɛ ɛɛ waa tamaa fɛɛ Pɔɔlɩ ii biti ɔ sa mu afulee kɛ ɔ yɛgɛ mʋ. Ɩmʋ sʋ saŋa kʋmaa mʋ, ee sun ɛɛ tɩɩ Pɔɔlɩ nɩɩ bee biri aligyima. ");
INSERT INTO naw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nsu nyɔ kamaa mʋ ba lɛɛ Felisi nɩɩ ba taa Pokiyu Fesitu ba yii mʋ ayaa tɔ. Amaa Felisi maa biti fɛɛ ɔ waa kʋtɔ kʋ bɔla Gyiwu abi ansi mʋ, ɔ yɛgɛ nɩɩ Pɔɔlɩ san o tii obu. ");
INSERT INTO naw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nɩɩ Fesitu maa ba Kasariya fɛɛ ɔsʋwʋlɛ ɔkɩɩsʋpʋ mʋ, ɩmʋ nkɛ nsa kamaa mʋ, ɔ lɩɩ tʋtɔ kpee Gyerusalem. ");
INSERT INTO naw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nɩɩ aseepu bɩlɩsa yɛ Gyiwu abi abɩlɩsa ba taa Pɔɔlɩ asɩn mʋ naa tʋʋ mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Nɩɩ ba kʋlɛ Fesitu gaa fɛɛ ɔ waa bamʋ kɔkɔlɔ biti sa bamʋ. Ɩmʋ ɩ gyɛ fɛɛ ɔ yɛgɛ Pɔɔlɩ ɔ lɩɩ Kasariya ba Gyerusalem. Kpalɩ fɛɛ ba waa bamʋ nfɛɛrɛ yɛ ba naa bun ɔkpa tɔ, kɛ ba nyɛ mɔɔ Pɔɔlɩ. ");
INSERT INTO naw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nɩɩ Fesitu lɛɛ kɔnɔ yɛ, “Pɔɔlɩ tii obu Kasariya, nɩɩ ɩ mɛɛ yɛ ɩ kyɛɛrɛɛ mɛ gbaa‐gbaa mɛ n biti n kpee tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Fan lɛɛ fanɛ abɩlɩsa akʋ kɛ maa bamʋ a kpee Kasariya. Nɩɩ fan kan fan sʋ ɔnyɩn mʋ asɩn libi akʋ mʋ, kɛ fan naa mʋ fan tɔwɛ.” ");
INSERT INTO naw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesitu maa kyɩna bamʋ asɛ fɛɛ nkɛ nburuwa abɛɛ nkɛ kudu kamaa tɔ mʋ, ɔ lɩɩ tʋtɔ kpee Kasariya. Kayɩ kɩ maa kɛ mʋ, ɔ naa kyɩna asɩn ogyikpa kagya sʋ. Nɩɩ ɔ sa kɔnɔ yɛ ba taa Pɔɔlɩ ba mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Saŋa mʋ nɩɩ Pɔɔlɩ ba tʋtɔ mʋ, Gyiwu abi abɩlɩsa mʋ nɩɩ ba lɩɩ Gyerusalem ba tʋtɔ mʋ, ba yɩlɛ kyaabɔɔ mʋ. Nɩɩ bɛɛ tɩn atɩntɩnsa bɛɛ gyaga mʋ sʋ, amaa yɛgɛ ba mɛɛ taalɛ kaapʋ ɩmʋ kasɛ. ");
INSERT INTO naw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Nɩɩ Pɔɔlɩ lɛɛ asɩn mʋ kɔnɔ yɛ, “N man waa alibi akʋ lɩɩ Gyiwu abi nbara sʋ, abɛɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, abɛɛ Roma Owura lala Kayisa.” ");
INSERT INTO naw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Amaa Fesitu maa biti fɛɛ ɔ waa Gyiwu abi kɔkɔlɔ biti sʋ mʋ, ɔ taasɛ Pɔɔlɩ yɛ, “Fii biti fɛɛ n kpiya fʋ Gyerusalem, kɛ n naa gyii fʋ asɩn mʋ nɩɩ bɛɛ pwɩɩ fʋ falɛ sʋ mi ansi tɔ abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nɩɩ Pɔɔlɩ lɛɛ kɔnɔ yɛ, “Nbɩɩnbɩɩ n yɩlɛ opula mʋ nɩɩ Roma Owura lala Kayisa ee gyii asɩn mʋ, nɩɩ ɩ dagaa be gyii mɛ asɩn. Amaa Gyiwu abi bɩrɛ n man waa bamʋ alibi akʋ, fɛɛ kanan mʋ nɩɩ fʋ gbaa‐gbaa fʋ, fu nyi falɛ. ");
INSERT INTO naw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Fɛɛ nɩɩ mɛ asɩn akʋ a bun mɛ kʋpwɛ, nɩɩ ɩ dagaa fɛɛ n wu bɩrɛ, man kina kɩmʋ. Amaa asɩn mʋ nɩɩ ba tɩn gyaga mɛ sʋ falɛ, nɩɩ ɩ man gyɛ kesintin mʋ, ɔkʋ mɛɛ taalɛ lɛɛ mɛ sa bamʋ. Ɩmʋ sʋ n biti n taa mɛ asɩn mʋ naa tʋʋ Kayisa ansi tɔ.” ");
INSERT INTO naw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nɩɩ Fesitu maa mʋ atɔwɛ kyatɔpʋ ba maa tɔwɛ lʋwɛ kamaa mʋ, ba tɔwɛ Pɔɔlɩ yɛ, “Fʋ maa tɛɛ tɔwɛ yɛ fʋ taa fʋ asɩn kpee Kayisa ansi tɔ mʋ, Kayisa ansi tɔ nɩɩ fii kpee.” ");
INSERT INTO naw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ɩ maa gyii nkɛ nkʋ kamaa tɔ mʋ, Owura Agiripa yɛ mʋ pɩɩkyɩɩ Benisi ba kpee Kasariya ba naa fwaala Ɔsʋwʋlɛ ɔkɩɩsʋpʋ Fesitu. ");
INSERT INTO naw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ba maa kyɩna tʋtɔ nkɛ nkʋ mʋ, Fesitu tɔwɛ Pɔɔlɩ n‐yɩɩ sʋ asɩn sa owura Agiripa yɛ, “Ɔnyɩn kʋ bʋ tɔ nɩɩ Felisi yɛgɛ nɩɩ o tii obu. ");
INSERT INTO naw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Saŋa mʋ nɩɩ n kpee Gyerusalem mʋ, aseepu bɩlɩsa yɛ Gyiwu abi abɩlɩsa ba bɩya Pɔɔlɩ asɩn pwɩɩsa mi ansi tɔ, nɩɩ bee biti fɛɛ n bun mʋ kʋpwɛ. ");
INSERT INTO naw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Nɩɩ n tɔwɛ bamʋ yɛ, ɩ man gyɛ anɛ Roma abi adɩdaa‐sɩn fɛɛ a bun ɔkʋ kʋpwɛ, amɔɔ maa bamʋ nɩɩ ba pwɩɩ mʋ mʋ, ba gyaŋɛ kɛ ba gyii asɩn mʋ pɔyɩ kɛ ba bun mʋ kʋpwɛ ");
INSERT INTO naw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Saŋa mʋ nɩɩ bamʋ abɩlɩsa ba buu mɛ ba nfɩɩ mʋ, n man taa asɩn mʋ kpɩɩ kasɛ. Amaa ɩmʋ lɩɩkaakɛ mʋ, n kpee naa kyɩna asɩn mʋ ogyikpa, nɩɩ n sa kɔnɔ yɛ ba taa ɔnyɩn mʋ ba tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Amaa saŋa mʋ nɩɩ mʋ apwɩɩpʋ ba kʋsʋ yɩlɛ mʋ, ba man taalɛ kaapʋ tɔ asɩn libi mʋ nɩɩ n da fɛ nfɛɛrɛ mʋ ɩkʋ lɩɩ mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Amaa asɩn mʋ nɩɩ ba nyɛ lɩɩ mʋ sʋ ɩ gyɛ maa bamʋ kabwaarɛ‐sunkpa kamɔɔrɛ‐gyii, yɛ ɔnyɩn kʋ mʋ nɩɩ bɛɛ tɩɩ yɛ Yesu nɩɩ o wu mʋ, nɩɩ Pɔɔlɩ ɩ tɔwɛ fɛɛ ɔ san ɔ tɛ nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nɩɩ asɩn nɩmʋ kɩmɛɛgɛ tɔ ɩ kɩtaa mɛ nfɛɛrɛ. Ɩmʋ sʋ n taasɛ mʋ yɛ, ‘Fii biti fɛɛ fu kpee Gyerusalem kɛ ba naa gyii fʋ asɩn nɩmʋ tʋtɔ abɛɛ? ");
INSERT INTO naw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Amaa Pɔɔlɩ maa kʋlɛ fɛɛ ee biti ɔ baa o tii obu mʋ, naa fʋʋ saŋa mʋ nɩɩ Roma Owura lala Kayisa ii biti o gyii mʋ asɩn mʋ, kanɩn sʋ n kɩtaa mʋ n yɩla naa fʋʋ saŋa mʋ nɩɩ n biti n taa mʋ naa sa owura lala Kayisa.’ ” ");
INSERT INTO naw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Nɩɩ Owura Agiripa tɔwɛ Fesitu yɛ, “Mɛ gbaa‐gbaa mɛ n biti fɛɛ n nu lɩɩ ɔnyɩn nɩmʋ asɛ.” Nɩɩ Fesitu lɛɛ kɔnɔ yɛ, “Ɔkɛ fii biti fu nu lɩɩ mʋ asɛ.” ");
INSERT INTO naw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ɩmʋ sʋ lɩɩkaakɛ mʋ Owura Agiripa maa mʋ‐pɩɩkyɩɩ Benisi ba suu‐tɔ, nɩɩ asa ba taa bɛɛrɛɛ sa bamʋ, nɩɩ anaakɔpʋ abɩlɩsa lala yɛ kadɛ mʋ tɔ abɩlɩsa ba naa gyaŋɛ asɩn ogyikpa mʋ. Nɩɩ Fesitu sa kɔnɔ nɩɩ ba naa bɩya Pɔɔlɩ. ");
INSERT INTO naw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nɩɩ Fesitu kʋsʋ tɔwɛ yɛ, “Owura Agiripa yɛ fanɛ mʋ nɩɩ fan gyaŋɛ anɛ asɛ nfɩɩ kpini fan nu asɩn nɩmʋ. Ɔnyɩn nɩmʋ nɩɩ Gyiwu abi kpini ba kʋlɛ mɛ lɩɩ Gyerusalem yɛ Kasariya nfɩɩ fɛɛ ɔ man dagaa maa bɩla kyɩna nkpa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","N wu fɛɛ ɔ man waa alibi mʋ nɩɩ ɔ dagaa lewu. Amaa lɩɩ fɛɛ ɔ maa taa mʋ asɩn naa sa Owura lala Kayisa sʋ mʋ, n waa mɛ nfɛɛrɛ fɛɛ n kpiya mʋ Roma. ");
INSERT INTO naw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Amaa n man nyɛ asɩn kitii mʋ nɩɩ n kyʋrɔɔ naa sa mɛ Owura lala Kayisa. Ɩmʋ sʋ n taa mʋ ba fanɛ ansi tɔ, fɔnfɔn fʋ owura Agiripa, fɛɛ an kan kɩɩ mʋ asɩn mʋ tɔ mʋ, n nyɛ asɩn kʋ lɩɩ mʋ sʋ kɛ n kyʋrɔɔ. ");
INSERT INTO naw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Lɩɩ fɛɛ ɩ man sʋ kasɛ fɛɛ n lɛɛ obu tiipu kyasɛ Owura Kayisa, yɛgɛ n man kaapʋ tɔ asɩn mʋ nɩɩ bɛɛ sʋ ba pwɩɩ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Nɩɩ Owura Agiripa tɔwɛ Pɔɔlɩ yɛ, “Nbɩɩnbɩɩ ɔkpa dɛ sa fʋ fɛɛ fʋ tɔwɛ fʋ asɩn.” Nɩɩ Pɔɔlɩ kʋsaa mʋ kɩbaa piili ɛɛ tɔwɛ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Owura Agiripa, ɩ gyɛ kumu ɔkɔn sa mɛ fɛɛ ndaga n maa yɩlɛ fu ansi tɔ n biti n lɛɛ kɔnɔ lɩɩ asɩn mʋ nɩɩ Gyiwu abi ba tɩn gyaga mɛ sʋ falɛ kpini. ");
INSERT INTO naw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Fɔnfɔn fɛɛ fʋ bɩrɛ fu nyi Gyiwu abi anaana tɔ kpini yɛ bamʋ ɩmɔɔrɛ‐libi. Ɩmʋ sʋ n kʋlɛ fʋ fɛɛ fʋ nyɛ kɔkɔlɔ kɛ fu nu mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Gyiwu abi kpini be nyi mɛ kakyɩna tɔ lɩɩ koo mi kibi tɔ. Nɩɩ be nyi kanan mʋ nɩɩ n du mɛ gbaa‐gbaa mɛ ɔsʋwʋlɛ sʋ yɛ Gyerusalem tɔ. ");
INSERT INTO naw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nɩɩ bee biti ba gyii kesintin mʋ, ba wʋla be nyi mɛ koo dɩdaa fɛɛ, n kyɩna n gyɛ Farasii kʋbʋ mʋ nɩɩ kɩ gyɛ anɛ kabwaarɛ‐sun, nɩɩ kɩ sʋ anɛ nbara kyɛɛkyɛɛ mʋ ɔkʋ. ");
INSERT INTO naw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ndaga n yɩlɛ nfɩɩ nɩɩ bɛɛ talɛ mɛ, lɩɩ fɛɛ n sʋ tamaa lɩɩ asɩn mʋ nɩɩ Ɩbwaarɛ da mʋ kɔkɔlɔ sʋ sa anɛ naana ana mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Falɛ kɔkɔlɔ mʋ nɩɩ Ɩbwaarɛ da mʋ sʋ, nɩɩ Ɩsɩrayɩ abi nbunɔ kudu anyɔ ba sʋ tamaa yɛ bee biti ba nyɛ sʋ, nɩɩ bee sun Ɩbwaarɛ kakyʋwapɛ yɛ kagyanbwɛ. Owura danbɩrasa, falɛ tamaa nɩmʋ sʋ nɩɩ Gyiwu abi mʋ bɛɛ pwɩɩ mɛ. ");
INSERT INTO naw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mɩnɛ ɩ waa nɩɩ ɩ bʋlʋn sa fanɛ Gyiwu abi nɩɩ fan mɛɛ kɔɔlɛ fen gyii fɛɛ Ɩbwaarɛ i kyiŋi alewupu? ");
INSERT INTO naw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Mɛ gbaa‐gbaa mɛ n daa kɔɔlɛ gyii fɛɛ ɩ dagaa fɛɛ n waa kʋtɔ kʋmaa mʋ nɩɩ n taalɛ waa kun Yesu Kanasareti‐nyɩn mʋ kɩtɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nɩɩ kanɩn gbaa nɩɩ n waa Gyerusalem kadɛ tɔ. N nyɛ ɔlʋn lɩɩ aseepu bɩlɩsa asɛ n naa n kɩtaa Ɩbwaarɛ asa tii obu. Nɩɩ saŋa mʋ nɩɩ ba mɔɔ bamʋ mʋ, mɛ kɔnɔ ki tii sʋ. ");
INSERT INTO naw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Saŋa kʋmaa n kpee Gyiwu abi kabwaarɛ‐kʋlɛ ɩgyaŋɛkpa, nɩɩ n yɛgɛ nɩɩ bɛɛ nyanla bamʋ. Nɩɩ n nyan bamʋ ba tɔwɛ nbusaa asɩn gyaga Yesu sʋ. Lɩɩ fɛɛ kanan mʋ nɩɩ n kisi bamʋ sʋ mʋ, n kpee asa ndɛ sʋ n naa nyanla bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Kanɩn asɩn nɩmʋ sʋ nɩɩ n kyɩna naa kɔɔlɛ ɔwʋlɛ yɛ ɔlʋn lɩɩ aseepu bɩlɩsa mʋ asɛ, nɩɩ n kpee Damasiko. ");
INSERT INTO naw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mɛ Owura danbɩrasa, n maa kpee nɩɩ ɩ naa fʋʋ kakyʋwapɛ asɛ mʋ, nɩɩ n wu fɩtɩla kʋ lɩɩ sʋsʋ kɩ ŋalɩgɛ kɩ kyɔ kyɔwɛ ba kyaabɔɔ maa bamʋ nɩɩ anaa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nɩɩ anɛ kpini an tɩyɛ kasɛ, nɩɩ n nu ɔbʋlɛ kʋ maa tɔwɛ Hibriwu katɔwɛ tɔ yɛ, ‘Sɔɔlɩ, Sɔɔlɩ, mɩnɛ ɩ waa nɩɩ fɩɩ nyanla mɛ kanɩn? Ɩ bʋlʋn sa fʋ fɛɛ fʋ maa kɔɔ yɛ mi kebiti’. ");
INSERT INTO naw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Nɩɩ n taasɛ yɛ, ‘Fʋ anɩmʋ nɩn, Ɔnyɩrɩpɛ?’ Nɩɩ Ɔnyɩrɩpɛ tɔwɛ yɛ, ‘Mɛ Yesu mʋ nɩɩ fɩɩ nyanla mʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Amaa kʋsʋ yɩlɛ fʋ ayaa sʋ. N lɛɛ mɛ n‐yɩɩ kaapʋ fʋ, kɛ n taa fʋ waa mɛ kɩyaafɔlɛ yɛ mi kesintin ogyipu. Nɩɩ kʋtɔ mʋ nɩɩ fu wu lɩɩ mɛ n‐yɩɩ sʋ, yɛ atɔ mʋ nɩɩ n biti n lɛɛ kaapʋ fʋ mʋ, kɛ fʋ taa tɔwɛ asa. ");
INSERT INTO naw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","N biti n sun fu kpee fʋ gbaa‐gbaa fʋ asa yɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi mʋ asɛ, kɛ n mɔlɩgɛ fʋ lɩɩ bamʋ abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kɛ fʋ naa bugi bamʋ ansi, kɛ fʋ lɛɛ bamʋ lɩɩ kitentenbiri tɔ ba fɩtɩla tɔ. Kɛ fʋ lɛɛ bamʋ lɩɩ Sɩtaanɛ ɔlʋn tɔ ba Ɩbwaarɛ asɛ. Kɛ bamʋ nɩɩ bee biti ba kɔɔlɛ gyii mʋ, ba nyɛ alibi kɩtaakɛɛ, kɛ ba nyɛ ɔkyɩnakpa mʋ nɩɩ Ɩbwaarɛ lɔŋɔ yɩla sa mʋ asa mʋ.’ ");
INSERT INTO naw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ɩmʋ sʋ, Owura Agiripa, n man waa kʋsʋ tɔ ɔlʋn sa kɩlɛɛkaapʋ mʋ nɩɩ kɩ lɩɩ sʋsʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kanɩn sʋ n gyankpaa tɔwɛ asɩn nɩmʋ sa Damasiko abi, yɛ Gyerusalem abi. N bɩla tɔwɛ sa bamʋ nɩɩ ba bʋ Gyudeya ɔsʋwʋlɛ sʋ kpini, yɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi. N naa tɔwɛ bamʋ yɛ ba kyɛɛgɛ bamʋ nfɛɛrɛ lɩɩ alibi tɔ, kɛ ba ba Ɩbwaarɛ asɛ, kɛ ba waa ɩmʋ nɩɩ ɩ kaapʋ fɛɛ ba yɛgɛ libi kɩwaa. ");
INSERT INTO naw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Lɩɩ ɩnɩmʋ sʋ nɩɩ Gyiwu abi ba kɩtaa mɛ kabwaarɛ‐sunkpa ayɛ mʋ tɔ, nɩɩ bee biti ba mɔɔ mɛ. ");
INSERT INTO naw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Amaa Ɩbwaarɛ ɩ kyɛ mɛ tɔ ba fʋʋ ndaga kakɛ nɩmʋ. Ɩmʋ sʋ nɩɩ n yɩlɛ nfɩɩ n lɛɛ Yesu kesintin asɩn n kaapʋ asa kpini. Nɩɩ asɩn mʋ nɩɩ Ɩbwaarɛ atɔwɛpʋ yɛ Mosesi tɔwɛ yɩla yɛ ii biti ɩ ba mʋ, ɩmʋ asɩn maŋa nɩɩ n tɔwɛ falɛ. ");
INSERT INTO naw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Asɩn mʋ ɩ gyɛ yɛ, ɩ dagaa fɛɛ Ɔmʋ nɩɩ Ɩbwaarɛ wʋla lɛɛ mʋ maa gyii awʋrʋfɔ, kɛ ɔ baa ɔ gyɛ kelewu kyiŋi tɔ ɔgyankpaapʋ, kɛ ɔ tɔwɛ fɩtɩla mʋ asɩn sa Gyiwu abi yɛ bamʋ nɩɩ ba man gyɛ Gyiwu abi kpini.” ");
INSERT INTO naw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔɔlɩ maa lɛɛ mʋ asɩn mʋ kasɛ kanɩn mʋ, nɩɩ Fesitu tɩn mʋ sʋ pʋntɛ yɛ, “Pɔɔlɩ, fɩɩ lɔɔ ɩbʋn nɩn? Fʋ ɔwʋlɛ kinyi kɩbansa ɩ yɛgɛ nɩɩ fʋ nfɛɛrɛ i nyita.” ");
INSERT INTO naw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nɩɩ Pɔɔlɩ lɛɛ kɔnɔ yɛ, “Ɔsʋwʋlɛ Ɔkɩɩsʋpʋ Fesitu, n mɛɛ lɔɔ ɩbʋn nɩn, n tɔwɛ kesintin asɩn mʋ nɩɩ kanyaasɩn bʋ ɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Owura Agiripa, n kɔɔlɛ gyii fɛɛ fʋ gbaa fu nyi asɩn nɩmʋ sʋ. Ɩmʋ sʋ nɩɩ n yɩlɛ kɩnyɩn tɔ, n tɔwɛ falɛ. Nɩɩ asɩn mʋ nɩɩ n tɔwɛ falɛ ɩmʋ ɩkʋ ɩ man baala fʋ sʋ, lɩɩ fɛɛ ba man waa ɩkʋ asiiri tɔ. ");
INSERT INTO naw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Owura Agiripa, fʋ kɔɔlɛ Ɩbwaarɛ atɔwɛpʋ mʋ asɩn gyii? N nyi fɛɛ fʋ maa kɔɔlɛ gyii.” ");
INSERT INTO naw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tʋtɔ nɩɩ owura Agiripa taasɛ Pɔɔlɩ yɛ, “Fu nyi fɛɛ fɩɩ taalɛ taa saŋa dɛɛ nɩmʋ tɔ kyɛɛgɛ mɛ nfɛɛrɛ, kɛ n ba biliŋi Krisito obii abɛɛ?” ");
INSERT INTO naw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Nɩɩ Pɔɔlɩ lɛɛ kɔnɔ yɛ, “Ɩ gyɛ saŋa dɛɛ nɩmʋ tɔ nɩn o, ii biti ɩ kyɛɛrɛɛ nɩn o, ɩmʋ nɩɩ n kʋlɛ n lɩɩ Ɩbwaarɛ asɛ ɩ gyɛ yɛ, ɔ yɛgɛ fʋ yɛ bamʋ nɩɩ ba sarɛ bee nu mɛ asɛ nfɩɩ mʋ kpini ba biliŋi fɛɛ mɛ, amaa ba man taa agbeeleebi ŋmina bamʋ fɛɛ mɛ.” ");
INSERT INTO naw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Saŋa maa tɔ nɩɩ Owura Agiripa maa mʋ pɩɩkyɩɩ Benisi yɛ Ɔsʋwʋlɛ Ɔkɩɩsʋpʋ Fesitu yɛ bamʋ nɩɩ ba tɛ tʋtɔ mʋ kpini ba kʋsʋ lɩɩ. ");
INSERT INTO naw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ba maa lɩɩ obu mʋ tɔ mʋ, bee biri asɩn mʋ kiligyima, nɩɩ ba tɔwɛ abaa yɛ, “Ɔnyɩn nɩmʋ man waa kʋtɔ mʋ nɩɩ ɩ dagaa fɛɛ ba mɔɔ mʋ, abɛɛ ba tii mʋ obu.” ");
INSERT INTO naw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nɩɩ Agiripa tɔwɛ Fesitu yɛ, “Ɔnyɩn nɩmʋ man dɩn tɔwɛ, yɛ ee biti ɔ taa mʋ asɩn naa sa Owura lala Kayisa nɩn, naafɔɔ an taalɛ yɛgɛ mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Saŋa mʋ nɩɩ ba taa nfɛɛrɛ fɛɛ a kpee Roma kadɛ tɔ mʋ, ba taa Pɔɔlɩ maa bamʋ nɩɩ ba tii bamʋ obu mʋ akʋ, waa anaakɔpʋ kɩlɩfa ɔbɩlɩsa mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ ɔbɩlɩsa Yuriyo abaa tɔ. Nɩɩ ɔ lɩɩ Owura lala Kayisa anaakɔpʋ kʋbʋ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nɩɩ an taa ɔkʋlɩ lala mʋ nɩɩ kɩ lɩɩ Adaramitiyo kadɛ tɔ, nɩɩ kii biti ki kpee Asiya ɔsʋwʋlɛ kabaafʋn kʋkʋ sʋ kebunɔ. Nɩɩ Kamasedoniya‐nyɩn Arisitako mʋ nɩɩ ɔ lɩɩ Tesalonika mʋ gbaa tii anɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ɩmʋ lɩɩkaakɛ mʋ, a naa dan Sidon kadɛ tɔ. Nɩɩ anaakɔpʋ kɩlɩfa Yuriyo waa Pɔɔlɩ adanbɩrasa, sa mʋ ɔkpa fɛɛ ɔ naa wu mʋ kyɛmɩnɛ ana, kɛ ɔ nyɛ nkyɛtɔ lɩɩ bamʋ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nɩɩ an lɩɩ tʋtɔ bɔla ɔpʋ sʋ, lɩɩ fɛɛ afuu mʋ ɩmaa daa ɩ gyaŋa anɛ sʋ mʋ, an bɔla kpee Sipuru kifintin mʋ asɛ katɩn mʋ nɩɩ afuu mʋ a man bʋlʋn. ");
INSERT INTO naw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","A maa bɔla ɔpʋ sʋ naa kara Kilikiya yɛ Panfiliya, nɩɩ a naa dan Mira mʋ nɩɩ kɩ bʋ Lisiya ɔsʋwʋlɛ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tʋtɔ nɩɩ anaakɔpʋ ɔbɩlɩsa mʋ wu ɔkʋlɩ lala kʋ mʋ nɩɩ kɩ lɩɩ Alekisandiya kadɛ tɔ kii kpee Itali. Nɩɩ ɔ taa anɛ naa waa kɩmʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nɩɩ an natɛ nkyu sʋ bwahn‐bwahn gyii nkɛ nkʋ nɩɩ ɩ waa ɔlʋn sa anɛ, pɔyɩ nɩɩ an naa fʋʋ Kinido. Lɩɩ fɛɛ afuu mʋ ɩ maa man sa anɛ ɔkpa sʋ mʋ, an bɔla naa tiri Kereti kefintin mʋ, nɩɩ an kara Salimone kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","A maa naa an kara an kyʋn nbunɔ‐nbunɔ sʋ mʋ, an kpɩnɛ pɔyɩ nɩɩ an ba fʋʋ katɩn mʋ nɩɩ bɛɛ tɩɩ Ɩkʋlɩ lala Ɔdankpa Danbɩrasa, nɩɩ kɩ bʋ tiri Laseya kadɛ. ");
INSERT INTO naw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Lɩɩ fɛɛ an maa kyɛɛrɛɛ ɔkpa tɔ gaa sʋ mʋ, nɩɩ kɔnɔ‐ŋmina saŋa maa kyʋn mʋ, nkyu sʋ kɩbɔla waa kufuu. Ɩmʋ sʋ Pɔɔlɩ da bamʋ amu tɔ tɔwɛ bamʋ yɛ, ");
INSERT INTO naw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Anyɩn, n wu fɛɛ anɛ ɔkpa mʋ nɩɩ an kpee falɛ, ii biti ɩ bɩya kumu libi, yɛ gyerebi lɩɩ ɔkʋlɩ lala mʋ yɛ kɩmʋ ɩsʋla. Nɩɩ anɛ gbaa anɛ an man lɩɩ.” ");
INSERT INTO naw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Amaa anaakɔpʋ ɔbɩlɩsa mʋ ɔ man nu Pɔɔlɩ asɩn mʋ, ɔkʋlɩ wuya mʋ yɛ kɩmʋ ɔkpa ɔkaapʋpʋ asɛ nɩɩ ee nu. ");
INSERT INTO naw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Lɩɩ fɛɛ ɩkʋlɩ ɔdankpa maŋa man bʋrɔn sa awɔɔ saŋa. Nɩɩ bamʋ gaalaagaa ba tɔwɛ kyula yɛ ba kpan bamʋ n‐yɩɩ kɛ ba fʋʋ Fonike. Tʋtɔ ɩkʋlɩ ɔdankpa mʋ ɩ bʋrɔn sa awɔɔ saŋa. Fonike gyɛ ɔdankpa nɩɩ kɩ dɛ Kereti kefintin, mʋ nɩɩ kɩ kɩɩ akpɩlɩgɛ kɩtɩyɛ yɛ adii kɩtɩyɛ nsana tɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Saŋa mʋ nɩɩ afuu pii ɩ daa ɩ lɩɩ akpɩlɩgɛ mʋ, asa mʋ be nyi fɛɛ ba nyɛ afuu mʋ nɩɩ bee biti. Ɩmʋ sʋ ba lɛɛ kɩbɩlɩtɔ mʋ nɩɩ kɩ kɩtaa ɔkʋlɩ lala kɩ yɩla, nɩɩ ba kyaga bamʋ ɔkpa sʋ ba naa Kereti ɩkaa sʋ ɩkaa sʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Amaa ɩ man kyɛɛrɛɛ nɩɩ afuu bʋlʋnsa akʋ, ɩ daa apaa mʋ nɩɩ bɛɛ tɩɩ yɛ Adɩɩ yɛ Kyɔwɛ kɩlɩɩ afuu. Nɩɩ ɩ daa lɩɩ kefintin mʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Saŋa mʋ nɩɩ anɛ ɔkʋlɩ ɩ gyaŋa afuu mʋ, ɔkʋlɩ mʋ man bɩla ɛɛ taalɛ ee kpee ansi tɔ. Ɩmʋ sʋ an yɛgɛ anɛ n‐yɩɩ sa afuu mʋ, nɩɩ i sii ɩ sʋ anɛ ɩ naa. ");
INSERT INTO naw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nɩɩ ɩ sʋla anɛ naa lɩɩ kifintin pii mʋ nɩɩ bɛ tɩɩ yɛ Kuda, nɩɩ kii kun afuu mʋ gbɛrɛɛ. Nɩɩ ɩ waa ɔlʋn sa anɛ pɔyɩ nɩɩ an taalɛ kɩtaa ɔkʋlɩ pii mʋ nɩɩ kɩlala mʋ kɩ bɩɩtɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Anyɩn mʋ ba maa nyɛ ɔkʋlɩ‐pii mʋ, ba taa kɩmʋ waa kɩlala mʋ tɔ, nɩɩ ba taa ɩfɛ ŋmina kyaabɔɔ ɔkʋlɩ lala mʋ kinkin. Nɩɩ ɩ waa bamʋ kufuu fɛɛ afuu mʋ ii biti ɩ sʋla bamʋ naa wɔtɛ Libiya kɩkyafa. Ɩmʋ sʋ ba bɔɔ abaala mʋ, nɩɩ ba yɛgɛ nɩɩ afuu mʋ i sii ɩ sʋ ɔkʋlɩ mʋ ɩ naa. ");
INSERT INTO naw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Afuu mʋ ɩ maa nyanla anɛ kanɩn mʋ, kayɩ kɩ maa kɛ mʋ, ba piili bɛɛ lɛɛ ɔkʋlɩ mʋ tɔ ɩsʋla bɛɛ tʋʋ nkyu mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ɩmʋ kakɛ sasapʋ mʋ, ba taa bamʋ abaa bɛɛ lɛɛ ɔkʋlɩ mʋ gbaa‐gbaa tɔ atɔ bɛɛ tʋʋ nkyu mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","An gyii nkɛ gaalaagaa yɛgɛ a mee wu kyɔwɛ abɛɛ akyikpebi, yɛgɛ afuu mʋ mɔɔ ɩ san ɩ daa kanɩn. Ɩmʋ sʋ anɛ ɔkʋmaa nɩmʋ man bɩla ɔ sʋ tamaa fɛɛ ɔ sʋ nkpa. ");
INSERT INTO naw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","A maa kyɩna akʋn nkɛ gaalaagaa nɩmʋ yɛgɛ a mee gyii sɛhn mʋ, nɩɩ Pɔɔlɩ kʋsʋ yɩlɛ bamʋ nsana tɔwɛ yɛ, “Anyɩn, fan daa nu mɛ katɔwɛ yɛ an man lɩɩ Kereti mʋ, naafɔɔ falɛ awʋrʋfɔ yɛ gyerebi nɩmʋ man dɩn ba anɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Amaa n tɔwɛ fanɛ fɛɛ fan nyɛ kɔkɔlɔ, fanɛ ɔkʋ mɛɛ yɛ o sii tɔ, amɔɔ ɔkʋlɩ mʋ nkʋn ii biti o nyita. ");
INSERT INTO naw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Lɩɩ fɛɛ ndee kagyanbwɛ, Ɩbwaarɛ mʋ nɩɩ n gyɛ mʋ lɛɛ, nɩɩ n sun mɛ mʋ, mʋ kabɔɔ ba yɩlɛ mɛ asɛ. ");
INSERT INTO naw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Nɩɩ ɔ tɔwɛ yɛ, ‘Pɔɔlɩ, man waa kufuu. Ɩ dan ɩ gyɛ fɛɛ fʋ naa yɩlɛ Owura lala Kayisa ansi tɔ. Nɩɩ fʋ sʋ mʋ, Ɩbwaarɛ taa bamʋ nɩɩ be tii fʋ sʋ falɛ kpini nkpa sa bamʋ’. ");
INSERT INTO naw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ɩmʋ sʋ anyɩn, fan nyɛ kɔkɔlɔ. N kɔɔlɛ Ɩbwaarɛ gyii fɛɛ kʋtɔ kʋmaa mʋ nɩɩ ɔ tɔwɛ mɛ mʋ, kanɩn nɩɩ ee biti ɔ waa. ");
INSERT INTO naw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Amaa ɩ waa kanan kʋmaa afuu mʋ ii biti ɩ sʋla anɛ naa dan kefintin kʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","“Nɩɩ a maa gyii nkɛ kudu ana, yɛgɛ ɩ san ɩ sʋ anɛ ɩɩ kyaa ɩɩ bɔɔ Adiratiki ɔpʋ mʋ sʋ. Kiyiridi saŋa mʋ, ɔkʋlɩ mʋ tɔ kusun awaapʋ mʋ, ɩ waa bamʋ fɛɛ bee nin bee tiri kidenbi. ");
INSERT INTO naw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Nɩɩ ba lɛɛ ɔfɛ kalasa tʋʋ katɩn mʋ nɩɩ ba gyan nkyu mʋ sʋ mʋ, nɩɩ ba wu yɛ tʋtɔ ɔnyɛ bunkyin gyɛ abaa nswɩɩ tɔ adʋnyɔ. Ba maa bɩla nin ba ansi tɔ gbɛrɛɛ mʋ, ba bɩla tʋʋ ɔfɛ mʋ wu fɛɛ tʋtɔ ɔnyɛ gyɛ abaa nswɩɩ tɔ kudu anu. ");
INSERT INTO naw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nɩɩ ɩ waa anɛ kufuu fɛɛ akʋtɔ an biti a naa wɔtɛ afʋlɛ‐buu fɛɛ. Ɩmʋ sʋ nɩɩ ba lɛɛ abɩlɩtɔ ana mʋ nɩɩ ɩɩ kɩtaa ɔkʋlɩ ɩɩ yɩlɛ mʋ, tʋʋ nkyu mʋ tɔ, nɩɩ ba kʋlɛ kabwaarɛ‐kʋlɛ fɛɛ kayɩ kɩ kɛ bamʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nɩɩ ɔkʋlɩ mʋ tɔ kusun awaapʋ mʋ ba maa paa fɛɛ ba sɩlɛ lɩɩ ɔkʋlɩ lala mʋ tɔ. Ɩmʋ sʋ ba lɛɛ ɔkʋlɩ‐pii mʋ gyaga ɔpʋ sʋ, bɛɛ pɩna fɛɛ bee biti ba naa lɛɛ abɩlɩtɔ mʋ akʋ ɔkʋlɩ mu ansi tɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nɩɩ Pɔɔlɩ tɔwɛ anaakɔpʋ ɔbɩlɩsa mʋ maa anaakɔpʋ mʋ yɛ, fɛɛ nɩɩ anyɩn anɩmʋ ba man kyɩna ɔkʋlɩ lala mʋ tɔ bɩrɛ, fan mɛɛ yɛ fan nyɛ nkpa. ");
INSERT INTO naw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","“Ɩmʋ sʋ anaakɔpʋ mʋ ba kɩtaa ɩfɛ mʋ nɩɩ ɩ sʋ ɔkʋlɩ‐pii mʋ tɔ mʋ tɩŋɛ tɔ. Nɩɩ ba yɛgɛ kɩmʋ tɔ nɩɩ kɩ kyʋn.” ");
INSERT INTO naw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nɩɩ ɩmʋ kɩbwayɩkɛ asɛ mʋ, Pɔɔlɩ tʋtɔɔ bamʋ asɛ yɛ be gyii agyitɔ. Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Fanɛ nkɛ kudu ana nɩmʋ nɩɩ fan tɛ yɛ kafʋn, yɛgɛ sɛhn mee loo fanɛ nnɔ tɔ, nɩɩ fan tɛ yɛ akʋn. ");
INSERT INTO naw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ɩmʋ sʋ n kʋlɛ fanɛ nɩn fan kʋsʋ gyii agyitɔ, kɛ fan nyɛ ɔlʋn. Fanɛ tɔ ɔkʋlʋn kinyinibi kʋlʋn gbaa mɛɛ yɛ kɩ fɔyɩ.” ");
INSERT INTO naw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔɔlɩ maa tɔwɛ ɩnɩmʋ kamaa mʋ, ɔ taa bodobodo nɩɩ ɔ taa afwaala sa Ɩbwaarɛ bamʋ ansi tɔ. Tʋtɔ nɩɩ ɔ gya bodobodo mʋ tɔ piili ɛɛ wɛ. ");
INSERT INTO naw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nɩɩ bamʋ kpini nkɔlɔ n tɩyɛ bamʋ, nɩɩ ɔkʋmaa nɩmʋ gyii agyitɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nɩɩ anɛ mʋ nɩɩ an bʋ ɔkʋlɩ lala mʋ tɔ mʋ, an gyɛ asa alafa anyɔ yɛ adusunɔ yɛ asiye (276). ");
INSERT INTO naw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Saŋa mʋ nɩɩ ba gyii ŋmɛ mʋ, ba lɛɛ ɩbɔɔta tɔ agyitɔ mʋ tʋʋ ɔpʋ tɔ, kɛ ɔkʋlɩ mʋ ɔ kʋsaa oduu. ");
INSERT INTO naw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kayɩ maa kɛ mʋ, ba man taalɛ bɩɩ kebunɔ mʋ. Amaa ba wu kidenbi kʋ nɩɩ kɩ gyɛ kɩkyafa. Nɩɩ ba waa bamʋ nfɛɛrɛ fɛɛ nɩɩ bɛɛ taalɛ mʋ, ba taa ɔkʋlɩ lala mʋ naa dan tʋtɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ɩmʋ sʋ ba tɩŋɛ ɩfɛ mʋ nɩɩ ɩ sʋ abɩlɩtɔ mʋ nɩɩ ɩ kɩtaa ɔkʋlɩ lala mʋ tɔ ɩ yɩlɛ mʋ waa ɔpʋ mʋ tɔ. Nɩɩ opula maŋa tɔ mʋ, nɩɩ ba saŋɛ ɩfɛ mʋ nɩɩ ɩ sʋ iyu mʋ nɩɩ bɛ sʋ bɛ kaapʋ ɔkpa. Tʋtɔ nɩɩ ba ŋmina kɩtaa lala mʋ nɩɩ bɛɛ tɩɩ kɩmʋ yɛ abaala ɔkʋlɩ mʋ kɔnɔ asɛ sa afuu, kɛ afuu mʋ a sʋla bamʋ i kpee kebunɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Amaa ɔkʋlɩ lala mʋ kasɛ tɔ naa wɔtɛ kɩkyafa. Nɩɩ kɩmʋ ansi tɔ mʋ kɩ man bɩla kɩ taalɛ ki biliŋi. Nɩɩ apaa a daa kɩmʋ kamaa tɔ mʋ gyɛ‐gyɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Nɩɩ anaakɔpʋ mʋ ba waa bamʋ nfɛɛrɛ fɛɛ ba mɔɔ obu atiipu mʋ, kɛ ba man nyɛ tɩyɛ nkyu tɔ sɩlɛ. ");
INSERT INTO naw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Amaa anaakɔpʋ ɔbɩlɩsa mʋ, biti fɛɛ ɔ mɔlɩgɛ Pɔɔlɩ. Ɩmʋ sʋ ɔ man sa bamʋ ɔkpa kɛ ba waa bamʋ nkɔlɔ biti. Nɩɩ ɔ tɔwɛ bamʋ nɩɩ be nyi nkyu kɩtɩyɛ mʋ yɛ, ba gyankpaa fugi tɩyɛ tɔ kɛ ba tɩyɛ lɩɩ kpee ofuli sʋ. ");
INSERT INTO naw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Nɩɩ bamʋ nɩɩ ba san mʋ, ba taa bamʋ n‐yɩɩ bun‐bun itaabo dɩyɛ‐dɩyɛ sʋ. Nɩɩ akʋ mɔɔ ba taa bamʋ n‐yɩɩ bun ɔkʋlɩ iyu boyisa mʋ sʋ. Kanɩn nɩɩ ɩ sʋla ɔkʋmaa nɩmʋ naa dan yɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","A maa fʋʋ kifintin mʋ sʋ yɛ alanfɩya nɩɩ, an bɩɩ fɛɛ bɛɛ tɩɩ kɩmʋ yɛ Malita. ");
INSERT INTO naw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Kifintin mʋ sʋ ndɛ abi ba waa anɛ nsa‐nsa kɔɔlɛ anɛ abaa anyɔ. Bʋlayɩ maa da nɩɩ awɔɔ a bʋ tɔ sʋ mʋ, ba dɛɛla fʋlɔn sa anɛ yɛ a wʋlɛ. ");
INSERT INTO naw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Nɩɩ Pɔɔlɩ naa kʋʋla ngya ɔ ba waa fʋlɔn mʋ tɔ. Maa taa ngya mʋ ɛɛ waa fʋlɔn mʋ tɔ mʋ, nɩɩ fʋlɔn mʋ awulawula ɩ maa wiili kɩnansɛ mʋ, nɩɩ o dun Pɔɔlɩ kɩbaa yɛgɛ ɔ kyɔlɛ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Saŋa mʋ nɩɩ kifintin mʋ sʋ ndɛ abi ba wu kɩnansɛ mʋ maa kyɔlɛ mʋ kɩbaa sʋ mʋ, nɩɩ ba tɔwɛ abaa asɛ yɛ, “Ɔnyɩn nɩmʋ biti ɔ baa ɔ gyɛ ɔmɔɔpʋ nɩn. Lɩɩ fɛɛ maa nyɛ nɩɩ ɔ lɩɩ ɔpʋ mʋ tɔ gbaa mʋ, ɔmʋnɩ ɛɛ ka alibi akɔ mʋ mɛɛ yɛ ɔ yɛgɛ ɔ nyɛ nkpa.” ");
INSERT INTO naw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Amaa Pɔɔlɩ maa ŋmanyan kɩnansɛ mʋ tʋʋ fʋlɔn mʋ tɔ mʋ, sɛhn man waa mʋ. ");
INSERT INTO naw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nɩɩ asa mʋ ba fɛ nfɛɛrɛ fɛɛ Pɔɔlɩ ii biti o puŋa abɛɛ ɔ tɩyɛ opula maŋa tɔ kɛ o wu. Amaa ba maa gyoo naa fʋʋ saŋa kʋ nɩɩ ba wu fɛɛ sɛhn man waa Pɔɔlɩ mʋ, ba kyɛɛgɛ bamʋ nfɛɛrɛ, nɩɩ ba tɔwɛ yɛ, ɔ gyɛ ɔdakpa kʋ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kanɩn kifintin maŋa sʋ ɔkɩɩsʋpʋ mʋ nɩɩ bɛɛ tɩɩ mʋ yɛ Pubilo sʋ kasɛ nɩɩ kɩ bʋ tiri katɩn mʋ nɩɩ an yɩlɛ mʋ. Ɔnyɩn mʋ waa anɛ nsa‐nsa, nɩɩ ɔ kɔɔlɛ anɛ mʋ kɩkpaara sʋ, kɩtaa anɛ kɩfɔ nkɛ nsa. ");
INSERT INTO naw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Saŋa maa Pubilo mʋ‐sɛ dɛ ɛɛ lɔ kibirima yɛgɛ ɛɛ kyaalɛ. Nɩɩ Pɔɔlɩ naa loo taa mʋ abaa gyaga mʋ sʋ, kʋlɛ kabwaarɛ‐kʋlɛ, nɩɩ ɔ nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ɩnɩmʋ ɩ maa waa kanɩn mʋ, nɩɩ kifintin mʋ sʋ alɔpʋ mʋ kpini ba ba Pɔɔlɩ asɛ nɩɩ ba nyɛ alanfɩya. ");
INSERT INTO naw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Lɩɩ kanɩn sʋ ba taa bɛɛrɛɛ sa anɛ ɔkpa kʋmaa nɩmʋ sʋ. Nɩɩ saŋa maa fʋʋ fɛɛ a lɩɩ tʋtɔ mʋ, ba kɛɛ anɛ atɔ mʋ nɩɩ i tiri sa anɛ. ");
INSERT INTO naw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","A maa kyɩna tʋtɔ ɩbwaayɩ ɩsa kamaa mʋ, a naa loo ɔkʋlɩ lala mʋ nɩɩ kɩ lɩɩ Alekisanda nɩɩ kɩ ba sii tʋtɔ awɔɔ saŋa mʋ. Ba kyan ɩdakpa nbwaara‐bii mʋ gyaga kɩmʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","A maa lɩɩ tʋtɔ mʋ, an naa yɩlɛ Sirakusi kadɛ tɔ, nɩɩ an gyii tʋtɔ nkɛ nsa. ");
INSERT INTO naw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Lɩɩ tʋtɔ mʋ, an naa fʋʋ Regiyo kadɛ tɔ. Lɩɩkaakɛ mʋ afuu a da lɩɩ akpɩlɩgɛ, ɩmʋ sʋ kakɛ nyɔsapʋ mʋ, an naa fʋʋ Putoli kadɛ tɔ. ");
INSERT INTO naw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tʋtɔ maŋa nɩɩ an wu akɔɔlɛ‐gyipu akʋ, nɩɩ ba tɔwɛ anɛ yɛ a ba kyɩna bamʋ asɛ nkɛ nsunɔ. Falɛ nɩɩ an natɛ naa fʋʋ Roma. ");
INSERT INTO naw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Akɔɔlɛ‐gyipu mʋ nɩɩ ba bʋ Roma ba maa nu fɛɛ an ba mʋ, ba kʋsʋ ba gyaŋa anɛ. Akʋ ba natɛ kanɩn ba gyaŋa anɛ Apiya Kɩgya opula, nɩɩ akʋ mɔɔ ba ba gyaŋa anɛ ɔfʋʋtɛkpa asa opula mʋ tɔ. Pɔɔlɩ maa wu bamʋ kanɩn mʋ, ɔ fwaala Ɩbwaarɛ, nɩɩ mʋ kɔkɔlɔ kɩ tɩyɛ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","An maa fʋʋ Roma mʋ, ba sa Pɔɔlɩ ɔkpa fɛɛ maa ɔnaakɔpʋ mʋ nɩɩ ɛɛ kɩɩ mʋ sʋ mʋ ba naa kyɩna ntɩn mʋ nɩɩ mʋ Pɔɔlɩ ii biti. ");
INSERT INTO naw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Nkɛ nsa kamaa mʋ, Pɔɔlɩ tɩɩ Gyiwu abɩlɩsa mʋ nɩɩ ba bʋ tʋtɔ mʋ ba sarɛ. Nɩɩ ɔ tɔwɛ bamʋ yɛ, “Mɛ tɔɔmaa ana Gyiwu abi, amaa n maa man waa anɛ asa alibi akʋ gbaa, nɩɩ man nyita anɛ naana ana nbara mʋ, ba kɩtaa mɛ naa tii Gyerusalem, nɩɩ ba taa mɛ waa Roma abi abaa tɔ. ");
INSERT INTO naw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Amaa Roma abi ba maa gyii mɛ asɩn mʋ, ba waa nfɛɛrɛ fɛɛ ba yɛgɛ mɛ, lɩɩ fɛɛ ba man wu alibi mʋ nɩɩ n waa nɩɩ ɩ dagaa ba mɔɔ mɛ. ");
INSERT INTO naw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Saŋa mʋ nɩɩ Gyiwu abi ba kina fɛɛ ba man yɛgɛ mɛ mʋ, nɩɩ ɩ nyan mɛ, nɩɩ n taa asɩn mʋ ba Owura lala Kayisa asɛ. Amaa ɩ man gyɛ fɛɛ n biti n ba tɩɩ mɛ asa ntalɛ nɩn. ");
INSERT INTO naw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Falɛ asɩn nɩmʋ sʋ nɩɩ n tɩɩ fanɛ, kɛ n lɛɛ asɩn mʋ kasɛ sa fanɛ. Lɩɩ Ɔmʋ nɩɩ Ɩsɩrayɩ abi kpini ba sʋ tamaa mʋ sʋ mʋ, nɩɩ ndaga ba ŋmina mɛ agbeeleebi.” ");
INSERT INTO naw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Nɩɩ ba lɛɛ kɔnɔ yɛ, “An man nyɛ ɔwʋlɛ lɩɩ Gyudeya lɩɩ fʋ sʋ. Nɩɩ anɛ bɩrɩsa ana mʋ nɩɩ ba lɩɩ tʋtɔ mʋ ɔkʋ man ba waa adiboyi‐sɩn, nɩɩ ba man tɔwɛ asɩn libi kʋ lɩɩ fʋ sʋ. ");
INSERT INTO naw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amaa anɛ Gyiwu abi an biti an wu fʋ nfɛɛrɛ. Lɩɩ fɛɛ an nyi fɛɛ kʋbʋ mʋ nɩɩ fʋ bʋ kɩmʋ tɔ falɛ, katɩn kʋmaa nɩmʋ asa bɛɛ tɔwɛ bee yii kɩmʋ.” ");
INSERT INTO naw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Gyiwu abi mʋ ba yɩla kakɛ kʋ, kɛ ba maa Pɔɔlɩ ba gyaŋɛ. Kanɩn kakɛ maŋa maa fʋʋ mʋ, bamʋ asa damantɛ ba kpee katɩn mʋ nɩɩ Pɔɔlɩ tɛ mʋ. Lɩɩ nyenyenfuu naa fʋʋ kalaatɩpwɛ mʋ, ɔ kpan mʋ n‐yɩɩ tɔwɛ bamʋ Ɩbwaarɛ kuwura‐gyii mʋ asɩn. Ɔ bɔla Mosesi nbara yɛ Ɩbwaarɛ atɔwɛpʋ ɩwʋlɛ mʋ sʋ kaapʋ bamʋ lɩɩ Yesu sʋ yɛ, ba kɔɔlɛ mʋ gyii. ");
INSERT INTO naw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nɩɩ akʋ ba kɔɔlɛ asɩn mʋ gyii, amaa akʋ mɔɔ ba man kɔɔlɛ gyii. ");
INSERT INTO naw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Saŋa mʋ nɩɩ Pɔɔlɩ tɔwɛ asɩn mʋ laalaalʋwɛ mʋ, asa mʋ ba gyii abaa ɩmɔɔrɛ, nɩɩ bamʋ kpini ba yaasɛ tɔ. Asɩn mʋ nɩɩ Pɔɔlɩ tɔwɛ mʋ ɩ gyɛ fɛɛ, “Kayaayu Kyɩrɛkyɩrɛ mʋ bɔla Ɩbwaarɛ ɔtɔwɛpʋ Isaya sʋ tɔwɛ kesintin sa fanɛ naana ana yɛ, ");
INSERT INTO naw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Kpe asa anɩmʋ asɛ naa tɔwɛ bamʋ yɛ, “Fen biti fan nu asɩn, amaa fan mɛɛ yɛ fan nu kasɛ. Fen biti fan kɩɩ kɛ fan kɩɩ, amaa fɛn mɛɛ yɛ fen wu.” ");
INSERT INTO naw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Lɩɩ fɛɛ asa anɩmʋ nkɔlɔ i budu, nɩɩ bamʋ asʋ a bʋlʋn, nɩɩ ba kɩtaa bamʋ ansi bun sʋ. Nɩɩ ɩ man gyɛ kanɩn sʋ mʋ, naafɔɔ bamʋ ansi ii biti i wu, kɛ bamʋ asʋ a nu, kɛ ba bɩya bamʋ nkɔlɔ kasɛ, kɛ ba biliŋi ba mɛ asɛ kɛ n kyɛ bamʋ.’ ” ");
INSERT INTO naw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Kanɩn sʋ n biti fan bɩɩ fɛɛ, Ɩbwaarɛ taa mʋ kamɔlɩgɛ mʋ naa sa bamʋ nɩɩ ba man gyɛ Gyiwu abi, nɩɩ bee biti be nu mʋ.” ");
INSERT INTO naw_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pɔɔlɩ maa tɔwɛ asɩn nɩmʋ kamaa tɔ mʋ, Gyiwu abi mʋ ba kʋsʋ lɩɩ ba gyii abaa ɩmɔɔrɛ. ");
INSERT INTO naw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔɔlɩ kyɩna kɩkpaara mʋ nɩɩ ɔ kɔɔlɛ nɩɩ ɛɛ ka kɩmʋ sʋ kʋkɔ nsu nnyɔ laalaamuu. Nɩɩ ɛɛ kɔɔlɛ ɔkʋmaa mʋ nɩɩ ɛɛ ba ɛɛ bɔɔ mʋ sʋ mʋ. ");
INSERT INTO naw_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ɔ yɩlɛ kɩnyɩn tɔ ɛɛ tɔwɛ Ɩbwaarɛ kuwura‐gyii mʋ asɩn, nɩɩ ɛɛ kaapʋ asɩn lɩɩ Yesu Krisito sʋ, yɛgɛ sɛhn man tii mʋ ɔkpa.");
INSERT INTO naw_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mɛ, Pɔɔlɩ ɩ kyʋrɔɔ ɔwʋlɛ nɩmʋ n sa fanɛ. N gyɛ Yesu Krisito kɩyaafɔlɛ mʋ nɩɩ ɔ tɩɩ mɛ yɛ n ba waa mu osunpu, nɩɩ ɔ lɛɛ mɛ yɩla yɛ n ba tɔwɛ Ɩbwaarɛ asɩn danbɩrasa mʋ. ");
INSERT INTO naw_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ɩbwaarɛ wʋla da mʋ kɔkɔlɔ sʋ, bɔla mʋ atɔwɛpʋ sʋ nɩɩ ba kyʋrɔɔ asɩn danbɩrasa nɩmʋ waa Asɩnkyan yɩlasa Kyɩrɛkyɩrɛ mʋ tɔ. ");
INSERT INTO naw_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Asɩn mʋ ɩ tɔwɛ ɩ lɩɩ anɛ‐Nyɩrɩpɛ Yesu Krisito sʋ, nɩɩ ɔ gyɛ Ɩbwaarɛ mu‐bii, nɩɩ ba kʋʋgɛ mʋ nyɩmɩsa lɩɩ Owura Dawidi kɩnaana tɔ. ");
INSERT INTO naw_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Anɛ‐Nyɩrɩpɛ Yesu Krisito mʋ nɩɩ Ɩbwaarɛ Kayaayu Kyɩrɛ