﻿USE sofia;
DROP TABLE IF EXISTS sofia.nas_vpl;
CREATE TABLE nas_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nas_vpl WRITE;
INSERT INTO nas_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tenang tutunaꞌ masipoꞌ Kumponinge aaꞌning paning eeꞌnoko kansiꞌ nkovuuꞌnang. ");
INSERT INTO nas_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Aung kansiꞌ tee, emuꞌ otoinaꞌ otoarukoꞌ; naroomparavaꞌ otokoꞌ; tamung domaang-poꞌningmeeva otokoꞌ. Dau-eta mutaanange dakaꞌpui otokoꞌ tee poonaruꞌ baka otoko, eeꞌnoko tee Kumponing bakaang Tanuaang tee-koo pirung-koo daue aavinuko. ");
INSERT INTO nas_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tenang Kumponinge karoma aaꞌpuuꞌ, “Araka, tavoꞌdaravai,” eeꞌnoko tenang araka oroꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Eeꞌnoko Kumponinge tee araka tampaꞌ oovura dotuarara tee araka simpeꞌuuꞌ mutaanang-eta. ");
INSERT INTO nas_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Eeꞌnoko Kumponinge tee araka doonaaꞌ tampuuꞌ eeꞌnoko mutaanang muung tampuuꞌ. Teketa aaꞌnouꞌ muung tankinuko taneꞌpuuꞌ eeꞌnoko teꞌmung teꞌmung tutunaꞌnaꞌmung. ");
INSERT INTO nas_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Eeꞌnoko Kumponinge napoꞌ karoma aaꞌpuuꞌ, “Meerooꞌnavaro doona otoai tankaampuresi pirung boonaruꞌ eeꞌnoko ntong kamoꞌkoong.” ");
INSERT INTO nas_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tee meerooꞌnavaro tee, Kumponinge teing ntong meuꞌ tankaampureeꞌnaang nkovuuꞌ boonaruꞌ daunaruꞌketa. ");
INSERT INTO nas_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Eeꞌnoko Kumponinge tee meerooꞌnavaro doona auviꞌau tampuuꞌ, teketa aaꞌnouꞌ muung tankinuko taneꞌpuuꞌ eeꞌnoko teꞌmung teꞌmung keꞌmunta-naꞌmung. ");
INSERT INTO nas_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Teketa napoꞌ Kumponinge aaꞌpuuꞌ, “Aiaꞌ, ntong paning-koo boong otoing naroꞌ poontarako koverenooꞌ oroꞌparavai,” eeꞌnoko teeꞌ masikaꞌ nkoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Teketa Kumponinge teꞌ koverenooꞌ kansiꞌ tampuuꞌ eeꞌnoko tee ntong poonaruꞌ pirung tampuuꞌ. Eeꞌnoko Kumponinge tampaꞌ oovura dotuaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Eeꞌnoko Kumponinge napoꞌ karoma aaꞌpuuꞌ, “Kansiꞌkoo baaꞌ eeꞌnoko koiꞌnanka amutemuriiꞌ dupuai, aaꞌnoko keenavaang, eeꞌnoko poraꞌkooning, eeꞌnoko sinampuai ookara muuꞌ amutemuriiꞌ kantenaꞌ.” Eeꞌnoko teeꞌ eeꞌnaꞌ nkoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kansiꞌkoo amutemuriiꞌ baaꞌ eeꞌnoko koiꞌnanka amutemuuꞌnaꞌ sinampumaing dupuuꞌ, keenavaang eeꞌnoko poraꞌkooning, teing-koo kuunge napoꞌ okiꞌnarekaꞌ sinang nkoarikooꞌ amutemuuꞌnaꞌ. Eeꞌnoko Kumponinge tampaꞌ oovura dotuaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Teketa aaꞌnouꞌ muung tankinuko taneꞌpuuꞌ eeꞌnoko teꞌmung teꞌmung beenanaꞌmung. ");
INSERT INTO nas_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Teketa napoꞌ Kumponinge aaꞌpuuꞌ, “Aiaꞌ, arakananka tavoꞌdariai meerooꞌnavaro-koo meuꞌke teke paning-koo doong eeꞌnoko muung simpeꞌaareaing, eeꞌnoko teke aing aaꞌning taaꞌniꞌantavaari otoromaatoai: doonanka, kaarananka eeꞌnoko mareꞌnanka. ");
INSERT INTO nas_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Eeꞌnoko teke meerooꞌnavaro-koo paning-koo arakavariri otoromaatoai teketa kansiꞌaape araka poꞌantavaamaatoai.” Eeꞌnoko teeꞌ eeꞌnaꞌ nkoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Eeꞌnoko Kumponinge teeꞌ araka pankeng kenaanka nkovuretuꞌ, narung aaꞌnaꞌ araka doonaaꞌ araka-koo miring duaaꞌ nkovuuꞌ. Eeꞌnoko niiꞌnung baruꞌ araka deeaung muunga araka-koo miring kaara nkovuuꞌ. Napoꞌ beentoꞌnanka nkovuruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Teing paning-koo meuꞌ nkovurira sipuruꞌ teketa kansiꞌaape araka poꞌantavaamaatooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Eeꞌnoko teketa doong eeꞌnoko muung tanatavaamaatoai, eeꞌnoko napoꞌ arakanaanka eeꞌnoko mutaanang tankaampaarematoai. Eeꞌnoko Kumponinge teeꞌ eeꞌnaꞌ tampaꞌ oovura dotuaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Teketa aaꞌnouꞌ muung tankinuko taneꞌpuuꞌ, eeꞌnoko teꞌmung teꞌmung karenanaꞌmung. ");
INSERT INTO nas_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Eeꞌnoko Kumponinge napoꞌ karoma aaꞌpuuꞌ, “Ntong eeꞌnoko pirung ookarai kapooꞌnanka amutemuriiꞌ domantooꞌnankai maantoꞌaavai. Eeꞌnoko barennankai porora meerooꞌnavaro aꞌdeiꞌ auviꞌau puraanaama maantoꞌaavai.” ");
INSERT INTO nas_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Taviꞌ pankenanka nkovuruꞌ pirung-koo kuung otoromaing eeꞌnoko ookara okiꞌnarekaꞌ kapooꞌ nanaamaing ntong-koo kuunge, eeꞌnoko ookara bareng amutemuriiꞌ. Eeꞌnoko Kumponinge tampaꞌ oovura dotuaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Eeꞌnoko Kumponinge ookara biraankevuruꞌ aaꞌpuma, “Ookara kapooꞌnanka pirung-kooning parerima berentarima pirung maantoꞌeriai, eeꞌnoko ookara barennanka teeꞌke, parerima berentariai kansiꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Teketa aaꞌnouꞌ muung tankinuko taneꞌpuuꞌ eeꞌnoko teꞌmung teꞌmung paꞌnokoꞌnaꞌmung. ");
INSERT INTO nas_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Teketa napoꞌ Kumponinge aaꞌpuuꞌ, “Enang kansiꞌkoo kapooꞌnanka amutemuriiꞌ domantooꞌnanka tavoꞌdariai: ookara kauꞌkarenaumo bauꞌnaananka, eeꞌnoko biikoori, eeꞌnoko ookara kapooꞌ kansiꞌkoo daue nanaamaing.” Eeꞌnoko teeꞌ eeꞌnaꞌ nkoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kumponinge kauꞌkarenaumo poraꞌkooning amutemuuꞌ nkovuruꞌ eeꞌnoko napoꞌ bauꞌnaananka amutemuuꞌ teeꞌ nariꞌ nkovuruꞌ eeꞌnoko napoꞌ teing kansiꞌkoo daue kakanaamaing teeꞌ nariꞌ amutemuuꞌ nkovuruꞌ. Eeꞌnoko Kumponinge tampaꞌ oovura dotuaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Teketa napoꞌ Kumponinge aaꞌpuuꞌ, “Aiaꞌ, naning-namuuꞌ nantoong niiꞌ pinaꞌ oroꞌnuka nkoarampiai, niikaang oroꞌoroꞌnooꞌ siompuioꞌ, eeꞌnoko teinge ookara kapooꞌnanka tanatavaariai, aaꞌning: taviꞌ pirung-koonanka, barenanka auviꞌau-kooning, kauꞌkarenaumo datauraaꞌnanka, eeꞌnoko poraꞌkoonanka, eeꞌnoko napoꞌ teing ookara kapooꞌnanka kansiꞌkoo daue nanaamaing.” ");
INSERT INTO nas_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Teeꞌkoo Kumponinge naning baka bakaang oroꞌoroꞌnooꞌ siompuioꞌ nkovuuꞌ. Teeꞌ eeꞌnaꞌ nariꞌ oroꞌ Kumponing-pinaꞌ nkovuuꞌ, aaꞌnouꞌ donkaani eeꞌnoko manikuma nkovuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Eeꞌnoko Kumponinge biraankevurema aaꞌpuretuꞌ, “Deeꞌ parerema berentareai eeꞌnoko deurukaaꞌke ookara kansiꞌ maantoꞌaara ookara kapooꞌnanka tanatavaariai tenairu-koo. Eeꞌnoko deeꞌke tee aaꞌnoaing ookara taviꞌ pirung-kooning tanataverereriai, barenanka auviꞌau-kooning eeꞌnoko ookara kapooꞌnanka kansiꞌkoo daue nanaamaing.” ");
INSERT INTO nas_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Eeꞌnoko Kumponinge aaꞌpuretuꞌ, “Oovereko, ninge tee deeꞌ arompesing ookara kapooꞌnanka sinampumaing ookara-koo kansiꞌkoo daue otorinanka; deeꞌ deekaang taamang, ookara baaꞌnanka, koiꞌnanka, keenavaang eeꞌnoko poraꞌkooning naroꞌka. ");
INSERT INTO nas_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Eeꞌnoko ookara kauꞌkarenaumo-nanka kansiꞌkooning, napoꞌ barennanka auviꞌau-kooning eeꞌnoko ookara kapooꞌnanka kansiꞌkoo daue nanaamaing, eeꞌnoko ookara kapooꞌ domantooꞌnanka, ninge teing ookara kapooꞌ dupumaung maaꞌkoo avoronsing.” Eeꞌnoko teeꞌ eeꞌnaꞌ nkoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Eeꞌnoko Kumponinge ookara kapooꞌnanka teie nkovuruꞌning tampaꞌ masikaꞌ oroꞌpariko oovura dotuaruꞌ. Teketa aaꞌnouꞌ muung tankinuko taneꞌpuuꞌ, eeꞌnoko teꞌmung teꞌmung ˜naꞌmung-taa-naꞌmung. ");
INSERT INTO nas_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Teeꞌ eeꞌnaꞌ nariꞌ Kumponinge aaꞌning paning eeꞌnoko kansiꞌ bakevuuꞌ, eeꞌnoko ookara kapooꞌnanka mmauꞌ nariꞌ bakevuruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Eeꞌnoko Kumponinge ookara bakaang nko-nko nkovuruꞌnanka ˜naꞌmung-taa-naꞌmung bakevura, teꞌmung ˜keꞌmunta-taa-naꞌmung uaavouꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Eeꞌnoko Kumponinge teꞌmung ˜keꞌmunta-taa-naꞌmung biraankevura meekaꞌantavuuꞌ, aiꞌ teꞌmung eeꞌnaꞌmung tee, tee uaavouꞌnaꞌmung bakaang nko-nko kansiꞌ nko-koong bakevura. ");
INSERT INTO nas_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tenang tutunaꞌ Kumponinge kansiꞌnaanka paning nkovuuꞌnaꞌkoong minkunaa aung: ");
INSERT INTO nas_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Tenang Ovoringe Kumponinge kansiꞌ eeꞌnoko paning nkovuuꞌnang kapooꞌ keenavaang tovang koiꞌ dovang baaꞌ otoarukoꞌ kansiꞌkoo, mmeꞌ Kumponinge apoꞌ botovuaruko eeꞌnoko naning otoarukoꞌ mintoong nkovupeuꞌnung. ");
INSERT INTO nas_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Nka ntonooꞌ tenang eeꞌnang tavoꞌarakoꞌ okiꞌnarekaꞌ kansiꞌkoo dau tompatompaꞌanta-koo. ");
INSERT INTO nas_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Eeꞌnoko tenang eeꞌnang teie Ovoringe Kumponinge naning kansiꞌkoong daꞌmong-etab nkovuuꞌ, eeꞌnoko keꞌnie deto uupuvura domaang avuuꞌ domang-antavuma eeꞌnoko tee naning tenang domaang-poꞌnung deemparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Teketa Kumponinge tee naning nkovura tampooꞌ temuꞌ nerievuuꞌnooꞌ sipuuꞌ teka Iideniꞌka duaaꞌ pomanooꞌaapea. ");
INSERT INTO nas_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tenau tenau Kumponinge koiꞌnanka amutemuriiꞌ tampaꞌ oroꞌnanka keempuruꞌnau eeꞌnoko sinang maaꞌkoo tamparanankai. Eeꞌnoko meerooꞌ tenau-koo koiꞌ kevarira sipuretuꞌ: navari domaang isikung avuꞌnavari; niiꞌnavari noruꞌ aaꞌning tampara eeꞌnoko orara avuꞌnavari. ");
INSERT INTO nas_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Eeꞌnoko teing ntong kareriiru teꞌ Iideniꞌ tavearikooꞌ tenau mintoonau duuꞌpaama, teketa nari deempari siarakooꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Tutunaꞌnari teing-koo miring Piison-nari, Aavila nameng, kooro-poꞌnameng, korovui pomanari. ");
INSERT INTO nas_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Tee kooro temeng-koong tampara eeꞌnoko narung napoꞌ koiꞌ tampaꞌ nuuraaꞌ otomanooꞌ miring deliam. Napoꞌ kapang tampaꞌ oroꞌnanka-poꞌnooꞌ, miring kaneliani, ereng naakiomaing. ");
INSERT INTO nas_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Keriira-nari ntong miring Kiong-nari, Kus-nameng-eta pomanari. ");
INSERT INTO nas_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Beeriiru-nari miring Taikirisi-nari, Asiria-nameensiꞌkoo duaaꞌ pomanooꞌaapeita pomanari. Kareriiru-nari miring Iuperetisi-nari. ");
INSERT INTO nas_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Eeꞌnoko teie Ovoringe Kumponinge tee naning nkavura teꞌ Iideniꞌnau-koo sipuuꞌ tenau mintoompuma teke tarevui otooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Eeꞌnoko Ovoringe Kumponinge botovuma aaꞌpuuꞌ tee naning, ");
INSERT INTO nas_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","“Ookara koiꞌkoong sinananka mintoong-koo otoining-koong tamung naroꞌketa maaꞌemaatoaing, teka tevari koiꞌnavari noruꞌanta nka-navari teing aaꞌning-koo tampara eeꞌnoko orara dake maaꞌeaukaꞌ tee sinang tevari-koong, aiꞌ teꞌmung daꞌ tevari-koo sinang maaꞌeainaꞌmung daꞌ tee dooaing.” ");
INSERT INTO nas_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Teketa Ovoringe Kumponinge aaꞌpuuꞌ, “Aung naning baka otoꞌkoo tampaꞌ deeaꞌ. Ninge bakaang pakupakunung tee-koo makosi nkoevompaing.” ");
INSERT INTO nas_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Teketa teie Ovoringe Kumponinge teing kauꞌkarenaumo-nanka eeꞌnoko barennanka kansiꞌketa temuꞌ nkovuruꞌning teꞌ Aadama-anko poꞌantavuruꞌ teie namuriiꞌnaꞌ oovurira miring tampuriiꞌnaang, eeꞌnoko aming miring teie Aadamai tampuruꞌnung teing kapooꞌ domantooꞌnanka-koo tee tee biikaang miring deemparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Eeꞌnoko tenang Aadamai mirinanka tampuruꞌ teing kauꞌ karenaumo-nanka-koong bauꞌnaananka-koo eeꞌnoko biikoori-koo, napoꞌ ookara barennanka-koo tampuruꞌ, teka tee Aadama bakaang pakupakunung tee-koo makosi otoaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Teketa teie Ovoringe Kumponinge tee Aadama aaꞌnaꞌ aasiꞌantavuuꞌ, eeꞌnoko tenang aatuko paramparang-koo kooꞌkoo nariꞌ bitaꞌura teꞌ napoꞌ bioꞌke avoꞌantavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Eeꞌnoko teriꞌ paramparang-nariꞌ nkavuuꞌnariꞌketa Kumponinge nani manikuma nkovuuꞌ eeꞌnoko teni teꞌ Aadama-anko tavoꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Teketa Aadamai aaꞌpuuꞌ, “Emuꞌ ani eeꞌnani mmaikoꞌ masikani. Bakaang kooꞌ tee ning-koong-eta kooꞌketaing eeꞌnoko bakaang bioꞌ tee ning-koong-eta bioꞌketaing. Ani donkaani-koong-eta kooꞌketa nkoniiꞌnani naning-eta-nani, teꞌkoo manikuma tampampaing.” ");
INSERT INTO nas_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Teeꞌkoo teeꞌ aaꞌnomaung naninge baumararing sipurema baꞌaang ninka pinkaꞌarekooꞌ eeꞌnoko narung deemparekooꞌ. ");
INSERT INTO nas_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tenang tee tering ookaring donkaani eeꞌnoko teni baꞌaang simpenoiꞌdaring otoresi teka tee maiaꞌoreaꞌ. ");
INSERT INTO nas_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ookara kapooꞌ avutevuꞌ biikoori Kumponinge nkovuruꞌnanka-koo boruꞌ bakei aaꞌnaꞌ toreearoꞌ. Teie tee teni manikuma aaꞌpuuꞌ, “Kumponinge ee masikaꞌ ookara anau-koo koiꞌnanka-koong sinang maaꞌkoo orokoruresing?” ");
INSERT INTO nas_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Eeꞌnoko tenie makuꞌuma aaꞌpuuꞌ tee boruꞌ, “Neeꞌke aaꞌ ookara koiꞌnanka-kooning sinang anau-kooning maaꞌkoo makosi. ");
INSERT INTO nas_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Teka Kumponinge aaꞌpuing, ‘Koiꞌnavari anau-koo meuꞌke otoinavari-koong deekoꞌ deeꞌke sinang maaꞌereaukaꞌ, aaꞌnoko tamung kompereaukaꞌ tevari, dooreꞌneenga.’” ");
INSERT INTO nas_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nka teie boruꞌke aaꞌpuuꞌ teni manikuma, “A, deeꞌ bakei doorearooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Deeꞌke tee sinang teuꞌkoong maaꞌereta deekoꞌ deeꞌ tee noruꞌ daateꞌdareeꞌnaang kapooꞌ tampara eeꞌnoko kapooꞌ orara noruꞌkoo, eeꞌnoko deeꞌ tee Kumponing-pinaꞌ nariꞌ otoreeꞌnaang. Kumponinge teeꞌ noruꞌui deeꞌ teeꞌ orokoruresing.” ");
INSERT INTO nas_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Eeꞌnoko tenang tenie manikumai tee teuꞌkoong sinang oovuko onou eeꞌ oroꞌ tavoꞌkuuꞌ, “Bakei aung sinang maaꞌkoo tampara, oroꞌoroꞌnooꞌ tampaꞌ oroꞌke, eeꞌnoko maaꞌanko norukasiꞌ deeng-antamupeuꞌ.” Tee ninka noruꞌ ninka tee-koo sinang-koo nkavura maaꞌkuuꞌ, eeꞌnoko niiꞌning napoꞌ tenie tee baꞌung nariꞌ otoretuꞌnung avuioꞌ maaꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Eeꞌnoko tenang tee noruꞌ ookaanka-koong daateꞌaretuꞌ, eeꞌnoko tenang noruꞌaretuꞌ tenaanka tee simpenoiꞌka, eeꞌnoko tenang koiꞌ piikiꞌkoong paraꞌnooꞌ naroꞌka pateꞌureta duaana nkosiiretuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Teketa tenang kamunooꞌnang boimpuioꞌ tenaankai tee Ovoring Kumponing teke mintoonge nanuko taaravuretuꞌ, eeꞌnoko koiꞌnanka-koo meuꞌ bakuꞌaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Teka teie Ovoringe Kumponinge Aadama bokuvuma aaꞌpuuꞌ, “Daꞌ areꞌ otomang?” ");
INSERT INTO nas_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Eeꞌnoko teie aaꞌpuuꞌ, “Ninge daꞌkoong aurong mintoonge naniko taararamira amoromira simpenoiꞌ deemarama oomeꞌneeng-koo bakuꞌmaring.” ");
INSERT INTO nas_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Eeꞌnoko Kumponinge aaꞌpuuꞌ, “Daꞌ baie simpenoiꞌ otoing nauruing? Aiꞌ tee koiꞌkoong sinang orokorantuꞌnavari-koong maaꞌei?” ");
INSERT INTO nas_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Eeꞌnoko teie aaꞌpuuꞌ, “Tenie anie manikumai dake niꞌninka nariꞌ oꞌnoreeꞌnaang ameuꞌnanie tee-koo koiꞌkoong-koo sinang-koo amuioꞌ maaꞌkansing.” ");
INSERT INTO nas_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Teketa teie Ovoringe Kumponinge teni manikuma aaꞌpuuꞌ, “Dake tee aming-koo teeꞌ nkoveing?” Eeꞌnoko tenie manikumai aaꞌpuuꞌ, “Boruꞌke tosimuioꞌ teeꞌ ninge maaꞌansing.” ");
INSERT INTO nas_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Teketa Ovoringe Kumponinge tee boruꞌ aaꞌpuuꞌ, “Dake tee teeꞌ oroꞌ kapooꞌ nkoveing-koo dakaang barakosiꞌ tee dau basi ookara kauꞌkarenaumo-nanka bauꞌnaananka-koo eeꞌnoko poraꞌkoonanka-koo. Daꞌ tee keꞌdei nanimatoaing otoainaroong-koo tee nankanankara maaꞌema. ");
INSERT INTO nas_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Eeꞌnoko ninge tee deeꞌnaanka daꞌ eeꞌnoko ani manikuma karenaanka deeng-antarampeaing eeꞌnoko napoꞌ teing deeꞌke deurukaaꞌ teeꞌke kare-nupoong otoromaatoaing. Teni baurukaaꞌkoo narunge daꞌ boreꞌkoo puuturuaing eeꞌnoko dake tee kankoꞌbo-koo kakieai.” ");
INSERT INTO nas_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Napoꞌ teni manikuma aaꞌpuuꞌ Kumponinge, “Ninge tee daꞌ pankaing sisikeera arompaing tenang parema mantompemaatoaing. Sisikeera ninka parematoaing. Nka tee, daꞌung-koo pia otoi otoaing, eeꞌnoko bakaang pia siompemaatoai.” ");
INSERT INTO nas_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Eeꞌnoko napoꞌ Aadama-koo aaꞌpuuꞌ, “Dake teni daꞌaang bakaang kara taaravera tee koiꞌkoong sinang orokoantuꞌnung maaꞌeing-koo, ninge tee kansiꞌ taamang keentoma barakosiꞌansing taamananka tampaꞌ nkoaravaꞌ otoainge, eeꞌnoko daꞌ poreꞌdoma deekoꞌ tee-koo kansiꞌkoo taamanimatoaing ookara batei daꞌ otoaining-koo. ");
INSERT INTO nas_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Eeꞌnoko kansiꞌketa koiꞌnanka tooꞌmurintaaꞌpoꞌnanka dupuai, napoꞌ baaꞌnanka orananka dupuai, eeꞌnoko dake maaꞌkoo poraꞌkooning baaꞌnanka maaꞌemaatoai. ");
INSERT INTO nas_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Eeꞌnoko iontakaanang mintoontarama taamanimatoai, bera doora kansiꞌkoo tororaravainooꞌke basi, teꞌ eeꞌnooꞌ daꞌ nkorantuꞌnooꞌ, aiꞌ daꞌ tee daꞌmong, napoꞌ daꞌmong-koo doonko tororaravaing.” ");
INSERT INTO nas_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Eeꞌnoko Aadamai teni baꞌaang miring Iivi tampuuꞌ, aiꞌ teni teni ookara nantoong amutemuriiꞌ bioko. ");
INSERT INTO nas_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Eeꞌnoko Kumponinge Ovoringe kauꞌkarenaumo-nanka-koong dopaꞌkoo mononopaꞌ nkovura Aadama eeꞌnoko teni Iivi avuretuꞌ kurumpareeꞌnaang. ");
INSERT INTO nas_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Teketa Kumponinge Ovoringe aaꞌpuuꞌ, “Aung tee naning niiꞌpinaꞌ oroꞌparing aaꞌnoing kapooꞌ tampara eeꞌnoko orara noruꞌui. Emuꞌ tee koiꞌ domang isikung avuꞌnavari-koo dueꞌ beꞌkoo tauraꞌpampiaukaꞌ, tevari-koong sinang maaꞌura napoꞌ domampari otoꞌneenga.” ");
INSERT INTO nas_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Teeꞌpura Ovoringe Kumponinge tenau-eta Iideniꞌnau-eta bataꞌuuꞌ tamung poraꞌke mintoomparaaꞌnaang, tee naning kansiꞌketaing kansiꞌ nenkeꞌuma. ");
INSERT INTO nas_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tenang Kumponinge tering bataꞌureta, tee-koo tenau-koo Iideniꞌnau-koo duaaꞌ pomanooꞌaapenameng-koo koosinunanka purintoꞌnanka donkong-antavuruꞌ, tee tevung taung koiꞌ domang-anta-aape beꞌnavung paraꞌai otoromaatooꞌnaang, bainatu ntaꞌpinaꞌ urung kompai eevaavaama. ");
INSERT INTO nas_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Enang tee Aadama Iivi-ninka baꞌaang ninka otoresi teni kempoꞌkuuꞌ. Teketa tootoꞌ narung donkaani paravuuꞌ tenie, miring Keiniꞌ. Eeꞌnoko aaꞌpuuꞌ tenie, “Ninge narung donkaani paravansing Ovoringe pakumuioꞌ.” ");
INSERT INTO nas_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Napoꞌ kemuꞌkanaꞌ tenie donkaani Keiniꞌke baaraꞌmaꞌnung paravuuꞌ miring Eebeloꞌ. Eebeloꞌ sipisipiꞌnanka tanata deemparuꞌ eeꞌnoko Keiniꞌ mintoong nkonara. ");
INSERT INTO nas_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Damaꞌke tee Keiniꞌke tee-koo keenkeenanka-koo sinananka nkavurira Ovoring-koo boontunamparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Eeꞌnoko Eebeloꞌke sipisipiꞌnanka-koo niiꞌning tutunaꞌning-kooning datoꞌurira menaanka dovang-nairu ninka boontunamparuꞌ. Eeꞌnoko Ovoring Eebeloꞌkoo aaꞌnaꞌ dotuaruꞌ eeꞌnoko tee-koo bakaang-koo boontunang-koo. ");
INSERT INTO nas_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Teka Keiniꞌkoo eeꞌnoko tee-koo bakaang-koo boontunang-koo dotuaravaruuꞌ. Eeꞌnoko Keiniꞌ teeꞌkoo aaꞌnaꞌ iirai oing orakaꞌ oroꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Eeꞌnoko Ovoringe aaꞌpuuꞌ tee Keiniꞌ, “Daꞌ aming-koo iirarora oing orakaꞌ oroꞌdaramang? ");
INSERT INTO nas_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Daꞌ tampaꞌ boontunantaravaing deekoꞌ ning daꞌkoo dotumaravaing, apeꞌ aung? Teka tee dake kapooꞌ orara nkoveko deekoꞌ tee orara aarumo maamuari otong daꞌ kurumaaꞌkoo. Nka dake purintarara puruꞌeaing tee.” ");
INSERT INTO nas_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Teketa Keiniꞌke tee baaraꞌmaꞌnung Eebeloꞌ bokuvuma aaꞌpuuꞌ, “Poai ioꞌ tokoi poraꞌke korokoromareai.” Eeꞌnoko tenang poraꞌ bereta Keiniꞌ tee-koo baaraꞌmaꞌnung-koo Eebeloꞌkoo dau kokoroarara teka tavuma dupisiꞌuuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tenang Ovoringe aaꞌpuuꞌ tee Keiniꞌ, “Eebeloꞌ arerai tee daaraꞌmaꞌnung?” Eeꞌnoko Keiniꞌke aaꞌpuuꞌ, “Ninge noruꞌampaꞌ tee, aiꞌ ning tee ntaraꞌmaꞌnung tare-koo siꞌmeuꞌnunge?” ");
INSERT INTO nas_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Eeꞌnoko Ovoringe aaꞌpuuꞌ, “Nka dake aming nkoveing? Tee daaraꞌmaꞌnung bakaang ereng-koong aurong tee ning-koo biromparamang kansiꞌketa. ");
INSERT INTO nas_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Emuꞌ tee daꞌ barakosiꞌdama aaꞌdamaang: Anketa kansiꞌketa daꞌ tenkeniaing, aꞌ teꞌ kansiꞌnooꞌ daaraꞌmaꞌnung-koong ereng tuuvuioꞌ naivuinooꞌ daka dake dupisiꞌeioꞌ. ");
INSERT INTO nas_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Daꞌ tee poreꞌdoma kansiꞌkoo keempeko taamang tampaꞌ nkoaravaukaꞌnung eeꞌnoko tokoo dakanooꞌ masipoꞌ otoꞌderuaukaꞌ, tamung kansiꞌkoo kororaramatoaing.” ");
INSERT INTO nas_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Teketa Keiniꞌke aaꞌpuuꞌ tee Ovoring, “Ee bakaꞌ, aung tee kiimata pankaing masikung. Dake ameioꞌ orarunsie dupisiꞌmuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Dake tee ning eꞌmung bataꞌmeing anketa kansiꞌketa, eeꞌnoko dakaang biraanke-ita bakuꞌmeinge. Eeꞌnoko tokoo nkanooꞌ otoꞌmemuaukaꞌ; tamung kansiꞌkoo koromaramaꞌnoaing. Naninge tokoa oomura deekoꞌ tamung anutua dupisiꞌmuaing makosie.” ");
INSERT INTO nas_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Teka Kumponinge aaꞌpuuꞌ tee, “A, teeꞌ deeaꞌ. Niiꞌnung naninge daꞌ taruma dupisiꞌduaing deekoꞌ, tee naning tee ninge aaꞌnaꞌ dau basinooꞌ kiimata avompaing.” Eeꞌnoko Ovoringe Keiniꞌkoo taaꞌniꞌanta sipuuꞌ naninge tokoa oovura tavuꞌneeng-koo tee. ");
INSERT INTO nas_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Teketa tenang Keiniꞌ Ovoring-ankoita tenkenuuꞌ, eeꞌnoko bera Ataꞌnanuꞌ tampaama-nameng-koo beuꞌ teketa Iideniꞌketa duaaꞌ pomanooꞌaapenameng-koo. ");
INSERT INTO nas_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Emuꞌ tee Keiniꞌ, osi pankaing kanivui otoko, baꞌaang kempoꞌkura bauring donkaani paravuuꞌ miring Iinoke; eeꞌnoko Keiniꞌke tee osi opura napoꞌ Iinoke namirimpuuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Eeꞌnoko Iinoke tee Irat bauma. Tee Irat tee Meusiel bauma, eeꞌnoko Meusiel tee Metusiel bauma, eeꞌnoko Metusiel tee Leemekiꞌ bauma. ");
INSERT INTO nas_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Eeꞌnoko Leemekiꞌke kenaanka manikumaara nampuretuꞌ. Niiꞌnani-koong miring Eda, eeꞌnoko nani Silaꞌ. ");
INSERT INTO nas_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Eeꞌnoko Edai Jabal paravuuꞌ, Jabal tee teing poraꞌke nanaama boromakaꞌnanka tarearikoꞌning biuma. ");
INSERT INTO nas_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Tee Jabal baaraꞌmaꞌnung miring Jubal, eeꞌnoko tee Jubal tee teing nantoong kovi dovang kiita kompaamaing biuma. ");
INSERT INTO nas_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Damaꞌke napoꞌ tenie Silaꞌke Tubokein paravuuꞌ. Tubokein tee teing nantoong baraasi˜ dovang-koo aini aaꞌning-koo kapooꞌ nkonuka biuma. Tee Tubokein baꞌmari miring Naama. ");
INSERT INTO nas_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Niiꞌnaꞌmung Leemekiꞌke tenaanka baꞌaankaara nauvurema aaꞌpuretuꞌ, “Eda naanka Silaꞌ ee, nkaang kara tampaꞌ masikaꞌ taaramereai. Naninge narunge nemakai ning baikemuioꞌ ninge dupisiꞌansieeng makuꞌkoo, eeꞌnoko baꞌmarange meroꞌkoo piavorora deekoꞌ eeꞌ nauarampaing, ");
INSERT INTO nas_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","‘Baa naning Keiniꞌ dupisiꞌuaing aaꞌnaꞌ dau basinooꞌ kiimata nkavuaing, eeꞌnoko naning ning tamuaing bakei aaꞌnaꞌ aaꞌnaꞌ kiimata dau basinooꞌ kompuaing.’” ");
INSERT INTO nas_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Damaꞌke napoꞌ Aadama ninka otoresi baꞌaange tootoꞌ narung donkaani napoꞌ paravuuꞌ miring Set, eeꞌnoko tenie aaꞌpuuꞌ, “Kumponinge tootoꞌ narung napoꞌ amuing Eebeloꞌ pariꞌantanung tee Keiniꞌke dupisiꞌuuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Damaꞌke napoꞌ Set bauring pontoꞌaruꞌ eeꞌnoko Iinosiꞌ tampuuꞌ. Tenang eeꞌnang nantoonge Kumponing Iaaue tampaama dootuuꞌ tutumpariruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Aung tee Aadama bakanaving-koong mirinanka, tee naning Kumponinge nkovuuꞌnung baka bakaang oroꞌ siompui otoko. ");
INSERT INTO nas_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kumponinge kenaankara nkovuretuꞌ, donkaani eeꞌnoko manikuma, eeꞌnoko biraankevureta “naninka” tampuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tenang Aadama mareꞌ narung daakuꞌketa beenaumo kivora 130 deemparama bauring narung nkoaruꞌ tee-pinaꞌ masikaꞌ oroꞌ. Miring Set tampuuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Temareꞌketa Set pontoꞌaruꞌnamareꞌketa deto Aadama ˜beenaumo-taa daakuꞌ 800 mareꞌ otouꞌ, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ donkaang eeꞌnoko manikuꞌ nkoariruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ookara mareꞌ naroꞌka Aadama otouꞌning ˜karenaumo-taa daakuꞌ bera beenaumo kivora 930 deemparama bouꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Teketa tee Set mareꞌ narung daakuꞌketa paꞌnokoꞌ 105 deemparako bauring narung pontoꞌaruꞌ miring Iinosiꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Temareꞌketa Iinosiꞌ pontoꞌaruꞌnamareꞌketa deto tee Set ˜beenaumo-taa daakuꞌ bera ˜kenaanka-taa 807 mareꞌ otouꞌ, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ nkoariruꞌ donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ookara mareꞌ Set otouꞌning naroꞌka ˜karenaumo-taa daakuꞌ bera kivora-ita kenaanka 912 deemparama booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tenang tee Iinosiꞌ mareꞌ ˜karenaumo-taa kivora 90 deemparama bauring narung nkoaruꞌ miring Kenan. ");
INSERT INTO nas_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Temareꞌketa Kenan pontoꞌ aruꞌnamareꞌketa tee Iinosiꞌ ˜beenaumo-taa daakuꞌ bera kivora-ita paꞌnokoꞌ 815 mareꞌ otouꞌ, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ pontoꞌariruꞌ, donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ookara mareꞌ Iinosiꞌ otouꞌning naroꞌka ˜karenaumo-taa daakuꞌ bera paꞌnokoꞌ 905 deemparama booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Teketa tee Kenan mareꞌ ˜kenaanka-taa kivora 70 deemparako bauring narung Maaleliꞌ pontoꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Eeꞌnoko temareꞌketa Maaleliꞌ pontoꞌaruꞌnamareꞌketa deto Kenan ˜beenaumo-taa daakuꞌ bera karenaumo kivora 840 mareꞌ otouꞌ, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ nkoariruꞌ, donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ookara mareꞌ Kenan otouꞌning naroꞌka ˜karenaumo-taa daakuꞌ bera kivora 910 deemparama bouꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tenang tee Maaleliꞌ ˜narung-taa kivora bera paꞌnokoꞌ 65 mareꞌ deemparako bauring narung Jereteꞌ pontoꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Temareꞌketa Jereteꞌ pontoꞌaruꞌnamareꞌketa deto Maaleliꞌ ˜beenaumo-taa daakuꞌ bera beenaumo kivora 830 mareꞌ otouꞌ, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ pontoꞌariruꞌ, donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Eeꞌnoko ookara mareꞌ Maaleliꞌ otouꞌning naroꞌka ˜beenaumo-taa daakuꞌ bera ˜karenaumo-taa eeꞌnoko paꞌnokoꞌ 895 deemparama booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Teketa Jereteꞌ mareꞌ narung daakuꞌketa ˜narung-taa kivora bera kenaanka 162 deemparako bauring Iinoke pontoꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Temareꞌketa Iinoke pontoꞌaruꞌnamareꞌketa deto Jereteꞌ ˜beenaumo-taa daakuꞌ 800 mareꞌ otouꞌ, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ pontoꞌariruꞌ, donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Eeꞌnoko Jereteꞌ ookara mareꞌ naroꞌka ˜karenaumo-taa daakuꞌ bera ˜narung-taa kivora-ita kenaanka 962 otora bouꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tenang Iinoke mareꞌ ˜narung-taa kivora-eta paꞌnokoꞌ 65 deemparako bauring Metuselaꞌ pontoꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Eeꞌnoko temareꞌketa Metuselaꞌ pontoꞌaruꞌnamareꞌketa Iinoke beenaumo daakuꞌ 300 mareꞌ otouꞌ, Kumponing ninka nariꞌ tampaꞌ navuaresi, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ pontoꞌariruꞌ, donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ookara mareꞌ Iinoke otouꞌning naroꞌka beenaumo daakuꞌ bera ˜narung-taa kivora-ita paꞌnokoꞌ 365. ");
INSERT INTO nas_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Iinoke tee Kumponing ninka tampaꞌ navuarekoꞌnooꞌkoo Kumponinge nkavuioꞌ napoꞌ nantoonge ooaavaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Teketa Metuselaꞌ mareꞌ narung daakuꞌ bera ˜beenaumo-taa kivora eeꞌnoko ˜kenaanka-taa 187 deemparako bauring Leemekiꞌ pontoꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Temareꞌketa Leemekiꞌ pontoꞌaruꞌnamareꞌketa ˜kenaanka-taa daakuꞌ bera ˜beenaumo-taa kivora-ita kenaanka 782 mareꞌ otouꞌ, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ nkoariruꞌ, donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ookara mareꞌ Metuselaꞌ otouꞌning naroꞌka ˜karenaumo-taa daakuꞌ bera ˜narung-taa kivora-ita napoꞌ ˜karenaumo-taa 969 deemparama booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tenang napoꞌ tee Leemekiꞌ mareꞌ narung daakuꞌ bera ˜beenaumo-taa kivora-ita kenaanka 182 deemparako bauring narung pontoꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Eeꞌnoko miring Nooaꞌ tampuuꞌ, aaꞌpuma, “Aung tee niiꞌ unaa-antamuriaing teieta iriꞌoꞌketa aung kansiꞌ mintoompampima kompampimaung-eta Kumponinge barakosiꞌuuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Temareꞌketa Nooaꞌ pontoꞌaruꞌnamareꞌketa Leemekiꞌ paꞌnokoꞌ daakuꞌ bera ˜karenaumo-taa kivora-ita paꞌnokoꞌ 595 mareꞌ otouꞌ, eeꞌnoko teing-koo mareꞌkoo kuunge napoꞌ niiꞌning baurukaaꞌ pontoꞌariruꞌ, donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ookara mareꞌ Leemekiꞌ otouꞌning naroꞌka ˜kenaanka-taa daakuꞌ bera ˜kenaanka-taa kivora-ita ˜kenaanka-taa 777 deemparama booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Eeꞌnoko Nooaꞌ mareꞌ paꞌnokoꞌ daakuꞌ 500 tamung otora baurukaaꞌ beenaumo pontoꞌariruꞌ aaꞌning Siemiꞌ, Aam eeꞌnoko Jepat. ");
INSERT INTO nas_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aung aneꞌ tee Jiisuuꞌ Karistooꞌ bakanarempoꞌkoong mirinanka otoing, tee eeꞌnung Deevitaꞌ bakanaving-koong, tee Deevitaꞌ napoꞌ tee Eebaraamiꞌ bakanaving-koong. ");
INSERT INTO nas_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eebaraamiꞌ tee Aisakeꞌ bauma. Aisakeꞌ napoꞌ tee Jeekopiꞌ bauma. Jeekopiꞌ tee Juda bauma batatakaampi eeꞌnoko baaraꞌmainkaang ninka nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda tee Peeresi namainta Siira beuma. Beuko teni Teemaa. Peeresi tee Eesirong bauma. Eesirong napoꞌ tee Aramiꞌ bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramiꞌ tee Aminadapiꞌ bauma. Aminadapiꞌ tee Naasoni bauma. Naasoni tee Salamong bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamong tee Booasi bauma, bauko teni Reeap. Booasi tee Oobeteꞌ bauma, teie bauko teni Rut. Oobeteꞌ tee Jeeseꞌ bauma. Eeꞌnoko ");
INSERT INTO nas_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jeeseꞌ tee Deevitaꞌ bauma, tee daurarong˜. Napoꞌ Deevitaꞌ tee Solomoniꞌ bauma, bauko teni eeꞌnani tutung Uraia baꞌaang. ");
INSERT INTO nas_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoniꞌ tee Reaboam bauma. Reaboam tee Abaisiaꞌ bauma. Abaisiaꞌ tee Eesa bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Eesa tee Jeosapata bauma. Jeosapata tee Jooram bauma. Jooram tee Usaia bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia tee Jootam bauma. Jootam tee Eeasi bauma. Eeasi tee Esekaia bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaia tee Manase bauma. Manase tee Aamon bauma. Aamon tee Josaia bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia tee Jekonaia bauma, eeꞌnoko baaraꞌmainkaang. Tekang ninka nariꞌ mmauꞌ Juꞌnupoong Babiloniꞌnameensiꞌaape berouꞌ kiimata-koo. ");
INSERT INTO nas_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babiloniꞌaape berouꞌnooꞌketa Jekonaia tee Sialeteale bauma deemparuꞌ. Sialeteale tee Serababele bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababele tee Abaiutuꞌ bauma. Abaiutuꞌ tee Elaiakim bauma. Elaiakim tee Eesoo bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eesoo tee Siedoko bauma. Siedoko tee Eekim bauma. Eekim tee Elaituꞌ bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaituꞌ tee Eliesaꞌ bauma. Eliesaꞌ tee Mataaniꞌ bauma. Mataaniꞌ tee Jeekopiꞌ bauma. ");
INSERT INTO nas_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jeekopiꞌ tee Josepaꞌ bauma. Josepaꞌ tee Meeriꞌ baꞌung, teni Jiisuuꞌ paravuuꞌnani, tee eeꞌnung Kumponinge Pakoꞌpariꞌniiꞌ tampaamaung, Karistooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aing teing avantevaranooꞌ kivora-ita karenaumo-koo basi Eebaraamiꞌketa Deevitaꞌkoo basinooꞌ, eeꞌnoko teketa napoꞌ kivora-ita karenaumo-navarantu otorouꞌ Babiloniꞌke kiimatavariri otorouꞌnooꞌ basinooꞌkoo. Eeꞌnoko teketa napoꞌ kivora-ita karenaumo-navarantu depeto tee Kumponinge Pakoꞌpariꞌniiꞌkoo basinooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Enang teeꞌ eeꞌ nkoarara Jiisuuꞌ Karistooꞌ pontoꞌaruꞌnaꞌ. Teni bauko Meeriꞌ teni Josepaꞌkoo miruꞌniiꞌnani, teka mmeꞌ nariꞌ otoreaꞌ teni tootoꞌpoꞌnani deemparuꞌ taꞌninaꞌ Tanuaang Meekung bakaang iriꞌke. ");
INSERT INTO nas_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Teketa teie Josepaꞌke, teni-koo miruꞌniiꞌke teni tootoꞌpoꞌnani tasiꞌpura koontoꞌnaꞌ nko-koo noruꞌari beekaang navunavu totoꞌkoo mauꞌaruꞌ, teka makenge nko-koo piavouꞌ ookara-koo siraꞌpuko maiaꞌoꞌneeng-koo teni. ");
INSERT INTO nas_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Teka teeꞌ noruꞌarara otoko koosinung˜ narung Ovoring bakaang noone-koo tee-ankoi oroꞌparuꞌ eeꞌnoko aaꞌpuuꞌ, “Josepaꞌ, Deevitaꞌ bauring, aroreaukaꞌ Meeriꞌ boku-koo daꞌaang deemparaaꞌnaang, aiꞌ tee tootoꞌ teni-koo poontoaring˜ tee Tanuaang Meekung-etaing. ");
INSERT INTO nas_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tenie tee tootoꞌ donkaani paravuaing, eeꞌnoko dake tee miring Jiisuuꞌ tampeaing, aiꞌ teie tee bakaning nantoong biikaning orara aarumonanka-ita mooꞌuriaing.” ");
INSERT INTO nas_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aing ookara kapooꞌnanka nkoaruꞌnooꞌ tee kapooꞌ Ovoringe tero nakaronara˜ karantavuma˜ nauvuuꞌnung masikaꞌparaaꞌnaang, eeꞌ oroꞌ: ");
INSERT INTO nas_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Teni kuukuma˜ teni tootoꞌpoꞌnani deemparara narung donkaani paravuai, eeꞌnoko teinge eeꞌpinaꞌ tampaavaing, ‘Iimanuelaꞌ,’ miruꞌnooꞌ tee ‘Kumponing niiꞌ ninka nariꞌ otong.’” ");
INSERT INTO nas_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tenang Josepaꞌ tantearara teeꞌ nariꞌ teie koosinunge Ovoring bakaange botovuuꞌnaꞌ bera Meeriꞌ bokuvuuꞌ baꞌaang deemparaaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Teka teie tamung tanatavuuꞌ bera tenie tee tootoꞌ donkaani paravuuꞌnooꞌketa damaꞌke nampuuꞌ. Eeꞌnoko tee tootoꞌ miring Jiisuuꞌ tampuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Teketa tee Jiisuuꞌ pontoꞌarioꞌ teke Beeteleemaꞌke Judiaꞌkoonooꞌke tenang tee daurarong˜ Eerotiꞌ otokoꞌnang niiꞌning norukasiꞌnuka duaaꞌ bakoaramanooꞌketa Jerusalemaꞌ porouꞌ. Porora niaꞌkaama aaꞌpaakoꞌ, ");
INSERT INTO nas_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Daurarong Juꞌnupoong biikaang pontoꞌaruꞌnung arerai? Niiꞌke bakaang beentoꞌ taꞌdaꞌpuioꞌ ooampira nanampikotaaꞌ enang moring tee-koo dootuuꞌmariiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Teketa tenang teie daurarong Eerotiꞌke teeꞌ taaravura tee bakei orakaꞌ mantomparuꞌ, teing Jerusalemaꞌnupoong tee ninka nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Teketa tenang teing ookara piristiꞌkoo pankenuka eeꞌnoko boto naunuka naroꞌ bokuvurira niaꞌurima aaꞌpuruꞌ, “Nko tee Kumponinge teroita Pakoꞌpariꞌniiꞌ nantoong domampurira tarevuriainooꞌkoo areꞌke pontoꞌaravainge?” ");
INSERT INTO nas_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Teinge makuꞌaama aaꞌpauꞌ, “Beeteleemaꞌke, Judiaꞌkoonooꞌke, aiꞌ aung kara nakaronarai daarivuuꞌnung Daari Meekung-koo, aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Daꞌ Beeteleemaꞌ, Judiaꞌkoonavuntuꞌ osi okiꞌnavuntuꞌ deeaꞌ teing-koo pankeng osi Judiaꞌnavaroi otoromaing-koo, aiꞌ daꞌketa tee narung tanata-nko tavoꞌkuaing nkanavitu Isireeli-nupoong sipisipiꞌnanka-pinaꞌ tanatavuriaing.’” ");
INSERT INTO nas_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Teketa teie Eerotiꞌke teing norukasiꞌnuka bakuꞌnooꞌ bokuvuruꞌ eeꞌnoko teing batei tee beentoꞌ oroꞌpari otouꞌning tampaꞌ noruꞌuuꞌnaang niaꞌuriko nauauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Teketa botovurima teꞌ Beeteleemaꞌaape aaꞌpuruꞌ, “Berira tampaꞌ besiꞌeriai tee tootoꞌ, eeꞌnoko ooverira namuꞌke ning naumeriai, meraiꞌnang tee-koo dootuuꞌmaravainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Teketa teinge tee daurarong taaravaara tenkenauꞌ, eeꞌnoko tee beentoꞌ duaaꞌ bakoaramanooꞌaapea tutung ooauꞌnung teing-koo napoꞌ oroꞌparara uroꞌkanooꞌke nanuuꞌ bera teꞌ tootoꞌ otouꞌnooꞌ dau datearuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tenang teinge tee beentoꞌ teka ooaara doturotue maantoꞌurira bakei aaꞌnaꞌ doꞌderoꞌdeꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Teketa tenang pava-koo kuung porora teinge tee tootoꞌ ooauꞌ bauko ninka Meeriꞌ ninka otoreko. Eeꞌnoko teing teꞌ doonko miinge keemparira tee-koo dootuuꞌariruꞌ. Teketa biikaang bakurananka daateꞌaara kapooꞌ mooꞌ pankeng-kooninge bautaꞌauꞌ tee aaꞌninge: kooro, kapooꞌ betuꞌuko tampaꞌ nuuraaꞌ eeꞌnoko duuni tampaꞌ nuuraaꞌ miring meea. ");
INSERT INTO nas_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Eeꞌnoko noone-koo koono-antavurioꞌ Eerotiꞌanko napoꞌ beroarooꞌnaang teing norukasiꞌnuka niiꞌnavunge biikanameensiꞌaape toroariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Teing beroioꞌ napoꞌ tee koosinung Ovoring bakaang Josepaꞌankoi oroꞌparuꞌ noone-koo, teketa aaꞌpuuꞌ, “Daaꞌdaravai. Tee tootoꞌ eeꞌnoko bauko bokuereta Iisipiꞌaape mmaririra bera teke otoriko ninge nauranko deekoꞌ tororariai, aiꞌ Eerotiꞌke tee besiꞌuuꞌnaang tee tootoꞌ dupisiꞌuuꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Teketa iꞌamparara tee tootoꞌ eeꞌnoko bauko bokuvureta tenang muunga Iisipiꞌaape tenkenauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bera teke otorouꞌ Eerotiꞌ booꞌparuꞌnooꞌke basi. Teeꞌ nkoarioꞌ tee kara Ovoring bakaang makotuuꞌ nakaronara˜ karantavuma˜ aaꞌpuuꞌnaare: “Ninge bokuantuꞌ tee nnuring Iisipiꞌketa.” ");
INSERT INTO nas_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Teketa tenang Eerotiꞌke noruꞌuraiꞌnange teinge norukasiꞌnukai tee tosiaara divuꞌauꞌnung tee, tee bakei aaꞌnaꞌ iiravouꞌ eeꞌnoko tee botoaruꞌ ookara toirekaaꞌ donkaang Beeteleemaꞌnavete-kooning dupisiꞌkoo biikaang mareꞌ beemareu-koo basiariaing teing norukasiꞌnukai nauauꞌnooꞌka noruꞌ nkavura. ");
INSERT INTO nas_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Teketa tenang eeꞌnang tee kapooꞌ tee-koo Daari Meekung-koo nakaronarai Jeremaiaꞌke tero minkuvuuꞌnung masikaꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Aaꞌpuuꞌ, “Narung aurong teka Raama-nairu-koo taaravansing, aaꞌnaꞌ orarunsiari uiarama biromparako, teni Reesiel baurukaaꞌkoo biromparako, dunsirunsi-antavaako˜ piavoaruuꞌ baurukaaꞌ oparirioꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Teketa tenang Eerotiꞌ booꞌparioꞌ, tee koosinung Ovoring bakaang napoꞌ Josepaꞌankoi noone-koo oroꞌparuꞌ teke Iisipiꞌke. ");
INSERT INTO nas_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Eeꞌnoko aaꞌpuuꞌ, “Tanterarara tee tootoꞌ eeꞌnoko bauko bokuereta teꞌ Isireeli-nameensiꞌaape beriai, aiꞌ teing tee tootoꞌ dupisiꞌkoo piavorokoꞌning teing booꞌpariruꞌning.” ");
INSERT INTO nas_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Teketa tantearara tee tootoꞌ eeꞌnoko bauko bokuvureta Isireeli-nameensiꞌaape berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Teka tee Akeleasi Judiaꞌnavete tarevuko bauma tee Eerotiꞌ pariꞌantavura tee Josepaꞌ avorouꞌ teꞌ beꞌkoo. Eeꞌnoko noone-koo napoꞌ koono-antavuioꞌ Kumponinge Kaaleliꞌnavete-koo berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Eeꞌnoko berora narung osi miring Nasaretiꞌnamono-koo otorouꞌ. Teeꞌ nkoarako tee kara nakaronara karantavuma Ovoringe minkuvuuꞌnung masikaꞌparuꞌ, aaꞌpuuꞌnung, “Nasaretiꞌnung tampaamaatoaing.” ");
INSERT INTO nas_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tenang Jiisuuꞌ Nasaretiꞌ otokoꞌnang eeꞌnang Jooni Minkinara sirakuraꞌ tavoꞌarara daankinang tutumpuuꞌ meeꞌboraꞌ sirakamaaꞌkoo Judiaꞌnavete-koonooꞌke. ");
INSERT INTO nas_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Aaꞌpuma daankiaruꞌ, “Bereꞌdariai paninung muuꞌkoo tuntariainaꞌ, aiꞌ tee muuꞌ tee enang dueꞌ poing.” ");
INSERT INTO nas_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aung Jooni tee teie nakaronara Aisaiaꞌke urikamuꞌ minkuvuuꞌnung Daari Meekung-koo aaꞌpuuꞌnooꞌka, “Aurong narung naning-koong meeꞌboraꞌ sirakamaaꞌkoo bokuma aaꞌpumaang, ‘Maamu-antaveriaing tee taung Ovoring bakaang. Koompevuriai poainavung.’” ");
INSERT INTO nas_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tee Jooni Minkinara tee tamung mononopaꞌ kaameliꞌkoong dapo-koo nkoniiꞌ kurumparakoꞌ, eeꞌnoko dopaꞌnooꞌke tokoarakoꞌ. Eeꞌnoko bakaang taamang teing aaꞌning maaꞌurikoꞌ: ntaaꞌnanka eeꞌnoko davainta poraꞌkooning. ");
INSERT INTO nas_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Eeꞌnoko mmauꞌ nantoonanka Jerusalemaꞌketa tee-anko berouꞌ, ookara Judiaꞌnameng-nupoong nariꞌ, bera ookara Jooꞌdani-nari-nupoong-koo basi. ");
INSERT INTO nas_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Eeꞌnoko biikaning orakaꞌ nkonanka siraꞌpariko ntong-koo minkivurima meekaꞌantavurikoꞌ teie Jooꞌdani-nari-koo. ");
INSERT INTO nas_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Eeꞌnoko tenang eeꞌnang tevitu Moosesi bakaang Boto Keperuuꞌnavitu miring Paarisi-navitu eeꞌnoko Noruꞌ Pitunavitu miring Saadiusi-navitu nariꞌ ntong-koo minkivurira meekaꞌantavuriiꞌnaang porouꞌ. Teka Jooni Minkinarai oovurira aaꞌpurikoꞌ, “Diiꞌ borukoporonuka, baie aaꞌduri diiꞌ tamung minkirarira kooꞌdariaining Kumponing bakaang iira tavoꞌkuaing-eta? ");
INSERT INTO nas_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Masikaꞌ bereꞌdariaing tee-koo sinang oroꞌparavainaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tamung diiꞌka aaꞌperiaukaꞌ, ‘Eebaraamiꞌ tee niiꞌke niuma otong,’ aiꞌ masikung ninge naurampimang Kumponinge tee Eebaraamiꞌ baurukaaꞌ aing-eta kapananka-ita nkovuripeuꞌ diiꞌ pariꞌanta-koo, domang ivekaꞌdariko deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Teriꞌ marekenariꞌ teriꞌ maamuari otong koiꞌkoo okoraꞌ. Diiꞌ teing koiꞌ makosinuka. Diiꞌkoo ookara sinang tampara nkaveriaukaꞌning tee nokiraarira ntaꞌkoo duaꞌdaariaining. ");
INSERT INTO nas_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ninge tee tamung ntong-koo minkirampima meekaꞌantarampimaang domang bereꞌdariko, nka tee ning aaꞌnaꞌ apooꞌmui otoing iirakuta mmeꞌ pomaang, doonge-taara˜. Tee eeꞌnara poko aaꞌnaꞌ tampaꞌ taaraveriai, aiꞌ teie tee meekaꞌantaruriaing diiꞌ Tanuaang Meekung eeꞌnoko ntaꞌ ninka. ");
INSERT INTO nas_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Teie, tee simpeꞌnkoi˜ teing makosinuka bakaang muuꞌkoo kuunga onkeonkeꞌuriaing, eeꞌnoko teing makosinuka deeaing tee-koo ntaꞌkoo siriꞌpaaꞌkoo tai-antavuriaing.” ");
INSERT INTO nas_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Teketa tenang tee Jiisuuꞌ Kaaleliꞌnameensiꞌketa Jooꞌdani-nari-aape pouꞌ Joonie ntong-koo minkivura meekaꞌantavuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Teka Joonie orokovuma aaꞌpuuꞌ, “Ning dake ntong-koo minkimera meekaꞌanta-koo makosi eeꞌnoko daꞌ arekeeꞌkoo ning-anko poi?” ");
INSERT INTO nas_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Teka Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Emuꞌ nkomeaing. Makosi neeꞌke teeꞌ nkoampema dupe-antavampeaing ookara aarumo koontoꞌnanka.” Tenang teeꞌ minkuvuioꞌ Joonie arooꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Teketa tenang Joonie Jiisuuꞌ ntong-koo minkivura meekaꞌantavuioꞌ doompeto daaꞌarioꞌ ntong-eta tontaꞌarako tee-koo batei-koo paning daateꞌaruꞌ eeꞌnoko tenang teie tee Tanuaang Meekung Kumponing bakaang, kuukuuꞌpinaꞌ siarara Jiisuuꞌkoo pantoko oovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eeꞌnoko kara auromparuꞌ paning-eta aaꞌpuma, “Aung tee nnuring ninge piaavamaung. Ning aung-koo aaꞌnaꞌ dotumaramaung.” ");
INSERT INTO nas_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Teketa teie Tanuaang Meekunge tee Jiisuuꞌ meeꞌboraꞌ sirakamaaꞌkoo beꞌantavuuꞌ Sietaniꞌke dauaꞌuuꞌnaang teka. ");
INSERT INTO nas_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Teke taamanuaꞌ otouꞌ karenaumo kivora doong eeꞌnoko karenaumo kivora muung-koo. Eeꞌnoko teing doong oparuꞌnooꞌke tee peeravouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Eeꞌnoko teie dauaꞌbaukoi pora aaꞌpuuꞌ tee Jiisuuꞌ, “Daꞌ Kumponing Bauring deekoꞌ aing kapananka naueriko taamananka deempariaing.” ");
INSERT INTO nas_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “A, tee Daari Meekung-koo eeꞌ daariari otong, ‘Naning taamang narunge domampari otoaung, teka ookara kara Kumponing-etaning siompui domampari otomaung.’” ");
INSERT INTO nas_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Teketa napoꞌ Sietaniꞌke Jerusalemaꞌaape, teꞌ Meekamono-koo beꞌantavuuꞌ tee Jiisuuꞌ, eeꞌnoko aꞌdeiꞌ pava dootuuꞌnava pankava-koo miiraka-koo panteꞌantavura aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Daꞌ Kumponing bauring deekoꞌ doonko toꞌdiꞌdaravaing, tampaꞌ duaꞌdarako masikaꞌantaraavainaꞌ, aiꞌ Daari Meekung-koo eeꞌ daariari otong, ‘Teie bakaning koosinunanka botovuriaing daꞌ paku-koo. Teinge biikaning birenge deto doontaavaing kapang-koo kauꞌ naapuraraꞌneeng-koo.’” ");
INSERT INTO nas_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Teka Jiisuuꞌke makuꞌuma aaꞌpuuꞌ tee, “A, Daari Meekung-koo napoꞌ eeꞌ daariari otong, ‘Diiꞌke tee Ovoring diikaang Kumponing parapaara-koo siperiaukaꞌ.’” ");
INSERT INTO nas_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Teketa napoꞌ Sietaniꞌke Jiisuuꞌ aꞌdeiꞌ iuꞌkoo isikung-koo koing-antavura ookara muuꞌnanka kansiꞌkoo tampaꞌ oroꞌnanka oo-antavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Eeꞌnoko Sietaniꞌke aaꞌpuuꞌ, “Aing ookara ninge oko-antarampeuꞌ daꞌ ning-koo miinge keentarara dootuuꞌmei dei.” ");
INSERT INTO nas_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Teketa Jiisuuꞌke aaꞌpuuꞌ tee, “Tokoi tenkeniai daꞌ Sietaniꞌ ning-ankoita, aiꞌ Daari Meekung-koo eeꞌ daariari otong, ‘Diiꞌke Ovoring diikaang Kumponing narung dootuuꞌeriaing, eeꞌnoko niiꞌnung siomperiaꞌ otoriai.’” ");
INSERT INTO nas_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Teketa tenang Sietaniꞌke sipura beko tee, koosinunankai porora puring-antavauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tenang batei-koo Eerotiꞌke Jooni Minkinarai kiimatanava-koo daiꞌura sipuuꞌ. Eeꞌnoko Jiisuuꞌke tee taaravura tee Kaaleliꞌnameng-aape toroaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Teka Nasaretiꞌ sipura Kapaneumeꞌnavuntuꞌkoo otouꞌ teꞌ eeꞌnooꞌ teꞌ nuaruꞌ dueꞌ Sebulon-namuuꞌ eeꞌnoko Napitalai-namuuꞌ biikanameng-koonooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Teeꞌ biikanameng-koo beioꞌ tee kara teie nakaronara temuꞌnunge Aisaiaꞌke minkuvuuꞌnung dupearuꞌ Daari Meekung-koo aaꞌpuuꞌnooꞌka, ");
INSERT INTO nas_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Teinge nantoonge mutaananooꞌ otoromainge pankaing araka ooaavaing teinge Sebulon eeꞌnoko Napitalai beekanavaro-kooninge, teꞌ ookamenta-koo otoromanooꞌ aaꞌnoko pirung-aape danto eeꞌnoko Jooꞌdani-nari-eta eeꞌdaanto, teꞌ eeꞌnooꞌ Kaaleliꞌ, Juꞌdeeaing Biikanooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Teing eeꞌning teꞌ booꞌke anivumanameng-koo otoromaing arakai taneꞌpuriaing.” ");
INSERT INTO nas_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eeꞌnoko tenang-eta deto Jiisuuꞌke daankinang tutumpuuꞌ aaꞌpuma, “Bereꞌdariai paninung muuꞌkoo tuntariainaꞌ, aiꞌ tee muuꞌ tee enang dueꞌ poing.” ");
INSERT INTO nas_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Eeꞌnoko teketa Jiisuuꞌ Kaaleliꞌnaruꞌkoo miiringe nanuma teie kemaintara teka oovuretuꞌ aaꞌnoko Saimoniꞌ tee niiꞌnooꞌke Piita, eeꞌnoko tee Aanduruꞌ, baaraꞌmaꞌnung, sionung duaꞌureko teruꞌkoo, aiꞌ temainta tee taviꞌ baranka. ");
INSERT INTO nas_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Eeꞌnoko Jiisuuꞌke aaꞌpuretuꞌ, “Poreta ning siomereai, nantoong baranka deeng-antarampeainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eeꞌnoko namuꞌke tee beekaang sionung sipureta Jiisuuꞌ siompuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Teketa napoꞌ nanuma niiꞌnamainta oovuretuꞌ miring Jeemisi namainta Jooni, Siebedi baurinketa, bakaasi-koo beuma ninka otoroko, Siebedi ninka, biikaang sionung pateꞌaama. Teketa Jiisuuꞌke temainta bokuvuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Eeꞌnoko namuꞌke temaintai biikaang bakaasi eeꞌnoko tee beuma sipureta Jiisuuꞌ siompuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jiisuuꞌke tee ootukunairue Kaaleliꞌke nanuma nau-antavuruꞌ nantoong pava dootuuꞌnanka biikaning-koo. Nau-antavurima daankivukoꞌ tee doorenang tampara Kumponing bakaang muuꞌkoong, eeꞌnoko taare-antavurikoꞌ nantoong siipa amutemuriiꞌpoꞌnupoong. ");
INSERT INTO nas_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eeꞌnoko doorenang tee-koong Siiria-namenge nanuꞌantavauꞌ, eeꞌnoko teketa ookara siipa amutemuriiꞌpoꞌnupoong tavoꞌaaruꞌ tee-anko, sisikeerai toraꞌantavurikoꞌning, maꞌnarie koriaarikoꞌning, kookoko˜poꞌnupoong, eeꞌnoko dootanuka, eeꞌnoko teꞌ poꞌantavaariko taare-antavurikoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eeꞌnoko nantoong karingai aaꞌning-eta Jiisuuꞌ siompai nanaakoꞌ, Kaaleliꞌnupoong, Dekapolis-navete-nupoong, Jerusalemaꞌnupoong, Judiaꞌnavete-nupoong, eeꞌnoko ookara Jooꞌdani-nari-koo aveteraang-nupoong. ");
INSERT INTO nas_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tenang teinge nantoong karingai Jiisuuꞌ siompaioꞌ oovurira tee mii-koo deto koinura baꞌnamparuꞌ. Eeꞌnoko bakaning barevare-nupoong tee-anko porouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Eeꞌnoko teie nau-anta tutumpuma aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Biraanke-nupoong teing nantoong biikaang tanuaang ataataꞌkoo otoko tasiꞌpariaining, aiꞌ muuꞌ paninung tee teing okovoroaing. ");
INSERT INTO nas_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Biraanke-nupoong teing nantoong orarunsiarimaing, aiꞌ teing teing eeꞌning Ovoringe dunsirunsi˜antavuriaining. ");
INSERT INTO nas_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Biraanke-nupoong teing Kumponing-koo arooꞌariri banainge otoromaing, aiꞌ biikaang barenku okovoroaing tee ookara kansiꞌ tare-koong. ");
INSERT INTO nas_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Biraanke-nupoong teing nantoong peeravoroma nukaaꞌoromaing tee-koo aarumo koontoꞌ siong-koo, aiꞌ teing teing poovuriaining. ");
INSERT INTO nas_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Biraanke-nupoong teing nantoong piaa-baukonuka, aiꞌ Kumponinge teing piaavuriaing. ");
INSERT INTO nas_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Biraanke-nupoong teing nantoong domang kiiroraaꞌnuka, aiꞌ teing teing Kumponing ooaavaining. ");
INSERT INTO nas_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Biraanke-nupoong teing mooa nkonuka, aiꞌ teing teing Kumponinge baurukaaꞌ tampuriaining. ");
INSERT INTO nas_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Biraanke-nupoong napoꞌ teing nantoonge mankiꞌantavaarimaatoaining aarumo koontoꞌ siompaioꞌ, aiꞌ tee Muuꞌ Paninung tee teing biikaang. ");
INSERT INTO nas_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Biraanke-nupoong napoꞌ diiꞌ tenang nantoonge deuꞌdaarima mankiꞌantaraariko eeꞌnoko daanaꞌ avutevuꞌai orakaꞌ minkuraariko ning diiꞌke siomerimaung-koo. ");
INSERT INTO nas_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Doturarima doꞌderoꞌdeꞌdariai eeꞌ noruꞌerima, ‘Niikaang mooꞌ pankaing otong teke paning-koo.’ Aiꞌ tee teeꞌ nariꞌ nantoonge teing nakaro-nupoong tee diiꞌpinaꞌ nariꞌ mankiꞌantavaarikoꞌ, diiꞌkoo uroꞌnupoong.” ");
INSERT INTO nas_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Diiꞌ teing devaꞌnuka ookara kansiꞌkoo, teka tee devaꞌ tariiꞌnooꞌ paaꞌarapeuꞌnung arekeeꞌ napoꞌ tariiꞌantavupeuꞌ? Tee aaꞌ tee tamunsiꞌnung deemparing. Tamung doonko duaꞌuma nantoonge mmemmeꞌkoo makosi. ");
INSERT INTO nas_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Napoꞌ diiꞌ teing arakanuka ookara kansiꞌkoo. Narung osi iuꞌkoo dau kaniaapeuꞌnung tee bakuꞌkoo makosi deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nantoonge tee araka paroꞌaara antonaꞌkoo boong sipaavarupeuꞌ, teka sirang batanang-koo panteꞌaapeuꞌ bakanooꞌ, eeꞌnoko teketa araka-antavuripeuꞌ ookara nantoong pava-koo kuunge otoromaing. ");
INSERT INTO nas_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Teeꞌ nariꞌ diikaang araka araka-antaveriaing nantoong-koo uroꞌkanooꞌke diikaang nko-nko tampara ooaara Diuma tee paning-koong daangampaavainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ning diiꞌke tee boto Moosesi-nung eeꞌnoko nakaro-nupoong biikaang kara kui-koo mouꞌnung-pinaꞌ noruꞌmeriaukaꞌ. Ning teing kui-koo moaꞌ, teka teing dupe-anta-koo mouꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Masikaꞌ naurampimang, tenang paning eeꞌnoko kansiꞌ opareainooꞌke basinooꞌkoo okiꞌnaare niiꞌnooꞌ namooraꞌnooꞌ daari-koo kuiaravaꞌ tee boto tee bakei teeꞌ nariꞌ otoaing bera ookara kapooꞌnanka dupearavainooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Baa tee naning aung-koo botonanka-koo okiꞌnarekaꞌ masikeng-koo narung totoꞌpura niiꞌning nariꞌ nau-antavuriaing tee tee okiꞌnung masikung tang-koong teka muuꞌ paninung-koo. Eeꞌnoko baa tee naning siompuma nau-antavuriaing tee botonanka tee eeꞌnung pankaing tang-koong teka muuꞌ paninung-koo. ");
INSERT INTO nas_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aiꞌ ninge diiꞌ eeꞌ naurampimang, diikaang aarumo tamparai teꞌ kuung masipoꞌ teing boto keperuuꞌnavitu tamparimaing eeꞌnoko boto naunuka biikaang puruꞌuaukaꞌnung deekoꞌ diiꞌ muuꞌ paninung-koo bakei tuntariaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Diiꞌke taaraverimaung uripoꞌketa aaꞌpui otoing, ‘Naninge niiꞌnung dupisiꞌeaukaꞌ, eeꞌnoko baa tee dupisiꞌ nkovuaing tee tuutunang˜koong.’ ");
INSERT INTO nas_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Teka napoꞌ ninge eeꞌ naurampimang, baa tee naning baꞌmarang-koo narung iiraevuaing tee teeꞌ nariꞌ tuutunang-koonge. Napoꞌ baa tee naning niiꞌnung baꞌmarang-koong noruꞌ otoaung tampuaing tee tee koompaaraꞌnavitu-anko beꞌanta-koo makosi. Teka baa tee naning niiꞌnung barakosiꞌuma aaꞌpuaing, ‘Daꞌ kanuꞌ!’ tee tee mosianung-aape nanuꞌkoo makosi, teꞌ ntaꞌpoꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Teeꞌkoo dake avuavuꞌ darimpeeꞌnaang nkorarama teke boonturomai eeꞌnoko teke niiꞌnung daꞌmarang-koong daꞌ ninka iira otoing noruꞌera deekoꞌ, ");
INSERT INTO nas_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ioꞌ teka boonturoma uroꞌkanooꞌke sipera tee dakaang avuavuꞌ, tutung bera tee ninka mooa-antareereai, eeꞌnoko teketa tororarara tee dakaang avuavuꞌ darimpeai. ");
INSERT INTO nas_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Naninge karenunge daꞌ tuutunang-koo barantuko iriꞌnarung koompeai tee kara, mmeꞌ taung naniresitaaꞌ simpeꞌnko˜anko tavoꞌduaruko. Teie napoꞌ piatooro˜anko beꞌantaruko kiimataroma siꞌduꞌneenga. ");
INSERT INTO nas_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Masikaꞌ naurampimang, diiꞌ kiimatanavaꞌketa tenkeniriarupeuꞌ mooniꞌkoo asiꞌnu duaꞌkiriaꞌ deekoꞌ tuutunang mooꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Diiꞌke taaraverimaung uripoꞌketa aaꞌpui otoing, ‘Nampeesi orarieriaukaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Teka ninge aaꞌdampimang, baa tee naning nani manikuma karaaꞌui oovuaing teie tee nampeesi tero orarivuing teni ninka bakaang domange. ");
INSERT INTO nas_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dakaang duta tampavine-koonge duaꞌantaruko deekoꞌ orara aarumo-koo tee kaꞌbampera taapoꞌ duaꞌeai. Tampaꞌnaꞌ daꞌkoo navioꞌ paaꞌaravaing dakaang ootukunung mono mosianung-koo duaꞌduꞌneenga. ");
INSERT INTO nas_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Eeꞌnoko napoꞌ dakaang birenge tampavine-aapenunge duaꞌantaruko deekoꞌ orara aarumo-koo, tenaang napuꞌdarara taapoꞌ duaꞌeaing. Tampaꞌnaꞌ daꞌkoo mono-koo navioꞌ paaꞌaravaing dakaang ootukunung mono mosianung-koo naniꞌneenga. ");
INSERT INTO nas_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Uripoꞌketa aaꞌpari otong, ‘Baa tee naning baꞌaang sipuma teie narung karavoto˜ daarivuaing nampeesi totoꞌpuing tasiꞌanta-koo.’ ");
INSERT INTO nas_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Teka ninge aaꞌdampimang, baa tee naning baꞌaange tutung kaukauro nkovuaruko bataꞌura deekoꞌ teie tee teni tuuꞌumaang niiꞌnarai nampuko nampeesi orarivuuꞌnaang. Eeꞌnoko baa tee naning teni bataꞌniiꞌ nampuaing teie tee nampeesi orarivuing.” ");
INSERT INTO nas_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Napoꞌ diiꞌke taaraverimaung uripoꞌketa aaꞌpui otoing, ‘Diikaning masikaꞌdetonanka totoꞌperiaꞌ otoai, nka tampaꞌ siomperimatoai Ovoring-koo nkoverira.’ ");
INSERT INTO nas_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Teka ninge eeꞌ naurampimang, bakei masikaꞌ deto tamperiaꞌ otoai. Paning tang-koo makotuaꞌ, aiꞌ teꞌ teꞌ Kumponing bakanooꞌ meepoꞌ baꞌnaniꞌdoma. ");
INSERT INTO nas_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kansiꞌ tang-koo makotuaꞌ, aiꞌ teꞌ teꞌ Kumponing bakanooꞌ kauꞌ patuꞌdoma. Napoꞌ Jerusalemaꞌ tang-koo makotuaꞌ, aiꞌ teꞌ teꞌ Daurarong˜ Pankaing bakanooꞌ osi. ");
INSERT INTO nas_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Eeꞌnoko napoꞌ masikaꞌ deto dakaang boreꞌ tampema minkueaukaꞌ, aiꞌ dake tee-koong daponaviꞌ niiꞌnaꞌ duꞌantavearupeuꞌ kakaara-antavema deekoꞌ eeꞌnoko mutaanuꞌantavema deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Teka ‘Eeꞌ’ miruꞌema ‘Eeꞌ’ narung tampeai. ‘A’ miruꞌema, ‘A’ narung tampeai. Aing-koo taapoꞌning, teing masikaꞌ deto dovang, kara teieta naning orara-ita pomaing.” ");
INSERT INTO nas_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Diiꞌke taaraverimaung uripoꞌketa aaꞌpui otoing, ‘Naninge dakaang duta kaꞌbampuko, makosi bakaang duta kaꞌbampaavaing makuꞌkoo,’ eeꞌnoko ‘Naninge dakaang siꞌdaꞌ nakiꞌuko, makosi bakaang siꞌdaꞌ nakiꞌaavai makuꞌkoo.’ ");
INSERT INTO nas_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Teka ninge aaꞌdampimang, naninge orakaꞌ nkoruko tankaꞌniꞌpeaukaꞌ tee. Naninge tampavine-koo amoꞌkoo tankoꞌduko napoꞌ bereꞌdarako asiꞌnameng tauraꞌpeko tankoꞌduai. ");
INSERT INTO nas_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Eeꞌnoko napoꞌ niiꞌnunge naninge daang koosiruma mononopaꞌke makuꞌkoo eentavarako deekoꞌ, makosi tee avema napoꞌ niiꞌnaaꞌ nariꞌ aveai. ");
INSERT INTO nas_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Napoꞌ niiꞌnung naninge niiꞌnooꞌ basinooꞌ nanireeꞌnaang eturuko napoꞌ bonoꞌ divuꞌei niiꞌnooꞌ basinooꞌ nariꞌ nanireai. ");
INSERT INTO nas_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Naninge eentaruko kapooꞌ aveai eeꞌnoko dakaang kapooꞌ kong-koo niaꞌduko orokoveaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Diiꞌke taaraverimaung uripoꞌketa aaꞌpui otoing, ‘Daꞌmaikoꞌ daꞌkoo miirinung piaavema eeꞌnoko daꞌkoo karenung munteꞌeai.’ ");
INSERT INTO nas_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Teka ninge eeꞌ naurampimang, teing diikaning kare-nupoong piaaverererimaatoaing. Teing diiꞌ barakosiꞌdaariaining biraankevereriai. Teing diiꞌ munteꞌdaariaining tampaꞌ nkovereriai. Eeꞌnoko teing diiꞌ orakaꞌ nkoraarima mankiꞌantaraariaining kunsi-koo pakuereriai. ");
INSERT INTO nas_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Diiꞌke teeꞌ nkoverima Diuma tee paning-koong baurukaaꞌ deentariainaꞌ. Tee eeꞌnung tee bakaang duaaꞌ ookeng-koo araka-antavumaung tampeng-koo eeꞌnoko oreng-koo, eeꞌnoko apoꞌ teeꞌ nariꞌ botovukooꞌ aaꞌning-koo koontoꞌnuka-koo eeꞌnoko koontoꞌnuka deeaing-koo. ");
INSERT INTO nas_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Eeꞌnoko diiꞌke teing nantoong diiꞌ piaaraarimaing naing piaaverererira deekoꞌ mooꞌ aremuriiꞌ nkaveripeuꞌ Kumponing-eta? Teeꞌ ee deeaꞌ nariꞌ teing oreng taakisi nkanuka nkoarimanaꞌ? ");
INSERT INTO nas_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Eeꞌnoko diiꞌke teing daꞌmarang naing onkeonkeꞌereriaing deekoꞌ aming kapooꞌ dau basi niiꞌning nkoaamaing-koo nkoveripeuꞌ? Bakei katuaꞌ. Mutaanang-nupoonge ee teeꞌ nkoaavaung? ");
INSERT INTO nas_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Teeꞌkoo tampaꞌ nariꞌ nkoverimatoaing teeꞌ Diuma paning-koong tampaꞌ nariꞌ otomanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tanatarariaing diiꞌ. Dootuuꞌkoong aarumo tampara nkoverima nantoong-koo dutakanooꞌke nkoveriaukaꞌ teinge ooraariiꞌnaang. Teeꞌ nkoveriaing deekoꞌ tee, teie Diumai paning-koonge mooꞌ aruriaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aaꞌnomaatoai tenang teing ataꞌoinku averererima deekoꞌ tee-koo tuuviri puumperiaꞌ otoai teinge ampirinunukai nkoaamanaꞌ pava dootuuꞌnanka-koo eeꞌnoko napoꞌ taung sionairu-koo maroita nantoonge pankaing-antavaariiꞌnaang. Ninge masikaꞌ naurampimang, teinge tee biikaang mooꞌ ookara teka nkavaamaung. ");
INSERT INTO nas_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Teka tenang diiꞌke teing ataꞌoinku averererima bakuꞌeri nkoveriai kapooꞌ tampanaange nkovuaing mareꞌanaange noruꞌuaukaꞌ; ");
INSERT INTO nas_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Eeꞌnoko teie Diumai kapooꞌ bakuꞌniiꞌ oovumaunge sirapoꞌke mooꞌduriai diiꞌ tee-koo.” ");
INSERT INTO nas_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Tenang kunsirarima teing-pinaꞌ ampirinunuka-pinaꞌ nkorariaꞌ otoai. Pava dootuuꞌnairu-koo eeꞌnoko taung sionairue donkonai kunsi-koo aaꞌnaꞌ piavoromaing-pinaꞌ nantoonge ooaariiꞌnaang. Ninge masikaꞌ naurampimang, teinge tee biikaang mooꞌ ookara teka nkavaamaung. ");
INSERT INTO nas_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tenang diiꞌ kunsirarima diikanavaro-koo avoꞌniiꞌnavaro-koo tuntarima karanaang daꞌperima kunsirarimatoai tee-koo Diuma-koo naninge oo-paaꞌkoo, eeꞌnoko teie Diumai kapooꞌ bakuꞌniiꞌ oovumaunge sirapoꞌke mooꞌduriai diiꞌ tee-koo. ");
INSERT INTO nas_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Eeꞌnoko tenang kunsirarima kara putuꞌeriaꞌ otoai teinge mutaanang-koo-nupoonge nkoaamanaꞌ aaꞌpaama, ‘Mmauꞌ kara-koo taaramuriainaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Koontoꞌ teing-pinaꞌ nkorariaukaꞌ, aiꞌ teie Diumai tee noruꞌumaung teing kapooꞌ diiꞌ apukaꞌdarimaing tutung eentaveriaruko tee. ");
INSERT INTO nas_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Kunsirarima eeꞌ kunsirarimatoai, ‘Niuma paning-koo otomaung, dakaang miring meekaꞌantavari otoaing. ");
INSERT INTO nas_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dakaang muuꞌ poꞌantaveai. Dakaang pia nkoaravaing anke kansiꞌkoo paning-koo nkoaramanaꞌ nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Eꞌmung-koo makosinaꞌ ameriai tee taamang doong kante amerimaung. ");
INSERT INTO nas_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tontaꞌantameriai niikaning orarananka niiꞌ orakaꞌ nkomaarimaing tontaꞌantaevorompimanaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Eeꞌnoko parapaara-koo siꞌmeriaukaꞌ, teka tontaꞌantameriai teieta naning orara bakaang purintoꞌketa; aiꞌ daꞌ tee ookara-koo okorui tarenumpoꞌ, purintoꞌpoꞌnung, eeꞌnoko meenaꞌdoi otomaung ookara doong-koo. Teeꞌ eeꞌnaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Aiꞌ diiꞌke nantoong tontaꞌantavereriko teing diiꞌ orakaꞌ nkoraarimaing teie Diumai paning-koonge diiꞌ teeꞌ nariꞌ tontaꞌantaruriainge. ");
INSERT INTO nas_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Teka diiꞌke tontaꞌantavereriaruko nantoong teing biikaning orakaꞌ nkonanka-koo teie Diumai tee tontaꞌantaruriaukaꞌnung diikaning orarananka-koo.” ");
INSERT INTO nas_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tenang diiꞌ unkumorarima munteꞌdorining-pinaꞌ oroꞌdariaꞌ otoai teing ampirinunuka nkoarimanaꞌ, aiꞌ teing teing oing orakaꞌ oroꞌantavarimaing maroita unkumoaririning taaꞌniꞌantavarima. Ninge masikaꞌ naurampimang, teinge tee biikaang mooꞌ ookara teka nkavaamaung. ");
INSERT INTO nas_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Teka tenang diiꞌ unkumorarima oing duuꞌdarimatoai boreꞌ duunie sisiꞌdarima nantoong-koo diiꞌ unkumoraririning-pinaꞌ oroꞌdariaukaꞌnaꞌ; ");
INSERT INTO nas_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Teka tee narung-koo Diuma-koo naninge oo-paaꞌkoo deekoꞌ siraꞌdariri otoriai eeꞌnoko teie Diumai kapooꞌ bakuꞌniiꞌ oovumaunge sirapoꞌke mooꞌduriai diiꞌ tee-koo.” ");
INSERT INTO nas_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Aꞌ kansiꞌkoo kapooꞌ tampeng kavonanka oosieriaꞌ otoai teꞌ pumpuꞌ dovange eeꞌnoko takarauꞌ aaꞌninge orariaamanooꞌ, napoꞌ bakisipunankai pesiꞌaama bakiaaꞌaamanooꞌke. ");
INSERT INTO nas_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Teka paning-koo mooꞌ tampeng oosierimaatoai teꞌ eeꞌnooꞌ pumpuꞌ dovange eeꞌnoko takarauꞌke orariaavarupeuꞌ, napoꞌ bakisipunankai pesiꞌaama bakiaaꞌaavaꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aiꞌ teꞌ tokoo naning bakaang muuninava˜ otoainooꞌ bakaang pankaruntoonge noruꞌ tee teꞌ otoaing. ");
INSERT INTO nas_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Domang tee duta pinaꞌ, tee diikaang mono bakaang puu. Tenang diikaang duta tampara deempari otoko diikaang mono ootukunairu arakai maantoꞌui otopeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Teka duta tampara deeaung deempari otoko diikaang mono mutaanange maantoꞌui otopeuꞌ. Teeꞌkoo tee diikaang domang mutaanang-nameng-koo otoko deekoꞌ bakei aaꞌnaꞌ masikaꞌ mutaanantoriaining. ");
INSERT INTO nas_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Narunge kenaanka ovontura siompurearupeuꞌ, aiꞌ teie tee narung munteꞌuma niiꞌnung piaavumatopeuꞌ, niiꞌnooꞌ narung siompuma niiꞌnung siompuarupeuꞌ. Teeꞌkoo diiꞌke Kumponing eeꞌnoko kavokavoro ookeng deto deeng-antaveriarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Teeꞌkoo ninge naurampimang diiꞌ, noruꞌ mankiꞌdoriaꞌ otoai aaꞌning-koo taamang tovang ntong domanturiaining eeꞌnoko mononopaꞌnanka. Aming-koo, nnaꞌ, domaang tee taamang-koo biꞌari otoaꞌ eeꞌnoko mono tee baarong-koo ioꞌaravaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Oovereriai teing barennanka auviꞌau-kooning. Teing teing kapooꞌ keeng noruꞌaavaꞌ, kavaama oosi noruꞌaavaꞌ, koreꞌ noruꞌaavaꞌ pava-koo, teka teing teing Diumai paning-koonge bauꞌurimaing. Enang arekeeꞌ, diiꞌ ee teing-koo dau basinanka deeaꞌ bakaang norunoruꞌkoo? ");
INSERT INTO nas_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Eeꞌnoko diiꞌkoo baie noruꞌ mankiꞌoma doong naraangaꞌnooꞌ deto beꞌnuꞌantavura teꞌkoo domampari otopeuꞌ? Otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Eeꞌnoko aming-koo napoꞌ diiꞌ baarong tovang-koo noruꞌ mankiꞌdorikooꞌ? Oovereriai teing iiooꞌnanka tamung dupurimanaꞌ, baarong tuaꞌkoo poreꞌoroainge. ");
INSERT INTO nas_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Teka ninge eeꞌ naurampimang, aaꞌnaꞌ tampaꞌ nerampurimaung nantoong biikaang meenasi puruꞌuitaaꞌ, bane dauraronanka Solomoniꞌpinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Teka Kumponinge baaꞌnanka teeꞌ nerampurimaung deekoꞌ, teing aaꞌnomaing naꞌmung doong-koo domamparara daunaꞌmung maraꞌoko tai-antavaakooꞌ, tee tee teeꞌ nariꞌ tasiꞌperiaing diiꞌke, masikaꞌanta okiꞌnaa otoꞌderurininge, aiꞌ diiꞌ teing deto basinooꞌ noruꞌduri duaanaruriaining. ");
INSERT INTO nas_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Teeꞌkoo enang tee noruꞌ mankiꞌdoriaꞌ otoaing aaꞌperima, ‘Aming naiampiiꞌnaang?’ eeꞌnoko ‘Arenaaꞌ kurumariiꞌnaang?’ ");
INSERT INTO nas_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aing eeꞌ oroꞌ kapooꞌ mutaanang-nupoonge kariaamaing, teka diiꞌ teeꞌ deeaꞌ, aiꞌ diiꞌ Diumai Paning-etaing noruꞌui otong aing ookara kapooꞌ diiꞌ apukaꞌdarimaing. ");
INSERT INTO nas_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Teeꞌkoo ainkato noruꞌeriaꞌ Kumponing bakaang muuꞌ deto pankaruntoonge noruꞌerimatoai tee ninka bakaang aarumo koompari otoꞌ ninka nariꞌ eeꞌnoko teing aing kapooꞌ apukaꞌdarimaing nariꞌ aruriainge. ");
INSERT INTO nas_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Teeꞌkoo taneꞌnung doong-koo noruꞌ mankiꞌdoriaukaꞌ. Taneꞌ teꞌmung baka noruꞌaravainaꞌmung. Aiꞌ ookara mankiꞌnanka naꞌmung doong-koo makosinaꞌ bireꞌari otong.” ");
INSERT INTO nas_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nantoong koong-anta-koo oioiꞌdariaꞌ otoai Kumponinge nariꞌ koong-antaruꞌneenga. ");
INSERT INTO nas_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aiꞌ diiꞌke koong-antavererimaung-koo teeꞌ nariꞌ Kumponinge diiꞌ koong-antaruriaing. Tee paaranang kompei nantoong koong-antaverimanarong Kumponinge kompui daꞌ koong-antaruuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aming-koo dake nankiꞌ daaraꞌmaꞌnung-koo duta-koo oovemaunge teka daka noruꞌdaravaꞌ daꞌkoo duta-koo konkinarong otoing? ");
INSERT INTO nas_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Arekeeꞌ dake aaꞌpepeuꞌ tee daaraꞌmaꞌnung, ‘Ioꞌ nankiꞌ mooꞌdampai daꞌkoo duta-koo otoing,’ tenang daka ooraravaꞌ tee konking daꞌkoo duta-koo otoing. ");
INSERT INTO nas_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Daꞌ ampirinung˜, iroꞌ tutung daka-koo mooꞌdaravaing tee konking duta-koo eeꞌnoko tenang daaraꞌmaꞌnung-koo sirakaꞌpei oovera mooꞌeai tee nankiꞌ daaraꞌmaꞌnung-koo duta-koo otoing.” ");
INSERT INTO nas_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Eeꞌnoko Jiisuuꞌke mirumiruꞌ nauvurima aaꞌpuuꞌ, “Kapooꞌ meekung mosiꞌnanka averereriaꞌ otoai bereꞌarima okiꞌnooꞌnaꞌ tairaarima busivusiriraariꞌneenga. Eeꞌnoko napoꞌ diikaang dukuꞌ pooroꞌanko duaꞌeriaꞌ otoai. Teeꞌ nkoveriko metoꞌ ninka nariꞌ meeꞌaama moreꞌaaꞌneenga.” ");
INSERT INTO nas_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Eentarariai aruriainaꞌ. Besiꞌeriai daaꞌeriainaꞌ. Kopikopiꞌeriai karanaang daateꞌderuriainaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aiꞌ ookara nantoonge eentavarimainge tee nkavaamaung, eeꞌnoko besiꞌaamainge tee daaꞌaamaunge, eeꞌnoko karanaang kopikopiꞌaamaing teinge daateꞌevurimaunge. ");
INSERT INTO nas_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Diiꞌkoo baie bauring taamang-koo eentavuko kapang avupeuꞌ? ");
INSERT INTO nas_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Niiꞌnooꞌ taviꞌkoo eentavuko ee boruꞌ avupeuꞌ tee? Otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tee tee diiꞌke orenge diurukaaꞌ tampaꞌ averererimaung deekoꞌ noruꞌeriaing teie Diumai paning-koo otomaunge bakei tampaꞌ masikaꞌ avuriaing teing tee-koo eentavarimaing. ");
INSERT INTO nas_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Teeꞌ nantoonge diiꞌ tampaꞌ nkoraariiꞌnaang piarorimanaꞌ teeꞌ nariꞌ nkovererimaatoaing teing diiꞌke, aiꞌ teie aunge aarumoi tee boto Moosesi-nung eeꞌnoko nakaro-nupoong urikupoong biikaang naroꞌka dupeantavuri otong.” ");
INSERT INTO nas_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Muuꞌ paninung-koo tuntoma teꞌ ito-navarong. Teke tevaronge tuntariaing avutevuꞌdariaꞌ, aiꞌ tee karanaang pankaing, eeꞌnoko taung tee beetaꞌniiꞌ tee mosianung-aape bei otong, eeꞌnoko mmauꞌ tevaronge tumparimaung. ");
INSERT INTO nas_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Teka tevarong ito-navarong kaponavunge danto tee domaang isikung-anta-aape bei otong, eeꞌnoko mmauꞌ nantoonge dekopiꞌaamaung tevung.” ");
INSERT INTO nas_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Tanatarariaing teing-koo nakaro-nupoong daang Kumponing-etaning tamparimaing-koo. Teing teing diiꞌanko sipisipiꞌkoong dopaꞌ kurumpariri poroaing, teka kuunooꞌ teing teing nkaunanka makosi-nanka tairoꞌnanka. ");
INSERT INTO nas_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Teka tee-koo biikaang sinananka-koo diiꞌke tasiꞌpereriaing. Aiꞌ nantoonge ee karikauꞌ tooꞌmurintaaꞌpoꞌnavari-koo kavaapeuꞌ? Aiꞌ kiring ee nantong-koo kavaapeuꞌ? Otoaꞌ! ");
INSERT INTO nas_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Teeꞌ nariꞌ ookara koiꞌ tampenanka-koo tee sinang tamparananka biꞌumaung. Eeꞌnoko tee-koo koiꞌ orara-koo sinang orara biꞌumaung. ");
INSERT INTO nas_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tee-koo koiꞌ tampara-koo orara sinang biꞌuarupeuꞌ, eeꞌnoko orara koiꞌkoo sinang tampara biꞌuarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Eeꞌnoko ookara koiꞌnanka sinang tampara biꞌuaukaꞌning teing nokiaarima ntaꞌkoo duaꞌaariaining. ");
INSERT INTO nas_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Teeꞌkoo biikaning sinananka-koo diiꞌke tasiꞌpereriaing teing nakaro-nupoong Kumponing-etaning deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mmauꞌke tee aaꞌmaamaung, ‘Ovoring, niikaang Ovoring,’ nka teing ookara nariꞌ tumpariaukaꞌnung teꞌ muuꞌ paninung-koo, teka teing naing deekoꞌ tee Mmaꞌ paning-koong bakaang pia siompaavaining tumpariaing. ");
INSERT INTO nas_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Napoꞌ nantoong karingai aaꞌmaavainge ning teꞌmung, ‘Ovoring, Ovoring, niiꞌ ee dakaang miring-koo tarampeemariaruuꞌning˜ napoꞌ dakaang miring-koo maꞌnari bataꞌarampiaruuꞌninge taaꞌniꞌantananka mmauꞌ nkoampima?’ ");
INSERT INTO nas_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Teka ninge eeꞌ nauarampaing teing siraꞌpansi, ‘Temuꞌketa diiꞌ nkaning pinaꞌ noruꞌdampiaung. Tokoi beriai ning-ankoita diiꞌ orara aarumo nkonuka.’” ");
INSERT INTO nas_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Teeꞌkoo ookara nantoong aung nkaang kara taaravaama nkoaakooꞌ teing teing tee-pinaꞌ naning norukasiꞌ tee bakaang pava boiaꞌkoo dau kanivuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Teketa aing aaꞌning pouꞌ: apoꞌ duaꞌaruꞌ, doua tuuvuuꞌ, eeꞌnoko dovinge aaꞌnaꞌ duparara dankampuuꞌ tee pava, teka teva pesiꞌaravaꞌ, kapang-koo boiaꞌkoo eꞌmaniiꞌnava deemparako. ");
INSERT INTO nas_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Teka teing ookara nantoong nkaang kara tamung taaravaama siompaavarukooꞌ teing teing tee-pinaꞌ naning kanuꞌ tee bakaang pava tamung piisiꞌkoo dau kanivuuꞌnung-pinaꞌ, eꞌmang-antavuaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Eeꞌnoko tenang teing aing aaꞌning pora apoꞌ duaꞌaruꞌ, doua tuuvuuꞌ, eeꞌnoko dovinge aaꞌnaꞌ duparara dankampuuꞌ tee pava, eeꞌnoko bakei pesiꞌarara tuung tanuuꞌ tee pava.” ");
INSERT INTO nas_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Eeꞌnoko tenang Jiisuuꞌke teeꞌ minkuvura bakearioꞌ nantoong karinga bakei aaꞌnaꞌ taꞌnimpariruꞌ tee-koo bakaang nau-anta-koo kara bakaang purintoꞌ deemparioꞌ, teing-pinaꞌ biikaning boto naunuka-pinaꞌ deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tenang Jiisuuꞌ mii-eta nau-antavurira depeto siarioꞌ nantoong karingai siompauꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Eeꞌnoko narung oramuuꞌpoꞌnung pora Jiisuuꞌkoo uroꞌkanooꞌ kinkinui eentavarama aaꞌpuuꞌ, “Ovoring, daꞌ piarora deekoꞌ dake ning aung oramuuꞌ kuimepeuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Teketa Jiisuuꞌke bireng tovoroꞌarara kompuuꞌ tee, aaꞌpuma, “Piamoi otong. Enang kuiraring!” Eeꞌnoko namuꞌke tee tee bakaang oramuuꞌ kuiaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Teketa Jiisuuꞌke aaꞌpuuꞌ tee, “Tarerari naning naueaukaꞌ, teka namuꞌke Moosesi bakaang boto siompei piristiꞌkoo siraꞌantararavai, eeꞌnoko tampaꞌ ooruko Kumponing-koo boontunang nkoveai nantoonge tee taaꞌniꞌanta ooaara daꞌ teing ninka nariꞌ otoꞌkoo tauraꞌniiꞌ tasiꞌdaavainaꞌ, teeꞌ Moosesi bakaang botoi minkuvumanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tenang Jiisuuꞌ teꞌ Kapaneumeꞌnavuntuꞌkoo tumparara otoko narung Juꞌdeeaung piatooronuka narung daakuꞌ tarenara tee-anko pora pakupaku-koo eentavaruꞌ aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ovoring, nkaang bautara osie bempari otong siipai sisikeera ninka doota-antavuioꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Teketa Jiisuuꞌke aaꞌpuuꞌ tee, “Meraiꞌnang taare-antavamaꞌnaang tee.” ");
INSERT INTO nas_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Eeꞌnoko teie piatooronuka daakuꞌ tarenarai makuꞌuma aaꞌpuuꞌ, “Ovoring, ning tee makosi deeaꞌ daꞌ nkanooꞌ pava-koo kuung poꞌkoo; ");
INSERT INTO nas_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ninge daꞌ pankaing tasiꞌdamira teeꞌ minkuamaang, aiꞌ ning tee napoꞌ niiꞌnooꞌ basi-koo iriꞌkoo kuung oꞌnong piatooronuka tare-koong-koo. Eeꞌnoko niiꞌnung aaꞌpanko dei, ‘Beai,’ tee bepeuꞌ. Eeꞌnoko niiꞌnung aaꞌpanko dei, ‘Poai,’ tee popeuꞌ. Eeꞌnoko nkaang bautara aaꞌpanko, ‘Aung nkoveai,’ teie nkovupeuꞌ tee. Teeꞌkoo dake tamung karai minkueko nkaang botovotonaaꞌ taarevoaing.” ");
INSERT INTO nas_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tenang Jiisuuꞌke teeꞌ taaravura taꞌninuuꞌ, eeꞌnoko teing siompaakoꞌning nauvurima aaꞌpuuꞌ, “Ninge masikaꞌ naurampimang diiꞌ: Temuꞌketa aung amuriiꞌ baito pankaing ooampaung bane Isireeli-nupoong ninka nariꞌ oꞌnorimaunge. ");
INSERT INTO nas_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eeꞌnoko ninge aaꞌdampimang, karinga nantoong duaaꞌ pomanooꞌketa eeꞌnoko tumparamanooꞌ tenairu-eta poroaining nariꞌ taaman-aavaing Eebaraamiꞌ, Aisakeꞌ eeꞌnoko Jeekopiꞌ ninka tee muuꞌ paninung taaꞌniꞌpoainaꞌmung. ");
INSERT INTO nas_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Teka teing muuꞌkoo temuꞌ miruꞌniiꞌnuka teing aꞌdang damaꞌdu duaꞌuriaining mutaananooꞌ, teꞌ eeꞌnooꞌ nantoong biromparima siꞌdaꞌ dovang kakirinkuarimatoainooꞌ sisikeera-koo otoroi.” ");
INSERT INTO nas_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Teketa Jiisuuꞌke tee piatooronuka daakuꞌ tarenara aaꞌpuuꞌ, “Naniai. Tee tee teeꞌ nariꞌ dake masikaꞌantaveinaꞌ nkoaravaing.” Eeꞌnoko tee bakaang bautara tee tenang tee-koo batei-koo taarevouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tenang Jiisuuꞌ Piita bakanava-koo pora teie Piita baꞌdoraa teke batanang-koo bemparioꞌ oovuuꞌ uipaariiꞌ ninka siipavora. ");
INSERT INTO nas_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eeꞌnoko teie teni bakaang bireng-koo kompuioꞌ tee uipaariiꞌ namuꞌke boimpuuꞌ, eeꞌnoko tenie deto iꞌamparara bauꞌuruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Teketa duaaꞌ tumparioꞌ nantoong mmauꞌ maꞌnarie koriaarikoꞌning Jiisuuꞌanko tavoꞌaaruꞌ, eeꞌnoko teie maꞌnari kara nanaarei bataꞌuruꞌ, napoꞌ siipa-nupoong taare-antavuruꞌ ookara. ");
INSERT INTO nas_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jiisuuꞌke teeꞌ nkovuma tee kara dupe-antavuuꞌ teie Aisaiaꞌke nakaronunge urikunge minkuvuuꞌnung Daari Meekung-koo aaꞌpuuꞌnooꞌka, “Teie niikaning siipananka eeꞌnoko aruaruꞌnanka nkamemurira duaꞌuaing.” ");
INSERT INTO nas_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tenang Jiisuuꞌke nantoong karingai tee koroai otoroko oovurira bakaning ninka nariꞌ pakoꞌariiꞌnaang botoaruꞌ nuaruꞌka amenkaꞌkoo karinga teꞌ otoroko. ");
INSERT INTO nas_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Teketa narunge boto naunuka-koonge tee-anko pora aaꞌpuuꞌ, “Pankaing ee, ninge tee daꞌ siontampaing areꞌ tokoo daꞌ beainooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Teketa Jiisuuꞌke makuꞌuma aaꞌpuuꞌ tee, “Nkaunanka biikaning kumpenanka otoꞌevoromaung, eeꞌnoko barennanka auviꞌau-kooning biikaning bitonanka, teka ning Tee Naning-naumpoꞌ Paning-etaing˜ tokoo boreꞌ patuꞌmaravainooꞌ otoꞌmemuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Teketa napoꞌ teing siompaakoꞌning-koong narung pora aaꞌpuuꞌ, “Ovoring, ioꞌ tauraꞌmeko mmaꞌ dakoꞌampainooꞌ basinooꞌ mmaꞌ ninka oꞌnoreaing, eeꞌnoko mmaꞌ dakoꞌamiraiꞌnange daꞌ siontampai.” ");
INSERT INTO nas_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Teka Jiisuuꞌke aaꞌpuuꞌ tee, “Siperiko booꞌnukai biiꞌka booꞌnuka dakoꞌaariaing, teka daꞌ aaꞌdamaang: Bera daankieaing tee Kumponing bakaang muuꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Teketa tee Jiisuuꞌ bakaasi-nareng-koo aaꞌearako teing bakaning barevare-nupoong tee siompai nariꞌ aaꞌeariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Teketa tenkenaara nanaako namuꞌke taꞌninaꞌ piong pankaing pouꞌ teke nuaruꞌkoo daue. Teketa tee booꞌa bakaasi-nareng-koo daue taꞌdaꞌparama nanuuꞌ, teka Jiisuuꞌ teke aatui otoko. ");
INSERT INTO nas_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Teketa teinge bakaning barevare-nupoonge berora tanteaama aaꞌpauꞌ Jiisuuꞌ, “Ovoring, pakumeriai, niiꞌ enang keꞌnuruꞌmariiꞌnaang!” ");
INSERT INTO nas_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Teketa teie makuꞌurima aaꞌpuuꞌ, “Diiꞌ bakei diikaang baito okiꞌnaa. Aming-koo teeꞌ arorerimang?” Teketa deto iꞌamparara teie tee piong eeꞌnoko tee eemaaruꞌ ntong-koong akaꞌpuioꞌ bakei aaꞌnaꞌ tarorovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eeꞌnoko teing taꞌninaara niaꞌkaama aaꞌpaakoꞌ, “Aung naning aremuriiꞌ aaꞌnung piong tovange eemaaruꞌ dovange taaravaakooꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Teketa teing Jiisuuꞌninka Kadaraꞌnavete-koo tavoꞌariko kenaankarai naninkai maꞌnarie koriaarekoꞌnaankai kuvi dakoꞌdoma-ita poreta Jiisuuꞌ kuneꞌuretuꞌ. Bakei avoꞌavoroꞌka. Naning teke tankinuarupeuꞌ tenaanka-ankoi. ");
INSERT INTO nas_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Poreta aaꞌpuretuꞌ, “Jiisuuꞌ ee, dake Kumponing Bauringe niiꞌ arekeeꞌ nkomeriiꞌnaang? Aiꞌ niiꞌ toraꞌanta-koo poinge niikaang batei mmeꞌ makotuaruko?” ");
INSERT INTO nas_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Teketa eeꞌnooꞌketa duerueꞌke mmauꞌ pooroꞌnavontu meruꞌarima otorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Eeꞌnoko teinge maꞌnari orenge eentavarima Jiisuuꞌ aaꞌpauꞌ, “Dake bataꞌmerima deekoꞌ pooroꞌnavontu-koo kuung tung-koo tauraꞌmeriai.” ");
INSERT INTO nas_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Teketa Jiisuuꞌke aaꞌpuruꞌ, “Beriaing.” Tee tee tenang maꞌnari bakoarira pooroꞌnanka-koo tumpariruꞌ, eeꞌnoko tevontu ootukunavontu pemue doonko kooꞌariruꞌ nuaruꞌkoo bera keꞌnuruꞌariruꞌ teke. ");
INSERT INTO nas_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Eeꞌnoko teing pooroꞌ bauꞌaarikoꞌning mmariauꞌ. Teketa osi-aape kuaꞌparira dooreaaruꞌ tee ookara kapooꞌnanka teke nkoaruꞌning napoꞌ maꞌnarie koriaarekoꞌnaanka-koo nkoaruꞌnaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Teketa ookara nantoong temono-nupoong berouꞌ Jiisuuꞌ kuneꞌkoo, eeꞌnoko Jiisuuꞌ ooaara teing aaꞌnaꞌ eentavariruꞌ Jiisuuꞌ teketa temeng-eta biikanameng-eta tenkenuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Teketa Jiisuuꞌ bakaning ninka bakaasi-koo aaꞌearira pakoꞌarira bakanooꞌ osi masipoꞌ tavoꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Teka niiꞌninge nantoonge naning doota tee-anko tavoꞌauꞌ batanang-koo bemparioꞌ. Eeꞌnoko tenang Jiisuuꞌke teing tee tavoꞌauꞌning biikaang baito oovura aaꞌpuuꞌ tee naning doota, “Domang mankiꞌdoaukaꞌ, ee aung, dakaning orarananka tontaꞌderonsing.” ");
INSERT INTO nas_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Teeꞌ nkovuko ooaara niiꞌninge boto naunukai biiꞌka kareaama aaꞌpaakoꞌ, “Aunge bakei naninge Kumponing bauvaupaaꞌumaang.” ");
INSERT INTO nas_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Teketa Jiisuuꞌke biikaang noruꞌ noruꞌura aaꞌpuruꞌ teing, “Diiꞌ aming-koo diikaang domang-koo kuunge teeꞌ munkururarimaang? ");
INSERT INTO nas_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Arera kara masikaꞌpoaruko ooverira ning makosi deeaung tammeripeuꞌ aaꞌning-koo eeꞌ minku-koo, ‘Dakaning orarananka tontaꞌderonsing,’ niiꞌnaꞌ eeꞌ minku-koo, ‘Daaꞌdarara naniai.’? ");
INSERT INTO nas_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Teka diiꞌke iroꞌ noruꞌkoo makosi ning Tee Naning-naumpoꞌ Paning-etaing tee tauraꞌ oꞌnong anke kansiꞌkoo oꞌnoi orarananka tontaꞌkoo makosi...” Teeꞌpura tee naning doota aaꞌpuuꞌ, “Daaꞌdarara dakaang taniꞌ nkavei naniai dakanava-koo.” ");
INSERT INTO nas_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eeꞌnoko tee naning deto donkonura bakanava-koo beuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eeꞌnoko ookara nantoong karingai ooaara tee aung karang kamaankiai datavorouꞌ. Eeꞌnoko teinge Kumponing daangampauꞌ tee temuriiꞌ tauraꞌ nantoong avuruꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Eeꞌnoko teketa Jiisuuꞌke nanuma narung naning oovuuꞌ miring Maatiuꞌ, taakisi nkavaakoꞌnava-koo baꞌnanuioꞌ bakanavaro-koo. Teketa Jiisuuꞌke aaꞌpuuꞌ, “Ning siomeai.” Eeꞌnoko Maatiuꞌke deto donkonura tenang-eta deto tee siompui nanuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Teketa taamang nkovuuꞌnung-koo Jiisuuꞌ baꞌnanuuꞌ bakaning barevare-nupoong ninka eeꞌnoko nantoong mmauꞌ niiꞌning orenanka aaꞌning taakisi nkanuka porora baꞌnaniaara tee ninka nariꞌ taamanauꞌ teke Maatiuꞌ bakanava-koo. ");
INSERT INTO nas_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Eeꞌnoko teinge Boto Keperuuꞌnavitue teeꞌ ooaarira teing bakaning tee siompaakoꞌning niaꞌaarima aaꞌpauꞌ, “Diikaang pankaing aming-koo taakisi nkanuka ninka eeꞌnoko nantoong orenanka nariꞌ taamanaamaang?” ");
INSERT INTO nas_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Eeꞌnoko Jiisuuꞌke teeꞌ taaravura aaꞌpuuꞌ, “Teing nantoong tampaꞌ otoroining naninge nankaiꞌuriiꞌnaang piavoroaꞌ, teka teing siipavoromaing naing piavoromaung. ");
INSERT INTO nas_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Berira ioꞌ tee kara daari meekung-koong-koo tampaꞌ barerariaing aaꞌpumanaare, ‘Ninge tee aarumo piaa unaa-anta-poꞌnung piamoi oꞌnong, tee boontunang deeaꞌ.’ Aiꞌ ning nantoong tampenanka-anko moaꞌ. Ning orenanka-koo mouꞌnung nauaranko bereꞌariaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Napoꞌ Jooni bakaninge barevare-nupoonge porora Jiisuuꞌ niaꞌaama aaꞌpauꞌ, “Daꞌ dakaning daꞌ ninka nanirimaing arekeeꞌkoo dootuuꞌkoong aarumo siompai unkumuariaung? Eeꞌnoko niiꞌ Boto Keperuuꞌnavitu ninka unkumumarikooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Teing nantoong baraneeꞌnavitu nampeesi-koo poromaing naning nampeesinara ninka nariꞌ otoroi arekeeꞌ napoꞌ orarunsiaripeuꞌ tee nampeesinara teke otoko? Batei tee otong tee naning nampeesinara teing-eta tontaꞌaravainaꞌmung, eeꞌnoko tenang teing doong-koo unkumoariaing. ");
INSERT INTO nas_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Naninge tee baarong nerakaraꞌ urikaraꞌ ninka naroꞌka pateꞌuarupeuꞌ, aiꞌ nerakaraꞌke teraꞌ urikaraꞌ beetoꞌuko dereꞌarara oraruꞌkupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Napoꞌ nantoonge nerakaruꞌ uaininaruꞌ urikaroꞌkoo pareꞌaavarupeuꞌ. Teeꞌ nkoaako deekoꞌ tee, teroꞌ nakaꞌarako teruꞌ uaininaruꞌ dakoarapeuꞌ eeꞌnoko teroꞌ tenang oraruꞌkupeuꞌ. Teruꞌ nerakaruꞌ uaininaruꞌ nerakaroꞌkoo deekoꞌ pareꞌkoo makosi, teeꞌkoo ookeng tampaꞌ otorepeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tenang teeꞌ minkuvuma teke otoko narung pava dootuuꞌnava tanatanuka-koong narung tavoꞌarara tee-koo uroꞌkanooꞌ kinkinui eentavarama aaꞌpuuꞌ, “Nnorang bakei enang okiꞌnaruuꞌkuing. Poraiꞌnange teni-koo bireng panteꞌeko teni domamparavai.” ");
INSERT INTO nas_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Teketa Jiisuuꞌ donkonura tee ninka nariꞌ beretuꞌ eeꞌnoko teing bakaning barevare-nupoong nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Teketa tenang niiꞌnani naning manikuma kivora-ita kemareꞌka-koo tarumatearakoꞌnani tee-koo damaꞌdu pora bakaang mononopaꞌkoo kainuꞌ kompuuꞌ, eeꞌ noruꞌarara, “Bane okiꞌnooꞌ kompamira bakaang mononopaꞌkoo, ning teni taaremoainani.” ");
INSERT INTO nas_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Teketa Jiisuuꞌke bereꞌarara teni oovura aaꞌpuuꞌ, “Ani ee, daꞌ doturaravaing. Dakaang baitoi taareroinani.” Eeꞌnoko teni manikuma tenang eeꞌnang taarevouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Eeꞌnoko tenang tee Jiisuuꞌ tee naning pava dootuuꞌnava tanatanuka-koong bakanava-koo koinura nantoonge patuaiarima, biromparima naampavaako oovuruꞌ bakei karingai. ");
INSERT INTO nas_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Eeꞌnoko teie aaꞌpuruꞌ teing, “Oko sirariai, ani neraiꞌnaꞌ booaꞌ, teka tamung aatumaang.” Eeꞌnoko teinge benkempauꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Teketa teing nantoong karinga damaꞌdu etuvurira teni neraiꞌnaꞌ otouꞌnavaro-koo tumparara teie bakaang bireng kompui deto iꞌampuko teni daaꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Eeꞌnoko tee-koong aung-koong doorenang tee ootukunairu-koo beremparuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Eeꞌnoko teketa nanuko Jiisuuꞌ kenaankai naninkai kaputuꞌkai bokurema siompuretuꞌ aaꞌpurema, “Pankaing, Deevitaꞌ bakanaving-koong, Piaamereaing neeꞌ!” ");
INSERT INTO nas_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Eeꞌnoko teketa niiꞌnava-koo tumparako tenaanka kaputuꞌka tee-anko poretuꞌ, eeꞌnoko Jiisuuꞌke niaꞌurema aaꞌpuretuꞌ tenaanka, “Deeꞌke ee ning makosi masikaꞌantameresi otong ninge piaroresinaꞌ nkorampeeꞌnaang?” Makuꞌurema aaꞌpuretuꞌ, “Eeꞌ, Ovoring.” ");
INSERT INTO nas_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eeꞌnoko tenang teie beekaang duta kompurema aaꞌpuretuꞌ, “Deekaang baito-koo makosinaꞌ nkoaravaing deeꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eeꞌnoko beekaang duta tenang bantouꞌ. Eeꞌnoko aaꞌnaꞌ orokovuretuꞌ aaꞌpurema, “Teka aung naninge noruꞌuaukaꞌ, makempereaing.” ");
INSERT INTO nas_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Teka tenaankai tee bereta Jiisuuꞌkoong doorenang bereng-antavuretuꞌ ootukunairu-koo temeensiꞌkooning-koo. ");
INSERT INTO nas_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Teketa napoꞌ tenkenaako niiꞌnung naning maꞌnaange korivuko karoarukoꞌnung Jiisuuꞌanko tavoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eeꞌnoko tenang tee maꞌnaang bataꞌuioꞌ tee karoarukoꞌnung karouꞌ, eeꞌnoko nantoong karingai ooaara taꞌninaara aaꞌpauꞌ, “Kapooꞌ eeꞌ oroꞌ ooampiaruuꞌnung teroita niiꞌkoo Isireeli-nupoong-koo meuꞌka.” ");
INSERT INTO nas_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Teka teinge boto keperuuꞌnavitue aaꞌpauꞌ, “Tee aaꞌ maꞌnari biikaang pankaing bakaang iriꞌke teeꞌ bataꞌurimang maꞌnari.” ");
INSERT INTO nas_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jiisuuꞌ tee teeꞌ nariꞌ osinankai pankenge eeꞌnoko okiꞌnarekaꞌke nanuuꞌ nau-antavurima biikaning pava dootuuꞌnanka-koo daankiarama, aaꞌnoma, tampara doorenang daankivuma tee muuꞌ paninung-koong eeꞌnoko siipananka amutemuriiꞌ taare-antavurima. ");
INSERT INTO nas_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eeꞌnoko tenang teie teing nantoong karinga oovurira bakaang domang aaꞌnaꞌ piaavouꞌ teing ereananuka eeꞌnoko aruaruꞌnuka deempariri otorokoꞌnung-koo, teing-pinaꞌ sipisipiꞌ tanatanungropanuka-pinaꞌ oroꞌpariko. ");
INSERT INTO nas_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Teketa teing bakaning barevare-nupoong aaꞌpurikoꞌ, “Sinang tee bakei aaꞌnaꞌ meuraꞌpuing, teka kavuꞌnupoong okiꞌning. ");
INSERT INTO nas_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Teeꞌkoo kunsirariaing sinang kavuꞌkoo Ovoringe kavuꞌnupoong botovuriainaꞌ tee-koo bakaang mintoong-koo.” ");
INSERT INTO nas_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jiisuuꞌke teing nanaiꞌketa kenaankara bakaning barevare-nupoong tee-anko bokuvurira tauraꞌ avuruꞌ makosi-antavurima maꞌnari oreng bataꞌkoong eeꞌnoko napoꞌ siipananka amutemuriiꞌ taare-anta-koonge. ");
INSERT INTO nas_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aing teing mirinanka teing nanaiꞌketa kenaankara kara okovuri nkanuka biikaning: Tutunaꞌnung Saimoniꞌ, niiꞌnooꞌ Piita, eeꞌnoko teie baaraꞌmaꞌnung Aanduruꞌ; napoꞌ Jeemisi, tee Siebedi bauring; eeꞌnoko baaraꞌmaꞌnung tee Jooni. ");
INSERT INTO nas_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Napoꞌ narung Pilipiꞌ, eeꞌnoko narung Baatolomiuꞌ, napoꞌ niiꞌnung Toomasi eeꞌnoko Maatiuꞌ, tee eeꞌnung taakisi nkanuka-koong; napoꞌ niiꞌnung Jeemisi, tee Alopeasi bauring; eeꞌnoko narung Taꞌdeasi. ");
INSERT INTO nas_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Napoꞌ niiꞌnung Saimoniꞌ, Juꞌ biiꞌka donkong-koo pia-navitu-koong; eeꞌnoko narung Judasi Kerioꞌnara, tee tooka kompui Jiisuuꞌ tauraꞌpuuꞌnung bakaning kare-nupoong-koo. ");
INSERT INTO nas_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Teing aing nanaiꞌketa kenaankara Jiisuuꞌke botovuruꞌ kara aung ninka tautauvurima, “Juꞌdeeaing biikanooꞌ beriaukaꞌ, napoꞌ Sameriaꞌkooning-koo osi-koo beriaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Teka teing Isireeli-nupoong sipisipiꞌpinaꞌ pooariruꞌning biikanairu-koo beriai. ");
INSERT INTO nas_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Berira kara aung anaare daankieriai, ‘Tee muuꞌ paninung tee enang dueꞌ poing!’ ");
INSERT INTO nas_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Eeꞌnoko siipa-nupoong taare-antaverereriai. Napoꞌ booꞌnuka domampereriai. Oramuuꞌpoꞌnupoong kiiroraaꞌantaverereriai. Eeꞌnoko maꞌnari bataꞌereriai. Aung amuriiꞌ iriꞌ tamung arompiring eeꞌnoko diiꞌke napoꞌ teeꞌ tamung pakuereriai tee ninka. ");
INSERT INTO nas_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Aing aaꞌning kapooꞌnanka nkaveriaukaꞌ: mooniꞌnanka kereka-koo kuunga, miku taamang-poꞌnung, niiꞌnooꞌ mononopaꞌ paripariꞌ, eeꞌnoko boonamante˜, napoꞌ donsiꞌ nkaveriaukaꞌ, aiꞌ tee tee pakuereriko diiꞌ napoꞌ teinge pakuraariaing. ");
INSERT INTO nas_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aremono-koo diiꞌ beriainamono-koo pankamono-koo deekoꞌ niiꞌnooꞌ osi okiꞌnamono-koo deekoꞌ naning makosi besiꞌeriaing teka, eeꞌnoko tee ninka otoriai bakanava-koo bera tenkeniriainooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tenang teva-koo tuntarima mooa-antaveriai tee naning. ");
INSERT INTO nas_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Eeꞌnoko teie tevaꞌkoonge nkaang kara taara-koo arooꞌuaing deekoꞌ tee mooa teke teva-koo otoaing tee ninka, eeꞌnoko arooꞌuaukaꞌnung deekoꞌ tee napoꞌ diikaang mooa diiꞌkoo napoꞌ toroaravaing makosi. ");
INSERT INTO nas_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Naninge onkeonkeꞌduriaukaꞌnung deekoꞌ eeꞌnoko diikaang kara taaravuaukaꞌ teketa teva-ita, niiꞌnooꞌ osi-eta, tenkenirima temono-koong daꞌmong tankaveriaing diikaang peꞌnaaꞌketa temono Kumponing-koo maarekusiꞌnamono taaꞌniꞌantaveri. ");
INSERT INTO nas_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Masikaꞌ naurampimang ninge, teꞌmung simpeꞌ nkonaꞌmung kiimata temono-nupoong biikaang koontoꞌ bakei dau basi deemparavaing teing-koo temuꞌnupoong oreng-koo biikaang osi Kumponinge paroꞌuuꞌning-koo, aaꞌnoko Sodom eeꞌnoko Komoraꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Aing ee, ninge tee diiꞌ sipisipiꞌnanka-pinaꞌ botorampimang nkaunanka-koo meuꞌke botorampipeuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Teeꞌkoo dontaꞌperi naniriai, aiꞌ diiꞌ teinge nantoonge koompaaraꞌnavitu-koo tavoꞌdaariaing, niiꞌnooꞌ muraꞌdaariainge dootuuꞌarimanairu-koo. ");
INSERT INTO nas_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Diiꞌ teing ning-koo daiꞌdaarira donkong-antaraariaing ovoꞌmaꞌnuka-koo eeꞌnoko dauraronanka-koo uroꞌkanooꞌ. Teeꞌ nkoaravaing diiꞌ nkaang kara siraꞌkoo miruꞌniiꞌnuka deentariko, teing-koo eeꞌnoko ookara Juꞌdeeaing-koo. ");
INSERT INTO nas_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Teka teinge teeꞌ tuutunang˜koo beꞌantaraariko kapooꞌ minkueriaining eeꞌnoko minkueriainaꞌ noruꞌerima avitoitoi noruꞌ mankiꞌdoriaukaꞌ. Aiꞌ tenang eeꞌnang niaꞌdaariko Kumponinge naururiaing kapooꞌ minkueriaining. ");
INSERT INTO nas_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Diiꞌ diiꞌka tee kareriaukaꞌnung, teka tee Tanuaang Meekung Diuma-itaing diiꞌkoo kuunge karoaing. ");
INSERT INTO nas_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Napoꞌ aaꞌnoainge: bataatai tooka kompui baaraꞌmaꞌnung tauraꞌpuaing dupisiꞌaavaꞌnaang, eeꞌnoko baumai bauring teeꞌ nariꞌ nkovuai. Napoꞌ biurukaaꞌke biumaraang turampaarima dupisiꞌaari-ainge. ");
INSERT INTO nas_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Diiꞌ teing ookara nantoonge munteꞌdaariaining ning nkaang miring-poꞌnupoong deentariko, eeꞌnoko naning purimparioꞌ bera asiranaꞌmung basiaravaing deekoꞌ domamparavaing. ");
INSERT INTO nas_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tenang diiꞌ mankiꞌantaraariko niiꞌnamono-koo teketa niiꞌnooꞌ napoꞌ kooꞌdariai. Masikaꞌ naurampimang ninge, diiꞌke teing osinanka Isireeli-nupoong otoromaing nanirima operiaruko tee ning Tee Naning-naumpoꞌ Paning-etaing moaing. ");
INSERT INTO nas_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tee naning barevare-nung bakaang nau-anta-koo dau basi deeaꞌ. Napoꞌ teie botovotonaaꞌ bakaang pankaing-koo dau basi deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Teka tee tee naning barevare-nung bakaang nau-anta-pinaꞌ nariꞌ nkoaavaing. Napoꞌ tee botovotonaaꞌ teeꞌ nariꞌ tee-pinaꞌ bakaang pankaing-pinaꞌ nkoaavainge. Ning tee nkanavitu-koo boreꞌ Kopeu tammaama pooreꞌmaamaung deemarako diiꞌ teing nkanavitu baruꞌ aaꞌnooꞌ pooreꞌdaariaining. ");
INSERT INTO nas_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Teing-koo aroreriaꞌ otoriai, aiꞌ ookara kapooꞌnanka nopaꞌari otoining teing siraꞌparavaining. Eeꞌnoko ookara kara bakuꞌniiꞌ nantoonge ookarai taaravaavainge. ");
INSERT INTO nas_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kapooꞌ ninge mutaananooꞌke naurampimaing doonaaꞌ nau-antavereriaing. Kapooꞌ iaantampiko taaraverira deto karerima daankieriaing.” ");
INSERT INTO nas_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Aroreriaukaꞌ teing-koo nkaang kara avoꞌaama diikaang mono dupisiꞌaavaining-koo teka diikaang tanuaang dupisiꞌaavarupeuꞌ. Teka Kumponing-koo aroreriai aaꞌnung-koo: baitoveriaruko mono eeꞌnoko tanuaang ookeng duaꞌureai mosianung-koo. ");
INSERT INTO nas_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Noruꞌeri otong nantoonge keura barenning okiꞌnarekaꞌ baaveaamaung nau mooniꞌnu-koo, teka bane okiꞌninge, Diumai tauraꞌpuaruko kansiꞌkoo teing-koo nau duaꞌaravarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Napoꞌ teeꞌke ookara daponanka diikaang boreꞌkoo tee deeruniiꞌnanka otorong. ");
INSERT INTO nas_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Teeꞌkoo diiꞌ aroreriaukaꞌ, aiꞌ diiꞌ teing baruꞌ deto basinooꞌ noruꞌduri otong bareng okiꞌnarekaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ookara teing nantoong-koo uroꞌkanooꞌke ning arooꞌmai otoing siraꞌpariko ninge teeꞌke tee Mmaꞌkoo uroꞌkanooꞌke teke paning-koo nkaning tamparampaing. ");
INSERT INTO nas_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Teka baa tee naning ning penkemuaing nantoong-koo uroꞌkanooꞌke ninge tee teeꞌ penkempampaing Mmaꞌkoo uroꞌkanooꞌke teke paning-koo.” ");
INSERT INTO nas_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Eeꞌ noruꞌeriaukaꞌ ning kansiꞌkoo mouꞌnung turanturang bake-anta-koo. Turanturang bake-anta-koo moaꞌ, teka siivenkeꞌ nkoaraaꞌnaang mouꞌnung. Aaꞌnoaing, narionge ning masikaꞌantamaavai eeꞌnoko niiꞌnarionge masikaꞌantamaavaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eeꞌnoko teeꞌ nkoarama naning bauma-koo turaniꞌ deemparavai eeꞌnoko baurang napoꞌ bauko-koo turaniꞌ deempaaravaing, eeꞌnoko napoꞌ baampuruꞌnaang bakaampo-koo. ");
INSERT INTO nas_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Naning bakaning kare-nupoong teing eeꞌning bakanava-kooning. ");
INSERT INTO nas_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Eeꞌnoko baa tee naning baumararing aaꞌnaꞌ piaavuremaung ning divuꞌmui ning siong-koo makotuaꞌ. Eeꞌnoko napoꞌ baa tee naning baurukaaꞌ aaꞌnaꞌ piaavurimaung ning divuꞌmui tee tee ning nkaang naning deempari otoꞌkoo makotuaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Eeꞌnoko baa tee naning ning siong-koo baike aaꞌbarataꞌkoo˜ kuneꞌkoo tauraꞌparavarupeuꞌnung tee makotuaꞌ nkaang naning deempari otoꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Baa tee naning bakaang domaang baka tarearamaung tee bakaang domaang tee paaꞌaravaing, eeꞌnoko baa tee naning ning siomuma bakaang domaang duaꞌuaing tee teie napoꞌ daaꞌuaing tee domaang. ");
INSERT INTO nas_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Baa tee naning diiꞌ onkeonkeꞌduriaing teie tee ning onkeonkeꞌmuaing, eeꞌnoko baa tee naning ning onkeonkeꞌmuainge teie tee Naning onkeonkeꞌuaing ning botomuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Eeꞌnoko baa tee naning tee Kumponing bakaang nakaronung onkeonkeꞌuaing tee Kumponing bakaang deemparako teie tee bakaang nakaronung-pinaꞌ nariꞌ Kumponinge mooꞌuaing. Eeꞌnoko baa tee naning tee naning koontoꞌ onkeonkeꞌuaing koontoꞌ deemparako, teie tee tee-pinaꞌ koontoꞌpinaꞌ nariꞌ mooꞌ nkavuaing. ");
INSERT INTO nas_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eeꞌnoko ninge masikaꞌ naurampimang, baa tee naning aing okiꞌnarekaꞌkoo narung ntonaruꞌ avuaing kaꞌmatonaruꞌ tee eeꞌnung nkaang barevare-nung deemparako teie tee koontoꞌ divuꞌuaukaꞌ tee bakaang mooꞌ; nkavuaing.” ");
INSERT INTO nas_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Teketa Jiisuuꞌke teing bakaning nanaiꞌketa kenaanka barevare-nupoong tautauvurikotaaꞌ bakearako osinanka-koo Kaaleliꞌnameng-kooning-koo dueꞌke daankinamparama nau-antavuriiꞌnaang beuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Eeꞌnoko Jooni Minkinara kiimata-navaꞌkoo otoi teing kapooꞌnanka Karistooꞌke nkovukoꞌning taaravura teie kenaankara bakaning barevare-nupoong-koo botovuretuꞌ tee Jiisuuꞌanko tee niaꞌurema aaꞌpureeꞌnaang, “Daꞌ ee tee tavoꞌkuaing-koong, aiꞌ mmeꞌ niiꞌnung nempampiainge?” ");
INSERT INTO nas_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Eeꞌnoko teie aaꞌpuretuꞌnung tenaanka, “Bereta nauereai tee Jooni Minkinara kapooꞌ deeꞌke ooveresining eeꞌnoko taaraveresining; ");
INSERT INTO nas_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aaꞌnoining: kaputuꞌnuka banteaama ookai, kauꞌ deꞌdoonuka nanai, oramuuꞌpoꞌnupoong kiiroraaꞌariri eeꞌnoko kipaunuka taareai, booꞌnuka daaꞌariri, ataꞌoinku tampara doorenang daankianko taaravai. ");
INSERT INTO nas_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Eeꞌnoko biraankearavaing tee naning ning-koo dateꞌpari baitoaravaing, eeꞌnoko nkaang nko-nko akoveeꞌ mareꞌuaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Teketa Jooni Minkinara bakanaanka kara-nkara toroareko Jiisuuꞌke kara-nau tutumpuruꞌ nantoong karinga Jooni minkuvuma, eeꞌnoko aaꞌpuuꞌ, “Diiꞌke aremuriiꞌ naning doore taaraverira meeꞌboraꞌ sirakamaaꞌkoo ooveriiꞌnaang berikoꞌ karikaꞌduri? Naning tunsi-paaka onou avitoitoi eeari otoꞌ oo-koo teꞌ beriarupeuꞌ, apeꞌ? ");
INSERT INTO nas_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Napoꞌ naning nepuꞌarama kirokaiari otomaung oo-koo beriaꞌ, apeꞌ aing? Aiꞌ teing nantoong baarong tampenge nopaꞌarimaing dauraronanka biikaning-koo pava-koo oovereripeuꞌ, meeꞌboraꞌ sirakamaaꞌkoo deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Teka arekeeꞌ masikaꞌ oroꞌ oo-koo berikoꞌ diiꞌ, aiꞌ narung nakaronara? Eeꞌ, tee bakei nakaronara masikung Kumponing-etaing emuꞌ ninge naurampimang diiꞌ. Tee tee aaꞌnung ookara nakaronuka-koo dau basie tee. ");
INSERT INTO nas_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aiꞌ aung eeꞌnung miruꞌui Daari Meekung-koo eeꞌ minkuari otong Kumponinge bauring Karistooꞌ temuꞌ nauvuuꞌnooꞌka aaꞌpuma, ‘Ee aung, ninge botoampaing nkaang kara-nka daꞌkoo uroꞌke tee taung maamu-antareruaing uroitaaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Masikaꞌ naurampimang diiꞌ, Jooni tee ookara nantoong tee-koo uroꞌke pontoꞌariruꞌning-koo tee deto basi pankaing, teka ninge eeꞌ naurampimang, enang-eta deto baata teing ninge tare-koo arooꞌariaining, bane Kumponing bakaang muuꞌkoo miring okiꞌnarekaꞌ, teinge tee Jooni puruꞌai otoroaing. ");
INSERT INTO nas_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Teketa Jooni Minkinarai daankinang tutumpuuꞌnooꞌketa bera doong eꞌmunung-koo basi-nooꞌkoo tee paninung muuꞌ tee iriꞌoi daaꞌaramang, eeꞌnoko teing teꞌ muuꞌkoo kuung poromaing teing iriꞌoroi tee-koo pinkaꞌarimaing. ");
INSERT INTO nas_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aiꞌ tee tee uripoꞌketa nakaro-nupoonge eeꞌnoko Moosesi-nung botoi paninung muuꞌ tavoꞌaravainaꞌ tarampeearima˜ minkuauꞌ bera Jooni bakaang batei-koo basi. ");
INSERT INTO nas_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Diiꞌke masika-antaveriaing deekoꞌ tee Jooni tee eeꞌnung Eliasi miruꞌari otong Kumponinge uroꞌke pooꞌnaang tampuuꞌnung teinge nakaro-nupoonge minkuauꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Diiꞌ punkang-poꞌnupoong deekoꞌ enang taaraveriai!” ");
INSERT INTO nas_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Teketa Jiisuuꞌke napoꞌ aaꞌpuuꞌ, “Diiꞌ nantoong emuꞌnavarang ninge aminge pa miruꞌdampipeuꞌ? Diiꞌ teing toireꞌpinaꞌ oroꞌnanka baaveroma baꞌnaniai turampeemaing biiꞌka aaꞌpeema, ");
INSERT INTO nas_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kovi puunterorompiko konterorima neekarariarukooꞌ. Aiꞌnontuꞌmariko diiꞌ birontariarukooꞌ.’ Teeꞌ nariꞌ oorarampimaung neeꞌ tokomererimaing. ");
INSERT INTO nas_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jooni Minkinara poraiꞌnange taamang tovang uaini kerempuko konterorima aaꞌperikoꞌ, ‘Tee maꞌnaang-poꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Eeꞌnoko ning Tee Naning-naumpoꞌ Paning-etaing mora taamanama tuaamarako napoꞌ konterorima aaꞌmerimaung, ‘Aung ooveriai taamang eeꞌnoko uaini nai bauko, taakisi nkanuka eeꞌnoko niiꞌning orenge biiꞌmaikoꞌke!’ Teka Kumponinge avutevuꞌmuresi botomuresinaꞌ sinampuko diiꞌke bakaang matau tasiꞌperiaing.” ");
INSERT INTO nas_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Teketa tenang Jiisuuꞌke teing osi pankenanka taaꞌniꞌantananka nkovuko ooauꞌning daankiarama turampuruꞌnung bereꞌariaruko oovurira. ");
INSERT INTO nas_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Aaꞌpuruꞌ, “Bakaꞌe piaaruꞌnuka diiꞌ Korasin-nupoong, toraꞌkiriaining. Piaaruꞌnuka diiꞌ Besaida-nupoong, diiꞌ toraꞌkiriaininge, aiꞌ diiꞌ teing kapooꞌnanka iriꞌpoꞌning taꞌnimpaariiꞌnanka diiꞌkoo nkoaruꞌning ooverima bereꞌdariaruuꞌ. Teinge Juꞌdeeaing Saidoniꞌnupoong eeꞌnoko Taiaꞌnupoonge ooaara dei namuꞌke bereꞌaripeuꞌ sipunge pooꞌarima mononopaꞌ orarunsi-koong kurumparipeuꞌ bereꞌariruꞌnung-koo taaꞌniꞌantavarima. ");
INSERT INTO nas_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Teka aaꞌdampimang, teꞌmung Kumponinge nantoong simpeꞌurima kiimatavuriainaꞌmung diiꞌke dau basinooꞌ toraꞌperiaing Taiaꞌ naankai Saidoniꞌ toraꞌpureainooꞌketa. ");
INSERT INTO nas_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eeꞌnoko diiꞌ Kapaneumeꞌnupoong deto paning-koo basirariaining-pinaꞌ daang noruꞌdarimaing. Diiꞌ doonko mosianung-koo sing-antaruriaining. Teing taaꞌniꞌantananka diiꞌkoo nkoantuꞌning Sodom-namono-koo nkoantuꞌnung dei temono tee teeꞌ nariꞌ otopeuꞌ eꞌmung-koo basinooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Teka ninge eeꞌ naurampimang teꞌmung simpeꞌ nkonaꞌmung kiimata bakei aaꞌnaꞌ toraꞌperiaining diiꞌ, teing-koo temuꞌnupoong oreng-koo dau basinooꞌ, biikaang osi Sodom Kumponinge paroꞌuuꞌning-koo.” ");
INSERT INTO nas_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tenang eeꞌnang Jiisuuꞌke aaꞌpuuꞌ, “Mmaꞌ ee, tampara tantamang daꞌ Ovoring paning-koong eeꞌnoko kansiꞌkoonge, dake aaꞌnouꞌnung-koo: Dake tee doorenang tampara bakuꞌeuꞌnung-koo teing-koo matau-poꞌnupoong eeꞌnoko noruꞌpoꞌnupoong tamparimaing-koo eeꞌnoko siraꞌpeuꞌ teing-koo tootoia-pinaꞌ otoromaing-koo. ");
INSERT INTO nas_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Teing nantoong piaaveri piarouꞌnaꞌ teeꞌ. Eeꞌ, Mmaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eeꞌnoko nantoong karavurima aaꞌpuruꞌ, “Ookutunung kapooꞌnanka tee Mmaꞌke pareꞌmuuꞌnung, eeꞌnoko naning otoaꞌ ning Tee Bauring noruꞌmui otoing, Mmaꞌke deekoꞌ noruꞌmui otong. Eeꞌnoko napoꞌ naning otoaꞌ Mmaꞌ noruꞌui otoing, teka ninge Bauringe deekoꞌ noruꞌansi oꞌnong. Eeꞌnoko nantoong teing naing ninge Bauringe miruꞌarampaining-koo oroꞌantavanko noruꞌaavaing tee. ");
INSERT INTO nas_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ning-koo poriai diiꞌ ookara iriꞌ oꞌdarima mankiꞌdorimaing avutevuꞌ matau siomperima poreꞌdorimaing, eeꞌnoko ninge uaa-antarampiaing diikaang tanuaang. ");
INSERT INTO nas_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ning nkaang tare-koo kuung porira ning-koo barerariai, aiꞌ ning tee banainge otoꞌ, eeꞌnoko domang boonko noruꞌmari otoꞌke. Eeꞌnoko ning-koo tee diikaang tanuaang uaa-anta komperiaing. ");
INSERT INTO nas_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ninge tare-koo diiꞌ arooꞌdariri dei mankiꞌdoriaꞌ kuaaꞌdoripeuꞌ ning siomeritaaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Teketa dueꞌka niiꞌnaꞌmung Doong Uaanaꞌmung Jiisuuꞌ uiteꞌnaue˜ tankinuko bakaninge barevare-nupoonge tee siompaama peeravorora niiꞌning biiꞌdaꞌpauꞌnung uiteꞌkoong sinang-koo untuꞌnooꞌ, eeꞌnoko naakoꞌpaama maaꞌauꞌ tamung tankinaama, Juꞌnupoong biikaang aarumo-koo tauraꞌpari otoinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Teka teinge Boto Keperuuꞌnavitue˜ teeꞌ ooaarira aaꞌpauꞌ tee Jiisuuꞌ, “Ooveko, dakaning barevare-nupoong mintoomparimaang boto totoꞌpaitaaꞌ Doong Uaanaꞌmung-koong.” ");
INSERT INTO nas_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Diiꞌke aming-koo teeꞌ tuumpimerimaang? Tampaꞌ noruꞌeri otong tee kapooꞌ Deevitaꞌke nkovuuꞌnung tenang tee peeravora, tee Deevitaꞌ eeꞌnoko teing nariꞌ otorokoꞌning ninka. ");
INSERT INTO nas_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kumponing bakanava-koo Deevitaꞌ koinura nkavura naiauꞌ tee taamang meekung, niiꞌninge nai-koo tauraꞌparavaꞌ, teka piristiꞌnuka nainge deekoꞌ nai-koo makosi. Eeꞌnoko teie Deevitaꞌke teing nariꞌ otorokoꞌning avurioꞌ boto totoꞌkoo tuumpiaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Napoꞌ ee ampankeenaꞌdoring Moosesi-nung botoi tampuioꞌ teing piristiꞌnuka dootuuꞌnava pankava-koo pareka nkoaamaung bane tee Doong Uaanaꞌmung-koong boto otoi otoko, eeꞌnoko tuumpi-koo otoroaꞌ dootuuꞌnava pankava bakaang mintoong dau basi deempari otoko. ");
INSERT INTO nas_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Teka ninge eeꞌ naurampimang, naning dootuuꞌnava pankava-koo dau basi aung anke otong. ");
INSERT INTO nas_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aung anaare kara Kumponinge aaꞌpuuꞌnung, ‘Ninge tee aarumo piaa unaa-anta-poꞌnung piamoi oꞌnong, tee boontunang deeaꞌ.’ Tenaare tasiꞌperi noruꞌering deekoꞌ diiꞌke ning tee tuumpiropa napoꞌ tuumpimeriarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aiꞌ tee ning Tee Naning-naumpoꞌ Paning-etaing tee Ovoring Doong Uaanaꞌmung-koo eeꞌnoko tauraꞌ avorompeuꞌ nantoonge kapooꞌ nko-koo.” ");
INSERT INTO nas_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Eeꞌnoko teketa tenkenura biikaang pava dootuuꞌnava-koo tumparara Jiisuuꞌke nau-antavurikoꞌ narung naning teke otoko bireng duuaiꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eeꞌnoko teinge Boto Keperuuꞌnavitue turang-koong taung besiꞌaama niaꞌaama aaꞌpauꞌ tee, “Arekeeꞌ, Doong Uaanaꞌmung ee taare-anta nko-koo tauraꞌpari otong?” ");
INSERT INTO nas_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jiisuuꞌke aaꞌpuruꞌ teing, “Diiꞌkoo niiꞌnung sipisipiꞌnavoroꞌ otoꞌevuing eeꞌnoko tevoroꞌ dinkung-koo duaꞌarapeuꞌ Doong Uaanaꞌmung, eeꞌnoko teie tevoroꞌ teꞌmung kompura ee taaruꞌuarupeuꞌ? Tee aaꞌ taaruꞌupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Eeꞌnoko naning ee sipisipiꞌkoo dau basi deeaꞌ? Tee aaꞌ naning tee sipisipiꞌkoo dau basi. Teeꞌkoo botoi tauraꞌmurimaung Doong Uaanaꞌmung naning tampaꞌ nko-nko.” ");
INSERT INTO nas_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Teketa Jiisuuꞌke aaꞌpuuꞌ tee naning, “Bireng tovoroꞌdaravai.” Eeꞌnoko tovoroꞌarara koontoꞌ bakei tamparuꞌkuuꞌ niiꞌnaang-pinaꞌ baꞌmaikoꞌnaang-pinaꞌ nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Teka teing Boto Keperuuꞌnavitu-koo-nupoong teketa siarira mumunsiariruꞌ Jiisuuꞌ dupisiꞌaavainaꞌ minkuaama. ");
INSERT INTO nas_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Teinge tavaavaꞌnaang mumunsiariko noruꞌuitaaꞌ Jiisuuꞌ teketa tenkenuko nantoong karingai siompauꞌ tee, eeꞌnoko teie taare-antavuruꞌ teing ookara biikaning siipananka. ");
INSERT INTO nas_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Eeꞌnoko teie orokovuruꞌ teing tee Kumponing bauring siraꞌpaavarooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Teeꞌ nkoarara tee dupe-antavuuꞌ tee kara Kumponinge tero tee nakaronung Aisaiaꞌ karantavuma˜ minkuvuuꞌnung aaꞌpuuꞌnooꞌka, ");
INSERT INTO nas_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Aung tee nkaang muuꞌ tanatanara ninge miruꞌantuꞌnung. Tee eeꞌnung ninge piaavamaung, eeꞌnoko ning dotumaramaung tee-koo. Ninge tee nkaang Tanuaang tee-koo sipampaing eeꞌnoko teie teing Juꞌdeeaing koontoꞌnaꞌ aarumo nau-antavuriaing. ");
INSERT INTO nas_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tee tee nantoong ninka tatariꞌeeaukaꞌ, napoꞌ bokuaukaꞌ. Naninge taung pankenanka-koo bokuko bakaang aurong taaravuaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nantoong aruaruꞌnuka doonko mmeꞌuriaukaꞌ. Noruꞌ okiꞌnung sirivaaꞌuaukaꞌ, bera tee koontoꞌnung aarumo iriꞌantavui dau basi-antavuainooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Eeꞌnoko tee-koo bakaang miring-koo ookara nantoonge noruꞌ sipaavai.” ");
INSERT INTO nas_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Teketa tee-anko naning maꞌnaang-poꞌnung kaputuꞌ karoaung tavoꞌauꞌ. Eeꞌnoko Jiisuuꞌke taare-antavuioꞌ karouꞌ, duta bantouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Eeꞌnoko ookara nantoonge taꞌninaara aaꞌpauꞌ, “Aung pa tee Deevitaꞌ bauring, Kumponinge Pakoꞌpariꞌniiꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Teka tenang teinge Boto Keperuuꞌnavitue teeꞌ taaravaara aaꞌpauꞌ, “Tee aaꞌ Kopeu bakaang purintoꞌke maꞌnari bataꞌurimaung, tee maꞌnari biikaang pankaing.” ");
INSERT INTO nas_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Eeꞌnoko Jiisuuꞌke biikaang onou tasiꞌpura aaꞌpuruꞌ teing, “Ookara muuꞌnanka biiꞌka siivenkeꞌarimaing kare-nupoonge pini daakoꞌaarimaung. Eeꞌnoko napoꞌ tee puataꞌ niiꞌnooꞌ osi siivenkeꞌeemaing teie duaꞌarimainge. ");
INSERT INTO nas_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eeꞌnoko napoꞌ teie Sietaniꞌke bakanamuiaang bataꞌurira tee tee baka siivenkeꞌarapeuꞌ eeꞌnoko teeꞌkoo arekeeꞌ bakaang muuꞌ donkonui nariꞌ otopeuꞌ? ");
INSERT INTO nas_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eeꞌnoko ooveriko diiꞌ siontaarimaing-koo niiꞌning maꞌnari bataꞌaarimaing otorong. Eeꞌnoko ninge Kopeu ninka maꞌnari bataꞌaramaung tamperima deekoꞌ teing siontaarimainge baa ninka bataꞌaarimaung tamperikooꞌ? Arekeeꞌ, teing napoꞌ ning-pinaꞌ nariꞌ Kopeu bakaang purintoꞌke bataꞌaarimaing tamperererimaang ee? Teeꞌ taararaarira teinge tuutunantaariaing diiꞌ, aiꞌ teing teeꞌke niꞌninka nariꞌ nkomarimaing. ");
INSERT INTO nas_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Teka Kumponing bakaang Tanuaang Meekunge maꞌnari bataꞌaramaung deekoꞌ tee muuꞌ Kumponing bakaang tee diiꞌanko taaꞌniꞌpoi poing. ");
INSERT INTO nas_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aiꞌ naninge naning purintoꞌ bakanava-koo arekeeꞌ koinura ookara kapooꞌ bakaning nkavupeuꞌ tee naning purintoꞌ tutung daiꞌuaꞌ? Daiꞌura deekoꞌ pariꞌupeuꞌ bakanava-kooning kapooꞌnanka. ");
INSERT INTO nas_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Eeꞌnoko diiꞌke tasiꞌmeriarura diiꞌ teing ning-koo kare-nupoong, eeꞌnoko diiꞌ niꞌninka nariꞌ nantoong oosiarampiarura diiꞌ purarenkaꞌ nkonuka Kumponing bakaang muuꞌketa. ");
INSERT INTO nas_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Teeꞌkoo eeꞌ naurampimang, tee aung diikaang orakaꞌnko tontaꞌaravaukaꞌnung, aiꞌ ookara orakaꞌ nkonanka eeꞌnoko orakaꞌ minkunanka nantoong biikaning teing tontaꞌaravaining, teka naning Tanuaang Meekung Kopeu dovang tampuma orakaꞌ minkuvumaung tontaꞌanta kompuaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Eeꞌnoko baa tee naning tee ning Tee Naning-naumpoꞌ Paning-etaing orakaꞌ minkumuaing tee Kumponinge tontaꞌanta-koo makosi. Teka tee naning Tanuaang Meekung mintoomparako orakaꞌ minkuvuaing tee tee tontaꞌanta-koo makosi deeaꞌ, enang anke aung batei-koo napoꞌ damaꞌke damaꞌnung batei-koo. ");
INSERT INTO nas_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sinang tampara tamperiaing deekoꞌ tevari koiꞌnavari teeꞌ nariꞌ tampavari tamperiaing. Sinang orara deemparako deekoꞌ tee koiꞌ tevari oravari tang-koo makosi, aiꞌ ookara koiꞌnanka tee sinang-koo tasiꞌparampimaung. Enang arekeeꞌkoo kapooꞌ tampeng nkoanko Kopeu-etaing tamperimaunge? ");
INSERT INTO nas_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Diiꞌ borukoporonuka doparopa-poꞌning, diiꞌ teing oreng masikeng siraꞌdarimaing kapooꞌ koontoꞌnaꞌ minku paaꞌerima! Aiꞌ kapooꞌ tee domang-koo otoing piamparako karange minkuerimaung. ");
INSERT INTO nas_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Teie naning tamparai tee teieta tampara domang-koong koreꞌnang-eta tampara tavoꞌantavumaung eeꞌnoko teie naning orarai tee teieta orarananka domang-koong koreꞌnang-eta orara tavoꞌantavumaung. Eeꞌnoko naning orarai orananka kapooꞌnanka tavoꞌantavukooꞌ bakaang domang-koo oreng koreꞌnang otoꞌevumaing-eta. ");
INSERT INTO nas_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Teka ninge eeꞌ naurampimang, teꞌmung simpeꞌ nkonaꞌmung tee ookara karananka anutua minkuerimaing siraꞌderuriko makuꞌeriaing. ");
INSERT INTO nas_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Teie eeꞌnunge diikaang karanankai simpeꞌduriaining diiꞌ koontoꞌnuka niiꞌnooꞌ koontoꞌnuka deeaing tanturiaing deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Teketa tenang teinge Boto Keperuuꞌnavitue eeꞌnoko napoꞌ teing boto nau-antanukai aaꞌpauꞌ tee, “Nau-anta, niiꞌ taaꞌniꞌanta dake nkoveko oo-koo piamorimang.” ");
INSERT INTO nas_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jiisuuꞌke makuꞌuma aaꞌpuruꞌ, “Diiꞌ enanavarang bakei oreng, nampeesi orarinuka-pinaꞌ diikaang Ovoring siperima, tosirarima aaꞌmerimaing, ‘Taaꞌniꞌanta paning-etaing iroꞌ naumeriko deekoꞌ taararampiaing.’ Bakei Kumponinge diiꞌ taaꞌniꞌanta nau-koo kasivuarura narung masikung aruriiꞌnaang, aaꞌnoaing: Teie ning taaꞌniꞌanta deeng-antamuaing temuꞌ tee nakaronara Joonaꞌ taaꞌniꞌanta deeng-antavuuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Eeꞌ, teeꞌ nariꞌ nkoaravaing tee taviꞌ pankaing-koo keꞌde-koo kuunge Joonaꞌ beenang doong eeꞌnoko muung beenang otokotaaꞌ taaꞌniꞌantavari daaꞌaruꞌnaꞌ napoꞌ teeꞌ nariꞌ ning Tee Naning-naumpoꞌ Paning-etaing beenang doong eeꞌnoko napoꞌ muung beenang kansiꞌkoo kuunge oꞌnokotaaꞌ daaꞌmaravaing taaꞌniꞌantamari. ");
INSERT INTO nas_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Teꞌmung simpeꞌ nkonaꞌmung teing Nineva-nupoong teinge daaꞌariaininge diiꞌ ninka enanavarang ninka nariꞌ eeꞌnoko napoꞌ diiꞌ kiimata-koo makosinuka tantaariaining Joonaꞌ daankiarako temuꞌ bereꞌariruꞌning deemparima, eeꞌnoko ee aing, naning aaꞌnaꞌ pankaing Joonaꞌ puruꞌui otoing aung anke daankiarako diiꞌ bereꞌdariaung. ");
INSERT INTO nas_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Napoꞌ teꞌmung simpeꞌ nkonaꞌmung teni ovorinaang amenteiꞌketa depeto pouꞌnanie nariꞌ diiꞌ emuꞌnavarang ninka daaꞌarara diiꞌ kiimata-koo makosinuka tanturiaing, teni kansiꞌkoo basi-aapeita pouꞌnani deemparama Solomoniꞌ bakaang norukasiꞌkoo baroromparaaꞌnaang, eeꞌnoko ee aing Solomoniꞌkoo dau basi aung anke otoko oomeri barorontariaꞌ otong.” ");
INSERT INTO nas_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Eeꞌnoko Jiisuuꞌke kato nau-antavurima aaꞌpuruꞌ, “Tenang maꞌnaang orara tamung bataꞌnisi naning-eta tenkenura avitoitoi nanupeuꞌnung ntong otoaꞌnairue uaavoainooꞌ besiꞌuma. ");
INSERT INTO nas_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Eeꞌnoko tokoo oovuarura aaꞌpupeuꞌ, ‘Ning toromaravaing napoꞌ nkanava ning mouꞌnava-koo.’ Eeꞌnoko tenang toroarara kiiroraaꞌari neriarioꞌ oovupeuꞌ Tanuaang Meekung borivuaruko bakaang domang-koo. ");
INSERT INTO nas_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Teketa bera teie ˜kenaanka-taa maꞌnari napoꞌ bokuvurira toroaripeuꞌ baruꞌ aaꞌnaꞌ oreng tee puruꞌai. Eeꞌnoko teing tumparira tee-koo otoropeuꞌ, eeꞌnoko asiꞌnung otootoꞌ tee naning bakaang bakei aaꞌnaꞌ oraruꞌkupeuꞌ tutung otokoꞌnooꞌketa. Teeꞌ eeꞌnaꞌ nariꞌ nkoaravaing teing-koo aing-koo nantoong-koo emuꞌnavarang-koo oreng-koo.” ");
INSERT INTO nas_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tenang Jiisuuꞌke nantoong karinga karavuriko teni bauko eeꞌnoko baaraꞌmainkaang teꞌ porora damaꞌdue donkonai Jiisuuꞌ kara-koo piavorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Teketa naninge narunge Jiisuuꞌ nauvuma aaꞌpuuꞌ, “Daaraꞌmainkaang eeꞌnoko dauko damaꞌdue donkonai otorong, daꞌ kara-koo piavoromang.” ");
INSERT INTO nas_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jiisuuꞌke tee naning karavukoꞌnung makuꞌuma aaꞌpuuꞌ, “Baa teni nkoꞌ, eeꞌnoko baata teing ntaraꞌmainkaang?” ");
INSERT INTO nas_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Teketa teing bakaning barevare-nupoong toompurima aaꞌpuuꞌ, “Aing teing ninge nkoꞌ makosinuka eeꞌnoko napoꞌ aing teing ntaraꞌmainkaang. ");
INSERT INTO nas_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aiꞌ baata teing Mmaꞌ paning-koong bakaang pia siompaamaing teing teing eeꞌning ninge aaꞌning makosinuka: ntaraꞌmainkaang, mmarikaampi eeꞌnoko nkoꞌdovo.” ");
INSERT INTO nas_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Teꞌmung eeꞌnaꞌmung Jiisuuꞌ teketa pava-ita siarara nuaruꞌkoo miiring bera baꞌnanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Teketa teka nantoong karingai aaꞌnaꞌ kuronkurompaioꞌ bakaasi-nareng-koo aaꞌearara teꞌ kuung baꞌnanuuꞌ eeꞌnoko nantoong piisiꞌkoo donkonai otorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Teketa teie kapooꞌnanka mmauꞌ nauvuruꞌ mirumiruꞌpoꞌning. Minkuvuma aaꞌpuuꞌ, “Naning mintoong-koo sinang tanka-koo nanura tankavuko aaꞌnouꞌ: ");
INSERT INTO nas_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Niiꞌning sinang taung-koo dau duaꞌariruꞌ, eeꞌnoko teka barennankai porora tunturavauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eeꞌnoko niiꞌning sinang kansiꞌ aavetaꞌkoo dau duaꞌariruꞌ kapang-koo dau otomaung-koo, eeꞌnoko daꞌdeng narung dupuuꞌ, teꞌ kansiꞌ baruꞌ aavetaꞌnooꞌ deemparako. ");
INSERT INTO nas_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Eeꞌnoko batei doonkenang bakaang-koo tee keenkeeng maraꞌouꞌ teke, baruꞌ biira doonko nanuaung deemparara kansiꞌ baruꞌ makotuaꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Eeꞌnoko niiꞌning sinang napoꞌ tooꞌmurintaaꞌ otoroinooꞌ meuꞌ duaꞌariruꞌ eeꞌnoko nariꞌ dupurira tooꞌmurintaaꞌke iinkenevuuꞌ tee keenkeeng. ");
INSERT INTO nas_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Teka niiꞌning kansiꞌ pankauanooꞌ dau duaꞌarira maneearira aaꞌnouꞌ: niiꞌning-koo narung daakuꞌ biꞌuuꞌ, napoꞌ niiꞌning-koo paꞌnokoꞌketa narung kivora biꞌuuꞌ, napoꞌ niiꞌning-koo beenaumo kivora biꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Punkang otorininge tee enang taaraveriaing!” ");
INSERT INTO nas_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Teketa bakaning barevare-nupoonge porora Jiisuuꞌ niaꞌaama aaꞌpauꞌ, “Dake aming-koo nantoong kara mirumiruꞌpoꞌnunge karema nauerimaung?” ");
INSERT INTO nas_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Teie makuꞌuma aaꞌpuuꞌ, “Kumponinge diiꞌ bakaang kara pinkaꞌerimaing tauraꞌduruꞌnung makensiꞌnung-koo miruꞌnooꞌ noruꞌeriiꞌnaang tee-koo bakaang muuꞌkoo nkoaramanaꞌ, teka aing nantoong teeꞌ deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aiꞌ baa tee naning bakaang domang-koo kara Kumponing bakaang kompui otomaung tee eeꞌnung baruꞌ aaꞌnaꞌ noruꞌ nkavuaing bonoꞌ divuꞌui, teka tee naning bakaang domange kompuaung tee okiꞌnooꞌ naroꞌ daunooꞌ noruꞌkui otoing tee tee pariꞌnumpoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Teeꞌkoo aing nantoong mirumiruꞌ narunge kara nauaramaung, aiꞌ aing teing Kumponinge kapooꞌ nauvuriko tee-koo daunooꞌ naroꞌ noruꞌkaamaing, bane aaꞌnaꞌ ookaama niiꞌnooꞌ taarakaama. ");
INSERT INTO nas_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Teing-koo masikaꞌpari otong tee teie Aisaiaꞌke tero tarampeearama minkuvuuꞌnung Daari Meekung-koo aaꞌpuuꞌnooꞌka, ‘Diiꞌke taaraverimaatoaing, teka tasiꞌperiaꞌ otoaing. Napoꞌ teeꞌ ooveri otoma papaaraverimatoai. ");
INSERT INTO nas_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","“Aiꞌ teing aing nantoong biikaang domang poruruorouꞌning˜, biikaang punkange taara-koo baruꞌ makotuaunge eeꞌnoko biikaang duta mutuuariruꞌ. Teeꞌ biiꞌka maroita nkoariruꞌ aaꞌnoꞌneeng-koo, dutai tasiꞌpaama, punkange taaravaama, domange onouaara ning-koo toroariko ninge unaa-antavaramiꞌneeng-koo.’ ");
INSERT INTO nas_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Teka diiꞌ diikaang duta biraankeniiꞌ teinge ookirimaung-koo, eeꞌnoko diikaang punkang biraankeniiꞌke teinge taarakirimaung-koo. ");
INSERT INTO nas_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aiꞌ ninge masikaꞌ naurampimang, karingai-nakaro-nupoong eeꞌnoko nantoong koontoꞌnukai-tee kapooꞌ ninge nkoanko diiꞌke ooverimaung oo-koo piavorokoꞌ, teka ooaavarukoꞌ. Napoꞌ tee kapooꞌ ninge daankianko diiꞌke taaraverimaung taara-koo piavorokoꞌ, teka taaravaavarukoꞌ tee.” ");
INSERT INTO nas_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Enang tee diiꞌke taaraveriiꞌnaang tee miruꞌnooꞌ tee-koo mirumiruꞌkoo sinang tankavumaung-koong. ");
INSERT INTO nas_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tee sinang taung-koo duaꞌariruꞌning eeꞌ miruꞌari otong: Niiꞌninge nantoonge tee minkunaa muuꞌ paninung-koong daunooꞌ naroꞌ taaravaama miruꞌnooꞌ nkavaavaruko teie naning orarai, Sietaniꞌke tee kara teꞌnempumaung biikaang onou-eta. ");
INSERT INTO nas_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Napoꞌ tee sinang kansiꞌ aavetaꞌkoo dau duaꞌariruꞌning eeꞌ miruꞌnooꞌ: Niiꞌning nantoong teing kara taaravaama doturotu ninka kompaamaung. ");
INSERT INTO nas_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Teka tee kara biikaang domang-koo tampaꞌ ariꞌavuaruma pankaroong otoarukooꞌ. Eeꞌnoko aaꞌnokooꞌ: niiꞌninge Kumponing-nung kara piavoroainge turampaarima mankiꞌantavaariko namuꞌke biikaang baito orariarakooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eeꞌnoko napoꞌ tee sinang tooꞌmurintaaꞌkoo meuꞌ duaꞌariruꞌning eeꞌ miruꞌnooꞌ: Niiꞌning nantoong kara taaravaamaung teka aung kansiꞌkoong mankiꞌnanka-koo eeꞌnoko kavo nka-koo daang noruꞌarima booniꞌantavaako tee kara teke sinampuarukooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Napoꞌ tee sinang kansiꞌ pankauang-koo duaꞌariruꞌning eeꞌ miruꞌnooꞌ: Niiꞌning nantoonge tee kara taaravaama tee-koong miruꞌ nkavaamaung. Teketa biikaang domang-koo dupuriko sinananka mmauꞌ biꞌantavaakooꞌ, niiꞌning daakuꞌnaꞌ, niiꞌning paꞌnokoꞌketa narung kivoranaꞌ eeꞌnoko niiꞌning beenaumo kivoranaꞌ teing-eta tankaniiꞌnanka-ita.” ");
INSERT INTO nas_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Napoꞌ Jiisuuꞌke niiꞌnung minkunaa mirumiruꞌpoꞌnung nauvuruꞌ, aaꞌpuruꞌ, “Tee muuꞌ paninung tee-pinaꞌ naninge sinang tampara bakanau-koo tankavuuꞌnung-pinaꞌ oroꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Teka tenang ookara aasiaako teie bakaang karenunge pora tee sinang oramuriiꞌ dau-eta tankavuuꞌ sinang tampenanka-koo meuꞌ. Teeꞌ nkovura tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Eeꞌnoko tenang tee uiteꞌ dupura puaravuko tee oramuriiꞌ tonto teeꞌke siraꞌpari oroꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Eeꞌnoko teinge bakaninge botovotonaaꞌnukai porora aaꞌpauꞌ tee, ‘Aung ee, tee orara tonto areketa pouꞌnung dakanau-koo teꞌ dake tampamuriiꞌ sinang tankaveruꞌnooꞌ?’ ");
INSERT INTO nas_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Eeꞌnoko teie makuꞌurima aaꞌpuruꞌ, ‘Tee aaꞌ teie naninge ning-koo karenunge teeꞌ nkovuuꞌnung.’ Eeꞌnoko teinge aaꞌpauꞌ, ‘Teka ee niiꞌke bitaꞌkoo pia-antavemaang?’ ");
INSERT INTO nas_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Teie aaꞌpuuꞌ, ‘A, tee aaꞌ otoaing. Tee tonto bitaꞌerima tee uiteꞌ naroꞌka bitaꞌeriꞌneenga. ");
INSERT INTO nas_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Siperioꞌ nariꞌ dupureaing bera kavuꞌkoong batei makotuai, eeꞌnoko tenang ninge teing kavuꞌ nkonuka nauarama aaꞌpampai, “Tutung teenanka tonto orarananka bitaꞌerima daiꞌereriai tai-anta-koong, teketa tee uiteꞌnanka kaverira nkanooꞌ pava-koo oosierereriai.’” ’ ");
INSERT INTO nas_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Napoꞌ teie niiꞌnung mirumiruꞌ nauvuruꞌ, aaꞌpuuꞌ, “Tee muuꞌ paninung tee teu-pinaꞌ masitaraꞌkoong sinanu okiꞌnu naninge nkavura bakanau-koo keempuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bane temuriiꞌ mukusiriꞌ ookara-ita, nka tee tenang dupura pankaꞌparama taamang mintoong-kooning divuꞌura koiꞌ pankavari deemparamaung, eeꞌnoko barennanka poroma biikaang bitonanka kaniaamaunge kaumpeꞌnanka-koo.” ");
INSERT INTO nas_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Napoꞌ teeꞌ nariꞌ niiꞌnung mirumiruꞌ nau-antavuruꞌ, aaꞌpuuꞌ, “Tee muuꞌ paninung tee teu-pinaꞌ parauanu naakoꞌniiꞌnu iisi-poꞌnu-pinaꞌ naninge manikumai nkavura paraua diisi beerentuꞌkoo maantoꞌura naroꞌka bereꞌuko bera teue ookara pangapangavopeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aing ookara kapooꞌnanka Jiisuuꞌke nantoong karinga-koo minkuvuuꞌning teing mirumiruꞌpoꞌning, eeꞌnoko kapooꞌ niiꞌnung mirumiruꞌ otoaruko nau-antavuruꞌnung otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Teeꞌkoo tee kara narunge nakaronunge minkuvuuꞌnung masikaꞌparuꞌ Daari Meekung-koo aaꞌpuuꞌnooꞌka, “Ninge nkaang karang daateꞌmaravaing mirumiruꞌnanka-koo. Eeꞌnoko napoꞌ ninge siraꞌantavampaing teing kapooꞌ makensiꞌning otomaing kansiꞌ pupuꞌaruꞌnooꞌketa.” ");
INSERT INTO nas_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Teketa teing nantoong karinga sipurira Jiisuuꞌ pava-koo koinuuꞌ. Eeꞌnoko teka bakaning barevare-nupoonge porora aaꞌpauꞌ, “Tee kara mirumiruꞌpoꞌnung tonto-poꞌnau-koong niiꞌkoo sirakaꞌantaveai.” ");
INSERT INTO nas_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Eeꞌnoko makuꞌurima aaꞌpuruꞌ teie, “Tee naning sinang tampara tankavumaung tee ning eeꞌnung, Tee Naning-naumpoꞌ Paning-etaing. ");
INSERT INTO nas_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Eeꞌnoko tee mintoong tee aung kansiꞌ ookutunung, eeꞌnoko tee sinang tampara tee teing nantoong paninung muuꞌkoo-nupoong makosi. Eeꞌnoko tee tonto tee teing nantoong tee naning orara bakaning. ");
INSERT INTO nas_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Eeꞌnoko tee karenung teing tankavuruꞌnung tee Sietaniꞌ. Eeꞌnoko tee sinang kavuꞌ tee batei asirang makosi, eeꞌnoko teing sinang kavuꞌnupoong teing eeꞌning koosinunanka. ");
INSERT INTO nas_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Teeꞌ tontonanka bitaꞌaama ntaꞌkoo betuꞌaarimanaꞌ tee teeꞌ nantoong oreng nkoariaing asiranaꞌmung. ");
INSERT INTO nas_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Eeꞌnoko ninge Naning-naumpoꞌ Paning-etainge nkaning koosinunanka botoaranko teinge tee nkaang muuꞌ tontoaama bitaꞌaariaing, ookara kapooꞌnanka orara aarumo tavoꞌantavumaing eeꞌnoko ookara nantoong orara aarumo nkoaamaing. ");
INSERT INTO nas_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Eeꞌnoko teinge teing teing urung-koo duaꞌaariaining, teꞌ eeꞌnooꞌ nantoong biromparima siꞌdaꞌ dovang kakirinkuarimatoainooꞌ sisikeera-koo otoroi. ");
INSERT INTO nas_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Teketa tenang teing koontoꞌnuka duaaꞌpinaꞌ arakavariai teke tee-koo muuꞌ Biuma bakaang-koo. Punkang otorininge tee enang taaraveriaing!” ");
INSERT INTO nas_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Napoꞌ tee muuꞌ paning-koong tee tee-pinaꞌ muuninava kansiꞌkoo bakuꞌniiꞌ. Tenang naninge daaꞌura napoꞌ tampaꞌ bakuꞌuuꞌ eeꞌnoko bera doturotu ninka ookara kapooꞌnanka tee otoꞌevukoꞌning baavevuuꞌ eeꞌnoko mooniꞌ nkavura teing-koo tee tenau kansiꞌ mooꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Napoꞌ tee muuꞌ paninung tee tee-pinaꞌ oroꞌ naning baave-nko dukuꞌ tampara mooꞌkoo besiꞌukoꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Teketa nau mooꞌ pankaing-koonu oovura toroarara ookara kapooꞌnanka bakaning baavevura mooniꞌ nkavura teu mooꞌuuꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Napoꞌ tee muuꞌ paninung tee tee-pinaꞌ sionung-pinaꞌ oroꞌke. Nuaruꞌkoo duaꞌaara taviꞌ amutemuriiꞌ barampaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bera tenang aaꞌnaꞌ maantoꞌuioꞌ teinge taviꞌ baranukai deto piisiꞌkoo barampauꞌ. Teketa baꞌnaniaara tampenanka taviꞌ bireꞌarima pekuꞌkoo kuung sipaaruꞌ, teka oreng duaꞌaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Teeꞌ eeꞌnaꞌ nariꞌ nkoaravaing teꞌmung doong asiꞌnaꞌmung. Teinge koosinunankai porora simpeꞌaariaing teing orananka teing-eta tampeng-eta. ");
INSERT INTO nas_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Eeꞌnoko ntaꞌkoo kuung urung-koo duaꞌaariai teꞌ eeꞌnooꞌ nantoong biromparima siꞌdaꞌ dovang kakirinkuarimatoainooꞌ sisikeera-koo otoroi.” ");
INSERT INTO nas_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Teketa Jiisuuꞌke niaꞌurima aaꞌpuruꞌ, “Aing ee kapooꞌnanka diiꞌke tasiꞌpering?” Teinge makuꞌaama aaꞌpauꞌ, “Eeꞌ”. ");
INSERT INTO nas_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Napoꞌ teie aaꞌpuruꞌ teing, “Ookara teing-koo boto nau-antanuka ning-koo barearimaing muuꞌ paning-aapening-koo teing teing biraanke-nupoong, aiꞌ teinge urikupoong nakaro-nupoong biikaang kara tasiꞌpai otorong eeꞌnoko ning-koo dupearamanaꞌ tasiꞌpai otong tampaꞌ nantoong nau-antavaariiꞌnaang naroꞌka.” ");
INSERT INTO nas_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tenang Jiisuuꞌke aing mirumiruꞌnanka minku bakevura teketa diiriꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bera bakanooꞌ osi masipoꞌ pora nantoong nau-anta tutumpuruꞌ biikanava dootuuꞌnava-koo. Eeꞌnoko teing taꞌninaara aaꞌpauꞌ, “Aunge tee aung noruꞌ areꞌka nkavuuꞌnung, eeꞌnoko teing aing taꞌnimpaariiꞌnanka iriꞌpoꞌning? ");
INSERT INTO nas_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aung ee eeꞌnung tee anke pava kani bauring ee deeaꞌ? Bauko miring Meeriꞌ eeꞌnoko baaraꞌmainkaang ainge ee deeaꞌ aaꞌning, Jeemisi, Josepaꞌ, Saimoniꞌ eeꞌnoko Judasi? ");
INSERT INTO nas_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Baꞌmarikaampi anke ee otoroaꞌ niiꞌ ninka? Areꞌka nkavuuꞌnunge aunge aing kapooꞌnanka?” ");
INSERT INTO nas_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eeꞌnoko teing tee-koo domang orakaꞌ otoroko Jiisuuꞌke aaꞌpuruꞌ, “Mmauꞌ nantoonge niiꞌ nakaro-nupoong pankaing-antamaarimaung. Niikanooꞌnupoonge deekoꞌ pankaing-antamaariaung, niiꞌmarange.” ");
INSERT INTO nas_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eeꞌnoko teie mmauꞌ taaꞌniꞌantananka teke nkovuaruuꞌ biikaang masikaꞌanta otoaruioꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tenang eeꞌnang tee teie Eerotiꞌke, Kaaleliꞌnameng tarevukoꞌnunge Jiisuuꞌkoong doorenang taaravura aaꞌpuruꞌ bakaning bautarananka, ");
INSERT INTO nas_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Tee tee eeꞌnung Jooni Minkinara; booꞌketa napoꞌ daaꞌaring. Teeꞌkoo iriꞌ ninka mintoomparamaang.” ");
INSERT INTO nas_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tee tee eeꞌnunge Eerotiꞌke botoarioꞌ Jooni mooꞌura, daiꞌuuꞌ, eeꞌnoko kiimatanava-koo sipauꞌ Erodiasi dotu-anta-koo; ");
INSERT INTO nas_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aiꞌ Eerotiꞌke teni ninka Erodiasi, baaraꞌmaꞌnung Pilipiꞌ baꞌaang ninka otoresioꞌ Joonie tero aaꞌpuuꞌ, “Teeꞌ botoi potevui otoinaꞌ nkoraring teni nampera.” ");
INSERT INTO nas_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eerotiꞌke Jooni tee dupisiꞌkoo piavouꞌ, teka nantoong-koo avorouꞌ teinge tee nakaronung noruꞌai otoromanooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Teketa niiꞌnaꞌmung tee, tee Eerotiꞌ bakaang doong pontoꞌaruꞌnaꞌmung-koo teni eeꞌnani Erodiasi baurang damisimainku-ankoi neekavarara Eerotiꞌ aaꞌnaꞌ karaaꞌantavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bera teie marakavarama teni kapooꞌ piavora eentavarako avuuꞌnaang tampuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Teketa baukoi botovuko tenie aaꞌpuuꞌ, “Jooni tee Minkinara-koong boreꞌ aꞌ daara-koo siꞌmemura ameaing.” ");
INSERT INTO nas_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Teketa teie dauraronge˜ teeꞌ taaravura domang orakaꞌ deeꞌouꞌ, teka tee bakaang maraka-anta nkovuuꞌnung deemparako eeꞌnoko napoꞌ teing damisimainku otoroko, tee botoaruꞌ teni avuꞌkoo teeꞌ eentavaruꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eeꞌnoko botoarioꞌ bakaning-koo narung bera pava kiimatanavaꞌkoo kuunga kuru takoꞌpevuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Eeꞌnoko Jooni bakaang boreꞌ daara-koo nkavui pora teni neraiꞌnaꞌ avuuꞌ. Eeꞌnoko tenie bauko-anko tavoꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Eeꞌnoko Jooni bakaning barevare-nupoonge porora bakaang mono nkavaara dakoꞌauꞌ. Teketa Jiisuuꞌanko berora nauauꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tenang Jiisuuꞌke taaravura tee kapooꞌ Jooni Minkinara-koo nkoaruꞌnung, teketa tenkenuuꞌnung eeꞌnoko bakaasi-koo bakaning ninka aaꞌearira biiꞌka otoꞌnooꞌ berouꞌ. Teeꞌ taaravaara nantoong karingai siompai kauꞌke berouꞌ osinanka-ita. ");
INSERT INTO nas_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tenang Jiisuuꞌ bakaning ninka teꞌ duumearira˜ teka nantoonanka mmauꞌ karinga oovurira bakaang domang aaꞌnaꞌ piaavouꞌ teing-koo, eeꞌnoko siipa-nupoong poꞌantavaaruꞌning taare-antavuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Teketa muung-aapevuma nanuuꞌnang teinge bakaning barevare-nupoonge tee-anko porora aaꞌpauꞌ tee, “Niiꞌ meeꞌboraꞌ sirakamaaꞌkoo oꞌnoring eeꞌnoko batei nanuinge. Aing nantoong karikaꞌ botoveriko osinanka-koo berora taamang mooꞌsiiaavai.” ");
INSERT INTO nas_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Aing aaꞌ tokoi bataꞌkoo tampaꞌ deeaꞌ niiꞌ apukaꞌmariaꞌ. Diiꞌke kapooꞌ averereriko naiaavaing.” ");
INSERT INTO nas_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eeꞌnoko teinge makuꞌaama aaꞌpauꞌ, “Niiꞌ anke bereteꞌ paꞌnokoꞌ naing otong eeꞌnoko taviꞌ keura otoꞌmemurimaang.” ");
INSERT INTO nas_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jiisuuꞌke aaꞌpuruꞌ, “Aꞌ ning-anko poꞌantaveriaing teing.” ");
INSERT INTO nas_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eeꞌnoko teie nantoong karinga karaasiꞌkoo doonko baꞌnampariiꞌnaang botovuruꞌ. Eeꞌnoko Jiisuuꞌke teing paꞌnokoꞌ bereteꞌ eeꞌnoko taviꞌning keura nkavura tee paning-aape ankamparara biraankevura pisiꞌuuꞌ teing bereteꞌning. Teketa teing bakaning barevare-nupoong avuriko teinge teing karinga avaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Eeꞌnoko ookara taamanaara poovorouꞌ. Eeꞌnoko teinge bakaning barevare-nupoonge kakitaꞌnanka oosiaara kivora-ita kevekuꞌka pekuꞌ maantoꞌantavauꞌ siparuꞌninge. ");
INSERT INTO nas_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nantoong donkaang teke taamanauꞌning-koong deerunooꞌ paꞌnokoꞌ kokoreiꞌ, manikuꞌ eeꞌnoko toireꞌ nariꞌ deeruariaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Teketa tenang namuꞌke Jiisuuꞌke bakaning barevare-nupoong bakaasi-nareng-koo aaꞌe-antavurira nuaruꞌkoo niiꞌnavete-koo beꞌkoo botovuruꞌ tee-koo uroꞌke, teing beroko nantoong karinga tenkeng-koo botovuriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Teketa Jiisuuꞌke teing karinga botovurira tee mii-koo deto baka beuꞌ teke kunsiaraaꞌnaang, bera muumpuuꞌ teke baka otoko. ");
INSERT INTO nas_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Eeꞌnoko tereng bakaasi-nareng tee kansiꞌketa isipoꞌ basiaruꞌ, teka pionge kosiꞌuko booꞌai aaꞌnaꞌ neekavukoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bera taneꞌ dereꞌuaruko Jiisuuꞌ teing-aape pouꞌ nuaruꞌkoo daue nanuma. ");
INSERT INTO nas_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Teketa teinge barevare-nupoonge ooaara ntong-koo daue nanuko, aaꞌnaꞌ avoreaama bokiaama aaꞌpaakoꞌ, “Aunkapeto maꞌnaang!” ");
INSERT INTO nas_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Teka Jiisuuꞌke namuꞌke karavuruꞌ teing, aaꞌpurima, “Domang kuaaꞌdoriai aroreriaꞌ, tee ning eeꞌ nanamang.” ");
INSERT INTO nas_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Teketa Piitai aaꞌpuuꞌ, “Ovoring, daꞌ masikung deekoꞌ bokumeko ning ntong-koo daue nanama daꞌanko meai.” ");
INSERT INTO nas_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jiisuuꞌke aaꞌpuuꞌ, “Poaing.” Teketa tenang Piita doonko siaruꞌ bakaasi-eta, eeꞌnoko ntong-koo daue nanuuꞌ Jiisuuꞌanko bema. ");
INSERT INTO nas_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Teka tenang teie doving oovura tee avorouꞌ, eeꞌnoko minki tutumparuꞌ, eeꞌnoko minki tutumparama bokuma aaꞌpuuꞌ, “Ovoring, mooꞌmeai!” ");
INSERT INTO nas_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Teketa namuꞌke Jiisuuꞌke tankaꞌ toonura mooꞌura aaꞌpuuꞌ tee, “Daꞌ bakei dakaang masikaꞌanta okiꞌnung. Aming-koo keekooꞌdaramaunge?” ");
INSERT INTO nas_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Eeꞌnoko tenang bakaasi-koo deto aaꞌearesioꞌ tee doving bakearuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eeꞌnoko tenang teinge bakaasi-koo otorouꞌninge tee-anko kinkinaara daangampaama aaꞌpauꞌ, “Daꞌ tee Kumponing bauring masikung!” ");
INSERT INTO nas_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Teketa kato pakoꞌarira Kenaseretiꞌnameng-koo tavoꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Eeꞌnoko tenang nantoonge Jiisuuꞌ teka tasiꞌpaara doorenang ootukunairue tevaro-koo nanuꞌantavauꞌ. Teketa nantoonge ookara biikaning siipa-poꞌnupoong Jiisuuꞌanko tavoꞌaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Eeꞌnoko eentavarikoꞌ tamung bakaang mononopaꞌkoo kainuꞌ kompaama taarevorooꞌnaang. Eeꞌnoko teing ookara tee kompauꞌning tee taarevorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tenang tee niiꞌning Boto Keperuuꞌnavitu eeꞌnoko boto naunuka Jerusalemaꞌketa Jiisuuꞌanko porouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Eeꞌnoko Jiisuuꞌ niaꞌaama aaꞌpauꞌ, “Dakaning barevare-nupoonge aming-koo niikakatauroi bamaaruꞌnaꞌ boto siompaavaung, aaꞌnomaung, biikaang bireng duuꞌpariaꞌ taamanaakooꞌ domang orari-antavarima Kumponing-koo dutakanooꞌke?” ");
INSERT INTO nas_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Teketa Jiisuuꞌke makuꞌuma aaꞌpuruꞌ, “Nka diiꞌke tee Kumponing bakaang boto aming-koo totoꞌperikooꞌ tee diikaang minkunaa sintokosintoi-koong toomo siomperima? ");
INSERT INTO nas_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Aaꞌnoma, Kumponinge eeꞌ botoaruꞌ, ‘Daumararing deto noruꞌeresi pakuereaing,’ eeꞌnoko, ‘Naning baumararing orakaꞌ minkuvureaing tee bakei dupisiꞌnumpoꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Teka diiꞌke aaꞌperimaung, ‘Naninge baumararing kapooꞌkoo apukaꞌpareko, beuringe tering paku-koo kupiꞌora deekoꞌ aaꞌpupeuꞌ, “A, nkaning kapooꞌ arompepeuꞌning teing temuꞌ Kumponing bareantuꞌning.” Eeꞌnoko teeꞌpureta orokoari otoaing teing kapooꞌ baumararing avuꞌkoo.’ ");
INSERT INTO nas_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Teeꞌ nkorarima diiꞌke tee Kumponing bakaang boto daang-antaverimaung tee diikaang sintokosintoi-koong minkunaa daang toomo pinaꞌ oroꞌparaaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Diiꞌ ampirinunuka! Masikaꞌ teie nakaronunge Aisaiaꞌke tarampeearama˜ diiꞌ eeꞌning minkururima Kumponing bakaang kara eeꞌ minkuvuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Teinge ainge nantoonge biikaang beꞌduuꞌke narunge pankaing-antamaamaung, teka biikaang domang ning-koo isipoꞌ otoroi. ");
INSERT INTO nas_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tamung ning dootuuꞌmaamaing, aiꞌ teing boto nkaang miring-koo nau-antavaarimaing teing tamung nantoong-etaning.’” ");
INSERT INTO nas_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Teketa Jiisuuꞌke nantoong karinga tee-anko bokuvurira aaꞌpuruꞌ teing, “Aing kapooꞌ diiꞌke taaraverira tampaꞌ norunoruꞌeriaing. ");
INSERT INTO nas_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tee kapooꞌ naning-koo karang-koo tumparamaunge naning bakaang domang orari-antavuaung Kumponing bakaang duta-koo, teka teie kapooꞌke naning-eta karange doompeto pomaunge naning domang orari-antavumaung.” ");
INSERT INTO nas_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Teketa napoꞌ bakaning barevare-nupoong tee-anko porora niaꞌaama aaꞌpauꞌ, “Dake ee noruꞌei otong teinge Boto Keperuuꞌnavitue daꞌ orakaꞌ noruꞌdaing teeꞌ minkuveioꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jiisuuꞌke makuꞌuma aaꞌpuruꞌ, “Ookara keenkeenanka Mmaꞌke paning-koonge keempuriaruuꞌning teing bitaꞌkooning ariꞌa ninka nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Teing teing biiꞌka kaputuꞌariri niiꞌning duta kaputuꞌnuka taung nau-anta nkoaamaing. Diiꞌke teing siperereriaing, aiꞌ naning kaputuꞌke narung napoꞌ kaputuꞌ siong-antavuma tenaanka tee ookaanka dinkung-koo duaꞌareaing.” ");
INSERT INTO nas_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Teketa Piitai aaꞌpuuꞌ, “Tee mirumiruꞌ niiꞌkoo sirakaꞌantaveai.” ");
INSERT INTO nas_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jiisuuꞌke aaꞌpuuꞌ, “Diiꞌ ee teing-pinaꞌ nariꞌ mmeꞌ noruꞌ sirakaꞌdariaꞌ? ");
INSERT INTO nas_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Arekeeꞌ tasiꞌperiaꞌ tee kapooꞌ naning-koo karange doonko tumparama pakosiiꞌkoo bemaung, eeꞌnoko teketa mono-ita napoꞌ siarakooꞌ domang orarivuaꞌ? ");
INSERT INTO nas_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Teka tee kapooꞌnanka karange doompeto pomananka teing teing domang-eta pomaing, eeꞌnoko teinge eeꞌninge naning orari-antavumaung. ");
INSERT INTO nas_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aiꞌ eeꞌnooꞌketa domang-eta kapooꞌ orara noruꞌnanka pomaunge aing aaꞌning: naning dupisiꞌkoong noruꞌ, nampeesi orari-koong noruꞌ, kaukauro-koong noruꞌ, eeꞌnoko bakiaaꞌnko, daang-koong kara minku tuutunantomai eeꞌnoko pooreꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aing eeꞌninge kapooꞌnankai naning orari-antavumaung, teka bireng duuꞌparavaꞌ taamang naie naning orari-antavuaung.” ");
INSERT INTO nas_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Eeꞌnoko Juꞌ biikanameng-eta uaa-koo tenkenuraiꞌnange Jiisuuꞌ bakaning ninka osi Taiaꞌ eeꞌnoko Saidoniꞌnameng-koo berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Teka temeng-koo naning Keenang-naving-koonani Jiisuuꞌanko pora bokuma aaꞌpuuꞌ, “Ovoring, Deevitaꞌ bakanaving-koong, piaameai ning! Nnorang teni maꞌnaang aaꞌnaꞌ masikaꞌ kurumaaꞌaramanani!” ");
INSERT INTO nas_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Teka Jiisuuꞌke nanaarenooꞌ karoma makuꞌuaꞌ. Teeꞌ birompari otoko bakaninge barevare-nupoonge Jiisuuꞌanko beroma botoaama aaꞌpauꞌ tee, “Ani bataꞌeai. Niiꞌ siomurima birompari otomang.” ");
INSERT INTO nas_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Teka Jiisuuꞌke aaꞌpuuꞌ teni, “Ning tee Isireeli-nupoong-eta sipisipiꞌpinaꞌ pooariruꞌning naing-koo botomuuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Teketa teni pora Jiisuuꞌkoo uroꞌkanooꞌ kinkinura eentavarama aaꞌpuuꞌ, “Ovoring pakumeai.” ");
INSERT INTO nas_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Tee aaꞌ taamang toireꞌ biikaang mosiꞌnanka-anko duaꞌkoo tampaꞌ deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tenie aaꞌpuuꞌ, “Eeꞌ, Ovoring, masikaꞌ, nka tee mosiꞌnankai napoꞌ mukunanka naiaamaung ovoring baurukaaꞌ taamanaamanooꞌketa duaꞌarimaing.” ");
INSERT INTO nas_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Teketa Jiisuuꞌke makuꞌuma aaꞌpuuꞌ teni, “Ani ee, daꞌ bakei dakaang baito pankaing, teeꞌkoo tee kapooꞌ eentararing enang nkoaring.” Eeꞌnoko teni baurang tee-koo batei-koo tenang taarevouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Teketa Jiisuuꞌke teꞌ sipura Kaaleliꞌnaruꞌ sionge danto beuꞌ. Teketa miie deto koinuuꞌ, bera aꞌdeiꞌ baꞌnamparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Teketa nantoong karinga tee-anko porouꞌ nantoong deꞌdoonuka eeꞌnoko kaputuꞌnuka, kooꞌ mareꞌnuka, amakoori eeꞌnoko napoꞌ mmauꞌ niiꞌning. Porora tee-koo kauꞌkanooꞌ bempaarioꞌ teka taare-atavuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nantoong bakei aaꞌnaꞌ taꞌninauꞌ tenang aing aaꞌning nantoong ooaarira, amakonuka kareaako ooaaruꞌ, kooꞌ mareꞌnuka koompariruꞌ, deꞌdoonuka tampaꞌ nanauꞌ, kaputuꞌnuka ookauꞌ. Eeꞌnoko teinge tee Kumponing Isireeli-nupoong biikaang daangampauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Teketa Jiisuuꞌke bakaning barevare-nupoong tee-anko bokuvurira aaꞌpuruꞌ, “Nkaang domang aaꞌnaꞌ piaamoing aing-koo nantoong-koo. Aing teing niꞌninka beenang doong oꞌnorining eeꞌnoko kapooꞌ nai-koong otoꞌevoroaꞌ. Peeravoroi otoroko tokoi boto-koo piamoaꞌ taunga peerai tavuriꞌneeng.” ");
INSERT INTO nas_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eeꞌnoko bakaning barevare-nupoonge aaꞌpauꞌ, “Aing bauꞌkoong makosi nantoong karinga taamang areꞌka nkavampiiꞌnaang aung-koo meeꞌboraꞌ sirakamaaꞌkoo meuꞌka?” ");
INSERT INTO nas_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Eeꞌnoko Jiisuuꞌke niaꞌurima aaꞌpuruꞌ, “Teka bereteꞌning arekeeꞌning otoꞌderuring?” Teinge aaꞌpauꞌ, “Paꞌnokoꞌketa keura eeꞌnoko niiꞌning taviꞌning okiꞌnarekaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eeꞌnoko teie nantoonge karinga kansiꞌkoo baꞌnaniꞌaavaꞌnaang nauvuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Teketa teie teing paꞌnokoꞌketa keura bereteꞌning eeꞌnoko taviꞌning nkavura Ovoring-koo tampara tampura pisiꞌura teing bakaning barevare-nupoong avuruꞌ, eeꞌnoko teinge nantoong avaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Eeꞌnoko ookara taamanaara poovorouꞌ. Teketa damaꞌke bakaning barevare-nupoonge pekuꞌ paꞌnokoꞌketa kevekuꞌka kakitaꞌnankai sipaaruꞌninge maantoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nantoong donkaang naing teke taamanauꞌning-koong deerunooꞌ karenaumo kokoreiꞌ, manikuꞌ dovang toireꞌ nariꞌ deeruariaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Teketa Jiisuuꞌke nantoong karinga tenkeng-koo botovurira tee bakaasi-nareng-koo aaꞌearuꞌ, eeꞌnoko teketa Maꞌdala-aape-navete-koo berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Niiꞌnaꞌmung teing Boto Keperuuꞌnavitu eeꞌnoko napoꞌ teing Noruꞌ Pitunavitu Jiisuuꞌanko porora tee paara-antavaama niaꞌaama aaꞌpauꞌ, “Narung taaꞌniꞌanta Paning-etaing naumeriai daꞌ Kumponing-etaing deekoꞌ tasiꞌdampiainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Tenang muung-aapenang diiꞌke aaꞌperimaung, ‘Taneꞌ tampaꞌmung, tampaꞌ otooꞌnaang, kamoꞌ urung deemparing.’ ");
INSERT INTO nas_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Eeꞌnoko napoꞌ taneꞌnang aaꞌperikooꞌ, ‘Eꞌmung irinke nkoaraaꞌnaang, aiꞌ paning kamoꞌke urunge neeꞌuing.’ Diiꞌke tee tampaꞌ noruꞌeri otong kamoꞌ ooverima nkoaravainaꞌ noruꞌkoo, teka diiꞌke emuꞌnung batei bakaang taaꞌniꞌanta noruꞌeriarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Diiꞌ enanavarang bakei oreng, nampeesi orarinuka-pinaꞌ diikaang Ovoring siperima, tosirarima aaꞌmerimaing, ‘Taaꞌniꞌanta paning-etaing iroꞌ naumeriko deekoꞌ taararampiaing.’ Bakei Kumponinge diiꞌ taaꞌniꞌanta nau-anta-koo kasivuarura narung masikung aruriiꞌnaang, aaꞌnoaing: teie ning taaꞌniꞌanta deeng-antamuaing temuꞌ Joonaꞌ taaꞌniꞌanta deeng-antavuuꞌnaꞌ.” Teketa Jiisuuꞌ teing teka sipurira tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Teka tenang tee-koo nuaruꞌkoo beroma teinge bakaning barevare-nupoonge tee taamang nka-koo ampaꞌorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Eeꞌnoko nuaruꞌkoo pakoꞌariraiꞌnange Jiisuuꞌke aaꞌpuruꞌ teing, “Tanatarariaing teing-koo Boto Keperuuꞌnavitu-koo eeꞌnoko Noruꞌ Pitunavitu biikaang iisi-koo.” ");
INSERT INTO nas_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eeꞌnoko teeꞌpuioꞌ tasiꞌpaavarura kareaama aaꞌpeekoꞌ, “Aunge pa niiꞌke taamang nkavampiaruing-koo teeꞌ minkuvumaang.” ");
INSERT INTO nas_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Teketa Jiisuuꞌke tee biikaang minkunaa noruꞌura aaꞌpuruꞌ teing, “Diiꞌ baruꞌ masikaꞌantaropanuka, aming-koo diiꞌka minkurarimang taamang nkaveriarura? ");
INSERT INTO nas_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Koontoꞌ ee mmeꞌ diiꞌke tasiꞌmeriaꞌ ning? Noruꞌeriaꞌ otong teing paꞌnokoꞌnuri bereteꞌ, nantoonge paꞌnokoꞌ kokoreiꞌke naiauꞌning, eeꞌnoko teing-koo arekeeꞌning pekuꞌ oosierira maantoꞌeruꞌ damaꞌke taaꞌparioꞌ? ");
INSERT INTO nas_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Napoꞌ ee noruꞌeriaꞌ otong teing paꞌnokoꞌketa keura bereteꞌ nantoong karenaumo kokoreiꞌke naiauꞌning eeꞌnoko teing-koo arekeeꞌning pekuꞌ oosierira maantoꞌeruꞌ damaꞌke taaꞌparioꞌ? ");
INSERT INTO nas_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Arekeeꞌkoo diiꞌke tasiꞌperiaunge? Aiꞌ ninge tee taamang-koo minkuampaung. Teka diiꞌ eeꞌning tanatarariaining tee-koo Boto Keperuuꞌnavitu eeꞌnoko noruꞌ pitunavitu biikaang iisi-koo.” ");
INSERT INTO nas_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Teketa tenang teinge tasiꞌpauꞌ teie tee tee iisi bereteꞌkoo sipaamaung minkuvuma teeꞌ nauvuriaꞌ, teka tee kapooꞌkoo teinge Boto Keperuuꞌnavitue eeꞌnoko Noruꞌ Pitunukai nau-antavaarimaung-koo teeꞌ minkuvurikoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Teketa tenang Jiisuuꞌ bakaning barevare-nupoong ninka Sisariaꞌ Pilipai-navuntuꞌkoonooꞌ berora teing niaꞌurima aaꞌpuruꞌ, “Ning Tee Naning-naumpoꞌ Paning-etaing nantoonge baa tammaamaung?” ");
INSERT INTO nas_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Teinge makuꞌaama aaꞌpauꞌ, “Niiꞌninge aaꞌdaamaung, ‘Aung pa tee Jooni Minkinara,’ eeꞌnoko niiꞌninge Eliasi poaing-koong tantaamaung, eeꞌnoko niiꞌninge napoꞌ urikupoong nakaro-nupoong-koo narung, booꞌketa daaꞌaruꞌnung, aiꞌ Jeremaia pa.” ");
INSERT INTO nas_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Eeꞌnoko napoꞌ Jiisuuꞌke aaꞌpuruꞌ teing, “Teka diiꞌke napoꞌ baa tammerimaung ning?” ");
INSERT INTO nas_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Teketa Saimoniꞌ Piitai bariꞌuma aaꞌpuuꞌ, “Daꞌ aaꞌ tee Kumponinge teroita Pakoꞌpariꞌniiꞌ nantoong domamperira tareveriainooꞌkoo, tee Kumponing domantooꞌ bauring.” ");
INSERT INTO nas_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Biraankeraring daꞌ, Jooni bauring, aiꞌ aung tee naninge kansiꞌkoonge nauruaꞌ, teka tee Mmaꞌke paning-koonge nauruing. ");
INSERT INTO nas_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eeꞌnoko ninge aaꞌdamaang, daꞌ tee eeꞌnung Piita, Manto, eeꞌnoko aung-koo boiaꞌkoo eꞌmaniang-koo ninge tee nkaang dootuuꞌ donkong-antavampaing, mosianung-koonge purintoꞌke puruꞌuaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eeꞌnoko ninge daꞌ tee kiiꞌnanka arompaing teing muuꞌ paninung-kooning. Aming kapooꞌ dake anke kansiꞌkoo pinkaꞌeaing deekoꞌ paning-koo teeꞌ pinkaꞌaravaing, eeꞌnoko aming kapooꞌ anke kansiꞌkoo dapaꞌeaing deekoꞌ paning-koo teeꞌ nariꞌ dapaꞌaravainge.” ");
INSERT INTO nas_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Teketa potevuruꞌ teing bakaning barevare-nupoong siraꞌpaavarooꞌnaang tee Kumponinge Pakoꞌpariꞌniiꞌ. ");
INSERT INTO nas_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tenang-eta deto Jiisuuꞌke tee teꞌ Jerusalemaꞌ bera kapooꞌnanka arikananka toraꞌpuaining bakaning barevare-nupoong nau tutumpuruꞌ. Aing aaꞌninge toraꞌantavaavaing: nantoong pankenge, piristiꞌkoong ovontunankai, eeꞌnoko boto naunukai. Eeꞌnoko tee teeꞌ nkoaama dupisiꞌaavaing, eeꞌnoko beenang doong deemparako napoꞌ domamparara daaꞌaravai. ");
INSERT INTO nas_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Teketa Piitai taapoꞌ beꞌantavura teka potevuma aaꞌpuuꞌ, “Bakei makotuaꞌ daꞌ teeꞌ nko-koo, Ovoring. Teeꞌ daꞌkoo nkoaravaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Teketa Jiisuuꞌ bakaning barevare-nupoong-aape bereꞌarama Piita turampuma aaꞌpuuꞌ, “Tokoi beai daꞌ Sietaniꞌ. Daꞌ tee ning-koo baankaꞌ makosi. Dake tee Kumponing bakaang noruꞌ noruꞌeaꞌ, nantoong biikaang noruꞌ narung noruꞌei otong.” ");
INSERT INTO nas_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Teketa Jiisuuꞌke aaꞌpuruꞌ teing bakaning barevare-nupoong, “Naning ning siomui pooꞌnaang piavora deekoꞌ, baka bakaang pia iroꞌ doonko tompimparavaing eeꞌnoko bakaang aaꞌbarataꞌ poruꞌui ning siomumaatoaing. ");
INSERT INTO nas_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Eeꞌkoo, baa tee naning bakaang domaang ning-koo orokovuma baka tare-koo piavoaing tee paaꞌaravaing, teka baa tee naning bakaang domaang ning-koo arooꞌari duaꞌuaing, teie tee napoꞌ daaꞌuaing. ");
INSERT INTO nas_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Eeꞌnoko aming kapooꞌ tampara basiarapeuꞌ naning-koo ookara kapooꞌnanka kansiꞌpoꞌ barampuma okovui baka orariarakotaaꞌ domaang paaꞌaravainaꞌ? Eeꞌnoko naning aming avupeuꞌ tee bakaang domaang paaꞌaruꞌnung napoꞌ mooꞌkoo? ");
INSERT INTO nas_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aiꞌ ning Tee Naning-naumpoꞌ Paning-etaing tee teie Mmaꞌ bakaang meenasie baumari moaing teing ninka nkaning koosinunanka ninka, teketa mooꞌ avorompaing nantoong narunaꞌ narunaꞌ kapooꞌ nkoauꞌning siomparioꞌ. ");
INSERT INTO nas_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Teka ninge masikung naurampimang, diiꞌkoo niiꞌning anke nariꞌ donkoniri otorining-koo mmeꞌ booꞌkoo mantonkiriaꞌ ning Tee Naning-naumpoꞌ Paning-etaing nkaang muuꞌkoo Daurarong˜ deemari moko oomeriaing.” ");
INSERT INTO nas_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Teketa paꞌnokoꞌketa naꞌmung doong tankinuioꞌ Jiisuuꞌke Piita dovang Jeemisi eeꞌnoko baaraꞌmaꞌnung Jooni, bokuvurira iuꞌ isikung-koo deto koinauꞌ teing naing biiꞌka. ");
INSERT INTO nas_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Eeꞌnoko teke teinge ooaioꞌ Jiisuuꞌ bakaang mono aampariꞌarama aaꞌnouꞌ, bakaang oing duaaꞌpinaꞌ siisiouꞌ eeꞌnoko bakaang mononopaꞌ aaꞌnaꞌ kakaaravouꞌ araka-pinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eeꞌnoko tenang teing-ankoi Moosesi naanka Eliasi oroꞌpareta Jiisuuꞌ ninka kareaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Eeꞌnoko Piitai aaꞌpuuꞌ tee Jiisuuꞌ, “Ovoring ee, bakei tampaꞌ niiꞌ anke oꞌnorimaang. Daꞌ piaroko deekoꞌ ninge bare beevaari kaniampaing, nava daꞌ dakanava, nava Moosesi bakanava eeꞌnoko nava Eliasi bakanava.” ");
INSERT INTO nas_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eeꞌnoko tenang tee Piita teeꞌ karoi otoko narunge kamoꞌke sisisiisie teka dakaꞌpuruꞌ, eeꞌnoko teieta kamoꞌketa auronge karoma aaꞌpuuꞌ, “Aung tee nnuring ninge piaavamaung. Ning tee-koo aaꞌnaꞌ dotumaramaung. Taaraveriaing tee.” ");
INSERT INTO nas_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tenang teinge bakaning barevare-nupoonge tee aurong taaravaara avoreaara oing kansiꞌkoo doonko kinkinauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Teka Jiisuuꞌke pora kompurima aaꞌpuruꞌ, “Deto daaꞌdariai, aroreriaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Teketa tenang deto daaꞌarira ookaama niiꞌnara naning ooaavaꞌ, Jiisuuꞌ narung teka ooauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Teketa iuꞌketa depeto siarima Jiisuuꞌke teing orokovuruꞌ tee kapooꞌ ooauꞌnung nauaariarooꞌnaang bera tee Naning-naumpoꞌ Paning-etaing booꞌketa daaꞌaravainooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Teketa teinge bakaning barevare-nupoonge tee niaꞌaama aaꞌpauꞌ, “Teinge boto naunukai aming-koo aaꞌpaamaung Eliasi tee tee-koo Kumponinge Pakoꞌpariꞌniiꞌkoo˜ uroꞌke poaing?” ");
INSERT INTO nas_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuuꞌ, “Masikaꞌ Daari Meekung-koo Eliasi tee pooꞌnaang tampari otong ookara kapooꞌnanka nerivuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Teka ninge aaꞌdampimang, tee Eliasi aaꞌ tee tero pouꞌnung, teka teinge tasiꞌpaavarura tee orakaꞌ piavorouꞌnaꞌ nariꞌ nkoauꞌ tee. Teeꞌ nariꞌ napoꞌ ning Tee Naning-naumpoꞌ Paning-etaing nantoonge sisikeera-antamaavainge.” ");
INSERT INTO nas_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Teketa teeꞌ minkuvuioꞌ teinge bakaning barevare-nupoonge tasiꞌpauꞌ tee eeꞌnung Jooni Minkinara miruꞌui Eliasi teeꞌ minkuvuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tenang teing nantoong karinga-anko poroioꞌ naning narung pora Jiisuuꞌanko kinkinura aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ovoring ee, nnuring piaaveai kookokoaramaung, eeꞌnoko aaꞌnaꞌ sisikeeravokooꞌ. Mmauꞌnamuꞌpie ntaꞌkoo niiꞌnooꞌ ntong-koo duaꞌarakooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aing-anko dakaning barevare-nupoong-anko tavoꞌansioꞌ teinge taare-anta-koo makosiaavaruing.” ");
INSERT INTO nas_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ teing, “Nko diiꞌ masikaꞌanta otoriainge, koontariaing, areꞌ basinaroonge diiꞌ ninka nariꞌ oꞌnorimaatoainge dooroontampiri? Poꞌantaveai tee okiꞌnara aꞌ ning-anko.” ");
INSERT INTO nas_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Teketa tavoꞌuioꞌ Jiisuuꞌke tee maꞌnaang teka akaꞌpuioꞌ teieta nemaka-ita bakoaruꞌ, eeꞌnoko tenang-eta deto taarevouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Teketa teing bakaning barevare-nupoong makenge tee-anko porora aaꞌpauꞌ, “Niiꞌ aming-koo tee maꞌnaang bataꞌkoo makotumpiaꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jiisuuꞌke makuꞌuma aaꞌpuruꞌ, “Diikaang masikaꞌanta bakei okiꞌnung deemparako teeꞌ bataꞌeriarupeuꞌnung. Masikaꞌ naurampimang ninge, diikaang masikaꞌanta tee masitaraꞌkoong sinang-pinaꞌ basi otoꞌderui dei diiꞌke aunteto iuꞌ aaꞌperipeuꞌ, ‘Ankaꞌ diiriꞌdaravai anketa,’ eeꞌnoko tee diiriꞌarapeuꞌ. Teeꞌkoo kapooꞌ diiꞌke nko-koo makosi deeaung otoarupeuꞌ diiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Teka tee aung amuriiꞌ tamung bakoaravarupeuꞌ, naninge kunsiarama eeꞌnoko unkumoarama deekoꞌ makosi temuriiꞌ bataꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Eeꞌnoko tenang teing ookara Kaaleliꞌ porora oosiariraiꞌnange Jiisuuꞌke aaꞌpuruꞌ teing, “Ning Tee Naning-naumpoꞌ Paning-etaing tee nkaning-koo navumainuka-koo narunge tooka kompui tauraꞌmuuꞌnaang nantoong oreng biikaang bireng-koo. ");
INSERT INTO nas_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Teinge dupisiꞌmaavaing, teka beenang doong deemparako napoꞌ domamarara daaꞌmaravaing.” Eeꞌnoko teing bakaning orakaꞌ deeꞌorouꞌ teeꞌpuioꞌ. ");
INSERT INTO nas_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Teketa Jiisuuꞌ bakanavitu ninka Kapaneumeꞌnavuntuꞌkoo basiaririoꞌ taakisi nkanukai porora Piita niaꞌaama aaꞌpauꞌ, “Diikaang nau-antai ee taakisi dootuuꞌnava pankava-koong duaꞌuaung?” ");
INSERT INTO nas_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piitai makuꞌuma aaꞌpuuꞌ, “A, tee aaꞌ duaꞌumaung.” Teketa tenang Piita pava-koo pora mmeꞌ nauvuaruko teie Jiisuuꞌke tutung minkuvuma aaꞌpuuꞌ, “Saimoniꞌ ee, arekeeꞌ noruꞌemaang, ookara dauraronukai kansiꞌkooninge baata-koo taakisi barampaamaung, biurukaaꞌkoo aiꞌ oovuning-koo?” ");
INSERT INTO nas_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piitai makuꞌuma aaꞌpuuꞌ, “Oovuning-eta barampaamaung.” Teketa Jiisuuꞌke aaꞌpuuꞌ, “Tee tee teeꞌkoo dauraronuka biurukaaꞌ teing unaanisi otoꞌnuka, eeꞌnoko ning napoꞌ teeꞌke, unaanisi otoꞌnara. ");
INSERT INTO nas_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Teka makosi neeꞌke mooꞌampeaing noruꞌ orari-antavarampeꞌneeng teing. Enang bera aꞌdoong nuaruꞌkoo airiraravaing, teketa tutunaꞌnu taviꞌnu barampeainu-koo karang kaakeꞌera teka mooniꞌ ooveaing. Oovera nkavera teing averiaing, neekaang taakisi deemparavaing.” ");
INSERT INTO nas_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tenang eeꞌnang napoꞌ teinge bakaning barevare-nupoonge porora Jiisuuꞌ niaꞌaama aaꞌpauꞌ, “Pankaing baa tee-koo muuꞌ paninung-koo?” ");
INSERT INTO nas_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Teketa Jiisuuꞌke narung tootoꞌ bokuvura teing-koo meuꞌ donkong-antavura aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Masikaꞌ naurampimang, diiꞌ diikaang domang bereꞌdariarura deekoꞌ toirekaaꞌpinaꞌ onou-koo diiꞌ teing bakei makosiriaꞌ teꞌ muuꞌ paninung-koo tung-koo. ");
INSERT INTO nas_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Teeꞌkoo baa tee naning baka boonko noruꞌaravaing aung-pinaꞌ tootoꞌpinaꞌ tee tee eeꞌnung muuꞌ paninung-koo pankaing. ");
INSERT INTO nas_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Eeꞌnoko baa tee naning ning nkaang miring-koo onkeonkeꞌuaing narung tootoꞌ okiꞌnara aung-pinaꞌ oroꞌ teie tee onkeonkeꞌmuaing. ");
INSERT INTO nas_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Teka Baa tee naning aing toireꞌ ning masikaꞌantamaamaing-koo narung duaꞌantavuaing tee-koo orara aarumo-koo deekoꞌ tee tee piaaruꞌ. Teeꞌ oroꞌ naning baukoi paravuaruuꞌnung dei tampaꞌ, aiꞌ Kumponinge aaꞌnaꞌ kiimatavuaing tee. ");
INSERT INTO nas_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bakei piaaruꞌnuka kansiꞌnupoong amutemuriaunanka orara aarumo-koo nantoong duaꞌantavaarimaing. Masikaꞌ, teeꞌ oroꞌ aarumo duaꞌanta-koong tee poaing, teka bakei piaaruꞌnuka teing nantoong teeꞌ oroꞌ aarumo tavoꞌantavaavaining! ");
INSERT INTO nas_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Eeꞌnoko dakaang birenge niiꞌnooꞌ kauꞌke duaꞌantaruko deekoꞌ orara aarumo-koo, napuꞌdarara taapoꞌ duaꞌeaing tenauꞌ. Tampaꞌ masikaꞌ tee daꞌ nanauꞌ kopuꞌdarara deꞌdoonima domaang otoi otoꞌnooꞌ beaing, ookanauꞌka otoi ntaꞌkoo otoi-otoꞌkoong-koo duaꞌduꞌneenga. ");
INSERT INTO nas_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Eeꞌnoko napoꞌ dakaang dutai orari-antaruko deekoꞌ kaꞌbantarara taapoꞌ duaꞌeai. Tampaꞌ masikaꞌ tee daꞌ naruta otoi domaang otoi otoꞌnooꞌ beaing, ookaruta otoko mosianung-koong ntaꞌkoo duaꞌdaaꞌneenga. ");
INSERT INTO nas_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Teeꞌkoo tarerariri otoriaing diiꞌke aing-koo narung okiꞌnarekaꞌkoo tamung baaꞌpinaꞌ ooeriꞌneeng, aiꞌ toireꞌ biikaning koosinunakai tee paning-koo uatepa Mmaꞌanko beroma siraꞌpaarimaung baata teing anutua orakaꞌ nkoaarimaing. ");
INSERT INTO nas_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Eeꞌnoko ning Tee Naning-naumpoꞌ Paning-etaing tee nantoong toireꞌ makosinuka pooariruꞌning besiꞌkoo mouꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Arekeeꞌ noruꞌerimang diiꞌke, naning narung daakuꞌ sipisipiꞌ otoꞌevuma otopeuꞌnung eeꞌnoko teing-koo nau pooari dei, teie ee teing niiꞌning mmauꞌ tee-koo mii-koo niiꞌnameng-koo sipurira teu nau besiꞌkoo nanuarupeuꞌ pooarapeuꞌnu? ");
INSERT INTO nas_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Eeꞌnoko masikaꞌ minkuamaang, teie daaꞌura deekoꞌ teu, tee tee bakei aaꞌnaꞌ dotuarapeuꞌ teu-koo eeꞌnu-koo sipisipiꞌnu-koo, bane teing niiꞌning mmauꞌ otoroko pooariarupeuꞌning. ");
INSERT INTO nas_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Teeꞌ nariꞌ napoꞌ tee eeꞌnung Diuma paning-koong koontoꞌ piavoaꞌ narung toireꞌkoo okiꞌnarekaꞌ makosinuka-koong paaꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Naning daꞌmarang-koonge orakaꞌ nkoruko deekoꞌ bera naueai bakaang orakaꞌnko deeꞌ deeꞌka otoresi, eeꞌnoko daꞌ taararuaing deekoꞌ tee dake tampameng-koo barampeing tee. ");
INSERT INTO nas_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Teka daꞌ taararuaruko deekoꞌ niiꞌnara niiꞌnooꞌ kenaankara daꞌ ninka bokuereta nariꞌ beriai tee-anko. Teeꞌ nkoveko ookara kapooꞌnanka makosinaꞌ masikaꞌ siraꞌparavaing kenaankarai niiꞌnooꞌ beenaumoi ooaioꞌ. ");
INSERT INTO nas_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Eeꞌnoko napoꞌ teing taara-koo piavoaruko deekoꞌ dootuuꞌkoo siraꞌpeai. Eeꞌnoko napoꞌ dootuuꞌnupoong taara-koo piavoaruko deekoꞌ koontoꞌ mutaanang-koong-pinaꞌ niiꞌnooꞌ taakisi nkanuka-koong-pinaꞌ nariꞌ nkoveriaing. ");
INSERT INTO nas_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Masikaꞌ naurampimang, aming kapooꞌ diiꞌke anke kansiꞌkoo pinkaꞌeriaing tee napoꞌ paning-koo pinkaꞌari otoainge, eeꞌnoko aming kapooꞌ anke kansiꞌkoo diiꞌke dapaꞌeriaing deekoꞌ, paning-koo teeꞌ nariꞌ dapaꞌari otoainge. ");
INSERT INTO nas_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Napoꞌ eeꞌ naurampiiꞌnaang, diiꞌkoo niiꞌnaankai anke kansiꞌkoo kapooꞌkoo kara naroompereta niaꞌkireko deekoꞌ tee teeꞌ nariꞌ piaroreainaꞌ nko-antavuaing teie Mmaꞌke paning-koonge. ");
INSERT INTO nas_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aiꞌ areꞌ tokoo beenaumo niiꞌnooꞌ kenaanka naroꞌ poroainooꞌ nkaang miring-koo, ning tee teke teing-ankoi nariꞌ oꞌnoaing.” ");
INSERT INTO nas_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Teketa Piitai pora Jiisuuꞌ niaꞌuma aaꞌpuuꞌ, “Ovoring, ninge naning mmarang-koong arekeeꞌning bateie tontaꞌantavampeuꞌ ning orakaꞌ nkomuko deekoꞌ? Aiꞌ ˜kemuꞌka-taae?” ");
INSERT INTO nas_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Teka Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Ninge eeꞌ nauramaꞌnaang, ˜kemuꞌka-taae deeaꞌ, teka teing ˜kemuꞌka-taa tampematomaing amutemuꞌari ˜kemuꞌka-taa kivora-namuꞌpie tontaꞌantaveaing tee daꞌmaikoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Teeꞌkoo tee muuꞌ paninung tee eeꞌ oroꞌpari otong: Narung daurarong˜ otopeuꞌnung, eeꞌnoko teie bakaning botovotonaaꞌnuka biikaang komaaru˜ tee-koo nkoauꞌning nerivuuꞌnaang piavouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Teketa nerivuri otoko naning mmauꞌ koko-kokoreiꞌ mooniꞌ nkavuuꞌnung tee-anko poꞌantavauꞌ bakaang komaaru narivuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Teketa pora teie mooꞌ kasi-antavuaruioꞌ teie bakaang ovoringe eeꞌ minkuvuuꞌ, ‘Ookara-daꞌ, daꞌaang, eeꞌnoko daurukaaꞌ, eeꞌnoko dakaning kapooꞌnanka baave-koong tee komaaru makuꞌaravainaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Teketa teie botovotonaaꞌ tee-koo uroꞌkanooꞌ miinge keemparara eentavarama aaꞌpuuꞌ, ‘Ioꞌ siꞌmera batei ameko ookara kapooꞌnanka makuꞌderompaing.’ ");
INSERT INTO nas_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eeꞌnoko teie bakaang ovoringe teeꞌ oovura bakaang domang aaꞌnaꞌ piaavouꞌ tee-koo, eeꞌnoko unaa-antavuma tontaꞌevuuꞌ tee bakaang komaaru. ");
INSERT INTO nas_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Teka tee eeꞌnung botovotonaaꞌ teketa tenkenura teie niiꞌnung botovotonaaꞌ oovuuꞌ napoꞌ tee-koo nau kiinaꞌnu komaaru otoꞌevuing. Eeꞌnoko teie mooꞌura keniꞌuma aaꞌpuuꞌ, ‘Koontoꞌ makuꞌmemuai tee nkaang mooniꞌ dake nkaveuꞌnung!’ ");
INSERT INTO nas_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Teketa tee eeꞌnung baꞌmaikoꞌ doonko kinkinura eentavarama aaꞌpuuꞌ, ‘Ioꞌ siꞌmera batei ameko makuꞌderompaing.’ ");
INSERT INTO nas_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Teka teie arooꞌuaꞌ teeꞌ minkuarako, nka teie bera kiimatanava-koo daiꞌantavuuꞌ teke otooꞌnaang bera tee komaaru makuꞌuainooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Eeꞌnoko niiꞌning botovotonaaꞌnukai tee teie teeꞌ nkovuko ooaara orakaꞌ deeꞌorora berora tee biikaang ovoring nauauꞌ ookara kapooꞌ teie nkovuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Teketa teie bakaang ovoringe tee botovotonaaꞌ kuung bokuvuuꞌ. Bokuvura aaꞌpuuꞌ, ‘Daꞌ tee bakei orara botovotonaaꞌ! ");
INSERT INTO nas_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ninge teing dakaning komaarunanka eentameioꞌ ookara oꞌantareronsioꞌ dake aming-koo tee daꞌmaikoꞌ nariꞌ botovotonaaꞌ piaavearui teeꞌ ninge piaarantuꞌnaꞌ daꞌ?’ ");
INSERT INTO nas_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Eeꞌnoko teie bakaang ovoringe iiravoma tee kiimata-nupoong tanatanuka-anko kosiꞌuuꞌ teke kiimatavari otooꞌnaang bera ookara komaarunanka makuꞌuainooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Teeꞌ eeꞌnaꞌ nariꞌ teie Mmaꞌke paning-koonge diiꞌ narunaꞌ narunaꞌ nkoruriaing diiꞌmarang tontaꞌantaverereriaruko deekoꞌ diikaang domang-eta.” ");
INSERT INTO nas_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Teketa tenang Jiisuuꞌke tee aung karananka minku bakevura Kaaleliꞌnameng sipura Judiaꞌnavoraꞌaape pareꞌaruꞌ Jooꞌdani-nari-koo amenkaꞌkoonooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Eeꞌnoko nantoong karingai Jiisuuꞌ siompai teꞌ napoꞌ berouꞌ, eeꞌnoko teka taare-antavuruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eeꞌnoko niiꞌning boto keperuuꞌnavitu nariꞌ Jiisuuꞌanko pororaiꞌnange aavavaama aaꞌpauꞌ, “Botoi ee tauraꞌpui otong naninge baꞌaang bataꞌkoo baka piavoma deekoꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ teing, “Diiꞌke ee deeruerima tasiꞌperiaung tee Kumponinge pupuꞌuuꞌnang donkaani eeꞌnoko manikuma nariꞌ nkovuretuꞌnaꞌ? ");
INSERT INTO nas_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Eeꞌnoko aaꞌpui otong Daari Meekung-koo, ‘Teeꞌkoo donkaanie baumararing sipureta baꞌaang ninka pinkaꞌareaing, eeꞌnoko tee tenaanka narung mono deempareaing.’ ");
INSERT INTO nas_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Enang tee, kenaanka deempareaꞌ teka narung deemparesing. Teeꞌkoo kapooꞌ Kumponinge beꞌnuꞌantavuuꞌnung naroꞌka naninge tankaampuaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Eeꞌnoko teinge niaꞌaama napoꞌ aaꞌpauꞌ, “Teka Moosesie aming-koo tauraꞌpuma aaꞌpuuꞌ, ‘Naninge baꞌaang sipuma deekoꞌ narung karavoto˜ daarivuaing nampeesi totoꞌpuing tasiꞌanta-koo?’” ");
INSERT INTO nas_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Teketa Jiisuuꞌke makuꞌurima aaꞌpuuꞌ, “Moosesie teeꞌ tauraꞌpuuꞌnooꞌ diiꞌankaampi siꞌkoo tee diiꞌ diikaang domang ivekaꞌdoriko, teka pupuꞌaruꞌnooꞌke Kumponinge teeꞌ minkuvuaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Teka eeꞌ naurampimang ninge, baa tee naning baꞌaange tutung kaukauro nkovuaruko bataꞌura eeꞌnoko oovunani nampura deekoꞌ teie nampeesi orarivumaung.” ");
INSERT INTO nas_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Teketa bakaning barevare-nupoonge aaꞌpauꞌ tee, “Ei, bakei naning baꞌaang ninka teeꞌ nariꞌ daiꞌaresi otoremaatoaing deekoꞌ nantoong nampeesiariaꞌ otoaing-koo tampaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Teketa Jiisuuꞌke makuꞌuma aaꞌpuruꞌ, “Teeꞌ minkuerimatomanaꞌ ookara nantoonge arooꞌaavarupeuꞌ, teing naing Kumponinge teeꞌ otoꞌkoo miruꞌurimaing deekoꞌ teeꞌ otoropeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aaꞌnomaung-koo: niiꞌning makosiaavaing keꞌde-ita pontoꞌarikooꞌ, eeꞌnoko niiꞌning nantoonge deekoꞌ tuukavaarikooꞌ, eeꞌnoko niiꞌning maroita nampeesi-koo piavoroarukooꞌ muuꞌ paninung narung-koo keiꞌorooꞌnaang. Baa naning teeꞌ otoꞌkoo arooꞌaravaing tee makosi teeꞌ otoaing.” ");
INSERT INTO nas_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Teketa toirekaaꞌ okiꞌnarekaꞌ Jiisuuꞌanko tavoꞌaaruꞌ Jiisuuꞌke bireng panteꞌurira kunsivuriiꞌnaang teing. Teka teinge bakaning barevare-nupoonge poteaarikoꞌ teing tavoꞌaaruꞌning. ");
INSERT INTO nas_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Teing toirekaaꞌ tauraꞌperereriko poroai ning-anko, paraꞌereriaꞌ, aiꞌ tee muuꞌ paninung nantoong amuriiꞌ okovuriaing.” ");
INSERT INTO nas_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Teketa tenang bireng panteꞌurira teing-koo teketa tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Enang tee teketa naning narung Jiisuuꞌanko pora niaꞌuma aaꞌpuuꞌ, “Nau-anta, aming kapooꞌ tampara ninge nkoamira tee domaang oparavaukaꞌnung kompampaing?” ");
INSERT INTO nas_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ tee, “Dake aming-koo ning kapooꞌ tampara nkovepeuꞌnung-koo niaꞌmemaang? Aiꞌ Kumponing narung masikung tampara otong. Daꞌ tee domaang oparavaung-koo tuntaraaꞌnaang piarora deekoꞌ dake tee bakaang botonanka siompeaing.” ");
INSERT INTO nas_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Teie aaꞌpuuꞌ, “Boto areing?” Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Aing eeꞌ oroꞌ botonanka: ");
INSERT INTO nas_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Naning dupisiꞌeaukaꞌ, Nampeesi orarieaukaꞌ, Bakiaaꞌ nkoveaukaꞌ, Daang-koo tuutunampeaukaꞌ, Daumararing deto noruꞌeresi pakuereaing,’ eeꞌnoko ‘Dake tee naning daꞌkoo dueꞌnung daka piaararamanaꞌ nariꞌ teeꞌ piaaveaing.’” ");
INSERT INTO nas_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eeꞌnoko teie nemakai aaꞌpuuꞌ, “Aing ookara teroita tanatavantuꞌning, aiꞌ aming kapooꞌ ninge mmeꞌ nkoampaꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ tee, “Dake ookara dupe-anta-koo piarora deekoꞌ bera kapooꞌnanka dakaning ookara baavevera mooniꞌ nkavera ataꞌoiꞌnuka-koo tankaampeaing. Teeꞌ nkovera Paning-koong kavonanka otoꞌderuaing. Eeꞌnoko ning siomei poai.” ");
INSERT INTO nas_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Eeꞌnoko teie nemakai teeꞌ taaravura teketa orarunsiari tenkenuuꞌ tee kavokavoro mmauꞌpoꞌnung deemparako. ");
INSERT INTO nas_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jiisuuꞌke teeꞌ oovura bakaning barevare-nupoong nauvurima aaꞌpuruꞌ, “Ninge masikaꞌ naurampimang diiꞌ, tee naning kapooꞌ mmauꞌpoꞌnung bakei poreꞌ masikung teꞌ muuꞌ paninung-koo tung-koo. ");
INSERT INTO nas_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eeꞌnoko napoꞌ unampansi naurampiiꞌnaang, kaameliꞌnavoroꞌ bamaruꞌkoong busie tumparavarupeuꞌnaꞌ bakei naning kavonanka-poꞌnung dau basinooꞌ makotuaꞌ Kumponing bakaang muuꞌkoo tung-koo.” ");
INSERT INTO nas_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eeꞌnoko tenang teinge bakaning barevare-nupoonge teeꞌ minkuvuko taaravaara bakei aaꞌnaꞌ taꞌninauꞌ. Eeꞌnoko aaꞌpauꞌ, “Nka enang baa domaang mooꞌaravaing?” ");
INSERT INTO nas_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Eeꞌnoko Jiisuuꞌke teing oovurira aaꞌpuruꞌ, “Nantoong biiꞌka domaang mooꞌkoo makosi deeaꞌ, Kumponinge deekoꞌ ookara kapooꞌ nko-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Teketa Piitai baariꞌuma aaꞌpuuꞌ, “Aung ee, teka niiꞌke ookara kapooꞌnanka niikaning sipampiruꞌnung daꞌ siontampima, eeꞌnoko niiꞌke aming nkavampiaing?” ");
INSERT INTO nas_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jiisuuꞌke makuꞌurima napoꞌ aaꞌpuruꞌ teing, “Ninge masikaꞌ naurampimang, tenang ookara kapooꞌ nerakaꞌparavainang, ning Tee Naning-naumpoꞌ Paning-etaing teke nkanooꞌ baꞌnavaꞌnaniꞌdomai ovorimari baꞌnanampainang paninung meenasie baumaritaaꞌ, teeꞌ nariꞌ napoꞌ diiꞌ kante baꞌnantariri kara simpeꞌerimaatoaing teing kivora-ita kenaanka muuꞌ Isireeli-nupoong-koo ovontuntariri. ");
INSERT INTO nas_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eeꞌnoko ookara nantoonge aing aaꞌning nkaang miring pankaing-anta-koo sipauꞌning: pavananka, biumaraang, biurukaaꞌ toireꞌ, niiꞌnooꞌ biikaang kansiꞌ, teinge tee daakuꞌnamuꞌpie makuꞌ nkavaavaing eeꞌnoko napoꞌ tee barenku domaang oparavaung-koong okovuriaing teing. ");
INSERT INTO nas_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Teka mmauꞌ nantoong ureai otoromaing damaꞌke damaꞌduariaing, eeꞌnoko damaꞌduariri otoromaing ureaavai.” ");
INSERT INTO nas_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tee muuꞌ paninung tee tee-pinaꞌ oroꞌ, naning mintoonau-poꞌnung tero taneꞌke bera nantoong bakanau-koo mintoong-koo bokuvuruꞌnung, naꞌmung doong-koo mintoompariko mooꞌkoo namikue mooꞌuriiꞌnaang tampura; ");
INSERT INTO nas_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Eeꞌnoko arooꞌaririoꞌ teie bakanau-koo botovuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Teketa napoꞌ duaaꞌ deto sirang poioꞌ bera baaveromaa niiꞌning nantoong tamung donkonaioꞌ oovuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eeꞌnoko aaꞌpuruꞌ teing, ‘Diiꞌ aing berira nkanau-koo mintoontariai, eeꞌnoko ninge tee makosinaꞌ mooꞌdampiaing.’ Eeꞌnoko teing berouꞌ mintoong-koo. ");
INSERT INTO nas_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Teketa napoꞌ duaakiꞌnang eeꞌnoko kamunooꞌnang napoꞌ beuꞌ bera teeꞌ nariꞌ tutung nkovuuꞌnaꞌ nkovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Teketa napoꞌ muung-aapenang beraiꞌnange niiꞌning nantoong tamung donkonaioꞌ oovuruꞌ, eeꞌnoko niaꞌuruꞌ teing, aaꞌpuruꞌ, ‘Diiꞌ aming-koo tamung donkoniri otorimaang eꞌmung ootukunaꞌmung kapooꞌ nkoveriaꞌ?’ ");
INSERT INTO nas_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Teinge aaꞌpauꞌ, ‘Naninge bokumuriaruko teeꞌ oꞌnorimaang.’ Eeꞌnoko teie aaꞌpuruꞌ teing, ‘Diiꞌ napoꞌ berira nkanooꞌke mintoontariaing, eeꞌnoko mooꞌ makosinaꞌ nkaveriaing.’ ");
INSERT INTO nas_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Teketa muumpuko teie mintoong okovenunge teing bakaning mintoong-nupoong tarevurikoꞌning bokuvura aaꞌpuuꞌ, ‘Teing nantoong mintoomparirining bokuerira mooꞌ averiaing asiꞌning-eta bera tutunaꞌnupoong-koo basi.’ ");
INSERT INTO nas_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Teing mintoong-nupoong muung-aapenang bokuvurioꞌ tutumpariruꞌning poroioꞌ mooꞌkoo namikunaꞌ avuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Teeꞌkoo teing tutung bokuvurioꞌ mintoong tutumpariruꞌning mmauꞌ nkavaavaing-pinaꞌ noruꞌariruꞌ, teka teing napoꞌ teeꞌ namikunaꞌ mono kante nkakauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eeꞌnoko teinge teeꞌ nkavaara minkuminkuauꞌ tee mintoong okovenung, aaꞌpaama, ");
INSERT INTO nas_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Dake aing damaꞌ mintoong tutumparira narung aua mintoomparirining niiꞌ uipaariiꞌkoo aaꞌnaꞌ mintoomaririning ninka nariꞌ basie mooꞌering.’ ");
INSERT INTO nas_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Teka teie narung teing-koo karavuma aaꞌpuuꞌ, ‘Ee mmaikoꞌ, ninge diiꞌ orakaꞌ nkorampiaꞌ. Arooꞌeriaruinge ee temiku namiku mintoontarira nka-koo? ");
INSERT INTO nas_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nkaverira aung diikaang mooꞌ beriai. Teing damaꞌ bokuaransing teeꞌ nariꞌ avuꞌkoo piamoi oꞌnong. ");
INSERT INTO nas_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Orakaꞌke kapooꞌ nkaang mooniꞌ ninge piamopeuꞌnaꞌ nariꞌ nko-koo? Aiꞌ diiꞌ domang oraruꞌkiring ee ning tampaꞌ avusiroꞌmarioꞌ?’ ");
INSERT INTO nas_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Teeꞌ nariꞌ teing nantoong damaꞌdu-nupoong teing ureaavaining, eeꞌnoko ureaamaing teing damaꞌduariaining.” ");
INSERT INTO nas_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Enang tee Jiisuuꞌ uroitaaꞌ Jerusalemaꞌaape daanto beroma bakaning nanaiꞌketa kenaankara barevare-nupoong taapoꞌ tontaꞌurira teka aaꞌpuruꞌ teing, ");
INSERT INTO nas_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Aing ee, Jerusalemaꞌaape merimang eeꞌnoko teka eeꞌnooꞌka naninge tooka kompui ning Tee Naning-naumpoꞌ Paning-etaing tauraꞌmuuꞌnaang aaꞌning-koo Piristiꞌnuka-koo ovontung eeꞌnoko boto naunuka, eeꞌnoko teinge tee ning dupisiꞌkoo manemaavaing. ");
INSERT INTO nas_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Eeꞌnoko teinge Juꞌdeeaing-anko siꞌmaavaing teka akapeuꞌmaama muraꞌmaavaꞌnaang, eeꞌnoko aaꞌbarataꞌkoo biꞌmaara dupisiꞌmaavaing. Teketa beenang doong deemparako napoꞌ daaꞌmaravaing.” ");
INSERT INTO nas_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Teketa napoꞌ Siebedi baurinketa beuko Jiisuuꞌanko pouꞌ baurinketa ninka. Pora uroꞌkanooꞌ kinkinura eentavaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jiisuuꞌke aaꞌpuuꞌ, niaꞌuma, “Daꞌ aming kapooꞌ piaromaang?” Eeꞌnoko tenie aaꞌpuuꞌ, “Amainta nnurinketa dake enang eeꞌ miruꞌereaing narung tampavine-aape baꞌnanuaing eeꞌnoko narung mareꞌaanavine-aape daꞌkoo tenang daꞌ daurarong deentaravainang.” ");
INSERT INTO nas_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Teketa Jiisuuꞌke temainta aaꞌpuretuꞌ, “Deeꞌke noruꞌereaꞌ tee kapooꞌ eentameremaatomaung. Deeꞌke ee teruꞌ ntonaruꞌ orakaꞌ deeꞌnaruꞌ ning naikampainaruꞌ naikirepeuꞌ? Eeꞌnoko tee sisikeera ning meekaꞌantamaravainge ee meekaꞌantararepeuꞌ?” Eeꞌnoko temaintai makuꞌurema aaꞌpuretuꞌ, “Eeꞌ, neeꞌ makosira.” ");
INSERT INTO nas_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Teketa Jiisuuꞌke aaꞌpuretuꞌ, “Eeꞌ, masikaꞌ deeꞌke naiereaing teruꞌ nkanareng-eta, eeꞌnoko teeꞌ sisikeerai meekaꞌantarareainge ning meekaꞌantamaravainaꞌ, teka tee baꞌnavaꞌnaniꞌ ning-koo tampavine-koo niiꞌnooꞌ mareꞌaanavine-koo ning-koo ninge miruꞌkoo makosi deeaꞌ. Teie Mmaꞌke bampuuꞌnaꞌ baꞌnantareaing.” ");
INSERT INTO nas_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Eeꞌnoko teinge napoꞌ nanaiꞌke teeꞌ taaravaara teinge iikooꞌaaretuꞌ temainta. ");
INSERT INTO nas_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Teketa Jiisuuꞌke ookara naroꞌ bokuvurira aaꞌpuruꞌ, “Diiꞌke noruꞌeri otong teing nantoong Juꞌdeeaing-kooning urantanuka biiꞌka ovontumparimaing eeꞌnoko biikaning pankenankai biikaang iriꞌke nantoong etuaarikooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Teka diiꞌkoo teeꞌ nkoaravaukaꞌnung. Eeꞌ nkoaravaing diiꞌkoo: baa tee naning Kumponing bakaang duta-koo pankaimparaaꞌnaang piavoaing diiꞌkoo meuꞌke tee tee eeꞌnung pakupakunung deemparavaing. ");
INSERT INTO nas_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Eeꞌnoko napoꞌ baa tee naning diiꞌkoo dau basi deemparaaꞌnaang piavoaing tee tee eeꞌnung napoꞌ diiꞌkoo botovotonaaꞌ otoaing. ");
INSERT INTO nas_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ning Tee Naning-naumpoꞌ Paning-etaing teeꞌke, kansiꞌkoo ovoring-pinaꞌ otoꞌkoo moaꞌ, teka pakupakunung deemaraaꞌnaang mouꞌnung, eeꞌnoko nkaang domaang duaꞌkoo teing-koo mmauꞌ booꞌketa simpiriꞌariiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Teketa tenang Jiisuuꞌ teing ninka bakaning barevare-nupoong Jerikooꞌnamono sipaara beroko nantoong karingai siompauꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kenaanka naninka kaputuꞌka taung miiringe baꞌnanuresi otorekoꞌ, eeꞌnoko tenang tee Jiisuuꞌ teketa tankinuko taaravureta tenaanka bokurema aaꞌpuretuꞌ, “Ovoring, Deevitaꞌ bakanaving-koong, piaamereai neeꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Teka nantoong karingai akaꞌpaarema dooroompareeꞌnaang botoaaretuꞌ. Teka tenaanka baruꞌ aaꞌnaꞌ bokuretuꞌ aaꞌpurema, “Ovoring, Deevitaꞌ bakanaving-koong, piaamereai neeꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jiisuuꞌke teꞌ datearara bokuvuretuꞌ tenaanka, teketa aaꞌpuretuꞌ, “Deeꞌ ninge arekeeꞌ nkorampeeꞌnaang piaroremang?” ");
INSERT INTO nas_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tenaankai nauvurema aaꞌpuretuꞌ, “Ovoring ee, neeꞌ ookampeeꞌnaang piamoremang.” ");
INSERT INTO nas_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jiisuuꞌ bakaang domang aaꞌnaꞌ piaavouꞌ tenaanka-koo, eeꞌnoko beekaang duta kompureko namuꞌke bantoreta ookuretuꞌ. Teketa Jiisuuꞌ siompuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tenang Jiisuuꞌ bakaning ninka Jerusalemaꞌ duerueꞌaama Bepasi-namono-koo basiarima Oliveꞌpoꞌnamii-koo otoinooꞌ, Jiisuuꞌke bakaning barevare-nupoong-koo kenaanka uroꞌke botovuretuꞌ aaꞌpurema, ");
INSERT INTO nas_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Temono-koo danto uroꞌkanooꞌke otoi-namono-koo duꞌdareai, eeꞌnoko duꞌdareta namuꞌke doonkiiꞌnavoroꞌ moꞌming-koo biꞌari teke otoko oovereeꞌnaang, bauring-navoroꞌ kampia-navoroꞌ nariꞌ. Tevoroꞌ dapaꞌereta ookeng aꞌ ning-anko poꞌantavereai. ");
INSERT INTO nas_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Niiꞌnung naninge tokoonaꞌ minkurureko nauerema aaꞌpereai, ‘Ovoring piavoing akong,’ eeꞌnoko teie namuꞌke botorureaing aaꞌpuma, ‘Bokuvereri bereai.’” ");
INSERT INTO nas_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aung tee kapooꞌ narunge temuꞌnunge nakaronunge tarampeearama˜ minkuvuuꞌnung dupearaaꞌnaang teeꞌ nkoaruꞌ, tee Daari Meekung-koo aaꞌpuuꞌnooꞌka minkuvuuꞌnung, ");
INSERT INTO nas_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bera naueriai teing Saioni-nupoong, aaꞌperiaing, ‘Ooveriaing, diikaang daurarong˜ diiꞌanko dooroompari banainge pomaang, doonkiiꞌnu kampianu-koo dau baꞌnanui, kauꞌ karenaumo-nu dooroompari mankiꞌnanka nkavumau-koo.’” ");
INSERT INTO nas_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Teketa tenaanka Jiisuuꞌ bakaning-koonaanka barevare-nupoong-naanka bereta teeꞌ nauvuretuꞌnaꞌ nkoaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tenaankai teu doonkiiꞌnu baurinu ninka poꞌantavuresioꞌ teinge biikaang baarong dau taniꞌauꞌ, eeꞌnoko Jiisuuꞌ baaronanka-koo dau baꞌnamparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Teketa nantoong karingai biikaang baaronanka taunge danto taniꞌauꞌ, eeꞌnoko niiꞌninge uurung tovang napuꞌaama taniꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eeꞌnoko teing karinga Jiisuuꞌkoo uroꞌkanooꞌke nanauꞌninge eeꞌnoko damaꞌdu-eta porouꞌninge eura bokiaama aaꞌpaakoꞌ, “Biraanke tee-koo Deevitaꞌ bauring! Biraanke-poꞌnung aung Ovoring bakaang miring-koo pomaang! Biraanke otoi otoaing aꞌdeiꞌke paning-koo nariꞌ!” ");
INSERT INTO nas_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Teketa tenang Jiisuuꞌ Jerusalemaꞌ tumparako ookara nantoong temono-koo-nupoonge irikung-antavarira niaꞌkaama aaꞌpaakoꞌ, “Aung baa?” ");
INSERT INTO nas_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eeꞌnoko nantoong karingai makuꞌaama aaꞌpauꞌ, “Aung tee nakaronara Jiisuuꞌ, Nasaretiꞌnung, teꞌ eeꞌnooꞌ Kaaleliꞌkoonooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Teketa Jiisuuꞌ parang-koo tumparara pava dootuuꞌnava pankava-koong-koo nantoong sipisipiꞌ dovang parekanumpoꞌ baaveveekoꞌning bataꞌuruꞌnung. Aaꞌnoko batanananka mooniꞌ aampariꞌaakoꞌning biikaning eeꞌnoko napoꞌ baꞌnavaꞌnananka kuukuuꞌ baave-aarikoꞌning biikaning teka piakatuꞌuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aaꞌpuruꞌ teing, “Kumponing bakaang kara Daari Meekung-koo tee eeꞌ daariari otong, ‘Nkaang pava tee pava kunsinava tampari otoaing,’ teka diiꞌke ‘bakiaaꞌ nkonuka biikanooꞌ’ deeng-antavering.” ");
INSERT INTO nas_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Teketa kaputuꞌnanka eeꞌnoko dootananka tee-anko porouꞌ teꞌ dootuuꞌnava pankava-koo, eeꞌnoko teka taare-antavuruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Teka teing piristiꞌnuka-koo pankenge eeꞌnoko boto naunukai teeꞌ ooaara domang orakaꞌ deeꞌorouꞌ teie kapooꞌ tampeng taꞌnimpaariiꞌnanka nkovuko eeꞌnoko napoꞌ toireꞌke dootuuꞌnava pankava-koo parang-koo kuunga oovavaama aaꞌpaakoꞌnung-koo, “Daangampampimaatoaing tee Deevitaꞌ bauring.” ");
INSERT INTO nas_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Teinge niaꞌaama aaꞌpauꞌ, “Dake ee taaravemaang tee kapooꞌ toireꞌke minkuaamatomaung?” Jiisuuꞌke makuꞌurima aaꞌpuuꞌ, “Eeꞌ. Teka ee diiꞌke tee Daari Meekung-koo deeruerima noruꞌeriaung aaꞌpumanooꞌka, ‘Toireꞌ eeꞌnoko nerakauꞌnuka biikaang beꞌduuꞌketa dake tee dangaraangang tavoꞌantaveaing?’” ");
INSERT INTO nas_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eeꞌnoko teing teka temono-koo sipurira Beetani-navuntuꞌaape tenkenura teke aatuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Teketa daunaꞌmung tero maata Jerusalemaꞌaape napoꞌ bema Jiisuuꞌ tee peeravouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Teketa piikiꞌnavari taung miiringa oovura teꞌ tevari-anko beuꞌ. Teka sinang tevari-koo oovuaꞌ, paraꞌ narung otoko oovuuꞌ. Teketa aaꞌpuuꞌ tevari, “Daꞌkoo tee napoꞌ sinang biꞌduaukaꞌnung.” Teketa namuꞌke tevari maraꞌoi booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Teketa tenang bakaning barevare-nupoonge tee ooaara teing bakei taꞌninauꞌ eeꞌnoko aaꞌpauꞌ, “Aung avari arekeeꞌ namuꞌke maraꞌoi booꞌparing?” ");
INSERT INTO nas_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jiisuuꞌke teing makuꞌurima aaꞌpuruꞌ, “Masikaꞌ naurampimang ninge, diiꞌ masikaꞌanta otoꞌderuri deekoꞌ, keekooꞌdariaꞌ, aung avari-koo nkoaring-pinaꞌ oroꞌ dau basinaꞌ nkoveriaing, aaꞌnoko aunteto iuꞌ diiꞌke aaꞌperiko, ‘Bitaꞌdarara pirung-koo duaꞌdaravai,’ teeꞌ nkoarapeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Masikaꞌantaveri niaꞌkiriaing deekoꞌ tee nkaveriaing kapooꞌ eentarariaing diikaang kunsi-koo.” ");
INSERT INTO nas_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Teketa tee Jiisuuꞌ pava dootuuꞌnava pankava-koong-koo parang-koo kuung tumparuꞌ, eeꞌnoko teke nau-antavarako piristiꞌkoo ovontung eeꞌnoko nantoong urang-antanuka tee-anko porouꞌ. Porora tanaꞌaama aaꞌpauꞌ, “Tee aung aremuriiꞌ tauraꞌ otoko dake aing kapooꞌnanka nkovemaatoing? Eeꞌnoko napoꞌ baie aruuꞌnunge tee tauraꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Ninge diiꞌ napoꞌ tanaꞌdampiaing, eeꞌnoko ning makuꞌmeriko ninge naurampiaing tee tauraꞌ ning otoꞌmemuko teing aing kapooꞌnanka nkoamaung okoraꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jooni Minkinara-koo niaꞌdampiiꞌnaang: baie tauraꞌpuioꞌ nantoong ntong-koo minkivurima meekaꞌantavurikoꞌ? Kumponinge, aiꞌ tamung nantoonge?” Teketa teing biiꞌka niaꞌeema aaꞌpeekoꞌ, “Areꞌpampiiꞌnaang? Aaꞌpampiko deekoꞌ, ‘Kumponinge,’ teie aaꞌmuriiꞌnaang, ‘Teka diiꞌke aming-koo Jooni masikaꞌantaveriarukoꞌ?’ ");
INSERT INTO nas_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Napoꞌ aaꞌpampiko deekoꞌ, ‘Tamung nantoong-etaing,’ nantoonge tamaariꞌneenga, aiꞌ teinge tee ookarai Jooni nakaronara Kumponing-etaing tasiꞌpai otong.” ");
INSERT INTO nas_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Teketa Jiisuuꞌ makuꞌaama aaꞌpauꞌ, “Niiꞌke aaꞌ noruꞌampiaꞌ.” Teketa Jiisuuꞌke aaꞌpuruꞌ teing, “Eeꞌ, ninge teeꞌke diiꞌ naurampiarooꞌnaang baa tee ning tauraꞌ amuuꞌnung aing kapooꞌnanka nko-koo.” ");
INSERT INTO nas_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Aung minkunaa arekeeꞌ pa noruꞌeriiꞌnaang diiꞌke? Naning narung baurinketa kenaanka otokoꞌnung. Tutunaꞌnung bauring-anko bera aaꞌpuuꞌ tee, ‘Eꞌmung daꞌ bera mintoonau-koo mintoontaravai.’ ");
INSERT INTO nas_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Eeꞌnoko teie makuꞌuma aaꞌpuuꞌ, ‘Ning aaꞌ mearooꞌnaang,’ teka damaꞌke noruꞌ paariarara mintoong-koo nanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Teketa tee bauma napoꞌ niiꞌnung-anko bauring-anko bera teeꞌ nariꞌ minkuvuuꞌ, eeꞌnoko teie aaꞌpuuꞌ, ‘Mera mintoomaraaꞌnaang,’ teka damaꞌke bearuuꞌ mintoong-koo. ");
INSERT INTO nas_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Temainta-koo arerai beuma bakaang pia siompuuꞌ?” Teinge makuꞌaama aaꞌpauꞌ, “Teie tutunaꞌnunge.” Teketa Jiisuuꞌke aaꞌpuruꞌ teing, “Masikaꞌ naurampimang ninge diiꞌ, teinge taakisi nkanukai eeꞌnoko teing manikuꞌ auning nkonuka teinge tee diiꞌ divuꞌdaari muuꞌ Kumponing bakaang-koo beroaing. ");
INSERT INTO nas_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aiꞌ Jooni tee diiꞌanko pora taung koontoꞌnavung naururiko diiꞌke masikaꞌantaveriaruuꞌ, teka teinge taakisi nkanukai eeꞌnoko manikuꞌ auning nkonukai masikaꞌantavaamaung, eeꞌnoko bane bereꞌariko ooverira, diiꞌke tee masikaꞌantaverima bereꞌdariaꞌ otong.” ");
INSERT INTO nas_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Napoꞌ niiꞌnung mirumiruꞌkoo taarakiriai. Aung aaꞌ tee naning narung ovoring otokoꞌnung bakaang kansiꞌkoo mintoonau uaininau keempura. Eeꞌnoko parampuuꞌ tenau, dinkung nenkeꞌuuꞌ uaini miiꞌdoma tenau-koong. Eeꞌnoko pava tarenava siaruaꞌ kanivuuꞌ. Teketa niiꞌning nantoong tenau tare-antavurira niiꞌnameensiꞌkoo tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Teketa batei sinang kavuꞌkoong dueꞌuko teie bakaning botovotonaaꞌnuka botovuruꞌ teing-anko uaini tarenuka-anko bakaang baarauni˜ tenau-koong nkaevaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Teketa teinge tenau tarenukai teing bakaning botovotonaaꞌnuka mooꞌaarima daiꞌaaruꞌ, narung murasiavaama niiꞌnung dupisiꞌauꞌ, teketa beenaumo-nung kapange tavaama dupisiꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Teketa napoꞌ teie ovoringe niiꞌning mmauꞌ botovotonaaꞌnuka napoꞌ teing-anko botovuruꞌ tutunaꞌnamuꞌkoo botovuruꞌning-koo dau basining, teketa teinge tenau tare-antavuruꞌninge teeꞌ nariꞌ tutunaꞌning nkoaaruꞌnaꞌ nkoaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Asiꞌnaꞌmoo masikaꞌmoo teie bauring botovuuꞌ teing tarenuka-anko, eeꞌ noruꞌura, teing tee nnuring-koo amaiaaꞌoroaing. ");
INSERT INTO nas_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Teka teing tare nkonukai tee bauring ooaara teinge biiꞌka kareaama aaꞌpaakoꞌ, ‘Tee aung eeꞌnung barenku okovuaing. Aiaꞌ dupisiꞌampiaing tee, barenku okomuriainaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Teketa teinge kompaara tee uaininau-eta damaꞌdu duaꞌaara teka dupisiꞌauꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Eeꞌnoko tenau okonarai pora teing tenau tarenuka arekeeꞌ nkovuriaing?” ");
INSERT INTO nas_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Teinge aaꞌpauꞌ, “Teie aaꞌ teing maarekusiꞌnuka bakei maremaarenooꞌ basi-antavuri dupisiꞌuriaing, eeꞌnoko tee tenau teie niiꞌning napoꞌ tare-antavuriaing baarauni˜ tenau-koong avaamatoaining sinang kavaama.” ");
INSERT INTO nas_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Teketa Jiisuuꞌke aaꞌpuruꞌ teing, “Diiꞌke ee tee Daari Meekung-koong kara deeruerima damaꞌ nkoaravainaꞌ tasiꞌperiaung aaꞌpui otoinooꞌka, ‘Tereꞌ eeꞌnareꞌ kapanareꞌ pava kaninukai pooreꞌaama duaꞌauꞌnareꞌ ookutunava-koo eꞌmanianareꞌ tumanareꞌ deemparioꞌ tasiꞌpauꞌ damaꞌke. Ovoringe teeꞌ eeꞌnaꞌ nko-antavuuꞌ eeꞌnoko bakei taꞌnimpaariiꞌ niikaang duta-koo.’ ");
INSERT INTO nas_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Teeꞌkoo ninge naurampimang, tee muuꞌ Kumponing bakaang tee diiꞌ pariꞌduriaing bera teing nantoong sinang tampara tavoꞌantavaavaining avuriai. ");
INSERT INTO nas_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Eeꞌnoko ookara nantoong tereꞌkoo tasiꞌpaavaꞌ tupampariaining tee biiꞌka pisiraꞌariaing, bera baa tee naning tereꞌ dau duaꞌaravaing tee tereꞌke puutuvuaing.” ");
INSERT INTO nas_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Teketa tenang teinge piristiꞌkoo ovontunge eeꞌnoko Boto Keperuuꞌnavitue Jiisuuꞌ bakaang kara mirumiruꞌ taaravaara tee teing tasiꞌpariruꞌ teing eeꞌning minkuvuruꞌnung Jiisuuꞌke. ");
INSERT INTO nas_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Teka tee daiꞌaavaꞌnaang taung besiꞌaama nantoong karinga-koo avoreaakoꞌ, nantoonge tee eeꞌnung nakaronung noruꞌai otoinooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Napoꞌ Jiisuuꞌke kara mirumiruꞌpoꞌnung nauvurima aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tee muuꞌ paninung napoꞌ tee teeꞌ oroꞌ narung dauraronge˜ bauring nampeesiaraaꞌnaang paroro pankaing maamu-antavuuꞌnung-pinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Teie tee bakaning botovotonaaꞌnuka botovuruꞌ teing nantoong paroro-koo paraꞌ avaaruꞌning bokuaariko porooꞌnaang, teka teing kupiꞌorora poroaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Teketa teie napoꞌ niiꞌning botovotonaaꞌnuka botovurima aaꞌpuruꞌ, ‘Berira nauereriaing teing ninge paraꞌ avorontuꞌning tee nkaang taamang emuꞌ maamuari otong. Aaꞌnoing boromakaꞌ pankeng biꞌaransi, kampianing nunkemparamaing nariꞌ. Enang tee ookara kapooꞌnanka tee maamu-antavari otong. Poroaing enang nampeesi-koong paroro-koo.’ ");
INSERT INTO nas_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Teka teinge taaravaavaꞌ tenkenauꞌ, aaꞌnouꞌ narung bakanooꞌ mintoong-koo nanuuꞌ, niiꞌnung mooniꞌ besiꞌkoong-koo nko-nko-koo nanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Eeꞌnoko niiꞌninge teing bakaning botovotonaaꞌnuka mooꞌaarima pooreꞌaarima tavaarira dupisiꞌaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Eeꞌnoko tee daurarong bakei iiravouꞌ bera teie bakaning piatooronuka˜ botovurioꞌ berora piniaaruꞌ teing dupisiꞌ nkonuka, eeꞌnoko biikaang osi tai-antavauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Teketa aaꞌpuruꞌ teing bakaning botovotonaaꞌnuka, ‘Paroro tee nampeesi-koong maamuari otong, teka teing nantoong paraꞌ avorontuꞌning teing makosinuka deempariarura poroaruining. ");
INSERT INTO nas_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Berira nantoong kunekuneꞌnairu-koo naniriaing eeꞌnoko baata teka meuꞌpereriaining ookara paroro-koo paraꞌ averereriai.’ ");
INSERT INTO nas_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Teketa teing botovotonaaꞌnuka taung sionairue nanaama ookara nantoong bokuaaruꞌ meuꞌpaaruꞌning ookamuriiꞌka nantoong, oreng eeꞌnoko tampeng. Eeꞌnoko teketa tee tevaꞌ nampeesinava baraneeꞌke aaꞌnaꞌ maantoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Teketa tenang daurarong kuung poma baraneeꞌ oovuriiꞌnaang teka naning narung nampeesi-koong paroro-koo mononopaꞌ kurumparavaruuꞌnung oovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Teketa niaꞌuma aaꞌpuuꞌ tee, ‘Mmaikoꞌ ee, daꞌ arekeeꞌ aꞌ poi nampeesi-koong paroro-koo mononopaꞌ kuruntaravaung?’ Teka tee naning karoaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Teketa dauraronge teing bakaning pakupaku-nupoong nauvurima aaꞌpuruꞌ, ‘Daiꞌeriai tee aung ookeng kauꞌ eeꞌnoko bireng. Teketa aꞌdang damaꞌdu duaꞌeriai mutaananooꞌ, teꞌ eeꞌnooꞌ nantoong biromparima siꞌdaꞌ dovang kakirinkuarimatoainooꞌ sisikeera-koo otoroi.’ ");
INSERT INTO nas_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Teeꞌ nariꞌ nantoong mmauꞌ paraꞌ avuꞌniiꞌnuka otorong, teka okiꞌning naing miruꞌuriaing paninung muuꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Teketa teing Boto Keperuuꞌnavitu tenkenaara taung besiꞌauꞌ Jiisuuꞌ dauaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Teketa biikaning barevare-nupoong Jiisuuꞌanko botoaaruꞌ. Eeꞌnoko Eerotiꞌ bakanavitu ninka nariꞌ berora aaꞌpauꞌ, “Nau-anta ee, niiꞌke daꞌ noruꞌdampiri otong naning masikung narung minku. Kumponing bakanavung taung nau-antaverimaung miruꞌari otoinaꞌ masikaꞌ. Tankaang-anta-pinaꞌ oroꞌdaravaunge, aiꞌ nantoong-koo amaiaaꞌdoaunge biikaang miring noruꞌema. ");
INSERT INTO nas_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Enang naumeriaing niiꞌ dake noruꞌemanaꞌ: Arekeeꞌ, niiꞌke Juꞌnupoonge ee daurarong˜ pankaing, Siisaꞌ˜, Roomaꞌnung, taakisi avuꞌkoo makosi, aiꞌ makosi deeaꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Teka Jiisuuꞌke tee biikaang noruꞌ orara noruꞌura aaꞌpuruꞌ, “Diiꞌke ampirinunukai ning aming-koo dauaꞌmerimaang? ");
INSERT INTO nas_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ioꞌ mooniꞌnu naumeriai teu taakisi-koo duaꞌerimaung.” Eeꞌnoko teinge mooniꞌnu nau tavoꞌauꞌ tee-anko. ");
INSERT INTO nas_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eeꞌnoko Jiisuuꞌke niaꞌurima aaꞌpuruꞌ teing, “Au-koo aung boreꞌ uuꞌaaꞌ baa-koong aaꞌnung miring daariari otong?” ");
INSERT INTO nas_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Teinge aaꞌpauꞌ, “Siisaꞌkoong.” Teketa teie aaꞌpuruꞌ teing, “Tee tee averiaing teing kapooꞌ Siisaꞌ bakaning tee-anko, eeꞌnoko Kumponing bakaning Kumponing-aape averiai.” ");
INSERT INTO nas_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Teketa tenang teeꞌ taaravaara teing bakei taꞌninaara tee teka sipaara tenkenauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Teꞌmung eeꞌnaꞌmung napoꞌ noruꞌ pitunavitu-koo niiꞌning Jiisuuꞌanko nianiaꞌ ninka porouꞌ, booꞌketa napoꞌ daaꞌ masikaꞌantavaavaꞌnavitu. ");
INSERT INTO nas_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Porora avakareaama aaꞌpauꞌ, “Nau-anta, Moosesie eeꞌ naumurima daarivuuꞌ, ‘Naning narung booko baꞌaang otoko toireꞌ otoaꞌ tee donkaani baaraꞌmaꞌnunge nampuaing teni naaro tee ninka bataata booꞌparuꞌnung tootoꞌ paraevureeꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Urikamuꞌ tee namaiaꞌ naroꞌka paꞌnokoꞌketa kenaanka niiꞌkoo otorokoꞌnung. Eeꞌnoko tutunaꞌnung nampeesiarara booꞌparuꞌ bauring otoaꞌ. Eeꞌnoko baaraꞌmaꞌnunge teni manikuma nampura teeꞌ nariꞌ booꞌparuꞌ bauring otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Teketa beenaumo-nunge. Teeꞌ nariꞌ temaiaꞌkoo ookara-koo paꞌnokoꞌketa kenaanka-koo nkoaruꞌ. Ookara boorouꞌ biurukaaꞌ otoroaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Eeꞌnoko asiꞌnaꞌmoo teni nani manikuma booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Enang teꞌmung asiranaꞌmung booꞌnuka daaꞌariainaꞌmung teni ani arera temaiaꞌkoo paꞌnokoꞌketa kenaanka-koo baꞌaang deemparavainani? Aiꞌ teinge tee ookarai nampauꞌnanie teni.” ");
INSERT INTO nas_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jiisuuꞌke makuꞌuma aaꞌpuruꞌ teing, “Diiꞌ bakei papaarararimaung tee Daari Meekung-koong kara eeꞌnoko Kumponing bakaang purintoꞌ noruꞌeriaruma. ");
INSERT INTO nas_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Damaꞌke nantoong booꞌketa daaꞌarira teing nampeesiariaꞌ otoroaing Kumponing bakaning koosinunanka paning-etaning-pinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Teka tenaare-koo booꞌketa napoꞌ daaꞌnaare-koo diiꞌke ee deeruerima tasiꞌperiaung aung Kumponinge Daari Meekung-koo aaꞌduruꞌnung, ");
INSERT INTO nas_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ning tee Kumponing teing aing aaꞌning temuꞌnupoong biikaang: Eebaraamiꞌ, Aisakeꞌ, Jeekopiꞌ. Teing ninka komeeri Oꞌnoi Oꞌnomaung ning.’? Teeꞌ minkuvuuꞌnung-koo tasiꞌpampiri otong ookara bakaning deempariri domantooꞌnuka otorong Kumponing bakaang duta-koo, booꞌnuka deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Teketa nantoong karingai tee bakaang nau-anta taaravaara bakei taꞌninauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jiisuuꞌke noruꞌ pitunavitu karantavuriaruioꞌ taaravaara Boto Keperuuꞌnavitu biiꞌka naroꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Eeꞌnoko teketa narunge teing-koo boto-koo norukasiꞌke Jiisuuꞌ paaravuma nianiaꞌ niaꞌuma aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nau-anta, botonanka-koo arera pankaing masikung boto?” ");
INSERT INTO nas_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ tee, “Aung boto pankaing masikung: ‘Dake pankaruntoompeaing Ovoring dakaang Kumponing ootukunung dakaang domang-eta eeꞌnoko ootukunung dakaang uraang-eta˜ eeꞌnoko ootukunung dakaang onou-eta.’ ");
INSERT INTO nas_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aung tee ookara-koo boto-koo tutunaꞌnung eeꞌnoko pankaing masikung. ");
INSERT INTO nas_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Eeꞌnoko tee kenaanka-nung boto tee tee-pinaꞌ nariꞌ oroꞌ aung: ‘Dake tee naning daꞌkoo dueꞌnung daka piaararamanaꞌ nariꞌ teeꞌ piaaveaing.’ ");
INSERT INTO nas_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ookara botonanka eeꞌnoko nakaro-nupoong biikaning kara aing-koo kenaanka-koo boto-koo biꞌariri otorong.” ");
INSERT INTO nas_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tenang eeꞌnang teing Boto Keperuuꞌnavitu naroꞌarira otoroko Jiisuuꞌke biikaang noruꞌ tante-anta-koo niaꞌurima aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tee naning Kumponinge Pakoꞌpariꞌuuꞌnung˜ nantoong domampuri tarevuriainooꞌkoo arekeeꞌ noruꞌerimaung, baa bakanaving-koong deempari tavoꞌaravainge?” Teinge makuꞌaama aaꞌpauꞌ, “Deevitaꞌ bakanaving-koong deempari tavoꞌaravaing.” ");
INSERT INTO nas_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Eeꞌnoko teie aaꞌpuruꞌ teing, “Nka Deevitaꞌ arekeeꞌkoo Tanuaang Meekunge karantavuko tee Ovoring tampuuꞌ Daari Meekung-koo aaꞌpumanooꞌka, ");
INSERT INTO nas_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Teie Ovoringe nkaang Ovoring aaꞌpuuꞌ, “Aꞌ, ning-koo tampavine-koo baꞌnaniai bera ninge dakaning kare-nupoong dakaang kauꞌkoo boonavete-koo siparampainooꞌke basi.” ’ ");
INSERT INTO nas_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Teeꞌ minkuvuma Deevitaꞌke tee Pakoꞌpariꞌniiꞌ Ovoring Kumponing-pinaꞌ basi tampuuꞌnung. Enang Kumponing deemparako arekeeꞌ napoꞌ Deevitaꞌ bakanaving-koong tampaapeuꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Teeꞌ minkuvuioꞌ naninge makuꞌuma kapooꞌ minkuvuaꞌ, eeꞌnoko teꞌmung-eta deto teing ookara nantoong avoreauꞌ Jiisuuꞌ niiꞌning nianiaꞌ niaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Teketa Jiisuuꞌke nantoong karinga eeꞌnoko teing bakaning barevare-nupoong aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Teing boto naunuka eeꞌnoko Boto Keperuuꞌnavitu Moosesi paariauꞌning bakaang boto nau-anta-koo. ");
INSERT INTO nas_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Teeꞌkoo diikaning ovoꞌmaꞌnuka deempariko taaraverereriaing kapooꞌ nauraariaining, teka kapooꞌnanka teinge nkoaavaining diiꞌke nkoveriaukaꞌ, aiꞌ teinge tee kapooꞌ daankiaamaung nko-nkoi siong-antavaavaung. ");
INSERT INTO nas_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Teinge tee poreꞌantavaarimaung mmauꞌ boto nantoonge tareaavaꞌnaang botoaarima, teka biiꞌka teinge okiꞌnooꞌ tareaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ookara kapooꞌnanka teinge nkoaamaing nantoonge oo-koo maroita nkoaamaung. Aaꞌnomaung: dootuuꞌkoong taaꞌniꞌanta teing dapapiꞌ daiꞌarikooꞌ, eeꞌnoko dootuuꞌkooning baarong-koong puraparari bakei isikeng kurumparikooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Paroro kante-koo teꞌ ovontung biikanooꞌ baꞌnang-koo piavorokooꞌ. Napoꞌ pava dootuuꞌnairu-koo baꞌnavaꞌnaniꞌnanka tampeng-koo baꞌnaniaakooꞌ nantoonge ankampaariaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Napoꞌ nantoong kunekuneꞌnairu-koo nantoonge onkeonkeꞌaarimaatooꞌnaang piavorokooꞌ ‘Nau-anta Pankaing’ tampaarima. ");
INSERT INTO nas_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Teka diiꞌ teing ‘Nau-anta Pankaing!’ tantaariaukaꞌning, aiꞌ diikaang Siong-anta tee narung masikung otong, eeꞌnoko diiꞌ teing namaiaꞌ makosinuka. ");
INSERT INTO nas_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Eeꞌnoko napoꞌ naning narung anke kansiꞌkoo diuma tamperiaukaꞌ, aiꞌ diiꞌ teing narung masikung Diuma otong, eeꞌnoko tee tee paning-koo otomaung. ");
INSERT INTO nas_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Eeꞌnoko nau-antananka pankeng tantaariaukaꞌ, aiꞌ diiꞌ teing tee narung Nau-anta Pankaing otoꞌderuring tee Kumponinge Pakoꞌpariꞌniiꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Naning diiꞌkoo pankaing masikung tee eeꞌnung diiꞌkoo meuꞌke pakupaku nkovuaing. ");
INSERT INTO nas_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Baa tee naning baka deto basiaramaung damaꞌke doonko basi deemparavaing, eeꞌnoko baa tee naning boonko noruꞌari otomaung tee tee eeꞌnung deto basi deemparavaing. ");
INSERT INTO nas_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bakaꞌ piaaruꞌnuka diiꞌ boto naunuka eeꞌnoko diiꞌ Boto Keperuuꞌnavitu, bakei toraꞌkiriaining diiꞌ ampirinunuka. Diiꞌ eeꞌning diiꞌka muuꞌ paninung-koo tuntariaruma niiꞌning napoꞌ tauraꞌperereriarukooꞌ teꞌ tumparipeuꞌning. ");
INSERT INTO nas_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Bakaꞌ piaaruꞌnuka diiꞌ boto naunuka eeꞌnoko diiꞌ Boto Keperuuꞌnavitu, bakei toraꞌkiriaining diiꞌ ampirinunuka. Diiꞌke naaroonku biikaning kapooꞌnanka pariꞌererima opevurerererikooꞌ kunsi isikanankai dakarakaꞌdarima nantoonge tampaꞌ ooraariiꞌnaang. Teeꞌkoo diiꞌ teing bakei aaꞌnaꞌ kiimatarariaining. ");
INSERT INTO nas_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bakaꞌ piaaruꞌnuka diiꞌ boto naunuka eeꞌnoko diiꞌ Boto Keperuuꞌnavitu, bakei toraꞌkiriaining diiꞌ ampirinunuka. Nanunanuꞌ isipoꞌ basi nkoverikooꞌ pirung-koo daue eeꞌnoko kansiꞌkoo narung naning diiꞌkoo bereꞌaraaꞌnaang, eeꞌnoko tenang diiꞌanko poko diiꞌke bakei diiꞌkoo dau basinaꞌ mosianung-koo nanuꞌkoong deeng-antaverikooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Bakaꞌ piaaruꞌnuka diiꞌ kaputuꞌdariri nantoong taung nau-anta-koo piarorimaing aaꞌperima, ‘Naning dootuuꞌnava pankava tampuma marakavaravaing tee kapooꞌ otoaꞌ, teka baa tee naning dootuuꞌnava pankava-koong kooro tampuma marakavaravaing tee tee daiꞌari otong tee bakaang maraka-anta dupe-anta-koo.’ ");
INSERT INTO nas_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Diiꞌ bakei kaputuꞌnuka mutaanang-kooning, arera teing-koo aing-koo aaꞌning-koo dau basi: kooro niiꞌnooꞌ dootuuꞌnava pankava tee kooro meekaꞌantavumanava? ");
INSERT INTO nas_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Napoꞌ aaꞌperikooꞌ diiꞌke, ‘Naning boonturoma-koo marakavarako kapooꞌ nkoaravaukaꞌnung, teka naning teꞌ kapooꞌ darimpaamaung-koo marakavarara deekoꞌ teie tee tee dupe-antavuaing.’ ");
INSERT INTO nas_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Diiꞌ bakei kaputuꞌnuka mutaanang-kooning, arera kapooꞌ pankaing masikung teing-koo, tee kapooꞌ darimpaamaung aiꞌ teꞌ boonturoma tee kapooꞌ teꞌ darimpaamaung meekaꞌantavumaung? ");
INSERT INTO nas_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Teeꞌkoo baa naning boonturoma-koo marakavaravaing tee teꞌkoo marakavaravaing eeꞌnoko ookara kapooꞌnanka teke otoroining-koo nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Eeꞌnoko baa tee naning dootuuꞌnava pankava-koo marakavaravaing tee teva-koo marakavaravaing eeꞌnoko tee-koo Kumponing-koo teke otomaung-koo nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Eeꞌnoko baa tee naning paning-koo marakavaravaing tee tee Kumponing bakanooꞌ baꞌnanui tare nkoroma-koo marakavaramaang eeꞌnoko napoꞌ tee-koo teꞌ baꞌnanui otomaung-koo nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Bakaꞌ piaaruꞌnuka diiꞌ boto naunuka eeꞌnoko diiꞌ Boto Keperuuꞌnavitu, bakei toraꞌkiriaining diiꞌ ampirinunuka, aiꞌ diiꞌke tee avutevuꞌ napoka dovang okiꞌnarekaꞌ kivoranaꞌ tankaamperima baarauni-koo˜ namanto Kumponing averikooꞌ, sirivitaꞌ dovang koꞌdompuuꞌ, teka teing kapooꞌ boto-koo pankeng damaꞌduerikooꞌ aaꞌning: aarumo koontoꞌnaꞌ simpeꞌ, aarumo piaa unaa-anta-poꞌnung, eeꞌnoko Kumponing masikaꞌantavui kakeꞌiiari otoꞌ. Aing eeꞌning teing diiꞌke naroꞌka nko-koo makosining. ");
INSERT INTO nas_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Diiꞌ kaputuꞌnuka taung nau-anta-koo piarorimaing, okiꞌnarekaꞌ kapooꞌnanka aaꞌnaꞌ pukerariri maaꞌerikooꞌ, teka kapooꞌ pankaing opoꞌ dunkumperikooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Bakaꞌ piaaruꞌnuka diiꞌ boto naunuka eeꞌnoko diiꞌ Boto Keperuuꞌnavitu, bakei toraꞌkiriaining diiꞌ ampirinunuka˜. Diikaning kaapunanka-koo eeꞌnoko bantovantoꞌnanka-koo damaꞌdu aaꞌnaꞌ kiiroraaꞌantaverikooꞌ duuꞌperima, teka kuung teing-koo bakiaaꞌke maantoꞌ, eeꞌnoko mono bakaang pia narung siong. ");
INSERT INTO nas_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Diiꞌ Boto Keperuuꞌnavitu kaputuꞌnuka, tutung kuung kiiroraaꞌantaverimaatoai teing diikaning kaapu eeꞌnoko bantovantoꞌnanka aaꞌnoainaꞌ damaꞌdu nariꞌ kiiroraaꞌ otoai. ");
INSERT INTO nas_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bakaꞌ piaaruꞌnuka diiꞌ boto naunuka eeꞌnoko diiꞌ Boto Keperuuꞌnavitu, bakei toraꞌkiriaining diiꞌ ampirinunuka. Diiꞌ kuvi dakoꞌdoma damaꞌdu aaꞌnaꞌ kiiroraaꞌantavaamaing-pinaꞌ oroꞌnuka damaꞌdu-eta tampaꞌ oroꞌparaaꞌnaang, teka kuung bakei booꞌnuka-koong makeꞌke maantoꞌ eeꞌnoko amutemuriiꞌ kuꞌmiꞌnanka. ");
INSERT INTO nas_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Teeꞌ nariꞌ diiꞌ damaꞌdu-eta nantoonge koontoꞌnuka-pinaꞌ ooraarimaung teka diiꞌkoo kuung ampirinunge˜ maantoꞌ eeꞌnoko boto totoꞌke. ");
INSERT INTO nas_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Bakaꞌ piaaruꞌnuka diiꞌ boto naunuka eeꞌnoko diiꞌ Boto Keperuuꞌnavitu, bakei toraꞌkiriaining diiꞌ ampirinunuka. Diiꞌke nakaro-nupoong dakoꞌaaruꞌnooꞌ tampaꞌ kanierikooꞌ, koontoꞌnuka biikaning dakoꞌdomanairu tampaꞌ nepunepuꞌerikooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aaꞌperimaung, ‘Niiꞌ tenang nakaro-nupoong niikakatauro otorokoꞌnang oꞌnori dei nakaro-nupoong dupisiꞌaariko pakumariarupeuꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Teka daang dakarakaꞌdarima teeꞌ minkurarikooꞌ, aiꞌ diikaang aarumoi teing biurukaaꞌ siraꞌdurimaung nakaro-nupoong tero dupisiꞌaaruꞌning. ");
INSERT INTO nas_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aiaꞌ enang dupe-antaveriaing teeꞌ nariꞌ tee temuriiꞌ aarumo orara diikakatauroi tero nkoaakoꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Diiꞌ borukoporonuka, boruꞌ doparopa-poꞌnung baurukaaꞌ, arekeeꞌ napoꞌ dontaꞌperipeuꞌ tenang Kumponinge tuutunanturira mosianung-koo beꞌkoo tanturiko? ");
INSERT INTO nas_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Teeꞌkoo ninge nakaro-nupoong diiꞌanko botoarampaing eeꞌnoko Daari Meekung-koo norukasiꞌnuka eeꞌnoko nau-antanuka. Niiꞌning tee teing-koo diiꞌke dupisiꞌerereriaining aaꞌbarataꞌ dovang-koo biꞌerererima. Eeꞌnoko niiꞌning teing muraꞌereriaining diikaning pava dootuuꞌnanka-koo kuunge osi kanteveri bataꞌererima. ");
INSERT INTO nas_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tee tee ookara urikupoong koontoꞌnuka dupisiꞌaarikoꞌning-koong tuutunang diiꞌke komperiaing teing-koo Eebeloꞌketa bera Sakaraiaꞌkoo basinooꞌka, tee Sakaraiaꞌ tee Berakaia bauring boonturoma eeꞌnoko meekavaro-koo meuꞌka diiꞌke diumaraang-koo kuunge dupisiꞌeruꞌnung teꞌ dootuuꞌnava pankava-koo. ");
INSERT INTO nas_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Masikaꞌ naurampimang, aing teing ookara kapooꞌnanka enanavarang-koo basiarako toraꞌkiriaing.” ");
INSERT INTO nas_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Oi bakaꞌ Jerusalemaꞌnupoong, Jerusalemaꞌnupoong, dupisiꞌerererimaing Kumponing bakaning nakaro-nupoong, eeꞌnoko teing diiꞌkoo botovurimaing kapange tooꞌpererima dupisiꞌerererikooꞌ, arekeeꞌning batei-koo ninge diiꞌ naroꞌkoo karirampimaung kokoreeꞌke baurukaaꞌ kupaꞌkoo boong naroꞌurimanaꞌ, teka diiꞌ arooꞌdariaung. ");
INSERT INTO nas_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aing ee, Kumponinge diikanooꞌ osi siꞌduring diiꞌke diiꞌka tare-koo bera nuampavooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eeꞌnoko naurampimang diiꞌke tee ning napoꞌ oomeriarooꞌnaang bera tenang batei aaꞌmeriainang, ‘Biraankenung tee naning Ovoring bakaang miring-koo pomaatomaung.’” ");
INSERT INTO nas_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Teketa Jiisuuꞌ dootuuꞌnava pankava-ita siarara tenkenuko bakaning barevare-nupoong tee-anko porouꞌ avatevaronanka-koo nau-antavaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jiisuuꞌke aaꞌpuruꞌ teing, “Aing kapooꞌnanka diiꞌke ee ooverimang? Masikaꞌ naurampimang, teing aing kapananka teing tuurampaavaining. Teinge piatooroi deroaama nareꞌ niiꞌnareꞌkoo daue panteꞌarioꞌ sipaavaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Teketa Jiisuuꞌ teke Oliveꞌpoꞌnamii-koo baka baꞌnanuioꞌ bakaning barevare-nupoong tee-anko porora biiꞌka otoroi niaꞌaama aaꞌpauꞌ, “Naumeriai tee areꞌmoong teeꞌ nkoaravaing, eeꞌnoko taaꞌniꞌanta aming daꞌ poaing-koong, eeꞌnoko aung batei oparavaing-koong taaꞌniꞌanta aminge?” ");
INSERT INTO nas_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Teketa Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Bakei, tarerariri otoriaing nantoonge poo-antaraariꞌneeng. ");
INSERT INTO nas_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aiꞌ nantoong mmauꞌke tee poroma nkaang miring tampaama aaꞌpaavaing, ‘Ning tee eeꞌnung Kumponinge Pakoꞌpariꞌniiꞌ,’ eeꞌnoko teeꞌ nkoarima nantoong mmauꞌ tosiaariko siompaariaing. ");
INSERT INTO nas_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Eeꞌnoko diiꞌke tee karenanka tavoꞌkuko eeꞌnoko tamung minkuaako taaraveriaing, teka diiꞌ eeꞌning tarerariaing diiꞌ domang puraaniriꞌneeng tee-koo, aiꞌ teing teing kapooꞌ teeꞌ oroꞌnanka nkoaravaining, teka botu mmeꞌ basiaravaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Narung kansiꞌ iꞌamparama niiꞌnung kansiꞌ turampuainge. Eeꞌnoko narung muuꞌ iꞌamparama niiꞌnung muuꞌ turampuainge. Eeꞌnoko napoꞌ nantoong peera-koo booroainge, eeꞌnoko uꞌmiꞌnanka nkoaravai niiꞌning kansiꞌnanka-koo. ");
INSERT INTO nas_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aing teing tamung tutunaꞌning sisikeerananka manikuma mantompumanaꞌ tootoꞌ pontoꞌke dueꞌuko. ");
INSERT INTO nas_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Eeꞌnoko tenang eeꞌnang diiꞌ teing daiꞌdaarira tavoꞌdaariaining orakaꞌ nkoraariiꞌnaang, eeꞌnoko diiꞌkoo niiꞌning dupisiꞌdaariaing. Eeꞌnoko diiꞌ teing ookara nantoonge munteꞌdaariaining ning nkaang miring-poꞌnupoong deentariko. ");
INSERT INTO nas_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Eeꞌnoko tenang eeꞌnang mmauꞌ nantoong tee biikaang masikaꞌanta-ita duaꞌariaing, eeꞌnoko niiꞌninge biiꞌmaikororiꞌ munteꞌaarima tooka kompai niiꞌning kare-nupoong-koo siaariai dupisiꞌaariiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Eeꞌnoko mmauꞌ nakaro-nupoong oroꞌpariaing tenang daang Kumponing-etaining tamparima, eeꞌnoko mmauꞌ nantoong tosiaarima poo-antavaariai. ");
INSERT INTO nas_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Eeꞌnoko tenang orara aarumo beremparako mmauꞌ biikaang piaa tee kaꞌmatompuaing. ");
INSERT INTO nas_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Eeꞌnoko naning purimparioꞌ bera asiranaꞌmung basiaravaing deekoꞌ domamparavaing. ");
INSERT INTO nas_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Eeꞌnoko tee tutung tee aung doorenang tampara ookara kansiꞌkoo daankiaavaing ookara nantoonge Kumponing bakaang muuꞌkoo tumpariainaꞌ taaravaavaꞌnaang, teketa tee-koo damaꞌdue doong asiꞌ tavoꞌkuaing.” ");
INSERT INTO nas_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Eeꞌnoko tenang tee kapooꞌ maremaare ooveriaing meepoꞌke donkonuioꞌ teie nakaronunge Danieloi minkuvuuꞌnaꞌ tee teꞌ meepoꞌ nuampa-antavuaing.” (Daari Meekung-koo deeruerira tasiꞌperipeuꞌ.) ");
INSERT INTO nas_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Tenang tee donkonuioꞌ ooaara teing aꞌ Judiaꞌnameng-koo otoroaining miinanka-koo deto bakei navoꞌka kooꞌariaing! ");
INSERT INTO nas_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Naning daunavaro-koo otoaing deekoꞌ siarara pava-koo kuung beaukaꞌ bakaang kavo nka-koo. ");
INSERT INTO nas_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Napoꞌ naning mintoong-koo otoainooꞌketa pava-koo toroaravaukaꞌ bakaang mononopaꞌ nka-koo. ");
INSERT INTO nas_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bakei piaaruꞌnuka otoroaing teing manikuꞌ kempoꞌnuka eeꞌnoko napoꞌ teing biurukaaꞌ noonooꞌkoo otoroaining, aiꞌ teing tapotaponuka, mmariꞌkoo makotuaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kunsirariaing tee aung batei mmaririainaꞌmung kamaari bakanang batei deemparavaukaꞌnaꞌ, niiꞌnooꞌ Doong Uaanaꞌmung deemparavaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tee arikung teꞌmung tavoꞌkuaing tee bakei dau basi aung kansiꞌ tutuntoma-ita nkoaruꞌning-koo bera eꞌmung doong-koo basinooꞌkoo, eeꞌnoko napoꞌ damaꞌke teeꞌ basi otoaukaꞌnunge. ");
INSERT INTO nas_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Teing doong arikeng Kumponinge apukaꞌantavuaruko deekoꞌ ookara nantoong teing oparipeuꞌning, teka Kumponinge bakaning miruꞌnisinuka piaavurima tee batei apukaꞌantavui miruꞌuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Eeꞌnoko tenang eeꞌnang niiꞌnung naninge aaꞌduriko deekoꞌ, ‘Ooveriai, aung tee Kumponinge Pakoꞌpariꞌniiꞌ tavoꞌkuaing-koong!’ niiꞌnooꞌ aaꞌpuko, ‘Auntang!’ tee masikaꞌantaveriaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aiꞌ teing nakaro-nupoong eeꞌnoko pakoꞌpariꞌniiꞌnuka daang Kumponing-etaning tamparimaing porora taaꞌniꞌanta pankenanka taꞌnimpaariiꞌnaꞌ nkoaavaing nantoong tosiaarima Kumponing bakaning naroꞌka papaara-antavaariiꞌnaang, tavoꞌarapeuꞌnung-pinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ooveriko, aung tee ninge tero uroꞌkanooꞌke naurampimang. ");
INSERT INTO nas_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Teeꞌkoo naninge niiꞌnunge naururima aaꞌduriko, ‘Auntanto meeꞌboraꞌ sirakamaaꞌke otomang,’ teꞌ beriaukaꞌ. Napoꞌ aaꞌpuko deekoꞌ, ‘Aung anke kuunge otomang,’ tee masikaꞌantaveriaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Teka tee piping isipoꞌketa pipimpuma ootukunairu namuꞌke sirakaꞌpumanaꞌ teeꞌ nariꞌ ookarai oomaavaing ning Tee Naning-naumpoꞌ Paning-etaing moko. ");
INSERT INTO nas_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Areꞌ tokoo bonkuꞌ otoainooꞌ teing mareoiꞌnanka teꞌ oosiarima siraꞌpaavaing.” ");
INSERT INTO nas_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Tenang eeꞌnang namuꞌke mankiꞌantananka teing doong-koo tavoꞌkuaining tankinuko tee duaaꞌ tee tenang mutaanampuaing, eeꞌnoko kaara arakavaravaukaꞌ, eeꞌnoko beentoꞌnanka paning-eta tankavariai. Eeꞌnoko teing purintoꞌnanka kapooꞌ paning-kooning teing dankampuriaininge. ");
INSERT INTO nas_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Eeꞌnoko tenang eeꞌnang tee taaꞌniꞌanta Tee Naning-naumpoꞌ Paning-etaing ookara kansiꞌ tare-koo poaing-koong oroꞌparavaing teke paning-koo, eeꞌnoko nantoong ookara kansiꞌkooning tenang eeꞌnang avoreaama orarunsiariaing. Eeꞌnoko teinge ning Tee Naning-naumpoꞌ Paning-etaing taaꞌniꞌmoi moko oomaavaing, purintoꞌ ninka kamoꞌke depeto aaꞌnaꞌ meenaꞌmoi. ");
INSERT INTO nas_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Eeꞌnoko ninge tuuviri aaꞌnaꞌ karantavama˜ botoarampaing teing nkaning koosinunanka, eeꞌnoko teinge oosiaariaing teing nkaning miruꞌnisinuka kansiꞌkoo ookutunairu-eta. ");
INSERT INTO nas_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Enang tee diiꞌke tee baisirovang ooverira noruꞌeriaing, aaꞌnomaung: Tenang paraꞌ nenuvaraꞌuko noruꞌerikooꞌ teketa deto puaravuuꞌnaang dueꞌka. ");
INSERT INTO nas_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Teeꞌ nariꞌ napoꞌ diiꞌke teing aing ookara kapooꞌnanka ooverira noruꞌeriaing tee tee dueꞌ, karanaang-anko poing. ");
INSERT INTO nas_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Masikaꞌ naurampimang ninge diiꞌ, aing enanavarang mmeꞌ paaꞌariaruko nkoaravaing teing aing kapooꞌnanka ookara. ");
INSERT INTO nas_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Paning eeꞌnoko kansiꞌ teing paaꞌareaining teka nkaang kara tee paaꞌaravaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Naninge noruꞌuaꞌ tee doong eeꞌnoko tee batei. Koosinunanka paning-kooninge noruꞌaavaꞌ. Napoꞌ ninge, tee bauringe, noruꞌampaꞌ, teka teie narunge Mmaꞌke noruꞌui otong tee batei. ");
INSERT INTO nas_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Teeꞌ nariꞌ Nooaꞌ bakanang nkoaruꞌnaꞌ nkoaravaing tee ning Tee Naning-naumpoꞌ Paning-etaing moainang. ");
INSERT INTO nas_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Aaꞌnokoꞌnaꞌ: tenang batei doua pankaing mmeꞌ poaruko taamanaama, naikaama, nampeema otorokoꞌ bera Nooaꞌ aakaꞌnareng-koo tumparuꞌnaꞌmung-koo basi. ");
INSERT INTO nas_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tee kapooꞌ nkoaravaing-koo noruꞌ otoroaꞌ bera douai pora teing ookara aaruvuruꞌ. Teeꞌ nariꞌ eeꞌnaꞌ nkoaravaing tenang ning Tee Naning-naumpoꞌ Paning-etaing moainang. ");
INSERT INTO nas_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kenaankara naninka mintoong-koo otoreko narung tenaanka-koo pariꞌuma, narung sipuaing. ");
INSERT INTO nas_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Napoꞌ manikumaara kenaankara-koo nariꞌ iinkureko nani pariꞌuma nani sipuaing. ");
INSERT INTO nas_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Teeꞌkoo tanatarariri otorimaatoai, aiꞌ diiꞌke tee noruꞌeriaꞌ tee diikaang Ovoring poainaꞌmung. ");
INSERT INTO nas_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Teka eeꞌ noruꞌeriaing diiꞌke, naninge pava okovenunge tee bakiaaꞌnko pomanang muunga noruꞌui dei tee tee maamuari otopeuꞌ tee bakaang pava pesiꞌkoo tauraꞌpuaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Teeꞌ nariꞌ diiꞌ maamurariri otoriainge, aiꞌ tee ning Tee Naning-naumpoꞌ Paning-etaing tenang batei ning moaing-pinaꞌ noruꞌmeriaruko moaing.” ");
INSERT INTO nas_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","46","“Baa tee naning matau, bakaang ovoringe bakanava tare-koo botovumaung, naning kakeꞌiinara botovotonaaꞌnuka batei makosinang bauꞌkoo miruꞌnisi, biraanke-antavuaing tee botovotonaaꞌ bakaang ovoringe pora teeꞌ nkoarako meuꞌpura. ");
INSERT INTO nas_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Masikaꞌ naurampimang ninge, teie ookutuning kapooꞌ okovumaing-koo tarenara deeng-antavuaing. ");
INSERT INTO nas_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Teka teie botovotonaaꞌke orarai eeꞌ noruꞌuaing deekoꞌ, ‘Nkaang ovoring anaꞌaring poꞌkoo,’ eeꞌnoko tavuꞌ tutumpuriai teing niiꞌning botovotonaaꞌnuka, eeꞌnoko teing ninka nantoong naikaama kanuꞌarimaing ninka nariꞌ nkoariai, teie bakaang ovoringe poma meuꞌpuuꞌnaang doong paapaaꞌui otoainaꞌmung tee poꞌkoo, eeꞌnoko batei noruꞌuaukaꞌnang. ");
INSERT INTO nas_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eeꞌnoko teie aaꞌnaꞌ kiimatavuaing tee, eeꞌnoko naroꞌ sipuai teing ninka ampirinunuka ninka, teꞌ eeꞌnooꞌ nantoong biromparima siꞌdaꞌ dovang kakirinkuarimatoainooꞌ sisikeera-koo otoroi.” ");
INSERT INTO nas_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tenang eeꞌnang tee tee muuꞌ paninung tee teing pinaꞌ neraiꞌ nanaiꞌ oroꞌparavaing biikaning daamunanka kompai nampeesinung kuneꞌkoo berouꞌning onkeonkeꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Paꞌnokoꞌ teing-koo mutaanang-kooning eeꞌnoko paꞌnokoꞌ matau-poꞌning. ");
INSERT INTO nas_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Teinge mutaanang-kooninge biikaang daamu nkavaama karasini nariꞌ nkavaavaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Eeꞌnoko teinge matau-poꞌning karasininanka nariꞌ daamu-koo nkavai berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Teka tee nampeesinung poꞌkoo anaꞌaruꞌ. Anaꞌarioꞌ teing duunkaamparira aasiauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Teketa meuꞌnamang boku karouꞌ aaꞌpuma, ‘Nampeesinung aung enang pomaang. Porira kuneꞌeriai.’ ");
INSERT INTO nas_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Teketa teing neraiꞌ tantearira biikaning daamunanka pankaꞌpauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Teketa teing mutaanang-kooninge teing matau-poꞌning karasini-koo eentavaarima aaꞌpauꞌ, ‘Niiꞌning pareꞌmereriai karasini-koo. Niikaning daamunanka siriꞌarining.’ ");
INSERT INTO nas_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Makuꞌaama aaꞌpauꞌ, ‘A, niiꞌkoo aaꞌ ookara-koo makotuarooꞌnaang. Makosi berira karasini baaveaamaing-ankoa mooꞌsiiriaing.’ ");
INSERT INTO nas_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Teka tenang mmeꞌ nanai otoroko karasini mooꞌkoo tee nampeesinung teꞌ basiaruꞌ. Eeꞌnoko teing neraiꞌ matau-poꞌning maamuariri otorokoꞌning tee ninka nariꞌ kuung tumpariruꞌ nampeesi-koong paroro-koo. Eeꞌnoko beroko karanaang daꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Napoꞌ damaꞌke teing niiꞌning napoꞌ porora aaꞌpaakoꞌ, ‘Ovoring, ovoring, daateꞌmeriai.’ ");
INSERT INTO nas_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Teka teie makuꞌurima aaꞌpuruꞌ, ‘Masikaꞌ naurampimang, ninge diiꞌ noruꞌdampiaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Teeꞌkoo tanatarariri otorimaatoai diiꞌ, aiꞌ diiꞌke tee doong eeꞌnoko batei noruꞌeriaꞌ ning toromaravainooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Napoꞌ tee muuꞌ paninung aunge minkunaae paara-anta-koo makosi. Narunge naninge ovoringe isipoꞌ niiꞌnameensiꞌkoo tenkenuma bakaning botovotonaaꞌnuka bokuvurira mooniꞌ tankaampuruꞌ teinge bakaang mooniꞌ tare-evaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tutunaꞌnung paꞌnokoꞌ kokoreiꞌnamiku avuuꞌ. Teketa kenaanka-nung kenaanka kokoreiꞌnamiku avuuꞌ. Teketa beenaumo-nung narung kokoreiꞌnamiku avuuꞌ. Biikaang matau siompui teeꞌ tankaampuruꞌ. Teketa tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Teketa tee paꞌnokoꞌ kokoreiꞌnamiku nkavuuꞌnung namuꞌke bera teie tee mooniꞌ mintoong-antavuuꞌ eeꞌnoko daua napoꞌ paꞌnokoꞌ kokoreiꞌ basi-antavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Napoꞌ tee kenaanka kokoreiꞌnamiku nkavuuꞌnung bera teeꞌ nariꞌ nkoaruꞌ. Teie napoꞌ asiꞌning kenaanka kokoreiꞌnamiku basi-antavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Teka teie naninge narung kokoreiꞌnamiku nkavuuꞌnunge bera kansiꞌ nenkeꞌura dinkung-koo dakoꞌuuꞌ tee mooniꞌ ovoring bakaang. ");
INSERT INTO nas_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Teketa pankaroompuioꞌ tee teing biikaang ovoring toroarara baakeenevuruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Eeꞌnoko teie naninge paꞌnokoꞌ kokoreiꞌnamiku nkavuuꞌnunge napoꞌ niiꞌning paꞌnokoꞌ kokoreiꞌnamiku poꞌantavuuꞌ nariꞌ pora aaꞌpuuꞌ, ‘Ovoring, dake tee ning paꞌnokoꞌ kokoreiꞌnamiku ameuꞌ. Ooveko ninge napoꞌ niiꞌning paꞌnokoꞌ kokoreiꞌ basi-antavantuꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bakaang ovoringe makuꞌuma aaꞌpuuꞌ, ‘Bakei tampaꞌ nkoveuꞌnung, daꞌ tee botovotonaaꞌ tampara, kakeꞌiinung. Aing-koo okiꞌning-koo tampaꞌ kakeꞌiiraruꞌnung-koo ninge tee kapooꞌnanka mmauꞌnanka tare-koo siꞌdampaing. Enang pora niꞌninka nariꞌ dotumareaing.’ ");
INSERT INTO nas_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Napoꞌ tee kenaanka kokoreiꞌnamiku nkavuuꞌnung pouꞌ. Pora aaꞌpuuꞌ tee ovoring, ‘Dake tee ning kenaanka kokoreiꞌnamiku ameuꞌ. Ooveko enang tee ninge napoꞌ asiꞌning kenaanka kokoreiꞌnamiku basi-antavantuꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bakaang ovoringe makuꞌuma aaꞌpuuꞌ, ‘Bakei tampaꞌ nkoveuꞌnung, daꞌ tee botovotonaaꞌ tampara, kakeꞌiinung. Aing-koo okiꞌning-koo tampaꞌ kakeꞌiiraruꞌnung-koo ninge tee kapooꞌnanka mmauꞌnanka tare-koo siꞌdampaing. Enang pora niꞌninka nariꞌ dotumareaing.’ ");
INSERT INTO nas_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Teketa napoꞌ tee naning narung kokoreiꞌnamiku nkavuuꞌnung teꞌ pouꞌ. Pora aaꞌpuuꞌ, ‘Ovoring ee, daꞌ tee bakei naning ivekung noruꞌdansi oꞌnong. Dakaning botovotonaaꞌnuka poreꞌoromatoko damaꞌ pora derararaaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Teeꞌkoo daꞌ dataramparura mera tee aung dakaang mooniꞌ bakuꞌantuꞌ kansiꞌkoo kuung. Ooveko, aung tee dakaang kapooꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Bakaang ovoringe makuꞌuma aaꞌpuuꞌ, ‘Daꞌ bakei orara botovotonaaꞌ, kakaruaꞌ. Teeꞌ minkumeinaare ninge enang toro-antavamaꞌnaang daꞌkoo. Masikaꞌ ee noruꞌmei otong ning naning ivekung? Nkaning botovotonaaꞌnuka poreꞌoromatoko damaꞌ mera deramaramaung ee? ");
INSERT INTO nas_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Teeꞌ noruꞌmei deekoꞌ arekeeꞌkoo nkaang mooniꞌ beeng-koo sipearuuꞌ, toromarara nkaning taakoreꞌning ninka nkavampeuꞌnung? ");
INSERT INTO nas_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tee narung kokoreiꞌnamiku pariꞌerira tee naning kivora kokoreiꞌnamiku otoꞌevuing averiai. ");
INSERT INTO nas_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aiꞌ baa tee naning bereng-anta-nko dau basinaꞌ napoꞌ avuꞌkoong. Eeꞌnoko tee naning bereng-anta-nko deeaung teing otoꞌevuining naroꞌka pariꞌkoonge. ");
INSERT INTO nas_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Enang damaꞌdu duaꞌeriai aung botovotonaaꞌ tamunsiꞌnung teꞌ mutaananooꞌ, teꞌ eeꞌnooꞌ nantoong biromparima siꞌdaꞌ dovang kakirinkuarimatoainooꞌ sisikeera-koo otoroi.’” ");
INSERT INTO nas_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Tenang eeꞌnang tee ning Tee Naning-naumpoꞌ Paning-etaing nkaang meenasi ninka moainang teing ninka nkaning koosinunanka ninka nariꞌ ning tee tee-koo nkaang baꞌnavaꞌnaniꞌ pipiꞌdaari-koo paning-koong-koo baꞌnanampaing daurarong taaꞌniꞌantamari. ");
INSERT INTO nas_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Eeꞌnoko ookara kansiꞌkoo muuꞌnanka amutemuuꞌ teing ning-koo uroꞌkanooꞌ oosiariaining eeꞌnoko teka siivenkeꞌarampaing teeꞌ sipisipiꞌ tarenarai sipisipiꞌ eeꞌnoko meeꞌmeeꞌ simpeꞌuripeuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eeꞌnoko aaꞌnoai, sipisipiꞌnanka ning-koo tampavine-aape siparampai, meeꞌmeeꞌnanka mareꞌaanavine-aape. ");
INSERT INTO nas_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Teketa tenang ninge dauraronge aaꞌparampaing teing tampavine-koo otoroaining, ‘Porira diiꞌ Mmaꞌke biraankeruruꞌning barenku konsiiriai, aiꞌ tee muuꞌ paninung tee diiꞌkoo maamu-antavuuꞌnung kansiꞌ tutumparuꞌnooꞌketa. ");
INSERT INTO nas_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aiꞌ diiꞌke tee ning tenang peeramoko bauꞌmerikoꞌ. Ntong-koo karaaꞌmarako kapooꞌ nai-koong amerikoꞌ. Tenang damisimai deemari oꞌnoko kuung bokumerikoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tenang duaana oꞌnoaruko duaamerikoꞌ. Napoꞌ siipamoko tanatamerikoꞌ. Tenang kiimatanava-koo oꞌnoko porima beeroꞌmerikoꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Teketa tenang teinge koontoꞌnukai makuꞌaama aaꞌpaavai tee, ‘Ovoring, areꞌka peeraroko oorampima bauꞌdampikoꞌ, eeꞌnoko ntong-koo nekeruꞌkiko kapooꞌ nai-koong arompikoꞌ? ");
INSERT INTO nas_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Napoꞌ areꞌka damisimai deentari otoko oorampima kuung bokurampikoꞌ, eeꞌnoko areꞌka duaana otoꞌderuaruko duaantampikoꞌ? ");
INSERT INTO nas_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Napoꞌ areꞌka siiparoko oorampima niiꞌnooꞌ kiimatanava-koo otoko beeroꞌdampikoꞌ?’ ");
INSERT INTO nas_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eeꞌnoko ninge dauraronge makuꞌarama aaꞌparampaing, ‘Masikaꞌ naurampimang diiꞌ, aming kapooꞌ diiꞌke aing-koo mmarang-koo baruꞌ miring otoroaing-koo nkoveruꞌnung tee tee ning-koo nkoveruꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Napoꞌ aaꞌparampaing teing mareꞌaanavine-koo-nupoong, ‘Diiꞌ barakosiꞌnisinuka, beriai ning-ankoita tee-koo ntaꞌkoo otoi otoꞌkoo Sietaniꞌkoo eeꞌnoko bakaning koosinunanka-koo maamu-antanisi-koo. ");
INSERT INTO nas_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aiꞌ ning tee peeramoko diiꞌke bauꞌmeriarukoꞌ. Ntong-koo nekeruꞌkanko kapooꞌ nai-koong ameriarukoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Damisimai deemari oꞌnoko kuung bokumeriarukoꞌ. Duaana-koo ataꞌteenko duaanameriarukoꞌ. Napoꞌ siipamoko eeꞌnoko kiimatanava-koo oꞌnoko diiꞌke tee ning taremeriarukoꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Eeꞌnoko teinge napoꞌ makuꞌaama aaꞌpaavai, ‘Ovoring ee, arenang niiꞌke daꞌ aaꞌnoko oorampima pakurampiarukoꞌ, peeraroko, ntong-koo nekeruꞌkiko, damisimai deentari otoko, duaana-koo ataꞌsiiko, siiparoko niiꞌnooꞌ kiimatanava-koo otoko?’ ");
INSERT INTO nas_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Eeꞌnoko ninge makuꞌarama aaꞌparampai, ‘Masikaꞌ naurampimang, aming kapooꞌ diiꞌke aing-koo mmaikoriꞌkoo baruꞌ miring otoroaing-koo nkoveriaruuꞌnung tee tee ning-koo nkoveriaruuꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Teketa tee teing kiimatavariri doong kante teeꞌ nariꞌ otoroainooꞌ beroaing, teka teing koontoꞌnuka domampariri teeꞌ nariꞌ otoroainooꞌ beroaing.” ");
INSERT INTO nas_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Teketa Jiisuuꞌke teing aing karananka minku bakevura bakaning barevare-nupoong aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Diiꞌke noruꞌeri otong tee Paroro Baariꞌkoong˜ makotuuꞌnaang doong deto keꞌmunta otong, eeꞌnoko ning Tee Naning-naumpoꞌ Paning-etaing tee naninge tooka kompui tauraꞌmuaing, eeꞌnoko aaꞌbarataꞌkoo biꞌmaara dupisiꞌmaavaing.” ");
INSERT INTO nas_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tenang eeꞌnang tee teing piristiꞌnuka-koo ovontung eeꞌnoko nantoong-koo pankenanka tee piristiꞌ pankaing bakanava-koo naroꞌariruꞌ, bakaang miring tee Kaiapasi. ");
INSERT INTO nas_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Eeꞌnoko teinge Jiisuuꞌ aavavaara mooꞌaara tavaavaꞌnaang mumunsiauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Eeꞌnoko teinge aaꞌpauꞌ, “Naꞌmoo paroro ninka nkoampiaukaꞌ nantoonge karingai turamaariꞌneenga.” ");
INSERT INTO nas_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Teketa tee Jiisuuꞌ teke Beetani-namono-koo otoko tee Saimoniꞌ tero oramuuꞌpoꞌnung bakanava-koo kuunge. ");
INSERT INTO nas_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Eeꞌnoko tenang teke otoko nani manikuma tee-anko pouꞌ duuninaroꞌ mooꞌ pankaing-koonaroꞌ nkavui. Eeꞌnoko tenie pora Jiisuuꞌkoo boreꞌkoo dau dakovuuꞌ teke taamang bantoꞌdomai baꞌnamparioꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Teeꞌ nkovuioꞌ teinge barevare-nupoonge ooaara iiravorora aaꞌpaakoꞌ, “Aung aming-koo anie tamung keraꞌpumaang? ");
INSERT INTO nas_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aung duuni tee mooꞌ pankaing-koo baavevuma mooniꞌ nkavuma ataꞌoiꞌnuka paku-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Eeꞌnoko Jiisuuꞌke noruꞌura tee kapooꞌ teinge minkuaakoꞌnung aaꞌpuruꞌ teing, “Diiꞌke aming-koo ani manikuma poreꞌantaverimang? Anie tee kapooꞌ tampara masikung ning-koo nkovuing. ");
INSERT INTO nas_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aiꞌ teing ataꞌoiꞌnuka teing diiꞌ ninka doong kante nariꞌ otorimaatoaining, teka ning tee diiꞌ ninka baruꞌ pankaroong oꞌnoriaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tenang anie aung duuni ning-koo mono-koo dakovuma tenie tee ning dakoꞌmaavaing-koong maamu-antamuma teeꞌ nkovuing. ");
INSERT INTO nas_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Masikaꞌ naurampimang, areꞌke tokoi tee doorenang tampara daankiaavainooꞌke ookara kansiꞌkoo tee kapooꞌ ning-koo anie nkovuing tee minkuaama ani norunoruꞌaavaing.” ");
INSERT INTO nas_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Teketa narung teing-koo nanaiꞌketa kenaanka-koo Judasi Kerioꞌnung tampaakoꞌnung, piristiꞌnuka-koo pankainuka-anko beuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Bera niaꞌurima aaꞌpuruꞌ, “Diiꞌke ning aming ameripeuꞌ ninge tee Jiisuuꞌ diiꞌanko sianko?” Teeꞌpuioꞌ teinge mooniꞌning silivaꞌkooning beenaumo kivoranuri deeru-antavaara avauꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Teketa deto tee enang Judasie tooka kompui doona besiꞌuuꞌ Jiisuuꞌ teing-koo sivuainooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Doong tutunaꞌnaꞌmung basiarioꞌ tee paroro Juꞌ biikaang bereteꞌ iisiropa-koong, bakaning barevare-nupoong Jiisuuꞌanko porora tee niaꞌaama aaꞌpauꞌ, “Dake areꞌke niiꞌke tee Taamang Baariꞌkoong˜ maamu-antavampira naiampiiꞌnaang piaromaang?” ");
INSERT INTO nas_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jiisuuꞌke aaꞌpuruꞌ, “Jerusalemaꞌnamono-koo berira naning narung ooveriaing ninge noruꞌansi oꞌnoing. Nauerima aaꞌperiaing, ‘Teie nau-antai aaꞌpuing, “Nkaang batei tokompansi oꞌnomaung miruꞌnisi enang dueꞌuing. Eeꞌnoko ning nkaning barevare-nupoong ninka teke dakanava-koo Baariꞌkoong Taamang naiampima norunoruꞌampiaing teꞌmung doong.” ’” ");
INSERT INTO nas_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Teketa teing barevare-nupoong teeꞌ Jiisuuꞌke nauvuruꞌnaꞌ berora maamu-antavauꞌ tee Baariꞌkoong Taamang. ");
INSERT INTO nas_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bera muumpuioꞌ Jiisuuꞌ teing ninka nanaiꞌketa kenaanka barevare-nupoong ninka teke baꞌnaniauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eeꞌnoko tenang taamanaama Jiisuuꞌke aaꞌpuruꞌ, “Ninge masikaꞌ naurampimang diiꞌ, narunge diiꞌkoonge tee tooka kompui ning kare-nupoong-koo simuaing.” ");
INSERT INTO nas_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Teketa teinge teeꞌ taaravaara bakei orarunsiariruꞌ, eeꞌnoko Jiisuuꞌ narunaꞌ doompeitaaꞌ niaꞌ tutumpauꞌ aaꞌpaama, “Tee ee ning ee, Ovoring?” ");
INSERT INTO nas_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jiisuuꞌke makuꞌuma aaꞌpuruꞌ, “Teie eeꞌnunge niꞌninka nariꞌ diisi-koo toonampematomaunge ning tooka kompui tauraꞌmuaing. ");
INSERT INTO nas_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ning Tee Naning-naumpoꞌ Paning-etaing tee teeꞌ Daari Meekunge minkuvuuꞌnaꞌ nariꞌ nkomaravaing, teka tee naning ning tooka kompui kare-nupoong-koo simuaing tee bakei piaaruꞌ masikung, toraꞌkuainung. Bakei pontoꞌaravaruuꞌnung dei tampaꞌke.” ");
INSERT INTO nas_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Teketa tenang teie Judasie eeꞌnunge tooka kompui tee Jiisuuꞌ kare-nupoong-koo tauraꞌpuainge aaꞌpuuꞌ, “Tee ee ning ee, Nau-anta Pankaing?” Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Eeꞌ, daꞌ eeꞌnung tee.” ");
INSERT INTO nas_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Teketa teeꞌ taamanaama Jiisuuꞌke bereteꞌnu nkavura, biraankevura, pisiꞌuuꞌ. Pisiꞌura bakaning barevare-nupoong avurima aaꞌpuuꞌ, “Nkaverira naieriai, aung tee nkaang mono makosi.” ");
INSERT INTO nas_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Teketa napoꞌ uaininareng avaako nkavura kompui tampaꞌ tampura Kumponing-koo teing avurima aaꞌpuruꞌ, “Aruꞌkoo naikiriai diiꞌ ookara. ");
INSERT INTO nas_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aung tee nkaang ereng nerakung kara naroong-anta pinkaꞌanta-koong makosi, mmauꞌ nantoong biikaang orarananka tontaꞌanta-koo dakoaravaing. ");
INSERT INTO nas_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Enang tee ninge eeꞌ naurampimang, enang-eta deto naikamparooꞌnaang uaininaruꞌkoo bera teꞌmung uaini-koong urusiꞌ nerakung diiꞌ ninka nariꞌ naiampiainaꞌmunge basi Mmaꞌ bakaang muuꞌkoo kuunge.” ");
INSERT INTO nas_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Teketa kenanavu kenavaara danto tenkenaara Oliveꞌpoꞌnamii-aape berouꞌ teing. ");
INSERT INTO nas_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Teketa Jiisuuꞌke nauvurima aaꞌpuruꞌ teing, “Eꞌmung eeꞌnaꞌmung muunga diiꞌke ookarai ning siꞌmerira kooꞌdariiꞌnaang, aiꞌ Daari Meekunge tee tero teeꞌ minkuvuuꞌnung aaꞌpuuꞌnooꞌka, ‘Ninge tee sipisipiꞌ tanatanung tavanko teing sipisipiꞌnanka teing avitoitoi purarenkaꞌariaining.’ ");
INSERT INTO nas_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Teka ning booꞌketa daaꞌmarara tee diiꞌkoo uroꞌke Kaaleliꞌnameng-koo meaing.” ");
INSERT INTO nas_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piitai makuꞌuma aaꞌpuuꞌ, “Ninge tee bakei daꞌ siꞌdampaukaꞌnung bane ainge niiꞌninge siꞌdaako dakaning kare-nupoong-koo avoreaama.” ");
INSERT INTO nas_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Ninge masikaꞌ nauramaang, eꞌmung eeꞌnaꞌmung muunga kokoreeꞌ mmeꞌ kooꞌkuaruko beemuꞌpie daꞌ penkentaravaing niꞌninka nariꞌ oꞌnoremaung-koo.” ");
INSERT INTO nas_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Teka Piitai napoꞌ aaꞌpuuꞌ, “Ning tee daꞌkoo penkemaravaukaꞌnung bane daꞌ ninka nariꞌ moompeainge.” Napoꞌ teing niiꞌning barevare-nupoong ookara teeꞌ nariꞌ kareauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Teketa tenang Jiisuuꞌ teing ninka bakaning barevare-nupoong niiꞌnooꞌ Ketsemani tampaakoꞌnooꞌ berouꞌ, eeꞌnoko teꞌ berora aaꞌpuruꞌ teing, “Aꞌ baꞌnanirioꞌ ning ankaꞌ mera kunsimaravai.” ");
INSERT INTO nas_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Teketa Piita bokuvui eeꞌnoko Siebedi-baurinketa nariꞌ tapotaapoꞌ berouꞌ, eeꞌnoko orarunsiarama domang orakaꞌ deeꞌouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Eeꞌnoko teing aaꞌpuruꞌ, “Nkaang domang tee orarunsie bakei booꞌpinaꞌ deeꞌantamuing. Anke otoriai niꞌninka nariꞌ tanatarariri.” ");
INSERT INTO nas_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Teketa kato okiꞌnooꞌ bera teꞌ doonko kinkinura kansiꞌkoo teke kunsiaruꞌ aaꞌpuma, “Mmaꞌ ee, makosi deekoꞌ aung kiimata-koong kaapu baariꞌantameaing, teka tee nkaang pia deeaꞌ, daꞌ dakaang pia siong-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Teketa napoꞌ teꞌ bakaning barevare-nupoong otorouꞌnooꞌ toroarara teing aasiaioꞌ oovuruꞌ teka. Eeꞌnoko teketa aaꞌpuuꞌ tee Piita, “Diiꞌ ee donkaang niꞌninka nariꞌ tanatarariri tamung okiꞌnooꞌ batei otoriarupeuꞌ? ");
INSERT INTO nas_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kunsirarima tanatarariri otoriaing parapaara-koo duaꞌdariꞌneenga, aiꞌ domange tee piarori otoritaaꞌ diikaang mono aruaruꞌdorimang.” ");
INSERT INTO nas_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Teketa napoꞌ kemuꞌkanaꞌ kato bera kunsiarama aaꞌpuuꞌ, “Mmaꞌ ee, aung kiimata ninge baariꞌkoo makosi deeaung deekoꞌ, makosi dakaang pia siompansi toraꞌpampaing.” ");
INSERT INTO nas_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eeꞌnoko napoꞌ pora teeꞌ teing aasiai otoroko oovuruꞌ, duta aasiꞌke tavurioꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Teketa napoꞌ teka sipurira napoꞌ beemuꞌpinaꞌ beuꞌ kunsiaraaꞌnaang teeꞌ nariꞌ minkuvuuꞌnaꞌ minkuvuma. ");
INSERT INTO nas_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Teketa napoꞌ barevare-nupoong-anko toroarara aaꞌpuruꞌ teing, “Diiꞌ ee mmeꞌ aasiri otong uaarorima? Ee aing, batei dueꞌumaang ning Tee Naning-naumpoꞌ Paning-etaing tooka kompui naninge simuuꞌnaang nantoong oreng biikaang bireng-koo. ");
INSERT INTO nas_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aiaꞌ, daaꞌdarira meriai. Ooveriko tee aung tooka kompui ning simuaꞌnaang enang pomaang.” ");
INSERT INTO nas_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tenang eeꞌnang tee Jiisuuꞌ teeꞌ karoi otoko tee Judasi nanaiꞌketa kenaanka-koong narung teꞌ basiaruꞌ. Tee ninka nariꞌ nantoong karinga bainatu dovang-poꞌnupoong eeꞌnoko taꞌbaka aaꞌning kompai porouꞌ, piristiꞌnuka-koo ovontung eeꞌnoko nantoong biikaning pankeuꞌ urantanuka aaꞌninge botoaaruꞌning. ");
INSERT INTO nas_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Teie tooka kompui Jiisuuꞌ kare-nupoong-koo sivuuꞌnaang tee taaꞌniꞌanta maamu-antavuuꞌ aaꞌpuma, “Tee naning ninge nuunuampaing tee eeꞌnung naning diiꞌke bokotaanieriaing.” ");
INSERT INTO nas_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jiisuuꞌanko namuꞌke bema Judasie aaꞌpuuꞌ, “Teie ee Nau-anta Pankaing!” Teeꞌ minkuvuma teka nuunuvuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Mmaikoꞌ, kapooꞌ dake nko-koo poing nkoveaing.” Teketa tenang teing nantoong uroꞌkanooꞌ kooꞌarira Jiisuuꞌ bokotaaniaara daiꞌauꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Teeꞌ nkoaako narunge Jiisuuꞌ bakaning-koonge bakaang bainatu barampura piristiꞌkoong pankaing bakaang botovotonaaꞌ tekaꞌpuma domeꞌ eteꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Teketa Jiisuuꞌke aaꞌpuuꞌ tee, “Tee dakaang bainatu teꞌ bakanooꞌ napoꞌ sipeai, aiꞌ teing nantoong bainatue tavuꞌ nkoaavaining teing napoꞌ bainatue booroaining. ");
INSERT INTO nas_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aiꞌ dake ee noruꞌeaꞌ ninge Mmaꞌkoo karonko bakei mmauꞌ kokoreiꞌ koosinunanka aaꞌ namuꞌke beeꞌoaripeuꞌ ning paku-koo? ");
INSERT INTO nas_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Teka teeꞌ nkoansi dei tee Daari Meekung-koong kara arekeeꞌ dupearapeuꞌ, aaꞌpui otoing, teeꞌ eeꞌ nkomaamatomanaꞌ nariꞌ nkomaavaing?” ");
INSERT INTO nas_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eeꞌnoko tenang Jiisuuꞌke aaꞌpuruꞌ teing nantoong karinga, “Diiꞌke ee ning tavuꞌ nkoaama bakiaaꞌkamaung deemerima bainatu dovang ninka ankonuꞌ poring ning daiꞌmeriiꞌnaang? Doong kante tee ning oomerioꞌ dootuuꞌnava pankava-koo doonanairu-koo baꞌnamari nau-antamaramaung, teka teke oꞌnoko diiꞌke ning daiꞌmeriaung. ");
INSERT INTO nas_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Teka aung eeꞌ nkoaring tee Daari Meekung-koong kara nakaro-nupoonge daariauꞌnung dupearaaꞌnaang.” Teketa tenang teinge ookara bakaning barevare-nupoonge teka sipaara kooꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Teketa teinge tee Jiisuuꞌ mooꞌauꞌninge Kaiapasi-anko beꞌantavauꞌ tee eeꞌnung piristiꞌnuka biikaang pankaing, teꞌ eeꞌnooꞌ teing boto naunuka eeꞌnoko teing pankeuꞌ urantanuka naroꞌariruꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Teka Piitai damaꞌke isipoꞌketa kaarie sipuma bera teꞌ piristiꞌnuka biikaang pankaing bakanava-koo uroꞌmang basiaruꞌ. Bera teꞌ kuung tumparara teing ninka Juꞌ biikaang piatooronuka˜ ninka nariꞌ baꞌnanui otokoꞌ tokoonaꞌ nkoaavainaꞌ oovuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eeꞌnoko Piita teꞌ baꞌnanui otoko teinge piristiꞌnuka-koo ovontunge teing ninka ookara koompaaraꞌnavitu karananka mareꞌniiꞌ besiꞌaakoꞌ Jiisuuꞌ tuumpi-kooning kara daaꞌaara deekoꞌ Jiisuuꞌ dupisiꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Teka teing kapooꞌ daaꞌaavaꞌ bane mmauꞌ daang minku nkonankai teke donkonai kara mmauꞌ minkuaakoꞌ. Asiꞌnaꞌmoong kenaanka naninka uroꞌkanooꞌ poreta aaꞌpuretuꞌ, ");
INSERT INTO nas_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Aunge tee aaꞌpumaung, ‘Ninge teva dootuuꞌnava pankava turampamira beenang doong-koo napoꞌ kaniampeuꞌ.’” ");
INSERT INTO nas_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Teketa tenang piristiꞌnuka biikaang pankainge deto donkonura Jiisuuꞌ aaꞌpuuꞌ, “Daꞌ ee bariꞌnaꞌ otoꞌderuaꞌ? Siraꞌdaravai aung-koo tuumpiramaung-koo!” ");
INSERT INTO nas_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Teka Jiisuuꞌ teeꞌ nariꞌ kaꞌduuari otokoꞌ. Teketa teie piristiꞌnuka biikaang pankainge aaꞌpuuꞌ tee, “Ninge tee Kumponing domantooꞌ bakaang miring-koo aaꞌdamaang, naumeriai daꞌ tee Kumponinge tero Pakoꞌpariꞌniiꞌ niiꞌ domameri taremeriainooꞌkoo deekoꞌ, tee Karistooꞌ, Kumponing Bauring.” ");
INSERT INTO nas_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Eeꞌ, teeꞌ eeꞌnaꞌ masikaꞌ minkuemaang. Eeꞌnoko aaꞌdampiiꞌnaang ninge diiꞌ ookara: Damaꞌke tee ning tasiꞌmeriaing ning tee eeꞌnung Tee Naning-naumpoꞌ Paning-etaing Daari Meekunge naururimaung kamoꞌke depeto pora ookara kansiꞌ tarevumaatoainung. Eeꞌ, Kumponing bakaang iriꞌ deto basi ninka moko oomerira tee diiꞌke tenang tasiꞌmeriaing.” ");
INSERT INTO nas_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Teketa tenang teie piristiꞌnuka biikaang pankainge bakaang mononopaꞌ dereꞌura aaꞌpuuꞌ, “Aunge bakei Kumponing akapeuꞌumaang! Niiꞌ nantoong aung-koo kapooꞌ minku-koo piamoriaꞌ. Tee tee aung enang diiꞌka taaravering Kumponing akapeuꞌuko. ");
INSERT INTO nas_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Enang bakaang kara simpeꞌerima arekeeꞌ noruꞌerimang?” Eeꞌnoko teinge makuꞌaama aaꞌpauꞌ, “Aung tee booꞌkoo makosi.” ");
INSERT INTO nas_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Teketa tenang oing-koo tutupaaꞌaama kiꞌbituauꞌ. Eeꞌnoko niiꞌninge tankoꞌpaakoꞌ aaꞌpaama, ");
INSERT INTO nas_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Daꞌ tee Kumponinge teroita Pakoꞌpariꞌniiꞌ nantoong domamperi tareveriainooꞌkoo deekoꞌ tarampeerarama˜ mansiꞌdari naumeriai baie tarui?” ");
INSERT INTO nas_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tuutunang˜ kuunge nkoarako tee Piita tee parang-koo kuunge pava-ita damaꞌdue baꞌnanuioꞌ nani neraiꞌnaꞌ botovotonaaꞌ tee-anko pouꞌ teꞌ. Pora aaꞌpuuꞌ, “Daꞌ tee Jiisuuꞌ ninka tee ninka Kaaleliꞌnung ninka nanirimaung.” ");
INSERT INTO nas_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Teka Piita penkemparuꞌ teing-koo ookara-koo uroꞌkanooꞌke, aaꞌpuma, “Ning tee kapooꞌ diiꞌke minkuerimatomaung noruꞌampaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Napoꞌ teketa danto tuntoma-navaro-koo bera teke otoko niiꞌnanie napoꞌ neraiꞌnaꞌke teka oovuuꞌ. Oovura teing nantoong teke otorokoꞌning nauvurima aaꞌpuruꞌ, “Aung tee naning tee ninka Jiisuuꞌ Nasaretiꞌnung ninka nariꞌ nanuremaung.” ");
INSERT INTO nas_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Teketa napoꞌ penkemparuꞌ tee Piita marakavarama; aaꞌpuuꞌ, “Ninge tee naning noruꞌampaꞌ,” ");
INSERT INTO nas_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Napoꞌ teketa otompuaruko teinge nantoonge teke donkonai otorokoꞌninge Piita-anko masipoꞌ berora aaꞌpauꞌ, “Bakei masikaꞌ daꞌ teie narung teing-koong, aiꞌ daꞌ tee teeꞌ teing-pinaꞌ karema siraꞌdaramang.” ");
INSERT INTO nas_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Teketa Piita baka barakosiꞌarama maraka-antavarama aaꞌpuuꞌ, “Ninge tee naning noruꞌampaꞌ!” Teketa namuꞌke kokoreeꞌ kooꞌkuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Teketa tenang Piitai norunoruꞌuuꞌ tee kara Jiisuuꞌke minkuvuuꞌnung, aaꞌpuuꞌnung, “Daꞌ tee kokoreeꞌ mmeꞌ kooꞌkuaruko beemuꞌpie penkentaravaing niꞌninka nariꞌ oꞌnoremaung-koo.” Eeꞌnoko teketa oko siarara aaꞌnaꞌ orarunsiarara biromparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Teketa minkuaakotaaꞌ taneꞌpuioꞌ ookarai aaꞌninge piristiꞌnuka-koo ovontung eeꞌnoko nantoong-koo pankeuꞌ urantanukai Jiisuuꞌ dupisiꞌaavaꞌnaang maneauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eeꞌnoko daiꞌaara teketa tee Pailatiꞌanko, tee-anko Roomaꞌnung ovoꞌmaꞌanko, tavoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Teketa tenang teie Judasie tooka kompui Jiisuuꞌ tauraꞌpuuꞌnunge tee maneauꞌnaꞌ oovura orarunsiaruꞌ. Eeꞌnoko orarunsiarara teing mooniꞌ silivaꞌnanka beenaumo kivora-nuri bera torovuuꞌ piristiꞌ pankenanka-koo eeꞌnoko nantoong-koo pankenuka-anko aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Bakei orakaꞌ nkomarieeng! Tee naning orararopa kare-nupoong-koo tauraꞌpansieeng tavaavaꞌnaang.” Eeꞌnoko teinge pankenankai makuꞌaama aaꞌpauꞌ, “Tee tee kapooꞌ dakaang, niiꞌ tee-koo dake mankiꞌantameriaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Teketa Judasie mooniꞌ teꞌ dootuuꞌnava pankava-koo kuung duaꞌura tenkenuuꞌ. Teketa bera keniꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Teketa teinge piristiꞌkoo pankenankai teing mooniꞌnanka teka ukuaara aaꞌpauꞌ, “Aung tee boto-koo eeꞌ oroꞌ orokoari otong teꞌ meepoꞌ mooniꞌ koreꞌdoma siꞌkoo tee tooka-koong deemparako.” ");
INSERT INTO nas_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Teketa teinge narung naning utau taꞌnang bakaang kansiꞌ mooꞌkoo kara naroompauꞌ nantoong Juꞌdeeaing teꞌ dakoꞌaarimaatooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eeꞌnoko teeꞌkoo eeꞌnaꞌkoo tevoraꞌ kansiꞌnavoraꞌ miring tookanavoraꞌ tampaamaung bera eꞌmung doonko basinooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Eeꞌnoko teeꞌ nkoarioꞌ tee kara teie Jeremaiaꞌke nakaronarai minkuvuuꞌnung dupearuꞌ Daari Meekung-koo aaꞌpuuꞌnooꞌka, ");
INSERT INTO nas_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","“Teinge beenaumo kivora silivaꞌnanka nkavauꞌ, teinge niiꞌninge Isireeli-nupoonge miruꞌauꞌning tee naning mooꞌkooning. Eeꞌnoko naning utau taꞌnang bakanameensiꞌ mooꞌauꞌ teinge, Ovoringe botomuuꞌnaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Enang napoꞌ tee Jiisuuꞌ tee-anko ovoꞌmaꞌanko donkong-antavaioꞌ niaꞌuma aaꞌpuuꞌ tee, “Daꞌ ee tee Juꞌnupoong biikaang daurarong?” Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Teeꞌ nariꞌ minkueinaꞌ oꞌnong.” ");
INSERT INTO nas_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Teketa teinge pankenankai piristiꞌnuka-koo eeꞌnoko nantoong-koo daang tuumpiaako kasivuaꞌ karoarukoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Teketa Pailatiꞌke niaꞌuma aaꞌpuuꞌ, “Dake ee taaraveaꞌ otong kapooꞌ mmauꞌnanka-koo tuumpiraamaang daꞌ?” ");
INSERT INTO nas_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Teka Jiisuuꞌke niiꞌnauꞌ kapooꞌnauꞌkoo makuꞌuriaꞌ. Teeꞌkoo tee ovoꞌmaꞌ aaꞌnaꞌ taꞌninuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tenang tee teke narung aarumo ovoꞌmaꞌke nkovukoꞌnung eeꞌ oroꞌ: Ookara mareꞌ kante-koo Taamang Baariꞌkoong˜ nkoaako tee narung naning kiimata-nupoong-koo simpiriꞌantaevurikoꞌ nantoong karikaꞌ piavorokoꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Eeꞌnoko tenang eeꞌnang teke tee narung naning orara, ookarai noruꞌaakoꞌnung miring Barabas kiimata-nava-koo otokoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Teeꞌkoo tenang nantoong karinga naroꞌaririoꞌ Pailatiꞌke niaꞌurima aaꞌpuruꞌ teing, “Anaanka-koo arera ninge simpiriꞌanta-koo piarorimang, tee Barabas aiꞌ tee Jiisuuꞌ, tee Pakoꞌpariꞌniiꞌ tampaamaung?” ");
INSERT INTO nas_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Teka eeꞌ noruꞌui, teinge tee Jiisuuꞌ mamairo-ita tee-anko tavoꞌauꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Teketa tenang Pailatiꞌ teke bakanooꞌke baꞌnanui kara simpeꞌdomai baꞌnanuioꞌ baꞌaang botoarioꞌ narung kara tee-anko poꞌantavauꞌ eeꞌ minku, “Tee naning kapooꞌ orararopa dake tokoonaꞌ nkoveaukaꞌ, aiꞌ ninge tee eꞌmung tee-koo noone ooamira domang aaꞌnaꞌ mankiꞌmoi oꞌnoing.” ");
INSERT INTO nas_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Teka teinge piristiꞌnuka-koo eeꞌnoko nantoong-koo pankenankai dera-antavaarikoꞌ ookara nantoonge Barabas bake-antavuma Jiisuuꞌ dupisiꞌantavuaing tampaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Teketa teie ovoꞌmaꞌke aaꞌpuuꞌ, “Anaanka-koo naninka-koo baa arera diiꞌke bake-anta-koo piarori otong?” Teinge makuꞌaama aaꞌpauꞌ, “Tee Barabas.” ");
INSERT INTO nas_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Teketa Pailatiꞌke nantoong niaꞌurima aaꞌpuuꞌ, “Teka tee Jiisuuꞌ, tee Pakoꞌpariꞌniiꞌ tampaamaung, arekeeꞌ nkoamaꞌnaang?” Teinge ookarai makuꞌaama aaꞌpauꞌ, “Aaꞌbarataꞌkoo taakaveaing tee.” ");
INSERT INTO nas_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailatiꞌke makuꞌurima aaꞌpuuꞌ, “Aming-koo, aiꞌ kapooꞌ orara aming nkovuing teie?” Teka teinge napoꞌ baruꞌ aaꞌnaꞌ bokiaama aaꞌpauꞌ, “Aaꞌbarataꞌkoo taakaveaing tee.” ");
INSERT INTO nas_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Teketa tenang Pailatiꞌke tamung kariarakoꞌnung noruꞌarara eeꞌnoko nantoonge karakarare tutumpaioꞌ teie ntong nkavura bireng duuꞌparuꞌ teing-koo karikaꞌkoo uroꞌkanooꞌke aaꞌpuma, “Ning tee kapooꞌ oꞌnoaꞌ, aung naning bakaang ereng ning-koo biromparavaukaꞌnunge, kapooꞌ diiꞌ diikaang.” ");
INSERT INTO nas_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eeꞌnoko ookara nantoonge makuꞌaama aaꞌpauꞌ, “Makosi, bakaang ereng niiꞌkoo biromparavaing eeꞌnoko ookara-koo niurukaaꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Teketa teie Barabasi simpiriꞌantavevuruꞌ. Teka teie Jiisuuꞌ muraꞌaavaꞌnaang botovuruꞌ Pailatiꞌke, eeꞌnoko damaꞌke aaꞌbarataꞌkoo taakavaavaꞌnaang botovuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Teketa tenang ovoꞌmaꞌ bakaning piatooronukai Jiisuuꞌ ovoꞌmaꞌ bakanava-koo beꞌantavauꞌ, eeꞌnoko ookara piatooronukai teka tapoꞌeera koroauꞌ tee eeꞌ akapeuꞌaavaꞌnaang: ");
INSERT INTO nas_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Teinge bakaning mononopaꞌnanka kiruꞌaara napoꞌ mononopaꞌ urumpumaung dauraronuka biikaang-pinaꞌ oroꞌ kurumpauꞌ tee-koo. ");
INSERT INTO nas_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Teketa baakopo tooꞌmurintaaꞌpoꞌnung dauraronuka biikaang-pinaꞌ kaamaum paara tee-koo boreꞌkoo kurumpauꞌ. Eeꞌnoko banaꞌ kong-antavauꞌ tee-koo bireng-koo tampavine-koo eeꞌnoko tee-koo uroꞌkanooꞌ kinkinaakoꞌ aaꞌpaama, “Tampara masikung, Daurarong Juꞌnupoong Biikaang!” ");
INSERT INTO nas_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eeꞌnoko teinge tutupaaꞌaama banaꞌ pariꞌaama amutemuꞌke boreꞌkoo muraꞌaakoꞌ teie. ");
INSERT INTO nas_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Teketa akapeuꞌaakotaaꞌ tee mononopaꞌ urung kiruꞌauꞌ, teketa tee bakaang masikung mononopaꞌ kurumpauꞌ tee-koo. Teketa aaꞌbarataꞌkoo taakavaavaꞌnaang beꞌantavauꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Teketa beroma naning narung kuneꞌauꞌ Sairini-nung miring Saimoniꞌ, eeꞌnoko teinge tee etuauꞌ tee teie aaꞌbarataꞌ nkaevuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Teketa Kolokataꞌ tampaamanooꞌ basi-antavauꞌ, miruꞌnooꞌ Makupiꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Eeꞌnoko teka teꞌ basiarira teinge Jiisuuꞌ uaini nonang-koong maꞌnaange pitunisi avuꞌkoo paaravauꞌ teie naivuuꞌnaang, teka teie toraꞌpura nai-koo kasivuaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tenang tee aaꞌbarataꞌkoo taakavaara teinge tee bakaning mononopaꞌ tankaampeuꞌ kapooꞌ deikooꞌkoong nkoaara. Teeꞌ nkoaioꞌ tee kara nakaronunge minkuvuuꞌnung dupearuꞌ Daari Meekung-koo aaꞌpuuꞌnung, “Teing tankaampeuꞌnung teing nkaning mononopaꞌ, eeꞌnoko nkaang baarong-koo deikooꞌeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Eeꞌnoko teke baꞌnanai tanatavai otorokoꞌ tee teka. ");
INSERT INTO nas_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Eeꞌnoko tee-koo boreꞌkoo daua teing kapooꞌ tee tuumpiaakoꞌning daariaara sipauꞌ eeꞌ minkuning: AUNG TEE JIISUUꞌ, JUꞌNUPOONG BIIKAANG DAURARONG. ");
INSERT INTO nas_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Napoꞌ kenaanka naninka mutaaꞌo tee ninka nariꞌ taakavaaretuꞌ teka. Narung tee-koo tampavine-aape eeꞌnoko narung mareꞌaanavine-aape. ");
INSERT INTO nas_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Eeꞌnoko nantoong teke tankinaakoꞌninge kooviꞌai tankinaakoꞌ, orakaꞌ minkuaama. ");
INSERT INTO nas_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Eeꞌnoko aaꞌpaakoꞌ, “Daꞌ tee pava dootuuꞌnava pankava turampera beenang doong-koo kanieeꞌnaang tantaramaung, enang daka domaang mooꞌdarama aaꞌbarataꞌketa depeto siraravai, daꞌ tee Kumponing Bauring deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Napoꞌ teeꞌ nariꞌ teinge ainge aaꞌninge akapeuꞌaakoꞌ tee, piristiꞌnuka-koo ovontunge, boto naunukai eeꞌnoko nantoong pankeuꞌ urantanukai. ");
INSERT INTO nas_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Aaꞌpaakoꞌ, “Aunge tee nantoong oovuning domaang mooꞌurikooꞌ, teka baka domaang mooꞌkoo makotuaꞌ. Tee Isireeli-nupoong Biikaang Daurarong deekoꞌ enang aaꞌbarataꞌketa depeto siaravaing eeꞌnoko niiꞌke masikaꞌantavampiaing tee. ");
INSERT INTO nas_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bakei Kumponing bauring tamparama tee-koo aaꞌnaꞌ pinkaꞌaramaung tamparakooꞌ, enang Kumponinge pakuvuaing teka tee domamparaaꞌnaang piavoi otoing deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Eeꞌnoko napoꞌ teeꞌ nariꞌ tenaanka mutaaꞌo nkorai tee ninka nariꞌ taakavaaretuꞌnaankai pooreꞌuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Enang tee duaakiꞌuioꞌ mutaanang pouꞌ temeng ookutunameng bera kamunooꞌnang-koo basi. ");
INSERT INTO nas_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Eeꞌnoko kamunooꞌnang Jiisuuꞌ aaꞌnaꞌ karoma osinung karai aaꞌpuuꞌ, “Eloi, Eloi, lama sabakatani,” eeꞌ minkuvuma, “Nkaang Kumponing, nkaang Kumponing, ning dake aming-koo siꞌmeing?” ");
INSERT INTO nas_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Eeꞌnoko niiꞌninge nantoonge teke donkonai otorokoꞌninge teeꞌ taaravaara aaꞌpauꞌ, “Eliasi bokuvumaang.” ");
INSERT INTO nas_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Teketa namuꞌke narung teing-koo kuaꞌparara kapooꞌ uaini kaaveeriiꞌke boovong-antavura banaꞌkoo daiꞌantavura Jiisuuꞌaape deto toong-antavuuꞌ musiꞌuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Teka niiꞌninge aaꞌpauꞌ, “Sipeko baka otoai tee. Iroꞌ ooampiaing, Eliasie pa pora pakuvuuꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Teka Jiisuuꞌ aaꞌnaꞌ napoꞌ deto bokuma tenang eeꞌnang domang siꞌnuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Eeꞌnoko tenang eeꞌnang tee baarong pava dootuuꞌnava pankava-koong, meekavaro kuꞌnung, meuꞌ keꞌmeꞌaruꞌ aꞌdeiꞌketa depeto dereꞌarama bera aꞌdoong kainuꞌ. Kansiꞌ uꞌmiꞌke aaꞌnaꞌ biruꞌuuꞌ, eeꞌnoko boiaꞌnanka keꞌmeraꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Eeꞌnoko napoꞌ nantoong dakoꞌaaruꞌnanka-koong kuvinanka daateꞌariruꞌ, eeꞌnoko nantoong meekupoong tero dakoꞌ aaruꞌning biikaang mononanka domamparira daaꞌarira kuvi-eta bakoariruꞌ; ");
INSERT INTO nas_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Teketa Jiisuuꞌ domamparara daaꞌarioꞌ teing Jerusalemaꞌkoo kuung berora nantoong mmauꞌkoo oroꞌpariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Eeꞌnoko tenang teie piatooro daakuꞌ tarenara teing ninka teke Jiisuuꞌ tanatavai otorokoꞌning ninka nariꞌ tee uꞌmiꞌ nkoaruꞌnung ooaara eeꞌnoko ookara kapooꞌnanka tavoꞌkuuꞌning teing teing bakei aaꞌnaꞌ avoreauꞌ, eeꞌnoko oitaꞌkaama aaꞌpauꞌ, “Aung bakei masikaꞌ Kumponing Bauring.” ");
INSERT INTO nas_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Eeꞌnoko manikuꞌ mmauꞌ teke otorokoꞌ isipoꞌketa tee Jiisuuꞌ ooaitaaꞌ Kaaleliꞌketa Jiisuuꞌ siompaitaaꞌ nariꞌ porouꞌning tee pakuaama kapooꞌ apukaꞌparakoꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Teing-koo niiꞌnani Meeriꞌ Maꞌdala-nani, eeꞌnoko niiꞌnani napoꞌ Meeriꞌ Jeemisi namainta Josepaꞌ beuko, eeꞌnoko napoꞌ Siebedi baurinketa beuko. ");
INSERT INTO nas_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Muung-aapevuma nanuko naning narung teꞌ pouꞌ kavonanka mmauꞌpoꞌnung miring Josepaꞌ Arimateaꞌnung, teenooꞌ tee Jiisuuꞌ bakaning-koong barevare-nupoong-koo narung deemparuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Eeꞌnung tee Pailatiꞌanko bera Jiisuuꞌkoong mono niaꞌuuꞌ, eeꞌnoko Pailatiꞌke arooꞌura avaavaꞌnaang botovuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Eeꞌnoko Josepaꞌke tee Jiisuuꞌkoong mono nkavura teie baaronge kakaarai nerakunge booꞌnuka daiꞌnaꞌ daiꞌuma nopaꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Eeꞌnoko bakaang-koo kuvi dakoꞌdoma-koo nerakung-koo kuung sipuuꞌ tee kapang-koo nenkeꞌuuꞌnareng-koo. Eeꞌnoko kapang pankaing kaavororiiꞌ kovempura teꞌ kuvi dakoꞌdoma karanaang kuꞌnumpuuꞌ, eeꞌnoko teeꞌ nkovura tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Teni Meeriꞌ Maꞌdala-nani eeꞌnoko napoꞌ niiꞌnani Meeriꞌ teꞌ kuvi-eta avetekaꞌkoo baꞌnanuresi tarevuresi otorekoꞌ. ");
INSERT INTO nas_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Teketa daunaꞌmung teing piristiꞌnuka-koo pankeng eeꞌnoko Boto Keperuuꞌnuka Pailatiꞌanko berora aaꞌpauꞌ, ");
INSERT INTO nas_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ee pankaing, niiꞌke tee tosi bauko bakaang kara norunoruꞌampiring domampari minkuvuuꞌnung aaꞌpuma, ‘Beenang doong tankinuko ning napoꞌ daaꞌmaravaing.’ ");
INSERT INTO nas_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Teeꞌkoo dake boto sipeko teꞌ kuvi dakoꞌdoma tanatavaavaing bera beenamparavainaꞌmung-koo basi, teinge bakaning barevare-nupoonge porora Jiisuuꞌkoong bonkuꞌnooꞌ bakiaaꞌaara nantoong nauaarima aaꞌpaaꞌneenga, ‘Tee Jiisuuꞌ booꞌketa daaꞌaring.’ Aung tee teeꞌ oroꞌ tositosi beremparavaing deekoꞌ bakei koontoꞌ orara masikung, tutunaꞌnung tositosi divuꞌui otoainge.” ");
INSERT INTO nas_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eeꞌnoko Pailatiꞌke aaꞌpuuꞌ, “Berira tanatavaavaining bokuereriaing, eeꞌnoko tee kuvi tampaꞌ mataueri pinkaꞌeriai diiꞌke makosieriainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eeꞌnoko tee teinge berora tee kuvi pinkaꞌauꞌ, aaꞌnouꞌ, ovoꞌmaꞌ bakaang taaꞌniꞌanta kapang-koo dau sipauꞌ teie paraꞌaama, eeꞌnoko tanata nkonuka miruꞌaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Doong Uaanaꞌmung tankinuioꞌ Saandei-naꞌmung sirakaꞌpuma nanuko Meeriꞌ Maꞌdala-nani eeꞌnoko teni niiꞌnani Meeriꞌ beretuꞌ tee kuvi dakoꞌdoma oovureeꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tenaanka teꞌ basiareko uꞌmiꞌ pankaing nkoaruꞌ. Narung koosinung˜ Ovoring bakaang paning-eta teꞌ siarara kuvi-aape bera tee kapang kaavororiiꞌ kato korimpuuꞌ eeꞌnoko tee-koo dau baꞌnamparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bakaang ooꞌoo-koo piping-pinaꞌ oroꞌparitaaꞌ, eeꞌnoko bakaang mononopaꞌ aaꞌnaꞌ kakaara sinou-pinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Eeꞌnoko teing teꞌ tareaakoꞌning tee-koo aaꞌnaꞌ avoroꞌke daiꞌurioꞌ dankurankuꞌarima booꞌpinaꞌ otorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eeꞌnoko teie koosinunge tenaanka manikumaara aaꞌpuretuꞌ, “Deeꞌ arorereaukaꞌ. Noruꞌansi oꞌnong deeꞌke Jiisuuꞌ besiꞌeremang, tee eeꞌnung aaꞌbarataꞌkoo taakavaieeng. ");
INSERT INTO nas_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tee tee aꞌ otoaꞌ, domamparing teeꞌ minkuvuuꞌnaꞌ. Poreta oovereaing aꞌ bempaieenooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Teketa namuꞌke bereta bakaning barevare-nupoong aung kara nauereriai, aaꞌpereriaing, ‘Tee tee booꞌketa domamparing, eeꞌnoko Kaaleliꞌaape diiꞌkoo uroi bemaang. Teka berira ooveriaing.’ Teeꞌ eeꞌnaꞌ masikaꞌ ninge naurampesinaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Teketa tenaanka manikumaara namuꞌke tenkenuretuꞌ teketa kuvi dakoꞌdoma-ita avororema, nka tee domang dotue maantoꞌuresi. Eeꞌnoko kuaꞌparetuꞌ teing bakaning barevare-nupoong nauaareeꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Teketa Jiisuuꞌke tenaanka teka taunga taꞌninaꞌ oroꞌpari kuneꞌureta aaꞌpuretuꞌ, “Deeꞌke ee!” Eeꞌnoko tenaanka tee-anko poreta bakaang kauꞌ bokoꞌureta pankaing-antavuretuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Teketa Jiisuuꞌke aaꞌpuretuꞌ tenaanka, “Arorereaꞌ bereta teing mmaikoriꞌ nauereriko Kaaleliꞌnameensiꞌaape beroai teka kuneꞌmaavaing ning.” ");
INSERT INTO nas_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tenang tenaanka manikumaara taunge nanuresi otoreko niiꞌning teing-koo kuvi dakoꞌdoma tanatavaakoꞌning-koo Jerusalemaꞌ duparira siraꞌpauꞌ teing piristiꞌnuka-koo pankenanka nauaarima ookara kapooꞌnanka nkoaruꞌning. ");
INSERT INTO nas_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Teketa teinge piristiꞌnuka-koo pankenge teing ninka nantoong-koo pankenanka ninka naroꞌke minkunaavarira teinge narung taung matauauꞌ. Eeꞌnoko teing piatooronuka mooniꞌ pankainge mooꞌaaruꞌ aaꞌpaarima teing, ");
INSERT INTO nas_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Aaꞌperiaing, ‘Bakaning barevare-nupoonge muunga aatumpirioꞌ bakiaaꞌaara nkavaing.’ ");
INSERT INTO nas_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Teka tee aung kara aasirieeng-koong ovoꞌmaꞌke taaravuko deekoꞌ niiꞌke boing-antavampiaing tee, eeꞌnoko diiꞌ tee-koo kara-koo kiimatarariaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Teketa teinge piatooronukai teing mooniꞌnanka kompaara teeꞌ nariꞌ nauaaruꞌnaꞌ minkuakoꞌ. Eeꞌnoko biikaang minkunaa tee avitoitoi beremparuꞌ Juꞌnupoong-koo meuꞌke bera eꞌmung doong-koo basinooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Teketa tenang teing nanaiꞌketa narung barevare-nupoong Kaaleliꞌaape berouꞌ teꞌ mii-koo Jiisuuꞌke berooꞌnaang nauvuruꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Eeꞌnoko teinge ooaara kinkinaama pankaing-antavauꞌ, teka niiꞌning keekooꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Eeꞌnoko Jiisuuꞌ teing-anko pora aaꞌpuruꞌ, “Ookara iriꞌnanka paning-kooning eeꞌnoko kansiꞌkooning tee ning oko-antamuining. ");
INSERT INTO nas_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Teeꞌkoo berira ookara nantoong amutemuuꞌ ning-koo barevare-nupoong deeng-antavereriaing aing aaꞌning miring-koo ntong-koo minkiererima meekaꞌantaverererima: tee Mmaꞌ eeꞌnoko ning Bauring eeꞌnoko tee Tanuaang Meekung. ");
INSERT INTO nas_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Eeꞌnoko nau-antavereriaing ookara kapooꞌnanka ninge diiꞌke nko-koo botorampiruꞌning siompaavaꞌnaang, eeꞌnoko ning tee bakei masikaꞌ diiꞌ ninka nariꞌ oꞌnoaing ookara batei-koo bera doong asiꞌnooꞌke basi.” ");
INSERT INTO nas_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aung doorenang tampara Jiisuuꞌ Karistooꞌ, Kumponing Bauring-koong. ");
INSERT INTO nas_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Eeꞌ tutumparuꞌ, Kumponinge urikamuꞌ Aisaiaꞌ karantavuma˜ Karistooꞌ nauvuuꞌnaꞌ nariꞌ, Daari Meekung-koo aaꞌpumanooꞌka, ");
INSERT INTO nas_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Ee aung, ninge botoampaing nkaang kara-nka daꞌkoo uroꞌke tee taung maamu-antareruaing uroitaaꞌ. Tee eeꞌ pinaꞌ otoaing, aurong narung naning-koong meeꞌboraꞌ sirakamaaꞌkoo bokuma aaꞌpumaang, ‘Maamu-antaveriaing tee taung Ovoring bakaang. Koompevuriai poainavung.’” ");
INSERT INTO nas_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Eeꞌnoko damaꞌke tee Jooni Minkinara tavoꞌkuuꞌ teke meeꞌboraꞌ sirakamaaꞌkoo nantoong ntong-koo minkivurima meekaꞌantavurima, minkunaa daankivurima. Aaꞌpurikoꞌ, “Bereꞌdarira ntong-koo minkirarima meekaꞌantarariaing eeꞌnoko Kumponinge diikaning orakaꞌ nkonanka tontaꞌderuriai.” ");
INSERT INTO nas_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eeꞌnoko ookara Judiaꞌnameng-nupoong eeꞌnoko Jerusalemaꞌnavuntuꞌnupoong berokoꞌ Jooni bakaang kara taara-koo. Eeꞌnoko biikaning orarananka siraꞌpariko ntong-koo minkivurima meekaꞌantavurikoꞌ teie Jooꞌdani-nari-koo. ");
INSERT INTO nas_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tee Jooni Minkinara tee tamung mononopaꞌ kaameliꞌkoong dapo-koo nkoniiꞌ kurumparakoꞌ eeꞌnoko dopaꞌnooꞌke tokoarakoꞌ. Ntaaꞌ maaꞌurikoꞌ eeꞌnoko davainta poraꞌkooning naivukoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Eeꞌnoko doorenampurima aaꞌpurikoꞌ, “Naning ning-koo damaꞌdue poaing aaꞌnaꞌ apooꞌmui otoing iirakuta, doonge-taara˜. Tee eeꞌnara poko aaꞌnaꞌ tampaꞌ taaraveriai! ");
INSERT INTO nas_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ninge tamung ntong-koo minkirampima meekaꞌantarampimaang, teka teie deekoꞌ Tanuaang Meekung ninka meekaꞌantaruriaing.” ");
INSERT INTO nas_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eeꞌnoko teing doong-koo kuunge Jiisuuꞌ nanuuꞌ Nasaretiꞌketa, Kaaleliꞌnameng-koonooꞌketa. Eeꞌnoko Joonie ntong-koo minkivura meekaꞌantavuuꞌ teka Jooꞌdani-koo. ");
INSERT INTO nas_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Eeꞌnoko Joonie oovuioꞌ Jiisuuꞌ ntong-eta doompeto daaꞌarako paning daateꞌaruꞌ, eeꞌnoko Tanuaang Meekung kuukuuꞌpinaꞌ siarara pouꞌ Jiisuuꞌkoo dau. ");
INSERT INTO nas_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eeꞌnoko kara auromparuꞌ paning-eta aaꞌpuma, “Daꞌ tee nnuring ninge piaaramaung, eeꞌnoko ning aung-koo aaꞌnaꞌ dotumaramaung.” ");
INSERT INTO nas_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Eeꞌnoko teketa namuꞌke Tanuaang Meekunge Jiisuuꞌ meeꞌboraꞌ sirakamaaꞌkoo tukovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Teke otoko, karenaumo kivora doong tankinuuꞌ Sietaniꞌke teka dauaꞌuko. Eeꞌnoko kauꞌkarenaumo biikonanka ninka nariꞌ otorokoꞌ, bera tee batei oparako koosinunankai porora puring-antavauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Teketaꞌ Eerotiꞌke Jooni Minkinara kiimata-nava-koo daiꞌuioꞌ Jiisuuꞌ Kaaleliꞌnameng-koo doorenang tampara daankivurima nanuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aaꞌpurima, “Batei enang dupearing eeꞌnoko Kumponing bakaang muuꞌ tee enang dueꞌ poing. Orara aarumo siperira Kumponing narung bakaang doorenang tampara masikaꞌantaveriai.” ");
INSERT INTO nas_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jiisuuꞌ Kaaleliꞌnaruꞌkoo miiringe nanuma Saimoniꞌ namainta Aanduruꞌ oovuretuꞌ sionung duaꞌureko teruꞌkoo, aiꞌ temainta tee taviꞌ baranka. ");
INSERT INTO nas_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Eeꞌnoko Jiisuuꞌke aaꞌpuretuꞌ, “Poreta ning siomereai, nantoong baranka deeng-antarampeainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Eeꞌnoko namuꞌke tee beekaang sionung sipureta Jiisuuꞌ siompuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Teketa napoꞌ okiꞌnooꞌ nanura Jeemisi namainta Jooni, Siebedi baurinketa, oovuretuꞌ bakaasi-koo otoroko sionung pateꞌaama. ");
INSERT INTO nas_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Eeꞌnoko namuꞌke bokuvuretuꞌ. Eeꞌnoko beuma Siebedi sipureta bakaasi-koo pakupaku-nupoong ninka otoroko Jiisuuꞌ siompuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Eeꞌnoko Kapaneumeꞌnavuntuꞌkoo nanauꞌ. Eeꞌnoko Doong Uaanaꞌmung Jiisuuꞌ pava dootuuꞌnava-koo koinura teka kara nau-antavuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Eeꞌnoko nantoong aaꞌnaꞌ taꞌnimpariruꞌ tee-koo bakaang nau-anta-koo, kara bakaang purintoꞌ deemparioꞌ, teing-pinaꞌ boto naunuka-pinaꞌ deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Eeꞌnoko teke biikaang pava dootuuꞌkoo naning maꞌnaang orara-poꞌnung otokoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Teie uiarama aaꞌpuuꞌ, “Jiisuuꞌ, Nasaretiꞌnung, arekeeꞌ nkomeriiꞌnaang? Daꞌ ee niiꞌ orari-anta-koo poing? Ninge noruꞌdansi oꞌnong daꞌ Kumponing-etaing Naning Meekung.” ");
INSERT INTO nas_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Teka Jiisuuꞌke tee akaꞌpuma aaꞌpuuꞌ, “Kareaukaꞌ eeꞌnoko daꞌ teieta bakoraravai.” ");
INSERT INTO nas_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eeꞌnoko teie maꞌnaange tee naning aaꞌnaꞌ bokuma nuanua-antavura teieta bakoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Eeꞌnoko ookara aaꞌnaꞌ taꞌnimpariruꞌ eeꞌnoko tanaꞌeema aaꞌpaakoꞌ, “Aing ee, aming tavoꞌkui? Aung pa nerakung kara! Pankaing-pinaꞌ karomaung. Bakei, maꞌnarie bakaang kara taaravaakooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eeꞌnoko Jiisuuꞌnung miring namuꞌke beremparuꞌ ookarai osi Kaaleliꞌnamenge. ");
INSERT INTO nas_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Enang teva pava dootuuꞌnava-ita Saimoniꞌ namainta Aanduruꞌ beekanavaꞌkoo koinauꞌ Jeemisi namainta ninka Jooni, Saimoniꞌ baꞌdoraa uipaariiꞌ ninka siipavora bempari otoko. ");
INSERT INTO nas_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jiisuuꞌ poko namuꞌke nauauꞌ teni. ");
INSERT INTO nas_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Teni-anko pora bireng-koo kompura deto teni daaꞌuuꞌ. Eeꞌnoko uipaariiꞌ namuꞌke boimpuuꞌ. Eeꞌnoko tenie bauꞌuruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Eeꞌnoko duaaꞌ tumparioꞌ ookara siipa-poꞌnupoong eeꞌnoko maꞌnarie koriaarikoꞌning tavoꞌaaruꞌ Jiisuuꞌanko. ");
INSERT INTO nas_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eeꞌnoko ookara temono-nupoong aarentokai naroꞌarira otorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Eeꞌnoko amutemuriiꞌ siipa-poꞌnupoong taare-antavuruꞌ, eeꞌnoko maꞌnari mmauꞌ bataꞌuruꞌ kara potevurima Jiisuuꞌ tasiꞌpaioꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Eeꞌnoko taneꞌ mmeꞌ siimpoorovuaruko˜ daaꞌarara Jiisuuꞌ tenkenuuꞌ, bera naning otoaꞌnooꞌ basiarara teke kunsiaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Teke otoko Saimoniꞌ baꞌmaikoriꞌ ninka porouꞌ besiꞌaama. ");
INSERT INTO nas_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eeꞌnoko teka peꞌnumpaaraiꞌnange aaꞌpauꞌ, “Ookarai daꞌ besiꞌdaamang.” ");
INSERT INTO nas_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Eeꞌnoko Jiisuuꞌke bariꞌurima aaꞌpuruꞌ, “Meriai ainge kato niiꞌning osinankai teing-koo napoꞌ daankimaravainaꞌ, aiꞌ ning tee teeꞌkoo simaring.” ");
INSERT INTO nas_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eeꞌnoko avitoitoi nanuuꞌ Kaaleliꞌ namenge pava dootuuꞌnairu-koo daankivurima, eeꞌnoko maꞌnari bataꞌuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Naning narung oramuuꞌpoꞌnung bataꞌauꞌnooꞌketa Jiisuuꞌanko pora miinge keemparuꞌ eeꞌnoko pakuvuuꞌnaang eentavarama aaꞌpuuꞌ, “Daꞌ piarora deekoꞌ ning kuimepeuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Eeꞌnoko Jiisuuꞌ bakaang domang aaꞌnaꞌ piaavora tee-koo, eeꞌnoko birenge kompuma aaꞌpuuꞌ, “Piamoi oꞌnong. Enang kuiraring!” ");
INSERT INTO nas_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Eeꞌnoko namuꞌke teie oramuuꞌke sipuko kiiroraaꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Eeꞌnoko Jiisuuꞌke botovuuꞌ tenkeng-koo. Eeꞌnoko aaꞌnaꞌ potevuma aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tarerari naning naueaukaꞌ, teka koontoꞌ bera piristiꞌkoo siraꞌantararavaing. Eeꞌnoko tampaꞌ ooruko Kumponing-koo boontunang nkoveai nantoonge tee taaꞌniꞌanta ooaara daꞌ teing ninka nariꞌ otoꞌkoo tauraꞌniiꞌ tasiꞌdaavainaꞌ, teeꞌ Moosesi bakaang botoi minkuvumanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Teka tee avitoitoi nanuuꞌ kara bereng-antavuma. Eeꞌnoko baruꞌ berempuioꞌ Jiisuuꞌ osi-koo sirapoꞌke daaꞌumparavarukoꞌ. Eeꞌnoko baka oovue bireꞌari otoko nantoonge teka beeroꞌaakoꞌ osinanka-ita beroma. ");
INSERT INTO nas_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Niiꞌning doong tankinuioꞌ Jiisuuꞌ napoꞌ toroaruꞌ Kapaneumeꞌnavuntuꞌkoo. Eeꞌnoko toroarako ooauꞌninge pava-koo otoko siraꞌpauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nantoong aaꞌnaꞌ karikaꞌ poroioꞌ otoꞌdoma otoaruuꞌ pava-koo kuunge eeꞌnoko karanaang-koo damaꞌdu. Eeꞌnoko Jiisuuꞌke nantoong teka kara daankivuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Eeꞌnoko tenang daankivuriko niiꞌning porouꞌ naning doota tavoꞌaama Jiisuuꞌanko, nantoong karenaumoi nkavaakotaaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eeꞌnoko nantoong karikaꞌke itoꞌaioꞌ Jiisuuꞌanko koontoꞌ tavoꞌaavaꞌ. Enang tee pava-koo kantuꞌda dipiꞌauꞌ Jiisuuꞌ otouꞌnooꞌka dau. Eeꞌnoko naning doota teke doonai sing-antavauꞌ bakaang taniꞌ ninka nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Eeꞌnoko tenang Jiisuuꞌke teing tee tavoꞌauꞌning biikaang baito oovura aaꞌpuuꞌ tee naning doota, “Ee aung, dakaning orarananka tontaꞌderonsing.” ");
INSERT INTO nas_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eeꞌnoko teinge boto naunukai teke baꞌnampariri tunsi-koo eeꞌ noruꞌaakoꞌ, ");
INSERT INTO nas_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Aming-koo aung kara menaankavumaang Kumponing bauvaupaaꞌuma? Naning otoaꞌ orara aarumo tontaꞌupeuꞌnung, Kumponing narung deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Teeꞌ tamung noruꞌaako Jiisuuꞌke namuꞌke iraakavurira aaꞌpuruꞌ, “Aming-koo teeꞌ noruꞌerimang? ");
INSERT INTO nas_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Arera kara masikaꞌpoaruko ooverira ning makosi deeaung tammeripeuꞌ aaꞌning-koo, aung doota eeꞌ minku-koo, ‘Dakaning orarananka tontaꞌderonsing,’ niiꞌnaꞌ eeꞌ minku-koo, ‘Daaꞌdarara dakaang taniꞌ nkavei naniai.’? ");
INSERT INTO nas_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Teka diiꞌke iroꞌ noruꞌkoo makosi ning Tee Naning-naumpoꞌ Paning-etaing kansiꞌkoo oꞌnoi orarananka tontaꞌkoo makosi...” Teeꞌpura tee naning doota aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ninge aaꞌdamaang, daaꞌdarara dakaang taniꞌ nkavei naniai dakanava-koo.” ");
INSERT INTO nas_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Teeꞌpuko daaꞌarara namuꞌke taniꞌ nkavui tenkenuuꞌ ooai otoko. Eeꞌnoko aaꞌnaꞌ taꞌninaara ookarai Kumponing daangampauꞌ aaꞌpaama, “Niiꞌke tero teeꞌ oroꞌ kapooꞌ ooampiaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Eeꞌnoko Jiisuuꞌ napoꞌ tenkenura miiruꞌ Kaaleliꞌkoo basiaruꞌ. Eeꞌnoko teke otoko nantoong karikaꞌ poroioꞌ kara nauvuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Eeꞌnoko teketa tenkenura Liivaiꞌ, Alopeasi bauring, oovuuꞌ taakisi nkavaakoꞌnava-koo baꞌnanuioꞌ bakanavaro-koo. Teketa Jiisuuꞌke aaꞌpuuꞌ, “Ning siomeai.” Eeꞌnoko Liivaiꞌke deto donkonura tenang-eta deto tee siompui nanuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Eeꞌnoko karikaꞌ nantoong orenanka eeꞌnoko napoꞌ taakisi nkanuka ninka Jiisuuꞌ nariꞌ siompauꞌ. Eeꞌnoko teing-koo nariong ninka Liivaiꞌ bakanavaꞌkoo nariꞌ taamanauꞌ Jiisuuꞌ bakaning barevare-nupoong ninka nariꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Eeꞌnoko teke taamanai otoroko nariong Boto Keperuuꞌnavitu-koo nau-antanukai ooauꞌ Jiisuuꞌ nariꞌ taamanaako oreng ninka eeꞌnoko taakisi nkanuka. Eeꞌnoko bakaning barevare-nupoong tanaꞌaarima aaꞌpaaruꞌ, “Aming-koo taakisi nkanuka ninka nariꞌ taamanaamaang eeꞌnoko nantoong orenanka ninka nariꞌ?” ");
INSERT INTO nas_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Eeꞌnoko Jiisuuꞌke taaravurira makuꞌurima aaꞌpuruꞌ, “Teing nantoong tampaꞌ otoromaing naninge nankaiꞌuriiꞌnaang piavoroaꞌ, teka teing siipavoromaing naing piavoromaung. Ning nantoong tampenanka-anko moaꞌ. Ning orenanka-koo mouꞌnung nauaranko bereꞌariaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jooni bakaning barevare-nupoong eeꞌnoko teing Boto Keperuuꞌnavitu biikaning unkumoariko nantoonge Jiisuuꞌanko porora tanaꞌaama aaꞌpauꞌ, “Aming-koo dakaning unkumoariaung?” ");
INSERT INTO nas_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Eeꞌnoko Jiisuuꞌke bariꞌurima aaꞌpuruꞌ, “Teka ee nantoong baraneeꞌ navitu nampeesi-koo poromaing naning nampeesinara ninka nariꞌ otoroi unkumoaripeuꞌ? Otoaꞌ, aiꞌ nantoong nampeesinara ninka nariꞌ otoroi unkumo-koo makotuaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Teka doonanka pomaang teing biiꞌmaikoꞌ teꞌnemparako unkumoariaing. ");
INSERT INTO nas_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Naninge baarong nerakanaaꞌ urikanaaꞌ ninka naroꞌka pateꞌuarupeuꞌ. Eeꞌnoko teeꞌ nkovuko deekoꞌ napoꞌ nerakanaaꞌke tenaaꞌ urikanaaꞌ beetoꞌuko aaꞌnaꞌ dereꞌarapeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Eeꞌnoko napoꞌ naninge uaini nerakaruꞌ urikaroꞌkoo pareꞌuarupeuꞌ. Teeꞌ nkovuko dei katekateꞌora teroꞌ nakaꞌupeuꞌ. Eeꞌnoko nakaꞌuko teruꞌ eeꞌnoko teroꞌ ookeng oraruꞌkupeuꞌ. Uaini nerakaruꞌ nerakaroꞌkoo deekoꞌ pareꞌkoo makosi.” ");
INSERT INTO nas_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Eeꞌnoko niiꞌnaꞌmung Doong Uaanaꞌmung-koo Jiisuuꞌ bakaning barevare-nupoong ninka nanauꞌ mintoong uiteꞌnaue˜. Eeꞌnoko bakaninge biiꞌdaꞌpaama nanauꞌ, Juꞌnupoong biikaang aarumo-koo tauraꞌpari otoinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Eeꞌnoko teinge Boto Keperuuꞌnavitue˜ Jiisuuꞌ aaꞌpauꞌ, “Ooveai. Aming-koo Doong Uaanaꞌmung-koong boto totoꞌpaamang dake bare-antaverimainge?” ");
INSERT INTO nas_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Diiꞌke aming-koo teeꞌ tuumpimerimaang? Tampaꞌ noruꞌeri otong tee kapooꞌ Deevitaꞌke nkovuuꞌnung tenang Abietaꞌke piristiꞌ pankaing deempari otouꞌnang, tenang teing ataꞌai peeravorora, tee eeꞌnoko teing nariꞌ otorokoꞌning ninka; ");
INSERT INTO nas_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kumponing bakanava-koo Deevitaꞌke koinura, nkavura naiauꞌ tee taamang meekung, niiꞌninge nai-koo tauraꞌparavaꞌ, teka piristiꞌnuka nainge deekoꞌ nai-koo makosi. Eeꞌnoko teie Deevitaꞌke teing nariꞌ otorokoꞌning avurioꞌ boto totoꞌkoo tuumpiaavaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Kumponinge Doong Uaanaꞌmung nkomemuruꞌnung niiꞌkoo boonge otoi pakumuri otoꞌkoo. Eeꞌnoko teꞌmung-koo boong siꞌmuriaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Teeꞌkoo ning Tee Naning-naumpoꞌ Paning-etaing tee Ovoring Doong Uaanaꞌmung-koong.” ");
INSERT INTO nas_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Eeꞌnoko Jiisuuꞌ napoꞌ toroaruꞌ dootuuꞌnava-koo, naning teke otoko bireng duuaiꞌ. ");
INSERT INTO nas_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Eeꞌnoko niiꞌninge Jiisuuꞌ nempai otorouꞌ teꞌmung doong meekung-koo taare-antavuko ooaara tuumpiaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Eeꞌnoko Jiisuuꞌke duuaiꞌ karavuma aaꞌpuuꞌ, “Poai aꞌ uroꞌkanooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Eeꞌnoko aaꞌpuruꞌ, “Boto ee Doong Uaanaꞌmung-koo kapooꞌ tampara aiꞌ naning orari-anta nko-koo tauraꞌmuri otong? Aiꞌ domang-antanaꞌmunge, aiꞌ dupisiꞌnaꞌmunge?” Eeꞌnoko teing Boto Keperuuꞌnavitu˜ tenang dooroompariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Eeꞌnoko Jiisuuꞌke domang tupuꞌpaaꞌnuka-koo mankiꞌoi noruꞌurira iiravoi oovuruꞌ. Eeꞌnoko tenang duuaiꞌ aaꞌpuuꞌ, “Bireng tovoroꞌdaravai.” Eeꞌnoko tovoroꞌarama tamparuꞌkuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Eeꞌnoko Boto Keperuuꞌnavitu siarira Eerotiꞌ bakanariong ninka mumunsiariruꞌ Jiisuuꞌ tavuꞌnaꞌ matauaama. ");
INSERT INTO nas_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Eeꞌnoko Jiisuuꞌ bakaning barevare-nupoong ninka tenkenauꞌ bera nuaruꞌ Kaaleliꞌ dueꞌ. Eeꞌnoko nantoong miatarai siompauꞌ osi kante-ita porora, nariong Kaaleliꞌnupoong, Judiaꞌnupoong, Jerusalemaꞌnupoong, Idumeaꞌnavaro-nupoong, Taiaꞌnupoong, Saidoniꞌnupoong. ");
INSERT INTO nas_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Karikaꞌ porouꞌ taaravaakotaaꞌ kapooꞌ Jiisuuꞌke nkovukoꞌning. ");
INSERT INTO nas_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Eeꞌnoko mmauꞌ nantoong naroꞌaririoꞌ Jiisuuꞌke bakaning barevare-nupoong botovuruꞌ bakaasi neri-koo karikaꞌke papurankaꞌaaꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jiisuuꞌke karikaꞌ nantoong taare-antavurioꞌ ookara siipa-poꞌnupoong Jiisuuꞌanko tuueneveuꞌ kompaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Eeꞌnoko maꞌnari oreng-poꞌnupoonge Jiisuuꞌ ooaama uroꞌkanooꞌ duaꞌarima bokiaama aaꞌpaakoꞌ, “Daꞌ bakei Kumponing Bauring.” ");
INSERT INTO nas_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eeꞌnoko Jiisuuꞌke koontoꞌ orokovuriko siraꞌpaaꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Eeꞌnoko Jiisuuꞌ deto iuꞌkoo koinuuꞌ eeꞌnoko teketa bokuvuruꞌ nantoong piavokoꞌning. Eeꞌnoko bokuvurioꞌ porouꞌ tee-anko. ");
INSERT INTO nas_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Eeꞌnoko nanaiꞌketa kenaanka kara okovuri nkanuka miruꞌurima aaꞌpuruꞌ, “Diiꞌ niꞌninka nariꞌ otoriaining eeꞌnoko damaꞌke botorampiai nantoong daanki-koo. ");
INSERT INTO nas_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Eeꞌnoko iriꞌ otoꞌderuriaininge maꞌnari oreng bataꞌkoong.” ");
INSERT INTO nas_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Aing teing Nanaiꞌketa Kenaankara Jiisuuꞌke miruꞌuruꞌning: Saimoniꞌ, niiꞌnooꞌ Piita, Jiisuuꞌke tampuuꞌnooꞌ; Jeemisi namainta Jooni, Siebedi baurinketa, niiꞌnooꞌ Boanesi baurinketa Jiisuuꞌke bokuvuretuꞌnooꞌ, kuunooꞌ kurung-pinaꞌ karara; Aanduruꞌ; Pilipiꞌ; Baatolomiuꞌ; Maatiuꞌ; Toomasi; Jeemisi, Alopeasi bauring; Taꞌdeasi; Saimoniꞌ, Juꞌnupoong biiꞌka donkong-koo pia-navitu-koong; eeꞌnoko Judasi, Kerioꞌnara, tee tooka kompui Jiisuuꞌ tauraꞌpuuꞌnung bakaning kare-nupoong-koo. ");
INSERT INTO nas_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Eeꞌnoko Jiisuuꞌ napoꞌ osi-aape toroaruꞌ otokoꞌnooꞌ. Eeꞌnoko nantoong miatara porora naroꞌariruꞌ, eeꞌnoko Jiisuuꞌ teing ninka bakaning barevare-nupoong taamanaapeuꞌnang batei otoꞌevuriaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eeꞌnoko baukorovoi tee taaravaara berouꞌ mooꞌaara barampaavaꞌnaang nantoonge kanuꞌ narung tampaako. ");
INSERT INTO nas_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Eeꞌnoko nariong boto naunuka-koo Jerusalemaꞌketa porouꞌninge aaꞌpaakoꞌ, “Kopeu deeꞌma kurumaaꞌaring.” Eeꞌnoko napoꞌ narionge aaꞌpaakoꞌ, “Eeꞌ, masikung, aiꞌ pa maꞌnari biikaang pankaing bakaang purintoꞌ ninka bataꞌurimatoinge.” ");
INSERT INTO nas_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eeꞌnoko Jiisuuꞌke nantoong naroꞌ bokuvurira aung kara mirumiruꞌ nauvurima aaꞌpuruꞌ, “Teka maꞌnaang orarai napoꞌ maꞌnaang orara arekeeꞌ bataꞌupeuꞌ? ");
INSERT INTO nas_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Eeꞌnoko napoꞌ narung muuꞌ baka siivenkeꞌarara deto donkonuarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Eeꞌnoko napoꞌ narung puataꞌ siivenkeꞌarara nariꞌ donkonaavarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Eeꞌnoko Sietaniꞌ bakaning maꞌnari turampeera biikaang muuꞌ siivenkeꞌarara pankaroompuaꞌ napoꞌ duaꞌarara paaꞌarapeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Naning purintoꞌ bakaang pava-koo oovunara tumparara kapooꞌnanka nkavuarupeuꞌ iroꞌ okonara tavuitaaꞌ daiꞌuarura. Eeꞌnoko daiꞌura deekoꞌ pariꞌupeuꞌ bakanava-kooning kapooꞌnanka. ");
INSERT INTO nas_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Noruꞌeriaing aung, Nantoong biikaang orarananka tontaꞌkoo makosi eeꞌnoko amutemuriiꞌ orakaꞌ minku tontaꞌkoo makosie. ");
INSERT INTO nas_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Teka naning Tanuaang Meekung Kopeu dovang tampuma daviraaꞌumaung tontaꞌanta kompuaukaꞌnung. Bakaang orara teeꞌ nariꞌ otoi otoaing.” ");
INSERT INTO nas_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Teeꞌ nauvuruꞌ Jiisuuꞌke, maꞌnaang orara otoꞌpoꞌnung tampaioꞌ. ");
INSERT INTO nas_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eeꞌnoko Jiisuuꞌke teeꞌ minkuvuko teni ninka bauko eeꞌnoko baaraꞌmainkaang tee tavoꞌariruꞌ. Eeꞌnoko damaꞌdu donkonaitaaꞌ kara Jiisuuꞌanko beꞌantavauꞌ pora teing oo-koo. ");
INSERT INTO nas_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eeꞌnoko nantoonge Jiisuuꞌ ninka baꞌnampariri otorokoꞌninge aaꞌpauꞌ, “Daukorovoi damaꞌdue nentaamaang.” ");
INSERT INTO nas_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Baie ninge nkoꞌ? Eeꞌnoko baatai ninge ntaraꞌmainkaang?” ");
INSERT INTO nas_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eeꞌnoko nantoong nariꞌ baꞌnaniauꞌning-aape bereꞌarara aaꞌpuruꞌ, “Ooveriko, ninge nkoꞌdovo makosinuka aing.” ");
INSERT INTO nas_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nantoong ninge ntaraꞌmainkaang eeꞌnoko mmarikaampi eeꞌnoko nkoꞌkaampi makosinuka teing Kumponing piavomanaꞌ nariꞌ nkoaamaing. ");
INSERT INTO nas_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Niiꞌnaꞌmung Jiisuuꞌke kara nau tutumpuruꞌ Kaaleliꞌnaruꞌkoo dueꞌka. Eeꞌnoko nantoong karikaꞌ Jiisuuꞌanko naroꞌaririoꞌ Jiisuuꞌ bakaasi-koo baꞌnamparuꞌ nuaruꞌkoo daue otoko eeꞌnoko nantoong tapiru-nairu-koo donkonauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eeꞌnoko Jiisuuꞌke minkunaananka mirumiruꞌketa nau tutumpurima aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Taaraveriai. Naning narung mintoong-koo sinang tanka-koo nanura aaꞌnouꞌ: ");
INSERT INTO nas_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Niiꞌning sinang taung-koo dau duaꞌariruꞌ eeꞌnoko barennankai porora teka tunturavauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Eeꞌnoko niiꞌning sinang dakurakung-koo dau duaꞌariruꞌ kapang-koo dau otomaung-koo, eeꞌnoko daꞌdeng narung dupuuꞌ, teꞌ kansiꞌ baruꞌ aavetaꞌnooꞌ deemparako. ");
INSERT INTO nas_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Eeꞌnoko batei doonkenang bakaang-koo tee keenkeeng maraꞌouꞌ teke, baruꞌ biira doonko nanuaung deemparara kansiꞌ baruꞌ makotuaꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eeꞌnoko niiꞌning sinang napoꞌ tooꞌmurintaaꞌ otoroinooꞌ meuꞌ duaꞌariruꞌ eeꞌnoko nariꞌ dupurira tooꞌmurintaaꞌke iinkenevuuꞌ tee keenkeeng. ");
INSERT INTO nas_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Eeꞌnoko niiꞌning kansiꞌ pankauanooꞌ duaꞌariruꞌ eeꞌnoko teke dupurira sinang aaꞌnaꞌ biꞌuruꞌ beenaumo kivora-pinaꞌ eeꞌnoko niiꞌning ˜narung-taa kivora-pinaꞌ eeꞌnoko niiꞌning daakuꞌpinaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Eeꞌnoko aaꞌpuruꞌ, “Diiꞌ punkang-poꞌnupoong deekoꞌ enang taaraveriai!” ");
INSERT INTO nas_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Eeꞌnoko Jiisuuꞌ baka otoko niiꞌninge taaravaara porouꞌ teing ninka bakaning Nanaiꞌketa Kenaankara ninka, eeꞌnoko tanaꞌauꞌ kara dipiꞌuaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tanaꞌaako bariꞌuruꞌ, “Kumponinge diiꞌ bakaang kara pinkaꞌerimaing tauraꞌduruꞌnung makensiꞌnung-koo miruꞌnooꞌ noruꞌeriiꞌnaang tee-koo bakaang muuꞌkoo nkoaramanaꞌ, eeꞌnoko damaꞌdu otoromainge kara mirumiruꞌ narung taaravaavaing. ");
INSERT INTO nas_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Teeꞌ Daari Meekunge minkuvuma aaꞌpuuꞌnaꞌ, ‘Bane ooaama teka papaaravarimatoai. Bane taaravaama teka tasiꞌpariaꞌ otoroai, Kumponing-koo bereꞌariko orara aarumo tontaꞌevuriꞌneeng-koo.’” ");
INSERT INTO nas_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Aung mirumiruꞌ ee miruꞌnooꞌ diiꞌke bakei noruꞌeriaꞌ? Arekeeꞌ noruꞌeriainge ookara-koong miruꞌnooꞌ? ");
INSERT INTO nas_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aung Kumponing bakaang kara tankanarai sinang pinaꞌ tankavuuꞌnu. ");
INSERT INTO nas_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sinang taung-koo duaꞌariruꞌning miruꞌnooꞌ eeꞌ oroꞌ: Nantoonge kara taaravaako Sietaniꞌke namuꞌke poma pariꞌurikooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Eeꞌnoko sinang dakurakung-koo duaꞌariruꞌning miruꞌnooꞌ eeꞌ oroꞌ: Niiꞌninge kara taaravaama doturotu-eta kompaamaung. ");
INSERT INTO nas_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Eeꞌnoko tee kara tampaꞌ ariꞌavuaruma eeꞌnoko turanturang poko tee-koo kara-koo biikaang baito namuꞌke orariarakooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Eeꞌnoko tee sinang tooꞌmurintaaꞌkoo meuꞌ duaꞌariruꞌning-koo eeꞌ miruꞌnooꞌ: Narionge baruꞌ pankaruntoonge noruꞌaakooꞌ kavonanka piaavaama eeꞌnoko amutemuriiꞌ kapooꞌ karaaꞌaakooꞌ, eeꞌnoko teinge booniꞌukooꞌ tee karakara eeꞌnoko sinang biꞌuarukooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Eeꞌnoko sinang kansiꞌ pankauang-koo duaꞌariruꞌning miruꞌnooꞌ eeꞌ oroꞌ: Niiꞌning nantoonge tee kara tariiꞌoroi taaravaako biꞌumaung niiꞌning-koo beenaumo kivora-pinaꞌ, niiꞌning-koo ˜narung-taa kivora-pinaꞌ eeꞌnoko niiꞌning-koo narung daakuꞌpinaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jiisuuꞌke aaꞌpuruꞌ, “Naning diiꞌkoonge bakaang araka paroꞌura antonaꞌkoo boong niiꞌnooꞌ batanang-koo boong ee sipupeuꞌ? Aiꞌ dau batanang-koo sipupeuꞌ? ");
INSERT INTO nas_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kapooꞌ enang makempari otoing damaꞌ siraꞌanta-koong. Eeꞌnoko kapooꞌ enang daꞌpari otoing damaꞌke daateꞌnumpoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Diiꞌ nantoong punkang-poꞌnupoong deekoꞌ enang taaraveriai!” ");
INSERT INTO nas_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Eeꞌnoko napoꞌ eeꞌ minkuvuruꞌ, “Kara taaraverira siomperiai. Damaꞌke nkoveriainooꞌ basinooꞌ napoꞌ nkaveriaing, eeꞌnoko Kumponinge napoꞌ dau basinooꞌ aruriai. ");
INSERT INTO nas_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Naning avuavuꞌ aaꞌnaꞌ kompumaung damaꞌke deto basinooꞌ kompuaing, eeꞌnoko naning avuavuꞌkoo nuaku otoꞌevuining damaꞌ pariꞌnumpoꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jiisuuꞌke aaꞌpuruꞌ, “Kumponing bakaang muuꞌ naninge bakaang mintoong-koo sinang tankavupeuꞌnaꞌpinaꞌ oroꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Eeꞌnoko muunga aatuma doonga avitoitoi nanuko sinang baka pekiꞌkura dupupeuꞌ teie noruꞌuaruko. ");
INSERT INTO nas_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Baka kansiꞌke duꞌantavuko pankaꞌparama sinang biꞌumaung. Tutunaꞌ dupuma pankaꞌparama biꞌukooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Eeꞌnoko sinang petaaꞌuma meuraꞌuko naninge tenang kavupeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Teka niiꞌke aminge miruꞌampipeuꞌ Kumponing bakaang muuꞌ? Eeꞌnoko aminge mimpama sirakaꞌantavampeuꞌ? ");
INSERT INTO nas_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tee aaꞌ sinanu okiꞌnu-pinaꞌ oroꞌnu masitaraꞌkoonu. ");
INSERT INTO nas_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bane temuriiꞌ mukusiriꞌ ookara sinang kansiꞌkoo keempaamaing-eta, teka tenang naninge kansiꞌkoo keempuko dupura pankaꞌparama taamang mintoong-kooning divuꞌura kaumpeꞌnanka tampaꞌ tovoroꞌarapeuꞌ eeꞌnoko amutemuriiꞌ barenge bito kaniaama teke ueemparipeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jiisuuꞌke teeꞌ oroꞌning mirumiruꞌ amutemuriiꞌke kara nauvurikoꞌ teinge arooꞌaakoꞌninge nainge noruꞌ nka-koo makosinaꞌ mantompuritaaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Eeꞌnoko kapooꞌ nauvuriaꞌ mirumiruꞌpoꞌnung deeaung. Eeꞌnoko bakaning barevare-nupoong ninka deekoꞌ biiꞌka otoroitaaꞌ miruꞌnooꞌ siraꞌpukoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Teꞌmung doong muung-aapevuioꞌ Jiisuuꞌke bakaning barevare-nupoong aaꞌpuruꞌ, “Enang nuaruꞌka amenkaꞌkoo pakoꞌmariai.” ");
INSERT INTO nas_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eeꞌnoko nantoong karikaꞌ teka sipaarira Jiisuuꞌ ninka bakaasi-koo aaꞌearira tenkenauꞌ. Niiꞌning bakaasie nariꞌ berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nanai otoroko piong pankaing basiaruꞌ eeꞌnoko bakaasi booꞌai dapiꞌ minkivukoꞌ, Jiisuuꞌ boreꞌ patuꞌari aatuioꞌ bakaasi-koo damaꞌdue. ");
INSERT INTO nas_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Eeꞌnoko bakaninge tanteaama aaꞌpauꞌ, “Nau-anta, daꞌ ee taraꞌdoaꞌ keꞌnuruꞌmarimaang?” ");
INSERT INTO nas_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Eeꞌnoko tee tantearara piong eeꞌnoko tee eemaruꞌ ntong-koong akaꞌpuma aaꞌpuuꞌ, “Bakerari dooroontaravai.” Eeꞌnoko piong bakearako nuaruꞌ tenang aaꞌnaꞌ taarorovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Teketa teie makuꞌurima aaꞌpuuꞌ, “Diiꞌ aming-koo arorerining? Diiꞌ ee baitoropanuka?” ");
INSERT INTO nas_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eeꞌnoko taꞌnimparira tanaꞌeema aaꞌpeekoꞌ, “Aung naning baa piong tovange eeꞌnoko ntong taaravaakooꞌ?” ");
INSERT INTO nas_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Eeꞌnoko Nuaruꞌ Kaaleliꞌ pakoꞌaara Kerasaꞌnupoong biikanameng-koo berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Eeꞌnoko Jiisuuꞌ bakaasi-eta siarako naning maꞌnaang orara-poꞌnunge kuneꞌuuꞌ kuvi dakoꞌdomanairu-eta basiarama. ");
INSERT INTO nas_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aunooꞌ dakoꞌdomanairu-koo otokoꞌnung teroita. Naninge patauꞌuarukoꞌnunge bane sieenai daiꞌaama. ");
INSERT INTO nas_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mmauꞌ doong-koo sieena dovange kuuka daiꞌaako totoraꞌpukoꞌ okiꞌnooꞌnaꞌ. Naning purintoꞌ tapupunara otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Doong eeꞌnoko muung ataꞌuma nanukoꞌ dakoꞌdomanairue eeꞌnoko iuꞌnankai. Eeꞌnoko bakaang mono uiarama kapange datoꞌarakoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eeꞌnoko isipoꞌketa Jiisuuꞌ oovui kuaꞌpari pora tee-koo uroꞌkanooꞌ kinkinura pankaing-antavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Eeꞌnoko Jiisuuꞌke akaꞌpuma aaꞌpuuꞌ, “Dake maꞌnaang orarai aung naning sipeai.” ");
INSERT INTO nas_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Eeꞌnoko teeꞌpuko bokuma aaꞌpuuꞌ, “Jiisuuꞌ, Kumponing Deto Basi Bauring, dake ning arekeeꞌ nkomeeꞌnaang piaroing? Daꞌ Kumponinge pote-koo piamomaang ning toraꞌantameꞌneeng-koo.” ");
INSERT INTO nas_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Eeꞌnoko Jiisuuꞌke tanaꞌuma aaꞌpuuꞌ, “Daꞌ miring baa?” Eeꞌnoko teie bariꞌuma aaꞌpuuꞌ, “Ning miring Miatara. Niiꞌ aaꞌnaꞌ karikaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eeꞌnoko tanaꞌuma aaꞌpuuꞌ, “Jiisuuꞌ, aing maꞌnari avoraꞌketa bataꞌeriaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Eeꞌnoko teketa dueꞌke mii-koo navete-aapei pooroꞌnanka meruꞌarima otorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eeꞌnoko maꞌnari orenge Jiisuuꞌkoo eentavarima aaꞌpauꞌ, “Tauraꞌmeriko merira tumariai pooroꞌnanka-koo.” ");
INSERT INTO nas_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Eeꞌnoko Jiisuuꞌke tauraꞌpuruꞌ. Eeꞌnoko teing maꞌnari bakoarira pooroꞌnanka-koo tumpariruꞌ. Eeꞌnoko pooroꞌ naroꞌka kenaanka kokoreiꞌkoo˜ makosining pemue doonko kooꞌarira nuaruꞌkoo bera keꞌnuruꞌariruꞌ teke. ");
INSERT INTO nas_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eeꞌnoko teing pooroꞌ bauꞌaarikoꞌning mmariauꞌ eeꞌnoko aung eeꞌ oroꞌ basiarioꞌ doorenang avitoitoi bereng-antavauꞌ. Eeꞌnoko taaravaara nantoonge berouꞌ ooaavaꞌnaang kapooꞌ nkoaruꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Eeꞌnoko Jiisuuꞌanko poroma aung naning tutunaꞌ maꞌnari-poꞌnung duaanavari baꞌnanui otoko ooauꞌ bakaang noruꞌ matauari, eeꞌnoko avoreauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eeꞌnoko maꞌnari-poꞌnung-koo eeꞌnoko pooroꞌkoo nkoaruꞌnaꞌ ooauꞌninge tampaꞌ nauaaruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eeꞌnoko Jiisuuꞌ teing biikanameng-eta tenkeng-koo piavorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Eeꞌnoko Jiisuuꞌ bakaasi-koo beko aung naning maꞌnari-eta tamparuꞌkuuꞌnung nariꞌ tee ninka piavouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Tee aaꞌ daꞌ otoko. Daꞌmaikoriꞌanko tororarara kapooꞌ pankaing Kumponinge piaarura daꞌkoo nkovuinaꞌ naueriaing.” ");
INSERT INTO nas_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eeꞌnoko aung naning tenkenura osinanka kivora-koo kuunge nanuma nauvurikoꞌ kapooꞌ taꞌnimpaariiꞌ Jiisuuꞌke tee-koo nkovuuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jiisuuꞌ napoꞌ toroarama nuaruꞌ pakoꞌuitaaꞌ niiꞌnameng-aape beuꞌ, eeꞌnoko nantoong karikaꞌ piisiꞌkoo naroꞌariruꞌ Jiisuuꞌanko. ");
INSERT INTO nas_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eeꞌnoko naning dootuuꞌnava tantanuka-koong narung miring Jairasi Jiisuuꞌkoo kauꞌkanooꞌ kiunura eentavarama aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Nnorang boomang. Daꞌ pora tankaꞌ panteꞌeko taarevoai.” ");
INSERT INTO nas_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eeꞌnoko Jairasi ninka nanuretuꞌ. Eeꞌnoko nantoong karikaꞌ biꞌariruꞌ itoveitaaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Eeꞌnoko niiꞌnani manikuma otokoꞌ mareꞌ kivora-ita kemareꞌka-koo tarumatearakoꞌnani, mmauꞌ batei-koo boorinang ninka avitoitoi nankaiꞌaavaꞌnaang nanukoꞌnani. ");
INSERT INTO nas_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Taarevoaꞌ baruꞌ biaꞌokoꞌ bera boorinang oꞌsiiviuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Eeꞌnoko Jiisuuꞌkoong doorenang taaravura eeꞌ noruꞌaruꞌ, “Bane okiꞌnooꞌ kompamira bakaang mononopaꞌkoo, ning teni taaremoainani.” ");
INSERT INTO nas_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Eeꞌnoko teni damaꞌke poraiꞌnang karikaꞌkoo meuꞌka Jiisuuꞌkoo biirokanooꞌketa baarong-koo komparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eeꞌnoko kompura namuꞌke ereng tempampuuꞌ eeꞌnoko taarevouꞌnaꞌ mono mantomparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Eeꞌnoko tenang Jiisuuꞌ bakaang iriꞌke sipuko mantomparuꞌ, eeꞌnoko namuꞌke karikaꞌkoo meuꞌke berevereꞌarama aaꞌpuuꞌ, “Baie baarong komeng?” ");
INSERT INTO nas_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eeꞌnoko bakaning barevare-nupoonge bariꞌaama aaꞌpauꞌ, “Teka daꞌ nantoong karikaꞌkoo meuꞌke otoi arekeeꞌkoo aaꞌpemaang, ‘Baie komeng?’” ");
INSERT INTO nas_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Eeꞌnoko Jiisuuꞌ teke berevereꞌarakoꞌ kompuuꞌnani besiꞌuma. ");
INSERT INTO nas_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eeꞌnoko temuriiꞌ kapooꞌ teni-koo nkoaruꞌnung baka tampaꞌ tasiꞌparitaaꞌ Jiisuuꞌanko avoroi dankusiꞌkuma pora kinkinuuꞌ eeꞌnoko ookara tampaꞌ sirakaꞌpui nauvuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ teniꞌ, “Ani ee, daꞌ dakaang baitoi taareroinani. Mooa ninka naniaing. Teeꞌ nariꞌ taareroi otoainani.” ");
INSERT INTO nas_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Eeꞌnoko Jiisuuꞌke teni karavui otoko Jairasi bakanooꞌketa nantoong porora aaꞌpauꞌ, “Daurang boinani. Arekeeꞌkoo napoꞌ Nau-anta poreꞌantaveaꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Eeꞌnoko Jiisuuꞌke taaravura nasinuaꞌ dootuuꞌnava tanata aaꞌpuuꞌ, “Aroreaukaꞌ, masikaꞌantaveko naroꞌ!” ");
INSERT INTO nas_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eeꞌnoko Jiisuuꞌ nantoonge siong-koo potearioꞌ Jeemisi namainta Jooni eeꞌnoko Piita, teing nainge siompai berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Eeꞌnoko dootuuꞌnava tanatanuka-koong bakanavaꞌkoo tavoꞌarira nantoong karakararearima birong tovang eeꞌnoko ui nkoaako oovuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Eeꞌnoko pava-koo tumparara aaꞌpuruꞌ Jiisuuꞌke, “Diiꞌ aming-koo birontarimang baruꞌ naampaverima? Ani okiꞌnani booaꞌ, teka tamung aatumaang.” ");
INSERT INTO nas_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Eeꞌnoko teinge benkempauꞌ tee. Eeꞌnoko ookara birong-nupoong damaꞌdu sing-koo botovurira tootoꞌ baumararing ninka Piita eeꞌnoko Jeemisie namainta Jooni teing naing bokuvurira teni otouꞌnavaro-koo tumpariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eeꞌnoko Jiisuuꞌke teni bonkuꞌ bireng-koo kompura aaꞌpuuꞌ, “Talita kumi.” Kuunooꞌ eeꞌ minkuvuioꞌ, “Okiꞌnani, aaꞌdamaang: Daaꞌdaravai.” ");
INSERT INTO nas_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Eeꞌnoko teni namuꞌke daaꞌarara nanuꞌnanuuꞌ. Bakaning mareꞌ kivora-ita kemareꞌka divuꞌ. Eeꞌnoko aung kapooꞌ teeꞌ oroꞌ tavoꞌkuioꞌ nantoong taꞌnimpariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Eeꞌnoko Jiisuuꞌke aung doorenang koontoꞌ naning nau-koo potevurima aaꞌpuruꞌ, “Taamang-koo teni averiko naikuai.” ");
INSERT INTO nas_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jiisuuꞌ teketaꞌ tenkenura bakanameng-aape toroaruꞌ, eeꞌnoko bakaninge siompaitaaꞌ berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Eeꞌnoko Doong Uaanaꞌmung pava dootuuꞌnava-koo daanki tutumpuuꞌ. Eeꞌnoko nantoong karikaꞌke taaravaara sinkaꞌorora aaꞌpauꞌ, “Aung amuriiꞌ kara areꞌka nkavuuꞌnung? Eeꞌnoko aung matau eeꞌ oroꞌ baie avuuꞌnunge? Eeꞌnoko aung taꞌnimpaariiꞌnanka iriꞌpoꞌning arekeeꞌ tavoꞌantavumaunge? ");
INSERT INTO nas_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aung ee eeꞌnara tee Meeriꞌ bauring deeaꞌ, tamung anke pava-kani? Jeemisi, Joosesi, Judasi eeꞌnoko Saimoniꞌ aung ninka namaiaꞌ ee deeaꞌ? Eeꞌnoko baꞌmarikaampi anke niiꞌ ninka ee otoroaꞌ?” ");
INSERT INTO nas_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Eeꞌnoko teing tee-koo domang orakaꞌ otoroko Jiisuuꞌke aaꞌpuruꞌ, “Napoꞌ ookara niiꞌning nakaro-nupoong-koo teeꞌke, nantoonge oovunooꞌka pankaing-antavaarimaung, teka biikanooꞌka deeaꞌ, eeꞌnoko biiꞌmarange deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eeꞌnoko mintoong baruꞌ purintoꞌ nkovuarupeuꞌ teke. Eeꞌnoko niiꞌning deekoꞌ siipa-poꞌnupoong taare-antavuripeuꞌ tankaꞌke panteꞌurima. ");
INSERT INTO nas_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Eeꞌnoko Jiisuuꞌ taꞌnimparuꞌ teing-koo baitoropanuka. Eeꞌnoko osinankai nanuma nantoong nau-antavuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Eeꞌnoko Jiisuuꞌke bakaning barevare-nupoong nanaiꞌketa kenaankara naroꞌ bokuvuruꞌ eeꞌnoko irikung-antavuruꞌ. Eeꞌnoko teketa kenaankaranaꞌ botovuruꞌ maꞌnari oreng bataꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Eeꞌnoko aaꞌpuruꞌ, “Kapooꞌ nkaveriaukaꞌ, donsiꞌ narung deekoꞌ. Taꞌmariꞌ deeaꞌ, bakura deeaꞌ, mooniꞌ deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Boonamante˜ narung deekoꞌ siꞌdariaing. Eeꞌnoko mononopaꞌkoo nanaaꞌ nkaveriai.” ");
INSERT INTO nas_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eeꞌnoko napoꞌ aaꞌpuruꞌ, “Osi duꞌdariko teka bokuraariaining ninka otoriai bera temono-ita tenkeniriainooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eeꞌnoko Niiꞌnavuntuꞌkoo onkeonkeꞌdaariarura taararaariaruko deekoꞌ tenkeniriai temono-ita eeꞌnoko daꞌmong peꞌnaaꞌkoong teꞌ tankaveriai temono Kumponing-koo maarekusiꞌnooꞌ taaꞌniꞌantaveri.” ");
INSERT INTO nas_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eeꞌnoko teing tenkenaara daankiarima aaꞌpauꞌ, “Bereꞌdarirai orara aarumo-ita.” ");
INSERT INTO nas_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eeꞌnoko mmauꞌ maꞌnari oreng bataꞌaaruꞌ. Eeꞌnoko karikaꞌ siipa-poꞌnupoong duuni dau kooꞌaariko taarevorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Enang tee Daurarong˜ Eerotiꞌke Jiisuuꞌnung doorenang beremparioꞌ taaravuuꞌ aaꞌpaako, “Jooni Minkinara booꞌketa napoꞌ daaꞌaring, eeꞌnoko teeꞌkoo purintoꞌ ninka mintoomparamaang.” ");
INSERT INTO nas_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Eeꞌnoko niiꞌninge aaꞌpaakoꞌ, “Tee aaꞌ Eliasi pa.” Eeꞌnoko niiꞌninge napoꞌ aaꞌpaakoꞌ, “Aung aaꞌ narung nakaronara pankaing urikavarang-koong.” ");
INSERT INTO nas_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eeꞌnoko Eerotiꞌke taaravuraiꞌnange aaꞌpuuꞌ, “Aung aaꞌ Jooni Minkinara ninge kuru bituꞌantuꞌnooꞌketa napoꞌ domamparara otong.” ");
INSERT INTO nas_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Teka tutunaꞌ Eerotiꞌ teni ninka Erodiasi, baaraꞌmaꞌnung Pilipiꞌ baꞌaang ninka otorekoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Eeꞌnoko Joonie Eerotiꞌ tautauvuma aaꞌpukoꞌ, “Daꞌ bakei boto totoꞌpeitaaꞌ daaraꞌmaꞌnung baꞌaang ninka otoremaatoing.” ");
INSERT INTO nas_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Eeꞌnoko tenang Erodiasi iiravouꞌ teeꞌ minkuvioꞌ. Eeꞌnoko Eerotiꞌke teni dotu-anta-koo bakaning botovuruꞌ Jooni mooꞌaara daiꞌaavaꞌnaang pava kiimata-koo. ");
INSERT INTO nas_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erodiasie napoꞌ domang dupisiꞌkoo piavoko Eerotiꞌ tavuꞌkoo kupiꞌora donkonuꞌuuꞌ avoroitaaꞌ Jooni-koo, aiꞌ Eerotiꞌke Jooni tee tampaꞌ noruꞌui otokoꞌnung, naning koontoꞌ eeꞌnoko meekarai. Eeꞌnoko bane teie, Eerotiꞌke Jooni taaravuma noruꞌ mankiꞌokoꞌnunge, teka tee taara-koo piavokoꞌnung. ");
INSERT INTO nas_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Eeꞌnoko damaꞌke taung narung meuꞌpuuꞌ Erodiasie Jooni dupisiꞌkoong. Enang tee Eerotiꞌ pontoꞌaruꞌnaꞌmung doong makotuuꞌ. Eeꞌnoko nantoong pankainanka paroro nkoevuruꞌ: ovoꞌmaꞌkoo kuunge mintoomparikoꞌning, piatooronuka˜ biikaning boreꞌnuka eeꞌnoko ovontung Kaaleliꞌnameng-nupoong. ");
INSERT INTO nas_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Eeꞌnoko Erodiasi baurang pava-koo kuung tumparara mairuꞌaruꞌ Eerotiꞌ damisimainku ninka nariꞌ dotu-antavurima. ");
INSERT INTO nas_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eeꞌnoko Eerotiꞌke mamairoarara, mariaritaaꞌ maraka-antavuma aaꞌpuuꞌ, “Kapooꞌ eentameko makosi aromaꞌnaang. Ookara kapooꞌ tareamaing-koo meuꞌ pisiꞌderompainge piaroko.” ");
INSERT INTO nas_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Teketa neraiꞌnaꞌ okoraꞌ siarara bauko tanaꞌuma aaꞌpuuꞌ, “Aming arekeeꞌ oroꞌ ninge eentavamaꞌnaang?” Eeꞌnoko baukoi aaꞌpuuꞌ, “Jooni Minkinara bakaang boreꞌ eentaveaing.” ");
INSERT INTO nas_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eeꞌnoko teni neraiꞌnaꞌ namuꞌke kuaꞌpari daurarong-anko beuꞌ eeꞌnoko aaꞌpuuꞌ, “Jooni Minkinara bakaang boreꞌ namuꞌke ameaing daara-koo siꞌmemura.” ");
INSERT INTO nas_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Eeꞌnoko nauvuioꞌ daurarong aaꞌnaꞌ orarunsiaruꞌ, eeꞌnoko tutung damisimainku-koo dutakanooꞌke teni-koo marakavaruꞌnung deemparako paapaaꞌaruꞌ bakaang kara totoꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Eeꞌnoko dauraronge bakaning piatooronuka-koo narung botovuuꞌ Jooni bakaang boreꞌ tavoꞌuaꞌnaang. Eeꞌnoko bera pava kiimatanavaꞌkoo kuunga kuru takoꞌpevuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Eeꞌnoko boreꞌ diisi-koo kuung doompura tavoꞌevuuꞌ teni neraiꞌnaꞌ. Eeꞌnoko tenie napoꞌ bauko-anko tavoꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Eeꞌnoko Jooni bakaning barevare-nupoonge taaravauꞌ Jooni tavauꞌnaꞌ, eeꞌnoko porora Jooni-koong mono nkavaara kuvi dakoꞌdoma dakoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Eeꞌnoko Jiisuuꞌke botovuruꞌning napoꞌ toroarira tasiꞌantavauꞌ ookara kapooꞌ osinanka-koo nkoauꞌning eeꞌnoko nauaaruꞌning. ");
INSERT INTO nas_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nantoong karikaꞌ poroi otoroko bakaning ninka taamanaapeuꞌnung batei otoaruuꞌ, eeꞌnoko aaꞌpuruꞌ teing, “Enang tokoi niiꞌka merira oꞌnoriai uaarorima.” ");
INSERT INTO nas_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eeꞌnoko teketa bakaasie tenkenauꞌ bakuꞌariri otoroainooꞌaape. ");
INSERT INTO nas_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Eeꞌnoko nantoong karikaꞌke ooaari otoroko tenkenauꞌ eeꞌnoko tasiꞌpaarira osi ookara-ita nantoonanka kuaꞌpariruꞌ, eeꞌnoko Jiisuuꞌ dovang-koo uroꞌke tavoꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Eeꞌnoko Jiisuuꞌ bakaasi-eta siarama nantoong karikaꞌ oovuruꞌ eeꞌnoko bakaang domang aaꞌnaꞌ piaavouꞌ teing-koo, sipisipiꞌ tanatanungropanuka-pinaꞌ oroꞌpariko. Eeꞌnoko tenang Jiisuuꞌke kara amutemuriiꞌ nau tutumpuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Eeꞌnoko kamunooꞌuioꞌ teing barevare-nupoong bakaning Jiisuuꞌanko porora aaꞌpauꞌ, “Aung muung-aapevuing. Niiꞌ meeꞌboraꞌ sirakamaaꞌkoo oꞌnoring. ");
INSERT INTO nas_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nantoong botoveriko osinanka anketa dueꞌ otoroining-koo berora taamang mooꞌsiaavai.” ");
INSERT INTO nas_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Eeꞌnoko Jiisuuꞌke bariꞌurima aaꞌpuruꞌ, “Diiꞌke kapooꞌ averereriko naiaavaing.” Eeꞌnoko teinge napoꞌ bariꞌaama aaꞌpauꞌ, “Teka arekeeꞌ? Aiꞌ kenaanka kivora nopaꞌkoo makosininge mooꞌampira bauꞌarampiiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eeꞌnoko Jiisuuꞌke napoꞌ tanaꞌurima aaꞌpuruꞌ, “Teka arekeeꞌning bereteꞌ otoꞌderuring? Berira ooveriai.” Eeꞌnoko ooaara Jiisuuꞌ aaꞌpauꞌ, “Tee aaꞌ paꞌnokoꞌ masikeng bereteꞌ otong, eeꞌnoko taviꞌning keura.” ");
INSERT INTO nas_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Eeꞌnoko Jiisuuꞌke nantoong navitunaꞌ karaasiꞌkoo baꞌnang-koo botovuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Eeꞌnoko nauvurioꞌ narung daakuꞌnaꞌ eeꞌnoko nariong naruaapenaꞌ baꞌnampariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eeꞌnoko Jiisuuꞌke teing paꞌnokoꞌ bereteꞌ eeꞌnoko taviꞌning keura nkavura tee paning-aape ankamparara biraankevuuꞌ, eeꞌnoko bereteꞌnanka pisiꞌuma bakaning barevare-nupoong avuruꞌ teinge nantoong-koo tankaampaavaꞌnaang. Eeꞌnoko napoꞌ teing taviꞌning keura tankaampuruꞌ ookara-koo. ");
INSERT INTO nas_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Eeꞌnoko ookara taamanaara poovorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Eeꞌnoko Jiisuuꞌ bakaninge bereteꞌ dovang eeꞌnoko taviꞌ oparavaruuꞌning naroꞌaara pekuꞌ kivora-ita kevekuꞌka-koo makosi maantoꞌantavauꞌ ");
INSERT INTO nas_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eeꞌnoko nantoong taamang naiauꞌning-koo donkaang naing deerunooꞌ paꞌnokoꞌ kokoreiꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Eeꞌnoko namuꞌke Jiisuuꞌke bakaning barevare-nupoong bakaasi-nareng-koo aaꞌe-antavurira ureaitaaꞌ nuaruꞌkoo Besaida-nameng-koo beꞌkoo botovuruꞌ, nantoong karinga tenkeng-koo botovuriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eeꞌnoko Jiisuuꞌke nantoong siꞌnooraꞌurira baka mii-koo koinuuꞌ teke kunsiaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Eeꞌnoko muumpuioꞌ bakaasi-nareng nuaruꞌkoo meuꞌ basiaruꞌ Jiisuuꞌ teke kansiꞌkoo baka otoko. ");
INSERT INTO nas_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Eeꞌnoko Jiisuuꞌke otouꞌnooꞌketa oovuruꞌ poreꞌoroko, pionge uroꞌkanooꞌketa damaꞌdu-aape biiꞌurima tavuriko. Eeꞌnoko taneꞌ dereꞌuaruko Jiisuuꞌ nanura pouꞌ teing-aape nuaruꞌkoo daue. ");
INSERT INTO nas_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Eeꞌnoko ntong-koo daue nanuma dapiꞌ divuꞌuriko teinge ookarai maꞌnaang pinaꞌ ooaara bokiauꞌ, avoroꞌke tavurioꞌ; ");
INSERT INTO nas_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Teka Jiisuuꞌke namuꞌke karavurima aaꞌpuruꞌ, “Aing ee, domang kuaaꞌdoriai aroreriaꞌ. Tee ning eeꞌ nanamang.” ");
INSERT INTO nas_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Eeꞌnoko tenang bakaasi-koo aaꞌearioꞌ doving taarorovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Eeꞌnoko bakei aaꞌnaꞌ sinkaꞌorouꞌ, nantoong domang tupuꞌpaaꞌnuka deemparira. Tampaꞌ tasiꞌpaavaruuꞌ kapooꞌ bereteꞌkoo nkoaruꞌnaꞌ kuunooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Eeꞌnoko nuaruꞌ pakoꞌaitaaꞌ Kenaseretiꞌnameng-koo tavoꞌarira biikaang bakaasi teka biꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Eeꞌnoko tenang bakaasi-eta siariko Jiisuuꞌ namuꞌke tasiꞌpauꞌ nantoonge. ");
INSERT INTO nas_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Eeꞌnoko tevaro-koo osinanka ookutuning dooreveera siipa-poꞌnupoong batanang-koo nkavaari porouꞌ Jiisuuꞌ otouꞌnooꞌ taaravaara. ");
INSERT INTO nas_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Eeꞌnoko ookara osinanka Jiisuuꞌ nanukoꞌnairu-koo-osi pankeng, osi okiꞌnarekaꞌ, poraꞌnairu-koo-nantoong tee-anko siipa-poꞌnupoong tavoꞌaarikoꞌ. Eeꞌnoko eentavariko Jiisuuꞌkoo tamung bakaang mononopaꞌkoo kainuꞌ kong-koo tauraꞌpuriiꞌnaang. Eeꞌnoko ookara mononopaꞌkoo komparikoꞌning taarevorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Teing Boto Keperuuꞌnavitu eeꞌnoko boto naunuka Jerusalemaꞌketa Jiisuuꞌanko porouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Porora ooaaruꞌ Jiisuuꞌ bakaning barevare-nupoong-koo nariong tankaꞌ kuꞌmiꞌoroi taamanaako. Aꞌnooꞌ tutunaꞌ tankaꞌ duuꞌpari meekaꞌpariaꞌ Boto Keperuuꞌnavitue nantoong nau-antavaarikoꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aiꞌ Boto Keperuuꞌnavitu ninka ookara Juꞌnupoonge biikakatauro biikaang toomo tampaꞌ siompaamaung. Tamung taamanaavaung tutunaꞌ tankaꞌ duuꞌpariaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Eeꞌnoko baavenairu-eta poroma deekoꞌ taamanaavarupeuꞌ tutung ntonge meekaꞌpariaꞌ eeꞌnoko napoꞌ amutemuriiꞌ toomo siompaakooꞌ biikakatauroi bampaaruꞌnaꞌ aing eeꞌ otoꞌ ntonge meekaꞌantanaꞌ: kaapu, kokoto, utau, eeꞌnoko batanang. ");
INSERT INTO nas_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eeꞌnoko Jiisuuꞌ tanaꞌaama aaꞌpauꞌ teinge Boto Keperuuꞌnavitue eeꞌnoko boto naunukai, “Aming-koo dakaning barevare-nupoonge niikakatauroi bamaaruꞌnaꞌ boto siompaavaung, aaꞌnomaung, bireng tovang duuꞌpariaꞌ taamang naiaamatoi?” ");
INSERT INTO nas_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Tee nakaronung Aisaiaꞌ koontoꞌ masikaꞌpari tarampeearuꞌnung˜ diiꞌ ampirinunuka minkururima, Daari Meekung-koo eeꞌ daariari otoinaꞌ, ‘Teinge ainge nantoonge biikaang beꞌduuꞌke narunge pankaing-antamaamaung, teka biikaang domang ning-koo isipoꞌ otoroi. ");
INSERT INTO nas_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tamung ning dootuuꞌmaamaing, aiꞌ teing boto nkaang miring-koo nau-antavaarimaing teing tamung nantoong-etaning.’” ");
INSERT INTO nas_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Teeꞌ eeꞌnaꞌ diiꞌke Kumponing bakaang boto siperi tamung nantoong-etaing sintokosintoi-koong minkunaa pinkaꞌerikooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Eeꞌnoko napoꞌ aaꞌpuruꞌ, “Diiꞌ aaꞌnaꞌ norukasiꞌnuka Kumponing bakaang boto nimpaꞌerima tee diikaang minkunaa sintokosintoi-koong toomo deto kong-koo. ");
INSERT INTO nas_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Aiꞌ Moosesie napoꞌ boto eeꞌ sipuuꞌ, ‘Diumaraang deto noruꞌereri pakuereriainge’. Eeꞌnoko ‘Naning baumararing orakaꞌ minkuvureaing bakei dupisiꞌnumpoꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Teka diiꞌke aaꞌperimaung, ‘Naninge baumararing kapooꞌkoo apukaꞌpareko, beuringe tering paku-koo kupiꞌora deekoꞌ aaꞌpupeuꞌ, “A, nkaning kapooꞌ arompepeuꞌning teing temuꞌ Kumponing bakaning bareantuꞌning.” Eeꞌnoko teeꞌpura tering baumararing pakuvurearupeuꞌ.’ Eeꞌnoko tering biromparesioꞌ beuring domang bereꞌkoo piavoko diiꞌke tauraꞌperiaunge diikaang toomoi daiꞌerima. ");
INSERT INTO nas_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Teeꞌ nkorarima diiꞌke tee Kumponing bakaang kara daang-antaverimaung tee diikaang sintokosintoi-koong minkunaa barereerimaung siomperima, eeꞌnoko amutemuriiꞌ aarumo nariꞌ nkoverikooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Eeꞌnoko Jiisuuꞌke nantoong bokuvurira aaꞌpuruꞌ, “Ning iroꞌ taaramerira diiꞌke tampaꞌ tasiꞌperiai. ");
INSERT INTO nas_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kapooꞌ naninge naivuko kumiꞌantavupeuꞌnung otoaꞌ. Eeꞌnoko kapooꞌ domaang-eta tavoꞌkupeuꞌnunge deekoꞌ naning kuꞌmiꞌantavupeuꞌ ");
INSERT INTO nas_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Diiꞌ nantoong punkang-poꞌnupoong deekoꞌ enang taaraveriai!” ");
INSERT INTO nas_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eeꞌnoko nantoong teka sipurira pava-koo koinuuꞌ, eeꞌnoko bakaning barevare-nupoonge teka mirumiruꞌkoong kuunooꞌ tanaꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Diiꞌ ee napoꞌ teing-pinaꞌ noruꞌdopanuka? Arekeeꞌ, tasiꞌperiaꞌ tee kapooꞌ damaꞌdunung naninge dunkumpuko tanuaang kuꞌmiꞌantavuarupeuꞌ? ");
INSERT INTO nas_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Aung tee domang-koo kuung beaꞌ, pakosiiꞌkoo bemaung, eeꞌnoko teketa mono-ita napoꞌ siarakooꞌ.” Teeꞌpurima ookara taamang tauraꞌnisi tampuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Teketa aaꞌpuruꞌ, “Teeo kapooꞌ tee kuung-eta pomaunge deekoꞌ naning kuꞌmiꞌantavumaung. ");
INSERT INTO nas_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Eeꞌ, naning bakaang domaang-eta aing eeꞌ oroꞌ pomaung: norunoruꞌ orara eeꞌnoko auning, bakiaaꞌ, naning dupisiꞌ, nampeesi orari, karakaraaꞌ, amutemuriiꞌ aarumo orara, tositosi, maimaiaꞌnko, mamairo, orakaꞌ minku, baka biiving, eeꞌnoko matau bekoiꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Teing eeꞌning kapooꞌ oreng naing kuꞌmiꞌanta.” ");
INSERT INTO nas_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Eeꞌnoko Juꞌ biikanameng-eta tenkenuraiꞌnange Jiisuuꞌ bakaning ninka osi Taiaꞌ eeꞌnoko Saidoniꞌnameng-koo berouꞌ. Eeꞌnoko teꞌ bera pava navaꞌkoo kuung tumparuꞌ nantoonge noruꞌkoo piavoarura. Teka baruꞌ bakuꞌaravaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Teke otoko nani manikuma baurang maꞌnaang orara-poꞌnanie Jiisuuꞌ poioꞌ taaravuuꞌ, eeꞌnoko pora tee-anko kauꞌkanooꞌ duaꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Teninooꞌ Juꞌdeeaing-koonani, Ponisia-nameensiꞌke pontoꞌaruꞌnani, Siiria-nameng-koo. Aaꞌnaꞌ baitoaritaaꞌ Jiisuuꞌ keviꞌuuꞌnani baurang-eta maꞌnaang bataꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Eeꞌnoko Jiisuuꞌke teni aaꞌpuuꞌ, “A, makotuaꞌ! Toireꞌ deekoꞌ ookara piavoroainaꞌ bauꞌnumpoꞌ, eeꞌnoko tee taamang biikaang mosiꞌnanka-anko duaꞌkoo tampaꞌ deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Eeꞌnoko tenie Jiisuuꞌ bariꞌuma aaꞌpuuꞌ, “Eeꞌ, Ovoring, masikaꞌ, nka tee toireꞌke duaꞌantavaako mosiꞌnankai mukunanka naiaamaung tarepa-koo boonga.” ");
INSERT INTO nas_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Eeꞌnoko Jiisuuꞌke teni aaꞌpuuꞌ, “Makosi, osi tororaravaing. Tampaꞌ bariꞌmeing. Maꞌnaang tenkenuing daurang-eta.” ");
INSERT INTO nas_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eeꞌnoko teni toroarara baurang batanang-koo bempari otoko oovuuꞌ maꞌnaang tenkenuioꞌ teni-eta. ");
INSERT INTO nas_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jiisuuꞌ Taiaꞌnameng-eta tenkenura osi kivorai nanuitaaꞌ Saidoniꞌnamenge tankinui Kaaleliꞌnaruꞌkoo basiaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eeꞌnoko narionge naning kipau eeꞌnoko tampaꞌ karoarukoꞌnung tavoꞌauꞌ. Eeꞌnoko Jiisuuꞌ tanaꞌauꞌ bireng tee-koo patuꞌuko taarevoaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Eeꞌnoko Jiisuuꞌke tee naning bokuvura karikaꞌketa taapoꞌ beꞌantavuuꞌ beeꞌka otoꞌkoo. Eeꞌnoko birenge punkang-koo kuung kompuuꞌ, eeꞌnoko napoꞌ tutupaaꞌarara meneng-koo kompuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Eeꞌnoko paning-aape ankamparara kooreerevoitaaꞌ aaꞌpuuꞌ, “Epata.” Aung kara kuunooꞌ: “Daateꞌdaravai.” ");
INSERT INTO nas_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eeꞌnoko bakaang punkang tenang daateꞌaruꞌ eeꞌnoko meneng simpiriꞌarara tampaꞌ karouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Eeꞌnoko Jiisuuꞌke potevuruꞌ naning nau-koo. Eeꞌnoko nau-koo doong kante potevuriko teinge napoꞌ aaꞌnaꞌ siraꞌpaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eeꞌnoko nantoonge taaravaama aaꞌnaꞌ taꞌninaakoꞌ aaꞌpaama, “Aung bakei ookara kapooꞌke meeꞌduꞌpinarai, aaꞌnomaung: Kipaunuka taarakiaakooꞌ, eeꞌnoko amakonuka kareaakooꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pankaroompuaruko nantoong karikaꞌ porora naroꞌariruꞌ. Eeꞌnoko taamang naiaapeuꞌning otoaruioꞌ Jiisuuꞌke bakaning barevare-nupoong tee-anko bokuvurira aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nkaang domang aaꞌnaꞌ piaamoing aing-koo nantoong-koo. Aing teing niꞌninka beenang doong oꞌnorining eeꞌnoko kapooꞌ nai-koong otoꞌevoroaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Eeꞌnoko ninge peeravoroi otoroko osi-aape botoaranko dei taunga peerai tavuripeuꞌ, aiꞌ nariong aing-koo isipoꞌnupoong.” ");
INSERT INTO nas_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eeꞌnoko bakaning barevare-nupoonge Jiisuuꞌ tanaꞌaama aaꞌpauꞌ, “Teka anke meeꞌboraꞌ sirakamaaꞌkoo taamang naninge areꞌka daaꞌura aing bauꞌuriaꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Eeꞌnoko Jiisuuꞌke niaꞌurima aaꞌpuruꞌ, “Teka arekeeꞌning bereteꞌ otoꞌderuring?” Eeꞌnoko aaꞌpauꞌ, “˜Keura-taa.” ");
INSERT INTO nas_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eeꞌnoko Jiisuuꞌke botovuruꞌ teing nantoong karinga kansiꞌkoo baꞌnampariaꞌnaang. Eeꞌnoko ˜keura-taa bereteꞌ nkavura tampaꞌ tampura pisiꞌuma bakaning barevare-nupoong avuriko teinge nantoong miatara avaarikoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eeꞌnoko napoꞌ niiꞌning taviꞌning okiꞌnarekaꞌ otoꞌevuruꞌning-koo biraankevura bakaning botovuruꞌ teing napoꞌ tankaampaariaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eeꞌnoko ookara taamanaara poovorouꞌ. Eeꞌnoko Jiisuuꞌ bakaning barevare-nupoonge pekuꞌ ˜kevekuꞌka-taa kakitaꞌke maantoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Naroꞌka donkaang deerunooꞌ karenaumo kokoreiꞌ pinaꞌ teke otorouꞌ. Eeꞌnoko Jiisuuꞌke teing nantoong tenkeng-koo botovuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Eeꞌnoko namuꞌke tee bakaasi-nareng-koo bakaning barevare-nupoong ninka aaꞌeariruꞌ, eeꞌnoko Dalamanuta-nameng-aape berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Niiꞌning Boto Keperuuꞌnavitu Jiisuuꞌanko porouꞌ bakaang kara paara-koo. Tutumpaama teinge tanaꞌauꞌ taaꞌniꞌanta nkoevuriiꞌnaang Kumponinge botovuuꞌnaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jiisuuꞌke eeꞌmaraanura aaꞌpuruꞌ, “Aming-koo diiꞌ avarang taaꞌniꞌanta-koo tanaꞌkirimang? Masikung naurampimang, Kumponinge diiꞌ enanavarang taaꞌniꞌanta nau-koo kasivuaꞌ otong.” ");
INSERT INTO nas_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Teeꞌpurira sipuruꞌ teka, eeꞌnoko bakaasi-koo aaꞌearara nuaruꞌ pakoꞌ tutumpuuꞌ amenkaꞌkoo beeꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jiisuuꞌ bakaning barevare-nupoong ampaꞌorouꞌ taamang nka-koo. Eeꞌnoko nau masiku bereteꞌ otoꞌevuruꞌ teke bakaasi-koo. ");
INSERT INTO nas_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Eeꞌnoko Jiisuuꞌke siingoravurima aaꞌpuruꞌ, “Bakei tarerariai tee-koo iisi Boto Keperuuꞌnavitue eeꞌnoko Eerotiꞌnupoonge biikaang taamang ninka bereꞌaamaung-koo.” ");
INSERT INTO nas_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eeꞌnoko teeꞌpuioꞌ tasiꞌpaavarura kareaama aaꞌpeekoꞌ, “Aunge pa niiꞌ taamang otoꞌmemuriaruioꞌ teeꞌ minkuvuing.” ");
INSERT INTO nas_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Eeꞌnoko Jiisuuꞌke minkuaako noruꞌura aaꞌpuruꞌ, “Aming-koo diiꞌka minkurarimang taamang nkaveriarura? Koontoꞌ ee mmeꞌ diiꞌke tasiꞌmeriaꞌ ning? Aiꞌ diikaang domang kapanukai? ");
INSERT INTO nas_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Duta otori, teka ee ookiriaꞌ? Punkang otori, teka ee taaraveriaꞌ? Aming-koo noruꞌeriaꞌ? ");
INSERT INTO nas_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tenang bereteꞌ paꞌnokoꞌnuri ninge nantoong paꞌnokoꞌ kokoreiꞌ bauꞌaransioꞌ arekeeꞌning pekuꞌ kakitaꞌke oosierira maantoꞌeruꞌ?” Eeꞌnoko aaꞌpauꞌ, “Kivora-ita kevekuꞌka.” ");
INSERT INTO nas_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jiisuuꞌke napoꞌ aaꞌpuruꞌ, “Eeꞌnoko tenang ˜keura-taa bereteꞌ nantoong karenaumo kokoreiꞌke naiaioꞌ arekeeꞌning pekuꞌ kakitaꞌke maantoꞌerieeng?” Eeꞌnoko aaꞌpauꞌ, “˜Kevekuꞌka-taa.” ");
INSERT INTO nas_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eeꞌnoko aaꞌpuruꞌ, “Teka ee diiꞌke mmeꞌ tasiꞌperiaꞌ?” ");
INSERT INTO nas_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jiisuuꞌ bakaning ninka Besaida duparirioꞌ narionge naning duta kaputuꞌ tavoꞌauꞌ tee-anko birenge kompuaꞌnaang eentavarima. ");
INSERT INTO nas_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eeꞌnoko Jiisuuꞌke naning kaputuꞌ bireng-koo kompura osi-eta damaꞌdu tenkeng-antavuuꞌ. Eeꞌnoko duta-koo tutupaaꞌura bakaang bireng tee-koo panteꞌuuꞌ, eeꞌnoko aaꞌpuuꞌ, “Kapooꞌ ee oovemaang?” ");
INSERT INTO nas_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eeꞌnoko duta bantora aaꞌpuuꞌ, “Nantoong aaꞌ koiꞌpinaꞌ nanaako ooaramang.” ");
INSERT INTO nas_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Eeꞌnoko Jiisuuꞌke napoꞌ bireng patuꞌuuꞌ duta-koo, eeꞌnoko tenang duta bantora naapu narung ookuma tamparuꞌkuuꞌ. Ookara kapooꞌ sirakaꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Eeꞌnoko Jiisuuꞌke koontoꞌ bakanooꞌaape botovuma aaꞌpuuꞌ, “Amono-nupoong-koo bera naueriaukaꞌ!” ");
INSERT INTO nas_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Niiꞌnaꞌmung Jiisuuꞌ bakaning barevare-nupoong ninka Sisariaꞌ Pilipai navuntuꞌaape taunge nanaama bakaning barevare-nupoong tanaꞌurima aaꞌpuruꞌ, “Nantoonge ning baa tammaamaung?” ");
INSERT INTO nas_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eeꞌnoko teinge aaꞌpauꞌ, “Niiꞌninge Jooni Minkinara tantaamaung. Eeꞌnoko narionge Eliasi poaing-koong tantaamaunge. Eeꞌnoko niiꞌninge urikupoong nakaro-nupoong-koo narung, booꞌketa daaꞌaruꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eeꞌnoko napoꞌ Jiisuuꞌke teing tanaꞌurima aaꞌpuruꞌ, “Eeꞌnoko diiꞌke napoꞌ ning baa tammerimaung?” Eeꞌnoko Piitai bariꞌuma aaꞌpuuꞌ, “Daꞌ aaꞌ tee Kumponinge teroita Pakoꞌpariꞌniiꞌ nantoong domamperira tareveriainooꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eeꞌnoko Jiisuuꞌke potevurima aaꞌpuruꞌ, “Naning-koo siraꞌmeriaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Eeꞌnoko Jiisuuꞌke bakaning nau tutumpuruꞌ booꞌparavainaꞌ, aaꞌpurima, “ning Tee Naning-naumpoꞌ Paning-etaing teing amutemuriiꞌ arikananka toraꞌpampaing, eeꞌnoko aing aaꞌninge tompimaavaing: pankenukai, piristiꞌkoong ovontunukai eeꞌnoko boto naunukai, eeꞌnoko tee dupisiꞌmaavaing. Teketa beenang doong tankinuko napoꞌ domamarara daaꞌmaravaing.” ");
INSERT INTO nas_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sirakaꞌpui tampaꞌ nauvurioꞌ Piitai taapoꞌ beꞌantavura potevuuꞌ temuriiꞌ kara minkuvuarooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Eeꞌnoko Jiisuuꞌ bakaning barevare-nupoong-aape bereꞌarama Piita turampuma aaꞌpuuꞌ, “Tokoi beai daꞌ Sietaniꞌ, ning-ankoita. Dake tee Kumponing bakaang noruꞌ noruꞌeaꞌ, nantoong biikaang noruꞌ narung noruꞌei otong.” ");
INSERT INTO nas_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eeꞌnoko Jiisuuꞌke nantoong miatara bakaning barevare-nupoong ninka naroꞌ bokuvurira aaꞌpuruꞌ, “Naning ning siomui pooꞌnaang piavora deekoꞌ, baka bakaang pia iroꞌ doonko tompimparavaing eeꞌnoko bakaang aaꞌbarataꞌ poruꞌui ning siomumaatoaing. ");
INSERT INTO nas_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Eeꞌkoo, baa tee naning bakaang domaang ning-koo orokovuma baka tare-koo piavoaing tee paaꞌaravaing, teka baa tee naning ning-koo eeꞌnoko nkaang doorenang tampara-koo bakaang domaang arooꞌari duaꞌuaing tee domamparavaing. ");
INSERT INTO nas_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Naninge kapooꞌ ookara kansiꞌkooning barampui okovura bakaang domaang daroveꞌuko teinge arekeeꞌ pakuaapeuꞌ? ");
INSERT INTO nas_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Eeꞌnoko naning aming avupeuꞌ tee bakaang domaang paaꞌaruꞌnung napoꞌ mooꞌkoo? ");
INSERT INTO nas_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aing avarang oreng otorong nampeesi orarinuka, eeꞌnoko naning teing-koo meuꞌke otoi nkaang miring siraꞌkoo eeꞌnoko nkaang kara-koo maiaꞌomaung damaꞌke ning Tee Naning-naumpoꞌ Paning-etaing tee-koo maiaꞌmoaing mora teing ninka koosinung˜ meekupoong eeꞌnoko Mmaꞌ bakaang meenasi ninka.” ");
INSERT INTO nas_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jiisuuꞌke napoꞌ karoma aaꞌpuruꞌ, “Teka ninge masikung naurampimang, Diiꞌkoo nariong anke otorining dooriaꞌ ooverioꞌ Kumponing bakaang Muuꞌ basiaravaing tee ninka purintoꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Eeꞌnoko ˜naꞌmung-taa doong tankinuioꞌ Jiisuuꞌke Piita dovang Jeemisi eeꞌnoko Jooni bokuvuritaaꞌ biiꞌka iuꞌ isikara-koo deto koinauꞌ, eeꞌnoko teke otoroi ooaioꞌ Jiisuuꞌnung mono niiꞌnaꞌ paariaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bakaang mononopaꞌ aaꞌnaꞌ kakaravora siisiouꞌ. Naning otoaꞌ duuꞌpura teeꞌ oroꞌantavupeuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eeꞌnoko Jiisuuꞌ bakaninge ooauꞌ Eliasi eeꞌnoko Moosesi nariꞌ kareaako Jiisuuꞌ ninka. ");
INSERT INTO nas_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Eeꞌnoko Piitai karoma Jiisuuꞌ aaꞌpuuꞌ, “Nau-anta Pankaing ee, bakei tampaꞌ niiꞌ anke oꞌnorimaang. Aiaꞌ, niiꞌke beevaari bare kaniampiai: navaꞌ daꞌ dakanavaꞌ, navaꞌ Moosesi bakanavaꞌ, eeꞌnoko navaꞌ Eliasi bakanavaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aing teing avoreaara minkuvupeuꞌning otoaruko aung minkuvuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eeꞌnoko teka kamoꞌke dakaꞌpuruꞌ, eeꞌnoko teketa auronge karoma aaꞌpuuꞌ, “Aung tee nnuring ninge piaavamaung. Taaraveriaing tee.” ");
INSERT INTO nas_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eeꞌnoko daꞌdeng avitoitoi ookaama naning ooaavaꞌ, Jiisuuꞌ narung teing ninka otoko ooauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eeꞌnoko iuꞌketa depeto siarima Jiisuuꞌke teing potevuruꞌ kapooꞌ ooauꞌning nantoong nauaariarooꞌnaang bera Tee Naning-naumpoꞌ Paning-etaing booainooꞌketa daaꞌaravainooꞌ basi. ");
INSERT INTO nas_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eeꞌnoko teinge Jiisuuꞌ bakaang kara meumpauꞌ, eeꞌnoko biiꞌka kareaama aaꞌpaakoꞌ, “Aunge aming kapooꞌ booꞌketa napoꞌ daaꞌaravaing tampumang?” ");
INSERT INTO nas_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eeꞌnoko Jiisuuꞌ tanaꞌaama aaꞌpauꞌ, “Aming-koo boto naunukai aaꞌpaamaung Eliasi damaꞌ tee tee-koo Kumponinge Pakoꞌpariꞌniiꞌkoo uroꞌke poaing?” ");
INSERT INTO nas_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Eeꞌnoko Jiisuuꞌke bariꞌurima aaꞌpuruꞌ, “Masikung, Daari Meekunge aaꞌpui otong, ‘Eliasi tutung poaing ookara kapooꞌ maamu-antavuaꞌnaang.’ Eeꞌnoko Daari Meekunge napoꞌ ning-koo aaꞌpui otong, ‘Tee Naning-naumpoꞌ Paning-etaing aaꞌnaꞌ sisikeera kompuaing pooreꞌaako.’ ");
INSERT INTO nas_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Teka iroꞌ ninge naurampiai. Eliasi tee masikaꞌ tutunaꞌ pouꞌnung, eeꞌnoko nantoonge tee-koo orakaꞌ piavorouꞌnaꞌ nariꞌ nkoauꞌ tee, Daari Meekunge minkuvui otoinaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eeꞌnoko Jiisuuꞌ ninka iuꞌketa siarima niiꞌning barevare-nupoong meuꞌpaaruꞌ, eeꞌnoko napoꞌ nantoong karikaꞌ kuneꞌaaruꞌ, nariong boto naunuka Jiisuuꞌ bakaning barevare-nupoong ninka mantekaveeko. ");
INSERT INTO nas_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Eeꞌnoko namuꞌke Jiisuuꞌ ooaara bakei ookara taꞌnimparira kuaꞌpariruꞌ tee-anko onkeonkeꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Eeꞌnoko Jiisuuꞌke bakaning tanaꞌurima aaꞌpuuꞌ, “Diiꞌ aming-koo mantekareerimang?” ");
INSERT INTO nas_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Eeꞌnoko naninge karikaꞌkoo meuꞌketa bariꞌuma aaꞌpuuꞌ, “Nau-anta ee, ninge nnuring daꞌanko tavoꞌama moing maꞌnaang orara otoi kara kereng-antavuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Teie maꞌnaange tavuma kansiꞌkoo kosiꞌuko kaꞌbuairavarama kakirinkuarakooꞌ, eeꞌnoko bakaang mono taꞌnaaꞌokooꞌ. Ninge dakaning barevare-nupoong tanaꞌaransioꞌ tee maꞌnaang bataꞌkoo makosiaavaruing.” ");
INSERT INTO nas_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Eeꞌnoko tenang Jiisuuꞌke aaꞌpuruꞌ, “Nko diiꞌ masikaꞌanta otoriainge, koontariaing, areꞌ basinaroonge diiꞌ ninka nariꞌ oꞌnorimaatoainge dooroontampiri? Poꞌantaveai tee okiꞌnara ning-anko.” ");
INSERT INTO nas_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eeꞌnoko tenang poꞌantavauꞌ Jiisuuꞌanko. Eeꞌnoko maꞌnaange Jiisuuꞌ oovura namuꞌke tee nemaka kanuꞌantavuioꞌ dankurankuꞌarama kansiꞌkoo duaꞌarara korimparuꞌ kaꞌbuaaꞌke sisiꞌarama. ");
INSERT INTO nas_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Eeꞌnoko Jiisuuꞌke bauma tanaꞌuma aaꞌpuuꞌ, “Aung arekeeꞌning doonge teeꞌ nkoaramaung?” Eeꞌnoko baumai bariꞌuma aaꞌpuuꞌ, “Okiꞌnaꞌnooꞌketa. ");
INSERT INTO nas_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mmauꞌ doonge ntong tovang-koo ntaꞌ duaꞌantavukooꞌ dupisiꞌkoo keviꞌuma. Daꞌ makosi deekoꞌ piaamerira pakumeriai.” ");
INSERT INTO nas_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Arekeeꞌkoo ning makosi deekoꞌ tammemang, aiꞌ teie daꞌ makosi deekoꞌ. Ookara kapooꞌ arikaꞌparavaꞌ naning-koo Kumponing masikaꞌantavumaung-koo.” ");
INSERT INTO nas_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eeꞌnoko tootoꞌke bauma namuꞌke bokuma aaꞌpuuꞌ, “Masikaꞌantavansing. Makotumparuko deekoꞌ pakumeaing.” ");
INSERT INTO nas_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eeꞌnoko Jiisuuꞌke nantoong karikaꞌ porora naroꞌariko oovurira tee maꞌnaang orara akaꞌpuma aaꞌpuuꞌ, “Daꞌ kipau eeꞌnoko amako maꞌnaang botoramaang naning-eta bakorarara tenkeng-koo eeꞌnoko napoꞌ tee-koo kuung beaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Eeꞌnoko tenang maꞌnaang uiarama naning kanuꞌantavura sipuuꞌ. Eeꞌnoko nemaka bakei davoru-pinaꞌ oroꞌparioꞌ nantoonge aaꞌpauꞌ, “Aung aaꞌ booꞌparing.” ");
INSERT INTO nas_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eeꞌnoko Jiisuuꞌke aung naning nemaka bireng-koo kompura deto donkong-antavuioꞌ donkonuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Eeꞌnoko Jiisuuꞌ teketa pava-koo tumparioꞌ bakaninge barevare-nupoong makenge tanaꞌaama aaꞌpauꞌ, “Arekeeꞌkoo niiꞌke maꞌnaang bataꞌkoo makotumpiaꞌ?” ");
INSERT INTO nas_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eeꞌnoko Jiisuuꞌke bariꞌurima aaꞌpuruꞌ, “Unkumuari kunsi narunge deekoꞌ temuriiꞌ bataꞌkoo makosi.” ");
INSERT INTO nas_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Eeꞌnoko teketa tenkenaara Kaaleliꞌnamenge berouꞌ makemparitaaꞌ, biiꞌka bireꞌariri bakaning barevare-nupoong nau-anta-koo. ");
INSERT INTO nas_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Eeꞌnoko aaꞌpuruꞌ, “Ning Tee Naning-naumpoꞌ Paning-etaing tee nkaning-koo navumainuka-koo narunge tooka kompui simuuꞌnaang nantoong oreng biikaang bireng-koo. Teinge dupisiꞌmaavaing, teka beenang doong tankinuko napoꞌ domamarara daaꞌmaravaing.” ");
INSERT INTO nas_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eeꞌnoko teinge nauvurioꞌ tasiꞌpaavaꞌ, eeꞌnoko napoꞌ amaiaaꞌorouꞌ tanaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Eeꞌnoko Kapaneumeꞌ tavoꞌarira Jiisuuꞌke bakaning tanaꞌurima aaꞌpuruꞌ, “Diiꞌ taunge aming mantekavering?” ");
INSERT INTO nas_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Eeꞌnoko kareaavaꞌ, aiꞌ taunge nanaama mantekaveema aaꞌpauꞌ, “Niiꞌkoo baa pankaing?” ");
INSERT INTO nas_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eeꞌnoko Jiisuuꞌ baꞌnanuraiꞌnange bakaning nanaiꞌketa kenaankara bokuvurira aaꞌpuruꞌ, “Naning paninung muuꞌkoo uroꞌnara deemparaaꞌnaang piavora deekoꞌ, baka enang ookara-koo damaꞌdu siparara biikaang pakupakunung otoai.” ");
INSERT INTO nas_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eeꞌnoko Jiisuuꞌke tootoꞌ kompura uroꞌkanooꞌ teing-koo donkong-antavuuꞌ. Eeꞌnoko tankaꞌke bokoꞌura aaꞌpuruꞌ teing, ");
INSERT INTO nas_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Baa tee naning ning nkaang miring-koo narung tootoꞌ okiꞌnara aung-pinaꞌ oroꞌ onkeonkeꞌuainge tee ning onkeonkeꞌmuaing, eeꞌnoko ning narung deeaꞌ, naning ning botomuing onkeonkeꞌuainge.” ");
INSERT INTO nas_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joonie aaꞌpuuꞌ, “Nau-anta, niiꞌke naning ooampiring dakaang miring-koo maꞌnari bataꞌuriko. Eeꞌnoko ooampira poteampiri tee niiꞌ ninka nariꞌ daꞌ siontuaung-koo.” ");
INSERT INTO nas_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Eeꞌnoko Jiisuuꞌke bariꞌuma aaꞌpuuꞌ, “Poteveriaukaꞌ tee. Naning nkaang miring-koo kuunge kapooꞌ purintoꞌ nkovura namuꞌke orakaꞌ minkumuarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Baa naning niiꞌ tooꞌdemuriaung tee pakumurimaung-pinaꞌ noruꞌampiaing. ");
INSERT INTO nas_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Eeꞌnoko noruꞌeriai naning oovununge diiꞌ ntong aruriko deekoꞌ Karistooꞌ bakaning tantaririoꞌ teie bakaang mooꞌ divuꞌuaukaꞌnunge. ");
INSERT INTO nas_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Baa tee naning aing toireꞌ ning masikaꞌantamaamaing-koo narung duaꞌantavuaing tee-koo orara aarumo-koo deekoꞌ tee tee piaaruꞌ. Teeꞌ oroꞌ naning baukoi paravuaruuꞌnung dei tampaꞌ, aiꞌ Kumponinge aaꞌnaꞌ kiimatavuaing tee. ");
INSERT INTO nas_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Eeꞌnoko dakaang tankaꞌke duaꞌantaruko napuꞌdaravai. Tampaꞌ masikaꞌ tankaꞌnanaang ninka domaang otoi-otoꞌnooꞌ beaing, eeꞌnoko tankaꞌ kenaanta ninka tampaꞌ deeaꞌ mosianung-aape nanuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Teeꞌ aaꞌnomanooꞌ kikiꞌnanka booroaꞌnooꞌke eeꞌnoko ntaꞌ siriꞌaravaꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Eeꞌnoko dakaang kauꞌke duaꞌantaruko napuꞌdaravai. Tampaꞌ masikaꞌ kauꞌnanauꞌ ninka domaang otoi-otoꞌnooꞌ beaing, eeꞌnoko kauꞌ kenauꞌka ninka tampaꞌ deeaꞌ mosianung-aape nanuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Teꞌ aaꞌnomanooꞌ kikiꞌnanka booroaꞌnooꞌke eeꞌnoko ntaꞌ siriꞌaravaꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Eeꞌnoko duta narutai tapiriꞌantaruko pasiꞌdarara duaꞌeai. Aaꞌnaꞌ tampara duta naruta ninka Kumponing bakaang muuꞌkoo tung-koo eeꞌnoko duta kerutara ninka tampaꞌ deeaꞌ mosianung-aape duaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Teꞌ aaꞌnomanooꞌ kikiꞌnanka booroaꞌnooꞌke eeꞌnoko ntaꞌ siriꞌaravaꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Niiꞌ ookara teing meekaꞌmariri Kumponing-koo boontunang deemariiꞌnaang ntaꞌke miang-pinaꞌ taimuriko, Daari Meekunge minkuvui otoinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Miang tee kapooꞌ tampara, teka miang-koo tariiꞌnooꞌ paaꞌarako arekeeꞌ napoꞌ naninge tariiꞌantavupeuꞌ? Makotuaꞌ! Teeꞌkoo, dau basinaꞌ, ning-koo arooꞌdariri imaꞌdariaing, eeꞌnoko meekupoong masikeng otori pinkaꞌdarima nariꞌ mooarariri otoriai.” ");
INSERT INTO nas_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jiisuuꞌke temono sipura Judiaꞌnameng-koo beuꞌ Jooꞌdani-nari pakoꞌuitaaꞌ. Eeꞌnoko nantoong karikaꞌ napoꞌ tee-anko naroꞌaririoꞌ kara nauvuruꞌ teroita nauvurikoꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eeꞌnoko niiꞌning Boto Keperuuꞌnavitu nariꞌ pororaiꞌnange aavavaama aaꞌpauꞌ, “Naumeriai. Niikaang boto-koo ee naninge baꞌaang bataꞌkoo tauraꞌpui otong?” ");
INSERT INTO nas_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eeꞌnoko aaꞌpuruꞌ, “Teka aremuriiꞌ boto Moosesie aruruꞌ?” ");
INSERT INTO nas_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eeꞌnoko bariꞌaama aaꞌpauꞌ, “Moosesie tauraꞌ avuꞌnisi naninge baꞌaang siꞌkoo piavora deekoꞌ karavoto˜ daarivuaing nampeesi totoꞌpuing tasiꞌanta-koo, eeꞌnoko baꞌaang bataꞌuai.” ");
INSERT INTO nas_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Moosesie aung boto daarivuuꞌnung diiꞌ diiꞌka domang ivekaꞌdariko. ");
INSERT INTO nas_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Teka Kumponinge ookara kapooꞌ pupuꞌuuꞌnang-eta minkuvuma aaꞌpui otong Daari Meekung-koo, ‘Kumponinge donkaani eeꞌnoko manikuma nariꞌ nkovuretuꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Eeꞌnoko ‘Teeꞌkoo donkaanie baumararing sipureta baꞌaang ninka pinkaꞌareaing, eeꞌnoko tenaanka narung mono deempareaing.’ ");
INSERT INTO nas_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Teeꞌpuuꞌnooꞌkoo tenaanka kenaanka deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Teeꞌkoo kapooꞌ Kumponinge beꞌnuꞌantavuuꞌnung naroꞌka naninge tankaampuaukaꞌ nung.” ");
INSERT INTO nas_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Eeꞌnoko teketa pava-koo toroarira bakaning barevare-nupoonge tampaꞌ tasiꞌkoo tanaꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Tenang naninge baꞌaang bataꞌuma oovunani nampupeuꞌ eeꞌnoko nampeesi baꞌaang ninka teka orarivuing. ");
INSERT INTO nas_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Eeꞌnoko baꞌaange bataꞌuma baꞌung oovunara nampupeuꞌ eeꞌnoko nampeesi tee teka orarivuing.” ");
INSERT INTO nas_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Eeꞌnoko nantoonge toireꞌ okiꞌnarekaꞌ Jiisuuꞌanko poꞌantavaarikoꞌ teie kompurira biraankevuriiꞌnaang. Eeꞌnoko teinge bakaning barevare-nupoonge poteaaruꞌ tee-anko tavoꞌaariko. ");
INSERT INTO nas_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Eeꞌnoko Jiisuuꞌke oovurira iiraevuruꞌ bakaning barevare-nupoong aaꞌpurima, “Tauraꞌperereriai toireꞌ ning-anko poꞌkoo, potevereriaꞌ. Kumponinge nantoong toireꞌpinaꞌ bereꞌarimaing bakaang muuꞌkooning. ");
INSERT INTO nas_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Masikaꞌ naurampimang ninge diiꞌ, baa tee naning Kumponing bakaang muuꞌ tootoꞌke bautaꞌ nkavui arooꞌaramanaꞌ kompuarura tee bakei tumparavaukaꞌnung teꞌ Kumponing bakaang muuꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eeꞌnoko minku bakevura toireꞌ narunaꞌ bokoꞌurima tankaꞌ panteꞌuruꞌ Kumponinge biraanke-koo. ");
INSERT INTO nas_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tenang Jiisuuꞌ niiꞌnameng-aape nanuꞌ tutumparako naning narung kuaꞌpari pora miinge keemparuꞌ uroꞌkanooꞌ eeꞌnoko aaꞌpuuꞌ, “Nau-anta tampara, ninge aming kapooꞌ nkoamira domaang oparavaukaꞌnung kompampaing?” ");
INSERT INTO nas_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ tee, “Arekeeꞌkoo dake ning tampara tammemang? Niiꞌnara naning tampara otoaꞌ, Kumponing narung tampara. ");
INSERT INTO nas_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dake Moosesi bakaang boto eeꞌ oroꞌ noruꞌei otong: ‘Naning dupisiꞌeaukaꞌ. Nampeesi orarieaukaꞌ. bakiaaꞌ nkoveaukaꞌ. Daang-koo tuutunampeaukaꞌ. Kapooꞌ kokonoveaukaꞌ. Daumararing deto noruꞌeresi pakuereaing.’” ");
INSERT INTO nas_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Eeꞌnoko teie aaꞌpuuꞌ, “Nau-anta, ninge okiꞌnaꞌnooꞌketa aing ookara boto tanatavantuꞌning.” ");
INSERT INTO nas_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eeꞌnoko Jiisuuꞌke oovui piaavura aaꞌpuuꞌ tee, “Daꞌ narung kapooꞌkoo makosiaꞌ. Bera ookara kapooꞌnanka dakaning baavevera mooniꞌ nkavera ataꞌoiꞌnuka averiai. Teeꞌ nkovera paning-koong kavonanka otoꞌderuaing. Eeꞌnoko teketa ning siomei poai.” ");
INSERT INTO nas_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Eeꞌnoko aung kara taaravura aaꞌnaꞌ muriꞌouꞌ, eeꞌnoko domang mankiꞌoitaaꞌ tenkenuuꞌ, aiꞌ aung naning tee maneenara. ");
INSERT INTO nas_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Eeꞌnoko Jiisuuꞌke ooꞌoovurima bakaning barevare-nupoong aaꞌpuruꞌ, “Bakei poreꞌ masikung manee-nupoong Kumponing bakaang muuꞌkoo tung-koo.” ");
INSERT INTO nas_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Eeꞌnoko bakaning barevare-nupoong aaꞌnaꞌ taꞌninauꞌ teeꞌpuioꞌ. Eeꞌnoko Jiisuuꞌke napoꞌ kara bariꞌevurima aaꞌpuruꞌ, “Ee toireꞌ, bakei poreꞌ masikung Kumponing bakaang muuꞌke tung-koo teing maneeariri otoromanooꞌkoo noruꞌ sipaamaing. ");
INSERT INTO nas_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kaameliꞌnavoroꞌ bamaruꞌkoong busi-koo kuunge tung-koo makotuaꞌ, eeꞌnoko naning maneenara-koo bakei aaꞌnaꞌ koontoꞌ makotuaꞌ Kumponing bakaang muuꞌkoo tung-koo.” ");
INSERT INTO nas_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eeꞌnoko teing aaꞌnaꞌ taꞌninaara biiꞌka kareaama aaꞌpauꞌ, “Nka enang baa domaang mooꞌaravaing?” ");
INSERT INTO nas_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eeꞌnoko Jiisuuꞌke teing oovurira aaꞌpuruꞌ, “Nantoong biiꞌka domaang mooꞌkoo makosi deeaing, Kumponinge deekoꞌ makosi, aiꞌ teie ookara kapooꞌ nko-koo makosie.” ");
INSERT INTO nas_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Eeꞌnoko Piitai karoma aaꞌpuuꞌ, “Aung ee, teka niiꞌ teing ookara kapooꞌ sipampira siontampimaing.” ");
INSERT INTO nas_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Masikung naurampimang, naninge aing sipuuꞌnung: pava, baumaraang, baurukaaꞌ, bakaang kansiꞌ sipura ning-koo eeꞌnoko nkaang kara tampara bereng-anta-koo, eꞌmung-eta dau basinooꞌ makuꞌ nkavuaing daakuꞌpinaꞌ anke kansiꞌkoo otoitaaꞌ; ");
INSERT INTO nas_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Aaꞌnoko: pava, baumaraang, baurukaaꞌ, kansiꞌ. Eeꞌnoko nantoonge turampaavai eeꞌnoko damaꞌnaroong-koo napoꞌ domaang oparavaung okovuaing. ");
INSERT INTO nas_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Teka mmauꞌ nantoong ureai otoromaing damaꞌke damaꞌduariaing, eeꞌnoko damaꞌduariri otoromaing ureaavai.” ");
INSERT INTO nas_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Eeꞌnoko Jiisuuꞌ uroitaaꞌ Jerusalemaꞌaape daanto taunge nanauꞌ, eeꞌnoko taꞌnimpariruꞌ teing siompaakoꞌning avoreaama. Eeꞌnoko bakaning nanaiꞌketa kenaanka naroꞌurira minkunaavuruꞌ damaꞌke nkoaravainaꞌ ");
INSERT INTO nas_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Aaꞌpuruꞌ, “Ee aing, niiꞌ teing Jerusalemaꞌnavuntuꞌkoo deto merimang. Eeꞌnoko teka eeꞌnooꞌka naninge tooka kompui ning Tee Naning-naumpoꞌ Paning-etaing tauraꞌmuuꞌnaang aaꞌning-koo Piristiꞌnuka-koo ovontung eeꞌnoko boto naunuka; eeꞌnoko teinge tee tuutunamaara ning booꞌkoo makosi tampaaraiꞌnange sing-antamaavaing teing-koo Juꞌdeeaing-koo. ");
INSERT INTO nas_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Eeꞌnoko teinge Juꞌdeeainge siisimaavai tutupaaꞌmaama, eeꞌnoko muraꞌmaara dupisiꞌmaavaing. Teketa beenang doong tankinuko napoꞌ daaꞌmaravaing.” ");
INSERT INTO nas_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jeemisi namainta Jooni, Siebedi baurinketa, Jiisuuꞌanko poretuꞌ aaꞌpurema, “Nau-anta, kapooꞌ nkomemureeꞌnaang piamoremang.” ");
INSERT INTO nas_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eeꞌnoko Jiisuuꞌke aaꞌpuretuꞌ, “Aming nkorerompeeꞌnaang piaroremang?” ");
INSERT INTO nas_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eeꞌnoko temaintai makuꞌurema aaꞌpuretuꞌ, “Tauraꞌmereaing neeꞌ daꞌ ninka baꞌnang-koo, tenang dakaang meenasie kororuioꞌ ovorintari baꞌnantaravainang, narung tampavine-aape eeꞌnoko narung mareꞌaanavine-aape.” ");
INSERT INTO nas_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Eeꞌnoko Jiisuuꞌke temainta aaꞌpuretuꞌ, “Deeꞌke tee kapooꞌ eentameresing noruꞌereaꞌ. Deeꞌke ee teruꞌ ntonaruꞌ orakaꞌ deeꞌnaruꞌ ning naikampainaruꞌ naikirepeuꞌ? Eeꞌnoko napoꞌ sisikeera ninka meekaꞌantamaravainaꞌ ee meekaꞌantararepeuꞌ?” ");
INSERT INTO nas_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eeꞌnoko temaintai makuꞌurema aaꞌpuretuꞌ, “Eeꞌ, neeꞌ makosira.” Eeꞌnoko Jiisuuꞌke aaꞌpuretuꞌ, “Eeꞌ, masikaꞌ, kaapu-koo ninge naikampaing-koo naikireainge, eeꞌnoko meekaꞌantamaravainaꞌ meekaꞌantarareainge. ");
INSERT INTO nas_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Eeꞌnoko ning tauraꞌ oꞌnoaꞌ miruꞌkoo naning ning-koo tampavine-koo eeꞌnoko mareꞌaanavine-aape baꞌnang-anta-koo. Aung tee kapooꞌ Kumponing bakaang. Teie bampuuꞌnaꞌ baꞌnampareaing.” ");
INSERT INTO nas_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Eeꞌnoko teinge napoꞌ nanaiꞌke teeꞌ taaravaara Jeemisi namainta Jooni iikooꞌaaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Eeꞌnoko Jiisuuꞌke ookara naroꞌ bokuvurira aaꞌpuruꞌ, “Diiꞌke ee noruꞌeri otong teing nantoong Juꞌdeeaing-kooninge biikaning ovontung miruꞌaarimaing iriꞌoromanaꞌ nantoong-koo. Eeꞌnoko biikaning pankenankai biikaang iriꞌke nantoong etuaarikooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Teka diiꞌkoo teeꞌ deeaꞌ. Naning diiꞌkoong boreꞌ otoꞌkoo piavora diikaang pakupakunung otoai. ");
INSERT INTO nas_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Eeꞌnoko naning diiꞌkoo dau basi deeng-koo piavora botovotonaaꞌ otoai ookara-koo. ");
INSERT INTO nas_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ning Tee Naning-naumpoꞌ Paning-etaing teeꞌke, kansiꞌkoo ovoring-pinaꞌ otoꞌkoo moaꞌ, teka pakupakunung deemaraaꞌnaang mouꞌnung, eeꞌnoko nkaang domaang duaꞌkoo teing-koo mmauꞌ booꞌketa simpiriꞌariiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Eeꞌnoko Jerikooꞌnamono-koo tavoꞌariruꞌ. Teꞌ otorokotaaꞌ napoꞌ tenkenauꞌ Jiisuuꞌ eeꞌnoko bakaning barevare-nupoong. Eeꞌnoko napoꞌ nantoong karikaꞌ nariꞌ. Eeꞌnoko naning duta kaputuꞌ taunge baꞌnampari otoi nantoong mooniꞌkoo eentavurikoꞌ. Aung naning miring Batimiasi, Timiasi bauring. ");
INSERT INTO nas_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eeꞌnoko teie taaravura Jiisuuꞌ Nasaretiꞌnung tankinuko boku tutumpuuꞌ aaꞌpuma, “Jiisuuꞌ, Deevitaꞌ bakanaving-koong, piaameai ning.” ");
INSERT INTO nas_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eeꞌnoko nantoong karikaꞌke poteaama dooroomparaaꞌnaang botoauꞌ. Eeꞌnoko teeꞌpaako bakei aaꞌnaꞌ bokuma aaꞌpuuꞌ, “Deevitaꞌ bakanaving-koong, piaameai ning.” ");
INSERT INTO nas_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eeꞌnoko Jiisuuꞌke nasinura aaꞌpuuꞌ, “Bokueriai.” Eeꞌnoko bokuauꞌ tee kaputuꞌ, aaꞌpaama, “Doturari daaꞌdaravai. Bokurumaang.” ");
INSERT INTO nas_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eeꞌnoko bakaang mononopaꞌ duaꞌura namuꞌke daaꞌarara Jiisuuꞌanko beuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jiisuuꞌke aaꞌpuuꞌ, “Daꞌ arekeeꞌ nkoramaꞌnaang piaroi?” Eeꞌnoko naning kaputuꞌke aaꞌpuuꞌ, “Nau-anta Pankaing ee, ning duta bantang-antameaing.” ");
INSERT INTO nas_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Naniaing. Dakaang baitoi tamparuꞌkiing.” Eeꞌnoko namuꞌke bantora tee Jiisuuꞌ siompuuꞌ taunge nanuko. ");
INSERT INTO nas_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Eeꞌnoko poroma Jerusalemaꞌ dueꞌ Oliveꞌpoꞌnamii-koo basiariruꞌ, osi Bepasi eeꞌnoko Beetani dueꞌ masipoꞌ. Eeꞌnoko bakaning barevare-nupoong-koo Jiisuuꞌke kenaankara uroꞌke botovurema aaꞌpuretuꞌ, ");
INSERT INTO nas_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Deeꞌ ureresi bereta osi uroꞌkanooꞌke otoi-namono-koo duꞌdareai. Eeꞌnoko basirareta doonkiiꞌnu kampianu oovereai biꞌari otoko naning mmeꞌ teu-koo baꞌnamparavaꞌ. Dipiꞌereta poꞌantavereai.” ");
INSERT INTO nas_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eeꞌnoko naninge tanaꞌdurema aaꞌdureko, “Aung aming-koo teeꞌ nkoveremang? Aaꞌpereai, ‘Ovoring piavoing. Napoꞌ torovuaing namuꞌke.’” ");
INSERT INTO nas_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eeꞌnoko bereta oovuretuꞌ tee doonkiiꞌ kampia taung-koo meuꞌke biꞌari otoko pava karanaange; ");
INSERT INTO nas_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eeꞌnoko dipiꞌureko narionge dueꞌ donkonai otorokoꞌninge tanaꞌaarema aaꞌpaaretuꞌ, “Deeꞌ aming nkoverema doonkiiꞌ dipiꞌeremang?” ");
INSERT INTO nas_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eeꞌnoko tenaankai Jiisuuꞌke nauvuretuꞌnaꞌ makuꞌuretuꞌ, eeꞌnoko nantoonge tenang tauraꞌpaaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eeꞌnoko tenaankai poꞌantavuresioꞌ Jiisuuꞌanko teinge biikaang baarong tevoroꞌkoo dau taniꞌauꞌ. Eeꞌnoko Jiisuuꞌ tee-koo dau baꞌnamparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Eeꞌnoko nantoong karikaꞌke biikaang baaronankai taunge danto taniꞌauꞌ, eeꞌnoko narionge uurung tovang poraꞌka napuꞌaama taniꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eeꞌnoko nantoong Jiisuuꞌkoo uroꞌke nanauꞌning eeꞌnoko niiꞌnariong damaꞌdu-eta porouꞌninge eura bokiaama aaꞌpaakoꞌ, “Biraanke! Biraanke-poꞌnung aung Ovoring bakaang miring-koo pomaang! ");
INSERT INTO nas_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Biraankeniiꞌ tee muuꞌ niuma Deevitaꞌketaing napoꞌ donkonge dueꞌumaang! Biraanke otoi otoaing aꞌdeiꞌke paning-koo nariꞌ!” ");
INSERT INTO nas_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Eeꞌnoko aarenuuꞌ Jiisuuꞌ tee-koo osi Jerusalemaꞌ. Eeꞌnoko teketa pava dootuuꞌnava pankava-koo kuung tumparara avitoitoi nanuma beeroꞌuuꞌ. Eeꞌnoko muung-aapevuioꞌ napoꞌ toroaruꞌ Beetani-aape bakaning nanaiꞌketa kenaankara ninka. ");
INSERT INTO nas_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Eeꞌnoko daunaꞌmung Jiisuuꞌ toroaruꞌ Beetaniꞌketa peeravoitaaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eeꞌnoko koiꞌnavari miring piikiꞌ isiꞌisipoꞌketa oovuuꞌ paraꞌ narung uumaananuꞌ. Eeꞌnoko sinang-poꞌnavari tampuma beuꞌ tevari-anko. Eeꞌnoko beraiꞌnange sinang oovuaꞌ, paraꞌ narung otoko oovuuꞌ, sinang biꞌkoong bakaang batei deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eeꞌnoko Jiisuuꞌke tevari aaꞌpuuꞌ, “Naning otoaꞌ dakaang sinang napoꞌ maaꞌderuaing.” Eeꞌnoko bakaning barevare-nupoonge taaravauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Eeꞌnoko Jerusalemaꞌ napoꞌ tavoꞌarira Jiisuuꞌ parang-koo tumparara pava dootuuꞌnava pankava-koong-koo, nantoong sipisipiꞌ dovang parekanumpoꞌ baaveveekoꞌning bataꞌ tutumpuruꞌnung. Aaꞌnoko batanananka mooniꞌ aampariꞌaakoꞌning biikaning eeꞌnoko napoꞌ baꞌnavaꞌnananka kuukuuꞌ baaveaarikoꞌning biikaning teka piakatuꞌuruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Eeꞌnoko potevuruꞌ Pava Dootuuꞌkoo kapooꞌnanka nkavai beꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Eeꞌnoko napoꞌ nau-antavurima aaꞌpuruꞌ, “Aming-koo noruꞌeriaꞌ otong Kumponing bakaang kara Daari Meekung-koo aaꞌpumanaꞌ ‘Nkaang pava tee pava kunsinava tampari otoaing, nantoong amutemuriiꞌ biikaang.’? Teka diiꞌke ‘bakiaaꞌ nkonuka biikanooꞌ’ deeng-antavering.” ");
INSERT INTO nas_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Eeꞌnoko teinge piristiꞌnuka-koo ovontunge eeꞌnoko boto naunuka taaravaara taung besiꞌauꞌ Jiisuuꞌ tavuꞌnaꞌ, nantoong karikaꞌ Jiisuuꞌ bakaang kara-koo taꞌnimparima biꞌariko avoreaara. ");
INSERT INTO nas_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Eeꞌnoko muung-aapevuioꞌ Jiisuuꞌ bakaning ninka tenkenauꞌ ");
INSERT INTO nas_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eeꞌnoko napoꞌ daunaꞌmung oraꞌka-ita tevunge toroarima tevari piikiꞌnavari ooauꞌ maraꞌora booꞌparioꞌ untuꞌketa kaakeng-koo basi. ");
INSERT INTO nas_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Eeꞌnoko Piitai nkoaruꞌnaꞌ noruꞌura Jiisuuꞌ aaꞌpuuꞌ, “Nau-anta Pankaing, ooveai. Tee koiꞌ dake barakosiꞌeieeng maraꞌoi booꞌparing.” ");
INSERT INTO nas_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jiisuuꞌke teing kara makuꞌurima aaꞌpuruꞌ, “Masikaꞌ naurampimang ninge, ");
INSERT INTO nas_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Baa naning baito Kumponing-koo otoꞌevui dei aunteto iuꞌ aaꞌpupeuꞌ, ‘Daaꞌdarara pirung-koo duaꞌdaravai,’ eeꞌnoko bakaang noruꞌ keekooꞌaravaꞌ minkuvuinaꞌ nkoaraaꞌnaang masikaꞌantavuko teeꞌ nkoarapeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Teeꞌkoo aaꞌdampimang, tenang eentararima eeꞌ noruꞌeriai, ‘Kapooꞌ nkavampiring,’ eeꞌnoko tee okoruriaing. ");
INSERT INTO nas_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Eeꞌnoko tenang donkoniri kunsirarima tontaꞌevurereriai kapooꞌ orara diiꞌkoo nkoauꞌnanka. Eeꞌnoko Diuma, paning-koo otomaunge napoꞌ diikaang orara tontaꞌderuriai. ");
INSERT INTO nas_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eeꞌnoko napoꞌ diiꞌke nariong biikaang orara tontaꞌeriaruko Diuma paning-koo otomaunge diikaang aarumo orara tontaꞌkoo makotuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Eeꞌnoko Jerusalemaꞌaape napoꞌ toroariruꞌ eeꞌnoko Jiisuuꞌ dootuuꞌnava pankava-koong-koo parang-koo kuunge nanuuꞌ. Eeꞌnoko piristiꞌkoo ovontung, boto naunuka eeꞌnoko nantoong-koo urang-antanuka Jiisuuꞌanko porouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Eeꞌnoko tanaꞌaama aaꞌpauꞌ, “Tee aung aremuriiꞌ tauraꞌ otoko dake aing kapooꞌnanka nkovemaatoing? Eeꞌnoko napoꞌ baie tauraꞌ aruioꞌ nkovemaatoinge?” ");
INSERT INTO nas_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Eeꞌnoko Jiisuuꞌke kara bariꞌevurima aaꞌpuruꞌ, “Enang aaꞌ napoꞌ ninge tanaꞌdampiaing eeꞌnoko diiꞌke bariꞌmeriko ninge napoꞌ naurampiai tee tauraꞌ ning otoꞌmemuko aing kapooꞌnanka nkoamaung. ");
INSERT INTO nas_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Naumeriai, Jooni baie tauraꞌpuioꞌ nantoong ntong-koo minkivurima meekaꞌantavurikoꞌ, Kumponinge aiꞌ tamung nantoonge? Enang bariꞌmeriai.” ");
INSERT INTO nas_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eeꞌnoko teing biiꞌka niaꞌeema aaꞌpeekoꞌ, “Areꞌpampiaꞌnaang? Aaꞌpampiko deekoꞌ, ‘Kumponinge,’ teie aaꞌmuriiꞌnaang, ‘Teka aming-koo diiꞌke Jooni masikaꞌantaveriarukoꞌ?’ ");
INSERT INTO nas_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Eeꞌnoko aaꞌpampiko deekoꞌ, ‘Tamung nantoong-etaing,’ nantoonge tamaariꞌneenga, aiꞌ teinge tee ookarai Jooni nakaronara Kumponing-etaing tasiꞌpai otong.” ");
INSERT INTO nas_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eeꞌnoko teinge Jiisuuꞌ makuꞌaama aaꞌpauꞌ, “Niiꞌke aaꞌ noruꞌampiaꞌ.” Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Nnaꞌ ninge napoꞌ diiꞌ naurampiarooꞌnaang baa tee ning tauraꞌ amuuꞌnung aing kapooꞌnanka nko-koo.” ");
INSERT INTO nas_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jiisuuꞌke niiꞌning kara mirumiruꞌ nauvurima aaꞌpuruꞌ, “Naning narunge mintoong uaininau keempura parange korovui kaavaneꞌuuꞌ, eeꞌnoko dinkung nenkeꞌuuꞌ uaini miiꞌdoma tenau-koong. Eeꞌnoko napoꞌ pava tarenava siaruaꞌ kanivuuꞌ. Eeꞌnoko napoꞌ niiꞌning nantoong tenau tare-antavurira niiꞌnamensiꞌkoo tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Eeꞌnoko tenang batei sinang kavuꞌkoong makotuioꞌ teie narung bakaang botovotonaaꞌ botovuuꞌ teing-anko uaini tarenuka-anko niiꞌning sinang baarauni-koong˜ tenau-koo nkaevuaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Eeꞌnoko teinge tare nkonukai tee botovotonaaꞌ mooꞌaara bataꞌauꞌ murasiavaama, tee baarauni avaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eeꞌnoko napoꞌ narung botovotonaaꞌ botovuuꞌ. Eeꞌnoko teinge boreꞌ bapeꞌaama maimaiaꞌnaꞌ nkoauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Eeꞌnoko tenau-koo ovoringe napoꞌ narung botovotonaaꞌ botovuuꞌ. Eeꞌnoko teinge tee dupisiꞌauꞌ. Eeꞌnoko napoꞌ mmauꞌ botovotonaaꞌnuka teeꞌ nariꞌ nkoaaruꞌ nariong muraꞌaarima, napoꞌ nariong koontoꞌ dupisiꞌaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Eeꞌnoko teing-koo asiꞌnara botovupeuꞌnung biruanisi bauring piaavumaung. Eeꞌnoko asiꞌnamuꞌkoo deekoꞌ tee bauring botovuuꞌ tare-antavuruꞌning-anko eeꞌ noruꞌura, ‘Aung-koo pa nnuring-koo amaiaaꞌorooꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Eeꞌnoko teinge tare nkonukai biiꞌka kareaama aaꞌpaakoꞌ, ‘Aung tee barenku okovuaing. Aiaꞌ, dupisiꞌampiaing tee barenku okomuriainaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eeꞌnoko teinge tee bauring kompaara teka dupisiꞌauꞌ tee. Eeꞌnoko uaininau-koo damaꞌdu duaꞌauꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Eeꞌnoko Jiisuuꞌke tanaꞌurima aaꞌpuruꞌ, “Enang tenau okonarai arekeeꞌ nkovuriaing? Teie aaꞌ tee teing tare nkonuka-anko pora tavurima opuriaing, eeꞌnoko niiꞌning oko-antavuriaing. ");
INSERT INTO nas_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Diiꞌke ee tee Daari Meekung-koong kara deeruerima damaꞌ nkoaravainaꞌ tasiꞌperiaung aaꞌpui otoinooꞌka, ‘Tereꞌ eeꞌnareꞌ kapanareꞌ pava kaninukai pooreꞌaama duaꞌauꞌnareꞌ ookutunava-koo eꞌmanianareꞌ tumanareꞌ deemparioꞌ tasiꞌpauꞌ damaꞌke. ");
INSERT INTO nas_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ovoringe teeꞌ eeꞌnaꞌ nko-antavuuꞌ eeꞌnoko bakei taꞌnimpaariiꞌ niikaang duta-koo.’” ");
INSERT INTO nas_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Eeꞌnoko teketa mirumiruꞌke tooꞌpuruꞌnung tasiꞌparira boto naunukai eeꞌnoko piristiꞌkoo ovontunge taung besiꞌauꞌ Jiisuuꞌ daiꞌaavainavung, teka teing nantoong karikaꞌkoo avoreaara teka sipaara tenkenauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Eeꞌnoko botoaaruꞌ teing Boto Keperuuꞌnavitu eeꞌnoko Eerotiꞌ Bakanavitu Jiisuuꞌanko porora niiꞌning tanatanaꞌke avakareaama tee duaꞌantanaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eeꞌnoko Jiisuuꞌanko porora aaꞌpauꞌ, “Nau-anta ee, niiꞌke daꞌ noruꞌdampiri otong naning masikung narung minku. Daꞌ tee kapooꞌ naninge minkurupeuꞌning tamung taarai. Eeꞌnoko naning ankang noruꞌeaꞌ. Kapooꞌ masikung narung Kumponinge nantoong pia-antavurimanaꞌ nauerimaung; ");
INSERT INTO nas_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Enang aung naumeriaing niiꞌke Juꞌnupoonge ee daurarong˜ pankaing, Siisaꞌ˜, Roomaꞌnung, taakisi avuꞌkoo makosi, aiꞌ makosi deeaꞌ?” Eeꞌnoko Jiisuuꞌke tokompurira aaꞌpuruꞌ, “Aming-koo dauaꞌmerimaang aiꞌ ning taaviꞌmerimaang? Teu mooniꞌnu iroꞌ poꞌantaveriko ooampai.” ");
INSERT INTO nas_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eeꞌnoko teinge mooniꞌnu nau avaioꞌ tanaꞌurima Jiisuuꞌke aaꞌpuruꞌ, “Aung uuꞌaaꞌ eeꞌnoko aung miring baa bakaang?” Eeꞌnoko aaꞌpauꞌ, “Daurarong Siisaꞌ bakaang.” ");
INSERT INTO nas_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Tee tee averiaing kapooꞌ Siisaꞌ bakaang, eeꞌnoko kapooꞌ Kumponing bakaang Kumponing averiai.” Eeꞌnoko teeꞌ makuꞌurioꞌ aaꞌnaꞌ taꞌnimpariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Teketa napoꞌ Noruꞌ Pitunavitu˜koo niiꞌning Jiisuuꞌanko nianiaꞌ ninka porouꞌ, booꞌketa napoꞌ daaꞌ masikaꞌantavaavaꞌnavitu. ");
INSERT INTO nas_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Porora avakareaama aaꞌpauꞌ, “Nau-anta, Mosesie aung boto daarimemuruꞌnung, ‘Tenang naninge baꞌaang siraraaviꞌaresi naaroarako napoꞌ baaraꞌmaꞌnunge teni damaꞌ mooꞌura bataata-aape paroreai.’ ");
INSERT INTO nas_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Urikamuꞌ tee namaiaꞌ naroꞌka ˜kenaanka-taa otorokoꞌnung. Eeꞌnoko tutunaꞌnung nampeesiarara booꞌparuꞌ beurukaaꞌ otoreaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Eeꞌnoko teketa kenaanka-nunge napoꞌ teni naaro damaꞌmooꞌura paroreaꞌ booꞌparuꞌ. Eeꞌnoko napoꞌ beenaumo-nung teeꞌ nkoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Eeꞌnoko teing ookara teeꞌ nariꞌ, teka aing ˜kenaanka-taa namaiaꞌ teni nampauꞌning biurukaaꞌ otoꞌevuriaꞌ boorouꞌ, eeꞌnoko asiꞌnaꞌmoo teni manikuma booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eeꞌnoko teing teꞌmung asiranaꞌmung booꞌnuka daaꞌariainaꞌmung teni temaiaꞌkoo arera baꞌaang deemparavainani? Aiꞌ ookara ˜kenaanka-taae nampauꞌnani teni.” ");
INSERT INTO nas_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Diiꞌ bakei papaarararimaung, aiꞌ diiꞌke doma Daari Meekung eeꞌnoko Kumponing bakaang purintoꞌ noruꞌeriaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nantoong damaꞌke booꞌketa daaꞌarira koosinung-nanka˜ paning-nupoong-pinaꞌ nampeesiariaꞌ otoroaing. ");
INSERT INTO nas_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Eeꞌnoko tenaare-koo booꞌketa napoꞌ daaꞌnaare-koo diiꞌke ee deeruerima tasiꞌperiaung Moosesie teeꞌ nau-antamuruꞌnaꞌ Daari Meekung-koo daarivuuꞌnavaro-koo? Kumponinge tuuꞌdoiꞌnavari tamung urusivukoꞌnavari-eta karoma Moosesi aaꞌpuuꞌ, ‘Ning tee Kumponing teing aing aaꞌning biikaang: Eebaraamiꞌ, Aisakeꞌ, Jeekopiꞌ. Teing ninka komeeri Oꞌnoi Oꞌnomaung ning.’ ");
INSERT INTO nas_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aung kara tee miruꞌnooꞌ eeꞌ otong: Ookara bakaning deempariri domantooꞌnuka otorong Kumponing bakaang duta-koo, booꞌnuka deeaꞌ. Diiꞌ bakei daang noruꞌerimaing.” ");
INSERT INTO nas_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Narung boto-nau teꞌ otoitaaꞌ taaravuruꞌ tanaꞌeeko, eeꞌnoko Jiisuuꞌke Noruꞌ Pitunavitu tampaꞌ bariꞌuriko oovuuꞌ. Eeꞌnoko Jiisuuꞌanko pouꞌ eeꞌ tanaꞌuuꞌnaang, “Boto arera aaꞌnaꞌ pankaing ookara-ita?” ");
INSERT INTO nas_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Aung boto aaꞌnaꞌ pankaing masikung: ‘Diiꞌ Isireeli-nupoong taaraveriai, Kumponing niikaang Ovoring tee narung masikung. ");
INSERT INTO nas_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Eeꞌnoko dake piaaveaing Ovoring dakaang Kumponing teieta dakaang domang ootukunung eeꞌnoko teieta dakaang uraang˜ ootukunung eeꞌnoko teieta dakaang onou ootukunung eeꞌnoko teie dakaang purintoꞌ ootukunung.’ ");
INSERT INTO nas_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Eeꞌnoko kenaanka-nung boto aung: ‘Dake tee naning daꞌkoo dueꞌnung daka piaararamanaꞌ nariꞌ teeꞌ piaaveaing.’ Niiꞌnara boto otoaꞌ aing-koo dau basi.” ");
INSERT INTO nas_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eeꞌnoko boto-naue Jiisuuꞌ aaꞌpuuꞌ, “Nau-anta, dake bakei tampaꞌ minkueing. Teeꞌ minkueinaꞌ niiꞌnara Kumponing otoaꞌ, tee narung. ");
INSERT INTO nas_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Eeꞌnoko napoꞌ naninge piaavuai Kumponing teieta bakaang domaang ootukunung eeꞌnoko teieta bakaang norunoruꞌ ootukunung eeꞌnoko teieta bakaang purintoꞌ ootukunung. Eeꞌnoko oovunara piaavuai baka piaavaramanaꞌ. Aing boto meung-koo bakei tampaꞌ, dau basi teieta kauꞌ karenaumo boonturomai tai-antavaamaung-eta eeꞌnoko napoꞌ avuavuꞌ niiꞌning Kumponing-koo.” ");
INSERT INTO nas_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Eeꞌnoko Jiisuuꞌke aung naning bakaang makumakuꞌ mataaꞌivui bariꞌuioꞌ aaꞌpuuꞌ, “Daꞌ isipoꞌ otoaꞌ Kumponing bakaang muuꞌketa.” Eeꞌnoko tenang-eta deto teing ookara nantoong avoreauꞌ Jiisuuꞌ niiꞌning nianiaꞌ niaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jiisuuꞌke kara nauvurima pava dootuuꞌnava pankava-koo teing tanaꞌurima aaꞌpuruꞌ, “Arekeeꞌkoo boto naunukai aaꞌpaamaung, ‘Tee naning Kumponinge tero Pakoꞌpariꞌuuꞌnung˜ nantoong domampuri tarevuriainooꞌkoo tee Deevitaꞌ bakanaving-koong deempari tavoꞌaraaꞌnaang.’? ");
INSERT INTO nas_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aiꞌ Deevitaꞌke baka Tanuaang Meekunge karantavuko˜ aaꞌpuuꞌ, ‘Teie Ovoringe nkaang Ovoring nauvuma aaꞌpuuꞌ, “Aꞌ ning-koo tampavine-koo baꞌnaniai bera ninge dakaning tooꞌde-nupoong dakaang kauꞌkoo boonavete-koo siparampainooꞌke basi.’” ");
INSERT INTO nas_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Teeꞌ minkuvuma Deevitaꞌke baka tee Pakoꞌpariꞌniiꞌ Ovoring Kumponing-pinaꞌ basi tampuuꞌnung. Enang arekeeꞌ napoꞌ Deevitaꞌ bakanaving-koong tampaapeuꞌ?” ");
INSERT INTO nas_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Eeꞌnoko minkuvurima aaꞌpuruꞌ, “Koonorariri otoriaing boto naunuka-koo mononopaꞌ isikara ninka nanuꞌkoo piavoromaing; nantoonge pankaing-antavaariiꞌnaang pianuka baaveroma-nairu-koo. ");
INSERT INTO nas_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Napoꞌ pava dootuuꞌnairu-koo baꞌnavaꞌnaniꞌnanka tampeng-koo baꞌnaniaakooꞌ nantoonge ankampaariaꞌnaang. Eeꞌnoko paroro nainang tampooꞌ baꞌnang-koo piavorokooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Naaroonku biikaang pavapoꞌ bakiaaꞌaakooꞌ, eeꞌnoko kunsi isikananka nkoaakooꞌ nantoonge tampaꞌ ooaariiꞌnaang. Teeꞌkoo biikaang kiimata bakei orara masikung.” ");
INSERT INTO nas_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jiisuuꞌ pava dootuuꞌnava pankava-koo karikaꞌkoo meuꞌke baꞌnanui oovurioꞌ nantoonge mooniꞌ duaꞌauꞌ. Eeꞌnoko manee-nupoong mauꞌke mooniꞌ deto duaꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eeꞌnoko niiꞌnani naaro ataꞌoiꞌ poraiꞌnang mooniꞌning keura duaꞌuuꞌ, baruꞌ mooniꞌ masikeng deeaꞌ, nau toeaꞌ pinaꞌ basining. ");
INSERT INTO nas_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eeꞌnoko Jiisuuꞌke bakaning barevare-nupoong naroꞌ bokuvurira aaꞌpuruꞌ, “Masikaꞌ ninge naurampimang, anie naaro ataꞌoiꞌke bakei bautaꞌ masikung sipuing ookarai duaꞌaining-eta dau basi. ");
INSERT INTO nas_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Narionge masikaꞌ daang-pinaꞌ duaꞌaing mooniꞌ mmauꞌ otoꞌevuritaaꞌ, eeꞌnoko teni bakei bane ataꞌoiꞌke teka ookara-koo otoꞌevuining duaꞌuing bakaning taamang mooꞌsiipeuꞌning.” ");
INSERT INTO nas_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Eeꞌnoko Jiisuuꞌ pava dootuuꞌnava pankava-ita siarako bakaning barevare-nupoong-koo narunge aaꞌpuuꞌ, “Nau-anta, ooveai aung bakei pavananka kapang booꞌantanaꞌ oroꞌke kaniauꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eeꞌnoko Jiisuuꞌke bariꞌuma aaꞌpuuꞌ, “Teka ee aung pava pankainanka booꞌantanaꞌ ooverimang? Damaꞌke tee enang paupaureari otoinaꞌ otoaukaꞌnung tuuravarira duaꞌariaing.” ");
INSERT INTO nas_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jiisuuꞌ baꞌnamparuꞌ Iuꞌ Oliveꞌpoꞌnamii-koo, pava dootuuꞌnava pankava-aape toroaritaaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Teke otoko Piita dovang Jeemisi, Jooni eeꞌnoko Aanduruꞌ tee-anko porora biiꞌka otoroi niaꞌaama aaꞌpauꞌ, “Naumeriai tee areꞌmoong teeꞌ nkoaravaing? Eeꞌnoko taaꞌniꞌanta aming teeꞌ nkoaraaꞌnaang dueꞌuko ooꞌkoonge?”. ");
INSERT INTO nas_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eeꞌnoko Jiisuuꞌke tenang tutumpurima aaꞌpuruꞌ, “Bakei tarerariri otoriaing naninge poo-antaruriꞌneenga. ");
INSERT INTO nas_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mmauꞌ nantoong poroaing nkaang miring tampaama, aaꞌpaama, ‘Ning tee eeꞌnara.’ Eeꞌnoko nantoong mmauꞌ papaara-antavaariai teeꞌ minkuaama. ");
INSERT INTO nas_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Teka aroreriaukaꞌ karenanka tavoꞌkaako eeꞌnoko tavoꞌkaavaining-koo taaraverima. Kapooꞌnanka teeꞌ oroꞌ tee nkoaravaining, teka botu mmeꞌ dueꞌuaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Narung kansiꞌ iꞌamparama niiꞌnara kansiꞌ tavuainge, eeꞌnoko narung muuꞌ iꞌamparama niiꞌnung muuꞌ turampuainge. Uꞌmiꞌ avitoitoi nkoaravainge eeꞌnoko nantoong peera-koo booroainge. Tutunaꞌning teing orakaꞌ mantong manikumai tootoꞌ pontoꞌke dueꞌuko mantonaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Teka diiꞌ tampaꞌ tarerariai. Eeꞌnoko taꞌniniriaukaꞌ nantoonge diiꞌ daiꞌdaarira tuutunantaariko koompaaraꞌnavitu-koo, niiꞌnooꞌ murasiaraariko pava dootuuꞌnairu-koo. Diiꞌ teing donkong-antaraariai ovoꞌmaꞌnuka-anko eeꞌnoko dauraronuka-anko diiꞌ nkaang miring siraꞌkoo miruꞌniiꞌnuka deentarikoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Eeꞌnoko doorenang tampara navoꞌka tutung daankiari otoai nantoong amutemuriiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eeꞌnoko teinge daiꞌdaarima tuutunang-koo beꞌantaraariko avitoitoi noruꞌ mankiꞌ doriaukaꞌ paaꞌerima minkueriainaꞌ. Teka teinge tanaꞌdaariko, Kumponinge kapooꞌ tenang eeꞌnang naururiko tamung kato minkueriaing. Diiꞌ diiꞌka tee kareriaukaꞌnung, teka tee Tanuaang Meekung karoaing. ");
INSERT INTO nas_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Napoꞌ aaꞌnoainge: bataatai tooka kompui baaraꞌmaꞌnung tauraꞌpuaing dupisiꞌaavaꞌnaang, eeꞌnoko baumai bauring teeꞌ nariꞌ nkovuai. Napoꞌ biurukaaꞌke biumaraang turampaarima dupisiꞌaariainge. ");
INSERT INTO nas_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Diiꞌ teing ookara nantoonge munteꞌdaariaining ning nkaang miring-poꞌnupoong deentariko, eeꞌnoko naning purimparioꞌ bera asiranaꞌmung basiaravaing deekoꞌ domamparavaing.” ");
INSERT INTO nas_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Teie nakaronarai Danieloi daarivuuꞌnaneꞌkoo deeruerima tasiꞌperiaing: ‘Naning maarekusiꞌ donkonuaing pava dootuuꞌnava pankava-koo Kumponinge meekaꞌantavuuꞌnooꞌke.’ Tee taaꞌniꞌanta osi orari-koong. Tenang tee donkonuioꞌ ooverira diiꞌ aꞌ Judiaꞌnameng-koo otoriaining miinanka-koo deto bakei navoꞌka kooꞌdariaing! ");
INSERT INTO nas_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Naning daunavaro-koo otoaing deekoꞌ depeto siarara pava-koo kuung beaukaꞌ. Tamung kapooꞌ nka-koo tung-koo makotuaukaꞌnunge. ");
INSERT INTO nas_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Napoꞌ naning mintoong-koo otoainooꞌketa pava-koo toroaravaukaꞌ bakaang mononopaꞌ nka-koo. ");
INSERT INTO nas_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aung batei mankiꞌ masikung teing-koo manikuꞌ kempoꞌnuka eeꞌnoko noonooꞌkai otoroaining. ");
INSERT INTO nas_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Teka diiꞌ kunsirariaing teꞌmung mmaririainaꞌmung kamaarinang-koo tavoꞌkuaukaꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tee arikung teꞌmung tavoꞌkuaing tee bakei dau basi aung kansiꞌ tutuntoma-ita nkoaruꞌning-koo bera eꞌmung doong-koo basinooꞌkoo, eeꞌnoko napoꞌ damaꞌke teeꞌ basi otoaukaꞌnunge. ");
INSERT INTO nas_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Teka Kumponinge teing nantoong baka miruꞌuruꞌning piaavurira aing doong apukaꞌantavuuꞌ. Eeꞌnoko teing doong arikananka apukaꞌantavuriarui dei ookara nantoong booropeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Eeꞌnoko tenang eeꞌnang niiꞌnung naninge aaꞌduriko deekoꞌ, ‘Ooveriai, aung tee Kumponinge Pakoꞌpariꞌniiꞌ tavoꞌkuaing-koong!’ niiꞌnooꞌ aaꞌpuko, ‘Ooveriai auntang!’ tee masikaꞌantaveriaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aiꞌ teing nakaro-nupoong eeꞌnoko pakoꞌpariꞌniiꞌnuka daang Kumponing-etaning tamparimaing porora taaꞌniꞌanta pankenanka taꞌnimpaariiꞌnaꞌ nkoaavaing nantoong tosiaarima Kumponing bakaning naroꞌka papaara-antavaariiꞌnaang, tavoꞌarapeuꞌnung-pinaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Eeꞌnoko diiꞌ teing dontaꞌke moronuka. Ninge tero nau bakerampiruꞌning.” ");
INSERT INTO nas_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Tenang batei arikung bakearako tee duaaꞌ tenang mutaanampuai eeꞌnoko kaara arakavaravaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Eeꞌnoko beentoꞌnanka tankavariai paning-eta. Eeꞌnoko purintoꞌnanka paning-koo otoromaing dankampariai. ");
INSERT INTO nas_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Eeꞌnoko tenang teinge ning Tee Naning-naumpoꞌ Paning-etaing taaꞌniꞌmoi moko oomaavaing, purintoꞌ ninka kamoꞌke depeto aaꞌnaꞌ meenaꞌmoi. ");
INSERT INTO nas_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Eeꞌnoko tenang ninge botoarampaing koosinunanka ookara kansiꞌkoo teing nkaning miruꞌnisinuka naroꞌkoo doving karenaumo-ita eeꞌnoko napoꞌ kansiꞌ kainuꞌnairu-eta.” ");
INSERT INTO nas_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Enang tee diiꞌke tee baisirovang ooverira noruꞌeriaing, aaꞌnomaung: Tenang paraꞌ nenuvaraꞌuko noruꞌerikooꞌ teketa deto puaravuuꞌnaang dueꞌka. ");
INSERT INTO nas_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Teeꞌ nariꞌ kapooꞌ aing eeꞌ oroꞌ tavoꞌarako ooverira diiꞌke eeꞌpinaꞌ noruꞌeriaing, dueꞌui otong, karanaang poing. ");
INSERT INTO nas_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Masikaꞌ naurampimang, Teing aing kapooꞌ ookara nkoaravaing aung avarang booꞌpariaruko. ");
INSERT INTO nas_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Paning eeꞌnoko kansiꞌ teing oparavaininge teka nkaang kara tee oparavaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Naninge noruꞌuaꞌ batei poainooꞌ. Paning-nupoong koosinunukai noruꞌaavaꞌ. Ninge tee bauringe noruꞌampaꞌ. Teka teie Mmaꞌ narunge noruꞌui otong tee batei. ");
INSERT INTO nas_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Teka diiꞌ tanatarariri otorimaatoai, kunsi ninka tanterariri, aiꞌ diiꞌke noruꞌeriaꞌ batei tavoꞌaravainooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Teeꞌ nariꞌ naning pankaing isipoꞌ nanuma osi-eta tenkenupeuꞌnung-pinaꞌ bakaning botovotonaaꞌnuka tauraꞌ avurima mintoonge kantevuripeuꞌ eeꞌnoko karanaang tampaꞌ tanata-koo teing-koo narung botovupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Teka diiꞌ teing tanatarariri otorimaatoaing. Noruꞌeriaꞌ arenang deeꞌma pava okonara poainge, aiꞌ pa muung-aapenang, aiꞌ pa meuꞌnamang, aiꞌ pa siimporovuko˜, aiꞌ pa taneꞌnang. ");
INSERT INTO nas_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Taꞌninaꞌ poma deekoꞌ aasirioꞌ poꞌneeng. ");
INSERT INTO nas_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Teka ninge naurampimanaꞌ ookara nauarama aaꞌpamaung: Teka diiꞌ teing navoꞌka tarerariai.” ");
INSERT INTO nas_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Teꞌmung Taamang Baariꞌkoong˜ eeꞌnoko tee Paroro Iisiropa keꞌmunta doong deto otoko naiaakoꞌnaꞌmung, piristiꞌnuka-koo ovontung eeꞌnoko boto naunuka mumunsiariruꞌ Jiisuuꞌ aavavaama mooꞌaara dupisiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Eeꞌnoko teinge aaꞌpauꞌ, “Naꞌmoo paroro ninka nkoampiaukaꞌ nantoonge karingai turamaariꞌneenga.” ");
INSERT INTO nas_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Teketa tee Jiisuuꞌ teke Beetani-namono-koo otoko tee Saimoniꞌ tero oramuuꞌpoꞌnung bakanava-koo kuunge. Eeꞌnoko tenang Jiisuuꞌ teke taamang bantoꞌdomai baꞌnamparioꞌ nani manikuma tee-anko pouꞌ duuninaroꞌ mooꞌ pankaing-koonaroꞌ nkavui. Eeꞌnoko tenie pora Jiisuuꞌkoo boreꞌkoo dau dakovuuꞌ teke taamang bantoꞌdomai baꞌnamparioꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Eeꞌnoko nariong iiravorora biiꞌka kareaama aaꞌpauꞌ, “Anie aung duuni aming-koo keraꞌpumaang tamung? ");
INSERT INTO nas_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aung duuni baavevui dei beenaumo daakuꞌ nopaꞌke mooꞌaapeuꞌ eeꞌnoko mooniꞌ ataꞌoiꞌnuka avuripeuꞌ.” Teeꞌ nariꞌ mamairoarima pooreꞌauꞌ teni. ");
INSERT INTO nas_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Teni siperiai. Diiꞌke aming-koo poreꞌantaverimang? Anie tee kapooꞌ tampara masikung ning-koo nkovuing. ");
INSERT INTO nas_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Diiꞌ ninka ataꞌoiꞌnuka teing doong kante otorimaatoaining nariꞌ. Niiꞌnang piarorira pakuereripeuꞌ. Teka ning tee doong kante diiꞌ ninka oꞌnoriaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Anie kapooꞌ makosinaꞌ nkovuing. Anie ning-koo duuni mmeꞌka dakovuing maamu-antamuma ning dakoꞌmaavainaꞌmung-koo. Tenie duuni kooꞌuing nkaang mono dakoꞌkoo maamu-antavuma. ");
INSERT INTO nas_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Masikung naurampimang: Areꞌke tokoi ookara kansiꞌkoo tee tampara doorenang daankiaavainooꞌke tee kapooꞌ anie ning-koo nkovuing minkuaama ani norunoruꞌaavaing.” ");
INSERT INTO nas_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Teketa Judasi Kerioꞌnara Jiisuuꞌ bakaning nanaiꞌketa kenaanka-koo narung nanuuꞌ piristiꞌnuka-koo pankainuka-anko nariꞌ mumunsiaara teing-anko sivuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Eeꞌnoko teinge taaravaara bakei dotuariruꞌ. Dotuarira tee mooniꞌ teinge avuꞌkoo tampauꞌ. Eeꞌnoko teie batei eeꞌnoko taung besiꞌuuꞌ Jiisuuꞌ sivuainaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tutunaꞌnaꞌmung tee-koo paroro Juꞌ biikaang bereteꞌ iisiropa-koong basiaruꞌ. Teꞌmung eeꞌnaꞌmung doong sipisipiꞌ kampia pareka Taamang Baariꞌkoong-koo tavaarikoꞌnaꞌmung, eeꞌnoko teꞌmung basiarioꞌ bakaning barevare-nupoonge Jiisuuꞌ aaꞌpauꞌ, “Dake niiꞌ areꞌ merira tee Taamang Baariꞌkoong˜ maamu-antavampira naiampiiꞌnaang piaromaang?” ");
INSERT INTO nas_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eeꞌnoko Jiisuuꞌke bakaning barevare-nupoong-koo kenaankara botovuretuꞌ aaꞌpurema, “Bereta osi pankaing-koo bereai. Eeꞌnoko naning narunge utau ntong-poꞌnung kuru-koo ipampui nanuko kuneꞌdureaing. Eeꞌnoko tee siomperesi bereai. ");
INSERT INTO nas_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pava-koo tumparako siomperesi bereta tevaꞌ okonara aaꞌpereai, ‘Teie nau-antai aaꞌpuing, “Nkanavaro areꞌ otong paroro nai-navaro nkaning barevare-nupoong ninka?” ’ ");
INSERT INTO nas_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eeꞌnoko teie daunavaro pankavaro tarepa eeꞌnoko baꞌnavaꞌnang-poꞌnavaro naurureai. Eeꞌnoko tevaro-koo kapooꞌ maamu-antavereai niiꞌkoo makosi.” ");
INSERT INTO nas_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Teeꞌ nauvuresioꞌ tenaanka tenkenuretuꞌ osi pankaing-koo. Basiareta ookara kapooꞌ Jiisuuꞌke nauvuretuꞌnaꞌ oovuretuꞌ. Eeꞌnoko tenaankai maamu-antavuretuꞌ tee Taamang Baariꞌkoong. ");
INSERT INTO nas_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Eeꞌnoko muumpuioꞌ Jiisuuꞌ teing ninka nanaiꞌketa kenaanka barevare-nupoong ninka porouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eeꞌnoko tenang taamanaama Jiisuuꞌke aaꞌpuruꞌ, “Ninge masikaꞌ nauramping, diiꞌkoo nariꞌ taamanampimaatomaunge tee tooka kompui ning tooꞌde-nupoong-koo simuaing.” ");
INSERT INTO nas_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Eeꞌnoko teing domang mankiꞌ tutumparima narunaꞌ doompeitaaꞌ niaꞌaama aaꞌpauꞌ, “Baie? Aiꞌ pa ninge?” ");
INSERT INTO nas_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Diiꞌkoo narunge nariꞌ utau-koo toonampematomaunge. ");
INSERT INTO nas_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ning Tee Naning-naumpoꞌ Paning-etaing moompaing Daari Meekung-koo minkuauꞌnaꞌ, teka piaaruꞌ masikung tee naning tooka kompui kare-nupoong-koo ning simuaing. Toraꞌkuainung tee. Pontoꞌaravaruuꞌnung dei bakei tampaꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eeꞌnoko teeꞌ taamanaama Jiisuuꞌke bereteꞌnu nkavura, biraankevuma, pisiꞌura teing avuruꞌ aaꞌpurima, “Nkaveriai, aung tee nkaang mono makosi.” ");
INSERT INTO nas_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Teeꞌpura napoꞌ uaininareng avaako nkavura kompui tampaꞌ tampura Kumponing-koo teing avuruꞌ, eeꞌnoko teing ookara teruꞌkoo naikauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Naiaako aaꞌpuruꞌ, “Aung tee nkaang ereng nerakung kara naroong-anta pinkaꞌanta-koong makosi, mmauꞌ nantoong domang-anta-koo dakoaravaing. ");
INSERT INTO nas_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Masikung naurampimang, aung uaini-koo napoꞌ naiampaukaꞌnung bera nerakung-koo naikampainooꞌke basi Kumponing bakaang muuꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eeꞌnoko teeꞌ minkuvura kenanavu kenavauꞌ eeꞌnoko danto tenkenauꞌ Oliveꞌpoꞌnamii-aape. ");
INSERT INTO nas_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jiisuuꞌke aaꞌpuruꞌ, “Diiꞌke ookarai ning siꞌmerira kooꞌdariiꞌnaang Kumponinge tero minku bakevuuꞌnaꞌ Daari Meekung-koo aaꞌpuuꞌnaꞌ, ‘Ninge tee sipisipiꞌ tanatanung tavanko teing sipisipiꞌnanka teing avitoitoi purarenkaꞌariaining.’ ");
INSERT INTO nas_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Teka ning booꞌketa daaꞌmarara Kaaleliꞌnameng-koo meaing diiꞌkoo uroꞌke.” ");
INSERT INTO nas_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Eeꞌnoko Piitai kara makuꞌuma aaꞌpuuꞌ, “Ninge tee bakei daꞌ siꞌdampaukaꞌnung bane ainge niiꞌninge siꞌdaako.” ");
INSERT INTO nas_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Ninge masikaꞌ nauramaang, eꞌmung eeꞌnaꞌmung muunga kokoreeꞌ kemuꞌkanaꞌ kooꞌkuaruko daꞌ beemuꞌpie penkentaravaing niꞌninka nariꞌ oꞌnoremaung-koo.” ");
INSERT INTO nas_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eeꞌnoko Piitai aaꞌnaꞌ karoma bariꞌuma aaꞌpuuꞌ, “Ning tee daꞌkoo penkemaravaukaꞌnung bera daꞌ ninka moompeainge.” Eeꞌnoko ookara teing niiꞌning barevare-nupoong teeꞌ nariꞌ kareauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Eeꞌnoko berora ketsemani tampaakoꞌnooꞌ tavoꞌariruꞌ. Eeꞌnoko Jiisuuꞌke bakaning barevare-nupoong aaꞌpuruꞌ, “Anke baꞌnantaririoꞌ ning ankaꞌ mera kunsimaraaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Eeꞌnoko Piita dovang Jeemisi, Jooni bokuvurira berouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Eeꞌnoko bakaang domang aaꞌnaꞌ mankiꞌoitaaꞌ orakaꞌ deeꞌouꞌ. Eeꞌnoko aaꞌpuruꞌ, “Nkaang domang orarunsie bakei booꞌpinaꞌ deeꞌmoing. Anke tanatarariri otoriko.” ");
INSERT INTO nas_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Teketa kato okiꞌnooꞌ bera teꞌ doonko kinkinura kansiꞌkoo teke kunsiaruꞌ tee batei arikung divuꞌantavuuꞌnaang makosi deekoꞌ, aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Mmaꞌ, Mmaꞌ, daꞌ makosi ookara kapooꞌ nko-koo. Aung kiimata koong kaapu baariꞌantameai, teka kapooꞌ ninka piamomaung makosi deeaꞌ, kapooꞌ daka piaromaung deekoꞌ makosi.” ");
INSERT INTO nas_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Eeꞌnoko teketa toroaruꞌ. Eeꞌnoko teing beenaumo peꞌnumpuruꞌ aasiaako, eeꞌnoko tee Piita aaꞌpuuꞌ, “Saimoniꞌ, daꞌ ee aasii otong? Daꞌ ee makosi deeaꞌ okiꞌnooꞌ batei tanatarari otoꞌkoo?” ");
INSERT INTO nas_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Tanatarariri otoriai kunsirarima parapaara-koo duaꞌdariꞌneenga, aiꞌ domange tee piarori otoritaaꞌ diikaang mono aruaruꞌdorimang.” ");
INSERT INTO nas_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Eeꞌnoko napoꞌ kato bera kunsiaruꞌ iroꞌ minkuvuuꞌnaꞌ karoma. ");
INSERT INTO nas_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eeꞌnoko napoꞌ pora teeꞌ teing aasiai otoroko oovuruꞌ, duta aasiꞌke tavurioꞌ. Eeꞌnoko teinge Jiisuuꞌ makuꞌnaꞌ paaꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Eeꞌnoko napoꞌ beemuꞌpinaꞌ pora aaꞌpuruꞌ teing, “Diiꞌ ee mmeꞌ uaarorima aasirimang? Enang makotuing. Batei enang tavoꞌkung. Ning Tee Naning-naumpoꞌ Paning-etaing tooka kompui naninge simuuꞌnaang nantoong oreng biikaang bireng-koo. ");
INSERT INTO nas_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aiaꞌ, daaꞌdarira meriai. Ooveriko naning baavemuing aung enang pomaang.” ");
INSERT INTO nas_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Eeꞌnoko namuꞌke tee Jiisuuꞌ teeꞌ karoi otoko tee Judasi pouꞌ teing-koo nanaiꞌketa kenaanka-koong narung nantoong karikaꞌ ninka bainatu eeꞌnoko taꞌbaka dovang nkavaitaaꞌ botoaarioꞌ teinge: piristiꞌnuka-koo ovontung eeꞌnoko boto naunuka eeꞌnoko pankeuꞌ urantanuka. ");
INSERT INTO nas_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Teie tooka kompui Jiisuuꞌ kare-nupoong-koo sivuuꞌnaang tee taaꞌniꞌanta maamu-antavuuꞌ aaꞌpuma, “Tee naning ninge nuunuampaing tee eeꞌnara naning diiꞌke bokotaanierira daiꞌerira baramperiaing.” ");
INSERT INTO nas_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Eeꞌnoko Judasi basiarara namuꞌke Jiisuuꞌanko bera aaꞌpuuꞌ, “Nau-anta Pankaing!” Eeꞌnoko nuunuvuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eeꞌnoko Jiisuuꞌ tankaꞌke pinkaꞌai mooꞌauꞌ tee. ");
INSERT INTO nas_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Eeꞌnoko dueꞌ donkonai otorouꞌning-koo narunge bakaang bainatu barampura piristiꞌkoong pankaing bakaang botovotonaaꞌ tekaꞌpuma domeꞌ eteꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Eeꞌnoko Jiisuuꞌke karoma aaꞌpuruꞌ, “Diiꞌke ee ning tavuꞌ nkoaama bakiaaꞌkamaung deemerima bainatu dovang ninka ankonuꞌ aaꞌning nkaveri poring ning daiꞌmeriiꞌnaang? ");
INSERT INTO nas_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Doong kante ning tee diiꞌ eeꞌning ninka oꞌnori dootuuꞌnava pankava-koo nau-antamaramaung teka teke doonanairu-koo oꞌnoko diiꞌke ning daiꞌmeriaung. Teka koontoꞌ Daari Meekung-koong kara dupearavaing.” ");
INSERT INTO nas_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eeꞌnoko tenang teinge ookara bakaning barevare-nupoonge teka sipaama kooꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Eeꞌnoko narung naning nemaka baarong kakaarai duaanisie Jiisuuꞌ siompuko teinge mooꞌaako teie duaana sipura simpeng mmaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Eeꞌnoko Jiisuuꞌ piristiꞌnuka biikaang-anko beꞌantavauꞌ naroꞌariruꞌnooꞌ piristiꞌkoo ovontunuka, pankeuꞌkoo urantanuka eeꞌnoko boto naunuka. ");
INSERT INTO nas_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piitai damaꞌke isipoꞌketa kaarie sipurima siompuruꞌ eeꞌnoko tumparuꞌ piristiꞌnuka biikaang pankaing bakanavaꞌkoo uroꞌmang, eeꞌnoko teke Juꞌ biikaang piatooronuka˜ ninka nariꞌ baꞌnampariri ntaꞌkoo ankavorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eeꞌnoko piristiꞌnuka-koo ovontung eeꞌnoko ookara koompaaraꞌnavitue kapooꞌ Jiisuuꞌke nkovuuꞌnung-koo kara besiꞌauꞌ Jiisuuꞌ tuumpi-kooning kara daaꞌaara deekoꞌ Jiisuuꞌ dupisiꞌaavaꞌnaang. Eeꞌnoko teinge kapooꞌ daaꞌaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nantoong mmauꞌke Jiisuuꞌ daang daiꞌnavimpauꞌ duaꞌanta-koo, teka biikaang minkunaa nariꞌ deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Narionge donkonaama daang minkuaama aaꞌpauꞌ, ");
INSERT INTO nas_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Niiꞌke taaravampirioꞌ aaꞌpuuꞌ, ‘Ninge pava dootuuꞌnava pankava tankaꞌke nkonisinavaꞌ turampamira napoꞌ beenang doong-koo niiꞌnava kaniampaing nantoonge tankaꞌke nkoniiꞌnava deeaꞌ.’” ");
INSERT INTO nas_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Teka ainge biikaang minkunaa nariꞌ minkuaavarukoꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eeꞌnoko piristiꞌnuka biikaang pankaing meuꞌ donkonura ookara-koo uroꞌkanooꞌka Jiisuuꞌ tanaꞌuma aaꞌpuuꞌ, “Daꞌ ee bariꞌnaꞌ otoꞌderuaꞌ? Siraꞌdaravai aung-koo tuumpiraamaung-koo!” ");
INSERT INTO nas_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Eeꞌnoko Jiisuuꞌ tamung kaꞌduuari otokoꞌ. Okiꞌnooꞌ karoaꞌ. Napoꞌ piristiꞌnuka biikaang pankainge tanaꞌuma aaꞌpuuꞌ, “Daꞌ ee tee Kumponinge tero Pakoꞌpariꞌniiꞌ niiꞌ domameri taremeriainooꞌkoo, Kumponing Biraanke Bauring?” ");
INSERT INTO nas_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Eeꞌ, ning aaꞌ tee. Eeꞌnoko dueꞌke tee ning tasiꞌmeriaing ning tee eeꞌnung, Tee Naning-naumpoꞌ Paning-etaing Daari Meekunge kamoꞌke depeto pora ookara kansiꞌ tarevumaatoainung naururimaung. Aiꞌ ning teeꞌ nariꞌ moko diiꞌke oomeriaing, Kumponinge tee ninka iriꞌ okoraꞌnooꞌ baꞌnang-antamuioꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Eeꞌnoko piristiꞌnuka biikaang pankaing iiravora bakaang mononopaꞌ dereꞌuma aaꞌpuuꞌ, “Niiꞌ nantoong aung-koo kapooꞌ minku-koo piamoriaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kumponing akapeuꞌuko taaravering deekoꞌ arekeeꞌ matauerimaang?” Eeꞌnoko nariꞌ kareaama pooreꞌauꞌ, eeꞌnoko aaꞌpauꞌ, “Booꞌanta-koong, orakaꞌ karomaung.” ");
INSERT INTO nas_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eeꞌnoko narionge tenang-eta tutupaaꞌaakoꞌ. Eeꞌnoko duta baaronge daiꞌaara tavauꞌ aaꞌpaama, “Iroꞌ tarampeerarama˜ mansiꞌdari naumeriai, ‘Baie pa tarumang?’” Eeꞌnoko teinge piatooronukai mooꞌaara tankoꞌpauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tenang Piita pava-koo damaꞌdu-navaro-koo otoko Piristiꞌ Pankaing bakaning-koonani neraiꞌnaꞌ bautara pouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Eeꞌnoko Piita ankavoko oovuuꞌ, eeꞌnoko koontoꞌ tee oovuitaaꞌ tenie aaꞌpuuꞌ, “Narung dake Jiisuuꞌ Nasaretiꞌnung ninka otorimaung.” ");
INSERT INTO nas_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eeꞌnoko Piitai penkemparama aaꞌpuuꞌ, “Ning aaꞌ noruꞌmaravaꞌ dake minkumeinaꞌ.” Eeꞌnoko Piita karanaang-aape diiriꞌaruꞌ. Eeꞌnoko tenang kokoreeꞌ karouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Eeꞌnoko tenie bautarai napoꞌ oovura dueꞌ donkonai otorouꞌning nauvurima aaꞌpuruꞌ, “Aung teing-koo narung.” ");
INSERT INTO nas_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eeꞌnoko Piita napoꞌ penkemparuꞌ. Eeꞌnoko napoꞌ pankaroompuaruko teinge nantoonge teke donkonai otorokoꞌninge Piita tuumpiaama aaꞌpauꞌ, “Bakei daꞌ teie, teing-koo narung masikaꞌ, aiꞌ daꞌ Kaaleliꞌnaꞌ karemang.” ");
INSERT INTO nas_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Eeꞌnoko Piita baka barakosiꞌarama maraka-antavarama aaꞌpuuꞌ, “Ninge tee naning noruꞌampaꞌ diiꞌke minkuerimatomaung.” ");
INSERT INTO nas_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Eeꞌnoko namuꞌke kokoreeꞌ kooꞌkuuꞌ kemuꞌkanaꞌ. Eeꞌnoko Piitai tenang noruꞌuuꞌ Jiisuuꞌke minkuvuma aaꞌpuuꞌnaꞌ, “Kokoreeꞌ mmeꞌ kemuꞌkanaꞌ kooꞌkuaruko daꞌ penkentaravaing niꞌninka nariꞌ oꞌnoremaung-koo beemuꞌpie.” Eeꞌnoko teeꞌ noruꞌuraiꞌnange biromparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tero maatanang teing piristiꞌnuka-koo ovontung pankeuꞌkoo urantanuka, boto naunuka eeꞌnoko ookara koompaaraꞌnavitu naroꞌke mumunsiariruꞌ. Eeꞌnoko teketa Jiisuuꞌ daiꞌaara tavoꞌauꞌ Pailatiꞌanko. ");
INSERT INTO nas_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailatiꞌke tanaꞌuma aaꞌpuuꞌ, “Daꞌ ee Daurarong˜ Juꞌnupoong Biikaang?” Jiisuuꞌke bariꞌuma aaꞌpuuꞌ, “Masikung minkuemaang.” ");
INSERT INTO nas_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eeꞌnoko ookara piristiꞌnukai kapooꞌ avutevuꞌkoo tuutuauꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tuutuaako Pailatiꞌke napoꞌ tanaꞌuma aaꞌpuuꞌ, “Arekeeꞌ, bariꞌearooꞌnaang? Taaraveko mmauꞌ kapooꞌkoo tuumpiraamaang.” ");
INSERT INTO nas_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Eeꞌnoko Jiisuuꞌke napoꞌ kara-koo niiꞌnaare makuꞌevuaꞌ. Eeꞌnoko teeꞌkoo Pailatiꞌ aaꞌnaꞌ taꞌnimparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ookara mareꞌ kante-koo Taamang Baariꞌkoong-koo˜ Pailatiꞌke kiimata-ita narung simpiriꞌantaevurikoꞌ nantoonge tanaꞌaako. ");
INSERT INTO nas_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eeꞌnoko teꞌmung batei-koo naning miring Barabasi kiimata-koo otoko nariong ninka ovoꞌmaꞌ turampaakoꞌning ninka, turampeema naning dupisiꞌauꞌning. ");
INSERT INTO nas_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eeꞌnoko nantoong naroꞌariruꞌ Pailatiꞌke tanaꞌkoo mareꞌ kante nkovukoꞌnaꞌ nkovuaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Eeꞌnoko Pailatiꞌke tanaꞌurima aaꞌpuruꞌ, “Teka diiꞌke aung Juꞌnupoong Biikaang Daurarong ninge simpiriꞌanta-koo ee piarorimang?” ");
INSERT INTO nas_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tampaꞌ noruꞌuitaaꞌ aiꞌ piristiꞌnuka-koo ovontunge Jiisuuꞌ tee mamairo-ita tee-anko tavoꞌauꞌnung. ");
INSERT INTO nas_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Eeꞌnoko pankeng piristiꞌnukai nantoong tukoaaruꞌ Pailatiꞌanko bokiaako, Barabasi narung simpiriꞌantavuko teing-anko poꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Eeꞌnoko Pailatiꞌke napoꞌ nantoong niaꞌurima aaꞌpuruꞌ, “Teka ninge arekeeꞌ nkoamaꞌnaang piarorimaang aung Juꞌnupoong Biikaang Daurarong?” ");
INSERT INTO nas_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eeꞌnoko teinge bokiaama aaꞌpauꞌ, “Aaꞌbarataꞌkoo taakaveaing.” ");
INSERT INTO nas_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eeꞌnoko Pailatiꞌke aaꞌpuruꞌ, “Teka aming orara nkovuing-koo?” Eeꞌnoko teeꞌ minkuvuioꞌ napoꞌ baruꞌ aaꞌnaꞌ bokiaama aaꞌpauꞌ, “Aaꞌbarataꞌkoo taakaveaing tee.” ");
INSERT INTO nas_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eeꞌnoko Pailatiꞌke nantoong pinau-anta-koo piavora Barabasi simpiriꞌantavuuꞌ teing-anko poꞌkoo. Eeꞌnoko Jiisuuꞌ muraꞌkoo botovuruꞌ Pailatiꞌke, eeꞌnoko avuruꞌ aaꞌbarataꞌkoo taaka-koo. ");
INSERT INTO nas_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Eeꞌnoko piatooronukai Jiisuuꞌ ovoꞌmaꞌ bakanavaꞌkoo kuung tung-antavauꞌ. Eeꞌnoko ookara biiꞌmarang naroꞌ poꞌkoo bokuaaruꞌ tee akapeuꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Eeꞌnoko mononopaꞌ isikung dauraronuka biikaang-pinaꞌ iiraampumaung kurumpauꞌ, eeꞌnoko baakopo moꞌming kunikunisi-koo nkoaara tee-koo boreꞌkoo kurumpauꞌ dauraronuka kurumpaarimanaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eeꞌnoko tenang atataiꞌaakoꞌ aaꞌpaama, “Tampara masikung, Daurarong Juꞌnupoong Biikaang!” ");
INSERT INTO nas_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eeꞌnoko boreꞌkoo muraꞌauꞌ banaꞌke tutupaaꞌaama, eeꞌnoko miinge keemparima kinkinaakoꞌ Jiisuuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eeꞌnoko akapeuꞌaakotaaꞌ mononopaꞌ iiraampumaung kiruꞌauꞌ, eeꞌnoko bakaang mononopaꞌ napoꞌ kurumpauꞌ tee-koo. Eeꞌnoko tenkeng-antavauꞌ aaꞌbarataꞌkoo taaka-koo. ");
INSERT INTO nas_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eeꞌnoko beroma taunga naning miring Saimoniꞌ kuneꞌauꞌ tamung poraꞌketa pora tankinuko, eeꞌnoko botoauꞌ Jiisuuꞌ bakaang aaꞌbarataꞌ poruꞌkoo. Aung Saimoniꞌ Sairini-nung, Aleksandaꞌ namainta Ruupasi beuma. ");
INSERT INTO nas_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eeꞌnoko teketa Jiisuuꞌ tavoꞌauꞌ Kolokataꞌ tampaamanooꞌ, miruꞌnooꞌ Makupiꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eeꞌnoko teka teꞌ basiarira, teinge Jiisuuꞌ uaini bankinie pitunisi miring maaraꞌ ninka Jiisuuꞌ avuꞌkoo paaravauꞌ. Eeꞌnoko nai-koo kupiꞌouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eeꞌnoko tenang Jiisuuꞌ aaꞌbarataꞌkoo taakavauꞌ. Baaronanka bakaang biiꞌka-koo tankeeꞌeera kapooꞌ deikooꞌkoong nkoaama, eeꞌ noruꞌaitaaꞌ baie pa aung mononopaꞌ nkavuuꞌnaang? ");
INSERT INTO nas_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eꞌmoo duaaꞌ sirang poioꞌ biꞌauꞌ aaꞌbarataꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Eeꞌnoko daua aung kara tuumpiauꞌnaare daariauꞌ, JUꞌNUPOONG BIIKAANG DAURARONG. ");
INSERT INTO nas_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Eeꞌnoko Jiisuuꞌ ninka nariꞌ niiꞌnaanka mutaaꞌo nkora aaꞌbarataꞌkoo taakavaaretuꞌ, narung tee-koo tampavine-aape, eeꞌnoko narung mareꞌaanavine-aape. ");
INSERT INTO nas_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Eeꞌnoko enang Daari Meekunge minkuvuma aaꞌpuuꞌnaꞌ dupearuꞌ, “Oreng ninka naroꞌka tapoꞌnisi.” ");
INSERT INTO nas_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Eeꞌnoko nantoong teke tankinaakoꞌninge siisiai tankinaakoꞌ, kooviꞌaama. Eeꞌnoko aaꞌpaakoꞌ, “Ei, daꞌ tee pava dootuuꞌnava pankava pesiꞌera napoꞌ doong beenange kaniepeuꞌnung tantaramaung. ");
INSERT INTO nas_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Enang daka teketa aaꞌbarataꞌketa dipiꞌdarara sirarara domaang mooꞌdaravai!” ");
INSERT INTO nas_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Napoꞌ teeꞌ nariꞌ teinge piristiꞌnuka-koo ovontunge, eeꞌnoko boto naunukai akapeuꞌaakoꞌ tee, aaꞌpaama, “Aunge tee nantoong oovuning domaang mooꞌurikooꞌ, teka baka domaang mooꞌkoo makotuaꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aung Kumponinge tero Pakoꞌpariꞌniiꞌ nantoong domampuri tarevuriaing-koong, eeꞌnoko Daurarong Isireeli-nupoong Biikaang, enang aaꞌbarataꞌketa depeto siaravai ooampira masikaꞌantavampiainaꞌ.” Eeꞌnoko napoꞌ tenaanka tee ninka nariꞌ taakavaaretuꞌnaankai Jiisuuꞌ pooreꞌuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Eeꞌnoko duaakiꞌnang mutaanange ookara kansiꞌ tunumparavaruuꞌ bera kamunooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Eeꞌnoko kamunooꞌuioꞌ Jiisuuꞌ aaꞌnaꞌ karoma osinung karai aaꞌpuma, “Eloi, Eloi, Lama Sabakatani.” Kuunooꞌ aaꞌpuitaaꞌ, “Nkaang Kumponing, nkaang Kumponing, ning dake aming-koo siꞌmeing?” ");
INSERT INTO nas_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Eeꞌnoko niiꞌninge nantoonge teke donkonai otorouꞌninge teeꞌ taravaara aaꞌpauꞌ, “Taaraveriai. Eliasi bokuvumaang.” ");
INSERT INTO nas_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eeꞌnoko narung kuaꞌparara kapooꞌ uaini kaaveeriiꞌkoo duꞌmumpura banaꞌkoo daiꞌantavura Jiisuuꞌke musiꞌkoo toong-antavuuꞌ aaꞌpuma, “Iroꞌ ooampiai, Eliasie pora aaꞌbarataꞌketa sing-antavuaing deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Eeꞌnoko Jiisuuꞌ tenang aaꞌnaꞌ bokuma asiꞌnamuꞌ domaang oparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Eeꞌnoko tee baarong pava dootuuꞌnava pankava-koong, meekavaro kuꞌnung, meuꞌ keꞌmeꞌaruꞌ aꞌdeiꞌketa depeto dereꞌarama bera aꞌdoong kainuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eeꞌnoko tenang teie piatooro daakuꞌ tarenarai Jiisuuꞌaape bereꞌarama donkonui teeꞌpuko taaravura eeꞌnoko teeꞌ booꞌparuꞌnaꞌ oovura aaꞌpuuꞌ, “Aung bakei masikaꞌ Kumponing Bauring!” ");
INSERT INTO nas_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Eeꞌnoko niiꞌning manikuꞌke isipoꞌketa ooai otorouꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Teing-koo niiꞌnani Meeriꞌ Maꞌdala-nani, eeꞌnoko niiꞌnani napoꞌ Saalomeꞌ, eeꞌnoko napoꞌ Meeriꞌ nemakara Jeemisi namainta Joosesi beuko. Aing teing manikuꞌ tenang Jiisuuꞌ Kaaleliꞌke otoko siompaama pakuaakoꞌning kapooꞌ apukaꞌparakoꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Teꞌmung Doong Uaanaꞌmung-koo maamunaꞌmung, muung-aapevuioꞌ Doong Uaanaꞌmung dueꞌuko, naning miring Josepaꞌ Arimateaꞌnung tavoꞌaruꞌ. Josepaꞌ tee narung koompaaraꞌnavitu-koong pankaing Kumponing bakaang muuꞌ donkonuko oovuuꞌnaang nempukoꞌnung; ");
INSERT INTO nas_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Avoroaꞌ Pailatiꞌanko bera tanaꞌuuꞌ Jiisuuꞌnung mono nka-koo. ");
INSERT INTO nas_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Eeꞌnoko Pailatiꞌke taaravura Jiisuuꞌ bouꞌnaꞌ aaꞌpuuꞌ, “Teka ee booꞌparing, aiꞌ booꞌparavaꞌ?” Teketa komandaꞌ bokuvura tanaꞌuma aaꞌpuuꞌ, “Jiisuuꞌ ee masikung booꞌparing?” ");
INSERT INTO nas_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Eeꞌnoko Pailatiꞌke komandaꞌnung kara taaravura Jiisuuꞌ masikung bouꞌnaꞌ tauraꞌpuuꞌ Josepaꞌke mono nka-koo. ");
INSERT INTO nas_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Eeꞌnoko Josepaꞌke pankaing baarong kakaara mooꞌuuꞌ Jiisuuꞌnung mono nopaꞌkoo, eeꞌnoko aaꞌbarataꞌketa sing-antavura teie baaronge kakaarai nopaꞌuuꞌ. Eeꞌnoko kuvi dakoꞌdoma boiaꞌkoong nenkeꞌauꞌnung-koo kuung sipura karanaang kapang kaavororiiꞌ kovempura kuꞌnumpuuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Eeꞌnoko Meeriꞌ Maꞌdalanani, Meeriꞌ Joosesi bauko tenaankai tampaꞌ keperuuꞌ uresi Jiisuuꞌ bempauꞌnooꞌ oovuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Doong Uaanaꞌmung tankinuioꞌ Meeriꞌ Maꞌdala-nani, Meeriꞌ Jeemisie bauko, eeꞌnoko Saalomeꞌ duuni tampaꞌ nuuraaꞌ mooꞌauꞌ Jiisuuꞌkoong mono sisiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Eeꞌnoko tero oraꞌka Saandei-naꞌmung kuvi dakoꞌdoma berouꞌ duaaꞌ mmeꞌ pataꞌuko. ");
INSERT INTO nas_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Eeꞌnoko biiꞌka minkuarima aaꞌpaakoꞌ, “Niiꞌ deeꞌma baie kapang korimemuriiꞌnaang kuvi dakoꞌdoma karanaang-eta?” ");
INSERT INTO nas_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Eeꞌnoko beroma kapang teketa kosiꞌarioꞌ ooauꞌ. Tee kapanooꞌ bakei aaꞌnaꞌ pankaing. ");
INSERT INTO nas_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eeꞌnoko tumpariruꞌ kuvi dakoꞌdoma. Eeꞌnoko teka narung naning nemaka ooauꞌ baꞌnamparioꞌ tampavine-aape. Bakaang mononopaꞌ kakaara kurunisi. Eeꞌnoko teing taꞌnimpariruꞌ tee-koo. ");
INSERT INTO nas_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eeꞌnoko teie aaꞌpuruꞌ, “Taꞌniniriaukaꞌ. Diiꞌke Jiisuuꞌ besiꞌerimang Nasaretiꞌnung aaꞌbarataꞌkoo taakavaieeng. Tee tee aꞌ otoaꞌ, tero daaꞌaring. Ooveriai aꞌ bempaieenooꞌ. ");
INSERT INTO nas_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Enang berira aung kara nauereriaing bakaning barevare-nupoong tee ninka Piita, aaꞌperima, ‘Jiisuuꞌ diiꞌkoo uroꞌke bemaang Kaaleliꞌaape. Teka berira ooveriaing baka naururuꞌnaꞌ.’” ");
INSERT INTO nas_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eeꞌnoko kuvi dakoꞌdoma-ita avoroꞌke nopaꞌuri bakoarira kuaꞌpariri berouꞌ. Niiꞌning-ankoi kapooꞌ minkuaavaꞌ avoreaara. ");
INSERT INTO nas_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Damaꞌdue Jiisuuꞌ bouꞌnooꞌketa daaꞌarara tero maatanang doong Saandei-naꞌmung Meeriꞌ Maꞌdalanani-ankoi tutung oroꞌparuꞌ ˜kenaanka-taa maꞌnari bataꞌuruꞌnani. ");
INSERT INTO nas_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Eeꞌnoko tenie bera Jiisuuꞌ baꞌmarang nauvuruꞌ orarunsiarima birompariko. ");
INSERT INTO nas_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Eeꞌnoko tenang tenie aaꞌpuriko, “Jiisuuꞌ daaꞌaring, ninge ooansing,” teing masikaꞌantavaavaꞌ bakaang kara. ");
INSERT INTO nas_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Teketa oovunara-pinaꞌ oroꞌparitaaꞌ bakaning-koonaanka taunga nanureko kuneꞌuretuꞌ osi-eta isipoꞌka. ");
INSERT INTO nas_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tenaankai toroareta napoꞌ nariong barevare-nupoong nauaaretuꞌ, eeꞌnoko teinge masikaꞌantavaareaꞌ beekaang kara. ");
INSERT INTO nas_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Damaꞌke Jiisuuꞌ teing-koo nanaiꞌketa narung-koo basiaruꞌ taamanaako. Eeꞌnoko iikooꞌuruꞌ domamparioꞌ ooauꞌninge minkuaako noruꞌ tupuꞌpaaꞌ otoroi masikaꞌantavaariaruuꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Eeꞌnoko aaꞌpuruꞌ, “Ookara kansiꞌkoo naniriaing nantoong ookara-koo doorenang tampara daankierima. ");
INSERT INTO nas_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Eeꞌnoko naning masikaꞌantavui ntong-koo minkiarara meekaꞌantavarara tee mooꞌaravaing, eeꞌnoko masikaꞌantavuaukaꞌnung Kumponinge kiimata-koo tampuaing. ");
INSERT INTO nas_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ning masikaꞌantamaavaining ninka aing eeꞌ oroꞌ taaꞌniꞌanta tavoꞌaravaing: Maꞌnari bataꞌaariainge nkaang miring-koo, eeꞌnoko oovunung karai kareaavai. ");
INSERT INTO nas_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bane boruꞌ kompaavainge eeꞌnoko bane dopa naiaama teie baikevuriaukaꞌ. Teinge biikaang bireng narung panteꞌaariko siipa-poꞌnupoong taarevoroaing.” ");
INSERT INTO nas_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Damaꞌdue Jiisuuꞌ teing ninka kareaakotaaꞌ baka siramparara paning-aape koinuuꞌ, eeꞌnoko Kumponing-koo tampavine-aape baꞌnamparuꞌ. ");
INSERT INTO nas_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eeꞌnoko bakaning barevare-nupoong avitoitoi nanauꞌ ookara osi-koo daankiarima. Ovoring nariꞌ teing ninka mintoomparuꞌ puring-antavurima biikaang kara taaꞌniꞌanta ninka tavoꞌanta-koo. ");
INSERT INTO nas_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aung ee, pankaing, Teopilasiꞌ; ");
INSERT INTO nas_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mmauꞌ nantoonge teing kapooꞌnanka niiꞌankoi nkoaruꞌning daariauꞌnung taaravaara teinge tutuntoma-ita dutai ooauꞌning-eta teing kara siraꞌnuka deempariko tee-koong minkunaa pareꞌaama naumaarimaing-eta; ");
INSERT INTO nas_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Daariaako ooamiraiꞌnange ninge teeꞌ nariꞌ napoꞌ daꞌ Teopilasiꞌanko daarireromaꞌnaang piamoing, ioꞌ tutung kapooꞌnanka okoraꞌketa, tampaꞌ pukeansi kenkumpamira˜; ");
INSERT INTO nas_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Eeꞌpinaꞌ piamoma, dake tee kara tero nau-antarauꞌning toomosiarioꞌ tampaꞌ noruꞌera masikung-pinaꞌ tasiꞌpeeꞌnaang. Aung tee kara. ");
INSERT INTO nas_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tenang teie dauraronge˜ Eerotiꞌke Judiaꞌnavaro tarevukoꞌnang narung piristiꞌ otokoꞌ miring Sakaraiaꞌ, piristiꞌnanka-koo Abaisiaꞌ bakanavitu-koong. Teie baꞌaang Eeroni baꞌdompenkuri-koonani, miring Elisabetaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Eeꞌnoko tering ookaring koontoꞌdaring Kumponing-koo dutakanooꞌke, ookara boto siompurekoꞌnaring Ovoring bakaang, tuumpi otoreaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Teka tootoꞌ otoreaꞌnaring teni Elisabetaꞌ bisiira deemparako, eeꞌnoko tering ookaring aaꞌnaꞌ pankaring. ");
INSERT INTO nas_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Niiꞌnaꞌmung biikaang batei dootuuꞌ tare-koong makotuioꞌ Sakaraiaꞌ bakanavitu ninka teke dootuuꞌnava pankava-koo piristiꞌnanka biikaang nko-nko nkoaakoꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Eeꞌnoko teeꞌ piristiꞌnanka miruꞌaarikoꞌnaꞌkoong aarumo siompai, teinge Sakaraiaꞌ miruꞌauꞌnung pava dootuuꞌnava pankava-koo meekavaro-koo kuung tumparara boontunamparaaꞌnaang ii tampaꞌ nuuraaꞌ bereng-antavui. ");
INSERT INTO nas_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Eeꞌnoko tenang tee kapooꞌ tampaꞌ nuuraaꞌ paroꞌkoong batei makotuioꞌ teie kuunge paroꞌuko nantoong karikaꞌ teing damaꞌdu-navaro-koo kunsiarikoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eeꞌnoko teie teeꞌ nkovuko Ovoring bakaning-koo narung koosinung˜ tee-ankoi oroꞌparuꞌ batanang boonturoma-koo tampavine-aapei donkonui. ");
INSERT INTO nas_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Eeꞌnoko Sakaraiaꞌke oovura tee domang puraanura avorouꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Teka teie koosinunge aaꞌpuuꞌ tee, “Aroreaukaꞌ Sakaraiaꞌ. Kumponinge dakaang kunsi tee taaravuuꞌnung. Daꞌaange Elisabetaꞌke tee dauring parareruuꞌnaang, eeꞌnoko dake tee miring Jooni tampeaing. ");
INSERT INTO nas_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Eeꞌnoko daꞌ tee doturarama doꞌderoꞌdeꞌdaravaing tee-koo, eeꞌnoko nantoong mmauꞌ dotuariainge pontoꞌarako. ");
INSERT INTO nas_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aiꞌ tee tee naning pankaing deemparavaing Ovoring-koo dutakanooꞌke. Uaini dovang teing nainai purintoꞌ potearioꞌ naivuaukaꞌnunge. Tanuaang Meekung narunge maantoꞌui otoaing keꞌde-koo otoko-ita. ");
INSERT INTO nas_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mmauꞌ Isireeli-nupoong teie tee Ovoring-koo napoꞌ bereꞌantavuriaing tee-koo biikaang Kumponing-koo. ");
INSERT INTO nas_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eeꞌnoko tee tee Ovoring-koo uroꞌkanooꞌke nantoong doorevurima nanuaing Eliasi-pinaꞌ bakaang aarumo eeꞌnoko iriꞌ nariꞌ kompui. Biumaraang domang biurukaaꞌaape bereꞌantavuriiꞌnaang eeꞌnoko teing taarapiikanuka koontoꞌnuka biikaang matau-koo. Teeꞌ nariꞌ nerivuri maamu-antavuriaing nantoong Ovoring poaing-koo.” ");
INSERT INTO nas_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Eeꞌnoko Sakaraiaꞌke koosinung niaꞌuma aaꞌpuuꞌ, “Ninge arekeeꞌ tasiꞌpampeuꞌ tee masikung deekoꞌ? Aiꞌ ning tee pankara eeꞌnoko nnaang teni pankaaꞌke.” ");
INSERT INTO nas_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eeꞌnoko koosinunge makuꞌuma aaꞌpuuꞌ, “Ning tee Kepareliꞌ Kumponing-koo uroꞌkanooꞌke donkonansi oꞌnomaung. Teie eeꞌnarai ning daꞌanko botomuing daꞌ kara-koo tee aung doorenang tampara nauramaang. ");
INSERT INTO nas_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aung ee, ninge nauransinaꞌ masikaꞌ nkoaravaing batei makotuainang, teka daꞌaange dauring parareruuꞌnaang masikaꞌantavearuing-koo Kumponinge daꞌ enang-eta kaꞌduu-antaruioꞌ karearooꞌnaang bera aing nauransining tavoꞌaravainooꞌke basi.” ");
INSERT INTO nas_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eeꞌnoko nantoonge nempai otokoꞌnung Sakaraiaꞌ, paapaaꞌarima anaꞌarioꞌ dootuuꞌnava pankava-koo kuunge. ");
INSERT INTO nas_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eeꞌnoko tenang amakoari siarara teie teing kara-koo makotuaruuꞌnung, teka bireng narunge teeꞌ nariꞌ karavuriko teinge tasiꞌpaara aaꞌpauꞌ, “Kapooꞌke apaikovuioꞌ kara karoarui.” ");
INSERT INTO nas_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Eeꞌnoko tenang bakaang nko-nko nkonang oparioꞌ bakanooꞌ osi duparuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tee-koo damaꞌdue baꞌaang Elisabetaꞌ tootoꞌ nkoaruꞌnung, eeꞌnoko kaara paꞌnokoꞌnaveraaꞌka-koo pava-koo kuung naroꞌke otokoꞌ teni, eeꞌ noruꞌuma: ");
INSERT INTO nas_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aung tee Ovoringe ning-koo nko-antavuing; piaamukotaaꞌ ning teeꞌ nkomuing maiaꞌ tontaꞌmemuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Eeꞌnoko tenang Elisabetaꞌ ˜nau-taa kaara deemparako kempoꞌkuuꞌnooꞌketa tee koosinung Kepareliꞌ napoꞌ Kumponinge osi niiꞌnamono-koo botovuuꞌ Kaaleliꞌnavaro-koonooꞌ miring Nasaretiꞌnamono. ");
INSERT INTO nas_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nani manikuma neraiꞌnaꞌ kuukuma˜anko botovuuꞌnung miring Meeriꞌanko. Aninooꞌ teni miruꞌniiꞌ naning-koo miring Josepaꞌ, Daurarong˜ Deevitaꞌ baꞌdompenkuri-koong-koo. ");
INSERT INTO nas_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eeꞌnoko tee koosinung teni-anko bera aaꞌpuuꞌnung, “Ani ee, daꞌ bakei Kumponinge domange tampaꞌ noruꞌdui otomai. Ovoring tee daꞌ ninka otong. Manikuꞌkoo meuꞌka biraankenani daꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Teeꞌ minkuvuioꞌ teni noruꞌ paapaaꞌarara avitoitoi noruꞌaruꞌnung aaꞌpuma, “Aung kara aremuriiꞌ teeꞌ minku?” ");
INSERT INTO nas_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eeꞌnoko koosinunge aaꞌpuuꞌ teni, “Ee Meeriꞌ, aroreaukaꞌnung, aiꞌ daꞌ teni domange tampaꞌ noruꞌ Kumponinge. ");
INSERT INTO nas_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Daꞌkoo tootoꞌ poontoaraaꞌnaang˜ keꞌde-koo, eeꞌnoko tee dauring donkaani paraveeꞌnaang, eeꞌnoko dake tee miring Jiisuuꞌ tampeaing. ");
INSERT INTO nas_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tee tee eeꞌnung pankaing deempari otoaing eeꞌnoko tee tee Ovoring Deto Basi Bauring tampaavaing. Eeꞌnoko Ovoring Kumponinge tee Daurarong deeng-antavuaing bakaaka Deevitaꞌ paari-antavui. ");
INSERT INTO nas_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eeꞌnoko teie Jeekopiꞌ bakanariong, teing Isireeli-nupoong tanatavuriaing ookutunung batei-koo, eeꞌnoko bakaang muuꞌ tee bakearavaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eeꞌnoko Meeriꞌke koosinung tanaꞌuma aaꞌpuuꞌ, “Tee aung kapooꞌ arekeeꞌ nkoaravaing teeꞌ ning kuukuma oꞌnoko?” ");
INSERT INTO nas_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eeꞌnoko teie koosinunge teni makuꞌuma aaꞌpuuꞌ, “Tee Tanuaang Meekung daꞌkoo poko eeꞌnoko tee purintoꞌ Ovoring Deto Basi bakaange dakaꞌduaing daꞌ. Teeꞌkoo tee eeꞌnung tootoꞌ pontoꞌaravaing meekung tampaavaing, tee Kumponing Bauring. ");
INSERT INTO nas_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ani ee, daꞌmaasie Elisabetaꞌke pankaaꞌke tootoꞌ poontoari˜ otong. Emuꞌ tee kaara ˜nau-taa deemparamang teni-koo bisiira tampaakoꞌnani-koo; ");
INSERT INTO nas_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aiꞌ Kumponinge tee kapooꞌ nkovuarupeuꞌnung otoaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eeꞌnoko Meeriꞌke makuꞌuma aaꞌpuuꞌ, “Aung ee, ning masikaꞌ Ovoring bakanani botovotonaaꞌ. Makosi, teeꞌ minkueinaꞌ nkoaravaing ning-koo.” Eeꞌnoko tenang tenkenuuꞌ tee koosinung teni-ankoita. ");
INSERT INTO nas_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Teketaꞌ pankaroompuaruko Meeriꞌ daaꞌarara nanuuꞌnung iriꞌnarung iuꞌpoꞌnavoraꞌke deto bera Sakaraiaꞌ bakanooꞌ osi Judiaꞌnavaro-koonavuntuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Eeꞌnoko Sakaraiaꞌ bakanavaꞌke tumparara Elisabetaꞌkoo tampara tampuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Eeꞌnoko tenang Elisabetaꞌke tee tampaꞌ tang Meeriꞌketa taaravuko tootoꞌ keꞌde-koo kuunge toꞌdinuuꞌ; ");
INSERT INTO nas_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Eeꞌnoko Elisabetaꞌ Tanuaang Meekunge maantoꞌura duuruꞌkuma aaꞌnaꞌ karoma aaꞌpuuꞌ, “Biraankerarinani daꞌ eeꞌnani manikuꞌkoo dau basinaꞌ, eeꞌnoko napoꞌ tee tootoꞌ dakaang keꞌde-koo biraankearinge. ");
INSERT INTO nas_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Oi bakaꞌe, ning piaaruꞌ arekeeꞌ noruꞌmei beeroꞌmei nkaang Ovoring baukoi? ");
INSERT INTO nas_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ani ee, tenang dake ning-koo tampaꞌ tampeko tee tootoꞌ ning-koo keꞌde-koo dotue toꞌding-antavuing. ");
INSERT INTO nas_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Daꞌ teni biraankenani Kumponing bakaang kara dupearaaꞌnaang masikaꞌantaveinani!” ");
INSERT INTO nas_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Eeꞌnoko Meeriꞌke makuꞌuma aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","“Nkaang domange Ovoring pankaing-antavansi otong, eeꞌnoko nkaang tanuaang doturotuaramaung Kumponing-koo tee ning domaang mooꞌmuuꞌnung-koo, aiꞌ teie tee ning norunoruꞌmuing ning boonko tamung botovotonaaꞌ deemari oꞌnomai; ");
INSERT INTO nas_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bakei, emuꞌketa deto tee ning teni ookarai avatevarange doturotue biraankenani tammaamaaꞌnoainani teie Kumponing Purintoꞌpoꞌnunge kapooꞌ pankaing ning-koo nkovuing-koo; ");
INSERT INTO nas_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Eeꞌnoko miring bakaang meekunge. ");
INSERT INTO nas_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Teie tee piaavurimaung teing bakaang kara dimpaꞌkoo avoreaamaing. ");
INSERT INTO nas_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bakaang iirakuta bakaang birenge nkovuuꞌning-koo siraꞌparioꞌ oroꞌantavumaung, eeꞌnoko purarenkaꞌantavurikooꞌ teing baka daanganuka eeꞌnoko onou-koo pankainanka-pinaꞌ ooarimaing. ");
INSERT INTO nas_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Teie tee dauraronanka iirakutananka kosiꞌurikooꞌ biikaning baꞌnavaꞌnaniꞌ dovang-eta, eeꞌnoko teing boong-koo noruꞌarimaing pankaing-antavurikooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Teing peera-nupoong poo-antavurikooꞌ kapooꞌke tampenge eeꞌnoko kapooꞌ mmauꞌpoꞌnupoong tang torovurikooꞌ kapooꞌ avuriaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Teie tee niiꞌ bakaning bautaranuka pakuvurikooꞌ, niiꞌ Isireeli-nupoong, tee piaa-etanung unaa-anta noruꞌui niikakatauro-koo maraka-antavuuꞌnung, aaꞌning-koo Eebaraamiꞌ eeꞌnoko baurukaaꞌ avatevarang-koo doompeto teeꞌ nariꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Eeꞌnoko Meeriꞌ Elisabetaꞌ ninka nariꞌ otoretuꞌnung teke. Beekuri kaara-pinaꞌ otoreta toroaruꞌ bakanooꞌ osi-aape. ");
INSERT INTO nas_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Emuꞌ tee batei makotuuꞌnung Elisabetaꞌke tootoꞌ para-koong eeꞌnoko tootoꞌ tenie donkaani paravuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Eeꞌnoko teni ninka nariꞌ otorokoꞌninge napoꞌ baꞌmarange taaravauꞌnung Ovoringe piaa pankaing teni-koo oroꞌantavuuꞌnaꞌ eeꞌnoko teing dotuariruꞌnung teni ninka. ");
INSERT INTO nas_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Eeꞌnoko teketa ˜beenang-taa doong tankinuko porouꞌnung tee tootoꞌ dopaꞌ napuꞌaavaꞌnaang; ");
INSERT INTO nas_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Teka bauma Sakaraiaꞌ namirimpaavaꞌnaang tampaako baukoi aaꞌpuuꞌnung, “A, teeꞌ deeaꞌ, tee Jooni tang-koong.” ");
INSERT INTO nas_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Eeꞌnoko teinge aaꞌpauꞌ teni, “Naning daꞌmaikoꞌ teeꞌ boku otoaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Eeꞌnoko teinge bauma birenge tamung niaꞌauꞌnung arekeeꞌ tampuainaꞌ tee bauring. ");
INSERT INTO nas_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Eeꞌnoko teie bentang daari-koonaventoꞌ eentavuruꞌnung eeꞌnoko eeꞌ daarivuuꞌ, “Bakaang miring tee Jooni.” Eeꞌnoko ookara taꞌninauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Eeꞌnoko tenauꞌka Kumponinge kara-koo tauraꞌpuioꞌ karouꞌ Kumponing biraankevuma. ");
INSERT INTO nas_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Eeꞌnoko ookara beeꞌmarang asikovorouꞌ tee-koo eeꞌnoko tee aung kapooꞌ minkuaama nanauꞌnung avitoitoi iuꞌnairu-kooning-koo teka Judiaꞌnavaro-koo. ");
INSERT INTO nas_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Eeꞌnoko Kumponinge teeꞌ oroꞌning taaꞌniꞌantananka Jooni pontoꞌaruꞌnooꞌke nkovuioꞌ ookarai tee aung taaravauꞌninge norunoruꞌaama aaꞌpaakoꞌnung, “Aung tootoꞌ aremuriiꞌ deemparavaing?” ");
INSERT INTO nas_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aung kara tee Sakaraiaꞌke Kumponing daangampui minkuvuuꞌnung Jiisuuꞌ pontoꞌaravaing minkuvuma. Teie Tanuaang Meekunge maantoꞌura karantavuko˜ aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Biraankeampiaing tee Ovoring Kumponing niiꞌ Isireeli-nupoong niikaang, aiꞌ teie niiꞌ beeroꞌmurira enang narung daurarong deto iꞌampuuꞌnaang domamuriaing niiꞌ; ");
INSERT INTO nas_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Eeꞌnoko teie niiꞌ bakaning nantoong boorimurira napoꞌ mooꞌmuriiꞌnaang daiꞌmariri oꞌnorimanooꞌketa. Tee eeꞌnara Kumponing bakaang muuꞌ tarenung, Deevitaꞌ, baꞌdompenkuri-koong pakumuriaing; ");
INSERT INTO nas_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Teeꞌ Kumponinge uripoꞌketa minkuvukoꞌnaꞌ bakaning nakaronuka˜ meekupoong karantavurima˜. ");
INSERT INTO nas_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kumponinge teeꞌ naumuruꞌnung eeꞌnarai dauraronge teꞌnemuriiꞌnaang niikaning kare-nupoong-etaꞌ, teing munteꞌmaarimaing biikaang bireng-eta. ");
INSERT INTO nas_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Eeꞌnoko napoꞌ bakaang piaa-eta unaa-antamuriiꞌnaang maraka-antavuuꞌnaꞌ, tee kara meekung niikakatauro ninka naroong-antavuuꞌnung noruꞌui. ");
INSERT INTO nas_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Tee aaꞌnouꞌnaare: niikaaka Eebaraamiꞌkoo tumpearama˜ maraka-antavuuꞌ taaruꞌmuriiꞌnaang niikaning kare-nupoong biikaang bireng-eta, eeꞌnoko puring-antamuriiꞌnaang amorompiaꞌ tampaꞌ siompampimatoainaꞌ, meekaꞌmariri, koontoꞌnuka oꞌnori tee-ankoi, ookara doong domamariri oꞌnorianing-koo. ");
INSERT INTO nas_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Eeꞌnoko daꞌ tootoꞌ tee Ovoring Deto Basi Bakaang Nakaronara tantaavaing, aiꞌ daꞌ tee urei nanima Ovoring-koo maamu-antaveaing bakaang taung. ");
INSERT INTO nas_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Teing bakaning nantoong teie domampuriaing-koong kara nau-eriaing biikaang orakaꞌnko pankaruntoonge piaavuri tontaꞌantavuriaing nauerima; ");
INSERT INTO nas_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Aaꞌnoaing: Siroong-eta siimpooromurira˜ araka-antamuriiꞌnaang niiꞌ mutaanang-koo oꞌnorimaing booꞌaapenameng-koong uuꞌaaꞌkoo, niikaang peꞌnaaꞌ koong-antamurima tevung mooa-aapenavung-koo.” Teeꞌpuuꞌ Sakaraiaꞌke. ");
INSERT INTO nas_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Eeꞌnoko damaꞌke tee tootoꞌ pankaꞌparara tanuaang purimparuꞌ, eeꞌnoko tee meeꞌboraꞌ sirakamaaꞌkoo otokoꞌ bera tee batei makotuuꞌ Isireeli-nupoong-koo karikaꞌkoo dutakanooꞌ tavoꞌkuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tenang Jooni pontoꞌaruꞌnooꞌketa niiꞌning batei tankinura otoko tee daurarong˜, Siisaꞌ, miring Akastasie botonang sipuuꞌnung ookutuning nantoong tarevurikoꞌning-koo biikaang miring daariariiꞌnaang bakaang buuku-koo. ");
INSERT INTO nas_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aung tee tutunaꞌnamuꞌ miring daari nkoaruꞌnung tenang Sairiniasiꞌ Siiria-nameensiꞌkoo ovoring deempari otokoꞌnang. ");
INSERT INTO nas_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eeꞌnoko ookara tee biikanairu porouꞌnairu siompai nanauꞌnung miring daariariiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Eeꞌnoko Josepaꞌ teeꞌke, Kaaleliꞌkoonooꞌketa, Nasaretiꞌketa, deto Judiaꞌnavaro-koonooꞌaape nanuuꞌnunge Beeteleemaꞌ, teꞌ Deevitaꞌ bakanavuntuꞌ deemparako, aiꞌ tee tee Deevitaꞌ baurukaaꞌ bakanamuiaang-koong. ");
INSERT INTO nas_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tee teni ninka Meeriꞌ ninka baꞌaang ninka nariꞌ nanuretuꞌnung miring daariareeꞌnaang. Teni tee tootoꞌpoꞌnani. ");
INSERT INTO nas_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Eeꞌnoko teke otoreko tootoꞌ pontoꞌkoong bateinang makotuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Eeꞌnoko tenie tootoꞌ tutunaꞌnung paravuuꞌ donkaani, eeꞌnoko baaronge korovui daiꞌura kauꞌ karenaumonanka biikanava-koo otoroi karaasiꞌ maaꞌaakoꞌnavaro-koo bempuuꞌ, poꞌnupoꞌnuka biikanavaꞌkoo doona otoaruioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Eeꞌnoko teke Beeteleemaꞌketa dueꞌke niiꞌning sipisipiꞌ tanatanuka otorokoꞌ muunga biikaning sipisipiꞌ binaaꞌkoo tanatavaarima. ");
INSERT INTO nas_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Eeꞌnoko narung koosinung Ovoring bakaang teing-ankoi tavoꞌaruꞌ, eeꞌnoko Ovoring bakaang meenasi teing korovuri arakavaruꞌ eeꞌnoko tenang avoroꞌ pankainge maantoꞌuruꞌ. ");
INSERT INTO nas_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Eeꞌnoko koosinunge aaꞌpuruꞌ, “Aroreriaukaꞌ, ninge doorenang tampara poꞌantarerompimang doturotu-koong diiꞌ ookara nantoong-koo basiaravaing. ");
INSERT INTO nas_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aaꞌnoing eꞌmung diiꞌankoi teke Deevitaꞌ bakanavuntuꞌkoo narung Domang-anta pontoꞌaring, tee Ovoring Pakoꞌpariꞌniiꞌ, Kumponinge teroita maraka-antarurioꞌ nemperimaung. ");
INSERT INTO nas_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Taaꞌniꞌanta eeꞌ ooverira masikung tasiꞌperiaing: Narung nerakauꞌ baaronge koroari daiꞌniiꞌ nakoꞌbo-koo bempari otoko ooveriiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Eeꞌnoko namuꞌke taꞌninaꞌ, tee ninka koosinung ninka paning-nupoong-koonavitu karikaꞌ nariꞌ tapoꞌeuꞌ Kumponing daangampaama eeꞌ minkuaama, ");
INSERT INTO nas_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kumponing paning-koo siroong otomaung daangampampimaang, aiꞌ mooa tee kansiꞌkoo poing nantoong tampaꞌ nkovuriko arooꞌarimaing-koo.” ");
INSERT INTO nas_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tenang koosinunanka paning-aape toroaririoꞌ sipisipiꞌ tanatanukai aaꞌpauꞌ biiꞌka kareaama, “Aiaꞌ, Beeteleemaꞌ duꞌmarira, ooampiai tee kapooꞌ nkoaring Ovoringe nau-antamuring niiꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eeꞌnoko teing iriꞌnarung berora ooaaruꞌ teing, aaꞌnoko Meeriꞌ, Josepaꞌ eeꞌnoko tee tootoꞌ nakoꞌbo-koo bempari otoko. ");
INSERT INTO nas_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Eeꞌnoko tenang teinge ooaara tee siraꞌpauꞌ tee minkunaa tootoꞌ minkuari otoing koosinunge nauvuruꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Eeꞌnoko ookara taaravauꞌninge tee minkunaa avutevuꞌai noruꞌauꞌ sipisipiꞌ tanatanukai teing nauaarioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Teka Meeriꞌke teing aing kapooꞌnanka kinkompura bakaang domang-koo norunoruꞌukoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eeꞌnoko teing sipisipiꞌ tanatanuka toroariruꞌ biikanairu-koo Kumponing daangampaama, bakaang meenasi siraꞌpai kapooꞌnanka teinge taaravaama ooauꞌning-koo teeꞌ eeꞌnaꞌ teie koosinunge nauvuruꞌnaꞌ teing. ");
INSERT INTO nas_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Eeꞌnoko Jiisuuꞌ pontoꞌaruꞌnaꞌmung-eta ˜beenang-taa doong deemparako tenang dopaꞌ napuꞌauꞌnang tee, miring Jiisuuꞌ tampauꞌ, tee eeꞌnara koosinunge tampuuꞌnung tee miring tenang mmeꞌ poontoaravaruko˜ keꞌde-koo. ");
INSERT INTO nas_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Eeꞌnoko Meeriꞌke tootoꞌ paravuuꞌnooꞌketa meekava-koo beꞌkoo untuꞌanta-koong batei makotuioꞌ, teeꞌ Moosesi bakaang botoi tampui otoinaꞌ, teringe Jiisuuꞌ tavoꞌuretuꞌ Jerusalemaꞌaape Ovoring oko-antavureeꞌnaang teie botoi napoꞌ minkuvui otoinaꞌ aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","“Ookara toireꞌ donkaang tutung pontoꞌariaining Ovoring bakaning meekupoong tang-koong.” ");
INSERT INTO nas_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eeꞌnoko untuꞌanta-koo boontunampariiꞌnaang berouꞌ botoi Ovoring bakaange tampui otoinaꞌ aaꞌpuma, “Urareng-koo˜ mantaꞌnisining ninka boonturariaing niiꞌnooꞌ niiꞌnamuriiꞌ kuukuuꞌkoo kooꞌnening keura.” ");
INSERT INTO nas_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tenang teke Jerusalemaꞌ naning narung otokoꞌnung bakaang miring tee Simioniꞌ. Aung tee naning koontoꞌ Kumponing-koo meeꞌduꞌpiari otokoꞌnung. Nempui besiꞌukoꞌnung Isireeli-koong Dun-sirunsinara˜ tavoꞌaravaing, eeꞌnoko Tanuaang Meekung tee tee-koo otokoꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Eeꞌnoko Tanuaang Meekunge tee tee-koo siraꞌpuuꞌ tee booaukaꞌnung teie mmeꞌ oovuaꞌ tee Domang-anta Ovoringe tero Pakoꞌpariꞌuuꞌnung˜. ");
INSERT INTO nas_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eeꞌnoko Tanuaang Meekunge nau-antavuioꞌ dootuuꞌnava pankava-koo kuung tumparuꞌ; ");
INSERT INTO nas_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Eeꞌnoko tenang tee tootoꞌ Jiisuuꞌ baumararinge kuung poꞌantavuretuꞌnang botoi minkuvumanaꞌ aarumo nkovureeꞌnaang, teie pora birenge nkavura biraankevuma Kumponing-koo aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","“Ovoring ee, emuꞌ tee ning dakaang botovotonaaꞌ mooa ninka bakemari moompaing makosi, teeꞌ temuꞌ marakarari naumeuꞌnaꞌ, aiꞌ ninge tee emuꞌ ooansing nkaang dutai Tee Domamuriaing dake maamu-antaveuꞌnung nantoong-koo dutakanooꞌka. ");
INSERT INTO nas_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Teie Arakai teing Isireeli-eta taapoꞌnupoong kapooꞌ masikung biiꞌka noruꞌaavarukoꞌnung sirapoꞌevuriaing eeꞌnoko Isireeli-nupoong meenasi kong-antavuriai.” ");
INSERT INTO nas_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Eeꞌnoko Jiisuuꞌ baumararing taꞌninuretuꞌ teing-koo kapooꞌnanka Jiisuuꞌkoo minkuvuuꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Eeꞌnoko Simioniꞌke tekang biraankevurira Meeriꞌ nauvuma aaꞌpuuꞌ teni Jiisuuꞌ bauko, “Ani ee, aung tootoꞌ tee miruꞌari otoing mmauꞌ nantoong Isireeli-nupoong-kooning aaꞌnoaing niiꞌning duaꞌantavuriai eeꞌnoko napoꞌ niiꞌning daaꞌantavuriai; ");
INSERT INTO nas_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Eeꞌnoko napoꞌ tee tee taaꞌniꞌanta deempari otooꞌnaang miruꞌari otong nantoonge tompimpaavaing, eeꞌnoko teeꞌ tompimpaako nantoong mmauꞌ biikaang domang-eta onounanka siraꞌparavai. Eeꞌnoko daꞌ bainatu-pinaꞌ orarunsie domang tooꞌduainanie.” ");
INSERT INTO nas_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Eeꞌnoko napoꞌ niiꞌnani manikuma nakaronani teke otokoꞌ miring Aanaꞌ, Panuele baurang, Aasia bakanamuiaang-koonani. Teni baꞌung ninka mareꞌ ˜kemareꞌka-taa otoretuꞌnani nampeesiaruꞌnooꞌketa, eeꞌnoko emuꞌ beenaumo kivora-ita karemareu ookara mareꞌ bakaning; ");
INSERT INTO nas_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Eeꞌnoko ani teni pava dootuuꞌnava pankava-ita tokoo bearukoꞌnani; teke otoi unkumoarama kunsiarama dootuuꞌarakoꞌnani muunga eeꞌnoko doonga. ");
INSERT INTO nas_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tenang tee-koo batei-koo pora Kumponing tampara tampuuꞌnung eeꞌnoko tee tootoꞌkoo nantoong minkuvuruꞌ teing Tee Poaing nempai besiꞌaakoꞌning Jerusalemaꞌnupoong daiꞌariri otoromanooꞌketa napoꞌ mooꞌuriaing Ovoringe maraka-antavuruꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Eeꞌnoko tenang ookara kapooꞌnanka nkovureta botoi Ovoring bakaange minkuvui otoinaꞌ tekang toroariruꞌnung Kaaleliꞌnavaro-aape bera biikanooꞌ osi Nasaretiꞌ tavoꞌariruꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eeꞌnoko tootoꞌ pankaꞌparara purimparuꞌnung mataue maantoꞌniiꞌ, eeꞌnoko Kumponinge tampaꞌ oovui otokoꞌ biraankevui. ");
INSERT INTO nas_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Emuꞌ tee, ookara mareꞌkoo tee Paroro Baariꞌkoong˜ nkoaakoꞌnang baumararing tee Jerusalemaꞌaape berekoꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Eeꞌnoko tenang tee kivora-ita kemareꞌka mareꞌ makotuuꞌnang tee nariꞌ berouꞌ baumararing ninka, tering nanurekoꞌnaꞌ nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tenang paroro bakearako nantoong toroariko tee nemaka Jiisuuꞌ teke otouꞌnung Jerusalemaꞌke. Baumararinge tee noruꞌureaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Teꞌmung nanaama eeꞌ noruꞌurekoꞌ, niiꞌning ninka poromang. Eeꞌnoko taunga muumpuruꞌnooꞌka besiꞌuretuꞌ beeꞌmarang-ankoa eeꞌnoko ookara teringe noruꞌaaresining-ankoa. ");
INSERT INTO nas_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Teka oovurearuta toroaretuꞌ Jerusalemaꞌaape tee besiꞌureeꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Teketa beenang doong tankinuko daaꞌuretuꞌ teka dootuuꞌnava pankava-koo boto naunuka-koo meuꞌ baꞌnanuioꞌ taaravuritaaꞌ otoko nianiaꞌnanka niaꞌurima. ");
INSERT INTO nas_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eeꞌnoko teing taaravauꞌning bakei asikovorouꞌ tee-koo bakaang norukasiꞌkoo eeꞌnoko makumakuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eeꞌnoko tee baumararinge oovureta taꞌninuretuꞌ, eeꞌnoko baukoi aaꞌpuuꞌ, “Nnuring, arekeeꞌkoo dake neeꞌ teeꞌ nkomeresi? Aung ee, neeꞌdaring poreꞌmoresing daꞌ besiꞌkoo noruꞌ mankiꞌmoresitaaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eeꞌnoko teie aaꞌpuretuꞌ, “Ning aming-koo besiꞌkoo poreꞌdoremang? Deeꞌke ee noruꞌereaꞌ tee ning Mmaꞌ bakanava-koo oꞌnoaing?” ");
INSERT INTO nas_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Teeꞌpuresioꞌ teringe tasiꞌpurearuuꞌ bakaang kara. ");
INSERT INTO nas_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eeꞌnoko teie tee tering siompuresi tekang Nasaretiꞌaape doonko berouꞌ, eeꞌnoko otoi osie kara siompukoꞌ tering beekaang. Eeꞌnoko baukoi aing ookara kapooꞌnanka domang-koo kinkompuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Eeꞌnoko Jiisuuꞌ pankaꞌparuꞌnung matau ninka nariꞌ. Kumponinge eeꞌnoko nantoonge deto tampaꞌ nariꞌ ooaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Emuꞌ tee Jooni, Sakaraiaꞌ bauring, meeꞌboraꞌ sirakamaaꞌkoo nempari otoko, tenang Kumponinge kara nauvuuꞌ nantoong nauvuriiꞌnaang. Teeꞌ nkoaruꞌnung tenang teie Taibiriasi ookara kansiꞌnanka-koo ovorimpari miring Siisaꞌ nkavuuꞌnooꞌketa kivora-ita paꞌnokoꞌ mareꞌ deemparuꞌnang. Tenang aing aaꞌning ovoꞌmaꞌnuka deempariri otorokoꞌnang: Poontiasi Pailatiꞌ Judiaꞌnavaro-koo, eeꞌnoko napoꞌ Eerotiꞌ Kaaleliꞌnavaro-koo, eeꞌnoko baaraꞌmaꞌnung Pilipiꞌ aaꞌning-koo Iturea, eeꞌnoko Takonisi, eeꞌnoko Laisaniasiꞌ Abilini-navaro-koo. ");
INSERT INTO nas_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Eeꞌnoko Aanasi naanka Kaiapasi piristiꞌ deto basira otorekoꞌnang; ");
INSERT INTO nas_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tenang eeꞌnang Kumponinge bakaang kara siraꞌkoo botovuioꞌ Jooni ookutunairue Jooꞌdani-nari-aapei nanuuꞌnung eeꞌ daankiarama, “Bereꞌdarira ntong-koo minkirarira meekaꞌantarariaing eeꞌnoko Kumponinge diikaang orakaꞌnko tontaꞌderuriai.” ");
INSERT INTO nas_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Daari Meekung-koo tee nakaronara Aisaiaꞌ bakaang karapoꞌnaneꞌkoo urikamuꞌ minkuvuuꞌnaꞌ tee, aaꞌpuma, “Aurong narung naning-koong meeꞌboraꞌ sirakamaaꞌkoo bokuma aaꞌpumaang, ‘Maamu-antaveriaing tee taung Ovoring bakaang. Koompevuriai poainavung. ");
INSERT INTO nas_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ookara biriꞌnairu maantoꞌantaveriai, Eeꞌnoko ookara iuꞌnanka eeꞌnoko iꞌnunairu tanoomperiai. Aveꞌaveꞌnairu taung-koo koomperiai, Eeꞌnoko ariiruteriirunairu naroomperiai. ");
INSERT INTO nas_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eeꞌnoko ookara nantoonge ooaavaing tee Domang-anta Kumponing-etaing.’” ");
INSERT INTO nas_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Karinga nantoong porokoꞌnung Jooni-koo ntong-koo minkivurima meekaꞌantavuriiꞌnaang. Eeꞌnoko aaꞌpurikoꞌ, “Diiꞌ borukoporonuka, baie aaꞌduri diiꞌ tamung ntong-koo minkirarira meekaꞌantararima kooꞌdariaining Kumponing bakaang iira tavoꞌkuaing-eta? ");
INSERT INTO nas_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Masikaꞌ bereꞌdariaing tee-koo sinang oroꞌparavainaꞌ. Tamung diiꞌka aaꞌperiaukaꞌ, ‘Eebaraamiꞌ tee niiꞌke niuma otong,’ aiꞌ masikung ninge naurampimang Kumponinge tee Eebaraamiꞌ baurukaaꞌ aing-eta kapananka-ita nkovuripeuꞌ diiꞌ pariꞌanta-koo, domang ivekaꞌdariko deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Teriꞌ marekenariꞌ teriꞌ maamuari otong koiꞌkoo okoraꞌ. Diiꞌ teing koiꞌ makosinuka. Diiꞌkoo ookara sinang tampara nkaveriaukaꞌning tee nokiraarira ntaꞌkoo duaꞌdaariaining.” ");
INSERT INTO nas_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eeꞌnoko karikaꞌke niaꞌauꞌnung, aaꞌpaama, “Enang aming nkoampiiꞌnaang niiꞌke bereꞌmaririnooꞌketa?” ");
INSERT INTO nas_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eeꞌnoko teie makuꞌevurima aaꞌpuuꞌ, “Baa tee naning mononopaꞌ kenaaꞌka otoꞌevuinge niiꞌnung otoꞌevuaung niiꞌnaaꞌ avuaing. Baa tee naning taamang otoꞌevuinge teeꞌ nariꞌ nkovuai.” ");
INSERT INTO nas_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Napoꞌ taakisi nkanuka ntong-koo minkiarira meekaꞌantavariiꞌnaang porora aaꞌpauꞌ, “Nau-anta, niiꞌke napoꞌ aming nkoampiiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Eeꞌnoko teie aaꞌpuruꞌ, “Miruꞌniiꞌnooꞌketa bonoꞌ divuꞌeri niiꞌnooꞌ nkaveriaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Napoꞌ piatooronukai˜ niaꞌauꞌ, “Niiꞌke eeꞌninge napoꞌ, arekeeꞌ nkoampiiꞌnaang?” Eeꞌnoko teie aaꞌpuruꞌ teing, “Naning tamung taverima, niiꞌnooꞌ daang tuumpierima, bakaang kapooꞌ bakiaaꞌeriaukaꞌ. Diikaning mooꞌkoo araarimaing-koo doturarimatoai.” ");
INSERT INTO nas_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nantoonge Tee Domang-anta Kumponinge tero Pakoꞌpariꞌuuꞌnung˜ bakaang bateinang tavoꞌaravaing-koong basiarioꞌ noruꞌaama biikaang domange Jooni-koo niaꞌkaama aaꞌpaakoꞌ, “Aunge pa tee nempampimaung.” ");
INSERT INTO nas_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Teeꞌpaako makuꞌurima aaꞌpuuꞌnung, “Ning aaꞌ tee Domang-anta nemperimaung deeaꞌ, tamung ntong-koo minkirampima meekaꞌantarampimaang, nka tee ning aaꞌnaꞌ apooꞌmui otoing iirakuta mmeꞌ pomaang, doonge-taara˜. Tee eeꞌnara poko aaꞌnaꞌ tampaꞌ taaraveriai, aiꞌ teie tee meekaꞌantaruriaing diiꞌ Tanuaang Meekung ninka eeꞌnoko ntaꞌ ninka. ");
INSERT INTO nas_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Teie, tee simpeꞌnkoi˜ teing makosinuka bakaang muuꞌkoo kuunga onkeonkeꞌuriaing, eeꞌnoko teing makosinuka deeaing tee-koo ntaꞌkoo siriꞌpaaꞌkoo tai-antavuriaing.” ");
INSERT INTO nas_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Teeꞌ nariꞌ amutemuriiꞌ tautaunanka ninka tampara doorenang daankivukoꞌnung teing-koo nantoong-koo. ");
INSERT INTO nas_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Teka Joonie tee ovoꞌmaꞌ Eerotiꞌ turampuuꞌ baaraꞌmaꞌnung baꞌaang Erodiasiꞌ nampuuꞌnung-koo eeꞌnoko niiꞌning kapooꞌ oreng mmauꞌ nkovuuꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Eeꞌnoko Eerotiꞌke orakaꞌnko nkovuma Jooni kiimata-koo sipuuꞌ bakaning orakaꞌ nkonanka-koo dau pauꞌui. ");
INSERT INTO nas_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Teka Jooni mmeꞌ kiimatavaravaꞌ nantoong ntong-koo minkivurima meekaꞌantavurikoꞌnang Jiisuuꞌ tenang teing ninka nariꞌ ntong-koo minkivura meekaꞌantavuuꞌnunge. Eeꞌnoko tee Jiisuuꞌ kunsiarako paning daateꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Eeꞌnoko Tanuaang Meekung tee-koo siaruꞌ kuukuuꞌnaumpui, eeꞌnoko tee-koo dau otoko kara auromparuꞌ paning-eta aaꞌpuma, “Daꞌ tee nnuring ninge piaaramaung. Ning daꞌkoo aaꞌnaꞌ dotumaramaung.” ");
INSERT INTO nas_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jiisuuꞌke tee bakaang nko-nko mareꞌ beenaumo kivora-pinaꞌ deemparama tutumpuuꞌnung. Nantoonge Josepaꞌ bauring-pinaꞌ noruꞌaakoꞌnung. Tee Josepaꞌ tee Eelaiꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Tee Eelaiꞌ tee Maatataꞌ bauring. Tee Maatataꞌ tee Liivaiꞌ bauring. Tee Liivaiꞌ tee Melekaiꞌ bauring. Tee Melekaiꞌ tee Janaiꞌ bauring. Tee Janaiꞌ tee Josepaꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Tee Josepaꞌ tee Matataiasiꞌ bauring. Tee Matataiasiꞌ tee Eimos bauring. Tee Eimos tee Neeamu bauring. Tee Neeamu tee Eslaiꞌ bauring. Tee Eslaiꞌ tee Naakaiꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Tee Naakaiꞌ tee Meeataꞌ bauring. Tee Meeataꞌ tee Matataiasiꞌ bauring. Tee Matataiasiꞌ tee Siemen bauring. Tee Siemen tee Josekeꞌ bauring. Tee Josekeꞌ tee Jodaꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Tee Jodaꞌ tee Joanang bauring. Tee Joanang tee Reesaꞌ bauring. Tee Reesaꞌ tee Serababele bauring. Tee Serababele tee Sieluteala bauring. Tee Sieluteala tee Neeraiꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Tee Neeraiꞌ tee Melekaiꞌ bauring. Tee Melekaiꞌ tee Eidaiꞌ bauring. Tee Eidaiꞌ tee Kosang bauring. Tee Kosang tee Elemadang bauring. Tee Elemadang tee Eere bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Tee Eere tee Josiuaꞌ bauring. Tee Josiuaꞌ tee Eliesaꞌ bauring. Tee Eliesaꞌ tee Joring bauring. Tee Joring tee Maatataꞌ bauring. Tee Maatataꞌ tee Liivaiꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Tee Liivaiꞌ tee Simioniꞌ bauring. Tee Simioniꞌ tee Juda bauring. Tee Juda tee Josepaꞌ bauring. Tee Josepaꞌ tee Jonang bauring. Tee Jonang tee Elaiakim bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Tee Elaiakim tee Meliaꞌ bauring. Tee Meliaꞌ tee Meenaꞌ bauring. Tee Meenaꞌ tee Matataꞌ bauring. Tee Matataꞌ tee Neetani bauring. Tee Neetani tee Deevitaꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tee Deevitaꞌ tee Jeeseꞌ bauring. Tee Jeeseꞌ tee Oobeteꞌ bauring. Tee Oobeteꞌ tee Booasi bauring. Tee Booasi tee Salamong bauring. Tee Salamong tee Naasoni bauring. Tee Naasoni tee Aminadapiꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Tee Aminadapiꞌ tee Araminuꞌ bauring. Tee Araminuꞌ tee Aaraniꞌ bauring. Tee Aaraniꞌ tee Eesirong bauring. Tee Eesirong tee Peeresi bauring. Tee Peeresi tee Juda bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Tee Juda tee Jeekopiꞌ bauring. Tee Jeekopiꞌ tee Aisakeꞌ bauring. Tee Aisakeꞌ tee Eebaraamiꞌ bauring. Tee Eebaraamiꞌ tee Teeraꞌ bauring. Tee Teeraꞌ tee Neeoo bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Tee Neeoo tee Serakaꞌ bauring. Tee Serakaꞌ tee Reuꞌ bauring. Tee Reuꞌ tee Pelekeꞌ bauring. Tee Pelekeꞌ tee Iibereꞌ bauring. Tee Iibereꞌ tee Siilaꞌ bauring ");
INSERT INTO nas_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Tee Siilaꞌ tee Keenani bauring. Tee Keenani tee Apasataꞌ bauring. Tee Apasataꞌ tee Siemiꞌ bauring. Tee Siemiꞌ tee Nooaꞌ bauring. Tee Nooaꞌ tee Leemekiꞌ bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Tee Leemekiꞌ tee Metuselaꞌ bauring. Tee Metuselaꞌ tee Iinoke bauring. Tee Iinoke tee Jereteꞌ bauring. Tee Jereteꞌ tee Maaleliꞌ bauring. Tee Maaleliꞌ tee Kenan bauring. ");
INSERT INTO nas_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Tee Kenan tee Iinosiꞌ bauring. Tee Iinosiꞌ tee Set bauring. Tee Set tee Aadama bauring. Tee Aadama tee Kumponing bauring. ");
INSERT INTO nas_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Eeꞌnoko Jiisuuꞌ Tanuaang Meekunge maantoꞌura toroaruꞌnung teketa Jooꞌdani-nari-eta, eeꞌnoko Tanuaang Meekunge beꞌantavuuꞌ meeꞌboraꞌ sirakamaaꞌkoo karenaumo kivora doonanka-koo Sietaniꞌke dauaꞌkoo; ");
INSERT INTO nas_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Eeꞌnoko teie tee kapooꞌ naivuaꞌ teing doong-koo. Eeꞌnoko teing doong oparuꞌnooꞌke tee peeravouꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Eeꞌnoko Sietaniꞌke Jiisuuꞌ duaꞌanta-koo paaravuma aaꞌpuuꞌ tee, “Daꞌ Kumponing bauring deekoꞌ aung kapang naueko taamang deemparavaing.” ");
INSERT INTO nas_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌnung tee, “A, tee Daari Meekung-koo eeꞌ daariari otong, ‘Naning taamang narunge domampari otoaung, teka ookara kara Kumponing-etaning siompui domampari otomaung.’” ");
INSERT INTO nas_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eeꞌnoko Sietaniꞌke deto koing-antavura okiꞌnung batei-koo oo-antavuuꞌ ookara muuꞌnanka kansiꞌkooning. ");
INSERT INTO nas_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Eeꞌnoko aaꞌpuuꞌ tee, “Ninge tee daꞌ aing ookara tare-koo purintoꞌ arompaing biikaning meenasi ninka, aiꞌ aing ning okomui otoining eeꞌnoko ninge tee avomaung baa ninge pia-antavamaung avuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Teka dake ning dootuuꞌmei dei aing ookara oko-antarampeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌnung, “A, Daari Meekung-koo eeꞌ daariari otong: ‘Diiꞌke Ovoring diikaang Kumponing narung dootuuꞌeriaing, eeꞌnoko niiꞌnung siomperiaꞌ otoriai.’” ");
INSERT INTO nas_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Eeꞌnoko Sietaniꞌke Jerusalemaꞌaape beꞌantavuuꞌ tee Jiisuuꞌ, eeꞌnoko aꞌdeiꞌ pava dootuuꞌnava pankava-koo miiraka-koo panteꞌantavura aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Daꞌ Kumponing bauring deekoꞌ anke doonko toꞌdiꞌdaravaing, tampaꞌ duaꞌdarako masikaꞌantaraavainaꞌ, aiꞌ Daari Meekung-koo eeꞌ daariari otong, ");
INSERT INTO nas_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Teie bakaning koosinunanka botovuriaing daꞌ neeꞌdaavaꞌnaang. Teinge biikaning birenge deto doontaavaing, kapang-koo kauꞌ naapuraraꞌneeng-koo.’” ");
INSERT INTO nas_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “A, teka napoꞌ Daari Meekunge aaꞌmurimaung, ‘Diiꞌke tee Ovoring diikaang Kumponing parapaara-koo siperiaukaꞌ.’” ");
INSERT INTO nas_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Eeꞌnoko tenang Sietaniꞌke paaravuma bakevura sipuuꞌ napoꞌ niiꞌnang makosivuainang nempuitaaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Eeꞌnoko Jiisuuꞌ meeꞌboraꞌ sirakamaaꞌketa toroaruꞌnung tee ninka purintoꞌ Tanuaang Meekung-etaing ninka Kaaleliꞌnameng-aape; ");
INSERT INTO nas_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Teie Jiisuuꞌke nau-antavurikoꞌnung biikaning pava dootuuꞌnanka-koo biivimpaako, eeꞌnoko tee-koong doorenang avitoitoi nanuꞌantavauꞌ tevaro-koo; ");
INSERT INTO nas_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Eeꞌnoko tee Nasaretiꞌ pouꞌnung teꞌ tee pankaꞌantavuretuꞌnooꞌ. Eeꞌnoko biikaang pava dootuuꞌnava-koo tumparuꞌ bakaang aarumo Doong Uaanaꞌmung-koong siompuitaaꞌ; ");
INSERT INTO nas_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Eeꞌnoko deeruvuuꞌnaang donkonuioꞌ avauꞌnung buukunaneꞌ temuꞌnung Kumponing-etaing nakaronarai Aisaiaꞌke daarivuuꞌnaneꞌ. Teie teneꞌ bereꞌura koontoꞌ piavouꞌnooꞌ oovura deeruvuuꞌ eeꞌ daariari otoinooꞌ, ");
INSERT INTO nas_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tee Tanuaang Meekung Ovoring bakaang ning-koo otong aiꞌ ning tee pakoꞌpariꞌmuuꞌnung teie daankiamaꞌnaang doorenang tampara ataꞌoiꞌnuka-koo. Teie botomuuꞌnung ning nauaranko daiꞌnisinanka dipiꞌariiꞌnaang eeꞌnoko kaputuꞌnuka ookaavaꞌnaang; ");
INSERT INTO nas_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Napoꞌ botomuuꞌnunge unaa-antavaramaꞌnaang teing booniꞌuri otoromaing eeꞌnoko nauaramaꞌnaang enanung batei Ovoringe miruꞌuuꞌnung piaavurira domampuriaing-koo teing.” ");
INSERT INTO nas_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Eeꞌnoko teie teneꞌ avoꞌura avuuꞌ napoꞌ tee naning dootuuꞌ nko-koo pakupakunung eeꞌnoko nau-anta nko-koo neriarama doonko baꞌnamparuꞌ nantoonge ookarai teke pava dootuuꞌkoo otorokoꞌninge naapu narung ooai otoko; ");
INSERT INTO nas_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Eeꞌnoko tee kara tutumpuma aaꞌpuuꞌ, “Eꞌmung tee dupearing taaraverioꞌ tee Daari Meekunge minkuvuuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Eeꞌnoko teing ookarai tampaꞌ tampauꞌnung tee-koo, eeꞌnoko taꞌninauꞌ kara maneenaꞌ karouꞌnung-koo. Eeꞌnoko teinge aaꞌpauꞌ, “Nko aung baie, Josepaꞌ bauring ee deeaꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eeꞌnoko teie aaꞌpuruꞌ, “Masikaꞌ noruꞌansing, anaare karanaare mirumiruꞌnaare napoꞌ ning naumeriiꞌnaang diiꞌke, eeꞌ minkunaare, ‘Nankaiꞌ, daꞌ daka taare-antararavai. Teing kapooꞌ Kapaneumeꞌnavuntuꞌkoo nkoveuꞌning taaravampiruꞌning anke dakanooꞌke napoꞌ nkoveaing masikung deekoꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Masikung naurampimang, naning Kumponing-etaing nakaronara bakanooꞌka tee arooꞌaavaung. ");
INSERT INTO nas_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Masikaꞌ aaꞌnouꞌnung naurampimang: Mmauꞌ naaroonkunanka otorokoꞌ Isireeli-nameensiꞌkoo tenang tee temuꞌnung Kumponing-etaing nakaronara Eliasi otokoꞌnang peera pankaing nkoaruꞌ aaꞌnang, paning pankaroong avoꞌari otoko mareꞌ beemareu-eta ˜nau-taa kaara-koo. ");
INSERT INTO nas_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eeꞌnoko teing-koo naning-anko Kumponinge botovuaꞌ Eliasi, teka naaro Juꞌdeeaing-koonani-anko naroꞌ botovuuꞌ paku-koo arooꞌuainani noruꞌui Sarepatiꞌnavuntuꞌkoo, Saidoniꞌkoonooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eeꞌnoko napoꞌ tenang tee Kumponing-etaing nakaronara Elaisaꞌ bakanang aaꞌnouꞌ, mmauꞌ oramuuꞌpoꞌnupoong otorokoꞌ Isireeli-nameensiꞌkoo, eeꞌnoko teing-koo niiꞌnarai Elaisaꞌ arooꞌuaꞌ kui-koo, teka Juꞌdeeaing-koo narung deekoꞌ, Neeamani, Siiria-nameensiꞌkoong, Elaisaꞌ arooꞌuioꞌ kuiaruꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tenang teinge teeꞌ taaravaara ookara pava dootuuꞌkoo otorokoꞌning aaꞌnaꞌ iiravorouꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Eeꞌnoko daaꞌarira kompai osi-eta tuuꞌaama bataꞌauꞌnung bera mare-koo auremping osi siroong kaniauꞌnooꞌketa dueꞌ, teke doonko kosiꞌaavaꞌnaang boreꞌke uroioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Teka teketaꞌ teing-koo meuꞌke beentevuri tankinura tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Eeꞌnoko Jiisuuꞌ Kapaneumeꞌnavuntuꞌaape danto beuꞌ, osi pankaing Kaaleliꞌnameng-koonooꞌ; ");
INSERT INTO nas_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Eeꞌnoko teke otoi Doong Uaanaꞌmung kara nau-antavuriko aaꞌnaꞌ taꞌninauꞌ tee-koo bakaang nau-anta-koo, kara bakaang purintoꞌ deemparioꞌ; ");
INSERT INTO nas_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eeꞌnoko teke pava dootuuꞌkoo naning narung otokoꞌnung maꞌnaang orara kurumaaꞌaruꞌnung. Eeꞌnoko aaꞌnaꞌ uiarama aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei, arekeeꞌ nkomeriiꞌnaang, Jiisuuꞌke Nasaretiꞌnunge? Daꞌ ee niiꞌ bataꞌkoo poing? Ninge noruꞌdansi oꞌnong daꞌ Kumponing-etaing Naning Meekung.” ");
INSERT INTO nas_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Teka Jiisuuꞌke tee akaꞌpuma aaꞌpuuꞌ, “Kareaukaꞌ, eeꞌnoko daꞌ teietaꞌ bankeꞌdaravai.” Eeꞌnoko teketa maꞌnaange teing-koo meuꞌ teꞌ doonko duaꞌantavura teieta bankeꞌaruꞌnung tokoonaꞌ baikevuaꞌ tee. ");
INSERT INTO nas_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eeꞌnoko ookarai aaꞌnaꞌ taꞌninaara biiꞌka kareaama aaꞌpaakoꞌ, “Aung aremuriiꞌke karai iirakutai karomaung purintoꞌke aaꞌnunge maꞌnari orenanka botovuriko bankeꞌarikooꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eeꞌnoko doorenang aung-koong tee ookutunairue osinankai nanuuꞌnung temeng korovui otoininge. ");
INSERT INTO nas_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Eeꞌnoko tee teketaꞌ donkonura teva pava dootuuꞌnava sipura Saimoniꞌ bakanavaꞌke deto koinuuꞌ. Eeꞌnoko Saimoniꞌ baꞌdoraa teke aaꞌnaꞌ siipavora otoko uipaariiꞌ ninka teinge Jiisuuꞌ niaꞌauꞌ teni pakuvuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Eeꞌnoko tee teni-anko donkonura tee siipa akaꞌpuuꞌnung eeꞌnoko tee uipaariiꞌ namuꞌke boimpuuꞌ. Eeꞌnoko namuꞌke tenie deto iꞌamparara bauꞌuruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Emuꞌ tee tenang duaaꞌ tumparioꞌ ookarai biikaning siipa-poꞌnupoong tavoꞌaaruꞌnung amutemuriiꞌ siipa otoꞌevorokoꞌning. Eeꞌnoko teie tankaꞌ ookara-koo narunaꞌ narunaꞌ panteꞌurima taare-antavuruꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eeꞌnoko mmauꞌ nantoong-eta maꞌnari bankeꞌarikoꞌ bokiaama aaꞌpaama, “Daꞌ tee Domang-anta Kumponinge tero nantoong marakavuruꞌnung, Kumponing bauring.” Teka teie orokovurima kara-koo tauraꞌpuriarukoꞌ, aiꞌ teinge tee tasiꞌpauꞌnung tee tee Kumponinge tero Pakoꞌpariꞌuuꞌnung˜ nantoong domampuri tarevuriainooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Eeꞌnoko siimpoorovuma˜ nanuko Jiisuuꞌ tenkenura baka otoꞌnooꞌ beuꞌ teke kunsiaraaꞌnaang. Eeꞌnoko nantoonge besiꞌaama porouꞌ tee-anko. Eeꞌnoko pinkaꞌkoo paaravaakoꞌnung teing-ankoita tenkenuarooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Teka teie aaꞌpuruꞌ teing, “Ninge aaꞌ daankiamaꞌnaang tee doorenang tampara napoꞌ niiꞌning osi-koo Kumponing bakaang muuꞌkoong, aiꞌ ning tee teeꞌ nko-koo botomuuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eeꞌnoko tee teketaꞌ Judiaꞌnameensiꞌkoo bera daankiarakoꞌ pava dootuuꞌnanka-koo. ");
INSERT INTO nas_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Niiꞌnaꞌmung tee Jiisuuꞌ tee nuaruꞌ Kaaleliꞌnaruꞌ dueꞌke donkonuioꞌ nantoong mmauꞌ porora paampaꞌaakoꞌ kara Kumponing bakaang taara-koo. ");
INSERT INTO nas_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Eeꞌnoko teie teka kerenta bakaasining oovukoꞌ nuaruꞌkoo tapirua taviꞌ baranukai sipaara biikaning sionung duuꞌpaako. ");
INSERT INTO nas_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nareng-koo teing-koo bakaasi-koo Saimoniꞌ bakanareng-koo aaꞌearara Saimoniꞌ niaꞌuma aaꞌpuuꞌ, “Daampeto okiꞌnooꞌ naroꞌ tuuꞌei mereai.” Eeꞌnoko teie tuuꞌuioꞌ teꞌ bakaasi-koo baꞌnanui nau-antavuruꞌnung nantoong tereng-eta. ");
INSERT INTO nas_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eeꞌnoko kara bakearako teie Jiisuuꞌke Saimoniꞌ aaꞌpuuꞌ, “Kankonooꞌ danto beꞌantavera dakaang sionung doonko duaꞌeai taviꞌ barang-koo.” ");
INSERT INTO nas_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Eeꞌnoko Saimoniꞌke makuꞌuma aaꞌpuuꞌ, “Ovoring, niiꞌ poreꞌmoring ookutunaꞌmung muunga. Konkampiaꞌ, teka botomeinaꞌkoo dake ninge doonko duaꞌampaing tee sionung.” ");
INSERT INTO nas_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Eeꞌnoko teinge teeꞌ nkoaara taviꞌ uumono˜ oraura˜ avoꞌaaruꞌ; ");
INSERT INTO nas_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eeꞌnoko biikaang sionung dererereꞌarako biikaning mantaꞌnanka birenge bokuaaruꞌnung oovunareng-koo otorokoꞌning porora pakuaariiꞌnaang. Eeꞌnoko teing porora ookeng bakaasining maantoꞌaara dapiꞌ minkiarikoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Teka Saimoniꞌ Piitai oovura tee, asikovura Jiisuuꞌkoo kauꞌkanooꞌ kinkinura aaꞌpuuꞌ, “Ovoring ee, ning naning orara, daꞌkoo dueꞌ otoꞌkoo makosi deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Teing ookara Saimoniꞌ baꞌmaikoriꞌ nariꞌ asikovuruꞌ teing taviꞌnanka barampaaruꞌning ooaarira. ");
INSERT INTO nas_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jeemisi namainta Jooni napoꞌ nariꞌ, Sebetiꞌ baurinketa, Saimoniꞌ ninka nariꞌ mantaꞌka taviꞌ barang-koo. Eeꞌnoko Jiisuuꞌke Saimoniꞌ aaꞌpuuꞌ, “Aroreaukaꞌnung. Enang-eta deto dake nantoong baramperimatooꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eeꞌnoko tenang teinge teing biikaning bakaasinanka tapiru duumeaarira˜ ookara kapooꞌ sipaarira teinge tee siompauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jiisuuꞌ niiꞌnavuntuꞌkoo teing-koo osinanka-koo otoko naning narung pouꞌ oramuuꞌke maantoꞌ. Eeꞌnoko tenang Jiisuuꞌ oovura tee kinkinura eentavaruꞌ tee-koo, aaꞌpuma, “Ovoring, daꞌ piarora deekoꞌ dake ning kuimepeuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eeꞌnoko Jiisuuꞌke bireng tovoroꞌarara kompuuꞌ tee, aaꞌpuma, “Piamoi otong. Enang kuiraring!” Eeꞌnoko namuꞌke tee oramuuꞌke sipuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Eeꞌnoko Jiisuuꞌke naning nau-koo orokovura aaꞌpuuꞌ, “Bera piristiꞌkoo siraꞌantararavaing eeꞌnoko boontunang nkoveai daꞌ nantoong dueꞌkoo untuꞌanta-koong Moosesi bakaang botoi minkuvumanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Teka teeꞌ minkuvuioꞌ baruꞌ aaꞌnooꞌ doorenang bereravari nanuuꞌnung tee-koong, eeꞌnoko mmauꞌ nantoong porouꞌ taara-koo eeꞌnoko taare-anta nka-koo biikaning siipananka-koo. ");
INSERT INTO nas_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Teka niiꞌning batei-koo meeꞌboraꞌ sirakamaaꞌkoo nantoong-eta tontaꞌarama teke kunsiarakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Niiꞌnaꞌmung teroong-koo Jiisuuꞌ nau-antavarako Boto Keperuuꞌnavitu eeꞌnoko boto naunuka teke dueꞌke baꞌnanai otorokoꞌ ookara osinairu-eta porora aaꞌning-eta: Kaaleliꞌnavaro-ita, Judiaꞌnavaro-ita, eeꞌnoko Jerusalemaꞌketa. Eeꞌnoko Ovoring bakaang purintoꞌ tee ninka otokoꞌ nantoong taare-anta-koo. ");
INSERT INTO nas_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eeꞌnoko nantoonge naning narung batanang-koo otoko poꞌantavauꞌ dootavouꞌnung. Eeꞌnoko teinge taung besiꞌaakoꞌ kuung poꞌantavaara Jiisuuꞌkoo uroꞌkanooꞌ beng-koo. ");
INSERT INTO nas_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Teka karikaꞌke paampaꞌaioꞌ doona ooaavaꞌ tee kuung poꞌanta-koo, eeꞌnoko teinge daukava-koo koinaara teke toꞌbaꞌaara batanang-koo otoko siauꞌnung meuꞌ Jiisuuꞌanko. ");
INSERT INTO nas_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Eeꞌnoko tenang Jiisuuꞌke teing tee tavoꞌauꞌning biikaang baito oovura aaꞌpuuꞌ tee naning doota, “Aung ee, dakaning orarananka tontaꞌderonsing.” ");
INSERT INTO nas_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eeꞌnoko teinge boto naunuka eeꞌnoko Boto Keperuuꞌnavitu˜ aaꞌning ninka nianiaꞌ tutumpauꞌ aaꞌpaama, “Aunge aming-koo Kumponing bauvaupaaꞌumaang? Naning otoaꞌ orara aarumo tontaꞌupeuꞌnung, Kumponing narung deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tenang Jiisuuꞌke biikaning nianiaꞌnanka tasiꞌpura teie makuꞌurima aaꞌpuruꞌ, “Diiꞌ aming-koo diikaang domang-koo kuunge teeꞌ munkururarimaang? ");
INSERT INTO nas_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Arera kara masikaꞌpoaruko ooverira ning makosi deeaung tammeripeuꞌ aaꞌning-koo, eeꞌ minku-koo, ‘Dakaning orarananka tontaꞌderonsing,’ niiꞌnaꞌ eeꞌ minku-koo, ‘Daaꞌdarara naniai.’? ");
INSERT INTO nas_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Teka diiꞌke iroꞌ noruꞌmeriiꞌnaang ning Tee Naning-naumpoꞌ Paning-etaing tee purintoꞌ otoꞌmemuing anke kansiꞌkoo oꞌnoi orarananka tontaꞌkoo...” Teeꞌpura tee naning doota aaꞌpuuꞌ, “Ninge aaꞌdamaang, ‘Daaꞌdarara dakaang taniꞌ nkavei naniai dakanava-koo.’” ");
INSERT INTO nas_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Eeꞌnoko namuꞌke, ooai otoko, tee daaꞌarara bempari otokoꞌnung taniꞌ deto nkavui bakanava-koo beuꞌ, Kumponing daangampuma. ");
INSERT INTO nas_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eeꞌnoko taꞌnintaꞌning noruꞌ paapaaꞌke ookara dakoꞌuruꞌ eeꞌnoko dankurankuꞌarima Kumponing daangampaama aaꞌpauꞌ, “Niiꞌke eꞌmung kapooꞌ damisimainanka ooampiring.” ");
INSERT INTO nas_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Teketa tee kato tenkenura Jiisuuꞌke naning taakisi-nka-nung oovuuꞌnung miring Liivaiꞌ, taakisi nkavaakoꞌnava-koo baꞌnanuioꞌ bakanavaro-koo. Teketa Jiisuuꞌke aaꞌpuuꞌ, “Ning siomeai.” Eeꞌnoko Liivaiꞌke ookara kapooꞌnanka sipura, deto donkonura tenang-eta deto tee siompui nanuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","(-) ");
INSERT INTO nas_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Eeꞌnoko Liivaiꞌke bakanava-koo paroro pankaing nkoevuuꞌnung Jiisuuꞌ. Eeꞌnoko teke karinga taakisi nkanuka ninka napoꞌ niiꞌning oovuning ninka nariꞌ otorokoꞌning teing ninka eeꞌning ninka nariꞌ baꞌnaniauꞌnung taamantomai. ");
INSERT INTO nas_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Eeꞌnoko teing Boto Keperuuꞌnavitu biikaning boto naunuka ninka minkuminkuaarikoꞌ bakaning barevare-nupoong-koo aaꞌpaama, “Diiꞌ aming-koo nariꞌ taamanirimaang taakisi nkanuka eeꞌnoko nantoong orenanka ninka nariꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuuꞌ, “Teing nantoong tampaꞌ otoroining naninge nankaiꞌuriiꞌnaang piavoroaꞌ, teka teing siipavoromaing naing piavoromaung. ");
INSERT INTO nas_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ning nantoong tampenanka-anko moaꞌ. Ning orenanka-koo mouꞌnung nauaranko bereꞌariaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eeꞌnoko teinge Jiisuuꞌ aaꞌpauꞌ, “Jooni bakaning barevare-nupoong amutemuꞌke unkumoarimaung kunsi ninka, eeꞌnoko Boto Keperuuꞌnavitu biikaning barevare-nupoong teeꞌ nariꞌke, teka daꞌ dakaning nai narung-koo otoromaung tuaamparima.” ");
INSERT INTO nas_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ teing, “Diiꞌke ee teing baraneeꞌnavitu nampeesi-koo poromaing unkumo-antaverereripeuꞌ tenang tee nampeesinara nariꞌ otoroko teing ninka? ");
INSERT INTO nas_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Otong niiꞌning doong tee nampeesinara teing-eta tontaꞌaravainaꞌmung. Eeꞌnoko tenang teing doong-koo unkumoariaing.” ");
INSERT INTO nas_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eeꞌnoko Jiisuuꞌke kara dikitoꞌ nauvuruꞌnung napoꞌ, aaꞌpuma, “Naninge nerakaraꞌkoo mononopaꞌnaraꞌkoo niiꞌnooꞌ dereꞌura urikaraꞌ ninka naroꞌka pateꞌuarupeuꞌ. Teeꞌ nkovuaing deekoꞌ tee tamung orarivuuꞌnaang teraꞌ nerakaraꞌ dereꞌuinaraꞌ urikaraꞌ ninka pateꞌkoo makotuaꞌnaraꞌ ninka. ");
INSERT INTO nas_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Eeꞌnoko napoꞌ naninge nerakaruꞌ uaininaruꞌ urikaroꞌkoo kooꞌuarupeuꞌ. Teeꞌ nkovuaing deekoꞌ teruꞌke nerakaruꞌke urikaroꞌ taꞌdaꞌpura piamparapeuꞌ eeꞌnoko teroꞌ tee urikaroꞌ oraruꞌkuainaroꞌ. ");
INSERT INTO nas_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Teka nerakaruꞌ uaininaruꞌ tee nerakaroꞌkoo kooꞌuaing. ");
INSERT INTO nas_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Eeꞌnoko napoꞌ naninge urikaruꞌ uaininaruꞌ naivura nerakaruꞌkoo piavoarupeuꞌ aaꞌpuma, ‘Urikaruꞌ aruꞌ tamparuꞌ.’” ");
INSERT INTO nas_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Niiꞌnaꞌmung Doong Uaanaꞌmung Jiisuuꞌ bakaning ninka nariꞌ uiteꞌnaue˜ tankinaama bakaninge barevare-nupoonge niiꞌning biiꞌdaꞌpauꞌnung uiteꞌkoong sinang-koo untuꞌnooꞌ, eeꞌnoko naakoꞌpaara maaꞌauꞌ tamung tankinaama Juꞌnupoong biikaang aarumo-koo tauraꞌpari otoinaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Teka niiꞌninge Boto Keperuuꞌnavitue˜ aaꞌpauꞌ, “Diiꞌ aming-koo mintoontarimaang boto totoꞌperitaaꞌ Doong Uaanaꞌmung-koong?” ");
INSERT INTO nas_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Diiꞌke aming-koo teeꞌ tuumpimerimaang? Tampaꞌ noruꞌeri otong tee kapooꞌ Deevitaꞌke nkovuuꞌnung tenang tee peeravora, tee Deevitaꞌ eeꞌnoko teing nariꞌ otorokoꞌning ninka. ");
INSERT INTO nas_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kumponing bakanava-koo Deevitaꞌke koinura nkavura naiauꞌ tee taamang meekung, niiꞌninge nai-koo tauraꞌparavaꞌ, teka piristiꞌnuka nainge deekoꞌ nai-koo makosi. Eeꞌnoko teie Deevitaꞌke teing nariꞌ otorokoꞌning avurioꞌ boto totoꞌkoo tuumpiaavaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Eeꞌnoko napoꞌ aaꞌpuruꞌnung teing, “Ning Tee Naning-naumpoꞌ Paning-etaing tee Ovoring Doong Uaanaꞌmung-koong.” ");
INSERT INTO nas_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Napoꞌ niiꞌnaꞌmung Doong Uaanaꞌmung pava dootuuꞌnava-koo tumparara Jiisuuꞌke nau-antavurikoꞌnung narung naning teke otoko bireng tampavine duuaiꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Eeꞌnoko boto naunuka eeꞌnoko Boto Keperuuꞌnavitu dovange tareaakoꞌ ooaavaꞌnaang taare-antavuko deekoꞌ Doong Uaanaꞌmung kapooꞌ tee tuumpiaavaing daaꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Teka teie noruꞌuruꞌ biikaang norunoruꞌ eeꞌnoko aaꞌpuuꞌ tee naning duuaiꞌ, “Deto donkoniko ooraavai.” Eeꞌnoko teketa daaꞌarara donkonuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ teing, “Ninge eeꞌ tanaꞌdampimang: Arekeeꞌ oroꞌ aarumo tauraꞌpari otong Doong Uaanaꞌmung nko-koo, aiꞌ naning tampaꞌ nko-koo aiꞌ orakaꞌ nko-koo; aiꞌ domaang mooꞌkoo aiꞌ dupisiꞌkoo makosie?” ");
INSERT INTO nas_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eeꞌnoko teie ooꞌoovuruꞌnung teing ookara, eeꞌnoko teka aaꞌpuuꞌ, “Bireng tovoroꞌdaravai.” Eeꞌnoko teeꞌ nkoaruꞌ, eeꞌnoko bakaang bireng tamparuꞌkuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Eeꞌnoko teing karinsiꞌorora biiꞌka minkuarima kapooꞌ Jiisuuꞌkoo orakaꞌ nkoaavaing minkuaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Eeꞌnoko teing doong-koo Jiisuuꞌ osi sipura beuꞌnung iuꞌaape kunsiaraaꞌnaang; muung ookutunaꞌmung Kumponing-koo kunsiarama otouꞌ teke. ");
INSERT INTO nas_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Eeꞌnoko tenang taneꞌpuioꞌ teie bokuvuruꞌnung bakaning barevare-nupoong eeꞌnoko teing-koo nanaiꞌketa kenaanka miruꞌuruꞌ, teing kara okovuri nkanuka tampuruꞌning, miring aing aaꞌning: ");
INSERT INTO nas_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Saimoniꞌ, niiꞌnooꞌ Piita tampuuꞌ, eeꞌnoko Aanduruꞌ, teie baaraꞌmaꞌnung, eeꞌnoko Jeemisi, eeꞌnoko Jooni, eeꞌnoko Pilipiꞌ, eeꞌnoko Baatolomiuꞌ, eeꞌnoko Maatiuꞌ, eeꞌnoko Toomasi, eeꞌnoko Jeemisi, Alopeasi bauring, eeꞌnoko Saimoniꞌ, niiꞌnooꞌ Sielotiꞌ miring damaꞌ ereꞌauꞌnung, eeꞌnoko Judasi, Jeemisi bauring, eeꞌnoko Judasi, Kerioꞌnara, tee eeꞌnara Ovoring baavevuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Eeꞌnoko tee siaruꞌ doonko teing ninka, eeꞌnoko donkonauꞌ duumpanooꞌ deepoꞌ nantoong karikaꞌ barevare-nupoong ninka. Eeꞌnoko nantoong miatara porouꞌnung taaravaavaꞌnaang eeꞌnoko biikaning siipa-ita taare-antavuriiꞌnaang. Teing osi aaꞌning-eta porouꞌ: ookara Judiaꞌnavaro-eta, Jerusalemaꞌketa eeꞌnoko pirung dueꞌnairu-eta (Taiaꞌkoonairu-eta eeꞌnoko Saidoniꞌketa). ");
INSERT INTO nas_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Eeꞌnoko teing napoꞌ maꞌnari orenge poreꞌantavaarikoꞌning unaavorouꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ookara nantoonge Jiisuuꞌ tankaꞌke kompaavaꞌnaang keviꞌarikoꞌ aiꞌ purintoꞌ Jiisuuꞌketa pareꞌarama teie ookara taare-antavurikoꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Eeꞌnoko Jiisuuꞌke dutai keenavuri oovurira bakaning barevare-nupoong aaꞌpuruꞌnung, “Biraanke-nupoong diiꞌ enang ataꞌerima baitorarimaing, aiꞌ Kumponing bakaang muuꞌ tee diiꞌ okoruriaing. ");
INSERT INTO nas_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Biraanke-nupoong diiꞌ enang peerarorima baitorarimaing, aiꞌ diiꞌ teing pooruriaining. “Biraanke-nupoong diiꞌ enang birontarimatomaing, aiꞌ diiꞌ teing benkenirimatoaining. ");
INSERT INTO nas_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Biraanke-nupoong napoꞌ diiꞌ tenang nantoonge munteꞌdaariko, pokaꞌdaariko deuꞌdaarima diikaang miring orakaꞌ tantaarima ning Naning-naumpoꞌ Paning-etaing siomerimaung-koo. ");
INSERT INTO nas_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Teꞌmung teeꞌ tavoꞌarako doturoturariritaaꞌ dinkitooꞌdariaing doturoturarima, eeꞌ noruꞌerima, ‘Niikaang mooꞌ pankaing otong teke paning-koo,’ aiꞌ tee teeꞌ nariꞌ biumaraange temuꞌnupoong Kumponing-etaing nakaro-nupoong nkoaarikoꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Teka diiꞌ kavo mmauꞌnuka bakaꞌ piaaruꞌnuka, toraꞌkiriaing, aiꞌ dunsirunsi-anta˜ tero nkaveruꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Diiꞌ enang pooruri otoining piaaruꞌnukai, diiꞌ teing peeraroriaining. “Diiꞌ enang benkenirimatomaing piaaruꞌnukai, diiꞌ teing orarunsi ninka birontariaining. ");
INSERT INTO nas_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Diiꞌ nantoonge tampaꞌ nariꞌ minkuraarimaatomaing piaaruꞌnukai, toraꞌkiriaining, aiꞌ diiꞌ teing urikupoong tositosinanka nakaro-nupoong-pinaꞌ oroꞌnanka. Diumaraange teeꞌ nkoaarikoꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Teka ninge aaꞌdampimang diiꞌ tampaꞌ taaramerimaing: Diikaning kare-nupoong piaaverererimaatoaing, tampaꞌ nkovererima teing diiꞌ munteꞌdaarimaing. ");
INSERT INTO nas_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Teing barakosiꞌdaarimaing biraanke-antavererimaatoai. Teing orakaꞌ nkoraarimaing kunsi-koo pakuererimaatoai. ");
INSERT INTO nas_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Baa naning diiꞌ amoꞌkoo tankoꞌduriaing napoꞌ bariꞌnameng naueriai napoꞌ tankoꞌduriiꞌnaang. Baa tee diiꞌ mononopaꞌ daunanaaꞌ pariꞌduriaing tee-koo orokoveriaukaꞌ napoꞌ boonanaaꞌ pariꞌduriko. ");
INSERT INTO nas_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ookara eentaraarimaatoaining averererimaatoai eeꞌnoko teing baata diikaning kapooꞌnanka pariꞌdaariaining diiꞌke napoꞌ eentaverereriaukaꞌ teing. ");
INSERT INTO nas_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Eeꞌnoko nantoonge diiꞌ tampaꞌ nkoraariiꞌnaang piarorimanaꞌ teeꞌ nariꞌ nkovererimaatoaing teing diiꞌke. ");
INSERT INTO nas_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Diiꞌke teing nantoong piaaraarimaing naing piaaverererimaatoaing deekoꞌ arekeeꞌ tee-koo Kumponinge tampaꞌ ooruripeuꞌ? Aiꞌ aaꞌ orenge piaavaarikooꞌ teing piaavaarimaing napoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Eeꞌnoko diiꞌke tampaꞌ nkovererima teing diiꞌ tampaꞌ nkoraarimaing arekeeꞌ tee-koo Kumponinge tampaꞌ ooruripeu? Aiꞌ aaꞌ orenge teeꞌ nariꞌ nkoaakooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Eeꞌnoko komaaru˜ nka-koo tauraꞌperererima teing diiꞌke makuꞌdaariaining-pinaꞌ noruꞌererimaing arekeeꞌ Kumponinge tampaꞌ noruꞌduripeuꞌ, aiꞌ aaꞌ orenge teeꞌ nariꞌ nkoaakooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Teka diiꞌke piaaverererimaatoaing diiꞌkoo kare-nupoong tampaꞌ nkovererima, eeꞌnoko komaaru eentaraariko averererima tamung teka siperimaatoai makuꞌkoo noruꞌeriaꞌ. Teeꞌkoo diikaang mooꞌ bakei pankaing eeꞌnoko diiꞌ teing tee Ovoring Deto Basi baurukaaꞌ deentariaing, aiꞌ teie tee tampaꞌ nkovurimaung teing oreng, tampaꞌ tang noruꞌaavaing. ");
INSERT INTO nas_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Piaae maantoꞌdariri otorimaatoaing Diuma paning-koong piaae maantoꞌari otomanaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nantoong koong-anta-koo oioiꞌdariaꞌ otoai Kumponinge nariꞌ koong-antaruriaukaꞌnaꞌ. Kiimata-koo tamperereriaꞌ otoai Kumponinge kiimata-koo tanturiaukaꞌnaꞌ. Tontaꞌantareeri otorimaatoai diiꞌ tontaꞌantaruiainaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Avuavuꞌ nkoverimatoai arurimaatoainaꞌ. Tampooꞌ basinooꞌ dankarankampuma meenkiꞌora piaampura aruriainaꞌ. Teeꞌ diiꞌke avereriainaꞌ teeꞌ basinaꞌ napoꞌ diiꞌ aruriaing.” ");
INSERT INTO nas_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Eeꞌnoko teie napoꞌ kara dikitoꞌ nauvuruꞌnung, aaꞌpuuꞌnung, “Kaputuꞌke ee napoꞌ kaputuꞌ taung nau-antavupeuꞌ? A, makotuaꞌ. Tenaanka ookaanka duaꞌarepeuꞌ dinkung-koo. ");
INSERT INTO nas_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aiꞌ tee naning barevare-nung tee bakaang nau-anta-koo dau basi deeaꞌ, teka ookara barevare-nupoong tenang dupearioꞌ nau-antavaariko biikaning nau-antanuka-pinaꞌ otoroaing. ");
INSERT INTO nas_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Teeꞌ oroꞌ nau-anta baka tasiꞌparavaung aaꞌpampiiꞌnaang, ‘Aming-koo dake nankiꞌ daaraꞌmaꞌnung-koo duta-koo oovemaunge teka daka noruꞌdaravaꞌ daꞌkoo duta-koo konkinarong otoing?’ ");
INSERT INTO nas_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Niiꞌnaꞌ, ‘Arekeeꞌ dake aaꞌpepeuꞌ tee daaraꞌmaꞌnung, “Ntaraꞌ ee, ninge nankang mooꞌdampai daꞌkoo duta-koo otoing,” tenang daka ooraravaꞌ tee konking daꞌkoo duta-koo otoing. Daꞌ ampirinung˜, iroꞌ tutung daka-koo mooꞌdaravaing tee konking duta-koo eeꞌnoko tenang daaraꞌmaꞌnung-koo sirakaꞌpei oovera mooꞌeai tee nankiꞌ daaraꞌmaꞌnung-koo duta-koo otoing.’ ");
INSERT INTO nas_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Eeꞌnoko koiꞌ tampara sinang orara biꞌumaung otoaꞌ, eeꞌnoko napoꞌ koiꞌ orara sinang tampara biꞌumaung otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Koiꞌnavarinaꞌ biikaang sinang-koo tasiꞌpaarimaung. Tee sinang piikiꞌ tooꞌmurintaaꞌpoꞌnavari-koo kavaavarupeuꞌ, eeꞌnoko karikauꞌ napoꞌ moꞌming nanaꞌmosiriiꞌkoo kavaavarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Teie naning tamparai tee teieta tampara domang-koong koreꞌnang-eta tampara tavoꞌantavumaung eeꞌnoko teie naning orarai tee teieta orara domang-koong koreꞌnang-eta orara tavoꞌantavumaung, teieta bakaang domang-koo otoining piamparako bakaang karange minkuvurimaung.” ");
INSERT INTO nas_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Aming-koo ning diiꞌke ‘Ovoring, Ovoring’ tammerimaunge kapooꞌ ninge naurampimaung nkoveriaꞌ? ");
INSERT INTO nas_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ookara nantoong ning-koo poroma aung nkaang kara taaravaama siompaamaing naurampiiꞌnaang ninge, teing oroꞌparimanaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Teing tee-pinaꞌ naning-pinaꞌ oroꞌnanka pava kanivuuꞌnung-pinaꞌ dinkung isikung nenkeꞌura natuku boiaꞌkoo eꞌmang-antavuuꞌ. Eeꞌnoko tenang doua pora teva-ankoi kooꞌura biruꞌuaꞌ teva, aming-koo nnaꞌ tampaꞌ kaniniiꞌnava deemparako. ");
INSERT INTO nas_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Eeꞌnoko baata teing nkaang kara tamung taaravaama siompaavarukooꞌ teing teing tee-pinaꞌ naning-pinaꞌ oroꞌnuka pava kanivuuꞌnung-pinaꞌ tamung piisiꞌkoo dau eꞌmang-antavuaꞌ, eeꞌnoko doua teva-ankoi kooꞌura namuꞌke duaꞌantavuuꞌ eeꞌnoko bakei aaꞌnaꞌ masikaꞌ orariaruꞌ teva.” ");
INSERT INTO nas_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tenang Jiisuuꞌke bakaang daankinang bakearara taaravauꞌnooꞌketa tumparuꞌnung tee Kapaneumeꞌnavuntuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Teke tee naning narung daakuꞌ piatooronuka tarenara otokoꞌ bakaang botovotonaaꞌ teie aaꞌnaꞌ piaavukoꞌnung siipavouꞌnung booꞌkoo tumpituumpi. ");
INSERT INTO nas_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tenang teie Jiisuuꞌ taaravura Juꞌkoong Ovontung botovuruꞌ tee-anko niaꞌaako pora taare-antavuuꞌnaang bakaang botovotonaaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Eeꞌnoko tenang teing Jiisuuꞌanko porora teing aaꞌnaꞌ eentavariruꞌnung aaꞌpaama, ");
INSERT INTO nas_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","“Tee tee naning tampara aung, dake paku-koo makosi, aiꞌ teie tee niiꞌ Juꞌnupoong pakumurimaung eeꞌnoko niikaang dootuuꞌnava kanimemuruꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eeꞌnoko Jiisuuꞌ teing ninka nariꞌ beuꞌ. Tenang tee pava dueꞌ basiarako teie daakuꞌ tarenarai baꞌmaikoriꞌ niiꞌning botovuruꞌ Jiisuuꞌanko aaꞌpuma, “Ovoring, daka baruꞌ poreꞌantararavaukaꞌ, aiꞌ ning tee makosi deeaꞌ daꞌ nkanooꞌ pava-koo kuung poꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Teeꞌkoo ning ninka daangamarama daꞌanko moaꞌ, teka dake tamung karai minkueko nkaang botovotonaaꞌ taarevoaing. ");
INSERT INTO nas_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ninge daꞌ pankaing tasiꞌdamira teeꞌ minkuamaang, aiꞌ ning tee napoꞌ niiꞌnooꞌ basi-koo iriꞌkoo kuung oꞌnong piatooronuka tare-koong-koo. Eeꞌnoko niiꞌnung aaꞌpanko dei, ‘Beai,’ tee bepeuꞌ. Eeꞌnoko niiꞌnung aaꞌpanko dei, ‘Poai,’ tee popeuꞌ. Eeꞌnoko nkaang botovotonaaꞌ aaꞌpanko, ‘Aung nkoveai,’ teie nkovupeuꞌ tee.” ");
INSERT INTO nas_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tenang Jiisuuꞌke teeꞌ taaravura taꞌninuuꞌ tee-koo, eeꞌnoko damaꞌdu bereꞌarara karikaꞌkoo siompaakoꞌning-koo karoma aaꞌpuuꞌ, “Ninge naurampimang diiꞌ: temuꞌketa aung amuriiꞌ baito pankaing ooampaung bane Isireeli-nupoong ninka nariꞌ oꞌnorimaunge.” ");
INSERT INTO nas_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Eeꞌnoko tenang teing botovuruꞌning toroarira pava-koo teinge ooauꞌnung tee botovotonaaꞌ taarevora otoko. ");
INSERT INTO nas_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Batei okiꞌnamuꞌkoo teketaꞌ Jiisuuꞌ niiꞌnamono-koo osi pankaing-koo beuꞌnung Neiniꞌ tampaamanamono-koo. Eeꞌnoko bakaning barevare-nupoong eeꞌnoko nantoong karinga nariꞌ tee ninka berouꞌnunge. ");
INSERT INTO nas_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Osi-koo karanaang dueꞌarako naning booꞌparuꞌnung nkavai siarikoꞌ temono-ita. Aung tee bauring narung masikung anie baukoi, eeꞌnoko teni teie bauko naaro. Eeꞌnoko nantoong karinga teni ninka nariꞌ porokoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Eeꞌnoko tenang Ovoringe oovura bakaang domang aaꞌnaꞌ piaavouꞌ teni-koo, eeꞌnoko aaꞌpuuꞌ, “Birontaravaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Eeꞌnoko teie pora kompuuꞌ tee kave, eeꞌnoko teing nkavaakoꞌning dantavarira donkonai otorouꞌ. Eeꞌnoko teie aaꞌpuuꞌ, “Nemaka, ninge aaꞌdamaang daꞌ, ‘Daaꞌdaravai.’” ");
INSERT INTO nas_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eeꞌnoko tee naning booꞌ deto baꞌnanura kara tutumparuꞌ, eeꞌnoko Jiisuuꞌke tee teni bauko avuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Avoroꞌke amporoꞌuruꞌ teing ookara. Eeꞌnoko teinge Kumponing daangampauꞌ aaꞌpaama, “Nakaronara Kumponing-etaing niiꞌkoo meuꞌke anke daaꞌaring; Kumponinge niiꞌ bakaning beeroꞌmuring!” ");
INSERT INTO nas_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eeꞌnoko teie aunge doorenange tee-koonge ookara Judiaꞌnavaro punkaraampuuꞌnung eeꞌnoko teꞌ korovui otoinairu nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Emuꞌ tee, Jooni Minkinara kiimatanava-koo otoko bakaning barevare-nupoong tee-anko berora nauauꞌnung aing ookara kapooꞌnanka Jiisuuꞌke nkovukoꞌning. ");
INSERT INTO nas_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Eeꞌnoko Joonie kenaankara bakaning-koo barevare-nupoong-koo bokuvureta Ovoring-anko botovuretuꞌnung aaꞌpuma, “Aaꞌpereai, ‘Daꞌ ee tee tavoꞌkuaing-koong, aiꞌ mmeꞌ niiꞌnung nempampiainge?’” ");
INSERT INTO nas_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Eeꞌnoko tenang tenaanka poreta tee-anko aaꞌpuretuꞌnung, “Jooni Minkinarai neeꞌ daꞌanko botomuresinung aaꞌpuma: ‘Daꞌ ee tee tavoꞌaravaing-koong, aiꞌ mmeꞌ niiꞌnung nempampiainge?’” ");
INSERT INTO nas_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Eeꞌnoko tenaankai Joonie botovuretuꞌnaankai makuꞌnooꞌ nempuresi otoko Jiisuuꞌke karinga amutemuriiꞌ siipa-poꞌnupoong taare-antavuruꞌ, niiꞌning oramuriiꞌ siipa avoꞌavoroꞌ otoroining eeꞌnoko niiꞌning tanuaananka oreng-poꞌnupoong. Eeꞌnoko kaputuꞌnuka mmauꞌ bantang-antavuruꞌnunge. ");
INSERT INTO nas_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eeꞌnoko teie aaꞌpuretuꞌnung tenaanka, “Bereta nauereai tee Jooni Minkinara kapooꞌ deeꞌke ooveresining eeꞌnoko taaraveresining, aaꞌnoining: kaputuꞌnuka banteaama ookai, kauꞌ deꞌdoonuka nanai, oramuuꞌpoꞌnupoong kiiroraaꞌariri eeꞌnoko kipaunuka taareai, booꞌnuka daaꞌariri, ataꞌoinku tampara doorenang daankianko taaravai. ");
INSERT INTO nas_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Eeꞌnoko biraankearavaing tee naning ning-koo dateꞌpari baitoaravaing, eeꞌnoko nkaang nko-nko akoveeꞌ mareꞌuaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tenang Jooni Minkinara bakanaanka kara nkara toroaresioꞌ Jiisuuꞌke kara-nau tutumpuruꞌ nantoong karinga Jooni minkuvuma; eeꞌnoko aaꞌpuuꞌ, “Diiꞌke aremuriiꞌ naning doore taaraverira meeꞌboraꞌ sirakamaaꞌkoo ooveriiꞌnaang berikoꞌ karikaꞌduri? Naning tunsi-paaka onou avitoitoi eeari otoꞌ oo-koo teꞌ beriarupeuꞌ, apeꞌ? ");
INSERT INTO nas_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Napoꞌ naning nepuꞌarama kirokaiari otomaung oo-koo beriaꞌ, apeꞌ aing? Aiꞌ teing nantoong baarong tampenge nopaꞌarimaing, eeꞌnoko kavo mmauꞌpoꞌnupoong-pinaꞌ otoromaing dauraronanka biikaning-koo pava-koo oovereripeuꞌ, meeꞌboraꞌ sirakamaaꞌkoo deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Teka arekeeꞌ masikaꞌ oroꞌ oo-koo berikoꞌ diiꞌ, aiꞌ narung nakaronara? Eeꞌ, tee bakei nakaronara masikung Kumponing-etaing emuꞌ ninge naurampimang diiꞌ, tee tee aaꞌnung ookara nakaronuka-koo dau basie tee. ");
INSERT INTO nas_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aiꞌ aung eeꞌnara miruꞌui Daari Meekung-koo eeꞌ minkuari otong Kumponinge bauring temuꞌ nauvuuꞌnooꞌka aaꞌpuma, ‘Ee aung, ninge botoampaing nkaang kara-nka daꞌkoo uroꞌke tee taung maamu-antareruaing uroitaaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Emuꞌ ninge aaꞌdampimang diiꞌ, Jooni Minkinara tee ookara nantoong tee-koo uroꞌke pontoꞌariruꞌning-koo tee deto basi pankaing, teka ninge eeꞌ naurampimang, enang-eta deto baa tee ninge tare-koo arooꞌaravaing, bane Kumponing bakaang muuꞌkoo okiꞌnarai, teie tee Jooni puruꞌui otoaing.” ");
INSERT INTO nas_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ookarai nantoonge eeꞌnoko taakisi nkanukai taaravauꞌnung tee. Aing teing eeꞌning Kumponing bakaang kara koontoꞌ tasiꞌpaara arooꞌaako Joonie ntong-koo minkivurira meekaꞌantavuruꞌning. ");
INSERT INTO nas_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Teka teing Boto Keperuuꞌnavitu eeꞌnoko teing boto naunuka Kumponing bakaang miruꞌ teing-koo kontevorora Joonie ntong-koo minkivuma meekaꞌanta-koo tauraꞌpariaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Teeꞌkoo Jiisuuꞌke napoꞌ aaꞌpuuꞌ, “Diiꞌ nantoong emuꞌnavarang ninge aminge pa miruꞌdampipeuꞌ? Arekeeꞌ naurampiko diiꞌka tasiꞌdaripeuꞌ diikaang aarumo? ");
INSERT INTO nas_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Diiꞌ teing toireꞌpinaꞌ oroꞌnanka baaveroma baꞌnaniai turampeemaing biiꞌka aaꞌpeema, ‘Kovi puunterorompiko konterorima neekarariarukooꞌ. Aiꞌnontuꞌmariko diiꞌ birontariarukooꞌ.’ Teeꞌ nariꞌ oorampimaung neeꞌ tokomererimaing. ");
INSERT INTO nas_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jooni Minkinara poraiꞌnange taamang tovang uaini kerempuko konterorima aaꞌperikoꞌ, ‘Tee maꞌnaang-poꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Eeꞌnoko ning Tee Naning-naumpoꞌ Paning-etaing mora taamanama tuaamarako napoꞌ konterorima aaꞌmerimaung, ‘Aung ooveriai taamang eeꞌnoko uaini nai bauko, taakisi nkanuka eeꞌnoko niiꞌning orenge biiꞌmaikoꞌke.’ ");
INSERT INTO nas_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Teka Kumponinge avutevuꞌmuresi botomuresinaꞌ sinampuko diiꞌke bakaang matau tasiꞌperiaing.” ");
INSERT INTO nas_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Teketaꞌ niiꞌnunge Boto Keperuuꞌnavitu-koonge Jiisuuꞌ bokuvuuꞌnung tee ninka taamanureeꞌnaang, eeꞌnoko bakanava-koo kuung tumpareta taamantoma baꞌnamparuꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Eeꞌnoko taꞌnimpaariiꞌnaꞌ nanie manikumai oranie temono-koonanie taaravura tee taamanuko Boto Keperuuꞌnavitu-koong bakanava-koo, duuni tampaꞌ nuuraaꞌpoꞌnaroꞌ nkavui pouꞌ. ");
INSERT INTO nas_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eeꞌnoko teni pora Jiisuuꞌkoo damaꞌdu donkonuuꞌnung kauꞌkanooꞌke biromparama. Bakaang kauꞌ taꞌdue duuꞌpukoꞌ eeꞌnoko piuꞌukoꞌ bakaang dapoi boreꞌkoonge, eeꞌnoko kauꞌ bakaang nuunuvukoꞌ eeꞌnoko duunie sisiꞌuuꞌ tampaꞌ nuuraaꞌke. ");
INSERT INTO nas_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Emuꞌ teie Boto Keperuuꞌnavitu-koonge bokuvuuꞌnunge tee oovura baka-koo aaꞌpukoꞌ, “Aung naning nakaronara dei noruꞌupeuꞌ ani baa aremuriiꞌ manikuma kompumatomai aung, aiꞌ ani teni orani.” ");
INSERT INTO nas_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Eeꞌnoko Jiisuuꞌke bakaang noruꞌ tasiꞌpura aaꞌpuuꞌnung tee, “Saimoniꞌ, ning kapooꞌ otoꞌmemumang daꞌ nauramaꞌnaang otoing.” Eeꞌnoko teie makuꞌuma aaꞌpuuꞌ, “Aming ee, nau-anta?” ");
INSERT INTO nas_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jiisuuꞌke aaꞌpuuꞌ, “Narung naning otokoꞌnung tee-koo kenaanka naninkai komaaru nkovuretuꞌnung. Narunge paꞌnokoꞌ daakuꞌ namikuri nkavuuꞌ, napoꞌ niiꞌnunge paꞌnokoꞌ kivora namikuri. ");
INSERT INTO nas_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Teketa tenaankai bariꞌkoo makoturearuioꞌ teie tenaanka tontaꞌantavevuretuꞌ ookaanka. Emuꞌ tenaanka-koo arera teie aaꞌnaꞌ pankaruntoompupeuꞌnaꞌ oroꞌpari?” ");
INSERT INTO nas_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimoniꞌke makuꞌuma aaꞌpuuꞌnung, “Tee naning baruꞌ aaꞌnaꞌ tontaꞌantaevuuꞌnung-pinaꞌ noruꞌamaang.” Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ tee, “Dake masikaꞌ minkueing.” ");
INSERT INTO nas_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Teketaꞌ teni-aape manikuma-aape bereꞌarara Saimoniꞌ aaꞌpuuꞌnung, “Dake ee ani manikuma oovemaang? Ning aꞌ dakanava-koo tumarako dake niikaang toomo siompei ning ntong ameaꞌ kauꞌ duuꞌkoo, teka anie duuꞌmuing nkaang kauꞌ bakaang taꞌdue eeꞌnoko dapoi bakaange piuꞌmui. ");
INSERT INTO nas_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dake napoꞌ onkeonkeꞌmema nuunumeaꞌ, teka tenang ning aꞌ kuung moinooꞌketaꞌ teni siparavaꞌ ning-koong kauꞌ nuunu-koo. ");
INSERT INTO nas_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dake ning-koong boreꞌ duunie sisiꞌmeaꞌ, teka anie nkaang kauꞌ duunie sisiꞌmuing tampaꞌ nuuraaꞌke. ");
INSERT INTO nas_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Teeꞌkoo ninge nauramaang daꞌ: Ani bakaning orarananka mmauꞌ tontaꞌarioꞌ piaa pankaing oroꞌantavuing, teka baa tee bakaning orakaꞌ nkonanka-koo okiꞌning tontaꞌarako piaa okiꞌnooꞌ oroꞌantavumaung.” ");
INSERT INTO nas_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tenang tee Jiisuuꞌke teni aaꞌpuuꞌ, “Dakaning orarananka tontaꞌderonsing.” ");
INSERT INTO nas_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Teketa teing teke nariꞌ taamanaakoꞌning kara tutumpariruꞌ nung biiꞌka aaꞌpaama, “Aung baa naning aaꞌnung orarananka tontaꞌukooꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eeꞌnoko teie aaꞌpuuꞌnung teni manikuma, “Dakaange baitoi mooꞌduinani. Mooa ninka naniaing.” ");
INSERT INTO nas_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Teketa dueꞌka Jiisuuꞌ osi pankeng-kooninge eeꞌnoko poraꞌkooninge nanuuꞌ daankiarama eeꞌnoko nauvurima tee doorenang tampara tee muuꞌ Kumponing bakaang-koong; ");
INSERT INTO nas_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Eeꞌnoko teing nanaiꞌketa kenaanka nariꞌ, bakaning barevare-nupoong, eeꞌnoko niiꞌning manikuꞌ nariꞌ teie unaa-antavuruꞌning tanuaananka oreng-eta eeꞌnoko siipananka-ita; ");
INSERT INTO nas_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Aaꞌning: Meeriꞌ Maꞌdala-nani, maꞌnari ˜kenaanka-taa bataꞌuruꞌnani; eeꞌnoko Joana, teni Siusa baꞌaang, tee Eerotiꞌ bakaang pava tarevukoꞌnung; eeꞌnoko Susana eeꞌnoko napoꞌ niiꞌning manikuꞌ mmauꞌ biikaning mintoong-eta taamang avaarikoꞌ nariꞌ nanaama. ");
INSERT INTO nas_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Eeꞌnoko tenang nantoong karinga avuntevuntuꞌketa Jiisuuꞌanko naroꞌariruꞌnang teie mirumiruꞌke nau-antavurima aaꞌpuuꞌnung, ");
INSERT INTO nas_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Naning mintoong-koo sinang tanka-koo nanura tankavuko aaꞌnouꞌ: niiꞌning sinang taung-koo duaꞌariruꞌ, eeꞌnoko teka nantoonge mmemmeꞌaaruꞌ kauꞌke eeꞌnoko barenankai depeto porora tunturavauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eeꞌnoko niiꞌning sinang kapang-koo dau duaꞌariruꞌ eeꞌnoko dupurira teke maraꞌorouꞌ tompaꞌ otoaruioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eeꞌnoko niiꞌning tooꞌmurintaaꞌ otoroinooꞌ meuꞌ duaꞌariruꞌ, eeꞌnoko nariꞌ dupurira tooꞌmurintaaꞌke iinkenevuuꞌ tee keenkeeng. ");
INSERT INTO nas_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eeꞌnoko niiꞌning kansiꞌ pankauanooꞌ duaꞌarira teke dupuruꞌ eeꞌnoko sinang biꞌuruꞌ daakuꞌnaꞌ ookara-ita.” Teeꞌ minkuvura enang bokuma aaꞌpuuꞌnung, “Diiꞌ punkang-poꞌnupoong deekoꞌ enang taaraveriai!” ");
INSERT INTO nas_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Eeꞌnoko tenang bakaning barevare-nupoonge niaꞌaama aaꞌpaioꞌ, “Aung kara dikitoꞌ miruꞌnooꞌ aming?” teie aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Kumponinge diiꞌ bakaang kara pinkaꞌerimaing tauraꞌduruꞌnung makensiꞌnung-koo miruꞌnooꞌ noruꞌeriiꞌnaang tee-koo bakaang muuꞌkoo nkoaramanaꞌ, teka teing niiꞌning kara dikitoꞌ narunge nauaramaung aaꞌnoainaꞌ: ‘Ooaama ooaavaukaꞌ, taaravaama taaravaavaukaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Enang kara dikitoꞌ miruꞌ aung: Tee sinang tee Kumponing bakaang kara. ");
INSERT INTO nas_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Teing taung duaꞌariruꞌning miruꞌnooꞌ aung: Niiꞌning nantoonge kara taaravaako Sietaniꞌke poma pariꞌurikooꞌ tee kara biikaang domang-eta, maroita, masikaꞌantavaara domampariꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Teing kapang-koo duaꞌariruꞌning miruꞌnooꞌ aunge: Niiꞌning nantoonge kara taaravaama dotuariri kompaamaung, teka imaꞌariaꞌ. Batei okiꞌnamuꞌkoo masikaꞌantavaakooꞌ eeꞌnoko parapaara poko namuꞌke biikaang baito orariarakooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Teing tooꞌmurintaaꞌkoo kuung duaꞌariruꞌning miruꞌ aunge: Niiꞌning nantoonge kara taaravaama beroko amutemuriiꞌke iinkenevurimaung aaꞌninge noruꞌ mankiꞌnankai, kavonankai eeꞌnoko doturotunankai kansiꞌkooninge. Eeꞌnoko biikaang sinang natasiꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Eeꞌnoko teing kansiꞌ pankauang-koo duaꞌariruꞌning miruꞌnooꞌ aunge: Niiꞌning nantoonge tee kara taaravaama imaꞌai kompaakooꞌ tunsi paakavariaꞌ domang tampara ninka. Eeꞌnoko teing teeꞌ nariꞌ purimpariri otoroaining bera sinang biꞌuriai.” ");
INSERT INTO nas_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Teeꞌ nauvurira Jiisuuꞌke napoꞌ aung mirumiruꞌ nauvuruꞌ, “Naninge araka paroꞌura utaue dakaꞌpuarupeuꞌ niiꞌnooꞌ batanang-koo boong sipuarupeuꞌ, teka sirang batanang-koo panteꞌupeuꞌ teing tumpariaininge araka ooaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ookara kapooꞌ enang makempari otomaing damaꞌ siraꞌanta-koong. Eeꞌnoko ookutuning kapooꞌ nopaꞌariri otomaing teing damaꞌ dapaꞌnumpoꞌ. Nantoonge taaravaara noruꞌaavai. ");
INSERT INTO nas_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Teeꞌkoo tarerariaing diiꞌ taaraverimaing. Tee naning taaravura oroꞌantavuaing Kumponinge napoꞌ niiꞌning nauvuaing, eeꞌnoko baa tee taaravura oroꞌantavuaukaꞌnung pariꞌuaing tee araka otoꞌevuing-pinaꞌ noruꞌui otoing.” ");
INSERT INTO nas_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Teketa teꞌ Jiisuuꞌ baukorovo porouꞌnung tee oo-koo, teka tee-anko basi-koo makosiaavaruuꞌ karingai itoaioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Eeꞌnoko teinge Jiisuuꞌ taaravaakoꞌninge nauaama aaꞌpauꞌnung: “Daukorovo damaꞌdu donkonai daꞌ oo-koo piavoromang.” ");
INSERT INTO nas_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Teka teie aaꞌpuruꞌnung teing, “Teing ninge nkoꞌ eeꞌnoko ntaraꞌmainkaang makosinuka teing Kumponing bakaang kara taaravaama nkoaamaing.” ");
INSERT INTO nas_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Niiꞌnaꞌmung Jiisuuꞌke bakaning barevare-nupoong aaꞌpuruꞌ, “Nuaruꞌka amenkaꞌkoo pakoꞌmariai.” Teketa bakaasi-koo aaꞌearira tenkenauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Teketa beroma Jiisuuꞌ aasiꞌkoo duaꞌaruꞌ. Eeꞌnoko piong pankaing pouꞌ depeto teruꞌkoo, eeꞌnoko ntonge maantoꞌukoꞌ minki-antavuuꞌnaang-pinaꞌ nkovuma. ");
INSERT INTO nas_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eeꞌnoko teinge berora Jiisuuꞌ tanteauꞌnung aaꞌpaama, “Ovoring, Ovoring, niiꞌ enang keꞌnuruꞌmariiꞌnaang!” Eeꞌnoko tee tantearara piong eeꞌnoko tee booꞌa iꞌnuiꞌnung teing teka akaꞌpuretuꞌ, eeꞌnoko teke bakeareta pirung koontoꞌ tarorovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Teketa teie makuꞌurima aaꞌpuuꞌ, “Diiꞌ ee niꞌninka oꞌnori ning baitomeriaꞌ?” Eeꞌnoko teing avoreaama taꞌninauꞌnung biiꞌka kareaama aaꞌpauꞌ, “Aung eeꞌnung baa naning? Aaꞌninge taaravaakooꞌ: piong eeꞌnoko ntong botovuriko.” ");
INSERT INTO nas_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Teketaꞌ teinge Kaaleliꞌnameng-eta tee nuaruꞌ bakaasie pakoꞌaara Kerasaꞌnameng-koo tavoꞌariruꞌ Kaaleliꞌnameng ninka bariꞌeeresi otoinameensiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Eeꞌnoko teketa kansiꞌkoo siarako naninge Jiisuuꞌ kuneꞌuuꞌ osi pankamono-koonge maꞌnari-poꞌnunge. Mmauꞌ namuꞌpie koriaakoꞌ. Sieenai daiꞌaama nantoonge tanatavaakoꞌ, kauꞌkoo apasikaꞌ kaki-antavaama; ");
INSERT INTO nas_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Teka tee daiꞌnisi totoraꞌpaara maꞌnarie meeꞌboraꞌ sirakamaaꞌaape beꞌantavauꞌ. Teke pankaroong kuvinanka-koo otokoꞌ booꞌnuka dakoꞌdomai, pava-koo deeaꞌ, eeꞌnoko simpenoiꞌ otokoꞌ. Teie naninge Jiisuuꞌ kuneꞌuko Jiisuuꞌke tee maꞌnaang nauvuuꞌnung teieta bakoaraaꞌnaang; ");
INSERT INTO nas_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Eeꞌnoko Jiisuuꞌ taaravura tee bokuma boonko duaꞌarara kinkinuuꞌnung Jiisuuꞌkoo uroꞌkanooꞌ, eeꞌnoko aaꞌnaꞌ karoma aaꞌpuuꞌ, “Jiisuuꞌ, dake arekeeꞌ nkomeeꞌnaang ning, Kumponing Deto Basi Bauringe? Eentamaramaang dake ning toraꞌantameaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jiisuuꞌke niaꞌuma aaꞌpuuꞌ, “Daꞌ miring baa?” Eeꞌnoko teie aaꞌpuuꞌ, “Karinga.” Mmauꞌ maꞌnarie kurumaaꞌauꞌnung-koo teeꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eeꞌnoko teing nuuꞌariruꞌnung maꞌdinku˜nooꞌ duaꞌkoo botovuriarooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Eeꞌnoko teketa dueꞌke mmauꞌ pooroꞌnavontu meruꞌarima otorokoꞌ mii-koo navete-koo. Eeꞌnoko teing maꞌnari oreng Jiisuuꞌkoo eentavarikoꞌ tumpariiꞌnaang pooroꞌnavontu-koo. Eeꞌnoko teie tauraꞌpuruꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tee tee tenang maꞌnari naning-eta bakoarira pooroꞌnanka-koo tumpariruꞌ, eeꞌnoko tevontu pemue doonko kooꞌariruꞌ nuaruꞌkoo bera keꞌnuruꞌariruꞌ teke. ");
INSERT INTO nas_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tenang teing pooroꞌ bauꞌaarikoꞌninge ooaara kapooꞌ nkoaruꞌnung, mmariauꞌ teing, eeꞌnoko aung eeꞌ oroꞌ basiarioꞌ doorenang avitoitoi bereng-antavauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Teketa nantoong berouꞌnung ooaavaꞌnaang tee kapooꞌ nkoaruꞌnung. Eeꞌnoko Jiisuuꞌanko porora tee naning kuneꞌauꞌ maꞌnari teieta tenkenauꞌnung Jiisuuꞌkoo kauꞌkanooꞌ baꞌnanuioꞌ duaanavari eeꞌnoko noruꞌ matauari. Eeꞌnoko teing avoreauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eeꞌnoko teinge ooauꞌninge tee niiꞌning nauaarikoꞌ Jiisuuꞌke taare-antavuuꞌnaꞌ tee naning maꞌnarie kurunkeauꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Teketa tee ookara nantoonge Kerasaꞌnameensiꞌkooninge dueꞌke otorokoꞌninge niaꞌauꞌnung Jiisuuꞌ teing-ankoita tenkenuuꞌnaang pankainge avoroꞌke aporoꞌurioꞌ teing. Teketa tee napoꞌ bakaasi-koo aaꞌearuuꞌ toroaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Teie naninge maꞌnarie sipauꞌnunge niaꞌuuꞌnung Jiisuuꞌ nariꞌ otoreeꞌnaang tee ninka, teka teie potevuuꞌnung aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Dakanooꞌ osi tororarara tasiꞌantaveriaing Kumponinge baruꞌ deepoꞌ tampaꞌ nkoruinaꞌ.” Eeꞌnoko tee teketa tenkenura doorevurima nanuuꞌnung ookutunamono-koo teke osie Jiisuuꞌke baruꞌ deepoꞌ tampaꞌ nkovuuꞌnaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Teketa Jiisuuꞌ nuaruꞌke kato avetekaꞌkoo toroarako nantoong karingai onkeonkeꞌauꞌnung nempai otoko poioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eeꞌnoko teka narung naning tee-anko pouꞌ miring Jairus, pava dootuuꞌnava tanatanuka-koong narung, eeꞌnoko Jiisuuꞌanko kauꞌkanooꞌ kinkinura eentavaruꞌ bakanava-koo pava-koo pooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Aung tee baurang nani masikani otoꞌevukoꞌnung, teni mareꞌ kivora-ita kenaanka pankaꞌnooꞌkoo, teni eeꞌnani okiꞌnaruuꞌkuioꞌ. Jiisuuꞌ teni oo-koo beko nantoong karingai paampaꞌaakoꞌ itoveema. ");
INSERT INTO nas_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Eeꞌnoko teke nani manikuma otokoꞌ tarumatearakoꞌnani mareꞌ kivora-ita kemareꞌka-koo, aaꞌnani nankaiꞌnanka-koo ookara bakaang boorinang oꞌsiiviuꞌ, teka niiꞌnarai taare-antavuaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Teni Jiisuuꞌkoo damaꞌdu pora komparuꞌnung bakaang mononopaꞌkoong-koo kainuꞌkoo, eeꞌnoko namuꞌke ereng takevuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Tee baie ning komung?” Tenang ookara penkempariko Piitai aaꞌpuuꞌ, “Ovoring, daꞌ karingai kororai daꞌkoo iimparimang.” ");
INSERT INTO nas_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Teka Jiisuuꞌke aaꞌpuuꞌ, “Niiꞌnunge naninge taarevooꞌnaang komuioꞌ iriꞌ ning-eta tee-koo pareꞌarako mantompamira teeꞌ minkuamaang.” ");
INSERT INTO nas_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Eeꞌnoko tenang teni manikuma bakuꞌaravaruuꞌnung noruꞌarara teni dankurankuꞌarama pora kinkinuuꞌnung tee-koo uroꞌkanooꞌ, eeꞌnoko ookara nantoonge taaravaioꞌ siraꞌparuꞌnung arekeeꞌ komparuꞌnaꞌ eeꞌnoko namuꞌke taarevouꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ teni, “Ani ee, domang kuaaꞌdoi otoaing. Daꞌ dakaang baitoi taareroinani. Mooa ninka naniaing.” ");
INSERT INTO nas_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tenang teni ninka karoresi otoko narung naning pouꞌnung tee naning pava dootuuꞌnava-koo pankaing bakanava-ankoita. Pora aaꞌpuuꞌnung, “Daurang booꞌparing. Nau-anta tamung poreꞌantaveaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Teka Jiisuuꞌke taaravura tee aung nauvuma aaꞌpuuꞌ, “Aroreaukaꞌ, masikaꞌantaveko naroꞌ teni taarevooꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eeꞌnoko tenang tee pava-koo pora teie niiꞌning tauraꞌpuriaruuꞌ kuung tung-koo, teka Piita eeꞌnoko Jooni eeꞌnoko Jeemisi dovang eeꞌnoko baumararing tenie tauraꞌpuruꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Eeꞌnoko ookara birong-nupoong biromparima aiꞌnontuꞌariko oovurira aaꞌpuruꞌ, “Birontariaukaꞌ, aiꞌ ani teni booaꞌ, teka tamung aatumaang.” ");
INSERT INTO nas_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eeꞌnoko teinge benkempauꞌ tee, mono patorompuuꞌ aaꞌnani noruꞌai. ");
INSERT INTO nas_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Teka bireng teni-koong kompura teni bokuma aaꞌpuuꞌ, “Tootoꞌ daaꞌdaravai.” ");
INSERT INTO nas_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eeꞌnoko bakaang tanuaang tenang toroaruꞌ eeꞌnoko teni deto iꞌamparuꞌ namuꞌke. Eeꞌnoko kapooꞌ nai-koong avureeꞌnaang nauvuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Eeꞌnoko teni baumararing bakei taꞌninuretuꞌnung, teka teie orokovuretuꞌ niiꞌning nauaarearooꞌnaang kapooꞌ nkoaruꞌnung-koo teke. ");
INSERT INTO nas_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Eeꞌnoko Jiisuuꞌke teing bakaning barevare-nupoong nanaiꞌketa kenaanka naroꞌ bokuvurira iriꞌ avuruꞌnung makosi-antavurima maꞌnari amutemuriiꞌ bataꞌaariiꞌnaang eeꞌnoko siipananka taare-anta-koo. ");
INSERT INTO nas_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Eeꞌnoko teie botovuruꞌnung teing taare-anta nkoaama Kumponing bakaang muuꞌ daankiaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Eeꞌnoko teie aaꞌpuruꞌ teing, “Kapooꞌ nkaveriaukaꞌ nanirima: Donsiꞌ eeꞌnoko siirauꞌ niiꞌnooꞌ taamang niiꞌnooꞌ mooniꞌ. Eeꞌnoko mononopaꞌ kenaaꞌka ninka naniriaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Eeꞌnoko areva tuntariainava-koo teꞌ naroꞌ otoriai bera teꞌ osi siperiainooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eeꞌnoko areꞌ tokoo diiꞌ onkeonkeꞌdaariaukaꞌnooꞌ temono siperima temono-koong daꞌmong tankaveriaing diikaang peꞌnaaꞌketa, temono Kumponing-koo maarekusiꞌnamono taaꞌniꞌantaveri.” ");
INSERT INTO nas_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eeꞌnoko teing tenkenaara nanauꞌnung osinankai daankiaama tee doorenang tampara eeꞌnoko avitoitoi-koo siipa-poꞌnupoong taare-antavaarima. ");
INSERT INTO nas_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Enang teie Eerotiꞌke, temeensiꞌkoong ovoꞌmaꞌke taaravuuꞌnung ookara kapooꞌ Jiisuuꞌ bakaning ninka nkoauꞌning, eeꞌnoko papaaravaruꞌnung tee nantoonge avitoitoi minkuaako. Niiꞌninge aaꞌpaakoꞌ, “Jooni napoꞌ daaꞌaring bouꞌnooꞌketa.” ");
INSERT INTO nas_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Napoꞌ niiꞌninge aaꞌpaakoꞌ, “Tee Eliasi poaing-koong tavoꞌaring.” Eeꞌnoko niiꞌninge eeꞌ minkuaakoꞌ, “Niiꞌnung pa Kumponing-etaing urikupoong nakaro-nupoong-koo daaꞌaring.” ");
INSERT INTO nas_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eerotiꞌke aaꞌpuuꞌnung, “Jooni tee ning botomarioꞌ kuru napuꞌauꞌnung. Teka tee baa aung teeꞌ naumaarimaang?” Eeꞌnoko teie taung Jiisuuꞌ oo-koong besiꞌuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Teketa botovuruꞌnooꞌketa toroarira kara okovuri nkanukai Jiisuuꞌ nauaakoꞌnung kapooꞌ teinge nkoauꞌning. Eeꞌnoko teie bokuvurira teing tontaꞌariruꞌ biiꞌka otorooꞌnaang osinamono-koo miring Besaida. ");
INSERT INTO nas_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tenang karikaꞌke noruꞌaara tee teinge siompauꞌ Jiisuuꞌ, eeꞌnoko teie onkeonkeꞌuruꞌ teing, eeꞌnoko kara nauvuruꞌ Kumponing bakaang muuꞌkoong. Eeꞌnoko taare-antavuruꞌ teing siipa-nupoong. ");
INSERT INTO nas_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Enang doong oparama nanuko teing bakaning barevare-nupoong nanaiꞌketa kenaanka porora aaꞌpauꞌ tee, “Aing nantoong karikaꞌ botoveriko osinanka anketa dueꞌ otoroining-koo berora aasiꞌdoma eeꞌnoko taamananka ooaavai, aiꞌ niiꞌ anke tee tamung meeꞌboraꞌ sirakamaaꞌkoo oꞌnoring.” ");
INSERT INTO nas_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Teka teie aaꞌpuruꞌnung teing, “Diiꞌke kapooꞌ averereriko naiaavaing.” Eeꞌnoko teinge aaꞌpauꞌ, “Niiꞌ paꞌnokoꞌnuri bereteꞌ eeꞌnoko keura taviꞌning naing otoꞌmemuring, daua otoaꞌ. Taamang mmauꞌ mooꞌampiri dei makotupeuꞌ aing ookara karikaꞌ bauꞌkoo dake tampeko deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aing-koo teing deerunooꞌ donkaang naing paꞌnokoꞌ kokoreiꞌpinaꞌ otorouꞌnung teke. Eeꞌnoko teie aaꞌpuruꞌ bakaning barevare-nupoong, “Navitunaꞌ baꞌnang-antavereriai, naruaape-pinaꞌ navitu-koo.” ");
INSERT INTO nas_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eeꞌnoko teinge teeꞌ nkoaarima doonko baꞌnang-antavaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Eeꞌnoko Jiisuuꞌke teing paꞌnokoꞌ bereteꞌ eeꞌnoko taviꞌning keura nkavura tee ankamparuꞌ deto paning-aape eeꞌnoko biraanke-antavura pisiꞌuruꞌ teing. Eeꞌnoko avuruꞌ teing bakaning barevare-nupoong tankeeꞌaariiꞌnaang nantoong karikaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eeꞌnoko ookara taamanaara poovorouꞌ. Eeꞌnoko kakitaꞌnanka sipaaruꞌning kivora-ita kevekuꞌka pekuꞌ maantoꞌantavauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Niiꞌnaꞌmung Jiisuuꞌ baka kunsiarama eeꞌnoko bakaning barevare-nupoong nariꞌ otoroitaaꞌ niaꞌuruꞌnung teing aaꞌpuma, “Ning baa nantoonge tammaamaung?” ");
INSERT INTO nas_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eeꞌnoko teinge makuꞌaama aaꞌpauꞌ, “Niiꞌninge Jooni tee minkinara tantaamaung, eeꞌnoko niiꞌninge tee Eliasi poaing-koong tantaamaung, eeꞌnoko niiꞌninge urikupoong nakaro-nupoong-koong narung booꞌketa daaꞌaruꞌnung tantaamaung.” ");
INSERT INTO nas_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eeꞌnoko napoꞌ teie aaꞌpuruꞌ teing, “Teka diiꞌke ning baa tammerimaung?” Eeꞌnoko Piitai bariꞌuma aaꞌpuuꞌ, “Daꞌ aaꞌ tee Kumponinge teroita Pakoꞌpariꞌniiꞌ nantoong domamperira tareveriainooꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Teka Piitai Jiisuuꞌ tee Pakoꞌpariꞌniiꞌ tampuioꞌ Jiisuuꞌke niiꞌnung naning nau-koo aaꞌnaꞌ orokovurima aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Ning Tee Naning˜naumpoꞌ Paning-etaing teing amutemuriiꞌ arikananka toraꞌpampaing, eeꞌnoko aing aaꞌninge tompimaavaing: pankenukai, piristiꞌkoong ovontunukai eeꞌnoko boto naunukai, eeꞌnoko tee dupisiꞌmaavaing. Teketa beenang doong tankinuko napoꞌ domamarara daaꞌmaravaing.” ");
INSERT INTO nas_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Eeꞌnoko teie napoꞌ aaꞌpuruꞌ teing ookara, “Naning ning siomui pooꞌnaang piavora deekoꞌ, baka bakaang pia iroꞌ doonko tompimparavaing eeꞌnoko doong kante bakaang aaꞌbarataꞌ poruꞌui ning siomumaatoaing. ");
INSERT INTO nas_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Eeꞌkoo, baa tee naning bakaang domaang ning-koo orokovuma baka tare-koo piavoaing tee paaꞌaravaing, teka baa tee naning bakaang domaang ning-koo arooꞌari duaꞌuaing tee domamparavaing. ");
INSERT INTO nas_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Naninge kapooꞌ ookara kansiꞌkooning barampui okovura bakaang domaang daroveꞌari paaꞌarako teinge arekeeꞌ pakuaapeuꞌ? Eeꞌnoko naning aming avupeuꞌ tee bakaang domaang paaꞌaruꞌnung napoꞌ mooꞌkoo? ");
INSERT INTO nas_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Napoꞌ baa tee naning nkaang miring siraꞌkoo maiaꞌomaung eeꞌnoko nkaang kara-koo, tee-koo naning-koo ning Tee Naning-naumpoꞌ Paning-etaing tee maiaꞌmoaing tenang moainang nkaang meenasi ninka eeꞌnoko Mmaꞌ bakaang meenasi ninka eeꞌnoko teing koosinunanka meekupoong biikaang. ");
INSERT INTO nas_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Teka ninge masikung naurampimang, niiꞌning nantoong anke nariꞌ donkonai otoroining teing booꞌkoo toraꞌkaavaꞌ muuꞌ Kumponing bakaang taaꞌniꞌpoi otoko ooaavaing.” ");
INSERT INTO nas_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Enang aung minkuvuuꞌnooꞌketa ˜beenang-taa doong-pinaꞌ tankinuko teie aing aaꞌning bokuvurira berouꞌ: Piita, Jooni, eeꞌnoko Jeemisi nariꞌ, iuꞌkoo deto teke kunsi-koo. ");
INSERT INTO nas_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eeꞌnoko tenang tee kunsiarako aasiꞌke Piita dovang tavuruꞌ. Teketa Jiisuuꞌ mmeꞌ kunsiaritaaꞌ bakaang oing oroꞌnooꞌ aampariꞌaruꞌ eeꞌnoko bakaang mononopaꞌ kakaara sisisiisi deemparuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Eeꞌnoko tenang kenaanka naninka taꞌninaꞌ paning-etaing meenasi ninka oroꞌpareta tee ninka kareaakoꞌ aaꞌnaanka Moosesi eeꞌnoko Eliasi. Eeꞌnoko Kumponing bakaang miruꞌ dupevui Jiisuuꞌ booꞌparavainaꞌ teke Jerusalemaꞌke minkuaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Enang tee Jiisuuꞌ ninka minkuai otoko Piita dovange tantearira Jiisuuꞌ bakaang meenasi ooauꞌ eeꞌnoko tenaanka naninka tee ninka donkonuresioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Eeꞌnoko tenang tenaanka naninka Jiisuuꞌankoita tenkeng-aapeareko Piitai Jiisuuꞌ aaꞌpuuꞌ, “Ovoring ee, bakei tampaꞌ niiꞌ anke oꞌnorimaang. Aiaꞌ niiꞌke beevaari bare kaniampiai, nava daꞌ dakanava, nava Moosesi bakanava eeꞌnoko nava Eliasi bakanava.” Botu noruꞌuaꞌ, tamung teeꞌ minkuvukoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Eeꞌnoko tenang Piitai teeꞌ minkuvuko kamoꞌke pora dakaꞌpuruꞌ teing, eeꞌnoko avoreauꞌ kaꞌmoꞌke kuung deempurioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eeꞌnoko teieta kamoꞌketa auronge karoma aaꞌpuuꞌ, “Aung tee nnuring, ninge piaavansi miruꞌantuꞌnung. Taaraveriaing tee.” ");
INSERT INTO nas_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Eeꞌnoko tenang aurong karoioꞌ Jiisuuꞌ baka otoko ooauꞌ. Eeꞌnoko teinge teing doong-koo makempauꞌ naning nauaavaꞌ kapooꞌ teinge ooauꞌning bera Jiisuuꞌ booꞌketa daaꞌaruꞌnooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Teketa daunaꞌmung iuꞌketa siarira poroioꞌ nantoong mmauꞌke kuneꞌauꞌnung tee Jiisuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eeꞌnoko naninge karikaꞌkoo meuꞌketa bokuma Jiisuuꞌ aaꞌpuuꞌ, “Nau-anta, eentamaramaang daꞌkoo nnuring ooveeꞌnaang aiꞌ tee tee narung masikung nnuring. ");
INSERT INTO nas_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Eeꞌnoko daꞌmaikoꞌ namuꞌke teie maꞌnaange korivuko taꞌninaꞌ bokukooꞌ. Teie nuanua-antavuma bera kaꞌbuaira-antavukooꞌ napoꞌ mapou-antavuma˜, eeꞌnoko daꞌdeng sipuarukooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eeꞌnoko eentamaring dakaning barevare-nupoong-koo bataꞌaavaꞌnaang, teka teing makosiaavaruing.” ");
INSERT INTO nas_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuuꞌ, “Nko diiꞌ masikaꞌanta otoriainge, koontariaing, areꞌ basinaroonge diiꞌ ninka nariꞌ oꞌnorimaatoainge dooroontampiri? Poꞌantaveai tee dauring aꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Teketa tenang tee nemaka Jiisuuꞌanko poko teie maꞌnaange papaara-antavura nuanua-antavuuꞌ. Teka Jiisuuꞌke akaꞌpuuꞌ tee maꞌnaang orara, eeꞌnoko unaa-antavura tee nemaka bauma napoꞌ avuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Eeꞌnoko ookara asikovuruꞌ Kumponing aaꞌnaꞌ pankaing tasiꞌpaara. Teka taꞌninaara karakaraarearima Jiisuuꞌ daangampaako ookara kapooꞌ nkovuuꞌning-koo teie teing bakaning barevare-nupoong aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kara aing pinkaꞌeriaining: Ning Tee Naning-naumpoꞌ Paning-etaing tee nkaning-koo navumainuka-koo narunge tooka kompui tauraꞌmuuꞌnaang nantoong oreng biikaang bireng-koo.” ");
INSERT INTO nas_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Teka teinge tasiꞌpaavaꞌ tee teeꞌ minkuvuuꞌnung kapooꞌ teing-koo bakuꞌnisi deemparako teinge tasiꞌpaaꞌneeng-koo, eeꞌnoko teinge avoreaara niaꞌaavaꞌ tee aung anaare kara. ");
INSERT INTO nas_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Eeꞌnoko teketa biiꞌka tataꞌeekoꞌ aaꞌpaama, “Niiꞌkoo baa pankaing?” ");
INSERT INTO nas_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Teka Jiisuuꞌke biikaang domang-koong noruꞌ noruꞌura teie narung tootoꞌ nkavura tee-anko donkong-antavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Eeꞌnoko aaꞌpuruꞌ teing, “Baa tee naning ning nkaang miring-koo aung tootoꞌ okiꞌnara onkeonkeꞌuaing teie tee ning onkeonkeꞌmuaing, eeꞌnoko baa tee ning onkeonkeꞌmuaing teie tee onkeonkeꞌuaing tee ning botomuuꞌnung, aiꞌ tee naning diiꞌkoo meuꞌke okiꞌnara-pinaꞌ otoaing tee tee diiꞌkoo pankaing.” ");
INSERT INTO nas_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Joonie bariꞌuma aaꞌpuuꞌ, “Ovoring, niiꞌke ooampiring naning narung maꞌnari bataꞌuriko dakaang miring-koo eeꞌnoko niiꞌke poteampiri tee niiꞌ ninka nariꞌ daꞌ siontuaung-koo.” ");
INSERT INTO nas_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Teka Jiisuuꞌke aaꞌpuuꞌ tee Jooni, “Orokoveriaukaꞌ tee, aiꞌ tee naning diiꞌ turanturiaung tee diiꞌ pakururimaung.” ");
INSERT INTO nas_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tenang Jiisuuꞌ bakaang doong dueꞌuioꞌ Kumponinge paning-aape boku-koong Jiisuuꞌ Jerusalemaꞌaape beꞌkoo deravaruꞌ. ");
INSERT INTO nas_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Eeꞌnoko teie kara nkanuka tutung uroꞌke botovurioꞌ Sameriaꞌkoonavuntuꞌkoo berouꞌnung Jiisuuꞌ bakaning ninka aasiaavainooꞌ maamu-antavaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Teka nantoonge onkeonkeꞌaavaruuꞌnung tee Jiisuuꞌ, biikanooꞌ meepoꞌ okiꞌnaa-antavuing-pinaꞌ Jerusalemaꞌaape nanuaing deemparako. ");
INSERT INTO nas_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Eeꞌnoko tenang bakaning barevare-naankai oovureta, aaꞌnoko Jeemisi eeꞌnoko Jooni, aaꞌpuretuꞌ, “Ovoring, dake ee neeꞌ pia-antameremang ntaꞌ paning-eta bokuampeko siarara opuri taivuriainaꞌ aing Eliasie nkovuuꞌna?” ");
INSERT INTO nas_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Teka teie bereꞌarara orokovuretuꞌnung tenaanka aaꞌpurema, ");
INSERT INTO nas_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","“Deeꞌke noruꞌereaꞌ aremuriiꞌ tanuaang deeꞌ otoꞌderureng, aiꞌ ning Tee Naning-naumpoꞌ Paning-etaing nantoong orari-koo moaꞌ, teka nantoong domang-anta-koo mouꞌnung.” Eeꞌnoko teing teketa niiꞌnamono-koo berouꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eeꞌnoko taunge beroma naninge Jiisuuꞌ aaꞌpuuꞌnung, “Ninge tee daꞌ siontampaing areꞌ tokoo daꞌ beainooꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Teka Jiisuuꞌke makuꞌuma aaꞌpuuꞌ tee, “Nkaunanka biikaning kumpenanka otoꞌevoromaung, eeꞌnoko barennanka auviꞌau-kooning biikaning bitonanka, teka ning tee Naning-naumpoꞌ Paning-etaing tokoo boreꞌ patuꞌmaravainooꞌ otoꞌmemuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Napoꞌ Jiisuuꞌke niiꞌnara aaꞌpuuꞌ, “Ning siomeaing dake.” Teka teie aaꞌpuuꞌ, “Ovoring, ioꞌ tauraꞌmeko mmaꞌ dakoꞌampainooꞌ basinooꞌ mmaꞌ ninka oꞌnoreaing, eeꞌnoko mmaꞌ dakoꞌamiraiꞌnange daꞌ siontampai.” ");
INSERT INTO nas_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Teka Jiisuuꞌke aaꞌpuuꞌ tee, “Siperiko booꞌnukai biiꞌka booꞌnuka dakoꞌaariaing, teka daꞌ aaꞌdamaang: Bera daankieaing tee Kumponing bakaang muuꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Niiꞌnunge napoꞌ aaꞌpuuꞌ, “Ninge tee daꞌ siontampaing, Ovoring, teka iroꞌ tauraꞌmeko tutung siꞌnooraꞌarampaing nkanooꞌnupoong.” ");
INSERT INTO nas_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Teka Jiisuuꞌke tororeeꞌarama-nanuꞌ kenkumpura aaꞌpuuꞌ tee, “Tee naning mintoong-koo mmeꞌ komparama torotoroarapeuꞌnung teeꞌ oroꞌ tee, naning makotuaꞌ Kumponing bakaang muuꞌkoo mintoomparaaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Teketa Jerusalemaꞌaape deto nariꞌ nanaavaꞌnaang piavora Jiisuuꞌke naruaape-ita kenaiꞌka miruꞌurira kenaankanaꞌ botovuruꞌ osinanka beeroꞌaari nanaavaꞌnaang uroꞌke. ");
INSERT INTO nas_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Eeꞌnoko teie aaꞌpuruꞌ, “Sinang tee bakei aaꞌnaꞌ meuraꞌpuing, teka kavuꞌnupoong okiꞌning, teeꞌkoo kunsirariaing sinang kavuꞌkoo Ovoringe kavuꞌnupoong botovuriainaꞌ tee-koo bakaang mintoong-koo. ");
INSERT INTO nas_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aiaꞌ beriai naurampirinaꞌ. Aing ee, ninge tee diiꞌ sipisipiꞌkoo kampianu-pinaꞌ botorampimang nkaunanka-koo meuꞌke botorampipeuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kereka dovang siirauꞌ nkaveriaukaꞌ, boonamante˜ nkaveriaukaꞌ. Nantoong ninka taunge minkurariaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Areva pava diiꞌ tuntariainava tutung aaꞌperiai: Tampara! Mooa diiꞌkoo ava-koo otoaing. ");
INSERT INTO nas_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Eeꞌnoko naning mooa bauko teke otoko deekoꞌ diikaang mooa tee-koo keemparavaing. Teka diiꞌ taara-koo kasiaavaruko deekoꞌ tee diikaang biraanke napoꞌ diiꞌkoo toroaravaing. ");
INSERT INTO nas_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Eeꞌnoko teva nava-koo otoriai taamanirima tuaantarima kapooꞌ teinge araariaining ninka, aiꞌ teie naninge mintoomparamaunge tee teeꞌ bakaang mooꞌ nka-koo makosi. Pava paareveriaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Arenang tenang diiꞌ osi navuntuꞌkoo duꞌdariko onkeonkeꞌdaarima taamang araariaing naieriai. ");
INSERT INTO nas_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Siipa-nupoong taare-antaverererima teing ookara aaꞌpereriai, ‘Tee muuꞌ Kumponing Bakaang diiꞌkoo dueꞌ poing.’ ");
INSERT INTO nas_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Teka arenang diiꞌ duꞌdariko osinamono-koo onkeonkeꞌdaariaukaꞌnung deekoꞌ osi-koo meuꞌ berira aaꞌperiai, ");
INSERT INTO nas_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Aung diikaang daꞌmong niiꞌkoo peꞌnaaꞌkoo naꞌnampuing tankamarimang amono Kumponing-koo maarekusiꞌnamono taaꞌniꞌanta-koo. Bane taaramerereriaꞌ teka diiꞌke noruꞌeriaing Kumponing bakaang muuꞌ diiꞌkoo dueꞌ poing.’ ");
INSERT INTO nas_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ninge naurampimang diiꞌ, teing enang onkeonkeꞌdaariaukaꞌning teing doong asiꞌnaꞌmung kiimata toraꞌpaavaining, Sodom-navuntuꞌ ntaꞌke paning-eta pora taivuruꞌnung-koo dau basinooꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Bakaꞌe piaaruꞌnuka diiꞌ Korasin-nupoong, toraꞌkiriaining. Piaaruꞌnuka diiꞌ Besaida-nupoong, diiꞌ toraꞌkiriaininge, aiꞌ diiꞌ teing kapooꞌnanka iriꞌpoꞌning taꞌnimpaariiꞌnanka diiꞌkoo nkoaruꞌning ooverima bereꞌdariaruuꞌ. Teinge Juꞌdeeaing Saidoniꞌnupoong eeꞌnoko Taiaꞌnupoonge ooaara dei namuꞌke bereꞌaripeuꞌ, sipunge pooꞌarima mononopaꞌ orarunsi-koong kurumparipeuꞌ bereꞌariruꞌnung-koo taaꞌniꞌantavarima. ");
INSERT INTO nas_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Teka aaꞌdampimang, teꞌmung Kumponinge nantoong kiimatavuriainaꞌmung diiꞌke dau basinooꞌ toraꞌperiaing Taiaꞌ naankai eeꞌnoko Saidoniꞌ toraꞌpureainooꞌketa. ");
INSERT INTO nas_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eeꞌnoko diiꞌ Kapaneumeꞌnupoong deto paning-koo basirariaining-pinaꞌ daang noruꞌdarimaing. Diiꞌ aaꞌ doonko nekipaꞌnooꞌkoo sing-antaruriaining.” ");
INSERT INTO nas_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Eeꞌnoko teing bakaning naruaape-ita kenaiꞌka nanaavaꞌnaang botovurima napoꞌ aaꞌpuruꞌ, “Baa tee naning diiꞌ taararurimaatoainge tee ning nariꞌ taaramumatoaing. Eeꞌnoko tee naning diikaang kara dimpaꞌumaatoainge teie tee ning nkaang kara dimpaꞌumaatoaing. Eeꞌnoko tee ning nkaang kara dimpaꞌumaatoainge tee ning botomuuꞌnung bakaang kara teeꞌ nariꞌ dimpaꞌumaatoaing.” ");
INSERT INTO nas_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Teketa tee Jiisuuꞌke teing naruaape-ita kenaiꞌka tee botovurioꞌ nanaakotaaꞌ doturotu narung ninka toroariruꞌnung aaꞌpaama, “Ovoring ee, siipa narung deeaꞌ maꞌnarinanka apooꞌarampirieenge dakaang miring ninka.” ");
INSERT INTO nas_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eeꞌnoko teie aaꞌpuruꞌ teing, “Ninge ooansioꞌ Sietaniꞌ paning-eta depeto piping-pinaꞌ duaꞌaruꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aing ee, ninge tee diiꞌ purintoꞌ arompiring boruꞌnanka eeꞌnoko munkeitananka mmeꞌkoong eeꞌnoko ookara iriꞌ Sietaniꞌnung puruꞌkoong, eeꞌnoko diiꞌ teing kapooꞌke baikeruriaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Teka tee diiꞌ baruꞌ doturariaukaꞌnung tee-koo, aaꞌnoko maꞌnarinanka diiꞌkoo boong otoroinooꞌkoo, teka doturariaing diikaang miring paning-koo daariari otoinooꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tenang teing naruaape-ita kenaiꞌka toroarira minkuaako tee-koo batei-koo Tanuaang Meekunge Jiisuuꞌ dotu-antavuioꞌ aaꞌpuuꞌ, “Mmaꞌ ee, tampara tantamang daꞌ Ovoring paning-koong eeꞌnoko kansiꞌkoonge, Dake aaꞌnouꞌnung-koo: Dake tee doorenang tampara bakuꞌeuꞌnung-koo teing-koo aaꞌning-koo matau-poꞌnupoong eeꞌnoko noruꞌpoꞌnupoong eeꞌnoko siraꞌpeuꞌ teing-koo tootoia-koo. Teing nantoong piaaveri piarouꞌnaꞌ teeꞌ. Eeꞌ, Mmaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Eeꞌnoko nantoong karavurima aaꞌpuruꞌ, “Ookutunung kapooꞌnanka tee Mmaꞌke pareꞌmuuꞌnung eeꞌnoko naning otoaꞌ ning Tee Bauring noruꞌmui otoing, Mmaꞌke deekoꞌ noruꞌmui otong. Eeꞌnoko napoꞌ naning otoaꞌ Mmaꞌ noruꞌui otoing, teka ninge Bauringe deekoꞌ noruꞌansi oꞌnong. Eeꞌnoko nantoong teing naing ninge Bauringe miruꞌarampaining-koo oroꞌantavanko noruꞌaavaing tee.” ");
INSERT INTO nas_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tenang barevare-nupoong-anko bereꞌarara biiꞌkamaiꞌ otoroi aaꞌpuruꞌ, “Biraanke-nupoong teing nantoong ookaavaining diiꞌke ooverimaing-koo. ");
INSERT INTO nas_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aiꞌ ninge tee naurampimang, karingai-nakaro-nupoong eeꞌnoko dauraronuka-oo-koo piavorokoꞌ ninge kapooꞌ nkoanko enang ooverimanaꞌ, eeꞌnoko tee ooaavarukoꞌ. Eeꞌnoko taara-koo piavorokoꞌ kapooꞌ daankianko diiꞌke taaraverimaing, eeꞌnoko tee taaravaavarukoꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Eeꞌnoko narunge boto-naue donkonura paaravuma aaꞌpuuꞌ, “Nau-anta, ninge aming nkoamira domaang oparavaung okomuaing?” ");
INSERT INTO nas_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jiisuuꞌke aaꞌpuuꞌ, “Aming tee Moosesi-nung boto-koo daariari otong? Arekeeꞌ deeruemaunge?” ");
INSERT INTO nas_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eeꞌnoko teie makuꞌuma aaꞌpuuꞌ, “Dake pankaruntoompeaing Ovoring dakaang Kumponing ootukunung dakaang domang-eta eeꞌnoko ootukunung dakaang uraang˜eta eeꞌnoko ootukunung dakaang purintoꞌketa eeꞌnoko ootukunung dakaang onou-eta, eeꞌnoko tee naning daꞌkoo dueꞌnung daka nariꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ tee, “Dake tampaꞌ bariꞌmeing. Teeꞌ nkovera daꞌ domantaravaing.” ");
INSERT INTO nas_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Teka teie maiaꞌ dakaꞌkoo piavoma aaꞌpuuꞌ tee Jiisuuꞌ, “Eeꞌnoko baie tee naning ning-koo dueꞌnung miruꞌari otoing?” ");
INSERT INTO nas_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jiisuuꞌke makuꞌuma aaꞌpuuꞌnung, “Naning Juꞌkoo narung Jerusalemaꞌketa Jerikooꞌnavuntuꞌaape doonko bekoꞌnung eeꞌnoko bakisipunuka-koo maamunooraꞌkoo dau basiaruꞌnung. Teinge muraꞌaama ookara kapooꞌ teka kiruꞌaara tenkenauꞌnung okiꞌnaruuꞌkuioꞌ. ");
INSERT INTO nas_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Teketa tee narung piristiꞌ tevunge doonko bema tee oovura baariꞌui niiꞌnamenge beuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Teeꞌ nariꞌ napoꞌ narunge Liivaiꞌke bakanamuiaang-koonge pora teka oovura tee, teie napoꞌ baariꞌuuꞌ niiꞌnamenge. ");
INSERT INTO nas_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Teka narung diiꞌke munteꞌererimaing-koong, Sameriaꞌkoong, nanuma teꞌ pouꞌnung tee otouꞌnooꞌ, eeꞌnoko teie oovura piaavuuꞌnung tee. ");
INSERT INTO nas_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eeꞌnoko tee-anko bera tekaꞌpauꞌnairu daiꞌuuꞌ, duunie eeꞌnoko uaini dovange sisiꞌuma, teketa bakanavoroꞌ doonkiiꞌnavoroꞌkoo baꞌnang-antavura poꞌnupoꞌnuka biikanava-koo beꞌantavuuꞌ eeꞌnoko teka tarevuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Eeꞌnoko daunaꞌmung poꞌnupoꞌnuka biikanavaꞌ tarenara keura kiinaꞌning avuma aaꞌpuuꞌ, ‘Aung tareveaing dake, eeꞌnoko arekeeꞌning aing-koo daua duaꞌeaining aung tarevema damaꞌke mora makuꞌdampaing.’ ");
INSERT INTO nas_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Emuꞌ baa teing-koo aing-koo beenaumo-koo dake noruꞌei, naning tee-koo dueꞌnung-pinaꞌ tasiꞌparing maamunooraꞌkoo tavauꞌnung-koo?” ");
INSERT INTO nas_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Eeꞌnoko teie boto naunuka-koonge aaꞌpuuꞌ, “Tee narung tee piaa oroꞌantavuuꞌnung tee-koo.” Eeꞌnoko Jiisuuꞌke tee aaꞌpuuꞌ, “Bera teeꞌ nariꞌ nkoveaing.” ");
INSERT INTO nas_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Enang tee teketa taunge nanaama niiꞌnamono-koo osi basiariko nanie manikumai miring Maataꞌke Jiisuuꞌ onkeonkeꞌura bokuvuuꞌnung bakanava-koo. ");
INSERT INTO nas_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Eeꞌnoko anie tee baaraꞌmaꞌnaang nani otokoꞌnung bakaang miring Meeriꞌ, teni Jiisuuꞌkoo kauꞌkanooꞌ baꞌnanura baroromparakoꞌnani bakaang nau-anta-koo. ");
INSERT INTO nas_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Teka Maataꞌke taamang avutevuꞌ maamu-antavuma tapotapoarama noruꞌ baavaꞌaruꞌ, eeꞌnoko tenie Jiisuuꞌanko bera aaꞌpuuꞌ, “Ovoring ee, daꞌ ee taraꞌdoaꞌ otong ani ntaraꞌmaꞌnaang ning siꞌmuinani? Ning ninka poreꞌmomaang. Dake naueko pakumuai.” ");
INSERT INTO nas_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Teka Ovoringe makuꞌuma aaꞌpuuꞌ teni, “Maataꞌ, Maataꞌ, daꞌ poreꞌdomaang avitoitoi noruꞌdarama avutevuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kapooꞌ narung masikung daꞌ piaropeuꞌnung otong. Meeriꞌ teni tee kapooꞌ tampara bamparinani pariꞌkoo makosinamuriiꞌ deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Niiꞌnooꞌke tee Jiisuuꞌ niiꞌnaꞌmung kunsiarakoꞌnung. Eeꞌnoko tenang bakearako bakaning barevare-nupoong-koo narunge aaꞌpuuꞌ, “Ovoring, naumeriai kunsi bakanaꞌ Joonie bakaning barevare-nupoong nau-antavuruꞌnaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ teing, “Tenang kunsirarima aaꞌperimatoaing: Niuma paning-koo otomaung, dakaang miring meekaꞌantavari otoaing; dakaang muuꞌ poꞌantaveai; dakaang pia nkoaravaing anke kansiꞌkoo paning-koo nkoaramanaꞌ nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Doong kante-koo taamang makosinaꞌ amerimaatoai; ");
INSERT INTO nas_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Eeꞌnoko tontaꞌmemuriai niikaning orarananka, niiꞌke niiꞌka tontaꞌevorompimaung-koo teing niiꞌ orakaꞌ nkomaarimaing. Eeꞌnoko parapaara-koo siꞌmeriaukaꞌ, teka tontaꞌantameriai teieta naning orara bakaang purintoꞌketa.” ");
INSERT INTO nas_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Eeꞌnoko Jiisuuꞌke bakaning barevare-nupoong aaꞌpuruꞌnung, “Diiꞌkoo narung daꞌmaikoꞌ otoꞌderupeuꞌnung eeꞌnoko meuꞌnamang tee-anko bera aaꞌpepeuꞌ, ‘Mmaikoꞌ ee, ioꞌ taamang-koo beekuri ameai. ");
INSERT INTO nas_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Naning narung mmaikoꞌ isipoꞌketa ning-anko poing eeꞌnoko ning kapooꞌ otoꞌmemuaꞌ tee avompaing.’ ");
INSERT INTO nas_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eeꞌnoko daꞌmaikoꞌke kuung-eta eeꞌ bariꞌdupeuꞌ, ‘Ning poreꞌantameaukaꞌ. Karanaang tero daꞌmariring eeꞌnoko nnurukaaꞌ nariꞌ aatumpiri otong niiꞌdaang. Ning deto daaꞌkoo makosi deeaꞌ daꞌ kapooꞌ avuꞌkoo.’ ");
INSERT INTO nas_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Teka ninge eeꞌ naurampimang, tee tee tamung daaꞌaravarupeuꞌ kapooꞌ aruuꞌnaang bane daꞌmaikoꞌke, teka tee dake ereanavei otoko deekoꞌ daaꞌarara teie arupeuꞌ aming kapooꞌ ookara piaropeuꞌning. ");
INSERT INTO nas_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Eeꞌnoko ninge aaꞌdampimang, Eentarariai aruriainaꞌ. Besiꞌeriai daaꞌeriainaꞌ. Kopikopiꞌeriai karanaang daateꞌderuriainaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aiꞌ ookara nantoonge eentavarimainge tee nkavaamaung, eeꞌnoko besiꞌaamainge tee daaꞌaamaunge, eeꞌnoko karanaang kopikopiꞌaamaing teinge daateꞌevurimaunge. ");
INSERT INTO nas_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","Diiꞌkoo baa dauring-poꞌnung dauringe taamang eentaruko dei dake ee kapang avepeuꞌ, niiꞌnooꞌ taviꞌ eentaruko dake ee boruꞌ avepeuꞌ, niiꞌnooꞌ sinkaaꞌ eentaruko dake ee munkeita avepeuꞌ? Otoaꞌ! ");
INSERT INTO nas_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tee tee diiꞌke orenge diurukaaꞌkoo tampaꞌ avuavuꞌ nkoverimaung deekoꞌ noruꞌeriaing Kumponinge tee Niumai paning-koonge Tanuaang Meekung tampaꞌ masikaꞌ aruriaing diiꞌ tee-koo eentarariaining.” ");
INSERT INTO nas_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Enang tee Jiisuuꞌke maꞌnaang amako-anta nkovukoꞌnung bataꞌuuꞌnung. Tenang tee maꞌnaang tenkenuko tee naning karouꞌ. Eeꞌnoko nantoong taꞌnimpariruꞌ karakararearima. ");
INSERT INTO nas_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Teka niiꞌninge aaꞌpaakoꞌ, “Aunge tee Kopeu bakaang purintoꞌke maꞌnari bataꞌurimaung, tee maꞌnari biikaang pankaing.” ");
INSERT INTO nas_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Teeꞌ minkuaako napoꞌ niiꞌninge paara-antavaama aaꞌpauꞌ, “Taaꞌniꞌanta paning-etaing naumeriaing tee purintoꞌ kompei otoing Kumponing-etaing deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Teka teie biikaang onou tasiꞌpura aaꞌpuruꞌnung teing, “Ookara muuꞌnanka biiꞌka siivenkeꞌarimaing kare-nupoonge pini daakoꞌaarimaung, eeꞌnoko tee puataꞌ siivenkeꞌarimaung teie duaꞌarimaunge. ");
INSERT INTO nas_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Eeꞌnoko Sietaniꞌ teeꞌke, baka siivenkeꞌari dei arekeeꞌ bakaang muuꞌ napoꞌ donkonui nariꞌ otopeuꞌ? Diiꞌke aaꞌmerimatomanaꞌkoo: ninge maꞌnari Kopeu ninka bataꞌaramaung. ");
INSERT INTO nas_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eeꞌnoko ooveriko diiꞌ siontaarimaing-koo niiꞌning maꞌnari bataꞌaarimaing otorong. Eeꞌnoko ninge Kopeu ninka maꞌnari bataꞌaramaung tamperima deekoꞌ teing siontaarimainge baa ninka bataꞌaarimaung tamperikooꞌ? Arekeeꞌ, teing napoꞌ ning-pinaꞌ nariꞌ Kopeu bakaang purintoꞌke bataꞌaarimaing tamperererimaang ee? Teeꞌ taararaarira teinge tuutunantaariaing diiꞌ, aiꞌ teing teeꞌke niꞌninka nariꞌ nkomarimaing. ");
INSERT INTO nas_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Teka Kumponing bakaang iriꞌke maꞌnari bataꞌaramaung deekoꞌ tee muuꞌ Kumponing bakaang tee diiꞌanko taaꞌniꞌpoi poing. ");
INSERT INTO nas_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Tenang teie naninge purintoꞌke tavuꞌkooninge tankeꞌpari bakanava tampava tarevui otoko bakaning kapooꞌnanka pinkaꞌari otomatopeuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Teka tenang narung aaꞌnaꞌ purintoꞌ tee-koo dau basi tee-koo kokoroarara puruꞌura dei, teie pariꞌupeuꞌ ookara bakaning tavuꞌkooning tee eꞌmanumaing eeꞌnoko tankaampupeuꞌ bakaning kapooꞌnanka. ");
INSERT INTO nas_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Eeꞌnoko diiꞌke tasiꞌmeriarura diiꞌ teing ning-koo kare-nupoong, eeꞌnoko diiꞌ niꞌninka nariꞌ nantoong oosiarampiarura diiꞌ purarenkaꞌ nkonuka Kumponing bakaang muuꞌketa.” ");
INSERT INTO nas_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Eeꞌnoko Jiisuuꞌke kato nau-antavurima aaꞌpuruꞌ, “Tenang maꞌnaang orara tamung bataꞌnisi naning-eta tenkenura avitoitoi nanupeuꞌnung ntong otoaꞌnairue uaavoainooꞌ besiꞌuma, eeꞌnoko tokoo oovuarura aaꞌpupeuꞌ, ‘Ning toromaravaing napoꞌ nkanava ning mouꞌnava-koo.’ ");
INSERT INTO nas_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eeꞌnoko tenang toroarara kiiroraaꞌari neriarioꞌ oovupeuꞌ Tanuaang Meekung borivuaꞌ bakaang domang-koo. ");
INSERT INTO nas_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Teketa bera teie ˜kenaanka-taa maꞌnari napoꞌ bokuvurira toroaripeuꞌ baruꞌ aaꞌnaꞌ oreng tee puruꞌai. Eeꞌnoko teing tumparira tee-koo otoropeuꞌ, eeꞌnoko asiꞌnung otootoꞌ tee naning bakaang bakei aaꞌnaꞌ oraruꞌkupeuꞌ tutung otokoꞌnaꞌketa.” ");
INSERT INTO nas_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Aung teeꞌ oroꞌ kara Jiisuuꞌke minkuvui otoko nani manikumai karinga-koo meuꞌketa bokuma aaꞌpuuꞌ, “Biraankearuꞌnani teni dauko daꞌ pararuuꞌnani eeꞌnoko noonooꞌduuꞌ daꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Teka teie aaꞌpuuꞌ, “A, teing oo nantoong biraankeariaining Kumponing bakaang kara taaravaara iꞌmaꞌaavaining.” ");
INSERT INTO nas_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tenang nantoong karikaꞌ aaꞌnaꞌ mmauꞌparirioꞌ Jiisuuꞌke kara tutumpuuꞌnung, aaꞌpuma, “Diiꞌ enanavarang bakei oreng, niiꞌning Sietaniꞌketa una-antavaranko tokomerima aaꞌmerimaing, ‘Taaꞌniꞌanta paning-etaing naumeriaing dake Kumponing bakaang iriꞌninka mintoontaramaung deekoꞌ.’ Bakei Kumponinge diiꞌ taaꞌniꞌanta nau-anta-koo kasivuarura narung masikung aruriiꞌnaang, aaꞌnoaing: teie ning taaꞌniꞌanta deeng-antamuaing temuꞌ Joonaꞌ taaꞌniꞌanta deeng-antavuuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Eeꞌ, teeꞌpinaꞌ Joonaꞌ nekipaꞌnooꞌketa daaꞌuioꞌ teing Nineva-nupoonge tee Kumponing-etaing nakaronara tasiꞌpauꞌnaꞌ teeꞌ nariꞌ Kumponinge booꞌketa daaꞌmuko ning Tee Naning-naumpoꞌ Paning-etaing tasiꞌmeriaing diiꞌke. ");
INSERT INTO nas_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tenie ovorinaang amenteiꞌketa depeto pouꞌnanie teꞌmung simpeꞌ nkonaꞌmung diiꞌ emuꞌnavarang ninka nariꞌ daaꞌarara diiꞌ kiimata-koo makosinuka tanturiaing, teni kansiꞌ botu-etaꞌ pouꞌnooꞌkoo taara-koo tee daurarong˜ Solomoniꞌ bakaang matau, eeꞌnoko ee aing, naning baruꞌ aaꞌnaꞌ matau Solomoniꞌ puruꞌui otoing aung anke otoko diiꞌke taaraveriaung. ");
INSERT INTO nas_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Napoꞌ teꞌmung simpeꞌ nkonaꞌmung teing Nineva-nupoong teinge daaꞌariaininge diiꞌ ninka enanavarang ninka nariꞌ eeꞌnoko napoꞌ diiꞌ kiimata-koo makosinuka tantaariaing Joonaꞌ daankiarako temuꞌ bereꞌariruꞌning deemparima, eeꞌnoko ee aing, naning aaꞌnaꞌ pankaing Joonaꞌ puruꞌui otoing aung anke daankiarako diiꞌ bereꞌdariaung. ");
INSERT INTO nas_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Naninge araka paroꞌura bakuꞌuarupeuꞌ, niiꞌnooꞌ antonaꞌke dakaꞌpuarupeuꞌ, teka teie batanang-koo dau panteꞌupeuꞌ teinge tumpariaininge araka ooaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Duta tee diikaang mono bakaang puu. Tenang diikaang duta tampaꞌ otoko diikaang mono ootukunairu arakai maantoꞌui otopeuꞌ, teka tenang tampaꞌ otoaruko deekoꞌ diikaang mono mutaanange maantoꞌui otopeuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Teeꞌkoo tanatarariri otoriai tee araka diiꞌkoo otoing mutuurariko mutaanampuꞌneenga. ");
INSERT INTO nas_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tee tee diikaang mono tee ookutunairu arakai maantoꞌuaing deekoꞌ niiꞌnavaro mutaanampuaꞌ tee bakei ookutuari sirakaꞌpuaing teie puue oovuko ookutuari arakarurimanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Teka kara bakearako narunge Boto Keperuuꞌnavitu-koonge Jiisuuꞌ bokuvuuꞌ tee ninka taamang-koo. Tee tee tumparara taamantoma baꞌnanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Eeꞌnoko tee Boto Keperuuꞌnavitu-koong taꞌnimparuꞌ oovura tee tutung ntong-koo bireng duuꞌke meekaꞌparavaꞌ taamanuko. ");
INSERT INTO nas_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eeꞌnoko Ovoringe aaꞌpuuꞌ tee, “Diiꞌke tee Boto Keperuuꞌnavitue kaapu dovang-koo diisi damaꞌdu naroꞌ duuꞌperimaung teka diiꞌ pakareererariri orara aarumo ninka okoꞌokoi maantoꞌduri otong. ");
INSERT INTO nas_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Diiꞌ kanuꞌnanka. Arekeeꞌ, teie Kumponinge damaꞌdu nkoruruꞌnunge ee napoꞌ kuung nkoruriaꞌ nariꞌ kiiroraaꞌdariri otoripeuꞌnaꞌ? ");
INSERT INTO nas_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Diikaang domang Kumponing-koo tutung ararima deekoꞌ, napoꞌ ataꞌoinku-koo avusiroꞌrariri otorimaatoai makosinaꞌ, eeꞌnoko teeꞌkoo ookara kapooꞌ kiiroraaꞌari otoaing diiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Bakaꞌ piaaruꞌnuka diiꞌ Boto Keperuuꞌnavitu, toraꞌkiriaining, aiꞌ diiꞌke tee avutevuꞌ napoka dovang okiꞌnarekaꞌ kivoranaꞌ tankaamperima namanto Kumponing averikooꞌ sirivitaꞌ dovang koꞌdompuuꞌ; aarumo koontoꞌ eeꞌnoko tee piaa Kumponing bakaang siperi. Aing eeꞌning teing diiꞌke naroꞌka nko-koo makosining. ");
INSERT INTO nas_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Piaaruꞌnuka diiꞌ Boto Keperuuꞌnavitu, toraꞌkiriaining, aiꞌ diiꞌ teing pava dootuuꞌnairu-koo baꞌnavaꞌnaniꞌnanka tampeng-koo baꞌnantarikooꞌ nantoonge ankantaariiꞌnaang, eeꞌnoko nantoonge pankaing-antaraariiꞌnaang pianukai bavevaave-nairu-koo. ");
INSERT INTO nas_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Piaaruꞌnuka diiꞌ Boto Keperuuꞌnavitu, toraꞌkiriaining, dakoꞌdoma tasiꞌpaaꞌnooꞌ makosinuka aaꞌnooꞌke nantoong daue noruꞌaavaꞌ nanaamaatopeuꞌnooꞌ, aiꞌ diiꞌ diikaang kara tampaꞌ taararaari siontaarima tasiꞌpaavaung Kumponing-eta ketaꞌantavereriko booꞌnameng-aape.” ");
INSERT INTO nas_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Narunge boto naunuka-koonge bariꞌuma aaꞌpuuꞌ tee, “Nau-anta, niiꞌ teeꞌ dake minkuvema teing ninka nariꞌ maiaꞌantamerimaang.” ");
INSERT INTO nas_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ tee, “Diiꞌ piaaruꞌnuka boto naunuka, toraꞌkiriaining, aiꞌ diiꞌ teing nantoong mankiꞌantavererimaing aarumo mmauꞌ siong-koo poreꞌantavererima, eeꞌnoko diiꞌke pankireꞌkoo-navirenge diiꞌka komperiaꞌ tee-koo mankiꞌnanka-koo pakuereritaaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Piaaruꞌnuka diiꞌ, toraꞌkiriaining, aiꞌ diiꞌ teing Kumponing-etaing nakaronuka dakoꞌaaruꞌnooꞌ tamung nerinuka oreng diumaraange tavaaruꞌning. ");
INSERT INTO nas_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Teeꞌkoo diiꞌ diumaraang-koo arooꞌdariri otorining siraꞌdarimaung, teinge nakaro-nupoong tavaarira dakoꞌaaruꞌnooꞌ nerierimaung-koo. ");
INSERT INTO nas_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Teeꞌkoo Kumponing bakaang mataue aaꞌdampimaung, ‘Ninge botoevorompaing teing nakaro-nupoong eeꞌnoko kara okovuri nkanuka, niiꞌning tee teing-koo dupisiꞌaariaining orakaꞌ nkoaarima.’ ");
INSERT INTO nas_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tee tee Kumponing-etaing nakaro-nupoong biikaang ereng-koo temuꞌketa kansiꞌ pupuꞌaruꞌnooꞌketa bera enang tuuvumaung-koo diiꞌke avarange tuutunang˜ komperiainge, teing-koo Eebeloꞌketa bera Sakaraiaꞌkoo basinooꞌke boorouꞌning-koo, tee Sakaraiaꞌ boonturoma eeꞌnoko meekavaro-koo meuꞌka dupisiꞌauꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eeꞌ, masikung naurampimang, diiꞌke avarange tee-koo tuutunang komperira toraꞌkiriaing; ");
INSERT INTO nas_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Piaaruꞌnuka diiꞌ, toraꞌkiriaining, boto naunuka, aiꞌ diiꞌ teing kiiꞌ paaꞌantaveruꞌning karanaang noruꞌkoonavung daateꞌkoong. Diiꞌ diiꞌka tuntariaꞌ tevaronge eeꞌnoko diiꞌke avoꞌererikooꞌ teing teke tumpariko.” ");
INSERT INTO nas_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Eeꞌnoko Jiisuuꞌ teketa tenkenuko teinge boto naunukai eeꞌnoko Boto Keperuuꞌnavitue karai tuuꞌantavaakoꞌ maroita kapooꞌnanka mmauꞌ makuꞌuma minkuvuko niiꞌnaare-koo baankaꞌaavaꞌnaang nempaitaaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Boto Keperuuꞌnavitue Jiisuuꞌ teeꞌ paaravai otoko nantoong dakuraakuꞌ oosiariruꞌ baruꞌ aaꞌnaꞌ itovei dapiꞌ mmeꞌeema. Eeꞌnoko Jiisuuꞌke bakaning barevare-nupoong bireꞌuri kara tutumpuma aaꞌpuruꞌ, “Tarerariri otoriai tee-koo iisi Boto Keperuuꞌnavitue biikaang taamang ninka bereꞌaamaung-koo, aiꞌ tampeng nau-antanuka oroꞌantavarima biikaang kara orakaꞌ noruꞌ ninka pituaamaung Kumponing bakaang kara avoꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aiꞌ ookara kapooꞌnanka nopaꞌari otoining teing siraꞌparavaining. Eeꞌnoko ookara kara bakuꞌniiꞌ nantoonge ookarai taaravaavainge. ");
INSERT INTO nas_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eeꞌnoko tee Kumponing bakaang mirumiruꞌ arorerima mutaanang-koo minkurarimaung tee araka-koo ookarai taaranumpoꞌ. Eeꞌnoko tee kara diiꞌka kuꞌnuntarima iaange minkuerimaung damaꞌke sirakuraꞌ daankieriaing. ");
INSERT INTO nas_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ninge naurampimang diiꞌ mmaikoriꞌ, aroreriaukaꞌ teing-koo nkaang kara avoꞌaama diikaang mono booꞌantavaavaining-koo eeꞌnoko damaꞌke niiꞌnung kapooꞌ nkoaavarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Teka ninge koono-antarampiri baa diiꞌ aroreriaing naurampiiꞌnaang, mono tavurira mosianung-koo duaꞌduripeuꞌnung. Eeꞌ, tee-koo Kumponing-koo aroreriaing naurampimang, bakaang kara imaꞌeriainaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Noruꞌeri otong nantoonge tee paꞌnokoꞌ barenning okiꞌnarekaꞌ baaveaamaung keura toeaꞌning-koo, teka tee bane okiꞌnarekaꞌke Kumponing tee teing-koo nau ampaꞌoaung tare-koo. ");
INSERT INTO nas_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tee aaꞌnomaung, diikaang daponanka boreꞌkooning-koo deeru noruꞌui otong. Nantoonanka-koo aroreriaukaꞌ, aiꞌ diiꞌ teing baruꞌ deto basinooꞌ noruꞌduri otong bareng okiꞌnarekaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Eeꞌnoko ninge naurampimang, ookara teing nantoong-koo uroꞌkanooꞌke ning arooꞌmai otoing siraꞌpariko ninge, Teie Naning-naumpoꞌ Paning-etainge, tee koosinunanka-koo Kumponing bakaning-koo uroꞌkanooꞌke nkaning tamparampaing. ");
INSERT INTO nas_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Teka baa tee naning ning penkemuaing nantoong-koo uroꞌkanooꞌke, ninge tee teeꞌ penkempampaing koosinunanka Kumponing bakaning-koo uroꞌkanooꞌke. ");
INSERT INTO nas_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Eeꞌnoko baata teing nantoong ning Tee Naning-naumpoꞌ Paning-etaing orakaꞌ minkumaavaining teing tee Kumponinge tontaꞌanta-koo makosinuka, teka baata teing Tanuaang Meekung mintoomparako orakaꞌ minkuaavaining teing teing tontaꞌanta-koo makosinuka deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Eeꞌnoko tenang ainge Boto Keperuuꞌnavitu dovange tuutunantaariko tare nkonuka eeꞌnoko kara simpeꞌnuka-ankoa, avitoitoi noruꞌdariaukaꞌ minkueriainaꞌkoo aaꞌperima, ‘Aminge makuꞌamaꞌnaang?’ ");
INSERT INTO nas_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aiꞌ Tanuaang Meekunge tee tenang tee-koo batei-koo nau-antaruriaing diiꞌke minku-koo makosinaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Narunge karinga-koonge Jiisuuꞌ niaꞌuuꞌnung aaꞌpuma, “Nau-anta, taataꞌ naueko neumai deining barenku tankaampuai neeꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Teka Jiisuuꞌke aaꞌpuuꞌ tee, “Aung ee, nko ning baie simpeꞌnko˜ eeꞌnoko tankaang-nko deeꞌmainta-koo miruꞌmuinge?” ");
INSERT INTO nas_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eeꞌnoko teketa beꞌnuꞌui teing ookara nau-antavurima aaꞌpuuꞌ, “Oorariri tarerariai tee-koo aarumo okoꞌoko-koo, aiꞌ naning bakaang domaang kavokavoro-ita nkoniiꞌ deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Teketa teie kara dikitoꞌ nauvuruꞌ teing; aaꞌpuuꞌ, “Temuꞌ naning narung kavo mmauꞌpoꞌnung otokoꞌnung bakanau kansiꞌ aaꞌnaꞌ maneenau doong kante-koo. ");
INSERT INTO nas_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Eeꞌnoko baka karoma aaꞌpuuꞌ: Ning aming nkoamaꞌnaang? Aing nkaning taamananka sipampainooꞌ otoꞌmemuaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Teketa aaꞌpuuꞌ: Enang aaꞌ eeꞌ nkoamaꞌnaang, aing nkaning taamang koreꞌmaramaing pava okiꞌnarekaꞌ pesiꞌamira pankainanka kaniampaing, eeꞌnoko teing-koo sipampaing ookara nkaning sinananka eeꞌnoko kavonanka. ");
INSERT INTO nas_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Eeꞌnoko ninka aaꞌmaravai: Aung ee, daꞌ mmauꞌ kavonanka otoꞌderung mareꞌ amatemareꞌkoo makosining. Unaaroi otoi bauꞌdarama, tuaantarama doturari otoaing. ");
INSERT INTO nas_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Teketa Kumponinge aaꞌpuuꞌ tee, ‘Daꞌ kanuꞌ, eꞌmung muunga dakaang tanuaange siꞌduuꞌnaang, eeꞌnoko teeꞌ nkorarako baa okovuuꞌnaang teing kapooꞌnanka maamu-antaveining?’ ");
INSERT INTO nas_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Teeꞌ nariꞌ tee naning baka-koo kavo oosisiimaung nkoaravaing Kumponing-aape oosivuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ bakaning barevare-nupoong, “Teeꞌkoo ninge naurampimang diiꞌ, noruꞌ mankiꞌdoriaꞌ otoai aaꞌning-koo taamang domanturiaining eeꞌnoko mononopaꞌnanka. ");
INSERT INTO nas_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Aming-koo, nnaꞌ domaang tee taamang-koo biꞌari otoaꞌ eeꞌnoko mono tee baarong-koo ioꞌaravaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Oovereriai teing kaukaunanka, keeng eeꞌnoko kavuꞌ noruꞌaavainge, taamang koreꞌnairu otoꞌevoroaꞌ, nka tee Kumponinge bauꞌurimaung. Bakei, diiꞌ teing baruꞌ deto basinooꞌ noruꞌduri otong barennanka-koo. ");
INSERT INTO nas_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Eeꞌnoko baie diiꞌkoo noruꞌ mankiꞌoma doong naraangaꞌnooꞌ beꞌnuꞌura teꞌkoo domampari otopeuꞌ? Otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tee tee diiꞌke kapooꞌ okiꞌnaa aung-pinaꞌ nko-koo makosiriaruma deekoꞌ aming-koo noruꞌ mankiꞌdorimaung niiꞌning kapooꞌ piarorima? ");
INSERT INTO nas_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Oovereriai teing iiooꞌnanka tamung dupurimanaꞌ, baarong tuaꞌkoo poreꞌoroainge. Teka ninge eeꞌ naurampimang, aaꞌnaꞌ tampaꞌ nerampurimaung nantoong biikaang meenasi puruꞌuitaaꞌ, bane dauraronanka Solomoniꞌpinaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Teka Kumponinge baaꞌnanka teeꞌ nerampurimaung deekoꞌ, teing aaꞌnomaing naꞌmung doong-koo domamparara daunaꞌmung maraꞌoko tai-antavaakooꞌ, tee tee teeꞌ nariꞌ tasiꞌperiaing diiꞌke, masikaꞌanta okiꞌnaa otoꞌderurininge, aiꞌ diiꞌ teing deto basinooꞌ noruꞌduri duaanaruriaining. ");
INSERT INTO nas_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tee tee kapooꞌ naieriaining tuaantarima besiꞌeriaukaꞌ eeꞌnoko onoue norunoruꞌ nkoveriaꞌ otoai. ");
INSERT INTO nas_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Aing eeꞌ oroꞌ kapooꞌ ookara mutaanang-nupoong ookara kansiꞌkoo kaariaamaing, teka diiꞌ teeꞌ deeaꞌ, aiꞌ diiꞌ Diumai paning-etaing noruꞌui otong aing ookara kapooꞌ diiꞌ apukaꞌdarimaing. ");
INSERT INTO nas_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","“Teeꞌkoo ainkato noruꞌeriaꞌ Kumponing bakaang muuꞌ deto pankaruntoonge noruꞌerimatoai, eeꞌnoko teing aing kapooꞌ apukaꞌdarimaing nariꞌ aruriainge. ");
INSERT INTO nas_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Aroreriaukaꞌ diiꞌ okiꞌnavitu, aiꞌ teie tee Diumai tampaꞌ noruꞌ ninka oko-antaruriaing bakaang muuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Diikaning kavo baaveverima mooniꞌ ataꞌoinku averererimaatoai. Teeꞌ nkoverima koreꞌdarimatoai kerekasiꞌnanka muuninava-poꞌning˜ tamunsiꞌning deemparavaukaꞌning paning-koo. Teꞌ bakiaaꞌ nkonuka tumpariaꞌnooꞌ eeꞌnoko pumpuꞌke orariaavaꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aiꞌ ‘teꞌ tokoo naning bakaang muuninava otoainooꞌ bakaang pankaruntoonge noruꞌ tee teꞌ otoaing.’” ");
INSERT INTO nas_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Eeꞌnoko Jiisuuꞌke danto nariꞌ nau-antavurima aaꞌpuruꞌ, “Maamurariri otoriai tokoniiꞌke pinkaꞌdariri, eeꞌnoko puu paroꞌerira. ");
INSERT INTO nas_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Eeꞌnoko teing-pinaꞌ nantoong biikaang ovoring nampeesiroma-ita toroaravainang nempai otoromaing-pinaꞌ otoriai, kopikopiꞌuko namuꞌke daateꞌaavaꞌnaang nempariri otoromaing-pinaꞌ otoroi. ");
INSERT INTO nas_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bakei biraankenuka deempariaing teing botovotonaaꞌnuka tantearirioꞌ biikaang ovoringe kuneꞌuriaining tenang poma. Masikaꞌ naurampimang, tee tee baka mamuarara baꞌnang-antavuriaing teing taamantoma eeꞌnoko pora bauꞌuriaing teie teing. ");
INSERT INTO nas_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tenang meuꞌnamang niiꞌnooꞌ taneꞌaapenang poma deekoꞌ, tantearirioꞌ meuꞌpuriaining teing botovotonaaꞌnuka teie biraankevuriaining. ");
INSERT INTO nas_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Napoꞌ eeꞌ noruꞌeriai diiꞌ teing tee-pinaꞌ naning pava okovenung, aaꞌnung naning bakiaaꞌnko bakaang batei poꞌkoong noruꞌura dei tee tampaꞌ maamuarapeuꞌ tee pava tauraꞌpuarura derovuma kuung tung-koo. ");
INSERT INTO nas_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Diiꞌ teeꞌke maamurariaininge, aiꞌ Tee Naning-naumpoꞌ Paning-etaing tee batei naninge noruꞌuaruko pooꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piitai aaꞌpuuꞌ, “Ovoring, dake ee tee dikitoꞌ niiꞌkoo miruꞌei naumerimang aiꞌ ookara nantoong-koo?” ");
INSERT INTO nas_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Eeꞌnoko Ovoringe aaꞌpuuꞌ, “Tee aaꞌ ninge baa tee naning matau bakaang ovoringe bakanava tare-koo botovumaung miruꞌama minkuamaang, naning kakeꞌiinara botovotonaaꞌnuka batei makosinang bauꞌkoo miruꞌnisi. ");
INSERT INTO nas_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Biraanke-antavuaing tee botovotonaaꞌ bakaang ovoringe pora teeꞌ nkoarako meuꞌpura. ");
INSERT INTO nas_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Masikaꞌ naurampimang ninge, teie ookutuning kapooꞌ okovumaing-koo tarenara deeng-antavuaing. ");
INSERT INTO nas_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Teka teie botovotonaaꞌke eeꞌ noruꞌuaing deekoꞌ, ‘Nkaang ovoring anaꞌaring poꞌkoo,’ eeꞌnoko teing bautaranuka tavuꞌ tutumpuriai donkaang eeꞌnoko manikuꞌ, eeꞌnoko taamanuma purintoꞌnaruꞌke naivuma kanuꞌaravai. ");
INSERT INTO nas_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Teketa teie bakaang ovoringe poma meuꞌpuuꞌnaang doong paapaaꞌui otoainaꞌmung tee poꞌkoo eeꞌnoko batei noruꞌuaukaꞌnang. Eeꞌnoko teie aaꞌnaꞌ kiimatavuaing tee, eeꞌnoko naroꞌ sipuai teing ninka masikaꞌantavaavaꞌ kakaruaꞌnuka ninka. ");
INSERT INTO nas_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Eeꞌnoko tee botovotonaaꞌ ovoring bakaang pia tasiꞌpui siompuaukaꞌnung deekoꞌ, maamuaravaꞌ, tee aaꞌnaꞌ muraꞌkoong. ");
INSERT INTO nas_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Teka tee noruꞌkuaꞌ teeꞌ nkovuaing deekoꞌ tee okiꞌnooꞌ muraꞌkoong. Aiꞌ ookara nantoong narunaꞌ narunaꞌ mmauꞌ avuavuꞌ nkavaamaing napoꞌ mmauꞌnaꞌ avuꞌkoo miruꞌariri otorong. Tee mmauꞌ avaamaung-eta napoꞌ mmauꞌ nka-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Teketa Jiisuuꞌke danto nariꞌ nau-antavurima aaꞌpuruꞌ, “Ninge aꞌ kansiꞌkoo ntaꞌ betuꞌamaꞌnaang mouꞌnung. Bakei tero mooꞌkupeuꞌnung tampaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Teka tee tutung sisikeera ninka mmeꞌ meekaꞌantamaravaꞌ ning bakei orakaꞌ deeꞌmoi kakau oꞌnong dupearavaruko tee. ");
INSERT INTO nas_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Diiꞌke ee ning mooa aꞌ kansiꞌkoo tavoꞌamaꞌnaang mouꞌnung-pinaꞌ noruꞌmerimang? A, teeꞌ aaꞌ deeaꞌ, ning tankaang-anta nko-koo mouꞌnung teeꞌ naurampimang. ");
INSERT INTO nas_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Enang-eta deto paꞌnokoꞌ nantoong nava-koo otoromaing teeꞌ tankaampariiꞌnaang, beenaumo kenaanka ninka turampeematooꞌnaang, eeꞌnoko kenaanka beenaumo ninka. ");
INSERT INTO nas_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Teing siivenkeꞌeeaing bauma bauring-eta eeꞌnoko bauring bauma-ita; bauko baurang-eta eeꞌnoko baurang bauko-ita; bakaampo baampuruꞌnaang ninka eeꞌnoko baampuruꞌnaang bakaampo ninka.” ");
INSERT INTO nas_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Eeꞌnoko Jiisuuꞌke napoꞌ nauvuruꞌ nantoong karikaꞌ, aaꞌpuuꞌ, “Tenang kamoꞌ duaaꞌ tumparamanooꞌke nkoarako diiꞌke namuꞌke aaꞌperimaung: Apoꞌuuꞌnaang. Eeꞌnoko apoꞌukooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Eeꞌnoko tenang doving uipaariiꞌnooꞌke depeto poko ooverima aaꞌperimaung: Uipaariiꞌ baaꞌ maraꞌanta tavoꞌkuuꞌnaang. Eeꞌnoko teeꞌ nariꞌ nkoaramaung. ");
INSERT INTO nas_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Diiꞌ ampirininuka, teeꞌ noruꞌeri otong tasiꞌkoo taaꞌniꞌanta kansiꞌkooning eeꞌnoko doona-kooning. Teka arekeeꞌkoo diiꞌke ning-kooning taaꞌniꞌanta tasiꞌperiaꞌ otong? ");
INSERT INTO nas_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aming-koo diiꞌke koontoꞌnaꞌ simpeꞌeriaung nkaang kara diikaning oreng tuumpirampima minkuanko? ");
INSERT INTO nas_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Eeꞌpinaꞌ, tenang naninge daꞌ tuumpirura tuutunang-koo tavoꞌduuꞌnaang nanirema aaꞌnaꞌ paaraveai koonteereeꞌnaang teke taunge simpeꞌ nkonara-anko tavoꞌduaruko, eeꞌnoko simpeꞌnkoi piatooro avuriko kiimata-koo siꞌdaaꞌneenga. ");
INSERT INTO nas_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ninge eeꞌ nauramaang, daꞌ tee teketa tamung tontaꞌdaravarupeuꞌ mooꞌ pukevei ookutuning duaꞌeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tenang niiꞌning nantoong Jiisuuꞌanko porora nauaama aaꞌpauꞌ, “Pailatiꞌke piatooronuka˜ botovurioꞌ niiꞌning Kaaleliꞌnupoong boontunang nkoari otoko dupisiꞌaarioꞌ ereng biikaning boontunang-kooning ereng ninka pitu-antavaaring.” ");
INSERT INTO nas_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Diiꞌke eeꞌ noruꞌeriaukaꞌ: teing teeꞌ boorouꞌning kapooꞌ orara makensiꞌning diiꞌ otoꞌderuiaing-pinaꞌ oroꞌ otoko Kumponinge Roomaꞌnupoong tauraꞌpuruꞌ teing Kaaleliꞌnupoong dupisiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Otoaꞌ, teeꞌ deeaꞌ. Teka diiꞌ teeꞌ nariꞌ paaꞌdariaininge bereꞌdariaukaꞌning deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aiꞌ eeꞌ noruꞌerimang teing nanaiꞌketa ˜beenaumo-taa 18 pava deto isikava dau duaꞌarara tavuruꞌning bakei oreng masikeng niiꞌning Jerusalemaꞌnupoong divuꞌaari otong? ");
INSERT INTO nas_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A, otoaꞌ, teeꞌ naurampimang. Diiꞌ teeꞌ nariꞌ paaꞌdariaininge bereꞌdariaukaꞌning deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Eeꞌnoko teie aung dikitoꞌ nauvuruꞌ, “Narung naninge koiꞌ piikiꞌ keempuuꞌnung bakanooꞌ uaininau-koo, eeꞌnoko niiꞌnaꞌmung sinang kavuꞌkoo pouꞌnung tevari-koo, teka oovuaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eeꞌnoko teie uaininau tanata nauvuma aaꞌpuuꞌ, ‘Aung ee, aing beenaumo mareꞌkoo ning sinang kavuꞌkoo momaung avari-koo piikiꞌnavari-koo, teka sinang ooampaung ninge. Nokieaing tevari tamung kansiꞌ orarivumatoꞌneenga.’ ");
INSERT INTO nas_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Eeꞌnoko teie makuꞌuma aaꞌpuuꞌ, ‘Ovorooꞌ ee, sipeioꞌ amareꞌ iroꞌ otoai napoꞌ bera okoraꞌ nenkeꞌamira kansiꞌ pankauang sipampaing. ");
INSERT INTO nas_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Daunamareꞌkoo sinang biꞌuaing deekoꞌ tampaꞌ masikaꞌ, teka biꞌuaruko deekoꞌ nokieaing.’” ");
INSERT INTO nas_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Teketa niiꞌnaꞌmung Doong Uaanaꞌmung, nau-antavarakoꞌnung pava dootuuꞌnanka-koo niiꞌnava-koo. ");
INSERT INTO nas_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Teke nani maꞌnaange siipa-antavukoꞌnani otokoꞌ mareꞌ kivora-ita ˜beemareꞌpi-taa-koo 18, kaiꞌaritaaꞌ baka deto koompari donkong-koo makotuarukoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Eeꞌnoko tenang Jiisuuꞌke oovura teni, teie bokuvuko uroꞌke poko aaꞌpuuꞌ, “Ani ee, daꞌ unaaroinani dakaang siipa-ita.” ");
INSERT INTO nas_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Eeꞌnoko teie bakaang bireng panteꞌuuꞌ teni-koo dau eeꞌnoko tenang namuꞌke teni koomparuꞌ. Eeꞌnoko tenie Kumponing daangampuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Teka Jiisuuꞌke Doong Uaanaꞌmung-koo taare-anta nkovuuꞌnung-koo teie pava dootuuꞌnava tanatavukoꞌnunge iiravoma eeꞌ minkuvuruꞌ teing nantoong, “˜Naꞌmung-taa doong otong nko-nko nko-kooning. Teing-koo doonko porira taare-anta nkaveriaing, Doong Uaanaꞌmung-koo deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Teketa Ovoringe makuꞌuma aaꞌpuuꞌ tee, “Daꞌ ampirinung˜, diiꞌkoo ee narunge teꞌmung Doong Uaanaꞌmung bakaang boromakaꞌ niiꞌnaꞌ doonkiiꞌ dapaꞌuma biꞌari otomanooꞌketa barampui beaung ntong nai-anta-koo? ");
INSERT INTO nas_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eeꞌnoko teeꞌ makosi deekoꞌ, aming-koo ani manikuma Eebaraamiꞌ baurang makosi deeaꞌ Doong Uaanaꞌmung-koo unaa-anta-koo, Sietaniꞌke daiꞌuuꞌnani booniꞌantavuma teing-koo mareꞌ kivora-ita ˜beemareꞌpi-taa-koo?” ");
INSERT INTO nas_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Teeꞌ minkuvura teing bakaning tooꞌde-nupoong maiaꞌantavuruꞌ eeꞌnoko ookara nantoong dotuariruꞌ ookara kapooꞌ nepuꞌnaꞌ nkovuuꞌning-koo teie. ");
INSERT INTO nas_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Napoꞌ niiꞌnaꞌ Jiisuuꞌke eeꞌ minkuvuuꞌ, “Kumponing bakaang muuꞌ aming-pinaꞌ oroꞌ? Aminge pa paara-antavampeuꞌ tee? ");
INSERT INTO nas_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tee aaꞌ sinanu okiꞌnu-pinaꞌ oroꞌ masitaraꞌkoonu naninge nkavura mintoong-koo keempuuꞌnu, eeꞌnoko dupura koiꞌ pankavari deemparuꞌ, eeꞌnoko barennankai bitonanka kaniauꞌ kaumpeꞌnanka-koo.” ");
INSERT INTO nas_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Eeꞌnoko napoꞌ aaꞌpuuꞌ, “Kumponing bakaang muuꞌ aminge pa paara-antavampeuꞌ tee? ");
INSERT INTO nas_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tee aaꞌ tee teu-pinaꞌ parauanu naakoꞌniiꞌnu iisi-poꞌnu-pinaꞌ naninge manikumai nkavura paraua diisi beerentuꞌkoo maantoꞌura naroꞌka bereꞌuko bera teue ookara pangapangavopeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Teketa tee tenkenura Jiisuuꞌ nanuuꞌnung Jerusalemaꞌaape osi pankeng eeꞌnoko okiꞌnarekaꞌ beeroꞌui nau-antavurima. ");
INSERT INTO nas_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Eeꞌnoko niiꞌninge aaꞌpauꞌ tee, “Ovoring, teing ee mooꞌariaining okiꞌning?” Eeꞌnoko teie aaꞌpuruꞌ teing, ");
INSERT INTO nas_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Muuꞌ paninung-koo tuntoma teꞌ ito-navarong. Teke tevaronge aaꞌnaꞌ purintariri paararariaing tung-koo avutevuꞌdariaꞌ, aming-koo, nnaꞌ teing karinga avitoitoi miruꞌarima paaravariaining makosiaavaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tenang namuꞌke pava okonarai iꞌamparara karanaang pinkaꞌuko diiꞌ tee damaꞌdue donkoniri otoriaing kopikopiꞌerima teꞌ karanaang, aaꞌperima, ‘Ovoring, daateꞌmeriai.’ Eeꞌnoko teie aaꞌduriaing diiꞌ, ‘Ninge diiꞌ noruꞌdampiaꞌ areketa porininge.’ ");
INSERT INTO nas_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tenang diiꞌke aaꞌperiaing, ‘Niiꞌ aaꞌ daꞌ ninka nariꞌ taamanampima tuaamarikoꞌning, eeꞌnoko daꞌ niikaning osinanka-koo nau-antararakoꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Teka teie aaꞌduriaing, ‘Ninge naurampimang diiꞌ noruꞌdampiaꞌ, areꞌnupoonge. Tokoi beriaing ning-ankoita diiꞌ orakaꞌ nkorarimaing.’ ");
INSERT INTO nas_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Teke eeꞌnooꞌke damaꞌdu otoritaaꞌ birontariai siꞌdaꞌ kakirinkurarima sisikeera-koo otori, aaꞌning oovererima: Eebaraamiꞌ, Aisakeꞌ, Jeekopiꞌ eeꞌnoko teing ookara Kumponing bakaning nakaro-nupoong teka muuꞌ Kumponing bakanooꞌka. ");
INSERT INTO nas_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Eeꞌnoko nantoong aaꞌning-eta poroaining teke muuꞌ Kumponing bakanooꞌke nariꞌ taamanaavaing: duaaꞌ pomanooꞌ, tumparamanooꞌ, eeꞌdoompeto eeꞌnoko eeꞌdepeto. ");
INSERT INTO nas_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ee aing, niiꞌning teing enang damaꞌduariri otoroining ureaavaining eeꞌnoko napoꞌ niiꞌning enang ureai otoroining napoꞌ damaꞌduariaing.” ");
INSERT INTO nas_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Eeꞌnoko tenang tee-koo batei-koo niiꞌning Boto Keperuuꞌnavitu porora aaꞌpauꞌnung Jiisuuꞌ, “Tenkeniai anketa, Eerotiꞌke daꞌ dupisiꞌduuꞌnaang piavomaang.” ");
INSERT INTO nas_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌnung teing, “Berira nauerima tee daang-koong daurarong aaꞌperiaing, ‘Aung ee, Jiisuuꞌke aaꞌpuing, “Ninge aaꞌnomaang: maꞌnari bataꞌaramang, taare-anta nkoamaang-eꞌmung, taneꞌ teeꞌke, eeꞌnoko daunaꞌmung opamaꞌnaang nkaning nko-nko nkoama Kumponinge miruꞌmuuꞌning. ");
INSERT INTO nas_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Teka eꞌmung, taneꞌ, eeꞌnoko daunaꞌmung nkoampaing teing nkaning nko-nko, bera Jerusalemaꞌke bakeampaing, aiꞌ Kumponing bakaning nakaro-nupoong teing Jerusalemaꞌkoo taapoꞌke booroaung.” ’ ");
INSERT INTO nas_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Oi bakaꞌ Jerusalemaꞌnupoong, Jerusalemaꞌnupoong, dupisiꞌerererimaing Kumponing bakaning nakaro-nupoong, eeꞌnoko teing diiꞌkoo botovurimaing kapange tooꞌpererima dupisiꞌerererikooꞌ, arekeeꞌning batei-koo ninge diiꞌ naroꞌkoo kariamaung kokoreeꞌke baurukaaꞌ kupaꞌkoo boong naroꞌurimanaꞌ, teka diiꞌ arooꞌdariaung. ");
INSERT INTO nas_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aing ee, Kumponinge diikanooꞌ osi siꞌduring diiꞌke diiꞌka tare-koo. Eeꞌnoko naurampimang, diiꞌ teing ning napoꞌ oomeriarooꞌnaang bera tenang batei aaꞌmeriainang, ‘Biraankenung tee naning Ovoring bakaang miring-koo pomaatomaung.’” ");
INSERT INTO nas_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Niiꞌnaꞌmung Doong Uaanaꞌmung Jiisuuꞌ taamang-koo beuꞌnung narung pankaing Boto Keperuuꞌnavitu-koong bakanavaꞌkoo. Teinge Boto Keperuuꞌnavitue Jiisuuꞌ nempai tareaakoꞌnung baankaꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Teke naning narung Jiisuuꞌkoo uroꞌkanooꞌke otokoꞌ siipai mono doremparakoꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eeꞌnoko Jiisuuꞌke oovura niaꞌurima aaꞌpuruꞌ teing boto naunuka eeꞌnoko Boto Keperuuꞌnavitu, “Doong Uaanaꞌmung ee taare-anta nko-koo makosi aiꞌ makosi deeaꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Teka teing kareaavaꞌ. Teketaꞌ teie kompura taare-antavura siꞌnaraꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eeꞌnoko teing aaꞌpuruꞌ, “Diiꞌkoo baa bauring-poꞌnung niiꞌnooꞌ boromakaꞌnavoroꞌ otoꞌevuing dinkung-koo duaꞌari dei ee teie iriꞌnarung taaruꞌuarupeuꞌ Doong Uaanaꞌmung?” ");
INSERT INTO nas_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eeꞌnoko teing tenaare makuꞌkoo makosiaavaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jiisuuꞌke tee teka nantoong taamang-koo bokuaaruꞌning tampooꞌ baꞌnang-koo piavoroko oovurira kara dikitoꞌ nauvurima aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tenang niiꞌnarai bokuruko daꞌ nampeesi-koong-koo taamang-koo pankeng baꞌnamparimanooꞌ baꞌnaniaukaꞌ naning daꞌkoo dau basi bokuvuing poko teie bokururepeuꞌnunge aaꞌduꞌneenga, ‘Aung ee, tontaꞌdarako aung baꞌnanuai;’ ");
INSERT INTO nas_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Eeꞌnoko tenang daꞌ maiaꞌdoitaaꞌ boonko oko batariꞌdarapeuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Teka tenang bokuraako daꞌ bera oko baꞌnaniai, eeꞌnoko bokuruinge pora aaꞌduai, ‘Mmaikoꞌ, deto aꞌdeiꞌ baꞌnaniai.’ Tenang ookara-koo teke daꞌ ninka taamang-koo nariꞌ baꞌnantariaining-koo miring pankaing nkaveeꞌnaang dake. ");
INSERT INTO nas_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aiꞌ toomo aung eeꞌ oroꞌ: Baa naning baka deto nkoaramaung doonko batariꞌnumpoꞌ eeꞌnoko tee naning baka boonko otomaung deto iꞌanumpoꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Eeꞌnoko Jiisuuꞌke napoꞌ nauvuma aaꞌpuuꞌ tee naning bokuvuuꞌnung, “Tenang dake paroro nkovema daꞌmaikoriꞌ bokueriaukaꞌ, aing aaꞌning: daaraꞌmainkaang, dakanamuiaang eeꞌnoko kavokavoro-poꞌnupoong, damaꞌke napoꞌ bokuraara makuꞌariꞌneeng. ");
INSERT INTO nas_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Teka tenang paroro nkovema aing eeꞌ oroꞌnuka bokueriai: ataꞌoinku, kaikuuꞌnuka, kauꞌ deꞌdoonuka eeꞌnoko kaputuꞌnuka. ");
INSERT INTO nas_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Teeꞌ nkoveko tee Ovoringe daꞌ biraankeruaing teinge bariꞌdaavaukaꞌnooꞌkoo, eeꞌnoko damaꞌke teꞌmung koontoꞌnuka booꞌketa daaꞌariainaꞌmung Kumponinge tee-koo mooꞌ aruaing.” ");
INSERT INTO nas_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tenang teing-koo narunge Jiisuuꞌ taaravura nariꞌ baꞌnampariri otorokoꞌning-koonge aaꞌpuuꞌ, “Biraanke-nupoong teing nantoong taamang-koo naikaavaining Kumponing bakaang muuꞌ donkonuainooꞌke.” ");
INSERT INTO nas_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Teka Jiisuuꞌke aaꞌpuuꞌ, “Niiꞌnaꞌmung narung naninge paroro pankaing nkovura karinga nantoong bokuvuruꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Eeꞌnoko mororuꞌnaꞌmung botovotonaaꞌ botovuuꞌ paraꞌ sipuma aaꞌpuuꞌnaang, ‘Poriai, taamang maamuari otong.’ ");
INSERT INTO nas_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Teka teing nariꞌ paraꞌariri kareauꞌ. Tutunaꞌnunge aaꞌpuuꞌ, ‘Ninge kansiꞌ nerakung mooꞌansieeng; mera ooamaꞌnaang. Aung ee, tampaꞌ naueaing ee, moarooꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Eeꞌnoko niiꞌnunge aaꞌpuuꞌ, ‘Ninge boromakaꞌnavong mooꞌaransieening mera paaravaramaꞌnaang. Aung ee, tampaꞌ naueaing ee, moarooꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Eeꞌnoko niiꞌnunge napoꞌ aaꞌpuuꞌ, ‘Ning aꞌmung nampeesimarieeng; teeꞌkoo moarooꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tee tee enang botovotonaaꞌ toroarara bakaang ovoring kontevorouꞌnaꞌ nauvuuꞌnung. Teketaꞌ tee pava okonara iiravoi bakaang botovotonaaꞌ aaꞌpuuꞌ, ‘Beaing iriꞌnarung taung pankenankai eeꞌnoko okiꞌnarekaꞌke kantevei osi pankaing-kooninge eeꞌnoko poꞌantaveriaing teing ataꞌoiꞌnuka eeꞌnoko kaikuuꞌnuka eeꞌnoko kauꞌ deꞌdoonuka eeꞌnoko kaputuꞌnuka.’ ");
INSERT INTO nas_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Teketa teeꞌ nkovura toroarara teie botovotonaaꞌke aaꞌpuuꞌ, ‘Ovoring ee, kapooꞌ botomeing ninge nkoansing, teka pava mmeꞌ maantoꞌuaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Eeꞌnoko teie ovoringe botovotonaaꞌ aaꞌpuuꞌ, ‘Taung pankaraunge naniaing eeꞌnoko buruꞌbuurunairue naniai. Eeꞌnoko nantoong etueri kuung poꞌantaveriai nkanava maantoꞌaavainaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eeꞌ nauramaang, teing tero bokuaranko kupiꞌorouꞌning ookara mantonkaavaukaꞌning nkaang-koo paroro-koo.’” ");
INSERT INTO nas_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Niiꞌnaꞌmung nantoong aaꞌnaꞌ karinga Jiisuuꞌ ninka nariꞌ Jerusalemaꞌaape nanaama teie teing-aape bereꞌarara aaꞌpuruꞌ teing, ");
INSERT INTO nas_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tee naning ning-anko poainge tee ning aaꞌnaꞌ deto basinooꞌ pankaruntoonge noruꞌmuaing aing aaꞌning piaavurimanooꞌketa dau basinooꞌ: bauma, bauko, baꞌaang, baurukaaꞌ, batatakaampi, baaraꞌmainkaang, baꞌmarikaampi eeꞌnoko tee baka bakaang domaang nariꞌ. Makosi deeaung deekoꞌ tee makotuaꞌ nkaang barevare-nung deempari otoꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Eeꞌnoko baata teing ning siong-koo baike aaꞌbarataꞌkoo kuneꞌkoo tauraꞌpariarupeuꞌning teing makosiaavaꞌ nkaning barevare-nupoong deempariri otoꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Diiꞌkoo narunge pava pankava kani-koo piavora deekoꞌ tutung ee baꞌnanura norunoruꞌuarupeuꞌ mooꞌ noruꞌuuꞌnaang teva bake-kooning makosi otoꞌevuing deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Noruꞌuaꞌ tamung tutumpuma tuuku-koo dorang panteꞌura opuaruko ookarai ooaavaininge akapeuꞌaama bemkempaaꞌneeng tee. ");
INSERT INTO nas_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Aaꞌpaaꞌneeng, ‘Aunge naninge kani tutumpura kanivuma oꞌkoo makotuaruuꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Niiꞌnaꞌ narung dauraronge niiꞌnara daurarong˜ bataꞌuuꞌnaang kare-koo ee tutung baꞌnanura bakaning ninka mumunsiariarupeuꞌ aaꞌpaama, ‘Niiꞌke ee okiꞌning ninka kivora kokoreiꞌ piatooronuka ninka kenaanka kivora kokoreiꞌ piatooro bataꞌkoo makosi, aiꞌ makotumpiaꞌ?’ ");
INSERT INTO nas_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eeꞌnoko teie dauraronge makosi deeaung noruꞌura deekoꞌ tenang mmeꞌ isipoꞌ otoroko teie kara nka-nupoong botovuripeuꞌ mooaveereainaꞌ niaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Teeꞌ nariꞌ baa naning diiꞌkoong ookara kapooꞌ bakaning-eta siparavarura deekoꞌ tee nkaang barevare-nung deempari otoarupeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Teeꞌkoo diiꞌ miang-koo tasiꞌdariaing. Miang tee kapooꞌ tampara, teka devaꞌnooꞌ opari dei, arekeeꞌ tariiꞌantavupeuꞌ napoꞌ? ");
INSERT INTO nas_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tee aaꞌ tee tee enang makotuaꞌ kapooꞌ nko-koo, tamung duaꞌkoong deemparing. “Diiꞌ punkang-poꞌnupoong deekoꞌ enang taaraveriai!” ");
INSERT INTO nas_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Enang tee taakisi nkanuka eeꞌnoko niiꞌning orananka nariꞌ tee-anko dueꞌ porouꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Eeꞌnoko teinge Boto Keperuuꞌnavitue eeꞌnoko boto naunukai minkuminku nkoauꞌ aaꞌpaama, “Aunge naninge orananka poraporaivurimaung teing ninka nariꞌ taamanaama.” ");
INSERT INTO nas_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Teeꞌkoo Jiisuuꞌke aung dikitoꞌ nauvuruꞌnung, aaꞌpuuꞌnung, ");
INSERT INTO nas_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Baa naning diiꞌkoong narung, narung daakuꞌ sipisipiꞌ otoꞌevupeuꞌ, teketa teing-koo nau pooari dei dake ee teing niiꞌning mmauꞌ tamung siperira teu nau pooaruꞌnu besiꞌkoo naniarupeuꞌ bera daaꞌeainooꞌke basi? ");
INSERT INTO nas_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Eeꞌnoko tenang daaꞌera dake teu poruꞌepeuꞌ ukaamauꞌke doturotu ninka. ");
INSERT INTO nas_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Eeꞌnoko tenang osi pora dake daꞌmarang bokueripeuꞌ eeꞌnoko daꞌmaikoriꞌ aaꞌperima, ‘Niꞌninka nariꞌ dotumariaing ninge nkaang sipisipiꞌ paaꞌaruꞌnung daaꞌansing-koo.’ ");
INSERT INTO nas_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Teeꞌ nariꞌ bakei paning-koo doturotu pankaing otomaunge naning narung orara bereꞌarako tee doturotu teing nantoong karikaꞌ koontoꞌnuka otoromaing-koong doturotu puruꞌui otong, aaꞌning biiꞌka bereꞌkoo makosiaavaing tamparikooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Napoꞌ nani manikuma mooniꞌ kivoranuri otoꞌevupeuꞌnani ee, nau paaꞌantavura puu paroꞌura keperuuꞌari siimuvuma tee pava besiꞌuarupeuꞌ bera daaꞌupeuꞌnooꞌke basi? ");
INSERT INTO nas_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Eeꞌnoko tenang tenie daaꞌura teu, tenie baꞌmarang eeꞌnoko baꞌmaikoriꞌ bokuvuripeuꞌ aaꞌpuma, ‘Niꞌninka nariꞌ dotumariai ninge au mooniꞌnu daaꞌansing-koo, paaꞌantavantuꞌnu.’ ");
INSERT INTO nas_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Teeꞌ nariꞌ bakei Kumponing bakaning koosinunanka dotuarimaung narung orara bereꞌaramaung-koo.” ");
INSERT INTO nas_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Eeꞌnoko napoꞌ Jiisuuꞌke aaꞌpuuꞌ, “Naning narung otokoꞌnung baurinketa kenaankara. ");
INSERT INTO nas_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Eeꞌnoko baaraꞌmaꞌnunge tenaanka-koo aaꞌpuuꞌ tee bauma, ‘Mmaꞌ ee, nkanamanto barenku-koo enang ameai.’ Eeꞌnoko baumai tankaampuuꞌ kapooꞌ okovuining tenaanka-koo. ");
INSERT INTO nas_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Teketa mmauꞌ doong tankinuaruko baaraꞌmaꞌnunge bakaning nkavura tenkenuuꞌ tokoonamenge isipoꞌke, eeꞌnoko teke nainai dovang-koo eeꞌnoko moru, naviuraaꞌeema tamung duaꞌuuꞌ boturopa. ");
INSERT INTO nas_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Eeꞌnoko tenang ookutunung kapooꞌ duaꞌuko pankaing peera tavoꞌkuuꞌ temeng-koo, eeꞌnoko ataꞌ tutumparuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Teeꞌ nkoarara osikaiaang-koong narung-koo biꞌantavaruꞌ temeng-koo. Eeꞌnoko teie bakanavoraꞌkoo botovuuꞌ pooroꞌnanka bauꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Eeꞌnoko bakei aaꞌnaꞌ peeravoi teing dopaꞌ nai-koo piavokoꞌ pooroꞌ avurikoꞌning-koo. Naninge kapooꞌ nauꞌ avuaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Teka baka norunoruꞌarara teie aaꞌpuuꞌ, ‘Bakaꞌe, teing mintoong-nupoong mmaꞌke mooꞌurimaing karikaꞌ otorong taamang makosining otoꞌevorong eeꞌnoko koreꞌarikooꞌ, teka ning aung peerai anka dupisiꞌmumang. ");
INSERT INTO nas_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ning enang iꞌamarara nanampaing mmaꞌanko, eeꞌnoko aaꞌpampai tee, “Mmaꞌ ee, ning orakaꞌ nkomaruꞌnung Kumponing-koo eeꞌnoko daꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ning enang dauring tang-koo makotumpaꞌ. Aing dakaning mintoong-nupoong-koong narung-pinaꞌ nkomeaing.” ’ ");
INSERT INTO nas_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eeꞌnoko teketaꞌ iꞌamparara bauma-anko nanuuꞌ. Teka mmeꞌ isipoꞌ otoko baumai oovura bakaang domang piaae aaꞌnaꞌ maantoꞌura tee-koo bauring-koo, eeꞌnoko teketa kuaꞌparara bokoꞌura nuunuvuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Eeꞌnoko bauringe aaꞌpuuꞌ tee bauma, ‘Mmaꞌ, ning orakaꞌ nkomaruꞌnung Kumponing-koo eeꞌnoko daꞌkoo. Ning dauring tang-koo makotumparuing.’ ");
INSERT INTO nas_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Teka baumai bakaning botovotonaaꞌnuka aaꞌpuruꞌ, ‘Mononopaꞌ tampara masikung iriꞌnarung nkaveri porira kurumperiai aung-koo, eeꞌnoko riing pankiriꞌkoo kurumperiai eeꞌnoko boonamante˜ kauꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Eeꞌnoko boromakaꞌnu kampianu bauꞌnaanu biꞌerira taveriai, eeꞌnoko maaꞌampiai dotumarima, aiꞌ aung nnuring tee booꞌparuꞌnung-pinaꞌ noruꞌ enang napoꞌ domamparing; tee pooaruꞌnung enang napoꞌ toroaring.’ Eeꞌnoko teinge tenang kovi tutumpauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Enang tee tutunaꞌnung bataata poraꞌke otoko, eeꞌnoko teketa poma pava dueꞌ basiarama teie neekavarima koviariko taaravuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Eeꞌnoko botovotonaaꞌnuka-koo narung niaꞌuma aaꞌpuuꞌ, ‘Aming-koo koviarimang?’ ");
INSERT INTO nas_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eeꞌnoko teie aaꞌpuuꞌ tee, ‘Daaraꞌmaꞌnung poing, eeꞌnoko daumai teu kampianu bauꞌnaanu tavuing tee bauring tampaꞌ otoko kuneꞌura onkeonkeꞌuma.’ ");
INSERT INTO nas_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Teka tee iiravora kuung poꞌkoo piavoaruuꞌ. Teketa baumai damaꞌdu siarara keviꞌuuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Teka teie bariꞌuma bauma aaꞌpuuꞌ, ‘Ee mmaꞌ ooveko, aing mmauꞌ mareꞌ ning daꞌkoo daiꞌmari pakurama oꞌnoretuꞌning. Dakaang kara siompamaung taarapiikamaravaꞌ, teka dake ning sieꞌnu biꞌmemuaꞌ ning mmaikoriꞌ ninka nariꞌ kovimaripeuꞌnu. ");
INSERT INTO nas_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Teka tee aung dauring poioꞌ dakaang kokononang tamung keraꞌpuuꞌnung maniiꞌ bakisipunanka mooꞌurima dake tamung teu kampianu bauꞌnaanu tavevuing.’ ");
INSERT INTO nas_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Eeꞌnoko baumai aaꞌpuuꞌ tee, ‘Nnuring ee, daꞌ niꞌninka ookara batei-koo nariꞌ oꞌnoremaung, eeꞌnoko ookara kapooꞌ ning nkaning teinge dakaning. ");
INSERT INTO nas_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tee tee makosi doturotumarima kovimariaing, aiꞌ aung daaraꞌmaꞌnung tee booꞌparuꞌnung-pinaꞌ noruꞌ enang napoꞌ domamparing; tee pooaruꞌnung enang napoꞌ toroaring.’” ");
INSERT INTO nas_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Niiꞌnaꞌmung Jiisuuꞌke bakaning barevare-nupoong nau-antavurima aaꞌpuruꞌnung, “Naning narung kavo mmauꞌ poꞌnung otokoꞌnung. Teie niiꞌnung bakaning kavonanka avutevuꞌ tare-koo sipuuꞌ. Eeꞌnoko niiꞌninge tuumpiauꞌnung orakaꞌ tare tampaama. ");
INSERT INTO nas_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Eeꞌnoko teie okonarai bokuvura aaꞌpuuꞌ tee, ‘Tee aming-koo daꞌ minkuraako taaravansing? Kavo tarevemanaꞌ daariera ameaing. Daꞌ tee bake-antaramaꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Eeꞌnoko teie tare-nkoi baka karoma aaꞌpuuꞌ, ‘Nkaang pankainge enang tontaꞌmuuꞌnaang tanatamaramanooꞌketa. Ninge enang aming nkoamaꞌnaang? Aiꞌ ning tee kansiꞌ nenkeꞌkoo makotumpaꞌ. Ning baka-eenta-koo maiaꞌmomang. ");
INSERT INTO nas_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Eeꞌ, enang noruꞌansing. Nantoong pakuarampaing biikanairu-koo bokumaavainaꞌ tanatamaramanooꞌketa bataꞌmuko.’ ");
INSERT INTO nas_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Tee tee teie narunaꞌ narunaꞌ bokuvuruꞌnung teing bakaang ovoring-koo komaaru˜ otoꞌevorouꞌning. Tutunaꞌnung aaꞌpuuꞌ, ‘Daꞌ nkaang ovoring-koo arekeeꞌning komaaru otoꞌderung?’ ");
INSERT INTO nas_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Teie aaꞌpuuꞌ, ‘Narung daakuꞌ daramu duuni-poꞌnanka.’ Eeꞌnoko teie aaꞌpuuꞌ tee, ‘Aung aneꞌ komaaru-koonaneꞌ tero daarieuꞌnaneꞌ nkavera iriꞌnarung baꞌnanira pariꞌema niiꞌnaneꞌkoo naruaape daarieai.’ ");
INSERT INTO nas_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Napoꞌ niiꞌnung aaꞌpuuꞌ, ‘Daꞌ arekeeꞌning komaaru otoꞌderung?’ Teie aaꞌpuuꞌ, ‘Narung daakuꞌ daramu uiteꞌkoonanka˜.’ Teie aaꞌpuuꞌ tee, ‘Aung aneꞌ komaaru-koonaneꞌ daarieuꞌnaneꞌ nkavera pariꞌema niiꞌnaneꞌkoo naruaape-ita beenaumo kivora daarieai.’ ");
INSERT INTO nas_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Eeꞌnoko tee tarenara bakaang ovoringe taaravura aaꞌpuuꞌ, ‘Tee aung tarenara aaꞌ, bane koontoꞌ deeaunge, teka bakei tampaꞌ uroꞌke noruꞌumaung!’” Eeꞌnoko Jiisuuꞌke minkunaavarama aaꞌpuuꞌ, “Nantoong aung kansiꞌnupoong kansiꞌkoo mintoonaꞌ tero uroꞌka matauaarimaung diiꞌ araka-koo-nupoong divuꞌdaari paninung mintoonuka tantarimaing. ");
INSERT INTO nas_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aꞌnooꞌ kansiꞌnupoonge tamung apupoꞌ uroꞌke noruꞌaama kavokavoro kompaamaung biiꞌka dotu-anta-koo, Kumponing deeaꞌ. Teka ninge eeꞌ botorampimang diiꞌ araka-koo-nupoong, kavokavoro tampaꞌ komperiaing niiꞌning nantoong paku-koo, Kumponinge tampaꞌ oorurira onkeonkeꞌduriainaꞌ paning-koo, teꞌ tampaꞌ otoi otorimaatoainooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Baa tee naning kakeꞌiinung okiꞌning-koo napoꞌ teeꞌke kakeꞌiinung mmauꞌkoo. Eeꞌnoko baa tee naning okiꞌning kompui kavuruaramaung teie mmauꞌ tampaꞌ tanatavuarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tee tee teeꞌkoo diiꞌ naurampirinaꞌkoo kakeꞌiirariarura deekoꞌ aung kansiꞌkoong kavokavoro-nanka-koo, baie noruꞌduriaꞌ kapooꞌ masikung oko-antaruripeuꞌ? ");
INSERT INTO nas_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eeꞌnoko teing kapooꞌ Kumponinge okiꞌnooꞌ kong-koo tauraꞌdurining-koo kakeꞌiirariaruko deekoꞌ baie diiꞌka diiꞌ okoruriaining aruriiꞌnaang? ");
INSERT INTO nas_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Narung bautarai kenaanka ovontura siompurearupeuꞌ, aiꞌ teie tee narung munteꞌuma niiꞌnung piaavumatopeuꞌ, niiꞌnooꞌ narung siompuma niiꞌnung siompuarupeuꞌ. Teeꞌkoo diiꞌke Kumponing eeꞌnoko kavokavoro ookeng deto deeng-antaveriarupeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Teinge Boto Keperuuꞌnavitue mooniꞌ piaavaakoꞌninge aing eeꞌ oroꞌ taaravaara Jiisuuꞌ benkempauꞌ, teka teie aaꞌpuruꞌ teing, ");
INSERT INTO nas_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","“Diiꞌ aing diiꞌka koontoꞌnuka-pinaꞌ nkorarimaung nantoonge daangantaariiꞌnaang, teka Kumponinge noruꞌui otong diikaning domang oreng, aiꞌ aming tee kapooꞌ nantoonge daangampaamaung tee maremaare Kumponing-koo duta-koo. ");
INSERT INTO nas_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Temuꞌketa tee Jooni Minkinara mmeꞌ poaruko Moosesi-nung boto eeꞌnoko Kumponing-etaing nakaro-nupoong biikaang dariraari otoꞌderurikoꞌnung diiꞌke siong-koo, teka Joonie tampara doorenang Kumponing bakaang muuꞌ poaing-koong tasiꞌantaruruꞌnooꞌketa karikaꞌ aaꞌnaꞌ itoveema taatoiarimang tung-koo diiꞌ tamung doororariri otoko. ");
INSERT INTO nas_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nka Moosesi bakaang boto-koo okiꞌnanaare daanaare deemparavaukaꞌ, bane paning eeꞌnoko kansiꞌ tankinureko. ");
INSERT INTO nas_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Eeꞌpinaꞌ, diiꞌ ookara diiꞌankaampi bataꞌerererima oovuning namperererimaing diiꞌke tee nampeesi orarierimaung. Eeꞌnoko diiꞌ donkaang manikuꞌ biiꞌunkaampie bataꞌaarimaing namperereerimaing teeꞌke, nampeesi orarinukai Moosesi bakaang boto totoꞌperi.” ");
INSERT INTO nas_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Narung aunge, diiꞌmaikoꞌ, mmauꞌ kavopoꞌnung atang-pinaꞌ oroꞌninge tampenge mononopaꞌke nopaꞌarakoꞌnung, doong kante paroro narunge mavomavoꞌpoꞌninge bauꞌarakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eeꞌnoko bakanooꞌke karanaang-koo naning narung ataꞌoiꞌ bempari otokoꞌ miring Lasarusi, pentai maantoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mukunge bauꞌarakoꞌ tee ovoꞌmaꞌnung taamang bantoꞌdoma-ita duaꞌarakoꞌninge. Aaꞌnokoꞌnung, mosiꞌke poroma penta nempiꞌaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Teketaꞌ tee ataꞌoiꞌ booꞌparioꞌ koosinunankai nkavaara Eebaraamiꞌkoo bireng-koo kuung sipauꞌ. “Tee kavo mmauꞌpoꞌnung teeꞌ nariꞌ booꞌparioꞌ dakoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Eeꞌnoko booꞌnuka biikanooꞌke sisikeeravoi duta bereꞌarara ookukoꞌ Eebaraamiꞌkoo isipoꞌ otoko Lasarusi ninka nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eeꞌnoko tee bokuvuuꞌnung aaꞌpuma, ‘Mmaꞌ, Eebaraamiꞌ, piaamera Lasarusi botoveko pora pankiriꞌ ntong-koo duuꞌparara meneng komura boimuai, aiꞌ ning tee sisikeerai puruꞌantamuing aung-koo urung-koo meuꞌka.’ ");
INSERT INTO nas_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Teka Eebaraamiꞌke aaꞌpuuꞌ, ‘Nnuring ee, noruꞌeaing daꞌ tee kansiꞌkoo otoi kapooꞌ tampeng nkasiikoꞌnung eeꞌnoko Lasarusie tenang oreng nkavukoꞌ, teka enang aung anke boiravui domang kuaaꞌoi otong eeꞌnoko daꞌ sisikeerai puruꞌantarui otong. ");
INSERT INTO nas_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Napoꞌ niiꞌnung kapooꞌ niiꞌkoo meuꞌke keevaꞌ bakatemota otong nantoong anketa tanking-koo piavoropeuꞌning beroarupeuꞌ, eeꞌnoko teketa dakanameng-eta aaꞌ niiꞌanko naning tankinuarupeuꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Eeꞌnoko tee kavo mmauꞌke Eebaraamiꞌ makuꞌuma aaꞌpuuꞌnung, ‘Mmaꞌ ee, nuuꞌdamaang dake Lasarusi botoeaing mmaꞌ bakanamono-koo, aiꞌ ninge paꞌnokoꞌ ntaraꞌmainkaang otorong. ");
INSERT INTO nas_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bera siingoravuriaing aaꞌ orooꞌ sisikeera-poꞌnooꞌ poroꞌneenga.’ ");
INSERT INTO nas_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Teka Eebaraamiꞌke aaꞌpuuꞌ, ‘Tee aaꞌ Moosesi eeꞌnoko teing Kumponing-etaing nakaro-nupoong biikaang dariraari otong. Teing deeruaavaing.’ ");
INSERT INTO nas_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Eeꞌnoko teie kavo mmauꞌke makuꞌuma aaꞌpuuꞌ, ‘A, mmaꞌ Eebaraamiꞌ, naning booꞌketa bei dei teing-anko teing bereꞌaripeuꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eeꞌnoko teie makuꞌuma aaꞌpuuꞌ tee, ‘Tee aaꞌ tee Moosesi eeꞌnoko teing nakaro-nupoong taaravaariaukaꞌnung deekoꞌ tee teeꞌ nariꞌ masikaꞌantavaavarupeuꞌ, bane naninge booꞌketa daaꞌarapeuꞌnunge nauvuriko.’” ");
INSERT INTO nas_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌnung barevare-nupoong, “Amutemuriaunanka kapooꞌ otong nantoong orara aarumo-koo duaꞌantavurimaung, teka bakei piaaruꞌnuka teing nantoong niiꞌning duaꞌantavaariaining. ");
INSERT INTO nas_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Teka teeꞌ oroꞌ naning baukoi paravuaruuꞌnung dei tampaꞌ, aiꞌ Kumponinge aaꞌnaꞌ kiimatavuaing tee naning aing toireꞌkoo narung duaꞌantavuaing tee-koo orara aarumo-koo. ");
INSERT INTO nas_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tanatarariaing diiꞌ diiꞌka. Daꞌmarang-koong orakaꞌ nkoarako siraꞌpei naueai eeꞌnoko orarunsiarako deekoꞌ tontaꞌantaevuai tee. ");
INSERT INTO nas_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eeꞌnoko tee naꞌmung doong-koo ˜kemuꞌka-taae orakaꞌnko nkovupeuꞌ daꞌkoo eeꞌnoko teing kante napoꞌ ˜kemuꞌka-taae daꞌanko bereꞌarama poma aaꞌpuko deekoꞌ, ‘Ning orakaꞌ nkomaring,’ tontaꞌantaevumatoai dake.” ");
INSERT INTO nas_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Teinge kara okovuri nkanukai aaꞌpauꞌ tee Ovoring, “Niikaang baito pankaing-antamemuriaing.” ");
INSERT INTO nas_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eeꞌnoko Ovoringe makuꞌurima aaꞌpuruꞌ, “Teu masitaraꞌkoonu sinanu teu okiꞌnu, teka teu-eta tee koiꞌ pankaing dupuma deemparamaung, eeꞌnoko teeꞌ nariꞌ diiꞌke masikaꞌanta ninka, bane okiꞌnavuꞌ komperi, bakei aaꞌnoaing, avarireto koiꞌnavari aaꞌperiko deekoꞌ, ‘Deto bitaꞌdarara pirung-koo keentaravai,’ tevarie meunturipeuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Diiꞌkoo narung ovoꞌmaꞌ botovotonaaꞌ otoꞌevumatopeuꞌ mintoomparama niiꞌnooꞌ sipisipiꞌ tanatavurima, eeꞌnoko tenang tee botovotonaaꞌ osi duparako teie ovoꞌmaꞌke ee kirokaivupeuꞌ? ");
INSERT INTO nas_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A, teeꞌ aaꞌ kirokaivuarupeuꞌ, teka aaꞌpupeuꞌ tee, ‘Dake taamang uaꞌmemuai eeꞌnoko mononopaꞌ paarirarara bantoꞌmemuko naiampai eeꞌnoko daꞌ doinang daka taamaniaing.’ ");
INSERT INTO nas_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tee ovoꞌmaꞌ amaiaaꞌoarupeuꞌ bakaang botovotonaaꞌkoo kapooꞌ botovuko nkoevumaing-koo. ");
INSERT INTO nas_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eeꞌnoko diiꞌkoo teeꞌ nariꞌke, tenang diiꞌke bakeveriko tee kapooꞌnanka ninge diikaang ovoringe naurampimaing nko-koo ninge diiꞌ pankaing-anta-koo piaroriaukaꞌ, aming-koo, nnaꞌ diiꞌke tee nko-nko diikaang bantampiruꞌnung narung nkoverimang.” ");
INSERT INTO nas_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalemaꞌaape bema Jiisuuꞌ kevoraꞌka-koo meuꞌke tankinuuꞌ aaꞌning-koo Sameriaꞌ eeꞌnoko Kaaleliꞌ. ");
INSERT INTO nas_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Eeꞌnoko namono-koo osi-koo duparako nantoong nanaiꞌke oramuuꞌpoꞌnupoonge kuneꞌauꞌ. Teketa isipoꞌ donkonai bokiaama aaꞌpauꞌ, “Jiisuuꞌ, Ovoring, piaameriaing niiꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eeꞌnoko tenang teie oovurira teing aaꞌpuruꞌ, “Berira piristiꞌnanka-koo siraꞌantarariaing, eeꞌnoko tampaꞌ ooruko Kumponing-koo boontunang nkoveai nantoonge tee taaꞌniꞌanta ooaara daꞌ teing ninka nariꞌ otoꞌkoo tauraꞌniiꞌ tasiꞌdaavainaꞌ, teeꞌ Moosesi bakaang botoi minkuvumanaꞌ.” Eeꞌnoko teeꞌ beroma mono kiiroraaꞌorouꞌ. ");
INSERT INTO nas_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Teketa narung teing-koong taarevouꞌnung ooarara napoꞌ toroaruꞌnung Kumponing aaꞌnaꞌ bokuma daangampuma. ");
INSERT INTO nas_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eeꞌnoko Jiisuuꞌkoo kauꞌkanooꞌ kinkinura tampara tampuuꞌ. Aung tee eeꞌnung Sameriaꞌkoong. ");
INSERT INTO nas_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Enang Jiisuuꞌke aaꞌpuuꞌ, “Nanaiꞌ ee deeaꞌ kuiaririning? Teing ˜karenaumo-taa areinge? ");
INSERT INTO nas_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Teing-koo narung ee otoaꞌ toroarara Kumponing daangampupeuꞌnung teka aung narung akoꞌnung toroari?” ");
INSERT INTO nas_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ tee, “Daaꞌdarara naniai. Dakaange baitoi domang-antaruing.” ");
INSERT INTO nas_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Niiꞌnang napoꞌ Boto Keperuuꞌnavitue Jiisuuꞌ niaꞌaama aaꞌpauꞌ, “Kumponing bakaang muuꞌ arenang poaꞌnaang?” Teie makuꞌurima aaꞌpuruꞌ teing, “Tee Kumponing bakaang muuꞌ taaꞌniꞌanta ninka poaukaꞌnung dutai oo-koo. ");
INSERT INTO nas_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Naninge aaꞌpuaukaꞌ, ‘Ooveriai, aung tee,’ aiꞌ ‘Aunkaꞌ tee.’ Aming-koo, nnaꞌ Kumponing bakaang muuꞌ tee bakaning nantoong-koo meuꞌke otoi tarevuri otomaung.” ");
INSERT INTO nas_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Eeꞌnoko teketa damaꞌke Jiisuuꞌke aaꞌpuruꞌ bakaning barevare-nupoong, “Batei orananka tee pomaang tenang ning Tee Naning-naumpoꞌ Paning-etaing ninka nariꞌ otoꞌkoo aaꞌnaꞌ piaroriainang, teka ning oomeriaukaꞌnung diiꞌke. ");
INSERT INTO nas_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nka tee nantoonge aaꞌdaariaing diiꞌ, ‘Tee aunkaꞌ nemperimaung berira ooveriai.’ Niiꞌnooꞌ aaꞌdaariai, ‘Tee aung aꞌ otong.’ Teka biikaang kara siomperiaꞌ otoaing. ");
INSERT INTO nas_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aming-koo nnaꞌ piping tavoꞌkuma paning-koo auviꞌaue bereravaramanaꞌ teeꞌ nariꞌ ning Tee Naning-naumpoꞌ Paning-etaing oroꞌmaravaing teꞌmung nkanaꞌmung. ");
INSERT INTO nas_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Teka tutung ninge kapooꞌ arikananka kuneꞌampaing tompimaama nkomaavaining enanavarange. ");
INSERT INTO nas_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Teeꞌ nariꞌ Nooaꞌ bakanang nkoaruꞌnaꞌ teeꞌ eeꞌnaꞌ nariꞌ ning Tee Naning-naumpoꞌ Paning-etaing moainang nkoaravaing. ");
INSERT INTO nas_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Aaꞌnokoꞌnaꞌ: Taamanaama, naikaama, nampeema otorokoꞌ bera Nooaꞌ aakaꞌnareng-koo tumparuꞌnooꞌke basi, eeꞌnoko douai pora aaruvuruꞌ ookara. ");
INSERT INTO nas_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Napoꞌ teeꞌ nariꞌ nkoarikoꞌ tenang Looteꞌ bakanang: Taamanaama, naikaama, baaveveema, keenkeeng nkoaama, pava kaniaarima. ");
INSERT INTO nas_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Teka teꞌmung Looteꞌ Sodom-navuntuꞌketa tontaꞌarako urung eeꞌnoko kapang ntaꞌpoꞌning apoꞌpinaꞌ paning-eta duaꞌarara taivuruꞌ teing ookara. ");
INSERT INTO nas_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Napoꞌ teeꞌ nariꞌ nkoaravainge ning Tee Naning-naumpoꞌ Paning-etaing napoꞌ moainang. ");
INSERT INTO nas_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Teꞌmung basiarako naning kavo-poꞌnung daunavaro-koo otoainooꞌketa siarama bakaning kavo nka-koo pava-koo kuung tumparavaukaꞌnunge. Napoꞌ teeꞌ nariꞌ naning mintoong-koo otoainooꞌketa pava-koo toroaravaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Noruꞌeriaing Looteꞌ baꞌaang denkiꞌouꞌnaꞌ tenang ntaꞌke osi taivukoꞌnamono-aape toroarako bakaang kavo noruꞌuitaaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Baa tee naning bakaang domaang baka tarearamaung tee bakaang domaang tee paaꞌaravaing, eeꞌnoko baa tee naning ning-koo bakaang domaang duaꞌaravaing tee teie teeꞌ nkoarama tampaꞌ pinkaꞌantavuaing. ");
INSERT INTO nas_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Napoꞌ naurampimang, muunga tee kenaanka naroꞌke aaturesi otoko narung pariꞌuma narung sipuaing. ");
INSERT INTO nas_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Napoꞌ manikumaara kenaanka-koo nariꞌ iinkureko nani pariꞌuma nani sipuaing. ");
INSERT INTO nas_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Napoꞌ kenaanka naninka poraꞌke otoreko narung pariꞌuma narung sipuai.” ");
INSERT INTO nas_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eeꞌnoko teinge aaꞌpauꞌ tee, “Ovoring, areꞌka?” Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ teing, “Areꞌ tokoo deraꞌ otoinooꞌ mareoiꞌnanka tee teꞌ poroma naroꞌarimaung maaꞌaavaꞌnaang tee.” ");
INSERT INTO nas_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Eeꞌnoko Jiisuuꞌke nauvuruꞌnung kara dikitoꞌ baito-koo dateꞌpariri doong kante kunsiarimatooꞌnaang kontevoroaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aaꞌpuuꞌnung, “Niiꞌnamono-koo naning narung kara-simpeꞌ otokoꞌnung, aaꞌnung Kumponing-koo avoroarukoꞌ, nantoong noruꞌuriarukoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Eeꞌnoko temono-koo nani manikuma naaro otokoꞌ, tee-anko doong kante poma aaꞌpukoꞌnani, ‘Donkomei pakumeai ning naninge turamumaatoinani.’ ");
INSERT INTO nas_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tutunaꞌnamuꞌpi-koo taaravuarukoꞌnung, teka damaꞌke baka karoma aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","‘Ai, ning aaꞌ Kumponing-koo amoromparukooꞌ eeꞌnoko nantoong noruꞌaramparukooꞌ, nka makosi anie naaroi ereanamumaung-koo donkompampaing poreꞌantamumaatoꞌneenga teeꞌ nariꞌ poi otoma.’” ");
INSERT INTO nas_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Teketa Ovoringe aaꞌpuuꞌ, “Tasiꞌperi noruꞌeriai tee aung naning kara-simpeꞌ orara nkoaruꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eeꞌnoko Kumponinge ee aarumo koontoꞌ kansiꞌkoo donkompevuriarooꞌnaang bakaning miruꞌniiꞌnanka tee-koo bokiaamaing doong eeꞌnoko muung nantoonge orakaꞌ nkoaarimaung-koo? Aiꞌ pankaroong tamung taaravuri otopeuꞌ? ");
INSERT INTO nas_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ninge eeꞌ naurampimang, teie tee namuꞌke aarumo koontoꞌ donkompevuriaing. Teka bane teeꞌkoo, ning Tee Naning-naumpoꞌ Paning-etaing napoꞌ kansiꞌkoo mora arekeeꞌ, nantoong mmeꞌ baitoariri otoroko ooarampaing e?” ");
INSERT INTO nas_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Napoꞌ niiꞌnung narung kara dikitoꞌ Jiisuuꞌke nauvuruꞌnung aunge tooꞌpuri teing nantoong biiꞌka koontoꞌnuka tamparimaing ookara oovuning doonko ooaarima, ");
INSERT INTO nas_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kenaanka naninka nanuretuꞌnung dootuuꞌnava pankava-koo kunsiareeꞌnaang, narung Boto Keperuuꞌnavitu-koong eeꞌnoko niiꞌnung taakisi nkanuka-koong. ");
INSERT INTO nas_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tee Boto Keperuuꞌnavitu-koong donkonui kunsiarama aaꞌpuuꞌ, ‘Kumponing, ninge tampara tantamang daꞌkoo, aiꞌ ning tee niiꞌning nantoong-pinaꞌ deeaꞌ aaꞌning okoꞌokonuka, tosi ninka bakiaaꞌ nkonuka, nampeesi orarinuka, napoꞌ bakei aung-pinaꞌ taakisi nkanuka-koong-pinaꞌ deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ning tee kemuꞌkai unkumomaramaung uiki kante tampaꞌ kunsimaraaꞌnaang. Kapooꞌkoo kompamaing-koo Kumponing bakaning avonkooꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Teka tee niiꞌnung isipoꞌ donkonura, domang putuꞌarama, deto ankamparavaꞌ paning-aape aaꞌpuuꞌ, ‘Kumponing ee, piaamera tontaꞌmeai ning naning oreng nkoamaung.’ ");
INSERT INTO nas_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tee aung naning naurampimang Kumponing bakaang duta-koo koontoꞌ deempari duparuꞌnung, tee niiꞌnung deeaꞌ. Aiꞌ ookara nantoong biiꞌka detoarimaing Kumponinge doonko batarivuriaing, eeꞌnoko baa tee naning baka depetoaramaung Kumponinge deto sipuaing.” ");
INSERT INTO nas_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Enang teing nantoonge toireꞌ nerakauꞌnanka ninka Jiisuuꞌanko poꞌantavaarikoꞌ teie kompurira biraankevuriiꞌnaang. Eeꞌnoko tenang teinge bakaning barevare-nupoonge ooaarira poteaaruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Teka Jiisuuꞌke toireꞌ bokuvurima bakaning barevare-nupoong aaꞌpuruꞌnung, “Toireꞌ tauraꞌperereriko poroai ning-anko, paraꞌereriaꞌ, aiꞌ Kumponing bakaang muuꞌ nantoong amuriiꞌ okovuriaing. ");
INSERT INTO nas_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Masikaꞌ naurampimang ninge diiꞌ, baa tee naning Kumponing bakaang muuꞌ tootoꞌke bautaꞌ nkavui arooꞌaramanaꞌ kompuarura tee bakei tumparavaukaꞌnung teꞌ Kumponing bakaang muuꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Teketa tee naning pankainge niaꞌuuꞌnung Jiisuuꞌ, aaꞌpuma, “Daꞌ nau-anta tampara, ninge aming nkoamira domaang oparavaung okomupeuꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ tee, “Arekeeꞌkoo dake ning tampara tammemang? Niiꞌnara naning tampara otoaꞌ. Kumponing narung tampara. ");
INSERT INTO nas_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dake Moosesi bakaang boto noruꞌei otong, eeꞌ minkuvumaung, ‘Nampeesi orarieaukaꞌ, naning dupisiꞌeaukaꞌ, bakiaaꞌ nkoveaukaꞌ, daang-koo tuutunampeaukaꞌ, daumararing deto noruꞌeresi pakuereaing.’” ");
INSERT INTO nas_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Eeꞌnoko teie aaꞌpuuꞌ, “Aing ookara ninge tanatavantuꞌning ning okiꞌnaꞌnooꞌketa.” ");
INSERT INTO nas_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Eeꞌnoko tenang Jiisuuꞌke taaravura aaꞌpuuꞌ tee, “Daꞌ narung kapooꞌkoo makosiaꞌ. Baaveveaing ookara kapooꞌnanka dakaning, eeꞌnoko mooniꞌ nkavera tankaampeai teing-koo ataꞌoiꞌnuka-koo. Teeꞌ nkovera paning-koong kavonanka otoꞌderuaing. Eeꞌnoko ning siomei poai.” ");
INSERT INTO nas_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Teka teie teeꞌ taaravura orarunsiaruꞌ tee, aiꞌ tee aung tee kavo mmauꞌpoꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jiisuuꞌke tenkenuko oovuma aaꞌpuuꞌnung, “Bakei poreꞌ masikung teing-koo kavo mmauꞌpoꞌnupoong-koo muuꞌ Kumponing bakaang-koo tung-koo. ");
INSERT INTO nas_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kaameliꞌnavoroꞌ bamaruꞌkoong busie tumparavarupeuꞌnaꞌ bakei naning kavonanka-poꞌnung dau basinooꞌ makotuaꞌ Kumponing bakaang muuꞌkoo tung-koo.” ");
INSERT INTO nas_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Teinge taaravauꞌninge aaꞌpauꞌ, “Arekeeꞌ? Kavo mmauꞌpoꞌnupoong domaang mooꞌariarupeuꞌning deekoꞌ enang baa domaang mooꞌaravaing?” ");
INSERT INTO nas_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Teka teie aaꞌpuuꞌ, “Kapooꞌ nantoonge nko-koo makosiaavaung tee, teie Kumponinge nko-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Eeꞌnoko Piitai aaꞌpuuꞌ, “Aung ee, teka niiꞌke siparampiruꞌnung niikaning osinanka-poꞌ daꞌ siontampima.” ");
INSERT INTO nas_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ teing, “Masikaꞌ naurampimang ninge diiꞌ, baa tee naning aing aaꞌning sipuuꞌnung: pava, baꞌaang, baꞌmarang, niiꞌnooꞌ baurukaaꞌ Kumponing bakaang muuꞌ bereng-anta-koo, napoꞌ tee temuriiꞌ mmauꞌ otoꞌevuaing emuꞌnaroong-koo kansiꞌkoo otoitaaꞌ; ");
INSERT INTO nas_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","eeꞌnoko damaꞌnaroong-koo napoꞌ domaang oparavaung okovuainge.” ");
INSERT INTO nas_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","32","Eeꞌnoko bakaning pokaꞌurira nanaiꞌketa kenaanka aaꞌpuruꞌ teing, “Aing ee, Jerusalemaꞌaape deto meriiꞌnaang eeꞌnoko ookutunung kapooꞌnanka ning-koo, Tee Naning-naumpoꞌ Paning-etaing-koo, nakaro-nupoonge teroita minkumaama daariakoꞌning teke dupearaaꞌnaang, aaꞌnora: Juꞌkoong ovontunge siꞌmaavaing Juꞌdeeaing-anko, eeꞌnoko teka teinge akapeuꞌmaama maimaiaꞌnaꞌ nkomaavaing tutupeeꞌmaama. ");
INSERT INTO nas_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Teinge ning muraꞌmaara dupisiꞌmaavaing, teketa beenang doong deemparako napoꞌ daaꞌmaravaing.” ");
INSERT INTO nas_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Teka teinge tasiꞌpaavaꞌ teing aing kapooꞌnanka. Aung minkunaa tee teing-koo bakuꞌaruꞌnung, noruꞌke nkavaavaꞌ teing kapooꞌ minkuvuuꞌning. ");
INSERT INTO nas_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Teketa Jiisuuꞌ Jerusalemaꞌaape nariꞌ bema Jerikooꞌnavuntuꞌkoo dueꞌaruꞌnung teke kaputuꞌ, eenta bauko, taung miiringe baꞌnampari otoko. ");
INSERT INTO nas_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eeꞌnoko teie kaputuꞌke nantoong karikaꞌ tee-koo miiringe tankinaako taaravuruꞌnung eeꞌnoko niaꞌkuma aaꞌpuuꞌ, “Aung naampa aming-koo?” ");
INSERT INTO nas_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Teinge aaꞌpauꞌ, “Jiisuuꞌ, Nasaretiꞌnung tankinumaang.” ");
INSERT INTO nas_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Teketa bokuma aaꞌpuuꞌ, “Jiisuuꞌ, Deevitaꞌ bakanaving-koong, piaameai ning!” ");
INSERT INTO nas_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Eeꞌnoko teinge ureai nanaakoꞌninge orokoauꞌ tee aaꞌpaama, “Dooroontaravai!” Teka tee baruꞌ aaꞌnaꞌ bokuuꞌ aaꞌpuma, “Ovoring Deevitaꞌ bakanaving-koong, piaameai ning!” ");
INSERT INTO nas_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eeꞌnoko Jiisuuꞌ nasinura poꞌanta-koo botoaruꞌ tee-anko. Eeꞌnoko tenang dueꞌ poioꞌ Jiisuuꞌke niaꞌuuꞌ tee, ");
INSERT INTO nas_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Arekeeꞌ nkoramaꞌnaang piaromaang daꞌ, ninge?” Eeꞌnoko teie aaꞌpuuꞌ, “Ovoring ee, duta ning bantang-antameaing.” ");
INSERT INTO nas_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ tee, “Banteaing, dakaang baitoi tamparuꞌkiing.” ");
INSERT INTO nas_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Eeꞌnoko namuꞌke bantora tee Jiisuuꞌ siompuuꞌ Kumponing daangampuma. Eeꞌnoko ookara nantoonge teie ooaara Kumponing daangampauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Teketa Jiisuuꞌ mmeꞌ Jerusalemaꞌaape bema Jerikooꞌnamonoi tumparara osi-koo meerooꞌke tankinuko, eeꞌnoko teke naning narung otokoꞌnung miring Sakiasi; ");
INSERT INTO nas_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tee taakisi nkanuka-koong narung pankaing, eeꞌnoko mooniꞌke maantoꞌke. ");
INSERT INTO nas_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Eeꞌnoko tee Jiisuuꞌ tasiꞌpui oo-koo piavouꞌnung, teka makotuaruuꞌ nantoong karikaꞌke neeꞌaako naning apukung deemparama. ");
INSERT INTO nas_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Teeꞌkoo uroꞌkanooꞌ kuaꞌparara koiꞌnavarie miring sikamoaꞌke deto koinuuꞌ Jiisuuꞌ oovuuꞌnaang tevunge tankinuaing noruꞌui. ");
INSERT INTO nas_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eeꞌnoko tenang Jiisuuꞌ teꞌ basiarama deto ookuma oovura tee aaꞌpuuꞌ, “Sakiasi, iriꞌnarung depeto siraravai, aiꞌ ning dakanavaꞌkoo eꞌmung oꞌnooꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Teeꞌkoo iriꞌnarung depeto siarara dotuaritaaꞌ onkeonkeꞌuuꞌ tee Jiisuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Eeꞌnoko nantoonge ooaara tee minkuminkuauꞌ aaꞌpaama, “Naning orara bakanava-koo otooꞌnaang being.” ");
INSERT INTO nas_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Teka Sakiasie donkonura Ovoring aaꞌpuuꞌ, “Aung ee Ovoring, nkaang kavonanka-koo namarang ataꞌoiꞌnuka avorompaing, eeꞌnoko niiꞌnung naning kapooꞌ tamung nkaevontuꞌnung deekoꞌ napoꞌ karemuꞌpie oriꞌampaing.” ");
INSERT INTO nas_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ tee, “Eꞌmung domang-anta ava-koo poing, aiꞌ aung teie narung, Eebaraamiꞌ baurukaaꞌkoong. ");
INSERT INTO nas_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Eeꞌnoko ning Tee Naning-naumpoꞌ Paning-etaing tee nantoong pooarimaing eeꞌ eeꞌnaꞌ besiꞌarama domamparamaꞌnaang mouꞌnung.” ");
INSERT INTO nas_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tenang teinge aing kapooꞌnanka taaravai otoroko Jiisuuꞌke danto minkuvuma kara dikitoꞌ nauvuruꞌ noruꞌ koong-antavuriiꞌnaang. Aiꞌ mmauꞌ nantoonge daang eeꞌ noruꞌaakoꞌnung, Jiisuuꞌ daurarong˜ deempari Jerusalemaꞌ dueꞌka basiarara Roomaꞌnupoong bataꞌuriiꞌnaang Kumponing bakaang muuꞌ dupe-antavuma. ");
INSERT INTO nas_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Teeꞌkoo aaꞌpuuꞌ teie, “Naning narung ovorooꞌ niiꞌnameensiꞌkoo isipoꞌ nanuuꞌnung daurarong pankainge teka daurarong deeng-antavuko toroaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mmeꞌ beaꞌ teie bakaning botovotonaaꞌnuka-koo nanaiꞌ bokuvurira narung daakuꞌnamikunaꞌ kantevuruꞌ. Eeꞌnoko aaꞌpuruꞌ teing, ‘Aing mintoong-antaveriaining bera ning toromaravainooꞌke basi.’ ");
INSERT INTO nas_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Teka bakaning osikaiaang-koo niiꞌninge munteꞌaara tee-koo damaꞌdue kara nkanuka botoaarima tee daurarong pankaing-anko aaꞌpauꞌ, ‘Niiꞌ niikaang daurarong deeng-antaveaukaꞌ.’ Teka teie taaravuriaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Teketa tenang daurarong deeng-antavuioꞌ toroarara tee botoaruꞌnung bakaning botovotonaaꞌnuka mooniꞌ avuruꞌning tee-anko porora siraꞌpaavaꞌnaang bereng-antavauꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Eeꞌnoko tutunaꞌnung tee-anko uroꞌkanooꞌ pora aaꞌpuuꞌ, ‘Ovoring, dakaang mooniꞌ narung daakuꞌ ameuꞌnamiku napoꞌ kivora daakuꞌnamiku deeng-antarerontuꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Eeꞌnoko teie aaꞌpuuꞌ tee, ‘Bakei tampaꞌ nkoraruꞌnung daꞌ tampara botovotonaaꞌ. Teeꞌkoo tampaꞌ okiꞌnavuꞌkoo kakeꞌiiraruꞌnaꞌkoo daꞌ enang kivora-namonori osi pankeng-koo tarenung deeng-antaramaang.’ ");
INSERT INTO nas_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Eeꞌnoko kenaanka-nung pouꞌ tee-anko aaꞌpuma, ‘Ovoring, dakaang mooniꞌ narung daakuꞌ ameuꞌnamiku paꞌnokoꞌ daakuꞌnamiku deeng-antarerontuꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Eeꞌnoko teie aaꞌpuuꞌ tee, ‘Daꞌ enang paꞌnokoꞌnamonori osi pankeng-koo tarenung deeng-antaramaang.’ ");
INSERT INTO nas_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Teketa napoꞌ niiꞌnara pora aaꞌpuuꞌ, ‘Ovoring, dakaang mooniꞌ narung daakuꞌ ameuꞌnamiku aing, baarong-koo daiꞌamira teka tareantuꞌnamiku. ");
INSERT INTO nas_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Daꞌ dataramparura teeꞌ, aiꞌ daꞌ tee naning ivekung. Dakaning botovotonaaꞌnuka poreꞌoromaatoko damaꞌ pora derararaaꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Eeꞌnoko teie dauraronge tee aaꞌpuuꞌ, ‘Daꞌ botovotonaaꞌ orara masikung, teeꞌ minkumeinaare ninge enang toro-antavamaꞌnaang daꞌkoo. Masikaꞌ ee noruꞌmei otong naning ivekung? Nkaning botovotonaaꞌnuka poreꞌoromatoko damaꞌ mora deramaramaung ee? ");
INSERT INTO nas_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Teeꞌ noruꞌmei deekoꞌ arekeeꞌkoo nkaang mooniꞌ beeng-koo sipearuuꞌ, toromarara niiꞌning taakoreꞌning ninka nkavampeuꞌnung?’ ");
INSERT INTO nas_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Eeꞌnoko tee dauraronge teing nantoong dueꞌke donkonai otorokoꞌning aaꞌpuruꞌ, ‘Tee mooniꞌ pariꞌeriai tee aung, eeꞌnoko tee kivora daakuꞌnamiku otoꞌevuing averiai.’ ");
INSERT INTO nas_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eeꞌnoko teinge aaꞌpauꞌ tee, ‘Ovoring, aung aaꞌ kivora daakuꞌnamiku otoꞌevuing mmauꞌ otoꞌevung.’ ");
INSERT INTO nas_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Teka teie aaꞌpuuꞌ, ‘Ninge naurampimang diiꞌ aaꞌdampima, teing ookara kapooꞌ basi-antavaamaing dau basinooꞌ napoꞌ avuꞌkoong, eeꞌnoko tee naning kapooꞌ basi-antavuaung teing otoꞌevuining naroꞌka pariꞌkoong. ");
INSERT INTO nas_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Teka teing nkaning tooꞌde-nupoong ninge tare-koo piavoroaing tee teing poꞌantavererira anka ning-koo dutakanooꞌka dupisiꞌerereriaing.’” ");
INSERT INTO nas_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Eeꞌnoko tenang aung eeꞌ oroꞌ kapooꞌ minkuvura uroi Jerusalemaꞌaape deto beuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eeꞌnoko tenang Jerusalemaꞌ dueꞌarama teing-koo osi kemonora aaꞌning Bepasi eeꞌnoko Beetani teke Oliveꞌpoꞌnamii-koo teie bakaning-koo barevare-nupoong-koo kenaankara uroꞌke botovuretuꞌ aaꞌpurema, ");
INSERT INTO nas_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Amonokaꞌkoo duꞌdareai. Teꞌ duꞌdareta doonkiiꞌnu kampianu oovereeꞌnaang biꞌari otoko naning mmeꞌ baꞌnanuau. Dapaꞌereta aꞌ poꞌantavereai. ");
INSERT INTO nas_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Naninge niaꞌdurema aaꞌdureko, ‘Avoroꞌ aming-koo dapaꞌeremang?’ eeꞌ minkuereai, ‘Ovoring avoroꞌkoo nko-nko otoꞌevung.’” ");
INSERT INTO nas_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Teketa tee tenaanka botovuretuꞌnaankai bereta teeꞌ nariꞌ nauvuretuꞌnaꞌ oovuretuꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eeꞌnoko dapaꞌureko tevoroꞌ kampia-navoroꞌ oko-nupoonge aaꞌpaaretuꞌ, “Aming-koo avoroꞌ kampia-navoroꞌ dapaꞌeremang?” ");
INSERT INTO nas_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eeꞌnoko tenaankai aaꞌpuretuꞌ, “Ovoring avoroꞌkoo nko-nko otoꞌevung.” ");
INSERT INTO nas_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eeꞌnoko tenaankai Jiisuuꞌanko poꞌantavuretuꞌnung tevoroꞌ, eeꞌnoko biikaang baaronge taniꞌaara Jiisuuꞌ teu-koo dau baꞌnang-antavauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eeꞌnoko tevoroꞌke nanuko nantoonge baaronankai biikaninge taung taniꞌaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Teketa tee Oliveꞌpoꞌnamii booruꞌuma˜ Jerusalemaꞌaape dueꞌarama oroꞌparako teing ookara karikaꞌ barevare-nupoong doturotu tutumpariruꞌ Kumponing daangampaama bokiaama teing nko-nko iirakutananka ooaakoꞌning-koo aaꞌpaama, ");
INSERT INTO nas_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Biraanke-poꞌnung tee aung daurarong Kumponing bakaang miring-koo pomaang! Mooa eeꞌnoko tee meenasi aꞌdeiꞌke paning-koo otoaing.” ");
INSERT INTO nas_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eeꞌnoko niiꞌninge Boto Keperuuꞌnavitue karikaꞌkooninge aaꞌpauꞌ tee, “Nau-anta, orokoveriai dakaning barevare-nupoong teeꞌ minku-koo.” ");
INSERT INTO nas_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Eeꞌnoko teie makuꞌuma aaꞌpuuꞌ, “Ninge naurampimang aing dooroompariko deekoꞌ aing kapananka deto bokiaama teeꞌ minkuaapeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Eeꞌnoko tenang Jerusalemaꞌ dueꞌ pora teꞌ osi pankamono oovuma birompuruꞌ temono-nupoong, aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Bakaꞌe, eꞌmung diiꞌke tasiꞌperi dei tampaꞌ, ninge mooa-koo basi-antarampipeuꞌnaꞌ diiꞌ, teka enang tee diiꞌketa duta-ita bakuꞌaring. ");
INSERT INTO nas_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pomaang teꞌmung doong tenang diikaning kare-nupoonge porora kororai kuꞌnuntaariainaꞌmung taamang mooꞌeriaukaꞌ bera peerai taruriko teinge oꞌdaari doonko kansiꞌkoo duaꞌraariai diikaning pavananka nariꞌ, teing-kooning kapananka tuurampaama; ");
INSERT INTO nas_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aming-koo, nnaꞌ Kumponinge diiꞌ piaaruri beeroꞌduriko tasiꞌperiaung-koo.” ");
INSERT INTO nas_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Eeꞌnoko Jiisuuꞌ Jerusalemaꞌ basiararaiꞌnange, parang-koo tumparara pava dootuuꞌnava pankava-koong-koo, nantoong sipisipiꞌ dovang parekanumpoꞌ baaveveekoꞌning bataꞌ tutumpuruꞌnung. aaꞌpurima teing, “Daari Meekung-koo tee eeꞌ daariari otong, ‘Nkaang pava tee pava kunsinava deempari otoainava.’ Teka diiꞌke ‘bakiaaꞌ nkonuka biikanooꞌ’ deeng-antavering.” ");
INSERT INTO nas_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Teketa doong kante kara nau-antavurikoꞌ pava dootuuꞌnava pankava-koo. Eeꞌnoko piristiꞌkoo ovontunge eeꞌnoko boto naunukai eeꞌnoko pankenge taung besiꞌaakoꞌ Jiisuuꞌ dupisiꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Teka teinge kapooꞌ nkoaapeuꞌning ooaavaꞌ, aiꞌ nantoong dompirompiꞌorokoꞌnung bakaang kara taara-koo. ");
INSERT INTO nas_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Niiꞌnaꞌmung Jiisuuꞌke teke dootuuꞌnava pankava-koong parang-koo daankiarama doorenang tampara nau-antavurikoꞌ; ");
INSERT INTO nas_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Teketa teinge piristiꞌkoo ovontung eeꞌnoko boto naunuka, nantoong-koo urang-antanuka ninka tee-anko pororaiꞌnange aaꞌpauꞌ, “Naumeriai dake aremuriiꞌ tauraꞌ otoko dake aing kapooꞌnanka nkovemaatoinge, baie aruuꞌnunge tee tauraꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Teie makuꞌurima aaꞌpuuꞌ, “Iroꞌ ninge diiꞌ napoꞌ tanaꞌdampiko naumeriaing diiꞌke. ");
INSERT INTO nas_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Baie tauraꞌpuioꞌ Joonie nantoong ntong-koo minkivurima meekaꞌantavurikoꞌ, Kumponinge aiꞌ tamung nantoonge?” ");
INSERT INTO nas_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eeꞌnoko teing biiꞌka niaꞌeema aaꞌpeekoꞌ, “Areꞌpampiaꞌnaang? Aaꞌpampiko deekoꞌ, ‘Kumponinge,’ teie aaꞌmuriiꞌnaang, ‘Teka diiꞌke aming-koo Jooni masikaꞌantaveriarukoꞌ?’ ");
INSERT INTO nas_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Teka aaꞌpampiko deekoꞌ, ‘Tamung nantoong-etaing,’ ookarai nantoonge kapange dupisiꞌmaariiꞌnaang, aiꞌ teinge tee Jooni nakaronara Kumponing-etaing tasiꞌpai otong.” ");
INSERT INTO nas_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Teketa aaꞌpauꞌ makuꞌaama, “Niiꞌke aaꞌ noruꞌampiaꞌ baie pa tauraꞌpuioꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ teing, “Eeꞌ, ninge teeꞌke naurampiarooꞌnaang baa tee ning tauraꞌ amuuꞌnung aing kapooꞌnanka nko-koo.” ");
INSERT INTO nas_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Eeꞌnoko Jiisuuꞌke kato nau-antavurima aung kara dikitoꞌ nauvuruꞌ teing nantoong, “Naning narunge mintoonau uaininau keempuuꞌnung, teketa niiꞌning nantoong tenau tare-antavurira niiꞌnameensiꞌkoo tenkenuuꞌ pankaroong otooꞌnaang teke. ");
INSERT INTO nas_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Eeꞌnoko tenang batei sinang kavuꞌkoong makotuioꞌ teie narung bakaang botovotonaaꞌ botovuuꞌ teing-anko uaini tare nkonuka-anko niiꞌning sinang baarauni-koong˜ tenau-koo nkaevuaꞌnaang. Teka teinge tenau tare nkonukai tee botovotonaaꞌ murasiavaama bataꞌauꞌ tee baarauni avaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Teketa teie napoꞌ niiꞌnung botovotonaaꞌ botovuuꞌ. Tee eeꞌnung napoꞌ teeꞌ nariꞌ muraꞌaama maimaiaꞌnaꞌ nkoaama bataꞌauꞌ tee baarauni avaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Eeꞌnoko napoꞌ teeꞌ nariꞌ teie ovoringe beenaumo-nung botovuuꞌ, eeꞌnoko tee aung ereng-antavaara damaꞌdu duaꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Teketa teie uaininau ovoringe aaꞌpuuꞌ, ‘Enang aming nkoamaꞌnaang? Enang aaꞌ tee nnuring kirokai ninge aaꞌnaꞌ piaavamaung botoampaing. Teing pa amaiaaꞌoropeuꞌ tee-koo.’ ");
INSERT INTO nas_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Teka tenang teinge tare nkonukai tee bauring ooaara biiꞌka kareaama aaꞌpaakoꞌ, ‘Tee aung eeꞌnung barenku okovuaing. Aiaꞌ dupisiꞌampiai tee barenku okomuriainaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eeꞌnoko teinge tee uaininau-eta damaꞌdu duaꞌaara teka dupisiꞌauꞌ tee. Enang arekeeꞌ nkovuriaing teie tenau okovenunge? ");
INSERT INTO nas_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Teie aaꞌ tee teing tare nkonuka-anko pora tavurima opuriaing, eeꞌnoko niiꞌning oko-antavuriaing.” Tenang teinge taaravaara tee aung minkunaa aaꞌpauꞌ, “Ee aing, teing aaꞌ oo niiꞌke teeꞌ nkoauꞌnaꞌ nkoampiarupeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Teka teie ooꞌoovurima teing aaꞌpuruꞌ, “Nko temuriiꞌ nko-koo makosiriaung deekoꞌ anaare Daari Meekung-koonaare aming miruꞌari otong, ‘Tereꞌ eeꞌnareꞌ kapanareꞌ pava kaninukai pooreꞌaama duaꞌauꞌnareꞌ ookutunava-koo eꞌmanianareꞌ tumanareꞌ deemparioꞌ tasiꞌpauꞌ damaꞌke.’? ");
INSERT INTO nas_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ookara nantoong tereꞌkoo tasiꞌpaavaꞌ tupampariaining tee biiꞌka pisiraꞌariaing, bera baa tee naning tereꞌ dau duaꞌaravaing tee tereꞌke puutuvuaing.” ");
INSERT INTO nas_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Eeꞌnoko teketa tenang boto naunuka eeꞌnoko piristiꞌkoo ovontung tasiꞌpariruꞌ teie tee kara dikitoꞌ teing tooꞌantavuri minkuvurioꞌ. Eeꞌnoko tenang eeꞌnang taung besiꞌauꞌ Jiisuuꞌ daiꞌaavainavung, teka nantoong-koo avoreauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tee tee teinge keuai otokoꞌnung makensiꞌnavitu botoaarima tee-anko barevare-nupoong masikeng-pinaꞌ oroꞌpariri avakareaavaꞌnaang, eeꞌnoko kara minkuvuaining-koo oranaare taaravaara deekoꞌ ovoꞌmaꞌkoo tavoꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Teinge niaꞌaama aaꞌpauꞌ tee, “Nau-anta ee, niiꞌke noruꞌdampiri otong daꞌ koontoꞌnaꞌ karema nau-antamerimaung, tankaang-anta-pinaꞌ oroꞌdaravaunge, teka bakei masikaꞌ Kumponing bakanavung naumerimaung. ");
INSERT INTO nas_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Arekeeꞌ, niiꞌke Juꞌnupoonge ee daurarong˜ pankaing, Siisaꞌ, Roomaꞌnung taakisi avuꞌkoo makosi aiꞌ makosi deeaꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Teka teie biikaang avakare tasiꞌpura aaꞌpuruꞌ teing, ");
INSERT INTO nas_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ioꞌ mooniꞌnu naumeriai. Au-koo aung boreꞌ uuꞌaaꞌ baa-koong aaꞌnung miring daariari otong?” Teinge aaꞌpauꞌ, “Siisaꞌkoong.” ");
INSERT INTO nas_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Teketa teie aaꞌpuruꞌ teing, “Tee tee averiaing teing kapooꞌ Siisaꞌ bakaning tee-anko eeꞌnoko Kumponing bakaning Kumponing-aape averiai.” ");
INSERT INTO nas_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Teeꞌ makuꞌurioꞌ doona ooaavaꞌ baankaꞌaapeuꞌnaꞌ nantoong-koo uroꞌka, teka taꞌninaara dooroompariruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Teketa napoꞌ Noruꞌ Pitunavitu-koong˜ niiꞌning Jiisuuꞌanko nianiaꞌ ninka porouꞌ. Teing teing booꞌketa napoꞌ daaꞌ masikaꞌantavaavaꞌnavitu. Tevitu-koo niiꞌning Jiisuuꞌanko porora avakareaama eeꞌpinaꞌ niaꞌauꞌnung, ");
INSERT INTO nas_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Nau-anta, Mosesie aung boto daarimemuruꞌnung, ‘Naning narung booko baꞌaang otoko toireꞌ otoai tee donkaani baaraꞌmaꞌnunge nampuai teni naaro tee ninka bataata booꞌparuꞌnung tootoꞌ paravevureeꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Urikamuꞌ tee namaiaꞌ naroꞌka ˜kenaanka-taa otorokoꞌnung. Eeꞌnoko tutunaꞌnung nampeesiarara booꞌparuꞌ bauring otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Eeꞌnoko baaraꞌmaꞌnunge teni manikuma nampura teeꞌ nariꞌ booꞌparuꞌ bauring otoaꞌ. Teketa beenaumo-nunge; ");
INSERT INTO nas_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Teeꞌ nariꞌ temaiaꞌkoo ookara-koo ˜kenaanka-taa-koo nkoaruꞌ. Ookara boorouꞌ biurukaaꞌ otoroaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Eeꞌnoko asiꞌnaꞌmoo teni nani manikuma booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Enang teꞌmung asiranaꞌmung booꞌnuka daaꞌariainaꞌmung temaiaꞌkoo arera baꞌaang deemparavainani? Aiꞌ ookara ˜kenaanka-taae nampauꞌnanie teni.” ");
INSERT INTO nas_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ teing, ");
INSERT INTO nas_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","“Aung emuꞌnung batei-koo donkaang eeꞌnoko manikuꞌ nampeesiarimaung, teka damaꞌnung batei-koo teing Kumponinge makosi-antavuriaining booꞌketa daaꞌarira otoꞌkoo tee teing nampeesiariaukaꞌning, ");
INSERT INTO nas_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","aiꞌ teing tee napoꞌ booꞌkoo makosinuka deeaꞌ; aming-koo, nnaꞌ koosinunanka-pinaꞌ oroꞌnanka deempariko. Teing booꞌketa daaꞌariainooꞌkoo Kumponinge baurukaaꞌ deempariri otoroaing. ");
INSERT INTO nas_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moosesie eeꞌnarai teeꞌ nau-antamuruꞌnunge teing booꞌnuka domampariaing-koong kara. Bakaang dariraari-koo Kumponinge tuuꞌdoiꞌnavari tamung urusivukoꞌnavari-eta karoma Moosesi aaꞌpuuꞌ, ‘Ning tee Kumponing teing aing aaꞌning biikaang: Eebaraamiꞌ, Aisakeꞌ, Jeekopiꞌ. Teing ninka komeeri Oꞌnoi Oꞌnomaung ning.’ ");
INSERT INTO nas_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Teeꞌ minkuvuuꞌnung-koo tasiꞌpampiri otong ookara bakaning deempariri domantooꞌnuka otorong Kumponing bakaang duta-koo, booꞌnuka deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eeꞌnoko napoꞌ niiꞌning boto naunukai makuꞌaama aaꞌpauꞌ, “Nau-anta, daꞌ tampaꞌ kareing.” ");
INSERT INTO nas_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Teketa tee, teing ookara nantoong avoreauꞌ Jiisuuꞌ niiꞌning nianiaꞌ niaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Teketa Jiisuuꞌke biikaang noruꞌ tante-anta-koo aaꞌpuruꞌ teing, “Arekeeꞌkoo nantoonge aaꞌpaamaung, ‘Tee naning Kumponinge tero Pakoꞌpariꞌuuꞌnung nantoong domampuri tarevuriainooꞌkoo tee Deevitaꞌ bakanaving-koong deempari tavoꞌaraaꞌnaang.’? ");
INSERT INTO nas_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Aiꞌ Deevitaꞌke baka aaꞌpuuꞌnooꞌkoo tee-koo Buuku Kena-koo, ");
INSERT INTO nas_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‘Teie Ovoringe nkaang Ovoring aaꞌpuuꞌ, “Aꞌ ning-koo tampavine-koo baꞌnaniai bera ninge dakaning kare-nupoong dakaang kauꞌ patuꞌnanka deeng-antarerompainooꞌke basi.” ’ ");
INSERT INTO nas_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Teeꞌ minkuvuma Deevitaꞌke tee Pakoꞌpariꞌniiꞌ Ovoring Kumponing-pinaꞌ basi tampuuꞌnung. Enang Kumponing deemparako arekeeꞌ napoꞌ Deevitaꞌ bakanaving-koong tampaapeuꞌ?” ");
INSERT INTO nas_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eeꞌnoko ookara nantoonge taaravaioꞌ teie aaꞌpuruꞌ bakaning barevare-nupoong, ");
INSERT INTO nas_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tarerariai teing boto naunuka-koo biikaang aarumoi baaroꞌantaraariꞌneeng. Teing mononopaꞌ isikeng ninka avitoitoi nanuꞌkoo piavoromaing. Eeꞌnoko nantoonge pankaing-antavaariiꞌnaang piavorokooꞌ baaveromanairu-koo. Napoꞌ pava dootuuꞌnairu-koo baꞌnavaꞌnaniꞌnanka tampeng-koo baꞌnaniaakooꞌ nantoonge ankampaariaꞌnaang, eeꞌnoko paroro kante-koo pankeng-pinaꞌ noruꞌaariiꞌnaang piavorokooꞌ. ");
INSERT INTO nas_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eeꞌnoko naaroonku biikaning pava ookeng daping opoꞌ dunkumpaama kunsi isikenge dakarakaꞌpaakooꞌ orakaꞌ noruꞌaariꞌneeng-koo. Teing teing eeꞌning pankaing kiimata nkavaavaining.” ");
INSERT INTO nas_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jiisuuꞌke baakeenevuri oovurikoꞌnung mooniꞌ mmauꞌpoꞌnupoonge biikaang avuavuꞌ sipaako teke dootuuꞌnava pankava-koo. ");
INSERT INTO nas_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Eeꞌnoko teie teka nani naaro ataꞌoiꞌ oovuuꞌ mooniꞌning keura okiꞌning kuung sipuko. ");
INSERT INTO nas_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Eeꞌnoko teie bakaning barevare-nupoong aaꞌpuruꞌ, “Masikaꞌ naurampimang ninge, anie ataꞌoiꞌke naaroi aaꞌnaꞌ mmauꞌ sipuing ookara-ita. ");
INSERT INTO nas_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Teinge tee biikaang kapooꞌnanka mmauꞌketa sipaing, teka tenie tee ataꞌoiꞌketa ookara otoꞌevuining teni paku-koo makosining sipuing.” ");
INSERT INTO nas_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Niiꞌninge bakaning barevare-nupoong-koo pava dootuuꞌnava pankava teke minkuaakoꞌnung aaꞌpaama, “Bakei tampaꞌ oroꞌnava, kapang pipiꞌdaarie eeꞌnoko nepunepuꞌnanka avuavuꞌkooninge maantoꞌnavai.” ");
INSERT INTO nas_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Eeꞌnoko teeꞌ minkuaako Jiisuuꞌke aaꞌpuuꞌ, “Ooverimatomaing teing aing kapooꞌnanka naurampiaing: Doong pomaang teing aing kapananka tuurampaavainaꞌmung. Teinge piatooroi deroaama nareꞌ niiꞌnareꞌkoo daue panteꞌarioꞌ sipaavaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eeꞌnoko teinge napoꞌ niaꞌaama tee aaꞌpauꞌ, “Nau-anta ee, tee areꞌmoong teeꞌ nkoaravaing? Eeꞌnoko taaꞌniꞌanta aming teeꞌ nkoaraaꞌnaang dueꞌuko oo-koonge?” ");
INSERT INTO nas_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Eeꞌnoko teie aaꞌpuuꞌ, “Bakei tarerariri otoriaing nantoonge poo-antaraariꞌneeng, aiꞌ nantoong mmauꞌ nkaang miring tampaama porooꞌnaang aaꞌpaama, ‘Batei botu basiaring Tee Pakoꞌpariꞌniiꞌ toroaraaꞌnaang.’ Niiꞌnaꞌ eeꞌ, ‘Ning tee eeꞌnung.’ Teing teeꞌ kareavaining siompereriaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Eeꞌnoko tenang diiꞌke taaraverira karenanka eeꞌnoko nantoong biikaning taretarenanka paari-anta-koo turampeeko dankurankuꞌdariaukaꞌ, aiꞌ aing teing kapooꞌnanka teeꞌ oroꞌ tutung uroꞌke tavoꞌkuaining, teka botu namuꞌke tavoꞌkuaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Teketaꞌ aaꞌpuruꞌ teing, “Narung kansiꞌ iꞌamparama niiꞌnung kansiꞌ tavuainge, eeꞌnoko narung muuꞌ iꞌamparama niiꞌnung muuꞌ turampuainge. ");
INSERT INTO nas_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tenang pankainanka uꞌmiꞌ nkoaravaing, eeꞌnoko anairu tenairu-koo doovang ninka peera-koo booroainge. Avorokesiꞌnanka eeꞌnoko pankeng taaꞌniꞌantananka paning-eta nkoariainge. ");
INSERT INTO nas_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Teka mmeꞌ aing eeꞌ oroꞌ tavoꞌkuaruko diiꞌ tee mooꞌdaarima daiꞌdaariaing mankiꞌantaraarima, dootuuꞌ tare-nupoong-anko tavoꞌdaarima eeꞌnoko kiimatanairu-koo siꞌdaariai. Eeꞌnoko dauraronanka eeꞌnoko ovoꞌmaꞌnuka-anko tavoꞌdaariai nkaang miring nkaverimaung-koo. ");
INSERT INTO nas_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eeꞌnoko teeꞌ nkoraarima tampara doona araariai ning siraꞌmeriaing. ");
INSERT INTO nas_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tee tee koontoꞌ okoteꞌdoriaing norunoruꞌ mmauꞌ nkoveriaꞌ otoriaing tuutunang˜ nimpaꞌeriainaꞌ nemperi. ");
INSERT INTO nas_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Aiꞌ ninge tee arompiaing tee matau minkueriaing aaꞌnung turantaarining-koo narung makotuaꞌ diiꞌ makuꞌduriaing daang deeng-antarurima. ");
INSERT INTO nas_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Diiꞌ teing kare-nupoong-anko sing-antaraariaining bane ainge aaꞌninge: diumatakaampie eeꞌnoko diiꞌmarang eeꞌnoko teing diikanamuiaang eeꞌnoko diiꞌmaikororiꞌ eeꞌnoko niiꞌning diiꞌkoo teing dupisiꞌdaariaining. ");
INSERT INTO nas_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Eeꞌnoko napoꞌ munteꞌdaariai ookarai nkaang miring-koo. ");
INSERT INTO nas_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Teka tee diiꞌkoo daponaviꞌ naviꞌ diikaang boreꞌketa paaꞌaravaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Teka purintariri otoriaing diiꞌ domantariainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Teka tenang diiꞌke temono Jerusalemaꞌnamono piatooronukai koroaioꞌ ooverira tee noruꞌeriaing temono pesiꞌaravainaꞌmung emuꞌ dueꞌuing. ");
INSERT INTO nas_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Eeꞌnoko tenang teing aꞌ Judiaꞌnameng-koo otoroaining miinanka-koo deto bakei navoꞌka kooꞌariaing! Eeꞌnoko osi pankamono-koo kuung otoromaing mmariaavai, eeꞌnoko damaꞌdu-eta nantoong kuung tumpariaukaꞌ naroꞌka tavaariꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aiꞌ teing aing doong teing Kumponing meroꞌaravaining teeꞌ nariꞌ Daari Meekung-koo daariari otoinaꞌ dupe-anta-koo. ");
INSERT INTO nas_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bakei piaaruꞌnuka otoroaing teing kempoꞌnuka eeꞌnoko napoꞌ teing biurukaaꞌ noonooꞌkoo otoroaining, aiꞌ teing tapotaponuka, mmariꞌkoo makotuaꞌ. Teꞌmung teꞌmung paapaaꞌnaꞌmung avaro-koo, Kumponing bakaang iira aing-koo nantoong-koo tavoꞌarako. ");
INSERT INTO nas_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Teing-koo tee niiꞌning bainatue tooꞌpaarima niiꞌning daiꞌaarima avoraꞌtevoaraꞌke beꞌantavaariaing. Eeꞌnoko Jerusalemaꞌ teꞌ Juꞌdeeainge mmemmeꞌaavainooꞌ bera tenang teing biikanang doong oparavainange basi.” ");
INSERT INTO nas_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Teketa tee taaꞌniꞌantananka oroꞌparavaing aing aaꞌning-koo duaaꞌ eeꞌnoko kaara, beentoꞌ. Eeꞌnoko anke kansiꞌkoo ookutunairu-koo tee nantoong domang aaꞌnaꞌ mankiꞌoroaing aaꞌnoaing-koo pirung tang korimparavai booꞌa taꞌdaꞌparama. ");
INSERT INTO nas_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Eeꞌnoko nantoong teing avoroꞌke kaiꞌantavuriaing, ookara kansiꞌ oraruꞌkuainooꞌ naroꞌ nempai. Aiꞌ teing purintoꞌnanka kapooꞌ paning-kooning teinge dankampuriaininge. ");
INSERT INTO nas_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Teka tenang teing aing ookara kapooꞌnanka nko tutumparako deto ookiriai ankantariri, aiꞌ tee batei ninge mooꞌdampiainang dueꞌdurimang; ");
INSERT INTO nas_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Eeꞌnoko tenang teinge ning Tee Naning-naumpoꞌ Paning-etaing oomaavaing purintoꞌ ninka moko kamoꞌka kuunge depeto aaꞌnaꞌ meenaꞌmoi.” ");
INSERT INTO nas_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Teketa Jiisuuꞌke narung kara dikitoꞌ nau-antavuruꞌ, aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","“Tee baisi dovang nenuvaraꞌuko ooverima eeꞌ noruꞌerikooꞌ teketa deto puaravuuꞌnaang dueꞌka. ");
INSERT INTO nas_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Teeꞌ nariꞌ napoꞌ diiꞌke teing aing kapooꞌnanka naurampirining tavoꞌkuko ooverira tee noruꞌeriaing Kumponing bakaang muuꞌ tee dueꞌ pomaang. ");
INSERT INTO nas_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Masikaꞌ naurampimang ninge diiꞌ, aing enanavarang mmeꞌ paaꞌariaruko nkoaravaing teing aing kapooꞌnanka ookara. ");
INSERT INTO nas_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Paning eeꞌnoko kansiꞌ teing paaꞌareaining, teka nkaang kara tee paaꞌaravaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Teka domang pinkaꞌdariri otoriai Kumponing-koo dompirompiꞌdariainaꞌ. Tamung iriꞌ oꞌdariaukaꞌ paroro narung naierima, purintoꞌnaruꞌke kanuꞌdarima, eeꞌnoko kansiꞌkoong mankiꞌnanka-koo norunoruꞌdarima, teeꞌ tarerariaruko teꞌmung taꞌnimpaariiꞌnaꞌ taaviꞌduriꞌneenga. ");
INSERT INTO nas_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aiꞌ teꞌmung doong teꞌmung ookutunairu dakaꞌpui tavoꞌaravainaꞌmung. ");
INSERT INTO nas_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Teka ookara batei-koo tanatarariri otorimaatoai, kunsirarima aing ookara kapooꞌnanka-koo purintariri divuꞌeriainaꞌ eeꞌnoko ning-koo, Tee Naning-naumpoꞌ Paning-etaing-koo, uroꞌkanooꞌ tampaꞌ donkoniriainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ookara batei-koo tee Jiisuuꞌke Dootuuꞌnava-koo Pankava-koo nau-antavurikoꞌ, eeꞌnoko muunga tenkenuma Oliveꞌpoꞌnamii tampaamanamii-koo teke otoi daunaꞌmung nempukoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eeꞌnoko taneꞌpuko oraꞌka ookara nantoong dootuuꞌnava pankava-koo porokoꞌ tee taaravaavaꞌnaang daankiarako teke. ");
INSERT INTO nas_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Enang tee tee paroro Juꞌ biikaang bereteꞌ iisiropa-koong dueꞌuuꞌnung, tee doong Kumponinge Iisipiꞌnupoong biurukaaꞌ booꞌantavurima Juꞌnupoong biurukaaꞌ baariꞌuruꞌnaꞌ taaꞌniꞌanta-koong. Aaꞌnoioꞌ Juꞌnupoonge sipisipiꞌkoo sieꞌnanka booꞌantavaarira erenge pavananka-koo karanaang sisiꞌauꞌ eeꞌnoko Kumponinge teeꞌ oovura baariꞌuruꞌ. Teeꞌkoo miring Paroro Baariꞌkoong˜ tampaakoꞌnung. ");
INSERT INTO nas_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Teꞌmung doong dueꞌuko teinge piristiꞌnuka-koo ovontunge eeꞌnoko boto naunukai taung besiꞌaakoꞌ Jiisuuꞌ booꞌanta-koong, teka poreꞌorokoꞌ nantoong karikaꞌkoo avoreaama. ");
INSERT INTO nas_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Teketa tenang Sietaniꞌ Judasi Kerioꞌnung-koo kuung tumparuꞌ tee eeꞌnung nanaiꞌketa kenaanka-koong narung. ");
INSERT INTO nas_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tee bera aing aaꞌning ninka mumunsiauꞌ: piristiꞌnuka-koo ovontunuka eeꞌnoko teing dootuuꞌnava pankava orokovui tarenuka˜koo boreꞌnuka arekeeꞌ teie teing-anko Jiisuuꞌ sing-antavuainaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eeꞌnoko teinge dotuarira tee mooniꞌ avuꞌkoo tampauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Eeꞌnoko teie makosinaꞌ tampura doong besiꞌuuꞌ teing-anko sing-antavuainooꞌ karikaꞌke ooaavaruko. ");
INSERT INTO nas_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Teketa tee Paroro Bereteꞌ Iisiropa-koong doong tavoꞌkuuꞌnung, teꞌmung eeꞌnaꞌmung sipisipiꞌkoo sieꞌ Taamang Baariꞌkoong pareka nkonaꞌmung. ");
INSERT INTO nas_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Eeꞌnoko teꞌmung doong Jiisuuꞌke Piita naanka Jooni botovurema aaꞌpuuꞌnung, “Bereta niikaang Taamang Baariꞌkoong maamu-antamemurereriai naiampiainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tenaankai aaꞌpuretuꞌ tee, “Dake areꞌke maamu-antavampeeꞌnaang neeꞌke botomeremang?” ");
INSERT INTO nas_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Teie aaꞌpuretuꞌ tenaanka, “Anaanka ee, tenang deeꞌ Jerusalemaꞌ tuntareko naning narunge utau ntong-poꞌnung ipampui kuru-koo teka kuneꞌdureaing. Tee siomperesi bereaing tee tumparavainava-koo. ");
INSERT INTO nas_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Eeꞌnoko tee pava okonara nauerema aaꞌpereaing, ‘Teie nau-antai daꞌ aaꞌduinung, “Davisimainku biikanavaro arevaroi teke nkaning barevare-nupoong ninka Baariꞌkoong Taamang naiampiai-navaro?” ’ ");
INSERT INTO nas_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eeꞌnoko teie tee pankavaro daunavaro naurureaing neri bakeniiꞌnavaro. Teke taamang maamu-antavereaing.” ");
INSERT INTO nas_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eeꞌnoko tenaankai basiareta teeꞌ eeꞌnaꞌ nauvuretuꞌnaꞌ ookara oovuretuꞌ, eeꞌnoko tenaankai teke maamu-antavuretuꞌ tee Taamang Baariꞌkoong. ");
INSERT INTO nas_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eeꞌnoko tenang batei makotuioꞌ taamantoma tumpariruꞌnung Jiisuuꞌ bakaning kara okovuri nkanuka ninka nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Eeꞌnoko teie aaꞌpuruꞌ teing, “Ning aaꞌnaꞌ noruꞌke piamouꞌnung aung Taamang Baariꞌkoong diiꞌ ninka nariꞌ nai-koo tutung baike toraꞌpampaꞌ, ");
INSERT INTO nas_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aiꞌ ninge tee naurampimang ning tee aung amuriiꞌkoo napoꞌ naikampaukaꞌnung bera bakaang miruꞌ masikung dupearavainooꞌke basi Kumponing bakaang muuꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Teketaꞌ tenang uaininareng avaako nkavura kompui tampaꞌ tampura Ovoring-koo aaꞌpuruꞌ, “Aung nkaverira tankaanteeriai, ");
INSERT INTO nas_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aiꞌ ninge tee naurampimang enang-eta deto tee naikamparooꞌnaang uaininaruꞌkoo bera Kumponing bakaang muuꞌ tavoꞌkuainooꞌke basi.” ");
INSERT INTO nas_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Eeꞌnoko teie bereteꞌnu nkavura Kumponing-koo tampaꞌ tampura pisiꞌura avurima aaꞌpuuꞌ, “Aung tee nkaang mono makosi diiꞌ neeꞌdampima booꞌkoo tauraꞌmaring. Eeꞌ naierima ning norunoruꞌmerimaꞌnoaing.” ");
INSERT INTO nas_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Eeꞌnoko taamang bakearako napoꞌ teeꞌ nariꞌ nkovuuꞌ uaini-poꞌnareng nkavura, aaꞌpuma, “Enang-eta deto areng-koo naikirima eeꞌ noruꞌmeriaing: Ninge Kumponing ninka nerakung kara naroong-anta nkaang erenge pinkaꞌantavantuꞌnung diiꞌ domantariiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Teka, ee aing, tee bireng tee-koong ning kare-nupoong-anko simuaing-koong niꞌninka nariꞌ toonampemang aventoꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aiꞌ ning Tee Naning-naumpoꞌ Paning-etaing teeꞌ Kumponinge temuꞌketa maromuuꞌnaꞌ moompaing, teka tee naning tooka kompui kare-nupoong-koo ning simuaing tee bakei piaaruꞌ masikung, toraꞌkuainung.” ");
INSERT INTO nas_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eeꞌnoko teing tee biiꞌka nianiaꞌ tutumpeuꞌ narunaꞌ narunaꞌ, aaꞌpaama, “Baa niiꞌkoo teeꞌ nkoaravainge?” ");
INSERT INTO nas_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Eeꞌnoko napoꞌ teing barevare-nupoong biiꞌka tataꞌ tutumpeuꞌ teing-koo baa pankaing masikung ookarai noruꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ teing, “Teing dauraronanka akovitu biikaning tee booniꞌantavaarimaing teka ookarai teinge tareaarimaing miring pankaing nkavaamaung nantoong tampaꞌ nkonuka tang-koong. ");
INSERT INTO nas_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Teka diiꞌkoo teeꞌ nkoaravaukaꞌ. Diiꞌ tee aaꞌnoaing, tee pankaing diiꞌkoo tee asiꞌnooꞌnung-pinaꞌ otoaing, eeꞌnoko tee urantanung pakupakunung otoaing. ");
INSERT INTO nas_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Baa pankaing tamperikooꞌ, aiꞌ tee naning niiꞌning botovurimaung, aiꞌ tee naning pakupakunung? Tee eeꞌnara nantoong botovurimaung naning pankaing tamperikooꞌ, apeꞌ aing? Teka ning diiꞌkoo meuꞌke tee naning pakupakunung-pinaꞌ oꞌnomaung. ");
INSERT INTO nas_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Diiꞌke tee niꞌninka nariꞌ parapaara-koo orakaꞌ oꞌnori siꞌmeriaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Eeꞌnoko Mmaꞌke ning iriꞌ tare-koong amuuꞌnaꞌ napoꞌ teeꞌ nariꞌ ninge diiꞌ iriꞌ tare-koong arompimaang diiꞌ aaꞌnoainaꞌ taamanirima tuaantariai nkanaventoꞌkoo nkaang muuꞌkoo kuunge; ");
INSERT INTO nas_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Eeꞌnoko tee diiꞌ kante baꞌnantariri kara simpeꞌerimaatoaing teing kivora-ita kenaanka muuꞌ Isireeli-nupoong-koo ovontuntariri.” ");
INSERT INTO nas_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Eeꞌnoko Ovoringe aaꞌpuuꞌ, “Saimoniꞌ ee, Saimoniꞌ, Sietaniꞌ tee tauraꞌpari otong parapaarai naaranturiiꞌnaang; ");
INSERT INTO nas_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Teka ninge daꞌ paku-koo eentamaring dakaang baito paaꞌaravarooꞌnaang. Eeꞌnoko tenang duaruaꞌdaravainooꞌketa napoꞌ bereꞌdarara daꞌmaikoriꞌ puring antaveriaing.” ");
INSERT INTO nas_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Eeꞌnoko Piitai makuꞌuma Jiisuuꞌ aaꞌpuuꞌ, “Ovoring, ning maamumari oꞌnong daꞌ ninka nariꞌ nanuꞌkoo kiimataroma eeꞌnoko booꞌaape.” ");
INSERT INTO nas_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jiisuuꞌke aaꞌpuuꞌ, “Ninge nauramaang, Piita, eꞌmoong kokoreeꞌ mmeꞌ kooꞌkuaruko beemuꞌpie daꞌ penkentaravaing ning noruꞌmei otoinooꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Eeꞌnoko Jiisuuꞌke napoꞌ aaꞌpuruꞌ teing, “Tenang ninge diiꞌ botorampiruꞌnang aing aaꞌning otoꞌderuriarukoꞌnung: kereka, eeꞌnoko siirauꞌ eeꞌnoko boonamante˜, niiꞌning kapooꞌkoo ee apukaꞌdarikoꞌ?” Teinge aaꞌpauꞌ, “Otoaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Eeꞌnoko teie aaꞌpuruꞌ teing, “Teka enang baa naning siirauꞌ otoꞌevuinge nkavuaing, kereka otoꞌevuinge deekoꞌ. Eeꞌnoko bainatu otoꞌevuaung deekoꞌ bakaang mononopaꞌ baavevuraiꞌnange niiꞌnariꞌ mooꞌsiiviai. ");
INSERT INTO nas_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aiꞌ ninge naurampimang diiꞌ, aung kara Daari Meekung-etaing tee dupearavaing ning tooꞌmui eeꞌ minkumui oꞌnoing, ‘Tee tee boto-totoꞌnuka ninka deeruniiꞌ.’ Eeꞌnoko kapooꞌ ning-koo daariari otoining teing koontoꞌ dupearavaininge.” ");
INSERT INTO nas_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eeꞌnoko daunang kuuntuꞌkai aaꞌpauꞌ teinge, “Ovoring ee, bainatuning keriꞌka aing.” Eeꞌnoko aaꞌpuruꞌ, “Otoaing, makosi.” ");
INSERT INTO nas_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Teketa danto tenkenura Oliveꞌpoꞌnamii-koo nanuuꞌ, teroita bekoꞌnooꞌ. Eeꞌnoko bakaning barevare-nupoonge nariꞌ siompai berouꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Teka teie eeꞌ nauvuruꞌ teing, “Kumponing-koo kunsirariai parapaara-koo duaꞌdariꞌneenga.” ");
INSERT INTO nas_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Teketa okiꞌnooꞌ danto nanuuꞌ kapang baiꞌkoo makosinooꞌ deeꞌma, eeꞌnoko kinkinura eeꞌ kunsiaruꞌ, ");
INSERT INTO nas_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mmaꞌ, daꞌ piarora deekoꞌ pinau tauraꞌmeaing aung kiimata-koong kaapu baariꞌamaꞌnaang, teka tee nkaang pia deeaꞌ, daka dakaang pia siong-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Eeꞌnoko tenang koosinung˜ paning-eta tee-anko pora puring-antavuuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Eeꞌnoko tee aaꞌnaꞌ orarunsie puruꞌantavui otoko aaꞌnaꞌ deto iriꞌoi kunsiarako ionta erenamuriiꞌ aaꞌnaꞌ mootuꞌoi tuuvui duaꞌaruꞌ kansiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Eeꞌnoko tenang kunsiaruꞌnooꞌketa deto iꞌamparara barevare-nupoong-anko pora teing aasiaioꞌ oovuruꞌ orarunsie puruꞌurira. ");
INSERT INTO nas_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Eeꞌnoko teie aaꞌpuruꞌ teing, “Aming-koo aasirimang diiꞌ? Daaꞌdarira kunsirariai parapaara-koo duaꞌdariꞌneenga.” ");
INSERT INTO nas_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Teka Jiisuuꞌ teeꞌ karoi otoko karikaꞌ teke tavoꞌariruꞌnung Judasie barampuri, tee eeꞌnung nanaiꞌketa kenaanka-koong narung. Eeꞌnoko Judasi Jiisuuꞌanko beuꞌnung nuunuvuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Teka Jiisuuꞌke aaꞌpuuꞌ tee, “Judasi, dake ee ning Tee Naning-naumpoꞌ Paning-etaing nuunu ninka kare-nupoong-koo simemaang?” ");
INSERT INTO nas_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eeꞌnoko tenang bakaning barevare-nupoonge nariꞌ otorokoꞌninge arekeeꞌ nkoaravainaꞌ ooaara teinge aaꞌpauꞌ, “Ovoring, bainatue tavarampiai ee?” ");
INSERT INTO nas_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eeꞌnoko teing-koo narunge piristiꞌkoong pankaing bakaang botovotonaaꞌ tekaꞌpuma domeꞌ tamparomeꞌ eteꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Teka Jiisuuꞌke aaꞌpuuꞌ, “Ei, bakerari.” Eeꞌnoko Jiisuuꞌke bakaang domeꞌ kompura tempaꞌantavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Eeꞌnoko Jiisuuꞌke teing tee tooꞌdeaama porouꞌning aaꞌning: piristiꞌnanka-koo ovontung, dootuuꞌnava pankava orokovui tarenuka˜koo boreꞌnuka eeꞌnoko Juꞌnupoong-kooning pankenanka aaꞌpuruꞌ, “Diiꞌke ee ning tavuꞌ ninka bakiaaꞌnko deemerima bainatu dovang ninka eeꞌnoko ankonuꞌ poring? ");
INSERT INTO nas_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tenang ning diiꞌ ninka nariꞌ oꞌnoi doong kante dootuuꞌnava pankava-koo ning diiꞌke komeriaꞌ, teka aung tee batei diiꞌ diikaang, mutaanang-koong iriꞌ ninka.” ");
INSERT INTO nas_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Teketa tee teinge Jiisuuꞌ mooꞌaara nkavauꞌnung bera piristiꞌnuka biikaang pankaing bakanavaꞌkoo tavoꞌauꞌ. Piitai damaꞌke isipoꞌketa kaarie sipuma siompukoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eeꞌnoko pava-koo uroꞌmang teing Jiisuuꞌ mooꞌauꞌninge ntaꞌ betuꞌaara baꞌnaniaioꞌ napoꞌ Piita teꞌ baꞌnanuuꞌ teing-koo meuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Teketaꞌ nanie neraiꞌnaꞌke botovotonaaꞌke oovuuꞌnung araka-koo baꞌnamparioꞌ, eeꞌnoko keuvukotaaꞌ aaꞌpuuꞌnung, “Aung naning tee Jiisuuꞌ ninka nariꞌ otoremaung.” ");
INSERT INTO nas_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Teka tee penkemparuꞌ, aaꞌpuma, “Ani ee, ninge tee noruꞌampaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Napoꞌ teketa pankaroompuaruko niiꞌnunge napoꞌ oovura aaꞌpuuꞌ, “Daꞌ aung teie, teing-koong narung.” Teka Piitai aaꞌpuuꞌ, “Aung ee, ning deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Eeꞌnoko niiꞌning batei narung aua-pinaꞌ tankinuko, napoꞌ niiꞌnunge deravari aaꞌpuuꞌ, “Bakei tasiꞌpansi oꞌnong aung, tee narung napoꞌ teing ninka otoromaung, aiꞌ aung Kaaleliꞌnupoong-pinaꞌ karomang.” ");
INSERT INTO nas_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Teka Piitai aaꞌpuuꞌ, “Aung ee, ning noruꞌampaꞌ kapooꞌ dake minkuemaatomaung.” Eeꞌnoko tenang namuꞌke teeꞌ karoi otoko kokoreeꞌ kooꞌkuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eeꞌnoko Ovoringe bereꞌarama Piita dutai naapu narung oovuuꞌ. Eeꞌnoko Piita-koo tenang noruꞌkoo pouꞌ tee Ovoring bakaang kara tee eeꞌ minkuvuuꞌnung, “Kokoreeꞌ mmeꞌ kooꞌkuaruko daꞌ beemuꞌpie penkentaravaing ning noruꞌmei otoinooꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Eeꞌnoko teketa tenkenura orarunsiari biromparuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Enang tee teinge nantoonge Jiisuuꞌ kompai otokoꞌninge duta daiꞌaara muraꞌaama akapeuꞌaama aaꞌpaakoꞌ, ");
INSERT INTO nas_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","“Tarampeerarama˜ tampeai baie teeꞌ muraꞌdumaang?” ");
INSERT INTO nas_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Eeꞌnoko niiꞌning mmauꞌ kara oreng minkuaakoꞌ tee-koo. ");
INSERT INTO nas_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tenang taneꞌpuioꞌ pankeuꞌ urantanuka oosiariruꞌ aaꞌning: piristiꞌnuka-koo ovontung eeꞌnoko boto naunuka kara taaraevaavaꞌnaang, eeꞌnoko Jiisuuꞌ teing-koo koompaaraꞌnavitu-koo meuꞌ poꞌantavauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Eeꞌnoko aaꞌpauꞌ, “Daꞌ tee Kumponinge tero Pakoꞌpariꞌniiꞌ niiꞌ domameri taremeriainooꞌkoo deekoꞌ naumeriai!” Teka teie aaꞌpuruꞌ teing, “Ninge naurampiko deekoꞌ masikaꞌantameriarooꞌ naang. ");
INSERT INTO nas_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Eeꞌnoko ninge niaꞌdampiko deekoꞌ makuꞌmeriarooꞌnaang, niiꞌnooꞌ simpiriꞌantameriarooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Teka enang-eta deto tee ning Tee Naning-naumpoꞌ Paning-etaing Kumponing Iriꞌ Okonara-koo tampavine-koo baꞌnamaraaꞌnaang tare-nko deemari.” ");
INSERT INTO nas_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Eeꞌnoko ookarai aaꞌpauꞌ, “Arekeeꞌ miruꞌemaang? Daꞌ ee Kumponing Bauring?” Eeꞌnoko makuꞌurima aaꞌpuuꞌ, “Teeꞌ minkuerinaꞌ nariꞌ oꞌnong.” ");
INSERT INTO nas_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eeꞌnoko teinge aaꞌpauꞌ, “Niiꞌning aming kara besiꞌampiiꞌnaang niiꞌke aung dupisiꞌkoo makosi? Tee tee aung enang niiꞌka taaravampiring bakaang beꞌduuꞌke Kumponing akapeuꞌuko bauring tamparama!” ");
INSERT INTO nas_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Teketa ookara naroꞌariruꞌning daaꞌarira Pailatiꞌanko tavoꞌauꞌ eeꞌnung daurarong Siisaꞌke botovuuꞌnung Judiaꞌnavaro tare-koo. ");
INSERT INTO nas_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Eeꞌnoko teka teinge tuumpi tutumpauꞌ aaꞌpaama, “Niiꞌke enang daaꞌampiring aung naning nantoong Siisaꞌ bakaang tare-ita onou kentaang-antavurimaung, tee Siisaꞌanko taakisi duaꞌkoo orokovurikooꞌ, eeꞌnoko aaꞌpukooꞌ, ‘Ning tee tero Kumponinge diiꞌ domang-anta-koo maraka-antaruruꞌnung, daurarong pakoꞌpariꞌantamuma.’” ");
INSERT INTO nas_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eeꞌnoko Pailatiꞌke niaꞌuuꞌ tee, aaꞌpuuꞌ, “Daꞌ ee tee Juꞌnupoong biikaang daurarong?” Eeꞌnoko teie makuꞌuma tee aaꞌpuuꞌ, “Teeꞌ nariꞌ minkueinaꞌ oꞌnong.” ");
INSERT INTO nas_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Eeꞌnoko Pailatiꞌke teing piristiꞌkoo ovontunanka karikaꞌ ninka nariꞌ aaꞌpuruꞌ, “Ninge kapooꞌ orakaꞌ nkovuing ooampaꞌ aung-koo diiꞌke tuumpi-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Teka teinge eꞌmanai aaꞌpaakoꞌ, “Aunge nantoong Roomaꞌnung daurarong bakaang tanata-ita ketaꞌpariiꞌnaang irikung-antavurimaung nau-antavurima Judiaꞌnameensiꞌ dakaꞌpui, Kaaleliꞌnameensiꞌketa bera aaꞌ amono-koo basivukooꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tenang Pailatiꞌke taaravura tee aung kara teie tanaꞌuuꞌ tee Kaaleliꞌnung deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Eeꞌnoko tenang teie Pailatiꞌke Kaaleliꞌnung noruꞌura, teie Jiisuuꞌ Eerotiꞌanko botovurioꞌ beꞌantavauꞌ, tee Siisaꞌke Kaaleliꞌnavaro tarenara deeng-antavuuꞌnung-anko, aiꞌ Eerotiꞌ Kaaleliꞌketa Jerusalemaꞌ beeroꞌui otokoꞌnung tee paroro oo-koo. ");
INSERT INTO nas_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tenang Eerotiꞌke Jiisuuꞌ oovura aaꞌnaꞌ dotuaruꞌ pankaroong oo-koo piavokoꞌnung-koo nantoonge minkuaako taaravukoꞌnooꞌka tee. Eeꞌnoko teie niiꞌning taaꞌniꞌanta iriꞌpoꞌning nkovuko deekoꞌ oovuuꞌnaang piavouꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Teeꞌkoo Eerotiꞌke pankapankaroonge nianiaꞌ niaꞌuuꞌ, teka Jiisuuꞌke niiꞌnauꞌ makuꞌevuaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Teketa piristiꞌkoo ovontung eeꞌnoko boto naunukai teke donkonai iriꞌoroitaaꞌnange tuumpiaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eeꞌnoko Eerotiꞌ ninka bakaning piatooronukai uriꞌnarimpaama orakaꞌ nkoaakoꞌ akapeuꞌaama, teketa nepuꞌnaꞌ mononopaꞌ booꞌantananka tee-koo daurarong-pinaꞌ kurumpaara Eerotiꞌke toro-antavuuꞌ Pailatiꞌanko. ");
INSERT INTO nas_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Eeꞌnoko teꞌmung eeꞌnaꞌmung Eerotiꞌ naanka Pailatiꞌ napoꞌ navueeretuꞌ temuꞌketa tee turampeerekoꞌnaanka. ");
INSERT INTO nas_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Teketa Pailatiꞌke piristiꞌkoo ovontung, tare-nupoong eeꞌnoko nantoong naroꞌurira aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Diiꞌke tee aung naning ning-anko tavoꞌering daurarong Siisaꞌ bakaang tare-ita nantoong onou kentaang-antavurimaung tamperima. Tee-koo ee aing, ninge diiꞌkoo uroꞌkanooꞌka baakeeneama kapooꞌ diiꞌke tuumpierimaing-koo narung ooampaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Eerotiꞌke teeꞌke, niiꞌanko toro-antavuing-koo noruꞌampiringe kapooꞌ oovuaꞌ. Ooveriko, kapooꞌ aung booꞌanta-koo makosi aunge nkovuaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ninge muraꞌke kiimata-antavamira niikaang toomo siompansitaaꞌ siꞌantarerompiaing.” ");
INSERT INTO nas_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tee tee toomo ookara mareꞌ kante Baariꞌkoong˜ Paroro-koo Pailatiꞌke tee narung kiimatanuka-koo kiimata-ita simpiriꞌantaevurikoꞌ nantoong piavoroko. ");
INSERT INTO nas_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Teka ookarai nariꞌ bokiaama aaꞌpauꞌ, “Booꞌantaveainung tee aung naning, eeꞌnoko Barabas sing-antaveai niiꞌanko.” ");
INSERT INTO nas_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas tee naning kiimata-koo sipauꞌnung Siisaꞌ bakaang tanata totoꞌkoo tavuꞌ tutumpuioꞌ Jerusalemaꞌkoo meuꞌke eeꞌnoko naning dupisiꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","21","Pailatiꞌke Jiisuuꞌ simpiriꞌanta-koo piavora napoꞌ niiꞌnamuꞌ daankivuruꞌ, teka teinge bokiaama aaꞌpauꞌ, “Aaꞌbarataꞌkoo, aaꞌbarataꞌkoo taakaveai!” ");
INSERT INTO nas_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Napoꞌ beemuꞌpinaꞌ teie aaꞌpuruꞌ teing, “Aming-koo? Aming orara kapooꞌ nkovuinge? Ninge aung-koo orooꞌ aung booꞌanta-koo makosinooꞌ ooampaꞌ. Teeꞌkoo ninge kiimata-antavamira simpiriꞌantavamaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Teka teinge aaꞌnaꞌ deravariri bokiaama aaꞌbarataꞌkoo taakavaavaꞌnaang tampaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Eeꞌnoko baruꞌ aaꞌnaꞌ bokiaako teeꞌkoo Pailatiꞌke tauraꞌpuma boto sipuuꞌ kapooꞌ piavorouꞌnaꞌ nkoaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Teketa teie bake-antavuuꞌ tee naning kiimata-koo sipauꞌnung Siisaꞌ bakaang tanata totoꞌkoo tavuꞌ tutumpuioꞌ eeꞌnoko naning dupisiꞌuioꞌ, tee eeꞌnara teing eentavaarikoꞌnung, eeꞌnoko Jiisuuꞌ teing biikaang bireng-koo sipuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Eeꞌnoko teinge Jiisuuꞌ tuutunantoma-ita tenkeng-antavaama aaꞌbarataꞌ poruꞌantavauꞌ. Teketa mankiꞌoi nkavuko naning poraꞌketa poko kompauꞌ miring Saimoniꞌ, Sairini-nung, eeꞌnoko teinge tee aaꞌbarataꞌ tee-koo poruꞌantavauꞌ Jiisuuꞌkoo damaꞌdue nkavuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Eeꞌnoko teketa nantoong karikaꞌke siompauꞌ, eeꞌnoko niiꞌning manikuꞌke nariꞌ orarunsiariri birompaama tee siompauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Teka Jiisuuꞌ teing-aape bereꞌarara aaꞌpuruꞌ, “Diiꞌ manikuꞌ Jerusalemaꞌnupoong, ning biromeriaukaꞌ, teka diiꞌka birontariai eeꞌnoko diurukaaꞌ toireꞌ birompererima. ");
INSERT INTO nas_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aiꞌ, ee aing, doonanka pomaang ookara mankiꞌoroainang, baruꞌ teing biurukaaꞌpoꞌnupoong biurukaaꞌ baikeaariko orarunsiariaining. ");
INSERT INTO nas_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Eeꞌnoko tenang baiarima aaꞌpaavai, ‘Iuꞌnanka niiꞌkoo dau duaꞌdariai eeꞌnoko miinankai dakaꞌmereriai.’ ");
INSERT INTO nas_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ning naning tampara eeꞌ kiimatamaako oomerira tasiꞌperiaing diiꞌ aaꞌnaꞌ dau basinooꞌ toraꞌantaraariaing kiimata-koo makosinuka deentariko.” ");
INSERT INTO nas_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Niiꞌnaanka kenaankara oraanka teeꞌ nariꞌ beꞌantavaaretuꞌ tee ninka nariꞌ dupisiꞌaareeꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Eeꞌnoko tenang teꞌ basiarira Makupiꞌ tampaamanooꞌ teka tee aaꞌbarataꞌkoo taakavauꞌ, eeꞌnoko tenaanka oraanka nariꞌ, narung tampavine-aape eeꞌnoko narung mareꞌaanavine-aape. ");
INSERT INTO nas_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Mmaꞌ tontaꞌantaveriaing teing, aiꞌ teinge tee noruꞌaavaꞌ nkoaamang tee aung kapooꞌ.” Eeꞌnoko teinge piatooronukai deikooꞌeema bakaang mononopaꞌ tankaampeuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Eeꞌnoko nantoong tee-ankoi dueꞌke donkonai ooai otokoꞌ, eeꞌnoko ovontunge akapeuꞌaakoꞌ tee aaꞌpaama, “Aunge tee nantoong oovuning domaang mooꞌurikooꞌ, enang baka mooꞌaravai, aung Kumponinge Pakoꞌpariꞌniiꞌ, tero niiꞌ domang-anta-koo maraka-antamuruꞌnung deekoꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Eeꞌnoko napoꞌ teke tee narunge dariraari eeꞌ oroꞌ beemuꞌpie daariauꞌ tee-koo boreꞌkanooꞌke: AUNG TEE JUꞌNUPOONG BIIKAANG DAURARONG; ");
INSERT INTO nas_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kirikiꞌnaꞌ, Roomaꞌnaꞌ eeꞌnoko Iiburunaꞌ daariauꞌ; ");
INSERT INTO nas_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Eeꞌnoko teinge piatooronukai akapeuꞌaama porora uaini kaaveeriiꞌ avuꞌkoo paaravauꞌ aaꞌpaama, “Daꞌ tee Juꞌnupoong Biikaang Daurarong deekoꞌ enang daka domaang mooꞌdaravai.” ");
INSERT INTO nas_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Narunge tenaanka-koo oraanka-koo nariꞌ biꞌaaretuꞌnaanka-koo Jiisuuꞌ orakaꞌ minkuvuma aaꞌpuuꞌ, “Daꞌ ee tee Domang-anta Kumponinge tero Pakoꞌpariꞌniiꞌ deeaꞌ? Enang daka domaang mooꞌdaravai, eeꞌnoko neeꞌ nariꞌ mooꞌmereai.” ");
INSERT INTO nas_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Teka teie niiꞌnunge tee akaꞌpuma aaꞌpuuꞌ, “Daꞌ ee Kumponing-koo aroreaꞌ otong eeꞌ nariꞌ booꞌaape oꞌnoritaaꞌ? ");
INSERT INTO nas_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Neeꞌke tee makosinaꞌ toraꞌpampemang meroꞌkoo nkoampemaing-koo, teka aunge kapooꞌ orara nkovuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eeꞌnoko teie aaꞌpuuꞌ Jiisuuꞌ, “Norunoruꞌmeai ning tenang dakaang muuꞌ taaꞌniꞌdoi kompema.” ");
INSERT INTO nas_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ tee, “Masikaꞌ ninge nauramaang daꞌ, eꞌmung eeꞌnaꞌmung niꞌninka nariꞌ oꞌnoreeꞌnaang daꞌ osi tampooꞌke˜.” ");
INSERT INTO nas_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Enang tee duaakiꞌuko duaaꞌ namuꞌke kaꞌmuruntaꞌuuꞌ ookutunairu-koo bera kamunooꞌnang deekoꞌ duaaꞌ kooꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tenang duaaꞌ mutaanampuioꞌ tee baarong pava dootuuꞌnava pankava-koong, meekavaro kuꞌnung, meuꞌ keꞌmeꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eeꞌnoko Jiisuuꞌ aaꞌnaꞌ deto bokuma aaꞌpuuꞌ, “Mmaꞌ ee, nkaang tanuaang dakaang bireng-koo sipansing.” Eeꞌnoko teeꞌ minkuvuma asiꞌnamuꞌ domaang oparuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Teketa enang teie piatooro daakuꞌ tarenunge tee aung kapooꞌ nkoaruꞌnung oovura teie Kumponing pankaing-antavuuꞌ aaꞌpuma, “Masikaꞌ, tee aung naning tee orakaꞌnko otoꞌevuaung.” ");
INSERT INTO nas_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Eeꞌnoko ookara karikaꞌ teꞌ naroꞌariruꞌning dooroariiꞌnaang tenang ookara kapooꞌ nkoaruꞌnung-koo osi-aape toroariruꞌ orarunsiariri domang tavarima. ");
INSERT INTO nas_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Eeꞌnoko ookarai Jiisuuꞌ noruꞌaakoꞌninge, eeꞌnoko manikuꞌ Kaaleliꞌketa siompauꞌning nariꞌ, teinge isipoꞌ donkonai ooauꞌ tee kapooꞌnanka. ");
INSERT INTO nas_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Enang tee naning narung otokoꞌ miring Josepaꞌ, Arimateaꞌnamono-koong, Juꞌnupoong biikaning-koo osi-koo namono. Aung Josepaꞌ tee narung koompaaraꞌnavitu-koong pankaing, naning tampara, koontoꞌ, eeꞌnoko nemparakoꞌnung Kumponing bakaang muuꞌ oo-koo; ");
INSERT INTO nas_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Bane teie koompaaraꞌnavitu-koong narung, nka Jiisuuꞌ dupisiꞌaavaꞌnaang minkuaako tee kontevouꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Teie eeꞌnunge Pailatiꞌanko bera Jiisuuꞌ bakaang mono eentavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Eeꞌnoko aaꞌbarataꞌketa sing-antavura baaronge booꞌnuka daiꞌnaꞌ daiꞌuma nopaꞌura sipuuꞌ teie kuvi dakoꞌdoma-koo kuung, aaꞌnooꞌ kapang-koo nenkeꞌuuꞌnareng, naning tutung dakoꞌaavaꞌnareng. ");
INSERT INTO nas_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tee tee teꞌmung Doong Uaanaꞌmung-koo maamunaꞌmung eeꞌnoko tee Doong Uaanaꞌmung dueꞌui otoko namuꞌke dakoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Eeꞌnoko teinge manikuꞌke Kaaleliꞌketa Jiisuuꞌ ninka porouꞌninge Josepaꞌkoo biꞌariri berora tee kuvi dakoꞌdoma ooauꞌ eeꞌnoko Jiisuuꞌ bakaang mono bempauꞌnaꞌ ooauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Teketa tee osi duparira duuninanka numpompoꞌning maamu-antavauꞌ bakaang mono sisiꞌkoo, eeꞌnoko teꞌmung Doong Uaanaꞌmung tee uaavoroi otorouꞌ botoi minkuvui otoinaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Teka Saandei-naꞌmung tero maata teing manikuꞌ berouꞌ teꞌ kuvi dakoꞌdoma, duuni numpompoꞌning maamu-antavauꞌning nkavai, Jiisuuꞌkoong mono sisiꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Eeꞌnoko teinge kapang kuvi dakoꞌdoma karanaang-eta korimparioꞌ ooauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Teka tenang kuung tumparira Ovoring Jiisuuꞌkoong mono ooaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tenang noruꞌ tee-koo paapaaꞌariri otoroko bakei taꞌninaꞌ kenaanka naninka teing-koo dueꞌ donkonuretuꞌ mononopaꞌ sisisiisie nopaꞌaresi. ");
INSERT INTO nas_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Eeꞌnoko teketa avoreaara teing teꞌ doonko kansiꞌkoo kinkinauꞌnung, eeꞌnoko tenaankai aaꞌpaaretuꞌ, “Aming-koo diiꞌke tee domantooꞌ anka booꞌnuka biikanooꞌka besiꞌerimang? ");
INSERT INTO nas_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tee aꞌ otoaꞌ; tero daaꞌaring; ");
INSERT INTO nas_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Napoꞌ noruꞌeriai teeꞌ Kaaleliꞌ otori naururuꞌnaꞌ, tee tee Naning-naumpoꞌ Paning-etaing tavoꞌaavaing orananka biikaang bireng-koo eeꞌnoko aaꞌbarataꞌkoo taakavaako beenang doong deemparako napoꞌ daaꞌaravai.” ");
INSERT INTO nas_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Eeꞌnoko teinge tenang noruꞌauꞌ tee bakaang kara. ");
INSERT INTO nas_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Eeꞌnoko kuvi dakoꞌdoma-ita osi duparira teinge teing nanaiꞌketa narung nauaaruꞌ tee aung kapooꞌnanka, eeꞌnoko napoꞌ teing niiꞌning ookara barevare-nupoong nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ainge maniiꞌke dooreaaruꞌ teing kara okovuri nkanuka, ainge aaꞌnoko Meeriꞌ Maꞌdala-nani, eeꞌnoko Joana eeꞌnoko Meeriꞌ teni Jeemisi bauko, eeꞌnoko niiꞌning manikuꞌ napoꞌ nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Teka tee aung karananka teinge nauaaruꞌning minkunaa boturopa-pinaꞌ noruꞌauꞌ. Eeꞌnoko teinge masikaꞌantavaariaꞌ teing. ");
INSERT INTO nas_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Teka Piita iꞌamparara kuvi-aape kuaꞌparuꞌ, eeꞌnoko kinkinura daanto kuung oovuma baarong teka oovuuꞌ booꞌnuka daiꞌkoong baka otoko. Eeꞌnoko teketa osi duparuꞌ paapaaꞌari tee-koo kapooꞌ nkoaruꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Teketa teꞌmung eeꞌnaꞌmung Jiisuuꞌ bakaning barevare-nupoong-koo kenaanka nanuretuꞌ niiꞌnamono-koo miring Emeasi aaꞌnooꞌ Jerusalemaꞌketa kenaanka aua makosinooꞌ nanuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","Eeꞌnoko tee kapooꞌnanka nkoaruꞌning-koo nariꞌ minkuarema nanureko Jiisuuꞌ baka dueꞌ pora nariꞌ nanaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Teka beekaang duta dootai tavuretuꞌ tee tasiꞌkoo. ");
INSERT INTO nas_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eeꞌnoko teie aaꞌpuretuꞌ tenaanka, “Aung minkunaa aremuriiꞌ deeꞌke orarunsiraresi minkuerema naniremaang?” Eeꞌnoko teꞌ dantavaretuꞌ tenaanka orarunsi-poꞌnaanka-pinaꞌ oroꞌparesi. ");
INSERT INTO nas_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tenang narunge tenaanka-koo miring Kiliopasiꞌke aaꞌpuuꞌ tee, “Arekeeꞌ minkuemaang? Daꞌ ee Jerusalemaꞌke aing-koo doompeto otoitaaꞌ taarakiaꞌ teing-koo kapooꞌ nkoarieening-koo?” ");
INSERT INTO nas_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eeꞌnoko teie aaꞌpuretuꞌ tenaanka, “Aming kapooꞌnanka?” Eeꞌnoko tenaankai tee nauvurema aaꞌpuretuꞌ, “Jiisuuꞌ Nasaretiꞌnung bakaang minkunaa, tee nakaronara karoma nko-koo purintoꞌpoꞌnung Kumponing-koo eeꞌnoko ookara nantoong-koo uroꞌkanooꞌke. ");
INSERT INTO nas_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tee eeꞌnung niikaninge piristiꞌnanka-koo ovontunge eeꞌnoko tare-nupoong aaꞌninge tavoꞌauꞌnung kavumani-aape simpeꞌai orara tampaara dupisiꞌaavaꞌnaang, eeꞌnoko aaꞌbarataꞌkoo taakavauꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Teka niiꞌke eeꞌ noruꞌampikoꞌnung tee tee eeꞌnung niiꞌ Isireeli-nupoong napoꞌ donkomuriaing. Eeꞌ, teketa tee aung ookara nkoarieenooꞌketa eꞌmung tee beenang doong deemparing. ");
INSERT INTO nas_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aaꞌnoing niiꞌninge manikuꞌke niiꞌkooninge taꞌning-antamaaring. Taneꞌke tero beroraiꞌnange kuvi dakoꞌdoma eeꞌnoko teinge ooaavaruing bakaang mono; ");
INSERT INTO nas_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Eeꞌnoko teinge toroarira aaꞌpaing, ‘Niiꞌke koosinunka noone-pinaꞌ ooarampiring, aaꞌpuresinaanka, “Tee domamparing.” ’ ");
INSERT INTO nas_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Teketa barevare-nupoong-koo niiꞌning teꞌ kuvi dakoꞌdoma-aape beroing, eeꞌnoko teeꞌ nariꞌ ooai manikuꞌke minkuainaꞌ, teka tee ooaavaꞌ teinge.” ");
INSERT INTO nas_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Eeꞌnoko teie tenaanka aaꞌpuretuꞌ, “Bakei kanuꞌka eeꞌnoko domange masikaꞌanta-koo anaꞌkai tee kapooꞌnanka Kumponing-etaing nakaro-nupoonge tero minkuauꞌnanka-koo. ");
INSERT INTO nas_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Arekeeꞌ, teeꞌ ee teing aing baikenanka kuneꞌuarupeuꞌ teie domang-anta-koo Pakoꞌpariꞌniiꞌke aarenuuꞌnaang bakaang nerang-koo kuung?” ");
INSERT INTO nas_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Eeꞌnoko ookutunairu Daari Meekunge tee baka-koo minkuvui otoinairu tasiꞌantavuretuꞌ Moosesi bakanarong-eta tutumpura doonko teing nakaro-nupoong biikanaronge basivuma nauvuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Teeꞌ minkuarima osinamono-koo dueꞌ porouꞌ tenaanka berekoꞌnamono-koo. Eeꞌnoko basiarima tankinuuꞌnaang-pinaꞌ nkoarako teka tenaankai datevuretuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aaꞌpuretuꞌ, “Neeꞌ ninka oꞌnoreai, aiꞌ aung muung-aapevuing, doong pankarong oparing.” Tee tee nariꞌ tenaanka ninka berouꞌ teke nariꞌ otorooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tenang taamantomai otoroitaaꞌ teka bereteꞌnu nkavura biraankevura eeꞌnoko pisiꞌura tenaanka avuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Eeꞌnoko beekaang duta tenang daateꞌarara tasiꞌpuretuꞌ tee, eeꞌnoko tee teke paaꞌaruꞌ tenaanka-koo dutakanooꞌketa. ");
INSERT INTO nas_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tenaanka beeꞌka karorema aaꞌparetuꞌ, “Maikoꞌ, neeꞌkoo tee domang-koo ntaꞌ betuꞌantamuresing taunge neeꞌ karamurema Daari Meekung-kooning kara neeꞌkoo siraꞌpuma!” ");
INSERT INTO nas_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Eeꞌnoko tenaanka tenang tee batei-koo iꞌampareta Jerusalemaꞌaape toroaretuꞌ eeꞌnoko bereta teing nanaiꞌketa narung kuneꞌaareta nariꞌ oosiariri otoroko napoꞌ niiꞌning ninka nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Eeꞌnoko teinge tenaanka aaꞌpaaretuꞌ, “Ovoring bakei masikaꞌ daaꞌaring. Saimoniꞌkoo oroꞌpari.” ");
INSERT INTO nas_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Eeꞌnoko tenaankai napoꞌ teing nauaaretuꞌ teing kapooꞌ tenaanka-koo taunge nkoaruꞌning, eeꞌnoko tenaanka-koo tasiꞌparuꞌnaꞌ bereteꞌ pisiꞌuuꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tee tee tenaankai teeꞌ minkuvuresi otoreko tee Jiisuuꞌ baka teꞌ teing-koo meuꞌ donkonura aaꞌpuuꞌ, “Tampara, ee aing! Mooa tee diiꞌkoo otoaing!” ");
INSERT INTO nas_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Teka teing domang taꞌninaara avoreauꞌ tanuaang ooauꞌnung-pinaꞌ noruꞌaama. ");
INSERT INTO nas_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eeꞌnoko teie aaꞌpuruꞌ teing, “Nko diiꞌ aming-koo avoroꞌke tairurimang? Aming-koo noruꞌ keekooꞌdariri? ");
INSERT INTO nas_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Oomeriai bireng eeꞌnoko kauꞌ tasiꞌmeri, ning tee ning. Ioꞌ komerira oomeriai, aiꞌ tanuaang tee aaꞌning bioꞌ eeꞌnoko kooꞌ otoaung teeꞌ ning oomerimatomanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eeꞌnoko teeꞌ minkuvurira nau-antavuruꞌ bakaang bireng eeꞌnoko kauꞌ niirie tooꞌpauꞌnairu. ");
INSERT INTO nas_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eeꞌnoko teeꞌ nariꞌ dotue maantoꞌurira noone-pinaꞌ noruꞌai masikaꞌantavaavaꞌ papaaravaririoꞌ aaꞌpuruꞌ teie teing, “Kapooꞌ ee nai-koo makosi anke otomang?” ");
INSERT INTO nas_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eeꞌnoko teinge taviꞌnooꞌ uaꞌniiꞌnooꞌ avauꞌ, davainta nariꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Eeꞌnoko teie nkavura tee teinge ooaioꞌ maaꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Teketa tenang aaꞌpuruꞌ teing teie, “Aing teing nkaning kara diiꞌ naurampiruꞌning tenang diiꞌ ninka nariꞌ oꞌnoi aaꞌpama: Ookara tee kapooꞌnanka Daari Meekunge ning-koong tero minkuvuuꞌnung koontoꞌ dupearavaining aaꞌnooꞌke Moosesi bakaang boto, nakaro-nupoong biikaang kara, eeꞌnoko ookara kenananka otoinooꞌke.” ");
INSERT INTO nas_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","47","Tenang teeꞌ minkuvura biikaang onou daateꞌantavuruꞌ noruꞌaavaꞌnaang tee Daari Meekung-koong karananka aaꞌpurima, “Teroita eeꞌ daariari otomaung, tee Domang-anta Kumponinge Pakoꞌpariꞌuuꞌnung˜ pora baike kuneꞌura beenang doong deemparako booꞌketa daaꞌaravai, eeꞌnoko napoꞌ tee domang bereꞌanta eeꞌnoko tontaꞌanta orakaꞌ nko-ita daankiaavaing bakaang miring-koo ookara kansiꞌkoo-nupoong-koo Jerusalemaꞌketa tutumpaara. ");
INSERT INTO nas_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eeꞌnoko ninge aaꞌdampimang, ninge tenaare dupeanko ooverimaing deentaririoꞌ diiꞌ eeꞌning teing daanki nkonuka miruꞌdampimang aing kapooꞌnanka siraꞌperiaining. ");
INSERT INTO nas_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Eeꞌnoko ee aing, ninge tee Tanuaang Meekung Mmaꞌke maraka-antavuuꞌnung botoampaing diiꞌkoo dau otoꞌkoo. Teka anke osi pankamono-koo otoriaing diiꞌ bera purintoꞌke paning-etainge maantoꞌduriainooꞌke basi.” ");
INSERT INTO nas_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Teketa temono-ita bakaning barevare-nupoonge Jiisuuꞌ siompai berouꞌ bera Beetani-navuntuꞌkoo, eeꞌnoko bakaang bireng toonura biraankevurikoꞌ teing bakaning barevare-nupoong. ");
INSERT INTO nas_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eeꞌnoko biraankevurima tee deto iꞌamparara paning-aape tenkenuuꞌ teing-ankoita. ");
INSERT INTO nas_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eeꞌnoko teinge pankaing-antavaara tee toroariruꞌ Jerusalemaꞌaape aaꞌnaꞌ doturotuarima. ");
INSERT INTO nas_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Eeꞌnoko beꞌnuꞌai Kumponing daangampaama eeꞌnoko biraankeaama otorokoꞌ pava dootuuꞌnava pankava-koo. ");
INSERT INTO nas_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tenang tutunaꞌ masipoꞌ Kumponing bakaang Kara˜ Matau Okonara ovorimpari otokoꞌnung. Tee aaꞌnung kansiꞌ mmeꞌ pupuꞌaravaruko Kumponing ninka nariꞌ otoresi Kumponing-naumpui otokoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Eeꞌ, tee eeꞌnung teeꞌ tutunaꞌnooꞌka Kumponing ninka otorekoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ookara kapooꞌnanka teing teie nkovuruꞌning. Kapooꞌnanka nkoniiꞌnanka-koo narung kapooꞌ otoaꞌ teie nkovuaruko tavoꞌaruꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tee-koo kuunge domaang okoraꞌari otouꞌ, eeꞌnoko tee domaang tee nantoong biikaang araka deempari otouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Eeꞌnoko tee araka mutaanang-koo arakavari otoi otomaung, teie mutaanange tee dakaꞌkoo punkaampuaruko˜. ");
INSERT INTO nas_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aung aaꞌ tee, naning niiꞌnara tavoꞌaruꞌnung miring Jooni. ");
INSERT INTO nas_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kumponinge botovuioꞌ pouꞌ ookara nantoong nauvuriiꞌnaang tee araka, siraꞌparako masikaꞌantavaavainaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jooni tee, tee araka deeaꞌ, nka tee Jooni pouꞌ tee araka minkuvuma. ");
INSERT INTO nas_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tee minkuvukoꞌnung tee araka masikung, ookara nantoong aꞌ kansiꞌkoo pontoꞌarimaing araka-antavurimaung. ");
INSERT INTO nas_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tee tee kansiꞌkoo pontoꞌarara otokoꞌ, tee aaꞌnung kansiꞌ nkovuuꞌnung, teka teing kansiꞌnupoonge tasiꞌpaavarukoꞌnung tee. ");
INSERT INTO nas_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bane baka bakaning meekupoong-anko poioꞌ, teka teinge tee arooꞌaavarukoꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Niiꞌninge deekoꞌ arooꞌaako teie teing ookara iriꞌ avuruꞌ Kumponing baurukaaꞌ deempariiꞌnaang, teing bakaang miring pankaing masikaꞌantavauꞌning deempariko. ");
INSERT INTO nas_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Teing teing Kumponing baurukaaꞌ pontoꞌniiꞌnuka; biumaraang-koong erenge deeaꞌ, mono-koong piai deeaꞌ, eeꞌnoko naning bakaang mataue deeaꞌ; teing baka Kumponinge baurukaaꞌ deeng-antavuruꞌning. ");
INSERT INTO nas_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Eeꞌ, tee Kumponing bakaang Kara Okonara tee mono-poꞌnung deemparuꞌ eeꞌnoko niiꞌ ninka nariꞌ otouꞌ tee teinge piaa naankai eeꞌnoko tee kara masikung aaꞌninge maantoꞌ. Bakaang domaang-eta arakavarioꞌ ooampiruꞌnung tee tee-pinaꞌ tee Bauring narung masikung kirokai bakaang meenasi Bauma-itaing. ");
INSERT INTO nas_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joonie tee minkuvuuꞌ; bokuma aaꞌpuuꞌ, “Aung eeꞌnara naning minkuankoꞌnung, aaꞌpankoꞌnung: Naning tee ning-koo damaꞌke pomaang tee bakei ning puruꞌmui otong. Ning paramaavaruko teroita otouꞌnunge.” ");
INSERT INTO nas_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Biraanke-antamuriko niiꞌ ookara bautaꞌnanka nkavampikooꞌ bakaang avusiroꞌ pankaing okoraꞌarioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kumponinge bakaang boto Moosesi avuioꞌ teie niiꞌ pareꞌmuruꞌ; piaa naning otoaꞌ tee boto tampaꞌ tarevui tee kiimata baariꞌupeuꞌnung (Rom 8:3).’ eeꞌnoko kara masikung taꞌniꞌpoi minku Jiisuuꞌ Karistooꞌkoo kuunge poꞌantavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Naning otoaꞌ Kumponing oovuuꞌnung. Bauring narung masikung kirokai, tee narung bauma ninka navuaremaung. Teie eeꞌnarai Kumponing tampaꞌ naumurimang. ");
INSERT INTO nas_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juꞌkoong ovontung Jerusalemaꞌnupoonge piristiꞌnanka eeꞌnoko biikaning pakupakunanka botoaaruꞌ Jooni tanaꞌaavaꞌnaang, aaꞌpaavaꞌnaang, “Daꞌ baa eeꞌnara?” ");
INSERT INTO nas_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Eeꞌnoko tanaꞌaako Joonie kapooꞌ bakuꞌuaꞌ tampaꞌ siraꞌpari aaꞌpuruꞌ: “Ning tee Kumponing-etaing teroita Pakoꞌpariꞌniiꞌ˜ deeaꞌ, nantoong domampurira tarevuriaing.” ");
INSERT INTO nas_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Teeꞌpuko aaꞌpauꞌ, “Daꞌ eeꞌnara baa, Eliasi ee?” Eeꞌnoko Joonie makuꞌurima aaꞌpuruꞌ, “A, ning tee deeaꞌ.” Eeꞌnoko napoꞌ niaꞌaama aaꞌpauꞌ, “Daꞌ ee tee nakaronung nempampimaung ee?” Eeꞌnoko makuꞌurima aaꞌpuruꞌ, “Otoaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eeꞌnoko napoꞌ niaꞌaama aaꞌpauꞌ, “Nka daꞌ eeꞌnara baa? Naumeriaing nantoong botomaarining nauarampiainaꞌ. Daꞌ baa daka tantaramaung?” ");
INSERT INTO nas_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Eeꞌnoko Joonie makuꞌurima aaꞌpuruꞌ, “Teie nakaronarai Aisaiaꞌke urikamuꞌ ning-koo minkuvuuꞌ Daari Meekung-koo aaꞌpuuꞌnooꞌka, ‘Aurong narung naning-koong, naning meeꞌboraꞌ sirakamaaꞌ otoi bokuma aaꞌpumaang, maamu-antaveriaing tee taung Ovoring bakaang. Koompevuriaing poainavung.’” ");
INSERT INTO nas_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Niiꞌning napoꞌ teꞌ otorokoꞌ Boto Keperuuꞌnavitue˜ botoaarioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Teinge napoꞌ Jooni niaꞌaama aaꞌpauꞌ, “Daꞌ eeꞌnara Tee Pakoꞌpariꞌniiꞌ, Eliasi, eeꞌnoko tee nakaronung nempampimaung deeaung deekoꞌ aming-koo eeꞌnarai dake nantoong ntong-koo minkiverima meekaꞌantaverimaung?” ");
INSERT INTO nas_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Eeꞌnoko Joonie kara makuꞌurima aaꞌpuruꞌ, “A, tamung ntong-koo minkie meekaꞌ antavarampimang. Nka niiꞌnung noruꞌeriaung naning pankaing diiꞌkoo meuꞌ donkonui otong. ");
INSERT INTO nas_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tee ning-koo damaꞌke poaing naurampimaung aaꞌnaꞌ apooꞌmui otoing, doonge-taara˜. Tee eeꞌnara poko aaꞌnaꞌ tampaꞌ taaraveriai!” ");
INSERT INTO nas_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aung kapooꞌ ookara Beetani-namono-koo nkoaruꞌ Jooꞌdani-nari-koo amenkaꞌaapei, Joonie nantoong ntong-koo minkivurima meekaꞌantavurikoꞌnooꞌke. ");
INSERT INTO nas_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Teketa tee daunaꞌmung Joonie Jiisuuꞌ oovuuꞌ poko, eeꞌnoko aaꞌpuruꞌ, “Ooveriko, aunkapeto tee eeꞌnara Kumponing Bakaang Sipisipiꞌkoong Kampia aarumo orara tontaꞌuaing ookara kansiꞌnupoong-koo. ");
INSERT INTO nas_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tee aung eeꞌnara tee naning ninge minkuamaung, aaꞌpama, ning-koo damaꞌke poaing naning bakei ning-koo dau basi. Ning oꞌnoaruko otouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aung eeꞌnara naning ninge noruꞌampaꞌ minkuankoꞌnung, eeꞌnoko ning tavoꞌmaruꞌ diiꞌ Isireeli-nupoong ntong-koo minkirampima meekaꞌantarampiko, diiꞌke tasiꞌperiiꞌnaang aung naning.” ");
INSERT INTO nas_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Joonie daankivurima aaꞌpuruꞌ, “Ninge Tanuaang Meekung kuukuuꞌpinaꞌ siarako paning-eta siarara tee-koo dau pantoko ooansing. ");
INSERT INTO nas_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eeꞌnoko ninge koontoꞌ noruꞌampaꞌ, nka Kumponinge, botomuuꞌnunge nantoong ntong-koo minkiarama meekaꞌantavaramaꞌnaang, aaꞌmuuꞌ, ‘Dake Tanuaang Meekung siarara dau pantoko ooveeꞌnaang tee-koo naning-koo. Tee eeꞌnara tee Tanuaang Meekung ninka meekaꞌantavuriaing.’” ");
INSERT INTO nas_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Joonie aaꞌpuruꞌ, “Ninge ooansing, eeꞌnoko naurampimang, aung eeꞌnara tee Kumponing Bauring.” ");
INSERT INTO nas_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Teketa tee Jooni daunaꞌmung napoꞌ teꞌ otoko neeꞌ ninka bakaning barevare-nupoong-koonaanka ninka. ");
INSERT INTO nas_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Eeꞌnoko Joonie Jiisuuꞌ nanuko oovura aaꞌmuretuꞌ, “Aunkato eeꞌnara Kumponing Bakaang Sipisipiꞌkoong Kampia.” ");
INSERT INTO nas_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Eeꞌnoko tee neeꞌke Jooni taaravampeta Jiisuuꞌ siompampetuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jiisuuꞌke damaꞌdu-aape neeꞌke siompampeko oomureta niaꞌmuretuꞌ aaꞌpuma, “Deeꞌke aming besiꞌeremang?” Eeꞌnoko neeꞌke makuꞌampetuꞌ kara, aaꞌpampema, “Raabaiꞌ ee, daꞌ areꞌ otomaung?” (Aung Raabaiꞌ miruꞌnooꞌ Nau-anta Pankaing.) ");
INSERT INTO nas_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Eeꞌnoko bokumurema aaꞌmuretuꞌ, “Poreta oovereai.” Teketa tee nanampetaiꞌnange ooampetuꞌ teꞌ eeꞌnooꞌ otokoꞌnooꞌ. Tenang eeꞌnang duaaꞌ sirang poioꞌ. Eeꞌnoko teꞌmung doong tee ninka oꞌnoruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tenang Joonie tasiꞌantamureko Jiisuuꞌkoo biꞌmaresi nanampetuꞌ. Neeꞌ eeꞌnaanka Aanduruꞌ, Saimoniꞌ Piita baaraꞌmaꞌnung ninka. ");
INSERT INTO nas_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Eeꞌnoko namuꞌke Aanduruꞌke bataata Saimoniꞌ besiꞌuuꞌ. Eeꞌnoko oovuraiꞌnange nauvuma aaꞌpuuꞌ, “Neeꞌke peꞌnumpampesing tee Kumponinge Pakoꞌpariꞌniiꞌ niiꞌ domang mooꞌmurima taremuriaing-koong” (Kirikiꞌnaꞌ tee Karistooꞌ tampaamaung). ");
INSERT INTO nas_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Eeꞌnoko Aanduruꞌke enang Saimoniꞌ Jiisuuꞌanko tavoꞌuuꞌ. Jiisuuꞌke oovuraiꞌnange aaꞌpuuꞌ, “Daꞌ Saimoniꞌ, Jooni bauring. Dakaang miring Siipasi deemparavaing,” Kirikiꞌnaꞌ tee Piita tampaamaung. ");
INSERT INTO nas_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aung aaꞌ napoꞌ daunaꞌmung Jiisuuꞌ Kaaleliꞌnavete-aape nanuꞌkoo piavouꞌ. Eeꞌnoko Pilipiꞌ oovuraiꞌnange aaꞌpuuꞌ, “Niꞌninka nanampeaing.” ");
INSERT INTO nas_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Aunooꞌ Pilipiꞌ Besaida-nung. Teꞌ osi Aanduruꞌnamainta Piita otorekoꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Eeꞌnoko Pilipiꞌke Natanieloꞌ besiꞌuma oovura nauvuma aaꞌpuuꞌ, “Niiꞌke peꞌnumpampirieeng tee eeꞌnara naning Moosesie buuku-koo daarivuuꞌnung Kumponing bakaang boto-koong-koo, tee eeꞌnara naning nakaro-nupoong urikupoong daariauꞌnung biikaang buuku-koo. Aung bakaang miring Jiisuuꞌ, Josepaꞌ bauring, Nasaretiꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Eeꞌnoko Natanieloꞌke makuꞌuma aaꞌpuuꞌ, “Arekeeꞌ? Kapooꞌ ee tampara Nasaretiꞌketa popeuꞌ?” Eeꞌnoko Pilipiꞌke aaꞌpuuꞌ, “Pora ooveaing.” ");
INSERT INTO nas_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eeꞌnoko Jiisuuꞌke oovuuꞌ Natanieloꞌ tee-anko poko, eeꞌnoko aaꞌpuuꞌ, “Aung eeꞌnara koontoꞌ Isireeli-nupoong-koong. Tosi nkovuaunge.” ");
INSERT INTO nas_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanieloꞌke niaꞌuma aaꞌpuuꞌ, “Dake arekeeꞌ ning noruꞌmeing?” Jiisuuꞌke aaꞌpuuꞌ, “Daꞌ ninge tero ooransing Pilipiꞌke mmeꞌ bokuruaruko kokoki-navari-koo boong ueentari otoko.” ");
INSERT INTO nas_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Eeꞌnoko Natanieloꞌke makuꞌuma aaꞌpuuꞌ, “Nau-anta Pankaing, daꞌ eeꞌnara Daurarong˜ niiꞌ Isireeli-nupoong niikaang.” ");
INSERT INTO nas_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jiisuuꞌke aaꞌpuuꞌ, “Dake ee masikaꞌantamemang aaꞌdansing-koo, ‘Daꞌ ninge ooransing kokoki-koo boong ueentari otoko.’? Dake kapooꞌ mmauꞌ pankainanka aung-koo dau basining ooveainge.” ");
INSERT INTO nas_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Eeꞌnoko Jiisuuꞌke aaꞌmuruꞌ, “Masikaꞌ naurampimang, paning bereꞌarako ooveriainge, eeꞌnoko Kumponing bakaning koosinunanka eeꞌdeto eeꞌnoko eeꞌdepeto nanaako oovereriaing ning-anko Tee Naning-naumpoꞌ Paning-etaing-anko.” ");
INSERT INTO nas_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Keꞌmunta doong tankinuioꞌ nampeesi-koong paroro Kana-navuntuꞌkoo nkoauꞌ Kaaleliꞌnameng-koonooꞌke. Jiisuuꞌ bauko teꞌ otouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jiisuuꞌ eeꞌnoko niiꞌ bakaning barevare-nupoong nanampiruꞌ tee-koo eeꞌnara-koo paroro-koo nampeesi-koong-koo. ");
INSERT INTO nas_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Teketa tee, ookara uaini oparako Jiisuuꞌ baukoi aaꞌpuuꞌ, “Uaini oparing. Enang otoꞌevoroaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Ee nkoꞌ, arekeeꞌ? Nkaang batei mmeꞌ makotuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Teketa Jiisuuꞌ baukoi teing taamang bantoꞌnuka teke otorokoꞌning nauvurima aaꞌpuruꞌ, “Kapooꞌ naururiaing nkoveriai.” ");
INSERT INTO nas_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Teke ˜nareng-taa utau kapang-kooning ntong-poꞌning teꞌ otokoꞌ taramu-pinaꞌ basi pankaing-pinaꞌ, Juꞌnupoonge temuriiꞌketa ntong nkeꞌaama amutemuriiꞌ kapooꞌ duuꞌpaakoꞌning biikaang toomo siompai. ");
INSERT INTO nas_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Eeꞌnoko Jiisuuꞌke teing taamang bantoꞌnuka aaꞌpuruꞌ, “Aing utauning maantoꞌeriaing ntonge.” Eeꞌnoko teinge maantoꞌama koontoꞌ aꞌdeiꞌke karange basiauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Eeꞌnoko maantoꞌaioꞌ Jiisuuꞌke nauvurima aaꞌpuruꞌ, “Enang tee-koo ntong-koo niiꞌnaruꞌ nkeꞌerira tavoꞌeriaing tee-anko paroro okovenung-anko.” Eeꞌnoko tee-anko tavoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Eeꞌnoko ntong avaioꞌ mantompuuꞌ, koontoꞌ uaini deemparioꞌ. Teie noruꞌuaruuꞌ aung uaini okoraꞌnooꞌ. Teinge nainge taamang bantoꞌnankai ntong nkeꞌauꞌninge noruꞌauꞌ. Eeꞌnoko teie paroro okovenunge mantompura tee naning nampeesiarakoꞌnung bokuvura aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Niiꞌke ookarai uaini tampara masikung tutung avorompimaung, eeꞌnoko nantoonge tee opaako damaꞌke tamunsiꞌnung uaini avorompikooꞌ. Eeꞌnoko dake tampara uaini pinkaꞌeing bera enang damaꞌke amerimaang.” ");
INSERT INTO nas_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aung Jiisuuꞌ bakaning taaꞌniꞌantananka-koo tutunaꞌnung. Tee nkovuuꞌnung Kana-navuntuꞌkoo, Kaaleliꞌnameng-koonooꞌke. Teke eeꞌnooꞌke bakaang meenasi siraꞌparuꞌ eeꞌnoko niiꞌke bakaning barevare-nupoonge masikaꞌantavampiruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Eeꞌnoko teketa Jiisuuꞌ eeꞌnoko bauko eeꞌnoko baaraꞌmainkaang eeꞌnoko niiꞌ bakaning barevare-nupoong nanampiruꞌ Kapaneumeꞌnavuntuꞌaape. Eeꞌnoko temono-koo niiꞌning doong oꞌnoruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tenang Juꞌnupoong biikaang Taamang Baariꞌkoong˜ dueꞌuioꞌ Jiisuuꞌ Jerusalemaꞌaape nanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Eeꞌnoko Jiisuuꞌke nantoong oovuruꞌ parang-koo dootuuꞌnava pankava-koong-koo kuunge baaveveeko boromakaꞌ dovang, sipisipiꞌ dovang, kuukuuꞌ dovang parekanumpoꞌ. Eeꞌnoko napoꞌ nantoong mooniꞌ aampariꞌaakoꞌning oovuruꞌ biikaang baꞌnavaꞌnang-koo baꞌnamparirioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Eeꞌnoko Jiisuuꞌke moꞌming nerivura nipoꞌurima ookara kauꞌ karenaumo bataꞌuruꞌ dootuuꞌnava pankava-ita, sipisipiꞌ dovang, boromakaꞌ dovang. Eeꞌnoko Jiisuuꞌke batanang-nanka peꞌdempuruꞌ mooniꞌ aampariꞌaakoꞌning biikaning, eeꞌnoko biikaang mooniꞌ purarinkaꞌevuruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Eeꞌnoko teing nantoong kuukuuꞌ baaveaakoꞌning Jiisuuꞌke nauvurima aaꞌpuruꞌ, “Teꞌnemperiaing anketa. Mmaꞌ bakaang pava baaveroma deeng-antaveriaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Eeꞌnoko niiꞌke bakaning barevare-nupoonge noruꞌampiruꞌ Daari Meekunge minkuvuuꞌnaꞌ, aaꞌpuuꞌnaꞌ, “Nkaang domang-eta pia aaꞌnaꞌ oꞌnong dakaang pava meekung otoi otoꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Teketa tee Juꞌkoong ovontunge makuꞌaama tuuꞌai niaꞌaama aaꞌpauꞌ, “Daꞌ pankaing deekoꞌ, teeꞌ nkovepeuꞌnung, taaꞌniꞌanta naumeriaing.” ");
INSERT INTO nas_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Aung pava dootuuꞌnava turamperiko beenang doong-koo napoꞌ daaꞌampaing.” ");
INSERT INTO nas_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Teketa napoꞌ teinge niaꞌaama aaꞌpauꞌ, “Beenang doong-koo masikaꞌ kaniepeuꞌ? Makotuaꞌ. Ava dootuuꞌnava pankava pankaroonge kaniampiruꞌnava karenaumo kivora-ita ˜namareꞌtaa-koo.” ");
INSERT INTO nas_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tee dootuuꞌnava tampukoꞌnung miruꞌnooꞌ tee eeꞌnara Jiisuuꞌnung mono. ");
INSERT INTO nas_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Damaꞌke booꞌketa daaꞌarioꞌ niiꞌke bakaning barevare-nupoonge napoꞌ noruꞌampiruꞌ teeꞌ minkuvuuꞌnaꞌ. Eeꞌnoko Daari Meekung masikaꞌantavampiruꞌ eeꞌnoko tee kara Jiisuuꞌke minkuvuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Teketa tee Jiisuuꞌ otouꞌ Jerusalemaꞌ Taamang Baariꞌkoong-koo˜. Eeꞌnoko teꞌ otoko mmauꞌke masikaꞌantavauꞌ taaꞌniꞌantananka nkovuuꞌning ooaama teꞌ otoroitaaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nka Jiisuuꞌke tee masikaꞌantavuriarukoꞌ ookara biikaang aarumo noruꞌuitaaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bane naninge kapooꞌ nauvuaruko tampaꞌ noruꞌukoꞌ nantoong-koo tunsi-koo otoing. ");
INSERT INTO nas_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Enang tee naning narung otokoꞌ miring Nikodemasi. Tee Juꞌnupoong-koong pankaing, Boto Keperuuꞌnavitu-koong˜. ");
INSERT INTO nas_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Eeꞌnoko niiꞌnaꞌmung muunga Jiisuuꞌanko pora aaꞌpuuꞌ, “Nau-anta Pankaing ee, daꞌ niiꞌke noruꞌdampiri otong. Daꞌ nau-anta Kumponinge botoruuꞌnung. Aing taaꞌniꞌantananka nkovemaing naninge baka nkovuarupeuꞌ Kumponing ninka nariꞌ otoreaꞌ dei.” ");
INSERT INTO nas_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Masikaꞌ nauramaang, naning napoꞌ pontoꞌaravarui dei, Kumponing bakaang muuꞌ oovuarupeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemasie aaꞌpuuꞌ, “Arekeeꞌ napoꞌ naning pankara pontoꞌarapeuꞌ? Bauko-koong-koo manong-koo napoꞌ tumparavarupeuꞌ kemuꞌkanaꞌ napoꞌ pontoꞌaraaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Masikaꞌ nauramaang, naning Kumponing bakaang muuꞌkoo tumparavarupeuꞌ pontoꞌaravarui dei ntong-eta eeꞌnoko Tanuaang Meekung-eta. ");
INSERT INTO nas_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mono-koong pontoꞌ mono-pinaꞌ ooampimaung, eeꞌnoko Tanuaang Meekung-koong pontoꞌ domaang-pinaꞌ ooampiarupeuꞌ dutai. ");
INSERT INTO nas_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taꞌniniaukaꞌ aaꞌpansing-koo, ‘Diiꞌ nauꞌka napoꞌ pontoꞌdariaing.’ ");
INSERT INTO nas_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Doving piavomanaꞌ duparama eevumaunge. Dake tamung bakaang kara taaravepeuꞌ eeꞌnoko dake noruꞌearupeuꞌ areketa pomaang aiꞌ areꞌaape nanumang. Teeꞌ nariꞌ, dake tasiꞌpearupeuꞌ nantoong Tanuaang Meekung-eta pontoꞌarimanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemasie aaꞌpuuꞌ, “Arekeeꞌ teeꞌ nkoarapeuꞌ?” ");
INSERT INTO nas_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Arekeeꞌ dake aung noruꞌeaꞌ otong bane pankainge, kakeꞌii-anta Isireeli-nupoong biikaange? ");
INSERT INTO nas_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Masikaꞌ nauramaang, niiꞌke tampaꞌ noruꞌampiritaaꞌ karompimaung, eeꞌnoko kapooꞌ ooampiritaaꞌ minkuampimaunge. Eeꞌnoko diiꞌ aung niikaang kara taara-koo piaroriaung. ");
INSERT INTO nas_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Diiꞌke masikaꞌantameriaung kapooꞌkoo kansiꞌkoong-koo naurampiko arekeeꞌ masikaꞌantameripeuꞌ ninge kapooꞌ paning-kooning naurampiko? ");
INSERT INTO nas_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Eeꞌnoko niiꞌnung naning paning-koo nanuuꞌnung otoaꞌ, ning narung, ning Tee Naning-naumpoꞌ Paning-eta mouꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Teeꞌ Moosesie boruꞌ koopaꞌkoong intampuuꞌnaꞌ tuuku-koo meeꞌboraꞌ sirakamaaꞌkoo teeꞌ nariꞌ nauꞌka ning Tee Naning-naumpoꞌ intamaavaing. ");
INSERT INTO nas_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kumponinge teeꞌ nkoaraaꞌnaang miruꞌuuꞌnung taung daareꞌuuꞌnaang nantoong domaang isikung okovuriaing-koong, teing ookara ning masikaꞌantamaavaining.” Jiisuuꞌke teeꞌpuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Eeꞌ, Kumponinge niiꞌ ookara kansiꞌnupoong aaꞌnaꞌ piaamurikotaaꞌ tee Bauring narung masikung kirokai tauraꞌpuuꞌnung tee booꞌparaaꞌnaang niiꞌ paku-koo; bera tee naning tee masikaꞌantavuaing paaꞌaravaukaꞌnung, teka domaang oparavaung otoꞌevuaing. ");
INSERT INTO nas_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kumponinge Bauring botovuuꞌ domang-antanung deemparaaꞌnaang, tuumpinung deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Baa tee Kumponing Bauring masikaꞌantavumaung tee kiimata nkavuaukaꞌnung, eeꞌnoko baa tee Kumponing Bauring masikaꞌantavuaung tee kiimata-numpoꞌ, Kumponing Bauring narung masikung kirokai masikaꞌantavuaruko. ");
INSERT INTO nas_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tee kiimata nka-koong okoraꞌnooꞌ eeꞌ: Araka aꞌ kansiꞌkoo poko nantoong kontevorouꞌ, mutaanang narung piavoroi biikaang orara-nko dakaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Naning tee kapooꞌ orara nkovumaung bakei aaꞌnaꞌ piavoaung araka-koo eeꞌnoko kupiꞌomaung araka-anko poꞌkoo bakaning orara nko-nko siraꞌparaꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Eeꞌnoko naning tee kapooꞌ masikung siompuitaaꞌ nkoaramaung tee araka-anko pomaung, ookara kapooꞌ nkovuining siraꞌparaaꞌnaang Kumponing dotu-anta-koo nkoniiꞌ deemparako. ");
INSERT INTO nas_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aung aaꞌ tee teketa niiꞌ bakaning barevare-nupoong tee Jiisuuꞌ ninka nanampiruꞌ Judiaꞌnameng-koo. Niiꞌning doong teke tee ninka oꞌnoruꞌ nantoong ntong-koo minkivurima meekaꞌantavurima. ");
INSERT INTO nas_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tenang napoꞌ Joonie nantoong niiꞌning ntong-koo minkivurima meekaꞌantavurikoꞌ Iinong-a, Sielimaꞌnavuntuꞌkoo dueꞌka, teꞌ ntong mmauꞌpoꞌnooꞌ deemparako. Nantoong mmauꞌ teꞌ berokoꞌ Joonie minkivurira meekaꞌanta-koo. ");
INSERT INTO nas_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tenang eeꞌnang mmeꞌ Jooni kiimatavaravaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Eeꞌnoko niiꞌning Jooni bakaning barevare-nupoong-kooning tataꞌeekoꞌ Juꞌnupoong-koong narung pankaing ninka kiiroraaꞌanta aarumo meekung-koong. ");
INSERT INTO nas_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aung aaꞌ tee, Jooni bakaning Jooni-anko berouꞌ nauaavaꞌnaang. Aaꞌpauꞌ, “Nau-anta Pankaing, tee ee dake naning noruꞌemaang ntong-koo avetekaꞌkoo otoresieeng Jooꞌdani-nari-koo tee eeꞌnara naning dake minkueuꞌnung? Tee eeꞌnara naninge enang nantoong ntong-koo minkivurima meekaꞌantavurimaang, eeꞌnoko ookara tee-anko nanaamaang.” ");
INSERT INTO nas_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Joonie makuꞌurima aaꞌpuruꞌ, “Naning otoaꞌ kapooꞌ otoꞌevupeuꞌnung Kumponinge avuaruko. ");
INSERT INTO nas_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Diiꞌke tero taaraveruꞌ tee kara ninge minkuama aaꞌpantuꞌnung, ‘Ning tee Pakoꞌpariꞌniiꞌ tavoꞌaravaing-koong deeaꞌ, teka Kumponinge botomuuꞌ tee-koo eeꞌnara-koo uroꞌkanooꞌ nanamaꞌnaang.’ ");
INSERT INTO nas_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nampeesi-koong paroro-koo, teni manikuma teni tee nampeesinara baꞌaang. Eeꞌnoko tee baꞌmaikoꞌ tamung dueꞌke donkonui nempari taaravuma doturotuarapeuꞌ tee nampeesinara karoko. Teeꞌ eeꞌnaꞌ teing nantoong Jiisuuꞌ ninka otoroko ooaransi nkaang doturotu dupeniiꞌ otoi otong. ");
INSERT INTO nas_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tee nauꞌka pankaimparavaing ning okiꞌnaꞌmarako.” ");
INSERT INTO nas_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Naning aꞌdeiꞌketa pouꞌnung ookara-koo dau basi. Naning kansiꞌkoo otoi tee kansiꞌnung eeꞌnara, kansiꞌkooning kapooꞌ minkuvumaung. Eeꞌnoko tee naning paning-eta pouꞌnung ookara-koo deu basi. ");
INSERT INTO nas_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Teie eeꞌnarai naumurimaung oovuuꞌning eeꞌnoko taaravuuꞌning. Nka nantoonge bakaang kara masikaꞌantavaavaung. ");
INSERT INTO nas_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Eeꞌnoko naning tee bakaang kara masikaꞌantavumaung tee eeꞌnarai siraꞌpui aaꞌpumaung, “Kumponing bakaang kara bakei kara masikung.” ");
INSERT INTO nas_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tee eeꞌnara Kumponinge botovuuꞌnung Kumponing-koong kara koontoꞌ taaꞌniꞌpoioꞌ minkuvumaung, Tanuaang Meekung Kumponinge ootukuarioꞌ avuuꞌnung ninka. ");
INSERT INTO nas_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baumai Bauring piaavura ookara kapooꞌnanka avuuꞌ kompuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Eeꞌnoko naning Kumponing Bauring masikaꞌantavumaung domaang oparavaukaꞌnung otoꞌevumaung. Eeꞌnoko naning tee Kumponinge Bauring bakaang kara taaravuaung domaang oparavaukaꞌnung otoꞌevuaukaꞌnung koontoꞌ. Kumponing bakaang iira toraꞌpuaing teie doong kante. ");
INSERT INTO nas_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Eeꞌnoko teinge Boto Keperuuꞌnavitu˜ taaravauꞌ Jiisuuꞌke mmauꞌ barevare-nupoong bokuvurima ntong-koo minkivurima meekaꞌantavuriko Jooni-koo dau basinooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aꞌnooꞌ Jiisuuꞌke baka nantoong ntong-koo minkie meekaꞌantavuriaꞌ; niiꞌke bakaninge barevare-nupoonge nainge deekoꞌ minkiarampima meekaꞌantavarampikoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Teketa Jiisuuꞌke tee kara taaravuraiꞌnange Judiaꞌnameng-eta toroaruꞌ Kaaleliꞌaape. ");
INSERT INTO nas_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Eeꞌnoko maroita tevung taung-navunge Sameriaꞌnamenge tankinui-navunge siong-antamuruꞌ, niiꞌke Juꞌnupoonge baariꞌampimanavunge. ");
INSERT INTO nas_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Eeꞌnoko Sameriaꞌnameng-koo tumarira osi tavoꞌmariruꞌ miring Saikaaꞌ. Teꞌ eeꞌnooꞌ baruꞌ isipoꞌ deeaꞌ Jeekopiꞌke bauring Josepaꞌ avuuꞌnau-koo. ");
INSERT INTO nas_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Teꞌ eeꞌnooꞌ Jeekopiꞌ bakaang dinkung ntong-poꞌnung otokoꞌnooꞌ. Eeꞌnoko Jiisuuꞌ nanuꞌkoo takaaꞌora teꞌ baꞌnamparuꞌ tee-anko dinkung-anko. Tenang eeꞌnang muung-aapenang. ");
INSERT INTO nas_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jiisuuꞌ teꞌ baꞌnampari otoko niiꞌ bakaning barevare-nupoong osi nanampiruꞌ taamang mooꞌampiiꞌnaang. Eeꞌnoko tee, Jiisuuꞌ sipampirioꞌ nani Sameriaꞌkoonani teꞌ ntong nkeꞌkoo dinkung-koo pouꞌ. Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Ntong-koo ameai.” ");
INSERT INTO nas_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Teketa Sameriaꞌnanie aaꞌpuuꞌ, “Daꞌ Juꞌkoong, eeꞌnoko ning Sameriaꞌnani. Arekeeꞌ ning dake niaꞌmemaang ntong-koo aromaꞌnaang?” (Juꞌnupoonge kompaavaung kapooꞌ Sameriaꞌnupoonge taamanaama kompaamaing. Teeꞌkoo tenie teeꞌ minkuvuuꞌ.) ");
INSERT INTO nas_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Ee bakaꞌ, dake noruꞌei dei Kumponing-nung bautaꞌ eeꞌnoko ning baa eeꞌnara niaꞌdamaang ntong-koo, ning eeꞌnara niaꞌmepeuꞌ. Niaꞌmeko ninge arompeuꞌ ntong domaang-poꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Eeꞌnoko tenie manikumai makuꞌuma aaꞌpuuꞌ, “Ee aung, nnaꞌ daꞌ baakete otoꞌderuaꞌ, eeꞌnoko aung dinkung baruꞌ isikung masikung. Arekeeꞌ nkavepeuꞌ tee ntong domaang-poꞌnung? ");
INSERT INTO nas_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Niikaakai Jeekopiꞌke aung dinkung ntong-poꞌnung amuruꞌ. Tee eeꞌnara eeꞌnoko baurukaaꞌ eeꞌnoko bakaning boromakaꞌ dovang sipisipiꞌ ookara aruꞌkoo naikauꞌ. Emuꞌ daꞌ ee Jeekopiꞌkoo dau basi tantaramaang?” ");
INSERT INTO nas_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jiisuuꞌke kara makuꞌuma aaꞌpuuꞌ, “Nantoong aung-koo dinkung-koonaruꞌkoo naikaara napoꞌ nukaaꞌoropeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nantoong teing ninge ntong avorompaining napoꞌ nukaaꞌoroaukaꞌnung. Teruꞌ avorompainaruꞌ teing-koo kuunge puunta-poꞌnaruꞌ deemparavaing ntong domaang-poꞌnung doong kante tavoꞌaramatoainaꞌ teing-koo, domaang oparavaukaꞌnung otoꞌevuriainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Eeꞌnoko tenie manikumai makuꞌuma aaꞌpuuꞌ, “Eeꞌ, ameaing tee eeꞌnara ntong. Ning teeꞌ nariꞌ otoꞌkoo piamomaang, napoꞌ ntong-koo nukaaꞌmoaukaꞌ, napoꞌ kemuꞌkanaꞌ moaukaꞌnaꞌ ntong nkeꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Enang tee Jiisuuꞌke botovuma aaꞌpuuꞌ, “Bera daꞌung bokuera aꞌ poreaing.” ");
INSERT INTO nas_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tenie manikumai aaꞌpuuꞌ, “A, ning aaꞌ inung oꞌnoai.” Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Eeꞌ. Daang deeaꞌ. Masikaꞌ minkuemaang teeꞌ aaꞌpema, ‘Ning aaꞌ inung oꞌnoai.’ ");
INSERT INTO nas_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Daꞌ paꞌnokoꞌke nantoonge nantauꞌnani, eeꞌnoko tee naning enang daꞌ ninka otoresing daꞌung masikung deeaꞌ. Masikaꞌ naumeing.” ");
INSERT INTO nas_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Eeꞌnoko tee, tenie aaꞌpuuꞌ, “Ee aung, daꞌ masikaꞌdarioꞌ ninge nakaronung-pinaꞌ noruꞌdamaang. ");
INSERT INTO nas_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Niikakatauroi Sameriaꞌnupoonge amii-koo Kumponing boontuaakoꞌ, dootuuꞌ nkoaama; eeꞌnoko diiꞌke Juꞌnupoonge aaꞌperimaung, ‘Jerusalemaꞌ naroꞌke Kumponing boontuampimaatoaing.’” ");
INSERT INTO nas_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jiisuuꞌke aaꞌpuuꞌ teni manikuma, “Masikaꞌantameaing, ee ani, batei tavoꞌaravaing amii-koo eeꞌnoko Jerusalemaꞌke nantoonge Tee Niuma dootuuꞌaama boontuaavaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Diiꞌke Sameriaꞌnupoonge baruꞌ noruꞌeriaꞌ tee dootuuꞌerimaung. Niiꞌke Juꞌnupoonge tampaꞌ noruꞌampiri otong tee dootuuꞌampimaung. Kumponinge tee Domang-antanung Ju-nupoong-koong tavoꞌaraaꞌnaang tampuuꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tee batei pomaang, aung aaꞌ otong, tenang Tee Niuma dootuuꞌarimainge masikenge tanuaang-aapenaꞌ domange arooꞌariri masikaꞌ dootuuꞌaavainang. Teing temuriiꞌnaꞌ dootuuꞌnupoong Tee Niuma piavomaung. ");
INSERT INTO nas_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kumponing tee Tanuaang. Teeꞌkoo Kumponinge maromurimaung tanuaang-aapenaꞌ dootuuꞌampiiꞌnaang domaang-eta, arooꞌmariri masikaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Manikumai aaꞌpuuꞌ, “Ninge noruꞌansi oꞌnong tee Kumponinge urikamuꞌketa Pakoꞌpariꞌniiꞌ, Karistooꞌ tampaamaung pooꞌnaang. Tee eeꞌnara pora ookara kapooꞌ naumuriaing.” ");
INSERT INTO nas_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Ning tee eeꞌnara daꞌ ninka karompemaang.” ");
INSERT INTO nas_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Eeꞌnoko tenang eeꞌnang niiꞌ bakaning barevare-nupoong toromarima bakei aaꞌnaꞌ taꞌninampiruꞌ manikuma ninka minkuareko, nka niaꞌampima aaꞌpampiaruuꞌ, “Aming piaromaang?” niiꞌnaꞌ “Aming-koo minkuraremang teni ninka?” ");
INSERT INTO nas_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Eeꞌnoko tenie manikumai tee utau teꞌ sipura nanuuꞌ osi-aape. Eeꞌnoko osi-nupoong nauvurima aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Porira naning ooveriaing kapooꞌ ookara ninge tero nkoankoꞌning naumuinung. Aung eeꞌnara deeꞌma tee Pakoꞌpariꞌniiꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Eeꞌnoko teing osi-eta porouꞌ Jiisuuꞌanko. ");
INSERT INTO nas_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tee aaꞌ nkoarioꞌ niiꞌke bakaninge barevare-nupoonge Jiisuuꞌ aaꞌnaꞌ niaꞌampiruꞌ aaꞌpampima, “Nau-anta Pankaing, taamang-koo naikiaing.” ");
INSERT INTO nas_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jiisuuꞌke kara makuꞌmemurima aaꞌmuruꞌ, “Ning nkaang taamang otoꞌmemuing diiꞌke noruꞌeriaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Eeꞌnoko teketa niiꞌ niiꞌka nianiaꞌ niaꞌmeerima aaꞌmeerikoꞌ, “Aiꞌ niiꞌninge aung taamang tavoꞌevainge?” ");
INSERT INTO nas_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jiisuuꞌke aaꞌmuruꞌ, “Ning-koo taamang baruꞌ kapooꞌ masikung deeaꞌ. Nka tee Kumponing bakaang nko-nko kapooꞌ masikung. Teie botomuuꞌnaꞌ tampaꞌ nkoansi dupeampaing. ");
INSERT INTO nas_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Diiꞌke eeꞌ minkuerimaung, ‘Keempampimanooꞌketa karekuri kaara makosi tankinuko taamang nkavampipeuꞌ.’ Nka diiꞌke ooveriaing mintoonanka. Enang namuꞌke petaaꞌoing, taamang kavuꞌnooꞌ makotuing. ");
INSERT INTO nas_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Niiꞌke taamang nkavampima doturotumarimaung. Teeꞌpinaꞌ nantoong oosiarampimang domaang oparavaukaꞌnung otoꞌevuriiꞌnaang, niiꞌ sinang tanka-nupoong eeꞌnoko taamang nka-nupoong naroꞌmariri doturotumariainaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aung kara teinge minkuaamaung masikung, ‘Narunge keempuko niiꞌnunge taamang kavumaung.’ ");
INSERT INTO nas_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ninge diiꞌ botorampiring taamang nkaveriiꞌnaang mintoong-koo diiꞌ pakurariaruuꞌnau-koo. Aung tee niiꞌning mintoong-koo iriꞌopariring-koo diiꞌ tamung kavuꞌ narung-koo pakurarimang.” ");
INSERT INTO nas_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Eeꞌnoko mmauꞌke Sameriaꞌnupoonge temono-nupoonge Jiisuuꞌ masikaꞌantavauꞌ, tenie eeꞌnani manikumai teeꞌ minkuvuma aaꞌpuioꞌ, “Teie kapooꞌ ookara naumuing tero nkoankoꞌning.” ");
INSERT INTO nas_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eeꞌnoko teing Sameriaꞌnupoong Jiisuuꞌanko porora aaꞌnaꞌ niaꞌauꞌ teꞌ otorooꞌnaang teing ninka. Eeꞌnoko tee Jiisuuꞌ temono-koo keꞌmunta doong otouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Eeꞌnoko mmauꞌke napoꞌ masikaꞌantavauꞌ Jiisuuꞌ bakaang-koo kara-koo. ");
INSERT INTO nas_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Eeꞌnoko teinge teni manikuma nauaama aaꞌpauꞌ, “Niiꞌke enang masikaꞌantavampiring tee-koo dake naumering-koo deeaꞌ, tee niiꞌke koontoꞌ taaravampiraiꞌnange. Tee eeꞌnara koontoꞌ noruꞌampiring tee Domang-antanung ookara kansiꞌnupoong.” ");
INSERT INTO nas_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Eeꞌnoko tee, keꞌmunta doong teꞌ otoraiꞌnange Jiisuuꞌke temono sipura Kaaleliꞌaape napoꞌ nanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jiisuuꞌke aaꞌpukoꞌ, “Naning tee ning-pinaꞌ nakaronara bakanooꞌnupoonge nainge deekoꞌ masikaꞌantavaavaung.” ");
INSERT INTO nas_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Teeꞌ nariꞌ Jiisuuꞌke bakanooꞌ osi Jerusalemaꞌ sipuraiꞌnange Kaaleliꞌnameng-koo tumparioꞌ tevoraꞌnupoonge onkeonkeꞌauꞌ. Aming-koo, nnaꞌ teing eeꞌning nanauꞌ Jerusalemaꞌaape Baariꞌkoong Paroro naiaavaꞌnaang, eeꞌnoko teꞌ otoroitaaꞌ ookara kapooꞌ Jiisuuꞌke tenang nkovuuꞌning ooauꞌ paroro-koo meuꞌke. ");
INSERT INTO nas_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Eeꞌnoko Jiisuuꞌ napoꞌ toroaruꞌ Kana-namono-koo Kaaleliꞌnameng-koonooꞌ, ntong uaini deeng-antavuuꞌnooꞌ. Eeꞌnoko tee daurarong bakanaving-koong narung pankaing teꞌ otokoꞌ, bauring Kapaneumeꞌnamono-koo otoi siipavouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Eeꞌnoko teie Jiisuuꞌ Kaaleliꞌaape pouꞌnung Judiaꞌketa taaravuuꞌ. Taaravura tee, Jiisuuꞌanko bera, niaꞌuuꞌ Kapaneumeꞌaape nanuuꞌnaang bauring taare-anta-koo, booꞌke dueꞌuko. ");
INSERT INTO nas_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jiisuuꞌke tee eeꞌnara aaꞌpuuꞌ, “Diiꞌkoo naning otoaꞌ masikaꞌantamepeuꞌnung tutung aaꞌnaꞌ iirakuta nko-nko oovuarura, taaꞌniꞌanta taꞌnimpaariiꞌnanka.” ");
INSERT INTO nas_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Eeꞌnoko tee daurarong bakanaving-koonunge aaꞌpuuꞌ, “Niꞌninka poaing nnuring mmeꞌ booꞌparavaruko.” ");
INSERT INTO nas_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Bera naniaing. Dauring domamparavaing.” Eeꞌnoko teie naninge Jiisuuꞌ bakaang kara masikaꞌantavura nanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Eeꞌnoko taunga toroarama bakaning-koong botovotonaaꞌnanka-koo niiꞌning kuneꞌuruꞌ. Eeꞌnoko teinge aaꞌpauꞌ, “Dauring domamparaaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eeꞌnoko teie makuꞌurima aaꞌpuruꞌ, “Arenang tee eeꞌnang nnuring tampatampaꞌ deeꞌoinge?” Eeꞌnoko teinge aaꞌpauꞌ, “Keꞌmaakiꞌ mmeꞌ mutaanampuko uipaariiꞌ boimpuieeng.” ");
INSERT INTO nas_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eeꞌnoko baumai noruꞌuuꞌ tenang eeꞌnang batei basiarako Jiisuuꞌke nauvuma aaꞌpuuꞌnung, “Dauring domamparavaing.” Teeꞌkoo eeꞌnarai eeꞌnoko baurukaaꞌke Jiisuuꞌ masikaꞌantavauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","(-) ");
INSERT INTO nas_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Eeꞌnoko teketa tee Juꞌnupoong biikaang paroro meekung nkoauꞌ. Eeꞌnoko Jiisuuꞌ Jerusalemaꞌ nanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Eeꞌnoko Jerusalemaꞌkoong karanaang sipisipiꞌ duparimanooꞌketa dueꞌke kankonaruꞌ pooniiꞌnaruꞌ otokoꞌ, paꞌnokoꞌ bare pankeng koroai kaniauꞌning ninka, eeꞌnoko teruꞌ miring Betesira tampaakoꞌ Juꞌ biikaang kara-koo. ");
INSERT INTO nas_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Eeꞌnoko nantoong mmauꞌ siipa-poꞌnupoong teke teing-koo bare-koo nempariri otorokoꞌ, aaꞌnoko mutuunanka, kaikuuꞌnanka, eeꞌnoko dootananka, nempaama ntong eemaaruꞌaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Koosinung˜ Kumponing-etaing namuꞌnaꞌ teruꞌkoo bema ntong eemaaruꞌantavukoꞌ, eeꞌnoko tenang tee ntong eemaaruꞌarako baa tee tutunaꞌnung teruꞌkoo duꞌmumparama taarevokoꞌ, bane aremuriiꞌ siipa-poꞌnunge. ");
INSERT INTO nas_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Eeꞌnoko narung naning teꞌ bempari otokoꞌ beenaumo kivora-ita ˜beenaumo-taa 38 masiraani siipavouꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Eeꞌnoko Jiisuuꞌke tee oovura noruꞌuuꞌ tee naning pankaroong siipavouꞌnung, eeꞌnoko aaꞌpuuꞌ, “Daꞌ ee taarerooꞌnaang piaromaang?” ");
INSERT INTO nas_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Eeꞌnoko teie siipa-poꞌnunge kara makuꞌuma aaꞌpuuꞌ, “Ning aaꞌ naning otoꞌmemuaung tee ntong eemaaruꞌarako siꞌmupeuꞌnung. Ning ninka teꞌ nanuꞌkoo paaramarako teka niiꞌnung divuꞌmui bemaung.” ");
INSERT INTO nas_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ tee, “Daaꞌdaravaing. Taniꞌ poruꞌera naniaing.” ");
INSERT INTO nas_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Eeꞌnoko tee naning namuꞌke taarevora bakaang taniꞌ poruꞌura beuꞌ. Teꞌmung eeꞌnaꞌmung Doong Uaanaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Eeꞌnoko Juꞌkoong ovontunge tee naning Jiisuuꞌke tamparuꞌntavuuꞌnung tautauaama, aaꞌpauꞌ, “Eꞌmung Doong Uaanaꞌmung; niikaang boto totoꞌpei taniꞌ poruꞌdari nanimang.” ");
INSERT INTO nas_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Eeꞌnoko teie kara makuꞌuma aaꞌpuuꞌ, “Teie naninge ning taare-antamuinge naumuma aaꞌmuing, ‘Dakaang taniꞌ nkavera naniai.’” ");
INSERT INTO nas_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Eeꞌnoko teinge niaꞌaama aaꞌpauꞌ, “Baa eeꞌnara tee naning daꞌ botoruing taniꞌ nkavei naniiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Eeꞌnoko teie naninge Jiisuuꞌke taare-antavuuꞌnunge Jiisuuꞌ miring noruꞌuaꞌ Jiisuuꞌ namuꞌke tenkenuuꞌnung-koo, karikaꞌ baruꞌ temono-koo otoroko. ");
INSERT INTO nas_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Eeꞌnoko damaꞌke tee Jiisuuꞌke dootuuꞌnava pankava-koo kuneꞌura aaꞌpuuꞌ, “Ee aung, daꞌ enang taareroing. Dakaang orara aarumo sipeaing kapooꞌ tee-koo siipa-koo dau basi tavoꞌkuꞌneeng daꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eeꞌnoko tee naning teketa tenkenura Juꞌkoong ovontung nauvurima aaꞌpuruꞌ, “Tee aaꞌ ning Jiisuuꞌke tamparuꞌantamuing.” ");
INSERT INTO nas_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Teeꞌkoo eeꞌnaꞌkoo Juꞌkoong ovontunge Jiisuuꞌ turang tutumpauꞌ teie Doong Uaanaꞌmung-koo naning taare-antavuioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Mmaꞌ doong kante mintoompari otong, teeꞌkoo ning napoꞌ nauꞌka mintoomari oꞌnong. ");
INSERT INTO nas_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Teeꞌ minkuvuioꞌ Juꞌkoong ovontung bakei orakaꞌ deeꞌorouꞌ. Jiisuuꞌ tavaavaꞌnaang enang bakei aaꞌnaꞌ mauꞌauꞌ Jiisuuꞌke Doong Uaanaꞌmung-koong boto totoꞌpuuꞌnung-koo, eeꞌnoko teie Kumponing bauma masikung tampuuꞌnung-koo, teeꞌ minkuvuma Kumponing-pinaꞌ basi tamparuꞌnung-koo.” ");
INSERT INTO nas_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jiisuuꞌke teing kara makuꞌurima aaꞌpuruꞌ, “Masikaꞌ naurampimang, ninge Bauringe kapooꞌ ninge ninka nkoampaung. Ninge Mmaꞌke nkovuko ooamanaꞌ nariꞌ nkoamaung. Kapooꞌ Mmaꞌke nkovumaung ninge Bauringe nkoamaung. ");
INSERT INTO nas_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mmaꞌke ning Bauring piaamui ookara kapooꞌ nkovumaing naumumaung, eeꞌnoko damaꞌke kapooꞌ aung nkoansing-koo dau basi naumuko nkoamaꞌnaang diiꞌ dooroi taruriaing. ");
INSERT INTO nas_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mmaꞌke booꞌnuka daaꞌurima domang-antavurimanaꞌ teeꞌ nariꞌ ninge Bauringe domang-antavaramaung teing ning piamomaing. ");
INSERT INTO nas_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Eeꞌnoko Mmaꞌke nantoong-simpeꞌ nkovuaꞌ, tee ning-koo Bauring-koo sipuuꞌnung nantoong simpeꞌnko˜, ookarai ning Bauring daangang-koo, Mmaꞌ daangampaamanaꞌ; ");
INSERT INTO nas_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nantoong ning daangamaavaukaꞌning tee Mmaꞌ daangampaavaukaꞌnunge ning botomuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Masikaꞌ naurampimang, nantoong teing nkaang kara taaravaamaing, eeꞌnoko teing masikaꞌantavaamaing tee botomuuꞌnung domaang oparavaukaꞌnung otoꞌevurimaing. Teing teing kiimatavuriaukaꞌning, tero booꞌnameng-eta domaang-aape tankinaing-koo. ");
INSERT INTO nas_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Masikaꞌ naurampimang, enang-eta deto tee booꞌnukai nkaang kara taaramaavainang ning Kumponing Bauring. Eeꞌnoko teing nkaang kara taaramaavaining domampariaing. ");
INSERT INTO nas_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mmaꞌ baka domaang okovenung otomanaꞌ ning Bauring domaang okovenung deeng-antamuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Eeꞌnoko Mmaꞌke ning bauring makosi-antamuuꞌnung nantoong simpeꞌkoo ning Tee Naning-naumpoꞌ Paning-etaing deemari oꞌnoing-koo. ");
INSERT INTO nas_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Taꞌniniriaukaꞌ aung-koo: bateinang pomaang ookara boorouꞌning dakoꞌdomanooꞌ otoromainge nkaang kara taaramaavainang. ");
INSERT INTO nas_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Eeꞌnoko taaramaaraiꞌnange tavoꞌariaing dakoꞌdoma-ita. Teing nantoong tampaꞌ otorokoꞌning daaꞌarampaing koontoꞌ domampariiꞌnaang, eeꞌnoko teing orakaꞌ otorokoꞌning daaꞌarampainge kiimata nka-koo.” ");
INSERT INTO nas_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Kapooꞌ ninge ninka nkoamparupeuꞌ. Ninge kara simpeꞌamaung Kumponinge narunge naumumanaꞌ nariꞌ. Teeꞌkoo ning toꞌbiimari karomaung, ning ninka piamomanaꞌ nkoampaꞌ tee ning botomuuꞌnung narung piavomanaꞌ nkoamaung-koo. ");
INSERT INTO nas_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Eeꞌnoko nkaang kapooꞌkoo ning ninka kara minkuamaung dei, tee kara minkuamaung makotuaꞌ masikung-pinaꞌ noruꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nka niiꞌnung naning otong nkaang kara puring-antavumaung, eeꞌnoko ninge noruꞌansi oꞌnong kapooꞌ teie minkuvumaung ning-koo masikung. ");
INSERT INTO nas_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Diiꞌ diikaning kara nka-nupoong Jooni-anko botovererioꞌ teinge teing bakaang kara nauraaruꞌnung ning masikaꞌanta-koong. ");
INSERT INTO nas_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nka ninge nantoong-koo naning bakaang kara-koo arooꞌmaravaꞌ otong. Teeo ninge Jooni bakaang karai noruꞌ daaꞌantarampiring diiꞌke masikaꞌantamerira domantariiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jooni daamu-pinaꞌ urumpari arakavarako diiꞌ okiꞌnooꞌ batei-koo siomperima doturarikoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Teka ning kapooꞌ pakumui siraꞌantamumaung otoꞌmemung aaꞌnaꞌ pankaing masikung Jooni-nung sirasiraꞌkoo dau basi. Teinge kapooꞌke Mmaꞌke botomuioꞌ nkoamainge naururi otong siraꞌantavui ning tee Mmaꞌke botomuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Eeꞌnoko napoꞌ Mmaꞌke eeꞌnarai nkaang kara puring-antamemumaunge. Diiꞌke bakaang kara teroita taaraveriaꞌ, eeꞌnoko bakaang oing ooveriaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Eeꞌ, diiꞌkoo bakaang kara otoaꞌ. Teeꞌkoo diiꞌke ning masikaꞌantameriaꞌ ning Kumponinge botomuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Diiꞌke doong kante Daari Meekung aaꞌnaꞌ pukeveri deeruerimaung eeꞌ noruꞌerima, ‘Niiꞌke domaang oparavaung okomuriainaꞌ;’ ");
INSERT INTO nas_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nka teie eeꞌnarai Daari Meekunge ning moaing-koong minkunaa naururiko arooꞌeriaꞌ ning-anko poꞌkoo domaang isikung otoꞌderuriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ning nantoonge pankaing-antamaavaꞌnaang piamoaꞌ, Kumponinge deekoꞌ makosi. ");
INSERT INTO nas_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nka ninge diiꞌ noruꞌdampiri otong, diiꞌ diikaang domang-eta Kumponing-koo piaroriaꞌ bakei. ");
INSERT INTO nas_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ning Mmaꞌke botomuioꞌ moioꞌ diiꞌke onkeonkeꞌmeriaꞌ; nka tee niiꞌnung bakamaiꞌ poko tee onkeonkeꞌerikooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Diiꞌ Kumponing taaraveri dotu-anta-koo kasieriaꞌ diiꞌka daangang-koo keiꞌdorima. Teeꞌkoo ning masikaꞌantameriaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ning Mmaꞌankoi tuumpi nkonara deeaꞌ teeꞌ diiꞌke noruꞌmerimanaꞌ; teeo teie Moosesie diiꞌ tuumpiruriaing, daang arooꞌerimaunge. ");
INSERT INTO nas_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Diiꞌke Moosesi koontoꞌ masikaꞌantaveri dei ning masikaꞌantameripeuꞌ, teie daarivuma ning naururuꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Eeꞌnoko diiꞌke Moosesi bakaang kara deerueri masikaꞌantaveriaruma arekeeꞌ diiꞌke nkaang kara masikaꞌantameripeuꞌ? Makotuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Teketa niiꞌning batei tankinuioꞌ Jiisuuꞌ toroarama Kaaleliꞌnaruꞌkoo pakoꞌaruꞌ niiꞌnooꞌ miring Taiberiasi-naruꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Eeꞌnoko mmauꞌ nantoonge siompauꞌ taaꞌniꞌantananka nkovuko ooaama. Siipananka unaa-antavurikoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Eeꞌnoko Jiisuuꞌ miinani-koo koinura baꞌnamparuꞌ niiꞌ bakaning barevare-nupoong ninka, ");
INSERT INTO nas_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Paroro Baariꞌkoong˜ Juꞌnupoong biikaang dueꞌui otoko. ");
INSERT INTO nas_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Eeꞌnoko Jiisuuꞌ ooꞌoopaavarama mmauꞌ nantoong oovuruꞌ tee-anko poroko. Oovurira Pilipiꞌ aaꞌpuuꞌ, “Areꞌka taamang mooꞌampipeuꞌ aing nantoong bauꞌarampiiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tamung teeꞌpuuꞌ Pilipiꞌ paara-antavuma baka noruꞌuitaaꞌ nkovuainaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipiꞌke kara makuꞌuma aaꞌpuuꞌ, “Kenaanka kivora nopaꞌkoo makotuaꞌ ainge nantoonge okiꞌnooꞌnaꞌ bereteꞌ naiaavaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Eeꞌnoko niiꞌnunge bakaning barevare-nupoong-koonge, Aanduruꞌke, Saimoniꞌ Piita baaraꞌmaꞌnunge aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nemaka aꞌ otong paꞌnokoꞌ bereteꞌ otoꞌevuinung, eeꞌnoko taviꞌning keura. Nka arekeeꞌ makotupeuꞌ aing-koo ookara-koo?” ");
INSERT INTO nas_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jiisuuꞌke aaꞌpuruꞌ, “Baꞌnang-antavereriaing ookara nantoong.” Teꞌ otorokoꞌnooꞌ karaasiꞌ mmauꞌpoꞌnooꞌ, eeꞌnoko ookara nantoong teꞌ baꞌnampariruꞌ. Teing-koong nantoong-koong donkaang deerunooꞌ paꞌnokoꞌ kokoreiꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jiisuuꞌke bereteꞌ kompura Kumponing tampaꞌ tampuuꞌ, eeꞌnoko teing nantoong tankeeꞌuruꞌ baꞌnampariruꞌning. Eeꞌnoko taviꞌ teeꞌ siong-antavuuꞌ. Eeꞌnoko ookara taamanaara poovorouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Eeꞌnoko teing poovoroioꞌ Jiisuuꞌke niiꞌ bakaning barevare-nupoong aaꞌmuruꞌ, “Tee ookara kakitaꞌnanka oosieriaing, tamung keraꞌparaꞌneeng okiꞌnairu.” ");
INSERT INTO nas_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Eeꞌnoko oosiampira pekuꞌ kivora-ita kevekuꞌka maantoꞌampiruꞌ kakitaꞌnankai paꞌnokoꞌ bereteꞌkoo taamanaama sipauꞌning. ");
INSERT INTO nas_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eeꞌnoko teinge nantoonge Jiisuuꞌ bakaang taaꞌniꞌanta ooaara aaꞌpauꞌ, “Aung eeꞌnara tee nakaronung masikung kansiꞌkoo teroita pooꞌnaang Kumponinge barevuuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jiisuuꞌke noruꞌuuꞌ teinge mooꞌaara daurarong˜ deeng-antavaavaꞌnaang mauꞌaako. Teeꞌ minkuaako Jiisuuꞌ tenkenura napoꞌ baka mii-koo koinuuꞌ teka kunsiaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Eeꞌnoko muung-aapevuioꞌ niiꞌ bakaning barevare-nupoong eeꞌdanto nanampiruꞌ teruꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bakaasi-koo aaꞌemarira tankinampiiꞌnaang Kapaneumeꞌaape toromarima. Eeꞌnoko muumpuuꞌ Jiisuuꞌ mmeꞌ niiꞌanko poaruko. ");
INSERT INTO nas_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Eeꞌnoko napoꞌ doving pankaing duparuꞌ, booꞌa pankaing ninka. ");
INSERT INTO nas_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Eeꞌnoko tee niiꞌ booꞌemariruꞌ beenaumo kivora daakuꞌ daangaꞌpinaꞌ basinooꞌ. Teꞌ basimarima Jiisuuꞌ ooampiruꞌ kankong-koo daue nanuko, eeꞌnoko dueꞌ poioꞌ aaꞌnaꞌ amorompiruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Eeꞌnoko amorompiko Jiisuuꞌke aaꞌmuruꞌ, “Aroreriaukaꞌ. Tee ning eeꞌ nanamang.” ");
INSERT INTO nas_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Teeꞌ minkuvuioꞌ niiꞌ piamoruꞌ niiꞌke bakaasi-koo nkavampiiꞌnaang. Eeꞌnoko tee namuꞌke daꞌdenga tee bakaasi teꞌ basiaruꞌ piamori nanampikoꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Teketa daunaꞌmung nantoonge karingai amenkaꞌkoo otorokoꞌninge ooauꞌ nareng bakaasi-nareng teꞌ mmeꞌ otoko. Teinge eeꞌ noruꞌauꞌ: Jiisuuꞌ nanuaꞌ bakaning barevare-nupoong ninka, aiꞌ teinge Jiisuuꞌ sipaara tenkenaieeng. ");
INSERT INTO nas_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Teketa bakaasinanka Taiberiasi-eta porora duumiauꞌ teꞌ karingai bereteꞌ naiauꞌnooꞌ Ovoringe tampara minkuvuioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Eeꞌnoko tee karikaꞌke ooaavaꞌ Jiisuuꞌ teꞌ otoaruko. Niiꞌ bakaning oomaariaꞌ. Enang tee nantoong bakaasinanka-koo aaꞌearira Kapaneumeꞌaape toroariruꞌ Jiisuuꞌ besiꞌaama. ");
INSERT INTO nas_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Teketa teinge Jiisuuꞌ kuneꞌauꞌ teruꞌkoo amenkaꞌaape otoko eeꞌnoko aaꞌpauꞌ, “Nau-anta Pankaing ee, daꞌ arenang aꞌ poing?” ");
INSERT INTO nas_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jiisuuꞌke aaꞌpuruꞌ, “Masikung naurampimang, diiꞌke ning besiꞌmerimang teie bereteꞌke poorurieeng-koo. Diiꞌke besiꞌmeriaꞌ nkaang taaꞌniꞌanta tasiꞌperi masikaꞌantamering-koo. ");
INSERT INTO nas_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Iriꞌ oꞌdariaukaꞌ taamang deraꞌomaung besiꞌkoo. Teka kaviꞌeritaaꞌ besiꞌeriai temuriiꞌ taamang domaang oparavaukaꞌnung. Temuriiꞌ deraꞌoarupeuꞌ. Tee taamang ninge, teie Naning-naumpoꞌ Paning-etainge arompiaing, Mmaꞌke Kumponinge teeꞌ nkoamaꞌnaang botomuuꞌnung-koo.” ");
INSERT INTO nas_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Teinge niaꞌaama aaꞌpauꞌ, “Aming nkoampiainge Kumponing bakaang pia siompampiiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Aung eeꞌnara tee nko-nko Kumponinge maroruri otoing: Tee naning botovuuꞌnung masikaꞌantaveriaing.” ");
INSERT INTO nas_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Teinge kara makuꞌaama aaꞌpauꞌ, “Arera taaꞌniꞌanta nkoveaing niiꞌke oorampira masikaꞌanta-koo? Aming nkoveeꞌnaang? ");
INSERT INTO nas_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Diikakatauroi paning-koong taamang naiauꞌ meeꞌboraꞌ sirakamaaꞌkoo teeꞌ eeꞌnaꞌ Daari Meekunge minkuvuma aaꞌpui otoinaꞌ, ‘Kumponinge paning-eta taamang avuruꞌ naiaavaꞌnaang.’” ");
INSERT INTO nas_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Masikaꞌ naurampimang, Moosesi deeaꞌ tee taamang paninung arurimaung. Mmaꞌ eeꞌnara tee, taamang masikung paning-etaing arurimaung. ");
INSERT INTO nas_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tee taamang Kumponinge arurimaung tee naning eeꞌnara paning-eta pora diiꞌ kansiꞌnupoong domang-antaruriaing.” ");
INSERT INTO nas_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Eeꞌnoko teinge niaꞌaama aaꞌpauꞌ, “Ee aung pankaing, tee eeꞌnara temuriau taamang doong kante ameriaing.” ");
INSERT INTO nas_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jiisuuꞌke aaꞌpuruꞌ, “Nka ning eeꞌnara tee taamang domang-anta-koong. Naning tee ning-anko poaing peeravoaukaꞌnung, eeꞌnoko naning tee ning masikaꞌantamuaing nukaaꞌoaukaꞌnunge. ");
INSERT INTO nas_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ninge tero naurampiring, aaꞌdampima, bane diiꞌke oomerira masikaꞌantameriaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ookara nantoong Mmaꞌke amuko ning-anko poromaing. Ninge bataꞌaramparupeuꞌ ning-anko poroko. ");
INSERT INTO nas_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ning paning-eta simaruꞌ teie botomuioꞌ bakaang pia nkoamaꞌnaang, nkaang pia deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tee botomuuꞌnung bakaang pia aung: teing amuuꞌning tare-koo, niiꞌnung paaꞌaravarooꞌnaang, eeꞌnoko ookara daaꞌarampaing doong asiꞌnooꞌnaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tee Mmaꞌ piavomanaꞌ eeꞌ: ookara ning-koo Bauring-koo ookaama masikaꞌantamaavaining domaang oparavaung nkavaavaing. Eeꞌnoko ninge daaꞌarampaing doong asiꞌnooꞌnaꞌmung.” ");
INSERT INTO nas_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Teketa tee, teinge Juꞌkoong ovontunge makenge minkuminkuauꞌ, bakaang kara orara tampaama aaꞌpuuꞌnooꞌkoo, “Ning eeꞌnara taamang paning-eta pouꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Eeꞌnoko aaꞌpauꞌ, “Aung naning Jiisuuꞌ, Josepaꞌ bauring aiꞌ baa? Niiꞌke baumararing noruꞌarampiri otong. Arekeeꞌ paning-eta pouꞌnung tamparamaung?” ");
INSERT INTO nas_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Diiꞌ orakaꞌ minkuminkururariaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Naning otoaꞌ ning-anko baka popeuꞌnung, Mmaꞌke ning botomuuꞌnunge bokuvuaruko. Eeꞌnoko booꞌketa daaꞌantavampaing doong asiꞌnooꞌnaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Teinge nakaro-nupoonge urikupoonge Daari Meekung-koo eeꞌ daariauꞌ, ‘Ookara nantoong Kumponinge bare-antaniiꞌnuka otoroi otoroaing.’ Ookara Mmaꞌ taaravaamaing eeꞌnoko tee-koo noruꞌ nkavaamaing ning-anko poroaing. ");
INSERT INTO nas_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nka naning Mmaꞌ oovuuꞌnung otoaꞌ. Ninge Kumponing-ankoita mouꞌnunge narunge Mmaꞌ ooantuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Masikaꞌ naurampimang, naning tee ning masikaꞌantamuing domaang oparavaung otoꞌevung. ");
INSERT INTO nas_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ning tee taamang domang-anta. ");
INSERT INTO nas_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Diikakatauroi niiꞌnamuriiꞌ taamang meeꞌboraꞌ sirakamaaꞌkoo naiauꞌning, teka teing boorouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Eeꞌnoko tee aung taamang paning-eta pomaung naninge naivura booaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ning eeꞌnara domang-anta-koong taamang paning-eta mouꞌnung. Naninge aung taamang naivura doong kante domampari otomatoaing, eeꞌnoko tee taamang arompiainung tee nkaang mono, ookara nantoong kansiꞌnupoong domang-anta-koo.” ");
INSERT INTO nas_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Teeꞌ minkuvuioꞌ Juꞌkoong ovontung iiravoroitaaꞌ biiꞌka tataꞌeema aaꞌpauꞌ, “Arekeeꞌ bakaang mono amuripeuꞌ niiꞌke maaꞌkoo?” ");
INSERT INTO nas_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jiisuuꞌke aaꞌpuruꞌ, “Masikaꞌ naurampimang, diiꞌke ning Tee Naning-naumpoꞌ Paning-etaing nkaang mono maaꞌmeriarui dei, nkaang ereng naimeriarui dei, diiꞌ domaang okoruriarupeuꞌ diiꞌka. ");
INSERT INTO nas_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Naning tee nkaang mono maaꞌmuaing, nkaang ereng naimuaing domaang oparavaukaꞌnung otoꞌevuaing, eeꞌnoko booꞌketa daaꞌantavampaing doong asiꞌnooꞌnaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Aming-koo, nkaang mono tee taamang masikung, nkaang ereng teie nainai masikung. ");
INSERT INTO nas_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Baa tee nkaang mono maaꞌuaing eeꞌnoko nkaang ereng naivuaing, ning-koo otoaing eeꞌnoko ning tee-koo oꞌnoai. ");
INSERT INTO nas_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mmaꞌke domampari otomaunge botomuioꞌ ning domamari oꞌnomanaꞌ teeꞌ nariꞌ naning tee maaꞌmuaing domamparavaing ning-koo. ");
INSERT INTO nas_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aung tee naurampiring taamang paning-eta pouꞌnung. Tee taamang-pinaꞌ deeaꞌ diikakatauroi naiaakotaaꞌ boorouꞌnung-pinaꞌ. Naning tee aung taamang naivuaing doong kante domampari otomatoaing.” ");
INSERT INTO nas_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jiisuuꞌke aung kara nauvuruꞌ dootuuꞌnava-koo Kapaneumeꞌnavuntuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aung aaꞌ tee, mmauꞌke bakaning barevare-nupoonge taaravaara aaꞌpauꞌ, “Tee kara aaꞌnaꞌ mankiꞌ. Baie arooꞌupeuꞌ?” ");
INSERT INTO nas_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Eeꞌnoko teing bakaning barevare-nupoong teeꞌ minkuminkuruariko Jiisuuꞌke baka noruꞌuraiꞌnange aaꞌpuruꞌ, “Aung kara minkuansing orara-pinaꞌ noruꞌerima tenkeniriiꞌnaang? ");
INSERT INTO nas_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Eeꞌnoko diiꞌke ning Tee Naning-naumpoꞌ Paning-etaing toromarako nkanooꞌ tero oꞌnokoꞌnooꞌ arekeeꞌ noruꞌdariaing? ");
INSERT INTO nas_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tee eeꞌnara Tanuaang Meekung domaang avuꞌkoong. Naninge baka mono narunge Tanuaang Meekung otoaruko domaang masikung nkavuarupeuꞌ. Nka aung kara ninge naurampiring diiꞌkoo makosi tanuaang-koong domaang avuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Eeꞌnoko diiꞌkoo narionge masikaꞌantameriaꞌ.” Jiisuuꞌke teeꞌ minkuvuuꞌ tee tutuntoma-ita noruꞌuruꞌnung-koo, aaꞌning: teing masikaꞌantavaavaukaꞌning eeꞌnoko tee naning tooka kompui sivuainung tavaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eeꞌnoko Jiisuuꞌke napoꞌ aaꞌpuruꞌnung, “Teeꞌkoo eeꞌnaꞌkoo naurampiring naning ning-anko poarupeuꞌ Mmaꞌke makosi-antavuaruko.” ");
INSERT INTO nas_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Teketa emuꞌ teeꞌ minkuvuioꞌ bakaning barevare-nupoong-koo mmauꞌ toroariruꞌ, siong-koo kasiaavarura. ");
INSERT INTO nas_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Eeꞌnoko Jiisuuꞌke niiꞌ bakaning nanaiꞌketa kenaanka aaꞌmuruꞌ, “Eeꞌnoko diiꞌ arekeeꞌ, siꞌmeriiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimoniꞌ Piitai aaꞌpuuꞌ, “Ovoring ee, baa-anko nanampipeuꞌ? Daꞌ narung otoꞌderung kara domaang oparavaukaꞌnung-koong. ");
INSERT INTO nas_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Eeꞌnoko niiꞌke enang tasiꞌdampira masikaꞌantarampiring, daꞌ Kumponing-etaing Naning Meekung.” ");
INSERT INTO nas_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jiisuuꞌke aaꞌpuruꞌ, “Bane ninge marorampiruꞌ nkaning deentariiꞌnaang, teka diiꞌkoong narung maꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Teeꞌpuma Judasi minkuvukoꞌnung, Saimoniꞌ Kerioꞌnung bauring. Tee, bane Jiisuuꞌ bakaning nanaiꞌketa kenaanka-koonunge, nka tee Jiisuuꞌ kare-nupoong-koo sivuainung. ");
INSERT INTO nas_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Teketa tee damaꞌke Jiisuuꞌ Kaaleliꞌnamenge nanukoꞌnung. Judiaꞌnamenge nanuꞌkoo piavoaruuꞌ Juꞌkoong ovontunge teꞌ otorokoꞌninge tavaavaꞌnaang piavoroko. ");
INSERT INTO nas_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Juꞌnupoong biikaang Paroro Bare-koo Otoꞌkoong dueꞌuioꞌ Jiisuuꞌ baaraꞌmainkaange aaꞌpauꞌ, “Ameng sipera Judiaꞌnameng-koo naniaing dakaning barevare-nupoonge dakaang nko-nko ooaavainaꞌ nkovemaung. ");
INSERT INTO nas_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Naning kapooꞌ nkovumaing ookarai oo-koo piavoi bakuꞌuarupeuꞌ. Teeꞌkoo aing kapooꞌ ookara nkovemaung deekoꞌ sirapoꞌ siꞌdaravaing ookarai ooraara masikaꞌantaraavainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Teinge bane baaraꞌmainkaange masikaꞌ antavaavaꞌ teeꞌpauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Eeꞌnoko Jiisuuꞌke teing aaꞌpuruꞌ, “Nkaang doong mmeꞌ makotuaꞌ. Ookara doonanka diiꞌkoo makosi. Kapooꞌ otoaꞌ diiꞌ avoꞌduripeuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kansiꞌnupoonge diiꞌ munteꞌkoo makosi deeaꞌ, nka ning munteꞌmaamaung doong kante ninge biikaang aarumo orara siraꞌpamaung-koo. ");
INSERT INTO nas_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Berira naniriaing paroro-koo. Ning mmeꞌ nanamparooꞌnaang tee-koo paroro-koo, aiꞌ ning nkaang doong mmeꞌ makotuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Eeꞌnoko teeꞌ nauvuriraiꞌnange tee, Kaaleliꞌnameng-koo teke otouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Teketa baaraꞌmainkaang paroro-koo ureai beroioꞌ Jiisuuꞌke damaꞌketa siraꞌparavaꞌ bakuꞌaritaaꞌ siompuruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Eeꞌnoko Juꞌkoong ovontunge besiꞌaakoꞌ tee-koo paroro-koo, aaꞌpaama, “Tee areꞌ otong?” ");
INSERT INTO nas_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eeꞌnoko tee karikaꞌ iaampeema niiꞌninge aaꞌpaakoꞌ, “Tee naning tampara.” Eeꞌnoko niiꞌninge aaꞌpaakoꞌ, “A, teie nantoong tosivurima orari-antavurimaung.” ");
INSERT INTO nas_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nka baruꞌ sirapoꞌke minkuaavarukoꞌ avoreaitaaꞌ biikaang ovontung-koo. ");
INSERT INTO nas_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Eeꞌnoko paroro-koo navaro oparioꞌ Jiisuuꞌ dootuuꞌnava pankava-koo kuung tumparara kara nau tutumpuruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Eeꞌnoko Juꞌkoong ovontung taꞌninaama aaꞌpauꞌ, “Keei. Aung naning sikuruꞌaravaruuꞌnunge arekeeꞌ kapooꞌ avutevuꞌ noruꞌui otong?” ");
INSERT INTO nas_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jiisuuꞌke aaꞌpuruꞌ, “Ninge kara naurampimaung ning ninka nkaang deeaꞌ, Kumponing-eta pomaung, ning botomuuꞌnung-eta. ");
INSERT INTO nas_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Teinge Kumponing bakaang pia nko-koo okovuriainge ning nkaang kara tasiꞌpaavaing Kumponing-etaing deekoꞌ niiꞌnooꞌ tamung nkaang noruꞌketa karomaung deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Naning baka bakaang noruꞌketa karomaung baka daangang piavoma, eeꞌnoko naning tee botovuuꞌnung bakaang miring pankaing deemparaaꞌnaang piavomaung tee, tee naning koontoꞌ, daang minkuvuaung. ");
INSERT INTO nas_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moosesie ee boto aruriaꞌ? Eeꞌnoko diiꞌkoo narung otoaꞌ doma tee boto siompumaung. Aming-koo diiꞌke dupisiꞌmeriiꞌnaang piarorimang?” ");
INSERT INTO nas_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eeꞌnoko karingai makuꞌaama aaꞌpauꞌ, “Daꞌ maꞌnaang orara-poꞌnung. Baie daꞌ taruuꞌnaang tantumang?” ");
INSERT INTO nas_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Ninge narung nko-nko pankaing nkoanko taꞌniniruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moosesie naururuꞌ diurukaaꞌkoong dopaꞌ napuꞌeriiꞌnaang. Tee eeꞌnara aarumo Moosesie koontoꞌ tutumpuaꞌ, diiꞌ diikakatauroi tutumpauꞌnung, eeꞌnoko tootoꞌ donkaani-koong dopaꞌ totoꞌperimaung bane Uaanaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Diiꞌke tootoꞌnung dopaꞌ napuꞌerimaung Doong Uaanaꞌmung Moosesi-nung boto siomperitaaꞌ. Enang aming-koo diiꞌ iirarorimaang ninge naning mono ookutunung taare-antavansioꞌ Doong Uaanaꞌmung-koo? ");
INSERT INTO nas_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tamung daunaaꞌketa tuumpimeriaukaꞌ. Tampaꞌ mataueri aarumo simpeꞌeriai.” ");
INSERT INTO nas_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Niiꞌninge Jerusalemaꞌnupoonge aaꞌpauꞌ, “Eeꞌ, masikaꞌ, aung tee eeꞌnara naning tavaavaꞌnaang mauꞌaamang, apeꞌ? ");
INSERT INTO nas_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ooveriaing, aung eeꞌnara tee sirapoꞌke karoko naninge karavuaꞌ. Niikaning pankainankai pa tee Kumponinge Pakoꞌpariꞌniiꞌ tasiꞌpai otong, aiꞌ arekeeꞌ? ");
INSERT INTO nas_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nka tee Pakoꞌpariꞌniiꞌ poainaꞌmung naninge noruꞌuaukaꞌnung areketa poainge, eeꞌnoko niiꞌke noruꞌampiri otong aung pouꞌnooꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Teketa Jiisuuꞌke dootuuꞌnava pankava-koo kara nauvurima aaꞌnaꞌ karoma aaꞌpuuꞌ, “Eeꞌ, diiꞌke noruꞌmeri otong, eeꞌnoko mouꞌnooꞌ noruꞌeri otong. Ning aꞌ ninka moaꞌ. Nka tee ning botomuuꞌnung tee masikung diiꞌke noruꞌeriaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Teka ninge noruꞌansi oꞌnong tee, teie botomuioꞌ ning tee-ankoita mouꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Eeꞌnoko teinge tee mooꞌkoo kariaama mooꞌaavarukoꞌ. Naninge tankaꞌ panteꞌuaꞌ tee-koo, bakaang batei mmeꞌ makotuaruko. ");
INSERT INTO nas_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Eeꞌnoko karingai nantoonge tee masikaꞌantavaama aaꞌpaakoꞌ, “Tee Kumponinge uripoꞌketa Pakoꞌpariꞌniiꞌ niiꞌ domamuri taremuriainooꞌkoo poraiꞌnange arekeeꞌ taaꞌniꞌanta nkovuaing aung naning bakaang-koo dau basinooꞌ? Makotuaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Karingai teeꞌ minkuminkuaako teinge Boto Keperuuꞌnavitue taaravauꞌ. Taaravaara tee teinge eeꞌnoko piristiꞌkoong ovontunankai niiꞌning Piatooronanka botoaaruꞌ Jiisuuꞌ mooꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jiisuuꞌke aaꞌpuruꞌ, “Ning diiꞌ ninka okiꞌnooꞌ mmeꞌ oꞌnoriaing, teketa napoꞌ toromaravaing ning botomuuꞌnung-anko. ");
INSERT INTO nas_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Diiꞌke ning besiꞌmeriaing eeꞌnoko oomeriaukaꞌnung, aiꞌ ning oꞌnoainooꞌ diiꞌ beriarupeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juꞌkoong ovontunge biiꞌka kareaama aaꞌpauꞌ, “Areꞌ nanuko niiꞌke ooampiaukaꞌnunge? Aiꞌ Kirikiꞌnupoong biikanameensiꞌaape nanuuꞌnaang niiꞌkoong niiꞌning ninka otorooꞌnaang, eeꞌnoko teing akopoꞌnupoong Kirikiꞌnupoong kara nauvuriiꞌnaang deeꞌma. ");
INSERT INTO nas_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Teie aaꞌmuring, ‘Diiꞌke ning besiꞌmeriaing eeꞌnoko oomeriaukaꞌnung.’ Eeꞌnoko napoꞌ aaꞌmuri, ‘Diiꞌ beriarupeuꞌ ning oꞌnoainooꞌ.’ Tee miruꞌnooꞌ aming teeꞌ minkuvuing?” ");
INSERT INTO nas_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Paroro-koong asiranaꞌmung bakei aaꞌnaꞌ meekaꞌnaꞌmung. Teꞌmung eeꞌnaꞌmung Jiisuuꞌke donkonura aaꞌnaꞌ karoma aaꞌpuruꞌ, “Diiꞌkoong naning tee nukaaꞌdoma ning-anko pora naikiaing. ");
INSERT INTO nas_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Daari Meekung-koo daariari otoinaꞌ aaꞌpumanaꞌ, ‘Naning tee ning masikaꞌantamumaung ntonari domaang-poꞌnari tunsi-eta kooꞌuaing.’” ");
INSERT INTO nas_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jiisuuꞌke teeꞌ minkuvuuꞌ Tanuaang Meekung minkuvuma. Tee eeꞌnara Tanuaang Meekung teinge Jiisuuꞌ masikaꞌantavaakoꞌninge dueꞌka nkavaavaꞌnaang. Teꞌmung eeꞌnaꞌmung teeꞌ minkuvuko Kumponinge Tanuaang Meekung avuriaꞌ, Jiisuuꞌ meenasi-koo mmeꞌ daaꞌaravaruko. ");
INSERT INTO nas_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jiisuuꞌke teeꞌpuioꞌ mmauꞌ nantoonge karikaꞌke otorokoꞌninge taaravaara aaꞌpauꞌ, “Aung naning masikaꞌ tee eeꞌnara nakaronung Kumponing-etaing.” ");
INSERT INTO nas_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Eeꞌnoko napoꞌ niiꞌnarionge aaꞌpauꞌ, “A, tee Pakoꞌpariꞌniiꞌ Kaaleliꞌketa poaukaꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Daari Meekunge eeꞌ minkuvumaang: Tee Pakoꞌpariꞌniiꞌ Deevitaꞌ bakanamuiaang-koo tavoꞌkuaing, eeꞌnoko Beeteleemaꞌnavuntuꞌkoo pontoꞌaravaing, teꞌ eeꞌnooꞌ osi Deevitaꞌ otokoꞌnavuntuꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Teketa tee, ookara teing nantoong paroro-koo poruꞌning pokapokaꞌariruꞌ Jiisuuꞌnung minkunaa tataꞌeema. ");
INSERT INTO nas_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Niiꞌninge mooꞌaara daiꞌaavaꞌnaang piavorouꞌ, nka naninge birenge kompuaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Teketa tee Piatooronuka toroariruꞌ piristiꞌkoong ovontung-anko Boto Keperuuꞌnavitu-anko. Toroariko niaꞌaarima aaꞌpaaruꞌ, “Aming-koo diiꞌke tee bokueri poriaꞌ?” ");
INSERT INTO nas_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Eeꞌnoko piatooronukai kara makuꞌaarima aaꞌpaaruꞌ, “Naning teeꞌ karoaung tee karomanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Eeꞌnoko teinge Boto Keperuuꞌnukai makuꞌaarima aaꞌpaaruꞌ, “Diiꞌ ee napoꞌ teie papaara-antarurining? ");
INSERT INTO nas_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Niiꞌ nantoong pankainanka-koo eeꞌnoko Boto Keperuuꞌnavitu-koo naninge baitoaring tee-koo? Otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Teka aing karikaꞌ Moosesi-nung boto noruꞌaavaꞌ Jiisuuꞌ siompaama barakosiꞌniiꞌ otorong.” ");
INSERT INTO nas_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemasi teing-koong narung otoko, tee eeꞌnara tero Jiisuuꞌ beeroꞌuuꞌnung. Enang teie aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Niikaange botoi tauraꞌmuriaꞌ naning booꞌkoo tang-koo tutung kara bakaang taaravampiaꞌ eeꞌnoko noruꞌampiaꞌ aming kapooꞌ nkovuing.” ");
INSERT INTO nas_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eeꞌnoko teinge makuꞌaama aaꞌpauꞌ, “Ekee, daꞌ doma Kaaleliꞌnung! Daari Meekung tampaꞌ deerueaing noruꞌeainaꞌ nakaro-nupoong poroaung Kaaleliꞌketa.” ");
INSERT INTO nas_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Teketa ookara biikanooꞌ tenkenauꞌ, eeꞌnoko Jiisuuꞌ iuꞌkoo nanuuꞌ Oliveꞌpoꞌnamii-koo. ");
INSERT INTO nas_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Eeꞌnoko maatanang tero mmeꞌ taneꞌpuko Jiisuuꞌ napoꞌ Oliveꞌpoꞌnamii-eta dootuuꞌnava pankava-koo toroaruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Eeꞌnoko mmauꞌ karinga tee-anko oosiaririoꞌ tee baꞌnamparara kara nau tutumpuruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Enang tee boto naunuka eeꞌnoko Boto Keperuuꞌnavitue nani manikuma tavoꞌauꞌ tee-anko. Teinge teni nampeesi orarivuioꞌ ooaaraiꞌnange tavoꞌauꞌ. Eeꞌnoko teinge teni donkong-antavauꞌ uroꞌkanooꞌ teing-koo ookara-koo. ");
INSERT INTO nas_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Eeꞌnoko teinge aaꞌpauꞌ Jiisuuꞌ, “Nau-anta, ani nampeesi orarivuioꞌ ooampiring. ");
INSERT INTO nas_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moosesi-nung Boto-koong daarie eeꞌ minkuvumaang, ‘Nani teeꞌ nkoaravainani kapange tavampiainang booaing.’ Eeꞌnoko dake arekeeꞌ minkuemaang?” ");
INSERT INTO nas_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aavavaama teeꞌpauꞌ, tuumpiaavainooꞌ dauꞌpaavaꞌnaang, teka Jiisuuꞌ kinkinuitaaꞌ kansiꞌkoo daarikukoꞌ tankaꞌke. ");
INSERT INTO nas_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Donkonai mmauꞌ nianiaꞌ niaꞌaakoꞌ, eeꞌnoko niaꞌaamatoko Jiisuuꞌ kinkinuuꞌnooꞌketa koomparara aaꞌpuruꞌ, “Diiꞌkoong naninge tero orara aarumo nkovuaruuꞌnunge tutunaꞌnareꞌke kapanareꞌke ani tooꞌpuai.” ");
INSERT INTO nas_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Teeꞌ minkuvuraiꞌnange napoꞌ kinkinura kansiꞌkoo daarikukoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Eeꞌnoko biikang domang teeꞌ tooꞌpurioꞌ tee tenkenauꞌ teing-koo pankeuꞌke tutumpaara narunaꞌ narunaꞌ. Eeꞌnoko Jiisuuꞌ narung sipauꞌ, eeꞌnoko teni manikuma teꞌ donkonuioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Eeꞌnoko Jiisuuꞌke napoꞌ koomparara aaꞌpuuꞌ, “Ee ani, teing areꞌke berong? Naning ee otoaꞌ daꞌ tuutunantuing?” ");
INSERT INTO nas_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tenie aaꞌpuuꞌ, “Eeꞌ, pankaing, otoaꞌ.” Jiisuuꞌke aaꞌpuuꞌ, “Nnaꞌ ninge daꞌ tuutunantamparooꞌnaang. Bera naniaing. Eeꞌnoko napoꞌ orara aarumo nkoveaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jiisuuꞌke napoꞌ aaꞌpuruꞌ, “Ning tee araka ookara kansiꞌkoo. Naning tee ning siomuaing mutaananooꞌke nanuaukaꞌnung, domaang isikung kompuinge ookara otootoꞌ sirakaꞌantavuioꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Boto Keperuuꞌnukai aaꞌpauꞌ, “Daꞌ daka minkuema tantaramaang, teeꞌkoo nauꞌka masikaꞌantarampiaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “A, bane ninge ninka kara minkuama tammaramaunge, kapooꞌ minkuamaung masikung. Aming-koo, nnaꞌ ninge noruꞌansi oꞌnong ning mouꞌnooꞌ eeꞌnoko ning memaatomanooꞌ. Diiꞌke ning noruꞌmeriaꞌ mouꞌnooꞌ eeꞌnoko areꞌ ning memaatomanooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Diiꞌke ning simpeꞌmerima kansiꞌkoong aarumo narung siomperimaung. Ninge naning simpeꞌampaꞌ oꞌnong. ");
INSERT INTO nas_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nka ninge simpeꞌdampiri dei nkaang kara masikung deemparapeuꞌ. Ning ninka oꞌnoi nkoampaꞌ, teeꞌkoo Mmaꞌ, ning botomuuꞌnung niꞌninka otomaung-koo. ");
INSERT INTO nas_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Diikaang boto-koo eeꞌ otong, ‘Kenaankarai nariꞌ karorema kara siraꞌpureko noruꞌeripeuꞌ tee tee masikung kara.’ ");
INSERT INTO nas_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ninge ninka kara minkuama tammaramaung eeꞌnoko napoꞌ Mmaꞌke botomuuꞌnunge kara teeꞌ napoꞌ siong-antamemumaunge.” ");
INSERT INTO nas_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Teinge aaꞌpauꞌ, “Dauma areꞌ otong?” Eeꞌnoko Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Diiꞌke aaꞌ ning noruꞌmeriaꞌ, Mmaꞌ noruꞌeriaꞌ. Diiꞌke ning noruꞌmeri dei, Mmaꞌ napoꞌ noruꞌeripeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jiisuuꞌke aung kara ookara dootuuꞌnava pankava-koo nauvuruꞌ mooniꞌ bautaꞌkoong sipaakoꞌnavaro-koo. Eeꞌnoko naninge Jiisuuꞌ kiimata-nava-koo sipuaruuꞌ bakaang bateinang mmeꞌ makotuaruko. ");
INSERT INTO nas_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Teketa Jiisuuꞌke napoꞌ aaꞌpuruꞌ, “Ning nanampaing eeꞌnoko nananko diiꞌke ning besiꞌmeriaing, eeꞌnoko diiꞌ dooriaing diikaning oreng aarumo ninka. Diiꞌ naniriarupeuꞌ ning nanamatomanooꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juꞌkoong ovontunge aaꞌpauꞌ, “Aunge aaꞌpumaang, ‘Diiꞌ naniriarupeuꞌ ning nanampainooꞌ.’ Kara-koong miruꞌnooꞌ eeꞌ oroꞌ: tee baka tavaraaꞌnaang deeꞌma.” ");
INSERT INTO nas_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jiisuuꞌke kara makuꞌurima aaꞌpuruꞌ, “Diiꞌ paning-koo boong-nupoong eeꞌnoko ning paning-nung. Diiꞌ kansiꞌnupoong eeꞌnoko ning kansiꞌnung deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Teeꞌkoo naurampiring diiꞌ diikaning oreng aarumo ninka dooriaing. Eeꞌ, masikaꞌ, diiꞌke ning eeꞌnara naning tammaramaung masikaꞌantameriarura deekoꞌ diiꞌ oreng aarumo ninka dooriaing.” ");
INSERT INTO nas_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Teinge niaꞌaama aaꞌpauꞌ, “Naumeriaing, daꞌ teing-koo pankenuka poroaining-koo Daari Meekunge minkuvurimaing-koo baa eeꞌnung?” Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Ning eeꞌnara diiꞌ teroita naurampiruꞌ tutumparuꞌnooꞌketa. ");
INSERT INTO nas_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ninge amutemuriiꞌ kapooꞌ minkuamira diikaang orara aarumo siraꞌpampeuꞌ. Nka tee naning ning botomuuꞌnung bakaang aarumo bakei koontoꞌ masikung, orara aarumo otoaunge. Teie naumumanaꞌ nariꞌ minkuamaung.” ");
INSERT INTO nas_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jiisuuꞌke Bauma-koong kara minkuvuko noruꞌaavaruioꞌ teie napoꞌ aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“Diiꞌke ning Tee Naning-naumpoꞌ Paning-etaing intameriraiꞌnange diiꞌke noruꞌmeriaing ning eeꞌnara baa. Tenang diiꞌke noruꞌmeriaing ninge kapooꞌ nkoampaung maroita, ninge kapooꞌ minkuamaing Mmaꞌke naumumaing naing. ");
INSERT INTO nas_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Eeꞌnoko tee botomuuꞌnung niꞌninka nariꞌ oꞌnoremaung. Ning siꞌmuaung ninka, ninge doong kante kapooꞌnanka dotu-antavumaung nkoamaing-koo.” ");
INSERT INTO nas_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Eeꞌnoko teeꞌ minkuvuko mmauꞌke Jiisuuꞌ masikaꞌantavauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Eeꞌnoko Jiisuuꞌke teing Juꞌnupoong masikaꞌantavauꞌning aaꞌpuruꞌ, “Diiꞌ nkaang kara nariꞌ pinkaꞌerimatoaing deekoꞌ diiꞌ nkaning barevare-nupoong masikeng otoriaing. ");
INSERT INTO nas_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Eeꞌnoko Kumponing bakaang kara masikaꞌpari otoinaꞌ noruꞌeriko teie karai masikai simpiriꞌantaruriaing daiꞌdariri otorimanooꞌketa.” ");
INSERT INTO nas_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Teinge makuꞌaama aaꞌpauꞌ, “Niiꞌ teing Eebaraamiꞌ baꞌdompenku. Naninge teroita daiꞌmurira bakaning botovoto-koo-nupoong deeng-antamuriarukoꞌ. Enang arekeeꞌ teeꞌ minkumerimang daiꞌmariri oꞌnorimanooꞌketa simpiriꞌantamariiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jiisuuꞌke aaꞌpuruꞌ, “Masikaꞌ naurampimang, nantoong teing oreng aarumo nkoaamaing botovotonaaꞌnupoong eeꞌning, orara aarumoi daiꞌuri botovurimaing. ");
INSERT INTO nas_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Naning botovotonaaꞌ tee tamung tankinumaung, teka teing osikaiaang biurukaaꞌ teing teꞌ nariꞌ otoroi otoromaing. ");
INSERT INTO nas_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Teeꞌkoo ninge Pankaing Bauringe botovoto-koong otootoꞌketa simpiriꞌantarampiaing deekoꞌ, bakei tampaꞌ simpiriꞌdariri otoriaing! ");
INSERT INTO nas_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ninge diiꞌ noruꞌdampiri oꞌnong diiꞌ Eebaraamiꞌ baꞌdompenku, eeꞌnoko diiꞌ ning tavuꞌkoo piarorimaung nkaang kara taaraveriaruma. ");
INSERT INTO nas_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ninge kara minkuamaung Mmaꞌke naumumanaꞌ, eeꞌnoko diiꞌke nkoverimaung diumai naururimanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Teinge makuꞌaama aaꞌpauꞌ, “Niuma Eebaraamiꞌ.” Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “A, diiꞌ masikaꞌ Eebaraamiꞌ baurukaaꞌ dei teeꞌ nariꞌ nkovukoꞌnaꞌ nkoveripeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eebaraamiꞌke temuriiꞌ kapooꞌ nkovuaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Diiꞌke tee kapooꞌ diumai nkovukoꞌnaꞌ nkoverimang.” Eeꞌnoko teinge makuꞌaama aaꞌpauꞌ, “Niiꞌ aaꞌ auning-koonanka deeaꞌ. Niiꞌke Niuma narung otong. Kumponing eeꞌnara.” ");
INSERT INTO nas_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jiisuuꞌke aaꞌpuruꞌ, “Kumponing diuma masikung dei diiꞌke ning navumeripeuꞌ, ning aaꞌ Kumponing-ankoita mouꞌnung-koo. Ning maroita ninka moaꞌ, teie botomuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Arekeeꞌ diiꞌke noruꞌeriaꞌ otong kapooꞌ minkuamaaꞌnomaung? Diiꞌke kara naurampimaung koontoꞌ taara-koo piaroriaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Diiꞌ koontoꞌ Sietaniꞌ baurukaaꞌ eeꞌnoko tee diuma, eeꞌnoko diuma piavomanaꞌ siong-koo piarorimaung. Tutuntoma-ita dupisiꞌ nkovukoꞌ. Kara masikung siompuaung. Kara masikung-koo okiꞌnooꞌ okovuaunge. Tee tosi-bauko, ookara tosi-koo okoraꞌ. Bakaang aarumo narung siompuma tosi nkovumaung. ");
INSERT INTO nas_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kara masikung naurampimang, teeꞌkoo diiꞌke masikaꞌantameriaꞌ oꞌnong. ");
INSERT INTO nas_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Diiꞌkoo baie ninge orara aarumo nkoantuꞌnung minkuvupeuꞌ? Eeꞌnoko ninge masikaꞌ naurampiko diiꞌke aming-koo ning masikaꞌantameriaꞌ oꞌnong? ");
INSERT INTO nas_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Naning Kumponing-eta pouꞌnung Kumponing bakaang kara taaravumaung, eeꞌnoko diiꞌ Kumponing-ankoita poriaꞌ. Teeꞌkoo diiꞌke ning taarameriaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Teketa Juꞌkoong ovontunge karai makuꞌauꞌ Jiisuuꞌ. Aaꞌpauꞌ, “Bakei tampaꞌ minkuampiring, daꞌ Sameriaꞌnung, eeꞌnoko daꞌ maꞌnaang-poꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “A, ning maꞌnaang oꞌnoaung. Ninge Mmaꞌ daangampamaung eeꞌnoko diiꞌke ning daang-antamerimaung. ");
INSERT INTO nas_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ninge daangang ninka-koo besiꞌampaꞌ, teeo Mmaꞌke teeꞌ nkovumaung ninge daangang kong-koo, eeꞌnoko teie simpeꞌmuriaing. ");
INSERT INTO nas_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Masikaꞌ naurampimang, naning tee nkaang kara siompumaung booaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juꞌkoong ovontunge Jiisuuꞌ aaꞌpauꞌ, “Enang koontoꞌ noruꞌdampiring daꞌ maꞌnaang-poꞌnung. Eebaraamiꞌ booꞌparuꞌ, eeꞌnoko Kumponing bakaning nakaro-nupoong booꞌpariruꞌnunge, eeꞌnoko aaꞌmerimang, ‘Naning ning nkaang kara taaravuaing booaukaꞌnung.’ ");
INSERT INTO nas_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Niuma Eebaraamiꞌ booꞌparuꞌ, aiꞌ Eebaraamiꞌkoo dau basi tantaramaunge ee? Eeꞌnoko nakaro-nupoong boorouꞌ. Eeꞌnoko baa tantaramaung?” ");
INSERT INTO nas_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Ning ninka daangamari dei, nkaang daangang tamunsiꞌnung. Tee daangamumaung Mmaꞌke eeꞌnarai, nkaang meenasi naururima. Tee eeꞌnara diiꞌke diikaang Kumponing tamperimaung. ");
INSERT INTO nas_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Diiꞌke teroita noruꞌeriaruuꞌ, eeꞌnoko ninge noruꞌansi oꞌnong. Eeꞌnoko ninge aaꞌpamira, ‘Ninge noruꞌampaꞌ,’ ning tosimarapeuꞌ diiꞌpinaꞌ. Nka masikaꞌ ninge tee noruꞌansi oꞌnong, eeꞌnoko bakaang kara siompamaunge. ");
INSERT INTO nas_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Diuma Eebaraamiꞌ dotuaruꞌ nkaang doong oovuuꞌnaang noruꞌuitaaꞌ. Teie oovuuꞌ eeꞌnoko oovuraiꞌnange doturotuaruꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Eeꞌnoko Juꞌkoong ovontunge Jiisuuꞌ aaꞌpauꞌ. “Daꞌ mmeꞌ paꞌnokoꞌ kivora masiraani otoꞌderuaꞌ, arekeeꞌ Eebaraamiꞌ, teronung masikung ooveuꞌ ee?” ");
INSERT INTO nas_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Masikaꞌ naurampimang, tero Eebaraamiꞌ mmeꞌ pontoꞌaravaruko ning oꞌnoi oꞌnomaung oꞌnokoꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Teeꞌ minkuvuioꞌ tee kapananka ukuauꞌ tee tooꞌpaavaꞌnaang, teka Jiisuuꞌ bakuꞌarara tenkenuuꞌ dootuuꞌnava pankava-ita. ");
INSERT INTO nas_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Aung aaꞌ tee, Jiisuuꞌke nanuma naning oovuuꞌ duta mutuu pontoꞌaruꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Niiꞌke bakaninge barevare-nupoonge niaꞌampima aaꞌpampiruꞌ, “Nau-anta Pankaing ee, baie orara aarumo nkovuioꞌ aung duta mutuu pontoꞌaruꞌnunge? Baka aiꞌ baumararinge?” ");
INSERT INTO nas_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jiisuuꞌke makuꞌmurima aaꞌmuruꞌ, “Bakaang mutuu bakaang aarumo-koong deeaꞌ; baumararing beekaang aarumo-koong deeaꞌ. Tee mutuu otomaung Kumponinge bakaang iriꞌ siraꞌantavuuꞌnaang tee-koo naning-koo. ");
INSERT INTO nas_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Niiꞌke nauꞌka ning botomuuꞌnung bakaang nko-nko nkoampiaing doong tankinuaruko. Muumuriiꞌnaang. Naning mintoomparavarupeuꞌ muunganang. ");
INSERT INTO nas_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ning kansiꞌkoo oꞌnoi ning kansiꞌnupoong araka-antanung.” ");
INSERT INTO nas_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Teeꞌ minkuvuraiꞌnange Jiisuuꞌ kansiꞌkoo tutupaaꞌkura tutupaaꞌke metoꞌ nkovura duta sisiꞌuuꞌ, eeꞌnoko aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Bera duuꞌdaravaing poonaruꞌkoo Siloam tampampimanaruꞌkoo.” Aung Siloam miruꞌnooꞌ “Boto-nisi”. Eeꞌnoko tee naning nanuraiꞌnange duuꞌparara ookuitaaꞌ toroaruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Eeꞌnoko baꞌmarange eeꞌnoko teinge tero tee ooaakoꞌninge baꞌnampari mooniꞌ eentavuriko, aaꞌpauꞌ, “Aung ee tee deeaꞌ baꞌnampari mooniꞌ eentamurikoꞌnung?” ");
INSERT INTO nas_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Narionge aaꞌpauꞌ, “Eeꞌ, tee eeꞌnara.” Niiꞌninge aaꞌpauꞌ, “A, tee deeaꞌ. Tee tee-pinaꞌ oroꞌ.” Eeꞌnoko tee baka aaꞌpuruꞌ, “Ning eeꞌnara.” ");
INSERT INTO nas_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aaꞌpauꞌ, “Nka dakaang duta arekeeꞌ banteing?” ");
INSERT INTO nas_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Teie makuꞌurima aaꞌpuruꞌ, “Teie naninge miring Jiisuuꞌke metoꞌ nkovura nkaang duta-koo siꞌmuing. Siꞌmura naumuma aaꞌmuing, ‘Siloam-aape nanira duuꞌdaravaing.’ Eeꞌnoko nanamira duuꞌmarara namuꞌke ookansing.” ");
INSERT INTO nas_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eeꞌnoko teinge niaꞌaama aaꞌpauꞌ, “Areꞌ otong tee eeꞌnara?” Eeꞌnoko teie makuꞌurima aaꞌpuruꞌ, “Noruꞌampaung.” ");
INSERT INTO nas_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Teeꞌpuriko tee, teinge nkavauꞌ Boto Keperuuꞌnavitu-anko tee naning. ");
INSERT INTO nas_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Teꞌmung eeꞌnaꞌmung Jiisuuꞌke metoꞌ nkovura naning mutuu oo-antavuuꞌnaꞌmung Doong Uaanaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eeꞌnoko teing Boto Keperuuꞌnukai napoꞌ tee tanaꞌaama aaꞌpauꞌ, “Arekeeꞌ nkorura tamparuꞌantaruinge?” Eeꞌnoko teie nauvurima aaꞌpuruꞌ, “Teie aaꞌ kansiꞌkoong metoꞌ nkovura duta-koo siꞌmuioꞌ oing duuꞌmarara tampaꞌ ookansing.” ");
INSERT INTO nas_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Eeꞌnoko Boto Keperuuꞌnavitu-koonarioonge aaꞌpauꞌ, “Tee naning temuriiꞌ nkovuinung Kumponing-etaing deeaꞌ, aiꞌ Doong Uaanaꞌmung tampaꞌ tarevuaꞌ teeꞌ nkovuing.” Eeꞌnoko niiꞌnarionge aaꞌpauꞌ, “Arekeeꞌ orara aarumo nkovumaunge temuriiꞌ taaꞌniꞌanta iirakuta nkovupeuꞌ?” Eeꞌnoko teie karai pokapokaꞌantavuruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Teketa tee Boto Keperuuꞌnukai napoꞌ niaꞌaama aaꞌpauꞌ, “Teie oo-antaruing deentarako niaꞌdampimang: Dake tee areꞌpepeuꞌ?” Teie aaꞌpuruꞌ, “Tee aaꞌ nakaronung.” ");
INSERT INTO nas_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nka tee, tee naning enang ookuuꞌnung tero naning mutuu pontoꞌaruꞌnung Juꞌkoong ovontunge masikaꞌantavaavarukoꞌ bera baumararing bokuaaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Eeꞌnoko teinge aaꞌpaaretuꞌ, “Aung ee deeꞌke deuring? Aung ee tee duta mutuu pontoꞌaruꞌnung tamperemaung? Nka arekeeꞌ nkoarara enang ookuing?” ");
INSERT INTO nas_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Baumararinge makuꞌurema aaꞌpuretuꞌ, “Neeꞌke noruꞌampesi otong tee neuring eeꞌnara duta mutuu pontoꞌaruꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Eeꞌnoko neeꞌke noruꞌampeaꞌ arekeeꞌ nkoarara enang ookuinge. Eeꞌnoko napoꞌ noruꞌampeaꞌ baie duta oo-antavuinge. Teie baka naururipeuꞌ, tee matarama.” ");
INSERT INTO nas_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Baumararinge teeꞌ minkuvuretuꞌ tero eeꞌ mauꞌaarioꞌ: Naninge Jiisuuꞌ tee Pakoꞌpariꞌniiꞌ tampuaing deekoꞌ bataꞌaavaing dootuuꞌnava-ita. ");
INSERT INTO nas_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Teeꞌkoo eeꞌnaꞌkoo teeꞌ baumararinge aaꞌpuretuꞌ, “Niaꞌeriaing, baka naururipeuꞌ, tee matarama.” ");
INSERT INTO nas_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Eeꞌnoko napoꞌ kemuꞌkanaꞌ bokuaara tee eeꞌnara naning mutuu pontoꞌaruꞌnung aaꞌpauꞌ, “Bameriaing Kumponinge taararuioꞌ kara masikung narung naumeriaing. Niiꞌke noruꞌampiri otong tee naning orara aarumo nkovumaung.” ");
INSERT INTO nas_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Eeꞌnoko teie naninge makuꞌurima aaꞌpuruꞌ, “Tee orara aarumo nkovumaung aiꞌ tampara, ning noruꞌampaꞌ. Narung kapooꞌ noruꞌansi oꞌnong, ning tero mutuu eeꞌnoko enang ning tampaꞌ ookamaang.” ");
INSERT INTO nas_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Teinge niaꞌaama aaꞌpauꞌ, “Aming kapooꞌ nkovuinge daꞌkoo? Arekeeꞌ dakaang duta oo-antaruinge?” ");
INSERT INTO nas_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Teie makuꞌurima aaꞌpuruꞌ, “Tero naurampiko eeꞌnoko diiꞌke ee taarameriaꞌ? Aming-koo napoꞌ taara-koo piarorimang? Aiꞌ diiꞌ bakaning barevare-nupoong deentariiꞌnaang piarorimang?” ");
INSERT INTO nas_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Teinge barakosiꞌaama aaꞌpauꞌ, “Daꞌ eeꞌnara bakaning-koong. Niiꞌ teing Moosesi bakaning barevare-nupoong. ");
INSERT INTO nas_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Niiꞌke noruꞌampiri otong Kumponinge Moosesi karavukoꞌnaꞌ, eeꞌnoko aung naning noruꞌampiaꞌ areꞌ pouꞌnooꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Eeꞌnoko teie naninge makuꞌurima aaꞌpuruꞌ, “Akokamuriiꞌ kara minkuering doma. Diiꞌke noruꞌeriaꞌ areketa pouꞌ, nka eeꞌnarai ning tamparuꞌantamuing duta. ");
INSERT INTO nas_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Niiꞌke noruꞌampiri otong Kumponinge orara aarumo nkoaamaing taaravuriaung, eeꞌnoko teing nantoong masikaꞌantavaamaing eeꞌnoko marovurimanaꞌ nkoaamaing taaravurimaung. ");
INSERT INTO nas_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kansiꞌ pupuꞌaruꞌnooꞌketa minkunaa otoaꞌ naning duta mutuu pontoꞌaruꞌnung oo-antavuuꞌnung-koong. ");
INSERT INTO nas_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aung naning Kumponing-eta poarui dei kapooꞌ nkovuarupeuꞌ bakei.” ");
INSERT INTO nas_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Teinge kara makuꞌaama aaꞌpauꞌ, “Diiꞌdaang orara aarumo-koo kuunge otori orakaꞌ pontoꞌdaruꞌnung daꞌ. Arekeeꞌ niiꞌ tautau-koo piaromaang?” Eeꞌnoko dootuuꞌnava pankava-ita bataꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jiisuuꞌke tee taaravura dootuuꞌnava-ita bataꞌaioꞌ besiꞌuuꞌ, eeꞌnoko besiꞌukotaaꞌ oovura aaꞌpuuꞌ, “Dake ee tee Naning-naumpoꞌ Paning-etaing masikaꞌantavemang?” ");
INSERT INTO nas_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Eeꞌnoko teie aaꞌpuuꞌ, “Ee pankaing, naumeaing masikaꞌantavampainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jiisuuꞌke aaꞌpuuꞌ, “Tee aaꞌ dake tero ooveing eeꞌnoko tee eeꞌnara naning enang kareremaang.” ");
INSERT INTO nas_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Teie naninge makuꞌuma aaꞌpuuꞌ, “Ovoring ee, masikaꞌantaransing.” Teeꞌpura kinkinuuꞌ Jiisuuꞌanko, pankaing-antavuma. ");
INSERT INTO nas_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jiisuuꞌke aaꞌpuuꞌ, “Ning kansiꞌkoo eeꞌ simpeꞌkoo mouꞌnung: mutuunanka bantang-anta-koo eeꞌnoko teing banteai otoroining tamparimaing kaputuꞌanta-koo.” ");
INSERT INTO nas_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Teeꞌpuioꞌ enang Boto Keperuuꞌnavitu-koo-narionge Jiisuuꞌ ninka otorokoꞌninge taaravaara niaꞌaama aaꞌpauꞌ, “Dake arekeeꞌ minkuemaang? Niiꞌ mutuunanka ee?” ");
INSERT INTO nas_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Diiꞌ mutuu siraꞌrariri tantariko dei tuumpi diiꞌkoo otoarupeuꞌ. Nka eeꞌnoko ‘Niiꞌ ookirining!’ tantariko enang tuumpi diiꞌkoo mmeꞌ otong.” ");
INSERT INTO nas_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Masikaꞌ naurampimang, naning tee karanaange tumparavarura sipisipiꞌ biikaang-koo parang-koo niiꞌnooꞌke tumparapeuꞌnung tee eeꞌnara naning bakisipung, tatusiꞌ bauko. ");
INSERT INTO nas_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Eeꞌnoko tee naning tee karanaange tumparamaung parang-koo sipisipiꞌ biikaang-koo tee eeꞌnara sipisipiꞌ okovenung. ");
INSERT INTO nas_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Eeꞌnoko okovenung poko teie naninge karanaang tarevumaunge kuꞌnung bereꞌevumaung. Eeꞌnoko sipisipiꞌnankai okovenung bakaang kara tasiꞌpaamaung bakaning bokuvuriko sipisipiꞌkoong mirinanka, barampurima damaꞌdu-aape. ");
INSERT INTO nas_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Eeꞌnoko damaꞌdu sipurima teing-koo uroꞌke nanumaung. Eeꞌnoko bakaninge sipisipiꞌke siompaamaung, bakaang kara tasiꞌpai. ");
INSERT INTO nas_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Niiꞌnung naning teinge siompaavarupeuꞌ. Niiꞌnung-ankoita kooꞌaripeuꞌ bakaang kara tasiꞌpaavarura.” ");
INSERT INTO nas_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jiisuuꞌke aung kara mirumiruꞌ nauvuruꞌ Boto Keperuuꞌnuka, eeꞌnoko teinge noruꞌaavaruuꞌ tee kapooꞌ minkuvukoꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Teeꞌkoo napoꞌ Jiisuuꞌke nauvurima aaꞌpuruꞌ, “Masikaꞌ naurampimang, ning eeꞌnara karanaang sipisipiꞌ biikaang parang-koong. ");
INSERT INTO nas_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ookara tero porouꞌning karanaang tamparima bakisipunanka eeꞌnoko tatusiꞌ baukonanka. Sipisipiꞌnankai taaravaariarukoꞌ teing. ");
INSERT INTO nas_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nka tee, ning eeꞌnara karanaang parang-koong. Baa tee ning-anko pora tumparavainung domang mooꞌaravaing. Napoꞌ teie tumparama eeꞌnoko siarama taamang oovumatoaing. ");
INSERT INTO nas_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bakisipunanka poromaung bakiaaꞌaariiꞌnaang, tavaariiꞌnaang, keraꞌpaariiꞌnaang. Eeꞌnoko ning mouꞌnung domaang otoꞌevuriiꞌnaang, domaang tampaꞌ otoi-otoꞌke maantoꞌnisi. ");
INSERT INTO nas_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ning tampara tarenara. Tampara tarenara bakaning-koo sipisipiꞌkoo booꞌparapeuꞌnung makosi. ");
INSERT INTO nas_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Eeꞌnoko tee naning mooꞌ nka-koo tanata nkovumaung tampara tarenara deeaꞌ eeꞌnoko sipisipiꞌ okovenung deeaꞌ. Teie nkau poko oovuma sipisipiꞌ sipurima kooꞌaramaung. Eeꞌnoko nkau poma sipisipiꞌnanka tavuriko purarinkaꞌarimaung. ");
INSERT INTO nas_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Naning mooꞌkoo tanata nkovumaung kooꞌaramaung mooꞌkoo narung-koo tanatavumaung deemparama. Sipisipiꞌnanka-koo taraꞌoaunge. ");
INSERT INTO nas_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ning tee tampara tarenara; ");
INSERT INTO nas_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mmaꞌke tasiꞌmui oꞌnoinaꞌ eeꞌnoko ninge Mmaꞌ tasiꞌpansi oꞌnong, teeꞌ nariꞌ ninge tasiꞌparansi oꞌnong nkaning sipisipiꞌnanka eeꞌnoko teinge tasiꞌmai oꞌnong. Teing-koo ning moompaing makosi. ");
INSERT INTO nas_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eeꞌnoko niiꞌning sipisipiꞌ otoꞌmemung aung-koo parang-koo kuung otoroaing. Teing siomparamira bokuaranko naroꞌ otoroi nkaang kara taaramaako ning biikaang tarenara narung oꞌnoai. ");
INSERT INTO nas_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ning Mmaꞌke ning piaamumaung tee ninge nakaang domaang sipampaing-koo; eeꞌnoko napoꞌ nkavampai. ");
INSERT INTO nas_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nantoonge nkaang domaang pariꞌmaavaukaꞌnung. Ninge ninka maroita sipampaing. Ning iriꞌ otoꞌmemung nkaang domaang sipampeuꞌnung-koo, eeꞌnoko napoꞌ iriꞌ otoꞌmemung ninge napoꞌ domaang nkavampeuꞌnung-koo. Mmaꞌke teeꞌ nko-koo botomuuꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aung aaꞌ tee napoꞌ Juꞌkoong ovontung pokapokaꞌariruꞌ teing kara taaravaara. ");
INSERT INTO nas_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mmauꞌke teing-koo narionge aaꞌpaakoꞌ, “Aung-koo maꞌnaang orara otong. Kanuꞌaramang. Taaraveriaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Eeꞌnoko napoꞌ niiꞌnarionge napoꞌ aaꞌpaakoꞌ, “Naning maꞌnaang orara-poꞌnung teeꞌ karoarupeuꞌ. Eeꞌnoko naning maꞌnaang orara-poꞌnunge arekeeꞌ naning duta mutuu tamparuꞌantavupeuꞌ?” ");
INSERT INTO nas_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Niiꞌnaꞌmung Jerusalemaꞌnavuntuꞌkoo doong meekung tavoꞌkuuꞌ, teꞌmung eeꞌnaꞌmung dootuuꞌnava pankava bereꞌauꞌnaꞌmung-koong paroro nkoaakoꞌnaꞌmung. Tenang kamaari bakanang. ");
INSERT INTO nas_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Teꞌmung eeꞌnaꞌmung Jiisuuꞌ nanuꞌnanuuꞌ dootuuꞌnava pankava-koo bansing-navaro-koo miring Solomoniꞌnavaro-koo. ");
INSERT INTO nas_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Eeꞌnoko Juꞌkoong ovontunge teka koroai aaꞌpauꞌ, “Dake niiꞌ areꞌ basinooꞌ papaara-antameriiꞌnaang? Koontoꞌ siraꞌdari naumeriaing. Daꞌ ee tee Domang-anta Pakoꞌpariꞌniiꞌ tavoꞌaravaing-koong?” ");
INSERT INTO nas_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Tero naurampiruꞌ, teka diiꞌke ning masikaꞌantameriaꞌ. Teing nko-nkonanka Mmaꞌke botomuioꞌ nkoamaaꞌnomaing teing taaꞌniꞌantananka ning-koo. ");
INSERT INTO nas_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Diiꞌ nkaning sipisipiꞌnanka deeaꞌ, teeꞌkoo diiꞌke ning masikaꞌantameriaung. ");
INSERT INTO nas_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nkaninge sipisipiꞌnankai nkaang kara taaravaamaung, ninge noruꞌaransi oꞌnong, eeꞌnoko teinge ning siomaamaung. ");
INSERT INTO nas_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Domaang oparavaukaꞌnung avoromaung, eeꞌnoko teing booroaukaꞌnunge, eeꞌnoko naninge tatusiꞌuriaukaꞌnunge nkaang bireng-eta. ");
INSERT INTO nas_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mmaꞌke ookara-koo dau basie teing amuuꞌ. Naninge tatusiꞌuriarupeuꞌ Mmaꞌketa, bakaang bireng-eta. ");
INSERT INTO nas_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mmaꞌ eeꞌnoko ning narung.” ");
INSERT INTO nas_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Eeꞌnoko Juꞌkoong ovontunge napoꞌ kapang ukuauꞌ tee tooꞌpaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Teka Jiisuuꞌke aaꞌpuruꞌ, “Diiꞌke oomerioꞌ nko-nkonanka tamparananka nkoamaung Mmaꞌke pakumuioꞌ. Teing-koo orara arera nkoansing-koo kapange tooꞌmeriiꞌnaang piarorimang?” ");
INSERT INTO nas_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juꞌkoong ovontunge napoꞌ Jiisuuꞌ makuꞌaama aaꞌpauꞌ, “Niiꞌke daꞌ kapang naꞌnang-koo piamoriaꞌ dakaang nko-nko tampara-koo, nka dake Kumponing akapeuꞌemaung-koo, daꞌ tamunsiꞌnung naning daka Kumponing tantaramaung-koo.” ");
INSERT INTO nas_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Tee aaꞌ diikaang-koo boto-koo naneꞌkoo eeꞌ daariari otong, Kumponinge tero-nupoong-kooning pankainuka aaꞌpuruꞌ, ‘Diiꞌ teing kumponinanka.’ ");
INSERT INTO nas_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tee kara tee Daari Meekung-koong, diiꞌke tontaꞌkoo makosi deeaꞌ. Eeꞌnoko teie teing bakaang kara taaravaama pareꞌaakoꞌning kumponinanka tang-koo makosi deekoꞌ ning tee Baumai meekaꞌantamura aꞌ kansiꞌkoo mooꞌnaang botomuuꞌnung dau basinaꞌ makosi tee miring nka-koo; ");
INSERT INTO nas_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Teeꞌkoo arekeeꞌkoo ninge Kumponing akapeuꞌamaaꞌnomaung tammerimaunge ning Kumponing Bauring tammarako? ");
INSERT INTO nas_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Makosi, masikaꞌantameriaukaꞌnung ninge Mmaꞌ bakaang nko-nko nkoamparuko dei. ");
INSERT INTO nas_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nka bane diiꞌke nau-antarampiko tamung masikaꞌantameriaung, teing nko-nkonanka nkoamaing Kumponing bakaning tasiꞌperi masikaꞌantaveriaing, koontoꞌ noruꞌmeriainaꞌ Mmaꞌ ning-koo otong eeꞌnoko ning Mmaꞌkoo oꞌnong.” ");
INSERT INTO nas_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Eeꞌnoko teketa napoꞌ Juꞌkoong ovontunge mooꞌaavaꞌnaang mauꞌauꞌ, teka teing divuꞌuri tenkenuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Eeꞌnoko Jiisuuꞌ napoꞌ toroaruꞌ Jooꞌdani-nari tankimpui Joonie tero nantoong ntong-koo minkivurima meekaꞌantavurikoꞌnooꞌaape. Eeꞌnoko Jiisuuꞌ teꞌ otouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mmauꞌ nantoong tee-anko poroma aaꞌpauꞌ, “Joonie taꞌnimpaariiꞌnaꞌ taaꞌniꞌanta nkovuaruuꞌ, teka ookara kapooꞌ aung naning-koo minkuvuuꞌnung kara masikung.” ");
INSERT INTO nas_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eeꞌnoko mmauꞌ nantoonge teꞌ otorokoꞌninge Jiisuuꞌ masikaꞌantavauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Niiꞌnaꞌmung tee, naning Lasarusi tampaakoꞌnung, Beetani-navuntuꞌkoo otokoꞌnung siipavouꞌ. Teꞌ eeꞌnooꞌ Beetani Maaria-namainta otorekoꞌnooꞌ Maataꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Teni eeꞌnani Meeriꞌ Jiisuuꞌkoo tampaꞌ nuuraaꞌ kauꞌkoo duuni dakovuuꞌnani eeꞌnoko napoꞌ dapoi piuꞌuuꞌ aaꞌnani. Lasarusi teni baꞌmari siipavouꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eeꞌnoko baꞌmari-kaarai Jiisuuꞌanko kara nanuꞌantavurema aaꞌpuretuꞌ, “Ovoring, tee daꞌmaikoꞌ siipavomang.” ");
INSERT INTO nas_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jiisuuꞌke taaravuraiꞌnange aaꞌpuruꞌ, “Lasarusi siipavomang, nka booaukaꞌnung. Siipa tavoꞌaringe Kumponing-nung meenasi tavoꞌantavuuꞌnaang. Eeꞌnoko aung siipa kompui Kumponinge ning Bauring meenasi amuuꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Maataꞌnamaiaꞌ eeꞌnoko Lasarusi Jiisuuꞌke aaꞌnaꞌ piaavurikoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Eeꞌnoko Lasarusi siipavoko Jiisuuꞌke taaravura tamung keꞌmunta doong otouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Keꞌmunta doong tankinuioꞌ tee, teie niiꞌ bakaning barevare-nupoong aaꞌmuruꞌ, “Meriaing; nanampiaing; Judiaꞌnameng-aape toromariaing.” ");
INSERT INTO nas_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Eeꞌnoko niiꞌke bakaning barevare-nupoonge makuꞌampima aaꞌpampiruꞌ, “Nau-anta Pankaing ee, teꞌmung Juꞌkoong ovontunge daꞌ daping kapange tooꞌdaieeng. Arekeeꞌ mauꞌemaang teꞌaape tororaraaꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jiisuuꞌke aaꞌmuruꞌ, “Tee batei narung doong-koong niiꞌkoo sirakaꞌpari otong. Nantoong doonganang nanaama puꞌariaung arakai kansiꞌkoonge sirakaꞌpui otoko. ");
INSERT INTO nas_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Teka muunga deekoꞌ nanaama puꞌaripeuꞌ, aming-koo, nnaꞌ tee araka otoaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jiisuuꞌke teeꞌpura napoꞌ aaꞌmuruꞌ, “Niikaang naning Lasarusi aatui otong, nka nanamira daaꞌampaing.” ");
INSERT INTO nas_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eeꞌnoko niiꞌke bakaninge aaꞌpampiruꞌ, “Ovoring, tee aatura tampaꞌ deeꞌooꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nka Jiisuuꞌke Lasarusi booꞌparuꞌnung naumuriko niiꞌke noruꞌampiaꞌ, tamung aatuuꞌnung pinaꞌ minkuvuko tampampima. ");
INSERT INTO nas_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Teketa tee tenang Jiisuuꞌke koontoꞌ naumurima aaꞌmuruꞌ, “Lasarusi aaꞌ booꞌparing. ");
INSERT INTO nas_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nka tee ninka oꞌnorearuing-koo dotumaring diiꞌke masikaꞌantameriiꞌnaang noruꞌamira. Aiaꞌ, tee-anko nanamping.” ");
INSERT INTO nas_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toomasi, niiꞌnooꞌ miring Pauroong tampampimaunge, niiꞌ baꞌmarang aaꞌmuruꞌ, “Aiaꞌ meriaing Nau-anta ninka, niiꞌ ookara tee ninka nariꞌ moompiainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Eeꞌnoko Jiisuuꞌke pora oovuuꞌ Lasarusi karenaumo doong kuvi dakoꞌdomanooꞌ otoioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Beetani-namono Jerusalemaꞌketa narung kokoreiꞌ daangaꞌpinaꞌ basinooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Eeꞌnoko mmauꞌ Juꞌnupoong porokoꞌ Maataꞌnamainta Meeriꞌ dunsirunsi-antavaarema˜ beeꞌmari booꞌparuꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eeꞌnoko Maataꞌke Jiisuuꞌ pokoꞌnung taaravuraiꞌnange taung nanuuꞌ kuneꞌuuꞌnaang, eeꞌnoko Meeriꞌ pava-koo otoko. ");
INSERT INTO nas_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maataꞌke aaꞌpuuꞌ Jiisuuꞌ, “Ovoring, daꞌ aꞌ otoieeng dei mmari booarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nka ninge noruꞌansi oꞌnong Kumponinge arupeuꞌ kapooꞌ niaꞌepeuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jiisuuꞌke aaꞌpuuꞌ, “Daꞌmari domamparaaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tenie makuꞌuma aaꞌpuuꞌ, “Noruꞌansi oꞌnong tee daaꞌaravaing doong asiꞌnooꞌnaꞌmung.” ");
INSERT INTO nas_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jiisuuꞌke teni aaꞌpuuꞌ, “Ning aaꞌ naning booꞌketa daaꞌnunge, domang-antai. Baa tee ning masikaꞌantamumaung domamparavaing bane booꞌparavainge. ");
INSERT INTO nas_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Eeꞌnoko baa tee domampari ning masikaꞌantamumaung booꞌparavaukaꞌnung. Dake ee masikaꞌantavemang aung?” ");
INSERT INTO nas_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tenie aaꞌpuuꞌ, “Eeꞌ, ee Ovoring, masikaꞌantavamang daꞌ tee Karistooꞌ, Kumponing Bauring, tee Kumponinge teroita Pakoꞌpariꞌniiꞌ aꞌ kansiꞌkoo pora niiꞌ domamuriaing-koo.” ");
INSERT INTO nas_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Eeꞌnoko teeꞌ minkuvura Maataꞌ baaraꞌmaꞌnaang-anko Meeriꞌanko toroarara baka aaꞌpuuꞌ, “Nau-anta ankaꞌ otong, daꞌ niaꞌdumaang.” ");
INSERT INTO nas_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Eeꞌnoko Meeriꞌke tee kara taaravuraiꞌnange daaꞌarara kuaꞌpari nanuuꞌ kuneꞌuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jiisuuꞌ mmeꞌ tavoꞌaravaruko osi, teꞌ Maataꞌke kuneꞌuuꞌnooꞌ naroꞌ otoko. ");
INSERT INTO nas_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Eeꞌnoko niiꞌning Juꞌnupoong teva-koo kuung otorokoꞌnung Meeriꞌ ninka teni dunsirunsi-antavaama. Teketa teni iriꞌnarung daaꞌarara tenkenuko siompauꞌ, eeꞌ noruꞌaama, “Teni deeꞌma kuvi dakoꞌdoma-aape nanumang teke biromparaaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Eeꞌnoko Meeriꞌ tavoꞌaruꞌ Jiisuuꞌ otokoꞌnooꞌ. Eeꞌnoko tenie oovuraiꞌnange kauꞌkanooꞌ duaꞌaruꞌ aaꞌpuma, “Ovoring, daꞌ otoieeng dei mmari booꞌparavarupeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Eeꞌnoko Jiisuuꞌke teni biromparako oovura eeꞌnoko Juꞌnupoong teni ninka porouꞌning birompariko oovurira bakaang domang aaꞌnaꞌ orarunsie mankiꞌouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Eeꞌnoko Jiisuuꞌke niaꞌurima, aaꞌpuruꞌ, “Areꞌ dakoꞌerieenge?” Eeꞌnoko teinge bokuaama aaꞌpauꞌ, “Ovoring, pora ooveaing.” ");
INSERT INTO nas_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Eeꞌnoko Jiisuuꞌ biromparuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Eeꞌnoko Juꞌnupoonge aaꞌpauꞌ, “Ooveriaing aaꞌnaꞌ piaavumanaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Eeꞌnoko niiꞌninge aaꞌpauꞌ, “Teie tee temuꞌ naning duta mutuu tamparuꞌantavuuꞌ, apeꞌ? Arekeeꞌ aꞌmung Lasarusi booꞌparavarooꞌnaang kapooꞌ nkovuaruiee?” ");
INSERT INTO nas_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Napoꞌ aaꞌnaꞌ orakaꞌ deeꞌoitaaꞌ Jiisuuꞌ nanuuꞌ kuvi dakoꞌdoma-aape. Tee kuvi kapange daꞌpauꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jiisuuꞌke botovurima aaꞌpuruꞌ, “Tee kapang diiriꞌeriai.” Eeꞌnoko Maataꞌke, tee naning booꞌparuꞌnung baꞌmarie aaꞌpuuꞌ, “Ee Ovoring, orakaꞌ kaꞌmiꞌmoriꞌneeng. Tee karenang doong tankinuieeng booꞌparioꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jiisuuꞌke aaꞌpuuꞌ, “Ninge nauransing daꞌ ning masikaꞌantameaing deekoꞌ Kumponing bakaang meenasi ooveaing. Aiꞌ daꞌ ampaꞌdoinge?” ");
INSERT INTO nas_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Eeꞌnoko tee boiaꞌ diiriꞌauꞌ kuvi dakoꞌdoma karanaang-eta. Diiriꞌaioꞌ Jiisuuꞌke ankamparara aaꞌpuuꞌ, “Mmaꞌ ee, tampara tantamang dake nkaang eenta taaramemaung-koo. ");
INSERT INTO nas_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ninge noruꞌansi oꞌnong dake doong kante taaramemaung. Ninge teeꞌ nauransing nantoonge taaramaara masikaꞌantamaavaꞌnaang dake botomeuꞌnung ning.” ");
INSERT INTO nas_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eeꞌnoko teeꞌ minkuvuraiꞌnange aaꞌnaꞌ bokuma aaꞌpuuꞌ, “Lasarusi, sirapoꞌ poai!” ");
INSERT INTO nas_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eeꞌnoko tee booꞌparuꞌnung sirapoꞌ pouꞌ bakaang bireng eeꞌnoko kauꞌ daiꞌaritaaꞌnange baaronge, bakaang oing baaronge daiꞌaritaaꞌ. Eeꞌnoko Jiisuuꞌke botovurima aaꞌpuruꞌ, “Dapaꞌeriaing nanuainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mmauꞌ Juꞌnupoong Meeriꞌ siompauꞌning Jiisuuꞌke kapooꞌ nkovuuꞌnung ooaaraiꞌnange masikaꞌantavauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Eeꞌnoko narionge Boto Keperuuꞌnavitu-anko toroariraiꞌnange nauaaruꞌ kapooꞌ Jiisuuꞌke nkovuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Teketa tee, taaravaaraiꞌnange Boto Keperuuꞌnavitue eeꞌnoko piristiꞌnuka-koo ovontunankai koompaaraꞌnavitu ninka mumunsinang nkoaama aaꞌpauꞌ, “Arekeeꞌ nkoampiiꞌnaang? Aung naning baruꞌ mmauꞌ taaꞌniꞌanta nkovumaatoing. ");
INSERT INTO nas_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Niiꞌke tamung ooampiaing deekoꞌ aung mmauꞌke daurarong˜pinaꞌ masikaꞌantavaara Roomaꞌnupoong beiꞌbeiꞌaariko teinge niiꞌ ookara piniraakuꞌmaariaing dootuuꞌnava pankava nariꞌ pesiꞌaama.” ");
INSERT INTO nas_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Narunge naninge miring Kaiapasie Piristiꞌkoo Ovoring deempari otokoꞌnunge aaꞌpuruꞌ, “Diiꞌke kapooꞌ noruꞌeriaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Diiꞌke ee tasiꞌperiaꞌ otong tampaꞌnaꞌ teeꞌ naning narung boi dei niiꞌ ookara domang mooꞌmaripeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nka teie baka teeꞌ minkuvuaꞌ, tee Piristiꞌkoong Ovoring deemparitaaꞌ teeꞌ tarampeearuꞌ Jiisuuꞌ booꞌparaaꞌnaang niiꞌkoo Juꞌnupoong-koo. ");
INSERT INTO nas_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Eeꞌnoko niiꞌ naing-koo deeaꞌ, ookara Kumponing baurukaaꞌ amutemuuꞌketa oosimuriiꞌnaang narung mono-pinaꞌ oꞌnoriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Teꞌmung-eta tutumpauꞌ Jiisuuꞌ tavaavaꞌnaang mumunsi-koo. ");
INSERT INTO nas_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eeꞌnoko teeꞌkoo Jiisuuꞌ baruꞌ sirapoꞌke nanuarukoꞌ Judiaꞌnameng-koo. Teketa tenkenuraiꞌnange niiꞌnooꞌ osi nanuuꞌ miring Eparaim, meeꞌboraꞌ sirakamaaꞌkoo dueꞌ. Eeꞌnoko teꞌ oꞌnorikoꞌ niiꞌ bakaning barevare-nupoong ninka. ");
INSERT INTO nas_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tenang Juꞌnupoong biikaang Paroro Baariꞌkoong˜ dueꞌuuꞌnang. Mmauꞌ nantoong avuntevuntuꞌketa Jerusalemaꞌaape nanaakoꞌ neriarima kiiroraaꞌantavariaꞌnaang tee-koo paroro-koo makosinaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Eeꞌnoko teinge Jiisuuꞌ besiꞌaakoꞌ teke, eeꞌnoko dootuuꞌnava pankava-koo oosiarima niaꞌeema aaꞌpeekoꞌ, “Dake arekeeꞌ noruꞌemaang? Tee paroro-koo pa poarooꞌnaang deeꞌma.” ");
INSERT INTO nas_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tero piristiꞌkoong ovontunge eeꞌnoko Boto Keperuuꞌnavitue boto nauaarima aaꞌpaaruꞌ, “Naninge tee Jiisuuꞌ otomanooꞌ noruꞌuraiꞌnange teie nauꞌka naumuriaing, teinge Jiisuuꞌ mooꞌaara kiimata-nava-koo sipaavaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Teketa tee, ˜naꞌmung-taa doong otoko Taamang Baariꞌkoong˜ nkoaavaꞌnaang Jiisuuꞌ Beetani-namono-aape nanuuꞌ. Temono eeꞌnamono Lasarusi bakanamono, tee Jiisuuꞌke tero daaꞌantavuuꞌnung bakanamono. ");
INSERT INTO nas_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jiisuuꞌ teꞌ poioꞌ taamang pankaing nkoauꞌ. Maataꞌke Jiisuuꞌ eeꞌnoko teing tee oo-koo porouꞌning bauꞌuruꞌ, eeꞌnoko Lasarusi Jiisuuꞌ ninka baꞌnamparesioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Eeꞌnoko Meeriꞌke mou-koong-pinaꞌ ntong-pinaꞌ basi duuni nkavui pouꞌ, tampaꞌ nuuraaꞌ naruꞌ, naaradaꞌ narunge nkoniiꞌ, mooꞌ pankaing-koonaruꞌ. Eeꞌnoko Jiisuuꞌkoong-koo kauꞌkoo kooꞌuuꞌ eeꞌnoko bakaange dapoi napoꞌ kauꞌ piuꞌuuꞌ. Eeꞌnoko teie tampaꞌ nuuraaꞌke teva nariꞌ nuuraaꞌaruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Eeꞌnoko niiꞌkoong Jiisuuꞌ bakaning barevare-nupoong-koonarunge, Judasi Kerioꞌnunge, teie Jiisuuꞌ damaꞌke kare-nupoong-koo sivuainunge aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Aming-koo anie aruꞌ duuninaruꞌ tampaꞌ nuuraaꞌnaruꞌ keraꞌpuing? Baavevura dei beenaumo daakuꞌ namikuri nkavupeuꞌ eeꞌnoko ataꞌoiꞌnuka pakuvuripeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Teie ataꞌoiꞌnanka-koo taraꞌoaꞌ, tamung teeꞌ minkuvuuꞌ tee baka bakisipung deemparama, teie mooniꞌ sipaakoꞌnaraꞌ bakura kompui bakiaaꞌurikoꞌnooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Teni sipeai. Aung tee ning dakoꞌmaavainaꞌmung-koo makosi koreꞌmemuuꞌnung, teeꞌ nkovuing. ");
INSERT INTO nas_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Diiꞌ ataꞌoiꞌnuka ninka doong kante otorimaung eeꞌnoko ning doong kante diiꞌ ninka oꞌnoriaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Eeꞌnoko Juꞌnupoong karikaꞌke taaravauꞌ Jiisuuꞌ Beetani-navuntuꞌkoo otokoꞌnung. Eeꞌnoko teꞌ nanauꞌ, Jiisuuꞌ narung oo-koo deeaꞌ, napoꞌ tee Lasarusi oo-koo berouꞌ, tee Jiisuuꞌke booꞌketa daaꞌantavuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Teeꞌkoo piristiꞌkoong ovontunankai matauauꞌ Lasarusi tavaavaꞌnaang, tee Lasarusi ooaaraiꞌnange mmauꞌ Juꞌnupoonge biikaning pankainanka sipaaruꞌnung-koo, Jiisuuꞌ masikaꞌantavaama. ");
INSERT INTO nas_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Teketa daunaꞌmung tee karikaꞌke taaravauꞌ Baariꞌkoong Paroro-koo porokoꞌninge Jiisuuꞌ Jerusalemaꞌaape pooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Taaravaara uurung tovang nkavai osi-eta tenkenauꞌ kuneꞌaavaꞌnaang. Eeꞌnoko euravaama bokiaama aaꞌpauꞌ, “Biraanke! Biraanke-poꞌnung tee aung Kumponing bakaang miring-koo pomaang; aung tee daurarong niiꞌ Isireeli-nupoong niikaang!” ");
INSERT INTO nas_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jiisuuꞌke doonkiiꞌnavoroꞌ nkavura, doonkiiꞌkoo dau baꞌnanui nanuko, teeꞌ Daari Meekunge minkuvumanaꞌ, aaꞌpumanaꞌ, ");
INSERT INTO nas_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Aroreriaukaꞌ diiꞌ Saioni-nupoong, diikaang daurarong diiꞌanko pomaang doonkiiꞌnu kampianu-koo dau baꞌnanui.” ");
INSERT INTO nas_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Niiꞌke bakaning barevare-nupoonge tasiꞌpampiarukoꞌ tee kapooꞌ nkoaruꞌnung. Jiisuuꞌ daaꞌaruꞌnang bakaang meenasi ninka deekoꞌ niiꞌkoo siraꞌparuꞌ tee Daari Meekunge tutung minkuvuuꞌnung teeꞌ nkoaraaꞌnaang eeꞌnoko teeꞌ nariꞌ nkoaruꞌ Jiisuuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Teing karinga Jiisuuꞌke bokuma Lasarusi booꞌparioꞌ kuvi dakoꞌauꞌnooꞌketa domang-antavuioꞌ ooauꞌninge dooreaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Teing ookara Jerusalemaꞌ porouꞌning taꞌninai taaravaara berora onkeonkeꞌauꞌ, Jiisuuꞌ teeꞌ taaꞌniꞌpoi poko. ");
INSERT INTO nas_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Eeꞌnoko teeꞌ nariꞌ dooreai otoroko teinge Boto Keperuuꞌnavitue biiꞌka kareaama aaꞌpauꞌ, “Ooveriaing, niiꞌke matauampimanaꞌ nkoaravaꞌ otong. Ookara nantoonge tee narung siompaamang.” ");
INSERT INTO nas_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Eeꞌnoko teing-kooninge dootuuꞌariiꞌnaang eeꞌdeto Jerusalemaꞌaape nanaakoꞌninge niiꞌning Kirikiꞌ otorokoꞌ tenang paroro nkoaakoꞌnaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eeꞌnoko teing Pilipiꞌanko porouꞌ. Pilipiꞌ Besaida-namono-nung, Kaaleliꞌnameng-koonooꞌnung. Eeꞌnoko teinge aaꞌpauꞌ, “Ee pankaing, niiꞌ Jiisuuꞌ ooampiiꞌnaang piamorimang.” ");
INSERT INTO nas_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Eeꞌnoko Pilipiꞌ Aanduruꞌanko nanura nauvuuꞌ, eeꞌnoko tenaanka Jiisuuꞌanko nanureta nauvuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jiisuuꞌke makuꞌurema aaꞌpuretuꞌ, “Tee bateinang enang tavoꞌaring Kumponinge meenasi pankaing amuainang ning tee Naning-naumpoꞌ Paning-etaing. ");
INSERT INTO nas_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Masikaꞌ naurampemang sinang-koo, uiteꞌnu˜ nau kansiꞌkoo duaꞌaravarura eeꞌnoko booarura, teu nau deempari otopeuꞌ, nka boora deekoꞌ mmauꞌ sinang tavoꞌantavupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tee teeꞌ nariꞌ baa tee naning bakaang domaang baka kirokaiaramaung bakaang domaang tee paaꞌaravaing, teketa baa tee naning anke kansiꞌkoo otoi bakaang domaang siꞌkoo tauraꞌpari otoing tee bakaang domaang pinkaꞌaravaing. Teie tee domaang oparavaung kompuaing. ");
INSERT INTO nas_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Baa tee naning nkaang pakupakunung deemparaaꞌnaang piavora deekoꞌ ning siomuaing. Teeꞌkoo nkaning pakupaku-nupoong niꞌninka oꞌnoriaing ning oꞌnoainooꞌ. Mmaꞌke daangampuainge naning tee ning-koo pakunara deemparavaing.” ");
INSERT INTO nas_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jiisuuꞌke aaꞌpuuꞌ, “Nkaang domang orakaꞌ deeꞌmoing. Aming minkuampainge? Eeꞌ pa minkuamaꞌnaang, ‘Mmaꞌ, aung bateinang ning-anko poaukaꞌ poteveaing?’ Nka teeꞌ deeaꞌ. Ning mouꞌnung enang-koong sisikeera toraꞌpamaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ee Mmaꞌ, nerantaravai dakaang miring pankaing-antararavainaꞌ.” Teeꞌ minkuvuko narung aurong paning-eta karoma aaꞌpuuꞌ, “Ning neramari oꞌnomaꞌnoing, eeꞌnoko napoꞌ teeꞌ nkomaraaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Teinge karingai teꞌ donkonaakoꞌninge tee kara taaravaara aaꞌpauꞌ, “Kurunkurung-pinaꞌ taaravampiring.” Eeꞌnoko niiꞌninge aaꞌpauꞌ, “Tee aaꞌ koosinung˜ tee-anko karoing.” ");
INSERT INTO nas_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Aung kara ninge taaravamaꞌnaang karoaꞌ, diiꞌke taaraveriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Enang bateinang tenang Kumponinge ookara kansiꞌnupoong koosinang nkovuma koompuriainang. Enang eeꞌnang Kumponinge teing kansiꞌnupoong biikaang pankaing turampura bataꞌuaing. ");
INSERT INTO nas_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nantoonge ning taakamaara kansiꞌketa intamaako ookara nantoong baramparampaing ning-anko.” ");
INSERT INTO nas_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Teeꞌ minkuvuma nauvuruꞌ aremuriiꞌ booꞌ toraꞌpuuꞌnaang otoing. ");
INSERT INTO nas_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Eeꞌnoko teinge karingai makuꞌaama aaꞌpauꞌ, “Niikaang boto-koo dariraarie eeꞌ naumurimaung: tee Pakoꞌpariꞌniiꞌ doong kante otoaing. Arekeeꞌ dake enang minkuepeuꞌ daꞌ nauꞌka enang intantaavaing? Daꞌ aming-koo ‘Tee Naning-naumpoꞌ Paning-etaing’ tantaramaung”? ");
INSERT INTO nas_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Ning diiꞌ ninka okiokiꞌnooꞌ oꞌnoritaaꞌ araka-antarampimaang. Ninge mmeꞌ araka-antarampirioꞌ ooveritaaꞌ otoriaing mutaananturiꞌneeng. Aming-koo, nnaꞌ naning tee mutaananooꞌ otomaung noruꞌuaung areꞌaape nanumang. ");
INSERT INTO nas_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Teeꞌkoo ninge araka-antarampirioꞌ masikaꞌantameriaing mmeꞌ taaramerima, diiꞌ sirapoꞌnupoong deentariainaꞌ.” Eeꞌnoko Jiisuuꞌke teeꞌ minkuvura baka nanuuꞌ bakuꞌaritaaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bane aing ookara taaꞌniꞌanta nkovuko ookara-koo dutakanooꞌke, nka masikaꞌantavaavarukoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Teeꞌ teronunge nakaronunge Aisaiaꞌke Daari Meekung-koo daarivuuꞌnaꞌ masikaꞌ deemparuꞌ, aaꞌpuuꞌnaꞌ, “Ovoring ee, kapooꞌ nkoaravaing-koong karantamemaung˜ nantoonge masikaꞌantavaavaukaꞌ, eeꞌnoko dakaang tankaꞌke iirakutai dupe-antaveko ooaara tasiꞌkoo makosiaavaukaꞌ bakei!” ");
INSERT INTO nas_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Teeꞌ eeꞌnaꞌ teinge masikaꞌantavaavarukoꞌnung. Aisaiaꞌke temuriiꞌ aarumo-koo napoꞌ minkuvuuꞌnunge, aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kumponinge biikaang duta mutuu-antavurira biikaang domang ivekaꞌantavuruꞌ aaꞌnoꞌneeng-koo: dutai ooaama domange tasiꞌpaara ning-koo toroariko ninge tamparuꞌantavaramiꞌneeng-koo.” ");
INSERT INTO nas_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiaꞌke tee kara minkuvuuꞌnung Jiisuuꞌ bakaang meenasi oovuraiꞌnange. Teeꞌkoo teeꞌ minkuvuuꞌ Jiisuuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tenang eeꞌnang mmauꞌ Juꞌkoong Ovontung Jiisuuꞌ masikaꞌantavaakoꞌ, eeꞌnoko Boto Keperuuꞌnavitu-koo avoreaama sirapoꞌke minkuaavarukoꞌ tevitue dootuuꞌnava-ita bataꞌaariꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nantoonge daangang-koo piavoroma, Kumponinge daangang-koo piavoroaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jiisuuꞌke aaꞌnaꞌ karoma aaꞌpuruꞌ, “Baa tee ning masikaꞌantamumaunge ning narung masikaꞌantamuaung, teie tee ning botomuuꞌnung nariꞌ masikaꞌantavumaunge. ");
INSERT INTO nas_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Baa tee ning oomumaung tee ning botomuuꞌnung napoꞌ oovumaunge. ");
INSERT INTO nas_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ning kansiꞌkoo mouꞌ araka-pinaꞌ. Eeꞌnoko ookara nantoong ning masikaꞌantamaamaing mutaanang-koo otoroaukaꞌnunge. ");
INSERT INTO nas_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Baa tee nkaang kara taaravuma masikaꞌantavuaung ninge tuumpiampaukaꞌnung. Ning mouꞌnung tuumpiaramparooꞌnaang, teka domang-antavaramaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Baa tee ning tontaꞌmumaung eeꞌnoko nkaang kara masikaꞌantavuaung, tee naning bakaang tuutunang˜ otoꞌevung-tee kara ninge minkuansing bakaang tuutunang-nko otoaing teꞌmung doong asiꞌnooꞌnaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Teeꞌkoo eeꞌnaꞌkoo ninge ninka tamung minkuampaꞌ, teie Mmaꞌke ning botomuuꞌnunge mooꞌnaang napoꞌ botomuuꞌ naurampiiꞌnaang teeꞌ naurampirinaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Eeꞌnoko noruꞌansi oꞌnong bakaang botoi domaang oparavaukaꞌnung tavoꞌumaung. Ninge kapooꞌ minkuamaung tee eeꞌnaa Mmaꞌke naumuuꞌnung minkuamaung.” ");
INSERT INTO nas_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aung aaꞌ tee enang koreꞌnooꞌnaꞌmung Baariꞌkoong˜ Paroro-koo. Jiisuuꞌke noruꞌuuꞌ bakaang doong makotuioꞌ aung-eta kansiꞌketa tenkenuainooꞌ Bauma-anko nanuuꞌnaang. Teie kansiꞌkoo otoitaaꞌ bakaning doong kante piaavurikoꞌ bera bouꞌnaꞌmung-koo basinooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Eeꞌnoko Jiisuuꞌ niiꞌ bakaning barevare-nupoong ninka taamang-koo baꞌnamariruꞌ. Eeꞌnoko Sietaniꞌke Judasi Kerioꞌnung, Saimoniꞌ bauring, tero maamu-antavuuꞌ Jiisuuꞌ sivuuꞌnaang kare-nupoong-koo. ");
INSERT INTO nas_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jiisuuꞌke koontoꞌ noruꞌuuꞌ Baumai iirakuta ookara kapooꞌkoo makosinaꞌ avuuꞌnung, eeꞌnoko noruꞌuuꞌ Kumponing-eta pouꞌnung, eeꞌnoko napoꞌ Kumponing-anko toroaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eeꞌnoko tee, Jiisuuꞌke taamang bantoꞌniiꞌ sipura daaꞌaruꞌ, eeꞌnoko bakaang mononopaꞌ kiruꞌarara tauro meuꞌke kapeto tokoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eeꞌnoko ntong diisi-koo kooꞌuraiꞌnange niiꞌ niikaang kauꞌ duuꞌ tutumuruꞌ. Eeꞌnoko napoꞌ teie tauroi tokoaruꞌnunge piuꞌmuruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Eeꞌnoko tee Jiisuuꞌ Saimoniꞌ Piita-anko basiarako Piitai aaꞌpuuꞌ, “Ovoring, nkaang ee kauꞌ duuꞌmeeꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Dake enang kapooꞌ noruꞌeaꞌ nkoamaaꞌnomaung. Damaꞌke noruꞌeaing.” ");
INSERT INTO nas_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Eeꞌnoko Piitai aaꞌpuuꞌ, “Dake nkaang kauꞌ koontoꞌ duuꞌmeaukaꞌnung.” Eeꞌnoko Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Daꞌ ninge duuꞌdamparuko deekoꞌ nkaning-koong barevare-nupoong-koong deentaravaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Eeꞌnoko Saimoniꞌ Piitai aaꞌpuuꞌ, “Ovoring, nkaang kauꞌ narung duuꞌmeaukaꞌnung, bireng duuꞌmeainge; boreꞌ duuꞌmeainge.” ");
INSERT INTO nas_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jiisuuꞌke aaꞌpuuꞌ, “Naning tee mono duuꞌparinung ookara mono kiiroraaꞌaring. Napoꞌ duuꞌparavaung. Bakaang kauꞌ narung duuꞌparavaing. Diiꞌ kuꞌmiꞌdoriaꞌ, nka ookara deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jiisuuꞌke tero noruꞌuuꞌ tee naning kare-nupoong-koo sivuainung. Teeꞌkoo eeꞌnaꞌkoo aaꞌpuuꞌ, “Diiꞌ ookara kiiroraaꞌdariri otoriaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Eeꞌnoko Jiisuuꞌke kauꞌ duuꞌ bakemuriraiꞌnange Jiisuuꞌ mononopaꞌ napoꞌ siparara bakanooꞌ taamantoma toroaruꞌ. Teka Jiisuuꞌke niaꞌmurima aaꞌmuruꞌ, “Diiꞌke ee noruꞌeri otong tee kapooꞌ nkorampiring? Tasiꞌperinge? ");
INSERT INTO nas_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Diiꞌke ning Nau-anta eeꞌnoko Ovoring tammerimaung. Ning tee eeꞌnara. Tampaꞌ miring tammerimaung. ");
INSERT INTO nas_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ning diikaang Ovoring, eeꞌnoko Nau-anta eeꞌnoko ninge eeꞌnarai kauꞌ duuꞌdampiring. Diiꞌ teeꞌ napoꞌ boonko noruꞌdariri pakureeriainge. ");
INSERT INTO nas_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aung diiꞌ nau-anta-koo teeꞌ nkorampiring diiꞌ pakureeriiꞌnaang pakurampirinaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Masikaꞌ naurampimang, naning botovotonaaꞌ bakaang pankaing-koo dau basi deeaꞌ, eeꞌnoko naning kara-okovui-nka tee botovuuꞌnung-koo dau basi deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Aung kara taaraveriraiꞌnange teeꞌ nkoverima biraanke-nupoong otoriaing. ");
INSERT INTO nas_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ninge diiꞌ ookara koontoꞌ naurampiaꞌ. Ninge barearantuꞌning noruꞌaransi oꞌnong. Eeꞌnoko aung Daari Meekung nauꞌka masikung deemparaaꞌnaang aaꞌpumaung, ‘Teie naninge nariꞌ taamanampemaunge tamaavaꞌnaang simuuꞌ.’ ");
INSERT INTO nas_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Enang naurampimang mmeꞌ nkoaravaruko diiꞌke masikaꞌantameriiꞌnaang ning tee eeꞌnara pankaing tenang nkoaravainang. ");
INSERT INTO nas_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Masikaꞌ naurampimang, baa tee ninge botoampainung onkeonkeꞌuaing tee ning napoꞌ onkeonkeꞌmuaing. Eeꞌnoko naning tee ning onkeonkeꞌmuaing tee ning botomuuꞌnung onkeonkeꞌuainge.” ");
INSERT INTO nas_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Teketa Jiisuuꞌke teeꞌ minkuvuraiꞌnange domang orakaꞌ deeꞌouꞌ, eeꞌnoko siraꞌpui naumurima aaꞌmuruꞌ, “Ninge masikaꞌ naurampimang diiꞌ, narunge diiꞌkoonge tooka kompui ning kare-nupoong-koo simuaing.” ");
INSERT INTO nas_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jiisuuꞌke teeꞌ minkuvuioꞌ niiꞌ niiꞌka ooꞌoomeeruꞌ avitoitoi noruꞌampima, miruꞌnooꞌ besiꞌampima. ");
INSERT INTO nas_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ning˜ Jiisuuꞌkoo dueꞌ baꞌnamarakoꞌ baꞌmaikoꞌ deemaritaaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Eeꞌnoko Saimoniꞌ Piitai birenge pinkaꞌmuma aaꞌmuuꞌ, “Niaꞌeai tee baa teeꞌ minkuvumaang.” ");
INSERT INTO nas_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Teeꞌ niaꞌmuko Jiisuuꞌanko diiriꞌmarara niaꞌantuꞌ, aaꞌpama, “Ovoring, tee baa eeꞌnara?” ");
INSERT INTO nas_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jiisuuꞌke makuꞌmuma aaꞌmuuꞌ, “Ninge navioꞌ duuni-koo iimpamira tee avompainung, tee eeꞌnara tee naning.” Enang teeꞌ minkuvura navioꞌ nkavura iimpura Judasi avuuꞌ, Saimoniꞌ Kerioꞌnung bauring. ");
INSERT INTO nas_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Eeꞌnoko Judasie tevioꞌ kompuko Sietaniꞌ namuꞌke tumparuꞌ Judasi-koo kuung. Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Kapooꞌ nkoveainung iriꞌnarung nkoveaing.” ");
INSERT INTO nas_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Teeꞌ minkuvuuꞌnung-koong miruꞌnooꞌ niiꞌke taamantomai baꞌnamariri oꞌnorikoꞌninge noruꞌampiaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Niiꞌninge aaꞌpauꞌ, “Tee Judasie kapooꞌ mooꞌuuꞌnaang paroro-koo makosi Jiisuuꞌke teeꞌ minkuvumaang,” Judasie mooniꞌkoonaraꞌ bakura-naraꞌ tarevukoꞌnung-koo. Eeꞌnoko niiꞌninge eeꞌ noruꞌauꞌ, “Tee Jiisuuꞌke botovuing sitovuruꞌnuka kapooꞌ avuriiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasie tevioꞌ nkavura namuꞌke siaruꞌ, tenang muunga. ");
INSERT INTO nas_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Teketa Judasi tenkenuioꞌ Jiisuuꞌke aaꞌmuruꞌ, “Enang ning Tee Naning-naumpoꞌ Paning-etaing nkaang meenasi siraꞌpari otong, eeꞌnoko Kumponing bakaang meenasi ning-koo siraꞌpari otong. ");
INSERT INTO nas_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ninge Kumponinge pankaing-antavansioꞌ teie ning napoꞌ bakaang meenasi amura pankaing-antamuuꞌnaang. Eeꞌ, emuꞌ dueꞌka teeꞌ nkomuaing. ");
INSERT INTO nas_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nnurukaaꞌ ee, ning diiꞌ ninka baruꞌ pankaroong oꞌnoriaukaꞌnung. Diiꞌke damaꞌke besiꞌmeriaing, eeꞌnoko Juꞌkoong ovontung nauarantuꞌnaꞌ enang naurampimang, ning nanampainooꞌ diiꞌ poriarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nerakung boto arompimaang: Piaareeriaing diiꞌka. Teeꞌ ninge diiꞌ piaarampimanaꞌ diiꞌka piaareeriaing. ");
INSERT INTO nas_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Diiꞌke diiꞌka teeꞌ piaareeriko ookara nantoonge tasiꞌdaaripeuꞌ diiꞌ nkaning barevare-nupoong.” ");
INSERT INTO nas_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Teketa Piitai aaꞌpuuꞌ, “Ovoring, areꞌaape nanimang?” Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Dake ning siomearupeuꞌ enang nanamatomanooꞌ, nka damaꞌ niiꞌnang siomeriaing.” ");
INSERT INTO nas_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piitai niaꞌuma aaꞌpuuꞌ, “Aming-koo ninge siontamparupeuꞌ enang? Ning daꞌ ninka booꞌkoo makotunsi oꞌnong.” ");
INSERT INTO nas_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Daꞌ ee koontoꞌ ning-koo booꞌkoo makosi? Bakei koontoꞌ masikaꞌ nauramaang, kokoreeꞌ mmeꞌ kooꞌkuaruko daꞌ beemuꞌpie penkentaravaing niꞌninka nariꞌ oꞌnoremaung-koo.” ");
INSERT INTO nas_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jiisuuꞌke aaꞌmuruꞌ, “Domang orakaꞌ deeꞌdoriaukaꞌ. Kumponing masikaꞌantaveriaing, eeꞌnoko ning masikaꞌantameriainge. ");
INSERT INTO nas_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mmaꞌ bakanava-koo avatevaro otong. Ninge otoriainooꞌ neriampaing. Teeꞌ naurampiarupeuꞌ tosi dei. ");
INSERT INTO nas_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Diiꞌ otoriainooꞌ osi neri bakeamira napoꞌ toromaravaing, eeꞌnoko ning-anko poꞌantarampiaing teꞌ ning oꞌnoainooꞌ diiꞌ otoriainaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Diiꞌke noruꞌeri otong nanampainooꞌ eeꞌnoko teꞌ basiraripeuꞌnaꞌ noruꞌeri otong.” ");
INSERT INTO nas_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomasie aaꞌpuuꞌ, “Ovoring, niiꞌke noruꞌampiaꞌ teꞌ daꞌ naniainooꞌ. Arekeeꞌ noruꞌampipeuꞌ taung teꞌ tavoꞌmaripeuꞌnavung?” ");
INSERT INTO nas_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jiisuuꞌke aaꞌpuuꞌ, “Ning tee eeꞌnara taung masikung, kara masikung okovenung eeꞌnoko domaang okovenunge ning eeꞌnara. Naning Mmaꞌanko bearupeuꞌ baka. Ninge deekoꞌ tavoꞌantavampeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Diiꞌke ning noruꞌmeri dei Mmaꞌ noruꞌeripeuꞌ; enang-eta noruꞌering, eeꞌnoko ooveringe.” ");
INSERT INTO nas_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipiꞌke aaꞌpuuꞌ, “Ovoring, Dauma naumeriaing ooampiainaꞌ. Tee narung oo-koo piamorimang.” ");
INSERT INTO nas_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jiisuuꞌke aaꞌpuuꞌ, “Ning pankaroonge diiꞌ ninka oꞌnoruꞌ. Arekeeꞌ, Pilipiꞌ, dake ning ee mmeꞌ noruꞌmeaꞌ? Naninge ning oomuuꞌnunge Mmaꞌ oovuuꞌnung. Aming-koo dake aaꞌpemaang, ‘Dauma naumeriai?’ ");
INSERT INTO nas_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Aiꞌ daꞌ masikaꞌantaveaꞌ ee, Pilipiꞌ, ning Mmaꞌkoo oꞌnomaung eeꞌnoko Mmaꞌ ning-koo otomaunge? Eeꞌnoko teing kara naurampimatoining ning-eta poaꞌ. Mmaꞌketa eeꞌnara-ita pomaung. Mmaꞌke ning-koo otomaunge bakaang nko-nko nkovumaung. ");
INSERT INTO nas_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Masikaꞌantameriaing ning Mmaꞌkoo oꞌnong eeꞌnoko Mmaꞌ ning-koo otong. Makotuaung deekoꞌ masikaꞌantameriaing aing-koo nko-nkoning-koo. ");
INSERT INTO nas_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Masikaꞌ naurampimang, baa tee ning masikaꞌantamumaung ninge nko-nko nkoamaung nkovuaing. Eeꞌ, nko-nkonanka pankainanka nkoansing-koo dau basi pankaing nkovuainge, ning Mmaꞌanko nanampaing-koo. ");
INSERT INTO nas_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eeꞌnoko kapooꞌ nkaang miring-koo niaꞌmeriaing nkoampaing, Kumponinge bakaang meenasi siraꞌantavuainaꞌ ning-koo Bauring-koo. ");
INSERT INTO nas_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kapooꞌ nkoamaꞌnaang niaꞌmeriaing nkaang miring-koo nkoampaing.” ");
INSERT INTO nas_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Diiꞌke ning piaameritaaꞌ nkaang boto siomperiaing. ");
INSERT INTO nas_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ninge Mmaꞌ niaꞌampaing niiꞌnung domang kuaaꞌanta diiꞌanko botovuaing, Tanuaang Meekung eeꞌnara, kara masikung tanata, diiꞌ ninka doong kante otoriainaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Teinge tamung kansiꞌkoo otoromainge nkavaavarupeuꞌ, ooaavarura noruꞌaavaung-koo. Teka diiꞌke tee noruꞌeri otong, aiꞌ tee diiꞌ ninka otorimaung-koo; eeꞌnoko diikaang domang-koo otoi otoaing. ");
INSERT INTO nas_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ninge diiꞌka maantuaaraꞌnuka-pinaꞌ siꞌdampiaukaꞌnung. Napoꞌ toromaravaing diiꞌanko. ");
INSERT INTO nas_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Okiꞌnooꞌ batei tankinuko tamung kansiꞌkoo otoromainge oomaavaukaꞌnung eeꞌnoko diiꞌke oomeriaing. Eeꞌnoko ning domamari oꞌnomaꞌnoaing-koo diiꞌ napoꞌ domantariri otoriainge. ");
INSERT INTO nas_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Teꞌmung eeꞌnaꞌmung diiꞌke noruꞌmeriaing ning Mmaꞌkoo oꞌnong eeꞌnoko diiꞌ ning-koo otoring teeꞌ ning diiꞌkoo oꞌnomanaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Baa tee nkaang boto arooꞌuma siompumaung tee eeꞌnara naning ning piaamumaung. Eeꞌnoko baa tee naning ning piaamumaung Mmaꞌke piaavuainge. Eeꞌnoko ninge piaavampainge. Eeꞌnoko ning ninka siraꞌmaravainge tee-koo.” ");
INSERT INTO nas_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judasi, Kerioꞌnunge deeaꞌ, aaꞌpuuꞌ, “Ovoring, aming-koo niiꞌkoo naing-koo oroꞌdaravainge eeꞌnoko ookara kansiꞌkoo-nupoong-koo deeaꞌ?” ");
INSERT INTO nas_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Baa tee naning ning piaamumaung nkaang boto siompuaing. Eeꞌnoko Mmaꞌke piaavuainge. Mmaꞌ eeꞌnoko ning mereaing tee-anko; tee ninka oꞌnoriaing. ");
INSERT INTO nas_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Baa tee ning piaamuaung, teie tee nkaang kara meumpuaukaꞌnung. Eeꞌnoko tee kara minkuanko taaraverimaung nkaang deeaꞌ, Mmaꞌ tee ning botomuuꞌnung bakaang. ");
INSERT INTO nas_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Enang aing kapooꞌnanka ninge mmeꞌ diiꞌ ninka oꞌnoritaaꞌ naurampimaing. ");
INSERT INTO nas_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Teka damaꞌke teie Domang Kuaaꞌantai, Tanuaang Meekunge, Kumponinge diiꞌanko botovuainunge nkaang miring-koo, ookara kapooꞌ nau-antaruriaing, eeꞌnoko noruꞌantaruriainge napoꞌ ookara kapooꞌ ninge naurampiruꞌning. ");
INSERT INTO nas_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Tampara, otoriko. Tampara masikung, nkaang mooa koontoꞌ masikung arompimaang. Avitoitoi noruꞌdariaꞌ eeꞌnoko aroreriaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Diiꞌke taaramering ninge aaꞌpanko, ‘Ninge diiꞌ siꞌdampiaing nka napoꞌ toromaravaing diiꞌanko.’ Diiꞌke ning piaamerimaung dei doturoturaripeuꞌ ning Mmaꞌanko nananko, tee-anko ning-koo dau basi-anko. ");
INSERT INTO nas_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ninge enang naurampiring mmeꞌ nkoaravaruko masikaꞌantameriiꞌnaang nkoaravainaꞌmung. ");
INSERT INTO nas_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Diiꞌ ninka ning baruꞌ pankaroong minkumariaukaꞌnung. Aming-koo, nnaꞌ Sietaniꞌ pomaang, tamung kansiꞌkoo otoromaing biikaang pankaing. Nka tee nkaang pankaing deeaꞌ. Komaaru˜ oꞌnoaꞌ baramupeuꞌnung-koong. ");
INSERT INTO nas_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Teka pora paaramuko taraꞌmoaꞌ taaravampaing ookara kansiꞌnupoonge tasiꞌpaavainaꞌ ninge Mmaꞌ narung piaavamaung, eeꞌnoko Mmaꞌ narung bakaang pia keperuuꞌmari siompamaung. Aiaꞌ, daaꞌdarira danto meriai.” ");
INSERT INTO nas_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ning uaini masikung, eeꞌnoko Mmaꞌ uaini tarenara. ");
INSERT INTO nas_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Teie ning-koong kaumpeꞌ ookara tootoꞌumaung teing sinang biꞌuriaing. Sinang biꞌumaing kaumpeꞌnanka nerivumaung niiꞌning napoꞌ mmauꞌ sinang biꞌuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Diiꞌ enang kiiroraaꞌdariri otoring nkaang kara naurampimaunge nerirurioꞌ. ");
INSERT INTO nas_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ning-koo otoriaing, eeꞌnoko ning diiꞌkoo oꞌnoainge. Diiꞌke sinang nkaveriarupeuꞌ ning-koo otoriarura, kaumpeꞌke sinang nkavuarupeuꞌnaꞌ koiꞌkoo otoarura. ");
INSERT INTO nas_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ning uaini eeꞌnoko diiꞌ kaumpeꞌnanka. Baa tee ning-koo otomaung eeꞌnoko ning tee-koo oꞌnomaung mmauꞌ sinang nkavuaing. Diiꞌke kapooꞌ nkoveriarupeuꞌ ning-eta taapoꞌ otori. ");
INSERT INTO nas_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Naning tee ning-koo otoaung Kumponinge kaumpeꞌpinaꞌ duaꞌuaing, maraꞌoainooꞌ. Kaumpeꞌ teeꞌ oroꞌnanka oosiaarima ntaꞌkoo duaꞌnumpoꞌ paroꞌdoma. ");
INSERT INTO nas_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Diiꞌ ning-koo otori dei, nkaang kara diiꞌkoo otoi dei kapooꞌ niaꞌmeriko diiꞌ piaroripeuꞌning diiꞌ otoꞌderuripeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Teeꞌ eeꞌnaꞌ Mmaꞌnung meenasi siraꞌparamanaꞌ diiꞌke sinang mmauꞌ nkaverioꞌ. Eeꞌnoko teeꞌ nariꞌ nkaning barevare-nupoong deentariri otoriaing. ");
INSERT INTO nas_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ninge diiꞌ piaarampimaang Mmaꞌke ning piaamumanaꞌ. Nkaang piaa-koo otoriaing. ");
INSERT INTO nas_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nkaang boto siomperi diiꞌ nkaang-koo piaa-koo otorimaatoaing. Teeꞌ nariꞌ Mmaꞌnung boto siompansi bakaang-koo piaa-koo oꞌnomanaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ninge teeꞌ naurampimang nkaang doturotu diiꞌkoo otooꞌnaang, eeꞌnoko diiꞌ aaꞌnaꞌ bakei dotue maantoꞌduriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nkaang boto aung, ‘Diiꞌka pakureeri piaareeriaing teeꞌ ninge piaarampimanaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Naning booꞌpari dei baꞌmaikoriꞌ paari-antavuri pakuvurima, niiꞌnung aarumo otoaꞌ piaa-koong temuriiꞌ puruꞌui otoing. ");
INSERT INTO nas_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eeꞌnoko diiꞌ ninge mmaikoriꞌ, kapooꞌ ninge botorampiring nkoveriaing deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Diiꞌ ninge botovotonaaꞌnuka tantampiaukaꞌnung enang-eta deto, aiꞌ botovotonaaꞌnukai noruꞌaavaung kapooꞌ biikaning ovontunge nkoaamaing. Botovotonaaꞌnanka-ita mmaikoriꞌ tantampimaung kapooꞌ ookara naurampiruꞌnung-koo Mmaꞌketa taaravantuꞌning. ");
INSERT INTO nas_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Diiꞌke ning miruꞌmeriaꞌ, ninge diiꞌ miruꞌdampiruꞌnung eeꞌnoko ninge barerampiruꞌ berira sinang mmauꞌ nkaveriiꞌnaang, temuriiꞌ sinang doong kante otomatoaing. Eeꞌnoko Mmaꞌke aruriaing kapooꞌ nkaang miring-koo niaꞌeriaing. ");
INSERT INTO nas_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Aung eeꞌnara boto ninge naurampimang, ‘Diiꞌka piaareeriaing.’” ");
INSERT INTO nas_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kansiꞌnupoonge munteꞌdaariko eeꞌ noruꞌeriaing, ning teeꞌ eeꞌnaꞌ tero munteꞌmauꞌnunge. ");
INSERT INTO nas_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eeꞌnoko diiꞌ teing-kooning dei teinge navuraaripeuꞌ biikaning-pinaꞌ. Eeꞌnoko diiꞌ ninge meekaꞌantarampirioꞌ teing-pinaꞌ deeaing deentariruꞌ, eeꞌnoko diiꞌ teing-kooning deeaꞌ. Teeꞌkoo eeꞌnaꞌkoo teinge diiꞌ munteꞌdaarimaung. ");
INSERT INTO nas_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Noruꞌeriaing kapooꞌ ninge naurampiring, aaꞌdampiring, ‘Naning botovotonaaꞌ bakaang pankaing-koo dau basi deeaꞌ.’ Teinge ning tooꞌdemauꞌnung deemparako napoꞌ diiꞌ teeꞌ tooꞌdentaariainge. Eeꞌnoko teinge nkaang kara taaravauꞌnung dei diikaang kara taaravaapeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Teinge tee naning botomuuꞌnung noruꞌaavaꞌ, teeꞌkoo teeꞌ nkoraariaing diiꞌ nkaning deentariko. ");
INSERT INTO nas_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ninge moraiꞌnange kara nauaranko beiꞌbeiꞌmaavaruꞌnung dei naninge biikaang aarumo orara tampuarupeuꞌ. Nka tampaꞌ siraꞌmarioꞌ beiꞌbeiꞌmaama biikaang orara aarumo bakuꞌkoo makosiaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Baa tee ning munteꞌmumaung Mmaꞌ munteꞌumaunge. ");
INSERT INTO nas_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Teinge oomaioꞌ kapooꞌnanka nkoankoꞌnung niiꞌnung naninge tero nkovuarukoꞌning. Teeꞌ nkoaravarui dei naninge biikaang aarumo orara tampuarupeuꞌ. Nka niiꞌnaꞌ nkoaring-koo biikaang aarumo bakei orara masikung siraꞌpari otong, kapooꞌnanka nkoankoꞌning ooaara neeꞌdaang ookakang munteꞌmaaremaung-koo. ");
INSERT INTO nas_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nka teeꞌ nariꞌ nkoaravaing biikaang boto-koong daari masikaꞌ tavoꞌaravainaꞌ, aaꞌpumaung, ‘Teinge tamung munteꞌmauꞌ.’ ");
INSERT INTO nas_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Tee Domang Kuaaꞌanta poaing. Tee eeꞌnara Tanuaang Meekung, kara masikung tanata, Mmaꞌketaing. Mmaꞌankoita ninge botoampaing, eeꞌnoko teie ning-koo kara masikung siraꞌpumaatoaing. ");
INSERT INTO nas_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Eeꞌnoko diiꞌke teeꞌ napoꞌ ning-koo kara masikung minkuerimatoainge niꞌninka teroita oꞌnoruꞌninge.” ");
INSERT INTO nas_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ninge teeꞌ naurampiring diiꞌ duaꞌdariꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Biikaning dootuuꞌnavananka-ita bataꞌdaariaing; eeꞌ, bakei, doong poaining-koo Kumponing dotu-anta tampaama dupisiꞌraariainge. ");
INSERT INTO nas_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Teinge ning eeꞌnoko Mmaꞌ noruꞌmaarearuta diiꞌ teeꞌ nkoraariaing. ");
INSERT INTO nas_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aung tee ninge uroꞌke naurampiring teing kapooꞌnanka basiaravaining. Eeꞌnoko tenang teeꞌ oroꞌ aarumo diiꞌkoo teinge nkoaako, diiꞌke tenang norunoruꞌeriaing tee aung kara ninge naurampimatomaung. Ninge tee tero naurampiaruuꞌnung aung kapooꞌnanka ning diiꞌ ninka oꞌnoritaaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Teka enang ning nanamang teꞌ naning-anko botomuuꞌnung-anko. Nka diiꞌkoo narung otoaꞌ ning niaꞌmema aaꞌmupeuꞌnung, ‘Areꞌaape nanimang?’ ");
INSERT INTO nas_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Eeꞌnoko ninge enang diiꞌ naurampiring-koo diiꞌ peeꞌdunsie maantoꞌduring. ");
INSERT INTO nas_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ninge masikaꞌ naurampimang, Bakei koontoꞌ tampaꞌ masikaꞌ diiꞌkoo, ning anketa tenkenampaing-koo. Ning tenkenamparuko deekoꞌ tee Domang Kuaaꞌanta diiꞌanko poarupeuꞌ. Eeꞌnoko ning tenkenampaing deekoꞌ naurampirinaꞌ, tenkenamira Domang Kuaaꞌanta diiꞌanko botoampaing. ");
INSERT INTO nas_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Eeꞌnoko teie poraiꞌnange ookara nantoonanka-koo okoꞌbosiꞌarioꞌ orakaꞌ nkoarimanooꞌ tasiꞌantavuriaing aing aaꞌning nauvurima: orara aarumo, tampara aarumo eeꞌnoko aarumo simpeꞌ nkonaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Teie nauvuriaing biikaang aarumo orara-koo okoꞌbosiꞌnooꞌ tee teinge ning Tee Pakoꞌpariꞌniiꞌ masikaꞌantamaavaruuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Teie tampara aarumo nauvuriaing ning pariꞌantanunge, ning Mmaꞌanko nananko oomeriaukaꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Napoꞌ nantoong simpeꞌuriainaꞌ nauvuriainge tamung kansiꞌkoo otoromaing biikaang pankaing tuutunang˜koo duaꞌaruꞌnaꞌ nauvurima. ");
INSERT INTO nas_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ninge mmauꞌ naurampipeuꞌning otoꞌmemung. Nka tee, tee kara baruꞌ aaꞌnaꞌ ivekung, enang tampaꞌ noruꞌeriarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nka tee, Tanuaang Meekunge kara masikung tanatai poraiꞌnange masikung kara ookara taara-antaruriaing. Baka karoaukaꞌnunge, nka kapooꞌ taaravuaining naururiaing eeꞌnoko kapooꞌ tavoꞌaravainanka minkuvuainge. ");
INSERT INTO nas_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Teie ning daangamuaing. Nkaang meenasi diiꞌ naururiainge. ");
INSERT INTO nas_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ookara kapooꞌ Mmaꞌ otoꞌevumaing ning nkaning. Teeꞌkoo eeꞌnaꞌkoo teeꞌ naurampimang Tanuaang Meekunge nkaang meenasi diiꞌ naururiaing.” ");
INSERT INTO nas_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ning okiꞌnooꞌ batei tankinuko damaꞌ oomeriaukaꞌnung, eeꞌnoko napoꞌ damaꞌke okiꞌnooꞌ batei otorira oomeriaing.” ");
INSERT INTO nas_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Niiꞌke niiꞌninge Jiisuuꞌ bakaninge barevare-nupoonge niiꞌka nianiaꞌ niaꞌmeerima aaꞌmeerikoꞌ, “Aung kara miruꞌnooꞌ aming? Eeꞌ naumurimaꞌnomaung, ‘Okiꞌnooꞌ batei tankinuko damaꞌke napoꞌ oomeriaukaꞌnung, eeꞌnoko napoꞌ okiꞌnooꞌ batei tankinuko damaꞌke oomeriaing.’ Eeꞌnoko napoꞌ aaꞌmurimaung, ‘Ning Mmaꞌanko nanampaing.’ ");
INSERT INTO nas_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tee aung miruꞌnooꞌ ‘okiꞌnooꞌ’ aming? Niiꞌke noruꞌampiaꞌ aming teeꞌ minkuvuinge.” ");
INSERT INTO nas_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Eeꞌnoko niiꞌke niaꞌampiiꞌnaang piamoriko Jiisuuꞌke noruꞌura aaꞌmuruꞌ, “Ninge aaꞌpamaang, Okiꞌnooꞌ tankinuko diiꞌke oomeriaukaꞌnung, eeꞌnoko damaꞌ napoꞌ okiꞌnooꞌ tankinuko diiꞌke napoꞌ oomeriaing. Aung teeꞌ minkuansing tee diiꞌka ee tanaꞌdeerimaang? ");
INSERT INTO nas_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Masikaꞌ naurampimang diiꞌ birontariaing orarunsirarima, eeꞌnoko tamung kansiꞌkoo otoromaing doturotuariaing. Bane diiꞌ orarunsirarira diikaang orarunsi doturotu-koo toroaravaing. ");
INSERT INTO nas_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Naning manikuma tootoꞌ paravuainooꞌ noruꞌuma orakaꞌ deeꞌong, bakaang doong sisikeeravoainaꞌmung dueꞌuko. Nka tee tootoꞌ paravura teni sisikeera ampaꞌopeuꞌ, aaꞌnaꞌ doturotuaritaaꞌ otopeuꞌ tootoꞌ pontoꞌaring-koo. ");
INSERT INTO nas_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Teeꞌ nariꞌ diiꞌkoo nkoaravaing. Enang diiꞌ orarunsirarimang eeꞌnoko ninge diiꞌ damaꞌke oorampiaing, eeꞌnoko diikaang tunsi doturotue maantoꞌuaing. Naninge teꞌnempuaukaꞌnunge tee doturotu diiꞌketa. ");
INSERT INTO nas_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Eeꞌnoko tenang doong basiaravainang ning kapooꞌkoo niaꞌmeriaukaꞌnung. Masikung naurampimang, diiꞌ nkaning barevare-nupoong deentariko Mmaꞌke ookara kapooꞌ aruriaing niaꞌeriaining. ");
INSERT INTO nas_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Diiꞌke mmeꞌ kapooꞌkoo niaꞌeriaꞌ nkaang miring-koo. Niaꞌerira komperiaing diiꞌ dotue maantoꞌduriainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ninge aung minkunaananka diiꞌ kara mirumiruꞌke naurampimaung. Nka batei pomaang aunge eeꞌ oroꞌke karai karompaukaꞌnang. Tenang ninge kara siraꞌpansi minkuampaing Mmaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Teꞌmung tavoꞌaravainaꞌmung nkaang miring-koo niaꞌeriaing. Eeꞌnoko ninge eeꞌ minkuampaꞌ ninge Mmaꞌ niaꞌderompiaing, teeo Mmaꞌke baka piaarurimaung-koo; ");
INSERT INTO nas_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Diiꞌke ning piaamerimaung eeꞌnoko masikaꞌantamerimaung ning Kumponing-ankoita mouꞌnung, teeꞌkoo Mmaꞌke piaarurimaung. ");
INSERT INTO nas_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Masikung, ning Mmaꞌankoita mouꞌ aaꞌ kansiꞌkoo, eeꞌnoko ning enang kansiꞌ sipamang, Mmaꞌanko nanama.” ");
INSERT INTO nas_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Eeꞌnoko niiꞌke bakaning barevare-nupoonge aaꞌpampiruꞌ, “Ee aung, daꞌ enang bakei siraꞌpei minkuemaang. Kara mirumiruꞌ minkueaꞌ otong. ");
INSERT INTO nas_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Niiꞌke enang daꞌ noruꞌdampiring dake kapooꞌ ookara noruꞌei otong, bane niiꞌninge nianiaꞌ niaꞌdaavaruko noruꞌepeuꞌ. Teeꞌkoo eeꞌnaꞌkoo daꞌ niiꞌke masikaꞌantarampimaang daꞌ Kumponing-ankoita pouꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jiisuuꞌke makuꞌmurima aaꞌmuruꞌ, “Ekee, enang asiꞌ masikaꞌantameri! ");
INSERT INTO nas_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nka tee bateinang dueꞌumaang, diiꞌ ookara aroreritaaꞌ avitoitoi kooꞌdariainang, eeꞌnoko ning ninka oꞌnoaing. Nka bakei ning ninka oꞌnoaukaꞌnung, Mmaꞌ niꞌninka oꞌnoremaung-koo. ");
INSERT INTO nas_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ninge diiꞌ naurampiring diiꞌ mooa-poꞌnupoong deentariiꞌnaang ning-koo otoritaaꞌ. Kansiꞌkoo otoritaaꞌ poreꞌdoriaing. Nka domang purintariaing, ninge ookara kansiꞌpoꞌ kuung deempansing-koo.” ");
INSERT INTO nas_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jiisuuꞌke teeꞌ minkuvuraiꞌnange paning-aape ankamparara aaꞌpuuꞌ, “Mmaꞌ ee, tee bateinang poing. Ning dauring meenasi ameaing napoꞌ ninge dauringe meenasi arompainaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Iirakuta ameuꞌ nantoong ookara tanata-koong ninge domaang oparavaukaꞌnung avoromaꞌnaang ookara nantoong-koo dake ameuꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Domaang oparavaukaꞌnupoong aing: Daꞌ Kumponing masikung noruꞌdaamaing, niiꞌnung otoaꞌ, eeꞌnoko teinge dake botomeuꞌnaꞌ noruꞌmaamaing ning tee Pakoꞌpariꞌniiꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kansiꞌkoo oꞌnoitaaꞌ dakaang meenasi sirakaꞌantavansi oꞌnoing. Dakaang nko-nko opansing nkoamaꞌnaang ameuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Enang tee Mmaꞌ, pora pankaing-antamei nerameaing tero kansiꞌ otoaruko daꞌ ninka oꞌnoresi nerameuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Teing-koo nantoong-koo dake tero kansiꞌketa ameuꞌning-koo ookara-koo ninge daꞌ tasiꞌantavarantuꞌnung. Teing dakaning deempariri otoroko, dake ning ameuꞌning, eeꞌnoko dakaang kara meumpauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Eeꞌnoko enang teinge noruꞌai otong ookara kapooꞌ dake ameuꞌning eeꞌnoko daꞌankoita pouꞌning. ");
INSERT INTO nas_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ninge tee kara naumeuꞌnung nauaranko tampaꞌ taaravauꞌ, eeꞌnoko sirakaꞌpariri ning tasiꞌmauꞌnung ning tee daꞌankoita mouꞌnung, eeꞌnoko masikaꞌantavaamaung dake ning botomeuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ninge teing pakuaramaꞌnaang eentaramang. Ookara kansiꞌnupoong paku-koo eentamaravaꞌ, teing nantoong dake ameuꞌning-koo naing-koo, dakaning deempariko. ");
INSERT INTO nas_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ookara kapooꞌ nantoong otoꞌmemumaing dakaning, eeꞌnoko daꞌ otoꞌderumaing ning nkaninge. Nantoonge teing ooaara daangamaavaing. ");
INSERT INTO nas_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ning enang daꞌanko momaang. Ning kansiꞌkoo otoꞌkoong deeaꞌ, teeo aing aꞌ kansiꞌkoo otoroko. Mmaꞌ meekung ee, duaꞌariꞌneeng tareveriaing dakaang miring-koonge purintoꞌke, teie eeꞌnarai miring-koo dake ameuꞌnunge, teing narung deempariiꞌnaang neeꞌ narung-pinaꞌ oꞌnoremanaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ning teing ninka oꞌnoritaaꞌ ninge teing tarearansing dakaang miring-koonge purintoꞌke, teie eeꞌnarai miringe dake ameuꞌnunge. Ninge komparansioꞌ naning otoaꞌ paaꞌaruꞌnung, nka tee naning duaꞌniiꞌ tee narung paaꞌaravaing; teꞌkoo Daari Meekung-koong kara masikaꞌparavaing. ");
INSERT INTO nas_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ning enang daꞌanko momaang. Eeꞌnoko ning kansiꞌkoo oꞌnoitaaꞌ aing kapooꞌning minkuamaang teing nkaang doturotu okovuriiꞌnaang, biikaning tunsi teie doturotue maantoꞌuriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ninge dakaang kara avoronko kansiꞌnupoonge munteꞌaaruꞌ, teing kansiꞌnupoong deeaing deempariaruko ning pinaꞌ nariꞌ, aiꞌ ning teie kansiꞌnupoong-koong deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ninge daꞌ niaꞌdampaꞌ kansiꞌnupoong-eta tontaꞌeriiꞌnaang, teka ninge daꞌ tanaꞌdamaang tampaꞌ tareveriiꞌnaang naning orara-koo. ");
INSERT INTO nas_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ning kansiꞌnupoong-koong deeaung-koo teeꞌ nariꞌ nkaning teing-kooning deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Eeꞌnoko teie dakaang karai meekupoong deeng-antaveriaing. Dakaang kara tee masikung ootukunung. ");
INSERT INTO nas_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ninge teing botoaransing kansiꞌnupoong-koo, dake ning botomeuꞌnaꞌ teꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Eeꞌnoko teing noruꞌaransitaaꞌ ninge ninka aromang teing napoꞌ dakaning meekupoong masikeng deempariiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Aing-koo naing-koo eenta nkoampaꞌ eeꞌnoko teing-koo nantoong-koo napoꞌ ning masikaꞌantamaavaining-koo aing biikaang kara taaravaama. ");
INSERT INTO nas_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ning eentamaramaung aing eeꞌnoko teing narung deempariiꞌnaang. Mmaꞌ ee, narung deempariiꞌnaang neeꞌ ninka piamomaang teeꞌ daꞌ ning-koo otomanaꞌ eeꞌnoko ning daꞌkoo oꞌnomanaꞌ. Narung deempariiꞌnaang piamomaang ookara kansiꞌnupoonge masikaꞌantamaavainaꞌ ning dake botomeuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tee eeꞌnara meenasi ameuꞌnung avorontuꞌnung narung deempariiꞌnaang, daꞌ eeꞌnoko ning narung deemaresi oꞌnoremanaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ning teing-koo oꞌnoko eeꞌnoko daꞌ ning-koo otoko teing narung deempariaing koontoꞌ. Eeꞌnoko teeꞌ nariꞌ ookara kansiꞌnupoonge noruꞌaapeuꞌ dake ning botomeuꞌnung, dake piaaverimaung teeꞌ nariꞌ ning piaamemanaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mmaꞌ ee, teing dake ning ameuꞌning niꞌninka oꞌnoriiꞌnaang piamomaang ning oꞌnoainooꞌ nkaang meenasi ooaavainaꞌ tee dake ameuꞌnung. Aming-koo, nnaꞌ dake ning piaameuꞌnung kansiꞌ mmeꞌ nkoaravaruko. ");
INSERT INTO nas_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mmaꞌ ee, daꞌ domang koompari otoꞌ. Tamung kansiꞌkoo otoromainge daꞌ noruꞌdaavaꞌ, eeꞌnoko ninge daꞌ noruꞌdansi oꞌnong, eeꞌnoko ainge noruꞌai otong dake ning botomeuꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ninge daꞌ nau-antavarantuꞌ, eeꞌnoko teeꞌ nariꞌ nkoamaaꞌnoaing piaa pankaing otoꞌevuriiꞌnaang piaa ning-koo otoꞌderumanaꞌ, eeꞌnoko ning teing-koo oꞌnooꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jiisuuꞌ eentavarama teeꞌpuraiꞌnange tenkenampiruꞌ niiꞌ ninka bakaning barevare-nupoong ninka, Kiidironi-nari okiꞌnari tankimpampiri. Teꞌ eeꞌnooꞌ mintoong otokoꞌnooꞌ; tenau-koo meruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tenau tee mmauꞌ doonge niiꞌ bakaning barevare-nupoong Jiisuuꞌninka minkumurikoꞌnooꞌ, Judasi nariꞌ, tee Jiisuuꞌ sivuainung kare-nupoong-koo; ");
INSERT INTO nas_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eeꞌnoko Judasi noruꞌuitaaꞌ teꞌ pouꞌ tavutavuꞌnavitu ninka eeꞌnoko Juꞌ biikaang piatooronuka˜ ninka, piristiꞌkoong ovontunge eeꞌnoko Boto Keperuuꞌnavitue botoaaruꞌning ninka. Teing kaava-poꞌnupoong, kosiana, daamu dovang ninka porouꞌ, puu. ");
INSERT INTO nas_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jiisuuꞌke ookara kapooꞌ tee-koo nkoaravaining noruꞌuitaaꞌ uroꞌkanooꞌ donkonura aaꞌpuuꞌ, “Diiꞌke baa besiꞌerimang?” ");
INSERT INTO nas_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Teinge makuꞌaama aaꞌpauꞌ, “Jiisuuꞌ, Nasaretiꞌnung.” Eeꞌnoko Jiisuuꞌke aaꞌpuruꞌ, “Ning eeꞌnara.” Judasi, tee tooꞌdenung, tee teing ninka donkonuitaaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tenang Jiisuuꞌke aaꞌpuriko, “Ning eeꞌnara,” teing damaꞌdu-aape dunkaꞌarira kansiꞌkoo duaꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jiisuuꞌke napoꞌ niaꞌurima aaꞌpuruꞌ, “Diiꞌke baa besiꞌerimang?” Eeꞌnoko teinge aaꞌpauꞌ, “Jiisuuꞌ, Nasaretiꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Eeꞌnoko napoꞌ Jiisuuꞌke makuꞌurima aaꞌpuruꞌ, “Ninge tero naurampiring ning tee eeꞌnara. Diiꞌke ning besiꞌmerimaꞌnomaung deekoꞌ nkaning siperereriko nanaavai.” ");
INSERT INTO nas_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Teie teeꞌ minkuvuuꞌ, bakaang kara tero minkuvuuꞌnung masikung deemparaaꞌnaang aaꞌpuuꞌnaare, “Mmaꞌ ee, ookara ameuꞌning-koo narung paaꞌaravaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aung aaꞌ Saimoniꞌ Piita bainatu otoꞌevukoꞌnung. Bakaang bainatu barampura piristiꞌkoong pankaing bakaang botovotonaaꞌ tekaꞌpuma domeꞌ tamparomeꞌ eteꞌuuꞌ. Bakaang miring Malakosi. ");
INSERT INTO nas_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jiisuuꞌke Saimoniꞌ Piita aaꞌpuuꞌ, “Tee dakaang bainatu teꞌ bakanooꞌ koreꞌeai bakura-koo. Dake ee ning eeꞌ noruꞌmemaang, tee sisikeera Mmaꞌke bamuuꞌnung mantompampaukaꞌnung?” ");
INSERT INTO nas_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tevitue tavutavuꞌnavitue biikaang pankaing ninka eeꞌnoko teing piatooronukai Jiisuuꞌ mooꞌaara daiꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Eeꞌnoko Aanasi Kaiapasi baꞌdoraa-anko tutung tavoꞌauꞌ. Tee Kaiapasi tenang piristiꞌnuka biikaang pankaing deempari otokoꞌnung. ");
INSERT INTO nas_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tee tee eeꞌnara Kaiapasi Juꞌkoong ovontung tero eeꞌ nauvuruꞌnung, “Tampaꞌnaꞌ eeꞌ: Narung masikung booaing ookara-koo nantoong-koo.” ");
INSERT INTO nas_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimoniꞌ Piita eeꞌnoko ning neeꞌke Jiisuuꞌ siompampetuꞌnung. Eeꞌnoko Piristiꞌ Pankainge tampaꞌ noruꞌmuioꞌ ning tumaruꞌ bakanava-koo Jiisuuꞌ ninka damaꞌdu-navaro-koo kuung. ");
INSERT INTO nas_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Eeꞌnoko Piita damaꞌdu donkonui otokoꞌ karanaang-koo. Tee enang ning napoꞌ toromarara simaruꞌ. Eeꞌnoko teni karanaang tarevukoꞌnani karavamira Piita tung-antavantuꞌ pava-koo kuung. ");
INSERT INTO nas_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Enang tee, tenie manikumai karanaang tarevukoꞌnanie Piita aaꞌpuuꞌ, “Daꞌ deeꞌma aunkaꞌ bakaning barevare-nupoong-koong.” Piitai makuꞌuma aaꞌpuuꞌ, “A, ning deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tenang eeꞌnang kamaarinang, teeꞌkoo teing ovontung biikaang botovotonaaꞌnukai eeꞌnoko piatooronukai ntaꞌ betuꞌaara tee ntaꞌ koroai donkonai otorokoꞌ ankavoroma. Piita teing-anko nanuraiꞌnange teing ninka donkonai teꞌ otorokoꞌ ntaꞌkoo ankavoma. ");
INSERT INTO nas_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Teie Aanasie, uroꞌke Piristiꞌ Pankaing deemparakoꞌnunge sinevuma Jiisuuꞌ bakaning barevare-nupoong-koo niaꞌuuꞌ, eeꞌnoko kapooꞌ nauvurikoꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Ninge doong kante sirapoꞌke minkuamaung ookara nantoong-koo. Ookara nkaang kara nauaramaunge dootuuꞌdoma-nairu-koo eeꞌnoko dootuuꞌnava pankava-koo ookara Juꞌnupoong oosiarimanooꞌke. Ninge kapooꞌ makensiꞌnung minkuampaung. ");
INSERT INTO nas_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aming-koo dake ning nianiaꞌ niaꞌmemaang? Teing nantoong nianiaꞌ niaꞌeriaing ning taaramaamaing. Teinge noruꞌai otong kapooꞌ ninge minkuamaung.” ");
INSERT INTO nas_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jiisuuꞌke teeꞌ minkuvuioꞌ teing piatooronuka-koong narunge tankoꞌpuuꞌ aaꞌpuma, “Teeꞌ kareaukaꞌ Piristiꞌ Pankaing-ankoi.” ");
INSERT INTO nas_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Ninge kapooꞌ orakaꞌ minkuansing deekoꞌ siraꞌpeaing, nka ninge tampaꞌ minkuanko aming-koo tankoꞌmemaang?” ");
INSERT INTO nas_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Teketa Aanasie Jiisuuꞌ daiꞌari otoko botovuuꞌ Kaiapasi-anko, Piristiꞌ Pankaing-anko. ");
INSERT INTO nas_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Piita mmeꞌ donkonui otoko teke ankavoma niiꞌninge aaꞌpauꞌ, “Daꞌ aunkaꞌ bakaning barevare-nupoong-koonarung deeaꞌ, ee?” Eeꞌnoko Piita penkemparama aaꞌpuuꞌ, “A, ning deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Eeꞌnoko piristiꞌnuka biikaang pankaing bakaning-koong botovotonaaꞌkoo narunge, tee Piitai domeꞌ napuꞌuuꞌnung baꞌmaikoꞌke karoma aaꞌpuuꞌ, “Daꞌ ee ninge teka mintoong-koo Jiisuuꞌ ninka ooramparuing tantaramaang?” ");
INSERT INTO nas_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Eeꞌnoko napoꞌ Piitai aaꞌpuuꞌ, “Otoaꞌ.” Eeꞌnoko tenang namuꞌke kokoreeꞌ kooꞌkuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Teketa tero bakei maatanang, Jiisuuꞌ Kaiapasi-nava-ita Ovoꞌmaꞌ Pankaing Roomaꞌnung bakanava-koo tavoꞌauꞌ. Teka teing Juꞌnupoong koinaavaruuꞌ biikaang toomo orari-antavaara Baariꞌkoong Paroro nai-koo makosiaavarupeuꞌnooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Eeꞌnoko Pailatiꞌ siarara damaꞌdua kuneꞌurira aaꞌpuruꞌ, “Aming nkovuioꞌ tuumpierimaang aung naning?” ");
INSERT INTO nas_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eeꞌnoko eeꞌ makuꞌauꞌ, “Teie kapooꞌ orara nkovuaruko niiꞌke daꞌanko tavoꞌampiarupeuꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailatiꞌke napoꞌ aaꞌpuruꞌ, “Diiꞌke diiꞌka nkaverira paaraveriaing diikaang botoi naururimanaꞌ.” Juꞌkoong ovontunge makuꞌaama aaꞌpauꞌ, “Niiꞌ tauraꞌmariaꞌ naning tavampiko booꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Teeꞌ nkoarako Jiisuuꞌ bakaang kara intampaako tee booꞌparavaing-koong masikung deemparuꞌ, aiꞌ Juꞌnupoonge tee aaꞌbarataꞌkoo˜ intampaama tavaariaung. ");
INSERT INTO nas_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailatiꞌ kuung-aape tumparara tee-koo pava-koo Jiisuuꞌ bokuvuma aaꞌpuuꞌ, “Daꞌ ee daurarong Juꞌnupoong biikaang?” ");
INSERT INTO nas_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Tee nianiaꞌ dake daka matauei niaꞌmemaang, aiꞌ niiꞌninge daꞌ nauraioꞌ?” ");
INSERT INTO nas_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailatiꞌke makuꞌuma aaꞌpuuꞌ, “A, ning aaꞌ Juꞌnupoong-koong deeaꞌ. Dakaning nantoonge eeꞌninge eeꞌnoko piristiꞌkoo ovontunukai daꞌ ning-anko tavoꞌdaing. Aming kapooꞌ dake nkoveinge?” ");
INSERT INTO nas_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jiisuuꞌke aaꞌpuuꞌ, “Nkaang muuꞌ ninge tareamaung aung kansiꞌketaing deeaꞌ. Tee kansiꞌketaing dei nkaninge piatooronukai kare nkoaama pakumaapeuꞌ Juꞌkoong ovontunge daiꞌmaaꞌneeng-koo. Teka nkaang taretare oovunooꞌketaing.” ");
INSERT INTO nas_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Teeꞌpuko Pailatiꞌke niaꞌuma aaꞌpuuꞌ, “Daꞌ ee daurarong ee?” Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Masikaꞌ minkueing, ning eeꞌnara daurarong. Ning pontoꞌmarama kansiꞌkoo mouꞌnung aung kapooꞌ narung nkoamaꞌnaang, kara masikung siraꞌpamaꞌnaang. Baa tee kara masikung siompumaung ning taaramumaung.” ");
INSERT INTO nas_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailatiꞌke aaꞌpuuꞌ, “Aming eeꞌnara kara masikung?” Pailatiꞌ napoꞌ damaꞌdu siarara Juꞌkoong ovontung otorouꞌnooꞌ aaꞌpuruꞌ, “Ninge kapooꞌ ooampaꞌ aung beeka-koong. ");
INSERT INTO nas_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Diikaang aarumo eeꞌ siong-antavui otong: ninge narung kiimatanuka-koong simpiriꞌantarerompiaing ookara mareꞌ kante Taamang Baariꞌkoong-koo. Enang diiꞌ arekeeꞌ piarorimang, aung Juꞌnupoong Biikaang Daurarong simpiriꞌantarerompiiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aung aaꞌ bokiaama makuꞌauꞌnung, aaꞌpaama, “A, tee deeaꞌ. Niiꞌ Barabas piamorimang.” Barabasi tee bakiaaꞌ bauko nantoong tavurima. ");
INSERT INTO nas_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Aung aaꞌ tee, Pailatiꞌke botoarioꞌ Jiisuuꞌ mooꞌaara muraꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Eeꞌnoko tee muraꞌaaraiꞌnange piatooronukai akapeuꞌaama moꞌming kunikunisi daurarong˜ bakaang baakopo-pinaꞌ nkoaara boreꞌkoo kurumpauꞌ, eeꞌnoko mononopaꞌ isikung dauraronuka biikaang-pinaꞌ karompumaung, kurumpauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Teeꞌ nepuꞌaara tee-ankoi porokoꞌ aaꞌpaama, “Tampara masikung, Daurarong Juꞌnupoong Biikaang!” Eeꞌnoko teeꞌ minkuaama tankoꞌpaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eeꞌnoko Pailatiꞌ napoꞌ damaꞌdu toroarara karikaꞌ aaꞌpuruꞌ, “Ee aing, ninge tee aꞌ damaꞌdu tavoꞌampaing diiꞌkoo dutakanooꞌ diiꞌ nau-koo kapooꞌ aung-koo ooampaꞌ tee tuumpi-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Teeꞌ minkuvuko Jiisuuꞌ damaꞌdu siaruꞌ boreꞌ kunikunisie baakopoari, eeꞌnoko mononopaꞌ isikung karompumaung kurumparitaaꞌ. Enang tee, Pailatiꞌke aaꞌpuruꞌ, “Ooveriaing, tee aung eeꞌnara.” ");
INSERT INTO nas_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Teketa piristiꞌnuka-koo ovontunge eeꞌnoko biikaang piatooronukai Jiisuuꞌ ooaaraiꞌnange bokiaama aaꞌpauꞌ, “Aaꞌbarataꞌkoo taakaveaing! Aaꞌbarataꞌkoo taakaveaing!” Pailatiꞌke aaꞌpuruꞌ, “Diiꞌke diiꞌka nkaverira aaꞌbarataꞌkoo taakaveriaing. Ninge kapooꞌ ooampaꞌ tuumpi-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Eeꞌnoko Juꞌkoong ovontunge makuꞌaama aaꞌpauꞌ, “Niiꞌ boto otoꞌmemuring aung nauꞌka booꞌparavaing naumuri otoing, aung Kumponinge Bauring tamparamaung-koo.” ");
INSERT INTO nas_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Teketa Pailatiꞌke tee taaravuraiꞌnange bakei aaꞌnaꞌ avorouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Eeꞌnoko pava-koo kuung napoꞌ tumparara Jiisuuꞌ aaꞌpuuꞌ, “Daꞌ areketa pouꞌnung?” Eeꞌnoko Jiisuuꞌke makuꞌnooꞌ nauvuaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailatiꞌke aaꞌpuuꞌ, “Dake ning karameaꞌ oꞌnong ee? Noruꞌeaꞌ ee ninge makosi daꞌ sirapoꞌ siꞌkoo eeꞌnoko aaꞌbarataꞌkoo taaka-koo?” ");
INSERT INTO nas_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Daꞌ makosi deeaꞌ kapooꞌ nko-koo ning-koo Kumponinge tutung makosi-antaruaruko deekoꞌ. Teeꞌkoo tee naning ning daꞌanko tavoꞌmuinung kapooꞌ bakei aaꞌnaꞌ orara nkovuing.” ");
INSERT INTO nas_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailatiꞌke tee taaravuraiꞌnange bakei napoꞌ aaꞌnaꞌ piavouꞌ sirapoꞌ sipuuꞌnaang. Eeꞌnoko Juꞌkoong ovontung aaꞌnaꞌ bokiaama aaꞌpauꞌ, “Dake sirapoꞌ sipeaing deekoꞌ ookarai noruꞌdaapeuꞌ daꞌ dakaang pankaing Siisaꞌ baꞌmaikoꞌ deeaꞌ, aiꞌ baa tee daurarong baka tamparamaung Siisaꞌ tooꞌdenung deempari otong.” ");
INSERT INTO nas_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Eeꞌnoko Pailatiꞌke tee kara taaravura siaruꞌ Jiisuuꞌ bokuvui, eeꞌnoko baꞌnamparuꞌ kara simpeꞌdoma baꞌnavaꞌnang taataru-koo, teꞌ eeꞌnooꞌ Kapang Tapeeꞌpoꞌnooꞌ tampaamanooꞌ, niiꞌnooꞌ Juꞌnupoong urikupoong biikaang kara-koo Kabata tampaamanooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tenang eeꞌnang duaaꞌ tavoꞌkuko teꞌmung-koo boonaꞌmung Baariꞌkoong˜ Paroro-koo. Pailatiꞌke Juꞌkoong ovontung aaꞌpuruꞌ, “Diikaang aung daurarong.” ");
INSERT INTO nas_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Teinge kara makuꞌaama bokiaama aaꞌpauꞌ, “Taveaing! Taveaing! Taakaveaing aaꞌbarataꞌkoo!” Pailatiꞌke eeꞌ niaꞌuruꞌ, “Diiꞌ ee piarorimang tee eeꞌnara diikaang daurarong taakavamaꞌnaang aaꞌbarataꞌkoo?” Piristiꞌkoong ovontunankai makuꞌaama aaꞌpauꞌ, “Niiꞌ daurarong otoꞌmemuriaꞌ, dauraronuka biikaang pankaing, Siisaꞌ narung otoꞌmemuring.” ");
INSERT INTO nas_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aung aaꞌ teeꞌpaako Pailatiꞌke kasivuarura tauraꞌpuruꞌ aaꞌbarataꞌkoo taakavaavaꞌnaang. Enang tee Pailatiꞌke tauraꞌpurioꞌ niiꞌning piatooronukai Jiisuuꞌ oko siong-antavauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Eeꞌnoko Jiisuuꞌke bakaang aaꞌbarataꞌ nkavui osi-eta tenkenuuꞌ bera Makupiꞌnooꞌ tampaamanooꞌ basiaruꞌ, Juꞌnupoong biikaang kara-koo Kolokataꞌ tampaamanooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Teka eeꞌnooꞌka taakavauꞌ aaꞌbarataꞌkoo. Eeꞌnoko kenaankara niiꞌnaanka napoꞌ taakavaaretuꞌ aaꞌbarataꞌkoo, niiꞌnara tampavine-aape, niiꞌnara mareꞌaanavine-aape, eeꞌnoko Jiisuuꞌ meuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailatiꞌke taaꞌniꞌanta daarivura aaꞌbarataꞌkoo niiri-antavuuꞌ eeꞌ minkunaare: “JIISUUꞌ NASARETIꞌNUNG, JUꞌNUPOONG BIIKAANG DAURARONG.” ");
INSERT INTO nas_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Teꞌ Jiisuuꞌ taakavauꞌnooꞌ osi-koo dueꞌ deemparako mmauꞌ Juꞌnupoonge tee taaꞌniꞌanta siraꞌparioꞌ deeruaakoꞌ, aing aaꞌning kara-koo daariari otoko: Juꞌnaꞌ, Roomaꞌnaꞌ, eeꞌnoko Kirikiꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Juꞌnupoong-koo piristiꞌkoo ovontunukai Pailatiꞌ aaꞌpauꞌ, “Eeꞌ daarieinaꞌ, ‘Juꞌnupoong Biikaang Daurarong,’ makosi deeaꞌ. Niiꞌnaꞌ daarieaing eeꞌpinaꞌ, ‘Aung baka aaꞌparamaung: Ning Daurarong Juꞌnupoong Biikaang.’” ");
INSERT INTO nas_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nka Pailatiꞌke makuꞌurima aaꞌpuruꞌ, “Kapooꞌ daariansing teeꞌ nariꞌ daariari otoaing.” ");
INSERT INTO nas_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Teketa piatooronukai Jiisuuꞌ aaꞌbarataꞌkoo taakavaaraiꞌnange bakaang mononopaꞌ nkavaama tankeeꞌeuꞌ karemarantu-koo, namaranaꞌ piatooro narunaꞌ. Eeꞌnoko tee mononopaꞌ isikung nkavauꞌ tenaaꞌ ootukunaaꞌ navaro-koo bavuꞌniiꞌnaaꞌ, tuaꞌnooꞌ dapaꞌdoma dopa. ");
INSERT INTO nas_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Teing piatooronuka aaꞌpeekoꞌ, “Dereꞌampiaukaꞌnung, deikooꞌmeerima ooampiaing baie nkavupeuꞌ.” Teeꞌ eeꞌnaꞌ nkoarako Daari Meekung masikaꞌparuꞌ aaꞌpumaung-koo, “Teing tankeeꞌeuꞌ nkaang baarong biiꞌka, eeꞌnoko deikooꞌeuꞌ nkaang mononopaꞌkoo.” Eeꞌnoko teeꞌ eeꞌnaꞌ piatooronukai nkoauꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tenang tee Jiisuuꞌ bauko-namainta eeꞌnoko Maaria Kolopas baꞌaang, eeꞌnoko Meeriꞌ Maꞌdala-nani, teing eeꞌning Jiisuuꞌ bakaang aaꞌbarataꞌkoo dueꞌ donkonai otorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jiisuuꞌke bauko eeꞌnoko ning baꞌmaikoꞌ dueꞌ donkonampesioꞌ oomureta bauko aaꞌpuuꞌ, “Ee nkoꞌ, dauring tee.” ");
INSERT INTO nas_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Eeꞌnoko napoꞌ teeꞌpuraiꞌnange ning aaꞌmuuꞌ, “Dauko teni.” Teketa teni bokuantuꞌ niikanava-koo oꞌnoriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Teketa Jiisuuꞌke noruꞌuuꞌ ookara kapooꞌ nkoaraaꞌnaang makosi Kumponinge teroita tampuuꞌning teeꞌ dupearako. Eeꞌnoko Daari Meekung dupe-anta-koo Jiisuuꞌke aaꞌpuuꞌ, “Ning nukaaꞌmoing.” ");
INSERT INTO nas_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Teke tee kokotonaroꞌ teꞌ otokoꞌ uaini kaaveeriiꞌke maantoꞌnaroꞌ. Teinge kapooꞌ tee-koo uaini-koo boovong-antavaara napoꞌ banaꞌkoo daiꞌantavaara intampauꞌ Jiisuuꞌ karankanooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jiisuuꞌke teruꞌ mantompura aaꞌpuuꞌ, “Bakearing.” Eeꞌnoko bakaang boreꞌ aruꞌarara domang siꞌnuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Teꞌmung teꞌmung doonaꞌmung miring Maamu-antanaꞌmung, doong uaanaꞌmung aaꞌnaꞌ meekaꞌmung-koo boonaꞌmung deemparioꞌ. Eeꞌnoko teinge Juꞌkoong pankenge eeꞌ noruꞌauꞌ, “Teing aaꞌbarataꞌkoo taakavarining teeꞌ nariꞌ otoroko Doong Uaanaꞌmung orariaraꞌneeng.” Teeꞌpaara Pailatiꞌkoo eentavariruꞌ botoarako piatooronukai teing-koong taakavaaruꞌning-koong kauꞌ nenkoꞌaavaꞌnaang, bera namuꞌke booroioꞌ sing-antavaariiꞌnaang aaꞌbarataꞌketa. ");
INSERT INTO nas_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eeꞌnoko piatooronuka beroraiꞌnange tutunaꞌnung-koong kauꞌ nenkoꞌauꞌ, teketa tee-koong Jiisuuꞌkoo amenkaꞌkoo taakavauꞌnung-koong. ");
INSERT INTO nas_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Teka Jiisuuꞌanko pororaiꞌnange tero booꞌparioꞌ ooauꞌ, teeꞌkoo kauꞌ nenkoꞌaavaruuꞌ Jiisuuꞌkoong. ");
INSERT INTO nas_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Teketa narunge piatooronuka-koonge daankoꞌke Jiisuuꞌ tooꞌpuuꞌ matoꞌnang-koo, eeꞌnoko namuꞌke ereng ntong ninka dakoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Masikaꞌ naurampimang, ninge eeꞌnarai ooansioꞌ teeꞌ nkoauꞌ. Niiꞌke bakaninge noruꞌampiri otong tee kapooꞌ minkuamaaꞌnomaung tee masikung, eeꞌnoko ninge masikung minkuamaang noruꞌansitaaꞌ ninge teeꞌ siraꞌpamaang diiꞌke napoꞌ masikaꞌantaveriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tee kapooꞌ nkoaruꞌnung Daari Meekung masikaꞌparaaꞌnaang aaꞌpuuꞌnaꞌ, “Tee-koong kooꞌnariꞌ nenkoꞌaavaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Eeꞌnoko niiꞌnung Daari Meekung-koong nanaare eeꞌ otong, “Nantoonge ooaavaing tee tooꞌpauꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Aung aaꞌ tee damaꞌke, Josepaꞌ Arimateaꞌnunge Pailatiꞌ niaꞌuuꞌ Jiisuuꞌ bakaang mono nka-koo tauraꞌpuuꞌnaang. Josepaꞌ tee Jiisuuꞌ bakaning-koong barevare-nupoong-koo narung deempari otokoꞌnung, teka makemparitaaꞌ Juꞌkoong ovontung-koo avoroma. Eeꞌnoko Pailatiꞌke tauraꞌ avuioꞌ bera Jiisuuꞌkoong mono sivura nkavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemasi ninka nariꞌ beretuꞌ. Tee Nikodemasi tee eeꞌnara Jiisuuꞌ tutung beeroꞌuuꞌnung muunganang. Teie mmauꞌ duuni tampaꞌ nuuraaꞌ meea-koong eeꞌnoko alosi-koo kenotoarioꞌ kompui, daping mou-koong naraꞌpinaꞌ basi mankiꞌnooꞌ, naning daurarong dakoꞌkoo makosinooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tenaankai Jiisuuꞌnung mono nkavuretaiꞌnange booꞌnuka nopaꞌnaꞌ nopaꞌuretuꞌ baaronge tee ninka tampaꞌ nuuraaꞌ ninka, teeꞌ eeꞌnaꞌ nkoaarikoꞌnaꞌ Juꞌnupoonge dakoꞌaariiꞌnaang mono. ");
INSERT INTO nas_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Teꞌ aaꞌbarataꞌkoo dupisiꞌauꞌnooꞌ mintoong-nanau otokoꞌ, eeꞌnoko tenau-koo meuꞌ nerakung kuvi dakoꞌdoma otokoꞌ naning mmeꞌ siparavaꞌnareng. ");
INSERT INTO nas_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Teꞌmung Juꞌnupoong biikaang Doong Uaanaꞌmung-koo maamu-naꞌmung deemparako Jiisuuꞌ teꞌ sipuretuꞌ teꞌ kuvi dueꞌ otoko. ");
INSERT INTO nas_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Aung aaꞌ tee, tero maatanang Saandei-naꞌmung mmeꞌ taneꞌpuko, Meeriꞌ Maꞌdala-nani kuvi dakoꞌdoma nanuuꞌ, eeꞌnoko tee kuꞌnung kapang-koong diiriꞌarioꞌ karanaang-eta oovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eeꞌnoko oovuraiꞌnange teni kuaꞌparuꞌ neeꞌanko, Saimoniꞌ Piita-anko eeꞌnoko ning Jiisuuꞌ baꞌmaikoꞌ. Eeꞌnoko naumurema aaꞌmuretuꞌ, “Tee Ovoring kuvi-eta nkavaing. Eeꞌnoko sipainooꞌ noruꞌampiaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Teketa tee enang neeꞌke Piita naankai simaretaiꞌnange kuvi dakoꞌdoma kuaꞌmaresi meretuꞌ; ");
INSERT INTO nas_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Eeꞌnoko aaꞌnaꞌ kuaꞌmari Piita divuꞌamira kuvi-koo tutung tavoꞌmaruꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Eeꞌnoko kinkinamiraiꞌnange ooantuꞌ baaronanka. Nka kuvi dakoꞌdoma tumaravaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Eeꞌnoko Saimoniꞌ Piita poraiꞌnange koontoꞌ tee kuvi dakoꞌdoma tumparuꞌ, eeꞌnoko baaronanka oovuuꞌ teꞌ tamung otoko. ");
INSERT INTO nas_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Eeꞌnoko tenaaꞌ baarong-nanaaꞌ Jiisuuꞌkoong boreꞌ daiꞌauꞌnanaaꞌ, tenaaꞌ oovunooꞌ otoko, niiꞌning baaronanka ninka deeaꞌ, baka kaiꞌari otoko. ");
INSERT INTO nas_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Teketa ning damaꞌke tumaruꞌ, eeꞌnoko ooamiraiꞌnange deekoꞌ Kumponinge booꞌketa daaꞌuuꞌnung masikaꞌantavantuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nka neeꞌkoo mmeꞌ sirakaꞌparavaꞌ tee kara Daari Meekung-koo otoing Jiisuuꞌ booꞌketa daaꞌaravaing-koong, bane noruꞌampesi naumuruꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Eeꞌnoko teketa tee neeꞌ osi toromaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Aung aaꞌ tee, Meeriꞌ kuvi dakoꞌdoma damaꞌdu donkonui biromparakoꞌ, eeꞌnoko biromparama kinkinura ookuuꞌ kuvi-koo kuung. ");
INSERT INTO nas_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Eeꞌnoko teka kuvi-koo kuunga koosinunka kenaankara oovuretuꞌ kakaarai duaanavaresi, teꞌ baꞌnamparesioꞌ Jiisuuꞌkoong mono tero otouꞌnooꞌ, niiꞌnung boreꞌkanooꞌ eeꞌnoko niiꞌnung kauꞌkanooꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Koosinungkai˜ aaꞌpuretuꞌ, “Ani ee, daꞌ aming-koo birontaramang?” Eeꞌnoko tenie makuꞌurema aaꞌpuretuꞌ, “Tee aaꞌ ning nkaang Ovoring nkavaara tokoo sipaioꞌ, eeꞌnoko sipainooꞌ noruꞌampaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eeꞌnoko tenie teeꞌ minkuvuraiꞌnange torotoroarama Jiisuuꞌ oovuuꞌ teꞌ donkonui otoko, nka tasiꞌpuaꞌ tenie tee Jiisuuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Ani ee, daꞌ aming-koo birontaramang? Dake baa besiꞌemaang?” Tenie mintoong tarenara-pinaꞌ noruꞌuma aaꞌpuuꞌ, “Ee aung, dake nkaveing deekoꞌ ning naumeaing sipeinooꞌ, ninge mera nkavampainaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jiisuuꞌke miring tampuma aaꞌpuuꞌ teni, “Meeriꞌ.” Eeꞌnoko koontoꞌ tee-anko toroarama tero Juꞌnupoong urikupoong biikaang karai karoma tenie aaꞌpuuꞌ, “Rabonai.” Aung miruꞌnooꞌ eeꞌ oroꞌ, Nau-anta Ovoring. ");
INSERT INTO nas_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jiisuuꞌke teni aaꞌpuuꞌ, “Anaꞌantameaukaꞌ, aiꞌ ning mmeꞌ Mmaꞌanko deto toromaravaꞌ. Bera mmaikoriꞌ eeꞌnoko ntaraꞌmainkaang-anko nanira naueriaing ning nanamang Mmaꞌanko eeꞌnoko diuma-anko, nkaang Kumponing-anko eeꞌnoko diikaang Kumponing-anko.” ");
INSERT INTO nas_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eeꞌnoko Meeriꞌ Maꞌdala-nanie niiꞌ bakaning barevare-nupoong naumurima aaꞌmuruꞌ, “Ninge ooansing Ovoring, eeꞌnoko tee kara naurampiring naumui.” ");
INSERT INTO nas_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Eeꞌnoko teꞌmung eeꞌnaꞌmung Saandei-naꞌmung muung-aapenang nava-koo niiꞌ bakaning barevare-nupoong oosimariruꞌ. Daꞌmarira oꞌnoruꞌ Juꞌkoong ovontung-koo amorompima. Eeꞌnoko tenang Jiisuuꞌ pouꞌ. Pora niiꞌkoo meuꞌ donkonuma aaꞌmuruꞌ, “Tampara, ee aing! Mooa tee diiꞌkoo otoaing!” ");
INSERT INTO nas_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Eeꞌnoko teeꞌ minkuvuraiꞌnange bakaang bireng nau-antamuruꞌ eeꞌnoko mantoꞌnang. Eeꞌnoko niiꞌ bakaning barevare-nupoong bakei aaꞌnaꞌ dotumariruꞌ Ovoring ooampira. ");
INSERT INTO nas_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Eeꞌnoko Jiisuuꞌke napoꞌ aaꞌmuruꞌ, “Mooa-poꞌnupoong otoriaing. Mmaꞌke ning botomuuꞌnaꞌ ninge diiꞌ botorampimang.” ");
INSERT INTO nas_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Teeꞌ minkuvura domaange niiꞌ uupumurira aaꞌmuruꞌ, “Tanuaang Meekung nkaveriaing. ");
INSERT INTO nas_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Diiꞌke nantoong biikaning oreng aarumo tontaꞌevurereriko tontaꞌari otoaing, eeꞌnoko diiꞌke tontaꞌevurereriaruko tontaꞌaravaꞌ otoainge.” ");
INSERT INTO nas_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Narung niiꞌkoong Kivora-ita Kenaanka-koong Toomasi, niiꞌnooꞌ Pauroong tampampikoꞌnung niiꞌ ninka otoaruko Jiisuuꞌ pouꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eeꞌnoko niiꞌke nauampima aaꞌpampiruꞌ, “Niiꞌke Ovoring ooampiring.” Toomasie makuꞌmurima aaꞌmuruꞌ, “Ninge niiri-koong taamu ooamparura bireng-koo, napoꞌ tankaꞌ dusiꞌamparura niirie tupuꞌuuꞌnung-koo taamu-koo, eeꞌnoko nkaang bireng matoꞌnang-koo dusiꞌamparura deekoꞌ ninge masikaꞌantavampaukaꞌnung.” ");
INSERT INTO nas_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","˜Beenang-taa doong tankinuioꞌ napoꞌ niiꞌ ookara bakaning barevare-nupoong naroꞌmarira oꞌnorikoꞌ pava-koo kuung, Toomasi nariꞌ. Bane kuꞌnung pinkaꞌarioꞌ Jiisuuꞌ niiꞌkoo meuꞌ donkonura aaꞌmuruꞌ, “Mooa-poꞌnupoong otoriaing!” ");
INSERT INTO nas_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Eeꞌnoko Jiisuuꞌke Toomasi aaꞌpuuꞌ, “Dakaang bireng aꞌ dusiꞌeai, eeꞌnoko nkaang bireng oomeai. Bireng tovoroꞌdarara aꞌ ning-koo mantoꞌnang-koo dusiꞌeai. Noruꞌ keekooꞌkoong bakerarara masikaꞌanta otoꞌderui otoai.” ");
INSERT INTO nas_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomasie makuꞌuma aaꞌpuuꞌ, “Keei, nkaang Ovoring eeꞌnoko nkaang Kumponing Daꞌ!” ");
INSERT INTO nas_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jiisuuꞌke aaꞌpuuꞌ, “Daꞌ ee ning oomera masikaꞌantameng? Nka biraankenanka masikeng teing nantoong oomaavaꞌ masikaꞌantamaavaining.” ");
INSERT INTO nas_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Eeꞌnoko tee, Jiisuuꞌke niiꞌning oovuning taaꞌniꞌanta nkovuuꞌ niiꞌke bakaning barevare-nupoonge ooampirioꞌ aung-koo buuku-koo daariaravaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Aing daariampirining otomaung diiꞌke masikaꞌantaveriiꞌnaang Jiisuuꞌ tee Kumponinge Pakoꞌpariꞌniiꞌ niiꞌ domang-anta-koo, Kumponing Bauring eeꞌnara. Eeꞌnoko tee, teeꞌ masikaꞌantaverima diiꞌ domaang-poꞌnupoong otoriiꞌnaang bakaang miring-koo. ");
INSERT INTO nas_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jiisuuꞌ napoꞌ taaꞌniꞌpoi siraꞌantavaruꞌnaꞌ niiꞌ bakaning barevare-nupoong Kaaleliꞌnaruꞌkoo oꞌnoriko teeꞌ eeꞌ nkoaruꞌ: ");
INSERT INTO nas_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoniꞌ Piita, Toomasi (Pauroong tampampikoꞌnung), Natanieloꞌ (Kana-namono-nung, Kaaleliꞌnameng-koonooꞌ), neeꞌ Siebedi-baurinketa, eeꞌnoko niiꞌnaanka kenaankara bakaning barevare-nupoong-koonaanka niiꞌ nariꞌ oꞌnoriko. ");
INSERT INTO nas_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimoniꞌ Piitai niiꞌning aaꞌmuruꞌ, “Ning kapaꞌkoo nanang.” Niiꞌke aaꞌpampiruꞌ, “Eeꞌ, tee aaꞌ niiꞌ moriiꞌnaang.” Teketa bakaasi-koo aaꞌemarira teꞌmung eeꞌnaꞌmung ootukunaꞌmung muunganang kapaꞌkampima nau asiꞌnu barankampiaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Duaaꞌ mmeꞌ tavoꞌarako Jiisuuꞌ donkonuuꞌ teruꞌkoo tapiru. Eeꞌnoko niiꞌke bakaning barevare-nupoonge ooampiaꞌ tee Jiisuuꞌpinaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Eeꞌnoko teie aaꞌmuruꞌ, “Ee aing nemaaꞌ, diiꞌ ee barankiriaruing?” Niiꞌke aaꞌpampiruꞌ, “Eeꞌ, barankampiaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Eeꞌnoko Jiisuuꞌke aaꞌmuruꞌ, “Napoꞌ sionung duaꞌeriaing bakaasi-koo tampanaang-aapei niiꞌning barankiriainaꞌ.” Eeꞌnoko teeꞌpuioꞌ niiꞌke sionung napoꞌ duaꞌampiruꞌ ntong-koo, eeꞌnoko duaꞌampira mmauꞌ kapaꞌnaraꞌ dauꞌpampira intampampiaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Eeꞌnoko ning Jiisuuꞌ baꞌmaikoꞌke Piita aaꞌpantuꞌ, “Tee aung Ovoring.” Eeꞌnoko Saimoniꞌ Piita tee Ovoring taaravura bakaang mononopaꞌke ioꞌ kiruꞌaruꞌnunge nopaꞌarara dinkitooꞌaruꞌ ntong-koo. ");
INSERT INTO nas_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Eeꞌnoko niiꞌ niiꞌning bakaning barevare-nupoong piisiꞌkoo duumumpiruꞌ sionung kapaꞌnaraꞌke maantoꞌuioꞌ taariꞌmarira barampampiri; teꞌ taviꞌ dauꞌpampiruꞌnooꞌ baruꞌ isipoꞌ kansiꞌketa deeaꞌnooꞌ, paꞌnokoꞌ kivora daangaꞌpinaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Teketa piisiꞌkoo simariraiꞌnange ooampiruꞌ, taviꞌ eeꞌnoko bereteꞌ ntaꞌkoo dau otoko. ");
INSERT INTO nas_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jiisuuꞌke niiꞌ aaꞌmuruꞌ, “Niiꞌning taviꞌkoo tavoꞌeriaing teing-koo barampererining-koo.” ");
INSERT INTO nas_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Teketa Saimoniꞌ Piita enang bakaasi-koo aaꞌearuꞌ, eeꞌnoko sionung barampuuꞌ piisiꞌaape taviꞌ pankainankai maantoꞌuioꞌ. Teing taviꞌning narung daakuꞌketa paꞌnokoꞌ kivora-ita beenaumo 153. Nka bane taviꞌ mmauꞌ, nka sionung dereꞌaravaꞌ. ");
INSERT INTO nas_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jiisuuꞌke niiꞌ aaꞌmuruꞌ, “Porira mamompiai.” Eeꞌnoko niiꞌ maiaꞌmoruꞌ eeꞌ niaꞌkoo “Daꞌ baa?” noruꞌampiritaaꞌ tee tee Ovoring. ");
INSERT INTO nas_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Teka Jiisuuꞌ poraiꞌnange bereteꞌ nkavura amuruꞌ, taviꞌke teeꞌ siong-antavui. ");
INSERT INTO nas_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Teꞌmung eeꞌnaꞌmung beenanaꞌ taaꞌniꞌpoi siraꞌantavaruꞌnaꞌmung Jiisuuꞌ baka niiꞌkoo bakaning barevare-nupoong-koo booꞌketa daaꞌararaiꞌnange. ");
INSERT INTO nas_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aung aaꞌ tee, taamang bakemariraiꞌnange Jiisuuꞌke Saimoniꞌ Piita aaꞌpuuꞌ, “Saimoniꞌ, Jooni bauring, dake ee ning piaamemang aing-koo dau basinooꞌ?” Teie makuꞌuma aaꞌpuuꞌ, “Eeꞌ. Dake noruꞌmei otong, ninge piaaramang.” Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Nkaning sipisipiꞌkoong sieꞌnanka tanataveriaing.” ");
INSERT INTO nas_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Eeꞌnoko napoꞌ kemuꞌkanaꞌ Jiisuuꞌke aaꞌpuuꞌ, “Saimoniꞌ, Jooni bauring, dake ee ning piaamemang?” Teie makuꞌuma aaꞌpuuꞌ, “Eeꞌ, Ovoring, dake noruꞌei otong ninge daꞌ piaaramang.” Jiisuuꞌke aaꞌpuuꞌ, “Nkaning sipisipiꞌnanka tareveriaing.” ");
INSERT INTO nas_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Aung aaꞌ beemuꞌpinaꞌ Jiisuuꞌke aaꞌpuuꞌ, “Saimoniꞌ, Jooni bauring, dake ee ning piaamemang?” Piita orakaꞌ deeꞌouꞌ Jiisuuꞌke beemuꞌpie nianiaꞌ niaꞌuioꞌ, aaꞌpuma, “Dake ee ning piaamemang?” Eeꞌnoko Jiisuuꞌ aaꞌpuuꞌ, “Ovoring, daꞌ ookara kapooꞌ noruꞌei otong. Dake ning noruꞌmei oꞌnong daꞌ ninge piaaransi oꞌnong.” Jiisuuꞌke aaꞌpuuꞌ, “Nkaning sipisipiꞌnanka tanataveriaing. ");
INSERT INTO nas_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Masikaꞌ nauramaang, daꞌ nemaaꞌdaritaaꞌnange tokoniiꞌ pinkaꞌdarama avitoitoi nanikoꞌ piarokoꞌnaꞌ, eeꞌnoko pankaꞌdarara dakaang bireng tovoroꞌdaravaing, eeꞌnoko niiꞌnunge bireng pinkaꞌdura tokoo nkaruaing piaroaukaꞌnooꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Teeꞌ aaꞌbarataꞌkoo Piita booainaꞌ Jiisuuꞌke minkuvuma nauvuuꞌ, Kumponing-anko meenasi tavoꞌuma. Eeꞌnoko Jiisuuꞌke aaꞌpuuꞌ, “Ning siomeaing.” ");
INSERT INTO nas_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piita damaꞌdu-aape toroarama ning Jiisuuꞌ baꞌmaikoꞌ oomuuꞌ, ning eeꞌnara taamang naiampima Jiisuuꞌkoo darimaritaaꞌ niaꞌama aaꞌpantuꞌnung, “Daꞌ baie kare-nupoong-koo sing-antaruuꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Eeꞌnoko Piitai ning oomuraiꞌnange Jiisuuꞌ aaꞌpuuꞌ, “Ovoring, arekeeꞌ tee aung naning?” ");
INSERT INTO nas_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jiisuuꞌke makuꞌuma aaꞌpuuꞌ, “Tee domampari otoaing bera ning napoꞌ moainooꞌ miruꞌampaing deekoꞌ tee dakaang kapooꞌ deeaꞌ. Ning siomeaing dake.” ");
INSERT INTO nas_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Teeꞌ minkuvuioꞌ minkunaa beremparuꞌ Jiisuuꞌ bakaning barevare-nupoong-koo ning moompaukaꞌnung. Nka Jiisuuꞌke minkuvuaꞌ ning moompaukaꞌnung. Teeo aaꞌpuuꞌ, “Tee domampari otoaing bera ning moainooꞌ miruꞌampaing deekoꞌ tee dakaang kapooꞌ deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ning tee eeꞌnara bakaning barevare-nupoong-koonge aing kapooꞌ minkuansing eeꞌnoko daariansi. Eeꞌnoko niiꞌke noruꞌampiri otong tee kapooꞌ ninge minkuansing tee masikung. ");
INSERT INTO nas_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Eeꞌnoko tee niiꞌning oovuning kapooꞌ mmauꞌ Jiisuuꞌke nkovuuꞌ aꞌ otoaing. Ookara narunaꞌ narunaꞌ daari-koo ookara kansiꞌ makotuarupeuꞌ pa teing buuku kong-koo tee daariaapeuꞌning. ");
INSERT INTO nas_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Aung ee, Teopilasiꞌ, Tutunaꞌnaneꞌkoo daarireroma tee ookara kapooꞌnanka-koo minku-antarantuꞌnung Jiisuuꞌke nkovukoꞌning eeꞌnoko nau-antavurikoꞌning tutuntoma-ita bera deto paning-aape intamparuꞌnooꞌke basi. ");
INSERT INTO nas_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Mmeꞌ intamparavaꞌ teie bakaning kara okovuri nka-koo miruꞌuruꞌning boto avuruꞌ Tanuaang Meekung-koo kuunge. ");
INSERT INTO nas_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Teing-koo mmauꞌnamuꞌpie oroꞌparuꞌ domamparuꞌnaꞌkoo taaꞌniꞌantavari, mmauꞌ kapooꞌnanka tasiꞌanta ninka, noruꞌ keekooꞌariarooꞌnaang. Eeꞌnoko booꞌparuꞌnooꞌketa karenaumo kivora doong teeꞌ otoi Kumponing bakaang muuꞌ nau-antavuruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Eeꞌnoko tenang teing ninka taamanaama otoroi teie orokovuruꞌ Jerusalemaꞌketa tenkenaavarooꞌnaang, teka nempaavaꞌnaang tampuuꞌ tee avuavuꞌ teing-koo Baumai maraka-antavuruꞌnung, eeꞌ oroꞌ, “Aung tee tero naurampiruꞌnung aaꞌpama: ");
INSERT INTO nas_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jooni Minkinarai tee ntong-koo minkirurima meekaꞌantarurikoꞌ, teka mmauꞌ doong tankinuaruko diiꞌ teing Tanuaang Meekung ninka meekaꞌantarariaining.” ");
INSERT INTO nas_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bera teinge tee naroꞌ porora eeꞌ niaꞌauꞌ, “Ovoring, dake ee enang donkompeeꞌnaang tee Isireeli tero donkompuuꞌnaꞌ?” ");
INSERT INTO nas_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Eeꞌnoko teie aaꞌpuruꞌ teing, “Tee kapooꞌ diiꞌke noruꞌkoong deeaꞌ; tee bateinananka Mmaꞌke baka bakaang, bakaange iriꞌke pinkaꞌuruꞌnanka. ");
INSERT INTO nas_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Teka diiꞌke tee iriꞌ nkaveriaing tenang Tanuaang Meekung diiꞌkoo dau poko, eeꞌnoko diiꞌ teing nkaning ning siraꞌmeriaining anke Jerusalemaꞌke, eeꞌnoko ookutunairu Judiaꞌ nameensiꞌkoo eeꞌnoko Sameriaꞌ eeꞌnoko bera kansiꞌ oparavainooꞌke basi.” ");
INSERT INTO nas_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eeꞌnoko teeꞌ minkuvura ooai otoko intamparuꞌ tee Jiisuuꞌ, bera kamoꞌnavuꞌke nopaꞌura paaꞌantavuuꞌ teing-koo duta-ita. ");
INSERT INTO nas_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eeꞌnoko tenang paning-aape ankampariri otoroko, tee beko, taꞌninaꞌ kenaanka donkaanira mononopaꞌ kakaarai nopaꞌniiꞌka donkonuretuꞌ teꞌ teing-anko. ");
INSERT INTO nas_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Eeꞌnoko aaꞌpuretuꞌ, “Diiꞌ donkaang Kaaleliꞌnupoong, aming-koo teeꞌ donkoniri paning-aape ooveri otomang? Tee tee Jiisuuꞌ deto intamparing paning-aape diiꞌankoita tee, teeꞌ nariꞌ otoi poaing ooverioꞌ paning-aape beinaꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Teketa Oliveꞌpoꞌnamii-eta toroariruꞌ teing Jerusalemaꞌaape. Dueꞌ teꞌ Jerusalemaꞌ teketa. ");
INSERT INTO nas_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Eeꞌnoko osi duparira deto daukava-koo koinauꞌ teꞌ otorokoꞌnooꞌ aaꞌning: Piita, Jooni, Jeemisi, Aanduruꞌ, Pilipiꞌ, Toomasi, Baatolomiuꞌ, Maatiuꞌ, Jeemisi tee Alopeasi bauring, Saimoniꞌ Sielotiꞌ, eeꞌnoko Judasi Jeemisi bauring. ");
INSERT INTO nas_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aing teing nariꞌ otoroi kunsi-koo biiꞌka avarikoꞌning, napoꞌ nariꞌ teing maniiꞌ, Meeriꞌ Jiisuuꞌ bauko ninka nariꞌ, eeꞌnoko teing Jiisuuꞌ baaraꞌmainkaang. ");
INSERT INTO nas_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Teketa niiꞌning doong tankinuko teing Jiisuuꞌ bakaning barevare-nupoong oosiarira Piita meuꞌ donkonuuꞌ teing-koo, deerunooꞌ narung daakuꞌketa kenaiꞌka-pinaꞌ otoroi. ");
INSERT INTO nas_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Eeꞌnoko aaꞌpuuꞌ, “Mmaikoriꞌ ee, tee Daari Meekunge minkuvuuꞌnung kara tee bakei dupenumpoꞌ tee Tanuaang Meekunge urikamuꞌ siraꞌpuuꞌnung Deevitaꞌ karantavuma˜ mmeꞌ nkoaravaruko, aaꞌnaare Judasi minkuari otong tee eeꞌnara Jiisuuꞌ daiꞌauꞌning barampuri pouꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tee tee niiꞌ ninka deeruniiꞌ, Ovoringe niiꞌ ninka nariꞌ mintoomariiꞌnaang miruꞌmuruꞌnung.” ");
INSERT INTO nas_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Tee aaꞌ tee Judasie kansiꞌnameensiꞌ mooꞌuuꞌnung teinge mooniꞌninge bakaang orakaꞌ nko-koo mooꞌauꞌninge, eeꞌnoko teke boreꞌke uroi duaꞌarara tompooꞌkura mintung taapoꞌ bakoaruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ookara Jerusalemaꞌnupoonge tee noruꞌauꞌnung tee, eeꞌnoko tevoraꞌ kansiꞌnavoraꞌ Akeldama tampauꞌ, miruꞌnooꞌ Tookanavoraꞌ. ");
INSERT INTO nas_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Eeꞌnoko Piitai napoꞌ karoma aaꞌpuuꞌ, “Tee aung naning tee Daari Meekung-koong Kena-koo eeꞌ minkuari otong, ‘Bakanavaro tee doonavaravaing eeꞌnoko naning teꞌ otoaukaꞌ.’ Eeꞌnoko ‘Niiꞌnunge bakanooꞌ tareroma pariꞌantavuaing.’ ");
INSERT INTO nas_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Teeꞌkoo, Daari Meekunge teeꞌ minkuvuioꞌ naning Judasi paari-antanung miring tampampiaing tee Ovoring Jiisuuꞌ booꞌketa daaꞌaruꞌnaꞌkoong kara siraꞌpuaing niiꞌ ninka nariꞌ. Niiꞌ Jiisuuꞌ ninka nariꞌ oꞌnorimaing-pinaꞌ masikaꞌ oroꞌ miruꞌampiaing. ");
INSERT INTO nas_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Tee Jiisuuꞌ ookara batei-koo nanuuꞌnaꞌ siompukoꞌnung Joonie minkivura meekaꞌantavuuꞌnooꞌketa bera niiꞌankoita deto koinuuꞌnooꞌke basi.” ");
INSERT INTO nas_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Eeꞌnoko teinge kenaanka makosira tampaaretuꞌ aaꞌnoko Josepaꞌ, niiꞌnooꞌ Basabas Jaastas eeꞌnoko Mataias. ");
INSERT INTO nas_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Eeꞌnoko kunsiarima aaꞌpauꞌ, “Ovoring ee, dake nantoong-koong domang noruꞌei otomaunge naumeriaing arera narung anaanka-koo kenaankara-koo dake miruꞌei otoing amuriiꞌ nko-nko nko-koo Judasi pariꞌantavuaing, oovunaꞌ bereꞌarara bakanamenge oramenge booꞌpari beuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eeꞌnoko teeꞌ minkuaara siikiitaakiiꞌ nkoaako Mataias miring tavoꞌkuuꞌ. Eeꞌnoko teketa tee tee teing ninka nanaiꞌketa narung kara okovuri nkanuka ninka nariꞌ deeruauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Teketa tee doong paroronaꞌmung Pentekos tampaakoꞌnaꞌmung tavoꞌkuuꞌ ˜kenaanka-taa uiki Baariꞌkoong˜ Paroro divuꞌkuioꞌ. ");
INSERT INTO nas_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Teꞌmung eeꞌnaꞌmung tee ookara naroꞌarira naroꞌ otoroko taꞌninaꞌ aurong paning-eta pouꞌ piong pankaing uutuarama karomanaꞌ. Eeꞌnoko teie teva ookutunava maantoꞌuuꞌ teing eeꞌning baꞌnanai otokoꞌnava. ");
INSERT INTO nas_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Eeꞌnoko tee kapooꞌnanka ntaꞌ meneng-pinaꞌ oroꞌnanka urumpariri teing-koo tankaamparira narunaꞌ narunaꞌ panteꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Eeꞌnoko teing tenang Tanuaang Meekunge maantoꞌuruꞌ, eeꞌnoko oovuning karai kara tutumpariruꞌ Tanuaang Meekunge karantavuriko˜. ");
INSERT INTO nas_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tenang tee teke Jerusalemaꞌke niiꞌning nantoong Juꞌnupoong otorokoꞌ Kumponing-koo meeꞌduꞌpiariri otorokoꞌning kansiꞌkoo ookutunairu-eta paninga boonamenge otoromaing-eta. ");
INSERT INTO nas_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Eeꞌnoko tee aung aurong paning-etaing taaravaara tee karinga naroꞌ porora teke paapaaꞌarikoꞌ teing Kumponing-koo meeꞌduꞌpiariri porouꞌning ookara karanankai teing biikaninge kareaioꞌ taaravaara. ");
INSERT INTO nas_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Eeꞌnoko taꞌninai karakararearima asikovurikoꞌ aaꞌpaama, “Aing apeꞌ ookara eeꞌ kareaamatomaing Kaaleliꞌnupoong, eeꞌnoko arekeeꞌkoo niiꞌke narunaꞌ narunaꞌ niikanaꞌ osinaꞌ kareaako taaravarampimang, aing kara aaꞌninge: ");
INSERT INTO nas_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Paasiaꞌnaꞌ, Miidiaꞌnaꞌ, Iilamaꞌnaꞌ, Mesopotemiaꞌnaꞌ, Judiaꞌnaꞌ, Kapadosiaꞌnaꞌ, Poontusinaꞌ, eeꞌnoko Eesianaꞌ, Pirisiaꞌnaꞌ, Pampiliaꞌnaꞌ, Iisipiꞌnaꞌ, eeꞌnoko Liibiaꞌnaꞌ teꞌ Sairini-aapenooꞌ. Eeꞌnoko Roomaꞌnaꞌ karompimaing damisimainku oꞌnoring ookamuriiꞌka Juꞌnupoong eeꞌnoko niiꞌ damaꞌ Juꞌnuka. ");
INSERT INTO nas_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Napoꞌ niiꞌ Kiritiꞌ eeꞌnoko Arebia-nupoong tovange nariꞌ, taaravarampimang niikanaꞌ kareaama siraꞌpaako tee Kumponing bakaang nko-nko purintoꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eeꞌnoko ookara asikovurira paapaaꞌarikoꞌ biiꞌka aaꞌpeema, “Aung miruꞌ aming eeꞌ oroꞌ?” ");
INSERT INTO nas_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Teka niiꞌninge akapeuꞌaarima aaꞌpaarikoꞌ, “Aing uaini purintoꞌnaruꞌke maantoꞌantavaririning.” ");
INSERT INTO nas_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Teka Piita teing ninka nanaiꞌketa narung ninka nariꞌ deto donkonaara deto karoma daankivurima aaꞌpuruꞌ, “Diiꞌ Judiaꞌnupoong eeꞌnoko diiꞌ ookara Jerusalemaꞌ otorimaing enang tasiꞌperiiꞌnaang ioꞌ barorontarira nkaang kara-koo. ");
INSERT INTO nas_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aiꞌ aing teing naikaara kanuꞌariaꞌ teeꞌ diiꞌke noruꞌerimatomanaꞌ aung-koo mmeꞌ taneꞌ ninka-koo. ");
INSERT INTO nas_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Teka aung tee kapooꞌ teie Jooelie teie Kumponing-etaing nakaronarai˜ urikamuꞌ minkuvuuꞌnung aaꞌpuuꞌnooꞌka, ");
INSERT INTO nas_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Kumponinge aaꞌpumaang: Damaꞌke doong asiꞌning-koo eeꞌ nkoaravaing: Ninge nkaang Tanuaang piampampaing ookutunung nantoong-koo, eeꞌnoko diurukaaꞌ aaꞌning donkaang eeꞌnoko manikuꞌ tarampeeariaing˜ eeꞌnoko diikaning nemaaꞌke paning-etaning aampoonanka˜ ooaavaing eeꞌnoko diikaning pankareuꞌke noonenanka nooneaavai. ");
INSERT INTO nas_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eeꞌ, eeꞌnoko nkaning botovotonaaꞌnuka aaꞌning manikuꞌ eeꞌnoko donkaang teing-koo doong-koo nkaang Tanuaang piampanko tarampeeariaing. ");
INSERT INTO nas_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eeꞌnoko ninge taꞌnimpaariiꞌnanka oroꞌantavampaing aꞌdeiꞌke paning-koo, aaꞌnoaing: duaaꞌ mutaanampuai eeꞌnoko kaara ereng-pinaꞌ oroꞌparavai; ");
INSERT INTO nas_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Eeꞌnoko taaꞌniꞌantananka aꞌdoonge kansiꞌkoo aaꞌning oroꞌantavampai: ereng, ntaꞌ eeꞌnoko ii kamoꞌpinaꞌ Ovoring bakanaꞌmung dueꞌ poko doong pankaꞌmung ampaꞌpaaꞌnaꞌmung. ");
INSERT INTO nas_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eeꞌnoko tenang eeꞌ nkoaravaing: Baa tee Ovoring bakaang miring-koo eentavaravaing tee domamparavaing.’ ");
INSERT INTO nas_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Diiꞌ nantoong Isireeli-nupoong taaraveriaing aing karananka naurampiiꞌnaang otoining, tee Jiisuuꞌ Nasaretiꞌnung-koo. Diiꞌke tee noruꞌeri otong tee nko-nko purintoꞌnanka eeꞌnoko taꞌnimpaariiꞌnanka eeꞌnoko taaꞌniꞌantananka Kumponinge diiꞌkoo meuꞌke nkovuining Jiisuuꞌ bakaang birenge. Tee teeꞌ nkovuuꞌnanka diiꞌke noruꞌeriiꞌnaang tee Kumponinge botovuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tero Kumponinge tauraꞌpui miruꞌuuꞌnaꞌ diiꞌkoo bireng-koo sipuko diiꞌke oravitu ninka aaꞌbarataꞌkoo˜ taakaverioꞌ booꞌparuꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Teka Kumponinge deto daaꞌantavuuꞌnung unaa-antavuma booꞌke sisikeera ninka tankeꞌpui otoꞌketa, aiꞌ teie pinkaꞌkoo koontoꞌ makosi deeaꞌ bakei. ");
INSERT INTO nas_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Aiꞌ temuꞌka Deevitaꞌke Karistooꞌ miruꞌuma aaꞌpuuꞌnung, ‘Ninge Ovoring ookara batei-koo ning-ankoa dueꞌka ooamaung. Tee ning-koo tampavine-koo otoko ning duaꞌmaravaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Teeꞌkoo nkaang domang dotumaramaung menenge kenamarama, baruꞌnooꞌ nkaang mono damaꞌke tampaꞌ oꞌnoainaꞌ noruꞌmarama. ");
INSERT INTO nas_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Aiꞌ dake tee nkaang tanuaang daroveꞌeaꞌ tutueu otoꞌkoo, niiꞌnooꞌ ning dakaang naning meekung deraꞌkoo tauraꞌmeaukaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Dake tee ning tasiꞌantameing tevung domang-anta bakanavung. Noruꞌansi oꞌnong daꞌ ninka nariꞌ oꞌnoresi doturotue maantoꞌantameainaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ee aing mmarang, koontoꞌ tasiꞌparioꞌ naninge daang tampuaukaꞌnaꞌ minkuamaꞌnaang tee-koo Deevitaꞌkoo. Tee eeꞌnung aaꞌnouꞌnung booꞌparioꞌ dakoꞌauꞌ, eeꞌnoko dakoꞌauꞌnooꞌ tee niiꞌ ninka nariꞌ otong eꞌmung doong-koo basinooꞌke. ");
INSERT INTO nas_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Teka Deevitaꞌ tee nakaronara˜ deemparitaaꞌ Kumponing bakaang kara noruꞌukoꞌnung. Kumponinge mariarama Deevitaꞌ maraka-antavuuꞌnung bakanaving-koo narung oko-antavuuꞌnaang teꞌ bakanooꞌ baꞌnanui tareroma; tee aaꞌnung tee Kumponinge tero Pakoꞌpariꞌniiꞌ nantoong domampurira tarevuriaing. ");
INSERT INTO nas_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Teeꞌ eeꞌnaꞌ noruꞌuitaaꞌ teeꞌ minkvuuꞌnung tee Pakoꞌpariꞌniiꞌ daaꞌaravaing-koo, tee eeꞌnung tee daroveꞌuaruuꞌnung tutueu otoꞌkoo eeꞌnoko bakaang mono deraꞌoaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tee eeꞌnung, Jiisuuꞌ, Kumponinge booꞌketa daaꞌantavuuꞌnung eeꞌnoko niiꞌ teing tee-koong kara siraꞌnuka. ");
INSERT INTO nas_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Enang tee Kumponing-koo tampavine-koo tareroma baꞌnanui otong. Bauma-ita tee Tanuaang Meekung maraka-antavuuꞌnung nkavura teie piampuing niiꞌkoo enang oomererima taaramerererimaatomaing diiꞌke. ");
INSERT INTO nas_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aiꞌ Deevitaꞌ tee paning-koo deto koinuaruuꞌnung, teka teie eeꞌnunge aaꞌpuuꞌnung, ");
INSERT INTO nas_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","‘Teie Ovoringe nkaang Ovoring aaꞌpuuꞌnung, “Ning-koo tampavine-koo baꞌnaniai teing dakaning kare-nupoong dakaning kauꞌ patuꞌnuka deeng-antarerompainooꞌke basi.” ’ ");
INSERT INTO nas_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Diiꞌ ookarai Isireeli-nupoonge tasiꞌperi noruꞌeriaing tee tee Kumponinge naroꞌka aaꞌnoing nariꞌ Ovoring eeꞌnoko tee Pakoꞌpariꞌniiꞌ deeng-antavuing, tee eeꞌnung Jiisuuꞌ diiꞌke aaꞌbarataꞌkoo taakaveruꞌnung.” ");
INSERT INTO nas_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Enang tee teinge tee taaravaako teie domang tooꞌpuruꞌnung, eeꞌnoko aaꞌpaaruꞌ teing Piita dovang kara okovuri nkanuka, “Ee aing niiꞌmarang, niiꞌ arekeeꞌ nkomariiꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Eeꞌnoko Piitai aaꞌpuruꞌ teing, “Bereꞌdarira eeꞌnoko ntong-koo minkirarira meekaꞌantarariai diiꞌ ookara tee-koo Jiisuuꞌ tee tero domamuri taremuriainooꞌkoo Pakoꞌpariꞌniiꞌ bakaang miring-koo Kumponinge orakaꞌ nkonanka tontaꞌderuriainaꞌ eeꞌnoko diiꞌke tee avuavuꞌ tee Tanuaang Meekung nkaveriaing. ");
INSERT INTO nas_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Aiꞌ aung tee eeꞌnung avuavuꞌ diiꞌkoo maraka-antavuuꞌnung eeꞌnoko diurukaaꞌ eeꞌnoko ookara isipoꞌke otoromaing. Eeꞌnoko teing ookara teie Kumponinge niikaang Ovoringe tee-anko poꞌkoo bokuvuriaining oko-antavuriiꞌnaang tampuuꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Teie Piitai tee aaꞌnaꞌ napoꞌ siingoravurima teeꞌ pinauvuritaaꞌ daankivuruꞌ eeꞌ minkuvuma, “Domaang mooꞌdariai diiꞌ teieta kiimata-ita aing emuꞌnavarang koontoꞌ deeainge nkavaavaing-eta.” ");
INSERT INTO nas_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eeꞌnoko teing bakaang kara teꞌmung taaravaara, ntong-koo minkiarira meekaꞌantavarira, teing-koo tapoꞌariruꞌning naroꞌka beenaumo kokoreiꞌ. ");
INSERT INTO nas_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eeꞌnoko teing biiꞌka avariruꞌ aaꞌnooꞌnaang: kara okovuri nkanuka biikaang nau-anta taaravaama, naroꞌke navuariri, taamang nariꞌ tankaampeema kunsiarimatooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Eeꞌnoko nantoong ookara ookauꞌning asikovorouꞌ, kapooꞌnanka mmauꞌ taꞌnimpaariiꞌnanka eeꞌnoko taaꞌniꞌantananka teinge kara okovuri nkanukai nkoaako. ");
INSERT INTO nas_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ookara baito-nupoong naroꞌ navuariri kuneꞌeekoꞌ ookara biikaning kapooꞌ nariꞌ kompaama. ");
INSERT INTO nas_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eeꞌnoko teinge biikaning kapooꞌnanka kavonanka baaveaama tankaampauꞌ teing-koo ookara-koo ataꞌai otorokoꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Eeꞌnoko doong kante dootuuꞌnava pankava-koo nariꞌ berokoꞌ sisiuꞌpeeaꞌ, taamang nariꞌ pisiꞌeema biikanairu-koo domang doturotu ninka avusiroꞌariri. ");
INSERT INTO nas_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kumponing daangampaakoꞌ, eeꞌnoko nantoonge tampaꞌ noruꞌaarikoꞌ. Eeꞌnoko ookara doong-koo Ovoringe dootuuꞌnupoong mmauꞌantavurikoꞌ teing ninka domaang mooꞌarikoꞌning ninka. ");
INSERT INTO nas_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Niiꞌnaꞌmung kamunooꞌ Piita eeꞌnoko Jooni pava dootuuꞌnava pankava-koo beretuꞌ kunsi-koong bateinang-koo, duaaꞌ aveꞌarako. ");
INSERT INTO nas_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Eeꞌnoko naning kauꞌ doota pontoꞌaruꞌnooꞌketa teꞌ otokoꞌ. Tee eeꞌnung doong kante nkavai poroma sipaakoꞌnung karanaang pava dootuuꞌnava pankava-koo, miring Tampaꞌ Oroꞌnavarong tampaakoꞌnavarong-koo, baka-eentavaramaatooꞌnaang dootuuꞌnava pankava-koo koinaakoꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Eeꞌnunge Piita naanka Jooni dootuuꞌnava pankava-koo bereko oovureta eentavuretuꞌ kapooꞌ avureeꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Eeꞌnoko Piita naankai Jooni naapu narung oovuresi Piitai aaꞌpuuꞌ, “Neeꞌ oomereai.” ");
INSERT INTO nas_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Eeꞌnoko tee tenaanka-koo baroromparuꞌ eeꞌ noruꞌuma: Kapooꞌ amureeꞌnaang anaankai. ");
INSERT INTO nas_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Teka Piitai aaꞌpuuꞌ, “Aung ee, ning mooniꞌ otoꞌmemuaꞌ, teka kapooꞌ ning otoꞌmemuing aromaꞌnaang. Jiisuuꞌ Karistooꞌ bakaang miring-koo tee Nasaretiꞌnung daꞌ daaꞌdarara naniai!” ");
INSERT INTO nas_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Eeꞌnoko teie tampanaang-koo bireng-koo kompura deto iꞌampuko namuꞌke bakaang kauꞌ eeꞌnoko koposiina purimparuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Bera tee deto dinkitooꞌarara donkonui nanuuꞌ eeꞌnoko tumparuꞌ dootuuꞌnava pankava-koo tenaanka ninka nariꞌ, nanuma eeꞌnoko dinkitooꞌarama Kumponing daangampuma. ");
INSERT INTO nas_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kumponing daangampuma nanuko ookara nantoonge ooaara tee tasiꞌpauꞌ tee eeꞌnara baka-eentavaramaung Tampaꞌ Oroꞌnavarong-koo baꞌnanui dootuuꞌnava pankava-koo. ");
INSERT INTO nas_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Eeꞌnoko tee teing aaꞌnaꞌ taꞌnimpariruꞌ asikovoroma tee-koo kapooꞌkoo tee-koo nkoaruꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tenang tee kauꞌ doota taarevora Piita naanka-koo Jooni biꞌantavari beioꞌ ookara nantoong teing-anko nariꞌ aivitu-navaro-koo˜ miring Solomoniꞌ bakanavaro-koo kuaꞌparira dooroi tavuruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Eeꞌnoko tenang Piitai oovurira teing tee teka daankivuruꞌ aaꞌpuma, “Diiꞌ nantoong Isireeli-nupoong, aming-koo taꞌninirimang aung-koo, eeꞌnoko neeꞌ aming-koo tuutuuꞌanta narung oomererimaang? Aiꞌ eeꞌ noruꞌerima aung neekaang purintoꞌke eeꞌnoko aarumo meekaꞌpari otoꞌke kauꞌ taare-antavampesing? ");
INSERT INTO nas_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Teie Kumponinge niikakatauro Eebaraamiꞌ dovang, Aisakeꞌ, eeꞌnoko Jeekopiꞌ biikaange tee Jiisuuꞌ bakaang muuꞌ tarenung meenasi avuioꞌ aung tamparuꞌantavuing. Tee eeꞌnung Jiisuuꞌ diiꞌke Pailatiꞌanko beꞌantaveruꞌ, eeꞌnoko Pailatiꞌke unaa-anta-koo tampuioꞌ piaroriaruuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tee Jiisuuꞌ naning meekung eeꞌnoko koontoꞌ tee tompimperira naning tavuꞌnko piaroruꞌ Pailatiꞌke sing-antareruriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Eeꞌnoko diiꞌke tee Domaang Okonara dupisiꞌeruꞌ, teka tee eeꞌnung Kumponinge domang-antavuuꞌ booꞌketa. Neeꞌnaanka tee-koong kara siraꞌka. ");
INSERT INTO nas_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Eeꞌnoko teie bakaang miring purintoꞌke masikaꞌantavampirioꞌ aung naning puring-antavuing ooverima tasiꞌperimatomaung. Eeꞌnoko teie eeꞌnunge masikaꞌantai Jiisuuꞌketainge aung naning ookutuarioꞌ taare-antavuing diiꞌkoo ookara-koo dutakanooꞌka. ");
INSERT INTO nas_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Emuꞌ tee diiꞌ mmarang, ninge noruꞌdampiring diiꞌke tee noruꞌeriaꞌ teeꞌ nkoveruꞌnung teing ninka diikaning ovontunanka ninka. ");
INSERT INTO nas_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Teka tee kapooꞌ Kumponinge tero siraꞌpuuꞌnung bakaning nakaro-nupoong biikaang karange, tee eeꞌnung domamuriainooꞌkoo Pakoꞌpariꞌniiꞌke baike kuneꞌuaing teeꞌ nariꞌ dupe-antavuieeng. ");
INSERT INTO nas_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Eeꞌnoko enang tee Kumponing-koo bereꞌdariaing diiꞌ teing diikaang orakaꞌ nkonanka piuꞌderuriainaꞌ eeꞌnoko napoꞌ unaa-anta Ovoring-eta komperiai batei makotuko. ");
INSERT INTO nas_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Teeꞌ nariꞌ bereꞌdariri otoriko botovuaing tee naning Pakoꞌpariꞌniiꞌ diiꞌ domang-anta-koo miruꞌuuꞌnung, tee eeꞌnung Jiisuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Enang tee paning-koo otomatooꞌnaang bera tee batei Kumponinge ookara kapooꞌ nerakaꞌantavuainooꞌke basi teeꞌ maraka-antavuuꞌnaꞌ bakaning meekupoong nakaronuka biikaang karange uripoꞌketa. ");
INSERT INTO nas_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Aaꞌnung Moosesie tee minkuarama niikakatauro aaꞌpuruꞌ, ‘Ovoring Kumponinge tee narung nakaronara donkong-antareruriaing diiꞌkoo damaꞌnavarang-koo meuꞌke, teeꞌ nariꞌ ning donkong-antamuuꞌnaꞌ, eeꞌnoko diiꞌke bakei taaraverimaatoaing teing kapooꞌ naururiaining. ");
INSERT INTO nas_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Eeꞌnoko teing nantoong ookara narunaꞌ narunaꞌ tee eeꞌnung nakaronara taaravaavaukaꞌning bakaning nantoong-eta simpeꞌuriaing.’ ");
INSERT INTO nas_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Eeꞌnoko Moosesi narung deeaꞌ, napoꞌ ookara nakaro-nupoonge Samuelaꞌketa doompeto Kumponinge karantavurikoꞌninge˜ kara eꞌmunung doong-koong siraꞌpauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ooveriko, Ovoring bakaang maramaraka tee diiꞌ diikaang, aaꞌning teing bakaning nakaro-nupoong biurukaaꞌ, eeꞌnoko teing okoꞌbosiꞌnuka diikakatauro biiꞌdompenku. Eeꞌnoko tee kara maramaraka Kumponinge Eebaraamiꞌkoo naroompuuꞌnaare Jiisuuꞌ miruꞌuitaaꞌ eeꞌ minkuvuuꞌ, ‘Daꞌdompenge ookara kansiꞌnupoong amutemuriiꞌ nantoong biraankevuriaing.’ ");
INSERT INTO nas_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kumponinge Jiisuuꞌ, bakaang muuꞌ tarenung, tutung diiꞌkoo botovuuꞌ diiꞌ ookara narunaꞌ narunaꞌ diikaang orakaꞌ nkonanka-ita bereꞌantarurira biraanke-antaruriiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Eeꞌnoko tenang Jooni naankai Piita teing nantoong karavaareko teing piristiꞌnanka eeꞌnoko pava dootuuꞌnava pankava orokovui tarenuka˜koong boreꞌ eeꞌnoko teing Noruꞌ Pitunavitu˜ teꞌ tenaanka-anko porouꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Porora teing aaꞌnaꞌ iiravorouꞌ taaravaara tenaankai Jiisuuꞌ daankivurema nantoong booꞌketa daaꞌariaing minkuvureko. ");
INSERT INTO nas_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Eeꞌnoko aaꞌnaꞌ kamunooꞌuioꞌ teinge tenaanka daiꞌaareta kiimatanavaꞌkoo sipaaretuꞌ bera daunaꞌmung-koo basinooꞌ otoreeꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Teka mmauꞌke tenaanka-koo tee kara taaravauꞌninge masikaꞌantavauꞌ. Eeꞌnoko deerunooꞌkoo teing nantoong bereꞌariruꞌning paꞌnokoꞌ kokoreiꞌkoo˜ basi. ");
INSERT INTO nas_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Teketa daunaꞌmung Juꞌnupoong koompaaraꞌnavitu naroꞌariruꞌ aaꞌning tarenuka, pankenanka eeꞌnoko boto naunuka. ");
INSERT INTO nas_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aanasi, tee ookara-koo dau basi piristiꞌ, eeꞌnoko teing donkaang tee ninka Kaiapasi, Jooni eeꞌnoko Aleksandaꞌ narung puataꞌkooning nariꞌ porouꞌ teꞌ Jerusalemaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Eeꞌnoko tenang teinge tenaanka meuꞌ baꞌnang-antavaareta niaꞌaarekoꞌ aaꞌpaarema, “Iriꞌ eeꞌnoko miring baa bakaange tee aung amuriiꞌ nkoveremang deeꞌke?” ");
INSERT INTO nas_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Teketaꞌ tee Piita Tanuaang Meekunge maantoꞌui aaꞌpuruꞌ teing, “Diiꞌ tarenuka eeꞌnoko nantoong-kooning pankenanka, taaramerereriai. ");
INSERT INTO nas_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Diiꞌke eꞌmung niiꞌnaꞌ noruꞌerima tuutunamererimaatomaung deekoꞌ kapooꞌ tampara nkoampetuꞌnung-koo aung-koo kauꞌ doota-koo, eeꞌnoko teeꞌ taarevouꞌnaꞌ noruꞌkoo piaroriko deekoꞌ makosi. ");
INSERT INTO nas_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Naurarampiko tee aung tasiꞌperiaing diiꞌke eeꞌnoko ookarai Isireeli-nupoonge tee Jiisuuꞌ Nasaretiꞌnung tee Domamuri Taremuriainooꞌkoo Tero Pakoꞌpariꞌniiꞌ bakaang miring ninka teeꞌ nkoampesing. Tee eeꞌnung, diiꞌke aaꞌbarataꞌkoo dupisiꞌeriko Kumponinge booꞌketa daaꞌuuꞌnung, tee bakaang iriꞌke aung naning diiꞌkoo dutakanooꞌke tampaꞌ otoi donkonui otong. ");
INSERT INTO nas_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Daari Meekunge tee naning Pakoꞌpariꞌniiꞌ miruꞌui eeꞌ minkuvuuꞌnung, ‘Areꞌ eeꞌnareꞌ kapanareꞌ diiꞌke pava kaninukai pooreꞌerima duaꞌeruꞌnareꞌ enang ookutunava-koo eꞌmanianareꞌ tumanareꞌ deemparioꞌ tasiꞌperiaing!’ ");
INSERT INTO nas_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Eeꞌnoko niiꞌnung domaang mooꞌmuripeuꞌnung otoaꞌ, Jiisuuꞌ narung. Bakei, ookutunairu-koo paning-koo boonameng-koo niiꞌnung otoaꞌ bakaang miring bokuampiko domamuripeuꞌnung.” ");
INSERT INTO nas_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Enang tee teinge tenaanka Piita naanka eeꞌnoko Jooni avororeaꞌ deravareko ooaareta taꞌninauꞌnung, tamunsiꞌnaanka, tampaꞌ barearearuuꞌnaanka-pinaꞌ noruꞌaarema. Teketa tasiꞌpaaretuꞌ Jiisuuꞌ ninka nariꞌ otorekoꞌnaanka. ");
INSERT INTO nas_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Teka tee naning taarevouꞌnung tenaanka-koo dueꞌ donkonuioꞌ ooaama teinge kapooꞌ minku-koo makosiaavaruuꞌ tenaanka tooꞌdeng-koo. ");
INSERT INTO nas_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bera koompaaraꞌnavitue damaꞌdu botoaareta biiꞌka makenge minkuarima aaꞌpauꞌ, ");
INSERT INTO nas_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Arekeeꞌ nkoarampiiꞌnaang niiꞌke anaanka? Aiꞌ ookara Jerusalemaꞌnupoonge tee noruꞌai otong taꞌnimpaariiꞌ pankaing nkovuresing, eeꞌnoko niiꞌke penkempampiarupeuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Teka nantoong-koo avitoitoi beremparavarooꞌnaang deekoꞌ potearampiaing anaanka napoꞌ aung ninka miring ninka naning karavureaukaꞌnaꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Teketa tee napoꞌ bokuaareta poteaaretuꞌ koontoꞌ minkuvurearooꞌnaang eeꞌnoko nau-antavaarearooꞌnaang Jiisuuꞌ bakaang miring-koo. ");
INSERT INTO nas_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Teka Piita eeꞌnoko Jooni naankai makuꞌaarema teing aaꞌpaaretuꞌ, “Arekeeꞌ tampaꞌ, diiꞌ nantoong taara-koo aiꞌ Kumponing? Kumponing-koo dutakanooꞌka makuꞌnaꞌ enang noruꞌeriai. ");
INSERT INTO nas_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Neeꞌke niiꞌnaꞌ bereꞌkoo makosi deeaꞌ, teka teeꞌ nariꞌ taaravampema ooampetuꞌnaꞌ minku-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Teketa teinge tee sisikeera avaarepeuꞌnaꞌ papaaravauꞌ, ookarai nantoonge Kumponing daangampaako tee-koo nkoaruꞌnung-koo. Eeꞌnoko aaꞌnaꞌ avoroꞌantavaareta sipaaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aiꞌ tee aung naning taꞌninaꞌ taarevouꞌnung tee bakaning mareꞌ karenaumo kivora divuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Teketa tee Piita eeꞌnoko Jooni sipaaresioꞌ beeꞌmaikororiꞌanko bereta nauaaretuꞌ kapooꞌ teinge piristiꞌnuka-koo ovontunge eeꞌnoko nantoong-kooning pankenankai minkuauꞌning. ");
INSERT INTO nas_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eeꞌnoko tenang teinge taaravaara tee teing deto aaꞌnaꞌ nariꞌ kareauꞌ Kumponing-anko aaꞌpaama, “Ovoring, daꞌ Kumponing ookara kapooꞌ nkoveuꞌnung aaꞌnimpoꞌ, paning eeꞌnoko kansiꞌ eeꞌnoko pirung. ");
INSERT INTO nas_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Dake Tanuaang Meekung ninka temuꞌnung niuma Deevitaꞌ, dakaang muuꞌ uripoꞌ tarevukoꞌnung, karantavema aaꞌpeuꞌ, ‘Aming-koo teing akovituri iira ninka daaꞌarimang? Aming-koo nantoong orakaꞌ makotuaꞌnaꞌ nko-koo maroarimaunge! ");
INSERT INTO nas_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ookara dauraronanka kansiꞌkoo otoromaing tavuꞌkoo maamuariri otorong. Pankenuka naroꞌarira otorong tee Ovoring turang-koo eeꞌnoko tee tero Pakoꞌpariꞌuuꞌnung nantoong domampuri tarevuriainooꞌkoo.’ ");
INSERT INTO nas_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Masikaꞌ minkueing, aaꞌnoing Eerotiꞌ eeꞌnoko Poontiasi Pailatiꞌ, Juꞌnupoong eeꞌnoko akovitu nariꞌ tapoꞌariring aung-koo osi pankaing-koo Jiisuuꞌ turang-koo, tee dakaang muuꞌ tare-koo dake pakoꞌpariꞌeuꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Teing naroꞌariring nko-koo ookara kapooꞌnanka dake dakaang iriꞌke eeꞌnoko piai tero miruꞌeuꞌning tavoꞌaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Enang tee mauꞌmauꞌmaariko ooverira Ovoring iriꞌ ameriaing dakaning botovotonaaꞌnuka dakaang kara amorompiaꞌ siraꞌpampiainaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Eeꞌnoko dakaang bireng tovoroꞌdaravaing nantoong taare-anta-koo, eeꞌnoko taaꞌniꞌantananka taꞌnimpaariiꞌnanka nko-antamemuriai tee dakaang botovotonaaꞌkoo kuunge miring Jiisuuꞌ tampampiko.” ");
INSERT INTO nas_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Enang tee kunsi bakeariko teꞌ eeꞌnooꞌ teing oosiariruꞌnooꞌ danuꞌarako ookara Tanuaang Meekunge maantoꞌuruꞌ, teketa Kumponing bakaang kara siraꞌpaakoꞌ avoreaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Enang tee tevitu ookutunavitu masikaꞌanta-poꞌnavitu domang nariꞌ noruꞌarima nariꞌ mantomparikoꞌ. Naninge eeꞌ tampuaꞌ: Kapooꞌ ning otoꞌmemuining ninka nkaning, teka teing ookara kapooꞌ nariꞌ otoꞌevorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Eeꞌnoko tee ninka iriꞌ pankaing ninka teinge kara okovuri nkanukai Ovoring Jiisuuꞌ booꞌketa domamparuꞌnaꞌkoong kara ooauꞌnaꞌ siraꞌpauꞌ, eeꞌnoko ookara biraanke-poꞌnupoong deempariruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Naning kapooꞌkoo ataꞌoiꞌ otoaruuꞌ teing-koo meuꞌke, aiꞌ teinge ookarai aaꞌnong teing kansiꞌpoꞌnupoong eeꞌnoko pavapoꞌnupoonge kanteariri baaveaama mooꞌnooꞌ nkavaama kara okovuri nkanuka-anko tavoꞌaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Eeꞌnoko teing narunaꞌ narunaꞌ biiꞌka tankaampeekoꞌ ataꞌoinku-koo. ");
INSERT INTO nas_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Narung pakupaku nkovukoꞌnung tee Josepaꞌ, niiꞌnaꞌ “Banabasi” kara okovuri nkanukai tampauꞌnaꞌ (miruꞌnooꞌ: domang kuaaꞌanta bauko) Liivaiꞌ bakanarempoꞌkoong, Saiparasi-namuiꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Teie eeꞌnunge kansiꞌnameng baavevura mooniꞌ kara okovuri nkanuka-anko tavoꞌuuꞌ tankaampaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Teka narung naning miring Ananaiasi teni ninka baꞌaang Sapaira, teringe kansiꞌkoo niiꞌnooꞌ baavevuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Eeꞌnoko Ananaiasi, baꞌaange noruꞌui otoko, niiꞌning pinkaꞌura eeꞌnoko niiꞌning kara okovuri nkanuka-anko tavoꞌuuꞌ ookutunung mooꞌ tampuma. ");
INSERT INTO nas_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Teka Piitai aaꞌpuuꞌ, “Ananaiasi, aming-koo daꞌ Sietaniꞌke domang maantoꞌkoo tauraꞌdaring Tanuaang Meekung tosieeꞌnaang mooniꞌkoo niiꞌning pinkaꞌei kansiꞌ baaveveieeng-koong? ");
INSERT INTO nas_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tenang mmeꞌ baaveveaꞌ tevoraꞌ tee daꞌ narung okorui otokoꞌnung. Eeꞌnoko baaveveieenooꞌketa tee mooniꞌ tee dakaang, daka piaropeuꞌnaꞌ nkovepeuꞌ. Naninge eturuarupeuꞌ aꞌ tavoꞌkoo. Eeꞌnoko arekeeꞌkoo dakaang domange teeꞌ matauei? Aiꞌ dake tee naning tosieaꞌ, teka Kumponing tosieing.” ");
INSERT INTO nas_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tenang Ananaiasie teing kara taaravura tee teꞌ doonko booꞌ duaꞌaruꞌnung. Eeꞌnoko teing nantoong taaravauꞌning aaꞌnaꞌ avoreauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Teketa nemaaꞌ daaꞌarira mono nopaꞌaara nkavai berora dakoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Damaꞌke beenaumo aua-pinaꞌ tankinuko baꞌaang teꞌ tavoꞌkuuꞌ noruꞌuaꞌ kapooꞌ nkoaruꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Eeꞌnoko Piitai aaꞌpuuꞌ teni, “Naumeai, deeꞌke ee masikaꞌ kansiꞌ aing-koo mooniꞌ anke otoining-koo makosi baaveveresieeng?” Eeꞌnoko tenie aaꞌpuuꞌ, “Eeꞌ, teing-koo makosi.” ");
INSERT INTO nas_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Teka Piitai aaꞌpuuꞌ teni, “Deeꞌke arekeeꞌkoo nariꞌ mataueresing Tanuaang Meekung Ovoring bakaang paara-koo? Taaraveai daꞌung dakoꞌkoo beroining-koong kumpikumpiring, enang toroarima karanaang basiarimang. Teinge eeꞌninge napoꞌ daꞌ nkaraavaꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Teketa namuꞌke teni teꞌ doonko kauꞌkanooꞌ booꞌ duaꞌaruꞌ. Eeꞌnoko teinge nemaaꞌke poroma booꞌparioꞌ ooaara oko-aape nkavai berora dakoꞌauꞌ baꞌung-koo nameng-aape. ");
INSERT INTO nas_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eeꞌnoko avoꞌavoroꞌ pankaing tavoꞌkuuꞌ teing-koo ookara-koo dootuuꞌnupoong-koo eeꞌnoko napoꞌ teing-koo tang taaravauꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Enang tee teinge kara okovuri nkanukai mmauꞌ taaꞌniꞌantananka eeꞌnoko taꞌnimpaariiꞌnanka nkoaakoꞌ nantoong-koo meuꞌke, eeꞌnoko teing ookutunavitu dootuuꞌnava pankava-koo Solomoniꞌ bakanavaro aivitu˜navaro-koo teke nariꞌ kuneꞌeema otorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Niiꞌning teing-anko poꞌkoo avoreaakoꞌ, teka bane avoreaama nantoonge deto aaꞌnaꞌ nariꞌ noruꞌaarikoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eeꞌnoko niiꞌninge masikaꞌantavaama dau-eta dau Ovoring-koo tampoꞌarikoꞌ, miatara, aaꞌnoko donkaang eeꞌnoko manikuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Teeꞌ nkoarima teinge siipa-poꞌnupoong taung sionairu-koo nkavaari poroma batanang-koo eeꞌnoko taniꞌ dovang-koo bempaarikoꞌ Piitai teke tankinuma tamung uuꞌaaꞌ narunge deekoꞌ, dakaꞌantavuriko taarevorooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Eeꞌnoko napoꞌ nantoonge osi okiꞌnarekaꞌketa Jerusalemaꞌ koroai otoroining-eta siipa-poꞌnupoong poꞌantavaarikoꞌ eeꞌnoko maꞌnari orenge koriaarikoꞌning, eeꞌnoko ookara nariꞌ taarevorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Teka piristiꞌ deto basi daaꞌaruꞌnung bakanavitu Noruꞌ Pitunavitu ninka mamairoi maantoꞌuri. ");
INSERT INTO nas_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eeꞌnoko teing kara okovuri nkanuka daiꞌaarira kiimatanava-koo tamung sipaarimanooꞌ sipaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Teka muunganang Ovoring bakaang koosinunge karanaang kiimatanava-koong daateꞌura damaꞌdu sing-antavuruꞌ teing, eeꞌnoko aaꞌpuruꞌ, ");
INSERT INTO nas_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Berira donkoniriaing teꞌ pava dootuuꞌnava pankava-koo eeꞌnoko nauereriaing nantoong ookara minkunaa aung amuriiꞌ nerakung otootoꞌkoong.” ");
INSERT INTO nas_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Eeꞌnoko tenang teinge teeꞌ taaravaara taneꞌke tero oraꞌka pava dootuuꞌnava pankava-koo berora nau-antavaarikoꞌ teke. Enang piristiꞌ deto basi bakanooꞌ kara simpeꞌdoma pouꞌ teing ninka nariꞌ otorokoꞌning ninka, teketa koompaaraꞌnavitu bokuaaruꞌ, teing ookara boreꞌnuka Isireeli-nupoong tarenuka, eeꞌnoko kiimatanava-koo botoaaruꞌ kara okovuri nkanuka poꞌantavaariiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Teka tenang piatooronanka˜ porora teka kiimatanava-koo ooaariaꞌ, eeꞌnoko toroarira teeꞌ minkuauꞌ ooaariaruuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Aaꞌpauꞌ, “Niiꞌke kiimatanava tampaꞌ pinkaꞌarioꞌ ooampiring, eeꞌnoko tanatavaamaing karanaange donkonaioꞌ, teka tenang daateꞌampirinang narung naning otoaꞌ kuunge.” ");
INSERT INTO nas_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Enang tee teie teing piatooronuka dootuuꞌnava pankava tareaakoꞌning-koong boreꞌke eeꞌnoko piristiꞌkoo pankenge taaravaara teing aing karananka teing papaaravariruꞌ teing-koo. Paapaaꞌarima aaꞌpaakoꞌ, “Aiꞌ pa arekeeꞌ nkoaraaꞌnaang?” ");
INSERT INTO nas_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Eeꞌnoko niiꞌnunge pora aaꞌpuruꞌ, “Teing nantoong diiꞌke kiimatanava-koo siperereruꞌning pava dootuuꞌnava pankava-koo donkonai nau-antavaarimaang nantoong.” ");
INSERT INTO nas_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Teketa teing piatooronuka biikaang boreꞌ siompai berora bokuaaruꞌ teing, teka tokoonaꞌ nkoaariaꞌ avoreai nantoonge kapange tooꞌpaariꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Eeꞌnoko teinge poꞌantavaarira koompaaraꞌnavitu-koo uroꞌkanooꞌ donkong-antavaaruꞌ. Bera piristiꞌ deto basie niaꞌurima aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Niiꞌke bakei koontoꞌ poterarampirieeng diiꞌ tee aung miring-koo nau-antarariarooꞌnaang. Teka diiꞌke maantoꞌantavering aung Jerusalemaꞌnameng teie diikaang naunaue, eeꞌnoko diiꞌke niiꞌ tuumpi-koo keiꞌdorimang aung naning bakaang booꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Teka Piitai eeꞌnoko teing niiꞌning kara okovuri nkanukai makuꞌaama aaꞌpauꞌ, “Niiꞌ aaꞌ tee Kumponing-koo narung-koo arooꞌmariiꞌnaang, naning-koo deeaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Teie Kumponinge niikakatauro biikaange daaꞌantavuuꞌnung tee Jiisuuꞌ diiꞌke dupisiꞌeruꞌnung aaꞌbarataꞌkoo biꞌerira. ");
INSERT INTO nas_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kumponinge pankaing-antavuuꞌnung deto tee-koo tampavine-koo sipura nantoong biikaang Ovoring eeꞌnoko Domang-anta deemparaaꞌnaang teketa diiꞌ Isireeli-nupoong pakururioꞌ bereꞌdariko orakaꞌ nkonanka tontaꞌderuriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Eeꞌnoko niiꞌ teing kara siraꞌnuka aing-koo kapooꞌnanka-koo tee ninka Tanuaang Meekung ninka nariꞌ, tee eeꞌnung Kumponinge avuruꞌnung teing siompaamaing.” ");
INSERT INTO nas_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tenang teinge ovorooꞌnukai teeꞌ taaravaara teing iirai puruꞌantavurioꞌ teing dupisiꞌkoo piavorouꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Teka teing-koo narung Boto Keperuuꞌnavitu˜koong miring Kameliele otokoꞌ ookarai nantoonge tampaꞌ noruꞌaamaung. Bera tee teing-koo koompaaraꞌnavitu-koo meuꞌke donkonura aaꞌpuuꞌ, “Aing nantoong damaꞌdu sing-antaverereriai ioꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Eeꞌnoko teie aaꞌpuruꞌ teing ovookaꞌnuka, “Diiꞌ Isireeli-nupoong, tampaꞌ tarerariai aing-koo kapooꞌ orara nkoveriꞌneeng. ");
INSERT INTO nas_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tero tee naning Tuudas donkonura baka daangamparakoꞌnung pankaing tamparama, eeꞌnoko karingai donkaange deerunooꞌ karenaumo daakuꞌke siompaakoꞌ. Teka tee tavaako tee teing tee siompaakoꞌning avitoitoi purarenkaꞌarira paaꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tee-koo damaꞌke Judasi Kaaleliꞌnung napoꞌ donkonuuꞌ tenang Siisaꞌke nantoong deeruvurikoꞌnang, eeꞌnoko teie niiꞌning barampuruꞌ. Eeꞌnoko tee napoꞌ teeꞌ booꞌparuꞌ eeꞌnoko teing ookara tee siompaakoꞌning purarenkaꞌariruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Teeꞌkoo ninge enang diiꞌ aung kapooꞌ enang tavoꞌkuing-koo naurampimang, dontaꞌdariri otoriaing aing-eta nantoong-eta, siperereriko biiꞌka otoroai. Aing kapooꞌ ainge maroaama nkoaamatomaing naning-etaing deekoꞌ teing duaꞌaravaining. ");
INSERT INTO nas_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Teka teing Kumponing-etaing deekoꞌ diiꞌke teing duaꞌanta-koo makosi deeaꞌ. Teeꞌ nkorarima deekoꞌ Kumponing ninka turaniꞌnanka deentariiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bera tee bakaang kara tampaꞌ taaravaara teing kara okovuri nkanuka kuung bokuaarira muraꞌaarima poteaaruꞌ Jiisuuꞌ bakaang miring-koo kapooꞌ minkuaavarooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Teketa tee koompaaraꞌnavitu-ankoita berouꞌnung dotuariritaaꞌ Kumponinge tauraꞌpuruꞌnung-koo mankiꞌ nkavaavaꞌnaang bakaang miring-koo. ");
INSERT INTO nas_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Eeꞌnoko doong kante pava dootuuꞌnava-koo eeꞌnoko nantoong biikaning pavananka-koo nau-anta-koo sipariarukoꞌ daankiaama Jiisuuꞌ tee naning Kumponinge tero Pakoꞌpariꞌuuꞌnung˜ nantoong domampuri tarevuriainooꞌkoo. ");
INSERT INTO nas_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tenang eeꞌnang tee batei-koo Juꞌnupoong Jiisuuꞌ siompaakoꞌnavitu karinga deempariruꞌ, teing-koo nariong Kirikiꞌnaꞌ kareaakoꞌning eeꞌnoko nariong Iiburu-naꞌ, eeꞌnoko teing Kirikiꞌnaꞌ kareaakoꞌninge teing Iiburu-naꞌ kareaakoꞌning minkuminkuaarikoꞌ aaꞌpaama, “Niiꞌkooning manikuꞌ naaroonku tampaꞌ pakuaariarukooꞌ doong kante kapooꞌ tankaampaama.” ");
INSERT INTO nas_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Eeꞌnoko teinge nanaiꞌketa kenaankai ookara Jiisuuꞌ siompaakoꞌning naroꞌ bokuaarira aaꞌpaaruꞌ, “Niiꞌke Kumponing bakaang kara daankiampimaung tamung siꞌkoo makosi deeaꞌ taamang bantoꞌarampima. ");
INSERT INTO nas_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Teeꞌkoo diiꞌke mmaikoriꞌke ˜kenaanka-taa nantoong diiꞌkooning niiꞌning miruꞌereriaing Tanuaang Meekunge eeꞌnoko mataue maantoꞌnuka tasiꞌpereritaaꞌ, teing eeꞌning aung-koo amuriiꞌ nko-nko-koo siparampiaining. ");
INSERT INTO nas_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Teka niiꞌ tee kunsi-koo eeꞌnoko Kumponing bakaang kara nau-anta-koo amariaing.” ");
INSERT INTO nas_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Eeꞌnoko teie karai minkuauꞌnunge ookara karinga dotu-antavuruꞌ, bera teinge aing aaꞌning tampaaruꞌ: Sitiveni, naning baito eeꞌnoko Tanuaang Meekunge maantoꞌ, teketa Pilipiꞌ, eeꞌnoko Porokorus, eeꞌnoko Naikena, eeꞌnoko Tiimon, eeꞌnoko Paramenas, eeꞌnoko Nikolas, tee naning damaꞌ Juꞌ, Antiokoꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Teing aing eeꞌning kara okovuri nkanuka-anko uroꞌkanooꞌ donkong-antavaariko teinge kunsiaaruꞌ tankaꞌ panteꞌaarira teing-koo. ");
INSERT INTO nas_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eeꞌnoko teeꞌ nariꞌ Kumponing bakaang kara kato beremparuꞌ eeꞌnoko Jiisuuꞌ siompaakoꞌnavitu aaꞌnaꞌ mmauꞌariruꞌ teke Jerusalemaꞌke, eeꞌnoko mmauꞌ piristiꞌnanka arooꞌariruꞌ Jiisuuꞌ baito-koo. ");
INSERT INTO nas_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Eeꞌnoko Sitivenie tee, Kumponing aaꞌnaꞌ masikaꞌantavuitaaꞌ eeꞌnoko iriꞌke maantoꞌui taaꞌniꞌantananka eeꞌnoko taꞌnimpaariiꞌnanka nkovukoꞌ nantoong-koo meuꞌke. ");
INSERT INTO nas_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Teka niiꞌninge nantoonge daaꞌarira Sitiveni turampaakoꞌ. Teing Juꞌ niiꞌnooꞌnupoong biikaang pava dootuuꞌnava-koo dootuuꞌarikoꞌning Kiimata-ita Simpiriꞌantaniiꞌnanka Biikanava tampaakoꞌnava-koo. Teing eeꞌning Sairini-nupoong eeꞌnoko Aleksandaria-nupoong eeꞌnoko Silisia-nupoong eeꞌnoko napoꞌ Eesia-nupoong. ");
INSERT INTO nas_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Teka Tanuaang Meekunge kakeꞌii-antavui Sitiveni karantavuko˜ makosiaavarukoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Teketa tenang teinge niiꞌning nantoong makenge etuaaruꞌnung tosiarima aaꞌpaavaꞌnaang, “Niiꞌke taaravampirioꞌ teie Kumponing orakaꞌ minkuvuing, eeꞌnoko Moosesi.” ");
INSERT INTO nas_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eeꞌnoko terionge tee tosi-koong minkuminkuru aaꞌnaꞌ berempauꞌnung meuꞌke nantoong-koo, eeꞌnoko biikaning pankenanka-koo eeꞌnoko boto naunuka-koo bera aaꞌnaꞌ iiravorouꞌ. Eeꞌnoko teing Sitiveni-anko porora tee baransiiꞌaara koompaaraꞌnavitu naroꞌariruꞌnooꞌ tavoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bera tee daang-koong karananka masikeng-pinaꞌ donkong-antavaaruꞌ aaꞌpauꞌning, “Aunge naninge uatepa ava pava dootuuꞌnava pankava meekava orakaꞌ minkuvumaung eeꞌnoko tee boto Moosesi-nung. ");
INSERT INTO nas_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Aiꞌ niiꞌke tee taaravampirioꞌ minkuvuma aaꞌpumaung: Teie Jiisuuꞌ Nasaretiꞌnunge ava derovura toomonanka Moosesie amuruꞌnanka aampariꞌantavuai.” ");
INSERT INTO nas_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eeꞌnoko ookara koompaaraꞌnavitu teke baꞌnampariruꞌninge ooai otoko bakaang oing koosinung˜pinaꞌ oroꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Eeꞌnoko piristiꞌ deto basie aaꞌpuuꞌ, “Teeꞌ ee masikaꞌ minkuaamang?” ");
INSERT INTO nas_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Eeꞌnoko Sitivenie aaꞌpuuꞌ, “Diiꞌ mmataraang eeꞌnoko mmarang, ioꞌ taarameriaing ning. Tee Kumponing meenasi-poꞌnung Eebaraamiꞌkoo niuma-koo oroꞌparuꞌ Mesopotemiaꞌ otoko Aaraniꞌaape mmeꞌ tenkenuaruko. ");
INSERT INTO nas_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kumponinge aaꞌpuuꞌ tee, ‘Tenkeniaing anketa dakanooꞌketa kansiꞌketa, dakanamuiaang-ankoita, eeꞌnoko ninge naurampainameensiꞌkoo beaing kansiꞌkoo.’ ");
INSERT INTO nas_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Teketa Kaldea-nupoong biikanameensiꞌketa tenkenura tee bera Aaraniꞌnamono-koo otokoꞌ. Eeꞌnoko teketa bauma booꞌparioꞌ damaꞌke Kumponinge botovuuꞌ teketa aaꞌ eeꞌnooꞌ ameensiꞌkoo niiꞌ enang oꞌnorinooꞌ pooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Teka ameensiꞌkoo navaro oko-antavuaꞌ, okiꞌnooꞌ aaꞌnooꞌ mukuꞌnooꞌ otoaꞌ. Teka tamung maraka-antavuuꞌnung damaꞌke teing ninka baꞌdompenku ninka doompeto damaꞌke tavoꞌkaavaining ninka nariꞌ kompaavaꞌnaang bane bauring mmeꞌ otoaruko. ");
INSERT INTO nas_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Eeꞌnoko Kumponinge eeꞌpinaꞌ nauvuuꞌ, ‘Daurukaaꞌ teing damaꞌke tavora-nupoong otoroaining oovuning biikanooꞌke, teke teing-koo daiꞌnisinuka deempariri otoromaatoaing orakaꞌ nkoaariko karenaumo daakuꞌ mareꞌkoo. ");
INSERT INTO nas_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Teka ninge kiimatavarampaing teing tevitu daꞌdompenku tang mooꞌdopa-koo mintoong-antavaariainavitu. Eeꞌnoko teketa tenkenaaraiꞌnange ning anke ameensiꞌkoo porora dootuuꞌmaamatoaing.’ ");
INSERT INTO nas_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Kumponinge teeꞌpuraiꞌnange teie napoꞌ kara naroong-antaevuuꞌ dopaꞌ totoꞌnaveu-koong. Eeꞌnoko teeꞌkoo Eebaraamiꞌ Aisakeꞌ bauma deemparara dopaꞌ napuꞌuuꞌ bakaning doong ˜beenang-taa basiarako. Eeꞌnoko Aisakeꞌ tee Jeekopiꞌ bauma deemparuꞌ eeꞌnoko Jeekopiꞌ tee temaiaꞌ nanaiꞌketa kenaanka muuꞌkoo okoꞌbosiꞌnamaiaꞌ biuma deemparuꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Eeꞌnoko temaiaꞌ okoꞌbosi-namaiaꞌ Josepaꞌkoo mamairoarira baaveauꞌ tee Iisipiꞌaape, teka Kumponing tee tee ninka nariꞌ otokoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Eeꞌnoko tee unaa-antavukoꞌ teing-eta bakaning arikananka-ita. Eeꞌnoko Kumponinge Josepaꞌ aaꞌnaꞌ matau deeng-antavuioꞌ Peeroꞌke, teie Iisipiꞌnunge dauraronge˜, tampaꞌ oovura ovoꞌmaꞌ deeng-antavuuꞌ Iisipiꞌnameensiꞌkoo eeꞌnoko bakanavaꞌkoo ookutunava-koo. ");
INSERT INTO nas_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Enang tee peera pankaing tavoꞌkuuꞌ Iisipiꞌnameng-koo eeꞌnoko Keenani-nameng-koo, eeꞌnoko aaꞌnaꞌ toraꞌpauꞌ. Eeꞌnoko niumaraange taamang besiꞌaama ooaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bera Jeekopiꞌke taamang Iisipiꞌka taaravura teie botovuruꞌ teing niumaraang Iisipiꞌ beeroꞌaavaꞌnaang tutunaꞌnamuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Eeꞌnoko kemuꞌkanamuꞌ berouꞌnang-koo Josepaꞌ baka siraꞌparuꞌ batatakaampi-koo, eeꞌnoko Josepaꞌ baumaraang tenang Peeroꞌke noruꞌuruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Eeꞌnoko Josepaꞌ botoaruꞌ bauma Jeekopiꞌ boku-koo tee-anko eeꞌnoko ookara bakanamuiaang, nantoong-koong deerunooꞌ ˜kenaanka-taa kivora-ita paꞌnokoꞌ 75. ");
INSERT INTO nas_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Eeꞌnoko Jeekopiꞌ temaiaꞌ ninka, niikaang muuꞌnanka-koo okoꞌbosiꞌnamaiaꞌ ninka, nariꞌ danto Iisipiꞌaape berora teke otoroitaaꞌ nariꞌ boorouꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Eeꞌnoko Siekamaꞌaape nkavaarira teꞌ kuvi dakoꞌdoma bempaaruꞌ Eebaraamiꞌke mooꞌuuꞌnooꞌ niiꞌninge mooniꞌke Aamoo baurukaaꞌkoo teka Siekamaꞌka.” ");
INSERT INTO nas_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","“Teka tee maraka-anta Kumponinge Eebaraamiꞌ nauvuuꞌnung dupearavaing-koong batei dueꞌuma nanuko nantoong tee deto berempariruꞌ teke Iisipiꞌke bera niiꞌnung daurarong tavoꞌkuuꞌnooꞌke basi Iisipiꞌnameensiꞌkoo, Josepaꞌ noruꞌuaung. ");
INSERT INTO nas_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Teie niikanamuiaang aavavurima orakaꞌ nkovurima niikakatauro etuvurikoꞌ tootoia oko duaꞌaariko boorooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Eeꞌnoko tenang eeꞌnang Moosesi tee tootoꞌ kirokai pontoꞌaruꞌ. Eeꞌnoko beekuri kaara-koo baumaraange pava-koo kuunga tareauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bera tenang bakuꞌkoo makotuaruioꞌ taapoꞌ sipauꞌ, eeꞌnoko Peeroꞌ baurange nkavura bauring deempura tarevuko pankaꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eeꞌnoko Moosesi tee bare-antavaakoꞌ ookara mataunanka Iisipiꞌnupoong biikaning, eeꞌnoko tee iirakuta deemparuꞌ kara-koo eeꞌnoko nko-nkonanka-koo. ");
INSERT INTO nas_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Tenang tee mareꞌ karenaumo kivora deemparara baꞌmarang beeroꞌkoo piavokoꞌ, Isireeli baurukaaꞌ tampaarikoꞌning. ");
INSERT INTO nas_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Eeꞌnoko teie oovuuꞌ narung baꞌmarang-koong narunge Iisipiꞌkoonge orakaꞌ nkovuko, eeꞌnoko tee Iisipiꞌkoong tavura tee siꞌantavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Eeꞌ noruꞌui, ‘Ainge mmarange tasiꞌpai otong Kumponinge nkaang birenge mooꞌuriainaꞌ.’ Teka teinge tasiꞌpaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Eeꞌnoko daunaꞌmung napoꞌ Moosesie baꞌmarang-koonaanka taveereko oovuretuꞌ. Eeꞌnoko navu-anta-koo piavouꞌ aaꞌpuma, ‘Anaanka, deeꞌ namainta. Aming-koo deeꞌka orakaꞌ nkoreeremaang?’ ");
INSERT INTO nas_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Teka teie narunge baꞌmaikoꞌ orakaꞌ nkovukoꞌnunge nimpaꞌuma aaꞌpuuꞌ, ‘Daꞌ baie tarenung eeꞌnoko kara simpeꞌnara˜ neeꞌkoo deeng-antaruing? ");
INSERT INTO nas_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aiꞌ dake ning dupisiꞌmeeꞌnaang piaromaang teeꞌ narung Iisipiꞌkoong keꞌmaakiꞌ dupisiꞌeieenaꞌ nariꞌ?’ ");
INSERT INTO nas_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Eeꞌnoko tee Moosesi tenaarei naari-antavuioꞌ Iisipiꞌketa tenkenui kooꞌaruꞌ bera Midian-nameensiꞌnung deemparuꞌ, teke eeꞌnooꞌke baurinketa kenaankara nkoaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Teketa tee mareꞌ karenaumo kivora tankinuioꞌ narung koosinung˜ tee-anko pouꞌ teka meeꞌboraꞌ sirakamaaꞌkoo Sainai-namii-ankoa, ntaꞌkoo urung-koo meuꞌke tuuꞌdoiꞌnavari-koo. ");
INSERT INTO nas_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tenang Moosesie oovura tee taꞌninuuꞌ temuriiꞌkoo, eeꞌnoko tenang dueꞌ poko tee oovuuꞌnaang tee aurong Ovoring-etaing karouꞌ aaꞌpuma, ");
INSERT INTO nas_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ning tee Kumponing dakakatauro biikaang eeꞌnoko tee Eebaraamiꞌ bakaang, eeꞌnoko Aisakeꞌ eeꞌnoko Jeekopiꞌ.’ Eeꞌnoko Moosesi dankurankuꞌaruꞌ teke, oo-koo avorouꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Eeꞌnoko Ovoringe aaꞌpuuꞌ tee, ‘Tee boonamante˜ basiꞌdaravai kauꞌketa. Teꞌ kansiꞌ daꞌ donkonii otoinooꞌ meepoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ninge tee bakei ooansing Iisipiꞌnupoonge nkaning nantoong orakaꞌ nkoaariko, eeꞌnoko tee biikaang bairooto ninka birong taaravansing, eeꞌnoko ning depeto simaring teing mooꞌkoo. Enang arooꞌmeko daꞌ Iisipiꞌaape botorampaing.’ ");
INSERT INTO nas_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Tee eeꞌnara Moosesi tero tompimpaama eeꞌ minkuauꞌnung, ‘Daꞌ baie tarenung eeꞌnoko kara simpeꞌnara˜ deeng-antaruing?’ – tee eeꞌnara narung Kumponinge botovuuꞌ tarenung eeꞌnoko domang-anta deeng-antavura teie koosinunge pakuvuioꞌ, tee-ankoi oroꞌparuꞌnunge tuuꞌdoiꞌnavari-koo. ");
INSERT INTO nas_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Teie eeꞌnarai teeꞌ teing barampuruꞌ taaꞌniꞌanta taꞌnimpaariiꞌnanka nkovuma Iisipiꞌke eeꞌnoko teke Pirung Urung-koo eeꞌnoko teke meeꞌboraꞌ sirakamaaꞌkoo mareꞌ karenaumo kivora-koo. ");
INSERT INTO nas_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Tee aung tee teie Moosesie aaꞌpuruꞌnung teing Isireeli-nupoong, ‘Ovoring Kumponinge tee narung nakaronara donkong-antareruriaing diiꞌkoo damaꞌnavarang-koo meuꞌke, teeꞌ nariꞌ ning donkong-antamuuꞌnaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Bakei masikaꞌ sirakaꞌpari otong, tee Moosesi tee teke meeꞌboraꞌ sirakamaaꞌkoo tee kara pareꞌ deempari otokoꞌnung teing nantoong Isireeli-nupoong eeꞌnoko tee koosinung aaꞌning-koo meuꞌke tee eeꞌnara boto nkavuuꞌnung Kumponing bakaang kara domang-anta teka Sainai-namii-koo. ");
INSERT INTO nas_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","“Nka niumaraange tee taara-koo piavoroarukoꞌ dimpaꞌaama. Biikaang domang Iisipiꞌaape bereꞌarikoꞌ Eeroni aaꞌpaama, ‘Narung kumponing taꞌnamemuriaing niiꞌke siompampiaing, aiꞌ tee aung Moosesi niiꞌ Iisipiꞌketa baramuruꞌnung tee noruꞌampiaꞌ areꞌ beuꞌnunge.’ ");
INSERT INTO nas_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tenang eeꞌnang teinge boromakaꞌ kampianu paaravaitaaꞌ taꞌnampauꞌnang, eeꞌnoko akoꞌ boontunamparikoꞌ teu-koo, dotuarima biikaang nko-nko birenge nkoauꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Teka Kumponinge teing-eta bereꞌarama teka sipuruꞌ akoꞌ dootuuꞌariiꞌnaang aaꞌning-koo: duaaꞌ, kaara eeꞌnoko beentoꞌnanka-koo, teeꞌ eeꞌnaꞌ Kumponinge Daari Meekung-koo minkuvuuꞌnaꞌ nariꞌ bakaning nakaro-nupoong karantavurima eeꞌpinaꞌ, ‘Diiꞌ Isireeli-nupoong, tero tee diikakatauro meeꞌboraꞌ sirakamaaꞌkoo otorokoꞌning karenaumo kivora mareꞌkoo, eeꞌnoko teinge boromakaꞌ dovang sipisipiꞌnanka tavaarima dootuuꞌkoo boontunampaarikoꞌ. Teeꞌ nkoarima ee masikaꞌ ning-koo dootuuꞌarikoꞌ? Otoaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tee aaꞌ teva okiꞌnava dooponava nkavai nanaakoꞌnava ning Kumponing nkanava deeaꞌ, daang-koonaanka kumponinka beekanava deeng-antavauꞌnung, tenaanka aaꞌnoko Molokoꞌ eeꞌnoko tee beentoꞌ miring Reepani, tenaanka tamunsiꞌnaanka daangampaareeꞌnaang tekaꞌpaaretuꞌnaanka. Eeꞌnoko teeꞌkoo diikakatauro-pinaꞌ nariꞌ nkorariko diiꞌ isipoꞌ Babiloniꞌketa kato bataꞌdampiaing.’” ");
INSERT INTO nas_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Teinge niikakatauroi teva dooponava Kumponing ninka karanava kunuꞌai nanaakoꞌnung teke meeꞌboraꞌ sirakamaaꞌkoo. Teva eeꞌnava Kumponinge Moosesi paaranang nau-antavuuꞌnaꞌ kaniniiꞌnava. ");
INSERT INTO nas_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Napoꞌ teinge damaꞌnavarange niikakatauroi teie, teva dooponava kunuꞌaitaaꞌ Josiuaꞌ ninka berouꞌnunge temeensiꞌkoo akovitu pariꞌaarira tenang Kumponinge teing kare-nupoong bataꞌuriko uroꞌkanooꞌke nanuma. Bera teva teva dooponava pankaroong otouꞌnava bera Deevitaꞌ bakaang batei-koo basinooꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Eeꞌnoko teie Kumponinge Jeekopiꞌ bakaange tee Deevitaꞌ aaꞌnaꞌ biraankevukoꞌnung, eeꞌnoko teeꞌkoo Kumponing bakanavaꞌ masikavaꞌ kanievuuꞌnaang tanaꞌuuꞌ Deevitaꞌke. ");
INSERT INTO nas_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Teka Solomoniꞌke deekoꞌ damaꞌke kanievuuꞌnung teva. ");
INSERT INTO nas_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nka tee bane teva pankava kanievuioꞌ, Kumponing tee deto basi, nantoonge kaniaamaing-koo pavananka-koo pinkaꞌari otoaung. Teeꞌ Kumponinge Daari Meekung-koo nakaronung karantavuma aaꞌpuuꞌnaꞌ, ");
INSERT INTO nas_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Paning teꞌ nkanooꞌ baꞌnamari ookara tareroma, eeꞌnoko kansiꞌ teꞌ nkanooꞌ kauꞌ patuꞌdoma. Teeꞌkoo dake ning pava aremuriiꞌ kanimemuaing? Niiꞌnooꞌ areꞌka nkanooꞌ uaaroma daaꞌmemuuꞌnaang? ");
INSERT INTO nas_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ninge ee nkoampaꞌ nkaange birenge aing ookara kapooꞌnanka? Ovoringe teeꞌpuuꞌ.’ ");
INSERT INTO nas_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Diiꞌ bakei nantoong kontenuka, mutaananuka noruꞌkoo eeꞌnoko tasiꞌkoo. Doong kante diiꞌke Tanuaang Meekung beiꞌbeiꞌerimaung diikakatauro nkoarikoꞌnaꞌ nariꞌ nkorarima. ");
INSERT INTO nas_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Baa arera Kumponing-etaing nakaro-nupoong-koo diikakatauroi orakaꞌ nkoaavaruuꞌnung? Aaꞌnoma teing tee Naning Koontoꞌ poainooꞌ uroꞌke siraꞌpaakoꞌning tavaarikoꞌ, tee eeꞌnara diiꞌke kare-nupoong-anko sierira nariꞌ dupisiꞌeruꞌ; ");
INSERT INTO nas_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Diiꞌke eeꞌninge boto koosinunge poꞌantavuioꞌ nkaverira siomperiarukooꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Enang tee Sitivenie teing kara nau-antavurioꞌ taaravaara tee aaꞌnaꞌ iiravoroma siꞌdaꞌ kakirinkuarikoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Teka tee Tanuaang Meekunge maantoꞌui Sitiveni deto paning-aape ankamparama oovuuꞌ tee meenasi Kumponing bakaang, eeꞌnoko Jiisuuꞌ Kumponing-koo tampavine-koo donkonuioꞌ oovuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eeꞌnoko aaꞌpuuꞌ teie, “Ee aing, ninge ooansi oꞌnong paning daateꞌarioꞌ eeꞌnoko Tee Naning-naumpoꞌ Paning-etaing donkonuioꞌ aꞌdeiꞌke Kumponing-koo tampavine-koo.” ");
INSERT INTO nas_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Teka teing punkang pinkaꞌarima aaꞌnaꞌ bokiaama tee-koo naꞌmoong kokoroariruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Teketa osi pankamono-ita damaꞌdu baransiꞌaara teka kapange tooꞌpauꞌ tee. Eeꞌnoko teinge bakaang kara orakaꞌ masikaꞌ taaravauꞌninge biikaang mononopaꞌnanka kiruꞌarira narung nemaka-koo kauꞌkanooꞌ miring Soolo-koo sipauꞌ kapange tampaꞌ tooꞌpaavaꞌnaang tee. ");
INSERT INTO nas_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Eeꞌnoko tenang tooꞌpaako tee Sitiveni tee kunsiarama aaꞌpuuꞌ, “Ovoring Jiisuuꞌ, nkaang tanuaang nkaveai.” ");
INSERT INTO nas_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Eeꞌnoko kinkinura aaꞌnaꞌ bokuma aaꞌpuuꞌ, “Ovoring, aing aung orara nko-nko-koo tontaꞌantaveriaing.” Eeꞌnoko teeꞌ minkuvura tenang booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Eeꞌnoko Sooloi tee tampaꞌ noruꞌuuꞌ teeꞌ Sitiveni booꞌparuꞌnaꞌ. Eeꞌnoko teꞌmung-eta deto aaꞌnaꞌ orakaꞌ nkoaaruꞌnung teing dootuuꞌnupoong teka Jerusalemaꞌka, eeꞌnoko teing teketa purarenkaꞌeuꞌ avitoitoi aaꞌning-koo Judiaꞌ eeꞌnoko Sameriaꞌnameensiꞌkoo, nka teing kara okovuri nkanuka tenkenaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Teka niiꞌninge Kumponing-koo meeꞌduꞌpiariri otorokoꞌninge dakoꞌauꞌ tee Sitiveni aaꞌnaꞌ birompaama. ");
INSERT INTO nas_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Teka teie Sooloi tee tooreerevurikoꞌ teing dootuuꞌnupoong pava kantevui tumparama bera donkaang eeꞌnoko maniiꞌ barampurima kiimatanava-koo sipurikoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Enang tee teing purarenkaꞌariruꞌning avitoitoi nanaama Kumponing bakaang kara daankiauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipiꞌ tee Sameriaꞌ osi pankaing-koo beuꞌ eeꞌnoko teing-koo daankiarama aaꞌpuuꞌ, “Jiisuuꞌ tee naning Kumponinge tero Pakoꞌpariꞌuuꞌnung˜ nantoong domampuri tarevuriainooꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Eeꞌnoko tenang karingai tee taaravaara eeꞌnoko ooaama taaꞌniꞌantananka teie nkovukoꞌning domang-eta baroromparikoꞌ Pilipiꞌke minkuvukoꞌning-koo. ");
INSERT INTO nas_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Aiꞌ nantoong mmauꞌ maꞌnarie orenge koriaarikoꞌning unaavorokoꞌ tenang maꞌnari uiarima taapoꞌ teing-eta bakoariko, eeꞌnoko nantoong karinga dootananka eeꞌnoko kaikuuꞌnanka unaavorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Bera tee temono-nupoong aaꞌnaꞌ dotuarikoꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Teka teke osi pankamono-koo tee naning miring Saimoniꞌ aaꞌnaꞌ biivimparama otokoꞌnung maꞌnari biikaang iriꞌke taꞌnimpaariiꞌ nkovuma. ");
INSERT INTO nas_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pankaroong bakaang bankinie aavavuriko bera teinge Sameriaꞌnupoonge asikovurima siompaakoꞌ; ");
INSERT INTO nas_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Eeꞌnoko teinge ookarai temono-koo otorokoꞌninge eeꞌnoko biikaning ovontunankai tee narung barorompaakoꞌ aaꞌpaama, “Aung naning niiꞌnara Kumponing piikonara deto basi.” ");
INSERT INTO nas_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Teka tenang Pilipiꞌke doorenang tampara daankivuuꞌ Kumponing bakaang muuꞌkoong eeꞌnoko tee muuꞌ tarevuaing Kumponinge tero Pakoꞌpariꞌuuꞌnung tee miring Jiisuuꞌ. Teinge tee taaravaara ookara, donkaang eeꞌnoko maniiꞌ masikaꞌantavaara ntong-koo minkiarira meekaꞌantavariruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tee Saimoniꞌ eeꞌnara bereꞌarara nariꞌ masikaꞌantavauꞌ, eeꞌnoko damaꞌke ntong-koo minkiarara meekaꞌantavarara Pilipiꞌ ninka nariꞌ nanurekoꞌ, bera taaꞌniꞌantananka eeꞌnoko nko-nko taꞌnimpaariiꞌnanka oovuma asikovukoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Enang tee kara okovuri nkanukai Jerusalemaꞌketa eeꞌ taaravauꞌ, “Sameriaꞌnupoonge Kumponing bakaang kara taaravaing.” Eeꞌnoko teinge Piita naanka Jooni teꞌ botoaaretuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bera teꞌ poreta kunsiaaretuꞌ temono-nupoonge Tanuaang Meekung nkavaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Aiꞌ teing ookara tee Tanuaang Meekunge mmeꞌ korivuriaꞌ, tamung ntong-koo minkiarira meekaꞌantavariruꞌning Jiisuuꞌ Ovoring bakaang miring-koo. ");
INSERT INTO nas_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bera tenang teing-koo tenaankai beekaang bireng panteꞌaaresioꞌ Tanuaang Meekung nkavauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Enang Saimoniꞌke tee tenaankai kara-okovuresi-nkarai bireng panteꞌaareko Tanuaang Meekung nkavaako oovura, temuriiꞌ iriꞌ mooniꞌke mooꞌkoo piavouꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Eeꞌnoko bera aaꞌpuuꞌ, “Ning amereai tee temuriiꞌ iriꞌ, eeꞌnoko baa naning ninge nkaang tankaꞌ panteꞌampaing Tanuaang Meekung nkavuaing.” ");
INSERT INTO nas_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Teka Piitai aaꞌpuuꞌ tee, “Tee ninka dakaang mooniꞌ ninka daꞌ nariꞌ paaꞌdaravaing eeꞌ noruꞌemaatomaung-koo Kumponing bakaang avuavuꞌ mooniꞌke pa mooꞌkoo makosi. ");
INSERT INTO nas_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Daꞌ dakaang deeaꞌ aung eeꞌ oroꞌ kapooꞌ nko-koo, aiꞌ daꞌ dakaang domang tee koomparavaꞌ Kumponing-ankoi. ");
INSERT INTO nas_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kiimata-koo aroreitaaꞌ deekoꞌ bereꞌdaravai daꞌ teieta aung-eta dakaang onou orara-ita, eeꞌnoko kunsiraravai Ovoring-koo dakaning oreng tontaꞌderuainaꞌ baka makosivura deekoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Aiꞌ daꞌ tee ninge mamairoi maantoꞌ ooramaang eeꞌnoko orakaꞌnkoi daiꞌdui otong.” ");
INSERT INTO nas_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Eeꞌnoko Saimoniꞌke makuꞌuma aaꞌpuuꞌ, “Deeꞌ kunsirareaing Ovoring-koo teing kapooꞌnanka minkuveresining ning-koo basiaravaukaꞌnaꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Eeꞌnoko tenaankai Jiisuuꞌ mintoomparako oovurekoꞌnaꞌ siraꞌpuresi nauaaretuꞌ teing Sameriaꞌnavuntuꞌkoo otorouꞌning, eeꞌnoko Ovoring bakaang kara daankivuretuꞌ. Teketa Jerusalemaꞌaape toroaretuꞌ daankivurema tee doorenang tampara osinanka mmauꞌkoo Sameriaꞌnameensiꞌkooning-koo. ");
INSERT INTO nas_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Teka narunge koosinunge˜ Ovoring bakaange Pilipiꞌ aaꞌpuuꞌ, “Danto beaing tevung-koo taunavung Jerusalemaꞌketa Kasa-aape beꞌnavung-koo.” Tevung eeꞌnavung teke meeꞌboraꞌke nanuꞌnavung. ");
INSERT INTO nas_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Eeꞌnoko tee iꞌamparara nanuma narung Itiopiaꞌkoong oovuuꞌ, naning pankaing, doꞌmaꞌniiꞌ, teni Kandesi, Itiopiaꞌnupoong biikanani ovorinaang bakaang mooniꞌ tarenara; ");
INSERT INTO nas_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Eeꞌnara Jerusalemaꞌaape pouꞌ dootuuꞌaraaꞌnaang eeꞌnoko toroarakoꞌ teketaꞌ bakaang kaarisi-koo baꞌnanui deeruvuma nanukoꞌ Daari Meekung teie temuꞌnung nakaronarai Aisaiaꞌke daarivuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Eeꞌnoko Tanuaang Meekunge Pilipiꞌ aaꞌpuuꞌ, “Deto bera kaarisi-ankoi dueꞌke nariꞌ naniai.” ");
INSERT INTO nas_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Teketa Pilipiꞌ kuaꞌparuꞌ tee-anko eeꞌnoko teie tee temuꞌnung nakaronung Aisaiaꞌke daarivuuꞌnung deeruvuko taaravuuꞌ. Eeꞌnoko tee Itiopiaꞌkoong niaꞌuma aaꞌpuuꞌ, “Dake ee tee kapooꞌ deeruematomaung tasiꞌpemaang?” ");
INSERT INTO nas_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Eeꞌnoko teie aaꞌpuuꞌ, “Arekeeꞌ ninge tasiꞌpampeuꞌ naninge pakumuaruko?” Eeꞌnoko Pilipiꞌ bokuvuuꞌ deto koinura tee-anko baꞌnanuuꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tee kara Daari Meekung-koo deeruvukoꞌnaare anaare: “Kumponing bakaang bautara dupisiꞌaavaꞌnaang nkoaako karang kamaankuaukaꞌnung teeꞌ nariꞌ sipisipiꞌnu amakoarapeuꞌnaꞌ nantoonge tavuꞌdoma barampai beroko. ");
INSERT INTO nas_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","“Teinge pooreꞌaama kara koontoꞌnaꞌ simpeꞌevaavaukaꞌ. Teing nantoong bakanavarang-kooning bakei aaꞌnupoong: tee bakaang domaang teie, kansiꞌketa koontoꞌ tontaꞌaavaing.” ");
INSERT INTO nas_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eeꞌnoko teie Itiopiaꞌnunge Pilipiꞌ aaꞌpuuꞌ, “Ee aung, teie nakaronarai baa teeꞌ minkuvuuꞌ? Baka minkuaruꞌ aiꞌ niiꞌnung teeꞌ minkuvuuꞌ?” ");
INSERT INTO nas_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tenang eeꞌnang Pilipiꞌ karoma tenaare Daari Meekung-koong deeruvuuꞌnaare-ita tutumpuma tampara doorenang Jiisuuꞌ Karistooꞌkoong nauvuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eeꞌnoko teketa nanurema taunge ntong-poꞌnooꞌ basiaretuꞌ. Eeꞌnoko teie Itiopiaꞌkoonge aaꞌpuuꞌ, “Ooveko ntong aung. Aminge avoꞌmupeuꞌ ning enang ntong-koo minkimarara meekaꞌanta-koo?” ");
INSERT INTO nas_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipiꞌke aaꞌpuuꞌ, “Tee aaꞌ kapooꞌ otoaꞌ, dakaang domang-eta koontoꞌ masikaꞌantaveing deekoꞌ.” Eeꞌnoko teie makuꞌuma aaꞌpuuꞌ, “Masikaꞌantavansi oꞌnong tee Jiisuuꞌ tee naning niiꞌ domamuri taremuriainooꞌkoo tero Pakoꞌpariꞌniiꞌ, Kumponing Bauring.” ");
INSERT INTO nas_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Eeꞌnoko tee eeꞌnara botoaruꞌ tee bakaang kaarisi teꞌ datearaaꞌnaang, eeꞌnoko tenaanka ookaanka Pilipiꞌ eeꞌnoko tee Itiopiaꞌkoong doonko ntong-koo siareta Pilipiꞌke teka ntong-koo minkivura meekaꞌantavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Eeꞌnoko tenang ntong-eta deto taapoꞌ poreko Tanuaang Meekunge Ovoring bakaange Pilipiꞌ namuꞌke deto batusiꞌuuꞌ, eeꞌnoko teie Itiopiaꞌkoonge napoꞌ kemuꞌkanaꞌ oovuaruuꞌ teka. Teketa dotuarama danto nanuuꞌ bakanooꞌaape. ");
INSERT INTO nas_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Teketa Pilipiꞌ Asotasi-navuntuꞌkoo oroꞌparuꞌ, eeꞌnoko teke tankinuma ookara osi-koo tee doorenang tampara daankivuma nanuuꞌ bera Sisariaꞌ basiaruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tenang eeꞌnang tee Soolo domange sipukoꞌnang teing Ovoring bakanariong tavuꞌkoo. ");
INSERT INTO nas_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Eeꞌnoko tee eeꞌnara piristiꞌ deto basi-anko pora niaꞌkuuꞌ niiꞌning karavotoning˜ daarievuuꞌnaang, bera teing kompui pava dootuuꞌnanka-koo Damaskasie otoining-koo nanuma aaꞌnooꞌnaang: donkaang eeꞌnoko maniiꞌ Karistooꞌ siompaakoꞌning oovurira deekoꞌ daiꞌurira Jerusalemaꞌ beꞌantavuriiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Bera tee teketa nanuma Damaskas-navuntuꞌkoo dueꞌarako taꞌning-antanaꞌ paning-eta arakai siisioi korovui tooꞌpuuꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Eeꞌnoko teꞌ doonko kansiꞌkoo duaꞌarara aurong taaravuuꞌ aaꞌpuko, “Daꞌ Soolo, Soolo, ning aming-koo dake mankiꞌantamemaung?” ");
INSERT INTO nas_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Eeꞌnoko teie aaꞌpuuꞌ, “Daꞌ baa Ovoring?” Eeꞌnoko aaꞌpuuꞌ, “Ning eeꞌnara Jiisuuꞌ dake mankiꞌantamemaung. Nkaang kara dimpaꞌema daka baikeraramaung irintoꞌ deemparako.” ");
INSERT INTO nas_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Eeꞌnoko Sooloi aaꞌnaꞌ taꞌninui dankurankuꞌarama aaꞌpuuꞌ, “Ninge aming nkoamaꞌnaang, Ovoring?” Eeꞌnoko teie Ovoringe aaꞌpuuꞌ, “Enang donkonira teꞌ Damaskas beaing, eeꞌnoko teka nauraavaing kapooꞌ dake nkoveaing.” ");
INSERT INTO nas_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Teing nantoong tee ninka nariꞌ nanaakoꞌning teing teke kareaavaꞌ donkonai otorouꞌnung, aurong taaravaama, teka naning ooaavaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Teketa kansiꞌketa deto iꞌamparara Soolo duta bantoma makotuaruuꞌ kapooꞌ oo-koo. Eeꞌnoko tee bireng-koo kompai ootavauꞌ Damaskas-aape. ");
INSERT INTO nas_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Bera beenang doong kaputuꞌari otoi taamang eeꞌnoko ntong-koo naikuaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Enang tee teke naning narung Ovoring bakanavitu-koong otokoꞌnung miring Ananaiasi. Ovoringe tee tee-koo oroꞌparara karavuma aaꞌpuuꞌ, “Ananaiasi ee.” Eeꞌnoko teie aaꞌpuuꞌ, “Ovoring ee, ning aung.” ");
INSERT INTO nas_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Eeꞌnoko Ovoringe nauvuma aaꞌpuuꞌ, “Naniaing taunavunge miring Koontoꞌnavunge, bera Judasi bakanava-koo niaꞌkiaing naning oo-koo miring Soolo, Taasus-nung. Tee kunsiaramang teke. ");
INSERT INTO nas_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Eeꞌnoko kunsiarama niiꞌnaung˜koo bereꞌarara naning miring Ananaiasi pora bireng panteꞌuko oovuing duta bantang-anta-koo.” ");
INSERT INTO nas_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Teka Ananaiasie makuꞌuma aaꞌpuuꞌ, “Ovoring, ning tee nantoonge mmauꞌke naumaako taaravamaung tee. Nantoong dakaning aaꞌnaꞌ orakaꞌ nkovurimaung Jerusalemaꞌka. ");
INSERT INTO nas_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Eeꞌnoko tee aung tauraꞌ otoꞌevung piristiꞌnanka-koo ovontunge avauꞌnung daiꞌkoo teing nantoong anke dakaang miring-koo baitoarimaing.” ");
INSERT INTO nas_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Teka Ovoringe aaꞌpuuꞌ tee, “Beai, aiꞌ tee tee naning ninge tero miruꞌantuꞌnung nkaang miring nkavui nanuma daankivuuꞌnaang ookara nantoong-koo, aaꞌning-koo Juꞌdeeaing, dauraronanka, eeꞌnoko teing Isireeli-nupoong. ");
INSERT INTO nas_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eeꞌnoko damaꞌke tee ninge nau-antavampaing tee aaꞌnaꞌ baike kuneꞌuainaꞌ nkaang miring kompuitaaꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Teeꞌ minkuvuioꞌ Ananaiasi siarara pava-koo koinuuꞌ. Bera tee-koo bireng panteꞌuma aaꞌpuuꞌ, “Mmaikoꞌ, Soolo, teie Ovoring Jiisuuꞌke daꞌkoo oroꞌparieenge taunge daꞌ poieenavung-koo ning botomuing daꞌ napoꞌ ookira Tanuaang Meekunge maantoꞌduuꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Eeꞌnoko tenang teeꞌpuko taꞌninaꞌ kapooꞌ tenteng-pinaꞌ oroꞌ Soolo bakaang duta-ita duaꞌarako napoꞌ ookuuꞌ. Eeꞌnoko tenang teketa iꞌamparara ntong-koo minkiaioꞌ meekaꞌantavaruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Eeꞌnoko taamanura purimparuꞌ. Teketa niiꞌning doonge Karistooꞌ bakanavitu ninka otorouꞌ teke Damaskasie. ");
INSERT INTO nas_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Eeꞌnoko pava dootuuꞌnanka-koo namuꞌke daankinang tutumparuꞌ Jiisuuꞌ eeꞌ siraꞌpuma, “Tee tee Kumponing Bauring.” ");
INSERT INTO nas_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Eeꞌnoko teing ookara tee taaravauꞌning taꞌninaama aaꞌpauꞌ, “Aung ee tee naning Jerusalemaꞌke teing aung Jiisuuꞌ miring tampaama baitoaamaing tooreerevurimaung deeaꞌ? Eeꞌnoko teeꞌ nariꞌ napoꞌ temuriiꞌ aarumo nko-koo aꞌ poi daiꞌurima piristiꞌnanka biikaang ovontung-anko tavoꞌkoo.” ");
INSERT INTO nas_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Teka Soolo aaꞌnaꞌ masikaꞌ deto irikumparakoꞌ eeꞌnoko Juꞌkoong ovontung Damaskasie otorokoꞌning apooꞌurikoꞌ sirakaꞌantavuma Jiisuuꞌ tee eeꞌnara Kumponinge nantoong domampuri tarevuriainooꞌkoo tero Pakoꞌpariꞌuuꞌnung˜. ");
INSERT INTO nas_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bera mmauꞌ doong divuꞌuioꞌ Juꞌkoong ovontunge mumunsiauꞌ dupisiꞌaavaꞌnaang tee. ");
INSERT INTO nas_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Teka tee biikaang mumunsinang tavaavaꞌnaang nempaakoꞌnung osi karanaang aaꞌning-koo doong eeꞌnoko muung, taaravuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Teka baꞌmaikoriꞌke muunga mmariꞌantavaama burunge doonko osi-koong parang-koo damaꞌdue sing-antavauꞌ kaꞌbaraaꞌkoo otoko. ");
INSERT INTO nas_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Eeꞌnoko tenang Jerusalemaꞌ pora teing Karistooꞌ bakanavitu navu-koo paaravarakoꞌ, teka teing avoreaakoꞌ tee-koo Karistooꞌ bakanavitu-koong-pinaꞌ masikaꞌantavaavaruma. ");
INSERT INTO nas_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Teka Banabasie bokuvura kara okovuri nkanuka-anko beꞌantavura sirakaꞌantavuuꞌ teing-koo teie Ovoringe taunga karavuko oovuuꞌnaꞌ eeꞌnoko teeꞌ tee Damaskasie avoroaꞌ Jiisuuꞌ bakaang miring ninka daankiaruꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bera tee teing ninka data-antaveera teke Jerusalemaꞌke aaꞌnaꞌ iriꞌoi Ovoring bakaang miring-koo daankinang nkovukoꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Napoꞌ aaꞌnaꞌ nariꞌ karavurima deepaikoꞌeekoꞌ teing Juꞌnupoong Kirikiꞌnaꞌ kareaakoꞌning Jiisuuꞌ masikaꞌantavaavaruma, eeꞌnoko teinge dupisiꞌaavaꞌnaang besiꞌaakoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Eeꞌnoko tenang teinge nariꞌ baito-nupoonge tasiꞌpaara Sisariaꞌnavuntuꞌaape beꞌantavauꞌ. Teketa napoꞌ kato bakanooꞌ Taasus-aape botoauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Enang tee Soolo bereꞌaruꞌnooꞌketa dootuuꞌnupoong Judiaꞌke eeꞌnoko Kaaleliꞌke eeꞌnoko Sameriaꞌke otorokoꞌning mooa-koo otoroi purimpariruꞌnung, eeꞌnoko Ovoring-koo meeꞌduꞌpiariri otoroko Tanuaang Meekunge domang kuaaꞌantavurioꞌ berempariruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Teketa tenang Piitai beeroꞌurima avitoitoi nanukoꞌnang, teeꞌ nanuma Liida-namono-koo pouꞌ Ovoring kakeꞌiiariri siompaamaing-anko. ");
INSERT INTO nas_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Teeꞌ nanuma naning doota miring Inias kuneꞌuuꞌ mareꞌ ˜beenaumo-taa-koo pankaroong bempari nariꞌ otokoꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Eeꞌnoko Piitai aaꞌpuuꞌ tee, “Inias, teie Jiisuuꞌke, Kumponinge tero Pakoꞌpariꞌniiꞌke daꞌ taare-antaruing. Deto donkonira dakaang taniꞌ kaiꞌeai.” Eeꞌnoko namuꞌke deto iꞌamparuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bera Liida-nupoonge eeꞌnoko Saaron-nupoonge ooaara tee Ovoring-aape bereꞌariruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Teketa napoꞌ nani manikuma Jiisuuꞌ siompukoꞌnani miring Tabita, niiꞌnooꞌ Dookasi otokoꞌ. Teni teni tampani, papovuruꞌnanka pakuvurikoꞌnani. ");
INSERT INTO nas_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tenang tee batei-koo teni siipavora booꞌparuꞌ. Eeꞌnoko duuꞌpaara daunavaro-koo bempauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Teꞌ Liida Joopaꞌketa dueꞌ deemparako, eeꞌnoko Piita teke otoko taaravaara teinge Liida-nupoonge Jiisuuꞌ siompaakoꞌninge kenaanka naninka botoaaretuꞌ Piita bokuvureeꞌnaang aaꞌpaama, “Aung ee, namuꞌke poai niiꞌanko.” ");
INSERT INTO nas_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Teketa tee Piita tenaanka ninka nariꞌ porouꞌnung. Tenang tavoꞌarako tee teinge daunavaro-koo beꞌantavauꞌ teꞌ ookara naaroonku donkonai biromparikoꞌnooꞌ. Eeꞌnoko nau-antavauꞌ teing amutemuriiꞌ baarong Dookasie pateꞌukoꞌnanka tenang teni teing ninka otoi. ");
INSERT INTO nas_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Teka Piitai teing ookara damaꞌdu botovurira kinkinura kunsiaruꞌ. Bera mono-aape bereꞌarara aaꞌpuuꞌ, “Tabita, iꞌantaravai.” Eeꞌnoko teni duta bantoma Piita oovura deto baꞌnanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bera Piitai bakaang birenge kompura deto iꞌampuuꞌ. Eeꞌnoko ookara baito-nupoong teing ninka naaroonkunanka ninka nariꞌ bokuvurira teni domampoꞌ avuruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Eeꞌnoko ookarai Joopaꞌnavuntuꞌnupoonge taaravaara karingai Ovoring masikaꞌantavauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bera Piita tee teke Joopaꞌke mmauꞌ doong otouꞌnung niiꞌnara Saimoniꞌ bakanavaꞌkoo, kauꞌ karenaumo-koong dopaꞌ takeraꞌuma baavevukoꞌnung bakanava-koo. ");
INSERT INTO nas_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Teke Sisariaꞌnamono-koo tee narung naning otokoꞌ miring Koniliasi, narung daakuꞌ piatooro˜ tanatavurikoꞌnung, Itali-nameensiꞌnupoong tampaarikoꞌning. ");
INSERT INTO nas_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Koniliasi tee naning dootuuꞌkoo tampara, Kumponing-koo amaiaaꞌoi meeꞌduꞌpiari otokoꞌ bakanava-kooning ninka nariꞌ. Eeꞌnoko Juꞌnupoong ataꞌoiꞌnuka mmauꞌ mooniꞌ avurima pakuvurikoꞌ. Tee eeꞌnung kunsi bauko Kumponing-koo. ");
INSERT INTO nas_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Niiꞌnaꞌmung kamunooꞌaapevuko Kumponinge niiꞌnaung˜koo bereꞌantavuioꞌ koosinung siraꞌpari poioꞌ oovuuꞌ Kumponing bakaang. Pora aaꞌpuuꞌ tee, “Koniliasi ee.” ");
INSERT INTO nas_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Eeꞌnoko teie tee oovui avoroꞌke korivuma aaꞌpuuꞌ, “Arekeeꞌ, Ovoring?” Eeꞌnoko teie aaꞌpuuꞌ, “Dakaang kunsi eeꞌnoko dakaang avuavuꞌ Kumponing-anko tavoꞌkuioꞌ tasiꞌderuing. ");
INSERT INTO nas_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Enang nantoong Joopaꞌaape botoveriai eeꞌnoko narung Saimoniꞌ niiꞌnooꞌ miring Piita bokuaavai teka. ");
INSERT INTO nas_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Niiꞌnung Saimoniꞌ ninka nariꞌ otoreng, dopaꞌ kauꞌkarenaumo-koong takeraꞌumaung ninka. Bakaang pava pirung dueꞌke otong.” ");
INSERT INTO nas_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tenang tee koosinung tee kara nauvuuꞌnung tenkenuko teie kenaanka bakanaanka bautarara bokuvuretuꞌ eeꞌnoko narung piatooronuka-koong Kumponing-koo meeꞌduꞌpiari otokoꞌnung teke nempariri otorokoꞌning-koong. ");
INSERT INTO nas_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Eeꞌnoko ookara kapooꞌnanka nauvurira Joopaꞌaape botovuruꞌ teing. ");
INSERT INTO nas_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Teketa daunaꞌmung duaakiꞌnang teing nanaama teꞌ dueꞌ basiariko osi pankamono-koo Piita daunavaro-koo pava-koo koinuuꞌ teke kunsiaraaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Eeꞌnoko teke aaꞌnaꞌ peeravora kapooꞌ nai-koo piavokoꞌ. Teke niiꞌning iapavariko tee niiꞌnaung-koo bereꞌarara paning daateꞌarioꞌ oovuuꞌ, bera kapooꞌ baarong pankaing-pinaꞌ sivereꞌari depeto kansiꞌkoo siaruꞌ karenaumo kunkuꞌdoiꞌkoo biꞌari. ");
INSERT INTO nas_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tenaaꞌkoo kuunge amutemuriiꞌ kauꞌ karenaumonanka, boruꞌnanka eeꞌnoko barennanka auviꞌau-kooning otoroko. ");
INSERT INTO nas_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Teketa aurong eeꞌ taaravuuꞌ, “Piita, deto donkonira tavera maaꞌeai.” ");
INSERT INTO nas_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Teka Piitai aaꞌpuuꞌ, “A, Ovoring, ninge temuꞌketa koontoꞌ aing kapooꞌ eeꞌ oroꞌ maaꞌampaung, aiꞌ aing teing kuꞌmiꞌpoꞌning orokoari otong niiꞌkoo Juꞌnupoong-koo.” ");
INSERT INTO nas_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Eeꞌnoko aurong napoꞌ karouꞌ kemuꞌkanaꞌ aaꞌpuma, “Aming kapooꞌ Kumponinge kiiroraaꞌantavuing dake kapooꞌ kuꞌmiꞌpoꞌnung tampema pooreꞌeaukaꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Asiꞌnaꞌmoo beemuꞌpinaꞌ nkoarioꞌ tee baarong napoꞌ daꞌdeng paning-aape deto nkavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Enang tee Piitai niiꞌnaung-koo bereꞌarara kapooꞌ oovuuꞌnung-koong miruꞌnooꞌ besiꞌuma norunoruꞌuko teing nantoong Koniliasie botovurioꞌ porouꞌning teke niaꞌkaakotaaꞌ Saimoniꞌ bakanavaꞌkoo karanaang-koo dueꞌ donkonai otorokoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Eeꞌnoko bokiaama aaꞌpauꞌ, “Tee ee Saimoniꞌ, niiꞌnooꞌ miring Piita, anke otomang?” ");
INSERT INTO nas_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piitai tee mmeꞌ tee niiꞌnaung-koo bereꞌararara oovuuꞌnung-koong miruꞌ nooruupivuko Tanuaang Meekunge aaꞌpuuꞌ, “Ee aung, nantoong beenaumoi daꞌ besiꞌdaamang. ");
INSERT INTO nas_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Donkonira doonko sirarara teing ninka nariꞌ beriai tokoonaꞌ noruꞌeaꞌ, aiꞌ teing teing ninge botoaransining.” ");
INSERT INTO nas_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Eeꞌnoko Piita doonko siaruꞌ teing-anko eeꞌnoko aaꞌpuuꞌ, “Ning eeꞌnara aung diiꞌke besiꞌmerimatomaung. Aming kapooꞌkoo porininge?” ");
INSERT INTO nas_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Eeꞌnoko teinge aaꞌpauꞌ, “Koniliasi, tee daakuꞌ piatooro tanatavurimaung, tee naning koontoꞌ eeꞌnoko Kumponing-koo aaꞌnaꞌ amaiaaꞌoi otomaung eeꞌnoko tee ookarai Juꞌnupoonge tampara tampaamaung, narunge meekunge koosinunge botovuioꞌ daꞌanko botoaring daꞌ bakanava-koo beeꞌnaang eeꞌnoko taaravuuꞌnaang kapooꞌ dake minkuveaining.” ");
INSERT INTO nas_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Teeꞌ taaravura tee teie kuung bokuvurira naꞌmung muung teke aasiauꞌ. Teketa daunaꞌmung tee daaꞌarara teing ninka nariꞌ berouꞌ, eeꞌnoko niiꞌning baito-nupoong Joopaꞌketa nariꞌ siompauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Eeꞌnoko keinaꞌmung Sisariaꞌ basiariruꞌ, Koniliasie nempuri otoko ookara baꞌmarang eeꞌnoko baꞌmaikoriꞌ naroꞌ naroꞌurira. ");
INSERT INTO nas_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tenang Piita tumparako Koniliasie kuneꞌura kauꞌkanooꞌke miinge keemparara pankaing-antavuuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Teka Piitai deto iꞌampuma aaꞌpuuꞌ, “Donkoniai, ning tee naning, daꞌpinaꞌ oroꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Eeꞌnoko nariꞌ karorema kuung basiarema nantoong karikaꞌ oovuruꞌ teke naroꞌariri otoroko. ");
INSERT INTO nas_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Eeꞌnoko aaꞌpuruꞌ teie teing, “Diiꞌke tee noruꞌeri otong Juꞌnupoong niikaang botoi tauraꞌmuriaꞌ niiꞌ oovunavitu ninka nariꞌ navu-koo niiꞌnooꞌ beeroꞌkoo, teka Kumponinge tero naumuieeng ninge baa naning tamunsiꞌnung niiꞌnooꞌ kuꞌmiꞌpoꞌnung tampamparooꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Teeꞌkoo ning-koo botoraririoꞌ ning tee aung moing kupiꞌmoaꞌ. Enang niaꞌdamaang ninge daꞌ: Aming-koo ning-koo botorarieenge?” ");
INSERT INTO nas_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Eeꞌnoko Koniliasie aaꞌpuuꞌ, “Karenang doong tankinuieening-koo duaaꞌ enang-pinaꞌ basiarako batei kamunooꞌnang-koong kunsi siompansi kunsimarako anke nkanava-koo taꞌninaꞌ naning narung ning-koo uroꞌkanooꞌ donkonuuꞌ mononopaꞌ sisisiisi kurumpari. ");
INSERT INTO nas_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Teie aaꞌmuuꞌnung, ‘Koniliasi, Kumponinge dakaang kunsi taarareruing eeꞌnoko dakaang avuavuꞌnanka ataꞌoinku-koo nkovemaung noruꞌderuieenge. ");
INSERT INTO nas_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Teeꞌkoo aaꞌdamaang: Joopaꞌaape Saimoniꞌanko, niiꞌnooꞌ miring Piita tampaakooꞌ, botoraravai. Niiꞌnung Saimoniꞌ bakanava-koo otomatoing pirung-koo dueꞌ, tee dopaꞌnanka kauꞌkarenaumo-koong takeraꞌumaung.’ ");
INSERT INTO nas_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Teeꞌkoo daꞌanko iriꞌnarung botomaruꞌ, eeꞌnoko tampaꞌ tampamang daꞌ aaꞌ poing-koo. Teeꞌkoo niiꞌ ookara anke naroꞌmariring Kumponing-koo uroꞌkanooꞌ teing kapooꞌ Ovoringe botoruining naumeriko taaravampiiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Eeꞌnoko Piitai daankinang tutumpuma aaꞌpuuꞌ, “Masikaꞌ enang tampaꞌ tasiꞌpansi otong Kumponinge tee nantoong tankaampuriaung, teka nantoong paninga boonameng-koo-nupoong Kumponing meeꞌduꞌpiai koontoꞌ otoromainge tee Kumponing dotu-antavaamaung. ");
INSERT INTO nas_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Aung tee kara Kumponinge Isireeli baꞌdompenku-anko botovuuꞌ, tee doorenang tampara eeꞌ minkuvui otoing: Jiisuuꞌ tee naning Kumponinge tero Pakoꞌpariꞌuuꞌnung niiꞌ ookara domamuri taremuriainooꞌkoo, eeꞌnoko teeꞌkoo Jiisuuꞌ ookara-koo naroꞌka Ovoring deempari otong, eeꞌnoko tee-koo kuunge mooa-koo oꞌnoriaing. ");
INSERT INTO nas_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Diiꞌke tee noruꞌeri otong tee minkunaa beremparuꞌnung ootukunairu-koo Judiaꞌke Kaaleliꞌketa tutumparara tenang Jooni Minkinarai daankivukoꞌnooꞌketa damaꞌke. ");
INSERT INTO nas_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tenaare anaare: Kumponinge Jiisuuꞌ Nasaretiꞌnung Tanuaang Meekung ninka iriꞌantavuma pakoꞌpariꞌuuꞌ. Teketa nantoong tampaꞌ nkovurima avitoitoi nanukoꞌ teing Sietaniꞌke korivurikoꞌning unaa-antavurima, aiꞌ tee tee Kumponing ninka nariꞌ otorekoꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nka niiꞌ teing, ookara kapooꞌnanka siraꞌnuka teie nkovukoꞌning teke Juꞌnupoong biikanooꞌke, nka baruꞌnooꞌ Jerusalemaꞌke, eeꞌnoko teinge teka dupisiꞌauꞌnaꞌ koiꞌkoo biꞌaara. ");
INSERT INTO nas_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Teka Kumponinge beenang doong tankinuioꞌ tee bouꞌnooꞌketa daaꞌura siraꞌpuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ookara nantoong-koo tee oroꞌparavaꞌ, teka Kumponinge niiꞌ bakaning siraꞌ nkonuka miruꞌmuritaaꞌ niiꞌankoi oroꞌantavuuꞌ eeꞌnoko nariꞌ taamang tovang ntong naiampikoꞌ booꞌketa daaꞌarara. ");
INSERT INTO nas_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Eeꞌnoko teie niiꞌke ooampiruꞌnaꞌ nau-antavarampiiꞌnaang botomuruꞌ ookara nantoong daankiarampima tee Jiisuuꞌ tee Kumponinge pakoꞌpariꞌuuꞌnung booꞌnuka eeꞌnoko domantooꞌnuka simpeꞌkoo. ");
INSERT INTO nas_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ookara urikupoong nakaro-nupoong Kumponing-etainge eeꞌ nariꞌ siraꞌpauꞌnung: ‘Ookara nantoong tee masikaꞌantavaavaining tontaꞌanta kompaavaing tee bakaang miring-koo kuunge.’” ");
INSERT INTO nas_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tenang Piita teeꞌ minkuari otoko Tanuaang Meekung tee teing-koo ookara-koo tee kara taaravauꞌning-koo pouꞌ. ");
INSERT INTO nas_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Eeꞌnoko teing Juꞌnupoong Karistooꞌ masikaꞌantavaakoꞌning nariꞌ Piita ninka porouꞌning bakei taꞌninauꞌnung, aming-koo, nnaꞌ Tanuaang Meekung teing-koo piamparioꞌ bane Juꞌdeeainge. ");
INSERT INTO nas_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Aiꞌ teinge tee oovuning karai kareaama Kumponing daangampaako taaravaaruꞌ. Teketa Piitai sirakaꞌantavuma aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Baie orokovuripeuꞌ aing ntong-koo minkie meekaꞌanta-koo? Aiꞌ aing teing Tanuaang Meekung nkavaining niiꞌpinaꞌ nariꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Eeꞌnoko teie botovuruꞌnung ntong-koo minkiarira meekaꞌantavariiꞌnaang Jiisuuꞌ Karistooꞌ bakaang miring-koo. Teketa teinge Piita dateauꞌ niiꞌning doong nariꞌ otorooꞌnaang tampaama. ");
INSERT INTO nas_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Enang tee Juꞌdeeainge Kumponing bakaang kara nkavaioꞌ taaravauꞌnung kara okovuri nkanukai eeꞌnoko ookara baitoarikoꞌninge Judiaꞌnupoonge. ");
INSERT INTO nas_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Teeꞌkoo Piita Jerusalemaꞌaape toroarioꞌ teinge dopaꞌ totoꞌkoo purimparikoꞌnavitue tuutunampauꞌ, aaꞌpaama, ");
INSERT INTO nas_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Daꞌ aming-koo teing ninka dopaꞌ napuꞌariaing ninka pava-koo bera nariꞌ taamanirieeng?” ");
INSERT INTO nas_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Teka Piitai ookara kapooꞌ okoraꞌketa nkoaruꞌnaꞌ nauvurima sirakaꞌantavuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Aaꞌpuuꞌ, “Ning teke Joopaꞌnavuntuꞌkoo kunsimarama oꞌnoi niiꞌnaung-koo bereꞌmarara kapooꞌ pankaing baarong-pinaꞌ sivereꞌari paning-eta depeto siarako karenaumo kunkuꞌdoiꞌkoo biꞌari noone-pinaꞌ ooantuꞌ. Eeꞌnoko tee ning-anko siaruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bera tee-koo ookama kauꞌ karenaumonanka ooarantuꞌ, niiꞌning iirankesiꞌnanka, eeꞌnoko boruꞌnanka eeꞌnoko barennanka auviꞌau-kooning. ");
INSERT INTO nas_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Eeꞌnoko ninge aurong taaravantuꞌ aaꞌmuko, ‘Piita, donkonira tavera maaꞌeai.’ ");
INSERT INTO nas_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Teka ninge aaꞌpantuꞌ, ‘A, Ovoring, temuꞌketa koontoꞌ aing kapooꞌ eeꞌ oroꞌke ning karang komuaruuꞌnung, aiꞌ aing teing kuꞌmiꞌpoꞌning, orokoari otong niiꞌkoo Juꞌnupoong-koo.’ ");
INSERT INTO nas_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Eeꞌnoko teie auronge napoꞌ kemuꞌkanaꞌ paning-eta karoma makuꞌmuma aaꞌpuuꞌ, ‘Aming kapooꞌ Kumponinge kiiroraaꞌantavuing dake kuꞌmiꞌpoꞌnung tampema pooreꞌeaukaꞌ.’ ");
INSERT INTO nas_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bera tee beemuꞌpinaꞌ nkoarioꞌ napoꞌ paning-aape ookutunung deto barampuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Eeꞌnoko napoꞌ tenang tee batei-koo beenaumo nantoong Sisariaꞌketa ning-anko botoaaruꞌning porouꞌ teꞌ teva-koo niiꞌ oꞌnorikoꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Eeꞌnoko Tanuaang Meekunge ning teing ninka nariꞌ meriiꞌnaang botomuuꞌ tokoonaꞌ noruꞌmaravaꞌ. Eeꞌnoko aing niiꞌmaikororiꞌ ˜narung-taa niꞌninka nariꞌ nanampiruꞌ bera teꞌ tee naning ning bokumuuꞌnung bakanava-koo tumariruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Eeꞌnoko teie naumuruꞌ teeꞌ koosinung bakanava-koo pora tee-anko donkonuioꞌ oovuuꞌnaꞌ aaꞌpuma, ‘Joopaꞌaape botoraravai Saimoniꞌ, tee Piita tampaamaung boku-koo. ");
INSERT INTO nas_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Teie eeꞌnarai sirakaꞌantaruuꞌnaang tee doorenang daꞌ eeꞌnoko dakanava-kooning nariꞌ domantariainaꞌkoong.’ ");
INSERT INTO nas_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Teketa ninge kara tutumpanko tee Tanuaang Meekung tee teing-koo siaruꞌ teeꞌ niiꞌkoo tutuntomai nkoaruꞌnaꞌ nariꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eeꞌnoko ninge norunoruꞌantuꞌ tee kara Ovoring bakaang eeꞌ minkuvuuꞌnung, ‘Jooni Minkinarai tee masikaꞌ tamung ntong-koo minkirurima meekaꞌantarurikoꞌ, teka diiꞌ teing Tanuaang Meekung ninka meekaꞌantarariaining.’ ");
INSERT INTO nas_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kumponinge tee, niiꞌke Ovoring Jiisuuꞌ niikaang domang-anta tero Pakoꞌpariꞌniiꞌ masikaꞌantavampirioꞌ tee bakaang Tanuaang Meekung niiꞌ amuruꞌnaꞌ aing avurioꞌ tasiꞌpamira ning arekeeꞌkoo ninka mosiiꞌmarapeuꞌ Kumponing bakaang pia totoꞌpansitaaꞌ?” ");
INSERT INTO nas_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tenang teinge tee taaravaara teing dooroomparira Kumponing pankaing-antavauꞌ aaꞌpaama, “Juꞌdeeaing doma tureroꞌpuringe Kumponinge bereꞌarira domampariiꞌnaang.” ");
INSERT INTO nas_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tenang tee Sitiveni tavaara mankiꞌ avuꞌantavaarioꞌ Karistooꞌ bakanavitu-koo niiꞌning avitoitoi mmariauꞌ akovitu otoromanairue bera aaꞌning-koo basiariruꞌ Ponisia-nameensiꞌ, Saiparasi-namuiꞌ eeꞌnoko Antiokoꞌnavuntuꞌ. Nka Kumponing bakaang kara Juꞌdeeaing-koo siraꞌpaavaꞌ biiꞌka Juꞌnupoong naing naueekoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Teka teing-koo niiꞌning Saiparasi eeꞌnoko Sairini-nupoong-koo teketa mmariaama Antiokoꞌ berora teke siraꞌpauꞌ tee kara Ovoring Jiisuuꞌkoong oovuning-koo Kirikiꞌnavitu-koo. ");
INSERT INTO nas_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ovoringe teing aaꞌnaꞌ pakuvurikoꞌ. Eeꞌnoko karingai nantoonge masikaꞌantavaarima Ovoring-aape bereꞌarikoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Teketa teinge dootuuꞌnupoonge Jerusalemaꞌ otorokoꞌninge taaravaara Banabasi Antiokoꞌaape botoauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bera Banabasi teꞌ basiarara Kumponing bakaang piaa teing-koo oovura dotuaruꞌ, eeꞌnoko tautauvuruꞌ teing ookara teeꞌ nariꞌ kakeꞌiiariri otoromaatooꞌnaang, Ovoring-koo pinkaꞌariri, avutevuꞌariaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Aiꞌ tee tee naning tampara, Tanuaang Meekunge eeꞌnoko baitoi maantoꞌke. Eeꞌnoko teketa pankavitu bereꞌarira tapoꞌariruꞌ Ovoring-koo. ");
INSERT INTO nas_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Teeꞌkoo Banabasi napoꞌ Taasus-aape beuꞌ Soolo besiꞌuma. ");
INSERT INTO nas_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Eeꞌnoko oovura Antiokoꞌaape toroaretuꞌ. Eeꞌnoko namareꞌkoo ookutunamareꞌkoo teing mmauꞌ dootuuꞌnupoong teke otorokoꞌning nau-antavaarema nariꞌ otorouꞌ. Bera teka eeꞌnooꞌka Antiokoꞌnavuntuꞌkoo tutunaꞌ teing Karistooꞌ siompaakoꞌning Kiristianiꞌ tampaaruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Enang tee tee batei-koo niiꞌning nakaro-nupoong Kumponing bakaning Jerusalemaꞌketa depeto porouꞌ Antiokoꞌaape. ");
INSERT INTO nas_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Eeꞌnoko narung teing-koong miring Akabas deto donkonura peera pankaing ookutunung kansiꞌkoo damaꞌke tavoꞌaravaing siraꞌpuuꞌ Tanuaang Meekunge nauvuioꞌ. Tee aung tee tavoꞌaruꞌnung damaꞌke tenang ovoꞌmaꞌ miring Kalaudias otokoꞌnang. ");
INSERT INTO nas_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Eeꞌnoko teinge Karistooꞌ sionukai teeꞌ taaravaara teing biiꞌmaikororiꞌ Judiaꞌnupoong pakuaariiꞌnaang eeꞌ matauauꞌ: ookarai mooniꞌ biiꞌka makosinaꞌ naroꞌ oosiaavai teing paku-koo. ");
INSERT INTO nas_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bera oosiaara Banabasi eeꞌnoko Soolo botoaaresioꞌ Jerusalemaꞌ Karistooꞌkoonavitu-koo urantanuka-anko tavoꞌuretuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tenang tee batei-koo tee daurarong˜ Eerotiꞌ botoarioꞌ niiꞌning dootuuꞌnupoong-kooning daiꞌaaruꞌ orakaꞌ nkoaariiꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Bera aaꞌnouꞌ Jeemisi tee Jooni bataata, Eerotiꞌ botoarioꞌ bainatue dupisiꞌauꞌ. Eeꞌnoko teing ovontung Juꞌnupoong Jiisuuꞌ turampaakoꞌninge tampaꞌ noruꞌauꞌ; ");
INSERT INTO nas_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Teketa Eerotiꞌke teing dotuariko oovura napoꞌ Piita daiꞌkoo botoaruꞌ. Aung tee tenang Baariꞌkoong˜ Paroro, taamang bereteꞌ iisiropa-koong nkoaakoꞌnang. ");
INSERT INTO nas_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Eeꞌnoko tenang teie mooꞌura tee kiimatanava-koo sipuuꞌ piatooronuka-koo kareviturie karenaumonaꞌ paarieema tanatavaavaꞌnaang kiimatanava-koo. Teketa Baariꞌkoong Paroro bakearako nantoong-anko beꞌantavuuꞌnaang noruꞌukoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Teeꞌkoo Piita tee kiimatanava-koo teka tareaakoꞌ, teka teinge dootuuꞌnupoonge kunsi ivekung nkoevauꞌ Kumponing-koo. ");
INSERT INTO nas_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Teketa teꞌmung eeꞌnaꞌmung muunga teie Eerotiꞌke nantoong-anko tavoꞌuuꞌnaang tampukoꞌnaꞌmung Piita tee aatui otoko piatoorora-koo˜ kenaankara-koo meuꞌke kevintai sieenai daiꞌari. Eeꞌnoko niiꞌning tarearikoꞌning kiimatanava-koo karanaange donkonai tanatavariko. ");
INSERT INTO nas_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bera tee taꞌninaꞌ Ovoring bakaang koosinung teke oroꞌparuꞌ eeꞌnoko arakai arakavuuꞌ tevaro. Eeꞌnoko Piita teka matoꞌnang-koo tankoꞌpuma tantevura aaꞌpuuꞌ, “Iriꞌnarung daaꞌdaravai.” Eeꞌnoko teing sieenaning doonko duaꞌaretuꞌ bireng-eta. ");
INSERT INTO nas_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Eeꞌnoko koosinunge napoꞌ aaꞌpuuꞌ tee, “Baarong tokorarara boonamante˜ siꞌdaravai.” Eeꞌnoko teeꞌ nkoarioꞌ koosinunge Piita aaꞌpuuꞌ, “Mononopaꞌ kuruntarara siomeai ning.” ");
INSERT INTO nas_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Eeꞌnoko danto siaruꞌ siompui tee. Teie tee masikaꞌantavuaꞌ tee kapooꞌ koosinunge nkovuuꞌnung, tang niiꞌnaung-koo bereꞌari noone-koo nanuuꞌnung-pinaꞌ noruꞌuma. ");
INSERT INTO nas_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Teketa tee tenaanka tutunaꞌnung eeꞌnoko kenaanka-nung tanata nkora divuꞌaareta aini-koong kuꞌnung otoinooꞌ basiaretuꞌ osi pankamono-aape beꞌdoma. Eeꞌnoko tee tee kuꞌnung baka daateꞌarioꞌ tenaanka siaretuꞌ danto damaꞌdu. Bera navunge danto bereta koosinunge teka namuꞌke sipuuꞌ tee. ");
INSERT INTO nas_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eeꞌnoko Piita-koo tenang onou poko aaꞌpuuꞌ, “Emuꞌ koontoꞌ tasiꞌpansing aung tee Ovoringe bakaang koosinung botovuing ning domamuuꞌnaang Eerotiꞌ bakaang bireng-eta eeꞌnoko bakaning orakaꞌ nkonanka ning-koo basi-antavuko Juꞌnupoonge ooaavaꞌnaang nemparikoꞌning.” ");
INSERT INTO nas_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tenang tee tasiꞌparara Piita Meeriꞌ bakanava-koo beuꞌ, teni tee Jooni Maakaꞌ bauko, teꞌ eeꞌnooꞌ nantoong karinga oosiarira kunsiarikoꞌnooꞌ. ");
INSERT INTO nas_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Eeꞌnoko tenang teie karanaang-koong kuꞌnung kopikopiꞌuko nani neraiꞌnaꞌ bautara miring Roodaꞌke taaravura oo-koo pouꞌ. ");
INSERT INTO nas_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bera Piita-koong aurong tasiꞌpura dotuarama karanaang daateꞌuaꞌ kuung-aape kuaꞌpari bera nauvurima aaꞌpuuꞌ, “Piita karanaang-koo damaꞌdue donkonui otong.” ");
INSERT INTO nas_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nka teinge aaꞌpauꞌ teni, “Daꞌ aaꞌ pa kanuꞌdaring.” Teka teni deravarako teinge aaꞌpauꞌ, “Tee aaꞌ bakaang tanuaang pa.” ");
INSERT INTO nas_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Teka Piitai teeꞌ nariꞌ kopikopiꞌukoꞌ. Eeꞌnoko tenang teinge daateꞌaama Piita ooaara tee taꞌninauꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bera dooroompariiꞌnaang birenge orokovurira teie sirakaꞌantavuuꞌ Ovoringe kiimatanavaꞌketa poꞌantavuuꞌnaꞌ. Eeꞌnoko aaꞌpuuꞌ Piitai, “Aung Jeemisi bakanamiring naueriai eeꞌnoko teing niiꞌning niiꞌmaikororiꞌ.” Teketa tenang tenkenura oovunamono-koo beuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tenang taneꞌpuioꞌ tee teing piatooronuka okiꞌnooꞌ biruꞌariaꞌ Piita paaꞌaruꞌnung-koo. ");
INSERT INTO nas_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Eeꞌnoko tenang Eerotiꞌke besiꞌuma oovuarura teing tare-nupoong tuutunampuriraiꞌnange tavaarima dupisiꞌaariiꞌnaang botoaruꞌ. Teketa Eerotiꞌ Judiaꞌketa Sisariaꞌaape doonko bera teke otouꞌ. ");
INSERT INTO nas_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tenang Eerotiꞌ teke Sisariaꞌke otoko Taiaꞌnupoong eeꞌnoko Saidoniꞌnupoong naroꞌ naroꞌarira niiꞌning nantoong Eerotiꞌ pinau-antavaavaꞌnaang botoaaruꞌ, aiꞌ teie Eerotiꞌke tee teing aing kemonora osi pankeng aaꞌnaꞌ munteꞌuri otokoꞌnung. Eeꞌnoko teing mooa-antanuka porora tutung narung tee Eerotiꞌ bakanava tanatavukoꞌnung miring Blastus tampaꞌ karavaama mooa-koo eentavariruꞌ, aiꞌ teing teing biikaang taamang tee daurarong bakanooꞌketa nkavaakoꞌning. ");
INSERT INTO nas_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bera tee teketa teꞌmung doong miruꞌuuꞌnaꞌmung makotuuꞌnang Eerotiꞌ nepuꞌari daurarong bakanooꞌ baꞌnaniꞌdoma baꞌnanura booꞌantanaꞌ daankiaruꞌ teing-koo nantoong-koo. ");
INSERT INTO nas_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Eeꞌnoko teinge bokiaama aaꞌpaakoꞌ, “Narung eeꞌnara kumponing bakaang-pinaꞌ auromparamaang, naning-pinaꞌ deeaꞌ.” ");
INSERT INTO nas_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Teketa namuꞌke Kumponing bakaang koosinunge˜ teka tavuuꞌ tee, bakaang daangang Kumponing-aape pareꞌuaruioꞌ. Eeꞌnoko domang ninka otoko kikiꞌke puampaako booꞌparuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Eeꞌnoko teketa tee Kumponing bakaang kara nepuꞌnaꞌ deto aaꞌnaꞌ dupura beremparuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Eeꞌnoko tenang tee batei-koo Banabas naanka Soolo Jerusalemaꞌketa toroaretuꞌ mooniꞌ tavoꞌuretuꞌnooꞌketa, tee Jooni Maakaꞌ bokuvuresi. ");
INSERT INTO nas_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Enang tee teke Antiokoꞌke dootuuꞌnupoong-koo niiꞌning nakaronuka eeꞌnoko nau-antanuka otorokoꞌnung, aaꞌnoko Banabasi, Simioniꞌ niiꞌnooꞌ Mutaanuꞌ tampaakoꞌ, Lusias Sairini-nung, Maneien, tee ovoꞌmaꞌ Eerotiꞌ ninka nariꞌ pankaꞌparetuꞌnung, eeꞌnoko Soolo. ");
INSERT INTO nas_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tenang teinge Ovoring daangampaako eeꞌnoko bakaang piaa besiꞌai unkumoariko Tanuaang Meekunge aaꞌpuruꞌ, “Banabasi naanka eeꞌnoko Soolo taapoꞌ tontaꞌmemuriai tee nko-nko ninge botoampetuꞌnung nko-koo.” ");
INSERT INTO nas_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Teketa unkumoarima kunsiarikotaaꞌ teinge tankaꞌ panteꞌaareta botoaaretuꞌ tenaanka. ");
INSERT INTO nas_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Teeꞌkoo Tanuaang Meekunge botovuresioꞌ tenaankai Jooni Maakaꞌ bokuvuretuꞌ teie pakuvureeꞌnaang. Teketa Selusia-navuntuꞌkoo pirung-aape danto berora Saiparasi-namuiꞌaape aarerie˜ berouꞌ; ");
INSERT INTO nas_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tenang Salamisi, Saiparasi-koonavuntuꞌkoo basiarira tenaankai Kumponing bakaang kara daankivuretuꞌ pava dootuuꞌnanka Juꞌnupoong biikaning-koo. ");
INSERT INTO nas_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tenang teinge temuiꞌ ookutunamuiꞌ opai daankiaarima nanaara Paaposi-navuntuꞌkoo basiarira teka teinge naning narung nankaiꞌnung kuneꞌauꞌ, Juꞌnupoong-koong daang Kumponing-etaing nakaronara tamparakoꞌnung miring Baajiisuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Temuiꞌkoong ovoꞌmaꞌ ninka nariꞌ otorekoꞌnung miring Sesias Paulus, tee naning onou-poꞌnung. Tee eeꞌnara botoaruꞌnung Banabasi naanka-koo Soolo Kumponing bakaang kara taara-koo piavoma. ");
INSERT INTO nas_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Teka teie nankaiꞌnarai, miring Baajiisuuꞌke, niiꞌnooꞌ Elimasi Kirikiꞌnaꞌkoo, teie turampuretuꞌ Banabasi naanka Soolo, teie ovoꞌmaꞌke Jiisuuꞌ masikaꞌantavuꞌneeng-koo. ");
INSERT INTO nas_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Teka teie, Sooloi, niiꞌnooꞌ Paulaꞌ tampaakoꞌ, Tanuaang Meekunge maantoꞌui aaꞌnaꞌ naapu narung oovuma aaꞌpuuꞌ, ");
INSERT INTO nas_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Daꞌ aung Sietaniꞌ bauring, daꞌ tee karenung ookara kapooꞌ koontoꞌnanka-koo, tosinankai eeꞌnoko orakaꞌ nkonankai maantoꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ee aung, Ovoring bakaang kara mareꞌkoo bakeraravaruko daꞌ tee Ovoringe enang taruko kaputuꞌdarara ookiarooꞌnaang niiꞌning batei-koo; duaaꞌkoo ookiaukaꞌnunge.” Teketa tenang namuꞌke kamoꞌke dakoꞌura mutaanampuuꞌ. Eeꞌnoko nantoong tee bireng-koo kompai siong-antavai nanaavaining besiꞌurima nanuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tenang teie ovoꞌmaꞌke tee kapooꞌ nkoaruꞌnung oovura taꞌnimparara masikaꞌantavuuꞌ. Asikovuuꞌ Ovoring bakaang nau-anta-koo. ");
INSERT INTO nas_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Teketa tee Paulaꞌ dovang aarerie tenkenauꞌnung Paaposi-eta teketa Peeka-navuntuꞌkoo basiariruꞌ Pampiliaꞌnameensiꞌkoonooꞌ. Eeꞌnoko Jooni Maakaꞌke teka sipureta Jerusalemaꞌaape toroaruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Teka tenaanka daanto tankinureta Antiokoꞌnavuntuꞌkoo basiaretuꞌ, Pisiria-nameensiꞌkoonooꞌ teꞌ. Eeꞌnoko Doong Uaanaꞌmung tenaanka Juꞌ biikaang pava dootuuꞌnava-koo bereta baꞌnamparetuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Teketa teinge dootuuꞌnava-koo pankenge Daari Meekung-koo bereꞌaara Moosesi-nung boto-koo eeꞌnoko urikupoong Kumponing-etaing nakaronuka biikaang dariraari-koo deeruaara tenaanka-koo botoarema aaꞌpauꞌ, “Deeꞌ niiꞌmarang-koonaanka, deeꞌke tautau nantoong domang kuaaꞌanta-koong otoꞌderuresing deekoꞌ minkuereai.” ");
INSERT INTO nas_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Teketa Paulaꞌ deto donkonura bireng toonuma aaꞌpuuꞌ, “Diiꞌ nantoong Isireeli-nupoong eeꞌnoko diiꞌ Juꞌdeeaing Kumponing nariꞌ arooꞌerimaing taarameriai. ");
INSERT INTO nas_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tee eeꞌnara Kumponing aing nantoong Isireeli-nupoong biikaange niikakatauro bakaning miruꞌurira biurukaaꞌ naroꞌka pankaing-antavuruꞌ tenang teke Iisipiꞌke damisimainku otorokoꞌnang, eeꞌnoko bakaang iriꞌ oroꞌantavui teketaꞌ tontaꞌuruꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Eeꞌnoko mareꞌ karenaumo kivora-koo tarevuri nanukoꞌ teke meeꞌboraꞌ sirakamaaꞌkoo. ");
INSERT INTO nas_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Eeꞌnoko tenang ˜kenaanka-taa muuꞌ tavurima opurira Keenani-nameensiꞌkoo teie teing barevuri oko-antavuruꞌ tee temeensiꞌ tankaampurira. ");
INSERT INTO nas_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Aung tee karenaumo daakuꞌketa naruaape mareꞌkoo kuunge nkoaruꞌnung. Eeꞌnoko teketa simpeꞌ nkonanka˜ donkong-antaevurikoꞌ bera Samuelaꞌkoo basinooꞌ, tee eeꞌnara Kumponing-etaing nakaronara. ");
INSERT INTO nas_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Teketa teing daurarong-koo eentavariko Kumponinge Soolo daurarong deeng-antaevuruꞌ karenaumo kivora mareꞌkoo, tee Kiisi bauring, Bensimani bakanamuiaang-koong. ");
INSERT INTO nas_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eeꞌnoko teketa tee tontaꞌura Deevitaꞌ napoꞌ biikaang daurarong deeng-antavuuꞌ. Tee-koo eeꞌnara-koo Kumponinge kara siraꞌpuma Daari Meekung-koo otoinaꞌ aaꞌpuuꞌ, ‘Aung eeꞌnara Deevitaꞌ, Jeeseꞌ bauring, enang ooansing tee naning nkaang domang ninka nariꞌ onouaramaung. Tee eeꞌnara ookara nkaang pia siompui nkovuaing.’ ");
INSERT INTO nas_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Aung eeꞌnara Deevitaꞌ baurukaaꞌketa Kumponinge poꞌantavuuꞌ Isireeli-nupoong-koo tee Domang-anta, Jiisuuꞌ, maraka-antavuuꞌnaꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jiisuuꞌ mmeꞌ poaruko Joonie bereꞌarira ntong-koo minkiarira meekaꞌantavariiꞌnaang daankivurikoꞌ ookara nantoong Isireeli-nupoong. ");
INSERT INTO nas_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Eeꞌnoko tenang Joonie bakaang nko-nko bakevuma aaꞌpuuꞌ, ‘Diiꞌke ning baa-pinaꞌ noruꞌmerimang? Ning aaꞌ tee Domang-anta nemperimaung deeaꞌ, teka ning-koo damaꞌke pomaang tee, ning aaꞌnaꞌ apooꞌmui doonge-taara˜ deempari. Tee eeꞌnara poko bakei tampaꞌ taaraveriai.’” ");
INSERT INTO nas_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Teeꞌ nariꞌ Paulaꞌke daankiarama aaꞌpuruꞌ, “Mmarang ee, Eebaraamiꞌ baurukaaꞌkooning, eeꞌnoko diiꞌ Juꞌdeeaing Kumponing nariꞌ arooꞌerimaing aaꞌdampimang: Niiꞌkoo eeꞌning-koo doorenang tee-koong domamuriaing-koong botoarioꞌ pouꞌnung. ");
INSERT INTO nas_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Teing nantoonge Jerusalemaꞌnupoonge eeꞌnoko biikaning pankenankai tasiꞌpaavaruuꞌ tee Jiisuuꞌ, teka tee booꞌkoong kiimata tampauꞌnooꞌkoo teinge tee dupe-antavauꞌnung tee kara urikupoong Kumponing-etaing nakaronukai daariauꞌnung eeꞌnara deeruampimaung ookara nko-nko-ita uaanaꞌmunanka-koo. ");
INSERT INTO nas_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Teka tee bane okoraꞌ booꞌanta-koo makosinaꞌ ooaavarura teinge Pailatiꞌ niaꞌauꞌnung tee botoarako dupisiꞌaavaꞌnaang. ");
INSERT INTO nas_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Eeꞌnoko tenang dupe-antavaara tee ookara Daari Meekunge tee-koo minkuvui otoining teinge depeto siauꞌnung teieta koiꞌketa eeꞌnoko kuvi dakoꞌdoma dakoꞌauꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Teka teie Kumponinge booꞌketa daaꞌuuꞌ. ");
INSERT INTO nas_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Eeꞌnoko mmauꞌ doong-koo oroꞌparuꞌ teing-koo tee ninka porouꞌning-koo Kaaleliꞌketa teꞌ Jerusalemaꞌ. Teing eeꞌning enang batei-koo bakaning siraꞌ nkonuka deempariri otorong nantoong-koo. ");
INSERT INTO nas_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Eeꞌnoko niiꞌke tee doorenang tampara poꞌantarerorompimaang aung anaare: Tee eeꞌnara Kumponinge maraka-antavuuꞌnung teing-koo urikupoong niumaraang-koo enang tee Kumponinge dupe-antamemuring niiꞌkoo biurukaaꞌkoo Jiisuuꞌ domang-antavura. ");
INSERT INTO nas_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Teeꞌ nariꞌ Daari Meekung-koo daariari otoinaꞌ teke kevuranavu-koo Kena-koo Tee Pakoꞌpariꞌniiꞌ tero miruꞌuma aaꞌpumanavu-koo: ‘Daꞌ tee Nnuring. Eꞌmung tee ninge daaꞌdansing.’ ");
INSERT INTO nas_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Eeꞌnoko booꞌketa domang-antavuuꞌnooꞌkoo teeꞌ eeꞌnaꞌ napoꞌ 