﻿USE sofia;
DROP TABLE IF EXISTS sofia.nal_vpl;
CREATE TABLE nal_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nal_vpl WRITE;
INSERT INTO nal_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Naari a vaatizang pana amun kulmua rapti zin Iesu Kaarisito, a natnaat sin Dewit, ma Dewit a natnaat sin Aabaraam: ");
INSERT INTO nal_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aabaraam, naan damana Aaisaak, ma Aaisaak, naan damana Jekop, ma Jekop damana Judaa varaxai wana amun daasna. ");
INSERT INTO nal_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaa, naan damana Perez nandiaa Zeraa ma naanaa zin nandiaa Taamaar. Perez naan damana Esron, ma Esron, naan damana Raam, ");
INSERT INTO nal_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ma Raam, naan damana Aaminaadaap, ma Aaminaadaap, naan damana Naason, ma Naason, naan damana Saalmon, ");
INSERT INTO nal_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ma Saalmon, naan damana Boaaz ma naanaa zin Boaaz, aizina Reaap. Boaaz naan damana Obet ma naanaa zin Obet, aizina Rut. Obet naan damana Jesi, ");
INSERT INTO nal_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ma Jesi naan damana a Xalxaal Dewit. Dewit naan damana Solomon, ma naanaa zina xa tabung maxus kalaak sin Uriaa waamua. ");
INSERT INTO nal_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon naan damana Reoboaam, ma Reoboaam naan damana Aabijaa, ma Aabijaa naan damana Aasaa, ");
INSERT INTO nal_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ma Aasaa naan damana Jeosefaat, ma Jeosefaat naan damana Joraam, ma Joraam naan damana Uziaa, ");
INSERT INTO nal_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ma Uziaa naan damana Jotaam, ma Jotaam naan damana Aaxaaz, ma Aaxaaz naan damana Ezekia, ");
INSERT INTO nal_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ma Ezekia naan damana Manaase, ma Manaase naan damana Aamon, ma Aamon naan damana Josaaia, ");
INSERT INTO nal_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ma Josaaia naan damana Jekoniaa varaxai wana amun daasna. La notaan angkanaan amun Baabilon di vangarin amun Israael ma di raagul Baabilon malasing amun topuran. ");
INSERT INTO nal_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lamuraana amun taan angkanaan di iziar Baabilon, Jekoniaa naan damana Salaatiel, ma Salaatiel naan damana Zerubaabel, ");
INSERT INTO nal_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ma Zerubaabel naan damana Aabiut, ma Aabiut naan damana Eliaakim, ma Eliaakim naan damana Aazor, ");
INSERT INTO nal_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ma Aazor naan damana Zaadok, ma Zaadok naan damana Aakim, ma Aakim naan damana Eliut, ");
INSERT INTO nal_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ma Eliut naan damana Eliezaa, ma Eliezaa naan damana Maataan, ma Maataan naan damana Jekop, ");
INSERT INTO nal_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ma Jekop naan damana Iosep, labana Maaria, naanaa zin Iesu, Iesu angbani di vakilaan naan a Mesaaia. ");
INSERT INTO nal_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ka zangaaflu ma urulavaat a watkul di varumara zin Aabaraam ma xa wat tuaas sin Dewit, ma xa zangaaflu ma urulavaat a watkul, di varumara zin Dewit ma xa wat tuaas sin amun Baabilon di vangarin amun Israael ma di raagul Baabilon, ma xa zangaaflu ma urulavaat a watkul di varumara la raan amun Baabilon di vangarin amun Israael ma di raagul Baabilon ma xa wat tuaas a Mesaaia di luk naan. ");
INSERT INTO nal_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","A vaatizang pana Iesu Kaarisito di luk naan ka malasing kari: Maaria, naanaa zin Iesu, di vakol naan kana zaxot Iosep, Singsaxai la raan nandiaa xawit nanga di maxus iaa, di raamin adu Maaria xa buxut faanong. A Laklagaai a Raabu nanga xa vabalos a nalik la xuna. ");
INSERT INTO nal_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosep, labana Maaria, naan kat falos amun Lus sin Moses, singsaxai xawit na saxot kana vamangil Maaria lamarana aubina. Ka naxaam adu xana vataling burungin be naan. ");
INSERT INTO nal_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Singsaxai araan naan ka inaxam nanga wana azaan angkanaan, a aangelo zin a Piran ka balas lamaskana a mirifdaaiang sina ma xa vazei naan naako, “Iosep, a natnaat sin Dewit, tuaa gu maraaut pana zaxotang Maaria malasing taak sunum, panaze a nalik la xuna, a Laklagaai a Raabu nanga xa vabalos. ");
INSERT INTO nal_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma naan kana luk a nalik tapti ma guna vakilaan aizina Iesu, wanaze naan kana zaxot faulin aubina zina ziaana amun matmalabuk taksaat sin naandi.” ");
INSERT INTO nal_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Amun saan faakdul angkanaan ka ra balas kuna waambazovang a dorang sin a Piran, ina a profet sina xa ra piaat malasing kari, ");
INSERT INTO nal_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Naagu langar, aza rakfaaxur ina xawit nanga nat milivin ta rapti, xana buxut ma xana luk a nalik tapti ma dina vakilaan naan Imaanuel.” Aknaaza waaling angkanaan Imaanuel adu, “Nakmai xa iziar varaxai wana dia.” ");
INSERT INTO nal_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lamur Iosep ka ravaangun ma xa zaxot Maaria malasing taak sina, malasing be a aangelo zin a Piran ka ra vazei naan pana. ");
INSERT INTO nal_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Singsaxai Iosep kawit na milivin Maaria xa ruaas Maaria xa luk a nalik tapti. Ma Iosep ka vakilaan naan pana Iesu. ");
INSERT INTO nal_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Di luk Iesu la bina laba Betliem, la pira Judia la notaan sin a xalxaal Erot. Lamur azanon ubina mazam ila non a iaas kai laak pana, di wat balas Jerusalem. ");
INSERT INTO nal_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma di iaari malasing kari, “Naan a nalik faa ina di luk naan kana balas a xalxaal zin amun Judaa? Maadi raamin a watpada zina la non a iaas kai laak pana ma maadi wat kari xuna maadina lotu wana naan.” ");
INSERT INTO nal_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Araan a xalxaal Erot ka langarin azaan angkanaan, ka inaxam farvaras ma xa maskalus, ma aubina vaakdul in Jerusalem saait di inaxam farvaras ma di maskalus. ");
INSERT INTO nal_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A xalxaal Erot ka viring fatuin amun pris laba vaakdul ma amun maravas faakdul iwana amun Lus sin Moses ma xa iaari zin naandi naako, “Dina luk a Mesaaia vaa?” ");
INSERT INTO nal_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma di xis naan malasing kari, “Dina luk naan la bina laba Betliem, la pira Judia, wanaze a profet ka ra varaar vating malasing kari, ");
INSERT INTO nal_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nua Betliem, ila pira Judaa, nua xawit a zaxamur lawalaua naandi ubina laba di ratasin a lus in Judaa. Avuna a rapti laba xa ratasin a lus kana tukbilak inaan sunum, naan kana xatkatong aubina zurugu, amun Israael, malasing a rapti xa rataamaai xaaul wana amun sipsip.’ ” ");
INSERT INTO nal_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ma a xalxaal Erot ka viring funfunin ubina mazam angkanaan, ma xa iaari zin naandi wana aze ra raan mase di ra raamin a watpada angkanaan ka balas. ");
INSERT INTO nal_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma xa kling pizin naandi xun Betliem, ma xa vazei naandi malasing kari, “Naagu waan ma naagu wa saaleng daxa wana a nalik angkanaan. Ma araan naagu tangin naan, naagu wat fazei nia xuna nia zaait gana wa lotu wana naan.” ");
INSERT INTO nal_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Di langarin fanong a dorang sin a xalxaal ma di waan. Pana a zangazang sin naandi, a watpada ina naadi ra raamin la non a iaas kai laak pana, xa waamuain naandi ma xa wa iziar vaatak la non a nalik ka itate wana. ");
INSERT INTO nal_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Naandi di nanam mase araan di raamin a watpada angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Di balas la vaal zin nandiaal ma di albis ma di raamin a nalik ma naanaa zina Maaria. Di zibukaak lamarana ma di lotu wana a nalik angkanaan. Naanaan di kaas amun laxa zin naandi wana amun lulugaan, ma di ralaas naan pana amun talazang kari, a goul, ma a laas ina dit faif ma ambuan iwana xa milalas mikuf, ma aza wat daanim ina xa milalas mikuf, di vakilaan a mar. ");
INSERT INTO nal_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lamaskana mirifdaaiang, Nakmai xa vazei naandi adu tuaa dina uli waan sin Erot. Malasing ma di uli xula bina zin naandi wana aza lan tawarak. ");
INSERT INTO nal_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Araan di waan faanong, a aangelo zin a Piran ka balas sin Iosep lamaskana a mirifdaaiang, ma xa vazei naan naako, “Tamaraat, saxot a nalik ma naanaa zina ma naagu valaau raal xun Ijip. Naaguna iziar raal inaan ka ruaas a raan nia nanga gana vazei nua, wanaze Erot kana zaleng a nalik kuna naana zop famaat.” ");
INSERT INTO nal_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Labung angkanaan nanga Iosep ka zuruk a nalik ma naanaa zina ma di waan taal Ijip. ");
INSERT INTO nal_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Di iziar raal inaan ka ruaas lamuraana Erot ka maat. Azaan angkanaan ka balas ka waambazof a dorang sin a Piran ina a profet ka ra piaat malasing kari, “Ga viring pizin luk naarugu inaan Ijip.” ");
INSERT INTO nal_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Araan Erot ka mazaam ka adu ubina mazam di vagit naan, ka boromaazik mase. Ma xa rasin a lus dikdik, adu dina zop famaat a funalik tapti vaakdul in Betliem ma amun non faasilik. A funalik a maariaas sin naandi urua ma xa wizik tuaas pana naandi ina di samura luk naandi, lalozang a raan angkanaan ubina mazam di ra vazei naan pana. ");
INSERT INTO nal_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Malasing ma a dorang kanaan profet Jeremaaia xa ra piaat ka balas faaratunaan malasing kari: ");
INSERT INTO nal_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A linga xazak di langarin la bina laba Raamaa, xa rataangis pana adi maskaluzang. Raakel xa rataangis saxot a funalik sina ma xa bain taxazak kana mada naan, panaze naandi vaakdul di maat.” ");
INSERT INTO nal_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lamuraana Erot ka maat faanong, a aangelo zin a Piran ka balas sin Iosep lamaskana mirifdaaiang araan di iziar Ijip. ");
INSERT INTO nal_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ma xa vazei naan malasing kari, “Tamaraat, saxot a nalik ma naanaa zina ma naagu uli raal xula pira Israael, wanaze ubina ina adu dina zop famaat a nalik di maat faanong.” ");
INSERT INTO nal_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma naan ka ramaraat ma xa zaxot a nalik ma naanaa zina ma di uli raal xula pira Israael. ");
INSERT INTO nal_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Singsaxai araan Iosep ka langarin adu Aakelaaus ka xul damana Erot, malasing a xalxaal zin amun Judaa, xa maraaut pana waanang inaan. Ma lamaskana a mirifdaaiang, Nakmai xa vazei Iosep ma nandiaal di ramaraat taal inaan kula pira Gaalili. ");
INSERT INTO nal_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nandiaal di wa raagul raal la bina laba di vakilaan Naazaret. Malasing ma di waambazof a dorang sin amun profet di ra piaat malasing kari, “Dina vakilaan naan a rapti Naazaret.” ");
INSERT INTO nal_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lamun taan angkanaan, Jon A Rapti Iwana Baaptaaizang ka balas ma xai fazei la non bingil in Judia. ");
INSERT INTO nal_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ma xa piaat malasing kari, “Naaguna inaxam taawuk, panaze a bikabar ila lia xa wat faasilik faanong.” ");
INSERT INTO nal_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon, naan a rapti ina a profet Aaisaaia xa ra dador wana naako, “A linga xazak ka viviraai la non bingil malasing kari, ‘Naaguna nimnimanin a lan sin a Piran, naaguna waafatok amun lan aaxana xuna zangazang.’ ” ");
INSERT INTO nal_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon kat falaak a marapi di giu wana a vura kaamel ma xat lagot kol a zuruna wana a let di giu wana a wina bulumagau. Ma a vanganang sina xanaan amun sixa ma a aani ilauran. ");
INSERT INTO nal_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aubina in Jerusalem ma aubina ilamun non faakdul in Judia ma aubina ilamun non faakdul lapaara daanim Jodaan di waan sina. ");
INSERT INTO nal_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Di pitfiaat amun matmalabuk taksaat sin naandi, ma Jon ka baaptaais naandi la daanim Jodaan. ");
INSERT INTO nal_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Singsaxai araan Jon ka raamin amala amun Faarasi ma amun Saadusi di uwat kuna xana baaptaais naandi, xa vazei naandi malasing kari, “Nim a funalik sin amun sizi di ikarat! Nis ka vazei nim kuna naaguna valaau ziaana a boromaazikang sin Nakmai ina xana balas? ");
INSERT INTO nal_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Naaguna giu amun matmalabuk kuna vatanginang adu faaratunaan naagu inaxam taawuk faanong. ");
INSERT INTO nal_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tuaa naagu naxaam adu xat faraxas naaguna piaat malasing kari, ‘Aabaraam, naan damana maam.’ Ga vazei nim, Nakmai xat faraxas kana xul amun faat angkari xuna dina balas amun natnaat sin Aabaraam. ");
INSERT INTO nal_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A raamu xari xa iziar vaanong la vuna amun iaai, ma amun iaai vaakdul ina xawit nat fuain amun fnuaai daxa, dina raraai psin ma dina psin lamaskana xaiaf. ");
INSERT INTO nal_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Gai baaptaais nim pana a daanim kuna vatanginang adu faaratunaan naagu inaxam taawuk faanong, singsaxai axazak ina xana wat lamuraagu, naan ka laaup mase wana nia, ma nia xawit a rapti daxa xuna xanat faraxas gana vazaak uru su zina. Naan kana baaptaais nim pana a Laklagaai a Raabu ma wana a xaiaf. ");
INSERT INTO nal_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Naan ka ratoting a saawol xuna gimaan pizinang a wakpaak amun kalamona wit. Araan naa vatawaraxin fakdul vanong, kana waaturin amun kalamona wit lamaskana vaal iwana. Singsaxai a wakpaakna, naana vaif lamaskana xaiaf ina xawit nat faraxas dina zop famaat.” ");
INSERT INTO nal_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ma Iesu xa ramaraat Gaalili ma xa waan la daanim Jodaan kuna Jon kana baaptaais naan. ");
INSERT INTO nal_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Singsaxai Jon ka saxot kana vazobuaak naan, ma xa piaat sina naako, “Ka tak adu nua guna baaptaais nia. Kunaze gu wat surugu?” ");
INSERT INTO nal_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Singsaxai Iesu xa vazei naan naako, “Guna baaptaais be nia. Ka tak dina los iaa a lan angkanaan kuna waambazovang amun matmalabuk faakdul xa tak Nakmai xa saxot.” Naanaan Jon ka rudaxa ma xa baaptaais Iesu. ");
INSERT INTO nal_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Araan Jon ka baaptaais fanong Iesu, Iesu xa kasaai wat la daanim ma fazaaus mase a lia xa ralakas ma xa raamin a Laklagaai a Nakmai xa kabal wat malasing a baalus ma xa ziar wana naan. ");
INSERT INTO nal_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma a linga xazak ka wat ikula la lia xa piaat malasing kari, “Naan kari Naarugu. Nia ga sasaxot naan, ma ga nanam mase wana naan.” ");
INSERT INTO nal_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Naanaan a Laklagaai a Raabu xa zaxot Iesu xu lamaskana a non bingil xuna Saatan kana vaxabebeu naan. ");
INSERT INTO nal_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesu xa ra valvaal wana a vanganang pana a raan ka zangaaflu vaaralavaat ma a suk ka zangaaflu vaaralavaat, malasing ma naan ka lagaai. ");
INSERT INTO nal_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ma Saatan, a rapti xat faaxabebeu, xa balas sina, ma xa piaat naako, “Tamon nua Naata Nakmai, gu vazei amun faat angkari xuna dina balas a raraba.” ");
INSERT INTO nal_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma Iesu xa xis naan naako, “Di varaar vating lamaskana a Baar Xoxok malasing kari, ‘Aubina xawit di roro wana vanganang be, xawit. Di roro wana a dorang faakdul ina xa tukbilak la nguza Nakmai.’ ” ");
INSERT INTO nal_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Naanaan Saatan ka zaxot naan kun Jerusalem, a bina xoxok ma xa varur naan laaxur mase la waata vaal ila vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma Saatan ka vazei naan malasing kari, “Tamon nua Naata Nakmai, gu fida wizik paanaburut la pira. Avuna di varaar vating lamaskana a Baar Xoxok malasing kari, ‘Nakmai xana kling amun aangelo zina xuna dina raamaai xaaul wana nua, ma dina raxut fauzaa nua laaxur wana mita naandi xuna guna wen tuxin nua wana vaat.’ ” ");
INSERT INTO nal_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Iesu xa xis naan naako, “Di varaar vating lamaskana Baar Xoxok malasing kari, ‘Tuaa gu vaxabebeu a Piran, Nakmai zunum.’ ” ");
INSERT INTO nal_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ma Saatan ka zaxot Iesu xula waatawut lapuk mase ma xa vatangin naan pana amun kaantri vaakdul ila pira angkari ma amun marmari daxaiang sin naandi. ");
INSERT INTO nal_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma xa vazei Iesu naako, “Tamon gu zibukaak ma gu lotu wana nia, gana lis amun saan faakdul angkanaan sunum.” ");
INSERT INTO nal_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma Iesu xa vazei Saatan naako, “Saatan! Paan siaagu! Avuna di varaar vating lamaskana a Baar Xoxok malasing kari, ‘Gu lotu wana a Piran, Nakmai zunum ma gu vaamuzas be xu naan.’ ” ");
INSERT INTO nal_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ma Saatan ka waan fataling naan ma amun aangelo di balas ma di vaxatkatong naan. ");
INSERT INTO nal_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Araan Iesu xa langarin adu Jon di rasin naan la vaal a vaamaazikang, ka uli xun Gaalili. ");
INSERT INTO nal_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naan ka ramaraat fataling Naazaret ma xa wa raagul Kaapernaaum. Kaapernaaum ka iziar lapaara Laman Gaalili, la non pira Zebulon ma la non pira Naaftali. ");
INSERT INTO nal_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Naan ka luaa Naazaret ma xa waan Kaapernaaum kuna waambazovang a dorang sin a profet Aaisaaia malasing kari, ");
INSERT INTO nal_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“La non pira Zebulon ma la non pira Naaftali, la lan kula laman laza rita daanim Jodaan, a pira Gaalili zin aubina xawit amun Judaa, ");
INSERT INTO nal_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","aubina di raagul lamaskana bungsuzuk, di raamin fanong adi maravas. Ma naandi a bungsuzuk iwana maatang ka waramin naandi, a maravas ka vamaravaas fanong naandi.” ");
INSERT INTO nal_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","La notaan angkanaan ka, Iesu xa varumara a fazeiang sina malasing kari, “Naagu inaxam taawuk, panaze a bikabar ila lia xa wat faasilik faanong.” ");
INSERT INTO nal_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Araan Iesu xa zazangas lapaara Laman Gaalili, xa raamin uru vandaas, Saaimon ina dit fakilaan saait naan pana Pita, ma daasna Endru. Nandiaa di waataas iaa la laman panaze nandiaa uru rapti iwana vaaianang. ");
INSERT INTO nal_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma Iesu xa piaat sin nandiaa malasing kari, “Laawus iaa. Naagu los iaa nia ma gana viraai numaa wana a lan iwana urivang aubina.” ");
INSERT INTO nal_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Fazaaus mase di luaa iaa amun ubina iwana vaaianang sin nandiaa ma di los iaa Iesu. ");
INSERT INTO nal_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iesu xa zangas paan faamumut kaarik ma xa raamin aza ru vandaas, Jems naata Zebedi, ma daasna Jon. Di iziar iaa lamaskana a mon faraxai wana damana nandiaa Zebedi. Di iom taal amun ubina zin nandiaal. Ma Iesu xa viring nandiaa, ");
INSERT INTO nal_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ma faabuza mase di vataling iaa a mon ma damana nandiaa, ma di los iaa Iesu. ");
INSERT INTO nal_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu xa waan lamun non faakdul la pira Gaalili ma xat faraviraai lamaskana amun faal a maainungang sin amun Judaa. Naan ka fazei wana a Dorang Daxa iwana a bikabar zin Nakmai ma xa vira aubina wana atavura giazang faakdul. ");
INSERT INTO nal_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A dorang pana naan ka waan farawuk sin aubina vaakdul in Siria, malasing ma di zaxot fawat aubina vaakdul di gias pana atavur amun giazang faakdul zina, ma aubina di xazanin a maazikang lapuk, ma aubina ina amun sapalaau di ragul naandi, ma aubina dit gaga ma aubina ina di zipas ma naandi vaakdul Iesu xa vira naandi. ");
INSERT INTO nal_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Amun kulutung aubina in Gaalili ma Dekaapolis ma Jerusalem ma Judia ma ila non pira laza rita daanim Jodaan, di los naan. ");
INSERT INTO nal_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Araan Iesu xa raamin adi xulutung aubina, xa uzaa laaxur la rit aza wut, ma xa ziar. Ma ubina varaviraai zina di wat faraxulin naan. ");
INSERT INTO nal_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma xa varumara viraaiang naandi naako, ");
INSERT INTO nal_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aubina ina di raamin fakilaan adu di gof pana amun matmalabuk Nakmai xai sasaxot, naan ka lis a daxaiang sin naandi, wanaze a bikabar ila lia aaxan naandi. ");
INSERT INTO nal_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aubina ina di rataangis pana maskaluzang, Nakmai xa lis a daxaiang sin naandi, wanaze naan kana mada naandi. ");
INSERT INTO nal_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aubina ina dit mainof ma dit famumut naandi, Nakmai xa lis a daxaiang sin naandi, wanaze naan kana lis a pira vaakdul angkari zin naandi. ");
INSERT INTO nal_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aubina ina dit lagaai ma dit maaru zaxotang amun matmalabuk ka tak, Nakmai xa lis a daxaiang sin naandi, wanaze mur dina maazur. ");
INSERT INTO nal_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aubina ina dit faramaaluf, Nakmai xa lis a daxaiang sin naandi, wanaze naan kana maluf naandi. ");
INSERT INTO nal_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aubina ina ainaxamang sin naandi xa ninis, Nakmai xa lis a daxaiang sin naandi, wanaze dina raamin Nakmai. ");
INSERT INTO nal_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aubina ina dit fabalos a luaai, Nakmai xa lis a daxaiang sin naandi, wanaze naan kana vakilaan naandi a funalik sina. ");
INSERT INTO nal_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aubina ina dit fazaak a maazikang saxotang amun matmalabuk ka tak, Nakmai xa lis a daxaiang sin naandi, wanaze a bikabar ila lia aaxan naandi. ");
INSERT INTO nal_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Araan aubina di piaat faraksaat nim, ma di vamazik nim, ma di piaat a dorang taksaat pana nim ina xawit na vaaratunaan, panaze naagui los nia, Nakmai xa lis a daxaiang sinim. ");
INSERT INTO nal_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Naaguna dokdok ma naaguna nanam, panaze a wulwulang sinim ikula la lia xa laba marazaat, malasing saait amun profet ina di iziar waamua wana nim, aubina dit famazik naandi.” ");
INSERT INTO nal_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ma Iesu xa piaat kaarik naako, “Nim naagu malasing a rasmaxas sin aubina ila pira angkari. Singsaxai tamon a rasmaxas kana wen tauxin a miaana, dina giu malasing faa xuna xana rauxin kaarik a miaana? Kawit kaarik na daxa wana dina giu tazaan pana. Ka daxa be xuna dina xailungin pizin ma aubina dina was paramin. ");
INSERT INTO nal_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nim naagu malasing a maravas ila pira angkari. A bina laba xa iziar la waatawut kawit nat faraxas kana izi vunfun. ");
INSERT INTO nal_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aubina xawit dit failaap a laam ma di ratasin lawaana baakit. Kawit. Di ratasin fatok nanga la kin siziarang iwana, ma xai lis a maravas sin aubina vaakdul lamaskana vaal. ");
INSERT INTO nal_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Malasing saait bani, naaguna vatangin a maravas sinim lamarana aubina, xuna dina raamin amun gigiuang daxa zinim ma dina wisfalik Damana nim ina xa iziar ikula laaxur la lia.” ");
INSERT INTO nal_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ma Iesu xa piaat kaarik naako, “Tuaa naagu naxaam adu nia ga wat kuna zuruk pizinang amun Lus sin Moses faraxai wana dorang sin amun profet. Kawit. Ga wat kuna waambazovang naandi. ");
INSERT INTO nal_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ga vazei varatunaan nim, ka ruaas a lia ma a pira angkari dina malik iaa, xawit ta nan fararang mumut, ma xawit ta nan sina xizong di xalaar xana malik pana amun Lus sin Moses. Amun dorang kanaan kana iziar nanga malasing kanaan ka ruaas amun saan faakdul di waambazof. ");
INSERT INTO nal_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tamon axazak ka laxau ta nan lus mumut iwana amun lus faakdul angkari, ma xat firaai aubina adu naandi dina valos a matmalabuk angkanaan sina, Nakmai xana vakilaan naan adu naan ka mumut mase la bikabar ila lia. Singsaxai axazak kat falos fakdul naandi ma xat firaai aubina wana amun lus angkari, Nakmai xana vakilaan naan adu naan ka laaup la bikabar ila lia. ");
INSERT INTO nal_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Avuna ga vazei nim, tamon amun matmalabuk ka tak sinim, kawit na laaup pana amun matmalabuk ka tak sin amun Faarasi ma zin amun maravas iwana amun Lus sin Moses, naaguna wen libis mase la bikabar ila lia.” ");
INSERT INTO nal_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ma Iesu xa piaat kaarik naako, “Naagu ra langarin fanong adu amun kulmua zin dia mumua di zuruk a dorang malasing kari, ‘Tuaa ra zop famaatang taxazak. Nis nanga xa zop famaat axazak, kana rur wana aikilizang.’ ");
INSERT INTO nal_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Singsaxai ga vazei nim adu nis ka mangaring taatum sina lamaskana Kaarisito, naan kana rur wana aikilizang. Ma nis nanga xa piaat faraksaat taatum sina, xana rur wana aikilizang lamarana amun paamua laba. Singsaxai nis nanga xa piaat naako, ‘Gu rabanat,’ naan kat faraxas kana waan pana a bina iwana adi xaiaf kawit nai maat. ");
INSERT INTO nal_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Malasing ma tamon gu zuruk a talazang sunum kuna ralaazang Nakmai xula aalta, ma gu naxaam luk azaan taksaat gu ra giu wana taatum sunum ma a maravanang kanaan ka iziar nanga, ");
INSERT INTO nal_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","gu luaa xalaak a talazang sunum inaan lapaara aalta, ma gu waan sin taatum sunum ma gu vaamada varaxai wana naan ma mur gu uli ma gu lis a talazang sunum sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Araan axazak ka rasin nua wana aikilizang, gu waafatok fazaus a dorang faraxai wana naan, naapalaau tamon naagu zazangas iaa nanga la lan, paamua wana gu rur lamarana a rapti xai kilis. Taulaan kana lis nua la mit a rapti xai kilis ma a rapti xai kilis kana lis nua la mita ubina dauran ma naandi dina valbis nua la vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ga vazei varatunaan nua, guna wen tukbilak ka ruaas guna wul vakdul amun kaakaai angkanaan.” ");
INSERT INTO nal_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Iesu xa piaat kaarik naako, “Naagu langarin fanong di piaat malasing kari, ‘Tuaa naagu giu a matmalabuk taksaat iwana milivinang a ravin tawarak o a rapti rawarak.’ ");
INSERT INTO nal_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Singsaxai ga vazei nim, tamon a rapti xa raamin a ravin ma a inaxamang sina xa raksaat saxot naan, naan ka giu vanong a matmalabuk taksaat iwana milivinang a ravin tawarak faraxai wana a ravin angkanaan la inaxamang sina. ");
INSERT INTO nal_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tamon a xalimaraam la mit sazaxa xat faxalxaal nua xuna zuiang pana matmalabuk taksaat, bilok pizin ma gu psin. Ka daxa tamon ta non ila winum kana malik, kuna dina wen pizin fakdul a winum lamaskana a bina iwana adi xaiaf ina xawit nai maat. ");
INSERT INTO nal_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma tamon a mit sazaxa zunum kat faxalxaal nua xuna zuiang pana matmalabuk taksaat, kip pizin ma gu psin. Ka daxa tamon ta non ila winum kana malik, kuna dina wen pizin fakdul a winum lamaskana a bina iwana adi xaiaf kawit nai maat.” ");
INSERT INTO nal_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Iesu xa piaat kaarik naako, “Mumua di ra piaat malasing kari, ‘Axazak ka kip a maxuzang sin nandiaa taak sina, naan kana lis a waambaar iwana kipang a maxuzang sin taak sina.’ ");
INSERT INTO nal_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Singsaxai ga vazei nim, a rapti xa kip a maxuzang sin nandiaa taak sina araan taak sina xawit na giu a matmalabuk iwana milivinang a rapti rawarak, naan ka vaxalxaal taak sina xuna giuang a matmalabuk taksaat iwana milivinang a rapti rawarak, araan naan ka maxus kaarik. Ma a rapti ina xa maxus sina, naan saait ka giu a matmalabuk taksaat angkanaan.” ");
INSERT INTO nal_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ma Iesu xa piaat kaarik naako, “Naagu langarin fanong di ra vazei aubina mumua malasing kari, ‘Tuaa ra kipang a xalxalang sunum, singsaxai gu waambazof a xalxalang sunum sin a Piran.’ ");
INSERT INTO nal_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Singsaxai ga vazei nim, tuaa ra xalxalang pana tazaan. Tuaa naagu xalxal wana a lia, wanaze a lia xari akin izi xalxaalang sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma tuaa ra xalxalang pana a pira angkari, wanaze a pira angkari akin faiavuzang uru xaaka Nakmai. Ma tuaa zaait ta xalxalang pana Jerusalem, panaze Jerusalem kari a bina laba zin a Xalxaal Laba. ");
INSERT INTO nal_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma tuaa ra xalxalang pana a waarum, panaze xawit nat faraxas guna giu vabalos ta vur la waarum kana xufkuf o xana maxit. ");
INSERT INTO nal_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Naagu rudaxa be o naagu piaat kawit. Ma aze ra dorang kaarik naagu piaat fauzaa, xa wat sin a rapti raksaat.” ");
INSERT INTO nal_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Iesu xa piaat kaarik naako, “Naagu langarin fanong di piaat malasing kari, ‘Tamon axazak ka vamarawif a xalimarana aza xazak tawarak, dina vamarawif saait a xalimarana. Ma tamon axazak ka tukbuaak alvana aza xazak tawarak, dina tukbuaak saait alvana.’ ");
INSERT INTO nal_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Singsaxai ga vazei nim, tuaa naagu xis faulin a matmalabuk taksaat angkanaan axazak ka giu wana nim. Tamon axazak ka rabaaf a paarum la mit sazaxa, gu rutaawuk kuna xana rabaaf saait aza paarum la mit kais. ");
INSERT INTO nal_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma tamon axazak ka saxot kana rasin nua wana aikilizang kuna xana zuruk a marapi zunum i laaxur, gu lis saait a marapi baraaf sunum sina. ");
INSERT INTO nal_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma tamon axazak ka vangarin nua xuna fazakang ku naan pana a kilomita azaxai, gu fazak ku naan pana a kilomita urua. ");
INSERT INTO nal_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tamon axazak ka maainung nua wana tazaan, gu lis sina. Ma tamon axazak ka maainung tazaan ma mur naana lis faulin, tuaa gu piaat kawit.” ");
INSERT INTO nal_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ma Iesu xa piaat kaarik naako, “Naagu langarin fanong di piaat malasing kari, ‘Guna sasaxot a waliaanum ma guna maska raksaat pana a purua zunum.’ ");
INSERT INTO nal_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Singsaxai gana vazei nim, naaguna sasaxot aubina ina di purua wana nim ma naagu maainung sin Nakmai wana naandi ina di vamazik nim, ");
INSERT INTO nal_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kuna naaguna balas a funalik sin Damana nim la lia. Avuna naan kat fabalos a iaas sina xuna wilakang pana aubina raksaat ma aubina daxa, ma xai lis fawat a daavur xai zu laaxur wana aubina di tak ma aubina ina xawit di tak. ");
INSERT INTO nal_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tamon naagui sasaxot be naandi ina di sasaxot nim, aze ra wulwulang naaguna zuruk? A wat matmalabuk angkanaan aubina iwana zurukang a taakis saait di gigiu. ");
INSERT INTO nal_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma tamon naagui ruzuaai be amun daaza nim, naagu rawarak pana azanon malasing faa? Aubina zaait ina xawit di rexaazin Nakmai di gigiu malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Malasing ma nim naaguna gigiu amun matmalabuk ka tak faakdul malasing Damana nim la lia, naan ka tak faakdul.” ");
INSERT INTO nal_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesu xa piaat kaarik naako, “Naagu naknakaai! Tuaa naagu giu amun matmalabuk daxa be lamarana aubina xuna dina raamin nim. Tamon naagu giu malasing kanaan, Damana nim la lia xana wen lis ta wulwulang sinim. ");
INSERT INTO nal_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Malasing ma, araan naagu ralaas aubina di izi gogof, tuaa naagu vamaravaas labirua wana bina, malasing axazak ka wif a raavuru xuna aubina dina raamaai ma dina raamin a matmalabuk daxa zinim. Aubina ina xawit dit falos amun dorang sin naandi di gigiu malasing kanaan la vaal a maainungang ma lamun rita lan kuna aubina dina raamin amun matmalabuk sin naandi ma dina varanop pana naandi. Ga piaat faratunaan, di zuruk fanong a wulwulang faakdul zin naandi. ");
INSERT INTO nal_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Malasing ma araan naagu ralaas axazak ka izi gogof, tuaa a mit kais sinim kana rexaazin aze a mit sazaxa zinim ka giu, ");
INSERT INTO nal_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","xuna a talazang sinim kana vunfun be. Ma Damana nim singbe, ina xa rataamin aze naagu gigiu vunfunin, naan kana lis a wulwulang sinim.” ");
INSERT INTO nal_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ma Iesu xa piaat kaarik naako, “Ma araan naagu maainung, tuaa naagu malasing aubina ina xawit dit falos a dorang sin naandi, wanaze di sasaxot adu dina irur ma dinat maainung lamun faal a maainungang ma lamun rita lan kuna aubina dina raamin naandi. Ga vazei varatunaan nim, naandi di zuruk fanong a wulwulang faakdul zin naandi. ");
INSERT INTO nal_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Singsaxai araan gu maainung, gu albis la rumaaf sunum ma gu baraat kol a mara ma gu maainung sin Damaam ina xawit nat faraxas dina raamin naan. Damaam singbe, ina xa rataamin aze gu gigiu ma xawit nat faraxas azanon dina raamin, kana lis a wulwulang sunum. ");
INSERT INTO nal_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ma araan naagu maainung, tuaa naagu piaat a dorang ka varas kawit ta vuvuna, malasing aubina di wetexaazin Nakmai. Dit naxaam adu amun nakmai zin naandi dina langarin naandi avuna wana amun dorang ka varas naadi ipiaat. ");
INSERT INTO nal_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Malasing ma tuaa naagu malasing naandi, wanaze Damana nim ka rexaas faanong pana aze razaan naagu izi gogof pana, waamua wana naagu maainung naan. ");
INSERT INTO nal_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Malasing ma naaguna maainung malasing kari, ‘Damana maam la lia, aubina dina vaxoxok aizinum, ");
INSERT INTO nal_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","maadi saxot adu a bikabar zunum kana balas. Gu waambazof ainaxamang ma sasaxotang sunum iriat la pira angkari malasing saait ikula la lia. ");
INSERT INTO nal_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Talaas maam pana vanganang ku taning. ");
INSERT INTO nal_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Naxaam pizin amun matmalabuk taksaat simaam, malasing maam saait maadi naxaam pizin amun matmalabuk taksaat sin naandi ina di ra giu wana maam. ");
INSERT INTO nal_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma xana daxa tamon guna wen luaa maam ku lamaskana vaaxabebeuang, singsaxai gu zaxot faulin maam siaana rapti raksaat.’ ");
INSERT INTO nal_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tamon naagu naxaam pizin amun matmalabuk taksaat ina aubina di ra giu wana nim, Damana nim la lia zaait kana naxaam pizin amun matmalabuk taksaat sinim. ");
INSERT INTO nal_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Singsaxai tamon kawit naagu naxaam pizin amun matmalabuk taksaat sin naandi, Damana nim saait kana wen naxaam pizin amun matmalabuk taksaat sinim.” ");
INSERT INTO nal_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ma Iesu xa piaat kaarik naako, “Araan naagu valvaal wana vanganang, tuaa naagu vatangin lamarana nim, malasing aubina ina xawit dit falos a dorang sin naandi. Naandi di iplaas a marana naandi xa raamaai maaluf kuna vatanginang sin aubina adu naandi di valvaal wana vanganang. Ga vazei varatunaan nim, naandi di zuruk fanong a wulwulang faakdul zin naandi. ");
INSERT INTO nal_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Araan naagu valvaal wana vanganang, naagu zuksuk mara ma naagu rasin a wel la waata nim, ");
INSERT INTO nal_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kuna aubina xawit nat faraxas dina rexaas adu naagu valvaal wana vanganang, singsaxai Damana nim singbe, ina xawit nat faraxas dina raamin naan, kana raamin nim. Ma Damana nim, ina xa rataamin aze naagu gigiu ma xawit nat faraxas azanon dina raamin, naan kana lis a wulwulang sinim.” ");
INSERT INTO nal_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ma Iesu xa piaat kaarik naako, “Tuaa naagu gonin tasin amun lulugaan daxa aaxa nim nanga iriat la pira angkari, ina amun kokaros dina saxa wana ma a ros kana vanong psin ma amun finaau dina albis ma dina vinau. ");
INSERT INTO nal_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Singsaxai naagu gonin tasin amun lulugaan daxa aaxa nim nanga ikula la lia, ina amun kokaros dina wen saxa wana ma a ros kana wen fanong pizin ma amun finaau dina wen libis ma dina vinau. ");
INSERT INTO nal_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Avuna aze ra non amun lulugaan sunum ka iziar wana, ainaxamang sunum saait ka iziar inaan.” ");
INSERT INTO nal_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ma Iesu xa piaat kaarik naako, “Amun marana dia xari xa malasing a maravas ila wina dia. Tamon uru maraam di daxa iaa, a winum faakdul xana bas pana maravas. ");
INSERT INTO nal_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Singsaxai tamon uru maraam di raksaat iaa, a winum faakdul xana bas pana bungsuzuk. Ma tamon a maskaam ka bungsuzuk be, a bungsuzuk angkanaan kana suk baangut. ");
INSERT INTO nal_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kawit taxazak kat faraxas kana vaamuzas aaxan a mono urua. Naan kana maska raksaat pana axazak ma xana sasaxot aza xazak. Ma xana vaaratunaan be wana azaxai ma xana wiaal axazak. Kawit nat faraxas naaguna iaana kilaaiang sin Nakmai varaxai wana naaguna sasaxot famarazaat saait a kaakaai.” ");
INSERT INTO nal_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ma Iesu xa piaat kaarik naako, “Malasing ma ga vazei nim, tuaa naagu inaxam farvaras pana roroiang sinim o wana aze naaguna iaan o aze naaguna imin o wana a wina nim adu aze naaguna valaak. A roroiang sinim azaan laba wana a vanganang, ma a wina nim azaan laba wana amun marapi. ");
INSERT INTO nal_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Naagu raamin amun maani laaxur la ambara, naandi xawit dit faazu ma xawit dit laflaaf a vanganang ma xawit dit sirin turin a vanganang kula vaal a vanganang. Singsaxai Damana nim la lia xat favangaan naandi. Nim nanga naagu rexaas adu nim naagu laaup marazaat pana amun maani. ");
INSERT INTO nal_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kawit nat faraxas tazaxai zinim kana vadumduma xaarik nanga ta aaua azaxai wana a roroiang sina, araan ka inaxam farvaras pana a roroiang sina. ");
INSERT INTO nal_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ma xunaze naagu inaxam farvaras pana marapi? Naagu raamin amun iaai di rauxin amun purpur daxa, di mitai bok lauran. Kawit dit faamuzas ma xawit dit saba amun marapi aaxa naandi nanga. ");
INSERT INTO nal_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ga vazei nim, amun mamaauzang sin a xalxaal Solomon ka marmari daxa marazaat mase, singsaxai nanga a marmari daxaiang sin amun purpur angkari xa waramin sina. ");
INSERT INTO nal_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nakmai xa vamamaus amun lauran pana amun purpur daxa, ina taning be di rasin a purpur ma lamaf di vaif lamaskana a xaiaf. Tamon naan ka giu malasing kanaan pana amun lauran, malasing faa, xana wen famamaus saait nim? Ainaxam paazaaiang sinim ka xalxaalif. ");
INSERT INTO nal_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Malasing ma tuaa naagu inaxam farvaras ma naagu piaat malasing kari, ‘Maadina iaan aze?’, o ‘Maadina imin aze?’, o ‘Maadina valaak aze?’ ");
INSERT INTO nal_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aubina ina xawit di inaxam paazaai wana Nakmai, di inaxam farvaras pana zalengang amun saan angkanaan, singsaxai Damana nim ikula la lia, xa rexaas faanong adu naagu izi gogof pana amun saan angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Singsaxai azaan laba mase nim naaguna tabung giu xa malasing kari, naaguna zaleng kalaak amun matmalabuk ila bikabar zin Nakmai varaxai wana amun matmalabuk ka tak sina, ma amun saan faakdul angbani, naana lis saait sinim. ");
INSERT INTO nal_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Malasing ma tuaa naagu inaxam farvaras pana lamaf. A raan lamaf kana inaxam farvaras pana naan nanga. Ma amun taan saksaxai xa rauxin amun maravanang sina nanga.” ");
INSERT INTO nal_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesu xa piaat kaarik naako, “Tuaa naagu klis a matmalabuk sin azanon tawarak, taulaan Nakmai xana klis nim. ");
INSERT INTO nal_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Avuna aze ra lan naagu klis azanon pana, naan a lan angbani Nakmai xana klis faulin nim pana. Ma aze ra xarxarangang iwana ikilizang naagu giu wana azanon, Nakmai xana klis nim pana xarxarang angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kunaze gu raamaai be wana a nan bes ka iziar lamarana daazum ma xawit gu naxaam a vang palaang laba xa iziar la maraam? ");
INSERT INTO nal_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Araan ka rauxin a vang palaang la maraam, kunaze gu piaat sin daazum malasing kari, ‘Laawus gana waapizin a bes la maraam’? ");
INSERT INTO nal_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nua a rapti xawit gut falos a dorang sunum, paamua xalaak guna waapizin a vang palaang la maraam ma araan gu raamaai daxa laxo, guna waapizin a nan bes lamarana daazum. ");
INSERT INTO nal_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tuaa naagu lis amun saan ka xoxok sin amun piu, taulaan amun piu dina rutaawuk ma dina xaraat faraksaat nim. Ma tuaa naagu psin amun kuxut daxa zinim ina di giu wana amun katura zaang sin amun bari, taulaan amun bari dina was kixip pana xaaka naandi.” ");
INSERT INTO nal_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ma Iesu xa piaat kaarik naako, “Naagu maainung Nakmai ma naan kana lis sinim. Naagu saaleng ma naaguna tangin. Naagu pidik ma a mara xana ralakas pana nim. ");
INSERT INTO nal_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Avuna aubina vaakdul ina dit maainung, naan kana lis aze razaan naadit maainung pana, ma nis kai saaleng, kana tangin aze razaan naa zazaleng, ma nis kai pidik, a mara xana ralakas pana naan. ");
INSERT INTO nal_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ma nis sinim, tamon naatna xa maainung naan pana raraba, xana lis a vaat sina? ");
INSERT INTO nal_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O tamon ka maainung pana ian, kana lis a zizi raksaat sina? Kawit. ");
INSERT INTO nal_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Naapalaau nim naagu gigiu amun matmalabuk taksaat ka varas, naagu rexaas pana lizang amun talazang daxa zin a funalik sinim. Faaratunaan mase, Damana nim ikula la lia xana lis amun talazang daxa zin aubina dit maainung sina. ");
INSERT INTO nal_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Malasing ma wana amun matmalabuk faakdul naagu saxot aubina dina giu wana nim, naan amun matmalabuk angbani naaguna giu wana naandi. Awat matmalabuk angkanaan, naan aknaas amun Lus sin Moses ma amun dorang sin amun profet.” ");
INSERT INTO nal_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Iesu xa piaat kaarik naako, “Naaguna albis lamarana mara mumut. Avuna a marana mara xula milung tapal xa lapuk ma a lan ka waan pana, xa ralakas ma amala aubina di albis pana. ");
INSERT INTO nal_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Singsaxai a marana mara xa waan pana a roroiang ka mumut marazaat, ma a lan ka waan pana aubina xawit faras be di tangin.” ");
INSERT INTO nal_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iesu xa piaat kaarik naako, “Naaguna naknakaai wana amun profet faagit. Dina babof mara adu naandi di malasing nim. Naandi dina malasing amun sipsip lawalau amun sipsip. Singsaxai wana ainaxamang sin naandi di saxot dina vanong pizin nim malasing amun piu wungpung ina di ikarat. ");
INSERT INTO nal_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Naaguna raamin fakilaan naandi wana fnuaai a naandi. Aubina xawit di mos amun fnuaai a waain pana amun iaarus koxot. Ma xawit saait di mos amun fnuaai iwana fik pana amun iaai masang. Kawit. ");
INSERT INTO nal_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Malasing saait bani wana amun iaai daxa, dit fuain amun fnuaai daxa, singsaxai amun iaai raksaat dit fuain amun fnuaai raksaat. ");
INSERT INTO nal_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A iaai daxa xawit nat faraxas kana vuain a fnuaai iwana a iaai raksaat ma a iaai raksaat kawit nat faraxas kana vuain a fnuaai iwana a iaai daxa. Kawit. ");
INSERT INTO nal_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Amun iaai vaakdul ina xawit dit fuain a fnuaai daxa, dina raraai psin naandi ma dina psin lamaskana xaiaf. ");
INSERT INTO nal_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ka malasing saait kanaan pana amun profet faagit, naaguna raamin fakilaan naandi wana amun fnuaai iwana vaamuzazang sin naandi. ");
INSERT INTO nal_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kawit aubina vaakdul ina dit fakilaan nia, ‘Piran, Piran,’ dina albis la bikabar ila lia. Kawit. Singsaxai naandi be ina dit falos a sasaxotang ma ainaxamang sin Maagu ikula la lia, naandi dina albis la bikabar. ");
INSERT INTO nal_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","La raan iwana aikilizang, amala dina piaat surugu malasing kari, ‘Piran, Piran, pana aizinum maadi dador profet, ma wana aizinum maadi mof pizin amun sapalaau, ma wana aizinum maadi giu amun faamuzazang ka banglala.’ ");
INSERT INTO nal_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Singsaxai gana vazei be naandi malasing kari, ‘Ga wetexaazin nim. Nim aubina raksaat! Naagu waan siaagu!’ ” ");
INSERT INTO nal_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Iesu xa piaat kaarik naako, “Malasing ma aubina vaakdul dit langarin a dorang surugu ma naadit falos, di malasing a rapti mazam ina xa giu a vaal zina laaxur wana vaat siar. ");
INSERT INTO nal_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Araan a daavur xa uzan, ma a daanim ka ulim ma a maaliu xa taaif dikdik ma xa valvalingin a vaal angkanaan, kawit mase na zu, wanaze xa irur laaxur wana vaat siar. ");
INSERT INTO nal_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Singsaxai aubina vaakdul dit langarin a dorang surugu ma xawit dit falos, di malasing a rabanat ina xa giu a vaal zina laaxur wana xon. ");
INSERT INTO nal_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Araan a daavur xa uzan ma a daanim ka ulim ma a maaliu xa taaif dikdik ma xa valvalingin a vaal angkanaan, a vaal xa rambara ma a lingna xa pau lapuk mase.” ");
INSERT INTO nal_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Araan Iesu xa piaat fanong amun saan angkanaan, amala aubina inaan di banglala wana varaviraaiang sina, ");
INSERT INTO nal_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","wanaze xa varaviraai malasing a rapti ina Nakmai nanga xa lis a burburaaiang sina. Kawit na varaviraai malasing amun maravas iwana amun Lus sin Moses dit faraviraai. ");
INSERT INTO nal_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Araan Iesu xa kabal wat paanaburut la rita wut, amun kulutung aubina di los naan. ");
INSERT INTO nal_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma aza rapti xa rauxin a giazang tapak ka wat sibukaak lamarana Iesu ma xa piaat naako, “Piran, tamon gu saxot, gu vira nia xuna gana ninis lamarana Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ma Iesu xa vatok a mitna ma xa xaaf a wina rapti ma xa piaat naako, “Ga saxot! Gu ninis!” Fazaaus mase a tapak la wina rapti xa vaanong, ma a wina xa ninis. ");
INSERT INTO nal_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ma Iesu xa piaat sina naako, “Gu langar! Tuaa gu vazei taxazak pana aze razaan ka balas sunum. Singsaxai gu waan ma gu vatangin a winum sin a pris, ma gu lis a talazang sin Nakmai malasing ina Moses ka ra piaat lamaskana Baar Xoxok, kuna aubina vaakdul dina rexaas adu a giazang sunum ka vaanong.” ");
INSERT INTO nal_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ma araan Iesu xa albis la bina Kaapernaaum, a waamua zin azangaaflu varazuai ubina dauran in Rom ka wat ma xa iaari zin Iesu xuna vawaalang naan. ");
INSERT INTO nal_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ma xa piaat malasing kari, “Piran, a iaana kilaaiang surugu xa itate gigias la vaal, a wina xa maat pop saxai ma xa xazanin adi maazikang lapuk.” ");
INSERT INTO nal_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ma Iesu xa xis naan malasing kari, “Gana wa vira naan.” ");
INSERT INTO nal_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Singsaxai a waamua zin ubina dauran ka xis naan naako, “Piran, nia xawit a rapti daxa xuna guna albis la vaal zurugu. Singsaxai gu piaat be ma Nakmai xana vira naan. ");
INSERT INTO nal_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Avuna nia zaait ga iziar lawaana burburaaiang sin amun paamua zurugu, ma azanon ubina dauran di iziar lawaana burburaaiang surugu. Ma araan ga piaat sin azaxai angkari, ‘Paan,’ naan ka waan. Ma araan ga piaat sin axazak angkanaan, ‘Laawus,’ naan ka wat. Ma araan ga piaat sin a iaana kilaaiang surugu malasing kari, ‘Gu giu azaan angkari,’ naa giu.” ");
INSERT INTO nal_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Araan Iesu xa langarin a dorang kanaan, ka raknar ma xa vazei aubina ina di los naan naako, “Ga vazei varatunaan nim, kawit nanga ga tangin taxazak in Israael, ainaxam paazaaiang sina xa laba malasing kari. ");
INSERT INTO nal_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ga vazei nim adu aubina xa varas dina ramaraat fataling amun bina di iziar la non a iaas kai laak pana ma la non a iaas kai si wana, ma dina wat iziar wana flangan laba ma dina vangan faraxai wana Aabaraam, ma Aaisaak ma Jekop lamaskana bikabar ila lia. ");
INSERT INTO nal_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Azanon Judaa di naxaam adu dina albis la bikabar angkanaan, singsaxai Nakmai xana psin fatukbilok naandi xula non bungsuzuk, a non ina di rataangis ma dit karaat alvana naandi.” ");
INSERT INTO nal_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Naanaan Iesu xa vazei a waamua zin ubina dauran malasing kari, “Paan kabe, azaan kana balas malasing gu inaxam paazaai wana.” Ma la notaan angkanaan nanga a giazang ka vataling a iaana kilaaiang sina. ");
INSERT INTO nal_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Araan Iesu xa albis la vaal zin Pita, xa raamin nimuna Pita xa win lagaf ma xa itate la wina iban. ");
INSERT INTO nal_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu xa xaaf a mitna ma a giazang ka vaanong pana naan, ma xa ramaraat ma xa nimnimanin a vanganang aaxan Iesu. ");
INSERT INTO nal_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Languzaraaf angkanaan, di wat sin Iesu ma di zaxot fawat amala aubina ina amun sapalaau di ragul naandi. Ma Iesu xa mof pizin amun sapalaau wana dorang sina be ma di tukbilak siaana aubina angkanaan, ma xa vira naandi vaakdul ina di gias. ");
INSERT INTO nal_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Azaan angkanaan ka balas ka waambazof a dorang sin Nakmai ina a profet Aaisaaia xa ra piaat naako, “Naan nanga xa vazaak pizin amun maazikang sin dia, ma xa zuruk pizin amun giazang sin dia.” ");
INSERT INTO nal_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Araan Iesu xa raamin adi mala aubina di irur varaxulin naan, ka vazei ubina varaviraai zina adu dina kas buak kulaza non rita laman. ");
INSERT INTO nal_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma aza maravas iwana amun Lus sin Moses ka wat sina ma xa vazei naan naako, “Maravas, gana los nua xu lamun non faakdul gu waan pana.” ");
INSERT INTO nal_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Iesu xa xis naan malasing kari, “Amun piu wungpung di rauxin amun luk lamaskana pira, ma amun maani di rauxin amun nu zin naandi. Singsaxai Naata Rapti xawit ta non kuna vatateiang a waatna ma xana ziaavus lamaskana.” ");
INSERT INTO nal_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma aza rapti varaviraai xa piaat sina naako, “Piran, luaa xalaak nia wana notaan mumut kuna gana wa xavin maamaa zurugu.” ");
INSERT INTO nal_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Singsaxai Iesu xa piaat sina malasing kari, “Los nia, ma luaa aubina di maat, dina xavin a maat sin naandi.” ");
INSERT INTO nal_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Naanaan Iesu xa xawas pana a mon ma ubina varaviraai zina di waan faraxai wana naan. ");
INSERT INTO nal_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Fazaaus mase adi maaliu xa ramaraat la laman ma a rof ka rambur wana a mon. Singsaxai Iesu xai milaaif. ");
INSERT INTO nal_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ubina varaviraai di waan ma di wangun naan, di piaat malasing kari, “Piran! Fawaal dia! Dia dina samura xanak!” ");
INSERT INTO nal_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma Iesu xa xis naandi naako, “Kunaze naagu maraaut? Ainaxam paazaaiang sinim ka xalxaalif.” Ka ramaraat ma xa vadawaar a maaliu varaxai wana rof ma a laman ka malaai. ");
INSERT INTO nal_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Naandi di banglala mase ma di piaat malasing kari, “Aze rawat tapti mase xari? A maaliu ma a rof di langar iaa zaait sina!” ");
INSERT INTO nal_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Araan Iesu xa wat balas laza rita Laman Gaalili, la non pira zin aubina in Gaadaraa, aza ru rapti ina amun sapalaau di ragul nandiaa, di tukbilak iaa lamun baaul a maat ma di vasuin iaa naan. Nandiaa di rabanat iaa mase, malasing ma xawit taxazak kai lu la lan angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ma di viraai iaa malasing kari, “Naata Nakmai, aze razaan gu saxot guna giu wana nimaa? Malasing faa, gu wat kari xuna vamazikang nimaa? Singsaxai a raan Nakmai xa ra kalin kuna vamazikang nimaa xawit nanga na balas.” ");
INSERT INTO nal_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Adi lemlem bari di isuar lawalaau vaamumut pana naandi. ");
INSERT INTO nal_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ma amun sapalaau angkanaan di maainung Iesu malasing kari, “Tamon gu mof pizin maam, guna kling maam ku lamaskana adi lemlem bari angkapaa.” ");
INSERT INTO nal_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma Iesu xa vazei naandi naako, “Naagu waan!” Ma amun sapalaau angkanaan di tukbilak ma di albis lamaskana amun bari. Ma adi lemlem bari vaakdul angbani di zazarai wizik lalos a rita wut ina xa ru vaatak, ma di zu lamaskana laman ma di xanak ma naandi vaakdul di maat. ");
INSERT INTO nal_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma aubina ina dit katkatong amun bari, di valaau. Di waan la bina ma di kus sin aubina wana aze razaan ka balas ma di kus saait pana aze xa balas sin uru rapti ina amun sapalaau di ragul nandiaa. ");
INSERT INTO nal_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma aubina vaakdul ila bina laba angkanaan di waan kuna raaminang Iesu. Ma araan di raamin naan, di iaari zina xuna xana waan fataling a non pira zin naandi. ");
INSERT INTO nal_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu xa xawas pana a mon ma xa kas buak kulaza rita laman ma xa balas la bina zina vaatak. ");
INSERT INTO nal_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ma azanon ubina di vazaak aza zipas pana a iban xa waan sina. Araan Iesu xa raamin ainaxam paazaaiang sin naandi, xa piaat sin a zipas naako, “Naarugu, gu dikdik, ga naxaam pizin fanong amun matmalabuk taksaat sunum.” ");
INSERT INTO nal_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Azanon maravas iwana amun Lus sin Moses di langarin a dorang kanaan ma di piaat lawalaua naandi nanga malasing kari, “A rapti angkanaan ka lingpuak, ka dador malasing adu naan Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu xa rexaazin ainaxamang sin naandi ma xa piaat naako, “Kunaze naagu rauxin awat inaxamang taksaat lamaskana nim? ");
INSERT INTO nal_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Malasing faa, gana piaat, ‘Ga naxaam pizin fanong amun matmalabuk taksaat sunum,’ o gana piaat, ‘Tamaraat ma gu waan’? Aze ra dorang ka maravas kuna piaatang? ");
INSERT INTO nal_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Singsaxai ga piaat malasing kanaan kuna naaguna rexaas adu Naata Rapti xa rauxin a burburaaiang kuna naxaam pizinang amun matmalabuk taksaat iriat la pira angkari.” Naanaan ka vazei a zipas angkanaan naako, “Tamaraat, suruk luk a xaazira zunum ma gu waan la vaal zunum.” ");
INSERT INTO nal_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma a rapti angkanaan ka ramaraat ma xa waan la vaal zina. ");
INSERT INTO nal_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Araan adi mala aubina di raamin aze razaan ka balas, di banglala mase ma di wisfaru aizina Nakmai, ina xa lis awat burburaaiang kari zin aubina. ");
INSERT INTO nal_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Araan Iesu xa ramaraat ma xa waan, ka raamin a rapti aizina Metiu, xa iziar la vaal iwana zuzurukang a taakis. Ma xa vazei naan malasing kari, “Gu los nia.” Ma Metiu xa ramaraat ma xa los naan. ");
INSERT INTO nal_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lamur araan Iesu xa vavangan la vaal zin Metiu, ubina xa varas iwana zuzurukang a taakis ma aubina raksaat di wat sina ma di vangan faraxai wana Iesu ma ubina varaviraai zina. ");
INSERT INTO nal_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Araan amun Faarasi di raamin malasing kanaan, di iaari zin ubina varaviraai zina malasing kari, “Kunaze a maravas sinim ka vangan faraxai wana ubina di zuzuruk a taakis ma aubina raksaat?” ");
INSERT INTO nal_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu xa langarin ma xa piaat malasing kari, “Aubina a roroiang sin naandi xa daxa, dina wen paan sin a dokta. Kawit. Aubina be ina di gias, naandi di wanpaan sin a dokta. ");
INSERT INTO nal_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Naagu waan ma naagu zaleng aknaaza dorang lamaskana Baar Xoxok ina xa piaat naako, ‘Ga sasaxot famarazaat a matmalabuk iwana varamaaluvang, ma xawit amun talazang ina naagut faif.’ Avuna xawit ga wat iriat saxotang aubina di tak. Kawit! Ga wat saxotang aubina raksaat.” ");
INSERT INTO nal_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naanaan ubina varaviraai zin Jon di wat iaari zin Iesu malasing kari, “Kunaze maam faraxai wana amun Faarasi maadit falvaal wana vanganang ma ubina varaviraai zunum kawit dit falvaal?” ");
INSERT INTO nal_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Iesu xa xis naandi naako, “Kawit nat faraxas pana amun topuran sin a rapti adu xana maxus, dina maskalus araan naan ka iziar nanga varaxai wana naandi. Singsaxai xa rauxin a raan kana balas, araan dina zaxot pizin a rapti angkanaan siaana naandi, ma naandi laxo dina valvaal. ");
INSERT INTO nal_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kawit taxazak kat saxazit kol a non tamatar wana a marapi xabaar wana a waan marapi vaaxur. Kawit. Tamon naana giu malasing kanaan, a waan marapi vaaxur xana fis ma xana urif taraar a marapi xabaar, ma a non tamatar xana vut laba laxo. ");
INSERT INTO nal_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma xawit taxazak kat fitor sfaar a waain faaxur xu lamaskana a wakpaaka waain kabaar ina di giu wana a wina xaktalavaat. Tamon naana giu malasing kanaan, a wakpaak a waain kabaar xana ring ma xana pau ma a waain faaxur xana ravukaai psaai ma a wakpaaka waain angkanaan kana vaanong mase. Singsaxai dit fitor sfaar nanga a waain faaxur xu lamaskana a wakpaaka waain faaxur xuna nandiaa varaxai dina daxa iaa.” ");
INSERT INTO nal_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Araan Iesu xai dador nanga, aza waamua xa wat ma xa zibukaak lamarana, ma xa piaat naako, “Nativugu xa samura maat be. Singsaxai laawus ma gu rasin a mirum pana naan kuna xana roro uli xaarik.” ");
INSERT INTO nal_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu xa ramaraat ma xa waan faraxai wana naan ma ubina varaviraai zina di los nandiaa. ");
INSERT INTO nal_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kawit nanga lawalaau ma aza ravin ina xa rauxin a dari laba wana a maariaas ka zangaaflu ma urua, xa wat lamuraana ma xa xaaf a zuva marapi baraaf sina. ");
INSERT INTO nal_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Avuna a ravin angkanaan ka naxaam malasing kari, “Tamon ga xaaf be a zuva marapi baraaf sina, gana roro daxa.” ");
INSERT INTO nal_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu xa rutaawuk ma xa raamin naan. Ma xa piaat naako, “Nativugu, gu dokdok, ainaxam paazaaiang sunum ka vira nua.” Ma la notaan angkanaan mase, a giazang ka vaanong ma a ravin angkanaan ka roro daxa. ");
INSERT INTO nal_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Araan Iesu xa albis lamaskana vaal zin a waamua angkanaan, ka raamin aubina di wifpif amun lexu wana ranganang iwana maat ma aubina xa varas di vaanggala wana rataangis. ");
INSERT INTO nal_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma naan ka piaat naako, “Naagu tukbilak, a fnaalik angkari xawit na maat. Naan kai milaaif be.” Singsaxai di vanangon naan. ");
INSERT INTO nal_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Araan di kling fatukbilok fanong mala aubina angkanaan, Iesu xa albis lamaskana rumaaf ma xa roting a mita fnaalik, ma a fnaalik ka ramaraat. ");
INSERT INTO nal_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma a dorang pana azaan Iesu xa ra giu, xa waan farawuk lamun non faakdul angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Araan Iesu xa ramaraat ma xa waan, uru marawif di los iaa naan, ma dit firaai iaa malasing kari, “A Natnaat Sin Dewit! Maluf nimaa!” ");
INSERT INTO nal_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesu xa albis la vaal ma uru marawif di wat iaa zina. Ma xa iaari zin nandiaa naako, “Malasing faa, naagu inaxam paazaai iaa adu xat faraxas nia gana giu azaan angkanaan?” Ma di xis iaa naan malasing kari, “Piran, aiang.” ");
INSERT INTO nal_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma naan ka xaaf amun marana nandiaa ma xa piaat naako, “Azaan angkanaan kana balas lalozang ainaxam paazaaiang sunumaa.” ");
INSERT INTO nal_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Naan laxo amun marana nandiaa xa ralakas ma di raamaai iaa. Ma Iesu xa dador dikdik sin nandiaa malasing kari, “Tuaa naagu vazei iaa taxazak pana azaan nia ga giu wana numaa.” ");
INSERT INTO nal_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Singsaxai di waan iaa ma di wa fazei varawuk iaa wana azaan angkanaan lamaskana a non faakdul angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Araan uru rapti di waan faanong iaa, azanon aubina di zaxot fawat aza rapti zin Iesu, ina a zapalaau xa ragul naan, ma xawit nat faraxas kana dador. ");
INSERT INTO nal_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Araan Iesu xa mof pizin a zapalaau angkanaan, a rapti ina xawit nai dador, xa dador laxo. A xulutung aubina di banglala ma di piaat malasing kari, “Dia xawit di rataamin awat saan malasing kanaan iriat la pira in Israael.” ");
INSERT INTO nal_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Singsaxai amun Faarasi di piaat malasing kari, “Naan kai mof pizin amun sapalaau wana dikdikang sin a waamua zin amun sapalaau.” ");
INSERT INTO nal_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu xa rai lu labirua wana amun bina vaakdul, ma xat faraviraai lamaskana amun faal a maainungang sin naandi ma xai fazei wana a Dorang Daxa wana a bikabar ma xat fira aubina vaakdul wana amun giazang sin naandi. ");
INSERT INTO nal_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Araan ka raamin adi mala aubina, naan ka rauxin a varamaaluvang pana naandi. Avuna ainaxamang sin naandi xa baabaa varawuk laaxur wana amun maravanang sin naandi ma xawit di rauxin taxazak kuna vawaalang naandi. Di malasing amun sipsip ina xawit ta rapti xa rataamaai xaaul wana naandi. ");
INSERT INTO nal_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma naan ka vazei ubina varaviraai zina malasing kari, “A vanganang kuna laavang ka varas, singsaxai ubina vaamuzazang kawit faras be. ");
INSERT INTO nal_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Malasing ma naaguna maainung sin a Piraana laflaavang, kuna naan kana kling tazanon ubina vaamuzazang kula uma zina.” ");
INSERT INTO nal_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu xa viring fawat ubina varaviraai zina, xa zangaaflu ma urua ma xa lis a burburaaiang sin naandi xuna mof pizinang amun sapalaau ma xuna viraiang aubina wana amun giazang. ");
INSERT INTO nal_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Naan aizina amun aaposal, xa zangaaflu ma urua xari: A varumaraiang kari Saaimon, ina Iesu xa vakilaan naan pana Pita, ma daasna Endru, ma uru naata Zebedi, Jems ma daasna Jon, ");
INSERT INTO nal_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ma Filip ma Baatalomeu, ma Tomaas ma Metiu, a rapti iwana zuzurukang a taakis, ma aza Jems, ma naata Aalfias, ma Taadius, ");
INSERT INTO nal_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma aza Saaimon, sin a lemlem Zelot, ma Judaas Iskaariot, ina mur xana ngutlis Iesu zin amun purua. ");
INSERT INTO nal_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu xa kling pizin amun aaposal xa zangaaflu ma urua varaxai wana dorang dikdik malasing kari, “Tuaa naagu waan lawalau aubina xawit amun Judaa, ma tuaa naagu albis la non sin amun Samaaria. ");
INSERT INTO nal_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Naagu waan be zin amun sipsip in Israael, naandi di milung. ");
INSERT INTO nal_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Araan naagu waan, naagu fazei malasing kari, ‘A bikabar ila lia xa wat faasilik faanong.’ ");
INSERT INTO nal_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ma naagu vira aubina wana atavura giazang, ma naagu varamaraat faulin amun maat, ma naagu vira aubina di rauxin a giazang tapak kuna dina ninis lamarana Nakmai, ma naagu mof pizin amun sapalaau. Ga lis palau a burburaaiang kari malasing a talazang aaxanim, kuna nim naaguna lis palau zaait sin aubina malasing a talazang. ");
INSERT INTO nal_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tuaa naagu flus funfunin a goul o siliwa o kopa lamaskana baak sinim. ");
INSERT INTO nal_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ma araan naagu waan, tuaa naagu roting ta laxa, o ta marapi xuna xulxulang, o ta su o ta laak. Avuna xa tak pana a rapti xat faamuzas kana zuruk a vanganang sina wana vaamuzazang sina. ");
INSERT INTO nal_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Araan naagu albis lamaskana ta bina, naagu zaleng ta axazak ka rauxin aiza daxa inaan, ma naagu iziar varaxai wana naan la vaal zina, xa ruaas a raan naagu ramaraat fataling a bina angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Araan naagu albis la vaal angkanaan, naagu vazei naandi malasing kari, ‘A luaai xa iziar varaxai wana nim.’ ");
INSERT INTO nal_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tamon aubina ila vaal angkanaan di ruzuaai nim, a dor daxaiang sinim iwana a luaai xana iziar inaan faraxai wana naandi. Singsaxai tamon kawit di ruzuaai nim, naagu zuruk faulin a dor daxaiang sinim iwana a luaai ma xana uli varaxai wana nim. ");
INSERT INTO nal_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tamon taxazak kawit na ruzuaai nim o xawit na langarin a dorang sinim, naagu taaf pizin a paauf la xaaka nim araan naagu vataling a vaal o a bina angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ga piaat faratunaan sinim, la raan iwana aikilizang, a maravanang ina Nakmai xana lis sin aubina ilamaskana bina angkanaan, kana laba mase wana a maravanang ina naa ra lis sin aubina in Sodom ma Gomoraa.” ");
INSERT INTO nal_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iesu xa piaat kaarik naako, “Naagu langar! Ga kling nim malasing amun sipsip di zangas paan lawalau amun piu wungpung di karat. Malasing ma naaguna mazam malasing amun sizi ma naaguna mainof malasing amun baalus. ");
INSERT INTO nal_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Naagut naknakaai wana aubina. Dina zaraak nim ma dina lis nim la mita ubina di ikilis ma dina kmis nim pana wip lamaskana amun faal a maainungang sin naandi. ");
INSERT INTO nal_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dina urif nim panaze naagui los nia, ma dina varur nim lamarana amun paamua laba zin a gaapman ma amun kalxaal xuna naaguna pitfiaat ainaxam paazaaiang sinim sin naandi ma zin aubina xawit amun Judaa. ");
INSERT INTO nal_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Singsaxai araan di zaraak nim, tuaa naagu inaxam farvaras pana aze razaan naaguna piaat o naaguna mita ipiaat, avuna la notaan angkanaan Nakmai nanga xana vazei nim pana dorang naaguna piaat, ");
INSERT INTO nal_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","panaze xawit nim ka naagu dador. Kawit. A Laklagai zin Damana nim kana rasin a dorang la nguza nim. ");
INSERT INTO nal_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","A rapti xana ngutlis daasna xuna dina zop famaat naan, ma maamaa xana giu zaait malasing kanaan pana naatna. Ma a funalik dina bain a valozang a dorang sin amun damana naandi ma dina naandi ma dina vazei aubina dina zop famaat naandi. ");
INSERT INTO nal_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Aubina vaakdul dina maska raksaat pana nim lalozang nia. Singsaxai nis ka irur dikdik ka ruaas a vaanongang, Nakmai xana zaxot faulin naan. ");
INSERT INTO nal_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Araan di vamazik nim lamaskana ta bina, naagu valaau xu laza bina. Ga piaat faratunaan sinim, naaguna wen fanong nanga vaamuzazang sinim lamun bina laba vaakdul in Israael, ma Naata Rapti xana balas. ");
INSERT INTO nal_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","A nalik faraviraai xawit na laaup pana a maravas sina. Kawit. Ma a iaana kilaaiang kawit na laaup pana a mono zina. ");
INSERT INTO nal_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kat faraxas a nalik faraviraai xana malasing a maravas sina ma a iaana kilaaiang malasing a mono zina. Tamon damana vaal di vakilaan pana Belzebul, aubina zaait lamaskana vaal angkanaan dina vakilaan naandi wana amun iza xa raksaat mase.” ");
INSERT INTO nal_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Iesu xa piaat kaarik naako, “Malasing ma tuaa naagu maraaut pana amun purua angkanaan sinim. Amun saan faakdul ina di flus kol, mur dina kaas pizin, ma amun saan faakdul ina xa izi vunfun, mur xana balas la maravas. ");
INSERT INTO nal_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aze ga vazei nim pana la bungsuzuk, naaguna piaat la waanaas. Aze ra dorang ga ngif la alngana nim, naaguna rur lawaata vaal ma naaguna pitfiaat sin aubina. ");
INSERT INTO nal_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tuaa naagu marauring aubina ina dina zop famaat a winpina nim singsaxai xawit nat faraxas dina zop famaat a laklagaaia nim. Singsaxai naaguna marauring Nakmai ina xat faraxas kana vanong a laklagaaia nim faraxai wana a winpina nim lamaskana a bina iwana adi xaiaf kawit nai maat. ");
INSERT INTO nal_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Naagu rexaas adu aubina di wulwul a kaana masmaas urua wana a nan kaakaai mumut. Singsaxai xawit tazaxai zin naandi xana maat tamon Maamaa xawit na rudaxain. ");
INSERT INTO nal_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Faaratunaan mase, Nakmai xa rexaazin amun fur vaakdul la waata nim. ");
INSERT INTO nal_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Malasing ma tuaa naagu maraaut, avuna nim naagu laaup marazaat mase wana amun masmaas ka varas lamarana Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ma Iesu xa piaat kaarik naako, “Axazak kai dador vaamaravas lamarana aubina adu naan surugu, nia zaait gana dador vaamaravas lamarana Maagu la lia adu naan surugu. ");
INSERT INTO nal_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Singsaxai axazak kai wispuxin nia lamarana aubina, nia zaait gana wispuxin naan lamarana Maagu la lia.” ");
INSERT INTO nal_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma Iesu xa piaat kaarik naako, “Tuaa naagu naxaam adu ga wat kuna lizang a luaai iriat la pira angkari. Kawit. Ga wat kuna lizang a baainaat kuna varopang. ");
INSERT INTO nal_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ga wat kuna vabalozang amun matmalabuk malasing kari, ‘a rapti xana purua wana damana, ma natifna xana purua wana dina, ma ninana xana purua wana dina labana. ");
INSERT INTO nal_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aubina lamaskana vaal zin a rapti, naandi nanga dina balas amun purua zina.’ ");
INSERT INTO nal_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tamon a matmalabuk sin axazak iwana sasaxotang damana o dina xa laaup pana a matmalabuk iwana sasaxotang sina wana nia, xawit nat faraxas gana vakilaan naan adu naan axazak surugu. Ma tamon a sasaxotang sin axazak pana naatna o natifna xa laba wana sasaxotang sina wana nia, xawit nat faraxas gana vakilaan naan adu naan axazak surugu. ");
INSERT INTO nal_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma axazak kawit na vazaak a robuxul zina ma xa los nia, naan kawit nat faraxas kana balas a rapti varaviraai zurugu. ");
INSERT INTO nal_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Axazak ka saxot kana roting falagot a roroiang sina, a roroiang sina xana milung siaana. Ma axazak ka lis pizin a roroiang sina saxotang nia, naan kana tangin a roro tapal.” ");
INSERT INTO nal_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ma Iesu xa piaat kaarik naako, “Axazak kai ruzuaai nim, naan kai ruzuaai nia. Ma axazak kai ruzuaai nia, naan kai ruzuaai axazak ina xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Axazak kai ruzuaai a profet avuna xa rexaas adu naan a profet, naan saait kana zuruk a wulwulang bani malasing sin a profet. Ma axazak kai ruzuaai axazak ka tak avuna xa rexaas adu naan ka tak, naan kana zuruk a wulwulang malasing bani zin axazak ka tak. ");
INSERT INTO nal_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ga piaat faratunaan sinim, tamon axazak ka lis a daanim pana win imiminang sin azaxai zin naandi ina xawit ta izina lawalau aubina, avuna naan a rapti varaviraai zurugu, naan kana zuruk faratunaan a wulwulang sina.” ");
INSERT INTO nal_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Araan Iesu xa vanong a dorang dikdik sina wana a zangaaflu ma urua ubina varaviraai zina, xa ramaraat inaan ma xa waan kuna xana wa viraai aubina ma xana wa fazei lamun bina laba in Gaalili. ");
INSERT INTO nal_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon ka iziar la vaal a vaamaazikang ma araan ka langar wana amun gigiuang a Mesaaia xa gigiu, xa kling azanon ubina varaviraai zina ");
INSERT INTO nal_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","xuna iaariang sin Iesu malasing kari, “Malasing faa, naan nua xari axazak ina Nakmai xa ra xalxalin adu xana balas, o axazak tawarak nanga maadina zimbong?” ");
INSERT INTO nal_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma Iesu xa xis naandi naako, “Naagu uli ma naagu vazei Jon pana aze razaan naagu langarin ma naagu raamin. ");
INSERT INTO nal_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Amun saan malasing amun marawif di raamaai, ma amun kaak taksaat di zangas, ma aubina di gias pana tapak di ninis, ma amun lingambat di langar, ma amun maat di ramaraat puli, ma aubina di izi gogof di langarin a Dorang Daxa. ");
INSERT INTO nal_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Axazak ka raamin amun saan angkari ga vabalos, ma ainaxam paazaaiang sina xawit na zu, naan kana zuruk a daxaiang.” ");
INSERT INTO nal_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Araan ubina varaviraai zin Jon di waan faanong, Iesu xa vazei amala aubina angkanaan pana Jon naako, “Aze naagu ra raamin araan naagu waan la non bingil? Iaak naagu wa xalim be a waxana ri ina xa ritiria araan a maaliu xai wif? ");
INSERT INTO nal_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tamon kawit, aze naagu wa raamin? A rapti xa mamaaus pana marapi xa marmari daxa? Kawit. Ubina ina dit mamaaus pana marapi xa marmari daxa di iziar lamaskana amun faal laba zin amun kalxaal. ");
INSERT INTO nal_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Singsaxai aze xa naagu wa raamin? A profet? Aiang faaratunaan. Ga vazei nim, a profet angkari Jon, a vaamuzazang sina xa laaup pana amun profet. ");
INSERT INTO nal_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ma di ra varaar vating lamaskana a Baar Xoxok pana naan malasing kari, ‘Gana kling a wangpaang surugu waamua wana nua, ma xana nimnimanin a lan sunum.’ ");
INSERT INTO nal_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ga piaat faratunaan sinim, Jon A Rapti Iwana Baaptaaizang ka laaup pana aubina vaakdul ina di ra luk naandi, xa utuaas la notaan angkanaan, singsaxai axazak ina xa mumut mase la bikabar ila lia, naan ka laaup pana Jon. ");
INSERT INTO nal_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","La raan Jon A Rapti Iwana Baaptaaizang ka varumara fazeiang pana dorang sin Nakmai ma xa utuaas taning, a bikabar ila lia xa wat faraxai wana dikdikang ma xat laba uzaa, ma aubina dikdik di gut kuna albizang lamaskana. ");
INSERT INTO nal_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Avuna amun profet ma amun Lus sin Moses di pitfiaat a dorang sin Nakmai, xa ruaas Jon ka balas. ");
INSERT INTO nal_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma tamon naagu saxot naaguna rudaxain a dorang kanaan, Jon bani Elaaija, ina a Baar Xoxok ka ra piaat adu xana wat. ");
INSERT INTO nal_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Axazak ka rauxin uru alngana, xana langar ma xana zuruk. ");
INSERT INTO nal_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Gana vatfaraxazin a watkul angkari wana aze razaan? Di malasing a funalik ina di iziar la xumanar ma dit kupkup sin azanon funalik tawarak malasing kari, ");
INSERT INTO nal_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Araan maadi wif a lexu, xawit naagu riria, ma araan maadi rangon a ranganang maaluf, kawit naagu raangis.’ ");
INSERT INTO nal_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ka malasing bani wana a watkul angkari. Araan Jon ka wat, kat falvaal wana vanganang ma xawit na imimin a waain, malasing ma di piaat pana naan malasing kari, ‘A zapalaau xa ragul naan.’ ");
INSERT INTO nal_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma araan Naata Rapti xa wat, naan ka vavangan ma xa imimin a waain ma naandi di piaat pana naan malasing kari, ‘Naagu raamin, a rapti angkari, naan a balang ma a rapti xa imimin famarazaat a daanim dikdik, ma a paasaxo zin ubina iwana zuzurukang a taakis ma zin aubina di gigiu a matmalabuk taksaat.’ Singsaxai a vaamuzazang sin Nakmai xat fatangin adu a mazamang sina, naan a mazamang faaratunaan.” ");
INSERT INTO nal_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ma Iesu xa vadawaar aubina lamun bina ina naan ka ra giu amun faamuzazang ka banglala wana, wanaze xawit di inaxam taawuk. ");
INSERT INTO nal_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ka piaat naako, “Kana raksaat mase wana nim aubina in Korazin, ma aubina in Betsaaida. Tamon ga lek giu amun faamuzazang ka banglala zin aubina in Taair ma aubina in Saaidon malasing ga ra giu lamarana nim, naandi di lek inaxam taawuk faanong paamua nanga ma dina maskalus ma dina mamaaus pana mamaauzang iwana maskaluzang ma dina xawur a waata naandi wana burut iwana xaiaf kuna vatanginang adu di maskalus lalozang amun matmalabuk taksaat sin naandi. ");
INSERT INTO nal_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ga vazei nim, la raan iwana aikilizang, a maravanang Nakmai xana lis sinim kana laaup pana maravanang naana lis sin aubina in Taair ma Saaidon. ");
INSERT INTO nal_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma malasing faa wana nim aubina in Kaapernaaum, naagu naxaam adu Nakmai xana wisfaru nim la lia? Kawit. Naan kana psin fawizik nim paanaburut lamaskana adi xaiaf. Tamon amun faamuzazang ka banglala ga ra giu lamarana nim, di lek giu Sodom, taning Sodom ka lek iziar nanga. ");
INSERT INTO nal_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Singsaxai ga vazei nim, la raan aikilizang, a maravanang Nakmai xana lis sinim kana laaup pana a maravanang naana lis sin aubina in Sodom.” ");
INSERT INTO nal_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","La notaan angkanaan Iesu xa piaat naako, “Maamaa, nua a Piraana lia ma a pira angkari. Ga wisfaru nua wanaze gu ra vun amun saan angkanaan siaana aubina mazam ma ziaana naandi ina di rexaazin atavur amun saan faakdul, ma gu viaat sin aubina ina di malasing a kaana funalik mumut. ");
INSERT INTO nal_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aiang, Maamaa, avuna gu saxot nanga malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Maamaa zurugu xa ra lis amun saan faakdul zurugu. Kawit taxazak na rexaazin Naatna, Damana zingbe. Ma xawit saait taxazak na rexaazin Maamaa, Naatna zingbe varaxai wana naandi ina Naatna xa saxot kana viaat Damana zin naandi. ");
INSERT INTO nal_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nim faakdul ina naagut fazaak a maravanang ma a winpina nim ka malumbaai, naaguna wat surugu, ma gana vaiavus nim. ");
INSERT INTO nal_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Naaguna vazaak a iaapaaraas surugu ma naaguna varaviraai zurugu, avuna a matmalabuk surugu xa mainof ma nia gat famumut nia nanga. Naaguna zuruk a iaapaaraas angkari zurugu ma naaguna tangin a iaavuzang. ");
INSERT INTO nal_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Avuna a iaapaaraas surugu xa mamaraxas ma a vaamuzazang surugu xu nim kawit na lagaf.” ");
INSERT INTO nal_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lamur, aza Saabat Iesu xa zazangas lamaskana amun uma wit. Ma ubina varaviraai zina di lagaai ma di imos azanon kalamona wit ma naadi iaan. ");
INSERT INTO nal_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Araan amun Faarasi di raamin aze razaan ka balas, di piaat sina malasing kari, “Taamin! Araan ubina varaviraai zunum di giu malasing kanaan, di laxau a lus ina xa pitkol adu tuaa di vaamuzas la raan a Saabat.” ");
INSERT INTO nal_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma Iesu xa xis naandi naako, “Malasing faa, xawit nanga naagu vakot aze Dewit ka ra giu, araan naan faraxai wana ubina zina di lagaai? ");
INSERT INTO nal_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Naan ka albis la vaal zin Nakmai ma naan faraxai wana ubina zina di iaan a raraba ina amun pris di talazin aaxan Nakmai. A raraba angkanaan ka xoxok. Kawit na tak pana amun Lus sin Moses adu aubina walaau dina iaan a raraba angkanaan, amun pris singbe di iaan. ");
INSERT INTO nal_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Malasing faa, xawit nanga naagu vakot lamaskana a baar iwana amun Lus sin Moses adu amun pris dit faamuzas lamaskana vaal xoxok la raan a Saabat malasing ma di laxau a lus ina xa pitkol adu tuaa di vaamuzas la raan a Saabat? Singsaxai Nakmai xawit na vakor naandi adu di laxau a lus angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ga vazei nim, adu axazak iriat, naan ka laaup pana a vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A Baar Xoxok ka piaat malasing kari, ‘Ga sasaxot a matmalabuk iwana varamaaluvang, kawit amun talazang sinim ina dit faif.’ Tamon naagu lek texaazin aknaaza dorang kanaan, naagu lek pen fakor naandi ina xawit di laxau amun Lus sin Moses. ");
INSERT INTO nal_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Avuna Naata Rapti naan a Piraana Saabat.” ");
INSERT INTO nal_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu xa waan fataling a non angkanaan ma xa albis la vaal a maainungang sin naandi. ");
INSERT INTO nal_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma aza rapti inaan, a mitna xa maat. Ma naandi di saxot dina vakor Iesu malasing ma di iaari zina malasing kari, “Malasing faa, wana lus simaam ka tak pana dina vira aubina la raan a Saabat o xawit?” ");
INSERT INTO nal_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma naan ka xis naandi naako, “Nis sinim tamon a sipsip sina xa zu lamaskana a luk la raan a Saabat, naana wen toting ma naana raxut fawat kaarik laaxur? ");
INSERT INTO nal_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A roroiang sin a rapti xa laaup pana a sipsip. Malasing ma xa tak pana dia dina giu a matmalabuk daxa la raan a Saabat.” ");
INSERT INTO nal_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ma naan ka vazei a rapti angkanaan naako, “Fatok a mirum.” Ma naan ka vatok a mitna, ma a mitna xa daxa uli xaarik, malasing aza mitna. ");
INSERT INTO nal_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Singsaxai amun Faarasi di tukbilak la vaal a maainungang, ma di pis a dorang kuna dina zop famaat Iesu. ");
INSERT INTO nal_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu xa rexaas adu naandi di pis a dorang kuna dina zop famaat naan, malasing ma xa waan lawalaau ziaana a non angkanaan. Ma adi mala aubina di los naan ma xa vira naandi vaakdul ina di ra gias. ");
INSERT INTO nal_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma xa wisbuaak naandi tuaa dina pitfiaat naan nis. ");
INSERT INTO nal_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Naan ka piaat malasing kanaan kuna waambazovang a dorang ina Nakmai xa ra vazei a profet Aaisaaia. Naan ka ra piaat naako, ");
INSERT INTO nal_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“A iaana kilaaiang surugu xari ina ga ra kalin, axazak ina ga sasaxot, ma ga nanam pana naan. Gana sfaar a Laklagai zurugu wana naan, ma xana pitfiaat aikilizang ka tak, sin aubina vaakdul la pira angkari. ");
INSERT INTO nal_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naan kana wen faruaas ma xana wen kupkup, ma xawit taxazak kana langarin ta ling labaiang sina varawuk lamun lan. ");
INSERT INTO nal_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Naan kana wen buaak a vis ina xa ambi naan, ma xana wen pif famaat a laam ina xawit na ililap daxa. Naan kana giu malasing kanaan ka ruaas kana vabalos aikilizang ka tak, ina xana waramin amun taksaarang faakdul. ");
INSERT INTO nal_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ma aubina xawit amun Judaa zaait dina inaxam paazaai wana aizina ma dina zimbong naan.” ");
INSERT INTO nal_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Naanaan di zaxot fawat aza rapti zin Iesu ina a zapalaau xa ragul naan, ka marawif ma xa nguspo zaait. Ma Iesu xa vira naan ma naan ka raamaai ma xa dador xaarik. ");
INSERT INTO nal_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aubina vaakdul di raknar ma di iaari malasing kari, “Iaak naan a Natnaat Sin Dewit?” ");
INSERT INTO nal_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Singsaxai amun Faarasi di langarin ma di piaat malasing kari, “A rapti angkanaan kai mof pizin amun sapalaau wana dikdikang sin Belzebul, a waamua zin amun sapalaau.” ");
INSERT INTO nal_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu xa rexaazin ainaxamang sin naandi, ma xa piaat naako, “Tamon aubina lamaskana ta bikabar di varop farawuk lawalaua naandi nanga, a bikabar angkanaan kana vaanong palaau be. Tamon aubina ilaza bina o ilamaskana ta vaal di varop lawalaua naandi nanga, dina wen iziar varaxai xaarik. ");
INSERT INTO nal_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tamon Saatan ka mof pizin amun iaana kilaaiang sina, naan ka varop faraxai wana naandi zina nanga. Tamon ka malasing kanaan, a bikabar zina xana irur dikdik malasing faa? ");
INSERT INTO nal_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tamon ga mof pizin amun sapalaau wana a dikdikang sin Belzebul, aubina zinim di mof pizin amun sapalaau wana dikdikang sinis? Amun faamuzazang sin naandi nanga xana vatangin adu aikilizang sinim kawit na tak. ");
INSERT INTO nal_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Singsaxai araan ga ra mof pizin amun sapalaau wana dikdikang sin a Laklagaai a Nakmai, naagu rexaas adu a bikabar zin Nakmai xa balas faanong sinim. ");
INSERT INTO nal_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ma xawit saait nat faraxas taxazak kana albis la vaal zin ta rapti maradikdikang ma xana vazaak finau amun lulugaan sina, tamon kana wen tabung pis fating kalaak a rapti angkanaan. Naan kana tabung pis fating naan ma mur laxo xana vinaau la vaal zina. ");
INSERT INTO nal_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Axazak ina xawit nat fawaal nia, naan kai ruxol nia. Ma naan ina xawit nat firing fatuiang aubina varaxai wana nia, naan ka vutfut farauxin naandi. ");
INSERT INTO nal_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Malasing ma ga vazei nim adu Nakmai xana naxaam pizin amun matmalabuk taksaat faakdul zin aubina ma amun dorang iwana wispiaalang Nakmai, singsaxai amun dor lingpuak lawaana Laklagaai a Raabu, Nakmai xana wen naxaam pizin. ");
INSERT INTO nal_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma tamon axazak ka piaat ta dorang taksaat pana Naata Rapti, Nakmai xana naxaam pizin, singsaxai tamon axazak ka piaat ta dorang taksaat pana a Laklagaai a Raabu, Nakmai xana wen naxaam pizin a matmalabuk taksaat angkanaan sina, wana roroiang kari ma wana roroiang mur zaait.” ");
INSERT INTO nal_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ma Iesu xa piaat kaarik naako, “Tamon a iaai xa daxa, amun fnuaaina xana daxa, ma tamon a iaai xa raksaat, amun fnuaaina xana raksaat, avuna dina raamin fakilaan a iaai wana amun fnuaaina. ");
INSERT INTO nal_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nim a funalik sin amun sizi di ikarat. Naaguna piaat amun saan daxa malasing faa araan naagu bas pana matmalabuk taksaat? Avuna a nguza aubina xai pitfiaat amun matmalabuk ina xa bas pakluaai lamaskana naandi. ");
INSERT INTO nal_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A rapti daxa xat fatangin a matmalabuk daxa zina wana a daxaiang ina xa iziar lamaskana roroiang sina. Ma a rapti raksaat kat fatangin a matmalabuk taksaat sina wana a raksaatang ina xa iziar lamaskana roroiang sina. ");
INSERT INTO nal_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ga vazei nim adu amun dorang taksaat faakdul ina aubina di valai psin palau, Nakmai xana iaari zin naandi wana la raan aikilizang. ");
INSERT INTO nal_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Araan gu rur wana aikilizang, a dorang sunum nanga xana vamamaraxas nua o xana vamazik nua.” ");
INSERT INTO nal_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naanaan azanon Faarasi ma azanon maravas iwana amun Lus sin Moses di piaat sina malasing kari, “Maravas, maadi saxot guna giu ta vaamuzazang ka banglala xuna maadina raamin.” ");
INSERT INTO nal_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma Iesu xa xis naandi malasing kari, “Aubina ilamaskana watkul i taning, nim aubina raksaat. Naagu waan fataling Nakmai malasing a ravin ka waan fataling labana ma xa wa maxus sin a rapti rawarak. Naagu saxot naaguna raamin a vaakilanang, singsaxai gana wen fabalos ta vaakilanang aaxan nim. Gana vabalos be a vaakilanang sin Jonaa. ");
INSERT INTO nal_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonaa xa iziar lamaskana xuna adi ian pana a raan urul ma a suk urul, malasing saait bani Naata Rapti xana iziar a raan urul ma a suk urul lamaskana pira. ");
INSERT INTO nal_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma la raan iwana aikilizang, aubina in Niniwe dina rur ma dina vakor valagot aubina ilamaskana a watkul i taning, panaze naandi di inaxam taawuk pana fazeiang sin Jonaa, ma axazak ina xa laaup pana Jonaa, naan kari xa iziar vaanong faraxai wana nim. ");
INSERT INTO nal_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","La raan iwana aikilizang, a ravin kalxaal ina xa iziar la saaut, naan kana rur ma xana vakor valagot aubina lamaskana watkul i taning panaze naan ka wat lawalaau xuna langarinang a mazamang sin a Xalxaal Solomon, ma axazak ina xa laaup mase wana Solomon, naan kari xa iziar vaanong faraxai wana nim.” ");
INSERT INTO nal_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ma Iesu xa piaat kaarik naako, “Tamon a zapalaau xa tukbilak siaana taxazak, a zapalaau angkanaan kana waan lamun non kawit ta daanim kuna xana ziaavus, singsaxai xana wen tangin ta non siaavuzang. ");
INSERT INTO nal_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ma a zapalaau xana piaat naako, ‘Gana uli xula vaal zurugu ina ga ra waan fataling.’ Ma araan kana balas, kana raamin a vaal xana gof, dina sor vanong ma dina rasin fatalamin amun saan. ");
INSERT INTO nal_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Naanaan kana waan ma xana wa zaxot fawat uzamun sapalaau xa wizik urua ina di raksaat marazaat pana naan nanga. Ma naandi vaakdul dina albis lamaskana vaal angkanaan ma dina raagul inaan. Malasing ma a roroiang sin a rapti angkanaan kana raksaat pana a roroiang sina i waamua. Kana malasing kanaan pana aubina ilamaskana a watkul i taning, naandi aubina raksaat.” ");
INSERT INTO nal_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Araan Iesu xai dador nanga zin aubina, naanaa zina varaxai wana amun daasna di wat, ma di rur inaan lamanar, wanaze di saxot dina dador zina. ");
INSERT INTO nal_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma axazak ka vazei naan naako, “Naanaa zunum ma amun daazum di irur lamanar, di saxot dina dador zunum.” ");
INSERT INTO nal_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma Iesu xa xis naandi naako, “Nis naanaa zurugu ma nis amun daazugu?” ");
INSERT INTO nal_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iesu xa zaxatalus ubina varaviraai zina ma xa piaat naako, “Naandi xari naanaa zurugu ma amun daazugu. ");
INSERT INTO nal_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Avuna nis be xa giu lalos a sasaxotang ma ainaxamang sin Maagu la lia, naan daazugu ma fafnugu ma naanaa zurugu.” ");
INSERT INTO nal_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","La raan angkanaan nanga, Iesu xa tukbilak fataling a vaal angkanaan ma xa wa iziar la rita laman. ");
INSERT INTO nal_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma adi mala aubina di wat sina malasing ma naan ka wa xawas pana a mon ma xa ziar lamaskana, araan aubina vaakdul angkanaan di irur laxon. ");
INSERT INTO nal_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma naan ka vazei naandi wana amun dorang lalaamangaai xa varas, ma xa piaat malasing kari, “Naagu langar! Aza rapti xat faazu, xa waan ma xa wa psin garavin amun kalamona wit. ");
INSERT INTO nal_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Araan naa psin garavin, azanon kala di zu la lan, ma amun maani di lif puat ma di tok fanong mase. ");
INSERT INTO nal_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Azanon ka zu wana amun faat ina a pira xawit na varas laaxur wana. Amun paxana xa balas fazaaus avuna a pira xawit be na varas laaxur wana ");
INSERT INTO nal_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Singsaxai araan a iaas ka lang, ka laang naandi ma di plaxas, avuna amun katkadora naandi xawit na laba. ");
INSERT INTO nal_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Azanon kala di zu lawalau amun iaarus ka xoxorang. Araan amun iaarus a xoxot di bok, di wof a xalamona wit ma xawit na bok daxa. ");
INSERT INTO nal_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma azanon kala di zu wana pira daxa, ma di vuai, azanon a zangaaflu varazuai, ma azanon azangaaflu vaawizik saaxa, ma azanon azangaaflu vaarul. ");
INSERT INTO nal_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Axazak ka rauxin alngana, xa daxa xana langar ma xana zuruk.” ");
INSERT INTO nal_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ubina varaviraai zin Iesu di waan ma di iaari zina malasing kari, “Kunaze gui dador zin aubina wana dorang lalaamangaai?” ");
INSERT INTO nal_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma naan ka ra xis naandi naako, “Nakmai xa lis a rexaazang sinim ma naagu mazaam amun dorang funfun iwana a bikabar ila lia, singsaxai xawit naa lis sin aubina vaakdul angkari. ");
INSERT INTO nal_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Axazak ka rauxin a rexaazang, Nakmai xana valaup a rexaazang ina naa rauxin, kuna a rexaazang sina xana bas pakluaai. Singsaxai axazak ina xawit na rauxin ta rexaazang, Nakmai xana zuruk pizin a nan texaazang mumut angkanaan naa rauxin. ");
INSERT INTO nal_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ga dador zin naandi wana dorang lalaamangaai wanaze: Di raamaai, singsaxai xawit di raamaai vaakilan, di langar, singsaxai xawit di langarin fakilaan ma xawit di mazaam. ");
INSERT INTO nal_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A dorang sin a profet Aaisaaia xa balas faaratunaan pana naandi ina naa ra piaat naako: ‘Naagunat langar, singsaxai nanga naaguna wen mazaam, ma naaguna rataamaai, singsaxai nanga naaguna wen taamaai vaakilan. ");
INSERT INTO nal_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Avuna a waata ubina angkanaan ka dikdik, ma di baai dina langar, ma di bafkol amun marana naandi. Dina put taamaai vaakilan, ma dina langar vaakilan, ma ainaxamang sin naandi xana maravas, ma dina uli wat surugu ma gana vira naandi.’ ");
INSERT INTO nal_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Singsaxai Nakmai xa ra lis a daxaiang lamun marana nim ma amun alngana nim, panaze naagu raamin ma naagu langar. ");
INSERT INTO nal_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ga piaat faratunaan sinim, mumua amun profet ka varas faraxai wana aubina xa varas di tak, di ra sasaxot famarazaat adu dina raamin aze nim naagu rataamin, singsaxai xawit naadi ra raamin. Ma di ra sasaxot famarazaat dina langarin aze naagut langarin, singsaxai xawit naadi ra langarin.” ");
INSERT INTO nal_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Iesu xa piaat kaarik naako, “Naagu langar, naari aknaaza dorang lalaamangaai wana a rapti xat faazu. ");
INSERT INTO nal_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Araan axazak ka langarin a Dorang Daxa iwana a bikabar, ma xawit naa maravas pana, naan ka malasing a xalamona wit ina xa zu be la lan, ma a Rapti Raksaat ka wat ma xa zuruk pizin kaarik a dorang ina Nakmai xa ra vazu lamaskana roroiang sin axazak angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma a xalamona wit ina xa zu laaxur wana a pira xa rauxin amun faat ka varas, ka malasing a xazak ina xa langarin a dorang, ma fazaaus mase naa rudaxain faraxai wana nanamang. ");
INSERT INTO nal_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Singsaxai xawit na iziar vaabung baraaf, malasing a wit ina amun katkadorna xawit na laba. Ma fazaaus ka zu, araan ka tangin a maravanang ma araan aubina di vamazik naan lalozang a dorang ina naa inaxam paazaai wana. ");
INSERT INTO nal_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A xalamona wit ina xa zu lawalau amun iaarus ka xoxorang, ka malasing axazak ina xa langarin a dorang, singsaxai naan ka inaxam marazaat pana amun saan initiat la pira angkari, ma a matmalabuk iwana sasaxot famarazaatang amun lulugaan ka varas. Amun saan angkanaan ka vagit naan ma xa waramin a dorang sin Nakmai malasing a iaarus koxot ka waramin a wit, ma xawit nat fuai. ");
INSERT INTO nal_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma a xalamona wit ina xa zu la pira daxa xat faraxas be malasing axazak ina xa langarin a dorang ma naa maravas pana. Naan kana malasing a wit ina xat fuain amun fnuaai xa zangaaflu varazuai o azangaaflu vaawizik saaxa o xa zangaaflu vaarul.” ");
INSERT INTO nal_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu xa vazei xaarik naandi wana aza dorang lalaamangaai naako, “A bikabar ila lia xa malasing a rapti ina xa waan ma xa wa vazu amun kalamona wit daxa la uma zina. ");
INSERT INTO nal_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Singsaxai araan aubina vaakdul di vara milaaif, a purua zina xa wat fazu amun kalamona lauran taksaat lawalau amun kalamona wit ma xa waan. ");
INSERT INTO nal_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Araan amun kalamona wit di bok ma faasilik dina vuai, amun lauran taksaat saait di bok faraxai wana. ");
INSERT INTO nal_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ma amun iaana kilaaiang sin damana uma di waan sina ma di vazei naan malasing kari, ‘Dipiran, gu ra vazu be amun kalamona wit daxa la uma zunum. Malasing faa ma amun lauran taksaat di bok lamaskana a uma zunum?’ ");
INSERT INTO nal_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma naan ka xis naandi naako, ‘Aza purua xa giu a matmalabuk angkanaan.’ Ma amun iaana kilaaiang sina di iaari zina malasing kari, ‘Malasing faa, gu saxot maadina waan ma maadina wa uraas pizin fakdul naandi?’ ");
INSERT INTO nal_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ma naan ka wisbuaak naandi naako, ‘Tuaa, taulaan naaguna uraas pizin saait amun wit faraxai wana amun lauran taksaat. ");
INSERT INTO nal_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Naagu luaa psin kalaak dina bok faraxai xa ruaas a raan iwana laflaavang. Ma la notaan angkanaan laxo gana vazei ubina iwana laflaavang malasing kari, “Naaguna tabung uraas pizin kalaak amun lauran taksaat ma naaguna pis faraxin kuna vaivang naandi, ma lamur naaguna laaf faraxin amun wit ma naaguna sfaar la vaal a rataasmaaiang surugu.” ’ ” ");
INSERT INTO nal_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ma naan ka vazei xaarik naandi wana aza dorang lalaamangaai naako, “A bikabar ila lia xa malasing a xalamona maastat ina a rapti xa zuruk ma naa vazu la uma zina. ");
INSERT INTO nal_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A nan kala angkanaan ka mumut mase wana amun kala vaakdul dit fazu la uma, singsaxai araan ka bok puzaa, xa walak laba waamuain amun saan faakdul di vazu lamaskana uma. Ma amun maani di inu wana amun rangtangaana.” ");
INSERT INTO nal_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu xa vazei xaarik naandi wana aza dorang lalaamangaai malasing kari, “A bikabar ila lia xa malasing a is ina a ravin ka zuruk ma naa plaas faraxai wana a flaaua lamaskana a boul. Ma a flaaua vaakdul xa ring.” ");
INSERT INTO nal_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Amun dorang faakdul angkanaan Iesu xa vazei adi mala aubina wana, naan ka dador wana amun dorang lalaamangaai be. ");
INSERT INTO nal_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ka dador malasing kanaan ma a dorang sin a profet ka balas faaratunaan naako, “Nia gana dador wana dorang lalaamangaai. Gana piaat amun saan ina xa izi vunfun, la varumaraiang nanga araan Nakmai xa ra vaziaar a pira angkari.” ");
INSERT INTO nal_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Naanaan Iesu xa ramaraat fataling adi mala aubina angkanaan ma xa albis la vaal. Ma ubina varaviraai zina di wat ma di iaari zina malasing kari, “Kat faraxas guna akpaat aknaaza dorang lalaamangaai wana lauran taksaat ina xa bok la uma?” ");
INSERT INTO nal_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma xa vazei naandi malasing kari, “A rapti ina xa vazu a xalamona wit daxa, naan Naata Rapti. ");
INSERT INTO nal_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A uma angkanaan naan a pira angkari, ma amun kalamona wit daxa xanaan, aubina ilamaskana bikabar ila lia. Ma amun lauran taksaat kanaan aubina zin a Rapti Raksaat. ");
INSERT INTO nal_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma a purua ina xa ra vazu amun lauran taksaat, naan bani Saatan. Ma a raan iwana laflaavang kanaan a vaanongang iwana amun taan i taning ma ubina iwana laflaavang kanaan amun aangelo. ");
INSERT INTO nal_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Amun lauran taksaat ina di uraas pizin ma di rasin turin ma di vaif lamaskana xaiaf, kana malasing saait bani la vaanongang iwana amun taan i taning. ");
INSERT INTO nal_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Naata Rapti xana kling amun aangelo zina, ma dina uraas pizin amun saan faakdul la bikabar zina ina xat faxalxaal aubina xuna giuang amun matmalabuk taksaat faraxai zaait pana aubina vaakdul ina di gigiu amun matmalabuk taksaat. ");
INSERT INTO nal_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma dina psin naandi lamaskana adi xaiaf, inaan dina rataangis ma dinat karaat alvana naandi. ");
INSERT INTO nal_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aubina di tak dinat pilwilak malasing a iaas la bikabar zin Damana naandi. Axazak ka rauxin alngana, xa daxa xana langarin a dorang kari.” ");
INSERT INTO nal_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ma Iesu xa piaat kaarik naako, “A bikabar ila lia xa malasing azaan daxa mase ina di vun laza uma. Araan aza rapti xa tangin, naa vun kaarik. Ma xa waan faraxai wana dokdokang ma xa vaangurin amun lulugaan faakdul zina xuna aubina dina wul, ma wana a kaakaai iwana naa wulang a uma angkanaan.” ");
INSERT INTO nal_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ma Iesu xa piaat kaarik naako, “A bikabar ila lia xa malasing saait a rapti vaangurang ka zazaleng amun katura zaang. ");
INSERT INTO nal_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Araan ka tangin a xatura zaang ina a maraana xa laaup marazaat, ka waan ma xa vaangurin amun lulugaan faakdul zina ma wana a kaakaai iwana naa wulang a xatura zaang angkanaan.” ");
INSERT INTO nal_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ma Iesu xa piaat kaarik naako, “A bikabar ila lia xa malasing saait aubina ina dit faaian pana, di psin nana raas ma atavura ian faakdul di laxar lamaskana. ");
INSERT INTO nal_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Araan aubina xa bas, di urif fawat laxon. Ma di ziar ma di zuruk pilaai amun ian daxa ma di rasin lamaskana amun laxa. Singsaxai amun ian taksaat, naadi psin. ");
INSERT INTO nal_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kana malasing saait bani la vaanongang iwana amun taan i taning. Amun aangelo dina wat ma dina zuruk pizin aubina raksaat siaana aubina di tak. ");
INSERT INTO nal_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma dina psin aubina raksaat lamaskana adi xaiaf. Ma inaan naandi dina rataangis ma dinat karaat alvana naandi.” ");
INSERT INTO nal_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ma Iesu xa iaari zin ubina varaviraai zina naako, “Malasing faa, naagu maravas pana aknaaza amun dorang faakdul ga ra vazei nim pana?” Ma di xis naan malasing kari, “Aiang.” ");
INSERT INTO nal_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma naan ka vazei naandi naako, “Amun maravas faakdul iwana amun Lus sin Moses ina di ra zuruk a rexaazang pana a bikabar ila lia, di malasing damana aza vaal ina xa zuruk fatukbilok amun saan daxa la vaal a ratasmaaiang sina, azanon ka vaaxur ma azanon ka xabaar zaait.” ");
INSERT INTO nal_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Araan Iesu xa ra piaat fanong amun dorang lalaamangaai angkanaan, ka ramaraat fataling a bina angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma xa uli xula bina zina vaatak. Naan ka viraai aubina inaan la vaal a maainungang sin naandi, ma di banglala mase ma di iaari malasing kari, “A rapti angkari xa zuruk a rexaazang laba vaa? Ma xa zuruk a dikdikang kuna giuang amun faamuzazang ka banglala vaa? ");
INSERT INTO nal_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dia di rexaas be adu damana naan a rapti xat gigiu vaal, ma naanaa zina xanaan Maaria, ma amun daasna xanaan Jems, ma Iosep, ma Saaimon, ma Judaas. ");
INSERT INTO nal_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma amun fafina xari varaxai wana dia. Naan ka zuruk amun saan faakdul angkanaan faa?” ");
INSERT INTO nal_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Malasing ma naandi di maska raksaat pana naan. Singsaxai Iesu xa piaat sin naandi naako, “A profet dit faranop pana naan lamun bina rawarak, singsaxai la bina zina vaatak ma lamaskana a vaal zina vaatak, kawit dit faranop pana naan.” ");
INSERT INTO nal_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma xawit na giu amun faamuzazang ka banglala xa varas inaan, panaze xawit di inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","La raan angkanaan, Erot a waamua zin a gaapman in Gaalili xa langarin amun saan Iesu xa giu. ");
INSERT INTO nal_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ma xa vazei ubina vaamuzazang sina naako, “A rapti angkanaan, naan bani Jon A Rapti Iwana Baaptaaizang, ka ramaraat puli ziaana maatang. Malasing ma naan ka rauxin a dikdikang kuna giuang amun faamuzazang ka banglala.” ");
INSERT INTO nal_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Azanon flan paamua Jon A Rapti Iwana Baaptaaizang ka vazei Erot naako, “Kawit na tak pana nua guna maxus sin Erodiaas, taak sin daazum, Filip.” Malasing ma Erot ka vazei ubina dauran sina ma di zaraak naan. Di pis fating naan ma di rasin naan la vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ma Erot ka saxot kana zop famaat Jon singsaxai xa marauring aubina, wanaze di naxaam adu Jon naan a profet. ");
INSERT INTO nal_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","La raan iwana naxaamang araan naanaa xa ra luk Erot, nativa Erodiaas ka riria lawalau amun topuran sin Erot. Ma Erot ka dokdok mase wana a fnaalik angkanaan, ");
INSERT INTO nal_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ma xa xalxal wana a waata fafina adu aze razaan a fnaalik ka maainung naan pana, naana lis. ");
INSERT INTO nal_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A fnaalik angkanaan ka vazei Erot naako, “Gu rasin a waata Jon A Rapti Iwana Baaptaaizang pana a win laba ma gu lis surugu.” Naan ka piaat malasing kanaan panaze naanaa zina xa ra vazei naan adu xana vazei Erot malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A xalxaal xa langarin a maainungang sin a fnaalik angkanaan ma xa maskalus. Singsaxai naan ka ra xalxal zin a fnaalik angkanaan, lamarana amun topuran sina ina di izi vavangan faraxai wana naan, malasing ma naan ka valos a maainungang sin a fnaalik. ");
INSERT INTO nal_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma naan ka kling ubina dauran ma di kip pizin a waata Jon inaan la vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Di rasin a waatna wana a win laba ma di lis sin a fnaalik angkanaan ma naa zuruk lis sin naanaa zina. ");
INSERT INTO nal_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ubina varaviraai zin Jon di wat ma di vazaak pizin naan ma di wa xavin naan. Ma di waan ma di vazei Iesu. ");
INSERT INTO nal_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Araan Iesu xa langarin adu Jon ka maat faanong, ka xawas pana mon ma xa waan laza non ka iziar naan singit kuna naan singbe xana wa iziar inaan. Ma aubina di langarin malasing kanaan, ma di ramaraat lamun bina zin naandi ma di zangas lalos a lan ma di los naan. ");
INSERT INTO nal_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Araan naan ka xozaraai, xa raamin adi xulutung aubina, ma xa maskalus saxot naandi, ma xa vira aubina di gias. ");
INSERT INTO nal_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka nguzaraaf ka, ma ubina varaviraai zina di wat sina ma di vazei naan malasing kari, “A non angkari xa bingil, ma araan ka valaau. Guna kling pizin kabe axulutung aubina angkari, ma naandi dina waan lamun bina ma dina wa wulwul vanganang ku naandi nanga.” ");
INSERT INTO nal_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma Iesu xa xis naandi naako, “Kawit ta vuvuna ma naandi dina waan. Naagu ralaas naandi wana vanganang.” ");
INSERT INTO nal_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma di vazei naan malasing kari, “Maadi rauxin be a raraba xa watmit ma a ian urua.” ");
INSERT INTO nal_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma Iesu xa vazei naandi naako, “Naagu zuruk fawat amun raraba ma amun ian iriat surugu.” ");
INSERT INTO nal_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Naanaan naan ka vazei axulutung aubina angkanaan ma di iziar waanaburut pana wilaangis. Ma naan ka zuruk a raraba xa watmit ma a ian urua, ma xa raamaai uzaa laaxur la lia, ma xa wisfaadaxa wana zin Nakmai. Naa biaak ma naa lis sin ubina varaviraai zina ma di ralaas aubina wana. ");
INSERT INTO nal_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aubina vaakdul di vangan ma di maazur. Ma ubina varaviraai zina di sfaar vambos amun laxa xa zangaaflu ma urua wana amun kibaal a vanganang ina naadi ra maazur vataling. ");
INSERT INTO nal_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma a vaakatang pana ubina ina di ra vangan ka malasing a taausan ka watmit, singsaxai xawit di vakot a furavin ma a funalik. ");
INSERT INTO nal_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Fazaaus mase Iesu xa kling paamuain ubina varaviraai zina xuna dina albis lamaskana a mon ma dina kas buak kulaza rita laman. Ma naan kana iziar uli xuna xana kling pizin aubina angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Araan ka kling pizin fanong aubina, naan singbe xa waan ikula la waatawut kuna xana wa maainung. A bina xat faakilan tapti xa languzaraaf, ma naan singbe xa iziar inaan. ");
INSERT INTO nal_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma araan a mon ka iziar labirua wana laman, ka uzaa laaxur ma xa wizik paanaburut pana rof, panaze a maaliu xa taaif puat fatok naandi. ");
INSERT INTO nal_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lawalau a marana iaas urul ma xa wizik saaxa paanaraan gufguf mase, Iesu xa zangas paan sin naandi laaxur wana laman. ");
INSERT INTO nal_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Araan ubina varaviraai zina di raamin naan ka zazangas laaxur wana laman, di maraaut mase ma di viraai malasing kari, “A warak ka wat!” ");
INSERT INTO nal_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Fazaaus mase Iesu xa vazei naandi naako, “Naagu dikdik. Nia be. Tuaa naagu maraaut!” ");
INSERT INTO nal_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma Pita xa xis naan naako, “Piran, tamon nua be, vazei nia gana zangas puat sunum laaxur wana daanim.” ");
INSERT INTO nal_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma Iesu xa piaat sina naako, “Laawus!” Pita xa ramaraat fataling a mon, ma xa varumara zangazang paan sin Iesu laaxur wana daanim. ");
INSERT INTO nal_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Singsaxai araan ka raamin adi maaliu, xa maraaut mase ma xa varumara wizikang lamaskana laman, ma xa viraai naako, “Piran, saxot faulin nia!” ");
INSERT INTO nal_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Fazaaus mase Iesu xa vatok a mitna ma xa roting naan ma xa urif fauzaa naan laaxur ma xa piaat naako, “Ainaxam paazaaiang sunum ka xalxaalif. Kunaze gu rauxin ainaxamang urua?” ");
INSERT INTO nal_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Araan nandiaa varaxai di albis iaa lamaskana a mon, a maaliu xa maat. ");
INSERT INTO nal_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ma ubina varaviraai ina di iziar lamaskana a mon di lotu wana naan ma di piaat malasing kari, “Faaratunaan mase, nua Naata Nakmai!” ");
INSERT INTO nal_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Araan di kas buak faanong, di xozaraai la non Genesaret. ");
INSERT INTO nal_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma araan aubina ininaan di raamin fakilaan Iesu, di lis a dorang ka waan lamun bina vaasilik faakdul ma di zaxot fawat aubina vaakdul ina di gias, sina. ");
INSERT INTO nal_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma di maainung fadikdik Iesu xuna aubina di gias dina xaaf be a zuva marapi baraaf sina, ma naandi vaakdul ina di ra xaaf naan, di roro daxa xaarik. ");
INSERT INTO nal_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ma azanon Faarasi varaxai wana azanon maravas iwana amun Lus sin Moses inikula Jerusalem, di wat sin Iesu ma di iaari zina malasing kari, ");
INSERT INTO nal_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kunaze ubina varaviraai zunum kawit dit falos amun faraviraaiang sin amun maravas sin amun kulmua zin dia? Kawit dit suksuk mit paamua wana di vavangan.” ");
INSERT INTO nal_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma naan ka xis naandi naako, “Ma xunaze naagut laxau amun lus sin Nakmai ma naagut falos amun faraviraaiang sin amun maravas sin amun kulmua zinim? ");
INSERT INTO nal_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Avuna Nakmai xa piaat malasing kari, ‘Naagu varanop pana maamaa ma naanaa zinim,’ ma xa piaat saait naako, ‘Tamon axazak ka lingpuak lawaana maamaa zina ma naanaa zina, dina zop famaat naan.’ ");
INSERT INTO nal_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Singsaxai naagui piaat adu xa daxa wana axazak kana piaat sin maamaa ma naanaa zina malasing kari, ‘Azaan ina ga lek fawaal numaa wana, ga rasin parok fanong, gana lis sin Nakmai.’ ");
INSERT INTO nal_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Naagui piaat malasing kanaan ma axazak angkanaan kawit ka na varanop pana damana o naanaa zina. Araan naagu giu malasing kanaan, naagu wengin pizin a dorang sin Nakmai xuna naaguna valos be a varaviraaiang sin amun maravas sin amun kulmua zinim. ");
INSERT INTO nal_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nim aubina xawit naagut falos a dorang sinim. A profet Aaisaaia xa piaat faratunaan pana nim araan ka dador waamua naako, ");
INSERT INTO nal_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Aubina angkari dit faranop pana nia wana nguza naandi, singsaxai a maskana naandi xa iziar lawalaau wana nia. ");
INSERT INTO nal_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dit lotu walaau be wana nia, wanaze dit firaai aubina wana amun lus sin aubina be.’ ” ");
INSERT INTO nal_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu xa viring fawat adi mala aubina zina ma xa vazei naandi naako, “Naaguna langar ma naaguna mazaam a dorang surugu. ");
INSERT INTO nal_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A vanganang ka albis la balana axazak, kawit na vamitikaai naan lamarana Nakmai. Kawit. Singsaxai azaan ka tukbilak la balana axazak, naan azaan angkanaan ka vamitikaai naan.” ");
INSERT INTO nal_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ma ubina varaviraai di wat sina ma di iaari malasing kari, “Malasing faa, gu rexaas saait adu amun Faarasi di langarin a dorang sunum ma di maska maazik pana nua?” ");
INSERT INTO nal_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma naan ka vazei naandi naako, “Amun iaai vaakdul ina Maagu la lia xawit na vazu, naana put pizin naandi wana xatkadora naandi. ");
INSERT INTO nal_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Naagu raamin pizin naandi, di malasing a marawif kat paamuain aubina. Tamon ta marawif ka waamuain aza marawif, nandiaa varaxai dina zu iaa lamaskana luk.” ");
INSERT INTO nal_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma Pita xa vazei naan naako, “Guna vamaravaas aknaaza dorang lalaamangaai angkanaan simaam.” ");
INSERT INTO nal_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ma Iesu xa iaari zina naako, “Aze, ainaxamang sinim kawit nanga na maravas? ");
INSERT INTO nal_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Malasing faa, xawit naagu rexaas adu amun fanganang faakdul ina xa albis la balana axazak, ka wizik faatak la xuna ma naa wizin pizin? ");
INSERT INTO nal_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Singsaxai a dorang ina xa tukbilak la balana, xa wat lamaskana ainaxamang sina, ma xa vamitikaai naan lamarana Nakmai. ");
INSERT INTO nal_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Avuna atavur amun matmalabuk taksaat faakdul xai tukbilak lamaskana ainaxamang sin axazak malasing kari: ainaxamang taksaat, ma a matmalabuk iwana zop famaatang aubina, ma a matmalabuk iwana milivinang a ravin o a rapti rawarak, ma amun matmalabuk taksaat lamanar wana aizit maxuzang, ma a matmalabuk iwana vinaauang, ma a matmalabuk iwana vaagitang pana axazak, ma a matmalabuk iwana wispiaalang azanon. ");
INSERT INTO nal_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Atavura matmalabuk angkanaan, kat famitikaai aubina lamarana Nakmai, singsaxai tamon axazak ka vangan ma xawit na zukmit, a matmalabuk angkanaan kana wen famitikaai naan.” ");
INSERT INTO nal_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu xa ramaraat inaan ma xa wa balas la non pira in Taair ma Saaidon. ");
INSERT INTO nal_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma aza ravin Kenaan, naan ila non angkanaan, ka wat ma xa viraai waan sin Iesu malasing kari, “Piran! A Natnaat Sin Dewit, maluf nia! A zapalaau xa ragul nativugu ma xa vamazik mase naan.” ");
INSERT INTO nal_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Singsaxai Iesu xawit na xis naan. Ma ubina varaviraai zina di wat sina ma di vazei naan malasing kari, “Kling pizin naan, panaze xa viraai vaamosmos lamuraana dia.” ");
INSERT INTO nal_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma Iesu xa xis naandi naako, “Nakmai xa ra kling fawat be nia iriat kuna vawaalang amun sipsip faakdul in Israael, di ra milung.” ");
INSERT INTO nal_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Singsaxai a ravin angkanaan ka wat sin Iesu ma xa zibukaak lamarana, ma xa piaat naako, “Piran, fawaal nia!” ");
INSERT INTO nal_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma Iesu xa xis naan naako, “Kawit na tak pana dina zuruk a vanganang sin a funalik ma dina psin lis sin amun piu.” ");
INSERT INTO nal_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma a ravin angkanaan ka piaat naako, “Piran, ka vaaratunaan, singsaxai amun piu zaait di iaan a sina vanganang sin amun mono zin naandi ina xa zuzu wizik lawaana iban favanganang.” ");
INSERT INTO nal_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ma Iesu xa xis naan malasing kari, “Diravin, ainaxam paazaaiang sunum ka laaup. Gana giu vatfaraxazin a maainungang sunum.” Ma la notaan angkanaan mase a fnaalik sina xa roro daxa. ");
INSERT INTO nal_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu xa ramaraat inaan ma xa zangas lapaara rita laman Gaalili ma xa laak a wut ma xa wa iziar inaan. ");
INSERT INTO nal_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma amun kulutung aubina di wat sina. Di zaxot fawat amun kaak taksaat, ma dit findaan fawat amun marawif, ma naandi amun mita naandi xa xolxoli, ma amun nguspo, ma aubina xa varas pana atavura giazang tawarak, ma di vaziaar naandi lamarana, ma xa vira naandi. ");
INSERT INTO nal_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Adi mala angkanaan, di raknar mase araan di raamin amun nguspo di dador, ma naandi amun mita naandi xa xolxoli xa balas daxa, ma amun kaak taksaat di zangas, ma amun marawif di raamaai. Ma di wisfaru Nakmai zin amun Israael. ");
INSERT INTO nal_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu xa viring fawat ubina varaviraai zina ma xa vazei naandi malasing kari, “Ga rauxin a varamaaluvang pana aubina angkari, wanaze di ra iziar varaxai wana nia wana a raan urul ma xawit na rauxin ta vanganang aaxan naandi xuna naadina iaan. Ga baai gana kling pizin palau naandi varaxai wana lagaaiang, taulaan dina zumaat pana lagaaiang la lan.” ");
INSERT INTO nal_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ubina varaviraai di vazei naan malasing kari, “A non angkari xa iziar naansing it, maadina zuruk a vanganang faa xuna vavangaanang awat kulutung angkari?” ");
INSERT INTO nal_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Iesu xa iaari zin naandi naako, “Usfa raraba naagu rauxin?” Ma di xis naan malasing kari, “A raraba xa wizik urua ma a kaana ian mumut.” ");
INSERT INTO nal_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ma xa vazei aubina xuna dina iziar wizik paanaburut la pira. ");
INSERT INTO nal_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Naan ka zuruk a raraba angkanaan ka wizik urua ma a kaana ian angkanaan ma xa wisfaadaxa wana xa waan sin Nakmai. Naa biaak ma naa lis sin ubina varaviraai zina ma di talazin sin aubina. ");
INSERT INTO nal_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Naandi vaakdul di vangan ma di maazur. Ma lamuraana, ubina varaviraai zina di sfaar amun laxa xa wizik urua wana amun kibaala vanganang ina naadi maazur vataling. ");
INSERT INTO nal_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ma a vaakatang pana ubina ina di ra vangan, kat faraxas pana a taausan urulavaat, singsaxai xawit di vakot a furavin ma a funalik. ");
INSERT INTO nal_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lamuraana Iesu xa kling farauxin pizin fanong adi mala aubina angkanaan, ka xawaas a mon ma xa waan la non in Maagadaan. ");
INSERT INTO nal_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amun Faarasi varaxai wana amun Saadusi di wat sin Iesu ma di saxot adu dina vaxabebeu naan. Malasing ma di iaari zina xana giu ta vaamuzazang ka banglala lamarana naandi malasing a vaakilanang kuna vatanginang adu Nakmai xa kalin naan. ");
INSERT INTO nal_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma Iesu xa xis naandi naako, “Araan a iaas ka si, naagu piaat malasing kari, ‘Kana raan daxa, wanaze ambara xa memek.’ ");
INSERT INTO nal_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma paanaraan naagu piaat malasing kari, ‘Kana daavur, wanaze a bina xa bubung ma a iaas ka memek.’ Naagu raamin fakilaan amun faakilanang la ambara ma naagu rexaazin a raan kana malasing faa. Singsaxai xawit nat faraxas naaguna raamin fakilaan amun faakilanang ilamun taan angkari. ");
INSERT INTO nal_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nim a watkul angkari taning, nim aubina raksaat, naagu waan fataling Nakmai malasing a ravin ka waan fataling labana ma xa zaxot aza rapti rawarak. Naagu iaari wana ta vaakilanang, singsaxai a vaakilanang be gana vatangin sinim, naan a vaamuzazang ka banglala ina xa balas pana Jonaa.” Ma Iesu xa vataling naandi ma xa waan. ");
INSERT INTO nal_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Araan Iesu varaxai wana ubina varaviraai zina di kas buaak a laman, ubina varaviraai di naxambain dina zuruk tazanon raraba. ");
INSERT INTO nal_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma Iesu xa vazei naandi malasing kari, “Naagu naknakaai, naagu xatkatong fatalamin nim siaana a is sin amun Faarasi ma amun Saadusi.” ");
INSERT INTO nal_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma ubina varaviraai di xulus a dorang kanaan lawalaua naandi nanga ma di piaat malasing kari, “Naan ka piaat malasing kanaan panaze dia xawit di zuruk ta raraba.” ");
INSERT INTO nal_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Singsaxai Iesu xa rexaas faanong pana aze razaan naadi xulus, malasing ma xa piaat naako, “Ainaxam paazaaiang sinim ka xalxaalif. Kunaze naagui dador lawalaua nim nanga adu xawit naagu zuruk ta raraba? ");
INSERT INTO nal_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Malasing faa, xawit nanga naagu mazaam? Iaak naagu naxambain fanong a raraba xa watmit ina ubina xa taausan ka watmit di ra iaan. Ma usfa laxa naagu sfaar vambos pana amun kibaala vanganang? ");
INSERT INTO nal_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma iaak naagu naxambain fanong a raraba xa wizik urua ina ubina xa taausan urulavaat di ra iaan. Ma usfa laxa naagu sfaar vambos pana amun kibaala vanganang? ");
INSERT INTO nal_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kunaze xawit naagu maravas? Nia xawit ga dador zinim pana raraba. Singsaxai naaguna naknakaai wana a is sin amun Faarasi ma amun Saadusi.” ");
INSERT INTO nal_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ma naanaan di maravas laxo adu naan kawit na piaat adu dina naknakaai wana a is lamaskana raraba, xawit. Singsaxai naan ka ra vazei naandi adu dina naknakaai wana amun faraviraaiang sin amun Faarasi ma amun Saadusi. ");
INSERT INTO nal_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Araan Iesu xa balas la pira in Sesaria Filipaai, xa iaari zin ubina varaviraai zina naako, “Aubina di piaat adu Naata Rapti nis?” ");
INSERT INTO nal_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ma di xis naan malasing kari, “Azanon di piaat naan Jon A Rapti Iwana Baaptaaizang, ma azanon di piaat naan Elaaija, ma azanon nanga di piaat naan Jeremaaia, o naan azaxai zin amun profet.” ");
INSERT INTO nal_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ma Iesu xa iaari zin naandi naako, “Ma malasing faa wana nim? Naagu piaat adu nia nis?” ");
INSERT INTO nal_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma Saaimon Pita xa xis naan malasing kari, “Nua a Mesaaia, Naata Nakmai xa roro.” ");
INSERT INTO nal_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma Iesu xa xis naan naako, “Saaimon, naata Jonaa, Nakmai xa ra lis a daxaiang sunum, panaze xawit ta rapti ila pira angkari xa viaat a dorang kanaan sunum. Maagu la lia xa viaat sunum. ");
INSERT INTO nal_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma ga vazei nua adu nua Pita. Ma wana a vaat siar angkanaan, gana varur a lotu zurugu. Ma a dikdikang iwana maatang kawit nat faraxas kana waramin a lotu angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gana lis amun ki ila bikabar ila lia zunum: Aze razaan gu pis tasin iriat la pira angkari, Nakmai xana pis tasin ikula la lia, ma aze razaan gu akpaat iriat la pira angkari, Nakmai xana akpaat ikula la lia.” ");
INSERT INTO nal_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma xa dador dikdik sin ubina varaviraai zina adu tuaa di vazei taxazak adu naan a Mesaaia. ");
INSERT INTO nal_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","La notaan angkanaan ma xa uzaa, Iesu xa varumara vazeiang ubina varaviraai zina adu naan kana waan Jerusalem kuna xana vazaak a vaamaazikang ka varas la mit amun paamua zin amun Judaa ma amun pris laba ma amun maravas iwana amun Lus sin Moses. Ma naandi dina zop famaat naan ma la varulang a raan, kana ramaraat puli xaarik siaana maatang. ");
INSERT INTO nal_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita xa zaxot parok Iesu ma xa vadawaar naan naako, “Piran, kawit mase! Tuaa gu piaat malasing kanaan. Amun saan angkanaan kana wen balas sunum.” ");
INSERT INTO nal_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma Iesu xa plaas a marana xa waan sin Pita ma xa vazei naan naako, “Saatan! Paan siaagu. Gu malasing a vaat kuna tuxinang nia, wanaze amun inaxamang kanaan sunum kawit gu zuruk sin Nakmai. Gu valos be amun inaxamang sin aubina.” ");
INSERT INTO nal_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ma Iesu xa vazei ubina varaviraai zina naako, “Tamon axazak ka saxot kana los nia, xana vazaak a robuxul zina ma xana los nia. ");
INSERT INTO nal_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Avuna nis ka saxot kana roting falagot a roroiang sina, a roroiang kanaan sina xana milung siaana, singsaxai nis ka lis pizin a roroiang sina saxotang aizinugu, naan kana tangin a roro tapal. ");
INSERT INTO nal_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tamon axazak ka rauxin amun saan faakdul ila pira angkari singsaxai a roroiang sina xa milung ma xa waan la bina iwana adi xaiaf kawit nai maat, amun saan angkanaan kana vabalos a daxaiang aaxana malasing faa? Ma aze razaan naana lis kuna wul xulang a roroiang sina? ");
INSERT INTO nal_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Avuna Naata Rapti xana uli wat lamaskana marmari daxaiang sin Damana ma varaxai wana amun aangelo zina. Ma la notaan angkanaan, naan kana lis a wulwulang sin axazak saksaxai lalozang aze razaan naa ra giu. ");
INSERT INTO nal_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ga piaat faratunaan sinim, azanon angbari di irur iriat taning, dina wen maat nanga ma dina raamin Naata Rapti xana wat faraxai wana a bikabar zina.” ");
INSERT INTO nal_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A raan ka wizik saaxa lamur, Iesu xa zaxot Pita, ma uru vandaas Jems ma Jon, ma naandi urulavaat di laak fauzaa adi waatawut, naandi zingbe. ");
INSERT INTO nal_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma inaan lamarana nandiaal, di raamin taal a winpina Iesu xa xulxulaai. A marana xa wilwilak malasing a marana iaas ma amun marapi zina zaait di xufkuf marazaat ma di wilwilak. ");
INSERT INTO nal_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Fazaaus mase ubina varaviraai angkanaan urul, di raamin taal Moses ma Elaaija di balas iaa, ma di dador iaa varaxai wana Iesu. ");
INSERT INTO nal_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma Pita xa vazei Iesu naako, “Piran, ka daxa wana dia di iziar iriat. Tamon gu saxot gana giu a vaal maling urul, azaxai aaxanum, ma azaxai aaxan Moses ma azaxai aaxan Elaaija.” ");
INSERT INTO nal_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Araan kai dador nanga, a vang bara xa wilwilak marazaat ka vakuf kol naandi ma a linga xazak inaan lamaskana bara xa dador malasing kari, “Naan kari Naarugu, ina ga sasaxot ma ga nanam mase wana naan. Naagu langar zina.” ");
INSERT INTO nal_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Araan ubina varaviraai angkanaan urul di langarin taal, di maraaut taal mase ma di zu wizik taal wana marana nandiaal waanaburut la pira. ");
INSERT INTO nal_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Singsaxai Iesu xa wat ma xa xaaf nandiaal ma naako, “Naagu ramaraat taal. Tuaa naagu maraaut.” ");
INSERT INTO nal_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Araan di raamaai uzaa laaxur, di raamin taal Iesu zingbe. ");
INSERT INTO nal_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma araan naandi urulavaat di kabal wizik la waatawut, Iesu xa dador vaalagat sin nandiaal naako, “Tuaa naagu vazei raal taxazak pana aze razaan naagu ra raamin taal, xa ruaas a raan Naata Rapti xana ramaraat puli ziaana maatang.” ");
INSERT INTO nal_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ubina varaviraai angkanaan urul, di iaari raal zina malasing kari, “Kunaze amun maravas iwana amun Lus sin Moses di piaat adu Elaaija xana tabung balas paamua wana a Mesaaia?” ");
INSERT INTO nal_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ma Iesu xa xis nandiaal naako, “Ka vaaratunaan mase adu Elaaija xana tabung balas kuna xana giu vatalamin faulin kaarik amun saan faakdul. ");
INSERT INTO nal_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Singsaxai ga vazei numtaal, Elaaija xa balas faanong, singsaxai xawit di raamin fakilaan naan, ma di giu a matmalabuk taksaat pana naan lalozang ainaxamang sin naandi nanga. Kana malasing saait kanaan pana Naata Rapti. Naan kana vazaak a maazikang la mita naandi.” ");
INSERT INTO nal_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ma ubina varaviraai angkanaan urul di rexaas ka adu naan kat fazei be nandiaal wana Jon A Rapti Iwana Baaptaaizang. ");
INSERT INTO nal_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Araan naandi urulavaat di wat balas sin axulutung aubina, aza rapti xa wat sin Iesu ma xa zibukaak lamarana, ");
INSERT INTO nal_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ma xa vazei naan naako, “Piran, gu maluf naarugu. Kat gaga ma xat kazanin adi maazikang laba. Amun taan ka varas, naan ka zuzu lamaskana axaiaf ma amun taan ka varas ka zuzu lamaskana daanim. ");
INSERT INTO nal_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ga ra zaxot naan ka waan sin ubina varaviraai zunum, singsaxai xawit nat faraxas dina vira naan.” ");
INSERT INTO nal_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma Iesu xa vazei naan malasing kari, “Nim ilamaskana watkul angkari, xawit naagu inaxam paazaai ma ainaxamang ma matmalabuk sinim kawit na tak. Usfa raan gana iziar nanga varaxai wana nim? Usfa raan nanga gana vamalmalin ainaxam paazaaiang sinim ka xalxaalif? Saxot fawat naarum iriat surugu.” ");
INSERT INTO nal_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma Iesu xa vadawaar a zapalaau angkanaan ma xa waan fataling a nalik ma la notaan angkanaan mase, a nalik ka balas daxa. ");
INSERT INTO nal_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Naanaan ubina varaviraai di wat sin Iesu ma di iaari vunfun sina malasing kari, “Kunaze xawit nat faraxas maam maadina mof pizin a zapalaau ziaana?” ");
INSERT INTO nal_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma Iesu xa xis naandi naako, “Panaze ainaxam paazaaiang sinim ka xalxaalif marazaat. Ga piaat faratunaan sinim, tamon ainaxam paazaaiang sinim ka mumut malasing a xalamona maastat, kat faraxas naaguna vazei a waatawut angkari malasing kari, ‘Gu ramaraat iriat kunipaa,’ ma faaratunaan mase xana ramaraat. Kawit tazaan kana lagaf pana nim.” ");
INSERT INTO nal_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Araan Iesu varaxai wana ubina varaviraai zina di wat balas fatu la pira Gaalili, naan ka vazei naandi naako, “Dina ngutlis Naata Rapti la mit amun purua. ");
INSERT INTO nal_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Dina zop famaat naan ma wana varulang a raan, naan kana ramaraat puli.” Ma ubina varaviraai zina di maskalus mase. ");
INSERT INTO nal_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu varaxai wana ubina varaviraai zina di balas Kaapernaaum. Ma ubina iwana zuzurukang a taakis ila vaal xoxok di wat sin Pita ma di iaari zina malasing kari, “Malasing faa, a maravas sunum ka wulwul zaait a taakis la vaal xoxok o xawit?” ");
INSERT INTO nal_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma Pita xa xis naandi naako, “Aiang, naa wulwul.” Araan Pita xa albis la vaal, xawit nanga na dador ma Iesu xa tabung iaari zina naako, “Saaimon, gu naxaam malasing faa? Amun kalxaal ila pira angkari di zuzuruk a wulwulang iwana amun taakis faakdul zinis? Sin aubina zin naandi vaatak o zin azanon tawarak?” ");
INSERT INTO nal_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ma Saaimon ka xis naan naako, “Zin aubina rawarak.” Ma Iesu xa vazei naan naako, “Tamon malasing kanaan, aubina zin naandi vaatak tuaa di wul a taakis. ");
INSERT INTO nal_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Singsaxai taulaan dina mangaring diaa, guna waan la laman ma guna ngangaul. Ma a ian guna tabung kos, guna kaas a balana ma guna raamin a kaakaai xat faraxas pana a taakis sin diaa. Guna zuruk ma guna lis sin naandi xuna wulang a taakis sin diaa.” ");
INSERT INTO nal_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","La raan angkanaan, ubina varaviraai di wat sin Iesu ma di iaari zina malasing kari, “Nis mase xa laaup la bikabar ila lia?” ");
INSERT INTO nal_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu xa viring fawat aza nan nalik ma naa varur lawalaua naandi. ");
INSERT INTO nal_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma xa piaat naako, “Ga piaat faratunaan sinim, tamon kawit naagu xul ainaxamang sinim ma naagu inaxam malasing a kaana funalik mumut, kawit nat faraxas naaguna albis la bikabar ila lia. ");
INSERT INTO nal_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Malasing ma tamon axazak be xat famumut naan nanga ma xa malasing a nan nalik angkari, naan kana laaup mase la bikabar ila lia. ");
INSERT INTO nal_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma tamon axazak ka ruzuaai a nan nalik mumut malasing kari lapaarugu wana aizinugu, naan ka ruzuaai nia.” ");
INSERT INTO nal_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma Iesu xa piaat kaarik naako, “Singsaxai tamon axazak ka vaxalxaal azaxai zin a kaana funalik angkari ina di inaxam paazaai wana nia, ma xa zu lamaskana matmalabuk taksaat. A matmalabuk taksaat angkanaan ka raksaat mase wana tamon di pis adi vaat la vuruna ma di vaxanak naan la laman gafeu. ");
INSERT INTO nal_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kana raksaat mase zin aubina ila pira angkari, lalozang amun saan ina xat faxalxaal aubina ma di zu lamaskana matmalabuk taksaat. Amun saan angkanaan kana balas faaratunaan, singsaxai xana raksaat mase nanga wana axazak ina xat fabalos naandi. ");
INSERT INTO nal_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tamon a mirum azaxai o a xaakum azaxai xa vaxalxaal nua ma gu zu lamaskana matmalabuk taksaat, ka daxa tamon gu kip pizin. Ka daxa tamon guna albis la non iwana roro tapal varaxai wana a mitfu o a xaakfu, taulaan dina psin nua varaxai wana uru mirum ma uru xaakum lamaskana adi xaiaf ina xawit nai maat. ");
INSERT INTO nal_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tamon azaxai zin uru maraam ka vaxalxaal nua ma gu zu lamaskana matmalabuk taksaat, bilok pizin ma gu psin. Ka daxa tamon gu albis la non iwana roro tapal varaxai wana a mara azaxai be, taulaan dina psin nua varaxai wana uru maraam lamaskana a bina iwana adi xaiaf kawit nai maat.” ");
INSERT INTO nal_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ma Iesu xa piaat kaarik naako, “Tuaa naagu raamin azaxai zin a kaana funalik angkari malasing amun sangof. Ga vazei nim, amun aangelo zin naandi la lia di rataamin a marana Maagu la lia. ");
INSERT INTO nal_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Naagu naxaam malasing faa wana a rapti ina xa rauxin amun sipsip ka zangaaflu varazuai, ma a zaxai zin naandi xa malik? Naan kana waan fataling a zangaaflu vaawizik faat ma xa wizik faat inaan la waatawut ma xana wa zaleng azaxai angkanaan ka malik. ");
INSERT INTO nal_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ga piaat faratunaan sinim, araan naa tangin fanong, a dokdokang sina wana a sipsip angkanaan azaxai xa laaup mase wana a dokdokang sina wana amun sipsip ka zangaaflu vaawizik faat ma xa wizik faat ina xawit di malik. ");
INSERT INTO nal_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ka malasing saait bani wana Damana nim la lia, naan kawit na saxot adu tazaxai zin akaana funalik angkari xana milung.” ");
INSERT INTO nal_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ma Iesu xa piaat kaarik naako, “Tamon taatum sunum lamaskana Kaarisito xa giu a matmalabuk taksaat pana nua, gu wat ma gu vazei naan pana matmalabuk taksaat sina labirua wana numaa zingbe. Tamon ka langar zunum, naanaan guna vaamada iaa xaarik. ");
INSERT INTO nal_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Singsaxai tamon kawit na langar zunum, gu maainung taxazak azaxai o urua dina waan faraxai wana nua, wanaze a Baar Xoxok ka piaat naako, ‘A dorang sin axazak urua o urul xana maravan.’ ");
INSERT INTO nal_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tamon kawit na langar zin nandiaa, guna vazei aubina vaakdul ila lotu, wana naan. Ma tamon kawit na langar zaait sin naandi, naaguna naxaam naan malasing axazak kawit na inaxam paazaai wana Nakmai o axazak iwana zuzurukang a taakis. ");
INSERT INTO nal_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ga piaat faratunaan sinim, aze razaan naagu pis tasin iriat la pira angkari, Nakmai xana pis tasin saait la lia. Ma aze razaan naagu akpaat la pira angkari, Nakmai xana akpaat saait la lia. ");
INSERT INTO nal_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ga vazei xaarik nim adu tamon axazak urua iriat la pira angkari, di rudaxa varaxai iaa wana tazaan naadina maainung iaa wana, Maagu la lia xana lis sin nandiaa. ");
INSERT INTO nal_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tamon urua o urul di wat faraxai wana aizinugu, nia gana iziar varaxai wana naandi.” ");
INSERT INTO nal_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita xa wat sin Iesu ma xa iaari zina naako, “Piran, faa sfa gana naxaam pizin a matmalabuk taksaat ina daazugu xa ra giu wana nia? Faawizik urua?” ");
INSERT INTO nal_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma Iesu xa xis naan naako, “Ga vazei nua, xawit faawizik urua be, singsaxai guna naxaam pizin a matmalabuk taksaat sina vaa zangaaflu xa wizik urua ma xa wizik urua. ");
INSERT INTO nal_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ga piaat malasing kari zinim panaze a bikabar ila lia xa malasing a xalxaal ina xa saxot kana raamin fakilaan amun kaakaai iwana vaamuzazang sin amun iaana kilaaiang sina. ");
INSERT INTO nal_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Araan ka iaari zin naandi, di zaxot fawat a iaana kilaaiang sina ina naa ra pis a rudaxaiang faraxai wana naan kuna lizang amun kaakaai zin a xalxaal xat faraxas pana 60 milian amun kaakaai denaarias. ");
INSERT INTO nal_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Singsaxai naan kawit nat faraxas kana lis amun kaakaai zin a xalxaal. Malasing ma a xalxaal, a mono zina, xa lis a dorang dikdik kuna dina vaangurin a rapti angkanaan ma taak sina ma a funalik sina ma amun saan faakdul zina zin taxazak kuna xana wul naandi xuna wulang amun dinaau zina. ");
INSERT INTO nal_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Singsaxai a iaana kilaaiang kanaan ka zibukaak lamarana ma xa maainung naan malasing kari, ‘Simbong fatalamin nia wana notaan angkari, mur gana lis fakdul amun kaakaai zunum.’ ");
INSERT INTO nal_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma a mono zina xa maluf a iaana kilaaiang kanaan ma xa vazei naan adu tuaa xana xis amun kaakaai angkanaan. Ma xa kling pizin naan. ");
INSERT INTO nal_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Singsaxai araan a iaana kilaaiang kanaan ka tukbilak ma xa waan, ka tangin a waliaana dit faamuzas faraxai iaa, ina xa ra pis a rudaxaiang faraxai wana naan kuna lizang amun kaakaai xat faraxas pana a zangaaflu varazuai amun kaakaai denaarias. Naan ka roting naan ma xa xafkuxut a bukadolna ma xa vazei naan naako, ‘Gu xis fazaus a kaakaai gu ra xalxalin.’ ");
INSERT INTO nal_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ma a waliaana xa zibukaak lamarana ma xa maainung naan naako, ‘Simbong fatalamin nia wana notaan angkari, mur gana xis a kaakaai angkanaan.’ ");
INSERT INTO nal_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Singsaxai naan kawit na rudaxa. Ka zaxot naan ma xa rasin naan la vaal a vaamaazikang, ka ruaas la raan naan kat faraxas kana xis faulin a kaakaai zina. ");
INSERT INTO nal_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Araan azanon paliaana a iaana kilaaiang kanaan di raamin azaan angkanaan ka balas sina, a maskana naandi xa raksaat. Di waan sin a mono zin naandi ma di vazei naan pana amun saan faakdul xa ra balas. ");
INSERT INTO nal_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","A mono zina xa kilaai xun a iaana kilaaiang kanaan ma xa piaat sina naako, ‘Nua a iaana kilaaiang taksaat, nia ga ra naxaam pizin amun saan gu ra zuruk surugu wanaze gu zibukaak la maraagu ma gu maainung nia. ");
INSERT INTO nal_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kunaze xawit gu rauxin a varamaaluvang pana a waliaanum malasing nia ga rauxin a varamaaluvang pana nua?’ ");
INSERT INTO nal_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A mono zina xa mangat pana naan ma xa lis naan sin amun tuxaaul ila vaal a vaamaazikang kuna dina lis a vaamaazikang sina xa ruaas a raan naan kat faraxas kana xis amun kaakaai vaakdul naa ra xalxalin sin a xalxaal. ");
INSERT INTO nal_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Maagu la lia xana giu zaait malasing kanaan pana nim ina xawit naagu naxaam pizin faratunaan a matmalabuk taksaat amun taatum sinim di ra giu wana nim.” ");
INSERT INTO nal_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Araan Iesu xa dador vaanong, ka ramaraat inaan Gaalili ma xa waan la pira Judia, ma xa waan laza non rita daanim Jodaan. ");
INSERT INTO nal_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Amun mala aubina di los naan ma xa vira naandi di rauxin amun giazang inaan. ");
INSERT INTO nal_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Azanon Faarasi di wat sina xuna dina vaxabebeu naan, ma di iaari zina malasing kari, “Malasing faa, wana amun Lus sin Moses, ka tak pana a rapti xana kip a maxuzang sina varaxai wana taak sina tamon ka rauxin ta vuvuna?” ");
INSERT INTO nal_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu xa xis naandi naako, “Malasing faa, xawit nanga naagu vakot a dorang lamaskana Baar Xoxok? Ka piaat malasing kari, ‘La varumaraiang iwana faaziarang, Nakmai xa ra vaziaar aubina ma di balas a rapti ma a ravin,’ ");
INSERT INTO nal_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ma xa piaat naako, ‘Naan a vuvuna xanaan a rapti xana vataling damana ma dina ma xana iziar varaxai wana taak sina ma nandiaa di zaxai iaa la winpin.’ ");
INSERT INTO nal_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ma xawit ka di urua iaa, singsaxai di zaxai iaa. Malasing ma aze razaan Nakmai xa ra duma varaxin, tuaa xaarik taxazak ka kip.” ");
INSERT INTO nal_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma amun Faarasi di iaari xaarik sina malasing kari, “Tamon ka malasing kanaan, kunaze Moses ka piaat adu a rapti xana varaar a waambaar xuna kipang a maxuzang ma naana lis sin taak sina xuna xana kling psin naan?” ");
INSERT INTO nal_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma Iesu xa xis naandi malasing kari, “Moses ka rudaxain nim kuna kipang a maxuzang faraxai wana amun taak sinim panaze a maskana nim ka dikdik marazaat, singsaxai la varumaraiang mase, xawit na malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ga vazei nim, tamon a rapti xa kip a maxuzang sina varaxai wana taak sina araan taak sina xawit na giu a matmalabuk iwana milivinang a rapti rawarak, ma a rapti angkanaan ka maxus sin aza ravin tawarak, a rapti angkanaan ka giu a matmalabuk taksaat iwana milivinang a ravin tawarak.” ");
INSERT INTO nal_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ma ubina varaviraai zina di vazei naan malasing kari, “Tamon a lus iwana maxuzang ka lagaf marazaat malasing kanaan, kana daxa be tamon tuaa ra maxuzang.” ");
INSERT INTO nal_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu xa xis naandi naako, “Kawit aubina vaakdul dit faraxas dina rudaxa wana varaviraaiang kanaan. Kawit. Nakmai xa lis a dikdikang be zin azanon. ");
INSERT INTO nal_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Avuna ubina xawit di maxus panaze xa rauxin a vuvuna xa varas. Azanon di luk naandi ma xawit nat faraxas dina raxunalik. Azanon, ubina di valup naandi ma xawit nat faraxas dina maxus, ma azanon, panaze di naxaam a vaamuzazang ila bikabar ila lia ma xawit di maxus. Axazak kat faraxas kana rudaxain a varaviraaiang kanaan, naana rudaxain.” ");
INSERT INTO nal_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Azanon aubina di zaxot fawat a funalik mumut sin Iesu xuna xana rasin uru mitna laaxur wana naandi ma xa maainung pana naandi. Singsaxai ubina varaviraai zina di vadawaar aubina angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma Iesu xa vazei naandi malasing kari, “Naagu luaa a funalik mumut angkanaan dina wat surugu. Tuaa naagu ruxol naandi wanaze a bikabar ila lia zin a funalik mumut malasing kari.” ");
INSERT INTO nal_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Araan ka rasin uru mitna wana naandi ma xa maainung faanong, ka ramaraat inaan ma xa waan. ");
INSERT INTO nal_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aza xulaau xa wat sin Iesu ma xa iaari zina naako, “Maravas, aze razaan daxa gana giu xuna gana zuruk a roro tapal?” ");
INSERT INTO nal_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma Iesu xa xis naan naako, “Kunaze gu iaari zurugu wana aze razaan ka daxa? Ka rauxin be Azaxai ina xa daxa, ma naan Nakmai. Tamon gu saxot guna zuruk a roro tapal, guna valos amun lus sina.” ");
INSERT INTO nal_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A xulaau angkanaan ka iaari zina naako, “Aze ramun lus?” Ma Iesu xa xis naan naako, “Tuaa gu zop famaat axazak, ma tuaa gu giu a matmalabuk iwana milivinang a ravin tawarak, ma tuaa gu vinaau, ma tuaa gu vaagit pana axazak, ");
INSERT INTO nal_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ma gu varanop pana damaam ma dinaam. Ma guna sasaxot a waliaanum malasing gu sasaxot nua nanga.” ");
INSERT INTO nal_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma a xulaau angkanaan ka vazei naan naako, “Amun lus faakdul angkanaan ga valos naandi. Ma aze nanga nia xawit ga giu?” ");
INSERT INTO nal_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma Iesu xa xis naan naako, “Tamon gu saxot guna tak faakdul mase, paan ma guna vaangurin amun lulugaan faakdul zunum kuna aubina dina wul ma a kaakaai iwana guna lis sin aubina di izi gogof. Araan guna giu malasing kanaan, guna raxumbaaxut pana amun lulugaan daxa ila lia. Mur guna wat los nia.” ");
INSERT INTO nal_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","A xulaau xa langar malasing kanaan ma xa ramaraat ma xa waan. Ka maskalus marazaat mase avuna amun lulugaan sina xa varas marazaat. ");
INSERT INTO nal_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma Iesu xa vazei ubina varaviraai zina naako, “Ga vazei varatunaan nim, kana lagaf pana axazak ina xa rauxin a lulugaan ka varas kana albis lamaskana a bikabar ila lia. ");
INSERT INTO nal_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ga vazei zaait nim, iaak kat faraxas pana a kaamel xana albis lamaskana a luk iwana a nil iwana zaxazitang? Singsaxai xana lagaf marazaat nanga wana a rapti raxumbaaxut kana albis lamaskana bikabar zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Araan ubina varaviraai zina di langarin, di raknar mase ma di piaat malasing kari, “Tamon malasing kanaan, nis mase Nakmai xana zaxot faulin?” ");
INSERT INTO nal_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu xa daamaai wana naandi ma xa piaat naako, “Aubina xawit nat faraxas dina giu azaan angkanaan, singsaxai Nakmai xat faraxas kana giu amun saan faakdul.” ");
INSERT INTO nal_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ma Pita xa xis naan naako, “Malasing ma, maadi vataling fanong amun saan faakdul zimaam ma maadi los nua. Aze xapaa xa itate aaxa maam ku mur?” ");
INSERT INTO nal_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma Iesu xa vazei naandi malasing kari, “Ga piaat faratunaan sinim, araan amun saan faakdul xa balas faaxur ma Naata Rapti xa iziar a xalxaal wana akin siziarang sina ina xa rauxin adi marmari daxaiang, nim ina naagu los nia, naaguna iziar zaait pana amun kin siziarang ka zangaaflu ma urua zin amun paamua ma naaguna klis amun patbung ka zangaaflu ma urua in Israael. ");
INSERT INTO nal_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma aubina vaakdul ina di vataling amun faal zin naandi o amun daaza naandi o amun fafina naandi o amun damana naandi o amun dina naandi o vataling a funalik sin naandi o a pira zin naandi, ma di los nia, Nakmai xana lis kaarik amun saan angkanaan, ka zangaaflu varazuai laaxur wana ina naadi rauxin fanong ma dina raumana a roro tapal. ");
INSERT INTO nal_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Singsaxai amala aubina ina di waamua dina wat mur. Ma amala aubina ina di wat mur dina waamua.” ");
INSERT INTO nal_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesu xa piaat kaarik naako, “A bikabar ila lia xa malasing kari: Aza rapti xa raumana a non pira laba. Ka waan paanaraan gufguf kuna wa zaxotang tazanon ubina xuna dina vaamuzas la tesin waain sina. ");
INSERT INTO nal_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma xa rudaxa varaxai wana naandi adu xana wul naandi wana a kaakaai denaarias azaxai, a wulwulang iwana vaamuzazang ila raan azaxai ma xa kling naandi xa waan la tesin waain sina. ");
INSERT INTO nal_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","La marana iaas ka wizik faat paanaraan, ka waan kaarik ma xa raamin azanon ubina di irur walaau be la non iwana balas faraxumulang. ");
INSERT INTO nal_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma xa vazei naandi malasing kari, ‘Naagu waan saait ma naagu vaamuzas la tesin waain surugu ma gana wul nim pana ainaxamang ka tak.’ ");
INSERT INTO nal_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma di rudaxa ma di waan. Ma lamarana iaas ka izi vaatak lawaanaas, ka waan kaarik ma xa zaxot azanon ubina ma di wa vaamuzas. Ma lamarana iaas urul languzaraaf, ka zaxot kaarik azanon ma di wa vaamuzas. ");
INSERT INTO nal_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","La marana iaas ka watmit languzaraaf ka waan kaarik ma xa raamin azanon ubina nanga di irur walaau ma xa iaari zin naandi naako, ‘Kunaze naagu vala irur walaau be iriat la raan kudul angkari?’ ");
INSERT INTO nal_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ma di xis naan malasing kari, ‘Kawit taxazak na zaxot maam kuna vaamuzazang.’ Ma xa vazei naandi naako, ‘Nim saait, naaguna waan ma naaguna vaamuzas la tesin waain surugu.’ ");
INSERT INTO nal_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Languzaraaf, kat faakilan tapti, a rapti ina xa rauxin a tesin waain ka vazei a waamua zin ubina vaamuzazang naako, ‘Firing fawat ubina iriat ma guna wul naandi. Guna tabung pul xalaak naandi ina di balas mur ma xa uzaa faanong pana naandi ina di balas paamua.’ ");
INSERT INTO nal_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ma ubina vaamuzazang ina di samura vaamuzas be lamarana iaas ka watmit languzaraaf di waan ma naan ka lis a kaakaai denaarias azaxai zin naandi zaksaxai, a wulwulang kat faraxas pana a vaamuzazang ila raan azaxai. ");
INSERT INTO nal_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma ubina ina di tabung faamuzas di waan ma di naxaam adu dina zuruk a wulwulang laba. Singsaxai xawit, naan ka lis saait a kaakaai denaarias azaxai zin naandi zaksaxai. ");
INSERT INTO nal_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Araan naandi di suruk pulwulang faanong, di dador varvaras ka wana damana tesin waain. Di vazei naan malasing kari, ");
INSERT INTO nal_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ubina ina gu ra zaxot be naandi languzaraaf, di vaamuzas be wana a aaua azaxai. Ma maam maadi vaamuzas pana a raan kudul ma a iaas ka laang maam, singsaxai gu wul maam malasing be naandi.’ ");
INSERT INTO nal_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ma xa vazei axazak sin naandi naako, ‘A paasaxo zurugu, xawit ga varaksaat nua. Malasing faa, xawit di rudaxa iaa wana a kaakaai denaarias azaxai? ");
INSERT INTO nal_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Suruk a wulwulang sunum ma gu waan. Nia nanga ga saxot gana wul naandi ina di balas mur, xat faraxas malasing nua gu balas paamua. ");
INSERT INTO nal_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ka tak pana nia nanga gana giu aze razaan pana kaakaai zurugu lalozang a inaxamang surugu. Tuaa gu marazuzuai wanaze ga giu a matmalabuk daxa wana ubina angkanaan.’ ");
INSERT INTO nal_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Malasing ma aubina ina di wat mur dina waamua. Ma aubina ina di waamua dina wat mur.” ");
INSERT INTO nal_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Araan Iesu xa zazangas puzaa xun Jerusalem, ka zaxot luk ubina varaviraai zina ziaana amala aubina ma xa vazei naandi malasing kari, ");
INSERT INTO nal_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Naagu langar, naari di uzaa xari xunikula Jerusalem ma axazak kana ngutlis Naata Rapti la mit amun pris laba ma amun maravas iwana amun Lus sin Moses. Ma naandi dina klis adu naan kana maat. ");
INSERT INTO nal_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dina lis naan la mita aubina xawit amun Judaa ma dina vis naan ma dina kmis naan pana wip ma dina tukfating naan pana robuxul. Ma wana varulang a raan, naan kana ramaraat puli.” ");
INSERT INTO nal_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Naanaan taak sin Zebedi, varaxai wana uru naatna di waan sin Iesu ma naanaa zin nandiaa xa zibukaak lamarana ma xa iaari zina wana aza zaan. ");
INSERT INTO nal_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu xa iaari zina naako, “Gu saxot aze?” Ma naan ka xis Iesu malasing kari, “Araan guna balas a xalxaal, guna vaziaar uru naarugu la bikabar zunum, azaxai la mit sazaxa zunum ma axazak la mit kais sunum.” ");
INSERT INTO nal_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma Iesu xa xis naan naako, “Kawit naagu rexaazin taal aze naagu maainung taal wana. Malasing faa, xat faraxas guna imin iaa wana a win imiminang ina nia gana imin?” Ma di xis iaa naan malasing kari, “Maadit faraxas iaa.” ");
INSERT INTO nal_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu xa xis nandiaa naako, “Faaratunaan, guna imin iaa wana win imiminang surugu, singsaxai wana iziarang la mit sazaxa zurugu o la mit kais surugu, nia xawit ga xatkatong kuna gana lis. Maagu nanga xana lis sin naandi ina naa ra nimnimanin aaxan naandi.” ");
INSERT INTO nal_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Araan amun sangaaflu ubina varaviraai di langarin, di mangat pana uru vandaas. ");
INSERT INTO nal_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iesu xa viring fatu naandi ma xa piaat naako, “Naagu rexaas adu amun kalxaal zin aubina xawit amun Judaa, di rauxin a burburaaiang laba laaxur wana naandi ma dit falaup naandi nanga, ma amun paamua laba zin naandi di ratasin a lus dikdik laaxur wana aubina. ");
INSERT INTO nal_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Singsaxai nim tuaa naagu malasing naandi. Tamon axazak ka saxot kana laaup lawalaua nim, naan kana vamumut naan nanga, ma xana balas axazak kat faamuzas be aaxan nim. ");
INSERT INTO nal_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma nis ka saxot kana balas a waamua zinim, naan kana balas a iaana kilaaiang sinim. ");
INSERT INTO nal_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kat faraxas malasing pana Naata Rapti. Naan kawit na wat kuna aubina dina vawaal naan. Kawit. Naan ka wat kuna xana vawaal aubina ma xana lis a roroiang sina nanga xuna wul vaulinang amala aubina.” ");
INSERT INTO nal_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Araan Iesu varaxai wana ubina varaviraai zina di waan fataling Jeriko, adi mala aubina di los naan. ");
INSERT INTO nal_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Uru marawif di iziar iaa la rita lan. Araan di langar iaa adu Iesu xa wat faasilik, di xupkup iaa malasing kari, “Piran, a Natnaat Sin Dewit, gu maluf nimaa.” ");
INSERT INTO nal_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma axulutung aubina angkanaan di vadawaar nandiaa xuna dina ziburung iaa. Singsaxai di xupkup laba iaa nanga malasing kari, “Piran, a Natnaat Sin Dewit! Maluf nimaa!” ");
INSERT INTO nal_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu xa rur ma xa viring fawat nandiaa ma xa iaari zin nandiaa naako, “Aze razaan naagu saxot iaa gana giu wana numaa?” ");
INSERT INTO nal_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma di xis iaa naan malasing kari, “Piran, maadi saxot maadina raamaai iaa.” ");
INSERT INTO nal_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu xa maluf nandiaa ma xa xaaf a marana nandiaa. Ma fazaaus mase di raamaai iaa ma di los iaa naan. ");
INSERT INTO nal_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Araan di wat faasilik lapaara Jerusalem, di balas Betfaage la Waatawut Olif, ma Iesu xa kling urua zin ubina varaviraai zina, ");
INSERT INTO nal_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma xa vazei nandiaa malasing kari, “Naagu waan iaa la bina xa iziar waamua wana numaa. Araan naagu balas iaa inaan, naaguna raamin iaa a dongki ina di pis fating faraxai wana naatna. Gu akpaat iaa nandiaa ma naagu zaxot fawat iaa nandiaa zurugu. ");
INSERT INTO nal_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tamon taxazak ka iaari zunumaa, adu xunaze naagu akpaat iaa uru dongki angkanaan, naagu vazei iaa naan malasing kari, ‘A Piran ka saxot nandiaa.’ Ma fazaaus mase naan kana luaa psin nandiaa zunumaa.” ");
INSERT INTO nal_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Amun saan angkanaan ka balas malasing ma a dorang sin Nakmai xa balas faaratunaan ina a profet ka ra piaat naako, ");
INSERT INTO nal_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Fazei aubina in Zaaion malasing kari, ‘Naagu raamin a xalxaal zinim ka wat sinim, naan ka vamumut naan nanga, ma xa xawaas fawat a dongki, a dongki vaaxur, a naata dongki.’ ” ");
INSERT INTO nal_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Uru rapti varaviraai angkanaan, di waan iaa ma di giu iaa malasing Iesu xa vazei nandiaa. ");
INSERT INTO nal_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Di zaxot fawat iaa a dongki ma naatna ma di zawarin amun marapi baraaf sin nandiaa wana uru dongki angkanaan ma Iesu xa ziar wana. ");
INSERT INTO nal_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma adi xulutung di zawarin amun marapi baraaf sin naandi la lan ma azanon di tok a rangtangaan amun iaai ma di zawarin la lan. ");
INSERT INTO nal_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Adi xulutung aubina ina dit paamuain Iesu ma naandi ina di ilas, dit firaai malasing kari, “Osaanaa zin a Natnaat Sin Dewit!” “A daxaiang ka waan sina ina xa wat pana aizina a Piran.” “Osaanaa ikula mase laaxur!” ");
INSERT INTO nal_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Araan Iesu xa albis Jerusalem aubina vaakdul di banglala ma di iaari varawuk lawalaua naandi zaksaxai malasing kari, “Nis kanaan?” ");
INSERT INTO nal_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Adi mala ina di wat faraxai wana naan, di xis naandi malasing kari, “Naan Iesu, a profet in Naazaret ila non laba Gaalili.” ");
INSERT INTO nal_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu xa albis lamaskana rabaraau ila vaal xoxok ma xa vut pizin aubina vaakdul ina dit pulwul ma naandi dit faangur. Ma xa wukfukin amun iban taasmaaiang sin aubina ina dit kulxulaai kaakaai ma amun iban siziarang sin aubina in dit faangur baalus. ");
INSERT INTO nal_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma xa vazei naandi naako, “Di ra varaar vating lamaskana a Baar Xoxok malasing kari, ‘Dina vakilaan a vaal zurugu adu a vaal a maainungang, singsaxai nim naagu giu malasing a non iwana zikamang sin amun finaau.’ ” ");
INSERT INTO nal_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ma amun marawif ma amun kaak taksaat di wat sina la vaal xoxok ma xa vira naandi. ");
INSERT INTO nal_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Singsaxai araan amun pris laba varaxai wana amun maravas iwana amun Lus sin Moses di raamin amun saan daxa naa vabalos, ma a funalik dit firaai inaan la rabaraau ila vaal xoxok malasing kari, “Osaanaa zin a Natnaat Sin Dewit,” di mangat taksaat. ");
INSERT INTO nal_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma di iaari zin Iesu malasing kari, “Gu langarin aze a funalik angkari di ipiaat?” Ma Iesu xa xis naandi naako, “Aiang. Malasing faa, xawit nanga naagu vakot a Baar Xoxok? Ka piaat malasing kari, ‘Naagu viraai vanong a funalik ma amun popo xuna wisfaruiang aizinum.’ ” ");
INSERT INTO nal_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma Iesu xa vataling naandi inaan Jerusalem ma xa waan Betani ma xa wa iziar inaan labung. ");
INSERT INTO nal_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Paanaraan gufguf, Iesu xa uli uzaa xun Jerusalem ma xa lagaai. ");
INSERT INTO nal_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ka raamin a iaai a fik inaan la rita lan ma xa waan lapaarana. Singsaxai xawit na raamin ta vuaaina, amun paxana be. Ma xa vazei a iaai a fik naako, “Taning ma xa uzaa, guna wen fuai xaarik.” Ma fazaaus mase a iaai a fik ka maraang. ");
INSERT INTO nal_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Araan ubina varaviraai di raamin, di raknar ma di iaari zina malasing kari, “Malasing faa a iaai a fik ka maraang fazaaus?” ");
INSERT INTO nal_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Naan ka xis naandi naako, “Ga vazei varatunaan nim, tamon naagu rauxin a inaxam paazaaiang ma xawit naagu rauxin ainaxamang urua, xat faraxas naaguna giu a zaan ina ga ra giu wana a iaai a fik angkari. Ma xat faraxas saait naaguna vazei a waatawut angkari malasing kari, ‘Tamaraat inaan ma gu psin nua nana raas,’ ma xana balas malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tamon naagu inaxam paazaai, amun saan faakdul ina naagu maainung pana, naaguna zuruk.” ");
INSERT INTO nal_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu xa albis lamaskana rabaraau ila vaal xoxok ma araan kat firaai aubina, amun pris laba varaxai wana amun paamua zin aubina di wat ma di iaari zina malasing kari, “Gu zuruk a burburaaiang faa xuna giuang amun saan angkanaan? Ma nis ka lis a burburaaiang kanaan sunum?” ");
INSERT INTO nal_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma Iesu xa xis naandi naako, “Nia zaait gana iaari zinim pana aza iaariang. Tamon naaguna xis nia, gana vazei nim nis ka lis a burburaaiang nia ga giu amun saan angkari wana. ");
INSERT INTO nal_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A burburaaiang sin Jon kuna baaptaaizang ka wat faa? Ikula la lia o zin aubina be?” Di dador wana lawalau a naandi nanga malasing kari, “Tamon dina piaat adu inikula la lia, naan kana iaari zin dia adu ma xunaze xawit naagu inaxam paazaai wana naan? ");
INSERT INTO nal_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma tamon dina piaat adu zin aubina be, dia dina maraaut pana aubina zaait, taulaan dina mangat pana dia wanaze naandi vaakdul di inaxam paazaai adu Jon naan a profet.” ");
INSERT INTO nal_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Malasing ma di xis be Iesu malasing kari, “Kawit maadi rexaas.” Ma Iesu xa vazei naandi naako, “Ma nia zaait gana wen fazei nim a burburaaiang ka wat faa, nia ga giu amun saan angkari wana.” ");
INSERT INTO nal_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesu xa vazei xaarik amun paamua naako, “Naagu naxaam malasing faa? Aza rapti xa rauxin uru naatna. Ka waan sin a ruaan ma xa vazei naan naako, ‘Naarugu, taning guna wa vaamuzas lamaskana tesin waain.’ ");
INSERT INTO nal_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma xa xis damana naako, ‘Ga baai.’ Singsaxai mur naan ka plaas ainaxamang sina ma xa waan. ");
INSERT INTO nal_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mur damana nandiaa xa waan kaarik sin aza naatna ma xa vazei naan malasing saait kanaan, ma naatna xa xis naan naako, ‘Aiang maamaa, gana waan.’ Singsaxai xawit na waan.” ");
INSERT INTO nal_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ma Iesu xa iaari zin naandi malasing kari, “Nis sin nandiaa xa giu aze damana nandiaa xa saxot?” Ma di xis naan malasing kari, “A ruaan.” Ma Iesu xa vazei naandi naako, “Ga vazei varatunaan nim, aubina iwana zuzurukang a taakis faraxai wana a furavin dit faangurin a winpina naandi xuna kaakaai dina albis paamuain nim la bikabar zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Naan a vuvuna xanaan Jon ka ra wat ma xa viraai nim pana matmalabuk ka tak ma xawit naagu inaxam paazaai wana naan. Singsaxai ubina iwana zurukang a taakis ma a furavin dit faangurin a winpina naandi xuna kaakaai, di inaxam paazaai wana naan. Ma araan naagu ra raamin naandi di inaxam taawuk, kawit naagu inaxam taawuk ma naagu inaxam paazaai wana naan.” ");
INSERT INTO nal_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesu xa piaat kaarik naako, “Naagu langarin aza dorang lalaamangaai: Aza rapti xa vazu a tesin waain la pira zina ma naa pai xol wana balavaat. Inaan lamaskana tesin waain angkanaan ka xaaf a luk kuna maios turinang a daanim a waain. Ma xa varur a nan faal xa uzaa mase laaxur aaxan ubina xuna raamaai xaaulang pana a tesin. Mur xa lis a tesin waain la mita azanon ubina xuna dina xatkatong pana azanon flan ma di pis a rudaxaiang kuna dina lis tazanon fnuaaia waain sina. Ma naan ka waan laza bina lawalaau. ");
INSERT INTO nal_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","La raan iwana mos turinang amun fnuaaia waain, ka kling azanon iaana kilaaiang ka waan sin ubina dit katkatong a tesin waain sina xuna dina zuruk tazanon fnuaaia waain. ");
INSERT INTO nal_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma ubina angkanaan di zaraak amun iaana kilaaiang sina ma di wit azaxai, di zop famaat axazak ma di tuk axazak pana amun faat. ");
INSERT INTO nal_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ma xa kling kaarik azanon iaana kilaaiang ka waan sin naandi, ma di varas pana naandi angkaina naa tabung kling paamua. Singsaxai ubina angkanaan, di zaraak kaarik naandi ma di giu malasing be naadi ra giu wana azanon paamua. ");
INSERT INTO nal_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mur mase naan ka kling naatna vaaratunaan ka waan sin naandi wanaze xa naxaam adu dina varanop pana naan. ");
INSERT INTO nal_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Singsaxai araan ubina di raamin naatna, di pis tasin a dorang malasing kari, ‘A rapti angkanaan kana raumana amun saan sin damana. Dia dina zop famaat naan kuna a tesin waain angkari aaxan dia xa.’ ");
INSERT INTO nal_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Di zaraak fating naan ma di psin fatukbilok naan la tesin waain angkanaan ma di zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Malasing ma, araan damana tesin waain angkanaan ka balas, aze xa naana giu wana ubina angkanaan?” ");
INSERT INTO nal_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma amun paamua zin aubina di xis naan malasing kari, “Naan kana zop famaat ubina raksaat angkanaan ma xana lis a tesin waain sin tazanon ubina rawarak kuna dina lis azanon fnuaaia waain sina la raan a mozang amun fnuaaia waain.” ");
INSERT INTO nal_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma Iesu xa xis naandi naako, “Malasing faa, xawit nanga naagu vakot a dorang kari lamaskana Baar Xoxok? Ka piaat malasing kari, ‘A vaat ina aubina di gigiu vaal di bain pizin, naan kanaan ka balas a varumaraiang a vaat iwana vaal. Nakmai xa ra giu azaan angkanaan ma xa marmari daxa wana rataamaaiang sin dia.’ ");
INSERT INTO nal_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Malasing ma ga vazei nim, Nakmai xana zuruk pizin a bikabar zina ziaana nim ma naana lis sin aubina a roroiang sin naandi xana vabalos a fnuaai daxa ina xat faraxas pana a bikabar zina. ");
INSERT INTO nal_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tamon taxazak kana zu wana a vaat angkanaan, kana raabuak faamimidi ma axazak ina a vaat angkanaan kana zu waramin naan, naan kana mem.” ");
INSERT INTO nal_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Araan amun pris laba ma amun Faarasi di langarin amun dorang lalaamangaai zin Iesu, di rexaas adu naan kai dador be wana naandi. ");
INSERT INTO nal_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ma di zaleng ta lan kuna zaraakang naan, singsaxai di marauring adi xulutung angkanaan panaze aubina di naxaam adu naan a profet. ");
INSERT INTO nal_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu xa vazei xaarik naandi wana aza dorang lalaamangaai naako, ");
INSERT INTO nal_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A bikabar ila lia xa malasing a xalxaal ina naatna adu xana maxus. Malasing ma a xalxaal xa nimnimanin adi flangan lapuk. ");
INSERT INTO nal_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Naan ka kling amun iaana kilaaiang sina xuna zaxot fatuiang aubina ina naa ra maainung naandi xuna watang pana a flangan iwana vaamaxuzang, singsaxai di baai. ");
INSERT INTO nal_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ka kling kaarik azanon iaana kilaaiang ma xa vazei naandi naako, ‘Naaguna waan sin naandi ina ga ra maainung naandi xuna watang ma naagu vazei naandi adu a flangan ka nimniman ka. Ga zop famaat amun bulumagau rapti varaxai wana amun bulumagau vaaxur ina di walak daxa ma amun saan faakdul xa nimniman faanong. Naandi dina wat pana a flangan iwana vaamaxuzang.’ ");
INSERT INTO nal_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Singsaxai aubina ina naa ra maainung naandi xuna watang kawit di langar. Di raalil wana amun faamuzazang sin naandi. A xazak ka waan la uma zina ma xazak ka wa vaamuzas kuna kaakaai aaxana. ");
INSERT INTO nal_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma azanon di zaraak amun iaana kilaaiang sin a xalxaal ma di wit naandi ma di zop famaat naandi. ");
INSERT INTO nal_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A xalxaal angkanaan ka mangat mase ma xa kling ubina dauran sina ma di zop famaat ubina ina di ra zop famaat palau amun iaana kilaaiang sina ma xa vaif a bina zin naandi. ");
INSERT INTO nal_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ka vazei xaarik amun iaana kilaaiang sina naako, ‘A flangan iwana vaamaxuzang ka nimniman faanong. Singsaxai naandi ina ga ra maainung naandi xuna watang, a matmalabuk sin naandi xa vatangin adu xawit nat faraxas naandi dina iziar wana a flangan. ");
INSERT INTO nal_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Naaguna waan lamun nguza lan ka varazuai ma aubina vaakdul ina naagu vasuin naandi, naagu maainung naandi dina wat iriat pana flangan iwana vaamaxuzang.’ ");
INSERT INTO nal_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Malasing ma amun iaana kilaaiang di waan lamun nguza lan ka varazuai ma di viring fatu aubina vaakdul ina naadi vasuin. Aubina raksaat ma aubina daxa zaait, ma a vaal angkanaan ka bas pana amun topuran. ");
INSERT INTO nal_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Singsaxai araan a xalxaal xa albis kuna raaminang amun topuran sina, xa raamin aza rapti xawit na valaak a marapi xat faraxas kuna iziarang pana a flangan iwana vaamaxuzang. ");
INSERT INTO nal_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma xa iaari zina naako, ‘Paluaak, gu albis malasing faa iriat pana xawit gu mamaaus pana amun marapi xat faraxas pana iziarang pana flangan iwana vaamaxuzang.’ Singsaxai a rapti xawit na dador. ");
INSERT INTO nal_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ma a xalxaal xa vazei amun iaana kilaaiang naako, ‘Naagu pis fating uru mitna ma uru xaakna ma naagu psin fatukbilok naan ku lamaskana bungsuzuk, a non aubina di rataangis ma dit karaat alvana naandi.’ ” ");
INSERT INTO nal_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ma Iesu xa vanong a dorang sina malasing kari, “Nakmai xat maainung aubina xa varas kuna watang, singsaxai xai kalin luk be aubina xawit faras.” ");
INSERT INTO nal_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mur amun Faarasi di waan ma di pis a dorang adu dina vaxabebeu Iesu wana azanon dorang kuna dina vakor naan. ");
INSERT INTO nal_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Di kling ubina varaviraai zin naandi ma ubina zin Erot di waan sin Iesu ma di piaat sina malasing kari, “Maravas, maadi rexaas adu nua a rapti gu tak. Gut firaai aubina wana matmalabuk sin Nakmai wana dorang faaratunaan. Ma xawit gut maraaut pana axazak ina xa rauxin aiza laba. Gui piaat a dorang azaxai zin aubina vaakdul, naapalaau naandi di rauxin aiza laba o naandi xawit ta iza. ");
INSERT INTO nal_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gu naxaam aze, fazei maam, ka tak pana dina wul a taakis ka waan sin Siza o xawit?” ");
INSERT INTO nal_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Singsaxai Iesu xa rexaas mase wana ainaxamang taksaat sin naandi, malasing ma xa vazei naandi naako, “Nim aubina ina xawit naagut falos a dorang sinim. Kunaze naagu saxot naaguna vaxabebeu nia? ");
INSERT INTO nal_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Naaguna vatangin ta kaakaai zurugu ina di wulwul a taakis pana.” Ma di zuruk fawat a kaakaai denaarias sina. ");
INSERT INTO nal_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma xa iaari zin naandi naako, “A waroka nis kari ma a fararang kari wana nis?” ");
INSERT INTO nal_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma di xis naan malasing kari, “Zin Siza.” Ma xa vazei naandi naako, “Aze razaan sin Siza, naagu lis sin Siza, ma aze razaan sin Nakmai, naagu lis sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Araan di langarin, di raknar mase ma di waan fataling naan. ");
INSERT INTO nal_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","La raan angkanaan nanga, amun Saadusi di waan sin Iesu varaxai wana aza iaariang. Di ipiaat adu xawit a ramaraat puliang pana maatang. ");
INSERT INTO nal_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ma di piaat malasing kari, “Maravas, Moses ka ra varaar adu, tamon a rapti xa maat fataling taak sina, ma xawit di raxunalik iaa, daasna xana zaxot a raksiziar zina ma xana vabalos a funalik aaxan daasna ina xa maat. ");
INSERT INTO nal_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ka rauxin amun fandaas ka wizik urua xari lawalaua maam. A ruaan ka maxus ma xa maat fataling taak sina ma xawit ta nalik sin nandiaa. Ma a varuaiang daasna xa maxus kaarik a ravin angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ka malasing saait be xanaan pana varuaiang daasna ma a varulang. Ma naandi vaakdul xa wizik urua di maxus sina ma di maat. ");
INSERT INTO nal_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ma mur a ravin saait ka maat. ");
INSERT INTO nal_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","La raan a ramaraat puliang, a ravin angkanaan, mase taak sinis sin naandi? Avuna naandi vaakdul xa wizik urua amun fandaas di maxus sina.” ");
INSERT INTO nal_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma Iesu xa vazei naandi naako, “Ainaxamang sinim kawit na tak, panaze xawit naagu rexaazin a dorang lamaskana Baar Xoxok o a dikdikang sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","La raan a ramaraat puliang, aubina dina wen maxus ka, dina malasing amun aangelo inikula la lia. ");
INSERT INTO nal_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Naagu ipiaat adu amun maat dina wen tamaraat puli. Malasing faa, xawit nanga naagu vakot a dorang ina Nakmai xa ra vazei nim pana? Naan ka piaat naako, ");
INSERT INTO nal_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nia Nakmai zin Aabaraam ma Nakmai zin Aaisaak ma Nakmai zin Jekop.’ Nakmai xawit Nakmai zin amun maat. Kawit. Naan Nakmai zin aubina di roro.” ");
INSERT INTO nal_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Araan amala aubina di langarin, di raknar mase wana varaviraaiang sina. ");
INSERT INTO nal_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Araan amun Faarasi di langar adu Iesu xa waramin amun Saadusi wana dadorang, di wat faraxai lapaarana. ");
INSERT INTO nal_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma axazak sin naandi, naan axazak ka mazam pana amun Lus sin Moses, ka lalaamangaain Iesu wana iaariang malasing kari, ");
INSERT INTO nal_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maravas, aze ra lus ka laaup lamaskana amun Lus faakdul zin Moses?” ");
INSERT INTO nal_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma Iesu xa xis naan naako, “ ‘Naaguna sasaxot a Piran Nakmai zinim pana maska vaakdul zinim ma wana a laklagai vaakdul zinim ma wana a inaxamang faakdul zinim.’ ");
INSERT INTO nal_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A lus angkanaan ka varumara ma xa laaup mase. ");
INSERT INTO nal_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma a varuaiang a lus ka malasing a lus angkanaan. Ka piaat malasing kari, ‘Guna sasaxot a waliaanum malasing be gu sasaxot nua nanga.’ ");
INSERT INTO nal_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Amun Lus sin Moses faraxai wana amun baar vaakdul zin amun profet di irur laaxur be wana uru lus angkanaan.” ");
INSERT INTO nal_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Araan amun Faarasi di iziar nanga varaxai wana naan inaan, Iesu xa iaari zin naandi naako, ");
INSERT INTO nal_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Naagu naxaam malasing faa wana a Mesaaia? Naan mase naata nis?” Di xis naan malasing kari, “Naan a natnaat sin Dewit.” ");
INSERT INTO nal_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ma Iesu xa piaat sin naandi naako, “Tamon malasing kanaan, kunaze Dewit ka vakilaan a Mesaaia wana ‘a Piran’ araan a Laklagaai a Raabu xa sfaar naan? Avuna Dewit ka ra piaat naako, ");
INSERT INTO nal_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘A Piran Nakmai xa piaat sin a Piran surugu naako, “Siar la mit sazaxa zurugu, xa ruaas a raan gana rasin amun purua zunum lawaana uru xaakum.” ’ ");
INSERT INTO nal_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dewit ka vakilaan a Mesaaia wana ‘a Piran.’ Tamon malasing kanaan, malasing faa naan a natnaat sin Dewit?” ");
INSERT INTO nal_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kawit taxazak kat faraxas kana piaat ta dorang kuna xizang naan. Ka varumara la raan angkanaan, kawit ka taxazak na iaari zina xaarik pana ta iaariang. ");
INSERT INTO nal_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Naanaan Iesu xa vazei amun mala aubina varaxai wana ubina varaviraai zina naako, ");
INSERT INTO nal_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Amun maravas iwana amun Lus sin Moses ma amun Faarasi di zuruk a kiaana Moses pana viraaiang aubina wana lus. ");
INSERT INTO nal_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Malasing ma nim naaguna valos a dorang faakdul zin naandi ma naaguna giu amun saan faakdul ina naadi piaat sinim. Singsaxai tuaa naagu valos amun matmalabuk sin naandi, wanaze naandi nanga xawit dit falos amun saan ina naadi ipiaat. ");
INSERT INTO nal_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Naandi di ipis amun maravanang la xalxalana aubina, singsaxai naandi nanga xawit di saxot dina raxut ta klusmit kuna vawaalang naandi xuna vazaakang. ");
INSERT INTO nal_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Amun Faarasi di gigiu amun saan faakdul xuna aubina dina raamin. Araan naandi di giu akaana bogis kuna rasinang azanon dorang mumut ila Baar Xoxok, dina giu zin naandi xana lapuk pana zin aubina vaakdul. Ma araan di pis a iaarus la zuva amun marapi zin naandi, xana baraaf pana zin aubina vaakdul. ");
INSERT INTO nal_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma di sasaxot amun kin siziarang sin ubina laba wana amun flangan ma di sasaxot saait dina iziar wana amun kin siziarang sin ubina laba lamaskana amun faal a maainungang sin amun Judaa. ");
INSERT INTO nal_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Di sasaxot adu aubina dina lis a varanopang pana naandi lamun non iwana balas fatuiang ma dina vakilaan naandi Raabi. ");
INSERT INTO nal_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Singsaxai nim, tuaa dina vakilaan nim Raabi wanaze azaxai be naan a Maravas sinim ma nim faakdul amun fandaas. ");
INSERT INTO nal_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma tuaa naagu vakilaan taxazak iriat la pira angkari damana nim panaze axazak be azaxai naan Damana nim ina xa iziar la lia. ");
INSERT INTO nal_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma tuaa dina vakilaan nim adu nim amun maravas panaze azaxai be naan a Maravas sinim, naan a Mesaaia. ");
INSERT INTO nal_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Axazak ka laaup lawalaua nim, kana vamumut naan nanga ma xana balas a iaana kilaaiang sinim. ");
INSERT INTO nal_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Avuna axazak kat falaup naan nanga, Nakmai xana vamumut naan ma axazak kat famumut naan nanga, Nakmai xana valaup naan. ");
INSERT INTO nal_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Kana raksaat mase zinim amun maravas iwana amun Lus sin Moses ma amun Faarasi, nim aubina xawit naagut falos a dorang sinim. Naagui ruxol aubina xuna tuaa dina albis la bikabar ila lia. Nim nanga xawit naagu albis ma naagu ruxol zaait aubina ina di saxot dina albis. ");
INSERT INTO nal_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kana raksaat mase wana nim amun maravas iwana amun Lus sin Moses ma amun Faarasi, nim aubina xawit naagut falos a dorang sinim. Naagu zazangas farawuk lamun non taas ma lamun non ila pira angkari xuna urivang taxazak kuna lozang awat matmalabuk sinim. Ma araan naan kat falos amun matmalabuk sinim, naagut fabalos naan kuna amun matmalabuk sina xana raksaat marazaat mase wana zinim ma naan kana vazaak adi maazikang laba malasing nim lamaskana a bina iwana adi xaiaf kawit nai maat. ");
INSERT INTO nal_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kana raksaat mase wana nim amun paamua ina naagu malasing amun marawif, naagut fatangin a lan sin aubina malasing faa? Avuna naagui piaat malasing kari, ‘Tamon taxazak ka xalxal wana a vaal xoxok, a xalxalang sina xa zaan palaau be singsaxai tamon axazak ka xalxal wana a goul ina xa iziar la vaal xoxok, naan kana waambazof a xalxalang sina.’ ");
INSERT INTO nal_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nim amun tabanat, naagu malasing amun marawif. Aze razaan ka laaup lamarana Nakmai: a goul xa laaup o a vaal xoxok ina xat faxoxok a goul lamarana Nakmai? ");
INSERT INTO nal_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Naagui piaat saait malasing kari, ‘Tamon axazak ka xalxal wana a aalta, a xalxalang sina xa zaan palaau be, singsaxai tamon ka xalxal wana a talazang laaxur wana aalta, naan kana waambazof a xalxalang sina.’ ");
INSERT INTO nal_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Naagu malasing amun marawif! Aze ra zaxai zin nandiaa xa laaup lamarana Nakmai: a talazang o a aalta ina xat faxoxok a talazang lamarana Nakmai? ");
INSERT INTO nal_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Malasing ma tamon axazak ka xalxal wana a aalta, naan ka xalxal zaait pana amun talazang faakdul laaxur wana aalta. ");
INSERT INTO nal_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma tamon axazak ka xalxal wana a vaal xoxok, naan ka xalxal zaait pana Nakmai ina xa iziar inaan. ");
INSERT INTO nal_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma tamon axazak ka xalxal wana a lia, naan ka xalxal zaait pana akin izi xalxaalang sin Nakmai ma wana Nakmai ina xa iziar wana. ");
INSERT INTO nal_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kana raksaat mase wana nim amun maravas iwana amun Lus sin Moses ma amun Faarasi, nim aubina xawit naagut falos a dorang sinim. Naagui talas sin Nakmai wana a ngabuk azaxai iwana amun ngabuk ka zangaaflu iwana amun paxana kaana iaai ila uma xat famikuf a vanganang, malasing a mint ma a dil ma a kumin. Singsaxai xawit naagut falos amun faraviraaiang iwana amun lus ina di laaup pana amun lus angkanaan, malasing a matmalabuk iwana klis fatokang aubina ma a matmalabuk iwana varamaaluvang ma a matmalabuk iwana giu valozang amun dorang sinim nanga. Naaguna giu vatfaraxazin amun faraviraaiang iwana amun lus angkanaan, ma tuaa naagu naxambain a kaana lus mumut lamaskana amun Lus sin Moses. ");
INSERT INTO nal_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nim naagu malasing amun marawif, naagut fatangin a lan sin aubina malasing faa? Naagui gut mase xuna valozang a kaana lus mumut malasing axazak ina xai daring a ngit lamaskana a win daanim naana imin ma naai gut kuna waapizinang, singsaxai xawit naagu valos amun non laba lamaskana lus malasing axazak angkanaan kawit na raamin adi kaamel lamaskana a daanim ma naa imin ma naa xanom fakdul. ");
INSERT INTO nal_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kana raksaat mase wana nim amun maravas iwana amun Lus sin Moses ma amun Faarasi, nim aubina xawit naagut falos a dorang sinim. Naagu zuksuk fatalamin a tora amun pin imiminang ma amun pin favanganang, singsaxai a maskana naandi xa bas pana amun saan ka mitikaai naagu zuzuruk pana matmalabuk iwana lamaiang ma a matmalabuk iwana valozang be a sasaxotang sinim nanga. ");
INSERT INTO nal_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Amun Faarasi, naagu marawif! Naaguna tabung suk fatalamin kalaak a maskana amun pin imiminang ma amun pin favanganang ma mur laxo lamanar zaait kana ninis. ");
INSERT INTO nal_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kana raksaat mase wana nim amun maravas iwana amun Lus sin Moses ma amun Faarasi, nim aubina xawit naagut falos a dorang sinim. Naagu malasing amun baaul a maat ina di zaaf faxufkuf pana a waraxa ma di marmari daxa lu lamanar. Singsaxai a maskana naandi xa bas pana ruaana maat ma amun saan faakdul ina xa mitikaai. ");
INSERT INTO nal_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Malasing bani zaait pana nim, lamanar naagu raamaai malasing naagu tak mase lamarana aubina, singsaxai a maskana nim ka bas pana matmalabuk iwana piaatang amun dorang singsaxai xawit naagut falos ma wana amun matmalabuk taksaat. ");
INSERT INTO nal_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kana raksaat mase wana nim, amun maravas iwana amun Lus sin Moses ma amun Faarasi, nim aubina xawit naagut falos a dorang sinim. Naagut farur a waata iza wana amun baaul a maat sin amun profet ma naagut famamaus amun luka maat sin aubina di tak. ");
INSERT INTO nal_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma naagu ipiaat sinim malasing kari, ‘Tamon dia di lek iziar la raan sin amun kulmua zin dia, dina wen fawaal naandi wana zop famaatang amun profet.’ ");
INSERT INTO nal_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Singsaxai naari naagu pitfiaat nim nanga adu nim amun duxuna naandi ina di ra zop famaat palau amun profet. ");
INSERT INTO nal_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lawaxas, naagu waan ma naagu vanong fakdul amun matmalabuk taksaat ina amun kulmua zinim di ra varumara. ");
INSERT INTO nal_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nim amun sizi! Nim a funalik sin amun sizi di ikarat! Malasing faa, xat faraxas naaguna valaau ziaana aikilizang kuna valiuang a bina iwana adi xaiaf kawit nai maat? ");
INSERT INTO nal_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Malasing ma naagu langar. Gana kling fawat amun profet ma ubina mazam ma amun maravas inaan sinim. Naaguna zop famaat azanon sin naandi ma azanon naaguna tukfating naandi laaxur wana robuxul. Ma azanon naaguna kmis naandi lamaskana amun faal a maainungang sinim ma naaguna vut pizin naandi ma dina valaau waan laza bina xu laza bina. ");
INSERT INTO nal_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Malasing ma naaguna zuruk a vaamaazikang sin aubina vaakdul ina di ra zop famaat palau aubina di tak laaxur wana a pira angkari, di varumarain pana Aabel, ma xa uzaa tuaas pana Zekaria di zop famaat naan, naan naata Berekia, ina naagu ra zop famaat lawalaua vaal xoxok ma a aalta. ");
INSERT INTO nal_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ga piaat faratunaan sinim, a wulwulang taksaat iwana amun matmalabuk taksaat faakdul angkanaan kana balas sin a watkul angkari i taning.” ");
INSERT INTO nal_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ma Iesu xa piaat kaarik naako, “Amun Jerusalem, amun Jerusalem, naagu zopsop famaat amun profet ma naagui tukfamaat naandi ina Nakmai xa ra kling fawat naandi zinim. Faavaras faanong, gat naxaam adu gana zaxot fatuin nim malasing a uraa ravin kat fatu a funalik sina xula waana bibina. Singsaxai xawit naagu saxot nia gana xatkatong nim. ");
INSERT INTO nal_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Naagu langar! Nakmai xana vataling a bina zinim ma xana bingil. ");
INSERT INTO nal_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ga vazei nim, naaguna wen taamin kaarik nia, xa ruaas la raan naaguna piaat malasing kari, ‘Naan ina xa wat pana aizina a Piran, Nakmai xa ra lis a daxaiang sina.’ ” ");
INSERT INTO nal_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Araan Iesu xa vataling a rabaraau ila vaal xoxok ma xa zangas ku lamanar, ubina varaviraai zina di wat sina xuna dina vatangin azanon faal ila vaal xoxok di rur lapaarana. ");
INSERT INTO nal_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ka piaat sin naandi naako, “Naagu raamin amun saan faakdul angkari, aan? Ga vazei varatunaan nim, kawit ta vaat azaxai xana imaal laaxur wana axazak, amun purua dina wul psin ku waanaburut.” ");
INSERT INTO nal_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesu xa waan ma xa iziar la Waatawut Olif, ma ubina varaviraai zina zingbe di wat sina ma di piaat malasing kari, “Fazei maam, lasang amun saan faakdul angkanaan kana balas? Ma aze ra wat faakilanang kana balas kuna xana vatidaai maam pana a uli watang sunum ma a vaanongang iwana a pira angkari?” ");
INSERT INTO nal_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ma Iesu xa xis naandi naako, “Naagu naknakaai, taulaan taxazak kana vagit nim. ");
INSERT INTO nal_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Avuna amala dina wat dina vaagit pana vakilaanang aizinugu ma dina piaat malasing kari, ‘Nia a Mesaaia,’ ma dina vagit aubina xa varas. ");
INSERT INTO nal_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Naaguna langarin a ling amun faropang lapuk ma amun fingaaiang pana varopang, singsaxai tuaa naagu maraaut. Awat saan malasing kanaan kana balas faaratunaan singsaxai a vaanongang iwana a raan kawit nanga. ");
INSERT INTO nal_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ma aza gaapman kana varop faraxai wana aza gaapman tawarak ma aza xalxaal xana varop faraxai wana aza xalxaal rawarak. Ma amun zong ma amun maraulia dina balas lamun non farawuk. ");
INSERT INTO nal_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Amun saan angkari xana malasing a varumaraiang a maazikang ina a ravin kana tabung kazanin araan naako xana luk a popo. ");
INSERT INTO nal_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mur aubina dina lis pizin nim kuna dina vamazik nim ma dina zop famaat nim ma amun kaantri vaakdul dina maska raksaat pana nim, a vuvuna wana aizinugu. ");
INSERT INTO nal_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","La raan angkanaan, amala ina di inaxam paazaai wana nia, a inaxam paazaaiang sin naandi xana zu ma dina maska raksaat pana naandi zaksaxai ma dina ngutlis naandi la mit amun purua. ");
INSERT INTO nal_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Amun profet faagit ka varas saait dina balas ma dina vagit aubina xa varas. ");
INSERT INTO nal_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A matmalabuk taksaat kanat laba uzaa, malasing ma aubina xa varas dinat luaa psin a matmalabuk iwana sasaxotang azanon tawarak. ");
INSERT INTO nal_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Singsaxai axazak ina xa irur dikdik ka ruaas pana vaanongang, Nakmai xana zaxot faulin naan. ");
INSERT INTO nal_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma dina fazei wana Dorang Daxa angkari iwana a bikabar, la pira vaakdul angkari malasing a dor vaamaravazang ka waan sin aubina iwana amun linga bina vaakdul, ma mur a vaanongang iwana amun taan kana balas.” ");
INSERT INTO nal_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Iesu xa piaat kaarik naako, “Naaguna raamin azaan ka mitikaai xana rur lamaskana vaal xoxok. Kana vamitikaai amun non kuna xawit nat faraxas taxazak kana iziar inaan. Azaan angkari ina profet Daaniel xa ra dador wana. Axazak ka vakot a dorang kari xana mazaam aknaasna. ");
INSERT INTO nal_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ma la notaan angkanaan, naandi ina di iziar Judia, dina valaau xu lamun paatawut. ");
INSERT INTO nal_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Axazak ka irur laaxur la waata vaal zina, araan ka kabal xuna valaauang, tuaa xana albis kuna zuruk fatukbilokang amun lulugaan sina. ");
INSERT INTO nal_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma axazak ka iziar la uma, tuaa xana uli xula vaal xuna zurukang a marapi baraaf sina. ");
INSERT INTO nal_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ma la raan angkanaan, kana raksaat mase wana a furavin ina di buxut ma a furavin di vaazus. ");
INSERT INTO nal_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Naaguna maainung kuna a raan angkanaan iwana valaauang kana wen balas lamun flan iwana milaatus o la raan a Saabat. ");
INSERT INTO nal_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Avuna la raan angkanaan kana rauxin adi maravanang laba mase. Mumua pis araan a pira xa vaaxur nanga ma xa ruaas taning, kawit awat maravanang malasing kanaan ka ra balas. Ma mur zaait kana wen tauxin ta wat maravanang malasing kanaan kana balas. ");
INSERT INTO nal_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tamon Nakmai xana wen kip fabut amun taan angkanaan iwana maravanang, kawit taxazak kana roro. Singsaxai naana kip fabut panaze naan ka inaxam pana aubina ina naa kalin naandi. ");
INSERT INTO nal_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","La notaan angkanaan tamon axazak ka piaat sinim naako, ‘Taamin, a Mesaaia xari,’ o ‘A Mesaaia xa paa,’ tuaa naagu inaxam paazaai wana dorang sina. ");
INSERT INTO nal_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Avuna azanon dina balas ma dina vaagit malasing kari, ‘Nia a Mesaaia.’ Ma azanon dina balas ma dina vaagit malasing kari, ‘Nia a profet sin Nakmai.’ Ma dina vabalos amun faakilanang laba ma amun faaxoxovang. Ma tamon kat faraxas, dina vagit saait naandi ina Nakmai xa ra kalin adu naandi aaxana vaatak. ");
INSERT INTO nal_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Naagu langar, ga vazei vanong nim paamua wana amun saan kana balas. ");
INSERT INTO nal_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Malasing ma tamon taxazak kana vazei nim naako, ‘A Mesaaia xa kula la non bingil,’ tuaa naagu waan la non angkanaan. O tamon taxazak ka vazei nim naako, ‘Naan kari lamaskana vaal,’ tuaa naagu inaxam paazaai wana dorang kanaan. ");
INSERT INTO nal_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Avuna auli watang sin Naata Rapti, xana malasing a wilak kat pilwilak la non a iaas kai laak pana ma aubina dina rataamin la non a iaas kai si wana. ");
INSERT INTO nal_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A non ina a maat ka itate wana, la non angkanaan amun kor dina wat fatu wana.” ");
INSERT INTO nal_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Iesu xa piaat kaarik naako, “Fazaaus mase lamuraana amun maravanang ilamun taan angkanaan, ‘a iaas kana suk, ma a flan kana wen ilap, amun patpada dina zu wat paanaburut, ma amun saan faakdul nana mof kana valvaaliang.’ ");
INSERT INTO nal_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","La notaan angkanaan, a vaakilanang sin Naata Rapti xana balas la ambara ma aubina ilamun linga bina vaakdul la pira angkari dina raamin Naata Rapti xana wat pana ambara i nana mof, faraxai wana a dikdikang ma adi wilaakna. Ma naandi dina raangis maskalus. ");
INSERT INTO nal_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma a raavuru xana raangis lapuk mase, ma naan kana kling amun aangelo zina ma dina zaxot fatu aubina vaakdul ina naa ra kalin fanong adu naandi aaxana vaatak. Amun aangelo dina zaxot fatu naandi lamun non faakdul wana amun marana maaliu urulavaat ila pira angkari ma lamun non faakdul i nana mof.” ");
INSERT INTO nal_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ma Iesu xa piaat kaarik naako, “Naaguna zuruk a varaviraaiang pana a iaai a fik. Araan amun baurivi di balas ma di rasin amun paxana naandi, naagu rexaas adu araan a maariaas ka vaasilik ka. ");
INSERT INTO nal_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Malasing saait bani, araan naagu raamin amun saan faakdul angkari xa balas faanong, naagu rexaas adu a raan sina xa vaasilik ka, lamarana mara. ");
INSERT INTO nal_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ga vazei varatunaan nim, a watkul angkari xana wen maat nanga xa ruaas amun saan faakdul angkari xana balas. ");
INSERT INTO nal_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A lia ma a pira angkari xana milung, singsaxai a dorang surugu xana wen milung.” ");
INSERT INTO nal_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ma Iesu xa piaat kaarik naako, “Kawit taxazak na rexaas pana a raan angkanaan o a aaua angkanaan kana balas, amun aangelo ila lia zaait kawit di rexaas, ma Naatna zaait kawit na rexaas, singsaxai Damana zingbe, xa rexaas. ");
INSERT INTO nal_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ka malasing bani lamaskana amun taan sin Noaa, malasing saait bani la raan Naata Rapti xana balas. ");
INSERT INTO nal_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lamaskana amun taan paamua wana adi ulim, aubina di vavangan ma di imimin ma dit maxus, ma ubina di lis amun nativa naandi zin azanon kuna maxuzang, ka ruaas la raan Noaa xa albis lamaskana a sip sina. ");
INSERT INTO nal_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aubina xawit di rexaas aze razaan kana balas ka ruaas adi ulim ka balas ma xa vazaak pizin fakdul naandi. Kana balas malasing kanaan la raan Naata Rapti xana balas. ");
INSERT INTO nal_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","La notaan angkanaan uru rapti dina vaamuzas iaa la uma, azaxai dina zaxot pizin naan, ma axazak dina luaa naan. ");
INSERT INTO nal_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Uru ravin dinat maios iaa amun wit kuna flaaua, azaxai dina zaxot pizin ma axazak dina luaa naan. ");
INSERT INTO nal_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Malasing ma naaguna naknakaai, wanaze xawit naagu rexaas aze ra raan a Piran sinim kana balas. ");
INSERT INTO nal_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Singsaxai naaguna maravas pana azaan angkari, tamon damana vaal xa ra lek texaas aze ra raan labung a vinaau xana wat, naan ka lek izi naknakaai, ma xana wen luaa a vinaau angkanaan kana taar a vaal ma xana albis lamaskana. ");
INSERT INTO nal_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Malasing ma nim saait naaguna nimniman, panaze Naata Rapti xana wat pana a raan nim kawit naagu naxaam naan kana wat.” ");
INSERT INTO nal_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ma Iesu xa piaat kaarik naako, “Nis a iaana kilaaiang kat falos a dorang sina ma xa mazam? A mono xai kalin awat iaana kilaaiang kari xuna xana xatkatong amun iaana kilaaiang sina xuna xana talazin a vanganang sin naandi la raan iwana zurukang a vanganang. ");
INSERT INTO nal_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kana daxa wana a iaana kilaaiang kanaan araan a mono zina xa uli wat ma xa tangin naan kai giu vatfaraxazin a vaamuzazang sina. ");
INSERT INTO nal_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ga vazei varatunaan nim, a mono xana kalin naan kana xatkatong amun lulugaan faakdul zina. ");
INSERT INTO nal_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Singsaxai tamon naan a iaana kilaaiang taksaat, ma xa naxaam la inaxamang sina nanga naako, ‘A mono zurugu xana wen puli wat fazaaus,’ ");
INSERT INTO nal_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma xana ramaraat ma xana zop amun paliaana, amun iaana kilaaiang, ma xa wa vavangan ma xa imimin faraxai wana ubina di imimin. ");
INSERT INTO nal_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ma a mono zina xana wat balas la raan naan kawit na naxaam adu a mono xana wat balas pana. ");
INSERT INTO nal_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A mono xana ftuk famimidi naan ma xana rasin naan faraxai wana aubina ina xawit dit falos a dorang sin naandi, inaan la non iwana rataangizang ma xaraatang alva.” ");
INSERT INTO nal_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesu xa piaat kaarik naako, “La raan angkanaan a bikabar ila lia xana malasing a fingaaiang pana amun takfaaxur xa zangaaflu ina di zuruk amun laam sin naandi ma di waan kuna ruzuaaiang a rapti xana maxus. ");
INSERT INTO nal_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Naandi xa watmit di rabanat ma xa watmit di rauxin a mazamang daxa. ");
INSERT INTO nal_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Naandi di rabanat di zuruk amun laam sin naandi singsaxai xawit di zuruk ta mis wel varaxai zaait pana. ");
INSERT INTO nal_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Naandi di rauxin a mazamang daxa di suruk wel varaxai zaait. ");
INSERT INTO nal_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A rapti ina xana maxus, kawit na wat fazaaus, malasing ma a marana amun takfaaxur angkanaan ka zangaaflu, xa maravan ma di wa milaaif. ");
INSERT INTO nal_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","La xuxuna suk di langarin a ling a xazak ka viraai malasing kari, ‘A rapti xana maxus kari xa balas! Naagu wat ma naagu ruzuaai naan.’ ");
INSERT INTO nal_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ma amun takfaaxur angkanaan di ravaangun ma di nimnimanin amun laam sin naandi. ");
INSERT INTO nal_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma naandi di rabanat di piaat sin naandi di rauxin a mazamang daxa malasing kari, ‘Naagu ralaas maam pana tazanon wel zinim panaze amun laam simaam dina samura maat.’ ");
INSERT INTO nal_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Singsaxai naandi di rauxin a mazamang daxa, di xis naandi malasing kari, ‘Kawit. A wel angkari xawit nat faraxas pana dia vaakdul. Naaguna waan la non dit faangurin a wel wana ma naaguna wul a wel aaxanim faatak.’ ");
INSERT INTO nal_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Singsaxai araan naandi angkanaan ka watmit di rabanat di waan faanong kuna wulang a wel, a rapti xana maxus ka balas. Naandi ina di nimniman, di albis lamaskana vaal varaxai wana naan kuna vanganang pana a flangan iwana vaamaxuzang. Ma xa baraat a mara. ");
INSERT INTO nal_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mur naandi di watmit di rabanat di balas ma di viraai malasing kari, ‘Piran, piran! Kaas a mara wana maam!’ ");
INSERT INTO nal_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Singsaxai naan ka xis naandi naako, ‘Ga vazei varatunaan nim, ga wetexaazin nim.’ ");
INSERT INTO nal_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Malasing ma nim saait naaguna izit nimniman, panaze xawit naagu rexaazin a raan o a aaua a Piran sinim kana balas.” ");
INSERT INTO nal_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iesu xa piaat kaarik naako, “A bikabar ila lia xana malasing aza rapti xa nimniman kuna waanang pana a zangazang baraaf. Naan ka viring fawat amun iaana kilaaiang sina ma xa lis amun lulugaan sina zin naandi xuna naadina xatkatong. ");
INSERT INTO nal_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka vatawaraxin a kaakaai lalozang a mazamang sin naandi zaksaxai. Ka lis a taalen kaakaai xa watmit sin azaxai, ma a taalen kaakaai urua zin axazak, ma a taalen kaakaai azaxai zin axazak. Ma mur naan ka waan pana zangazang sina. ");
INSERT INTO nal_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Fazaaus mase axazak angkaina xa ra zuruk a kaakaai xa watmit, ka waan ma xa vaamuzas pana ma xa vabalos aza watmit. ");
INSERT INTO nal_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma xa malasing saait pana axazak ina xa zuruk a kaakaai urua. Fazaaus mase naan ka wa vaamuzas pana ma xa vabalos aza urua xaarik. ");
INSERT INTO nal_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Singsaxai axazak angkaina xa ra zuruk a kaakaai azaxai, xa wa xaaf a luk lamaskana pira ma xa vun a kaakaai zin a mono zina. ");
INSERT INTO nal_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Lamuraana a notaan baraaf, a mono zin nandiaal xa uli wat ma xa saxot kana waafatok a dorang faraxai wana nandiaal wana a kaakaai zina. ");
INSERT INTO nal_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Axazak ina xa ra zuruk a taalen kaakaai xa watmit, ka wat sin a mono zina varaxai wana aza watmit kaarik, ma xa vazei naan naako, ‘Dipiran, gu ra lis a taalen kaakaai xa watmit ma ga vaamuzas pana. Taamin aza watmit kari ga vabalos.’ ");
INSERT INTO nal_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ma a mono zina xa xis naan naako, ‘Ka daxa marazaat mase. Nua a iaana kilaaiang daxa. Gut falos a dorang sunum. Gu ra xatkatong fatalamin a kaana zaan mumut. Malasing ma ga saxot gana rasin nua a waamua xuna guna xatkatong amun saan ka varas. Laawus ma dina nanam faraxai iaa.’ ");
INSERT INTO nal_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ma naan ina xa ra zuruk a taalen kaakaai urua xa wat sin a mono zina ma xa vazei naan naako, ‘Dipiran, gu ra lis a taalen kaakaai urua. Taamin, aza urua xari ga vabalos.’ ");
INSERT INTO nal_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ma a mono zina xa xis naan naako, ‘Ka daxa marazaat mase. Nua a iaana kilaaiang daxa. Gut falos a dorang sunum. Gu ra xatkatong fatalamin a kaana zaan mumut. Malasing ma ga saxot gana rasin nua a waamua xuna guna xatkatong amun saan ka varas. Laawus ma dina nanam faraxai iaa.’ ");
INSERT INTO nal_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mur naan ina xa ra zuruk a taalen kaakaai azaxai xa wat sin a mono zina ma xa vazei naan naako, ‘Dipiran, ga rexaas adu nua a rapti xawit taxazak kat faraxas kana plaas a waarum. Gut laflaaf a vanganang lamun uma azanon tawarak di ra vazu ma gui iot turin amun fnuaai lamun non ina azanon tawarak di ra xalawirin amun kala wana. ");
INSERT INTO nal_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Malasing ma ga maraaut ma ga wa vun a kaakaai zunum lamaskana a pira. Taamin, naan a kaakaai zunum kari.’ ");
INSERT INTO nal_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ma a mono zina xa xis naan naako, ‘Nua a iaana kilaaiang taksaat. Gut malumbaai. Gu piaat adu gu rexaas nia gat laflaaf lamun uma azanon tawarak di ra vazu ma gai iot turin amun fnuaai lamun non ina azanon tawarak di ra xalawirin amun kala wana. ");
INSERT INTO nal_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tamon malasing kanaan, gu lek sivaar a kaakaai zurugu lamaskana adi vaal a kaakaai xuna araan gana uli wat, ga lek suruk faulin faraxai wana azanon kaakaai xaarik laaxur wana.’ ");
INSERT INTO nal_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ma a mono xa vazei amun iaana kilaaiang sina naako, ‘Naagu zuruk a kaakaai ziaana ma naagu lis sin axazak angkaina xa rauxin ka zangaaflu. ");
INSERT INTO nal_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Avuna aubina vaakdul ina di rauxin fanong, dina lis azanon kaarik sin naandi, xuna naandi dina rauxin kana bas pakluaai. Singsaxai axazak ina xawit na rauxin, naapalaau xa rauxin be xawit faras, dina zuruk pizin siaana. ");
INSERT INTO nal_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma a iaana kilaaiang taksaat angkanaan, naagu psin fatukbilok naan ku lamanar la bungsuzuk. La non angkanaan dina rataangis ma dinat karaat alvana naandi.’ ” ");
INSERT INTO nal_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iesu xa piaat kaarik naako, “Araan Naata Rapti xana uli wat faraxai wana adi marmari daxaiang sina ma varaxai wana amun aangelo vaakdul, naan kana iziar la kin izi xalxaalang sina lamaskana adi marmari daxaiang. ");
INSERT INTO nal_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Amun lemlem aubina vaakdul dina balas fatu lamarana ma xana vatawaraxin aubina wana a lemlem urua malasing a rapti xa rataamaai xaaul wana amun sipsip, kai iot parok amun sipsip siaana amun meme. ");
INSERT INTO nal_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Naan kana rasin amun sipsip la mit sazaxa zina ma amun meme la mit kais sina. ");
INSERT INTO nal_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ma a Xalxaal xana vazei naandi angkanaan la mit sazaxa zina naako, ‘Naagu wat, nim aubina ina a daxaiang sin Maagu xa iziar wana nim. Naaguna raumana a xalxalang ina Nakmai xa ra xalxal wana aaxa nim, naan a bikabar ina Nakmai xa ra nimnimanin tasin aaxa nim mumua pis araan naan ka ra vaziaar a pira angkari. ");
INSERT INTO nal_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Avuna ga ra lagaai ma naagu ralaas nia wana vanganang, ga ra maaru ma naagu vaimin nia wana daanim, ga ropuran, ma naagu zaxot nia xu lamaskana amun faal zinim. ");
INSERT INTO nal_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kawit ga rauxin a marapi ma naagu vamamaus nia, ga ra gias ma naagu ra xatkatong nia, ga ra iziar lamaskana vaal a vaamaazikang, ma naagu wa rutaamin nia.’ ");
INSERT INTO nal_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ma aubina la mit sazaxa, naandi aubina di tak, dina xis naan malasing kari, ‘Piran, lasang maadi raamin nua gu ra lagaai ma maadi ralaas nua wana vanganang, o gu ra maaru ma maadi vaimin nua wana daanim? ");
INSERT INTO nal_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma lasang gu ropuran ma maadi ra zaxot nua xu lamaskana amun faal zimaam, o araan a waan marapi zunum ka xabaar ma maadi vamamaus nua? ");
INSERT INTO nal_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aze ra raan maadi raamin nua gu ra gias, o gu ra iziar la vaal a vaamaazikang ma maadi wa rutaamin nua?’ ");
INSERT INTO nal_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ma a Xalxaal xana xis naandi malasing kari, ‘Ga vazei varatunaan nim, aze razaan naagu ra giu wana azaxai zin amun taatum surugu ina xawit di rauxin aiza laba, naagu giu wana nia.’ ");
INSERT INTO nal_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ma xana piaat sin naandi la mit kais sina malasing kari, ‘Nim aubina a raksaatang sin Nakmai xa iziar wana nim, naagu waan siaagu, naagu waan lamaskana axaiaf kawit akin faanongang iwana, ina Nakmai xa ra nimnimanin tasin aaxan Saatan ma amun aangelo zina. ");
INSERT INTO nal_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Avuna ga ra lagaai ma xawit naagu ralaas nia wana tazaan kuna gana iaan, ma ga ra maaru ma xawit naagu vaimin nia wana daanim. ");
INSERT INTO nal_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma ga ropuran ma xawit naagu ra zaxot nia xu la vaal zinim. Ma xawit ga rauxin a marapi ma xawit naagu ra vamamaus nia. Ma ga ra gias ma ga ra iziar la vaal a vaamaazikang ma xawit naagu xatkatong nia.’ ");
INSERT INTO nal_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ma naandi zaait dina xis naan malasing kari, ‘Piran, aze ra raan maadi raamin nua gu ra lagaai o gu ra maaru o gu ropuran o a waan marapi zunum ka xabaar o gu ra gias o gu ra iziar la vaal a vaamaazikang, ma xawit maadi vawaal nua?’ ");
INSERT INTO nal_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma xana xis naandi malasing kari, ‘Ga vazei varatunaan nim, aze razaan kawit naagu giu aaxan amun taatum surugu ina xawit di rauxin aiza laba, xawit naagu giu wana nia.’ ");
INSERT INTO nal_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ma naandi angkanaan dina waan lamaskana a vaamaazikang ina xawit akin faanongang iwana, singsaxai naandi di tak dina rauxin a roro tapal.” ");
INSERT INTO nal_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Araan Iesu xa piaat fanong amun saan faakdul angkanaan, ka vazei ubina varaviraai zina naako, ");
INSERT INTO nal_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Naagu rexaas adu a raan urua nanga xa iziar ma mur A Raan Laba Iwana Zangas Fasaalang kana balas. Ma dina lis Naata Rapti la mit amun purua ma dina tukfating naan laaxur wana robuxul.” ");
INSERT INTO nal_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","La notaan angkanaan amun pris laba ma amun paamua zin amun Judaa di wat fatu la adi vaal zin a waamua zin amun pris faakdul aizina xanaan Kaaiapaas. ");
INSERT INTO nal_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Di pis a dorang kuna dina zaraak funfunin Iesu ma dina zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma di piaat malasing kari, “Tuaa dina giu la raan laba iwana Zangas Fasaalang, taulaan kana rauxin a varamangatang ma varopang lawalau aubina.” ");
INSERT INTO nal_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu xa iziar la bina Betani, la vaal zin aza rapti aizina xanaan Saaimon ina waamua xa ra rauxin a giazang di vakilaan a tapak. ");
INSERT INTO nal_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Araan Iesu xa vavangan nanga, aza ravin ka wat sina, xa vazaak a win di giu wana waraxa ma xa marmari daxa mase, xa rauxin a daanim milalas mikuf lamaskana. A daanim angkanaan a maraana xa laaup marazaat. Ma naa vukin la waata Iesu araan ka iziar la iban favanganang. ");
INSERT INTO nal_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Singsaxai araan ubina varaviraai di raamin naan ka ra giu azaan angkanaan, di mangat ma di piaat malasing kari, “Kunaze xa kawin palau a daanim milalas mikuf? ");
INSERT INTO nal_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Di lek faangurin ma dina zuruk a wulwulang iwana ma dina lis sin aubina di izi gogof.” ");
INSERT INTO nal_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Singsaxai Iesu xa rexaazin fanong aze naadi ipiaat, malasing ma xa vazei naandi malasing kari, “Kunaze naagui dador varvaras pana a ravin angkari? Naan ka giu azaan daxa wana nia. ");
INSERT INTO nal_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aubina di izi gogof dina iziar bulaai varaxai wana nim, singsaxai nia, gana wen iziar bulaai varaxai wana nim. ");
INSERT INTO nal_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Naan ka vukin a daanim milalas mikuf pana nia xuna nimnimaninang a winpinugu xula raan a kaavaaiang. ");
INSERT INTO nal_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ga vazei varatunaan nim, lamun non faakdul la pira angkari, araan aubina di ifazei wana a Dorang Daxa angkari, azaan naa ra giu naadina ipiaat saait, kuna aubina dinat naxaam naan.” ");
INSERT INTO nal_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ma Judaas Iskaariot, azaxai zin azangaaflu ma urua ubina varaviraai zin Iesu, xa waan sin amun pris laba ");
INSERT INTO nal_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ma xa iaari zin naandi naako, “Tamon gana lis Iesu la mita nim, naaguna lis aze zurugu?” Ma naandi di vakot a kaakaai xat faraxas pana azangaaflu urul amun siliwa aaxana. ");
INSERT INTO nal_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","La notaan angkanaan ma xa uzaa, Judaas ka zimbong a notaan mase xat faraxas pana naan kuna xana lis Iesu la mita naandi. ");
INSERT INTO nal_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","La varumaraiang amun taan iwana A Raan Laba Iwana A Raraba Xawit A Is, ubina varaviraai di wat sin Iesu ma di iaari zina malasing kari, “Aze ra non gu saxot maadina wa nimnimanin a vanganang kuna guna iaan faraxai wana maam la Raan Laba Iwana Zangas Fasaalang?” ");
INSERT INTO nal_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma xa xis naandi naako, “Naaguna albis Jerusalem ma naaguna vasuin aza rapti ma naaguna vazei naan malasing kari, ‘A Maravas ka piaat, a raan surugu xa vaasilik faanong. Nia varaxai wana ubina varaviraai zurugu maadina vangan pana A Raan Laba Iwana Zangas Fasaalang la vaal zunum.’ ” ");
INSERT INTO nal_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ma ubina varaviraai di giu malasing Iesu xa ra vazei naandi, ma di nimnimanin a vanganang kuna A Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lamuraana a iaas ka si, Iesu xa izi vavangan la iban favanganang faraxai wana azangaaflu ma urua ubina varaviraai zina. ");
INSERT INTO nal_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Araan di vavangan, ka vazei naandi malasing kari, “Ga vazei varatunaan nim, azaxai zinim nanga xana ngutlis nia zin amun purua.” ");
INSERT INTO nal_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Di langarin a dorang kari ma a maskana naandi xa maravan. Ma naandi zaksaxai di iaari zina malasing kari, “Piran, kawit nia, aan?” ");
INSERT INTO nal_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma Iesu xa vazei naandi naako, “A xazak ina xa rasin a mitna lamaskana a win favanganang faraxai wana nia, naan bani xana ngutlis nia. ");
INSERT INTO nal_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Naata Rapti xana maat malasing be di ra varaar vating lamaskana a Baar Xoxok. Singsaxai xana raksaat mase wana a rapti ina xa ngutlis Naata Rapti zin amun purua. Ka lek daxa mase tamon a rapti angkanaan kawit di ra luk naan.” ");
INSERT INTO nal_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ma Judaas ina xana ngutlis Iesu zin amun purua, xa iaari malasing kari, “Maravas, kawit nia, aan?” Ma Iesu xa xis naan naako, “Faaratunaan, nua bani.” ");
INSERT INTO nal_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Araan di vavangan, Iesu xa zuruk a raraba ma xa wisfaadaxa zin Nakmai ma xa biaak ma xa ralaas ubina varaviraai zina wana. Ma naan ka vazei naandi naako, “Naagu zuruk ma naagu iaan, naari a winugu.” ");
INSERT INTO nal_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma xa zuruk a win imiminang, a waain lamaskana, ma xa wisfaadaxa zin Nakmai ma xa ralaas naandi wana, ma xa piaat naako, “Nim faakdul naagu imin. ");
INSERT INTO nal_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Naari a dari zurugu xuna pizang a rudaxaiang. Ka zaal zaxot aubina xa varas kuna naxaam pizinang amun matmalabuk taksaat sin naandi. ");
INSERT INTO nal_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ga vazei nim, gana wen imin kaarik a waain angkari xa ruaas a raan gana imin favaxur a waain faraxai wana nim lamaskana bikabar zin Maagu.” ");
INSERT INTO nal_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Araan di rangon fanong a ranganang, di luaa a vaal angkanaan ma di waan kula Waatawut Olif. ");
INSERT INTO nal_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma Iesu xa vazei naandi naako, “Azaan kana balas pana nia taning labung, ma xana kawin ainaxamang sinim ma naaguna valaau vataling nia malasing di ra varaar vating lamaskana a Baar Xoxok, ‘Gana zop famaat a rapti xa rataamaai xaaul wana amun sipsip ma amun sipsip dina valaau varawuk.’ ");
INSERT INTO nal_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Singsaxai lamuraana gana ramaraat puli ziaana maatang, gana waamuin nim kun Gaalili.” ");
INSERT INTO nal_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma Pita xa xis naan naako, “Iaak naandi aubina vaakdul angkari dina raamin azaan kana balas pana nua ma xana kawin ainaxamang sin naandi ma dina valaau vataling nua, singsaxai nia mase xawit.” ");
INSERT INTO nal_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu xa xis naan naako, “Ga vazei varatunaan nua, taning mase labung, paamua wana a uraa xana kaakaluk, guna wispuxin nia faarul.” ");
INSERT INTO nal_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Singsaxai Pita xa vazei naan naako, “Naapalaau tamon gana maat faraxai wana nua, gana wen pispuxin nua. Kawit mase.” Ma ubina varaviraai vaakdul di piaat saait malasing bani. ");
INSERT INTO nal_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ma Iesu varaxai wana ubina varaviraai zina di waan pana aza non di vakilaan Getsemani. Ma xa vazei naandi naako, “Naagu iziar iriat ma nia gana waan ma gana wa maainung.” ");
INSERT INTO nal_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Naan ka zaxot Pita ma uru naata Zebedi varaxai wana naan. A maskana xa maravan marazaat ma a xazanaaiang sina xa raksaat mase. ");
INSERT INTO nal_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma naan ka vazei nandiaal naako, “A maskaagu xa maravan marazaat, ma ga xazanin malasing adu gana maat. Naagu iziar raal iriat ma naagu rataamaai xaaul raal varaxai wana nia.” ");
INSERT INTO nal_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Naan ka zangas paan lawalaau vaamumut ma xa psin fawizik naan paanaburut la pira ma xa maainung naako, “Maagu, tamon kat faraxas, suruk pizin a win imiminang kari ziaagu. Singsaxai guna wen los a sasaxotang surugu, xawit. Guna los be a sasaxotang sunum.” ");
INSERT INTO nal_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ma Iesu xa uli wat sin nandiaal ubina varaviraai zina ma xa tangin nandiaal di imilaaif taal. Ma xa iaari zin Pita naako, “Malasing faa, xawit nat faraxas naaguna rataamaai xaaul varaxai wana nia wana a aaua azaxai? ");
INSERT INTO nal_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Naaguna raamaai xaaul raal ma naaguna maainung taal xuna naaguna wen su raal lamaskana amun faaxabebeuang. A maskana dia xa saxot kana giu azaan, singsaxai a winpin kawit na rauxin a dikdikang kuna giu vabalozang azaan angkanaan.” ");
INSERT INTO nal_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ma faarua xaarik Iesu xa wa maainung, ma xa piaat naako, “Maagu, tamon kawit nat faraxas a win imiminang kari xana vasaal nia ma gana imin, ka daxa gu los be a sasaxotang sunum.” ");
INSERT INTO nal_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Araan ka uli wat sin nandiaal, xa tangin kaarik nandiaal di imilaaif taal, wanaze a marana nandiaal xa maravan marazaat. ");
INSERT INTO nal_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka luaa xaarik nandiaal ma xa varul xaarik a waanang ma xa wa maainung, ma xa piaat amun dorang bani ina naa ra tabung piaat pana maainungang paamua. ");
INSERT INTO nal_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Naanaan ka uli wat kaarik sin ubina varaviraai zina ma xa piaat sin naandi naako, “Malasing faa, naagu imilaaif iaavus nanga? Kat faraxas ka! Naagu langar, a notaan ka balas faanong kuna dina ngutlis Naata Rapti zin aubina raksaat. ");
INSERT INTO nal_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Naagu ramaraat ma di waan! Naagu raamin, a rapti xana ngutlis nia xari xa balas faanong.” ");
INSERT INTO nal_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Araan naan kai dador nanga, Judaas, azaxai zin azangaaflu ma urua ubina varaviraai, xa wat balas. Adi mala ubina di wat faraxai wana naan, di roting amun baainaat ma amun iaai iwana varopang. Amun pris laba ma amun paamua zin aubina di ra kling fawat naandi. ");
INSERT INTO nal_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A rapti angkanaan ina xana ngutlis Iesu zin naandi, xa tabung fazei rasin naandi wana aza vaakilanang kuna naandi dina raamin fakilaan Iesu. Naan ka vazei naandi naako, “Axazak angkanaan gana ngus, naan a rapti angkanaan, naaguna zaraak fating naan.” ");
INSERT INTO nal_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Fazaaus mase Judaas ka wat sin Iesu ma xa vazei naan naako, “Maravas, labung ka!” Ma xa ngus naan. ");
INSERT INTO nal_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Iesu xa vazei naan naako, “Paluaak, aze gu wat kuna giuang, giu xabe.” Naanaan ubina di wat ma di zaraak fating Iesu. ");
INSERT INTO nal_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aza waliaana Iesu xa urif luk a baainaat sina ma xa kip pizin alngana a iaana kilaaiang sin a waamua zin amun pris. ");
INSERT INTO nal_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Singsaxai Iesu xa vazei naan naako, “Tasin faulin a baainaat sunum lamaskana wakpaakna, wanaze aubina vaakdul ina di urif luk a baainaat, dina maat saait malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Malasing faa, gu naxaam adu xa lagaf pana nia xuna gana maainung Maagu xuna naambari nanga, naan kana kling fawat amun aangelo, a vaakatang sin naandi xa laaup pana a taausan ka zangaaflu vaawizik urua ma urua, ma dina varop ku nia? ");
INSERT INTO nal_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Singsaxai tamon gana giu malasing kanaan, a dorang lamaskana Baar Xoxok kana wen balas faaratunaan. A matmalabuk angkari naagu raamin, a Baar Xoxok ka dador wana adu xana balas malasing kari wana nia.” ");
INSERT INTO nal_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","La notaan angkanaan, Iesu xa vazei adi mala aubina naako, “Malasing faa, nia axazak kat farop ma xat finaau malasing ma naagu wat pana amun baainaat ma amun iaai iwana varopang kuna naaguna zaraak nia? Amun taan faakdul nia ga iziar varaxai wana aubina la rabaraau ila vaal xoxok ma gat firaai naandi ma xawit naagu zaraak nia. ");
INSERT INTO nal_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amun saan faakdul angkanaan ka balas malasing kanaan kuna a dorang lamaskana amun baar zin amun profet kana balas faaratunaan.” Ma ubina varaviraai vaakdul zina di vataling Iesu ma di valaau varawuk siaana. ");
INSERT INTO nal_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma ubina ina di ra zaraak Iesu di zaxot naan ka waan la vaal zin Kaaiapaas, naan a waamua zin amun pris faakdul. Ma amun maravas iwana amun Lus sin Moses faraxai wana amun paamua di iziar vaanong inaan. ");
INSERT INTO nal_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita xai las lawalaau nanga xu lamaskana rabaraau ila vaal zin a waamua zin amun pris faakdul. Naan ka albis lamaskana rabaraau ila vaal angkanaan, ma xa iziar varaxai wana ubina di ruxaaul, xuna naan kana raamin aze xana balas pana Iesu. ");
INSERT INTO nal_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Amun pris laba varaxai wana ubina vaakdul iwana Aiziarang Iwana Aikilizang Sin Amun Judaa, di zaleng ta dorang faagit kuna vakorang Iesu, xuna dina zop famaat naan, ");
INSERT INTO nal_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","singsaxai naandi xawit di tangin, naapalaau aubina xa varas di balas faraxai wana amun faagitang sin naandi. Lamuraana aza ru rapti di balas iaa, ");
INSERT INTO nal_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ma di piaat iaa malasing kari, “A rapti angkari xa ra piaat naako, ‘Nia gat faraxas gana bara psin a vaal xoxok sin Nakmai, ma gana varur vaulin lamuraana a raan urul.’ ” ");
INSERT INTO nal_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A waamua zina amun pris faakdul xa rur ma xa piaat sin Iesu malasing kari, “Malasing faa, xawit gu saxot guna xis a dorang kanaan naadi vakor nua wana?” ");
INSERT INTO nal_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Singsaxai Iesu xawit na dador. Ma a waamua zin amun pris faakdul xa piaat sina naako, “Ga maainung nua wana aizina Nakmai xa roro, guna piaat faratunaan. Fazei maam tamon nua a Mesaaia, Naata Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma Iesu xa xis naan malasing kari, “Aiang, malasing bani gu piaat. Singsaxai ga vazei nim faakdul, lamur naaguna raamin Naata Rapti xana iziar la mit sazaxa zin Nakmai a Maradikdikang ma xana wat pana ambara i nana mof.” ");
INSERT INTO nal_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A waamua zin amun pris faakdul xa langarin Iesu xa piaat malasing kanaan ma xa taar a marapi zina ma xa piaat naako, “A rapti angkari xa lingpuak lawaana Nakmai! Kunaze xaarik dia di saxot tazanon aubina xuna wat dadorang. Naagu langarin fanong amun lingpuakang sina lawaana Nakmai. ");
INSERT INTO nal_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Naagu naxaam malasing faa?” Ma di xis naan malasing kari, “Naan kat faraxas kana maat.” ");
INSERT INTO nal_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Naanaan di kanis naan lamarana ma di tuk naan pana mita naandi. Azanon di rabaaf naan, ");
INSERT INTO nal_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma di piaat malasing kari, “Mesaaia, gu dador profet simaam, adu nis kari xa rabaaf nua?” ");
INSERT INTO nal_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita xa iziar inaan lamaskana a rabaraau ila vaal laba ma aza rakfaaxur, a iaana kilaaiang ka wat sina ma naako, “Nua zaait gu ra iziar varaxai wana Iesu in Gaalili!” ");
INSERT INTO nal_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma xa wispuk lamarana naandi vaakdul naako, “Kawit ga rexaazin aze razaan gui piaat.” ");
INSERT INTO nal_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma xa waan lamarana mara iwana balavaat, ma aza rakfaaxur xaarik ka raamin naan ma xa vazei aubina ininaan naako, “A rapti angkari xa ra iziar varaxai wana Iesu in Naazaret.” ");
INSERT INTO nal_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma Pita xa xalxal wana a waata fafina ma xa wispuk kaarik naako, “Ga wetexaazin a rapti angkanaan!” ");
INSERT INTO nal_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lamur vaamumut, aubina ina di irur inaan di piaat malasing kari, “Faaratunaan nua bani azaxai zin naandi, avuna a lingum ka pitfiaat nua.” ");
INSERT INTO nal_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma Pita xa viring fawat amun taksaarang laaxur wana naan ma xa xalxal wana a waata fafina ma xa piaat malasing kari, “Ga wetexaazin a rapti angkanaan!” Ma fazaaus mase a uraa xa kaakaluk. ");
INSERT INTO nal_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Naanaan Pita xa naxaam faulin a dorang Iesu xa ra piaat naako, “Paamua wana a uraa xana kaakaluk, guna wispuxin nia faarul.” Ma xa tukbilak ma xa wa raangis taksaat mase. ");
INSERT INTO nal_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Paanaraan gufguf, amun pris laba vaakdul ma amun paamua vaakdul zin amun Judaa, di pis a dorang adu dina zop famaat Iesu. ");
INSERT INTO nal_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Di pis fating uru mitna ma di valos lis naan sin Paailat, a rapti in Rom ina Siza xa kalin naan ka waamua zin amun Judaa. ");
INSERT INTO nal_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judaas a rapti ina xa ra ngutlis Iesu zin amun purua, xa raamin adu di varur Iesu wana dorang ma di rasin a maravanang pana naan. Naanaan Judaas ka maskalus mase wana azaan naa ra giu ma xa zuruk a kaakaai angkanaan amun siliwa xa zangaaflu vaarul ma naa lis faulin sin amun pris laba ma amun paamua zin amun Judaa. ");
INSERT INTO nal_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ma xa piaat naako, “Ga ra ngutlis a rapti angkari zinim, singsaxai xawit na giu ta matmalabuk taksaat, ma naari naagu lis a vaamaazikang sina xuna maatang, malasing ma nia ga ra giu a matmalabuk taksaat.” Singsaxai di xis a dorang sina malasing kari, “Kawit azaan simaam. A maravanang sunum kanaan.” ");
INSERT INTO nal_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naanaan Judaas ka psin amun kaakaai lamaskana a rabaraau ila vaal xoxok ma xa waan fataling naandi ma xa wa xutmaat. ");
INSERT INTO nal_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Amun pris laba di iot amun kaakaai ma di piaat malasing kari, “A kaakaai angkari, di vaulang a dari malasing ma xawit na tak pana amun Lus sin Moses kuna dia dina rasin faraxin lamaskana kaakaai ila vaal xoxok.” ");
INSERT INTO nal_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Malasing ma di pis a dorang ma di wul a non pira zin a rapti xai giu a sopen pana pira. Di saxot adu a non pira angkanaan kuna xavinang amun maat sin amun topuran. ");
INSERT INTO nal_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Naan avuna xari, taning nanga dit fakilaan a non pira angkanaan adu, “A Non Pira Iwana Dari.” ");
INSERT INTO nal_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Malasing ma a dorang a profet Jeremaaia xa ra piaat ka balas faaratunaan pana Iesu naako, “Di zuruk a kaakaai, amun siliwa xa zangaaflu vaarul, a maraana wulwulang amun Israael di maraana naan pana. ");
INSERT INTO nal_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma a kaakaai angkanaan naadi wulang a non pira zin a rapti xai giu a sopen pana pira, malasing a Piran ka ra vazei nia.” ");
INSERT INTO nal_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma Iesu xa rur lamarana a waamua Paailat, ma naan ka iaari zin Iesu naako, “Nua a xalxaal zin amun Judaa aan?” Ma Iesu xa xis naan naako, “Aiang, nua nanga gu piaat fanong.” ");
INSERT INTO nal_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amun pris laba ma amun paamua di vakor naan pana amun dorang, singsaxai xawit na xis ta dorang. ");
INSERT INTO nal_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Paailat ka iaari zina naako, “Malasing faa, xawit gu langarin amun dorang faakdul naandi di vakor nua wana?” ");
INSERT INTO nal_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Singsaxai Iesu xawit na xis ta dorang sin naandi. Malasing ma Paailat ka banglala mase. ");
INSERT INTO nal_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lamun maariaas faakdul Paailat kat falos aza matmalabuk. La Raan Laba Iwana Zangas Fasaalang, naan kat familuaar psin a rapti azaxai ina xa iziar wana vaamaazikang ina aubina di kalin naan. ");
INSERT INTO nal_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","La notaan angkanaan aza rapti, aizina xanaan Iesu Baarabaas, naan ka rauxin aiza laba wana gigiuang amun matmalabuk taksaat mase ma xa iziar lamaskana a vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Araan adi mala aubina di wat balas fatu, Paailat ka iaari zin naandi naako, “Nis mase naagu saxot gana vamiluaar lis sinim, Baarabaas o Iesu ina di vakilaan adu a Mesaaia?” ");
INSERT INTO nal_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paailat ka rexaas adu amun paamua zin amun Judaa di marazuzuai wana Iesu ma naan a vuvuna xanaan di lis Iesu la mitna. ");
INSERT INTO nal_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Araan Paailat ka iziar wana akin ikilizang sina, taak sina xa iaalis dorang puat sina naako, “Tuaa gu giu tazaan pana a rapti angkanaan, kawit na giu ta matmalabuk taksaat. Avuna labung ga ra mirifdaai ma ga raamin naan, ma ga xazanin a maravanang laba.” ");
INSERT INTO nal_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Singsaxai amun pris laba ma amun paamua dit faxalxaal aubina xuna dina iaari zin Paailat kuna xana vamiluaar Baarabaas ma dina zop famaat Iesu. ");
INSERT INTO nal_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paailat ka iaari zin naandi naako, “Nis sin nandiaa naagu saxot gana vamiluaar lis sinim?” Ma di xis naan malasing kari, “Baarabaas!” ");
INSERT INTO nal_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma Paailat ka iaari zin naandi naako, “Gana uvin Iesu angkari dit fakilaan naan a Mesaaia?” Ma di laanga xis naan malasing kari, “Tukfating naan pana robuxul!” ");
INSERT INTO nal_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma Paailat ka iaari xaarik naako, “Kunaze? Naan ka giu aze rawat matmalabuk taksaat?” Singsaxai dit kupkup laba nanga malasing kari, “Tukfating naan pana robuxul!” ");
INSERT INTO nal_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Araan Paailat ka raamin adu aubina xawit di langor naan ma faasilik a varopang kana balas, ka zuruk amis daanim ma xa zuk uru mitna lamarana naandi ma xa piaat naako, “Nia ga mamaraxas tamon a rapti angkari xa maat. Azaan sinim ka.” ");
INSERT INTO nal_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma aubina vaakdul di xis naan malasing kari, “A maravanang kari xana iziar wana maam ma wana a funalik simaam saait.” ");
INSERT INTO nal_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Naanaan Paailat ka vamiluaar lis Baarabaas sin naandi. Singsaxai xa lis Iesu la mita ubina dauran kuna dina kmis naan ma dina tukfating naan pana robuxul. ");
INSERT INTO nal_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ubina dauran sin Paailat di zaxot Iesu xu lamaskana a vaal zin a waamua zin naandi ma naandi vaakdul ubina dauran di wat faraxulin naan. ");
INSERT INTO nal_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma di gamul psin amun marapi zina ma di vamamaus naan pana a marapi baraaf ka raubung. ");
INSERT INTO nal_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma di kos a iaarus koxot malasing a lawilot ma di rasin la waatna. Di rasin a laak malasing a rol la mit sazaxa zina ma di zibukaak lamarana ma di vis naan malasing kari, “A varanopang lamaraam, a xalxaal zin amun Judaa!” ");
INSERT INTO nal_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Di kanis naan ma di zuruk a laak la mitna ma di wit faavarazin naan la waatna. ");
INSERT INTO nal_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lamuraana di vis fanong naan, di gamul psin a marapi baraaf siaana ma di vavalaak kaarik naan pana a marapi zina nanga. Ma di zaxot psin fatukbilok naan la vaal laba angkanaan kuna dina wa tukfating naan pana robuxul. ");
INSERT INTO nal_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Araan ubina dauran di zazangas tukbilak, di tangin aza rapti in Saairini aizina xanaan Saaimon ma di vangarin naan ma xa vazaak a robuxul zin Iesu. ");
INSERT INTO nal_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Di wat balas la non di vakilaan Golgaata. Aknaaza waaling angkanaan adu, “A Non Iwana Barang.” ");
INSERT INTO nal_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Inaan di ralaas Iesu wana a waain di plaas faraxai wana a makara xa mawaak, singsaxai araan naa imin taamin, naa bain ka naana imin. ");
INSERT INTO nal_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Naanaan di tukfating fanong naan laaxur wana robuxul, ma di raktaaxin amun faat kuna dina vatawaraxin amun marapi zina lawalaua naandi nanga. ");
INSERT INTO nal_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ma mur di ziar waanaburut ma di rataamaai xaaul wana naan inaan. ");
INSERT INTO nal_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Laaxur la waata robuxul zina, di rasin a dorang ka pitfiaat a vuvuna maravanang sina. A dorang kanaan ka malasing kari, “Iesu xari, a xalxaal zin amun Judaa.” ");
INSERT INTO nal_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Di tukfating saait uru vinaau wana uru robuxul lapaara Iesu, azaxai la mit sazaxa zina ma axazak la mit kais sina. ");
INSERT INTO nal_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma aubina di zazangas bilaas a non angkanaan, di idador lingpuak lawaana ma dit favalingin amun paata naandi, ");
INSERT INTO nal_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ma di ipiaat malasing kari, “Gu piaat adu nua guna bara psin a vaal xoxok ma guna varur vaulin lamaskana a raan urul. Tamon nua Naata Nakmai, gu vawaal nua nanga ziaana maatang ma gu kabal wat paanaburut siaana robuxul.” ");
INSERT INTO nal_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma malasing saait bani wana amun pris laba varaxai wana amun maravas iwana amun Lus sin Moses ma amun paamua, naandi di visfis naan ");
INSERT INTO nal_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","malasing kari, “Naan ka varoro azanon tawarak siaana maatang, singsaxai xawit nat faraxas kana varoro naan nanga. Malasing faa, naan a Xalxaal in Israael? Kana kabal wat paanaburut pana robuxul ma dia dina raamin ma dina inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Naan ka inaxam paazaai wana Nakmai ma xa piaat naako, ‘Nia Naata Nakmai.’ Malasing ma naari dina raamin tamon Nakmai xa saxot naan, kana varoro naan.” ");
INSERT INTO nal_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma uru vinaau ina di rokaai iaa lapaarana, nandiaa zaait di dador lingpuak iaa wana naan. ");
INSERT INTO nal_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","La marana iaas ka zangaaflu vaazaxai ma urua lawaanaas, ma xa ruaas a marana iaas urul languzaraaf, a bungsuzuk ka pung paramin a non pira vaakdul ininaan. ");
INSERT INTO nal_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ka malasing adu a marana iaas urul languzaraaf, ma Iesu xa xupkup laba malasing kari, “Eli, Eli, lema saabaaktaani.” Aknaas u waan dorang kari adu, “Nakmai zurugu, Nakmai zurugu, xunaze gu luaa psin nia?” ");
INSERT INTO nal_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Azanon aubina ina di irur, di langarin ma di piaat malasing kari, “Naan kat firing Elaaija.” ");
INSERT INTO nal_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Fazaaus mase azaxai zin naandi xa valaau ma xa zuruk azaan malasing a lingmut, ma naa burung pana a waain mawaak. Ma naa pis fating la nguza vang tangtangaana iaai ma naa lis fauzaa zin Iesu xuna vaiminang naan. ");
INSERT INTO nal_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma naandi vaakdul ina di irur varaxai wana naan di piaat malasing kari, “Naagu luaa psin naan. Dina raamin kalaak tamon Elaaija xana balas faaratunaan kuna zaxot faulinang naan.” ");
INSERT INTO nal_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma Iesu xa xupkup laba xaarik, ma xa vamiluaar psin a laklagaaina ma xa maat. ");
INSERT INTO nal_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","La notaan angkanaan, adi marapi laba xa ratokaai lamaskana a vaal xoxok, ka ramatar laaxur ma xa wizik mase waanaburut ma xa balas uwaan marapi urua. A maraulia xa gis a pira ma amun faat di raabiak. ");
INSERT INTO nal_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma amun baaul a maat di ralakas, ma amala aubina xoxok sin Nakmai ina di ra maat faanong, di ramaraat puli. ");
INSERT INTO nal_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Di ramaraat fataling amun baaul a maat ma lamuraana Iesu xa ramaraat puli, naandi di waan la bina laba zin Nakmai ma di balas sin aubina xa varas. ");
INSERT INTO nal_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","A waamua zin a zangaaflu varazuai ubina dauran in Rom faraxai wana azanon ubina dauran ina di rataamaai xaaul wana Iesu, di raamin a maraulia ma amun saan faakdul ina xa ra balas ma di maraaut marazaat. Ma di piaat malasing kari, “Faaratunaan, naan Naata Nakmai!” ");
INSERT INTO nal_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A furavin ka varas di ra irur lawalaau vaamumut ma di rataamin a maatang sin Iesu. Naandi di ra ilos Iesu araan ka vataling Gaalili ma xa wat Jerusalem ma dit fawaal naan. ");
INSERT INTO nal_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ma a furavin angkari di irur lawalaua naandi, Maaria in Maakdaalaa, ma Maaria naanaa zin Jems ma Iosep, ma naanaa zin uru naata Zebedi. ");
INSERT INTO nal_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aza rapti raxumbaaxut in Aarimaatiaa, aizina Iosep, naan saait aza rapti varaviraai zin Iesu. Languzaraaf, naan ka wat balas. ");
INSERT INTO nal_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Naan ka wat sin Paailat ma xa iaari zina xuna xana vazaak luk Iesu. Ma Paailat ka rudaxa ma xa vazei ubina dauran ma di lis Iesu zina. ");
INSERT INTO nal_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosep ka vazaak luk naan kula aza non ma naa flus naan pana a marapi vaaxur, ");
INSERT INTO nal_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma naa vatate naan lamaskana baaul a maat faaxur ina naa ra xaaf lamaskana a vaat siar. A baaula maat angkanaan sin Iosep faatak. Ma Iosep ka wul xol a marana baaul a maat pana adi vaat ma xa waan. ");
INSERT INTO nal_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maaria in Maakdaalaa nandiaa aza Maaria di iziar iaa laza non rita baaul a maat ma di rataamaai iaa. ");
INSERT INTO nal_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A raan lamuraana, a raan a Saabat, amun pris laba ma amun Faarasi di waan sin Paailat. ");
INSERT INTO nal_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma di piaat sina malasing kari, “Dipiran, maadi naxaam faulin a dorang sin a rapti angkanaan iwana rategitang, araan nanga xa izi roro, xa piaat naako, ‘Lamuraana a raan urul, gana ramaraat puli.’ ");
INSERT INTO nal_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Malasing ma gu lis a dorang dikdik kuna dina raamin kol a baaul a maat pana a raan urul. Taulaan ubina varaviraai zina dina wat finau luk naan ma dina vazei aubina adu naan ka ramaraat puli vaanong siaana maatang. A vaagitang faaxur angkanaan kana raksaat mase wana vaagitang sina i waamua.” ");
INSERT INTO nal_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma Paailat ka xis naandi naako, “Naagu vazei amun tuxaaul ma dina raamin kol a baaul a maat. Naagu waan naagu giu aze ramun saan nanga xuna waakol valagotang a baaul a maat.” ");
INSERT INTO nal_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Malasing ma naandi di waan ma di waakol valagot a baaul a maat ma di bulut kol a vaat lamarana ma amun tuxaaul di izi rataamaai xaaul wana. ");
INSERT INTO nal_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","A raan lamuraana Saabat, la varumaraiang a raan iwana wik, paanaraan gufguf mase, Maaria in Maakdaalaa ma aza Maaria di wa raamin iaa a baaul a maat. ");
INSERT INTO nal_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Adi maraulia dikdik ka balas panaze a aangelo zin a Piran ka kabal wat la lia, ma xa wul psin a vaat lamarana a baaul a maat. Ma naan ka iziar laaxur wana adi vaat angkanaan. ");
INSERT INTO nal_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A rataamaaiang sina xa wilwilak malasing a wilak ma amun marapi zina xa xufkuf malasing a xuf. ");
INSERT INTO nal_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma amun tuxaaul ila baaul a maat di maraaut mase wana naan ma di dakdakur ma di malasing ubina di maat. ");
INSERT INTO nal_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma a aangelo xa vazei uru ravin naako, “Tuaa naagu maraaut iaa, ga rexaas naagu zazaleng iaa Iesu, ina di ra tukfating naan pana robuxul. ");
INSERT INTO nal_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Naan ka malik kari, xa ramaraat puli vaanong, malasing be naa ra piaat. Naagu wat iaa ma naagu raamin iaa a non ina naa ra imaal wana. ");
INSERT INTO nal_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naaguna uli vazaaus iaa ma naaguna vazei iaa ubina varaviraai zina malasing kari, ‘Iesu xa ramaraat puli vaanong siaana maatang. Ma naan ka waamuain nim kun Gaalili ma naaguna raamin naan inaan.’ Ga wat fazei vanong numaa.” ");
INSERT INTO nal_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Malasing ma uru ravin di ramaraat fataling iaa a baaul a maat ma di waan iaa. Naapalaau di maraaut iaa, di bas iaa wana dokdokang ma di valaau iaa be xuna wa vazeiang ubina varaviraai zina wana dorang kanaan. ");
INSERT INTO nal_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Fazaaus mase Iesu xa vasuin nandiaa ma xa waanaraan sin nandiaa. Di wat iaa zina ma di roting iaa uru xaakna ma di lotu iaa wana naan. ");
INSERT INTO nal_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Iesu xa vazei nandiaa naako, “Tuaa gu maraaut iaa. Naagu waan iaa ma naagu vazei iaa amun daazugu ma dina waan Gaalili ma dina raamin nia inaan.” ");
INSERT INTO nal_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Araan uru ravin angkanaan di zazangas iaa nanga la lan, azanon ubina dauran ina di ruxaaul la baaul a maat, di waan Jerusalem ma di vazei amun pris laba wana amun saan faakdul ina xa ra balas. ");
INSERT INTO nal_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma amun pris laba di balas fatu varaxai wana amun paamua zin amun Judaa, ma di balas pana ainaxamang azaxai. Ma di lis a kaakaai laba zin ubina dauran, ");
INSERT INTO nal_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ma di vazei naandi malasing kari, “Naaguna vazei aubina malasing kari, ‘Labung araan maadi milaaif, ubina varaviraai zina di wat finau luk naan.’ ");
INSERT INTO nal_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma tamon a waamua zin a gaapman kana langarin ma xana iaari, maadina dador xol nim ma naaguna wen iziar lamaskana maravanang kari.” ");
INSERT INTO nal_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ma ubina dauran di zuruk a kaakaai angkanaan, ma di los aze ra dorang amun pris laba ma amun paamua di ra vazei naandi wana. Ma a dorang kanaan ka waan farawuk lawalau amun Judaa ma xa ruaas taning. ");
INSERT INTO nal_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ma azangaaflu ma zaxai ubina varaviraai zina di waan Gaalili, la waatawut Iesu xa ra vazei naandi dina waan pana. ");
INSERT INTO nal_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ma araan di raamin naan, di lotu wana naan. Singsaxai azanon sin naandi di rauxin ainaxamang urua. ");
INSERT INTO nal_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu xa balas sin naandi ma xa vazei naandi naako, “Nakmai xa lis a burburaaiang faakdul zurugu la lia ma la pira angkari. ");
INSERT INTO nal_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Malasing ma naaguna waan sin aubina lamun non faakdul, ma naaguna viraai naandi xuna naandi zaait dina balas aubina varaviraai zurugu. Naaguna baaptaais naandi wana aizina Maagu ma wana aizina Naatna ma wana aizina a Laklagaai a Raabu. ");
INSERT INTO nal_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma naaguna viraai naandi xuna dina valos amun dorang faakdul zurugu ina ga ra vazei nim pana. Ma faaratunaan mase, nia gana iziar bulaai varaxai wana nim, ka ruaas pana vaanongang iwana notaan angkari.” ");
INSERT INTO nal_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Naari a varumaraiang a Dorang Daxa zin Iesu Kaarisito Naata Nakmai. ");
INSERT INTO nal_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ka ramaraat malasing be Aaisaaia a profet sin Nakmai xa varaar vating lamaskana a Baar Xoxok naako, “Nia gana kling a wangpaang surugu waamua wana nua, ma naan kana nimnimanin a lan sunum.” ");
INSERT INTO nal_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“A linga axazak ka viviraai la non bingil naako, ‘Naagu nimnimanin a lan sin a Piran, naagu waafatok amun lan aaxana xuna zangazang.’ ” ");
INSERT INTO nal_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Malasing ma Jon A Rapti Iwana Baaptaaizang ka balas la non bingil ma xai baaptaais aubina ma xa fazei zin naandi adu naandi dina inaxam taawuk siaana amun matmalabuk taksaat sin naandi ma dina baaptaais kuna vatanginang adu di inaxam taawuk faanong ma Nakmai xana naxaam pizin amun matmalabuk taksaat sin naandi. ");
INSERT INTO nal_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Amala aubina ilamun bina ila pira Judia ma Jerusalem di waan sin Jon kuna langarinang naan. Di pitfiaat amun matmalabuk taksaat sin naandi ma Jon ka baaptaais naandi la daanim Jodaan. ");
INSERT INTO nal_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon kat falaak a marapi di giu wana a vura kaamel, ma a let di giu wana a wina kaamel, naat lagot kolang a zuruna ma xai iaan a zixa ma a aani ilauran. ");
INSERT INTO nal_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma xa fazei malasing kari, “Axazak kana wat lamuraagu. A dikdikang sina xa laaup marazaat pana zurugu. Ma nia xawit a rapti daxa xuna xanat faraxas gana zundung ma gana akpaat a iaarus iwana a su zina wanaze naan ka laaup mase wana nia. ");
INSERT INTO nal_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nia gat baaptaais nim pana daanim, singsaxai naan kana baaptaais nim pana a Laklagaai a Raabu.” ");
INSERT INTO nal_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ma lamun taan angkanaan Iesu xa luaa a bina zina Naazaret, a bina laba ila pira Gaalili ma xa wat la daanim Jodaan ma inaan Jon ka baaptaais naan. ");
INSERT INTO nal_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Araan Iesu xai kasaai wat laaxur la daanim, ka raamin a lia xa ralakas ma a Laklagaai a Raabu xa malasing a baalus ka lif puat paanaburut ma xa iziar wana naan. ");
INSERT INTO nal_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma axazak ka dador wat laaxur la lia naako, “Nua Naarugu. Ga sasaxot nua ma ga nanam mase wana nua.” ");
INSERT INTO nal_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Fazaaus mase a Laklagaai a Raabu xa kling Iesu xu lamaskana a non bingil. ");
INSERT INTO nal_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Naan ka iziar inaan pana a raan ka zangaaflu vaaralavaat, ma Saatan ka vaxabebeu naan. Amun pungpung saait di iziar la non angkanaan, ma amun aangelo di rataamaai xaaul wana naan. ");
INSERT INTO nal_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lamuraana di zaraak Jon ma di rasin naan la vaal a vaamaazikang, Iesu xa waan la pira Gaalili, ma xa ifazei wana a Dorang Daxa zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Naan kai fazei malasing kari, “A bikabar zin Nakmai xa wat faasilik faanong. Naagu inaxam taawuk siaana amun matmalabuk taksaat sinim ma naagu inaxam paazaai wana a Dorang Daxa zin Nakmai!” ");
INSERT INTO nal_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Araan Iesu xa zazangas la rita laman Gaalili, naan ka raamin Saaimon ma daasna Endru di ipsin iaa aubina la laman. Nandiaa di isuruk kaakaai iaa wana ian. ");
INSERT INTO nal_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma Iesu xa piaat sin nandiaa naako, “Laawus iaa ma naagu los iaa nia ma gana viraai numaa wana a lan iwana kozang aubina malasing naagui kos a ian.” ");
INSERT INTO nal_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Fazaaus mase di luaa iaa aubina zin nandiaa ma di los iaa Iesu. ");
INSERT INTO nal_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iesu xa zangas paan faamumut kaarik ma xa raamin Jems ma daasna Jon, uru naata Zebedi. Di iziar iaa lamaskana a mon. Dit nimnimanin iaa amun aubina zin nandiaa. ");
INSERT INTO nal_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iesu xawit na zimbang, ka viring luk nandiaa ma di ramaraat fataling iaa damana nandiaa Zebedi lamaskana a mon faraxai wana ubina vaamuzazang sin naandi ma di los iaa naan. ");
INSERT INTO nal_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu ma ubina varaviraai zina di waan la bina Kaapernaaum. La raan a Saabat Iesu xa albis lamaskana a vaal a maainungang sin amun Judaa ma xat firaai aubina. ");
INSERT INTO nal_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aubina angkanaan di banglala mase wanaze a varaviraaiang sina xa maravan. Naan kawit na varaviraai malasing amun maravas iwana amun Lus sin Moses, singsaxai malasing axazak ka rauxin a burburaaiang. ");
INSERT INTO nal_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma fazaaus mase aza rapti xa ramaraat inaan lamaskana a vaal a maainungang sin naandi, a zapalaau xa ragul naan ma xa viraai laba naako, ");
INSERT INTO nal_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu in Naazaret, aze razaan gu saxot pana maam? Malasing faa, gu wat kuna vanong pizinang mase maam? Ga rexaazin nua. Nua Axazak Koxok, gu wat sin Nakmai!” ");
INSERT INTO nal_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu xa wisbuaak falagot naan naako, “Tuaa gu dador, gu waan siaana!” ");
INSERT INTO nal_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A zapalaau xa gis fadikdik a rapti angkanaan ma xa viraai laba ma xa waan fataling naan. ");
INSERT INTO nal_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aubina vaakdul di banglala mase ma di iaari varawuk lawalaua naandi malasing kari, “Aze razaan kari? A varaviraaiang faaxur varaxai wana a burburaaiang! Naan kai lis a dorang dikdik sin amun sapalaau ma dit langar zina.” ");
INSERT INTO nal_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Fazaaus mase a dorang pana a zaan Iesu xa giu xa waan farawuk lamaskana a pira vaakdul Gaalili. ");
INSERT INTO nal_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ma araan di tukbilak la vaal a maainungang sin amun Judaa, Iesu ma Saaimon ma Endru varaxai wana Jems ma Jon di waan la vaal zin Saaimon nandiaa Endru. ");
INSERT INTO nal_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Naandi di balas la vaal ma di tangin nimuna Saaimon ka itate gigias la wina iban sina. Naan ka winlagaf, ma di vazei Iesu wana naan. ");
INSERT INTO nal_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu xa wat sina ma xa roting naan la mitna ma xa vawaal varamaraat naan. A winlagaf ka vataling naan ma xa daxa xaarik. Naan ka ramaraat ma xa wa nimnimanin a vanganang aaxa naandi. ");
INSERT INTO nal_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Languzaraaf angkanaan araan a iaas ka si, aubina ininaan di wat sin Iesu ma di zaxot fawat aubina vaakdul ina di rauxin atavur amun giazang ma aubina ina amun sapalaau di ragul naandi. ");
INSERT INTO nal_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aubina vaakdul ila bina angkanaan di wat sin Iesu la vaal angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iesu xa vira amala aubina di rauxin atavura giazang. Naan ka mof pizin amun sapalaau ziaana aubina, singsaxai xa wisbuaak naandi dina wen dador, wanaze naandi di rexaas adu naan Naata Nakmai. ");
INSERT INTO nal_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Paanaraan gufguf mase, araan kat faakilan tapti nanga, Iesu xa ramaraat, ka tukbilak la vaal ma xa waan laza non kawit taxazak na raagul wana, ma xa wa maainung. ");
INSERT INTO nal_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saaimon ma amun paliaana di waan ma di zaleng naan, ");
INSERT INTO nal_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ka ruaas di tangin naan ma di piaat sina malasing kari, “Aubina vaakdul di zazaleng nua.” ");
INSERT INTO nal_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Iesu xa piaat sin naandi naako, “Dia dina waan lamun bina varawuk di iziar vaasilik iriat, kuna gana fazei zaait sin naandi, wanaze naan a vuvuna xari nia ga wat iriat.” ");
INSERT INTO nal_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iesu xa zazangas farawuk lamaskana a pira Gaalili, xa ifazei lamaskana amun faal a maainungang sin naandi ma xai mof pizin amun sapalaau ziaana aubina. ");
INSERT INTO nal_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aza raan aza rapti xa rauxin a tapak ka wat sin Iesu. Naan ka zibukaak lamarana Iesu ma xa maainung naan naako, “Tamon gu saxot, kat faraxas guna vaninis nia.” ");
INSERT INTO nal_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu xa maluf naan. Ka vatok a mitna ma xa xaaf a wina rapti ma xa piaat naako, “Ga saxot! Gu ninis!” ");
INSERT INTO nal_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Fazaaus mase a tapak ka vataling naan ma naan ka ninis kaarik. ");
INSERT INTO nal_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu xa kling pizin naan faraxai wana a dorang dikdik naako, ");
INSERT INTO nal_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Gu langar! Tuaa gu vazei taxazak pana aze razaan ka balas sunum. Singsaxai gu waan ma gu vatangin a winum sin a pris, ma gu lis a talazang sin Nakmai malasing ina Moses ka ra piaat lamaskana Baar Xoxok, kuna aubina vaakdul dina rexaas adu a giazang sunum ka vaanong.” ");
INSERT INTO nal_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Singsaxai naan saxo xa ramaraat, ka waan ma xa vazei varauxin aubina vaakdul. Malasing ma Iesu xawit na zazangas paan lamun bina laba la maravas. Naan ka iziar lamun non kawit taxazak ka raagul wana. Singsaxai nanga aubina di uwat sina lamun non farawuk. ");
INSERT INTO nal_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Azanon taan lamuraana, araan Iesu xa balas kaarik Kaapernaaum, aubina di langar adu naan ka wat ma xa iziar la vaal zina. ");
INSERT INTO nal_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Adi mala di wat fatu ma xawit ta marapalau xa izi walaau, ma lamarana mara zaait ka bas. Iesu xa fazei wana a dorang sin Nakmai zin naandi. ");
INSERT INTO nal_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Azanon tapti di zaxot fawat a rapti xa zipas. A rapti urulavaat di vazaak naan. ");
INSERT INTO nal_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Singsaxai xawit nat faraxas dina zaxot fawat naan sin Iesu wanaze adi mala marazaat. Di vazaak a zipas kula waata vaal laaxur. Di waapizin a waata vaal fatokang Iesu ma di waafining a mara xuna rasin fawizikang a zipas angkanaan paanaburut. Di vakabaal vawizik a zipas laaxur wana a iban xu waanaburut. ");
INSERT INTO nal_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Araan Iesu xa raamin fakilaan adu aubina angkari di inaxam paazaai, naan ka vazei a zipas naako, “Naarugu, ga naxaam pizin amun matmalabuk taksaat sunum.” ");
INSERT INTO nal_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Inaan azanon maravas iwana amun Lus sin Moses di iziar ma di naxaam lamaskana naandi malasing kari, ");
INSERT INTO nal_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kunaze a rapti angkari xa dador malasing kanaan? Ka lingpuak lawaana Nakmai. Nis kat faraxas kana naxaam pizin amun matmalabuk taksaat? Nakmai zingbe azaxai.” ");
INSERT INTO nal_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Fazaaus mase Iesu xa rexaas lamaskana a laklagai zina adu naandi di inaxam malasing kanaan lamaskana naandi ma xa piaat sin naandi naako, “Kunaze naagut naxaam amun saan angkanaan? ");
INSERT INTO nal_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aze ra dorang ka maravas kuna piaatang sin a zipas, ‘A matmalabuk taksaat sunum ga naxaam pizin,’ o gana piaat, ‘Tamaraat, suruk a xaazira zunum ma gu zangas?’ ");
INSERT INTO nal_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Singsaxai ga saxot naaguna rexaas adu Naata Rapti xa rauxin a burburaaiang laaxur wana pira angkari xuna naxaam pizinang amun matmalabuk taksaat.” Malasing ma naan ka piaat sin a zipas naako, ");
INSERT INTO nal_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ga vazei nua, tamaraat, suruk a xaazira zunum ma gu waan la vaal zunum.” ");
INSERT INTO nal_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A zipas ka ramaraat, ka zuruk luk a xaazira zina ma xa zangas tukbilak lamarana naandi vaakdul. Azaan angkanaan ka vabanglala aubina vaakdul ma di wisfaru Nakmai, ma di piaat malasing kari, “Kawit nanga di rataamin tawat saan malasing kanaan.” ");
INSERT INTO nal_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu xa waan kaarik ku laxon lapaara Laman Gaalili. Adi mala di wat sina ma xat firaai naandi. ");
INSERT INTO nal_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Araan ka zazangas pizik, ka raamin Livaai naata Aalfias ka iziar la vaal iwana zuzurukang a taakis. Iesu xa vazei naan naako, “Gu los nia.” Ma Livaai xa ramaraat ma xa los naan. ");
INSERT INTO nal_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iesu xa izi vavangan la vaal zin Livaai. Ma amala ubina dit suzuruk a taakis ma azanon aubina raksaat saait di vavangan faraxai wana naan ma ubina varaviraai zina. Avuna amala di los naan. ");
INSERT INTO nal_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Amun maravas iwana amun Lus sin Moses, naandi amun Faarasi, di raamin Iesu xa vavangan faraxai wana aubina raksaat ma ubina dit suzuruk a taakis ma di iaari zin ubina varaviraai zina malasing kari, “Kunaze Iesu xa vangan faraxai wana ubina di zuzuruk a taakis ma aubina raksaat?” ");
INSERT INTO nal_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Araan Iesu xa langar, xa piaat sin naandi naako, “Aubina xawit di gias, dina wen paan sin a dokta, singsaxai naandi ina di gias, naandi dina waan sin a dokta. Nia ga wat kawit kuna viringang aubina di tak singsaxai ga wat kuna viringang aubina raksaat.” ");
INSERT INTO nal_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aza raan ubina varaviraai zin Jon ma amun Faarasi di valvaal ma xawit di vangan. Azanon aubina di wat ma di iaari zin Iesu malasing kari, “Kunaze ubina varaviraai zin Jon ma amun Faarasi dit falvaal ma zunum kawit?” ");
INSERT INTO nal_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu xa xis naandi naako, “Lamaskana a vaamaxuzang, amun paasaxo zin a rapti xa maxus dina wen falvaal wanaze a rapti di vamaxuzin ka iziar varaxai wana naandi. ");
INSERT INTO nal_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Singsaxai a raan kana wat ma dina zaxot pizin a rapti di vamaxuzin siaana naandi ma la raan angkanaan laxo dina valvaal.” ");
INSERT INTO nal_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma Iesu xa piaat kaarik naako, “Kawit taxazak kat saxazit kol a waan marapi vaaxur varaxai wana a marapi xabaar. Tamon naana giu malasing kanaan, a waan marapi vaaxur xana urif taraar a marapi xabaar ma a non ka ramatar xana ramatar laba xaarik laxo. ");
INSERT INTO nal_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma xawit taxazak kat fitor sfaar a waain faaxur lamaskana a wakpaaka waain kabaar, wanaze tamon naana giu malasing kanaan a waain kana ring ma xana pau taraar a wakpaakna ma a waain ma a wakpaakna varaxai zaait kana raksaat. Singsaxai naan kana vitor sfaar a waain faaxur lamaskana a wakpaaka waain faaxur.” ");
INSERT INTO nal_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aza raan a Saabat, Iesu xa zazangas lamaskana amun uma wit faraxai wana ubina varaviraai zina. Ubina varaviraai zina dit sazangas ma di imos azanon kalamona wit kuna naadina iaan, malasing amun Lus sin Moses di rudaxain. ");
INSERT INTO nal_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Amun Faarasi di piaat sin Iesu malasing kari, “Taamin, kunaze ubina varaviraai zunum di giu azaan angkari xawit na tak la raan a Saabat?” ");
INSERT INTO nal_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma Iesu xa vazei naandi malasing kari, “Kawit nanga naagu vakot azaan angkaina Dewit ka giu mumua laraan naan ma ubina zina di ra lagaai ma xawit di rauxin ta vanganang? ");
INSERT INTO nal_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","La notaan Aabiaataa xa waamua zin amun pris laba, Dewit ka albis lamaskana a vaal zin Nakmai ma xa iaan a raraba di talas pana xa waan sin Nakmai. Singsaxai a Lus ka rudaxain be amun pris dina iaan. Ma naan ka ralaas saait ubina zina wana uzavang.” ");
INSERT INTO nal_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesu xa vazei amun Faarasi naako, “Nakmai xa rasin a raan a Saabat kuna vawaalang aubina, xawit na vaziaar aubina xuna vawaalang a raan a Saabat. ");
INSERT INTO nal_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Malasing ma Naata Rapti naan nanga a Piraana Saabat.” ");
INSERT INTO nal_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Aza raan kaarik Iesu xa albis lamaskana a vaal a maainungang sin amun Judaa. Aza rapti a mitna xa maat ka iziar inaan. ");
INSERT INTO nal_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Amun Faarasi di rataamaai wana Iesu tamon naan kana vira a rapti angkanaan la raan a Saabat. Di saxot adu dina vakor Iesu wana xa laxau a lus iwana Saabat. ");
INSERT INTO nal_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma Iesu xa vazei a rapti angkanaan a mitna xa maat naako, “Tamaraat ma gu rur lamarana aubina vaakdul.” ");
INSERT INTO nal_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma Iesu xa iaari zin amun Faarasi malasing kari, “Aze razaan a Lus sin dia xa rudaxain dia dina giu la a raan a Saabat, kuna vawaalang a rapti o xuna vamazikang naan, kuna zaxot faulinang a rapti o xuna zop famaatang naan?” Singsaxai xawit di xis naan. ");
INSERT INTO nal_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu xa boromaazik ma xa raamaai varawuk pana naandi, ma xa maskalus mase zaait pana naandi wanaze a waata naandi xa dikdik marazaat. Ma xa vazei a rapti angkanaan naako, “Gu vatok a mirum.” A rapti angkanaan ka vatok a mitna ma a mitna xa daxa uli xaarik. ");
INSERT INTO nal_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ma amun Faarasi di luaa a vaal a maainungang ma fazaaus mase di waan ma di tangin amun Judaa di ilos Erot. Ma naandi vaakdul di zaleng ta lan kuna dina zop famaat Iesu. ");
INSERT INTO nal_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu varaxai wana ubina varaviraai zina di waan fataling a vaal a maainungang ma di waan la Laman Gaalili. Ma adi xulutung ka los naan. ");
INSERT INTO nal_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aubina di wat lamun pira Gaalili ma pira Judia ma Jerusalem ma pira Idumia ma amun pira la ritita daanim Jodaan ma ilapaara uru bina Taair ma Saaidon. Naandi vaakdul di wat sin Iesu wanaze di langar wana amun saan faakdul naa ra gigiu. ");
INSERT INTO nal_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ka rauxin adi mala, ma Iesu xa vazei ubina varaviraai zina adu dina nimnimanin ta nan mon mumut aaxana xuna naan kana iziar wana, ma naandi dina wen bas farawuk lapaarana ma xana fazei ma naandi dina langarin naan. ");
INSERT INTO nal_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Avuna naan ka rat fira vanong amala, malasing ma amala aubina di rauxin atavura giazang dit fasingin paamuin naandi xuna dina xaaf be naan ma a giazang sin naandi xana vaanong. ");
INSERT INTO nal_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma azanon aubina amun sapalaau di ragul naandi, di wat sin Iesu, ma di zibukaak lamarana ma dit firaai malasing kari, “Nua Naata Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Singsaxai naan ka dador dikdik sin naandi xuna tuaa dina vazei taxazak tawarak pana naan mase nis. ");
INSERT INTO nal_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ma mur Iesu xa zangas puzaa xula waatawut ma xa viring luk ubina angkanaan naa saxot ma di wat sina. ");
INSERT INTO nal_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Naan ka kalin ubina di zangaaflu ma urua xuna dina iziar varaxai wana naan, ma xana ikling farauxin naandi xuna dina ifazei, ");
INSERT INTO nal_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ma dina rauxin a burburaaiang kuna mof pizinang amun sapalaau ziaana aubina. ");
INSERT INTO nal_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aizina ubina di zangaaflu ma urua ina naa kalin naandi xari, Saaimon, ina naa lis aza izina Pita, ");
INSERT INTO nal_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma Jems ma daasna Jon, uru naata Zebedi, ina naan ka vaiza zaait nandiaa wana aiza Boaaneges, aknaaza waaling angkari adu “Amun Naata Bambarak,” ");
INSERT INTO nal_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ma Endru, ma Filip, ma Baatalomeu, ma Metiu, ma Tomaas, ma aza Jems kaarik naata Aalfias, ma Taadius, ma aza Saaimon, sin a lemlem Zelot, ");
INSERT INTO nal_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judaas Iskaariot, naan saait ina mur xana ngutlis Iesu zin amun purua. ");
INSERT INTO nal_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mur Iesu xa waan la vaal. Ma axulutung kaarik ka wat fatu malasing ma naan ma ubina varaviraai zina xawit nat faraxas dina vangan. ");
INSERT INTO nal_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Araan naanaa zina ma amun daasna di langar, di wat kuna zaxot faulinang naan panaze di piaat malasing kari, “Naan ka ngong.” ");
INSERT INTO nal_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Amun maravas iwana amun Lus sin Moses ina di kabal wat Jerusalem, di langar adu Iesu xai mof pizin amun sapalaau ma di piaat malasing kari, “Belzebul, a waamua zin amun sapalaau, xa ragul naan pana dikdikang sina malasing ma Iesu xai mof pizin amun sapalaau.” ");
INSERT INTO nal_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iesu xa viring fawat amun maravas iwana amun Lus sin Moses ma xa dador zin naandi wana amun dorang lalaamangaai malasing kari, “A dorang sinim kawit na tak panaze Saatan kawit nat faraxas kana mof pizin naan nanga. ");
INSERT INTO nal_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tamon aubina ila bikabar azaxai di varop lawalaua naandi nanga, dina wen tur dikdik faraxai. ");
INSERT INTO nal_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tamon aubina ila maskana a vaal azaxai di varop lawalaua naandi nanga, naandi angkanaan dina wen taagul malasing a vatama azaxai. A dikdikang iwana raagul vatamaiang kanawit. ");
INSERT INTO nal_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Malasing saait tamon Saatan ma amun sapalaau zina dina varop, dina vatawagalaai ma naan kana zu ma a dikdikang sina xana vaanong. ");
INSERT INTO nal_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tamon taxazak ka saxot kana vazaak luk amun saan la vaal zin ta rapti xa maradikdik, naan kana pis fating kalaak a rapti angkanaan ma mur loxo xana vazaak luk amun saan sina. ");
INSERT INTO nal_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ga piaat faratunaan, Nakmai xana naxaam pizin amun matmalabuk taksaat faakdul ma amun dorang faakdul iwana piaat faraksaatang aubina. ");
INSERT INTO nal_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Singsaxai tamon axazak ka piaat faraksaat a Laklagaai a Raabu, Nakmai xana wen naxaam pizin a matmalabuk taksaat angkari. A matmalabuk taksaat angkari xai izi tapal. Ma naan ka vaaxapara wana.” ");
INSERT INTO nal_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu xa piaat azaan angkanaan panaze amun maravas iwana amun Lus sin Moses di piaat malasing kari, “A zapalaau xa ragul naan.” ");
INSERT INTO nal_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naanaan naanaa zin Iesu ma amun daaza Iesu di wat balas. Di wat irur lamanar ma di kling axazak kuna viring lukang Iesu. ");
INSERT INTO nal_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ka rauxin axulutung ka izi varaxulin Iesu ma di vazei naan malasing kari, “Naanaa zunum ma amun daazum di irur lamanar. Di zaleng nua.” ");
INSERT INTO nal_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma Iesu xa iaari zin naandi naako, “Nis naanaa zurugu ma nis amun daazugu?” ");
INSERT INTO nal_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Naan ka raamaai varawuk sin aubina vaakdul di iziar varaxulin naan ma xa piaat malasing kari, “Aubina angkari naandi amun naanaa zurugu ma amun daazugu! ");
INSERT INTO nal_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Axazak be xat falos a sasaxotang ma ainaxamang sin Nakmai, naan daazugu ma fafnugu ma naanaa zurugu.” ");
INSERT INTO nal_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mur Iesu xat faraviraai xaarik lapaara Laman Gaalili. Ma axulutung ka wat faraxulin naan, ma aubina di bas malasing ma naan ka xawas ma xa iziar lamaskana a mon ma xat faraviraai. A mon angkanaan ka iziar la laman. Singsaxai axulutung angkanaan ka irur laxon ma dit langarin naan. ");
INSERT INTO nal_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu xa varaviraai wana amun saan ka varas mase wana amun dorang lalaamangaai, ma xa dador lalaamangaai malasing kari, ");
INSERT INTO nal_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Naagu langar! Aza rapti xa ra waan la uma ma xa vazu amun kalamona wit. ");
INSERT INTO nal_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Araan ka psin farauxin amun kalamona wit, azanon kala xa zu la lan. Ma amun maani di wat ma di tok fanong amun kalamona wit angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Azanon kala xa zu la non ka rauxin amun faat ka varas, a pira xawit na wizik paanaburut, ma a wit ka bok fazaaus panaze a pira xa iziar be laaxur. ");
INSERT INTO nal_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Singsaxai araan a iaas ka wat laaxur, xa laang faplaxas amun wit, panaze amun katkadar xawit na wizik paanaburut ma amun wit di bok di vara maat. ");
INSERT INTO nal_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma azanon kala di zu lawalau amun lauran ka xoxorang. Ma axoxot ka kos paramin a wit ma xawit na vuai. ");
INSERT INTO nal_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma azanon kala di zu wana a pira daxa. Di bok daxa ma di laba ma mur di vuai ma di vamos mase naandi. Azanon di vuain azangaaflu vaarul, azanon azangaaflu vaawizik saaxa ma azanon azangaaflu varazuai.” ");
INSERT INTO nal_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Naanaan Iesu xa vazei naandi naako, “Nis ka rauxin alnga xuna langarang, naan kana langar.” ");
INSERT INTO nal_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lamur, araan Iesu xa iziar naansing, amun sangaaflu ma urua ma azanon aubina nanga di iziar zaait di iaari zina wana a vuvuna amun dorang lalaamangaai naa ra piaat. ");
INSERT INTO nal_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naan ka xis naandi malasing kari, “Nakmai xa viraai vanong nim pana a vuvuna dorang funfun pana a bikabar zin Nakmai. Singsaxai naandi di iziar lamanar wana a bikabar zin Nakmai, dit langarin amun saan faakdul wana dorang lalaamangaai. ");
INSERT INTO nal_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Naan ka giu malasing kanaan kuna: ‘Naandi dina raamin amun faamuzazang singsaxai dina wen taamaai vaakilan, ma naandi dina langarin amun dorang singsaxai dina wen mazaam, taulaan dina inaxam taawuk ma Nakmai xana naxaam pizin amun matmalabuk taksaat sin naandi.’ ” ");
INSERT INTO nal_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesu xa vazei zaait naandi naako, “Malasing faa, xawit naagu mazaam avuvuna dorang lalaamangaai angkanaan? Tamon kawit naagu mazaam a dorang lalaamangaai angkari, naaguna mazaam amun dorang lalaamangaai rawarak malasing faa? ");
INSERT INTO nal_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Lamaskana dorang lalaamangaai angkanaan, amun kalamona wit ka iru vakilaan amun dorang sin Nakmai, ina a rapti xat faazu xa vazu. ");
INSERT INTO nal_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Azanon kalamona wit di zu la lan. Di ru vakilaan aubina di langarin a dorang sin Nakmai, singsaxai Saatan ka wat fazaaus ma zuruk pizin a dorang di vazu lamaskana naandi. ");
INSERT INTO nal_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Azanon kalamona wit di zu wana amun faat, a non pira mumut ka iziar wana. Ka iru vakilaan naandi aubina di langarin a dorang ma fazaaus mase di zuruk faraxai wana dokdokang. ");
INSERT INTO nal_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Singsaxai naandi di malasing amun iaai xawit amun katkadorna. A dorang kawit na albis lamaskana roroiang sin naandi ma ainaxam paazaaiang sin naandi xawit na iziar vaabungbaraaf marazaat. Malasing ma araan a maravanang ka balas o aubina di vamazik naandi lalozang a dorang sin Nakmai, ainaxam paazaaiang sin naandi xa zu vazaaus mase. ");
INSERT INTO nal_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Azanon aubina di malasing amun kalamona wit di zu lamaskana amun lauran ka xoxorang. Naandi di langarin a dorang, ");
INSERT INTO nal_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","singsaxai di inaxam marazaat pana amun saan ka varas iwana roroiang kari, ma di sasaxot dina raxumbaaxut ina xat fagit naandi, ma di mazaalu saxotang dina rauxin azanon saan nanga xa varas ila pira angkari. Naan amun saan angkanaan ka albis lamaskana roroiang sin naandi ma xa waramin a dorang sin Nakmai ma a dorang kawit na vuain a fnuaai. ");
INSERT INTO nal_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Azanon aubina di malasing amun kalamona wit di zu wana pira daxa. Naandi di langarin a dorang sin Nakmai ma di rudaxain ma a roroiang sin naandi xa vabalos amun fnuaai. Azanon di vuain amun fnuaai xat faraxas pana azangaaflu vaarul, azanon ka zangaaflu vaawizik saaxa ma azanon ka zangaaflu varazuai.” ");
INSERT INTO nal_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma Iesu xa dador lalaamangaai zaait sin naandi malasing kari, “Ka malasing faa, Iaak naagut failaap a laam ma naagu pung paramin pana a boul o naagu vun lawaana iban? Kawit. Naagu ratasin la akin siziarang iwana la maravas. ");
INSERT INTO nal_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aze razaan ka izi vunfun kana balas la maravas, ma a dorang aknaasna xa izi vunfun, mur dina mazaam. ");
INSERT INTO nal_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Naagu langar! Tamon naagu rauxin alnga xuna langarang, naagu langarin a dorang kari.” ");
INSERT INTO nal_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesu xa piaat saait sin naandi malasing kari, “Naagu inaxam daxa wana a dorang naagu langarin. Pana aze ra lan naagu giu wana azanon tawarak, naan a lan angbani naadina giu wana nim, ma dina giu vauzaa nanga. ");
INSERT INTO nal_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Avuna tamon axazak ka rauxin a mazamang, Nakmai xana lis saait a mazamang laba xaarik sina. Tamon axazak kawit na rauxin, Nakmai xana zuruk pizin anan mazamang mumut naa rauxin.” ");
INSERT INTO nal_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu xa piaat kaarik naako, “A bikabar zin Nakmai xa malasing kari. Aza rapti xa vazu amun kalamona wit la uma. ");
INSERT INTO nal_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Labung naan ka imilaaif ma lawaanaas ka rataalil wana amun faamuzazang sina, ma amun kalamona wit di bok ma di laba ma a rapti angkanaan kawit na rexaas adu amun kalamona wit ka bok malasing faa. ");
INSERT INTO nal_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A pira nanga xat fabalos axala ma xai bok. Axala xa bok kalaak ma lamur a waxana ma mur amun kalamona wit ka vuai. ");
INSERT INTO nal_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Araan amun wit ka makal, a rapti angkanaan ka zuruk a sikal ma xa laaf amun kalamona wit panaze a raan a laflaavang ka balas faanong.” ");
INSERT INTO nal_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu xa piaat kaarik naako, “Dia dina piaat a bikabar zin Nakmai xa malasing faa, o aze ra dorang lalaamangaai dina piaat pana? ");
INSERT INTO nal_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A bikabar zin Nakmai xa malasing a xalamona maastat ka mumut mase wana amun kala vaakdul dit fazu la pira. ");
INSERT INTO nal_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Araan di vazu ma xa bok, kana bok laba ma xana laba luaa amun saan faakdul dit fazu la uma. Amun tangtangaana zaait di laba ma amun maani di uwat ma di iziar la maliaangna.” ");
INSERT INTO nal_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Amun dorang lalaamangaai xa varas malasing kanaan Iesu xa dadorin sin aubina, xat faraxas pana naandi dina mazaam. ");
INSERT INTO nal_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Naan kai fazei zin naandi be wana dorang lalaamangaai. Singsaxai araan naan singbe xa iziar varaxai wana ubina varaviraai zina, xa vamaravaas aknaaza dorang sin naandi. ");
INSERT INTO nal_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","La raan angkanaan araan a iaas kai si wizik, Iesu xa vazei ubina varaviraai zina naako, “Dina kas buak kulaza non ritita laman.” ");
INSERT INTO nal_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Di vataling axulutung ma di xawaas a mon angkanaan Iesu xa iziar lamaskana ma di waan faraxai wana naan. Azanon mon saait di waan faraxai wana a mon sin naandi. ");
INSERT INTO nal_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Adi maaliu xa taaif dikdik ma a laman ka varop ma a rof ka rambur wana a mon ma xa raamaai malasing adu faasilik a mon kana lus. ");
INSERT INTO nal_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Iesu xa milaaif la muraana mon, ka itate wana a ulingan. Ubina varaviraai zina di wangun naan ma di piaat sina malasing kari, “Maravas, malasing faa, xawit gu maluf dia dina xanak?” ");
INSERT INTO nal_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu xa ramaraat ma xa vadawaar a maaliu ma xa vazei a rof malasing kari, “Gu ziburung! Gu malaai!” Ma a maaliu xa maat ma a laman ka malaai mase. ");
INSERT INTO nal_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma Iesu xa vazei ubina varaviraai zina naako, “Kunaze naagu maraaut? Ka malasing faa, xawit nanga naagu inaxam paazaai?” ");
INSERT INTO nal_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma naandi di maraaut mase ma di dador lawalaua naandi zaksaxai malasing kari, “Nis mase xari? A maaliu ma rof di langar iaa zina!” ");
INSERT INTO nal_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu ma ubina varaviraai zina di balas laza rita Laman Gaalili la non pira zin aubina in Gerasaa. ");
INSERT INTO nal_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Araan Iesu xa kasaai wana a mon, fazaaus mase aza rapti a zapalaau xa ragul naan, ka wat lamun baaul a maat ma xa vasuin naan. ");
INSERT INTO nal_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Naan ka rataagul lamaskana amun baaul a maat ma aubina ila non angkanaan kawit dit faraxas dina zaxir vating naan, naapalaau tamon di zaxir vating naan pana amun sen. ");
INSERT INTO nal_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Faavaras faanong, aubina ila bina zina di rat saxir vating naan pana amun sen, singsaxai xai kip amun sen dit saxir vating uru mitna ma uru xaakna wana. Kawit taxazak ka maradikdik, kat faraxas kana rotfating naan. ");
INSERT INTO nal_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lamun taan faakdul lawaanaas ma labung, naan ka zazangas farawuk ku lamaskana amun baaul a maat ma xula kaana wut ma xa rataangis kupkup ma xa rataraai a winpina wana amun faat. ");
INSERT INTO nal_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Araan ka raamin Iesu lawalaau nanga, xa valaau wat ma xa zibukaak lamarana Iesu. ");
INSERT INTO nal_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Naan ka xupkup laba malasing kari, “Iesu, Naata Nakmai Laaxur Mase! Aze razaan gu saxot guna giu wana nia? Ga maainung nua guna xalxal zin Nakmai adu tuaa gu vamazik nia.” ");
INSERT INTO nal_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Avuna Iesu xa ra vazei naan naako, “Nua a zapalaau, gu tukbilak siaana a rapti angkari.” ");
INSERT INTO nal_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ma Iesu xa iaari zina naako, “Nis aizinum?” Naan ka xis Iesu malasing kari, “Aizinugu Amala, wanaze maam maadi varas.” ");
INSERT INTO nal_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma xa maainung Iesu faavaras tuaa xana kling pizin naandi ziaana a non pira angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ka rauxin adi lemlem bari di vavangan la nan put faasilik. ");
INSERT INTO nal_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma amun sapalaau di maainung Iesu malasing kari, “Gu kling maam, maadina sfaar amun bari angkapaa.” ");
INSERT INTO nal_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naan ka rudaxain naandi ma amun sapalaau di tukbilak ma di sfaar amun bari. Amun bari angkanaan, di malasing a taausan urua vaakdul, di zazarai wizik paanaburut ku lamaskana laman ma di xanak ma di maat. ");
INSERT INTO nal_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Naandi ina di italas bari di raamin azaan angkanaan ma di valaau. Di waan ma di fazei la bina laba ma lamun non farawuk. Ma aubina di wat kuna dina raamin aze razaan ka balas. ");
INSERT INTO nal_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Araan di wat sin Iesu, di raamin a rapti amala amun sapalaau di ragul naan ka iziar. Naan ka mamaaus ma ainaxamang sina xa uli. Singsaxai aubina angkanaan di maraaut. ");
INSERT INTO nal_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Naandi di ra raamin azaan angkanaan, di xus aubina wana aze razaan Iesu xa giu wana a rapti ma amun bari. ");
INSERT INTO nal_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aubina angkanaan di maainung fadikdik Iesu xuna naan kana waan fataling a non pira angkanaan sin naandi. ");
INSERT INTO nal_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Araan Iesu xat kawas pana a mon, a rapti angkanaan a zapalaau xa ra ragul naan, ka maainung naan kuna xana waan faraxai wana naan. ");
INSERT INTO nal_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Singsaxai Iesu xawit na rudaxain naan. Ka vazei naan naako, “Gu waan la vaal zunum ma gu vazei naandi zunum pana azaan a Piran ka ra giu wana nua, ma wana a varamaaluvang sina wana nua.” ");
INSERT INTO nal_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma a rapti angkanaan ka waan fataling Iesu ma xa zangas farawuk ku lamun bina laba xa zangaaflu, ma xa fazei zin aubina vaakdul wana azaan angkanaan Iesu xa giu wana naan. Ma aubina vaakdul di langarin ma di banglala. ");
INSERT INTO nal_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu xa kas buaak faulin kaarik a Laman Gaalili wana a mon ma axulutung ka wat sina ipaa laxon. ");
INSERT INTO nal_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma aza rapti xa balas, naan a waamua ila vaal a maainungang sin amun Judaa ma aizina Jaairus. Araan naan ka raamin Iesu, xa psin fawizik naan paanaburut la pira la xaaka Iesu. ");
INSERT INTO nal_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Naan ka maainung Iesu malasing kari, “A fnaalik mumut surugu adu xana maat. Ga saxot guna wat ma guna rasin uru mirum pana naan kuna guna vira naan ma xana roro.” ");
INSERT INTO nal_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma Iesu xa waan faraxai wana naan. Ma axulutung ka los naan ma dit faramburut farawuk lapaarana. ");
INSERT INTO nal_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma aza ravin inaan ka giazin a dari laba. A giazang kanaan ka iziar wana naan pana a maariaas ka zangaaflu ma urua. ");
INSERT INTO nal_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naan ka wanpaan bulaai zin amun dokta, singsaxai dit famazik be naan ma xawit dit fawaal naan. A kaakaai zina xa vaanong ma a giazang kawit na vaanong, singsaxai xa vut balas taksaat kaarik laxo. ");
INSERT INTO nal_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Naan ka langar wana Iesu ma xa wat lamuraana lamaskana axulutung ma xa xaaf a marapi baraaf sin Iesu, ");
INSERT INTO nal_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","wanaze xa naxaam naako, “Tamon gana xaaf be a marapi baraaf sin Iesu, gana roro daxa xaarik.” ");
INSERT INTO nal_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A ravin ka xaaf a marapi baraaf sin Iesu ma fazaaus mase a dari laba xa vaanong ma xa xazanin a winpina xa mamaraxas. ");
INSERT INTO nal_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma fazaaus mase Iesu xa xazanin adu azanon dikdikang sina xa waan siaana. Naan ka rutaawuk lamaskana axulutung angkanaan ma xa iaari malasing kari, “Nis ka xaaf a marapi zurugu?” ");
INSERT INTO nal_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma ubina varaviraai zina di xis naan malasing kari, “Aubina xa varas di zazangas lapaarum ma dit birit nua, malasing ma xunaze gu iaari malasing kari, ‘Nis ka xaaf a marapi zurugu?’ ” ");
INSERT INTO nal_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Singsaxai Iesu xa raamaai varawuk nanga xuna raamin salengang axazak angkanaan ka xaaf a marapi zina. ");
INSERT INTO nal_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A ravin angkanaan ka rexaas adu a giazang sina xa vaanong. Naan ka maraaut ma xa dakdakur ma xa wat sibukaak lamarana Iesu ma xa vazei naan pana amun saan faakdul. ");
INSERT INTO nal_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma Iesu xa vazei naan naako, “Finaalik, ainaxam paazaaiang sunum ka vira nua. Gu waan faraxai wana a luaai, ma guna mamaraxas siaana a maazikang sunum.” ");
INSERT INTO nal_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Araan Iesu nanga xai dador varaxai wana a ravin angkanaan, azanon ubina di vinang la vaal zin Jaairus, a waamua ila vaal a maainungang, di balas sin Jaairus ma di piaat, “Nativum ka maat faanong. Tuaa xaarik gu varalil a maravas.” ");
INSERT INTO nal_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu xa langar wana dorang sin naandi singsaxai xa piaat sin a waamua ila vaal a maainungang naako, “Tuaa gu maraaut, gu inaxam paazaai be.” ");
INSERT INTO nal_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kawit na luaa taxazak kana los naan, Pita be, ma Jems ma daasna Jon. ");
INSERT INTO nal_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Araan di balas la vaal zin Jaairus, Iesu xa raamin aubina di vaanggala. Azanon di rataangis ma azanon di rataangis kupkup. ");
INSERT INTO nal_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesu xa albis la vaal angkanaan ma xa piaat sin naandi naako, “Kunaze naagu vaanggala ma naagu raangis kupkup? A fnaalik kawit na maat, ka imilaaif be.” ");
INSERT INTO nal_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Singsaxai di vanangon naan. Iesu xa kling fatukbilak naandi ma xa zaxot damana ma dina a fnaalik angkanaan faraxai wana ubina varaviraai urul zina, ma di albis lamaskana a rumaaf a fnaalik ka itate lamaskana. ");
INSERT INTO nal_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ka taaxur la mitna ma xa vazei naan naako, “Taalita, koum.” Aknaaza dorang kari xa malasing kari, “Finaalik, ga vazei nua, tamaraat.” ");
INSERT INTO nal_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma fazaaus mase a fnaalik ka ruzaa ma xa zangas farawuk la non angkanaan. A maariaas sina xa zangaaflu ma urua. Ma naandi di iziar inaan di banglala marazaat. ");
INSERT INTO nal_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma Iesu xa vazei vadikdik naandi adu tuaa dina piaat azaan angkanaan sin taxazak, ma xa vazei damana varaxai wana dina a fnaalik adu dina ralaas iaa naan pana tazaan kuna iaanang. ");
INSERT INTO nal_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu xa luaa a bina angkanaan ma xa uli xula bina zina vaatak, faraxai wana ubina varaviraai zina. ");
INSERT INTO nal_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","La raan a Saabat ka albis lamaskana a vaal a maainungang sin amun Judaa ma xat faraviraai. Ma amala aubina di langarin naan ma di banglala. Ma di iaari malasing kari, “A rapti angkari xa rexaazin amun saan angkanaan malasing faa? Ma awat mazamang kanaan, nis ka lis sina ma xat fabalos saait amun faamuzazang ka banglala! ");
INSERT INTO nal_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naan bani a kaamdaa, naata Maaria, ma daaza Jems ma Iosep ma Judaas ma Saaimon. Ma amun fafina di iziar iriat faraxai wana dia.” Ma di maska raksaat pana naan. ");
INSERT INTO nal_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu xa vazei naandi naako, “Aubina dit faranop pana a profet lamun bina rawarak, singsaxai xawit dit faranop pana naan la bina zina vaatak, lawalau amun taauna ma la vaal zina vaatak saait.” ");
INSERT INTO nal_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naan kawit nat faraxas kana giu vabalos amun faamuzazang ka banglala inaan, singsaxai xa rasin be uru mitna wana aubina xawit faras be ina di gias ma xa vira naandi. ");
INSERT INTO nal_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma naan ka banglala wana xawit di inaxam paazaai wana naan. Naanaan Iesu xa waan farawuk lamun bina ma xat faraviraai. ");
INSERT INTO nal_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ka viring luk a zangaaflu ma urua zina, ma xa kling paanin naandi, urua urua, ma xa lis a burburaaiang sin naandi xuna dina mof psin amun sapalaau. ");
INSERT INTO nal_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iesu xa vazei naandi naako, “Tuaa naagu zuruk tazaan faraxai wana nim pana a zangazang sinim, a laak be. Amun saan malasing a raraba ma a laxa ma a kaakaai la baak, tuaa. ");
INSERT INTO nal_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Naagu valaak be a su la xaaka nim singsaxai tuaa naagu zuruk kaarik nanga taza marapi wana xulxulang. ");
INSERT INTO nal_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Araan naaguna albis la zera vaal, naan a vaal angbani naagu iziar wana xa ruaas naagu luaa a bina angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tamon naagu balas la aze ra bina ma xawit di nanam pana ruzuaaiang nim, o xawit di langar zinim, naagu taaf pizin a paauf la axaaka nim araan naagu waan. Ka vatangin adu naagu mamaraxas siaana aze ra maravanang kana balas sin naandi mur.” ");
INSERT INTO nal_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Di waan ma di fazei varawuk adu aubina dina inaxam taawuk. ");
INSERT INTO nal_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Di mof pizin amun sapalaau xa varas ma di vukin a wel iwana olif pana aubina di gias ma di vira naandi. ");
INSERT INTO nal_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A Xalxaal Erot ka langarin amun saan angkanaan, avuna aizina Iesu xa laba lamaskana amun bina. Azanon aubina di piaat pana Iesu malasing kari, “A rapti angkanaan naan Jon A Rapti Iwana Baaptaaizang, ka ramaraat puli wana maatang malasing ma xa rauxin a dikdikang kuna giuang amun faamuzazang ka banglala.” ");
INSERT INTO nal_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma azanon di piaat malasing kari, “Naan bani Elaaija.” Singsaxai azanon nanga di piaat malasing kari, “Naan a profet malasing azaxai zin amun profet i mumua pis.” ");
INSERT INTO nal_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Singsaxai araan Erot ka langarin a dorang kanaan, naan ka piaat naako, “Jon a rapti ina ga ra kip pizin a vuruna, xa ramaraat puli xaarik pana maatang!” ");
INSERT INTO nal_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Azanon flan paamua, Erot ka ra lis a dorang dikdik ma di zaraak Jon ma di zaxir vating naan ma di rasin naan la vaal a vaamaazikang. Naan ka giu a matmalabuk angkanaan panaze wana Erodiaas, paamua naan a ravin sin daasna Filip. Singsaxai Erot ka ra urif Erodiaas siaana Filip ma naa zaxot. ");
INSERT INTO nal_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Paamua wana di zaraak Jon, naan ka rat fazei Erot naako, “Kawit na tak pana nua gu maxus sin a ravin sin daazum.” ");
INSERT INTO nal_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Malasing ma Erodiaas ka saxot kana puxaai wana Jon panaze xa vakor nandiaa wana maxuzang sin nandiaa ma xa zaleng a lan kuna zop famaatang Jon singsaxai naan kawit nat faraxas, ");
INSERT INTO nal_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","panaze Erot kat faranop pana Jon ma xa rataamaai xaaul wana naan. Avuna xa rexaas adu Jon naan a rapti xa tak ma xa ninis lamarana Nakmai. Araan Erot kat langarin a dorang sin Jon, ka inaxam farvaras mase singsaxai xai saxot nanga xana langarin Jon. ");
INSERT INTO nal_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aza raan daxa mase xa balas. A raan angkanaan Erot ka giu a flangan kuna naxaamang a raan di luk naan. Ka vazei amun paamua ila gaapman ma amun paamua ila aami ma amun paamua nanga ila pira Gaalili dina wat fangan faraxai wana naan. ");
INSERT INTO nal_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Araan di vavangan, nativa Erodiaas ka albis ma xa riria lamarana Erot ma amun paamua ma di nanam mase. Ma a xalxaal xa vazei a fnaalik naako, “Tamon guna maainung nia wana aze razaan gu saxot, gana lis sunum.” ");
INSERT INTO nal_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma xa xalxal wana a waata fafina naako, “Aze razaan gu iaariin naambari, gana lis be zunum, naapalaau tamon guna iaari wana gana kip a bikabar zurugu labirua ma gana lis aza non sunum, gana lis be.” ");
INSERT INTO nal_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A fnaalik ka tukbilak ma xa iaari zin naanaa zina naako, “Gana iaari wana aze?” Naanaa zina xa xis naan malasing kari, “Gu iaari wana a waata Jon A Rapti Iwana Baaptaaizang.” ");
INSERT INTO nal_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Fazaaus mase a fnaalik ka albis puli ma xa vazei a xalxaal naako, “Ga saxot naambari nanga guna lis a waata Jon A Rapti Iwana Baaptaaizang surugu wana a win.” ");
INSERT INTO nal_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A xalxaal xa maskalus mase, singsaxai xawit nat faraxas kana iaalauxaai lamarana amun paamua di vavangan faraxai wanaze naan ka ra xalxal vaanong. ");
INSERT INTO nal_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Fazaaus mase naan ka kling aza rapti xai saaup ka waan la non Jon ka iziar wana, ma xa kip pizin a vuruna Jon ");
INSERT INTO nal_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma xa zuruk fawat a waata Jon pana a win. Naa lis sin a fnaalik ma xa lis sin dina. ");
INSERT INTO nal_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ubina varaviraai zin Jon di langar ma di wat fazaak luk naan ma di vatate naan la baaul a maat. ");
INSERT INTO nal_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Amun aaposal di uli wat ma di wat faraxulin Iesu ma di vazei naan pana amun saan faakdul naadi ra giu ma di ra varaviraai wana. ");
INSERT INTO nal_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Amala di wat ma di wanpaan malasing ma Iesu ma amun aaposal xawit ta marapalau aaxan naandi xuna vanganang. Iesu xa vazei naandi naako, “Nim singbe naagu wat faraxai wana nia ma dina waan la non kawit taxazak pana ma dina iaavus.” ");
INSERT INTO nal_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Malasing ma naandi zingbe di waan pana a mon ku laza non kawit taxazak pana. ");
INSERT INTO nal_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Singsaxai aubina xa varas di raamin fakilaan naandi di waan ma di valaau vataling amun bina laba vaakdul ma di tabung balas paamuain naandi. ");
INSERT INTO nal_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Araan di balas, Iesu xa raamin axulutung, ka maluf naandi wanaze di malasing amun sipsip kawit a rapti xa rataamaai xaaul wana naandi. Naan ka ramaraat ma xa viraai naandi wana amun saan ka varas. ");
INSERT INTO nal_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A bina xa nguzaraaf ka ma ubina varaviraai zin Iesu di wat sina ma di piaat malasing kari, “A non angkari xawit taxazak ma xa nguzaraaf faanong. ");
INSERT INTO nal_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gu kling pizin aubina xuna dina waan lamun non farawuk ma amun bina xuna dina wulwul vanganang kun naandi.” ");
INSERT INTO nal_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Singsaxai Iesu xa xis naandi naako, “Nim nanga naagu ralaas naandi.” Ma di vazei naan malasing kari, “Kana zuruk a wulwulang pana a flan ka wizik tul zin axazak kat faamuzas. Iaak gu saxot maadina waan ma maadina wul a raraba wana awat pulwulang kari xuna ralaazang naandi?” ");
INSERT INTO nal_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu xa iaari zin naandi naako, “Usfa raraba naagu rauxin? Naagu waan ma naagu raamaai.” Di wa raamaai vaanong ma di wat piaat malasing kari, “A raraba xa watmit ma a ian urua.” ");
INSERT INTO nal_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ma xa vazei ubina varaviraai zina dina vazei aubina dina iziar wana amun lemlem laaxur wana a wilaangis ka maraxawa. ");
INSERT INTO nal_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aubina di iziar wana amun lemlem ka zangaaflu varazuai, ma azanon azangaaflu vaa watmit. ");
INSERT INTO nal_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iesu xa zuruk a raraba xa watmit ma a ian urua, xa raamaai uzaa la lia ma xa wisfaadaxa ma xa biaak a raraba. Naa lis sin ubina varaviraai zina xuna dina talazin lawalau aubina. Ka talazin saait uru ian lawalaua naandi vaakdul. ");
INSERT INTO nal_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Naandi vaakdul di vangan ma di maazur. ");
INSERT INTO nal_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ubina varaviraai di sfaar vambos amun laxa xa zangaaflu ma urua wana amun kibaala raraba ma ian di biaak. ");
INSERT INTO nal_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A furavin, a funalik ma ubina, naandi vaakdul di ra vangan. Singsaxai di vakot ubina la raan angkanaan ka malasing a taausan ka watmit. ");
INSERT INTO nal_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Fazaaus mase Iesu xa vazei ubina varaviraai zina dina waan pana a mon ma di kas buak kun Betsaaida. Naan singbe xa iziar ma xa kling pizin axulutung. ");
INSERT INTO nal_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ka vataling naandi ma xa uzaa la waatawut kuna maainungang. ");
INSERT INTO nal_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Labung ka, a mon pana ubina varaviraai xa iziar labirua wana laman, ma Iesu zingbe xa iziar la waatawut. ");
INSERT INTO nal_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iesu xa raamin adu ubina varaviraai zina di gut pana kaaulang, panaze a maaliu xa varop faraxai wana naandi. La notaan malasing la birua wana a marana a iaas urul ma xa wizik saaxa paanaraan gufguf Iesu xa waan sin naandi, xa zazangas laaxur wana laman. Faasilik kana zangas bilaas naandi, ");
INSERT INTO nal_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ma di raamin naan ka zazangas laaxur wana laman ma di naxaam adu a warak. Ma di xupkup laba, ");
INSERT INTO nal_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","panaze di laanga raamin naan ma di maraaut taksaat mase. Fazaaus mase xa dador zin naandi naako, “Naagu dikdik! Nia be. Tuaa naagu maraaut.” ");
INSERT INTO nal_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naan ka albis lamaskana mon ina naandi di iziar lamaskana ma a maaliu xa maat. Di banglala mase, ");
INSERT INTO nal_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","wanaze xawit di mazaam a vuvuna azaan Iesu xa giu wana raraba. Amun maskana naandi xa dikdik. ");
INSERT INTO nal_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Araan di kasbuak faanong, di xozaraai la bina Genesaret, ma di rasin a mon inaan. ");
INSERT INTO nal_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Araan di kasaai wana mon, aubina di raamin fakilaan Iesu. ");
INSERT INTO nal_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Di valaau varawuk lamaskana a non pira vaakdul angkanaan ma di vazaak luk aubina di gias pana a xaazira xula aze ranon Iesu xa iziar wana. ");
INSERT INTO nal_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma aze ra non Iesu xa waan pana, la amun bina o la amun bina laba o la amun non mumut, di rasin aubina di gias la non a vaangurang. Di maainung Iesu xana luaa aubina angkanaan di gias dina xaaf be a zuva marapi zina. Ma naandi vaakdul ina di xaaf, di daxa xaarik. ");
INSERT INTO nal_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Amun Faarasi ma azanon maravas iwana amun Lus sin Moses di vinang Jerusalem ma di wat faraxulin Iesu ");
INSERT INTO nal_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ma di raamin azanon ubina varaviraai zina di vavangan be wana amun mita naandi ina amun Faarasi di ipiaat adu xa mitikaai lamarana Nakmai, wanaze xawit di valos a rataawuka zuksukang amun mita naandi. ");
INSERT INTO nal_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Amun Faarasi ma aubina vaakdul in Judia dit falos a dorang i mumua adu dina wen fangan tamon kawit di tabung suk amun mita naandi lalozang a rataawuka amun kulmua zin naandi. ");
INSERT INTO nal_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Araan naandi di vinang la non iwana vaangurang, dina wen fangan tamon kawit di tabung suksuk mit. Ma amun saan saait nanga xa varas naadit gigiu lalos amun tataawuka naandi, malasing dit suksuk amun pin imiminang ma amun pin laba nanga ma amun ketal.) ");
INSERT INTO nal_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ma amun Faarasi ma amun maravas iwana amun Lus sin Moses di iaari zin Iesu malasing kari, “Kunaze ma ubina varaviraai zunum kawit di valos a rataawuka amun kulmua zin dia, ma di vangan pana amun mita naandi xa mitikaai lamarana Nakmai?” ");
INSERT INTO nal_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu xa xis naandi naako, “A profet Aaisaaia xa vaaratunaan mase araan ka dador profet pana nim ubina xawit naagut falos amun dorang sinim. Naan ka varaar vating a dorang sin Nakmai malasing kari, ‘Aubina angkari di nop nia wana nguza naandi, singsaxai a maskana naandi xa lawalaau mase wana nia. ");
INSERT INTO nal_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naandi di lotu walaau wana nia, wanaze dit firaai aubina lalozang amun lus sin aubina be.’ ");
INSERT INTO nal_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Naagu luaa vanong amun Lus sin Nakmai ma naagu los amun tataawuka aubina be.” ");
INSERT INTO nal_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma Iesu xa vazei xaarik naandi naako, “Ka raksaat pana naagu valiu amun Lus sin Nakmai ma naagui los be amun tataawuka nim nanga! ");
INSERT INTO nal_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Avuna mumua pis Moses ka ra piaat naako, ‘Gu nop damaam ma dinaam,’ ma ‘Tamon taxazak kana piaat faraksaat damana o dina, dina zop famaat naan.’ ");
INSERT INTO nal_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Singsaxai nim, naagu viraai aubina adu tamon axazak kana vazei damana o naanaa zina adu aze razaan naan kana vawaal nandiaa wana, azaan angkanaan a talazang sina aaxan Nakmai, ");
INSERT INTO nal_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","naanaan naagu wisbuaak naan kuna tuaa naan kana vawaal damana o naanaa zina. ");
INSERT INTO nal_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Malasing ma wana a lan angkanaan, naagu waramin a dorang sin Nakmai, ma naagu los be amun tataawuka nim ina amun kulmua zinim di lis. Ma naagu gigiu amun saan ka varas saait malasing kanaan.” ");
INSERT INTO nal_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu xa viring fawat kaarik axulutung ma di wat sina, ma xa piaat naako, “Nim faakdul naagu langar zurugu ma naagu mazaam a dorang kari: ");
INSERT INTO nal_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Aze razaan axazak ka iaan ma xa albis lamaskana a xuna, xana wen famitikaai naan lamarana Nakmai. Singsaxai amun saan ina xa tukbilak lamaskana axazak ku lamanar, naan kana vamitikaai naan.” ");
INSERT INTO nal_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu xa vataling axulutung angkanaan ma xa albis la vaal. Ma ubina varaviraai zina di iaari wana a dorang lalaamangaai angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma Iesu xa iaari zin naandi naako, “Malasing faa, nim saait kawit naagu maravas pana? Kasaa, xawit naagu mazaam adu amun saan faakdul xa albis lamaskana a xuna axazak, kana wen famitikaai naan lamarana Nakmai? ");
INSERT INTO nal_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Avuna xawit na wizik lamaskana ainaxamang sina, singsaxai xa wizik lamaskana a xuna ma naa wizin pizin.” (Araan Iesu xa piaat a dorang kanaan, ka piaat naako lamarana Nakmai amun fanganang faakdul xa daxa xuna iaanang.) ");
INSERT INTO nal_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iesu xa piaat saait nanga naako, “Aze razaan ka iziar lamaskana axazak ma xa tukbilak la balana, a zaan angkanaan kana vamitikaai naan lamarana Nakmai. ");
INSERT INTO nal_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Avuna naan amun saan angkari xai tukbilak lamaskana axazak: ainaxamang taksaat ma amun matmalabuk taksaat lamanar wana aizit maxuzang ma a matmalabuk iwana vinaauang ma a matmalabuk iwana zop famaatang axazak ");
INSERT INTO nal_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma a matmalabuk iwana milivinang a ravin tawarak o a rapti rawarak ma a matmalabuk iwana lamaiang ma a matmalabuk iwana kawinang azanon ma a matmalabuk iwana vaagitang ma a matmalabuk iwana vaamaangilang ka mitikaai ma a matmalabuk iwana marazaxatang ma a matmalabuk iwana piaat faraksaatang axazak ma a matmalabuk iwana valaupang nua nanga ma a matmalabuka rabanatang. ");
INSERT INTO nal_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Amun matmalabuk taksaat faakdul angkanaan kai tukbilak lamaskana axazak ma xat famitikaai naan lamarana Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu xa ramaraat ma xa vataling a pira Gaalili ma xa balas lapaara bina laba Taair. Naan ka albis laza vaal. Kawit na saxot adu taxazak kana rexaas pana naan ka iziar inaan, singsaxai naan kawit nat faraxas kana vunfunaai. ");
INSERT INTO nal_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nativa aza ravin, a zapalaau xa ragul naan. Araan bani xa langar wana Iesu, fazaaus mase xa wat ma xa zibukaak la xaakna. ");
INSERT INTO nal_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A ravin angkanaan, naan a ravin in Grik, ma di luk naan la non laba Fonisia la provins Siria. Naan ka maainung Iesu xuna xana mof pizin a zapalaau ina xa ragul natifna. ");
INSERT INTO nal_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iesu xa vazei a ravin naako, “Guna luaa xalaak a funalik dina vangan maazur, wanaze xawit na tak pana dina zuruk a raraba zin a funalik ma dina psin sin amun piu.” ");
INSERT INTO nal_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A ravin angkanaan ka xis naan naako, “Piran, singsaxai amun piu zaait lawaana iban favanganang, di iaan a sina vanganang sin a funalik.” ");
INSERT INTO nal_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iesu xa vazei naan naako, “Pana a wat dorang daxa zunum, gu uli xabe xula vaal zunum. A zapalaau xa vataling fanong nativum.” ");
INSERT INTO nal_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A ravin ka uli xula vaal zina ma xa raamin natifna xa itate la wina iban, ma a zapalaau xa vataling fanong naan. ");
INSERT INTO nal_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Naanaan Iesu xa vataling a bina angkanaan lapaara bina laba Taair ma xa bilaas a bina laba Saaidon ma xa waan kula Laman Gaalili ma xa balas la pira Dekaapolis ma xa iziar inaan. ");
INSERT INTO nal_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Inaan la non angkanaan aubina di zaxot fawat aza rapti zin Iesu. A rapti angkanaan alngana xa bat ma a ngusna xa po. Ma di maainung Iesu xuna xana rasin uru mitna wana a rapti. ");
INSERT INTO nal_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu xa zaxot parok a rapti angkanaan siaana a xulutung, ma xa rasin amun klusmitna la ulngana rapti, xa kaanis ma xa xaaf a xaramana a rapti. ");
INSERT INTO nal_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Naan ka raamaai uzaa laaxur la lia ma xa maabus dikdik ma xa piaat sin a rapti naako, “Efataa!” (Aknaas a dorang adu, “Gu ralakas!”). ");
INSERT INTO nal_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Fazaaus mase ulngana rapti xa ralakas ma a xaramana xa rapalas ma a rapti xa dador daxa. ");
INSERT INTO nal_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu xa pitkol naandi adu tuaa dina vazei taxazak. Singsaxai araan ka pitkol naandi, xawit di langar zin Iesu, a dorang ka valaau varawuk. ");
INSERT INTO nal_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma naandi vaakdul ina di langarin azaan angkanaan, di banglala marazaat mase ma di piaat, “Amun saan faakdul naa giu, naa giu vatalamin mase. Naan ka vira zaait nanga amun linga bat dina langar ma amun ngus po dina dador.” ");
INSERT INTO nal_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Laza raan kaarik axulutung ka wat fatu. Ma xawit di rauxin tazaan kuna iaanang. Ma Iesu xa viring fawat ubina varaviraai zina ma xa piaat malasing kari, ");
INSERT INTO nal_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ga maluf aubina angkari wanaze di iziar vaanong faraxai wana nia wana a raan urul. Ma xawit ta vanganang naadina iaan. ");
INSERT INTO nal_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma tamon gana kling pizin naandi xula bina zin naandi varaxai wana lagaaiang, azanon sin naandi dina zumaat la lan panaze di wat pana a lan baraaf.” ");
INSERT INTO nal_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma ubina varaviraai zina di xis naan malasing kari, “A non angkari xa bingil, ma dina zuruk a raraba xat faraxas kuna vavangaanang naandi vaa?” ");
INSERT INTO nal_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Iesu xa iaari zin naandi naako, “Usfa raraba naagu rauxin?” Di xis naan malasing kari, “A raraba xa wizik urua.” ");
INSERT INTO nal_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu xa vazei axulutung kuna iziarang paanaburut pana pira. Naan ka zuruk amun raraba xa wizik urua ma xa wisfaadaxa zin Nakmai ma naa biaak. Naa lis sin ubina varaviraai zina xuna vatawaraxinang pana aubina. Ma naadi giu malasing naa piaat. ");
INSERT INTO nal_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Di rauxin a kaana ian saait. Naan ka wisfaadaxa zaait pana ma xa vazei ubina varaviraai zina xuna vatawaraxinang pana aubina. ");
INSERT INTO nal_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aubina di vangan ma di maazur. Lamuraana di vangan faanong, ubina varaviraai di waaturin amun kibaala vanganang ma di sfaar vambos amun laxa xa wizik urua. ");
INSERT INTO nal_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A furavin, a funalik ma ubina, naandi vaakdul di ra vangan. Di vakot ubina ma xa malasing a taausan urulavaat. Naanaan Iesu xa kling pizin naandi, ");
INSERT INTO nal_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma xa xawaas a mon faraxai wana ubina varaviraai zina ma di kaaul la Laman Gaalili xula aza non pira in Daalmanutaa. ");
INSERT INTO nal_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Amun Faarasi di wat ma dit faramakalaai varaxai wana Iesu. Di saxot dina lalaamangaain naan ma di iaari zina xuna xana vatangin ta vaamuzazang ka banglala malasing a vaakilanang adu Nakmai xa kling fawat naan. ");
INSERT INTO nal_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu xa maabus dikdik ma xa piaat naako, “Kunaze a watkul ila raan angkari taning di saxot dina raamin ta vaakilanang? Ga piaat faratunaan, gana wen fatangin ta vaakilanang.” ");
INSERT INTO nal_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Naan ka luaa naandi ma xa xawaas a mon ma xa kas buak kula aza non ritita Laman Gaalili. ");
INSERT INTO nal_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ubina varaviraai di naxambain kuna zurukang a raraba. Ma xa rauxin a raraba azaxai be xa iziar lamaskana a mon. ");
INSERT INTO nal_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu xa vazei vadikdik naandi naako, “Naagu naknakaai, naagu raamaai daxa wana a is sin amun Faarasi ma zin Erot.” ");
INSERT INTO nal_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ubina varaviraai di dadorin azaan angkanaan lawalaua naandi nanga ma di piaat malasing kari, “Naan ka piaat malasing kari wanaze dia xawit di rauxin a raraba.” ");
INSERT INTO nal_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu xa rexaazin aze razaan naadi dadorin ma xa iaari zin naandi naako, “Kunaze naagu ipiaat kawit a raraba? Kawit nanga naagu raamaai vaakilan ma xawit saait naagu mazaam? A maskana nim nanga xa dikdik? ");
INSERT INTO nal_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Malasing faa, naagu rauxin a marana nim singsaxai xawit nat faraxas naaguna raamaai vaakilan? Ma malasing faa, naagu rauxin alngana nim singsaxai xawit nat faraxas naaguna langar? Ma malasing faa, xawit nat faraxas naaguna naxaam faulin? ");
INSERT INTO nal_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Araan ga biaak a raraba xa watmit aaxan aubina xa taausan ka watmit, usfa laxa naagu sfaar vambos pana akbaala vanganang?” Ma ubina varaviraai di piaat malasing kari, “Ka zangaaflu ma urua.” ");
INSERT INTO nal_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma Iesu xa piaat naako, “Ma araan ga biaak a raraba xa wizik urua aaxan aubina xa taausan urulavaat, usfa laxa naagu sfaar vambos pana akbaala vanganang?” Di xis naan malasing kari, “Ka wizik urua.” ");
INSERT INTO nal_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma xa iaari zin naandi naako, “Malasing faa, xawit nanga naagu mazaam?” ");
INSERT INTO nal_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu ma ubina varaviraai zina di balas la bina Betsaaida ma azanon aubina di zaxot fawat aza rapti uru marana varaxai di wif iaa. Ma di maainung Iesu xuna xana rasin a mitna wana naan kuna xana raamaai. ");
INSERT INTO nal_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesu xa taaxur la mita rapti ma xa vindaan naan kula manar ziaana bina. Naan ka kanis a marana a rapti ma xa rasin uru mitna laru marana. Ma araan ka waapizin uru mitna, xa iaari zin a rapti naako, “Gu raamin ta zaan?” ");
INSERT INTO nal_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A rapti xa raamaai uzaa laaxur ma xa piaat naako, “Ga raamin aubina, ma di raamaai malasing amun iaai di zazangas farawuk.” ");
INSERT INTO nal_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Faazaxai xaarik Iesu xa rasin uru mitna lamarana a rapti. Ma araan ka waapizin uru mitna, umarana di ralakas iaa. Ka raamaai daxa xa ma xa raamin fakilaan amun saan faakdul. ");
INSERT INTO nal_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu xa kling naan kula vaal zina ma xa vazei naan naako, “Tuaa gu waan lamaskana bina.” ");
INSERT INTO nal_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu ma ubina varaviraai zina di waan lamun bina di iziar varawuk lapaara bina laba Sesaria Filipaai. Araan di zazangas la lan Iesu xa iaari zin naandi naako, “Aubina di piaat nia nis?” ");
INSERT INTO nal_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Di xis naan malasing kari, “Azanon di piaat nua Jon A Rapti Iwana Baaptaaizang ma azanon di piaat nua Elaaija ma azanon di piaat nua azaxai zin amun profet i mumua.” ");
INSERT INTO nal_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iesu xa iaari xaarik sin naandi naako, “Ma nim, naagu naxaam adu nia nis?” Ma Pita xa xis naan naako, “Nua a Mesaaia.” ");
INSERT INTO nal_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesu xa dador dikdik sin naandi adu tuaa dina vazei taxazak pana. ");
INSERT INTO nal_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iesu xa varumara xuna viraaiang ubina varaviraai zina adu Naata Rapti xana vazaak a maazikang pana amun saan ka varas. Amun paamua zin amun Judaa, ma amun pris laba ma amun maravas iwana amun Lus sin Moses dina bain naan ma dina zop famaat naan. Ma lamuraana a raan urul naan kana ramaraat puli xaarik. ");
INSERT INTO nal_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesu xa dador la maravas pana amun saan angkanaan, ma Pita xa zaxot naan siaana ubina varaviraai zina ma xa vadawaar naan pana azaan naa piaat. ");
INSERT INTO nal_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Singsaxai araan Iesu xa rutaawuk ma xa raamin ubina varaviraai zina, xa vadawaar Pita naako, “Saatan, paan siaagu! Kawit gu rauxin ainaxamang pana aze ramun saan Nakmai xa saxot gana giu, singsaxai aze aubina ila pira angkari di saxot.” ");
INSERT INTO nal_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naan ka viring fawat a xulutung faraxai wana ubina varaviraai zina ma xa piaat naako, “Tamon axazak ka saxot kana los nia, xana naxaam pizin naan nanga ma xana vazaak a robuxul zina ma xana los nia. ");
INSERT INTO nal_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ma tamon axazak ka saxot be xana roting falagot a roroiang sina, a roroiang sina xana milung. Singsaxai tamon axazak ka lis psin a roroiang sina xu nia ma a Dorang Daxa zin Nakmai zaait, Nakmai xana zaxot faulin naan. ");
INSERT INTO nal_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Avuna axazak ina xa rauxin amun saan faakdul naa saxot la pira angkari singsaxai a roroiang sina xa milung ma xa waan la bina iwana adi xaiaf kawit nai maat, aze ra daxaiang amun saan angkanaan kana lis sina? ");
INSERT INTO nal_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Naan kana xul a roroiang kanaan sina wanaze? ");
INSERT INTO nal_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tamon axazak ka maangil wana nia o wana a dorang surugu lamaskana a watkul i taning, di lis a tora naandi zin Nakmai ma di gigiu amun matmalabuk taksaat, Naata Rapti zaait kana maangilin axazak angkanaan araan naan kana balas faraxai wana amun aangelo xoxok lamaskana a marmari daxaiang sin Damana.” ");
INSERT INTO nal_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma Iesu xa vazei naandi naako, “Ga piaat faratunaan sinim, azanon sinim di irur xari, dina wen maat nanga xa ruaas dina raamin a bikabar zin Nakmai xana balas faraxai wana dikdikang.” ");
INSERT INTO nal_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lamuraana a raan ka wizik saaxa Iesu xa zaxot Pita ma Jems ma Jon, ma xa valos fauzaa nandiaal xu la aza waatawut ka uzaa mase laaxur. Di wa iziar naandi zingbe inaan. Ma la non angkanaan a winpina Iesu xa xulxulaai lamarana nandiaal. ");
INSERT INTO nal_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Amun marapi zina xa xufkuf mase ma xa wilwilak. Awat kufkuf angkanaan, kawit taxazak ila pira angkari xat faraxas kana pot faxufkuf a marapi malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma ubina varaviraai angkanaan urul di raamin taal Elaaija ma Moses di balas iaa ma di dador varaxai iaa wana Iesu. ");
INSERT INTO nal_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma Pita xa vazei Iesu naako, “Maravas, ka daxa wana nimtaal maadi iziar raal iriat. Maadina varur a vaal maling urul, axazak aaxanum ma axazak aaxan Moses ma axazak aaxan Elaaija.” ");
INSERT INTO nal_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita xawit na rexaas aze naana piaat panaze naan ma Jems ma Jon di maraaut taal mase. ");
INSERT INTO nal_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naanaan a vang bara xa balas ma xa vakuf kol naandi ma alinga axazak ka dador lamaskana bara naako, “Naan kari Naarugu, ga sasaxot naan. Naagu langar raal zina!” ");
INSERT INTO nal_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Fazaaus mase di raamaai varawuk taal ma xawit kaarik di raamin taxazak, Iesu zingbe varaxai wana nandiaal. ");
INSERT INTO nal_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Araan di kabal wizik paanaburut la waatawut, Iesu xa dador dikdik sin nandiaal adu tuaa dina vazei raal taxazak pana aze razaan naadi ra raamin, ka ruaas Naata Rapti xana ramaraat puli wana maatang. ");
INSERT INTO nal_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Azaan angkanaan ka iziar zin nandiaal nanga ma di iaari raal lawalaua nandiaal nanga malasing kari, “Aze ra aknaaza dorang ‘ramaraat puli wana maatang?’ ” ");
INSERT INTO nal_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Di iaari raal zin Iesu malasing kari, “Kunaze ma amun maravas iwana amun Lus sin Moses di piaat Elaaija xana tabung balas paamua wana a Mesaaia?” ");
INSERT INTO nal_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu xa xis nandiaal naako, “Ka vaaratunaan mase, a Baar Xoxok ka piaat Elaaija xana balas paamua ma xana waafatok amun saan faakdul. Singsaxai xunaze di varaar vating lamaskana a Baar Xoxok adu Naata Rapti xana vazaak adi maazikang laba ma aubina dina bain naan? ");
INSERT INTO nal_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Singsaxai ga vazei numtaal, Elaaija xa balas faanong, ma naandi di giu amun saan faakdul naadi saxot pana naan, malasing be a dorang di varaar vating lamaskana a Baar Xoxok ka piaat pana naan.” ");
INSERT INTO nal_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Araan Iesu ma ubina varaviraai zina urul di wat balas sin uza ubina varaviraai, di raamin axulutung ka irur varaxulin naandi. Ma amun maravas iwana amun Lus sin Moses dit faramakalaai varaxai wana naandi. ");
INSERT INTO nal_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Araan bani aubina vaakdul di raamin Iesu, di banglala mase ma di valaau waan ma di ruzuaai naan. ");
INSERT INTO nal_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu xa iaari zin ubina varaviraai zina naako, “Aze razaan naagu varamakalaai wana varaxai wana naandi?” ");
INSERT INTO nal_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aza rapti lamaskana axulutung angkanaan ka xis naan naako, “Maravas, ga zaxot fawat naarugu zunum, a zapalaau xa ragul naan ma xawit nat faraxas kana dador. ");
INSERT INTO nal_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma araan kat suruk naan, kai psin naan paanaburut pana pira. A busbuzak ka uwat la balana ma xat karaat alvana ma a wina xai dikdik faakdul. Ga maainung ubina varaviraai zunum kuna mof pizinang a zapalaau ziaana, singsaxai xawit dit faraxas.” ");
INSERT INTO nal_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu xa xis naandi malasing kari, “Nim a watkul i taning, kawit naagu inaxam paazaai. Usfa raan nanga gana iziar varaxai wana nim, ma naaguna iziar nanga malasing kari? Usfa raan nanga gana vamalmalin nim faraxai wana amun matmalabuk taksaat sinim? Saxot fawat a nalik iriat surugu.” ");
INSERT INTO nal_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Malasing ma di zaxot fawat a nalik sin Iesu. Araan a zapalaau xa raamin Iesu, fazaaus mase xa psin a nalik paanaburut pana pira ma a nalik ka plaas farawuxin naan ma a busbuzak ka balas la balana. ");
INSERT INTO nal_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu xa iaari zin damana a nalik naako, “Lasang azaan angkari xa balas sina?” Naan ka xis Iesu naako, “Araan ka nalik mumut nanga. ");
INSERT INTO nal_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Amun taan ka varas kai psin naan lamaskana xaiaf o lamaskana daanim kuna zop famaatang naan. Singsaxai tamon kat faraxas guna giu tazaan, maluf nimaa ma fawaal nimaa.” ");
INSERT INTO nal_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu xa piaat sina naako, “Kunaze gu piaat malasing kari, ‘Tamon kat faraxas guna giu tazaan’? Amun saan faakdul xat faraxas sin axazak ka inaxam paazaai.” ");
INSERT INTO nal_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Fazaaus mase damana a nalik ka viraai laba naako, “Ga inaxam paazaai, fadikdik anan inaxam paazaaiang surugu!” ");
INSERT INTO nal_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu xa raamin adu axulutung di valaau wat sin naandi, ma xa vadawaar a zapalaau naako, “Nua a zapalaau gu vabalos alngambat ma a nguspo. Tukbilak siaana ma tuaa xaarik gu sfaar naan.” ");
INSERT INTO nal_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A zapalaau xa xupkup ma xa gisgizin a nalik ma xa tukbilak siaana. A nalik ka raamaai malasing adu xa maat ma amala di piaat malasing kari, “Ka maat fanong.” ");
INSERT INTO nal_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Singsaxai Iesu xa roting naan la mitna ma xa varamaraat naan ma xa rur. ");
INSERT INTO nal_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lamur Iesu xa albis la vaal ma ubina varaviraai zina di iaari vunfun sina malasing kari, “Kunaze ma xawit nat faraxas maadina mof pizin a zapalaau angkanaan?” ");
INSERT INTO nal_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu xa xis naandi naako, “Awat sapalaau angkanaan, kat faraxas be a matmalabuk iwana maainungang kana waapizin naan.” ");
INSERT INTO nal_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Di luaa a non angkanaan ma di zangas bilaas a pira Gaalili. Iesu xawit na saxot adu taxazak kana rexaazin naandi di iziar vaa, ");
INSERT INTO nal_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","wanaze naan kat firaai ubina varaviraai zina. Ka vazei naandi naako, “Dina ngutlis Naata Rapti la mita ubina ma dina zop famaat naan. Ma lamuraana a raan urul, naan kana ramaraat puli.” ");
INSERT INTO nal_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Singsaxai naandi xawit di mazaam aknaaza dorang sina ma di maraaut pana iaariang sina wana. ");
INSERT INTO nal_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iesu ma ubina varaviraai zina di balas Kaapernaaum. Araan di iziar la vaal, Iesu xa iaari zin naandi naako, “Aze razaan naagut faramakalaai wana la lan?” ");
INSERT INTO nal_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Singsaxai xawit di dador, wanaze la lan naandi di ra varamakalaai wana adu nis mase zin naandi xa laaup. ");
INSERT INTO nal_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu xa iziar wizik paanaburut ma xa viring luk fawat azangaaflu ma urua ubina varaviraai zina ma xa vazei naandi naako, “Tamon axazak ka saxot kana waamua, naan kana rasin naan mase mur ma xana iaana kilaaiang sin aubina vaakdul.” ");
INSERT INTO nal_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iesu xa zaxot aza nan nalik ma naa varur lawalaua naandi. Ka rot fawat a nalik lawaana bibina, ma xa vazei naandi naako, ");
INSERT INTO nal_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tamon axazak ka ruzuaai awat nalik mumut malasing kari wana aizinugu, naan ka ruzuaai nia. Ma axazak ka ruzuaai nia, xawit na ruzuaai nia singsaxai xa ruzuaai axazak ka kling fawat nia.” ");
INSERT INTO nal_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ka piaat naako, “Maravas, maadi raamin aza rapti xa mof pizin amun sapalaau wana aizinum, ma maadi wisbuaak naan panaze naan kawit azaxai zin dia.” ");
INSERT INTO nal_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu xa xis naan naako, “Tuaa naagu wisbuaak naan. Axazak ina xat fabalos a vaamuzazang ka banglala wana aizinugu naan kana wen piaat fazaaus ta dorang taksaat pana nia. ");
INSERT INTO nal_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Avuna axazak ina xawit na purua wana dia, naan sin dia. ");
INSERT INTO nal_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ga vazei varatunaan nim, axazak ina xa ralaas nim pana a kaap daanim lamaskana aizinugu wanaze nim sin a Mesaaia, a wulwulang sina xana wen milung.” ");
INSERT INTO nal_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ma Iesu xa piaat kaarik naako, “Tamon axazak ka vaxalxaal azaxai zin a funalik mumut ina di inaxam paazaai wana nia xuna zuiang lamaskana a matmalabuk taksaat. A matmalabuk taksaat angkanaan ka raksaat mase wana tamon dina pis adi vaat la vuruna ma dina psin naan nana raas. ");
INSERT INTO nal_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Tamon a mirum kat faxalxaal nua xuna zuiang lamaskana a matmalabuk taksaat, kip pizin. Kana daxa tamon gu rauxin a mit azaxai ma gu albis lamaskana roro tapal wana gu rauxin a mit urua ma gu waan lamaskana a bina iwana adi xaiaf kawit nai maat. ");
INSERT INTO nal_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma tamon a xaakum kat faxalxaal nua xuna zuiang lamaskana a matmalabuk taksaat, kip pizin. Kana daxa tamon gu rauxin a xaak azaxai ma gu albis lamaskana roro tapal, wana gu waan lamaskana a bina iwana adi xaiaf kawit nai maat faraxai wana a xaak urua. ");
INSERT INTO nal_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma tamon a maraam kat faxalxaal nua xuna zuiang lamaskana a matmalabuk taksaat, gu bilok pizin. Kana daxa tamon gu rauxin a maraam azaxai ma gu albis lamaskana bikabar zin Nakmai wana gu rauxin a maraam urua ma di psin nua lamaskana a bina iwana adi xaiaf kawit nai maat, ");
INSERT INTO nal_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","a non ‘axonip ina xai iaan naandi xawit nai maat, ma xawit taxazak kat faraxas kana tus famaat axaiaf.’ ");
INSERT INTO nal_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Aubina vaakdul dina vazaak amun maazikang kuna amun matmalabuk sin naandi xana balas daxa malasing a talazang dit savur wana a rasmaxas ma dit faif. ");
INSERT INTO nal_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A rasmaxas ka daxa, singsaxai tamon a miaana xa vanong, naaguna mita ratasin faulin kaarik a miaana rasmaxas? Naagu zavur nim pana rasmaxas iwana aizi paasaxoiang ma naaguna iziar lamaskana a luaai lawalaua nim saksaxai.” ");
INSERT INTO nal_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu xa luaa a non angkanaan ma xa waan lamaskana pira Judia, ma xa kas buaak a daanim Jodaan. Axulutung di wat sina, ma xat firaai naandi wana dorang sin Nakmai, malasing a rataawukna. ");
INSERT INTO nal_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Azanon Faarasi di saxot dina vaxabebeu naan ma di wat iaari zina malasing kari, “Malasing faa, a amun Lus sin Moses ka rudaxain a rapti xana kip a maxuzang sina varaxai wana taak sina?” ");
INSERT INTO nal_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu xa xis naandi malasing kari, “Amun Lus sin Moses ka piaat aze?” ");
INSERT INTO nal_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma di piaat malasing kari, “Moses ka rudaxain a rapti xuna varaarang a baar iwana kipang a maxuzang sina ma xana kling pizin taak sina.” ");
INSERT INTO nal_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu xa vazei naandi naako, “A maskana nim ka dikdik malasing ma Moses ka varaar a lus angkanaan aaxan nim. ");
INSERT INTO nal_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Singsaxai la varumaraiang pana faaziarang Nakmai xa ‘vaziaar a rapti ma a ravin.’ ");
INSERT INTO nal_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Malasing ma naan avuvuna xanaan a rapti xana luaa damana ma dina ma xana daxat pana taak sina, ");
INSERT INTO nal_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma nandiaa, dina zaxai iaa la winpin.’ Ma xawit kaarik di urua iaa, di zaxai iaa xa. ");
INSERT INTO nal_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Malasing ma aze ra zaan Nakmai xa pis faraxin fanong, tuaa taxazak kana kip.” ");
INSERT INTO nal_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lamur Iesu varaxai wana ubina varaviraai zina di uli xula vaal, ma ubina varaviraai zina di iaari zina wana azaan angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma Iesu xa xis naandi malasing kari, “Tamon ta rapti xa kip a maxuzang sina varaxai wana taak sina ma xa maxus sin a ravin tawarak, naan ka giu a matmalabuk taksaat pana taak sina wana milivinang a ravin tawarak. ");
INSERT INTO nal_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Malasing be tamon a ravin ka kip a maxuzang sina varaxai wana labana, ma xa maxus sin a rapti rawarak, naan ka giu a matmalabuk taksaat iwana milivinang a rapti rawarak.” ");
INSERT INTO nal_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aubina di zazaxot fawat a funalik mumut sin Iesu xuna xana rasin uru mitna laaxur wana naandi. Singsaxai ubina varaviraai zin Iesu di vadawaar naandi. ");
INSERT INTO nal_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu xa raamin azaan angkanaan ma xa mangat. Ka vazei naandi naako, “Naagu luaa a funalik mumut dina wat surugu, tuaa naagu waakol naandi, wanaze a bikabar zin Nakmai zin aubina malasing a funalik mumut angkari. ");
INSERT INTO nal_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ga vazei varatunaan nim, axazak kawit na rudaxain a bikabar zin Nakmai malasing a funalik mumut, naan kana wen libis lamaskana.” ");
INSERT INTO nal_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iesu xa zaxot fawat a funalik lawaana bibina, ma xa rasin uru mitna wana naandi ma xa maainung sin Nakmai xuna xana lis a daxaiang sin naandi. ");
INSERT INTO nal_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu xa ramaraat ma xa waan. Araan ka zazangas, aza rapti xa valaau wat sina ma xa zibukaak lamarana Iesu ma xa iaari naako, “Maravas daxa, aze razaan gana giu xuna gana rauxin a roro tapal?” ");
INSERT INTO nal_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu xa xis naan naako, “Kunaze gu vakilaan nia daxa? Kawit taxazak ka daxa, Nakmai zingbe naan ka daxa. ");
INSERT INTO nal_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gu rexaazin fanong amun Lus: ‘Tuaa gu zop famaat axazak, ma tuaa gu milivin a ravin tawarak, ma tuaa gu vinaau, ma tuaa gu vaagit pana axazak, ma tuaa gu babof mara, ma gu nop damaam ma dinaam.’ ” ");
INSERT INTO nal_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A rapti angkanaan ka piaat naako, “Maravas, amun lus faakdul angkanaan ga valos araan nanga ga nalik mumut.” ");
INSERT INTO nal_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu xa damin naan ma xa sasaxot naan. Ma xa piaat sina naako, “Azaan azaxai nanga xawit gu rauxin. Gu waan ma gu vaangurin amun saan faakdul zunum ma a kaakaai iwana, gu ralaas naandi ina di izi gogof, ma guna rauxin amun lulugaan daxa ikula la lia. Mur gu wat los nia.” ");
INSERT INTO nal_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A rapti xa langarin ma a marana xa raawuk. Naan ka maskalus ma xa waan panaze xa rauxin amun lulugaan ka varas marazaat. ");
INSERT INTO nal_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu xa raamaai varawuk ma xa vazei ubina varaviraai zina naako, “Ka lagaf mase zin a raxumbaaxut kana albis lamaskana a bikabar zin Nakmai!” ");
INSERT INTO nal_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ubina varaviraai di banglala wana dorang sin Iesu. Singsaxai Iesu xa piaat kaarik naako, “Naam funalik, ka lagaf mase wana albizang lamaskana bikabar zin Nakmai! ");
INSERT INTO nal_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ka lagaf pana a kaamel xana albis lamaskana a luk iwana nil iwana zaxazitang amun marapi, singsaxai xa lagaf marazaat nanga wana a raxumbaaxut kana albis lamaskana a bikabar zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ubina varaviraai di banglala marazaat kaarik ma di iaari lawalaua naandi zaksaxai malasing kari, “Ma nis mase Nakmai xana zaxot faulin?” ");
INSERT INTO nal_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu xa damin naandi ma xa piaat naako, “Kawit axazak nat faraxas kana giu azaan angkanaan, singsaxai Nakmai naan kat faraxas. Nakmai xat faraxas kana giu amun saan faakdul.” ");
INSERT INTO nal_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita xa vazei naan naako, “Maadi vataling amun saan faakdul ma maadi los nua!” ");
INSERT INTO nal_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu xa piaat naako, “Ga piaat faratunaan sinim, tamon axazak ka vataling a vaal zina o amun daasna o amun fafina o damana o dina o a funalik sina o vataling amun uma zina xu nia ma a Dorang Daxa zin Nakmai, ");
INSERT INTO nal_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","naan kana zuruk pana roroiang ila notaan angkari, amun saan angkanaan ka zangaaflu varazuai laaxur wana ina naa tabung tauxin fanong, malasing amun faal o amun daasna o amun fafina o amun naanaa o a funalik o amun uma zina varaxai zaait pana amun maazikang lalozang a Dorang Daxa. Ma wana roroiang mur naan kana zuruk a roro tapal. ");
INSERT INTO nal_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Singsaxai amala aubina ina di waamua dina wat mur. Ma amala aubina ina di wat mur dina waamua.” ");
INSERT INTO nal_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu ma ubina varaviraai zina di zazangas paan ikula Jerusalem. Iesu xa waamuain naandi, ma ubina varaviraai zina di banga ma aubina di las lamuraana di maraaut. Ka zaxot parok kaarik a zangaaflu urua ubina varaviraai zina ma xa vazei naandi wana aze ra amun saan kana balas sina. ");
INSERT INTO nal_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Naan ka piaat naako, “Dia dina uzaa xari ikula Jerusalem ma axazak kana ngutlis Naata Rapti zin amun pris laba ma amun maravas iwana amun Lus sin Moses. Dina varur naan pana dorang ma xana vazaak a maazikang kuna xana maat, ma dina lis naan la mita aubina xawit amun Judaa, ");
INSERT INTO nal_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ma dina vis naan, ma dina kanis naan, ma dina kmis naan pana wip, ma dina zop famaat naan. Ma la muraana a raan urul naan kana ramaraat puli wana maatang.” ");
INSERT INTO nal_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naanaan Jems ma Jon, uru naata Zebedi, di wat iaa zin Iesu ma di piaat iaa zina malasing kari, “Maravas maadi saxot iaa guna giu aze razaan maadi maainung iaa nua wana.” ");
INSERT INTO nal_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu xa iaari zin nandiaa naako, “Aze razaan naagu saxot iaa gana giu aaxan numaa?” ");
INSERT INTO nal_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Di xis iaa naan malasing kari, “Araan gu iziar wana akin siziarang sunum lamaskana a bikabar zunum ka marmari daxa, guna vaziaar axazak sin nimaa la mit sazaxa ma axazak la mit kais sunum.” ");
INSERT INTO nal_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma Iesu xa piaat sin nandiaa naako, “Kawit naagu rexaazin iaa aze naagu maainung iaa. Malasing faa, xat faraxas guna imin iaa wana a win imiminang ina nia gana imin pana? Ma xat faraxas guna zuruk iaa a baaptaaizang iwana maazikang malasing nia gana zuruk?” ");
INSERT INTO nal_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Di xis iaa naan malasing kari, “Maadit faraxas iaa.” Ma Iesu xa vazei nandiaa naako, “Guna imin iaa wana a win imiminang ina nia gana imin pana, ma guna zuruk iaa a baaptaaizang iwana maazikang malasing nia gana zuruk. ");
INSERT INTO nal_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Singsaxai wana aiziarang la mit sazaxa ma la mit kais surugu xawit ga rauxin a burburaaiang kuna gana lis. Nakmai xana lis sin aubina naa kalin tasin fanong.” ");
INSERT INTO nal_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Araan azangaaflu ubina varaviraai di langarin, di mangat pana Jems ma Jon. ");
INSERT INTO nal_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu xa viring fatu naandi ma xa vazei naandi naako, “Naagu rexaas adu amun paamua zin aubina xawit amun Judaa di rauxin a burburaaiang laba laaxur wana naandi ma dit falaup naandi nanga ma di itingar lawaata naandi. ");
INSERT INTO nal_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Singsaxai wana nim kawit. Tamon axazak ka saxot adu naan kana laaup lawalaua nim, naan kana vamumut naan nanga ma xana iaana kilaaiang sinim. ");
INSERT INTO nal_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma axazak ka saxot kana waamua, naan kana iaana kilaaiang sin aubina vaakdul. ");
INSERT INTO nal_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Avuna Naata Rapti zaait nanga xawit na wat kuna dina vaamuzas aaxana, xawit. Singsaxai naan ka wat kuna vaamuzazang aaxan aubina. Naan kana lis a roroiang sina saxotang aubina vaakdul malasing a vaaxaramang aaxana amala aubina.” ");
INSERT INTO nal_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Naanaan Iesu ma ubina varaviraai zina di wat la bina laba Jeriko. Di luaa a bina laba angkanaan faraxai wana adi mala aubina. Aza rapti a marawif, aizina xanaan Baatimaais (aknaaza dorang kari adu naata Timaais), ka iziar lapaara lan ma xat nungnung. ");
INSERT INTO nal_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ka langar adu Iesu in Naazaret ka wat ma xa xupkup naako, “Iesu, a Natnaat Sin Dewit, gu maluf nia!” ");
INSERT INTO nal_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Amala di vadawaar naan ma di vazei naan kana ziburung, singsaxai xa vut kupkup nanga naako, “A Natnaat Sin Dewit, gu maluf nia!” ");
INSERT INTO nal_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu xa rur ma naako, “Naagu viring fawat naan.” Di viring fawat a marawif ma di piaat malasing kari, “Gu nanam! Tamaraat! Naan ka viring nua.” ");
INSERT INTO nal_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Fazaaus mase Baatimaais ka waapizin a marapi baraaf ila winpina lamanar ma xa ramaraat fazaaus ma xa wat sin Iesu. ");
INSERT INTO nal_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma Iesu xa iaari zina naako, “Aze razaan gu saxot gana giu aaxanum?” Ma a marawif naako, “Maravas, ga saxot gana raamaai.” ");
INSERT INTO nal_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu xa vazei naan naako, “Paan, ainaxam paazaaiang sunum ka vira vanong nua.” Fazaaus mase a marana xa daxa ma naan ka raamaai, ma xa los Iesu la lan. ");
INSERT INTO nal_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesu varaxai wana ubina varaviraai zina di wat lapaara Jerusalem, ma di balas Betfaage ma Betani la Waatawut Olif. Iesu xa saxot kana kling uru rapti varaviraai zina, ");
INSERT INTO nal_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma xa vazei nandiaa naako, “Gu waan iaa la bina xa iziar waamua wana numaa. Ma araan naagu balas iaa, naaguna tangin iaa aza naata dongki inaan di pis fating naan, kawit nanga taxazak nat kawas pana. Gu akpaat pizin iaa a iaarus pana ma naagu zaxot fawat iaa naan iriat. ");
INSERT INTO nal_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tamon taxazak kana iaari zunumaa malasing kari, ‘Kunaze gu giu iaa azaan angkanaan?’, naagu vazei iaa naan malasing kari, ‘A Piran ka saxot kalaak ma xana lis faulin fazaaus kaarik.’ ” ");
INSERT INTO nal_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naanaan di waan iaa ma di tangin iaa a naata dongki xa irur lapaara lan, di pis fating naan lapaara mara iwana aza vaal. Ma di akpaat iaa a iaarus pana. ");
INSERT INTO nal_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Azanon aubina di irur lapaara dongki di iaari zin nandiaa malasing kari, “Kunaze naagu akpaat iaa a naata dongki angkanaan?” ");
INSERT INTO nal_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Di xis iaa naandi malasing Iesu xa ra vazei nandiaa, ma aubina di luaa nandiaa ma di waan iaa. ");
INSERT INTO nal_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Di zaxot fawat iaa a naata dongki zin Iesu ma di rasin iaa amun marapi baraaf sin nandiaa laaxur wana, ma Iesu xa iziar wana. ");
INSERT INTO nal_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Amala aubina di gamul psin amun marapi baraaf naadit falaak kol a mamaauzang sin naandi wana, ma di zawarin la lan. Ma azanon di tok amun tangtangaana amun baibaai ma naadi rasin la lan. ");
INSERT INTO nal_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma naandi di zangas paamua ma naandi di wat lamur di xupkup malasing kari, “Osaanaa!” “A daxaiang ka waan sina ina xa wat pana aizina a Piran!” ");
INSERT INTO nal_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“A daxaiang ka waan la bikabar zin damana dia Dewit ina xana balas! Osaanaa ikula mase laaxur!” ");
INSERT INTO nal_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu xa albis Jerusalem, ma xa albis lamaskana a rabaraau ila vaal xoxok, ma xa raamaai varawuk pana amun saan faakdul, singsaxai a iaas kai si, malasing ma Iesu xa tukbilak ma xa waan Betani varaxai wana azangaaflu ma urua ubina varaviraai zina. ");
INSERT INTO nal_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A raan lamuraana, di luaa Betani, ma Iesu xa lagaai. ");
INSERT INTO nal_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Naan ka raamin aza iaai a fik ka irur lawalaau vaamumut ma xa rauxin a waxana xa varas. Iesu xa waan faasilik lapaara iaai xuna xana raamin tamon ka vuai. Singsaxai xawit na raamin ta vuaaina laaxur wana a iaai. Amun paxana be, wanaze xawit a raan iwana amun iaai a fik kuna vuaiang. ");
INSERT INTO nal_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma Iesu xa vadawaar a iaai a fik naako, “Guna wen fuai xaarik ma aubina dina wen fangan pana nua. Kawit mase.” Ma ubina varaviraai zina di langarin a dorang kanaan. ");
INSERT INTO nal_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iesu varaxai wana ubina varaviraai zina di balas Jerusalem. Iesu xa albis la rabaraau ila vaal xoxok ma xa vut pizin aubina dit faangur ma dit pulwul inaan. Ka wukfukin amun iban taasmaaiang sin aubina dit kulxulaai kaakaai ma amun siaa zin naandi dit faangurin amun baalus. ");
INSERT INTO nal_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma xa pitkol naandi, tuaa dina vazaak amun saan iwana vaangurang sin naandi ma dina lu la rabaraau ila vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naan ka vazei naandi naako, “Di varaar vating lamaskana a Baar Xoxok malasing kari, ‘A vaal zurugu dina vakilaan a vaal a maainungang sin amun lemlem aubina vaakdul.’ Singsaxai naagu xul ma xa balas malasing ‘a non funfun sin amun finaau!’ ” ");
INSERT INTO nal_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Amun pris laba ma amun maravas iwana amun Lus sin Moses di langarin ma di zaleng ta lan kuna zop famaatang Iesu, avuna di marauring naan, panaze aubina vaakdul di banglala wana amun faraviraaiang sina. ");
INSERT INTO nal_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","A iaas kai si ma Iesu varaxai wana ubina varaviraai zina di luaa Jerusalem ma di waan. ");
INSERT INTO nal_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Paanaraan mase, Iesu varaxai wana ubina varaviraai zina di zazangas la lan ma di raamin a iaai a fik ka maraang faanong, la xatkadorna ma xa uzaa laaxur lamun paxana. ");
INSERT INTO nal_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita xa naxaam faulin azaan angkanaan ma xa piaat sin Iesu naako, “Maravas, taamin! A iaai a fik gu vadawaar, naari xa maraang faanong.” ");
INSERT INTO nal_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma Iesu xa xis a dorang sina naako, “Naagu inaxam paazaai wana Nakmai. ");
INSERT INTO nal_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ga vazei varatunaan nim, tamon taxazak kana vazei a wut angkari naako, ‘Tamaraat, ma gu fida wizik ku nana raas,’ ma xawit na rauxin ainaxamang urua, singsaxai xa inaxam paazaai wana aze ra zaan naa piaat, kana balas malasing naa piaat. ");
INSERT INTO nal_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Malasing ma ga vazei nim, aze ra zaan naagu iaariin pana maainungang, naagu inaxam paazaai adu naagu zuruk fanong ma xana balas sinim. ");
INSERT INTO nal_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Araan naagu irut maainung ma naagu naxaam axazak ka ra varaksaat nim, naagu naxaam pizin a matmalabuk taksaat sina, xuna damana nim la lia xana naxaam pizin amun matmalabuk taksaat sinim.” ");
INSERT INTO nal_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iesu varaxai wana ubina varaviraai zina di balas kaarik Jerusalem. Ma araan Iesu xa zazangas lamaskana rabaraau ila vaal xoxok, amun pris laba ma amun maravas iwana amun Lus sin Moses ma amun paamua zin amun Judaa di wat sina. ");
INSERT INTO nal_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Di iaari zina malasing kari, “Gu zuruk a burburaaiang kanaan faa ma gu giu amun saan angkanaan? Ma nis ka lis a burburaaiang sunum kuna giuang a vaamuzazang kanaan?” ");
INSERT INTO nal_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma Iesu xa xis naandi naako, “Gana iaari xalaak sinim pana aza iaariang. Naagu xis nia. Naanaan gana vazei nim pana a burburaaiang inifaa ga gigiu amun saan angkanaan pana. ");
INSERT INTO nal_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Araan Jon ka ra baaptaais aubina, malasing faa, naagu naxaam adu a burburaaiang ila lia o xa wat sin aubina be? Naagu vazei nia.” ");
INSERT INTO nal_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Di xulus lawalaua naandi nanga ma di piaat malasing kari, “Tamon dina piaat malasing kari, ‘A burburaaiang ila lia,’ naan kana iaari zin dia naako, ‘Naanaan kunaze xawit naagu inaxam paazaai wana dorang sina?’ ");
INSERT INTO nal_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Singsaxai tamon dina piaat malasing kari, ‘Ka wat sin aubina,’ amala aubina dina purua wana dia.” (Di maraaut pana aubina, wanaze aubina vaakdul di inaxam paazaai adu Jon naan a profet faaratunaan.) ");
INSERT INTO nal_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Naanaan di xis Iesu malasing kari, “Maadi wetexaas.” Ma Iesu xa piaat naako, “Ma nia zaait gana wen fazei nim pana nis ka lis a burburaaiang surugu xuna giuang amun faamuzazang kanaan.” ");
INSERT INTO nal_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ma Iesu xa varumara dadorang pana amun paamua angkanaan pana amun dorang lalaamangaai. Ka piaat malasing kari, “Aza rapti xa vazu auma waain, ma naa pai xol wana balavaat. Ma lamaskana auma waain angkanaan, ka xaaf a luk aaxan naandi xuna wasfamemang amun fnuaaia waain kuna zurukang a daanim ilamaskana. Ma xa varur anan faal xa irur vaatak puzaa laaxur xuna axazak kana iziar wana ma xana rataamaai xaaul wana auma. Ka rasin la mita zanon ubina xuna naandi dina vaamuzas pana ma dina xatkatong ma dina isuruk kaakaai wana. Ma naan nanga xa waan laza bina xa lawalaau. ");
INSERT INTO nal_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","La flan faatak iwana mos turinang amun fnuaaia waain, damana auma xa kling aza iaana kilaaiang ka waan sin ubina dit faamuzas la uma. Ka saxot dina lis tazanon fnuaaia waain ila uma angkanaan sina malasing a wulwulang sina. ");
INSERT INTO nal_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Singsaxai ubina dit faamuzas la uma angkanaan di zaraak fating a iaana kilaaiang kanaan ma di zop faraksaat naan ma naadi kling pizin ma xa uli gof. ");
INSERT INTO nal_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naanaan damana auma xa kling kaarik aza iaana kilaaiang ka waan sin naandi, ma di wit naan la waatna ma di vamangil mase naan. ");
INSERT INTO nal_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ma xa kling kaarik nanga aza iaana kilaaiang, ma di zop famaat naan. Ma mur xa kling ka varas nanga, di zop faraksaat azanon ma di zop famaat azanon. ");
INSERT INTO nal_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ma azaxai be xa, xa iziar varaxai wana naan. Naan naatna zina ina naa sasaxot. Naa kling naan ka waan sin naandi, avuna xa piaat naako, ‘Dina nop naarugu.’ ");
INSERT INTO nal_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Singsaxai ubina dit faamuzas la uma di dador lawalaua naandi malasing kari, ‘A rapti angkanaan kana raumana amun saan faakdul zin damana. Dia dina zop famaat naan ma dina raumana auma waain angkari.’ ");
INSERT INTO nal_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Malasing ma di zaraak naan ma di zop famaat naan ma di psin fatukbilok naan ku lamanar wana auma. ");
INSERT INTO nal_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma aze xa damana auma waain angkanaan kana giu? Ga vazei nim, kana wat ma xana zop famaat ubina dit faamuzas la uma ma xana lis auma waain angkanaan sin uzanon ubina. ");
INSERT INTO nal_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Malasing faa, iaak kawit nanga naagu vakot a dorang kari lamaskana a Baar Xoxok? Ka piaat malasing kari, ‘A vaat ina aubina iwana gigiuang a vaal di bain pizin, naan kanaan ka balas a varumaraiang a vaat iwana vaal. ");
INSERT INTO nal_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A Piran nanga xa ra giu azaan angkanaan, ma xa daxa mase wana a rataamaaiang simaam.’ ” ");
INSERT INTO nal_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naanaan amun paamua di zaleng ta lan kuna zaraakang Iesu, wanaze di rexaas adu naan ka dador lalaamangaai be wana naandi. Singsaxai di maraaut pana adi mala aubina. Malasing ma di luaa naan ma di waan. ");
INSERT INTO nal_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lamur amun paamua di kling azanon Faarasi ma azanon ubina zin Erot di waan sin Iesu, adu dina vaxabebeu naan pana tazanon dorang kuna dina vakor naan pana. ");
INSERT INTO nal_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Di wat sina ma di piaat malasing kari, “Maravas, maadi rexaas, adu nua a rapti iwana dorang faaratunaan. Ma xawit gut marauring taxazak. Gui piaat a dorang azaxai zin aubina vaakdul, naapalaau naandi di rauxin aiza laba o naandi xawit ta iza. Gut firaai aubina wana matmalabuk sin Nakmai wana a dorang faaratunaan. Malasing faa, xa tak pana dina wul a taakis ka waan sin Siza o xawit? ");
INSERT INTO nal_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dia dina wul o xawit?” Singsaxai Iesu xa rexaas faanong adu di lalaamangaain naan pana iaariang ka vaagit. Malasing ma naan ka iaari zin naandi naako, “Kunaze adu naaguna vaxabebeu nia? Naagu lis fawat a denaarias ma gana raamin.” ");
INSERT INTO nal_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Di lis a kaakaai zina, ma xa iaari zin naandi naako, “A waroka nis kari? Ma a fararang pana nis kari?” Ma di piaat malasing kari, “Zin Siza.” ");
INSERT INTO nal_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma Iesu xa vazei naandi naako, “Aze razaan sin Siza, naagu lis sin Siza, ma aze razaan sin Nakmai, naagu lis sin Nakmai.” Amun paamua di langarin a dorang sina ma di banglala. ");
INSERT INTO nal_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Amun Saadusi di piaat adu aubina di maat faanong, dina wen tamaraat puli wana maatang. Di wat sin Iesu ma di iaari zina malasing kari, ");
INSERT INTO nal_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maravas, Moses ka varaar aza dorang aaxan dia malasing kari, tamon ta rapti xa maat fataling taak sina ma xawit na raxunalik, daaza rapti angkanaan kana zaxot a ravin ma dina maxus iaa xuna xana raxunalik lawaana aizina daasna ina xa maat faanong. ");
INSERT INTO nal_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aza raan ka rauxin amun fandaas ka wizik urua. A ruaan ka maxus sin aza ravin, ma a rapti angkanaan ka maat ma xawit na raxunalik. ");
INSERT INTO nal_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A varuaiang ka maxus kaarik sin a ravin angkanaan, ma naan saait ka maat fataling a ravin ma xawit na raxunalik. Ma xa malasing saait kanaan pana a varulang. ");
INSERT INTO nal_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Naandi vaakdul amun fandaas di wizik urua di maxus sina, singsaxai a ravin kawit na raxunalik lawaana naandi, ma di maat. Naanaan lamur a ravin saait ka maat. ");
INSERT INTO nal_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pana roroiang mur, araan aubina di maat faanong ma di ramaraat puli, a ravin angkari aaxan nis sin naandi? Avuna naandi vaakdul xa wizik urua di maxus sina.” ");
INSERT INTO nal_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu xa xis naandi naako, “A dorang sinim kawit na tak, panaze xawit naagu rexaazin a dorang lamaskana a Baar Xoxok ma wana a dikdikang sin Nakmai zaait. ");
INSERT INTO nal_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Araan amun maat di ramaraat puli, dina wen maxus kaarik. Kawit. Dina malasing be xa amun aangelo ila lia. ");
INSERT INTO nal_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lalozang amun maat dina ramaraat puli wana maatang, iaak kawit nanga naagu vakot a baar zin Moses, ka dador wana axaiaf pana a nan iaai ma Nakmai xa piaat sina naako, ‘Nia Nakmai zin Aabaraam, Nakmai zin Aaisaak ma Nakmai zin Jekop.’ ");
INSERT INTO nal_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Naan kawit Nakmai zin amun maat. Kawit. Naan Nakmai zin aubina di roro. Malasing ma a dorang sinim kawit mase na tak!” ");
INSERT INTO nal_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Azaxai zin amun maravas iwana amun Lus sin Moses, ka wat ma xa langarin amun Saadusi dit faramakalaai varaxai wana Iesu. Ma xa langarin Iesu xa xis fatalamin naandi, ma xa iaari zina naako, “Aze ra lus ka laaup pana amun lus faakdul?” ");
INSERT INTO nal_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu xa xis a dorang sina naako, “A lus ka laaup ka malasing kari, ‘Nim amun Israael naagu langar, a Piran sin dia Nakmai, naan singbe a Piran azaxai. ");
INSERT INTO nal_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Naaguna sasaxot a Piran, Nakmai zinim, pana maskana nim faakdul ma wana a laklagaaia nim faakdul ma wana a inaxamang faakdul zinim ma wana a dikdikang faakdul zinim.’ ");
INSERT INTO nal_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma a varuaiang a lus ka malasing kari, ‘Naaguna sasaxot amun paliaana nim malasing be naagu sasaxot nim nanga.’ Kawit taza lus ka laaup pana uru lus angkanaan.” ");
INSERT INTO nal_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A maravas iwana amun Lus sin Moses ka vazei Iesu naako, “Maravas, a dorang sunum ka daxa. Gu piaat faratunaan adu a Piran naan singbe Nakmai azaxai ma xawit kaarik taxazak. ");
INSERT INTO nal_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dia dina sasaxot naan pana maskana dia vaakdul ma wana a inaxamang faakdul zin dia ma wana a dikdikang faakdul zin dia. Ma dina sasaxot amun paliaana dia malasing di sasaxot dia nanga. Tamon di valos uru lus angkanaan, a matmalabuk angkanaan ka laaup pana lizang amun talazang dit faif suaai Nakmai ma amun sanon talazang farawuk saait.” ");
INSERT INTO nal_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu xa raamin adu a rapti xa dador varaxai wana a mazamang. Malasing ma xa piaat sina naako, “Kawit gu izi lawalaau wana a bikabar zin Nakmai.” Ma mur xawit kaarik taxazak na waan sina wana ta iaariang panaze di maraaut pana dina iaari zina. ");
INSERT INTO nal_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Araan Iesu xat faraviraai la rabaraau ila vaal xoxok, ka iaari naako, “Kunaze amun maravas iwana amun Lus sin Moses di piaat adu a Mesaaia naan a natnaat sin Dewit? ");
INSERT INTO nal_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A Laklagaai a Raabu xa vaxazanaai Dewit, ma Dewit ka piaat malasing kari, ‘A Piran Nakmai xa piaat sin a Piran surugu naako, “Gu iziar la mit sazaxa zurugu xa ruaas ga waramin amun purua zunum lawaana uru xaakum.” ’ ");
INSERT INTO nal_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewit nanga xa vakilaan a Mesaaia adu a Piran sina. Tamon ka malasing kanaan, malasing faa ma naan a natnaat sin Dewit?” Axulutung di nanam pana langarinang a dorang sin Iesu. ");
INSERT INTO nal_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu xat faraviraai ma xa piaat naako, “Naagu naknakaai wana amun maravas iwana amun Lus sin Moses. Di saxot dina zazangas farawuk pana amun marapi baraaf kuna vatanginang adu naandi di rauxin aiza laba. Ma di saxot aubina dina lis a varanopang laba zin naandi la amun non iwana balas fatuiang. ");
INSERT INTO nal_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma di saxot dina iziar lamun kin siziarang sin ubina laba lamaskana amun faal a maainungang sin amun Judaa ma di saxot saait dina iziar lamun kin siziarang sin aubina di rauxin aiza laba lamun flangan. ");
INSERT INTO nal_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Singsaxai dit fagit amun taksiziar ma dit suruk palau amun saan sin naandi. Ma dit fakilaan amun maainungang ka baraaf kuna aubina dina rataamin naandi. Uwat aubina angkari, dina zuruk a maazikang laba la raan iwana aikilizang.” ");
INSERT INTO nal_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu xa iziar lapaara non di ipsin a talazang pana lamaskana a rabaraau ila vaal xoxok, ma xa rataamin amala aubina di psin a kaakaai zin naandi. Amala aubina raxumbaaxut saait di pizaai ma di psin a kaakaai laba. ");
INSERT INTO nal_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Singsaxai aza raksiziar, xawit na rauxin tazaan, ka wat ma xa psin a kaakaai mumut urua. ");
INSERT INTO nal_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma Iesu xa viring fawat ubina varaviraai zina, ma xa piaat sin naandi naako, “Ga vazei varatunaan nim, a raksiziar angkanaan ka psin a kaakaai laba wana naandi vaakdul ina di pizaai. ");
INSERT INTO nal_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aubina raxumbaaxut di rauxin a kaakaai laba ma di psin be a non mumut iwana a kaakaai zin naandi. A ravin angkanaan kawit na rauxin tazaan singsaxai xa lis fakdul amun kaakaai zina. Kawit kaarik na rauxin ta kaakaai xuna wulang a vanganang aaxana.” ");
INSERT INTO nal_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Araan Iesu xa zazangas luaa a rabaraau ila vaal xoxok, aza rapti varaviraai zina xa piaat sina, naako, “Maravas, taamin amun faraang a vaal laba, di marmari daxa mase ma di giu wana amun faraang a vaat laba!” ");
INSERT INTO nal_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Iesu xa xis naan naako, “Gu raamin amun faal laba angkari? Amun purua dina wen luaa ta vaat kana iziar la butuaana taza vaat. Kawit. Dina urif pizin fawizik paanaburut.” ");
INSERT INTO nal_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu xa waan ma xa iziar varaxai wana ubina varaviraai zina la Waatawut Olif, ma xat faraxas dina raamin a vaal xoxok laza wut la rita naandi. Pita ma Jems ma Jon ma Endru naandi zingbe di iziar lapaara Iesu ma di iaari zina malasing kari, ");
INSERT INTO nal_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gu vazei maam, aze ra raan mase amun saan angkanaan kana balas? Ma aze ra wat faakilanang kana tabung balas, kuna maadina rexaazin adu amun saan faakdul angkanaan faasilik kana balas?” ");
INSERT INTO nal_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu xa vazei naandi naako, “Naagu naknakaai xuna tuaa taxazak kana vagit nim lalozang amun saan angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Amala aubina dina babof mara ma dina wat pana aizinugu ma dina piaat malasing kari, ‘Nia a rapti angkanaan, a Mesaaia,’ ma dina vagit amala. ");
INSERT INTO nal_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Araan naagu langar wana amun faropang laba ma a dorang ka valaau wana amun faropang laba xa ra balas, tuaa naagu inaxam farvaras. Amun saan angkanaan kana balas, singsaxai a pira angkari xana wen faanong nanga lamun taan angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aubina ilaza kaantri dina varop faraxai wana aubina ilaza kaantri rawarak, ma azanon saait dina giu malasing kanaan. Ma amun paamua ilaza bikabar dina varop faraxai wana amun paamua ilaza bikabar rawarak, ma azanon saait dina giu malasing kanaan. Kana rauxin amun maraulia xana gizin amun non ka varas ma xana rauxin amun song kana balas. Amun saan angkanaan ka malasing a varumaraiang a maazikang kat balas sin a ravin araan kana luk a popo. ");
INSERT INTO nal_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Naagu naknakaai daxa. Dina lis nim sin amun paamua ila bina ma dina kmis nim pana wip lamaskana amun faal a maainungang sin amun Judaa. Ma dina varur nim lamarana amun gaapman ma amun kalxaal zin naandi xu nia, ma naaguna vazei naandi wana nia. ");
INSERT INTO nal_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dina tabung fazei wana a Dorang Daxa zurugu ma amun lemlem aubina vaakdul dina langarin, naanaan a vaanongang iwana raan kana balas. ");
INSERT INTO nal_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Araan di zaraak nim, tuaa naagu inaxam farvaras pana aze razaan kuna piaatang pana a raan aikilizang. Naagu piaat be aze razaan a Laklagaai a Raabu xa vazei nim pana la raan angkanaan. Avuna xawit nim nanga naaguna dador, singsaxai a Laklagaai a Raabu. ");
INSERT INTO nal_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","A rapti xana ngutlis daasna zin amun purua ma xana vazei aubina dina zop famaat daasna, ma azanon saait dina giu malasing kanaan. Amun maamaa dina giu awat matmalabuk malasing kanaan pana a funalik sin naandi. Ma a funalik dina lis a tora naandi zin amun maamaa ma naanaa zin naandi ma dina ngutlis naandi zin amun purua ma dina zop famaat naandi. ");
INSERT INTO nal_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Aubina vaakdul dina maska raksaat pana nim avuna wana nia, singsaxai naan ina xa irur dikdik taning ka ruaas a raan a pira angkari xana vaanong, Nakmai xana zaxot faulin naan. ");
INSERT INTO nal_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Taza raan naaguna raamin ‘azaan ka mitikaai ina xat fawaan aubina ma dit falau vataling.’ Naan kana irur la aza non, a non angkanaan kawit sina. Araan naagu vakot a dorang kari, naagu mazaam fatalamin fanong! Nim ina naagu iziar Judia, naaguna valaau waan lamun paatawut! ");
INSERT INTO nal_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Axazak ka irur la waata vaal zina, araan kana kabal wizik paanaburut, tuaa xana albis la vaal xuna zurukang tazaan. ");
INSERT INTO nal_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma a rapti ina xa iziar la uma, tuaa xana uli xuna zurukang a marapi baraaf sina. ");
INSERT INTO nal_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lamun taan angkanaan kana lagaf mase wana a furavin di buxut ma a furavin dit faazus. ");
INSERT INTO nal_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Naagu maainung kuna tuaa amun saan angkanaan kana balas pana amun flan iwana milaatus, ");
INSERT INTO nal_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","panaze lamun taan angkanaan kana rauxin a maravanang laba mase. Mumua pis araan Nakmai xa vaziaar amun saan faakdul ma xa utuaas taning, awat maravanang angkanaan kawit nat balas. Ma mur zaait kanawit awat maravanang kanaan kana balas kaarik. ");
INSERT INTO nal_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tamon a Piran kana wen faxalxalif amun taan angkanaan aubina vaakdul dina milung. Singsaxai naan ka inaxam pana aubina naa kalin fanong aaxana nanga, malasing ma naan ka vaxalxalif amun taan angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lamun taan angkanaan tamon taxazak kana vazei nim naako, ‘Taamin, a Mesaaia xari,’ o ‘Taamin, naan boxo,’ tuaa ra inaxam paazaaiang pana. ");
INSERT INTO nal_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Uzanon aubina di balas ma dina dador vagit aubina malasing kari, ‘Nia a Mesaaia,’ o ‘Nia aza profet,’ ma dina vabalos amun faakilanang ma amun faaxoxovang. Naandi dina lalaamangaai xuna valos falmurang aubina zin Nakmai, ina naa kalin aaxana nanga, singsaxai xawit dit faraxas. ");
INSERT INTO nal_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Malasing ma naagu naknakaai. Ga vazei vanong nim pana amun saan faakdul xana balas.” ");
INSERT INTO nal_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Iesu xa piaat kaarik naako, “Amun taan iwana maravanang kanaan kana vaanong, ma lamuraana, ‘a iaas kana bungsuzuk, ma a flan kana wen ilap, ");
INSERT INTO nal_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ma amun patpada dina zu wat la bara, ma amun saan dikdik ila bara dina valvaaliang.’ ");
INSERT INTO nal_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","La raan angkanaan aubina dina raamin Naata Rapti xana wat pana bara varaxai wana a dikdikang laba ma adi marmari daxaiang sina. ");
INSERT INTO nal_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma naan kana kling amun aangelo zina dina waan, ma dina zaxot fatu aubina naa ra kalin aaxana nanga. Naandi dina zaxot naandi lamun non faakdul ila pira, varaxai wana amun non faakdul la bara ma nana mof.” ");
INSERT INTO nal_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iesu xa piaat kaarik naako, “Naagu langarin a varaviraaiang iwana a iaai a fik: Araan a rangtangaana xa baurivi uzaa ma amun paxana vaaxur xa balas, naagu rexaas adu amun flan iwana iaas ka vaasilik. ");
INSERT INTO nal_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Malasing saait, araan naagu raamin amun saan angkanaan ka balas, naagu rexaas adu a raan kana samura balas, malasing axazak ka irur lamarana mara xuna albizang. ");
INSERT INTO nal_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ga vazei varatunaan nim, araan aubina ila notaan taning kawit di maat nanga, amun saan faakdul angkanaan kana balas. ");
INSERT INTO nal_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Amun faaziarang faakdul xana vaanong, singsaxai a dorang surugu xana wen faanong.” ");
INSERT INTO nal_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iesu xa piaat kaarik naako, “Kawit taxazak na rexaas pana a raan angkanaan o a marana iaas araan amun saan angkanaan kana balas. Amun aangelo ila lia o Naatna zaait kawit na rexaas, Maamaa zingbe xa rexaas. ");
INSERT INTO nal_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Naagu raamaai daxa! Naagu naknakaai, wanaze naagu wetexaazin aze ra raan amun saan angkanaan kana balas. ");
INSERT INTO nal_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ka malasing a rapti xa luaa a vaal zina ma xa waan laza non. Naan ka vazei amun iaana kilaaiang sina xuna xatkatongang amun saan sina, ma xa lis a vaamuzazang sin naandi zaksaxai ma xa vazei a rapti xa irur la mara xana rataamaai xaaul. ");
INSERT INTO nal_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Malasing ma naagu rataamaai xaaul. Kawit naagu rexaas aze ra raan damana vaal xana uli wat, kana wat languzaraaf o la xunasuk o la raan auraa xa kaakaluk o paanaraan. ");
INSERT INTO nal_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tamon kana wat fazaaus, tuaa naagu luaa naan kana tangin nim naagu imilaaif. ");
INSERT INTO nal_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A dorang kanaan ga vazei nim pana, ga vazei aubina vaakdul malasing kari: Naagu rataamaai xaaul!” ");
INSERT INTO nal_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A raan urua nanga xa iziar xuna A Raan Laba Iwana Zangas Fasaalang ma a raan laba iwana A Raraba Xawit A Is kana balas. Ma amun pris laba ma amun maravas iwana amun Lus sin Moses di zazaleng ta lan kuna dina vagit Iesu ma dina zaraak burungin naan ma dina zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Di piaat malasing kari, “Dia dina wen giu azaan angkanaan la raan laba iwana lotu. Tamon aubina dina raamin dia, dina mangat ma adu dina varop.” ");
INSERT INTO nal_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu xa iziar la bina Betani la vaal zin aza rapti aizina xanaan Saaimon, ina waamua xa ra rauxin a tapak. Araan Iesu xa iziar la iban favanganang, aza ravin ka wat, ka vazaak a win di giu wana a waraxa. Ka rauxin a daanim milalas mikuf lamaskana. A daanim angkanaan di vakilaan a naad, ma a maraana xa laaup marazaat. A ravin ka biaak pizin a marana win angkanaan ma xa vukin a daanim milalas mikuf la waata Iesu. ");
INSERT INTO nal_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Azanon sin aubina di iziar inaan, di raamin ma di mangat, ma di dador lawalaua naandi nanga malasing kari, “Kunaze xa vanong palau a daanim milalas mikuf? ");
INSERT INTO nal_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Di lek faangurin, ma di lek suruk a wulwulang iwana a maariaas azaxai ma azanon taan nanga, ma a kaakaai di lek lis sin aubina di izi gogof.” Ma di vadawaar a ravin angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Singsaxai Iesu xa piaat naako, “Naagu luaa a ravin angkanaan, kunaze naagu vamosmos naan? Naan ka giu a matmalabuk daxa wana nia. ");
INSERT INTO nal_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aubina di izi gogof dina iziar bulaai varaxai wana nim, ma xat faraxas naaguna vawaal naandi lamun taan naagu sasaxot. Singsaxai nia gana wen iziar bulaai varaxai wana nim. ");
INSERT INTO nal_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A ravin angkari xa giu aze razaan naan kat faraxas naana giu. Ka vukin a daanim milalas mikuf la winugu xuna nimnimaninang nia wana a kaavaaiang surugu. ");
INSERT INTO nal_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ga vazei varatunaan nim, lamun non faakdul la pira angkari, araan aubina di ifazei wana a Dorang Daxa, azaan naa ra giu naadina ipiaat saait ma aubina dinat naxaam naan.” ");
INSERT INTO nal_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judaas Iskaariot, azaxai zin amun sangaaflu ma urua ubina varaviraai zin Iesu, xa waan sin amun pris laba xuna xana ngutlis Iesu zin naandi. ");
INSERT INTO nal_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Araan di langarin di nanam mase, ma di xalxal xuna dina ralaas naan pana a kaakaai. Ma Judaas ka zimbong a notaan mase xat faraxas pana naan, kuna xana ngutlis Iesu zin naandi. ");
INSERT INTO nal_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A varumaraiang a raan laba iwana A Raraba Xawit A Is ka balas. La raan angkanaan di zopsop famaat amun naata sipsip kuna vanganang kuna naxaamang A Raan Laba Iwana Zangas Fasaalang. Ubina varaviraai di iaari zin Iesu malasing kari, “Gu saxot maadina nimnimanin a vanganang aaxan dia vaa?” ");
INSERT INTO nal_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma xa kalin urua zin naandi xuna xana kling nandiaa, ma xa vazei nandiaa, naako, “Tamon naaguna albis iaa la bina laba, naaguna vasuin iaa aza rapti xat fazaak a win laba xa rauxin a daanim. Naagu los iaa naan. ");
INSERT INTO nal_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Naan kana albis la aza vaal. Naaguna vazei iaa damana vaal malasing kari, ‘A Maravas ka iaari naako, “Aze ra rumaaf la vaal angkari zunum, nia varaxai wana ubina varaviraai zurugu maadina iaan fakilaan A Raan Laba Iwana Zangas Fasaalang lamaskana?” ’ ");
INSERT INTO nal_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma naan kana vatangin a non tumaaf laba, di ra nimnimanin tasin fanong ma xa iziar laaxur la vaal angkanaan. Naagu nimnimanin iaa amun saan kuna vanganang sin dia lamaskana.” ");
INSERT INTO nal_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Naanaan uru rapti varaviraai di ramaraat iaa, ma di zangas paan iaa ma di albis iaa la bina laba. Di raamin fakilaan iaa amun saan faakdul xa malasing be Iesu xa ra vazei nandiaa wana. Ma di nimnimanin tasin iaa amun fanganang kuna iaan fakilaanang A Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A iaas kai si ma Iesu varaxai wana azangaaflu ma urua ubina varaviraai zina di balas. ");
INSERT INTO nal_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Araan di izi vavangan la iban favanganang, Iesu xa piaat naako, “Ga vazei varatunaan nim, azaxai zinim kana ngutlis nia zin amun purua. Azaxai angkanaan ka vavangan faraxai wana nia.” ");
INSERT INTO nal_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Di langarin a dorang angkanaan ma a maskana naandi xa maravan. Ma naandi zaksaxai di iaari zina malasing kari, “Kawit nia, aan?” ");
INSERT INTO nal_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu xa vazei naandi naako, “Naan azaxai zinim a zangaaflu ma urua. Naan ka zuzuruk a vang raraba ma xat burung lamaskana a win favanganang faraxai wana nia. ");
INSERT INTO nal_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naata Rapti xana maat malasing be a Baar Xoxok ka piaat fanong pana naan. Singsaxai xana raksaat mase wana a rapti angkanaan ina xana ngutlis Naata Rapti zin amun purua. Ka lek daxa tamon naanaa zina xa lek pen luk naan.” ");
INSERT INTO nal_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Araan di izi vavangan, Iesu xa zuruk a raraba ma xa wisfaadaxa zin Nakmai. Naa biaak ma xa ralaas ubina varaviraai zina ma xa piaat naako, “Naagu zuruk, naari a winugu.” ");
INSERT INTO nal_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ma naan ka zuruk a win imiminang ma xa wisfaadaxa zin Nakmai ma xa ralaas naandi, ma di laanga imin pana. ");
INSERT INTO nal_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma xa piaat sin naandi naako, “Naari a daraaigu, xana iru vakilaan a rudaxaiang faaxur. A daraaigu xana ravukaai ma xana vawaal aubina xa varas. ");
INSERT INTO nal_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ga vazei varatunaan nim, gana wen imin kaarik a waain ka ruaas pana a raan gana imin a waain faaxur lamaskana a bikabar zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Naandi di rangon fanong aza ranganang, ma di luaa a bina laba ma di waan la Waatawut Olif. ");
INSERT INTO nal_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu xa vazei ubina varaviraai zina naako, “Ainaxam paazaaiang sinim faakdul xana zu, wanaze lamaskana a Baar Xoxok Nakmai xa piaat malasing kari: ‘Gana zop famaat a rapti xa rataamaai xaaul, ma amun sipsip dina valaau varawuk.’ ");
INSERT INTO nal_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Singsaxai lamuraana a raan ga ramaraat puli, gana waamuain nim kun Gaalili.” ");
INSERT INTO nal_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita xa vazei Iesu naako, “Naapalaau tamon ainaxam paazaaiang sin naandi vaakdul xana zu vataling nua, nia gana wen luaa nua.” ");
INSERT INTO nal_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu xa xis naan naako, “Ga vazei varatunaan nua, taning labung paamua wana auraa xana kaakaluk faarua, guna wispuxin nia faarul.” ");
INSERT INTO nal_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Singsaxai Pita xa dador dikdik sina naako, “Naapalaau tamon ga maat faraxai wana nua, gana wen pispuxin nua.” Ma naandi azanon ubina varaviraai vaakdul di piaat saait awat dorang kanaan. ");
INSERT INTO nal_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iesu varaxai wana ubina varaviraai zina di waan laza uma di vakilaan pana Getsemani, ma Iesu xa vazei naandi malasing kari, “Naagu iziar iriat, gana wa maainung.” ");
INSERT INTO nal_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ka zaxot Pita ma Jems ma Jon ma di waan taal varaxai wana naan, ma a maskana xa maravan marazaat ma a xazanaaiang sina xa raksaat mase. ");
INSERT INTO nal_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma naan ka vazei nandiaal naako, “A maskaagu xa maravan marazaat ma faasilik adu gana maat. Naagu iziar raal iriat ma naagu rataamaai xaaul raal.” ");
INSERT INTO nal_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naan ka zangas paan lawalaau vaamumut ma xa psin fawizik naan paanaburut la pira ma xa maainung sin Nakmai adu, tamon kat faraxas a raan angkari iwana maazikang kana valiu naan. ");
INSERT INTO nal_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ka maainung malasing kari, “Maamaa, Maagu, nua gut faraxas guna giu amun saan faakdul. Kat faraxas guna zuruk pizin a win imiminang kari ziaagu. Singsaxai, tuaa gu los a sasaxotang ma ainaxamang surugu, xawit. Gu los a sasaxotang ma ainaxamang sunum.” ");
INSERT INTO nal_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iesu xa uli zin ubina varaviraai zina urul, ma xa tangin nandiaal di imilaaif taal. Ma xa iaari zin Pita naako, “Saaimon, gui milaaif aan? Malasing faa, xawit nat faraxas guna raamaai xaaul wana a aaua azaxai? ");
INSERT INTO nal_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Naagu raamaai xaaul raal ma naagu maainung taal xuna naaguna wen su raal lamaskana amun faaxabebeuang. A maskana axazak ka saxot kana giu azaan, singsaxai a winpin kawit na rauxin a dikdikang kuna giu vabalozang azaan angkanaan.” ");
INSERT INTO nal_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iesu xa waan ma xa maainung faazaxai xaarik pana a maainungang kanaan sina. ");
INSERT INTO nal_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Naan ka uli wat sin nandiaal ma xa tangin kaarik nandiaal di imilaaif taal, wanaze a marana nandiaal xa maravan marazaat. Naan ka wangun nandiaal, ma xawit di rexaas dina piaat taal aze zina. ");
INSERT INTO nal_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A varulang a raan naan ka wa maainung ma xa uli. Naan ka vazei nandiaal naako, “Naagu imilaaif iaavus taal nanga, aan? Kat faraxas ka! A raan ka balas faanong. Naagu raamin taal, di ngutlis Naata Rapti la mita aubina di gigiu amun matmalabuk taksaat. ");
INSERT INTO nal_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Naagu ramaraat taal ma di waan! Naagu raamin taal, a rapti xa ngutlis nia, xari xa balas faanong!” ");
INSERT INTO nal_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu xai dador nanga, ma Judaas, azaxai zin azangaaflu ma urua ubina varaviraai xa wat balas. Amala ubina di wat faraxai wana naan, di roting amun baainaat ma amun iaai iwana varopang. Amun pris laba ma amun maravas iwana amun Lus sin Moses ma amun paamua zin amun Judaa di kling fawat naandi. ");
INSERT INTO nal_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A rapti angkanaan ina xa ngutlis Iesu, xa tabung fazei rasin naandi wana aza vaakilanang kuna dina raamin fakilaan Iesu. Naan ka vazei naandi malasing kari, “Axazak angkanaan gana ngus, naan a rapti angkanaan. Naagu zaraak fating naan ma naagu ruxaaul wana naan ma naagu zaxot pizin naan.” ");
INSERT INTO nal_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Fazaaus mase Judaas ka wat sin Iesu ma xa piaat naako, “Maravas!” Ma xa ngus naan. ");
INSERT INTO nal_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ubina di wat ma di zaraak fating Iesu. ");
INSERT INTO nal_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma azaxai zin ubina varaviraai xa irur vaasilik, ka urif luk a baainaat sina ma xa kip pizin alngana a iaana kilaaiang sin a waamua zin amun pris laba. ");
INSERT INTO nal_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma Iesu xa piaat naako, “Malasing faa, naagu wat faraxai wana amun baainaat ma amun iaai iwana varopang kuna zaraakang nia, malasing adu naaguna zaraak axazak kat farop ma xat finaau, aan? ");
INSERT INTO nal_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Amun taan faakdul ga iziar varaxai wana nim, gat faraviraai la rabaraau ila vaal xoxok ma xawit naagu zaraak nia. Singsaxai naagu zaraak nia malasing a Baar Xoxok ka piaat.” ");
INSERT INTO nal_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mur ubina varaviraai di vataling Iesu ma di valaau. ");
INSERT INTO nal_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aza xulaau, xa valaak be a marapi xufkuf, ma xai los Iesu. Naandi di zaraak naan, ");
INSERT INTO nal_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ma xa valaau bulbulu ma xa vataling a marapi zina wanaze naadi roting falagot. ");
INSERT INTO nal_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Di zaxot lis Iesu zin a waamua zin amun pris. Ma amun pris laba ma amun paamua zin amun Judaa ma amun maravas iwana amun Lus sin Moses di balas fatu. ");
INSERT INTO nal_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita xai rur lawalaau vaamumut nanga ma xai los Iesu. Ka albis lamaskana a rabaraau ila a vaal zin a waamua zin amun pris, ma xa iziar varaxai wana amun tuxaaul ila vaal xoxok ma xat maadur wana axaiaf. ");
INSERT INTO nal_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Amun pris laba ma Aiziarang Iwana Aikilizang Sin Amun Judaa di zazaleng ta dorang kuna dina varur Iesu wana aikilizang ma dina zop famaat naan, singsaxai xawit di tangin tazaan. ");
INSERT INTO nal_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Amala aubina di vaagit ma di vakor Iesu wana a dorang, singsaxai a dorang sin naandi xawit nat faraxas faraxai. ");
INSERT INTO nal_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma azanon aubina di ramaraat ma di vaagit ma di vakor naan malasing kari, ");
INSERT INTO nal_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Maadi langarin naan ka piaat naako, ‘Gana bara psin a vaal xoxok angkari ina aubina di varur, ma lamaskana a raan urul gana varur xaarik azaxai, xawit pana a mita aubina.’ ” ");
INSERT INTO nal_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Singsaxai nanga a dorang sin naandi xawit nat faraxas faraxai. ");
INSERT INTO nal_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma a waamua zin amun pris ka rur lamarana naandi ma xa iaari zin Iesu naako, “Aze ra vuvuna ma xawit gu dador? Gu bain guna xis a dorang dit fakor nua wana?” ");
INSERT INTO nal_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Singsaxai Iesu xawit na dador, ma xawit na xis naan. A waamua zin amun pris ka iaari xaarik nanga zina. Ma xa iaari zina naako, “Malasing faa, nua a Mesaaia, Naata Nakmai ina xa rauxin amun daxaiang faakdul?” ");
INSERT INTO nal_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma Iesu xa xis naan malasing kari, “Nia be. Ma nim faakdul naaguna raamin Naata Rapti xana iziar la mit sazaxa zin Nakmai a Maradikdikang, ma xana wat pana ambara ila lia.” ");
INSERT INTO nal_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma a waamua zin amun pris ka taar a marapi zina nanga ma xa piaat naako, “Kunaze xaarik dia di saxot tazanon dorang kuna vaakarang? ");
INSERT INTO nal_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Naagu langarin fanong amun dorang lingpuak sina lawaana Nakmai. Naagu naxaam malasing faa?” Ma naandi vaakdul di xis naan adu naan kat faraxas kana maat. ");
INSERT INTO nal_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma azanon sin naandi di iabis a marana. Ma di bafkol umarana wana a waan marapi, ma di gumut a mita naandi ma di tuk naan, ma di vazei naan malasing kari, “Gu dador profet simaam.” Ma amun tuxaaul ila vaal xoxok di zaxot naan ma di wit kaarik naan. ");
INSERT INTO nal_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita xa iziar waanaburut, lamaskana a rabaraau ila vaal laba zin a waamua zin amun pris. Ma aza rakfaaxur xa balas, naan azaxai zin amun iaana kilaaiang sin a waamua zin amun pris. ");
INSERT INTO nal_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Naan ka raamin Pita xa izit maadur ma xa damin falagot naan, ma xa piaat naako, “Nua zaait gu ra iziar varaxai wana Iesu in Naazaret.” ");
INSERT INTO nal_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Singsaxai Pita xa wispuk naako, “Kawit ga rexaazin aze razaan gu dador wana.” Ma xa zangas kula mara iwana a rabaraau ila vaal angkanaan. Naanaan auraa xa kaakaluk. ");
INSERT INTO nal_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma mur a rakfaaxur angkanaan ka raamin kaarik Pita, ma xa piaat sin aubina di irur inaan naako, “Naan bani azaxai zin ubina varaviraai zin Iesu.” ");
INSERT INTO nal_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma Pita xa wispuk kaarik. Ma mur azanon di irur lapaara Pita, di piaat sina malasing kari, “Ka vaaratunaan, nua azaxai zin naandi, wanaze nua zaait in Gaalili.” ");
INSERT INTO nal_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma Pita xa viring fawat amun taksaarang laaxur wana naan ma xa xalxal wana a waata fafina ma xa piaat malasing kari, “Ga wetexaazin a rapti angkanaan naagu dador wana.” ");
INSERT INTO nal_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma fazaaus mase auraa xa varua a kaakalukang. Naanaan Pita xa naxaam luk a dorang Iesu xa ra piaat sina malasing kari, “Paamua wana auraa xana kaakaluk faarua, guna wispuk faarulin nia.” Ma a maskana xa lus ma xa raangis taksaat. ");
INSERT INTO nal_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Paanaraan gufguf mase amun pris laba varaxai wana amun paamua ma amun maravas iwana amun Lus sin Moses ma Aiziarang Iwana Aikilizang Sin Amun Judaa di balas fatu ma di pis a dorang pana aze ra zaan dina giu wana Iesu. Di pis fating uru mitna ma di valos lis naan sin Paailat. ");
INSERT INTO nal_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma Paailat ka iaari zin Iesu malasing kari, “Nua a xalxaal zin amun Judaa, aan?” Ma Iesu xa xis naan naako, “Nua nanga gu piaat fanong.” ");
INSERT INTO nal_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ma amun pris laba di vakor naan pana amun dorang ka varas. ");
INSERT INTO nal_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma Paailat ka iaari zina xaarik malasing kari, “Malasing faa, guna wen kis amun dorang sin naandi? Langar. Amun dorang ka varas naadi vakor nua wana.” ");
INSERT INTO nal_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Singsaxai Iesu xawit na xis a dorang sin naandi, ma Paailat ka banglala. ");
INSERT INTO nal_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lamun maariaas faakdul Paailat kat falos aza matmalabuk. La Raan Laba Iwana Zangas Fasaalang, naan kat familuaar psin a rapti azaxai ina xa iziar wana vaamaazikang ina aubina di kalin naan. ");
INSERT INTO nal_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma aza rapti aizina xanaan Baarabaas naan ka iziar lamaskana a vaal a vaamaazikang. Mumua naan faraxai wana azanon aubina di ra varop faraxai wana ubina dauran sin a gaapman kuna waapizinang a gaapman, ma naan ka zop famaat palau axazak la notaan angkanaan. ");
INSERT INTO nal_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ma la raan angkanaan aubina di balas sin Paailat ma di iaari zina xuna naan kana vamiluaar taza rapti xa ra iziar la vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma Paailat ka iaari zin naandi malasing kari, “Naagu saxot gana vamiluaar a xalxaal zinim amun Judaa, aan?” ");
INSERT INTO nal_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paailat ka rexaas adu amun pris laba di raamaai zuzuai wana Iesu ma naan a vuvuna xanaan di lis Iesu la mitna. ");
INSERT INTO nal_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Singsaxai amun pris laba dit faxalxaal aubina xuna iaariang sin Paailat adu naan kana vamiluaar Baarabaas. ");
INSERT INTO nal_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma Paailat ka iaari zin naandi naako, “Ma gana uvin a rapti angkari naagu vakilaan naan a xalxaal zin amun Judaa?” ");
INSERT INTO nal_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma di xupkup paan sina malasing kari, “Gu tukfating naan pana robuxul.” ");
INSERT INTO nal_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma Paailat ka iaari xaarik naako, “Kunaze? Naan ka giu aze rawat matmalabuk taksaat?” Singsaxai dit kupkup dikdik nanga malasing kari, “Tukfating naan pana robuxul!” ");
INSERT INTO nal_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma Paailat ka saxot kana vananam naandi ma xa vamiluaar lis Baarabaas sin naandi. Singsaxai xa lis Iesu zin ubina dauran sina xuna dina kmis naan pana wip ma dina tukfating naan pana robuxul. ");
INSERT INTO nal_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ubina dauran sina di valos lis Iesu xula vaal laba zin a waamua Paailat ma di viring fatuin ubina dauran faakdul. ");
INSERT INTO nal_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma di vamamaus naan pana a marapi raubung sin a xalxaal ma di kos a iaarus koxot malasing a lawilot ma di rasin la waata Iesu. ");
INSERT INTO nal_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma di vis naan malasing kari, “Maadi nop nua, a xalxaal zin amun Judaa.” ");
INSERT INTO nal_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma di wit faavarazin naan la waatna wana a laak ma di iabis naan. Ma di zi bukaak lamarana ma di wisfaru visfizin naan. ");
INSERT INTO nal_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lamuraana di vis fanong naan, di gamul psin a marapi raubung baraaf siaana, ma di vavalaak kaarik naan pana a marapi zina nanga. Ma di zaxot pizin fatukbilok naan kuna dina wa tukfating naan pana robuxul. ");
INSERT INTO nal_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma aza rapti in Saairini aizina Saaimon, damana Aaleksenda ma Rufas, naan ka ulili wat kula bina laba, ma araan ubina dauran di raamin naan, di vangarin naan kuna xana vazaak a robuxul zin Iesu. ");
INSERT INTO nal_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Di valos luk Iesu xula non di vakilaan Golgaata. Aknaas a waan dorang kanaan adu, “A Non Iwana Barang.” ");
INSERT INTO nal_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma di ralaas naan pana a waain di plaas faraxai wana aza daanim mawaak, aizina a mar, a makara xai waapizin a maazikang. Singsaxai Iesu xawit na imin. ");
INSERT INTO nal_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Naanaan di tukfating naan laaxur wana robuxul. Ma di raktaaxin amun faat kuna vatawaraxinang amun marapi zina lawalaua naandi nanga. ");
INSERT INTO nal_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Di tukfating Iesu waanaraan pana a marana iaas ka wizik faat. ");
INSERT INTO nal_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Laaxur la waata robuxul zina di rasin a dorang ka pitfiaat a vuvuna maravanang sina. A dorang kanaan ka malasing kari, “A Xalxaal zin amun Judaa.” ");
INSERT INTO nal_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma di tukfating saait uru vinaau wana uru robuxul lapaara Iesu, azaxai la mit sazaxa zina ma axazak la mit kais sina. ");
INSERT INTO nal_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma aubina ina di zazangas bilaas a non angkanaan dit favalingin amun paata naandi ma di visfis Iesu malasing kari, “Aahaa! Gu piaat adu nua guna bara psin a vaal xoxok ma guna varur vaulin kaarik lamaskana a raan urul. ");
INSERT INTO nal_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Gu vawaal nua nanga ziaana maatang ma gu kabal wat paanaburut siaana robuxul.” ");
INSERT INTO nal_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma malasing saait bani wana amun pris laba varaxai wana amun maravas iwana amun Lus sin Moses, di vis naan. Di piaat malasing kari, “Naan ka zaxot faulin azanon tawarak siaana maatang, singsaxai xawit nat faraxas kana zaxot faulin naan nanga. ");
INSERT INTO nal_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tamon naan a Mesaaia ma a Xalxaal zin amun Israael, naan kana kabal wat paanaburut pana robuxul ma dia dina raamin ma dina inaxam paazaai laxo wana naan.” Uru rapti di ra rokaai iaa lapaarana, nandiaa zaait di dador lingpuak iaa wana naan. ");
INSERT INTO nal_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","La marana iaas ka zangaaflu vaazaxai ma urua lawaanaas, a bungsuzuk ka pung paramin a pira vaakdul xa ruaas a marana iaas urul languzaraaf. ");
INSERT INTO nal_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","La notaan a marana iaas urul, Iesu xa xupkup dikdik malasing kari, “Eloi, Eloi, lama saabaaktaani?” Aknaas a waan dorang kari adu, “Nakmai zurugu, Nakmai zurugu, xunaze gu luaa psin nia?” ");
INSERT INTO nal_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Azanon aubina di irur vaasilik, di langarin ma di piaat malasing kari, “Naagu langar, naan kat firing Elaaija.” ");
INSERT INTO nal_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aza rapti xa valaau, ma xa zuruk a spaans ma naa burung pana a waain mawaak. Naa pis fating la nguza vang tangtangaana iaai ma naa lis fauzaa zin Iesu xuna vaiminang naan, ma xa piaat malasing kari, “Naagu luaa psin naan. Dina raamin kalaak tamon Elaaija xana balas faaratunaan kuna vakabaal vawatang naan paanaburut.” ");
INSERT INTO nal_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu xa xupkup dikdik ma xa maat. ");
INSERT INTO nal_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma la notaan angkanaan adi marapi laba xa ratokaai lamaskana a vaal xoxok ka ramatar laaxur ma xa wizik mase waanaburut ma xa balas uwaan marapi urua. ");
INSERT INTO nal_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma a waamua zin ubina dauran in Rom ka irur inaan paanaburut lamarana Iesu, xa raamin awat maatang sina ma xa piaat naako, “Faaratunaan, a rapti angkari naan Naata Nakmai.” ");
INSERT INTO nal_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Azanon furavin di irur lawalaau vaamumut di raamin a maatang sin Iesu. Amun izina naandi xanaan, Maaria in Maakdaalaa ma Maaria naanaa zin Jems mumut nandiaa Iosep ma aza ravin aizina Saalomi. ");
INSERT INTO nal_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mumua naandi di ra ilos Iesu lamun taan angkaina naan ka ra iziar ikula Gaalili ma dit fawaal naan. Ma amala a furavin tawarak saait ina di ra los Iesu xun Jerusalem, naandi zaait inaan. ");
INSERT INTO nal_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","La raan angkanaan Iesu xa maat pana languzaraaf, naan a raan a nimnimanang, a raan paamua wana a Saabat. ");
INSERT INTO nal_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ma Iosep in Aarimaatiaa, naan aza rapti laba zin ubina iwana Aiziarang Iwana Aikilizang Sin Amun Judaa ma naan ka izimbong a bikabar zin Nakmai. Naan kawit na maraaut ma xa wat sin Paailat ma xa iaari tamon naan kana lis Iesu zina. ");
INSERT INTO nal_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma Paailat ka raknar wana langarinang adu Iesu xa maat faanong. Ma naan ka viring a waamua zin amun aami zina ma xa iaari zina tamon Iesu xa maat faanong o xawit. ");
INSERT INTO nal_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","A waamua angkanaan ka vazei naan adu a dorang kanaan ka vaaratunaan. Ma Paailat ka rudaxain Iosep kana vazaak pizin Iesu. ");
INSERT INTO nal_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iosep ka zuruk a marapi vaaxur ma xa vakabaal Iesu xu waanaburut, ma xa xavut Iesu wana a marapi angkanaan. Ma di rasin naan lamaskana a baaul a maat, ina di xaaf lamaskana a varaanga vaat siar. Ma Iosep ka wul xol a marana a baaul a maat pana adi vaat laba. ");
INSERT INTO nal_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maaria in Maakdaalaa ma Maaria naanaa zin Iosep di raamin iaa a non angkanaan, a baaul a maat sin Iesu xa itate wana. ");
INSERT INTO nal_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","A raan a Saabat ka vaanong Maaria in Maakdaalaa ma Saalomi ma Maaria naanaa zin Jems di wa wul luk taal a daanim milalas mikuf kuna dina vukin taal la wina Iesu. ");
INSERT INTO nal_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Paanaraan gufguf mase lamuraana a iaas ka zarawilak la varumaraiang a raan iwana a wik, a furavin angkanaan di zazangas taal xula baaul a maat sin Iesu, ");
INSERT INTO nal_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ma di iaari raal lawalaua nandiaal malasing kari, “Nis kana wul psin adi vaat ina di rasin kolang a marana a baaul a maat?” ");
INSERT INTO nal_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Araan di balas taal inaan, di raamaai uzaa raal laaxur ma di raamin taal adu axazak ka wul psin fanong adi vaat laba angkanaan lamarana baaul a maat. ");
INSERT INTO nal_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Di albis taal lamaskana a baaul a maat ma di raamin taal aza xulaau, amun mamaauzang ila wina xa xufkuf mase ma xa iziar la non mit sazaxa, ma di raknar ma di marauring taal naan. ");
INSERT INTO nal_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma naan ka vazei nandiaal malasing kari, “Tuaa mase naagu maraaut taal. Naagu zazaleng taal Iesu in Naazaret ina xa rokaai laaxur wana robuxul. Singsaxai naan ka ramaraat puli vaanong. Naagu raamin taal a non di vatate naan pana, xa waan faanong. ");
INSERT INTO nal_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Naagu waan ma naagu balas taal zin ubina varaviraai zina varaxai wana Pita, ma naagu vazei raal naandi malasing kari, ‘Naan ka waamuain fanong nim kun Gaalili. Naaguna waan ma inaan naaguna raamin naan, malasing be xa ra vazei vanong nim pana.’ ” ");
INSERT INTO nal_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma a furavin urul angkanaan di dakdakur raal wana maraautang ma di banglala raal ma di tukbilak puat taal lamanar ma di valaau raal. Ma xawit di vazei raal taxazak pana azaan angkanaan panaze di maraaut taal. ");
INSERT INTO nal_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ma Iesu xa ramaraat puli la varumaraiang a raan iwana a wik angkanaan. Maaria in Maakdaalaa xa tabung taamin naan, naan bani ina waamua Iesu xa ra mof pizin amun sapalaau xa wizik urua ziaana. ");
INSERT INTO nal_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma Maaria Maakdaalaa xa uli ma xa balas sin aubina ina di ra ilos Iesu. Naandi di maskalus mase ma di ratangis Iesu, ma Maaria Maakdaalaa xa vazei naandi adu naan ka raamin fanong Iesu. ");
INSERT INTO nal_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Araan di langarin azaan angkanaan, kawit di inaxam paazaai adu Iesu xa ramaraat puli vaanong ma Maaria Maakdaalaa xa raamin naan. ");
INSERT INTO nal_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lamur uru rapti varaviraai zin Iesu di zazangas iaa la lan labirua wana amun bina ma di raamin iaa Iesu xa rauxin aza wat tataamaaiang. ");
INSERT INTO nal_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma di uli iaa ma di vazei iaa azanon ubina varaviraai zina, singsaxai xawit di inaxam paazaai zaait pana nandiaa. ");
INSERT INTO nal_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lamur Iesu xa balas sin a zangaaflu ma zaxai ubina varaviraai zina la raan naandi di vavangan, ma naan ka vadawaar naandi wanaze ainaxam paazaaiang sin naandi xawit na dikdik, ma a maskana naandi xa dikdik ma xawit di inaxam paazaai wana naandi ina di ra raamin Iesu lamuraana xa ramaraat puli wana maatang. ");
INSERT INTO nal_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma Iesu xa vazei naandi malasing kari, “Naagu waan lamun non faakdul ila pira angkari ma naagu fazei wana a Dorang Daxa zurugu xa waan sin aubina vaakdul. ");
INSERT INTO nal_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tamon taxazak ka inaxam paazaai wana a Dorang Daxa zurugu ma naagu baaptaais naan, Nakmai xana zaxot faulin naan. Tamon axazak kawit na inaxam paazaai wana a Dorang Daxa zurugu, Nakmai xana vamazik naan. ");
INSERT INTO nal_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Naandi di inaxam paazaai wana nia, Nakmai xana giu amun fakilaanang la mita naandi malasing kari: wana aizinugu dina mof pizin amun sapalaau ziaana aubina, ma dina wuk amun linga bina vaaxur, ");
INSERT INTO nal_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ma dina roting amun sizi raksaat, ma aubina dina imin a taaring singsaxai dina wen gias ma dina wen maat, ma dina rasin umita naandi wana aubina di gias ma aubina angkanaan dina balas daxa.” ");
INSERT INTO nal_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","A Piran Iesu xa ra dador vaanong, ma Nakmai xa zaxot fauzaa naan kunikula la lia, ma xa iziar la mit sazaxa zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma ubina varaviraai zina di waan ma di fazei wana a Dorang Daxa lamun non faakdul ma a Piran ka vaamuzas faraxai wana naandi ma xa vadikdik a dorang sina wana amun faakilanang. ");
INSERT INTO nal_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","A dorang ka waan sin a piran Tiofilas. Amala di ra lalaamangaai xuna varaar vatingang amun saan Nakmai xa ra waambazof lawalaua maam malasing naa ra pitfiaat mumua. ");
INSERT INTO nal_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Naandi ina di ra raamin amun saan angkanaan la varumaraiang iwana ma di balas amun iaana kilaaiang iwana a dorang sin Nakmai, di ra vazei maam pana amun saan angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ma nia ga zazaleng amun dorang iwana lagazaai zin Iesu ila varumaraiang ma xa utuaas pana vaanongang sina la pira angkari. Malasing ma ga naxaam adu xa daxa nia zaait gana fararin ka waan sunum. Ga varaar amun saan angkanaan lalozang a lan di balas pana, ");
INSERT INTO nal_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kuna guna rexaas mase adu amun saan di ra viraai nua wana xa vaaratunaan. ");
INSERT INTO nal_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lamun maariaas araan Erot ka izi a xalxaal in Judia, xa rauxin aza pris aizina xanaan Zekaria, xa wat pana a lemlem pris sin Aabijaa. Aizina taak sin Zekaria xanaan Elizabet, ma naan saait a natnaat sin Aaron. ");
INSERT INTO nal_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nandiaa uru xazak di tak iaa lamarana Nakmai, ma dit falos fatalamin iaa amun dorang dikdik faakdul ma amun lus faakdul zin a Piran Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Singsaxai xawit di raxunalik iaa, avuna Elizabet ka mala ma di baiak iaa vaanong saait. ");
INSERT INTO nal_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Aza raan lamaskana amun taan iwana vaamuzazang sin a lemlem sin Zekaria, Zekaria nanga xa giu a vaamuzazang iwana talazang lamarana Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lalozang a rataawuk amun pris, naandi di raktaaxin amun faat ma di kalin Zekaria xuna naan kana albis lamaskana vaal xoxok sin a Piran ma xana vaif a laas milalas mikuf. ");
INSERT INTO nal_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","La raan kat faif a laas milalas mikuf, aubina iwana lotu di irur vatu lamanar ma dit maainung. ");
INSERT INTO nal_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Naanaan aza aangelo zin a Piran ka balas sin Zekaria ma xa wat tur la mit sazaxa iwana aalta iwana vaivang a laas milalas mikuf. ");
INSERT INTO nal_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Araan Zekaria xa raamin naan, ka raknar ma xa maraaut marazaat. ");
INSERT INTO nal_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma xa piaat sina naako, “Zekaria, tuaa gu maraaut, Nakmai xa langarin fanong a maainungang sunum, ma taak sunum Elizabet kana luk a nalik sunum, ma guna vakilaan naan pana Jon. ");
INSERT INTO nal_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Guna nanam mase wana naan ma amala dina nanam saait pana a balazang sina, ");
INSERT INTO nal_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","wanaze naan kana laaup lamarana a Piran. Naan kana wen imimin a waain, o tazanon daanim dikdik ma paamua wana naanaa zina xana luk naan, ma a Laklagaai a Raabu xana iziar wana naan. ");
INSERT INTO nal_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma xana zaxot faulin amala amun Israael xa waan sin Nakmai a Piran sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Naan kana dikdik mase malasing a profet Elaaija, xana waamuain a Piran kuna xana zaxot fatuin amun damana a funalik faraxai wana a funalik sin naandi, xuna dina maska zaxai ma xana plaas fatok ainaxamang sin aubina dit langar pesalaai xuna dina rauxin ainaxamang daxa zin aubina di tak. Naan kana giu uru zaan angkanaan kuna nimnimaninang aubina zin a Piran pana balazang sina.” ");
INSERT INTO nal_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekaria xa iaari zin a aangelo naako, “Gana rexaas malasing faa adu azaan angkanaan kana balas faaratunaan? Panaze maadi baiak iaa vaanong.” ");
INSERT INTO nal_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma a aangelo xa xis naan naako, “Nia xari Gaabriel. Nia gai rur lamarana Nakmai. Naan nanga xa kling fawat nia xuna dadorang sunum ma xuna lizang amun dorang kanaan ka daxa zunum. ");
INSERT INTO nal_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Singsaxai nua xawit gu inaxam paazaai wana amun dorang surugu, malasing ma naari guna nguspo. Guna wen dador xa ruaas la notaan faatak mase amun saan angkanaan kana balas faaratunaan.” ");
INSERT INTO nal_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","La notaan angkanaan aubina ina di rat simbong Zekaria, ma di ra inaxam farvaras pana naan, panaze xa vaabung lamaskana a vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Araan ka tukbilak, kawit nat faraxas kana dador zin naandi, xai talus be naandi wana uru mitna. Malasing ma di rexaas ka adu Zekaria xa raamin fanong aza rataamaaiang lamaskana vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Araan a notaan sina iwana vaamuzazang ka vaanong, naan ka uli xula bina zina. ");
INSERT INTO nal_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma mur taak sina, Elizabet ka buxut, ma lamaskana a flan ka watmit, naan kawit na waan fataling a vaal. ");
INSERT INTO nal_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma Elizabet ka piaat naako, “Naari mase xa, a Piran ka vawaal nia ma xa zuruk pizin azaan ina nia gat maangil wana lamarana aubina.” ");
INSERT INTO nal_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pana vawizik saaxaiang a flan Elizabet ka buxut, Nakmai xa kling a aangelo Gaabriel xa waan la bina laba Naazaret, la non laba Gaalili. ");
INSERT INTO nal_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Naan ka waan sin aza rakfaaxur xawit nanga nat milivin ta rapti, aizina xanaan Maaria, ina di vakol naan kana maxus sin Iosep, a natnaat sin a Xalxaal Dewit. ");
INSERT INTO nal_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A aangelo xa balas sin Maaria ma xa piaat sina naako, “A dor vaananamang ka wat sunum. A daxaiang sin Nakmai xa iziar zunum! A Piran ka iziar varaxai wana nua!” ");
INSERT INTO nal_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maaria xa inaxam farvaras pana a dorang kari, adu aze mase a vuvuna. ");
INSERT INTO nal_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma a aangelo xa piaat sina naako, “Maaria, tuaa gu maraaut, Nakmai xa lis a daxaiang sunum. ");
INSERT INTO nal_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Langar! Guna buxut ma guna luk a nalik ma guna vakilaan naan pana Iesu. ");
INSERT INTO nal_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma aizina xana laaup ma dina vakilaan naan pana Naata Nakmai Laaxur Mase. Ma a Piran Nakmai xana vaziaar naan la kin izi xalxaalang sin a xulmua zina Dewit, ");
INSERT INTO nal_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ma naan kana rasin bulin a lus laaxur wana amun natnaat sin Jekop ma a bikabar zina xana wen faanong.” ");
INSERT INTO nal_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma Maaria xa iaari zin a aangelo naako, “Azaan angkanaan kana mitat balas, avuna xawit ga milivin ta rapti.” ");
INSERT INTO nal_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma a aangelo xa xis naan naako, “A Laklagaai a Raabu xana wat pana nua ma a dikdikang sin Nakmai Laaxur Mase xana waramin nua. Malasing ma a Nalik Koxok ina nua guna luk dina vakilaan naan pana Naata Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Langar, a taaum Elizabet ka baiak faanong ma di piaat pana naan adu xa mala, singsaxai naari naan ka buxut faanong, ma a flan sina xa wizik saaxa. ");
INSERT INTO nal_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Avuna xawit tazaan Nakmai xawit nat faraxas kana giu.” ");
INSERT INTO nal_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Maaria xa piaat naako, “Nia a iaana kilaaiang sin a Piran. Ka daxa adu naan kana giu wana nia malasing nua gu piaat.” Ma a aangelo xa vataling naan. ");
INSERT INTO nal_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mur Maaria xa nimniman ma xa uzaa vazaaus laza bina ikula lamaskana amun put la pira Judia. ");
INSERT INTO nal_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Naan ka albis la vaal zin Zekaria ma xa piaat lawaanaas sin Elizabet. ");
INSERT INTO nal_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Araan Elizabet ka langarin Maaria xa piaat lawaanaas, popo xa fida la xuna ma a Laklagaai a Raabu xa iziar wana Elizabet. ");
INSERT INTO nal_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma xa dador laba naako, “Nua gu rauxin a daxaiang ka laaup pana a furavin faakdul ma a nalik saait guna luk ka rauxin a daxaiang sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nia aze rawat tavin malasing ma naanaa zin a Piran surugu xa wat surugu? A balazang sunum ka lis a daxaiang surugu. ");
INSERT INTO nal_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Araan ga langarin gu piaat fawat lawaanaas surugu, a nalik la xunugu xa fida wana nanamang. ");
INSERT INTO nal_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gu ra inaxam paazaai adu a Piran kana giu vatfaraxazin malasing naan ka ra vazei nua, malasing ma a daxaiang ka wat sunum.” ");
INSERT INTO nal_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maaria xa piaat naako, “A maskaagu xa valaup a Piran, ");
INSERT INTO nal_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma a maskaagu xa nanam pana Nakmai a Baraai a Vaaroroiang surugu, ");
INSERT INTO nal_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","avuna naan kat naxaam nia, a ravin iaana kilaaiang palaau be zina. Taning ma xa uzaa, amun patkul vaakdul dina piaat adu nia ga rauxin a daxaiang, ");
INSERT INTO nal_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","avuna naan A Maradikdikang, ma xa ra giu amun saan ka laaup pana nia. Aizina xa xoxok. ");
INSERT INTO nal_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A varamaaluvang sina xa iziar wana aubina ilamun patkul vaakdul ina dit marauring naan ma dit faranop pana naan. ");
INSERT INTO nal_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Naan ka ra giu amun faamuzazang dikdik pana mitna, ma naan ka ra vut pizin farauxin naandi dit naxaam falaup naandi nanga lamaskana ainaxamang sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Naan ka ra zuruk pizin amun kalxaal ziaana akin izi xalxaalang sin naandi, singsaxai xa valaup aubina walaau. ");
INSERT INTO nal_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ka ralaas aubina di lagaai wana amun saan daxa xa varas, ma di maazur, singsaxai xa kling pizin fagof aubina di raxumbaaxut. ");
INSERT INTO nal_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Naan ka ra vawaal amun iaana kilaaiang sina amun Israael, wanaze xat naxaam faulin a xalxalang sina malasing ma xat faramaaluf ");
INSERT INTO nal_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","pana Aabaraam ma amun natnaat sina bulaai, lalozang azaan naa ra piaat sin naandi, amun kulmua zin dia.” ");
INSERT INTO nal_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma Maaria xa raagul varaxai wana Elizabet pana amun taan ka malasing a flan urul ma mur xa uli xula bina zina. ");
INSERT INTO nal_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ma a raan sin Elizabet ka balas kuna lukang a popo, ma naan ka luk a popo rapti. ");
INSERT INTO nal_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Amun paliaana ma amun taaua Elizabet di langar adu a Piran ka rauxin adi varamaaluvang laba wana naan, ma di wat dokdok faraxai wana naan. ");
INSERT INTO nal_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pana wizik tulang a raan sin a popo lamuraana naanaa zina xa luk naan, di nimniman kuna ftuk pizinang a vang pakpaakna, ma di saxot dina vakilaan naan pana aizina damana Zekaria. ");
INSERT INTO nal_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Singsaxai naanaa zina naako, “Kawit! Aizina Jon.” ");
INSERT INTO nal_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma naandi di piaat sina malasing kari, “Kawit ta taaum na rauxin aiza angkanaan.” ");
INSERT INTO nal_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mur di talus pana amun mita naandi xa waan sin damana ma di iaari zina wana aze ra iza naana vakilaan a popo wana. ");
INSERT INTO nal_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma xa talus pana tazaan kuna fararang pana ma xa varaar malasing kari, “Aizina Jon.” Naandi vaakdul di raknar. ");
INSERT INTO nal_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Fazaaus mase a balana xa ralakas ma a xaramana xa rapalas. Ma naan kat faraxas kana dador ma xa wisfaru Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma naandi vaakdul amun paliaana, di banglala marazaat mase. A dorang pana amun saan angkanaan ka waan farawuk lamun bina vaakdul di iziar la non paatawut in Judia. ");
INSERT INTO nal_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Naandi vaakdul ina di langarin, di inaxam marazaat pana ma di iaari malasing kari, “Mur a nalik kana balas malasing faa?” Avuna di raamin adu a dikdikang sin a Piran ka iziar wana naan. ");
INSERT INTO nal_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A Laklagaai a Raabu xa iziar wana Zekaria, damana Jon, ma Zekaria xa dador profet malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“A wisfaaruiang ka waan sin a Piran, Nakmai zin amun Israael, wanaze naan ka balas faanong sin aubina zina ma xa wul vaxarom naandi. ");
INSERT INTO nal_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Naan ka lis fanong a Baraai a Vaaroroiang sin dia, ina xa maradikdik, ka wat pana amun natnaat sin Dewit, a iaana kilaaiang sina, ");
INSERT INTO nal_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","lalozang aze naa ra piaat mumua pis la nguza amun profet ninis sina. ");
INSERT INTO nal_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Naan kana zaxot faulin dia ziaana amun purua zin dia ma la mita naandi vaakdul ina di maska raksaat pana dia. ");
INSERT INTO nal_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Naan kana giu malasing kanaan kuna vatanginang a varamaaluvang sina wana amun kulmua zin dia, ma xana waambazof a rudaxaiang koxok sina varaxai wana naandi. ");
INSERT INTO nal_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Naan ka xalxal zin a xulmua zin dia Aabaraam, ");
INSERT INTO nal_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","adu xana zaxot faulin dia la mita amun purua zin dia, ma xanat faraxas dia dina vaamuzas ku naan ma dina wen maraaut. ");
INSERT INTO nal_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dina vaamuzas ku naan pana a matmalabuk ka ninis ma xa tak lamarana lamun taan faakdul wana roroiang sin dia. ");
INSERT INTO nal_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma nua naarugu, dina vakilaan nua a profet sin Nakmai Laaxur Mase, wanaze guna zangas paamua wana a Piran, ma guna nimnimanin a lan aaxana. ");
INSERT INTO nal_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Guna vamaravaas aubina zina wana a lan ina Nakmai xana zaxot faulin naandi araan ka naxaam pizin amun matmalabuk taksaat sin naandi, ");
INSERT INTO nal_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","wanaze Nakmai zin dia xat mainof pana a varamaaluvang sina zin naandi. Ma lamaskana varamaaluvang sina, a maravas iwana vaaroroiang inikula la lia xana vamaravaas fawat dia. ");
INSERT INTO nal_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Naan kana lis a maravas sin naandi ina di iziar la bungsuzuk ma lawaana dikdikang iwana maatang, ma xana valos dia wana a lan iwana aiziarang lamaskana a luaai.” ");
INSERT INTO nal_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma a nalik ka laba uzaa ma Nakmai xa vamaravaas inaxamang sina ma xa makal. Ma xa iziar la non bingil xa ruaas ka balas la maravas sin amun Israael. ");
INSERT INTO nal_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","La notaan angkanaan Siza Aaugustus, naan a xalxaal in Rom, ka rasin a lus adu dina varaar vating amun izina aubina vaakdul lamun bina vaakdul ina Rom ka rasin a lus laaxur wana naandi. ");
INSERT INTO nal_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","La notaan angkanaan a matmalabuk angkanaan iwana varaar vatingang amun izina aubina xa balas mara mase la raan Kuwirinias ka waamua wana a gaapman ila provins Siria. ");
INSERT INTO nal_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aubina vaakdul di ra waan lamun bina laba vaatak sin naandi xuna lizang amun izina naandi. ");
INSERT INTO nal_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Malasing ma Iosep saait ka ramaraat la bina laba Naazaret la pira Gaalili ma xa uzaa xunikula la pira Judia, la bina laba zin a Xalxaal Dewit, di vakilaan Betliem, panaze naan aza natnaat sin Dewit. ");
INSERT INTO nal_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Naan ma Maaria di ra waan iaa xuna lizang iaa aizina nandiaa. Maaria di ra vakol naan kuna xana maxus sin Iosep ma la raan angkanaan naan ka buxut faanong. ");
INSERT INTO nal_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Di iziar iaa nanga Betliem, ma a raan sin Maaria xa balas kuna xana luk. ");
INSERT INTO nal_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maaria xa luk a ruaan sina, a popo rapti. Naa flus pana uwaan marapi ma naa vatate la kin favanganang sin amun kak talavaat, panaze xawit ta marapalau aaxan naandi xuna milaaivang lamaskana ta rumaaf la vaal zin amun topuran. ");
INSERT INTO nal_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ka rauxin azanon ubina di rataamaai xaaul wana amun sipsip sin naandi labung. Naandi di iziar laza non pira vaasilik pana a bina laba. ");
INSERT INTO nal_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma aza aangelo zin a Piran ka balas sin naandi ma adi maravaas a Piran ka wilwilak faraxulin naandi, ma di maraaut taksaat mase. ");
INSERT INTO nal_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Singsaxai a aangelo xa vazei naandi naako, “Tuaa naagu maraaut. Naagu langar. Ga wat pana a dorang ka daxa aaxan aubina vaakdul xuna nanamang pana. ");
INSERT INTO nal_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Taning, la bina laba zin Dewit, aza ravin ka luk a popo, naan a Baraai a Vaaroroiang sinim, ma naan a Mesaaia ma a Piran. ");
INSERT INTO nal_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Naaguna raamin fakilaan naan malasing kari: A nan popo di flus naan pana uwaan marapi ma xa itate la kin fanganang sin amun kak talavaat.” ");
INSERT INTO nal_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Fazaaus mase adi lemlem amun aangelo ila lia di balas faraxai wana a aangelo angkanaan ma di wisfarur Nakmai malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Aiza laba xa uzaa zin Nakmai xa iziar ikula mase laaxur, ma la pira angkari a luaai xana iziar zin aubina Nakmai xa nanam pana naandi.” ");
INSERT INTO nal_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Amun aangelo di luaa naandi ma di uli xunikula la lia. Ma ubina di rataamaai xaaul wana amun sipsip di piaat lawalaua naandi nanga malasing kari, “Dia dina waan Betliem ma dina wa raamin azaan angkanaan ina xa ra balas malasing a Piran ka ra vazei dia wana.” ");
INSERT INTO nal_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Malasing ma naandi di ramaraat fazaaus ma di waan. Di tangin Maaria ma Iosep, ma popo xa itate lamaskana akin fanganang sin amun kak talavaat. ");
INSERT INTO nal_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Araan di raamin fanong a popo, di waan ma di piaat farauxin a dorang pana aze razaan a aangelo xa ra vazei naandi wana a popo angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Naandi vaakdul ina di ra langarin a dorang kanaan ubina di rataamaai xaaul wana amun sipsip di vazei naandi wana, di banglala marazaat. ");
INSERT INTO nal_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Singsaxai Maaria xa naxaam falagot amun saan angkanaan ma naa rasin la inaxamang sina. ");
INSERT INTO nal_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma ubina di rataamaai xaaul wana amun sipsip di uli, ma dit pisfaru Nakmai ma dit falaup aizina wana amun saan faakdul ina naadi ra langarin ma naadi ra raamin malasing be amun aangelo di ra vazei naandi wana. ");
INSERT INTO nal_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","La vawizik tulang a raan lamuraana naanaa zin Iesu xa ra luk naan, di ftuk pizin a vang pakpak malasing be a rataawuk amun Judaa. Ma di ra vakilaan naan pana Iesu. Aiza angkanaan a aangelo xa ra lis araan naanaa zina xawit nanga na buxurin naan. ");
INSERT INTO nal_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","A raan iwana vaninizang Iosep ma Maaria xuna balas daxaiang iaa lamarana Nakmai malasing amun Lus sin Moses ka ra piaat ka vaanong ka, ma di zaxot iaa Iesu xun Jerusalem kuna dina lis iaa naan sin a Piran. ");
INSERT INTO nal_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Di valos iaa a dorang lamaskana Lus sin a Piran ka piaat naako, “Dia dina lis amun nalik tuaan faakdul xa waan sin a Piran.” ");
INSERT INTO nal_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma di lis iaa zaait a talazang ka waan sin Nakmai malasing a Lus sin a Piran ka piaat malasing kari, “Dina talazin a baalus urua o a bun faaxur urua.” ");
INSERT INTO nal_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","La notaan angkanaan ka rauxin aza rapti xa iziar Jerusalem, aizina Simion. Naan a rapti xa gigiu amun matmalabuk ka tak ma xat faranop pana Nakmai. Ma xat simbong Nakmai xana mada amun Israael araan a Mesaaia xana wat ma a Laklagaai a Raabu xa iziar wana naan. ");
INSERT INTO nal_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A Laklagaai a Raabu xa ra pitfiaat sina adu naan kana wen maat nanga xa ruaas kana raamin a Mesaaia zin a Piran Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A Laklagaai a Raabu xa vazei naan ma xa waan la rabaraau ila vaal xoxok. Ma maamaa ma naanaa zin Iesu di zaxot falbis iaa naan kuna dina giu wana naan aze ra rataawuk amun Lus sin Moses ka piaat. ");
INSERT INTO nal_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion ka waaluk a popo ma xa roting naan pana uru mitna ma xa wisfaru Nakmai malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Piran, nua gu waambazof a xalxalang sunum ka wat surugu, ma naari guna vamiluaar xa nia, a iaana kilaaiang sunum lamaskana a luaai. ");
INSERT INTO nal_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Avuna nia ga raamin fanong pana uru maraagu a nalik ina xana zaxot faulin aubina. ");
INSERT INTO nal_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nua gu ra nimnimanin lamarana aubina vaakdul. ");
INSERT INTO nal_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Naan a maravas kuna vamaravaazang aubina xawit amun Israael wana nua, ma xana valaup aizinum sin aubina zunum, amun Israael.” ");
INSERT INTO nal_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Maamaa ma naanaa zin a popo di banglala iaa wana aze razaan Simion ka piaat pana naan. ");
INSERT INTO nal_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma Simion ka piaat a daxaiang laaxur wana naandi ma xa vazei Maaria, naanaa zin Iesu naako, “Nakmai xa ra kalin a nalik angkari, ma amun Israael xa varas dina zu ma azanon sin naandi xa varas dina ramaraat avuna wana naan. Naan kana balas malasing a vaakilanang ka wat sin Nakmai, singsaxai aubina dina wispuxin naan. ");
INSERT INTO nal_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Malasing ma amun inaxam funfunang sin amala aubina xana balas la maravas. Ma guna xazanin a maskaluzang malasing adu a baainaat ka zaxa zaait a maskaam.” ");
INSERT INTO nal_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ka rauxin aza profet tavin, aizina Aanaa, a fnaalik sin Faanuel, wana watbung sin Aasaa. Naan ka baiak taksaat. Ka ra iziar varaxai wana labana wana a maariaas ka wizik urua lamuraana di maxus iaa, ");
INSERT INTO nal_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ma labana xa ra maat fataling naan ma xa iziar a raksiziar xa ruaas a maariaas sina xa zangaaflu vaawizik tul ma urulavaat. Naan kawit nat luaa a rabaraau ila vaal xoxok, ka gigiu amun faamuzazang sin Nakmai varaxai wana valvaalang ma maainungang labung ma lawaanaas. ");
INSERT INTO nal_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","La notaan angkanaan mase, naan ka wat balas sin nandiaal ma xa wisfaadaxa zin Nakmai ma xa dador wana a nalik angkanaan sin aubina vaakdul ina dit simbong Nakmai xana kling axazak kuna xana wul vaxarom aubina in Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Araan Iosep ma Maaria di giu vatfaraxazin fanong iaa amun saan faakdul wana popo lalozang amun Lus sin a Piran, di uli xula pira Gaalili la bina laba vaatak sin naandi Naazaret. ");
INSERT INTO nal_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A nalik kat laba uzaa, ma xa maradikdik ma xa bas pana mazamang, ma daxaiang sin Nakmai xa iziar wana naan. ");
INSERT INTO nal_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lamun maariaas faakdul, maamaa ma naanaa zin Iesu di wanpaan iaa Jerusalem pana A Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Araan a maariaas sin Iesu xa zangaaflu ma urua, nandiaal varaxai di ra waan taal ikula Jerusalem, pana a raan laba angkanaan, malasing a rataawuka naandi. ");
INSERT INTO nal_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","A raan laba angkanaan ka vaanong ka, ma maamaa ma naanaa zin Iesu di uli waan iaa xula bina zin naandi, singsaxai Iesu xa izi uli inaan Jerusalem. Maamaa ma naanaa zina xawit di rexaas iaa adu naan ka izi uli. ");
INSERT INTO nal_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Di naxaam iaa adu naan banaan lawalau a lemlem angkanaan sin naandi ma di zangas faanong pana a raan azaxai. Di ramaraat iaa xa ma di zaleng iaa naan lawalau amun taaua naandi ma amun paasaxo zin naandi. ");
INSERT INTO nal_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Singsaxai xawit di tangin iaa naan, malasing ma di uli waan iaa Jerusalem kuna zalengang naan. ");
INSERT INTO nal_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lamuraana a raan urul, di tangin iaa naan la rabaraau ila vaal xoxok, ka iziar lawalau amun maravas sin amun Judaa, ma xat langarin naandi ma xai iaari zin naandi wana amun iaariang. ");
INSERT INTO nal_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Naandi vaakdul ina di langarin naan, di banglala wana mazamang sina ma a dorang naai xis naandi wana. ");
INSERT INTO nal_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Maamaa ma naanaa zina di banglala iaa araan di raamin iaa naan. Ma naanaa zina xa piaat sina naako, “Naarugu, xunaze gu giu malasing angkanaan pana nimaa? Nimaa damaam maadi inaxam farvaras iaa ma maadi zazaleng iaa nua.” ");
INSERT INTO nal_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma Iesu xa xis naan naako, “Kunaze naagu zaleng iaa nia? Malasing faa, xawit naagu rexaas iaa adu xa tak pana nia gana iziar la vaal zin Maagu?” ");
INSERT INTO nal_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Singsaxai nandiaa xawit di mazaam iaa aze naa piaat sin nandiaa. ");
INSERT INTO nal_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naanaan Iesu xa uli waan Naazaret faraxai wana nandiaa, ma xat langar zin nandiaa. Singsaxai naanaa zina xa naxaam falagot amun saan angkanaan ma naa rasin la inaxamang sina. ");
INSERT INTO nal_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu xa laba uzaa la winpin ma wana mazamang. Ma Nakmai ma aubina di piaat adu naan a rapti daxa. ");
INSERT INTO nal_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberiaas Siza, naan a xalxaal in Rom. Pana a zangaaflu vaawatmitang a maariaas naan ka rasin a lus laaxur wana aubina, aza waamua zina Pontias Paailat. Naan a waamua zin a gaapman in Judia, ma Erot naan a waamua ila pira Gaalili. Filip daaza Erot, naan a waamua ilamun pira Ituriaa ma Traakonaaitis, ma Lisaaniaas naan a waamua ila pira Aabilene. ");
INSERT INTO nal_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aanaas ma Kaaiapaas, nandiaa uru Judaa ma uru waamua zin amun pris faakdul in Judia. La notaan angkanaan, a dorang sin Nakmai xa wat sin Jon, naata Zekaria, araan ka iziar la non bingil. ");
INSERT INTO nal_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Naan ka ra waan farawuk lamun pira vaakdul lapaara daanim Jodaan ma xa fazei zin aubina adu dina inaxam taawuk siaana amun matmalabuk taksaat sin naandi ma dina baaptaais ma Nakmai xana naxaam pizin amun matmalabuk taksaat sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lalozang Jon, a dorang sin a profet Aaisaaia naa ra varaar lamaskana baar zina naako, “A ling axazak ka viviraai la non bingil naako, ‘Naaguna nimnimanin a lan aaxan a Piran, naaguna waafatok amun lan aaxana xuna zangazang. ");
INSERT INTO nal_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Amun balanamaau vaakdul dina sfaar vatok, ma amun paatawut faakdul ma a kaana wut faakdul dina xaaf fatok, ma amun lan ka xolxoli dina waafatok, ma amun lan ka lukluxang dina sfaar vatok. ");
INSERT INTO nal_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma aubina vaakdul dina raamin Nakmai xa zaxot faulin aubina zina.’ ” ");
INSERT INTO nal_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Amun mala di wat sina xuna xana baaptaais naandi, ma naan ka vazei naandi malasing kari, “Nim a funalik sin amun sizi di ikarat! Nis ka ra vazei nim adu naaguna valaau ziaana a boromaazikang sin Nakmai ina xana balas? ");
INSERT INTO nal_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Amun matmalabuk sinim kana vatangin adu naagu inaxam taawuk faanong siaana amun matmalabuk taksaat sinim. Ma tuaa naagu piaat sinim nanga adu Aabaraam a xulmua zinim, panaze ga vazei nim adu Nakmai xat faraxas kana vabalos a funalik aaxan Aabaraam pana amun faat angkari. ");
INSERT INTO nal_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A raamu xa nimniman faanong la vuna amun iaai xuna raraai psinang amun iaai ina xawit na vuain a fnuaai daxa ma dina psin lamaskana axaiaf.” ");
INSERT INTO nal_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma aubina di iaari zina malasing kari, “Malasing ma aze razaan ka maadina giu?” ");
INSERT INTO nal_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon ka xis naandi naako, “Axazak ka rauxin a siot urua, xana ralaas axazak angkaina xawit na rauxin, ma axazak ka rauxin a vanganang, kana giu malasing saait.” ");
INSERT INTO nal_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ubina di zuzuruk a taakis, di wat kuna xana baaptaais naandi, ma di iaari zina malasing kari, “Maravas, maadina saa xari?” ");
INSERT INTO nal_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma naan ka vazei naandi naako, “Tuaa naagu zuruk a taakis ka laaup pana usfa naaguna zuruk.” ");
INSERT INTO nal_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma ubina dauran di iaari zina zaait malasing kari, “Ma maam kari maadina saa?” Ma naan ka xis naandi naako, “Tuaa naagu vangarin luk a kaakaai zin aubina, ma tuaa naagu vakor walau aubina, ma aze ra wulwulang sinim, kat faraxas be.” ");
INSERT INTO nal_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ainaxamang sin aubina vaakdul xa fida ma dit naxaam adu iaak Jon bani a Mesaaia. ");
INSERT INTO nal_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma Jon ka vazei naandi vaakdul naako, “Nia ga baaptaais nim pana a daanim. Singsaxai xa rauxin nanga axazak ka laaup pana nia xana wat. Nia xawit a rapti daxa xuna xanat faraxas gana akpaat a iaarus iwana su zina, wanaze naan ka laaup marazaat pana nia. Naan kana baaptaais nim pana a Laklagaai a Raabu ma wana axaiaf. ");
INSERT INTO nal_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Naan ka ratoting a saawol xuna psin fauzaaiang amun kalamona wit pana maaliu ina xa riaaf pizin amun pakpak siaana amun kala. Naan ka irur la non iwana gimaan psinang amun wit. Ma xana waaturin amun kalamona wit lamaskana vaal iwana ratasmaaiang. Kana zuruk amun pakpaaka wit ma naana vaif lamaskana axaiaf kawit nai maat.” ");
INSERT INTO nal_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon ka vadikdik aubina wana azanon dorang ka varas ma xai fazei wana a dorang ka daxa xa waan sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Singsaxai Jon ka vadawaar Erot, a waamua zin a gaapman, panaze xa maxus sin Erodiaas, taak sin daasna ina xawit nanga na maat, ma varaxai zaait pana azanon saan taksaat ina naa ra giu. ");
INSERT INTO nal_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Malasing ma Erot ka giu vauzaa xaarik aza zaan taksaat araan ka rasin Jon lamaskana a vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Paamua wana araan Jon ka ra iziar la vaal a vaamaazikang, naan kat baaptaais aubina xa varas, ma xa baaptaais saait Iesu. Ma araan Iesu xat maainung, a lia xa ralakas, ");
INSERT INTO nal_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma a Laklagaai a Raabu xa kabal wat malasing a baalus ma xa iziar wana naan. Ma a linga Nakmai xa wat la lia naako, “Nua Naarugu, ina ga sasaxot. Ga nanam mase wana nua.” ");
INSERT INTO nal_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu xa varumara a vaamuzazang sina araan a maariaas sina xa malasing a zangaaflu vaarul. Aubina di naxaam adu naan naata Iosep. Iosep naan naata Eli, ");
INSERT INTO nal_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ma Eli naan naata Maataat, ma Maataat naan naata Livaai, ma Livaai naan naata Melki, ma Melki naan naata Jaanaai, ma Jaanaai naan naata Iosep, ");
INSERT INTO nal_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ma Iosep naan naata Maatatiaas, ma Maatatiaas naata Aamos, ma Aamos naan naata Naaum, ma Naaum naan naata Esli, ma Esli naan naata Naagaai, ");
INSERT INTO nal_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ma Naagaai naan naata Maat, ma Maat naan naata Maatatiaas, ma Maatatiaas naan naata Semein, ma Semein naan naata Iosek, ma Iosek naan naata Iodaa, ");
INSERT INTO nal_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ma Iodaa naan naata Ioaanaan, ma Ioaanaan naan naata Resaa, ma Resaa naan naata Zerubaabel, ma Zerubaabel naan naata Salaaltiel, ma Salaaltiel naan naata Neri, ");
INSERT INTO nal_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ma Neri naan naata Melki, ma Melki naan naata Aadi, ma Aadi naan naata Kosaam, ma Kosaam naan naata Elmaadaam, ma Elmaadaam naan naata Er, ");
INSERT INTO nal_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ma Er naan naata Josua, ma Josua naan naata Eliezaa, ma Eliezaa naan naata Jorim, ma Jorim naan naata Maataat, ma Maataat naan naata Livaai, ");
INSERT INTO nal_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ma Livaai naan naata Simion, ma Simion naan naata Judaa, ma Judaa naan naata Iosep, ma Iosep naan naata Jonaam, ma Jonaam naan naata Eliaakim, ");
INSERT INTO nal_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ma Eliaakim naan naata Meleaa, ma Meleaa naan naata Menaa, ma Menaa naan naata Maataata, ma Maataata naan naata Naaitaan, ma Naaitaan naan naata Dewit, ");
INSERT INTO nal_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ma Dewit naan naata Jesi, ma Jesi naan naata Obet, ma Obet naan naata Boaaz, ma Boaaz naan naata Saalmon, ma Saalmon naan naata Naason, ");
INSERT INTO nal_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ma Naason naan naata Aaminaadaap, ma Aaminaadaap naan naata Raam, ma Raam naan naata Ezron, ma Ezron naan naata Perez, ma Perez naan naata Judaa ");
INSERT INTO nal_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ma Judaa naan naata Jekop, ma Jekop naan naata Aaisaak, ma Aaisaak naan naata Aabaraam, ma Aabaraam naan naata Teraa, ma Teraa naan naata Naaor, ");
INSERT INTO nal_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ma Naaor naan naata Seruk, ma Seruk naan naata Reu, ma Reu naan naata Pelek, ma Pelek naan naata Eber, ma Eber naan naata Selaa, ");
INSERT INTO nal_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ma Selaa naan naata Kaainan, ma Kaainan naan naata Aafaaksaat, ma Aafaaksaat naan naata Sem, ma Sem naan naata Noaa, ma Noaa naan naata Laamek, ");
INSERT INTO nal_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ma Laamek naan naata Metuselaa, ma Metuselaa naan naata Enok, ma Enok naan naata Jaaret, ma Jaaret naan naata Maalalel, ma Maalalel naan naata Kenaan, ");
INSERT INTO nal_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ma Kenaan naan naata Enos, ma Enos naan naata Set, ma Set naan naata Aadaam, ma Aadaam naan naata Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","A Laklagaai a Raabu xa iziar wana Iesu ma xa ramaraat fataling a daanim Jodaan ma xa uli. Ma a Laklagaai a Raabu xa zaxot naan ku lamaskana a non bingil. ");
INSERT INTO nal_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma la non angkanaan, Saatan ka vaxabebeu naan pana a raan ka zangaaflu vaaralavaat. Kawit na iaan tazaan lamaskana amun taan angkanaan, ma wana vaanongang iwana amun taan angkanaan, naan ka lagaai. ");
INSERT INTO nal_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Saatan ka vazei naan naako, “Tamon nua Naata Nakmai, fazei a vaat angkari xuna xana balas a raraba.” ");
INSERT INTO nal_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Iesu xa xis naan malasing kari, “Di ra varaar vating a dorang lamaskana Baar Xoxok malasing kari, ‘Aubina xawit di roro wana a raraba be.’ ” ");
INSERT INTO nal_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Naanaan Saatan ka zaxot luk naan kula waatawut ka uzaa mase laaxur ma fazaaus mase xa vatangin amun bikabar vaakdul ila pira angkari zina. ");
INSERT INTO nal_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma xa vazei Iesu naako, “Gana lis amun burburaaiang faakdul zin naandi ma a marmari daxaiang faakdul zin naandi wana amun lulugaan faakdul zin naandi zunum, panaze amun saan faakdul angkari xa izi la mirugu, ma xat faraxas gana lis sin axazak ga saxot gana lis sina. ");
INSERT INTO nal_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Malasing ma tamon guna lotu wana nia, amun saan faakdul angkari aaxanum.” ");
INSERT INTO nal_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu xa xis naan naako, “Di ra varaar vating a dorang lamaskana Baar Xoxok malasing kari, ‘Guna lotu waan be zin a Piran Nakmai zunum, ma guna vaamuzas be xu naan.’ ” ");
INSERT INTO nal_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Saatan ka zaxot naan kun Jerusalem ma xa varur naan laaxur mase la waata vaal xoxok ma xa vazei naan naako, “Tamon nua Naata Nakmai, guna psin fawizik nua waanaburut. ");
INSERT INTO nal_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Avuna di ra varaar vating a dorang lamaskana Baar Xoxok malasing kari, ‘Nakmai xana kling amun aangelo zina xuna dina raamaai xaaul wana nua, ");
INSERT INTO nal_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ma dina raxut fauzaa nua laaxur wana mita naandi, xuna guna wen tuxin nua wana vaat.’ ” ");
INSERT INTO nal_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma Iesu xa xis naan naako, “A dorang lamaskana a Baar Xoxok ka piaat malasing kari, ‘Tuaa gu vaxabebeu a Piran Nakmai zunum.’ ” ");
INSERT INTO nal_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saatan ka vaxabebeu vanong Iesu wana amun lan faakdul, ma xa luaa naan ma xa zimbong a notaan mase xat faraxas pana naan. ");
INSERT INTO nal_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Naanaan Iesu xa uli xula pira Gaalili ma a dikdikang sin a Laklagaai a Raabu xa iziar wana naan. Ma a dorang pana naan ka waan farawuk lamaskana a pira faakdul angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naan kat faraviraai lamaskana amun faal a maainungang sin naandi ma aubina vaakdul di iwisfarur naan. ");
INSERT INTO nal_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu xa waan la bina laba Naazaret, a bina angkanaan naan ka laba wana. Ma la raan a Saabat, ka albis la vaal a maainungang malasing a rataawukna. Ma xa rur xuna vakotang a dorang sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ma di lis a wilwilaaia baar zin a profet Aaisaaia zina. Naa walaas ma xa tangin a dorang kari lamaskana malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“A Laklagai zin a Piran ka iziar wana nia, wanaze naan ka kalin nia xuna gana fazei wana Dorang Daxa zin aubina di izi gogof. Naan ka ra kling nia xuna pitfiaatang adu aubina di iziar la vaal a vaamaazikang, dina mamaraxas, ma aubina di marawif, dina raamaai, ma aubina ina uzanon dit paramin naandi gana vamamaraxas naandi, ");
INSERT INTO nal_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma gana pitfiaat adu naari a maariaas sin a Piran kana lis a daxaiang sin aubina.” ");
INSERT INTO nal_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Naanaan Iesu xa bafkol a wilwilaaia baar ma naa lis faulin sin a iaana kilaaiang ma xa ziar wizik paanaburut. Aubina vaakdul lamaskana a vaal a maainungang di damin naan. ");
INSERT INTO nal_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma naan ka varumara dadorang sina zin naandi naako, “A dorang kanaan naagu langarin, taning faanong ka balas faaratunaan.” ");
INSERT INTO nal_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma naandi vaakdul di nanam pana naan, ma di banglala wana a dorang ka daxa xa wat la ngusna. Singsaxai di iaari malasing kari, “Naan bani naata Iosep, aan?” ");
INSERT INTO nal_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma Iesu xa vazei naandi naako, “Taulaan naaguna dador lalaamangaai wana nia lalozang a dorang kari naako, ‘Dokta, fira nua nanga! Amun saan faakdul maadi ra langarin gu ra giu la bina laba Kaapernaaum, guna giu iriat la bina zunum faatak.’ ” ");
INSERT INTO nal_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iesu xa piaat fauzaa xaarik naako, “Ga vazei varatunaan nim, aubina zin a profet la bina zina vaatak kawit di rudaxain naan. ");
INSERT INTO nal_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ga vazei varatunaan nim, adu laraan sin Elaaija, xa rauxin amun raksiziar xa varas in Israael. Ma xawit a daavur wana a maariaas urul ma akbal, ma adi zong ka balas lamun bina vaakdul ila pira. ");
INSERT INTO nal_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Singsaxai Nakmai xawit na kling Elaaija xa waan sin tazaxai zin naandi, xawit. Naan ka waan sin aza raksiziar xa iziar la bina laba Zaarefaat la pira Saaidon. ");
INSERT INTO nal_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Malasing saait la raan sin a profet Elisa, xa rauxin aubina xa varas in Israael di rauxin a giazang tapak, singsaxai xawit tazaxai zin naandi a wina xa ninis siaana a giazang kanaan, Naamaan singbe, ila pira Siria.” ");
INSERT INTO nal_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aubina vaakdul lamaskana a vaal a maainungang, di boromaazik mase araan di langarin a dorang kanaan. ");
INSERT INTO nal_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Di ramaraat ma di urif fatukbilok naan fataling a bina laba, xula xis a wut la non angkanaan a bina laba xa iziar wana, xuna dina psin fawizik naan paanaburut. ");
INSERT INTO nal_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Singsaxai naan ka zangas lu labirua wana adi mala angkanaan ma xa waan pana a zangazang sina. ");
INSERT INTO nal_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Naanaan Iesu xa kabal wizik Kaapernaaum, aza bina laba in Gaalili. Ma la raan a Saabat, Iesu xa albis lamaskana a vaal a maainungang ma xa varumara viraaiang aubina. ");
INSERT INTO nal_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aubina di banglala wana a varaviraaiang sina wanaze a dorang sina xa rauxin a burburaaiang. ");
INSERT INTO nal_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Inaan lamaskana a vaal a maainungang ka rauxin aza rapti, a zapalaau xa ragul naan. Ka viraai laba mase la waata lingna naako, ");
INSERT INTO nal_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aai! Iesu in Naazaret, aze razaan gu saxot pana maam? Gu saa, gu wat kari xuna guna vanong pizin ka maam? Ga rexaazin nua. Nua a Rapti Xoxok sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu xa vadawaar naan naako, “Siburung ma gu tukbilak siaana!” A zapalaau xa psin fawizik naan paanaburut, lamarana naandi vaakdul ma xa tukbilak siaana, singsaxai xawit na kawin naan. ");
INSERT INTO nal_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aubina vaakdul di banglala ma di dador lawalaua naandi malasing kari, “Aze ra wat faraviraaiang kanaan? Naan kai dador varaxai wana a burburaaiang ma dikdikang ma xai lis a dorang dikdik sin amun sapalaau ma di itukbilak siaana aubina.” ");
INSERT INTO nal_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma a dorang pana Iesu xa waan farawuk lamun bina vaakdul xa iziar varaxulin a non laba angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu xa vataling a vaal a maainungang ma xa waan la vaal zin Saaimon. Ma nimuna Saaimon ka gias, a wina xa lagaf marazaat, ma naandi di maainung Iesu xuna vawaalang naan. ");
INSERT INTO nal_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu xa rur lapaarana ma xa vadawaar a winlagaf, ma a winlagaf ka vataling naan. Ma fazaaus mase, a ravin ka ramaraat ma xa wa nimnimanin a vanganang aaxan naandi. ");
INSERT INTO nal_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Araan a iaas kai si wizik, aubina di zaxot fawat aubina vaakdul ina di rauxin atavur amun giazang sin Iesu, ma xa rasin uru mitna wana naandi zaksaxai ma xa vira naandi. ");
INSERT INTO nal_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Amun sapalaau di tukbilak siaana aubina xa varas ma dit firaai malasing kari, “Nua Naata Nakmai,” wanaze naandi di rexaas adu naan a Mesaaia. Singsaxai Iesu xa vadawaar naandi xuna tuaa dina dador. ");
INSERT INTO nal_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A bina xa rataan puat ma Iesu xa luaa a bina laba ma xa waan laza non ka bingil. Aubina di zazaleng naan, ma araan di wat la non naa iziar wana, di saxot dina vaxadong naan kuna tuaa xana vataling naandi. ");
INSERT INTO nal_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Singsaxai Iesu xa piaat naako, “Gana fazei wana a Dorang Daxa iwana a bikabar zin Nakmai lamun bina laba rawarak saait, panaze naan a vuvuna xari Nakmai xa kling fawat nia.” ");
INSERT INTO nal_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naan ka waan ma xa maandaau nanga wana ifazeiang lamaskana amun faal a maainungang in Judia. ");
INSERT INTO nal_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Aza raan Iesu xa irur laxon ila Laman Genesaret, ma aubina di wat bas faraxulin naan ma dit langarin a dorang sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naan ka raamin a mon urua laxon, ubina dit faaian di luaa ma di zuksuk aubina zin naandi. ");
INSERT INTO nal_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ka xawas lamaskana azaxai zin uru mon angkanaan, a mon sin Saaimon, ma xa maainung Saaimon kuna xana urif faamumurin fauzaa a mon la laman. Naanaan Iesu xa ziar lamaskana a mon ma xat firaai aubina. ");
INSERT INTO nal_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Araan ka dador vaanong, ka vazei Saaimon naako, “Naagu kaaul waan la non ka lamlamanang ma naagu rasin fawizik amun aubina zinim kuna naaguna vaaian.” ");
INSERT INTO nal_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Saaimon ka xis naan malasing kari, “Dipiran, maadi gut faraan, singsaxai maadi vaagof. Singsaxai gana rasin fawizik kaarik amun aubina waanaburut, panaze nua gu piaat.” ");
INSERT INTO nal_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma araan naadi giu malasing naa ra piaat, di urif amun ian ka varas marazaat mase, malasing ma amun aubina zin naandi faasilik kana ramatar. ");
INSERT INTO nal_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Di xalif luk amun paliaana naandi lamaskana aza mon kuna dina wat ma dina vawaal naandi. Amun paliaana naandi di wat ma di sfaar vambos mase uru mon angkanaan malasing ma uru mon faasilik dina lus iaa. ");
INSERT INTO nal_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Araan Saaimon Pita xa raamin azaan angkanaan, ka zibukaak la xaaka Iesu ma xa piaat naako, “Piran, paan siaagu. Nia a rapti raksaat!” ");
INSERT INTO nal_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Avuna naan ma amun paliaana vaakdul di banglala mase wana amun ian naadi ra urif. ");
INSERT INTO nal_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma Jems nandiaa Jon saait di banglala iaa mase. Nandiaa uru naata Zebedi, ma amun paliaana Saaimon pana vaaianang ma dit suruk kaakaai wana. Naanaan, Iesu xa vazei Saaimon naako, “Tuaa gu maraaut, taning ma xa uzaa, gunat purif aubina.” ");
INSERT INTO nal_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Naanaan di urif taal uru mon sin nandiaal xu laxon. Ma di vataling taal amun saan faakdul ma di los taal Iesu. ");
INSERT INTO nal_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesu xai ziar laza bina laba ma aza rapti, a wina xa raksaat mase wana tapak, ka wat sina. Araan ka raamin Iesu, xa psin fawizik naan paanaburut la pira ma xa maainung Iesu naako, “Piran, tamon gu saxot, kat faraxas guna vaninis nia.” ");
INSERT INTO nal_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu xa rasin fawat a mitna ma xa xaaf a wina rapti ma xa piaat naako, “Ga saxot! Guna ninis!” Fazaaus mase a tapak ka vataling naan ma a wina rapti xa ninis. ");
INSERT INTO nal_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iesu xa dador dikdik sina naako, “Tuaa gu vazei taxazak pana azaan angkanaan ka ra balas sunum. Singsaxai gu waan ma gu vatangin a winum sin a pris, ma gu lis a talazang sin Nakmai malasing Moses ka ra piaat lamaskana Baar Xoxok, kuna aubina vaakdul dina rexaas adu a giazang sunum ka vaanong.” ");
INSERT INTO nal_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Singsaxai a dorang pana Iesu xa valaau varawuk nanga ma amun amala aubina di wat kuna langarinang naan ma xuna naan kana vira zaait amun giazang sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma amun taan ka varas Iesu xai waan la non bingil ma xat maainung. ");
INSERT INTO nal_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aza raan araan Iesu xat firaai aubina, amun Faarasi ma amun maravas iwana amun Lus sin Moses di iziar zaait inaan. Naandi di wat lamun bina vaakdul in Gaalili ma Judia ma Jerusalem. Ma a dikdikang sin a Piran ka iziar wana naan kuna viraiang aubina di gias. ");
INSERT INTO nal_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Azanon ubina di vazaak fawat aza rapti xa zipas pana a iban, ma di saxot dina zaxot falbis naan ku lamaskana vaal ma dina vamaal naan lamarana Iesu. ");
INSERT INTO nal_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Singsaxai xawit nat faraxas dina tangin ta lan kuna dina zaxot fawat naan sin Iesu, wanaze adi mala marazaat. Malasing ma di vazaak a zipas kula waata vaal laaxur. Ma di waafining a mara laaxur la waata vaal. Ma di vakabaal vawizik naan pana a iban sina lamaskana a mara angkanaan, labirua wana adi mala angkanaan lamarana Iesu. ");
INSERT INTO nal_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Araan Iesu xa raamin fakilaan ainaxam paazaaiang sin naandi, xa piaat naako, “Paasaxo zurugu, ga naxaam pizin amun matmalabuk taksaat sunum.” ");
INSERT INTO nal_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amun Faarasi ma amun maravas iwana amun Lus sin Moses di inaxam lamaskana naandi zaksaxai malasing kari, “Nis axazak angkari xa dador lingpuak lawaana Nakmai? Nis kat faraxas kana naxaam pizin amun matmalabuk taksaat? Nakmai zingbe.” ");
INSERT INTO nal_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu xa rexaazin ainaxamang sin naandi ma xa iaari naako, “Kunaze naagu naxaam amun saan angkanaan lamaskana nim? ");
INSERT INTO nal_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aze ra dorang ka maravas kuna piaatang? ‘Amun matmalabuk taksaat sunum ga naxaam pizin,’ o gana piaat, ‘Tamaraat, ma guna zangas.’ ");
INSERT INTO nal_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Singsaxai gana piaat malasing kari xuna naaguna rexaas adu Naata Rapti xa rauxin a burburaaiang la pira angkari xuna naxaam pizinang amun matmalabuk taksaat.” Ma naan ka vazei a zipas naako, “Tamaraat, suruk luk amun saan imilaaivang sunum ma gu waan la vaal zunum.” ");
INSERT INTO nal_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Fazaaus mase, a zipas ka rur lamarana naandi, ma xa zuruk amun saan naa itate wana ma xa waan la vaal zina, ma xai wisfaru Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aubina vaakdul di banglala marazaat mase ma di balaxof ma di wisfaru Nakmai ma di piaat malasing kari, “Amun saan ka rawarak mase maadi raamin ka balas taning!” ");
INSERT INTO nal_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lamuraana amun saan angkanaan ka balas, Iesu xa waan ma xa raamin aza rapti ina xat suruk a taakis. Aizina xanaan Livaai ma xa iziar la non iwana wulwulang a taakis. Ma Iesu xa vazei naan naako, “Los nia.” ");
INSERT INTO nal_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livaai xa ramaraat fataling amun saan faakdul ma xa los Iesu. ");
INSERT INTO nal_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livaai xa giu a flangan laba aaxan Iesu la vaal zina. Ma ubina xa varas mase iwana zurukang a taakis ma azanon ubina zaait di vavangan faraxai wana nandiaa. ");
INSERT INTO nal_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Singsaxai amun Faarasi ma amun maravas iwana amun Lus sin Moses, naandi zin a lemlem Faarasi, di dador varvaras sin ubina varaviraai zin Iesu malasing kari, “Kunaze naagu vangan ma naagu imin faraxai wana ubina di zuzuruk a taakis ma ubina di gigiu amun matmalabuk taksaat?” ");
INSERT INTO nal_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma Iesu xa xis naandi naako, “Aubina xawit di gias dina wen paan sin a dokta, singsaxai naandi be di gias dina waan sin a dokta. ");
INSERT INTO nal_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ga wat kawit kuna gana viring aubina di tak dina inaxam taawuk. Kawit. Nia ga wat kuna gana viring luk aubina di gigiu a matmalabuk taksaat kuna dina inaxam taawuk.” ");
INSERT INTO nal_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Azanon aubina di piaat sin Iesu malasing kari, “Ubina varaviraai zin Jon bulaai dit falvaal ma dit maainung ma malasing saait ubina varaviraai zin amun Faarasi. Singsaxai ubina varaviraai zunum di vavangan ma di imimin.” ");
INSERT INTO nal_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ma Iesu xa xis naandi malasing kari, “Ubina di maainung fawat naandi wana vaamaxuzang, dina mitat falvaal araan a rapti dina vamaxuzin ka iziar varaxai wana naandi? ");
INSERT INTO nal_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Singsaxai a raan kana wat araan dina zaxot pizin a rapti di vamaxuzin siaana naandi, ma lamuraana raan angkanaan laxo dina valvaal.” ");
INSERT INTO nal_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu xa vazei naandi wana a dorang lalaamangaai malasing kari, “Kawit taxazak kai taar luk a waan marapi wana a marapi vaaxur ma naat saxazit pana a marapi xabaar. Tamon naana giu malasing kanaan, kana kawin a marapi vaaxur ma a waan marapi iwana marapi vaaxur zaait kana wen taamaai vatfaraxas pana a marapi xabaar. ");
INSERT INTO nal_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma xawit taxazak kat fitor sfaar a waain faaxur lamaskana a wakpaaka waain kabaar ina di giu wana a wina xaktalavaat. Tamon naana giu malasing kanaan, a waain faaxur xana pau taraar a wakpaaka waain kabaar ma a waain kana ravukaai psaai ma a wakpaakna xana raksaat. ");
INSERT INTO nal_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Malasing ma dina vitor sfaar nanga a waain faaxur lamaskana a wakpaaka waain faaxur. ");
INSERT INTO nal_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma xawit taxazak na saxot kana imin a waain faaxur lamuraana xa imin a waain kabaar, wanaze xana piaat naako, ‘A waain kabaar nanga xa daxa, ma xat faraxas pana nia.’ ” ");
INSERT INTO nal_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aza raan a Saabat, Iesu xa zazangas lu lamaskana amun uma wit. Ma ubina varaviraai zina di ramaraat ma di mos azanon kalamona wit, ma di zuga la mita naandi xuna waapizinang a wakpaakna ma naadi iaan. ");
INSERT INTO nal_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Azanon Faarasi di iaari zina malasing kari, “Kunaze naagu giu azaan angkanaan ma naagu laxau a lus ina xa pitkol adu tuaa di vaamuzas la raan a Saabat?” ");
INSERT INTO nal_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma Iesu xa xis naandi naako, “Malasing faa, xawit nanga naagu vakot a dorang pana aze razaan Dewit ka giu araan naan ma ubina zina di lagaai? ");
INSERT INTO nal_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Naan ka albis lamaskana a vaal zin Nakmai, ma xa zuruk a raraba di talazin sin Nakmai ma naa iaan ma xa lis saait azanon sin ubina zina. Amun lus sin Moses ka piaat adu amun pris be dina iaan a raraba angkanaan.” ");
INSERT INTO nal_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naanaan Iesu xa vazei naandi naako, “Naata Rapti, naan a Piraana Saabat.” ");
INSERT INTO nal_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Laza raan a Saabat, Iesu xa albis lamaskana a vaal a maainungang sin amun Judaa ma xat firaai aubina. Ma xa rauxin aza rapti inaan a mit sazaxa zina xa maat. ");
INSERT INTO nal_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Amun Faarasi ma amun maravas iwana amun Lus sin Moses dit sazaleng tazaan kuna vakorang Iesu. Malasing ma di rataamin falagot naan tamon kana vira taxazak la raan a Saabat. ");
INSERT INTO nal_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Singsaxai Iesu xa rexaazin ainaxamang sin naandi ma xa vazei a rapti ina aza mitna xa maat naako, “Tamaraat ma gu rur lamarana aubina vaakdul.” Ma a rapti xa ramaraat ma xa rur. ");
INSERT INTO nal_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mur Iesu xa piaat sin naandi naako, “Ga iaari zinim, amun lus sin Moses ka piaat aze razaan dina giu la raan a Saabat? Kuna giuang a daxaiang o xuna giuang a raksaatang, kuna zaxot faulinang axazak o xuna vanong pizinang a roroiang sina?” ");
INSERT INTO nal_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Naan ka raamaai varawuk pana naandi vaakdul ma xa vazei a rapti naako, “Fatok a mirum.” A rapti xa giu malasing naa piaat, ma a mitna xa daxa uli xaarik. ");
INSERT INTO nal_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Singsaxai a maskana naandi xa raksaat mase ma di dador lawalaua naandi wana aze razaan naadina giu wana Iesu. ");
INSERT INTO nal_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aza raan lamun taan angkanaan, Iesu xa waan la waatawut kuna wa maainungang, ma a suk faakdul angkanaan ka maainung paan sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","A bina xa raan, ma Iesu xa viring fawat aubina varaviraai zina, ma xa kalin luk naandi di zangaaflu ma urua, ma xa vakilaan saait naandi amun aaposal. ");
INSERT INTO nal_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Aizina naandi xari, Saaimon (naa vakilaan pana Pita) ma daasna Endru, ma Jems, ma Jon, ma Filip, ma Baatalomeu, ");
INSERT INTO nal_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma Metiu, ma Tomaas, ma aza Jems naata Aalfias, ma aza Saaimon ina di vakilaan pana Zelot, ");
INSERT INTO nal_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma Judaas naata Jems, ma Judaas Iskaariot ina xana lis Iesu la mit amun purua. ");
INSERT INTO nal_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesu xa kabal la waatawut faraxai wana naandi, ma xa rur la non ka tak. Adi xulutung aubina varaviraai zina di irur zaait inaan faraxai wana adi mala aubina ilamun bina in Judia ma ila bina laba Jerusalem ma aubina i laxon Taair ma Saaidon. ");
INSERT INTO nal_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Naandi di wat kuna langarinang naan ma xuna xana vira naandi wana amun giazang sin naandi. Ma naandi ina amun sapalaau di kawin a roroiang sin naandi, Iesu xa mof pizin amun sapalaau angkanaan ma di daxa xaarik. ");
INSERT INTO nal_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma aubina vaakdul di saxot dina xaaf naan panaze a dikdikang kai tukbilak pana naan ma xat fira naandi vaakdul. ");
INSERT INTO nal_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu xa raamin aubina varaviraai zina ma xa piaat naako, “Nim naagu izi gogof, Nakmai xa lis a daxaiang sinim, panaze a bikabar zin Nakmai aaxan nim. ");
INSERT INTO nal_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nim naagu lagaai taning, Nakmai xa lis a daxaiang sinim, panaze naaguna maazur. Nim naagu raangis taning, Nakmai xa lis a daxaiang sinim, panaze naaguna nangan. ");
INSERT INTO nal_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Naaguna dokdok, nim ina aubina di maska raksaat pana nim, ma di vakot pizin nim ma di lingpuak lawaana nim, ma di bain aizina nim adu xa raksaat avuna wana Naata Rapti, Nakmai xa lis a daxaiang sinim. ");
INSERT INTO nal_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Naaguna dokdok la raan angkanaan ma naaguna fida wana nanamang panaze adi wulwulang laba zinim ka izit simbong nim ikula la lia. Avuna amun kulmua zin naandi di giu malasing kanaan pana amun profet. ");
INSERT INTO nal_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Singsaxai xana raksaat pana nim naagu raxumbaaxut taning, panaze naagu zuruk fanong amun saan kuna madaiang nim. ");
INSERT INTO nal_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kana raksaat pana nim naagut fangan maazur taning, panaze naaguna lagaai. Kana raksaat pana nim naagu nangan taning, panaze naaguna maskalus ma naaguna raangis. ");
INSERT INTO nal_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kana raksaat pana nim ina aubina vaakdul di wisfalik nim, avuna amun kulmua zin naandi di wisfalik saait amun profet faagit.” ");
INSERT INTO nal_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ma Iesu xa piaat kaarik naako, “Singsaxai ga vazei nim angkanaan naagut langar zurugu. Naaguna sasaxot aubina di purua wana nim, ma naaguna giu a daxaiang pana naandi dit maska raksaat pana nim. ");
INSERT INTO nal_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Naaguna giu a daxaiang pana naandi di pitlis a raksaatang kana kawin a roroiang sinim. Ma naaguna maainung pana naandi ina di purua wana nim. ");
INSERT INTO nal_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tamon taxazak kana rabaaf nua la paarum, lis aza paarum kuna naana rabaaf saait. Tamon taxazak ka zuruk a marapi baraaf sunum, luaa naan kana zuruk saait a marapi zunum i laaxur. ");
INSERT INTO nal_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gu ralaas naandi vaakdul ina dit maainung nua. Ma tamon axazak ka zuruk tazaan sunum, tuaa gu iaariin faulin. ");
INSERT INTO nal_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Naaguna giu amun matmalabuk faakdul wana naandi malasing naagu saxot naandi dina giu vawat sinim. ");
INSERT INTO nal_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tamon naagu sasaxot be naandi di sasaxot nim, aze ra daxaiang naaguna zuruk? Aubina di gigiu amun matmalabuk taksaat saait di sasaxot aubina di sasaxot naandi. ");
INSERT INTO nal_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma tamon naagu gigiu be a daxaiang pana naandi di daxa wana nim, aze ra daxaiang naaguna zuruk? Aubina di gigiu amun matmalabuk taksaat saait di gigiu malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma tamon naagu lis tazaan sin uzanon ina naagu saxot naadina xis, aze ra daxaiang naaguna zuruk? Aubina di gigiu amun matmalabuk taksaat saait di lis amun saan sin aubina di gigiu amun matmalabuk taksaat, ma di saxot saait dina xis fakdul vaulin. ");
INSERT INTO nal_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Singsaxai naaguna sasaxot aubina di purua wana nim, ma naaguna daxa wana naandi. Ma naaguna lis amun saan sin naandi ma naaguna wen naxaam adu naadina xis faulin. Ma mur a wulwulang sinim kana laaup mase ma amun matmalabuk angkanaan kana vatangin adu nim a funalik sin Nakmai Laaxur Mase, wanaze naan kai daxa wana aubina xawit di wisfaadaxa ma aubina di raksaat. ");
INSERT INTO nal_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Naagunat maluf aubina malasing be Damana nim kat maluf naandi.” ");
INSERT INTO nal_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma Iesu xa piaat kaarik naako, “Tuaa naagu klis amun matmalabuk sin azanon tawarak, kuna tuaa Nakmai xana klis amun matmalabuk sinim. Tuaa naagu vakor taxazak pana ta dorang, kuna tuaa Nakmai xana vakor nim pana ta dorang. Naaguna naxaam pizin amun matmalabuk taksaat sin aubina di giu wana nim, ma Nakmai xana naxaam pizin amun matmalabuk taksaat sinim. ");
INSERT INTO nal_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Naaguna ralaas aubina rawarak, ma Nakmai xana ralaas nim. Ma naaguna zuruk adi wulwulang laba mase, naana sfaar vambos, ma naana pa vawizik paanaburut ma naana gurgurungin, ma xana bas pakluaai ma xana ravukaai zavur nim. Usfa naagu ralaas azanon tawarak pana, naan awat talazang bani Nakmai xana ralaas nim pana.” ");
INSERT INTO nal_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu xa vazei naandi wana aza dorang lalaamangaai malasing kari, “Malasing faa, xat faraxas a marawif kana vindaan aza marawif? Tamon kana vindaan naan, nandiaa varaxai dina zu iaa lamaskana luk. ");
INSERT INTO nal_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A nalik faraviraai xawit na laaup pana a maravas sina. Singsaxai araan naandi vaakdul, a funalik faraviraai di vanong a varaviraaiang sin naandi, naandi dinat faraxas malasing a maravas sin naandi.” ");
INSERT INTO nal_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ma aza dorang lalaamangaai xaarik Iesu xa vazei naandi wana xa malasing kari, “Kunaze gu raamaai wana a nan bes lamarana daazum, ma nua nanga xawit gu raamin fakilaan a palaang ka iziar la maraam? ");
INSERT INTO nal_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tamon kawit gu raamin fakilaan a palaang ka iziar la maraam, guna mitai piaat sin daazum malasing kari, ‘Taatum, laawus gana waapizin a nan bes la maraam’? Nua a rapti gui piaat azaan singsaxai xawit gut falos. Guna waapizin kalaak a palaang ka waakol a maraam ma mur laxo guna raamaai daxa xuna guna waapizin a nan bes lamarana daazum.” ");
INSERT INTO nal_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ma Iesu xa dador lalaamangaai xaarik naako, “A iaai daxa xawit nat fuain a fnuaaia iaai raksaat. Ma a iaai raksaat kawit nat fuain a fnuaaia iaai daxa. ");
INSERT INTO nal_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Dina raamin fakilaan a iaai wana a fnuaai iwana. Aubina xawit di mos a fnuaai iwana fik pana a iaarus koxot. Ma xawit di mos a fnuaai a waain pana a iaai masang. ");
INSERT INTO nal_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A rapti daxa xat fabalos a daxaiang pana amun saan daxa xa iziar lamaskana. A rapti raksaat kat fabalos a raksaatang pana amun matmalabuk taksaat ka iziar lamaskana. Avuna araan a maskana axazak ka bas pakluaai wana aze ramun saan, kana tukbilak lu la ngusna ma naana piaat.” ");
INSERT INTO nal_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Iesu xa piaat kaarik naako, “Kunaze naagut fakilaan nia, ‘Piran, Piran,’ singsaxai xawit naagut falos a dorang surugu? ");
INSERT INTO nal_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gana viraai nim pana axazak kat langarin a dorang surugu ma naat falos. ");
INSERT INTO nal_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Naan ka malasing a rapti xa varur a vaal. Ka xaaf fawizik mase a luk ipaa waanaburut ma xa rasin fawizik a vaanga vaat lamaskana a luk angkanaan laaxur wana a vaat siar xuna vaziaarang a vaal. Ma araan adi ulim ka fazak puat, ka vatfalingin a vaal angkanaan. Singsaxai a vaal xawit na rambara wizik paanaburut, panaze naa giu vatalamin mase. ");
INSERT INTO nal_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Singsaxai a rapti xa langarin a dorang surugu ma xawit naa valos, ka malasing a rapti xa varur a vaal wana a pira, ma xawit na tabung tasin fawizik kalaak a vaanga vaat kuna vaziaarang a vaal. Araan adi ulim ka vatfalingin a vaal angkanaan, ka rambara wizik paanaburut ma xa vaanong faakdul mase.” ");
INSERT INTO nal_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu xa piaat fanong amun saan angkanaan sin aubina, ma xa albis la bina laba Kaapernaaum. ");
INSERT INTO nal_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aza waamua zin a zangaaflu varazuai ubina dauran in Rom, ka iziar inaan. Naan ka rauxin a iaana kilaaiang, ma xa rauxin a varanopang laba wana naan. A iaana kilaaiang kanaan ka gias taksaat ma faasilik ka xana maat. ");
INSERT INTO nal_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Araan a waamua angkanaan ka langarin a dorang pana Iesu xa balas inaan, naan ka kling azanon paamua zin amun Judaa xa waan sin Iesu, xuna dina wa maainung naan kana wat fira a iaana kilaaiang kanaan sina. ");
INSERT INTO nal_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Di wat sin Iesu ma di maainung fadikdik naan malasing kari, “A rapti angkanaan a rapti daxa, ma xa daxa tamon guna vawaal naan, ");
INSERT INTO nal_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","panaze naan kai sasaxot dia amun Judaa ma xa giu a vaal a maainungang sin dia.” ");
INSERT INTO nal_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Malasing ma Iesu xa waan faraxai wana naandi. Naan ka wat ka faasilik pana a vaal zin a waamua angkanaan sin ubina dauran, ma a waamua angkanaan ka kling azanon paasaxo zina ma di waan sin Iesu wana a dorang malasing kari, “Piran, tuaa gu varalil nua nanga wana watang. Nia xawit a rapti daxa xuna guna albis la vaal zurugu. ");
INSERT INTO nal_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Malasing ma ga naxaam adu nia xawit a rapti daxa xuna xanat faraxas gana wat sunum. Singsaxai gu piaat be ma a iaana kilaaiang surugu xana daxa. ");
INSERT INTO nal_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ga piaat malasing kanaan panaze nia zaait ga iziar lawaana burburaaiang sin azanon paamua zurugu, ma azanon ubina dauran di iziar lawaanugu. Ma araan ga piaat sin azaxai angkari, ‘Paan,’ naan ka waan. Ma araan ga piaat sin axazak angkanaan, ‘Laawus,’ naan ka wat. Ma araan ga piaat sin a iaana kilaaiang surugu malasing kari, ‘Giu azaan angkari,’ naa giu.” ");
INSERT INTO nal_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Araan Iesu xa langarin, ka banglala. Naan ka rutaawuk ma xa vazei adi mala aubina ina di los naan naako, “Ga vazei nim, lamaskana Israael vaakdul, xawit nanga ga tangin taxazak ainaxam paazaaiang sina xa laaup malasing sin a rapti angkari!” ");
INSERT INTO nal_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ubina angkanaan ina a waamua iwana dauran ka kling naandi, di uli xula vaal zina ma di raamin a iaana kilaaiang sina xa daxa vaanong. ");
INSERT INTO nal_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A notaan mumut lamur, Iesu xa waan laza bina laba di vakilaan Naain, ma ubina varaviraai zina varaxai wana adi mala aubina di waan faraxai wana naan. ");
INSERT INTO nal_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Araan di balas lamarana lan ila bina laba angkanaan, aubina ininaan dit fazaak aza rapti xa maat, naan a nalik be azaxai zin aza raksiziar, ma adi amala ila bina laba angkanaan di zazangas tukbilak siaana a bina laba varaxai wana naan. ");
INSERT INTO nal_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Araan a Piran Iesu xa raamin a ravin angkanaan, a maskana xa bas saxotang naan ma xa piaat sina naako, “Tuaa gu raangis!” ");
INSERT INTO nal_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ma xa wa xaaf a bogis sin a maat angkanaan, ma ubina dit fazaak di rur. Ma xa piaat sin a maat naako, “A xulaau! Ga vazei nua, tamaraat!” ");
INSERT INTO nal_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A rapti xa maat ka ramaraat ma xa iziar ma xa dador. Ma Iesu xa lis faulin naan sin naanaa zina. ");
INSERT INTO nal_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aubina vaakdul di banglala ma di maraaut ma di wisfaru Nakmai. Ma di piaat malasing kari, “Aza profet laba xa balas faanong lawalaua dia! Ma Nakmai xa balas faanong kuna vawaalang aubina zina!” ");
INSERT INTO nal_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma a dorang pana Iesu xa waan farawuk lamaskana Judia vaakdul ma lamun non tawarak saait lapaarana. ");
INSERT INTO nal_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ubina varaviraai zin Jon, di vazei Jon pana amun gigiuang faakdul angkanaan sin Iesu. Naan ka viring luk fawat urua zin naandi, ");
INSERT INTO nal_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma xa kling nandiaa xa waan sin a Piran kuna dina iaari iaa zina malasing kari, “Malasing faa, naan nua xari axazak ina xana balas, o maadina zimbong axazak tawarak nanga?” ");
INSERT INTO nal_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Di balas iaa zin Iesu ma di piaat iaa malasing kari, “Jon A Rapti Iwana Baaptaaizang ka kling fawat nimaa zunum kuna maadina iaari iaa zunum malasing kari, ‘Malasing faa, naan nua xari axazak ina xana balas, o maadina zimbong axazak tawarak nanga?’ ” ");
INSERT INTO nal_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","La notaan angkanaan, Iesu xa vira amala aubina wana amun giazang sin naandi, ma xa mof pizin amun sapalaau ziaana aubina ma xa kaas a marana aubina xa varas ina di marawif. ");
INSERT INTO nal_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ma naan ka xis uru rapti di fazak dorang iaa zin Jon naako, “Naaguna uli iaa ma guna vazei iaa Jon pana amun saan naagu ra raamin iaa ma naagu ra langarin iaa. Amun saan malasing, amun marawif di raamaai, ma amun kaak taksaat di zangas, ma naandi di rauxin a tapak, a wina naandi xa daxa, ma amun lingambat di langar, ma aubina di maat di ramaraat puli, ma aubina di izi gogof di langarin a Dorang Daxa. ");
INSERT INTO nal_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nakmai xana lis a daxaiang ka waan sin axazak ina xana wen su vataling nia wanaze a maskana xana wen taksaat pana amun gigiuang surugu.” ");
INSERT INTO nal_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lamuraana uru rapti di uli waan iaa zin Jon, Iesu xa dador zin axulutung pana Jon naako, “Aze rawat tapti naagu ra naxaam adu naaguna raamin araan naagu wa raamin Jon la non bingil? Malasing faa, naagu ra naxaam adu naaguna raamin a rapti xa malasing a ri, xat falvaaliang pana maaliu xai wif? ");
INSERT INTO nal_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tamon kawit, aze razaan naagu ra naxaam naaguna wa raamin? A rapti xa valaak a mamaauzang daxa mase? Kawit. Aubina dit falaak a mamaauzang daxa mase ma a maraana xa uzaa laaxur ma di rauxin amun lulugaan ka varas marazaat, di iziar lamaskana amun faal laba zin amun kalxaal. ");
INSERT INTO nal_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Naagu vazei nia, aze razaan naagu wa raamin? A profet? Aiang, ga vazei nim, naagu waan kuna wa raaminang a rapti xa laaup pana amun profet sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Naan a rapti angkanaan a Baar Xoxok ka dador wana naan malasing kari, ‘Gana kling a wangpaang surugu waamua wana nua, xuna xana nimnimanin a lan aaxanum.’ ” ");
INSERT INTO nal_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ma Iesu xa piaat kaarik naako, “Ga vazei nim, pana aubina vaakdul la pira angkari, xawit taxazak sin naandi xa laaup pana Jon. Singsaxai tamon axazak kawit ta izina lamaskana a bikabar zin Nakmai, naan ka laaup pana Jon.” ");
INSERT INTO nal_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aubina vaakdul, varaxai zaait pana ubina di zuzuruk a taakis, Jon ka ra baaptaais naandi. Naandi di langarin a dorang sin Iesu ma di rudaxa adu a lan sin Nakmai xa tak. ");
INSERT INTO nal_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Singsaxai amun Faarasi ma amun maravas iwana amun Lus sin Moses di bain ainaxamang sin Nakmai wana naandi nanga, avuna di baai Jon kana baaptaais naandi. ");
INSERT INTO nal_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma Iesu xa piaat kaarik naako, “Gana dador lalaamangaai wana a watkul i taning pana aze rawat saan? Di malasing aze? ");
INSERT INTO nal_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Di malasing a funalik di iziar la xumanar, ma dit firaai varawuk lawalaua naandi nanga malasing kari, ‘Maadi wif a lexu aaxan nim, ma xawit naagu riria, maadi rangan maaluf, ma xawit naagu raangis!’ ” ");
INSERT INTO nal_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ma Iesu xa piaat kaarik naako, “Jon A Rapti Iwana Baaptaaizang ka wat, ma xa valvaal wana vanganang ma xawit na imin a waain, ma naagu piaat malasing kari, ‘A zapalaau xa ragul naan.’ ");
INSERT INTO nal_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Singsaxai Naata Rapti xa wat ma xa vangan ma xa imin, ma naagu piaat malasing kari, ‘Naagu raamin, naan a balang ma a rapti xa imimin famarazaat a daanim dikdik, ma naan a paasaxo zin ubina di zuzuruk a taakis ma zin aubina di gigiu amun matmalabuk taksaat!’ ");
INSERT INTO nal_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Singsaxai aubina vaakdul ina di rauxin a mazamang sin Nakmai, a roroiang sin naandi xa vatangin adu a mazamang sina naan a mazamang faaratunaan.” ");
INSERT INTO nal_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Azaxai zin amun Faarasi angkanaan ka maainung Iesu xuna xana wa vangan faraxai wana naan. Iesu xa albis lamaskana a vaal zina ma xa zuruk a kiaana la iban favanganang. ");
INSERT INTO nal_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ka rauxin aza ravin ininaan la bina angkanaan, naan a ravin ka gigiu amun matmalabuk taksaat. Naan ka langar adu Iesu xa vavangan la vaal zin a Faarasi angkanaan. Ma xa zuruk a nan pin mumut di giu wana waraxa ma xa bas pana a daanim milalas mikuf, ");
INSERT INTO nal_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ma xai ru rataangis lamuraana Iesu lapaara uru xaakna, ma xa ramaraat ma xa vamidaus uru xaaka Iesu waanaburut pana lumara zina. Ma naan ka suxa vamagala wana a vurna, ma xa ngus uru xaaka Iesu waanaburut ma xa vukin a daanim milalas mikuf pana. ");
INSERT INTO nal_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Araan a Faarasi angkanaan ka raamin, naan ka dador lamaskana nanga naako, “Tamon a rapti angkanaan naan a profet faaratunaan, ka lek texaazin aze rawat tavin kanaan ka xaaf naan ma xa lek texaazin saait adu naan a ravin ka gigiu amun matmalabuk taksaat!” ");
INSERT INTO nal_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma Iesu xa vazei a Faarasi naako, “Saaimon, gana vazei nua wana aza dorang.” Ma Saaimon naako, “Maravas, piaat fawat surugu.” ");
INSERT INTO nal_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Naanaan Iesu xa piaat malasing kari, “Uru rapti di zuruk iaa a kaakaai denaarias sin aza rapti raxumbaaxut ma mur dina xis faulin iaa. Azaxai xa zuruk a denaarias ka zangaaflu varazuai xa watmit ma axazak ka zuruk a zangaaflu xa watmit. ");
INSERT INTO nal_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nandiaa varaxai xawit nat faraxas dina xis faulin iaa a kaakaai zin a rapti angkanaan, malasing ma naan ka naxaam pizin usfa kaakaai naadi ra zuruk iaa zina, ma xawit naadi ra xis faulin iaa. Nis sin nandiaa xana sasaxot a rapti angkanaan?” ");
INSERT INTO nal_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saaimon ka xis naan naako, “Ga naxaam adu, a rapti angkaina xa ra zuruk a kaakaai laba, ma a rapti raxumbaaxut ka naxaam pizin.” Ma Iesu xa piaat naako, “A dorang sunum ka tak.” ");
INSERT INTO nal_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iesu xa rutaawuk fatokang a ravin ma xa vazei Saaimon naako, “Gu raamin a ravin angkari. Ga albis la vaal zunum singsaxai xawit gu lis a daanim surugu xuna gana tus uru xaaku waanaburut. Singsaxai naan ka tus uru xaaku waanaburut pana a lumara zina ma naa suxa vamagala wana vurna. ");
INSERT INTO nal_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kawit gu ngus nia, singsaxai araan ga albis puat la vaal, naan kawit na ziaavus pana nguzang uru xaaku waanaburut. ");
INSERT INTO nal_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kawit gu rasin a wel la waarugu, singsaxai naan ka zaaf a daanim milalas mikuf la uru xaaku waanaburut. ");
INSERT INTO nal_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Malasing ma naari, ga vazei nua adu wana a sasaxotang laba zina wana nia, Nakmai xa naxaam pizin fanong amun matmalabuk taksaat sina. Tamon axazak ka rauxin akaana matmalabuk taksaat ma aza xazak ka naxaam pizin, naan kana rauxin a sasaxotang mumut be wana naan.” ");
INSERT INTO nal_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ma Iesu xa vazei a ravin angkanaan naako, “Ga naxaam pizin fanong amun matmalabuk taksaat sunum.” ");
INSERT INTO nal_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Azanon ubina di ra iziar inaan, di dador lawalaua naandi malasing kari, “Nis a rapti angkari xat naxaam pizin amun matmalabuk taksaat?” ");
INSERT INTO nal_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iesu xa vazei a ravin malasing kari, “Ainaxam paazaaiang sunum ka zaxot faulin fanong nua. Gu waan ma a luaai xana iziar varaxai wana nua.” ");
INSERT INTO nal_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Azanon taan lamur, Iesu xa zazangas farawuk lamaskana amun bina ma amun bina laba zaait, ma xai fazei wana a Dorang Daxa iwana a bikabar zin Nakmai. Ma ubina varaviraai xa zangaaflu ma urua, di zangas faraxai wana naan. ");
INSERT INTO nal_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Azanon furavin di saxat saait sin naandi. Paamua Iesu xa ra vira a furavin angkanaan siaana amun giazang sin naandi ma xa mof pizin saait amun sapalaau ziaana naandi. Naandi xari, Maaria di vakilaan naan a ravin in Maakdaalaa ina waamua Iesu xa ra mof pizin amun sapalaau xa wizik urua wana naan, ");
INSERT INTO nal_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joaanaa, taak sin Kuzaa, aza waamua xat katkatong a vaal zin Erot, ma Susaana ma azanon furavin ka varas nanga zaait. Pana kaakaai zin naandi vaatak di rat fawaal Iesu varaxai wana ubina varaviraai zina wana amun saan naadi izi gogof pana. ");
INSERT INTO nal_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Adi xulutung ka wat sin Iesu, naandi di wat lamun bina laba xa varas. Araan di wat fatu, Iesu xa dador lalaamangaai zin naandi naako, ");
INSERT INTO nal_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Aza rapti xat nauma xa waan la uma ma xa vazu a xalamona wit. Azanon kalamona wit ka zu la lan ma aubina di was paramin ma amun maani di lif puat ma di tok fanong mase. ");
INSERT INTO nal_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Azanon kalamona wit ka zu wana a non pira xa rauxin amun faat ka varas. Ka bok puzaa singsaxai a non pira angkanaan kawit a daanim ma a wit ka plaxas ma xa maat. ");
INSERT INTO nal_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Azanon kalamona wit ka zu wana pira lawalau amun iaarus koxot ina xa bok faraxai wana. Singsaxai amun iaarus koxot di kos paramin. ");
INSERT INTO nal_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma azanon kalamona wit ka zu wana a pira daxa. Ma xa bok laba ma xa vuai ma xa zof mase naan, malasing azangaaflu varazuai laaxur wana ina di ra vazu.” Ma Iesu xa vanong a dorang lalaamangaai angkanaan ma xa viraai malasing kari, “Tamon naagu rauxin alngana nim, naaguna langar daxa wana dorang kanaan.” ");
INSERT INTO nal_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ubina varaviraai zin Iesu di iaari zina wana aze ra vuvuna dorang lalaamangaai angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma Iesu xa vazei naandi naako, “Nakmai xa lis fanong a mazamang sinim kuna rexaazang pana amun dorang funfun pana a bikabar zina. Singsaxai wana azanon aubina rawarak, ga rai dador lalaamangaai wana a bikabar zin Nakmai xuna: ‘Naapalaau naandi di rataamaai, dina wen taamaai vaakilan. Dit langarin a dorang, singsaxai dina wen mazaam.’ ” ");
INSERT INTO nal_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Iesu xa piaat kaarik naako, “A vuvuna dorang lalaamangaai xa malasing kari: A xala xari a dorang sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lalozang a dorang pana a xala xa zu la lan, kai ru vakilaan naandi di langarin a dorang, singsaxai Saatan ka wat ma xa zuruk pizin a dorang lamaskana naandi, xuna dina wen inaxam paazaai ma Nakmai xana wen saxot faulin naandi. ");
INSERT INTO nal_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lalozang a xala xa zu la pira xa rauxin amun faat, kai ru vakilaan naandi di langarin a dorang ma di ra nanam pana zurukang, singsaxai xawit na wizik lamaskana roroiang sin naandi. Di ra inaxam paazaai be wana a notaan mumut, ma araan a lalaamangaaiang ka wat, di zu xaarik. ");
INSERT INTO nal_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Lalozang a xala xa zu lawalau amun iaarus koxot, kai ru vakilaan naandi di langarin a dorang singsaxai amun inaxam farvarazang ma amun lulugaan ma amun saan kat fabalos a malavitang ila pira angkari di bas lamaskana naandi ma di kos paramin a roroiang sin naandi. Malasing ma xawit di valos a dorang sin Nakmai ma xawit di vuain amun saan daxa wana roroiang sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lalozang a xala xa zu wana pira daxa, xai ru vakilaan naandi di langarin a dorang ma naadi rasin fatalamin lamaskana naandi, wana vaaratunaanang ma a maska daxaiang. Ma di irur dikdik ka ruaas di vuain a fnuaai.” ");
INSERT INTO nal_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ma Iesu xa dador lalaamangaai xaarik naako, “Kawit taxazak kana vailaap a laam ma naana vakuf paramin pana baakit o naana rasin lawaana iban. Singsaxai naana rasin la kin siziarang iwana, xuna aubina ina di albis la vaal, dina raamin a maravas iwana. ");
INSERT INTO nal_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Amun saan faakdul ina xa izi vunfun kana balas la maravas. Ma amun saan faakdul di xavut kol, mur Nakmai xana rasin la maravas. ");
INSERT INTO nal_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Malasing ma naaguna inaxam daxa wana amun dorang naagu ra langarin. Naandi di rauxin a rexaazang pana dorang sin Nakmai, Nakmai xana lis a rexaazang laba xaarik sin naandi. Ma naandi xawit di rauxin a rexaazang pana dorang sin Nakmai, Nakmai xana zuruk pizin saait anan texaazang di naxaam adu naadi rauxin.” ");
INSERT INTO nal_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naanaa zin Iesu ma amun daasna di wat kuna raaminang naan, singsaxai xawit nat faraxas dina wat lapaarana wanaze aubina di bas. ");
INSERT INTO nal_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Axazak ka vazei Iesu naako, “Naanaa zunum ma amun daazum di irur lamanar, di saxot dina raamin nua.” ");
INSERT INTO nal_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ma Iesu xa xis naandi malasing kari, “Naanaa zurugu ma amun daazugu xari, naandi ina dit langarin a dorang sin Nakmai ma naadit falos.” ");
INSERT INTO nal_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aza raan Iesu xa vazei ubina varaviraai zina naako, “Dia dina kas buak kulaza ritita laman.” Ma naandi di xawas pana a mon ma di waan. ");
INSERT INTO nal_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Araan di izaal nanga Iesu xa wa milaaif. Ma adi maaliu xa taaif dikdik inaan la laman ma a daanim ka sfaar a mon ma faasilik kana lus ma naandi vaakdul dina milung. ");
INSERT INTO nal_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ubina varaviraai di waan ma di wangun Iesu ma di vazei naan malasing kari, “Dipiran, Dipiran, dia dina samura xanak.” Ma Iesu xa ramaraat ma xa vadawaar a maaliu ma a rof ma di maat iaa. Ma a laman ka malaai xaarik. ");
INSERT INTO nal_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma xa iaari zin naandi naako, “Malasing faa, xawit ta inaxam paazaaiang sinim?” Singsaxai naandi di maraaut ma di banglala ma di iaari zin naandi zaksaxai malasing kari, “Aze rawat tapti xari? Naan ka vadawaar a maaliu ma a rof ma di langar iaa zina!” ");
INSERT INTO nal_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu ma ubina varaviraai zina di xozaraai laxon laza non rita Laman Gaalili, xa iziar la non laba di vakilaan Gerasaa. A non angkanaan ka iziar la rita laman ila pira Gaalili. ");
INSERT INTO nal_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu xa kasaai laxon ma aza rapti ininaan la bina angkanaan, amun sapalaau di ragul naan, ka wat fasuin naan. A maariaas ka varas a rapti angkanaan kawit nat falaak ta marapi ma xawit na rataagul lamaskana ta vaal, singsaxai xa rataagul lamun baaul a maat. ");
INSERT INTO nal_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Araan ka raamin Iesu, xa viraai laba ma xa psin fawizik naan paanaburut la pira la xaaka Iesu ma naako, “Iesu, Naata Nakmai Laaxur Mase! Aze razaan gu saxot guna giu wana nia? Ga maainung nua adu tuaa guna vamazik nia ma guna kawin nia.” ");
INSERT INTO nal_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Naan ka piaat malasing kanaan panaze Iesu xa ra vazei vanong a zapalaau angkanaan kana waan fataling a rapti. Faavaras faanong a zapalaau angkanaan ka rat sop faraksaat naan lamun taan angkanaan naan ka ra iziar lawaana vaaxatkatangang sin aubina. Naandi di pis fating uru mitna ma uru xaakna wana amun iaarus a sen. Singsaxai naan kai kip buaak amun iaarus a sen angkanaan ma a zapalaau xat purif naan ku lamun non bingil. ");
INSERT INTO nal_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ma Iesu xa iaari zina naako, “Nis aizinum?” Ma xa piaat naako, “Aizinugu Amala,” wanaze amun sapalaau xa varas di ragul vanong naan. ");
INSERT INTO nal_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma amun sapalaau angkanaan dit maainung faavaras sin Iesu xuna tuaa xana kling naandi xu lamaskana maadif kawit ta vaanongang iwana. ");
INSERT INTO nal_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ka rauxin adi lemlem bari di vavangan la nan put faasilik. Ma amun sapalaau di maainung Iesu xuna xana kling naandi xu lamaskana amun bari. Ma naan ka rudaxain naandi. ");
INSERT INTO nal_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ma amun sapalaau di valaau tukbilak fataling a rapti angkanaan ma di ragul amun bari angkanaan. Ma amun bari vaakdul angkanaan di zazarai wizik la rita wut ma di zu wizik lamaskana a laman ma di xanak faakdul. ");
INSERT INTO nal_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aubina dit katkatong amun bari angkanaan di raamin azaan angkanaan ma di valaau ma di wa fazei wana a dorang kanaan sin aubina ila bina laba zin naandi ma aubina rawarak lamun non faasilik saait. ");
INSERT INTO nal_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma aubina di waan kuna dina wa raamin aze razaan ka ra balas. Di wat sin Iesu ma di raamin a rapti angkanaan amun sapalaau di waan fataling fanong naan ma xa iziar inaan lapaara uru xaaka Iesu. Ka ra mamaaus ma ainaxamang sina xa maravas ka, ma di maraaut. ");
INSERT INTO nal_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Naandi di ra raamin azaan angkanaan, di vazei aubina wana a rapti angkari xa balas daxa malasing faa. ");
INSERT INTO nal_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma aubina vaakdul ila non laba Gerasaa di maainung Iesu xuna xana waan ka, wanaze di maraaut marazaat. Naanaan Iesu xa xawaas a mon kuna waanang. ");
INSERT INTO nal_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma a rapti angkanaan ina amun sapalaau di waan fataling naan ka maainung falagot Iesu xuna xana saxat sina. Singsaxai Iesu xa kling pizin naan naako, ");
INSERT INTO nal_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gu uli xula vaal zunum ma gu piaat azaan angkanaan Nakmai xa ra giu vanong pana nua.” Ma a rapti angkanaan ka zangas farawuk lamaskana a bina laba angkanaan ma xa fazei wana azaan ina Iesu xa ra giu wana naan. ");
INSERT INTO nal_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Araan Iesu xa uli waan laza rita laman, adi mala di ruzuaai naan, panaze naandi vaakdul dit simbong naan. ");
INSERT INTO nal_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","La notaan angkanaan, aza waamua ila vaal a maainungang sin amun Judaa xa wat, aizina Jaairus. Naan ka psin fawizik naan paanaburut la pira la xaaka Iesu ma xa maainung naan kuna xana wat la vaal zina, ");
INSERT INTO nal_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","wanaze natifna be azaxai a maariaas sina xa malasing a zangaaflu ma urua, faasilik ka xana maat. Araan Iesu xa zazangas nanga la lan ku la vaal zin Jaairus, adi mala dit farambirit pana Iesu. ");
INSERT INTO nal_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma aza ravin ka iziar inaan, ka giazin a dari laba lamun taan faakdul lamaskana amun maariaas ka zangaaflu ma urua, ma xa vanong a kaakaai vaakdul zina wana wulwulang amun dokta, singsaxai xawit nat faraxas taxazak kana vira naan. ");
INSERT INTO nal_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Naan ka wat la tora Iesu ma xa xaaf a zuva marapi baraaf ina Iesu xa valaak. Ma fazaaus mase a dari laba zina xa vaanong. ");
INSERT INTO nal_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma Iesu xa iaari zin naandi naako, “Nis ka xaaf nia?” Ma naandi vaakdul di iaalawuk, ma Pita xa piaat naako, “Dipiran, aubina di bas ma dit farambirit pana nua.” ");
INSERT INTO nal_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Singsaxai Iesu xa piaat malasing kari, “Axazak ka xaaf nia, avuna ga xazanin a dikdikang ka vataling nia.” ");
INSERT INTO nal_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Naanaan a ravin angkanaan ka raamin adu di tangin paxot naan, ka dakdakur wat ma xa wat sibukaak la uru xaaka Iesu. Ma inaan lamarana aubina vaakdul naan ka pitfiaat kunaze naan ka xaaf Iesu ma naan ka daxa vazaaus mase malasing faa. ");
INSERT INTO nal_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma Iesu xa vazei naan naako, “Aku fnaalik, ainaxam paazaaiang sunum ka vira nua. Guna waan faraxai wana a luaai.” ");
INSERT INTO nal_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Araan naan kai dador nanga, axazak ka vinang la vaal zin Jaairus, a waamua ila vaal a maainungang ma xa wat piaat sina naako, “Nativum ka maat faanong. Tuaa xaarik gu varalil a maravas.” ");
INSERT INTO nal_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Singsaxai Iesu xa langarin ma xa vazei Jaairus naako, “Tuaa guna maraaut. Guna inaxam paazaai be ma naan kana roro.” ");
INSERT INTO nal_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iesu xa balas la vaal zin Jaairus, ma xawit na luaa taxazak kana albis lamaskana vaal varaxai wana naan, Pita ma Jon ma Jems ma maamaa ma naanaa zin a fnaalik be, naandi di albis faraxai wana naan. ");
INSERT INTO nal_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma aubina vaakdul inaan di maskalus ma di rataangis kupkup saxotang a fnaalik angkanaan. Ma Iesu xa piaat naako, “Tuaa naaguna raangis. A fnaalik kawit na maat, kai milaaif be.” ");
INSERT INTO nal_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Di vanangon naan panaze di rexaas adu a fnaalik ka maat faanong. ");
INSERT INTO nal_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Singsaxai Iesu xa taaxur la mitna ma xa viraai laba zina naako, “Aku fnaalik, tamaraat!” ");
INSERT INTO nal_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A laklagaaina xa uli ma fazaaus mase naan ka ramaraat. Ma Iesu xa vazei naandi xuna dina ralaas naan pana vanganang. ");
INSERT INTO nal_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Maamaa ma naanaa zina di banglala iaa mase, singsaxai Iesu xa dador dikdik sin nandiaa adu tuaa dina piaat iaa azaan angkanaan sin taxazak. ");
INSERT INTO nal_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Araan Iesu xa viring fatuin fanong ubina varaviraai xa zangaaflu ma urua, xa lis a dikdikang ma burburaaiang sin naandi xuna dina mof pizin amun sapalaau vaakdul ma dina vira psin atavur amun giazang. ");
INSERT INTO nal_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma naan ka kling naandi xuna dina waan ma dina fazei wana a bikabar zin Nakmai ma dina vira aubina di gias ma dina mof pizin amun sapalaau. ");
INSERT INTO nal_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma xa vazei zaait naandi malasing kari, “Tuaa naagu zuruk tazaan faraxai wana nim pana zangazang kanaan. Tuaa naagu roting ta laak kuna zangazang, ma tuaa naagu vazaak a laxa, ma ta vanganang, ma ta kaakaai ma ta marapi xuna xulxulang. ");
INSERT INTO nal_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Araan naagu balas laza bina, ma naagu albis lamaskana ta vaal, naagu iziar varaxai wana naandi xa ruaas naagu ramaraat fataling a bina angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tamon aubina xawit di ruzuaai nim, naagu waan fataling a bina angkanaan ma naagu taaf pizin a paauf la xaaka nim. Naari xa malasing a vaakilanang aaxan naandi xuna vatanginang adu naandi dina vazaak a maravanang pana a matmalabuk naadi ra giu.” ");
INSERT INTO nal_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ubina varaviraai di waan ma di zazangas lu lamun bina. Ma di fazei wana Dorang Daxa ma dit fira aubina di gias lamun non faakdul. ");
INSERT INTO nal_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Naanaan Erot a waamua zin a gaapman in Gaalili xa langar wana amun saan angkanaan ka balas. Ma xa baabaa mase wanaze azanon aubina ininaan di ipiaat malasing kari, “Jon A Rapti Iwana Baaptaaizang, ka ramaraat puli vaanong siaana maatang.” ");
INSERT INTO nal_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ma azanon aubina nanga di piaat adu Elaaija xa balas, ma azanon aubina di piaat adu aza profet i mumua pis ka ramaraat puli ma xa roro xaarik. ");
INSERT INTO nal_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Singsaxai Erot ka piaat naako, “Nia ga ra kip pizin fanong a vuruna Jon. Ma nis a rapti angkanaan ina gat langarin adu xa gigiu amun saan angkanaan?” Ma naan ka zazaleng ta lan kuna raaminang Iesu. ");
INSERT INTO nal_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Amun aaposal di uli wat ma di vazei Iesu wana aze naadi ra giu. Ma naan ka zaxot luk naandi, ma naandi zingbe di waan laza bina di vakilaan Betsaaida. ");
INSERT INTO nal_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Singsaxai nanga aubina di langar wana azaan angkanaan ma di las lamuraana. Naan ka ruzuaai naandi ma xa dador zin naandi wana a bikabar zin Nakmai ma xa vira aubina di gias. ");
INSERT INTO nal_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Languzaraaf mase a zangaaflu ma urua ubina varaviraai zina di wat sina ma di vazei naan malasing kari, “Gu kling pizin aubina xuna dina waan lamun bina vaasilik ma lamun non farawuk saait ma dina zaleng a vanganang ma akin milaaivang aaxan naandi, wanaze a non angkari xa bingil mase.” ");
INSERT INTO nal_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Singsaxai Iesu xa xis naandi naako, “Naagu ralaas naandi wana vanganang kuna naadina iaan.” Ma di xis naan malasing kari, “Maadi rauxin be a raraba xa watmit ma a ian urua. Malasing faa, gu saxot maadina waan ma maadina wulwul vanganang ku naandi, adi mala angkari?” ");
INSERT INTO nal_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ubina di iziar inaan, naandi di malasing a taausan ka watmit. Iesu xa vazei ubina varaviraai zina naako, “Naagu vaziaar naandi wana amun lemlem, aubina malasing ka zangaaflu vaawatmit pana a lemlem saksaxai.” ");
INSERT INTO nal_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ubina varaviraai di giu malasing kanaan ma aubina vaakdul di ziar wizik paanaburut. ");
INSERT INTO nal_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Naanaan Iesu xa zuruk amun raraba angkanaan ka watmit ma uru ian ma xa raamaai uzaa laaxur ma xa wisfaadaxa zin Nakmai wana ma naa biaak. Naa lis sin ubina varaviraai zina xuna dina vatawaraxin lawalau aubina. ");
INSERT INTO nal_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Naandi vaakdul di vangan ma di maazur mase. Ma ubina varaviraai di sfaar vambos amun laxa xa zangaaflu ma urua wana amun kibaala vanganang naadi maazur vataling. ");
INSERT INTO nal_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Aza raan Iesu xa iziar naansing ma xat maainung, ma ubina varaviraai zina di wat sina ma xa iaari zin naandi naako, “Amala aubina di ipiaat adu nia nis?” ");
INSERT INTO nal_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma naandi di xis naan malasing kari, “Azanon aubina di piaat adu nua Jon A Rapti Iwana Baaptaaizang, ma azanon aubina nanga di piaat adu nua Elaaija, ma azanon aubina nanga di piaat adu nua aza profet i mumua pis, ka ramaraat puli ma xa roro xaarik.” ");
INSERT INTO nal_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma Iesu xa iaari xaarik sin naandi naako, “Malasing faa wana nim, naagu piaat adu nia nis?” Pita xa xis naan naako, “Nua a Mesaaia zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iesu xa dador vaalagat sin naandi adu tuaa dina vazei taxazak adu naan a Mesaaia. ");
INSERT INTO nal_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma Iesu xa vazei naandi naako, “Naata Rapti xana vazaak adi maazikang laba, ma amun paamua zin amun Judaa ma amun pris laba ma amun maravas iwana amun Lus sin Moses dina bain naan. Dina zop famaat naan ma xana ramaraat puli wana varulang a raan.” ");
INSERT INTO nal_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma mur xa vazei aubina vaakdul naako, “Tamon axazak ka saxot kana los nia, naan kana naxaam pizin naan nanga, ma lamun taan faakdul xana vazaak a robuxul zina ma xana los nia. ");
INSERT INTO nal_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tamon axazak ka saxot kana roting falagot a roroiang sina, naana vamilung. Singsaxai axazak ka lis pizin a roroiang sina xuna giuang a vaamuzazang surugu, naan kana roting falagot. ");
INSERT INTO nal_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Malasing faa, xana daxa tamon axazak ka rauxin amun saan faakdul la pira angkari ma xana vamilung a roroiang faaratunaan sina varaxai wana Nakmai? Kawit. ");
INSERT INTO nal_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tamon axazak ka maangilin nia varaxai wana dorang surugu, Naata Rapti xana maangilin naan la raan angkanaan naan kana wat lamaskana adi wilaakna ma adi wilaaka Nakmai ma adi wilaak amun aangelo xoxok sina. ");
INSERT INTO nal_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ga vazei varatunaan nim, azanon sinim di irur xari, dina wen maat nanga xa ruaas la raan angkanaan dina raamin a bikabar zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ka malasing amun taan ka wizik tul lamuraana Iesu xa piaat fanong a dorang kanaan, naan ka zaxot luk Pita ma Jon ma Jems faraxai wana naan ma di uzaa ikula la waatawut kuna xana wa maainung. ");
INSERT INTO nal_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma araan kat maainung, a rataamaaiang ila marana xa xulxulaai, ma a mamaauzang la wina xa wilwilak malasing a wilak. ");
INSERT INTO nal_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma a rapti urua, Moses ma Elaaija, di balas puat iaa lamaskana adi marmari daxaiang ma di dador iaa varaxai wana Iesu. ");
INSERT INTO nal_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Naandi di dador wana dorang sin Nakmai wana waanang sin Iesu, naari naana samura waambazof ikula Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ma uru waliaana di milaaif maat taal mase ma araan di ravaangun, di raamin taal adi wilwilaaka Iesu, ma uru rapti di irur iaa varaxai wana naan. ");
INSERT INTO nal_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Araan uru rapti adu dina vataling iaa Iesu, Pita xa piaat sin Iesu naako, “Maimaai, xa daxa mase wana maadi iziar raal iriat. Maadina varur raal ta vaal maling urul, azaxai aaxanum, ma azaxai aaxan Moses ma azaxai aaxan Elaaija.” Naan ka wetexaazin aze razaan kanaan naa ipiaat. ");
INSERT INTO nal_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita xai dador nanga ma a vang bara xa balas puat ma xa pung paramin kol nandiaal ubina varaviraai. Ma nandiaal di maraaut taal mase. ");
INSERT INTO nal_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma a linga axazak ka dador lamaskana a vang bara angkanaan naako, “Naan kari Naarugu. Ga ra kalin naan kuna giuang a vaamuzazang surugu. Naagu langar zina.” ");
INSERT INTO nal_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Araan a linga xazak angkanaan ka dador vaanong, ubina varaviraai zin Iesu di raamin taal adu Iesu naan singbe xa. Nandiaal di ziburung taal wana azaan angkanaan ma xawit di vazei raal taxazak la notaan angkanaan pana aze razaan naadi ra raamin taal. ");
INSERT INTO nal_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A raan lamuraana, Iesu ma ubina varaviraai angkanaan urul zina di kabal wat la waatawut ma adi mala aubina di vasuin naan. ");
INSERT INTO nal_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aza rapti xa xupkup laba labirua wana aubina ma xa piaat malasing kari, “Maravas, ga maainung nua guna raamin naarugu, wanaze naan a nalik be azaxai zurugu! ");
INSERT INTO nal_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A zapalaau xai zop naan, ma fazaaus mase xat kupkup. Ma xai psin fawizik naan paanaburut la pira. A nalik kat dakdakur ma a busbuzak kat balas la balana. Ma a zapalaau angkari xawit nat luaa naan ma xai kawin naan. ");
INSERT INTO nal_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ga maainung ubina varaviraai zunum kuna dina mof pizin a zapalaau singsaxai xawit dit faraxas.” ");
INSERT INTO nal_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu xa xis naan naako, “Nim aubina i taning, kawit naagu inaxam paazaai ma naagu gigiu amun taksaarang. Usfa raan nanga, nia gana iziar varaxai wana nim, ma gana vamalmalin pizin nim? Saxot fawat naarum iriat.” ");
INSERT INTO nal_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Araan a nalik ka zazangas puat sin Iesu, a zapalaau xa psin fawizik naan paanaburut la pira ma xa xaraat alvana. Iesu xa vadawaar a zapalaau ma a zapalaau xa waan fataling a nalik ma a nalik ka daxa xa, ma Iesu xa lis faulin naan sin damana. ");
INSERT INTO nal_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma aubina vaakdul di banglala mase wana adi dikdikang sin Nakmai. Araan aubina vaakdul di balaxof nanga wana amun saan faakdul Iesu xa ra giu, naan ka vazei aubina varaviraai zina naako, ");
INSERT INTO nal_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Naagu langar daxa wana a dorang kari gana vazei nim pana. Axazak kana ngutlis Naata Rapti la mita ubina raksaat.” ");
INSERT INTO nal_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Singsaxai ubina varaviraai xawit di rexaazin aknaaza dorang sina. Ka izi vunfun siaana naandi malasing ma xawit naadi mazaam ma di maraaut pana iaariang sina wana. ");
INSERT INTO nal_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A varamangatang ka balas lawalaua ubina varaviraai zin Iesu wana nis mase zin naandi xa laaup. ");
INSERT INTO nal_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu xa rexaas pana aze ra inaxamang sin naandi, malasing ma xa zaxot luk aza nan nalik mumut ma xa varur naan lapaarana, ");
INSERT INTO nal_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma mur xa piaat sin naandi naako, “Nis ka ruzuaai a nan nalik angkari lamaskana aizinugu, naan ka ruzuaai nia. Ma nis ka ruzuaai nia, naan ka ruzuaai Nakmai ina xa ra kling fawat nia. Avuna nis kawit ta iza lawalaua nim faakdul, naan ka laaup mase lawalaua nim.” ");
INSERT INTO nal_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma Jon ka piaat naako, “Maimaai, maadi raamin aza rapti xa mof pizin amun sapalaau wana aizinum, ma maadi lalaamangaai xuna wisbuaakang naan, panaze naan kawit axazak simaam.” ");
INSERT INTO nal_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma Iesu xa piaat naako, “Tuaa naagu wisbuaak naan, panaze nis kawit a purua zinim, naan sinim.” ");
INSERT INTO nal_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A raan ka wat faasilik ka xuna Nakmai xana zaxot fauzaa Iesu xunikula la lia, malasing ma Iesu xa inaxam dikdik ma xa ramaraat kun Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naan ka zazangas nanga la lan ma xa tabung kling paamuain amun wangpaang kuna dador vaamaravazang. Naandi di albis laza bina zin amun Samaaria xuna dina nimnimanin amun saan babongang naan. ");
INSERT INTO nal_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Singsaxai aubina ininaan kawit di rudaxain naan kana albis la bina zin naandi, avuna naandi di rexaas adu naan ka zazangas kun Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Araan uru rapti varaviraai zina, Jems ma Jon di langarin iaa, di iaari iaa malasing kari, “Piran, gu saxot maadina viring fawat iaa a xaiaf inikula la lia xuna vanong pizinang naandi?” ");
INSERT INTO nal_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Singsaxai Iesu xa rutaawuk ma xa vadawaar nandiaa. ");
INSERT INTO nal_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Naanaan naandi di zangas ku laza bina rawarak. ");
INSERT INTO nal_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Araan di zazangas la lan, aza rapti xa piaat sin Iesu naako, “Gana los nua xu lamun non faakdul gu waan pana.” ");
INSERT INTO nal_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma Iesu xa vazei naan naako, “Amun piu wungpung di rauxin amun luk sin naandi xuna milaaivang, ma amun maani di rauxin amun nu zin naandi. Singsaxai Naata Rapti xawit na rauxin ta non kuna tateiang ma xana iaavus.” ");
INSERT INTO nal_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma Iesu xa piaat kaarik sin aza rapti naako, “Laawus, los nia.” Singsaxai a rapti angkanaan ka vazei naan naako, “Piran, paamua xalaak, gu luaa nia gana wa xavin maamaa zurugu.” ");
INSERT INTO nal_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Singsaxai Iesu xa xis naan malasing kari, “Luaa aubina di maat dina xavin aubina vaatak sin naandi ina di maat. Singsaxai nua gu waan lamun bina, ma gu fazei wana a bikabar zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma aza rapti xaarik ka vazei naan naako, “Piran, gana los nua, singsaxai paamua xalaak, gu luaa nia gana uli ma gana vazei amun fatina zurugu adu gana waan.” ");
INSERT INTO nal_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma Iesu xa xis naan naako, “Axazak ka saxot kana vaamuzas ku nia singsaxai xa rataamaai uli, naan kawit nat faraxas kana giu a vaamuzazang ila bikabar zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lamuraana azaan angkanaan, a Piran ka kalin paanin ubina di zangaaflu vaawizik urua ma urua, ma xa kling naandi, urua urua xuna dina waamuain naan ma dina fazei wana Dorang Daxa lamun bina laba vaakdul ma lamun non ina naan kana waan pana. ");
INSERT INTO nal_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naan ka piaat sin naandi malasing kari, “A vanganang kuna laavang ka varas marazaat, singsaxai aubina vaamuzazang kawit faras. Malasing ma naaguna maainung a Piraana laflaavang kuna naan kana kling paanin aubina vaamuzazang ku lamaskana uma laflaavang sina. ");
INSERT INTO nal_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Naagu waan! Ga kling nim malasing amun naata sipsip lawalau amun piu wungpung. ");
INSERT INTO nal_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tuaa naagu zuruk ta lun baaxut o ta laxa marapi xuna xulxulang o ta su. Ma tuaa naagu rur la lan ma naagu dador zin taxazak naagu vasuin. ");
INSERT INTO nal_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Araan naagu albis lamaskana ta vaal, a dorang naaguna tabung piaat ka malasing kari, ‘A luaai xa iziar lamaskana a vaal angkari.’ ");
INSERT INTO nal_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tamon axazak a maskana xat luaai xa iziar la vaal angkanaan, a luaai zinim kana iziar wana naan. Singsaxai tamon kawit, a luaai xana uli wat sinim. ");
INSERT INTO nal_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Naagu iziar be lamaskana a vaal angkanaan azaxai. Ma naagu iaan ma naagu imin aze rawat saan naadi ralaas nim pana, wanaze axazak kat faamuzas, naan kat faraxas kana zuruk a wulwulang sina. Tuaa naagu iziar varawuk lamun faal. ");
INSERT INTO nal_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Araan naagu albis lamaskana ta bina ma di nanam pana ruzuaaiang nim, naagu iaan a vanganang naadi nimnimanin tasin aaxa nim. ");
INSERT INTO nal_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Naagu vira aubina di gias la bina angkanaan ma naagu vazei naandi malasing kari, ‘A bikabar zin Nakmai xa wat faanong lapaara nim.’ ");
INSERT INTO nal_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Singsaxai tamon naagu albis lamaskana a bina ma xawit di nanam pana ruzuaaiang nim, naagu zangas farawuk lamun lan ma naagu vazei naandi malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘A paauf ila bina angkari zinim, ina xa daxat la xaaka maam, maadi taaf pizin faulin pana nim, kuna vatanginang amun matmalabuk taksaat sinim. Singsaxai naaguna rexaas adu a bikabar zin Nakmai xa wat faasilik faanong!’ ");
INSERT INTO nal_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ga vazei nim adu laraan aikilizang, Nakmai xana lis adi maravanang sin aubina raksaat in Sodom, singsaxai wana aubina ila bina angkanaan naagu waan pana, a maravanang kana laba marazaat mase aaxan naandi.” ");
INSERT INTO nal_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ma Iesu xa piaat kaarik naako, “Kana raksaat mase wana nim aubina ila bina laba Korazin! Ma xana raksaat mase wana nim aubina ila bina laba Betsaaida! Tamon amun faamuzazang ka banglala ina ga ra giu naandi inaan sinim, ga lek giu naandi lamun bina laba Taair ma Saaidon, aubina ilamun bina angkanaan di lek inaxam taawuk faanong mumua nanga, ma di lek iziar wana amun mamaauzang iwana maskaluzang ma a paauf la wina naandi, xuna vatanginang adu di inaxam taawuk faanong siaana amun matmalabuk taksaat sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","La raan aikilizang, Nakmai xana lis a maravanang sin aubina ila ru bina laba Taair ma Saaidon, singsaxai adi maravanang laba marazaat mase naana rasin pana nim. ");
INSERT INTO nal_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma nim aubina in Kaapernaaum! Malasing faa, Nakmai xana valaup nim kunikula laaxur? Kawit. Nakmai xana psin fawizik nim kunipaa waanaburut la bina zin amun maat.” ");
INSERT INTO nal_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ma Iesu xa piaat sin ubina varaviraai zina naako, “Nis ka langar zinim, ka langar zurugu. Ma nis ka bain nim, ka bain nia. Singsaxai nis ka bain nia, xa bain Nakmai ina xa kling fawat nia.” ");
INSERT INTO nal_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ubina xa zangaaflu vaawizik urua ma urua di uli varaxai wana adi nanamang, ma di piaat malasing kari, “Piran, amun sapalaau zaait di langar zimaam araan maadi vadawaar naandi wana aizinum!” ");
INSERT INTO nal_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma Iesu xa xis naandi naako, “Ga raamin Saatan ka zu wat faabuza mase waanaburut ikula la lia malasing a wilak. ");
INSERT INTO nal_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ga lis fanong a burburaaiang sinim kuna zangazang laaxur wana amun sizi, ma amun guzumaat ma naaguna waramin saait a dikdikang faakdul zin Saatan a purua zinim, ma xawit tazaan kana kawin nim. ");
INSERT INTO nal_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Singsaxai tuaa naagu nanam adu amun sapalaau di langar zinim, singsaxai naagu nanam panaze Nakmai xa varaar vating fanong aizina nim ikula la lia.” ");
INSERT INTO nal_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","La notaan angkanaan Iesu xa bas pana nanamang ka wat sin a Laklagaai a Raabu ma xa piaat naako, “Maamaa, a Piraana lia ma a pira angkari! Ga wisfaru nua wanaze gu viraai vanong aubina xawit ta izina naandi wana amun saan angkanaan, ma wanaze gu vun amun saan angkanaan siaana ubina mazam ma ubina di rauxin a rexaazang laba. Aiang Maamaa, gu giu azaan angkanaan lalozang ainaxamang ma a nanamang sunum. ");
INSERT INTO nal_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Maamaa xa lis fanong amun saan faakdul zurugu. Kawit taxazak na rexaazin nis Naatna, singsaxai Maamaa zingbe naan ka rexaas. Ma xawit taxazak na rexaazin nis Maamaa, singsaxai Naatna zingbe naan ka rexaas ma naandi be zaait ina Naatna xa ra viaat naan sin naandi.” ");
INSERT INTO nal_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iesu xa plaaspuk naan ka waan sin ubina varaviraai zina ma xa vazei naandi zingbe naako, “Nakmai xa ra lis a daxaiang sin aubina di raamin aze ramun saan nim naagu raamin. ");
INSERT INTO nal_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ga vazei nim adu amun profet ka varas ma amun kalxaal xa varas i mumua di saxot dina raamin aze razaan nim naagu raamin, singsaxai xawit naadi ra raamin. Ma di saxot dina langarin a dorang nim naagu langarin, singsaxai xawit naadi ra langarin.” ");
INSERT INTO nal_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aza raan aza maravas iwana amun Lus sin Moses ka ramaraat ma xa saxot kana lalaamangaain Iesu. Ma naan ka iaari zin Iesu naako, “Maravas, aze razaan gana giu xuna gana zuruk a roro tapal?” ");
INSERT INTO nal_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma Iesu xa xis naan naako, “Aze razaan amun Lus sin Moses ka dador wana? Ma gu naxaam adu aze ra vuvuna dorang iwana?” ");
INSERT INTO nal_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A rapti angkanaan ka xis naan malasing kari, “Ka piaat naako, ‘Naaguna sasaxot a Piran Nakmai zinim pana a maska vaakdul zinim ma wana a laklagai vaakdul zinim ma wana a dikdikang faakdul zinim ma wana ainaxamang faakdul zinim.’ Ma ‘Naaguna sasaxot amun paliaana nim malasing be naagu sasaxot nim nanga.’ ” ");
INSERT INTO nal_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma Iesu xa xis naan malasing kari, “A dorang gu xis nia wana xa tak. Gu giu malasing kanaan ma guna rauxin a roro tapal.” ");
INSERT INTO nal_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Singsaxai a maravas iwana amun Lus sin Moses ka saxot kana waafatok naan lamarana Iesu ma xa iaari zin Iesu naako, “Nis a waliaanugu?” ");
INSERT INTO nal_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu xa xis naan pana a dorang lalaamangaai naako, “Aza rapti xa ramaraat Jerusalem ma naako xana kabal wizik Jeriko, ma araan ka zazangas pizik la lan, azanon finaau di zaraak fating naan. Di taar psin amun marapi zina, ma di wit faraksaat naan ma di waan fataling naan ka maatsal. ");
INSERT INTO nal_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","La notaan angkanaan aza pris ka zazangas pizik saait la lan angbani. Ma araan ka raamin a rapti angkanaan, ka zangas fasaal naan laza rit a lan. ");
INSERT INTO nal_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aza Livaai zaait ka zazangas pizik kaarik inaan, ma araan ka raamin a rapti angkanaan, ka zangas fasaal xaarik naan la rita lan. ");
INSERT INTO nal_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Singsaxai aza rapti in Samaaria, xa los a lan angbani ma xa wat tangin naan. Ma araan ka raamin a rapti angkanaan, a maskana xa bas pana varamaaluvang. ");
INSERT INTO nal_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naan ka wizik sina ma xa vukin a wel iwana a olif faraxai wana a waain pana amun burus sina ma naa xaba xol. Ka vazaak luk a rapti angkanaan ma xa rasin naan laaxur wana a dongki zina ma xa zaxot naan kula vaal imilaaivang sin amun topuran ma xa xatkatong naan. ");
INSERT INTO nal_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A raan lamuraana, waamua wana naan kana waan, ka zuruk azanon kaakaai, a siliwa urua ma naa lis sin a rapti xat katkatong a vaal a imilaaivang ma xa vazei naan naako, ‘Gu xatkatong a rapti angkari, ma aze razaan kaarik nanga gu zuruk kuna vawaalang naan, gana xis faulin araan gana uli wat.’ ” ");
INSERT INTO nal_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ma Iesu xa piaat sin a maravas iwana amun Lus sin Moses naako, “Pana ainaxamang sunum, nis sin nandiaal gu naxaam adu naan a waliaana a rapti angkanaan ina amun finaau di zop faraksaat?” ");
INSERT INTO nal_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A maravas iwana amun Lus ka xis naan malasing kari, “A rapti ina xa vatangin a varamaaluvang pana naan.” Ma Iesu xa vazei naan naako, “Paan ma gu giu malasing bani.” ");
INSERT INTO nal_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu ma ubina varaviraai zina di zazangas la lan ma di wa balas laza bina zin aza ravin aizina xanaan Maata. Naan ka ruzuaai Iesu ma xa zaxot naan kula vaal zina. ");
INSERT INTO nal_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maata xa rauxin duaana, aizina xanaan Maaria. Naan ka iziar lapaara uru xaaka Piran ma xat langar wana varaviraaiang sina. ");
INSERT INTO nal_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Singsaxai Maata xa raalil marazaat pana amun saan faakdul ina naa naxaam naana nimnimanin. Malasing ma naan ka wat sin Iesu ma xa piaat naako, “Piran, duaagu xa luaa psin nia ma nia zing gat nimnimanin amun saan. Iaak kawit gu naxaam nia, aan? Fazei naan kana vawaal nia!” ");
INSERT INTO nal_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma a Piran ka xis naan naako, “Maata, Maata, gu inaxam farvaras ma gu maskalus pana amun saan ka varas. ");
INSERT INTO nal_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Singsaxai azaan be azaxai guna naxaam. Nua gu ra kalin a matmalabuk daxa singsaxai Maaria xa ra kalin a matmalabuk ka daxa marazaat pana zunum. Ma xawit taxazak kat faraxas kana zuruk pizin siaana.” ");
INSERT INTO nal_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aza raan Iesu xa wa maainung laza non. Araan ka vaanong pana maainungang, azaxai zin ubina varaviraai zina xa iaari zina naako, “Piran, guna viraai maam pana maainungang malasing Jon ka ra viraai ubina varaviraai zina.” ");
INSERT INTO nal_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma Iesu xa vazei naandi malasing kari, “Araan naagu maainung, naagu maainung malasing kari: ‘Damana maam, aubina dina vaxoxok aizinum, a bikabar zunum kana balas, ");
INSERT INTO nal_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gu ralaas maam pana vanganang ku lamun taan saksaxai. ");
INSERT INTO nal_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Naxaam pizin amun matmalabuk taksaat simaam, avuna maam saait maadi naxaam pizin amun matmalabuk taksaat sin naandi vaakdul di ra giu wana maam. Ma xana daxa tamon guna wen luaa maam ku lamaskana vaxabebeuang.’ ” ");
INSERT INTO nal_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma Iesu xa vazei naandi malasing kari, “Tamon azaxai zinim kana waan sin a paasaxo zina la xuxuna suk, ma xa maainung naan malasing kari, ‘Paasaxo, guna lis a raraba urul zurugu ma lamur gana xis faulin. ");
INSERT INTO nal_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Aza paasaxo zurugu xa balas surugu wana zangazang sina, ma xawit ga rauxin tazaan kuna ralaazang naan pana.’ ");
INSERT INTO nal_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma a paasaxo inaan lamaskana vaal xa piaat naako, ‘Tuaa gu vamosmos nia. A mara xa rabanat faanong, ma nia ma a funalik surugu maadi itate vaanong. Kawit nat faraxas gana ramaraat ma gana lis sunum.’ ” ");
INSERT INTO nal_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma Iesu xa piaat kaarik naako, “Ga vazei nim, kawit adu nandiaa uru paasaxo ma naan kana tukbilak ma xana lis sina, singsaxai naan kana tukbilak ma xana lis amun saan faakdul ina naa saxot, panaze naan ka dikdik pana iaariang faavaras ma xawit na maraaut. ");
INSERT INTO nal_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Malasing ma ga vazei nim, naaguna maainung Nakmai. Pana lan angbani naan kana lis sinim. Naaguna saaleng. Pana lan angbani naaguna tangin. Naaguna pidik. Pana lan angbani a mara xana ralakas pana nim. ");
INSERT INTO nal_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Avuna naandi vaakdul ina dit maainung, dina ralaas naandi, ma naandi di saaleng, dina tangin, ma naandi di pidik pana mara, dina kaas a mara wana naandi. ");
INSERT INTO nal_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nis sinim amun damana funalik, tamon naatna xa maainung naan pana a ian, kana lis a zizi raksaat sina? ");
INSERT INTO nal_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma tamon naatna xana maainung pana a xatur, naan kana lis a guzumaat sina? ");
INSERT INTO nal_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tamon nim aubina raksaat naagu rexaas pana lizang amun talazang daxa zin a funalik sinim, faaratunaan mase Damana nim ina xa iziar ikula la lia, xana lis a Laklagaai a Raabu zin nis naandi dit maainung naan.” ");
INSERT INTO nal_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu xa mof pizin a zapalaau ina xa ra ragul aza rapti ma xa nguspo. Araan a zapalaau angkanaan ka waan fataling naan, a rapti xa dador xa. Axulutung di banglala mase. ");
INSERT INTO nal_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Singsaxai azanon sin naandi di piaat be malasing kari, “Naan kai mof pizin amun sapalaau wana a dikdikang sin Belzebul, a piraana amun sapalaau.” ");
INSERT INTO nal_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma azanon aubina rawarak di saxot dina lalaamangaain naan, malasing ma di iaari zina xuna xana giu ta vaamuzazang ka banglala xuna vatanginang adu Nakmai xa ra kling naan. ");
INSERT INTO nal_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iesu xa rexaazin fanong ainaxamang sin naandi ma xa vazei naandi naako, “Tamon aubina ila kaantri azaxai, naandi nanga di varavarop lawalaua naandi nanga, a kaantri angkanaan kana raksaat mase. Ma tamon ta vatama di varop lawalaua naandi nanga, naandi dina wen iziar varaxai xaarik. ");
INSERT INTO nal_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tamon Saatan ka varop kaarik be varaxai wana amun iaana kilaaiang sina, a bikabar zina xana rur dikdik malasing faa? Ga piaat malasing kanaan panaze naagu piaat pana nia adu ga ra mof pizin be amun sapalaau wana a dikdikang sin Belzebul. ");
INSERT INTO nal_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tamon ga mof pizin amun sapalaau wana a dikdikang sin Belzebul, aubina zinim di mof pizin amun sapalaau wana a dikdikang sinis? Malasing ma naandi dina klis nim. ");
INSERT INTO nal_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Singsaxai tamon ga mof pizin amun sapalaau wana dikdikang ila mita Nakmai, naanaan naagu rexaas adu a bikabar zina xa balas faanong sinim. ");
INSERT INTO nal_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tamon ta rapti maradikdik ka valaak amun saan sina iwana varopang, ma xa rataamaai xaaul wana vaal zina, amun lulugaan sina xana izi daxa. ");
INSERT INTO nal_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Singsaxai tamon taxazak nanga xa maradikdik pana naan, ka wat ma xa varop faraxai wana naan ma xa waramin naan, kana urif pizin amun saan iwana varopang siaana ina naa inaxam paazaai wana ma xana vatawaraxin amun saan sin a rapti angkanaan lawalau aubina rawarak. ");
INSERT INTO nal_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Naan ina xawit na irur varaxai wana nia, naan kai purua wana nia. Ma naan ina xawit na vawaal nia xuna zaxot fatuiang aubina, naan kai vut pizin farauxin naandi.” ");
INSERT INTO nal_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Iesu xa dador lalaamangaai xaarik naako, “Araan a zapalaau xa tukbilak siaana axazak, naan kai waan lamun non ina xawit ta daanim kuna xana ziaavus, singsaxai xawit na tangin ta non kuna ziaavuzang inaan. Ma xa piaat malasing kari, ‘Gana uli waan kula vaal ina ga tukbilak pana.’ ");
INSERT INTO nal_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma araan ka balas la vaal, xa tangin adu di sor vatalamin fanong ma di waafatok. ");
INSERT INTO nal_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Naanaan naan ka waan ma xa zaxot luk kaarik amun sapalaau xa wizik urua, naandi di raksaat mase wana naan, ma di laanga albis la vaal angkanaan ma di iziar lamaskana. Malasing ma a roroiang sin a rapti angkanaan ka raksaat mase wana a roroiang kaina zina iwaamua.” ");
INSERT INTO nal_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu xai dador nanga ma aza ravin lamaskana axulutung ka viraai laba malasing kari, “A ravin ina xa luk nua ma xa vazus nua, Nakmai xa lis a daxaiang sina.” ");
INSERT INTO nal_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Singsaxai Iesu xa xis naan naako, “Naandi ina di langarin a dorang sin Nakmai ma naadi valos, Nakmai xa lis mase a daxaiang sin naandi.” ");
INSERT INTO nal_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Araan amun mala aubina di uwat nanga zin Iesu, naan ka piaat sin naandi naako, “A watkul angkari taning, a watkul raksaat. Di saxot dina raamin ta vaamuzazang ka banglala xuna vatanginang adu nia ga giu a vaamuzazang sin Nakmai, singsaxai gana wen fatangin sin naandi. Nakmai xana giu be a vaamuzazang ka banglala malasing sin a profet Jonaa malasing a vaakilanang. ");
INSERT INTO nal_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Avuna Jonaa, naan a vaakilanang Nakmai xa ra vatangin sin aubina in Niniwe, malasing saait bani Naata Rapti xana balas a vaakilanang aaxan a watkul angkari taning. ");
INSERT INTO nal_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","La raan aikilizang, a ravin kalxaal ila saaut kana rur ma xana vakor vadikdik a watkul angkari taning pana amun matmalabuk taksaat sin naandi. Avuna naan ka ra wat mase lawalaau xuna langarinang amun mazamang sin a xalxaal Solomon, singsaxai axazak ina xa laaup mase wana a xalxaal Solomon, ka iziar iriat lawalaua nim. ");
INSERT INTO nal_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","La raan aikilizang, aubina in Niniwe dina rur ma dina vakor vadikdik a watkul angkari taning. Avuna naandi di inaxam taawuk siaana amun matmalabuk taksaat sin naandi araan di ra langarin Jonaa xa fazei zin naandi, singsaxai axazak ina xa laaup mase wana Jonaa naan ka iziar iriat lawalaua nim.” ");
INSERT INTO nal_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ma Iesu xa piaat kaarik naako, “Kawit taxazak kana vailaap a laam ma naana vun o naana vakuf paramin pana a baakit. Kawit! Naana rasin nanga laaxur la kin siziarang iwana xuna naandi ina di albis la vaal dina raamin a maravas. ");
INSERT INTO nal_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Uru xalimaraam, nandiaa di malasing iaa a laam sunum. Tamon uru xalimaraam di daxa iaa, a winpinum faakdul xana bas pana maravas. Singsaxai tamon nandiaa varaxai di raksaat iaa, a winpinum faakdul zaait kana bas pana bungsuzuk. ");
INSERT INTO nal_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Malasing ma naagu naknakaai! A maravas angkanaan la winpina nim tuaa xana bungsuzuk. ");
INSERT INTO nal_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tamon a winpin faakdul zinim ka maravas, ma xawit ta non iwana xa bungsuzuk, kana maravas faakdul mase, malasing a laam ina a maravaasna xa maravas pana nim.” ");
INSERT INTO nal_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Araan Iesu xa dador vaanong, aza Faarasi xa maainung naan kuna nandiaa dina wa vangan iaa. Iesu xa albis ma xa wa iziar lapaara iban favanganang. ");
INSERT INTO nal_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Araan a Faarasi xa raamin adu Iesu xawit na tabung sukmit paamua wana vanganang, naan ka raknar mase wana azaan angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma a Piran ka piaat sina naako, “Nim amun Faarasi, naagut suksuk be a tora amun pin imiminang ma amun pin favanganang, singsaxai a maskana nim ka bas pana matmalabuk iwana vinaauang ma amun taksaarang. ");
INSERT INTO nal_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nim amun tabanat! Kawit naagu rexaas adu naan ina xa giu a tora amun saan, ka giu zaait a maskana naandi? ");
INSERT INTO nal_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Naaguna ralaas aubina di izi gogof pana amun saan ila maskana amun pin imiminang ma amun pin favanganang kuna vawaalang naandi, xuna amun saan faakdul zinim kana ninis. ");
INSERT INTO nal_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kana raksaat mase wana nim amun Faarasi. Naagu inaxam marazaat pana a nan lus mumut malasing kari, uwat iaai di vakilaan a mint, ma a rui ma aze rawat makara nanga ilamaskana uma, naagu ratalaas Nakmai wana azaxai lamaskana a zangaaflu iwana amun saan angkanaan. Singsaxai aikilizang sinim kawit na tak ma xawit naagui sasaxot Nakmai. Kana daxa tamon naagu giu aikilizang ka tak ma a matmalabuk iwana varamaaluvang sin Nakmai wana aubina, ma tuaa naagu naxambain azaxai zaxai iwana azangaaflu, xuna lizang sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kana raksaat mase wana nim amun Faarasi. Avuna naagui saxot amun kin siziarang sin ubina laba lamaskana a vaal a maainungang sin amun Judaa. Ma naagu saxot saait adu aubina dina lis a varanopang laba zinim lamun non iwana balas fatuiang. ");
INSERT INTO nal_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kana raksaat mase wana nim, panaze naagu malasing amun luka maat ina xawit ta waata iza wana, ma aubina di zangas laaxur wana ma xawit di rexaazin.” ");
INSERT INTO nal_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Naanaan azaxai zin amun maravas iwana amun Lus sin Moses ka piaat sin Iesu naako, “Maravas, araan gu piaat malasing kanaan, gu piaat faraksaat maam saait.” ");
INSERT INTO nal_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Iesu xa xis naan naako, “Kana raksaat mase zaait pana nim amun maravas iwana amun Lus sin Moses. Avuna naagui lis amun lus dikdik kuna aubina dina valos, malasing amun maravanang ina xa lagaf pana naadina vazaak. Singsaxai nim nanga naaguna wen tasin ta klusmit kuna vawaalang naandi xuna vazaakang. ");
INSERT INTO nal_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kana raksaat mase wana nim, avuna naagut farur a waata iza wana amun baaul a maat sin amun profet, singsaxai amun kulmua zinim di ra zop famaat naandi. ");
INSERT INTO nal_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pana matmalabuk angkanaan sinim naagu vatangin adu naagu rudaxa wana amun kulmua zinim pana amun faamuzazang sin naandi wana zop famaatang amun profet, ma naagu varur a waata iza wana amun baaul a maat sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Avuna wana azaan angkanaan, Nakmai wana mazamang sina xa piaat naako, ‘Gana kling amun profet ma amun aaposal xa waan sin naandi, ma dina zop famaat azanon profet ma azanon aaposal ma dina vamazik azanon.’ ");
INSERT INTO nal_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Malasing ma nim a watkul angkari taning, naaguna vazaak a maravanang saxotang a dari zin amun profet faakdul ina di ra zop famaat naandi la varumaraiang ila pira angkari xa ruaas taning. ");
INSERT INTO nal_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Di varumara araan di ra zop famaat Aabel ma xa uzaa tuaas a raan di ra zop famaat Zekaria, ina xa maat labirua wana a aalta ma a non koxok sin Nakmai. Malasing ma ga vazei nim, Nakmai xana xis faulin aikilizang laaxur wana a watkul angkari taning pana amun matmalabuk faakdul angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kana raksaat mase wana nim amun maravas iwana amun Lus sin Moses, panaze naagu baraat kol a mara iwana mazamang. Nim nanga xawit naagu albis lamaskana a non iwana zurukang a mazamang, ma naagu ruxol naandi ina di saxot dina albis lamaskana.” ");
INSERT INTO nal_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Araan Iesu xa tukbilak la vaal angkanaan, amun maravas iwana amun Lus sin Moses ma amun Faarasi di boromaazik ma di ramaraat ma di ipurua wana naan ma di iaari wukpuxaai zina wana amun saan ka varas kuna lalaamangaain naan. ");
INSERT INTO nal_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma di zimbong Iesu wana tazanon dorang naana psin kuna naadina vakor naan pana. ");
INSERT INTO nal_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Araan adi xulutung aubina, naandi di taausan taausan di balas fatu, ma di waspaas farauxin amun kaaka naandi zaksaxai, Iesu xa ramaraat ma xa tabung dador zin ubina varaviraai zina naako, “Naagu xatkatong fatalamin nim nanga ziaana amun Faarasi. Gai dador wana a matmalabuk sin naandi iwana piaatang azaan ma xawit dit falos. ");
INSERT INTO nal_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Amun saan faakdul ina aubina di xavut kol, mur Nakmai xana walaas, ma amun saan faakdul xa izi vunfun, mur Nakmai xana vabalos la maravas. ");
INSERT INTO nal_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Amun saan faakdul naagu piaat la bungsuzuk, mur dina langarin lawaanaas. Ma aze naagu ngif funfunin sin axazak la rumaaf lamaskana vaal, mur dina rur la waata vaal ma dina pitfiaat sin aubina. ");
INSERT INTO nal_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ga vazei nim faakdul amun paasaxo zurugu, tuaa naagu maraaut pana ubina ina dit sop famaat a winpin be, ma lamuraana xawit nat faraxas dina giu xaarik taza zaan sinim. ");
INSERT INTO nal_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Singsaxai gana vazei vamaravaas nim pana nis mase naaguna marauring. Naagunat marauring be Nakmai. Araan Nakmai xai zop famaat axazak, naan ka rauxin a burburaaiang kuna psinang naan ku lamaskana a bina iwana adi xaiaf kawit nai maat. Malasing ma ga vazei nim, naaguna marauring bulin Nakmai zingbe lamun taan faakdul. ");
INSERT INTO nal_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Naagu rexaas adu aubina di wulwul akaana masmaas mumut ka watmit pana a kaakaai mumut urua. Singsaxai Nakmai xawit nat naxambain tazaxai zin a kaana masmaas mumut angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ka vaaratunaan mase, Nakmai xa ra vakot fanong amun fur vaakdul la waata nim, ma xa rexaas daxa mase wana nim. Malasing ma tuaa naagu maraaut, nim naagu laaup marazaat lamarana Nakmai wana amun masmaas mumut ka varas.” ");
INSERT INTO nal_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Iesu xa piaat kaarik naako, “Ga vazei nim, tamon axazak ka vazei aubina adu naan surugu, naanaan Naata Rapti xana vazei zaait Nakmai lamarana amun aangelo zina adu axazak angkanaan sina vaatak. ");
INSERT INTO nal_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Singsaxai tamon axazak ka vazei aubina adu naan kawit surugu, nia zaait gana vazei Nakmai lamarana amun aangelo zina adu naan kawit surugu. ");
INSERT INTO nal_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma axazak ka piaat a dorang taksaat pana Naata Rapti, Nakmai xana naxaam pizin a matmalabuk taksaat angkanaan sina. Singsaxai tamon axazak ka lingpuak pana a Laklagaai a Raabu, Nakmai xana wen naxaam pizin a matmalabuk taksaat angkanaan sina. ");
INSERT INTO nal_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Araan di zaxot fawat nim kuna klizang nim lamaskana amun faal a maainungang sin amun Judaa o lamarana amun paamua o lamarana ubina di rauxin a burburaaiang, tuaa naagu inaxam farvaras pana aze razaan naaguna piaat o wana naaguna mitai dador xol nim lalozang amun faakarang pana nim. ");
INSERT INTO nal_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Avuna la notaan angkanaan a Laklagaai a Raabu xana vazei nim pana aze razaan naaguna piaat sin naandi.” ");
INSERT INTO nal_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aza rapti lamaskana adi mala xa piaat sin Iesu naako, “Maravas, fazei daazugu xuna wagaalang amun saan faakdul labirua wana nimaa ina maamaa zinimaa xa ra maat fataling.” ");
INSERT INTO nal_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma Iesu xa xis naan naako, “Nalik, nis ka rasin nia a rapti iwana ikilizang o axazak kana wagaal amun saan labirua wana numaa?” ");
INSERT INTO nal_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naanaan ka piaat sin naandi naako, “Naagu naknakaai! Naagu xatkatong fatalamin nim nanga ziaana a matmalabuk iwana lamaiang, avuna a roroiang sin axazak kawit nat faraxas kana balas daxa wana amun lulugaan sina xa varas.” ");
INSERT INTO nal_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ma xa vazei naandi wana a dorang lalaamangaai malasing kari: “A pira zin aza rapti raxumbaaxut ka vabalos amun fanganang ka varas. ");
INSERT INTO nal_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma xa inaxam naako, ‘Gana giu aze? Kawit ga rauxin ta non kuna rasinang amun fanganang angkari zurugu.’ ");
INSERT INTO nal_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naanaan ka piaat naako, ‘Gana giu azaan angkari: Gana bara psin amun faal a rataasmaaiang surugu ma gana giu amun salaba nanga, ma inaan gana rasin amun fanganang faakdul zurugu ma aze razanon saan nanga. ");
INSERT INTO nal_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma gana piaat surugu nanga malasing kari, “Ga rauxin amun saan ka varas kat faraxas pana amun maariaas ka varas. A roroiang surugu xana wen lagaf. Naari gana imimin ma gana vavangan ma gana dokdok be.” ’ ");
INSERT INTO nal_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Singsaxai Nakmai xa vazei naan naako, ‘Gu rabanat! Taning labung mase gana zuruk pizin a roroiang sunum. Ma nis ka xana zuruk amun saan faakdul angkanaan gu ra nimnimanin tasin aaxanum nanga?’ ” ");
INSERT INTO nal_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iesu xa piaat kaarik sin amala aubina naako, “Kana malasing kanaan pana axazak ina xai waaturin amun lulugaan ka varas aaxana nanga, singsaxai naan kawit nai kaas uru mitna xuna faawalang pana amun faamuzazang sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iesu xa piaat sin ubina varaviraai zina naako, “Malasing ma ga vazei nim, tuaa naagu inaxam farvaras pana a roroiang sinim, pana aze razaan naaguna iaan o aze razaan naaguna valaak kol a winpina nim pana. ");
INSERT INTO nal_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A roroiang azaan laba wana vanganang, ma a winpin azaan laba wana amun marapi. ");
INSERT INTO nal_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Naagu raamin amun kor, xawit dit faazu ma xawit dit laflaaf ma xawit di rauxin a vaal a rataasmaaiang, singsaxai Nakmai xat favangaan naandi. Ma nim, azaan laba mase wana amun maani. ");
INSERT INTO nal_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nis sinim kai inaxam farvaras pana a roroiang sina xat faraxas kana vandumduma ta aaua xaarik azaxai wana a roroiang sina? ");
INSERT INTO nal_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tamon kawit nat faraxas naaguna giu anan saan mumut angkanaan, kunaze naagu inaxam farvaras pana azanon saan? ");
INSERT INTO nal_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Naagu raamin amun purpur, xawit dit faamuzas ma xawit dit saxazit amun marapi xun naandi nanga. Singsaxai ga vazei nim, a xalxaal Solomon pana amun saan faakdul naa raxumbaaxut pana, xawit ta marapi zina xa marmari daxa malasing a marmari daxaiang iwana amun purpur angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nakmai nanga xat famamaus amun lauran angkari ina di iziar taning ma lamaf aubina dina tok pizin ma naadina psin lamaskana axaiaf. Nim aubina ainaxam paazaaiang sinim ka xalxaalif! Tamon Nakmai xa giu azaan angkanaan pana amun lauran, faaratunaan mase naan kana vamamaus saait nim. ");
INSERT INTO nal_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma tuaa naagu rasin ainaxamang sinim pana aze razaan naaguna iaan o naaguna imin, ma tuaa naagu inaxam farvaras pana. ");
INSERT INTO nal_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Avuna aubina ila pira angkari dit falau lalos amun saan angkanaan. Singsaxai Damana nim ka rexaas faanong adu naaguna rauxin amun saan angkanaan pana roroiang sinim. ");
INSERT INTO nal_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Singsaxai naaguna zaleng amun matmalabuk iwana a bikabar zin Nakmai, ma amun saan angkanaan naana lis saait sinim.” ");
INSERT INTO nal_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma Iesu xa piaat kaarik naako, “Nim a nan lemlem sipsip, tuaa naagu maraaut, Damana nim ka nanam faanong kuna naan kana lis a bikabar zina zinim. ");
INSERT INTO nal_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Naaguna vaangurin amun lulugaan sinim ma naaguna lis amun kaakaai zin aubina di izi gogof. Naaguna nimnimanin nim nanga wana amun lulugaan daxa xa iziar la lia, ina xawit na rataksaat. Amun lulugaan angkanaan kana wen faanong, ma xawit ta vinaau xana wat finau ma xawit ta iaani xana saxa wana. ");
INSERT INTO nal_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Avuna aze ranon amun lulugaan sinim ka iziar wana, naan a non angbani ainaxamang sinim kana iziar zaait pana.” ");
INSERT INTO nal_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ma Iesu xa piaat kaarik naako, “Naaguna mamaaus taasmaai xuna nimnimanang pana aze rawat faamuzazang kana wat, ma tuaa amun laam sinim kana maat. ");
INSERT INTO nal_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Naaguna malasing amun iaana kilaaiang dit simbong a mono zin naandi xana uli wana flangan iwana vaamaxuzang kuna araan ka balas ma xa pidik pana mara, fazaaus mase dina kaas a mara. ");
INSERT INTO nal_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kana daxa wana amun iaana kilaaiang kanaan, araan a mono zin naandi xa wat tangin naandi di rataamaai xaaul. Ga vazei varatunaan nim, naan nanga xana mamaaus kuna xana talas, ma xana vazei naandi dina iziar la iban favanganang ma xana ralaas naandi. ");
INSERT INTO nal_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kana daxa mase wana amun iaana kilaaiang angkanaan ina a mono zin naandi xa wat tangin naandi di izit nimniman naapalaau tamon ka balas la xuxuna suk o paanaraan gufguf mase araan auraa xa kaakaluk mara. ");
INSERT INTO nal_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Singsaxai naaguna mazaam a dorang kari: Tamon damana vaal xa lek texaas pana aze ra raan a vinaau xana wat, ka lek pen luaa a vinaau xana taar a vaal zina. ");
INSERT INTO nal_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nim saait naaguna nimniman, panaze Naata Rapti xana wat la notaan nim kawit naagu naxaam naan kana balas.” ");
INSERT INTO nal_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita xa iaari zin Iesu naako, “Piran, a dorang lalaamangaai angkanaan gu piaat, sinis, simaam o zin aubina vaakdul?” ");
INSERT INTO nal_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma a Piran ka xis naan naako, “Nis a waamua zin amun iaana kilaaiang ina xat falos a dorang sina ma xa mazam? Naan bani ina a mono zina xana kalin naan kuna xana waamuain amun iaana kilaaiang sina ma xana ralaas naandi wana vanganang sin naandi la notaan faatak iwana. ");
INSERT INTO nal_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kana daxa mase zin a iaana kilaaiang kanaan tamon a mono zina xana uli wat ma xana balas tangin naan kat gigiu malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ga vazei varatunaan nim, kana rasin naan kuna xana xatkatong amun lulugaan faakdul zina. ");
INSERT INTO nal_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Singsaxai tamon a iaana kilaaiang kanaan ka piaat sina nanga malasing kari, ‘A mono zurugu xana wen puli vazaaus,’ malasing ma xa ramaraat ma xa zop amun tapti iaana kilaaiang ma amun tavin iaana kilaaiang ma xa vangan ma xa imin a daanim dikdik ma xa bumaat. ");
INSERT INTO nal_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tamon naana giu malasing kanaan, a mono zina xana wat balas pana a raan naan kawit na naxaam kana balas pana ma wana a aaua naan kawit na maravas pana. Ma a mono xana ruk famimidi naan ma xana rasin naan la non sin aubina xawit di inaxam paazaai. ");
INSERT INTO nal_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A iaana kilaaiang kaina xa rexaazin a sasaxotang ma ainaxamang sin a mono zina, singsaxai naan kawit na nimniman kuna giuang ma xawit naa giu, dina zop faraksaat naan. ");
INSERT INTO nal_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Singsaxai a iaana kilaaiang ina xawit na rexaazin a sasaxotang ma ainaxamang sin a mono zina ma xa giu amun saan ina xat faraxas pana dina zop naan, dina wen sop misaai naan. Aubina vaakdul ina Nakmai xa ra lis amun saan ka varas sin naandi, naan ka dador dikdik adu dina giu amun matmalabuk ka varas aaxana. Ma axazak ina Nakmai xa lis amun dikdikang ma burburaaiang ka varas la mitna, Nakmai xana iaari zina xana giu amun matmalabuk kana varas marazaat nanga.” ");
INSERT INTO nal_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ma Iesu xa piaat kaarik naako, “Ga ra wat kuna rasinang a xaiaf la pira angkari, ma ga saxot mase adu axaiaf ka ililap faanong. ");
INSERT INTO nal_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Singsaxai xa rauxin aza wat baaptaaizang nanga gana wizik lamaskana iwana vazaakang adi maazikang, ma a maskaagu xa maravan pana xa ruaas kana vaanong. ");
INSERT INTO nal_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Malasing faa, naagu naxaam adu ga wat kuna lizang a luaai la pira angkari? Kawit. Ga vazei nim, ga wat kuna aubina ila pira angkari dina iziar vatawagalaai. ");
INSERT INTO nal_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Taning ma xa uzaa, aubina xa watmit lamaskana a vaal dina izi vatawagalaai ziaana naandi zaksaxai, urul dina purua wana urua, ma urua dina purua wana urul. ");
INSERT INTO nal_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Maamaa xana purua wana naatna ma naatna xana purua wana damana, ma naanaa xana purua wana natifna, ma natifna xana purua wana dina, ma naanaa xana purua wana ninana ma ninana xana purua wana naanaa.” ");
INSERT INTO nal_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu xa vazei adi mala aubina naako, “Araan naagu raamin a bara xa ramaraat la non a iaas kai si wana, fazaaus mase naagu piaat malasing kari, ‘Kana uzan,’ ma xa uzan. ");
INSERT INTO nal_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma tamon a maaliu ila saaut ka taaif, naagu piaat malasing kari, ‘A bina xana lagaf,’ ma a bina xa lagaf. ");
INSERT INTO nal_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nim aubina xawit naagut falos a dorang sinim! Naagu rexaas pana raamin fakilaanang amun saan ila pira angkari ma ila bara. Malasing faa xawit nat faraxas naaguna raamin fakilaan amun taan angkari taning?” ");
INSERT INTO nal_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Iesu xa piaat kaarik naako, “Kunaze nim nanga xawit naagu klis aze razaan ka tak? ");
INSERT INTO nal_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tamon axazak ka varur nua wana aikilizang, ma araan naagu zazangas iaa nanga xa waan sin a rapti xai kilis, gu gut kuna guna mada naan inaan la lan, ma mur laxo naaguna balas iaa la non iwana ikilizang. Taulaan naan kana urif nua xa waan sin a rapti xai kilis ma a rapti xai kilis kana lis nua la mit a buzul ma a buzul xana rasin nua la vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ga vazei nua, guna iziar la vaal a vaamaazikang ka ruaas gu vanong a maraana a wulwulang faakdul.” ");
INSERT INTO nal_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","La raan angkanaan azanon aubina ina di ra iziar inaan, di vazei Iesu wana azanon aubina in Gaalili, ina Paailat ka ra kling ubina dauran sina ma di zop famaat naandi araan di lis a talazang sin naandi xa waan sin Nakmai. Ma a daraaia naandi xa ravukaai laaxur wana a daraai amun kak talavaat ina di ra talazin sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma Iesu xa xis naandi naako, “Araan amun Gaalili angkanaan di maat malasing kanaan, malasing faa, naagu naxaam adu xa viaat adu amun matmalabuk taksaat sin naandi xa laaup pana zin naandi vaakdul azanon aubina in Gaalili? ");
INSERT INTO nal_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ga vazei nim, kawit mase! Singsaxai tamon naaguna wen inaxam taawuk siaana amun matmalabuk taksaat sinim, nim faakdul zaait naaguna milung. ");
INSERT INTO nal_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Malasing faa wana aubina in Siloaam, naandi di zangaaflu ma xa wizik tul ina di ra maat araan a vaal baraaf puzaa mase laaxur, xa zu waramin naandi? Malasing faa, naagu naxaam adu amun matmalabuk taksaat sin naandi xa laaup pana zin naandi vaakdul azanon aubina di iziar Jerusalem? ");
INSERT INTO nal_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ga vazei nim, kawit mase! Singsaxai tamon naaguna wen inaxam taawuk siaana amun matmalabuk taksaat sinim, nim faakdul zaait naaguna milung.” ");
INSERT INTO nal_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Naanaan Iesu xa vazei naandi wana a dorang lalaamangaai malasing kari, “Aza rapti xa ra vazu a iaai a fik lamaskana auma waain sina, ma mur xa waan ma xa wa raamaai zaleng ta fnuaai iwana fik, singsaxai xawit na tangin tazaxai. ");
INSERT INTO nal_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Malasing ma xa vazei a rapti xat katkatong auma naako, ‘A maariaas urul xari xa gai wat sazaleng a fnuaai iwana iaai angkari, singsaxai xawit gai tangin luk ta zaxai. Guna tok pizin! Kunaze xana vanong palau a vuaan ila pira angkari?’ ");
INSERT INTO nal_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Singsaxai a rapti xat katkatong auma xa xis naan naako, ‘Piran! Tuaa xalaak kana irur wana a maariaas azaxai xaarik ma gana xaaf faraxulin a pira la vuna ma gana rasin tazanon fuaan pana. ");
INSERT INTO nal_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tamon ka vuai la maariaas laaxur, xa daxa. Ma tamon kawit na vuai, naanaan guna tok pizin ka.’ ” ");
INSERT INTO nal_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aza raan a Saabat Iesu xat faraviraai lamaskana aza vaal a maainungang sin amun Judaa. ");
INSERT INTO nal_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma aza ravin inaan a zapalaau xa ragul naan pana a maariaas ka zangaaflu ma xa wiziktul. A butuaana xa butufulung, ma xawit mase nat faraxas kana ruvaatak. ");
INSERT INTO nal_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Araan Iesu xa raamin naan, ka viring fawat naan paamua ma xa vazei naan naako, “Diravin, gu mamaraxas siaana a maravanang kanaan la winum.” ");
INSERT INTO nal_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma Iesu xa rasin uru mitna wana naan ma fazaaus mase a ravin ka ruvaatak ma xa wisfaru Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A waamua ila vaal a maainungang kanaan ka mangat panaze Iesu xa ra vira a ravin la raan a Saabat. Ma xa piaat sin aubina naako, “Ka rauxin a raan ka wizik saaxa xuna vaamuzazang ma nim naaguna wat lamun taan angkanaan kuna dina vira nim, ma xawit la raan a Saabat.” ");
INSERT INTO nal_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma a Piran ka xis naan naako, “Nim aubina xawit naagut falos a dorang sinim! Iaak la raan a Saabat, kawit saait tazaxai zinim kai akpaat pizin a bulumagau o a dongki zina la vaal a bulumagau ma xana valos naan kuna xana imin, aan? ");
INSERT INTO nal_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Singsaxai a ravin angkari, aza natnaat sin Aabaraam, Saatan ka ra bulupis naan pana maariaas ka zangaaflu ma xa wiziktul. Malasing faa, xawit na tak pana dina akpaat pizin naan siaana azaan angkanaan ka ra bulupis naan, la raan a Saabat?” ");
INSERT INTO nal_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Araan ka piaat fanong malasing kanaan sin naandi, naandi ina di ra mangat paamua, di maangil. Ma amala aubina di nanam pana amun saan faakdul xa marmari daxa ina Iesu xa ra giu. ");
INSERT INTO nal_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu xa iaari zin naandi naako, “A bikabar zin Nakmai xa malasing aze? Gana vatfaraxazin a bikabar zin Nakmai wana aze razaan? ");
INSERT INTO nal_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ka malasing a xalamona maastat ina a rapti xa vazu lamaskana uma zina. Ka bok ma xa balas laba malasing a iaai, ma amun maani di wat ma di nu wana amun tangtangaana.” ");
INSERT INTO nal_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma Iesu xa iaari xaarik malasing kari, “Gana vatfaraxazin a bikabar zin Nakmai wana aze razaan? ");
INSERT INTO nal_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ka malasing a is, a ravin ka zuruk ma xa plaas faraxin pana a lun flaaua laba xa ruaas ka ring faakdul mase.” ");
INSERT INTO nal_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Araan Iesu xa zazangas puzaa xunikula Jerusalem, naan kat faraviraai lamun bina laba ma lamun bina ina naan kat sazangas pana. ");
INSERT INTO nal_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma axazak ka iaari zin Iesu naako, “Piran, malasing faa, Nakmai xana zaxot faulin be aubina xawit faras?” Ma Iesu xa xis naandi naako, ");
INSERT INTO nal_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ga vazei nim, naaguna gut kuna albizang pana a mara mumut, panaze amala aubina dina lalaamangaai xuna albizang, singsaxai xawit nat faraxas dina albis. ");
INSERT INTO nal_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Araan damana vaal xana rur ma xana baraat kol a mara, nim naaguna irur lamanar naaguna pidik pana a mara ma naaguna viraai lapuk malasing kari, ‘Piran! Kaas a mara wana maam.’ Singsaxai naan kana xis nim malasing kari, ‘Ga wetexaazin nim, o nim inifaa.’ ");
INSERT INTO nal_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ma naaguna piaat sina malasing kari, ‘Maadi ra vavangan ma maadi ra imimin faraxai wana nua, ma gu ra irur lamun lan simaam ma gut faraviraai.’ ");
INSERT INTO nal_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Singsaxai naan kana xis nim malasing kari, ‘Ga wetexaazin nim, o nim inifaa. Nim faakdul aubina raksaat, naagu waan siaagu!’ ");
INSERT INTO nal_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dina vut fatukbilok nim, ma araan naagu raamin Aabaraam, ma Aaisaak, ma Jekop, ma amun profet faakdul lamaskana bikabar zin Nakmai, naaguna rataangis ma naagunat karaat alvana nim. ");
INSERT INTO nal_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aubina dina ramaraat fataling amun bina ila non ina a iaas kai laak pana, ma amun bina ila non ina a iaas kai si wana, ma amun bina ila not, ma amun bina ila saaut ma dina wat iziar ma dina vangan pana a flangan lamaskana bikabar zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Faaratunaan mase, azanon aubina ina di waamua dina wat mur. Ma azanon aubina ina di wat mur dina waamua.” ");
INSERT INTO nal_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","La notaan angkanaan, azanon Faarasi di wat sin Iesu ma di vazei naan malasing kari, “Guna luaa a non angkari ma guna waan tawarak. Erot ka saxot adu xana zop famaat nua.” ");
INSERT INTO nal_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu xa xis naandi malasing kari, “Naagu vazei Erot a raktegit malasing kari, ‘Taning ma lamaf gana mof pizin amun sapalaau ma gana vira aubina di gias, ma wana varulang a raan gana vanong a vaamuzazang surugu.’ ");
INSERT INTO nal_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Singsaxai gana zazangas nanga taning, lamaf ma kabung urua zaait panaze xawit nat faraxas ta profet kana maat la bina rawarak, kawit. Dina zop famaat nanga naan Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Amun Jerusalem, amun Jerusalem, naagu ra zop famaat amun profet ma naagu ra tukfamaat naandi ina Nakmai xa ra kling fawat naandi zinim. Faavaras ga ra saxot adu gana zaxot fatuin nim malasing naanaa uraa xat saxot fatu a kaana nalik sina xu lawaana bibina. Singsaxai xawit naagu saxot. ");
INSERT INTO nal_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Naagu langar! A bina zinim kana raksaat ma xana bingil. Ga vazei nim, naaguna wen taamin kaarik nia xa ruaas la raan naaguna piaat malasing kari, ‘Nakmai xa lis a daxaiang sina ina xa wat pana aizina a Piran.’ ” ");
INSERT INTO nal_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aza raan a Saabat, Iesu xa wa vangan la vaal zin aza waamua zin amun Faarasi, ma aubina di raamin falagot naan kuna raaminang aze razaan naana giu. ");
INSERT INTO nal_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma xa rauxin a rapti xa gias, a wina xa vangat ma xa wat saait inaan lamarana Iesu. ");
INSERT INTO nal_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma Iesu xa iaari zin amun Faarasi ma amun maravas iwana amun Lus sin Moses malasing kari, “Malasing faa, xa tak pana Lus kuna viraiang aubina di gias la raan a Saabat o xawit?” ");
INSERT INTO nal_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Singsaxai xawit di xis naan. Malasing ma Iesu xa rasin a mitna wana a rapti ma xa vira naan, ma lamuraana xa kling pizin naan. ");
INSERT INTO nal_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ma Iesu xa iaari zin naandi naako, “Nis sinim, tamon naatna o a bulumagau zina xa zu lamaskana luka daanim la raan a Saabat, naana wen purif fazaus fawat laaxur?” ");
INSERT INTO nal_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma xawit nat faraxas dina xis a dorang sina. ");
INSERT INTO nal_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Araan Iesu xa ra iziar nanga wana vanganang, ka raamin azanon topuran ina di wat, di saxot dina zuruk amun kin siziarang sin aubina di rauxin aiza laba. Ma xa dador lalaamangaai zin naandi malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tamon axazak ka saaxat kuna waanang pana a flangan iwana vaamaxuzang, tuaa gu zuruk akin siziarang paamua, taulaan axazak ka laaup pana nua xana wat saait lamuraam. ");
INSERT INTO nal_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma a rapti ina xa maainung fawat numaa xana wat sunum ma xana vazei nua naako, ‘Tamaraat ma gu lis akin siziarang kari zin a rapti angkari.’ Ma guna maangil raksaat mase ma guna wa iziar mase lamur. ");
INSERT INTO nal_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Malasing ma tamon di saaxat, gu zuruk akin siziarang la mur xuna a rapti ina xa saaxat kana wat ma xana piaat sunum naako, ‘Paluaak, tamaraat ma gu wat iriat pana akin siziarang daxa.’ Malasing ma naan kana lis aiza laba zunum lamarana amun topuran ina di wat pana flangan. ");
INSERT INTO nal_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Avuna axazak kat falaup naan nanga, Nakmai xana vamumut naan, ma axazak kat famumut naan nanga, Nakmai xana valaup naan.” ");
INSERT INTO nal_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Naanaan Iesu xa piaat sin a Faarasi ina xa zaxot naan kula flangan naako, “Araan gu nimnimanin a flangan, tuaa gu maainung amun paasaxo zunum ma amun daazum ma amun taaum ma aubina di raxumbaaxut lapaarum kuna watang. Avuna araan guna giu malasing kanaan, mur naandi xaarik dina saaxat ma dina xis faulin sunum. ");
INSERT INTO nal_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Singsaxai araan gu nimnimanin a flangan, gu maainung fawat be aubina di izi gogof ma amun sipas ma naandi amun kaaka naandi xa raksaat ma amun marawif. ");
INSERT INTO nal_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Naandi uwat aubina angkanaan, kawit nat faraxas dina xis faulin nua. Singsaxai tamon guna giu malasing kanaan, Nakmai xana lis a daxaiang sunum. Naan kana xis faulin sunum la raan aubina di tak dina ramaraat puli ziaana maatang.” ");
INSERT INTO nal_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Azaxai zin aubina ina xa vangan faraxai wana Iesu xa langarin a dorang kanaan, ma xa piaat naako, “Naandi ina dina vangan pana flangan lamaskana bikabar zin Nakmai dina zuruk a daxaiang.” ");
INSERT INTO nal_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Iesu xa dador lalaamangaai zina naako, “Aza rapti xa saxot kana giu adi flangan laba, ma xa maainung amala aubina dina wat. ");
INSERT INTO nal_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma wana raan iwana flangan, ka kling a iaana kilaaiang sina xuna vazeiang naandi ina naa ra maainung naako, ‘Naagu wat, panaze amun saan faakdul xa nimniman faanong.’ ");
INSERT INTO nal_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Singsaxai naandi vaakdul di piaat dina wen balas, ma di lis amun dorang ka rawarak. Azaxai naako, ‘Ga samura wulwul be a vang pira, ma gana waan kalaak gana wa raamin. Ga maainung nua guna luaa psin nia.’ ");
INSERT INTO nal_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma axazak naako, ‘Ga samura wul be amun bulumagau xa zangaaflu, ma gana waan kalaak gana wa lalaamangaain naandi wana vaamuzazang. Ga maainung nua guna luaa psin nia.’ ");
INSERT INTO nal_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma aza xazak kaarik ka piaat malasing kari, ‘Ga samura maxus be, malasing ma xawit nat faraxas gana wat.’ ");
INSERT INTO nal_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","A iaana kilaaiang ka uli ma xa vazei a mono zina wana amun dorang faakdul angkanaan. A mono zina xa mangat ma xa vazei a iaana kilaaiang sina naako, ‘Gu waan fazaaus lamun lan laba ma amun lan mumut lamaskana amun bina laba, ma gu zaxot fawat aubina di izi gogof ma aubina amun kaaka naandi xa raksaat ma amun marawif ma amun sipas.’ ");
INSERT INTO nal_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Naanaan a iaana kilaaiang ka piaat naako, ‘Piran, ga giu vanong amun saan gu kling nia wana, singsaxai xa rauxin nanga a marapalau lamaskana vaal.’ ");
INSERT INTO nal_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ma a mono xa piaat sin a iaan a kilaaiang sina naako, ‘Gu waan lamun lan lamanar wana bina laba ma lamun lan mumut lapaara amun uma ma gu zaxot fawat aubina xuna dina albis lamaskana vaal zurugu xuna xana bas. ");
INSERT INTO nal_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ga vazei nim, kawit taxazak sin naandi ina ga ra tabung maainung fawat naandi dina namnaam ta vang fanganang iwana a flangan surugu.’ ” ");
INSERT INTO nal_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Adi mala aubina di waan faraxai wana Iesu, ma xa rutaawuk ka waan sin naandi ma xa piaat naako, ");
INSERT INTO nal_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tamon axazak ka saxot kana los nia, ma xana wen maska raksaat pana damana ma dina ma taak sina ma a funalik sina ma amun daasna ma amun fafina ma a roroiang sina zaait, naan kawit nat faraxas kana balas a rapti varaviraai zurugu. ");
INSERT INTO nal_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma axazak ina xawit na vazaak a robuxul zina ma xa los nia, xawit nat faraxas kana balas a rapti varaviraai zurugu. ");
INSERT INTO nal_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tamon axazak sinim ka saxot kana giu a vaal ina xa uzaa mase laaxur, xana daxa tamon naan kana iziar ma xana inaxam daxa xalaak ma xana vakot a maraana amun saan kuna giuang a vaal angkanaan, tamon kat faraxas naan kana vanong a vaal o xawit. ");
INSERT INTO nal_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tamon kawit naa giu malasing kanaan ma naan kana rasin be a vaanga vaat laba waanaburut kuna vaziaarang a vaal ma mur xana wen fanong a vaal vaakdul, aubina dina raamin ma dina vis naan. ");
INSERT INTO nal_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Dina piaat malasing kari, ‘A rapti angkanaan ka vaziaar be akin siarang iwana vaal singsaxai xawit nat faraxas naana vanong.’ ");
INSERT INTO nal_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O tamon aza xalxaal xa rauxin ubina dauran ka taausan ka zangaaflu ma xa saxot kana waan pana dauran pana aza xalxaal ina xa rauxin ubina dauran ka taausan ka zangaaflu vaarua, xana daxa tamon naan kana iziar ma xana inaxam daxa xalaak, tamon kana wa varop o xawit. ");
INSERT INTO nal_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tamon kawit, naan kana kling azanon paamua zina xuna dina wa dador varaxai wana aza xalxaal xuna rasinang a luaai lawalaua naandi araan naan ka iziar nanga lawalaau. ");
INSERT INTO nal_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Malasing be nim, tamon kawit nat faraxas naaguna luaa psin amun saan faakdul zinim, kawit nat faraxas naaguna balas ubina varaviraai zurugu.” ");
INSERT INTO nal_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Iesu xa piaat kaarik naako, “A rasmaxas azaan daxa, singsaxai tamon a maamis iwana xa malik, dina rasin faulin a maamis iwana malasing faa? ");
INSERT INTO nal_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Awat rasmaxas angkanaan kawit na daxa wana dina rasin pana a pira xuna vawaalang amun fanganang kana bok ma xawit saait na daxa wana dina rasin faraxai wana a mingas sin amun kak talavaat kuna vabalozang a vuaan kuna pira. Dina zuruk be ma dina psin. Axazak ka rauxin alngana, xa daxa xana langarin a dorang kari.” ");
INSERT INTO nal_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aza raan ubina iwana zurukang a taakis ma aubina di gigiu amun matmalabuk taksaat, di waan sin Iesu xuna langarinang a dorang sina. ");
INSERT INTO nal_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Singsaxai amun Faarasi ma amun maravas iwana amun Lus sin Moses dit murmuru, ma di piaat pana Iesu malasing kari, “A rapti angkari xai paasaxo varaxai wana aubina di gigiu amun matmalabuk taksaat ma xa vavangan faraxai wana naandi.” ");
INSERT INTO nal_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Naanaan Iesu xa vazei naandi wana aza dorang lalaamangaai malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tamon azaxai zinim ka rauxin amun sipsip ka zangaaflu varazuaai, ma azaxai zin naandi xa malik. Malasing faa, naan kana wen paan fataling amun sipsip ka zangaaflu vaawizik faat ma xa wizik faat, la non angkanaan naandi dit favangan pana, ma naan kana wa zaleng azaxai angkanaan ka ruaas naana tangin? ");
INSERT INTO nal_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Araan naan ka tangin fanong a sipsip angkanaan, kana dokdok mase ma naana rasin la xalxalana, ");
INSERT INTO nal_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma xana waan la vaal zina. Ma naan kana viring fatu amun paasaxo zina ma amun paliaana varaxai ma xana vazei naandi naako, ‘Dia dina dokdok faraxai! Ga tangin fanong a sipsip angkaina zurugu xa ra malik ma ga zaxot faulin fanong naan!’ ");
INSERT INTO nal_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ga vazei nim, pana awat lan angbani a dokdokang laba xat balas ikula la lia araan axazak azaxai xa gigiu amun matmalabuk taksaat ka inaxam taawuk. A dokdokang kanaan ka laaup marazaat pana a dokdokang pana aubina di zangaaflu vaawizik faat ma xa wizik faat ina di tak faanong ma xawit a vuvuna xuna dina inaxam taawuk.” ");
INSERT INTO nal_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma Iesu xa piaat kaarik naako, “Tamon a ravin ka rauxin a kaakaai xa zangaaflu zina, ma xa vamalik azaxai. Malasing faa, naan kana vailaap a laam ma xana sor a maskana vaal, ma xana zaleng fatalamin mase xa ruaas naana tangin luk kaarik? ");
INSERT INTO nal_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Araan naan ka tangin fanong, kana viring fatu amun paasaxo zina ma amun paliaana, ma xana vazei naandi malasing kari, ‘Dia dina dokdok faraxai, wanaze a kaakaai azaxai zurugu xa malik ma ga tangin fanong ma ga zuruk faulin.’ ” ");
INSERT INTO nal_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma Iesu xa piaat naako, “Ga vazei nim, pana awat lan angbani a dokdokang kat balas lawalau amun aangelo zin Nakmai araan axazak azaxai xa gigiu amun matmalabuk taksaat ka inaxam taawuk.” ");
INSERT INTO nal_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu xa piaat kaarik naako, “Aza rapti xa rauxin a nalik urua. ");
INSERT INTO nal_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A zaxamur xa vazei maamaa zina malasing kari, ‘Maamaa! Ga saxot guna wagaal amun saan faakdul zunum ina guna vatawaraxin labirua wana nimaa daazugu. Aze ramun saan adu aaxaku, gu lis pizin ka zurugu.’ Malasing ma maamaa zin nandiaa xa vatawaraxin amun lulugaan sina labirua wana nandiaa. ");
INSERT INTO nal_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Azanon taan lamur, a zaxamur xa zuruk fatuin amun lulugaan faakdul zina ma naa vaangurin sin aubina. Ka zuruk a kaakaai iwana ma xa waan laza non lawalaau mase, ma xa vanong pizin palau amun kaakaai zina wana awat taagulang kawit na tak. ");
INSERT INTO nal_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma araan ka ra vanong fakdul a kaakaai zina, adi zong laba xa ra balas lamaskana a non laba vaakdul angkanaan ma xa izi gogof. ");
INSERT INTO nal_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma naan ka waan ma xa wa saaleng faamuzazang kuna dina wul naan. Malasing ma xa wa balas a iaana kilaaiang sin aza rapti ila non laba angkanaan ma a rapti xa kling naan kana wa talas bari. ");
INSERT INTO nal_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ka raamin amun bari di vavangan, ma xa saxot mase adu xana sfaar a xuna wana a vanganang sin amun bari, singsaxai xawit taxazak na ralaas naan pana tazaan. ");
INSERT INTO nal_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Naanaan ainaxamang daxa xa balas sina ma xa piaat sina nanga naako, ‘Ubina vaamuzazang sin maamaa zurugu di vavangan daxa ma dit maazur. Ma xa rauxin nanga amun kibaala vanganang ina naadit maazur vataling, singsaxai nia xari gana maat pana lagaaiang! ");
INSERT INTO nal_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Gana ramaraat ma gana uli waan sin maamaa zurugu ma gana piaat sina malasing kari, “Maamaa, nia ga ra giu vanong a matmalabuk taksaat lamarana Nakmai ma lamaraam saait. ");
INSERT INTO nal_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nia xawit a rapti daxa xaarik kuna xanat faraxas guna vakilaan nia naarum. Gu luaa be nia gana iziar malasing aza rapti vaamuzazang sunum.” ’ ");
INSERT INTO nal_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naanaan ka ramaraat ma xa uli waan sin damana. Singsaxai araan naan ka ra zazangas nanga lawalaau vaamumut, damana xa raamin naan ma a maskana xa bas mase wana varamaaluvang pana naan. Naan ka valaau waan sin naatna ma xa rotfating naan ma xa ngus naan. ");
INSERT INTO nal_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma naatna xa piaat sina naako, ‘Maamaa, nia ga ra giu a matmalabuk taksaat lamarana Nakmai ma lamaraam saait. Nia xawit a rapti daxa xaarik kuna xanat faraxas guna vakilaan nia a nalik sunum.’ ");
INSERT INTO nal_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Singsaxai damana xa piaat sin amun iaana kilaaiang sina naako, ‘Fazaaus! Naagu waan ma naagu zuruk fawat a marapi baraaf angkaina zurugu ina xa marmari daxa, ma naagu vavalaak naan pana. Naagu rasin a ring la klusmitna, ma naagu vavalaak naan pana su la ru xaakna. ");
INSERT INTO nal_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Naagu zuruk fawat a naata bulumagau xa walak daxa ma naagu zop famaat kuna dia vaakdul dina vangan pana flangan ma dina dokdok faraxai. ");
INSERT INTO nal_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Avuna a nalik angkari zurugu xa maat faanong singsaxai naari xa roro uli xaarik. Naan ka ra milung ma naari xa balas puli vaanong.’ Naanaan di varumara vanganang pana flangan lapuk la raan angkanaan ma di dokdok. ");
INSERT INTO nal_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Singsaxai a nalik tuaan sina xa ra iziar nanga la uma. Naan ka ramaraat ma xa zangas puat lapaara vaal zin damana, ma xa langarin a linga aubina di ratangan ma di ritiria. ");
INSERT INTO nal_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma xa viring luk aza iaana kilaaiang ma xa iaari zina wana aze razaan ka balas. ");
INSERT INTO nal_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma a iaana kilaaiang ka xis naan naako, ‘Daazum ka balas puli vaanong ma damaam ka zop famaat a naata bulumagau xa walak daxa wanaze naatna xa uli daxa xaarik.’ ");
INSERT INTO nal_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma a nalik tuaan ka mangat ma xa baai xana albis lamaskana vaal. Malasing ma damana xa tukbilak ma xa maainung falagot naan kuna albizang. ");
INSERT INTO nal_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Singsaxai naan ka piaat sin damana naako, ‘Langar! A maariaas ka varas ga rat faamuzas aaxanum malasing aza iaana kilaaiang palaau. Ma ga rat langar daxa zunum pana amun faamuzazang gui kling nia xuna giuang. Singsaxai xawit taza raan gu ra lis ta naata meme be zurugu xuna nia varaxai wana amun paasaxo zurugu maadina vangan ma maadina dokdok faraxai. ");
INSERT INTO nal_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Singsaxai a nalik angkanaan sunum, ka ra vanong palau amun saan faakdul zunum pana furavin dit faangurin a winpina naandi xuna kaakaai. Ma araan ka ra balas, faabuza mase gu zop famaat a naata bulumagau xa walak daxa aaxana.’ ");
INSERT INTO nal_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma damana xa xis naan naako, ‘Naarugu, nua gu iziar bulaai varaxai wana nia. Ma amun saan faakdul zurugu aaxanum. ");
INSERT INTO nal_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Singsaxai dia dina vangan ma dina dokdok faraxai wanaze daazum ka ra maat faanong ma naari xa roro uli xaarik. Ka ra milung ma naari di tangin fanong naan.’ ” ");
INSERT INTO nal_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu xa piaat sin ubina varaviraai zina naako, “Aza rapti raxumbaaxut ka rauxin a rapti vaamuzazang ina xa rat katkatong amun lulugaan sina. Ma di vakor a rapti vaamuzazang kanaan adu xai kawin palau amun saan sin a rapti raxumbaaxut. ");
INSERT INTO nal_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naan ka viring a rapti vaamuzazang ma xa iaari zina naako, ‘Aze razaan kari ga ra langarin pana nua? Gu dador vaamaravas pana a vaamuzazang sunum, panaze xawit kaarik nat faraxas guna vaamuzas la vaal zurugu.’ ");
INSERT INTO nal_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ma a rapti vaamuzas angkanaan ka piaat sina nanga naako, ‘Aze mase gana giu? A mono zurugu xana vanong nia wana a vaamuzazang surugu. Kawit ga rauxin a dikdikang kuna kavang, ma ga maangil zaait pana nungnungang. ");
INSERT INTO nal_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ga rexaas pana aze razaan gana giu xuna aubina dina rudaxain nia ma dina zaxot nia xu lamun faal zin naandi, araan a mono zurugu xa vanong nia wana vaamuzazang surugu.’ ");
INSERT INTO nal_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Malasing ma xa viring falbis azaxai zaxai zin aubina vaakdul ina di rauxin amun dinaau zin a mono zina. Ma xa iaari zin azaxai ina xa tabung paamua wat malasing kari, ‘Usfa dinaau zunum sin a mono zurugu?’ ");
INSERT INTO nal_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ma naan ka piaat malasing kari, ‘Azangaaflu varazuaai xa wizik tul amun gaalan wel iwana olif.’ Ma a rapti vaamuzazang ka piaat naako, ‘Suruk a waambaar angkari ina di ra varaar a dinaau zunum pana ma siar vazaaus ma gu varaar azangaaflu varazuaai urulavaat amun gaalan wel.’ ");
INSERT INTO nal_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma naan ka iaari zin a varuaiang a rapti malasing kari, ‘Usfa dinaau zunum?’ Ma naan ka xis naan malasing kari, ‘Azangaaflu varazuaai vaazangaaflu a vaanga laxa laba xa bas pana wit.’ Ma naan ka piaat malasing kari, ‘Suruk a waambaar angkari ina di ra varaar a dinaau zunum pana ma fazaaus be gu varaar azangaaflu varazuaai xa wiziktul.’ ");
INSERT INTO nal_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","A mono zina xa rexaas adu a rapti vaamuzazang sina xawit nat faaratunaan pana amun faamuzazang sina, singsaxai xa wisfaru naan pana a mazamang sina wanaze xa vagit a mono zina singsaxai xa vananam azanon aubina. Avuna aubina ila pira angkari, di rexaas daxa mase wana a wat matmalabuk sin naandi malasing a rapti angkanaan, ma xa laba nanga wana rexaazang sin aubina ila maravas. ");
INSERT INTO nal_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ga vazei nim, naaguna vabalos amun paasaxo aaxanim nanga lalozang amun lulugaan ila pira angkari. Ma araan amun lulugaan angkanaan kana vaanong, Nakmai xana zaxot nim ma xana rasin nim lamaskana amun faal daxa ina xai rur bulaai ma xawit nat faanong. ");
INSERT INTO nal_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Axazak ina xat faaratunaan pana akaana zaan mumut, naan kat faaratunaan saait pana amun saan lapuk. Ma axazak ina xawit nat faaratunaan pana akaana zaan mumut, naan kawit saait nat faaratunaan pana amun saan lapuk. ");
INSERT INTO nal_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tamon kawit naagut faaratunaan pana xatkatong fatalaminang amun lulugaan ila pira angkari, nis kana inaxam paazaai wana nim adu naagut faraxas naaguna xatkatong fatalamin amun lulugaan faaratunaan inikula laaxur? ");
INSERT INTO nal_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma tamon kawit naagut faaratunaan pana amun saan sin axazak tawarak, nis kana lis tazaan aaxan nim nanga? ");
INSERT INTO nal_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kawit nat faraxas ta iaana kilaaiang kana vaamuzas sin a mono urua, xawit. Naan kana maska raksaat pana axazak ma xana sasaxot axazak. Ma xana vaaratunaan be wana azaxai ma xana wiaal axazak. Kawit nat faraxas naaguna iaana kilaaiang sin Nakmai varaxai wana kaakaai zaait.” ");
INSERT INTO nal_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Amun Faarasi di langarin ma di plaas a iza naandi wana Iesu, wanaze naandi aubina di sasaxot famarazaat a kaakaai. ");
INSERT INTO nal_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ma Iesu xa piaat sin naandi naako, “Naagui waafatok nim lamarana aubina, singsaxai Nakmai xa rexaazin a maskana nim. Avuna amun saan ka laba marazaat lamarana aubina, xa mitikaai lamarana Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ma Iesu xa piaat kaarik naako, “Amun Lus sin Moses ma amun dorang sin amun profet ka ra wat dikdik ka ruaas la raan sin Jon A Rapti Iwana Baaptaaizang. Lamuraana a raan angkanaan di ifazei wana a Dorang Daxa wana a bikabar zin Nakmai, ma aubina vaakdul di igut kuna albizang lamaskana. ");
INSERT INTO nal_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ka lagaf pana a bara ma pira dina menawaai iaa, singsaxai xawit mase nat faraxas pana ta nan paaling mumut kana menawaai wana Lus sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tamon a rapti xa kip a maxuzang sin nandiaa ma xa maxus kaarik sin aza ravin tawarak, a rapti angkanaan ka giu a matmalabuk taksaat iwana milivinang a ravin tawarak. Ma a rapti ina xa maxus sin a ravin ina labana xa ra vataling naan, naan saait ka giu a matmalabuk taksaat iwana milivinang a ravin tawarak.” ");
INSERT INTO nal_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iesu xa dador lalaamangaai xaarik naako, “Aza rapti raxumbaaxut kat mamaaus pana amun marapi a maraana naandi xa laaup marazaat ma aizi raagulang sina xa laaup marazaat. ");
INSERT INTO nal_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka rauxin aza rapti aizina xanaan Laazarus. Naan a rapti xat nungnung ma dit faziaar rasin naan lamanar lamarana mara iwana vala zin a rapti raxumbaaxut. A winpina xa bas pana amun burus. ");
INSERT INTO nal_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Naan kai saxot kana iaan a sina vanganang ina xai zu wana aiban favanganang sin a rapti raxumbaaxut angkanaan. Ma amun piu di uwat ma di damit amun burus la winpina. ");
INSERT INTO nal_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lamuraana azanon taan ka vaanong, Laazarus a rapti xa izi gogof ka maat. Ma amun aangelo di vazaak naan ma di rasin naan lapaara Aabaraam. Ma a rapti raxumbaaxut angkanaan saait ka maat, ma di xavin naan. ");
INSERT INTO nal_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka iziar lamaskana a bina zin aubina di maat. A winpina xa maazik marazaat mase, ma xa raamaai uzaa laaxur ma xa raamin Aabaraam lawalaau mase ma Laazarus saait lapaarana. ");
INSERT INTO nal_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma xa viraai waan sina naako, ‘Maamaa Aabaraam, maluf nia. Gu kling Laazarus kana rasin a klusmitna lamaskana daanim ma xana wat famindavut a xaramaagu wana. Ga xazanin adi maazikang laba mase, iriat lamaskana adi xaiaf laba.’ ");
INSERT INTO nal_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Singsaxai Aabaraam ka piaat naako, ‘Naarugu, gu naxaam faulin araan gu izi roro nanga, gu ra rauxin atavur amun saan daxa. Singsaxai wana Laazarus, naan ka ra rauxin atavur amun saan taksaat pana roroiang sina. Ma taning, Nakmai xa mada naan araan nua gu xazanin adi maazikang laba. ");
INSERT INTO nal_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma aza zaan saait, ka rauxin adi luk laba xa lulungaai la birua wana maam ma nim. Kawit nat faraxas taxazak kana kas buak kuninaan sinim, ma xawit nat faraxas taxazak inaan la non gu iziar wana xana kas buak kunitiat simaam.’ ");
INSERT INTO nal_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ma a rapti raxumbaaxut ka piaat naako, ‘Maamaa, ga maainung nua, gu kling Laazarus kula vaal zin maamaa zurugu. ");
INSERT INTO nal_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Avuna ga rauxin amun daazugu xa watmit. Naan kana wa fanaau zin naandi xuna tuaa naandi zaait dina wat iriat la non angkari iwana adi maazikang laba.’ ");
INSERT INTO nal_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Singsaxai Aabaraam ka xis naan naako, ‘Ka rauxin amun Lus sin Moses ma amun dorang sin amun profet ka iziar vaanong faraxai wana naandi. Kana daxa tamon dina langarin ma naadina valos.’ ");
INSERT INTO nal_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma a rapti raxumbaaxut ka piaat naako, ‘Kawit! Maamaa Aabaraam, singsaxai tamon taxazak ka ramaraat puli wana maatang ma xa balas sin naandi, naan laxo dina inaxam taawuk.’ ");
INSERT INTO nal_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Singsaxai Aabaraam ka xis faulin naan malasing kari, ‘Tamon kawit di saxot dina langarin amun Lus sin Moses ma amun dorang sin amun profet, dina wen langar zaait sin taxazak, naapalaau tamon taxazak ka ramaraat puli ziaana maatang.’ ” ");
INSERT INTO nal_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu xa piaat sin ubina varaviraai zina naako, “Amun saan kana wat faaratunaan ina xana vaxalxaal aubina xuna dina giu amun matmalabuk taksaat, singsaxai xana raksaat mase wana axazak angkanaan kana vabalos. ");
INSERT INTO nal_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kana daxa dina pis adi vaat laba la vuruna ma dina psin naan la laman kuna xana xanak, taulaan kana vaxalxaal tazaxai zin a kaana funalik angkari wana zuiang lamaskana a matmalabuk taksaat. ");
INSERT INTO nal_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Malasing ma naagu naknakaai daxa wana nim nanga. Tamon daazum ka giu a matmalabuk taksaat, guna vadawaar naan. Ma tamon ka inaxam taawuk, guna naxaam pizin a matmalabuk taksaat sina. ");
INSERT INTO nal_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tamon ka giu a matmalabuk taksaat pana nua faa wizik urua lamaskana a raan azaxai ma faa wizik urua xa wat sunum ma xa piaat naako, ‘Ga giu a matmalabuk taksaat pana nua, ma naari ga inaxam taawuk,’ guna naxaam pizin a matmalabuk taksaat sina.” ");
INSERT INTO nal_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Malasing ma amun aaposal di piaat sin a Piran malasing kari, “Gu valaup ainaxam paazaaiang simaam!” ");
INSERT INTO nal_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma naan ka piaat naako, “Tamon ainaxam paazaaiang sinim ka mumut malasing a xalamona maastat, kat faraxas naaguna vazei a iaai laba angkari di vakilaan maalberi malasing kari, ‘Gu put luk nua ma gu vazu nua nanga nana raas, ma xana langar zinim.’ ” ");
INSERT INTO nal_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ma Iesu xa piaat kaarik naako, “Tamon azaxai zinim ka rauxin a iaana kilaaiang sina xat faamuzas la uma o xat katkatong amun sipsip. Malasing faa araan naan ka uli wat pana vaamuzazang, guna vazei naan malasing kari, ‘Laawus gu ziar iriat ma gu vangan’? Kawit. ");
INSERT INTO nal_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Guna piaat sina malasing kari, ‘Gu nimnimanin a vanganang surugu ma gu mamaaus pana amun marapi daxa ma guna zuruk fawat a vanganang surugu ma gana vangan ma gana imin. Naanaan laxo guna vangan ma guna imin.’ ");
INSERT INTO nal_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Malasing faa gu naxaam adu a mono zina xana wisfaadaxa zina wanaze xa langar ma xa giu aze razaan naa ra kling naan kuna giuang? Kawit. ");
INSERT INTO nal_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nim saait araan naagu giu vanong amun saan faakdul ina Nakmai xa ra vazei nim kuna giuang, naaguna piaat malasing kari, ‘Dia amun iaana kilaaiang palaau, dia be di ra giu amun faamuzazang sin dia.’ ” ");
INSERT INTO nal_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu xa zazangas kun Jerusalem la rere in Samaaria ma Gaalili. ");
INSERT INTO nal_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naan ka zou lamaskana aza bina, inaan ma xa vasuin ubina xa zangaaflu di rauxin a tapak. Di irur lawalaau vaamumut, ");
INSERT INTO nal_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma di viraai laba malasing kari, “Iesu, Maimaai, maluf maam!” ");
INSERT INTO nal_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu xa raamin naandi, ma xa piaat sin naandi naako, “Naagu waan naagu wa vatangin nim sin amun pris.” Ma araan di zazangas paan, a winpina naandi xa ninis siaana tapak. ");
INSERT INTO nal_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Azaxai zin naandi xa raamin a winpina xa ninis, ma xa uli wat ma xa viraai laba xa wisfaru Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma xa psin fawizik naan paanaburut la pira la xaaka Iesu ma xa wisfaadaxa zin Iesu. A rapti angkanaan in Samaaria. ");
INSERT INTO nal_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu xa iaari zina naako, “Malasing faa, xawit nim naagu zangaaflu a winpina nim ka ninis? A vaa uza wizik faat? ");
INSERT INTO nal_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kunaze xawit taxazak sin naandi na uli wat kuna wisfaruiang Nakmai? A ropuran angkari zingbe xa uli wat.” ");
INSERT INTO nal_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma Iesu xa piaat sina naako, “Tamaraat ma gu waan, ainaxam paazaaiang sunum ka vira vatalamin nua.” ");
INSERT INTO nal_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Azanon Faarasi di iaari zin Iesu, wana aze ra raan a bikabar zin Nakmai xana balas ma xa xis naandi naako, “A bikabar zin Nakmai xawit nat faraxas naaguna raamin araan kana balas. ");
INSERT INTO nal_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma aubina dina wen piaat, ‘Naari,’ o ‘Naambaxo,’ wanaze a bikabar zin Nakmai xa iziar lawalaua nim.” ");
INSERT INTO nal_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Naanaan Iesu xa piaat sin ubina varaviraai zina naako, “A raan kana wat araan naaguna saxot mase adu naaguna raamin azaxai iwana amun taan sin Naata Rapti, singsaxai naaguna wen taamin. ");
INSERT INTO nal_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aubina dina vazei nim malasing kari, ‘Naan ka taa,’ o ‘Naan kari!’ Tuaa naagu valau lalos naandi. ");
INSERT INTO nal_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Avuna la raan Naata Rapti xa uli wat, aubina vaakdul dina raamin. Kana malasing a wilak ina xat pilwilak ma xat pilaak a bara itaa ma ipaa. ");
INSERT INTO nal_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Singsaxai paamua xalaak Naata Rapti xana xazanin a maazikang laba, ma a watkul itaning kana bain naan. ");
INSERT INTO nal_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Amun taan sin Naata Rapti xana malasing amun taan sin Noaa. ");
INSERT INTO nal_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Aubina di vavangan ma di imimin ma dit maxus ka ruaas a raan Noaa xa albis lamaskana a sip sina. Naanaan a daavur xa uzan ma adi ulim ka wat ma xa vanong pizin naandi vaakdul. ");
INSERT INTO nal_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ka malasing saait lamun taan sin Lot. Aubina di vavangan ma di imimin ma dit pulwul ma dit faangur ma dit faazu ma di gigiu vaal. ");
INSERT INTO nal_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Singsaxai la raan angkanaan araan Lot ka waan fataling a bina Sodom, a xaiaf faraxai wana saalfa xa zu wat ikula la lia malasing a daavur ma xa vaif naandi vaakdul ma xa vanong pizin naandi. ");
INSERT INTO nal_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kana malasing mase bani la raan Naata Rapti xana balas la maravas. ");
INSERT INTO nal_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","La raan angkanaan, tamon axazak ka iziar la waat a vaal zina, xana wen pizik paanaburut kuna zurukang amun saan sina lamaskana vaal. Malasing saait bani, tamon axazak ka iziar la uma, naan kana wen puli xula bina xuna zurukang tazaan. ");
INSERT INTO nal_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Naaguna naxaam taak sin Lot! ");
INSERT INTO nal_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tamon axazak ka saxot kana roting falagot a roroiang sina nanga, a roroiang sina xana milung, singsaxai tamon axazak ka vamiluaar a roroiang sina, xana roting falagot. ");
INSERT INTO nal_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ga vazei nim, labung angkanaan axazak urua di itate iaa wana aiban azaxai, azaxai dina zaxot luk, ma axazak dina luaa. ");
INSERT INTO nal_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","A ravin urua dina maios iaa a wit, ma azaxai dina zaxot luk ma axazak dina luaa.” ");
INSERT INTO nal_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ubina varaviraai zina di iaari zina malasing kari, “Piran, amun saan angkanaan kana balas faa?” Ma xa vazei naandi naako, “A non a maat ka imaal wana, amun kor dina varazuaai inaan.” ");
INSERT INTO nal_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu xa ra dador lalaamangaai zin ubina varaviraai zina xuna viraaiang naandi wana maainungang bulaai ma dina wen malumbaai. ");
INSERT INTO nal_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iesu xa piaat naako, “Laza bina xa rauxin aza rapti xa ikilis ma naan kawit nat marauring Nakmai ma xawit na varanop pana naan ma xawit na inaxam pana aubina. ");
INSERT INTO nal_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","La bina angkanaan ka rauxin saait aza raksiziar, labana xa maat faanong, ka wat bulaai zin a rapti angkanaan ma xat fazei naan naako, ‘Gu rasin a lus ka tak pana nia ma a purua zurugu wana a matmalabuk taksaat sina naa giu wana nia.’ ");
INSERT INTO nal_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ka vaabung baraaf faanong ma xawit na langor naan, ma lamuraana xa inaxam malasing kari, ‘Naapalaau xawit gat marauring Nakmai ma xawit ga varanop pana naan ma xawit ga inaxam pana aubina, ");
INSERT INTO nal_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","a raksiziar angkanaan bulaai xat famosmos nia, iaak ka daxa gana varur nandiaa wana aikilizang kuna vamazikang axazak ina xa giu a matmalabuk taksaat. Taulaan kana vamazik nia wana wat bulaaiang.’ ” ");
INSERT INTO nal_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A Piran Iesu xa piaat naako, “Naagu langarin a dorang sin a rapti ina xai kilis taksaat. ");
INSERT INTO nal_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ubina ma furavin Nakmai xa ra kalin naandi aaxana nanga, di rataangis kupkup bulaai waan sina lawaanaas ma labung. Malasing faa, iaak Nakmai xana zimbang pana vawaalang naandi wana amun maravanang sin naandi, aan? Kawit. ");
INSERT INTO nal_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ga vazei nim, naan kana vazaaus mase wana vatokang naandi. Singsaxai a raan Naata Rapti xana wat, malasing faa, xana tangin nanga ubina ma furavin di inaxam paazaai wana naan iriat la pira angkari?” ");
INSERT INTO nal_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesu xa piaat a dorang lalaamangaai angkari zin azanon aubina ina di inaxam paazaai wana naandi nanga adu naandi aubina di tak ma di wiaal uzanon. ");
INSERT INTO nal_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Naan ka piaat naako, “Uru rapti di uzaa iaa la vaal xoxok ma di wa maainung iaa. Azaxai zin nandiaa a Faarasi, ma axazak a rapti xa zuzuruk a taakis. ");
INSERT INTO nal_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A Faarasi xa rur ma xa maainung pana naan nanga malasing kari, ‘Nakmai, ga piaat ka daxa zunum panaze xawit ga malasing azanon aubina, amun finaau o aubina raksaat o aubina dit milivin ubina o furavin tawarak, ma nia zaait kawit ga malasing a rapti angkari xa zuzuruk a taakis. ");
INSERT INTO nal_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gat falvaal a raan urua lamaskana a wik azaxai, ma gai lis a zaxai iwana a zangaaflu zurugu wana amun saan faakdul gat fabalos ka waan sunum.’ ");
INSERT INTO nal_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ma a rapti xa zuzuruk a taakis ka rur lawalaau vaamumut nanga ma xawit na raamaai uzaa laaxur la lia, wanaze xa maangil. Ka wit a bangbangana wana maskaluzang ma naako, ‘Nakmai, nia a rapti iwana gigiuang amun matmalabuk taksaat, maluf nia.’ ” ");
INSERT INTO nal_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iesu xa piaat nanga malasing kari, “Ga vazei nim, a rapti angkari ina xa zuzuruk a taakis araan ka uli xula vaal zina, naan ka tak mase lamarana Nakmai, ma axazak kawit. Avuna naan ina xat falaup naan, Nakmai xana vamumut naan, ma naan ina xat famumut naan, Nakmai xana valaup naan.” ");
INSERT INTO nal_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aubina di zaxot fawat akaana nalik mumut sin Iesu xuna xana rasin uru mitna laaxur wana naandi ma xana lis a daxaiang sin naandi. Araan ubina varaviraai zin Iesu di raamin, di vadawaar naandi. ");
INSERT INTO nal_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Singsaxai Iesu xa viring fawat akaana nalik mumut, ma xa piaat malasing kari, “Naagu luaa a funalik dina wat surugu. Tuaa naagu vaxadong naandi wanaze a bikabar zin Nakmai, zin naandi malasing kari. ");
INSERT INTO nal_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ga vazei varatunaan nim, tamon axazak kawit na rudaxain a bikabar zin Nakmai malasing a nan nalik, naan kawit nat faraxas kana albis lamaskana.” ");
INSERT INTO nal_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aza waamua xa iaari zin Iesu naako, “Maravas daxa, gana giu aze ra zaan kuna gana raumana a roro tapal?” ");
INSERT INTO nal_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma Iesu xa xis naan naako, “Aze ra vuvuna gu vakilaan nia adu ga daxa? Kawit ta xazak ka daxa, Nakmai zingbe xa daxa. ");
INSERT INTO nal_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gu rexaazin amun Lus sin Moses: ‘Tuaa gu milivin a ravin tawarak. Tuaa gu zop famaat axazak. Tuaa gu vinaau. Tuaa gu vaagit pana axazak. Guna varanop pana damaam ma dinaam.’ ” ");
INSERT INTO nal_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A rapti xa xis naan naako, “Amun saan faakdul angkanaan gai giu araan ga nalik mumut nanga xa ruaas taning.” ");
INSERT INTO nal_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Araan Iesu xa langarin, ka vazei naan naako, “Azaan azaxai nanga xawit gu giu. Guna waan ma guna vaangurin amun saan faakdul gu rauxin, ma amun kaakaai iwana guna ralaas aubina di izi gogof. Tamon guna giu malasing kanaan guna rauxin amun lulugaan daxa ikula la lia. Ma mur guna wat ma guna los nia.” ");
INSERT INTO nal_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Araan ka langarin a dorang kanaan ka maskalus mase wanaze naan ka raxumbaaxut. ");
INSERT INTO nal_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu xa raamin naan ma xa piaat malasing kari, “Ka lagaf pana aubina di raxumbaaxut dina albis la bikabar zin Nakmai! ");
INSERT INTO nal_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Faaratunaan, ka lagaf pana kaamel xana albis lamaskana marana a nil iwana zaxazitang amun marapi, singsaxai xa lagaf nanga wana a rapti raxumbaaxut kana albis la bikabar zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aubina ina di langarin a dorang kanaan, di iaari malasing kari, “Tamon malasing kanaan, nis mase Nakmai xana zaxot faulin?” ");
INSERT INTO nal_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma Iesu xa xis naandi naako, “Amun saan ina aubina xawit dit faraxas dina giu, Nakmai xat faraxas kana giu.” ");
INSERT INTO nal_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma Pita xa vazei naan naako, “Taamin, maadi ra luaa psin fanong amun saan faakdul zimaam ma maadi los nua.” ");
INSERT INTO nal_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Naanaan Iesu xa vazei naandi naako, “Ga piaat faratunaan sinim, axazak ina xa inaxam pana a bikabar zin Nakmai, ma xa ra vataling a vaal zina o taak sina o amun daasna o amun fafina o damana ma dina o a funalik sina, ");
INSERT INTO nal_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","araan ka iziar nanga wana a roroiang ila pira angkari, Nakmai xana ralaas naan pana amun saan angkanaan, singsaxai xana laaup marazaat mase wana ina naa tabung tauxin paamua. Ma wana roroiang mur, naan kana rauxin a roro tapal.” ");
INSERT INTO nal_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu xa zaxot parok a zangaaflu ma urua ubina varaviraai zina ma xa vazei naandi naako, “Naagu langar, naari di uzaa ikula Jerusalem ma amun saan faakdul ina amun profet di ra varaar wana Naata Rapti xana balas faaratunaan pana naan. ");
INSERT INTO nal_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Amun Judaa dina lis naan la mita ubina xawit amun Judaa. Dina vis naan ma dina lingpuak lawaana ma dina kanis naan ");
INSERT INTO nal_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ma dina kmis naan pana wip ma dina zop famaat naan. Ma wana varulang a raan naan kana ramaraat puli ma xana roro.” ");
INSERT INTO nal_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ubina varaviraai zina xawit di maravas pana amun saan angkanaan. Avuvuna dorang ka izi vunfun siaana naandi, ma xawit di rexaazin aze razaan Iesu xa rai dador wana. ");
INSERT INTO nal_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu xa wat faasilik pana Jeriko, ma aza rapti xa marawif, ka iziar la rita lan ma xat nungnung aubina. ");
INSERT INTO nal_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Naan ka langarin a ling amala di zazangas bilas ma xa iaari naako, “Aze razaan ka balas?” ");
INSERT INTO nal_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma di vazei naan malasing kari, “Iesu in Naazaret ka zazangas bilas.” ");
INSERT INTO nal_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma xa viraai malasing kari, “Iesu, a Natnaat Sin Dewit, maluf nia!” ");
INSERT INTO nal_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aubina di zangas paamua di vadawaar naan kana ziburung, singsaxai xa vut firaai laba laxo naako, “A Natnaat Sin Dewit, maluf nia!” ");
INSERT INTO nal_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu xa rur ma xa vazei naandi dina zaxot fawat naan sina. Ma araan ka wat faasilik Iesu xa iaari zina naako, ");
INSERT INTO nal_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aze gu saxot gana giu aaxanum?” Ma xa xis naan naako, “Piran, ga saxot gana raamaai.” ");
INSERT INTO nal_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma Iesu xa vazei naan naako, “Gu raamaai! Ainaxam paazaaiang sunum ka vira vanong nua.” ");
INSERT INTO nal_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Fazaaus mase naan ka raamaai, ma xa los Iesu ma xa wisfaru Nakmai. Ma aubina vaakdul ina di ra raamin azaan angkanaan, naandi zaait di wisfaru Nakmai. ");
INSERT INTO nal_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu xa zou Jeriko xuna xana waan Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma aza rapti aizina Saakius ka iziar inaan, naan a waamua zin ubina di zuzuruk a taakis, ma naan saait a raxumbaaxut. ");
INSERT INTO nal_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Naan ka saxot kana raamin Iesu singsaxai naan ka xalxaalif ma xawit nat faraxas kana raamin naan panaze adi mala marazaat. ");
INSERT INTO nal_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Naan ka valaau waamua ma xa vani a iaai laba di vakilaan a sikamo xuna raaminang Iesu xa zangas la lan angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu xa wat la non angkanaan, ma xa raamaai uzaa laaxur wana iaai, ma xa piaat sina naako, “Saakius, kabal vazaaus. Taning gana iziar la vaal zunum.” ");
INSERT INTO nal_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ka kabal vazaaus puat paanaburut ma xa zaxot Iesu xula vaal zina varaxai wana a dokdokang. ");
INSERT INTO nal_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Araan aubina vaakdul di raamin, di murmuru malasing kari, “A rapti angkari xa ropuran la vaal zin a rapti xa gigiu amun matmalabuk taksaat.” ");
INSERT INTO nal_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Saakius ka rur ma xa piaat sin a Piran naako, “Piran, gu langar, amun lulugaan faakdul zurugu gana wagaal labirua ma gana lis sin aubina di izi gogof. Ma tamon ga ra vagit fanong taxazak ma ga vinau tazaan sina, gana xis faaralavaarin.” ");
INSERT INTO nal_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma Iesu xa piaat sin Saakius naako, “Taning nanga a vaamuzazang iwana zaxot faulinang aubina xa balas la vaal angkari, wanaze Saakius saait aza natnaat sin Aabaraam. ");
INSERT INTO nal_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Avuna Naata Rapti xa wat kuna zalengang naandi ina di ra milung ma xana zaxot faulin naandi.” ");
INSERT INTO nal_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aubina di langarin ma di naxaam adu a raan iwana a bikabar zin Nakmai xana balas fazaaus mase avuna Iesu xa iziar lapaara Jerusalem. Ka vazei naandi wana aza dorang lalaamangaai ");
INSERT INTO nal_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","malasing kari, “Aza waamua xa nimniman kuna waanang pana aza pira lawalaau xuna dina bur naan kana balas a xalxaal, ma mur xana uli wat kaarik la bina. ");
INSERT INTO nal_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Paamua wana naan ka waan, ka viring luk a zangaaflu amun iaana kilaaiang sina, ma xa lis a kaakaai azaxai zin naandi zaksaxai di vakilaan a mina ma xa piaat naako, ‘Naaguna vaamuzas laaxur wana xa ruaas gana uli wat.’ ");
INSERT INTO nal_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Singsaxai aubina ila pira angkanaan di maska raksaat pana naan ma di kling azanon ubina xuna zalengang naan ma di piaat malasing kari, ‘Kawit maadi saxot a rapti angkari xana balas a xalxaal zimaam.’ ");
INSERT INTO nal_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Singsaxai di bur vanong naan ka xalxaal, ma xa uli wat la bina zina xaarik. Naanaan ka kilaai xun amun iaana kilaaiang ina xa ra lis a kaakaai zin naandi xuna xana rexaazin usfa naadi vabalos kuna valaupang a kaakaai angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ma a rapti waamua xa wat sina ma xa piaat naako, ‘Piran, ga vaamuzas pana a kaakaai gu ra lis surugu ma ga zuruk a kaakaai xa zangaaflu xaarik laaxur wana.’ ");
INSERT INTO nal_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma a mono zina xa piaat malasing kari, ‘Ka daxa marazaat, nua mase a iaana kilaaiang daxa! Gana varur nua guna xatkatong amun bina laba xa zangaaflu, wanaze ainaxamang sunum ka dikdik pana amun saan mumut.’ ");
INSERT INTO nal_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ma a varuaiang ka wat sina ma xa piaat naako, ‘Piran, a kaakaai gu lis surugu xa vabalos a kaakaai xa watmit kaarik laaxur wana.’ ");
INSERT INTO nal_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma a mono zina xa piaat naako, ‘Nua guna xatkatong amun bina laba xa watmit.’ ");
INSERT INTO nal_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Aza iaana kilaaiang ka wat ma xa piaat naako, ‘Piran, a kaakaai zunum kari ina gu ra lis surugu. Ga flus pana waan marapi, ma ga rasin. ");
INSERT INTO nal_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Avuna ga maraaut pana nua a rapti gu maradikdik. Gut suruk amun kaakaai ina xawit gu ra rasin la adi vaal a kaakaai, ma gui laaf amun fanganang nua xawit gu ra vazu.’ ");
INSERT INTO nal_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A mono zina xa piaat naako, ‘Nua a iaana kilaaiang taksaat. Gana klis nua wana amun dorang sunum. Nua gu piaat adu nia a rapti maradikdikang, ma gu piaat saait adu nia gat suruk amun kaakaai ina xawit ga ra rasin la adi vaal a kaakaai, ma gai laaf amun fanganang kawit ga ra vazu. ");
INSERT INTO nal_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kunaze xawit gu rasin a kaakaai zurugu la vaal a kaakaai xuna araan gana uli wat, gana zuruk a kaakaai zurugu varaxai wana azanon kaakaai laaxur wana?’ ");
INSERT INTO nal_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ma xa vazei naandi angkanaan di irur inaan naako, ‘Naagu zuruk a kaakaai ziaana ma naagu lis sin a rapti ina xa rauxin a kaakaai xa zangaaflu.’ ");
INSERT INTO nal_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ma di piaat sina malasing kari, ‘Piran, naan ka rauxin fanong a kaakaai xa zangaaflu.’ ");
INSERT INTO nal_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma xa xis naandi naako, ‘Ga vazei nim, naandi ina di rauxin azaan, dina lis kaarik nanga zin naandi. Ma naandi ina xawit di rauxin tazaan, naapalaau aze ra nan saan naadi rauxin dina zuruk pizin saait siaana naandi. ");
INSERT INTO nal_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma naari, naagu zaxot fawat amun purua zurugu ina xawit di saxot nia gana balas a xalxaal zin naandi, ma naagu zop famaat naandi iriat lamaraagu.’ ” ");
INSERT INTO nal_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Araan Iesu xa vazei vanong naandi wana a dorang lalaamangaai angkanaan, ka zazangas paamua xunikula Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Naan ka balas puat lapaara uru bina Betfaage ma Betani la nan paatawut di vakilaan a Waatawut Olif. Ma xa kling urua zin ubina varaviraai zina varaxai wana dorang malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Naagu waan iaa la bina xa iziar waamua wana numaa, ma araan naagu albis iaa la bina angkanaan, naaguna raamin iaa a dongki vaaxur di pis tasin kawit nanga taxazak nat kawaas. Kiwaat luk iaa ma naagu zuruk fawat iaa iriat. ");
INSERT INTO nal_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tamon taxazak kana iaari zunumaa adu xunaze naagu akpaat iaa a dongki, naagu piaat iaa malasing kari, ‘A Piran ka saxot.’ ” ");
INSERT INTO nal_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Uru rapti angkanaan ina Iesu xa kling paamuin nandiaa di waan iaa ma di raamin iaa amun saan ka balas faaratunaan malasing naan ka ra vazei nandiaa wana. ");
INSERT INTO nal_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Araan di akpaat iaa a dongki, ubina vuvuna dongki di iaari zin nandiaa malasing kari, “Kunaze naagu akpaat iaa a dongki vaaxur?” ");
INSERT INTO nal_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ma di xis iaa naandi malasing kari, “A Piran ka saxot.” ");
INSERT INTO nal_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Naadi wa lis iaa zin Iesu ma di akpaat pizin iaa amun marapi baraaf sin nandiaa, ma di rasin pana dongki ma di vaziaar iaa Iesu laaxur wana. ");
INSERT INTO nal_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Araan ka zazangas paan aubina di akpaat pizin amun marapi baraaf sin naandi ma di zawarin la lan. ");
INSERT INTO nal_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Araan naan ka wat faasilik pana lan ka kabal wizik la Waatawut Olif, a dokdokang laba mase xa zuruk amala vaakdul aubina varaviraai zina ma di wisfarur Nakmai ma dit kupkup laba wanaze di ra raamin fanong amun faamuzazang ka banglala, ma di xupkup malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“A daxaiang ka waan sin a xalxaal ina xa wat pana aizina a Piran!” “A luaai xa iziar la lia, ma a marmari daxaiang ka waan sin Nakmai ikula mase laaxur!” ");
INSERT INTO nal_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Azanon Faarasi lawalaua mala aubina angkanaan di piaat sin Iesu malasing kari, “Maravas, fadawaar aubina varaviraai zunum.” ");
INSERT INTO nal_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Singsaxai Iesu xa xis naandi naako, “Ga vazei nim, tamon aubina angkanaan dina ziburung, amun faat dina xupkup pana wisfaaruiang.” ");
INSERT INTO nal_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu xa wat faasilik lapaara Jerusalem, ma naa raamin ma naa rangis saxot, ");
INSERT INTO nal_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ma naako, “Ga saxot taning naaguna rexaazin aze ramun saan kana lis a luaai zinim! Singsaxai xawit nat faraxas naaguna raamin, kai zi vunfun. ");
INSERT INTO nal_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kana rauxin amun taan kana wat, araan amun purua zinim dina wat tur varaxulin a bina laba zinim, ma dina varur a vala xuna waakolang nim, ma dina varuxol a lan sinim iwana albizang ma tukbilakang, ma dina waakol nim lamun titit faakdul. ");
INSERT INTO nal_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dina albis lamaskana amun balavaat iwana bina laba zinim ma dina tuxin fawizik nim faraxai wana funalik sinim paanaburut ma naaguna maat. Ma dina wen luaa ta vaat kana itete laaxur wana axazak, avuna xawit naagu raamin fakilaan a raan ina Nakmai xa ra wat sinim.” ");
INSERT INTO nal_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu xa albis lamaskana a rabaraau ila vaal xoxok, ma xa vut fatukbilak aubina dit faangur. ");
INSERT INTO nal_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma xa vazei naandi naako, “Di ra varaar vating lamaskana Baar Xoxok malasing kari, ‘Dina vakilaan a vaal zurugu a vaal iwana maainungang.’ Singsaxai naagu xul ma xa malasing ‘a vaal ina amun finaau di rataagul wana.’ ” ");
INSERT INTO nal_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Amun taan faakdul Iesu xat firaai aubina lamaskana a rabaraau ila vaal xoxok. Amun pris laba ma amun maravas iwana amun Lus sin Moses, ma amun paamua zin amun Judaa di zaleng a lan kuna zop famaatang naan. ");
INSERT INTO nal_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Singsaxai xawit di tangin ta lan kuna zop famaatang naan, panaze aubina vaakdul di saxot dina langarin a dorang faakdul zin Iesu. ");
INSERT INTO nal_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Aza raan Iesu xat faraviraai lamaskana a rabaraau ila vaal xoxok, ma xat firaai aubina wana Dorang Daxa. Ma amun pris laba ma amun maravas iwana amun Lus sin Moses faraxai wana amun paamua zin aubina di wat sina. ");
INSERT INTO nal_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Di iaari zina malasing kari, “Gu vazei maam, gu zuruk a burburaaiang faa naanaan gu gigiu amun saan angkanaan pana? Nis ka lis a burburaaiang kanaan sunum?” ");
INSERT INTO nal_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma Iesu xa xis naandi naako, “Ma nia zaait gana iaari zinim pana aza iaariang. Naagu vazei nia, ");
INSERT INTO nal_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","a burburaaiang sin Jon kuna baaptaaizang aubina xa wat faa, la lia o zin aubina ila pira angkari?” ");
INSERT INTO nal_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma di dador lawalaua naandi nanga malasing kari, “Tamon di piaat ‘Ila lia,’ naan kana iaari, ‘Kunaze xawit naagu inaxam paazaai wana dorang sina?’ ");
INSERT INTO nal_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Singsaxai tamon di piaat ‘Sin aubina,’ aubina vaakdul dina tuk dia wana amun faat panaze naandi di inaxam paazaai wana Jon adu naan a profet.” ");
INSERT INTO nal_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Naanaan di xis be naan malasing kari, “Kawit maadi rexaas ka wat faa.” ");
INSERT INTO nal_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Iesu xa xis naandi naako, “Gana wen fazei zaait nim pana ga zuruk a burburaaiang faa naari ga gigiu amun saan angkanaan pana.” ");
INSERT INTO nal_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesu xa vazei xaarik aubina wana aza dorang lalaamangaai malasing kari, “Aza rapti xa vazu a uma waain ma naa rasin la mita zanon ubina xuna naandi dina vaamuzas pana ma dina xatkatong ma dina isuruk kaakaai wana. Ma naan ka waan laza bina lawalaau ma xa wa raagul inaan faabung baraaf. ");
INSERT INTO nal_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","La raan iwana mozang amun fnuaai a waain, ka kling aza iaana kilaaiang sina xa waan sin ubina dit faamuzas la uma waain kuna dina lis tazanon fnuaai a waain aaxana. Singsaxai ubina dit faamuzas la uma waain di zop naan ma di kling fagof faulin naan. ");
INSERT INTO nal_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ka kling kaarik aza iaana kilaaiang ka waan sin naandi ma di zop saait naan ma di vamangil naan ma di kling fagof faulin naan. ");
INSERT INTO nal_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lamur xa kling a varulang a iaana kilaaiang. Di zop faraksaat naan ma di psin fatukbilok naan. ");
INSERT INTO nal_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ma damana a uma xa piaat naako, ‘Aze razaan gana giu? Gana kling naarugu ina ga sasaxot, iaak dina varanop pana naan.’ ");
INSERT INTO nal_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Singsaxai araan ubina dit faamuzas di raamin naan, di dador lawalaua naandi nanga malasing kari, ‘Naan ina xana xul damana xari xa wat. Naagu wat, dina zop famaat naan kuna a uma waain angkari aaxan dia.’ ");
INSERT INTO nal_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Di psin fatukbilok naan ku lamanar wana a uma ma di zop famaat naan.” Ma Iesu xa piaat kaarik sin aubina naako, “Damana a uma xana giu aze wana naandi? ");
INSERT INTO nal_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Damana a uma xana wat ma xana zop famaat ubina dit faamuzas la uma ma naana lis sin azanon ubina rawarak.” Araan aubina di langarin, di piaat malasing kari, “Kawit mase!” ");
INSERT INTO nal_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma Iesu xa raamin naandi ma xa piaat naako, “Aze ra aknaas a dorang kari lamaskana Baar Xoxok ina xa piaat naako, ‘A vaat ina ubina iwana gigiuang a vaal di bain pizin, naan kanaan ka balas a varumaraiang a vaat iwana vaal.’ ");
INSERT INTO nal_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aubina vaakdul ina di zu laaxur wana a vaat angkanaan, dina raabuak mimiringit, ma axazak ina a vaat angkanaan kana zu laaxur wana naan, kana mem.” ");
INSERT INTO nal_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Amun maravas iwana amun Lus sin Moses ma amun pris laba di zaleng ta lan kuna dina zaraak fazaus Iesu avuna di rexaas adu Iesu xa piaat a dorang lalaamangaai angkanaan pana naandi be. Singsaxai di marauring aubina. ");
INSERT INTO nal_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Amun maravas iwana amun Lus sin Moses ma amun pris laba di rataamaai lalos Iesu. Ma di kling azanon ubina dina wat taamin burungin naan ma di babof mara be adu naandi ubina di tak. Dit simbong Iesu xana piaat ta dorang kawit na tak kuna dina rasin naan pana aikilizang sin a waamua zin a gaapman in Judia. ");
INSERT INTO nal_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma di piaat malasing kari, “Maravas, maadi rexaas adu amun dorang sunum ma amun faraviraaiang sunum saait ka tak. Ma gui piaat a dorang azaxai zin aubina vaakdul, aubina di rauxin aiza laba ma aubina xawit ta iza. Gut firaai aubina wana a lan sin Nakmai lalozang a dorang faaratunaan. ");
INSERT INTO nal_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Malasing faa, xa tak pana dia dina wul a taakis ka waan sin Siza o xawit?” ");
INSERT INTO nal_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iesu xa rexaazin fanong a vaagitang sin naandi ma xa vazei naandi naako, ");
INSERT INTO nal_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Naagu vatangin ta denaarias kaakaai azaxai zurugu. A waroka nis kari ma a fararang kari wana nis?” Ma di xis naan malasing kari, “Zin Siza.” ");
INSERT INTO nal_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma xa vazei naandi naako, “Aze razaan sin Siza, naagu lis sin Siza, ma aze razaan sin Nakmai, naagu lis sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naandi xawit dit faraxas dina vaxabebeu Iesu inaan lamarana amala aubina. Di raknar wana a dorang naa xis naandi wana ma di ziburung. ");
INSERT INTO nal_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amun Saadusi di ipiaat kawit ta ramaraat puliang lamuraana maatang, Azanon sin naandi di wat sin Iesu ma di iaari zina malasing kari, ");
INSERT INTO nal_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Maravas, Moses ka ra varaar a lus aaxan dia malasing kari, ‘Tamon ta rapti xana maat fataling taak sina, ma xawit di raxunalik iaa, daasna xana maxus sin a ravin angkanaan kuna xana raxunalik pana aizina daasna angkanaan ka maat faanong.’ ");
INSERT INTO nal_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ka rauxin amun fandaas ka wizik urua. A ruaan ka maat fataling taak sina ma xawit ta nalik sina. ");
INSERT INTO nal_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A varuaiang daasna xa maxus kaarik sin a ravin angkanaan ma xa maat fataling saait naan. ");
INSERT INTO nal_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Naanaan a varulang daasna zaait ka maxus sin a ravin angkanaan, ma xa malasing bani wana amun fandaas faakdul xa wizik urua. Di maxus sina ma naandi vaakdul di maat, singsaxai a ravin kawit na raxunalik lawaana naandi. ");
INSERT INTO nal_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lamur a ravin saait ka maat. ");
INSERT INTO nal_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lamur araan ubina di maat faanong dina ramaraat puli wana maatang, a ravin angkari zinis mase? Avuna naandi ubina di wizik urua di ra maxus sina.” ");
INSERT INTO nal_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu xa xis naandi naako, “Aubina ilamun taan angkari dit maxus. ");
INSERT INTO nal_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Singsaxai aubina ina Nakmai xa rudaxain naandi adu dit faraxas dina ramaraat puli ziaana maatang ma dina roro wana roroiang mur, naandi dina wen maxus. ");
INSERT INTO nal_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ma dina wen maat kaarik panaze di malasing ka amun aangelo. Naandi a funalik sin Nakmai wanaze naan ka varamaraat faulin naandi ziaana maatang. ");
INSERT INTO nal_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Araan a Baar Xoxok ka dador wana axaiaf pana a nan iaai, Moses saait ka ra vatangin adu aubina ina di ra maat faanong dina ramaraat puli ziaana maatang, avuna naan ka ra vakilaan a Piran adu naan, ‘Nakmai zin Aabaraam, ma Nakmai zin Aaisaak, ma Nakmai zin Jekop.’ ");
INSERT INTO nal_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nakmai xawit Nakmai zin amun maat. Kawit. Naan Nakmai zin aubina di roro wanaze lamarana naandi vaakdul di roro.” ");
INSERT INTO nal_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma azanon maravas iwana amun Lus sin Moses di piaat malasing kari, “Maravas, a dorang sunum ka daxa.” ");
INSERT INTO nal_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma aubina vaakdul di maraaut pana iaariang sin Iesu wana tazanon iaariang kaarik. ");
INSERT INTO nal_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu xa piaat sin naandi naako, “Kunaze di piaat adu a Mesaaia a natnaat sin Dewit? ");
INSERT INTO nal_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Avuna Dewit nanga xa piaat lamaskana a baar Saam lamaskana Baar Xoxok malasing kari, ‘A Piran Nakmai xa piaat sin a Piran surugu naako: “Siar la mit sazaxa zurugu, ");
INSERT INTO nal_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","xa ruaas gana rasin amun purua zunum dina balas akin faiavuzang uru xaakum.” ’ ");
INSERT INTO nal_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewit ka vakilaan a Mesaaia adu a Mesaaia a Piran sina. Tamon ka malasing kanaan, malasing faa a rapti angkanaan a natnaat sin Dewit?” ");
INSERT INTO nal_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Araan aubina vaakdul angkanaan dit langarin nanga Iesu xai fazei, naan ka vazei ubina varaviraai zina naako, ");
INSERT INTO nal_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Naagu naknakaai wana amun maravas iwana amun Lus sin Moses. Di saxot adu dinat falaak amun marapi baraaf sin aubina di rauxin aiza laba ma dina zazangas farawuk. Ma di saxot adu aubina dina varanop pana naandi lamun non iwana balas fatuiang. Ma lamaskana amun faal a maainungang, di saxot amun kin siziarang sin ubina laba. Ma wana amun flangan, di saxot dina iziar lamun kin siziarang sin aubina di rauxin aiza laba. ");
INSERT INTO nal_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dit fagit amun raksiziar ma dit paxaar amun saan faakdul zin naandi malasing ma di izi gogof. Ma dit maainung faabung baraaf saait kuna aubina dina raamin naandi. Uwat ubina angkanaan dina zuruk a maravanang laba mase la raan aikilizang sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu xa iziar lamaskana a rabaraau ila vaal xoxok ma xa raamaai uzaa, ma xa raamin ubina raxumbaaxut di pizaai kaakaai lamaskana a bogis iwana rasinang a kaakaai la vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma xa raamin saait aza raksiziar, ina xa izi gogof, ka psin be a kaakaai mumut urua. ");
INSERT INTO nal_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma Iesu xa piaat naako, “Ga vazei varatunaan nim, a raksiziar angkanaan ina xa izi gogof ka psin a kaakaai laba wana naandi vaakdul ina di pizaai. ");
INSERT INTO nal_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Naandi vaakdul di psin akbaala kaakaai zin naandi, ma xa rauxin nanga a kaakaai laba zin naandi xa iziar, singsaxai a raksiziar angkari lamaskana izi gogovang sina xa psin fakdul a kaakaai zina ina xat faraxas pana raagulang sina.” ");
INSERT INTO nal_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Azanon ubina varaxai zin Iesu di dador wana vaal xoxok di ra vamamaus pana amun faat ka marmari daxa mase ma wana amun talazang aubina di ra lis sin Nakmai. Singsaxai Iesu xa piaat naako, ");
INSERT INTO nal_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ga saxot gana vazei nim pana amun saan angkanaan naagu raamin. A raan kana wat ma xana wen tauxin mase ta vaat kana imaal laaxur wana taza vaat, dina burut psin naandi vaakdul xu waanaburut.” ");
INSERT INTO nal_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma naandi di iaari zin Iesu malasing kari, “Maravas, lasang amun saan angkanaan kana balas? Ma aze rawat faakilanang kana waamua xuna maadina rexaas adu amun saan angkanaan kana samura balas?” ");
INSERT INTO nal_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma Iesu xa xis naandi naako, “Naagu naknakaai, aubina dina vagit nim singsaxai tuaa naagu langar zin naandi. Amala dina balas pana aizinugu, dina piaat malasing kari, ‘Nia a Mesaaia,’ o ‘A raan ka vaasilik.’ Tuaa naagu los naandi. ");
INSERT INTO nal_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Araan naagu langarin ka rauxin a dauran ma aubina dit farop faraxai wana amun gaapman sin naandi, tuaa naagu maraaut panaze amun saan angkanaan kana tabung balas kalaak, singsaxai a vaanongang iwana raan kana wen balas nanga.” ");
INSERT INTO nal_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma Iesu xa vazei naandi naako, “Aza kaantri xana varop faraxai wana aza kaantri, ma aza bikabar xana varop faraxai wana aza bikabar. ");
INSERT INTO nal_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma xana rauxin a vaanga maraulia laba ma a zong ma amun giazang dikdik kana balas lamun non farawuk. Ma amun saan kana balas ma xana vamaraut faraksaat aubina ma amun faanga vaakilanang laba la bara xana balas.” ");
INSERT INTO nal_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma Iesu xa piaat kaarik naako, “Singsaxai paamua wana amun saan faakdul angkanaan kana balas, dina zaraak nim ma dina vamazik nim ma dina urif nim ku lamun faal a maainungang sin amun Judaa xuna naaguna rur wana aikilizang, ma dina rasin nim lamun faala vaamaazikang. Dina varur nim lamarana amun kalxaal ma lamarana amun paamua laba. Amun saan faakdul angkanaan kana balas panaze naagui los nia. ");
INSERT INTO nal_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A raan angkanaan, a raan daxa xuna naaguna pitfiaat nia zin naandi. ");
INSERT INTO nal_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Paamua xalaak, naaguna inaxam daxa ma tuaa naagu inaxam farvaras pana aze ra dorang naaguna dador xol nim pana. ");
INSERT INTO nal_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Avuna nia nanga gana rasin a dorang la nguza nim, ma gana lis a mazamang sinim kuna xanawit tazaxai zin amun purua vaakdul zinim kana plaas amun dorang sinim ma xanawit tazaxai xana vatangin adu amun dorang sinim kawit na tak. ");
INSERT INTO nal_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Amun damana nim ma amun dina nim ma amun daaza nim ma amun taaua nim ma amun paasaxo zinim dina ngutlis nim sin amun purua, ma dina zop famaat azanon sinim. ");
INSERT INTO nal_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ma aubina vaakdul dina maska raksaat pana nim avuna wana aizinugu. ");
INSERT INTO nal_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Singsaxai xawit ta vur azaxai ila waata nim kana malik. ");
INSERT INTO nal_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Naaguna irur dikdik. Ma Nakmai xana lis a roro tapal zinim.” ");
INSERT INTO nal_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma Iesu xa piaat kaarik naako, “Araan naagu raamin amala ubina dauran di rur varaxulin Jerusalem, naagu rexaas adu faasilik ka dina vanong pizin Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma nis naandi di iziar la pira Judia, dina valaau xula amun paatawut. Ma naandi di iziar Jerusalem, dina tukbilak ma dina waan tawarak. Ma naandi di iziar lamanar wana bina laba tuaa dina albis lamaskana. ");
INSERT INTO nal_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Avuna a raan angkanaan, a raan iwana aikilizang ma vaamaazikang kuna waambazovang amun dorang faakdul di ra varaar vating lamaskana Baar Xoxok. ");
INSERT INTO nal_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lamun taan angkanaan kana raksaat mase zin a furavin buxut ma zin naandi zaait dit faazus. Adi maravanang kana balas la pira angkari, ma a boromaazikang sin Nakmai xana wat pana amun Judaa. ");
INSERT INTO nal_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Azanon aubina dina zop famaat amun Judaa wana baainaat, ma azanon dina zaxir naandi ma dina zaxot naandi xula amun faal a vaamaazikang lamun non sin amun lemlem aubina vaakdul la pira angkari. Ma aubina xawit amun Judaa dina waramin Jerusalem ka ruaas amun taan angkanaan Nakmai xana waambazof ainaxamang sina wana naandi.” ");
INSERT INTO nal_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ma Iesu xa piaat kaarik naako, “Amun faakilanang kana balas pana iaas ma a flan ma amun patpada. Ma iriat la pira angkari amun lemlem aubina dina maraaut ma ainaxamang sin naandi xana baabaa wana raaminang ma langarinang a vaanga rof laba xa ratambur nana raas. ");
INSERT INTO nal_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aubina dina zumaat pana maraautang avuna dina naxaam amun saan kana balas la pira angkari. Avuna amun saan dikdik ila bara dina valvaaliang. ");
INSERT INTO nal_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ma la notaan angkanaan mase dina raamin Naata Rapti xana wat lamaskana a vang bara varaxai wana dikdikang ma adi maravaasna. ");
INSERT INTO nal_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Araan amun saan angkanaan di varumara balazang, naagu rur ma naagu raxut fauzaa a waata nim laaxur ma tuaa naagu maraaut, avuna a raan Nakmai xana wul vaxarom nim, ka wat faasilik faanong.” ");
INSERT INTO nal_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma Iesu xa dador lalaamangaai zin naandi malasing kari, “Naagu raamin a iaai a fik ma amun iaai vaakdul. ");
INSERT INTO nal_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Araan naagu raamin di rasin afkus, naagu rexaas adu amun flan iwana iaas ka vaasilik. ");
INSERT INTO nal_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka malasing saait bani araan naagu raamin amun saan angkanaan ga ra vazei nim pana xana balas, naagu rexaas adu a raan sin bikabar zin Nakmai xa wat faasilik faanong. ");
INSERT INTO nal_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ga vazei varatunaan nim, a watkul angkari xana roro nanga araan amun saan angkanaan kana balas. ");
INSERT INTO nal_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A bara ma a pira angkari dina vaanong iaa, singsaxai a dorang surugu xana wen faanong mase.” ");
INSERT INTO nal_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ma Iesu xa piaat kaarik naako, “Singsaxai naagu naknakaai daxa wana nim nanga, taulaan a maskana nim kana bas pana bumaatang pana daanim dikdik ma matmalabuk taksaat ma amun inaxam farvarazang iwana roroiang ila pira angkari. Taulaan naaguna raknarin a raan angkanaan kana balas sinim malasing axaak talavaat ka zu lamaskana flung. ");
INSERT INTO nal_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Avuna a raan angkanaan kana balas sin aubina vaakdul di raagul la pira angkari. ");
INSERT INTO nal_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Malasing ma bulaai naagunat naknakaai. Naagunat maainung lamun taan faakdul zin Nakmai xuna xana lis a dikdikang sinim ma xanat faraxas naaguna valiu amun saan angkanaan kana samura balas ma naaguna maainung saait kuna xanat faraxas nim naaguna rur lamarana Naata Rapti.” ");
INSERT INTO nal_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ma lamun taan saksaxai Iesu xat firaai aubina lamaskana a rabaraau ila vaal xoxok ma lamun labung naan kai waan ma xa iziar la waatawut di vakilaan a Waatawut Olif. ");
INSERT INTO nal_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Paanaraan gufguf lamun taan saksaxai aubina vaakdul di wat sina la rabaraau ila vaal xoxok ma dit langarin naan. ");
INSERT INTO nal_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A Raan Laba Iwana A Raraba Xawit A Is, ina dit fakilaan pana A Raan Laba Iwana Zangas Fasaalang ka wat faasilik. ");
INSERT INTO nal_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma amun pris laba ma amun maravas iwana amun Lus sin Moses, di zaleng ta lan kuna zop famaatang Iesu ma aubina dina wetexaas, avuna di maraaut pana aubina. ");
INSERT INTO nal_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Naanaan Saatan ka sfaar Judaas, ina aza izina xanaan Iskaariot. Naan azaxai zin a zangaaflu ma urua ubina varaviraai. ");
INSERT INTO nal_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Naan ka waan sin amun pris laba ma amun paamua zin amun tuxaaul ila vaal xoxok ma di dador varaxai xuna naan kana mitai ngutlis Iesu zin naandi. ");
INSERT INTO nal_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Naandi di ra dokdok ma di rudaxa adu dina wul naan pana kaakaai. ");
INSERT INTO nal_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Naan ka rudaxa ma xa rataamaai wana ta raan daxa ina xawit ta mala aubina di iziar xuna xana ngutlis Iesu zin naandi. ");
INSERT INTO nal_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","A Raan Laba Iwana A Raraba Xawit A Is ka balas, ma bulaai la raan angkanaan di zopsop famaat amun sipsip faaxur xuna vanganang pana A Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma Iesu xa kling Pita ma Jon ma xa vazei nandiaa naako, “Gu waan iaa ma gu nimnimanin iaa a vanganang sin dia xuna vanganang pana A Raan Laba Iwana Zangas Fasaalang.” ");
INSERT INTO nal_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma di iaari iaa zina malasing kari, “Gu saxot maadina nimnimanin iaa vaa?” ");
INSERT INTO nal_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ma Iesu xa xis nandiaa naako, “Araan gu albis iaa Jerusalem, guna vasuin iaa aza rapti xat fazaak a daanim lamaskana win laba. Naaguna los iaa naan kula vaal ina naana albis lamaskana. ");
INSERT INTO nal_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ma naaguna iaari iaa zin damana vaal malasing kari, ‘A Maravas ka iaari adu a rumaaf sin amun topuran faa, xuna nia varaxai wana ubina varaviraai zurugu maadina iaan fakilaan A Raan Laba Iwana Zangas Fasaalang?’ ");
INSERT INTO nal_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma naan kana vatangin a rumaaf lapuk la vaal laaxur, ina di ra nimnimanin tasin fanong kuna vanganang, ma naaguna nimnimanin iaa a vanganang inaan.” ");
INSERT INTO nal_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Naanaan di waan iaa ma di wa tangin iaa amun saan faakdul malasing be Iesu xa ra vazei nandiaa wana. Ma di nimnimanin iaa a vanganang kuna iaan fakilaanang A Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A raan iwana vanganang ka balas ka, ma Iesu varaxai wana amun aaposal zina di iziar la iban favanganang. ");
INSERT INTO nal_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma Iesu xa piaat sin naandi malasing kari, “Ga ra sasaxot famarazaat mase adu dia varaxai dina iaan a vanganang iwana A Raan Laba Iwana Zangas Fasaalang, paamua wana gana vazaak a maazikang. ");
INSERT INTO nal_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Avuna ga vazei nim, gana wen fangan kaarik pana a vanganang kanaan ka ruaas a vuvuna vanganang kanaan kana balas faaratunaan la bikabar zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naanaan Iesu xa zuruk a win imiminang, a waain lamaskana, ma xa wisfaadaxa wana ma xa vazei naandi naako, “Naagu zuruk a win imimin angkari ma naagu imin ma naagu vatawaraxin lawalaua nim. ");
INSERT INTO nal_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Avuna ga vazei nim adu gana wen imin kaarik a waain ka ruaas la raan a bikabar zin Nakmai xana balas.” ");
INSERT INTO nal_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma xa zuruk a raraba, ma naa wisfaadaxa wana ma naa biaak ma xa ralaas naandi wana. Ma xa piaat naako, “Naari a winugu, ga lis kuna vawaalang nim. Naaguna gigiu malasing kari xuna naagunat naxaam faulin nia.” ");
INSERT INTO nal_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pana a lan angbani zaait lamuraana vanganang, ka ra zuruk a win imiminang ma xa piaat naako, “A waain angkari lamaskana a win imiminang, naan a rudaxaiang faaxur ga giu wana a daraaigu ina xana zaal zaxot nim. ");
INSERT INTO nal_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Singsaxai naagu langar, a mita xazak ina xana ngutlis nia zin amun purua xai ziar varaxai wana zurugu la iban favanganang. ");
INSERT INTO nal_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naata Rapti xana maat malasing Nakmai xa ra nol rasin, singsaxai xana raksaat mase zin axazak angkanaan ina xana ngutlis naan sin amun purua.” ");
INSERT INTO nal_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma di iaari varawuk lawalaua naandi zaksaxai adu nis mase axazak sin naandi xana giu malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Naanaan di varamakalaai lawalaua naandi nanga wana nis mase zin naandi dina vakilaan naan adu xa laaup. ");
INSERT INTO nal_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Singsaxai Iesu xa piaat sin naandi malasing kari, “Amun kalxaal zin aubina xawit amun Judaa, di rauxin a burburaaiang laba laaxur wana naandi ma dit falaup naandi nanga. Ma naandi ina di rauxin a burburaaiang laaxur wana aubina naandi dit fakilaan naandi nanga malasing kari, ‘Aubina faawalang.’ ");
INSERT INTO nal_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Singsaxai tuaa naagu malasing kanaan. Naan ina xa laaup mase lawalaua nim, kana malasing a nalik mumut mase, ma a waamua ina xa ratasin a lus pana aubina xana balas malasing a iaana kilaaiang. ");
INSERT INTO nal_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Avuna nis ka laaup, naan ina xa iziar wana aiban favanganang kuna vanganang o naan ina xai talas? Iaak naan ina xai iziar wana iban favanganang, aan? Singsaxai nia ga iziar lawalaua nim malasing axazak kai talas. ");
INSERT INTO nal_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nim naagu ra irur varaxai wana nia lamaskana amun maravanang surugu lamun taan amun maravanang ka ra tangin nia. ");
INSERT INTO nal_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ma gana lis a burburaaiang la mita nim kuna naaguna rasin a lus laaxur wana aubina lamaskana bikabar malasing be Maagu xa ra lis surugu, ");
INSERT INTO nal_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","xuna naaguna vangan ma naaguna imin pana iban favanganang surugu lamaskana bikabar zurugu. Ma naaguna iziar wana amun kin izi xalxaalang ma naaguna klis amun patbung ka zangaaflu ma urua in Israael.” ");
INSERT INTO nal_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ma Iesu xa piaat kaarik naako, “Saaimon, Saaimon, langar. Saatan ka ra iaari adu xana lalaamangaain ainaxam paazaaiang sinim malasing axazak kat fagiraas a xalamona wit siaana a wakpaakna. ");
INSERT INTO nal_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Singsaxai Saaimon, ga maainung faanong ku nua xuna ainaxam paazaaiang sunum kana wen su. Araan gu inaxam taawuk faanong, guna vadikdik amun daazum.” ");
INSERT INTO nal_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Singsaxai Pita xa vazei naan naako, “Piran, ga nimniman kuna waanang faraxai wana nua la vaal a vaamaazikang ma xuna maatang.” ");
INSERT INTO nal_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Iesu xa xis naan naako, “Pita, ga vazei nua, waamua wana a uraa xana kaakaluk, guna wispuk faarul adu gu wetexaazin nia.” ");
INSERT INTO nal_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Naanaan Iesu xa iaari zin ubina varaviraai zina naako, “Araan ga ra kling nim ma xawit naagu zuruk ta lun baaxut o ta laxa o ta su, malasing faa, naagu gof nanga wana tazaan?” Ma di xis naan malasing kari, “Kawit.” ");
INSERT INTO nal_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma Iesu xa vazei naandi naako, “Singsaxai taning nis ka rauxin a lun baaxut, luaa naan kana zuruk, ma malasing saait pana a laxa. Ma nis kawit na rauxin a baainaat, luaa naan kana vaangurin a marapi baraaf sina ma xana wul tazaxai. ");
INSERT INTO nal_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Di ra varaar vating lamaskana a Baar Xoxok malasing kari, ‘Di ra vakot falbis naan faraxai wana aubina raksaat.’ Ma ga vazei nim adu azaan angkanaan, kana balas faaratunaan pana nia. Aiang, aze ramun saan a Baar Xoxok ka piaat pana nia xana samura balas faaratunaan.” ");
INSERT INTO nal_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma ubina varaviraai di piaat malasing kari, “Piran, taamin. A baainaat urua xari.” Ma Iesu xa xis naandi naako, “Kat faraxas.” ");
INSERT INTO nal_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu xa waan fataling a bina laba ma xa waan ikula la Waatawut Olif, malasing naa gigiu bulin. Ma ubina varaviraai zina di los naan. ");
INSERT INTO nal_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Araan di balas la non angkanaan, ka vazei naandi naako, “Naagu maainung kuna naaguna wen su tamon a vaaxabebeuang kana balas sinim.” ");
INSERT INTO nal_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naan ka waan lawalaau vaamumut siaana naandi, wana awat marapalau ina xat faraxas guna psin a vaat, ma xa wa zibukaak, ma xa maainung naako, ");
INSERT INTO nal_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Maagu, tamon gu saxot, suruk pizin a win imiminang kari ziaagu. Singsaxai tuaa gu valos a sasaxotang ma ainaxamang surugu, gu los a sasaxotang ma ainaxamang sunum.” ");
INSERT INTO nal_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma aza aangelo inikula la lia xa ra balas sina ma xa ra vadikdik naan. ");
INSERT INTO nal_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ka xazanin adi maskaluzang laba malasing ma naan ka maainung dikdik nanga, ma a klawas ila winpina xa malasing a dari, xa zu wizik paanaburut la pira. ");
INSERT INTO nal_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Araan ka maainung faanong, ka ramaraat ma xa uli waan sin ubina varaviraai zina ma xa raamin naandi di milaaif avuna a winpina naandi xa malumbaai wana maskaluzang. ");
INSERT INTO nal_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma xa vazei naandi naako, “Kunaze naagu milaaif? Naagu ramaraat ma naagu maainung kuna tuaa naaguna zu tamon a vaaxabebeuang kana balas sinim.” ");
INSERT INTO nal_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Araan Iesu xai dador nanga, amala ubina di wat balas. Ma Judaas, azaxai zin a zangaaflu ma urua ubina varaviraai, xat paamuain naandi. Naan ka wat sin Iesu xuna xana ngus naan. ");
INSERT INTO nal_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma Iesu xa iaari zina naako, “Judaas, malasing faa, guna ngutlis Naata Rapti la mit amun purua wana nguzang naan?” ");
INSERT INTO nal_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma ubina di iziar varaxai wana Iesu di raamin fakilaan aze razaan kana balas, ma di iaari zina malasing kari, “Piran, malasing faa, xat faraxas maadina zop naandi wana amun baainaat simaam?” ");
INSERT INTO nal_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma azaxai zin naandi xa zop a iaana kilaaiang sin a waamua zin amun pris faakdul ma xa kip pizin alnga la mit sazaxa zina. ");
INSERT INTO nal_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma Iesu xa wisbuaak naan naako, “Tuaa!” Ma xa xaaf alngana a rapti angkanaan ma naa vira. ");
INSERT INTO nal_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iesu xa piaat sin amun pris laba ma amun paamua zin amun tuxaaul ila vaal xoxok ma azanon paamua zin aubina ina di wat ku naan naako, “Malasing faa, iaak nia axazak kat farop ma xat finaau, malasing ma naagu wat faraxai wana amun baainaat ma amun iaai iwana varopang? ");
INSERT INTO nal_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Amun taan faakdul ga iziar varaxai wana nim la rabaraau ila vaal xoxok ma xawit naagu zaraak nia. Singsaxai naari, a notaan sinim, a dikdikang ila bungsuzuk ka waamuin nim.” ");
INSERT INTO nal_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Naanaan di zaraak Iesu ma di zaxot luk naan kula vaal zin a waamua zin amun pris faakdul. Singsaxai Pita xai las lawalaau vaamumut. ");
INSERT INTO nal_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Azanon ubina di sung axaiaf labirua wana a rabaraau ila vaal angkanaan, ma di iziar varaxulin. Ma Pita xa wat ma xa ziar varaxai wana naandi. ");
INSERT INTO nal_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aza rakfaaxur, a iaana kilaaiang, ka raamin naan araan ka iziar la maravaaza xaiaf ma xa damin falagot naan ma xa piaat naako, “A rapti angkari xa ra ilos Iesu.” ");
INSERT INTO nal_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Singsaxai Pita xa wispuk naako, “Diravin, ga wetexaazin naan.” ");
INSERT INTO nal_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mur vaamumut be, aza rapti xaarik ka raamin Pita ma xa piaat naako, “Nua zaait azaxai zin naandi.” Singsaxai Pita naako, “Dirapti, nia xawit.” ");
INSERT INTO nal_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lamur vaamumut, malasing a aaua azaxai lamur, axazak kaarik ka dador dikdik naako, “Faaratunaan mase, a rapti angkari xa ra iziar varaxai wana Iesu, avuna naan in Gaalili.” ");
INSERT INTO nal_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma Pita xa xis naan naako, “Dirapti, ga wetexaazin aze gui dador wana.” Ma araan kai dador nanga, fazaaus mase a uraa xa kaakaluk. ");
INSERT INTO nal_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Naanaan a Piran ka rutaawuk ma xa raamaai vaatak pana Pita ma Pita xa naxaam luk a dorang sin a Piran ina xa ra vazei naan malasing kari, “Taning paamua wana a uraa xana kaakaluk, guna wispuk faarul adu gu wetexaazin nia.” ");
INSERT INTO nal_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma Pita xa tukbilak fataling a rabaraau ma xa wa raangis taksaat mase. ");
INSERT INTO nal_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ubina ina di ruxaaul wana Iesu di vis naan ma di wit naan. ");
INSERT INTO nal_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Di pis kol a marana wana a waan marapi ma di piaat sina malasing kari, “Gu dador profet! Fazei maam, nis ka wit nua?” ");
INSERT INTO nal_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma di piaat azanon dorang ka varas ka lingpuak lawaana. ");
INSERT INTO nal_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","A bina xa raan ka, ma amun paamua zin amun Judaa, amun pris laba ma amun maravas iwana amun Lus sin Moses, di wat fatu ma azanon ubina di zaxot fawat Iesu lamarana naandi. ");
INSERT INTO nal_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma di vazei naan malasing kari, “Tamon nua a Mesaaia, fazei maam.” Ma Iesu xa xis naandi naako, “Tamon gana vazei nim, naaguna wen inaxam paazaai wana dorang surugu. ");
INSERT INTO nal_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma tamon gana iaari zinim pana ta iaariang, naaguna wen kis. ");
INSERT INTO nal_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Singsaxai taning ma xa uzaa, Naata Rapti xana iziar la mit sazaxa zin Nakmai, a Maradikdikang.” ");
INSERT INTO nal_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Naandi vaakdul di iaari zin Iesu malasing kari, “Malasing faa nua Naata Nakmai?” Ma naan ka xis naandi naako, “Nim naagu piaat fanong. Nia be.” ");
INSERT INTO nal_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma di piaat malasing kari, “Aze ra dorang kaarik dina zuruk? Dia di langarin fanong a dorang ka wat faatak la ngusna.” ");
INSERT INTO nal_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aubina vaakdul angkanaan di ramaraat ma di zaxot Iesu xa waan sin Paailat. ");
INSERT INTO nal_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma di ramaraat ma di vakor naan di piaat malasing kari, “Maadi raamin a rapti angkari xat falos falmur aubina zimaam. Naan ka pitkol maam kuna tuaa maadina lis a taakis sin Siza, ma xa kalin saait adu naan a Mesaaia, a xalxaal.” ");
INSERT INTO nal_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma Paailat ka iaari zina naako, “Malasing faa Nua a xalxaal zin amun Judaa?” Ma Iesu xa xis naan naako, “Malasing bani gu piaat.” ");
INSERT INTO nal_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Naanaan Paailat ka piaat sin amun pris laba ma zin amun mala aubina naako, “Kawit ga tangin ta vuvuna dorang ina naagu vakor a rapti angkari wana.” ");
INSERT INTO nal_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma dit faangaraai nanga malasing kari, “Naan kat faramaraat a maskana aubina wana amun faraviraaiang sina lamun non faakdul in Judia. Naa varumarain Gaalili ma xa wat faakdul mase iriat.” ");
INSERT INTO nal_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Araan Paailat ka langarin, ka iaari zin naandi tamon Iesu naan in Gaalili. ");
INSERT INTO nal_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma araan naan ka rexaas ka adu Iesu naan ila non laba ina Erot ka ratasin a lus pana, xa kling pizin naan ka waan sin Erot. La notaan angkanaan Erot saait ka iziar Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Araan Erot ka raamin Iesu, xa dokdok mase, wanaze faabung baraaf faanong ka saxot kana raamin Iesu. Naan ka ra langarin a dorang pana Iesu, ma xa saxot mase xana raamin Iesu xana giu ta vaamuzazang ka banglala. ");
INSERT INTO nal_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Erot ka iaari zin Iesu wana amun iaariang ka varas, singsaxai Iesu xawit na xis naan. ");
INSERT INTO nal_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Amun pris laba varaxai wana amun maravas iwana amun Lus sin Moses di irur inaan, ma dit fakor vadikdik Iesu. ");
INSERT INTO nal_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma Erot faraxai wana ubina dauran sina di vis naan ma dit fanangon naan. Ma di vamamaus naan pana a marapi baraaf ka marmari daxa, ma di kling faulin naan ka waan sin Paailat. ");
INSERT INTO nal_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Paamua Erot ma Paailat nandiaa amun purua, singsaxai a raan angkanaan di paasaxo iaa xa. ");
INSERT INTO nal_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Naanaan Paailat ka viring fatu amun pris laba ma amun paamua ma aubina ");
INSERT INTO nal_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ma xa piaat sin naandi naako, “Naagu ra zaxot fawat a rapti angkari zurugu ma naagu ra piaat adu xa rat falos falmur aubina. Ma ga ra iaari zina lamarana nim, ma xawit ga tangin ta vuvuna raksaatang pana rapti angkari lalozang amun saan naagu vakor naan pana. ");
INSERT INTO nal_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma Erot saait kawit na tangin ta zaan pana naan ma xa kling faulin naan sin dia. Faaratunaan kawit di tangin ta zaan taksaat naan naa giu xat faraxas pana naan kana maat saxot. ");
INSERT INTO nal_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Malasing ma gana vamazik naan pana witang naan ma mur gana vamiluaar naan.” ");
INSERT INTO nal_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma aubina vaakdul di laanga xupkup laba varaxai, di piaat malasing kari, “A rapti angkanaan kana maat! Familuaar lis fawat Baarabaas simaam!” ");
INSERT INTO nal_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","A rapti angkanaan Baarabaas ka ra vaxanaat a varopang pana a gaapman lamaskana Jerusalem ma xa ra zop famaat palau zaait azanon ubina ma di rasin naan la vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paailat ka saxot nanga xana vamiluaar Iesu ma xa dador xaarik sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Singsaxai dit firaai nanga malasing kari, “Tukfating naan pana robuxul! Tukfating naan pana robuxul!” ");
INSERT INTO nal_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Naanaan a varulang a iaariang sin naandi naako, “Kunaze? Aze ra matmalabuk taksaat naa giu? Kawit ga tangin ta vuvuna matmalabuk taksaat naana maat saxot. Malasing kanaan gana vamazik naan pana witang naan ma gana vamiluaar naan.” ");
INSERT INTO nal_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Singsaxai di ra vaangaraai nanga ma dit firaai laba varaxai adu dina tukfating naan pana robuxul. Ma di vangarin nanga naan. ");
INSERT INTO nal_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Naanaan Paailat ka los ainaxamang sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ka vamiluaar a rapti ina di iaariin naan, naan ina xa ra vaxanaat a varopang pana a gaapman lamaskana bina laba Jerusalem ma xa ra zop famaat palau zaait azanon ubina ma di rasin naan la vaal a vaamaazikang. Ma xa lis pizin Iesu zin ubina dauran malasing aubina di ra saxot. ");
INSERT INTO nal_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ubina dauran di zaxot pizin Iesu, ma araan di zazangas tukbilak, di vasuin aza rapti in Saairini aizina Saaimon. Naan ka ulili wat kula bina laba. Ma di zaraak naan ma di rasin a robuxul laaxur wana naan ma naa vazaak lamuraana Iesu. ");
INSERT INTO nal_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Amala aubina di ra los naan faraxai zaait pana a furavin ina di maskalus mase ma di ratangis naan. ");
INSERT INTO nal_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu xa plaas naan ka waan sin naandi ma xa piaat naako, “Naam furavin in Jerusalem, tuaa naagu raangis pana nia! Naagu raangis pana nim nanga ma a funalik sinim. ");
INSERT INTO nal_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Avuna a raan iwana maazikang kana wat araan aubina dina piaat malasing kari, ‘A daxaiang kana waan sin a furavin di mala, xawit di iluk, ma xawit dit faazus.’ ");
INSERT INTO nal_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma a Baar Xoxok ka ra piaat malasing kari, ‘Dina piaat sin amun paatawut malasing kari, “Naagu zu wana maam!” Ma dina piaat sin a kaana wut malasing kari, “Naagu pung paramin maam!” ’ ” ");
INSERT INTO nal_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma Iesu xa piaat nanga malasing kari, “Tamon aubina di giu amun saan angkari wana nia ina ga malasing a iaai xa ro nanga, aze ra zaan dina giu wana nim ina naagu malasing a iaai xana maraang?” ");
INSERT INTO nal_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ka rauxin saait uru rapti raksaat, di ra zaxot nandiaa varaxai wana Iesu xuna dina zop famaat nandiaal. ");
INSERT INTO nal_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Araan di balas la non di vakilaan “A Barang,” di tukfating Iesu inaan pana robuxul. Di tukfating saait uru rapti angkanaan pana uru robuxul lapaara Iesu, azaxai la mit sazaxa zina ma axazak la mit kais sina. ");
INSERT INTO nal_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma Iesu xa piaat naako, “Maamaa, naxaam pizin amun matmalabuk taksaat sin naandi, avuna xawit di rexaazin aze razaan naadi gigiu.” Ma di raktaaxin amun faat kuna vatawaraxinang amun marapi zina lawalaua naandi nanga. ");
INSERT INTO nal_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ma aubina di irur rataamin Iesu, singsaxai amun paamua nanga di visfis naan, di piaat malasing kari, “Naan ka ra zuruk pizin amun maravanang sin azanon aubina. Tamon naan a Mesaaia zin Nakmai, axazak ina Nakmai xa ra kalin naan, kana zuruk pizin a maravanang iwana maatang sina nanga.” ");
INSERT INTO nal_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma ubina dauran saait di wat ma di vis naan. Di lis a waain ka mirik sina, ");
INSERT INTO nal_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma di piaat sina malasing kari, “Tamon nua a xalxaal zin amun Judaa, taning guna zuruk pizin a maravanang iwana maatang sunum nanga.” ");
INSERT INTO nal_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma xa rauxin a fararang di ra varaar zaait ma di ra varokin la waat a robuxul zina malasing kari, “Naan kari a Xalxaal zin amun Judaa.” ");
INSERT INTO nal_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma azaxai zin uru rapti raksaat angkanaan ina di rokaai iaa lapaara Iesu, xa dador lingpuak sin Iesu naako, “Tamon nua a Mesaaia, gu vawaal dital xuna dina wen maat taal.” ");
INSERT INTO nal_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Singsaxai aza xazak sin nandiaa xa vadawaar naan naako, “Malasing faa, xawit gu marauring Nakmai? Dital varaxai di vazaak taal a maazikang azaxai. ");
INSERT INTO nal_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ka tak pana diaa, wanaze di vazaak iaa a maravanang iwana amun matmalabuk taksaat sin diaa. Singsaxai a rapti angkari xawit na giu ta matmalabuk taksaat.” ");
INSERT INTO nal_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma xa vazei Iesu naako, “Iesu, gu naxaam nia araan gu balas a xalxaal lamaskana a bikabar zunum.” ");
INSERT INTO nal_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma Iesu xa xis naan naako, “Ga piaat faratunaan sunum, taning nanga guna iziar varaxai wana nia la paaradaais.” ");
INSERT INTO nal_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Araan a marana iaas ka iziar vaatak laaxur, a bungsuzuk ka pung paramin kol a pira vaakdul xa ruaas a marana iaas urul languzaraaf, ");
INSERT INTO nal_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","avuna a iaas kawit na lang. Ma adi marapi batbaat ka ratokaai lamaskana vaal xoxok ka rawagal labirua ma xa balas uwaa tua. ");
INSERT INTO nal_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Naanaan Iesu xa viraai laba naako, “Maamaa, ga lis a laklagai zurugu la mirum.” Naan ka piaat fanong malasing kanaan ma xa maat. ");
INSERT INTO nal_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Araan a waamua zin ubina dauran in Rom ka raamin azaan angkanaan, ka wisfarur Nakmai malasing kari, “Faaratunaan mase, a rapti angkari naan a rapti xa tak.” ");
INSERT INTO nal_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Araan aubina vaakdul ina di wat tur vatu xuna raaminang amun saan angkanaan, di raamin aze razaan ka balas ma di tuk a bangbangana naandi varaxai wana maskaluzang ma di waan. ");
INSERT INTO nal_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Singsaxai amun paasaxo vaakdul zin Iesu, varaxai wana a furavin ina di ra ilos fawat naan ipaa Gaalili, di irur lawalaau vaamumut ma di rataamin amun saan angkanaan kat balas. ");
INSERT INTO nal_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aza rapti aizina Iosep naan in Aarimaatiaa. Aarimaatiaa a bina la pira Judia. Iosep a rapti daxa ma matmalabuk sina xa tak, ma naan kat simbong a bikabar zin Nakmai. Naan azaxai zin ubina iwana aiziarang iwana aikilizang sin amun Judaa, singsaxai xawit na rudaxa varaxai wana naandi wana aze razaan naadi ra nol ma naadi ra giu. ");
INSERT INTO nal_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iosep ka waan sin Paailat ma xa iaari zina xuna xana vazaak luk Iesu. ");
INSERT INTO nal_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Naa zuruk pizin fawat paanaburut, ma naa fluzang a marapi daxa, ma naa vatate lamaskana baaul a maat, ina naadi ra tok tasin lamaskana vaat siar ma xawit nanga di vatate ta maat pana. ");
INSERT INTO nal_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A raan angkanaan a raan a nimnimanang, ma faasilik ka a varumaraiang a raan a Saabat kana balas. ");
INSERT INTO nal_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A furavin ina di ra los fawat Iesu Gaalili, di los Iosep ma di raamin a baaul a maat angkanaan ma di ra raamin di mitat fatete Iesu. ");
INSERT INTO nal_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mur di uli xu lamun faal zin naandi ma di nimnimanin amun wel ma amun saan ina xa milalas mikuf. Ma la raan a Saabat di ziaavus malasing a Lus ka piaat. ");
INSERT INTO nal_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Paanaraan gufguf mase, wana varumaraiang a raan iwana wik, a furavin di zuruk amun saan ka milalas mikuf ina naadi ra nimnimanin tasin ma di waan la baaul a maat. ");
INSERT INTO nal_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Araan di balas di raamin adu axazak ka wul psin fanong a vaat lamarana baaul a maat. ");
INSERT INTO nal_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Singsaxai araan di albis, kawit di tangin a Piran Iesu la non di vatate naan pana. ");
INSERT INTO nal_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma araan di inaxam marazaat nanga wana azaan angkanaan, fazaaus mase uru rapti di mamaaus iaa wana amun marapi xa wilwilak marazaat di balas faaknar iaa ma di rur iaa lapaara naandi. ");
INSERT INTO nal_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Naandi di maraaut mase ma di zivaakudung, a marana naandi xu waanaburut la pira. Ma di vazei iaa naandi malasing kari, “Kunaze naagu zaleng a rapti xa rauxin a roroiang lawalau aubina di maat? ");
INSERT INTO nal_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Naan kawit kaarik na iziar iriat, ka ramaraat puli vaanong. Naagu naxaam faulin a dorang ina naa ra vazei nim pana araan ka iziar nanga varaxai wana nim Gaalili. ");
INSERT INTO nal_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ka piaat naako, ‘Dina lis Naata Rapti la mita ubina raksaat, ma dina tukfating naan pana robuxul, ma wana varulang a raan, naan kana ramaraat puli xaarik.’ ” ");
INSERT INTO nal_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma la notaan angkanaan mase, a furavin angkanaan di naxaam faulin a dorang kanaan sin Iesu. ");
INSERT INTO nal_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Araan di vataling a baaul a maat ma di uli, di piaat amun saan faakdul angkanaan sin a zangaaflu ma azaxai amun aaposal ma xa waan saait sin naandi vaakdul di los Iesu. ");
INSERT INTO nal_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A furavin angkanaan ina di vazei amun aaposal wana amun saan angkanaan, aizina naandi xari: Maaria in Maakdaalaa ma Joaanaa ma Maaria naanaa zin Jems ma azanon furavin nanga varaxai wana nandiaal. ");
INSERT INTO nal_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Singsaxai amun aaposal di naxaam a dorang sin a furavin malasing a dorang palaau be ma xawit di inaxam paazaai wana. ");
INSERT INTO nal_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Singsaxai Pita xa ramaraat ma xa ra valau waan la baaul a maat. Naanaan ka zundung ma xa raamaai waan lamaskana ma xa raamin be uwaan marapi, di imamaal naandi it. Naan ka uli ma xa inaxam marazaat pana amun saan angkanaan ka ra balas. ");
INSERT INTO nal_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","La raan angkanaan nanga, uru rapti varaviraai, di zazangas iaa xu la bina di vakilaan Emaaus. A bina xa lawalaau, a kilomita xa zangaaflu ma azaxai wana Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Araan di zazangas iaa di dador iaa wana amun saan faakdul angkanaan ka ra balas. ");
INSERT INTO nal_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Araan di dador iaa ma dit kulus iaa azaan angkanaan lawalaua nandiaa nanga, Iesu nanga xa wat lapaara nandiaa ma xa zangas faraxai wana nandiaa. ");
INSERT INTO nal_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Singsaxai Nakmai xa waakol a marana nandiaa ma xawit di raamin fakilaan iaa naan. ");
INSERT INTO nal_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Naanaan Iesu xa iaari zin nandiaa naako, “Aze razaan naagut kulus iaa araan naagu zazangas iaa?” Ma di rur manunus iaa ma di raamaai maskalus iaa. ");
INSERT INTO nal_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Azaxai zin nandiaa, aizina xanaan Kleopaas, ka iaari naako, “Iaak nua be a ropuran iriat Jerusalem gu wetexaazin amun saan ka balas lamun taan angkari?” ");
INSERT INTO nal_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma Iesu xa iaari zin nandiaa naako, “Aze ramun saan?” Ma di xis iaa naan malasing kari, “Amun saan pana Iesu in Naazaret, a profet ina amun dorang sina ma vaamuzazang sina xa dikdik lamarana Nakmai ma lamarana aubina vaakdul zaait. ");
INSERT INTO nal_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Amun pris laba ma amun paamua zimaam di rasin naan pana aikilizang kuna xana maat ma di ra tukfating naan pana robuxul. ");
INSERT INTO nal_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Singsaxai maam maadi inaxam paazaai wana naan adu naan axazak kana wul vaxarom amun Israael. Ma naari, a varulang a raan kari wana amun saan ina xa ra balas. ");
INSERT INTO nal_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Taning saait, azanon furavin simaam, di ra vabanglala maam. Paanaraan gufguf mase di waan la baaul a maat, ");
INSERT INTO nal_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ma xawit di tangin Iesu. Ma di uli wat ma di piaat adu di raamin aza rataamaaiang pana uru aangelo ma di vazei iaa naandi adu naan ka roro uli xaarik. ");
INSERT INTO nal_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Naanaan azanon paliaana maam saait di waan la baaul a maat ma di wa raamin amun saan malasing be a furavin di dador wana ma xawit saait di raamin Iesu.” ");
INSERT INTO nal_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma Iesu xa vazei nandiaa naako, “Kunaze xawit naagu maravas iaa ma xawit naagu inaxam paazaai vazaaus iaa wana amun saan faakdul amun profet di ra dador wana? ");
INSERT INTO nal_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Naandi di piaat adu a Mesaaia xana vazaak amun maazikang kari ma mur naan kana albis lamaskana marmari daxaiang sina.” ");
INSERT INTO nal_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iesu xa vamaravaas sin nandiaa, amun saan faakdul di ra varaar vating pana naan nanga lamaskana amun fararang lamaskana a Baar Xoxok, naa varumara wana Moses ma xa ruaas pana amun profet. ");
INSERT INTO nal_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Araan di zazangas paan taal, di wat taal lapaara bina angkanaan nandiaa dina waan iaa wana. Ma Iesu xa zangas malasing adu xana zangas sazal. ");
INSERT INTO nal_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma di maainung falagot iaa naan, malasing kari, “Gu iziar varaxai wana nimaa wanaze a bina xa nguzaraaf ma a iaas ka si vaanong.” Naanaan di zou raal ma naan ka iziar varaxai wana nandiaa. ");
INSERT INTO nal_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Araan di iziar raal wana aiban favanganang, Iesu xa zuruk a raraba ma xa wisfaadaxa wana, ma naa biaak ma xa ralaas nandiaa. ");
INSERT INTO nal_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Naanaan Nakmai xa kaas amun marana nandiaa ma di raamin fakilaan iaa Iesu ma fazaaus mase xa malik siaana nandiaa. ");
INSERT INTO nal_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma di dador iaa lawalaua nandiaa nanga malasing kari, “Faaratunaan mase, araan ka rat famaravaas diaa wana a dorang lamaskana a Baar Xoxok, a maskana diaa xa ramaraat.” ");
INSERT INTO nal_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","La notaan angkanaan nanga, di ramaraat iaa ma di uli vazaaus iaa xun Jerusalem ma di wa tangin iaa azangaaflu ma azaxai ubina varaviraai varaxai wana azanon di ra izi vatu varaxai. ");
INSERT INTO nal_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma di piaat sin nandiaa malasing kari, “Faaratunaan mase! A Piran ka ramaraat puli vaanong ma xa ra balas sin Saaimon.” ");
INSERT INTO nal_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma di xus iaa amun saan faakdul ina xa ra balas sin nandiaa la lan ma araan naan ka ra biaak a raraba, nandiaa di raamin fakilaan iaa naan. ");
INSERT INTO nal_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Araan di rai dador iaa nanga wana amun saan angkanaan, Iesu nanga xa rur labirua wana naandi ma xa piaat naako, “A luaai xana iziar varaxai wana nim.” ");
INSERT INTO nal_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma di raknar ma di maraaut mase wanaze di naxaam adu di raamin a warak. ");
INSERT INTO nal_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma xa vazei naandi naako, “Kunaze naagu maraaut ma naagu rauxin ainaxamang urua? ");
INSERT INTO nal_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Naaguna raamin uru mirugu ma uru xaaku. Nia vaaratunaan kari. Naaguna xaaf a winugu ma naaguna raamin. A warak kawit na rauxin a winpin ma a ruan. Singsaxai naaguna raamin, nia ga rauxin a winugu ma a ruaanugu.” ");
INSERT INTO nal_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Araan ka piaat fanong amun saan angkanaan, ka vatangin uru mitna ma uru xaakna zin naandi. ");
INSERT INTO nal_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma naandi di nanam ma di banglala mase, singsaxai xawit nanga di inaxam paazaai adu naan ka roro uli xaarik. Ma xa iaari zin naandi naako, “Malasing faa, naagu rauxin ta vanganang iriat kuna iaanang?” ");
INSERT INTO nal_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma di ralaas naan pana a vang ian ina naadi ra run. ");
INSERT INTO nal_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Naa zuruk ma naa iaan lamarana naandi. ");
INSERT INTO nal_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma xa vazei naandi naako, “Araan ga ra iziar nanga varaxai wana nim, ga ra vazei nim adu amun saan faakdul di ra varaar wana nia lamaskana amun Lus sin Moses ma lamaskana amun baar zin amun profet ma lamaskana a Baar Saam, kana balas faaratunaan.” ");
INSERT INTO nal_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naanaan Iesu xa kaas ainaxamang sin naandi xuna dina maravas pana amun dorang lamaskana Baar Xoxok. ");
INSERT INTO nal_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ma xa vazei naandi naako, “Di ra varaar vating adu a Mesaaia xana vazaak a maazikang ma xana maat ma wana varulang a raan, naan kana ramaraat puli ziaana maatang. ");
INSERT INTO nal_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma di ra varaar vating saait adu wana aizina, aubina zina dina fazei wana a dorang iwana inaxam taawukang ma naxaam pizinang amun matmalabuk taksaat ka waan sin atavur aubina vaakdul, ma dina varumarain Jerusalem. ");
INSERT INTO nal_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nim aubina xuna pitfiaatang amun saan angkanaan. ");
INSERT INTO nal_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naagu langar, nia gana kling fawat sinim axazak ina Maagu xa ra xalxalin. Singsaxai naaguna iziar iriat la bina laba xa ruaas kana sfaar nim pana a dikdikang inikula laaxur.” ");
INSERT INTO nal_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lamur Iesu xa zaxot luk naandi inaan Jerusalem ma di tukbilak ma di balas lapaara bina Betani, ma xa raxut fauzaa uru mitna ma xa maainung Nakmai xana lis a daxaiang sin naandi. ");
INSERT INTO nal_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Araan kai lis nanga a daxaiang sin naandi, xa vataling naandi ma Nakmai xa zaxot fauzaa naan kunikula la lia. ");
INSERT INTO nal_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma di lotu wana naan ma di uli waan Jerusalem faraxai wana adi nanamang laba. ");
INSERT INTO nal_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma bulaai di iziar lamaskana a rabaraau ila vaal xoxok ma di wisfaru Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mumua pis la varumaraiang mase, a Dorang ka ra iziar vaanong, ma a Dorang ka ra iziar varaxai wana Nakmai, ma a Dorang bani Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Naan bani xa ra iziar varaxai wana Nakmai waamua la varumaraiang mase. ");
INSERT INTO nal_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lamaskana naan Nakmai xa ra vaziaar amun saan faakdul, ma xawit tazaan lamaskana faaziarang kari xawit nat faraxas kana balas sin taxazak tawarak ma taza lan tawarak. ");
INSERT INTO nal_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A Dorang naan a vuvuna roroiang ma a roroiang kanaan kai lis a maravas aaxan aubina. ");
INSERT INTO nal_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma a maravas ka ililap la bungsuzuk singsaxai a bungsuzuk kawit nat faraxas kana waramin naan. ");
INSERT INTO nal_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nakmai xa kling fawat a wangpaang sina, aizina xanaan Jon. ");
INSERT INTO nal_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ka wat kuna dador vaamaravazang pana a maravas angkanaan kuna aubina vaakdul dina inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Naan nanga xawit a maravas, ka wat kuna dador vaamaravazang pana a maravas. ");
INSERT INTO nal_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A maravas faaratunaan angkanaan ina xai lis a maravas aaxan aubina vaakdul, xa kabal wat iriat la pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Naan ka ra iziar la pira angkari, ma naapalaau naan ka ra vaziaar a pira angkari aubina ila pira angkari xawit di raamin fakilaan naan. ");
INSERT INTO nal_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Naan ka wat kun aubina zina vaatak singsaxai aubina zina vaatak kawit di rudaxain naan. ");
INSERT INTO nal_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Singsaxai, naandi di rudaxain naan ma di inaxam paazaai wana aizina, naan ka lis a rudaxaiang kuna balazang a funalik sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kawit di balas a funalik sin Nakmai wana matmalabuk ila pira angkari, o xa malasing kari adu a funalik ma fufnaalik sin amun falambaan o wana sasaxotang sin labana, xawit. Nakmai nanga, naan damana naandi. ");
INSERT INTO nal_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A Dorang ka balas axastunaan ma xa raagul varaxaiang dia. Di raamin fanong a marmari daxaiang sina, a marmari daxaiang sin azaxai be a Nalik ka wat sin Damana, ma naan ka bas pana daxaiang ma dorang faaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ka ra pitfiaat naan, ma xat kupkup dikdik paan sin aubina malasing kari, “Naan a rapti angkari nia ga ra dadorin malasing kari, ‘A rapti angkanaan kana wat la muraagu, xa laaup pana nia wanaze naan ka ra iziar waamua wana nia.’ ” ");
INSERT INTO nal_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","A daxaiang sina aaxan dia xa laba marazaat, malasing ma naan ka rai lis a daxaiang sin dia vaakdul, ma xa ralaas bulin dia wana amun daxaiang. ");
INSERT INTO nal_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Avuna Nakmai xa lis fawat amun Lus ma Moses ka lis sin dia, singsaxai a daxaiang sin Nakmai ma a dorang faaratunaan ka wat lamaskana Iesu Kaarisito aaxan dia. ");
INSERT INTO nal_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kawit nanga taxazak ka ra rataamin Nakmai. Naatna zingbe azaxai naan kat faraxas faraxai wana Nakmai, naan ka iziar la rita Damana ma naan nanga xat famaravaas dia wana Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A dor vaamaravazang sin Jon kari: Amun paamua zin aubina in Jerusalem di ra kling paanin azanon pris ma azanon iaana kilaaiang sin amun pris, di waan sin Jon ma di iaari zina malasing kari, “Nua nis?” ");
INSERT INTO nal_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon kawit na langarin pizin naandi, naan ka vazei vamaravaas naandi malasing kari, “Nia xawit a Mesaaia.” ");
INSERT INTO nal_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma di iaari xaarik sina malasing kari, “Malasing ma nua nis? Ka malasing faa, nua Elaaija a profet i mumua?” Jon ka xis naandi naako, “Kawit nia.” Ma di iaari xaarik sina malasing kari, “Ka malasing faa, nua a profet Nakmai xa xalxal wana?” Ma naan ka xis naandi naako, “Kawit.” ");
INSERT INTO nal_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Malasing ma di piaat sina, “Gu vazei maam nua nis. Maadi saxot maadina zuruk a xizang iwana iaariang sin naandi amun paamua ina di ra kling maam. Gu vazei maam pana nua.” ");
INSERT INTO nal_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ka xis naandi wana dorang sin a profet Aaisaaia malasing kari, “Nia a rapti xa viviraai la non bingil, ‘Naaguna waafatok a lan sin a Piran.’ ” ");
INSERT INTO nal_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma azanon Faarasi, ina amun paamua di kling fawat naandi zin Jon, ");
INSERT INTO nal_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","di iaari zina malasing kari, “Tamon nua xawit a Mesaaia o Elaaija o a profet angkanaan, kunaze gu baaptaais aubina?” ");
INSERT INTO nal_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon ka xis naandi naako, “Nia ga baaptaais aubina wana daanim, singsaxai axazak lawalaua nim, kawit naagu rexaazin naan. ");
INSERT INTO nal_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Naan kana wat lamuraagu, singsaxai nia xawit a rapti daxa xuna xanat faraxas gana akpaat a iaarus iwana su zina, wanaze naan ka laaup marazaat pana nia.” ");
INSERT INTO nal_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Amun saan angkanaan ka balas Betani, laza rita daanim Jodaan, a non Jon ka baaptaais aubina wana. ");
INSERT INTO nal_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","A raan lamuraana, Jon ka raamin Iesu xa zangas puat sina ma xa piaat sin aubina naako, “Naagu raamin, Naata Sipsip sin Nakmai, ina xana zaf pizin amun matmalabuk taksaat sin aubina vaakdul. ");
INSERT INTO nal_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Naan a rapti angkari nia ga dador wana naan sinim araan ga piaat malasing kari, ‘A rapti ina xana wat lamuraagu xa laaup pana nia, wanaze naan ka iziar vaanong paamua wana nia.’ ");
INSERT INTO nal_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Paamua nia nanga xawit ga rexaazin naan, singsaxai a vuvuna watang surugu iriat sinim ka malasing kari, gana baaptaais aubina wana daanim kuna Nakmai xana vatangin naan sin amun Israael.” ");
INSERT INTO nal_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma Jon ka pitfiaat a dor vaamaravazang malasing kari, “Ga raamin a Laklagaai a Raabu xa kabal wat laaxur la lia malasing a baalus ma xa wat iziar wana naan. ");
INSERT INTO nal_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nia nanga xawit ga ra rexaazin naan, singsaxai axazak ina xa kling nia xuna baaptaaizang aubina wana daanim, ka ra vazei nia malasing kari, ‘Guna raamin a rapti a Laklagaai a Raabu xana kabal wat ma xa iziar wana naan. A rapti angkanaan kana baaptaais pana a Laklagaai a Raabu.’ ");
INSERT INTO nal_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ga ra raamin fanong ma ga dador vaamaravas adu naan Naata Nakmai.” ");
INSERT INTO nal_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A raan lamuraana Jon ka irur xaarik faraxai wana uru rapti varaviraai zina inaan. ");
INSERT INTO nal_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Naan ka raamin Iesu xa zazangas bilas, ma xa piaat malasing kari, “Taamin iaa, Naata Sipsip sin Nakmai!” ");
INSERT INTO nal_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Araan uru rapti varaviraai di langarin iaa, di los iaa Iesu. ");
INSERT INTO nal_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu xa rutaawuk ma xa raamin nandiaa di los iaa naan ma xa iaari zin nandiaa naako, “Adu gu saxot iaa aze?” Di piaat iaa, “Raabi.” (Aknaas a waaling malasing, Maravas.) “Gu iziar vaa?” ");
INSERT INTO nal_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma Iesu xa xis nandiaa naako, “Laawus iaa ma naaguna raamin iaa.” Ma di wa raamin iaa a non naa raagul wana ma di vanong iaa a raan angkanaan faraxai wana naan. Ka malasing 4:00 languzaraaf. ");
INSERT INTO nal_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Endru, daaza Saaimon Pita, naan azaxai zin nandiaa xa langarin a dorang sin Jon ma xa los Iesu. ");
INSERT INTO nal_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ma Endru xa tabung tangin daasna, Saaimon ma xa vazei naan malasing kari, “Maadi tangin fanong a Mesaaia.” (Aknaas a waaling angkari, adu Kaarisito.) ");
INSERT INTO nal_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma xa zaxot naan ka waan sin Iesu. Iesu xa raamin naan ma xa piaat sina naako, “Nua Saaimon, naata Jon. Maadina vakilaan nua Sifaas.” (A waaling angkari adu Pita.) ");
INSERT INTO nal_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A raan lamuraana, Iesu xa naxaam kana waan la pira Gaalili. Ka tangin Filip ma xa vazei naan naako, “Laawus, los nia.” ");
INSERT INTO nal_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip naan ila bina laba Betsaaida, a bina zaait sin Pita ma Endru. ");
INSERT INTO nal_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip ka tangin Naatanaael ma xa vazei naan naako, “Maadi tangin fanong axazak Moses ka ra farar wana naan, lamaskana a baar iwana amun Lus, ma amun profet saait di farar wana naan, naan Iesu in Naazaret, naata Iosep.” ");
INSERT INTO nal_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naatanaael xa iaari zina naako, “Naazaret, tazaan daxa xana tukbilak inaan?” Filip ka piaat, “Laawus, ma guna raamin.” ");
INSERT INTO nal_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iesu xa raamin Naatanaael xa wat sina, ma xa piaat pana naan naako, “A rapti angkari, a rapti vaaratunaan in Israael, xawit a vaagitang lamaskana.” ");
INSERT INTO nal_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ma Naatanaael xa iaari zin Iesu naako, “Gu rexaazin nia malasing faa?” Iesu xa xis naan naako, “Araan Filip kawit nanga na viring fawat nua, ga raamin fanong nua lawaana iaai a fik.” ");
INSERT INTO nal_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma Naatanaael xa pitfiaat naako, “Maravas, nua Naata Nakmai, nua a Xalxaal in Israael.” ");
INSERT INTO nal_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu xa piaat sina naako, “Gu inaxam paazaai wana nia, wanaze ga vazei nua adu, ga raamin nua lawaana iaai a fik. Guna raamin azanon saan ka laaup pana naari.” ");
INSERT INTO nal_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Naan ka piaat kaarik malasing kari, “Ga vazei varatunaan mase nim, naaguna raamin a lia xana ralakas ma amun aangelo zin Nakmai dina zangas puzaa laaxur ma dina zangas kabal wat pana Naata Rapti.” ");
INSERT INTO nal_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wana varulang a raan, aubina di giu a flangaana vaamaxuzang la bina laba Kaanaa, ikula la pira Gaalili. Naanaa zin Iesu zaait ka ra iziar inaan, ");
INSERT INTO nal_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ma Iesu varaxai wana ubina varaviraai zina zaait di ra maainung naandi dina wat inaan pana vaamaxuzang, ma di wat. ");
INSERT INTO nal_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Araan aubina di imin fanong a waain, naanaa zin Iesu xa piaat sina naako, “A waain sin naandi xa vaanong.” ");
INSERT INTO nal_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu xa piaat sina naako, “Naang, azaan angkanaan kawit surugu. A raan kuna vaamuzazang surugu xawit nanga na balas.” ");
INSERT INTO nal_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Naanaa zin Iesu xa piaat sin amun iaana kilaaiang naako, “Naaguna valos aze razaan naana vazei nim pana.” ");
INSERT INTO nal_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Amun Judaa, di rauxin a rataawuka zuksukang naandi xuna dina xoxok kaarik lamarana Nakmai. Malasing ma xa rauxin amun pin laba mase di giu wana vaat, ka wizik saaxa iwana werif sivaarang pana daanim ka iziar inaan, naandi zaksaxai dit faraxas dina werif sivaar naandi wana a daanim ka malasing azangaaflu vaa zangaaflu a lita. ");
INSERT INTO nal_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu xa piaat sin amun iaana kilaaiang naako, “Naagu werif sivaar amun pin laba angkari wana daanim.” Ma di werif fambos naandi wana daanim. ");
INSERT INTO nal_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Naanaan ka vazei xaarik naandi naako, “Naari naagu werif luk a daanim inaan ma naagu zuruk lis sin a maimaai iwana flangan.” Naadi giu malasing, ");
INSERT INTO nal_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ma a maimaai iwana flangan ka imin taamin a daanim angkanaan ina xa balas a waain. Naan ka wetexaas pana a waain angkari xa wat faa, singsaxai amun iaana kilaaiang sina ina di ra werif a daanim di rexaas. Naan ka viring luk a rapti angkanaan naadi vamaxuzin, ");
INSERT INTO nal_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma xa piaat sina naako, “Aubina vaakdul di tabung talazin a waain daxa zin amun topuran, ma lamuraana di imin marazaat faanong, di talazin a waain a maraana xa mumut, singsaxai nua gu gonin tasin a waain daxa angkari xa wat tuaas taning.” ");
INSERT INTO nal_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A gigiuang kanaan ina Iesu xa giu ikula la bina laba Kaanaa, la pira Gaalili, naan a varumaraiang iwana amun faakilanang naat fabalos. Amun faakilanang kanaan ka vatangin a marmari daxaiang sina, ma ubina varaviraai zina di inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lamuraana azaan angkanaan, naan ka wizik paanaburut la bina laba Kaapernaaum faraxai wana dina, amun daasna, ma ubina varaviraai zina. Di wa iziar inaan pana a raan kawit na varas. ");
INSERT INTO nal_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A Raan Laba Iwana Zangas Fasaalang faasilik kana balas, ma Iesu xa uzaa Jerusalem. ");
INSERT INTO nal_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lamaskana a rabaraau ila vaal xoxok, ka tangin aubina dit faangurin amun bulumagau ma amun sipsip ma amun baalus, ma azanon di iziar wana amun iban taasmaaiang dit kulxulaai kaakaai. ");
INSERT INTO nal_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Naanaan ka xilong a iaarus ma xa vut pizin naandi vaakdul lamaskana a rabaraau iwana a vaal xoxok, faraxai wana amun sipsip ma amun bulumagau. Naan ka psin farauxin a kaakaai zin aubina dit kulxulaai ma xa wukpizin amun iban taasmaaiang. ");
INSERT INTO nal_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ka piaat sin naandi di vaangurin a baalus naako, “Naagu zuruk pizin amun maani angkari! Tuaa naagu xul a vaal zin Maagu malasing a vaal a vaangurang.” ");
INSERT INTO nal_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ubina varaviraai zina di naxaam faulin kaarik a dorang ila maskana a Baar Xoxok malasing kari, “A maskaagu xa ramaraat faakdul xuna xatkatongang a vaal zunum.” ");
INSERT INTO nal_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Naanaan amun paamua zin amun Judaa di iaari dikdik sina malasing kari, “Aze rawat faakilanang guna vatangin simaam adu nua gu rauxin a burburaaiang kuna giuang amun saan angkanaan?” ");
INSERT INTO nal_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma Iesu xa xis naandi naako, “Tamon naagu bara psin a vaal xoxok angkari, gana giu vaulin pana a raan urul.” ");
INSERT INTO nal_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Amun paamua zin amun Judaa di iaari zina malasing kari, “Ka zuruk a maariaas ka zangaaflu vaaralavaat ma xa wizik saaxa xuna giuang a vaal xoxok angkari ma malasing faa nua be guna giu wana a raan urul?” ");
INSERT INTO nal_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Singsaxai a vaal xoxok naa ra dador wana xari, a winpina nanga. ");
INSERT INTO nal_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Lamuraana naan ka ramaraat puli wana maatang, aubina varaviraai zina di naxaam faulin a dorang naa ra piaat. Ma di inaxam paazaai wana a dorang lamaskana a Baar Xoxok ma a dorang kanaan Iesu xa ra piaat. ");
INSERT INTO nal_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma araan Iesu xa iziar Jerusalem, pana flangan iwana Raan Laba Iwana Zangas Fasaalang, amala aubina di raamin amun faakilanang naat fabalos ma di inaxam paazaai wana aizina. ");
INSERT INTO nal_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Singsaxai Iesu xawit na inaxam paazaai wana naandi, wanaze xa mazaam a rataawuka aubina vaakdul. ");
INSERT INTO nal_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kawit nat faraxas axazak kana xus Iesu wana a matmalabuk sin taxazak, panaze naan ka rexaas faanong pana aze razaan ka iziar lamaskana a roroiang sin axazak. ");
INSERT INTO nal_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ka rauxin aza rapti zin amun Faarasi aizina Nikodimas, naan aza waamua zin amun Judaa. ");
INSERT INTO nal_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ka balas sin Iesu labung ma xa piaat naako, “Maravas, maadi rexaas adu nua a maravas ina Nakmai xa kling fawat. Kawit nat faraxas taxazak kana vabalos amun faakilanang ina nua gu gigiu tamon Nakmai xawit na iziar varaxai wana naan.” ");
INSERT INTO nal_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ma Iesu xa piaat sina naako, “Ga vazei varatunaan mase nua, xawit taxazak kana albis lamaskana a bikabar zin Nakmai tamon kawit di luk favaxur naan.” ");
INSERT INTO nal_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas ka iaari zina naako, “Dina mitai luk mase axazak ka baiak faanong? Faaratunaan, kawit nat faraxas kana varua xaarik auliang la xuna dina, ma dina xana luk favaxur naan.” ");
INSERT INTO nal_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu xa piaat naako, “Ga vazei varatunaan mase nua, tamon axazak kawit di luk naan pana daanim ma a Laklagaai a Raabu, xana wen libis lamaskana a bikabar zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Axazak dina xa luk naan pana matmalabuk sin damana ma dina, naan iwana a roroiang ila winpin, ma tamon a Laklagaai a Raabu xa luk favaxur naan, naan ka rauxin a roroiang pana laklagaaina. ");
INSERT INTO nal_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tuaa gu raknar wana dorang surugu malasing kari, ‘Dina luk favaxur nim.’ ");
INSERT INTO nal_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A maaliu xa taaif pana aze ra non naa saxot. Gu langarin a lingna, singsaxai xawit gu rexaas ka wat malasing faa o xa waa faa. Ka malasing be naandi vaakdul ina di luk favaxur naandi lamaskana a Laklagaai a Raabu.” ");
INSERT INTO nal_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas ka iaari zina naako, “Amun saan angkanaan gu piaat kana balas malasing faa?” ");
INSERT INTO nal_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma Iesu xa piaat naako, “Malasing faa, nua a maravas in Israael, ma xawit gu rexaazin amun saan angkari? ");
INSERT INTO nal_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ga vazei varatunaan mase nua, maadi dador wana aze maadi rexaazin, ma maadi pitfiaat aze maadi raamin singsaxai xawit nanga naagu rudaxain a dor vaamaravazang simaam. ");
INSERT INTO nal_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ga dador vaanong sinim pana amun saan ila pira angkari ma xawit naagu inaxam paazaai wana. Tamon gana dador wana amun saan inikula la lia, naaguna mita inaxam paazaai? ");
INSERT INTO nal_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kawit nanga taxazak ka ra uzaa ikula la lia, Naata Rapti be, ina xa kabal wat la lia. ");
INSERT INTO nal_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses ka raxut fauzaa a laklagaai a zizi wana iaai la bina bingil ma aubina di raamin ma di roro, ma wana a lan angbani, dina raxut fauzaa Naata Rapti, ");
INSERT INTO nal_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","xuna naandi vaakdul ina di inaxam paazaai wana naan, dina rauxin a roro tapal lamaskana naan. ");
INSERT INTO nal_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Avuna Nakmai xa sasaxot aubina vaakdul la pira angkari, malasing ma naan ka lis azaxai be a Nalik sina, xuna nis ka inaxam paazaai wana naan kana wen milung, singsaxai naan kana rauxin a roro tapal. ");
INSERT INTO nal_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Avuna Nakmai xa kling fawat Naatna xunitiat la pira angkari, xawit adu xuna varurang aubina wana dorang, singsaxai xuna naan kana zaxot faulin naandi lamaskana Naatna. ");
INSERT INTO nal_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Axazak ka inaxam paazaai wana Naatna, xawit na irur wana dorang, singsaxai axazak kawit na inaxam paazaai, naan ka irur vaanong pana dorang, panaze xawit na inaxam paazaai wana azaxai be Naata Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A dorang laba iwana aikilizang sin Nakmai xa malasing kari: A maravas ka wat faanong la pira angkari, singsaxai aubina di sasaxot be a bungsuzuk ma xawit di sasaxot a maravas, panaze a matmalabuk sin naandi xa raksaat. ");
INSERT INTO nal_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Naandi vaakdul di gigiu a matmalabuk taksaat, di bain a maravas, ma dina wen puat la maravas panaze di maraaut a matmalabuk taksaat sin naandi xana balas la maravas. ");
INSERT INTO nal_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Singsaxai naandi di gigiu amun saan pana vaaratunaanang, di wat la maravas, kuna xana maravas adu aze razaan naadi giu, naadi giu lamarana Nakmai.” ");
INSERT INTO nal_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Naari lamuraana, Iesu ma ubina varaviraai zina di waan la pira Judia, ma Iesu xa iziar vaamumut faraxai wana naandi wana azanon taan ma xat baaptaais aubina. ");
INSERT INTO nal_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma Jon saait kai baaptaais aubina ikula Aaenon lapaara Saalim, panaze xa rauxin a daanim ka varas la non angkanaan, ma aubina di uwat sina ma xat baaptaais naandi. ");
INSERT INTO nal_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Naari waamua wana Jon di valbis naan lamaskana a vaal a vaamaazikang.) ");
INSERT INTO nal_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A varamangatang ka balas lawalau azanon aubina varaviraai zin Jon ma aza Judaa wana aze rawat tataawuka zuksukang naandi xuna dina xoxok kaarik lamarana Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Di wat sin Jon ma di piaat sina malasing kari, “Maravas, a rapti ina xa ra iziar varaxai wana nua laza non ritita daanim Jodaan, gu ra dador vaamaravas pana naan, naan kai baaptaais ma aubina vaakdul di waan sina.” ");
INSERT INTO nal_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon ka xis naandi naako, “Axazak kana zuruk be aze razaan ka wat la lia ina Nakmai xa lis sina. ");
INSERT INTO nal_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nim nanga naagu ra langarin nia ga dador vaamaravas adu nia xawit a Mesaaia, singsaxai Nakmai xa kling fawat nia waamua wana naan. ");
INSERT INTO nal_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tamon a rapti xa maxus faaxur zin a ravin, a paasaxo zin a rapti xa irut simbang ma xat langar wana a rapti, ma araan ka langarin a linga rapti, naan ka bas mase wana nanamang. A nanamang kanaan ka wat surugu ma xa bas mase. ");
INSERT INTO nal_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Naan mase xana laaup ma nia gana mumut.” ");
INSERT INTO nal_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Naan ina xa wat la lia naan ka laaup pana amun saan faakdul. Axazak ila pira angkari, naan ila pira angkari, ma xai dador wana amun saan ila pira. Axazak ina xa wat la lia xa laaup pana amun saan faakdul. ");
INSERT INTO nal_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Naan kai dador vaamaravas pana aze naa ra raamin ma naa ra langarin, singsaxai xawit taxazak na rudaxain. ");
INSERT INTO nal_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Axazak ina xa rudaxain a dorang sina xa vatangin adu Nakmai naan kat faaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Axazak ina Nakmai xa ra kling fawat, naan kai dador wana amun dorang sin Nakmai, wanaze Nakmai xa ra lis fakdul a Laklagaai a Raabu zina. ");
INSERT INTO nal_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Damana xai sasaxot Naatna ma xa ra lis amun saan faakdul la mitna. ");
INSERT INTO nal_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Axazak ka inaxam paazaai wana Naatna, naan ka rauxin a roro tapal. Singsaxai axazak ka bain Naatna, xana wen tauxin a roroiang, kawit. A boromaazikang sin Nakmai xa iziar wana naan. ");
INSERT INTO nal_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Amun Faarasi di langarin adu aubina xa varas mase di las lamuraana Iesu, ma naandi di balas aubina varaviraai zina, ma xa baaptaais naandi. Aubina varaviraai zin Iesu di varas pana zin Jon. ");
INSERT INTO nal_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Singsaxai Iesu nanga xawit na baaptaais aubina, ubina varaviraai zina dit baaptaais naandi. ");
INSERT INTO nal_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Araan a Piran ka rexaas adu amun Faarasi di langar wana azaan angkanaan, ka luaa a pira Judia ma xa uli xaarik kula pira Gaalili. ");
INSERT INTO nal_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ka los a lan ka waan labirua wana a pira Samaaria. ");
INSERT INTO nal_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma xa balas Samaaria, la bina Sikaar, lapaara vang non pira Jekop ka lis sin naatna Iosep. ");
INSERT INTO nal_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ka rauxin a luka daanim sin Jekop inaan, ma Iesu xa wat siar lapaara luka daanim, panaze a wina xa malumbaai wana xa los a lan baraaf. Ka malasing ka zangaaflu ma urua a marana maknaas lawaanaas. ");
INSERT INTO nal_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Aza ravin Samaaria xa wat kuna werivang a daanim, ma Iesu xa piaat sina naako, “Kat faraxas guna vaimin nia?” ");
INSERT INTO nal_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ubina varaviraai zina di ra waan la bina laba xuna wulwul vanganang.) ");
INSERT INTO nal_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A ravin in Samaaria xa piaat sina naako, “Nua a Judaa, ma nia a ravin Samaaria. Malasing faa gu maainung nia xuna vaiminang nua?” (Avuna amun Judaa xawit di ruvatu varaxai wana amun Samaaria.) ");
INSERT INTO nal_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu xa xis naan naako, “Tamon gu lek texaazin a talazang sin Nakmai, ma nis axazak ka maainung nua xuna vaiminang naan, gu lek maainung naan ma xa lek lis a daanim ka roro zunum.” ");
INSERT INTO nal_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A ravin ka piaat naako, “Piran, kawit gu rauxin tazaan kuna werivang, ma a luka daanim angkari xa duluk. A daanim ka roro, guna zuruk faa? ");
INSERT INTO nal_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Axulmua zin dia Jekop ka ra lis a luka daanim simaam, ma naan nanga naa ra imin pana malasing saait amun naatna ma amun bulumagau ma amun sipsip sina. Iaak nua gu laaup pana axulmua zimaam Jekop aan?” ");
INSERT INTO nal_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu xa xis faulin naan naako, “Naandi vaakdul di imimin a daanim angkari dina maaru xaarik, ");
INSERT INTO nal_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","singsaxai axazak ka imin a daanim gana lis sina xana wen maaru xaarik, kawit. A daanim gana lis sina xana iziar lamaskana ma xana balas malasing a daanim kat fuvuat kuna lizang a roro tapal zina.” ");
INSERT INTO nal_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma a ravin ka vazei Iesu malasing kari, “Piran, gu lis a daanim angkanaan surugu xuna gana wen maaru xaarik, ma gana wen puat bulaai zaait iriat kuna werivang.” ");
INSERT INTO nal_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu xa vazei a ravin naako, “Paan gu zaxot labaam ma naagu uli wat faraxai iaa.” ");
INSERT INTO nal_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A ravin ka piaat naako, “Kawit ga rauxin a rapti.” Iesu xa piaat sina naako, “Gu vaaratunaan araan gu piaat kawit gu rauxin a rapti. ");
INSERT INTO nal_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ka vaaratunaan mase gu rauxin fanong a rapti xa watmit, ma a rapti naari gu iziar varaxai wana naan, kawit labaam. Azaan gu tabung piaat fanong ka vaaratunaan mase.” ");
INSERT INTO nal_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A ravin ka piaat naako, “Piran, ga raamin fakilaan ka adu nua a profet. ");
INSERT INTO nal_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Amun kulmua zimaam di lotu la waatawut angkari, singsaxai nim amun Judaa naagu piaat adu a non iwana lotu xa iziar Jerusalem.” ");
INSERT INTO nal_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu xa piaat sina naako, “Diravin, gu inaxam paazaai wana a dorang kari zurugu, a raan kana wat araan naaguna wen lotu waan sin Maamaa la waatawut angkari o ikula Jerusalem. ");
INSERT INTO nal_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nim amun Samaaria naagu lotu waan sin axazak kawit naagu rexaazin, singsaxai maam amun Judaa maadi lotu waan sin axazak maadi rexaazin, panaze a vaamuzazang iwana zaxot faulinang aubina xa wat sin amun Judaa. ");
INSERT INTO nal_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A raan kana wat ma naari xa balas faanong, araan aubina dit lotu vaaratunaan dina lotu waan sin Maamaa wana laklagaai a naandi ma wana vaaratunaanang. Avuna aubina dit lotu malasing kanaan, Maamaa xai saxot naandi. ");
INSERT INTO nal_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nakmai naan a Laklagai, malasing ma naandi dina lotu waan sina wana laklagaai a naandi ma wana vaaratunaanang.” ");
INSERT INTO nal_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A ravin ka vazei naan naako, “Ga rexaas adu a Mesaaia, di vakilaan naan Kaarisito, xana wat. Ma araan ka wat, naan kana vamaravaas dia wana amun saan faakdul.” ");
INSERT INTO nal_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma Iesu xa piaat sina naako, “Naan bani nia, naari gai dador varaxai wana nua.” ");
INSERT INTO nal_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","La non taan angkanaan ubina varaviraai di uli wat ma di raknar wanaze Iesu xai dador varaxai wana a aza ravin. Singsaxai xawit taxazak sin naandi xa iaari zin a ravin naako, “Gu saxot aze?” Ma xawit di iaari zin Iesu malasing kari, “Kunaze gui dador varaxai wana a ravin angkanaan?” ");
INSERT INTO nal_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A ravin ka luaa adi win laba zina ina naa werif sivaarang a daanim ma xa uli xula bina laba ma xa vazei aubina malasing kari, ");
INSERT INTO nal_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Naagu wat naaguna raamin aza rapti xa vazei viaat nia wana amun saan faakdul ga ra gigiu mumua. Iaak naan bani a Mesaaia?” ");
INSERT INTO nal_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Naanaan di luaa a bina laba ma di zangas puat sin Iesu. ");
INSERT INTO nal_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Araan a ravin ka waan faanong, ubina varaviraai zin Iesu di vazei Iesu malasing kari, “Maravas, gu vangan kalaak.” ");
INSERT INTO nal_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Singsaxai naan ka vazei naandi malasing kari, “Ga rauxin a vanganang nim kawit naagu rexaas pana.” ");
INSERT INTO nal_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma ubina varaviraai zina di dador lawalaua naandi di piaat malasing kari, “Iaak taxazak ka wat talaas fanong naan pana vanganang?” ");
INSERT INTO nal_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Iesu xa piaat sin naandi naako, “A vanganang surugu xari xuna lozang a sasaxotang ma ainaxamang sin axazak ka ra kling fawat nia ma xuna vanongang a vaamuzazang sina. ");
INSERT INTO nal_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","A waan dorang sinim ka uzaa malasing kari, ‘A flan urulavaat ka iziar nanga xuna laflaavang.’ Singsaxai ga vazei nim, naagu kaas amun marana nim ma naagu rataamaai lamaskana amun uma! Auma xa makal vaanong ma xa nimniman kuna laflaavang. ");
INSERT INTO nal_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A rapti xat laflaaf naan ka zuzuruk a wulwulang sina ma xa laflaaf a vanganang kuna roro tapal, malasing ma axazak kat fazu a vanganang ma axazak kat laflaaf nandiaa varaxai dina nanam iaa. ");
INSERT INTO nal_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A dorang kari xa vaaratunaan naako, ‘Azaxai xat faazu ma axazak kat laflaaf.’ ");
INSERT INTO nal_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ga ra kling nim kuna laavang a vanganang lamaskana auma xawit naagu tabung faamuzas pana. Azanon di ra vaamuzas dikdik pana ma nim naagu zuruk a vanganang iwana gutang sin naandi.” ");
INSERT INTO nal_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Amala zin amun Samaaria ila bina laba angkanaan di inaxam paazaai wana Iesu, wanaze di langarin a dorang a ravin ka piaat naako, “Naan ka vazei viaat nia wana amun saan faakdul ga ra gigiu mumua.” ");
INSERT INTO nal_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Malasing ma amun Samaaria di wat sin Iesu, ma di maainung naan kana iziar xalaak faraxai wana naandi, ma naan ka iziar a raan urua. ");
INSERT INTO nal_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma Iesu xa dador zin naandi, ma amala xaarik di inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Di piaat sin a ravin malasing kari, “Kawit maadi inaxam paazaai be wana naan pana aze razaan gu piaat, singsaxai maam nanga maadi langarin fatok saait ma maadi rexaas adu naan a rapti angkari naan faaratunaan a Baraai a Vaaroroiang aaxan aubina vaakdul.” ");
INSERT INTO nal_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Lamuraana a raan urua Iesu xa waan Gaalili. ");
INSERT INTO nal_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Naan nanga xa tabung piaat fanong adu a profet kawit dit pisfaru naan la bina zina vaatak. ");
INSERT INTO nal_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Araan Iesu xa balas Gaalili, di ruzuaai naan. Di ra raamin amun saan faakdul naa ra gigiu Jerusalem, la flangan iwana Raan Laba Iwana Zangas Fasaalang, panaze naandi zaait di ra iziar inaan la raan angkanaan. ");
INSERT INTO nal_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iesu xa uli xaarik Kaanaa la pira Gaalili ina xa ra plaas a daanim ma xa balas a waain. Ka rauxin aza waamua xat faamuzas aaxan a xalxaal, naatna xa itate gigias la bina zina Kaapernaaum. ");
INSERT INTO nal_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Araan a waamua angkanaan ka langar adu Iesu xa luaa a pira Judia ma xa balas faanong Gaalili, naan ka waan sin Iesu ma xa maainung naan kuna xana wat Kaapernaaum ma xana vira naatna, ina faasilik kana maat. ");
INSERT INTO nal_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu xa vazei naan naako, “Tamon kawit naagu raamin amun faakilanang ma amun faaxoxovang ga vabalos, naaguna wen inaxam paazaai.” ");
INSERT INTO nal_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","A waamua xat faamuzas aaxan a xalxaal xa piaat sina naako, “Piran, laawus paamua wana naarugu xana maat.” ");
INSERT INTO nal_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu xa xis naan naako, “Falaau xabe. Naarum kana roro.” A rapti xa inaxam paazaai wana dorang sin Iesu ma xa waan. ");
INSERT INTO nal_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Araan ka wiwizik nanga la lan amun iaana kilaaiang sina di wat fasuin naan pana a dorang adu naatna xa daxa vaanong. ");
INSERT INTO nal_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Araan ka iaari wana aze raraan mase naatna xa daxa uli, di vazei naan malasing kari, “A winlagaf ka luaa naan laraf languzaraaf pana marana iaas azaxai.” ");
INSERT INTO nal_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naanaan, damana xa naxaam luk adu naan a notaan mase xanaan ina naan ka iaari zin Iesu ma Iesu xa ra piaat sina naako, “Naarum kana roro.” Malasing ma naan ma naandi vaakdul la vaal zina di inaxam paazaai wana Iesu. ");
INSERT INTO nal_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Naari a varuaiang a vaakilanang Iesu xa vabalos araan naan ka luaa a pira Judia ma xa balas Gaalili. ");
INSERT INTO nal_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Azanon taan lamur, xa rauxin A Raan Laba zin amun Judaa, malasing ma Iesu xa zangas kunikula Jerusalem. ");
INSERT INTO nal_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Inaan Jerusalem ka rauxin adi mara, aizina adu, “A Mara Zina Sipsip.” A ruru xa iziar lapaarana, aizina wana linga bina Ibru adu Betesdaa, ma a non faraandaa xa watmit ka iziar varaxulin. ");
INSERT INTO nal_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Adi mala zin aubina di gigias di itate inaan, amun marawif ma amun kak taksaat ma naandi di zipas. ");
INSERT INTO nal_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aza rapti xa iziar inaan ma a giazang ka iziar wana naan pana a maariaas ka zangaaflu vaarul ma xa wiziktul vaakdul. ");
INSERT INTO nal_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu xa raamin naan ka itate inaan ma xa rexaas faanong adu naan ka itate vaabung baraaf pana giazang sina, malasing ma Iesu xa iaari zina naako, “Ka malasing faa, gu saxot guna daxa?” ");
INSERT INTO nal_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A rapti xa gias ka piaat naako, “Piran, kawit taku raxazak kuna vawaalang nia xu lamaskana ruru angkari la notaan kana vuvuat kaarik. Nia ga lalaamangaai adu gana wizik lamaskana, singsaxai axazak tawarak ka tabung pizik paamua wana nia.” ");
INSERT INTO nal_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Naanaan Iesu xa vazei naan naako, “Tamaraat, fazaak luk amun saan imilaaivang sunum ma gu waan.” ");
INSERT INTO nal_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Fazaaus mase a winpina rapti xa balas daxa uli, ma xa vazaak luk amun saan imilaaivang sina ma xa zangas. A zaan angkanaan ka balas la raan a Saabat, ");
INSERT INTO nal_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","malasing ma amun paamua zin amun Judaa di vazei a rapti Iesu xa vira naan malasing kari, “Naari a raan a Saabat, ma xawit na tak pana amun Lus sin dia xuna nua guna vazaak amun saan imilaaivang sunum.” ");
INSERT INTO nal_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma naan ka piaat naako, “A rapti xa vira nia, naan ka vazei nia naako, ‘Fazaak luk amun saan imilaaivang sunum ma gu waan.’ ” ");
INSERT INTO nal_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma di iaari zina malasing kari, “Nis a rapti angkanaan ka vazei nua gu vazaak luk amun saan imilaaivang ma gu waan?” ");
INSERT INTO nal_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Singsaxai a rapti angkanaan Iesu xa vira, xawit na rexaas pana nis a rapti angkanaan, panaze adi mala aubina di bas la non angkanaan, ma Iesu xa zangas lawalaua naandi ma xa malik. ");
INSERT INTO nal_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mur Iesu xa tangin naan lamaskana a rabaraau ila vaal xoxok ma xa vazei naan naako, “Gu langar, naari gu daxa vaanong. Gu vaanong ka wana gigiuang a matmalabuk taksaat, taulaan tazaan taksaat mase xana balas sunum.” ");
INSERT INTO nal_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A rapti xa waan ma xa vazei amun paamua zin amun Judaa adu naan Iesu bani ina xa ra vira naan. ");
INSERT INTO nal_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Amun paamua zin amun Judaa di varumara vamazikang Iesu wanaze xa gigiu amun saan angkari laraan a Saabat. ");
INSERT INTO nal_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iesu xa vazei naandi naako, “Maagu xat faamuzas bulaai ma xa ruaas taning, ma nia zaait gat faamuzas.” ");
INSERT INTO nal_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Amun paamua zin amun Judaa di langarin a dorang kanaan ma di saxot mase dina zop famaat Iesu, wanaze xawit be adu naan ka kip a lus ila Saabat, singsaxai naan ka piaat saait adu Nakmai xanaan Damana ma xat fatfaraxazin naan malasing Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iesu xa xis a dorang sin naandi naako, “Ga vazei varatunaan mase nim, Naatna xawit nat faraxas kana giu tazaan naan sing. Naan kat faraxas kana giu be amun saan naa raamin Damana xa gigiu. Avuna aze razaan Damana xa gigiu, Naatna zaait ka gigiu. ");
INSERT INTO nal_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Damana xa sasaxot Naatna ma xat fatangin sina amun saan faakdul naa gigiu. Ma xana vatangin sina amun gigiuang kana laaup nanga wana amun gigiuang kanaan naat fabalos kuna naaguna banglala. ");
INSERT INTO nal_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Damana xat faramaraat amun maat ma xai lis a roroiang sin naandi, malasing saait Naatna xai lis a roroiang sin naandi ina naa saxot naana lis. ");
INSERT INTO nal_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Avuna Damana xawit nai klis taxazak, singsaxai xa lis fakdul a vaamuzazang iwana aikilizang ka waan sin Naatna, ");
INSERT INTO nal_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","xuna naandi vaakdul dina nop Naatna malasing di nop Damana. Axazak kawit na nop Naatna, xawit na nop Damana ina xa ra kling fawat naan.” ");
INSERT INTO nal_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ma Iesu xa piaat sin amun paamua zin amun Judaa naako, “Ga vazei varatunaan mase nim, axazak ina xa valos a dorang surugu ma xa inaxam paazaai wana naan ina xa ra kling fawat nia, xa rauxin a roro tapal ma xana wen irur wana dorang. Naan ka vataling a maatang ma xa albis pana roroiang. ");
INSERT INTO nal_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ga vazei varatunaan mase nim, a raan kana wat ma naari xa balas faanong ma naandi di maat faanong dina langarin a linga Naata Nakmai ma naandi di langarin dina roro. ");
INSERT INTO nal_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Avuna Damana naan a vuvuna roroiang, ma xa lis a burburaaiang sin Naatna xuna naan saait kana vuvuna a roroiang. ");
INSERT INTO nal_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma naan ka lis a burburaaiang iwana aikilizang sin Naatna wanaze naan Naata Rapti. ");
INSERT INTO nal_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tuaa naagu banglala wana azaan angkanaan, panaze a raan kana balas ma aubina vaakdul ina di maat faanong dina langarin a lingna, ");
INSERT INTO nal_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma dina tukbilak la baaul a maat sin naandi. Ma naandi di ra gigiu amun matmalabuk daxa dina ramaraat puli ma dina rauxin a roroiang. Ma naandi di ra gigiu amun matmalabuk taksaat dina ramaraat puli ma dina irur wana dorang ma dina vazaak a maazikang. ");
INSERT INTO nal_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nia nanga xawit gat faraxas gana giu tazaan nia zing. Araan ga ikilis, gat langarin be a dorang sina. Malasing ma a vaamuzazang iwana aikilizang surugu xa tak panaze xawit ga lalaamangaai adu gana giu malasing nia ga saxot, singsaxai ga lalaamangaai adu gana giu xuna vadokdokang axazak ina xa kling fawat nia.” ");
INSERT INTO nal_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ma Iesu xa piaat sin amun paamua zin amun Judaa naako, “Tamon gana dador vaamaravas pana nia nanga, a dorang surugu xana wen maravan pana langlangarang sinim. ");
INSERT INTO nal_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ka rauxin aza xazak kai dador vaamaravas pana nia, ma ga rexaas adu a dorang sina wana nia xa vaaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nim amun paamua zin amun Judaa naagu kling amun iaana kilaaiang sinim ka waan sin Jon ma naan ka dador vaamaravas pana a dorang faaratunaan pana nia. ");
INSERT INTO nal_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kawit adu ga rudaxain a dorang sin aubina wana nia, singsaxai ga piaat a dorang kanaan kuna Nakmai xana zaxot faulin nim. ");
INSERT INTO nal_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ka malasing a laam ka ililap ma xa ilis a maravas, ma wana azanon taan naagu nanam pana a maravas sina. ");
INSERT INTO nal_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nia ga rauxin a dor vaamaravazang ka maravan nanga wana zin Jon. Ka malasing kari: Amun gigiuang Maagu xa lis surugu xuna vanongang ma naari ga gigiu, xa dador vaamaravas adu Maagu xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Maagu ina xa ra kling fawat nia, naan nanga xa ra dador vaamaravas pana nia. Kawit naagu langarin a lingna ma xawit naagu rataamin naan ");
INSERT INTO nal_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ma a dorang sina xawit na iziar lamaskana nim, panaze xawit naagu inaxam paazaai wana axazak naa ra kling fawat. ");
INSERT INTO nal_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Naagu vakot bulin amun dorang lamaskana a Baar Xoxok, panaze naagu naxaam adu wana amun dorang kanaan naaguna zuruk a roro tapal. Naan amun dorang kanaan lamaskana a Baar Xoxok kai dador vaamaravas pana nia. ");
INSERT INTO nal_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Singsaxai xawit naagu saxot naaguna wat surugu xuna zurukang a roroiang. ");
INSERT INTO nal_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kawit ga rudaxain a wisfaaruiang ka wat sin aubina. ");
INSERT INTO nal_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Singsaxai ga rexaazin nim. Ga rexaas adu xawit naagu rauxin a matmalabuk sin Nakmai iwana sasaxotang azanon lamaskana nim. ");
INSERT INTO nal_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ga wat pana aizina Maagu, ma xawit naagu rudaxain nia. Singsaxai tamon taxazak tawarak ka wat pana aizina nanga, naaguna rudaxain naan. ");
INSERT INTO nal_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kawit naagut faraxas naaguna inaxam paazaai wana a dorang surugu, wanaze naagu saxot a wisfaaruiang ka wat lawalaua nim, singsaxai xawit naagu zaleng a wisfaaruiang ina xa wat sin Nakmai azaxai be. ");
INSERT INTO nal_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Singsaxai tuaa naagu naxaam adu nia gana vakor nim lamarana Maagu. Axazak kana vakor nim, naan Moses ina naagu rasin amun inaxamang sinim pana amun dorang sina xuna vawaalang nim. ");
INSERT INTO nal_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tamon naagu lek inaxam paazaai wana Moses, naagu lek inaxam paazaai wana nia, wanaze naan ka tabung farar wana nia. ");
INSERT INTO nal_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Singsaxai tamon kawit naagu inaxam paazaai wana dorang naa varaar naaguna mita inaxam paazaai wana aze ga piaat?” ");
INSERT INTO nal_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Azanon taan lamuraana, Iesu xa kas buak kulaza rita Laman Gaalili, di vakilaan saait pana a Laman Tiberiaas. ");
INSERT INTO nal_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Adi mala aubina di los naan panaze di raamin amun faakilanang Iesu xa vabalos pana viraiang aubina di gias. ");
INSERT INTO nal_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Naanaan Iesu xa uzaa la waatawut ma xa iziar varaxai wana ubina varaviraai zina. ");
INSERT INTO nal_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A raan ka vaasilik ka wana flangan iwana Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu xa raamaai uzaa ma xa raamin amala marazaat di zangas suaai naan. Ma xa iaari zin Filip naako, “Dia dina wul a raraba vaa xuna vanganang aaxan aubina angkari?” ");
INSERT INTO nal_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Naan ka iaari lalaamangaai be zin Filip panaze naan ka rexaas faanong pana aze razaan naana giu. ");
INSERT INTO nal_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip ka xis naan naako, “A zangaaflu varazuai urua amun kaakaai denaarias xawit nat faraxas kuna wulang a raraba xuna lizang sin axazak saksaxai xana iaan ta vang samumut.” ");
INSERT INTO nal_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aza rapti varaviraai zina, Endru, daaza Saaimon Pita, xa piaat sina naako, ");
INSERT INTO nal_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Naari aza nalik ka rauxin a raraba mumut ka watmit di vaaf pana baali, ma a ian mumut urua. Singsaxai xana mitat faraxas pana amala vaakdul?” ");
INSERT INTO nal_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu xa piaat naako, “Naagu vazei aubina dina iziar waanaburut.” Ka rauxin a wilaangis ka varas la non angkanaan, ma ubina vaakdul di iziar, xa malasing a taausan ka watmit. ");
INSERT INTO nal_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iesu xa zuruk amun raraba, ma xa wisfaadaxa zin Nakmai, ma xa ralaas naandi angkanaan di iziar xat faraxas pana sasaxotang sin naandi. Malasing saait naa giu wana uru ian. ");
INSERT INTO nal_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Araan di laanga vangan maazur vaanong, ka piaat sin ubina varaviraai zina naako, “Naagu zuruk fatuin amun kibaala vanganang. Tuaa naagu kawin.” ");
INSERT INTO nal_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Malasing ma di zuruk fatuin amun kibaala raraba baali xa watmit ina naadi vakbaal ma di sfaar amun laxa xat faraxas pana azangaaflu ma urua. ");
INSERT INTO nal_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aubina di raamin a vaakilanang Iesu xa vabalos, ma mur di piaat malasing kari, “Ka vaaratunaan mase, naan a profet ina xana wat la pira angkari.” ");
INSERT INTO nal_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu xa rexaas pana amun inaxamang sin naandi adu dina vangarin naan kana balas a xalxaal, malasing ma xa ramaraat fataling naandi ma naan sing ka uli xaarik kula waatawut. ");
INSERT INTO nal_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lamuraana a iaas ka si, ubina varaviraai zina di waan ipaa la laman, ");
INSERT INTO nal_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ma di xawas pana a mon ma di ikas buaak a laman kuna waanang Kaapernaaum. Naari xa suk ka ma Iesu xawit nanga na balas sin naandi. ");
INSERT INTO nal_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Adi maaliu dikdik ka tangin naandi ma a rof ka varop marazaat. ");
INSERT INTO nal_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Araan di kaaul wana a kilomita xa malasing ka watmit o xa wizik saaxa di raamin Iesu xa uwat kula mon, ka zazangas laaxur wana laman ma di maraaut mase. ");
INSERT INTO nal_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Singsaxai xa piaat sin naandi naako, “Nia be, tuaa naagu maraaut.” ");
INSERT INTO nal_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Naanaan di saxot dina zaxot fawat naan ku lamaskana a mon ma xa xawas, ma fazaaus mase a mon ka xozaraai laxon la non naadina waan pana. ");
INSERT INTO nal_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A raan lamuraana amala ina di iziar la zanon ritit a laman di raamin fakilaan adu a mon be a zaxai xa tabung iziar inaan, ma Iesu xawit na wizik lamaskana varaxai wana ubina varaviraai zina, singsaxai naandi zingbe di waan. ");
INSERT INTO nal_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Naanaan azanon mon ila bina laba Tiberiaas di xozaraai lapaara a bina ina aubina di vangan pana lamuraana a Piran ka wisfaadaxa. ");
INSERT INTO nal_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Araan amala di raamin fakilaan adu Iesu ma ubina varaviraai zina di malik, di xawaas amun mon ma di waan Kaapernaaum kuna zalengang Iesu. ");
INSERT INTO nal_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Araan di tangin naan la aza rita laman, di iaari zina malasing kari, “Maravas, lasang gu balas iriat?” ");
INSERT INTO nal_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu xa xis naandi naako, “Ga vazei varatunaan mase nim, naagu zazaleng nia xawit pana naagu raamin amun faakilanang ga vabalos, singsaxai wanaze naagu iaan amun raraba ma naagu maazur. ");
INSERT INTO nal_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tuaa naagu vaamuzas kuna zurukang a vanganang kana raksaat, kawit, singsaxai naagu vaamuzas kuna zurukang a vanganang kana iziar bulaai ma xana lis a roro tapal, ina Naata Rapti xana lis sinim. Avuna Nakmai Damana xa ra vatangin adu xa rudaxain fanong naan.” ");
INSERT INTO nal_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Naanaan di iaari zina malasing kari, “Aze razaan maadina giu xuna giuang amun faamuzazang Nakmai xa sasaxot.” ");
INSERT INTO nal_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu xa xis naandi naako, “A vaamuzazang sin Nakmai xa malasing kari, naaguna inaxam paazaai wana axazak naa ra kling fawat.” ");
INSERT INTO nal_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Malasing ma di iaari zina malasing kari, “Aze ra vaakilanang guna vabalos kuna maadina raamin ma maadina inaxam paazaai wana nua? Guna giu aze? ");
INSERT INTO nal_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Amun kulmua zimaam di iaan a maanaa la bina bingil, malasing di varaar vanong malasing kari, ‘Naan ka ralaas naandi wana raraba xa wat la lia xuna iaanang.’ ” ");
INSERT INTO nal_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu xa vazei naandi naako, “Ga vazei varatunaan mase nim, kawit Moses ina xa ralaas nim pana a raraba inikula la lia, singsaxai Maagu naan kai lis a raraba vaaratunaan ka wat la lia. ");
INSERT INTO nal_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Avuna a raraba zin Nakmai xari, naan ina xa kabal wat la lia ma xai lis a roroiang sin aubina ila pira angkari.” ");
INSERT INTO nal_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Di piaat malasing kari, “Piran, taning ma xa uzaa, gu lis a raraba angkanaan simaam.” ");
INSERT INTO nal_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Naanaan Iesu xa vazei naandi naako, “Nia nanga a raraba iwana roroiang. Axazak ka wat surugu xana wen lagaai xaarik, ma axazak ka inaxam paazaai wana nia xana wen maaru xaarik. ");
INSERT INTO nal_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Malasing ga vazei vanong nim, naagu raamin fanong nia singsaxai xawit nanga naagu inaxam paazaai. ");
INSERT INTO nal_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Naandi vaakdul Maagu xa lis surugu dina wat surugu, ma axazak ka wat surugu gana wen kup pizin naan, ");
INSERT INTO nal_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","wanaze ga kabal wat la lia xawit kuna lozang a sasaxotang ma a inaxamang surugu nanga singsaxai xuna lozang a sasaxotang ma a inaxamang sina ina xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma naari a sasaxotang ma a inaxamang sina ina xa ra kling fawat nia, adu xawit tazaxai zin naandi vaakdul ina naa lis surugu dina milung, singsaxai gana varamaraat faulin naandi la vaanongang iwana amun taan. ");
INSERT INTO nal_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A sasaxotang ma ainaxamang sin Maagu xa malasing kari, aubina vaakdul ina di raamaai wana Naatna ma di inaxam paazaai wana naan, dina zuruk a roro tapal ma gana varamaraat faulin naandi la vaanongang iwana amun taan.” ");
INSERT INTO nal_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Amun paamua zin amun Judaa di murmuru wana naan panaze xa piaat naako, “Nia a raraba ina xa kabal wat ikula la lia.” ");
INSERT INTO nal_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Di piaat malasing kari, “Naan Iesu bani naata Iosep, ina dina ma damana dia di rexaazin. Kana mitai piaat naako, ‘Ga kabal wat la lia’?” ");
INSERT INTO nal_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu xa xis naandi naako, “Tuaa naagu murmuru lawalaua nim. ");
INSERT INTO nal_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kawit taxazak kat faraxas kana wat surugu, tamon Maagu ina xa ra kling fawat nia, xana wen urif fawat naan ma xana lis naan surugu, ma gana varamaraat faulin naan la vaanongang iwana amun taan. ");
INSERT INTO nal_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Di varaar vating fanong lamaskana a baar zin amun profet malasing kari, ‘Nakmai xana viraai vakdul aubina.’ Naandi vaakdul ina dit langar zin Maagu ma di zuruk a rexaazang ka wat sina, di uwat surugu. ");
INSERT INTO nal_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kawit taxazak na rataamin Maagu. Kawit. Singsaxai axazak ina xa ra iziar varaxai wana Nakmai ma xa wat, naan be xa raamin Maagu. ");
INSERT INTO nal_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ga vazei varatunaan mase nim, axazak ka inaxam paazaai wana nia, naan ka rauxin fanong a roro tapal. ");
INSERT INTO nal_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nia a raraba iwana roroiang. ");
INSERT INTO nal_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Amun kulmua zinim di iaan a maanaa la bina bingil, singsaxai di maat nanga. ");
INSERT INTO nal_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Singsaxai a raraba angkari ina xa wat ikula la lia, aubina dina iaan ma dina wen maat. ");
INSERT INTO nal_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nia nanga a raraba xa roro ina xa kabal wat ikula la lia. Tamon taxazak kana iaan a raraba angkari, xana roro tapal. A raraba angkari a winugu, ina gana lis kuna aubina ila pira angkari dina zuruk a roroiang.” ");
INSERT INTO nal_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Naanaan amun paamua zin amun Judaa di varamakalaai lawalaua naandi nanga ma di piaat malasing kari, “Malasing faa ma a rapti angkari xana lis a wina zin dia xuna iaanang?” ");
INSERT INTO nal_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu xa vazei naandi naako, “Ga vazei varatunaan mase nim, tamon kawit naagu iaan a wina Naata Rapti ma xawit naagu imin a daraaina, naaguna wen tauxin a roroiang lamaskana nim. ");
INSERT INTO nal_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nis nanga xa iaan a winugu ma xa imin a daraaigu xa rauxin a roro tapal, ma gana varamaraat faulin naan pana maatang la vaanongang iwana amun taan. ");
INSERT INTO nal_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A winugu a vanganang faratunaan ma a daraaigu a daanim imiminang faaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nis nanga xa iaan a winugu ma xa imin a daraaigu, maadi zaxai varaxai iaa. ");
INSERT INTO nal_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Maagu xa rauxin a roroiang ka ra kling fawat nia ma naan ka lis a roroiang surugu. Malasing saait axazak ina xa iaan a winugu, gana lis a roroiang sina. ");
INSERT INTO nal_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Naan kanaan a raraba ina xa kabal wat la lia. Amun kulmua zin dia di iaan a maanaa ma di maat nanga, singsaxai axazak ka vangan pana a raraba angkari xana roro tapal.” ");
INSERT INTO nal_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu xa piaat a dorang angkanaan araan kat faraviraai lamaskana a vaal a maainungang sin amun Judaa ikula Kaapernaaum. ");
INSERT INTO nal_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Araan aubina varaviraai di langarin, amala zin naandi di piaat malasing kari, “A varaviraaiang kanaan ka maravan marazaat. Nis mase xat faraxas kana rudaxain?” ");
INSERT INTO nal_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu xa rexaas faanong pana aubina varaviraai zina di murmuru wana a dorang kari, ma xa iaari zin naandi naako, “A dorang kanaan ka kawin a inaxamang sinim? ");
INSERT INTO nal_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma naaguna mita inaxam tamon naagu raamin Naata rapti xa uzaa laaxur xula non paamua naa tabung siziar wana! ");
INSERT INTO nal_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A Laklagaai a Raabu xai lis a roroiang ma a winpina aubina be a zangof. A dorang surugu xa bas pana a Laklagaai a Raabu ma a roroiang. ");
INSERT INTO nal_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Singsaxai xa rauxin azanon sinim kawit di inaxam paazaai.” Ma Iesu xa rexaas faanong paamua nanga wana nis sin naandi xawit di inaxam paazaai ma nis kana ngutlis naan. ");
INSERT INTO nal_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma xa piaat saait naako, “Malasing ma ga vazei nim adu xawit taxazak kana wat surugu tamon Maagu xawit na vainaxaam naandi xuna watang surugu.” ");
INSERT INTO nal_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma laraan angkanaan aubina varaviraai zina di uli ma xawit kaarik di los naan. ");
INSERT INTO nal_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iesu xa iaari zin azangaaflu ma urua ubina varaviraai zina naako, “Naagu saxot saait naaguna waan?” ");
INSERT INTO nal_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saaimon Pita xa xis naan naako, “Piran, maadina waan kaarik sinis? Gu rauxin a dorang kai lis a roro tapal. ");
INSERT INTO nal_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Maadi inaxam paazaai ma maadi rexaas adu nua a Rapti Xoxok gu balas sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Naanaan Iesu xa xis naan naako, “Ga kalin nim, naagu zangaaflu ma urua. Singsaxai nanga azaxai zinim naan a zapalaau!” ");
INSERT INTO nal_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kai piaat be Judaas, naata Saaimon Iskaariot, naan azaxai zin naandi di zangaaflu ma urua ina mur xana ngutlis Iesu. ");
INSERT INTO nal_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lamuraana azaan angkanaan, Iesu xa ra zazangas farawuk inaan Gaalili. Naan kawit na saxot adu xana waan la pira Judia, wanaze amun paamua zin amun Judaa di zazaleng ta lan kuna dina zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A Raan Laba Iwana Amun Faal Maling ka wat faasilik. ");
INSERT INTO nal_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Amun daaza Iesu di ra piaat sina malasing kari, “Gu ramaraat fataling a bina angkari, ma gu waan la pira Judia, xuna aubina varaviraai zunum dina raamin amun gigiuang ina gu gigiu. ");
INSERT INTO nal_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tamon axazak ka saxot adu aubina dina rexaazin naan, tuaa xana iziar vunfun. Nua gu gigiu amun gigiuang kari, malasing ma gu viaat nua zin aubina vaakdul.” ");
INSERT INTO nal_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Avuna xawit taxazak sin naandi amun daaza Iesu di inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Malasing ma Iesu xa vazei naandi naako, “A raan surugu xawit nanga na balas. Singsaxai amun taan faakdul xat faraxas aaxan nim, ");
INSERT INTO nal_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","panaze aubina ila pira angkari dina wen maska raksaat pana nim. Singsaxai di maska raksaat pana nia, wanaze nia gai dador vaamaravas adu amun matmalabuk sin naandi xa raksaat. ");
INSERT INTO nal_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Naagu waan pana A Raan Laba angkanaan. Kawit nat faraxas gana waan, panaze a raan surugu xawit nanga na balas.” ");
INSERT INTO nal_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Naan ka piaat azaan angkanaan ma xa iziar nanga inaan Gaalili. ");
INSERT INTO nal_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Amun daasna di waan pana A Raan Laba, ma mur Iesu zaait ka waan. Singsaxai naan kawit na zangas la maravas, naan ka ra zazangas funfun be. ");
INSERT INTO nal_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Amun paamua zin amun Judaa di ra zazaleng naan inaan pana A Raan Laba, ma di iaari varvaras sin aubina malasing kari, “Naan faa?” ");
INSERT INTO nal_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Amala aubina lawalau axulutung dit ngifngif farawuk pana Iesu. Azanon aubina di piaat malasing kari, “Naan a rapti daxa.” Ma azanon di piaat malasing kari, “Kawit, naan kat fagit amala.” ");
INSERT INTO nal_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Singsaxai xawit taxazak kat faraxas kana dador wana naan la maravas, panaze di maraaut pana amun paamua zin amun Judaa. ");
INSERT INTO nal_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pana varalavaatang a raan iwana A Raan Laba, Iesu xa albis lamaskana a rabaraau ila vaal xoxok ma xat firaai aubina. ");
INSERT INTO nal_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Amun paamua zin amun Judaa di banglala ma di iaari malasing kari, “A rapti angkari xawit na waan pana ta varaviraaiang ma xa zuruk a rexaazang kari vaa?” ");
INSERT INTO nal_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu xa xis naandi naako, “Amun faraviraaiang surugu xawit surugu nanga, singsaxai xa wat ikula zin axazak ina xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tamon taxazak ka saxot kana giu azaan Nakmai xa saxot, naan kana raamin fakilaan tamon nia ga varaviraai wana a dorang ka wat ikula zin Nakmai, o tamon ga dador wana ainaxamang surugu nanga. ");
INSERT INTO nal_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Araan axazak ka dador wana inaxamang sina nanga, naan ka malasing adu xa valaup naan nanga. Araan axazak ka saxot kana valaup axazak ka ra kling fawat naan, naan ka piaat a dorang faaratunaan ma xawit ta vaagitang ka iziar zina. ");
INSERT INTO nal_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ka ra lis amun Lus sinim. Singsaxai xawit tazaxai zinim kat falos amun Lus angkanaan. Kunaze naagu saxot naaguna zop famaat nia?” ");
INSERT INTO nal_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma aubina di piaat malasing kari, “A zapalaau xa ragul nua! Nis kari xa saxot kana zop famaat nua?” ");
INSERT INTO nal_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ma Iesu xa xis naandi malasing kari, “Ga ra giu aza vaamuzazang ka banglala ma nim faakdul naagu ra banglala. ");
INSERT INTO nal_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ka ra fararin adu naaguna ftuk pizin a vang pakpaak amun popo rapti zinim. Kawit Moses, singsaxai amun kulmua zinim, naandi di ra varumarain a matmalabuk angkanaan. Azanon taan naagu iftuk pizin a vang pakpaak amun popo rapti la Saabat. ");
INSERT INTO nal_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tamon a raan kuna ftuk pizinang a vang pakpaak amun popo rapti xana balas la raan a Saabat, naagu ftuk pizin nanga xuna naaguna wen laxau amun Lus sin Moses. Malasing ma xunaze naagu mangat pana nia wana ga vira a rapti laraan a Saabat? ");
INSERT INTO nal_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tuaa naagu klis amun saan pana a rataamaaiang ilamanar, singsaxai naagu klis pana ainaxamang ka tak.” ");
INSERT INTO nal_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","La raan angkanaan azanon aubina in Jerusalem di varumara iaariang malasing kari, “Iaak naan a rapti xari ina amun paamua di saxot dina zop famaat naan? ");
INSERT INTO nal_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Naan kari, xai dador la maravas. Ma xawit taxazak ka pukling sina. Iaak amun paamua di rexaas adu naan a Mesaaia? ");
INSERT INTO nal_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Singsaxai araan a Mesaaia xana wat, kawit taxazak kana rexaas adu naan ka wat faa. Singsaxai dia di rexaazin a rapti angkari xa wat faa.” ");
INSERT INTO nal_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ma Iesu xat faraviraai la rabaraau ila vaal xoxok. Naanaan ka dador laba malasing kari, “Ka vaaratunaan nim naagu rexaazin nia, ma naagu rexaazin nia ga wat faa. Singsaxai xawit ga wat pana ainaxamang surugu nanga. Axazak angkanaan ka ra kling fawat nia, naan kat faaratunaan. Ma nim naagu wetexaazin naan. ");
INSERT INTO nal_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Singsaxai nia ga rexaazin naan, panaze nia ga kabal wat ikula zina ma naan ka ra kling fawat nia.” ");
INSERT INTO nal_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Malasing ma di saxot dina zaraak fating naan, singsaxai xawit taxazak na taaxur wana naan, panaze a raan sina xawit nanga na balas. ");
INSERT INTO nal_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Singsaxai amala aubina lawalau axulutung di ra inaxam paazaai wana naan. Di piaat malasing kari, “A rapti angkari xat fabalos amun faakilanang ka laaup marazaat. Araan a Mesaaia xana wat, malasing faa, naan kana vabalos amun faakilanang ka laaup pana zina.” ");
INSERT INTO nal_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Amun Faarasi di langarin aubina dit ngifngif pana Iesu ma a dorang naa ra piaat sin naandi. Ma naandi varaxai wana amun pris laba di kling azanon tuxaaul ila vaal xoxok di waan sin Iesu xuna dina zaraak fating naan. Ma di waan. ");
INSERT INTO nal_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iesu xa piaat naako, “Gana iziar vaamumut be varaxai wana nim ma mur gana waan sin axazak ka ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Naaguna zaleng nia, singsaxai naaguna wen tangin luk nia. Ma a non nia gana iziar wana, nim kawit nat faraxas naaguna waan pana.” ");
INSERT INTO nal_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Amun paamua zin amun Judaa di dador lawalaua naandi malasing kari, “Kana waa faa ma xawit dit faraxas dina tangin luk naan. Iaak naan kana waan mase laza bina zin amun Grik, ina amun Judaa di ra raagul wana ma naan kana viraai amun Grik? ");
INSERT INTO nal_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Naan ka piaat naako, ‘Naaguna zaleng nia singsaxai naaguna wen tangin luk nia.’ Ma naan ka piaat saait naako, ‘Nim kawit nat faraxas naaguna waan la non nia gana waan pana.’ Aze ra vuvuna dorang kari?” ");
INSERT INTO nal_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","La adi raan laba mase xuna vanongang a Raan Laba angkanaan, Iesu xa rur ma xa xupkup dikdik malasing kari, “Tamon taxazak inaan ka maaru, naan kana wat surugu ma xana imin. ");
INSERT INTO nal_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tamon axazak ka inaxam paazaai wana nia, a Baar Xoxok ka piaat naako, ‘A daanim kai lis a roroiang kana zaal wat lamaskana roroiang sina xu lamanar.’ ” ");
INSERT INTO nal_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu xa piaat azaan angkanaan lalozang a Laklagaai a Raabu. Naandi ina di ra inaxam paazaai wana Iesu, mur dina rauxin. Lamun taan angkanaan Nakmai xawit nanga na lis a Laklagaai a Raabu, wanaze Nakmai xawit nanga na lis a marmari daxaiang sin Iesu. ");
INSERT INTO nal_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Amala zin naandi aubina lamaskana a xulutung angkanaan di langarin Iesu xa ra piaat a dorang sina ma di piaat malasing kari, “Ka varatunaan mase a rapti angkari, naan a profet, Moses ka ra dador profet pana naan.” ");
INSERT INTO nal_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma azanon di piaat malasing kari, “Naan a Mesaaia.” Singsaxai azanon tawarak di piaat malasing kari, “A Mesaaia xawit aro Gaalili. ");
INSERT INTO nal_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","A Baar Xoxok ka piaat adu a Mesaaia xana balas pana amun natnaat sin Dewit, ma dina luk naan Betliem, a bina Dewit ka ra raagul wana.” ");
INSERT INTO nal_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Malasing ma aubina di vatawagalaai lalozang Iesu. ");
INSERT INTO nal_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Azanon di ra saxot adu dina zaraak fating naan, singsaxai xawit taxazak na taaxur wana naan. ");
INSERT INTO nal_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Amun tuxaaul ila vaal xoxok di uli waan sin amun pris laba ma amun Faarasi. Ma amun pris laba varaxai wana amun Faarasi di iaari malasing kari, “Kunaze xawit naagu zaxot fawat naan iriat?” ");
INSERT INTO nal_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma amun tuxaaul ila vaal xoxok di piaat malasing kari, “Kawit taxazak nai dador wana a dorang ka maravan malasing a rapti angkanaan.” ");
INSERT INTO nal_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma amun Faarasi di iaari malasing kari, “Malasing faa, xa vagit saait nim? ");
INSERT INTO nal_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Malasing faa, tazaxai zin amun paamua zin amun Judaa o amun Faarasi di inaxam paazaai wana naan? ");
INSERT INTO nal_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kawit mase! Amala angkanaan kawit di rexaazin amun Lus, ma a raksaatang ka iziar wana naandi.” ");
INSERT INTO nal_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas naan azaxai zin amun paamua, ina waamua xa ra wat sin Iesu, xa piaat sin naandi naako, ");
INSERT INTO nal_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Lamaskana amun Lus sin dia dina wen famazik axazak, ka ruaas a raan di langarin fanong a dorang sina, xuna tanginang aze naa ra gigiu.” ");
INSERT INTO nal_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Di mangat ma di xis naan malasing kari, “Iaak nua zaait a rapti in Gaalili? Gu raamaai daxa lamaskana a Baar Xoxok ma guna maravas adu xawit ta profet laba inaan, aro Gaalili.” ");
INSERT INTO nal_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Naanaan naandi vaakdul di vatawagalaai ma di waan lamun faal zin naandi. ");
INSERT INTO nal_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Singsaxai Iesu xa waan la Waatawut Olif. ");
INSERT INTO nal_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma paanaraan gufguf laraan lamuraana, naan ka waan la rabaraau ila vaal xoxok. Ma aubina vaakdul di wat faraxulin naan, ma naan ka iziar waanaburut ma xat firaai naandi. ");
INSERT INTO nal_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma amun maravas iwana amun Lus sin Moses faraxai wana amun Faarasi di zaxot falbis aza ravin, di tangin naan ka milivin a rapti rawarak ma di varur naan lamarana naandi vaakdul. ");
INSERT INTO nal_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Di vazei Iesu malasing kari, “Maravas, a ravin angkari, maadi tangin naan ka milivin a rapti rawarak. ");
INSERT INTO nal_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Amun Lus sin Moses ka lis a dorang dikdik adu awat tavin ka gigiu a matmalabuk angkari, dina tuk famaat naan pana amun faat. Aze ra dorang sunum pana a matmalabuk angkari?” ");
INSERT INTO nal_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Di piaat malasing kanaan kuna lalaamangaainang Iesu xuna dina vakor naan. Singsaxai Iesu xa zundung ma xa farar waanaburut pana pira wana klus mitna. ");
INSERT INTO nal_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Di iru inaan ma di iaari vaararaa zin Iesu, ma naan ka ru vaatak ma xa piaat sin naandi naako, “Tamon taxazak sinim kawit nanga na gigiu ta matmalabuk taksaat, naan kana zuruk a vaat ma xana tabung tuk a ravin angkari.” ");
INSERT INTO nal_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ma naan ka zundung ma xa farar xaarik paanaburut pana pira. ");
INSERT INTO nal_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Araan di langarin, di ramaraat ma di zangas saksaxai waan siaana a non angkanaan, amun takpiwiran kalaak, ma lamur xa Iesu zingbe xa varaxai wana a ravin ka irur nanga inaan. ");
INSERT INTO nal_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu xa ru vaatak ma xa iaari zina naako, “Diravin, naandi vaa xa? Ka malasing faa, taxazak nanga naan ka iziar xuna varurang nua wana a dorang kuna vazaakang a maazikang?” ");
INSERT INTO nal_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma a ravin angkanaan ka piaat sina naako, “Piran, kawit taxazak.” Ma Iesu xa piaat sina naako, “Nia zaait gana wen farur nua wana dorang kuna guna vazaak a maazikang. Gu waan, singsaxai tuaa xaarik gu giu ta matmalabuk taksaat.” ");
INSERT INTO nal_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ma Iesu xa dador xaarik sin aubina naako, “Nia a maravas sin aubina ila pira angkari. Tamon axazak kana los nia, naan kana rauxin a maravas iwana roroiang, ma xana wen sangas la bungsuzuk.” ");
INSERT INTO nal_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma amun Faarasi di piaat sina malasing kari, “Nua gu dador vaamaravas pana nua nanga, malasing ma a dorang sunum kawit na vaaratunaan.” ");
INSERT INTO nal_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu xa xis naandi malasing kari, “Naapalaau tamon ga dador vaamaravas pana nia nanga, a dorang surugu xa vaaratunaan, panaze ga rexaazin a non nia ga ramaraat pana ma a non gana waan pana. Singsaxai nim kawit naagu rexaazin a non nia ga ramaraat pana ma a non nia gana waan pana. ");
INSERT INTO nal_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nim naagu klis aubina wana ainaxamang ila pira angkari, singsaxai nia xawit gai klis a matmalabuk sin taxazak. ");
INSERT INTO nal_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Singsaxai tamon nia ga klis a matmalabuk sin taxazak, a dorang surugu xa vaaratunaan, panaze xawit nia zingbe. Nia varaxai wana Maagu ina xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lamaskana amun Lus sinim di ra varaar vating adu tamon axazak urua dina rudaxa iaa wana a dorang, a dorang kanaan ka vaaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nia gai dador vaamaravas pana nia nanga, ma Maagu zaait ina xa ra kling fawat nia, naan kai dador vaamaravas saait pana nia.” ");
INSERT INTO nal_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Naandi di iaari zina malasing kari, “Naan damaam faa?” Ma Iesu xa piaat naako, “Naagu wetexaazin nia o Maagu. Tamon naagu lek texaazin nia, naagu lek texaazin saait Maagu.” ");
INSERT INTO nal_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu xa piaat a dorang kanaan laraan naan kat firaai aubina lamaskana a rabaraau ila vaal xoxok, la non di ratasin amun talazang sin Nakmai wana. Singsaxai xawit taxazak na zaraak naan, panaze a raan sina xawit nanga na balas. ");
INSERT INTO nal_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu xa piaat kaarik sin naandi naako, “Gana waan fataling nim, ma naaguna zaleng nia, singsaxai naaguna maat ma amun matmalabuk taksaat sinim kana iziar nanga. Kawit nat faraxas naaguna waan la non nia gana waan pana.” ");
INSERT INTO nal_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Amun paamua zin amun Judaa di piaat sin naandi nanga malasing kari, “Naan ka piaat adu dia xawit dit faraxas dina waan la non angkanaan naan kana waan pana. Aze ra vuvuna dorang kari? Iaak naako xana zop famaat naan nanga?” ");
INSERT INTO nal_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu xa xis naandi malasing kari, “Nim aubina i waanaburut ma nia i laaxur. Nim aubina ila pira angkari singsaxai nia xawit ila pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Malasing ma ga vazei nim adu naaguna maat ma amun matmalabuk taksaat sinim kana iziar nanga. Avuna tamon naaguna wen inaxam paazaai wana nia adu nia axazak angkanaan ga dadorin, ka vaaratunaan naaguna maat ma amun matmalabuk taksaat sinim kana iziar nanga.” ");
INSERT INTO nal_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ma di iaari zina malasing kari, “Nua nis?” Iesu xa xis naandi naako, “Nia axazak angkanaan ga ra dadorin sinim mumua nanga ma xa ruaas taning. ");
INSERT INTO nal_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ga rauxin a dorang ka varas kuna klizang nim pana. Axazak angkanaan ka ra kling fawat nia iriat, naan kai dador vaaratunaan ma amun dorang kanaan ga langarin naan kai piaat, gai fazei wana zin aubina ila pira angkari.” ");
INSERT INTO nal_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Naandi xawit di mazaam adu Iesu xa dador zin naandi wana Damana. ");
INSERT INTO nal_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Malasing ma Iesu xa vazei naandi naako, “Araan naagu raxut fauzaa Naata Rapti laaxur, naaguna rexaas ka adu Nia axazak angkanaan ga dadorin, ma naaguna rexaas ka adu nia xawit ga gigiu amun saan pana ainaxamang surugu nanga, singsaxai ga dadorin be amun dorang Maagu xa viraai nia. ");
INSERT INTO nal_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma axazak ina xa ra kling fawat nia, naan ka iziar varaxai wana nia. Kawit na luaa nia zing panaze nia ga gigiu bulin amun saan kat fananam naan.” ");
INSERT INTO nal_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iesu xai fazei wana a dorang kanaan ma amala di inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Malasing ma Iesu xa piaat sin amun Judaa ina di inaxam paazaai wana naan naako, “Tamon naaguna roting falagot amun faraviraaiang surugu, nim aubina varaviraai mase zurugu. ");
INSERT INTO nal_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Malasing ma naaguna rexaazin a dorang faaratunaan, ma a dorang kanaan kana vamamaraxaas nim.” ");
INSERT INTO nal_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ma di piaat malasing kari, “Aabaraam naan a xulmua zimaam, ma xawit nanga ta raan maadi iziar malasing amun iaana kilaaiang sin taxazak. Aze ra vuvuna a dorang kanaan sunum gu fazei wana, adu maadina mamaraxas?” ");
INSERT INTO nal_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu xa piaat sin naandi naako, “Ga vazei varatunaan mase nim. Tamon axazak ka gigiu amun matmalabuk taksaat, naan a iaana kilaaiang sin amun matmalabuk taksaat. ");
INSERT INTO nal_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A iaana kilaaiang naan kawit azaxai lamaskana aiziarang sin amun fatama. Singsaxai a nalik ka iziar bulaai lamaskana aizi vatamaiang. ");
INSERT INTO nal_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Malasing ma tamon Naatna xa vamamaraxaas nim, nim naaguna mamaraxas faaratunaan mase. ");
INSERT INTO nal_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ga rexaas adu Aabaraam a xulmua zinim. Singsaxai nim nanga naagu zazaleng a lan kuna zop famaatang nia wanaze amun dorang surugu xawit na iziar lamaskana nim. ");
INSERT INTO nal_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Gai dador wana amun saan ga raamin sin Maagu, singsaxai nim naagu gigiu amun saan naagu langarin sin damana nim.” ");
INSERT INTO nal_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Di piaat sina malasing kari, “Damana maam kari Aabaraam.” Ma Iesu xa xis naandi malasing kari, “Tamon nim a funalik faaratunaan sin Aabaraam, naaguna giu amun faamuzazang malasing be Aabaraam ka gigiu. ");
INSERT INTO nal_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nia ga fazei be wana amun dorang faaratunaan ga langarin sin Nakmai ma naagu zazaleng a lan kuna zop famaatang nia. Aabaraam kawit na giu amun saan malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nim naagu giu amun saan damana nim ka gigiu.” Di piaat malasing kari, “Maam kawit a funalik ila waana vinaabi. Nakmai zingbe naan damana maam.” ");
INSERT INTO nal_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu xa piaat sin naandi naako, “Tamon Nakmai naan damana nim, naaguna sasaxot nia wanaze nia ga wat sin Nakmai. Kawit ga wat pana ainaxamang surugu nanga, singsaxai Nakmai xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kunaze naagu wen mazaam a dorang surugu? A vuvuna xa malasing kari, xawit naagut faraxas naaguna rudaxain amun dorang surugu. ");
INSERT INTO nal_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nim a funalik sin damana nim Saatan. Ma naagu saxot adu naaguna las lamuraana amun sasaxotang sin damana nim. Ka ramaraat nanga la varumaraiang, naan a rapti xa zopsop famaat palau aubina. Ma naan kawit na irur wana vaaratunaanang panaze xawit ta vaaratunaanang lamaskana. Tamon naan ka rategit, naan ka gigiu be amun saan nat faraxas pana, wanaze naan a rapti iwana vaagitang ma naan damana vaagitang. ");
INSERT INTO nal_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nia nanga gai piaat a vaaratunaanang, malasing ma xawit naagu inaxam paazaai wana nia. ");
INSERT INTO nal_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kawit taxazak sinim kat faraxas kana vatangin adu nia ga ra giu a matmalabuk taksaat. Tamon ga dor vaaratunaan, kunaze xawit naagu inaxam paazaai wana nia? ");
INSERT INTO nal_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Axazak sin Nakmai, naan kat langarin amun dorang sin Nakmai. Nim kawit naagut langarin amun dorang sin Nakmai wanaze nim kawit sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Amun Judaa di piaat sin Iesu malasing kari, “Maadi piaat fatok adu nua a rapti in Samaaria a zapalaau xa ragul nua.” ");
INSERT INTO nal_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu xa xis naandi malasing kari, “A zapalaau xawit na ragul nia, wanaze nia ga valaup aizina Maagu, singsaxai nim naagu wispiaal aizinugu. ");
INSERT INTO nal_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kawit ga zazaleng ta lan kuna aubina dina valaup aizinugu. Singsaxai axazak ka saxot adu aubina dina valaup aizinugu, ma naan bani a rapti xai kilis. ");
INSERT INTO nal_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ga vazei varatunaan mase nim. Tamon axazak ka valos a dorang surugu, naan kana wen maat.” ");
INSERT INTO nal_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Amun Judaa di piaat sina malasing kari, “Naari maadi rexaas adu a zapalaau xa ragul nua. Aabaraam ka maat, ma amun profet saait di maat, ma nua gu piaat adu, axazak ina xa valos a dorang sunum kana wen maat. ");
INSERT INTO nal_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Damana maam Aabaraam ka maat ma amun profet saait di maat. Malasing faa, nua gu laaup pana Aabaraam? Gu naxaam adu nua mase nis?” ");
INSERT INTO nal_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu xa xis naandi malasing kari, “Tamon ga valaup nia nanga, a gigiuang kanaan ka zaan palaau. Singsaxai Maagu xat falaup nia. Nim naagu kalin adu naan Nakmai zinim. ");
INSERT INTO nal_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nim nanga xawit naagu rexaazin naan singsaxai nia ga rexaazin naan. Tamon ga lek piaat adu xawit ga rexaazin naan, nia a rapti xa rategit, malasing be nim. Singsaxai nia ga rexaazin naan, ma gat falos a dorang sina. ");
INSERT INTO nal_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Damana nim Aabaraam ka ra nanam adu naan kana raamin a raan surugu, naa raamin ma xa nanam.” ");
INSERT INTO nal_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Amun Judaa di piaat sina malasing kari, “A maariaas sunum kawit nanga na zangaaflu vaawatmit, ma xunaze gu piaat adu nua gu ra raamin Aabaraam?” ");
INSERT INTO nal_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu xa xis naandi malasing kari, “Ga vazei varatunaan mase nim. Paamua wana Aabaraam di luk naan, nia ga iziar.” ");
INSERT INTO nal_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Araan di langarin, di iot amun faat kuna tukang Iesu, singsaxai naan ka zangas fun naan nanga lamaskana a xulutung ma xa waan fataling a rabaraau ila vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Araan Iesu xa zazangas pizik, ka raamin a rapti xa marawif, ka marawif nanga araan di luk naan. ");
INSERT INTO nal_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ubina varaviraai zin Iesu di iaari zina malasing kari, “Maravas, nis ka giu a matmalabuk taksaat ma di luk naan ka marawif, a rapti angkari o damana ma dina?” ");
INSERT INTO nal_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu xa xis naandi naako, “Kawit a rapti angkari o damana ma dina di giu amun matmalabuk ka raksaat, singsaxai azaan angkanaan ka balas kuna dina raamin fakilaan a vaamuzazang sin Nakmai xana vaatangaai wana roroiang sina. ");
INSERT INTO nal_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Araan ka maravas nanga, dia dina giu amun faamuzazang sin axazak ka ra kling fawat nia. A suk kana wat ma xawit taxazak kana vaamuzas. ");
INSERT INTO nal_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Araan ga iziar la pira angkari, nia a maravas sin aubina ila pira angkari.” ");
INSERT INTO nal_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ma xa piaat fanong azaan angkanaan, ka kaanis pana pira, xa vamidaus a pira wana a kaanis sina ma naa rasin lamarana a marawif. ");
INSERT INTO nal_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Naan ka vazei a marawif naako, “Paan, gu izuf la ruru Siloaam.” (Aknaaza waaling Siloaam adu “Kling.”) A marawif ka waan ma xa izuf, ma xa uli wat faraxai wana uru marana xa ralakas faanong. ");
INSERT INTO nal_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Amun paliaana ma naandi ina waamua di rataamin naan kat nungnung, di iaari malasing kari, “Iaak naan a rapti angbari ina xat siziar ma xat nungnung bulaai?” ");
INSERT INTO nal_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Azanon di piaat adu naan bani. Ma uzanon di wispuk malasing kari, “Kawit, ka raamaai be malasing naan.” Singsaxai naan nanga xa piaat fadikdik naako, “Nia be a rapti angkanaan.” ");
INSERT INTO nal_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Di iaari zina malasing kari, “Malasing faa ma a maraam ka ralakas?” ");
INSERT INTO nal_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naan ka xis naandi naako, “A rapti di vakilaanang Iesu xa kanis a pira, naa vamidaus ma naa rasin la maraagu. Ka vazei nia gana waan ma gana izuf la ruru Siloaam. Malasing ma ga waan ma ga izuf ma naari ga raamaai xa.” ");
INSERT INTO nal_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Di iaari zina malasing kari, “Naan a rapti vaa?” Ma naan ka piaat naako, “Kawit ga rexaas.” ");
INSERT INTO nal_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Di zaxot a rapti ina xa ra marawif ma di lis naan sin amun Faarasi ");
INSERT INTO nal_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ma a raan angkanaan a raan a Saabat ina Iesu xa kanis famidaus a pira ma naa pa ma naa rasin lamarana a rapti ma a marana xa ralakas. ");
INSERT INTO nal_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Malasing ma amun Faarasi di iaari xaarik sina wana adu a marana xa mitat balas daxa. A rapti xa xis naandi naako, “Naan ka rasin a pira xa midaaus la maraagu ma ga izuf ma naari ga raamaai xa.” ");
INSERT INTO nal_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Azanon Faarasi di piaat malasing kari, “A rapti angkanaan kawit na wat sin Nakmai wanaze xawit nat falos amun lus ila Saabat.” Singsaxai uzanon di iaari malasing kari, “Ka malasing faa a rapti raksaat kat fabalos amun faakilanang?” Ma di vatawagalaai. ");
INSERT INTO nal_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lamuraana, di iaari xaarik sin a marawif malasing kari, “Guna piaat aze wana naan? Avuna naan ka varalakaas a maraam.” A rapti xa xis naandi naako, “Naan a profet.” ");
INSERT INTO nal_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Amun paamua zin amun Judaa xawit nanga di inaxam paazaai adu naan ka ra marawif ma xa raamaai xaarik, malasing ma di kilaai xun damana ma dina. ");
INSERT INTO nal_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Di iaari zin nandiaa malasing kari, “Naan naata numaa xari ina di luk naan ka marawif ma xa malasing faa ma naan ka raamaai?” ");
INSERT INTO nal_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Damana ma dina di xis naandi malasing kari, “Maadi rexaas iaa adu naan naata nimaa ma maadi rexaas iaa di luk naan ka marawif. ");
INSERT INTO nal_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Singsaxai malasing faa xa raamaai vaanong o nis ka varalakaas a marana, xawit maadi rexaas. Naagu iaari zina. Naan ka laba vaanong, naan kana dador wana naan nanga.” ");
INSERT INTO nal_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Damana ma dina di piaat malasing kanaan panaze di maraaut iaa wana amun paamua zin amun Judaa, wanaze waamua vaanong naandi di rudaxa adu axazak ina xa raamin fakilaan adu Iesu naan a Mesaaia, dina waapizin naan la vaal a maainungang sin naandi. ");
INSERT INTO nal_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Naan azaan kari damana ma dina di naxaam iaa ma di piaat iaa malasing kari, “Naan ka lapuk faanong, naagu iaari zina.” ");
INSERT INTO nal_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Di varua xaarik a viringang a rapti ina xa ra marawif ma di piaat malasing kari, “Gu piaat faratunaan kuna valaupang aizina Nakmai. Maadi rexaas adu naan a rapti raksaat.” ");
INSERT INTO nal_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naan ka xis naandi naako, “Tamon naan a rapti raksaat o xawit, nia xawit ga rexaas. Azaan azaxai be ga rexaazin. Paamua ga marawif ma naari ga raamaai xa!” ");
INSERT INTO nal_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Naanaan di iaari zina malasing kari, “Naan ka giu aze wana nua? Ka varalakaas a maraam malasing faa?” ");
INSERT INTO nal_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naan ka xis faulin naandi naako, “Ga vazei vanong nim ma xawit naagu langar. Kunaze naagu saxot naaguna langarin kaarik? Naagu saxot naaguna balas aubina varaviraai zina zaait?” ");
INSERT INTO nal_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Di psin amun dorang ka lingpuak pana naan ma di piaat malasing kari, “Nua a rapti varaviraai zin axazak angkanaan! Maam aubina varaviraai zin Moses! ");
INSERT INTO nal_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Maadi rexaas adu Nakmai xa dador zin Moses, singsaxai axazak angkanaan, kawit maadi rexaas naan ka wat faa.” ");
INSERT INTO nal_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A rapti xa piaat naako, “A zaan angkanaan ka banglala! Kawit naagu rexaazin naan ka wat faa, singsaxai naan ka varalakaas a maraagu. ");
INSERT INTO nal_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dia di rexaas adu Nakmai xawit nat langar zin aubina raksaat. Naan kat langar zin naandi dit lotu wana naan ma dit falos a sasaxotang ma ainaxamang sina. ");
INSERT INTO nal_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kawit nanga taxazak na langarin adu di varalakaas a marana a rapti di luk naan ka marawif faanong. ");
INSERT INTO nal_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tamon a rapti angkanaan kawit na wat sin Nakmai, xawit nat faraxas kana giu tazaan.” ");
INSERT INTO nal_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pana a dorang kanaan ma naandi di xis naan malasing kari, “Gu iziar vaanong pana matmalabuk taksaat araan nanga di luk nua, xa malasing faa adu guna wat firaai maam?!” Ma di waapizin naan la vaal a maainungang. ");
INSERT INTO nal_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu xa langar adu di waapizin a rapti angkanaan, ma xa wa tangin naan ma xa iaari zina naako, “Malasing faa, gu inaxam paazaai wana Naata Rapti?” ");
INSERT INTO nal_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A rapti xa iaari malasing kari, “Piran, naan nis? Fazei nia xuna gana inaxam paazaai wana naan.” ");
INSERT INTO nal_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu xa piaat naako, “Gu raamin fanong naan. Naan kari xai dador varaxai wana nua.” ");
INSERT INTO nal_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naanaan a rapti xa piaat naako, “Piran ga inaxam paazaai.” Ma naan ka lotu wana Iesu. ");
INSERT INTO nal_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu xa piaat naako, “Ga wat la pira angkari xuna klizang aubina xuna naandi di marawif dina raamaai ma naandi di raamaai dina balas amun marawif.” ");
INSERT INTO nal_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Azanon Faarasi di iziar varaxai wana Iesu di langarin naan ma di iaari zina malasing kari, “Aze? Maam saait maadi marawif?” ");
INSERT INTO nal_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu xa piaat naako, “Tamon naagu marawif, kawit taxazak kana vakor nim pana matmalabuk taksaat sinim. Singsaxai amun matmalabuk taksaat sinim nanga xa iziar wanaze naagu kalin adu naagu raamaai.” ");
INSERT INTO nal_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu xa piaat kaarik sin amun Faarasi naako, “Ga vazei varatunaan mase nim, a rapti ina xawit na ilbis lamarana a uwaau zin amun sipsip singsaxai xai fida lu la azanon tawarak, naan a vinaau ma axazak kat paxaar walau amun saan sin azanon. ");
INSERT INTO nal_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A rapti ina xa ilbis lu la mara naan axazak ka rataamaai xaaul wana amun sipsip sina. ");
INSERT INTO nal_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Axazak kat katkatong a mara xai kaas lis a mara zin a rapti xa rataamaai xaaul wana amun sipsip, ma amun sipsip dit langarin a lingna. Kat fakilaan amun sipsip pana amun izina naandi ma xat falos fatukbilok naandi. ");
INSERT INTO nal_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Araan naan ka zaxot fatukbilok naandi zina vaatak, kat paamuin naandi, ma amun sipsip di los naan panaze di rexaazin a lingna. ");
INSERT INTO nal_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Singsaxai dina wen los axazak tawarak, dina valaau vataling naan panaze xawit dit langarin fakilaan a linga axazak tawarak.” ");
INSERT INTO nal_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu xa dador lalaamangaai vaanong singsaxai naandi xawit di mazaam a vuvuna a dorang kanaan naa vazei naandi wana. ");
INSERT INTO nal_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Malasing ma Iesu xa piaat kaarik sin naandi naako, “Ga vazei varatunaan mase nim, Nia a mara zin amun sipsip. ");
INSERT INTO nal_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Naandi vaakdul ina di wat paamua wana nia naandi amun finaau ma aubina dit paxaar walau amun saan sin azanon, singsaxai amun sipsip kawit di langar zin naandi. ");
INSERT INTO nal_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nia a mara, ma axazak ina xa albis lu wana nia, Nakmai xana zaxot faulin naan. Naan kana albis ma xana tukbilak ma xana tangin a vanganang daxa. ");
INSERT INTO nal_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A vinaau xa wat be xuna vinaauang ma zop famaatang ma vanong pizinang amun sipsip. Singsaxai nia, ga wat kuna dina rauxin a roroiang ma xana bas pakluaai. ");
INSERT INTO nal_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nia a rapti xa rataamaai xaaul daxa wana amun sipsip. A rapti xa rataamaai xaaul daxa wana amun sipsip kat famaal psin a roroiang sina aaxan naandi. ");
INSERT INTO nal_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A rapti di wul naan kuna vaamuzazang, naan kawit a rapti xa rataamaai xaaul wana amun sipsip ma naan kawit damana amun sipsip. Araan ka raamin a wiu wungpung ka wat, kana luaa amun sipsip ma xana valaau. Naanaan a wiu wungpung kana xaraat naandi ma dina valaau varawuk. ");
INSERT INTO nal_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A rapti angkanaan kana valaau wanaze di wul be naan kuna vaamuzazang ma naan kawit na inaxam faalagat pana amun sipsip. ");
INSERT INTO nal_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nia nanga a rapti xa rataamaai xaaul daxa wana amun sipsip. Ga rexaazin amun sipsip surugu ma amun sipsip surugu di rexaazin nia, ");
INSERT INTO nal_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","malasing be Maagu xa rexaazin nia ma nia ga rexaazin Maagu. Ma ga vamaal psin a roroiang surugu aaxan amun sipsip. ");
INSERT INTO nal_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ga rauxin azanon sipsip ma xawit di iziar lamaskana a uwaau angkari. Gana zaxot fawat saait naandi. Naandi zaait dina langarin a lingugu, ma xana rauxin a lemlem azaxai ma a rapti be azaxai xa rataamaai xaaul wana naandi. ");
INSERT INTO nal_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","A vuvuna Maagu xa sasaxot nia xa malasing kari, gana vamaal psin a roroiang surugu, xuna gana zuruk faulin kaarik. ");
INSERT INTO nal_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kawit taxazak kana zuruk pizin siaagu, singsaxai ga vamaal psin pana ainaxamang surugu nanga. Nia ga rauxin a burburaaiang kuna vamaal psinang ma ga rauxin a burburaaiang kuna zuruk faulinang kaarik. Maagu xa vazei nia gana giu malasing kanaan.” ");
INSERT INTO nal_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Amun paamua zin amun Judaa di langarin a dorang kanaan ma di vara vatawagalaai xaarik. ");
INSERT INTO nal_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Amala zin naandi di piaat malasing kari, “A zapalaau xa ragul naan ma xa baabaa varawuk. Kunaze naagu langar zina?” ");
INSERT INTO nal_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Singsaxai azanon di piaat malasing kari, “Kawit awat dorang sin a rapti a zapalaau xa ragul naan. Kat faraxas a zapalaau xana varalakaas a marana aubina di marawif?” ");
INSERT INTO nal_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aza raan laba xa balas ikula Jerusalem. A raan iwana naxaamang A Raan Laba Di Viaat A Vaal Xoxok. A raan angkanaan kat balas la raan a milaatus, ");
INSERT INTO nal_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ma Iesu xa zazangas la Faraandaa zin Solomon lamaskana a rabaraau ila vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Amun paamua zin amun Judaa di wat tur varaxulin naan ma di piaat malasing kari, “Kana ruaas faa guna luaa maam maadina zibanglala? Tamon nua a Mesaaia, fazei vatok maam.” ");
INSERT INTO nal_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu xa xis naandi naako, “Ga ra vazei nim, singsaxai xawit naagu inaxam paazaai wana nia. Amun gigiuang gat gigiu wana aizina Maagu xat fiaat nia. ");
INSERT INTO nal_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Singsaxai xawit naagu inaxam paazaai wanaze nim kawit amun sipsip surugu. ");
INSERT INTO nal_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Amun sipsip surugu dit langarin a lingugu. Ga rexaazin naandi, ma di los nia. ");
INSERT INTO nal_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Gai lis a roro tapal zin naandi, ma dina wen milung. Kawit taxazak kat faraxas kana urif pizin naandi la mirugu. ");
INSERT INTO nal_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maagu ina xa lis naandi zurugu, xa laaup pana amun saan faakdul, xawit taxazak kat faraxas kana urif pizin naandi la mita Maagu. ");
INSERT INTO nal_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nia ma Maagu maadi zaxai iaa be.” ");
INSERT INTO nal_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Amun paamua zin amun Judaa di iot kaarik amun faat kuna tuk famaatang naan. ");
INSERT INTO nal_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Singsaxai Iesu xa piaat sin naandi naako, “Ga vatangin fanong amun gigiuang daxa xa varas ka wat sin Maagu. Pana aze ra gigiuang kanaan adu naaguna tuk famaat nia wana vaat?” ");
INSERT INTO nal_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Amun paamua di xis naan malasing kari, “Kawit adu maadina tuk nua saxotang amun saan angkanaan, singsaxai wanaze gui lingpuak pana Nakmai. Nua a rapti be, singsaxai gui kalin adu nua Nakmai.” ");
INSERT INTO nal_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu xa xis naandi naako, “Di varaar lamaskana amun Lus sinim malasing kari, ‘Nia ga ra piaat nim amun nakmai.’ ");
INSERT INTO nal_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nakmai xa lis fawat a dorang sina zin naandi ma xa vakilaan naandi amun nakmai, ma amun dorang lamaskana a Baar Xoxok kawit nat faraxas dina zuruk pizin. ");
INSERT INTO nal_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kana malasing faa wana naan ina Maagu xa rasin parok malasing sina vaatak nanga ma naa kling fawat la pira angkari? Kunaze naagu vakor nia adu ga lingpuak pana ga piaat adu nia Naata Nakmai? ");
INSERT INTO nal_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tuaa naagu inaxam paazaai wana nia tamon kawit ga gigiu amun gigiuang sin Maagu. ");
INSERT INTO nal_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Singsaxai tamon ga gigiu amun gigiuang sin Maagu, naapalaau xawit naagu inaxam paazaai wana nia, naaguna inaxam paazaai wana amun gigiuang, kuna naaguna rexaas ma naaguna mazaam adu Maagu xa iziar zurugu ma nia ga iziar zin Maagu.” ");
INSERT INTO nal_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Di lalaamangaai xuna zaraakang kaarik naan, singsaxai naan ka valau xaaiwizin naandi ma xa waan. ");
INSERT INTO nal_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Naanaan Iesu xa kas buaak faulin kaarik a daanim Jodaan kula non Jon kai baaptaais aubina wana lamun taan paamua. Ka iziar inaan ");
INSERT INTO nal_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ma amala aubina di wat sina. Di piaat malasing kari, “Naapalaau Jon kawit nat fabalos a vaakilanang, amun saan faakdul Jon ka piaat pana a rapti angkari xa vaaratunaan.” ");
INSERT INTO nal_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma la non angkanaan amala di inaxam paazaai wana Iesu. ");
INSERT INTO nal_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Aza rapti di vakilaanang Laazarus ka gias. Naan ila bina Betani, a bina zin Maaria ma duaana Maata. ");
INSERT INTO nal_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maaria angkanaan fafina Laazarus, naari xa itate gigias, mumua be ina xa ra vukin a daanim milalas mikuf, la uru xaaka Piran ma naa suxa wana a vurna. ");
INSERT INTO nal_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Uru vanduaanan di kilaai iaa xun Iesu ma di piaat iaa malasing kari, “Piran, a rapti gu sasaxot naan, ka gias.” ");
INSERT INTO nal_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Araan Iesu xa langarin ka piaat malasing kari, “A giazang kanaan kana wen faanong pana maatang. Kawit. Naari xuna aubina dina valaup aizina Nakmai ma aizina Naata Nakmai zaait.” ");
INSERT INTO nal_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu xa sasaxot Maata ma duaana ma Laazarus. ");
INSERT INTO nal_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Naapalaau xa langarin adu Laazarus ka gias, ka iziar la non angkanaan a raan urua nanga. ");
INSERT INTO nal_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ka piaat sin ubina varaviraai zina naako, “Dia dina uli waan la pira Judia.” ");
INSERT INTO nal_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma naandi di piaat malasing kari, “Maravas, naambari walaau be amun Judaa di ra lalaamangaai xuna dina tuk famaat nua wana vaat, ma adu guna uli xaarik nanga?” ");
INSERT INTO nal_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu xa xis naandi naako, “Malasing faa, xawit na rauxin a aaua xa zangaaflu ma urua wana a maravas la a raan azaxai? Axazak ina xa zangas la waanaas kana wen tuxin naan panaze xa rataamaai wana a maravas ila pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tamon kana zangas labung kana tuxin naan panaze naan kawit na rauxin a maravas kuna rataamaaiang pana.” ");
INSERT INTO nal_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lamuraana xa piaat fanong azaan angkanaan ka vazei naandi naako, “A paasaxo zin dia Laazarus ka milaaif. Singsaxai gana wa wangun naan.” ");
INSERT INTO nal_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ubina varaviraai zina di piaat malasing kari, “Piran, tamon ka milaaif kana daxa xaarik.” ");
INSERT INTO nal_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu xa dador wana maatang sin Laazarus, singsaxai ubina varaviraai zina di naxaam adu a vuvuna dorang sina adu xa milaaif be. ");
INSERT INTO nal_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Naan ka vazei vatok naandi naako, “Laazarus ka maat faanong. ");
INSERT INTO nal_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ga nanam kawit ga iziar varaxai wana naan pana notaan angkanaan, kuna naaguna raamaai vaakilan ma naaguna inaxam paazaai. Naagu wat ma dina waan sina.” ");
INSERT INTO nal_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomaas (di vakilaan Didimas) ka vazei aubina varaviraai vaakdul naako, “Dina waan saait kuna dina maat faraxai wana naan.” ");
INSERT INTO nal_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Araan Iesu xa balas ka tangin adu Laazarus ka itate vaanong la baaul a maat pana a raan urulavaat. ");
INSERT INTO nal_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani xa iziar malasing a kilomita urul wana Jerusalem, ");
INSERT INTO nal_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ma amala amun Judaa di wat sin Maata ma Maaria xuna vamadaiang nandiaa wana maatang sin fafina nandiaa. ");
INSERT INTO nal_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Araan Maata xa langar adu Iesu xa uwat, ka tukbilak kuna vasuinang naan, singsaxai Maaria xa iziar la vaal. ");
INSERT INTO nal_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maata xa piaat sin Iesu naako, “Piran, tamon gu lek siziar iriat, fafnugu xa lek pen maat. ");
INSERT INTO nal_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Singsaxai ga rexaas adu naari nanga Nakmai xana lis aze razaan gu maainung sina.” ");
INSERT INTO nal_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu xa piaat sina naako, “Fafnum kana ramaraat puli xaarik.” ");
INSERT INTO nal_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maata xa xis naan naako, “Ga rexaas kana ramaraat puli xaarik la raan aubina vaakdul dina ramaraat puli la vaanongang iwana amun taan.” ");
INSERT INTO nal_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu xa piaat sina naako, “Nia a ramaraat puliang ma nia a roroiang. Axazak ina xa inaxam paazaai wana nia xana roro, naapalaau, tamon ka maat, ");
INSERT INTO nal_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ma nis nanga xa roro ma xa inaxam paazaai wana nia xana wen maat, kawit mase. Malasing faa, gu inaxam paazaai wana aze razaan ga piaat?” ");
INSERT INTO nal_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maata xa piaat naako, “Aiang Piran, ga inaxam paazaai adu nua a Mesaaia, Naata Nakmai ina xana wat la pira angkari.” ");
INSERT INTO nal_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma lamuraana xa piaat fanong azaan angkanaan, ka uli xula vaal ma xa viring luk duaana Maaria ma xa ngif naan naako, “A maravas kari, ma xa iaariin nua.” ");
INSERT INTO nal_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Araan Maaria xa langar xa ramaraat fazaaus ma xa waan sin Iesu. ");
INSERT INTO nal_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Naari Iesu xawit nanga na balas la bina, singsaxai xa iziar nanga la non Maata xa vasuin naan pana. ");
INSERT INTO nal_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Araan amun Judaa ina di iziar varaxai wana Maaria la vaal dit mada naan, di raamin Maaria xa vazaaus pana ramaraatang ma xa tukbilak, malasing ma di los naan. Di naxaam adu xana waan la baaul a maat kuna wa raangizang. ");
INSERT INTO nal_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maaria xa balas la non Iesu xa iziar wana. Ka raamin Iesu, ma xa zibukaak la xaakna ma xa piaat naako, “Piran, tamon gu lek siziar iriat, fafnugu xa lek pen maat.” ");
INSERT INTO nal_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Araan Iesu xa raamin naan ka rataangis, ma aubina ina di wat faraxai wana naan saait di rataangis, a maskana xa bas ma xa maskalus. ");
INSERT INTO nal_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Naan ka iaari zin naandi naako, “Naagu vatate naan faa?” Di piaat sina malasing kari, “Piran, laawus gu raamin.” ");
INSERT INTO nal_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ma Iesu xa raangis. ");
INSERT INTO nal_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aubina di piaat malasing kari, “Naagu raamin, naan ka sasaxot a rapti angkari.” ");
INSERT INTO nal_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Singsaxai azanon di piaat malasing kari, “Iaak naan a rapti angbari ina xa kaas a marana a marawif, ma xunaze xawit na waakol a rapti angkari wana maatang?” ");
INSERT INTO nal_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu, faazaxai xaarik pana a maskana xa bas, ka wat la baaul a maat angkanaan. A liang, ma xa rauxin a vaat di rasin kol lamarana. ");
INSERT INTO nal_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ka piaat sin naandi naako, “Naagu wul psin a vaat.” Ma Maata fafina a rapti xa maat ka piaat naako, “Piran, ka itate vaanong a raan urulavaat ma awat taan angkari xa rauxin fanong a milalazang taksaat.” ");
INSERT INTO nal_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iesu xa piaat naako, “Ga ra vazei vanong nua adu tamon gu inaxam paazaai guna raamin a laaupang sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Naanaan di wul psin a vaat. Ma Iesu xa raamaai uzaa laaxur ma xa piaat naako, “Maagu, ga piaat ka daxa zunum panaze gu langar zurugu. ");
INSERT INTO nal_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ga rexaas adu gut langar bulaai zurugu, singsaxai ga piaat a dorang kanaan panaze ga naxaam aubina di irur xari xuna dina inaxam paazaai adu nua gu kling fawat nia.” ");
INSERT INTO nal_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Araan Iesu xa piaat fanong azaan angkanaan, ka viraai laba naako, “Laazarus tukbilak!” ");
INSERT INTO nal_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma a rapti xa maat ka tukbilak, amun mitna ma xaakna di bulupis pana uwaan marapi, ma aza waan di waakol a marana wana. Iesu xa piaat sin naandi naako, “Naagu akpaat uwaan marapi ila baaul a maat ma naagu luaa naan kana zangas.” ");
INSERT INTO nal_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Amala zin amun Judaa ina di wat taamin Maaria, di raamin azaan Iesu xa giu ma di inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Singsaxai uzanon sin naandi di waan sin amun Faarasi ma di vazei naandi wana azaan Iesu xa giu. ");
INSERT INTO nal_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Amun pris laba ma amun Faarasi di viring Aiziarang Iwana Aikilizang Sin Amun Judaa. Di iaari malasing kari, “Aze razaan dia di vabalos? Naari a rapti angkari xat fabalos amun faakilanang ka varas. ");
INSERT INTO nal_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tamon di luaa naan malasing kanaan, aubina vaakdul dina inaxam paazaai wana naan, ma mur amun Rom dina wat kawin fakdul mase a vaal xoxok sin dia ma aubina vaakdul.” ");
INSERT INTO nal_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Azaxai zin naandi, di vakilaan Kaaiapaas, naan a waamua zin amun pris faakdul la maariaas angkanaan ka piaat naako, “Kawit mase naagu rexaazin tazaan! ");
INSERT INTO nal_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kawit naagu raamin fakilaan adu xana daxa aaxan nim tamon a rapti be azaxai xana zuruk a kiaana aubina ma xana maat kuna tuaa dia vaakdul dina milung.” ");
INSERT INTO nal_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kawit na piaat azaan angkanaan pana ainaxamang sina nanga, singsaxai xa dador profet panaze naan a waamua zin amun pris faakdul la maariaas angkanaan. Ma xa dador profet adu Iesu xana maat saxotang amun Judaa vaakdul, ");
INSERT INTO nal_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ma xawit saxotang aubina angkanaan be, xawit. Singsaxai saxotang saait a funalik sin Nakmai ina di iziar varawuk, kuna zaxot faraxumulinang naandi xuna dina balas a lemlem azaxai be. ");
INSERT INTO nal_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma la raan angkanaan ma xa uzaa, di zazaleng ta lan kuna zop famaatang Iesu. ");
INSERT INTO nal_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Malasing ma Iesu xawit kaarik na zangas farawuk lamarana amun Judaa, xa luaa a non angkanaan ma xa waan la bina laba lapaara non bingil, a bina di vakilaan Efraaim, ma xa iziar varaxai wana ubina varaviraai zina. ");
INSERT INTO nal_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A raan laba zin amun Judaa xa wat faasilik. A raan angkanaan A Raan Laba Iwana Zangas Fasaalang. Ma amala aubina ila amun bina varawuk di waan Jerusalem kuna zuksukang naandi xuna dina ninis kaarik lamarana Nakmai, waamua wana A Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Di rataamaai zaleng Iesu, ma araan di irur nanga lamaskana rabaraau ila vaal xoxok, di iaari varawuk sin naandi nanga malasing kari, “Naagu naxaam malasing faa? Naan kana wen puat mase la raan laba angkari?” ");
INSERT INTO nal_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Singsaxai amun pris laba ma amun Faarasi di tabung fazei vaanong adu tamon taxazak ka rexaas Iesu xa iziar vaa, naan kana vazei naandi xuna dina zaraak naan. ");
INSERT INTO nal_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A raan ka wizik saaxa nanga xa iziar xuna A Raan Laba Iwana Zangas Fasaalang kana balas, ma Iesu xa balas la bina Betani. A bina zin Laazarus, a rapti Iesu xa varamaraat faulin pana maatang. ");
INSERT INTO nal_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Di nimnimanin a vanganang ku languzaraaf aaxan Iesu xuna vatanginang a varanopang sin naandi wana Iesu la bina angkanaan. Maata xa faawal wana talazang pana vanganang ma Laazarus ka iziar varaxai wana uzanon aubina wana aiban favanganang faraxai wana Iesu. ");
INSERT INTO nal_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Naanaan Maaria xa zuruk akbaala lita azaxai wana a daanim milalas mikuf di vakilaan a naad. Awat daanim mikuf angkari a maraana xa uzaa marazaat laaxur. Naa vukin la uru xaaka Iesu ma naa suxa wana a vurna. Ma a miaana a daanim mikuf ka vamilalos a maskana vaal vaakdul. ");
INSERT INTO nal_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Azaxai zin ubina varaviraai zin Iesu, aizina Judaas Iskaariot, ina mur xana ngutlis Iesu la mit amun purua, xa piaat naako, ");
INSERT INTO nal_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kunaze xawit di vaangurin a daanim milalas mikuf angkanaan pana a zangaaflu varazuai urul amun kaakaai denaarias kuna dina ralaas aubina di izi gogof.” ");
INSERT INTO nal_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Naan kawit na piaat malasing kanaan panaze xa inaxam pana aubina di izi gogof, singsaxai wanaze naan a vinaau. Naan kat gonin a lun di sfaar a kaakaai wana ma bulaai xat finau a kaakaai angkanaan di sfaar lamaskana a lun. ");
INSERT INTO nal_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iesu xa piaat naako, “Luaa a ravin angkanaan. Naan ka ra gonin a daanim mikuf angkanaan kula raan a nimnimaninang nia wana a kaavaaiang surugu. ");
INSERT INTO nal_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Inaan bulaai xana rauxin aubina di izi gogof lawalaua nim, singsaxai nia gana wen iziar bulaai varaxai wana nim.” ");
INSERT INTO nal_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","La notaan angkanaan adi mala amun Judaa di langar adu Iesu xa iziar Betani ma di wat, kawit kuna raaminang be Iesu singsaxai xuna raaminang saait Laazarus, ina Iesu xa varamaraat faulin pana maatang. ");
INSERT INTO nal_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Naanaan amun pris laba di zaleng a lan kuna zop famaatang saait Laazarus, ");
INSERT INTO nal_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","panaze wana naan be ma amala zin amun Judaa di waan sin Iesu ma di inaxam paazaai wana naan. ");
INSERT INTO nal_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","A raan lamuraana, axulutung angkanaan ina xa wat pana A Raan Laba Iwana Zangas Fasaalang, di langar adu Iesu xa uwat la lan kun Jerusalem. ");
INSERT INTO nal_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Di zuruk amun tangtangaana baibaai ma di waan kuna ruzuaaiang naan ma dit kupkup malasing kari, “Osaanaa!” “A daxaiang ka waan sina ina xa wat pana aizina Piran!” “Naan a Xalxaal in Israael!” ");
INSERT INTO nal_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu xa zuruk a dongki vaaxur ma xa iziar laaxur wana, malasing di ra varaar vating fanong lamaskana a Baar Xoxok, malasing kari, ");
INSERT INTO nal_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Aubina ila bina laba Zaaion, tuaa naagu maraaut, naagu raamin a xalxaal zinim ka wat, ka iziar laaxur wana a dongki vaaxur.” ");
INSERT INTO nal_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Paamua ubina varaviraai zina xawit di maravas pana a vuvuna a dorang kanaan. Singsaxai lamuraana Iesu xa ramaraat puli ma Nakmai xa valaup aizina, naandi di naxaam luk a dorang koxok di ra varaar wana naan ma naadi ra giu vanong saait pana naan. ");
INSERT INTO nal_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Adi mala angkanaan di ra iziar varaxai wana Iesu ma di ra raamin naan araan ka viring Laazarus lamaskana baaul a maat ma xa varamaraat faulin naan pana maatang. Di ipiaat farauxin azaan angkanaan. ");
INSERT INTO nal_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Amala aubina di waan kuna ruzuaaiang naan panaze di langarin adu naan ka ra vabalos a vaakilanang kanaan. ");
INSERT INTO nal_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Naanaan amun Faarasi di dador lawalaua naandi zaksaxai nanga malasing kari, “Naagu raamin, azaan adu di giu, xawit na vawaal dia. Naagu raamin malasing faa, aubina vaakdul di valau lalos naan!” ");
INSERT INTO nal_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ka rauxin azanon Grik lawalau aubina di wat Jerusalem kuna lotuiang la A Raan Laba angkanaan. ");
INSERT INTO nal_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Amun Grik angkanaan di wat sin Filip, naan in Betsaaida la pira Gaalili. Di vazei Filip malasing kari, “Dipiran, maadi saxot maadina raamin Iesu.” ");
INSERT INTO nal_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip ka waan ma xa vazei Endru, ma nandiaa varaxai di vazei iaa Iesu. ");
INSERT INTO nal_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu xa xis nandiaa naako, “A raan ka balas faanong kuna Nakmai xana valaup Naata Rapti. ");
INSERT INTO nal_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ga vazei varatunaan mase numaa, tamon a xalamona wit kana wen su wana pira ma xana maat, kana iziar axala be azaxai. Singsaxai tamon kana maat, kana vuain axala xa varas. ");
INSERT INTO nal_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Axazak ka sasaxot a roroiang sina ila pira angkari, a roroiang sina xana milung, ma axazak ina xa bain mase a roroiang sina ila pira angkari, naan kana roting falagot a roroiang sina xuna roro tapal. ");
INSERT INTO nal_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nis nanga xa gigiu a vaamuzazang surugu, naan kana los nia. Ma aze ranon ga iziar wana, a iaana kilaaiang surugu zaait kana iziar wana. Maagu xana wisfaru axazak ka gigiu a vaamuzazang surugu.” ");
INSERT INTO nal_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Iesu xa piaat fauzaa xaarik naako, “A maskaagu xa maravan, ma gana piaat aze? ‘Maagu, malasing faa, gu waapizin a maravan angkari wana nia’? Kawit. Ga wat iriat paanaburut kuna gana vazaak a maravanang kari. ");
INSERT INTO nal_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Maagu, gu valaup aizinum!” Mur a ling ka wat la lia naako, “Ga valaup fanong aizinugu ma gana valaup kaarik nanga.” ");
INSERT INTO nal_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Adi mala aubina di irur inaan di langarin ma di piaat adu xa bambarak, singsaxai azanon di piaat adu a aangelo xa dador zina. ");
INSERT INTO nal_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu xa piaat naako, “A ling angkanaan ka balas kuna vawaalang nim, kawit kuna vawaalang nia. ");
INSERT INTO nal_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Naari Nakmai xana klis a matmalabuk sin aubina ila pira angkari, ma naan kana vut pizin a piran ila pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Singsaxai nia, araan dina raxut fauzaa nia, gana urif fawat aubina vaakdul zurugu.” ");
INSERT INTO nal_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Naan ka piaat malasing kanaan kuna vatanginang aze rawat maatang sina. ");
INSERT INTO nal_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Adi mala aubina di piaat malasing kari, “Maadi langar vaanong pana amun Lus sin Moses adu a Mesaaia xana iziar tapal. Malasing ma xa malasing faa gu piaat malasing kari, ‘Naata Rapti dina raxut fauzaa naan laaxur’? Nis kari ‘Naata Rapti’?” ");
INSERT INTO nal_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ma Iesu xa vazei naandi naako, “A maravas kana wen iziar vaabung baraaf faraxai wana nim. Naagu zangas lamaskana maravas araan naagu rauxin a maravas, paamua wana a bungsuzuk kana waramin nim. Axazak ina xa zazangas la bungsuzuk, kawit na rexaazin naan ka zazangas paafaa. ");
INSERT INTO nal_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Naagu inaxam paazaai wana a maravas araan a maravas ka iziar varaxai wana nim, kuna naaguna balas a funalik ila maravas.” Araan Iesu xa vanong a dorang sina, xa vataling naandi ma xa zikam siaana naandi. ");
INSERT INTO nal_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Amun Judaa xawit di inaxam paazaai wana Iesu naapalaau naan ka vabalos amun faakilanang ka varas lamarana naandi. ");
INSERT INTO nal_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Malasing ma a dorang sin Aaisaaia a profet ka balas faaratunaan malasing kari, “Piran, nis ka ra inaxam paazaai wana a dorang sin diaa, ma nis ka ra raamin fakilaan a dikdikang sunum, nua a Piran?” ");
INSERT INTO nal_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","A vuvuna xawit di inaxam paazaai, wanaze xa malasing baina Aaisaaia xa piaat naako, ");
INSERT INTO nal_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nakmai xa vamarawif amun marana naandi ma xa waakol ainaxamang sin naandi, xuna amun marana naandi xana wen taamaai vaakilan ma dina wen inaxam daxa wana ainaxamang sin naandi. Ma xuna dina wen inaxam taawuk ma dina wen puat surugu xuna gana vira naandi.” ");
INSERT INTO nal_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aaisaaia xa piaat azaan angkanaan panaze naan ka raamin a marmari daxaiang sin Iesu ma xa dador profet pana naan. ");
INSERT INTO nal_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","La raan angkanaan nanga amala lawalau amun paamua zin amun Judaa di inaxam paazaai wana naan. Singsaxai xawit di viaat a inaxamang paazaai zin naandi wanaze di marauring amun Faarasi dina waapizin naandi lamaskana a vaal a maainungang sin amun Judaa. ");
INSERT INTO nal_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Avuna di sasaxot mase a wisfaaruiang sin aubina wana a wisfaaruiang ka wat sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma Iesu xa xupkup dikdik naako, “Araan axazak ka inaxam paazaai wana nia, naan kawit na inaxam paazaai wana nia zingbe, singsaxai wana axazak saait ina xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Araan axazak ka raamin nia, naan ka raamin axazak ina xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ga wat la pira angkari malasing a maravas, kuna nis ka inaxam paazaai wana nia xana wen iziar la bungsuzuk. ");
INSERT INTO nal_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Axazak ina xat langarin a dorang surugu ma xawit naat falos, kawit gai klis naan, panaze xawit ga wat kuna klizang aubina ila pira angkari, singsaxai ga wat kuna zaxot faulinang naandi. ");
INSERT INTO nal_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ka rauxin axazak kai klis naandi ina di lis a tora naandi zurugu ma xawit di rudaxain a dorang surugu, a dorang mase ina ga ra dadorin kana varur naandi wana dorang la vaanongang iwana a raan ma dina vazaak a maazikang. ");
INSERT INTO nal_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kawit ga dador wana ainaxamang surugu nanga, xawit. Maagu ina xa ra kling fawat nia, xa ra vazei nia xuna piaatang amun saan faakdul ga ra piaat. ");
INSERT INTO nal_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ga rexaas adu a dorang dikdik sina naan a roro tapal. Ma aze razaan ga piaat, naan bani azaan Maagu xa ra vazei nia gana piaat.” ");
INSERT INTO nal_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A flangan iwana Raan Laba Iwana Zangas Fasaalang kana samura balas, ma Iesu xa rexaas adu a raan ka wat faanong kuna naan kana luaa a pira angkari ma xana waan sin Damana. Naan ka sasaxot aubina zina di iziar la pira angkari ma naa sasaxot naandi xa ruaas pana vaanongang sina la pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","La raan a bina xat faakilan tapti, Iesu ma ubina varaviraai zina di vavangan, ma Saatan ka rasin fanong ainaxamang lamaskana Judaas, naata Saaimon Iskaariot, kuna xana ngutlis Iesu zin amun purua. ");
INSERT INTO nal_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu xa rexaas adu Damana xa lis fanong amun saan faakdul la mitna, ma Nakmai xa ra kling fawat naan ma xana uli waan sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Malasing ma naan ka ramaraat fataling a vanganang, ma xa gamul psin a marapi baraaf zina ilamanar, ma xa pis buaak naan la zuruna wana a taawol. ");
INSERT INTO nal_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mur xa vukin a daanim lamaskana a win iwana zuksukang ma xa varumara a zukang axaaka ubina varaviraai zina, ma naa suxa wana a taawol ina naa ra pis buaak a zuruna wana. ");
INSERT INTO nal_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Naan ka wat sin Saaimon Pita, ma Saaimon Pita xa piaat sina naako, “Piran, malasing faa, guna zuk kari uru xaaku?” ");
INSERT INTO nal_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu xa xis naan naako, “Kawit gu raamin fakilaan aze ga gigiu, singsaxai mur guna mazaam.” ");
INSERT INTO nal_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita xa piaat naako, “Kawit, guna wen suk mase amun kaaku.” Iesu xa xis naan malasing kari, “Tamon gana wen suk amun kaakum, guna wen iziar varaxai wana nia.” ");
INSERT INTO nal_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saaimon Pita xa piaat naako, “Piran, kawit uxaaku zingbe, singsaxai umirugu ma a waarugu zaait!” ");
INSERT INTO nal_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu xa piaat naako, “Axazak ina xai zuf faanong kat faraxas be xana zuk amun kaakna, a winpina vaakdul xa ninis. Ma nim naagu ninis, singsaxai xawit nim faakdul.” ");
INSERT INTO nal_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Avuna Iesu xa rexaas nis kana ngutlis naan sin amun purua malasing ma xa piaat kawit naandi vaakdul di ninis. ");
INSERT INTO nal_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Araan naan ka zuk fanong amun kaaka naandi, xa valaak faulin amun marapi zina ma xa iziar uli la kiaana. Naan ka iaari zin naandi naako, “Malasing faa, naagu mazaam aze ga giu xu nim? ");
INSERT INTO nal_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Naagu vakilaan nia ‘Maravas’ ma ‘Piran,’ ma a dorang kanaan ka daxa. Avuna nia a rapti angkanaan. ");
INSERT INTO nal_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma nia, a Piran ma a Maravas sinim, ga zuk fanong axaaka nim, malasing ma nim saait naaguna zuk farauxin amun kaaka nim. ");
INSERT INTO nal_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ga vatangin fanong sinim aze rawat matmalabuk ga giu xu nim, ma ga saxot naaguna giu malasing saait. ");
INSERT INTO nal_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ga vazei varatunaan mase nim, kawit na rauxin ta iaana kilaaiang kana laaup pana a mono zina, ma xawit taxazak di ikling naan ka laaup pana nis ka kling naan. ");
INSERT INTO nal_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ma naari naagu rexaas faanong pana amun saan angkari, malasing ma Nakmai xana lis a daxaiang sinim tamon naagu giu malasing kanaan.” ");
INSERT INTO nal_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ma Iesu xa piaat kaarik naako, “Kawit ga piaat pana nim faakdul, wanaze ga rexaazin nis ga kalin fanong. Naari a dorang kari lamaskana Baar Xoxok kana balas faaratunaan, ka malasing kari: ‘Axazak ka varabixin a raraba varaxai wana nia xa raxut a xaakna xuna wasparaminang nia.’ ");
INSERT INTO nal_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ga vazei xari nim paamua wana xana balas, kuna araan kana balas faaratunaan, naaguna inaxam paazaai adu nia bani axazak ina ga kalin adu nia. ");
INSERT INTO nal_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ga vazei varatunaan mase nim, axazak ina xa rudaxain axazak ga kling, ka rudaxain saait nia. Ma axazak ina xa rudaxain nia, xa rudaxain axazak ka ra kling fawat nia.” ");
INSERT INTO nal_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Lamuraana Iesu xa piaat malasing kanaan, a maskana xa maravan marazaat ma xa pitfiaat naako, “Ga vazei varatunaan mase nim, axazak sinim kana ngutlis nia zin amun purua.” ");
INSERT INTO nal_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ubina varaviraai zina di raamin farauxin naandi, ma di bangain nis sin naandi naa ipiaat. ");
INSERT INTO nal_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Axazak sin naandi, a rapti varaviraai ina Iesu xai sasaxot, ka iziar lapaarana. ");
INSERT INTO nal_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saaimon Pita xa vagilaam a rapti angkanaan ma xa piaat sina naako, “Gu iaari zina, nis mase naa ipiaat.” ");
INSERT INTO nal_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naan ka zivaraaskal wana Iesu ma xa iaari zina naako, “Piran, nis mase?” ");
INSERT INTO nal_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu xa xis a dorang sina naako, “Naan axazak ina gana lis a vang raraba zina lamuraana ga vasu lamaskana a win favanganang.” Ma Iesu xa vasu a vang raraba, ma naa lis sin Judaas, naata Saaimon Iskaariot. ");
INSERT INTO nal_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Araan bani Judaas ka zuruk a vang raraba, Saatan ka sfaar naan. Iesu xa vazei naan naako, “Azaan angkanaan adu guna giu, gu giu vazaus ka.” ");
INSERT INTO nal_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Singsaxai xawit taxazak di iziar varaxai wana aiban favanganang, ka mazaam kunaze Iesu xa piaat malasing kanaan sina. ");
INSERT INTO nal_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judaas kat katkatong a kaakaai, malasing ma azanon ubina varaviraai di naxaam adu Iesu xa vazei naan kana wul aze razaan kuna a raan laba, o xuna xana lis sin aubina di izi gogof. ");
INSERT INTO nal_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Araan bani Judaas ka zuruk a raraba, xa tukbilak. Ma a bina xa suk ka. ");
INSERT INTO nal_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lamuraana Judaas ka waan faanong, Iesu xa piaat naako, “Naari Naata Rapti xana zuruk aiza laba ma Nakmai xana zuruk aiza laba wana naan. ");
INSERT INTO nal_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma araan Nakmai xa zuruk aiza laba, naan kana valaup Naata Rapti, ma naana giu vazaaus mase. ");
INSERT INTO nal_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Naam funalik, gana iziar varaxai wana nim faamumut be. Naaguna zaleng nia ma malasing ga ra vazei amun paamua zin amun Judaa gana vazei zaait nim malasing kari: Aze ranon gana waan pana xawit naagut faraxas naaguna wat pana. ");
INSERT INTO nal_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A lus faaxur ga lis sinim malasing kari: Naaguna sasaxot nim saksaxai. Malasing nia ga sasaxot nim, nim saait naaguna sasaxot nim saksaxai. ");
INSERT INTO nal_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tamon naaguna sasaxot nim saksaxai, aubina vaakdul dina rexaas adu nim aubina varaviraai zurugu.” ");
INSERT INTO nal_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saaimon Pita xa iaari zina naako, “Piran, gu waa faa?” Iesu xa xis naan naako, “Aze ranon gana waan pana, xawit nat faraxas guna los nia naambari, singsaxai mur guna los nia.” ");
INSERT INTO nal_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita xa iaari naako, “Piran, malasing faa, xawit nat faraxas gana los nua naambari? Gana lis pizin a roroiang surugu xu nua.” ");
INSERT INTO nal_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma Iesu xa xis naan naako, “Faaratunaan guna lis pizin a roroiang sunum ku nia? Ga vazei varatunaan mase nua, waamua wana a uraa xana kaakaluk, guna wispuxin nia faarul!” ");
INSERT INTO nal_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu xa piaat kaarik naako, “Tuaa naagu maska maravan. Naagu inaxam paazaai wana Nakmai ma naagu inaxam paazaai zaait pana nia. ");
INSERT INTO nal_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lamaskana a vaal zin Maagu xa rauxin a rumaaf ka varas. Tamon kawit na vaaratunaan ga lek fazei nim pana. Gana waan la non angkanaan kuna nimnimaninang a non aaxan nim. ");
INSERT INTO nal_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma tamon gana waan ma gana nimnimanin a non aaxan nim, gana uli wat kaarik ma gana zaxot nim, ma naaguna raagul varaxai wana nia, xuna a non ga raagul wana, nim saait naaguna raagul wana. ");
INSERT INTO nal_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Naagu rexaazin a lan ka waan la non gana waan pana.” ");
INSERT INTO nal_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaas ka piaat sina naako, “Piran, maadi wetexaas aze ra non guna waan pana. Maadina rexaazin a lan malasing faa?” ");
INSERT INTO nal_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu xa xis naan malasing kari, “Nia a lan ma nia a vaaratunaanang ma nia a roroiang. Kawit nat faraxas taxazak kana wat sin Maagu wana taza lan tawarak, singsaxai wana nia be. ");
INSERT INTO nal_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tamon naagu rexaazin mase nia, naaguna rexaazin saait Maagu. Ma xa ruaas taning ma xa uzaa xa vaaratunaan, naagu rexaazin naan ma naagu raamin fanong naan.” ");
INSERT INTO nal_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip ka piaat naako, “Piran, gu vatangin Damaam simaam ma xanat faraxas pana ainaxamang simaam.” ");
INSERT INTO nal_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu xa xis naan naako, “Filip, ga iziar vaabung baraaf faanong faraxai wana nim. Malasing faa, xawit nanga gu rexaazin nia? Axazak ina xa raamin fanong nia, xa raamin fanong Maagu. Malasing faa gu piaat nu naako, ‘Gu vatangin Damaam simaam’? ");
INSERT INTO nal_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Iaak kawit naagu inaxam paazaai adu nia ga iziar lamaskana Maagu ma Maagu xa iziar la maskaagu? A dorang ga piaat sinim kawit surugu nanga. Singsaxai Maagu, naan ka iziar varaxai wana nia, ma naan ka gigiu amun faamuzazang sina. ");
INSERT INTO nal_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Naagu inaxam paazaai wana nia araan ga piaat adu nia ga iziar lamaskana Maagu ma Maagu xa iziar la maskaagu. O tamon kawit, naagu inaxam paazaai wana nia wanaze wana amun faamuzazang ka banglala gat fabalos. ");
INSERT INTO nal_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ga vazei varatunaan mase nim, axazak ina xa inaxam paazaai wana nia, naan kana giu amun saan ga gigiu. Ma naan kana giu amun faamuzazang ka laaup pana nia ga gigiu, wanaze gana waan sin Maagu. ");
INSERT INTO nal_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma gana giu aze razaan naagu maainung pana aizinugu, xuna Maagu xana zuruk aiza laba wana Naatna. ");
INSERT INTO nal_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Naaguna maainung nia wana aze razaan pana aizinugu, ma gana giu.” ");
INSERT INTO nal_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ma Iesu xa piaat kaarik naako, “Tamon naagu sasaxot nia naaguna valos amun dorang dikdik surugu. ");
INSERT INTO nal_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nia gana iaari zin Maagu, ma Naan kana lis taza xazak kuna faawalang sinim, ma naan kana izi tapal varaxai wana nim. ");
INSERT INTO nal_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Naan a Laklagai iwana dorang faaratunaan. Aubina ila pira angkari xawit dit faraxas dina rudaxain naan, panaze xawit di rataamin naan ma xawit di rexaazin naan. Singsaxai nim naagu rexaazin naan, panaze xa raagul varaxai wana nim ma xana iziar lamaskana nim. ");
INSERT INTO nal_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Gana wen luaa nim malasing amun nakmaal, gana uli wat sinim. ");
INSERT INTO nal_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Faasilik ka aubina ila pira angkari dina wen taamin kaarik nia. Singsaxai nim naaguna raamin nia. Nia ga roro, malasing ma nim saait naaguna roro. ");
INSERT INTO nal_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","La raan angkanaan naaguna mazaam adu nia ga iziar lamaskana Maagu, ma nim naagu iziar la maskaagu, ma nia ga iziar lamaskana nim. ");
INSERT INTO nal_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Axazak ina xa rauxin amun dorang dikdik surugu ma naat falos, naan ka sasaxot nia. Naan ina xa sasaxot nia, Maagu xana sasaxot naan, ma nia zaait gana sasaxot naan ma gana vatangin nia zina.” ");
INSERT INTO nal_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Naanaan Judaas (kawit Judaas Iskaariot) ka piaat naako, “Singsaxai Piran, kunaze adu guna vatangin nua zimaam ma guna wen fatangin nua zin aubina ila pira angkari.” ");
INSERT INTO nal_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu xa xis naan naako, “Tamon axazak ka sasaxot nia, naan kana valos amun dorang surugu. Maagu xana sasaxot naan ma maadina wat iaa zina ma maadina raagul iaa varaxai wana naan. ");
INSERT INTO nal_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Axazak ina xawit na sasaxot nia xana wen falos amun dorang surugu. Amun dorang kari naagu langarin kawit surugu nanga, amun dorang sin Maagu ina xa ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Amun saan faakdul angkanaan ga ra vazei nim pana araan ga iziar nanga varaxai wana nim. ");
INSERT INTO nal_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Singsaxai Axazak Iwana Faawalang, naan a Laklagaai a Raabu, Maagu xana kling fawat naan pana aizinugu. Naan kana viraai nim pana amun saan faakdul ma xana vainaxaam nim pana amun saan faakdul ga ra ipiaat sinim. ");
INSERT INTO nal_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","A luaai ga luaa varaxai wana nim, a luaai zurugu ga lis sinim. Kawit gai lis awat luaai aubina ila pira di ilis. Tuaa naagu maska maravan ma tuaa naagu maraaut. ");
INSERT INTO nal_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Naagu langarin ga piaat ninaako, ‘Gana waan tawarak ma gana uli wat kaarik sinim.’ Tamon naagu sasaxot nia, naaguna nanam adu gana waan sin Maagu, wanaze Maagu xa laaup pana nia. ");
INSERT INTO nal_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ga tabung fazei vanong nim paamua wana amun saan angkari xana balas, kuna araan kana balas, naaguna inaxam paazaai. ");
INSERT INTO nal_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gana wen dador vaabungbaraaf faraxai wana nim, panaze a piran ila pira angkari xana wat ka. Kawit na rauxin a dikdikang kuna waraminang nia, ");
INSERT INTO nal_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","singsaxai naan ka wat kuna aubina ila pira angkari dina rexaas adu ga sasaxot Maagu ma ga gigiu vatfaraxazin amun faamuzazang faakdul Maagu xat fazei nia xuna giuang. Naagu wat, dina waan fataling a non angkari.” ");
INSERT INTO nal_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu xa piaat kaarik naako, “Nia a iaai a waain faaratunaan, ma Maagu naan damana auma waain. ");
INSERT INTO nal_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naan kai tok pizin amun tangtanganang ina xawit nat fuvuai, ma xai kdur amun tangtanganang ina xa vuvuai, xuna xana vuain amun fnuaai xa varas. Nim amun tangtangaanugu. ");
INSERT INTO nal_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nim naagu ninis faanong panaze wana amun dorang ga ra dadorin sinim. ");
INSERT INTO nal_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Naagu iziar la maskaagu, malasing nia ga iziar lamaskana nim. Kawit nat faraxas ta rangtanganang kana vuai naan singit. Naan kana iziar lamaskana a iaai a waain. Malasing saait nim, kawit nat faraxas naaguna vuai tamon kawit naagu iziar la maskaagu. ");
INSERT INTO nal_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nia nanga a iaai a waain ma nim amun tangtanganang. Tamon axazak ka iziar la maskaagu ma nia ga iziar lamaskana, naan kana vuain amun fnuaai xa varas. Singsaxai tamon naan ka iziar lawalaau ziaagu, xawit nat faraxas kana giu vabalos tazaan. ");
INSERT INTO nal_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tamon axazak kawit na iziar la maskaagu, naan ka malasing a rangtanganang di tokpizin ma xa maraang. Amun tangtanganang kanaan di iot turin, ma di psin lamaskana xaiaf ma xa if. ");
INSERT INTO nal_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tamon naagu iziar la maskaagu ma amun dorang surugu xa iziar lamaskana nim, naaguna maainung pana aze razaan naagu saxot, ma gana giu aaxanim. ");
INSERT INTO nal_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Araan naagu vuain amun fnuaai xa varas, ka valaup aizina Maagu, ma xa vatangin saait adu nim ubina varaviraai zurugu. ");
INSERT INTO nal_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nia ga sasaxot nim malasing Maagu xa sasaxot nia. Naagu iziar lamaskana a sasaxotang surugu. ");
INSERT INTO nal_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tamon naagu valos amun dorang dikdik surugu, naaguna iziar lamaskana a sasaxotang surugu, malasing saait nia ga valos amun dorang dikdik sin Maagu ma ga iziar lamaskana a sasaxotang sina. ");
INSERT INTO nal_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ga ra vazei nim pana a dorang kanaan kuna a nanamang surugu xana iziar wana nim ma a nanamang sinim kana bas mase. ");
INSERT INTO nal_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A dorang dikdik surugu xa malasing kari: Naaguna sasaxot nim saksaxai malasing nia ga ra sasaxot nim. ");
INSERT INTO nal_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kawit taza sasaxotang ka laba wana a sasaxotang sin axazak ina xa lis pizin a roroiang sina aaxan amun paasaxo zina. ");
INSERT INTO nal_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tamon naagu valos amun dorang dikdik surugu, nim amun paasaxo zurugu. ");
INSERT INTO nal_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Gana wen fakilaan kaarik nim amun iaana kilaaiang, panaze a iaana kilaaiang kawit na rexaas pana amun taalilang sin a mono zina. Singsaxai, ga vakilaan nim amun paasaxo zurugu, wanaze amun saan faakdul ga ra varaviraai wana zin Maagu, gat fatangin sinim. ");
INSERT INTO nal_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kawit naagu kalin nia, singsaxai nia ga kalin nim ma ga lis a vaamuzazang sinim, kuna naaguna waan ma naaguna vuain amun fnuaai xana iziar bulaai. Ma Maagu xana lis aze razaan naagu maainung pana aizinugu. ");
INSERT INTO nal_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","A dorang dikdik surugu xa malasing kari: Naaguna sasaxot nim saksaxai.” ");
INSERT INTO nal_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ma Iesu xa piaat kaarik naako, “Tamon aubina ila pira angkari di maska raksaat pana nim, naagu naxaam saait adu di ra tabung maska raksaat pana nia. ");
INSERT INTO nal_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tamon nim ila pira angkari, aubina dina sasaxot nim malasing nim sin naandi vaatak. Singsaxai nim kawit ila pira angkari, xawit. Ga kalin fanong nim siaana aubina ila pira angkari. Malasing ma aubina ila pira angkari di maska raksaat pana nim. ");
INSERT INTO nal_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tuaa naagu naxambain a dorang ga piaat sinim adu a iaana kilaaiang kawit na laaup pana a mono zina. Tamon di vamazik nia, dina vamazik saait nim. Tamon di valos amun faraviraaiang surugu, dina valos saait sinim. ");
INSERT INTO nal_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Naandi dina giu malasing kanaan pana nim panaze wana aizinugu, avuna xawit di rexaazin axazak ka ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tamon ga lek pen puat ma ga lek pen dador zin naandi, di lek pen giu amun matmalabuk taksaat pana nia. Singsaxai naari xawit nat faraxas dina dador xol amun matmalabuk taksaat sin naandi. ");
INSERT INTO nal_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Axazak ina xa maska raksaat pana nia, xa maska raksaat saait pana Maagu. ");
INSERT INTO nal_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tamon ga lek pen puat lawalaua naandi ma ga lek pen fabalos amun faamuzazang ka banglala, ina xawit nat faraxas taxazak tawarak kana giu, di lek pen giu amun matmalabuk taksaat pana nia. Singsaxai faaratunaan di ra raamin fanong amun faamuzazang ka banglala ma di ra maska raksaat nanga wana nimaa Maagu. ");
INSERT INTO nal_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Singsaxai di ra giu malasing kanaan malasing ma a dorang di varaar lamaskana amun Lus sin naandi xa balas faaratunaan malasing kari, ‘Di maska raksaat pana nia ma xawit a vuvuna.’ ");
INSERT INTO nal_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Gana kling fawat Axazak Iwana Faawalang ma naan kana wat sinim, naan ka wat sin Maagu. Naan a Laklagai iwana vaaratunaanang. Araan naan kana wat, kana pitfiaat nia. ");
INSERT INTO nal_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma nim saait naaguna pitfiaat nia wanaze naagu iziar varaxai wana nia wana varumaraiang amun faamuzazang surugu ma xa ruaas taning.” ");
INSERT INTO nal_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Iesu xa piaat kaarik naako, “Ga vazei vanong nim pana amun saan angkanaan kuna tuaa ainaxam paazaaiang sinim kana zu. ");
INSERT INTO nal_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dina waapizin nim lamaskana a vaal a maainungang sin naandi. Ma a raan saait kana wat kuna axazak ina xa zop famaat nim kana naxaam adu xa gigiu a vaamuzazang daxa zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Dina giu amun saan angkanaan panaze xawit di rexaazin Maagu o nia. ");
INSERT INTO nal_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ga vazei vanong nim pana amun saan angkanaan, kuna a raan sin naandi xana balas ma naaguna naxaam faulin a dorang naknakaai ga ra vazei nim pana. Kawit ga ra vazei nim paamua wanaze ga iziar varaxai wana nim. ");
INSERT INTO nal_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Singsaxai naari gana waan sin axazak ina xa ra kling fawat nia. Ma xawit taxazak sinim na iaari zurugu naako, ‘Guna waa faa?’ ");
INSERT INTO nal_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","A maskana nim ka maravan marazaat panaze ga piaat amun saan angkanaan sinim. ");
INSERT INTO nal_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Singsaxai ga vazei varatunaan nim. A daxaiang aaxan nim araan gana waan tawarak, panaze tamon kawit ga waan, Axazak Iwana Faawalang kana wen puat sinim. Singsaxai tamon ga waan, gana kling fawat naan sinim. ");
INSERT INTO nal_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Araan naan kana wat, kana vatangin sin aubina ila pira angkari adu ainaxamang sin naandi wana a matmalabuk taksaat ma a matmalabuk ka tak ma aikilizang kawit na tak. ");
INSERT INTO nal_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Naan kana vatangin sin naandi adu ainaxamang sin naandi wana a matmalabuk taksaat kawit na tak, panaze aubina xawit di inaxam paazaai wana nia. ");
INSERT INTO nal_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma naan kana vatangin sin naandi adu ainaxamang sin naandi wana a matmalabuk ka tak kawit na tak, panaze nia gana waan sin Maagu, ma naaguna wen taamin kaarik nia. ");
INSERT INTO nal_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma malasing kanaan pana aikilizang, panaze Nakmai xa varur vanong a piran ila pira angkari wana dorang. ");
INSERT INTO nal_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ga rauxin a dorang ka varas marazaat kuna vazeiang nim, singsaxai xana lagaf mase wana naaguna zuruk. ");
INSERT INTO nal_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Singsaxai araan a Laklagai iwana dorang faaratunaan kana wat, naan kana waamuain nim pana amun dorang faaratunaan faakdul. Naan kana wen dador wana a dorang sina nanga, xana piaat be aze naa langarin ma xana vazei nim pana amun saan kana wat nanga. ");
INSERT INTO nal_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Naan kana valaup aizinugu wanaze gana lis amun dorang sina ma xana viaat sinim. ");
INSERT INTO nal_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Amun saan faakdul zin Maagu, zurugu. Malasing ma ga piaat a Laklagai xana zuruk amun dorang surugu ma xana viaat sinim.” ");
INSERT INTO nal_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Iesu xa piaat kaarik naako, “Faamumut be naaguna wen taamin nia, ma faamumut kaarik lamuraana naaguna raamin nia.” ");
INSERT INTO nal_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Azanon ubina varaviraai zina di piaat lawalaua naandi zaksaxai malasing kari, “Naan ka piaat naako, ‘Faamumut be naaguna wen taamin nia, ma faamumut kaarik lamuraana naaguna raamin nia,’ ma xa piaat saait naako, ‘Avuna gana waan sin Maagu.’ Aze ra vuvuna amun dorang kanaan?” ");
INSERT INTO nal_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma di vu iaari malasing kari, “Aze ra wat dorang kari xa piaat, ‘Faamumut be’? Kawit maadi mazaam aze naa ipiaat.” ");
INSERT INTO nal_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu xa rexaas adu di saxot dina iaari zina wana dorang kanaan, malasing ma xa piaat sin naandi, naako, “Iaak naagu iaari lawalaua nim saksaxai wana a dorang kari ga piaat adu ‘Faamumut be naaguna wen taamin nia, ma faamumut kaarik lamuraana naaguna raamin nia’? ");
INSERT INTO nal_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ga vazei varatunaan mase nim, naaguna raangis ma naaguna maskalus, singsaxai aubina vaakdul ila pira angkari dina nanam. Naaguna maskalus singsaxai mur naaguna nanam. ");
INSERT INTO nal_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A ravin ina xana luk kat kazanin a maazikang panaze a raan sina xa balas. Singsaxai araan a popo xa balas, naan ka naxambain a maazikang kanaan panaze wana a nanamang sina wana a nalik ka balas faanong la pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ka malasing kanaan pana nim. Naari a raan sinim naaguna maskalus, singsaxai gana raamin kaarik nim ma naaguna nanam ma xawit taxazak kana zuruk pizin a nanamang sinim. ");
INSERT INTO nal_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","La raan angkanaan naaguna wen maainung tazaan surugu. Ga vazei varatunaan mase nim. Aze razaan naagu maainung sin Maagu wana aizinugu, naana lis sinim. ");
INSERT INTO nal_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ka ruaas taning kawit nanga naagut maainung tazaan pana aizinugu. Naagu maainung ma naaguna zuruk, ma a nanamang sinim kana bas mase.” ");
INSERT INTO nal_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ma Iesu xa piaat kaarik naako, “Ga rai dador zinim pana a dorang lalaamangaai. A raan kana wat ma gana wen dor lalaamangaai xaarik, singsaxai gana vazei vatok be nim pana Maagu. ");
INSERT INTO nal_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pana a raan angkanaan nim nanga naaguna maainung paan sin Maagu wana aizinugu. Ma xawit ga piaat adu nia gana maainung paan sin Maagu aaxa nim. ");
INSERT INTO nal_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Avuna Maagu nanga xa sasaxot nim, panaze naagu sasaxot nia ma naagu inaxam paazaai adu ga wat sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ga wat ikula zin Maagu xunitiat la pira angkari. Ma naari gana luaa a pira angkari ma gana uli waan kaarik sin Maagu.” ");
INSERT INTO nal_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ubina varaviraai zina di piaat malasing kari, “Naari xa gu dador vaamaravas, ma xawit gu dador lalaamangaai. ");
INSERT INTO nal_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Naari maadi rexaas adu gu rexaazin amun saan faakdul ma xawit nat faraxas taxazak kana iaari zunum. Pana azaan angkanaan maadi inaxam paazaai adu nua gu wat sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu xa xis naandi naako, “Malasing faa, naari naagu inaxam paazaai xa? ");
INSERT INTO nal_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","A raan kana balas ma xa balas faanong, araan nim faakdul naaguna waan farawuk, axazak saksaxai la vaal zina. Malasing ma naaguna waan fataling nia zing. Singsaxai xawit ga iziar nia zing, Maagu xa iziar varaxai wana nia. ");
INSERT INTO nal_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ga vazei vanong nim pana amun saan angkanaan, kuna naaguna rauxin a luaai araan naagu iziar zurugu. La pira angkari naaguna xazanin amun maravanang. Singsaxai naagu irur dikdik! Ga waramin fanong a dikdikang ila pira angkari.” ");
INSERT INTO nal_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Lamuraana Iesu xa piaat fanong azaan angkanaan, ka raamaai uzaa la lia ma xa maainung naako, “Maagu, a raan ka balas faanong. Gu valaup aizina Naarum, kuna Naarum kana valaup aizinum. ");
INSERT INTO nal_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Avuna gu lis fanong a burburaaiang sina laaxur wana aubina vaakdul xuna naan kana lis a roro tapal zin naandi vaakdul ina gu ra lis sina. ");
INSERT INTO nal_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma a laana roro tapal xa malasing kari, naandi dina rexaazin nua, nua zingbe Nakmai vaaratunaan, ma dina rexaazin nia Iesu Kaarisito ina gu ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ga valaup fanong aizinum laaxur wana a pira angkari araan ga vanong amun faamuzazang gu lis surugu xuna giuang. ");
INSERT INTO nal_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Maagu, naari gu valaup aizinugu la maraam pana a marmari daxaiang ga rauxin faraxai wana nua waamua wana a faaziarang ka balas.” ");
INSERT INTO nal_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma Iesu xa piaat kaarik naako, “Ga ra viaat fanong nua zin naandi ina gu ra kalin luk naandi ziaana a pira angkari ma gu lis naandi zurugu. Naandi zunum, ma gu lis naandi zurugu ma di valos a dorang sunum. ");
INSERT INTO nal_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naari di rexaas ka adu amun saan faakdul gu lis fanong surugu xa wat sunum. ");
INSERT INTO nal_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Avuna amun dorang gu ra lis surugu ga lis sin naandi ma naadi zuruk. Di rexaazin faratunaan adu ga ra wat sunum, ma di inaxam paazaai adu nua gu ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ga maainung kun naandi. Kawit ga maainung kun aubina ila pira angkari, singsaxai aaxan naandi gu ra lis fanong surugu, wanaze naandi zunum. ");
INSERT INTO nal_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Naandi vaakdul zurugu naandi zunum, ma naandi vaakdul zunum naandi zurugu zaait. Ma wana naandi ga zuruk aiza laba. ");
INSERT INTO nal_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Gana wen iziar xaarik la pira angkari, singsaxai naandi di iziar nanga la pira angkari, ma nia gana wat sunum. Maagu gu xoxok, katkatong naandi wana a dikdikang iwana aizinum, aiza gu ra lis surugu, xuna naandi dina zaxai, malasing saait diaa di zaxai iaa. ");
INSERT INTO nal_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Araan ga iziar varaxai wana naandi, ga xatkatong naandi ma ga rataamaai xaaul wana naandi wana a dikdikang iwana aizinum, aiza gu lis surugu. Kawit tazaxai na milung, singsaxai be azaxai ina xana waan ma xana milung, kuna a dorang lamaskana a Baar Xoxok kana balas faaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Naari gana wat ka zunum, singsaxai gai piaat amun saan angkanaan araan ga iziar nanga la pira angkari, xuna dina xazanin a nanamang surugu lamaskana naandi ma xana bas mase. ");
INSERT INTO nal_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ga lis fanong a dorang sunum sin naandi, ma aubina ila pira angkari di ra maska raksaat pana naandi, wanaze naandi xawit ila pira angkari malasing saait bani nia xawit ila pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A maainungang surugu xawit adu xuna guna zuruk pizin naandi ziaana a pira angkari, xawit. Singsaxai a maainungang surugu adu xuna guna rataamaai xaaul wana naandi ziaana a rapti raksaat. ");
INSERT INTO nal_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Naandi xawit ila pira angkari, malasing saait bani nia xawit ila pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Faxoxok naandi wana a dorang faaratunaan. A dorang sunum naan a dorang faaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Malasing gu ra kling fawat nia xula pira angkari, ga kling saait naandi xula pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ga vaxoxok nia xuna nua zaait guna vaxoxok mase naandi.” ");
INSERT INTO nal_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ma Iesu xa piaat kaarik naako, “A maainungang surugu xawit aaxan naandi zingbe. Ga maainung saait aaxan naandi ina dina langarin a dorang sin ubina varaviraai angkari zurugu ma dina inaxam paazaai wana nia. ");
INSERT INTO nal_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Maagu, ga maainung kuna naandi vaakdul dina zaxai, malasing saait nua gu iziar la maskaagu ma nia ga iziar la maskaam. Ma naandi zaait dina iziar lamaskana diaa xuna aubina ila pira angkari dina inaxam paazaai adu nua gu ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ga ra lis fanong aiza laba gu lis surugu zin naandi xuna dina zaxai malasing diaa di zaxai iaa. ");
INSERT INTO nal_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nia ga iziar lamaskana naandi ma nua gu iziar la maskaagu, xuna naandi dina balas saxai mase. Malasing ma aubina ila pira angkari dina rexaas adu gu ra kling fawat nia ma adu gu sasaxot naandi ina ga iziar lamaskana naandi malasing gu sasaxot nia. ");
INSERT INTO nal_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Maagu, ga saxot naandi ina gu ra lis surugu dina iziar varaxai wana nia la non ga iziar wana. Ma ga saxot dina raamin a marmari daxaiang surugu. A marmari daxaiang kanaan gu lis surugu wanaze gu sasaxot nia waamua wana nua gu giu a pira angkari. ");
INSERT INTO nal_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Maagu, nua gu tak mase. Naapalaau aubina ila pira angkari di wetexaazin nua, nia ga rexaazin nua ma naandi angkari zurugu di rexaas adu nua gu ra kling fawat nia. ");
INSERT INTO nal_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ga vatangin fanong nua zin naandi ma gana giu vauzaa nanga malasing kanaan, kuna a matmalabuk sunum iwana sasaxotang nia xana iziar lamaskana naandi ma nia zaait gana iziar lamaskana naandi.” ");
INSERT INTO nal_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Araan Iesu xa vaanong pana maainungang, naan faraxai wana ubina varaviraai zina di kas buaak a balanamaau Kidron. Laza rit a non angkanaan ka rauxin a uma olif ma naan ma ubina varaviraai zina di waan lamaskana auma angkanaan. ");
INSERT INTO nal_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judaas ina xana ngutlis Iesu zin amun purua xa rexaazin a non angkanaan, panaze faavaras faanong Iesu ma ubina varaviraai zina dit farazawaai inaan. ");
INSERT INTO nal_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judaas kat paamuin azanon ubina dauran ma amun lawaza zin amun pris laba ma amun Faarasi ma di wat la uma angkanaan. Di vazaak amun sangat ma amun laam ma amun saan iwana varopang. ");
INSERT INTO nal_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu xa rexaazin fanong amun saan faakdul xana balas sina. Malasing ma xa waan ma xa iaari zin naandi naako, “Naagu zazaleng nis?” ");
INSERT INTO nal_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Di xis naan di piaat malasing kari, “Iesu in Naazaret.” Iesu xa piaat naako, “Nia bani.” Ma Judaas a rapti ina xa ngutlis Iesu la mit amun purua xa irur zaait faraxai wana naandi. ");
INSERT INTO nal_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Araan Iesu xa piaat naako, “Nia bani,” di zuxa uli ma di zu wizik paanaburut pana pira. ");
INSERT INTO nal_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ka iaari xaarik sin naandi naako, “Naagu zazaleng nis?” Ma di piaat malasing kari, “Iesu in Naazaret.” ");
INSERT INTO nal_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu xa piaat naako, “Ga vazei vanong nim adu nia bani. Tamon naagu zazaleng nia, naagu luaa ubina angkari dina waan.” ");
INSERT INTO nal_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Azaan angkanaan ka balas malasing ma a dorang sina naa ra tabung piaat ka balas faaratunaan. A dorang ka malasing kari, “Kawit ga vamilung tazaxai zin naandi gu ra lis surugu.” ");
INSERT INTO nal_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saaimon Pita xa rauxin a baainaat. Ka urif luk ma xa kip psin alnga la mit sazaxa zin a iaana kilaaiang sin a waamua zin amun pris faakdul. (Aizina a iaana kilaaiang kanaan Maalkus.) ");
INSERT INTO nal_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iesu xa vazei Pita naako, “Tasin faulin a baainaat lamaskana wakpaakna. Malasing faa, xawit nat faraxas gana imin pana a win imiminang Maagu xa ra lis surugu?” ");
INSERT INTO nal_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Naanaan ubina dauran ma a waamua zin naandi ma amun lawaza zin amun Judaa di zaraak Iesu ma di zaxir naan pana a iaarus. ");
INSERT INTO nal_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ma di tabung saxot naan ka waan sin Aanaas. Aanaas naan aimung sin Kaaiapaas ma Kaaiapaas naan a waamua zin amun pris faakdul la maariaas angkanaan. ");
INSERT INTO nal_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Naan Kaaiapaas bani ina xa ra wurus amun paamua zin amun Judaa adu xana daxa tamon a rapti be azaxai xana zuruk a kiaana amun Judaa ma xana maat aaxa naandi vaakdul. ");
INSERT INTO nal_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saaimon Pita nandiaa aza rapti varaviraai zin Iesu di los iaa Iesu. A rapti varaviraai angkanaan, a waamua zin amun pris faakdul xa rexaazin naan, malasing ma naan ka albis faraxai wana Iesu xu lamaskana rabaraau iwana a vaal laba zin a waamua angkanaan. ");
INSERT INTO nal_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Singsaxai Pita xa irut simbang lamanar lapaara mara. A rapti varaviraai ina a waamua zin amun pris faakdul xa rexaazin naan, ka uli ma xa dador zin a ravin kat katkatong a mara ma xa zaxot falbis Pita. ");
INSERT INTO nal_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","A ravin kat katkatong a mara xa iaari zin Pita naako, “Iaak nua zaait aza rapti varaviraai zin a rapti angkanaan?” Pita xa xis naan naako, “Kawit, nia xawit.” ");
INSERT INTO nal_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A bina xa milaatus ma amun iaana kilaaiang ma amun lawaza, di sung axaiaf ma di irur varaxulin ma dit maadur. Pita zaait ka irur varaxai wana naandi ma xat maadur. ");
INSERT INTO nal_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","La raan angkanaan a waamua zin amun pris faakdul xa iaari zin Iesu wana ubina varaviraai zina ma amun faraviraaiang sina. ");
INSERT INTO nal_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu xa xis naan naako, “Ga rat firaai aubina vaakdul la maravas. Gat faraviraai bulaai lamaskana amun faal a maainungang sin amun Judaa o lamaskana a rabaraau ila vaal xoxok, ma la amun non amun Judaa dit balas fatu wana. Kawit gai piaat funfunin ta dorang. ");
INSERT INTO nal_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kunaze gu iaari zurugu? Gu iaari zin naandi dit langarin a dorang surugu. Faaratunaan, di rexaazin aze ga ra ipiaat.” ");
INSERT INTO nal_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Araan Iesu xa piaat malasing kanaan, aza lawaza ina xa irur vaasilik ka rabaaf naan ma xa piaat naako, “Naan awat matmalabuk angkanaan guna xis a waamua zin amun pris faakdul wana?” ");
INSERT INTO nal_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu xa xis naan naako, “Tamon ga piaat a dorang ka raksaat, gu pitfiaat aze xa raksaat pana. Singsaxai tamon ga piaat a dorang ka vaaratunaan, kunaze gu rabaaf nia?” ");
INSERT INTO nal_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","A iaarus di zaxir Iesu wana xa iziar nanga ma Aanaas ka kling naan ka waan sin Kaaiapaas, a waamua zin amun pris faakdul. ");
INSERT INTO nal_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Araan Saaimon Pita xa irut maadur di iaari zina malasing kari, “Iaak nua zaait aza rapti varaviraai zina, aan?” Ka wispuk naako, “Kawit, nia xawit.” ");
INSERT INTO nal_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Azaxai zin amun iaana kilaaiang sin a waamua zin amun pris faakdul, a taaua rapti angkari Pita xa ra kip psin alngana, xa piaat naako, “Iaak ga ra raamin nua varaxai wana naan la uma olif, aan?” ");
INSERT INTO nal_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita xa wispuk kaarik, ma la non taan angkanaan mase a uraa xa kaakaluk. ");
INSERT INTO nal_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Paanaraan gufguf mase amun paamua zin amun Judaa di luaa Kaaiapaas ma di zaxot Iesu xa waan la vaal laba zin a rapti in Rom ina Siza xa kalin naan ka waamua zin amun Judaa. Singsaxai tamon naandi nanga di albis lamaskana a vaal angkanaan, dina balas mitikaai lawaana amun lus sin naandi. Malasing ma xawit di albis, panaze di saxot dina iaan a vanganang La Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Malasing ma Paailat, naan a waamua angkanaan, ka tukbilak puat sin naandi ma xa iaari naako, “Aze ramun saan mase naagu vakor a rapti angkari wana?” ");
INSERT INTO nal_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Di xis naan malasing kari, “Tamon naan ka lek pen giu ta matmalabuk taksaat, maadi lek pen saraak lis fawat naan sunum.” ");
INSERT INTO nal_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paailat ka piaat naako, “Naagu zaxot naan ma naagu klis naan pana amun lus sinim nanga.” Amun paamua zin amun Judaa di piaat malasing kari, “Singsaxai amun lus sinim ka waakol maam adu maadina wen sop famaat taxazak.” ");
INSERT INTO nal_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Azaan angkanaan ka balas kuna a dorang Iesu xa ra ipiaat pana awat maatang sina xana balas faaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Paailat ka albis puli lamaskana a vaal laba zina. Ka viring Iesu ma xa iaari zina naako, “Nua a xalxaal zin amun Judaa aan?” ");
INSERT INTO nal_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu xa iaari uli zina naako, “Malasing faa, ainaxamang sunum nanga o azanon di vazei nua wana nia?” ");
INSERT INTO nal_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paailat ka xis naan naako, “Nia xawit a rapti Judaa. Aubina zunum faatak ma amun pris laba zinim nanga di zaraak lis fawat nua zurugu. Aze razaan gu giu?” ");
INSERT INTO nal_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu xa piaat naako, “A bikabar zurugu xawit initiat la pira angkari. Tamon initiat la pira angkari, amun iaana kilaaiang surugu di lek farop kol nia xuna tuaa amun paamua zin amun Judaa dina zaraak nia. A bikabar zurugu xawit initiat.” ");
INSERT INTO nal_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Paailat ka piaat naako, “Malasing ma nua a xalxaal, aan!” Iesu xa xis naan naako, “Nua nanga gu piaat adu nia a xalxaal. Di luk nia ma ga wat la pira angkari xuna pitfiaatang a dorang faaratunaan. Aubina vaakdul ina dit falos a dorang faaratunaan dit langar zurugu.” ");
INSERT INTO nal_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Paailat ka iaari zina naako, “Aze razaan mase a dorang faaratunaan?” Naan ka piaat fanong ma xa waan lamanar xaarik sin amun Judaa ma xa piaat malasing kari, “Kawit ga tangin ta vuvuna a maravanang pana naan. ");
INSERT INTO nal_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Singsaxai naagu rauxin a rataawuka nim La Raan Laba Iwana Zangas Fasaalang. Gat familuaar lis a rapti azaxai ina xa iziar wana vaamaazikang ka waan sinim. Malasing ma iaak naagu saxot gana vamiluaar lis ‘A xalxaal zin amun Judaa,’ aan?” ");
INSERT INTO nal_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Di xupkup puli malasing kari, “Kawit, naan kawit! Lis fawat Baarabaas simaam!” Baarabaas naan a rapti xat farop ma xat finaau. ");
INSERT INTO nal_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Naanaan Paailat ka kling ubina dauran ma di zaxot Iesu ma di kmis naan pana wip. ");
INSERT INTO nal_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Di kos a iaarus koxot malasing a lawilot ma di rasin la waatna. Di vamamaus naan pana a marapi xa raubung ");
INSERT INTO nal_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ma di vis naan malasing kari, “A varanopang lamaraam, a xalxaal zin amun Judaa!” Ma di rabaaf naan. ");
INSERT INTO nal_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma Paailat ka tukbilak kaarik ma xa vazei amun Judaa naako, “Naagu raamin. Ga zaxot fatukbilok naan lamarana nim kuna naaguna rexaas adu xawit ga tangin ta vuvuna a maravanang pana naan.” ");
INSERT INTO nal_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iesu xa tukbilak faraxai wana a lawilot ka xoxorang la waatna ma xa valaak a marapi baraaf ka raubung, ma Paailat ka piaat naako, “Naan a rapti xari!” ");
INSERT INTO nal_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Araan amun pris laba ma amun lawaza zin naandi di raamin naan, di xupkup malasing kari, “Tuk fating naan pana a robuxul! Tuk fating naan pana a robuxul!” Singsaxai Paailat ka vazei naandi naako, “Naagu zaxot naan ma naagu tukfating naan pana a robuxul. Kawit ga tangin ta vuvuna a maravanang pana naan.” ");
INSERT INTO nal_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Amun paamua zin amun Judaa di xis naan malasing kari, “Maadi rauxin aza lus ma a lus angkanaan ka piaat adu naan kana maat, panaze xa kalin adu naan Naata Nakmai.” ");
INSERT INTO nal_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Araan Paailat ka langarin a dorang kanaan, naan ka vut maraaut laxo, ");
INSERT INTO nal_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ma xa albis puli xu lamaskana a vaal laba ma xa iaari zin Iesu malasing kari, “Nua inifaa?” Singsaxai Iesu xawit na xis ta waaling sina. ");
INSERT INTO nal_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Paailat ka iaari zina naako, “Malasing faa, gu baai guna dador zurugu? Iaak kawit gu raamin fakilaan adu nia ga rauxin a burburaaiang kuna vamiluaarang nua o xuna tukfatingang nua laaxur wana a robuxul?” ");
INSERT INTO nal_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu xa xis naan naako, “Gu lek pen tauxin a burburaaiang laaxur wana nia tamon Nakmai xa lek pen lis sunum. Malasing ma axazak ina xa lis nia la mirum, a matmalabuk taksaat sina xa laaup pana zunum.” ");
INSERT INTO nal_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Araan Paailat ka langarin, ka zaleng ta lan kuna vamiluaarang Iesu, singsaxai amun Judaa dit kupkup malasing kari, “Tamon guna vamiluaar a rapti angkari, nua xawit a paasaxo zin Siza. Axazak ina xa kalin adu naan a xalxaal, naan a purua zin Siza.” ");
INSERT INTO nal_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Araan Paailat ka langarin, ka zaxot fatukbilok Iesu. Paailat ka waan ma xa iziar wana a baang sin a waamua iwana aikilizang a dorang. A baang ka iziar la non di vakilaan, “A Laana Vaat” (ma wana a linga bina Ibru di vakilaan Gaabataa). ");
INSERT INTO nal_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A raan angkanaan a raan iwana nimnimanang kuna A Raan Laba Iwana Zangas Fasaalang. A marana iaas ka malasing ka zangaaflu ma urua lawaanaas. Paailat ka piaat sin amun Judaa naako, “A xalxaal zinim kari.” ");
INSERT INTO nal_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Singsaxai di xupkup malasing kari, “Saxot pizin naan! Saxot pizin naan! Tukfating naan pana robuxul!” Paailat ka iaari zin naandi naako, “Malasing faa, naagu saxot gana tukfating a xalxaal zinim laaxur wana a robuxul?” Amun pris laba di piaat malasing kari, “Kawit maadi rauxin kaarik taza xalxaal, Siza zingbe azaxai.” ");
INSERT INTO nal_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Malasing ma Paailat ka lis Iesu la mita naandi xuna dina tukfating naan laaxur wana robuxul. Ubina dauran di zaxot Iesu ma di waan. ");
INSERT INTO nal_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ka vazaak a robuxul zina nanga ma xa waan la non di vakilaan, “A Non Iwana Barang.” (Wana a linga Ibru di vakilaan Golgaata.) ");
INSERT INTO nal_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Inaan di tuk fating naan pana robuxul. Di tukfating saait uru rapti wana uru robuxul, di ratokaai iaa la uritna ma Iesu xa rokaai la birua. ");
INSERT INTO nal_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paailat ka vazei naandi ma di varaar aza waan dorang ma di varokin pana robuxul. A dorang kanaan ka malasing kari, “Iesu in Naazaret, a Xalxaal zin amun Judaa.” ");
INSERT INTO nal_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Amala aubina di vakot a dorang kanaan, panaze a non Iesu xa rokaai wana xa iziar lapaara bina laba, ma a dorang kanaan di varaar wana a linga bina in Ibru ma Laatin ma Grik. ");
INSERT INTO nal_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Amun pris laba xawit di nanam ma di vazei Paailat malasing kari, “Tuaa gu varaar, ‘A xalxaal zin amun Judaa,’ singsaxai malasing kari, ‘A rapti angkari xa kalin adu naan a xalxaal zin amun Judaa.’ ” ");
INSERT INTO nal_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Paailat ka xis a dorang naako, “Aze razaan ga varaar vanong kana iziar malasing ga varaar vanong.” ");
INSERT INTO nal_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Araan ubina dauran di tukfating fanong Iesu, di zuruk amun marapi zina ma di vatawaraxin pana unon talavaat lawalau a naandi zaksaxai singsaxai a marapi ilamaskana xa iziar nanga. A marapi angkanaan kawit na rauxin ta non di zaxazit faraxinang pana. Di vir wana a waan marapi a waasaxai be, di varumarain laaxur ma xa wizik sazal waanaburut. ");
INSERT INTO nal_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Di piaat lawalaua naandi malasing kari, “Tuaa dina taar. Dia dina raktaak pana xuna dina raamin nis mase xana zuruk.” A matmalabuk angkanaan ka balas malasing ma a dorang lamaskana a Baar Xoxok ka balas faaratunaan. A dorang kanaan ka malasing kari, “Di vatawaraxin amun marapi zurugu lawalaua naandi ma dina raktaaxin amun marapi zurugu xuna raaminang nis kana zuruk.” Ma naan a matmalabuk angkanaan ubina dauran di vabalos. ");
INSERT INTO nal_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Naanaa zin Iesu ma duaana naanaa zina ma Maaria taak sin Klopaas ma Maaria in Maakdaalaa di irur lapaara robuxul zin Iesu. ");
INSERT INTO nal_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesu xa raamin naanaa zina inaan ma a rapti varaviraai naai sasaxot ka irur la paarana, ma xa piaat sin naanaa zina naako, “Naang, naan kanaan a nalik sunum,” ");
INSERT INTO nal_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ma xa vazei a rapti varaviraai naako, “A ravin angkanaan naan naanaa zunum.” La non taan angkanaan a rapti varaviraai xa zaxot naanaa zin Iesu xula vaal zina ma xa xatkatong naan. ");
INSERT INTO nal_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lamur, Iesu xa rexaas adu amun saan faakdul xa vaanong ka, malasing ma xa piaat naako, “Ga maaru.” Ka piaat a dorang kanaan kuna a dorang lamaskana a Baar Xoxok kana balas faaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ka rauxin a sopen waain mawaak ka iziar la non angkanaan, malasing ma di burung a spaans lamaskana, ma araan a spaans ka bas, di pis fating laaxur wana a vang iaai a isop ma di rasin fauzaa la nguza Iesu. ");
INSERT INTO nal_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesu xa imin ma xa piaat naako, “Ka vaanong ka.” Ma a waatna xa zoluaai ma xa vamiluaar psin a laklagaaina. ");
INSERT INTO nal_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A raan angkanaan, a raan a nimnimanang panaze a raan lamuraana, a Saabat. Ma a Saabat angkanaan saait kana balas adi raan laba mase. Amun paamua zin amun Judaa di iaari zin Paailat kuna buaakang a xaaka aubina di rokaai wana robuxul xuna dina maat fazaaus ma dina waapizin naandi, wanaze xawit di saxot dina luaa aubina di maat dina rokaai wana amun robuxul la raan a Saabat. ");
INSERT INTO nal_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ubina dauran di wat buaak amun kaaka rapti wana aza rita Iesu ma mur zin axazak. ");
INSERT INTO nal_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Di wat sin Iesu singsaxai di tangin adu naan ka maat faanong malasing ma xawit di buaak amun kaakna. ");
INSERT INTO nal_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Singsaxai axazak sin ubina dauran ka zaxa a zuruna Iesu wana a bili. Fazaaus mase a dari ma a daanim ka zaal. ");
INSERT INTO nal_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A rapti ina xa ra raamin azaan angkanaan ka pitfiaat fanong amun saan naa raamin ma amun dorang naa ipitfiaat ka vaaratunaan mase. Naan ka rexaas adu naan ka ipitfiaat a dorang faaratunaan, ma naa ipitfiaat kuna nim saait naaguna inaxam paazaai. ");
INSERT INTO nal_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Amun saan angkanaan ka balas malasing ma a dorang lamaskana Baar Xoxok ka balas faaratunaan. A dorang ka malasing kari, “Kawit ta ruaana xana raabuak,” ");
INSERT INTO nal_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ma malasing saait aza waan dorang naako, “Dina raamaai wana naan ina di ra zaxa.” ");
INSERT INTO nal_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lamuraana, Iosep ila bina laba Aarimaatiaa xa iaari zin Paailat kuna vaziaap lukang Iesu ina xa maat faanong. Iosep naan aza rapti varaviraai zin Iesu, singsaxai a inaxam paazaaiang sina xa vunfunaai wanaze xa marauring amun paamua zin amun Judaa. Paailat ka rudaxa wana Iosep kana vaziaap luk Iesu ma naan ka vaziaap luk Iesu ma xa waan. ");
INSERT INTO nal_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas ka wat faraxai wana Iosep. Naan saait ka ra wat paamua labung ma xa raamin Iesu. Naan ka zuruk fawat a laas mikuf ina azanon di plaas pana a bulut iwana uru iaai di vakilaan a mar ma a aaloi. A maravanang iwana xa malasing a zangaaflu vaarul a kilogrem. ");
INSERT INTO nal_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Iosep ma Nikodimas di raxut iaa Iesu, ma di xavut iaa naan pana amun marapi vaaxur ma a laas mikuf. Di giu lalos a rataawuk amun Judaa araan di nimnimanin a maat kuna atkaavaaiang. ");
INSERT INTO nal_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","La non di ra tuk fating Iesu xa rauxin a uma, ma lamaskana a uma angkanaan ka rauxin a baaul a maat faaxur, xawit nanga ta maat di ra vatate inaan. ");
INSERT INTO nal_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Di vatate iaa Iesu inaan panaze a raan angkanaan a raan a nimnimanang pana a Saabat sin amun Judaa, ma di saxot dina vatate vazaus a maat paamua wana a Saabat kana balas, ma a baaul a maat ka vaasilik be. ");
INSERT INTO nal_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Paanaraan gufguf la varumaraiang a raan iwana a wik ma xa suk nanga, Maaria in Maakdaalaa xa wat la baaul a maat ma xa raamin a vaat di wul psin lamarana luk. ");
INSERT INTO nal_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Malasing ma naan ka valaau waan sin Saaimon Pita ma aza rapti varaviraai Iesu xai sasaxot ma xa piaat naako, “Di zuruk pizin fanong a Piran lamaskana a baaul a maat, ma xawit maadi rexaas aze ra non di vamaal naan pana!” ");
INSERT INTO nal_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Malasing ma Pita ma a rapti varaviraai angkanaan di ramaraat iaa xuna waanang la baaul a maat. ");
INSERT INTO nal_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Di valvalaau iaa be, singsaxai a rapti varaviraai angkanaan ka valau waamuin Pita ma xa tabung balas la baaul a maat. ");
INSERT INTO nal_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Naan ka zundung ma xa raamaai waan lamaskana a baaul a maat ma xa raamin amun marapi di fluzang Iesu xa imamaal inaan, singsaxai naan kawit na albis. ");
INSERT INTO nal_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Naanaan Saaimon Pita ina xa wat lamuraana, xa balas ma xa albis lamaskana a baaul a maat. Naan ka raamin amun marapi xa imamaal inaan, ");
INSERT INTO nal_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma xa raamin saait aza waan marapi ina di ra pis kolang a waata Iesu. A marapi angkanaan di flus parok nanga, ma xawit na imaal varaxai wana uza waan. ");
INSERT INTO nal_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Naanaan a rapti varaviraai ina xa tabung balas paamua la baaul a maat ka albis saait. Ka raamin amun saan angkanaan ma xa inaxam paazaai. ");
INSERT INTO nal_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Kawit nanga di mazaam iaa a dorang ilamaskana a Baar Xoxok adu Iesu xana ramaraat puli wana maatang.) ");
INSERT INTO nal_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Naanaan uru rapti varaviraai di uli iaa xu la bina. ");
INSERT INTO nal_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Singsaxai Maaria xa irur rataangis lamanar la baaul a maat. Araan ka rataangis, ka zundung ma xa raamaai xu lamaskana a baaul a maat. ");
INSERT INTO nal_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ka raamin a aangelo urua di valaak iaa amun marapi xufkuf. Di iziar iaa la non di ra vamaal Iesu wana, axazak ka iziar la kiaana waatna ma axazak ka iziar la kiaana uru xaakna. ");
INSERT INTO nal_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Di iaari iaa zina malasing kari, “Diravin, kunaze gu raangis?” Naan ka piaat naako, “Di zuruk pizin a Piran surugu, ma xawit ga rexaas di vatate naan faa.” ");
INSERT INTO nal_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Naanaan ka rutaawuk ma xa raamin Iesu xa irur inaan, singsaxai xawit na raamin fakilaan adu naan Iesu. ");
INSERT INTO nal_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Naanaan Iesu xa iaari zina naako, “Diravin, kunaze gu raangis? Gu zazaleng nis?” Maaria xa naxaam adu a rapti xat katkatong a uma ma xa piaat naako, “Dipiran, tamon gu zuruk pizin naan, gu vazei nia gu rasin naan faa xuna gana wa zuruk naan.” ");
INSERT INTO nal_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu xa piaat sina naako, “Maaria.” Maaria xa rutaawuk ma xa piaat pana a dorang in Ibru naako, “Raaboni!” (Aknaaza waaling angkari adu Maravas.) ");
INSERT INTO nal_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu xa vazei naan naako, “Tuaa gu taaxur wana nia, wanaze xawit nanga ga uzaa zin Maagu. Singsaxai gu waan sin amun daazugu ma gu vazei naandi adu gana uzaa zin Maagu zurugu ma Damana nim saait, ma zin Nakmai zurugu ma Nakmai zinim saait.” ");
INSERT INTO nal_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maaria in Maakdaalaa xa waan sin aubina varaviraai ma xa pitfiaat sin naandi naako, “Ga raamin fanong a Piran.” Ma xa vazei zaait naandi wana amun dorang Iesu xa ra piaat sina. ");
INSERT INTO nal_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","La raan a bina xat faakilan tapti la varumaraiang a raan iwana wik aubina varaviraai di iziar varaxai lamaskana a vaal. Di baraat kol amun mara wanaze di marauring amun paamua zin amun Judaa. Ma Iesu xa balas ma xa irur lawalaua naandi ma xa vazei naandi naako, “A luaai xana iziar varaxai wana nim!” ");
INSERT INTO nal_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iesu xa piaat fanong malasing kanaan ma xa vatangin uru mitna ma a zuruna. Aubina varaviraai di nanam mase araan di raamin a Piran. ");
INSERT INTO nal_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iesu xa piaat kaarik naako, “A luaai xana iziar varaxai wana nim! Maagu xa ra kling fawat nia, malasing saait naari ga kling nim naaguna waan.” ");
INSERT INTO nal_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Naan ka piaat fanong malasing kari ma xa pivin a maaliu zina wana naandi ma xa piaat naako, “Naagu zuruk a Laklagaai a Raabu. ");
INSERT INTO nal_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tamon naagu naxaam pizin amun matmalabuk taksaat sin aubina, Nakmai xana naxaam pizin amun matmalabuk taksaat sin naandi. Ma tamon kawit naagu naxaam pizin amun matmalabuk taksaat sin naandi, Nakmai xana wen naxaam pizin amun matmalabuk taksaat sin naandi.” ");
INSERT INTO nal_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Naari Tomaas (aza izina Didimas) axazak sin ubina varaviraai di zangaaflu ma urua, xawit na iziar varaxai wana naandi araan Iesu xa ra balas. ");
INSERT INTO nal_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Azanon ubina varaviraai di vazei naan malasing kari, “Maadi raamin fanong a Piran!” Singsaxai Tomaas ka vazei naandi naako, “Tamon kawit ga raamin a kiaana amun nil la uru mitna ma xawit ga rasin a klus mirugu la kiaana amun nil, ma tamon kawit ga rasin a mirugu la zuruna, gana wen inaxam paazaai.” ");
INSERT INTO nal_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A wik lamuraana aubina varaviraai zina di iziar xaarik lamaskana a vaal, ma Tomaas saait faraxai wana naandi. Iesu xa balas sin naandi naapalaau di baraat kol amun mara. Ka rur lawalaua naandi ma xa piaat naako, “A luaai xana iziar varaxai wana nim!” ");
INSERT INTO nal_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma xa vazei Tomaas malasing kari, “Tasin a klus mirum iriat. Taamin uru mirugu. Tasin fatok fawat a mirum la zurunugu. Tuaa gu rauxin ainaxamang urua. Gu inaxam paazaai be.” ");
INSERT INTO nal_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaas ka piaat sina naako, “Nua a Piran surugu ma nua Nakmai zurugu!” ");
INSERT INTO nal_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Naanaan Iesu xa vazei naan naako, “Gu inaxam paazaai wanaze gu raamin fanong nia. Naandi ina xawit di raamin nia ma di inaxam paazaai, Nakmai xa lis a daxaiang sin naandi.” ");
INSERT INTO nal_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu xa vabalos nanga azanon faakilanang ka varas lamarana aubina varaviraai zina, singsaxai a dorang pana naandi xawit na iziar lamaskana a baar angkari. ");
INSERT INTO nal_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Singsaxai azanon faakilanang ka iziar lamaskana a baar angkari xuna naaguna inaxam paazaai adu Iesu naan a Mesaaia, Naata Nakmai, ma tamon naagu inaxam paazaai naaguna rauxin a roro tapal lamaskana aizina. ");
INSERT INTO nal_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lamur Iesu xa balas kaarik sin ubina varaviraai zina lapaara Laman Tiberiaas, aza izina a Laman Gaalili. Ka balas malasing kari, ");
INSERT INTO nal_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saaimon Pita ma Tomaas (aza aizina Didimas), ma Naatanaael ila bina Kaanaa la pira Gaalili, ma uru naata Zebedi, ma uzaru rapti varaviraai di iziar varaxai. ");
INSERT INTO nal_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saaimon Pita xa vazei naandi naako, “Gana wa vaaian,” ma di piaat malasing kari, “Maadina wat faraxai wana nua.” Naanaan di waan ma di xawaas a mon, singsaxai di vaagof mase labung angkanaan. ");
INSERT INTO nal_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Paanaraan gufguf mase, Iesu xa irur laxon, singsaxai ubina varaviraai xawit di raamin fakilaan adu naan Iesu. ");
INSERT INTO nal_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Naan ka viraai waan sin naandi naako, “Malasing faa, naam nalik, naagu waaluk ta ian?” Ma naandi di xis naan malasing kari, “Kawit.” ");
INSERT INTO nal_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma naan ka vazei naandi naako, “Naagu psin aubina la mit sazaxa iwana mon ma naaguna tangaai.” Di giu malasing naa piaat singsaxai xawit nat faraxas dina urif fawat aubina lamaskana a mon panaze amun ian ka varas marazaat. ");
INSERT INTO nal_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","A rapti varaviraai ina Iesu xa sasaxot ka vazei Pita naako, “A Piran taan!” Araan bani Saaimon Pita xa langarin naan ka piaat naako, “A Piran taan,” ka valaak faulin a marapi baraaf sina ilamanar, avuna naa ra gamul psin, ma xa fida lamaskana daanim ma xa kakas paan laxon. ");
INSERT INTO nal_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Azanon ubina varaviraai di los naan pana a mon ma dit purif saait aubina xa bas pana amun ian. Kawit di lawalaau wana axon, ka malasing a mita xa zangaaflu vaa zangaaflu. ");
INSERT INTO nal_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Naandi di xozaraai laxon ma di raamin amun kalaflar xa ingingat inaan ma amun ian lamarana, ma amun raraba zaait ka iziar. ");
INSERT INTO nal_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu xa vazei naandi naako, “Naagu waaluk fawat azanon ian ina naagu samura zuruk.” ");
INSERT INTO nal_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Malasing ma Saaimon Pita xa vaani wana a mon ma xa urif aubina xu laxon. Aubina xa bas mase wana amun ian laba, amun ian ka 153. Singsaxai naapalaau amun ian ka varas marazaat, aubina xawit na ramatar. ");
INSERT INTO nal_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu xa piaat sin naandi naako, “Naagu wat fangan.” Ubina varaviraai di maraaut kuna iaariang malasing kari, “Nua nis?” Avuna di rexaas faanong adu naan a Piran. ");
INSERT INTO nal_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu xa wat ma xa zuruk amun raraba ma xa lis sin naandi, ma naa giu zaait malasing kanaan pana amun ian. ");
INSERT INTO nal_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Naari a varulang ka a raan Iesu xa balas sin ubina varaviraai zina lamuraana xa ramaraat puli wana maatang. ");
INSERT INTO nal_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iesu ma ubina varaviraai zina di vangan faanong ma xa iaari zin Saaimon Pita malasing kari, “Saaimon naata Jon, iaak a sasaxotang sunum pana nia xa laaup pana a sasaxotang sin naandi angkari wana nia aan?” Naan ka piaat naako, “Aiang Piran, gu rexaas adu ga sasaxot nua.” Iesu xa piaat naako, “Gu vavangaan amun naata sipsip surugu.” ");
INSERT INTO nal_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iesu xa piaat kaarik sina naako, “Saaimon naata Jon, iaak gu sasaxot nia aan?” Naan ka xis Iesu malasing kari, “Aiang Piran, gu rexaas adu ga sasaxot nua.” Iesu xa piaat sina naako, “Gu xatkatong amun sipsip surugu.” ");
INSERT INTO nal_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A varulang a raan Iesu xa iaari zina naako, “Saaimon naata Jon, iaak gu sasaxot nia aan?” Pita xawit na nanam panaze Iesu xa varul aiaariang sina naako, “Iaak gu sasaxot nia aan?” Pita xa piaat sina naako, “Piran, gu rexaazin amun saan faakdul, gu rexaas adu ga sasaxot nua.” Iesu xa piaat sina naako, “Gu vavangaan amun sipsip surugu. ");
INSERT INTO nal_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ga vazei varatunaan mase nua, araan gu xulaau, nua nanga gut famamaus a winpinum ma gu wanpaan la aze ra non gu saxot. Singsaxai araan gu baiak ka, guna lis uru mirum, ma axazak tawarak kana vamamaus nua ma xana zaxot nua xula non ina xawit gu saxot guna waan pana.” ");
INSERT INTO nal_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu xa piaat malasing kanaan kuna vatanginang Pita xana maat malasing faa xuna xana valaup aizina Nakmai. Naanaan ka piaat sin Pita naako, “Gu los nia!” ");
INSERT INTO nal_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita xa rutaawuk ma xa raamin a rapti varaviraai ina Iesu xa sasaxot kai los naandi. (Naan axazak angkanaan ina xa ra zivaraaskal wana Iesu araan di vangan ma xa iaari naako, “Piran nis kana ngutlis nua zin amun purua?”) ");
INSERT INTO nal_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Araan Pita xa raamin naan, ka iaari zin Iesu naako, “Piran, malasing faa wana a rapti angkari?” ");
INSERT INTO nal_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu xa xis naan naako, “Tamon ga saxot naan kana izi roro xa ruaas gana uli wat, iaak kawit azaan sunum? Gu los nia.” ");
INSERT INTO nal_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pana awat dorang kanaan, a dorang ka valaau lawalau amun fandaas adu a rapti varaviraai angkanaan kana wen maat. Singsaxai Iesu xawit na piaat adu a rapti varaviraai angkanaan kana wen maat. Ka piaat be naako, “Tamon ga saxot naan kana izi roro xa ruaas gana uli wat, iaak kawit azaan sunum?” ");
INSERT INTO nal_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nia a rapti varaviraai angkanaan ina xai pitfiaat amun saan faakdul angkanaan ma naat faraar vating. Dia di rexaas adu amun dorang sina xa vaaratunaan. ");
INSERT INTO nal_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu xa ra gigiu vabalos saait azanon saan nanga xa varas. Tamon amun saan faakdul angkanaan di lek faraar vating, ga naxaam adu a pira angkari xa lek pen tauxin ta non marapalau xuna rasinang amun baar angkari di ra varaar. ");
INSERT INTO nal_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","A dorang kari xa waan sunum, Tiofilas. Lamaskana a baar zurugu iwaamua ga ra farar vaamaravas sunum pana amun saan faakdul Iesu xa ra giu ma naa ra varaviraai wana. Naa varumarain la raan angkanaan naan ka varamaraat amun faamuzazang sina, ");
INSERT INTO nal_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","xa ruaas la raan Nakmai xa zaxot luk naan kunikula la lia. Naan kawit nanga na uzaa ikula la lia, ma wana a dikdikang sin a Laklagaai a Raabu, xa vazei amun aaposal zina wana aze ramun saan naadina giu. Naandi ubina naan ka ra kalin luk naandi. ");
INSERT INTO nal_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Naan ka ra vazaak adi maazikang ma xa maat, ma lamuraana, lamaskana amun taan ka zangaaflu vaaralavaat, ka ra balas sin amun aaposal zina ma xa vatangin amun saan ka varas lamarana naandi xuna viaatang adu naan faaratunaan ka roro uli vaanong siaana maatang, ma xa dador zin naandi wana a bikabar zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Aza raan ka izi vavangan faraxai wana naandi ma xa dador dikdik malasing kari, “Tuaa naaguna ramaraat fataling a bina laba Jerusalem. Naaguna zimbong a talazang Maagu xa ra xalxal wana, malasing naagu ra langarin ga dador vaanong sinim pana. ");
INSERT INTO nal_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ka ra baaptaais aubina wana daanim, singsaxai xana wen faabung baraaf ma Nakmai xana baaptaais nim pana a Laklagaai a Raabu.” ");
INSERT INTO nal_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aza raan amun aaposal di ra iziar varaxai wana Iesu ma di iaari zina malasing kari, “Piran, malasing faa, guna vabalos maam amun Israael maadina balas a bikabar zimaam nanga lamun taan angkari?” ");
INSERT INTO nal_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu xa xis naandi malasing kari, “Maagu nanga xa kalin fanong a raan ina aze razaan kana balas pana, ma xawit nat faraxas naaguna rexaazin. ");
INSERT INTO nal_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Singsaxai nim naaguna zuruk a dikdikang araan a Laklagaai a Raabu xana iziar wana nim, ma naaguna pitfiaat nia zin naandi aubina in Jerusalem, ma ilamun bina vaakdul la uru pira Judia ma Samaaria, ma ila amun non faakdul zaait la pira angkari.” ");
INSERT INTO nal_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lamuraana dorang kanaan sina, Nakmai xa zaxot luk naan lamarana naandi xunikula la lia ma a bara xa waakol naan ma xawit kaarik di raamin luk naan. ");
INSERT INTO nal_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Araan Iesu xa uzaa nanga, naandi di rataamaai dikdik puzaa nanga laaxur nana mof, ma fazaaus mase uru rapti di valaak iaa amun mamaauzang kufkuf di wat irur iaa lapaara naandi. ");
INSERT INTO nal_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma di piaat iaa malasing kari, “Naam ubina in Gaalili, xunaze naagu irur rataamaai uzaa laaxur nana mof? Iesu angbani ina Nakmai xa zaxot luk naan siaana nim kunikula la lia, naan kana uli zaait pana a lan angbani malasing be naagu raamin naan ka uzaa laaxur la lia.” ");
INSERT INTO nal_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mur amun aaposal di luaa a nan paatawut angkanaan ma di uli waan Jerusalem. Aizina a wut angkanaan di vakilaanang a Waatawut Olif, ka iziar lapaara Jerusalem. ");
INSERT INTO nal_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Di albis la bina laba angkanaan ma di laak puzaa laaxur la vaal naandi di iziar wana. Naandi di iziar la notaan angkanaan aizina naandi xari: Pita ma Jon ma Jems ma Endru ma Filip ma Tomaas ma Baatalomeu ma Metiu ma Jems naata Aalfias ma Judaas naata Jems ma Saaimon, sin a lemlem Zelot. ");
INSERT INTO nal_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Naandi dit fatu bulaai varaxai wana maainungang malasing a lemlem azaxai, varaxai wana a furavin ma Maaria naanaa zin Iesu ma amun daasna. ");
INSERT INTO nal_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Aza raan aubina di inaxam paazaai di balas fatu. Naandi di zangaaflu varazuai ma a zangaaflu vaarua. Ma Pita xa ramaraat lawalaua naandi ");
INSERT INTO nal_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ma xa vazei naandi naako, “Amun taatum lamaskana Kaarisito, a dorang lamaskana a Baar Xoxok ka balas faaratunaan, malasing be a Laklagaai a Raabu xa pitfiaat lamaskana a dorang sin Dewit, pana Judaas naan a rapti xa waamuain aubina ina di ra zaraak fating Iesu. ");
INSERT INTO nal_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judaas naan azaxai zin dia ma xat faamuzas faraxai wana dia.” ");
INSERT INTO nal_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judaas ka zuruk a wulwulang iwana a matmalabuk taksaat sina, ma xa wul luk a non pira mumut pana. Naan ka zu inaan ma a xuna xa ramatar ma a xuliwung sina xa tukbilak puat lamanar. ");
INSERT INTO nal_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma aubina vaakdul di ra iziar inaan Jerusalem, di langarin azaan angkanaan ma di vakilaan a non pira angkanaan pana a linga bina zin naandi vaatak adu Akeldaamaa. Aknaaza waaling angkari adu, “A Non Pira iwana Dari.”) ");
INSERT INTO nal_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ma Pita xa piaat saait naako, “Lamaskana a Baar Saam, di varaar malasing kari, ‘A vaal zina xana izi walaau, ma xana wen tauxin taxazak kana raagul lamaskana.’ Ma laza non ka piaat naako, ‘Axazak tawarak kana vazaak luk a vaamuzazang sina.’ ");
INSERT INTO nal_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Malasing ma naari dia xa dina kalin taxazak sin ubina ina di ra iziar bulaai varaxai wana dia, lamun taan a Piran Iesu xa zazangas farawuk faraxai wana dia, ");
INSERT INTO nal_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","la notaan nanga Jon ka baaptaais Iesu ma xa ruaas la raan Nakmai xa zaxot fauzaa naan kunikula la lia. Ma naan kana vazaak luk a vaamuzazang sin Judaas. Axazak angkanaan kana vaamuzas faraxai wana dia ma xana pitfiaat a dorang iwana ramaraat puliang sin Iesu.” ");
INSERT INTO nal_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Malasing ma naandi di kalin uru rapti, Iosep, dit fakilaan naan Baarsabaas, (ma aza izina Jaastas) ma Maatiaas. ");
INSERT INTO nal_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Naanaan di maainung ka ma di piaat malasing kari, “Piran gu rexaazin a inaxamang sin aubina vaakdul. Gu vatangin lis simaam nis sin nandiaa uru rapti angkari gu ra kalin, ");
INSERT INTO nal_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kuna xana vazaak luk a vaamuzazang sin a aaposal ina Judaas ka vataling kuna waanang la non Nakmai xa nimnimanin aaxana.” ");
INSERT INTO nal_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ma di raktaaxin amun faat ma a vaat sin Maatiaas ka tabung su wana pira, malasing ma naan ka albis faraxai wana naandi di zangaaflu ma azaxai. ");
INSERT INTO nal_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","A raan laba iwana lotu di vakilaan a Pentikos ka balas. Aubina vaakdul di inaxam paazaai di ra iziar varaxai lamaskana aza vaal. ");
INSERT INTO nal_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma fazaaus mase di langarin a linga zaan ka balas malasing adi maaliu laba xa wat ikula la lia, ma xa sfaar vakdul mase a vaal angkanaan naandi di iziar lamaskana. ");
INSERT INTO nal_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma di raamin azaan ka malasing amun karamana axaiaf ka balas la non angkanaan naadi iziar wana ma xai fida varawuk ma xa iziar wana naandi zaksaxai. ");
INSERT INTO nal_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A Laklagaai a Raabu xa sfaar naandi vaakdul ma dit faraxas dina wuk amun linga bina rawarak. Di wuk aze ra linga bina a Laklagaai a Raabu xa lis sin naandi. ");
INSERT INTO nal_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","La raan angkanaan amun Judaa ina di los fatalamin Nakmai lamaskana lotu zin naandi, di wat fatu Jerusalem. Naandi ila amun non faakdul ila pira angkari. ");
INSERT INTO nal_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Araan di langarin a linga zaan angkanaan, axulutung ka balas fatu ma di banglala wanaze naandi zaksaxai di langarin amun aaposal di fazei wana a dorang sin Nakmai wana a linga bina vaatak sin naandi zaksaxai. ");
INSERT INTO nal_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Di banga mase ma di iaari malasing kari, “Malasing faa, aubina angkari di dador, naandi in Gaalili? ");
INSERT INTO nal_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ka malasing faa dia di langarin naandi di wuk amun linga bina zin dia vaatak? ");
INSERT INTO nal_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Dia xari ilamun pira in Paatia ma Midia ma Ilaam ma Mesapotaamia ma Judia ma Kaapadosia ma Pontas ma Esia ");
INSERT INTO nal_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma Frigia ma Paamfilia ma Ijip ma azanon saait ilamun non Libia lapaara Saairini ma azanon sin dia zaait kari in Rom. ");
INSERT INTO nal_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ma azanon sin dia amun Judaa, ma azanon sin dia naandi ila amun non tawarak, di zuruk ainaxam paazaaiang sin amun Judaa. Ma azanon sin dia zaait naandi ila pira Krit ma Erebia. Singsaxai dia vaakdul di langarin naandi, di wuk amun linga bina vaatak sin dia, ma di dadorin amun faaxoxovang sin Nakmai naa ra giu.” ");
INSERT INTO nal_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ma di banglala ma di baabaa. Ma di iaari varawuk sin naandi zaksaxai malasing kari, “Aze ra vuvuna azaan angkari?” ");
INSERT INTO nal_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Singsaxai azanon di vis amun aaposal, ma di piaat malasing kari, “Aubina angkari di imin famarazaat a daanim dikdik.” ");
INSERT INTO nal_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ma Pita varaxai wana a zangaaflu ma azaxai amun aaposal di irur lawalau aubina vaakdul ma naan ka dador laba zin axulutung malasing kari, “Nim amun paliaanugu amun Judaa ma nim ina naagu iziar inaan Jerusalem, naaguna langarin fatalamin a dorang surugu. Nia gana akpaat a vuvuna azaan angkari zinim. ");
INSERT INTO nal_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aubina angkari xawit di imin famarazaat a daanim dikdik malasing nim naagu naxaam, naambari be a marana iaas ka wizik faat paanaraan. ");
INSERT INTO nal_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Singsaxai malasing baina Nakmai xa ra pitfiaat lamaskana dorang sin Joel a profet naako, ");
INSERT INTO nal_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nakmai xa piaat malasing kari, “La vaanongang iwana amun taan, gana kling fakabaal a Laklagaai a Raabu zurugu wana aubina vaakdul. Amun naata nim ma amun nativa nim dina viaat amun dorang profet. Amun kulaau zinim dina miriftaain amun saan, ma amun faanga piran sinim dina mirifdaai amun saan. ");
INSERT INTO nal_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Faaratunaan mase, lamun taan angkanaan gana kling fakabaal a Laklagaai a Raabu zurugu zaait nanga wana amun iaana kilaaiang surugu, ubina ma furavin, ma naandi dina pitfiaat amun dorang profet. ");
INSERT INTO nal_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gana vabalos amun faaxoxovang laaxur la bara ma gana giu amun faakilanang iriat paanaburut la pira angkari. Amun saan malasing kari, a dari ma axaiaf ma adi buan kana balas, ");
INSERT INTO nal_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ma a iaas kana suk ma a flan kana memek malasing a dari, ma lamuraana xa, adi raan laba varaxai wana a marmari daxaiang sin a Piran kana balas. ");
INSERT INTO nal_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma naandi vaakdul di viring aizina a Piran, naan kana zaxot faulin naandi.” ’ ” ");
INSERT INTO nal_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ma Pita xa piaat saait naako, “Amun paliaanugu amun Israael, naaguna langarin a dorang kari: Iesu in Naazaret ka ra giu amun faamuzazang ka banglala ma amun faaxoxovang ma amun faakilanang. Pana amun saan angkanaan Nakmai xa vatangin sinim adu Iesu naan nis. Nakmai xa vabalos amun saan angkanaan lawalaua nim, malasing naagu rexaazin fanong. ");
INSERT INTO nal_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Di ra lis a rapti angkanaan la mita nim ina Nakmai nanga xa ra nimnimanin naan ma xa rexaazin fanong azaan kana balas, kat faraxas pana ainaxamang faatak sina. Ma nim faraxai wana faawalang sin aubina raksaat, naagu ra tukfating naan laaxur wana robuxul ma naagu zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Singsaxai Nakmai xa varamaraat faulin naan siaana a maatang ma xa vamamaraxaas naan siaana a maazikang iwana maatang, panaze xawit nat faraxas a maatang kana roting falagot naan. ");
INSERT INTO nal_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Avuna Dewit ka ra dador wana naan malasing kari, ‘Ga raamin a Piran kat paamuin bulin nia, wanaze naan ka irur la mit sazaxa zurugu ma xat katkatong nia, xuna xawit ta zaan kana vamaraut nia. ");
INSERT INTO nal_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Malasing ma nia ga nanam ma ga dador nanam saait. Ma nia wana a winugu angkari gana aizit simbang faraxai wana inaxam paazaaiang, ");
INSERT INTO nal_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","panaze nua guna wen luaa psin nia lamaskana a bina zin amun maat. Ma guna wen luaa psin a Rapti Xoxok sunum a wina xana murut pizaai. ");
INSERT INTO nal_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gu vatangin fanong amun lan iwana roroiang surugu. Gana irur la maraam ma guna sfaar nia wana nanamang.’ ” ");
INSERT INTO nal_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ma Pita xa piaat saait naako, “Amun daazugu ma amun fafnugu, gana vazei vatok nim adu a xulmua zin dia, a Xalxaal Dewit, ka maat faanong ma di xavin naan, ma a baaul a maat sina xa iziar nanga taning. ");
INSERT INTO nal_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Singsaxai naan a profet sin Nakmai ma xa rexaazin fanong adu Nakmai xa xalxal wana a waatna xuna xana zuruk taxazak sin amun natnaat sin Dewit ma xana vaziaar naan pana akin izi xalxaalang sina. ");
INSERT INTO nal_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dewit ka raamin paamuin fanong aze razaan Nakmai xana giu mur, malasing ma naan ka dador lalos a ramaraat puliang sin a Mesaaia. Naan ka ra piaat adu Nakmai xana wen luaa psin naan la bina zin amun maat ma a wina xana wen murut pizaai. ");
INSERT INTO nal_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nakmai xa ra varamaraat faulin Iesu angkanaan siaana maatang, ma dia xari di ra raamin naan ka roro uli. ");
INSERT INTO nal_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nakmai xa zaxot naan kunikula la lia ma xa vaziaar naan la mit sazaxa zina ma Nakmai Damana nanga xa lis a Laklagaai a Raabu ina naa xalxalin malasing ma naan ka kling fakabaal a vaamuzazang ka banglala angkari zimaam malasing be taning naagu raamin ma naagu langarin. ");
INSERT INTO nal_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Avuna Dewit kawit na uzaa la lia, singsaxai xa piaat malasing kari naako, ‘A Piran Nakmai xa piaat sin a Piran surugu naako, “Guna iziar iriat la mit sazaxa zurugu, ");
INSERT INTO nal_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","xa ruaas gana rasin amun purua zunum dina balas akin faiavuzang uru xaakum.” ’ ” ");
INSERT INTO nal_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ma Pita xa piaat kaarik naako, “Malasing ma nim aubina vaakdul in Israael, naaguna rexaas daxa adu Iesu angkanaan ina naagu ra tukfating naan laaxur wana robuxul, Nakmai xa vaziaar naan a Piran ma a Mesaaia.” ");
INSERT INTO nal_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aubina di langarin azaan angkanaan, ma xa suk a maskana naandi ma di piaat sin Pita varaxai wana amun aaposal malasing kari, “Amun daaza maam, aze razaan maadina giu?” ");
INSERT INTO nal_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita xa vazei naandi naako, “Nim saksaxai naaguna inaxam taawuk siaana amun matmalabuk taksaat sinim, ma maadina baaptaais nim pana aizina Iesu Kaarisito xuna Nakmai xana naxaam pizin amun matmalabuk taksaat sinim ma naaguna zuruk a talazang pana a Laklagaai a Raabu. ");
INSERT INTO nal_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","A xalxalang kanaan sin Nakmai aaxan nim ma a funalik sinim ma aaxan naandi vaakdul zaait ina di iziar lawalaau ma aaxan naandi vaakdul ina a Piran Nakmai zin dia xana viring fawat sina.” ");
INSERT INTO nal_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita xa wurus naandi wana a dorang ka varas ma xa vadikdik naandi naako, “Naaguna luaa Nakmai xana zaxot faulin nim siaana a watkul angkari taning, naandi aubina raksaat.” ");
INSERT INTO nal_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Azanon sin naandi di inaxam paazaai wana a dorang ma amun aaposal di baaptaais naandi. A taausan urul aubina di vakot falbis naandi wana vaakatang sin aubina di inaxam paazaai la raan angkanaan. ");
INSERT INTO nal_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Amun aaposal dit firaai naandi wana dorang sin Nakmai, ma aubina di inaxam paazaai di dikdik pana langarinang a dorang kanaan. Di izi vatu varaxai wana naandi zaksaxai ma di vavangan faraxai ma dit maainung faraxai. ");
INSERT INTO nal_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Amun aaposal di gigiu amun faaxoxovang ma amun faakilanang ka varas, ma naandi vaakdul di raamin ma di banglala. ");
INSERT INTO nal_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma aubina di inaxam paazaai dit balas fatu bulaai ma dit fatawaraxin amun saan lawalaua naandi zaksaxai. ");
INSERT INTO nal_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dit faangurin amun saan sin naandi ma amun kaakaai iwana dit fatawaraxin lawalaua naandi ina di izi gogof. ");
INSERT INTO nal_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lamun taan faakdul dit balas fatu bulaai malasing a lemlem azaxai lamaskana a rabaraau ila vaal xoxok. Ma di vavangan faraxai lamun faal zin naandi varaxai wana a nanamang ma a maskana naandi xa vaaratunaan. ");
INSERT INTO nal_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Di wisfarur Nakmai ma aubina vaakdul in Jerusalem di nanam pana aubina di inaxam paazaai. Lamun taan faakdul a Piran kat fakot falaup falbis saait aubina di inaxam paazaai wana aizina Iesu ma naan ka zaxot faulin naandi. ");
INSERT INTO nal_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Aza raan languzaraaf pana marana iaas urul, Pita ma Jon di waan iaa la rabaraau ila vaal xoxok kuna dina maainung iaa, malasing amun Judaa di gigiu bulin. ");
INSERT INTO nal_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ka rauxin aza marana lan, di vakilaan a Mara Marmari Daxa, ma aza rapti xa iziar inaan, uru xaakna di maat iaa. Naanaa zina xa luk naan nanga malasing kanaan. Ma lamun taan faakdul aubina dit fazaak luk naan ku lamarana lan angkanaan kuna xanat nungnung kaakaai zin aubina di zazangas ku lamaskana a rabaraau ila vaal xoxok. ");
INSERT INTO nal_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Naan ka raamin Pita ma Jon di albis iaa la rabaraau ila vaal xoxok, ma xa nungnung nandiaa xuna dina ralaas iaa naan pana kaakaai. ");
INSERT INTO nal_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Di damin falagot iaa naan ma Pita xa piaat sina naako, “Taamin nimaa.” ");
INSERT INTO nal_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A rapti xa raamin nandiaa ma xa naxaam adu xana zuruk tazaan sin nandiaa. ");
INSERT INTO nal_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Singsaxai Pita xa vazei naan naako, “Kawit ga rauxin ta kaakaai siliwa o goul, singsaxai gana ralaas nua wana azaan nia ga rauxin. Lamaskana aizina Iesu Kaarisito in Naazaret, tamaraat ma gu zangas.” ");
INSERT INTO nal_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ma Pita xa taaxur la mit sazaxa zina ma xa vawaal varamaraat naan ku laaxur. Fazaaus mase uru xaakna di balas dikdik iaa. ");
INSERT INTO nal_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Naan ka fida uzaa ma xa rur ma xa zangas, ma xa albis faraxai wana nandiaa xu lamaskana a rabaraau ila vaal xoxok. Ka zazangas ma xai fida malavit ma xai wisfaru Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Aubina vaakdul di raamin a rapti xa zazangas ma xai wisfarur Nakmai, ");
INSERT INTO nal_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ma di raamin fakilaan adu naan a rapti ina xat nungnung saan ma xa iziar la Mara Marmari Daxa la rabaraau ila vaal xoxok, ma di balaxof ma di banglala wana azaan angkanaan ka balas sina. ");
INSERT INTO nal_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Araan a rapti angkanaan ka roting fating nanga Pita ma Jon, aubina vaakdul di banglala ma di valaau wat sin nandiaal la non faraandaa lamaskana rabaraau ila vaal xoxok di vakilaan adu, “A Faraandaa Zin Solomon.” ");
INSERT INTO nal_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita xa raamin aubina angkanaan ma xa vazei naandi naako, “Naam aubina in Israael, xunaze naagu raknar wana azaan angkanaan? Ma xunaze naagu rudamin falagot maam? Malasing faa, naagu naxaam adu maadi vira iaa a rapti angkari wana a dikdikang sin nimaa nanga o wana a matmalabuk sinimaa iwana valos fatalaminang a sasaxotang ma ainaxamang sin Nakmai xuna naan kanat faraxas kana zangas? ");
INSERT INTO nal_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A Nakmai zin Aabaraam ma Aaisaak ma Jekop, faaratunaan mase, Nakmai zin amun kulmua zin dia, naan ka ra valaup Iesu, a iaana kilaaiang sina. Singsaxai nim naagu lis naan la mit amun purua, ma naagu wispuxin naan lamarana Paailat, naapalaau Paailat ka piaat adu xana vamiluaar naan. ");
INSERT INTO nal_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nim naagu wispuxin A Rapti Ninis ma Xa Tak, ma naagu iaari zin Paailat kuna vamiluaarang lis sinim a rapti xa zopsop famaat palau aubina. ");
INSERT INTO nal_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nim naagu zop famaat axazak ina xa vuvuna roroiang, singsaxai Nakmai xa varamaraat faulin naan pana maatang. Maam maadi pitfiaat azaan angkanaan panaze maadi ra raamin. ");
INSERT INTO nal_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Naagu raamin a rapti angkari ma naagu rexaazin naan. Pana ainaxam paazaaiang be wana aizina Iesu, ma xa zuruk a dikdikang faaxur lamaskana uru xaakna. Ainaxam paazaaiang lamaskana aizina Iesu xari, xa vira a rapti angkari iriat lamarana nim faakdul. Nim faakdul naagu raamin adu uru xaakna di balas daxa iaa. ");
INSERT INTO nal_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ma naari, amun daazugu ma amun fafnugu, ga rexaazin aze razaan nim faraxai wana amun paamua zinim naagu ra giu wana Iesu wanaze xawit naagu mazaam adu Iesu naan nis. ");
INSERT INTO nal_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","A zaan angkanaan ka waambazof a dorang sin Nakmai la nguza amun profet faakdul adu a Mesaaia zina xana vazaak a maazikang laba. ");
INSERT INTO nal_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Malasing ma naaguna inaxam taawuk siaana amun matmalabuk taksaat sinim kuna Nakmai xana naxaam pizin, ");
INSERT INTO nal_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ma xana lis a iaavuzang sinim siaana amun maravanang ma naan kana kling fawat Iesu, naan a Mesaaia ina naa ra kalin fanong aaxan nim. ");
INSERT INTO nal_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Naan kana iziar laaxur la lia xa ruaas a raan Nakmai xana giu vavaxur amun saan faakdul, malasing be naan ka ra xalxal wana lamaskana a dorang sin amun profet ninis sina imumua. ");
INSERT INTO nal_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Aiang, Moses ka ra piaat naako, ‘A Piran Nakmai zinim kana kling fawat a profet, ma naan azaxai zinim faatak amun Judaa, malasing be xa ra kling fawat nia. Naaguna langarin amun dorang faakdul naana vazei nim pana. ");
INSERT INTO nal_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tamon taxazak ka baai xana langarin a dorang sina, Nakmai xana vaanong pizin naan siaana aubina zina vaatak.’ ” ");
INSERT INTO nal_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ma Pita xa piaat saait naako, “Amun profet, di varumarain pana Saamuel ma azanon di balas lamuraana, naandi vaakdul di pitfiaat amun saan ina xat balas lamun taan angkari. ");
INSERT INTO nal_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Amun dorang sin amun profet ka wat la mita nim ma naagu iziar lamaskana a rudaxaiang ina Nakmai xa ra xalxal wana zin amun kulmua zinim, malasing be xa ra vazei Aabaraam naako, ‘Wana a natnaat sunum gana lis a daxaiang sin amun lemlem aubina vaakdul ila pira angkari.’ ");
INSERT INTO nal_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Malasing ma Nakmai xa ra varamaraat a iaana kilaaiang sina ma xa tabung kling fawat naan sinim kuna xana lis a daxaiang sinim malasing kari, naan kana valos puk nim saksaxai ziaana amun matmalabuk taksaat sinim.” ");
INSERT INTO nal_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Araan Pita ma Jon di dador iaa nanga zin aubina, amun pris faraxai wana a waamua zin amun tuxaaul ila vaal xoxok ma a lemlem Saadusi di wat sin nandiaa. ");
INSERT INTO nal_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Amun Saadusi di mangat pana nandiaa uru aaposal wanaze di fazei iaa zin aubina adu Iesu xa ramaraat puli vaanong siaana maatang, malasing ma xa vatangin adu aubina di maat faanong dina ramaraat puli zaait. ");
INSERT INTO nal_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Malasing ma di zaraak nandiaa, ma di rasin nandiaa la vaal a vaamaazikang ka ruaas la raan lamuraana, wanaze a iaas ka si vaanong. ");
INSERT INTO nal_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Singsaxai amala zin naandi di langarin a dorang kanaan ma di inaxam paazaai, ma a vaakatang sin ubina di inaxam paazaai xa balas a taausan ka watmit. ");
INSERT INTO nal_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lamuraana a raan angkanaan amun paamua zin amun Judaa ma a vaanga piran ma amun maravas iwana amun Lus sin Moses di vatu inaan Jerusalem. ");
INSERT INTO nal_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Di vatu varaxai wana Aanaas, naan a waamua zin amun pris faakdul, ma Kaaiapaas ma Jon ma Aaleksenda ma naandi zaait azanon taaua Aanaas. ");
INSERT INTO nal_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Di varur Pita ma Jon lamarana naandi ma di iaari zin nandiaa malasing kari, “Gu zuruk iaa a dikdikang faa o lamaskana aizina nis naagu giu iaa azaan angkanaan?” ");
INSERT INTO nal_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","A Laklagaai a Raabu xa sfaar Pita ma xa piaat sin naandi naako, “Amun paamua zin amun Judaa, ma nim a vaanga piran! ");
INSERT INTO nal_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Naagu iaari zinimaa taning pana amun saan daxa maadi ra giu iaa laraf pana a rapti angkari, uru xaakna di maat iaa, ma naan ka daxa malasing faa. ");
INSERT INTO nal_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nim ma aubina vaakdul zaait in Israael, naaguna rexaazin adu a rapti angkari xa irur waamua lamarana nim, uru xaakna di balas daxa iaa wana a dikdikang iwana aizina Iesu Kaarisito in Naazaret, ina nim naagu ra tukfating naan pana robuxul. Singsaxai Nakmai xa varamaraat faulin naan siaana maatang. ");
INSERT INTO nal_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu naan a rapti a Baar Xoxok ka dador wana naan malasing kari, ‘A vaat ina nim amun kaamdaa naagu bain pizin, naan ka balas a varumaraiang a vaat iwana vaal.’ ");
INSERT INTO nal_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Lamaskana aizina zingbe, Nakmai xana zaxot faulin dia, wanaze xawit mase taxazak ila pira angkari, Nakmai xa lis aizina zina xuna zaxot faulinang dia wana.” ");
INSERT INTO nal_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Amun paamua di banglala wana Pita ma Jon di dador dikdik iaa ma xawit di maraaut iaa. Ma di raamin fakilaan saait adu nandiaa xawit di iziar iaa wana ta varaviraaiang ma nandiaa uru rapti walaau be ma di zazangas bulaai iaa varaxai wana Iesu. ");
INSERT INTO nal_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Singsaxai di raamin a rapti angkanaan di ra vira iaa naan, ka irur varaxai wana nandiaa ma xawit di rauxin a dorang kuna dina xis nandiaa. ");
INSERT INTO nal_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Malasing ma di kling pizin fatukbilok nandiaa, fataling a non angkanaan iwana aikilizang, ma naandi zingbe di xulus azaan angkanaan lawalaua naandi. ");
INSERT INTO nal_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Di iaari malasing kari, “Dina giu aze razaan pana uru rapti angkari? Aubina vaakdul di rataagul iriat Jerusalem di rexaazin fanong a vaakilanang ka banglala uru rapti angkari di ra giu iaa, ma dia xawit nat faraxas dina wispuk pana. ");
INSERT INTO nal_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Singsaxai dia dina ruxol a dorang kanaan kuna xana wen paan farawuk lawalau aubina, dina vazei nandiaa adu tuaa xaarik dina fazei iaa wana aiza angkanaan sin taxazak.” ");
INSERT INTO nal_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ma di viring falbis kaarik nandiaa xu lamaskana vaal ma di dador dikdik sin nandiaa, adu dina wen fazei iaa o dina wen faraviraai iaa xaarik pana aizina Iesu. ");
INSERT INTO nal_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Singsaxai Pita ma Jon di xis iaa naandi malasing kari, “Aze xa tak lamarana Nakmai, maadina langar iaa zinim o maadina langar iaa zin Nakmai? Nim nanga naaguna klis. ");
INSERT INTO nal_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Avuna xawit nat faraxas maadina vaanong iaa wana fazeiang pana amun saan maadi ra raamin iaa ma maadi ra langarin iaa.” ");
INSERT INTO nal_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Amun paamua di lis a dorang dikdik nanga zin nandiaa ma di vamiluaar nandiaa. Singsaxai xawit nat faraxas dina tangin ta lan kuna vamazikang nandiaa, wanaze aubina vaakdul di wisfarur Nakmai avuna di raamin a zaan angkanaan ka ra balas. ");
INSERT INTO nal_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A rapti angkanaan nandiaa di ra vira iaa naan pana a vaakilanang ka banglala, a maariaas sina xa laaup pana zangaaflu vaaralavaat. ");
INSERT INTO nal_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Lamuraana di vamiluaar Pita ma Jon, nandiaa di uli waan iaa zin amun paliaana nandiaa, ma di vazei iaa naandi wana a dorang faakdul amun pris laba varaxai wana a vaanga piran di ra piaat sin nandiaa. ");
INSERT INTO nal_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Araan di langarin, di balas pana ainaxamang azaxai ma di maainung sin Nakmai, di piaat malasing kari, “Piran, gu rauxin a burburaaiang faakdul. Gu vaziaar a lia ma a pira ma a raas ma amun saan faakdul lamaskana naandi. ");
INSERT INTO nal_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lamaskana a Laklagaai a Raabu gu ra fazei wana a dorang kari la nguza Dewit, a xulmua zimaam ma a iaana kilaaiang sunum. Naan ka piaat naako, ‘Kunaze amun lemlem aubina di mangat? Ma xunaze aubina di pis a dorang ma di nimniman kuna varopang faraxai wana Nakmai? Singsaxai ainaxamang sin naandi xana zaan palaau. ");
INSERT INTO nal_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Amun kalxaal ila pira angkari di nimnimanin naandi ma amun paamua zaait di balas fatu xuna varopang faraxai wana a Piran ma A Rapti Naa Kalin.’ ");
INSERT INTO nal_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ma faaratunaan mase, Erot ma Pontias Paailat di balas fatu iaa la bina laba angkari varaxai wana amun Judaa ma aubina xawit amun Judaa xuna puruaiang pana Iesu, naan a iaana kilaaiang ninis sunum, ina gu ra kalin. ");
INSERT INTO nal_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Di giu amun saan angkanaan, singsaxai naadi giu lalozang a dikdikang ma ainaxamang sunum be. Nua gu ra nimnimanin tasin fanong adu xana balas malasing kanaan. ");
INSERT INTO nal_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma Nakmai, gu ra langarin fanong a dorang dikdik naadi piaat kuna vamarautang maam ma guna naxaam. Naari maadi saxot adu guna vadikdik maam amun iaana kilaaiang sunum kuna maadina fazei wana dorang sunum ma maadina wen maraaut. ");
INSERT INTO nal_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Maadi saxot adu guna rasin a mirum pana aubina di gias ma guna vira naandi ma guna giu amun faakilanang ma amun faaxoxovang lamaskana aizina a iaana kilaaiang ninis sunum, Iesu.” ");
INSERT INTO nal_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lamuraana a maainungang sin naandi, a non angkanaan naadi vatu wana xa valvaaliang. A Laklagaai a Raabu xa sfaar naandi ma di ramaraat ma di fazei dikdik pana a dorang sin Nakmai ma xawit di maraaut. ");
INSERT INTO nal_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Aubina vaakdul di inaxam paazaai, di maska zaxai ma ainaxamang sin naandi xa zaxai. Kawit taxazak sin naandi xa naxaam adu amun saan sina, zina vaatak. Kawit. Di vatawaraxin amun saan faakdul naadi rauxin lawalaua naandi zaksaxai. ");
INSERT INTO nal_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wana a dikdikang laba amun aaposal di fazei wana a dorang iwana a ramaraat puliang sin a Piran Iesu. Ma a daxaiang laba zin Nakmai xa iziar wana naandi vaakdul. ");
INSERT INTO nal_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Avuna xawit taxazak lawalaua naandi xa ra izi gogof. Azanon di rauxin amun non pira ma azanon di rauxin amun faal, di vaangurin naandi ma di zuruk a kaakaai wana, ");
INSERT INTO nal_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ma di lis sin amun aaposal, ma a kaakaai angkanaan naadi vatawaraxin lawalaua naandi di izi gogof. ");
INSERT INTO nal_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma aza rapti, aizina xanaan Iosep, naan sin a watbung sin Livaai, naan in Saaipras, amun aaposal dit fakilaan saait naan pana Baanabaas. Avuvuna aiza angkanaan Baanabaas adu, “a rapti xat fadikdik azanon tawarak.” ");
INSERT INTO nal_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Naan ka vaangurin a vang pira zina ma xa zuruk a kaakaai, ma naa lis sin amun aaposal. ");
INSERT INTO nal_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Aza rapti aizina xanaan Aananiaas faraxai wana taak sina Saapiraa di vaangurin iaa a vang pira zin nandiaa. ");
INSERT INTO nal_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ma xa rasin parok azanon kaakaai iwana a wulwulang kanaan aaxana vaatak ma taak sina xa rexaazin azaan angkanaan. Singsaxai Aananiaas ka lis be azanon kaakaai xa waan sin amun aaposal ma xa piaat adu naan amun kaakaai vaakdul xanaan. ");
INSERT INTO nal_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ma Pita xa vazei naan naako, “Aananiaas, kunaze gu rudaxain Saatan kana sfaar ainaxamang sunum? Ma xa vaxalxaal nua, ma gu vagit a Laklagaai a Raabu ma gu roting azanon kaakaai iwana a wulwulang gu ra zuruk pana a vang pira angkanaan. ");
INSERT INTO nal_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Paamua araan kawit nanga gu vaangurin, a pira zunum faatak, ma lamuraana gu vaangurin fanong, a kaakaai zaait sunum. Kunaze gu naxaam adu guna giu a matmalabuk angkanaan? Kawit gu vagit aubina, singsaxai gu vagit Nakmai.” ");
INSERT INTO nal_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aananiaas ka langarin ma xa zu wizik paanaburut ma xa maat. Ma naandi vaakdul ina di langarin azaan angkanaan, di maraaut mase. ");
INSERT INTO nal_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ma azanon kulaau di albis ma di flus naan ma di vazaak fatukbilok naan ku lamanar ma di wa xavin naan. ");
INSERT INTO nal_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lamuraana a aaua urul, taak sina xa albis singsaxai naan kawit na rexaas aze razaan ka balas. ");
INSERT INTO nal_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita xa iaari zina naako, “Gu vazei nia, malasing faa, naan a wulwulang kari numaa labaam gu ra zuruk iaa wana a vang pira angkanaan?” Ma a ravin ka piaat naako, “Aiang, ka vaaratunaan, naan a wulwulang kanaan.” ");
INSERT INTO nal_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ma Pita xa vazei naan naako, “Kunaze numaa labaam gu rudaxa iaa adu guna vabe iaa a Laklagaai a Raabu zin a Piran? Aubina di xavin labaam boxo di irur vaanong lamarana mara, ma dina vazaak luk saait nua xu lamanar.” ");
INSERT INTO nal_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","La notaan angbani naan ka zu lapaara uru xaaka Pita ma xa maat. Amun kulaau di albis ma di raamin naan ka maat, malasing ma di vazaak luk naan ku lamanar ma di xavin naan lapaara labana. ");
INSERT INTO nal_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Adi maraautang laba xa balas lawalau aubina vaakdul di inaxam paazaai ma naandi zaait ina di langarin azaan angkanaan. ");
INSERT INTO nal_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","A Piran ka giu amun faakilanang ma amun faaxoxovang ka varas lamun mit amun aaposal zina, ma di vabalos lawalau aubina. Aubina vaakdul ina di inaxam paazaai, dit balas fatu bulaai malasing a lemlem azaxai la non di vakilaan, “A Faraandaa Zin Solomon.” ");
INSERT INTO nal_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Aubina ina xawit di inaxam paazaai, di maraaut pana wat fatuiang faraxai wana naandi, naapalaau di varanop marazaat pana naandi. ");
INSERT INTO nal_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Singsaxai amala xaarik nanga ubina ma furavin di inaxam paazaai wana a Piran, ma di vakot falbis naandi lamaskana a lemlem sin naandi. ");
INSERT INTO nal_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Malasing ma wana azaan angkanaan, aubina di zaxot luk aubina di gias faraxai wana amun iban sin naandi xula lan ma di vatate naandi inaan kuna araan Pita xana zangas bilas, a maliaangna xana pung naandi. ");
INSERT INTO nal_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma aubina xa varas mase ilamun bina lapaara Jerusalem di vatu inaan, ma di zaxot aubina zin naandi di gias, ma naandi zaait amun sapalaau di ragul naandi, ma naandi vaakdul di daxa xaarik. ");
INSERT INTO nal_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Singsaxai a waamua zin amun pris faakdul faraxai wana ubina zina, naandi zin a lemlem Saadusi, naandi di raamaai zuzuai mase wana amun aaposal. ");
INSERT INTO nal_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Di zaraak amun aaposal ma di rasin naandi la vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Labung angkanaan a aangelo zin a Piran ka kaas amun mara ila vaal a vaamaazikang ma xa zaxot fatukbilok naandi xu lamanar ma xa piaat sin naandi naako, ");
INSERT INTO nal_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Naaguna waan la rabaraau ila vaal xoxok ma naaguna fazei wana a roroiang faaxur angkari.” ");
INSERT INTO nal_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Amun aaposal di langar ma paanaraan gufguf mase di albis la rabaraau ila vaal xoxok ma di varumara viraaiang aubina. A waamua zin amun pris faakdul varaxai wana ubina vaakdul iwana Aiziarang Iwana Aikilizang Sin Amun Judaa, di viring fatuin amun paamua zin amun Judaa xuna naandi vaakdul dina iziar wana aikilizang, ma di kilaai waan la vaal a vaamaazikang kuna dina zaxot fawat amun aaposal. ");
INSERT INTO nal_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Singsaxai araan di balas, kawit di tangin amun aaposal la vaal a vaamaazikang. Malasing ma di uli waan sin amun paamua ma di vazei vamaravaas naandi malasing kari, ");
INSERT INTO nal_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Araan maadi balas la vaal a vaamaazikang, maadi raamin adu di baraat kol valagot amun mara, ma amun tuxaaul zaait di irur lamarana amun mara. Singsaxai araan maadi kaas amun mara, xawit maadi raamin taxazak lamaskana.” ");
INSERT INTO nal_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Naanaan araan a waamua zin amun pris faakdul ma a waamua zin amun tuxaaul ila vaal xoxok ma amun pris laba di langarin, di inaxam marazaat pana aze razaan kana balas pana amun aaposal. ");
INSERT INTO nal_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Aza rapti xa wat ma xa vazei naandi naako, “Naagu langar! Ubina naagu rasin naandi la vaal a vaamaazikang, di irur la rabaraau ila vaal xoxok ma dit firaai aubina.” ");
INSERT INTO nal_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Naanaan a waamua zin amun tuxaaul ila vaal xoxok ka ramaraat faraxai wana amun tuxaaul zina ma di zaxot fatalamin fawat amun aaposal, wanaze di maraaut adu aubina dina put tukfamaat naandi wana amun faat. ");
INSERT INTO nal_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Di zaxot luk amun aaposal xu lamarana Aiziarang Iwana Aikilizang Sin Amun Judaa, ma di varur naandi lamarana amun paamua iwana aikilizang, ma a waamua zin amun pris faakdul xa vazei naandi malasing kari, ");
INSERT INTO nal_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Maadi lis a dorang dikdik sinim adu tuaa xaarik naaguna varaviraai wana aizina a rapti angkanaan. Singsaxai naagu langarin pizin. Naagu fazei vaanong pana amun faraviraaiang sinim lamun non faakdul iriat lamaskana Jerusalem, ma naagu saxot mase naaguna vakor vadikdik maam pana a maatang sina.” ");
INSERT INTO nal_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita varaxai wana amun aaposal di xis naandi malasing kari, “Maadina valos be Nakmai, singsaxai xawit aubina. ");
INSERT INTO nal_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nakmai zin amun kulmua zin dia xa ra varamaraat faulin Iesu ziaana maatang, ina nim naagu ra tukfating naan pana robuxul ma naagu zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nakmai xa varamaraat fauzaa naan laaxur ma xa vaziaar naan la mit sazaxa zina. Ma naan ka balas a Waamua ma a Baraai a Vaaroroiang kuna xana vatangin a lan sin amun Israael adu dina inaxam taawuk siaana amun matmalabuk taksaat sin naandi ma Nakmai xana naxaam pizin. ");
INSERT INTO nal_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Maam maadi raamin amun saan angkanaan ma maadi pitfiaat a dorang kanaan. Ma a Laklagaai a Raabu zaait kai pitfiaat, ma naan bani a talazang kanaan ina Nakmai xa ra lis sin naandi dit falos a dorang sina.” ");
INSERT INTO nal_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Amun paamua di iziar wana aikilizang, di langarin ma di boromaazik mase, ma di saxot adu dina zop famaat naandi. ");
INSERT INTO nal_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Singsaxai azaxai zin naandi, naan a Faarasi, aizina xanaan Gaamaliel. Naan a maravas iwana amun Lus sin Moses, ma aubina vaakdul dit faranop pana naan. Naan ka rur lawalau amun paamua ma xa maainung naandi xuna kling fatukbilokang amun aaposal xu lamanar wana a notaan mumut. ");
INSERT INTO nal_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ma xa vazei amun paamua malasing kari, “Ubina in Israael, naaguna inaxam daxa wana aze razaan naagu naxaam naaguna giu wana naandi. ");
INSERT INTO nal_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Azanon maariaas ka vaanong, Teudaas ka balas ma xa kalin adu naan a rapti xa rauxin aiza laba, ma xa urif ubina ma di ra ilos naan, di malasing azangaaflu varazuai urulavaat. Singsaxai amun Rom di gaal vamaat naan ma ubina zina di waan farawuk ma amun faamuzazang sin naandi xa maat palaau xa. ");
INSERT INTO nal_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lamuraana azaan angkanaan, Judaas in Gaalili xa balas, lamaskana amun taan iwana zurukang aiza. Naan saait ka urif amala ubina ma di los naan kuna dina zop amun Rom ina di rasin a lus pana naandi. Singsaxai amun Rom di zop famaat saait naan ma ubina di ilos naan, di waan farawuk. ");
INSERT INTO nal_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Malasing ma wana azaan angkanaan, ga vazei nim adu tuaa naagu giu tazaan pana ubina angkanaan. Naaguna vamiluaar naandi. Avuna tamon a vaamuzazang kanaan naadi gigiu wana ainaxamang sin aubina be, xana menawaai walaau. ");
INSERT INTO nal_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Singsaxai tamon a vaamuzazang sin naandi xa wat ikula laaxur zin Nakmai, nim kawit nat faraxas naaguna ruxol ma naaguna varop faraxai wana Nakmai.” ");
INSERT INTO nal_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Naanaan amun paamua di valos a dorang kanaan sin Gaamaliel. Di viring falbis amun aaposal, ma di vazei amun tuxaaul ma di kmis naandi wana wip. Ma di dador dikdik sin naandi adu tuaa xaarik dina fazei wana aizina Iesu, ma di vamiluaar naandi. ");
INSERT INTO nal_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Amun aaposal di vataling Aiziarang Iwana Aikilizang Sin Amun Judaa ma di nanam marazaat mase, wanaze Nakmai xa ra rudaxain naandi adu xat faraxas dina zuruk a maangilang pana aizina Iesu. ");
INSERT INTO nal_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma lamun taan faakdul lamaskana rabaraau ila vaal xoxok ma lamaskana amun faal zaksaxai, xawit dit siaavus pana varaviraaiang ma fazeiang pana a Dorang Daxa adu Iesu naan a Mesaaia. ");
INSERT INTO nal_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lamun taan angkanaan a vaakatang sin aubina di inaxam paazaai xa uzaa bulaai laaxur, ma a varamangatang ka balas lawalau amun Judaa di inaxam paazaai ina di wukpuk a linga bina Grik ma amun Judaa di inaxam paazaai di wukpuk a linga bina Ibru. Aubina angkanaan di wukpuk a linga bina Grik, di piaat adu amun taksiziar zin naandi xawit di zuzuruk amun fanganang sin naandi ma amun saan kuna vawaalang naandi lamun taan saksaxai. ");
INSERT INTO nal_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Malasing ma amun aaposal xa zangaaflu ma urua di viring fatuin aubina varaviraai ma di piaat malasing kari, “Kawit na tak pana maam, maadina luaa psin a vaamuzazang iwana a dorang sin Nakmai ma maadina wa talazin a vanganang. ");
INSERT INTO nal_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Amun taatum lamaskana Kaarisito, naaguna kalin luk ubina xa wizik urua lawalaua nim nanga, naagu rexaazin naandi ina di bas pana a Laklagaai a Raabu ma mazamang, ma maadina rasin a vaamuzazang kanaan la mita naandi. ");
INSERT INTO nal_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma maam nanga maadina raalil wana maainungang ma vaamuzazang iwana a dorang sin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Naandi vaakdul di nanam pana dorang sin amun aaposal, malasing ma di kalin Stivan, a rapti ina xa bas pana ainaxam paazaaiang ma wana a Laklagaai a Raabu. Ma di kalin saait Filip ma Prokoras ma Nikaanor ma Timon ma Paamenaas ma Nikolaas naan in Entiok, naan kawit a Judaa, singsaxai xa balas a rapti varaviraai lamaskana lotu zin amun Judaa waamua wana xa inaxam paazaai wana Iesu. ");
INSERT INTO nal_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Di zaxot lis ubina angkari xa wizik urua zin amun aaposal ma amun aaposal di maainung pana naandi ma di rasin a mita naandi laaxur wana naandi xuna Nakmai xanat faraxaas naandi wana vaamuzazang kanaan. ");
INSERT INTO nal_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma a dorang sin Nakmai xa waan farawuk lamun non ka varas. A vaakatang pana aubina di inaxam paazaai inaan Jerusalem ka uzaa laaxur vazaaus, ma amala zin amun pris sin amun Judaa di inaxam paazaai wana Iesu ma di los naan. ");
INSERT INTO nal_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stivan a rapti xa bas pana daxaiang sin Nakmai ma a dikdikang, ma xa gigiu amun faaxoxovang laba ma amun faakilanang lawalau aubina. ");
INSERT INTO nal_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Singsaxai azanon Judaa di ramaraat ma di varamangat faraxai wana Stivan. Ubina angkanaan ila bina laba Saairini ma bina laba Aaleksendriaa ma a provins Silisia ma a provins Esia, naandi di wisfaaru lamaskana aza vaal a maainungang, aizina di vakilaan adu, “A vaal a maainungang sin ubina di izi mamaraxas.” ");
INSERT INTO nal_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Singsaxai a Laklagaai a Raabu xa lis a mazamang sin Stivan, malasing ma naandi xawit nat faraxas dina xis a dorang sina. ");
INSERT INTO nal_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Naanaan di dador vunfun ma di xul ainaxamang sin azanon ubina malasing ma naandi di vakor naan malasing kari, “Maam maadi langarin Stivan ka piaat faraksaat Moses ma Nakmai.” ");
INSERT INTO nal_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Malasing ma naandi di vaxanaat ainaxamang sin aubina ma amun paamua ma amun maravas iwana amun Lus sin Moses. Di wat saraak Stivan, ma di varur naan lamarana Aiziarang Iwana Aikilizang Sin Amun Judaa. ");
INSERT INTO nal_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ma di zaxot fawat azanon ubina ma di vakor naan ma di vaagit malasing kari, “A rapti angkari xawit nai ziaavus pana wispiaalang a vaal xoxok sin Nakmai ma amun Lus sin Moses. ");
INSERT INTO nal_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Maadi langarin naan ka piaat adu Iesu angbani in Naazaret, kana bara psin a vaal xoxok angkari ma xana xul amun tataawukang imumua ina Moses ka ra lis sin dia.” ");
INSERT INTO nal_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Naandi vaakdul di iziar inaan, di raamaai dikdik pana Stivan ma di raamin a marana xa malasing a marana a aangelo zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A waamua zin amun pris faakdul xa iaari zin Stivan naako, “Malasing faa wana a dorang kanaan naadi piaat pana nua, xa vaaratunaan?” ");
INSERT INTO nal_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ma Stivan ka xis naan naako, “Amun daazugu ma amun maagu! Naaguna langar zurugu. Nakmai iwana a marmari daxaiang ka balas sin damana dia Aabaraam la raan ka iziar nanga la pira Mesapotaamia, waamua wana xa wa raagul la bina laba Aaraan. ");
INSERT INTO nal_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ma Nakmai xa vazei naan naako, ‘Guna luaa a bina zunum ma a watbung sunum, ma guna waan la pira gana vatangin sunum.’ ");
INSERT INTO nal_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Malasing ma Aabaraam ka luaa a pira zin amun Kaaldiaa ma xa waan la bina laba Aaraan ma xa raagul inaan. Lamuraana a maatang sin damana Aabaraam, Nakmai xa kling naan kula pira angkari, nim naagu raagul wana. ");
INSERT INTO nal_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nakmai xawit na lis tazaan laaxur wana a pira angkari zin Aabaraam adu naana raumana, aiang, kawit ta vang pira mumut adu a pira aaxana vaatak. Kawit. Singsaxai Nakmai xa ra xalxal adu Aabaraam ma amun natnaat sina dina raumana. Ma la raan angkanaan Nakmai xa ra xalxal zin Aabaraam, Aabaraam kawit na raxunalik. ");
INSERT INTO nal_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nakmai xa vazei naan malasing kari, ‘Amun natnaat sunum dina raagul la non pira rawarak, kawit sin naandi vaatak, ma dina ropuran inaan. La non angkanaan dina balas amun iaana kilaaiang ma dina vazaak a vaamaazikang pana a maariaas ka zangaaflu varazuai vaaralavaat. ");
INSERT INTO nal_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Singsaxai nia gana klis aubina angkanaan dit famazik aubina zurugu ma gana vamazik naandi. Ma lamur naandi dina luaa a pira angkanaan ma dina wat ma dina lotu wana nia iriat la non angkari.’ ");
INSERT INTO nal_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ma lamur Nakmai xa lis a rudaxaiang sin Aabaraam iwana ftuk pizinang a vang pakpak. Malasing ma Aabaraam ka balas damana Aaisaak, ma a vawizik tulang a raan lamuraana di luk naan Aabaraam ka ftuk pizin a vang pakpaakna. Aaisaak ka balas damana Jekop ma xa ftuk pizin a vang pakpaaka naatna, ma Jekop ka balas damana amun kulmua laba zin dia, naandi di zangaaflu ma urua. ");
INSERT INTO nal_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Amun kulmua laba zin dia, amun naata Jekop, dit marazuzuai wana daaza naandi Iosep, malasing ma di vaangurin naan malasing a iaana kilaaiang sin aubina di zazangas paan la pira Ijip. Singsaxai Nakmai xa iziar varaxai wana naan, ");
INSERT INTO nal_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ma xa zaxot faulin naan lamaskana amun maravanang kat balas sina. Araan Iosep ka rur lamarana Paaraao, a xalxaal in Ijip, Nakmai xa lis a mazamang ma a daxaiang sina lamarana Paaraao. Malasing ma Paaraao xa rasin naan a waamua laaxur wana amun Ijip ma lamaskana a vaal vaakdul zina. ");
INSERT INTO nal_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Naanaan adi zong ka balas la uru pira Ijip ma Kenaan, ma xa vabalos adi maravanang laba mase. Malasing ma amun kulmua zin dia xawit nat faraxas dina tangin ta vanganang. ");
INSERT INTO nal_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ma araan Jekop ka langar adu di rauxin a vanganang la pira Ijip, ka kling amun kulmua zin dia wana a varumaraiang a zangazang sin naandi xuninaan. ");
INSERT INTO nal_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ma wana a varuaiang a zangazang sin naandi, Iosep ka vatangin naan nanga zin amun daasna, ma Paaraao xa rexaazin amun daaza Iosep la raan angkanaan. ");
INSERT INTO nal_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ma Iosep ka kilaai xun damana Jekop, kuna dina zaxot naan faraxai wana amun taauna vaakdul ma dina waan la pira Ijip, naandi vaakdul di zangaaflu vaawizik urua ma xa watmit. ");
INSERT INTO nal_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ma Jekop faraxai wana amun kulmua zin dia di waan la pira Ijip, ma di raagul inaan ka ruaas di maat. ");
INSERT INTO nal_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Di vazaak faulin naandi xula bina laba Sekem, ma di xavin naandi la baaul a maat ina Aabaraam ka ra wul luk sin a funalik sin Aamor. ");
INSERT INTO nal_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","A raan ka vaasilik ka wana Nakmai xana waambazof a xalxalang sina wana Aabaraam. Ma a vaakatang pana aubina zin dia di iziar la pira Ijip ka laaup marazaat mase. ");
INSERT INTO nal_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Naanaan a xalxaal vaaxur xa balas ma xa rasin a lus la pira Ijip singsaxai xa wetexaazin Iosep. ");
INSERT INTO nal_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Naan ka vagit aubina zin dia ma xa giu a matmalabuk taksaat angkari wana naandi, xa vangarin naandi ma di psin amun popo zin naandi lamanar xuna dina maat. ");
INSERT INTO nal_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","La raan angkanaan naanaa zin Moses ka luk naan, ma naan a nalik daxa mase lamarana Nakmai. Di gon naan la vaal zin damana wana a flan urul. ");
INSERT INTO nal_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma araan di rasin naan lamanar, nativa a xalxaal Paaraao xa zaxot naan ma xa gon naan malasing naatna zina vaatak. ");
INSERT INTO nal_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ma Moses ka varaviraai wana amun faraviraaiang daxa vaakdul zin amun Ijip, ma xa balas a rapti, ma a dadorang sina xa maravan marazaat faraxai wana amun gigiuang sina. ");
INSERT INTO nal_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Araan a maariaas sin Moses ka zangaaflu vaaralavaat, ka saxot adu xana wa raamin aubina zina vaatak, amun Israael. ");
INSERT INTO nal_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ma xa raamin aza rapti in Ijip ka purua wana aza rapti in Israael ma Moses ka vawaal a rapti in Israael ma xa zop famaat a rapti in Ijip. ");
INSERT INTO nal_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ka naxaam adu aubina zina vaatak dina mazaam adu Nakmai xa luaa naan kuna naan kana vamamaraxas naandi, singsaxai naandi xawit di mazaam. ");
INSERT INTO nal_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A raan lamuraana, naan ka raamin uru Israael di varop iaa, ma xa saxot kana rasin a luaai lawalaua nandiaa. Ma xa piaat naako, ‘Naagu langar iaa, numaa uru vandaas, kunaze naagu varop iaa malasing kari?’ ");
INSERT INTO nal_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Singsaxai a rapti ina xa vaxanaat a varopang ka burut pizin Moses ma xa piaat naako, ‘Nis ka kalin nua guna balas a waamua ma guna klis maam? ");
INSERT INTO nal_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Iaak gu saxot guna zop famaat nia malasing gu zop famaat a rapti in Ijip laraf?’ ");
INSERT INTO nal_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Araan Moses ka langarin, ka valaau waan kula pira Midian, ma xa raagul malasing a ropuran, ma xa maxus ma xa rauxin a nalik urua. ");
INSERT INTO nal_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Lamuraana a maariaas ka zangaaflu vaaralavaat, a aangelo zin a Piran ka balas lamaskana axaiaf labirua wana amun rangtangaana nan iaai ikula la non bingil lapaara waatawut Saainaai. ");
INSERT INTO nal_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Araan Moses ka raamin ka banglala mase wana. Ka saxot kana raamin fatalamin ma xa zangas paan faasilik nanga, ma xa langarin a ling a Piran naako: ");
INSERT INTO nal_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nia Nakmai zin amun kulmua zunum, Nakmai zin Aabaraam, Aaisaak ma Jekop.’ Moses ka dakdakur ma xa maraaut pana raamaaiang. ");
INSERT INTO nal_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ma a Piran ka piaat sina naako, ‘Gamul psin amun su zunum, avuna a non angkari gu irur wana xa xoxok. ");
INSERT INTO nal_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ga raamin fanong a vaamaazikang sin aubina zurugu di iziar la pira Ijip ma ga langarin fanong a raangizang sin naandi. Ga wat paanaburut kuna vamamaraxaazang naandi la mit amun Ijip. Ma naari, laawus. Gana kling faulin nua xula pira Ijip.’ ");
INSERT INTO nal_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Naan Moses angbani ina paamua amun Israael di ra bain naan di piaat malasing kari, ‘Nis ka kalin nua guna balas a waamua ma a rapti ikilizang simaam?’ Naan Moses angbani Nakmai nanga xa kling naan ma xa balas a waamua ma a rapti xuna vamamaraxaazang naandi. Naan ka giu azaan angkanaan pana faawalang sin a aangelo ina xa ra balas sina lawalau amun rangtangaana nan iaai mumut. ");
INSERT INTO nal_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ka ra giu amun faaxoxovang ma amun faakilanang la pira Ijip ma xa valos naandi vataling a pira angkanaan. Ma xa valos naandi la non taas di vakilaan a Raas Memek ma lamaskana a non bingil wana a maariaas ka zangaaflu vaaralavaat. ");
INSERT INTO nal_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Naan Moses angbani xa ra vazei amun Israael naako, ‘Nakmai xana kalin azaxai zinim, ma xana balas a profet malasing nia nanga.’ ");
INSERT INTO nal_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mur amun Israael di balas fatu la non bingil, ma Moses ka iziar varaxai wana naandi. Naan ka uzaa la waatawut Saainaai ma a aangelo xa dador zina, ma xa lis a dorang ka rauxin a roroiang sina, xuna naana lis sin dia. ");
INSERT INTO nal_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Singsaxai amun kulmua zin dia di bain Moses ma xawit di los naan. Ma a maskana naandi xa uli xula pira Ijip. ");
INSERT INTO nal_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Di vazei Aaron malasing kari, ‘Kawit maadi rexaas aze ra zaan ka balas sin Moses, a rapti angbani ina xa zaxot fawat dia vataling a pira Ijip. Gu giu amun laklagaai amun nakmai aaxa maam kuna dina waamuain maam la lan.’ ");
INSERT INTO nal_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ma la raan angkanaan di giu a laklagaai a naata bulumagau ma di lis amun talazang ka waan sin a nakmai vaagit angkanaan. Ma di vaananam pana azaan angkanaan naadi giu la mita naandi nanga. ");
INSERT INTO nal_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Malasing ma Nakmai xa lis a torana zin naandi, ma xa vamalmalin pizin naandi di lotu wana a iaas ma a flan ma amun patpada ma amun saan malasing kanaan ka iziar laaxur la bara malasing di varaar vating lamaskana a baar zin amun profet malasing kari, ‘Malasing faa nim amun Israael, araan naagu ra iziar a maariaas ka zangaaflu vaaralavaat la non bingil, naagu zop famaat nanga tamun bulumagau ma sipsip kuna talazang surugu ma naagu lis tazanon talazang tawarak nanga xa wat surugu? Kawit. ");
INSERT INTO nal_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","A vaal maling angkanaan iwana lotu naagu vazaak, kawit a vaal maling iwana lotu zurugu, a vaal maling iwana lotu zin Molek, a nakmai vaagit, ma a laklagaaia watpada Refaan a nakmai zinim. Naan amun nakmai vaagit kari ina naagu giu xuna naaguna wisfarur. Malasing ma gana kling pizin nim fataling a kaantri zinim’ ma gana vaziaar nim laza non tawarak ka bilaas a pira Baabilon. ");
INSERT INTO nal_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","La non bingil amun kulmua zin dia di rauxin a vaal maling iwana lotu ina xa vatangin adu Nakmai xa raagul varaxai wana naandi. Naadi giu malasing Nakmai xa ra vazei Moses kana giu lalozang aze ra rataamaaiang Nakmai xa ra vatangin sina. ");
INSERT INTO nal_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lamur la notaan sin Josua, amun kulmua zin dia di zuruk a vaal maling angkanaan iwana lotu zin amun damana naandi, ma naadi vazaak araan di waan faraxai wana Josua ma di zuruk a pira zin amun lemlem aubina ina Nakmai xa vut pizin naandi lamarana amun kulmua zin dia. Ma xa iziar inaan ka ruaas pana a raan sin Dewit. ");
INSERT INTO nal_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nakmai xa rudaxain naan adu naan a rapti daxa. Ma Dewit ka ra maainung Nakmai xuna xana luaa naan kana giu a vaal xoxok aaxan Nakmai zin Jekop kana raagul lamaskana. ");
INSERT INTO nal_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Singsaxai Solomon ka giu a vaal aaxan Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Singsaxai Nakmai Laaxur Mase, xawit na rataagul lamun faal ubina di giu wana mita naandi. Ka malasing a profet ka piaat naako, ");
INSERT INTO nal_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘A Piran ka piaat naako, “A lia naan akin izi xalxaalang surugu, ma a pira angkari akin faiavuzang uru xaaku. Aze rawat faal naaguna giu aaxaku? Aze ranon aaxaku gana ziaavus pana? ");
INSERT INTO nal_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Malasing faa, xawit nia ga ra vaziaar amun saan faakdul angkari wana mirugu?” ’ ” ");
INSERT INTO nal_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stivan ka vazei Aiziarang iwana Aikilizang Laba malasing kari, “A waata nim ka dikdik. A maskana nim ma alngana nim ka rabanat ma naagu iziar lawalaau wana Nakmai. Naagui pukling bulaai wana a dorang sin a Laklagaai a Raabu, malasing amun kulmua zinim di ra gigiu. ");
INSERT INTO nal_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Aze ra profet mumua xa iziar ma amun kulmua zinim kawit di vamazik naan? Di ra zop famaat palau ubina ina mumua di pitfiaat a balazang sin A Rapti Xa Tak. Ma taning a rapti angkanaan ka balas faanong, ma naagu ngutlis naan sin amun purua ma naagu zop famaat palau naan, ");
INSERT INTO nal_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","nim ina naagu ra zuruk amun Lus sin Nakmai la mit amun aangelo, singsaxai xawit naagu valos.” ");
INSERT INTO nal_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Amun paamua iwana aikilizang di langarin a dorang sin Stivan, ma di mangat mase wana naan ma di xaraat famut alvana naandi wana naan. ");
INSERT INTO nal_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Singsaxai Stivan ka bas pana a Laklagaai a Raabu ma xa raamaai uzaa la lia ma xa raamin a marmari daxaiang sin Nakmai ma Iesu xai rur la mit sazaxa zin Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ma Stivan ka piaat naako, “Naagu raamin! Ga raamin a lia xa ralakas ma Naata Rapti xai rur la mit sazaxa zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Araan di langarin, di waakol amun lingana naandi ma di xupkup laba mase, ma di ramaraat faraxai ma di valau waan sina ma di zaraak naan. ");
INSERT INTO nal_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ma di burut fatukbilok naan ku lamanar ziaana a bina laba angkanaan ma di varumara tukang naan pana amun faat. Ubina ina di vakor naan, di gamul amun marapi baraaf sin naandi, ma naadi rasin lapaara xaaka Sol, aza xulaau. ");
INSERT INTO nal_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Araan di ituk Stivan, Stivan ka maainung naako, “Piran Iesu, gu zuruk a laklagaaiugu.” ");
INSERT INTO nal_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma xa zibukaak ma xa viraai laba naako, “Piran, tuaa gu xis faulin a matmalabuk taksaat angkari zin naandi!” Stivan ka piaat malasing kanaan ma xa maat. ");
INSERT INTO nal_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ma Sol xa rudaxa wana di zop famaat Stivan. Laraan angkanaan di zop famaat Stivan, di varumara vamazikang famarazaat aubina di inaxam paazaai di iziar Jerusalem. Ma naandi vaakdul di valau waan farawuk kula uru non pira Judia ma Samaaria, ma amun aaposal zingbe di iziar inaan Jerusalem. ");
INSERT INTO nal_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Azanon ubina dit lotu waan sin Nakmai, di xavin Stivan. Di maskalus marazaat ma di raangis laba mase. ");
INSERT INTO nal_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Singsaxai Sol xa saxot kana vanong fakdul aubina ina di inaxam paazaai wana Iesu. Ka albis lamaskana amun faal xa varas ma xa urif pizin ubina ma furavin ma xa rasin naandi lamaskana a vaal a vaamaazikang. ");
INSERT INTO nal_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Aubina ina di valaau varawuk ku lamun bina, di fazei wana a Dorang Daxa lamun non naadi waan pana. ");
INSERT INTO nal_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip ka waan laza bina laba in Samaaria ma xa fazei wana a Dorang Daxa zin a Mesaaia zin aubina di iziar inaan. ");
INSERT INTO nal_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Amala aubina, araan di langarin naan ma di raamin amun faakilanang iwana amun faamuzazang ka banglala naat fabalos, dit langar daxa wana amun saan Filip kai piaat sin naandi. ");
INSERT INTO nal_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Di raamin Filip ka mof pizin amun sapalaau ziaana aubina xa varas, ma amun sapalaau di raangis laba araan di tukbilak fataling aubina ina naadi ragul, ma amala di zipas ma amun kaaka naandi o amun mita naandi di raksaat, di balas daxa xaarik. ");
INSERT INTO nal_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Malasing ma adi nanamang mase xa balas la bina laba angkanaan. ");
INSERT INTO nal_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Aza rapti aizina xanaan Saaimon ka rai taaring. Naan ka iziar la bina angkanaan, ma xat fabanglala amun Samaaria wana a dikdikang iwana taaring sina. Ma xai piaat adu naan ka laaup mase. ");
INSERT INTO nal_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma aubina vaakdul ila bina laba angkanaan, naandi di rauxin aiza laba ma naandi walaau, dit langar daxa zina. Ma di piaat malasing kari, “Ka tak pana a rapti angkari di vakilaan adu A Dikdikang Laba zin Nakmai.” ");
INSERT INTO nal_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Dit falos naan panaze a raan ka varas faanong naan kat fabanglala naandi wana dikdikang iwana taaring sina. ");
INSERT INTO nal_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Singsaxai araan Filip ka fazei wana a Dorang Daxa iwana a bikabar zin Nakmai ma wana aizina Iesu Kaarisito, ubina ma furavin di inaxam paazaai ma naan ka baaptaais naandi. ");
INSERT INTO nal_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saaimon saait ka inaxam paazaai ma Filip ka baaptaais naan. Naan ka los farauxin Filip panaze xa banglala wana amun faakilanang laba ma amun faamuzazang ka banglala naa rataamin Filip ka vabalos. ");
INSERT INTO nal_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Amun aaposal ina di iziar Jerusalem di langarin adu aubina in Samaaria di rudaxain a dorang sin Nakmai, ma di kling Pita ma Jon di waan iaa zin naandi. ");
INSERT INTO nal_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Araan di balas iaa, di maainung iaa xuna Nakmai xana lis fawat a Laklagaai a Raabu zin naandi. ");
INSERT INTO nal_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Avuna a Laklagaai a Raabu xawit nanga na wat sin naandi, ma di baaptaais be wana aizina a Piran Iesu. ");
INSERT INTO nal_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pita ma Jon di rasin iaa a mita nandiaa laaxur wana naandi, ma a Laklagaai a Raabu xa iziar wana naandi. ");
INSERT INTO nal_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Araan Saaimon ka raamin adu a Laklagaai a Raabu xa iziar wana naandi araan Pita ma Jon di rasin iaa a mita nandiaa la waata naandi, naako xana lis a kaakaai zin nandiaa, ");
INSERT INTO nal_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ma xa piaat naako, “Naagu lis iaa a dikdikang kanaan saait surugu, xuna tamon gana rasin uru mirugu la waata axazak, a Laklagaai a Raabu xana iziar wana naan.” ");
INSERT INTO nal_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Singsaxai Pita xa xis naan naako, “Guna milung faraxai wana a kaakaai zunum, panaze gu naxaam adu guna wul luk a talazang sin Nakmai wana kaakaai! ");
INSERT INTO nal_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kawit gu rauxin ta non pana a vaamuzazang kari zimaam, panaze a maskaam kawit na tak lamarana Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Guna inaxam taawuk siaana ainaxamang taksaat angkanaan sunum ma guna maainung sin a Piran, kuna xana naxaam pizin ainaxamang kanaan la maskaam. ");
INSERT INTO nal_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Avuna ga raamin adu a maskaam ka mirik mase ma amun matmalabuk taksaat ka bulupis nua.” ");
INSERT INTO nal_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ma Saaimon ka vazei Pita ma Jon naako, “Ga saxot adu guna maainung iaa zin a Piran ku nia, xuna amun saan angkanaan naagu piaat iaa vanong kana wen balas surugu.” ");
INSERT INTO nal_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ma Pita ma Jon di pitfiaat iaa nanga a dorang sin a Piran, ma di uli iaa xun Jerusalem. Ma araan di zazangas puli iaa, di ifazei iaa wana a Dorang Daxa lamun bina xa varas ila pira Samaaria. ");
INSERT INTO nal_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A aangelo zin a Piran ka vazei Filip malasing kari, “Tamaraat ma gu waan ma gu los a lan ka wat Jerusalem ma xa kabal wizik Gaaza.” (A lan angkari xa lu labirua la non bingil.) ");
INSERT INTO nal_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ma Filip ka ramaraat ma xa waan. Ma la lan angkanaan, ka raamin a rapti ila pira Itiopia. Naan aza waamua laba ila bikabar zin Kendaas, a xalxaal ravin ila pira Itiopia. Naan kat katkatong a kaakaai zin a xalxaal ravin. Ka ra waan Jerusalem kuna wa lotuiang pana Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ma auliang sina xula bina zina, xa iziar wana a kaaris sina ma xat fakot a baar zin a profet Aaisaaia. ");
INSERT INTO nal_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma a Laklagaai a Raabu xa vazei Filip naako, “Guna zangas lapaara kaaris angkanaan.” ");
INSERT INTO nal_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Naanaan Filip ka valau waan pana kaaris, ma xa langarin naan kat fakot a baar zin a profet Aaisaaia. Ma xa iaari zina naako, “Malasing faa, gu mazaam a vuvuna dorang kanaan gut fakot, o xawit?” ");
INSERT INTO nal_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ma a waamua angkanaan ka xis naan naako, “Gana mitat mazaam? Tamon taxazak kana vazei vamaravaas nia wana, gana mazaam.” Ma xa maainung Filip kuna xana xawas puzaa laaxur ma xana iziar varaxai wana naan lamaskana a kaaris sina. ");
INSERT INTO nal_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A Dorang sin Nakmai lamaskana a baar naa vakot, ka piaat malasing kari, “Naan ka malasing a sipsip di valos naan kuna dina zop famaat, ma xa ziburung malasing a naata sipsip araan di fut pizin a vurna, xawit na kaas a balana. ");
INSERT INTO nal_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Di vamangil naan, ma aikilizang pana naan kawit na tak. Kawit taxazak kat faraxas kana kus pana amun natnaat sina, wanaze di ra vanong a roroiang sina la pira angkari.” ");
INSERT INTO nal_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","A waamua angkanaan ka iaari zin Filip naako, “Gu vazei nia, nis mase a profet angkari xa dador wana, xa dador wana naan o wana axazak tawarak?” ");
INSERT INTO nal_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ma Filip ka varumara wana a non angkanaan mase lamaskana a Baar Xoxok ma xa vazei naan pana a Dorang Daxa zin Iesu. ");
INSERT INTO nal_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Araan di valvalaau wizik iaa la lan pana kaaris, di wat iaa la non ka rauxin a daanim. Ma a waamua angkanaan ka piaat naako, “Taamin, ka rauxin a daanim kari. Aze xa ruxol nia xuna gana wen baaptaais?” ");
INSERT INTO nal_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","A waamua angkanaan ka vazei a rapti xai vut a os ka urif a kaaris sina xuna dina rur ma di rur. Filip ma a waamua angkanaan di kabal iaa, ma di waan iaa la daanim ma Filip ka baaptaais naan. ");
INSERT INTO nal_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Araan di luaa iaa a daanim ma di zangas puat iaa laaxur, fazaaus mase a Laklagaai a Raabu xa zaxot pizin Filip siaana. Ma a waamua angkanaan kawit kaarik na raamin Filip, singsaxai xa waan faraxai wana nanamang. ");
INSERT INTO nal_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip ka balas la bina laba Aazotas, ma xa waan farawuk lamun bina ma xai fazei wana a Dorang Daxa xa ruaas la bina laba Sesaria. ");
INSERT INTO nal_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lamun taan angkanaan Sol xat maandaau nanga wana dador dikdikang pana aubina dit falos a Piran adu xana zop famaat naandi. Naan ka waan sin a waamua zin amun pris faakdul, ");
INSERT INTO nal_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma xa iaari zina tamon kat faraxas naan kana varaar lis amun paambaar xa waan sin amun paamua ilamun faal a maainungang sin amun Judaa la bina laba Daamaaskas. Amun baar angkanaan ka lis a dor rudaxaiang kuna tamon kana tangin amun Judaa inaan, naandi dit falos a Lan sin a Piran, kana zaraak fating naandi. Naapalaau tamon naandi ubina o a furavin, kana zaxot paanin naandi Jerusalem. ");
INSERT INTO nal_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ma Sol xa zangas paan Daamaaskas faraxai wana amun paambaar angkanaan. Araan naan ka zazangas faasilik, fazaaus mase a adi maravas laba inikula la lia xa wilaak naan. ");
INSERT INTO nal_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ka zu wizik paanaburut la pira ma xa langarin a linga axazak ka piaat sina naako, “Sol, Sol, xunaze gu vamazik nia?” ");
INSERT INTO nal_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ma Sol xa iaari naako, “Piran, nua nis?” A ling axazak angkanaan ka piaat sina malasing kari, “Nia Iesu, ina gut famazik nia. ");
INSERT INTO nal_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Naari gu ramaraat ma gu zangas kula bina laba ma inaan axazak kana vazei nua wana aze razaan guna giu.” ");
INSERT INTO nal_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Aubina ina di wat faraxai wana Sol, xawit nat faraxas dina piaat tazaan, panaze naandi zaait di langarin a ling axazak, singsaxai xawit di raamin naan. ");
INSERT INTO nal_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol xa ramaraat paanaburut la pira ma xa kaas uru marana, singsaxai xawit na raamin luk tazaan. Malasing ma di taaxur la mitna ma di vindaan naan kun Daamaaskas. ");
INSERT INTO nal_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A raan urul naan kawit nat faraxas kana raamin tazaan ma xawit na imimin ma xawit na vavangan. ");
INSERT INTO nal_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A rapti varaviraai zin Iesu xa iziar la bina laba Daamaaskas, aizina Aananiaas. Naan ka miriftaain a rataamaaiang ma lamaskana a rataamaaiang kanaan, a Piran ka viring naan naako, “Aananiaas!” Ma xa xis naan naako, “Piran, nia xari.” ");
INSERT INTO nal_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ma a Piran ka piaat sina naako, “Tamaraat ma gu waan la vaal zin Judaas la lan di vakilaan A Lan Ka Tak, ma gu iaariin a rapti in Taasas aizina Sol, avuna naan kat maainung. ");
INSERT INTO nal_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ma lamaskana a rataamaaiang naan ka miriftaain a rapti aizina Aananiaas ka wat libis ma xa rasin uru mitna laaxur wana naan kuna xana raamaai xaarik.” ");
INSERT INTO nal_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ma Aananiaas ka xis naan malasing kari, “Piran, ga langarin amala di dador wana a rapti angkanaan ma amun matmalabuk taksaat naa gigiu wana aubina ninis sunum di iziar Jerusalem. ");
INSERT INTO nal_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma naan ka zazangas puat iriat Daamaaskas faraxai wana a burburaaiang sin amun pris laba xuna xana zaraak fating aubina vaakdul ina dit fakilaan aizinum.” ");
INSERT INTO nal_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ma a Piran ka piaat sina naako, “Nua gu waan sina, wanaze ga kalin fanong naan kana los nia, ma naan kana vazaak aizinugu xa waan sin aubina xawit amun Judaa ma amun kalxaal zin naandi ma zin aubina in Israael. ");
INSERT INTO nal_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Gana vatangin atavura amun maazikang ma maravanang ina naana vazaak lalozang aizinugu.” ");
INSERT INTO nal_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ma Aananiaas ka waan ma xa albis la vaal zin Judaas. Ma xa rasin uru mitna wana Sol ma xa piaat naako, “Sol, daazugu, a Piran Iesu ina xa balas sunum la lan araan gu zazangas puat kunitiat, ka kling fawat nia xuna nua guna raamaai xaarik ma a Laklagaai a Raabu xana sfaar nua.” ");
INSERT INTO nal_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","La notaan angkanaan mase, amun saan malasing amun karang iwana ian ka zu lamarana, ma naan kat faraxas kana raamaai xaarik. Naan ka ramaraat ma Aananiaas ka baaptaais naan. ");
INSERT INTO nal_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma xa vangan ma a dikdikang sina xa uli xaarik. Sol xa iziar wana azanon taan inaan Daamaaskas faraxai wana aubina varaviraai zin Iesu. ");
INSERT INTO nal_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Fazaaus mase naan ka albis lamaskana amun faal a maainungang sin amun Judaa ma xa fazei malasing kari, “Iesu naan Naata Nakmai.” ");
INSERT INTO nal_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma naandi di langarin, di raknar ma di iaari malasing kari, “Naan bani a rapti ina xa iziar Jerusalem ma xai kawin aubina di inaxam paazaai wana Iesu. Ma xa wat kari iriat kuna xana zaraak fating naandi ma xana zaxot naandi xa waan sin amun pris laba, aan?” ");
INSERT INTO nal_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Singsaxai a dikdikang sin Sol xa laba uzaa uzaa ma xat fatangin adu Iesu, naan a Mesaaia. Ma a dorang sina xa maravan mase ma amun Judaa di iziar Daamaaskas kawit nat faraxas dina xis naan. ");
INSERT INTO nal_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Amun taan ka varas ka waan faanong, ma amun Judaa di wat fatu ma di pis a dorang kuna zop famaatang Sol, ");
INSERT INTO nal_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","singsaxai Sol xa langarin a dorang naadi pis. Lawaanaas ma labung di rataamaai xaaul lamun marana mara xu lamaskana a bina laba xuna dina zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Singsaxai aza labung azanon ubina ina di ilos amun faraviraaiang sina, di sfaar naan lamaskana adi laxa laba ma di pis farokin fawizik naan paanaburut pana a luk lamaskana a balavaat faraxulinang a bina laba. ");
INSERT INTO nal_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol xa uli Jerusalem ma xa saxot kana vaamuzas faraxai wana aubina varaviraai zin a Piran. Singsaxai naandi xawit di naxaam adu naan a rapti varaviraai vaaratunaan, ma di marauring naan. ");
INSERT INTO nal_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Singsaxai Baanabaas ka vawaal naan ma xa zaxot lis naan sin amun aaposal. Naan ka vamaravaas naandi adu Sol xa ra raamin a Piran la lan, ma a Piran ka dador zina. Ka vazei naandi adu Sol xawit na maraaut ma xa fazei wana aizina a Piran inaan Daamaaskas. ");
INSERT INTO nal_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Naanaan Sol xa iziar xa varaxai wana naandi ma xa zazangas farawuk lamun non faakdul inaan Jerusalem, ma xai fazei dikdik pana aizina a Piran ma xawit na maraaut. ");
INSERT INTO nal_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma xai dador dikdik ma xat faramakalaai varaxai wana amun Judaa ina di wukpuk a linga bina Grik, ma naandi di pis a dorang kuna dina zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Araan aubina ina di inaxam paazaai di langarin, di zaxot fawizik naan paanaburut la bina laba Sesaria ma di kling naan kula bina laba Taasas. ");
INSERT INTO nal_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Malasing ma aubina di inaxam paazaai ila non faakdul in Judia, Gaalili ma Samaaria di izi vatkul ma Nakmai xa vadikdik naandi, ma a vaakatang sin aubina di inaxam paazaai xa uzaa laaxur wanaze a Laklagaai a Raabu xa dador vawaal naandi, ma dit marauring a Piran ma di ilis a varanopang sina. ");
INSERT INTO nal_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Araan Pita xa zazangas farawuk lamaskana amun non faakdul ila pira Judia, aza raan naan ka wa raamin aubina ninis sin Iesu ina di rataagul la bina Lida. ");
INSERT INTO nal_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ma inaan ka tangin a rapti, aizina Aainiaas, ka zipas ma xawit nat faraxas kana ramaraat fataling a iban sina, wana a maariaas ka wizik tul. ");
INSERT INTO nal_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Pita xa piaat sina naako, “Aainiaas, Iesu Kaarisito xa vira nua! Tamaraat ma gu plim amun saan imilaaivang sunum.” Fazaaus mase Aainiaas ka ramaraat. ");
INSERT INTO nal_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aubina vaakdul di rataagul inaan la bina Lida ma la bina Seron di raamin a rapti angkanaan ka balas daxa xaarik ma di inaxam taawuk paan sin a Piran. ");
INSERT INTO nal_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ka rauxin a ravin ka iziar la bina Jopaa, aizina Taabita, (wana a linga bina Grik adu Dokaas) naan a ravin faraviraai zin Iesu. Ma xa gigiu bulin amun matmalabuk daxa ma xat fawaal aubina di iziar gogof. ");
INSERT INTO nal_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","La notaan angkanaan naan ka gias ma xa maat. Di tus naan ma di vamaal naan lamaskana a rumaaf la vaal laaxur. ");
INSERT INTO nal_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A bina Lida xa iziar lapaara bina Jopaa. Ma araan aubina di inaxam paazaai in Jopaa di langar adu Pita xa iziar Lida, di kling uru rapti xa waan sina, varaxai wana dorang malasing kari, “Guna wat faabuza xalaak.” ");
INSERT INTO nal_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita xa ramaraat ma xa waan faraxai wana nandiaa. Araan ka balas, di zaxot fauzaa naan lamaskana rumaaf laaxur. Amun taksiziar vaakdul di irur varaxulin Pita ma di rataangis ma dit fatangin amun marapi ina Dokaas ka rat saxazit la raan ka roro nanga. ");
INSERT INTO nal_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita xa kling fatukbilok naandi vaakdul xu lamanar, ma xa zibukaak ma xa maainung. Ka plaas a marana xa waan sin a ravin ina xa maat ma xa piaat naako, “Taabita, tamaraat.” Taabita xa kaas uru marana ma xa raamin Pita ma xa ziar. ");
INSERT INTO nal_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita xa roting a mitna ma xa varamaraat naan. Ma xa viring aubina di inaxam paazaai ma amun taksiziar ma xa zaxot lis Taabita zin naandi, xa roro uli vaanong. ");
INSERT INTO nal_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A dorang iwana a vaamuzazang kanaan ka banglala xa waan farawuk lamun non faakdul ila bina Jopaa, ma amala aubina di inaxam paazaai wana a Piran. ");
INSERT INTO nal_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Pita xa raagul inaan Jopaa wana azanon taan faraxai wana a rapti aizina Saaimon. Naan ka gigiu amun saan pana a wina bulumagau. ");
INSERT INTO nal_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ka rauxin a rapti xa iziar la bina Sesaria, aizina Konilias, naan aza waamua zin azangaaflu varazuai ubina dauran ikula Rom, naandi ilamaskana a lemlem di vakilaan naandi, “Ubina Dauran In Itali.” ");
INSERT INTO nal_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Konilias faraxai wana amun fatina vaakdul zina di iwisfarur Nakmai ma di gigiu amun matmalabuk daxa Nakmai xai saxot, ma dit maraaut pana Nakmai ma dit faranop pana naan. Azaan ka varas naa ra gigiu zaait aaxan amun Judaa xuna vawaalang naandi di iziar gogof ma bulaai xat maainung sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Aza raan, ka malasing a marana iaas urul languzaraaf, naan ka miriftaain a rataamaaiang. Ka raamin fakilaan a aangelo zin Nakmai xa wat sina ma xa piaat naako, “Konilias!” ");
INSERT INTO nal_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias ka damin a aangelo wanaze xa maraaut, ma xa piaat naako, “Piran, gu piaat aze?” A aangelo xa piaat sina naako, “Nakmai xa rudaxain amun maainungang sunum ma amun faawalang sunum pana naandi di iziar gogof. Ma amun matmalabuk angkanaan ka malasing a talazang ina Nakmai xa nanam pana. ");
INSERT INTO nal_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ma naari guna kling azanon ubina xun Jopaa xuna dina zaxot a rapti, aizina Saaimon ma aza izina Pita. ");
INSERT INTO nal_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Naan a ropuran la vaal zin a rapti xa gigiu amun saan pana wina bulumagau, aizina Saaimon, ma a vaal zina xa iziar lapaara raas.” ");
INSERT INTO nal_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Araan a aangelo xa waan faanong, Konilias ka viring luk uru iaana kilaaiang sina ma a rapti dauran ina xa gigiu a matmalabuk Nakmai xai saxot ma naan azaxai zin ubina ina dit faamuzas fawaal Konilias. ");
INSERT INTO nal_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ma Konilias ka vazei vamaravaas naandi wana amun saan faakdul xa balas sina ma xa kling naandi xula bina Jopaa. ");
INSERT INTO nal_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A raan lamuraana, a marana iaas ka izi vaatak, araan nandiaal di zazangas taal faasilik la bina Jopaa xuna dina balas, Pita xa uzaa laaxur la waata vaal xuna maainungang. ");
INSERT INTO nal_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Naan ka lagaai ma xa saxot kana iaan tazaan, singsaxai dit nimnimanin nanga a vanganang. La notaan angkanaan naan ka miriftaain a rataamaaiang. ");
INSERT INTO nal_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ka raamin a bara xa ralakas ma azaan di vakabaal xu waanaburut malasing a xabaraai laba, xa rauxin a ritna urulavaat di roting pana ma di rasin fawat paanaburut la pira. ");
INSERT INTO nal_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wana a xabaraai angkanaan ka rauxin a tavur amun kak talavaat ma atavur amun saan faakdul di ios pana xuna naandi ma atavura amun maani vaakdul. ");
INSERT INTO nal_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ma xa langarin a ling axazak ka piaat sina naako, “Pita, tamaraat, guna zop famaat amun faabus angkari ma guna vangan!” ");
INSERT INTO nal_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Singsaxai Pita xa piaat naako, “Piran, kawit mase. Ga wen iaan nanga tawat saan malasing kari xa maak ma xa mitikaai lamaraam.” ");
INSERT INTO nal_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ma a ling angkanaan ka varua xaarik a piaatang sina naako, “Azaan ina Nakmai xa ra vaninis fanong, tuaa gu piaat adu xa mitikaai.” ");
INSERT INTO nal_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ma a xabaraai angkanaan ka balas faarul ma fazaaus mase xa uli xaarik kula bara. ");
INSERT INTO nal_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita xa inaxam pana aze ra vuvuna rataamaaiang kanaan sina. Ma la notaan angkanaan mase, ubina ina Konilias ka ra kling naandi, di zazaleng a vaal zin Saaimon, di wat tur lamarana mara ila vaal zina. ");
INSERT INTO nal_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Di viraai ma di iaari tamon ka rauxin a rapti Saaimon aza izina Pita xa iziar inaan. ");
INSERT INTO nal_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Singsaxai naan ka inaxam nanga wana aze ra vuvuna rataamaaiang kanaan. La notaan angkanaan a Laklagaai a Raabu xa vazei naan naako, “Langar! A rapti urul di zazaleng taal nua. ");
INSERT INTO nal_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gu ramaraat ma gu kabal wizik paanaburut. Tuaa gu inaxam marazaat, gu los naandi wanaze nia ga kling fawat naandi.” ");
INSERT INTO nal_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ma Pita xa kabal wizik paanaburut ma xa vazei naandi naako, “Nia a rapti angkanaan naagu zazaleng. Kunaze naagu wat?” ");
INSERT INTO nal_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ma di xis naan malasing kari, “A waamua zin ubina dauran, Konilias, ka kling fawat maam. Naan ka tak ma xat maraaut pana Nakmai ma xat faranop pana naan. Ma amun Judaa vaakdul di nop naan. A aangelo xoxok sin Nakmai xa vazei naan kuna zaxotang nua xa waan la vaal zina, ma xana langar wana a dorang guna vazei naan pana.” ");
INSERT INTO nal_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ma Pita xa maainung naandi ma di albis lamaskana a vaal ma xa vazei naandi adu dina iziar varaxai inaan labung angkanaan. A raan lamuraana, Pita xa nimniman ma xa waan faraxai wana nandiaal, ma azanon ubina di inaxam paazaai in Jopaa di saxat sina. ");
INSERT INTO nal_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ma a raan lamuraana, naan faraxai wana naandi di balas la bina Sesaria. Konilias ka iziar zimbong naandi varaxai wana azanon taauna ma azanon paasaxo daxa zina ina naa viring fatu naandi. ");
INSERT INTO nal_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita xa albis lamaskana vaal zin Konilias, ma Konilias ka vasuin naan, ma xa zibukaak lamarana Pita ma xa wisfaru naan. ");
INSERT INTO nal_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Singsaxai Pita xa varamaraat naan ma xa piaat naako, “Tamaraat, nia a rapti be malasing nua.” ");
INSERT INTO nal_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Araan Pita xai dador nanga varaxai wana Konilias, ka albis ma xa tangin amala aubina di izi vatu. ");
INSERT INTO nal_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma xa piaat sin naandi naako, “Nim nanga naagu rexaas faanong adu a varaviraaiang iwana lotu zin amun Judaa xa piaat adu xawit nat faraxas axazak sin dia xana paasaxo varaxai wana aubina xawit amun Judaa o xana iziar varaxai wana naandi. Singsaxai Nakmai xa ra vatangin surugu adu tuaa gana vakilaan axazak adu naan ka maak o xa mitikaai lamarana Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Malasing ma araan naagu kilaai xu nia, ga ramaraat ma ga wat, ma xawit ga pukling lawaana dorang sinim. Ma gana iaari xalaak sinim, kunaze naagu kilaai xu nia?” ");
INSERT INTO nal_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilias ka xis naan naako, “A raan urul xa waan faanong pana notaan angkari, lamarana iaas urul languzaraaf, gat maainung lamaskana a vaal zurugu. Ma fazaaus mase a rapti, a mamaauzang sina xa wilwilak, ka wat tur lamaraagu. ");
INSERT INTO nal_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ma xa piaat naako, ‘Konilias! Nakmai xa langarin a maainungang sunum ma xa naxaam faulin amun talazang sunum pana naandi di iziar gogof. ");
INSERT INTO nal_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Guna kling tazanon dina waan la bina Jopaa xuna dina zaxot fawat a rapti aizina Saaimon, ma aza izina Pita. Naan a ropuran ka iziar varaxai wana Saaimon, a rapti xa gigiu amun saan pana a winpina bulumagau, ma xa iziar lapaara raas.’ ");
INSERT INTO nal_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Malasing ma ga kling fazaaus amun iaana kilaaiang surugu xuna dina zaxot fawat nua, ma xa daxa gu wat. Naari maadi iziar lamarana Nakmai xuna maadina langarin a dorang faakdul ina a Piran ka ra vazei nua guna piaat simaam.” ");
INSERT INTO nal_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita xa varumara a dadorang sina ma xa piaat naako, “Naari ga raamin fakilaan adu xa vaaratunaan Nakmai xawit nai waafatalamin be azanon tawarak, singsaxai xa rataamin aubina vaakdul malasing a lemlem azaxai. ");
INSERT INTO nal_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nakmai xana rudaxain axazak ka marauring naan ma xa nop naan ma xa giu amun saan ka tak, naapalaau axazak angkanaan ila aze rawat lemlem aubina. ");
INSERT INTO nal_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nim naagu rexaazin a dorang Nakmai xa lis sin aubina in Israael, naan a Dorang Daxa ina xa rasin a luaai lawalaua Nakmai ma aubina lamaskana Iesu Kaarisito, naan a Piran sin aubina vaakdul ila pira angkari. ");
INSERT INTO nal_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nim naagu rexaazin a lagazaai iwana amun saan laba Iesu xa ra giu lamun non faakdul iriat la pira Judia. Ka varumarain la pira Gaalili, lamuraana Jon ka ra fazei wana a dorang iwana baaptaaizang. ");
INSERT INTO nal_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nim naagu rexaas adu Nakmai xa ra kalin Iesu in Naazaret ma xa ra lis a dikdikang sina ma a Laklagaai a Raabu xa ra iziar wana naan. Nakmai xa iziar varaxai wana naan malasing ma naan ka waan farawuk ma xat gigiu amun faamuzazang daxa ma xat fira aubina ina Saatan ka bulupis naandi. ");
INSERT INTO nal_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Maam kari maadi raamin amun saan faakdul naa ra giu la pira zin amun Judaa ma inaan Jerusalem. Di varokin naan laaxur wana a robuxul ma di zop famaat naan. ");
INSERT INTO nal_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Singsaxai Nakmai xa varamaraat faulin naan pana maatang la varulang a raan, ma xa ra vatangin naan la maravas, ");
INSERT INTO nal_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kawit sin aubina vaakdul, singsaxai zimaam, ina Nakmai xa ra kalin ma maadi raamin naan ma maadi fazei wana a dorang sina. Maam ina maadi vangan ma maadi imin faraxai wana naan lamuraana xa ramaraat puli wana maatang. ");
INSERT INTO nal_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma xa dador dikdik simaam kuna fazeiang sin aubina wana a Dorang Daxa ma maadina pitfiaat adu naan axazak ina Nakmai xa ra kalin naan kana klis aubina di roro ma di maat faanong. ");
INSERT INTO nal_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Amun profet faakdul di pitfiaat naan adu nis ka inaxam paazaai wana naan, Nakmai xana naxaam pizin amun matmalabuk taksaat sina lamaskana aizina Iesu.” ");
INSERT INTO nal_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita xai dador nanga ma a Laklagaai a Raabu xa wat iziar wana naandi vaakdul ina dit langarin a dorang sina. ");
INSERT INTO nal_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","A Laklagaai a Raabu xa lis a talazang sin naandi iwana wukang amun linga bina vaaxur malasing ma di wukpuk amun linga bina vaaxur ma di wisfaru Nakmai. Naandi xawit amun Judaa. Ma amun Judaa ina di inaxam paazaai, di ra wat faraxai wana Pita, di langarin ma di banglala wana azaan angkanaan. Ma Pita xa piaat naako, ");
INSERT INTO nal_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“A Laklagaai a Raabu xa wat iziar wana naandi malasing be xa ra wat iziar wana dia. Malasing faa, xat faraxas taxazak kana ruxol naandi xuna dina wen baaptaais pana daanim?” ");
INSERT INTO nal_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Malasing ma naan ka dador dikdik sin naandi adu dina baaptaais naandi wana aizina Iesu Kaarisito. Ma naandi di giu malasing kanaan. Naanaan di iaari zina xuna xana iziar varaxai wana naandi wana azanon taan. ");
INSERT INTO nal_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Amun aaposal varaxai wana aubina di inaxam paazaai ilamun bina vaakdul in Judia di langar adu aubina xawit amun Judaa zaait di rudaxain fanong a dorang sin Nakmai. ");
INSERT INTO nal_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Singsaxai araan Pita xa uli uzaa Jerusalem, aubina di inaxam paazaai ina di dikdik pana valozang a matmalabuk iwana ftuk pizinang a vang pakpak, di klis naan. ");
INSERT INTO nal_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Di piaat malasing kari, “Nua a ropuran lamaskana vaal zin naandi aubina xawit amun Judaa, ina xawit di ftuk pizin a vang pakpaaka naandi ma gu vangan faraxai wana naandi.” ");
INSERT INTO nal_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ma Pita xa vamaravaas naandi wana amun saan faakdul xa balas malasing kari, ");
INSERT INTO nal_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nia ga maainung la bina Jopaa ma ga miriftaain a rataamaaiang. Ga raamin azaan di vakabaal vawat ikula la bara wana uritna urulavaat, ka malasing adi xabaraai laba ma xa wat surugu. ");
INSERT INTO nal_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ga raamaai lamaskana ma ga raamin amun kak talavaat ina aubina dit katkatong ma azanon di wungpung ma amun saan di ios pana a xuna naandi ma amun maani. ");
INSERT INTO nal_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma ga langarin a ling axazak ka piaat surugu malasing kari, ‘Pita, tamaraat, guna zop famaat amun faabus angkari ma guna vangan.’ ");
INSERT INTO nal_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Singsaxai nia ga piaat malasing kari, ‘Piran, kawit mase. Ga wen i iaan nanga tawat saan ka maak o xa mitikaai lamaraam.’ ");
INSERT INTO nal_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ma a ling ikula la lia xa varua xaarik a piaatang surugu naako, ‘Azaan ina Nakmai xa ra vaninis fanong, tuaa gu piaat adu xa mitikaai.’ ");
INSERT INTO nal_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Azaan angkanaan ka balas faarul ma fazaaus mase amun saan faakdul di uli xaarik kula bara. ");
INSERT INTO nal_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","La non taan angkanaan mase a rapti urul di balas la vaal nia ga iziar wana. Naandi di vinang Sesaria. ");
INSERT INTO nal_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma a Laklagaai a Raabu xa vazei nia xuna waanang faraxai wana naandi ma tuaa gana inaxam marazaat. Ma amun daazugu lamaskana Kaarisito naandi angkari di wizik saaxa, di saxat faraxai wana nia ma maadi albis la vaal zin Konilias. ");
INSERT INTO nal_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Naan ka vazei maam adu xa raamin a aangelo xa irur lamaskana a vaal zina ma a aangelo xa piaat sina malasing kari, ‘Gu kling tazanon ubina xun Jopaa xuna dina zaxot luk Saaimon aza izina Pita. ");
INSERT INTO nal_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Naan kana fazei zunum faraxai wana naandi vaakdul di iziar la vaal zunum pana dorang ma naaguna inaxam paazaai ma Nakmai xana zaxot faulin nim.’ ");
INSERT INTO nal_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ma araan kawit nanga ga dador vaabung baraaf, a Laklagaai a Raabu xa wat iziar wana naandi zaksaxai malasing be la raan a Laklagaai a Raabu xa wat iziar wana dia la varumaraiang. ");
INSERT INTO nal_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma ga naxaam faulin a dorang sin a Piran ka ra piaat malasing kari, ‘Jon ka baaptaais aubina wana daanim singsaxai nim naaguna zuruk a baaptaais pana a Laklagaai a Raabu.’ ");
INSERT INTO nal_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ka maravas adu Nakmai ra lis a Laklagaai a Raabu zin aubina xawit amun Judaa, malasing be naa lis sin dia, wanaze dia ma naandi zaait di laanga inaxam paazaai wana a Piran Iesu Kaarisito. Malasing ma nia nis kuna ruxolang a vaamuzazang sin Nakmai?” ");
INSERT INTO nal_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Naandi di langarin ma ainaxamang sin naandi xa tate daxa ma di wisfaru Nakmai. Di piaat malasing kari, “Ka vaaratunaan adu Nakmai xai lis saait a matmalabuk iwana inaxam taawukang sin aubina xawit amun Judaa ma a matmalabuk angkanaan kana valos naandi wana roro tapal.” ");
INSERT INTO nal_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lamuraana a raan di zop famaat Stivan, amala aubina di ra lis a maazikang sin aubina di inaxam paazaai malasing ma di valaau varawuk. Azanon sin naandi di zangas paan lawalaau xula pira Fonisia ma xula xurunuza Saaipras ma la bina laba Entiok. Singsaxai di ifazei wana a Dorang Daxa zin Iesu xa waan sin amun Judaa be ma xawit sin aubina rawarak. ");
INSERT INTO nal_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Singsaxai azanon ubina di inaxam paazaai ila xurunuza Saaipras ma ila bina laba Saairini, di waan Entiok ma di fazei inaan sin amun Judaa ma aubina xawit amun Judaa zaait pana a Dorang Daxa zin a Piran Iesu. ");
INSERT INTO nal_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A mita Piran ka iziar wana ubina ina di fazei ma amala aubina di inaxam paazaai ma di inaxam taawuk paan sin a Piran. ");
INSERT INTO nal_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","A dorang pana azaan angkanaan ka balas sin aubina di inaxam paazaai Jerusalem malasing ma di kling Baanabaas ka waan Entiok. ");
INSERT INTO nal_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Araan naan ka balas ma xa raamin a fnuaai iwana a daxaiang sin Nakmai, xa nanam ma xa vadikdik naandi vaakdul xuna dina iru dikdik lamaskana Piran pana a maskana naandi vaakdul. ");
INSERT INTO nal_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Baanabaas a rapti daxa, xa bas pana a Laklagaai a Raabu ma ainaxam paazaaiang sina xa dikdik. Ma di zaxot fawat amala aubina zin a Piran. ");
INSERT INTO nal_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mur Baanabaas ka waan Taasas kuna zalengang Sol. ");
INSERT INTO nal_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Naan ka tangin Sol ma xa zaxot naan kun Entiok. A maariaas azaxai vaakdul nandiaa di iziar iaa varaxai wana aubina di inaxam paazaai ila bina angkanaan ma dit firaai iaa amala aubina wana dorang sin Nakmai. Aubina in Entiok di tabung fakilaan aubina di inaxam paazaai wana aiza angkari Kristian. ");
INSERT INTO nal_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lamun taan angkanaan azanon profet di ramaraat ikula Jerusalem ma di kabal wat Entiok. ");
INSERT INTO nal_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Axazak sin naandi, aizina Aagabus, ka ruzaa ma wana a dikdikang sin a Laklagaai a Raabu xa pitfiaat adu adi zong laba xana balas lamun pira vaakdul amun Rom di xatkatong. (La notaan angkanaan Klodias ka waamua zin amun Rom.) ");
INSERT INTO nal_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aubina varaviraai inaan Entiok di dador adu dina vawaal amun taatum sin naandi lamaskana Kaarisito di iziar Judia. Di lis aze xat faraxas naadina lis. ");
INSERT INTO nal_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Naandi di giu malasing kanaan ma di iaalis kaakaai la mita Baanabaas ma Sol, ma di lis iaa zin amun paamua iwana lotu inaan Jerusalem. ");
INSERT INTO nal_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lamaskana notaan angkanaan a xalxaal Erot ka zaraak azanon aubina di inaxam paazaai wana Iesu xuna vamazikang naandi. ");
INSERT INTO nal_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Naan ka kip pizin a vuruna Jems, daaza Jon pana a baainaat. ");
INSERT INTO nal_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ma araan ka raamin adu azaan angkanaan ka vananam amun paamua zin amun Judaa, xa zaraak fating saait Pita. Naari xa balas la raan laba zin amun Judaa, a raan iwana Raraba Xawit A Is. ");
INSERT INTO nal_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lamuraana di zaraak fating Pita, di rasin naan lamaskana vaal a vaamaazikang. Inaan di lis naan la mita lemlem urulavaat ubina dauran. Ubina urulavaat lamaskana lemlem azaxai xuna iru xaaulang pana naan. Erot ka naxaam adu xana rasin naan pana aikilizang lamarana aubina lamuraana A Raan Laba Iwana Zangas Fasaalang. ");
INSERT INTO nal_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Malasing ma Pita xa iziar lamaskana a vaal a vaamaazikang, singsaxai aubina di inaxam paazaai dit maainung dikdik sin Nakmai xuna vawaalang naan. ");
INSERT INTO nal_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Labung angkanaan paamua wana Erot kana varur Pita wana aikilizang, Pita xai milaaif labirua wana uru rapti dauran. Naan kawit nat faraxas kana valaau wanaze di pis fating naan pana a iaarus a sen urua, ma ubina dauran di rataamaai xaaul lamarana mara. ");
INSERT INTO nal_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Fazaaus mase a aangelo zin a Piran ka balas inaan, ma a maravas ka wilaak a maskana a non angkanaan. A aangelo xa wit pangun Pita la ritna ma xa piaat sina naako, “Fazaaus! Tamaraat!” Ma uru iaarus a sen di zu iaa la ru mita Pita. ");
INSERT INTO nal_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ma a aangelo xa piaat naako, “Pis fating a let sunum, ma pis saait uru su zunum.” Ma Pita xa giu malasing a aangelo xa piaat sina. Ma a aangelo xa piaat kaarik naako, “Kavut nua wana a marapi baraaf sunum, ma los nia.” ");
INSERT INTO nal_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita xa los naan ku lamanar. Naan kawit na rexaas adu azaan angkanaan a aangelo xa gigiu xa balas faaratunaan. Ka naxaam adu naan ka rataamin a rataamaaiang be. ");
INSERT INTO nal_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Di tabung sangas bilaas iaa aza non, uru rapti dauran di rataamaai xaaul iaa wana ma lamur di bilaas iaa xaarik azanon ubina dauran 