﻿USE sofia;
DROP TABLE IF EXISTS sofia.nag_vpl;
CREATE TABLE nag_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nag_vpl WRITE;
INSERT INTO nag_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraham laga chokra, David laga chokra, Jisu Khrista laga purbo khandan laga likhi kene rakha kitab. ");
INSERT INTO nag_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, Isaac laga baba hoise, aru Isaac, Jacob laga baba hoise, aru Jacob, Judah aru tai laga bhai-kokai khan laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah pora Perez laga baba, aru Zerah pora Tamar laga baba, Perez pora Hezron laga baba hoise, aru Hezron, Ram laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram, Amminadab laga baba hoise, aru Amminadab, Nahshon laga baba hoise, aru Nahshon, Salmon laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, Boaz laga baba hoise, etu to Rahab logot pora hoise, aru Boaz, Obed laga baba Ruth logot pora hoise, aru Obed, Jesse laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse, Raja David laga baba hoise, aru David, Solomon laga baba, Uriah laga maiki logot pora hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon pora Rehoboam laga baba hoise, aru Rehoboam pora Abijah laga baba hoise, aru Abijah pora Asa laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa pora Jehoshaphat laga baba hoise, aru Jehoshaphat pora Joram laga baba hoise, aru Joram pora Uzziah laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah pora Jotham laga baba hoise, aru Jotham pora Ahaz laga baba hoise, aru Ahaz pora Hezekiah laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah pora Manasseh laga baba hoise, aru Manasseh pora Amon laga baba hoise, aru Amon pora Josiah laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah pora Jechoniah aru tai laga bhai-kokai khan laga baba hoise jitia taikhan ke Babylon desh te dhurikene loi jaise. ");
INSERT INTO nag_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babylon te loija pichete, Jechoniah pora Shealtiel laga baba hoise, aru Shealtiel pora Zerubbabel laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel pora Abiud laga baba hoise, aru Eliakim pora Azor laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor pora Zadok laga baba hoise, aru Zadok pora Achim laga baba hoise, aru Achim pora Eliud laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud pora Eleazar laga baba hoise, aru Eleazar pora Matthan laga baba hoise, aru Matthan pora Jacob laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob pora Joseph laga baba hoise, jun laga maiki Mary asele, jun pora Jisu ke jonom dise, aru Khrista koi kene matise. ");
INSERT INTO nag_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Etu karone, sob khandan Abraham pora loi kene David tak choudah khandan thakise, aru David pora loi kene jun khan ke Babylon te loi jaise aru Jisu Khrista laga jonom etu tak choudah khandan thakise. ");
INSERT INTO nag_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisu Khrista laga jonom eneka pora hoise. Tai laga ama, Mary Joseph ke shadi kori bole kotha milai loise, kintu tai duijon shadi nohua age te, Pobitro Atma dwara bacha pet te bukhi ja jani jaise. ");
INSERT INTO nag_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kintu Joseph, tai laga mota, ekjon dharmik manu asele aru sob manu age te taike bodnam nadibo nimite, tai lukaikene taike chari bole bhabona kori loise. ");
INSERT INTO nag_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jitia tai eitu khan bhabi thakise, Probhu laga ekjon sorgodoth tai laga sapna te ahise, aru eneka koise, “Joseph, David laga chokra, Mary ke tumi laga maiki kori bole bhoi na koribi, kele koile juntu ekjon bacha tai laga pet te bukhikena ase etu Pobitro Atma pora ase. ");
INSERT INTO nag_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tai ekjon chokra bacha ke jonom dibo, aru tumi tai laga naam Jisu rakhibo, kelemane Tai he Tai laga manu khan ke taikhan laga paap pora bachai lobo.” ");
INSERT INTO nag_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Isor pora bhabobadi khan dwara kowa kotha khan pura hobole karone eitu khan sob tineka he hoi jaise. Eneka likha ase, ");
INSERT INTO nag_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Huni bhi, ekjon kumari maiki pora tai laga pet te bacha bukhi bo aru ekjon chokra ke jonom dibo, aru taikhan Tai laga naam Immanuel” rakhibo- etu motlob ase, “Isor amikhan logote ase.” ");
INSERT INTO nag_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Etu pichete Joseph ghumai thaka pora uthijaise aru ki kotha Isor laga sorgodoth pora hukum dise tai etu manise aru Mary ke tai laga maiki bonai loise. ");
INSERT INTO nag_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kintu tai laga maiki pora bacha jonom nohua tak, tai laga usorte janai aru tai bacha laga naam Jisu matise. ");
INSERT INTO nag_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jitia Herod raja thakise, etu somoite Judea desh laga Bethlehem town te Jisu jonom hoise. Aru gyaan thaka manu khan purab phale thaka desh pora jonom laga kotha huni kene Jerusalem te ahise, ");
INSERT INTO nag_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","aru eneka hudise, “Yehudi khan laga Raja hobole jonom huwa to kot te ase? Kilekoile amikhan Tai laga tara purab te dikhise, aru amikhan Taike aradhana kori bole ahise.” ");
INSERT INTO nag_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kintu jitia Herod raja etu hunise, tai aru tai logote Jerusalem te thaka khan sob laga mon chinta hoise. ");
INSERT INTO nag_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Etu pichete Herod raja pora mukhyo purohit aru niyom likha manu khan ke eke logote mati kene hudise, “Khrista to kun jagate jonom hobo?” ");
INSERT INTO nag_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Taikhan taike koise, “Judea laga Bethlehem te, kele koile etu he bhabobadi khan pora Isor kotha te likhise, ");
INSERT INTO nag_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kintu tumi Bethlehem, Judah desh te thaka, Apnikhan Judah desh laga cholawta khan pora komti nohoi, Kilekoile apnikhan majot pora ekjon raja ulabo, Jun Ami laga Israel manu khan ke Rokhiya kori cholai loijabo.’” ");
INSERT INTO nag_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Etu pichete, Herod pora lukaikene gyaani manu khan ke kotha korise aru tara ki homoi te ulaise etu bhal pora jani loise. ");
INSERT INTO nag_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Etu pichete tai gyaani manu khan ke Bethlehem te eneka koi kene pathaise, “Jabi aru bhal pora etu bacha ke bisari bhi. Kitia apnikhan taike pabo, amike kobi, kele koile Moi bhi ta te jai kene Taike aradhana koribo.” ");
INSERT INTO nag_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Raja laga kotha khan huna pichete, taikhan jai jaise, aru sabi, taikhan juntu tara purab te dikhise etu eke tara aru dikhise aru taikhan etu tara laga piche jaise. Etu tara taikhan age-age jai kene bacha thaka jaga uporte rukhi jaise. ");
INSERT INTO nag_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jitia taikhan tara ke dikhise, taikhan bisi khushi hoi kene rukhibo. ");
INSERT INTO nag_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Titia taikhan ghor bhitor te ghusi se chutu bacha ke Tai laga ama Mary pora dhuri thaka dikhise. Taikhan athukari kene Taike aradhana korise. Taikhan khushi pora taikhan laga khajana khan khuli kene suna, aru dhona, aru bhal gundh laga tel khan daan korise. ");
INSERT INTO nag_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kintu Isor pora taikhan laga sapna te Herod logote wapas najabi koi kene hoshiar kori dise, etu nimite dusra rasta pora taikhan nijor desh te wapas jai jaise. ");
INSERT INTO nag_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kintu taikhan jai ja-a pichete, Isor laga sorgodoth sapna te ahikena Joseph ke koise, “Uthibi, bacha aru ama ke loi kene Egypt te polai jabi aru ami nokuwa tak ta te thakibi, kele koile Herod Raja pora etu bacha ke mora bole bisari bole ase.” ");
INSERT INTO nag_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Titia utu rati te, Joseph uthikena bacha aru ama ke loi kene Egypt desh te polai jaise. ");
INSERT INTO nag_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tai Herod namora tak ta te he thakise. Juntu kotha Isor laga bhabobadi pora koi disele, etu pura hoi jaise, “Egypt pora Ami laga chokra ke mati loise.” ");
INSERT INTO nag_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jitia Herod gyaani manu khan pora taike thogaise koi kene janise, tai bisi khong uthise. Etu nimite tai laga sipahi khan ke pathaikena jiman dui saal pora niche mota bacha Bethlehem te ase, sobke morai dibole hukum dise. Kilekoile utu somoite Jisu jonom koi kene dui saal ase koi kene Herod khobor paikena thakise. ");
INSERT INTO nag_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bhabobadi Jeremiah pora ki kotha koi dise eitu khan sob pura hoi jaise, juntu eneka likha asele, ");
INSERT INTO nag_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramah town te ekta awaj hunise, Bisi mon dukh koi kene kandi thakise, Rachel tai laga bacha nimite kandi thakise, Aru kunke bhi tai laga mon shanti koribo diya nai kele koile taikhan nathaka hoi jaise.” ");
INSERT INTO nag_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aru jitia raja Herod mori jaise, sabi, Isor laga ekjon sorgodoth, Joseph to Egypt te thaka somoite tai laga sapna te ahise, ");
INSERT INTO nag_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","aru eneka koise, “Uthikena bacha aru tai laga ama ke loi kene Israel desh te jabi, kele koile jun manu bacha ke mora bole thakise taikhan morise.” ");
INSERT INTO nag_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Etu pichete Joseph uthikena, bacha aru ama ke loi jaise, aru Israel laga desh te jaise. ");
INSERT INTO nag_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kintu jitia tai hunise Herod laga chokra Archelaus he Judea laga raja ase, titia, tai ta te jabole bhoi hoi jaise. Hoilebi Isor pora tai laga sapna te hoshiar kori dise, aru etu jaga chari kene, tai Galilee jagate jaise. ");
INSERT INTO nag_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aru Nazareth laga sheher te jaise aru ta te thaki jaise. Eneka pora, juntu bhabobadi khan pora Isor laga kotha koi dise etu pura hoi jaise, juntu asele, Taike Nazareth laga manu koi kene matibo. ");
INSERT INTO nag_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Etu somoite Baptizma diya John ahise aru Isor laga kotha prochar kori kene Judea laga sunsan jagate ahise, ");
INSERT INTO nag_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","aru eneka koise, “Mon ghura bhi, kele koile sorgo laga rajyo to usorte ahi jaise.” ");
INSERT INTO nag_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kilekoile bhabobadi Isaiah pora tai laga he kotha koi diya eneka likha ase, “Ekjon kunba sunsan jaga pora hala kori ase, ‘Isor laga rasta taiyar koribi, Tai laga rasta sidha koribi.” ");
INSERT INTO nag_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Etiya, John to uth janwar laga chuli pora bona kapra lagai aru komor te chamra laga peti pora bandhe. Aru tai pango aru jongol laga mou pani he khai. ");
INSERT INTO nag_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Titia Jerusalem sheher, aru pura Judea desh, aru Jordan Nodi laga sob jaga pora manu khan taike lok kori bole ahe. ");
INSERT INTO nag_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Taikhan laga paap shikar kora pichete, John pora Jordan Nodi te taikhan ke baptizma di thakise. ");
INSERT INTO nag_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kintu tai logot bisi Pharisee aru Sadducee khan baptizma lobole ahi thaka dikhise, aru tai taikhan ke koise, “Tumikhan saph laga bacha khan, kun koise tumikhan Isor laga khong pora polabo karone? ");
INSERT INTO nag_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Etu nimite, mon ghura laga bijon apnikhan laga kaam pora dikhai dibi. ");
INSERT INTO nag_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Apnikhan laga monte ‘Amikhan laga purbojo Abraham ase’ eneka nabhabi bhi. Moi tumikhan ke koi ase Isor to etu pathor khan loi kene Abraham laga khandan bonabo pare. ");
INSERT INTO nag_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kintu sob ghas khan kati bole kuthar to age pora taiyar hoi kene ase. Juntu ghas bhal phol nadhure etu ghas ke katikena jui te phelai dibo. ");
INSERT INTO nag_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Moi to tumikhan ke pani pora he baptizma dibo. Kintu Jun ami laga pichete ahi ase, Tai to ami pora bisi hokti thaka ase, Tai laga chapal moi dhori bole layak nai. Tai tumikhan ke Pobitro Atma aru jui pora baptizma dibo. ");
INSERT INTO nag_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tai dhaan kati bole dao loi kene ahi ase, sob dhaan ke dhaan ghor te joma kori kene ghas khan ke kitia bhi khotom nohobole jui te phelai dibo.” ");
INSERT INTO nag_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Etu pichete Jisu Galilee jaga pora ulaikena baptizma lobole Jordan Nodi te John logot ahise. ");
INSERT INTO nag_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hoilebi John to Jisu ke rukhabole bisi kosis korise, aru eneka koise, “Ami he Apuni laga hath pora baptizma lobo lage, hoilebi Apuni he moi logote ahise?” ");
INSERT INTO nag_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kintu Jisu taike eneka koise, “Etiya karone to eneka koridi bhi, kele koile Amikhan bhi dharmikta kaam sob pura korile he thik ase.” Etu pichete John pora kotha mani loise. ");
INSERT INTO nag_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jitia Jisu baptizma loi kene pani pora ulaise, sorgo pora ekta pohor ahise aru Isor laga Atma kopu chiriya nisena hoi kene Tai uporte rukhi jaise. ");
INSERT INTO nag_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Etu pichete, sabi, ekta awaj sorgo pora koise, “Etu Ami laga bisi morom thaka Putro ase. Ami Tai uporte bisi khushi ase.” ");
INSERT INTO nag_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Etu pichete Jisu ke Atma pora ekta sunsan jagate loi jaise juntu jagate saitan pora taike porikha koribo. ");
INSERT INTO nag_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aru chalis din aru chalis rati Jisu upwas korise, etu karone Tai bhuk lagi jaise. ");
INSERT INTO nag_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Titia porikha kora jon ahikena Taike eneka koise, “Apuni Isor laga Putro ase koile, etu pathor khan ke roti hobole kobi.” ");
INSERT INTO nag_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kintu Jisu taike jowab dikena koise, “Isor kotha te eneka likhi kene ase, ‘Manu to khali bhaat khaikena jinda nathake, kintu Isor laga mukh pora ula kotha te he jinda thakibo.’” ");
INSERT INTO nag_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Etu pichete saitan pora Jisu ke pobitro sheher te loi jaise aru mondoli laga sob pora uporte khara koribo dise, ");
INSERT INTO nag_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","aru Taike koise, “Apuni Isor laga Putro ase koile, yate pora nijorke nichete phelai dibi, kele koile Isor laga kotha te eneka likha ase, ‘Tai pora Tai laga duth khan ke hukum dikene Apuni ke bachai lobo,’ Aru, ‘Taikhan laga hath pora Apuni ke dhuri lobo, Aru Apuni laga theng ke pathor pora bhi jokhom nahobo.’” ");
INSERT INTO nag_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisu taike eneka koise, “Aru Isor kotha te etu bhi likhi kene ase, ‘Apuni laga Probhu Isor ke porikha na koribi.’” ");
INSERT INTO nag_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aru, saitan pora Jisu ke untcha pahar te loi jaise aru Taike prithibi laga rajyokhan laga dangor mohima thaka dikhai dise. ");
INSERT INTO nag_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Saitan pora Taike koise, “Apuni moike athukari kene aradhana korile, eitu khan sob ami Apnike di dibo.” ");
INSERT INTO nag_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Titia Jisu pora taike koise, “Yate pora jai jabi, Saitan! Kilekoile Shastro te eneka likhi kene ase, ‘Tumikhan khali Probhu, tumi laga Isor ke he aradhana koribi, aru khali Taike he sewa koribi.’” ");
INSERT INTO nag_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Titia saitan Taike chari kene jai jaise, aru sabi, sorgodoth khan ahi kene Taike modot korise. ");
INSERT INTO nag_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jitia John ke dhurise koi kene Jisu khobor paise, Tai Galilee jagate wapas jai jaise. ");
INSERT INTO nag_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tai Nazareth sheher chari kene Galilee Samundar laga usorte thaka, Capernaum town te jaise, etu jaga to Zebulun aru Naphtali laga majot te ase. ");
INSERT INTO nag_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Isaiah bhabobadi dwara Isor kotha pora kowa pura hobole karone eitu khan sob eneka hoise, ");
INSERT INTO nag_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun laga mati aru Naphtali laga mati, Sagar phale, Jordan paar kori kene, Porjati khan laga Galilee! ");
INSERT INTO nag_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Utu manu khan jun andhera te bohi thake taikhan dangor ekta ujala dikhise, Aru jun khan mora laga chaya aru jagate bohi thake, Taikhan uporte ekta pohor dikhai dise.” ");
INSERT INTO nag_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Utu somoi pora he Jisu prochar kori bole shuru hoise aru koise, “Mon ghura bhi, kele koile sorgo laga rajyo to usor hoise.” ");
INSERT INTO nag_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jitia Tai Galilee Nodi phale berai thakisele, Tai Simon junke Peter koi, aru tai laga bhai Andrew khan ke maas dhora jaal loi kene samundar te phelai thaka dikhise, kele koile taikhan maas dhora manu thakise. ");
INSERT INTO nag_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisu taikhan ke koise, “Ahibi, Ami laga piche koribi, aru Moi tumikhan ke manu dhori bole bonai dibo.” ");
INSERT INTO nag_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Loge-loge taikhan laga maas dhura jaal khan phelai dise aru Jisu laga piche kori bole shuru hoise. ");
INSERT INTO nag_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jitia Jisu ta te pora jai thakise, tai duijon bhai ke dikhise, James, Zebedee laga chokra, aru tai laga bhai John Tai ekta naw te taikhan laga baba Zebedee logote maas dhura jaal khan milai thakise. Jisu taikhan ke matise, ");
INSERT INTO nag_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aru etu loge-loge taikhan laga naw aru baba ke chari kene Jisu laga piche korise. ");
INSERT INTO nag_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Titia Jisu Galilee laga sob jagate berai jaise, synagogue khan te sikhaise, aru rajyo laga susamachar prochar korise, aru sob kisim laga ghao bemar aru bemar manu khan ke changai korise. ");
INSERT INTO nag_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tai laga khobor sob Syria jagate punchi jaise, aru manu khan Jisu usorte kisim-kisim bemar pora dukh pai thaka khan, gaw bhitor te bhoot huma khan, murgi-bemar thaka khan, aru jothor bemar thaka khan sobke loi kene anise. Aru taikhan ke Jisu pora changai kori dise. ");
INSERT INTO nag_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aru Galilee, Decapolis, Jerusalem, Judea, aru Jordan pora bhi dur thaka sob jaga pora manu khan Jisu logot ahise. ");
INSERT INTO nag_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bhir bisi dangor hoija pora, Jisu to ekta tilla uporte uthijaise. Tai ta te boha pichete, tai laga chela khan bhi Tai usorte ahise. ");
INSERT INTO nag_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aru Jisu pora Tai laga chela khan ke eneka koi kene sikhaise, ");
INSERT INTO nag_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Atma te dukhia thaka khan dhonyo ase, Kilekoile sorgo laga rajyo taikhan nimite ase. ");
INSERT INTO nag_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dukh koi kene thaka khan, taikhan dhonyo ase, Kilekoile taikhan laga mon aram kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nomro hoi kene thaka khan dhonyo ase, Taikhan prithibi laga adhikari hobo. ");
INSERT INTO nag_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dharmikta nimite bhuk aru pyaas thaka khan dhonyo ase, Taikhan ke bhorta kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Dayalu thaka manu khan dhonyo ase, Taikhan daya pabo. ");
INSERT INTO nag_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mon sapha thaka khan dhonyo ase, Taikhan Isor ke dikhibo. ");
INSERT INTO nag_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Shanti nimite kaam kora khan dhonyo ase, Taikhan ke Isor laga bacha khan koi kene matibo. ");
INSERT INTO nag_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dharmikta nimite dukh pai thaka khan dhonyo, Sorgo laga desh to taikhan nimite ase. ");
INSERT INTO nag_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tumikhan dhonyo ase jitia Ami laga naam nimite manu khan pora tumikhan ke gali dibo, dukh digdar dibo aru misa misi bodnam dibo. ");
INSERT INTO nag_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Monte bisi khushi hobi kele koile sorgote tumikhan nimite bisi dangor inam rakhi kene ase. Jun bhabobadi khan tumi laga age te ahisele, taikhan ke bhi eneka dukh digdar dise. ");
INSERT INTO nag_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tumikhan etu prithibi laga nimok nisena ase. Kintu nimok laga swadh haraise koile, kineka tai laga swadh to arubi anibo? Etu to eku kaam laga nohoi jai, kintu etu ke phelai dibo aru manu khan pora chipai dibo. ");
INSERT INTO nag_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tumikhan etu prithibi laga puhor ase. Ekta sheher ke pahar uporte bonaile lukabo napare. ");
INSERT INTO nag_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nohoile bhi manu khan tai laga saaki julai kene kiba ekta dabba pora bondh kori kene narakhe, kintu etu saaki ke khamba te rakhikena pura ghor ke ujala kori bole diye. ");
INSERT INTO nag_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tumi laga pohor ke eneka ujala kori dibi manu khan age te, titia taikhan tumi laga bhal kaam khan sob dikhi jabo aru tumi laga Baba Isor jun sorgote ase, Taike mohima dibo. ");
INSERT INTO nag_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Moi Isor laga niyom aru bhabobadi khan ke khotom kori dibo nimite ahise eneka nabhabi bi. Moi khotom kori dibole aha nohoi, kintu eitu khan sob pura kori dibo nimite ahise. ");
INSERT INTO nag_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kilekoile moi hosa pora tumikhan ke koi ase jitia tak prithibi aru akas khan khotom nohoi, ekta dagi nohoile ekta chutu kotha bhi naharabo, jitia tak etu kotha khan sob pura nohoi. ");
INSERT INTO nag_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Etu nimite, kun pora etu niyom aru hukum khan bhangabo aru dusra khan ke bhi eneka kori bole sikhabo, taikhan laga naam bhi sorgo laga rajyo pora hatai dibo. Kintu kun pora etu hukum aru niyom sob rakhe, taike sorgo laga rajyote mohan matibo. ");
INSERT INTO nag_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Etu nimite Moi tumikhan ke koi ase, tumikhan laga dharmikta to niyom likha khan aru pharisee khan pora bhi bhal hobo lage, eneka nohoile tumikhan sorgo laga rajyote ahibo na paribo. ");
INSERT INTO nag_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tumikhan hunise utu purana somoite eneka koi dise, ‘Morai diya kaam na koribi,’ aru, ‘Jun pora manu ke morai taikhan Isor laga bisar te ahibo.’ ");
INSERT INTO nag_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kintu Moi tumikhan ke koi ase, sob manu jun khan tai nijor bhai ke gusa kore, tai logot Isor laga bisar ahibo, aru nijor bhai ke eneka kowa khan to sabha age te bisi digdar hobo, ‘Tumi kaam nathaka manu!’ Aru tai norok laga jui te juli bo jodi ekjon pora tai bhai ke eneka koi, ‘Tumi murkho manu!’ ");
INSERT INTO nag_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Etu karone, jitia tumi Isor laga age te daan dibole ane, aru bhai ke kiba biya korise koi kene monte ahise koile, ");
INSERT INTO nag_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tumi laga dhun khan bedi usorte chari dibi. Aru poila jai kene tumi laga bhai logote mon milai lobi, etu pichete ahikena Isor ke daan dibi. ");
INSERT INTO nag_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kunba tumike bisar ghor te loijabo koi ase koile, naja-a age te tai logote kotha milai lobi, kele koile ekbar bisar ghor te jaise koile tai pora tumike ukil laga hathte di dibo, aru ukil pora tumike sipahi khan logote di dibo aru sipahi khan pora tumike bondhi ghor te rakhidibo. ");
INSERT INTO nag_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Hosa pora Ami tumikhan ke koidi ase, tumi bondhi ghor pora bahar naulabo jitia tak tumi laga dhar sob tirai nadibo. ");
INSERT INTO nag_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tumikhan eneka kowa hunise, ‘Bebichari na koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kintu Moi tumikhan ke koidi ase, jun manu ekjon mahila ke biya kaam kori bole bhabi loi, tai mon bhitor te bebichar kori loise. ");
INSERT INTO nag_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jitia ekta suku pora tumike biya kaam koribo di ase, utu suku ke ulaikene dhur te phelai dibi. Kilekoile gaw te ekta biya saman nimite pura gaw norokte ja pora to, ekta suku nathaki kene jinda thaka he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tumi laga ekta hath pora paap kaam kori ase koile, etu ke kati kene phelai dibi. Kilekoile pura gaw norokte ja pora, ekta hath nathaki kene jinda thakile he bhal ase. ");
INSERT INTO nag_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Eneka bhi koi kene ase, ‘Jun mota tai laga maiki ke chari bole mon ase, tai pora chari diya laga chithi likhi kene tai laga maiki ke dibole lage.’ ");
INSERT INTO nag_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kintu Moi tumikhan ke etu koidi ase, jun mota dusra maiki logote bebichar kori bole tai laga maiki ke chari diye, taike bebichari maiki bonai di ase. Aru jun manu pora etu chari diye maiki ke shadi koribo, tai bhi bebichar kori loise. ");
INSERT INTO nag_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Aru, tumikhan poila jamana te huni kene thakibo, ‘Misa kotha nimite kosom nakhabi, kintu ji kosom Probhu logote korise etu purah koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kintu Moi tumikhan ke koi ase, tumi laga kosom nimite, sorgote thaka laga naam nalobi, kele koile etu Isor laga singhason ase; ");
INSERT INTO nag_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","prithibi laga naam nalobi, kele koile etu Isor laga theng rakha jaga ase; Jerusalem laga naam nalobi, kele koile etu mohan Raja laga desh ase. ");
INSERT INTO nag_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aru nijor laga naam loi kene kosom nakhabi, kele koile tumi nijor laga chuli ke boga nohoile kala kori bole hokti nai. ");
INSERT INTO nag_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kintu tumi laga kotha ‘Hoi to, hoi' kobi, aru ‘Nohoi to Nohoi’ kobi. Kintu etu pora aru bisi kotha kora khan to sob biya khan pora ase. ");
INSERT INTO nag_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tumikhan hunise eneka koi kene ase, ‘Suku laga bodli suku, aru daat laga bodli daat.’ ");
INSERT INTO nag_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kintu Moi koi ase, tumike kunba golti kora manu ke badla lobole na koribi. Hoilebi, jun manu tumike mukh laga ekta phale thapor mare, tumi laga dusra phale bhi mari bole dibi. ");
INSERT INTO nag_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kunba manu bisar ghor te jabole itcha hoi aru tumi laga kapra pindhi loi, taike apuni laga chador bhi di dibi. ");
INSERT INTO nag_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kunba manu khan pora tumike ek kilometer jabole koile, tumi tai logote dui kilometer jabi. ");
INSERT INTO nag_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jun manu tumike kiba mangile taike di dibi, aru jun manu tumike kiba dhar lobole mange, taike mana na koribi. ");
INSERT INTO nag_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tumikhan hunise eneka koi kene, ‘Tumi laga ghor usorte thaka manu ke morom koribi aru tumi laga dushman ke ghin koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kintu Moi tumikhan ke koi ase, tumi laga dushman ke morom koribi, aru jun khan tumike dukh-digdar di ase, taikhan nimite prathana koribi, ");
INSERT INTO nag_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","eneka korile tumikhan sorgote thaka Baba laga bacha khan hobo. Kilekoile Tai laga suryo to biya manu aru bhal manu ke bhi diye, aru borkhon pani to biya manu aru bhal khan ke bhi diye. ");
INSERT INTO nag_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jitia tumikhan khali morom kora khan ke morom kore, etu to ki labh pabo? Kilekoile poisa utha manu khan bhi eneka kore nohoi? ");
INSERT INTO nag_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tumikhan khali tumi laga bhai khan he mane koile, etu kori kene tumi ki dangor kaam korise? Isor ke najana khan bhi dusra khan ke eneka kore nohoi? ");
INSERT INTO nag_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Etu nimite, tumikhan ekdom thik hobo lage, jineka tumikhan laga sorgo Baba Isor thik ase. ");
INSERT INTO nag_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Etiya bhal pora bujhi lobi, tumikhan manu ke dikha bole nimite bhal kaam na koribi, nohoile sorgote thaka Baba Isor pora tumikhan ke eku inam nadibo. ");
INSERT INTO nag_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jitia tumikhan kunba ke modot di ase koile, sob manu ke hunai kene hala na koribi, kele koile Pharisee khan bhi manu khan ke dikha bole nimite mondoli khan te aru rasta khan te hala kore. Hosa pora Moi koidi ase, taikhan laga inam taikhan paikena ase. ");
INSERT INTO nag_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kintu tumikhan jitia daan diye, tumi laga dyna hath ki kori ase tumi laga baya hath ke janibole nadibi, ");
INSERT INTO nag_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","titia tumi daan diya to kun bhi najanibo. Kintu tumi laga Baba jun sob sai ase tumike lukai kene inam dibo. ");
INSERT INTO nag_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jitia tumikhan prathana kore, kopoti khan kora nisena nahobi, kele koile taikhan mondoli khan te aru rasta kinar khan te dikha bole karone prathana kore. Hosa pora Moi koidi ase, taikhan laga inam to taikhan pabo. ");
INSERT INTO nag_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kintu, jitia tumikhan prathana kore, ghor bhitor dorja bondh koribi aru lukai kene tumi laga Baba ke prathana koribi. Titia tumi laga Baba jun tumike sai ase, Tai tumike inam dibo. ");
INSERT INTO nag_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jitia tumikhan prathana kore, Porjati khan nisena bisi kotha nakobi, kele koile taikhan bhabe eneka koile taikhan laga kotha huni lobo. ");
INSERT INTO nag_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Taikhan nisena na koribi, kele koile tumi laga Baba tumi ki mangi bole ase etu age pora jani ase. ");
INSERT INTO nag_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Etu nimite, eneka prathana koribi: ‘Amikhan laga Baba jun sorgote ase, Apuni laga naam pobitro hoi kene untcha hobi. ");
INSERT INTO nag_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apuni laga sorgo ahibole dibi. Apuni laga itcha hobole dibi, etu prithibi te jineka sorgote ase. ");
INSERT INTO nag_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amikhan ke hodai din laga kha luwa dibi. ");
INSERT INTO nag_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Amikhan laga dhar khan maph kori dibi, Jineka ami pora amikhan laga dhar thaka khan ke maph kori dise. ");
INSERT INTO nag_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amikhan ke porikha te giri bo nadibi, kintu biya jon pora amikhan ke bachai lobi.’ ");
INSERT INTO nag_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kilekoile jitia tumikhan pora dusra manu khan laga golti khan maph kore, tumi laga sorgote thaka Baba bhi tumikhan ke maph kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kintu jitia tumikhan dusra manu khan ke maph nakore, tumi laga sorgote thaka Baba bhi tumikhan laga golti maph nakoribo. ");
INSERT INTO nag_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jitia tumikhan upwas rakhe, kopoti khan kora nisena mon dukh laga chehera nadikhabi, kele koile taikhan to manu khan ke dikhabo nimite taikhan laga chehera biya kori kene dikhai, aru taikhan nijor laga inam pai loise. ");
INSERT INTO nag_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kintu, jitia tumi upwas rakhe, tumi nijor laga matha te tel hali lobi aru chehera ke dholai lobi, ");
INSERT INTO nag_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","titia manu khan tumike saikene najanibo tumi upwas kori ase, kintu khali tumi laga Baba he janibo; aru tumi laga Baba jun sob sai ase, Tai he tumike inam dibo. ");
INSERT INTO nag_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nijor nimite eku dhun joma na koribi, juntu jagate tumi laga sob dhun puka aru kira pora khotom kori dibo, aru jun jagate chor khan bhangai kene chor kori lobo. ");
INSERT INTO nag_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hoilebi, nijor laga sob dhun sorgote joma koribi, juntu jagate napuchibo aru pukakhan pora khotom nakoribo, aru chor khan bhanga bole na paribo. ");
INSERT INTO nag_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kilekoile jun jagate tumi laga dhun ase, ta te tumi laga mon bhi thakibo. ");
INSERT INTO nag_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Suku to tumi laga gaw te saaki nisena ase. Etu nimite, jitia tumi laga suku to thik thakibo, tumi laga gaw purah te puhor thakibo. ");
INSERT INTO nag_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kintu jitia tumi laga suku te letera thakibo, tumi laga pura gaw bhi letera thakibo. Etu nimite, juntu pohor tumi bhitor te ase, etu to andhera ase koile, utu andhar to kiman bhi dangor ase! ");
INSERT INTO nag_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kun manu bhi duita malik ke sewa koribo na paribo, kele koile tai ekjon malik ke morom koribo aru ke ghin koribo, nohoile ekjon ke mon dibo aru dusra ke mon nadibo. Tumi Isor aru dhun ke sewa koribo na paribo. ");
INSERT INTO nag_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Etu karone, Moi koi ase, nijor laga jibon nimite chinta na koribi, ki khabo nohoile- nohoile tumi laga gaw nimite, nohoile ki kapra pindhibo. Kha luwa pora bhi jibon to dangor nohoi naki, aru kapra pora bhi tumi laga gaw he dangor nohoi naki? ");
INSERT INTO nag_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Akas uporte chiriya khan ke sabi. Taikhan kheti bhi nakore, aru kheti bhi nakate, nohoile taikhan laga ghor te joma nakore, kintu tumi laga sorgote thaka Baba pora taikhan ke sob khilai. Tumikhan etu chiriya khan pora bhi bisi dangor ase nohoi? ");
INSERT INTO nag_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kintu tumikhan jun bisi chinta kore, etu pora tumikhan laga jibon ke lamba koribo pare naki? ");
INSERT INTO nag_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tumikhan kele kapra nimite iman chinta kori ase? Kheti te phul thaka khan laga bhabi sabi, taikhan kineka phule. Taikhan eku kaam nakore, aru kapra bhi nabonai. ");
INSERT INTO nag_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Titia bhi Ami koi ase, Solomon ekjon dangor raja hoi kene bhi, taike eitu khan nisena kapra lagai diya nai. ");
INSERT INTO nag_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kintu jodi Isor pora kapra pindhai dibole pare, etu kheti te thaka phul khan jun aji ase aru kali kati kene chulah te julai diye, titia hoile Tai tumikhan ke bhi bisi kapra pindhai dibo na paribo naki, tumi komti biswas thaka manu khan? ");
INSERT INTO nag_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Etu nimite, bisi chinta kori kene eneka nakobi, ‘Amikhan ki khabo?’ Nohoile, ‘Amikhan ki pindhibo?’ ");
INSERT INTO nag_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kilekoile Isor najana khan pora eitu khan he bisare, aru sorgote thaka Baba Isor pora tumikhan ki lage, Tai sob jani ase. ");
INSERT INTO nag_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kintu poila Tai laga sorgo rajyo aru dharmikta bisaribi aru eitu khan sob saman tumikhan ke Tai pora dibo. ");
INSERT INTO nag_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Etu karone, kali nimite chinta na koribi, kele koile kali to tai nijor he chinta koribo. Hodai dinte tai nijor laga biya din thake. ");
INSERT INTO nag_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Dusra ke bisar na koribi, tinehoile tumike bhi bisar nakoribo. ");
INSERT INTO nag_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ki kotha pora tumi bisar kore, tumike bhi etu pora bisar koribo, aru ki loi kene tumi hisab-kitab kore, tineka he tumike bhi hisab-kitab hobo. ");
INSERT INTO nag_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kintu kele tumi laga bhai laga suku te sukha pata chutu thaka to sai ase, hoilebi tumi nijor laga suku te dangor khuri thaka to nadikhe? ");
INSERT INTO nag_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nohoile kineka tumi laga bhai ke koi, ‘Amike tumi laga suku te sukha pata chutu thaka to sapha koribo dibi,’ jitia apuni nijor laga suku te ekta dangor khuri thaki kene? ");
INSERT INTO nag_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tumi kopoti khan! Poila nijor laga suku te dangor khuri thaka to sapha kori lobi, aru etu pichete tumikhan bhal pora dikhi kene bhai laga suku te sukha pata chutu thaka to sapha kori bole paribo. ");
INSERT INTO nag_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Juntu pobitro ase eitu khan kutta khan ke nadibi, aru tumi laga heera moti loi kene jongol gahori khan ke nadibi. Kilekoile taikhan laga theng pora chipai dibo, aru ghurikena tumikhan laga gaw ke kamuri kene tukra kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mangi bhi, aru tumikhan ke dibo. Bisaribi, aru tumikhan pai jabo. Dorjate maribi, aru tumikhan nimite khuli dibo. ");
INSERT INTO nag_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kilekoile jun mange, taikhan pai; aru jun bisare, taikhan pai; aru jun dorjate mare, taikhan nimite khuli diye. ");
INSERT INTO nag_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nohoile bhi kunba manu ase naki tumikhan majote, jun laga bacha pora khabole roti mangile, tai laga baba pora pathor diye naki? ");
INSERT INTO nag_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nohoile bacha pora maas khabole mangile, tai laga baba pora saph dibo naki? ");
INSERT INTO nag_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Etu nimite, tumikhan kiman biya hoilebi nijor bacha ke bhal saman khan diye, tinehoile tumi laga Baba kun sorgote ase, Tai aru bisi bhal saman tumikhan manga to nadibo naki? ");
INSERT INTO nag_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Etu nimite, sob te, dusra manu khan pora tumi ki lage, thik eneka tumi bhi dusra khan ke koribi, kele koile etu to niyom pora aru bhabobadi khan pora koi diya ase. ");
INSERT INTO nag_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ekdom huru rasta pora ghusi bhi. Kelemane juntu dorja bisi dangor hoi, etu to khotom kori diya rasta te loijai, aru bisi manu etu rasta te jabole kore. ");
INSERT INTO nag_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kilekoile jibon laga rasta to bisi huru ase aru dorja ekdom chutu ase. Etu nimite khali kunba khan he etu rasta pai. ");
INSERT INTO nag_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Misa bhabobadi khan pora hoshiar thakibi, jun khan mer nisena kapra pindhi kene dikhai, kintu bhitor te taikhan ekdom bhuk lagi thaka rong kutta janwar khan ase. ");
INSERT INTO nag_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Taikhan laga kaam laga phol pora tumikhan jani jabo. Dusra manu kata ghas pora angur ke joma nakore, aru nohoile kata ghas pora dimoru khan ulai naki? ");
INSERT INTO nag_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Etu nisena, sob bhal ghas khan bhal phol dhure, kintu biya ghas khan biya phol dhure. ");
INSERT INTO nag_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ekta bhal ghas pora biya phol dhoribo napare, nohoi lebi ekta biya ghas pora bhal phol dhoribo napare. ");
INSERT INTO nag_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Juntu ghas bhal phol nadhure etu ghas ke katikena jui te phelai dibo lage. ");
INSERT INTO nag_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Etu pichete, tumikhan tai laga phol pora jani jabo. ");
INSERT INTO nag_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sob manu jun Moike ‘Probhu, Probhu’ koi kene mate, taikhan sorgo desh te huma bole nohoi, kintu jun manu sorgote thaka Baba Isor laga itcha kore, taikhan he huma bole paribo. ");
INSERT INTO nag_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bisi manu khan utu dinte kobo, ‘Probhu, Probhu, amikhan Apuni laga naam te bhabobani kora nai naki, aru Apuni laga naam te biya atma khan ke khedai diya nai naki, aru Apuni laga naam te asurit kaam khan kora nai naki? ");
INSERT INTO nag_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Titia Ami Khuli Kena taikhan ke koi dibo, ‘Moi tumikhan ke kitia bhi jana nai! Moi laga usor pora jai jabi, tumikhan biya laga niyom kora khan!’ ");
INSERT INTO nag_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Etu nimite, sob manu jun Ami laga kotha khan hune aru eitu khan sob mane, taikhan ekjon gyaani manu nisena ase jun pathor uporte ghor bonaise. ");
INSERT INTO nag_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bisi dangor hawa aru pani ahikena, aru purah pani pora bhorta kori loise, hoilebi etu ghor ke gira bole para nai, kele koile etu ghor to pathor uporte bonaise. ");
INSERT INTO nag_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kintu kun manu Ami laga kotha hune aru namane taikhan murkho manu ase jun balu laga uporte ghor bonai. ");
INSERT INTO nag_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dangor borkhon ahise, aru ban pani pora bhorta hoi jaise, aru hawa pora etu ghor ke hilai kene girai dise, aru pura ghor ke khotom kori diye.” ");
INSERT INTO nag_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Etu pichete jitia Jisu etu kotha khan koi kene khotom korise, Tai pora sikhai diya kotha huni kene sob manu asurit hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kilekoile Tai sikhai diya to niyom likha khan pora sikha nisena nohoi, kintu ekjon adhikar thaka manu nisena koi thakise. ");
INSERT INTO nag_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jitia Jisu pahar pora namikene ahise se, dangor manu laga bhir pora Tai laga piche korise. ");
INSERT INTO nag_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aru sabi, ekjon korhi bemar thaka manu Jisu laga usorte ahise aru Tai age te matha jhukikena eneka koise, “Probhu, Apuni itcha ase koile, Apuni moike sapha kori bole paribo.” ");
INSERT INTO nag_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisu tai usorte jai kene taike chuikena koise, “Moi laga itcha ase. Sapha hobi.” Aru etu loge-loge tai laga bemar sapha hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Etu pichete Jisu taike koise, “Sabi, etu kunke bhi nakobi. Kintu jabi aru tumi laga purohit khan ke dikhai dibi aru Moses pora hukum diya kori lobi, titia etu dusra khan nimite tumi laga gawahi hobo.” ");
INSERT INTO nag_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jitia Jisu Capernaum jagate ahi loise, ekjon Rome laga henapoti Tai usorte ahise aru koise, ");
INSERT INTO nag_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Probhu, ami laga kaam kora nokor jothor bemar koi kene ghumai ase aru tai bisi dukh te ase.” ");
INSERT INTO nag_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisu taike koise, “Moi ahibo aru taike bhal kori dibo.” ");
INSERT INTO nag_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kintu henapoti pora taike eneka jowab dise, “Probhu, Apnike ami laga ghor te mati bole sorom ase, kintu khali Apuni laga kotha koi dibi aru ami laga nokor to bhal hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kilekoile ami bhi ekjon adhikari thaka manu ase, aru ami nichete sipahi khan ase. Ami taikhan ke eneka hukum diye, ‘Jabi’, aru tai jai, aru dusra ekjon ke, ‘Ahibi,’ aru tai ahe, aru nokor ke, ‘Eneka koribi,’ aru tai kore.” ");
INSERT INTO nag_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kintu jitia Jisu etu hunise, Tai asurit hoi jaise aru Tai laga piche aha manu khan ke koi, “Hosa pora Moi tumikhan ke koi ase, Moi kitia bhi etu nisena iman dangor biswas thaka manu purah Israel desh te dikha nai. ");
INSERT INTO nag_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kintu Moi tumikhan ke koi ase, purab aru paschim desh khan pora bisi manu ahibo, aru taikhan aram kori kene Abraham, Isaac, aru Jacob, usorte sorgo laga rajyote bohibo. ");
INSERT INTO nag_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kintu rajyo laga bacha khan ke andhera jagate phelai dibo, juntu jagate khali daat kamurikena kanda he thakibo.” ");
INSERT INTO nag_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Titia Jisu etu henapoti ke koise,“Jabi! Jineka tumi biswas korise, etu nisena he hobo dibi.” Aru thik utu homoi te tai laga nokor bhal hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jitia Jisu pora Peter laga ghor te ahise, Peter laga maiki laga ama bukhar pora bemar hoi kene ghumai thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisu pora tai laga hath choise aru titia bemar taike chari kene jaise. Etu pichete tai uthikena Jisu ke kha luwa sewa kori bole shuru hoijai. ");
INSERT INTO nag_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jitia saam hoi thakise, manu khan Jisu usorte biya atma humai kene thaka manu khan ke loi kene anise. Tai laga kotha pora sob biya atma khan ke khedai dise aru sob bemar thaka manu khan ke changai kori dise. ");
INSERT INTO nag_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Etu nisena juntu kotha khan bhabobadi Isaiah koi dise, eitu khan sob purah hoi jaise, “Tai nijor he amikhan laga sob bemar khan loi loise aru amikhan laga sob ghao khan nijor bukhi loise.” ");
INSERT INTO nag_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jitia Jisu pora Tai usorte dangor bhir joma hoi kene dikhise, Tai dusra khan ke Galilee laga Samundar laga dusra phale jai jabi koi kene hukum dise. ");
INSERT INTO nag_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Etu pichete niyom likha manu Tai logote ahise aru koise, “Shika manu, Apuni kot jai ami bhi Apuni pichete jabo.” ");
INSERT INTO nag_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisu taike koise, “Shial khan chenda bhitor te thake, chiriya khan pata pora bona ghor te thake, kintu Manu laga Putro nimite thaki bole jaga nai.” ");
INSERT INTO nag_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jisu laga ekjon chela pora taike koise, “Probhu, moike poila ekbar ghor te jai kene ami laga baba ke kobor dikena ahibole dibi.” ");
INSERT INTO nag_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kintu Jisu taike koise, “Moi laga piche koribi, aru mora manu khan ke taikhan nijorke kobor dibole dibi.” ");
INSERT INTO nag_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jitia Jisu naw bhitor te bohi loise, tai laga chela khan sob Tai piche korise. ");
INSERT INTO nag_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aru sabi, ekta dangor andhi nodi pora uthibole shuru hoise, aru purah naw to hawa aru pani pora hiliai thakise. Kintu Jisu to ghumai thakise. ");
INSERT INTO nag_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Titia chela khan Tai usorte ahise aru eneka koi kene uthai dise, “Probhu, amikhan ke bacha bhi; amikhan mori bole ase!” ");
INSERT INTO nag_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisu taikhan ke koise, “Tumikhan biswas komti thaka khan kele bhoi khai ase? Etu pichete Tai uthikena nodi aru hawa pani ke hukum dise. Titia sob chup-chap hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kintu sob manu asurit koi kene koise, “Etu ki kisim laga manu ase, hawa aru pani tak Tai laga kotha mane?” ");
INSERT INTO nag_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jitia Jisu samundar paar kori kene Gadarene laga desh te punchise, duijon manu jun logote biya atma ghusikena thakise, Jisu ke lok korise. Taikhan koboristan pora ulaikena ahise aru bisi khechera huwa pora manu khan etu rasta pora nabira hoise. ");
INSERT INTO nag_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sabi, taikhan hala kori kene koise, “Amikhan Apuni ke ki kori dibo, Isor laga Putro? Apuni homoi napuncha age te aha laga motlob to amikhan ke bisi dukh dibole ase naki?” ");
INSERT INTO nag_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Utu somoite dur nohoi kene kunba gahori dana khai thakisele. ");
INSERT INTO nag_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aru biya atma khan Jisu ke anurodh kori kene koise, “Apuni amikhan ke khedai dibole ase koile, amikhan ke gahori khan laga gaw te ghusi bo dibi.” ");
INSERT INTO nag_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Titia Jisu taikhan ke koise, “Jabi!” Etu hukum diya pichete sob biya atma khan ulaise aru gahori laga gaw bhitor te ghusi jaise; aru sabi, etu sob gahori pahar upor pora polaikena nodi te girikena panite dubi mori jaise. ");
INSERT INTO nag_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kintu juntu gahori saithaka manu khan sheher te polaikena sob manu khan ke khobor dise. ");
INSERT INTO nag_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sabi, pura sheher laga manu khan Jisu ke lok kori bole ulai ahise. Jitia taikhan Jisu ke dikhise, taikhan Jisu ke anurodh korise aru etu jaga pora jai jabole koise. ");
INSERT INTO nag_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Titia Jisu naw te uthi loise aru nodi paar korise, aru tai nijor laga town, Capernaum te ahi jaise. ");
INSERT INTO nag_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sabi, manu khan ekjon jothor bemar thaka manu ke chatai te ghumai thaka ke loi anise. Jitia Jisu taikhan laga biswas dikhise, tai jothor bemar manu ke koise, “Putro, mon dangor koribi. Tumi laga paap sob maph kori dise.” ");
INSERT INTO nag_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Titia sabi, niyom likha manu khan taikhan majote koise, “Etu manu Isor laga biya kotha koi ase.” ");
INSERT INTO nag_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kintu Jisu taikhan laga bhabona janikena koise, “Tumikhan ki hisab te mon bhitor te biya kotha bhabona kori ase? ");
INSERT INTO nag_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kilekoile, kuntu he asan ase, ‘Tumikhan laga paapkhan sob maph kori dise,’ na, ‘Uthibi aru berabi’ etu thik ase? ");
INSERT INTO nag_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kintu tumikhan ke jonai dibole, Manu laga Putro ke etu prithibi te adhikar dikena ase manu laga paapkhan maph kori bole, ...” Etu pichete Tai etu manu ke koise, “Uthibi, tumi laga chatai lobi, aru nijor laga ghor te jabi.” ");
INSERT INTO nag_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Titia etu manu uthise aru nijor ghor te jai jaise. ");
INSERT INTO nag_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jitia manu khan etu dikhise, taikhan asurit hoise aru Isor ke mohima dise, jun he manu khan ke eneka adhikar dise koi kene. ");
INSERT INTO nag_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jitia Jisu etu jaga paar hoi kene jai thakise, tai Matthew koi kene ekjon manu ke dikhise, jun poisa utha laga jagate kaam kori thakise. Tai pora taike koise, “Ami laga piche koribi.” Aru tai uthise aru Jisu laga piche korise. ");
INSERT INTO nag_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aru eneka hoise, jitia Jisu Matthew laga ghor te bohi kene bhat khabole hoise, sabi, bisi poisa utha manu khan aru dusra paapi manu khan bhi ahise aru Jisu aru tai laga chela khan sob eke logote khaise. ");
INSERT INTO nag_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jitia kunba Pharisee khan etu dikhise, taikhan Jisu laga chela khan ke hudise, “Kile apnikhan laga malik to poisa utha aru dusra paapi manu khan logote milikena khai ase?” ");
INSERT INTO nag_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jitia Jisu etu hunise, Tai koise, “Jun laga gaw sob thik ase, taike bemar bhal kora manu nalage, khali jun khan bemar ase taikhan ke lage. ");
INSERT INTO nag_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kintu tumikhan jabi aru sikhibi Isor laga kotha te etu laga motlob ki ase: ‘Ami to tumikhan boli diya to nalage, hoilebi daya kora to Moi laga itcha ase.’ Kilekoile Ami dhormik khan ke mati bole aha nohoi, kintu paapi manu khan karone ahise.’” ");
INSERT INTO nag_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aru ek din, John laga chela khan Tai logote ahikena koise, “Kile Pharisee aru amikhan upwas kore, kintu Apuni laga chela khan to nakore?” ");
INSERT INTO nag_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisu taikhan ke jawan dise, “Shadi te aha khan mon dukh hoi kene shadi kora jon logote thake naki? Kintu utu din ahibo jitia shadi kora jonke taikhan pora loijabo, aru etu pichete taikhan upwas lobo. ");
INSERT INTO nag_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kun manu bhi ekta notun kapra ke purana kapra logote silai kene nalagai, kele koile etu kapra laga silakhan sob ulai jabo, aru bisi biya pora phati jabo. ");
INSERT INTO nag_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nohoi lebi manu khan purana angur ros ke notun chamra laga jola te nadhale. Nohoile, chamra jola to phati jabo, aru angur ros to pura giri jabo aru chamra jola pura biya hoi jabo. Hoilebi, taikhan notun chamra jola te notun angur ros hale, eneka hoile duita bhi bhal thakibo.” ");
INSERT INTO nag_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jitia Tai eitu khan taikhan ke koi thakise, sabi, ekjon sahab ahise aru Jisu age te matha jhukise. Tai koise, “Moi laga chukri etiya mori jaise, kintu Apuni ahibi aru tai uporte Apuni laga hath lagai dibi, aru tai jinda hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Etu pichete Jisu uthise aru tai logote jaise, aru Tai laga chela khan bhi piche ahise. ");
INSERT INTO nag_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sabi, ekjon mahila jun baroh saal pora khun jai thaka bemar pora dukh pai thakise, tai Jisu laga piche ahikena Tai laga kapra kinar te chuise. ");
INSERT INTO nag_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kilekoile etu mahila pora tai nijorke koise, “Khali Tai laga kapra chuile, ami bhal hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kintu Jisu piche ghurise aru taike saikene koise, “Chukri, mon dangor kori lobi; apuni laga biswas pora bhal hoise.” Aru utu homoi te etu mahila ke changai paise. ");
INSERT INTO nag_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Titia Jisu utu daruga laga ghor te punchise, aru Tai pora basuri baja manu khan aru dangor bhir joma hoi kene hala kori thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tai koise, “Jai jabi, kele koile etu chukri mora nai, kintu tai ghumai ase.” Kintu etu manu khan Jisu ke hasi di thakise. ");
INSERT INTO nag_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jitia joma koi kene thaka manu khan sobke bahar te pathai dise, Tai ghor bhitor te ghusi se aru etu chukri ke hath pora dhurise, aru etu chukri uthijaise. ");
INSERT INTO nag_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aru etu laga khobor utu desh sob te punchi jaise. ");
INSERT INTO nag_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisu jitia berai jai thakise, duijon andha manu tai piche korise. Taikhan hala kori kene koise, “Amikhan ke daya koribi, David laga Putro!” ");
INSERT INTO nag_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jitia Jisu ghor te punchise, andha khan tai usorte ahise. Jisu taikhan ke koise, “Tumikhan biswas kore na nai ami etu koribo pare koi kene?” Taikhan koise, “Hoi, Probhu.” ");
INSERT INTO nag_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aru Jisu taikhan laga suku chuise, aru koise, “Tumikhan laga biswas hisab te hoi jabi,” ");
INSERT INTO nag_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","aru taikhan laga suku khuli jaise. Jisu pora taikhan ke kara pora hukum dikene eneka koise, “Sabi etu kotha khan kunke bhi janibo nadibi.” ");
INSERT INTO nag_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kintu etu duijon manu bahar te ulai jaise aru sob desh te etu laga khobor koi dise. ");
INSERT INTO nag_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tai duijon jai thaka somoite, sabi, ekjon bhoot atma ghumai kene ghunga thaka manu ke Jisu usorte anise. ");
INSERT INTO nag_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jitia bhoot atma ke khedai dise, tai kotha kori bole parise. Sob manu dikhi kene asurit hoise, aru koise, “Eneka asurit kaam to kitia bhi Israel desh te dikha nai!” ");
INSERT INTO nag_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kintu Pharisee khan eneka koise, “Bhoot atma laga cholawta huwa nimite, tai bhoot atma ke kheda bole pari ase.” ");
INSERT INTO nag_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisu sob sheher khan aru bosti khan te berai kene jaise. Tai mondoli khan te jai kene rajyo laga susamachar khan sikhai thakise aru sob biya bemar khan ke bhal korise. ");
INSERT INTO nag_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jitia Tai manu joma koi kene thaka dikhise, Tai bisi morom lagise, kele koile taikhan bisi dukh aru chinta hoi kene thakise, jineka mer khan laga ekjon rokhiya nathaka nisena. ");
INSERT INTO nag_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Etu pichete Jisu taikhan laga chela khan ke koise, “Dhan bisi pakki kene ase, kintu kati bole manu komti ase. ");
INSERT INTO nag_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Etu nimite, joldi Probhu ke prathana kori bhi, titia Tai kaam kori bole manu khan ke pathai dibo.” ");
INSERT INTO nag_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisu tai laga baroh ta chela khan sobke matise aru taikhan ke atma khan kheda bole aru sob bemar khan bhal kori bole adhikar dise. ");
INSERT INTO nag_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Etiya etu baroh ta chela khan laga naam khan eneka thakise. Poila, Simon -junke Peter koi kene mate-, aru tai laga bhai Andrew; James, Zebedee laga chokra, aru tai laga bhai John; ");
INSERT INTO nag_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip, aru Bartholomew; Thomas, aru Matthew ekjon poisa utha manu; James, Alphaeus laga chokra, aru Thaddaeus; ");
INSERT INTO nag_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon ekjon Zealot, aru Judas Iscariot, jun Jisu ke thogabo. ");
INSERT INTO nag_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aru baroh ta jon chela khan ke Jisu pora pathai dise. Tai bujhai kene koise, “Porjati manu khan laga rasta te najabi, aru Samaria nogor bhitor te naghusi bhi. ");
INSERT INTO nag_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kintu harai ja-a mer khan jun ase Israel laga ghor, taikhan logot jabi; ");
INSERT INTO nag_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","aru jitia tumikhan jai, prochar kori kene kobi, ‘Sorgo laga rajyo usor ahi ase.’ ");
INSERT INTO nag_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bemar khan ke bhal koribi, mora khan ke uthai dibi, kusto bemar thaka khan ke sapha kori dibi, aru biya atma khan ke khedai dibi. Eku daam naterai kene paise, eku daam noloikena dibi. ");
INSERT INTO nag_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Suna, chandi, nohoile pitol khan eku nabukhibi. ");
INSERT INTO nag_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Eku jola nadhuribi jai thaka somoite, nohoile duita kapra, nohoile chapal, nohoile lathi nadhuribi, kele koile kaam kora khan ke hajira pabo lage. ");
INSERT INTO nag_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kuntu sheher nohoile bhi bosti te tumikhan jai, utu jagate ekjon bhal manu ke bisaribi, aru jitia tak tumi chari kene najai, tai laga ghor te he thakibi. ");
INSERT INTO nag_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jitia tumi tai laga ghor te ghuse, taike salam koribi. ");
INSERT INTO nag_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aru etu ghor to thik hoile, tumikhan laga shanti ta te thakibo dibi. Kintu jodi ghor to thik nohoi, tinehoile shanti to wapas tumikhan laga hobo. ");
INSERT INTO nag_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Judi utu ghor te tumikhan ke ghusibole nadiye, aru utu sheher manu khan pora tumikhan laga kotha nahune, tinehoile etu jaga chari bhi aru tumi laga theng te dhula khan jharikena jai jabi. ");
INSERT INTO nag_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hosa pora Moi koi ase, jitia Isor laga bisar kora din ahibo, etu dinte etu sheher to Sodom aru Gomorrah town khan pora bhi bisi lobole napara laga saja pabo. ");
INSERT INTO nag_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sabi, Ami tumikhan ke ekta mer nisena rong kutta janwar khan majote pathai ase, etu nimite saph nisena gyaani thakibi aru kabotar nisena norom thakibi. ");
INSERT INTO nag_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Eneka manu khan pora hoshiar koi kene thakibi! Kilekoile taikhan tumikhan ke sabhakhan te loijabo, aru taikhan laga mondoli bhitor te tumikhan ke marikena sajai dibo. ");
INSERT INTO nag_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Etu pichete Ami nimite tumikhan ke Governor aru raja khan laga age te anibo, dusra khan aru Porjati khan ke ekta gawahi nisena dikhai dibole. ");
INSERT INTO nag_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jitia taikhan tumikhan ke taikhan hathte di dibo, titia tumikhan ki kobo lage etu karone chinta na koribi, kele koile thik somoite ji kobo lage etu sob tumikhan ke koi dibo. ");
INSERT INTO nag_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kilekoile tumikhan pora nakobo, kintu Baba laga Atma pora he tumikhan nimite koi dibo. ");
INSERT INTO nag_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bhai pora he kokai ke phasai dibo, aru baba pora nijor bacha ke. Bacha khan ama baba khan logote jhagara koribo aru taikhan ke morai dibole koribo. ");
INSERT INTO nag_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Moi laga naam nimite tumikhan ke sob pora ghin koribo. Kintu jun khan dukh digdar puwa homoi sob khotom nohua tak dhorjo kori kene thakibo pare, taikhan he bachibo. ");
INSERT INTO nag_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jitia taikhan pora etu sheher te tumikhan ke biya pora digdar dibo, dusra jagate polai jabi, kele koile Ami hosa pora tumikhan ke koi ase, Manu laga Putro naha age te tumikhan Israel laga sob sheher khan te jai kene khotom kori bole na paribo. ");
INSERT INTO nag_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ekjon chela tai laga guru pora dangor nohoi, nohoi lebi ekjon nokor malik pora dangor nohoi. ");
INSERT INTO nag_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ekjon chela tai laga guru nisena hoile etu he thik ase, aru ekjon nokor tai laga malik nisena hoile he thik ase. Judi taikhan etu ghor malik ke Beelzebul koi kene mate koile, kiman bhi biya pora tai laga ghor manu khan ke matibo! ");
INSERT INTO nag_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Etu karone taikhan ke bhoi nakhabi, kele koile lukaikene thaka eku nai juntu ke janai nadibo, aru juntu janai dibole pare, etu ke lukai kene rakhibo na paribo. ");
INSERT INTO nag_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ji kotha Ami pora tumikhan ke andhera te koi ase, tumikhan pora dinte koi dibi, aru ji kotha tumikhan norom pora kan te huni pai ase, ghor laga sobse untcha jagate uthikena jor pora sobke hunai dibi. ");
INSERT INTO nag_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jun khan manu ke morai diye eitu khan ke bhoi na koribi kele koile taikhan tumikhan laga jibon ke morai dibole napare. Hoilebi, Isor ke bhoi koribi Jun he tumikhan laga gaw aru jibon ke bhi khotom kori dibole pare. ");
INSERT INTO nag_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ekta chutu chandi pora duita ghor chiriya ke kini bole napare naki? Titia bhi tumikhan laga Baba pora najanikena ekta chiriya bhi matite giribole nadiye. ");
INSERT INTO nag_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kintu tumikhan laga matha te chuli thaka khan sob ginti kori kene ase. ");
INSERT INTO nag_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Etu karone bhoi na koribi. Tumikhan ke ghor laga chiriya pora bhi bisi morom kore. ");
INSERT INTO nag_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Etu karone jun manu sob manu khan laga age te Moi laga naam shikar koribo, Ami bhi tai laga naam sorgote thaka Ami laga Baba age te shikar dibo. ");
INSERT INTO nag_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kintu jun manu pora sob manu laga age te Ami laga naam noloi, Ami bhi tai laga naam sorgote thaka Ami laga Baba age te nolobo. ");
INSERT INTO nag_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ami etu prithibi te shanti dibole aha nohoi. Ami shanti loi kene aha nai, kintu talwar loi kene ahise. ");
INSERT INTO nag_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kilekoile Ami aha to chokra ke tai laga baba pora alag kori dibole, aru ekjon chukri ke tai laga ama pora alag kori dibole, aru ekjon buari ke tai laga sasuma pora alag kori dibole ahise. ");
INSERT INTO nag_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ekjon mota laga dushman khan nijor ghor manu khan he hobo. ");
INSERT INTO nag_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jun manu tai nijor baba aru ama ke Ami pora bisi morom kore tai Ami laga chela hobo na paribo; aru jun tai njior chokra nohoi lebi chukri ke Ami pora bhi bisi morom kore, tai Ami laga chela hobo na paribo. ");
INSERT INTO nag_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jun manu tai laga nijor Cross to uthaikene moi laga piche nahe, tai Ami laga chela hobo na paribo. ");
INSERT INTO nag_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jun manu tai nijor jibon to bacha bole itcha kore tai harai jabo. Kintu jun manu Moi nimite tai laga jibon diye, tai to aru wapas pabo. ");
INSERT INTO nag_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jun manu tumike grohon kore, tai Moike bhi grohon kore, aru jun tumike grohon kore, Isor, jun pora Amike pathaise, Taike bhi grohon kore. ");
INSERT INTO nag_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jun manu ekjon bhabobadi khan ke grohon kore, tai bhabobadi laga inam pabo, aru jun manu dhormik manu ke grohon kore, tai dhormik manu laga inam pabo. ");
INSERT INTO nag_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jun khan etu chutu dukhiya ekjon ke Ami laga chela ase koi kene ek kup thanda pani khilai dibo, hosa pora Ami koi ase, tai to hosa pora bhi tai laga inam to naharabo.” ");
INSERT INTO nag_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Eneka hoise jitia Jisu tai laga baroh jon chela khan ke niyom khan bujhai diya pichete, tai ta te pora ulaikena taikhan laga sheher te jai kene prochar kori bole aru sikhai dibole jai jaise. ");
INSERT INTO nag_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Etu homoi te John bondhi ghor te thakise, tai Khrista laga kotha huni paise, aru tai tai laga chela khan ke ekta jankari dibole pathaise ");
INSERT INTO nag_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","aru Taike hudise, “Apuni ahibole thaka Jon ase naki, na amikhan dusra ke bisaribo?” ");
INSERT INTO nag_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisu pora jowab dikene koise, “Jabi aru John ke koi dibi tumikhan ki hunise aru dikhise. ");
INSERT INTO nag_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Andha manu khan dikhibole paise, lengera khan bera bole parise, kusto bemar thaka khan sapha hoi jaise, behera khan huni bole paise, morija khan jinda hoise, aru gorib manu khan susamachar huni loise. ");
INSERT INTO nag_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jun manu Amike dikhikena biya panai tai to asis paise.” ");
INSERT INTO nag_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jitia taikhan jaise, Jisu pora bhir ke John laga kotha kori bole shuru hoise, “Tumikhan balu laga jagate ki sabole jaise- panite ulai thaka ghas ke hawa pora hilai diya to? ");
INSERT INTO nag_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aru tumikhan ta te ki sabole jaise- ekjon manu norom kapra lagai kene thaka ke? Hosa bhi, jun khan norom kapra lagai, taikhan to raja khan laga ghor te he thake. ");
INSERT INTO nag_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aru tumikhan ki sabole ta te jaise- ekjon bhabobadi? Hoi, Ami tumikhan ke koi ase, tai ekjon bhabobadi pora bhi bisi ase. ");
INSERT INTO nag_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Etu tai ase, jun karone eneka Isor kotha te likhi kene ase, ‘Sabi, Ami pora tumikhan laga chehera age te Ami laga khobor diya manu pathai ase, jun pora tumikhan nimite rasta taiyar koribo.’ ");
INSERT INTO nag_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ami hosa pora tumikhan ke koi ase, tumikhan majote Baptizma diya John nisena kun ama pora bhi jonom diya nai. Hoilebi sorgo laga rajyote thaka sob pora kaam nathaka manu bhi tai pora bisi dangor ase. ");
INSERT INTO nag_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Baptizma diya John laga din pora loi kene etiya tak, sorgo laga rajyo to mara-mari khan pora dukh paise, aru jhagara pora joborjosti kori kene chingi loise. ");
INSERT INTO nag_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kilekoile John naha age te sob bhabobadi khan aru niyom khan laga bhabobani hoi thakise; ");
INSERT INTO nag_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","aru jodi tumikhan lobole itcha ase koile, tai to Elijah ase jun ahibole thakise. ");
INSERT INTO nag_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jun laga kan khan ase, taikhan ke huni bole dibi. ");
INSERT INTO nag_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ki logote etu yug laga manu khan ke tulona koribo? Bacha khan bajar te bohi kene thaka nisena, jun ekjon pora ekjon ke mati thake ");
INSERT INTO nag_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","aru koi, ‘Amikhan pora apnikhan karone shadi laga basuri bajaise, aru apnikhan nacha nai. Amikhan mon dukh hoise aru apnikhan mon dukh laga suku pani bhi ula nai.’ ");
INSERT INTO nag_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kilekoile John to pani aru kha luwa khaikena aha nohoi, aru taikhan koise, ‘Tai logot te bhoot ase.’ ");
INSERT INTO nag_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Manu laga Putro to pani aru kha luwa kori kene ahise aru taikhan koise, ‘Sabi, tai to bisi khai aru ekjon sharabi ase, poisa utha aru paapi manu khan laga sathi ase!’ Kintu gyaan to tai laga bacha pora he dikhai dibo.” ");
INSERT INTO nag_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pichete Jisu jun to jagate tai laga asurit kaam khan dikhai dise, etu sheher khan laga manu khan ke gali dibole shuru korise, kele koile taikhan mon ghuraikena thaka nai. ");
INSERT INTO nag_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Chorazin, tumike hai ase! Bethsaida, tumike hai ase! Juntu kaam tumikhan nimite korise, eneka kaam Tyre aru Sidon nimite korise koile, taikhan poila pora bosta laga kapra aru jui laga koila lagai kene mon ghuri lobole thakise. ");
INSERT INTO nag_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kintu Moi tumikhan ke koi ase, Isor pora bisar kora dinte tumikhan pora bhi Tyre aru Sidon nimite he bisi aram hobo. ");
INSERT INTO nag_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tumi, Capernaum, tumikhan ke sorgo uporte uthibole nadibo, na uthibo dibo? Tumikhan ke Hades te namai dibo. Kilekoile tumikhan ke koi diya nisena jodi Sodom te bhi asurit aru dangor kaam korise koile, taikhan aji bachikena thakibo thakise. ");
INSERT INTO nag_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kintu Moi tumikhan ke koi ase, bisar laga dinte tumikhan pora bhi Sodom nimite he aram hobo.” ");
INSERT INTO nag_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Etu somoite Jisu pora jowab dise aru koise, “Ami Apuni ke mohima di ase, Baba, Sorgo aru prithibi laga Probhu, kele koile Apuni eitu khan gyaani aru buja manu khan pora lukaikene rakhise, aru chutu bacha khan ke dikhai dise. ");
INSERT INTO nag_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hoi, Baba, kele koile etu to Apuni laga suku age te thik ase. ");
INSERT INTO nag_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sob kaam khan moi laga bharosa te Baba pora rakhidise; aru kun bhi Putro ke najane khali Baba he nohoile, aru kun bhi Baba ke najane khali Putro he nohoile, aru utu manu junke Putro pora basikena dikhai dibo. ");
INSERT INTO nag_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ami usorte ahibi, jun manu etu prithibi laga dukh chinta bukhi bo napari kene dabi kene ase, aru Moi tumikhan ke aram dibo. ");
INSERT INTO nag_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ami laga kotha khan lobi aru Ami pora sikhibi, kele koile Ami laga mon to nomro aru shanti ase, aru tumi laga jibon nimite aram pabo. ");
INSERT INTO nag_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kilekoile Ami laga kotha khan aram ase aru ami laga boja bisi halka ase.” ");
INSERT INTO nag_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Utu somoite, ek Bisram dinte, Jisu dhaan kheti paar hoi kene jai thakise. Tai laga chela khan bhuk lagi thaka pora dhaan laga guti ulaikena khabole shuru korise. ");
INSERT INTO nag_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jitia Pharisee khan etu dikhise, taikhan Jisu ke koise, “Sabi, Apuni laga chela khan Bisram nimite niyom te nathaka kaam kori ase.” ");
INSERT INTO nag_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kintu Jisu taikhan ke koise, “Tumikhan kitia bhi Isor kotha te purah nai David pora ki korise, jitia tai aru tai logot thaka manu khan bhuk lagise? ");
INSERT INTO nag_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tai Isor laga ghor te jaise aru Isor nimite rakhikena thaka roti khaise, juntu tai nimite nohoile tai logote thaka manu khan nimite khabole niyom te nai, kele koile khali purohit khan he ta te pora khabo pare. ");
INSERT INTO nag_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nohoile tumikhan Moses laga niyom te purah nai naki Bisram laga dinte mondoli te thaka purohit khan Bisram din laga niyom bhangai kintu taikhan ke etu golti ase koi kene nadhure? ");
INSERT INTO nag_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kintu Moi tumikhan ke koi ase, mondoli pora bhi dangor jon to yate ase. ");
INSERT INTO nag_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jodi tumikhan etu laga motlob janikena thaki ase, ‘Moi daya kora he itcha ase aru bolidan diya nohoi,’ koile tumikhan golti nathaka khan ke golti ase koi kene namatibo. ");
INSERT INTO nag_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kilekoile Manu laga Putro he Bisram Din laga Probhu ase.” ");
INSERT INTO nag_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Etu pichete Jisu ta te pora ulaise aru taikhan laga mondoli te ghusi se. ");
INSERT INTO nag_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sabi, ta te ekjon manu thakise jun laga hath sukhikena thakise. Pharisee khan pora Jisu ke eneka koi kene hudise, “Bisram dinte bemar bhal kori diya to niyom ase naki?” Taikhan Jisu ke golti dibole nimite hudise. ");
INSERT INTO nag_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisu taikhan ke koise, “Kun manu tumikhan majote ase, jun logote khali ekta mer he ase, aru jitia utu mer to Bisram dinte ekdom niche chenda te giri jai koile, tai utu mer ke nauthabo naki? ");
INSERT INTO nag_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tinehoile mer pora bhi manu khan kiman bhi kimti ase! Etu nimite Bisram dinte bhal kaam kora thik niyom ase.” ");
INSERT INTO nag_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Etu pichete Jisu utu manu ke koise, “Tumi laga hath ke sida koribi.” Jitia tai hath sida korise, aru jineka dusra hath nisena, etu hath bhi bhal hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kintu Pharisee khan ta te pora ulai jaise aru jai kene taikhan kineka kori kene Jisu ke morai dibo etu kotha khan kori thakise. ");
INSERT INTO nag_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jitia Jisu eitu khan janibole paise, Tai ta te pora ulai jaise. Bisi manu Tai piche korise, aru Tai sobke bhal kori dise. ");
INSERT INTO nag_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aru manu khan ke Tai janai dibole hoshiar kori dise, ");
INSERT INTO nag_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","titia Isor pora bhabobadi Isaiah dwara kowa kotha khan pura hobole karone eitu khan sob tineka he hoi jaise, ");
INSERT INTO nag_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Sabi, etu Ami laga noukar ase junke Ami basi loise; Ami laga morom thaka ekjon, junke Moi laga jibon pora khushi ase. Moi Tai uporte Moi laga Atma rakhidibo, Aru Tai pora Porjati khan ke ajad kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tai biya napabo nohoile bhi jor pora nakandibo; Nohoile bhi kun bhi rasta khan te Tai laga awaj nahunibo. ");
INSERT INTO nag_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tai ekta tera koi kene thaka pani-ghas bhi bhangai nadibo; Tai khotom hobole thaka jui ke bhi bhutibole nadibo, Jitia tak Tai bisar ke age loi kene jiti noloi, ");
INSERT INTO nag_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","aru Tai laga naam uporte he Porjati khan asha thakibo.” ");
INSERT INTO nag_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Etu pichete kunba ekjon andha aru gunga, bhoot pora bandi kene thaka, Jisu usorte loi anise. Jisu pora taike changai kori dise, aru tai kotha kori bole aru sabole pari jaise. ");
INSERT INTO nag_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sob manu khan dikhikena asurit hoise aru koise, “Etu manu to David laga Putro ase nohoi?” ");
INSERT INTO nag_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kintu jitia Pharisee khan asurit kaam to huni bole paise, taikhan koise, “Etu manu to Saitan laga raja, Beelzebul laga takot pora kaam kori ase, nohoile bhoot khan khedai dibo na paribo.” ");
INSERT INTO nag_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kintu Jisu taikhan laga bhabona jani thakise aru taikhan ke koise, “Juntu rajyo taikhan nijor majote apatti thake, etu rajyo to bhangi jai, aru juntu sheher nohoile bhi ghor to nijor majote apatti thake, etu bhangi jai. ");
INSERT INTO nag_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Etu nimite jodi Saitan pora Saitan ke khedai dile, tai nijor bhirodh te bhag koi kene ase. Kineka kori kene tai laga rajyo to khara koribo? ");
INSERT INTO nag_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aru jodi Moi Beelzebul laga hokti loi kene bhoot khan ke khedai, tinehoile ki hokti pora tumikhan laga bacha khan bhoot khan ke khedai? Etu karone, taikhan pora tumikhan ke bisar koribo. ");
INSERT INTO nag_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kintu jodi Ami Isor laga Atma pora bhoot khan ke khedai diye, tinehoile Isor laga rajyo tumikhan uporte ahikena ase. ");
INSERT INTO nag_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nohoile kineka ekta takot thaka manu ke age nabandi kene utu ghor te ghusi kene saman khan chor koribo paribo? Poila takot manu ke bandibo lagibo etu pichete he tai laga saman khan chor koribo paribo. ");
INSERT INTO nag_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jun Ami logote nohoi tai Amike apatti kore, aru jun Ami logote joma nakore taikhan sob ephale-uphale hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Etu karone Moi tumikhan ke koi ase, sob paap aru hinsa kotha kora khan maph kori dibo, kintu jun manu Atma ke hinsa kore taike maph nadibo. ");
INSERT INTO nag_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jun manu pora Manu laga Putro ke apatti koribo tai maph pabo. Kintu jun manu Pobitro Atma ke apatti koribo, tai kitia bhi maph napabo, etu yug te bhi, aru ahibole thaka yug te bhi. ");
INSERT INTO nag_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ekta bhal ghas to bhal phol dhuri bo, nohoile biya ghas pora to biya phol he dhuri bo, kele koile phol pora he ghas ke janibole pare. ");
INSERT INTO nag_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Saph laga bacha khan, tumikhan biya hoi kene, kineka bhal kotha koi? Kilekoile mon bhitor te ki ase, mukh pora etu he koi. ");
INSERT INTO nag_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bhal manu laga monte bhal saman khan joma kora nimite bhal khan he ulai, aru biya manu laga monte biya saman khan joma kora nimite biya khan he ulai. ");
INSERT INTO nag_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Moi apnikhan ke koi ase jun manu misa-misi kotha kobo, taikhan bisar dinte etu laga hisab-kitab dibo lagibo. ");
INSERT INTO nag_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tumikhan laga kotha para he tumi laga bisar hobo, aru tumi laga kotha pora he tumi bodnam hobo.” ");
INSERT INTO nag_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Etu pichete kunba Pharisee aru niyom likha khan Jisu ke eneka koise, “Shika manu, Apuni pora ekta chihna amikhan sabole itcha ase.” ");
INSERT INTO nag_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kintu Jisu taikhan ke jowab dise aru koise, “Ekta biya aru biswas nathaka jamana laga manu khan he chihna sabole bisare. Kintu eku bhi chihna dikhai nadibo khali bhabobadi Jonah laga chihna he sabo dibo.” ");
INSERT INTO nag_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kilekoile Jonah to tin din aru tin rati ekta dangor maas laga pet bhitor te thakise, etu nisena Manu laga Putro bhi tin din aru tin rati prithibi laga bhitor te thakibo. ");
INSERT INTO nag_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nineveh sheher te thaka manu khan bisar dinte etu jamana laga manu khan logote khara koribo aru bodnam dibo. Kilekoile taikhan to Jonah laga kotha huni kene mon ghuraise, aru sabi, ekjon Jonah pora bhi bisi dangor yate khara ase. ");
INSERT INTO nag_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sheba laga Rani bisar dinte etu jamana laga manu khan logote uthi kene bodnam dibo. Tai prithibi laga sob pora dur jaga pora ahikena Solomon laga gyaani kotha huni bole ahise, aru sabi, ekjon Solomon pora bhi dangor yate khara ase. ");
INSERT INTO nag_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jitia ekta letera atma manu laga gaw pora bahar ulai jai, tai pani nathaka jaga pora paar kore aru aram kori bole bisare, kintu jaga napai. ");
INSERT INTO nag_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Etu pichete tai koi, ‘Juntu jaga pora moi ulaikene ahise etu ghor te wapas jabo.’ Jitia tai ghuri ahe, tai ghor to khali aru sob sapha paise aru ghor te sob thik tak rakhi kene thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Titia tai ta te pora ulaikene tai pora bhi bisi biya sat-ta atma khan ke loi kene ahise aru eke logote thaki jaise. Titia etu manu laga halat to poila pora bhi aru bisi biya hoijai. Thik etu nisena etu jamana laga manu khan ke bhi eneka hobo. ");
INSERT INTO nag_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jitia Jisu bhir khan ke kotha koi thakise, sabi, Tai laga ama aru bhai khan bahar te khara kori Jisu ke lok kori bole bisari thakise. ");
INSERT INTO nag_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ekjon Taike koise, “Sabi, Apuni laga ama aru bhai khan bahar te khara ase, Apuni ke kotha kori bole bisari ase.” ");
INSERT INTO nag_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kintu jun manu taike khobor disele Jisu taike koise, “Kun Moi laga ama ase aru kun Moi laga bhai khan ase?” ");
INSERT INTO nag_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Titia chela khan phale Tai laga anguli ishara kori kene Jisu koise, “Sabi, eitu khan Ami laga ama aru bhai khan ase! ");
INSERT INTO nag_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kilekoile jun manu Moi laga sorgote thaka Baba laga itcha kore, etu he Moi laga bhai, aru Moi laga bhoini, aru Moi laga ama ase.” ");
INSERT INTO nag_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Utu dinte Jisu ghor pora ulaikena nodi kinar te bohi thakise. ");
INSERT INTO nag_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dangor bhir joma hoi kene Tai usorte bohi jaise, etu nimite Tai naw uporte uthise, aru sob manu nodi kinar te khara korise. ");
INSERT INTO nag_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Etu pichete Jisu taikhan ke dristanto khan bisi koise. Tai koise, “Sabi, ekjon kheti kora manu dhaan bijon hali bole jaise. ");
INSERT INTO nag_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jitia tai kheti te bijon phelai thakise, kunba bijon rasta kinar te girise, aru chiriya khan ahikena sob khai dise. ");
INSERT INTO nag_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kunba bijon to bisi pathor thaka jagate girise, aru joldi uthijaise, kele koile mati olop thakise. ");
INSERT INTO nag_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kintu jitia gham ulaise, etu ulai thaka ghas ke julai dise, kele koile etu ghas laga shikor thaka nai, etu karone sob sukhi jaise. ");
INSERT INTO nag_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kunba bijon khan kata ghas majot te girise. Aru etu ghas to olop dangor hoise, hoilebi kata ghas pora morai dise. ");
INSERT INTO nag_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kunba bijon khan bhal matite girise aru bhal ghas hoi kene bhal guti dhurise, kunba eksoh guti, kunba te saathi guti aru kunba te trista guti dhurise. ");
INSERT INTO nag_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jun manu laga kaan ase, taikhan ke huni bole dibi.” ");
INSERT INTO nag_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Titia Jisu laga chela khan Tai usorte ahise aru hudise, “Apuni kele bhir khan ke dristanto pora kotha koi ase?” ");
INSERT INTO nag_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisu taikhan ke koise, “Tumikhan ke sorgo rajyo laga bujhi bo napara kotha khan bujhi bole gyaan dikena ase, kintu taikhan ke diya nai. ");
INSERT INTO nag_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kilekoile jun manu logot olop ase, taike aru bhi dibo, aru tai logote bhorta thakibo. Kintu jun manu logote nai, tai logote ki ase etu bhi loi lobo. ");
INSERT INTO nag_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Etu karone Moi taikhan ke dristanto pora kotha kore: Taikhan dikhi ase, kintu taikhan sabole napare; aru taikhan huni ase, kintu taikhan huni kene bhi bujhi bo napare. ");
INSERT INTO nag_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Taikhan nimite to Isaiah laga bhabobani to purah hoise, juntu eneka koi ase, ‘Tumikhan hosa pora bhi hunibo, kintu janibole na paribo; Tumikhan hosa pora bhi dikhibo, kintu bujhi bole na paribo. ");
INSERT INTO nag_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kilekoile etu manu khan laga mon to khali hoise, Aru taikhan huni bole tan kori loise, Aru taikhan laga suku bondh kori loise, Eneka korile taikhan suku pora nasabo nimite, Nohoile taikhan kaan pora nahunibo nimite, Nohoile taikhan laga mon pora nabujibo nimite, Kilekoile eneka kori kene taikhan aru bhi mon naghurabo nimite, Aru Moi taikhan ke bhal kori nadibo nimite.’ ");
INSERT INTO nag_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kintu asis te ase tumikhan laga suku, kele koile taikhan dikhi ase; aru tumikhan laga kaan, kele koile taikhan huni ase. ");
INSERT INTO nag_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Moi hosa pora koi ase tumikhan ke bisi bhabobadi aru pobitro manu khan to tumikhan ki dikhi ase, eitu khan sabole mon thakise, hoilebi taikhan dikhibole panai. Tumikhan ki kotha huni ase, taikhan bhi huni bole mon thakise, kintu taikhan huni bole panai. ");
INSERT INTO nag_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Etu nimite kheti kora manu bijon phela laga dristanto etu laga ki motlob ase huni bhi aru bujhibi. ");
INSERT INTO nag_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jitia kunba manu rajyo laga kotha hune kintu bujhi bole napare, tinehoile biya Jon ahe aru ki tai laga monte bijon hali kene ase etu chingi kene loijai. Etu bijon to rasta kinar te phelai diya bijon ase. ");
INSERT INTO nag_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Juntu bijon pathor uporte phelaise, etu to eneka manu ase jun kotha huni loi aru loge-loge khushi pora grohon kore, ");
INSERT INTO nag_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kintu kotha khan tai laga mon bhitor te najai, etu nimite khali olop somoi nimite he rakhe. Jitia etu kotha nimite biya aru dukh-digdar pa-a somoi ahe, tai ekbar te he giri jai. ");
INSERT INTO nag_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Juntu bijon kata ghas khan majote phelaise, etu to eneka manu ase jun kotha to hune, hoilebi etu jamana laga kaam aru dhun sompoti ke mon diya nimite kotha ke dabai kene rakhe, aru etu kotha pora bhal guti nadhure. ");
INSERT INTO nag_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Juntu bijon bhal matite phelaise, etu to eneka manu ase jun kotha to hune aru bujhi loi. Tai dangor koi kene bhal guti dhure, kunba te eksoh guti dhore, kunba te sathi aru kunba te trista.” ");
INSERT INTO nag_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisu taikhan ke dusra dristanto koise. Tai koise, “Sorgo laga rajyo to ekjon manu nisena ase jun tai laga kheti te bhal bijon phelai. ");
INSERT INTO nag_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kintu jitia manu khan ghumai jai, tai laga dushman khan ahikena gehu laga kheti te biya ghas laga bijon khan phelai aru jai-jai. ");
INSERT INTO nag_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jitia kheti te gehu khan dangor koi kene guti ulabole shuru hoise, titia biya ghas khan bhi dangor hoijai. ");
INSERT INTO nag_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Etu mati malik laga nokorkhan ahi kene taike koi, ‘Sahab, apuni to bhal bijon kheti te lagase nohoi? Nohoile kineka kori kene etu biya ghas khan ulaise?’ ");
INSERT INTO nag_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Etu pichete tai pora taikhan ke koise, ‘Dushman pora eneka kore.’ Nokorkhan taike koise, ‘To apuni itcha ase koile amikhan jai kene jongol khan sapha kori dibo?’ ");
INSERT INTO nag_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mati malik pora taikhan ke koi, ‘Nai. Kilekoile jitia tumikhan biya ghas khan tanibo, tai logote gehu laga ghas bhi tani kene ulai dibo pare. ");
INSERT INTO nag_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Etu nimite duijon ke bhi eke logote dangor koribo dibi, kheti kata somoi naha tak. Jitia kheti kata somoi hobo titia moi kata manu khan ke kobo, “Poila biya ghas khan tani kene ulai lobi aru eke logote bandhi kene rakhibi julai dibo nimite, kintu gehu khan ke dhaan ghor te joma kori rakhibi.’” ");
INSERT INTO nag_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Etu pichete Jisu aru ekta dristanto taikhan ke koise. Tai koise, “Sorgo laga rajyo to ekta sorso laga bijon nisena ase jineka ekta manu pora loi kene kheti te phelai de. ");
INSERT INTO nag_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Etu bijon to hosa pora bhi sobse huru ase sob bijon majote. Kintu jitia tai dangor hoi, bagan laga ghas khan pora bhi tai he dangor hoijai. Tai ekta dangor ghas hoijai, aru akas laga chiriya khan ahe aru etu ghas laga daal khan te ghor bonaikena thake.” ");
INSERT INTO nag_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisu taikhan ke aru alag dristanto koise. “Sorgo laga rajyo to khomir nisena ase, jineka ekta maiki pora etu khomir ke loi kene tin bhag atta te milai diye jitia tak etu atta to phuli najai.” ");
INSERT INTO nag_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Eitu khan sob kotha Jisu pora manu khan ke dristanto pora he koi dise; aru Tai ekta kotha bhi dristanto nacholai kene kowa nai. ");
INSERT INTO nag_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eitu khan sob age te bhabobadi pora koi diya kotha khan sob purah hobole nimite, Tai koi dise, “Dristanto khan pora he Moi mukh khuli bo. Ki kotha etu prithibi laga bhetimul te lukaikene ase eitu khan sob Moi koi dibo.” ");
INSERT INTO nag_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Etu pichete Jisu manu khan ke chari kene ghor te jaise. Tai laga chela khan Tai logote ahikena, eneka koise, “Amikhan ke kheti te biya ghas laga dristanto to bujhai dibi.” ");
INSERT INTO nag_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisu taikhan ke koise, “Jun bhal bijon to phelai, tai to Manu laga Putro ase. ");
INSERT INTO nag_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Prithibi to kheti ase; aru bhal bijon khan to rajyo lage bacha khan ase. Biya ghas to biya jon laga bacha khan ase, ");
INSERT INTO nag_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","aru jun dushman pora biya hissi se eitu khan saitan ase. Kheti kata somoi to yug khotom huwa somoi ase, aru kheti kata manu khan to sorgodoth khan ase. ");
INSERT INTO nag_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Etu karone, jineka biya ghas khan ke joma kori kene jui te julai dise, yug ses huwa dinte bhi eneka hobo. ");
INSERT INTO nag_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Manu laga Putro pora Tai laga sorgodoth khan ke pathabo, aru taikhan pora Tai laga rajyo pora paap aru biya kaam kora khan ke joma kori kene bahar te ulai dibo. ");
INSERT INTO nag_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Taikhan pora eitu khan sobke jui laga chulah te phelai dibo, juntu jagate kandi thaka aru daat kamuri thaka he hobo. ");
INSERT INTO nag_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Etu pichete dharmik manu khan Baba laga rajyote suryo nisena ujala hobo. Jun laga kan ase, tai hunibo dibi. ");
INSERT INTO nag_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sorgo laga rajyo to ekta kheti te khajana lukaikene thaka nisena ase, jitia ekjon manu pora etu pai, tai etu ke aru bhi lukai diye. Kilekoile tai mon khushi hoijai, aru tai laga dhun sompoti sob bikiri kori kene etu kheti kini loi. ");
INSERT INTO nag_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aru, sorgo laga rajyo to ekjon vyapari manu kimti laga moti khan bisari thaka nisena ase. ");
INSERT INTO nag_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jitia tai bisi kimti thaka ekta moti pai, tai laga sob dhun sompoti bikiri kori kene etu kini loi. ");
INSERT INTO nag_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Aru bhi, sorgo laga rajyo to samundar te jaal phela nisena ase, aru sob kisim laga maas dhura nisena ase. ");
INSERT INTO nag_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jitia jal to maas pora bhorta hoi jaise, taikhan etu loi kene samundar kinar te rakhe. Etu pichete taikhan bhal maas basi kene boxsa te joma kore, aru kaam nathaka maas khan sob phelai diye. ");
INSERT INTO nag_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Thik eneka, etu yug ses huwa dinte bhi eneka hobo. Sorgodoth khan ahibo aru biya manu khan ke dhormik khan pora alag kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Taikhan ke jui laga chulah te julai dibo, juntu jagate khali kandi thaka aru daat kamuri thaka he hobo. ");
INSERT INTO nag_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Apnikhan eitu khan sob bujise na nai?” Jisu laga chela khan Taike koise, “Hoi.” ");
INSERT INTO nag_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Etu pichete Jisu taikhan ke koise, “Etu karone sob niyom likha manu khan jun sorgo rajyo laga chela hoi jaise, eitu khan utu manu ase jun ekta ghor laga malik nisena ase.” ");
INSERT INTO nag_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Etu pichete jitia Jisu etu dristanto khan koi kene khotom hoise, Tai ta te pora ulai jaise. ");
INSERT INTO nag_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aru Tai nijor town Nazareth te jaise aru mondoli te manu khan ke sikhai thakise. Jisu laga kotha huni kene taikhan asurit hoi jaise aru taikhan majote koi thakise, “Kot pora etu manu iman asurit gyaan aru hokti paise? ");
INSERT INTO nag_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Etu manu to ekjon barhoi laga chokra nohoi? Tai laga ama to Mary nohoi? Tai laga bhai khan James, Joseph, Simon aru Judas khan nohoi? ");
INSERT INTO nag_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tai laga bhoini khan to amikhan logote ase nohoi? To kineka kori kene Tai eitu khan jani paise?” ");
INSERT INTO nag_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Taikhan Jisu ke biya paise. Kintu Jisu taikhan ke koise, “Ekjon bhabobadi ke tai nijor desh aru tai nijor parivar pora bhi sonman nakore.” ");
INSERT INTO nag_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tai asurit kaam khan bisi kora nai kele koile taikhan laga biswas nathaka nimite. ");
INSERT INTO nag_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Utu din khan te, raja Herod Jisu laga khobor huni bole paise. ");
INSERT INTO nag_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tai laga daruga khan ke koise, “Etu Baptizma diya John ase; tai mora pora jinda hoise. Etu karone etu hokti khan tai logote kaam kori ase.” ");
INSERT INTO nag_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kilekoile Herod to John ke dhurikena thakise, taike bandi se aru bondhi ghor te Herodias, tai laga bhai Philip laga maiki pora kowa nimite rakhise. ");
INSERT INTO nag_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kilekoile John pora taike koise, “Apuni etu maiki ke lobole niyom hisab te nai.” ");
INSERT INTO nag_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod to John ke morai dibole mon thakise, kintu tai manu khan ke bhoi lagi thakise, kele koile manu khan pora John to ekjon bhabobadi ase koi kene mani thakise. ");
INSERT INTO nag_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kintu jitia Herod raja laga jonom din ahisele, Herodias laga chukri sob manu majote nach kori kene Herod raja ke khushi kori dise. ");
INSERT INTO nag_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Etu dikhi kene, Herod raja kosom khaise tai ki mangibo etu sob taike dibo. ");
INSERT INTO nag_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodias pora tai laga chukri ke age pora ki mangibo etu sob sikhai dise, etu chukri Herod ke koise, “Moike ekta thali te Baptizma diya John laga matha dibi.” ");
INSERT INTO nag_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herod etu huni kene bisi mon dukh hoise, kintu tai sob manu age te kosom kha nimite, tai ki mangise etu taike di dibole hukum di dise. ");
INSERT INTO nag_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Herod pora manu ke pathaise aru John laga matha kati dise. ");
INSERT INTO nag_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aru John laga matha thali te rakhi kene etu chukri ke dise kun jai kene tai laga ama ke dise. ");
INSERT INTO nag_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Etu pichete John laga chela khan ahi kene tai laga gaw loi jaise aru mati bhitor te hali dise. Aru taikhan jai kene ki hoise etu sob Jisu ke koi dise. ");
INSERT INTO nag_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jitia Jisu etu khobor hunise, tai utu jaga pora ulaikena naw te kunbi nathaka jagate Tai ekla jai jaise. Jitia manu khan etu huni paise, taikhan laga sheher chari kene theng pora Jisu laga piche kori jaise. ");
INSERT INTO nag_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aru Jisu manu laga dangor bhir thaka dikhise. Taikhan ke bisi morom lagise aru bemar khan ke bhal korise. ");
INSERT INTO nag_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jitia saam hobole shuru hoise, Tai laga chela khan Taike koi, “Etu jagate kunbi nathake aru eku bhi napai, aru ene bhi deri hoise. Manu khan ke jabole dibi, titia taikhan nijor bosti te jai kene kha luwa khabole kini lobo.” ");
INSERT INTO nag_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kintu Jisu taikhan ke koise, “Taikhan najaile bhi hobo. Taikhan ke kiba khabole dibi.” ");
INSERT INTO nag_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tai laga chela khan Taike koise, “Amikhan logote eku bhi nai, khali pansta roti aru duita maas he ase.” ");
INSERT INTO nag_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisu koise, “Eitu khan loi kene anibi.” ");
INSERT INTO nag_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Etu pichete Jisu manu khan ke olop ghas thaka jagate bohi bole koise. Tai etu pansta roti aru duita maas loise, aru sorgo phale saikene, asirbad dise aru etu roti bhangai kene Tai laga chela khan ke dise, aru taikhan pora sob manu khan ke bhag kori dise. ");
INSERT INTO nag_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aru sob pet bhorta khaise. Pichete chela khan jai kene bachi kene thaka roti baroh ta tukri te joma korise. ");
INSERT INTO nag_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ta te 5,000 manu nisena mota manu khan khaise, bacha aru maiki khan ke chari kene. ");
INSERT INTO nag_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aru etu huwa loge-loge, Tai laga chela khan ke naw bhitor te bohibo dise aru taikhan ke nodi laga dusra phale pathai dise. Aru Jisu to taikhan logot najai kene manu khan ke nijor ghor te jai jabole koise. ");
INSERT INTO nag_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jitia Tai sob manu khan ke pathai dise, Tai ekla pahar uporte jaise aru prathana korise. Tai saam tak etu jagate ekla thakise. ");
INSERT INTO nag_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kintu utu somoite hawa bisi mara nimite naw to nodi laga majote punchi jaise, kele koile etu hawa to ulta phale mari thakise. ");
INSERT INTO nag_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ekdum phojurte Jisu nodi uporte berai kene taikhan logote ahise. ");
INSERT INTO nag_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kitia Tai laga chela khan Taike pani uporte bera dikhise, taikhan bisi bhoi khai kene koise, “Etu ekjon bhoot ase,” aru bisi bhoi pora hala korise. ");
INSERT INTO nag_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kintu Jisu taikhan ke koise, “Mon dangor koribi, etu Moi ase! Bhoi na koribi.” ");
INSERT INTO nag_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter pora Jisu ke jowab dise aru koise, “Probhu, jodi etu Apuni ase, titia amike pani upor pora Apuni logot ahibole hukum dibi.” ");
INSERT INTO nag_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisu koise, “Ahibi.” Titia Peter naw pora uthise aru Jisu usorte pani uporte berai kene jaise. ");
INSERT INTO nag_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kintu jitia Peter pora dangor hawa mara dikhise, tai bhoi khai jaise. Jitia tai dubi bole shuru hoise, tai hala kori kene koise, “Probhu, amike bacha bhi!” ");
INSERT INTO nag_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Loge-loge te Jisu Tai laga hath sida korise, aru Peter ke dhuri loise, aru taike koise, “Tumi komti biswas manu, tumi kele chinta korise?” ");
INSERT INTO nag_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Etu pichete Jisu aru Peter naw bhitor te jaise, aru hawa mara to rukhi jaise. ");
INSERT INTO nag_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Etu pichete naw bhitor te chela khan Jisu ke aradhana korise, eneka koi kene, “Hosa pora bhi Apuni to Isor laga Putro ase.” ");
INSERT INTO nag_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jitia taikhan nodi paar kori loise, taikhan Gennesaret town koi kene ekta jagate ahise. ");
INSERT INTO nag_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jitia ta te laga manu khan Jisu ke chini loise, taikhan usorte thaka sob manu khan ke khobor kori dise, aru sob bemar manu khan ke Jisu logot loi anise. ");
INSERT INTO nag_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Taikhan Jisu laga kapra chubo nimite bhik mangi kene Taike hudise, aru jiman manu Taike chuise, taikhan sob bhal hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Etu pichete Pharisee aru niyom likha manu khan Jerusalem pora Jisu usorte ahise. Taikhan koise, ");
INSERT INTO nag_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kile Apuni laga chela khan bura khan banai diya niyom khan bhangai thake? Kile taikhan hath nadholai kene roti khai.” ");
INSERT INTO nag_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisu taikhan ke jowab dikene koise, “Tinehoile kele tumikhan bhi nijor laga niyom nimite Isor laga niyom khan bhangai? ");
INSERT INTO nag_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kilekoile Isor pora hukum dise, eneka koise, ‘Nijor laga baba aru ama ke sonman dibi,’ aru ‘Jun tai nijor baba aru ama laga biya kotha koi, tai hosa pora bhi moribo.’ ");
INSERT INTO nag_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kintu tumikhan koi, ‘Jun khan nijor baba nohoile bhi ama ke koi, “Ki modot apnikhan moi pora pabole ase eitu khan etiya pora Isor ke daan dibo,’” ");
INSERT INTO nag_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","utu manu to tai laga baba ke sonman nadile bhi hobo. Eneka kori kene tumikhan Isor laga kotha ke hisab nathaka kori dise, tumikhan laga niyom manibo nimite. ");
INSERT INTO nag_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dhungi khan! Isaiah pora thik koise, jitia tumikhan nimite tai bhabobani korise, ");
INSERT INTO nag_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Etu manu khan Moike mukh pora he sonman kore, Kintu taikhan laga mon to Moi pora bisi dur te ase. ");
INSERT INTO nag_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Taikhan Moike aradhana kora to misa-misi ase, Kile mane manu pora bana niyom khan taikhan nijor laga niyom nisena sikhai thake.’” ");
INSERT INTO nag_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Etu pichete Jisu pora joma hoi kene thaka manu khan ke mati kene koise, “Huni bhi aru bujhi bhi- ");
INSERT INTO nag_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ki saman manu laga mukh te ghuse etu pora manu ke letera nakore. Kintu, ki to mukh pora bahar te ulai, etu pora he manu ke letera kori diye.” ");
INSERT INTO nag_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Etu pichete chela khan ahi kene Jisu ke koise, “Apuni jane na nai etu Pharisee khan jitia Apuni laga kotha hunise, taikhan khushi panai koi kene?” ");
INSERT INTO nag_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisu pora taikhan ke koise, “Sob ghas juntu sorgote thaka Ami laga Baba pora rupa nai, eitu khan sobke mati bhitor pora tani kene phelai dibo.” ");
INSERT INTO nag_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Taikhan ke ekla chari bhi, taikhan nijor andha koi kene andha manu ke rasta dikhai ase. Jitia ekta andha manu pora dusra andha manu ke rasta dikhai, tai duijon bhi nala te giri bo.” ");
INSERT INTO nag_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter jowab dikene Jisu ke koise, “Etu dristanto laga motlob to bujhai dibi.” ");
INSERT INTO nag_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisu koise, “Tumi etiya tak nabuji kene ase? ");
INSERT INTO nag_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tumi najane, ki jinis mukh bhitor pora ghusi kene pet te jai, etu he pichete latrine kori kene bahar ulai koi kene? ");
INSERT INTO nag_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kintu ji kotha khan mukh pora ulai eitu khan mon pora ulai. Eitu khan pora he manu ke letera kore. ");
INSERT INTO nag_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kilekoile mon pora he biya bhabona, manu morai diya, bebichari, chor kora, misa gawahi, aru hinsa kora eitu khan ulai. ");
INSERT INTO nag_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eitu khan pora he manu khan ke letera kore. Kintu hath nadholai kene kha pora manu ke letera nakore.” ");
INSERT INTO nag_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Etu pichete Jisu ta te pora ulai jaise, aru Tyre aru Sidon sheher phale jaise. ");
INSERT INTO nag_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sabi, ta te ekjon Canaan laga mahila utu jaga pora ulaikene ahise. Tai hala kori kene koise, “Moi uporte daya koribi, Probhu, David laga Putro! Moi laga chukri gaw bhitor te bisi biya bhoot pora bandhi kene ase.” ");
INSERT INTO nag_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kintu Jisu taike ekta jowab bhi diya nai. Tai laga chela khan ahi kene Taike anurodh koise, “Etu mahila ke khedai dibi, kele koile tai amikhan phale hala kori ase.” ");
INSERT INTO nag_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kintu Jisu jowab dikene koise, “Kunba nimite moike patha nohoi, kintu Israel laga ghor laga harai ja mer khan nimite ase.” ");
INSERT INTO nag_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kintu etu mahila ahise aru athukari kene Tai age te matha niche kori kene koise, “Probhu, amike modot koribi.” ");
INSERT INTO nag_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tai jowab dikene koise, “Bacha khan laga roti loi kene kutta khan ke phelai kene diya to thik nohoi.” ");
INSERT INTO nag_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tai koise, “Hoi, Probhu, kintu kutta bacha khan bhi tai malik laga thali pora tukra gira khan khai.” ");
INSERT INTO nag_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Etu pichete Jisu etu mahila ke koise, “Maiki, tumi laga biswas to bisi dangor ase; tumi laga ki khushi ase thik eneka he hobo dibi.” Aru tai laga chukri utu somoite bhal hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisu utu jaga ke chari kene Galilee Nodi usorte jaise. Etu pichete Tai pahar uporte jaise aru ta te bohise. ");
INSERT INTO nag_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bisi manu joma koi kene Tai usorte ahise. Taikhan logote lengra, andha, juthor rugi bemar thaka, aru gunga khan, aru kisim bemar thaka manu khan ke loi kene ahise. Taikhan Jisu laga theng usorte anise aru Jisu pora taikhan ke bhal kori dise. ");
INSERT INTO nag_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Titia manu khan sob asurit hoise jitia taikhan kotha koribo napara khan kotha korise, lengera khan beraise, aru andha khan dikhi bole paise. Taikhan sob Israel laga Isor ke mohima dise. ");
INSERT INTO nag_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tai laga chela khan ke mati kene Jisu koise, “Etu manu khan nimite moi laga monte morom ase, kele koile taikhan tin din pora moi logote thakise aru taikhan ke khila bole eku bhi nai. Moi taikhan ke nakhilai kene pathai dibole mon nai, nohoile matha ghuri kene giri jabo pare.” ");
INSERT INTO nag_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tai laga chela khan Taike koise, “Etu nisena khali jagate kote pora amikhan iman bisi roti bisari kene manu khan ke khila bo?” ");
INSERT INTO nag_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisu taikhan ke koise, “Tumikhan logote kiman roti ase?” Taikhan koise, “Sat-ta, aru chutu maas khan olop ase.” ");
INSERT INTO nag_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Etu pichete Jisu manu khan ke matite bohibi koise. ");
INSERT INTO nag_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tai sat-ta roti aru maas ke loise, aru dhanyavad diya pichete, roti bhangai kene chela khan ke dise. Aru chela khan pora manu khan ke bhag kori dise. ");
INSERT INTO nag_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sob khaise aru pet bhorta hoise. Aru taikhan bacha roti sob joma korise aru sat-ta tukri bhorta hoise. ");
INSERT INTO nag_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Sob milaikena char hajar mota khan thakise, maiki aru bacha khan ke chari kene. ");
INSERT INTO nag_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Etu pichete sobke nijor ghor te pathai dise aru Jisu ekta naw te uthi kene Magadan te jaise. ");
INSERT INTO nag_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Etu pichete, kunba Pharisee aru Sadducee khan ahi kene Jisu ke porikha koribo nimite Taike akas pora kiba ekta asurit kaam kori kene taikhan ke dikhai dibi koise. ");
INSERT INTO nag_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kintu Jisu taikhan ke jowab dise, aru koise, “Jitia saam hoi, tumikhan koi, din to bhal hobo, kele koile akas to lal ase. ");
INSERT INTO nag_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aru phojurte, aji din biya hobole ase, kele koile akas to lal ase aru niche hoi ase. Tumikhan akas te saikene din kobo pare, kintu tumikhan bhal biya din laga somoi saikene kobo napare? ");
INSERT INTO nag_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Biya aru biswas nathaka yug laga manu khan he chihna khan sabole bisare, kintu chihna khan dikhai nadibo khali Jonah laga chihna he pabo.” Etu pichete Jisu ta te pora ulai jai. ");
INSERT INTO nag_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jitia chela khan nodi paar kori kene dusra phale punchi jaise, taikhan roti lobole pahorise. ");
INSERT INTO nag_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisu taikhan ke koise, “Sai thakibi aru Pharisee aru Sadducee khan laga khomir pora hoshiar hoi jabi.” ");
INSERT INTO nag_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Titia chela khan nijor majote kotha kori thakise, eneka koi kene, “Etu eneka hoise kele koile amikhan roti lobole pahorise.” ");
INSERT INTO nag_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisu taikhan laga bhabona jani thakise aru koise, “Tumi biswas komti thaka khan, kele tumikhan nijor majote roti pahora nimite ase koi kene kotha kori ase? ");
INSERT INTO nag_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tumikhan etiya bhi buja nai nohoile bhi yaad nai kineka Moi pansta roti 5,000 manu nimite dise, aru kiman ta tukri bachi kene joma korise? ");
INSERT INTO nag_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nohoile bhi sat-ta roti 4,000 manu nimite dise, aru kiman ta tukri bachi kene joma korise? ");
INSERT INTO nag_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kineka kori kene tumikhan buja nai Moi roti laga kotha kowa nohoi koi kene? Pharisee aru Sadducee laga khomir pora hoshiar thakibi.” ");
INSERT INTO nag_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Etu pichete taikhan bujhi jaise Jisu to roti te khomir thaka pora hoshiar hoija bhi kowa nohoi, kintu Pharisee aru Sadducee khan laga kotha sikhai diya pora hoshiar thakibi koi thakisele. ");
INSERT INTO nag_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Etu pichete jitia Jisu Caesarea Philippi town usorte ahise, Jisu Tai laga chela khan ke hudise, “Manu khan pora Manu laga Putro ke kun koi kene mate?” ");
INSERT INTO nag_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Taikhan koise, “Kunba koi John Baptizma diya jon, kunba, Elijah, aru kunba Jeremiah, aru ekjon bhabobadi.” ");
INSERT INTO nag_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jisu taikhan ke koise, “Kintu tumikhan Moi kun ase koi kene bhabe?” ");
INSERT INTO nag_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter pora jowab dikene koise, “Apuni to Khrista ase, jinda Isor laga Putro.” ");
INSERT INTO nag_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisu taike jowab dikene koise, “Tumi asis paise, Simon Bar Jonah, kele koile manu pora tumike dikhai diya nohoi, kintu Moi laga Baba jun sorgote ase Tai pora he dikhai dise. ");
INSERT INTO nag_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Moi etu bhi tumike koi ase, tumi Peter ase, aru etu pathor uporte Moi laga girja bonabo. Aru Hades laga hokti pora etu girja ke eku koribo na paribo. ");
INSERT INTO nag_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Moi tumike sorgo rajyo laga chabi khan dibo. Tumi junke prithibi te bandhi bo, sorgote bhi etu bandhi bo, aru juntu prithibi te chari bo, sorgote bhi etu chari dibo.” ");
INSERT INTO nag_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Etu pichete Tai chela khan ke hukum dise kunke bhi Tai to Khrista ase nokobi koi kene. ");
INSERT INTO nag_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Utu somoi pora loi kene, Jisu Tai laga chela khan ke Tai Jerusalem te jabo lagibo, aru ta te bura manu khan, aru mukhyo purohit khan aru niyom likha khan pora Taike bisi dukh dibo aru morai dibo, aru tin din pichete mora pora jee uthibo laga kotha khan koi diya shuru hoise. ");
INSERT INTO nag_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Etu pichete Peter pora Jisu ke kinar te loi jaise aru gali dibole shuru hoise, eneka koi kene, “Eitu khan Apuni pora dur hobo dibi, Probhu; eitu khan Apuni ke hobole nadibi.” ");
INSERT INTO nag_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kintu Jisu ghuri kene Peter ke koise, “Moi laga pichete jabi, Saitan! Tumi Ami laga rasta bondh kori ase, kele koile tumi Isor laga kaam nimite hisab nakore, kintu manu khan laga kaam ke hisab kore.” ");
INSERT INTO nag_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Etu pichete Jisu tai laga chela khan ke koise, “Jun Ami laga piche koribo mon ase, tai nijorke chari bo lagibo, nijor laga Cross lobi, aru Moi laga piche koribi. ");
INSERT INTO nag_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kilekoile jun manu tai nijor jibon to bacha bole kore tai harai dibo, aru jun manu Ami nimite nijor jibon to harai dibo tai pabo. ");
INSERT INTO nag_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kilekoile ekjon manu laga ki labh ase jitia tai sob duniya to pai jai, kintu nijor jibon to harai diye? Ekjon manu jibon pabo nimite tai ki daam dibo paribo? ");
INSERT INTO nag_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kilekoile Manu laga Putro to Tai laga Baba laga mohima pora sorgodoth khan logote wapas ahibo. Etu pichete Tai sob manu ke taikhan laga kaam hisab te inam dibo. ");
INSERT INTO nag_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Moi hosa pora apnikhan ke koise, tumikhan majote kunba yate khara ase jun namora age te Manu laga Putro ke Tai laga rajyo loi kene akas te ahi thaka dikhibo.” ");
INSERT INTO nag_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Choi din pichete Jisu tai logote Peter, James aru tai laga bhai John ke loise, aru taikhan nijor pora ekta untcha pahar uporte jaise. ");
INSERT INTO nag_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aru Jisu nijorke taikhan age te alag ekjon kori kene dikhaise. Tai laga chehera suryo nisena ujala dikhaise, aru Tai laga kapra khan puhor nisena boga hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sabi, ta te taikhan logote Moses aru Elijah ulaikene Jisu logote kotha kori thakise. ");
INSERT INTO nag_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter jowab dikene Jisu ke koise, “Probhu, amikhan yate thaka to bhal ase naki. Apuni itcha ase koile, Moi etu jagate aram kori bole chaat bonabo- ekta Apuni nimite, aru ekta Moses nimite, aru ekta Elijah nimite.” ");
INSERT INTO nag_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Jitia tai kotha kori thakise, sabi, ekta ujala badal taikhan ke bondh kori dise, aru etu badal pora ekta awaj ulaikena eneka koise, “Etu Moi laga bisi morom Putro ase, jun uporte moi bisi khushi ase. Tai laga kotha huni bhi.” ");
INSERT INTO nag_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jitia tinjon chela khan etu hunise, taikhan bisi bhoi kori kene matite girise aru nijor chehera mati phale saise. ");
INSERT INTO nag_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Etu pichete Jisu ahise aru taikhan ke chui kene koise, “Uthibi aru bhoi na koribi.” ");
INSERT INTO nag_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Etu pichete taikhan suku uthaikene saise, kintu taikhan khali Jisu he nohoile dusra kunke bhi dikha nai. ");
INSERT INTO nag_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Taikhan jitia pahar upor pora nami ahi thakise, Jisu taikhan ke hukum dise, eneka koi kene, “Etu laga sapna kunke bhi nakobi jitia tak Manu laga Putro mora pora arubi jinda nohoi jai.” ");
INSERT INTO nag_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tai laga chela khan Taike eneka koi kene hudise, “Tenehoile kele kunba niyom likha manu khan Elijah he poila ahibo lage koi?” ");
INSERT INTO nag_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisu taikhan ke jowab dikene koise, “Elijah hosa pora bhi ahibo aru sob to thik kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kintu Moi tumikhan ke koi ase, Elijah to poila pora ahi jaise, kintu taikhan taike chini bole para nai. Ulta, tai uporte ki kori bole itcha thakise taikhan etu kori dise. Thik eneka he, Manu Laga Putro bhi taikhan laga hathte bisi dukh pabo.” ");
INSERT INTO nag_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Titia he chela khan bujise Tai John Baptizma laga kotha taikhan ke kori thakise koi kene. ");
INSERT INTO nag_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jitia taikhan manu joma hoi thaka jagate ahise, ekjon manu Tai usorte ahise, Tai age te athukari se, ");
INSERT INTO nag_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","aru koise, “Probhu, moi laga chokra uporte daya koribi, kele koile tai pagla hoi kene ase, aru bisi dukh pai ase. Kilekoile tai khali jui uporte giri thake, aru khali panite ghusi thake. ");
INSERT INTO nag_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Moi taike Apuni laga chela khan usorte ani sele, kintu taikhan bhal kori bole para nai.” ");
INSERT INTO nag_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisu jowab dikene koise, “Biswas nathaka aru biya jamana laga manu khan, aru kiman deri nimite Moi tumikhan logote thakibo lagibo? Kiman deri tumikhan ke dhorjo koribo? Taike Moi laga samne te anibi.” ");
INSERT INTO nag_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisu pora bhoot atma ke khedai dise, aru etu atma tai laga gaw pora ulai jaise, aru utu somoite etu chokra to bhal hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Etu pichete Jisu laga chela khan lukai kene Taike koise, “Kile amikhan bhoot ke kheda bole para nai?” ");
INSERT INTO nag_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jisu taikhan ke koise, “Kile mane tumikhan laga biswas komti thaka nimite. Moi hosa pora tumikhan ke koi ase, jodi tumikhan sorso dana nisena hoilebi biswas thakile, tumikhan etu pahar ke kobo, ‘Yate pora hati kene ta te jabi,’ aru etu hati jabo, aru tumikhan nimite eku bhi napara kaam nohobo. ");
INSERT INTO nag_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kintu eitu khan sob to, prathana aru upwas pora nohoile dusra eku pora na paribo.” ");
INSERT INTO nag_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jitia taikhan Galilee te thakise, Jisu Tai laga chela khan ke koise, “Manu laga Putro ke manu khan laga hath di dibo, ");
INSERT INTO nag_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","aru taikhan pora Taike morai dibo, aru tin dinte Taike mora pora uthai dibo.” Etu huni kene chela khan bisi mon dukh hoise. ");
INSERT INTO nag_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jitia taikhan Capernaum jagate punchise, ekjon manu jun dui taka chandi poisa utha manu Peter usorte ahise aru koise, “Apnikhan laga Shika manu to dui taka chandi poisa to diye na nai?” ");
INSERT INTO nag_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tai koise, “Hoi.” Jitia Peter ghor te ghusi loise, Jisu taike poila kotha korise, eneka koi kene, “Tumi ki bhabe, Simon? Kun logot pora prithibi laga raja khan poisa uthai? Taikhan laga bacha khan pora na dusra khan pora?” ");
INSERT INTO nag_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jitia tai koise, “Dusra khan pora,” Jisu taike koise, “Tinehoile bacha khan nimite ene to eku daam nai.” ");
INSERT INTO nag_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kintu amikhan nimite poisa utha manu ke paap koribo nadibo, etu nimite nodi te jabi, ekta maas dhura kata phelabi aru juntu maas ke poila pai etu ke loi kene anibi. Jitia tumi maas laga mukh khuli loi, ta te charta chandi pabo. Lobi aru jai kene poisa utha manu ke tumi aru Ami nimite bhi dibi.” ");
INSERT INTO nag_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Utu somoite Jisu laga chela khan Tai usorte ahise aru koise, “Tinehoile kun sorgo laga rajyote sobse dangor ase?” ");
INSERT INTO nag_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisu pora Tai usorte ekta bacha ke mati kene taikhan majote bohise, ");
INSERT INTO nag_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aru koise, “Moi hosa pora tumikhan ke koi ase, jitia tak apuni chutu bacha khan nisena nohoi, tumikhan ekjon bhi sorgo laga rajyote ghusi bole na paribo. ");
INSERT INTO nag_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Etu karone, jun manu nijorke ekta bacha nisena chutu koribo, tai he sorgo laga rajyote sobse dangor ase. ");
INSERT INTO nag_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jun manu chutu bacha khan ke etu nisena Moi laga naam te ahibole diye tai Moike pai jai. ");
INSERT INTO nag_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kintu jodi etu bacha khan majote ekjon bhi Moike biswas kore, aru kunba manu utu bacha ke paap kaam kori bole diye koile, utu manu nimite dangor pathor tai laga gola te bandhi kene nodi te dubi le he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Etu prithibi laga manu khan ke bisi morom lage, juntu kaam khan nimite taikhan paap kori ase. Eitu khan sob purah hobo lage, kintu utu manu khan uporte aru dangor sajai hobo jun etu paap kaam hobole di ase. ");
INSERT INTO nag_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jodi tumi laga hath nohoile theng nimite tumike girai de koile, etu ke kati dibi aru tumi laga gaw pora phelai dibi. Tumi nimite duita hath aru theng thaki kene norokte ja pora to gaw te hath nohoile theng nathaki kene sorgote ja to he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jodi tumi laga suku nimite paap koribo diye koile, ulai dibi aru tumi laga gaw pora phelai dibi. Kilekoile tumi nimite duita suku thaki kene norokte ja pora to gaw te ekta suku thaki kene sorgote ja he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Hoshiar thakibi, etu chutu bacha khan eku kaam nai koi kene nabhabi bhi. Kilekoile Moi tumikhan ke koi ase, taikhan laga sorgodoth khan pora Moi laga sorgote thaka Baba laga chehera hodai sai thake. ");
INSERT INTO nag_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kilekoile Manu laga Putro to harai ja khan nimite ahise. ");
INSERT INTO nag_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tumikhan ki bhabona ase? Jodi ekjon manu logote eksoh mer khan ase, aru ekta harai jaise koile, tai ninyanve mer khan ke pahar te chari kene, ekta harai ja ke bisaribo nohoi? ");
INSERT INTO nag_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jodi tai pai jai, Moi hosa pora koi ase, utu ninyanve mer khan pora bhi harai ja ekta pai ja-a nimite bisi khushi hobo. ");
INSERT INTO nag_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Thik etu nisena, Sorgote thaka Baba laga itcha nohoi eitu khan nisena ekjon chutu hoile bhi harai jabole. ");
INSERT INTO nag_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jodi tumi laga bhai pora tumi uporte paap korise koile, jabi aru tai laga golti koi dibi, tai aru tumi ekla duijon majote. Jodi tai tumi laga kotha hune koile, tumi laga bhai ke jiti loise. ");
INSERT INTO nag_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kintu jodi tai tumi laga kotha nahune koile, ekjon duijon ke tumi logote loijabi, eneka hoile duijon tinjon manu pora ki hoise, eitu khan taikhan laga mukh pora jani jabo. ");
INSERT INTO nag_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aru jodi taikhan laga kotha khan bhi nahune koile, girja ke etu laga kotha to koi dibi. Jodi tai girja laga bhi kotha nahune koile, taike ekjon Porjati aru poisa utha manu nisena chari di bhi. ");
INSERT INTO nag_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Moi hosa pora koi ase tumikhan ke, ki jinis khan prithibi te bandibo etu sorgote bhi hobo; aru ji jinis khan prithibi te chari bo etu sorgote bhi hobo. ");
INSERT INTO nag_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Aru bhi Moi hosa pora tumikhan ke koise, jodi duijon majote mon mili kene ki karone hoile bhi mangise koile, taikhan nimite Moi laga Baba jun sorgote ase eitu khan kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kilekoile juntu jagate duijon tinjon Moi naam te joma kore, taikhan majote Moi ase.” ");
INSERT INTO nag_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Etu pichete Peter ahise aru Jisu ke koise, “Probhu, kiman bar moi laga bhai ami uporte paap kaam koribo aru taike maph dibo? Sat bar tak?” ");
INSERT INTO nag_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisu taike koise, “Moi tumike sat bar tak koribo kowa nai, kintu sattar laga sat bar tak. ");
INSERT INTO nag_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Etu karone sorgo laga rajyo to ekjon raja nisena jun tai laga kaam kora manu logote hisab-kitab kori bole itcha kori loise. ");
INSERT INTO nag_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jitia tai hisab-kitab kori bole shuru hoise, tai usorte ekjon nokor ke loi anise, jun tai logot pora dos hajar talent pabo thakise. ");
INSERT INTO nag_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kintu tai logote eku pora bhi baki tirabole thaka nai, etu pora malik pora tai aru tai laga maiki bacha khan aru taikhan logot ki thakise etu sob bikiri koridi kene dhar tirabole hukum dise. ");
INSERT INTO nag_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Etu huni kene nokor matite girise aru malik age te athukari kene mangise, ‘Malik, amike olop somoi dibi, aru ami apuni ke sob tirai dibo.’ ");
INSERT INTO nag_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aru malik tai laga kotha huni kene morom lagi jaise, aru tai laga dhar maph kori dise aru taike chari dise. ");
INSERT INTO nag_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kintu, jitia etu nokor bahar te ulaise, tai logote ek sou denarii dhaar luwa nokor ke dikhise. Tai utu nokor ke gola te jor pora dhori kene eneka koise, ‘Moi laga ki dhar ase etu tirabi.’ ");
INSERT INTO nag_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Etu pichete utu nokor nichete girise aru taike kandi kene maph mangise, eneka koi kene, ‘Amike olop somoi dibi, aru ami apuni ke sob tirai dibo.’ ");
INSERT INTO nag_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kintu utu age laga nokor to eneka kori bole itcha thaka nai. Ulta, tai jaise aru bondhi ghor bhitor te hali dise, jitia tak tai laga dhar natirai. ");
INSERT INTO nag_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Etu karone jitia dusra nokorkhan etu dikhise, taikhan bisi mon biya hoise, aru jai kene malik ke ki hoise etu sob koi dise. ");
INSERT INTO nag_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Etu pichete etu nokor laga malik taike matise, aru koise, ‘Tumi mon kala thaka nokor, moi tumi laga dhar khan sob maph kori dise, kele koile tumi kandi kene moike maph manga nimite. ");
INSERT INTO nag_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tumi bhi nijor manu ke daya koribo para nai, jineka moi tumi uporte daya korise?’ ");
INSERT INTO nag_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aru malik gusa thakise aru taike sajai diya manu laga hathte dise, jitia tak tai baki khan natirai. ");
INSERT INTO nag_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Etu nisena Moi laga sorgote thaka Baba bhi tumikhan ke eneka koribo, jitia tak tumikhan nijor bhai kokai khan ke maph nakoribo.” ");
INSERT INTO nag_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aru eneka hoise, jitia Jisu eitu khan koi kene khotom hoise, tai Galilee pora ulaise, aru Jordan nodi laga paar thaka Judah jagate ahise. ");
INSERT INTO nag_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aru bisi manu khan tai laga piche-piche ahise; aru Tai ta te taikhan ke changai korise. ");
INSERT INTO nag_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pharisee khan bhi tai usorte ahise, taike porikha kori bole lagise, aru taike koise, “Ki nimite hoile bhi ekjon manu tai laga maiki ke chari bole niyom ase na nai? ");
INSERT INTO nag_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aru Tai jowab te taikhan ke koise, “Tumikhan Isor kotha te purah nai, Tai jun prothom te sristi bonaise, taikhan ke mota aru mahila bonaise? ");
INSERT INTO nag_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aru koise, ‘etu nimite ekjon manu baba aru ama ke chari bo, aru tai laga maiki logote jabo: aru tai duijon ekta sharir hoi jabo.’ ");
INSERT INTO nag_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eneka pora taikhan aru duita nohoi, hoile bhi ekta sharir hoijai. Etu nimite Isor ki eke logote milai dise, manu khan etu ke alag na koribi.” ");
INSERT INTO nag_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Taikhan koise, “Tinehoile kele Moses koise chara-chari laga ekta kagos likhi bole, aru taike chari dibole?” ");
INSERT INTO nag_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tai taikhan ke koise, “Kilekoile tumikhan laga mon to bisi tan ase etu nimite Moses pora tumikhan laga maiki chari dibole koise: hoile bhi age te eneka thaka nai. ");
INSERT INTO nag_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aru Moi tumikhan ke koi ase, jun bhi tai laga maiki ke chari bo, khali bebichar kotha karone chari kene, aru dusra ke shadi koribo, tai bebichar laga kaam kore: aru jun utu pora chari diye maiki ke shadi koribo, tai bebichar laga kaam kore.” ");
INSERT INTO nag_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tai laga chela khan taike koise, “Ekjon manu tai laga maiki logote eneka ase koile, shadi nakora he bhal ase.” ");
INSERT INTO nag_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hoile bhi tai taikhan ke koise, “Sob manu khan etu kotha ke lobole na paribo, khali taikhan ke chari kene jun khan ke etu dise. ");
INSERT INTO nag_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kilekoile ta te kunba hijira khan asele, jun khan taikhan laga ama laga pet pora he eneka jonom hoise: aru ta te kunba hijira thakise jun khan ke manu khan pora hijira bonaise: aru ta te kunba hijira khan thakise jun khan sorgo laga desh nimite nije ke hijira bonaise. Tai jun etu ke lobole pare, taike lobole dibi.” ");
INSERT INTO nag_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Etu pichete, dusra khan pora Tai usorte chutu-chutu bacha khan ke anise, Tai laga hath taikhan uporte rakhi kene asirbad koribo nimite, kintu chela khan pora taikhan ke gali dise. ");
INSERT INTO nag_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hoile bhi Jisu pora baroh jonke koise, “Bacha khan ke ahibole dibi, Ami logote ahibole taikhan ke narukhabi, kele koile sorgo laga rajyo taikhan nisena pora he ase.” ");
INSERT INTO nag_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aru Jisu pora taikhan uporte hath rakhise aru taikhan ke asirbad dise, aru ta te pora jai jaise. ");
INSERT INTO nag_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sabi, ekjon manu Jisu usorte ahise aru hudise, “Shika manu, moi anonto jibon pabo nimite ki bhal kaam koribo lagibo?” ");
INSERT INTO nag_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisu taike koise, “Tumi kele Moike bhal to ki ase koi kene hudi ase? Khali Ekjon he bhal ase, kintu jodi tumi sorgote ghusi bole mon ase koile, Isor laga niyom khan mani bhi.” ");
INSERT INTO nag_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Etu manu Taike koise, “Kuntu niyom?” Jisu koise, “Morai nadibi, bebichar kaam na koribi, chor nakuribi, misa gawahi nadibi, ");
INSERT INTO nag_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ama aru baba ke sonman koribi, aru ghor usorte thaka manu ke morom koribi jineka nijorke kora nisena.” ");
INSERT INTO nag_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aru etu jawan manu pora Taike koise, “Eitu khan sob ami mani loise. Aru ami ki koribo lagi ase?” ");
INSERT INTO nag_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisu taike koise, “Jodi tumi pura thik hobole itcha ase koile, jabi, tumi logote ki ase sob bikiri kori dibi aru gorib manu khan ke di dibi, aru sorgote tumi laga dhun sompoti pabo; aru ahibi, Ami laga piche koribi.” ");
INSERT INTO nag_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kintu jitia etu jawan Jisu ki koise huni loise, tai mon dukh hoi kene jai jaise, kele koile tai logote bisi dhun sompoti thakise. ");
INSERT INTO nag_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jisu tai laga chela khan ke koise, “Moi hosa pora tumikhan ke koi ase, ekjon dhuni manu nimite sorgo laga rajyote ghusi bole digdar ase. ");
INSERT INTO nag_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Arubi Moi tumikhan ke koi ase, ekjon dhuni manu Isor laga rajyote gusa pora to ekta uth bhiji laga chenda bhitor pora paar kori kene ghusa to he asan hobo.” ");
INSERT INTO nag_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jitia chela khan etu hunise, taikhan bisi asurit hoise, eneka koi kene, “Tinehoile kunkhan he bachibo?” ");
INSERT INTO nag_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kintu Jisu taikhan ke saise aru koise, “Manu khan nimite etu napara kaam ase, kintu Isor nimite sob pare.” ");
INSERT INTO nag_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Etu pichete Peter jowab dikene Taike koise, “Sabi, amikhan sob chari kene Apuni laga piche korise. Amikhan nimite ki thakibo?” ");
INSERT INTO nag_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisu taikhan ke koise, “Moi hosa pora tumikhan ke koi ase, notun jamana te jitia Manu laga Putro pora Tai laga singhason te bohibo, tumikhan jun Ami laga piche korise, tumikhan bhi baroh ta singhason te bohibo, aru Israel desh laga baroh ta jat ke bisar koribo. ");
INSERT INTO nag_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sob manu jun ghor khan, nohoile bhai kokai khan, nohoile didi bhoini khan, nohoile baba, nohoile ama, nohoile bacha khan, nohoile kheti khan, Ami laga naam nimite chari diye koile, taikhan ki chari dise etu pora bhi eksoh bar bisi pabo aru namora jibon to pai lobo. ");
INSERT INTO nag_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kintu bisi manu jun age te ase taikhan piche hoi jabo, aru piche khan age hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sorgo rajyo to ekjon mati malik nisena ase, jun phojurte bahar ulaikene tai laga kheti nimite manu bisari bole jaise. ");
INSERT INTO nag_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jitia tai kaam kora manu khan logote ek dinte ek denarius pora kotha milai loi, tai kaam kora manu khan ke kheti te pathaise. ");
INSERT INTO nag_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Aru tai nou baji nisena te bahar te jaise, aru dusra hajira kora manu khan eku kaam napai kene ene khara thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aru taikhan ke koise, ‘Tumikhan bhi angur bagan te jabi, aru ki thik ase ami tumikhan ke dibo.’ ");
INSERT INTO nag_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aru taikhan jaise. Arubi tai baroh baji nisena te bahar te jaise aru eneka he korise. ");
INSERT INTO nag_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aru tin baji nisena te tai bahar te jaise, aru dusra khan ke ene khara thaka dikhise, aru taikhan ke koise, ‘Tumikhan pura din kele yate ene khara ase?’ ");
INSERT INTO nag_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Taikhan taike koise, ‘Kilekoile kun manu bhi amikhan ke hajira te luwa nai.’ Taike koise, ‘Tumikhan bhi angur bagan te jabi.’ ");
INSERT INTO nag_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Eneka para jitia saam hoise, angur bagan laga malik pora imandar ke koise, ‘Hajira kora khan ke mati bhi, aru taikhan laga hajira dibi, pichete aha pora prothom ula tak.’ ");
INSERT INTO nag_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aru jitia taikhan ahise jun khan ke pans baji nisena te hajira te rakhise, taikhan ke ekta poisa dise. ");
INSERT INTO nag_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hoile sobse poila ahikena kaam kora khan bhabise taikhan bisi pabo; kintu taikhan bhi ek taka he paise. ");
INSERT INTO nag_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aru taikhan ghor laga malik ke biya paikena kiba kibi kobole lagise. ");
INSERT INTO nag_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Koise, ‘eitu khan pichete ahikena ek-ghanta he kaam korise, hoile bhi apuni taikhan ke bhi amikhan nisena he korise, jun khan sob kaam korise aru din laga gorom loise.’ ");
INSERT INTO nag_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hoile bhi tai taikhan bhitor te ekjon ke jowab dise, aru koise, ‘Sathi, Ami tumikhan ke eku bhi golti kora nai: tumi ami logote ek poisa te monjur hoise nohoi? ");
INSERT INTO nag_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tumi laga ki ase lobi, aru nijor rasta jabi: Ami piche aha khan ke bhi iman he dibo, jiman tumikhan ke dibo. ");
INSERT INTO nag_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na ami laga ki ase etu pora ami khushi koribo na paribo naki? Na tumi suku juli ase, kele koile ami bhal ase?’ ");
INSERT INTO nag_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Eneka pora piche khan poila hobo, aru poila piche hobo: kele koile bisi ke matise, hoile bhi olop ke he bisarise.” ");
INSERT INTO nag_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aru Jisu Jerusalem te jai thaka homoi te rasta te Tai laga baroh ta chela khan ke alag pora loise aru taikhan ke koise, ");
INSERT INTO nag_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Sabi, Amikhan Jerusalem te jai ase: aru Manu laga Putro ke mukhyo purohit khan laga hathte aru niyom likha khan laga hathte di dibo. Aru taikhan Taike mora bole laga faisla hunai dibo, ");
INSERT INTO nag_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","aru Taike sorom dikena mora bole, aru Cross te mari dibole nimite Porjati khan laga hathte di dibo: aru tisra dinte Tai aru bhi jee uthibo.” ");
INSERT INTO nag_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Etu pichete, Zebedee laga maiki aru tai duijon laga chokra khan Jisu usorte ahise, aru matha niche kori kene Jisu ke ekta kiba mangibole ahise. ");
INSERT INTO nag_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aru Tai koise, “Apuni ki mangi ase?” Tai taike koise, “Monjur hobi Apuni laga desh te ami laga etu duita chokra, ekjon Apuni laga dyna phale, aru ekjon Apuni laga baya phale bohibo dibi.” ");
INSERT INTO nag_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hoile bhi Jisu jowab dise aru chokra duijon ke eneka hudise, “Tumikhan nabuje tumikhan ki mangi ase. Tumikhan utu kup pora khabole paribo juntu pora Ami khabole ase, aru eneka baptizma lobole paribo jineka baptizma pora ami baptizma lobole ase?” Taikhan taike koise, “Amikhan paribo.” ");
INSERT INTO nag_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aru Tai taikhan ke koise, “Jineka hoile bhi tumikhan Ami laga kup pora khabole ase, aru eneka baptizma lobole ase jineka baptizma pora Ami baptizma lobole ase: hoile bhi Ami laga dyna aru baya phale bohi bole to Ami dibole laga nohoi, hoile bhi etu taikhan ke dibole ase jun khan nimite Ami laga Pormeshwar Baba pora jaga bonai kene rakhise.” ");
INSERT INTO nag_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aru jitia dos jon chela khan pora etu hunise, taikhan etu duita bhai uporte nije ke dangor banabole kosis kora nimite bisi biya paise. ");
INSERT INTO nag_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hoile bhi Jisu taikhan ke tai usorte matise, aru koise, “Tumikhan jani ase Porjati laga rajakhan taikhan uporte takot cholai thakise, aru taikhan jun khan dangor ase taikhan dusra khan uporte takot cholai thakise. ");
INSERT INTO nag_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Hoilebi tumikhan bhitor te eneka hobole nohoi: hoilebi jun bhi tumikhan bhitor te dangor hobole mon ase, taike tumikhan laga nokor hobole dibi. ");
INSERT INTO nag_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aru tumikhan bhitor te jun pora sobse age hobole mon ase, taike tumikhan laga nokor hobole dibi. ");
INSERT INTO nag_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Thik jineka Manu laga Putro sewa lobole aha nohoi, hoile bhi sewa kori bole ahise, aru bisi nimite tai laga jibon ke daan dibole ahise.” ");
INSERT INTO nag_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aru taikhan jitia Jericho sheher pora ulaise, ekta dangor bhir Tai piche korise. ");
INSERT INTO nag_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aru, rasta kinar te bohi kene thaka duita andha manu, jitia taikhan hunise Jisu ta te pora jai ase, hala kori bole lagise, koise, “Probhu, David laga Putro, amikhan uporte daya koribi.” ");
INSERT INTO nag_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aru bisi manu khan taikhan ke gali kori bole lagise chup thakibi koi kene, kintu taikhan aru bhi bisi jor pora hala kori bole lagise, koise, “Amikhan uporte morom koribi, Oh Probhu, David laga Putro.” ");
INSERT INTO nag_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aru Jisu thik ta te rukhise, aru taikhan ke matise, aru koise, “Tumikhan ki lagi ase juntu ami tumikhan nimite kori bole paribo?” ");
INSERT INTO nag_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Taikhan Taike koise, “Probhu, amikhan laga suku khuli dibi.” ");
INSERT INTO nag_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Etu nimite Jisu taikhan uporte morom lagise, aru taikhan laga sukukhan chuise: aru ekbar te taikhan laga suku pora dikhi bole paise, aru taikhan Tai laga piche korise. ");
INSERT INTO nag_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jitia Jisu aru tai laga chela khan Jerusalem te punchise aru Bethphage te ahise, Oliv Pahar te, titia Jisu duita chela ke pathaise, ");
INSERT INTO nag_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","taikhan ke eneka koi kene, “Tumikhan laga usorte thaka bosti te jabi, aru tumikhan loge-loge ekta gadha aru tai laga puwali ke bandi kene thaka dikhibo. Taikhan ke khuli kene Ami logote anibi. ");
INSERT INTO nag_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jodi kunba manu etu nimite kiba hudise koile, eneka koi dibi, ‘Probhu pora lagi ase,’ aru utu manu pora apnikhan ke eku bhi nakobo.” ");
INSERT INTO nag_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aru juntu kotha bhabobadi khan pora Isor kotha koi disele, eitu khan purah hoise. Tai eneka koise, ");
INSERT INTO nag_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion laga chukri khan ke koi dibi, ‘Sabi, tumi laga Raja tumi logote ahi ase, Nomro hoi kene gadha uporte- Ekta jawan gadha laga puwali uporte.”’ ");
INSERT INTO nag_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Etu pichete chela khan jaise aru jineka Jisu pora koise, thik eneka he korise. ");
INSERT INTO nag_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Taikhan gadha aru tai laga puwali ke loi kene anise aru taikhan laga uporte chador urai dise, aru Jisu taikhan uporte bohise. ");
INSERT INTO nag_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jerusalem te jai thaka somoite, bisi manu khan nijor laga bahar kapra bichai dise, aru kunba khan to ghas laga pata kati kene rasta pura te bichai dise. ");
INSERT INTO nag_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Etu pichete Jisu laga age te aru pichete jai thaka manu khan hala korise, eneka koi kene, “Hosanna David laga Putro ke! Asis te ase jun Probhu laga naam loi kene ahi ase! Hosanna sob pora uporte!” ");
INSERT INTO nag_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jitia Jisu Jerusalem te ahise, pura sheher Taike dikhi kene asurit hoise aru taikhan majote eneka koise, “Etu kun ase?” ");
INSERT INTO nag_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aru manu khan jowab dise, “Etu Jisu ase Galilee laga Nazareth te thaka ekjon bhabobadi.” ");
INSERT INTO nag_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Etu pichete Jisu Jerusalem laga mondoli te jaise. Tai ta te saman bikiri kora aru kini thaka khan sobke khedai dise, aru poisa bodli kora khan laga mez ulta kori dise aru chiriya bikiri kora manu khan ke bahar te khedai dise. ");
INSERT INTO nag_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jisu taikhan ke koise, “Isor kotha te eneka likhi kene ase, ‘Moi laga ghor to Prathana laga ghor koi kene matibo,’ kintu tumikhan etu ke chor laga ghor bonai dise.” ");
INSERT INTO nag_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Etu pichete suku andha aru theng lengra khan Jisu logote girja te jaise, aru Tai taikhan ke bhal kori dise. ");
INSERT INTO nag_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kintu jitia mukhyo purohit aru niyom likha manu khan Jisu laga asurit kaam khan kora, aru bacha khan mondoli bhitor te, “Hosanna David laga Putro ke,” koi kene hala kora hunise, taikhan bisi ghusa hoise. ");
INSERT INTO nag_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Taikhan Jisu ke koise, “Taikhan ki koi ase Apuni huni ase na nai?” Jisu taikhan koise, “Hoi! Kintu tumikhan kitia bhi Isor kotha te purah nai naki, ‘Chutu bacha khan laga mukh pora prosansa kori bole Apuni sikhai dise’?” ");
INSERT INTO nag_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Etu pichete Jisu taikhan ke chari kene Bethany nogor te jaise aru etu rati ta te ghumai se. ");
INSERT INTO nag_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Phojurte jitia Jisu Jerusalem sheher te wapas jaise, Tai bhuk lagi jaise. ");
INSERT INTO nag_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Rasta kinar te ekta dimoru ghas dikhise, Tai ghas usorte jaise aru khali pata khan he dikhise. Tai etu ghas ke koise, “Aji pora tumi laga ghas te kitia bhi phol nadhuribi,” aru loge-loge etu ghas sukhi jaise. ");
INSERT INTO nag_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jitia Tai laga chela khan etu dikhise, taikhan asurit lagi kene taikhan majote hudi thakise, “Kineka kori kene etu ghas phat sukhi jaise?” ");
INSERT INTO nag_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisu taikhan ke jowab dikene koise, “Moi hosa pora koi ase, jodi tumikhan duita mon nohoi kene biswas thakile, khali etu ghas ke kora nisena he nohoi kintu tumikhan ekta pahar ke bhi kobole paribo, ‘Uthi bhi aru samundar te ghusi bhi, aru eneka he hobo. ");
INSERT INTO nag_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jodi tumi biswas kore, tumi prathana te ki mangibo etu pai jabo.” ");
INSERT INTO nag_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jitia Jisu girja ghor te ahi kene sikhai thakise, mukhyo purohit aru girja laga bura manu khan Tai usorte ahise, eneka koi kene, “Ki hisab pora apuni eneka kori ase, aru kun pora apuni ke adhikar dise?” ");
INSERT INTO nag_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisu taikhan ke jowab dikene koise, “Moi bhi tumikhan ke ekta kotha hudibo. Jodi tumikhan etu laga jowab dise koile, Ami bhi tumikhan laga jowab dibo. ");
INSERT INTO nag_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John pora manu khan ke baptizma diya to kun laga adhikar pora dise? Sorgo pora na manu khan pora?” Taikhan nijor majote eneka kotha koise, “Jodi amikhan ‘Sorgo pora’ koile, Tai amikhan ke kobo, ‘To kele tumikhan taike biswas kora nai?’ ");
INSERT INTO nag_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kintu jodi amikhan ‘manu khan pora’ koise koile, etu manu khan pora amikhan ke biya pabo, kele koile taikhan sob John ke ekjon bhabobadi ase koi kene mane.” ");
INSERT INTO nag_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Etu pichete taikhan Jisu ke jowab dikene koise, “Amikhan najane.” Jisu bhi taikhan ke koise, “Ami bhi tumikhan ke Ami kun laga adhikar pora kori ase etu nakobo. ");
INSERT INTO nag_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kintu tumikhan ki bhabe? Ekjon manu laga duita chokra thakise. Tai poila dangor chokra ke koise, ‘Putro, aji jai kene angur laga kheti te kaam koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tai laga chokra pora jowab dikene koise, ‘Moi nakoribo,’ kintu olop somoi pichete tai jai kene kaam korise. ");
INSERT INTO nag_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Etu pichete tai laga dusra chokra ke bhi tineka koise. Kintu tai jowab dikene koise, ‘Moi jabo, malik,’ kintu tai janai. ");
INSERT INTO nag_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Duijon chokra majote kun pora baba laga itcha korise?” Taikhan koise, “Poila chokra pora.” Jisu taikhan ke koise, “Hosa pora Moi koi ase, tumikhan pora bhi poisa utha manu aru bebichari kora khan he poila Isor laga rajyote ghusi bo. ");
INSERT INTO nag_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kele koile John to tumikhan logote dharmikta pora ahise, kintu tumikhan taike biswas kora nai. Kintu poisa utha manu khan aru bebichar kora khan he taike biswas korise. Kintu tumikhan, etu dikhikena bhi, tumikhan mon ghura nai aru taike biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Huni lobi aru dusra dristanto ke. Ta te ekjon manu thakise, ekjon mati malik. Tai angur laga kheti korise, tai bera lagai dise, aru angur ros chipai kene ulabole laga gadda khundi se, aru kheti ke sabole nimite untcha chang ghor bonaise, aru dusra manu khan angur laga kheti koribo nimite bhara dise. Etu pichete tai dusra desh te jai jaise. ");
INSERT INTO nag_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jitia angur kati bole somoi ahise, tai kunba nokorkhan ke pathai kene kheti kora khan ke tai laga kheti laga angur mangi bole pathai. ");
INSERT INTO nag_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kintu jitia utu kheti kora khan nokorkhan ke lok paise, taikhan ekjon nokor ke marise, aru ekjon ke morai dise, aru ekjon ke pathor marikena morai dise. ");
INSERT INTO nag_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Arubi, malik pora dusra nokorkhan ke pathaise, poila patha pora bhi bisi pathai, kintu kheti kora manu khan utu nokorkhan poila te kora nisena etu nokorkhan ke bhi kore. ");
INSERT INTO nag_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Etu pichete, utu malik tai nijor laga chokra ke pathai, eneka koi kene, ‘Taikhan Moi laga chokra ke sonman koribo.’ ");
INSERT INTO nag_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kintu jitia kheti kora manu khan tai laga chokra ke dikhise, kheti kora khan nijor majote koi, ‘Malik hobole thaka to etu ase. Ahibi, amikhan taike morai dibo aru tai laga sompoti laga malik hoi jabo.’ ");
INSERT INTO nag_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eneka hoi kene taikhan pora taike dhori loise, aru angur laga kheti te loi kene morai de. ");
INSERT INTO nag_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Etiya, jitia utu kheti laga malik ahe, Tai pora utu kheti kora manu khan ke ki koribo?” ");
INSERT INTO nag_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Taikhan Jisu ke koise, “Tai utu manu khan ke biya pora khotom kori dibo, aru kheti to dusra khan ke kheti kori bole di dibo, aru taikhan pora Taike kheti kata somoite taikhan laga kheti te ula bostu ani dibo.” ");
INSERT INTO nag_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisu taikhan ke koise, “Tumikhan kitia bhi Isor kotha pura nai, ‘Ekta pathor junke ghor bona manu pora phelai diye, Etu pathor he sob ghor laga asol pathor hoijai. Etu to Isor pora he ase, Aru etu to amikhan laga suku te ekdom bhal ase?’ ");
INSERT INTO nag_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Etu karone Ami tumikhan ke koi ase, tumikhan logot pora Isor laga rajyo to loijabo aru utu desh ke di dibo jun bhal phol dhure. ");
INSERT INTO nag_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jun khan etu pathor uporte giri bo tai bhangi kene mihin hoi jabo. Kintu jun manu uporte etu giri bo, taike chipai dibo.” ");
INSERT INTO nag_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jitia mukhyo purohit aru Pharisee khan Tai laga dristanto hunise, taikhan bujhi jaise Tai taikhan laga kotha kori ase koi kene. ");
INSERT INTO nag_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Taikhan Jisu ke dhori bole bisari thakise, kintu taikhan manu khan ke bhoi khai thakise, kele koile manu khan Jisu ke ekjon bhabobadi ase koi kene mani thakise. ");
INSERT INTO nag_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisu jowab dise aru taikhan ke dristanto pora kotha korise, eneka koi kene, ");
INSERT INTO nag_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sorgo laga rajyo eneka ase jineka ekjon raja pora tai chokra laga shadi nimite kha luwa khan taiyar korise. ");
INSERT INTO nag_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Raja pora nokorkhan ke pathaikena shadi te mata manu khan ke bisari bole dise, kintu kunbi ahibole mon thaka nai. ");
INSERT INTO nag_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Aru bhi raja pora tai laga dusra nokorkhan ke eneka koi kene pathaise, ‘Jai kene shadi te mata manu khan ke kobi, “Sabi, Ami pora kha luwa bonai kene ase. Moi laga bhal guru aru mosto saguli khan ke morai dise, aru sob to taiyar hoi kene ase. Shadi laga kha luwa kori bole ahibi.’” ");
INSERT INTO nag_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kintu taikhan mon diya nai aru jai jaise, kunba kheti kori bole, aru kunba nijor dukan te jai jaise. ");
INSERT INTO nag_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aru kunba to raja laga nokorkhan ke dhori loise, aru sorom dibole laga kaam korise, aru morai dise. ");
INSERT INTO nag_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Raja bisi khong uthise, aru tai laga sipahi khan ke pathaise aru tai laga nokor ke morai diya manu khan ke morai dise aru taikhan laga sheher ke julai dise. ");
INSERT INTO nag_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Etu pichete tai laga nokorkhan ke koise, ‘Shadi laga kha luwa taiyar hoise, kintu jun manu khan ke matise, taikhan shadi te ahibole thik nohoi. ");
INSERT INTO nag_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Etu nimite rasta khan te jabi aru tumikhan junke lok pai taikhan sobke shadi laga bhat khabole mati bhi.’ ");
INSERT INTO nag_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Etu pichete raja laga nokorkhan rasta khan te jaise aru jiman bhal aru biya manu khan ke lok paise, taikhan sobke joma kori kene anise, aru shadi laga ghor te manu khan pora bhorta hoise. ");
INSERT INTO nag_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kintu jitia raja ahikena manu khan ke saise, tai ekjon manu ke shadi laga kapra napindi kene thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aru raja pora taike koise, ‘Sathi, tumi shadi laga kapra napindi kene kineka yate ahise?’ Kintu etu manu eku bhi kobole para nai. ");
INSERT INTO nag_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Etu pichete raja pora tai laga nokorkhan ke koise, ‘Etu manu laga theng aru hath bandhi bhi, aru andhera jagate phelai dibi, juntu jagate tai khali kandi thakibo aru daat kamuri thakibo.’ ");
INSERT INTO nag_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bisi manu khan ke mati sele, kintu khali kunba khan ke he basi loise.” ");
INSERT INTO nag_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Etu pichete kunba Pharisee khan jaise aru Jisu ke Tai nijor laga kotha pora phasai dibole taikhan kotha kori thakise. ");
INSERT INTO nag_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Etu pichete taikhan laga chela aru Herod laga manu khan ke milai kene Jisu logote pathaise. Taikhan koise, “Shika manu, amikhan jane Apuni to hosa ase, aru Apuni Isor laga hosa rasta pora sikhai diye. Kun laga kotha bhi apuni hisab nakore, kele koile Apuni to manu laga chehera nasai. ");
INSERT INTO nag_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tinehoile amikhan ke kobi, Apuni ki bhabe? Caesar ke poisa diya to thik niyom ase na nai?” ");
INSERT INTO nag_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kintu Jisu taikhan laga biya chal jani jaise aru koise, “Tumi kopoti khan kele Moike porikha kori ase? ");
INSERT INTO nag_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Amike kar diya laga chandi poisa to dikha bhi.” Etu pichete taikhan ekta chandi poisa anikena Jisu ke dise. ");
INSERT INTO nag_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jisu taikhan ke dikhai kene koise, “Etu kun laga noksa aru naam ase?” ");
INSERT INTO nag_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Taikhan Jisu ke koise, “Caesar laga.” Etu pichete Jisu taikhan ke koise, “Tinehoile ki to Caesar laga ase etu taike dibi, aru ki to Isor laga ase eitu khan Isor ke dibi.” ");
INSERT INTO nag_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jitia taikhan etu hunise, taikhan asurit hoise. Etu pichete taikhan Jisu ke chari kene jaise. ");
INSERT INTO nag_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Eke dinte kunba Sadducee khan, jun khan punoruthan te biswas nakore, taikhan Jisu usorte ahise. Taikhan Jisu ke eneka hudise, ");
INSERT INTO nag_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Shika manu, Moses pora koise, ‘Jodi kunba manu bacha nathaki kene mori jai, tai laga bhai to tai laga maiki ke shadi koribo lage aru tai laga kokai nimite bacha jonom dibo lage.’ ");
INSERT INTO nag_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Etiya, taikhan majote satta bhai kokai khan thakise. Poila, dangor kokai shadi korise aru mori jaise. Bacha nathaka karone, etu maiki ke mora manu laga dusra bhai nimite rakhidise. ");
INSERT INTO nag_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Etu pichete dusra bhai bhi eneka he korise, aru dusra bhai bhi, eneka kori kene pura sat-ta bhai koikai shadi korise. ");
INSERT INTO nag_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sob bhai kokai khan morija pichete, utu maiki bhi mori jai. ");
INSERT INTO nag_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Etiya, mori kene jinda huwa dinte, sat-ta bhai kokai majote, tai kun laga maiki hobo? Kilekoile taikhan sob etu maiki ke shadi kori sele.” ");
INSERT INTO nag_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kintu Jisu taikhan ke jowab dikene koise, “Tumikhan golti ase, kelemane tumikhan shastro najane aru Isor laga hokti bhi najane. ");
INSERT INTO nag_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kilekoile mori kene jinda huwa manu khan shadi nakore aru shadi nimite nadiye. Hoilebi, taikhan duth khan nisena sorgote thake. ");
INSERT INTO nag_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kintu, mori kene jee utha laga kotha to, tumikhan Isor laga kotha koi diya te pura nai naki, eneka koi kene thaka, ");
INSERT INTO nag_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Moi Abraham, Isaac, aru Jacob laga Isor ase?’ Isor to mora manu khan laga Isor nohoi, kintu jinda manu khan laga Isor ase.” ");
INSERT INTO nag_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jitia joma hoi kene thaka manu khan Jisu laga sikhai diya kotha hunise, taikhan asurit hoise. ");
INSERT INTO nag_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kintu jitia Pharisee khan Jisu pora Sadducee khan laga mukh chup kori diya hunise, taikhan eke logote mili kene joma hoise. ");
INSERT INTO nag_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Taikhan majote, ekjon ukil, Jisu ke porikha kori bole ekta kotha hudise- ");
INSERT INTO nag_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Shika manu, sob niyom laga majote, kuntu niyom he sob pora dangor ase?” ");
INSERT INTO nag_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisu koise, “‘Tumi laga Isor ke pura mon pora, aru pura atma, aru pura bhabona pora morom koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Etu he sob pora dangor aru poila niyom ase. ");
INSERT INTO nag_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aru dusra niyom to eneka ase- ‘Nijorke morom kora nisena tumi laga ghor usor manu khan ke bhi morom koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jiman niyom aru bhabobadi khan laga kotha khan ase, etu duita niyom uporte khara ase.” ");
INSERT INTO nag_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Etiya, jitia Pharisee khan sob joma hoi kene thaka somoite, Jisu taikhan ke ekta kotha hudise. ");
INSERT INTO nag_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Tai koise, “Tumikhan Khrista ke ki bhabe? Tai kun laga Putro ase?” Taikhan koise, “David laga Putro.” ");
INSERT INTO nag_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisu taikhan ke koise, “Tinehoile kineka kori kene David to atma te Taike probhu koi kene mate, eneka koi kene, ");
INSERT INTO nag_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Isor pora moi laga Probhu ke koise, “Moi laga dyna hathte bohibi, Jitia tak Moi tumi laga dushman khan ke tumi laga theng nichete na ane’”? ");
INSERT INTO nag_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jodi David pora Khrista ke ‘Probhu’ matise, tinehoile kineka Tai David laga chokra hobo?” ");
INSERT INTO nag_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kun bhi Jisu ke ekta jowab bhi dibole para nai, aru utu din pora kun bhi Taike ekta kotha bhi nahuda hoise. ");
INSERT INTO nag_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Etu pichete Jisu tai laga chela aru joma hoi kene thaka manu khan ke kotha korise. ");
INSERT INTO nag_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Tai koise, “Niom likha khan aru Pharisee khan Moses boha jagate bohe. ");
INSERT INTO nag_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Etu karone taikhan ki hukum diye tumikhan etu koribi, aru sai thakibi. Kintu taikhan laga kaam hisab te na koribi, kele koile taikhan mukh pora koi, hoile bhi kaam pora nakore. ");
INSERT INTO nag_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Taikhan juntu saman bhari hoi eitu khan bandhi diye aru bukhi bole digdar hoijai, aru manu khan laga kandha te rakhi diye. Kintu taikhan nijor laga anguli bhi uthabole itcha nakore. ");
INSERT INTO nag_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Taikhan dikha bole nimite he bhal niyom khan kore. Kilekoile taikhan matha te chamra laga boksa dangor bonai kene bandhe, aru taikhan kapra laga rusi khan dangor kore. ");
INSERT INTO nag_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Taikhan bisi sonman pa-a jagate kha luwa kora khushi pai, aru mondoli te bisi sonman pa jagate bohe. ");
INSERT INTO nag_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aru bajar te taikhan ke ekdom salam diya aru ‘Rabbi’ koi kene manu khan pora mata khushi pai. ");
INSERT INTO nag_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kintu tumikhan ke ‘Rabbi’ koi kene matibo dibo nalage kele koile khali ekjon he Shika manu ase, aru tumikhan sob bhai kokai ase. ");
INSERT INTO nag_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aru tumikhan ke ‘Baba’ koi kene matibo nadibi, kele koile tumikhan laga khali ekjon he Baba Isor ase, jun sorgote ase. ");
INSERT INTO nag_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tumikhan ke ‘Shika manu’ koi matibo nadibi, kele koile tumikhan laga hikhok to Khrista he ase. ");
INSERT INTO nag_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kintu tumikhan majote kun bisi dangor ase tai to tumi laga nokor hobo. ");
INSERT INTO nag_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jun khan nijorke uthai thake taike nomro kori dibo, aru jun khan nijorke nomro koribo taike uthai dibo. ");
INSERT INTO nag_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kintu, O niyom likha khan aru Pharisee khan, tumi kopoti khan ke hai ase! Tumikhan dusra manu khan nimite sorgo rajyo bondh kori diye. Kilekoile tumikhan nijor naghuse, aru ghusi bole thaka dusra khan ke bhi ghusi bole nadiye. ");
INSERT INTO nag_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O niyom likha khan aru Pharisee khan, tumi kopoti khan ke hai ase! Kilekoile tumikhan bidhowa khan ke thogai kene taikhan laga ghor chingi loi. Etu pichete girja te jai kene manu khan ke dikha bole lamba prathana kore. Tumikhan uporte sobse biya sajai hobo. ");
INSERT INTO nag_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","O niyom likha khan aru Pharisee khan, tumi kopoti khan ke hai ase! Kilekoile tumikhan samundar pora aru dusra desh khan te jai kene tumikhan laga dhorom mani bole mon ghura bo diye, aru jitia tai tumikhan laga niyom to mani loi, tumikhan taike poila pora bhi aru bisi norok laga bacha bonai de. ");
INSERT INTO nag_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Tumikhan ke hai ase, tumikhan andha hoi kene rasta dikhai thaka khan, tumikhan jun koi, ‘Jun manu mondoli laga naam loi kene kosom khai, etu eku nohoi. Kintu jun manu mondoli laga suna chandi laga naam loi kene kosom khai, tai etu kosom rakhibo lage.’ ");
INSERT INTO nag_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tumi murkho aru andha manu khan! Kuntu sob pora dangor ase, suna chandi na utu mondoli jun pora suna chandi khan ke pobitro bonai? ");
INSERT INTO nag_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aru, ‘Jun manu bedi laga kosom khai, etu eku nohoi. Kintu jun manu Isor laga bedi te daan thaka laga kosom khai, tai etu kosom manibo lagibo.’ ");
INSERT INTO nag_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","O Tumikhan murkho aru andha manu khan! Kuntu sob pora dangor ase, utu daan khan na Isor laga bedi jun pora etu daan ke pobitro bonai diye? ");
INSERT INTO nag_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Etu karone, jun manu Isor laga bedi laga kosom khai, tai etu aru etu logote thaka sob saman khan laga kosom khai loi. ");
INSERT INTO nag_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jun ekjon mondoli laga kosom khai, tai etu mondoli aru mondoli ghor te thaka Isor laga kosom khai loi. ");
INSERT INTO nag_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aru jun sorgo laga kosom khai, tai Isor laga singhason aru Tai usorte boha khan sob laga kosom khai loi. ");
INSERT INTO nag_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","O niyom likha khan aru Pharisee khan, tumi kopoti khan ke hai ase! Kilekoile tumikhan pudina, aru pata, aru dhaniya laga dos bhag di thake, aru bisi ujon thaka niyom, faisla, maph, aru biswas laga kotha khan ke chari diye- eitu khan bhi kori bole laga asele, hoilebi dusra khan bhi nakorikena nacharibo lage. ");
INSERT INTO nag_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tumikhan andha cholawta khan, jun khan makhi dikhile ghin lage, aru ekta uth-janwar ke khai loi. ");
INSERT INTO nag_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","O niyom likha khan aru Pharisee khan, tumi kopoti khan ke hai ase! Kilekoile tumikhan kup aru thali laga bahar phale sapha kori thake, hoile bhi bhitor te to joborjosti pora luwa aru lalchi pora bhorta ase. ");
INSERT INTO nag_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tumi andha Pharisee, poila kup aru thali laga bhitor te ki ase etu ke sapha koribi, titia eitu khan laga bahar khan bhi nijor pora sapha hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","O niyom likha khan aru Pharisee khan, tumi kopoti khan ke hai ase! Kilekoile tumikhan chuna mara pathor laga kobor nisena ase, juntu bahar pora sundur dikhe, hoile bhi bhitor te mora manu khan laga hardi khan, aru sob moila khan pora bhorta ase. ");
INSERT INTO nag_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Thik eneka nisena tumikhan bhi bahar pora manu khan usorte hosa te thaka nisena dikhe, hoilebi bhitor te misa misi aru paap pora bhorta ase. ");
INSERT INTO nag_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","O niyom likha khan aru Pharisee khan, tumi kopoti khan ke hai ase! Kilekoile tumikhan utu bhabobadi khan laga kobor khan bonaise, aru utu dharmikta te thaka manu khan laga pathor laga kobor ke sundur pora korise, ");
INSERT INTO nag_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aru koise, ‘Amikhan baba laga baba khan laga homoi te amikhan thakise koile, amikhan etu bhabobadi khan laga khun phelai diya te bhag nolobole thakise.’ ");
INSERT INTO nag_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eneka pora tumikhan nije pora he koi ase tumikhan taikhan laga bacha khan ase jun khan pora bhabobadi khan ke morai dise. ");
INSERT INTO nag_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Etu nimite tumikhan baba laga baba khan laga hisab ke tumikhan bhorta koribi. ");
INSERT INTO nag_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tumikhan saph khan, saph laga khandan khan, kineka pora tumikhan norok laga sajai pora polabole paribo? ");
INSERT INTO nag_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Etu nimite, sabi, Ami tumikhan ke bhabobadi aru gyaani aru niyom likha khan ke pathai ase. Kunba khan ke tumikhan pora morai dibo aru Cross uporte maribo, aru kunba khan ke tumikhan Isor laga kotha kora ghor te tumikhan pora chabuk pora maribo aru ekta sheher pora dusra sheher laga bahar te khedai dibo. ");
INSERT INTO nag_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eneka pora tumikhan uporte prithibi te jiman hosa te thaka khan ase taikhan laga khun ahibo, hosa te thaka Abel laga khun pora shuru kori kene Barachias laga chokra Zacharias laga khun tak, junke tumikhan pobitro jaga aru bedi majot te morai disele. ");
INSERT INTO nag_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hosa pora ami tumikhan ke koidi ase, eitu khan sob aji-kali laga yug uporte ahibo. ");
INSERT INTO nag_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalem, Jerusalem, tumi jun khan bhabobadi khan ke morai diye aru jun khan ke tumikhan logot pathai diye taikhan ke bhi tumikhan pathor mari dise! Kiman bar Moi tumi laga bacha khan ke milai dibole itcha thakise, jineka ekta murgi ama tai laga bacha khan ke tai laga pakhi nichete joma kore, kintu tumikhan ahibole itcha thaka nai! ");
INSERT INTO nag_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sabi, tumikhan laga ghor pora tumikhan ke ekla chari dibo. ");
INSERT INTO nag_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kilekoile Moi tumikhan ke koi ase, etiya pora tumikhan Amike nadikhibo jitia tak tumikhan eneka nakoi, ‘Tai asis te ase jun Probhu laga naam pora ahise.’” ");
INSERT INTO nag_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisu mondoli laga bahar te ulaikene nijor rasta te jai thakise. Tai laga chela khan Tai usorte ahikena mondoli ghor dikhai thakise. ");
INSERT INTO nag_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kintu Tai jowab dise aru taikhan ke koise, “Tumikhan etu sob dikhi ase na nai? Moi hosa pora koi ase, etu sob pathor khan matite phelai dibo. Ekta pathor bhi ekta uporte thakibo nadibo, sobke bhangai kene girai dibo.” ");
INSERT INTO nag_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jitia Tai Oliv Pahar te bohi thakise, Tai laga chela khan lukai kene ahise, eneka koi kene, “Amikhan ke kobi, eitu khan kitia hobole ase? Apuni aru ahibole thaka aru etu duniya laga somoi khotom hobole laga din to, kineka pora amikhan ke dikhai dibo?” ");
INSERT INTO nag_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisu jowab dise, “Hoshiar thakibi, kun pora bhi tumikhan ke thogabole nadibi. ");
INSERT INTO nag_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kilekoile bisi manu ami laga naam loi kene ahibo. Taikhan kobo, ‘Moi Khrista ase,’ aru bisi manu khan ke thogai dibo. ");
INSERT INTO nag_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tumikhan larai kora aru larai hobole thaka laga khobor hunibo. Hoilebi tumikhan chinta na koribi, kele koile prithibi khotom nohua age te eitu khan sob purah hobo lage. ");
INSERT INTO nag_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ekta desh pora dusra desh ke bhirodh koribo, aru ekta rajyo pora dusra rajyo ke hinsa koribo. Utu somoite bisi jagate khabole nathakibo aru mati khan bisi hili bo. ");
INSERT INTO nag_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kintu eitu khan sob to bacha jonom hobole nimite bikhabole shuru huwa he ase. ");
INSERT INTO nag_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Etu pichete tumikhan ke taikhan pora saja dibo aru morai dibo. Tumikhan ke sob desh khan pora Ami laga naam nimite ghin koribo. ");
INSERT INTO nag_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Etu pichete bisi manu laga biswas harai jabo, aru ekjon-ekjon ke thogabo aru ghin koribo. ");
INSERT INTO nag_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Misa bhabobadi khan bisi ulabo aru bisi manu ke thogai dibo. ");
INSERT INTO nag_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kilekoile niyom namana khan bisi hoi jabo, aru bisi manu laga morom to thanda hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kintu jun hekh tak biswas te thakibo, taikhan he bachibo. ");
INSERT INTO nag_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Etu sorgo rajyo laga bhal khobor to pura prithibi te ekta gawahi hoi kene pura desh te prochar koribo. Etu pichete hekh din to ahibo. ");
INSERT INTO nag_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Etu karone, jitia tumikhan ghin laga kaam pora khotom kori diya dikhibo, juntu kotha bhabobadi Daniel pora koi disele, tumikhan pobitro jagate khara kori kene dikhibo”- kun puri ase tai bujhi lobi,- ");
INSERT INTO nag_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Etu pichete jun khan Judea te ase taikhan ke pahar uporte polabole dibi, ");
INSERT INTO nag_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","jun manu ghor uporte ase, taike ghor laga saman khan lobole nichete jabole nadibi, ");
INSERT INTO nag_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","aru jun kheti te ase taike ghor te jai kene chador lobole nadibi. ");
INSERT INTO nag_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kintu, utu dinte jun khan pet te bacha nohoile bhi dudh khai thaka bacha khan logote ase, taikhan bisi dukh pabo! ");
INSERT INTO nag_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Prathana koribi eneka to thanda din nohoile Bisram dinte eitu khan nahobole nimite. ");
INSERT INTO nag_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Etu pichete dangor dukh digdar din ahijabo, etu somoite kitia bhi napa laga dukh khan pabo, aru etu nisena dukh kitia bhi aru nahibo. ");
INSERT INTO nag_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jitia tak utu din khotom nahobo, ekjon manu bhi nabachibo. Kintu basi luwa manu khan laga prathana pora he etu dukh din khan ke khata kori dibo. ");
INSERT INTO nag_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Etu pichete jodi kunba pora tumike koi, ‘Sabi, Khrista yate ase!’ Nohoile bhi, ‘Tai ta te ase!’ Taikhan ke biswas na koribi. ");
INSERT INTO nag_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kile mane misa Khrista aru misa bhabobadi khan ahibo aru asurit kaam khan kori kene dikha bo, tumikhan ke thogabo, parile Isor pora basi kene thaka khan ke bhi. ");
INSERT INTO nag_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sabi, Ami tumikhan ke etiya pora he eitu khan koi dise. ");
INSERT INTO nag_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Etu karone, jodi taikhan pora tumikhan ke koi, ‘Sabi, Tai eku bhi nathaka jagate ase,’ eneka jagate najabi. Nohoile bhi, ‘Sabi, Tai ghor bhitor te ase,’ eneka khan biswas na koribi. ");
INSERT INTO nag_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kilekoile jineka bhijili purab pora ujala hoi aru phat kori kene paschim tak jule, thik etu nisena Manu laga Putro bhi eneka ahibo. ");
INSERT INTO nag_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Juntu jagate janwar khan mori kene thake, etu jagate mangso kha chiriya khan joma hoi. ");
INSERT INTO nag_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kintu loge-loge dukh digdar din khan pichete, suryo to andhera hoi jabo, aru chand to ujala nadiya hoi jabo, aru tara khan akas pora giri jabo, aru sorgo laga hokti to hili jabo. ");
INSERT INTO nag_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Etu pichete Manu laga Putro aha din laga chihna akas te dikhai dibo, aru sob prithibi laga jati khan kandibo. Taikhan Manu laga Putro ke purah hokti aru dangor mohima pora akas laga badal te aha dikhibo. ");
INSERT INTO nag_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tai pora Tai laga sorgodoth khan ke dangor bajana pora awaj kori kene prithibi te pathabo, aru taikhan Isor pora basi luwa manu khan ke prithibi laga char kona pora joma kori lobo. ");
INSERT INTO nag_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Etu dristanto to dimoru laga ghas pora sikhi lo bhi. Jitia tai laga daal khan norom hoijai aru notun pata khan ulai ahe, titia tumikhan jani jai gorom din ahi ase. ");
INSERT INTO nag_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Thik eneka, jitia eitu khan dikhibo, tumikhan jani jabi Manu laga Putro to dorja usorte punchi ase. ");
INSERT INTO nag_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Moi hosa pora tumikhan ke koi ase, etu yug khotom nohobo jitia tak eitu khan sob pura hoi najai. ");
INSERT INTO nag_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Akas aru prithibi to harai jabo, kintu Moi laga ekta chutu kotha bhi naharabo. ");
INSERT INTO nag_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kintu kitia utu din aru somoi ahibo, kun bhi najane, sorgodoth khan bhi najane, nohoile Putro bhi najane, khali Baba ekla he jane. ");
INSERT INTO nag_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kineka Noah laga dinte hoise etu nisena Manu laga Putro aha din bhi eneka hobo. ");
INSERT INTO nag_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kilekoile utu somoite bhi, Noah pora naw bhitor te naghusa din tak, manu khan nisa-pani khai thakise, shadi kori thakise aru shadi koridi thakise, ");
INSERT INTO nag_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","aru taikhan eku jani kene thaka nai aru jitia ban-pani ahise, taikhan sobke pani pora loi jaise- etu nisena Manu laga Putro aha din bhi etu nisena ahibo. ");
INSERT INTO nag_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Etu pichete duijon manu kheti te thakibo- ekjon ke loijabo, aru ekjon ke chari dibo. ");
INSERT INTO nag_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duijon maiki mil te chawal khundi thakibo- ekjon ke loijabo, aru ekjon ke chari dibo. ");
INSERT INTO nag_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Etu karone nijor jagate taiyar hoi kene thakibi, kele koile tumi najane kuntu dinte tumi laga Probhu ahibo. ");
INSERT INTO nag_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kintu etu jani kene thakibi, jodi ghor laga malik to kuntu somoite chor ahibo etu jani thakile, tai to taiyar hoi kene thaki bole asele aru etu chor ke tai laga ghor bhitor te ghusi bole nadibo thakise. ");
INSERT INTO nag_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Etu karone tumikhan bhi taiyar thakibi, kele koile Manu laga Putro to tumikhan nabhaba somoite ahibo. ");
INSERT INTO nag_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Etu nimite, kun sob pora thik aru gyaan thaka nokor ase, junke tai laga malik pora biswas rakhi kene tai kha luwa thik somoite dibole aru ghor laga kaam sabole nimite rakhikena ase? ");
INSERT INTO nag_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Utu nokor asis pabo jitia tai laga malik ahikena taike kaam kori thaka dikhibo. ");
INSERT INTO nag_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Hosa pora Moi tumikhan ke koi ase utu malik pora Tai laga ki ase etu sob utu nokor laga jimedari te rakhidibo. ");
INSERT INTO nag_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kintu jodi etu biya nokor mon bhitor te koi, ‘Moi laga malik to deri pora ahibo,’ ");
INSERT INTO nag_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aru tai dusra nokorkhan ke mari bole shuru hoijai, aru modhu kha manu khan logote mili kene nisa-pani khai, ");
INSERT INTO nag_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","aru tai nabhaba aru najana somoite tai laga malik ahijai. ");
INSERT INTO nag_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Etu pichete tai laga malik taike saja dibo aru dhongi manu khan logote rakhidibo, aru ta te khali kanda aru daat kamura he hobo. ");
INSERT INTO nag_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Aru, etu somoite, sorgo laga rajyo to dosta chukri nisena ase jun taikhan laga saaki loi kene taikhan laga mota hobole thaka khan ke lok kori bole jaise. ");
INSERT INTO nag_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pans jon to murkho thakise aru pans jon to gyaani thakise. ");
INSERT INTO nag_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kilekoile utu pansta chukri taikhan laga saaki to loise, kintu taikhan tel lobole borton to pahori jaise. ");
INSERT INTO nag_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hoilebi utu pansta gyaani chukri khan to borton te tel hali kene taikhan logot saaki bhi loi jaise. ");
INSERT INTO nag_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jitia taikhan logot shadi kori bole thaka mota ahibole deri hoise, taikhan sob neendh lagi kene ghumai jaise. ");
INSERT INTO nag_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kintu rati laga majote ta te ekta awaj hunise, ‘Sabi, shadi koribo thaka mota ahise! Jabi aru taikhan ke lok koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Etu pichete chukri khan sob uthi kene taikhan laga sakhi julai se. ");
INSERT INTO nag_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kintu murkho chukri khan gyaani chukri khan ke koise, ‘Amikhan ke apnikhan laga tel olop dibi kelemane amikhan laga saaki to bhuti jabole ase,’ ");
INSERT INTO nag_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kintu utu gyaani chukri khan jowab dikene koise, ‘Amikhan aru apnikhan nimite bhi napuncha hoi jabo, etu pora to jai kene tel bikiri kora manu pora nijor nimite kini lobi.’ ");
INSERT INTO nag_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jitia taikhan kini bole jaise, shadi kora mota khan punchi kene ghor bhitor te jaise, aru jun khan taiyar thakise taikhan logote shadi kori bole jaise, aru dorja bondh kori dise. ");
INSERT INTO nag_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Etu pichete utu murkho chukri khan ahi kene koise, ‘Malik, malik, amikhan nimite bhi dorja khuli bhi.’ ");
INSERT INTO nag_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kintu tai jowab dikene koise, ‘Hosa pora Moi tumikhan ke koi ase, Moi tumikhan ke najane.’ ");
INSERT INTO nag_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Etu karone saikene thakibi, kele koile kuntu din nohoile bhi kuntu somoite Manu laga Putro wapas ahibo tumikhan najane. ");
INSERT INTO nag_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kile mane etu to ekjon manu safar te jai thaka nisena ase. Tai nijor laga nokorkhan ke matise aru taikhan ke Tai laga dhun khan dise. ");
INSERT INTO nag_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ekjon ke pansta talents dise, dusra ke duita talents dise, aru ekjon dusra ke ekta talent dise. Tai sobke taikhan laga kaam hisab te dise, aru joldi kori kene taikhan laga safar nimite ulai jai. ");
INSERT INTO nag_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jun manu ke pansta bordan disele tai jai kene kaam te cholai se aru tai aru bhi pansta bordan bisi paise. ");
INSERT INTO nag_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Etu nisena junke duita bordan disele tai bhi duita bordan aru bhi paise. ");
INSERT INTO nag_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kintu juntu nokor ke ekta bordan disele, tai jai kene mati khundi kene malik pora diya poisa to rupai dise. ");
INSERT INTO nag_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Etiya, bisi din pichete nokorkhan laga malik to wapas ahe aru taikhan ke bordan diya laga hisab khan mange. ");
INSERT INTO nag_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pansta bordan pa-a nokor ahi kene aru bhi pansta bordan bisi kori kene tai laga malik ke dise. Tai koise, ‘Malik, apuni amike pansta bordan dise. Kintu sabi, moi etu dui guna bisi kori dise.’ ");
INSERT INTO nag_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tai laga malik taike koise, ‘Bisi bhal korise, bhal aru imandar nokor! Tumi bisi imandar pora kaam khan korise. Moi tumike sob kaam khan sabole jimedari di ase. Ahibi aru tumi laga malik logote khushi koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Dusra nokor junke duita bordan disele tai ahikena koise, ‘Malik, apuni amike duita bordan dise. Kintu sabi, moi aru duita bisi bordan kori dise.’ ");
INSERT INTO nag_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tai laga malik taike koise, ‘Bisi bhal korise, bhal aru imandar nokor ase! Tumi bisi imandar pora kaam khan korise. Moi tumike sob kaam khan sabole jimedari di ase. Ahibi aru tumi laga malik logot te khushi koribi.’ ");
INSERT INTO nag_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Etu pichete ekta bordan pa-a nokor ahikena koise, ‘Malik, moi jani ase apuni bisi kara manu ase. Apuni juntu jagate bijon naphelai ta te guti khan joma kore, aru juntu jagate kheti nakore ta te kheti kate. ");
INSERT INTO nag_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Moi bhoi khai thakise, etu karone moi jai kene mati bhitor te lukai kene rakhise. Sabi, apuni ki dise etu yate ase.’ ");
INSERT INTO nag_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kintu tai laga malik jowab dikene taike koise, ‘Tumi mon kala aru alsi kora nokor, tumi jani ase, moi juntu jagate bijon naphelai ta te guti khan joma kore, aru juntu jagate kheti nakore ta te kheti kate. ");
INSERT INTO nag_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Etu karone moi laga poisa to poisa ghor te dise koile bhal hobole thakise, aru jitia moi wapas ahibo moi laga poisa logote munafa bhi pabo thakise. ");
INSERT INTO nag_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Etu karone, tai laga hath pora bordan khan loi lobi aru jun logote dosta bordan ase taike di dibi. ");
INSERT INTO nag_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kilekoile jun manu khan bisi ase- taike aru bhi dibo- ekdom bhorta pora aru bhi dibo. Kintu jun manu khan logote eku bhi nai, taikhan logote ki ase eitu khan bhi tai pora chingi loi lobo. ");
INSERT INTO nag_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Etu kaam nathaka nokor ke andhera jagate phelai dibi, juntu jagate khali kandi thaka aru daat kamuri thaka he hobo.’ ");
INSERT INTO nag_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jitia Manu laga Putro tai laga mohima aru pura sorgodoth khan logote ahibo, etu pichete Tai laga mohima laga jagate bohibo. ");
INSERT INTO nag_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tai laga age te sob desh khan joma hobo, aru Tai manu khan ke ekjon pora dusra jonke alag koribo, jineka roikhya pora mer aru saguli ke alag kori diye. ");
INSERT INTO nag_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tai mer khan ke Tai laga dyna hath phale rakhibo aru saguli khan ke baya hath phale rakhibo. ");
INSERT INTO nag_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Etu pichete Raja pora Tai laga dyna hathte thaka manu khan ke koise, ‘Ahibi, Moi laga Baba pora tumikhan ke asis dikene ase, juntu rajyo tumikhan nimite prithibi bona somoite rakhi sele, etu tumikhan laga hoise. ");
INSERT INTO nag_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kilekoile Moi bhuka thakise aru tumikhan Moike khilai se; Moi pyaas lagi thakise aru tumikhan Moike pani khabole dise; ");
INSERT INTO nag_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Moi eku kapra pindhi kene thaka nai aru tumi moike pindhibole dise; Moi bemar aru bondhi ghor te thakise aru tumi moike sabole ahise.’ ");
INSERT INTO nag_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Etu pichete dharmik khan Taike jowab dikene kobo, ‘Probhu, amikhan kitia Apuni bhuk lagi thaka dikhise aru khilai se? Nohoile Apuni pyaas laga homoi te Apuni ke pani dise? ");
INSERT INTO nag_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aru amikhan kitia Apuni ke nachina manu ase koi kene loi jaise? Nohoile bhi kapra pindhibole nathaka dikhi kene kapra pindhai dise? ");
INSERT INTO nag_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aru amikhan kitia Apuni ke bemar ase nohoile bhi bondhi ghor te ase koi kene Apuni usorte ahise? ");
INSERT INTO nag_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Etu pichete Raja pora jowab dikene taikhan ke kobo, ‘Hosa pora Moi tumikhan ke koi ase, ki kaam tumi Moi laga bhai khan nimite korise, tumi Moi nimite he korise.’ ");
INSERT INTO nag_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Etu pichete Tai bhi kobo Tai laga baya hath phale thaka manu khan ke, ‘Moi laga usor pora dur hoi jabi, tumi paap manu khan, khotom nohua jui te jabi juntu jaga biya atma aru tai laga duth khan nimite bonaise, ");
INSERT INTO nag_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kele koile Moi bhuk lagi thakise, kintu tumikhan Moike eku bhi khabole diya nai; Moi pyaas lagi thakise, kintu tumikhan Moike pani bhi khabole diya nai; ");
INSERT INTO nag_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Moi nachina manu thakise, kintu tumikhan Moike mata nai; kapra pindhibole thaka nai, kintu tumikhan Moike kapra pindhi diya nai; bemar aru bondhi ghor te thakise, kintu tumikhan Moike sabole aha nai.’ ");
INSERT INTO nag_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Etu pichete taikhan bhi jowab dikene kobo, ‘Probhu, amikhan kitia Apuni ke bhuka, pyasa, bahar manu, kapra pindhibole nathaka, bemar, bondhi ghor te, eneka kora dikhise aru Apuni ke sewa kora nai? ");
INSERT INTO nag_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Etu pichete Tai jawab dikene kobo, ‘Hosa para Moi tumikhan ke koi ase, ji kaam tumi Moi laga manu khan nimite kora nai tumi Moi nimite bhi kora nai.’ ");
INSERT INTO nag_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Titia Jisu eneka koise, “Eitu khan kitia bhi khotom nohua saja pabo, kintu dharmik khan anonto jibon pabo.” ");
INSERT INTO nag_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jitia Jisu sob kotha khan koi kene khotom korise, Tai chela khan ke koise, ");
INSERT INTO nag_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tumikhan jani kene ase dui din pichete Nistar utsov din ahi ase, aru Manu laga Putro ke Cross te morai dibole di dibo.” ");
INSERT INTO nag_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Etu pichete mukhyo purohit aru bura khan sob ahikena moha purohit Caiaphas laga ghor te eke logote joma hoise. ");
INSERT INTO nag_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Taikhan sob kineka kori kene Jisu ke dhoribo aru chalak pora Taike morai dibo, etu bhabona kori thakise. ");
INSERT INTO nag_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kilekoile taikhan majot te eneka koi thakise, “Utsov laga somoite nohoi, nohoile etu nimite manu khan majote jhagara ulabo pare.” ");
INSERT INTO nag_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jitia Jisu Bethany bosti te ekjon bemar manu Simon koi kene tai laga ghor te thakise, ");
INSERT INTO nag_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","aru Tai mez te bohi thakise, ekjon mahila Jisu usorte bisi daam laga tel ke ekta mati laga kolsi te hali kene anise, aru tai Jisu laga matha te hali dise. ");
INSERT INTO nag_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kintu jitia Jisu laga chela khan etu dikhise, taikhan ghusa hoi kene koise, “Eneka nuksan kora laga motlob to ki ase? ");
INSERT INTO nag_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Eitu ke bisi daam pora bikiri kori kene gorib manu khan ke dibo paribole thakise.” ");
INSERT INTO nag_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kintu Jisu, etu sob jani kene, taikhan ke koise, “Tumikhan kele etu mahila ke digdar di ase? Tai moi nimite bhal kaam kori dise. ");
INSERT INTO nag_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kilekoile tumikhan logote gorib manu khan to hodai thakibo, kintu Moi tumikhan logote hodai nathakibo. ");
INSERT INTO nag_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kitia etu mahila pora Moi laga gaw uporte te tel hali dise, tai Moike kobor te nadhala age te taiyar koridi ase. ");
INSERT INTO nag_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hosa pora Moi tumikhan ke koi ase, jitia etu bhal khobor pura prithibi te prochar hobo, etu mahila pora ki korise tai laga yaad te etu kotha koribo.” ");
INSERT INTO nag_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Etu pichete baroh jon chela majote ekjon chela, Judas Iscariot, tai mukhyo purohit khan logot jaise, ");
INSERT INTO nag_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aru koise, “Apuni khan moike ki dibole itcha kori ase, jodi moi apnikhan nimite Jisu ke thogai diye?” Titia taikhan trista chandi laga sikka ulaikene taike dise. ");
INSERT INTO nag_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aru utu somoi pora Judas to kineka kori kene Jisu ke thogai dibo etu bisari thakise. ");
INSERT INTO nag_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Etiya, khomir nathaka roti laga nakha-a utsov laga poila dinte Jisu laga chela khan eneka koi kene ahise, “Apuni kuntu jagate amikhan Nistar purbb laga khana kori bole nimite jaga taiyar koribo dibo itcha ase?” ");
INSERT INTO nag_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jisu koise, “Sheher te jai kene kunba ekjon manu logote jabi aru taike kobi, ‘Malik pora koise, “Moi laga somoi usor hoi ase. Moi tumi laga ghor te Nistar purbb khana Moi laga chela khan nimite rakhibo.”’” ");
INSERT INTO nag_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aru chela khan eneka he korise aru taikhan Nistar purbb nimite khana taiyar kori loise. ");
INSERT INTO nag_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jitia saam hoise, Jisu tai laga baroh jon chela khan logote khabole bohise. ");
INSERT INTO nag_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aru jitia taikhan khai thakise, Jisu koise, “Hosa pora Moi tumikhan ke koi ase, tumikhan majot te ekjon pora Amike thogai dibo.” ");
INSERT INTO nag_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Taikhan huni kene bisi mon dukh hoise, aru sob chela khan ekjon pichete ekjon eneka hudibole shuru hoise, “Probhu, hosa pora moi nohoi na?” ");
INSERT INTO nag_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisu jowab dikene koise, “Etu ekjon kun Moi logote mili kene ekta thali te khaise, tai pora he Moike thogai dibo. ");
INSERT INTO nag_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Manu laga Putro jabo lagibo, jineka Tai nimite Isor kotha te likhi kene ase. Kintu utu manu ke bisi hai ase jun pora Manu laga Putro ke thogabole ase! Tai nimite to jonom nohua he bhal hobole ase.” ");
INSERT INTO nag_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Etiya Judas, kun Jisu ke thogabole thakise, jowab dikene koise, “Rabbi, hosa pora moi nohoi na? Jisu taike koise, “Tumi nijor pora he koi dise.” ");
INSERT INTO nag_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jitia taikhan khai thakise, Jisu roti loi kene Isor ke asirbad dikena bhangai se. Aru chela khan ke dikene koise, “Lobi, aru khabi. Etu Moi laga gaw ase.” ");
INSERT INTO nag_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Titia, Jisu kup to loise aru Isor ke dhanyavad dise, aru taikhan ke eneka koi kene dise, “Tumikhan sob etu kup pora pi lobi. ");
INSERT INTO nag_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kilekoile etu Moi laga khun dwara vachan ase, etu pora sob manu paap pora khyama pabo. ");
INSERT INTO nag_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kintu Moi tumikhan ke koi ase, Baba laga rajyote Moi etu notun angur phol laga ros tumikhan logot napia tak, etu angur ros to aru napibo.” ");
INSERT INTO nag_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jitia taikhan atma laga gana kori loise, taikhan ulaikene Oliv Pahar te jaise. ");
INSERT INTO nag_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Etu pichete Jisu taikhan ke koise, “Tumikhan sob aji rati moi nimite biswas te giri jabo, kele koile Isor kotha te eneka likhi kene ase, ‘Moi mer roikhya kora manu ke morai dibo Aru sob mer khan alag-alag jagate polai jabo.’ ");
INSERT INTO nag_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kintu Moi mora pora uthija pichete, Moi tumikhan laga age Galilee te jabo.” ");
INSERT INTO nag_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kintu Peter jowab dikene Jisu ke koise, “Jodi sob manu Apuni ke chari le bhi, moi Apuni ke kitia bhi nacharibo.” ");
INSERT INTO nag_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisu taike koise, “Hosa pora Moi tumike koi ase, aji rati te, murga phojurte hala nakora age te, tumi Moike tin bar najane kobo.” ");
INSERT INTO nag_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter Jisu ke koise, “Jodi moi Apuni logote moribo lage koile bhi, moi kitia bhi Apuni ke najane nakobo.” Aru sob chela khan bhi eneka eke kotha koise. ");
INSERT INTO nag_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Etu pichete Jisu taikhan logote Gethsemane koi kene ekta jagate jaise, aru chela khan ke koise, “Yate bohi thakibi Moi jai kene ta te prathana koribo. ");
INSERT INTO nag_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jisu pora Peter aru Zebedee laga duita chokra khan ke Tai logote loi jaise aru bisi chinta hoi kene mon dukh kori jaise. ");
INSERT INTO nag_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Etu pichete Jisu taikhan ke koise, “Moi laga atma to bisi mon dukh ase, mori jabo nisena tak. Yate thakibi aru Moike rukhi thakibi.” ");
INSERT INTO nag_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aru Jisu olop age te jaise, aru matha niche kori kene prathana korise. Tai koise, “Moi laga Baba, jodi Apuni itcha hoile, etu kup to Moi usor pora hatai dibi. Kintu, Moi laga itcha pora nohoi, hoile bhi Apuni laga itcha pora he.” ");
INSERT INTO nag_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Titia Jisu ahi kene chela khan ke ghumai thaka dikhise, aru Peter ke koise, “Tumikhan Moi nimite ek ghanta bhi rukhibole para nai? ");
INSERT INTO nag_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sai thakibi aru prathana kori thakibi, titia tumikhan porikha te nagiribo nimite. Atma to hosa pora bhi itcha ase, kintu mangso to komjur ase.” ");
INSERT INTO nag_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tai aru dusra bar prathana kori bole jaise, Tai koise, “Moi laga Baba, jodi etu Moi nakha tak Moi pora paar nohoi koile, Apuni laga itcha hobi.” ");
INSERT INTO nag_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tai aru bhi ahi kene taikhan ke ghumai thaka dikhise, kele koile taikhan laga suku neendh pora bhari hoi kene thakise. ");
INSERT INTO nag_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Taikhan ke aru chari kene aru tin bar ula prathana kori bole jaise, aru age nisena he koise. ");
INSERT INTO nag_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Etu pichete Jisu ahikena Tai laga chela khan ke koise, “Tumikhan aru bhi ghumai kene aram kori ase? Sabi, somoi to ahi ase aru Manu laga Putro ke thogai kene paapi manu laga hathte dibole ase. ");
INSERT INTO nag_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Uthi bhi, amikhan jabo. Sabi, kun moike thogabole ase, tai usorte ahi ase.” ");
INSERT INTO nag_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jitia Tai kotha kori thakise, titia, Judas, baroh jon chela khan majote ekjon ahise. Tai logote bisi manu khan talwar aru lathi dhori kene thakise, mukhyo purohit aru cholawta khan pora pathaise. ");
INSERT INTO nag_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Titia etu manu kun Jisu ke thogai dibole thakise tai pora ekta chihna kori kene koise, “Kunke moi chuma dibo, tai he ase. Taike dhori bhi.” ");
INSERT INTO nag_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Loge-loge tai Jisu usorte ahise aru koise, “Salam, Rabbi!” Aru tai Jisu ke chuma dise. ");
INSERT INTO nag_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisu taike koise, “Sathi, tumi ki kori bole ahise etu kori lobi.” Etu pichete taikhan ahise, Jisu uporte hath lagaise, aru dhuri loise. ");
INSERT INTO nag_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sabi, ekjon kun Jisu usorte thakisele tai laga hath khuli se, aru tai laga talwar ulaikene moha purohit laga nokor ke marise aru tai laga kaan kati dise. ");
INSERT INTO nag_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Titia Jisu taike koise, “Tumi laga talwar kote pora ulaise ta te wapas rakhibi, kun manu talwar uthabo tai etu talwar pora khotom hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nohoile bhi tumikhan bhabe Moi Baba ke mati bona paribo, aru Tai baroh sorgodoth khan laga legion ekbar pora pathai dibo koi kene? ");
INSERT INTO nag_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kintu eneka hoile Isor kotha ki likha ase etu kineka purah hobo, yate ki hoi ase etu sob nohoile?” ");
INSERT INTO nag_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Utu somoite Jisu manu khan ke koise, “Tumikhan talwar aru lathi loi kene Moike dhori bole ahise naki, jineka ekta chor ke dhuribole aha nisena? Hodai Moi mondoli te bohi kene sikhai thakise, aru tumikhan utu somoite Moike dhura nai. ");
INSERT INTO nag_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kintu eitu khan sob purah hoise, tineka hoile bhabobadi khan pora Isor kotha te likhi kene thaka khan pura hobo nimite.” Etu pichete sob chela khan Jisu ke chari kene polai jaise. ");
INSERT INTO nag_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jun khan Jisu ke dhori kene loi jaise, aru Caiaphas ekjon maha purohit laga usorte loi jaise, juntu jagate niyom likha khan aru bura manu khan joma hoi kene thakise. ");
INSERT INTO nag_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kintu Peter dur pora Jisu laga piche korise aru moha purohit laga bisar kora jagate jaise. ");
INSERT INTO nag_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Etiya moha purohit aru tai laga sabha manu khan Jisu ke morai dibo koi kene misa gawahi dibole manu bisari thakise. ");
INSERT INTO nag_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Taikhan ekjon bhi pa-a nai, etu laga age te bisi misa laga gawahi dibole khan thakisele. Kintu pichete khali duijon he age te ahise, ");
INSERT INTO nag_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Aru koise, “Etu manu koise, ‘Moi etu Isor laga girja ghor ke bhangai kene aru tin dinte bonai dibo pare.’” ");
INSERT INTO nag_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Utu dangor purohit khara kori kene Taike koise, “Apuni logote eku jowab nai? Eitu khan ki ase taikhan pora Apuni uporte gawahi di thaka to?” ");
INSERT INTO nag_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kintu Jisu chup chap thakise. Aru dangor purohit Taike koise, “Moi jinda Isor laga naam pora apuni ke hukum di ase, Apuni amikhan ke kobi Apuni Isor laga Putro, Khrista to ase na nohoi.” ");
INSERT INTO nag_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisu taikhan ke jowab dise, “Tumi nijor pora he koi dise. Kintu Moi tumike koi ase, etiya pora tumikhan Manu laga Putro ke Hokti laga dyna hathte bohi thaka dikhibo, aru akas laga badal uporte aha dikhibo.” ");
INSERT INTO nag_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Etu pichete moha purohit bisi ghusa hoi kene tai laga kapra phataise, aru koise, “Etu manu Isor laga bodnam korise! Amikhan aru ki etiya gawahi lage? Sabi, etiya amikhan sob Isor laga bodnam huni loise. ");
INSERT INTO nag_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tumikhan laga ki bhabona ase?” Taikhan jowab dikene koise, “Tai to mora he thik hobo.” ");
INSERT INTO nag_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Etu pichete taikhan Jisu laga chehera te thuki se aru Taike marise, aru kunba khan to thapor marise, ");
INSERT INTO nag_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","eneka koi kene, “Amikhan ke bhabobani koribi, tumi Khrista. Kun pora tumike mari ase?” ");
INSERT INTO nag_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Etiya, Peter to ghor bahar te bohi thakise, aru ekjon nokor chukri tai usorte ahise aru koise, “Tumi bhi Jisu logote Galilee te thakise.” ");
INSERT INTO nag_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kintu tai sob laga usorte nohoi koise, “Tumi ki laga kotha kori ase moi najane.” ");
INSERT INTO nag_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jitia tai dorja laga bahar te ulaise, dusra ekjon nokorni taike dikhise aru manu khan ke koise, “Etu manu bhi Nazareth Jisu logote thakise.” ");
INSERT INTO nag_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tai aru bhi nohoi koi kene kosom khaise, “Moi etu manu ke najane!” ");
INSERT INTO nag_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aru olop deri pichete jun khan ta te khara thakise, taikhan ahikena Peter ke koise, “Hosa pora tumi bhi taikhan majote ekjon ase, tumi laga kotha kora pora he bujhi jaise.” ");
INSERT INTO nag_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Etu pichete tai kosom dise aru khaise, “Ami etu manu ke najane,” aru loge-loge murga hala korise. ");
INSERT INTO nag_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Etu pichete Peter Jisu pora ki hoise le etu yaad korise, “Murga hala nakora age te tumi Moike tin bar najane kobo.” Eneka hoi kene tai bahar te ulaise aru bisi mon tita hoi kene kandise. ");
INSERT INTO nag_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kitia phojur hoise, sob moha purohit khan aru bura khan mili kene Jisu ke morai dibole kotha milai thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Taikhan Jisu ke bandi kene loi jaise, aru Governor Pilate laga hathte dise. ");
INSERT INTO nag_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Etu pichete Judas, jun pora Jisu ke thogaise, Jisu ke bodnam kora dikhise, aru tai mon ghurai kene trista chandi laga sikka moha purohit khan aru bura khan ke eneka koi kene wapas kori dise, ");
INSERT INTO nag_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Moi ekjon eku golti nathaka laga khun ke thogai dise.” Kintu taikhan koise, “Utu ki ase amikhan nimite? Nijor pora sai lobi.” ");
INSERT INTO nag_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Titia tai chandi laga sikka khan mondoli te phelai dise, aru bahar te ulai jai kene nijorke fansi lagai kene mori jaise. ");
INSERT INTO nag_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Titia moha purohit khan chandi laga sikka khan loi kene koise, “Etu chandi laga sikka khan tijori te rakhibole niyom nai, kelemane etu sikka khun laga daam te diya hoise.” ");
INSERT INTO nag_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Taikhan sob eke logote mili kene kotha korise aru etu poisa loi kene mati kinise aru etu jaga to nachina manu khan laga kobor nimite rakhise. ");
INSERT INTO nag_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Etu karone, aji tak etu mati ke, “Khun laga Kheti” koi kene rakhi ase. ");
INSERT INTO nag_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jeremiah bhabobadi pora ki kotha koi disele etu sob purah hoi jaise, “Taikhan trista chandi laga sikka loise, aru Israel laga bacha khan pora tai uporte etu daam rakhidise, ");
INSERT INTO nag_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aru taikhan etu loi kene mati kini loise, Probhu pora jineka moike koi diya nisena.” ");
INSERT INTO nag_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Titia Jisu Governor usorte khara korise aru tai pora Jisu ke hudise, eneka koi kene, “Apuni Yehudi khan laga Raja ase naki?” Jisu taike jowab dise, “Apuni he koise.” ");
INSERT INTO nag_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kintu jitia moha purohit aru bura khan pora Jisu ke doshi dise, Tai eku jowab diya nai. ");
INSERT INTO nag_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Etu pichete Pilate Jisu ke koise, “Apuni uporte bodnam khan ani kene diya to Apuni huna nai naki? ");
INSERT INTO nag_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kintu Jisu taike jowab diya nai, Taike bodnam kora khan ke bhi, titia Governor etu dikhi kene bisi asurit lagise. ");
INSERT INTO nag_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Etiya dangor kha luwa laga niyom hisab te manu khan nimite Governor pora taikhan ke bondhi ghor pora chari dibole mon kore taikhan basi lobo pare. ");
INSERT INTO nag_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Etu somoite taikhan logote ekjon bisi biya koidi Barabbas koi kene thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jitia taikhan sob eke logote joma hoise, Pilate taikhan ke koise, “Tumikhan nimite kunke chari dibo? Barabbas na Jisu junke Khrista mate?” ");
INSERT INTO nag_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kilekoile Pilate jani thakise taikhan Jisu ke ghin kora nimite tai laga hathte dise. ");
INSERT INTO nag_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kintu jitia tai bisar kora jagate bohi thakise, tai laga maiki pora kotha pathai kene koise, “Etu golti nathaka manu logote eku na koribi, kelemane moi aji Jisu laga sapna dikhi kene bisi dukh pai ase.” ");
INSERT INTO nag_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Titia mukhyo purohit khan aru bura khan pora ta te joma thaka manu khan ke Barabbas ke chari dibole nimite koise, aru bodli te Jisu ke morai dibole mangise. ");
INSERT INTO nag_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Titia governor pora jowab dikene taikhan ke koise, “Etu duijon majot te moi pora junke kunke chari dibole tumikhan laga itcha ase?” Taikhan koise, “Barabbas.” ");
INSERT INTO nag_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate taikhan ke koise, “Tinehoile moi etu Jisu kun Khrista ase koi tai logote ki koribo?” Taikhan sob jowab dise, “Taike Cross te morai dibi.” ");
INSERT INTO nag_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Titia tai koise, “Kile, Tai ki laga golti kaam korise?” Kintu taikhan jor pora hala kori kene koise, “Taike Cross te mari dibi.” ");
INSERT INTO nag_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jitia Pilate dikhise tai aru eku kori bole napara hoise, aru manu khan pora dangor jhagara ulai dibo koi kene jani loise, etu pora tai manu khan usorte hath dhulaise aru koise, “Etu manu laga khun nimite moi laga eku golti nai, tumikhan nijor pora he sai lobi.” ");
INSERT INTO nag_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sob manu khan jowab dikene koise, “Tai laga khun to amikhan aru amikhan laga bacha khan uporte ahibole dibi.” ");
INSERT INTO nag_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Titia Barabbas ke taikhan nimite chari dise kintu tai Jisu ke mari kene dukh diya pichete Taike Cross te morai dibo khan nimite di dise. ");
INSERT INTO nag_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Titia Governor laga sipahi khan Jisu ke Governor logote loi jaise jun jagate sipahi khan joma kori kene thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Taikhan Jisu laga kapra ulai dise aru sundur rong laga kapra Taike pindhai dise. ");
INSERT INTO nag_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aru kata laga mukut bonaikena Tai laga matha te lagai dise aru dyna hathte ekta lathi dhori bole dise. ");
INSERT INTO nag_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Taikhan Jisu usorte athukari loise aru taike sorom khilai dise, aru matha te mari dikene eneka koise, “Hey Yehudi laga Raja!” ");
INSERT INTO nag_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jitia taikhan Jisu ke sorom khilai dise, taikhan kapra ulai loise aru tai laga nijor kapra aru lagai dise, aru Cross te mari dibole nimite loi jaise. ");
INSERT INTO nag_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jitia taikhan bahar te ulai ahise, ekjon Cyrene sheher pora Simon koi kene paise, junke taikhan Cross bukhi bole dise. ");
INSERT INTO nag_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Taikhan Golgotha koi kene ekta jagate ahise, etu motlob to “Matha Laga Hardi Jaga.” ");
INSERT INTO nag_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Taikhan Jisu ke dawai milai kene thaka draikha ros khabole dise. Kintu jitia Tai etu jiba te chati saise, Tai etu khabo para nai. ");
INSERT INTO nag_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jitia taikhan Jisu ke Cross te mari dise, taikhan Jisu laga kapra khan chithi khili kene bhag kori loise, ");
INSERT INTO nag_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","aru taikhan ta te bohi kene Jisu ke rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aru Jisu laga matha uporte taikhan eneka likhi dise, “Etu Jisu ase, Yehudi jati laga Raja.” ");
INSERT INTO nag_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Etu pichete utu duita chor ke Jisu logote Cross te mari dise, ekjon Tai laga dyna phale aru ekjon ke Tai laga baya phale. ");
INSERT INTO nag_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jun manu etu paar kori kene jai taikhan Jisu ke dikhi kene sorom khilai diye aru taikhan laga matha hilai kene hath milai, ");
INSERT INTO nag_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aru eneka koi kene, “Tumi jun Isor laga mondoli ke bhangai kene tin din pichete bonai dibo thakise, nijorke bachabi! Jodi Tumi Isor laga Putro ase koile, Cross pora namikene ahibi!” ");
INSERT INTO nag_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Etu nisena moha purohit khan bhi Jisu ke sorom khilai dise, aru taikhan logote niyom jana manu aru cholawta khan bhi thakise, aru koise, ");
INSERT INTO nag_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tai dusra manu khan ke bachai dise, kintu Nijorke bacha bole para nai. Tai Israel desh laga Raja ase. Taike Cross pora namikene ahibo dibi, aru etu pichete amikhan Taike biswas koribo. ");
INSERT INTO nag_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tai Isor ke biswas kore, Isor ke Taike bacha bole dibi etiya, jodi Isor Taike lage koile. Kile mane Tai koise, ‘Moi Isor laga Putro ase.’” ");
INSERT INTO nag_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Etu nisena chor duita jun Jisu logote Cross te mari dise, tai bhi Jisu ke sorom khilai diya laga kotha koise. ");
INSERT INTO nag_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aru jitia choi ghanta hoise pura desh te andhera ahi jaise aru pura nou ghanta nohua tak andhera thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jitia tin baji hoise, Jisu ekdom jor pora eneka koi kene kandise, “Eli, Eli, lama sabachthani?” Etu mane, “Ami laga Isor, Ami laga Isor, Apuni kele Moike chari dise?” ");
INSERT INTO nag_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jitia ta te khara kori thaka manu khan etu kotha hunise, taikhan koise, “Tai Elijah ke mati ase.” ");
INSERT INTO nag_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Titia ekjon manu polai jai kene norom kapra te tenga ros pani pora bhorta hoi kene thaka loi kene anise, aru ekta lamba ghar laga khuri te lagase, aru taike dikene Jisu ke khila bole dise. ");
INSERT INTO nag_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ta te thaka manu khan pora koise, “Taike ekla chari di bhi. Moi khan sabo jodi Elijah ahikena Taike bachai na nai.” ");
INSERT INTO nag_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Etu pichete Jisu aru bhi hala kori kene jor pora kandise aru Tai laga atma ke chari dise. ");
INSERT INTO nag_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Etu somoite, mondoli laga purdah upor pora loi kene niche tak dui bhag hoi kene phatise, aru matise, aru pathor khan bhi bhangi kene adha hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aru Isor laga manu kunkhan ghumai jaise, taikhan laga kobor khuli jaise aru taikhan uthijaise. ");
INSERT INTO nag_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Taikhan Jisu jinda huwa pichete kobor pora ulaikene ahise, pobitro sheher Jerusalem te ghusi se, aru bisi manu ke dikhai dise. ");
INSERT INTO nag_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aru jitia sipahi aru kun tai logote thaki kene Jisu ke sai thakise, mati hila aru ki hoise etu dikhise, taikhan bisi bhoi lagise aru koise, “Hosa pora etu manu to Isor laga Putro thakise.” ");
INSERT INTO nag_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aru bisi maiki khan jun Jisu laga pichete Galilee pora berai thakisele taikhan ta te thakise aru dur pora Jisu ke sai thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Taikhan majote Mary Magdalene, Joseph aru James laga ama Mary, aru Zebedee laga chokra khan laga ama bhi thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jitia saam hoise, ekjon dhuni manu Joseph koi kene Arimathea bosti pora ahise, tai bhi Jisu laga chela thakisele. ");
INSERT INTO nag_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tai Pilate usorte jai kene Jisu laga gaw to mangise. Etu pichete Pilate pora hukum dikene taike dise. ");
INSERT INTO nag_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aru Joseph pora Jisu laga gaw to loise, aru mihin kapra pora bandhi dise. ");
INSERT INTO nag_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aru tai nijor laga notun kobor te rakhidise, juntu tai pathor kati kene rakhi thakisele. Etu pichete tai ekta dangor chaka nisena pathor pora kobor to bondh kori dise aru tai jai jaise. ");
INSERT INTO nag_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene aru dusra Mary bhi ta te thakise, kobor laga utu phale bohi thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Dusra din, juntu din to Taiyar Kora din pichete thakise, maha purohit khan aru Pharisee khan eke logote Pilate usorte joma hoi kene thakise. ");
INSERT INTO nag_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Taikhan koise, “Sahab, amikhan yaad ase jitia utu thogai diya manu jinda thaka somoite, tai koise, ‘Tin din pichete moi jinda hobo.’ ");
INSERT INTO nag_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Etu karone hukum dibi, tin din tak etu kobor to bhal kori kene pehera dibole nimite, nohoile Tai laga chela khan ahikena chor kori loijabo, aru manu khan ke kobo, ‘Tai mora pora jinda hoi jaise.’ Aru poila pora bhi etiya laga kotha to bisi hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate taikhan ke koise, “Ekjon sipahi ke lobi. Jabi aru tumi kineka pora pehera lagabo paribo, etu nisena koribi.” ");
INSERT INTO nag_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Titia taikhan jai kene kobor ke bhal pora pehera dise, pathor te mohor marikena sipahi khan ke rukhibo dise. ");
INSERT INTO nag_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Etiya Bisram din khotom hobole hoise, jitia hapta laga poila din ulai thakise, Mary Magdalene aru dusra Mary kobor sabole ahise. ");
INSERT INTO nag_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aru sabi, ta te bisi dangor mati hili se, kele koile Probhu laga ekjon sorgodoth sorgo pora nichete namise, aru pathor ke ghurai kene hatai dise, aru etu uporte bohi jaise. ");
INSERT INTO nag_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tai laga chehera to bhijili nisena, aru tai laga kapra to borop nisena boga thakise. ");
INSERT INTO nag_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kobor rukhi thaka sipahi khan dikhi kene bhoi pora hili jaise aru taikhan mora manu nisena hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kintu utu sorgodoth kotha kori kene maiki khan ke koise, “Bhoi na koribi, kele koile moi jani ase tumikhan Jisu ke bisari bole ahise, junke Cross te mari disele. ");
INSERT INTO nag_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tai yate nai, kintu jinda hoise, jineka Tai pora koise. Ahi kene sabi juntu jagate Taike rakhi sele. ");
INSERT INTO nag_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Joldi jabi aru chela khan ke kobi, ‘Tai to mora pora jinda hoise. Sabi, Tai Galilee te tumikhan age jai ase. Ta te tumikhan Taike dikhibo.’ Sabi, Moi tumikhan ke koi dise.” ");
INSERT INTO nag_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mahila khan dangor bhoi aru khushi pora kobor ke chari kene joldi jaise, aru chela khan ke kobole nimite polaikene jaise. ");
INSERT INTO nag_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sabi, Jisu taikhan ke lok paise, eneka koi kene, “Salam! Apuni logote shanti thakibi!” Utu mahila khan ahikena Tai laga theng dhuri kene Taike aradhana korise. ");
INSERT INTO nag_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Etu pichete Jisu taikhan ke koise, “Bhoi nakuribi. Jabi jai kene Moi laga bhai-kokai khan ke Galilee te jabole kobi. Ta te taikhan Moike dikhibo.” ");
INSERT INTO nag_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jitia mahila khan jai thakise, titia, kunba sipahi khan sheher te jaise aru moha purohitkhan ke ki hoise sob koi dise. ");
INSERT INTO nag_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jitia taikhan bura khan ke lok korise aru taikhan ke bhi ki hoise etu koi dise, aru taikhan sipahi khan ke bisi poisa dise, ");
INSERT INTO nag_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aru koise, “Eneka kobi, ‘Tai laga chela khan rati te ahikena Tai laga gaw chor korise, jitia amikhan ghumai thakise.’ ");
INSERT INTO nag_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jodi etu khobor Governor tak punchi jai, amikhan tai logote kotha koribo aru tumikhan uporte digdar ahibo nadibo.” ");
INSERT INTO nag_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Titia sipahi khan poisa loise aru taikhan pora ki koise etu he koise. Etu laga kotha bisi Yehudi manu khan pora hunise aru aji tak etu kotha koi thake. ");
INSERT INTO nag_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kintu egaroh jon chela Galilee te jaise, ekta pahar te jun to Jisu pora ahibole koise. ");
INSERT INTO nag_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jitia taikhan Jisu ke dikhise, taikhan Taike aradhana korise, kintu kunba taikhan majote bhabona korise. ");
INSERT INTO nag_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisu taikhan usorte ahise aru kotha korise aru koise, “Sob sorgo aru prithibi laga adhikar Moike dise. ");
INSERT INTO nag_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Etu nimite jabi aru sob desh te Moi laga chela bonabi. Taikhan ke Baba, Putro aru Pobitro Atma laga naam pora baptizma dibi. ");
INSERT INTO nag_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Taikhan ke Moi ki hukum dise eitu khan sikhai dibi. Etu janibi, Moi tumikhan logote hodai ase, etu jamana laga hekh din tak.”");
INSERT INTO nag_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Isor laga Putro, Jisu Khrista laga susamachar eneka shuru huwa ase, ");
INSERT INTO nag_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jineka Isaiah bhabobadi pora likhise, “Sabi, tumikhan laga age te Moi khobor bukha manu ke pathai ase, Etu ekjon kun tumikhan nimite rasta taiyar kori dibo. ");
INSERT INTO nag_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ekjon jongol te jor awaj pora mati ase, ‘Probhu nimite rasta to bonai lobi; Aru Tai laga rasta ke sidha rakhi bhi.’” ");
INSERT INTO nag_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jongol te John ulai ahise aru baptizma dikene mon ghurabole aru paap pora khyama pabo nimite prochar korise. ");
INSERT INTO nag_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea laga pura desh aru Jerusalem sheher laga manu khan tai logote jaise. Taikhan ke Jordan Nodi te loi jaise aru taikhan paap shikar kora pichete taikhan ke baptizma dise. ");
INSERT INTO nag_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John laga kapra to uth laga chamra pora bona kapra thakise aru chamra laga peti tai laga komor te bandi kene thakise, aru tai phoring aru jongol mou laga pani khai thakise. ");
INSERT INTO nag_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tai eneka prochar korise, “Ekjon ahibole ase aru Tai moi pora bhi bisi takot ase, aru moi niche jhukikena Tai laga juta khuli dibole bhi layak nai. ");
INSERT INTO nag_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Moi tumikhan ke pani pora baptizma di ase, kintu Tai tumikhan ke Pobitro Atma pora baptizma dibo.” ");
INSERT INTO nag_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Etiya eneka hoise olop din pichete Jisu Nazareth town pora Galilee laga jagate ahise, aru John pora Taike baptizma dise. ");
INSERT INTO nag_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aru loge-loge, jitia Jisu pani pora ulai ahise, sorgo khuli kene Isor laga Atma ekta kopu chiriya nisena Tai uporte ahi thaka tai dikhise. ");
INSERT INTO nag_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Titia sorgo pora ekta awaj ahise, “Tumi Moi laga morom laga Putro ase, Moi Tumi uporte bisi khushi ase.” ");
INSERT INTO nag_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Etu homoi te, Atma pora Taike jongol te jai jabole nimite koise. ");
INSERT INTO nag_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aru Jisu jongol te chalis din tak thakise, aru Taike Saitan pora porikha korise. Etu somoite Tai jongol laga janwar khan logote thakise, aru sorgodoth khan Taike sewa kori thakise. ");
INSERT INTO nag_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John ke dhuri loija pichete, Jisu Galilee laga jagate ahi kene Isor laga susamachar prochar korise. ");
INSERT INTO nag_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jisu prochar, “Etu homoi pura hoise, aru Isor laga rajyo usor hoise. Mon ghura bhi aru susamachar te biswas koribi. ");
INSERT INTO nag_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jitia Tai Galilee Nodi laga kinar te berai thakise, Tai Simon aru tai laga bhai Andrew ke nodi te jal phelai thaka dikhise, kelemane taikhan maas dhora manu asele. ");
INSERT INTO nag_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Titia Jisu taikhan ke koise, “Ahibi, Moi laga pichete, aru Moi tumikhan ke manu dhori bole bonai dibo.” ");
INSERT INTO nag_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Etu homoi te taikhan sob chari kene Jisu laga pichete jaise. ");
INSERT INTO nag_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aru jitia Jisu olop age te jaise, titia Tai James, aru tai laga bhai John ke dikhise. Tai duijon to Zebedee laga chokra thakise, taikhan maas dhura jal bonai thakise. ");
INSERT INTO nag_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aru titia, Jisu taikhan ke matise, taikhan nijor baba aru kaam kora noukar khan ke naw te chari kene Tai laga pichete jaise. ");
INSERT INTO nag_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Titia Jisu aru chela khan Capernaum town te ahise, aru Bisram laga dinte, Jisu mondoli te jai kene sikhaise. ");
INSERT INTO nag_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Taikhan Jisu pora sikhai diya kotha huni kene asurit hoise, kelemane Tai niyom jani kene thaka manu nisena nohoi kene adhikar thaka ekjon nisena sikhai thakise. ");
INSERT INTO nag_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Etu homoi te, ekjon dusto atma pora dhori kene thaka mondoli te thakise, aru tai hala kori kene kandise, ");
INSERT INTO nag_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Aru koise, “Apuni moi khan logote ki kaam ase, Nazareth laga Jisu? Apuni moi khan ke khotom kori bole ahise naki? Moi jane Apuni Isor laga samachar koi dibole aha Pobitro Ekjon ase!” ");
INSERT INTO nag_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kintu Jisu taike gali dikene koise, “Chup thakibi, aru tai pora ulai jabi!” ");
INSERT INTO nag_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Titia dusto atma taike nichete phelai dise aru jor pora hala kori kene kandise aru gaw pora ulai jaise. ");
INSERT INTO nag_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Titia sob manu khan etu dikhi kene asurit hoise, aru ekjon-ekjon ke hudise, aru koise, “Etu ki ase? Ekta notun adhikar pora sikhai diya! Tai dusto atma ke bhi hukum diye aru taikhan Tai laga kotha mane!” ");
INSERT INTO nag_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aru etu laga khobor pura Galilee laga jagate joldi punchi jaise. ");
INSERT INTO nag_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Aru etu pichete, Jisu aru Tai laga chela khan mondoli pora ulaikene ahi juwa pichete, taikhan Simon aru Andrew laga ghor te ahise, aru taikhan logote James aru John bhi thakise. ");
INSERT INTO nag_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Etu homoi te Simon maiki laga ama bukhar pora ghumai thakise, aru taikhan joldi pora jai kene etu Jisu ke koi dise. ");
INSERT INTO nag_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Titia Jisu ahise, aru tai laga hath dhorise, aru taike uthai dise. Titia bukhar tai pora jai jaise, aru tai uthikena taikhan ke sewa korise. ");
INSERT INTO nag_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jitia saam hoise, aru suryo nami jaise, taikhan bemar thaka manu aru bhoot pora dhori kene thaka sob Tai usorte loi anise. ");
INSERT INTO nag_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aru Capernaum sheher te thaka sob manu khan ahikena dorja usorte joma hoise. ");
INSERT INTO nag_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Aru Tai alag kisim laga bemar thaka manu khan ke bhal korise, aru bhoot khan pora dhori kene thaka atma khan khedai dise, kintu Tai etu bhoot khan ke kotha kobole diya nai kelemane taikhan jani thakise Tai kun ase. ");
INSERT INTO nag_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Aru phojur nohua age te Tai joldi uthise, aru Tai ekla kun bhi nathaka jagate jai kene ta te prathana kori thakise. ");
INSERT INTO nag_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Titia Simon aru tai logote thaka khan Taike bisari ahise. ");
INSERT INTO nag_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jitia taikhan Taike lok paise, taikhan koise, “Sob manu Apuni ke bisari ase.” ");
INSERT INTO nag_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kintu Tai taikhan ke koise, “Ahibi amikhan dusra nogor te jai jabo, ta te bhi Moi prochar koribo lagi ase.” Kelemane Moi etu karone ahise. ");
INSERT INTO nag_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aru Tai Galilee sob jagah te jai kene taikhan laga mondoli te prochar korise aru bhoot khan ke khedai thakise. ");
INSERT INTO nag_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Titia kusto-rugi bemar thaka ekjon Tai logote ahi kene athukari se aru anurodh kori kene Taike koise, “Jodi Apuni itcha hoile, moike sapha koribo pare.” ");
INSERT INTO nag_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Titia Jisu taike bisi morom lagise. Aru Tai laga hath uthaise, aru taike chuikena eneka koise, “Ami itcha ase. Sapha hoi jabi.” ");
INSERT INTO nag_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aru loge-loge te kusto-rugi bemar taike chari jaise, aru tai sapha hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kintu Jisu pora taike samjai dikena jabo dise. ");
INSERT INTO nag_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Aru taike koise, “Sabi tumi kunke bhi eku nokobi, kintu jabi, tumi nijor purohit khan ke dikhai dibi, aru tumi sapha huwa laga dikhai kene Moses laga niyom kori taikhan ke sakhi hobole dibi.” ");
INSERT INTO nag_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kintu bemar bhal hoija manu pora etu kotha bisi manu ke koi dise, aru Jisu khula-khula nogor te jabole napara hoise. Kintu Tai bahar alag jagah te thakise, aru manu khan ephale-uphale pora Tai logote ahise. ");
INSERT INTO nag_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Aru Jisu Capernaum nogor te olop din pichete wapas ahise, aru Tai Simon Peter laga ghor te ase koi kene manu khan huni loise. ");
INSERT INTO nag_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Manu bisi ta te joma hoise aru jaga nathaka hoi jaise, dorjate bhi jaga nathaka hoise, aru Jisu pora taikhan ke Isor laga kotha koise. ");
INSERT INTO nag_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Titia kunba manu khan Jisu usorte ekjon juthor bemar para bera bole napara manu ke loi anise; taike charjon pora uthai anise. ");
INSERT INTO nag_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jitia taikhan manu bisi thaka nimite Jisu usorte taike loi jabole para nai, taikhan kun jagate Jisu thakise, ta te laga chat hatai dise, aru chaat khuli diya pichete, taikhan bisna te ghumai thaka manu ke Jisu usorte namai dise. ");
INSERT INTO nag_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jitia Jisu taikhan laga biswas dikhise, Tai etu manu ke koise, “Putro, tumi laga paapkhan sob maph kori dise.” ");
INSERT INTO nag_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Etiya niyom likha khan kunba ta te bohi thakise, aru taikhan nijor laga monte bhabona korise, ");
INSERT INTO nag_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kile etu manu eneka kotha koi ase? Tai misa koi ase! Kun he paap to maph kori bole paribo, khali Isor nohoile?” ");
INSERT INTO nag_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Titia Jisu atma pora jani jaise taikhan nijor monte ki bhabona kori ase. Jisu taikhan ke hudise, “Tumikhan kele monte eneka bhabona kori ase? ");
INSERT INTO nag_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Etu bera bole napara manu ke ki koile bhal ase, ‘Tumi laga paap to maph hoise’ na etu kobole ‘Uthibi, tumi laga bisna uthabi, aru berabi’? ");
INSERT INTO nag_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kintu tumikhan etu jani lobi Manu laga Putro ke etu prithibi te paap pora maph dibole nimite adhikar dise,” aru Jisu bera bole napara manu ke koise, ");
INSERT INTO nag_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Moi tumike koi ase, uthibi, tumi laga chatai lobi, aru nijor laga ghor te jabi.” ");
INSERT INTO nag_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Titia tai joldi uthi kene chatai uthaise, aru sob manu laga usor pora bahar te ulai jaise. Etu dikhi kene, taikhan sob asurit hoi jaise aru taikhan Isor ke dhanyavad dise, aru koise, “Moi khan kitia bhi eneka dikha nai.” ");
INSERT INTO nag_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Etu pichete Tai aru nodi kinar te jaise, aru bisi manu Tai usorte ahise, aru Jisu taikhan ke sikhaise. ");
INSERT INTO nag_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jitia Jisu jai thakise, Tai Aalphaeus laga chokra Levi ke poisa utha manu khan laga tambu te bohi thaka dikhise titia Jisu taike koise, “Moi laga pichete ahibi.” Tai uthi kene Jisu laga pichete jaise. ");
INSERT INTO nag_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aru eneka hoise Jisu Levi laga ghor te khana khai thakise, aru bisi poisa utha manu aru paapi manu khan bhi Jisu aru Tai laga chela khan logote bohi kene eke logote khai thakise, kelemane bisi manu thakise aru taikhan Jisu laga pichete jai thakise. ");
INSERT INTO nag_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jitia kunba niyom likha khan kunkhan Pharisee khan he asele, Jisu ke dusra paapi aru poisa utha manu khan logote bohi kene khai thaka dikhise, taikhan Jisu laga chela khan ke koise, “Kile Tai poisa utha aru paapi manu khan logote bohi kene khai ase?” ");
INSERT INTO nag_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jitia Jisu etu hunise, Tai koise, “Gaw bhal thaka manu khan ke dawai nalage, kintu kun manu bemar ase, taikhan he lage. Moi dharmik manu ke mati bole aha nai, kintu paapi manu khan nimite ahise.” ");
INSERT INTO nag_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Etiya John laga chela khan aru Pharisee khan upwas loi thakise, titia taikhan ahi kene Jisu ke koise, “Kile John laga chela aru Pharisee khan laga chela khan upwas loi ase, kintu Apuni laga chela khan upwas noloi?” ");
INSERT INTO nag_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Titia Jisu taikhan ke koise, “Shadi te aha manu khan to shadi kori thaka mota taikhan logote thaka tak upwas lobole napare, napare? Jitia tak taikhan logote shadi kora mota ase, taikhan upwas lobole na paribo. ");
INSERT INTO nag_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kintu eneka din ahibo jitia shadi kora mota ke taikhan pora loijabo, titia taikhan upwas lobo. ");
INSERT INTO nag_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kun bhi notun kapra te biya kapra hali kene nasilai. Eneka korile kapra biya hoi jabo, notun kapra ke purana kapra pora biya kori dibo, aru etu pora pura kapra biya hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aru kun bhi notun angur ros to loi kene purana chamra jola te narakhe. Eneka korile angur ros aru purana chamra jola duita bhi biya hoi kene phati jabo. Kintu notun angur ros ke notun chamra jola te he hali kene rakhibo.” ");
INSERT INTO nag_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aru eneka hoise, Tai Bisram dinte dhaan kheti paar hoi kene jai asele, Tai chela khan juwa somoite dhaan bhangai kene khai thakise. ");
INSERT INTO nag_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aru Pharisee khan taike koise, “Sabi, kele juntu kaam Bisram dinte koribo nalage etu kori ase?” ");
INSERT INTO nag_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kintu Jisu taikhan ke jowab dise, “Jitia David bhuk lagise- tai aru tai sathi khan ki korise,- etu tumikhan porha nai naki, ");
INSERT INTO nag_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","jineka tai Isor laga ghor te jaise jitia Abiathar mukhyo purohit thakise, aru ta te daan diya roti khaise, juntu niyom hisab te tai khabole napare, khali purohit khan he nohoile, kintu tai bhi khaise aru tai laga sathi khan ke bhi dise?” ");
INSERT INTO nag_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aru Tai taikhan ke koise, “Bisram din to manu karone bonai dise, kintu Bisram din karone manu ke bona nohoi. ");
INSERT INTO nag_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Karone Manu laga Putro to Bisram din laga Probhu ase.” ");
INSERT INTO nag_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Dusra dinte, Jisu aru mondoli te wapas jaise, aru ta te hath biya thaka ekjon thakise. ");
INSERT INTO nag_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kunba khan Taike golti lagabo karone Bisram dinte Tai bemar manu khan ke bhal kori dibo na nai sai thakise. ");
INSERT INTO nag_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aru Tai hath biya thaka ke koise, “Uthi kene age ahibi.” ");
INSERT INTO nag_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Titia Tai taikhan ke hudise, “Bisram dinte bhal kaam koribo lage na biya kaam koribo lage, jibon bachabo namorabo?” Kintu taikhan chup-chap thakise. ");
INSERT INTO nag_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aru taikhan laga mon tan huwa dikhikene Jisu bisi khong hoise, aru Tai hath biya thaka manu ke koise, “Tumi laga hath uthabi.” Aru etu manu tai hath uthaise, aru hath bhal hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Titia Pharisee khan ulaikene joldi Herod laga manu khan logote mili kene Tai bhirodh te, Taike morai dibo karone taikhan bisara shuru korise. ");
INSERT INTO nag_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kintu Jisu Tai chela khan ke loi kene nodi phale jaise, aru Galilee nodi aru Judea desh ");
INSERT INTO nag_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aru Jerusalem sheher, Idumea, aru Jordan paar pora aru Tyre aru Sidon sheher khan phale pora bisi manu Tai logot ahise. Tai dangor asurit kaam kori diya huni kene Tai logote dangor bhir Tai logot ahi jaise. ");
INSERT INTO nag_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Aru Tai chela khan ke Tai karone ekta chutu naw bisari bole koise, kelemane bhir pora Taike chipai dibo hoija karone. ");
INSERT INTO nag_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kelemane Tai bisi manu ke bhal kora karone jiman bemar ase, sob Taike chubole kosis korise. ");
INSERT INTO nag_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aru letera thaka atma khan Taike dikhise, aru Tai laga age te giri kene hala kori Taike koise, “Apuni Isor laga Putro ase.” ");
INSERT INTO nag_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kintu Tai taikhan ke jor pora koise, Tai kun ase manu khan ke janibo nadibi koi kene. ");
INSERT INTO nag_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aru Tai pahar uporte jaise, aru jun manu ke Tai lage, eitu khan ke Tai usorte matise, aru taikhan Tai logote ahise. ");
INSERT INTO nag_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Titia Tai logote thaki bole baroh jonke basi loise, - taikhan ke prochar kori bole pathai dibo karone- ");
INSERT INTO nag_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aru bemar khan ke bhal kori dibole aru bhoot khan ke khedai dibole hokti aru adhikar dise. ");
INSERT INTO nag_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aru Tai baroh jonke basi loise: Simon jun laga naam Tai Peter rakhise. ");
INSERT INTO nag_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedee laga Putro James aru tai laga bhai John jun khan laga naam Tai Boanergas rakhidise, etu laga motlob ase, bhijili laga chokra khan. ");
INSERT INTO nag_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew Matthew, Thomas, aru Alphaeus laga Putro James, Thaddaeus, Simon Zealot. ");
INSERT INTO nag_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Aru Iscariot Judas, jun Taike thogai dise. ");
INSERT INTO nag_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ek din Jisu ekta ghor bhitor te bohise, aru bisi manu ahi joma hoi jaise, etu karone Jisu aru chela khan to bhaat bhi khabole para nai. ");
INSERT INTO nag_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kintu jitia Tai nijor ghor manu khan etu kotha hunise, taikhan Taike dhori loi jabole bhabise, kelemane taikhan koise, “Tai laga dimag biya hoi jaise.” ");
INSERT INTO nag_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aru Jerusalem pora aha niyom likha khan koise, “Tai logote Beelzebul ase” aru “Tai bhoot khan laga adhikar pora bhoot ke khedai ulai ase.” ");
INSERT INTO nag_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Karone Tai taikhan ke usorte mati ani kene dristanto pora koise, “Kineka kori Saitan he Saitan ke khedai dibo paribo? ");
INSERT INTO nag_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jodi ekta rajyo to nijor bhitor te namili kene bhag hoile, etu rajyo khara koribo na paribo. ");
INSERT INTO nag_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jodi ekta ghor nijor majot namila hoile, etu ghor bhi khara koribo na paribo. ");
INSERT INTO nag_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aru jodi Saitan bhi nijor majot te namila hoi kene alag hoile, tai thakibo na paribo, kintu tai khotom hobo. ");
INSERT INTO nag_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kun bhi takot manu laga ghor te ghusi kene saman chor koribo na paribo, jitia tak takot manu ke bandhi nolobo, etu pichete he tai saman chor koribo paribo. ");
INSERT INTO nag_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Moi tumikhan ke hosa kobo, prithibi te thaka sob laga paap ke maph kori dibo, Isor ke hinsa kora kotha bhi maph kori dibo. ");
INSERT INTO nag_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kintu jun bhi Pobitro Atma uporte biya kotha ekta bhi kobo, taike maph nadibo, kintu kitia bhi khotom nohua golti kori dibo.”- ");
INSERT INTO nag_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kelemane taikhan koi thakise, “Tai logote dusto atma ase.” ");
INSERT INTO nag_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Titia Jisu laga ama aru bhai khan ahi kene bahar te rukhise, aru Taike mati bole manu pathaise. ");
INSERT INTO nag_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dangor bhir tai logote thakise, hoilebi taikhan koise, “Sabi! Apuni laga ama aru bhai khan bahar te ahi kene Apuni ke bisari ase.” ");
INSERT INTO nag_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kintu Tai jowab di koise, “Kun Ami laga ama aru bhai ase?” ");
INSERT INTO nag_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Titia Tai ghuri kene bohi thaka khan ke saikene koise, “Sabi, eitu khan he Ami laga bhai aru ama khan ase. ");
INSERT INTO nag_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kelemane jun Isor itcha koribo, eitu khan he Ami laga bhai, bhoini aru ama ase.” ");
INSERT INTO nag_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aru Tai Galilee Nodi kinar te sikhabole shuru korise, aru bisi Tai usorte dangor bhir joma hoi jaise. Titia Tai ekta naw pora samundar te bohi jaise, aru bisi thaka khan samundar kinar sukha jagate khara thakise. ");
INSERT INTO nag_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Titia Tai taikhan ke dristanto pora bisi kotha sikhai dise, aru Tai updesh te taikhan ke eneka koise. ");
INSERT INTO nag_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Huni bhi! Bijon diya manu ekjon bijon hissi bole jaise. ");
INSERT INTO nag_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aru eneka hoise, Tai bijon hissi dise, aru kunba bijon rasta kinar te giri jaise, aru chiriya khan ahikena khai dise. ");
INSERT INTO nag_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kunba olop mati thaka pathor te giri jaise, ta te mati bisi nathaka karone joldi uthijaise. ");
INSERT INTO nag_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kintu jitia suryo uporte uthise aru gham dise, taikhan jor nathaka karone phat sukhi jaise. ");
INSERT INTO nag_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aru kunba bijon to kata thaka jagate giri jaise, aru kata uthi kene bijon ke dabai loise, etu karone guti dhoribo para nai. ");
INSERT INTO nag_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kintu baki bijon bhal matite girise, aru taikhan uthijaise, aru bhal hoi kene guti dhurise, aru kunba tis guna, kunba saat aru kunba sou guna dise. ");
INSERT INTO nag_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aru Tai taikhan ke koise, jun laga huni bole kaan ase, taike hunibo dibi!” ");
INSERT INTO nag_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kintu jitia Tai ekla hoi jaise, titia Tai laga chela aru Tai logote thaka khan Taike etu dristanto laga motlob hudise. ");
INSERT INTO nag_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aru Tai taikhan ke koise, “Tumikhan ke to Isor rajyo laga lukaikene thaka kotha janibole dise. Kintu bahar manu khan ke to dristanto pora koi ase, ");
INSERT INTO nag_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kelemane taikhan sai thakibo, kintu nadikhibo, Aru taikhan huni thakibo kintu nabujhi bo, Etu nimite taikhan ghuri ahikena taikhan laga paap pora khyama napai.” ");
INSERT INTO nag_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aru Jisu pora taikhan ke hudise, “Kile tumikhan etu dristanto na bujhe? Tinehoile tumikhan sob dristanto kineka bujhi bo paribo? ");
INSERT INTO nag_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kheti kora manu he Isor laga kotha hissi diya jon ase. ");
INSERT INTO nag_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Rasta kinar te kotha hissi dise, aru jitia taikhan kotha hunise, Saitan joldi ahikena taikhan monte thaka kotha loijai. ");
INSERT INTO nag_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tineka he pathor jagate hissi diya khan ke bhi hoise, taikhan kotha huni kene khushi pora joldi mani loise. ");
INSERT INTO nag_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kintu jor nathaka karone olop din he thakibo parise. Etu pichete jitia kotha karone dukh kosto ahise, titia joldi taikhan giri jaise. ");
INSERT INTO nag_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aru kata te hissi diya to jun manu kotha ke huni loise, ");
INSERT INTO nag_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kintu duniya laga chinta, aru dhun laga thoga baji, aru kisim-kisim jinis laga lalos pora taikhan monte jai kene, kotha ke dabai dise aru phol ulabo napara hoijai. ");
INSERT INTO nag_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kintu bhal matite hali diya khan ase, jun khan kotha huni kene mani loise, aru phol dibo parise, kunba tis guna kunba sat guna aru kunba sou guna.” ");
INSERT INTO nag_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisu taikhan ke arubi eneka koidi thakise, “Kunbi saaki julai kene ekta tukri nohoile bisna nichete narakhe nohoi? Etu ke jolai kene khamba uporte rakhe nohoi? ");
INSERT INTO nag_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kelemane yate lukai rakhibole eku bhi nai, jitia tak dikhai nadiye, aru lukaikene ki kaam korise eitu khan sob puhor te dikhi jabo. ");
INSERT INTO nag_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jodi kunba huni bole kaan ase, taike hunibo dibi!” ");
INSERT INTO nag_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Titia Tai koise, “Tumikhan bhal pora huni bhi, ji naap tumi naapi dise, etu pora tumike bhi naapibo, aru etu pora bhi bisi di dibo. ");
INSERT INTO nag_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kelemane jun logote kiba ase, taike aru di dibo, kintu jun logote eku bhi nai, tai pora olop thaka ke bhi loijabo.” ");
INSERT INTO nag_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aru Tai koise, “lsor laga rajyo to kunba matite bijon hali diya nisena ase. ");
INSERT INTO nag_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aru tai ghumai kene rati aru dinte uthi thake, aru bijon dangor hoi thake, kintu tai najane kineka pora dangor hoi. ");
INSERT INTO nag_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mati nijor pora ghas ulai aru dhaan diye: poila to phul diye aru hawa khai, etu pichete dangor hoi kene dhaan diye. ");
INSERT INTO nag_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kintu jitia dhaan pakki jai, titia tai joldi dhaan kata manu khan ke pathai, kelemane katibo somoi huwa karone.” ");
INSERT INTO nag_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Titia Tai koise, “Kineka pora amikhan Isor laga rajyo ke tulona koribo? Nohoile ki dristanto pora etu dikhai dibo? ");
INSERT INTO nag_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Etu to sorso dana nisena ase, jitia etu matite hissi dise, etu somoi matite sob pora chutu guti ase. ");
INSERT INTO nag_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kintu, jitia etu ke hissi diye, aru uthi jai, kheti te thaka pata sob pora bhi dangor hoijai, aru tai daal dangor hoi kene, akas laga chiriya bhi etu laga chaya te ghor bonai thake.” ");
INSERT INTO nag_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aru Tai dristanto pora eneka bisi kotha taikhan ke bujhi bole koi dise. ");
INSERT INTO nag_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kintu dristanto nohoi kene taikhan ke eku bhi kowa nai. Aru jitia Tai ekla hoise, Tai chela khan ke eitu khan laga motlob samjhai dise. ");
INSERT INTO nag_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Etu din jitia saam hoise, Jisu pora chela khan ke koise, “Ahibi, amikhan etu jagate jabo.” ");
INSERT INTO nag_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aru taikhan bhir ke chari kene, Tai logot naw te uthise. Aru dusra nawkhan bhi thakise. ");
INSERT INTO nag_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Titia dangor hawa ahise, aru tufan pora naw ke mari thaka karone naw to pani bhorta hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kintu Jisu to kinar te palis uporte ghumai thakise. Aru taikhan Taike uthaikene koise, “Shika manu, amikhan khotom hobole ase aru Apuni chinta nai?” ");
INSERT INTO nag_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Titia Jisu uthi kene andhi ke galise aru nodi ke koise, “Chup thakijabi!” Aru hawa rukhi jaise aru sob shanti hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kintu Tai Taikhan ke hudise, “Kile tumikhan bhoi korise? Tumikhan etiya bhi biswas nakore?” ");
INSERT INTO nag_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aru taikhan bisi bhoi hoi kene ekjon majote kotha korise, “Etu kun ase? Hawa aru nodi bhi Tai laga kotha mane!” ");
INSERT INTO nag_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aru Jisu aru chela khan Galilee Nodi laga dusra phale, Gerasenes jagate ahise. ");
INSERT INTO nag_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aru jitia Jisu naw pora ulai ahise, ekjon junke dusto atma pora dhorise, joldi kobor pora ulai ahi kene Taike lok paise. ");
INSERT INTO nag_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tai kobor te he thake, aru kunbi taike rukhabole manu thaka nai, luha rusi pora bhi bandhi rakhibole napara hoise. ");
INSERT INTO nag_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kelemane taike bar-bar theng te luha rusi pora bandhi rakhise, kintu tai bhangai di thake. Aru ta te kun bhi taike dhori kene rakhibo paribole takot thaka nai. ");
INSERT INTO nag_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tai rati din hoile bhi hodai pahar te aru kobor te he thake, aru kandi kene tai dhar pathor pora nijorke jokhom kori thake. ");
INSERT INTO nag_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jitia tai dur pora Jisu ke dikhise, tai Jisu phale polaikene jaise aru salam korise. ");
INSERT INTO nag_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Aru tai jor pora kandi kene koise, “Jisu, Porom Prodhan Isor laga Putro? Apuni ami logote ki kaam ase? Ami Isor naam pora Apuni ke anurodh kori ase, amike dukh nadibi.” ");
INSERT INTO nag_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kelemane poila pora Jisu eneka koidisele, “O dusto atma, etu manu pora ulai jabi.” ");
INSERT INTO nag_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Titia Tai taike hudise, “Tumi laga ki naam ase?” Aru tai koise, “Ami laga naam Legion ase, kelemane amikhan bisi ase.” ");
INSERT INTO nag_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aru tai Jisu ke anurodh korise taikhan ke etu jaga pora bahar napothabo nimite. ");
INSERT INTO nag_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aru ta te pahar te gahori khan kiba khai thakisele, ");
INSERT INTO nag_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","aru biya atma khan Tai logote binti korise, “Amikhan ke gahori laga bhitor te ghusi jabo dibi.” ");
INSERT INTO nag_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Karone Tai taikhan ke jabole koi dise, titia dusto atma to ulaikene gahori te ghusi jaise, etu sob dui-hajar nisena gahori thakise, rang-khang pora polai ahi kene nodi te giri dubi jaise. ");
INSERT INTO nag_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Titia jun manu gahori ke khilai thakisele, taikhan polai ahi kene sheher te aru bosti te thaka sobke koi dise, aru ki hoise koi kene manu khan sabole ulai ahise. ");
INSERT INTO nag_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Titia taikhan Jisu logote ahise, aru jun logote Legion thakisele, bhal hoi kene kapra lagai thaka dikhi kene taikhan bhoi khaise. ");
INSERT INTO nag_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aru etu dusto atma thaka manu logot ki hoise aru gahori khan ke ki hoise etu laga kotha bhi sob manu ke koi dise. ");
INSERT INTO nag_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Titia taikhan Jisu ke etu desh pora jai jabole koise. ");
INSERT INTO nag_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aru jitia Jisu naw te uthijaise, jun manu logote biya atma thakisele, tai Jisu logote jabole binti korise. ");
INSERT INTO nag_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hoile bhi Jisu taike Tai logote jabo diya nai kintu koise, “Tumi nijor ghor te jabi, aru tumi laga sathi khan ke kineka tumi laga Probhu pora morom korise aru dangor kaam kori dise etu sob koi dibi.” ");
INSERT INTO nag_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aru etu manu Decapolis te jai kene ta te Jisu pora tai nimite ki kori dise etu sobke koise, aru jiman manu hunise, taikhan sob asurit hoise. ");
INSERT INTO nag_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aru jitia Jisu naw pora etu pahar hoi kene jaise, titia dangor bhir Tai logote joma hoi jaise, aru Tai nodi kinar te thakise. ");
INSERT INTO nag_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aru sabi, Jairus naam mondoli laga cholawta ekjon ahi Jisu laga theng te giri jaise. ");
INSERT INTO nag_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aru Tai logote binti kori koise, “Ami laga chutu swali mori bole ase. Tai bhal hoi kene jinda thaki bole Apuni ahibi aru tai uporte Apuni laga hath dibi.” ");
INSERT INTO nag_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Titia Jisu tai logote jaise, aru bisi joma thaka khan Tai logote ahise, aru dhaka-dhaki kori kene jai thakise. ");
INSERT INTO nag_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aru ekjon mahila baroh saal pora khun jai thaka ta te thakise. ");
INSERT INTO nag_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aru bhal kora manu khan logote bisi dukh kori toka poisa sob kharcha kori saise, hoile bhi bhal nohoi, kintu aru bisi biya hoi thakise. ");
INSERT INTO nag_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jitia tai Jisu ki korise etu laga kotha khan hunise, bhir thaka majot pora ahi kene Jisu laga kapra chuise. ");
INSERT INTO nag_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kelemane tai bhabise, “Jodi moi Tai laga kapra khali chubo parise koile, moi bhal hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Titia tai khun jai thaka rukhi jaise, aru tai laga gaw pora janibo parise bemar bhal hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aru loge-loge te, Jisu bhi Tai pora hokti ulai ja jani loise. Aru Tai ghuri kene ephale-uphale manu khan ke saikene hudise, “Kun pora Ami laga kapra chuise?” ");
INSERT INTO nag_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kintu Tai chela khan Taike koise, “Sabi manu bisi Apuni ke dhaka-dhaki kori jai ase etu dikhi kene bhi, Apuni koise, ‘Kun Moike chuise?” ");
INSERT INTO nag_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aru kun he Taike chuishe koi kene Tai ghuri kene saise. ");
INSERT INTO nag_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aru etu mahila jani loise tai laga bemar bhal hoi jaise aru bisi bhoi hoi kene Jisu laga theng te giri kene Tai logote ki-ki hoise sob hosa koi dise. ");
INSERT INTO nag_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aru Tai taike koise, “Chukri, tumi laga biswas he tumike bhal korise, shanti pora jabi, aru etu bemari pora bhal hoi jabi.” ");
INSERT INTO nag_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jitia Tai etu kotha koise, kunba manu khan Yehudi cholawta laga ghor pora ahi kene koise, “Tumi laga swali mori jaise. Etiya sikha manu ke kele aru dukh dibo?” ");
INSERT INTO nag_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kintu taikhan ki koi thakise, etu Jisu huni kene Tai mondoli laga cholawta ke koise, “Bhoi nokoribi. Biswas he rakhibi.” ");
INSERT INTO nag_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aru Tai Peter aru James aru James laga bhai John eitu khan ke chari kunke bhi Tai logote jabo diya nai. ");
INSERT INTO nag_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aru titia Tai mondoli laga cholawta laga ghor te ahise, ta te manu khan jor pora hala kori kandi thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Titia Tai bhitor te ahise, aru Tai taikhan ke koise, “Tumikhan kele dukh hoi kene kandi ase? Swali to mora nohoi, kintu tai khali ghumai ase.” ");
INSERT INTO nag_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aru taikhan Taike hasi dise, kintu Tai taikhan ke bahar te ulai dikene swali laga baba aru ama aru jun manu Tai logote thakise, taikhan ke loi kene bhitor te swali thaka jagate jaise. ");
INSERT INTO nag_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Titia Tai swali laga hath dhori kene koise, “Talitha Koum!” Etu motlob ase: Chutu swali, Moi tumike koi ase, uthibi.” ");
INSERT INTO nag_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aru loge-loge etu swali uthi kene bera bole hoise,- kelemane tai laga umor baroh saal thakise.- Aru taikhan sob bisi asurit hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kintu Tai kun manu ke bhi janibo nadibi koi kene swali laga baba ama khan ke mana korise aru taike kiba khabole dibi koise. ");
INSERT INTO nag_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Titia Tai ta te pora ulaikene nijor town, Nazareth te ahise, aru Tai laga chela khan Tai logote ahise. ");
INSERT INTO nag_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aru Bisram dinte Tai mondoli te sikhai thakise, aru bisi manu Tai kotha huni kene asurit hoise, aru ekjon majot te eneka hudi thakise, “Etu manu to kot pora etu kotha sob jani ase, aru Taike diya etu ki laga gyaan ase? Aru kineka hokti laga kaam etu manu laga hath pora asurit kaam hoi ase?” ");
INSERT INTO nag_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Tai barhoi nohoi, jun Mary laga chokra ase, aru James, Joses, Judas, aru Simon laga bhai to? Aru Tai laga bhoini khan yate amikhan logote thaka nohoi?” Karone taikhan Taike bhal puwa nai. ");
INSERT INTO nag_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kintu Jisu Taikhan ke koise, “Ekjon bhabobadi to tai laga adar nathaka nohoi, kintu tai laga nijor nogor aru nijor ghor manu khan majot tai adar napai.” ");
INSERT INTO nag_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aru Tai ta te dusra kaam koribo para nai, khali kunba bemar ke hath lagai kene bhal kori diya he hoise. ");
INSERT INTO nag_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aru taikhan biswas nakora karone Tai asurit hoise, aru Tai bosti te berai kene sikhai thakise. ");
INSERT INTO nag_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aru Tai baroh jon chela khan ke Tai usorte mati ani kene taikhan ke duijon kori pathai dise, aru taikhan ke dusto atma khan kheda bole adhikar dise. ");
INSERT INTO nag_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Aru Tai taikhan ke sikhai dise safar juwa somoite, eku bhi noloikena khali ekta lathi he lobi, aru jola, bhaat, aru poisa laga peti te poisa nolobo. ");
INSERT INTO nag_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kintu juta lagabo,- aru kapra bhi duita napindhibo. ");
INSERT INTO nag_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aru Jisu taikhan ke koise, “Jitia tumikhan kunba ghor te ghusi bo, tumikhan etu jaga chari kene najuwa tak etu ghor te he thakibi. ");
INSERT INTO nag_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aru jodi etu jagate manu kun bhi tumikhan ke grohon nakore, aru kotha nahune, eneka hoile ta te pora juwa somoite tumikhan theng te thaka dhuli jhari dibi, taikhan bhirod de etu pora sakhi hobo karone.” ");
INSERT INTO nag_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Karone baroh jon chela khan jai kene manu khan ke mon ghura bole prochar kori dise. ");
INSERT INTO nag_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aru taikhan bisi bhoot khan ke khedai dise, aru bemari ke tel malis kori kene taikhan ke bhal kori dise. ");
INSERT INTO nag_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Aru Herod raja bhi eitu khan hunise, kelemane sob pora Jisu laga naam jani jaise, aru kunba khan eneka koi thakise, “Baptizma diya John to mora pora jee uthijaise, aru etu karone tai pora he eneka dangor kaam kori ase.” ");
INSERT INTO nag_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dusra koise, “Tai Elijah ase.” Kintu dusra khan koise, “Tai poila te bhabobadi thaka khan nisena he ekta bhabobadi ase.” ");
INSERT INTO nag_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kintu jitia Herod etu kotha hunise, “John jun laga matha moi kati disele- tai mora pora jee uthijaise.” ");
INSERT INTO nag_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kelemane, Herod to tai nijor bhai Philip laga maiki Herodia ke shadi korise, etu nimite tai manu pathai kene John ke bondhi ghor te rakhi disele. ");
INSERT INTO nag_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kelemane John pora Herod ke koise, “Tumi nijor bhai laga maiki ke luwa to Isor laga niyom te thik nohoi.” ");
INSERT INTO nag_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Karone Herodias bhi John ke biya paikena taike morai dibo bhabisele, kintu tai para nai. ");
INSERT INTO nag_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kelemane Herod to John ke bhoi kori thakise; tai jani thakise John to ekjon dhormik aru pobitro manu ase, aru taike bhal pora bachai kene rakhise. Tai kotha hunile bisi bhoi hoijai, kintu khushi pora huni thake. ");
INSERT INTO nag_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aru ekta bhal dinte, Herod pora tai laga jonom dinte, tai laga daruga khan, senapoti khan aru adhikari manu khan, aru Galilee laga cholawta khan ke rati te khana te matise. ");
INSERT INTO nag_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aru Herodias laga chukri nachi kene Herod aru ta te thaka sobke khushi kori dise, titia Herod pora swali ke koise, “Mangibi moi pora ki lage, moi tumike dibo.” ");
INSERT INTO nag_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aru tai swali usorte kosom khaise, “Tumi ki mangibo, moi laga adha rajyo mangile bhi, moi tumike dibo.” ");
INSERT INTO nag_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Karone swali jai kene tai laga ama ke hudise, “Moi ki mangibo?” Titia tai ama jowab dise, “Baptizma diya John laga matha mangibi”. ");
INSERT INTO nag_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tai joldi raja logote ahi koise, “Baptizma diya John laga matha ekta thali pora moike di dibi, etu he ami laga itcha ase.” ");
INSERT INTO nag_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Titia raja laga mon bisi dukh hoise, kintu tai kosom diya karone aru Tai logote boha alohi manu khan karone tai swali ke nohobo kobo napara hoise. ");
INSERT INTO nag_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aru raja joldi ekjon sipahi ke John laga matha kati kene anibole hukum dise. Aru bondhi ghor te jai kene tai laga matha kati loise. ");
INSERT INTO nag_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aru ekta thali te rakhise aru etu swali ke dise, aru swali pora tai ama logot dise. ");
INSERT INTO nag_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jitia John laga chela khan etu hunise, taikhan ahi kene tai laga gaw uthai loijai kene ekta kobor te rakhidise. ");
INSERT INTO nag_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Titia apostle khan Jisu logote ahi joma hoise, aru ki kaam taikhan korise, aru sikhai dise, sob Taike koi dise. ");
INSERT INTO nag_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aru Tai taikhan ke koise, “Tumikhan nijor alag sunsan jagah te jai kene olop somoi aram kori lobi.” Kelemane ta te bisi manu aha-juwa kori ase, karone taikhan khabole somoi bhi napa hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aru taikhan naw pora ekta alag sunsan jagah te jai jaise. ");
INSERT INTO nag_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kintu bisi manu taikhan jai thaka dikhi kene sob nogor pora polai ahise aru Tai logote ahise. ");
INSERT INTO nag_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aru Jisu jitia bahar te ulaise, dangor bhir dikhikena taikhan ke morom lagise, kelemane taikhan to roikhya nathaka nisena thakise. Aru Tai bisi kotha taikhan ke sikhai dise. ");
INSERT INTO nag_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jitia saam hoi jaise, Jisu laga chela khan ahi kene Jisu ke koise, “Etu sunsan jagah ase, aru homoi to deri hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Taikhan ke pathai dibi, taikhan ephale-uphale usor bosti te jai kene nijor karone roti kinibo dibi, kelemane taikhan khabole eku nathaka hoise.” ");
INSERT INTO nag_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kintu Tai taikhan ke jowab di koise, “Tumikhan he taikhan ke kiba khabole dibi.” Aru taikhan Jisu ke hudise, “Amikhan jai kene dui-sou dinarii laga roti kini ani kene taikhan ke khabole dibo?” ");
INSERT INTO nag_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kintu Tai taikhan ke koise, “Tumikhan logote kiman roti ase? Jai kene sabi.” Aru jitia taikhan saikene koise, “Pansta roti aru duita maas.” ");
INSERT INTO nag_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Titia Tai sob manu ke ghas te joma hoi kene bohi bole koise. ");
INSERT INTO nag_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Titia taikhan ke eksoh-eksoh aru pachas-pachas kori kene alag-alag jagate bohi bole koi dise. ");
INSERT INTO nag_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aru Tai pansta roti aru duita maas ke loi kene sorgo phale saise aru dhanyavad dikena roti bhangai se aru manu khan ke dibole chela khan ke koise. Aru Tai duita maas ke bhi taikhan sob logote bhag kori dise. ");
INSERT INTO nag_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Titia Taikhan sob khai loise aru pet bhorta hoise. ");
INSERT INTO nag_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aru baroh ta tukri te bachi juwa roti tukra aru maas joma korise. ");
INSERT INTO nag_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ta te taikhan roti kha pans hajar manu thakise. ");
INSERT INTO nag_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Titia Tai manu khan ke pathai dibo karone chela khan ke naw pora joldi Nodi laga dusra phale, Bethsaida te jabi koi dise. ");
INSERT INTO nag_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aru Tai prathana kori bole pahar te jai jaise. ");
INSERT INTO nag_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jitia saam ahise naw to nodi majote thakise, aru Tai ekla he matite asele. ");
INSERT INTO nag_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Titia hawa taikhan ke ulta pora mari thaka karone, naw ke age te loi jabole bisi digdar huwa Tai dikhise. Aru choutha paher nisena Tai nodi te khujkari taikhan logote ahise, aru taikhan pora age ulai jabole bhabise. ");
INSERT INTO nag_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kintu jitia Tai nodi te Tai khujkari aha dikhise, taikhan bhoot dikhise bhabi kene bisi hala korise. ");
INSERT INTO nag_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kelemane taikhan sob Taike dikhi kene bisi bhoi hoise, kintu Tai joldi taikhan logote kotha korise aru koise, “Mon dangor koribi, Moi he ase! Bhoi na koribi!” ");
INSERT INTO nag_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Titia Tai taikhan logote naw te ahise, aru hawa rukhi jaise, aru taikhan bisi asurit hoise. ");
INSERT INTO nag_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kelemane taikhan etu roti laga motlob bhi buja nai. Kintu, taikhan laga mon tan hoi thakise. ");
INSERT INTO nag_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jitia taikhan paar kori kene matite ahise taikhan Gennesaret jagate ahi kene naw ta te lagai rakhise. ");
INSERT INTO nag_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aru jitia taikhan naw pora ulai ahise, manu khan Taike joldi jani loise. ");
INSERT INTO nag_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aru usorte thaka bosti khan sob polai ahise aru bemari khan ke bisna pora loi anise, aru jun jagah te Tai ase koi kene janibo, ta te loi ani thakise. ");
INSERT INTO nag_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aru jun jagah hobi, bosti, nogor aru desh hobi, Tai kote jai, utu sob jagah te bemari khan ke bajar te bhi rakhi kene Tai laga kapra olop chubole binti kori thakise, aru jiman manu Taike chubo parise, taikhan sob bhal hoijai thake. ");
INSERT INTO nag_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ek din, Jerusalem pora aha Pharisee aru kunba likha manu khan Tai logote joma hoise. ");
INSERT INTO nag_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Aru taikhan Jisu laga chela khan kunba ke hath nadhulai kene bhaat khai thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","-Kelemane Pharisee aru Yehudi khan purana niyom ke mani thakisele, taikhan hath nadhui kene eku bhi nakhai. ");
INSERT INTO nag_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jitia taikhan bajar jaga pora ahe, hath nadhui kene eku bhi nakhai, aru tineka bisi kotha ase: jun to taikhan mani thake, gilas, thali, tamba laga borton, dhua aru sapha kora.- ");
INSERT INTO nag_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Titia Pharisee aru niyom likha manu khan Jisu ke hudise, “Kile Apuni laga chela khan poila laga niyom namani kene choli thake, aru hath nadholai kene roti khai thake?” ");
INSERT INTO nag_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisu taikhan ke jowab dise, “Isaiah he tumi kopoti khan laga kotha bhabobani thik koise. Tai eneka likhise, ‘Eitu khan mukh pora to Moike sonman kore, Kintu taikhan mon to Moi pora dur thake. ");
INSERT INTO nag_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Aru taikhan misa-misi te Moike aradhana kori thake, Kelemane manu para bona niyom loi sikhai thake.’ ");
INSERT INTO nag_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kelemane tumikhan Isor diya niyom chari kene manu bona niyom he mani thake.” ");
INSERT INTO nag_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tai taikhan ke koise, “Tumikhan manu he bona niyom mani kene, Isor diya bhal niyom khan chari dise. ");
INSERT INTO nag_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kelemane Moses koisele, ‘Tumi laga baba aru ama ke Sonman koribi,’ aru, ‘Jun tai nijor baba, ama ke biya kobo, tai ji hoile bhi moribo.’ ");
INSERT INTO nag_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kintu tumikhan koi, ‘Jodi ekjon tai nijor baba, ama ke koi, “Moi pora tumi ki modot pabole ase, etu sob Isor pora Corban dise’” - motlob, ‘Isor ke di dise’. ");
INSERT INTO nag_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Aru tumikhan etu manu ke tai baba aru ama ke eku bhi modot kori bole nadiye. ");
INSERT INTO nag_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aru tumikhan Isor laga kotha biya kori thake tumikhan niyom pora. Aru bisi mili thaka nisena kaam kori thake. ");
INSERT INTO nag_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aru titia Jisu pora manu khan ke Tai usorte mati anikena koise, “Ami laga kotha huni bhi, aru bujhi lobi. ");
INSERT INTO nag_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Eneka jinis to nai, bahar pora manu bhithor te jai kene letera kori diya, kintu ji jinis bhitor pora ulai etu he taike letera kori diye. ");
INSERT INTO nag_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jodi kunba huni bole kan ase, taike hunibo dibi. ");
INSERT INTO nag_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jitia Tai bhir majot pora ulaikene ghor bhitor te ahise, taikhan Taike etu dristanto laga motlob hudise. ");
INSERT INTO nag_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aru Tai taikhan ke koise, “Kile tumikhan bhi eneka nabuja ase? Bahar pora manu laga bhitor te ki jai etu pora manu ke letera nakore. ");
INSERT INTO nag_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kelemane etu tai mon para nohoi, kintu mukh pora pet te jai kene aru latrine te ulai jai, kele koile sob kha luwa to sapha ase.” ");
INSERT INTO nag_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aru Jisu eneka koi thakise, “Ki mon pora ulai, etu he manu ke letera kore. ");
INSERT INTO nag_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kelemane manu laga mon pora biya bhabona, bebichari, chor kora aru morai diya, ");
INSERT INTO nag_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lalos, biya kaam kora, thogai diya, biya niyom thaka, suku jola, hinsa kora, dimag napuncha kaam kora, aru phutani kora. ");
INSERT INTO nag_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Etu sob biya bostu mon pora ahi manu ke letera kori diye.” ");
INSERT INTO nag_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ta te pora Tai uthi kene Tyre aru Sidon laga desh phale jaise. Aru ekta ghor te jaise, aru kunke bhi janibo nadibo bhabisele, kintu Tai Iukabole para nai. ");
INSERT INTO nag_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kintu ta te ekjon mahila jun laga chutu swali ke dusto atma pora dhurikena thakise, etu mahila Jisu laga kotha hunise, aru ahi Tai laga theng te giri jaise. ");
INSERT INTO nag_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aru etu mahila Yunani aru Syrophoenicia jaga laga asele, aru tai swali pora bhoot ulai dibi koi kene Jisu ke binti korise. ");
INSERT INTO nag_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kintu Jisu taike koise, “Poila, bacha ke khabole dibi. Kelemane bacha laga roti loi kene kutta khan ke diya thik nohoi.” ");
INSERT INTO nag_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aru tai jowab dikene koise “Hoi, Probhu, kintu kutta bhi bacha khan laga roti tukra mez nichete giri thaka khabole pai.” ");
INSERT INTO nag_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Titia Tai taike koise, “Etu kotha karone tumi, jabi, bhoot tumi laga swali pora ulai jaise.” ");
INSERT INTO nag_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aru tai jitia ghor te ahise, tai swali bisna te ghumai thaka aru bhoot ulai jai kene thaka pai loise. ");
INSERT INTO nag_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Titia Tai aru bhi Sidon laga desh pora ulai Decapolis laga desh te hoi Galilee nodi phale ahi jaise. ");
INSERT INTO nag_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Titia kunba ekjon kaan benga aru kotha bhal pora kobo napara jon thakise, Tai laga hath tai uporte rakhi dibi koi kene binti korise. ");
INSERT INTO nag_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aru Tai taike bisi thaka manu pora alag loijai kene tai laga kan te anguli ghusai dise, aru thuk dikene tai jiba te chui dise. ");
INSERT INTO nag_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Titia Tai sorgo phale saise aru jor pora awaj dikene koise, “Ephphatha!” -Motlob ase “Khuli jabi!” ");
INSERT INTO nag_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Titia joldi tai kan khuli jaise, aru tai jiba bandi thaka bhi khuli jaise, aru tai sapha pora kotha kori bole parise. ");
INSERT INTO nag_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Titia Tai taikhan ke etu kunke bhi nokobi koi mana kori dise kintu jiman taikhan ke mana kore, iman taikhan bisi kobole hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Aru taikhan bisi asurit hoi ekjon majot te koi thakise, “Tai jiman bhi korise sob thik korise. Tai kan nahuna ke bhi huni bole dise, aru kobo napara ke bhi kotha kobole takot dise.” ");
INSERT INTO nag_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dusra dinte arubi bisi manu joma hoi jaise, aru taikhan logote khabole eku thaka nai. Jisu pora Tai laga chela khan ke matise aru koise, ");
INSERT INTO nag_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Moi etu sob manu khan ke bisi morom lage, kelemane taikhan tin din pora Ami logote thaki ase, aru etiya taikhan logote khabole eku nai. ");
INSERT INTO nag_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jodi Moi taikhan ke ghor te bhukha pathai dile, taikhan rasta te komjur pora giri jabo pare, kelemane kunba to dur pora ahise.” ");
INSERT INTO nag_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Titia chela khan Taike jowab dise, “Kote pora kunba yate jongol pora roti ani kene eitu khan ke khila bo paribo?” ");
INSERT INTO nag_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tai taikhan ke hudise, “Tumikhan logote kiman ta roti ase?” Taikhan koise, “Sat-ta.” ");
INSERT INTO nag_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Titia Tai taikhan ke matite bohi bole adesh dise, aru Tai sat-ta roti loi Isor ke dhanyavad dise, aru bhangai kene chela khan ke di dise, aru taikhan pora sobke dise. ");
INSERT INTO nag_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Taikhan logote ekta huru maas thakise, Tai etu bhi loi dhanyavad dikene taikhan ke dibole koise. ");
INSERT INTO nag_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Titia taikhan khai kene aram pai loise, aru bachi juwa khana to sat-ta tukri bhorta uthai loise. ");
INSERT INTO nag_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Aru jun khaise, taikhan char hajar nisena asele, aru Tai taikhan ke jabo dise. ");
INSERT INTO nag_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aru Tai joldi nijor chela khan ke naw te uthi kene Dalmanutha laga desh phale jaise. ");
INSERT INTO nag_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Titia kunba Pharisee khan ahi Taike hudise aru porikha korise. Taike sorgo pora ekta chihna taikhan ke dikha bole koise. ");
INSERT INTO nag_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kintu Tai nijor Atma te dukh paa nisena lamba sans loi koise, “Kile etu yug khan chihna bisari thake? Moi tumikhan ke hosa kobo, etu yug khan ke eku chihna nadibo.” ");
INSERT INTO nag_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aru Tai taikhan ke chari kene, naw te uthijaise, aru nodi paar kori kene dusra phale jai jaise. ");
INSERT INTO nag_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aru chela khan roti lobole pahorise, aru naw te taikhan logote ekta roti pora bisi thaka nai. ");
INSERT INTO nag_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Titia Jisu taikhan ke koise, “Sai rukhi thaki bhi, Herod aru Pharisee laga khomir pora hoshiar thakibi.” ");
INSERT INTO nag_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Taikhan apaste kotha korise, kelemane amikhan logote roti nathaka hoise. ");
INSERT INTO nag_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kintu Jisu etu jani kene taikhan ke hudise, “Tumikhan roti nathaka karone kele kotha kori ase? Kile etiya bhi najane? Tumi laga mon tan hoi thaki ase? ");
INSERT INTO nag_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Suku thakile bhi, kele nadikhe? Kan thakile bhi, kele nahune? Aru tumikhan yaad nai? ");
INSERT INTO nag_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jitia Moi pans hajar karone pansta roti bhangai dise, aru tumikhan kiman tukri uthaise?” Taikhan jowab dise, “Baroh-ta tukri uthaise.” ");
INSERT INTO nag_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Aru jitia Moi char hajar karone sat-ta roti bhangai sele, titia tumikhan kiman ta tukri bhorta kori uthaise?” Taikhan koise, “Sat-ta tukhri uthaise.” ");
INSERT INTO nag_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Titia Tai hudise, “Kile, tumikhan etiya bhi nabuje?” ");
INSERT INTO nag_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Titia Jisu aru chela khan Bethsaida te ahi jaise, aru taikhan suku nadikha manu ekjon Jisu logote loi anise, aru taike chubole binti korise. ");
INSERT INTO nag_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Etu karone Tai suku nadikha manu laga hath dhorise aru bosti bahar te loi jaise, aru tai laga suku te thuki kene, Tai hath pora taike chuise aru taike hudise, “Tumi kiba dikhi ase?” ");
INSERT INTO nag_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aru tai uporte sai koise, “Moi ghas nisena manu jai thaka dikhi ase.” ");
INSERT INTO nag_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Titia Tai arubi ekbar hath tai laga suku te chuise, aru tai bhal pora sabo parise aru sapha pora sob dikhibo parise. ");
INSERT INTO nag_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Titia Jisu taike ghor te pathai dise aru koise, “Town te etiya-etiya nimite najabi.” ");
INSERT INTO nag_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Titia Jisu aru Tai chela khan Caesarea Philippi laga usorte thaka bosti khan te jai jaise. Tai rasta te ja somoite, chela khan hudise, “Manu khan Moike kun ase koi?” ");
INSERT INTO nag_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Titia taikhan taike koise, “Baptizma diya John,’ aru kunba koi, ‘Elijah,’ aru kunba koi, ‘Ekjon bhabobadi.’” ");
INSERT INTO nag_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tai taikhan ke koise, “Kintu tumikhan Moike ki koi ase?” Peter jowab di koise, “Apuni Khrista ase.” ");
INSERT INTO nag_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Titia Tai kun ase etu kunke bhi nokobi koise. ");
INSERT INTO nag_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aru Jisu taikhan ke sikhabole shuru korise, Manu laga Putro bisi dukh koribo lagibo, bura khan aru prodhan purohit aru likha manu khan Taike namanibo aru morai dibo, aru Tai tin din pichete jee uthijabo. ");
INSERT INTO nag_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tai taikhan ke etu kotha sapha pora koi dise, aru Peter Taike alag loijai kene Taike hala korise. ");
INSERT INTO nag_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kintu Jisu ghurikena chela khan ke saise aru Tai Peter ke galise aru koise, “Saitan! Ami laga usor pora dur hobi, kelemane tumi Isor laga kotha te nohoi, kintu manu laga bhabona te he thake.” ");
INSERT INTO nag_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Titia Tai bhir te thaka manu khan aru chela khan ke matise, aru Tai usorte ani kene koise, “Jodi kunba Ami laga piche koribo mon hoile, tai nijorke tyag koribo lage aru nijor Cross uthai loi Ami laga pichete ahibi. ");
INSERT INTO nag_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kelemane jun nijor jibon bacha bole mon koribo, tai jibon harabo, kintu jun Moi karone, aru susamachar karone nijor jibon harabo, tai bachibo. ");
INSERT INTO nag_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Karone kunba manu sob prithibi pai loi kene tai nijor jibon haraile, tai ki labh ase? ");
INSERT INTO nag_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Karone manu to nijor jibon laga bodli te ki dibo paribo? ");
INSERT INTO nag_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Judi biswas nathaka aru paapi yug pora Ami laga kotha ke aru Moi nimite sorom kore, Manu laga Putro bhi jitia Tai laga pobitro duth khan aru Baba laga mohima te ahibo, Tai bhi tai nimite kotha kobole sorom koribo.” ");
INSERT INTO nag_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aru Jisu taikhan ke koi thakise, “Hosa pora Moi tumikhan ke kobo, yate khara thaka kunba khan namoribo jitia tak Isor rajyo laga takot loi kene aha ke nadikhe bo.” ");
INSERT INTO nag_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Titia choi din pichete Jisu pora Peter, James aru John ke loi kene ekta untcha pahar te jaise. Titia taikhan usorte, Tai laga gaw bodli hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tai kapra borop nisena bisi boga hoi jaise, etu prithibi te kun dhobi bhi tineka boga kori bole na pora nisena. ");
INSERT INTO nag_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Titia Moses aru Elijah aha dikhai dise, aru taikhan Jisu logote kotha kori thakise. ");
INSERT INTO nag_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Titia Peter pora Jisu ke koise, “Rabbi, amikhan yate thakile bhal hobo, amikhan ke tinta thaki bole jaga bonabo dibi, ekta Apuni nimite, ekta Moses nimite, aru ekta Elijah nimite.” ");
INSERT INTO nag_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aru tinjon chela khan bisi bhoi laga karone Jisu taikhan ke ki kobo lage etu najana hoise. ");
INSERT INTO nag_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Titia ekta badal ahikena taikhan ke dhaki loise, aru badal pora ekta awaj pora koise, “Etu Ami laga morom thaka Putro ase. Taike huni bhi.” ");
INSERT INTO nag_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Titia tinjon chela khan achanak ephale-uphale saise aru Jisu he taikhan logote thaka paise, aru kunke bhi dikha nai. ");
INSERT INTO nag_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jitia taikhan pahar pora niche ahi thakise, Jisu taikhan ke hukum dikene koise jitia tak Manu laga Putro mora pora jee uthi najai, titia tak taikhan ki dikhise etu kunke bhi nakobo. ");
INSERT INTO nag_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Taikhan etu kotha lukai rakhidise aru “Mora pora jee uthi naja tak” ki motlob ase koi kene kotha kori thakise. ");
INSERT INTO nag_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aru taikhan Taike hudise, “Kile, likha khan Elijah he poila ahibo lage koi?” ");
INSERT INTO nag_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tai taikhan ke jowab dikena koise, “Elijah he poila ahibo lage, aru sob thik tak kori dibo, etu hosa ase. Kintu Manu laga Putro laga kotha te Tai bisi dukh koribo aru Taike ghin hobo etu kele Isor kotha te likhi rakhise? ");
INSERT INTO nag_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kintu Moi tumikhan ke koi dibo Elijah ahi jaise, aru taikhan taike ki kori bole mon thakise etu kori dise, jineka Tai nimite bhi kotha likhi rakhi kene ase.” ");
INSERT INTO nag_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aru jitia Tai chela khan logote ahise, bisi manu taikhan laga age pichete thakise, aru niyom likha khan taikhan logote kotha te lagi thakise. ");
INSERT INTO nag_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aru jitia manu khan Taike dikhise, taikhan asurit hoi kene Jisu logot polai ahise aru Taike salam dise. ");
INSERT INTO nag_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aru Tai pora chela khan ke hudise, “Tumikhan taikhan logote ki kotha te lagi ase?” ");
INSERT INTO nag_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ekjon bisi manu thaka jaga pora Taike jowab di koise, “Shika manu, moi laga chokra ke Apuni logot loi anise, tai logot gunga atma ase. ");
INSERT INTO nag_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aru kot te taike dhure, ta te taike phelai diye aru tai laga mukh pora phen ulai, aru daat kamuri kene tai laga bodon to tan hoi thake. Aru moi Apuni laga chela ke etu khedai dibole koise, kintu taikhan para nai.” ");
INSERT INTO nag_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisu taike jowab dise, “Tumi biswas nakora yug khan, Moi kitia tak tumikhan logote thakibo? Kitia tak Moi tumikhan ke sai thakibo? Taike Moi logote loi anibi.” ");
INSERT INTO nag_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aru taikhan chokra ke Tai logote anise. Aru jitia etu gunga atma pora Jisu ke dikhise, joldi tai chokra ke dukh dise, aru matite girai dise, aru tai laga mukh pora phen ulaise. ");
INSERT INTO nag_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Etu karone Jisu tai laga baba ke hudise, “Tai kitia pora bemar ase?” Aru tai koise, “Bacha homoi pora ase. ");
INSERT INTO nag_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aru bar-bar taike khotom kori bole kitia ba jui te aru kitia ba panite girai di thake, kintu Apuni he kiba koribo parile, morom pora amikhan ke modot koribi.” ");
INSERT INTO nag_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aru Jisu taike koise, “‘Jodi Apuni pare koile koi ase?’ Biswas manu khan karone to sob koribo paribo.” ");
INSERT INTO nag_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Joldi chokra laga baba kandi kene koise, “Hey Probhu, moi biswas ase, moi laga biswas laga upai kori dibi!” ");
INSERT INTO nag_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jitia bhir khan polai ahi thaka Jisu dikhise, titia Tai dusto atma ke galise, aru koise, “Tumi nahuna aru gunga atma, Moi tumike hukum di ase, tai pora ulai jabi, aru kitia bhi tai bhitor te aru najabi.” ");
INSERT INTO nag_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Titia gunga atma taike bisi dukh dise aru jor pora hala kori kene ulai jaise, aru chokra to mora nisena hoise, etu dikhikena bisi manu eneka koise, “Tai mori jaise.” ");
INSERT INTO nag_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kintu Jisu etu chokra laga hath dhori kene taike uthai dise aru tai khara hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pichete, jitia Jisu ghor bhitor te ahise, Tai laga chela khan alag pora Taike hudise, “Amikhan kele etu ke khedabo para nai? ");
INSERT INTO nag_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Etu karone Tai taikhan ke koise, “Etu sob prathana aru upwas pora he koribo paribo.” ");
INSERT INTO nag_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Titia Jisu aru chela khan ta te pora ulaikene Galilee paar kori jai asele, kintu Tai kun manu ke bhi janibo dibole itcha kora nai. ");
INSERT INTO nag_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kelemane Tai nijor chela khan ke sikhai thakise aru koise, “Manu laga Putro ke manu hathte dhori dibo, aru taikhan Taike morai dibo; aru tin din pichete arubi Tai jee uthijabo.” ");
INSERT INTO nag_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kintu taikhan etu kotha laga motlob bujhi bo pora nai, aru Taike hudibole bhi bhoi lagi thakise. ");
INSERT INTO nag_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Titia Tai Capernaum te ahise, aru jitia Tai ghor bhitor te ahise, Tai taikhan ke hudise, “Tumikhan rasta te ki kotha loi huda-hudi kori asele?” ");
INSERT INTO nag_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kintu taikhan eku bhi kowa nai. Kelemane taikhan rasta te ekjon-ekjon logote kun he dangor hobo etu kotha kori thakise. ");
INSERT INTO nag_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aru bohi kene, Tai laga baroh jon chela ke mati kene koise, “Jodi kunba prothom hobole mon korile tai sob pora piche hobi, aru sob laga noukar hobi.” ");
INSERT INTO nag_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Titia Tai ekta huru bacha loi taikhan majote rakhise aru bacha ke Tai laga hathte loi kene taikhan ke koise. ");
INSERT INTO nag_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Jun Ami laga naam te eitu khan nisena bacha ke grohon koribo, tai Moike grohon kori loise, aru jun Moike grohon koribo, tai Moike he nohoi kintu Moike Jun pathaise, Taike bhi grohon kori loise.” ");
INSERT INTO nag_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John Taike koise “Shika manu, kunba ejkon pora Apuni laga naam te bhoot khedai thaka paisele, aru amikhan taike mana kori dise, kelemane tai amikhan logote nathaka manu huwa karone.” ");
INSERT INTO nag_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kintu Jisu koise, “Taike mana na koribi, kelemane eneka kun bhi nai, jun Ami laga naam te asurit kaam koribo, aru pichete Moike biya nokobo. ");
INSERT INTO nag_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kelemane jun bhi Amikhan ke hinsa nakore, tai Ami phale ase. ");
INSERT INTO nag_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kelemane jun bhi tumikhan ke Khrista laga koi kene Ami naam pora ekta gilas pani bhi khilai le, Moi tumikhan ke hosa kobo, tai pabo thaka naharabo. ");
INSERT INTO nag_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kintu jun bhi, Moike biswas kora chutu ekjon ke bhi biya kori dile, tai karone dhan pisi thaka dangor pathor to tai gola te bandi kene samundar te phelai diya he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jodi tumi laga hath pora tumike paap koribo di thake, etu hath kati phelai dibi, duita hath loi norokte kitia bhi khotom nohua jui te juwa pora tumi hath nathakile bhi jibon te juwa he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ta te taikhan laga puka namora aru jui bhi kitia bhi nabhutibo. ");
INSERT INTO nag_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aru jodi tumi laga theng pora tumike paap koribo di thake, etu ke kati phelai dibi. Duita theng loi norokte kitia bhi bhuti bo napara jui te juwa pora tumi lengra hoile bhi jibon te juwa he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ta te taikhan ke kamura puka namore aru jui kitia bhi nabhute. ");
INSERT INTO nag_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aru jodi tumi laga suku karone tumike paap koribo di thake koile, suku ulaikena phelai dibi. Duita suku loi kene norokte juwa pora to ekta suku loi kene Isor laga rajyote juwa he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ta te taikhan ke kamura puka namore aru jui bhi kitia bhi nabhute. ");
INSERT INTO nag_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Karone sob jui pora nimokia kori dibo. ");
INSERT INTO nag_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nimok to bhal ase, kintu nimok bhi tai laga swadh harai jaile tumi ki pora etu ke aru swad koribo? Tumi nijorke nimok nisena rakhibi, aru shanti pora ek-dusra logote thakibi.” ");
INSERT INTO nag_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Titia Jisu Capernaum chari kene Jordan Nodi paar korise aru Judea desh phale ahi jaise, aru bisi manu Tai logote joma hoise, aru hodai nisena Tai taikhan ke sikhai di thakise. ");
INSERT INTO nag_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kunba Pharisee khan Taike porikha kori bole kiba hudise, “Ki karone mota tai maiki ke chari dibole niyom ase?” ");
INSERT INTO nag_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aru Tai taikhan ke jowab dikene koise, “Moses tumikhan ke ki hukum disele?” ");
INSERT INTO nag_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Taikhan koise, “Moses koise chari bole laga kagos likhi kene taike chari dibole pare.” ");
INSERT INTO nag_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aru Jisu taikhan ke koise, tumikhan laga mon tan huwa karone tai tumikhan ke etu hukum dise. ");
INSERT INTO nag_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kintu sristi laga shuru pora ‘Isor he mota aru maiki bonai dise.’ ");
INSERT INTO nag_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Karone mota to nijor ama aru baba chari kene tai nijor maiki logote mili jabo. ");
INSERT INTO nag_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aru tai duijon eke sharir hoi jabo.’ Karone taikhan duijon nohoi kintu ekta sharir hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Karone ki Isor pora milai dise, etu ke manu pora alag nokoribi.” ");
INSERT INTO nag_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jitia taikhan ghor te thakise Tai chela khan Taike aru etu kotha hudise. ");
INSERT INTO nag_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Karone Tai taikhan ke koise, “Jun bhi tai maiki ke chari dikene aru dusra ke shadi korile tai maiki laga bhirodh te bebichar kori ase. ");
INSERT INTO nag_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aru jodi maiki bhi nijor mota chari kene dusra logote shadi korile tai bhi bebichar kori ase.” ");
INSERT INTO nag_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ek din kunba manu khan pora taikhan laga bacha khan ke Tai usorte loi anise, taikhan laga matha te Tai laga hath rakhi kene asirbad dibole nimite, kintu chela khan pora taikhan ke rukhai dise. ");
INSERT INTO nag_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kintu Jisu etu dikhikena koise, “Bacha khan ke Moi logote ahibo dibi taikhan ke narukha bhi, kelemane Isor laga rajyo to eneka khan laga he ase. ");
INSERT INTO nag_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Moi hosa pora tumikhan ke koi ase, jun pora nije ke ekta chutu bacha nisena kori kene Isor laga rajyo ke swekar nakore, tai ji hoile bhi ta te gusibo na paribo.” ");
INSERT INTO nag_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aru Tai hath taikhan uporte rakhi kene asirbad dise. ");
INSERT INTO nag_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Aru jitia Jisu rasta te jai asele, ekjon polai ahise, aru Tai samne te athukari kene Taike hudise, “Bhal Shika manu, anonto jibon pabole moi ki koribo lage?” ");
INSERT INTO nag_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Titia Jisu taike koise, “Tumi Moike kele bhal koi ase? Isor he nohoile kun bhi bhal nohoi. ");
INSERT INTO nag_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tumi niyom khan jani ase: ‘Manu namora bhi, bebichar na koribi! Chor na koribi, misa gawahi nadibo, manu ke nothogabi, tumi baba ama ke sonman koribi.’” ");
INSERT INTO nag_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aru tai jowab di Taike koise, “Shika manu, moi etu sob jawan thaka somoi pora mani ahise.” ");
INSERT INTO nag_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Titia Jisu taike morom pora saikene taike koise, “Tumi ekta kaam he puncha nai, jabi aru tumi laga ki ase, sob bikiri kori kene dukhia khan ke di dibi, aru tumi sorgote dhun pai jabo, aru ahikena Ami laga piche koribi.” ");
INSERT INTO nag_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kintu tai etu kotha huni kene dukh hoise, aru mon biya hoi kene jai jaise, kelemane tai bisi dhuni asele. ");
INSERT INTO nag_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Titia Jisu Tai age piche saikene chela khan ke koise, “Dhuni manu Isor laga rajyote gushi bole bisi digdar hobo!” ");
INSERT INTO nag_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aru chela khan Tai kotha pora asurit hoise. Kintu Jisu taikhan ke aru koise, “Bacha khan, Isor laga rajyote gushi bole kiman bhi digdar ase! ");
INSERT INTO nag_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Isor laga rajyote dhuni manu gushi bole para to ekta uth pora bhiji laga suku paar ulai juwa he bisi sosta hobo.” ");
INSERT INTO nag_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aru taikhan ekdom asurit hoi kene ekjon-ekjon logote kotha korise, “Tinehoile kun poritran pabo?” ");
INSERT INTO nag_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kintu Jisu taikhan ke saikene koise, “Manu pora hoile etu na paribo, kintu Isor he paribo. Kelemane Isor nimite sob para ase.” ");
INSERT INTO nag_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Titia Peter Taike koise, “Sabi amikhan to sob chari kene Apuni laga piche korise. ");
INSERT INTO nag_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Titia Jisu koise, “Moi tumikhan ke hosa kobo, kun bhi Moi karone aru susamachar karone Tai ghor nohoile bhai-bhoini, ama-baba, nijor bacha, aru kheti mati bari chari dile; ");
INSERT INTO nag_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","taikhan sob ek-sou guna pora bhi bisi pabo: ghor, aru bhai, bhoini, ama aru bacha aru kheti baari khan, aru aha yug te anonto jibon pabo. ");
INSERT INTO nag_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kintu bisi manu jun khan age ase, taikhan piche hoi jabo, aru jun piche ase taikhan age hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kitia Jisu aru chela khan Jerusalem te jai thakise, Jisu taikhan sob laga age hoi kene jai thakise. Taikhan asurit hoise, aru Tai laga piche kori thaka khan bhoi lagi thakise. Titia Tai ekbar aru baroh jonke kinar te loijai kene Tai uporte ki ahibole ase etu taikhan ke koise. ");
INSERT INTO nag_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Sabi, Amikhan Jerusalem te jai ase, aru Manu laga Putro ke dhorikena mukhyo purohit aru niyom likha khan laga hathte di dibo, aru taikhan Taike golti dibo aru Taike morai dibo. Taike biswas nakora khan laga hathte dikena morai dibo. ");
INSERT INTO nag_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aru taikhan Taike ninda kori kene maribo, kintu tin din pichete Tai jee uthibo.” ");
INSERT INTO nag_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Titia Zebedee laga Putro James aru John duijon Tai logote ahikena koise, “Shika manu, ami duijon kiba mangibo, etu kori dibi.” ");
INSERT INTO nag_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tai duijon ke koise, “Moi tumikhan karone ki kori dibo?” ");
INSERT INTO nag_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tai duijon pora Jisu ke koise, “Kitia Apuni singhason te bohibi, Apuni laga mohima pora bhorta thaka rajyote, titia, duijon nimite, ekjon Apuni laga dyna hath aru dusra Apuni laga baya hathte bohibo dibi.” ");
INSERT INTO nag_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kintu Jisu taikhan ke koise, “Tumi duijon ki mangi ase, etu najani kene mangi ase, duijon Moi khabole thaka kup pora khabo paribo, aru Moi ki baptizma pora baptizma lobole ase etu paribo? ");
INSERT INTO nag_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Duijon Taike koise, “Amikhan paribo.” Titia Jisu taikhan ke koise, “Duijon Ami khabole thaka kup pora khabole to hosa ase, aru Moi ki baptizma pora baptizma kori bole ase, etu bhi hobo. ");
INSERT INTO nag_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kintu Ami laga dyna aru baya phale bohi bole to Moi dibo napare, kintu etu to kun nimite rakhikena ase, tai he pabo.” ");
INSERT INTO nag_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aru jitia dos jon chela khan etu kotha hunise, taikhan James aru John duijon ke bisi khong hoise. ");
INSERT INTO nag_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kintu Jisu taikhan ke mati anikena koise, “Tumikhan jani ase na, Porjati khan kun taikhan laga adhikari khan ase koi kene mane, eitu khan pora he taikhan uporte raj kore aru taikhan laga daruga khan pora taikhan uporte adhikar cholai thake. ");
INSERT INTO nag_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kintu tumi majot to eneka nahobi, kintu jun dangor hobole mon kore tai tumi laga nokor hobo dibi. ");
INSERT INTO nag_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aru jun age hobole mon kore taike sob laga ses te thakibo dibi. ");
INSERT INTO nag_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kelemane Manu laga Putro bhi sewa lobole aha nohoi, kintu sewa kori bole aru bisi manu ke bacha bole nijor jibon dibole ahise.” ");
INSERT INTO nag_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Titia taikhan Jericho sheher te ahise. Aru ta te pora Tai aru chela khan aru taikhan logot bisi manu Jericho pora ulai jai thakise, titia Timaeus laga chokra Bartimaeus koi kene andha ekjon rasta kinar te bohi kene bhikh mangi thakise. ");
INSERT INTO nag_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aru jitia tai etu Nazareth Jisu ase koi kene janise, tai hala kori kene koise, “Jisu, David laga Putro, moike daya koribi!” ");
INSERT INTO nag_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Titia bisi manu taike gali dikena chup thaki bole koise. Kintu tai arubi jor pora hala kori kene koise, “David laga Putro, moike daya koribi!” ");
INSERT INTO nag_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Titia Jisu rukhise aru taike mati bole koise. Etu nimite taikhan pora andha manu ke koise, “Mon dangor koribi! Uthibi! Tai tumike mati ase.” ");
INSERT INTO nag_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aru tai uthikena tai bahar te lagai thaka kapra ke ulaikene phelai dise aru Jisu logote ahise. ");
INSERT INTO nag_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aru Jisu taike koise, “Moi tumi karone ki kori dibo?” Andha manu Taike jowab dise, “Rabbi, moike dikhi pabo dibi.” ");
INSERT INTO nag_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Titia Jisu taike koise, “Jai jabi. Tumi laga biswas he tumike bhal kori dise.” Aru etu loge-logote tai dikhibow parise, aru Jisu laga piche korise. ");
INSERT INTO nag_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aru jitia Jisu aru chela khan Jerusalem te, aru Oliv Pahar kinar Bethphage aru Bethany nogorkhan te ahise, aru taikhan age jabole Jisu pora duijon chela ke pathaise. ");
INSERT INTO nag_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Aru Tai taikhan ke koise, “Jabi usor thaka bosti te, aru tumi ta te puncha loge-loge gadha puwali juntu uporte kun manu bhi boha nai, etu bandhi thaka pabo. Etu ke Khuli Kena loi anibi. ");
INSERT INTO nag_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aru jodi kunba tumike kunba eneka hude, ‘Kile eneka kori ase?’ Titia taike kobi, ‘Probhu ke etu lagi ase, titia tai joldi pathai dibo.’” ");
INSERT INTO nag_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Karone taikhan jaise aru etu gadha puwali ke dorja bahar rasta te bandha paise, aru taikhan khuli loi anise. ");
INSERT INTO nag_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kintu kunba manu ta te khara khan pora hudise, “Etu ki kori ase, gadha puwali ke kele khuli ase?” ");
INSERT INTO nag_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aru Jisu pora kowa nisena taikhan etu manu ke koise, etu pichete taikhan ke jabole dise. ");
INSERT INTO nag_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Titia taikhan gadha puwali loi anise, aru taikhan nijor kapra etu uporte bichai dise, aru Tai etu uporte bohi jaise. ");
INSERT INTO nag_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aru bisi manu nijor kapra rasta te bichai dise, aru dusra khan ghas laga daal kati ani rasta te bichai dise. ");
INSERT INTO nag_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tai laga age ja-a khan aru piche kora khan sob hala kori kene koise, “Hosanna dhoinyo ase jun Probhu laga naam te ahise. ");
INSERT INTO nag_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Probhu naam pora ami laga baba David laga rajyo loi aha ke dhoinyo! Hosanna Tai laga naam untcha koribi! ");
INSERT INTO nag_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aru Jisu Jerusalem sheher te ahi kene mondoli te jaise, aru Tai ghuri kene sob saise, aru bisi deri huwa karone, Tai baroh jonke loi kene Bethany te jai jaise. ");
INSERT INTO nag_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aru dusra din jitia taikhan Bethany pora ulai ahise, Tai bhuk lagise. ");
INSERT INTO nag_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aru dur pora ekta dimoru ghas te pata thaka dikhi kene ta te kiba pabo bhabi kene Tai etu usor jaise. Kintu Tai khali pata he thaka paise, kelemane etu somoi to dimoru guti dibole somoi nohoi, ");
INSERT INTO nag_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Titia Jisu pora etu ghas ke koise, “Etiya pora kun bhi tumi laga phol aru nakhabo.” Aru Tai chela khan etu kotha kowa hunise. ");
INSERT INTO nag_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Etu pichete taikhan Jerusalem sheher te ahise aru Jisu mondoli bhitor te jaise. Ta te bikiri kori thaka aru kini thaka khan ke bahar te ulai dise, aru taikhan laga mezkhan ultai dise aru kabotar bikiri kori thaka khan laga chowki bhi ultai dise. ");
INSERT INTO nag_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aru Tai kunke bhi eku jinis mondoli bhitor te loi aha-juwa kori bole diya nai. ");
INSERT INTO nag_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Titia Tai sikhai dikene koise, “Isor kotha te eneka likha ase nohoi, ‘Ami laga ghor to sob jati khan karone prathana ghor hobo?’ Kintu tumikhan etu ke chor dokait laga ghor bonai dise.” ");
INSERT INTO nag_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aru mukhyo purohit khan aru niyom likha khan etu hunise aru Taike khotom kori bole bisarise. Taikhan bhoi korise, kelemane sob manu Tai laga kotha huni kene asurit hoi thaka karone. ");
INSERT INTO nag_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aru jitia saam ahise, Tai sheher pora bahar te ulai jaise. ");
INSERT INTO nag_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Aru dusra din phojur jitia taikhan jai asele, taikhan etu dimoru ghas to tai laga jor tak sukhi ja dikhise. ");
INSERT INTO nag_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aru Peter laga monte ahise, aru tai Jisu ke hudise, “Rabbi, sabi! Dimoru ghas junke Apuni shrap disele, etu sukhi jaise.” ");
INSERT INTO nag_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Karone Jisu taikhan ke koise, “Isor ke biswas rakhibi. ");
INSERT INTO nag_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kelemane Moi tumikhan ke hosa kobo, jun bhi etu ‘pahar ke yate pora ulai samundar te dubi jabi,’ eneka chinta nathakikena etu hoi jabo biswas thakile, etu bhi hoi jabo. ");
INSERT INTO nag_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Karone Moi tumikhan ke kobo, tumikhan prathana te ki mangise, etu sob paise koi kene biswas korile etu pabo. ");
INSERT INTO nag_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aru jitia tumikhan prathana kori bole hoi, jodi tumi laga monte kunba ke biya pai thakile, taike maph kori dibi, eneka korise koile tumi laga sorgote thaka Baba bhi tumi laga golti maph kori dibo. ");
INSERT INTO nag_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kintu jodi tumikhan manu ke maph nadile tumi laga sorgo Baba bhi tumikhan laga golti maph nadibo.” ");
INSERT INTO nag_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jitia Jisu aru chela khan aru Jerusalem sheher te ahise, aru Tai mondoli te berai thakise, titia mukhyo purohit khan, niyom likha khan aru bura khan tai logote ahise. ");
INSERT INTO nag_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aru taikhan hudise, “Apuni ki hokti pora etu sob kori ase Aru kun Tumike etu kori bole dise?” ");
INSERT INTO nag_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kintu Jisu taikhan ke jowab di koise, “Moi bhi tumikhan ke ekta kotha hudibo. Moike kobi, aru Moi bhi tumikhan ke kobo Moi ki takot pora eitu khan kori ase. ");
INSERT INTO nag_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","John pora baptizma diya to sorgo pora ahise, na manu pora ahise? Moike jowab dibi.” ");
INSERT INTO nag_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Titia taikhan majote kotha patise, “Jodi amikhan sorgo pora ase koile, Tai kobo, ‘Tumikhan kele taike biswas kora nai?’ ");
INSERT INTO nag_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kintu jodi amikhan ‘Manu pora’ koile .....” Bisi manu pora John ke bhabobadi mani thake nimite taikhan bhoi kori thakise. ");
INSERT INTO nag_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Karone taikhan Jisu ke koise, “Amikhan najane.” Karone Jisu taikhan ke koise, “Moi bhi tumikhan ke Moi ki laga takot pora etu sob kaam kori ase nokobo.” ");
INSERT INTO nag_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Titia Jisu dristanto pora manu khan ke koise, “Ekjon manu draikha baari ekta bonaise, aru char kona phale bera lagai dise, aru ros khunda jaga bonaise, aru machang bonai kene kunba kaam kora manu ke theka di dikena tai to safar te ulai jaise. ");
INSERT INTO nag_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jitia ros ulabole somoi ahise, malik pora nokor ke angur pabo pare bhabi kene draikha baari te kaam kora manu khan logote pathaise. ");
INSERT INTO nag_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kintu taikhan pora nokor ke dhori kene marise, aru taike khali hath pathai dise. ");
INSERT INTO nag_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Titia tai aru dusra ekjon nokor ke pathaise, hoilebi taikhan etu nokor laga matha te pathor pora mari dikena jokhom kori dise aru sorom khilai se. ");
INSERT INTO nag_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aru tai dusra ekjon ke pathaise, aru etu bar to nokor ke morai dise. Tai bisi manu ke pathaise: kintu taikhan arubi kunba ke marise, aru dusra khan ke morai dise. ");
INSERT INTO nag_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tai logot pathabole ekjon he thaki jaise, tai laga ekjon morom thaka chokra. Tai eneka bhabona korise, ‘Taikhan bhi ami laga chokra ke to morom koribo.’ ");
INSERT INTO nag_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kintu kaam kora manu taikhan bhithor te kotha korise, ‘etu to uttoradhikari ase, ahibi amikhan taike morai dibo, aru tai laga sob to amikhan laga hoi jabo.’ ");
INSERT INTO nag_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aru taikhan taike loijai kene mari dise, aru taike draikha baari bahar te phelai dise. ");
INSERT INTO nag_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Karone etiya draikha baari laga malik ki koribo? Tai ahi kene kaam kora manu khan ke khotom kori dibo, aru draikha baari to dusra ke di dibo. ");
INSERT INTO nag_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tumikhan Shastro te porha nai naki? ‘Pathor mistiri khan pora chari diya pathor kona te thakise, Aru etu he ghor khara kora laga asol pathor hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Etu Probhu pora he hoise, Ami laga suku pora sabole bisi asurit ase.’” ");
INSERT INTO nag_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aru mukhyo purohit khan, niyom hika khan aru bura khan buji jaise Tai taikhan bhirodh te etu dristanto koise, aru taike dhori bole bhabisele, kintu manu ke bhoi pora chari dise aru jai jaise. ");
INSERT INTO nag_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Titia Yehudi cholauta khan Jisu laga kotha pora Taike dhori bole kunba Pharisee aru Herod laga manu khan ke Tai logote pathaise. ");
INSERT INTO nag_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aru taikhan koise, “Shika manu, amikhan jane Apuni hosa ase, aru kunke bhi bhoi nakore, kelemane Apuni manu laga mukh saikene kotha nakore, kintu Isor laga hosa rasta he sikhai, karone Caesar ke masul diya to thik ase na nai? Moi khan etu dibo lage na nai?” ");
INSERT INTO nag_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kintu Tai taikhan laga chalak jani kene koise, “Kile Moike porikha kori ase? Ekta chandi poisa anikena Moike dikhabi.” ");
INSERT INTO nag_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Karone taikhan ekta anise, aru Tai koise, “Etu kun laga chehera aru naam ase?” Taikhan koise, “Caesar laga ase.” ");
INSERT INTO nag_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aru Jisu taikhan ke jowab dise, “Eneka hoile ki Caesar laga ase, Caesar ke di dibi, aru ki Isor laga ase, etu Isor ke dibi.” Aru taikhan Taike asurit hoise. ");
INSERT INTO nag_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Titia Sadducee jun khan mora pora jee na uthibo koi, Tai logote ahise. Aru Taike hudise, ");
INSERT INTO nag_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Shika manu, Moses he amikhan ke etu niyom likhi disele, jodi kunba bhai bacha nathaki kene mori jai, aru tai laga maiki to thake, titia tai bhai he etu maiki ke lobo aru tai bhai laga naam age loi jabole koise. ");
INSERT INTO nag_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tinehoile age te sat-ta bhai asele, prothom bhai shadi kori kene bacha nathaki kene mori jaise. ");
INSERT INTO nag_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aru dusra bhai etu ke loise aru etu bhi bacha nohoi kene mori jaise, aru tisra bhai ke bhi thik eneka he hoise. ");
INSERT INTO nag_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aru sat-ta bhai sob taike loise aru bacha nathaki kene sob mori jaise, pichete etu maiki bhi mori jaise. ");
INSERT INTO nag_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Karone jee utha pichete tai kun laga maiki hobo? Kelemane tai sat jon bhai laga maiki thakisele.” ");
INSERT INTO nag_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisu taikhan ke koise, “Tumikhan Shastro te likha kotha khan aru Isor laga hokti najana karone golti kori thake nohoi? ");
INSERT INTO nag_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kelemane jitia taikhan mora pora jee uthibo taikhan shadi nakoribo, kintu sorgote Isor laga duth nisena thaki jabo. ");
INSERT INTO nag_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kintu mora pora jee utha kotha khan nimite tumikhan Moses laga kitab te porha nai, joli thaka jhari te, kineka Isor he taike eneka koisele, ‘Moi Abraham laga Isor, Isaac laga Isor, aru Jacob laga Isor ase?’ ");
INSERT INTO nag_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Isor to mora khan laga Isor nohoi, kintu jinda khan laga Isor ase etu karone tumikhan bisi dangor golti kori thake.” ");
INSERT INTO nag_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Titia ekjon niyom likha jon pora taikhan etu kotha kori thaka hunise. Aru Jisu pora etu laga thik jowab diya huni kene, tai Jisu ke hudise, “Sob pora prothom hukum to ki ase?” ");
INSERT INTO nag_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisu taike koise, “Sobse poila, ‘Huni bhi Israel, sob pora prothom hukum to amikhan laga Probhu he Isor ase, aru ekjon he Probhu ase. ");
INSERT INTO nag_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Aru tumi pura mon, pura atma, pura dimag, aru pura takot pora Probhu Isor ke morom koribi.’ ");
INSERT INTO nag_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aru dusra hukum to etu kowa ase, ‘Tumi laga ghor usor manu khan ke nijor nisena morom koribi.’ Etu duita pora dusra dangor hukum aru nai.” ");
INSERT INTO nag_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Karone likha manu Taike koise, “Bhal Shika manu! Apuni hosa pora koi dise, kelemane Isor ekjon he ase, aru Taike chari kene dusra nai. ");
INSERT INTO nag_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aru pura mon, pura dimag, pura atma, aru pura takot pora Isor ke morom kora, aru usor manu khan ke nijor nisena morom kora to daan kora aru bolidan diya pora bhi bisi dangor ase.” ");
INSERT INTO nag_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jitia Jisu tai bhal jowab diya dikhise, Tai taike koise, “Tumi Isor laga rajyo pora dur nohoi.” Etu pichete, kun bhi Jisu ke aru kiba hudibole mon dangor kora nai. ");
INSERT INTO nag_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pichete, Jisu mondoli laga bahar jagate sikhai thakise, Tai hudise, “Kanun likha khan to kineka Khrista to David laga chokra ase koi thake?” ");
INSERT INTO nag_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kelemane David to Pobitro Atma te bhorta hoi kene eneka koise, ‘Probhu he ami laga Probhu ke koise, “Ami laga dyna hath phale bohi thakibi, Jitia tak Moi pora tumi laga dushman khan ke tumi laga theng nichete nadibo, titia tak.’” ");
INSERT INTO nag_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David tai nijor Taike ‘Probhu’ koise, to David laga chokra tai kineka hobo? Aru bisi manu khan Tai kotha ke shanti pora huni asele. ");
INSERT INTO nag_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Titia Jisu sikhai thaka somoite taikhan ke koise, “Likha manu khan pora hoshiar thakibi, jun kapra lamba kori lagai berai thake, aru bajar te salam diya bhal pai, ");
INSERT INTO nag_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","mondoli te bhal jaga, aru kha luwa te bhal jaga bisara khan. ");
INSERT INTO nag_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Taikhan bidhowa khan laga ghor hajam kori diye, aru bahana pora lamba prathana kori thake, eitu khan bisi dangor saja pabo.” ");
INSERT INTO nag_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Titia Jisu mondoli te daan diya daba usorte bohi kene sai thakise jun khan ahikena daba te poisa haali thakise. Aru dhuni khan bisi-bisi di thakise. ");
INSERT INTO nag_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Titia gorib bidhowa ahikena duita paisa dise. ");
INSERT INTO nag_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Titia Tai chela khan ke mati anikena koise, “Moi tumikhan ke hosa kobo. Manu khan daba te daan diya te etu gorib bidhowa he sob pora bisi dise. ");
INSERT INTO nag_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kelemane sob manu taikhan nijor dhun bisi thaka pora dise. Kintu tai to bisi nathakilebi tai logote ki ase etu sob dise, motlob tai jinda thakibo laga sob di dise.” ");
INSERT INTO nag_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jitia Jisu mondoli pora ulaikene jai thakise, chela ekjon Taike koise, “Sikha manu, sabi, kineka bhal asurit pathor ase etu, aru kiman asurit ghor ase yate? ");
INSERT INTO nag_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aru Jisu jowab di taike koise, “Tumi etu dangor ghor dikhi ase? Yate ekta pathor bhi ekta uporte nathiki jabo, sob pathor ke girai dibo.” ");
INSERT INTO nag_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Titia Tai mondoli samne te Oliv Pahar te bohi asele, titia Peter, James, John aru Andrew taikhan lukaikene Taike hudise. ");
INSERT INTO nag_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Etu sob kotha kitia hobo, etu amikhan ke koi dibi, aru kitia etu sob kotha pura hobole hoi, etu laga chihna kineka hobo?” ");
INSERT INTO nag_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aru Jisu taikhan ke jowab di koise, “Hoshiar hobi, kun pora bhi tumikhan ke thogabo nadibi. ");
INSERT INTO nag_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kelemane bisi manu Ami laga naam loi ahikena kobo, ‘Moi he Tai ase,’ aru bisi manu ke thogai loijabo. ");
INSERT INTO nag_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kintu jitia tumikhan lorai aru mara-mari laga awaj hunibo, titia chinta nokoribi, kelemane eitu khan hobole dorkar ase, kintu etu bhi hekh somoi nohoi. ");
INSERT INTO nag_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kelemane ekta desh pora dusra desh ke bhirodh koribo, ekta rajyo pora dusra rajyo ke bhirodh koribo, aru jaga-jagate mati hili bo, aru titia khabole eku napabo. Etu sob to bacha jonom hobole shuru te bikha nisena ase. ");
INSERT INTO nag_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tumikhan nijor hoshiar thakibi. Ami nimite tumikhan ke dhori kene sabhakhan te aru mondoli khan te di dibo, tumikhan ke maribo, pitibo, aru tumikhan ke sorkar aru raja khan usorte loijabo, taikhan nimite gawahi hobole. ");
INSERT INTO nag_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kintu prothom te susamachar sob jati ke prochar kori dibo lagibo. ");
INSERT INTO nag_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jitia taikhan pora tumikhan ke dhori kene manu laga hathte di dibo, tumikhan ki kobo lage, etu nimite chinta na koribi, kintu tumikhan utu somoite ki kobo lage, etu he koi dibi, kelemane tumikhan pora nokobo, kintu Pobitro Atma pora he kobo. ");
INSERT INTO nag_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Titia bhai pora bhai ke dhurikena morai dibo, aru baba pora bacha ke morai dibo, bacha khan pora nijor ama-baba laga bhirodh hoi kene taikhan ke morai dibo. ");
INSERT INTO nag_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Aru Ami karone sob tumikhan ke ghin koribo, kintu hekh tak jun dhorjo thakibo paribo tai he poritran pabo. ");
INSERT INTO nag_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kintu jitia paap laga ghin kaam khotom kora ke kuntu jagah te khara nathakibole lage ta te khara kora tumikhan dikhile- kun porhibo tai he bujhi bole dibi- titia jun Judea te ase, pahar te polai jabi, ");
INSERT INTO nag_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jun ghor uporte ase, taike niche najabole aru jai kene ghor bhitor pora kiba bahar te ulabole nadibi. ");
INSERT INTO nag_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aru jun kheti te ase, taike nijor kapra lobole ghuri ahibo nadibi. ");
INSERT INTO nag_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kintu etu dinte jun maiki khan pet te bacha bukhi se, aru jun bacha dudh khilai thakise, taikhan nimite hai ase. ");
INSERT INTO nag_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Etu sob thanda dinte nohobo nimite prathana kori thakibi. ");
INSERT INTO nag_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kelemane etu din eneka dukh din hobo, jitia shuru pora Isor sristi bona homoi pora aji tak eneka dukh aha nai, aru kitia bhi nohobo. ");
INSERT INTO nag_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aru jodi Probhu he etu din to khata kori nadile kunbi bachibole nohoi, kintu basi luwa khan karone Tai etu din khan khata kori dise. ");
INSERT INTO nag_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aru jodi kunba tumikhan ke kobo, ‘Sabi, Khrista yate ase nohoile, ‘Sabi Tai ta te ase,’ etu biswas na koribi. ");
INSERT INTO nag_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kelemane misa khrista aru misa bhabobadi ahibo, aru chihna aru asurit dikha bo, aru jodi parile basi luwa khan ke bhi thogai loijabo. ");
INSERT INTO nag_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kintu hoshiar thakibi, sabi Moi age pora tumikhan ke koi ase. ");
INSERT INTO nag_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kintu etu dukh din laga pichete Suryo andhera hoi jabo, Aru chand bhi ujala nadibo. ");
INSERT INTO nag_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Titia akas laga tara bhi giri jabo, Aru akas laga hokti hili jabo ");
INSERT INTO nag_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Titia Manu laga Putro dangor hokti aru mohima hoi badal pora aha taikhan dikhibo. ");
INSERT INTO nag_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Titia Tai duth khan ke pathai kene prithibi laga kona pora akas laga kona tak, char phale hawa pora Tai basi luwa sobke joma kori lobo. ");
INSERT INTO nag_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Titia dimoru ghas pora dristanto sikhi lobi, jitia ghas laga daal komoliya hoi, aru pata ulabole hoi, gorom din usor hoise koi kene tumikhan jani jai. ");
INSERT INTO nag_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Etu karone jitia etu sob hoi thaka dikhile jani lobi Jisu dorja usorte ahi jaise. ");
INSERT INTO nag_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Moi tumikhan ke hosa kobo, jitia tak etu sob kotha pura nohobo, titia tak etu yug laga manu khan harai najabo. ");
INSERT INTO nag_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Akas aru prithibi harai jabo, kintu Ami laga kotha khan kitia bhi naharabo. ");
INSERT INTO nag_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kintu etu din aru etu somoi kun bhi najane, sorgodoth khan bhi, aru Putro bhi najane, kintu khali Baba he jane. ");
INSERT INTO nag_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hoshiar pora sai thakibi, uthi kene prathana kori thakibi kelemane tumikhan najane etu somoi kitia ahibo. ");
INSERT INTO nag_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Etu to ekjon manu pora tai laga nokorkhan ke adhikar dikene, taikhan sobke nijor kaam dikene aru chokidar ke bhal pora sob sai thaki bole hukum dikene dusra jagate jai ja nisena ase. ");
INSERT INTO nag_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Karone hoshiar thakibi, kelemane tumikhan najane, malik kitia ghor te ahibo, saam te hobo na adha rati te hobo, na murga hala kora homoi te hobo, nohoile phojurte hobo. ");
INSERT INTO nag_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tai achanak ahikena tumikhan ghumai thaka pai jabo pare. ");
INSERT INTO nag_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Etu pora Moi tumikhan ke ki koise, Moi sobke koi ase; Hoshiar hoi thakibi!” ");
INSERT INTO nag_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dui din pichete Khomir Nathaka Roti laga Purbb hobole asele. Aru prodhan purohit khan aru niyom likha khan kineka kori Taike thogai dikene morai dibole bisari asele. ");
INSERT INTO nag_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kintu taikhan apaste eneka koi thakise, “Purbb dinte eneka nohobo lage, kelemane manu majote gondugol kori biya hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jitia Jisu Bethany te Simon junke korhi bemar thakise, tai laga ghor te kha luwa kori bole bohi asele, ekjon mahila ekta alabaster daba te bisi daam laga abhishek kora shudh tel loi anise. Aru tai etu khuli kene Jisu laga matha te hali dise. ");
INSERT INTO nag_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kintu kunba biya paikene ekjon-ekjon ke koise, “Kile etu abhishek tel borbad kori ase? ");
INSERT INTO nag_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kilekoile etu tel bikiri korile tin-sou dinar pora bhi bisi pabo, aru loi kene dukhiya khan ke dibo pare.” Eneka hoi kene taikhan tai bhirodh te kotha korise. ");
INSERT INTO nag_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kintu Jisu pora taikhan ke koise, “Taike chari- dibi, tumikhan kele taike digdar kori ase? Tai Moi karone bhal kaam korise. ");
INSERT INTO nag_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dukhiya khan hodai tumikhan logote thakibo, aru jitia itcha hoi, taikhan ke bhal kaam koribo pare, kintu Moi hodai tumikhan logote nathakibo. ");
INSERT INTO nag_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tai ki koribo pare, etu tai kori dise. Moike matite moidam diya age te tai tel loi kene Moi laga gaw te haali kene abhishek kori dise. ");
INSERT INTO nag_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Moi tumikhan ke hosa kobo, pura prithibi te susamachar prochar kori juwa te etu mahila kori diya laga kotha bhi taike yaad thakibo karone kobo.” ");
INSERT INTO nag_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Titia Iscariot Judas baroh jon majot te ekjon asele, Jisu ke dhori dibole prodhan purohit khan logote jaise. ");
INSERT INTO nag_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aru etu huni kene taikhan bisi khushi hoi kene taike poisa dibole koi dise, karone tai etu somoi pora Taike dhori dibole bhal somoi sai thakise. ");
INSERT INTO nag_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Khomir nathaka Roti Purbb laga prothom din, jitia taikhan Nistar laga mer bacha ke bolidan di thakise, Tai chela khan Taike hudise, “Kun jagah te amikhan Nistar purbb nimite taiyar kori bole Apuni laga itcha ase?” ");
INSERT INTO nag_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aru Tai duijon chela ke pathai kene koise, “Sheher te jabi, aru ekjon ekta kolsi te pani loi juwa pai jabo, tai piche-piche jabi. ");
INSERT INTO nag_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aru kot te tai jabo ta te tumi bhi jabi, aru jai kene ghor malik ke kobi, ‘Shika manu koise, “Alohi khan karone jagah kot te ase? Ami laga chela khan logote kot te Nistar khabo?’” ");
INSERT INTO nag_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Titia tai sapha kori rakhi thaka uporte ekta kamra dikhai dibo, ta te amikhan karone taiyar kori kene rakhibi.” ");
INSERT INTO nag_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Titia tai laga duijon chela sheher te ahise, aru jineka Tai taikhan ke koise thik tineka paise aru taikhan Nistar nimite taiyar kori rakhise. ");
INSERT INTO nag_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jitia saam hoise, Jisu aru chela baroh jon ahise. ");
INSERT INTO nag_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jitia taikhan khai asele titia Jisu koise, “Moi tumikhan ke hosa kobo, tumikhan majote ekjon jun Moi logote kha luwa kori ase tai Moike thogai dibo.” ");
INSERT INTO nag_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aru taikhan bisi mon dukh hoise, aru Taikhan ekjon-ekjon kori sob Taike hudise, “Etu moi ase?” ");
INSERT INTO nag_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tai taikhan ke jowab di koise, “Etu baroh jon te ekjon ase, jun Moi logote eke thali te bhi jai kene khai ase. ");
INSERT INTO nag_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kelemane Manu laga Putro nimite jineka Isor laga kotha te likhi rakhise, tineka hoi ase. Kintu jun pora Manu laga Putro ke thogai di dise, taike hai ase! Tai to jonom nohoile he tai nimite bhal hobo asele.” ");
INSERT INTO nag_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aru jitia taikhan khai thakise, titia Jisu roti loise aru dhonyabad diya pichete bhangai se, aru taikhan ke eneka koi kene dise, “Lobi aru khabi. Etu Ami laga gaw ase.” ");
INSERT INTO nag_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Titia Tai kup loi kene Isor ke dhanyavad dise aru taikhan ke dise. Aru taikhan sob etu pora pi loise. ");
INSERT INTO nag_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aru Tai taikhan ke koise, “Etu khun to bisi manu karone Moi bahai diya khun laga vachan ase. ");
INSERT INTO nag_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Moi tumikhan ke hosa kobo, Isor laga rajyote notun angur phol laga ros napiya tak Moi aru etu napibo.” ");
INSERT INTO nag_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aru titia taikhan gana kori loise, taikhan Oliv Pahar te jai jaise. ");
INSERT INTO nag_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Titia Jisu taikhan ke koise, “Tumikhan sob Moike charikena jai jabo, etu Isor kotha te likha ase, ‘Moi roikhya ke maribo Aru mer khan ephale-uphale hoi jabo.’ ");
INSERT INTO nag_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kintu Moi jee utha pichete tumi pora age Galilee te jai jabo.” ");
INSERT INTO nag_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kintu Peter Taike koise, “Jodi sob manu giri le bhi, moi to nohobo.” ");
INSERT INTO nag_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisu taike koise, “Moi tumike hosa kobo, aji rati murga duibar hala nakora age te tumi tin bar Moike najana kobo.” ");
INSERT INTO nag_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kintu tai aru jor pora koise, “Jodi Apuni logote moribo koile bhi, moi Apuni ke kitia bhi najana nokobo.” Aru sob chela khan bhi tineka koise. ");
INSERT INTO nag_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Titia taikhan Gethsemane naam ekta jagate ahise, aru Jisu Tai chela khan ke koise, “Moi prathana kori thaka somoite yate bohibi.” ");
INSERT INTO nag_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aru Tai Peter, James aru John ke loi kene tai logote jaise, aru Tai bisi dukh aru chinta bhabona hoise. ");
INSERT INTO nag_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tai koise, “Ami laga atma bisi dukh hoise, mori bole nisena. Na ghumai kene yate rukhi thakibi.” ");
INSERT INTO nag_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Titia olop dur jai kene, Jisu niche giri prathana korise, jodi parile etu somoi ke Tai pora dur kori dibole. ");
INSERT INTO nag_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aru Tai koise, “Abba, Baba Apuni to sob koribo pare. Moi pora etu kup hatai dibi. Hoile bhi Ami laga itcha nohoi kintu jineka Apuni laga itcha ase, eneka koribi.” ");
INSERT INTO nag_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Titia Tai ahikena tinjon to ghumai thaka paise aru Peter ke koise, “Hey Peter, tumi ghumai jaise? Tumi ek-ghanta bhi rukhibo napare? ");
INSERT INTO nag_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tumikhan porikha te nagiribo karone na ghumai kene prathana kori thakibi, Atma to taiyar ase kintu gaw to komjur ase.” ");
INSERT INTO nag_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aru Tai jai kene age te kowa nisena koi kene prathana korise. ");
INSERT INTO nag_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aru jitia Tai wapas ahise, arubi tinjon ke ghumai thaka paise kelemane taikhan laga suku nindh pora bhorta asele. Aru Taike ki jowab dibo najana hoi thakise. ");
INSERT INTO nag_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Titia tin-bar ahi kene taikhan ke koise, “Tumikhan etiya bhi aram pora ghumai ase? Hoise! Somoi ponchise. Sabi! Manu laga Putro ke dhori kene paapi khan laga hathte di dibole hoise. ");
INSERT INTO nag_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Uthibi, amikhan jai jabo, sabi, Moike thoga manu usor ase.” ");
INSERT INTO nag_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Aru tai etu kotha koi thaka somoite, Judas baroh jon te ekjon to, prodhan purohit, likha manu aru bura khan pora pathai diya talwar, lathi aru bisi manu loi ahise. ");
INSERT INTO nag_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Taike thogai diya manu taikhan ke ekta chihna disele, “Junke moi chuma dibo, etu ase, Taike dhori lobi, aru dhuri kene loijabi.” ");
INSERT INTO nag_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aru jitia Judas ahise, tai joldi ahi kene Jisu ke koise, “Rabbi,” aru Taike chuma dise. ");
INSERT INTO nag_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Titia taikhan ahi kene hath pora Taike dhori loise. ");
INSERT INTO nag_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aru ta te usorte khara thaka ekjon talwar ulaikene moha purohit laga nokor uporte cholai dise, aru tai laga kan kati dise. ");
INSERT INTO nag_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Titia Jisu taikhan ke jowab dise, “Tumikhan Moike daku bhabi kene Moike dhori bole talwar aru lathi loi ahise? ");
INSERT INTO nag_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Moi hodai din mondoli te tumikhan logote bohi prochar kori thakise, aru tumikhan Moike dhora nai, kintu Shastro te likha pura hobo karone eneka hoise.” ");
INSERT INTO nag_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Titia Jisu laga chela khan sob Taike chari kene polai jaise. ");
INSERT INTO nag_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aru ekjon jawan chokra kapra napindi kene bodon te ekta mihin kapra lagai kene Jisu laga piche kori ahi thakise. Aru kunba manu khan pora taike dhori loise, ");
INSERT INTO nag_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kintu tai pindhi thaka mihin kapra chari dise aru eku kapra napindhi kene polai jaise. ");
INSERT INTO nag_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aru taikhan Jisu ke loi kene moha purohit logote jaise, aru ta te prodhan purohit khan, niyom likha khan aru bura khan sob joma hoise. ");
INSERT INTO nag_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kintu Peter dur hoi kene Tai piche-piche ahi moha purohit laga veranda te nokorkhan logote jui thapi thakise. ");
INSERT INTO nag_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Titia prodhan purohit aru sob maha sabha Taike morai dibole Jisu laga bhirodh misa kotha bisarise kintu eku pa-a nai. ");
INSERT INTO nag_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kelemane bisi manu Tai bhirodh te misa kotha koi dise, kintu taikhan laga kotha thik mila nai. ");
INSERT INTO nag_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Titia kunba khara hoi kene Tai bhirodh te misa kotha di koise. ");
INSERT INTO nag_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tai eneka kowa amikhan hunise, ‘Moi manu hath pora bonai rakha etu mondoli ke bhangai dikene, aru tin dinte dusra juntu hath pora bona nohoi, etu ke bonai dibo.” ");
INSERT INTO nag_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kintu titia bhi taikhan laga kotha thik milabo para nai. ");
INSERT INTO nag_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aru moha purohit taikhan majote uthi kene Jisu ke hudise, “Apuni eku bhi nokobo? Manu khan Apuni bhirodh te ki koi ase?” ");
INSERT INTO nag_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kintu Tai ekdom chup thakise. Aru eku jowab diya nai. Aru moha purohit Taike hudi koise. “Apuni Dhoinyo Jon laga Putro Khrista ase?” ");
INSERT INTO nag_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisu koise, “Moi ase; Aru tumikhan dikhibo Manu laga Putro ke dikhibo Jitia Tai hokti laga dyna hath phale bohibo Aru akas laga badal pora ahi thaka dikhibo.” ");
INSERT INTO nag_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Titia moha purohit bisi ghusa hoi kene tai laga kapra phatai kene koise, “Etiya amikhan ki gawah dibo lage? ");
INSERT INTO nag_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Apuni khan bhi Isor laga ninda kowa hunise. Apuni khan ki bhabi ase?” Aru taikhan sob taike morai dibo lage koise. ");
INSERT INTO nag_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Titia kunba Tai uporte thuki se, aru tai laga mukh dhakai dise, aru Taike marikena koise, “Bhabobani kobi!” Aru daruga khan bhi Taike loi jaise aru thapor marise. ");
INSERT INTO nag_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Etu homoi te Peter nichete bohi asele aru moha purohit laga nokorni ta te ahise. ");
INSERT INTO nag_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aru taike koise, “Tumi bhi Nazareth Jisu logote asele nohoi?” ");
INSERT INTO nag_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kintu tai nohoi koise, “Moi najane, tumi ki koi ase moi bujhi panai.” Aru tai bahar ulai jaise. ");
INSERT INTO nag_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aru etu nokorni taike aru dikhi kene usor thaka khan ke koise, “Etu manu bhi taikhan logot ekjon ase!” ");
INSERT INTO nag_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kintu tai nohoi koi dise, aru olop, pichete ta te khara thaka ekjon pora Peter ke koise, “Hosa ase, tumi bhi taikhan majote ekjon ase, kelemane tumi bhi Galilee manu ase.” ");
INSERT INTO nag_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Titia Tai shrap di kosom khai koise, “Apuni jun laga kotha koi ase moi etu manu ke najane.” ");
INSERT INTO nag_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aru titia dusra bar murga hala korise. Titia Peter Jisu kowa kotha ke bhabona korise, “Murga duibar hala kora age te tumi Moike tin-bar najane kobo,” aru titia tai etu kotha bhabi kene kandise. ");
INSERT INTO nag_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dusra din phojur huwa loge-loge mukhyo purohit khan pora niyom likha khan, bura khan aru pura sabha manu khan kotha milai kene Jisu ke bandi Pilate laga hathte di dise. ");
INSERT INTO nag_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate pora Jisu ke hudise, “Tumi Yehudi laga raja ase?” Tai jowab di taike koise, “Apuni kowa to ase.” ");
INSERT INTO nag_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aru purohit khan Taike bisi kotha te bodnam lagaise. ");
INSERT INTO nag_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Titia Pilate Taike koise, “Apuni eku jowab nadibo? Sabi taikhan Tumi laga bhirodh te ki bodnam lagai ase?” ");
INSERT INTO nag_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kintu Jisu eku kowa nai, karone Pilate bisi asurit hoise. ");
INSERT INTO nag_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aru etu purbb somoi ekta manu bondhi te thaka ke chari dibole niyom thake, kunke taikhan chari dibole itcha kore. ");
INSERT INTO nag_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aru ta te Barabbas naam ekjon manu morai diya taikhan logote bondhi te asele aru jun he bhirodh kori kene manu morai disele. ");
INSERT INTO nag_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Titia bhir pora taike binti korise jineka niyom kori ahise tineka kori dibi koi kene jor pora hala korise. ");
INSERT INTO nag_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kintu Pilate taikhan ke jowab di koise, “Moi tumikhan nimite Yehudi laga Raja ke chari dibo naki?” ");
INSERT INTO nag_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kelemane tai jani asele mukhyo purohit khan he Taike suku joli kene dhori taike di dise. ");
INSERT INTO nag_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kintu mukhyo purohit khan pora Barabbas taikhan ke dibi koi kene manu khan ke chukuli kori dise. ");
INSERT INTO nag_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aru Pilate koise, “Tinehoile moi tumikhan Yehudi laga Raja Taike ki kori dibo?” ");
INSERT INTO nag_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Etu karone taikhan aru hala kori koise, “Taike Cross te mari dibi!” ");
INSERT INTO nag_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Titia Pilate taikhan ke koise, “Kile, Tai ki biya kaam korise?” Kintu taikhan aru bisi jor pora hala kori kene koise, “Taike ke Cross te mari dibi.” ");
INSERT INTO nag_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Karone Pilate bisi manu ke khushi kori dibo itcha pora Barabbas ke taikhan nimite chari dise, aru Jisu ke chabuk mari kene Taike Cross te mari bole di dise. ");
INSERT INTO nag_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Titia sipahi khan Taike raja laga darbar -kuntu ke Praetorium koi- ta te loi jaise aru pura platon joma kori loise. ");
INSERT INTO nag_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aru taikhan begoni rong kapra Taike pindhai dise, aru katta thaka laga mukut bonai kene Tai laga matha te rakhidise. ");
INSERT INTO nag_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aru Taike eneka koi thakise: “Salam, Yehudi laga Raja!” ");
INSERT INTO nag_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Titia taikhan ekta lathi loi kene Tai matha te mari thakise, aru Tai upor thuk phelaise aru athukari kene taike sonman kora nisena kori thakise. ");
INSERT INTO nag_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jitia Taike dhamali kori loise, Taike age te begoni rong kapra pindhai diya to ulaikene Tai nijor kapra lagai dise, aru Taike Cross te mari dibole bahar te loi jaise. ");
INSERT INTO nag_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Titia taikhan Cyrene desh laga Alexander aru Rufus laga baba Simon, jun desh pora ahi asele, taike joborjosti Jisu laga Cross ke loi jabole dhori loise. ");
INSERT INTO nag_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aru taikhan Taike Golgotha- naam motlob ase, “Matha Hardi laga jaga”- ta te loi anise. ");
INSERT INTO nag_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Taike tita pani draikha ros logot milai kene khabo dibole bisarise, kintu Tai etu khanai. ");
INSERT INTO nag_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aru Taike Cross te mari dise, aru chithi kheli kene Tai laga kapra bhag kori loise kun ki pabo koi kene. ");
INSERT INTO nag_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aru tin ghanta somoite taikhan Taike Cross te mari dise. ");
INSERT INTO nag_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aru Tai matha uporte Tai laga golti likhi dise, “Yehudi Khan Laga Raja” koi kene. ");
INSERT INTO nag_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aru Rome sipahi khan pora duita chor bhi Cross te mari dise, ejkon Tai dyna phale, aru dusra Tai laga baya phale. ");
INSERT INTO nag_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aru Taike golti thaka khan logote ginti kori loise koi kene Shastro te likhi diya kotha pura hoise. ");
INSERT INTO nag_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aru rasta te aha juwa kori thaka khan sob nijor laga matha hilai kene hinsa korise, “Ha! Tumi mondoli bhangai dikene, aru tin dinte bonai dibo kowa manu. ");
INSERT INTO nag_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Cross pora niche nami ahi bhi aru nije ke bachai lobi!” ");
INSERT INTO nag_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tineka mukhyo purohit khan bhi niyom likha khan logote mili Taike hinsa kori koise, “Tai dusra ke to bachai thake, kintu Tai nije ke bachabo napare. ");
INSERT INTO nag_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel laga Raja Khrista etiya Cross pora niche namibi, amikhan bhi dikhi kene biswas kori bole,” aru junke Tai logote Cross te disele taikhan bhi Taike ninda korise. ");
INSERT INTO nag_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aru titia choi ghanta somoi hoise, ta te pura desh te baroh baji pora tin baji tak andhera hoi jaise. ");
INSERT INTO nag_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aru tin baji laga homoi te Jisu jor pora hala kori koise, “Eloi, Eloi lama sabachthani?” Motlob ase, “Ami laga Isor, Ami laga Isor, kele Apuni Amike chari dise?” ");
INSERT INTO nag_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jun manu khan Tai usorte khara asele, taikhan etu huni kene koise, “Sabi Tai Elijah ke mati ase.” ");
INSERT INTO nag_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Titia kunba ekjon polaikena spanj jinis ani kene tenga panite bhi jaise aru ekta nol pora Taike khabole dise, aru koise, “Tai ekla ke chari bhi aru sabi, Elijah ahikena Taike namai dibo na nai amikhan sabo!” ");
INSERT INTO nag_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aru Jisu jor pora hala kori Tai laga atma di dise. ");
INSERT INTO nag_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Titia girja laga porda upor pora niche tak phati kene dui tukra hoise. ");
INSERT INTO nag_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ekjon henapoti Tai samne te khara thakisele. Jitia Jisu saas charikena morise, etu dikhi kene tai koise, “Hosa ase, etu manu he Isor laga Putro ase.” ");
INSERT INTO nag_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ta te kunba mahila khan asele jun dur pora sai thakise, Mary Magdalene, aru Mary -chutu James aru Joses laga ama,- aru Salome. ");
INSERT INTO nag_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jitia Tai Galilee te thakisele, eitu khan Tai laga piche-piche ahi Taike sewa kori thakisele, aru bisi mahila khan bhi asele, jun Tai logot te Jerusalem te ahise. ");
INSERT INTO nag_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aru saam hoise, etu Taiyar Din asele, Bisram din laga ek din age. ");
INSERT INTO nag_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimathea nogor te thaka manu Joseph ahise. Tai sabha laga dangor manu asele, aru tai Isor laga rajyo aha rukhi thaka manu asele. Tai mon dangor pora Pilate logote jai kene Jisu laga gaw mangise. ");
INSERT INTO nag_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate asurit hoise, Tai joldi morise koi kene, aru henapoti ke mati ani kene Jisu morise na nai etu hudise. ");
INSERT INTO nag_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jitia tai henapoti pora jani loise, titia Jisu laga gaw Joseph ke dibole koi dise. ");
INSERT INTO nag_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aru Joseph pora Jisu laga gaw namai kene bhal norom kapra pora bandi kene, Taike pathor pora bona kobor te rakhidise, aru kobor laga dorjate ekta pathor pora bondh kori dise. ");
INSERT INTO nag_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aru Mary Magdalene aru Joses laga ama Mary bhi Jisu laga gaw kot te rakhise etu ahikena saise. ");
INSERT INTO nag_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jitia Bisram din khotom hoise, titia Mary Magdalene, James laga ama Mary aru Salome taikhan logot mitha sugandh thaka tel khan anise, Jisu ke abhishek kori dibole. ");
INSERT INTO nag_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aru hapta laga prothom din te ekdom phojurte suryo ula loge-loge taikhan kobor te ahise. ");
INSERT INTO nag_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aru taikhan majot eneka kotha koi thakise, “Kun pora amikhan nimite kobor laga dorja pora pathor hatai dibo?” ");
INSERT INTO nag_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kintu jitia taikhan ta te punchikena saise, etu dangor pathor to hati kene thaka paise. ");
INSERT INTO nag_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aru kobor bhitor te jai kene taikhan jawan manu ekjon lamba boga kapra pindhi kene dyna phale bohi thaka paise, titia taikhan bisi bhoi khaise. ");
INSERT INTO nag_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kintu tai taikhan ke koise, “Bhoi na koribi. Tumikhan Nazareth Jisu ke bisari ase, junke Cross te mari disele. Tai jee uthijaise. Tai yate nai. Taike kote rakhise etu jagah sabi. ");
INSERT INTO nag_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kintu tumikhan jai kene Tai chela khan aru Peter ke koi dibi, ‘Tai tumikhan laga age Galilee te punchi ase, ta te tumikhan Taike pai jabo, jineka Tai tumikhan ke koisele.’” ");
INSERT INTO nag_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Karone taikhan kobor pora ulaikene polai jaise, kelemane taikhan kapi aru hairan hoise, taikhan kunke bhi eku kowa nai kelemane taikhan bhoi lagi sele. ");
INSERT INTO nag_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Titia hapta laga prothom din te, Tai jee uthija-a pichete, Tai sob pora age Mary Magdalene, jun pora Tai sat-ta bhoot ulai disele, etu ke dikhai dise. ");
INSERT INTO nag_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aru Mary Magdelene jai kene Jisu laga chela khan ke koi dise, jun khan bisi mon dukh hoi kene kandi thakisele. ");
INSERT INTO nag_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Aru jitia taikhan Jisu jinda hoise koi kene hunise, aru taike dikhise, kintu taikhan biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Etu pichete Tai alag chehera hoi kene duijon chela ke dikhai dise, jitia taikhan dusra desh te jai asele. ");
INSERT INTO nag_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tai duijon Jerusalem te wapas jai kene taikhan ke koise, kintu taikhan pora duijon ke biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pichete jitia egaroh jon chela khan khabole bohi asele, Jisu ahi kene taikhan ke dikhai dise, aru taikhan mon tan huwa aru biswas nathaka karone taikhan ke galise. Kelemane Tai jee utha pichete jun khan pora Taike dikhise koise eitu khan laga kotha biswas kora nai . ");
INSERT INTO nag_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aru Jisu taikhan ke koise, “Tumikhan prithibi sob te jai kene sob sristi khan ke etu susamachar jonai dibi. ");
INSERT INTO nag_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jun manu biswas kore aru baptizma lobo, taikhan bachibo kintu jun biswas nokorile taike nosto kori dibo. ");
INSERT INTO nag_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aru biswas kora khan logote etu chihna thakibo, taikhan Moi laga naam te bhoot khan ke khedai dibo aru taikhan alag-alag bhasha te kobo. ");
INSERT INTO nag_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Taikhan saph ke uthai lobo, aru taikhan jodi jeher khai le bhi eku biya nohobo, taikhan bemar manu uporte hath rakhile bhal hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Titia Probhu Jisu taikhan logote kotha kowa pichete Taike sorgote uthai loi jaise, aru Isor laga dyna hathte bohi jaise. ");
INSERT INTO nag_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aru taikhan jai kene sob jagah te prochar kori jaise, aru Probhu pora taikhan logote ki kaam korise aru vachan dise, etu ke loi proman kori jai thakise.");
INSERT INTO nag_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bisi manu khan pora kotha aru kaam khan laga khisa joma kori kene likhibo nimite kosis korise, juntu amikhan majot te pura hoise ");
INSERT INTO nag_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","jineka pora amikhan laga hathte dise jun khan shuru te nijor suku pora dikhise aru kotha laga noukar khan asele. ");
INSERT INTO nag_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Etu nimite ami etu bisi bhal nisena dikhi ase, bhal pora bisari kene sob kotha aru kaam khan to shuru pora apuni ke hisab-kitab pora likhi ase mohan Theophilus, ");
INSERT INTO nag_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","eneka hoile tumi janibo etu bostu laga asol kotha juntu apuni ke sikhai dise. ");
INSERT INTO nag_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aru Herod pora Judea laga raja thaka somoite Abijah laga dol pora Zachariah naam laga ekjon purohit thakise. Tai laga maiki to Aaron laga khandan pora asele aru tai laga naam Elizabeth asele. ");
INSERT INTO nag_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aru tai duijon Isor usorte bisi bhal thakise, aru Probhu pora ki koi sob kotha to sapha pora mani thake. ");
INSERT INTO nag_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aru taikhan bacha thaka nai, kelemane Elizabeth to bacha pabole napara maiki thakise, aru tai duijon laga umor bhi bisi hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Etiya eneka hoise, jitia Zechariah tai Isor usorte tai laga purohit kaam khan kori asele, juntu kaan khan tai laga dol khan pora kore. ");
INSERT INTO nag_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Titia, purohit laga niyom hisab te, taike Isor laga pobitro ghor bhitor te jai kene dhup aru dhona julabole chithi pora basi se. ");
INSERT INTO nag_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jitia dhona juli jaise etu homoi te sob manu khan bahar te prathana kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Titia Probhu laga sorgodoth tai usorte ahise, aru jun jagate dhona julai se etu laga dyna phale khara korise. ");
INSERT INTO nag_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jitia Zechariah etu dikhise tai bisi chinta hoise aru tai uporte bisi bhoi ahi jaise. ");
INSERT INTO nag_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hoilebi, sorgodoth koise, “Bhoi na koribi Zechariah, tumi laga prathana huni loise. Tumi laga maiki Elizabeth pora ekjon chokra pabo. Aru tumi tai laga naam John rakhibo. ");
INSERT INTO nag_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aru tumikhan anond aru bhal lagibo, aru bisi manu khan tai laga jonom te khushi koribo. ");
INSERT INTO nag_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aru tai Probhu usorte bisi dangor hobo. Tai kitia bhi draikha-ros nakhabole lage, tai ama laga peth te thaka homoi pora he Pobitro Atma pora bhorta hoi jabo. ");
INSERT INTO nag_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aru tai Israel laga bacha khan ke Probhu Isor logote wapas anibo. ");
INSERT INTO nag_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Elijah laga atma aru takot pora Probhu laga kaam te tai he age kori kene loijabo. Aru jun dharmikta laga kotha namani kene ase taikhan laga mon ghurai dibo nimite aru baba khan laga mon taikhan laga bacha khan phale ghurai dibole, aru jun Probhu ahibole ase Tai nimite rasta taiyar kori bole.” ");
INSERT INTO nag_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah pora sorgodoth ke koise, “Moi etu hobo koi kene kineka janibo? Kelemane moi bura hoise aru moi laga maiki bhi umor bisi hoise.” ");
INSERT INTO nag_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aru sorgodoth taike jawab dikene koise, “Moi Gabriel ase, jun Isor usorte khara kore. Amike tumi logote kotha kobole pathaise, aru etu bhal khobor to tumike kobole nimite. ");
INSERT INTO nag_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aru etu nimite, sob kaam to nohua tak tumi chup thakibo aru kotha ulabo na paribo, kelemane tumi moi laga kotha biswas kora nai, etu sob to tai laga thik homoi te pura hobo.” ");
INSERT INTO nag_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aru manu khan Zechariah nimite rukhi thakisele, aru taikhan chinta-bhabona korise jitia tai mondoli ghor bhithor te deri korise. ");
INSERT INTO nag_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kintu jitia tai bahar te ulai ahise tai kotha kobole para nai, titia taikhan bhabise taike Isor pora kiba ekta dikhaise; aru tai manu khan ke ishara pora dikhai di thakise, aru kotha koribo naparikena he thaki jaise. ");
INSERT INTO nag_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aru etu sob to tai laga sewa kora homoi pura aru khotom hoise, titia tai ghor te jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aru etu din piche, tai laga maiki Elizabeth bacha bukhi se, aru pans mohina tak tai nije ke lukai kene rakhise, aru koi thakise, ");
INSERT INTO nag_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Isor ami uporte eneka korise, aru ami uporte Probhu he daya korise, manu usorte sorom nathakibo nimite.” ");
INSERT INTO nag_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Aru Elizabeth peth te bacha bukha choi mohina huwa homoi te, Isor pora sorgodoth Gabriel ke Galilee, juntu ke Nazareth mate, etu jagate pathaise, ");
INSERT INTO nag_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ekjon kumari mahila logote, jun Joseph koi kene ekjon manu logot shadi kori bole laga kotha milikena asele, aru jun David ghor manu asele; aru etu kumari laga naam Mary asele. ");
INSERT INTO nag_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aru tai logote ahikena, sorgodoth koise, “Salam tumike, jun uporte Isor laga morom ahise! Probhu tumi logote ase.” ");
INSERT INTO nag_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aru tai etu kotha khan huni kene chinta hoise aru tai bhabi thakise etu kineka laga salam ase. ");
INSERT INTO nag_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aru sorgodoth taike koise, “Bhoi na koribi, Mary, tumi to Isor usorte morom paise. ");
INSERT INTO nag_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aru tumi ekjon chokra bukhi bo, aru Tai laga naam ‘Jisu’ rakhibo. ");
INSERT INTO nag_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tai bisi mohan hobo aru Taike Sobse Mohan laga Putro eneka matibo. Aru Probhu Isor taike, tai laga purbo David laga singhason dibo. ");
INSERT INTO nag_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aru Tai hodai nimite Jacob laga ghor cholai thakibo, aru Tai laga rajyo kitia bhi khotom nahobo.” ");
INSERT INTO nag_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aru Mary pora sorgodoth logote koise, “Etu kineka hobo, kelemane moi kun manu ke bhi najane?” ");
INSERT INTO nag_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aru sorgodoth he taike koise, “Pobitro Atma tumi logote ahibo, aru Sobse Mohan takot pora tumike bondh kori dibo. Etu nimite juntu pobitro bacha jonom hobole ase, Taike Isor laga Putro matibo. ");
INSERT INTO nag_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aru sabi tumi laga ghor manu Elizabeth bhi tai laga buri umorte chokra pabole ase. Aru tai bacha bukha choi mohina chuli asele, tai junke dusra khan pora bacha bukhibo napara mahila koi thakisele. ");
INSERT INTO nag_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kelemane Isor nimite eku napara nai.” ");
INSERT INTO nag_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aru Mary koise, “Sabi moi Probhu laga ekjon mahila noukar ase. Apuni ki koi ase etu nisena hobole dibi.” Titia sorgodoth jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Etu huwa pichete, Mary tara-tari kori kene pahar desh te jaise, Judah laga sheher ekta te. ");
INSERT INTO nag_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aru Zechariah aru Elizabeth laga ghor te ghusi kene salam dise. ");
INSERT INTO nag_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aru eneka hoise jitia Mary pora Elizabeth ke salam dise, tai laga pet bhitor te bacha thaka to khushi pora hili se, aru Elizabeth to Pobitro Atma pora bhorta hoise. ");
INSERT INTO nag_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Aru tai khushi pora hala kori kene koise; “Sob maiki bhitor te tumi ekjon asirbad thaka ase, aru jun he apuni laga bhitor te ase etu bhi asirbad ase. ");
INSERT INTO nag_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aru etu moi logote kineka hoise, moi laga Probhu laga ama moi logote ahise. ");
INSERT INTO nag_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aru sabi, apuni laga salam jitia moi kan pora hunise, moi laga bhitor te bacha thaka to khushi pora hili se. ");
INSERT INTO nag_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aru etu manu asirbad ase jun to kotha khan purah hobo koi kene biswas korise, juntu kotha to Probhu pora taike koise.” ");
INSERT INTO nag_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Titia Mary koise, “Moi laga jibon Probhu ke mohima kore, ");
INSERT INTO nag_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Aru moi laga Atma khushi kori ase jun Isor he moi laga Tran-korta ase. ");
INSERT INTO nag_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Aru Tai upor pora, sobse mamuli maiki ekjon, tai laga noukar ke saise. Aru sabi, etiya pora sob manu khan moike asirbad ase kobo. ");
INSERT INTO nag_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kelemane Mohan Isor pora moi nimite dangor kaam kori dise aru tai laga naam to pobitro ase. ");
INSERT INTO nag_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aru tai laga morom to etiya pora loi kene aha din tak jun manu taike bhoi kore tai logote ase. ");
INSERT INTO nag_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tai laga hath pora bisi dangor kaam korise. Aru jun manu tai laga monte phutani bhabona kore taikhan ke alag kori diye. ");
INSERT INTO nag_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aru taikhan bohi kene raj kora jaga pora nichete girai dise. Aru jun chutu hoise eitu khan ke uthaise. ");
INSERT INTO nag_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aru bhuka thaka khan ke bhal saman pora bhorta kori dise, Aru dhun manu khan ke khali kori dise. ");
INSERT INTO nag_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Aru tai laga noukar, Israel ke modot korise, tai laga morom to yaad korise, ");
INSERT INTO nag_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aru tai kotha korise moi khan baba laga baba khan ke- Abraham aru tai laga bacha khan logote hodai nimite.” ");
INSERT INTO nag_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Aru Mary Elizabeth logote tin mohina tak thakise aru etu pichete tai laga ghor te jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aru Elizabeth nimite bacha pabole laga homoi ahi jaise aru tai ekjon chokra ke jonom dise. ");
INSERT INTO nag_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tai laga ghor manu aru usorte thaka khan Probhu pora kiman dangor aru morom kaam korise etu dikhi kene tai logote khushi korise. ");
INSERT INTO nag_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aru bacha ath din hoi thaka homoi te taikhan bacha ke sunnot kori bole anise, aru tai laga baba Zechariah laga naam te rakhibole thakise. ");
INSERT INTO nag_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hoilebi tai laga ama pora koise, “Nohoi. Taike John laga naam pora he matibo.” ");
INSERT INTO nag_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aru taikhan koise, “Apuni laga ghor manu bhitor te kun bhi etu naam thaka manu nai.” ");
INSERT INTO nag_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aru taikhan tai laga baba ke hath dikhai kene ki mati bole mon ase etu hudise. ");
INSERT INTO nag_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tai laga baba pora likhi bole saman mangise aru likhise, koise, “Tai laga naam to John ase.” Titia taikhan sob asurit hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aru achanak pora tai laga mukh khuli se aru tai laga jiba to hili se, aru tai Isor ke asirbad dise. ");
INSERT INTO nag_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sob Judea laga jagate etu laga kotha he koi thakise, aru jiman manu taikhan usorte thakise, taikhan sob bhoi hoise. ");
INSERT INTO nag_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jun manu etu kotha khan hunise etu sob taikhan nijor laga monte rakhise, aru koi thakise, “Etu bacha kineka hobo?” Kelemane Isor laga hath tai logote asele. ");
INSERT INTO nag_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Titia tai laga baba Zechariah ke Pobitro Atma pora bhorta hoise aru tai koise, ");
INSERT INTO nag_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Asirbad hobo Probhu, Israel laga Isor, Kelemane Tai modot kori bole ahise, aru Tai laga manu khan nimite ki bhabise etu purah hoise. ");
INSERT INTO nag_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Aru amikhan nimite Tai laga noukar David laga porial te ekjon mukti laga seing ulai dise, ");
INSERT INTO nag_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jineka tai purana homoi te pobitro bhabobadi laga mukh pora koisele. ");
INSERT INTO nag_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Biya pora mukti pabo aru taikhan laga hath pora amikhan ke bachai lobo. ");
INSERT INTO nag_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tai eneka kori kene amikhan baba laga baba khan uporte morom to dikhai dibo. Aru tai laga ki pobitro vachan dise etu yaad koribo. ");
INSERT INTO nag_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aru juntu kosom Abraham amikhan baba laga baba khan logote khaise, etu dibo nimite ");
INSERT INTO nag_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Aru amikhan ke dushman laga hath pora bachai kene ulai luwa nisena amikhan taike bhoi nakori kene tai laga sewa koribo, ");
INSERT INTO nag_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Pobitrota te aru sapha pora taike hodai mohima koribo. ");
INSERT INTO nag_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aru apuni ke, oh bacha, sob pora dangor bhabobadi matibo kelemane apuni Probhu laga age te jabo aru rasta taiyar koribo. ");
INSERT INTO nag_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tai laga manu khan ke poritran laga gyaan dibole, taikhan laga paap pora maph pai ja-a dwara. ");
INSERT INTO nag_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Aru etu sob to purah hobo kelemane amikhan laga Isor to morom aru nomro ase. Etu nimite uporte thaka ujala bhi amikhan ke modot kori bole ahibo, ");
INSERT INTO nag_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aru jun andhera te bohi ase aru mora-laga chaya te bohi kene ase taikhan uporte ujala thakibo; amikhan laga theng to shanti laga rasta te bera bole dibo.” ");
INSERT INTO nag_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aru bacha to dangor hoise aru atma te takot hoise, aru tai jongol te thakise jitia tak tai nijorke Israel manu usorte ahi dikhai diya nai. ");
INSERT INTO nag_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aru etu din khan te eneka hoise, Caesar Augustus pora ekta hukum ulaise dise, etu duniya laga manu khan sob sorkari kagos te naam likhi kene nijor laga ginti kori lobole. ");
INSERT INTO nag_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aru poila dinte hoile, jitia Quirinius pora Syria jaga laga governor thakise, etu homoi pora naam likha shuru hoise. ");
INSERT INTO nag_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aru sob manu nijor laga naam likhi bole nijor desh te jaise. ");
INSERT INTO nag_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aru Joseph bhi Galilee pora jaise, Nazareth aru Judea laga sheher pora, David laga sheher pora juntu ke Bethlehem mate, kelemane tai bhi David laga ghor manu ase aru tai laga khandan pora ahise. ");
INSERT INTO nag_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tai Mary ke loi kene naam likhi bole jaise, jun tai logote shadi kori bole laga kotha milai kene thakise, aru tai bacha bukhi thakise. ");
INSERT INTO nag_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aru jitia taikhan Bethlehem te thakise, bacha ke jonom hobole homoi ahi jaise. ");
INSERT INTO nag_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aru tai chokra ke jonom dise, tai laga poila bacha, aru kapra tukra khan pora bandi kene, taike khair te ghumai dise, kelemane aram kora ghor te taikhan thaki bole jaga thaka nai. ");
INSERT INTO nag_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aru etu jagate, kunba mer rokhiya khan thakise. Aru rati te taikhan kheti te mer khan ke rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aru Probhu laga sorgodoth taikhan usorte ahise, aru Probhu laga mohima taikhan uporte dise, aru taikhan bisi bhoi lagise. ");
INSERT INTO nag_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aru sorgodoth pora taikhan ke koise, “Bhoi na koribi, huni bhi, kelemane, moi dangor khushi kotha anise, aru etu sob manu nimite hobo. ");
INSERT INTO nag_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kilekoile aji laga dinte, David laga sheher Bethlehem te, tumikhan nimite, ekjon jonom hoise, jun Tran-korta Probhu Khrista ase! ");
INSERT INTO nag_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aru tumikhan ke etu chihna di ase: tumikhan ekjon bacha kapra laga tukra khan pora bandi kene khair uporte ghumai kene pabo.” ");
INSERT INTO nag_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aru achanak pora etu sorgodoth logote bisi duth khan ulaikena ahise, aru Isor ke dhanyavad dikena koi thakise, ");
INSERT INTO nag_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Sob pora untcha te thaka Isor ke mohima hobi, Aru prithibi te kun logot Tai khushi pai, Taikhan uporte shanti hobole dibi.” ");
INSERT INTO nag_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aru jitia sorgodoth khan sorgote jai jaise, rokhiya khan ekjon-ekjon ke koise, “Ahibi amikhan Bethlehem te jabo, aru ki hoise etu sabo, juntu kotha Probhu koi amikhan ke janibo dise.” ");
INSERT INTO nag_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aru taikhan joldi jai kene Mary aru Joseph ke lok paise aru khair te ghumai thaka bacha ke lok paise. ");
INSERT INTO nag_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aru jitia taikhan bacha ke sai loise, taikhan jai kene etu bacha laga sob kotha manu khan ke koise. ");
INSERT INTO nag_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jitia taikhan pora utu bacha laga kotha koise sob manu ke koise, etu huni kene taikhan sob asurit hoise. ");
INSERT INTO nag_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Hoilebi Mary to etu kotha sob tai laga monte he rakhise. ");
INSERT INTO nag_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aru saguli roikhya khan, ki kotha taikhan ke sorgodoth khan pora koise aru taikhan ki hunise etu loi kene Isor ke dhanyavad dikene wapas jaise. ");
INSERT INTO nag_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Aru jitia ath din pura hoise, tai laga sunnot niyom kora dinte, aru titia tai laga naam Jisu koi kene matidise, juntu naam sorgodoth pora matidise jitia Tai ama laga peth te hoi thakise. ");
INSERT INTO nag_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Aru jitia sapha kora laga din paar hoise, Moses laga niyom hisab te, taike Jerusalem te Isor usorte dibole nimite anise. ");
INSERT INTO nag_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","-Aru etu Isor laga niyom te likhi kene ase, “Jiman mota ama laga pet pora ulai ahise, tai Probhu usorte pobitro matibo”-, ");
INSERT INTO nag_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aru boli dibole nimite juntu Probhu laga niyom te koise, “Ek jora kopu chiriya aru duita chutu kobutar.” ");
INSERT INTO nag_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aru sabi, Jerusalem te ekjon manu thakisele, tai laga naam Simon ase, tai dharmik jon asele aru Isor ke aradhana di thaka manu asele. Tai Israel nimite mon aram pabole bisara manu thakise; aru Pobitro Atma tai logote thakise. ");
INSERT INTO nag_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aru Pobitro Atma pora taike dikhai dise, tai mora nadikhibo, jitia tak tai Probhu laga Khrista ke nadikhibo. ");
INSERT INTO nag_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aru tai Atma te hoi kene mondoli te ahise; aru jitia Jisu laga ama baba pora taike anise; ki niyom ase etu hisab te tai uporte kori bole nimite. ");
INSERT INTO nag_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aru tai laga hathte bacha ke uthaikene Isor ke dhanyavad dise, aru koise, ");
INSERT INTO nag_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Etiya apuni laga noukar ke shanti pora etu prithibi chari kene jabole dibi Probhu, apuni laga kotha hisab te. ");
INSERT INTO nag_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Moi laga suku pora apuni laga poritran dikhise, ");
INSERT INTO nag_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Apuni sob to taiyar kori dise apuni laga manu khan usorte: ");
INSERT INTO nag_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Porjati khan ke dikhai dibole nimite ekta ujala ahise, aru Israel manu khan nimite mohima hobole nimite.” ");
INSERT INTO nag_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aru tai ki koise etu huni kene tai laga ama aru baba asurit hoise. ");
INSERT INTO nag_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aru Simeon taikhan ke asirbad dise, aru bacha laga ama Mary ke koise, “Sabi, etu bacha ke Israel laga manu khan ke uthai dibo nimite rakhise; aru ek din asurit kaam to kotha namana khan ke dikhai dibo. ");
INSERT INTO nag_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Aru ekta talwar apuni laga atma te maribo- kelemane bisi manu laga monte bhabona kosi thaka to ulai ahibo.” ");
INSERT INTO nag_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Anna bhi ekta bhabobadini thakise, Phanuel laga chukri aru Asher laga jati pora asele. Tai umor bhi bisi hoi jaise, aru tai sat saal tak tai laga mota logote thakise, ");
INSERT INTO nag_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aru chaurasi saal tak tai ekjon bidhowa thakise. Tai kitia bhi mondoli chara nai, rati aru din tai prathana aru upas te he sewa kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aru jitia taikhan usorte ahise, tai Isor ke dhanyavad dibole suru hoise, aru sob manu khan ke etu bacha laga kotha koi dise, kelemane taikhan sob udhar pabo nimite Jerusalem te rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aru jitia Probhu laga niyom te sob kaam khotom hoise, taikhan Galilee te wapas jaise, juntu jaga Nazareth te asele, taikhan nijor laga bosti. ");
INSERT INTO nag_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aru bacha Jisu to dangor aru takot hoise, gyaan pora bhorta koi kene, aru Isor laga morom Tai laga uporte thakise. ");
INSERT INTO nag_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aru hodai saal, Tai laga ama baba Jerusalem te Nistar Laga Utsov nimite jai thake. ");
INSERT INTO nag_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jitia Tai baroh saal hoi jaise, taikhan hodai nisena, dhanyavad dibole nimite jaise. ");
INSERT INTO nag_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kintu jitia dhanyavad diya aru kha-luwa laga homoi to khotom koi kene paar hoise, jitia taikhan ghor te jai thakise, Jisu to Jerusalem te thaki jaise. Aru tai laga ama aru baba etu jana nai. ");
INSERT INTO nag_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kintu taikhan bhabise Jisu taikhan logote he eke logote jai ase, aru eneka pora ek din laga safar kori loise. Aru etu pichete taike ghor manu aru sathi khan majote bisari bole shuru hoise. ");
INSERT INTO nag_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Aru jitia Taike pa-a nai taikhan aru Jerusalem te ghuri kene jaise aru taike bisari bole shuru hoise. ");
INSERT INTO nag_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aru tin din pichete Taike mondoli te paise, sikhai diya manu khan majote bohi kene taikhan ki koi ase etu huni thakise aru kiba kibi hudi thakise. ");
INSERT INTO nag_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aru jiman manu Tai laga gyaan aru kotha hunise, sob manu khan bisi asurit hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aru jitia Taike dikhise, taikhan sob asurit hoi jaise, Tai laga ama pora koise, “Putro, amikhan ke kele eneka korise? Sabi, Apuni laga baba aru moi bisi chinta pora Apnike bisari thakise.” ");
INSERT INTO nag_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hoilebi Tai pora koise, “Kile Moike bisari ase? Apnikhan najane naki Moi laga Baba ghor te Moi thaki bole lage koi kene?” ");
INSERT INTO nag_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hoilebi Tai ki koise etu kotha taikhan bujhi bole para nai. ");
INSERT INTO nag_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Etu pichete taikhan logote Nazareth te ahi jaise, aru taikhan laga kotha mani kene thakise. Tai laga ama to sob kotha tai laga mon bhitor te he rakhise. ");
INSERT INTO nag_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aru Jisu tai laga gyaan aru buddhi te bisi bari kene jaise, aru Isor aru manu logot te morom paise. ");
INSERT INTO nag_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jitia Tiberius Caesar pondro saal raj kori thaka homoi te, aru Pontius Pilate pora Judea laga governor thaka homoi te, aru Herod bhi Galilee laga ekjon sthaniya cholawta thakise, aru tai laga kokai Philip bhi eturaea aru Trachonitis laga cholawta thakise, aru Lysanias bhi Abilene laga ekjon cholawta thakise, ");
INSERT INTO nag_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jitia Annas aru Caiaphas, moha purohit thakise, titia Isor Zechariah laga chokra jongol te thaka homoi te, Isor laga kotha tai logote ahise. ");
INSERT INTO nag_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aru tai Jordan laga sob jagate jai kene prochar korise, baptizma pora mon ghura bole aru paap pora maph pabole nimite. ");
INSERT INTO nag_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Aru Isaiah bhabobadi pora likha kotha kowa nisena, “Jongol pora ekta awaj mati ase, ‘Probhu nimite rasta taiyar koribi, aru Tai laga rasta to sidha koribi. ");
INSERT INTO nag_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sob bhoyam khan bhorta hoi jabo, Aru sob pahar khan ke niche anibo, Aru biya rasta khan sob sidha hoi jabo, Aru tan rasta khan norom hoi jabo, ");
INSERT INTO nag_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aru sob manu jati Isor laga poritran dikhibo.’” ");
INSERT INTO nag_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aru titia John pora baptizma lobole aha manu khan ke koise, “Saph laga khandan khan! Isor laga ahibole thaka khong pora polabole kun tumikhan ke polabole koise? ");
INSERT INTO nag_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Etu karone, mon ghurai kene bhal phol ulabi, aru nijor logote koi nathakibi, ‘Moi khan logote baba Abraham ase,’ kelemane moi tumikhan ke koi ase, Isor to Abraham nimite etu pathorkhan pora bhi bacha khan uthabole pare. ");
INSERT INTO nag_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hoilebi etu kuthar to taiyar ase, ghas laga jor te laga bole nimite. Etu nimite, juntu ghas to phol nadhure etu kati kene jui te julai dibo.” ");
INSERT INTO nag_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Titia manu khan taike hudibole shuru hoise, “Titia hoile amikhan ki kori bole laga?” ");
INSERT INTO nag_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aru taikhan ke koise, “Jun logote duita kapra ase ekta kapra to dusra ke dibi jun logote nai, aru jun logote kha luwa ase etu bhi eneka he koribi.” ");
INSERT INTO nag_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aru poisa utha manu khan bhi baptizma lobole ahise, aru taikhan pora koise, “Shika manu, amikhan ki kori bole lage?” ");
INSERT INTO nag_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Titia taikhan ke koise, “Tumikhan ke kiman poisa uthabole nimite koise etu pora aru bisi nauthabi.” ");
INSERT INTO nag_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aru ta te kunba sipahi thaka khan pora hudise, “Aru amikhan ki kori bole lage?” Tai taikhan ke koise. “Tumikhan joborjosti pora kun logote bhi poisa nolobi, aru misa pora manu ke naphasa bhi, aru ki pai etu logote he khushi thakibi.” ");
INSERT INTO nag_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Etiya manu khan bisi rukhi thakise aru monte John to Khrista hoi na nohoi etu asurit hoi kene bhabona kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John he sobke koise, “Moi tumikhan ke pani pora baptizma dise, kintu moi pora bhi dangor ekjon ahi ase, moi Tai laga juta laga rusi khuli bole bhi layak nohoi. Tai he Pobitro Atma aru jui pora sobke baptizma dibo. ");
INSERT INTO nag_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dhaan laga katha Tai laga hathte ase. Etu pora ekdom sapha kori kene dhaan to dhaan ghor te joma koribo. Kintu chamra to jui thaka jui te phelabo.” ");
INSERT INTO nag_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aru taikhan ke kisim kotha sob te mon dangor kori dise aru John eneka Isor kotha prochar kori dise. ");
INSERT INTO nag_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aru jitia John pora Herod raja ke tai laga kokai Philip laga maiki Herodias logote golti kaam kora nimite kotha koise, aru tai ki biya kaam khan korise eitu khan sob koi dise, ");
INSERT INTO nag_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tai etu biya kaam khan logote aru etu bhi milai dise: John ke bondhi ghor te rakhidise. ");
INSERT INTO nag_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Etu homoi ahi jaise, jitia sob manu baptizma loise, Jisu bhi baptizma korise, aru prathana kora homoi te sorgo khan khuli jaise. ");
INSERT INTO nag_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aru Tai uporte kopu chiriya nisena Pobitro Atma ahise, aru sorgo ekta awaj kotha koise, “Tumi Moi laga Putro ase, junke moi morom kore, Moi Tumi laga uporte bisi khushi ase.” ");
INSERT INTO nag_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Etu homoi te Jisu tis-saal umor thakise jitia Isor kaam shuru korise. Tai Joseph laga chokra thakise, ");
INSERT INTO nag_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matthat laga chokra, aru Levi laga chokra, Melchi laga chokra, aru Jannai laga chokra, aru Joseph laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mattathias laga chokra, Amos laga chokra, Nahum laga chokra, Esli laga chokra, aru Naggai laga chokra. ");
INSERT INTO nag_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maath laga chokra, Mattathias laga chokra, Semein laga chokra, Josech laga chokra aru Joda laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan laga chokra, Rhesa laga chokra, Zerubbabel laga chokra, Salathiel laga chokra aru Neri laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melchi laga chokra, Addi laga chokra, Cosam laga chokra, Elmadam laga chokra aru Er laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Joshua laga chokra, Eliezer laga chokra, Jorim laga chokra, Matthat laga chokra aru Levi laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeon laga chokra, Judah laga chokra, Joseph laga chokra, Jonam laga chokra aru Eliakim laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea laga chokra, Memna laga chokra, Mattatha laga chokra, Nathan laga chokra aru David laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesse laga chokra, Obed laga chokra, Boaz laga chokra, Salmon laga chokra aru Nahshon laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Amminadab laga chokra, Admin laga chokra, Arni laga chokra, Hezron laga chokra, Perez laga chokra aru Judah laga chokra ");
INSERT INTO nag_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob laga chokra, Isaac laga chokra. Abraham laga chokra, Terah laga chokra aru Nahor laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug laga chokra Reu laga chokra, Peleg laga chokra, Eber laga chokra aru Shelah laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainan laga chokra, Arphaxad laga chokra, Shem laga chokra, Noah laga chokra aru Lamech laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Methuselah laga chokra, Enoch laga chokra, Jared laga chokra, Mahalaleel laga chokra, aru Cainan laga chokra, ");
INSERT INTO nag_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos laga chokra, Seth laga chokra, Adam laga chokra, Isor laga chokra. ");
INSERT INTO nag_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Aru Jisu, Pobitro Atma pora bhorta koi kene, Tai Jordan Nodi pora ghuri jaise, aru Pobitro Atma pora taike jongol te loi jaise. ");
INSERT INTO nag_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ta te Taike chalis din saitan pora porikha korise. Etu din khan te tai eku bhi khanai, aru porikha homoi khotom huwa pichete Tai bhuk lagise. ");
INSERT INTO nag_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Saitan pora taike koise, “Tumi jodi Isor laga Putro hoi, titia etu pathor ke roti hobole hukum dibi.” ");
INSERT INTO nag_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisu taike koise, “Etu Isor kotha te likha ase, manu to khali bhaat pora jinda nathakibo.” ");
INSERT INTO nag_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Titia saitan pora Jisu ke uporte loi jaise aru ekbar te he Jisu ke duniya laga rajyo dikhai dise. ");
INSERT INTO nag_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aru saitan pora taike koise, “Moi tumike etu sob adhikar aru mohima dibo, kelemane etu sob moi loi loise aru moi junke itcha kore, moi taike dibo pare. ");
INSERT INTO nag_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jodi Tumi moike aradhana kore, etu sob Tumi laga hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kintu Jisu taike koise, “Isor kotha te likha ase, tumi khali Isor ke aradhana koribi, aru Tai laga kaam he koribi.” ");
INSERT INTO nag_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pichete saitan pora aru Jisu ke Jerusalem te loi jaise, aru mondoli uporte taike loi jaise aru koise, “Jodi Tumi Isor laga Putro hoi, yate pora niche giri jabi. ");
INSERT INTO nag_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kile etu likha ase, tai sorgodoth ke hukum dibo, Tumike bachabo karone.’ ");
INSERT INTO nag_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aru, taikhan Tumi laga hath pora uthai lobo, etu pora Tumi laga theng to pathor te nagiribo.’” ");
INSERT INTO nag_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisu taike koise, “Etu Isor kotha te likha ase, ‘Tumi Isor ke porikha na koribi.’” ");
INSERT INTO nag_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jitia saitan laga sob porikha khan khotom hoise, etu pichete saitan jai jaise, aru Taike gira bole bhal homoi rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pichete, Jisu Galilee te wapas Pobitro Atma laga hokti loi kene ahise, aru sob jagate Tai laga khobor huni loise. ");
INSERT INTO nag_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tai mondoli khan te Isor laga kotha sikhabole shuru korise, aru manu khan pora tai sikhai diya kotha khan huni kene bisi bhal paise. ");
INSERT INTO nag_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Aru tai Nazareth te ahise, jun jagate Tai dangor hoise, aru Yehudi niyom te, tai Bisram dinte mondoli te ghumai se, aru awaj uthaikene jor pora poribole khara kori loise. ");
INSERT INTO nag_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aru Jisu ke Isaiah bhabobadi laga kagos poribole dise. Tai kagos Khuli Kena ki likha ase etu paise, ");
INSERT INTO nag_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Probhu laga Atma moi uporte ase, Tai moike tel hali dikene basi loise gorib khan ke susamachar prochar kori bole, Tai moike pathaise bandhi rakha khan ke khulai diya laga prochar kori bole, Aru andha manu khan dikhi bole, Dukh te dabai rakha manu khan ke bacha bole, ");
INSERT INTO nag_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aru Probhu laga dinte sob manu khushi pabole.” ");
INSERT INTO nag_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aru Tai kagos bondh kori kene cholawta ke wapas di dise aru bohise. Aru mondoli te thaka manu khan Taike he sai thakise. ");
INSERT INTO nag_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Titia Tai pora taikhan ke koise, “Aji Isor kotha to purah hoise aru tumikhan huni loise.” ");
INSERT INTO nag_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sob manu Tai laga bhal koise aru asurit hoise aru Tai laga mukh pora ula kotha khan huni kene taikhan koise, “Etu Joseph laga chokra nohoi naki?” ");
INSERT INTO nag_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Titia Tai koise, “Hosa pora tumikhan Moi etu kotha kobo, ‘Bemar bhal kora manu, nijorke bhal koribi. Tumi Capernaum te ki korise amikhan etu sob huni loise, aru eneka kaam khan nijor desh te bhi koribi.’” ");
INSERT INTO nag_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kintu, “Moi hosa kotha kobo, bhabobadi ke nijor desh te kun bhi sonman nakore. ");
INSERT INTO nag_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Moi hosa pora tumikhan ke koi ase bidhowa bisi jon Israel te Elijah laga dinte thakise, jitia akas to tin saal choi mohina bondh thakise, jitia dangor dukh din etu desh te ahise. ");
INSERT INTO nag_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kintu Elijah ke taikhan kun logote te bhi pathai diya nai, hoilebi Zarephath, Sidon te ekjon mota nathaka maiki logote he pathaise. ");
INSERT INTO nag_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Etu homoi te kusto-rugi laga bemar thaka manu Israel te bisi thakise. Elisha bhabobadi laga dinte, kintu kunbi bhal huwa nai, khali Syria desh laga Naaman ke chari kene. ");
INSERT INTO nag_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aru mondoli te thaka khan jitia etu kotha hunise, taikhan sob khong hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Taikhan khara hoise, aru Jisu ke tanikena nogor laga untcha pahar pora phelai dibole korise. ");
INSERT INTO nag_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kintu Taike manu khan majot pora loi juwa homoi te, Jisu alag rasta pora ulai jaise. ");
INSERT INTO nag_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Etu pichete Jisu Capernaum te namise, juntu Galilee laga ekta sheher asele aru ta te sob manu khan ke Sabbath dinte Isor kotha hikai se. ");
INSERT INTO nag_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tai laga kotha huni kene taikhan bisi asurit hoise, kele koile Tai adhikar thakikena Isor kotha koi thakise. ");
INSERT INTO nag_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Etiya mondoli te ekjon manu bhoot atma pora dhora thakise, aru tai jor pora hala korise aru dangor awaj te koise, ");
INSERT INTO nag_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ha! Apuni logote amikhan ki kaam ase, Nazareth laga Jisu? Moi khan ke borbad kori bole ahise? Moi jane Apuni kun ase- Isor laga Pobitro Ekjon Ase!” ");
INSERT INTO nag_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisu pora bhoot ke hukum dikena koise, “Chup thakibi, aru tai pora bahar ulai jabi!” Aru bhoot pora manu ke taikhan majote girai dise, aru manu ke eku nuksan nakorikena ulai jaise. ");
INSERT INTO nag_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Manu khan saikene asurit lagise, aru ekjon-ekjon logote kotha patikena koise, “Etu ki kotha ase, juntu laga adhikar aru hokti pora Tai dusto atma khan ke hukum kore aru taikhan ulai jai?” ");
INSERT INTO nag_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aru etu khobor sob jagate punchikena bisi manu huni loise. ");
INSERT INTO nag_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pichete, Jisu mondoli chari kene Simon laga ghor te jaise. Etu homoi te Simon laga maiki laga ama bisi bemar thakise, etu nimite Taike ahikena anurodh korise. ");
INSERT INTO nag_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aru Jisu ta te jaise aru tai usorte khara hoi kene, bemar ke gali dise, aru bemar taike charise, aru tai uthikena taikhan ke sewa kori bole shuru hoise. ");
INSERT INTO nag_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jitia suryo nami jaise, jiman manu alag-alag bemar thakise, Jisu usorte loi kene ahise, aru Jisu ke taikhan uporte hath rakhi kene bhal kori dise. ");
INSERT INTO nag_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bisi jon pora bhoot khan hala kori kene ulaise, aru koise, “Tumi Isor laga Putro ase!” Hoilebi Jisu hukum dikene bhoot khan ke kotha kobo diya nai, kele taikhan jani thakise Tai Khrista ase koi kene. ");
INSERT INTO nag_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aru jitia din hoise, Jisu ulaikene manu nathaka jagate jaise, kintu manu khan dangor bhir hoi kene Taike bisari ahise. Taikhan ke Jisu pora chari kene najabo nimite manu khan kosis korise. ");
INSERT INTO nag_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kintu Jisu taikhan ke koise, “Moi aru bhi dusra sheher khan te bhi Isor laga rajyo laga susamachar prochar koribo lage, etu karone Moike duniya te pathaise.” ");
INSERT INTO nag_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aru Tai Judea desh laga jaga sob te mondoli te jai kene prochar korise. ");
INSERT INTO nag_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Etiya eneka hoise, bisi manu Jisu pora Isor kotha kowa huni bole Tai usorte ahi thakise, etu homoi te tai Gennesaret laga pukhuri te rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aru Tai duita naw pukhuri kinar te ani thaka dikhise, kintu maas mara manu khan naw pora namikene taikhan laga jal dhulai thakise. ");
INSERT INTO nag_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Aru Jisu ekta naw te uthise, etu Simon laga naw thakise, aru tai laga naw ke olop panite loi jabole koise. Aru Tai naw te bohi kene manu khan ke hikai se. ");
INSERT INTO nag_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jitia Jisu kotha koi kene khotom korise, Tai Simon ke koise, “Etu naw to pani bisi thaka phale loijabi aru tumi laga jal to ekbar panite phelabi.” ");
INSERT INTO nag_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon koise, “Probhu, amikhan raat bhor jal marise aru eku bhi puwa nai, hoilebi apuni laga kotha te, moi jal phelabo.” ");
INSERT INTO nag_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aru jitia taikhan jal phelaise, taikhan bisi maas dhurise, aru taikhan laga jal phati jaise. ");
INSERT INTO nag_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dusra naw te thaka sathi khan ke modot mangise. Aru taikhan sob mili kene duita naw te maas khan bhorta korise, etu pora naw to panite dubi bole hoise. ");
INSERT INTO nag_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jitia Simon Peter etu dikhise, tai Jisu laga theng nichete girikena koise, “Ami usor pora jai jabi, kele moi ekjon paapi manu ase, Probhu.” ");
INSERT INTO nag_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Etu kaam dikhikena Peter aru tai laga sathi khan, ");
INSERT INTO nag_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","aru etu nisena James aru John, Zebedee laga chokra khan, jun khan Simon laga sathi thakise taikhan sob kineka iman maas dhuri bo parise koi kene asurit hoise. Jisu pora Simon ke koise, “Bhoi nokoribi; tumikhan etiya pora manu khan dhora jal hobo.” ");
INSERT INTO nag_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jitia taikhan laga naw mati kinar te anise, taikhan sob chari kene Jisu laga piche korise. ");
INSERT INTO nag_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tai jitia ekta sheher te jaise, ekjon manu kusto-rugi bemar pora bhorta koi kene thaka dikhise. Aru jitia Jisu ke dikhise, tai Jisu laga theng te giri kene mangise aru koise, “Probhu, jodi Apuni itcha kore, Apuni moike sapha koribo pare.” ");
INSERT INTO nag_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisu taike chuikena koise, “Moi itcha ase, sapha hobi.” Etu homoi te kusto-rugi bemar taike charise. ");
INSERT INTO nag_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aru Jisu pora taike koise kunke bhi nokobi, kintu “Purohit logote jai kene dikha bhi. Aru ekta sapha huwa laga boli koribi, Moses pora niyom diya nisena, etu pora he manu khan nimite ekta gawahi hobo.” ");
INSERT INTO nag_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kintu etu asurit kaam laga khobor to sob jagate punchise, aru bisi manu tai laga kotha huni bole aru bemar pora changai pabole ahise. ");
INSERT INTO nag_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kintu Tai manu nathaka jagate jai kene prathana kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Eneka he, ek dinte, jitia Tai hikai thakise, Pharisee khan aru niyom hikai diya khan Galilee jaga, Judea desh aru Jerusalem sheher laga usorte thaka alag-alag bosti pora ahise aru taikhan bohi thakise. Changai kori bole Isor laga hokti Jisu logote thakise. ");
INSERT INTO nag_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Titia manu khan he ekjon jothor bemar manu ke chetai te bukhi kene anise, Jisu jun jagate bohi thakise etu jagate anibole kosis korise. ");
INSERT INTO nag_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Jitia taikhan manu bisi thaka karone taike anibo para nai, taikhan ghor uporte uthise, aru ghor laga chaat khuli kene Jisu usorte namai dise. ");
INSERT INTO nag_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Taikhan laga biswas dikhi kene, Jisu koise, “Manu, tumi laga paapkhan maph hoise.” ");
INSERT INTO nag_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Titia niyom likha khan aru Pharisee khan hudibole shuru hoise, “Tai kun ase eneka misa kobole? Kun he paap maph kori bole pare, khali Isor he nohoile?” ");
INSERT INTO nag_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kintu Jisu taikhan ke koise, “Tumikhan mon eneka kele bhabi ase? ");
INSERT INTO nag_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kuntu kobole asan ase, ‘Tumi paap to maph hoise’ na ‘Uthikena berabi?’ ");
INSERT INTO nag_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kintu tumikhan janibole koi ase, Manu laga Putro logote prithibi laga paap ke maph dibole hokti ase” - aru Tai jothor thaka manu ke koise- “Moi koi ase, uthibi, tumi laga chatai uthabi, aru ghor te jabi.” ");
INSERT INTO nag_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aru etu loge-loge, etu manu khara hoi jaise, aru tai ghumai thaka chatai uthaise, aru Isor ke mohima dikena nijor ghor te jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sob manu khan asurit hoise, aru Isor ke mohima dise, aru manu khan bhoi hoise, aru koise, “Amikhan kitia bhi nadikha asurit kaam khan aji dikhise.” ");
INSERT INTO nag_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Etu pichete, Jisu bahar te jaise. Aru Tai ekjon poisa utha manu, Levi koi kene naam thaka ke masul dikri laga tombu ghor te bohi thaka dikhise. Tai jai kene koise, “Moi laga pichete ahibi.” ");
INSERT INTO nag_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aru tai uthise aru sob chari kene, Jisu laga pichete jaise. ");
INSERT INTO nag_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aru Levi pora tai laga ghor te jai kene, ekta dangor ekta khana rakhise, Jisu nimite, aru ta te poisa utha manu khan aru dusra khan bhi eke logote mez usorte bohi thakise. ");
INSERT INTO nag_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kintu Pharisee khan aru niyom likha khan chela khan logote hala kori kene koise, “Tumikhan kele poisa utha manu aru dusra paapi khan logote khai ase?” ");
INSERT INTO nag_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisu pora taikhan ke jowab dise, “Jun manu bhal ase taike bemar bhal kora manu nalage, kintu bemar manu ke he lage.” ");
INSERT INTO nag_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Moi dharmik manu ke mati bole aha nai, kintu paapi khan mon ghura bole nimite ahise.” ");
INSERT INTO nag_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Titia taikhan pora Taike koise, “John laga chela khan upwas aru prathana kore aru Pharisee khan laga chela bhi eneka he kore. Kintu Apuni chela khan, kha-luwa kore.” ");
INSERT INTO nag_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kintu Jisu taikhan ke koise, “Shadi te aha manu ke bhukha rakhibo pare naki, jitia tak taikhan logote shadi kori bole mota thaki ase?” ");
INSERT INTO nag_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kintu eneka din ahi ase, jitia shadi kora manu taikhan pora jai jabo, etu din pora taikhan upwas koribo.” ");
INSERT INTO nag_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aru Jisu taikhan ke ekta dristanto koise. “Kun bhi phata kapra logote notun kapra nasilai, jodi etu kore, notun kapra bhi phati jabo, aru notun kapra to purana kapra logote namilibo. ");
INSERT INTO nag_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kun bhi angur ros purana chamra jola te nadhale. Eneka korile, notun ros pora jola to biya kori dibo, aru etu borbad hoi jabo. ");
INSERT INTO nag_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kintu notun ros to notun chamra jola te halibo lage. ");
INSERT INTO nag_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jun manu bhi purana ros kha pichete notun ros khabole namange, kele tai koi, ‘Purana to he bhal ase.’” ");
INSERT INTO nag_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aru dusra Bisram dinte eneka hoise Jisu kheti majote jai thakise, aru chela khan dhaan guti ulaikene hath pora sapha kori kene khai thakise. ");
INSERT INTO nag_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kintu Pharisee khan hudise, “Tumikhan eneka kele kori ase, Bisram dinte eneka kori bole niyom nai nohoi?” ");
INSERT INTO nag_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisu taikhan ke koise, “Tumikhan Isor laga kotha te pura nai naki David aru tai logote thaka manu khan bhuk laga homoi te taikhan ki korise? ");
INSERT INTO nag_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tai kineka Isor ghor bhitore jaise aru pobitro jagate bhaat rakha to loi kene khaise, aru tai logote thaka khan ke bhi dise, juntu niyom pora chubo aru khabo napare, khali purohitkhan he khabo pare.” ");
INSERT INTO nag_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tai taikhan ke koise, “Manu laga Putro to Bisram Din laga bhi Probhu ase.” ");
INSERT INTO nag_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aru ekta Bisram dinte eneka hoise, Tai mondoli bhitor te jai kene sikhai thakise. Ta te ekjon manu tai laga dyna hath to murjha asele. ");
INSERT INTO nag_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aru Bisram dinte, Jisu pora kunba ke bhal kore na nai, etu pora golti dhori bole nimite, niyom likha manu kunba aru Pharisee khan Jisu ke sai thakise. ");
INSERT INTO nag_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kintu Jisu taikhan laga bhabona jani jaise, aru jun laga hath murjha asele etu ke koise, “Uthibi, amikhan majote khara hoi jabi.” Etu manu uthi kene taikhan majote khara hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pichete Jisu taikhan ke koise, “Moi tumikhan ke hudibo, Bisram dinte bhal kaam koribo lage na manu ke nuksan koribo lage, atma ke bachabo lage na, biya koribo lage? ");
INSERT INTO nag_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aru Jisu sob phale saikene etu manu ke koise, “Tumi laga hath to sidha koribi.” Tai korise, aru tai laga hath to bhal hoise. ");
INSERT INTO nag_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kintu cholawta khan khong pora bhorta hoise aru Jisu ke kineka phasabo etu kotha korise. ");
INSERT INTO nag_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aru eneka hoise dusra dinte Tai ulaikene tilla uporte prathana kori bole jaise, aru Tai pura rati Isor logote prathana kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aru jitia din hoise Jisu pora chela khan ke matise, aru baroh jonke basi loise, aru taikhan ke apostle naam dise. ");
INSERT INTO nag_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (junke Peter naam dise) aru tai laga bhai Andrew; James aru John; Philip aru Bartholomew; ");
INSERT INTO nag_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew aru Thomas; aru James Alphaeus laga chokra; aru Simon junke Zealot bhi mate; ");
INSERT INTO nag_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Aru James laga chokra Judas; aru Judas Iscariot, jun he Jisu ke pichete dhoka dise. ");
INSERT INTO nag_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jitia Tai tilla pora namikene taikhan logote ahise, aru bisi dangor bhir manu joma hoi thakise. Aru Judea desh, Jerusalem sheher, aru samundar kinar Tyre aru Sidon sheher khan pora ahise bhi bisi manu ahise. ");
INSERT INTO nag_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Taikhan Isor kotha huni bole aru bemar pora bhal hobole nimite ahise. Kunkhan dusto atma pora dhori thakise taikhan bhi bhal hoise. ");
INSERT INTO nag_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aru manu khan Jisu ke chubole kosis korise kelemane Tai pora changai laga hokti ulai thakise. ");
INSERT INTO nag_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Titia Tai chela khan ke saise, aru koise, “Dhonyo ase dukhia manu khan, kelemane Isor laga rajyo to tumikhan nimite ase. ");
INSERT INTO nag_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Dhonyo ase jun bhuk lagi ase, kele koile tumikhan bhorta hobo. Dhonyo ase kun etiya kandi ase, kele koile tumikhan hasibo. ");
INSERT INTO nag_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dhonyo ase jitia manu pora tumikhan ke ghin koribo, tumikhan ke chari dibo aru bodnam kori kene naam biya kori dibo, Manu laga Putro karone. ");
INSERT INTO nag_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Etu din aha somoite khushi anondo pora nachibi, sabi, tumi laga inam to sorgote dangor ase. Kelemane taikhan baba laga baba khan bhi bhabobadi khan ke eneka he dukh dise. ");
INSERT INTO nag_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kintu dhun thaka manu khan, hai ase, kele koile tumikhan aram pai loise. ");
INSERT INTO nag_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hai ase kun manu etiya pet bhorta ase, kele koile tumi bhuk lagibo. Hai ase tumi kun etiya hasi ase, kele koile tumi dukh koribo aru kandibo. ");
INSERT INTO nag_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Hai ase jitia manu pora tumikhan ke bhal ase koi, kele koile taikhan baba laga baba khan bhi misa bhabobadi khan ke bhi eneka koi thakise. ");
INSERT INTO nag_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kintu kun huni ase, tumikhan ke Moi koi ase, tumi laga dushman khan ke morom koribi aru jun khan pora tumikhan ke ghin kore, taikhan ke bhal kaam dikhai dibi. ");
INSERT INTO nag_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Jun manu tumikhan ke shrap diye aru tumike digdar kore, tai nimite prathana koribi. ");
INSERT INTO nag_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jun manu tumike ekta thapor mare, taike aru alag gaal phale bhi mari bole dibi, jun manu tumi laga kapra ekta loijai, dusra ula bhi taike lobole dibi. ");
INSERT INTO nag_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tumike ki mange, etu di thaki bhi, aru jun manu tumi laga saman loijai, itu aru wapas namangibi. ");
INSERT INTO nag_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Manu ki korile tumi khushi pai, tumi bhi eneka taikhan logot koribi. ");
INSERT INTO nag_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Jodi apuni pora jun manu tumike morom kore, tumi bhi etu manu ke he morom korile, apuni nimite ki labh ase? Paapi manu bhi eitu khan ke he morom kore jun manu taikhan ke morom diye. ");
INSERT INTO nag_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jun manu tumi karone bhal kaam kore, aru tumi bhi etu manu nimite he bhal kaam kore, eneka hoile tumi nimite ki labh ase? Kile mane dusra paapi manu bhi eneka he kore. ");
INSERT INTO nag_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jun manu pora wapas pabole asha ase, taike he dile, tumi nimite ki labh ase? Dusra paapi manu pora bhi paapi manu ke dhar diye, taikhan bi etu sob pabole nimite. ");
INSERT INTO nag_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kintu dushman ke morom koribi aru bhal kaam to dikhai dibi, aru bodli te kiba pabo nimite bhabona nokoribi, eneka korile, tumi laga inam to dangor thakibo, aru tumi Sobse Mohan laga bacha khan hobo, kele koile paapi khan kun Isor ke dhanyavad nadiya, Tai pora eitu khan sobke morom kore. ");
INSERT INTO nag_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dayalu thakibi, jineka tumi laga Baba bhi dayalu ase. ");
INSERT INTO nag_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Bisar nokoribi, tumike bhi bisar nokorile. Bodnam na koribi, aru tumike bhi bodnam nakoribo, maph dibi, tumi bhi maph pabo. ");
INSERT INTO nag_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Di thaki bhi, tumi bhi pai thakibo: bhal pora dabai kene aru bhorta hoi kene dibi, aru bisi hoi kene tumi laga theng uporte giri bo. Ki hisab pora tumikhan dibo etu hisab te tumikhan bhi pabo.” ");
INSERT INTO nag_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aru Tai taikhan ke ekta dristanto koise. “Ekjon andha manu pora aru ekjon andha manu ke rasta dikha bo pare naki? Taikhan jai kene nalah te nagiribo naki? ");
INSERT INTO nag_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ekjon chela to guru pora dangor nohoi, kintu jun manu bhal kori kene sikhi loi tai guru nisena hoijai. ");
INSERT INTO nag_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tumi bhai laga suku letera ke kele sai thake, kintu tumi nijor suku laga dangor letera to nadikhe? ");
INSERT INTO nag_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tumi laga bhai ke etu kineka kobo, ‘Bhai, tumi laga suku te ki letera ase etu ami sapha kori dibo’; aru tumi laga suku te dangor letera thaka to tumi dikha nai? Kopoti khan! Poila tumi suku te letera thaka to ulabi, titia he tumi sapha pora tumi bhai laga suku te letera thaka to ulabole paribo. ");
INSERT INTO nag_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kelemane bhal ghas te biya phol naulai aru etu nisena biya ghas te bhi bhal phol naulai. ");
INSERT INTO nag_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sob ghas to tai laga phol pora he jani jai. Manu khan kata ghas pora dimoru nakate, aru jongol ghas pora angur phol nakate. ");
INSERT INTO nag_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bhal manu laga mon pora bhal bostu ulai diye, aru paapi manu bhitor pora biya he ulai diye. Kelemane mon bhitor te ki ase, tai mukh pora koi. ");
INSERT INTO nag_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Tumikhan kele Moike ‘Probhu, Probhu,’ mate aru Moi ki koi etu nakore? ");
INSERT INTO nag_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aru jun manu Moi logote ahe aru Moi laga kotha to huni kene kore, Moi tumikhan ke dikhai dibo tai kineka ase. ");
INSERT INTO nag_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tai ghor bonai thaka ekjon manu nisena ase aru bhal kori kene pathor uporte ghor bonaise aru jitia ban-pani ahise, ghor to pani pora bhorta hoi jaise, kintu ghor ke hila bo para nai, kele koile etu ghor to bhal kori kene bonaise. ");
INSERT INTO nag_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kintu kun manu huni kene kaam nakore, etu manu eneka ase, jun ghor bonaise hoilebi bhetimul to bhal diya nai. Aru jitia etu ghor te dangor hawa pani lagise, achanak pora etu ghor to purah bhangikena pura barbad hoi jaise.” ");
INSERT INTO nag_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jitia Jisu sob kotha to koi dise aru manu khan ke hunai dise, Tai Capernaum town te jaise. ");
INSERT INTO nag_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aru Rome laga ekjon henapoti laga noukar, junke tai bisi morom kore, tai bemar pora mori bole hoi thakise. ");
INSERT INTO nag_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aru jitia henapoti pora Jisu laga kotha hunise, tai Yehudi laga bura manu khan ke Jisu logote pathaise, Jisu pora jai kene tai laga noukar ke changai kori bole. ");
INSERT INTO nag_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aru jitia taikhan Jisu usorte ahise, taikhan Jisu ke eneka anurodh korise, “Tai ekjon bhal manu ase aru apuni eneka koridile bhal ase, ");
INSERT INTO nag_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kelemane tai moi khan laga desh ke morom kore, aru tai moi khan nimite synagogue bhi bonai dise.” ");
INSERT INTO nag_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Etu pora Jisu taikhan logote jaise. Kintu Tai jitia ghor te punchibole usor hoise, etu henapoti pora manu ke pathaise, aru Taike koise, “Probhu, Apuni dukh nauthabi, kelemane Moi laga ghor bhitor te Apuni ahibole moi layak nohoi. ");
INSERT INTO nag_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Etu nimite moi nijor bhi Apuni laga usorte ahibole layak nohoi, kintu Apuni ekta kotha koi dibi aru moi laga noukar changai pai jabo. ");
INSERT INTO nag_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Moi nijor bhi ekta hukum chola manu ase, moi nichete sipahi khan ase. Moi ekjon ke kobo ‘Jabi’ aru tai jai; aru dusra ke kobo, ‘Ahibi’ aru tai ahe; aru moi laga noukar ke, ‘etu koribi,’ aru tai kore.” ");
INSERT INTO nag_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aru jitia Jisu etu kotha hunise, Tai bisi asurit hoise aru jun manu khan tai laga piche kori thakise, taikhan ke saikene koise, “Moi tumikhan ke koi ase, Israel te Moi eneka biswas thaka manu dikha nai.” ");
INSERT INTO nag_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aru jitia etu manu khan ke ghor te pathai dise, taikhan noukar to bhal hoi kene thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aru dusra dinte eneka hoise jitia Jisu Nain sheher te jaise, aru Tai laga chela aru dangor manu laga bhir bhi tai logote jai thakise. ");
INSERT INTO nag_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aru jitia tai sheher laga dorjate ponchise, ekjon mora manu ke uthai loijai thaka Tai dikhise. Mora manu to tai laga bidhowa ama laga ekjon he thaka bacha asele-, aru sheher laga manu khan tai logote thakise. ");
INSERT INTO nag_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jitia Probhu taike dikhise, Tai etu ama ke bisi morom lagise aru taike koise, “Nakandibi.” ");
INSERT INTO nag_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Titia Jisu uthikena mora manu bukhi thaka chatai te chuise, aru mora manu ke bukhi thaka khan bhi ta te sidha khara hoi jaise. Titia Jisu koise, “Jawan manu, Moi tumike koi ase, uthi bhi.” ");
INSERT INTO nag_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aru titia mora manu to bohi kene kotha kobole shuru hoise, aru Jisu pora etu chokra ke tai laga ama logot di dise. ");
INSERT INTO nag_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aru etu dikhikene sob manu bhoi lagi jaise, aru Isor ke dhanyavad dibole shuru hoise, aru koise, “Ekjon dangor bhabobadi moi khan majote ahise” aru “Isor he manu uporte morom korise.” ");
INSERT INTO nag_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aru Jisu laga etu khobor to Judea desh aru usorte thaka bosti, nogor sob te bhi khobor to punchise. ");
INSERT INTO nag_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aru John laga chela khan etu sob khobor to jai kene John ke koise. Titia John pora tai laga diuta chela khan ke matise, ");
INSERT INTO nag_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aru taikhan ke Probhu ke hudibole pathaise, “Ahibole thaka Masiha to apuni ase naki, na amikhan to aru dusra ekjon ke rukhibo?” ");
INSERT INTO nag_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aru jitia taikhan Jisu usorte ahise, manu khan koise, “Baptizma Diya John pora amikhan ke etu hudibole nimite pathaise, ‘Ahibole thaka Masiha to apuni ase naki, na amikhan to aru dusra ekjon ke rukhibo?’” ");
INSERT INTO nag_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Etu homoi te Tai bisi manu ke bemar pora changai korise, biya atma pora dhora manu aru suku andha manu khan ke bhi changai korise. ");
INSERT INTO nag_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Titia Jisu pora taikhan ke koise, “Tumikhan yate pora ja pichete, John ke jai kene tumikhan ki dikhise aru hunise etu kobi. Andha manu khan dikhi pai ase, lengra khan bera bole pari ase, korhi bemar thaka khan sapha hoi ase aru kaan benga khan huni ase, mora manu jinda hoi ase, aru gorib manu khan susamachar laga kotha huni bole pai ase. ");
INSERT INTO nag_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dhonyo ase jun manu moi uporte biya napai.” ");
INSERT INTO nag_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aru jitia John laga khobor bukha manu khan jai jaise, Jisu pora manu khan ke John laga kotha kobole shuru hoise, “Tumikhan balu jagate ki sabole jaise? Ekta hawa pora hilai diya jongol ghas to? ");
INSERT INTO nag_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kintu tumikhan bahar te ki sabole jaise? Ekjon manu norom aru daam kapra lagai kene thaka to? Sabi, jun manu daam kapra lagai ase, aru aram pora thaki ase taikhan sob raja laga ghorkhan te pabo. ");
INSERT INTO nag_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kintu tumikhan bahar te ki sabole nimite jaise? Ekjon bhabobadi? Hoi, moi tumikhan ke koise, tai to bhabobadi pora bhi dangor ase. ");
INSERT INTO nag_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Etu tai ase jun nimite etu Shastro te likha ase, ‘Sabi, Moi ekjon manu ke pathai ase, tumi laga chehera usorte te, Jun he rasta to taiyar koribo.’ ");
INSERT INTO nag_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Moi tumikhan ke koi ase, jun manu ama pora jonom loise, kun bhi John nisena dangor nai, kintu jun Isor laga rajyote sobse chutu ase, tai pora bhi dangor ase.” ");
INSERT INTO nag_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aru jiman manu etu kotha hunise, poisa utha manu khan, aru John logote baptizma luwa khan sob Isor pora dharmik ase koi dise. ");
INSERT INTO nag_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kintu Pharisee khan aru niyom jana Yehudi khan Isor laga itcha namani kene baptizma luwa nai. ");
INSERT INTO nag_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Tinehoile, Moi, etiya laga jamana khan ke ki logote tulona koribo, taikhan ki nisena ase? ");
INSERT INTO nag_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Taikhan bajar te thaka bacha khan nisena ase, bohi kene ekjon-ekjon ke mati kene koi, ‘Ami tumikhan usorte shadi laga basuri bojaise, tumikhan nach kora nai; moi khan mon dukh laga gana korise, hoilebi tumikhan kandia nai.’ ");
INSERT INTO nag_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Baptizma Diya John to ahikena bhaat aru angur ros bhi khanai, aru tumikhan koi ase, ‘Tai logote bhoot ase.’ ");
INSERT INTO nag_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kintu Manu laga Putro ahikena kha luwa korise, aru tumikhan koi, ‘Sabi, taike, ekjon khakuwa aru nisa-pani kora, poisa utha khan aru dusra paapi manu laga sathi!’ ");
INSERT INTO nag_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gyaan pora sob bhal aru biya to jani loi.” ");
INSERT INTO nag_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ekjon Pharisee pora Jisu ke tai logote khabole matise. Tai Pharisee laga ghor te punchise, aru Tai khabole bohise. ");
INSERT INTO nag_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Etiya sabi, etu sheher te ekjon paapi mahila thakise. Jitia tai Jisu to Pharisee laga ghor te khabole bohi thaka dikhise, tai bhal gundh thaka bisi daam laga tel anise, ");
INSERT INTO nag_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","aru khara hoi kene Jisu laga theng usorte kandi kene tai laga suku pani pora Jisu laga theng bhi jai dise aru chuli pora mussi kene tai laga theng ke chumai dise, aru bhal gundh tel lagai dise. ");
INSERT INTO nag_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Etu dikhikene, Jisu ke mata Pharisee tai nije ke koise, “Jodi etu manu hosa bhi bhabobadi ase koile, Tai janibo thakise etu jun taike choi ase, etu kineka mahila ase.” ");
INSERT INTO nag_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Aru Jisu taike koise, “Simon, Moi tumike kiba kobole itcha ase.” Aru tai koise, “Koi dibi, Probhu!” ");
INSERT INTO nag_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Duita manu poisa dhar loise. Ekjon pansho denari aru dusra to pachas denari loi kene thakise. ");
INSERT INTO nag_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aru jitia taikhan logote wapas dibole poisa thaka nai, malik pora duijon ke maph kori dise. Etu nimite kun manu pora taike bisi morom koribo? ");
INSERT INTO nag_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon koise, “Moi hisab te junke tai bisi dhar to maph korise.” Titia Tai taike koise, “Tumi thik bhabona korise.” ");
INSERT INTO nag_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aru titia Jisu etu mahila phale saikene Simon ke koise, “Tumi etu mahila ke dikhi ase. Moi tumi laga ghor te ahise. Tumi Moike theng dhula bole pani bhi diya nai, kintu tai laga suku pani pora moi laga theng bhi jai dise, aru tai laga chuli pora mussi dise. ");
INSERT INTO nag_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tumi Moike ekta chuma bhi diya nai, kintu Moi jitia pora yate ahise tai moi laga theng to chuma dibole chara nai. ");
INSERT INTO nag_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tumi Moi laga matha te tel dhala nai, kintu tai Moi laga theng te bhal gundh thaka tel pora mussi se. ");
INSERT INTO nag_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Etu nimite Moi tumike koi ase, tai laga paap bisi thakise, etu sob maph kori dise- kelemane tai bisi morom korise, kintu jun manu olop he maph kore, tai olop he morom kore.” ");
INSERT INTO nag_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Titia Jisu pora mahila ke koise, “Tumi laga paap sob khyama koridi ase.” ");
INSERT INTO nag_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jun manu khan ta te bohi thakise taikhan majote kobole shuru hoise, “Etu kun ase, jun paap bhi maph kori bole pare?” ");
INSERT INTO nag_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Titia Jisu mahila ke koise, “Tumi laga biswas he tumike bachai loise. Shanti pora jabi.” ");
INSERT INTO nag_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aru eneka hoise, Jisu alag-alag sheher aru bosti te Isor laga rajyo laga kotha prochar kori kene jai thakise, aru Tai logote baroh jon chela khan bhi thakise, ");
INSERT INTO nag_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","aru kunba mahila khan bhi thakise jun khan dusto atma pora changai paise aru bemar pora bhal hoise. Mary, kunke Magdalene mate, jun laga gaw pora sat-ta bhoot khedaise; ");
INSERT INTO nag_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","aru Joanna, Chuza laga maiki, Herod raja laga imandar,aru Susanna; aru dusra manu khan kun Isor laga kaam nimite taikhan logote ki ase etu di thakise. ");
INSERT INTO nag_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Aru jitia bisi dangor manu laga bhir joma hoi thakise aru manu khan alag-alag nogor pora ahise, Jisu dristanto pora taikhan ke koise: ");
INSERT INTO nag_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ekjon kheti kora manu bijon hissi bole jaise. Aru jitia tai bijon halise, kunba rasta te girise, aru theng pora chipai dise, aru akas te chiriya thaka khan pora khai dise. ");
INSERT INTO nag_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aru kunba bijon pathor uporte girise, aru jitia dangor hoise, etu sukhi jaise, kelemane pathor uporte bisi patla mati thakise. ");
INSERT INTO nag_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aru kunba bijon to kata majote girise, aru dangor bhi hoise, hoilebi kata pora dabai dise. ");
INSERT INTO nag_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kintu kunba bijon to bhal matite girise, aru jitia etu dangor hoise, bisi dhan dhurise. “Etu kowa pichete, Tai awaj uthaikene koise, “Kun manu logot huni bole khan ase, tai huni lobi.” ");
INSERT INTO nag_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Titia chela khan Taike hudise, “Etu dristanto laga ki motlob ase?” ");
INSERT INTO nag_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tai koise, “Tumikhan ke Isor he sorgo laga rajyo janibole dise, kintu dusra manu ke Moi dristanto pora koi, utu karone taikhan sai thakile bhi nadikha aru hunile bhi bujhi bole napare.’ ");
INSERT INTO nag_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Etiya dristanto laga motlob eneka ase: bijon to Isor laga kotha ase. ");
INSERT INTO nag_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Rasta te gira bijon laga motlob kunba khan kotha hunise, kintu bhoot ahi kene mon pora bijon ke chingi loijai, etu pora taikhan biswas nokorile aru roikhya napabo. ");
INSERT INTO nag_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aru pathor uporte bijon gira to kunba Isor laga kotha khushi pora hunise. Kintu tai laga jor to bhitor te jabo napare, aru olop homoi nimite biswas kore, aru porikha aha homoi te giri jai. ");
INSERT INTO nag_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aru kata bhitor te gira bijon ase jun khan kotha hune, kintu duniya pora tani loi, dhun sampoti, rong tamash aru lalaj pora bandhi jai aru uthibole napare. ");
INSERT INTO nag_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kintu bhal matite gira bijon khan taikhan ase kunkhan mon dikena Isor kotha ke hunise aru monte rakhise, aru thik pora dhuri rakhise aru pichete bhal guti dhore. ");
INSERT INTO nag_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kun manu bhi saaki jolai kene bisna nichete narakhe. Kintu etu ke uporte rakhe, aru sob manu etu laga puhor dikhi bole pai. ");
INSERT INTO nag_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Eku bostu lukai kene rakhibo na paribo, kele koile puhor pora sob bostu dikhai dibo. ");
INSERT INTO nag_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Etu karone ki hune ase, jun manu logot bisi ase, tai arubi bisi pabo, aru kun manu logot komti ase, tai logote ki ase etu bhi loijabo.” ");
INSERT INTO nag_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pichete Jisu laga ama aru bhai khan Jisu usorte ahise, kintu taikhan Jisu thaka usorte jabo para nai kelemane manu laga bhir dangor thakise. ");
INSERT INTO nag_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jisu ke manu khan khobor dise, “Apuni laga ama aru bhai khan bahar te rukhi ase, Apnike lok kori bole rukhi ase.” ");
INSERT INTO nag_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kintu Jisu Khrista taikhan ke jowab dise, “Ami laga ama aru bhai eitu khan ase jun manu Isor kotha hune aru kore.” ");
INSERT INTO nag_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Etu ek din eneka hoise, Tai chela khan logote ekta naw te uthise, aru taikhan ke koise, “Ahibi amikhan nodi laga dusra phale jabo.” Aru taikhan bohi kene jaise. ");
INSERT INTO nag_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Naw te jai thaka homoi te Tai ghumai jaise. Etu homoi te dangor andhi ahise. Taikhan laga naw panite gushi bole shuru hoise aru taikhan moribo bhabi thakise. ");
INSERT INTO nag_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Taikhan Jisu ke uthaise aru koise, “Probhu! Probhu! Moi khan sob mori bole ase!” Kintu Tai uthikena hawa pani ke hukum korise, aru bisi shanti hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jisu taikhan ke koise, “Tumikhan laga biswas to kot te ase?” Aru taikhan bhoi pora asurit hoi kene majote ke koise, “Etu kun ase, Tai hawa aru pani ke hukum dise, aru taikhan manise?” ");
INSERT INTO nag_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pichete taikhan nodi paar kori kene Gerasenes, Galilee nodi usorte jaise. ");
INSERT INTO nag_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aru jitia Jisu matite namise, ekjon manu bisi bhoot pora dhora sheher pora ahi kene Jisu ke lok paise. Bisi din pora tai gaw te kapra nalagai kene, ghor te bhi thakibo napari kene, koboristan te he thaki asele. ");
INSERT INTO nag_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aru jitia tai Jisu ke dikhise, tai jor pora kandise, aru Tai age te girise aru jor pora hala kori kene koise, “Apuni moi logot ki kaam ase, Jisu, jinda Isor laga Putro? Moi anurodh kori ase, moike dukh nadibi.” ");
INSERT INTO nag_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jisu he dusto atma ke etu manu pora ulai jabole hukum dise. Bisi bar itu manu ke morai dibo nisena korise, loha laga rusi pora bandhi kene thakile bhi, manu khan pora bandhi rakhile bhi, sob rusi khan bhangai kene taike bhoot pora jongol te loijai thake. ");
INSERT INTO nag_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Titia Jisu pora taike hudise, “Tumi laga naam ki ase?” Tai jowab dise, “Legion,” kelemane bisi bhoot khan tai bhitor te thakise. ");
INSERT INTO nag_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aru taikhan ke mora manu thaka jagate jabole hukum nadibi koi kene Taike anurodh korise. ");
INSERT INTO nag_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aru etu usorte gahori khan tilla kinar te dana khai thakise, etu pora biya atma khan gahori bhitor te jabole nimite anurodh korise. Jisu pora eneka hobole dise. ");
INSERT INTO nag_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aru bhoot khan manu pora ulaikene gahori bhitor te ghumai jaise, aru gahori sob pahar nichete giri kene mori jaise. ");
INSERT INTO nag_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Gahori pala manu khan etu dikhi kene sheher te polaikene khobor dise. ");
INSERT INTO nag_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Aru manu khan ki hoise etu sabole ahise, aru jun laga gaw pora biya atma ulai jaise, taike Jisu laga theng usorte bohi thaka dikhise, sapha kapra lagase aru bhal hoise aru etu saikene manu khan bhoi lagise. ");
INSERT INTO nag_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aru jitia taikhan dikhise kineka bisi bhoot pora dhora manu to bhal hoise, taikhan pora jai kene itu laga khobor sobke dise. ");
INSERT INTO nag_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aru Gerasenes laga sob manu khan bhoi lagi kene Jisu ke etu jaga pora jai jabole koise. Etu pichete, Tai naw te bohi kene wapas jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jun manu pora biya atma khan ulaikene jaise, tai Jisu logote jabole anurodh korise, kintu Jisu pora taike wapas pathai kene koise, ");
INSERT INTO nag_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Tumi nijor ghor te jabi aru Isor ki kori dise etu jai kene koi dibi.” Tai pichete tai ghor te jaise, sob sheher te Jisu pora tai nimite ki kori dise etu prochar kori dise. ");
INSERT INTO nag_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jitia Jisu ahise, sob manu khan taike salam korise, kelemane taikhan Taike rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aru ta te ekjon manu thakise tai laga naam Jairus asele, tai mondoli laga cholawta thakise. Tai Jisu laga theng te giri jaise, aru Jisu ke tai laga ghor te ahibole anurodh korise. ");
INSERT INTO nag_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tai laga ekjon baroh saal chukri mori bole asele aru jitia tai rasta te jai thakise, bisi manu khan tai logote joma hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ekjon mahila baroh saal pora khun jai thakise, tai dawai diya manu logote sob taka poisa kharcha korise, kintu kun bhi taike bhal kori bole pora nai. ");
INSERT INTO nag_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tai piche pora jai kene manu majot pora Jisu laga kapra chuise, aru etu loge-loge te tai laga khun jai thaka rukhi jaise. ");
INSERT INTO nag_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Titia Jisu koise, “Kun pora Moike chuise?” Jitia sob manu chup thakise, Peter koise, “Probhu, bisi manu khan ahi kene Apuni ke chui ase.” ");
INSERT INTO nag_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kintu Jisu he koise, “Kunba Moike chuise, Moi jani ase, Moi pora hokti ulai jaise.” ");
INSERT INTO nag_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jitia mahila to luka bole napara hoise, tai bhoi pora kapi kene Jisu usorte girise. Sob manu usorte tai koi dise ki nimite tai Jisu ke choise, aru kineka tai ekbar pora bhal hoise. ");
INSERT INTO nag_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisu pora taike koise, “Swali, tumi laga biswas pora tumi bhal hoise. Shanti pora jabi.” ");
INSERT INTO nag_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aru Tai kotha koi thaka homoi te, synagogue laga kunba cholawta ghor pora ahise, aru koise, “Tumi laga swali to mori jaise. Sikhai diya manu ke aru dukh nadibi.” ");
INSERT INTO nag_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kintu jitia Jisu etu hunise, Tai eneka taike koise, “Bhoi na koribi; khali biswas koribi, aru tai changai hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aru jitia tai ghor te ahise, Tai kunke bhi bhitor te ahibole diya nai, khali Peter, John aru James, aru bacha laga ama aru baba ke he ahibole dise. ");
INSERT INTO nag_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aru sob manu monte dukh kori kene tai nimite kandi thakise, “Nakandibi, tai mora nai, kintu ghumai ase.” ");
INSERT INTO nag_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kintu taikhan Taike hasi dise, swali to morise bhabikena. ");
INSERT INTO nag_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kintu Jisu, tai laga hath to dhorise aru matikena koise, “Bacha, uthibi!” ");
INSERT INTO nag_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Titia tai laga atma wapas ahise aru tai uthikena kiba khabole mangise. ");
INSERT INTO nag_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tai laga ama aru baba asurit lagise, kintu Jisu pora taikhan ke ki hoise etu kunke bhi nakobi eneka koise. ");
INSERT INTO nag_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Aru jitia Jisu baroh jon chela khan ke matise, Tai pora chela khan ke bhoot khan ke kheda bole aru bemar ke bhal kori bole laga hokti aru adhikar dise, ");
INSERT INTO nag_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","aru Tai taikhan ke pathaise, bemar manu ke changai kori bole aru Isor rajyo laga kotha kobole nimite. ");
INSERT INTO nag_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aru Jisu taikhan ke koise, “Eku loi najabi- tumi laga jola, lathi, poisa aru bhaat, duita kapra bhi loi najabi. ");
INSERT INTO nag_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Juntu ghor te ghusi bo, ta te he thakibi, jitia tak etu jaga to nachare. ");
INSERT INTO nag_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jun jagate tumikhan ke namate, etu sheher pora ula homoi te, tumi laga theng pora dhuli to hatai dibi, etu he taikhan bhirodh te ekta sakhi hobo.” ");
INSERT INTO nag_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aru taikhan alag hoi kene bosti khan phale jai jaise, Isor laga kotha prochar kori kene, sob jagate changai kori kene jaise. ");
INSERT INTO nag_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jitia Herod raja pora etukhan sob hunise, tai bhoi hoi kene bhabona korise, kelemane kunba pora koise John to mora pora jinda hoise, ");
INSERT INTO nag_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","aru kunba koise Elijah he ahise, aru kunba pora koise, poila laga bhabobadi ekjon jinda hoise. ");
INSERT INTO nag_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kintu Herod koise, “Moi John laga matha alag kori dise, kintu etu kun ase jun laga moi iman kotha huni ase?” Aru tai Jisu ke sabole kosis kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aru jitia apostle khan wapas ahise, taikhan ki korise etu sob Jisu ke koi dise. Titia Jisu pora taikhan ke loi jaise, aru ekdom chup-chap pora Bethsaida sheher te taikhan sob jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kintu jitia manu laga bhir khan etu hunise, taikhan bhi Jisu piche korise. Titia Tai sobke matise aru Isor laga rajyo kotha taikhan logote koise, aru jun manu changai lage, taikhan ke changai korise. ");
INSERT INTO nag_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Etiya saam hobole homoi hoise, baroh jon chela khan Tai usorte ahikena koise, “Manu laga bhir khan ke pathai dibi, taikhan usor bosti te jai kene ghuma bole aru khabole bisaribo, kelemane moi khan eku napai-a jagate ase.” ");
INSERT INTO nag_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kintu Jisu taikhan ke koise, “Tumikhan manu khan ke kiba khabole dibi.” Kintu taikhan koise, “Moi khan logote pasta roti aru duita maas he ase- jodi moi khan jai kene sob manu nimite khana kina nai koile.” ");
INSERT INTO nag_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","-Ta te panch hajar manu thakise.- Titia Tai pora chela khan ke koise, “Taikhan ke ekta bhag te pachas manu kori kene bohibo dibi.” ");
INSERT INTO nag_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aru taikhan eneka korise aru sobke bohi bole dise. ");
INSERT INTO nag_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pasta roti aru duita maas to hathte loi kene, Tai sorgo phale saise, dhonyabad dise aru bhangaikena chela khan ke dibole dise. ");
INSERT INTO nag_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Taikhan sob khai kene bhorta hoise, aru bachi juwa sob uthaise- aru baroh ta tukri te uthaise. ");
INSERT INTO nag_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Aru ek din eneka hoise jitia Jisu Tai ekla pora prathana kori thakise, aru chela khan bhi Tai logote thakise, aru Tai taikhan ke hudise, “Manu khan pora Moi kun ase koi?” ");
INSERT INTO nag_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Taikhan koise, “Baptizma Diya John Aru kunba koi Elijah, aru dusra khan pora koi purana homoi pora jinda huwa bhabobadi ekjon.” ");
INSERT INTO nag_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Titia Tai taikhan ke koise, “Kintu tumikhan Moi kun ase koi?” Titia Peter he koise, “Isor laga Khrista.” ");
INSERT INTO nag_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kintu Tai pora taikhan ke etu kotha kunke bhi nokobole koise. ");
INSERT INTO nag_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tai koise, “Manu laga Putro bisi dukh pabo aru cholawta khan Taike swekar nakoribo, mukhyo purohit khan aru niyom likha khan pora bhi golti dhoribo aru Taike morai dibo, kintu Tai tin dinte arubi jinda hobo.” ");
INSERT INTO nag_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aru Tai sobke koise, “Kunba manu Moi pichete ahibole itcha thakile, tai nijorke pahoribo lage aru hodai cross uthaikene moi pichete ahibo lage. ");
INSERT INTO nag_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jun manu tai laga jibon to bacha bole kaam koribo tai harai dibo; kintu jun manu moi nimite jibon dibo, tai jibon pabo. ");
INSERT INTO nag_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Jibon te ki labh ase, sob duniya to paile bhi, nijor jibon to nuksan korile? ");
INSERT INTO nag_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kun manu moi laga kotha aru moi nimite sorom kore, jitia Manu laga Putro Tai nijor laga mohima aru Baba laga mohima aru pobitro sorgodoth khan laga mohima pora wapas ahibo, etu homoi te etu manu nimite moi bhi sorom hobo. ");
INSERT INTO nag_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kintu moi hosa kotha koi ase, kunba manu khan yate rukhi ase, taikhan Isor laga rajyo nadikha tak namoribo.” ");
INSERT INTO nag_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Etu kotha khan kowa ath din pichete, Tai tilla uporte prathana kori bole jaise, Peter, John aru James khan ke loi kene. ");
INSERT INTO nag_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jitia Tai prathana kori thakise, Tai laga chehera bodli hoise, aru Tai laga kapra to asurit laga boga hoise. ");
INSERT INTO nag_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aru sabi, duijon manu Tai logote kotha koi thakise, Moses aru Elijah thakise, ");
INSERT INTO nag_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mohima pora taikhan ahise, tai jabo laga kotha to patise, juntu Jerusalem te pura hoi jabo. ");
INSERT INTO nag_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jitia Peter aru sathi khan ghumai thakise, aru uthise, taikhan Tai laga mohima dikhise, aru duijon manu Tai logote khara hoi thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pichete eneka hoise, jitia duijon manu Jisu usor pora jai thakise, Peter Taike koise, “Probhu, amikhan yate tinta khamba bonabo, ekta apuni nimite, ekta Moses karone, aru ekta Elijah karone.” -Tai ki koi thakise tai najane.- ");
INSERT INTO nag_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kintu jitia tai etu koise, ekta badal ahikena taikhan ke lukai dise, aru taikhan bhoi lagise. ");
INSERT INTO nag_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aru akas pora ekta awaj ahise, “Etu Ami laga Putro ase, junke Moi basi loise; Tai laga kotha huni bhi.” ");
INSERT INTO nag_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jitia etu kotha khotom hoise, taikhan Jisu ekla thaka dikhise. Taikhan chup thakise aru ki dikhise kunke bhi kowa nai. ");
INSERT INTO nag_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Aru ek dinte eneka hoise, jitia taikhan pahar upor pora nichete ahise, dangor bhir ke lok paise. ");
INSERT INTO nag_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aru sabi, ekjon manu majot pora hala kori, koise, “Sikhai diya manu, moi anurodh korise, ami laga bacha ke sabi, tai moi laga ekjon bacha he ase. ");
INSERT INTO nag_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sabi, ekjon atma achanak pora dhori kene tai laga mukh pora letera thuk ulaise. Aru taike jokhom kori kene ulai jaise. ");
INSERT INTO nag_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Moi Apuni laga chela khan ke atma kheda bole anurodh korise, kintu taikhan kheda bole para nai.” ");
INSERT INTO nag_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Titia Jisu taikhan ke jowab dise, “Biswas nathaka aru biya rasta te jai thaka manu khan, Moi tumikhan logote kiman din thakibo? Tumi laga chokra ke yate anibi.” ");
INSERT INTO nag_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jitia chokra ke ani thakise, atma pora taike matite girai kene bisi hilai dise. Kintu Jisu pora dusto atma ke gali dise, aru chokra ke bhal kori dise, aru tai baba logot di dise. ");
INSERT INTO nag_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Taikhan Isor laga asurit kaam to dikhise. Kintu jitia manu khan ki hoise etu dikhise taikhan asurit lagise, Jisu tai laga chela khan ke koise, ");
INSERT INTO nag_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Etu kotha tumikhan mon bhitor te jabole dibi: kele koile Manu laga Putro ke manu laga hathte thogai pora di dibole ase.” ");
INSERT INTO nag_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kintu taikhan etu kotha bujhi bole para nai. Etu kotha taikhan pora lukai kene thakise, etu karone taikhan bujhi bole para nai, aru taikhan Jisu ke etu kotha hudibole bhoi lagise. ");
INSERT INTO nag_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pichete chela khan majote kun he sob pora dangor hobo itu laga kotha ulaise. ");
INSERT INTO nag_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kintu Jisu taikhan laga monte ki bhabona kori ase etu jani loise, aru ekjon chutu bacha ke Tai usorte uthai loise, ");
INSERT INTO nag_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","aru taikhan ke koise, “Jun manu etu bacha ke Moi laga naam pora grohon kore, tai Moike grohon kore; aru jun manu Moike grohon kore, jun Moike pathaise Taike bhi grohon kore. Kun manu nijorke chutu koribo, tai he dangor hobo.” ");
INSERT INTO nag_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John koise, “Probhu, amikhan dikhise kunba manu Apuni laga naam pora bhoot khedai se aru amikhan taike rukhai dise, kele koile tai moi khan logot nohoi.” ");
INSERT INTO nag_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kintu Jisu pora taikhan ke koise, “Taikhan ke narukhabi, jun manu tumikhan bhirodh te nai, tai tumikhan logote ase.” ");
INSERT INTO nag_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Etiya, Taike sorgote uthai loi jabole laga din to usorte hoise, Tai Jerusalem te jabole bisi mon hoise. ");
INSERT INTO nag_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tai poila ekjon chela ke pathaise, aru taikhan Samaria bosti bhitor te punchi kene sob kaam taiyar korise. ");
INSERT INTO nag_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kintu ta te thaka manu khan Taike grohon kora nai, kelemane tai Jerusalem te jabole he mon thakise. ");
INSERT INTO nag_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aru jitia chela khan James aru John ke dikhise, taikhan koise, “Probhu, amikhan sorgo pora jui ahi kene taikhan ke khotom kori bole kobo naki?” ");
INSERT INTO nag_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kintu Tai ghuri kene taikhan ke gali dise, ");
INSERT INTO nag_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","aru taikhan ta te pora alag bosti te jaise. ");
INSERT INTO nag_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Taikhan rasta te jai thaka homoi te, kunba ekjon Jisu ke koise, “Apuni kun jagate jabo moi bhi apuni logote jabo.” ");
INSERT INTO nag_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisu taike koise, “Siyal khan laga bhi gath ase aru akas te chiriya khan laga bhi ghor ase, hoile bhi Manu laga Putro laga matha rakhibole eku bhi jaga nai.” ");
INSERT INTO nag_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Titia Jisu aru ekjon ke koise, “Moi laga piche ahibi.” Kintu tai koise, “Probhu, poila moi jai kene moi laga baba ke kobor dikene ahibo.” ");
INSERT INTO nag_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kintu Tai koise, “Mora khan pora mora khan ke kobor dibo. Kintu tumi, jai kene Isor laga rajyo prochar koribi.” ");
INSERT INTO nag_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aru ekjon koise, “Moi bhi Apuni laga piche ahibo, Probhu, kintu moi poila jai kene sob ghor manu ke jai ase kobo.” ");
INSERT INTO nag_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kintu Jisu koise, “Jun manu kheti te hal dhori kene pichete nasai, tai he Isor laga rajyo nimite thik ase.” ");
INSERT INTO nag_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aru jitia etu sob kaam pura hoise, Probhu pora aru bhi bahatar manu ke mati kene Isor kaam nimite asirbad korise, aru duijon-duijon kori kene taikhan ke pathaise jun jagate Jisu nijor bhi jabo thakise. ");
INSERT INTO nag_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tai koise, “Kheti to bhorta hoise, kintu kaam kora manu olop he ase. Etu nimite kheti laga Probhu ke kobi, kaam kora manu pathai dibole nimite. ");
INSERT INTO nag_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nijor rasta te jai thakibi, sabi, Moi tumikhan ke ekta mer khan nisena rong kutta usorte pathai ase. ");
INSERT INTO nag_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Poisa laga jola nolobi, rasta te jabole laga jola bhi nolobi, aru nijor chapal bhi nolobi, aru rasta te jai thaka homoi te kunke bhi salam nadibi. ");
INSERT INTO nag_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jun to ghor te poila ghusi bo, poila kobi, ‘Shanti etu ghor te thakibi!’ ");
INSERT INTO nag_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jodi shanti laga chokra ta te ase koile, titia tumi laga shanti tai uporte thakibo; jodi nohoi, etu shanti tumi logote wapas ahijabo. ");
INSERT INTO nag_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Etiya etu ghor te he thakibi, ki kha luwa di ase etu khai kene thakibi, kelemane ki kaam kori ase, etu laga labh to pabole lage. Aru ekta ghor pora alag ghor te jai nathaki bhi. ");
INSERT INTO nag_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tumikhan juntu sheher te jabo, jodi taikhan tumike grohon kore, titia tumikhan ke ki khabole diye, etu he khabi. ");
INSERT INTO nag_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aru jun manu bemar ase taike changai koribi, aru taikhan ke kobi, ‘Isor laga rajyo tumikhan usorte ahise.’ ");
INSERT INTO nag_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kintu jun sheher te tumikhan ke namate etu laga rasta te ulaikene kobi, ");
INSERT INTO nag_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Juntu dhuli moi khan laga theng te lage etu bhi sapha kori ase tumikhan bhirodh te! Kintu etu jani lobi, Isor laga rajyo to usorte ahise.’ ");
INSERT INTO nag_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Moi tumikhan ke koi ase etu dinte tumikhan Sodom aru Gomorrah te dukh pa pora bhi bisi dukh pabo. ");
INSERT INTO nag_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hai ase tumi, Chorazin sheher! Hai ase tumi, Bethsaida sheher! Jintu dangor kaam tumikhan nimite kori dise, etu kaam Tyre aru Sidon sheher khan nimite korise koile, taikhan poila pora mon ghurai kene thakibo. ");
INSERT INTO nag_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kintu Tyre aru Sidon pora bhi bisi dukh tumikhan pabo, juntu dinte tumikhan logote Isor laga bisar hobo. ");
INSERT INTO nag_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aru tumi Capernaum town, tumike sorgote uthai loi najabo na, na uthai loijabo? Tumikhan ke ekdom niche, Hades te phelai dibo. ");
INSERT INTO nag_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jun manu tumikhan laga kotha hune, taikhan Moike hune aru jun tumikhan ke ghin kore taikhan Moike ghin kore, aru jun Moike grohon nakore, tai kun pora Moike pathaise, Taike bhi grohon nakore.” ");
INSERT INTO nag_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aru titia bahatar jon khushi pora jai kene koise, “Probhu, bhoot khan bhi Apuni laga naam te amikhan laga kotha mane.” ");
INSERT INTO nag_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Titia Tai koise, “Moi sai thakise Saitan sorgo pora bhijili nisena girise. ");
INSERT INTO nag_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sabi, Moi tumikhan ke saph aru bhichoo khan ke khotom kori bole nimite takot dise, aru jiman dushman laga takot ase etu sob khan ke khotom kori bole nimite dise, aru eku pora bhi tumikhan ke jokhom kori bole napari bole dise. ");
INSERT INTO nag_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hoilebi tumikhan etu dusto atma khan pora tumikhan laga kotha mani ase koi kene he khushi na koribi, kintu khushi koribi ki karone tumikhan laga naam sorgote likha ase.” ");
INSERT INTO nag_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aru etu homoi te Jisu ke Pobitro Atma pora bisi khushi korise aru koise, “Moi Apuni ke dhanyavad di ase Baba, sorgo aru prithibi laga Probhu, kelemane Apuni etu sob kotha to gyaani aru bujhi bole pora manu khan logote lukai kene rakhise, aru etu sob kotha to chutu bacha khan ke janibole dise. Hoi Baba, etu sob Apuni usorte sabole bhal dikhe.” ");
INSERT INTO nag_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Etu sob kaam aru kotha to Moi laga Baba pora Moike dise, aru kun bhi najane Putro to kun ase, khali Baba he jane, aru kun Baba ase etu khali Putro pora he jane, aru kunke Putro pora mati lobo taike he sob to dikhai dibo.” ");
INSERT INTO nag_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Titia Tai chela khan ke ghuri kene saise aru aste pora koise, “Dhonyo ase etu sukukhan, manu nadikha tumikhan ke sabo dise. ");
INSERT INTO nag_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Moi tumikhan ke koi ase, bisi bhabobadi aru raja khan tumikhan ki dikhise etu sabole nimite bisi itcha korise, kintu taikhan etu dikha nai, aru tumikhan ki hunise taikhan etu huni bole mon korise kintu taikhan huni bole panai.” ");
INSERT INTO nag_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aru sabi, ekjon Yehudi laga niyom jana manu Jisu ke porikha kori bole nimite khara hoise aru, koise, “Probhu moi anonto jibon pabole nimite ki kori bole lage?” ");
INSERT INTO nag_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Titia Jisu he taike koise, “Niom hisab te ki likha ase? Tumi etu kineka porhe?” ");
INSERT INTO nag_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Titia tai koise, “Tumi Probhu Isor ke pura mon pora morom koribi, aru tumi laga jibon pora, aru takot pora, aru tumi laga bhabona pora, aru tumi usorte thaka manu ke tumi nijorke kineka morom kore etu nisena morom koribi. ");
INSERT INTO nag_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Titia Jisu taike koise, “Tumi thik kotha koise. Eneka koribi, aru tumi jinda thakibo.” ");
INSERT INTO nag_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kintu tai nijorke thik dikha bole nimite, Jisu ke koise, “Moi laga usorte thaka manu to kun ase?” ");
INSERT INTO nag_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Titia Jisu taike jowab dikene koise, “Ekjon manu Jerusalem pora Jericho phale jai thakise. Taike chor aru dokait khan pora dhuri kene marise aru tai laga kapra phatai khan phatai dise aru taike adha mora chari kene polai jaise. ");
INSERT INTO nag_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Titia achanak pora ekjon purohit etu rasta pora jai thakise, aru jitia tai etu manu ke dikhise, tai dusra phale jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Etu nisena, ekjon Levi, jitia tai etu jagate ahikena manu ke dikhise, tai bhi dusra phale jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kintu ekjon Samaria laga manu, tai safar kori thaka homoi te, etu manu usorte ahise aru jitia taike dikhise, tai bisi mon dukh hoise aru morom lagi jaise. ");
INSERT INTO nag_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aru jitia etu manu usorte punchise, tai laga gaw te jokhom khan tel aru angur ros pora sapha kori kene bandi dise. Aru etu pichete, tai laga janwar uporte uthai dise, aru ekta ghor te loi jaise, aru taike bhal pora sai dise. ");
INSERT INTO nag_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aru dusra dinte tai duita denari ulaikene ta te thaka manu khan ke dise aru koise, “Taike bhal pora sabi, aru ki khorcha korile bhi, jitia moi aru wapas ahibo, etu homoi te moi sob di dibo.’ ");
INSERT INTO nag_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tumi ki bhabe, taikhan tinjon bhitor te kun he tai laga asol usor thaka manu ase junke dokait aru chor khan pora mari kene chari dise?” ");
INSERT INTO nag_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Titia tai koise, “Taike morom kora jon pora.” Titia Jisu taike koise, “Jabi aru tumi bhi eneka he koribi.” ");
INSERT INTO nag_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aru taikhan jai thaka homoi te, Tai ekta bosti te ghusi se, aru ta te Martha koi kene ekjon mahila thakise, tai pora Jisu ke tai laga ghor te matise. ");
INSERT INTO nag_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tai laga ekjon bhoini Mary koi kene thakise, aru tai Jisu laga theng usorte bohi kene Tai ki kotha koi ase etu huni thakise. ");
INSERT INTO nag_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kintu Martha olop biya lagise kelemane tai sob kaam to ekla kori thakise, etu karone tai jai kene koise, “Probhu, Apuni eku chinta nakore naki moi laga bhoini moike kaam kori bole ekla chari dise? Etu nimite moike modot kori bole nimite taike kobi.” ");
INSERT INTO nag_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Titia Probhu pora Martha ke jowab dise, “Martha, Martha, tumi bisi alag kaam nimite chinta kori ase, ");
INSERT INTO nag_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kintu khali ekta kaam he bisi dorkar ase. Aru Mary pora etu bhal kaam bisari loise, aru etu tai logot pora kitia bhi loi najabo.” ");
INSERT INTO nag_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aru ek din eneka hoise, Jisu ekta jagate prathana kori thakise, jitia khotom hoise, ekjon chela Taike hudise, “Probhu, amikhan ke prathana sikhai dibi jineka John tai laga chela khan ke sikhaise.” ");
INSERT INTO nag_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tai chela khan ke koise, “Jitia tumikhan prathana koribo eneka kobi, ‘Sorgote thaka amikhan laga Baba, Apuni laga naam honmanio hobole dibi, Apuni laga rajyo ahibole dibi. ");
INSERT INTO nag_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hodai laga kha luwa amikhan ke dibi. ");
INSERT INTO nag_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Amikhan laga paap pora amikhan ke maph kori dibi, Amikhan bhi dusra laga paap maph diya nisena Jun khan amikhan ke baki ase. Amikhan ke porikha te giribole nadibi.’” ");
INSERT INTO nag_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aru Tai taikhan ke koise, “Tumikhan logote kun sathi ase, aru tai logote rati te jai kene koi, “Sathi, moike tinta roti dhaar dibi, ");
INSERT INTO nag_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kele koile moi laga ekjon sathi dusra jaga pora berai kene etiya ahise, moi taike dibole eku nai’? ");
INSERT INTO nag_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Titia tai bhitor pora amike eneka kobo pare, ‘Moike etiya digdar nokoribi. Dorja to bondh hoise, aru moi aru bacha khan etiya ghumai ase. Moi etiya uthi kene tumike eku dibo na paribo.’ ");
INSERT INTO nag_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Moi tumike koi ase, jodi bhi tai uthi kene tai laga sathi ke dibole mon nai, hoilebi tai mangi thaka karone, tai ji hoilebi uthi kene taike jiman lage etu di dibo. ");
INSERT INTO nag_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Moi aru bhi tumike koi ase, mangibi, aru tumi pabo; bisaribi, aru tumi pai jabo, dorjate khat-khata bhi, etu khuli jabo. ");
INSERT INTO nag_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jun manu mange tai pai; jun manu bisare tai pai; aru jun manu khatai, taike khuli diye. ");
INSERT INTO nag_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tumikhan majote kun baba eneka ase naki, jodi tai laga bacha pora maas mangile, taike saph dibo? ");
INSERT INTO nag_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aru jodi anda mangile, taike bhichoo dibo naki? ");
INSERT INTO nag_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Etu karone, tumikhan biya manu hoilebi nijor bacha ke bhal saman he dibole jane, tenehoile sorgote thaka Baba Isor ke kun manu pora mange, taike Pobitro Atma nadibo naki?” ");
INSERT INTO nag_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ek din, Jisu ekta gunga kori diya bhoot ke khedai thakise. Aru jitia bhoot to ulai jaise, etu manu kotha kobo parise, aru ta te thaka manu khan asurit hoise. ");
INSERT INTO nag_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kintu kunba manu khan koise, “Tai bhoot ke Beelzebul laga naam pora khedai ase jun he bhoot khan laga raja ase.” ");
INSERT INTO nag_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aru dusra manu khan, Jisu ke porikha kori kene koise, sorgo pora ekta asurit kaam dikha bole koise. ");
INSERT INTO nag_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kintu, taikhan laga bhabona jani kene Jisu pora koise, “Juntu rajyo alag-alag bhabona hoi kene ase, etu bhangi jabo, aru ekta ghor alag-alag bhabona hoile, etu ghor bhangi jabo. ");
INSERT INTO nag_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aru jodi Saitan bhi alag-alag hoijai, eneka hoile tai laga rajyo kineka khara hobo? Tumikhan koi ase Moi Beelzebul laga takot pora bhoot khan ke khedai. ");
INSERT INTO nag_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jodi Moi bhoot khan ke Beelzebul takot pora khedai ase koile, titia hoile tumikhan laga chela khan kun laga atma pora bhoot khan ke khedai? Etu karone, eitu khan he tumikhan ke bisar koribo. ");
INSERT INTO nag_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jodi Moi bhoot khan ke Isor laga anguli pora khedai, titia hoile Isor laga rajyo to tumikhan usorte ahise. ");
INSERT INTO nag_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jitia ekta takot thaka manu pora hathiar loi kene ghor to rukhi thake, tai laga ki ase etu naharai. ");
INSERT INTO nag_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kintu tai pora bhi bisi takot thaka manu taike hamla korile, taike harai dibo, tai laga hathiar bhi loi lobo, jun uporte tai bharosa kore, aru ji dhun sompoti tai laga ase, sob bhag hoi jabo. ");
INSERT INTO nag_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kun manu Moi logote nathake, Moi laga bhirodh te ase, aru kun manu Moi logote nathake, tai alag hoijai. ");
INSERT INTO nag_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jitia ekta dusto atma ekjon manu pora ulai jai, tai sukha jagate aram pabole karone berai thake, aru koi, ‘Moi poila kot pora ulaise ta te aru bhi wapas jai jabo.’ ");
INSERT INTO nag_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aru jitia tai ahe, tai sob sapha aru bhal kore kene rakhi thaka dikhe. ");
INSERT INTO nag_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tai jai kene tai pora bhi aru bisi biya sat-ta dusto atma loi kene etu manu bhitor te ghusi jai. Aru poila pora bhi etu manu laga jibon to bisi biya hoijai.” ");
INSERT INTO nag_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Etiya eneka hoise, jitia Tai etu kotha koi thakise, ekjon mahila awaj uthaikene manu khan usorte Jisu ke koise, “Dhonyo ase etu ama jun Apuni ke jonom dise aru dudh khilai se.” ");
INSERT INTO nag_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kintu Tai koise, “Hoilebi, asishit hobo jun manu Isor kotha huni kene mani thake.” ");
INSERT INTO nag_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Manu laga bhir jitia bisi hoise, Tai kobole shuru hoise, “Etu manu khan paap laga khandan ase. Taikhan kiba ekta sabole bisari thake, kintu, asurit kaam to taikhan ke nadikhabo, khali Jonah laga chihna he nohoile. ");
INSERT INTO nag_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jineka Jonah to Nineveh sheher laga manu khan nimite ekta chihna hoise, etu nisena Manu laga Putro bhi manu khan nimite eneka hobo. ");
INSERT INTO nag_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dakshin laga Rani bisar dinte uthi kene etiya laga manu khan ke bisar koribo, kele tai duniya laga kona pora Solomon raja laga gyaan kotha huni bole ahisele aru sabi Solomon pora bhi mohan ekjon yate ase. ");
INSERT INTO nag_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nineveh sheher laga manu khan uthaikene etiya laga manu khan ke bisar koribo, kelemane taikhan mon ghuraise Jonah prochar kora homoi te aru sabi, Jonah pora bhi mohan ekjon yate ase. ");
INSERT INTO nag_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kun bhi saaki to jolai kene lukai narakhe kintu saaki rakha jagate rakhe, aru kun manu ghor bhitor te ahe, puhor to dikhi pai. ");
INSERT INTO nag_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tumi suku to gaw laga diya ase. Jitia tumi laga suku bhal thake, tumi laga pura gaw to pohor pora bhorta hoi. Kintu jitia biya hoi jaise, tumi laga gaw bhi pura andhar hoijai. ");
INSERT INTO nag_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Etu karone, bisi hoshiar hoi jabi etu pora tumi laga jibon to andhar nohobo nimite. ");
INSERT INTO nag_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jodi tumi laga gaw to ujala pora bhorta hoijai, aru kun jagate bhi andhar nai, titia etu puhor pora bhorta hoi jabo, jineka tumi uporte puhor to bhorta hoi thakibo.” ");
INSERT INTO nag_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jitia Tai kotha kora khotom hoise ekjon Pharisee pora Taike khana khabole matise. Aru Jisu tai logote khabole bohise. ");
INSERT INTO nag_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aru Pharisee khan etu dikhi kene asurit hoise, kelemane Jisu to bhaat kha age te, Tai laga hath Yehudi niyom hisab de thaka nisina dhula nai. ");
INSERT INTO nag_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kintu Probhu taike koise, “Tumi Pharisee khan kup aru borton laga bahar to sapha kore, kintu tumikhan mon bhitor te biya aru lalchi pora bhorta thake. ");
INSERT INTO nag_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Murkho manu khan! Jun he tumi laga bahar to bonaise, tai he tumi laga bhitor bhi bonaise nohoi? ");
INSERT INTO nag_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kintu tumi bhitor laga morom to dikhai dibi, aru sabi, tumi laga jibon te sob to sapha hoi jabo. ");
INSERT INTO nag_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kintu Pharisee khan, tumikhan ke hai ase. Tumikhan kheti laga sobji aru bagan te thaka pata khan loi kene dos bhag diye, kintu Isor laga morom to namane. Kintu etu kori bole dorkar ase, aru dusra bhal kaam bhi nacharibo lage. ");
INSERT INTO nag_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pharisee khan, tumikhan ke hai ase. Tumikhan mondoli te sobse bhal jagate bohi bole mon kore aru bajar te manu bhoi pora salam diya to khushi pai. ");
INSERT INTO nag_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tumikhan ke hai ase, tumikhan nadikha laga kobor nisena ase, etu uporte manu khan najanikena berai thake.” ");
INSERT INTO nag_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Titia ekjon niyom jana manu Jisu ke koise, “Probhu, etu koi kene, Apuni amikhan ke sorom khilai ase.” ");
INSERT INTO nag_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Titia Jisu jowab dise, “Hai tumikhan, niyom laga hikhok khan! Tumikhan manu khan ke bhari bhar bukhi bole diye juntu taikhan bukhi bole napare, kintu tumikhan laga anguli pora nijor bhi etu bhar to bukhi bole mon nai. ");
INSERT INTO nag_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tumikhan ke hai ase, bhabobadi khan laga kobor to bonaise, hoilebi tumikhan baba laga baba khan pora he taikhan ke moraise. ");
INSERT INTO nag_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hosa koile, tumikhan baba laga baba khan pora ki korise etu laga tumikhan sakhi ase, taikhan pora morai dise aru tumikhan kobor khan bonaise. ");
INSERT INTO nag_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Etu karone Isor laga gyaan pora sob koi dise, ‘Moi taikhan logot bhabobadi khan aru apostle khan ke pathabo, aru taikhan pora Moi patha khan ke dukh dibo aru kunba ke morai dibo.’ ");
INSERT INTO nag_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Etu karone, duniya shuru pora jiman bhabobadi khan laga khun giraise, sob laga bisar etiya laga jamana khan logote koribo. ");
INSERT INTO nag_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel laga khun pora shuru kori kene Zechariah laga khun tak, junke pobitro jagate moraise. Hoi, Moi tumikhan ke koi ase, etu sob hisab to etiya laga jamana pora dibo lagibo. ");
INSERT INTO nag_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kanun hikhok khan ke hai ase. Tumikhan Isor ke janibole gyaan laga chabi to loi kene rakhise; tumikhan nijor bhi etu bhitor te najai aru kun manu jabole mon kore, tumikhan pora taikhan ke bhi jabo nadiye.” ");
INSERT INTO nag_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jitia Jisu ta te pora ulai jaise, niyom likha khan aru Pharisee khan etu sob kotha to huni kene khong uthise aru Tai logote jhagara korise, ");
INSERT INTO nag_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","taikhan rukhi thakise, Jisu kiba ekta golti kotha koile, Taike phasabo koi kene. ");
INSERT INTO nag_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Eneka homoi te, hajar-hajar manu eke logote joma hoise, eneka somoite hazar manu joma huwa karone manu khan ekjon-ekjon uporte girise, Tai chela khan ke poila koise, “Pharisee khan laga chalaki pora hoshiar hobi, kelemane taikhan chalak ase. ");
INSERT INTO nag_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Eku kotha lukai rakhibole na paribo, kintu bhitor te thaka kotha to sob ulai jabo. ");
INSERT INTO nag_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Etu karone ki kotha andhar te koise, ujala te sob hunibo aru tumi ghor bhitor te ki kotha khan ki koise etu kotha ghor uporte awaj uthaikene kobo. ");
INSERT INTO nag_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Moi tumikhan ke koi ase moi laga sathi khan, bhoi nakori bhi jun manu tumi laga gaw to morai dibo, aru etu pichete taikhan eku koribo na paribo. ");
INSERT INTO nag_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kintu Moi tumikhan ke koi dibo Isor ke tumikhan bhoi kori bole lage. Morai diya pichete, norokte phela bole jun laga takot ase, taike bhoi koribi. Hosa Moi tumikhan ke koi ase, Isor ke he bhoi koribi. ");
INSERT INTO nag_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Aru pansta ghor laga chiriya khan ke dui poisa pora bikiri nakore naki? Hoilebi eitu khan ke bhi Isor napahore. ");
INSERT INTO nag_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tumikhan matha laga chuli bhi ekta-ekta pora ginti kori kene ase. Bhoi nokoribi. Tumikhan to ghor te thaka chiriya pora bhi bisi daam laga ase. ");
INSERT INTO nag_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Moi aru bhi tumikhan ke kobo, jun manu Moike manu khan usorte paap shikar kore, Manu laga Putro bhi sorgodoth usorte taikhan ke shikar koribo, ");
INSERT INTO nag_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kintu jun pora manu khan usorte Moike namatibo, Moi bhi sorgodoth usorte taike namatibo. ");
INSERT INTO nag_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jun manu Moi laga bodnam koribo tai maph pabo, kintu kun manu Pobitro Atma ke bodnam koribo tai kitia bhi maph napabo. ");
INSERT INTO nag_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Etu karone jitia taikhan tumikhan ke mondoli khan te, aru cholawta khan aru adhikari khan usorte loijabo, titia tumikhan laga safai te ki kobo lage etu karone chinta nokoribi, ");
INSERT INTO nag_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tumikhan ki kobo lage Pobitro Atma pora etu homoi te sob sikhai dibo.” ");
INSERT INTO nag_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Titia kunba ekjon manu majot pora Jisu ke koise, “Probhu, moi laga bhai ke kobi tai laga dhun sompoti bhag kori kene moike dibole.” ");
INSERT INTO nag_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kintu Jisu taike koise, “Manu, tumikhan uporte bhag aru bisar kori bole Moi kun koise?” ");
INSERT INTO nag_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tai manu khan ke koise, “Lalchi aru biya itcha pora nijorke bachai kene rakhibi, sob thakile bhi manu laga jibon dhun sompoti bisi thaka para nohoi.” ");
INSERT INTO nag_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jisu taikhan ke ekta dristanto koise, “Ekjon dhuni manu laga mati ke bhal kheti ulaise, ");
INSERT INTO nag_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","etu manu monte bhabikena korise, moi ki koribo, kheti bisi bhal hoise aru rakhibole jaga nai?’ ");
INSERT INTO nag_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kintu tai koise, ‘Moi eneka koribo: dhaan ghor to bhangai kene dangor ghor bonabo aru ta te moi laga dhaan aru sob bhal saman rakhibo. ");
INSERT INTO nag_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aru moi laga mon ke kobo, “Oh mon, bisi saal nimite kha luwa joma kori kene rakhise. Kha luwa kori kene, khushi koribi.’” ");
INSERT INTO nag_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kintu Isor he taike koise, ‘Murkho manu, aji rati tumi laga atma uthai lobo, aru ki dhun sompoti tumi joma kori kene rakhise, etu kun laga hobo?’ ");
INSERT INTO nag_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Eneka he hobo utu manu logote jun nijor nimite dhun sompoti joma kore, kintu Isor phale dhuni nohoi.” ");
INSERT INTO nag_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Titia Jisu tai laga chela khan ke koise, “Etu nimite Moi tumikhan ke koi ase, nijor laga jibon nimite chinta nokoribi, ki khabo aru ki pindhibo, nijor gaw nimite chinta nokoribi. ");
INSERT INTO nag_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kelemane jibon to kha luwa pora bhi dangor ase, aru tumi laga kapra pora bhi dangor to tumi laga gaw ase. ");
INSERT INTO nag_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sabi akas te uri thaka chiriya khan ke, taikhan kheti bhi nakate. Aru taikhan laga dhaan rakhibole jaga bhi nai, kintu Isor he taikhan ke khabole diye. Tinehoile tumikhan chiriya pora bhi daam laga ase. ");
INSERT INTO nag_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kintu tumikhan majot te kun he chinta kori kene jibon to lamba kori bole paribo? ");
INSERT INTO nag_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aru jodi tumikhan etu chutu kaam bhi kori bole napare koile, tenehoile dusra kaam nimite kele chinta kori ase? ");
INSERT INTO nag_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sabi kheti te lili phul to kineka dangor hoi. Taikhan kheti bhi nakore aru joma bhi nakore. Hoilebi Moi tumike koi ase, Solomon ekta dangor raja hoilebi lili phul nisena sundur hobo para nai. ");
INSERT INTO nag_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kintu kheti laga ghas khan juntu aji ase aru kali to chulah te phelai dibo, hoilebi sabi, Isor pora eitu khan sundur pora bonaise, O biswas natakha manu khan, eitu khan pora bhi tumikhan ke sundur nabonabo naki! ");
INSERT INTO nag_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aru tumikhan ki kha luwa koribo etu nimite chinta nokoribi. ");
INSERT INTO nag_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Etu prithibi manu kunkhan Isor najane, taikhan he eitu khan pichete berai thake, kintu etu tumi nimite dorkar ase koi kene Baba Isor he sob jane. ");
INSERT INTO nag_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Poila Isor laga rajyo bisaribi, titia sob tumikhan ke hali dibo. ");
INSERT INTO nag_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Komti manu khan, bhoi nokoribi, kelemane Baba pora tumikhan ke rajyo dibole khushi ase. ");
INSERT INTO nag_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tumikhan logote ki ase sob bikiri kori kene gorib khan ke de dibi. Jun jagate chor nahibo aru puka pora nakhabo, sorgote tumi laga dhun sompoti joma kora to kitia bhi naharabo. ");
INSERT INTO nag_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kilekoile jun jagate tumi laga dhun sompoti thake, etu jagate mon to hodai thake. ");
INSERT INTO nag_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tumi laga komor to bandhi lobi, aru saaki to jolai rakhibi, ");
INSERT INTO nag_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","aru eneka manu khan nisena hobi jun khan malik ke shadi pora wapas ahibole rukhi thake, aru jitia tai ahi kene dorwaja te mare, taikhan phot kori dorwaja to khuli bole pare. ");
INSERT INTO nag_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Asirbad ase etu noukar khan jun malik aha homoi te rukhi kene thake. Hosa pora moi tumikhan ke koi ase, Tai laga pet te kapra bandi kene taikhan ke khabole jagate bohai dibo, aru Tai ahikena nijor pora taikhan ke kha luwa khabole dibo. ");
INSERT INTO nag_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aru malik adha rati te, nohoile bisi phojurte ahile bhi, tai noukar khan pora rukhi thaka dikhile, etu noukar to asirbad ase. ");
INSERT INTO nag_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kintu etu jani lobi, jodi malik to tai laga ghor te chor kitia ahibo etu jani loi, titia tai kitia bhi ghor te chor hobole nadibo. ");
INSERT INTO nag_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tumikhan bhi taiyar kori thakibi, kelemane Manu laga Putro ki homoi te ahibo tumi kobo napare.” ");
INSERT INTO nag_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Titia Peter koise, “Probhu, Apuni etu dristanto moi khan ke koi ase na, sobke bhi koi ase?” ");
INSERT INTO nag_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Probhu koise, “Tinehoile kun taikhan majote gyaani imandar noukar ase junke malik pora basi lobo tai laga dusra nokorkhan ke sabole, taikhan laga kha luwa thik homoi te dibole? ");
INSERT INTO nag_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Asirbad ase etu noukar jitia tai laga malik ahikena taike kaam kora dikhe. ");
INSERT INTO nag_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Moi hosa koi ase tai etu noukar ke tai laga sob dhun sompoti to sabole di dibo. ");
INSERT INTO nag_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kintu jodi noukar tai laga monte bhabe, ‘Moi laga malik to ahibole bisi homoi loi ase,’ aru noukar khan ke mari bole shuru hoi, aru kha luwa kori kene, aru nisa te giri thake, ");
INSERT INTO nag_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","aru titia tai laga malik achanak pora ahijai, jun to homoi te tai bhabona kori thaka nai, titia malik pora taike kati phelai dibo aru tai laga bodli dusra bhal ke kaam to di dibo. ");
INSERT INTO nag_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Aru jun noukar tai malik laga itcha to jane, kintu malik laga itcha nisena eku kori kene nathake, titia hoile taike marikena bisi dukh dibo. ");
INSERT INTO nag_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kintu jun manu eku najane, hoilebi mar kha laga kaam to kori thakise taikhan olop he mari khabo. Kintu jun manu ke bisi dikena ase, taikhan logote pora bisi pabo lage, aru jun manu ke kaam bisi dikena ase, tai logote pora etu sob kaam laga hisab mangibo. ");
INSERT INTO nag_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Moi etu duniya te jui phela bole ahise, aru Moi etu he itcha ase etu shuru hoijai kene thakibo nimite. ");
INSERT INTO nag_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Moi baptizma pora baptizma kori bole ase, aru Moi chinta te ase jitia tak etu pura nohoi! ");
INSERT INTO nag_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tumikhan bhabise naki Moi etu prithibi te shanti dibole ahise? Nohoi, Moi hosa koi ase, kintu sob bhag hoi jabo. ");
INSERT INTO nag_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Etiya pora ghor te pans jon bhi bhag hoi jabo- tinjon bhitor te te duijon aru duijon bhitor te tinjon dushman hoi jabo. ");
INSERT INTO nag_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taikhan alag hoi jabo, baba pora bacha khan ke chari bo, aru bacha khan bhi baba ke chari bo; ama pora chukri ke chari bo aru chukri bhi ama laga dushman hobo, saas pora buari ke chari bo aru, buari bhi saas ke chari bo.” ");
INSERT INTO nag_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Etiya Jisu manu khan ke koise, “Tumikhan jitia paschim phale badal utha dikhe, ‘Borkhon ahise, aru etu ahijai. ");
INSERT INTO nag_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aru jitia dakshin laga hawa mare, tumikhan koi, ‘Bisi gorom ahibo, aru etu hoijai. ");
INSERT INTO nag_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","O Dhungi khan! Akas prithibi te ki dikhe etu kobole jane, kintu kele tumikhan aha dinte ki hobole ase etu kobo napare? ");
INSERT INTO nag_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aru tumikhan nijor bhi hosa to ki ase etu bisar nakore? ");
INSERT INTO nag_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tumi dushman logote bisar kori bole ja homoi te, rasta te he etu jhagara to faisla kori bole itcha koribi, nohoile tumike tanikena bisar ghor te loijabo, tumike daruga hathte di dibo, aru daruga pora tumike bondhi ghor te hali dibo. ");
INSERT INTO nag_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Moi tumike koi ase, tumi poisa laga sob hisab kitab pura nakora tak tumi etu koidi ghor pora ulabole na paribo.” ");
INSERT INTO nag_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Titia kunba manu khan etu homoi te Jisu ke eneka khobor dise ki Pilate pora bolidan kora homoi te tai Galilee manu khan ke morai dikena taikhan laga khun bhi milai dise. ");
INSERT INTO nag_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisu taikhan ke koise, “Tumikhan bhabise naki etu Galilee manu khan dusra Galilee manu khan pora bhi bisi paapi khan ase kelemane taikhan eneka dukh paise? ");
INSERT INTO nag_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nohoi, Moi tumikhan ke hosa kobo. Jodi tumikhan mon naghurai, tumikhan bhi eneka he khotom hoi jabo. ");
INSERT INTO nag_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aru atharo jon manu kunkhan uporte Siloam laga minar giri kene mari dise, tumikhan bhabise naki Jerusalem te thaka manu khan pora bhi taikhan he bisi paapi thakise? ");
INSERT INTO nag_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nohoi, Moi tumikhan ke koi ase. Jodi tumikhan mon naghuraile, taikhan nisena khotom hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Titia Jisu ekta dristanto koise, “Ekjon manu tai laga bagan te dimoru ghas rupaisile, aru tai etu ghas te phol bisarikena jaise, kintu eku pa-a nai. ");
INSERT INTO nag_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Titia tai bagan sa-a manu ke koise, ‘Sabi, tin saal moi etu ghas te phol bisari kene ahise, kintu eku pa-a nai. Etu ke kati dibi. Etu mati to kele nuksan koribo?’ ");
INSERT INTO nag_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Titia noukar pora malik ke eneka jowab dise, ‘Probhu, etu saal nimite chari dibi, moi aru ekbar bhal pora etu ghas to mol dikene sabo. ");
INSERT INTO nag_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jodi etu ghas pora etu somoi nisena te phol diye, to bhal ase, kintu jodi etu pora bhal phol diya nai koile, apuni etu ghas to kati dibi!’” ");
INSERT INTO nag_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aru ek Bisram dinte Jisu mondoli khan te hikai thakise, ");
INSERT INTO nag_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aru ta te ekjon mahila atharo saal pora komjur laga atma thakise, tai laga komor to tera thakise aru ekdom sidha koribo napari kene thakise. ");
INSERT INTO nag_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aru jitia Jisu taike dikhise, Tai usorte mati kene koise, “Mahila, tumi laga komjur pora tumi mukti paise.” ");
INSERT INTO nag_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Titia Jisu tai laga hath etu mahila uporte rakhise, aru etu homoi te tai sida hoi jaise aru tai Isor ke dhanyavad dise. ");
INSERT INTO nag_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kintu mondoli te thaka cholawta khan bhal pa-a nai aru Jisu pora Bisram dinte changai kaam kora nimite manu khan ke koise, “Choi din tak kaam kori bole dorkar ase. Etu homoi te he bhal hobole ahibi, kintu Bisram dinte nahibi.” ");
INSERT INTO nag_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kintu Probhu taikhan ke koise, “Dhongi khan! Tumikhan Bisram dinte tumikhan laga guru, saguli khan ke tai laga ghor pora ulaikene pani khabole loi najai naki? ");
INSERT INTO nag_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Etu mahila, Abraham laga khandan pora ahise, junke Saitan para atharo saal tak bandhi kene rakhise, tenehoile taike Bisram dinte khuli nadibo lage naki?” ");
INSERT INTO nag_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jitia Tai etu kotha kori kene khotom hoise, jun Jisu ke ghusa kori thakise taikhan sorom lagi jaise, kintu sob manu khan khushi kori kene dhanyavad di thakise juntu kaam Tai kori kene dikhai diya karone. ");
INSERT INTO nag_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Titia Jisu koise, “Isor laga rajyo to kineka ase, aru Moi etu ke ki logote tulona koribo? ");
INSERT INTO nag_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Etu ekta sorso dana nisena ase jineka ekjon manu pora loi kene tai laga kheti te phelaise, aru etu dangor ghas hoi jaise, aru ta te chiriya khan bhi ahikena ghor bonaise.” ");
INSERT INTO nag_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aru Tai koise, “Isor laga rajyo to ki logote tulona koribo? ");
INSERT INTO nag_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ekjon mahila pora tin kilo atta te khomir hali dise, jitia tak etu phuli najai.” ");
INSERT INTO nag_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aru Jisu nogor aru bosti khan te jai kene hikai thakise aru Jerusalem te jabo nimite taiyar kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Etiya ekjon pora Taike hudise, “Probhu, jun poritran pai ase taikhan olop jon he ase naki?” Titia Tai taikhan ke koise, ");
INSERT INTO nag_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Etu chutu rasta te jabole nimite dukh koribi, kelemane Moi tumikhan ke koi ase, bisi manu etu te ghusi bole kosis koribo, kintu ghusi bole na paribo. ");
INSERT INTO nag_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jitia ghor laga malik pora dorwaja to bondh kori dibo, titia tumi dorja to marikena kobo, ‘Probhu, moi khan nimite khuli bhi.’ Kintu tai tumikhan ke kobo, ‘Moi tumikhan ke najane, aru tumikhan kot pora ase.’ ");
INSERT INTO nag_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Titia tumi he kobo, ‘Amikhan Apuni logote bohi kene eke logote khai sele, aru Apuni amikhan laga jagate ahikena sikhai dise.’ ");
INSERT INTO nag_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Titia Tai kobo, ‘Moi tumikhan ke koi ase, Moi tumikhan kot pora ahise najane. Moi usor pora dur hoi jabi sob biya kaam kora khan!’ ");
INSERT INTO nag_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Etu jagate, kanda he thakibo, aru dath chababo aru jitia Abraham, Isaac aru Jacob aru sob bhabobadi khan ke Isor laga rajyo to dikhibo, kintu etu pora tumikhan ke bahar te phelai dibo. ");
INSERT INTO nag_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Taikhan purab, paschim, uttor aru dakshin pora ahikena Isor laga rajyote bohibo. ");
INSERT INTO nag_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aru sabi, kun manu pichete thakise taikhan age te ase, aru kunba jun age te ase, taikhan pichete hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Etu homoi te, kunba Pharisee khan Tai usorte ahikena koise, “Amikhan ke chari bhi aru yate pora jai jabi, kelemane Herod tumike morai dibole bisari ase.” ");
INSERT INTO nag_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisu taikhan ke koise, “Jai kene utu siyal Herod ke kobi, ‘Sabi, Moi bhoot khan ke khedai dise aru bemar khan ke aji aru kali bhal korise, aru tin din pichete Moi laga lakshya punchi jabo.’ ");
INSERT INTO nag_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jineka hoile bhi Moi kaam kori thakibo, aji, kali aru aha dinte bhi, kele koile Jerusalem te bhabobadi khan harai ja-a to bhal nai. ");
INSERT INTO nag_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Oh Jerusalem, Jerusalem, kun he bhabobadi khan ke morai diye aru tumikhan usorte ahile pathor pora mari kene pathai diye. Moi kiman itcha korise tumikhan laga bacha khan ke eke logote rakhibole nimite jineka ekta murgi tai laga bacha khan ke pakhi nichete rakhe. Kintu tumikhan etu itcha nakore. ");
INSERT INTO nag_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sabi, tumikhan laga ghor to khali hoi jaise. Kile Moi kobo, tumikhan Moike aru nadikhibo etu homoi naha tak, jitia tumikhan kobo, ‘Asirbad pabo jun Probhu laga naam te ahise.’” ");
INSERT INTO nag_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aru eneka hoise, Jisu ekjon Pharisee khan laga ghor te Bisram dinte bhaat khabole jaise, aru Jisu ki kori ase etu sob bhal pora taikhan sai thakise. ");
INSERT INTO nag_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aru ta te ekjon manu thakise jun gaw phula bemar pora dukh pai thakise. ");
INSERT INTO nag_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Titia Jisu Pharisee khan aru Yehudi niyom jana manu khan ke hudi kene koise, “Bisram dinte changai kori bole pare na nai?” ");
INSERT INTO nag_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kintu taikhan eku kowa nai, titia Jisu taike dhorise aru changai kori dise, aru taike pathai dise. ");
INSERT INTO nag_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Titia Tai pora taikhan ke hudise, “Tumikhan majote kunba tai laga bacha nahoile bhi tai laga janwar Bisram dinte panite giri le jai kene phot uthai nolobo naki?” ");
INSERT INTO nag_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Taikhan etu kotha te eku jowab dibo para nai. ");
INSERT INTO nag_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Titia Tai arubi taikhan ke ekta dristanto koise, jun khan ke khabole mati sele, taikhan kineka kori kene bhal jagate bohi bole pabo, etu kosis kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Jitia tumikhan ke shadi te khabole mate, tumikhan bhal jagate nabohibi, kele koile tumikhan pora bhi kunba bisi sonman thaka manu ke mati kene thakibo pare, ");
INSERT INTO nag_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","aru jitia tumi aru dusra manu junke khana te matise, tai tumikhan ke kobo, ‘Tumi laga jaga to taike dibi,’ aru titia sorom pora taike etu jaga to dikene tumi chutu jagate he bohi jai. ");
INSERT INTO nag_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jitia, tumike mate, jabi aru sobse chutu jagate he bohibi, jitia jun pora tumike matise tai ahibo, tai tumike kobo, ‘Sathi, uporte ahibi.’ Titia tumi laga sonman to dusra manu bohi thaka usorte bisi hoijai. ");
INSERT INTO nag_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jun manu nijorke dangor kori bole bisare tai chutu hoi jabo, aru jun manu tai nijorke chutu kore taike uthai dibo.” ");
INSERT INTO nag_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Titia tai etu manu ke kobo jun he taike matise, “Jitia tumi kha luwa koribo, tumi laga bhal sathi khan, bhai khan aru dhuni manu ke namatibi, nohoile taikhan bhi tumike matibo, aru tumi taikhan nimite ki korise etu he apuni pabo. ");
INSERT INTO nag_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kintu jitia tumi kha luwa kore, gorib khan, bera bole napara, andha aru bemar manu khan ke mati bhi, ");
INSERT INTO nag_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","aru tumikhan asirbad pabo, kelemane taikhan tumike ghurai kene eku dibole na paribo. Kintu tumikhan ke Jisu Khrista wapas lobole aha homoi te biswasi khan logote sob kaam laga inam dibo.” ");
INSERT INTO nag_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jitia jun ekjon mez te bohi thakise aru eitu khan huni thakise, tai Jisu ke koise, “Dhonyo ase jun Isor laga rajyote roti khabo!” ");
INSERT INTO nag_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Titia Jisu pora taikhan ke ekta dristanto koise, “Ekjon manu dangor kha luwa bonai kene manu khan ke matise. ");
INSERT INTO nag_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aru jitia khabole homoi ahise, tai laga noukar khan ke pathai kene jun manu khan ke matise taikhan ke koise, ‘Ahibi, sob to taiyar hoi jaise.’ ");
INSERT INTO nag_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kintu mata khan sob nijor bahana kori bole shuru hoise. Poila ekjon pora koise, ‘Moi ekta kheti kinise, aru moi ta te jai kene sabo lagibo. Morom pora biya napabi.’ ");
INSERT INTO nag_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aru ekjon pora koise, moi pansta guru kinise, moi taikhan ke kheti te loijai kene ekbar sabo. Morom pora biya napabi.’ ");
INSERT INTO nag_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aru dusra ekjon pora koise, ‘Moi ekjon maiki logote shadi korise, aru etu nimite moi ahibole na paribo.’ ");
INSERT INTO nag_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Titia noukar khan sob kotha to tai laga malik ke ahikena koise. Ghor laga malik khong uthi kene, noukar khan ke koise, ‘Bahar te joldi jabi aru bosti rasta pora gorib manu, bera bole napara, suku andha aru bemar manu ke loi anibi.’ ");
INSERT INTO nag_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sewak pora etu kaam kori kene tai koise, ‘Probhu Apuni ki koise eneka kori dise, aru bhi alohi manu bisi karone jaga ase.’ ");
INSERT INTO nag_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Titia malik tai laga noukar khan ke koise, ‘Bahar te jabi aru rasta kinar aru jun jaga pora hoile taikhan ke mati kene loi anibi, Moi laga ghor to bhorta hobo lage. ");
INSERT INTO nag_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Moi tumikhan ke koi ase, jun manu khan ke Moi poila mati sele taikhan Moi ki kha luwa bonaise etu khabole napabo.’” ");
INSERT INTO nag_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Aru bisi manu khan Jisu laga pichete jai thakise, aru Tai ghuri kene taikhan ke koise, ");
INSERT INTO nag_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Jun manu Moi logote ahibole itcha ase kintu tai nijor laga baba, ama, maiki, bacha, bhai, bhoini aru nijor jibon to ghin nakore, tai Moi laga chela hobole na paribo. ");
INSERT INTO nag_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jun manu tai nijor laga Cross uthaikene Moi pichete nahe tai Moi laga chela hobole na paribo. ");
INSERT INTO nag_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jun manu ekta ghor bona bole itcha kore, poila tai bohi kene, tai logote thaka poisa pora ghor bona khotom koribo paribona nai koi kene ginti nakore naki? ");
INSERT INTO nag_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jitia, tai ghor laga bhetimul to uthai dibo, aru ghor to khotom kori bole naparile, sob manu saikene taike hasi dibo, ");
INSERT INTO nag_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","aru kobo, etu manu ghor to bona bole shuru korise kintu khotom kori bole para nai.’ ");
INSERT INTO nag_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aru ekjon raja, dusra raja logote lorai kori bole ase, tai poila bohi kene nasabo naki, tai laga dos hajar manu pora dusra raja laga bis hajar logote lorai koribo paribona nai? ");
INSERT INTO nag_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kintu, tai dur te thaka homoi te, ekjon manu ke shanti pora kotha kori kene lorai to rukhai dibo. ");
INSERT INTO nag_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Etu nisena, jun manu tai laga sob dhun sompoti chari kene nahile, tai Moi laga chela hobole na paribo. ");
INSERT INTO nag_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Etu nimite nimok to bhal ase, kintu nimok laga swadh harai dile kineka etu ke aru swadisht bonabo? ");
INSERT INTO nag_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Etu ke mati nimite bhi aru kheti te mol bona bole bhi kaam nathake. Taikhan etu ke phelai dibo. Jun manu logote huni bole kan ase, taikhan huni bhi.” ");
INSERT INTO nag_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aru ek din poisa utha manu khan aru dusra paapi manu khan Jisu laga kotha huni bole nimite ahise. ");
INSERT INTO nag_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kintu Pharisee khan aru niyom likha khan ekjon-ekjon logote koi thakise, “Etu manu paapi khan ke mate, aru taikhan logote bohi kene khai.” ");
INSERT INTO nag_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Titia Jisu he etu dristanto taikhan ke koise, ");
INSERT INTO nag_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yate kun ase, jun logote eksoh mer ase kintu tai ekta haraise koile, tai ninyanve ke jongol te chari kene jun to haraise etu ke bisari bole najabo? ");
INSERT INTO nag_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aru jitia tai etu mer to pai jai, tai laga pithite uthaikene khushi pora loi ane. ");
INSERT INTO nag_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jitia tai ghor te ahijai, tai sobke mate, tai laga sathi aru usorte thaka manu khan ke koi, ‘Moi logot khushi koribi, moi laga harai ja-a mer paise.’ ");
INSERT INTO nag_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Moi tumikhan ke koi ase, sorgote bhi eneka khushi koribo jitia ekjon paapi manu mon ghurai kene ahibo, etu ninyanve thaka pora bhi bisi khushi hobo, kele koile taikhan to mon ghura bole eku nai. ");
INSERT INTO nag_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Aru kun mahila, jun logote dosta chandi poisa thakise, jodi ekta harai diye, titia tai saaki jolai kene ghor jharu marikena sob sapha kori bisaribo nohoi jitia tak etu poisa napai? ");
INSERT INTO nag_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aru jitia tai pai loi, tai laga sathi aru ghor usorte thaka manu khan ke matikena, koi ‘Moi logote khushi koribi, kelemane moi laga harai juwa poisa to moi paise.’ ");
INSERT INTO nag_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Etu nisena he, Moi tumikhan ke koi ase, aru Isor laga sorgodoth majote bhi khushi hoi jitia ekjon paapi manu mon ghurai kene ahe.” ");
INSERT INTO nag_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Titia Jisu he koise, “Ekjon manu laga duita chokra thakise, ");
INSERT INTO nag_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","aru chutu chokra pora baba ke koise, ‘Baba, moi laga dhun sompoti te ki bhag ase etu moike dibi.’ Titia tai laga baba pora dui bhag kori kene duijon ke di dise. ");
INSERT INTO nag_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Aru bisi din nohoi kene, chutu chokra tai laga ki ase etu sob joma kori kene dur jagate jai jaise, aru ta te tai laga sob dhun sompoti cholai kene khotom kori dise. ");
INSERT INTO nag_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jitia tai logote ki thakise etu sob khotom hoi jaise, titia etu pura desh te dangor akaal ahi jaise, aru tai bisi dukh paise. ");
INSERT INTO nag_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Titia tai kaam bisari kene ekta manu laga ghor te jaise, aru etu manu pora taike kheti te gahori ke dana khila bo nimite pathai dise. ");
INSERT INTO nag_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tai bisi bhuk laga pora gahori dana hoilebi khabo bhabi kene jaise, kintu tai khabole eku pa-a nai. ");
INSERT INTO nag_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jitia tai nijor laga halat dikhise, tai nijorke kotha korise, ‘Moi laga baba ghor te kiman jon hajira kora manu khan ase taikhan bhi pet bhorta kha-luwa khabo pai, kintu moi yate bhuk pora mori bole ase! ");
INSERT INTO nag_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Moi tayar kene moi laga baba ghor te jabo, aru taike kobo, “Baba, moi sorgo aru apuni age te paap korise. ");
INSERT INTO nag_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Moi apuni laga chokra kobole layak nai; moike bhi apuni laga ekjon hajira manu nisena he bonai kene rakhibi.’” ");
INSERT INTO nag_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Titia tai uthi kene baba laga ghor te jaise. Jitia tai dur te he thakise, tai laga baba pora dikhise aru morom pora bhorta hoi jaise, aru polaikene taike dhurise aru chuma dise. ");
INSERT INTO nag_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Titia chokra pora koise, ‘Baba, moi sorgote thaka Isor aru apuni usorte paap korise. Moi apuni laga chokra kobole layak nai.’ ");
INSERT INTO nag_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kintu baba pora tai laga noukar khan ke koise, ‘Sobse bhal kapra joldi anibi, aru taike lagai dibi, aru tai laga anguli te anguthi lagai dibi, aru notun chapal bhi lagai dibi. ");
INSERT INTO nag_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aru sobse bhal guru laga bacha to ani kene maribi, aru moi khan sob kha luwa kori kene khushi koribo! ");
INSERT INTO nag_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kelemane moi laga chokra to mori jaisele, kintu etiya jinda hoise; tai harai jaise, kintu etiya pai loise.’ Titia taikhan sob khushi korise. ");
INSERT INTO nag_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Etu homoi te tai laga dangor chokra kheti te thakise. Jitia tai ghor usorte ponchise, tai manu khan gana kori kene nachi thaka awaj hunise. ");
INSERT INTO nag_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Titia tai ekjon noukar ke matikena ki hoi ase etu hudise. ");
INSERT INTO nag_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Titia noukar pora koise, ‘Tumi laga bhai wapas ahise aru tumi laga baba pora sobse bhal guru laga bacha katise. Kelemane baba pora tumi laga bhai ke bhal kori kene wapas pai loise.’ ");
INSERT INTO nag_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kintu dangor chokra to khong uthise aru bhitor te jabole mon kora nai, etu karone tai laga baba bahar te ulaikene taike ahibole nimite matise. ");
INSERT INTO nag_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kintu dangor chokra pora tai laga baba ke koise, ‘Sabi, iman saal moi apuni nimite kaam korise, aru kitia bhi niyom bhanga nai, hoilebi apuni moike ekta chutu saguli bhi diya nai ami laga sathi khan logote jai kene khushi kori bole, ");
INSERT INTO nag_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","kintu jitia apuni laga etu chokra ahise, jun he apuni laga dhun sompoti sob to biya kaam kori kene phelai dise, tai nimite apuni sobse bhal guru laga bacha to katise.’ ");
INSERT INTO nag_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Titia baba taike koise, ‘Bacha, tumi hodai moi logote ase, aru etu sob to tumi laga he ase. ");
INSERT INTO nag_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kintu etu kha luwa kori kene khushi kori bole nimite dorkar thakise, kelemane tumi laga etu bhai jinda ase; tai harai jaisele, hoilebi etiya taike pai loise.’” ");
INSERT INTO nag_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Titia Jisu chela khan ke koise, “Ekjon dhuni manu thakise aru tai laga ekjon imandar thakise, kintu tai malik laga poisa khorcha kori ase koi kene kunba pora malik ke koi dise. ");
INSERT INTO nag_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Titia dhuni manu taike mati kene hudise, ‘Eneka kotha khan tumi laga moi kele huni ase? Tumi ki kaam korise etu sob hisab kitab moike dibi, kelemane tumi etiya pora moi nimite kaam kori bole na paribo.’ ");
INSERT INTO nag_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Titia etu imandar tai nijorke koise, ‘Moi etiya ki koribo, moi laga malik pora kaam to moi pora loi lobole ase? Moi iman takot nai mati khundikena kaam kori bole aru moi bhik mangi bole sorom lage. ");
INSERT INTO nag_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Moi ki kori bole lage moi jane, jitia moike kaam pora ulai dibo, manu khan taikhan laga ghor te moike matibo.’ ");
INSERT INTO nag_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Titia noukar pora jiman manu malik pora dhar loi kene thakise sobke tai matise, aru poila ekjon ke hudise, ‘Tumi moi laga malik ke kiman dibole ase?’ ");
INSERT INTO nag_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tai koise, ‘Moi eksoh botol oliv tel dibole ase.’ Titia tai koise, ‘Tumi laga hisab lobi aru joldi bohi kene yate pachas eneka likhibi.’ ");
INSERT INTO nag_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aru baki luwa dusra ke hudise, ‘Aru tumi kiman dibole ase?’ Tai koise, ‘Eksoh jola chawal.’ Taike koise, ‘etu hisab lobi, aru joldi pora likhibi assi dhan bosta.’ ");
INSERT INTO nag_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Titia malik pora etu biya imandar jun chalaki pora kaam korise, taike bhal paise. Kilekoile, etu yug laga chokra khan to taikhan nijor yug laga chokra khan, jun khan jyoti laga ase, taikhan pora bhi bisi chalak ase. ");
INSERT INTO nag_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Moi tumikhan ke koi ase, paap laga dhun sompoti pora sathikhan bonai, aru jitia etu pora eku kaam nadiye, taikhan pora tumikhan ke kitia bhi khotom nohua jagate grohon kori lobo. ");
INSERT INTO nag_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jun manu olop te bhi biswas hoi kene thake tai bisi te bhi eneka he thake, aru jun manu olop te bhi thoga baji kore tai bisi te bhi eneka he kore. ");
INSERT INTO nag_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jodi tumikhan etu sapha nathaka dhun to bhal pora cholai kene rakhibo napare, tenehoile etu hosa dhun to tumikhan ke kun pora dibo? ");
INSERT INTO nag_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aru tumikhan dusra manu laga dhun to bhal kori kene nacholaile, titia tumi nijor laga dhun to kineka chola bo? ");
INSERT INTO nag_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ekjon nokor pora duita malik laga kaam koribo na paribo, eneka korile tai ekjon ke ghin koribo aru ekjon ke morom koribo, aru nohoile ekjon ke chari kene dusra ke jai jabo. Tumikhan Isor aru dhun sompoti eke logote sewa kori bole na paribo. ");
INSERT INTO nag_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aru jitia poisa morom kora Pharisee khan etu kotha khan hunise, taikhan Jisu uporte biya paise. ");
INSERT INTO nag_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Titia Jisu pora taikhan ke koise, “Tumikhan manu usorte nijorke bhal dikhai, kintu Isor he tumikhan laga mon to jane. Jun manu usorte dangor hobole bisare tai Isor usorte komjur hoijai. ");
INSERT INTO nag_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Bhabobadi khan aru niyom khan John laga homoi tak he thakise. Etu homoi para Isor laga rajyo laga susamachar prochar hoise, aru sob manu etu janibo nimite joborjosti jaise. ");
INSERT INTO nag_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sorgo aru prithibi harabo nimite asan ase, kintu niyom te ki likhi kene ase, etu laga ekta chutu bhag bhi naharabo. ");
INSERT INTO nag_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kun manu tai laga shadi maiki ke chari diye aru dusra maiki ke shadi kore, tai bebichari kaam korise, aru jun manu mota pora chari diya maiki logote shadi kore, tai bhi bebichari kaam kori ase. ");
INSERT INTO nag_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aru ekjon dhuni manu thakise, tai daam begoni rong kapra aru bhal mihin kapra lagai kene thakise, aru hodai din khushi aru moja pora thake. ");
INSERT INTO nag_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kintu ekjon gorib manu Lazarus koi kene tai laga mukhyo diwar te thakise aru tai laga gaw pura te biya ghaw pora bhorta koi kene thake, ");
INSERT INTO nag_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","aru etu dhuni manu laga thali pora ki gire eitu khan khabole nimite rukhi thake. Kintu kutta khan bhi ahikena tai laga ghaw to chati thake. ");
INSERT INTO nag_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Etiya etu gorib manu to mori jaise, aru tai laga atma ke sorgodoth pora Abraham laga usorte loi jaise. Aru etu dhuni manu bhi mori jaise aru taike kobor te di dise, ");
INSERT INTO nag_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","aru mora manu laga desh pora tai laga suku to uthaikene Abraham ke dikhise aru tai laga usorte Lazarus ke bohi thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Titia etu dhuni manu kandi kene koise, ‘Baba Abraham, moi uporte morom koribi aru Lazarus ke yate pathai dibi, tai laga anguli pora hoilebi moike pani dikene jiba ke thanda kori dibole, kelemane moi etu jui te juli kene dukh pai ase.’ ");
INSERT INTO nag_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kintu Abraham pora koise, ‘Bacha, yaad koribi tumi laga jibon te sob bhal saman he paise, aru Lazarus to sob biya he paise. Kintu etiya tai yate aram pora ase, aru tumi dukh te ase. ");
INSERT INTO nag_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Etu sob to charikena, tumi aru amikhan majote ekta dangor khai ase, etu thaka pora manu yate pora tumi logote jabo na paribo aru taikhan bhi ta te pora yate ahibo na paribo.’ ");
INSERT INTO nag_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Titia dhuni manu koise, ‘Moi apnike anurodh kori ase, baba, apuni kunba ke moi laga baba ghor te pathai dibi- ");
INSERT INTO nag_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kele koile moi laga pans jon bhai ase, taikhan ke hoshiar kori dibi, taikhan bhi etu dukh khotom nohua jagate nahibo nimite.’ ");
INSERT INTO nag_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kintu Abraham koise, ‘Taikhan logote Moses pora likha aru dusra bhabobadi khan pora likha bhi ase; taikhan ke taikhan laga kotha hunibo dibi.’ ");
INSERT INTO nag_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kintu dhuni manu pora koise, ‘Nohoi Baba Abraham, kintu kunba mora pora uthi kene jaile he, taikhan mon ghura bo.’ ");
INSERT INTO nag_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kintu Abraham taike koise, ‘Jodi taikhan Moses pora likha aru dusra bhabobadi khan pora likha kotha mana nai koile, mora manu uthi jaile bhi taikhan mon naghurabo.’” ");
INSERT INTO nag_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aru ek din Jisu pora chela khan ke koise, “Paap koribi dibole porikha to ahibo, kintu jun manu eitu khan loi kene ahe, taike hai ase! ");
INSERT INTO nag_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Eneka manu dusra ke dukh diya pora nijor gola te pathor bandhi kene pani nichete phelai dile he bhal hobo. ");
INSERT INTO nag_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nijorke bhal pora sai lobi. Jodi tumi laga bhai paap kori ase, tinehoile taike rukhai dibi; aru jodi tai mon ghurai loile, taike maph dibi. ");
INSERT INTO nag_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jodi bhi tai tumi logote sath bar paap kaam kore ek dinte, aru sath bar wapas ahi kene koi, ‘Moike maph dibi, titia tumi taike maph koribo lage!” ");
INSERT INTO nag_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostle khan pora Probhu ke koise, “Moi khan laga biswas dangor kori dibi.” ");
INSERT INTO nag_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Titia Probhu he koise, “Tumikhan laga biswas ekta sorso dana nisena thakile bhi, tumikhan etu mulberry ghas ke kobo, ‘Nijor laga niche shikor pora ulai jabi, aru jai kene samundar te ulabi,’ aru tumi laga kotha manibo. ");
INSERT INTO nag_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aru yate kun manu tai laga noukar kheti te kaam kori thaka homoi te, nohoile bhi saguli rukha homoi te taike kobo, ‘Joldi ahikena kha luwa koribi’? ");
INSERT INTO nag_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kintu, tai etu manu ke eneka nokobo naki, ‘Moi kiba khabole nimite taiyar koribi, aru tumi laga kapra ke peti bandi lobi jitia moike kha luwa di ase, aru etu pichete tumi kha luwa koribi’? ");
INSERT INTO nag_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tai laga noukar ke ki hukum dise etu tai kori diya nimite malik pora taike dhanyavad dise naki? ");
INSERT INTO nag_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Etu nisena tumikhan bhi, jitia tumikhan ke ki hukum diya sob kori loise, tumikhan eneka kobo lage, ‘Moi khan layak nathaka noukar ase. Moi khan ke ki koise etu he korise.’” ");
INSERT INTO nag_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aru etu homoi te jitia Jisu Jerusalem sheher te jaise, Tai Samaria aru Galilee jaga khan phale pora jai thakise. ");
INSERT INTO nag_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jitia tai ekta bosti te ponchise, dos jon kusto-rugi bemar thaka khan ke lok paise. Taikhan durte khara kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Aru taikhan awaj uthaikene, koise, “Jisu, Probhu, amikhan uporte morom koribi.” ");
INSERT INTO nag_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jitia Tai taikhan ke dikhise, Jisu taikhan ke koise, “Jabi aru nijorke purohit khan ke dikhabi.” Aru jitia taikhan jai thakise, taikhan sob sapha hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Titia ekjon taikhan majot pora, bhal howa dikhi kene ghuri kene saise aru jor awaj pora Isor ke mohima korise. ");
INSERT INTO nag_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tai Jisu laga theng nichete giri jaise, aru Taike dhanyavad dise. Tai Samaria laga manu thakise. ");
INSERT INTO nag_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Titia Jisu taike hudise, “Dos jun manu bhal huwa nai naki? Nou jun to kot te ase? ");
INSERT INTO nag_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Taikhan majote aru Isor ke dhanyavad dibole kun bhi wapas aha nai naki, khali etu manu he nohoile jun alag desh pora ase?” ");
INSERT INTO nag_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jitia Jisu he taike koise, “Uthibi aru jabi. Tumi laga biswas pora tumike bhal korise.” ");
INSERT INTO nag_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisee khan pora Jisu ke Isor laga rajyo kitia ahibo eneka hudise, Tai jawab dise, “Isor laga rajyo to koi kene nahe. ");
INSERT INTO nag_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aru eneka nokobo, ‘Sabi, yate ase!’ Nohoile ‘Ta te ase!’ Kintu sabi, Isor laga rajyo to tumikhan majote ase.” ");
INSERT INTO nag_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Titia Jisu laga chela khan ke koise, “Eneka din ahibo, jitia tumikhan Manu laga Putro ke sabole itcha koribi, kintu tumikhan dikhi napabo. ");
INSERT INTO nag_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Titia taikhan pora tumike kobo, ‘Sabi ta te!’ Nohoile ‘Sabi yate!’ Tumi taikhan laga pichete napola bhi, ");
INSERT INTO nag_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","jitia akas te bhijili mara homoi te ekta jaga pora dusra jagate ujala dikhe etu nisena Manu laga Putro bhi Tai wapas aha homoi te eneka hobo. ");
INSERT INTO nag_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kintu poila Tai bisi dukh pabo lagibo etu jamana manu khan hath pora. ");
INSERT INTO nag_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jineka Noah laga homoi te hoisele, eneka din Manu laga Putro laga homoi te bhi eneka hobo. ");
INSERT INTO nag_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Taikhan kha luwa kori thakise, shadi kori thakise, aru jibon to duniya laga khushi pora moja kori thakise, utu din tak jitia Noah dangor naw bhitor te ghusi jaise, aru dangor hawa pani ahi kene manu ke khotom kori dise. ");
INSERT INTO nag_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aru eneka din Lot laga homoi te bhi hoise- taikhan kha luwa nisa-panite moja kori thakise, ekjon-ekjon logote luwa-diya kori thakise, kunba ghor bonai thakise aru kunba kheti kori thakise: ");
INSERT INTO nag_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kintu jitia Lot Sodom pora ulai ahise, akas pora jui ahi kene sob manu ke khotom kori dise. ");
INSERT INTO nag_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aru eneka he din ahibo jitia Manu laga Putro wapas ahibo aru sob manu Taike dikhi pabo. ");
INSERT INTO nag_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Aru etu dinte, jun manu ghor uporte ase aru tai laga saman khan ghor te ase, taike etu saman lobole nimite nichete jabo nadibi; aru jun manu kheti te kaam kori ase, etu ke ghuri kene pichete sabole nadibi. ");
INSERT INTO nag_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot laga maiki ke yaad koribi. ");
INSERT INTO nag_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jun manu tai laga jibon bacha bole bisare tai harai dibo, kintu jun manu nijor jibon to Isor nimite harai diye tai bachibo. ");
INSERT INTO nag_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Moi tumikhan ke koi ase, etu rati te duijon ghumai thakibo. Ekjon ke uthai lobo, aru ekjon ke chari jabo. ");
INSERT INTO nag_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aru etu nisena duita mahila eke jagate dhaan khundi thakibo. Ekjon ke uthai loijabo aru ekjon ke chari jabo. ");
INSERT INTO nag_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Duijon manu kheti te kaam kori thakibo, ekjon ke loijabo aru ekjon ke chari jabo.” ");
INSERT INTO nag_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Titia taikhan pora Jisu ke koise, “Kot te Probhu?” Aru Tai pora taikhan ke koise, “Jun jagate manu laga gaw thake, ta te pucha mangso kha chiriya khan bhi joma kori kene thake.” ");
INSERT INTO nag_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ek din Jisu pora chela khan ke dristanto pora hikaise kineka taikhan prathana kori thakibo lage aru kitia bhi mon chutu nokorile lage. ");
INSERT INTO nag_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aru koise, “Ekta sheher te ekjon niyom chola manu thakise aru tai Isor ke bhoi nakore aru manu khan ke bhi hisab nakore. ");
INSERT INTO nag_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aru etu sheher te ekta bidhowa mahila thakise, aru tai, etu manu usorte hodai ahi thake, aru koi, ‘Moi laga dushman khan logot pora moike niyai dibi.’ ");
INSERT INTO nag_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bisi din pora tai etu mahila laga kaam kori dibo mon thaka nai, kintu etu mahila bisi kowa nimite tai nijorke koise, ‘Moi Isor ke bhoi nakore aru manu ke hisab nakore, ");
INSERT INTO nag_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kintu etu mahila moike hodai digdar diya nimite, moi tai nimite niyai kori dibo, eneka kori dile tai aru hodai ahi kene moike digdar nokorile.’” ");
INSERT INTO nag_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Titia Probhu pora aru koise, “Huni bhi etu thik nathaka ukil pora ki koise. ");
INSERT INTO nag_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Etiya Isor junke bachai loise taike sajai nadibo naki? Jun tai usorte din aru rati kandi thake? Taikhan laga kotha hunibo nimite deri rukhi thakibo naki? ");
INSERT INTO nag_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Moi tumikhan ke koi ase, tai joldi pora niyai to ani dibo. Jitia Manu laga Putro ahibo, Tai etu duniya te biswas pabo na napabo?” ");
INSERT INTO nag_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aru Tai etu dristanto bhi koise jun taikhan nijorke dharmik manu ase koi thake aru dusra ke ghin kori thake, ");
INSERT INTO nag_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Duijon manu prathana kori bole nimite jaise- ekjon Pharisee, aru ekjon poisa utha manu. ");
INSERT INTO nag_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aru Pharisee to tai alag phale khara kori kene tai nijor logote eneka prathana kori thakise, ‘Isor, moi Apnike dhanyavad di ase moi dusra manu khan nisena nohoi- chor, biya manu, paap kaam kori kene thaka manu aru poisa utha manu khan nisena bhi nohoi. ");
INSERT INTO nag_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Moi hapta te duibar upwas loi. Moi ki pai etu laga dos bhag bhi diye.’ ");
INSERT INTO nag_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kintu poisa utha manu, durte khara kori kene, tai nijor matha bhi sorgo phale sa nai, kintu tai laga chati to marikena prathana korise, ‘Isor, moi uporte daya koribi, moi paapi manu.’ ");
INSERT INTO nag_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Moi tumikhan ke koi ase, etu Pharisee, jun poisa utha manu thakise, tai Isor usorte mohima paikena nijor ghor te jaise. Kelemane jun manu tai nijorke untcha uthabole bisare tai chutu hoi jabo, kintu jun manu nijorke chutu kore taike uthai dibo.” ");
INSERT INTO nag_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ek din kunba manu khan Jisu usorte bacha khan ke loi kene anise,Jisu laga hath taikhan uporte dikene asirbad dibole nimite. Kintu jitia chela khan pora etu dikhise, taikhan ke ahibo diya nai. ");
INSERT INTO nag_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kintu Jisu taikhan ke matise aru koise, “Chutu bacha khan ke Moi usorte ahibo dibi, aru taikhan ke narukhabi. Kelemane Isor laga rajyo to taikhan nisena nimite ase. ");
INSERT INTO nag_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Moi hosa pora tumikhan ke koi ase, jun pora ekta bacha nisena hoi kene Isor rajyo ke swekar nakore, tai ji hoilebi ta te gusibo na paribo.” ");
INSERT INTO nag_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aru ekjon Yehudi cholawta manu Taike hudise, “Bhal hikhok, moi anonto jibon pabo nimite ki koribo lage?” ");
INSERT INTO nag_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Titia Jisu taike jowab dise, “Moike kele bhal koi ase? Kun bhi bhal nai, khali Isor he bhal ase. ");
INSERT INTO nag_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Isor laga niyom tumikhan jane bebichar nokorile, manu ke nomorabi, chor nokoribi, manu laga misa kotha nokobi, baba, ama ke morom koribi.” ");
INSERT INTO nag_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kintu cholawta manu he koise, “Moi jawan pora etu sob manikena ahise.” ");
INSERT INTO nag_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jitia Jisu tai kowa kotha hunise, Tai koise, “Ekta kotha etiya bhi tumi mana nai: Tumi laga ki ase etu sob bikiri kori dibi aru gorib khan ke bhag kori dibi, titia tumi laga dhun sompoti sorgote thakibo- aru Moi laga pichete ahibi.” ");
INSERT INTO nag_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jitia cholawta manu Jisu laga kotha hunise, tai bisi mon dukh paise kele koile tai bisi dhuni manu thakise. ");
INSERT INTO nag_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Titia Jisu taike saikene koise, “Dhuni manu sorgote jabole kiman digdar ase! ");
INSERT INTO nag_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Biji laga chenda pora ekta uth jabole asan ase, hoilebi dhuni manu Isor laga rajyote jabole nimite asani nohoi. ");
INSERT INTO nag_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jun etu kotha hunise taikhan koise, “Tinehoile kun he poritran pabo?” ");
INSERT INTO nag_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kintu Jisu koise, “Juntu kaam manu napare, Isor he pare.” ");
INSERT INTO nag_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Titia Peter he koise, “Sabi amikhan sob chari kene Apuni laga piche ahise.” ");
INSERT INTO nag_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Titia Jisu taikhan ke koise, “Hosa pora Moi tumikhan ke koi ase jun manu tai laga ghor, maiki, bhai, ama, baba, bacha ke Isor laga rajyo nimite charise, ");
INSERT INTO nag_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","etu duniya te aru bisi napabo- aru ahibole duniya te, anonto jibon pabo.” ");
INSERT INTO nag_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Titia Tai baroh jonke alag kori kene koise, “Sabi, amikhan Jerusalem te jabo, aru bhabobadi khan pora Manu laga Putro nimite Isor kotha ki likhise, etu sob purah hobole ase. ");
INSERT INTO nag_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Karone Taike Porjati khan hathte di dibo, aru Taike bodnam koribo, aru bisi sorom khila bo, aru Tai uporte thuk phelabo. ");
INSERT INTO nag_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Aru Taike chabuk pora maribo, aru morai dibo, aru tisra dinte, Tai aru bhi jee uthijabo.” ");
INSERT INTO nag_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kintu chela khan etu kotha bujhi panai, aru etu kotha taikhan pora lukai rakhise, aru ki kotha koise etu bujhi bo para nai. ");
INSERT INTO nag_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Etiya eneka hoise, jitia Jisu Jericho sheher te ahise, ekjon andha manu rasta kinar te bohi kene bhik mangi thakise. ");
INSERT INTO nag_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tai manu khan hala kori kene jai thaka to hunise, tai hudise etu ki hoi ase. ");
INSERT INTO nag_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Taikhan andha manu ke koise, “Nazareth laga Jisu etu rasta pora jai ase.” ");
INSERT INTO nag_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Titia tai kandikena jor pora koise, “Jisu, David laga Putro, moi uporte morom koribi.” ");
INSERT INTO nag_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jun manu Jisu age te jai thakise khong pora taike chup thaki bole koise. Kintu tai bisi hala kori thakise, “David laga Putro, moi uporte morom koribi.” ");
INSERT INTO nag_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Titia Jisu khara kori kene etu manu ke usorte anibole koise. Aru jitia tai usorte ahise, Jisu taike hudise, ");
INSERT INTO nag_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Moi tumi nimite ki kori bole tumi itcha ase?” Tai koise, “Probhu, moi suku pora sabole itcha ase.” ");
INSERT INTO nag_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Titia Jisu he taike koise, “Tumi laga suku khuli bhi. Tumi laga biswas pora tumi bhal hoise.” ");
INSERT INTO nag_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Etu homoi te tai sabo parise aru Jisu pichete jaise, Isor ke mohima dikene, sob manu khan jitia etu dikhise, taikhan Isor ke stuti dise. ");
INSERT INTO nag_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Aru titia Jisu ahise aru Jericho sheher phale jaise. ");
INSERT INTO nag_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Etiya ekjon manu Zacchaeus koi kene thakise, aru tai poisa utha manu khan majote sobse dangor aru dhuni manu thakise. ");
INSERT INTO nag_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tai Jisu kun ase koi kene sabole itcha korise, kintu bhir dangor huwa pora sabo para nai, aru tai khata manu thakise. ");
INSERT INTO nag_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Titia tai Jisu ke sabole nimite polai jai kene ekta sycamore ghas te uthise, kelemane Jisu etu rasta pora he jabo thakise. ");
INSERT INTO nag_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jitia Jisu etu jagate ahise, Jisu taike saikene koise, “Zacchaeus, joldi namikene ahibi, aji Moi tumi laga ghor te jai kene thakibo.” ");
INSERT INTO nag_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Titia tai joldi kori kene nichete nami ahise, aru khushi pora Jisu ke tai laga ghor te ahibole matise. ");
INSERT INTO nag_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jitia manu khan etu dikhise, taikhan sob biya paise aru apaste koi thakise, “Jisu ekjon paapi manu laga ghor te jaise.” ");
INSERT INTO nag_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aru titia Zacchaeus uthikena Probhu ke koise, “Sabi, Probhu moi laga adha saman khan gorib ke di dibo, aru jodi moi kunba ke thogaise, tai laga bhag pora bisi aru char bhag milaikena dibo.” ");
INSERT INTO nag_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Titia Jisu taike koise, ‘Aji poritran etu ghor te ahise, kelemane tai bhi Abraham laga khandan pora ase. ");
INSERT INTO nag_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kelemane Manu laga Putro to harai kene thaka manu khan ke bisari bole aru bacha bole ahise. ");
INSERT INTO nag_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aru taikhan etu kotha huni thakise, Jisu ekta dristanto kobole shuru hoise, kelemane tai Jerusalem te jabole nimite usor hoise, aru taikhan bhabise Isor laga rajyo to ta te joldi ahibole ase. ");
INSERT INTO nag_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Titia Tai koise, ekta bhal ghor te jonom huwa manu dur ekta desh te tai laga rajyo pabo nimite jaise, aru etu pichete tai wapas ahi jabole thakise. ");
INSERT INTO nag_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Etu karone tai laga dosta noukar khan ke matise, aru taikhan ke dosta mina dikene koise, ‘etu mina loi kene tumikhan ki kaam koribo pare etu kori kene thakibi moi wapas naha tak.’ ");
INSERT INTO nag_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kintu manu khan taike bhal panai aru tai laga pichete ekjon ke pathai kene taike koise, ‘etu manu moi khan uporte raj kora to moi khan nalage.’ ");
INSERT INTO nag_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Aru jitia tai rajyo paikena wapas ahi jaise, titia tai koise jun manu ke tai poisa dise taikhan ke mati kene tai usorte loi anibole, ta te tai sabo kun pora bisi kaam kori kene labh paise. ");
INSERT INTO nag_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Poila ekjon tai usorte ahi kene koise, ‘Malik, apuni pora diya poisa loi kene moi aru etu laga dos bhag dise kori dise.’ ");
INSERT INTO nag_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Titia etu bhal manu pora taike koise, ‘Bisi bhal korise, bhal noukar. Kelemane tumi olop diya te bhi bhal kaam kori kene thakise, tumi etu dosta sheher uporte adhikar chola bo.’ ");
INSERT INTO nag_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aru dusra jon bhi ahise, aru koise, ‘Malik, apuni pora panch poisa diya to moi pans bhag bisi kori dise.’ ");
INSERT INTO nag_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Titia etu bhal manu taike koise, ‘Tumi bhi bhal kaam korise etu nimite pansta sheher uporte tumi adhikar chola bo.’ ");
INSERT INTO nag_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Aru tisra noukar ahise, aru koise, ‘Malik, etu apuni diya laga poisa ase, moi etu loi kene kapra pora bandhi rakhise, ");
INSERT INTO nag_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kele koile, moi apnike bhoi lagi thakise. Kelemane apuni hisab kitab thik rakha manu ase. Apuni ki joma nakore etu uthai aru ki narupai etu he kate.’ ");
INSERT INTO nag_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Titia etu manu pora taike koise, ‘Tumi laga mukh pora he moi tumike bisar koribo, tumi biya noukar! Tumi jani thakise naki moi ekjon joborjosti kori thaka manu ase, aru moi ki joma nakore etu loi, aru ki nadhale etu kata manu ase? ");
INSERT INTO nag_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Titia hoile tumi etu poisa to kele poisa-ghor te joma kora nai, aru jitia moi ahibo, etu homoi te bisi labh hobo thakise?’ ");
INSERT INTO nag_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Titia tai jun manu usorte khara kori thakise taikhan ke koise, ‘Tai logot pora poisa to loi lobi, aru jun logote dos bhag ase taike di dibi.’ ");
INSERT INTO nag_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kintu taikhan koise, ‘Malik, tai logote dos bhag ase.’ ");
INSERT INTO nag_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Moi tumikhan ke koi ase, jun manu logote bisi ase taike aru bhi bisi dibo, kintu jun manu logote eku nai, ki tai logote ase etu bhi loi lobo. ");
INSERT INTO nag_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kintu etu moi laga dushman khan, jun manu moike taikhan uporte raj kori bole dibo mon thaka nai, yate loi kene anibi aru moi usorte morai dibi.’” ");
INSERT INTO nag_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Etu sob pichete, Jisu aru chela khan sob Jerusalem phale jaise. ");
INSERT INTO nag_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aru jitia Tai Bethphage aru Bethany nogorkhan usorte ahise, Olivet kuwa ekta pahar te, Tai duijon chela ke pathaise, ");
INSERT INTO nag_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","aru koise, “Tumikhan etu age te thaka bosti te jabi. Jitia ta te punchibo, tumikhan ta te kun pora bhi naboha ekta ghora laga bacha ke bandi kene thaka dikhibo. Etu ke Khuli Kena yate loi anibi. ");
INSERT INTO nag_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jodi kunba tumikhan ke hude, ‘Kile etu ke khuli ase?’ Tumikhan etu kobi, ‘Probhu ke etu dorkar ase.’” ");
INSERT INTO nag_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aru jun khan ke etu karone pathaise, taikhan pora thik eneka he dikhi paise. ");
INSERT INTO nag_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jitia taikhan etu ghora bacha ke khuli thakise, malik ahikena taikhan ke koise, “Kile etu ghora bacha ke khuli ase?” ");
INSERT INTO nag_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Titia taikhan pora koise, “Probhu ke etu dorkar ase.” ");
INSERT INTO nag_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Titia taikhan Jisu usorte anise, aru taikhan laga kapra gadha uporte phelai dise aru Jisu ke gadha uporte bohi bole dise. ");
INSERT INTO nag_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aru jitia taikhan jai thakise, manu khan kapra ulaikene rasta te rakhidise. ");
INSERT INTO nag_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jitia Jisu Oliv pahar usorte ahi ponchise, aru chela aru manu khan dhanyavad dibole shuru hoise. Manu khan Jisu laga dangor kaam khan dikhi kene hala kori kene Isor ke mohima dikena ");
INSERT INTO nag_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","koise, “Dhonyo ase etu raja jun manu Probhu laga naam te ahise! Sorgote shanti hobo aru sob untcha jagate mohima dibo!” ");
INSERT INTO nag_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kintu kunba Pharisee manu khan majot pora koise, “Shika manu, Apuni laga chela khan ke chup thaki bole kobi.” ");
INSERT INTO nag_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Titia Jisu koise, “Moi tumikhan ke koi ase jodi taikhan chup thake, pathor khan pora he hala kori jabo.” ");
INSERT INTO nag_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aru jitia Jisu Jerusalem sheher usorte ponchise, Tai kandise, ");
INSERT INTO nag_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aru koise, “Aji tumikhan pora kineka shanti ahe etu jani thakile! Kintu tumikhan laga suku pora lukaikene ase. ");
INSERT INTO nag_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tumikhan uporte eneka din khan ahibo jitia dushman khan pora tumikhan ke sob phale pora dhori rakhibo aru dewar bonai kene tumikhan ke sob kinar pora dabai dibo. ");
INSERT INTO nag_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tumi aru tumi laga bacha khan ke matite girai dibo. Taikhan ekta pathor bhi tumikhan uporte nacharibo, kelemane etu laga homoi te ki dikhai dise, etu tumikhan janibole para nai.” ");
INSERT INTO nag_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jitia Jisu mondoli bhitor te ghusi se, Tai bhitor te bajar kori thaka manu khan ke khedai se, ");
INSERT INTO nag_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Taikhan ke koise, “Etu Isor kotha te likha ase, ‘Moi laga ghor to prathana laga ghor hobo,’ kintu tumikhan chor laga ghor bonai dise.” ");
INSERT INTO nag_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aru Jisu mondoli te sikhai thakise. Etu homoi te mukhyo purohit khan aru niyom likha khan aru Pharisee khan Jisu ke mora bole rukhi thakise, ");
INSERT INTO nag_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kintu kineka pora Taike dhoribo etu taikhan koribo para nai, kelemane sob manu Jisu laga kotha to huni kene bohi thakise. ");
INSERT INTO nag_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ek din jitia Jisu ekta jagate manu khan ke mondoli te sikhai thakise aru susamachar prochar kori thakise, mukhyo purohit khan aru niyom jana manu aru cholawta khan Tai logot ahise. ");
INSERT INTO nag_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Taikhan pora Taike eneka hudise, “Amikhan ke kobi ki adhikar pora Apuni etu kori ase, aru kun ase jun pora etu kori bole Apuni ke adhikar dise.” ");
INSERT INTO nag_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisu taikhan ke koise, “Moi bhi tumikhan ke ekta kotha hudibo, aru tumikhan Moike kobi. ");
INSERT INTO nag_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John laga baptizma: Isor pora hoise na manu pora hoise?” ");
INSERT INTO nag_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Taikhan ekjon-ekjon logote kotha patikena, koise, “Jodi moi khan koi, ‘Isor pora ase,’ Tai kobo, ‘Tenehoile tumikhan taike kele biswas kora nai?’ ");
INSERT INTO nag_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kintu amikhan jodi koi, ‘Manu pora ase’ koile, sob manu amikhan ke pathor maribo, kele koile taikhan John to ekjon bhabobadi ase koi kene biswas kore.” ");
INSERT INTO nag_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Taikhan Jisu ke koise etu kot pora ahise taikhan najane koi kene. ");
INSERT INTO nag_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Titia Jisu taikhan ke koise, “Moi bhi tumikhan ke nokobo ki adhikar pora Moi eitu khan kori ase.” ");
INSERT INTO nag_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Titia Tai manu khan ke etu dristanto koise, “Ekjon manu kheti te angur ghas hali se, aru tai etu kheti kora manu khan ke di dise, aru tai dusra desh te bisi din nimite jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Aru jitia homoi ahise tai ekjon noukar ke kheti kora khan logot pathaise, kheti te angur ulaikene thakile, tai nimite pothabole. Kintu kheti kora manu khan etu noukar ke marise aru khali hath pathai dise. ");
INSERT INTO nag_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aru dusra manu ke pathaise, kintu taike bhi marise aru bisi sorom khilai dise, aru taike khali hath pathai dise. ");
INSERT INTO nag_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Titia aru ekjon ke pathaise, kintu taike bhi jokhom kori kene bahar te phelai dise. ");
INSERT INTO nag_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Titia kheti laga malik pora nijorke koise, ‘Moi ki koribo? Moi bisi morom kori thaka bacha ke pathai dibo. Eneka korile taikhan taike adar koribo pare.’ ");
INSERT INTO nag_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kintu jitia kheti kora manu khan pora taike dikhise, taikhan ekjon-ekjon logote kotha patise, aru koise, ‘Etu uttoradhikari ase. Ahibi taike morai dibo, titia etu sob kheti to moi khan laga hoi jabo.’ ");
INSERT INTO nag_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aru taikhan pora chokra ke kheti pora bahar te phelai dise aru taike morai dise. Titia hoile kheti laga malik pora taikhan ke ki koribo? ");
INSERT INTO nag_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kheti malik to ahi kene etu kheti kora manu khan ke khotom kori dibo aru etu kheti to dusra manu khan ke di dibo.” Kintu jitia manu khan etu hunise, taikhan koise, “Eneka kitia bhi hobo nadibo!” ");
INSERT INTO nag_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Titia Jisu taikhan ke saikene koise, “Tinehoile Isor kotha te etu likhi kene rakha to ki ase: ‘Juntu pathor ghor bona manu khan pora phelai dise, etu pathor he ghor ke khara kori kene rakha pathor hoi jaise’? ");
INSERT INTO nag_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jun manu etu pathor te giribo, tai bhangi kene tukra hoi jabo. Kintu jun manu uporte etu gire, taike mihin kori dibo.” ");
INSERT INTO nag_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Titia niyom likha aru mukhyo purohit khan etu homoi te Tai uporte hath laga bole bisarise, kelemane taikhan jani jaise Jisu to etu dristanto taikhan nimite he koise. Kintu taikhan manu khan ke bhoi kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Etu karone Taike taikhan bhal kori kene sai thakise, aru Tai pichete manu lagai dise, jun dharmik thaka nisena dikhai thakise kintu Jisu laga kotha khan te golti bisari thakise, aru taikhan laga cholawta khan laga aru governor laga hathte di dibole karone. ");
INSERT INTO nag_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Titia, Yehudi cholauta khan pora manu potha khan to ahi kene Jisu ke hudise, “Probhu, moi khan jane Apuni hosa kotha he sikhai, aru kun logote bhi alag pora bebohar nakore, aru Apuni Isor laga kotha to hosa pora sikhai. ");
INSERT INTO nag_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Moi khan ke koi dibi, Caesar ke poisa diya to niyom te thik ase na nai?” ");
INSERT INTO nag_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kintu Jisu taikhan laga chalaki jani jaise, aru taikhan ke koise, ");
INSERT INTO nag_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moike etu denarius dikha bhi. Kun laga chehera aru kotha ta te likha ase?” Titia taikhan koise, “Caesar laga.” ");
INSERT INTO nag_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Titia Tai koise, “Etu nimite ji to Caesar laga ase etu Caesar ke dibi aru ji to Isor ke dibo lage etu Isor ke dibi.” ");
INSERT INTO nag_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Etu kotha pora taikhan Jisu ke manu majot pora dhori bole para nai, kintu Jisu laga jowab te sob asurit hoi thakise, aru taikhan chup-chap hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Titia kunba Sadducee khan, kunkhan jun jee utha te biswas nakore, Jisu usorte ahikena hudise, ");
INSERT INTO nag_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Probhu, Moses pora moi khan ke likhise, jodi kunba laga bhai ase aru tai maiki chari kene mori jaise, aru tai bacha nai, tenehoile etu morija laga bhai to maiki ke lobo pare aru tai laga morija bhai naam te bacha jonom kori kene khandan ulabo pare. ");
INSERT INTO nag_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ta te sat-ta bhai thakise, aru dangor wala pora maiki ke shadi korise, kintu bacha nathakikena mori jaise; ");
INSERT INTO nag_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","aru dusra pora etu maiki ke loise kintu tai bhi bacha nathaki kene mori jaise. ");
INSERT INTO nag_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aru tisra jon pora bhi maiki ke loise, kintu tai bhi eneka he mori jaise, aru etu nisena sath jon bhi maiki ke loise, kintu tai bhi bacha nathaki kene mori jaise. ");
INSERT INTO nag_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aru hekh te maiki bhi mori jaise. ");
INSERT INTO nag_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Etu nimite jee utha dinte, tai kun laga maiki hobo? Kelemane tai sat jon laga bhi maiki thakise.” ");
INSERT INTO nag_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Titia Jisu taikhan ke koise, “Etu yug laga manu khan shadi kore aru shadi koribo nimite di diye. ");
INSERT INTO nag_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hoilebi jun khan etu yug te thaki bole nimite layak hoise, aru mori kene jee uthibo, taikhan to shadi bhi nakore, aru shadi te bhi nadiye; ");
INSERT INTO nag_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","kelemane taikhan kitia bhi namoribo, taikhan sorgodoth hoi jabo; aru taikhan jinda thaka Isor laga bacha khan ase kobo, kelemane taikhan jee utha laga chokra khan ase. ");
INSERT INTO nag_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aru Moses pora bhi juli thaka ghas pora morija uthai diya dikhai dise, jitia tai Probhu ke Abraham laga Isor, Isaac laga Isor aru Jacob laga Isor matise. ");
INSERT INTO nag_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Etiya Tai to mora laga Isor nohoi kintu jinda khan laga ase, kelemane moi khan sob tai logote jinda ase.” ");
INSERT INTO nag_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Titia kunba niyom likha khan pora Jisu ke koise, “Probhu, Apuni bhal pora koise.” ");
INSERT INTO nag_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kelemane taikhan aru Taike hudibole himot kora nai. ");
INSERT INTO nag_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Titia Jisu pora taikhan ke hudise, “Taikhan kineka kobo pare, Khrista to David laga chokra ase? ");
INSERT INTO nag_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David nijor pora Bhajan Geet laga kitab te likhise, Probhu pora moi laga Probhu ke koise, ‘Moi laga dyna hathte bohibi, ");
INSERT INTO nag_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Jitia tak moi dushman khan ke tumi laga theng nichete giribole nadiye.’ ");
INSERT INTO nag_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David tai nijor pora Khrista ke ‘Probhu’ mate, tinehoile Tai kineka tai laga chokra hobo?” ");
INSERT INTO nag_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jitia sob manu khan huni thakise, Jisu pora chela khan ke koise, ");
INSERT INTO nag_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Etu niyom likha khan pora hoshiar thakibi, jun khan lamba kapra te bera bole bisare, aru bajar te sob pora bhal jaga bisare, aru mondoli te sob pora untcha jagate bohi bole bisare, aru kha luwa jagate bhi bhal he bisare. ");
INSERT INTO nag_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bidhowa khan laga ghor khan khotom kori diye aru dikha bole nimite lamba prathana kore. Eitu khan nisena pichete dangor sajai pabo.” ");
INSERT INTO nag_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Etiya Jisu uporte saise aru dhuni manu khan pora taikhan laga dhun laga daan khazana te di thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aru titia Tai ekjon gorib bidhowa aha dikhise aru tai logot duita poisa thaka ke daan te di dise. ");
INSERT INTO nag_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Titia Jisu pora chela khan ke koise, “Hosa pora Moi tumikhan ke koi ase, etu gorib bidhowa he sob pora bisi daan dise. ");
INSERT INTO nag_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Jiman manu daan dise taikhan logote bisi thaka hisab te dise. Kintu etu bidhowa, tai logote eku nai, hoilebi tai ki ase etu sob di dise.” ");
INSERT INTO nag_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aru jitia kunba manu khan mondoli laga kotha koi thakise, kineka sundur pathorkhan aru manu khan laga daan pora mondoli ke bonaise, Tai koise, ");
INSERT INTO nag_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Etu tumikhan etiya dikhi thaka to, eneka din ahibo, jitia ekta pathor bhi nabachibo aru juntu ekta uporte ekta ase, etu sobke girai dibo.” ");
INSERT INTO nag_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Titia taikhan Taike, koise, “Shika manu, etu sob to kitia hobo, aru eneka din ahibole ase koi kene moi khan kineka janibo?” ");
INSERT INTO nag_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Titia Jisu koise, “Hoshiar thakibi aru kun pora bhi tumike thogai dibo nadibi. Bisi manu Moi laga naam loi kene ahibo, aru kobo, ‘Moi Jisu ase,’ aru ‘Homoi to usorte ahise.’ Taikhan laga piche najabi. ");
INSERT INTO nag_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jitia tumikhan lorai aru jhagara laga kotha khan hunibo, bhoi nokoribi, kelemane eitu khan sob poila hobo lagibo, kintu eneka sob hoilebi hekh homoi to eitu khan huwa loge-loge te nahibo.” ");
INSERT INTO nag_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aru Jisu taikhan ke koise, “Ekta desh pora dusra desh bhirodh te uthibo, aru ekta rajyo pora dusra rajyo logote lorai koribo. ");
INSERT INTO nag_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aru dangor mati hili bo, khabole napabo aru alag kisim bemar khan ulabo. Ekdom biya ghatna khan hobo aru etu logot te akash te asurit chihna khan dikhibo. ");
INSERT INTO nag_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kintu eitu khan huwa age te, manu khan pora tumikhan laga uporte hath uthabo aru bisi dukh dibo, tumikhan ke mondoli khan aru bondhi ghor khan te bhi hali dibo, raja khan aru Governor khan usorte anibo moi laga naam luwa nimite. ");
INSERT INTO nag_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eitu khan huwa pora tumikhan gawahi dibole nimite ekta bhal homoi hobo. ");
INSERT INTO nag_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Etu nimite nijor mon to shanti rakhibi aru homoi naha age te ki safai dibo lagibo etu nimite chinta nokoribi, ");
INSERT INTO nag_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kintu Moi tumikhan ke kotha kobole aru gyaan dibo, aru ta te tumikhan usorte kun ahibo taikhan tumi laga kotha mana kori bole na paribo. ");
INSERT INTO nag_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kintu tumikhan laga nijor ama baba pora tumike chari dibo, aru bhai khan, aru ghor manu khan, sathi khan bhi chari dibo, aru kunba ke to taikhan morai dibo. ");
INSERT INTO nag_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Moi laga naam nimite tumikhan ke sob manu pora ghin koribo. ");
INSERT INTO nag_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kintu tumi laga matha te thaka ekta chuli bhi naharabo. ");
INSERT INTO nag_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kintu tumikhan nomro aru biswas te thakile tumikhan laga atma labh lobo. ");
INSERT INTO nag_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kintu jitia Jerusalem ke sipahi khan pora gherikena thaka dikhibo, titia jani lobo, khotom hobole homoi to ahise. ");
INSERT INTO nag_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aru Judea te thaka khan pahar te polai jabi, etu jaga majote thakile chari kene jai jabi, aru jun manu etu desh bhitor te nai taikhan ke gushi bole nadibi. ");
INSERT INTO nag_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Etu din to niyai kora laga homoi ase, aru Isor kotha te ki likha ase etu pora hobole nimite. ");
INSERT INTO nag_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kintu hai ase jun khan bacha bukhi ase, aru jun bacha khan ke sai ase! Etu jagate dangor dukh ahibole ase, aru manu khan uporte Isor laga khong ahibole ase. ");
INSERT INTO nag_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kunba to nijor talwar laga dhar pora giri jabo, aru dusra desh te taikhan ke dhori kene loijabo, aru Jerusalem to Porjati khan pora raj chola bo jitia tak Porjati khan laga homoi pura nohoi. ");
INSERT INTO nag_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Aru chihna khan to suryo, chand aru tara khan ke dikhibo, aru prithibi te thaka desh khan sob samundar laga pani bisi hili thaka nisena dangor chinta hobo. ");
INSERT INTO nag_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Etu duniya te ki ahibole ase eitu khan bhabikena bhoi pora manu khan behosh hoi jabo, kelemane sorgo laga takot sobke hilai dibo. ");
INSERT INTO nag_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Titia sob manu khan Manu laga Putro badal te hokti thaka aru dangor mohima pora loi kene ahi thaka dikhibo. ");
INSERT INTO nag_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jitia etu sob hoi thakibo, khara koribi aru matha to uporte uthai lobi, kelemane tumike bachai lobole usor hoise.” ");
INSERT INTO nag_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Titia Tai taikhan ke ekta dristanto koise: “Sabi etu dimoru ghas ke, aru sob ghas khan ke. ");
INSERT INTO nag_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Jitia ghas te phul ulai jai, tumikhan dikhi kene nijor pora jani jai gorom din ahi ase. ");
INSERT INTO nag_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Etu nisena, jitia tumikhan etu sob hoi thaka dikhibo, titia tumikhan jani lobi Isor laga rajyo usorte ahise. ");
INSERT INTO nag_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hosa pora Moi tumikhan ke koi ase, etiya laga manu khan khotom hoi najabo jitia tak etu sob pura nohoi. ");
INSERT INTO nag_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sorgo aru prithibi harai jabo, kintu Moi laga kotha ki koise etu kitia bhi naharabo. ");
INSERT INTO nag_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nijorke bhal kori kene rakhibi, nisa pani khai kene tumikhan laga mon ke bhari kori bole nadibi, aru jibon laga kiman chinta bhabona ase etu pora mon dukh nokorile, kelemane etu din achanak pora ahibo aru tumike dhuri lobo. ");
INSERT INTO nag_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ekta jal phela nisena, jiman manu duniya te thaki ase taikhan uporte ahibo. ");
INSERT INTO nag_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kintu sob homoi te hoshiar thakibi, prathana te takot koribi etu sob ki hobole ase eitu khan pora polabole paribo nimite, aru Manu laga Putro usorte khara kori bole paribo nimite.” ");
INSERT INTO nag_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Aru etu din khan te Tai mondoli te sikhai thakise, aru rati te Tai Olivet pahar uporte jai kene thakise. ");
INSERT INTO nag_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aru bisi phojurte manu khan Jisu laga kotha huni bole mondoli te punchise. ");
INSERT INTO nag_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Etiya Khomir Nokhuwa Roti laga Purbb dinte, juntu ke Nistar din eneka mate, etu din usor hoise. ");
INSERT INTO nag_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mukhyo purohit khan aru niyom likha khan Jisu ke kineka morai dibole etu laga upai bisari thakise, kele koile taikhan manu khan ke bhoi lagi thakise. ");
INSERT INTO nag_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Titia Saitan pora Judas bhitor te ghusi jaise, jun laga naam Iscariot bhi asele, tai bhi chela bhitor te ekjon thakise. ");
INSERT INTO nag_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Etu pichete Judas jai kene mukhyo purohit khan aru henedhikari khan logote kineka kori kene Jisu ke dhoribo etu upai bisarise. ");
INSERT INTO nag_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Taikhan khushi paise, aru taike poisa dibole nimite kotha milaise. ");
INSERT INTO nag_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aru etu kori bole Judas mani loise, aru Jisu ke kineka pora manu nathaka homoi te dhoribo etu upai bisari thakise. ");
INSERT INTO nag_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Aru khomir nadiya roti kha laga din ahise, etu dinte Nistar laga mer ke bolidan kori bole niyom ase. ");
INSERT INTO nag_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisu pora Peter aru John duijon ke pathai kene koise, “Jaikena amikhan nimite Nistar naam pora kha luwa rakhibi, amikhan mili kene khabo.” ");
INSERT INTO nag_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Taikhan pora Taike koise, “Probhu kun jagate jai kene amikhan taiyar koribo?” ");
INSERT INTO nag_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tai pora koise, “Sabi, jitia tumikhan sheher te ponchibo, ekjon manu pani laga baltin loi kene thaka lok pabo. Tai laga piche jabi jun to ghor te tai ghuse. ");
INSERT INTO nag_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Titia ghor laga malik ke jai kene kobi, ‘Shika manu pora apuni ke koi ase, “Bahar manu thaki bole laga kamra to kot ase, jun jagate Moi laga chela khan ke loi kene Nistar naam laga khana koribo?’” ");
INSERT INTO nag_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Titia tai tumikhan ke uporte loijai kene dangor ekta bhal kamra dikha bo. Jaikena ta te he taiyari koribi.” ");
INSERT INTO nag_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aru taikhan jai kene Jisu kineka koise eneka he paise. Titia taikhan Nistar laga kha luwa jai kene taiyar korise. ");
INSERT INTO nag_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aru jitia Nistar laga khana khabole homoi ahise, Jisu bohi jaise aru Tai laga apostle khan bhi bohi jaise. ");
INSERT INTO nag_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Titia Tai koise, “Moi dukh napa age te tumikhan logote bohi kene etu Nistar laga khana khabole mon thakise. ");
INSERT INTO nag_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Moi tumikhan ke koi ase, Moi etu nakhabo jitia tak etu sob Isor laga rajyote pura nohoi.” ");
INSERT INTO nag_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Titia Jisu kup to loise, aru dhanyavad dikena koise, “Etu lobi, aru ekjon-ekjon logote bhag kori lobi. ");
INSERT INTO nag_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Moi tumikhan ke koi ase, etiya pora Isor laga rajyo naha tak, Moi etu angur ros laga pani napibo.” ");
INSERT INTO nag_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jitia Tai roti to loise aru Isor ke dhanyavad dise, Tai bhag kori kene taikhan ke dise aru koise, “Etu Moi laga gaw ase juntu tumikhan karone dise. Moike yaad kori bole eneka koribi.” ");
INSERT INTO nag_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tai kup to loi kene koise, “Etu kup to Moi laga khun te notun niyom bonai ase, juntu tumikhan nimite bohi ulai ase. ");
INSERT INTO nag_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kintu sabi, kun manu Moike dhoka dibole ase, tai bhi amikhan logote bohi ase. ");
INSERT INTO nag_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Manu laga Putro ke ki hobole ase etu sob to Isor pora poila te he likhi kene ase. Kintu O jun manu pora Taike thogabole ase, tai hai paise!” ");
INSERT INTO nag_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chela khan majote hudi thakise amikhan majote kun pora eneka kaam koribo. ");
INSERT INTO nag_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pichete chela khan majot jhagara ulaise kun he taikhan majote sob pora dangor hobo laga kotha te. ");
INSERT INTO nag_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Titia Tai koise, “Porjati laga rajakhan pora taikhan ke raj kore, aru taikhan uporte adhikari chola khan ke ‘bhal kori diya khan’ eneka mate. ");
INSERT INTO nag_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kintu tumikhan eneka nakoribo lage. Tumikhan majote kun manu dangor bhabi thake tai sob pora chutu hobo lage; aru jun manu age te ase, tai to ekjon sewa kori thaka manu nisena hobo lage. ");
INSERT INTO nag_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kintu bhabi sabi kun he dangor ase, khabole boha manu na sewa kora manu? Kun khabole bohi ase tai nohoi? Kintu Moi tumikhan majote ekjon noukar nisena ase. ");
INSERT INTO nag_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kintu tumikhan Moi laga porikha te Moi logote ase. ");
INSERT INTO nag_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Moi tumikhan ke di ase jineka Ami laga, Baba pora Moike ekta rajyo dise, ");
INSERT INTO nag_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","etu nisena tumikhan bhi Moi laga rajyote kha luwa koribo, aru tumikhan singhason te bohi kene Israel laga baroh jati uporte bisar koribo. ");
INSERT INTO nag_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aru Jisu pora koise, “Simon, Simon, sabi Saitan he tumike gehu dana nisena chani loise. ");
INSERT INTO nag_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kintu Moi tumi nimite prathana korise, etu pora tumi laga biswas to naharabo; aru tumi, jitia ghurai ahibo, tumi laga biswasi bhai khan ke mojbut koribi.” ");
INSERT INTO nag_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kintu Peter koise, “Probhu, moi Apuni logot jabole taiyar ase, bondhi ghor te bhi aru mori bole bhi.” ");
INSERT INTO nag_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kintu Tai koise, “Moi hosa koise, Peter, murgi hala nakora age te tumi Moike najane koi kene tin bar misa kobo.” ");
INSERT INTO nag_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisu pora chela khan ke koise, “Jitia Moi tumikhan ke poisa laga jola, dorkar laga saman, aru juta noloikena jabole dise, titia kiba napuncha thakise naki?” Taikhan koise, “Eku komti huwa nai.” ");
INSERT INTO nag_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Titia Tai pora taikhan ke koise, “Kintu etiya, kun manu poisa laga jola ase tai loi lobi, aru etu nisena, ki saman laga jola ase, tai loi lobi, aru kun manu logote talwar nai tai nijor kapra bikiri kori kene kini lobi. ");
INSERT INTO nag_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Moi tumikhan ke koi ase, ji kotha Moi nimite Isor kotha te likha ase etu pura hobo lagibo, ‘aru Taike niyom nathaka khan logote ginti kori dise.’ Kelemane ji kotha moi nimite koise etu sob pura hoi ase.” ");
INSERT INTO nag_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aru taikhan koise, “Probhu, sabi! Yate duita talwar ase.” Etu nimite Tai taikhan ke koise, “Etu kafi ase.” ");
INSERT INTO nag_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Aru bahar te ulaikene, adat pora kori thaka nisena, Tai Oliv Pahar te jaise, aru chela khan bhi tai laga pichete jaise. ");
INSERT INTO nag_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jitia taikhan ekta jagate ahise, Tai pora taikhan ke koise, “Prathana koribi tumikhan porikha te nagiribo karone.” ");
INSERT INTO nag_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Titia taikhan pora olop dur te jai kene, Tai matite athukari kene prathana korise, ");
INSERT INTO nag_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","aru koise, “Baba, jodi Apuni itcha kore, etu dukh laga kup to Moi pora hatai dibi. Kintu Ami laga itcha nohoi, Apuni laga itcha hobole dibi.” ");
INSERT INTO nag_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Titia sorgodoth khan ahikena Jisu ke modot korise. ");
INSERT INTO nag_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tai dukh pora prathana kora homoi te Tai laga posina khun hoi kene matite giri thakise. ");
INSERT INTO nag_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aru Jitia Tai prathana kori kene uthise, Tai laga chela khan usorte jaise, aru taikhan mon dukh pora ghumai thaka dikhise, ");
INSERT INTO nag_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","etu nimite Tai pora taikhan ke koise, “Tumikhan kele ghumai ase? Uthibi aru prathana koribi, etu pora tumikhan porikha te nagiribo.” ");
INSERT INTO nag_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aru jitia Tai kotha koi thakise, ta te bisi manu ahi jaise, aru jun laga naam Judas thakise, baroh jon chela majot ekjon, tai age kori kene manu khan ke loi anise. Tai Jisu usorte chuma dibole ahise. ");
INSERT INTO nag_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kintu Jisu taike koise, “Tumi Manu laga Putro ke chuma dikene thogai ase?” ");
INSERT INTO nag_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aru jiman chela khan Jisu usorte khara asele, taikhan ki hobole ase jani jai kene Jisu ke koise, “Probhu, amikhan talwar ulaikene taikhan logote lorai koribo naki?” ");
INSERT INTO nag_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Titia maha purohit laga noukar ke chela ekjon pora dyna kan to kati phelai dise. ");
INSERT INTO nag_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kintu Jisu taikhan ke koise, “Eneka nokoribi!” Aru Jisu he kan wapas lagaikena changai kori dise. ");
INSERT INTO nag_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aru Taike dhori bole aha manu khan, mukhyo purohitkhan, aru mondoli laga henedhikari khan aru cholawta khan ke Tai koise, “Tumikhan talwar aru hathiar khan loi kene ekjon chor manu ke dhura nisena ahise naki? ");
INSERT INTO nag_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Moi jitia mondoli te hodai din tumikhan logote thakise, tumikhan moi uporte hath utha nai. Kintu etiya homoi tumikhan laga ase, aru andhar laga hokti ase.” ");
INSERT INTO nag_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aru taikhan Jisu Khrista ke dhurikena maha purohit laga ghor bhirorte loi jaise. Aru Peter bhi taikhan laga pichete jai thakise. ");
INSERT INTO nag_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Etu pichete taikhan ghor bahar te jui jolai kene eke logote bohise, aru Peter bhi taikhan logot bohi thakise. ");
INSERT INTO nag_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aru ekjon mahila noukar, Peter ke jui usorte bohi thaka dikhi kene koise, “Etu manu bhi Jisu logote thakise.” ");
INSERT INTO nag_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kintu Peter koise nohoi, “Mahila, moi Taike najane.” ");
INSERT INTO nag_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aru olop pichete ekjon pora taike dikhise, aru koise, “Tumi bhi Jisu logote beraise.” Kintu Peter koise, “Bhai moi nohoi.” ");
INSERT INTO nag_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ek ghanta pichete aru ekjon ahikena koise, “Hosa pora, etu manu bhi Tai logote thakise, tai bhi ekjon Galilee laga manu ase.” ");
INSERT INTO nag_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kintu Peter koise, “Bhai, moi najane tumi ki kotha koi ase.” Etu kotha koi thaka homoi te, ekta murga hala korise. ");
INSERT INTO nag_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Titia Jisu ghuri kene Peter ke saise, aru titia Peter Jisu kowa kotha to monte ahise, jitia Jisu koisele, “Tumi tin bar Moike ashikar kobo aru titia murga hala koribo.” ");
INSERT INTO nag_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Titia Peter bahar te jai kene tai laga mon tita hoi kene bisi kandise. ");
INSERT INTO nag_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aru titia sipahi khan Jisu ke biya kotha koi kene mari bole shuru hoise. ");
INSERT INTO nag_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Taikhan Jisu laga suku te kapra bandi kene, koise, “Bhabobani koribi! Kun pora tumike marise koi sabi?” ");
INSERT INTO nag_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aru taikhan bisi bodnam aru biya kotha kori kene Jisu ke sorom khilai se. ");
INSERT INTO nag_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aru jitia din hoise, bura manu khan ahi kene joma hoise, aru mukhyo purohit khan aru niyom likha khan, aru Jisu ke sabha te loi jaise, ");
INSERT INTO nag_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","aru koise, “Jodi tumi Khrista hoi, amikhan ke kobi.” Kintu Tai koise, “Jodi Moi tumikhan ke koi, tumikhan kitia bhi biswas nokorile; ");
INSERT INTO nag_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","aru Moi tumikhan ke hudile, tumikhan kitia bhi Moike jowab dibole na paribo. ");
INSERT INTO nag_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kintu etiya pora Manu laga Putro ke Isor laga dyna hathte bohi thaka dikhibo.” ");
INSERT INTO nag_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Titia taikhan koise, “Etu karone, tumi Isor laga Putro hoi naki?” Aru Tai koise, “Tumikhan he koi ase, Moi nohoi.” ");
INSERT INTO nag_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Taikhan apaste koi thakise, “Amikhan etu kotha age te aru ki janibole gawahi lagi ase? Amikhan tai laga nijor mukh pora etu kotha huni loise.” ");
INSERT INTO nag_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Titia sob manu uthi kene Jisu ke Pilate laga age te anise. ");
INSERT INTO nag_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aru taikhan shuru hoise, aru koise, “Etu manu desh ke biya kori ase, aru Caesar ke saman dibole mana kore, aru tai nijorke Khrista, ekjon raja ase koi.” ");
INSERT INTO nag_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Titia Pilate pora Jisu ke hudise, “Tumi Yehudi manu laga Raja ase naki?” Kintu Tai jawab dise, “Tumi nijor etu koi ase.” ");
INSERT INTO nag_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Titia Pilate pora mukhyo purohit khan aru manu khan ke koise, “Moi etu manu uporte eku golti nadikhe.” ");
INSERT INTO nag_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kintu taikhan etu mana nai aru, koise, “Tai manu khan ke loi kene pura Judea te sikhai kene berai thake, Galilee pora shuru kori kene yate Jerusalem te bhi sikhai.” ");
INSERT INTO nag_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aru jitia Pilate etu hunise, titia tai hudise Jisu to Galilee laga ase naki koi kene. ");
INSERT INTO nag_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jitia tai janise Jisu uporte niyom chola bo nimite Herod laga hathte he adhikar ase, tai Herod usorte Taike pathai dise, Herod tai nijor bhi Jerusalem te thakise. ");
INSERT INTO nag_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aru jitia Herod pora Jisu ke dikhise, tai bisi khushi paise, kelemane tai Jisu ke bisi din pora sabole mon thakise, aru tai Jisu pora kiba ekta asurit chihna kora to sabole mon thakise. ");
INSERT INTO nag_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Titia Herod pora Jisu ke bisi kotha hudise, kintu Tai eku jowab diya nai. ");
INSERT INTO nag_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Titia mukhyo purohit khan aru niyom likha khan age te khara hoise, aru Taike biya bebohar kori kene sorom khilai se. ");
INSERT INTO nag_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Titia Herod aru tai laga sipahi khan bhi milikena Jisu ke bisi ninda korise aru sorom khilai se. Taike raja laga bhal kapra lagai dise, aru Pilate usorte wapas pathai dise. ");
INSERT INTO nag_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Thik etu dinte Pilate aru Herod bhal sathi hoi jaise, kintu olop din age te tai duijon bhitor te kotha namila thakisele. ");
INSERT INTO nag_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Titia Pilate pora mukhyo purohit khan, cholawta khan aru niyom likha khan ke matise, ");
INSERT INTO nag_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","aru taikhan ke koise, “Tumikhan etu manu ke moi logote anise aru koise tai pora manu khan ke phuslai ase, aru tumikhan usorte Ami taike hudise, kintu tumikhan Tai uporte ki arop lagai ase, moi etu manu uporte eku biya dikha nai. ");
INSERT INTO nag_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aru Herod bhi Tai uporte eku golti dikha nai, etu karone tai bhi Jisu ke amikhan logote pathai dise, aru sabi, taike mora laga sajai dibole nimite eneka eku kaam kora nai. ");
INSERT INTO nag_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Etu nimite moi taike sajai dibo, aru chari dibo.” ");
INSERT INTO nag_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kelemane Jerusalem te jitia dangor utsov hoi, niyom pora duijon bhitor te ekjon bondhi ghor te thaka manu ke chari bole lage. ");
INSERT INTO nag_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kintu taikhan sob hala kori kene koise, “Etu, manu ke sajai dibi aru bodli te Barabbas ke chari dibi!” ");
INSERT INTO nag_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","-Barabbas ke bondhi ghor te rakhise kelemane tai manu ke morai disele aru sheher te jhagara ulabole dise.- ");
INSERT INTO nag_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aru Pilate pora manu khan ke aru kotha koise, tai Jisu ke chari bole mon thakise. ");
INSERT INTO nag_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kintu taikhan aru bhi hala kori kene koise, “Cross te morai dibi, Cross te morai dibi.” ");
INSERT INTO nag_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate pora tin bar taikhan logote koise, “Kile, etu manu pora ki biya kaam korise? Moi Tai uporte eku golti dikha nai juntu pora Taike morai dibo lagise. Etu karone Taike sajai dikena chari dibo.” ");
INSERT INTO nag_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Taikhan sob awaj uthaikene khong pora mangise, aru jor pora hala kori thakise Jisu ke Cross te morabo lage koi kene. ");
INSERT INTO nag_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Etu pichete Pilate taikhan laga kotha mani loise. ");
INSERT INTO nag_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barabbas ke bondhi ghor pora ajad kori dise, jun manu ke morai diya aru biya kaam kora ekjon dokait thakise. Kintu Jisu ke taikhan hathte di dise. ");
INSERT INTO nag_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aru Pilate laga ghor pora manu khan Jisu ke bahar te loi jaise, aru ekjon manu Simon, Cyrene sheher pora aha ke dhurikena, tai uporte Cross dikena Jisu pichete te jabo dise. ");
INSERT INTO nag_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Etu homoi te, bhir te manu khan aru maiki khan bisi mon dukh pora Tai usorte kandi thakise, aru Tai laga piche kori thakise. ");
INSERT INTO nag_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisu pora ghurikena taikhan ke koise, “Jerusalem laga mahila khan, Moi nimite nakandibi, kintu tumikhan nijor nimite aru bacha khan nimite kandibi. ");
INSERT INTO nag_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kelemane sabi, eneka din ase jitia taikhan kobo,’ ‘Dhonyo ase bacha nathaka mahila khan aru jun laga pet pora bacha jonom huwa nai, aru dudh khila nai. ");
INSERT INTO nag_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aru taikhan pahar ke kobo, ‘Amikhan uporte giri bhi,’ aru pahar khan girikena ‘amikhan ke bondh kori dibi.’ ");
INSERT INTO nag_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jodi ghas pata khan hara thaka homoi te eneka kore, tenehoile ghas sukhi ja-a somoite ki halat hobo?” ");
INSERT INTO nag_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aru duijon dokait ke Jisu logote loijai kene Cross te morai dise. ");
INSERT INTO nag_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jitia etu jagate ponchise, etu jaga laga naam to “Matha laga Hardi,” mate, taikhan ta te Jisu ke Cross te mari dise, aru duijon dokait ke bhi Jisu laga dyna aru baya phale Cross te mari dise. ");
INSERT INTO nag_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Titia Jisu koise, “Baba, taikhan ke maph kori dibi, taikhan ki korise etu taikhan najane.” Pichete taikhan Jisu laga kapra to chithi kheli kene bhag korise. ");
INSERT INTO nag_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sob manu rukhi kene sai thakise. Aru titia cholawta manu khan Jisu ke sorom khilai kene koise, “Tai dusra ke bachaise. Etiya nijorke bachai lobi, jodi Tai Isor laga Khrista, basi luwa jon to ase koile.” ");
INSERT INTO nag_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sipahi khan bhi Jisu ke sorom khilai se, aru tita pani dise, ");
INSERT INTO nag_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","aru koise, “Apuni jodi Yehudi khan laga raja ase koile, nijorke bachai lobi.” ");
INSERT INTO nag_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tai uporte ekta kotha likhi dise, “Jisu Yehudi khan laga Raja.” ");
INSERT INTO nag_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Titia ekjon dokait Jisu usorte Cross te thaka pora sorom khilai se Jisu ke koise, “Tumi Khrista nohoi naki? Tumi nijorke bachai lobi aru amikhan ke bhi bachai lobi.” ");
INSERT INTO nag_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kintu dusra ekjon pora tai laga sathi ke koise, “Tumi Isor ke bhoi nalage naki, amikhan biya kaam kora nimite nijor sajai pai ase? ");
INSERT INTO nag_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aru etu amikhan pabo lage, amikhan ki biya kaam korise etu hisab te he sajai pai ase. Kintu etu manu eku golti kora nai.” ");
INSERT INTO nag_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Titia tai koise, “Jisu, moike yaad koribi jitia Apuni Paradise te jabo.” ");
INSERT INTO nag_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Titia Jisu taike koise, “Moi hosa koise, tumi aji Ami logote Paradise te thakibo.” ");
INSERT INTO nag_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kintu baroh baji homoi te, achanak etu sob jagate andhera ahi jaise. ");
INSERT INTO nag_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Suryo andhar hoi jaise aru Jerusalem mondoli laga purdah phati jaise. ");
INSERT INTO nag_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Etu pichete jor pora awaj ulaikena Jisu koise, “Baba Apuni laga hathte Moi laga Atma di ase.” Etu koi kene Tai laga saas to chari dise. ");
INSERT INTO nag_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aru jitia henedhikari pora etu dikhise, tai Isor ke mohima dise, aru koise, “Hosa pora Tai ekjon dharmik manu thakise.” ");
INSERT INTO nag_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jiman bhir etu sabole ahise, taikhan ki hoise etu dikhise, aru bisi mon dukh hoi kene nijor chati te marikena jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kintu jun manu Taike bhal pora jane, aru jiman mahila khan Galilee pora Tai logot ahise taikhan dur pora ki hoi ase etu sai thakise. ");
INSERT INTO nag_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Etu homoi te ekjon manu Joseph koi kene jun sabha te ekjon hisa thaka manu asele aru tai bhal aru dharmik manu asele. ");
INSERT INTO nag_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","-Tai sabha laga dusra manu khan logote kotha mila nai.- Tai Arimathea sheher laga Yehudi manu thakise, aru tai bhi Isor laga rajyo ahibole nimite rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tai Pilate, usorte jai kene Jisu laga gaw mangise. ");
INSERT INTO nag_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aru tai Cross pora gaw namaise, aru sapha mihin kapra pora Jisu laga gaw to bandi dise, aru pathor katikena kobor bonai rakha jagate Jisu ke rakhise, jun jagate kitia bhi manu ke rakha nai. ");
INSERT INTO nag_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Titia Jugut Din punchise, aru Bisram din shuru hobole asele. ");
INSERT INTO nag_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aru Galilee pora jiman khan Jisu piche kori thakise, taikhan jai kene kobor ke saise jun jagate Jisu laga gaw rakhise. ");
INSERT INTO nag_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aru mahila khan wapas jai kene mitha sugandh tel aru dawai khan Jisu laga gaw te laga bole nimite jugut korise. Aru taikhan niyom hisab te Bisram din to pobitro rakhikena aram korise. ");
INSERT INTO nag_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Etiya hapta laga poila din te, etu mahila khan kobor usorte ahise, mitha sugandh tel aru dawai jugut kori kene anise. ");
INSERT INTO nag_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kintu taikhan dikhise kobor bondh kori kene rakha pathor to hataikena ase, ");
INSERT INTO nag_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","kintu taikhan bhitor te jai kene Probhu Jisu laga gaw to dikha nai. ");
INSERT INTO nag_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aru eneka hoise, jitia kobor te Jisu laga gaw dikha nai, taikhan asurit hoise. Aru achanak pora, duijon manu boga kapra lagai kene taikhan usorte khara hoise. ");
INSERT INTO nag_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aru, mahila khan bhoi lagikena matha niche kori kene matite girise, etu manu khan pora mahila khan ke hudise, “Tumikhan jinda manu ke mora khan majote kele bisari ase? ");
INSERT INTO nag_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tai yate nai, kintu jinda hoise! Yaad koribi kineka Tai tumikhan ke koisele Galilee te thaka homoi te, ");
INSERT INTO nag_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","koisele Manu laga Putro kineka paapi manu hathte di dibo aru Taike Cross te morai dibo, aru tin dinte Tai aru bhi jinda hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Titia mahila khan Jisu laga kotha monte yaad ahise, ");
INSERT INTO nag_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","aru jitia kobor pora wapas jaise, taikhan jai kene egaroh jon chela aru sob manu khan ke khobor di dise. ");
INSERT INTO nag_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aru Mary Magdalene, Joanna, aru Mary James laga ama aru mahila khan jai kene chela khan ke khobor di dise. ");
INSERT INTO nag_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kintu etu khobor to chela khan misa bhabise, aru mahila khan kowa kotha to biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hoile bhi Peter to uthi kene, Jisu laga kobor te polaikene jaise, aru usor pora saise aru khali Jisu ke bandi rakha mihin kapra he dikhise. Aru tai bahar te ulaikena ki hoise etu bhabise. ");
INSERT INTO nag_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aru ek din, duijon manu ekta bosti te jai thakise. Jerusalem pora sath mil dur thaka Emmaus bosti te. ");
INSERT INTO nag_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Etu din khan te ki hoise eitu khan sob laga kotha khan koi kene jai thakise. ");
INSERT INTO nag_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aru eneka hoise, taikhan kotha patikena jai thaka homoi te, Jisu taikhan usorte achanak pora ahi kene taikhan eke logote jai thakise. ");
INSERT INTO nag_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kintu taikhan suku pora Jisu ke chini bole para nai. ");
INSERT INTO nag_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Titia Jisu taikhan ke hudise, “Tumikhan ki kotha patikena mon dukh pora jai ase?” Taikhan khara hoi jaise, mon dukh pora. ");
INSERT INTO nag_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kintu ekjon Cleopas pora Jisu ke hudise, “Apuni Jerusalem te ekla ahise naki aru ki hoise etu najane?” ");
INSERT INTO nag_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Titia Jisu taikhan ke hudise, “Yate ki hoise?” Taikhan koise, “Nazareth Jisu laga kotha, kun ekjon manu thakise, aru asurit kaam aru kotha para Isor usorte aru sob manu nimite Tai ekjon dangor bhabobadi thakise, ");
INSERT INTO nag_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aru mukhyo purohit khan aru cholawta khan pora Taike dhorise aru bodnam kori kene Cross te morai dise. ");
INSERT INTO nag_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kintu moi khan biswas kori thakise Tai he Israel manu ke mukti dibo. Kintu etu sob pura hoi kene, aji tin din hoi jaise. ");
INSERT INTO nag_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kintu kunba mahila khan kobor te joldi jai kene, amikhan ke ahi kene asurit kotha koise. ");
INSERT INTO nag_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Aru taikhan Jisu laga gaw to kobor bhitor te dikha nai, taikhan sorgodoth khan ke darshan korise koise aru Jisu jinda ase koise. ");
INSERT INTO nag_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kintu amikhan logote thaka kunba kobor sabole jaise aru jineka mahila khan pora koise eneka he dikhise, kintu Jisu ke ta te dikha nai.” ");
INSERT INTO nag_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Titia Jisu taikhan ke koise, “O murkho aru mon chutu kori thaka khan jun khan bhabobadi khan pora ki koise etu sobke biswas kore! ");
INSERT INTO nag_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Etu dorkar thaka nai naki Khrista dukh paikena, aru bhi Isor laga mohima te huma bole?” ");
INSERT INTO nag_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Moses pora suru kori kene aru kiman bhabobadi khan thakise, taikhan ke ki pobitro kotha te Tai nimite likha ase etu bujhi bole dise. ");
INSERT INTO nag_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Taikhan jabole thaka bosti te ponchise, aru Jisu age te jabo nisena korise. ");
INSERT INTO nag_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kintu taikhan pora Taike anurodh kori kene koise, “Amikhan logote thakibi, aji laga din to khotom hobole hoise.” Aru Jisu taikhan logote thaki bole jaise. ");
INSERT INTO nag_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aru eneka hoise, jitia taikhan eke logote bohise, Tai roti loise, aru asirbad korise, aru bhangi kene taikhan ke dise. ");
INSERT INTO nag_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Titia taikhan laga suku khuli se, aru taikhan Taike chini paise, aru Jisu taikhan usor pora Atma hoi kene jai jaise. ");
INSERT INTO nag_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Taikhan ekjon-ekjon logote kotha patise, “Moi khan laga mon to joli thaka nai naki, jitia Tai amikhan logote ahi thakise, aru jitia Isor laga kotha to puri kene hunai sile?” ");
INSERT INTO nag_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Etu homoi te taikhan uthise, aru Jerusalem te wapas jaise. Egaroh chela khan eke logote joma hoi thakise, aru dusra khan bhi eke logote thakise. ");
INSERT INTO nag_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aru koise, “Hosa pora Probhu jinda hoise, aru Simon usorte ahise.” ");
INSERT INTO nag_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Titia rasta te ki hoise etu sob taikhan ke koi dise, kineka Jisu amikhan ke dikhai dise jitia Tai roti bhangise. ");
INSERT INTO nag_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jitia taikhan etu kotha khan koi thakise, Jisu taikhan majote ahikena khara hoi kene koise, “Tumikhan uporte shanti thakibi.” ");
INSERT INTO nag_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kintu taikhan asurit hoise, aru bisi bhoi lagise, taikhan bhabise ekjon bhoot taikhan laga usorte ahise. ");
INSERT INTO nag_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Titia Jisu taikhan ke koise, “Tumikhan kele bhoi lagise, aru kele monte alag bhabona kori ase? ");
INSERT INTO nag_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ami laga hath aru theng to sabi, etu Moi he ase. Moike chui kene sabi kele atma to mangso aru hardi nathake, kintu Moi logot eitu khan thaka tumikhan dikhi ase.” ");
INSERT INTO nag_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jitia Tai etu kotha koise, Tai laga hath aru theng taikhan ke dikhai dise. ");
INSERT INTO nag_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aru etu homoi te taikhan bisi asurit aru khushi pora biswas nakora nisena hoi jaise, Tai aru taikhan ke koise, “Tumikhan logote kiba khabole ase naki?” ");
INSERT INTO nag_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Titia taikhan Jisu ke jolai rakha maas khabole dise, ");
INSERT INTO nag_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","aru taikhan usorte Jisu etu loi kene khaise. ");
INSERT INTO nag_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Titia tai koise, “Etu Ami laga kotha ase, Ami jinda thaka homoi te tumikhan ke ki koisele, Moses laga kitab te aru bhabobadi khan aru Bhajan Geet te Ami nimite ki likha ase, etu sob pura hobo lage.” ");
INSERT INTO nag_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Titia Isor laga kotha bujhi bole taikhan laga dimag khuli dise, etu pichete Jisu taikhan ke koise, ");
INSERT INTO nag_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Etu nimite Isor kotha te eneka likha ase: Khrista dukh pabo, aru mora pora tin dinte jee uthibo; ");
INSERT INTO nag_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","aru mon ghura bole aru paap pora khyama pabole sob desh te prochar koribo, Jerusalem pora shuru hobo. ");
INSERT INTO nag_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tumikhan etu sob laga gawahi hobo. ");
INSERT INTO nag_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Moi tumikhan ke Baba pora ki kosom dise, etu te pathai ase. Kintu tumikhan Jerusalem chari kene najabi jitia tak sorgo laga takot tumikhan uporte nahe.” ");
INSERT INTO nag_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aru Jisu taikhan ke olop dur Bethany te loi jaise, aru Tai laga hath uthaikene, taikhan ke asirbad korise. ");
INSERT INTO nag_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Etiya eneka hoise, jitia Tai pora taikhan ke asirbad kori thakise, etu somoite badal ahikena Jisu ke uthaikene sorgote loi jaise. ");
INSERT INTO nag_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Taikhan Jisu ke mohima kori thakise, aru khushi anondo pora Jerusalem te wapas jaise, ");
INSERT INTO nag_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","aru taikhan mondoli te jai kene Isor ke dhanyavad aru aradhana kori thakise.");
INSERT INTO nag_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Shuru te Kotha asele, aru Kotha to Isor logote thakise, aru Kotha he Isor ase. ");
INSERT INTO nag_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Etu shuru pora Isor logote he thakise. ");
INSERT INTO nag_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sob jinis Tai pora he bonaise, aru ki bonaise Tai nathaki kene eku bhi bona nai. ");
INSERT INTO nag_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tai logote jibon asele, aru jibon to manu khan laga pohor asele. ");
INSERT INTO nag_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aru pohor to andhera te ujala korise, aru andhera to pohor ke jitibo para nai. ");
INSERT INTO nag_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Isor pora pathai diya ekjon manu asele, jun laga naam John thakise. ");
INSERT INTO nag_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tai gawahi hoi ahise, pohor laga kotha jonai dibole, aru sob Tai dwara biswas kori bole. ");
INSERT INTO nag_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","John nijor to pohor nohoi, kintu tai pohor laga gawahi dibole ahise. ");
INSERT INTO nag_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sob manu ke pohor dibole asol pohor duniya te ahi thakise. ");
INSERT INTO nag_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tai duniya te thakisele, aru Tai he duniya bonaise, kintu duniya pora Taike janibo para nai. ");
INSERT INTO nag_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tai nijor manu khan majote ahise, kintu Tai nijor manu khan pora Taike luwa nai. ");
INSERT INTO nag_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kintu jiman jon pora Taike grohon korise, Tai he taikhan ke Isor laga bacha hobole adhikar dise, jun Tai naam pora biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Taikhan jonom to khun pora bhi nohoi, mangso pora bhi nohoi, aru mangso itcha pora bhi nohoi, kintu Isor laga itcha pora ase. ");
INSERT INTO nag_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aru Kotha to gaw mangso hoi kene amikhan majote thakise. Amikhan Tai laga mohima dikhise, eneka mohima juntu Baba pora tai laga ekjon morom thaka Putro ke dise, aru etu anugraha aru hosa pora bhorta ase. ");
INSERT INTO nag_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John pora Tai laga gawahi dikene eneka koise, “Etu he ekjon ase Jun nimite moi koise, ‘Jun moi laga piche ahi ase, Tai to moi pora bhi bisi dangor ase, kelemane moi laga age pora Tai thakise.’” ");
INSERT INTO nag_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Aru Tai bhorta hoi thaka pora amikhan anugraha uporte anugraha paise. ");
INSERT INTO nag_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kelemane niyom to Moses dwara anidise. Kintu anugraha aru hosa to Jisu Khrista pora he anise. ");
INSERT INTO nag_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Isor ke kun bhi kitia bhi dikha nai. Ekjon Isor, jun Baba laga usorte bohi ase, etu ke he Tai dikhai dise. ");
INSERT INTO nag_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","John laga gawahi etu ase, Yehudi khan Jerusalem sheher pora Levi dol laga purohit khan ke pathaise taike hudibole, “Apuni kun ase?” ");
INSERT INTO nag_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tai shikar kori kene koise- “Moi Khrista nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aru taikhan hudise, “Nohoile apuni kun ase? Apuni Elijah ase?” Tai koise, “Moi nohoi.” Taikhan koise, “Apuni bhabobadi ase?” Aru tai jawab dise, “Nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Arubi taikhan taike hudise, “Apuni kun ase? Kilekoile amikhan ke pathai diya khan ke jowab dibo lage. Apuni nijorke kun ase koi?” ");
INSERT INTO nag_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tai koise, “Ami ekta awaj ase, juntu jongol te hala kori koi ase: ‘Probhu laga rasta sidha koribi,’ Jineka bhabobadi Isaiah pora likhise.” ");
INSERT INTO nag_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aru ta te Pharisee khan pora kunba manu khan ke pathaise. ");
INSERT INTO nag_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aru taikhan taike hudise, “Jodi apuni Khrista nohoi, Elijah bhi nohoi, aru bhabobadi bhi nohoi, to kele apuni baptizma di ase?” ");
INSERT INTO nag_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John taikhan ke jawab dise aru koise, “Moi pani pora baptizma di thaka he ase. Kintu tumikhan majote ekjon khara ase, Junke tumikhan najane. ");
INSERT INTO nag_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jun moi pichete ahi ase moi Tai laga juta laga rusi bhi khuli bole layak manu nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Etu sob to Jordan nodi laga dusra phale thaka Bethany te hoise, kun to jagate John baptizma di thakise. ");
INSERT INTO nag_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Dusra dinte Jisu tai logote ahi thaka dikhikena John koise, “Sabi, Isor laga Mer bacha, kun pora etu duniya laga paap uthai loi jabole ase! ");
INSERT INTO nag_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Etu he ase, Kun laga kotha moi age pora koi dise, ‘Ekjon ami laga piche ahi ase, Jun he moi pora bhi dangor ase, kelemane moi pora poila Tai thakisele.’ ");
INSERT INTO nag_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Moi bhi Taike najane. Kintu Israel manu khan logot Taike prokahit kori dibo karone moi pani pora baptizma di ahise.” ");
INSERT INTO nag_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Aru John etu gawahi dikene koise, “Atma he paro nisena sorgo pora ahikena Tai uporte bohi juwa moi dikhise. ");
INSERT INTO nag_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Moi Taike najane kintu Jun he moike pani pora baptizma dibole pathaise, Tai he moike koise, ‘Jun uporte Atma ahi thaki juwa tumi dikhibo, Tai he Pobitro Atma pora baptizma dibo thaka to ase.’ ");
INSERT INTO nag_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aru moi etu dikhi kene gawahi di ase, etu he Isor laga Putro ase.” ");
INSERT INTO nag_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Dusra dinte John pora tai laga duijon chela ke loi kene khara thakise. ");
INSERT INTO nag_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Titia Jisu berai kene aha dikhi kene tai koise, “Sabi, Isor laga Mer bacha!” ");
INSERT INTO nag_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Titia duijon chela etu huni kene Jisu laga piche korise. ");
INSERT INTO nag_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Titia Jisu ghuri saise aru tai duijon ke dikhi kene hudise, “Tumikhan ke ki lage?” Taikhan koise, “Rabbi, Apuni kot te thaki ase? - Etu motlob to Shika manu- Apuni kot te thake?” ");
INSERT INTO nag_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tai koise, “Ahi kene sabi.” Taikhan jai kene Tai kot te thaki ase etu dikhise, aru etu din Tai logote thaki jaise, aru etu somoi to dos ghanta nisena asele. ");
INSERT INTO nag_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Duijon majote kun John laga kotha huni kene Jisu logote jaise, etu ekjon to Simon Peter laga bhai Andrew thakise. ");
INSERT INTO nag_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tai Simon ke bisari kene koise, “Amikhan Messiah ke pai loise,” motlob ase Khrista. ");
INSERT INTO nag_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aru taike loi kene Jisu logot anise, aru Jisu taike saikene koise, “O Jonah laga Putro Simon, tumike Kefa matibo” - dusra naam ase Peter. ");
INSERT INTO nag_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dusra din Jisu to Galilee jagate jabole mon thakise, titia Tai Philip ke lok paise aru taike koise, “Ami laga piche koribi.” ");
INSERT INTO nag_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip to Bethsaida nogor laga manu asele, juntu sheher to Andrew aru Peter laga sheher asele. ");
INSERT INTO nag_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jitia Philip pora Nathaniel ke paise, tai koise, “Moses laga kitab te aru bhabobadi khan he jun laga kotha likhi rakhise, etu amikhan pai loise: etu Joseph laga chokra Nazareth Jisu he ase.” ");
INSERT INTO nag_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kintu Nathaniel taike koise, “Bhal bostu Nazareth pora ulabo naki?” Philip pora taike koise, “Ahibi aru sabi.” ");
INSERT INTO nag_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Titia Jisu pora Nathaniel Tai phale aha dikhi kene koise, “Sabi, etu hosa te Israel manu ase, tai thogai diya manu nohoi!” ");
INSERT INTO nag_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathaniel Taike koise, “Apuni moike kineka jane?” Jisu taike jowab di koise, “Philip pora tumike mata age te tumi dimoru ghas niche bohi thaka Moi dikhise.” ");
INSERT INTO nag_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathaniel Taike jowab dise, “Rabbi, Apuni Isor laga Chora ase! Apuni Israel laga Raja ase!” ");
INSERT INTO nag_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisu jowab te taike koise, “kelemane Moi tumike koise, ‘Moi Tumike dimoru ghas nichete bohi thaka dikhise’ kowa karone tumi biswas korise? Tumi etu pora bhi bisi dangor kaam dikhibo.” ");
INSERT INTO nag_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aru Jisu taike koise, “Hosa pora Moi tumikhan ke kobo, tumikhan sorgo khuli diya, aru Isor laga duth khan pora Manu laga Putro uporte aha juwa kora dikhibo.” ");
INSERT INTO nag_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tin din pichete, ta te shadi thakise, Cana nogor laga Galilee te, aru Jisu laga ama bhi ta te thakise. ");
INSERT INTO nag_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aru etu shadi te Jisu aru Tai chela khan ke bhi matise. ");
INSERT INTO nag_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jitia draikha ros khotom hoise, Tai ama pora Taike koise, “Taikhan logote draikha ros aru nathaka hoise.” ");
INSERT INTO nag_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kintu Jisu taike koise, “Mahila, Moi nimite aru tumi nimite etu ki ase? Ami laga somoi puncha nai.” ");
INSERT INTO nag_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tai ama pora nokorkhan ke koise “Ki hoile bhi Tai tumikhan ke koribi kobo, etu he koribi.” ");
INSERT INTO nag_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Titia pathor pora bona choita pani kolsi Yehudi khan laga niyom hisab te dhulai thaka ekta jagate rakhi thakise, ekta kolsi to dui-tin metre nisena lamba thakise. ");
INSERT INTO nag_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisu taikhan ke koise, “Kolsi te pani bhorai dibi.” Taikhan eneka bhorai dise. ");
INSERT INTO nag_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aru Tai nokorkhan ke koise, “Etu olop ulai lobi aru loijai kene kha luwa saithaka manu ke dibi.” Aru taikhan eneka korise. ");
INSERT INTO nag_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Titia kha luwa sa manu pora etu pani ke khai saise jun to draikha ros hoise, hoilebi etu kot pora ahise jana nai, kintu nokorkhan jun he pani anidise taikhan to jani thakise, aru kha luwa sa manu shadi koribo thaka mota ke matise. ");
INSERT INTO nag_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Aru koise, “Sob manu prothom te bhal draikha ros diye, aru jitia bhal to khai loi kene nisa hoijai etu pichete he sosta laga draikha ros diye, kintu apuni to bhal ros etiya tak bhi rakhi ase.” ");
INSERT INTO nag_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisu pora Galilee laga Cana te etu prothom chihna kori kene Tai nijor mohima dikhai dise, aru chela khan Taike biswas korise. ");
INSERT INTO nag_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Etu pichete Tai laga ama aru bhai aru chela khan ke loi kene Capernaum te namise, aru ta te taikhan olop din thakise. ");
INSERT INTO nag_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yehudi khan laga Nistar din usor ahi thakise, aru Jisu Jerusalem te jaise. ");
INSERT INTO nag_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aru mondoli bhitor te bail guru aru mer khan aru kabotar bikiri kori kene toka-poisa bodla-bodli kori thaka paise. ");
INSERT INTO nag_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aru Tai ekta chabuk bonai kene mondoli pora bail guru aru mer khan sob bahar te khedai dise, aru toka-poisa bodla-bodli kori thaka khan laga poisa sob phelai dise, aru taikhan laga mez bhi ultai dise. ");
INSERT INTO nag_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aru Tai paro bikiri kori thaka khan ke koise, “Tumikhan etu sob yate pora loijabi. Ami laga Baba laga ghor ke bajar jaga nabona bhi.” ");
INSERT INTO nag_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Titia Tai laga chela khan yaad ahise ki likha asele, “Tumi laga ghor nimite josh pora he moike khotom koribo.” ");
INSERT INTO nag_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Titia Yehudi cholawta khan Taike koise, “Apuni ki chihna amikhan ke dikha bo, kele koile Apuni etu kaam khan kori ase?” ");
INSERT INTO nag_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisu taikhan ke jowab di koise, “Etu mondoli ke khotom kori dibi, aru Moi etu ke tin dinte aru khara kori dibo.” ");
INSERT INTO nag_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Titia Yehudi khan laga cholawta khan koise, “Etu mondoli bona bole chheyalis saal lagise, aru Apuni tin dinte etu khara kori dibo?” ");
INSERT INTO nag_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kintu, Tai nijor gaw laga mondoli koi thakise. ");
INSERT INTO nag_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Karone, jitia Tai mora pora punoruthan hoise, Tai chela khan yaad ahise, ki Tai etu taikhan ke koise, aru Jisu taikhan ke kowa kotha ke bhi aru shastro kitab ke bhi biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jitia Tai Nistar purbb somoite Jerusalem te ahise, bisi manu Tai kori diya asurit kaam ke dikhi kene Tai naam pora biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kintu Jisu Tai nijor pora taikhan ke biswas kora nai kelemane Tai taikhan sobke jani asele, ");
INSERT INTO nag_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","aru kunbi manu laga gawahi Taike kobo nalage kelemane manu bhithor te ki ase sob Tai jane. ");
INSERT INTO nag_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pharisee khan majote ekjon Yehudi cholawta thakise, jun laga naam Nicodemus asele. ");
INSERT INTO nag_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tai rati te Jisu logote ahi Taike hudi kene koise, “Rabbi amikhan jane Apuni Isor pora aha ekjon hikhok ase, kelemane Isor Tai logote nathakile kunbi Apuni pora chihna dikhai diya khan koribo na paribo.” ");
INSERT INTO nag_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisu taike jowab di koise, “Moi hosa pora tumikhan ke koi ase, jodi kun bhi notun jonom noloile, Tai Isor laga rajyo dikhi napabo.” ");
INSERT INTO nag_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus Taike koise, “Ekjon manu, bura huwa pichete aru kineka jonom lobo paribo? Tai kineka nijor ama pet te dusra bar ghusi kene jonom lobo?” ");
INSERT INTO nag_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisu jowab dise, “Moi hosa pora tumikhan ke koi ase, jitia tak ekjon pani aru Atma pora jonom nolobo, tai Isor rajyote ghusi bona paribo. ");
INSERT INTO nag_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jun mangso pora jonom hoise, etu mangso ase, aru jun Atma pora jonom hoise etu Atma ase. ");
INSERT INTO nag_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Moi ‘tumikhan notun jonom lobo lage’ kowa karone asurit nohobi. ");
INSERT INTO nag_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hawa jun phale jabole mon ase, ta te jai thake, aru tumi etu awaj huni thake, kintu etu kot pora ahise aru kot phale jabole ase etu najane, etu karone jun Atma pora jonom hoise, tineka he ase.” ");
INSERT INTO nag_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus jowab dikena Taike koise, “Etu kineka hobo paribo?” ");
INSERT INTO nag_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisu taike jowab dise, “Tumi Yehudi laga hikhok hoi kene bhi etu kotha bujhi bo napare? ");
INSERT INTO nag_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Moi tumike hosa kobo, Amikhan ki jane etu he koi, aru ki dikhise etu gawahi diye, kintu tumikhan Ami laga gawahi lobo napare. ");
INSERT INTO nag_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jitia Moi tumikhan ke duniya laga kotha koise, aru tumikhan biswas kora nai, jodi Moi sorgo laga kotha koile tumikhan biswas koribo? ");
INSERT INTO nag_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aru kun bhi sorgote juwa nai, ekla Jun he sorgo pora ahise- Manu laga Putro. ");
INSERT INTO nag_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Aru jineka Moses pora jongol te saph ke upor uthai dise, tineka Manu laga Putro ke bhi uporte uthabo lagibo. ");
INSERT INTO nag_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Etu nimite jun Taike biswas koribo, nost nohobo kintu anonto jibon pabo. ");
INSERT INTO nag_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kelemane Isor duniya ke eneka morom korise, Tai nijor laga ekjon he thaka Putro ke di dise, tinehoile jun Taike biswas koribo, khotom nahobo, kintu anondo jibon pabo. ");
INSERT INTO nag_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kelemane Isor duniya ke khotom kori bole nijor Putro ke patha nohoi, kintu etu karone ase, Tai karone he duniya bachibole. ");
INSERT INTO nag_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jun Taike biswas koribo taike eku golti nadibo, kintu jun Taike biswas nakoribo, etu ke golti kori dibo, kelemane Tai Isor laga ekjon thaka Putro laga naam te biswas nakora hoise. ");
INSERT INTO nag_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Aru golti karone bisar to etu ase, puhor to duniya te ahise, kintu manu to puhor pora bhi andhera ke bisi morom kore, kelemane taikhan laga kaam biya ase. ");
INSERT INTO nag_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jun biya kaam kore, tai puhor ke ghin kore, aru puhor usorte na ahe, tai ki kaam korise etu ke khuli dikhi najabo nimite. ");
INSERT INTO nag_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kintu jun hosa te thake, taikhan to Isor laga itcha pora he kori ase koi kene dikhai dibo karone puhor usorte ahe.” ");
INSERT INTO nag_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Etu pichete Jisu aru Tai chela aru Judea desh te jai jaise, aru Tai ta te taikhan logote thaki kene baptizma di thakise. ");
INSERT INTO nag_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aru John bhi Salim usor Aenon te baptizma di thakise, kelemane ta te bisi pani thaka karone, aru taikhan ahi baptizma loi thakise. ");
INSERT INTO nag_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aru etu somoi tak te John ke bondhi ghor te loi janai. ");
INSERT INTO nag_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ta te John laga chela khan Yehudi manu ekjon logote Yehudi khan sapha kora niyom laga kotha nimite mon namili kene thakise. ");
INSERT INTO nag_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aru taikhan John logote ahi taike koise, “Rabbi, jun Jordan nodi paar te apuni logote thakise, jun nimite apuni kotha koi dise, sabi, etu manu baptizma di thakise, aru sob Tai logote ahijai ase.” ");
INSERT INTO nag_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John jowab dise aru koise, “Sorgo pora manu ke nadile, tai ekubi napabo. ");
INSERT INTO nag_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Apuni khan nijor ami laga gawahi dibo pare kele koile moi age te pora he koi dise, ‘Moi Khrista nohoi’ kintu ‘Tai laga age te pathai diya he ase.’ ");
INSERT INTO nag_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jun logote shadi kora maiki ase tai he shadi kora mota ase. Aru shadi kora mota laga sathi khan pora tai usorte khara koribo aru tai laga awaj huni kene bisi khushi pabo, etu nisena ami laga khushi bhi etu pora pura hobo. ");
INSERT INTO nag_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jisu he dangor hoi jabo lage, kintu moi komti hoi jabo lage. ");
INSERT INTO nag_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jun upor pora ahise, etu he sob laga upor ase. Jun prithibi pora ahise etu prithibi laga ase, aru prithibi laga kotha koi thake. Jun sorgo pora ase, tai he sob laga upor ase. ");
INSERT INTO nag_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Aru Tai ki dikhise aru hunise etu laga gawahi dise, kintu kunbi Tai laga gawahi ke grohon kora nai. ");
INSERT INTO nag_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jun Tai koi thaka grohon kori loi, etu manu to Isor hosa ase koi kene jani loise. ");
INSERT INTO nag_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kelemane kunke Isor pathai, tai he Isor laga kotha khan koi diye. Kelemane Tai Atma ke napikena nadiye. ");
INSERT INTO nag_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baba pora Putro ke morom kore, aru sob bostu Tai hathte di dise. ");
INSERT INTO nag_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jun Putro ke biswas korise anondo jibon tai laga hoise, kintu jun Putro ke biswas nakore, tai to jibon nadikhibo, kintu Isor laga khong tai uporte thaki jabo.” ");
INSERT INTO nag_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aru jitia Jisu jani loise Pharisee khan pora Tai he John pora bhi bisi manu ke baptizma dikene chela bonai loise koi kene, ");
INSERT INTO nag_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","- kintu Jisu pora nohoi kene Tai laga chela khan he baptizma di thakise- ");
INSERT INTO nag_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Titia Tai Judea desh chari kene Galilee jaga phale jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kintu Tai Samaria jaga paar kori kene jabo dorkar thakise. ");
INSERT INTO nag_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Karone Tai Samaria laga nogor, Sychar te ahise, etu jaga to Jacob pora tai laga chokra Joseph ke diya jaga usorte thakise. ");
INSERT INTO nag_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ta te Jacob laga kuha bhi thakise. Aru Jisu safar kora pora hairan koi kene etu kuha usorte bohi jaise, aru etu somoi baroh baji nisena asele. ");
INSERT INTO nag_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Titia ekjon Samaria laga mahila pani lobole ahise, aru Jisu taike koise, “Moike pani khila bhi.” ");
INSERT INTO nag_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Etu homoi te Tai chela khan to kha luwa kini bole nogor te jai kene asele. ");
INSERT INTO nag_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Titia Samaria laga mahila Taike koise, “Kineka Apuni Yehudi hoi kene moi Samaria mahila ke pani khila bhi koi kene mangi ase?” Kelemane Yehudi khan Samaria manu khan logote eku bhi lenden nakore. ");
INSERT INTO nag_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisu taike jowab di koise, “Jodi tumi Isor laga daan ke janile, aru kun pora tumike koi ase, ‘Moike pani khila bhi,’ titia tumi Tai logote mangibo, aru Tai tumike jibon laga pani dibole asele.” ");
INSERT INTO nag_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mahila pora Taike koise, “Sahab, Apuni logote pani ulabole baltin nai, aru kuha bhi ghalta ase. To jibon pani kot pora Apuni logote ase? ");
INSERT INTO nag_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kile, Apuni to amikhan laga baba Jacob pora bhi dangor ase naki, jun he etu kuha amikhan ke dise? Aru tai nijor bacha khan aru nijor pala janwar sob etu te khabole dise?” ");
INSERT INTO nag_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisu taike jowab di koise, “Jun bhi etu pani khabo aru bhi pyaas lagi jabo, ");
INSERT INTO nag_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kintu jun bhi etu pani khabo jun to Moi pora dibo, tai kitia bhi aru pyaas nalagibo. Kintu junke Moi pani dibo tai karone ekta dhara hoi anonto jibon tak bahi thaki jabo.” ");
INSERT INTO nag_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Etu mahila Taike koise, “Sahab, moi aru pyaas nalagibole aru pani lobole iman dur nahibole etu pani moike dibi.” ");
INSERT INTO nag_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisu taike koise, “Jabi, aru tumi laga mota ke yate loi anibi.” ");
INSERT INTO nag_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Etu mahila koise, “Moi laga mota nai.” Jisu taike koise, “Tumi ‘moi laga mota nai’ kowa to thik koise.” ");
INSERT INTO nag_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kelemane tumi pans-ta mota thakisele, aru etiya jun logote tumi thaki ase etu bhi tumi laga mota nohoi kowa, tumi hosa koise.” ");
INSERT INTO nag_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aru mahila pora Taike koise, “Sahab, moi janise Apuni ekjon bhabobadi ase.” ");
INSERT INTO nag_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ami laga baba khan etu porbot pora aradhana kori thakise, aru Apuni koi ase manu khan aradhana kori bole jaga to Jerusalem he hoi.” ");
INSERT INTO nag_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisu taike koise, “O mahila, Ami laga kotha biswas koribi, tumikhan etu porbot te bhi aru Jerusalem sheher te bhi Baba ke aradhana kori bole napara somoi ahi ase. ");
INSERT INTO nag_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tumikhan najana ke aradhana kore, amikhan to junke aradhana kore jani kene kore, kelemane poritran to Yehudi pora ase. ");
INSERT INTO nag_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kintu somoi ahi ase, aru etiya ahise, hosa te aradhana kora khan atma pora Isor ke aradhana hobo lage, Baba eneka khan ke he bisare, jun atma te aradhana kore. ");
INSERT INTO nag_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Isor to Atma ase, aru kun Taike aradhana koribo atma aru hosa te aradhana koribo lage.” ");
INSERT INTO nag_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Etu maiki Taike koise, “Moi jani ase Massiha ahibo kotha to, junke Khrista koi, jitia Tai ahibo, Tai sob kotha amikhan ke koi dibo.” ");
INSERT INTO nag_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisu taike koise, “Moi he tai ase, ekjon tumi logote kotha kori ase.” ");
INSERT INTO nag_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Titia Tai laga chela khan Tai kunba mahila logote kotha kora dikhi kene asurit hoise, kintu kun bhi Tai ki lage aru kele Jisu tai logot te kotha kori ase koi kene huda nai. ");
INSERT INTO nag_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aru tai laga pani daba chari kene, etu mahila nogor te dauri jaise, aru manu khan ke koise. ");
INSERT INTO nag_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ahibi aru ekjon ke sabi, moi ki korise etu sob Tai koi dise, etu Khrista kowa to nohoi na?” ");
INSERT INTO nag_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Karone taikhan town pora ulaikene Tai logote ahise. ");
INSERT INTO nag_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Etu somoite Tai chela khan Taike koise, “Rabbi, kiba khabi.” ");
INSERT INTO nag_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kintu Tai taikhan ke koise, “Tumikhan najana kiba kha luwa Ami logote ase.” ");
INSERT INTO nag_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Titia chela khan apaste kotha korise, “Kunba pora khabole kiba Taike dise na, diya nai?” ");
INSERT INTO nag_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisu taikhan ke koise, “Ami laga kha luwa to Moike pathai diya laga itcha ke pura kori diya to he ase. ");
INSERT INTO nag_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kile tumikhan nokoi, ‘Kati bole aru bhi char mohina baki ase’? Sabi, Moi tumikhan ke koi ase, suku uthaikene kheti ke sabi, eitu khan kati bole paaki kene boga hoi jaise! ");
INSERT INTO nag_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aru jun dhaan katikena nijor mojdur pabo, aru phol khan sob joma kori kene anonto jibon karone rakhidibo, titia jun manu bijon hissi dise aru jun dhaan katise, tai duijon mili anondo kori thaki jabo. ");
INSERT INTO nag_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kelemane, ‘Ekjon bijon hissi dise, aru dusra kati thake’ kowa kotha to hosa ase. ");
INSERT INTO nag_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tumikhan pora hissi kene narakha jagate kati bole Moi tumikhan ke pathai ase. Dusra khan pora hissi dise, aru tumikhan to taikhan laga kaam ke bhag luwa he ase.” ");
INSERT INTO nag_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aru etu sheher te thaka Samaria manu khan Taike biswas kori loise, kelemane etu mahila he eneka koise, “Moi age te ki korise sob Tai moike koi dise.” ");
INSERT INTO nag_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Karone jitia Samaria manu khan Tai logote ahise, taikhan pora Taike arubi taikhan logote thakibi koi kene binti korise, etu pora Tai ta te dui din rukhi jaise. ");
INSERT INTO nag_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aru Tai kotha pora bisi manu biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Titia taikhan etu mahila ke koise, “Etiya to amikhan apuni kowa karone nohoi, kintu amikhan nijor kaan pora Taike huni loise, aru jani loise, Tai he hosa ase, duniya laga Tran-Korta ase.” ");
INSERT INTO nag_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Aru dui din pichete Tai ta te pora Galilee jagate jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kelemane Jisu Tai nijor koisele, ekjon bhabobadi tai nijor desh te hoile sonman napai. ");
INSERT INTO nag_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jitia Tai Galilee te ahise, Galilee manu khan pora Taike khushi paikena grohon korise, ki kaam Tai purbb somoite Jerusalem te korise, taikhan etu sob dikhise kele koile taikhan bhi purbb te jaisele. ");
INSERT INTO nag_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Titia Tai aru Galilee te thaka Cana te ahise, kot te Tai pani pora draikha-ros bonai disele. Ta te ekjon daruga laga chokra Capernaum te bemar thakisele. ");
INSERT INTO nag_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jitia Jisu Judea pora Galilee te ahi ahise koi kene tai hunise, tai binti loi kene Tai logote ahise, aru tai laga chokra ke bhal kori dibi koise, kelemane tai mori bole hoi thakise. ");
INSERT INTO nag_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Titia Jisu taike koise, “Jitia tak tumikhan chihna aru asurit kaam nadikhibo, titia tak biswas nokorile.” ");
INSERT INTO nag_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Daruga pora Taike koise, “Sahab ami laga bacha namora age te ahibi.” ");
INSERT INTO nag_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisu taike koise, “Jabi. Tumi laga chokra jinda ase.” Etu manu Jisu taike kowa ke biswas korise, aru jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kitia tai rasta te thakise, tai laga nokorkhan polai ahi taike lok paise aru koise, apuni laga chokra jinda hoise. ");
INSERT INTO nag_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aru tai taikhan ke hudise, thik ki somoite chokra to bhal hoise. Aru taikhan koise, “Juwa kali thik ek baji somoite bukhar taike chari jaise.” ");
INSERT INTO nag_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Titia tai jani loise, etu somoi Jisu taike kowa thik somoite asele, “Tumi laga chokra jinda ase.” Aru tai aru tai ghor manu sob biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisu pora Judea ke chari kene Galilee te ahise, titia tai etu dusra chihna kori dikhai diya asele. ");
INSERT INTO nag_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Etu din pichete Yehudi khan laga purbb thakise, aru Jisu Jerusalem te jaise. ");
INSERT INTO nag_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem te mer laga duar mata usorte ekta pukhuri asele, etu Ibrani kotha te Bethesda koi, ta te pansta veranda bonai rakhi sele. ");
INSERT INTO nag_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta te andha, lengra, aru jothor- rugi bemar thaka khan etu pukhuri laga pani hili bole laga asha te bohi rukhi thake. ");
INSERT INTO nag_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kelemane olop somoi pichete ekjon sorgodoth ahikena etu pukhuri te pani ke hilai diye, aru kun sob pora prothom te panite jabo, tai laga bemar bhal hoi thake. ");
INSERT INTO nag_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta te ekjon manu artis-saal pora bemar hoi kene thakisele. ");
INSERT INTO nag_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jitia Jisu taike dikhise aru tai ta te bisi din bemar pora eneka thaka jani loise, Tai koise, “Tumi bhal hoi jabole mon ase?” ");
INSERT INTO nag_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Bemar manu taike jowab dise, “Sahab, pani hila somoite moike loi jabole kun bhi nai, aru moi ta te jai thaka te dusra moi pora poila jai thake.” ");
INSERT INTO nag_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisu taike koise, “Uthi kene tumi laga charpai uthai loijai jabi.” ");
INSERT INTO nag_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aru etu kowa loge-loge te etu manu bhal hoi jaise, aru nijor chatai uthai loi aha juwa korise. Aru etu Bisram din asele. ");
INSERT INTO nag_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Karone Yehudi cholauta khan pora jun bhal hoise etu manu ke koise, “Aji to Bisram din ase, tumi laga charpai uthai loi juwa to niyom nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kintu tai taikhan ke koise, “Kun moike bhal korise, tai moike koise, ‘Tumi laga charpai uthai loijai jabi.’” ");
INSERT INTO nag_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Titia taikhan hudise, “Tumike ‘tumi laga charpai uthai loijabi’ kowa kun ase?” ");
INSERT INTO nag_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kintu bhal hoija-a manu to etu kun ase jana nai, kelemane ta te bhir asele, etu karone Jisu ta te pora piche hati jaisele. ");
INSERT INTO nag_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Etu pichete Jisu mondoli te taike paikene koise, “Sabi, tumi to bhal hoise! Aru etu pora bhi biya tumi uporte nahibo karone aru paap na koribi.” ");
INSERT INTO nag_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Etu manu Yehudi cholawta khan logote jai kene taike changai kori diya to Jisu ase koi dise. ");
INSERT INTO nag_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Karone Yehudi cholawta khan Jisu ke tarona di thakise, aru Taike morai dibole bisari thakise, Tai Bisram dinte etu kaam kori diya karone. ");
INSERT INTO nag_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kintu Jisu taikhan ke jowab dise, “Ami laga Baba etiya tak kaam kori ase, aru Moi bhi kaam kori ase.” ");
INSERT INTO nag_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Karone Yehudi cholawta khan Taike morai dibole aru bisi jor korise, kelemane Tai Bisram din laga niyom bhangai diya ekla he nohoi kintu Isor ke Tai laga Baba kowa aru Tai nijorke Isor logot borabar kora karone. ");
INSERT INTO nag_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Titia Jisu taikhan ke koise, “Moi tumikhan ke hosa kobo, Putro nijor eku koribo napare, kintu ki kaam khan Baba kori thaka Tai dikhe, eitu khan he Putro bhi kori thake. ");
INSERT INTO nag_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kelemane Baba pora Putro ke morom kore, aru ki kaam Tai kore sob to Putro ke dikhai diye, aru etu pora bhi dangor kaam khan Putro ke dikhai dibo aru tumikhan asurit hoi jabo. ");
INSERT INTO nag_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kelemane jineka Baba mora manu ke uthai diye aru jibon diye, tineka he Putro bhi Tai junke bhal pai taike jibon diye. ");
INSERT INTO nag_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kelemane Baba nijor to bisar nakore, kintu bisar kori bole sob kaam Putro ke di dise. ");
INSERT INTO nag_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Karone jineka sob manu Baba ke sonman kore, tineka Putro ke bhi sonman koribo, jun Putro ke sonman nakore, Taike pathai diya Baba ke bhi sonman nakore. ");
INSERT INTO nag_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Moi tumikhan ke hosa kobo jun Moike huni kene Moike pathai diya ke sonman koribo, anondo jibon tai laga hoise, aru saja laga kotha nai, kintu mrityu ke paar kori kene jibon te jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Moi tumikhan ke hosa kobo, mora manu Isor laga Putro laga awaj hunibo, aru jun huni lobo eitu khan jinda hobole somoi ahi ase, aru etiya ahise. ");
INSERT INTO nag_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kelemane jineka Baba nijor te jibon rakhe, tineka Putro ke bhi, Tai jibon rakhibole adhikar dise. ");
INSERT INTO nag_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aru Jisu he Manu laga Putro ase, etu karone bisar laga adhikar bhi Taike dise. ");
INSERT INTO nag_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tumikhan etu kotha karone asurit nohobi, kelemane kobor khan te thaka sob pora Tai awaj huni kene bahar te ulai jabo. ");
INSERT INTO nag_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aru jun bhal kaam korise, eitu khan jibon karone punoruthan hobo, jun biya kaam korise, eitu khan sajai nimite punoruthan hobo, eneka somoi ahi ase. ");
INSERT INTO nag_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Moi nijor eku koribo napare. Jineka Moi hune, eneka bisar kore, aru Moi laga bisar hosa ase, kelemane Moi nijor itcha te nohoi kintu, Moike patha Moi Baba laga itcha te he kore. ");
INSERT INTO nag_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jodi Moi nijorke sakhi dile, Moi laga sakhi hosa nohoi. ");
INSERT INTO nag_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ekjon ase kun Ami laga kotha ke sakhi diye, aru Moi jane, tai pora Ami laga sakhi diya to hosa ase. ");
INSERT INTO nag_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tumikhan John logote manu pathaise, aru tai hosa sakhi dise. ");
INSERT INTO nag_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kintu Moi manu pora sakhi nalage, kintu Moi tumikhan laga udhar nimite etu koi ase. ");
INSERT INTO nag_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John to joli thaka aru jiliki thaka saaki ase, aru tumikhan tai puhor te ekbar khushi pora thaki jabo mon kori sele. ");
INSERT INTO nag_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kintu Moi laga sakhi he John laga sakhi pora dangor ase, kelemane kaam ke pura kori bole Baba he Moike dise, kuntu kaam Moi kori ase, etu pora Baba he Moike pathaise koi kene Moike sakhi di ase. ");
INSERT INTO nag_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aru Moike pathai diya Baba Tai nijor Moike sakhi dise, tumikhan to kitia bhi Tai awaj huna nai, aru Tai roop bhi dikha nai. ");
INSERT INTO nag_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Aru tumikhan Tai laga kotha monte narakha hoise, karone junke Tai pathaise etu ke bhi tumikhan biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tumikhan Shastro te anondo jibon ase bhabikena bisari thake, aru etu kotha khan he Moike sakhi di ase, ");
INSERT INTO nag_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kintu tumikhan jibon pabo karone Ami logote ahibole mon nai. ");
INSERT INTO nag_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Moi manu pora adar nabisare, ");
INSERT INTO nag_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kintu tumikhan Isor ke morom nakora etu Moi jane. ");
INSERT INTO nag_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ami Moi laga Baba laga naam to ahise, aru tumikhan Moike grohon nakore. Jodi kunba tai nijor naam te ahile, tumikhan etu ke to grohon kori lobo. ");
INSERT INTO nag_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kineka tumikhan biswas koribo jitia Isor pora aha sonman ke nabisare kene nijor apaste he bisari thake? ");
INSERT INTO nag_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Moi Baba usorte tumikhan ke golti lagabo eneka nabhabi bhi. Tumikhan ke golti kora to Moses ase, junke tumikhan asha rakhise. ");
INSERT INTO nag_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Jodi tumikhan Moses kowa biswas kori thakise koile, Moike bhi biswas koribo, kelemane tai Moi nimite likhise. ");
INSERT INTO nag_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kintu jodi tumikhan tai likha ke biswas nakore, to tumikhan Ami laga kotha kineka biswas koribo?” ");
INSERT INTO nag_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eitu khan huwa pichete, Jisu Galilee Nodi laga dusra phale jai jaise, juntu ke Tiberias Samundar bhi koi. ");
INSERT INTO nag_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Titia bisi manu Tai piche kori ahise, kelemane Tai bemari khan ke asurit chihna kaam kori diya karone. ");
INSERT INTO nag_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aru Jisu tilla te uthise, aru Tai chela khan logote ta te bohi jaise. ");
INSERT INTO nag_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","-Aru titia Yehudi khan laga Nistar purbb punchi asele.- ");
INSERT INTO nag_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jitia Jisu Tai laga suku uthaikene saise, Tai phale dangor bhir ahi thaka dikhise, aru Tai Philip ke koise, “Manu khan pora khabo karone amikhan kot pora roti kinibo paribo?” ");
INSERT INTO nag_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","-Kintu Tai Philip laga mon sabole tineka he koisele, kelemane Tai nijor ki koribo lage sob jane.- ");
INSERT INTO nag_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip Taike jowab dise, “Duisoh dinari laga roti pora ekjon ke olop-olop dile bhi naponchibo.” ");
INSERT INTO nag_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tai chela pora ekjon Simon Peter laga bhai, Andrew Taike koise. ");
INSERT INTO nag_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Yate ekjon lora ase, tai logote pansta roti aru duita huru maas ase, kintu iman bisi manu karone etu pora ki koribo paribo? ");
INSERT INTO nag_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Titia Jisu koise, “Manu khan ke bohai dibi.”- Etu jagah te ghas bisi thakisele. Karone manu khan ke bohai dise, aru eitu khan ginti korise aru pans hajar nisena thakise. ");
INSERT INTO nag_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Titia Jisu roti loi kene dhanyavad dise aru chela khan ke sob logot bhag kori bole dise, aru tineka maas ke bhi, aru jiman lage iman taikhan ke dise. ");
INSERT INTO nag_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jitia taikhan khai loise Tai laga chela khan ke koise, “Bachi juwa kha-luwa ke joma kori lobi, kelemane eku bhi nuksan hobo nalage.” ");
INSERT INTO nag_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Karone taikhan joma kori loise, aru pans-ta roti khai kene tukra bachi thaka ke baroh-ta tukri bhorta joma kori loise. ");
INSERT INTO nag_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Titia manu khan Tai asurit kaam kori diya ke dikhi kene koise, “Etu duniya te ahibole thaka bhabobadi to hosa te bhi etu ase.” ");
INSERT INTO nag_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Karone manu khan ahi Taike joborjosti dhori kene raja bonai dibole bhabi thaka Tai jani kene ekbar aru Tai ekla pahar te jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jitia saam hoise, Tai chela khan nodi kinar te jaise. ");
INSERT INTO nag_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Aru naw te jai kene nodi paar Capernaum town phale jaise, etu somoi andhera hoise, aru Jisu titia bhi taikhan logote aha nai. ");
INSERT INTO nag_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Titia andhi karone samundar te hawa mari bole lagise. ");
INSERT INTO nag_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jitia taikhan laga naw to tin nohoile chari mile nisena chari jaise titia taikhan Jisu panite khujkari kene naw usorte aha dikhise aru taikhan bhoi khaise. ");
INSERT INTO nag_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kintu Jisu taikhan ke koise, “Moi ase! Bhoi nokoribi.” ");
INSERT INTO nag_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Titia taikhan Taike naw te lobole taiyar hoise, aru joldi etu naw kot te jabole ase ta te punchi jaise. ");
INSERT INTO nag_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Aru dusra din bhi manu khan samundar paar te thaki jaise, taikhan ta te ekta naw he dikhise, aru Jisu to taikhan logote etu naw te ja-a nai, khali chela khan he jaise. ");
INSERT INTO nag_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hoilebi, Tiberias phale pora dusra nawkhan bisi ahise, kun to jagate Probhu he roti loi Isor ke dhanyavad dikene taikhan roti khai sele. ");
INSERT INTO nag_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jitia manu khan ta te Jisu aru chela khan ke pa-a nai, taikhan aru naw te uthijaise, aru Jisu ke bisari kene Capernaum phale ahise. ");
INSERT INTO nag_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aru nodi paar te Taike paikene koise, “Rabbi, Apuni kitia yate ahi jaise?” ");
INSERT INTO nag_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisu taikhan ke jowab dise, “Moi Tumikhan ke hosa kobo, tumikhan chihna dikha karone nohoi, kintu tumikhan pet bhorta roti khabo para karone Moike bisari ase.” ");
INSERT INTO nag_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nost hobole laga kha luwa karone kaam na koribi, kintu juntu kha luwa anondo jibon tak thakibo, jun to Manu laga Putro he Tumikhan ke dibole ase, etu karone porishram koribi, kelemane Baba Isor he Tai uporte mohor lagai loise.” ");
INSERT INTO nag_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Titia taikhan Taike koise, “Isor laga kaam kori bole amikhan ki koribo lage?” ");
INSERT INTO nag_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisu taikhan ke jowab te koise, “Etu he Isor laga kaam ase: Junke Tai pathaise, Taike biswas koribi.” ");
INSERT INTO nag_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Karone taikhan Taike koise, “Tinehoile Apuni amikhan ke ki chihna dikha bo, juntu saikene amikhan Apuni ke biswas kori lobo? Apuni ki koribo? ");
INSERT INTO nag_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Amikhan laga baba khan jongol te manna khaise, ‘Tai he khabole sorgo pora dise, Shastro te eneka likha ase.’” ");
INSERT INTO nag_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Titia Jisu taikhan ke koise, “Moi tumikhan ke hosa kobo, sorgo pora roti tumikhan ke diya to Moses nohoi, kintu Moi laga Baba he hosa laga roti tumikhan ke dise. ");
INSERT INTO nag_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kelemane Isor laga roti etu ase, jun sorgo pora ahi kene duniya ke jibon di thake.” ");
INSERT INTO nag_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Titia taikhan Taike koise, “Sahab, etu roti hodai amikhan ke di thakibi.” ");
INSERT INTO nag_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aru Jisu taikhan ke koise, “Moi he jibon roti ase; jun Moi logote ahe tai kitia bhi bhukh nalagibo, aru jun Moike biswas koribo tai kitia bhi aru pyasa nohobo. ");
INSERT INTO nag_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kintu tumikhan Moike dikhi paise, kintu biswas nakore, etu Moi tumikhan ke koi dise. ");
INSERT INTO nag_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Baba pora jun khan Moike dise, taikhan sob Moi logote ahibo aru kun Moi logote ahibo, taike Moi kitia bhi nacharibo. ");
INSERT INTO nag_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kelemane Moi nijor itcha te nohoi, kintu Moike pathai diya laga itcha pora kori bole Moike sorgo pora niche anise. ");
INSERT INTO nag_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aru Moike pathai diya Jon laga itcha etu ase, Tai kun pora Moike ki dise, eitu khan ekjon bhi naharaikena, hekh dinte sobke uthabo. ");
INSERT INTO nag_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kelemane Ami laga Baba laga itcha etu ase, jun Putro ke dikhibo, aru Taike biswas koribo, etu anondo jibon pabo aru Moi hekh dinte taike uthai lobo.” ");
INSERT INTO nag_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Titia Yehudi khan Tai bhirodh kotha korise, kelemane Tai koise, “Sorgo pora aha roti Moi he ase.” ");
INSERT INTO nag_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aru taikhan majote eneka hudi thakise, “Etu Joseph laga chokra Jisu nohoi, jun laga ama baba amikhan jane? Tai kele eneka koi ase, ‘Moi sorgo pora ahise’?” ");
INSERT INTO nag_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Karone Jisu taikhan ke koise, “Tumikhan apaste kotha na koribi. ");
INSERT INTO nag_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Moike pathai diya Moi laga Baba he loi ani nadile, kun bhi Moi logote ahibo na paribo, aru Moi hekh dinte taike uthai dibo. ");
INSERT INTO nag_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bhabobadi khan pora likha eneka ase, ‘Aru taikhan sobke Isor pora sikhai lobo.’ Kun pora Baba laga kotha hunise aru sikhi loise taikhan he Moi logote ahibo. ");
INSERT INTO nag_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kun bhi Baba ke dikha nai, khali Tai Jun Isor pora ahise- Tai he Baba ke dikhise. ");
INSERT INTO nag_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Moi tumikhan ke hosa kobo, jun Moike biswas koribo, tai anonto jibon pabo. ");
INSERT INTO nag_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jibon laga roti Moi ase. ");
INSERT INTO nag_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tumi baba laga baba khan jongol te manna khaise, aru morise. ");
INSERT INTO nag_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Etu roti to sorgo pora nichete ahise, aru manu khan etu khabo hoile bhi namoribo. ");
INSERT INTO nag_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sorgo pora aha jibon laga roti Moi ase. Jodi kunba etu roti khabo, tai anondo jibon pabo, aru ki roti jibon karone Moi duniya ke dibole ase, etu Moi laga mangso ase.” ");
INSERT INTO nag_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Etu huni kene Yehudi khan apaste kotha namila hoise, “Etu manu kineka kori Tai mangso amikhan ke khabole dibo paribo?” ");
INSERT INTO nag_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Titia Jisu taikhan ke koise, “Moi tumikhan ke hosa kobo, tumikhan Manu laga Putro laga mangso aru Tai laga khun jodi nakhabo, tinehoile tumikhan logote jibon nathakibo. ");
INSERT INTO nag_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jun Moi laga mangso khabo, aru Moi laga khun khabo, anonto jibon tai laga ase, aru Moi hekh dinte taike uthai lobo. ");
INSERT INTO nag_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kelemane Moi laga mangso he asol kha luwa ase, aru Moi laga khun bhi asol laga khun ase. ");
INSERT INTO nag_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jun Moi laga mangso khabo aru Moi laga khun khabo tai Moi logote ase, aru Moi tai logote ase. ");
INSERT INTO nag_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jivit Baba he Moike pathaise, aru Moi Baba karone jivit ase, tineka jun Moike khabo, tai bhi Moi karone jivit hobo. ");
INSERT INTO nag_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Etu to sorgo pora aha roti ase, tumikhan laga baba khan manna khaise aru mori jaise, jun bhi etu roti khabo, tai anonto tak jinda thakibo.” ");
INSERT INTO nag_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tai etu kotha khan sob Capernaum laga mondoli te thaka somoite manu khan ke sikhai thakise. ");
INSERT INTO nag_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Karone Tai chela khan jitia etu hunise taikhan koise, “Etu kotha to bisi digdar kotha ase, eitu khan to kun mani bole paribo? ");
INSERT INTO nag_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jitia Tai chela khan etu kotha patise, Jisu jani kene taikhan ke koise, “Etu kotha karone tumikhan thogar lagise? ");
INSERT INTO nag_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Aru jodi Manu laga Putro age te thaka jagate wapas uporte juwa tumikhan dikhile kineka hobo? ");
INSERT INTO nag_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jibon di thaka to Atma ase, gaw to eku labh nai, Moi tumikhan ke kowa khan to atma ase, aru jibon bhi ase. ");
INSERT INTO nag_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kintu tumikhan majote kunba biswas nakora ase.” Kelemane Jisu he shuru pora jani ase, kun biswas nakore aru kun Taike thogai dibole ase. ");
INSERT INTO nag_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aru tai koise, “Etu karone, Moi tumikhan ke koise, jitia tak Baba pora bordan nadibo kun bhi Moi logote ahibo na paribo.” ");
INSERT INTO nag_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Etu kotha karone Tai chela khan bisi Taike chari kene wapas jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Titia Jisu pora baroh jonke koise, “Tumikhan bhi wapas jabole mon kora nai na?” ");
INSERT INTO nag_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kintu Simon Peter Taike jowab dise, “Probhu amikhan kun logote jabo? Anondo jibon laga vachan to Apuni logote ase, ");
INSERT INTO nag_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","aru amikhan biswas kori ase, aru jani ase, Apuni he Isor laga Pobitro Jon ase.” ");
INSERT INTO nag_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisu taikhan ke jowab dise, “Moi he tumikhan baroh jonke basi loise nohoi, aru tumikhan majote ekjon saitan ase?” ");
INSERT INTO nag_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tai Simon laga chokra Iscariot Judas laga kotha koi asele, kelemane tai he Taike thogai dibole jon ase, baroh jon majote ekjon tai asele. ");
INSERT INTO nag_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Eitu khan huwa pichete, Jisu Galilee te berai thakise, kelemane Yehudi khan Taike morai dibole thaka karone Tai Judea phale berabo mon kora nai. ");
INSERT INTO nag_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yehudi khan laga Tombu laga Purbb din bhi usor ahi ponchise. ");
INSERT INTO nag_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Karone Tai bhai khan Taike koise, “Etu jaga chari kene Judea te jai jabi, Apuni ki kaam kori ase etu Apuni laga chela khan bhi dikhi bole dibi. ");
INSERT INTO nag_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kelemane Jun bhi tai nijor naam ke untcha koribo mon kore, tai lukai kene nakore. Jodi Apuni etu kaam korise koile, Apuni nijorke dikhai dibi duniya ke.” ");
INSERT INTO nag_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kelemane Jisu laga nijor bhai khan bhi Taike biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Titia Jisu taikhan ke koise, “Moi jabole laga thik somoi huwa nai, kintu tumikhan karone hodai somoi taiyar ase. ");
INSERT INTO nag_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Prithibi tumikhan ke ghin no koribo, kintu Moike ghin kore kelemane Moi taikhan laga biya kaam ke gawahi diye. ");
INSERT INTO nag_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tumikhan purbb te jabi; Moi to etiya etu purbb te najabo, kelemane Moi laga somoi pura huwa nai.” ");
INSERT INTO nag_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tai taikhan ke etu sob koi dise, aru Tai Galilee te thaki jaise. ");
INSERT INTO nag_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kintu Tai bhai khan juwa pichete Tai bhi khula-khula nohoi, kintu lukai kene purbb te jaise. ");
INSERT INTO nag_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Titia, Yehudi cholawta khan Taike purbb te bisarise aru koise, “Tai kot te ase?” ");
INSERT INTO nag_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Aru manu khan majote Tai nimite kotha namila bisi ulaise. Kunba koi, “Tai bhal manu ase.” Kintu dusra khan koise, “Nohoi, kintu Tai manu khan ke ulta loijai.” ");
INSERT INTO nag_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hoilebi Yehudi cholawta khan ke bhoi pora kun bhi Tai laga kotha khuli kene kowa nai. ");
INSERT INTO nag_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aru jitia purbb laga adha somoi jaise to Jisu mondoli te ahikena sikhabole shuru hoise. ");
INSERT INTO nag_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aru Yehudi cholawta khan asurit hoise, koise, “Kineka etu manu Shastro jane, pora likha nathaki kene bhi?” ");
INSERT INTO nag_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisu taikhan ke jowab di koise, “Moi sikhai di thaka kotha khan to Moi pora nohoi, kintu Moike pathai diya pora ase. ");
INSERT INTO nag_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jodi kunba Isor laga itcha te jabo mon korile, etu kotha to Isor pora ahise na Moi nijor khushi pora ase, tai nijor janibo. ");
INSERT INTO nag_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kun nijor khushi pora kobo etu tai nijorke prosansa kori ase, kintu jun taike pathai diya ke prosansa kore, etu hosa ase aru tai monte adharmikta nathake. ");
INSERT INTO nag_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses tumikhan ke niyom dise nohoi? Kintu tumikhan kun bhi niyom ke mana nai. Kile tumikhan Moike morai dibole bisari thake?” ");
INSERT INTO nag_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bhir khan jowab di koise, “Tumi logote bhoot ase. Kun apnike morai dibole bisari ase?” ");
INSERT INTO nag_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisu taikhan ke koise, “Moi ekta kaam kori dise, aru tumikhan sob asurit korise. ");
INSERT INTO nag_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses tumikhan ke sunnot laga hukum dise, etu to, Moses pora nohoi kintu baba laga khandan khan pora ahise aru tumikhan Bisram dinte sunnot kori thake. ");
INSERT INTO nag_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jodi ekjon manu Bisram dinte sunnot kori kene Moses laga niyom nabhangai, to kele tumikhan Moike ghusa kore kelemane Moi Bisram dinte manu ke bhal kora nimite? ");
INSERT INTO nag_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Chehera saikene bisar na koribi, kintu dharmikta pora bisar koribi.” ");
INSERT INTO nag_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Titia Jerusalem pora aha kunba koise, “Taikhan pora morai dibole bisari thaka to etu manu nohoi? ");
INSERT INTO nag_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kintu sabi, Tai to khula-khula kotha koi ase aru kunbi Taike eku nokoi, Tai he Khrista ase koi kene Yehudi cholawta khan bhi jani loise? ");
INSERT INTO nag_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Etu manu kot pora ase, amikhan etu jani ase. Kintu jitia Khrista ahibo, Tai kot pora ase etu kun bhi najanibo.” ");
INSERT INTO nag_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Titia Jisu mondoli bhitor te jor pora hikai se aru koise, “Tumikhan Moike jane, Moi kot pora ahise. Hoilebi Moi nijor khushi pora aha nohoi kintu Jun he Moike pathaise Tai hosa ase, Junke tumikhan najane. ");
INSERT INTO nag_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Moi Taike jane, kelemane Moi Tai pora ahise, aru Tai he Moike pathaise.” ");
INSERT INTO nag_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Karone, taikhan Taike dhori bole kosis korise, kintu kun bhi Tai uporte hath diya nai, kelemane Tai somoi napuncha karone. ");
INSERT INTO nag_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aru bisi manu Taike biswas kori loise, aru taikhan koise, “Jitia Khrista ahibo, Tai etu manu pora kori diya pora bhi bisi asurit kaam nakoribo naki?” ");
INSERT INTO nag_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Manu khan Jisu laga kotha koi thaka etu Pharisee khan jani kene, mukhyo purohit khan aru Pharisee khan Taike dhori bole daruga khan ke pathai dise. ");
INSERT INTO nag_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Titia Jisu taikhan ke koise, “Moi olop somoi karone tumikhan logote ase, pichete jun Moike pathaise Tai logote jai jabo. ");
INSERT INTO nag_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tumikhan Moike bisaribo, aru napabo, aru kot te Moi jabo ta te tumikhan ahibo na paribo.” ");
INSERT INTO nag_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Titia Yehudi cholawta khan kotha korise aru taikhan majote hudise, “Tai kot te jabole ase, aru ki karone amikhan Taike napabo? Tai Yunani khan ephale-uphale hoi thaka khan ke sikhabole jai jabole ase? ");
INSERT INTO nag_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tai kowa etu ki kotha ase, ‘Tumikhan Moike bisaribo, kintu Moike napabo, aru kot te Moi jabo ta te tumikhan ahibo na paribo’?” ");
INSERT INTO nag_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aru purbb laga ses dinte, juntu dangor din ase, Jisu uthi kene jor pora koise, “Jodi kunba pyasa ase, tai Moi logote ahi kene khabi. ");
INSERT INTO nag_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jun Moike biswas koribo, tinehoile Shastro te kowa nisena, nodi jinda laga pani tai laga pet pora bohi ahibo.” ");
INSERT INTO nag_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kintu Tai Atma laga kotha koi thakise, juntu biswas kora khan pabole thakise, aru Tai nijor mohima te juwa nai kelemane Pobitro Atma etiya tak Taike diya nai. ");
INSERT INTO nag_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Titia bhir pora kunba etu huni kene, “Asol bhabobadi etu he ase” koise. ");
INSERT INTO nag_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aru dusra koise, “Etu he Khrista ase.” Kintu kunba koise, “Khrista to Galilee pora ahibo naki?” ");
INSERT INTO nag_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Khrista to David laga khandan pora aru Bethlehem bosti kot te David thakisele, ta te pora ahibo eneka Shastro te kowa nohoi?” ");
INSERT INTO nag_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Titia Tai karone manu khan dui bhag hoi jaise. ");
INSERT INTO nag_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aru kunba Taike dhori bole hoise, kintu kunbi Tai uporte hath diya nai. ");
INSERT INTO nag_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Titia daruga khan wapas mukhyo purohit khan aru Pharisee khan logote ahise, aru taikhan pora koise, “Kile tumikhan Taike loi aha nai?” ");
INSERT INTO nag_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Daruga khan jowab dise, “Kunbi Tai nisena kotha nakoi.” ");
INSERT INTO nag_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Titia Pharisee khan taikhan ke jowab dise, “Kile, tumikhan bhi thogai te giri ase? ");
INSERT INTO nag_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kunba cholawta khan aru Pharisee khan Taike biswas kori luwa nohoi na? ");
INSERT INTO nag_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kintu niyom najana etu bhir manu khan to shrapit hoise.” ");
INSERT INTO nag_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus jun he rati te Jisu logote ahise, tai pora taikhan ke koise, ");
INSERT INTO nag_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Amikhan laga niyom hisab te manu laga kotha nahuna age te golti lagabo pare naki?” ");
INSERT INTO nag_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Taikhan taike jowab dise, “Tumi bhi Galilee manu ase? Sabi aru bisaribi, kelemane Galilee pora kun bhabobadi bhi naulabo lage.” ");
INSERT INTO nag_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aru sob manu nijor-nijor ghor te jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aru Jisu Oliv pahar te jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ekdom phojurte Tai aru mondoli te ahise, aru sob manu khan ahise; Tai bohi kene taikhan ke sikhai thakise. ");
INSERT INTO nag_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Titia niyom likha khan aru Pharisee khan pora ekjon mahila ke loi anise junke bebichari kaam te dhorise, aru taike taikhan majot te khara kori dise. ");
INSERT INTO nag_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Titia taikhan Jisu ke hudise, “Shika manu, etu mahila ke bebichari kaam te dhorise. ");
INSERT INTO nag_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aru niyom te pathor pora eneka khan ke mari dibi koi kene Moses he hukum di rakhise; kintu Apuni ki kobo?” ");
INSERT INTO nag_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Taikhan Jisu ke porikha lobole he Taike eneka hudise, kintu eku bhi nahuna nisena Tai niche jhuki kene anguli pora matite kiba likhi thakise. ");
INSERT INTO nag_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kintu taikhan hudi thakise, titia Tai sidha khara hoi kene koise, “Tumi laga majote kun paap kora nai, tai he sob pora poila pathor taike maribi.” ");
INSERT INTO nag_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tai arubi niche jhuki kene anguli pora matite likhi thakise. ");
INSERT INTO nag_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jitia taikhan etu hunise, taikhan majot sobse bura khan pora shuru kori kene ekjon pichete ekjon kori kene jai jaise. Aru ta te Jisu ekla thaki jaise, aru utu mahila jun majot te khara thakise. ");
INSERT INTO nag_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aru Jisu sidha khara hoi kene taike koise, “Mahila, kot te ase tumike golti diya khan? Kunbi tumike golti diya nai?” ");
INSERT INTO nag_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tai koise, “Kunbi nai, Probhu.” Jisu koise, “Moi bhi tumike golti nadibo. Jabi aru paap na koribi.” ");
INSERT INTO nag_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Titia Jisu taikhan ke koise, “Moi he duniya laga puhor ase; jun Ami laga picha koribo, tai andhera te najabo, kintu jibon laga puhor pabo.” ");
INSERT INTO nag_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisee khan Taike koise, “Apuni nijorke sakhi di ase; Apuni laga sakhi hosa nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisu taikhan ke jowab di koise, “Jodi Moi nijor karone sakhi dile bhi, Moi laga sakhi hosa ase. Kelemane Moi kot pora ahise aru kot te jabole ase etu Moi jane, kintu tumikhan to Moi kot pora ahise aru kot te jabole ase najane. ");
INSERT INTO nag_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tumikhan to mangso hisab bisar kore; Moi kunke bhi bisar no kore. ");
INSERT INTO nag_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jodi Moi bisar kore, Ami bisar kora hosa ase kelemane Moi ekla nohoi, kintu Moi Baba logote ase, jun Moike pathaise. ");
INSERT INTO nag_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aru tumikhan niyom te bhi likha ase duijon laga sakhi to hosa ase koi kene. ");
INSERT INTO nag_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Moi nijorke sakhi di ase, aru Baba jun Moike pathaise Tai bhi Amike sakhi di ase.” ");
INSERT INTO nag_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Titia taikhan Taike koise, “Tumi laga Baba kot te ase?” Jisu koise, “Tumikhan Moike bhi aru Moi laga Baba ke bhi najane; jodi tumikhan Amike janile, Ami laga Baba ke bhi janibole asele.” ");
INSERT INTO nag_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tai etu kotha mondoli ghor te bhandar jaga pora koi thakise, aru kun bhi Taike dhora nai kelemane Tai somoi puncha nai. ");
INSERT INTO nag_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aru Tai taikhan ke koise, “Moi to jai jabo, aru tumikhan Moike bisaribo aru tumikhan nijor paap pora mori jabo. Moi kote jabo, ta te tumikhan ahibo na paribo.” ");
INSERT INTO nag_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Karone Yehudi cholawta khan koise, “Tai nijorke namorabo na? Etu karone Tai koi ase, ‘Kot Moi jabo tumikhan ta te ahibo na paribo’?” ");
INSERT INTO nag_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Karone Jisu taikhan ke koise, “Tumikhan to niche pora ase; Moi to upor pora ase. Tumikhan to etu prithibi laga ase; Moi etu prithibi laga nohoi. ");
INSERT INTO nag_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Etu karone, Moi koise tumikhan nijor paap pora mori jabo. Kelemane MOI ASE etu koi kene tumikhan biswas nokorile, tumikhan nijor paap pora mori jabo.” ");
INSERT INTO nag_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Titia taikhan Taike koise, “Apuni kun ase?” Jisu taikhan ke koise, “Ki Moi tumikhan ke shuru pora koise etu ase.” ");
INSERT INTO nag_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Moi bisi kotha kobole aru bisar kori bole ase tumikhan karone. Kintu Moike pathai diya to hosa ase; aru Tai pora Ami ki hunise, etu he Moi prithibi ke koi thake.” ");
INSERT INTO nag_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Taikhan bujhi bo para nai Tai Baba laga kotha taikhan ke koise koi kene. ");
INSERT INTO nag_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Titia Jisu taikhan ke koise, “Jitia tumikhan pora Manu laga Putro ke upor latkai dibo, titia tumikhan jani lobo MOI ASE, aru Moi nijor eku nakore, kintu jineka Baba he Moike sikhai, etu he Moi koi thake. ");
INSERT INTO nag_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tai Moike pathaise aru Tai Moi logote thake, Tai Moike ekla nachare, kelemane Moi hodai Tai itcha he kori thake.” ");
INSERT INTO nag_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jitia Jisu etu kotha koi dise, bisi manu Taike biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Titia Jisu pora Taike biswas kori luwa Yehudi khan ke koise, “Tumikhan Ami laga kotha mani thakile tumikhan Ami laga hosa chela hoise; ");
INSERT INTO nag_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","aru tumikhan hosa ke jani lobo, aru hosa he tumikhan ke ajad kori dibo.” ");
INSERT INTO nag_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Taikhan Taike koise, “Amikhan Abraham laga khandan ase, kitia bhi kun laga nokor thaka nai; kineka Apuni koise, ‘Tumikhan ke ajad kori dibo’?” ");
INSERT INTO nag_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisu jowab dise, “Moi tumikhan ke hosa kobo, jun bhi paap te thakise tai paap laga noukar ase. ");
INSERT INTO nag_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aru noukar to hodai ghor te nathake, kintu Putro to hodai thake. ");
INSERT INTO nag_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Karone, jodi Putro pora tumikhan ke ajad kori dile, tumikhan hosa pora ajad hoise. ");
INSERT INTO nag_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tumikhan Abraham laga khandan ase etu Moi jane, kintu tumikhan Moike morai dibole bisari ase, kelemane Ami laga kotha karone tumikhan monte jagah nai. ");
INSERT INTO nag_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Moi pora kowa kotha khan sob Moi laga Baba logote dikhise; karone tumikhan bhi tumikhan baba pora ki hunise, etu he koribi.” ");
INSERT INTO nag_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Taikhan Taike jowab dise aru koise, “Amikhan laga baba to Abraham ase.” Jisu taikhan ke koise, “Jodi tumikhan Abraham laga bacha khan hoile, tumikhan Abraham laga kaam khan koribi. ");
INSERT INTO nag_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Etiya tumikhan Moike morai dibole bisari ase, ekjon manu kun tumikhan ke hosa koi dise juntu kotha khan Moike Isor pora hunai se. Abraham tineka kora nai. ");
INSERT INTO nag_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tumikhan to tumikhan baba khan laga kaam kori thake.” Taikhan pora Taike koise, “Amikhan bebichar kaam pora jonom luwa nohoi; amikhan Baba ekjon he ase; Isor.” ");
INSERT INTO nag_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisu taikhan ke koise, “Jodi Isor tumikhan laga Baba hoile, tumikhan Moike morom koribo, kelemane Moi Isor pora ahise, Moi nijor pora aha nohoi, kintu Tai Moike pathaise. ");
INSERT INTO nag_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kile tumikhan Ami laga kotha bujhi bo napare? Tumikhan Ami laga kotha nahuna nimite ase. ");
INSERT INTO nag_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tumikhan to tumikhan baba, bhoot laga ase, aru tumikhan tai itcha he kori bole bhal pai. Tai shuru pora khun kora ase aru tai hosa te khara nathaka karone tai logote hosa nai. Kitia tai misa koi, tai nijor mon pora koi thake, kelemane tai misa ase aru misa khan laga baba ase. ");
INSERT INTO nag_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kintu, Moi hosa koi, tumi Moike biswas nakore. ");
INSERT INTO nag_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kun Moike paap laga galti dibo pare? Jodi Moi hosa koi, to tumikhan Moike kele biswas nakore? ");
INSERT INTO nag_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jun Isor pora ahise tai Isor kotha khan huni; kintu etu nimite tumikhan to taikhan laga kotha nahune, kelemane tumikhan Isor laga nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Titia Yehudi khan Taike jowab di koise, “Amikhan hosa kowa nohoi Apuni Samaria manu ase aru Apuni logote ekjon bhoot ase?” ");
INSERT INTO nag_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisu koise, “Moi logote bhoot nai, kintu Moi Ami laga Baba ke sonman kore, aru tumikhan Moike bodnam kori ase. ");
INSERT INTO nag_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kintu Moi nijor mohima nabisare; etu bisari thaka aru bisar kori thaka ekjon ase. ");
INSERT INTO nag_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hosa pora Moi tumikhan ke kobo, jodi kunba Ami laga kotha hune, tai kitia bhi mrityu nadikhibo.” ");
INSERT INTO nag_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Titia Yehudi khan Taike koise, “Etiya amikhan jani loise, Tumi logote bhoot ase. Abraham aru bhabobadi khan bhi mori jaise; aru Apuni koise, ‘Jodi jun Ami laga kotha ke rakhi lobo, tai mrityu nadikhibo.’ ");
INSERT INTO nag_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Apuni amikhan laga Baba Abraham kun mori jaise, tai pora dangor ase naki? Bhabobadi khan bhi mori jaise. Apuni nijorke kun koi kene bhabi ase?” ");
INSERT INTO nag_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisu jowab dise, “Jodi Moi nijorke mohima korile, Ami laga mohima eku nai; kintu Moike mohima kora Ami laga Baba he ase- junke tumikhan Isor koi kene mate. ");
INSERT INTO nag_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tumikhan Taike najane, kintu Moi Taike jane. Aru jodi Moi koi, ‘Moi Taike najane’, tumi nisena Moi bhi misa hoise, kintu Moi Taike jane aru Tai laga kotha mane. ");
INSERT INTO nag_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tumikhan laga baba Abraham to Moi laga din dikhi bole asha te anondo kori ase, aru Tai dikhi paise aru khushi korise.” ");
INSERT INTO nag_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Titia Yehudi khan Taike koise, “Apuni pachas saal bhi huwa nai, aru Apuni Abraham ke dikhise?” ");
INSERT INTO nag_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisu taikhan ke koise, “Hosa pora Moi tumikhan ke kobo, Abraham age pora, MOI ASE.” ");
INSERT INTO nag_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Titia taikhan Taike mari dibole pathor uthaise; kintu Jisu Tai nijor lukai kene mondoli pora bahar ulai jaise. ");
INSERT INTO nag_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jitia Jisu jai thaka homoi te, jonom pora andha thaka ekjon ke Tai lok paise. ");
INSERT INTO nag_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aru Tai chela khan Taike hudise, “Rabbi, kun paap korise, etu manu na tai baba ama khan karone jonom pora tai andha hoise?” ");
INSERT INTO nag_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisu jowab dise, “Etu manu laga paap bhi nohoi, Tai baba-ama khan laga bhi nohoi, kintu tai karone Isor laga kaam dikhai dibole nimite. ");
INSERT INTO nag_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Din thaka homoi te he kun Moike pathaise Tai laga kaam kori thakibo lage. Kelemane rati ahi ase. ");
INSERT INTO nag_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Jitia Moi prithibi te ase, Moi he prithibi laga puhor ase.” ");
INSERT INTO nag_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jitia Tai etu sob koi diya hoise, Tai matite thuki kene buka bonai loise, aru etu buka pora andha manu laga suku te lagai dise. ");
INSERT INTO nag_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Aru Jisu taike koise, “Jabi, aru Siloam pukhuri te dhui lobi, ” -juntu laga motlob ase “pathai diya.” Karone tai jaise, aru dhui dise, aru dikhibo parikena wapas ghurai ahise. ");
INSERT INTO nag_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Karone tai laga ghor usor manu khan kunkhan pora taike age te bhikh mangi thaka dikhi thakise, etiya taike dikhi kene koise, “Etu manu to rasta te bohi bhikh mangi thaka to nohoi?” ");
INSERT INTO nag_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kunba koise, “Etu tai ase.” Dusra koise, “Nohoi, kintu tai nisena ase.” Kintu tai koise, “Etu moi ase.” ");
INSERT INTO nag_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Titia taikhan taike hudise, “Kineka tumi laga suku khuli jaise?” ");
INSERT INTO nag_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tai jowab dise, “Jun laga naam Jisu ase Tai mati buka bonai kene moi laga suku te lagai dise, aru moike koise, ‘Siloam te jabi aru dhui dibi.’ Aru moi jai kene dhui dise, aru moi dikhibo paise.” ");
INSERT INTO nag_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Taikhan taike koise, “Tai kot te ase?” Tai jowab dise, “Moi najane.” ");
INSERT INTO nag_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Taikhan jun andha asele etu ke Pharisee khan logote loi anise. ");
INSERT INTO nag_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Etu Bisram din asele jitia Jisu mati pora buka bonai kene tai laga suku bhal kori disele. ");
INSERT INTO nag_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Titia Pharisee khan bhi taike aru hudise. Tai taikhan ke koise, “Tai ami laga suku te mati lagai dise aru etiya moi dikhise.” ");
INSERT INTO nag_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Karone kunba Pharisee khan koise, “Etu manu to Isor pora nohoi kelemane Tai Bisram din ke namane.” Kintu kunba koise, “Kineka paapi manu eneka asurit kaam kori dikha bo paribo?” Aru taikhan bhag hoise. ");
INSERT INTO nag_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Taikhan aru andha manu ke hudise, “Tumi Tai karone ki kobo, kun tumi laga suku khuli dise?” Andha manu koise, “Tai to bhabobadi ase.” ");
INSERT INTO nag_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kintu Yehudi cholawta khan etu manu age te andha thakise aru etiya dikhibo pari ase koi kene biswas kora nai, jitia tak tai baba ama ke mati ani kene huda-hudi kora nai. ");
INSERT INTO nag_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Aru taikhan tai ama baba ke hudise, koise, “Etu tumikhan laga chokra jonom pora andha asele? Aru kineka kori etiya dikhi ase?” ");
INSERT INTO nag_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tai ama baba taikhan ke jowab di koise, “Amikhan jane etu amikhan laga chokra ase aru jonom pora andha thakise. ");
INSERT INTO nag_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kintu amikhan etu najane tai kineka kori etiya dikhibo pari ase, aru kun tai laga suku khuli dise. Tai jawan hoise, taike hudi bhi. Tai nijor koi dibo.” ");
INSERT INTO nag_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tai ama baba khan Yehudi khan ke bhoi pora tineka koise, kelemane Yehudi khan age pora eneka koi kene ase jodi kunba Khrista naam kobo, etu manu laga naam mondoli pora ulai dibo. ");
INSERT INTO nag_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Etu karone, tai baba ama koise, “Tai jawan hoise, taike hudi bhi.” ");
INSERT INTO nag_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aru taikhan dusra bar etu andha thaka manu ke mati ani kene taike koise, “Isor ke mohima koribi. Amikhan jane etu to paapi manu ase.” ");
INSERT INTO nag_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tai jowab di koise, “Moi najane jodi Tai paapi manu ase. Ekta kotha moi jani ase; moi andha asele, aru etiya dikhi ase.” ");
INSERT INTO nag_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Titia taikhan taike koise, “Tai tumike ki korise? Kineka kori tai tumi laga suku khuli dise?” ");
INSERT INTO nag_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tai taikhan ke koise, “Moi poila pora apuni khan ke koi dise, aru apuni khan huna nai! Kile apuni khan aru hunibo mon kori ase? Apnikhan bhi Tai chela hobole mon ase naki?” ");
INSERT INTO nag_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Titia taikhan taike gali dikene koise, “Tumi to Tai laga chela ase, kintu amikhan to Moses laga chela ase. ");
INSERT INTO nag_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amikhan jane Isor pora Moses logote prothom te kotha korise kintu etu manu to amikhan najane Tai kot pora ahise.” ");
INSERT INTO nag_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tai taikhan ke jowab di koise, “Etiya to asurit hoi ase, Tai kot pora ahise moi najane, hoilebi tai pora he ami laga suku bhal kori dise. ");
INSERT INTO nag_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Amikhan jane Isor paapi manu ke nahune, kintu kun Isor ke thik mane aru Tai itcha kore, eitu khan ke Tai hune. ");
INSERT INTO nag_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Prithibi shuru pora etiya tak kun bhi jonom pora andha manu suku bhal kori diya huna nai. ");
INSERT INTO nag_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jodi etu manu Isor pora aha nohoile, Tai eku bhi koribo na paribo.” ");
INSERT INTO nag_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Taikhan taike jowab di koise, “Tumi to hosa ke paap pora jonom hoise, aru tumi amikhan ke sikhabole ase?” Titia aru taikhan taike khedai dise. ");
INSERT INTO nag_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Aru etu manu ke taikhan mondoli pora ulai dise koi kene Jisu hunise. Jitia Jisu taike lok paise, Tai hudise, “Tumi Manu laga Putro ke biswas kore?” ");
INSERT INTO nag_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tai jowab dikene koise, “Aru Tai kun ase, Probhu, moi Taike biswas koribo karone?” ");
INSERT INTO nag_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aru Jisu taike koise, “Tumi Taike dikhi loise, aru tumi logote kotha kori thaka etu he Tai ase.” ");
INSERT INTO nag_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Titia tai koise, “Probhu, moi biswas korise” aru Taike aradhana korise. ");
INSERT INTO nag_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisu koise, “Moi etu prithibi ke bisar kori bole ahise, jun manu nadikhe taikhan dikhi pabole, aru jun manu dikhe taikhan ke andha kori dibole.” ");
INSERT INTO nag_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kunba Pharisee jun khan Tai logote asele taikhan etu kotha huni kene taike koise, “Amikhan bhi andha ase naki?” ");
INSERT INTO nag_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisu taikhan ke koise, “Jodi tumikhan andha thakise koile, tumi laga paap nathakibole asele, kintu etiya tumikhan koi ase, ‘Amikhan dikhi ase,’ karone tumikhan laga paap thaki jabo.” ");
INSERT INTO nag_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Hosa pora Moi tumikhan ke kobo, kun mer rakha dorja pora na ghusikena dusra rasta pora ghusi bo etu to chor aru dokait ase. ");
INSERT INTO nag_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kintu jun dorja pora ghusi bo tai he mer laga roikhya ase. ");
INSERT INTO nag_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tai karone dorjate rukhi thaka manu pora dorja khuli dibo. Aru mer khan tai laga awaj hunibo, aru tai nijor mer khan laga naam mati kene bahar te loijai thake. ");
INSERT INTO nag_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aru jitia tai mer khan ke bahar kori loise, tai eitu khan laga age jai thake, aru mer khan piche ahi thake, kelemane eitu khan tai laga awaj jane. ");
INSERT INTO nag_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aru taikhan najana manu laga piche najabo, kintu polai jabo, kelemane taikhan eitu khan laga awaj nachine.” ");
INSERT INTO nag_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisu pora etu dristanto taikhan ke koise, kintu taikhan Tai ki koise etu laga motlob bujhi bo para nai. ");
INSERT INTO nag_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Titia Jisu taikhan ke aru koise, “Hosa pora Moi tumikhan ke kobo, Moi he mer khan laga dorja ase. ");
INSERT INTO nag_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Moi pora age te jiman ahise, sob chor aru dokait ase, kintu mer khan pora taikhan ke huna nai. ");
INSERT INTO nag_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Moi he dorja ase, jodi kunba Moi dwara ghusi bo, tai poritran pabo, aru bhitor bahar aha juwa koribo, aru dana pabo. ");
INSERT INTO nag_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Chor khali chor kori bole nohoi kintu morai dibole aru biya kori bole ahe. Moi aha to taikhan jibon pabole aru etu ke bhi bisi bhorta thaka jibon dibo karone ahise. ");
INSERT INTO nag_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Moi bhal mer roikhya ase. Bhal mer roikhya to mer khan karone nijor jibon di diye. ");
INSERT INTO nag_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Hoile bhi ekjon hajira kora manu to roikhya nohoi, aru mer khan laga malik bhi nohoi. Tai kitia rong kutta aha dikhe, mer khan ke chari kene polai jai, aru rang-kutta he mer khan ke dhori loijai, aru mer khan ke ephale-uphale polabo diye. ");
INSERT INTO nag_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kelemane tai hajira kora manu ase etu karone polai jai, tai mer khan karone chinta nathaki. ");
INSERT INTO nag_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Moi bhal mer roikhya ase, aru Moi nijor mer khan ke jane, aru Moi laga mer khan bhi Moike jane. ");
INSERT INTO nag_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jineka Baba Moike jane, Moi bhi Baba ke jane, aru Moi mer khan karone Moi laga nijor jibon di ase. ");
INSERT INTO nag_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aru Ami laga dusra mer khan bhi ase jun khan etu mer ghor te nathake. Taikhan ke bhi Moi anibo lage, aru taikhan Moi laga awaj hunibo, aru titia sob mer khan ekta hoi jabo aru mer roikhya bhi ekjon he thakibo. ");
INSERT INTO nag_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Moi laga Baba Moike etu nimite morom kore: kelemane Moi nijor laga jibon dise aru bhi wapas loi lobo karone. ");
INSERT INTO nag_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kun bhi etu Moi pora chingibo napare, kintu Moi he nijorke di ase. Ami laga jibon dibole aru loi lobole bhi Moi adhikar ase, etu hukum Moi laga Baba pora paise.” ");
INSERT INTO nag_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Etu kotha karone Yehudi khan laga majote aru kotha namila hoise, aru apaste bhag hoise. ");
INSERT INTO nag_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aru bisi manu koi, “Tai logote bhoot ase, aru tai pagala ase. Kile apuni khan tai laga kotha huni ase?” ");
INSERT INTO nag_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aru dusra koise, “Etu kotha eneka manu laga nohoi jun logote bhoot thakise. Bhoot pora andha laga suku khuli dibo pare naki?” ");
INSERT INTO nag_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aru etu somoite Jerusalem sheher te Samarpan laga Purbb asele. Aru etu thanda din thakise, ");
INSERT INTO nag_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","aru Jisu to Solomon laga veranda kowa jagate aha juwa kori thakise. ");
INSERT INTO nag_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Titia kunba Yehudi khan Taike gheri loise, aru koise, “Apuni kiman deri amikhan ke chinta te rakhibole ase? Jodi Apuni Khrista ase koile amikhan ke koi dibi.” ");
INSERT INTO nag_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisu taikhan ke jowab dise, “Moi tumikhan ke koi dise, aru tumikhan biswas kora nai. Ki kaam Moi laga Baba naam te kori ase, etu he Moi laga sakhi di ase. ");
INSERT INTO nag_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kintu tumikhan biswas nakore kelemane tumikhan Ami laga mer nohoi. ");
INSERT INTO nag_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ami laga mer khan Ami laga awaj hune; Moi taikhan ke jane, aru taikhan Ami laga piche ahe. ");
INSERT INTO nag_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aru Moi taikhan ke anondo jibon diye, aru taikhan kitia bhi namoribo, aru kun bhi taikhan ke Ami laga hath pora chingi loijabo na paribo. ");
INSERT INTO nag_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ami laga Baba, Jun he etu sob Moike dise, Tai sob pora dangor ase, aru kun bhi Baba laga hath pora taikhan ke chingibo na paribo. ");
INSERT INTO nag_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Moi aru Moi laga Baba ekjon ase, ");
INSERT INTO nag_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Titia Yehudi khan Taike mari bole pathor uthaise. ");
INSERT INTO nag_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisu taikhan ke jowab dise, “Moi pora tumikhan ke Moi laga Baba laga bhal kaam bisi dikhai dise. Kuntu kaam karone tumikhan Moike pathor mari bole hoise?” ");
INSERT INTO nag_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yehudi khan Taike jowab dise, “Bhal kaam karone amikhan Apuni ke pathor mari bole nohoi, kintu Isor ke ninda kora, aru tumi manu hoi kene, nije ke Isor bonai thaka karone.” ");
INSERT INTO nag_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisu taikhan ke jowab dise, “Etu tumikhan niyom te likha nai, ‘Moi koise, “Tumikhan bhi Isor ase’”? ");
INSERT INTO nag_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jodi Tai tumikhan ke Isor koile, jun khan logote Isor laga kotha ponchise, - aru Shastro laga kotha khan to bhangi jabole nohoi,- ");
INSERT INTO nag_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tumikhan Taike koi ase jun Baba he alag bonai kene duniya te pathai dise, ‘Tumi ninda kori ase,’ kelemane Moi koise, ‘Moi Isor laga Putro ase’? ");
INSERT INTO nag_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jodi Moi Ami Baba laga kaam nakore, to Moike biswas na koribi. ");
INSERT INTO nag_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kintu jodi Moi kaam kori thakile bhi, tumikhan Moike biswas nokorile, kaam to saikene biswas kori lobi, titia tumikhan jani lobo aru biswas kori lobo Baba pora Moi bhitor te ase aru Moi Tai bhitor te ase.” ");
INSERT INTO nag_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Karone taikhan aru bhi Taike dhori bole korise, kintu Tai taikhan hath pora ulai jaise. ");
INSERT INTO nag_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aru Tai Jordan nodi paar jaga, kot te John prothom baptizma di thakisele, ta te jai kene thaki jaise. ");
INSERT INTO nag_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Titia bisi manu Jisu logote ahi koise, “John to eku chihna dikha diya nai, kintu John pora etu manu laga ki kotha koise, etu sob hosa ase.” ");
INSERT INTO nag_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aru ta te bisi manu Taike biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ekjon bemar thaka manu Lazarus koi kene thakise. Tai, aru bhoini Mary aru Martha khan laga bosti naam to Bethany thakise. ");
INSERT INTO nag_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Aru etu Mary he asele jun pora age te itra tel loi kene Probhu ke abhishek kori kene tai laga chuli pora Jisu laga theng mussi dise, aru bemar Lazarus to tai laga bhai asele. ");
INSERT INTO nag_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Karone tai bhoini khan pora manu pathai kene koise, “Probhu, kunke Apuni morom kore, tai bemar ase.” ");
INSERT INTO nag_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jitia Jisu etu kotha hunise, Tai koise, “Etu bemar to mori jabole laga bemar nohoi, kintu Isor ke mohima aru Manu laga Putro ke mohima hobo karone ase.” ");
INSERT INTO nag_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisu to Martha aru tai bhoini aru Lazarus ke bhi morom kori thakisele. ");
INSERT INTO nag_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Aru jitia Tai hunise Lazarus bemar ase koi kene, Jisu kot te thakise ta te dui din aru rukhi jaise. ");
INSERT INTO nag_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Titia etu pichete, Tai laga chela khan ke koise, “Ahibi, amikhan Judea te aru jabo.” ");
INSERT INTO nag_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tai chela khan Taike koise, “Rabbi, aji kali Yehudi khan Apuni ke pathor mari bole bisari ase, aru Apuni ta te jabole ase?” ");
INSERT INTO nag_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisu jowab dise, “Kile dinte baroh ghanta nathake naki? Jodi kunba dinte beraile tai thogar nakhai, kelemane tai duniya laga ujala ke pai thaka karone. ");
INSERT INTO nag_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kintu jodi kunba rati te beraile, puhor tai logote nathaka karone thogar khai.” ");
INSERT INTO nag_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tai eitu khan kotha koi diya pichete, eneka koise, “Amikhan laga sathi Lazarus ghumai ase, kintu Moi taike uthai dibole jabo.” ");
INSERT INTO nag_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Titia Tai chela khan koise, “Probhu, jodi tai ghumi ase koile, tai basi jabo.” ");
INSERT INTO nag_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisu tai mori bole laga kotha he koise, kintu taikhan to aram pora ghumai thaka kotha he bhabise. ");
INSERT INTO nag_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Titia Jisu taikhan ke sidha koi dise, “Lazarus mori jaise. ");
INSERT INTO nag_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Moi khushi ase, tumikhan karone, Moi ta te thaka nai, etu karone tumikhan biswas kori lobo. Kintu amikhan tai logote jabo.” ");
INSERT INTO nag_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Titia Thomas, junke Didymus bhi koi, tai sathi chela khan ke koise, “Ahibi amikhan bhi jabo Jisu logote moribo karone.” ");
INSERT INTO nag_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Karone jitia Jisu ahise, Tai janise Lazarus ke kobor te rakhi diya char din hoise. ");
INSERT INTO nag_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aru Bethany to Jerusalem usor ase, dui kos he dur nisena te ase. ");
INSERT INTO nag_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aru Yehudi khan bisi Martha aru Mary logote ahise, tai bhai karone mon aram kori dibole. ");
INSERT INTO nag_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jitia Martha hunise Jisu ahi ase, tai lok pabole jaise, kintu Mary to ghor te bohi thakise. ");
INSERT INTO nag_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha pora Jisu ke koise, “Probhu, jodi Apuni yate thakile, moi laga bhai namoribole asele. ");
INSERT INTO nag_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kintu etiya bhi, moi jane Apuni Isor ke ki mangile Isor pora etu Apuni ke dibo.” ");
INSERT INTO nag_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisu taike koise, “Tumi laga bhai aru jinda hoi jabo.” ");
INSERT INTO nag_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha Taike koise, “Moi jane tai aru jee uthibo hekh dinte.” ");
INSERT INTO nag_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisu taike koise, “Moi, he punoruthan aru jibon ase; jun Moike biswas koribo, jodi tai morile bhi, jinda hobo; ");
INSERT INTO nag_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aru jun bhi jinda thake aru Moike biswas kore tai kitia bhi namoribo. Tumi etu kotha biswas kore?” ");
INSERT INTO nag_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tai Jisu ke koise, “Hoi, Probhu, Moi biswas ase Apuni Khrista ase, Isor laga Putro, jun duniya te ahibole thaka jon ase.” ");
INSERT INTO nag_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Aru tai etu koi diya pichete, tai jai jaise aru lukai kene tai bhoini ke koise, “Shika manu yate ahi ase, aru apuni ke mati ase.” ");
INSERT INTO nag_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tai etu huna logote uthi kene Tai logote jaise. ");
INSERT INTO nag_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Titia tak Jisu to bosti te puncha nai, kintu kot te Martha Taike lok korise ta te he thakise. ");
INSERT INTO nag_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Titia jun Yehudi khan tai laga ghor te thakise aru tai laga mon aram koridi thakisele, taikhan Mary to joldi uthi kene juwa dikhise, aru tai kobor te jai kene kandibole jai ase bhabise aru tai laga piche korise. ");
INSERT INTO nag_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jitia Mary to Jisu thaka jagate ponchise, tai Jisu ke dikhi kene Tai theng te giri kene koise, “Probhu, jodi Apuni yate thakile, ami laga bhai namoribole asele.” ");
INSERT INTO nag_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kitia Jisu tai kanda dikhise, aru Yehudi khan tai logote aha khan kanda dikhise, Tai Atma te bisi bhabise aru mon chinta hoise; ");
INSERT INTO nag_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","aru Tai koise, “Tumikhan taike kot te rakhise?” Taikhan Taike koise, “Probhu, ahi kene sabi.” ");
INSERT INTO nag_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisu kandise. ");
INSERT INTO nag_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Titia Yehudi khan koise, “Sabi kiman morom kore ase Lazarus ke!” ");
INSERT INTO nag_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kintu taikhan kunba koise, “Tai age te andha manu laga suku bhal kori diya Tai etu manu na hoi, etu manu ke namoribo dibo para nai?” ");
INSERT INTO nag_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Aru Jisu bisi mon dukh hoi kobor te ahise, etu ekta gufa asele, aru ekta pathor pora dhaki rakhi thakise. ");
INSERT INTO nag_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisu koise, “Pathor ke hatai dibi. Martha, mori juwa laga bhoini, Jisu ke koise, “Probhu, etiya to pucha gundai thakibo, char din hoise.” ");
INSERT INTO nag_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisu taike koise, “Kile, Moi tumike kowa nohoi, jodi tumi biswas korile, tumi Isor laga mohima dikhibo?” ");
INSERT INTO nag_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Titia taikhan pathor ke hatai dise, Jisu Tai suku upor uthai koise, “Baba, Moi Apuni ke dhanyavad di ase, Apuni Ami laga prathana huni luwa karone. ");
INSERT INTO nag_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Moi jane, Apuni Moike hodai hune kintu Ami usorte thaka khan karone Apuni he Moike pathaise, etu jani kene biswas koribo karone Moi etu koi dise.” ");
INSERT INTO nag_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Titia Tai etu koi diya pichete, Tai jor pora hala kori koise, “Lazarus, ulai ahibi!” ");
INSERT INTO nag_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Titia mora manu ulai ahise; aru bhori aru hath kapra pora bandi kene aru Tai mukh ekta gamcha pora dhaki asele, Jisu taikhan ke koise, “Khuli dibi aru taike jabo dibi.” ");
INSERT INTO nag_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Titia bisi Yehudi khan jun Mary logote ahise aru Jisu kaam kori diya dikhi kene biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kintu taikhan kunba Pharisee khan logote jai kene Jisu kaam kori diya sob koi dise. ");
INSERT INTO nag_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Karone mukhyo purohit khan aru Pharisee khan sabha te joma hoi kotha korise, “Amikhan ki korile bhal hobo? Etu manu bisi asurit kori ase. ");
INSERT INTO nag_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jodi amikhan Taike eneka kori thakibo dile, sob manu Taike biswas kori jabo, aru Rome laga cholawta khan ahikena amikhan laga jagah aru jati duita ke bhi amikhan laga hath pora loi lobo.” ");
INSERT INTO nag_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aru taikhan majote sabha laga ekjon manu Caiaphas asele, jun etu saal pora moha purohit laga kaam shuru korisele, tai pora taikhan ke koise, “Tumikhan eku najane. ");
INSERT INTO nag_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sob desh nost huwa pora to ekjon mori juwa he bhal hobo, etu bhi tumikhan na bhabe.” ");
INSERT INTO nag_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Etu tai nijor pora kowa nohoi. Kintu etu saal pora tai moha purohit kaam korise, etu karone tai bhabobani korise Jisu he etu jati manu karone moribo; ");
INSERT INTO nag_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aru khali etu jati karone he nohoi, kintu Isor laga khandan khan, ephale-uphale hoi thaka khan sobke bisari ekta kori bole ase. ");
INSERT INTO nag_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Titia taikhan etu din pora Taike morai dibole bisari thakise. ");
INSERT INTO nag_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Karone, Jisu to aru Yehudi khan majote khula nabera hoise, kintu ta te pora jongol usorte Ephraim koi kene thaka ekta town te Tai chela ke loi ta te thaki jaise. ");
INSERT INTO nag_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aru Yehudi laga Nistar usor asele, titia bosti pora bisi manu nijorke pobitro kori bole Nistar age te Jerusalem jaise. ");
INSERT INTO nag_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Titia taikhan ta te Jisu ke bisarise, aru mondoli te joma hoi kene koise, “Apnikhan ki bhabi ase? Tai etu purbb te nahibo?” ");
INSERT INTO nag_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aru mukhyo purohit khan aru Pharisee khan pora hukum di rakhise, Tai kot te ase etu janile khobor dibole, Taike dhori bole karone. ");
INSERT INTO nag_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Titia, Nistar laga choi din age te Jisu Bethany te ahise, utu jaga juntu te Lazarus thake, kunke Tai mora pora jinda korise. ");
INSERT INTO nag_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Taikhan Tai karone rati laga kha luwa bonai dise, aru Martha sewa korise, kintu Lazarus bhi ta te ekjon mez te Jisu logote bohi asele. ");
INSERT INTO nag_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Titia Mary pora adha liter jiman bisi daam laga tel ani kene Jisu laga theng te lagai dise, aru tai nijor chuli pora Tai theng ke mussi dise, aru litra tel laga sugandh pora pura ghor bhorta hoise. ");
INSERT INTO nag_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kintu Tai laga chela ekjon, Judas Iscariot, jun Taike thogabole ase, koise, ");
INSERT INTO nag_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kile etu tel tin sou dinari pora bikiri kori kene dukhiya khan ke diya nai?” ");
INSERT INTO nag_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tai etu kowa to dukhiya khan nimite chinta karone kowa nohoi, kintu tai chor asele. Taikhan laga poisa jola bhi tai logote ase, aru ta te ki halibo tai etu pora chor kori kene loi thakise. ");
INSERT INTO nag_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Karone Jisu koise, “Tai ekla ke chari dibi. Ami laga moidam diya din karone rakhibo dibi. ");
INSERT INTO nag_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kelemane dukhiya khan tumikhan laga logote hodai thakibo, kintu Moi tumikhan logote hodai nathakibo.” ");
INSERT INTO nag_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Titia bisi Yehudi manu khan janise Jisu ta te ase, aru taikhan ahise, Jisu ekla karone aha nohoi, kintu junke Tai mora pora jinda korise, Lazarus, ke bhi sabole ahise. ");
INSERT INTO nag_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kintu prodhan purohit khan Lazarus ke bhi morai dibole bhabisele; ");
INSERT INTO nag_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kelemane Yehudi khan bisi manu tai karone jai jaise, aru Jisu ke biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Dusra din dangor bhir purbb te ahise. Jitia taikhan hunise Jisu Jerusalem te ahi ase, ");
INSERT INTO nag_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Taikhan palm ghas laga daal ulai ani kene Taike lok kori bole ahise aru jor pora koise, “Hosanna! Probhu laga naam loi kene aha Israel laga Raja, dhoinyo ase.” ");
INSERT INTO nag_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Titia Jisu ekta gadha puwali paikene etu uporte bohi jaise; jineka likha ase, ");
INSERT INTO nag_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Bhoi nokoribi, Zion laga swali, sabi, tumi laga Raja ahi ase, gadha bacha uporte bohi kene.” ");
INSERT INTO nag_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tai chela khan bujibo para nai shuru te; kintu jitia Jisu mohima hoise, taikhan bhabona ahise, etu Tai nimite likha asele, aru manu khan Tai uporte eneka kori diya bhabona ahise. ");
INSERT INTO nag_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Titia bhir khan gawahi dise taikhan bhi Tai logote he thakise jitia Tai Lazarus ke kobor pora ulabi koi kene matise aru mora pora jinda kori dise. ");
INSERT INTO nag_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Karone dangor bhir Taike lok kori bole ahise, kelemane taikhan hunise Tai etu chihna dikhaise. ");
INSERT INTO nag_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Titia Pharisee khan apaste kotha korise, “Sabi, tumikhan eku bhi koribo na paribo; sabi, duniya Tai piche jai ase.” ");
INSERT INTO nag_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Titia aradhana kori bole purbb te aha khan majote kunba Yunani khan bhi asele. ");
INSERT INTO nag_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Karone taikhan Philip logote ahise, jun Galilee jagate Bethsaida town laga manu ase, aru taike hudise, “Sahab, amikhan Jisu ke sabole mon korise.” ");
INSERT INTO nag_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip ahikena Andrew ke koise; Andrew Philip logote jaise, aru taikhan Jisu ke koi dise. ");
INSERT INTO nag_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kintu Jisu taikhan ke jowab dise aru koise, “Etu somoi Manu laga Putro ke mohima hobole ahise. ");
INSERT INTO nag_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hosa Moi tumikhan ke kobo, jitia tak ekta gehu dana matite giri kene namore, etu eneka he thake; kintu jodi etu mori jai, titia bisi dana ulai thake. ");
INSERT INTO nag_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jun nijor jibon morom kore tai harai dibo; kintu jun etu duniya te nijor jibon morom nokorile, tai anondo jibon karone bachibo. ");
INSERT INTO nag_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jodi kun Moike sewa kore, taike Ami laga piche ahibole dibi; aru Moi kun jagate thakibo ta te Ami laga noukar bhi thakibo. Jodi kun Moike sewa koribo, Baba bhi taike sonman koribo. ");
INSERT INTO nag_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Etiya Ami laga Atma bisi chinta ase aru Moi ki kobo? Baba, Moike etu somoi pora bachabi’? Kintu etu somoi karone he Moi ahi ponchise. ");
INSERT INTO nag_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba, mohima hobi Apuni laga naam.” Titia sorgote ekta awaj ahi koise, “Moi etu age te mohima korise, aru bhi mohima kori dibo.” ");
INSERT INTO nag_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Titia ta te khara thaka khan huni koise bhijili marise. Dusra pora koise, “Sorgodoth Tai logote kotha kori ase.” ");
INSERT INTO nag_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisu koise, “Etu awaj Moi karone nohoi, kintu tumikhan nimite ase. ");
INSERT INTO nag_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Etiya etu prithibi ke bisar kori ase; Etiya etu prithibi laga raja ke hatai dibo. ");
INSERT INTO nag_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jitia Moike etu prithibi pora uthai loijabo, Moi logote sob manu ke tani loijabo. ");
INSERT INTO nag_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kintu Tai koise etu dikha bole kineka pora tai moribo. ");
INSERT INTO nag_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Titia bhir khan Taike koise, “Amikhan niyom te likha janise, Khrista hodai thakibo. Kineka Apuni koi ase, ‘Manu laga Putro ke upor loijabo? Kun etu Manu laga Putro ase?’” ");
INSERT INTO nag_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aru Jisu Taikhan ke koise, “Olop somoi karone puhor tumikhan logote ase. Jitia tak tumikhan logote puhor ase titia tak berai thakibi, andhera tumikhan logote napuncha age te, aru jun andhera te berai thake, tai kot te jai najane. ");
INSERT INTO nag_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jitia tak tumikhan logote puhor ase, puhor ke biswas koribi titia tumikhan puhor laga bacha khan hobo.” Jisu eitu khan koise aru taikhan pora luki jaise. ");
INSERT INTO nag_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aru Tai Taikhan ke bisi asurit chihna dikhaise, hoilebi taikhan Taike biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Etu sob hoise Isaiah bhabobadi pora kowa pura hobole karone eitu khan sob hoise: “Probhu, kun amikhan koi diya kotha biswas korise, Aru Probhu laga hath kunke dikhai dise?” ");
INSERT INTO nag_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Karone Taikhan biswas koribo para nai, Isaiah bhi koise, ");
INSERT INTO nag_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tai he taikhan laga suku andha kori dise, aru Tai he taikhan laga mon tan kori dise; Nohoile taikhan suku pora sabo pare aru mon pora bujhi bo pare, Aru taikhan ghuri bo, Aru Moi taikhan ke bhal kori dibo.” ");
INSERT INTO nag_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah etu kotha koise kelemane tai Jisu laga mohima dikhise aru Tai nimite koise. ");
INSERT INTO nag_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kintu eneka hoilebi, bisi Yehudi cholawta khan Jisu ke biswas kori loise; kintu Pharisee khan karone, taikhan grohon kora nai, taikhan mondoli pora ulai dibo bhoi pora khuli dikhai diya nai. ");
INSERT INTO nag_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kelemane taikhan Isor prosansa pora to manu laga prosansa he bhal pai thakise. ");
INSERT INTO nag_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Titia Jisu jor pora koise, “Kun Moike biswas kore, Moike he biswas kora nohoi kintu Moike pathai diya ke biswas kore, ");
INSERT INTO nag_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","aru jun Moike dikhise Moike pathai diya ke bhi dikhise. ");
INSERT INTO nag_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Moi prithibi te puhor hoi ahise, jun Moike biswas kore tai andhera te nathakibo. ");
INSERT INTO nag_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jodi kunba Moi laga kotha huni kene namane, Moi taike bisar nakore; kelemane Moi prithibi ke bisar kori bole aha nohoi, kintu prithibi ke bacha bole he ahise. ");
INSERT INTO nag_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jun Moike grohon nakore, aru Moi laga kotha ke grohon nakore, taike bisar kori bole ekjon ase, motlob ji kotha Moi koi dise etu he hekh dinte taike bisar koribo. ");
INSERT INTO nag_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kelemane Moi nijor pora kotha kowa nohoi, kintu Baba jun he Moike pathaise, Tai he Moike hukum dise ki jonai dibo lage aru ki kobo lage. ");
INSERT INTO nag_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Moi jane Tai laga hukum anonto jibon ase, etu Moi thik pora jani ase- etu karone jineka Baba pora Moike kotha koi, eneka he Moike koidi thake.” ");
INSERT INTO nag_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Etiya Nistar purbb din age te, Jisu jani jaise Tai etu duniya chari kene Baba logote jabole somoi ahise. Kunkhan Tai logote duniya te thakise, eitu khan ke Tai morom kori ahise, aru tineka hekh tak morom korise. ");
INSERT INTO nag_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Aru jitia taikhan eke logot te rati laga kha-luwa kori thakise, titia Simon laga chokra Iscariot Judas laga monte bhoot ghusi se, Jisu ke thogai bole nimite. ");
INSERT INTO nag_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisu jani thakise Baba he sob jinis khan Taike dise, aru Tai Isor pora ahise aru Isor logote wapas jabole ase. ");
INSERT INTO nag_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tai kha luwa somoite uthi kene Tai nijor kapra ulai rakhi kene ekta gamcha loise aru Tai laga nijor komor bandi loise. ");
INSERT INTO nag_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Titia Tai borton te pani hali kene chela khan laga theng dhui dise aru gamcha Tai komor te bandi thaka ke loise aru taikhan laga theng mussi dise. ");
INSERT INTO nag_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jitia Tai Simon Peter logote ponchise, Peter Taike koise, “Probhu, Apuni ami laga theng dhubo?” ");
INSERT INTO nag_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisu taike jowab di koise, “Moi ki kori ase etu etiya tumi najane, kintu etu pichete tumi jani jabo.” ");
INSERT INTO nag_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter Taike koise, “Apuni ke ami laga theng dhubo nadibo,” Jisu taike koise, “Jodi Moi tumike nadholaile, tumi Moi phale eku bhi hisa nai.” ");
INSERT INTO nag_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter Taike koise, “Probhu, khali ami laga theng he nohoi, kintu hath aru matha bhi dhui dibi.” ");
INSERT INTO nag_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisu taike koise, “Jun gaw dhui loise tai to khali theng he dhuile hoise, dusra sob sapha ase, aru tumikhan sapha ase; kintu tumikhan sob nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","- Kelemane Jisu jani thakise kun Taike dhori bole ase; etu karone Tai koise,“Tumikhan sob sapha nohoi.”- ");
INSERT INTO nag_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jitia Tai taikhan laga theng dhuwa hoise, Tai nijor kapra lagai loise aru bohi jaise, aru taikhan ke koise, “Tumikhan bujhi se Moi tumikhan karone ki korise? ");
INSERT INTO nag_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tumikhan Moike ‘Shika manu,’ ‘Probhu,’ eneka koi aru tumikhan thik koi ase, kelemane Moi etu he ase. ");
INSERT INTO nag_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jodi Moi Shika manu aru Probhu hoi kene tumikhan laga theng dhuile, tumikhan bhi ekjon-ekjon laga theng dhubo lage. ");
INSERT INTO nag_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kelemane Moi tumikhan ke motlob dikhai dise, tumikhan bhi tineka kori thakibi. ");
INSERT INTO nag_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Hosa pora Moi tumikhan ke kobo, ekjon nokor to tai malik pora dangor nohoi; aru khobor diya manu ekjon khobor pathai diya manu pora dangor nohoi. ");
INSERT INTO nag_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jodi tumikhan eitu khan jane, aru mani thakile tumikhan asishit hobo. ");
INSERT INTO nag_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Moi tumikhan sob laga kotha kowa nohoi; Moi junke basi loise taikhan he jane- kintu Shastro he pura hobo karone eneka hoise: ‘Kun Ami logote bhaat khai ase, etu he Moike laat marise.’ ");
INSERT INTO nag_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Moi tumikhan ke etiya etu nohua age te koi diya to, etu kitia hobo, tumikhan biswas koribo MOI ASE. ");
INSERT INTO nag_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Hosa pora Moi tumikhan ke kobo, kun Moi patha diya ke grohon kore, tai Moike grohon kori ase, aru jun Moike grohon korise, tai Moike patha Jonke grohon kori loise.” ");
INSERT INTO nag_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jitia Jisu etu sob kowa hoise, Tai Atma te bisi dukh hoise. Tai gawahi dikene koise, “Hosa pora Moi tumikhan ke kobo tumikhan majote ekjon Moike thogai dibole ase.” ");
INSERT INTO nag_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chela khan ekjon-ekjon ke saise, asurit hoi kene etu kun hobo hudise. ");
INSERT INTO nag_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kintu ekjon chela junke Jisu morom kore, tai Jisu laga usorte mez te matha niche kori bohi thakise. ");
INSERT INTO nag_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Karone Simon Peter taike ishara kori kene koise, “Tai kun laga kotha koi ase amikhan ke koi dibi.” ");
INSERT INTO nag_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Titia tai Jisu laga chati usorte niche kori kene Jisu ke koise, “Probhu, etu kun ase?” ");
INSERT INTO nag_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisu koise, “Etu junke Moi roti bhi jai kene dibo etu he tai ase.” Aru Tai ekta roti uthaikene bhi jaise aru Simon laga chokra Iscariot Judas ke dise. ");
INSERT INTO nag_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Aru tai etu roti luwa pichete Saitan tai laga monte ghusi jaise, titia Jisu taike koise, “Tumi ki kori bole ase joldi koribi.” ");
INSERT INTO nag_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kintu mez usorte boha khan kunbi Tai etu kotha kele koise etu bujibo para nai. ");
INSERT INTO nag_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kunba bhabise, Judas hathte poisa laga jola thaka karone, Jisu taike koise, “Kiba kinibi amikhan lage purbb karone,” nohoile dukhiya khan ke kiba dibole. ");
INSERT INTO nag_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jitia tai roti loise, tai joldi bahar te ulai jaise, aru etu somoi rati asele. ");
INSERT INTO nag_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Karone, jitia Judas ulai jaise, Jisu koise, “Etiya Manu laga Putro mohima hoise, aru Tai dwara Isor mohima hoise. ");
INSERT INTO nag_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Isor pora taike mohima koribo Tai nijor aru Taike joldi mohima hobo dibo. ");
INSERT INTO nag_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Chutu bacha khan, Moi olop somoi tumikhan logote ase. Tumikhan Moike bisaribo, aru Moi Yehudi cholawta khan ke kowa nisena, ‘Moi kot te jai ase, ta te tumikhan ahibo na paribo. Etiya Moi pora tumikhan ke koi ase. ");
INSERT INTO nag_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Moi tumikhan ke notun hukum di ase, tumikhan ekjon-ekjon ke morom koribi; Moi tumikhan ke morom kora nisena, tumi bhi ekjon-ekjon ke morom koribi. ");
INSERT INTO nag_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Etu karone sob manu pora tumikhan to Moi laga chela ase koi kene jani lobo, jodi tumikhan ekjon-ekjon ke morom korile. ");
INSERT INTO nag_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter Taike koise, “Probhu, Apuni kote jabole ase?” Jisu taikhan koise, “Moi kote jabole ase, tumi etiya Moi laga piche ahibo na paribo, kintu pichete tumi Ami laga piche ahibo.” ");
INSERT INTO nag_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter Taike koise, “Probhu, kele, moi etiya Apuni laga piche ahibo napare? Moi to Apuni karone nijor jibon bhi dibo.” ");
INSERT INTO nag_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisu taike koise, “Tumi Moi nimite tumi nijor jibon dibo? Hosa pora Moi tumike kobo, jitia tak tumi tin bar Moike najane nokoi, titia tak murga hala nokorile.” ");
INSERT INTO nag_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Tumi laga mon chinta nohobi. Tumi Isor ke biswas koribi, aru Moike bhi biswas koribi. ");
INSERT INTO nag_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ami laga Baba laga ghor te jagah bisi ase, jodi nohoi, to Moi tumikhan ke koi dibo, kelemane Moi tumikhan karone jagah taiyar kori bole jai ase. ");
INSERT INTO nag_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aru jodi Moi jai kene tumikhan karone jagah taiyar kori loile, Moi aru ahikena tumikhan ke loijabo, aru kot te Moi thakibo ta te tumikhan ke bhi thakibo dibo. ");
INSERT INTO nag_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tumikhan Moi kot te jai ase etu rasta jani kene ase.” ");
INSERT INTO nag_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas pora Jisu ke koise, “Probhu, amikhan najane Apuni kot te jai ase, tinehoile amikhan kineka rasta janibo?” ");
INSERT INTO nag_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisu taike koise, “Moi he rasta ase, aru hosa ase aru jibon ase; kun bhi Baba logote jabo napare Moi pora nohoile. ");
INSERT INTO nag_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jodi tumikhan Moike janile, Moi laga Baba ke bhi janibole asele. Aru etiya pora tumikhan jani loise, aru Taike dikhi loise.” ");
INSERT INTO nag_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip pora Jisu ke koise, “Probhu, amikhan ke Baba dikhai dibi, etu he amikhan karone kafi hobo.” ");
INSERT INTO nag_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisu taike koise, “Philip, Moi iman din tumikhan logote ase tumi etiya bhi Moike janibo para nai? Jun Moike dikhise tai bhi Baba ke dikhi loise. Kineka tumi koi ase, ‘Amikhan ke Baba dikhai dibi’? ");
INSERT INTO nag_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tumikhan biswas nakore Moi Baba logot aru Baba Moi logote ase kowa to? Ki kotha Moi tumikhan ke koise, Moi nijor khushi pora kowa nohoi, kintu Baba he Ami logote thake aru Ami dwara Tai laga kaam kori thake. ");
INSERT INTO nag_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Moi Baba logote ase koi kene biswas koribi, aru Baba Ami logote ase koi kene biswas koribi, nohoile kaam khan saikene hoile bhi Moike biswas koribi. ");
INSERT INTO nag_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Hosa, pora Moi tumikhan ke kobo, jun Moike biswas koribo, tai Moi ki kaam korise, tai bhi koribo, aru tai etu pora bhi bisi dangor kaam koribo kelemane Moi Baba logote jai ase. ");
INSERT INTO nag_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tumikhan Ami laga naam pora ki mangibo, eitu khan sob Moi koribo, Putro nimite Baba mohima hobo karone. ");
INSERT INTO nag_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jodi tumikhan Moi laga naam pora mangibo, Moi etu kori dibo. ");
INSERT INTO nag_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jodi tumikhan Moike morom kore, Ami laga hukum khan manibo, ");
INSERT INTO nag_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aru Moi pora Baba ke prathana koribo, aru Tai tumikhan karone aru dusra ekjon Modot Diya Jon pathai dibo, Tai hodai tumikhan logote thaki jabo- ");
INSERT INTO nag_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","etu hosa laga Atma ase. Duniya pora Taike janibole para nai kelemane etu Taike nadikhe, aru najane. Kintu tumikhan to jane, kelemane Tai tumikhan logote thake aru tumikhan bhitor te thake. ");
INSERT INTO nag_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Moi tumikhan ke anath hobo nadibo; Moi tumikhan logote wapas ahibo. ");
INSERT INTO nag_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Olop homoi karone etu duniya te Moike nadikhibo, kintu tumikhan to Moike dikhibo. Kelemane Moi jinda ase, tumikhan bhi jinda thakibo. ");
INSERT INTO nag_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Utu din tumikhan janibo Moi Baba logote ase, aru tumikhan Ami logote aru tumikhan logote Moi ase. ");
INSERT INTO nag_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kun pora Ami laga hukum khan loi ase aru cholai thake, taikhan he Moike morom kora khan ase, aru kun Moike morom kore, Baba bhi taike morom koribo, aru Moi taike morom koribo aru taike Moi nijor dikhai dibo.” ");
INSERT INTO nag_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas -Iscariot nohoi- Jisu ke koise, “Probhu, kele Apuni nijorke amikhan logot dikhai dibo, kintu prithibi ke nohoi, etu kineka hobo?” ");
INSERT INTO nag_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisu jowab dikena taike koise, “Jodi kun bhi Moike morom kore, tai Ami laga kotha rakhibo. Moi laga Baba taike morom koribo, Ami duijon bhi tai logote ahibo aru tai logote Ami laga ghor bonabo. ");
INSERT INTO nag_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jun Moike morom nakore, tai Ami laga kotha khan ke narakhe, aru ki kotha tumikhan huni loise, etu Ami laga kotha nohoi kintu Baba laga ase, Jun pora Moike pathaise. ");
INSERT INTO nag_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Moi eitu khan sob kotha koi dise, tumikhan logote thaka somoite. ");
INSERT INTO nag_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kineka, Modot Diya Jon, Pobitro Atma, jun Baba he Ami laga naam pora pathai dibo- Tai sob apnikhan ke sikhai dibo, aru ki Moi apnikhan ke koise etu sob apnikhan ke aru bhi monte ahibo dibo. ");
INSERT INTO nag_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Moi apnikhan ke shanti rakhidibo; Moi apuni ke Ami laga shanti di ase. Moi diya to prithibi pora diya nisena nohoi. Tumi laga mon chinta nohobi aru bhoi nokoribi. ");
INSERT INTO nag_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Moi eneka kuwa apnikhan hunise, ‘Moi jai ase, aru Moi apuni khan logote wapas ahibo.’ Jodi apnikhan Moike morom kore, apnikhan etu pora khushi hobo lage, Moi Baba logote jai ase, kelemane Moi nohoi kintu Baba he dangor ase. ");
INSERT INTO nag_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Etu sob huwa age te Moi apnikhan ke koidi ase, jitia etu sob hoi jabo, titia apnikhan biswas kori lobo. ");
INSERT INTO nag_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Moi apnikhan logote bisi kotha nakoribo, kelemane etu prithibi laga cholawta ahi ase. Tai Moike eku koribo na paribo, ");
INSERT INTO nag_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kintu Moi Baba ke morom kora prithibi ke jonai dibo karone aru jineka Baba he Moike hukum dise eitu khan sob kori thake, uthibi Amikhan yate pora jai jabo.” ");
INSERT INTO nag_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Moi asol angur ghas ase, aru Moi laga Baba he bagan kora jon ase. ");
INSERT INTO nag_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Moi pora ula daal juntu te jodi phol naulai, Tai etu hatai diye; aru kuntu daal pora phol dibo, Tai etu pora aru bisi phol dibo karone bhal pora sai rakhi diye. ");
INSERT INTO nag_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Moi tumikhan ke koi diya kotha pora tumikhan sapha hoise. ");
INSERT INTO nag_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ami logote thakibi, aru Moi bhi tumi logote thakibo. Jodi daal to ghas te nathakile nijor phol dibo napare, tineka tumikhan bhi Ami logote nathakile phol dibo na paribo. ");
INSERT INTO nag_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Moi angur ghas ase aru tumikhan daal khan ase. Jun Ami logote thake aru Moi tai logote thake, tai bisi phol dibo, kelemane tumikhan Moi pora alag hoi kene eku koribo napare. ");
INSERT INTO nag_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jodi kunba Ami logote nathake, taike phelai dibo, aru ekta daal nisena, sukhi jabo, aru manu pora etu joma kori kene jui te di dibo, aru eitu khan ke jolai diye. ");
INSERT INTO nag_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jodi tumikhan Moi logote thake, aru Ami laga kotha tumikhan logote thake, tumi ki lage etu mangibi, titia etu tumikhan karone kori dibo. ");
INSERT INTO nag_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tumi laga phol bisi ulaile Baba laga mohima hobo, aru etu pora tumikhan Ami laga chela koribo paribo. ");
INSERT INTO nag_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jineka Baba Moike morom korise, tineka Moi bhi tumikhan ke morom korise. Ami laga morom te thakibi. ");
INSERT INTO nag_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jodi tumi Ami laga hukum manile, Ami laga morom te thakibo, jineka Moi Baba laga kotha mani ahise aru Taike morom kori ahise. ");
INSERT INTO nag_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Moi etu kotha tumikhan ke etu karone koise, Ami laga anond tumikhan logote thaki bole, aru tumi laga anond pura hobo karone. ");
INSERT INTO nag_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Etu Ami laga hukum ase, tumikhan ekjon-ekjon ke morom koribi jineka Moi tumikhan ke morom kore. ");
INSERT INTO nag_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kunba tai sathi khan karone nijor jibon diya- etu pora dangor morom aru nai. ");
INSERT INTO nag_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tumi Ami laga sathi ase jodi tumi Moi diya hukum mani thakile. ");
INSERT INTO nag_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aru Moi tumikhan ke nokorkhan namatibo, kelemane nokor tai malik ki kore najane. Kintu Moi tumikhan ke sathi koise, kelemane Moi ki kotha Ami laga Baba pora hunise etu sob tumikhan ke koi dise. ");
INSERT INTO nag_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tumikhan Moike basi luwa nohoi, kintu Moi he tumikhan ke basi loise, aru tumikhan ke tel lagai kene pobitro kori loise, tumikhan phol dhora to hodai thaki bole karone. Eneka hoile, tumikhan Ami laga naam te Baba ke mangibo, aru Tai etu tumikhan ke dibo. ");
INSERT INTO nag_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Etu hukum Moi tumikhan ke di ase, tumikhan ekjon-ekjon ke morom koribi. ");
INSERT INTO nag_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jodi duniya pora tumikhan ke ghin korile bhi tumikhan jani ase, etu tumikhan age te Moike ghin korise. ");
INSERT INTO nag_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jodi tumikhan duniya laga ase, titia duniya pora tai nijor nisena morom kori bole thakise. Kintu tumikhan duniya laga nohoi, kintu Moi he etu duniya pora tumikhan ke basi loise, kelemane duniya tumikhan ke ghin kore. ");
INSERT INTO nag_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ami pora kowa kotha yaad koribi, ‘Ekjon nokor tai laga malik pora dangor nohoi.’ Jodi taikhan pora Amike dukh dise koile, taikhan pora tumikhan ke bhi dukh dibo; jodi taikhan Ami laga kotha manile tumikhan laga kotha bhi manibo. ");
INSERT INTO nag_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kintu Moi karone etu sob tumikhan uporte koribo, kelemane taikhan Moike pathai diya ke najane. ");
INSERT INTO nag_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Jodi Moi nahile aru taikhan ke nokoile, taikhan laga paap nathakibo asele, kintu etiya taikhan nijor paap karone eku bahana nai. ");
INSERT INTO nag_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jun Moike ghin korise tai Ami laga Baba ke bhi ghin korise. ");
INSERT INTO nag_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jodi Moi kun pora bhi koribo napara kaam kori dikhai diya nai koile taikhan laga paap nathakibo asele, kintu etiya taikhan Moi kori diya khan ke dikhise, aru Moi aru Moi laga Baba ke bhi ghin korise. ");
INSERT INTO nag_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aru etu taikhan laga niyom te likha ase, ‘Taikhan Moike eku golti nathaki kene ghin korise,’ etu pura hoi jabo karone hoise. ");
INSERT INTO nag_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jitia Modot Diya Jonke Moi tumikhan logote pathabo Jun ase Baba pora aha hosa Atma, etu he Amike gawah dibo. ");
INSERT INTO nag_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kintu tumikhan bhi gawah ase kelemane shuru pora tumikhan Ami logote ase. ");
INSERT INTO nag_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Tumikhan nagiribo karone Moi etiya sob koi ase. ");
INSERT INTO nag_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Taikhan tumikhan ke mondoli khan pora ulai dibo. Kintu somoi ahi ase, jitia tumikhan ke morai diya khan bhabibo taikhan Isor ke sewa te daan di ase. ");
INSERT INTO nag_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Taikhan tineka sob koribo kelemane taikhan Baba aru Moike najana. ");
INSERT INTO nag_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kintu Moi tumikhan ke eitu khan sob koi dibo, eneka hoile jitia taikhan laga somoi ahibo, tumikhan bhabona ahibo Moi tumikhan ke koi diya to. Kintu Moi shuru te etu kotha tumikhan ke kowa nai, kele koile Moi tumikhan logote he thaka karone. ");
INSERT INTO nag_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kintu Moi etiya Moike pathai diya logote jai ase, kintu kun bhi eneka Moike huda nai, ‘Apuni kot te jabole ase?’ ");
INSERT INTO nag_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kintu Moi tumikhan ke etu kotha kowa karone, tumikhan mon dukh hoise. ");
INSERT INTO nag_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kintu Moi tumikhan ke hosa kobo, Moi jaile tumikhan karone bhal hobo. Karone jodi Moi najaile, Modot Diya Jon to tumikhan logote nahibo, kintu Moi ja pichete he, Moi Taike tumikhan karone pathai dibo. ");
INSERT INTO nag_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aru jitia Tai ahibo, Modot Diya Jon pora prithibi ke paap laga golti, dhormik kaam laga aru Isor pora bisar kora sob prithibi ke jonai dibo- ");
INSERT INTO nag_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Paapkhan bhi, kelemane taikhan Moike biswas nakora karone; ");
INSERT INTO nag_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","aru dhormik kotha bhi, kelemane Moi Baba logote jai ase aru tumikhan Moike aru nadikhibo; ");
INSERT INTO nag_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","aru bisar kotha bhi, kelemane etu duniya laga cholawta khan ke bisar kori loise. ");
INSERT INTO nag_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Moi etiya bhi tumikhan ke bisi kotha kobole ase, kintu tumikhan etiya etu dhorjo koribo na paribo. ");
INSERT INTO nag_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Hoilebi jitia, Hosa laga Atma ahibo, Tai tumikhan ke sob hosa rasta dikhai dibo, kelemane Tai nijor pora eku bhi nokobo. Kintu Tai ki hune, Tai etu he kobo, aru ki ahibole ase etu sob tumikhan ke koi dibo. ");
INSERT INTO nag_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tai Moike mohima koribo, kelemane Tai Ami laga kotha loi kene tumikhan ke jonai dibo. ");
INSERT INTO nag_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sob bostu kuntu Baba laga ase, etu sob Moi laga ase. Etu karone, Moi koise Atma pora Moi laga kotha loi kene tumikhan ke sob jonai dibo. ");
INSERT INTO nag_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Olop somoi pichete tumikhan Moike nadikhibo, aru olop somoi pichete tumikhan Moike aru dikhibo.” ");
INSERT INTO nag_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Titia Tai chela te kunba ekjon-ekjon kotha korise, “Tai amikhan ke ki koi ase, ‘Olop pichete tumikhan Moike nadikhibo, aru olop somoi pichete tumikhan Moike aru dikhibo,’ aru ‘kelemane Moi Ami laga Baba logote jai ase’? ");
INSERT INTO nag_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Karone taikhan koise, “Etu Tai ki koi ase, ‘Olop somoi’? Amikhan najane.” ");
INSERT INTO nag_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisu janise taikhan Taike hudibole mon kori ase, aru Tai koise, “Tumikhan apaste ‘olop somoi pichete tumikhan Moike nadikhibo, aru olop somoi pichete tumikhan aru Moike dikhibo’ kowa laga kotha ke huda-hudi kori ase? ");
INSERT INTO nag_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Hosa pora Moi tumikhan ke kobo, tumikhan kandibo aru dukh koribo, kintu duniya to khushi koribo. Tumikhan mon dukh koribo, kintu tumikhan mon dukh kora to khushi te bodli hoi jabo. ");
INSERT INTO nag_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jitia maiki jonom dibole somoi ahijai, tai mon dukh kori thake, kelemane tai dukh somoi ahise, kintu jitia tai bacha ke jonom pai loi, tai dukh sob pahori jai kelemane ekjon etu duniya te jonom huwa karone. ");
INSERT INTO nag_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Karone tumikhan etiya mon dukh kori ase, kintu Moi tumikhan ke aru lok pabo, aru tumikhan mon khushi pabo, aru tumikhan laga anond kun bhi chingi loi najabo. ");
INSERT INTO nag_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Aru etu dinte tumikhan Moike eku bhi namangibo. Hosa, Moi tumikhan ke kobo, jodi tumikhan Ami laga naam pora Baba logote kiba mangile, Tai tumikhan ke dibo. ");
INSERT INTO nag_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Etiya tak tumikhan Ami laga naam te eku bhi manga nai. Mangibi, aru tumi pai jabo, aru tumi laga khushi pura hoi jabo. ");
INSERT INTO nag_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Moi etu tumikhan ke dristanto pora koi ase, kintu Moi tumikhan ke dristant nohoi kene khula- khuli pora Baba laga kotha kobole somoi ahi ase. ");
INSERT INTO nag_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Etu dinte tumikhan Ami laga naam pora mangibo, aru Moi tumikhan karone Baba pora mangibo kowa nohoi, ");
INSERT INTO nag_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kelemane Baba nijor tumikhan ke morom kore, kele koile tumikhan Moike morom korise, aru Moi Baba pora ahise koi kene tumikhan biswas korise. ");
INSERT INTO nag_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Moi Baba pora ahise, aru Moi duniya te ahise. Aru bhi, Moi duniya chari kene Baba logote jabole ase.” ");
INSERT INTO nag_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tai chela khan koise, “Sabi, etiya to Apuni dristanto pora nohoi kintu khula-khuli koi ase. ");
INSERT INTO nag_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Etiya amikhan jani loise Apuni sob jane koi kene, aru kunbi Apuni ke eku hudibole dorkar nai. Eitu khan nimite, amikhan biswas kori ase Apuni Isor pora ahise.” ");
INSERT INTO nag_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisu taikhan ke hudise, “Tumikhan etiya biswas kori ase? ");
INSERT INTO nag_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sabi, etu somoi ahi ase, hoi ahi jaise, jitia tumikhan sob ephale-uphale hoi kene nijor ghor te jai jabo, aru Moike ekla chari dibo. Hoilebi Moi ekla nohoi kelemane Baba Moi logote ase. ");
INSERT INTO nag_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Moi apnikhan ke etu kotha koi dise karone apnikhan Moi pora shanti pabo. Etu prithibi te dukh pabo, kintu mon dangor koribi, Moi prithibi uporte jiti loise.” ");
INSERT INTO nag_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisu pora etu sob kotha koi diya pichete Tai sorgo phale saikene prathana korise, “Baba, somoi ahi ponchise, Putro pora Apuni ke mohima koribo karone Chora ke mohima kori dibi- ");
INSERT INTO nag_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Apuni pora he sob manu uporte Taike adhikar dise aru etu pora he jun khan Apuni pora Taike dise, taikhan sobke anonto jibon pabo nimite. ");
INSERT INTO nag_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Etu he anonto jibon ase: taikhan pora Apuni he hosa Isor ase koi kene janibole, aru Jisu Khrista ke Jun Apuni pathai dise. ");
INSERT INTO nag_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Moi etu prithibi te Apuni ke mohima kori dise. Moi kaam khotom hoise juntu Apuni Moike kori bole dise. ");
INSERT INTO nag_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Etiya, Baba etu duniya bona age te Moi Apuni logote mohima te thaka nisena, etiya Apuni logote mohima hobole dibi. ");
INSERT INTO nag_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Moi Apuni laga naam taikhan ke dikhai dise, jun khan Apuni he duniya pora Moike dise. Taikhan Apuni laga asele aru Apuni he taikhan ke Moi logote dise aru taikhan Apuni laga kotha mani loise. ");
INSERT INTO nag_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Etiya taikhan jani loise, sob to Apuni Moike dise, sob Apuni pora ahise koi kene, ");
INSERT INTO nag_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kelemane ki kotha Apuni Moike dise, Moi taikhan ke koi dise. Aru taikhan etu grohon kori loise, aru Moi, Apuni pora aha jani loise, aru Apuni he Moike pathaise etu ke biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Moi taikhan karone prathana kori ase. Moi etu duniya karone kora nai, kintu jun khan Apuni Moike dise, kelemane taikhan Apuni laga ase. ");
INSERT INTO nag_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Aru Ami laga ki ase, sob Apuni laga ase aru ki Apuni laga ase, sob Ami laga ase, aru Moi etu pora mohima hoise. ");
INSERT INTO nag_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Etiya Moi duniya te bisi din nathakibo, kintu eitu khan to duniya laga manu ase, aru Moi to Apuni logote ahi ase. Pobitro Baba, Apuni naam pora rakhi lobi jun khan Apuni Moike dise, taikhan ekta hobo dibi jineka Amikhan bhi ekta ase. ");
INSERT INTO nag_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jitia tak Moi taikhan logote ase, Moi Apuni laga naam pora, ki Apuni Moike dise eitu khan roikhya korise. Aru taikhan kunke bhi harai diya nai, khali khotom hobo thaka ke nohoile, jineka Shastro te likha ase etu pura hobo karone. ");
INSERT INTO nag_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kintu etiya Moi Apuni logote ahi ase, aru Ami laga khushi taikhan monte pura hobo karone Moi etu duniya te thaka somoite koi dise. ");
INSERT INTO nag_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Moi Apuni laga kotha taikhan ke koi dise, aru duniya pora taikhan ke ghin korise, kelemane jineka Moi duniya laga nohoi tineka taikhan bhi duniya laga nohoi. ");
INSERT INTO nag_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Moi taikhan ke etu duniya pora uthai loijabi koi kene Apuni ke prathana kora nohoi, kintu taikhan ke biya jon pora bachai rakhibi koi kene binti kori ase. ");
INSERT INTO nag_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taikhan duniya laga nohoi, jineka Moi duniya laga nohoi. ");
INSERT INTO nag_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Taikhan ke hosa dikena alag kori lobi. Apuni laga kotha to hosa ase. ");
INSERT INTO nag_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jineka Apuni Moike duniya te pathaise, tineka Moi bhi taikhan ke duniya te pathai dise. ");
INSERT INTO nag_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Aru taikhan karone Moi nijorke alag rakhise, taikhan bhi nijorke hosa pora alag rakhibo karone. ");
INSERT INTO nag_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Moi khali etu karone binti kora nohoi, kintu taikhan ke bhi, jun khan taikhan kotha pora Moike biswas koribo sob karone binti ase, ");
INSERT INTO nag_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","taikhan ke bhi ekta hobole dibi, jineka Apuni, Baba, Moi logote ase, aru Ami Apuni logote ase, eneka taikhan bhi Amikhan logote thaki bole, eneka pora duniya biswas koribo Apuni he Amike pathaise koi kene. ");
INSERT INTO nag_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Aru mohima juntu Apuni Moike dise, Moi taikhan ke di dise, karone taikhan bhi ekta hobole nimite, jineka Amikhan ekta ase. ");
INSERT INTO nag_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Moi taikhan logote aru Apuni Ami logote- taikhan ekta hobole, aru Apuni he Moike pathaise koi kene prithibi he janibole, aru Apuni Moike morom kora nisena, taikhan ke bhi morom korise. ");
INSERT INTO nag_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baba, Ami laga itcha ase jun khan Apuni Moike dise, taikhan bhi kot te Moi thakibo ta te Moi logote thaki bole, tinehoile taikhan Moi laga mohima ke dikhibo, kele koile duniya bona age te Apuni Moike morom kori ahise. ");
INSERT INTO nag_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dharmik Baba, prithibi Apuni ke jana nai, kintu Moi Apuni ke jane; aru eitu khan to Apuni pora Moike pathaise koi kene jani loise. ");
INSERT INTO nag_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aru Moi Apuni naam taikhan ke koi dise, aru koi thakibo, juntu morom Apuni Moike dise, etu morom taikhan monte thaki bole, aru Moi taikhan logote thaki bole.” ");
INSERT INTO nag_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Titia Jisu etu kotha koi diya pichete, Tai chela khan ke loi Kidron Bhoyam kinar pora jaise, ta te ekta bagan asele, juntu jagate Tai aru chela khan jaise. ");
INSERT INTO nag_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Titia Judas, jun Taike thogai dibole ase, tai bhi etu jagah jani thakise, kelemane poila bhi Jisu Taikhan ke loi ta te jai thakisele. ");
INSERT INTO nag_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Titia Judas, sipahi aru mukhyo purohit aru Pharisee aru adhikari khan sakhi, mashal, aru hathiar khan loi kene ahise. ");
INSERT INTO nag_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Titia Jisu, etu sob jinis Tai upor ahibo thaka jani kene, Tai taikhan logote ahikena hudise, “Apnikhan kunke bisari ase?” ");
INSERT INTO nag_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Taikhan Taike jowab dise, “Nazareth Jisu ke.” Jisu taikhan ke koise, “Moi ase.” Kintu Judas, Taike thogai dibole aru dhoribo thaka manu bhi sipahi khan logote khara thakise. ");
INSERT INTO nag_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Karone jitia Tai taikhan ke koise, “Moi ase,” taikhan pichete hati kene matite giri jaise. ");
INSERT INTO nag_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Titia Tai aru taikhan ke aru hudise, “Kunke tumikhan bisari ase?” Aru taikhan koise, “Nazareth Jisu ke.” ");
INSERT INTO nag_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisu jowab dise, “Moi tumikhan ke koise Moi ase. Jodi tumikhan Moike bisari ase koile, poila eitu khan ke jabo dibi.” ");
INSERT INTO nag_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Etu pura kori bole karone hoise jun to kotha Tai age te koisele; “Apuni Moike diya khan, Moi ekjon ke bhi harai diya nai.” ");
INSERT INTO nag_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Titia Simon Peter logote talwar thakise, aru tai etu ke ulaikene moha purohit nokor laga dyna kaan kati dise. Etu nokor laga naam Malchus asele. ");
INSERT INTO nag_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Karone Jisu Peter ke koise, “Tumi laga talwar nijor jagate rakhi dibi. Juntu kup Baba he Moike dise, Moi etu pora khabo nalage naki?” ");
INSERT INTO nag_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Titia Rome laga sipahi khan aru taikhan laga sahab aru Yehudi khan laga adhikari khan Jisu ke dhori loise aru Taike bandhi loise. ");
INSERT INTO nag_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Aru prothom te, Taike loi kene Annas logote jaise, jun Caiaphas laga sasur asele, jun he etu saal pora moha purohit kaam kori asele. ");
INSERT INTO nag_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Aru poila dinte Yehudi khan ke nirdes diya, jun koise sob manu nost huwa pora ekjon mori juwa he bhal ase kowa to etu Caiaphas he asele. ");
INSERT INTO nag_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kintu Simon Peter aru dusra ekjon chela bhi Jisu ke piche kori ahise. Aru etu chela to moha purohit logote chihnaki thakisele, karone tai Jisu logote moha purohit laga veranda te jaise; ");
INSERT INTO nag_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kintu Peter to dorja laga bahar te khara hoise. Titia dusra chela jun he moha purohit logote chihnaki ase, bahar jai kene dorja rukhi thaka mahila ke koi kene Peter ke bhitor loi anise. ");
INSERT INTO nag_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Titia etu nokorni jun he dorja ke sai thakise, tai Peter ke koise, “Apuni bhi etu manu laga chela nohoi?” Tai koise, “Moi to nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Etu jagate nokorkhan aru adhikari khan khara asele, aru taikhan thanda laga karone jui thapi thakise, aru Peter bhi taikhan logote khara kori jui thapi thakise. ");
INSERT INTO nag_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Titia moha purohit Jisu ke tai chela khan laga kotha aru tai laga updesh laga kotha hudise. ");
INSERT INTO nag_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisu taike jowab dise, “Moi khuli kene jogot ke koi dise, Moi hodai mondoli te aru mondoli te, kot te Yehudi khan joma kori thake, ta te sikhai thakise, aru eku bhi lukai kene kowa nai. ");
INSERT INTO nag_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kile tumikhan Moike hudi ase? Hudi bhi jun hunise Moi taikhan ke kowa kotha khan. Sabi, taikhan sob jani ase Moi ki koise.” ");
INSERT INTO nag_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jitia Jisu etu koise, ta te thaka ekjon adhikari khara kori thaka pora Jisu ke thapor mari koise, “Kile Apuni moha purohit ke eneka jowab dibo?” ");
INSERT INTO nag_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisu taike jowab dise, “Jodi Moi biya kotha koile, etu biya kotha laga sabut dibi, kintu jodi etu thik ase koile tumi Moike kele marise?” ");
INSERT INTO nag_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Titia Annas pora Tai hath bandi kene moha purohit Caiaphas logote pathai dise. ");
INSERT INTO nag_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Peter khara hoi kene jui thapi thakisele. Titia taikhan koise, “Apuni bhi Tai chela te ekjon nohoi?” Tai koise, “Moi to nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Maha purohit laga ekta nokor jun laga kaan Peter he kati dise, etu khandan manu ekjon koise, “Apuni bhi Tai logote thaka moi bagan te apuni ke dikha nohoi?” ");
INSERT INTO nag_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter aru nohoi koise aru etu kowa logote, ekta murga hala korise. ");
INSERT INTO nag_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Titia taikhan Jisu ke Caiaphas logote prodhan sorkari kendra te loi jaise. Kintu etu somoi phojur asele, aru taikhan prodhan sorkari kendra te loi juwa nai kelemane Nistar khabole thaka karone taikhan letera hoi jabo bhabona laga bhoi pora. ");
INSERT INTO nag_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilate taikhan logote ahikena koise, “Tumikhan etu manu ke ki golti lagai kene yate anise?” ");
INSERT INTO nag_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Taikhan taike jowab di koise, “Jodi Tai biya kaam nakorile, amikhan Taike apuni usorte loi nahibole asele.” ");
INSERT INTO nag_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Karone Pilate taikhan ke koise, “Loijabi tumikhan Taike, aru tumikhan laga niyom hisab pora Taike bisar koribi.” Yehudi khan taike koise, “Amikhan laga niyom te kunke bhi mora bole adhikar nai.” ");
INSERT INTO nag_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jisu Tai nijor kineka kori mori bole ase, Tai nijor koi diya ke pura hobo karone etu eneka hoise. ");
INSERT INTO nag_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Titia Pilate prodhan sorkari kendra jagate ahi kene Jisu ke matise, aru Taike koise, “Apuni Yehudi laga Raja ase?” ");
INSERT INTO nag_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisu taike jowab dise, “Etu kotha tumi nijor koi ase, na kunba Ami laga kotha tumike koise?” ");
INSERT INTO nag_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate jowab dise, “Moi Yehudi ase, na nohoi? Tumi laga jati aru mukhyo purohit khan he Apuni ke moi laga hathte dise. Apuni ki korise?” ");
INSERT INTO nag_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisu jowab dise, “Moi laga rajyo etu duniya laga nohoi. Jodi etu duniya laga hoile, manu pora Moike dhori kene Yehudi khan ke nadibo karone, Ami laga nokorkhan lorai koribo asele. Kintu Moi laga rajyo to yate nohoi.” ");
INSERT INTO nag_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Karone Pilate Taike koise, “Tinehoile, Apuni ekjon Raja ase?” Jisu jawan dise, “Apuni thik koise, Moi raja ase. Kelemane etu karone, Moi jonom loise aru ahise, hosa laga gawahi dibo nimite. Karone, jun manu hosa te thake Ami laga awaj huni thake.” ");
INSERT INTO nag_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate Taike koise, “Hosa to ki ase?” Aru tai etu koi kene Yehudi khan logote aru jaise aru koise, “Moi to Tai uporte eku golti paa nai. ");
INSERT INTO nag_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kintu tumikhan niyom te Nistar Purbb te moi pora ekjon ke tumikhan karone chari dibole ase, karone moi tumikhan Yehudi laga Raja ke chari dile tumi laga itcha hobo?” ");
INSERT INTO nag_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Titia taikhan aru bisi hala kori koise, “Etu manu nohoi kintu Barabbas ke dibi.” Barabbas ekjon dokait asele. ");
INSERT INTO nag_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Titia Pilate pora Jisu ke loijai kene chabuk maribo dise. ");
INSERT INTO nag_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aru sipahi khan kata mukut bonaise. Aru Jisu laga matha te hali dise aru begoni rong laga kapra Taike pindhai dise. ");
INSERT INTO nag_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aru Tai usorte ahi kene, salam korise aru Taike thapor marikena koise, “Yehudi laga Raja!” ");
INSERT INTO nag_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Titia Pilate aru bahar ahikena Taikhan ke koise, “Sabi, moi Tai pora eku golti pa-a, nai karone tumikhan ke jonai dibole Taike loi kene tumikhan logote ahi ase.” ");
INSERT INTO nag_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Titia Jisu kata mukut aru begoni rong kapra lagai kene bahar te ulai ahise. Pilate taikhan ke koise, “Sabi, etu manu yate ase!” ");
INSERT INTO nag_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jitia mukhyo purohit khan aru adhikari khan Jisu ke dikhise, taikhan jor pora hala kori koise, “Taike Cross te morai dibi, Taike Cross te morai dibi!” Pilate taikhan ke koise, “Tumikhan he Taike loijai kene morai dibi, kelemane moi to Tai pora eku golti paa nai.” ");
INSERT INTO nag_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yehudi khan taike jowab dise, “Amikhan bhi niyom ase, aru etu niyom hisab te Tai moribo lage, kelemane Tai nijorke Isor laga Putro kowa karone.” ");
INSERT INTO nag_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Karone jitia Pilate etu kotha hunise, tai aru bisi bhoi khai jaise. ");
INSERT INTO nag_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Aru tai prodhan sorkari kendra te jaise, aru Jisu ke koise, “Apuni kot pora ahise?” Kintu Jisu taike eku jowab diya nai. ");
INSERT INTO nag_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Titia Pilate Taike koise, “Apuni moike eku nakobo? Apuni najane moi Apuni ke chari dibole bhi adhikar ase, aru Apuni ke latkai dibole bhi adhikar ase?” ");
INSERT INTO nag_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisu taike koise, “Apuni ke upor pora hokti nadile Ami logote eku adhikar nathakibole asele, karone jun Moike dhori kene tumi laga hathte dise etu manu laga paap bisi hoise.” ");
INSERT INTO nag_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Etu jowab pora Pilate Taike chari dibole bhabi loise, kintu Yehudi cholawta khan hala kori koise, “Jodi apuni etu manu ke chari dile, apuni Caesar laga sathi nohoi. Kun tai nijorke raja koribo kosis kore, tai Caesar bhirodhi ase.” ");
INSERT INTO nag_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jitia Pilate etu kotha hunise, tai Jisu ke loi bahar ulaise, aru bisar kora singhason te bohise, utu jagah ke “Pavement” mate, kintu Ibrani kotha te “Gabbatha” koi. ");
INSERT INTO nag_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Etu somoi to Nistar Purbb laga taiyari kora din asele, aru baroh baji asele, aru tai Yehudi khan ke koise, “Sabi, tumikhan laga Raja!” ");
INSERT INTO nag_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kintu taikhan hala kori, “Taike loijabi, Taike loijabi; Taike Cross te morai dibi!” Pilate taikhan ke koise, “Kile tumikhan laga Raja ke moi Cross te dibo?” Mukhyo purohit khan koise, “Amikhan Caesar nohoile dusra raja nai.” ");
INSERT INTO nag_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Titia tai Jisu ke Cross te dibole taikhan hathte di dise, karone taikhan Jisu ke loi jaise. ");
INSERT INTO nag_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Aru Jisu nijor Cross loi kene ekta jagah te jaise juntu ke “Matha laga Hardi jaga” koi, jun to Ibrani kotha te “Golgotha” koi. ");
INSERT INTO nag_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ta te taikhan Jisu ke Cross te dise, aru dusra duijon ke bhi ekjon ephale aru dusra uphale korise, aru Jisu ke majote dise. ");
INSERT INTO nag_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aru Pilate ekta dosh potro likhi kene Cross te dise, aru eneka likha asele: NAZARETH LAGA JISU, YEHUDI KHAN LAGA RAJA.” ");
INSERT INTO nag_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Karone, bisi Yehudi khan etu porhise, kelemane Jisu ke latkai diya jaga to sheher usorte thakise. Aru etu chihna ke Ibrani, Latin aru Yunani pora kotha te likhi rakhise, ");
INSERT INTO nag_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Titia mukhyo purohit khan aru Yehudi khan Pilate ke koise, “Eneka nalikhibi, ‘Yehudi laga Raja,’ kintu Tai he nijor he koi, ‘Moi Yehudi laga Raja ase.’”” ");
INSERT INTO nag_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate jowab dise, “Ki Moi likhise, etu likhi dise.” ");
INSERT INTO nag_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jitia sipahi khan Jisu ke Cross te latkai dise aru Tai kapra khan char bhag kori sob sipahi ekta-ekta bhag loise, aru Tai kurta bhi, kintu kurta to silai nathaka, upor pora niche tak bona asele. ");
INSERT INTO nag_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Karone taikhan apaste kotha korise, “Amikhan etu kurta to naphatai kene chithi kheli koribo, kun naam te ulabo tai he loi lobo.” Kelemane Shastro te likha ase, “Taikhan Ami laga kapra bhangai loise Aru Moi laga kurta loi chithi kheli loise.” Karone sipahi khan etu kori loise. ");
INSERT INTO nag_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ta te Jisu Cross usorte Tai laga ama aru ama laga bhoini, Clopas laga maiki Mary, aru Mary Magdalene khara asele. ");
INSERT INTO nag_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jitia Jisu Tai laga ama aru Tai morom kori thaka chela khara thaka dikhi kene Tai laga ama ke koise, “Mahila, sabi, apuni laga chokra!” ");
INSERT INTO nag_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Titia Tai chela ke bhi koise, “Sabi, apuni laga ama!” Aru etu somoi pora chela pora taike nijor ghor te loi jaise. ");
INSERT INTO nag_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Etu pichete, Shastro te likha khan sob pura hoise janikena Jisu koise, “Moi pyaas lagise.” ");
INSERT INTO nag_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ta te ekta daba te tenga pani bhorta rakhi asele, taikhan kopas te tenga pani bhi jai kene Tai mukh te dise. ");
INSERT INTO nag_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jitia Jisu etu tenga pani loise, Tai koise, “Etu pura hoise.” Aru Tai matha niche kori Tai atma di dise. ");
INSERT INTO nag_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Titia Yehudi khan, kelemane etu taiyar kora din asele, karone gaw to Bisram dinte Cross te narakhi bole - kelemane etu Bisram din to khas din asele,- Pilate logote hudise theng bhangai dibole aru taikhan ke namai dibole. ");
INSERT INTO nag_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Titia sipahi khan ahi prothom laga theng bhangai dise, aru dusra laga bhi junke Jisu logote latkai disele. ");
INSERT INTO nag_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kintu jitia Taikhan Jisu usorte ahise, Tai mori juwa dikhikena Tai laga theng bhangai diya nai. ");
INSERT INTO nag_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Hoilebi, sipahi ekjon tai laga jathi loi kene Tai laga pet te ghusai dise, aru khun aru pani ulaise. ");
INSERT INTO nag_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Aru jun dikhise tai gawahi dise, aru tai laga gawahi to hosa ase. Tai jane tai hosa koise, karone tumikhan bhi biswas koribi. ");
INSERT INTO nag_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kelemane Shastro te “Tai laga hardi ekta bhi na bhangabo, etu pura hobo karone eneka hoise.” ");
INSERT INTO nag_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aru, dusra Shastro te koise, “Taikhan nijor jathi pora mari diya ke nijor sabo.” ");
INSERT INTO nag_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Etu sob huwa pichete, Arimathia laga manu Joseph, jun Jisu laga chela asele, -kintu Yehudi khan ke bhoi pora lukai thakise-, Pilate logote ahi Jisu laga gaw ke loi jabole mangise. Pilate taike dibole hukum dise. Karone Joseph ahikena Jisu laga gaw loi jaise. ");
INSERT INTO nag_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus bhi ahisele, age te jun manu rati te Jisu logote ahisele. Tai myrrh aru aloe khan anise, aru etu to milai kene eksoh pound nisena thakise. ");
INSERT INTO nag_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Titia taikhan Jisu laga gaw loi kene Yehudi laga moidam diya niyom hisab te mihin kapra loi mitha sugandh tel pora milai loise. ");
INSERT INTO nag_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Aru kun jagate Jisu ke latkai dise, ta te ekta bagan thakise, aru etu bagan te ekta notun kobor thakise, kitia bhi nachola laga thakise. ");
INSERT INTO nag_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aru etu din Yehudi khan laga taiyari din asele, aru etu kobor bisi dur bhi nohoi, karone taikhan Jisu ke ta te he rakhidise. ");
INSERT INTO nag_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Hapta laga prothom dinte, arubi andhera thaka homoi te, Mary Magdalene kobor te ahise, aru kobor pora pathor ke hatai diya dikhi paise. ");
INSERT INTO nag_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Titia tai dauri ahikena Simon Peter aru dusra chela junke Jisu morom kore, taikhan ke koise, “Manu khan Probhu ke kobor pora uthai loi jaise, aru amikhan najane Taike kote loi rakhidise.” ");
INSERT INTO nag_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Titia Peter aru dusra chela duijon ulaikene kobor te jaise. ");
INSERT INTO nag_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Aru duijon polai jai asele, hoilebi dusra chela he Peter pora age kobor te ponchise. ");
INSERT INTO nag_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Aru tai jhuki kene bhitor te saise, aru mihin kapra thaka paise, kintu tai bhitor te juwa nai. ");
INSERT INTO nag_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Titia Simon Peter tai piche-piche ahise, aru kobor bhitor te jaise. Tai mihin kapra ta te thaka paise ");
INSERT INTO nag_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","aru Tai matha bandi rakha kapra dikhise. Etu kapra to mihin kapra logote nohoi kintu alag jagate bhal pora lipai kene thaka paise. ");
INSERT INTO nag_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Titia dusra chela jun prothom kobor te ponchise, aru bhitor jaise aru dikhi kene biswas korise. ");
INSERT INTO nag_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kelemane taikhan etiya tak Tai mora pora jee uthijabo lage, eneka Shastro te kowa ke bujha nai. ");
INSERT INTO nag_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Titia chela khan nijor ghor te wapas jai jaise. ");
INSERT INTO nag_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kintu Mary to kobor bahar te khara kandi thakise, aru jhuki kene kobor bhitor te saise. ");
INSERT INTO nag_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Aru sorgodoth duijon ujala kapra pindhi kene kuntu jagate Jisu laga gaw rakhise, ta te ekjon matha phale aru dusra Tai theng phale thaka paise. ");
INSERT INTO nag_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Titia taikhan taike koise, “Mahila, kele tumi kandi ase?” Tai taikhan ke koise, “kelemane ami laga Probhu ke uthai loi jaise, aru taikhan Taike kot te rakhidise moi najane.” ");
INSERT INTO nag_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tai etu koi kene piche phale saise, aru Jisu ke ta te khara dikha paise, kintu tai etu Jisu ase koi kene jana nai. ");
INSERT INTO nag_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisu taike koise, “Mahila kele tumi kandi ase? Tumi kunke bisari ase?” Tai maali ase bhabi kene Taike koise, “Sahab, jodi apuni Taike loi jaise koile Taike kot te rakhidise moike koi dibi tinehoile moi Taike loijabo.” ");
INSERT INTO nag_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisu taike koise, “Mary.” Tai piche ghuri kene Taike koise Ibrani kotha pora koise, “Rabboni”- mane “Shika manu”. ");
INSERT INTO nag_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisu taike koise, “Moike na chubi, kelemane Moi etiya Baba logot uporte juwa nai kintu Ami laga bhai khan logote jai kene koi dibi, Moi Ami laga Baba aru tumikhan laga Baba, Ami laga Isor aru tumikhan laga Isor, Tai logote uporte jai ase.” ");
INSERT INTO nag_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene ahi kene chela khan ke koise, “Moi Probhu ke dikhise,” aru Tai he taike etu sob kotha koise koi kene. ");
INSERT INTO nag_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Karone, hapta laga prothom din laga saam te chela khan joma korise, taikhan Yehudi khan ke bhoi pora dorja bondh kori rakhise, titia Jisu ahi taikhan majote khara hoise, aru taikhan ke koise, “Shanti hobi tumikhan.” ");
INSERT INTO nag_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aru etu kowa pichete Tai hath aru Tai panjar taikhan ke dikhai dise. Titia taikhan Probhu ke dikhi anondo korise. ");
INSERT INTO nag_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Titia Jisu koise, “Shanti hobi tumikhan. Jineka Baba he Moike pathaise tineka Moi tumikhan ke pathai ase.” ");
INSERT INTO nag_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Aru jitia Jisu etu koi dise, Tai pora taikhan ke phuki dise, aru koise, Tumikhan “Pobitro Atma grohon kori lobi. ");
INSERT INTO nag_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tumikhan kun laga paap ke khyama kori dise, taikhan khyama pai jabo; aru tumikhan jun laga paap rakhidibo, etu paapkhan thaki jabo.” ");
INSERT INTO nag_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kintu Jisu pora baroh jon logote aha somoite Thomas Didymus to chela thaka nai. ");
INSERT INTO nag_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Dusra chela koise taike, “Amikhan Probhu ke dikhise.” Kintu tai taikhan ke koise, “Jitia tak moi Tai hathte gojal daag nadikhibo, aru nijor anguli pora gojal laga chenda te hath na nadhalibo, moi biswas nakoribo.” ");
INSERT INTO nag_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Aru ath din pichete Tai chela khan ghor te joma thakisele, aru Thomas bhi taikhan logote thakise. Jisu ahise aru dorja bondh thakise, aru taikhan majote khara koi kene koise, “Shanti hobi tumikhan.” ");
INSERT INTO nag_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Titia Tai Thomas ke koise, “Tumi laga anguli yate loi anibi aru Ami laga hath sabi. Aru tumi laga hath loi yate anibi, aru Ami laga panjar te halibi aru abiswasi nathakibi, kintu biswas koribi.” ");
INSERT INTO nag_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aru Thomas Taike koise, “Ami laga Probhu aru ami laga Isor.” ");
INSERT INTO nag_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisu taike koise, “kelemane tumi Moike dikhi kene biswas korise. Dhonyo ase jun khan dikhi nai, aru biswas kori loise.” ");
INSERT INTO nag_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisu aru bhi bisi chihna Tai chela khan usor pora kori dise, etu kitab te nalikha aru bhi bisi ase, ");
INSERT INTO nag_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kintu etu sob likhi rakhise, kelemane, Jisu he Khrista, jun Isor laga Putro ase etu biswas kori bole, aru biswas pora Tai naam te jibon pabo karone ase. Amen. ");
INSERT INTO nag_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Etu huwa pichete, arubi Jisu Tai nijor chela khan ke dikhai dise Tiberias nodi kinar te. Tai eneka taikhan ke dikhai dise: ");
INSERT INTO nag_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","-Simon Peter aru Didymus kowa Thomas, aru Galilee jaga laga Cana town pora Nathaniel aru Zebedee laga duijon chokra aru Tai chela khan kunba eke logote asele. ");
INSERT INTO nag_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter taikhan ke koise, “Moi maas dhori bole jai ase.” Taikhan koise, “Amikhan bhi apuni logote jabo.” Titia taikhan joldi jai kene ekta naw te bohi jaise, kintu etu rati taikhan eku bhi pa-a nai. ");
INSERT INTO nag_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jitia phojur hoise, Jisu nodi kinar te khara thakise, hoilebi chela khan etu Jisu ase koi kene jana nai. ");
INSERT INTO nag_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Karone Jisu taikhan ke koise, “Jawan khan, khabole kiba ase?” Taikhan Taike koise, “Nai.” ");
INSERT INTO nag_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Titia Tai taikhan ke koise, “Naw laga dyna phale tumikhan jal hali dibi, titia tumikhan kiba pabo.” Titia taikhan jal hali dise, aru maas bisi dhori luwa karone tanibo para nai. ");
INSERT INTO nag_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Titia juntu chela ke Jisu morom kore, tai pora Peter ke koise, “Etu Probhu ase.” Jitia Simon Peter etu kotha hunise, tai laga bahar kapra pindhi loise- kelemane tai kapra nalagai kene thakise- aru samundar te jap marise. ");
INSERT INTO nag_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kintu dusra chela khan chutu naw te ahise- kelemane taikhan kinar te jabole bisi dur nohoi, dui-sou hath lamba nisena he ase- aru taikhan maas bhorta thaka jal ke tani ani loise. ");
INSERT INTO nag_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jitia taikhan joldi matite ahi jaise, taikhan jui laga koila te maas rakhi thaka, aru roti dikhise. ");
INSERT INTO nag_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisu taikhan ke koise, “Tumikhan etiya dhori luwa pora maas olop anibi.” ");
INSERT INTO nag_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter naw te jai kene dangor maas pora bhorta thaka jal ke matite tani anise; ta te bisi thakise hoilebi jal to phata nai. ");
INSERT INTO nag_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisu pora taikhan ke koise, “Ahibi aru nashta kori lobi.” Kintu ekjon chela khan bhi Taike hudibo mon dangor kora nai, “Apuni kun ase?” Kelemane Tai he Probhu ase koi kene taikhan jani loise. ");
INSERT INTO nag_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisu ahise aru roti aru maas loi kene taikhan ke dise. ");
INSERT INTO nag_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Etu tin bar asele Jisu Tai mora pora ji uthija pichete chela khan ke nijor dikhai dise. ");
INSERT INTO nag_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jitia nashta kori loise, Jisu Simon Peter ke koise, “Simon Peter, Jonah laga chokra, tumi eitu khan pora bhi Moike bisi morom kore?” Peter Tai koise, “Hoi Probhu moi Apuni ke morom kora Apuni jane.” Jisu taike koise, “Ami laga mer khan ke khila bhi.” ");
INSERT INTO nag_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tai taike aru koise dusra bar, “Simon Jonah laga chokra, tumi Moike morom kore?” Peter Taike koise, “Hoi Probhu, Apuni he jane moi Apuni ke morom kore.” Jisu taike koise, “Ami laga mer khan ke roikhya koribi.” ");
INSERT INTO nag_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tai taike koise tin bar, “Simon Jonah laga chokra, tumi Moike morom kore?” Peter udas hoise kelemane Jisu taike tin bar kowa karone, “Moike morom kore?” Tai koise, “Probhu, Apuni he sob jane, moi Apuni ke morom kore.” Jisu taike koise, “Ami laga mer khan ke khila bhi. ");
INSERT INTO nag_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Hosa pora Moi tumike kobo, tumi jawan somoite tumi nijor komor bandi kot te jabole mon kore ta te jai thakisele, kintu jitia tumi bura hoi jabo, tumi hath uthaikene dusra pora tumike kapra pindhai aru tumi kot te jabole mon nakore ta te loijabo.” ");
INSERT INTO nag_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Titia Jisu etu kowa motlob to Peter kineka moribo aru Isor ke mohima kori bole ase, etu dikhai dibole kowa hoise, aru Tai Peter ke koise, “Ami laga piche koribi.” ");
INSERT INTO nag_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Titia Peter ghuri piche saise, aru junke Jisu morom kore etu chela jun bhoj kora somoite thik Jisu laga chati usorte jhuki kene hudise, “Probhu, Apuni ke thogai dibole thaka kun ase?” ");
INSERT INTO nag_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Karone Peter taike dikhi kene Jisu ke koise, “Kintu Probhu, etu manu kineka hobo?” ");
INSERT INTO nag_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisu taike koise, “Jodi Moi kobo Moi aru wapas naha tak, taike thaki bole dibo mon korile tumi ki hoise? Tumi Ami laga piche koribi.” ");
INSERT INTO nag_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Karone etu chela namoribo koi kene bhai khan majote kotha kori thakise, kintu Jisu taike etu chela namoribo kowa nai kintu, “Jodi Moi aru naha tak taike thaki bole dibo mon korile, tumi ki hoise?” ");
INSERT INTO nag_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Etu chela he ase jun pora etu kotha ke gawahi dise, aru etu kotha ke likhi diya hoise, aru tai laga gawahi hosa ase, etu amikhan jani ase. ");
INSERT INTO nag_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kintu aru bhi bisi kaam ase, Jisu kori diya, jodi etu sob kotha ekta-ekta kori likhi jabo koile, ami laga bhabona te kitab likhi bole etu duniya te jagah napabo.");
INSERT INTO nag_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Theophilus, moi laga prothom kitab te, Jisu pora ki hikai se aru ki korise, ");
INSERT INTO nag_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Taike sorgote loi najuwa din tak, aru Pobitro Atma laga hokti pora Jisu nijor basi luwa apostle khan ke hukum diya khan laga likhi dise. ");
INSERT INTO nag_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tai bisi dukh kori kene morise aru wapas jee uthija-a pichete, Tai chalis din tak hosa pora jinda hoise koi kene dikhai dise, aru Isor rajyo laga kotha taikhan ke koi dise. ");
INSERT INTO nag_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tai jitia taikhan logote thakise, tai hukum dise Jerusalem chari kene najabole, aru Baba laga itcha rukhi thaki bole juntu laga kotha Tai koise, “Tumikhan etu kotha moi pora huni loise ");
INSERT INTO nag_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John to pani pora Baptizma dise, kintu tumikhan to olop din pichete Pobitro Atma pora baptizma pabo.” ");
INSERT INTO nag_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jitia Jisu aru chela khan eke logot joma korise, titia taikhan eneka hudise, “Probhu Apuni etu homoi te Israel laga rajyo wapas dibo naki?” ");
INSERT INTO nag_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kintu Tai taikhan ke koise, “Etu tumikhan janibole din aru homoi aha nai, Baba he nijor adhikar aru hokti pora koribo. ");
INSERT INTO nag_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kintu tumikhan hokti pabo, jitia Pobitro Atma ahibo, aru tumikhan Moi laga gawahi dibo, Jerusalem te, aru Judea aru Samaria te aru prithibi laga sob jagate.” ");
INSERT INTO nag_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jitia Probhu Jisu taikhan ke etu kotha khan koi dise, aru taikhan upor phale sai thakise, titia Taike uporte uthai loi jaise, aru badal ahi kene taike bondh kori dise aru taikhan laga suku pora eku nadikha hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jitia taikhan Jisu ke sorgote loijai thaka to sai thakise, achanak pora, duijon manu boga kapra lagai kene taikhan usorte khara hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aru tai duijon pora koise, “Galilee laga manu khan, tumikhan kele sorgo phale saikene khara kori ase? Jisu junke sorgote loi jaise, Taike sorgote loi juwa dikha nisena aru Tai wapas eneka aha dikhibo.” ");
INSERT INTO nag_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Titia chela khan Jerusalem sheher te ahise, Oliv Pahar pora, jun to Jerusalem pora ekta Bisram din nisena dur te ase. ");
INSERT INTO nag_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Taikhan ponchi kene upor kamra te jaise, aru ta te Peter, James, John, aru Andrew, Philip aru Thomas, Bartholomew, Matthew, Alpheus laga chokra James, Simon Zealot aru James laga chokra Judas khan bohi thakise. ");
INSERT INTO nag_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Taikhan sob eke mon hoi kene prathana korise, ta te mahila khan bhi thakise, aru Jisu laga ama Mary aru Tai bhai khan bhi thakise. ");
INSERT INTO nag_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Aru etu homoi te eksoh bis nisena bhai khan joma thakise, titia Peter koise, ");
INSERT INTO nag_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bhai khan, Shastro te ki likha ase etu pura hobo lagibo, Pobitro Atma dwara David laga mukh pora Judas nimite koi disele, jun he Jisu ke dhoribole manu khan ke loi anise. ");
INSERT INTO nag_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kelemane Judas bhi amikhan logote ginti korise, aru Isor laga kaam kori bole tai laga bhag bhi thakise.” ");
INSERT INTO nag_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","- Ekjon manu tai laga letera kamai pora kheti kinise, aru etu jagate tai poila matha ulta kori kene girise, aru tai laga pet phati jaise, aru pet nari sob bahar te ulai jaise. ");
INSERT INTO nag_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Aru Jerusalem sheher te thaka manu sob etu kotha janise, aru titia taikhan nijor kotha pora etu kheti laga naam “Akeldama,” rakhidise juntu laga motlob ase, “Khun laga Kheti.”- ");
INSERT INTO nag_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Kelemane Bhajan Geet laga Kitab te likha ase, ‘Tai laga kheti khali hoi jabo, Ta te kunke bhi thaki bole nadibi,’ Aru ‘kunba pora tai laga kaam to loi lobole dibi.’ ");
INSERT INTO nag_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Etu dorkar ase, kelemane, Probhu Jisu thaka homoi pora Tai naja tak kunkhan amikhan logote thakise, ");
INSERT INTO nag_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","shuru pora John ke baptizma diya homoi aru Jisu ke amikhan logot pora uthai loi naja tak- etu majot pora, ekjon manu amikhan logote mili kene Tai arubi jee uthija-a laga gawahi kori bole lage.” ");
INSERT INTO nag_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aru taikhan duijon manu ke age te rakhise, Joseph junke Barsabbas aru Justus bhi mate, aru Matthias. ");
INSERT INTO nag_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Aru taikhan prathana kori kene koise, “Apuni, Probhu, sob manu laga mon jane, etu nimite duijon majote kunke basi loise etu jonai dibi ");
INSERT INTO nag_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kun he sewa laga jaga lobo juntu Judas pora chari kene nijor jagate jai jaise.” ");
INSERT INTO nag_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Titia taikhan chithi korise, aru chithi te Matthias laga naam ulaise, aru egaroh jon chela majote tai bhi ginti hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jitia Pentecost din ahise, biswasi khan sob ek jagah te joma hoise. ");
INSERT INTO nag_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aru achanak ta te awaj ekta sorgo pora ahise, aru taikhan bohi thaka pura ghor to bhorta hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Titia taikhan age te juli thaka jui nisena ulaise, aru ekjon-ekjon uporte bohi jaise. ");
INSERT INTO nag_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aru taikhan sob Pobitro Atma pora bhorta hoise aru alag kotha pora kobole shuru hoise, Atma pora taikhan ke dusra bhasa pora kobole sikhai dise. ");
INSERT INTO nag_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aru Jerusalem te Isor jana Yehudi manu khan thakise, aru akas nichete thaka sob desh pora ahikena ta te thakise. ");
INSERT INTO nag_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Aru jitia etu awaj ulaise, ta te manu khan sob ahi kene asurit lagise kelemane taikhan nijor laga kotha pora koi thaka hunise. ");
INSERT INTO nag_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Titia taikhan sob asurit hoi jaise; aru taikhan koise, “Sabi, etu kotha koi thaka khan Galilee manu khan nohoi naki? ");
INSERT INTO nag_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tenehoile kineka taikhan laga mukh pora amikhan ki kotha koi kene jonom korise etu kotha koi ase? ");
INSERT INTO nag_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parthia laga aru Mede aru Elam laga, aru kun Mesopotamia te thake, Judea aru Cappadocia, Pontus aru Asia te, ");
INSERT INTO nag_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia aru Pamphylia, Egypt aru Cyrene usorte Libya, aru Rome phale jai thaka manu khan, ");
INSERT INTO nag_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","aru Yehudi aru proselyte khan, Crete manu khan aru Arab manu khan, taikhan Isor laga dangor aru asurit kaam kora to amikhan laga bhasa pora koi thaka to hunise.” ");
INSERT INTO nag_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Taikhan sob asurit pora bhabona kori kene, aru ekjon-ekjon ke koise, “Etu laga ki motlob ase?” ");
INSERT INTO nag_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kintu dusra biswasi khan pora sorom khilai kene koise, “Taikhan nisa pani kori kene ase.” ");
INSERT INTO nag_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kintu Peter egaroh jon logote khara hoi kene jor pora taikhan ke koise, “Judea laga manu khan aru Jerusalem te thaka khan, apnikhan etu jani lobi, aru moi ki koi ase etu bhal kori kene huni lobi. ");
INSERT INTO nag_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kintu etu manu khan to apuni khan pora bhabona kora nisena nisa pani khai kene thaka nohoi, kelemane etiya phojur nou-baji he ase. ");
INSERT INTO nag_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kintu etu kotha bhabobadi Joel pora koise: ");
INSERT INTO nag_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Eneka hekh dinte hobo, Isor pora koise, Moi laga Atma sob manu uporte di dibo Tumikhan laga chokra chukri khan pora bhabobani koribo, Aru jawan manu khan darshan pabo, Aru bura manu khan sapna dikhibo. ");
INSERT INTO nag_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aru Moi laga noukar aru mahila noukar khan uporte Moi laga Atma di dibo, aru taikhan bhabobani kobo. ");
INSERT INTO nag_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Moi akas Aru prithibi te asurit kaam dikhai dibo, Khun aru jui aru dhuwa laga bhap. ");
INSERT INTO nag_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Titia suryo to andhera hoi jabo Aru chand to khun nisena dikhibo, Probhu laga dangor mohima din naha age te eitu khan sob hobo. ");
INSERT INTO nag_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aru jun manu hekh homoi tak Probhu laga naam loi kene thake tai bachi jabo.’ ");
INSERT INTO nag_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel laga manu khan, etu kotha huni bhi, Nazareth Jisu eneka manu thakise junke Isor pora tumikhan nimite pathai dise dangor aru asurit kaam kori bole nimite, aru etu sob Isor pora Probhu Jisu ke loi kene korise, aru etu sob tumikhan pora dikhise. ");
INSERT INTO nag_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tai Jisu to, Isor pora kineka age pora bhabona korise aru tai laga gyaan pora, Jisu ke biya manu hathte di dise, aru tumikhan Taike gojal mari kene ekta Cross te morai dise. ");
INSERT INTO nag_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tai ekjon ase junke Isor mora pora jinda kori dise, mora pora taike chari dise, kelemane Taike mora pora aru bandhi rakhibole para nai. ");
INSERT INTO nag_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kelemane David Tai nimite koise, ‘Moi Probhu ke hodai moi laga chehera usorte dikhe, Tai moi laga dyna hathte thake, moi biya rasta te najabo nimite. ");
INSERT INTO nag_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Etu karone, moi laga mon khushi ase aru moi laga jiba pora dhanyavad kore. Aru, moi laga gaw bhi biswas te jinda thakibo. ");
INSERT INTO nag_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kelemane Apuni moi laga jibon Hades te chari nadibo, Aru Apuni laga Pobitro Jonke puchibo nadibo. ");
INSERT INTO nag_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Apuni moike jibon laga rasta dikhai dise; Aru apuni laga usorte moike khushi pora bhorta kori dibo.’ ");
INSERT INTO nag_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Bhai khan, moi apuni khan ke etu kobole pari ase ki amikhan laga purush-Baba David pora ki kaam korise, aru tai morise aru taike kobor dise, aru tai laga kobor aji tak amikhan logote ase. ");
INSERT INTO nag_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Etu karone, tai ekjon bhabobadi thakise aru jani thakise Isor tai logote kosom khaise, tai laga khandan pora ekjon ulabo aru uthaikene Tai laga singhason te bohai dibo. ");
INSERT INTO nag_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Aru aha dinte ki hobole ase etu sob to dikhi kene, tai Khrista mora pora jinda huwa laga kotha koise, ‘Taike Hades te bhi chari diya nai, aru Tai laga gaw bhi puchi janai.’ ");
INSERT INTO nag_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jisu ke Isor he jinda kori dise, aru amikhan sob Jisu jee-utha laga gawahi ase. ");
INSERT INTO nag_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Etu nimite Taike Isor laga dyna hathte bohai kene uthai dise aru Baba Isor pora Tai laga Pobitro Atma amikhan uporte di dise, juntu apnikhan dikhi ase aru huni bole pari ase. ");
INSERT INTO nag_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kelemane David to sorgote uthai loi juwa nai, kintu tai nije koise, ‘Probhu he moi laga Probhu ke koise, “Ami laga dyna hathte bohibi, ");
INSERT INTO nag_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Jitia tak tumi laga dushman khan ke tumi laga theng rakha jaga bonai nadiye.’” ");
INSERT INTO nag_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Etu karone, Israel te jiman ghor ase etu jani lobi, Isor pora Taike Probhu aru Khrista bonai dise, etu Jisu, junke tumikhan Cross te morai dise.” ");
INSERT INTO nag_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jitia etu kotha hunise, taikhan monte jokhom paise, aru Peter aru ta te thaka apostle khan ke koise, “Bhai khan, amikhan ki koribo?” ");
INSERT INTO nag_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Titia Peter taikhan ke jowab dise, “Mon ghura bhi, moi koi ase, aru baptizma koribi, sob manu, Jisu Khrista naam pora, nijor laga paap nimite, titia tumikhan Pobitro Atma laga inam pabo. ");
INSERT INTO nag_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kelemane etu Isor laga kosom apuni aru apuni khan laga bacha khan nimite ase, aru Probhu Isor pora junke matibo, taikhan nimite bhi ase.” ");
INSERT INTO nag_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tai aru bisi kotha pora gawahi dikena taikhan ke samjai se, aru koise, “Nijorke biya manu khan pora bachai rakhibi.” ");
INSERT INTO nag_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Titia taikhan sob huni kene baptizma loise, aru tin hajar jon thaka biswasi khan logote aru bhi ginti kori loise. ");
INSERT INTO nag_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Aru taikhan apostle khan pora ki sikhai dise etu kotha khan koi jai thakise aru ekjon-ekjon logote girja kori thakise, aru roti bhangai kene prathana te thakise. ");
INSERT INTO nag_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aru sob logote bhoi ahi jaise, aru apostle khan dwara asurit kaam korise. ");
INSERT INTO nag_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Aru biswasi khan logote mili kene thakise, aru sob kaam mili kene kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aru taikhan nijor dhun-sampoti aru saman sob bikiri kori kene kunke lage taikhan ke bhag kori dise. ");
INSERT INTO nag_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aru hodai din ekta bhabona loi kene mondoli te kaam kore, aru ekjon-ekjon logote khushi aru mon sapha pora ghor te roti bhangai kene, ");
INSERT INTO nag_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","aru hodai Isor ke dhanyavad kori kene, aru sob logot pora morom paikene thakise. Aru hodai jiman Probhu logot biswas kori loi, taikhan majote ginti hoi thakise. ");
INSERT INTO nag_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ek din, tin baji homoi te, Peter aru John prathana kori bole mondoli te jai thakise. ");
INSERT INTO nag_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Titia ta te ekjon manu ama laga pet pora bera bole napara thakise, aru manu khan pora hodai taike bukhi kene mondoli laga dorja Sundur koi kene mata jagate rakhi diye, taike mondoli te aha manu khan pora poisa mangibo nimite. ");
INSERT INTO nag_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tai kitia Peter aru John ke mondoli bhitor te jai thaka dikhise, taikhan ke poisa mangise. ");
INSERT INTO nag_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kintu Peter aru John taike bhal kori saise aru koise, “Amikhan phale sabi.” ");
INSERT INTO nag_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Titia etu bera bole napara manu taikhan ke saise, aru bhabise kiba taikhan pora pabo. ");
INSERT INTO nag_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kintu Peter koise, “Suna aru chandi moi logot nai, kintu ki moi logot ase, etu moi tumike dibo. Nazareth laga Jisu Khrista naam pora koi ase, uthi kene berabi.” ");
INSERT INTO nag_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Aru Peter tai laga dyna hath dhori kene khara kori bole dise, aru etu homoi te theng laga hardi khan te takot ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Titia etu manu khara hoi kene bera bole shuru hoise; aru taikhan logote mondoli bhitor te jaise, kudi kene aru berai kene Isor ke dhanyavad dise. ");
INSERT INTO nag_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Aru sob manu taike berai kene Isor ke dhanyavad kora dikhise. ");
INSERT INTO nag_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Aru manu khan taike dikhi kene jani loise tai kun ase, tai jun mondoli laga Sundur dorjate bhik mangi thake; aru tai logot ki hoise etu dikhi kene taikhan bisi asurit hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aru tai Peter aru John logote jai thaka karone, sob manu polai ahi kene Solomon laga veranda kowa jagate joma hoise aru taikhan bisi asurit pora sai thakise. ");
INSERT INTO nag_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jitia Peter etu dikhise, tai manu khan ke koise, “Israel laga manu khan, etu dikhi kene kele iman asurit lagi ase? Aru kele amikhan ke eneka sai ase, amikhan laga hokti pora nohoile amikhan bisi bhal manu huwa pora taike berabo paribole diya nisena? ");
INSERT INTO nag_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham laga Isor, Isaac aru Jacob laga Isor, amikhan baba khan laga Isor, Tai laga noukar Jisu ke mohima kori dise, tumikhan taike swekar kora nai aru Pilate laga hathte di dise, jitia Pilate pora Jisu ke chari dibo koise etu bhi tumikhan mana nai. ");
INSERT INTO nag_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tumikhan Pobitro aru dhormik ekjon ke luwa nai, aru manu morai diya ekjon ke chari dibole binti korise. ");
INSERT INTO nag_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kintu Jibon diya ke morai dise, junke Isor he mora pora aru jinda kori dise- aru amikhan utu laga sakhi ase. ");
INSERT INTO nag_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Etiya, Jisu laga naam te aru biswas pora apnikhan junke dikhi ase taike takot kori dise. Jisu laga naam te aru Tai dwara thaka biswas pora etu manu ke apuni khan sob usorte pura bhal kori dise. ");
INSERT INTO nag_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Etiya, bhai khan, moi jane apuni khan najani kene kori dise, aru tumikhan laga cholawta khan bhi eneka korise. ");
INSERT INTO nag_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kintu ji kotha Isor he tai laga bhabobadi khan mukh pora koi dise, Tai laga Khrista dukh pabo, aru Tai etu purah kori dise. ");
INSERT INTO nag_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mon ghura bhi, aru, titia nijor paap pora maph pabo, ");
INSERT INTO nag_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Probhu laga asirbad apuni khan logote notun kori kene ahibo; aru Tai apuni khan nimite basi kene rakhi diya ekjon, Jisu Khrista ke pathai dibo. ");
INSERT INTO nag_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Taike sorgote loi najabo jitia tak sob kaam pura nohoi, aru ji kotha Isor pora Tai laga pobitro bhabobadi khan laga mukh pora koi disele etu pura nohua tak. ");
INSERT INTO nag_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses pora amikhan baba laga baba khan ke koise, ‘Probhu Isor pora tumikhan nimite bhai khan majot pora moi nisena ekjon bhabobadi ulai dibo, aru tai ki kotha kobo etu tumikhan sob hunibo. ");
INSERT INTO nag_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aru kun etu bhabobadi laga kotha nahunibo, etu bhabobadi pora taike manu laga majot pora khotom kori dibo.’ ");
INSERT INTO nag_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Aru Samuel pora loi kene jiman bhabobadi khan tai pichete ahise, taikhan sob pora etu din laga kotha he koise. ");
INSERT INTO nag_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Apuni khan bhabobadi khan laga bacha khan ase, aru Isor pora apnikhan laga baba khan logote kowa nisena, Abraham ke koise, ‘Aru tumi laga bijon pora duniya te sob parivar asishit hobo.’ ");
INSERT INTO nag_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jitia Isor pora Tai laga noukar ke mora pora jinda kori dise,Tai pora Taike tumikhan usorte poila pathai dise, tumikhan laga biya kaam pora ghurai kene loi anibo aru asirbad dibo nimite.” ");
INSERT INTO nag_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Jitia Peter aru John duijon pora manu khan logote kotha kori thakise, purohit khan aru mondoli laga henedhikari khan aru kunba sadducee khan taikhan duijon logot te ahise. ");
INSERT INTO nag_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Taikhan bisi chinta hoi jaise, kelemane Peter aru John duijon to Jisu mora pora jinda uthijaise koi kene manu khan ke sikhai thakise. ");
INSERT INTO nag_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aru taikhan duijon ke dhori kene dusra din phojur tak bondhi ghor te rakhidise, kelemane saam hoija karone. ");
INSERT INTO nag_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kintu jiman manu etu kotha hunise taikhan Jisu ke biswas korise; aru biswas kora manu khan sob milai kene panch hajar nisena hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Aru dusra dinte cholawta aru bura manu khan aru niyom likha khan sob Jerusalem te joma hoise. ");
INSERT INTO nag_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aru Annas moha purohit bhi ta te thakise, aru Caiaphas, John aru Alexandra aru jiman dangor purohit sob joma hoise. ");
INSERT INTO nag_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Aru jitia Peter aru John ke taikhan laga majote rakhise, taikhan ke hudise, “Kun laga takot aru kun laga naam pora tumikhan etu korise?” ");
INSERT INTO nag_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Titia Peter, Pobitro Atma pora bhorta hoi kene, taikhan ke koise, “Apuni cholawta khan, aru bura manu khan, ");
INSERT INTO nag_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","amikhan ke ekta bemar manu ke bhal kaam kori diya nimite hudi ase koile, kineka kori kene tai bhal hoise? ");
INSERT INTO nag_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Apuni khan aru Israel laga manu sob pora jani lobi, Nazareth Jisu Khrista naam pora, kunke tumikhan Cross te morai dise, kintu mora pora Taike Isor jinda kori dise, Tai laga naam pora etu manu bhal hoi kene tumikhan usorte khara ase. ");
INSERT INTO nag_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisu Khrista etu pathor ase junke apuni khan pora phelai dise, ghor bona manu khan, kintu etu pathor he sob pora bhal aru kaam laga pathor hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Aru Tai nohoile dusra kun bhi poritran dibole na paribo, kelemane sorgo laga nichete kun bhi eneka nai amikhan laga paap pora mukti dibole nimite.” ");
INSERT INTO nag_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jitia taikhan Peter aru John laga mon dangor dikhise, aru taikhan likha pora manu nohoi koi kene janise, taikhan asurit lagise, aru titia taikhan Jisu logote thakise koi kene chini bole parise. ");
INSERT INTO nag_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aru taikhan dikhise bhal hoi juwa manu tai duijon logote khara hoi thakise, aru taikhan eku bhi kobo para nai. ");
INSERT INTO nag_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aru jitia apostle khan ke sabha laga bahar te pathai dise, taikhan nijor majot te kotha patise. ");
INSERT INTO nag_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Taikhan majot te eneka hudi thakise, “Amikhan etu duijon ke ki kori dile bhal hobo? Kelemane tai duijon pora asurit kaam kori diya to Jerusalem te thaka sob jani jaise, aru amikhan etu mana koribo na paribo. ");
INSERT INTO nag_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kintu etu kotha dusra jagate bisi najabo nimite, amikhan tai duijon ke koi dibo etu naam loi kene dusra ke aru nahikabole.” ");
INSERT INTO nag_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Titia taikhan Peter aru John ke mati kene anise aru Jisu laga naam te nashika bole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kintu Peter aru John taikhan ke koise, “Isor laga kotha huna to thik ase na apnikhan laga kotha mana to thik ase, etu apnikhan bhabi sabi. ");
INSERT INTO nag_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kelemane amikhan ki dikhise aru hunise etu nokoi kene thaki bole na paribo.” ");
INSERT INTO nag_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Titia Peter aru John ke dhomki dikene jabole dise, kelemane manu khan tai duijon laga asurit kaam to dikhi kene Isor ke dhanyavad di thakise aru tai duijon ke sajai dibole eku golti taikhan dikha nai. ");
INSERT INTO nag_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kelemane junke asurit pora changai kori dise etu manu chalis saal pora dangor thakise. ");
INSERT INTO nag_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jitia tai duijon ke chari dise, Peter aru John nijor manu khan logote jai kene maha purohit khan aru cholawta khan pora ki koise etu taikhan ke koi dise. ");
INSERT INTO nag_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jitia taikhan etu hunise, taikhan sob awaj uthaikene eke logote Isor ke prathana korise, “Probhu, apuni sorgo aru prithibi bonaise aru samundar te ki ase sob bonai diya Probhu Isor hoi. ");
INSERT INTO nag_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Apuni ekjon ase jun he Pobitro Atma pora Apuni laga noukar laga mukh pora koise, moi khan laga baba David, ‘Ki nimite Porjati manu khan khong uthise, Aru manu khan misa kotha khan kele bhabi thake?’ ");
INSERT INTO nag_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","‘Prithibi laga raja khan uthi khara hoise, Aru cholawta khan eke logote joma hoise, Probhu laga bhirodh te aru Khrista laga bhirodh te.’ ");
INSERT INTO nag_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hosa pora, Herod aru Pontius Pilate, dusra jati aru Israel laga manu khan, sob eke logote joma hoi kene Apuni laga pobitro noukar junke Apuni asirbad korise taike manu khan pora hinsa korise. ");
INSERT INTO nag_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Aru taikhan sob joma korise aru Apuni laga hath pora ki kori bole itcha asele etu sob poila pora hobo koi kene thakise. ");
INSERT INTO nag_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Etiya, Probhu, taikhan laga dhomki ke sabi, aru Apuni laga noukar laga mon dangor kori dibi Apuni laga kotha bhoi nakorikena kobole nimite. ");
INSERT INTO nag_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Etu karone Apuni laga hath changai kori bole nimite khuli dibi, aru Apuni laga pobitro noukar Jisu laga naam te asurit kaam kori bole nimite.” ");
INSERT INTO nag_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Aru jitia taikhan prathana kori khotom hoise taikhan jun jagate thakise etu hili bole shuru hoise, aru taikhan sob Pobitro Atma pora bhorta hoi jaise, aru taikhan bhoi nakori kene Isor laga kotha manu khan ke koise. ");
INSERT INTO nag_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Aru jiman manu biswas te joma hoi thakise taikhan sob mon aru bhabona sob eke hoi thakise, aru kun pora bhi nijor laga dhun sompoti etu moi laga ase koi kene kowa nai kintu ekjon-ekjon logote bhag korise. ");
INSERT INTO nag_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aru apostle khan dangor takot pora, Probhu Jisu jinda hoise koi kene gawahi di thakise, aru taikhan sob logote Isor laga anugrah thakise. ");
INSERT INTO nag_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Aru taikhan majote kun bhi dukh nathaka hoise, kelemane kun logote kheti, ghor aru saman ase, tai etu sob bikiri kori kene etu laga daam ani di thakise. ");
INSERT INTO nag_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Aru apostle khan laga theng nichete ani kene rakhi diye, aru taikhan kunke ki dorkar ase etu saikene bhag kori diye. ");
INSERT INTO nag_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Titia Joseph, taike Barnabas koi kene apostle khan pora mate -Mon Dangor Kori Diya Putro bhi mate-, ekjon Levite, jonom pora Cyprus majuli laga manu, ");
INSERT INTO nag_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","tai laga ekta kheti thakise etu bikiri kori kene poisa anise aru apostle khan laga theng te rakhidise. ");
INSERT INTO nag_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Etiya ekjon manu Ananias, aru tai laga maiki Sapphira duijon mili kene chutu ekta mati bikiri korise, ");
INSERT INTO nag_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Aru tai laga maiki logote kotha milai kene adha poisa rakhi loise, aru adha poisa jai kene apostle khan laga theng te rakhidise. ");
INSERT INTO nag_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kintu Peter koise, “Ananias, kele Saitan pora tumi laga mon to Pobitro Atma ke misa kobole bhorta kori dise aru ki bhikai se etu laga adha daam tumi kele loi rakhise? ");
INSERT INTO nag_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Jitia mati tumi logote bikiri nohoi kene thakise, titia mati to tumi laga he thakise nohoi, aru jitia bikiri hoi jaise, tumi jani kene bikiri kora nohoi? Tumi laga monte kineka etu bhabise? Tumi manu ke misa kowa nai, kintu Isor ke he misa koi ase.” ");
INSERT INTO nag_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jitia Ananias etu kotha hunise, tai giri kene ta te mori jaise, aru jun etu kotha hunise sob bhoi lagi jaise. ");
INSERT INTO nag_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Aru taike uthaikene jawan khan ahi kene kapra pora bandhi dise, aru loijai kene, matite hali dise. ");
INSERT INTO nag_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Aru tin ghanta pichete, tai laga maiki ahise, hoilebi tai to ki hoise etu najani kene thakise. ");
INSERT INTO nag_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Titia Peter taike jawab dise, “Amike kobi, tumi etu mati iman pora bikiri korise na nohoi.” Titia tai koise “Hoi, iman pora he bikiri korise.” ");
INSERT INTO nag_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Titia Peter taike koise, “Tumi duijon mili kene Isor laga Atma ke porikha kori bole kene bhabise? Sabi, tumi laga mota ke matite hali diya manu khan dorja usorte khara kori ase, aru tumike bhi uthai loijabo.” ");
INSERT INTO nag_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Titia tai etu homoi te Peter laga theng nichete giri kene mori jaise, aru jitia jawan khan bhitor te ahise, taike mora paise, aru bahar te loijai kene tai laga mota usorte dabai dise. ");
INSERT INTO nag_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Aru jiman manu girja te thakise aru etu kotha hunise, taikhan sob bisi bhoi lagi jaise. ");
INSERT INTO nag_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aru apostle khan laga hath pora chihna kaam manu usorte bisi kori thakise, aru biswasi khan sob eke mon hoi kene Solomon laga Veranda te joma hoise. ");
INSERT INTO nag_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kintu taikhan logote abiswasi khan to kaam kori bole mon dangor thaka nai; hoilebi manu khan pora taikhan ke bisi sonman di thakise. ");
INSERT INTO nag_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Probhu laga naam te mota aru mahila khan bisi joma hoise, aru biswas khan logot mili kene ekta mon pora kaam korise, ");
INSERT INTO nag_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","etu karone manu khan bisna uthaikene bemar manu ke rasta te loijai kene rakhidise, jitia Peter ta te ahibo, tai laga chaya bemar manu khan uporte lagi kene changai pai jabo. ");
INSERT INTO nag_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Aru Jerusalem usorte thaka nagar khan pora manu khan bemar aru biya atma pora dukh di thaka khan loi ani joma kori dise, aru sob manu jiman ahise bhal hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kintu maha purohit khara hoi jaise, aru jun manu tai logote thakise taikhan bhi uthijaise - Sadducee khan laga ekta dol-; aru taikhan etu saikene jolon hoise ");
INSERT INTO nag_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aru apostle khan ke dhori kene bondhi ghor te rakhidise. ");
INSERT INTO nag_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kintu etu rati te Probhu laga sorgodoth ahi kene bondhi ghor laga dorja khuli dise, aru taikhan ke bahar ulai dise, aru koise, ");
INSERT INTO nag_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Jabi aru khara kori kene mondoli bhitor te jiman manu ase taikhan ke jibon laga kotha koi dibi.” ");
INSERT INTO nag_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aru jitia taikhan etu hunise, taikhan phojurte mondoli bhitor te jai kene sikhaise. Kintu maha purohit aru jiman manu tai logote thakise taikhan bhi ahise, aru Israel laga bacha khan laga dangor chokra khan ke sabha te eke logote matise, aru bondhi ghor pora apostle khan ke loi anibole nimite pathaise. ");
INSERT INTO nag_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kintu jitia daruga khan bondhi ghor te jaise, taikhan ke pa-a nai, titia taikhan wapas jai kene khobor dise. ");
INSERT INTO nag_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Koise, “Amikhan jai kene saise, bondhi ghor bahar te sipahi khan bhi ta te khara kori thakise, kintu jitia amikhan Khuli Kena bhitor te jaise, ta te kunke bhi panai.” ");
INSERT INTO nag_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jitia mondoli laga cholawta aru moha purohit khan etu kotha hunise, taikhan asurit hoise, aru bhabise etu kineka hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Titia kunba ahi kene taikhan ke koise, “Sabi, apnikhan kunke bondhi ghor te hali dise, taikhan to mondoli te khara kori kene manu khan ke sikhai ase.” ");
INSERT INTO nag_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Titia cholawta aru daruga khan jaise, aru taikhan ke loi anise, kintu taikhan eku kora nai, kelemane manu khan pora taikhan ke pathor maribo jodi taikhan pora apostle khan ke dukh dise koile. ");
INSERT INTO nag_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Aru jitia taikhan ke anise, sabha usorte khara kori bole dise. Titia maha purohit pora taikhan ke hudise, ");
INSERT INTO nag_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","aru koise, “Amikhan koi dise apuni khan etu naam loi kene nasikhabi, kintu, tumikhan Jerusalem to pura tumikhan laga kotha pora bhorta kori dise, aru etu manu laga khun moi khan uporte hali bole bisari ase.” ");
INSERT INTO nag_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kintu Peter aru apostle khan koise, “Manu laga kotha huna pora to amikhan Isor laga kotha he poila manibo lage. ");
INSERT INTO nag_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Amikhan laga baba khan laga Isor he Jisu ke jinda kori dise, junke apnikhan khuri te latkai kene morai dise. ");
INSERT INTO nag_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Isor he Taike Probhu aru Tran-Korta bonai kene Tai laga dyna hathte rakhi loise, aru Israel manu khan ke notun jibon dibo aru paap pora mukti pabo. ");
INSERT INTO nag_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aru amikhan etu kotha laga gawahi ase, aru Isor Tai laga kotha mani thaka khan ke dibole Pobitro Atma bhi etu kotha laga sakhi ase. ");
INSERT INTO nag_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jitia sabhakhan etu kotha hunise, taikhan bisi khong uthise, aru apostle khan ke morai dibole mon hoise.” ");
INSERT INTO nag_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kintu sabha te ekjon Pharisee thakise, tai laga naam Gamaliel thakise, ekjon niyom jana manu, aru sob manu pora taike adar kore, tai khara kori kene apostle khan ke olop deri nimite bahar te loi jabole koise. ");
INSERT INTO nag_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aru taikhan ke koise, “Israel laga manu, moi ki koi ase etu bhal pora huni bhi aru tumikhan etu manu khan logote ki kori bole lage. ");
INSERT INTO nag_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kelemane bisi sal age te, Theudas uthi kene tai kunba ekjon ase koise, aru charsoh nisena manu tai laga pichete jaise, taike morai dise, aru jun manu tai laga pichete jai thakise taikhan bhi sob alag-alag hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Etu pichete Galilee pora Judas koi kene ekjon uthise, tai bhi manu khan ke chela bonai loise le, kintu tai bhi harai jaise, aru jiman taike mani thakise taikhan sob alag-alag hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Etiya moi apnikhan ke koi ase, eitu khan pora dur thakibi aru taikhan ke chari dibi, kelemane jodi etu dhorom aru kaam to manu pora ase koile, taikhan bhi khotom hoi jabo. ");
INSERT INTO nag_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kintu jodi Isor pora ase koile, tumikhan taikhan ke kitia bhi hata bona paribo; aru tumikhan nijor Isor logote lorai kori thaka nisena hobo.” ");
INSERT INTO nag_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Titia taikhan apostle khan ke matise aru mari kene taikhan ke Jisu laga naam aru nolobole koise, aru jabole dise. ");
INSERT INTO nag_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Taikhan sabha pora ulai jaise aru Jisu laga naam nimite, dukh paise koi kene khushi pora jaise. ");
INSERT INTO nag_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aru etu pichete, mondoli te bhi aru ghor-ghor te jai kene Jisu Khrista laga susamachar manu khan ke prochar kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Aru etu dinte, jitia chela khan bisi hoi thakise, titia Yunani khan, Yehudi khan ke bhirodh kori thakise, kelemane mota morija maiki khan ke kha luwa bhag kora homoi te hisab nakore koi kene taikhan biya pai thakise. ");
INSERT INTO nag_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Titia baroh ta chela khan pora taikhan pichete aha khan ke koise, “Etu amikhan nimite thik nohoi Isor laga kotha chari kene kha luwa laga bhag kori thaki te jabo nalage. ");
INSERT INTO nag_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Etu karone bhai khan, apnikhan majote sat jon bhal manu khan ke basi lobi, Pobitro Atma aru gyaan thaka, junke amikhan etu kaam nimite basi lobo. ");
INSERT INTO nag_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kintu amikhan hodai prathana kori thakibo aru Isor laga kotha aru kaam te age jai thakibo.” ");
INSERT INTO nag_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Taikhan laga kotha sob manu khan pora bhal paise. Aru taikhan Stephen ke basi loise jun dhormik aru Pobitro Atma pora bhorta thakise, aru Philip, aru Prochorus, aru Nicanor, Timon, Parmenas, aru Nicolaus, Yehudi niyom mani thaka Antioch pora aha ekjon. ");
INSERT INTO nag_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Taikhan ke apostle usorte anise, aru apostle khan pora hath dikene taikhan uporte prathana kori dise. ");
INSERT INTO nag_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Titia Isor laga kotha khuli prochar hoi jaise, aru biswasi khan bisi-bisi hoi thakise aru Jerusalem te purohit khan bhi bisi manu biswasi khan logot mili jaise. ");
INSERT INTO nag_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiya Stephen pura takot aru anugrah te bhorta hoi kene manu usorte dangor asurit kaam kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kintu mondoli te Freedmen koi kene kunba uthise, aru Cyrenia aru Alexandria manu, aru Cilicia aru Asia pora kunba ahi kene Stephen logote kotha pora lagi jaise. ");
INSERT INTO nag_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kintu taikhan Stephen to gyaan aru Pobitro Atma pora kotha kowa dikhi kene tai uporte jiti bole para nai. ");
INSERT INTO nag_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Titia taikhan poisa dikene manu khan ke kobole koise, “Amikhan Stephen pora Moses aru Isor laga biya kotha koi thaka hunise.” ");
INSERT INTO nag_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Aru taikhan pora bura khan aru niyom likha khan laga mon ulta kori dise aru Stephen ke dhurikena taike sabha usorte tani kene loi anise. ");
INSERT INTO nag_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Taikhan misa gawahi diya manu bhi loi anise, aru koise, “Etu manu to amikhan laga pobitro jaga aru niyom laga bhirodh te biya kotha kobole narukhe. ");
INSERT INTO nag_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kelemane amikhan tai pora etu kowa hunise, Nazareth laga Jisu pora etu jaga khotom kori dibo, aru Moses ki niyom amikhan ke dise etu sob bodli kori dibo.” ");
INSERT INTO nag_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Aru jiman manu sabha te bohi thakise sob Stephen ke he saise, aru tai laga chehera to sorgodoth laga chehera nisena dikhise. ");
INSERT INTO nag_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Titia maha purohit pora hudise, “Etu kotha khan hosa ase? ");
INSERT INTO nag_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Titia Stephen koise, “Bhai khan aru baba khan, moi laga kotha huni bhi: Isor laga mohima baba Abraham logote ahise jitia tai Mesopotamia te thakise, tai Haran te nathaka age pora; ");
INSERT INTO nag_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","aru taike koise, ‘Tumi laga mati aru ghor manu khan pora ulai jabi, aru moi jun jaga tumike dikha bo ta te jabi.’ ");
INSERT INTO nag_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Titia Abraham pora Chaldea laga desh chari kene Haran te thaki jaise; aru tai laga baba mora pichete, Isor pora taike etu jagate loi anise, jun jagate tumikhan etiya thaki ase. ");
INSERT INTO nag_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kintu Tai taike etu jaga diya nai, tai laga theng rakhibole bhi diya nai. Kintu Isor pora taike aru tai laga khandan ke, ekta jaga dibo koi kene kosom dise, tai laga bacha nathaka hoilebi. ");
INSERT INTO nag_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kintu Isor pora taike eneka koise, tai laga khandan khan dusra desh te alag manu hoi kene thakibo, aru etu jaga laga manu khan taikhan ke nokor bonai rakhibo aru charsoh saal tak bisi dukh dibo. ");
INSERT INTO nag_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘Aru,’ Isor koise, ‘jun jati taikhan ke nokor banabo, utu jati khan ke moi bisar koribo, titia taikhan ulai ahi kene moike etu jagate mohima koribo.’ ");
INSERT INTO nag_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Titia Isor pora Abraham ke sunnot laga kosom dise, titia Abraham, Isaac laga baba hoise aru ath-dinte Isaac ke sunnot korise; aru Isaac pora Jacob laga baba hoise, aru Jacob pora baroh ta bacha paise aru etu khandan laga baba hoise. ");
INSERT INTO nag_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kintu Joseph laga bhai khan tai uporte ke suku jolise, aru taike Egypt te bikiri kori dise; kintu Isor tai logote thakise. ");
INSERT INTO nag_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Aru Isor pora tai laga dukh sob pora bachai loise. Tai laga gyaan pora Egypt raja Pharaoh laga mon jiti loise, aru raja pora taike Egypt aru tai laga ghor uporte Governor bonai dise. ");
INSERT INTO nag_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Titia Egypt aru Canaan desh te akaal ahise, aru bisi dukh paise, aru amikhan laga baba khan khabole panai. ");
INSERT INTO nag_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kintu jitia Jacob hunise Egypt te dhaan ase koi kene, tai amikhan laga baba khan ke ta te pathaise. ");
INSERT INTO nag_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aru dusra bar Joseph nijor bhai khan ke tai kun ase utu janibole dise, aru Pharaoh bhi Joseph laga ghor manu khan ke jani loise. ");
INSERT INTO nag_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Titia Joseph tai laga kokai khan logote manu pathai kene Jacob aru tai logote pachatar jonke loi kene Egypt te anibole pothaise. ");
INSERT INTO nag_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Titia Jacob Egypt te jaise, Jacob aru amikhan laga baba khan sob ta te morise. ");
INSERT INTO nag_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aru taikhan laga mora gaw to Shechem te loijai kene kote Abraham pora Hamor bacha khan logote poisa dikene mati kini rakhise ta te kobor dise. ");
INSERT INTO nag_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Jitia Isor pora Abraham logote kosom khai kene rakha homoi ahise- etu kosom juntu Isor he Abraham logote korise- Egypt te manu bisi hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Joseph ke najana ekjon raja Egypt te ulaise. ");
INSERT INTO nag_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tai amikhan laga manu ke thogai dise, aru jiman notun jonom huwa bacha khan ase taikhan ke ulai anibole koise ta te taikhan eitu khan ke jinda thaki bole nadibo. ");
INSERT INTO nag_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Etu homoi te Moses jonom hoise; tai Isor nimite bisi sundur thakise, aru taike tin mohina tak tai baba ghor te rakhise. ");
INSERT INTO nag_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kintu jitia taike bahar te rakhise, Pharaoh laga swali pora taike loi kene nijor bacha nisena palise. ");
INSERT INTO nag_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Aru Moses ke Egypt laga gyaan aru niyom sob sikhai dise, aru tai kotha aru kaam te bhi bisi takot thakise. ");
INSERT INTO nag_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kintu jitia tai chalis saal hoi jaise, tai nijor Israel bhai khan ke lok kori bole mon korise. ");
INSERT INTO nag_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aru ek din, jitia Israel manu ekjon ke dukh pai thaka dikhise, Moses etu manu ke modot kori bole jaise, aru etu dikhi kene Moses pora etu Egypt manu ke morai dise. ");
INSERT INTO nag_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tai bhabisele, tai laga bhai khan bujhi bo paribo, Isor he taikhan ke bachai dibo nimite taike pathaise, kintu taikhan etu bujhi bo para nai. ");
INSERT INTO nag_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Aru dusra dinte duijon Israel manu jhagara kori thaka homoi te tai ponchise, aru ekjon-ekjon logote shanti rakhibole koise, ‘Bhai khan, kele nijor bhai kokai majote jhagara kori ase?’ ");
INSERT INTO nag_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kintu jun tai usorte manu logot jhagara kori thakise, Moses ke pichete dhakai kene, koise, ‘Tumike kun pora amikhan uporte hukum chola bole dise? ");
INSERT INTO nag_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Juwa kali ekjon Egypt manu ke morai diya nisena, moike bhi mora bole mon ase?’ ");
INSERT INTO nag_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Etu kotha huni kene Moses polai jaise, aru Median laga desh te alag desh manu hoi kene thaki jaise, aru ta te tai duita chokra bacha laga baba hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Aru jitia chalis saal paar hoi jaise, Probhu laga sorgodoth Sinai Pahar laga jongol te jui nisena kori kene tai usorte ahise. ");
INSERT INTO nag_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jitia Moses jui dikhise, tai etu dikhi kene bisi asurit hoise, aru usor pora sabole jaise, titia Probhu laga awaj hunise. ");
INSERT INTO nag_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Moi tumi laga baba khan laga Isor ase, Abraham, Isaac aru Jacob laga Isor.’ Titia Moses kapi kene bhoi pora ta te phale sabole para nai. ");
INSERT INTO nag_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Titia Probhu taike koise, ‘Tumi laga theng pora juta ulai rakhi dibi, kelemane kuntu jagate tumi khara ase etu jaga Pobitro ase. ");
INSERT INTO nag_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ami laga manu khan Egypt te dukh kori thaka Moi dikhise, aru taikhan kandi thaka awaj hunise, aru taikhan ke bacha bole nimite Moi ahise; etu karone ahibi, Moi tumike Egypt te pathabo.’ ");
INSERT INTO nag_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Etu Moses, junke Israel manu khan pora grohon kora nai, tai koise, ‘Kun he tumike moi khan uporte cholawta koribo dise?’- Tai ekjon thakise junke Isor pora cholawta bonaise aru bachai dibole nimite pathaise- aru sorgodoth hath pora Moses ke jongol te dikhai dise. ");
INSERT INTO nag_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses pora he Egypt pora taikhan ke ulai anise, aru sob asurit kaam khan Egypt laga matite dikhai thakise aru Ghar laga Samundar te, aru jongol majot pora taikhan ke chalis saal tak cholai kene loi jaise. ");
INSERT INTO nag_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Etu Moses he ase, jun Israel khan ke koise, ‘Isor pora tumikhan nimite tumikhan laga bhai kokai khan majot pora ekjon moi nisena bhabobadi ulai dibo.’ ");
INSERT INTO nag_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Etu tai ase, jongol te thaka homoi te, Sinai Pahar te sorgodoth logot kotha korise, aru kun amikhan baba laga baba khan logot asele, aru utu tai ase jun pora jinda kotha paikene amikhan ke ponchai dise. ");
INSERT INTO nag_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Etu manu laga kotha moi khan laga baba laga baba khan mani bole mon kora nai, kintu taike hatai dise, aru taikhan laga mon Egypt phale jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aru Aaron koise, ‘Amikhan nimite murti khan bonai dibi jun amikhan ke loi kene age jabo. Aru etu Moses, jun he amikhan ke Egypt pora loi anise, taike ki hoise amikhan najane.’ ");
INSERT INTO nag_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Titia taikhan ekta goru bacha bonaise, aru hath pora bona laga murti ke kiba ani kene boli dise, aru khushi manai thakise. ");
INSERT INTO nag_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kintu Isor taikhan ke chari kene akas aru tara khan ke puja kori bole dise, jineka bhabobadi khan laga kitab te likha ase, ‘Tumikhan moike janwar laga boli diya nai Chalis saal jongol te thaka homoi te, tumi Israel manu khan kotha manise? ");
INSERT INTO nag_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Apuni khan Molech laga tambu ke mani loise, Aru tumikhan laga bhagwan Rephan laga tara bhi, aru murti bonai kene puja kori bole loi jaise karone: Moi tumikhan ke Babylon pora bisi dur te loi rakhidibo.’ ");
INSERT INTO nag_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ami laga baba laga baba khan logot sakhi laga tambu ase, jineka taike dikhaise jongol te, tineka bona bole koise, aru thik tineka bonai loise. ");
INSERT INTO nag_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Etu ase tombu ghor juntu amikhan baba khan pora paikene Joshua hath pora loi yate anise, jitia taikhan desh khan ke gheri loi kene kabja kori loise, jun khan Isor he amikhan laga baba khan usor pora khedai dise, aru David raja laga homoi tak thakise, ");
INSERT INTO nag_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","jun Isor itcha te paise, tai mangise Jacob laga Isor ke thaki bole ekta jagah karone. ");
INSERT INTO nag_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kintu Solomon he Isor karone ekta ghor bonai dise. ");
INSERT INTO nag_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kintu, Mohan Isor to manu pora bonai diya ghor te nathake, bhabobadi pora kowa nisena, ");
INSERT INTO nag_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Sorgo to Ami laga singhason, aru prithibi Ami laga theng rakha jaga. Probhu koise, tumi Moi karone ghor bonai dibo? Aru Ami laga aram kora jaga to kote hobo? ");
INSERT INTO nag_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Moi he nijor hath pora etu sob bona nai naki?’ ");
INSERT INTO nag_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tumikhan phutani aru mon aru kaan te sunnot nakora khan, tumikhan Pobitro Atma laga hinsa kori thake, tumikhan baba laga baba khan kori aha nisena, tineka apuni khan bhi kore. ");
INSERT INTO nag_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Eneka kun bhabobadi ase junke tumikhan laga baba pora dukh diya nai? Taikhan pora ahibole thaka Dharmik Jon Jisu laga kotha kowa manu khan ke bhi morai dise, aru tumikhan bhi morai diya aru thogai diya khan hoi jaise, ");
INSERT INTO nag_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tumikhan sorgodoth khan pora diya Isor laga niyom luwa khan, hoilebi tumikhan manibo para nai.” ");
INSERT INTO nag_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jitia taikhan etu kotha hunise, sabha laga manu khan monte bisi khong hoise, aru dath kamuri kene Stephen uporte khong uthise. ");
INSERT INTO nag_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kintu tai Pobitro Atma te bhorta hoi kene, sorgote saise, aru Isor laga mohima aru Jisu to Isor laga dyna hath phale khara thaka dikhi paise. ");
INSERT INTO nag_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stephen pora hala kori kene koise, “Sabi, sorgo khuli thaka dikhi ase, aru Manu laga Putro Isor laga dyna hath phale khara kori ase.” ");
INSERT INTO nag_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Titia taikhan untcha awaj pora hala korise, aru kaan bondh kori kene sob eke logot tai usorte polai ahise. ");
INSERT INTO nag_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Aru taikhan taike sheher bahar te loijai kene taike pathor mari dise, aru gawahi khan taikhan laga kapra loise aru jawan manu ekjon naam Saul laga bhori te rakhise. ");
INSERT INTO nag_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Aru taikhan jitia Stephen ke pathor mari thakise, tai Isor ke mati kene koise, “Probhu Jisu, moi laga Atma loi lobi.” ");
INSERT INTO nag_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Titia tai athukarikena jor awaj pora koise, “Probhu, taikhan ke etu paap laga bisar nokoribi.” Etu koi kene tai ghumai jaise. ");
INSERT INTO nag_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul bhi Stephen ke morai dibole monjur korise, aru etu dinte Jerusalem te thaka girja te bisi dukh digdar ahise; aru sob biswasi khan Judea aru Samaria te alag-alag jai jaise, khali apostle khan he thakise. ");
INSERT INTO nag_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Biswasi manu khan pora Stephen laga gaw uthai loijai kene kobor dise, aru manu khan mon dukh korise. ");
INSERT INTO nag_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kintu Saul girja khan ke biya kori bole kosis kori thakise; aru ghor-ghor te jai kene, mota aru maiki sobke dhori kene bondhi ghor te hali dise. ");
INSERT INTO nag_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Aru jun biswasi alag phale jai jaisele taikhan ja-a jaga sob te khushi laga khobor prochar kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Titia Philip Samaria sheher te jai kene manu khan ke Khrista laga kotha prochar kori dise. ");
INSERT INTO nag_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Aru Philip ki kotha prochar korise, taikhan mon dikene hunise, aru tai kori diya asurit kaam khan dikhise. ");
INSERT INTO nag_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bisi manu bhitor te dusto atma khan thakise, aru eitu khan taikhan pora ulai jaise, jor pora hala kori kene. Bisi manu jothor aru lengra khan bhi changai paise. ");
INSERT INTO nag_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Aru etu sheher manu khan bisi khushi korise. ");
INSERT INTO nag_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kintu ta te Simon koi kene ekjon manu thakise, tai jadu montor kori kene Samaria manu khan ke asurit kori dise, aru tai nijorke ekjon dangor manu ase koi thake. ");
INSERT INTO nag_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aru sob Samaria manu chutu pora dangor tak tai laga kotha bhal pora huni thakise aru koise, “Etu manu logote Isor laga takot ase.” ");
INSERT INTO nag_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tai laga kotha manu khan hune, kelemane bisi homoi pora tai jadu montor kori kene manu khan ke asurit kaam dikhai thakise, etu karone taikhan tai laga kotha mani thakise. ");
INSERT INTO nag_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kintu jitia taikhan Philip ke biswas korise, aru tai Isor laga rajyo kotha aru Jisu Khrista laga naam ke prochar korise, bisi mota aru maiki khan baptizma loise. ");
INSERT INTO nag_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Titia Simon nijor bhi biswas korise, aru tai baptizma loi kene Philip logote thaki jaise, aru jitia asurit kaam khan kora dikhise, tai bisi khushi paise. ");
INSERT INTO nag_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jitia Jerusalem te thaka apostle khan Samaria pora Isor kotha loise koi kene hunise, taikhan nimite Peter aru John ke pathaise. ");
INSERT INTO nag_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jitia Peter aru John ta te punchise, taikhan nimite prathana korise, taikhan Pobitro Atma pabo nimite. ");
INSERT INTO nag_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kelemane Pobitro Atma taikhan logote aha nai, kintu taikhan Probhu Jisu naam pora khali baptizma he loi kene thaka karone. ");
INSERT INTO nag_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Titia Peter aru John taikhan uporte hath rakhi kene prathana kori dise, aru taikhan Pobitro Atma paise. ");
INSERT INTO nag_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aru jitia Simon dikhise apostle khan manu laga uporte hath rakhile Pobitro Atma pai ase, tai apostle khan ke poisa dibole bisarise. ");
INSERT INTO nag_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Titia tai koise, “Moike bhi etu adhikar dibi, ta te moi jun uporte hath rakhibo tai Pobitro Atma pabo.” ");
INSERT INTO nag_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kintu Peter taike koise, tumi laga poisa tumi logote khotom hoi jabo, kelemane tumi Isor laga bordan poisa pora kini bole bhabi ase. ");
INSERT INTO nag_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tumi laga yate eku bhag aru hisa nai, kelemane Probhu usorte tumi laga mon thik nohoi. ");
INSERT INTO nag_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Etu nimite mon ghura bhi aru biya bhabona pora ulabi, aru Probhu usorte prathana koribi, titia Tai pora tumi laga letera mon aru biya bhabona pora maph kori dibo pare. ");
INSERT INTO nag_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kelemane moi dikhi ase tumi laga biya bhabona aru paap pora bandi thaka mon to.” ");
INSERT INTO nag_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Titia Simon koise, “Probhu logot moi nimite prathana kori dibi, apuni pora ki koise etu moi uporte nahibole nimite.” ");
INSERT INTO nag_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jitia taikhan Isor kotha koi dise aru sakhi korise, Peter aru John wapas Jerusalem te jaise, aru Samaria manu laga bosti khan te jai kene Isor laga kotha prochar korise. ");
INSERT INTO nag_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Titia Probhu laga sorgodoth Philip logote kotha korise, aru koise, “Uthibi aru dakshin laga rasta jun to Jerusalem hoi kene Gaza te jai ta te jabi.”- Etu rasta balu laga jaga pora jai. ");
INSERT INTO nag_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Titia tai uthi kene jaise. Aru ta te Ethiopia laga ekjon hijira manu thakise, tai ekjon dangor adhikar chola manu thakise, tai Candace, Ethiopia laga rani laga dhun sampoti sa-a manu asele, aru tai mohima kori bole Jerusalem te jai thakise. ");
INSERT INTO nag_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aru tai laga ghora gaari te bohi kene wapas ghor te jai thakise, aru Isaiah bhabobadi laga kitab porhi thakise. ");
INSERT INTO nag_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Titia Atma pora Philip ke koise, “Jai kene ghora gari usorte bohibi.” ");
INSERT INTO nag_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Titia Philip tai usorte polaikene jaise, aru Tai Isaiah bhabobadi laga kitab porhi thaka hunise, aru koise, “Tumi ki porhi ase etu bujhi pai ase?” ");
INSERT INTO nag_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Titia tai koise, “Moi kineka janibo, jitia tak moike kunba pora nashikai?” Titia tai Philip ke ghora gari te bohi bole matise. ");
INSERT INTO nag_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Etiya jun to kitab Ethiopia manu pora porhi thakise etu eneka thakise, “Taike ekta mer bolidan dibole nisena loi jaise, Aru jineka mer bacha pora chuli kata manu usorte chup-chap pora bohe, Etu nisena, aru Tai pora Tai laga mukh khula nai. ");
INSERT INTO nag_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tai laga bisar sorom khilai dikene Tai usor pora loi jaise. Kun Tai laga manu khan ase koi kene kobo pare? Kelemane Tai laga jibon to etu duniya pora uthai loise.” ");
INSERT INTO nag_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Titia hijira pora Philip ke hudise, “Moi apuni ke anurodh kori ase, kun bhabobadi laga kotha koi ase, tai nijor laga koi ase, na dusra manu laga kotha koi ase?” ");
INSERT INTO nag_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Titia Philip tai mukh khuli se, aru Isor kotha pora shuru kori kene, Jisu laga kotha taike prochar korise. ");
INSERT INTO nag_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Taikhan rasta te jai thaka homoi te pani thaka jagah ponchise, titia hijira pora koise, “Sabi, yate pani ase, moike baptizma lobole nimite ki pora rukhai ase?’” ");
INSERT INTO nag_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Titia Philip pora koise, “Jodi tumi mon pora biswas kore, baptizma lobo pare.” Titia tai koise, “Moi biswas kore Jisu Khrista Isor laga chokra ase koi kene.” ");
INSERT INTO nag_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Titia tai ghora gari ke rukhibole hukum dise. Aru Philip aru hijira duijon panite namikene jaise, aru Philip pora taike baptizma dise. ");
INSERT INTO nag_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jitia taikhan pani pora ulai ahise, Probhu laga Atma pora Philip ke loi jaise, titia hijira taike aru dikha nai, kintu tai bisi khushi pora jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kintu Philip to Azotus te ahise, aru pura jagate tai jaise, jitia tak tai Caesarea puncha nai, tai sob sheher khan te jai kene Isor laga kotha prochar korise. ");
INSERT INTO nag_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kintu Saul, Probhu laga chela khan ke morai dibo koi kene kotha kori thakise aru tai moha purohit logote jaise ");
INSERT INTO nag_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aru tai moha purohit logote chithi mangise Damascus sheher laga mondoli khan nimite, jodi tai rasta te jai thaka homoi te kunba manu pai, mota aru mahila hoilebi, eitu khan ke dhori kene Jerusalem te loi jabole. ");
INSERT INTO nag_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jitia tai safar te jai thakise, Damascus te punchibole usor huwa homoi te, achanak sorgo pora ujala hoi kene ekta puhor tai uporte jolise; ");
INSERT INTO nag_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","aru titia tai matite giri jaise, aru ekta awaj taike koi thaka hunise, “Saul, Saul, kele tumi Moike dukh di ase?” ");
INSERT INTO nag_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Aru titia Saul hudise, “Apuni kun ase Probhu?” Aru Probhu jowab dise, “Moi Jisu ase junke tumi dukh di ase; pathor te theng marile nijor he jokhom pabo.” ");
INSERT INTO nag_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Titia tai asurit hoise aru bhoi pora kapi kene koise, “Probhu moi ki kori bole lage?” Titia Probhu taike koise, “Uthibi aru Damascus sheher te jabi, aru tumi ki koribo lage etu sob tumike koi dibo.” ");
INSERT INTO nag_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jun manu Saul logote jai thakise taikhan chup hoi jaise, taikhan awaj hunise, kintu kunke bhi dikha nai. ");
INSERT INTO nag_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Titia Saul khara hoise, aru jitia tai laga suku khuli se, tai eku bhi dikhi bole napara hoise; titia taikhan tai laga hath dhori kene Damascus te loi jaise. ");
INSERT INTO nag_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Aru tai tin din suku andha hoi jaise aru eku dikhi bole para nai, aru kha luwa bhi kora nai. ");
INSERT INTO nag_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascus te ekjon chela Ananias koi kene thakise. Probhu pora taike darshan pora koise, “Ananais!” Titia tai koise, “Sabi, moi yate ase Probhu.” ");
INSERT INTO nag_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Titia Probhu taike koise, “Uthibi, aru Sidha kowa rasta te jabi, aru Judas laga ghor te jai kene ekjon manu Saul, Tarsus sheher pora aha, ase na nai hudibi, kelemane tai prathana kori ase. ");
INSERT INTO nag_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Aru tai darshan te ekjon manu Ananias koi kene dikhise, aru tai uporte te hath rakhi kene thaka dikhise, etu pora tai aru dikhibo paribo.” ");
INSERT INTO nag_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kintu Ananias koise, “Probhu, moi etu manu laga kotha bisi manu pora hunise, tai Jerusalem te kiman pobitro manu ke dukh dise. ");
INSERT INTO nag_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tai moha purohit khan pora adhikar loise aru jun manu apuni laga naam lobo taike bondhi ghor te hali dibo.” ");
INSERT INTO nag_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kintu Probhu taike koise, “Jabi, kelemane tai Moi laga basi luwa kaam kora manu hobo, tai he moi laga naam Porjati khan ke, raja khan ke aru Israel laga bacha khan ke koi dibo; ");
INSERT INTO nag_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","kelemane Moi taike dikhai dibo, tai moi laga naam nimite ki dukh uthabo lagibo.” ");
INSERT INTO nag_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Aru Ananias etu ghor te jaise, aru tai laga hath Saul uporte rakhi kene koise, “Bhai Saul, Probhu Jisu pora tumi rasta te ahi thaka homoi te dikhai dise, Tai moike tumi usorte pathaise, tumi aru dikhibo aru Pobitro Atma pora bhorta hobo.” ");
INSERT INTO nag_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Etu homoi te Saul laga suku pora kiba chamra nisena giri jaise, aru tai dikhi bole parise, aru tai uthi kene baptizma loise; ");
INSERT INTO nag_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","aru tai bhat khai kene takot paise. Aru tai chela khan logote Damascus te olop din thakise. ");
INSERT INTO nag_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tai joldi mondoli khan te jai kene Khrista Isor laga Putro ase koi kene prochar korise. ");
INSERT INTO nag_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aru jun manu tai laga kotha hunise sob manu asurit hoi kene koise, “Jerusalem te Khrista naam loi thaka khan ke dukh diya to etu manu nohoi? Aru yate tai yate aha to taikhan ke bandi kene moha purohit khan logot loi jabole ahise.” ");
INSERT INTO nag_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kintu Saul aru bisi mon dangor hoise, aru Damascus te thaka Yehudi khan nimite ekta chinta hoi jaise aru Jisu he Khrista ase koikena prochar kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kintu bisi din ja pichete, Yehudi khan Saul ke morai dibole kotha milai loise. ");
INSERT INTO nag_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kintu taikhan laga bhabona to Saul jani loise. Taike morai dibole nimite din raat dorja usorte te rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kintu tai laga chela khan rati huwa homoi te, taike ani kene tukri pora diwar niche korise aru paar kori dise. ");
INSERT INTO nag_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aru jitia Saul Jerusalem te ahise, tai chela khan logote mili bole kosis korise, kintu taikhan sob taike bhoi korise, tai bhi ekjon chela ase koi kene biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kintu Barnabas pora taike apostle khan logote loi jaise, aru Probhu pora kineka taike rasta te lok paise aru ki koise, aru tai Damascus te kineka mon dangor pora Jisu laga naam prochar korise, etu sob koi dise. ");
INSERT INTO nag_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Titia tai chela khan logote Jerusalem te aha juwa korise. Aru tai mon dangor pora Probhu laga naam loise. ");
INSERT INTO nag_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tai Greece te thaka Yehudi khan logot bhi kotha korise; kintu taikhan taike morai dibole kosis korise. ");
INSERT INTO nag_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jitia biswasi bhai khan etu janise, taike Caesarea te loijai kene Tarsus te pathai dise. ");
INSERT INTO nag_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Titia, Judea aru Galilee aru Samaria laga girja khan shanti te thakise; aru Probhu laga bhoi te thakise aru ekjon-ekjon ke Pobitro Atma pora mon dangor kori dise, aru girja laga ginti aru bhi bisi hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Etiya eneka hoise, jitia Peter sob jagate safar korise, Lydda town te thaka Isor laga manu khan usorte bhi jaise. ");
INSERT INTO nag_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ta te tai Aeneas koi kene ekjon manu ke lok paise, tai bisna te ath saal pora ghumai thakise, aru tai jothor bemar thakise. ");
INSERT INTO nag_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter taike koise, “Aeneas, Jisu Khrista tumike changai koridi ase, uthibi aru tumi laga bisna thik kori lobi,” aru titia tai joldi uthijaise. ");
INSERT INTO nag_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Titia Lydda aru Sharon te thaka manu khan taike dikhi kene mon ghuraise aru Probhu ke biswas korise. ");
INSERT INTO nag_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa te Tabitha koi kene ekjon mahila chela thakise, jun laga motlob ase “Dorcas.” Etu mahila sob bhal kaam kore aru gorib manu khan uporte bisi morom thakise. ");
INSERT INTO nag_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kintu tai bemar pora mori jaise, aru taike gaw dhulai dikene upor kamra te rakhise. ");
INSERT INTO nag_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Aru Lydda jaga to Joppa usorte thakise, aru Peter ta te ase koi kene chela khan hunise, aru taikhan pora duijon manu ke tai logote anurodh kori kene pathaise, “Amikhan logote deri nohoi kene ahibi.” ");
INSERT INTO nag_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Titia Peter uthi kene taikhan logot jaise. Jitia tai ponchise, taikhan pora taike upor kamra te loi jaise aru ta te sob bidhowa khan tai usorte khara kori kene kandi thakise, aru Dorcas pora tai jinda thaka homoi te taikhan nimite kapra bonai diya khan dikhai dise. ");
INSERT INTO nag_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kintu Peter taikhan sobke bahar jabo dise, aru tai athukari kene prathana korise. Titia, tai laga gaw phale saikene koise, “Tabitha, uthibi.” Tai suku khuli se, aru Peter ke dikhi kene tai bohi jaise. ");
INSERT INTO nag_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Titia Peter tai laga hath dikene taike uthai dise; aru pobitro manu aru bidhowa khan ke jinda hoi juwa to dikhai dise. ");
INSERT INTO nag_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Aru Joppa te thaka sob etu kotha jani loise, aru bisi manu Probhu ke biswas korise. ");
INSERT INTO nag_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter bisi din Joppa te Simon koi kene ekjon manu ghor te thakise. ");
INSERT INTO nag_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Titia ekjon manu Cornelius koi kene Caesarea te thakise, aru tai Italy laga Regiment te ekjon dangor henapoti thakise. ");
INSERT INTO nag_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tai aru tai laga ghor manu khan sob Isor ke bhoi kora khan thakise; aru tai manu khan ke poisa dikena modot kora manu asele, aru hodai Isor logote prathana kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ek din tin baji nisena te, tai ekta sapha sapna dikhise, Isor laga ekjon sorgodoth tai logote ahi kene koise, “Cornelius!” ");
INSERT INTO nag_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kintu Cornelius sorgodoth ke bhoi pora saikene hudise, “Ki ase, malik?” Titia sorgodoth pora taike koise, “Tumi laga prathana aru dukh manu ke modot kora to Isor pora dikhise. ");
INSERT INTO nag_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Etiya Joppa te kunba manu pathai kene Simon, kunke Peter bhi mate, taike anibi. ");
INSERT INTO nag_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tai Simon koi kene ekjon chamra ula kaam kora manu laga ghor te ase, tai laga ghor samundar kinar te ase.” ");
INSERT INTO nag_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jitia sorgodoth taike kotha koi kene jai jaise, Cornelius tai laga duijon noukar ke matise, aru bisi majote ekjon bhal sipahi jun taike sewa kore taike bhi mati anise. ");
INSERT INTO nag_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Aru taikhan ke sob kotha koi diya pichete, Cornelius taikhan ke Joppa te pathaise. ");
INSERT INTO nag_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Etiya aru alag din ekta te, taikhan jai thaka homoi te ekta sheher te ponchise, Peter ghor uporte prathana kori bole jaise. ");
INSERT INTO nag_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Titia tai bisi bhuk lagise, aru kiba khabole itcha thakise, kintu jitia manu khan bhat bonai thakise, tai ekta darshan dikhise, ");
INSERT INTO nag_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","aru tai akas pora kiba ekta saman aha dikhise, ekta dangor kapra, charta kinar pora bandhi kene prithibi nichete ahi thaka dikhise. ");
INSERT INTO nag_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Aru ta te prithibi laga sob janwar charta theng thaka aru matite rengi kene choli thaka jongli janwar, aru akas laga chiriya khan sob thakise. ");
INSERT INTO nag_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aru titia ekta awaj taike koise: “Uthibi, Peter, aru mari kene khabi.” ");
INSERT INTO nag_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kintu Peter koise, “Nohobo Probhu, moi kitia bhi sapha nathaka aru letera saman khanai.” ");
INSERT INTO nag_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kintu aru ekbar awaj ahi kene koise: “Ki Isor pora sapha kori dise, etu ke letera ase nokobi.” ");
INSERT INTO nag_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Aru eneka ti bar hoise; titia saman pora bhorta thaka sorgote wapas loi jaise. ");
INSERT INTO nag_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Titia Peter etu darshan laga ki motlob ase koi kene bisi chinta bhabona korise, etu homoi te, Cornelius pora kun manu ke pathaise taikhan ahi kene dorjate khara hoi thakise, taikhan ahi kene Simon laga ghor kot te ase etu bisari kene ahise. ");
INSERT INTO nag_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Aru taikhan ahi kene matise, aru Simon kunke Peter bhi koi, tai ta te thaki ase na nai etu hudise. ");
INSERT INTO nag_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Etu homoi te bhi Peter to tai ki darshan paise etu bhabona kori thakise, titia Pobitro Atma pora taike koise, “Sabi, kunba manu tumike bisari ase. ");
INSERT INTO nag_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Uthibi aru taikhan logote jabi, eku bhabona nokoribi, kelemane moi he taikhan ke pathaise.” ");
INSERT INTO nag_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Titia Peter niche kamra te namikene taikhan ke koise, “Sabi, tumikhan kunke bisari ase etu moi ase. Ki nimite tumikhan moike bisari kene ahise?” ");
INSERT INTO nag_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Aru taikhan koise, “Henapoti Cornelius jun dharmik manu ase, aru sob Yehudi desh manu khan pora tai laga bhal kotha he koi, pobitro sorgodoth pora etu ghor te apuni logote pathaise, apuni pora kowa kotha to huni bole nimite.” ");
INSERT INTO nag_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Titia Peter taikhan ke tai logote thaki bole matise. Aru dusra dinte uthi kene taikhan logote jaise, aru Joppa pora kunba bhai khan bhi tai logote jaise. ");
INSERT INTO nag_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aru dusra dinte taikhan Caesarea te ponchise. Cornelius pora tai laga sathi aru ghor manu khan ke bhi mati kene rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jitia Peter ghor bhitor te ahise, Cornelius ahi kene taike lok korise, aru taike aradhana kori bole Peter laga theng nichete girise. ");
INSERT INTO nag_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kintu Peter taike uthaikene, koise, “Uthibi! Moi nijor bhi ekjon manu he ase.” ");
INSERT INTO nag_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Aru jitia Peter tai logote kotha kori thakise, tai jai kene manu bisi joma kori thaka paise. ");
INSERT INTO nag_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Titia tai taikhan ke koise, “Apnikhan bhi jani ase, Yehudi manu dusra jati khan ke lok kora aru eke logote mili kene aha juwa kora niyom nai. Kintu Isor pora moike dikhaise aru koise kunke bhi letera aru sapha nai eneka nokobi. ");
INSERT INTO nag_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Etu nimite moi apuni khan logote eku nokoi kene ahise, jitia apuni pora moike mati bole pathaise. Etu karone moi hudise ki nimite moike lobole pathaise?” ");
INSERT INTO nag_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Titia Cornelius koise, “Char din age te etu homoi te, moi ghor te prathana kori thakise; aru sabi ekjon manu moi usorte boga kapra lagai kene khara kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Aru tai koise, ‘Cornelius, tumi laga prathana huni loise, aru tumi gorib manu khan ke modot kora to Isor pora Tai usorte yaad kori ase. ");
INSERT INTO nag_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Etu karone kunba ke Joppa te patha bhi, aru Simon junke Peter koi. Taike mati bhi, tai samundar kinar te chamra ula kaam kora manu Simon koi kene ekjon ghor te ase.’ ");
INSERT INTO nag_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Etu karone moi apuni ke lobole kunba manu pathaise. Aru apuni aha karone bisi bhal paise, aru etu karone, amikhan aji Isor usorte sob manu joma hoi ase, aru Probhu pora apuni ke ki koise etu huni bole nimite joma hoise.” ");
INSERT INTO nag_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Titia Peter mukh khuli kene koise, “Hosa pora, Isor to kun logote bhi alag pora nasai kintu Tai sobke eke morom kore. ");
INSERT INTO nag_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kintu, jun desh te hoilebi jun he Isor ke bhoi koribo aru Tai laga itcha pora kaam koribo tai uporte hodai Isor laga khushi thakibo. ");
INSERT INTO nag_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Etu kotha Israel laga bacha khan nimite di pathaise, shanti laga susamachar Jisu Khrista dwara, kun he sob laga Probhu ase- ");
INSERT INTO nag_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","etu kotha aha to tumikhan bhi jani ase, aru sob Judea te bhorta hoijai ase, Galilee pora shuru kori kene, aru John pora baptizma kotha koi diya pichete; ");
INSERT INTO nag_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","aru Nazareth Jisu laga kotha khan, kineka Pobitro Atma aru takot pora Taike Isor pora asirbad kori dise, jiman manu bhoot pora bandhi rakhise taikhan ke changai korise aru tai bhal kaam kori kene thakise, kelemane Isor tai logote asele. ");
INSERT INTO nag_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jisu ki korise moi khan sob etu laga gawahi ase, Yehudi khan laga desh sob jagah te, aru Jerusalem te ki-ki korise amikhan utu sob laga gawahi ase. Taikhan Taike Cross te latkai kene morai dise. ");
INSERT INTO nag_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kintu Isor Taike tin dinte jinda kori dise aru manu khan ke dikhai dise, ");
INSERT INTO nag_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sob manu ke nohoi, kintu Isor poila pora basi luwa khan ke- moi khan pora jun Tai logote kha luwa korise Tai mori kene jinda huwa pichete. ");
INSERT INTO nag_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aru Tai moi khan ke sob manu khan logote jai kene Tai he Isor pora basi luwa ekjon ase aru mora aru jinda sob jati uporte bisar kora ekjon ase koi kene manu khan ke jonai dibi koise. ");
INSERT INTO nag_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jiman bhabobadi ase sob Tai laga gawahi he ase, jun manu Taike biswas kore Tai laga naam te sob manu paap pora maph pabo.” ");
INSERT INTO nag_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Jitia Peter etu kotha khan koi thakise, jun manu tai laga kotha huni thakise taikhan uporte Pobitro Atma ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Aru Peter logot jiman sunnot kora biswasi khan ahise taikhan asurit hoi jaise, kelemane Pobitro Atma pora jati manu khan uporte bhi di dise. ");
INSERT INTO nag_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kelemane taikhan pora Porjati khan alag kotha kora aru Isor ke dhanyavad di thaka hunise. Titia Peter pora etu kotha koise, ");
INSERT INTO nag_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kun pora taikhan ke baptizma lobole nadibo nimite pani pora dur rakhibo paribo naki, amikhan sob Pobitro Atma pa nisena?” ");
INSERT INTO nag_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Aru tai taikhan ke Jisu Khrista naam pora baptizma lobole koise, titia taike aru olop din taikhan logote thaki bole anurodh korise. ");
INSERT INTO nag_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Titia apostle khan aru Judea te thaka biswasi bhai khan hunise Porjati khan bhi Isor laga kotha ke mani loise koi kene. ");
INSERT INTO nag_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Aru jitia Peter Jerusalem te wapas ahise, jun khan sunnot koribo lage koi, taikhan logote kotha te laga lagi jaise; ");
INSERT INTO nag_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","taikhan koise, “Apuni khan sunnot nakora manu khan logote jai kene kha luwa korise!” ");
INSERT INTO nag_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kintu Peter taikhan ke bhal pora samjai kene koise, ");
INSERT INTO nag_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Moi Joppa laga sheher te prathana kori thakise, titia moi upor pora saman nichete ahi thaka darshan te dikhise, ekta dangor kapra charta kinar pora bandi kene ahi thakise, etu moi logote ahise. ");
INSERT INTO nag_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Moi etu ke bhal pora saikene bhabona korise. Moi duniya te charta theng thaka janwar dikhise, aru jongli janwar, matite jai thaka janwar aru akas laga chiriya khan dikhise. ");
INSERT INTO nag_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aru moike ekta awaj pora koise, “Uthibi, Peter; mari kene khabi!” ");
INSERT INTO nag_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kintu moi koise, “Nohobo, Probhu; moi kitia bhi pobitro aru sapha nathaka saman moi laga mukh te ghusa nai.” ");
INSERT INTO nag_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kintu dusra bar aru ekta awaj pora moike koise, “Ki saman Isor pora sapha ase koise, etu ke letera nokobi.” ");
INSERT INTO nag_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Aru eneka tin bar hoise, titia sob saman akas te aru uthai loi jaise. ");
INSERT INTO nag_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Aru etu homoi te, moi thaka ghor te tinjon manu ahikena khara hoise; taikhan ke Caesarea pora moi logot pathaise. ");
INSERT INTO nag_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Titia Pobitro Atma pora moike taikhan logote jabole koise, kintu taikhan kun ase etu moike koi diya nai, titia choi jon bhai khan moi logote jaise, aru moi khan etu manu laga ghor te jaise. ");
INSERT INTO nag_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Titia tai pora amikhan ke koise kineka ekjon sorgodoth pora tai laga ghor te khara kori kene taike koise, “Joppa te manu ke pathabi aru Simon ke loi anibole kobi. ");
INSERT INTO nag_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tai tumike Isor kotha koi dibo, aru etu kotha huni kene tumi aru tumi laga ghor manu khan sob poritran pabo.” ");
INSERT INTO nag_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Aru jitia moi kotha koi thakise, Pobitro Atma taikhan logote ahi jaise, jineka shuru te amikhan logote ahisele. ");
INSERT INTO nag_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Titia moike Probhu laga kotha yaad ahise, kineka tai John ke koise, “John pani pora baptizma diye; kintu tumikhan Pobitro Atma pora baptizma lobo.” ");
INSERT INTO nag_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jodi Isor taikhan ke daan dise jineka amikhan ke bhi dise, juntu pora amikhan Probhu Jisu Khrista ke biswas kore, to moi kun ase, Isor laga kotha namanibole?” ");
INSERT INTO nag_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jitia taikhan etu kotha hunise, taikhan eku jowab diya nai, kintu taikhan Isor ke dhanyavad dise, aru koise, “Tinehoile Isor pora Porjati khan ke bhi notun jonom dise.” ");
INSERT INTO nag_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephen ke morai diya homoi te biswasi khan dukh pa-a pora alag-alag jagate jai jaise, taikhan Isor laga kotha koi kene Phoenicia, Cyprus, aru Antioch te khali Yehudi khan logote prochar kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kintu taikhan kunba manu khan Cyprus aru Cyrene laga manu thakise, aru taikhan Antioch te ahise aru Yunani manu khan logote bhi kotha korise, aru taikhan ke Probhu Jisu laga prochar korise. ");
INSERT INTO nag_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Aru Probhu laga hath taikhan uporte thakise; aru bisi manu, biswas kori kene, Probhu logot ahise. ");
INSERT INTO nag_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Titia taikhan laga kotha Jerusalem te thaka girja khan pora hunise, aru taikhan Barnabas ke Antioch te pathai dise. ");
INSERT INTO nag_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jitia tai ahi kene Isor laga anugraha dikhise, tai khushi paise; aru taikhan laga mon dangor kori kene arubi pura mon pora Probhu logote thaki bole koise. ");
INSERT INTO nag_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kelemane tai ekjon biswas te thaka aru Pobitro Atma pora bhorta kori kene thaka ekjon bhal manu thakise, aru bisi manu Probhu ke grohon korise. ");
INSERT INTO nag_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Titia Barnabas to Saul ke bisari bole Tarsus te jaise. ");
INSERT INTO nag_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aru jitia taike paise, taike Antioch te loi anise. Aru eneka hoise, pura saal taikhan eke logote thakise aru girja te manu khan ke sikhai thakise, aru titia Antioch te poila bar chela khan ke Khristan khan koi kene matise. ");
INSERT INTO nag_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aru etu homoi te bhabobadi khan kunba Jerusalem pora Antioch te ahise. ");
INSERT INTO nag_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Aru taikhan majot, Agabus koi kene ekjon khara hoi kene jineka pura duniya te bisi dangor akaal ahibole ase, Atma pora taike dikhai diya nisena bhabobani koise. Etu sob Claudius laga dinte hoise. ");
INSERT INTO nag_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Titia chela khan, jun khan jabo paribo, taikhan jai kene Judea te thaka bhai khan ke modot pathai dibo nimite kotha korise. ");
INSERT INTO nag_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Aru taikhan eneka korise; Barnabas aru Saul laga hath pora ta te thaka bura khan ke poisa pathai dise. ");
INSERT INTO nag_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Etu homoi te raja Herod pora girja manu kunba khan ke dhurise aru bisi digdar dise. ");
INSERT INTO nag_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Aru tai John laga bhai James ke talwar pora morai dise. ");
INSERT INTO nag_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Aru jitia Yehudi cholawta khan etu karone bisi khushi pa-a janise, tai Peter ke bhi dhori bole jaise. Aru etu homoi to khomir nadhala laga roti kha laga din khan thakise. ");
INSERT INTO nag_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Jitia tai Peter ke dhori loise, taike bondhi ghor te hali dise, aru charta sipahi khan ke tai uporte sabole rakhidise; tai Peter ke Nistar Purbb dinte manu khan usorte ulaikene anibole bhabi thakise. ");
INSERT INTO nag_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Etu homoi te, Peter ke bondhi ghor te rakhi thakise, kintu girja manu khan mon pora tai nimite hodai Isor logot prathana kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Aru Peter ke Herod pora bisar nakora ek rati age te, Peter to duijon sipahi majote ghumai thakise, loha laga rusi duita pora bandi kene thakise, aru dorja usorte duijon sipahi taike rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Titia, achanak pora Probhu laga sorgodoth tai usorte ahise, aru bondhi ghor bhitor te ujala pora bhorta hoi jaise. Tai Peter laga kona te marise, aru taike uthaikene koise, “Joldi uthibi,” aru taike bandhi kene rakha luha rusi giri jaise. ");
INSERT INTO nag_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Titia sorgodoth taike koise, “Kapra lagabi aru juta to lagai lobi.” Peter eneka korise. Sorgodoth taike koise, “Bahar laga ki kapra ase etu lagabi aru moi laga piche ahibi.” ");
INSERT INTO nag_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Titia Peter sorgodoth laga pichete jaise. Kintu tai jana nai etu sob to hosa pora sorgodoth he kori ase. Tai darshan he dikhi ase bhabise. ");
INSERT INTO nag_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Jitia taikhan poila thaka duijon sipahi aru bahar te thaka duijon sipahi ke paar korise, taikhan loha laga ekta dorja usorte punchise juntu khuli kene taikhan sheher te jabo paribo; aru etu nijor pora khuli jaise. Titia taikhan ulaikene rasta nichete jaise, aru sorgodoth taike chari kene jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Aru jitia Peter etu sob hosa pora hoise koi kene jani loise, tai nijorke koise, “Etiya moi hosa pora jani loise Probhu moike Herod laga hath pora bachai lobole nimite Tai laga sorgodoth ke pathai dise, aru Yehudi manu khan ki bhabona kori thakise etu pora moike ulaikene anise.” ");
INSERT INTO nag_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Jitia tai etu buji jaise, tai John, kunke Mark bhi mate tai laga ama Mary laga ghor te jaise, ta te bisi manu khan joma kori kene prathana kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Aru jitia Peter dorjate marikena awaj dise, ekjon chukri noukar Rhoda koi kene dorja khuli bole ahise. ");
INSERT INTO nag_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Jitia tai Peter laga awaj janise, khushi pora dorja khuli bole pahorise; aru tai, polaikene kamra te ahise; aru taikhan ke Peter dorjate khara kori kene ase koise. ");
INSERT INTO nag_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Titia taikhan pora koise, “Tumi pagli hoise.” Kintu tai Peter ahise koi kene jor pora koi dise. Titia taikhan koise, “Etu tai laga sorgodoth hobo.” ");
INSERT INTO nag_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kintu Peter to dorjate mari thakise, aru jitia taikhan dorja khuli se, taikhan taike dikhi kene bisi asurit hoise. ");
INSERT INTO nag_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kintu tai taikhan ke hath pora chup thaki bole dikhai dise, aru kineka kori kene Probhu pora taike bondhi ghor pora ulai dise etu taikhan ke koise, “Jai kene etu kotha James aru bhai khan ke kobi.” Aru ta te pora tai dusra jagate jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Aru jitia din hoise, sipahi khan Peter logote ki hoise eku bhi jana nai. ");
INSERT INTO nag_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Aru jitia Herod Peter ke bisari kene panai, tai sipahi khan ke hudise aru taikhan ke morai dibole hukum dise. Etu pichete tai Judea pora jai kene Caesarea te thakise. ");
INSERT INTO nag_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Aru Herod to Tyre aru Sidon laga manu khan uporte bisi khong thakise. Etu karone taikhan joma hoi kene eke logote taike lok kori bole ahise. Taikhan Blastus koi kene Raja laga kaam kora ekjon ke kotha korise aru taikhan ke modot kori bole phuslai loise. Titia taikhan shanti thaki bole nimite mangise, kelemane taikhan laga desh te kha luwa kiman jai, sob etu raja laga desh pora he jai thakise. ");
INSERT INTO nag_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kotha kori kene rakha dinte, Herod raja laga kapra lagai kene tai nijorke taiyar korise. Tai laga singhason te bohi kene taikhan ke kotha korise. ");
INSERT INTO nag_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kintu manu khan hala kori koise, “Etu Isor laga awaj ase, manu laga nohoi!” ");
INSERT INTO nag_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Titia etu homoi te Probhu laga sorgodoth joldi taike mari dise, kelemane tai Isor ke mohima diya nai; aru puka pora taike khai kene morai dise. ");
INSERT INTO nag_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Aru Isor laga kotha bisi-bisi hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Aru jitia Barnabas aru Saul taikhan laga kaam pura kori loise, taikhan Jerusalem te jaise, aru John kunke Mark bhi mate taike bhi loi anise. ");
INSERT INTO nag_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Aru Antioch girja te bhabobadi khan aru hikhok khan bhi thakise. Barnabas aru Simon -junke Niger koi-, aru Cyrene laga Lucius, - Herod tetrarch pora pala bhai- aru Saul. ");
INSERT INTO nag_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jitia taikhan Isor ke aradhana kori kene aru upwas kori thakise, Pobitro Atma pora koise, “Tumikhan Barnabas aru Saul ke Ami nimite alag rakhi dibi, Moi taikhan nimite ki kaam ase etu kori bole karone.” ");
INSERT INTO nag_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Titia taikhan upwas rakhise aru duijon uporte hath dikena prathana kori dise, aru tai duijon ke pathai dise. ");
INSERT INTO nag_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas aru Saul ke Pobitro Atma pora Seleucia te pathai dise; aru taikhan naw te uthi kene Cyprus majuli te jaise. ");
INSERT INTO nag_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Aru jitia duijon Salamis sheher te ponchise, taikhan Yehudi khan laga mondoli te jai kene Isor laga kotha prochar korise. Aru duijon ke modot kori bole John Mark bhi thakise. ");
INSERT INTO nag_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Aru jitia taikhan Paphos sheher laga sob jagate jaise, ta te ekjon jadu kora manu ke lok paise, Yehudi laga misa bhabobadi, tai laga naam Bar Jesus thakise. ");
INSERT INTO nag_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Etu jadu kora manu to Proconsul Sergius Paulus logote thakise, tai gyaan thaka manu asele. Tai Barnabas aru Saul ke matise, kelemane tai Isor laga kotha huni bole mon thakise. ");
INSERT INTO nag_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kintu Elymas “Jadu kora manu” -taike eneka naam pora he mate- taikhan ke bhirodh korise; tai proconsul ke biswas pora hatai dibole kosis korise. ");
INSERT INTO nag_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Titia Saul, junke Paul koi kene mate, taike Pobitro Atma pora bhorta hoise, aru taike bhal pora saise ");
INSERT INTO nag_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aru koise, “Tumi saitan laga bacha, tumi sob biya kaam pora bhorta hoi ase aru tumi logote sob letera bhabona he ase. Tumi dharmikta laga sob kisim kaam laga dushman ase. Tumi Probhu laga sidha rasta to tera kori bole kitia bhi norokhibo, hoi na nohoi? ");
INSERT INTO nag_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Etiya sabi, Probhu laga hath tumi uporte ase, aru tumi suku andha hoi jabo. Tumi olop din nimite suryo to nadikhibo.” Etu homoi te Elymas uporte andhera ahi jaise, aru tai manu khan ke tai laga hath dhurikena loi jabole modot mangise. ");
INSERT INTO nag_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jitia proconsul pora ki hoise etu dikhise, tai biswas korise, kelemane tai Isor laga kotha sikhai diya to asurit lagise. ");
INSERT INTO nag_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Aru titia Paul aru tai laga sathi khan Paphos pora naw te uthi kene jaise aru Pamphylia jagate thaka Perga sheher te ahi jaise. Kintu John taikhan ke chari kene aru Jerusalem te wapas ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kintu Paul aru tai laga sathi khan Perga te jaise aru Antioch laga Pisidia jagate ponchise. Taikhan Bisram laga dinte mondoli te jai kene bohise. ");
INSERT INTO nag_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bhabobadi aru niyom laga kotha porha pichete, mondoli laga cholawta khan pora koise, “Bhai khan, yate laga manu khan nimite kiba bhal kotha ase koile, kobi.” ");
INSERT INTO nag_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Titia Paul khara korise aru hath pora dikhai kene koise, “Israel manu aru Isor ke bhoi kori kene thaka khan, huni bhi. ");
INSERT INTO nag_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel manu laga Isor pora moi khan baba laga baba khan ke basi loise aru bisi kori dise jitia taikhan Egypt te thakise, aru Tai laga hath to uthaikene taikhan ke tai pora ulai loi anise. ");
INSERT INTO nag_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Aru chalis saal tak Tai jongol te taikhan logote thakise. ");
INSERT INTO nag_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Aru jitia Tai Cannan laga sat-ta desh ke khotom kori dise, Tai etu jaga amikhan laga manu khan ke dise. ");
INSERT INTO nag_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Etu sob charsoh pachas saal upor hoise. Etu sob huwa pichete, Isor taikhan ke bisar dise jitia tak bhabobadi Samuel aha nai. ");
INSERT INTO nag_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Titia taikhan raja mangise, aru Isor pora taikhan ke Kish laga chokra Saul dise, ekjon Benjamin laga jat pora, chalis saal tak raja hobole dise. ");
INSERT INTO nag_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kintu Isor pora Saul ke raja laga jaga pora hatai diya pichete, taikhan nimite David ke raja bonai dise. Aru David nimite bhi Isor pora koise, ‘Moi laga mon usorte te thaka ekjon Jesse laga chokra David ke paise, tai moi laga itcha kaam sob koribo.’ ");
INSERT INTO nag_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Etu manu laga khandan pora Isor Israel te bachai diya, Jisu ke pathaise, Tai Israel manu khan ke kosom diya nisena. ");
INSERT INTO nag_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Etu sob to shuru hoise jitia, Jisu naha age te, John poila Israel manu khan ke baptizma dikene mon ghura bole koise. ");
INSERT INTO nag_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aru jitia John laga kaam khotom kori thakise, tai hudise, ‘Moike tumikhan kun ase bhabe? Moi etu nohoi. Kintu huni bhi, ekjon ahi ase, aru tai laga theng laga juta bandhi bole bhi moi layak nai.’ ");
INSERT INTO nag_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Hey bhai khan, Abraham khandan laga bacha khan, apuni khan majote kun Isor ke bhoi kore, amikhan nimite he etu notun jibon laga kotha to pathai dise. ");
INSERT INTO nag_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kunkhan Jerusalem te thaki ase, aru taikhan laga cholawta khan Taike chini bole para nai, aru bhabobadi khan kowa to pura kori dise, jun to ase, hodai Bisram dinte Taike hinsa aru bodnam kori kene puri thake. ");
INSERT INTO nag_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aru taikhan Taike morai dibole eku golti napai le bhi, taikhan Pilate ke Jisu morai dibole koise. ");
INSERT INTO nag_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jitia Tai nimite Shastro te ki likha ase etu sob pura hoise, taikhan Cross pora Taike namai ani kene kobor te rakhidise. ");
INSERT INTO nag_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kintu Isor Taike mora pora aru bhi jinda kori dise. ");
INSERT INTO nag_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aru Tai logote Galilee pora Jerusalem te kun manu khan ahise bisi din tak Taike dikhise. Aru etu manu khan Tai laga gawahi manu khan ke koi kene berai. ");
INSERT INTO nag_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Aru etu nimite amikhan etu kotha to koi kene prochar kore juntu Isor pora amikhan laga baba khan ke kosom disele. ");
INSERT INTO nag_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Isor he sob kotha to amikhan nimite, taikhan laga bacha khan nimite pura kori dise, Jisu ke jinda kori diya pora. Bhajan Geet te likhi kene thaka nisena: ‘Tumi Moi laga chokra ase, aji pora Moi tumi laga Baba hoise.’ ");
INSERT INTO nag_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Taike mora pora jinda kori diya motlob ase Tai laga gaw to kitia bhi napuchibo, Isor to eneka koise: Moi tumike Pobitro aru hosa asirbad dibo juntu moi David ke kosom disele.’ ");
INSERT INTO nag_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Etu nimite tai dusra Psalms te aru koi kene ase, ‘Apuni kitia bhi Pobitro ekjon ke puchibole nadibo.’ ");
INSERT INTO nag_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kelemane David tai laga homoi te Isor laga itcha pora Tai nijor manu ke sewa kori thakise aru mori jaise, aru tai baba khan logot moidam te dise, aru puchi jaise. ");
INSERT INTO nag_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kintu Jisu junke Isor jinda kori dise, Taike puchibole diya nai. ");
INSERT INTO nag_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kintu apuni khan jani lobi, manu khan, bhai khan, etu manu pora he apuni khan paap to maph pabo, aru sob biya pora ajadi pabo jun to Moses laga niyom pora bhi apnikhan ke dibole para nai. ");
INSERT INTO nag_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Aru jun Taike biswas kore tai bachi jabo. ");
INSERT INTO nag_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Etu karone hoshiar thakibi bhabobadi khan pora ki koise etu apuni khan logote nohobole nimite: ");
INSERT INTO nag_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Sabi, hinsa kora khan, asurit hoi kene nijor harai jabi; Moi apuni khan laga homoi te kaam kori ase, Etu kaam juntu tumikhan kitia bhi biswas nakore, jodi bhi kunba apuni khan ke ahikena koi dile bhi.’” ");
INSERT INTO nag_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Aru jitia Paul aru Barnabas jaise, manu khan taikhan ke anurodh korise etu kotha ahi kene aru Bisram dinte koi dibole. ");
INSERT INTO nag_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Aru jitia mondoli laga sabha khotom hoise, Yehudi khan aru Yunani bhasa kotha koi thaka Yehudi khan Paul aru Barnabas pichete jaise, aru taikhan pora duijon ke Isor laga morom to koi thaki bole nimite koise, ");
INSERT INTO nag_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Aru Bisram laga dusra dinte, pura sheher eke logote joma hoise Probhu laga kotha huni bole nimite. ");
INSERT INTO nag_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kintu jitia Yehudi khan pora dangor bhir dikhise, taikhan suku jolise aru Paul laga biya kotha koise aru taike sorom khilai dise. ");
INSERT INTO nag_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kintu Paul aru Barnabas mon dangor kori kene koise, “Isor kotha apuni khan logote poila kobole bisi dorkar thakise. Kintu Isor kotha to hatai diya dikhi kene tumikhan Tai laga rajyote jabole layak nai, sabi, amikhan Porjati khan logot jai ase. ");
INSERT INTO nag_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Etu karone Probhu he moike hukum dise, aru koise, ‘Moi tumikhan ke biswas nathaka khan laga ekta puhor bonai dise, Etu pora tumikhan prithibi laga sob kona te jai kene anonto jibon laga kotha to koi dibo.’” ");
INSERT INTO nag_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jitia Porjati khan etu kotha hunise, taikhan khushi paise aru Probhu laga kotha ke dhanyavad dise. Aru jiman manu anonto jibon pabole ase eitu khan biswas kori loise. ");
INSERT INTO nag_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Aru Probhu laga kotha sob usor-usor jagate prochar hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kintu niyom luwa manu aru dorkar thaka maiki, aru sheher te manu majote naam thaka khan ke Yehudi khan pora Paul aru Barnabas ke digdar dibole korise, aru duijon ke taikhan laga desh pora bahar ulai dise. ");
INSERT INTO nag_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kintu Paul aru Barnabas taikhan usor pora theng laga dhula sapha korise. Aru ta te pora Iconium laga sheher te jaise. ");
INSERT INTO nag_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aru chela khan Pobitro Atma pora bhorta hoi kene khushi pora thakise. ");
INSERT INTO nag_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Etiya Iconium te eneka hoise, Paul aru Barnabas pora Yehudi khan laga mondoli te jaise aru kineka tai duijon kotha koise, etu huni kene bisi Yehudi aru Porjati manu khan biswas korise. ");
INSERT INTO nag_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kintu kotha namana Yehudi khan pora manu khan laga bhabona biya kotha pora bhorta kori kene nijor bhai khan laga dushman kori dise. ");
INSERT INTO nag_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kintu taikhan ta te olop din thakise, aru Isor laga kotha mon dangor pora koise, aru Isor he Paul aru Barnabas laga hath pora Tai laga asurit kaam manu khan ke dikhai dise. ");
INSERT INTO nag_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kintu sheher te thaka manu khan bhag hoi jaise; kunba Yehudi phale jaise, aru kunba apostle khan phale jaise. ");
INSERT INTO nag_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Aru jitia biswas nakora khan aru Yehudi aru taikhan laga cholawta khan mili kene duijon ke hinsa kori kene pathor mari bole bisarise, ");
INSERT INTO nag_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","tai duijon etu jani loise aru ta te pora Lycaonia, Lystra aru Derbe aru etu usorte thaka sheher te polai jaise, ");
INSERT INTO nag_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","aru taikhan Isor laga kotha prochar kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Aru Lystra town te ekjon lengra manu bohise, tai laga theng te khara hobole olop bhi takot thaka nai, tai ama laga pet pora he lengra jonom hoise, tai kitia bhi bera nai. ");
INSERT INTO nag_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Etu manu Paul kotha kowa hunise, titia Paul etu manu ke bhal hoi jabole mon kori thaka laga biswas dikhi kene taike bhal pora sai thakise. ");
INSERT INTO nag_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Aru titia tai untcha awaj pora koise, “Uthi kene tumi laga theng te khara hobi.” Titia etu manu uthi kene bera bole shuru hoise. ");
INSERT INTO nag_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jitia manu khan Paul ki korise etu dikhise, taikhan laga awaj uthaise aru Lycaonia laga bhasa te koise, “Isor khan manu laga gaw loi kene amikhan majote ahise.” ");
INSERT INTO nag_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Aru taikhan Barnabas ke “Zeus,” matise, aru Paul ke “Hermes,” kelemane tai he kotha bisi koi thakise. ");
INSERT INTO nag_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Titia Zeus mondoli laga purohit jun to sheher usorte thakise, bail guru aru phul laga mala loi kene dorja usorte ahise; tai aru ta te laga manu khan boli dibole mon jaise. ");
INSERT INTO nag_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kintu jitia apostle Barnabas aru Paul etu hunise, taikhan laga kapra phatai kene manu khan laga majote jai kene jor pora kandise. ");
INSERT INTO nag_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Aru koise, “Manu khan, tumikhan kele eneka kori ase? Amikhan bhi apuni khan nisena bhabona thaka manu he ase. Amikhan apuni khan ke Isor laga kotha prochar kori bole ahise, etu kotha huni kene Isor pora itcha nakora kaam khan chari bole, sorgo, prithibi aru samundar te jiman jinis ase sob Tai pora he bonaise. ");
INSERT INTO nag_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Poila homoi te, manu khan ke nijor khushi pora berabo disele. ");
INSERT INTO nag_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kintu, Tai manu khan ke chari diya nai, Tai sorgo pora pani dise aru phul ulaikene khabole nimite bhal mohina dise aru sob bhal kaam kori dise.” ");
INSERT INTO nag_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Etu kotha koi kene, Paul aru Barnabas taikhan ke boli dibole rukhaise. ");
INSERT INTO nag_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Titia Antioch aru Iconium pora kunba Yehudi khan ta te ahise aru manu khan laga monte biya kotha hali dise. Aru titia Paul ke pathor mari kene sheher laga bahar te tani ulai dise, taikhan bhabise Paul mori jaise. ");
INSERT INTO nag_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kintu chela khan tai usorte khara kori thakise, titia tai uthi kene sheher te jaise. Aru dusra dinte, Barnabas logote Derbe te jaise. ");
INSERT INTO nag_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Aru jitia tai duijon Isor laga kotha koi kene bisi chela bonaise, taikhan Lystra te jaise, aru Iconium aru ta te pora Antioch te jaise. ");
INSERT INTO nag_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Aru taikhan chela khan ke biswas te hodai mon dangor hoi kene thaki bole sikhaise, aru koise, “Amikhan Isor laga rajyote jabole bisi dukh kori bole lagibo.” ");
INSERT INTO nag_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Aru sob girja te taikhan ke cholai loijabo nimite dangor manu basi dise, aru upwas rakhikena prathana korise, aru taikhan ke Isor hathte dise, junke taikhan biswas korise. ");
INSERT INTO nag_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Aru etu pichete duijon Pisidia jaga paar kori kene Pamphylia te ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jitia taikhan Perga te Isor kotha koi dise, ta te pora taikhan Attalia sheher te jaise. ");
INSERT INTO nag_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ta te pora duijon naw te uthi kene Antioch te jaise, ta te taikhan Isor laga anugrah kaam kori bole pathai sele, aru duijon etu kaam pura kori dise. ");
INSERT INTO nag_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jitia taikhan Antioch te ahise aru girja manu khan ke joma korise, Isor pora ki korise, aru kineka Porjati khan nimite biswas laga dorja to khuli dise etu sob taikhan ke koi dise. ");
INSERT INTO nag_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Aru duijon to chela khan logote bisi din tak ta te thakise. ");
INSERT INTO nag_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Olop din pichete, kunba manu Judea jaga pora ahi kene Antioch te thaka bhai khan ke sikhai kene koise, “Jitia tak tumikhan Moses laga niyom te diya nisena sunnot nakore, tumikhan nabachibo.” ");
INSERT INTO nag_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Etu kotha kowa nimite Paul aru Barnabas logote manu khan mon mila nai aru taikhan uporte khong uthise. Paul aru Barnabas aru ta te kunba khan ke Jerusalem te jabole basi loise aru jai kene apostle aru bura manu khan ke taikhan ki koise etu hudibole nimite pathaise. ");
INSERT INTO nag_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Titia taikhan ke girja pora pathaise, aru Phoenicia aru Samaria laga jaga khan pora juwa homoi te Porjati khan mon ghura laga kotha koidi thakise. Sob bhai khan etu khobor paikena bisi khushi korise. ");
INSERT INTO nag_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jitia taikhan Jerusalem te ponchise, taikhan ke girja laga apostle aru bura khan pora ahibole dise, aru Isor pora taikhan majot ki kori dise etu sob manu khan ke koi dise. ");
INSERT INTO nag_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kintu kunba biswas kora manu, kunkhan Pharisee khan logote mili kene thakise, khara kori kene koise, “Taikhan karone to sunnot kori bole dorkar ase aru Moses laga niyom mani kene thaki bole nimite sikhai dibole lage.” ");
INSERT INTO nag_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Titia apostle aru bura manu khan eke logote joma hoi kene etu kotha patise. ");
INSERT INTO nag_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Jitia etu kotha bisi dangor hoi jaise, Peter khara kori kene taikhan ke koise, “Bhai khan, Isor poila te apuni khan majote te moike basi loise, moi laga mukh pora Porjati khan Isor laga kotha hunibo aru biswas koribo nimite. ");
INSERT INTO nag_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Isor, Tai manu laga mon jane, aru sob gawahi diye, Pobitro Atma pora bhorta kori diye, jineka Tai moi khan uporte bhi korise; ");
INSERT INTO nag_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","aru Isor dwara Porjati khan aru amikhan majote eku alag bhabona nai, aru taikhan laga mon biswas pora sapha kori dise. ");
INSERT INTO nag_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Etu nimite tumikhan kele Isor ke bisar kori ase, chela khan laga gola uporte amikhan aru amikhan laga baba khan pora kitia bhi uthabole napara bhar to kele hali bole bisari ase? ");
INSERT INTO nag_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kintu amikhan biswas kore Probhu Jisu laga anugrah aru morom pora poritran pabo, kineka taikhan paise amikhan bhi pabo.” ");
INSERT INTO nag_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Aru ta te thaka sob manu khan chup hoi jaise jitia Paul aru Barnabas pora Porjati khan majote Isor pora ki asurit kaam kori dise etu taikhan ke koise. ");
INSERT INTO nag_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Aru jitia taikhan kotha kori kene khotom hoise, James pora koise, “Bhai khan, moi laga kotha huni bhi. ");
INSERT INTO nag_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon pora poila koise kineka Isor pora Porjati khan ke modot kori dise aru taikhan majot pora Tai laga naam ulabole nimite. ");
INSERT INTO nag_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Aru bhabobadi khan etu kotha to manise, jineka etu Shastro te likha ase, ");
INSERT INTO nag_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Etu pichete moi aru bhi ahibo, Aru moi David laga bhangi juwa tombu uporte ghor bonabo; Aru biya hoija khan sob wapas bhal kori kene khara kori dibo, ");
INSERT INTO nag_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kelemane manu khan Isor ke bisaribo, Aru sob Porjati khan moi laga naam matibo. Etu Probhu pora koi ase, jun he etu sob kaam to kori dise. ");
INSERT INTO nag_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Etu sob kaam shuru pora manu khan ke jonai dise. ");
INSERT INTO nag_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Etu karone, moi laga bhabona eneka ase, amikhan Porjati khan Isor phale aha to digdar nokorile lage. ");
INSERT INTO nag_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kintu taikhan ke likhi kene taikhan murti puja kora aru mangso laga itcha kaam kora, aru janwar laga gola kati kene khun kha etu sob nakoribole koi dibo. ");
INSERT INTO nag_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Moses laga kotha sob sheher te ase, poila khandan pora loi kene, aru jun manu tai laga naam loi kene mondoli khan te prochar kore, aru tai laga naam hodai Bisram dinte loi thake.” ");
INSERT INTO nag_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Titia sob apostle khan, bura khan aru girja manu khan etu kotha khan bhal paise, aru basi luwa khan ke Paul aru Barnabas logote Antioch te pathai dibole taikhan sai loise. Titia Judas, kunke Barsabbas bhi mate, aru Silas taikhan biswasi bhai khan majote cholawta thakise, taike pathaise. ");
INSERT INTO nag_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Aru taikhan hath pora chithi likhi dise: “Apostle aru bura khan pora, amikhan jun apuni khan laga bhai khan ase, jun khan Antioch, Syria, aru Cilicia te ase, aru Porjati khan ke salam di ase! ");
INSERT INTO nag_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Amikhan hunise, kunba manu amikhan majot pora ulai jaise, aru amikhan ke eku huda nai, aru apuni khan ke ulta kotha sikhai kene Atma te dukh pabole dise. ");
INSERT INTO nag_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Etu nimite, amikhan eke logote lok kori kene apnikhan ke pathabole bhal manu basi bo, jun khan logote amikhan bisi morom kora Barnabas aru Paul duijon bhi pathabole ase. ");
INSERT INTO nag_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Etu manu khan nijor laga jibon dikene Probhu Jisu Khrista laga naam nimite dukh uthai thake. ");
INSERT INTO nag_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Etu karone Judas aru Silas ke pathai ase, taikhan bhi etu kotha khan nijor mukh pora apnikhan ke koi dibo. ");
INSERT INTO nag_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kelemane Pobitro Atma pora amikhan nimite etu he bhal ase bhabise, apuni khan uporte eku kaam nathaka laga bhar pora dukh nadibo nimite: ");
INSERT INTO nag_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","murti puja ke boli diya pora apuni khan dur thakibo, aru khun para, aru gola kati kene morai diya pora, aru biya paap pora. Jodi apuni khan pora eitu khan sob pora dur thakise koile, apuni khan nijor nimite bhal ase. Bhal pora thakibi.” ");
INSERT INTO nag_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jitia taikhan ke jabole dise, taikhan Antioch te ahi punchise; aru sob manu khan ke joma kora pichete, chithi taikhan ke dise. ");
INSERT INTO nag_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Aru jitia girja pora etu porhise, taikhan bisi mon dangor kori diya kotha dikhi kene taikhan bisi khushi korise. ");
INSERT INTO nag_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas aru Silas, duijon bhi bhabobadi thakise, aru ta te thaka bhai khan ke nijor kotha pora manu khan laga biswas aru mon dangor kori dise. ");
INSERT INTO nag_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Aru olop din ta te thaki kene, taikhan ke kun bhai khan pora pathaise, taikhan logot wapas shanti pora pathai dise. ");
INSERT INTO nag_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kintu Silas, ta te aru thaki bole mon thakise. ");
INSERT INTO nag_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Aru Paul aru Barnabas to Antioch te thaki jaise, Isor laga kotha manu khan ke sikhai thakise- dusra khan bhi duijon logote thakise. ");
INSERT INTO nag_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Olop din pichete, Paul pora Barnabas ke koise, “Ahibi amikhan poila jun sheher te jai kene Isor kotha prochar korise ta te laga bhai khan ke jai kene lok koribo, aru taikhan kineka ase etu sabo.” ");
INSERT INTO nag_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas taikhan logote John kunke Mark bhi mate taike loi jabole mon thakise. ");
INSERT INTO nag_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kintu Mark ke loi juwa to thik nohoi eneka Paul pora bhabise, ta te pora John to Pamphylia te jaise aru taikhan ki kaam nimite jaise etu kaam te tai aru age naja hoise. ");
INSERT INTO nag_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Etu nimite tai duijon majot kotha mila nai, aru ta te pora tai duijon alag hoi jaise, aru Barnabas pora Mark ke loi kene naw pora Cyprus te jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Kintu Paul pora Silas ke basi loise aru ta te bhai khan pora duijon ke Isor laga anugraha te rakhi kene sob kaam di dise. ");
INSERT INTO nag_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Aru tai Syria aru Cilicia te jaise, aru girja khan te jaikena biswasi khan laga mon dangor kori dise. ");
INSERT INTO nag_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Etu pichete tai Derbe aru Lystra sheher te jaise; aru sabi, ta te ekjon chela Timothy koi kene thakise, tai ekjon biswasi aru Yehudi mahila laga chokra asele; kintu tai laga baba to Yunani manu thakise. ");
INSERT INTO nag_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lystra aru Iconium te thaka biswasi bhai khan tai laga bhal kotha he koise. ");
INSERT INTO nag_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul pora Timothy ke loi jabole mon thakise; aru taike sunnot kori dise kelemane etu jagate Yehudi khan thakise, aru ta te laga manu khan sob jani thakise tai laga baba Yunani manu ase koi kene. ");
INSERT INTO nag_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aru Paul, Silas aru Timothy khan sheher te ja-a homoi te, taikhan girja khan te manu khan ke Isor kotha mani bole sikhaise, juntu kotha Jerusalem te thaka apostle aru girja laga bura khan pora taikhan ke kobole faisla kori dise. ");
INSERT INTO nag_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Etu pora girja khan biswas te takot hoi thakise, aru hodai din manu bhi bisi-bisi hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paul aru tai laga sathi khan Phrygia aru Galatia laga jaga phale pora jaise, kelemane Pobitro Atma pora taikhan ke Asia te prochar kori bole mana korise. ");
INSERT INTO nag_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Jitia taikhan Mysia sheher usorte ahise, taikhan Bithynia te jabole kosis korise, kintu Jisu laga Atma pora ta te jabole mana korise. ");
INSERT INTO nag_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Etu karone taikhan Mysia paar kori kene Troas sheher te jaise. ");
INSERT INTO nag_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Etu rati te Paul ekta darshan dikhise: ekjon manu Macedonia jagate khara kori thakise, aru taike mati kene koise, “Ahi kene amikhan ke Macedonia te modot koribi.” ");
INSERT INTO nag_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Jitia Paul etu darshan dikhise, etu homoi te amikhan joldi Mecedonia te jaise, kelemane taikhan ke susamachar koi dibole Isor amikhan ke matise. ");
INSERT INTO nag_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Aru amikhan Troas pora naw te uthi kene sidha Somothrace laga majuli te jaise, aru dusra din Neapolis sheher te ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Aru ta te pora Mecedonia laga sob pora dangor sheher Philippi te punchise, Rome manu khan laga jaga, aru amikhan ta te olop din thakise. ");
INSERT INTO nag_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Aru Bisram dinte amikhan sheher bahar te ulaikene nodi kinar phale, prathana kori bole jagah ase bhabi kene ta te jaise. Titia amikhan bohise aru ta te mahila khan joma hoi kene thaka khan logote kotha korise. ");
INSERT INTO nag_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ta te ekjon mahila Lydia koi kene asele, Thyatira te tai begoni rong kapra bikiri kori thake, tai Isor ke mohima kore, aru tai amikhan laga kotha hunise. Probhu he etu mahila laga mon khuli kene Paul laga kotha bhal pora huni bole dise. ");
INSERT INTO nag_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Aru jitia tai aru tai laga ghor manu sob baptizma loise, tai amikhan ke hudi kene koise, “Jodi apuni khan moi Isor usorte biswasi ase koi kene bisar kore, ahi kene moi laga ghor te thaki bhi.” Aru amikhan tai laga ghor te rukhibole jaise. ");
INSERT INTO nag_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Etu homoi te, amikhan prathana kori bole ekta jagate jai thakise, titia amikhan ekjon jawan jyotishee kora mahila ke lok paise. Tai etu kaam kori kene tai laga malik khan ke bisi poisa kamaikena di thakise. ");
INSERT INTO nag_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Etu mahila Paul aru amikhan laga pichete ahi kene hala korise, aru koise, “Etu manu khan sobse Mohan Isor laga noukar khan ase. Taikhan pora apnikhan logot prochar kora to poritran pabole rasta ase.” ");
INSERT INTO nag_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tai bisi din eneka koi thakise, kintu tai eneka kowa to Paul ke bhal panai, aru tai ghurai kene dusto atma ke koise, “Moi Jisu Khrista naam pora tumike hukum di ase tai pora ulai jabi,” aru etu homoi te atma ulai jaise. ");
INSERT INTO nag_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kintu jitia tai laga malik khan poisa aha rasta to bondh hoija dikhise, taikhan Paul aru Silas ke dhori kene bajar laga adhikari khan usorte loi anise. ");
INSERT INTO nag_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Aru jitia taikhan ke bisar kora manu khan usorte anise, taikhan koise, “Etu manu khan amikhan laga sheher ke biya kori ase. Taikhan Yehudi manu ase. ");
INSERT INTO nag_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Moi khan ki niyom manibo napare etu sikhai ase aru Rome laga niyom lobole koi ase.” ");
INSERT INTO nag_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Titia manu khan Paul aru Silas uporte khong korise, aru bisar kora manu khan pora tai duijon laga kapra phatai kene pitabole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Aru tai duijon ke bisi marise, aru bondhi ghor te bondh kori dise aru bondhi ghor laga adhikari ke bhal pora duijon ke rukhibole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Jitia tai etu hukum paise, bondhi ghor laga adhikari pora tai duijon laga theng bandhi kene bondh kora bhitor kamra te rakhidise. ");
INSERT INTO nag_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Aru adha rati te Paul aru Silas prathana kori kene Isor laga gana gayi thakise, aru bondhi ghor te thaka dusra koidi khan taikhan ke huni thakise. ");
INSERT INTO nag_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Achanak pora dangor mati hili se, aru bondhi ghor laga khamba khan hili jaise; aru etu homoi te dorja khan khuli jaise, aru manu khan ke bandhi rakha loha rusi sob khuli jaise. ");
INSERT INTO nag_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Titia adhikari ghumai thaka pora uthijaise aru dorja khan sob khula dikhise; aru tai laga talwar ulaikene nijorke morai dibole korise, kelemane tai bhabise bondhi ghor te thaka manu khan sob polai jaise. ");
INSERT INTO nag_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kintu Paul jor pora hala kori kene koise, “Nijorke jokhom nadibi, kelemane amikhan sob yate ase.” ");
INSERT INTO nag_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Titia bondhi ghor laga adhikari pora saaki mangi kene bhitor te polai ahise, aru bhoi pora kapi kene, Paul aru Silas laga theng te giri jaise, ");
INSERT INTO nag_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","aru tai duijon ke bahar te loi ani kene koise, “Sahab khan, poritran pabole moi ki koribo lage?” ");
INSERT INTO nag_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Titia duijon Taike jawab dise, “Probhu Jisu ke biswas koribi, titia tumi aru tumi laga ghor manu sob bachi jabo.” ");
INSERT INTO nag_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Titia duijon taike aru tai laga ghor manu sobke Probhu laga kotha hunai dise. ");
INSERT INTO nag_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Titia bondhi ghor laga sipahi pora etu rati te duijon ke loi jaise, aru taikhan laga jokhom sapha kori dise, tai laga sob ghor manu aru tai etu homoi te baptizma loise. ");
INSERT INTO nag_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Aru duijon ke tai laga ghor te loi anise aru kha luwa dise, aru tai Isor ke biswas korise koi kene tai laga sob ghor manu bisi khushi korise. ");
INSERT INTO nag_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Aru jitia din hoise, titia sahab khan pora sipahi khan ke pathaise aru koise, “Taikhan ke jabole dibi.” ");
INSERT INTO nag_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Titia sahab pora jai kene etu kotha Paul ke koise, “Bisar kora manu pora moike apuni khan ke chari dibole koise. Etu nimite bahar te ulabi, aru shanti pora jabi.” ");
INSERT INTO nag_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kintu Paul taikhan ke koise, “Amikhan Rome laga manu ase, hoilebi bisar laga niyom nacholai kene ami duijon ke marise, aru bondhi ghor te hali dise. Etiya to moi khan ke lukai kene pathai dibole mon ase? Eneka nohoi! Kintu, taikhan nijor ahi kene amikhan ke bahar te loi jabole dibi.” ");
INSERT INTO nag_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Titia sipahi khan bisar kora manu khan ke jai kene etu kotha koise, aru jitia Paul aru Silas Roman manu ase koi kene janise, taikhan bhoi lagi jaise. ");
INSERT INTO nag_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Titia bisar kora manu khan ahi kene taikhan ke maph mangise, aru duijon ke bahar te ulaikene anise, aru sheher pora jai jabole koise. ");
INSERT INTO nag_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Titia duijon bondhi ghor pora ulaikene Lydia laga ghor te jaise. Aru jitia Paul aru Silas duijon bhai khan ke dikhise, taikhan laga mon dangor koridi kene sheher pora jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ek din paul aru silas duijon Amphipolis aru Apollonia laga sheher paar kori kene jaise, aru Thessalonica laga sheher te ahi ponchise, ta te Yehudi khan laga ekta mondoli thakise. ");
INSERT INTO nag_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Aru Paul laga adat ekta thaka nisina, tai taikhan logote jaise, aru tin Bisram din tak taikhan logote Isor laga kotha koi thakise. ");
INSERT INTO nag_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Aru tai Shastro khuli kene taikhan ke bujhai thakise ki Khrista dukh pabo aru mora pora jinda hoi jabo, aru etu eneka hobole dorkar thakise. Aru tai koise, “Etu Jisu kun laga kotha koi kene moi prochar kori ase Tai he Khrista ase.” ");
INSERT INTO nag_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ta te kunba Yehudi khan Paul aru Silas laga kotha huni kene tai duijon logote milai loise, aru taikhan logote kunba Yunani khan aru kunba maiki khan bhi mili jaise. ");
INSERT INTO nag_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kintu biswas nakora Yehudi khan mon julise, aru bajar pora biya manu ke joma kori loise, aru bisi manu lagai kene sheher te hala korise. Aru jitia Jason laga ghor bhangai dise, aru Paul aru Silas ke manu khan dhori kene loi anibole bisarise. ");
INSERT INTO nag_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kintu jitia taikhan duijon ke panai, taikhan Jason aru kunba biswasi bhai khan ke dhori kene sheher laga adhikari khan usorte loi jaise, aru hala kori kene koise, “Etu manu khan jun duniya ke ulta koridi ase, taikhan bhi yate ahikena ase. ");
INSERT INTO nag_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason pora tai laga ghor te manu kunkhan rakhise kunkhan Caesar laga kotha mana nai, aru taikhan koi ase Jisu koi kene dusra raja ase.” ");
INSERT INTO nag_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Aru etu kotha huni kene bisi manu khan aru sheher laga adhikari khan sob chinta hoise. ");
INSERT INTO nag_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kintu taikhan Jason aru tai laga saathi khan pora poisa loise, aru dusra biswasi khan ke jabole dise. ");
INSERT INTO nag_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Titia biswasi bhai khan etu rati te Paul aru Silas ke Berea sheher te pathai dise. Aru jitia duijon ta te ponchise, tai duijon Yehudi khan laga mondoli te jaise. ");
INSERT INTO nag_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Aru Thessalonica te thaka manu khan to dusra jaga laga manu khan pora bhi bhal thakise, kelemane taikhan hodai din Isor laga kotha te ki likha ase etu saikene bhal mon pora grohon kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Etu nimite bisi manu Jisu ke biswas kori loise, aru ta te laga Yunani niyom mani thaka mahila khan aru kunba mota manu khan bhi biswas korise. ");
INSERT INTO nag_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kintu jitia Thessalonica laga Yehudi khan Paul pora Berea te Isor laga kotha koi ase koi kene janise, taikhan jai kene manu khan laga monte biya kotha hali dise aru mon biya kori bole dise. ");
INSERT INTO nag_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Etu homoi te, biswasi bhai khan joldi Paul ke samundar phale pora jabole dise, kintu Silas aru Timothy to Berea te thaki jaise. ");
INSERT INTO nag_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aru jun manu Paul ke loi jaise taikhan Athens sheher pora aru dur te taike loi jaise. Aru jitia taikhan Silas aru Timothy duijon ke Paul pora tai usorte te joldi ahibole dibi koi kene khobor paise, taikhan nijor laga ghor te jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Jitia Paul Athens te Silas aru Timothy ke rukhi thakise, tai etu sheher te murti bhorta thaka dikhi kene tai laga atma pora bisi mon dukh hoise. ");
INSERT INTO nag_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Titia tai mondoli te jai kene Yehudi aru hosa Isor ke aradhana kora manu khan logote kotha korise, aru hodai tai jitia bajar te jai ta te bhi manu lok paile etu laga kotha kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Titia Epicurean aru Stoic khan laga pondit kunba ahi kene tai logot kotha lagi thakise, aru kunba koise, etu ke najana manu ki kobole mon kori ase? Dusra koise tai dusra jaga laga dhorom manu ase, kelemane tai Jisu laga kotha aru jee utha laga kotha prochar kori ase. ");
INSERT INTO nag_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Taikhan Paul ke Aropagus laga usorte loi jaise aru koise, “Tumi ki koi ase aru sikhai ase etu amikhan bhi janibole paribo? ");
INSERT INTO nag_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kelemane amikhan laga kan pora kitia bhi nahuna kotha huni bole pai ase. Etu nimite, amikhan bhi janibole mon ase etu kotha laga ki motlob ase.” ");
INSERT INTO nag_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","-Etiya sob Athens laga manu aru dusra desh pora ahi kene thaka manu khan dusra eku kaam nakori kene kiba notun kotha hunile etu laga kotha koi kene bohi thake. ");
INSERT INTO nag_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Titia Paul Areopagus majote khara hoi kene koise, “Tumi Athens laga manu khan, moi dikhi ase tumikhan sob kaam te bhal ase. ");
INSERT INTO nag_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Jitia moi tumikhan laga puja kori thaka saman khan saikene paar kori thakise, tumikhan pathor pora bona bedi te eneka likhi kene rakha dikhise, “Ekjon najana Isor nimite.” Etu karone junke apnikhan najani kene puja kori thaki ase, etu laga kotha tumikhan ke moi kobo. ");
INSERT INTO nag_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Isor jun he prithibi aru ta te thaka sob bonai dise, Tai sorgo aru prithibi laga Isor ase, manu pora bonai diya laga mondoli te nathake. ");
INSERT INTO nag_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Aru Tai manu laga hath laga sewa nalage, aru manu pora eku nibisare, kelemane Tai he sobke jibon aru saas diye aru manu ki lage Tai etu sob diye. ");
INSERT INTO nag_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Aru Tai ekjon manu pora he ekta desh aru jiman manu etiya thaki ase etu sobke bonai dise, ki homoi te kineka dibole lage aru kun manu laga jat kote thaki bole lage etu sob Tai pora bonai kene rakhidise, ");
INSERT INTO nag_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Eneka korile manu khan Taike bisaribo aru taikhan Isor phale mon dibo aru Tai usorte ahibo. Kintu Tai amikhan pora kitia bhi dur thaka nai. ");
INSERT INTO nag_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kelemane amikhan Tai logote jinda ase aru amikhan laga ki ase etu sob to Tai laga he ase, jineka apuni khan laga majote kitab likha ekjon pora koise, ‘Amikhan sob Tai laga bacha khan he ase.’ ");
INSERT INTO nag_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Etu karone, amikhan Isor laga bacha ase, amikhan eneka bhabona kori bole nalage ki tai laga sobhab to suna, chandi, aru pathor nisena ase- eitu khan jinis to manu laga bhabona pora bonai. ");
INSERT INTO nag_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Etu nimite Isor poila te manu laga paap dhyan nakori kene chari dise, kintu etiya Tai sob manu ke paap pora mon ghura bole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kelemane, ek dinte rakhi kene ase, juntu dinte, Tai pora basi luwa ekjon pora etu duniya ke dhormikta pora bisar koribo. Isor he Jisu ke mora pora jinda kori kene Tai hosa Isor ase koi kene dikhai dise.” ");
INSERT INTO nag_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Aru jitia Athens laga manu khan mori kene jinda huwa kotha hunise, kunba ta te thaka khan Paul ke hinsa korise; kintu kunba koise, “Amikhan etu kotha apuni pora aru hunibo.” ");
INSERT INTO nag_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Etu pichete Paul taikhan laga majot pora ulai jaise. ");
INSERT INTO nag_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kintu kunba tai logote mili jaise aru tai ki kotha koise etu biswas korise, etu majote Dionysius jun Areopagus laga ekjon manu, aru Damaris koi kene ekjon mahila, aru dusra manu khan bhi taikhan logote thakise. ");
INSERT INTO nag_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Etu pichete Paul Athens pora Corinth sheher te jaise. ");
INSERT INTO nag_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ta te tai ekjon Yehudi manu Aquila koi kene lok paise, tai Pontus laga manu thakise, aru tai olop din age te Italy pora tai laga maiki Priscilla ke loi kene ahise, kelemane Claudius pora Yehudi manu khan ke Rome pora jai jabole hukum dise. Paul taikhan usorte jaise, ");
INSERT INTO nag_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","aru kelemane taikhan ki kaam kore etu Paul bhi kora nimite, taikhan logote thaki kene kaam korise, kele koile taikhan sob tambu bona manu asele. ");
INSERT INTO nag_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Aru Paul to mondoli te jai kene hodai Bisram dinte taikhan logote kotha kori thakise. Tai Yehudi aru Yunani manu khan ke Isor laga kotha mani kene thaki bole nimite koi thakise. ");
INSERT INTO nag_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Jitia Silas aru Timothy duijon Macedonia pora ahise, Paul Isor laga kotha te pura mon dikene thakise, aru Yehudi manu khan ke Jisu Khrista laga gawahi koi thakise. ");
INSERT INTO nag_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kintu Yehudi manu khan tai laga kotha mana nai aru taike sorom khilai dise, Paul tai laga kapra jharikena taikhan ke koise, “Tumikhan laga khun tumikhan nijor matha uporte ahibole dibi; moi eku golti kora nai. Etiya pora moi Isor najana manu usorte he jabo.” ");
INSERT INTO nag_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Aru tai ta te pora ulaikene ekjon manu Titus Justus laga ghor te jaise, tai Isor ke mohima kora ekjon thakise. Tai laga ghor mondoli laga usorte thakise. ");
INSERT INTO nag_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, mondoli laga ekjon cholawta, Probhu ke biswas kori loise, aru tai laga ghor manu sob bhi biswas korise; aru Corinth te kiman manu Isor laga kotha hunise taikhan bhi biswas kori kene baptizma loise. ");
INSERT INTO nag_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Aru ek rati, Probhu he Paul ke sapna te koise, “Bhoi na koribi, kintu moi laga kotha koi thakibi aru kitia bhi chup nathakibi. ");
INSERT INTO nag_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kelemane moi tumi logote ase, aru kun bhi tumike ahi kene eku kori bole na paribo, aru tumike nuksan nakoribo, kelemane etu sheher te moi laga manu bisi ase.” ");
INSERT INTO nag_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Aru Paul ta te ek saal aru choi mohina thakise, Isor laga kotha manu khan ke sikhai thakise. ");
INSERT INTO nag_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kintu jitia Gallio pora Achaia laga Governor hoise, sob Yehudi manu khan mili kene Paul laga bhirodh te khara hoise aru taike dhori kene bisar kora jagate loi anise; ");
INSERT INTO nag_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","taikhan koise, “Etu manu amikhan laga niyom bhirodh te jai kene Isor laga kotha sikhai ase aru mani bole koi ase.” ");
INSERT INTO nag_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Aru jitia Paul pora kotha kobole mukh khuli se, Gallio pora Yehudi khan ke koise, “Tumi Yehudi khan, jodi etu kotha golti aru paap kaam kora laga ase koile, moi tumikhan nimite bisar koribo. ");
INSERT INTO nag_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kintu tai koi thaka kotha kunba laga naam nimite aru tumikhan laga niyom laga ase koile, tumikhan nijor hai sai lobi. Moi etu kotha khan nimite bisar kori bole mon nai.” ");
INSERT INTO nag_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Titia Gallio bisar laga jaga pora taikhan ke jabole dise. ");
INSERT INTO nag_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Aru taikhan sob Sosthenes usorte jaise, mondoli laga ekjon cholawta, aru taike bisar kora jagate jai kene marise. Kintu Gallio to eitu khan nimite eku chinta kora nai. ");
INSERT INTO nag_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Aru Paul, bisi din ta te thaka pichete, ta te laga bhai khan ke chari kene Syria te jaise, Priscilla aru Aquila bhi tai logote thakise. Tai Cenchrea te tai nijor laga chuli kati dise kelemane tai kosom khaise. ");
INSERT INTO nag_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Aru jitia taikhan Ephesus te ahise, Paul pora Priscilla aru Aquila ke ta te chari dise, kintu tai nijor jai kene Yehudi khan logote kotha kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jitia taikhan Paul ke ta te aru olop din thaki bole koise, tai mana nai. ");
INSERT INTO nag_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kintu tai anurodh kori kene taikhan ke koise, “Isor itcha hoile moi aru bhi ahibo.” Ta te pora tai naw te uthi kene Ephesus te jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Aru jitia Paul Caesarea te namise, tai jai kene Jerusalem girja te manu khan ke salam dise aru ta te pora tai Antioch te jaise. ");
INSERT INTO nag_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Aru olop din ta te thaka pichete, Paul ta te pora ulai jai kene Galatia aru Phrygia laga desh te kiman biswasi manu khan ase taikhan laga mon dangor kori dise. ");
INSERT INTO nag_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ta te Apollos koi kene ekjon manu thakise, tai jonom pora Alexandria laga manu thakise, kintu tai Ephesus te ahise. Tai to Isor laga kotha bhal pora jana aru kobo para ekjon gyaani manu thakise. ");
INSERT INTO nag_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apollos ke Probhu laga rasta te thik pora mani kene thaki bole koi dise. Atma te bhal kori kene thaki bole nimite, aru mon dikene Jisu laga kotha manu khan ke sikhai thake, kintu tai John pora diya baptizma he jane. ");
INSERT INTO nag_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Etu nimite Apollos mondoli te jai kene mon dangor pora kotha koi thakise. Kintu jitia Priscilla aru Aquila tai laga kotha hunise, taike kinar te loijai kene Isor laga kotha aru bhi bhal pora bujhai dise. ");
INSERT INTO nag_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Jitia tai Achaia jaga ke paar kori kene jabole itcha korise, titia biswasi bhai khan pora tai laga mon dangor kori dise aru taike bhal pora grohon koribi koi kene Achaia te thaka chela khan ke ekta chithi likhi dise. Jitia tai ta te punchise, tai Isor laga anugrah pora biswasi khan ke bisi modot dise. ");
INSERT INTO nag_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Aru Apollos pora manu khan usorte mon dangor kori kene Yehudi khan ke kotha pora jitise aru Shastro te likhi kene thaka pora Jisu he Khrista ase koi kene dikhai dise. ");
INSERT INTO nag_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aru jitia Apollos Corinth te thakise, Paul to upor phale thaka desh paar kori kene Ephesus laga sheher te punchise, aru ta te kunba chela khan ke lok paise. ");
INSERT INTO nag_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Aru Paul taikhan ke koise, “Tumikhan biswas kora homoi te Pobitro Atma paise?” Kintu taikhan taike koise, “Nai, amikhan Pobitro Atma ase koi kene huna bhi nai.” ");
INSERT INTO nag_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Titia Paul koise, “Tenehoile tumikhan ki pora baptizma loise?” Taikhan koise, “John laga baptizma pora.” ");
INSERT INTO nag_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Titia Paul koise, “John pora mon ghura laga baptizma pora tumikhan ke baptizma dise. Tai manu khan ke koise tumikhan John laga pichete ekjon ahi ase Taike biswas koribi, Tai Jisu ase.” ");
INSERT INTO nag_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Jitia manu khan etu kotha hunise, taikhan sob Probhu Jisu laga naam te baptizma loise. ");
INSERT INTO nag_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Aru jitia Paul taikhan laga uporte hath rakhidise, Pobitro Atma taikhan laga uporte ahi jaise titia taikhan alag kotha pora bhabobani kobole shuru hoise. ");
INSERT INTO nag_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ta te taikhan sob milai kene baroh jon manu thakise. ");
INSERT INTO nag_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Aru Paul mondoli te jai kene tin mohina tak Isor laga kotha mon dangor kori kene koise, manu khan ke Isor laga rajyo kotha bhujai kene biswas kori bole koi dise. ");
INSERT INTO nag_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kintu kunba Yehudi khan mon tan kori kene kotha mana nai, taikhan manu khan usorte biya kotha kobole shuru hoise. Titia Paul taikhan ke chari kene chela khan ke loi jaise, aru hodai din Tyrannus hall te jai kene kotha koi thakise, ");
INSERT INTO nag_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Aru eneka dui saal tak hoi thakise, etu karone Asia te kiman manu thakise taikhan sob Probhu laga kotha hunise, Yehudi aru Yunani manu khan bhi. ");
INSERT INTO nag_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Isor pora Paul laga hath pora kitia bhi nadikha asurit kaam khan korise, ");
INSERT INTO nag_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","etu karone manu khan rumal nohoile kapra loi kene tai gaw ke chui dibo, aru bemar bhal hoi thake, aru biya atma khan bhi gaw chari kene bahar ulai jai thakise. ");
INSERT INTO nag_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Titia kunba Yehudi khan etu jaga phale beraikena jadu-tona, jhara-jhari kori thakise. Taikhan bhi jun manu logot dushto atma thakise utu khan ke Probhu Jisu laga naam lobole kosis kori kene eneka koise, “Moi tumike Paul pora prochar kori thaka Jisu laga naam pora bahar te ulai jabole hukum di ase.” ");
INSERT INTO nag_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Aru Yehudi laga maha purohit kaam kora Sceva laga sat jon chokra khan tineka kaam kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Aru dushto atma koise, “Moi Jisu ke jane aru Paul ke bhi jane, kintu tumi kun ase?” ");
INSERT INTO nag_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Titia jun logot te dusto atma thakise, utu manu taikhan uporte uthi kene taikhan ke marise aru harai dise, aru manu khan sob utu ghor pora lengta hoi kene, bisi jokhom paikena polai jaise. ");
INSERT INTO nag_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Aru utu kotha Ephesus te thaka Yehudi aru Yunani khan sob jani jaise, aru taikhan sob bhoi lagi jaise, aru Probhu Jisu naam ke prosansa kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Aru jun biswas kori loise utu khan pora bisi manu ahi kene nijor-nijor he taikhan ki biya kaam korise etu sob laga paap shikar korise. ");
INSERT INTO nag_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Aru jadu-tona kori thaka khan nijor-nijor jadu laga kitab khan joma kori sob manu pora dikhikena jolai dise, aru jitia utu daam hisab kori saise, etu chandi poisa te pachas hajar toka nisena thakise. ");
INSERT INTO nag_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Karone Probhu laga kotha pora jiti kene biswasi khan bisi hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Aru jitia Paul Ephesus te tai laga sewkai kaam khotom korise, tai Atma te bhabi loise jitia tai Jerusalem te jabo, titia tai Macedonia aru Achaia te bhi jabo; aru koise, “Ami ta te juwa pichete, aru Rome te bhi jai kene sabo lagibo.” ");
INSERT INTO nag_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Etu karone tai sewa te thaka Timothy aru Erastus duijon ke Macedonia te pathai kene tai olop homoi karone Asia te thaki jaise. ");
INSERT INTO nag_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Aru etu homoi te, Ephesus te Isor laga Rasta laga kotha nimite dangor gondugol hoise. ");
INSERT INTO nag_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrius koi kene chandi laga kaam kora ekjon thakise aru tai chandi pora Artemis laga mondoli te murtikhan bisi bonaise, aru etu pora kaam kora khan bisi labh hoi thakise. ");
INSERT INTO nag_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Aru tai pora tai nisena kaam kori thaka khan sobke mati anikena koise, “Hey sahab khan, apnikhan bhi jani ase, amikhan etu kaam kora pora bisi poisa pai thake. ");
INSERT INTO nag_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Aru apnikhan bhi dikhi aru huni ase, khali Ephesus te he nohoi kintu pura Asia te eneka koi kene Paul pora bisi manu ke biswas kori loi ase, tai koi ase juntu hath pora bonaise utu Isor nohoi. ");
INSERT INTO nag_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Etu karone khali ami laga kaam ke he nohoi, kintu Asia te, aru pura duniya te puja kori thaka maha devi Artemis laga mondoli ke bhi bodnam koridi ase, aru devi laga naam bhi harai jabole bhoi hoise.” ");
INSERT INTO nag_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Jitia manu khan etu kotha hunise, taikhan bisi khong uthise, aru bisi jor pora hala kori koise, “Ephesus laga Artemis mohan ase.” ");
INSERT INTO nag_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Eneka hoi kene pura sheher te hala hoi jaise; titia taikhan mili kene ahise aru Gaius aru Aristarchus jun Paul logote safar kori thaka manu khan asele, tai duijon ke dhori kene moncho ghor te loi anise. ");
INSERT INTO nag_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Aru Paul to ta te jabole bisi mon korise, kintu chela khan pora taike jabo diya nai. ");
INSERT INTO nag_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Titia kunba Asia te thaka adhikari khan pora taikhan laga sathi khan ke khobor pathai kene Paul ke moncho ghor te najabi koise. ");
INSERT INTO nag_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Aru bhir te thaka kunba pora kiba kobo, aru dusra pora kiba kobo eneka hoi thakise, etu pora bhir te manu khan bisi matha ghurai thakise. Ta te bisi manu etu bhi jani kene thaka nai taikhan kele ta te joma thakise. ");
INSERT INTO nag_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Aru Yehudi khan pora Alexander ke age te loi rakhidise, aru Alexander tai laga hath uthaikene manu khan ke bujhai dibole korise. ");
INSERT INTO nag_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kintu jitia tai Yehudi manu ase koi kene jani loise, sob mili kene dui ghanta tak, “Ephesus laga Artemis mohan ase” eneka hala kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Aru titia sheher laga cholawta he sob manu ke chup kori kene koise, “Hey Ephesus manu khan, Ephesus laga sheher to maha devi laga mondoli rakhi thaka jaga ase koi kene, aru murti nisena sabole juntu akas pora ahise etu kun manu najane? ");
INSERT INTO nag_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Karone utu jinis khan to nohoi kobo napare, titia hoile chup-chap hoi jabole lage, aru eku kori bole dorkar nai. ");
INSERT INTO nag_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kelemane etu duijon mondoli te chor dokaiti kora nohoi aru tumi laga devi laga uporte eku biya kotha kowa nohoi, hoilebi tumikhan pora taikhan ke dhori anise. ");
INSERT INTO nag_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Karone Demetrius aru tai logote kaam kora khan he kunba logot kotha namila thakile, bisar kora jaga aru sabha to khula ase, taikhan ta te pora bisar koribo dibi. ");
INSERT INTO nag_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kintu jodi apnikhan etu te bhi aru kiba ase koile, thik homoi te sabha pora bisar kori lobo lage. ");
INSERT INTO nag_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kelemane aji gondugol kora nimite ami upor golti dibole bhoi ase, etu eku motlob nathaki kene gondugol kora etu laga jowab dibole na paribo.” ");
INSERT INTO nag_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Aru tai etu kotha koi kene sabha ke chari dise. ");
INSERT INTO nag_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Jitia gondugol to khotom hoise, Paul chela khan ke mati anise aru taikhan ke samjai dise, aru taikhan ke bhidai kori kene tai Macedonia te jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Titia tai utu desh khan paar kori kene khotom huwa pichete, tai Greece te ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Aru tai ta te tin mohina thakise aru ta te pora Syria te jabole thakise, kintu Yehudi khan taike morai dibole thaka jani kene, Macedonia phale pora he wapas jabole bhabi loise. ");
INSERT INTO nag_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Aru Berea manu Sopater laga chokra, aru Thessalonica pora Aristarchus aru Secundus aru Derbe pora Gaius aru Timothy aru Asia pora Tychicus aru Trophimus taikhan tai logote jaise. ");
INSERT INTO nag_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kintu eitu khan amikhan age te jai kene Troas te rukhi thakise. ");
INSERT INTO nag_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Aru khomir nahala roti laga utsov din pichete amikhan Philippi pora naw te uthi kene pans din pichete Troas te taikhan logot ponchise, aru saat din tak ta te thakise. ");
INSERT INTO nag_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Titia hapta laga prothom din jitia biswasi chela khan eke loge mili kene roti bhangai sele. Paul dusra dinte jabole thakise, etu karone tai taikhan logot adha rati tak kotha kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Upor kamra kot te amikhan joma thakisele ta te bisi saaki khan jolai rakhise. ");
INSERT INTO nag_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Aru Eutychus koi kene jawan ekjon khirki te bohi thakise, aru Paul bisi deri kotha koi thaka pora, tai ghumai kene tin tola upor pora nichete girikena morise. ");
INSERT INTO nag_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Kintu Paul niche jai kene tai usorte tai laga gaw ke lamba korise, aru taike dhurise. Aru tai koise, “Bhoi nokoribi, kelemane tai laga jibon etiya bhi tai logot he ase.” ");
INSERT INTO nag_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Titia tai aru upor jai kene roti bhangai khaise aru phojur tak kotha kori thakise, aru etu pichete jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Aru taikhan utu chokra jinda pa karone ekdom shanti paise. ");
INSERT INTO nag_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Titia amikhan naw pora Assos te jaise, aru ta te pora naw te Paul ke uthabole thakise, kelemane tai nije pora he tai berai kene jabo koise, aru tai he eneka kori bole amikhan ke koise. ");
INSERT INTO nag_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aru tai Assos te ahi amikhan ke lok paise, aru amikhan taike uthaikene Mitylene te ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Aru ta te pora naw te uthi kene dusra din Chios usorte ahi jaise, utu din amikhan Samos ponchise, aru Tragyllium te thaki kene dusra din Miletus te ahi Jaise. ");
INSERT INTO nag_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kelemane Paul Asia te homoi phelabo mon kora nai, tai naw pora Ephesus paar kori bole mon korise, kelemane parile Pentecost din tai Jerusalem te thakibo mon kori kene tara-tari kori thakisele. ");
INSERT INTO nag_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Tai Miletus pora khobor pathai kene Ephesus girja laga bura khan ke matise. ");
INSERT INTO nag_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Aru jitia taikhan tai logot ahise, tai koise, “Moi juntu din pora Asia te ahise, utu prothom din pora kineka moi tumi logote thakise, apnikhan jani ase.” ");
INSERT INTO nag_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Moi nomrota korise aru suku pani girikena aru Yehudi khan pora chalak kori kene moike dukh di thakile bhi moi Probhu laga sewa kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Aru moi apnikhan ke sikha khan te, manu usorte nohoile ghor te hoilebi tumi bhal nimite kaam nakori kene chari diya nai. ");
INSERT INTO nag_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yehudi aru Yehudi hobi, moi taikhan ke mon ghurai kene Isor phale ahibole aru Jisu ke biswas kori bole sikhai ahise. ");
INSERT INTO nag_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Aru sabi, etiya moi Atma laga kotha mani kene Jerusalem te jai ase hoilebi ta te moi logote ki hobo moi najane. ");
INSERT INTO nag_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Juntu sheher te jaile bhi Pobitro Atma pora ami laga gawah koridi thakise, aru khali bandha aru dukh he moike rukhi ase koi kene. ");
INSERT INTO nag_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kintu moi nijor jibon karone eku chinta nathaki, kintu Probhu Jisu pora ji kaam moike kori bole dise, utu Isor anugrah laga susamachar ke khushi pora manu ke jonai dibole aru etu pura kori bole he bhabi thake. ");
INSERT INTO nag_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Aru sabi, moi jani ase, moi Isor rajyo kotha loi kene sob jagate prochar koribo, aru apnikhan etiya pora ami laga chehera aru nadikhibo. ");
INSERT INTO nag_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Etu moi aji apnikhan ke sakhi di ase, moi ekjon golti nathaka manu laga khun phale hoile golti nai. ");
INSERT INTO nag_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kelemane Isor laga itcha phale sob kotha moi apuni khan ke koi diya hoise. ");
INSERT INTO nag_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Etu karone apnikhan nije bhi hoshiar thakibi aru Pobitro Atma pora apnikhan ke sabole mer khan dise. Hoshiar pora Isor laga girja ke roikhya koribi, jintu Isor Tai Nijor laga bacha khun pora kinise. ");
INSERT INTO nag_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Kelemane moi jani ase moi juwa pichete rong kutta khan tumi laga majote ahibo, aru tumikhan ke nacharibo jun khan etiya bisi ase. ");
INSERT INTO nag_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Aru moi jani ase tumikhan nijor bhitor pora bhi misa kowa ulabo aru biswasi khan ke taikhan phale kori loi lobo. ");
INSERT INTO nag_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Karone hoshiar koi kene thakibi, aru bhabona koribi, moi tin saal tak rati din suku pani girai kene sob manu ke sikhaise. ");
INSERT INTO nag_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Aru bhai khan moi etiya apnikhan ke di ase, Isor aru tai anugrah laga kotha juntu pora tumikhan ke uthidibo pare aru sapha kori diya khan logote milaikena tai laga miras pabo thaka khan ase. ");
INSERT INTO nag_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Moi kun laga suna, chandi, kapra khan lalos kora nohoi. ");
INSERT INTO nag_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Apnikhan jani ase, moi nijor hath pora sewa kori kene nijor aru jun moi logot thakise, taikhan ke ki lage sob kori ahise. ");
INSERT INTO nag_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Moi apnikhan ke sob rasta sikhai dise, kineka sewa kori kene dukhia khan ke modot koribo lage, aru Probhu Jisu kotha monte bhabona kori bole, juntu Tai nijor pora koise: “Lu-a pora to diya jon he bisi asishit ase.” ");
INSERT INTO nag_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Aru jitia tai etu kotha koi diya hoise, tai athukari kene taikhan logote prathana kori loise. ");
INSERT INTO nag_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Titia taikhan sob bisi kandise, aru Paul ke dhori kene taike chuma dise. ");
INSERT INTO nag_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Taikhan bisi mon dukh huwa to Paul laga kotha karone hoise, aru kitia bhi tai laga chehera nadikhibo kowa karone, aru taikhan taike loijai kene jahaaj tak punchai dise. ");
INSERT INTO nag_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Aru taikhan pora alag koi kene amikhan jahaaj te uthi kene sidha rasta jaise aru Cos te ponchise, aru dusra din Rhodes te, aru ta te pora Patara te ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ta te pora ekta jahaaj Phoenicia te jabole thaka paise, etu pora amikhan bhi ta te uthi kene jaise. ");
INSERT INTO nag_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Cyprus sheher ke dikhikena aru paar korise aru amikhan Syria phale jaise, aru Tyre te nami jaise, kelemane ta te jahaaj laga saman namabole thakise. ");
INSERT INTO nag_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Aru ta te kunba biswasi chela khan lok paikene amikhan saat din ta te thakise. Aru taikhan Atma dwara Paul ke Jerusalem te najabole koise. ");
INSERT INTO nag_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Jitia amikhan laga din pura hoi jaise titia taikhan pora alag hoi kene amikhan logote taikhan maiki khan aru bacha khan sob loi kene amikhan ke sheher bahar te loijai dise, amikhan sob ta te pora athukari kene prathana korise, ");
INSERT INTO nag_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","titia alag hoi kene amikhan jahaaj te uthijaise, aru taikhan nijor-nijor ghor te jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Aru jitia amikhan Tyre pora safar khotom hoise, amikhan Ptolemais te ponchise. Aru bhai khan ke salam jonai kene taikhan logote ek din thakise. ");
INSERT INTO nag_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Dusra din amikhan ta te pora ahi Caesarea te ponchise, aru prochar kora Phillip jun saat jon laga majote ekjon asele, tai ghor te ahi kene tai logot thakise. ");
INSERT INTO nag_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Etu manu laga shadi nakorikena thaka charjon swali thakise, aru utu khan sob bhabobani koi thakise. ");
INSERT INTO nag_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Aru ta te bisi din thaki jaise, titia bhabobadi ekjon Agabus koi kene Judea pora ahise. ");
INSERT INTO nag_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Jitia tai amikhan logot ahise tai Paul laga peti loi nijor hath theng ke bandi kene koise, “Jun manu etu komor bandha peti laga malik ase taike ‘Jerusalem te Yehudi khan pora taike eneka bandi kene Isor najana khan laga hathte dibo, eneka Pobitro Atma koi ase.’” ");
INSERT INTO nag_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Etu kotha huni kene amikhan aru ta te thaka khan sob pora Paul ke Jerusalem te najabi koi kene rukhaise. ");
INSERT INTO nag_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kintu Paul koise, “Apuni khan ki kori ase, kandi-kandi kene ami laga mon dukhai ase? Moi to taiyar ase, khali bandibole nimite nohoi, hoilebi Probhu Jisu naam karone mori bole bhi taiyar ase.” ");
INSERT INTO nag_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Jitia amikhan janise Paul to namanibo, titia amikhan chup thaki jaise aru titia moi khan koise, “Amikhan Isor laga itcha hobo dibi.” ");
INSERT INTO nag_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Aru utu din pichete amikhan saman bandhi kene Jerusalem te jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Caesarea te kunba chela khan amikhan logote ahise, aru taikhan Mnason koi kene Cyprus manu ekjon jun purana chela asele, taike amikhan logote thaki bole loi anise. ");
INSERT INTO nag_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Aru jitia amikhan Jerusalem te ponchise, biswasi bhai khan bisi khushi pora amikhan ke swekar korise. ");
INSERT INTO nag_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Aru dusra dinte Paul amikhan ke James laga ghor te loi jaise, ta te girja bura khan sob joma thakise. ");
INSERT INTO nag_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Titia tai taikhan ke salam jonai kene Isor pora tai laga sewkai dwara ki kaam Porjati khan logote korise, eitu khan sob ekta-ekta kori kene sob koi dise. ");
INSERT INTO nag_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Taikhan etu huni kene Isor ke mohima korise, aru tai koise, “Bhai khan etu sabi, Yehudi khan majote hajar manu bhi biswas kori loise, aru taikhan sob bhal pora niyom mani thake. ");
INSERT INTO nag_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Taikhan ke manu khan pora apuni laga kotha koi dise, apuni Porjati khan laga jagah te thaka Yehudi khan ke Moses laga niyom ke namanibi koi kene hikai ase, aru bacha khan laga sunnot nakorile bhi hobo eneka sikhai ase hunise. ");
INSERT INTO nag_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tinehoile amikhan ki koribo? Taikhan apuni yate ahi ponchise koi kene jani thakibo pare. ");
INSERT INTO nag_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Karone ekta kaam koribi amikhan logote kiba kori bole kosom luwa charjon ase. ");
INSERT INTO nag_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Taikhan ke loi kene taikhan logote nijorke bhi pobitro kori lobi, aru taikhan matha chuli pura kati bole kharcha dibi. Titia sob manu jani lobo taikhan pora tumikhan laga ki kotha koi ase etu sob misa ase, kintu tumikhan to thik pora thaki ase aru niyom manikena thaki ase koi kene jani lobo. ");
INSERT INTO nag_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kintu Porjati khan ke jun biswas kori loise utu khan ke amikhan age pora likhi dise, murti ke boli diya laga bostu aru khun, aru gola mussri kene mangso kha-a aru bebichar kora, etu sob pora bachi thakibi koise.” ");
INSERT INTO nag_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Titia Paul dusra din manu khan ke loi taikhan logote sapha kori loise, aru girja te jai kene ekjon-ekjon laga kiman din tak sapha koribo lage koi dise aru sob nimite daan korise. ");
INSERT INTO nag_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kintu jitia saat-din khotom hobole hoise, kunba Yehudi khan Asia pora ahikena taike mondoli te dikhise, aru manu khan ke chukli mari kene taike dhori loise. ");
INSERT INTO nag_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Taikhan hala kori kene koise, “Hey Israel khan, amikhan ke modot dibi, etu manu pora sob jagah te manu khan ke manu khan, niyom khan aru etu jaga laga bhirodh kotha koi ase aru sikhai ase, aru tai Yunani manu khan ke bhi girja te anikena pobitro jaga ke letera kori dise.” ");
INSERT INTO nag_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Age te Paul ekbar Trophimus koi kene Ephesus laga manu logote berai thaka dikhise, aru taikhan bhabise Paul he eitu ke loi girja te anise eneka bhabi thakise. ");
INSERT INTO nag_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Titia etu sheher te gondugol hoise, sob polai ahi kene Paul ke dhuri loise, aru taike tani bahar te loi jaise, aru joldi mondoli laga dorja khan bondh kori dise. ");
INSERT INTO nag_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Aru taikhan taike morai dibole thaka homoi te, pura Jerusalem te hungama hoi ase koi kene etu khobor mukhyo henedhikari logote ponchise. ");
INSERT INTO nag_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Titia tai joldi sipahi khan aru henapoti khan loi kene niche phale polaikena taikhan logot punchise, aru jitia manu khan mukhyo henedhikari aru sipahi khan ke dikhise, taikhan Paul ke mari thaka pora rukhi jaise. ");
INSERT INTO nag_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Titia mukhyo henedhikari usorte ahi kene taike dhori loise, aru duita luha rusi pora taike bandi lobole koi dise, aru hudise etu manu kun ase aru tai ki korise. ");
INSERT INTO nag_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Aru bhir te kunba kiba-kibi koise, aru kunba dusra kiba koi thakise, aru bisi hala kora karone tai thik pora eku bujhi bo para nai, etu karone taike bondhi kora jagate loi jabole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Jitia tai siri te ponchise, manu khan bisi khong kora karone sipahi khan taike uthaikene loi jaise. ");
INSERT INTO nag_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kelemane bisi manu tai piche-piche hala kori thakise, “Taike morai dibi!” ");
INSERT INTO nag_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Jitia taikhan Paul ke bondhi rakha jagate loi jabole thakise, tai mukhyo henedhikari ke koise, “Moi apuni ke kiba kotha kobo paribo?” Tai koise, “Tumi Yunani kotha kobo pare? ");
INSERT INTO nag_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Olop din age te, ekjon Egypt manu, jun pora chukli mari kene gondugol kori dise, aru char-hajar ‘Hathiara manu khan ke’ jongol te loi jaise, utu manu to tumi nohoi?” ");
INSERT INTO nag_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Kintu Paul koise, “Moi to Tarsus laga Yehudi ase Cilicia sheher te jonom huwa manu ase. Aru moi utu khas sheher laga ekjon manu ase. Etu nimite, apuni logote anurodh kori ase, moike manu khan logot kotha kori bole dibi.” ");
INSERT INTO nag_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jitia tai agya dise, Paul siri te khara hoi kene kotha kobole tai hath uthaise, aru manu khan chup hoi jaise, aru jitia taikhan chup hoise, titia tai Yehudi bhasa te kotha koise. Tai koise, ");
INSERT INTO nag_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Bhai khan, aru baba khan, moi etiya nijor laga safai te apnikhan usorte kotha kobole ase, etu ke huni bhi.” ");
INSERT INTO nag_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Aru jitia tai Yehudi bhasa te koise, taikhan arubi ekdom chup thaki jaise. Titia tai aru koise, ");
INSERT INTO nag_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Moi Yehudi ase Cilicia laga Tarsus sheher te jonom luwa, etu sheher pora Gamaliel laga theng te bohi kene amikhan laga baba khan laga niyom thik pora sikhi loise, aru Isor phale jor dikena aji apnikhan jineka kori ase tineka kori ahisele. ");
INSERT INTO nag_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Aru mota, maiki, hobi, etu dhorom Rasta te juwa khan ke bondhi ghor te dikene morai bhi di thakise, ");
INSERT INTO nag_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","etu kotha cholawta, bura khan aru sabha bhi sakhi dibo pare, moi taikhan pora ami laga bhai khan Damascus te thaka khan logote chithi likhi diya utu bhi loise, karone moi jai kene ta te kunba thakile dhori kene Jerusalem te ani taikhan ke sajai dibo bhabise. ");
INSERT INTO nag_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Etu homoi moi Damascus punchibole usor hoi asele, titia din nisena homoi asele, aru sorgo pora achanak ekta dangor puhor ahi moi usorte thaki jaise. ");
INSERT INTO nag_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Aru moi matite giri jaise, aru ekta awaj moike kowa hunise, ‘Saul, Saul, kele tumi Moike digdar kori ase? ");
INSERT INTO nag_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Karone moi hudise, ‘Probhu Apuni kun ase?’ Aru Tai moike koise, ‘Moi Nazareth Jisu ase, junke tumi dukh digdar di ase.’ ");
INSERT INTO nag_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Aru jun manu moi logot ahise, taikhan bhi puhor to dikhise aru bhoi korise, kintu taikhan moike kotha kowa laga awaj to huna nai. ");
INSERT INTO nag_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Titia moi koise, ‘Moi ki koribo lage Probhu?’ Aru Probhu moike koise, ‘Uthi kene Damascus te jabi, aru ta te tumi ki-ki koribo lage etu sob tumike koi dibo.’ ");
INSERT INTO nag_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Aru utu puhor bisi huwa karone moi eku dikhibo para nai, titia moi laga sathi khan laga hath dhurikena he moi Damascus te ahise. ");
INSERT INTO nag_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Titia Ananias koi kene ekjon asele, tai niyom mani thaka ekjon asele, aru ta te thaka Yehudi khan bisi sonman kori thaka manu ase. ");
INSERT INTO nag_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tai ami laga usorte ahikena koise, ‘Bhai Saul, apuni laga suku dikhi bhi.’ Aru etu homoi te moi dikhibole parise aru taike dikhise. ");
INSERT INTO nag_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Titia tai koise, ami laga baba khan laga Isor he tumike basi loise, tumi he tai itcha ke janibole aru Dharmikta Jonke sabo paribole aru tai nijor mukh pora kowa awaj ke huni bole. ");
INSERT INTO nag_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kelemane tumi ki dikhise aru ki hunise etu sob manu ke koi dibole tai sakhi bonai dise. ");
INSERT INTO nag_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tinehoile apuni etiya bhi kele bohi ase? Uthi kene baptizma loi lobi, aru prathana kori kene tai naam pora tumi laga paap dhui dibi.’ ");
INSERT INTO nag_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Titia moi aru Jerusalem te ahi kene mondoli te prathana kori asele, titia moi Atma te bhorta hoi kene darshan dikhise. ");
INSERT INTO nag_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Aru moi Probhu ke dikhise, Tai moike koise, ‘Joldi Jerusalem chari kene jabi, kelemane taikhan Ami laga kotha tumi gawahi diya ke namanibo.’ ");
INSERT INTO nag_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Karone moi koise, ‘Probhu, moi pora biswasi khan mondoli te dhurikena bondhi ghor te diya aru mari thaka taikhan jani ase. ");
INSERT INTO nag_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Aru jitia Apuni nimite mori juwa Stephen ke khun giraikena morai di thakise, ta te moi bhi thakise, aru jun manu khan pora taike morai dise utu khan laga kapra ke moi rukhi thakise.’ ");
INSERT INTO nag_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Titia Tai moike koise, ‘Jabi, kelemane moi tumike yate pora dur Porjati khan logot pathai dibo.’ ");
INSERT INTO nag_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Aru taikhan etu kotha kowa tak taike huni thakise. Etu pichete taikhan awaj uthaikene hala kori koise, “Eneka manu ke prithibi pora hatai dibi, kelemane tai jinda thaki bole thik nohoi.” ");
INSERT INTO nag_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Titia taikhan hala kori kene taikhan laga kapra khan ulai phelaise, aru upor hawa te dhul urai thakise, ");
INSERT INTO nag_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","titia mukhyo henedhikari pora Paul ke bondh kora jagate loi jabole hukum dise, aru manu khan kele taike iman ghusa kori ase etu janibole taike chabuk pora mari kene bhal pora hudibole koise. ");
INSERT INTO nag_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Aru taikhan jitia taike chabuk mari bole taiyar korise, Paul pora tai usorte khara thaka henapoti ke koise, “Rome manu ke eku golti nathaki kene bhi chabuk mari bole niyom te ase?” ");
INSERT INTO nag_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Jitia henapoti etu kotha hunise tai mukhyo henedhikari logote jai kene koise, “Apuni eneka kele kori ase? Tai Rome laga nagrik ase.” ");
INSERT INTO nag_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Titia henedhikari tai logot te ahikena koise, “Moike kobi, tumi Rome laga nagrik ase?” Paul koise “Hoi”. ");
INSERT INTO nag_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Etu huni kene mukhyo henedhikari pora koise, “Moi to Rome laga nagrik hobole bisi toka poisa pora kinise.” Kintu Paul koise, “Moi to jonom pora he Rome laga nagrik ase.” ");
INSERT INTO nag_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Titia jun taike mari bole thakise, taikhan loge- loge tai usor pora joldi hati jaise. Aru kitia mukhyo henedhikari bhi Paul to Rome laga nagrik ase koi kene janise, tai bhi bhoi khaise kele koile tai pora Paul ke dhori kene bandh kora karone. ");
INSERT INTO nag_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Dusra din Yehudi khan pora ki nimite Paul ke doshi korise, etu janibole mukhyo henedhikari pora Paul ke khuli dise, aru mukhyo purohit khan aru sabhakhan ke joma kori bole hukum dise, aru Paul ke loi kene taikhan age te khara kori dise. ");
INSERT INTO nag_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Titia Paul sabha laga adhikari khan phale dhyan pora saikene koise, “Bhai khan, moi aji tak ekjon bhal nagrik nisena thakise, ami sapha mon pora Isor usorte bhal pora ahise.” ");
INSERT INTO nag_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Titia moha purohit Ananias pora jun khan Paul usorte khara ase taikhan pora Paul laga mukh te marikena bondh kori dibole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Titia Paul taike koise, “Isor pora apuni ke mari dibole ase, chuna pora boga kori rakha dewar khan. Isor apuni ke saja dibo, apuni niyom pora amike bisar kori bole bohi ase, aru kele niyom bhirodh te moike mari bole hukum di ase?” ");
INSERT INTO nag_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Kintu jun khan tai usorte khara asele taikhan koise, “Kile apuni Isor laga moha purohit ke ninda kori ase?” ");
INSERT INTO nag_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Titia Paul koise, “Bhai khan, tai moha purohit ase koi kene moi jana nai. Kilekoile likha ase, Tumi pora tumi laga cholawta laga biya kotha nakobo.” ");
INSERT INTO nag_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kintu jitia Paul dikhise sabha laga ekta bhag Sadducee khan aru dusra bhag Pharisee khan ase, tai sabha te jor pora koise, “Bhai khan, moi Pharisee ase aru Pharisee khan laga chokra ase, aji moike bisar kora to morija-a khan jee uthibo laga asha laga kotha kowa nimite he ase.” ");
INSERT INTO nag_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Aru jitia tai etu koi dise, Pharisee aru Sadducee khan laga majote kotha namila hoise, aru sabha to dui bhag hoi jaise. ");
INSERT INTO nag_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kelemane Sadducee khan punoruthan, sorgodoth aru atma khan te biswas nakore: kintu Pharisee khan to etu sob bhi hosa ase koi kene mani thake. ");
INSERT INTO nag_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Titia bisi jor pora hala hoi jaise aru Pharisee khan jaga pora uthi kene apatti kori koise, “Amikhan etu manu laga eku dosh pa-a nai. Kintu jodi ekta atma pora, nohoile bhi, ekjon sorgodoth pora taike kotha koi kene ase koile?” ");
INSERT INTO nag_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Titia taikhan bisi jhagara hoi jaise, aru henedhikari bhabise taikhan Paul ke tukra kori dibo, aru etu laga bhoi pora tai sipahi khan ke pathaise, aru joborjosti sabha pora taike bondh kora jagate loi jabole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kintu utu rati te tai usorte Probhu ahi kene khara hoi kene koise, “Mon dangor hobi, kelemane tumi Jerusalem te Ami laga gawahi dise, tineka tumi Rome te bhi Ami laga gawahi dibo lagibo.” ");
INSERT INTO nag_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Jitia din ulaise, kunba Yehudi khan mili kene, jitia tak Paul ke loi kene morai nadibo, titia tak eku bhi nakhabo koi kene kosom korise. ");
INSERT INTO nag_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Jun khan kotha milai thakise eitu khan chalis-jon pora bhi bisi thakise. ");
INSERT INTO nag_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Titia taikhan mukhyo purohit khan aru bura khan logote jai kene koise, “Amikhan jitia tak Paul ke morai nadibo titia tak eku bhi nakhabo koi kene kosom khaise. ");
INSERT INTO nag_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Karone apnikhan aru sabhakhan mili kene mukhyo henedhikari logot khobor pathai dibi aru Paul ke bhal pora kotha hudibi kobi, aru eneka koi kene tai pora Paul apnikhan logot anibo. Aru amikhan to tai yate napuncha age te taike morai dibole taiyar ase.” ");
INSERT INTO nag_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kintu jitia Paul didi laga chokra pora taikhan Paul ke mari bole rukhi thaka janise, tai Paul ke bondh kora jagate ahikena taike etu kotha koi dise. ");
INSERT INTO nag_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Titia Paul ekjon henapoti ke mati anikena koise, “Etu chokra ke mukhyo henadhikari logote loijabi, tai kiba kobole ase.” ");
INSERT INTO nag_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Karone tai taike loi kene mukhyo henedhikari logot jaise aru koise, “Bondhi ghor te thaka Paul pora moike matise aru moike etu lora apuni logote loi ani dibi koi kene anurodh korise. Tai apuni logote kiba kobole ase koise.” ");
INSERT INTO nag_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Titia mukhyo henedhikari pora tai hath dhurikena kinar te alag loijai kene hudise, “Tumi moike ki kobole ase?” ");
INSERT INTO nag_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Aru tai koise, “Yehudi khan mili kene Paul laga kotha ke aru bhal pora hudibole kali sabha te taike loi anibole bhabona pora apuni logot anurodh kori bole ase. ");
INSERT INTO nag_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kintu taikhan laga kotha namanibi, kelemane taikhan chalis-jon pora bhi bisi manu taike morai nadiya tak ekubi kha luwa nakoribo koi kene kosom khai kene ase, aru taikhan apuni pora hukum pabole etiya bhi rukhi thaki ase.” ");
INSERT INTO nag_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Titia mukhyo henedhikari pora lora ke koise, “Etu kotha tumi moike kowa khan kunke bhi nokobi.” ");
INSERT INTO nag_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Aru tai henapoti duijon ke mati ani kene koise, “Aji rati nou-baji te duisoh sipahi aru sat-ta ghora chola sipahi aru duisoh jathi-dhora sena khan loi kene Caesarea te jabole taiyar kori dibi. ");
INSERT INTO nag_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Aru Paul ke jabole nimite ghora taiyar koribi aru taike bachai kene Governor Felix logot loijabi. ");
INSERT INTO nag_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Tai eneka chithi bhi likhi dise: ");
INSERT INTO nag_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Claudius Lysias pora Rajyopal Felix ke salam jonai ase. ");
INSERT INTO nag_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Etu manu to Yehudi khan pora taike dhori kene morai dibole thaka te moi jani loise, tai Rome laga nagrik ase, moi joldi sipahi loijai kene taike bachai loise. ");
INSERT INTO nag_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Aru taikhan kele taike golti lagai ase, etu janibole mon hoi kene moi taike sabha te loi jaise. ");
INSERT INTO nag_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Aru moi jani paise taikhan nijor niyom kotha laga kotha namila pora taike golti kora he ase, aru taike morai dibole aru bandhi bole eneka eku bhi golti pa-a nai. ");
INSERT INTO nag_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Aru jitia Yehudi khan taike morai dibole kotha milai thakise, etu kotha moike jonai dise, titia moi taike joldi apuni logote pathai dise, aru tai golti diya khan ke bhi taikhan laga kotha apuni laga usorte kobole koi dise.” ");
INSERT INTO nag_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Titia sipahi khan taikhan ke kowa nisena rati te Paul ke Antipatris te loijai dise. ");
INSERT INTO nag_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Dusra dinte sipahi bisi khan wapas jai jaise, kintu ghora chola sipahi khan ke Paul logot jabole dise. ");
INSERT INTO nag_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Jitia sipahi khan Caesarea te ponchise, taikhan pora Governor ke chithi dise aru Paul ke bhi tai usorte khara kori dise. ");
INSERT INTO nag_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Aru Governor pora chithi porhi kene hudise tai kun desh laga ase. Aru jitia tai jani loise tai Cilicia desh pora ase, ");
INSERT INTO nag_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tai koise, “Jitia tumi laga golti diya khan ahibo, titia moi tumi laga kotha hunibo.” Aru taike Herod bisar kora jagah te rakhi dibi koi kene hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pans-din pichete mukhyo purohit Ananias aru kunba bura khan aru ekjon ukil jun laga naam Tertullus asele, taikhan arubi ahikena Governor ke Paul bhirodh te kotha koise. ");
INSERT INTO nag_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Aru jitia Paul ke Governor age te anise, Tertullus taike golti dikene eneka koise, “Apuni karone amikhan bisi shanti thaki ase, aru etu desh te apuni laga gyaan pora bodli korise; ");
INSERT INTO nag_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Amikhan laga sob jagah te aru hodai etu karone khushi pora apuni ke dhanyavad kori thake. ");
INSERT INTO nag_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Hoilebi, apuni laga homoi aru bhi nolobole, ami apuni logot te anurodh ase, morom kori amikhan laga ekta kotha huni bhi. ");
INSERT INTO nag_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kelemane etu manu to mara-mari kore aru duniya te thaka Yehudi khan laga sob jagah te bhirodh aru gondugol kori thaka Nazareth manu ekjon cholawta ase, amikhan jani paise. ");
INSERT INTO nag_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tai mondoli ke bhi apobitro kori bole bisarisele, etu nimite amikhan taike dhuri loise, aru ami laga niyom pora taike bisar koribo thakise. ");
INSERT INTO nag_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Kintu henapoti pora Lysias te ahi kene joborjosti amikhan laga hath pora taike dhori loi jaise. ");
INSERT INTO nag_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Taike golti diya khan ke apuni usorte ahi kobole koise, kintu apuni nijor hudile jani jabo amikhan taike ki karone golti di ase.” ");
INSERT INTO nag_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Aru Yehudi khan bhi mili kene taike etu sob kotha to hosa ase koi dise. ");
INSERT INTO nag_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Titia Governor Paul ke kotha kobole nimite koise, titia Paul koise, “Ami bujhi ase apuni bisi saal pora etu jati khan laga bisar kori ahi thakise, etu karone moi khushi pora ami laga sob kotha apuni ke kobole ase. ");
INSERT INTO nag_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kelemane apuni nijor jani jabo moi jitia pora aradhana kori bole Jerusalem te ahise, baroh-din pora bisi huwa nai. ");
INSERT INTO nag_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Aru taikhan moike mondoli aru mondoli aru sheher te kun logot te bhi kotha namila, nohoile gondugol lagi thaka pa-a nai. ");
INSERT INTO nag_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Aru taikhan ki kotha loi moike bodnam lagai ase, etu kun bhi sakhi dibo na paribo. ");
INSERT INTO nag_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kintu moi apuni ke hosa kotha koi ase, taikhan juntu Rasta ke ekta dol mati ase, eneka laga rasta pora Isor ke sewa kori ahise. Ki niyom te ase aru ki bhabobadi khan pora likhise, etu sob te moi bhal pora mani kene ahise. ");
INSERT INTO nag_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Aru ami Isor ke mon dangor laga etu asha ase, juntu etu manu khan nijor bhi rukhi ase, juntu to ase mori kene jinda hobole thaka, dharmik aru adharmik khan sob bhi. ");
INSERT INTO nag_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Etu karone moi Isor phale bhi aru manu phale bhi sapha bhabona bhal thakibo karone kosis kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Aru bisi saal pichete moi nijor jati khan ke poisa dibole anise, dukh thaka jati khan ke daan dibole anise. ");
INSERT INTO nag_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Taikhan ami etu kori thaka dikhise, mondoli pora sapha kori loi kene, bhir nohoile gondugol bhi thaka nai. ");
INSERT INTO nag_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Aru kunba Yehudi khan Asia pora ahise, taikhan ami laga bhirodh te thakile, taikhan apuni usorte ahi kene kobo lage. ");
INSERT INTO nag_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nohoile, yate etu manu thaka khan bhi jodi moi kiba golti kaam kora paise koile moi Yehudi sabha usorte khara thaka homoi te koi dibi, ");
INSERT INTO nag_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","khali ekta kotha karone ase, juntu moi sob manu usorte koisele, ‘Mora khan aru jee uthibo, etu kotha ke loi aji moike apuni usorte khara kori bisar kori ase.’” ");
INSERT INTO nag_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Jitia Felix etu kotha hunise, tai aru poritran Rasta ke bhal pora janibo mon hoi kene, taikhan ke rukhai dise. Tai koise, “Jitia sipahi laga senapoti Lysias Jerusalem pora ahibo, moi tumi laga bisar koribo.” ");
INSERT INTO nag_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Aru tai henapoti ke koi kene Paul ke bondhi ghor te rakhise, hoilebi taike bhi bandi narakhikena khula chari dibole koise, aru tai sathi khan tai logote ahibole bhi mana na koribi koise. ");
INSERT INTO nag_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Aru olop din pichete Felix tai laga Yehudi maiki Drusilla logote wapas ahise, jun Yehudini asele, aru tai Paul ke mati bole pathaise aru tai Paul dwara hunise Jisu Khrista ke biswas laga kotha. ");
INSERT INTO nag_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Aru jitia Paul pora taike dhormikta aru nijorke rukhabo para aru aha dinte bisar hobole thaka kotha khan thik pora koi dise, Felix bisi bhoi koi kene koise, “Etu bar to jai jabi. Jitia moi homoi pabo titia tumike aru matibo.” ");
INSERT INTO nag_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tai Paul pora poisa bhi pabo bhabikena tai hodai Paul ke mati ani kotha kori thakisele. ");
INSERT INTO nag_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kintu dui saal pichete Porcius Festus he Felix jagah te Governor hoi jaise, kintu Felix to Yehudi khan ke khushi kori bole mon asele, aru tai Paul ke bondh kora jagate he aru bhi thaki bole dise. ");
INSERT INTO nag_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Titia, Festus etu jagate ahise, aru tin din pichete, tai Caesarea pora Jerusalem te jaise. ");
INSERT INTO nag_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Titia mukhyo purohit khan aru Yehudi laga cholawta khan Festus logot Paul bhirodh te golti lagaise, aru anurodh korise. ");
INSERT INTO nag_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Aru Paul laga bhirodh te ekta upkar Festus ke mangise - ki Festus pora Paul ke Jerusalem te matibo nimite- eneka hoile taike loija-a homoi te kunba khan rasta te rukhai kene taike morai dibole bhabona thakise. ");
INSERT INTO nag_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kintu Festus koise Paul to Caesarea te bondhi ase, aru tai nijor bhi joldi ta te jabole ase. ");
INSERT INTO nag_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tai koise, “Etu karone tumikhan majote kun cholawta ase taikhan moi logote jabole dibi. Jodi etu manu kiba biya kaam korise koile, taikhan taike golti dibole kobi.” ");
INSERT INTO nag_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Aru tai dos din nisena taikhan logote thaki kene tai Caesarea te ahi jaise, aru dusra din bisar jagate bohi kene Paul ke loi anibole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Aru jitia Paul ahise, Jerusalem pora aha Yehudi khan ahi tai age piche khara hoi kene taike bisi biya golti lagaise jun to taikhan nijor bhi sakhi koribo napare. ");
INSERT INTO nag_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Titia tai nijor kotha koise, “Moi Yehudi khan niyom laga bhirodh, nohoile girja ke bhirodh, nohoile Caesar laga bhirodh te eku bhi golti kora nohoi.” ");
INSERT INTO nag_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kintu Festus Yehudi khan ke khushi koribo itcha pora Paul ke koise, “Tumi Jerusalem te jai kene ami laga bisar jaga usorte etu kotha loi bisar korile tumi itcha hobo?” ");
INSERT INTO nag_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Titia Paul koise, “Moi etiya bhi Caesar bisar jaga usorte khara ase, ami laga bisar yate hobo lage, apuni bhi jani ase, moi Yehudi khan logot eku golti kora nohoi. ");
INSERT INTO nag_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Jodi moi golti ase, aru etu nimite moike morai dibole layak ase koile moi morile bhi apatti nai. Kintu ki kotha loi kene moike doshi di ase, jodi ekta bhi hosa nohoi koile, kunbi moike taikhan hathte dibo na paribo, moi Caesar logot anurodh koribo.” ");
INSERT INTO nag_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Titia Festus pora sabhakhan ke kotha kori kene koise, “Tumi Caesar logote kotha mila bole kori ase. Karone tumi Caesar logote jabo!” ");
INSERT INTO nag_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Aru olop din juwa pichete Raja Agrippa aru Bernica Caesarea te ahi Festus ke adar dise. ");
INSERT INTO nag_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Aru duijon ta te bisi din thaka pichete, Festus Paul laga kotha raja ke koi dise. Tai koise, “Felix pora yate kunba ekjon ke bondh kora jagate rakhi ase. ");
INSERT INTO nag_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Aru jitia moi Jerusalem te jaise, Yehudi khan laga mukhyo purohit khan aru bura khan tai bhirodh te golti kotha moike koise, bisar kori taike saja dibole. ");
INSERT INTO nag_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kintu moi taikhan ke koise, Rome laga niyom te to hoile, kunke golti lagai ase, taike bisar kora dinte taike golti lagai diya khan usor nijor sob kotha kobole homoi nadi kene taike saja diya niyom nai. ");
INSERT INTO nag_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Karone jitia taikhan yate ahi kene joma hoise, moi deri nakori kene dusra din, bisar jagate bohi kene utu manu ke loi anibole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Jitia taike golti diya manu khan khara koi kene tai laga golti koise, taikhan eku biya golti dibo para nai, jineka moi bhabise tineka huwa nai. ");
INSERT INTO nag_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kintu taikhan nijor dhorom kotha aru mori juwa Jisu koi kene ekjon asele, Paul koi utu jinda ase, etu kotha loi kotha namila he ase. ");
INSERT INTO nag_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Aru etu laga motlob moi bhal pora bujhi bole para nai, karone moi taike hudise jodi tai etu kotha ke bisar kori bole Jerusalem te jabole mon kore na nai. ");
INSERT INTO nag_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kintu Paul koise tai Caesar logote anurodh koribo, etu karone moi taike Caesar logot pathai nadiya tak taike bondh kora jagate thaki bole hukum dise.” ");
INSERT INTO nag_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Titia Agrippa pora Festus ke koise, “Moi nijor utu manu laga kotha hunibo itcha ase. Festus jawab dise, “Kali apuni tai kotha huni bole pabo.” ");
INSERT INTO nag_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Karone dusra din Agrippa aru Bernica duijon dhum-dham pora bhal kapra lagai kene aru sheher laga daruga khan aru dusra cholawta logote sabha te ahise. Aru jitia Festus hukum dise, titia Paul ke loi anise. ");
INSERT INTO nag_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus koise, “Raja Agrippa aru jun yate ahi bohi ase, apnikhan bhi etu manu ke dikhi ase, etu manu nimite yate thaka Yehudi khan sob aru Jerusalem te thaka sob moi logote binti korise tai jinda thaki bole nalage koise. ");
INSERT INTO nag_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kintu tai moribo lage eneka eku kaam kora moi pa-a nai, aru tai nijor moi Caesar logot anurodh koribo koise, to moi taike pathai dibole faisla kori loise. ");
INSERT INTO nag_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kintu tai laga kotha ami Caesar logot kineka likhibo thik napai-a karone, moi taike apnikhan aru khaas pora Raja Agrippa apuni usorte loi anise, pichete kiba likhi bole pabo bhabona kori kene. ");
INSERT INTO nag_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kelemane ekjon manu ke ki nimite bondhi nisena pathai ase etu thik pora nalikhile, etu to moi hisab te thik nohobo.” ");
INSERT INTO nag_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Titia Agrippa pora Paul ke koise, “Tumi nijor laga kotha kobole homoi di ase.” Titia Paul tai hath uthaikene tai nijor laga safai diya kotha koise. ");
INSERT INTO nag_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Raja Agrippa, ji-ji kotha Yehudi khan moike bodnam lagai ase, aji apuni usorte utu laga sob jowab dibole homoi pa-a karone moi bisi khushi hoi ase; ");
INSERT INTO nag_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","kelemane Yehudi khan laga niyom te kotha namila kora sob apuni jani thaka karone, aru moike morom kori nomro pora moi laga kotha huni bole anurodh kori ase. ");
INSERT INTO nag_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Jineka ami chokra thaka homoi te Jerusalem pora nijor jati khan logote ahise, etu sob Yehudi khan jane. ");
INSERT INTO nag_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Taikhan jodi gawahi dibole mon thakile to shuru pora taikhan moike jani ase, moi Pharisee hoi kene taikhan laga dhorom te sob pora kara te choli ahise. ");
INSERT INTO nag_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Aru etiya moi yate khara koi kene bisar huwa to Isor ami laga baba khan ke ki kosom dise utu asha kora karone ase. ");
INSERT INTO nag_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Etu kosom ke pabo karone asha pora amikhan baroh-jati khan pura mon lagai kene raat-din Isor ke sewa kori ahise. Raja Agrippa, etu asha nimite he Yehudi khan moike golti lagai ase. ");
INSERT INTO nag_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Jitia Isor mora manu ke jinda kore, kele apnikhan etu to biswas kori bole nohoi bhabe? ");
INSERT INTO nag_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Hosa ase, moi bhi Nazareth Jisu naam bhirodh te bisi kaam koribo lage bhabi ahise. ");
INSERT INTO nag_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Aru moi Jerusalem te eneka korise, mukhyo purohit khan pora hukum loi pobitro khan ke dhori bondhi ghor te haali kene morai diya te moi laga bhi itcha thakise. ");
INSERT INTO nag_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Aru moi sob mondoli te taikhan ke dukh di-dikene joborjosti kori thakise, khali etu he nohoi kintu bisi gusa hoi kene bahar laga sheher te bhi jai kene taikhan ke dukh digdar di thakise. ");
INSERT INTO nag_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Jitia etu kori bole moi moha purohit khan pora hukum loi kene Damascus te jai thakise; ");
INSERT INTO nag_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","aru titia rasta he, O Raja, din laga homoi te akas pora moi dikhise suryo pora bhi bisi ujala, moi aru ami laga logote jai thaka khan usorte chamkise. ");
INSERT INTO nag_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Aru jitia amikhan sob matite giri jaise, moi ekta awaj Ibrani bhasa te moike kowa hunise, ‘Saul, Saul tumi kele Moike digdar kori ase? Tumi dhar thaka te laat marile tumi karone bisi dukh hobo.’ ");
INSERT INTO nag_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Karone moi koise, ‘Probhu, Apuni kun ase?’ Aru Probhu pora koise, ‘Moi Jisu ase junke tumi digdar kori thake.’ ");
INSERT INTO nag_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kintu uthibi aru tumi laga theng te khara hobi; kelemane Moi aji tumi ki dikhise etu manu ke kobole aru aha kali bhi dikha bole thaka khan ke gawahi dibole dikhai dise; ");
INSERT INTO nag_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","aru Moi tumike Yehudi aru Isor najana khan logote pathabo, aru taikhan hath pora tumike bachai thakibo, ");
INSERT INTO nag_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","tumi pora taikhan laga suku khuli dibo aru taikhan andhar pora ujala te ani dibole, aru Saitan laga takot pora Isor phale ghurai anibole, paap pora khyama pabole, aru biswas pora pobitro khan logote ki jaga ase utu pabole.’ ");
INSERT INTO nag_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Karone, Raja Agrippa, moi etu sorgo darshan laga kotha ke namani kene chari diya nohoi; ");
INSERT INTO nag_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","kintu poila moi Damascus te thaka khan ke koi dise, aru Jerusalem te thaka khan ke bhi, aru Judea sob te bhi, aru Isor najana khan ke bhi taikhan laga paap pora Isor phale ghuri ahibole, aru mon bodli huwa kaam khan kori bole koi dise. ");
INSERT INTO nag_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kelemane etu karone Yehudi khan mondoli pora moike dhori loise, aru morai dibole hoise le. ");
INSERT INTO nag_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kintu Isor laga modot pora aji tak yate khara hoi kene chutu, dangor sob usorte gawahi di aru Moses aru bhabobadi khan pora aha dinte ki hobole ase etu kotha kowa khan he nohoile dusra eku kowa nai- ");
INSERT INTO nag_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","etu kotha Khrista bisi dukh koribo aru mora pora tai he prothom jee uthibo, Tai Yehudi khan aru Porjati khan logote puhor laga prochar koribo. ");
INSERT INTO nag_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Jitia Paul tai nijor kotha koi dise, Festus jor pora hala kori koise, “Paul, tumi pagla hoise; bisi sikha karone tumike pagla bonai dise.” ");
INSERT INTO nag_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kintu Paul koise, “O mohan Festus, moi pagla nohoi, kintu hosa aru buddhi laga kotha koi ase. ");
INSERT INTO nag_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Raja bhi etu sob jani ase, moi eku bhoi nakori kene koi ase, aru etu kotha tai najana eneka ekta bhi kowa nai koi kene moi bhabi ase; etu ghatna to manu khan nathaka te kora nohoi. ");
INSERT INTO nag_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Raja Agrippa, apuni bhabobadi khan ke biswas kore? Hoi, moi jane, apuni biswas kori ase.” ");
INSERT INTO nag_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Titia Agrippa Paul ke koise, “Olop homoi te, tumi aram pora moike Khristan bonai dibole ase?” ");
INSERT INTO nag_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul koise, “Isor logote moi anurodh kori ase, olop nohoile bisi homoi pichete hoilebi, aji apuni logote bohi ami laga kotha huni thaka sob bhi moi nisena hobole dibi, hoilebi jineka moike rusi pora bandhikena ase etu nisena nohoi.” ");
INSERT INTO nag_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Jitia tai etu kotha koise, titia Raja aru Governor aru Bernice, aru taikhan logote bohi thaka sob khara hoi jaise; ");
INSERT INTO nag_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","aru taikhan alag jai kene nijor te kotha korise, aru koise, “Etu manu mori bole aru bandibole eneka eku biya kaam kora nohoi.” ");
INSERT INTO nag_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Titia Agrippa pora Festus ke koise, “Jodi etu manu Caesar logot anurodh nakorile, taike chari dile bhi hobole asele.” ");
INSERT INTO nag_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Aru jitia amikhan Italy te jabole faisla kori loise, taikhan Paul aru dusra bondh kora manu khan ke Julius koi kene Augustus Regiment laga henapoti ekjon laga hathte di dise. ");
INSERT INTO nag_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Titia amikhan Adramyttium pora ekta jahaaj Asia samundar phale jabole thaka te uthijaise. Aru amikhan safar korise. Thessalonica pora Macedonia laga ekjon Aristarchus koi kene bhi amikhan logote asele. ");
INSERT INTO nag_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Aru dusra dinte amikhan Sidon sheher te ahise, aru Julius pora Paul ke bisi morom korise aru tai sathi logote berabo dise, aru tai ki lage sob taike di thakise. ");
INSERT INTO nag_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Aru amikhan ta te pora jabole ulaise hoilebi hawa bisi jor pora mara karone jahaaj to Cyprus phale loi kene jaise. ");
INSERT INTO nag_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Aru amikhan Cilicia aru Pamphylia samundar paar kori Lycia laga sheher Myra te ahi jaise. ");
INSERT INTO nag_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ta te henapoti he Alexandria laga ekta jahaaj Italy te jabole thaka paikene amikhan ke ta te uthai dise. ");
INSERT INTO nag_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Amikhan bisi din aste-aste jai thakise, aru bisi digdar pora Cnidus ponchise, kintu hawa bisi mara pora amikhan age jabole para nai, etu pora jahaaj ke loi kene Crete phale loi jaise, juntu Salmone usorte ase. ");
INSERT INTO nag_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Amikhan bisi digdar pora safar korise aru Lysea sheher usorte Bhal Jaga eneka te ponchise. ");
INSERT INTO nag_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Etiya bisi homoi jaise, panite bera bole digdar hoise, aru etiya to Yehudi khan laga upwas din bhi paar hoise, karone Paul taikhan ke hoshiar kori bole, ");
INSERT INTO nag_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","koise, “Hey manu khan, amikhan etiya yate pora jaise koile digdar aru bisi nuksan bhi hobo pare, khali saman aru jahaaj he nohoi, kintu manu jibon bhi jabo pare.” ");
INSERT INTO nag_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Hoilebi henapoti pora Paul laga kotha namani kene jahaaj laga malik khan laga kotha he manise. ");
INSERT INTO nag_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Aru utu jaga to thanda dinte ta te thaki bole thik nohua karone bisi manu parile Phoenix te he thakile bhal hobo bhabise. Phoenix to Crete usorte ekta jaga ase, dakshin-paschim aru uttor-paschim phale bhi jabo para jagah ase. ");
INSERT INTO nag_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Titia dakshin pora halka-halka hawa ahise, jahaaj chola khan bhabise taikhan ki lage etu sob taikhan logot ase. Etu pora taikhan Crete phale jabole jahaaj khuli dise. ");
INSERT INTO nag_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kintu bisi deri nohoi kene dangor hawa pani laga tufan ta te pora ahi taikhan ke lagise. ");
INSERT INTO nag_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Jitia tufan pora jahaaj ke dhorise, taikhan aru age jabo napari kene hawa pora jahaaj ke kote loi jabole ase, loijabo dise. ");
INSERT INTO nag_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Titia Cauda naam laga ekta majuli te bisi digdar pora punchise aru chutu naw ke dhori rakhibo parise. ");
INSERT INTO nag_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Titia taikhan chutu naw ke uthai anise aru niche pora bandi loise. Syrtis laga balu matite lagi bole bhoi pora jahaaj kapra khan khuli dise, aru jahaaj ke hawa pora loijabo dise. ");
INSERT INTO nag_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kintu dusra din tak amikhan ke tufan pora bisi digdar di thakise, etu karone taikhan jahaaj pora saman khan samundar te phelai dise. ");
INSERT INTO nag_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Aru tin din pichete amikhan nijor hath pora jahaaj laga saman uthaikene samundar te phelai dise. ");
INSERT INTO nag_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Aru jitia bisi din tak suryo aru tara khan ula nai aru tufan bhi bisi mari thakise, titia amikhan bachibole asha sob chari dise. ");
INSERT INTO nag_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Titia bisi din pora kha-luwa nakora karone, Paul khara kori kene taikhan ke koise, “Sabi, apnikhan ami laga kotha mani kene Crete pora najaile bhal hobole asele, tinehoile amikhan eneka digdar aru nuksan nohobo asele. ");
INSERT INTO nag_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kintu etiya moi apnikhan ke mon dangor rakhibole koi ase, kelemane khali jahaaj ke he nohoile, kunke bhi digdar nohobo. ");
INSERT INTO nag_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kelemane moi jun laga ase, aru junke sewa kore, tai sorgodoth aji rati moi logote ahise. ");
INSERT INTO nag_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Aru koise, ‘Paul, tumi bhoi na koribi. Tumi Caesar age te khara hobo lagibo, aru sabi Isor tumike morom kori kene tumi logote juwa manu khan sob etiya bhi tumi logote he ase.’ ");
INSERT INTO nag_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Karone manu khan mon dangor hobi! Kelemane moi Isor ke biswas kore, jineka Tai koise tineka hobo. ");
INSERT INTO nag_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Hoilebi amikhan ekta majuli te loijai kene rakhibo pare.” ");
INSERT INTO nag_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Titia choudah rati hoise, aru amikhan Adriatic Samundar majote loijai kene thaki jaise, aru adha rati te jahaaj chola khan bhabise taikhan to kunba mati usorte ahi punchise. ");
INSERT INTO nag_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Aru taikhan pani laga galta ke naapi sai sele bisi lamba galta thakise, ekta hath to choi feet ase, aru olop jai kene aru sai sele, pondro hath paise. ");
INSERT INTO nag_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Titia pathor te lagibo bhoi pora taikhan piche phale pora loha longor charta phelai dise, aru phojur hobole prathana kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Aru jahaaj chola manu khan jahaaj charikena polabole bhabise, taikhan jahaaj pora longor phelai diya nisena bahana pora chutu naw ke niche samundar te girai dise. ");
INSERT INTO nag_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Titia Paul pora henapoti aru sipahi khan ke koise, “Jodi eitu khan jahaaj te nathakile apnikhan kitia bhi bachibole na paribo.” ");
INSERT INTO nag_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Titia sipahi khan jai kene chutu naw laga rusi khan kati girai dise. ");
INSERT INTO nag_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Aru jitia phojur hobole hoise, Paul sob manu ke kiba khabole koise. Tai koise, “Aji choudah din hoise apnikhan eku nakhai kene bhukha thaki ase. ");
INSERT INTO nag_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Karone moi apnikhan ke koi ase, kiba khai lobi, kelemane eneka korile bachibo paribo, tumi laga matha pora ekta chuli bhi na giribo.” ");
INSERT INTO nag_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Aru jitia tai utu koi dise, tai roti loi kene Isor ke dhanyavad dise, aru taikhan khai loise. ");
INSERT INTO nag_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Titia taikhan bhi sob mon dangor hoi kene kha luwa kori loise. ");
INSERT INTO nag_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Aru amikhan jahaaj te thaka khan sob 276 jon asele. ");
INSERT INTO nag_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Karone jitia taikhan kha luwa kora hoise, taikhan jahaaj ke halka kori bole gehu uthaikene samundar te phelai dise. ");
INSERT INTO nag_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Jitia din hoise, taikhan kuntu jagate ase janibole para nai, kintu ekta mati jagah dikhise, aru jahaaj ke ta te loijai kene rakhibole bhabise. ");
INSERT INTO nag_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Titia taikhan longor khan ke samundar te chari dise, aru jahaaj cholai thaka khuri bandi thaka ke khuli dise, aru jahaaj laga kapra khan age phale thaka ke uthaikene hawa pora kinar te loija bole dise, ");
INSERT INTO nag_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kintu jahaaj to jai kene samundar laga duita pani laga takot pora dhuri loise, aru jahaaj matite lagi kene thaki jaise, aru piche phale pani pora mari kene bhangai dise. ");
INSERT INTO nag_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Aru koidi manu khan pani khilikena polai jabo bhoi pora sipahi khan taikhan ke morai dibole bhabise. ");
INSERT INTO nag_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kintu henapoti pora Paul ke bachai dibo mon asele, etu karone taikhan ke rukhai dise, aru jun pani khilibo jane, jap mari kene poila sukha matite jai jabole hukum dise. ");
INSERT INTO nag_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Aru baki khan takhta pora aru kunba jahaaj bhanga tukra pora jabole hukum dise, aru sob bachi kene sukha matite punchise. ");
INSERT INTO nag_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Titia amikhan bachi kene ulai ahise, etu majuli laga naam Malta ase eneka jani loise. ");
INSERT INTO nag_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Aru ta te laga manu khan bhi amikhan ke bisi morom korise, aru pani gira karone bisi thanda thakise, taikhan jui jolai amikhan ke jui thapibo dise. ");
INSERT INTO nag_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kintu jitia Paul khuri mutha uthaikene jui te haali se, ta te ekta saph gorom paikene khuri pora ulaise, aru tai hathte bandhi loise. ");
INSERT INTO nag_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Titia ta te laga manu khan saph tai hathte bandi thaka dikhise aru taikhan majote kotha korise, “Ki hoilebi etu manu morai diya manu ase, tai samundar pora to bachi kene ahise, hoilebi niyom pora taike jinda thakibo nadibo.” ");
INSERT INTO nag_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kintu tai hath hilai kene saph ke jui te phelai dise, aru tai eku huwa nai. ");
INSERT INTO nag_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Kintu taikhan bhabise tai gaw phuli jabo, nohoile giri kene mori jabo. Kintu bisi deri tak sai thaki bole taike eku huwa nai, titia, taikhan laga bhabona alag hoise, aru tai ekta Isor ase bhabona korise. ");
INSERT INTO nag_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Etu jagah usorte Publius koi kene etu majuli laga prodhan cholawta asele, aru etu jaga laga mati bisi laga tai malik thakise, aru tai amikhan ke tai ghor te loijai kene tin-din bhal pora rakhi sewa korise. ");
INSERT INTO nag_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aru eneka hoise Publius laga baba bukhar aru pet-jai thakisele, Paul tai ghor te jai kene Isor ke prathana kori dise, aru tai uporte hath rakhi taike bhal kori dise. ");
INSERT INTO nag_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Jitia eneka hoise, etu dikhi kene utu jaga laga manu khan jun bemar ase sob loi ani bhal hoi kene jaise. ");
INSERT INTO nag_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Aru taikhan amikhan ke bisi sonman dise, aru jitia amikhan ta te pora jabole hoise, amikhan ki-ki lage sob ani jahaaj te rakhidise. ");
INSERT INTO nag_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tin mohina pichete, amikhan Alexandria laga ekta jahaaj te uthi kene jaise, jun thanda dinte ahi ta te thakise, etu jahaaj te “Jurwa Bhagwan” laga nuksa lagikena thaka asele. ");
INSERT INTO nag_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Aru amikhan ahi Syracus sheher te ponchise, aru ta te tin din thakise. ");
INSERT INTO nag_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ta te pora amikhan Rhegium te ghuri ahise, aru ek din pichete dakshin phale pora hawa ahise, aru dusra din Puteoli te punchise. ");
INSERT INTO nag_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ta te amikhan biswasi bhai khan paise aru taikhan kowa karone taikhan logote saat din thaki jaise. Eneka pora amikhan Rome phale jaise. ");
INSERT INTO nag_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Aru jitia ta te biswasi bhai khan Appius Bajar aru Tinta Taverns kowa te amikhan ke lok kori bole ahise. Jitia Paul taikhan ke dikhise, tai Isor ke dhanyavad dise, aru tai mon bhi bisi mon dangor hoise. ");
INSERT INTO nag_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Jitia amikhan Rome te ahi punchise, Paul ke saithaka ekta sipahi logote alag te thaki bole agya dise. ");
INSERT INTO nag_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tin din pichete tai Yehudi laga cholawta khan ke matise. Aru jitia taikhan ahi joma hoise, tai koise, “Bhai khan, ami pora moi laga manu bhirodh te nohoile khandan khan laga niyom bhirodh te eku bhi kora nohoi, hoilebi moike Jerusalem pora bondhi bonai kene Rome manu laga hathte di dise. ");
INSERT INTO nag_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Taikhan huda-hudi kori kene moike chari bole hoisele, kelemane moi pora mori bole laga eku bodnam panai. ");
INSERT INTO nag_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kintu jitia Yehudi khan etu bhirodh te koise, moike Caesar logote anurodh koribo lagise, hoilebi moi nijor jati manu ke bodnam dibole kora nohoi. ");
INSERT INTO nag_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Karone moi apnikhan ke lok kori kene kotha kori bole mati anise, manu khan moike rusi pora bandi rakha to Israel manu laga asha karone ase.” ");
INSERT INTO nag_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Titia taikhan taike koise, “Amikhan Judea pora apuni laga naam te eku chithi bhi pa-a nai, aru bhai khan pora kunbi ahi kene apuni laga eku biya kotha kowa nai. ");
INSERT INTO nag_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kintu apuni laga bhabona ki ase, utu hunibo mon kori ase, kelemane sob jagah etu kotha mana khan bhirodh ase, amikhan jane.” ");
INSERT INTO nag_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Titia taikhan ek din tai logote ahi lok koribo koi kene jai jaise, aru bisi manu tai logote ahi joma hoise, titia tai phojur pora saam tak Isor rajyo laga kotha bhal pora bujhi bo karone Moses laga niyom aru bhabobadi khan laga kitab te likha khan to bhal pora samjhai dise. ");
INSERT INTO nag_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Titia kunba tai laga kotha ke biswas kori loise, kintu kunba to biswas kora nai. ");
INSERT INTO nag_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Titia taikhan majote kotha namila hoise, aru taikhan Paul pora etu kowa pichete jai jaise, “Pobitro Atma he bhabobadi Isaiah pora ami laga baba khan ke thik koise. ");
INSERT INTO nag_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Tai koise, ‘Jai kene etu manu khan ke koi dibi, “Tumikhan huna to huni thakibo, kintu eku bhi nabujhi bo; Aru tumikhan sa-a to sai thakibo kintu eku bhi najanibo. ");
INSERT INTO nag_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kelemane eitu khan laga mon tan hoise Taikhan laga kaan bhi nahune, Aru taikhan suku bhi bondh kori loise. Eneka nohobo lage taikhan suku pora dikhi loi, Aru kaan pora huni loi, Aru mon pora bujhi loi kene ghuri ahile, Moi taikhan ke bhal kori dibo.’” ");
INSERT INTO nag_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Etu karone tumikhan jani lobi, Isor etu poritran laga kotha Porjati khan logote di dise, aru taikhan etu huni lobo.” ");
INSERT INTO nag_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Aru jitia Paul etu kotha koi dise, Yehudi khan apaste kotha namila hoise, aru jai jaise. ");
INSERT INTO nag_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Titia, Paul bhara ghor loi kene dui-saal ta te thakise, aru jun taike lok kori bole ahe, khushi pora taikhan ke grohon kori thakise. ");
INSERT INTO nag_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Aru tai bhoi nakori kene Isor rajyo laga kotha prochar kori aru Probhu Jisu Khrista laga kotha ke sikhai thakise, aru kun bhi taike rukhabole kosis kora nai.");
INSERT INTO nag_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paul, Jisu Khrista laga ekjon noukar, Tai laga basi luwa manu hobole nimite mati luwa aru Tai laga susamachar koi dibole alag rakhi luwa, ");
INSERT INTO nag_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","jun to Tai age din pora bhabobadi khan logot Tai laga kosom to pobitro kotha khan te di dise, ");
INSERT INTO nag_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tai laga Putro dibo nimite kosom diya to, aru kun gaw mangso hisab te David raja laga khandan pora ahise. ");
INSERT INTO nag_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Aru Tai mora pora jee uthi kene Pobitrota laga Atma dwara Tai Isor laga Putro ase eneka hokti pora jonai dise, etu Jisu Khrista amikhan laga Probhu. ");
INSERT INTO nag_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Khrista dwara amikhan anugrah aru apostle hobole paise, aru etu biswas pora kotha mani kene sob desh khan te, Tai laga naam nimite. ");
INSERT INTO nag_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Etu desh khan majote, apnikhan ke bhi Jisu Khrista laga hobole mati kene ase. ");
INSERT INTO nag_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Etu chithi to Rome te thaka sob jonke, Isor pora morom kora khan, jun khan ke pobitro hobole nimite likhise. Apuni khan logot anugrah hobi aru amikhan Baba Isor aru Probhu Jisu Khrista pora anondo hobi. ");
INSERT INTO nag_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Shuru te, moi apnikhan nimite Jisu Khrista dwara Isor ke dhanyavad di ase kelemane apuni khan laga biswas to duniya laga sob jagate prochar kori ase. ");
INSERT INTO nag_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kelemane Isor moi laga gawahi ase, kunke moi sewa kore moi laga atma pora, Tai Putro laga susamachar nimite, aru kineka moi narokhi kene apuni laga kotha koi ase. ");
INSERT INTO nag_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Moi laga prathana te apuni khan ke yaad kori kene Isor laga itcha hoile ki hoilebi apnikhan usorte ahibo karone moi hodai prathana kori ase. ");
INSERT INTO nag_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kelemane apnikhan ke dikhi bole bisi itcha ase titia apnikhan ke atma te takot hobo nimite atma laga bordan bhag kori dibo. ");
INSERT INTO nag_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Titia amikhan eke logote nijor biswas pora ekjon-ekjon laga atma uthai di thakibo. ");
INSERT INTO nag_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Aru etiya, bhai khan ke etu najani kene thakibo dibole mon nai, moi apnikhan logote ahibo nimite bisi bar taiyar korise, (kintu etiya tak kiba ekta pora moike hodai rukhai thakise), jineka Porjati khan pora ami bhal bijon kati bole paise, thik etu nisena ami apnikhan majot te bhi bhal bijon katibo dibole itcha ase. ");
INSERT INTO nag_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Moi Yunani jati aru dusra desh manu, gyaan thaka aru murkho manu khan sob logote dhar bukhi kene ase. ");
INSERT INTO nag_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Etu karone, Rome te thaka apnikhan sob logote susamachar prochar kori bole moi bisi itcha ase. ");
INSERT INTO nag_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kelemane moi susamachar nimite sorom nakore, kun he etu ke biswas kore taikhan sob nimite etu poritran pabole laga Isor laga hokti ase, shuru te Yehudi khan karone, etu pichete Yunani khan nimite. ");
INSERT INTO nag_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kelemane susamachar te Isor laga dharmikta to biswas pora biswas uporte dikhai di ase, Shastro te eneka likhi kene thaka nisena, “Hosabi, dharmik manu khan biswas pora jinda thakibo.” ");
INSERT INTO nag_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kelemane sorgo pora Isor laga khong adharmik manu khan sob uporte ahi thaka dikhai dise. ");
INSERT INTO nag_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Etu eneka ase kelemane Isor laga ki janikena ase, etu taikhan suku pora dikhibo pari ase. Kelemane Isor nijor pora taikhan ke dikhai dise. ");
INSERT INTO nag_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kelemane suku pora dikhibo napara Tai laga gunn, Tai laga anonto hokti aru sobhab, pura shristi bona din pora sob dikhai dise aru ki bonaise etu pora bujhai dise. Etu karone manu khan pora etiya najane eneka kobo napare. ");
INSERT INTO nag_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Etu eneka hoise kelemane, Isor ke janile bhi, taikhan pora Isor ke kineka mohima koribo lage etu kora nai, nohoile dhanyavad diya nai, kelemane taikhan karone etu bhabona to eku kaam thaka nai aru taikhan laga murkho mon to andhera hoi kene thakise. ");
INSERT INTO nag_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Gyaani ase eneka bhabi kene taikhan murkho hoise. ");
INSERT INTO nag_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Aru kitia bhi namora Isor laga mohima ke mori jabole manu laga protima logote bodli kori loise; chiriya khan, theng pora ja janwar khan aru pet pora ja janwar khan laga murti bonai loise. ");
INSERT INTO nag_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Etu karone Isor taikhan nijor laga letera aru sapha nathaka mon laga itcha te jabole dise, aru taikhan laga gaw to taikhan majote moila kori thaki bole nimite. ");
INSERT INTO nag_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Taikhan Isor laga hosa kotha to misa logote bodli kori dise, aru juntu Isor pora bonaise, etu ke sewa korise, aru sob sristi Bona-Jonke nohoi, jun laga mohima hodai nimite ase. Amen. ");
INSERT INTO nag_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Etu karone, Isor pora taikhan ke mangso itcha laga biya kaam te taikhan ke chari dise, kele koile taikhan laga maiki khan bhi niyom te ki ase etu nohoikena ki nohobo lage etu he itcha korise. ");
INSERT INTO nag_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Etu nisena, mota khan bhi taikhan laga maiki khan logot ki niyom koribo lage etu n