﻿USE sofia;
DROP TABLE IF EXISTS sofia.naf_vpl;
CREATE TABLE naf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES naf_vpl WRITE;
INSERT INTO naf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Am maŋge ŋen maŋge ŋen sokbem kotnepeme Zisas ek Abalaam ma Dewit egegat iŋsokŋit penaŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Âpme Abalaamgat nemuŋaŋ Aisak sokbeye. Aisakgat nemuŋaŋ Zekop sokbeye. Âpme Zekowaŋ nemuŋaŋ Zuda ma meniŋane notnaŋ indambege. ");
INSERT INTO naf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Âpme Zudayet nemuŋanet Pelesmak Zelamak sokbewun. Egetgat mamit Tama. Âpme Pelesiyet nemuŋaŋ Eslon sokbeye. Eslongat nemuŋaŋ Lam sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Âpme Lamgat nemuŋaŋ Aminadap sokbeye. Aminadapgat nemuŋaŋ Nason sokbeye. Nasongat nemuŋaŋ Salimon sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Âpme Salimongat nemuŋaŋ Boas sokbeye. Egat mamaŋ Leap. Âpme Boasiyet nemuŋaŋ Obet sokbeye. Egat mamaŋ Lut. Âpme Obetgat nemuŋaŋ Esi sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Âpme Esiyet nemuŋaŋ Dewit ke amobotnaŋ sokbeye. Dewit egat nemuŋaŋ Solomon sokbeye. Egat mamaŋ ke itnaŋaŋ Yulayayet imbiŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Âpme Solomongat nemuŋaŋ Liaboam sokbeye. Liaboamgat nemuŋaŋ Abaisa sokbeye. Abaisayet nemuŋaŋ Esa sokbeye. Esayet nemuŋaŋ Ziosapat sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ziosapatgat nemuŋaŋ Olam sokbeye. Olamgat nemuŋaŋ Yuzaya sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Âpme Yuzayayet nemuŋaŋ Zotan sokbeye. Zotangat nemuŋaŋ Eas sokbeye. Easiyet nemuŋaŋ Esekaya sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Âpme Esekayayet nemuŋaŋ Manase sokbeye. Manaseyet nemuŋaŋ Amon sokbeye. Amongat nemuŋaŋ Zosaya sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Âpme Zosayayet nemuŋaŋ Zekonayamak ekŋen meniŋane notnaŋ sokbemâbien. Kan keyet Babilon msalen Zuda am indomti indatimti mebien. ");
INSERT INTO naf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ekŋenaŋ met Babilon msalen met tabien ke Zekonaya nemuŋaŋ Sialtisel sokbeye. Âpme Sialtiseliyet nemuŋaŋ Salababet sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Âpme Salababetgat nemuŋaŋ Abayut sokbeye. Abayutgat nemuŋaŋ Elayakim sokbeye. Elayakimgat nemuŋaŋ Eso sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Âpme Esoyet nemuŋaŋ Sedok sokbeye. Sedokgat nemuŋaŋ Ekim sokbeye. Ekimgat nemuŋaŋ Elayut sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Âpme Elayutgat nemuŋaŋ Eliesa sokbeye. Eliesayet nemuŋaŋ Natan sokbeye. Natangat nemuŋaŋ Zekop sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Âpme Zekopgat nemuŋaŋ Zosep sokbeye. Zosep egaŋ imbiŋaŋ Malia wage. Âpme Malia egaŋ maneti Zisas ambege. Nin eget kwitnaŋ Mesaya kukuyelen. Ningalen zeleset Kawawaŋaŋ Zisas ombempeme nin yomengatnan timkwatndendeyet an sokbein. ");
INSERT INTO naf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","An sokbemkwebienen kalakumann maŋge tuk kapigok benak. Abalaamagengatnaŋ Dewitmagen kwadelaŋ peinen an maŋge sokbemkwapme 14 kogok beye. Ma Dewitmagengatnaŋ Babilon msalen mka katikŋan indatmebienen kogogak an maŋge 14 sokbewien. Ma Babilon mka katiknaŋgatnaŋ Kilasmagen kwazinen kogogagak an maŋge 14 sokbewien. ");
INSERT INTO naf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Zisas Kilais sokbeye keyet yaŋaŋ kapigok penaŋ tazin. Mamaŋ kwitnaŋ Malia. Egat apmaŋ Zosep ewe an zapatnaŋ etaŋ zempeme igak igak manepemalu Emetak Teŋaŋ menok mme Malia ek nemba kambakmak tage. ");
INSERT INTO naf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kegok mme an zapatnaŋ Zosep ek mama mimiŋaŋ dolakŋaŋ maŋgeyepmti keŋanŋegak kapigok otnâŋge, “Neŋ zetnaŋ sosok zema sakambuk temaŋ tisemgat belak buzak katipemti mebap.” Kegok nâŋge. ");
INSERT INTO naf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kegok mimiyelen nâmti manepeme Amobotnaŋgalen ensel ŋenaŋ mulugen sokbemsamti kapigok dunduye. “Zosep, geŋ Dewitgat guluk galakŋaŋ, imbindi Malia wawagat yayaŋ ku msenik. Nemba kambakmak tazin ke Emetak Teŋmagengatnaŋ. ");
INSERT INTO naf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nemba atam mbe kwitnaŋ Zisas kuwanik. Kwit keyet yaŋaŋ, Egaŋ ikŋaŋ amŋane yomengatnaŋ indatim kwabe.” ");
INSERT INTO naf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kwitnaŋ kwitnaŋ sokbeye ke golaŋ zenze an ŋenaŋ eweŋan Amobotnaŋ Kawawaŋgalen Zet Itnaŋanen kapigok zeye, ke penaŋaŋmak bembeyelen sokbeye, ");
INSERT INTO naf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nâip, imbi nembip ŋenaŋ nemba kambakmak tati nemba ambebe. Âpme anemba keyet kwitnaŋ ‘Imanuel’ kuwep. Imanuel kwit kapiyet ningalen zeleset yaŋaŋ Kawawaŋ ninmak main.” ");
INSERT INTO naf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Âpme Zosewaŋ mulugengatnaŋ wati Amobotnaŋgalen ensel egalen zetnaŋ gawepumti Malia mkaŋan wati moge. ");
INSERT INTO naf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mobunaŋgut awembiŋ mama ke ŋen ku mambun. Belak imbiŋaŋ kekenemuŋ penaŋ tetimti manepeme nemba ke sokbeme Zosewaŋ kwitnaŋ Zisas kuye. ");
INSERT INTO naf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Elot ek amobotnaŋ mame kan keyet Zisas Beteleem mkaen Zudia msalen sokbeye. Âpme kan keyet kasup kwakwatnaset an notnaŋ Zelusalem mkaen kwati am pigok indayaŋkwesiwien, “Zuda am ingalen Amobotnaŋ alakŋaŋ sokbeye. Ek mka deset tazin? Nin msatnan beŋan daengatnaŋ okak sokbembeyelen wenzim busatnaŋ ekti pedondom sesewatpesâgât takotnup.” ");
INSERT INTO naf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kegok zeme amobotnaŋ Elot ma Zelusalem mka toŋaŋ ekŋenaŋ ilinsakwep zet ke nâmti endilipewien. ");
INSERT INTO naf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Âpme Elot egaŋ sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda an ekŋen ondekindemti pigok indayaŋkwesiye, “Kilais pe msat deset sokbembeyet zenzeŋaŋ ze? Zeme nâne.” ");
INSERT INTO naf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Âpme ekŋenaŋ kapigok dunduwien, “Beteleem mkaen Zudia msalen sokbewe. Golaŋ zenze an ŋenaŋ kapigok kuye, ");
INSERT INTO naf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Beteleem mka Zudia msalen tadik geŋ Zuda am ekŋenaŋ mka tototnaŋ yek. Mka ŋotekŋaŋ temaŋ. Geŋmagen An ŋen temaŋ sokbemti Islael aminne indikdamuŋ mbe.’” ");
INSERT INTO naf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Zet kegok zeme nâmti Elot egaŋ an ekŋen beŋangatnaŋ kobien ekŋen ke buzakset indamandamti wenzim zukŋan sokbeye keyet yaŋaŋgat indayaŋkwesime yaŋaŋ dunduwien. ");
INSERT INTO naf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dundume nâmti, Beteleem mkaen meeegat nâmindemti pigok zeye, “In meti windeŋaŋ mti aikti kot nâgât zeme nâmti neŋ kegogak meekti pedondom samti sesewatpesap.” Dâsuki kogok zemindeme mebien. ");
INSERT INTO naf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Amobotnaŋaŋ kegok diindome toti meti selen mepme mkaŋinan wenzim ekbien keyaŋ ewe ŋeŋaŋ bemindap meti Zisasiyaŋ mka weŋge keyet dukŋan wenzimaŋ kaliŋaŋ atam tage. ");
INSERT INTO naf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Âpme ekŋenaŋ wenzim ekti keŋ oloŋen igagen mbien. ");
INSERT INTO naf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mti mka keŋan moti nemba ma mamaŋ Malia idikti nemba pedondom samti zemsesewatpewien. Mti milawat boŋgisiŋin mâtâti gol ma kwitnaŋ kwitnaŋ sesikŋaŋ dolakŋaŋ tosaŋaŋ temaŋ ke timti taolet msawien. ");
INSERT INTO naf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Âpme Kawawaŋaŋ kieset zemkulumindemti zeye, “In Elotmagen set mebepiŋ.” Kegok zemindeme set ŋenieset meti msalinan pataŋ zewien. ");
INSERT INTO naf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ekŋenaŋ gilik zem mepme An Temaŋgalen Ensel Zosep mulugen sokbemsamti pigok dunduye, “Geŋ wati imbi nembandi idatimti Izip msalen meti nâlen zetgat damuŋ manepeme neŋ zemaŋgut nâmti kobep. Nânik, Elot ek nemba timati aikti kusât tazein.” ");
INSERT INTO naf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Zeme Zosep egaŋ tambuyet penaŋ wati imbi nembaŋaŋ time Izip msalen kunzuŋ mebien. ");
INSERT INTO naf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kwitnaŋ kwitnaŋ kegok sokbeme Amobotnaŋaŋ golaŋ zenze an ŋeniyet zet zeme nâmti meluwaŋ pigok mge ke penaŋaŋ sokbeye, “Nemun Izip msalen met manepeme neŋ kumtetima gilik zemti kobe.” ");
INSERT INTO naf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","An kasup kwakwatnaset kobien, ekŋenaŋ Kawawaŋaŋ zemâtâtindame nâmti set butnaset mepme amobotnaŋ Elot egaŋ tapme beme pigok nâŋge, “An ekŋen pi tetimnemti butnaset melo.” E nâmti ŋeŋaŋ penaŋ zime an kobien ekŋenaŋ nup kan zut keyet keŋan sokbeme ekŋenaŋ zeme nâŋge keyepmti kasa kuku an zemindeme Beteleem mkaen meti mka isikŋan eyo tokwati anemba okak nup kanŋin zut ma keyet kandaŋan tozin ekŋen indome delaŋ zemâge. ");
INSERT INTO naf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Âpme kan keyet golaŋ zenze an Zelemaiayaŋ zet pigok zeye ke penaŋaŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lema mkaen Zuda msalen kwisak temaŋ sokbein. Nembaŋine sambe penaŋ gakimâpme keyepmti Islael nemba mamine ekŋen sume delaŋ zeme am ekŋenaŋ keŋin mme sewakŋaŋ bembeyet olalip.” ");
INSERT INTO naf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Zosep imbi nembaŋaŋ ekŋen ewe Izip msat mame amobotnaŋ Elot gakime Amobotnaŋgalen ensel ŋenaŋ kie Zosep pigok dunduye, ");
INSERT INTO naf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Geŋ milawat weyaŋ bemti imbi nembandi indatimti Islael msalen ewe melit nemba kume gakikiyet giŋgiŋ mamtan elak gakiye.” ");
INSERT INTO naf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Âpme Zosep egaŋ imbi nembaŋaŋ idatimti Islael msalen ewe kobien. ");
INSERT INTO naf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Gilik zem koti Zosewaŋ zet kapigok nâŋge. Akeleas ek bipmaŋgat munduman amobotnaŋ tati amobotnaŋ mulup Zudia msalen ke met tapm zeme kiŋgage, yaŋgut mulugen Kawawaŋaŋ zet dundume nâmti Galili msaleset meti mka ŋen kwitnaŋ Nasalet ke met mamtemien. Kegok mme golaŋ zenze an ekŋengalen zet ŋen pigok tazin ke penaŋaŋ sokbeye. “Am ekŋenaŋ, ‘Nasalet an,’ zewep.” ");
INSERT INTO naf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kan keyet Zân an tu zululut egaŋ Zudia msalen msat tuŋgupman sokbemkawaŋ bemti mulupmaŋ yaŋbem mmambe am zet pigok diindoye, ");
INSERT INTO naf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kawawaŋgalen zemâtâtâtgat katnanen mama keyaŋ kot indaombem tazingat in yomgalen set bekanaŋ bee peme tapme keŋin gilik zeit.” ");
INSERT INTO naf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zânmagen golaŋ zenze an Aizayayaŋ muluwaŋ pigok mge ke penaŋaŋmak bein, “An ŋenaŋ msat tuŋgupman kwizet kapigok takuin, ‘Amobotnaŋgat setnaŋ weyaŋme dolakŋaŋ ma kwetetepmaŋ bemti tapme kobe.’” ");
INSERT INTO naf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zân ek kâlâpmaŋ kamel zupmaŋaŋ weyayaŋaŋ mmamtan ma bitim ŋen pemanen zam mamtan. Meuŋaŋ didikŋaŋgatnaŋ bizik tuŋaŋ ma gwidek ke etaŋ nimti mamtan. ");
INSERT INTO naf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Âpme am sambe Zelusalem mka temaŋmak mka isisikŋaŋ ekŋen Zudia am ondekti ma Zodan Tu nembet timat butnaŋ butnaŋ Zânmagen kopmâti ondekbien. ");
INSERT INTO naf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mti yomin zemsokbeme Zânaŋ Zodan tuyen tu zulutindeye. ");
INSERT INTO naf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Âpme Palisi ma Sadusi ekŋenaŋ kegogak tu zulusâgât kopme kapigok diindoye, “In nombeyelen alikŋaŋ. In kapi Kawawaŋaŋ yominaŋgat dopmaŋ mutumindasâgât tapm ke walabep bein? Yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","In mama mimi dolakŋaŋ mme keyaŋ in yomengatnan keŋin gilik zewien ke sokbemkawaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","In keŋinan kapigok ku otnâit, ‘Nin Abalaamgat insokŋane manup keyepm Kawawaŋaŋ ku zemndowe.’ Neŋ pigok diindoma nâit, zet ke belakŋaŋ etaŋ. Kawawaŋ egaŋ zenak beme ke ŋep zeme nanzaŋ ekŋen kapiyaŋ Abalaamgat alikŋane bewiek.” ");
INSERT INTO naf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kegok zemti zet zapat sesepmaŋ ewe tusum pigok zeye, “An ŋen ek nâmkiŋpepeŋaŋmak bewe ke tep katnaŋ maelikzin keboŋ. Âpme an nâmkiŋpepeŋepiŋ bewe ek tep sinaŋ memuŋ bemti matozin sepem keboŋ mme ek kapupme tewen ziwe. ");
INSERT INTO naf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Neŋ in yomengatnan keŋin gilik zeme tu etaŋ manzulutindeyap yaŋgut bamnan an kosâpm ek Amobotnaŋ temaŋ windeŋaŋbeŋaŋ kosâpm. Neŋ an tototnaŋ penaŋaŋ; ek keboŋ ke neŋ bukeboŋaŋ elewat temaŋ timpema ŋep ku bewe. Egaŋ ikŋaŋ Kawawaŋgalen Emetak Teŋ mulupmaŋ tep manzinok yom zime kwetetepmaŋ mambein kemak temakwep zulutindewe. ");
INSERT INTO naf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Egaŋ omkakalili takasetnaŋmak takozinaŋ wit omkakalimti mwapme tâgâyaŋ kumti sekŋaŋ maŋge ŋen ma wit penaŋ maŋge ŋen bewe. Mti wit penaŋ time mkaŋan mowebe sekŋaŋ ulume tep katikŋan monzimti manzimopmambe. Keyet yaŋaŋ am nâmkiŋpepeŋinmak time maŋgeŋen mopme am nâmkiŋpepeŋinpiŋ time maŋge ŋen mobep.” ");
INSERT INTO naf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kan keyet Zisas egaŋ Galili msalen Zodan tuyen meti Zân egaŋ tu zulutpepeyelen nâmti koge. ");
INSERT INTO naf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Âpme Zân nâme nukŋaŋ beme dunduye, “Neŋ keboŋgat eneyet kot tazenik? Geŋ keboŋaŋ neŋ zulutnemane ŋep benak.” ");
INSERT INTO naf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Zeme Zisasiyaŋ zet kapigok gilik zem saye, “Geŋ alak yayaŋ pematalak. Kawawaŋaŋ mulup zet teŋ penaŋ gaingapmti gawepusenik.” Kegok zeme Zânaŋ nâmti tu zulutpeye. ");
INSERT INTO naf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Âpme Zisasiyaŋ tu zuluti kwapme keyegak kululuŋaŋ ŋandeme Kawawaŋgalen Emetak Teŋaŋ sasakandenombe nemboŋ bemti ekmagen toge. ");
INSERT INTO naf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Âpme kululuŋengatnaŋ zet ŋen kapigok sokbeye, “Kapi nanaŋgat Nemun penaŋ; egat nâmtikŋaŋ omba penaŋ manâmpeyap. Neŋ ek ombempewangapmti am yomengatnaŋ indati kwabe keyet oloŋen miap.” ");
INSERT INTO naf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Âpme Emetak Teŋaŋ Zisas msat tuŋgupman Sadaŋaŋ tetipepeyelen nâmti watmeti ");
INSERT INTO naf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zisasiyaŋ mame kasup 40 ma tambumbu 40 maneti tu meuyet penaŋ gakiwaleletgalen mge. ");
INSERT INTO naf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Âpme Sadaŋaŋ ekmagen koti zeye, “‘Neŋ Kawawaŋgat Nemuŋaŋ’ kok manzenik keyepmti ke penaŋ manik beme zemane nanzaŋ kapiyaŋ meu sokbeme ŋep nsenik.” ");
INSERT INTO naf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kegok zeme Zisasiyaŋ kapigok dunduye, “Kawawaŋgalen zet meluwaŋ itnaŋanen kapigok kukuŋaŋ tazin, ‘Amnaŋ keŋin tu meuyet etaŋ bemti ku mamayelen. Yek penaŋ. Zet kwep kwep Kawawaŋmagengatnaŋ kozin ke keŋinan mkipmaŋ bembeyelen.’” ");
INSERT INTO naf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kegok zeme Sadaŋaŋ Zisas naman wati Zelusalem sesewat mka temaŋ dukŋan wapmotati ");
INSERT INTO naf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kapigok dunduye, “Geŋ Kawawaŋgat Nemuŋaŋ manik beme kapiyetnan palam towepmane zet meluwaŋ ŋen kapigok tazin ke nânik, ‘Kawawaŋaŋ enselŋane ekŋengat belinan geme ekŋenaŋ belen gatam topme nanzaŋaŋ sedi ku aaŋgalen.’” ");
INSERT INTO naf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zeme Zisasiyaŋ kapigok dunduye, “Yaŋgut Kawawaŋgalen zet meluwaŋ itnaŋanen zet ŋen kapigok kukuŋaŋ tazinegek, ‘Kawawaŋ Amobotnaŋdi yaŋaŋ ku mim ekbanik.’” ");
INSERT INTO naf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Kegok zeme Sadaŋaŋ kalaŋ teepmaŋ ŋengat watmotati msat sambeyelen kwitnaŋ kwitnaŋ dolakŋaŋ sepem igak igak ke zikat samti zeye, “Geŋ pedondom namti dundum namane kwitnaŋ kwitnaŋ sambe ke ekdik beke gâlen belen bepema damuŋ mmambanik.” ");
INSERT INTO naf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Âpme Zisasiyaŋ kapigok gilik zem zeye, “Kawawaŋgalen zet meluwaŋ itnaŋanen zet ŋen kapigok kukuŋaŋ tazin, ‘Kawawaŋ Amobotnaŋdi etaŋ pedondom samti dundum sawanik ma ek kwewetaŋ sisiliŋ msamti mambanik.’ Sadaŋ, geŋ nemti met.” ");
INSERT INTO naf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kegok zeme Sadaŋaŋ pemti mege. Âpme Kawawaŋgalen ensel ekŋenaŋ koti mukulem mpewien. ");
INSERT INTO naf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zân mka katikŋan peme tapme Zisasiyaŋ zapatnaŋ nâmti Galili msalen mege. ");
INSERT INTO naf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mti egaŋ Zudia msat peme tapme Galili msalen meti mkaŋaŋ ŋotakŋan Nasalet ke met tabi tabi mineti peme tapme naman Kapaneam mkaen mege. Mka ke Galili tunduamak msat zut Zebulanmak Naptalai keyet sokŋanik ke matatan. ");
INSERT INTO naf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kegok mme golaŋ zenze an Aizaya egaŋ Kawawaŋgalen Zet Itnaŋanen zet ŋen kapigok kukuŋaŋ ke katikŋaŋ beye, ");
INSERT INTO naf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Am Zebulan msaleset ma Naptalai msaleset mamaip ekŋenaŋ Galili tundua lemunaŋ temaneset mamaip. Am Zuda maŋgeen ku sokbembeŋaŋmak lumaŋti kileŋ mamaip. Sambe beke tambusosok temaŋ keŋan mamaip ekŋenmagen busatnaŋaŋ sokbemindawe. Am waleletgat zapat mamaip ekŋen kemagen busatnaŋ sokbembeyelen.” ");
INSERT INTO naf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kan keyet Zisasiyaŋ Zet Zapat Dolakŋaŋ zemti am kapigok yaŋbem diindoye, “Kawawaŋgalen zemâtâtâtgat katnanen mamayelen kan ilak kolapgat yomengatnan keŋin gilik zeit.” ");
INSERT INTO naf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Âpme kasup ŋeniyet Zisas egaŋ Galili Tundua keyet nelum palen mepmambe an zut dapmeniŋ idige ŋen Saimon egat kwitnaŋ ŋen Pita ma datnaŋ Endulu. Egelaŋ tunduaen eleŋgolamit pemti tapmambun. Egegat muluwit ŋotekŋaŋ aŋgala titi. ");
INSERT INTO naf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Eget ke idikti zeye, “It kopmalu neŋmak meti neŋ naman am indatitiyelen mulup ke neŋmak tusumti indandayelen zikat idawap.” ");
INSERT INTO naf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Zeme keyegak eleŋgolamit mee pemalu tapme Zisasmak tusum mebien. ");
INSERT INTO naf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Âpme belaknik meti an dapmeniŋ ŋen ewe idaige Zems ma meniŋaŋ Zân. Eget Zebediyet nembaŋanet. Biwitmak waŋgaŋinan tati eleŋgolamin taweyaŋmambien. ");
INSERT INTO naf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Idikti Zisasiyaŋ idakumtetime eleŋgolamit mee ma biwit pemti Zisasmak tusum mebien. ");
INSERT INTO naf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Âpme Zisas ek Galili msat toweti sesewat mka kataŋ mototi am Zet Zapat Dolakŋaŋ diindomti Kawawaŋgalen zemâtâtâtgat katnanen mama keyet zapatnaŋ diindoye. Mti am zawalin sepemaŋ igak igak ke mme alik bemâbien. ");
INSERT INTO naf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kegok mme kwit zapatnaŋ Silia msalen palakŋaŋ beme nâmti am zawat sepemaŋ igak igak sek sindemak ma we bekanaŋinmak ma gakim wat gakim wat mamip keboŋ ma selin belin selauuŋaŋ ekmagen indatim kopme weyaŋindemâge. ");
INSERT INTO naf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Âpme Galili msalengatnaŋ ma Dekapolas mkaengatnaŋ ma Zelusalem mkaengatnaŋ ma Zudia msalengatnaŋ ma Zodan tu nembet daeset am maŋge temaŋ penaŋ ondekti ekmak tasât mebien. ");
INSERT INTO naf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Zisasiyaŋ am sambe penaŋ indikti kalaŋ dukŋan mot totapme nembaŋaneyaŋ met egat kandaŋanen totapme ");
INSERT INTO naf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Zet Zapat Dolakŋaŋ kapigok zemzikat indaye, ");
INSERT INTO naf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Am ilinaŋgat yominaŋgat nâme kembeŋ mambein ma ilin keŋin mtoti mamaip ekŋen oloŋen mip ma bamgat ekŋen keyaŋ mundum kululuŋen toŋaŋ bewep. ");
INSERT INTO naf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Am yominaŋgat keŋinan Kawawaŋ masumsaip ekŋenaŋ oloŋen mip. Am ekŋen ke Kawawaŋaŋ yomin katipeme keŋin sewakŋaŋ penaŋ mambein. ");
INSERT INTO naf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Am ilinaŋgat sekŋin mamtolip ekŋen ke oloŋen mip. Ekŋen ke Kawawaŋgalen zemâtâtâtgat katnanen mama aikbep. ");
INSERT INTO naf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Am mama mimi teŋ Kawawaŋaŋ indandayet windeŋaŋ mamip ekŋen oloŋen palen talip. Bamgat Kawawaŋaŋ winde igagen penaŋ indawe. ");
INSERT INTO naf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Am olat olat palen mame maindamukulem mimindep ekŋen oloŋen palen maip. Ekŋen ke Kawawaŋaŋ sepem kwep kegogak mimindawe. ");
INSERT INTO naf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Am keŋinangalen yom Kawawaŋaŋ katikpepeŋaŋ ekŋen oloŋen palen maip. Am ekŋen keyaŋ kululuŋen moti Kawawaŋgat zimosetnaŋ eksâip. ");
INSERT INTO naf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Am kalalaŋaŋ mme keŋ kwep mambeip an ekŋen ke Kawawaŋaŋ keŋin mme oloŋen palen talip. Bamgat Kawawaŋaŋ, ‘Nemunambanne,’ zemindewe. ");
INSERT INTO naf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Am Kawawaŋangat zikatnan teŋ mame notnaŋaŋ nâmbekam bemindemti sisipeŋpeŋ mti maindop ekŋenaŋ oloŋen palen maip. Ekŋenaŋ kululuŋen mundum ke met tiwep. ");
INSERT INTO naf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","In neŋmak tusumti mame keyepmti amnaŋ zet mgasik diindomti zet dâsuki bemzenze sambe sekŋinan bemzemti sisipeŋpeŋ penaŋ mamimindeip. ");
INSERT INTO naf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","In maneti nukŋaŋ maindaip keyepm oloŋen mit. Wa ke in etaŋ yek. Golaŋ zenze an eweŋan tipman baen mamkwabien ekŋen sisipeŋpeŋ sepem kegogak mimindamkwabien keyepm webeit tosaŋin kululuŋen gwaen motiwep. ");
INSERT INTO naf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Msalen am mamaip ekŋenmagen mama mimiŋin dolakŋaŋ dalaŋ keyet sepemnok beme mambep. Dalaŋ ke yaŋaŋ kapigok, dalaŋaŋ meuyen pemann meu mme tikŋaŋ mambemâzin. In dalaŋnok kwati am mama mimiŋin mme tikŋaŋmak beme amnaŋ nâmtikŋaŋ mbep. Âk dalaŋaŋ tikŋaŋ maasekzin sepem kegogak in nâmkiŋpepeŋin asekmâbe beme in Kawawaŋgalen Zet Zapat Dolakŋaŋ ku mâbep. Egaŋ zemindeme zupman toweti sakamaŋ dalaŋ bekanaŋ timtati selen time mepme amnaŋ mekoti selaŋ maim enzeŋip in sepem keboŋ bewep. ");
INSERT INTO naf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Amnaŋ lam koŋbemti menzimaŋ dukŋan ku makwalapeip. Ekŋenaŋ lam koŋti munduman sosok bempeme tapme am mka keŋan matalip bee mbusatnaŋ mambemindein. In sepem kegok kawaŋ sutnan tati am msat sambe mbusatnaŋ bemindeme ekŋen Kawawaŋgalen zapat sokbewep. Mka ŋande temaŋ ŋen kalaŋ sutnan belak kawaŋan tapme kwileki ŋenaŋ ku mautukekzin. ");
INSERT INTO naf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Keyepmti in mama mimiŋin dolakŋaŋ lamnok ke belak peme kawaŋan busatnaŋaŋ busatnaŋ bem talep keyepm am ekŋenaŋ busatnaŋin ke ekme dolakŋaŋ beme ekŋenaŋ ingat Biwin kululuŋen tazin sesewatpewep. ");
INSERT INTO naf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","In zii zet ma golaŋ zenze an ekŋengalen zet ke aseksâgât kolap nâgât kegok ŋen zewiegat. Neŋ zet ke aŋgososoyelen yek. Zii zet keyet yaŋaŋ penaŋ zemzikat indasât koban. ");
INSERT INTO naf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Neŋ penaŋ diindoma nâit, msat ma kululuŋ tazin kataŋ zii zelaŋ wemti mulupmaŋ mbe ma zii zet mulupmepiŋ belak ku tabe. Ke penaŋaŋmak etaŋ bemâbe. ");
INSERT INTO naf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Keyepmti am ŋenaŋ zii zet belaknik bugan aŋgosop ma notnane zikat indame zii zet aŋgososoyelen min an ke ek Kawawaŋgalen zemâtâtâtgat katnanen mama ke ku map. Naman am ŋenaŋ zii zet gawepumti notnaŋne ke mimiyet zemzikat indawe egaŋ Kawawaŋgalen zemâtâtâtgat katnanen mama keyet keŋan mambe. ");
INSERT INTO naf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Neŋ pigok diindoma nâit, ingalen zii zet gawepum mama keyaŋ zii zet zikat indanda anmak Palisi ekŋen bugan meti sebemindesem. Yek bein beme in Kawawaŋgalen zemâtâtâtgat katnanen mama ke keŋan ku tabep. ");
INSERT INTO naf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yeŋ sokŋineyet zet kapigok diindondoŋaŋ, ‘Geŋ am ku indomane gakiwep. Am ŋenaŋ kegok mbe beme zet muluwen motabe.’ ");
INSERT INTO naf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Zet ke penaŋ keyaŋgut neŋ tusumti pigok diindoma nâit, Am ŋenaŋ notnaŋ ŋenzinziŋ msawe beme an ke zet muluwen wati mebep. Ma ŋenaŋ notnaŋ zemkwelat kuwe beme an ke sesewat mka temaŋgalen an damuŋ ekŋengalen ondedagen onzempewep. Ma ŋen egaŋ notnaŋ ŋen, ‘Kopa belakŋaŋ penaŋ,’ dundumti mtopewe beme an keboŋ ke teziŋ ŋandaŋgat zapat bewe. ");
INSERT INTO naf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Keyepm geŋ Kawawaŋ sesewatsasâgât meti naman kapigok nâmbanik, ‘O neŋ notn kaindeyaŋ nâgât nâmbekam bembeŋaŋ tazin.’ ");
INSERT INTO naf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Kegok nâmbanik beme geŋ gilik zemti ekmagen meti nâmbekam bembeŋit zemkwetetepmaŋ mtiŋgut kot sesewatpewanik. ");
INSERT INTO naf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kegogak geŋ nodi ŋengalen kwileki ŋen dopmaŋ sasayet zemti mbanan yaŋ sasapiŋ mane pemane egaŋ geŋ zet muluwen gati mebe beme geŋ zet muluwen ewe mobopiŋ selen mepmambe nodi kemagen sakwep meti zelit weyaŋbalup. Kegok ku mbanik beme nodi keyaŋ sakwep moti zet muluwen geme zet tiyape yape mmane zet nânâyelen an keyaŋ tipdak kutum ekŋen zemindeme ekŋenaŋ kot gatamti met mka katikŋaŋ geme towebanik. ");
INSERT INTO naf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Neŋ penaŋ diŋgoma nâmbak, geŋ ke tatneti belak penaŋ ku tobanik, nodaŋgalen dopmaŋ mutumane delaŋ penaŋ zemeŋgut tobanik. ");
INSERT INTO naf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","In Kawawaŋgalen zii zelaŋ pigok mandiindome nâip, ‘In am ŋengalen imbi ma an eyak mti set buzak ku indatmambep’. ");
INSERT INTO naf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Zet ke penaŋ keyaŋgut neŋ naman tusumti ingat pigok diindoma nâit, an ŋenaŋ ŋengat imbiŋaŋ keŋanen eksegat mti egaŋ imbi ke menzem wawagat keŋaŋ etaŋ otnâmbe beme egaŋ ilak zii zelaŋ an notnaŋgat imbiŋaŋmak ku weweyet zewenn kelak imbi kemak wep. ");
INSERT INTO naf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Keyepmti zikadi ŋenaŋ bekanaset gatetimti mesât mbe beme geŋ kwenzempemane mebe. Mineti geŋ zikadi zuzulak tagame maneti teziŋ ŋandaŋ towebanikgat kwenzempemane mebe. ");
INSERT INTO naf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bedi ŋenaŋ yomeset gatetimti mesât mbe beme geŋ atumti pemane mebe. Mineti geŋ bedi zuzulak tagame maneti teziŋ ŋandaŋ towebanigat ŋen eleŋgemti pemane mebe. Yaŋaŋ kapigok, kwitnaŋ kwitnaŋ bekanaset gatetimti mesât mme katikpemane tapme mamaset pembenaŋ ke mobanik. ");
INSERT INTO naf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kawawaŋgalen Zet Itnaŋaŋ pigok zemti mkwabien, ‘Ŋen ek imbiŋaŋ katipesâgât nâin beme meluwaŋ asekpepeyelen kumti, “Asegeyap,” zempeme mametan.’ ");
INSERT INTO naf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yaŋgut neŋ alak ingat naman pigok diindoyap: An ŋen imbiŋaŋaŋ an ŋenmak set kileŋ kumame egaŋ nâmbempemti imbiŋaŋ belak etaŋ asekpewe beme an keyaŋ yom temaŋ penaŋ mbe. Imbi keyaŋ apmaŋ ewe tapme egaŋ meti an ŋen wabe beme imbiŋaŋaŋ set kileŋ imbi keboŋ bein. Ma an ŋenaŋ imbi apmaŋ asekpemti main ek ke wabe beme an keyaŋ set kileŋ an keboŋ bein. ");
INSERT INTO naf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yeŋsokŋine zet kapigok diindondoŋaŋ ke nâip, ‘In zet zemkatikbembe Amobotnaŋ egat kwitnaŋen kuwep beme e ewe ku asekbep. Ke gawepuwep.’ Yaŋgut in kwileki ŋen zemkatik besâti msatgat palen kumti manzemkatik beip. ");
INSERT INTO naf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kegogapm neŋ naman ingat pigok diindoyap, zelin zemti ku bandim mbep. Kululuŋ ek Kawawaŋgalen mundum totatat kululuŋgat kwitnanen kumti ku bandim mbep. ");
INSERT INTO naf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Msat e Kawawaŋgalen setnaŋgalen wetnaŋ bemti maim tazin keyepm msat kwitnaŋ kumti ku bandim mbep. Zelusalem ek Amobotnaŋ temaŋgalen mka temaŋ keyepm Zelusalem kwitnaŋ kumti ku bandim mbep. ");
INSERT INTO naf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sepem kegogak windeŋin ku tazin keyepm in ŋokŋinan bem zemti zemkatik bembe e kegogak ku mbep. ");
INSERT INTO naf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘Yek’ beme nâmti, ‘Yek,’ zewanik. ‘Penaŋ’ beme nâmti ‘Penaŋ,’ zewanik. Zet nânâpiŋ kileŋ bandim mimipiŋ; zet penaŋ etaŋ manzemmambanik. ");
INSERT INTO naf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Zet ŋen kapigok zenzeŋaŋ ke nâit, ‘Ŋen egaŋ zikadi âtâgeme geŋ dopmaŋ egalen âtâpewanik ma ŋenaŋ zedi kume etume geŋ dopmaŋ egalen kumane etuwe.’ ");
INSERT INTO naf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Keyaŋgut neŋ naman pigok diindosowap, am ŋenaŋ in kwileki ŋen myuŋgumindawe beme in naman sepem kegogak ku msawep. Ma am ŋenaŋ neŋgumdi nembet taiwe beme naman in gilik zemti neŋgumin nembet sawep. ");
INSERT INTO naf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma am ŋenaŋ geŋmak kasa kasa mti zet nânâ mkaŋan gapmesât min beme sakwep penaŋ zelit weyaŋselup. Mti egaŋ gâgât tosa zet mgamti, ‘Kogok nasenik’ zeme geŋ mukulem mti bugan moti sawanik. ");
INSERT INTO naf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma am ŋenaŋ geŋ gati milawatnaŋ timti selen belatnik mebegat zekaŋkaŋ mgawe beme geŋ naman ekmak sasukwep mebanik. ");
INSERT INTO naf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma am ŋenaŋ kwileki ŋengat olati wekumgame geŋ ku bamkumpewanik zein keyet kataŋ nâmpewanik. ");
INSERT INTO naf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Zet ŋen kapigok zenzeŋaŋ ke nâip, ‘Geŋ nodi gogot mpewanik ma kasandi kasa mpewanik’. ");
INSERT INTO naf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Keyaŋgut neŋ naman ingat pigok zeyap, In am kasaŋine ekŋen gogot mimindewep ma am sisipeŋpeŋ mamimindaip ma maindoip ekŋengat nâmti Kawawaŋgat dunduwep. ");
INSERT INTO naf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kegok mti kululuŋ Biwinaŋgat nemunambaŋane penaŋ bemti mambep. Egaŋ ikŋaŋ kasup bempeyeyaŋ am pembenaŋ ma bekanaŋ ilinsakwep mambusatnaŋ bemindein. Ma map kegogak am teŋ ma yominmak ekŋengat temakwep mme matozin. ");
INSERT INTO naf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","In am notnaŋ ekŋenmak gogot palen mamaip ekŋen etaŋ taolet mimindamti mambep. Kegok mbep beme ke Kawawaŋaŋ keyet dopmaŋ ku indawe. An takis mânep titi bekanaŋ mamaip ekŋenaŋ nolineyet sepem kegogak mamip. ");
INSERT INTO naf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","In am nolin ekŋenmak notn notn mti zezapat mamip beme keyaŋ sepemaŋ igak penaŋ ku bein. An Kawawaŋ ku nâmkiŋpeip ekŋenaŋ sepem kegogak mamip. ");
INSERT INTO naf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","In Biwin kululuŋen egaŋ teŋ main kegogak teŋak mamambep. ");
INSERT INTO naf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","In Kawawaŋgalen mulup dolakŋaŋ notnaŋ mti keyet nâmti am sambe ekŋengat zikalinan sekŋin mmobep beme kululuŋ Biwinaŋ keyet dopmaŋ ku indawe. ");
INSERT INTO naf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Keyepmti in am ŋen kwileki ŋeniyet olapme kwileki ŋen saip beme keyet zapatnaŋ zemti sekŋin ku mmobep. Am notnaŋ sek mmobot mamip ekŋenaŋ sesewat mkaen ma ondedak mundumen tokwati amnaŋ sekŋin mmobogat nâmti mulup mimiŋaŋ keyet zapatnaŋ manzemelip. Neŋ pigok diindoma nâit, am ekŋen keboŋ ke muluwinaŋgat tosaŋaŋ eweŋanak msalen kapiyegak matime delaŋ zein. ");
INSERT INTO naf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sepem kegok tazingapmti in am ŋen olapme kwileki ŋen mukulem mpewep beme mulup mbep keyet zapatnaŋ nolin penaŋ sokŋaŋ tabe ke ku nâmbe. ");
INSERT INTO naf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","In belak kogok enzililiŋan ke peme tapme Biwinaŋ kwitnaŋ kwitnaŋ enzililiŋan maekzin egaŋ ke ekti muluwin dolakŋaŋ mbep ke ekti keyet tosaŋaŋ indawe. ");
INSERT INTO naf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","In dundusâgât an sek mmobot maip ekŋenaŋ mamip kegok ku mbep. Ekŋenaŋ sesewat mkaen ma ondedak mundumen belak motati dundume am ekŋenaŋ indiktemtem mimindendeyet nâmti kegok mamip. Neŋ penaŋ zema nâit, am ekŋen keboŋ ke tosaŋin ilak kapi matime delaŋ zein. ");
INSERT INTO naf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Keyepmti in dundusât nâmti mkaŋin keŋan mot sekek tati Biwin enzililiŋan main ekmagen buzak dundum sawep. Âpme Biwin kwitnaŋ kwitnaŋ enzililiŋan eknâm maminaŋ keyet dopmaŋ indawe. ");
INSERT INTO naf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","In dundusâti belak zet omaiŋ maiŋ sambe mti ku dunduwep. Dundundu keboŋ ke am Kawawaŋ ku manâmkiŋpeip ekŋenaŋ dunduŋin teepmaŋ penaŋ mamip. Ekŋenaŋ pigok manâip, ‘Zet sambe zem toto kwakwat mmann ŋep nâmindesem,’ zemti mandunduip. ");
INSERT INTO naf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Keyaŋgut in ekŋenaŋ mamip kegok ku mbep. In Biwinaŋgat ewe dundundupiŋ mme egaŋ in kwitnaŋ kwitnaŋgat olalip e eweŋanak egaŋ nâmtapmeŋgut in mandunduip. ");
INSERT INTO naf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Keyepmti in kapigok zemti dunduwep: ‘Ningat Bipm, Geŋ kululuŋen mamanik. Nin gâgât kwidi mmotnuwen kogogak am sambeyaŋ mmobotgat dundunup. ");
INSERT INTO naf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Geŋ kot nin am sambe ndadamuŋ mi. Kululuŋen gwaen gâlen zetgat kandaŋan mamaip sepem kegogak nin msalen pienen gâlen zedaŋgat kandaŋan mamayet nin diŋgoganup. ");
INSERT INTO naf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Geŋ alak tu meu nnaŋgat weŋnok niniyet ndasenik. ");
INSERT INTO naf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nin am ekŋenaŋ myuŋgum ndandaŋaŋ makatikpenup sepem kegogak geŋ ningalen yomm katikpe. ");
INSERT INTO naf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yomgalen tetimaemaeyaŋ ndatime ku katikndewanik. Windendi ndamane bekananen ku towebanup.’ ");
INSERT INTO naf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","In amnaŋ yom mimindawien ke katikindewep beme kululuŋ Biwinaŋ kegogak ingalen yomin katikpewe. ");
INSERT INTO naf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma in am ekŋengalen yomin timame kululuŋ Biwinaŋ kegogak ingalen yomin ku katikpewe. ");
INSERT INTO naf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ma in meu zemkulumpemti Kawawaŋgat dundum sesewatsasâgât sesewat mkaen mowetnik beme amnaŋ geŋ meu zemkulumpenak keyet sepemdi ku ekbep. Ekŋenaŋ ŋenzimoselin amnaŋ eekgalen nâmti ku manzululip ekŋenaŋ amnaŋ meu zemkulumpemti tapmamo nâmimindeyet kegok mamip. Neŋ zet zeyawen kapi penaŋ ekŋen ke tosaŋin tim delaŋ zewien. ");
INSERT INTO naf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","In meu zemkulumpeip beme zimoselin zuluti ŋoksiŋin walabep. ");
INSERT INTO naf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mti am notnaŋ ekŋenaŋ in meu zemkulumpemti tapmaip ke ku nâmbep. Mme Biwin enzililiŋan main egaŋ kwitnaŋ kwitnaŋ maekmâtâzinaŋ dopmaŋ indawe. ");
INSERT INTO naf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","In msalengalen kwitnaŋ kwitnaŋ sambe ku akumbewep. Msalen kapi milawat gagak makwazin ma etimbemti matozin ma papalaŋ ime bekanaŋ mambein ma kambu titiyaŋ mka kwaselemti matip. ");
INSERT INTO naf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yaŋgut in kwitnaŋ kwitnaŋ dolakŋaŋ mamambep keyet Kawawaŋaŋ oloŋen mimindewe. Muluwin dolakŋaŋ keyet tosaŋin kululuŋen gwaen ikŋaŋ indawe ke bekanaŋ ku bewe. Ke kwawaŋ ku nimbe ma bekanaŋ ku bewe ma ku etim bewe ma kambu titi anaŋ ku tiwep. ");
INSERT INTO naf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","In kwitnaŋ ŋengat keŋin penaŋ maindembein beme ingat keŋin sekŋin nâmamaŋin peme keyet palen mamepmatim tazin. ");
INSERT INTO naf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","An ŋen ek nâmamaŋaŋ Kawawaŋmagen bemti mamain ek busatnanen mamaingapmti keŋan ma sekŋaŋ busatnanen talip. ");
INSERT INTO naf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mme an ŋen ek nâmamaŋaŋ Kawawaŋmagen ku mambein an ke tembusosogen mamain kegok zenzeyelen. Keyaŋgut, ‘Neŋ ŋep Kawawaŋ mâti mamti naman kwitnaŋ kwitnaŋ msatgalen kogogak timambap,’ an keyaŋ kogok zein beme ek tambusosogen penaŋ tazin. ");
INSERT INTO naf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","An kwewetaŋaŋ amobotnaŋ zut egetgalen sisiliŋ mulup ŋep ku mamin. Ek ŋen gogot mpemti ŋen egat keŋaŋ yeeŋaŋ mambein. Mti ŋenmagen met wetekumti ŋen bamkumpewe. In kegogak Kawawaŋgalen mulup ma mânep milawatmak mama eget temakwep idapepebemti ku mimidadayelen. ");
INSERT INTO naf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Keyet neŋ zema nâit, mamaŋinaŋ mobotnaŋ penaŋ bein, tu meuyaŋ mobotnaŋ penaŋ ku bein. Keyepmti sekŋinaŋgalen tu meu ma sâkmelakanduŋgat yayaŋ ku mbep. ");
INSERT INTO naf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","In tedukŋan gwaen gwasembelembele indigit. Age ekŋen keyaŋ yayaŋ ku mamip. Ekŋenaŋ mmonde onde ma timondakti mka milombiŋinanen ku mambeip. Yaŋgut Biwin Kululuŋen gwaenengatnaŋ etaŋaŋ maaikindame manip. Âpme Kawawaŋgalen nânâen age ekme tototnaŋ mambein ma in mobotnaŋ keyepmti Kawawaŋaŋ indikdamuŋ mamm keyepm yayaŋ mimipiŋ. ");
INSERT INTO naf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma am inmagengatnaŋ kwiyaŋ yayaŋ mti ikŋaŋgat mamaŋaŋ nup kanaŋ butnaŋ ŋep tusumti manak? Am ŋenaŋ kegok ŋep ku mnak keyepm yayaŋ mimipiŋ. ");
INSERT INTO naf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Âpme in kwilekiyet saŋgum melakanduŋgat yayaŋ penaŋ mamip? In tep belaalik msalen wein ke indigit. Ekŋenaŋ ilinaŋgat saŋgum melakanduŋin ma mulup ku mamip. ");
INSERT INTO naf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yaŋgut keyet neŋ diindoma nâit, Solomon ek mânep milawatnaŋ temaŋmak ma miak miakŋaŋ dolakŋaŋ yaŋgut tep belaaligat katnaŋaŋ mamiagip keyet kataŋ ku miage. ");
INSERT INTO naf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Âpme kwaŋ ekŋenaŋ alak taliwaŋ seŋen lalamba kumann memuŋ beme tewen mambumannzin. Ke Kawawaŋaŋ ikŋaŋ elimiakŋin mamiakindein. Âpme egaŋ in saŋgum melakandu ŋep aik indaweyet yayaŋ ku mseip? In nâmkiŋpepeŋin âlâgâlâk, ma? ");
INSERT INTO naf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Keyet in yaŋbemti tu meu ma saŋgum melakandu desetgatnaŋ timambanup zemti yayaŋ mimipiŋ. ");
INSERT INTO naf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ke am Kawawaŋ ku nâmkiŋpeip ekŋenaŋ nânâŋin keyet bempemti matalip. Keyaŋgut Biwin kululuŋen egaŋ in kwitnaŋ kwitnaŋ ekŋen keyet olalip ke ŋep nâmindein. ");
INSERT INTO naf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Keyepmti in naman keŋin sekŋin ketalasime Kawawaŋgalen zemâtâtâtgat katnanen mama keyet kandaŋan mait ma Kawawaŋgalen zetnaŋ kandaŋan mameŋgut keyet palaŋanen tu meu saŋgum melakandu ke indawe. ");
INSERT INTO naf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","In seŋen zigok sokbewe zemti kuluŋ kaluŋ mimipiŋ. Seŋen ninmagen zigok sokbewe ke Kawawaŋgat betnaŋ tazin keyet msasa kwepgat nukŋaŋ Kawawaŋ wekumann ndamukulem mme gapuwanup. ");
INSERT INTO naf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","In am ŋengat mama mimiŋinaŋgat sakwep penaŋ ku manâmbemindemambep. Am zemindowep beme Kawawaŋaŋ in bam zemindowe. ");
INSERT INTO naf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Keyet in am zet zem indondo mbep beme Kawawaŋaŋ in zem indowe. Ma am kwitnaŋ kwitnaŋ mimindawep, sepem keyegak Kawawaŋaŋ naman in mimindawe. ");
INSERT INTO naf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Geŋ eneyet nodaŋgat zikatnan kakalak isikŋaŋ tazin ke ekti naman gitaŋgalen zikadan tep paŋaŋ tazin ke ku eknâmâtâtnik? ");
INSERT INTO naf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tep paŋaŋ gitaŋgalen zikadan tapme ekpemti geŋ zigoset nodaŋgat pigok zemane ŋep bewe, ‘Geŋ nâmane zikadan kakalak tazin ke tim gewi?’ ");
INSERT INTO naf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Geŋ an nambalamdi zut, gitaŋgalen zikadan tep paŋaŋ ke ŋeŋaŋ timpemti bamgat ekmâtâti nodaŋgalen zikatnan kakalak timpemane ŋep bewe. ");
INSERT INTO naf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","In kwitnaŋ kwitnaŋ kambuk Kawawaŋgalen zenup ke tam ku ketalasim indame tamaŋ timti walelip. Ekŋenaŋ kwitnaŋ kwitnaŋ keboŋ ke selaŋ maim enzeŋip. In kegogak Kawawaŋgalen zetnaŋ am nânâyet wisat mamiwen ku diindowep.” ");
INSERT INTO naf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Zisasiyaŋ dundundu mimiyelen nâmti bemzenze zet tuk kapi zeye, “Kawawaŋgat dundum same kwitnaŋ kwitnaŋ indawe. Ma timamat mulup mti penaŋaŋ aikbep. Ma ŋande kesaŋ kume set kwaselemti kwitnaŋ kwitnaŋ indawe. ");
INSERT INTO naf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mandunduiwaŋ kwitnaŋ kwitnaŋ matip. Matimaliwaŋ penaŋaŋ maaigip ma ŋanda kesaŋ makuip ekŋen sekekek kwaselemti kwitnaŋ kwitnaŋ maindain.” ");
INSERT INTO naf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Dundunduyelenak ŋen kapigok zeye, “Ma inmagengatnaŋ am ŋenaŋ nembaŋaŋ meuyet yaŋkwesime, nanzaŋ ku masain. ");
INSERT INTO naf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma aŋgalayet yaŋkwesime nombe kukŋaŋbeŋ ku masain. ");
INSERT INTO naf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","In am bekanaŋ penaŋaŋgut nembaŋin kwitnaŋ kwitnaŋ dolakŋaŋ maindaip. Âpme Biwin kululuŋen ek An dolakŋaŋ penaŋ. In dundume kwitnaŋ kwitnaŋ dolakŋaŋ penaŋ indamukulem mimiyelen indawe. ");
INSERT INTO naf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Âpme in amnaŋ zigok mimindandayet manâip keyet kataŋ in ekŋen ŋeŋaŋ mimindawep. Zet keyaŋ Mosesiyelen zii zet ma golaŋ zenze an ekŋengalen zet sambe pendemtazin. ");
INSERT INTO naf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Teziŋ ŋandaŋgalen sekekek ke gâlâŋaŋ ma ke mebegalen set tazin ke temaŋ ma kwetetepmaŋ keyepmti am sambeyaŋ ke mâti mamelip. Mama katikŋaŋgalen sekekek ke gikŋaŋ ma set ke isikŋaŋ. Âpme am isikŋaŋ buganaŋ set ke mâti mamelip. Neŋ ingat sekekek gikŋaŋ ke mebegalen nâmtikŋaŋ miyap. ");
INSERT INTO naf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Golaŋ zenze an dâsuki sekŋin sipsip sek nemboŋ naman keŋin tam kukŋaŋbeŋ penaŋ nemboŋ. Ekŋen keboŋ keyepm keŋin miŋyuŋguwepgapm keŋin ekdamuŋ mbep. ");
INSERT INTO naf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mama mimiŋin mme in ekŋengat yaŋaŋ ŋep ekmâtâbep. Ke ŋen tepgat bem zesowap kapigok. Ŋaŋ zupmaŋaŋ penaŋ niniyelen ku peme totnak. Saŋgaleleyaŋ kegogak sam penaŋ ku peme totnak. ");
INSERT INTO naf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma tep pembenaŋaŋ penaŋaŋ pembenaŋ maelikzin ma tep bekanaŋaŋ penaŋ bekanaŋ maelikzin. ");
INSERT INTO naf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tep pembenaŋaŋ kataŋ bekanaŋ sokbembe ke ku maelikzin ma tep bekananen penaŋaŋ pembenaŋ ke ku maelikzin. ");
INSERT INTO naf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Keyepm tep ŋen penaŋaŋ dolakŋaŋ ku elikme antimti tewen mambumenzin. ");
INSERT INTO naf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sepem kegogak in golaŋ zenze an dâsuki ekŋen mama mimiŋin ekti yaŋin indikmâtâbep. ");
INSERT INTO naf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ma am notnaŋaŋ manzeip, ‘Amobotnaŋ, Amobotnaŋ,’ ekŋen ke ilinsakwep kululuŋen ku mebep. Bien kululuŋen egalen zet maŋgawepuip ekŋenaŋ etaŋ keŋan mebep. ");
INSERT INTO naf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Am sambeyaŋ kan delaŋ zenzeŋan Kawawaŋaŋ zemindome notnaŋaŋ nâgât kapigok dinowep, ‘Amobotnaŋ, Amobotnaŋ, nin gâlen maŋgeengatnangapm Kawawaŋgalen Zet Zapat Dolakŋaŋ diindowenn, ma gâlen zetgat we bekanaŋ sambe indapmâbenn ma mulup sambe mbenn.’ ");
INSERT INTO naf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kegok zeme neŋ kapigok diindowap, ‘Neŋ ingat ku nâmâtâtindeyap. In bekanaŋ mimi. In sebemâlit.’ ");
INSERT INTO naf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Am ŋenaŋ zetn kapi nâmti gawepuwe, ek an nânâŋaŋmak keboŋ. An keyaŋ mkaŋaŋ msat kaliŋan walage. ");
INSERT INTO naf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Walapeme tâgâ lumun temaŋ ma map tuŋgwam temaŋ kwati mka butem olapme katikŋaŋ bemti tage. Mka msat kaliŋan walalatnaŋgapmti katikŋaŋ bemti tage. ");
INSERT INTO naf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ma am ŋenaŋ nâlen zet nâmti ku gawepuwe ek an seoŋ keboŋ. An seoŋ keyaŋ mkaŋaŋ seŋ ŋokŋaŋ palen walage. ");
INSERT INTO naf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wala tatnepeme tâgâ lumun temaŋ kwapme tuŋgwam temaŋ kwati msat temaŋ tawalat metnepeme mka seŋ semuŋti mmege.” ");
INSERT INTO naf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zisasiyaŋ zetnaŋ sepem igak igak zemdelaŋ zeme kan keyet am ekŋenaŋ Zet Zapat Dolakŋaŋ zenzeŋaŋgat nâmtemtem penaŋ mpewien. ");
INSERT INTO naf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Egaŋ zet zapat dolakŋaŋ zeye ke sepemaŋ ekŋen zii zet am diindondo nemboŋ yek. Egaŋ am zet diindoye ke Kawawaŋgalen windemak zeye. ");
INSERT INTO naf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Zisasiyaŋ kalaŋangatnan toti mepme an imbi maŋge temaŋaŋ mâpmebien. ");
INSERT INTO naf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Âpme an ŋen liŋgit satnaŋmagaŋ Zisasiyet kandaŋan kot pedondom samti kapigok zeye. “Amobotnaŋ, geŋ nâgât liŋgit satnaŋŋ mmane ŋeluluyelen nânik beme ŋep weyaŋnesenik.” ");
INSERT INTO naf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Zeme Zisasiyaŋ betnaŋ sekŋanen timekti zeye, “Nâmgeyapgapm liŋgidi ŋeluk!” Zeme keyegak sekŋaŋ liŋgit sambe ŋelumâge. ");
INSERT INTO naf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Âpme Zisasiyaŋ aŋkeŋoo zet kapigok dunduye, “Nânik, geŋ zet zapat kapi am ŋengat ku zemane nâmbep. Geŋ belak esemteŋ met sekdi sâpe sâpe bumbu an zikat samane wiliŋgisem. Ma bam sâpe sâpe bumane ke Mosesiyaŋ eweŋan zeyenok mmane am sambeyaŋ nâme gâlen liŋgit satnaŋ ŋelup ke ekbep.” ");
INSERT INTO naf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Âpme Zisas egaŋ Kapeneam mkaen memopme Loma gapmangalen kasa kuku an ŋeŋaŋ ŋenaŋ ekmagen meti mukulem mpepeyet zeye, ");
INSERT INTO naf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Amobotnaŋ, nâlen mulup an zawat temaŋ penaŋ ma wesiŋ penaŋ bemti sindem temaŋ nâmti mkaen etaŋ tawen.” ");
INSERT INTO naf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Zeme Zisasiyaŋ zeye, “Neŋ kotiŋgut weyaŋpesap.” ");
INSERT INTO naf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kegok zeme kasa kuku an ŋeŋaŋ egaŋ zet dopmaŋ kapigok gilik zem zeye, “Yek, Amobotnaŋ, neŋ kwileki pembenaŋ nnaŋgat nâlen mkaen kosenik? Geŋ belak kapi tatiŋgut zet etaŋ zemane alik besem. ");
INSERT INTO naf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Neŋ gâlen yaŋdi nâmâtâlap. Gâlen zedi windeŋaŋbeŋ keyepmti gayaŋkwesima mulup ann kapi tati ŋep zemane alik besem. Eneyet neŋ amobotnaŋ ekŋengat kandaŋinan talap, ma nâgât kandaŋnanen kasa kuku an maip. Âpme ekŋenmagen ŋengatnaŋ ŋen, ‘Met,’ zempema mamezin ma ŋengat, ‘Kot,’ zema makozin ma mulup angat, ‘Mulup ke mi,’ zema mamin.” ");
INSERT INTO naf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Zeme Zisasiyaŋ zet ke nâmti nâmtemtem msamti am mâti mebien ekŋen zet kapigok diindoye, “Neŋ penaŋ diindowi, an ke Zuda maŋgeen ku sokbembeŋaŋ kapi nâmkiŋpepeŋaŋ temaŋ. Islael am maŋge tuŋguwinangatnan an nâmkiŋpepeŋin keboŋ penaŋ ŋen ku aikban. ");
INSERT INTO naf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Neŋ ingat kok ke zema nâit, am sambe Zuda maŋgeen ku sokbembeŋaŋ msat kataŋ kobep ekŋenaŋ Kawawaŋgalen mundumen kululuŋen Abalaam, Aisak, Zekop ekŋenmak tati tu meu nimwiaŋbep. ");
INSERT INTO naf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kawawaŋaŋ Islael am maŋge ingat kululuŋen mebegalen ombemindeye keyaŋgut ilin bamkumpewien keyepmti ekŋen sambe penaŋ tambusosok keŋan toti sek sindemgat zelinaŋ aŋgalikme si zemzu zemsu mbep.” ");
INSERT INTO naf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kegok zemti kasa kuku ŋeŋaŋ kapigok dunduye, “Geŋ mkandanen mepmane nâmkiŋpependangat penaŋaŋ sokbemgasemin.” Âpme mulup an kan keyegak penaŋ alik beye. ");
INSERT INTO naf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Âpme Zisasiyaŋ Pitayelen mkaen moti Pitayet tatnaŋ imbi zawat sek kikip temaŋ weme ege. ");
INSERT INTO naf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ekti betnanen timekme zawatnaŋ alik beye. Âpme imbi egaŋ wati Zisas tu meu bumsaye. ");
INSERT INTO naf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Âpme msat gasi tabeme am notnaŋaŋ an imbi we bekanaŋinmak sambe indatimkobien. Âpme Zisasiyaŋ belak zeletaŋaŋ we bekanaŋin mâge ma am notnaŋ zawat sek sindemak mme alik bewien. ");
INSERT INTO naf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Zisasiyaŋ kegok mme golaŋ zenze an Aizayayelen zet penaŋaŋmak beye. Ke Aizayayaŋ kapigok zeye, “Egaŋ ningalen zawat weyaŋme delaŋ zewe.” ");
INSERT INTO naf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Animbi sambeyaŋ kot Zisas bembuluŋ tapme egaŋ indikmâtâti nembaŋaneyet waŋga mti nembu nembet mebegalen zeye. ");
INSERT INTO naf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Âpme mesâgât penaŋ mme zii zet zikat indanda ŋenaŋ Zisasiyet kandaŋan penaŋ koti zeye, “An zikat indanda, geŋ deset mesât mmane neŋ gapmâti mamambap.” ");
INSERT INTO naf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Zeme Zisasiyaŋ zet dopmaŋ kapigok gilik zem saye, “Neŋ namâti mamayelen ŋep yaŋgut nukŋaŋ temaŋ penaŋ titiyelen. Zit ekŋen enzuŋinmakgapm ke mawep. Ma age ekŋen mkaŋinmak yaŋgut neŋ Angat Nemuŋaŋ mka ma mundum weweyelen ku tatnain.” ");
INSERT INTO naf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Âpme mamâpmamtemien ekŋenmagen ŋenaŋ dunduye, “Amobotnaŋ, nâmnemane meti bipm zawalen tazin ya mmalema gakime mzilimtiŋgut gilik ze kobap.” ");
INSERT INTO naf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Zeme Zisasiyaŋ kapigok gilik zem dunduye, “Geŋ bipdaŋgat nâmtemtem mimipiŋ. Geŋ nen napmât. Bipdi gakime nodine ku napmâlipgapmti ekŋengat muluwin ke. Geŋ pemane tapme kot namât.” ");
INSERT INTO naf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kegok zemti waŋgaen mopme nembaŋaneyaŋ kegogak moti mebien. ");
INSERT INTO naf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tapmetnepeme keyegak sakwep map tâgâ lumuŋ katikŋaŋ penaŋ kume tundua mamaŋaŋ temaŋ penaŋ kumti tuyaŋ lenzimti waŋga keŋan towepme waŋgayaŋ tu keŋan towesât mge. Kegok mge kan keyet Zisasiyaŋ waŋga keŋan meluk tawemaŋge. ");
INSERT INTO naf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Âpme nembaŋaneyaŋ met butemti zewien, “Amobotnaŋ, tu keŋan towesât tapminupgat wat ndaagalaŋ nde.” ");
INSERT INTO naf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kegok zeme egaŋ kapigok diindoye, “In eneyet kiŋgagat temaŋ penaŋaŋ indaikzin. In nâmkiŋpepeŋinpiŋ, ma?” Kegok zemti wati tâgâ temaŋ ma tundua mamaŋ zet diitdome sewakŋaŋ bemti titokpiŋ tabun. ");
INSERT INTO naf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kegok sokbeme nembaŋaneyaŋ ke ekti nâmtemtem mti zewien, “Ek an ziboŋgapmti tâgâ temaŋ ma tundua mamaŋ egelaŋ egat zetnaŋ gawepulup?” ");
INSERT INTO naf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Âpme tundua kutumti met nembet daen Gadala ekŋengalen msaleset met pataŋ zeme an zut we bekanaŋitmagaŋ ke koti aikbun. Egelaŋ am zaimengatnan koti kasa penaŋ mmalu am ekŋenaŋ kiŋgati keeset ku mametemien. ");
INSERT INTO naf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Âpme egelaŋ kwizet ŋakŋak temaŋ mti kapigok zewun, “Geŋ Kawawaŋgat Nemuŋaŋaŋ zigok penaŋ mimndesâgât kodik? Kan ewe ku daŋgome geŋ sindem temaŋ ndandapiŋ.” ");
INSERT INTO naf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Âpme bo maŋge temaŋ beŋanik daenen meu tatnimambien. ");
INSERT INTO naf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kegogapm we bekanaŋ ekŋenaŋ Zisas kapigok zemti dundum sawien, “Ndamâsât nâmti ndamâpmane bo keŋinan metowetne.” ");
INSERT INTO naf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Zemalu kapigok diindoye, “Ele ilak kunzuŋit.” Zeme ekŋenaŋ an egegat keŋidanengatnan kunzuŋti met bo keŋinan metowepmâbien. Kegok mme bo ekŋenaŋ kunzuŋti ŋandeŋen gululuŋ kumti tunduaen tageen toti tu nimti gakimâbien. ");
INSERT INTO naf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Âpme bo damuŋ ekŋenaŋ mka teman kunzuŋti meti boyelen zet zapat ma an zut we bekanaŋitmak egetgalen zet zapat am sambe diindomâbun. ");
INSERT INTO naf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Zet zapat diindome mka temaŋgatnan am ilinsakwep Zisas eksât topmâbien. Toekti nâme igagen beme msalin peme tapme mebegalen nâmti zempewien. ");
INSERT INTO naf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Âpme Zisasiyaŋ waŋgaen ewe moti gilik zem ikŋaŋgalen mka temaneset koge. ");
INSERT INTO naf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pataŋ zeme an ŋen wesiŋ loe mkobien. Âpme Zisasiyaŋ nâmkiŋpepeŋin igagen ke ekmâtâti an wesiŋ ke pigok dunduye, “Nemun, nâm nukŋaŋ mimipiŋ. Yomdi ilak katikpeyap.” ");
INSERT INTO naf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kegok zeme zii zet zikat indanda ekŋenaŋ kapigok zenâ zenâ mbien, “An kapi ziboŋ? Ek Kawawaŋ nemboŋ yek yaŋgut, ‘Yomdi katikpeyap,’ ke zein. An bekanaŋ penaŋ.” ");
INSERT INTO naf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Âpme Zisasiyaŋ keŋinan ekmâtâti kapigok diindoye, “Keŋinan zet bekanaŋ keboŋ ke eneyet taotnâip? ");
INSERT INTO naf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Neŋ mulup zut kapi mimiyelen winde nanaŋaŋaŋ tatnain: Am yomin katikpepeyelen ma am, ‘Wati melit,’ zemindema mebegalen kogogak winden tatnain. ");
INSERT INTO naf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Alak nen mulup msap kapi e in neŋ Angat Nemuŋaŋ winde ke nanaŋaŋ yaŋaŋ nâmâtâseip. Kapigok Kawawaŋgalen winde tatnain keyepm neŋ am msalen yomin ŋep katikpepeyelen.” Kegok zemti an kapigok dunduye, “Wati loendi pumti mkandan met.” ");
INSERT INTO naf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Zempeme an egaŋ wati mkaŋan mege. ");
INSERT INTO naf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Âpme am sambe ekŋenaŋ ekti, Kawawaŋgalen winde keboŋ ke ammagen mge keyepmti nâmtemtem mti Kawawaŋ zemsesewatpewien. ");
INSERT INTO naf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Âpme Zisas ek keyetnaŋ meti mânep takis titi munduman tapme mege. Meti mânep takis titi an ke aikge. Ke neŋ. Kwitn Matiyu. Neŋ tapma Zisasiyaŋ koti nikti dinoye, “Geŋ koti neŋmak tusu.” Kegok dinome neŋ keyegak wati ek mâti meban. ");
INSERT INTO naf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Meti nâlen mkaen meu niniyelen Zisas zemtetimti mobelin. Âpme am yomtoŋ ma an takis mânep titi notnne sambeyaŋ kopme Zisas ma nembaŋane ninsakwep meu nimbenn. ");
INSERT INTO naf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kegok mmann Palisi notnaŋaŋ ndikti Zisas nembaŋaŋne ningat zewien, “An zikat indandaŋin eneyet an mânep takis butnaŋ kambu matip ekŋenmak am yomtoŋ temakwep tati tu meu tatnip?” ");
INSERT INTO naf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Zet ke Zisasiyaŋ nâmti bemzenze zet ŋen diindoye, “Doktayaŋ am dolakŋaŋ zawalinpiŋ ekŋenmagen mulup ku mamin. Zawatmak ekŋenmagen etaŋ muluwin mamin. ");
INSERT INTO naf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","In meti Kawawaŋgalen Zet Itnaŋaŋ kapigok tazin keyet yaŋaŋ weyaŋekmâtâlit, ‘Kawawaŋaŋ zeye, “Neŋ in am aŋgalaŋ gogot mimindemti mama keyet nâmtikŋaŋ mamiyap. Wa in neŋmak keŋin kwetetepmaŋ beme mamayet sâpe sâpe mambup ke yek.”’ An ek ikŋaŋgat sekŋaŋ moti zein, ‘Neŋ a yomtoŋ yek; An dolakŋaŋ penaŋ,’ zein ke neŋ an keboŋ ke ku indamukulem mimiyelen kolap. Ma an ek ikŋaŋgat sekŋaŋ mtoti zein, ‘Neŋ yommak,’ tazein an keboŋ ke neŋ indamukulem mimiyelen kolap.” ");
INSERT INTO naf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kan ŋengat Zân an tu zululut egalen nemba ekŋenaŋ Zisasmagen koti yaŋkwesiwien, “Nin ma Palisi an msasa sambenik tu meu zemkulumpemti keŋ sindem matatnup. Kwilekiyet mti gâlen nembandine ekŋenaŋ eneyet tu meu ku zemkulumpemti talip?” ");
INSERT INTO naf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kegok zeme Zisasiyaŋ bemzenze zet pigok zeye, “An ŋenaŋ imbiŋaŋ wasât mti notnanemak tapme ekŋenaŋ oloŋen penaŋ tati tu meu nimwiaŋti tatnepeme an imbi wasâgât mge egat kasaŋane ekŋenaŋ koti mandamepme kan keyet notnaneyaŋ keŋ sindem palen ma meu zemkulumpemti tabep.” ");
INSERT INTO naf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Zisasiyaŋ zet ŋen kapigok zeye, “Mka tokan tuŋgupmanen etimbembeŋaŋ alakŋaŋ antimti ku weyaŋ bek. Weyaŋsât tapmnepemane egaŋ bululuŋ zemtobodak. Keyepmti alakŋaŋ etaŋaŋ mpemane dolakŋaŋ kaliŋaŋ tadak.” ");
INSERT INTO naf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bemzenze ŋen naman pigok zeye, “Am ŋenaŋ siŋgapoŋ sâŋsâŋ busât selik itnaŋaŋ peweweŋaŋgat ku bunak. Bunak beme seligaŋ sakwep epeeme siŋgapoŋ sâŋsâŋ kwawadak. Keyepmti selik alakŋanen bunak beme dolakŋaŋ zinak.” ");
INSERT INTO naf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Zisas ek bemzenze zet ke zemti tapme an damuŋ eget kandaŋan kot pedondom samti zeye, “Namban alakŋati kapi gakin keyepmti geŋ gapmepma met teŋgumane ewe gilik zem wasem.” ");
INSERT INTO naf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kegok zemti mepme Zisas ma nembaŋane nin mâti mebenn. ");
INSERT INTO naf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tapmepmann imbi ŋen sipmaŋ nup kan 12 omba penaŋ belak makwawetan. Keyaŋ Zisas mâti meti egalen sâkŋaŋ butnaŋ etaŋ atasâgât nâŋge. ");
INSERT INTO naf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Keŋaŋaŋ kapigok otnâye, “Sâkŋaŋ etaŋ atasap beme dolakŋaŋ besap.” ");
INSERT INTO naf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kegok nâmti Zisasiyelen sakŋaŋ butnaŋ atame Zisasiyaŋ gilik zemti ekti zeye, “Ipm, nâmnukŋaŋ mimipiŋ. Nâmkiŋpependimakgapm dolakŋaŋ benik.” Zeme keyegak imbiyaŋ dolakŋaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Âpme Zisas egaŋ metneti an damuŋ keyelen mka keŋan mowege. Moweti eget mkaen am notnaŋaŋ si silik kwisak ma am notnaŋgalen si zemsu zemsu nâye. ");
INSERT INTO naf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ke nâmti diindoye, “In ilinsakwep wati towepmâlit. Imbi nemba ek ku gakip; ek muluk tawen.” Kegok zeme am ekŋenaŋ Zisas ekyeŋbien. ");
INSERT INTO naf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Âpme indamâpme towepme delaŋ zeme egaŋ imbi nemba gakikiŋaŋ tage mka keŋan ke meti imbi nemba betnanen atame wage. ");
INSERT INTO naf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Âpme keyet zapatnaŋaŋ msat keyet keŋan palakŋaŋ bemege. ");
INSERT INTO naf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Âpme Zisasiyaŋ msat ke pemti mepme an zikalit beŋaŋ zut egelaŋ ek mâti kwizet kwawet kwawet mti zewun, “Geŋ amobotnaŋ Dewitgalen alikŋaŋaŋ, nigat kembeŋ bugan mi?” ");
INSERT INTO naf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Zeme egaŋ meti mkaen mowepme, an zulaŋ kandaŋan mowepmalu idayaŋkwesimti zeye, “Neŋ zikalit weyaŋidendeyelen ke ŋep nâmkiŋpelup, ma?” Zeme egelaŋ zewun, “Amobotnaŋ, nit nâmkiŋpemgelup.” ");
INSERT INTO naf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kegok zemalu Zisasiyaŋ zikalit timekti zeye, “Nâmkiŋpepeŋidaŋgat penaŋaŋ nâlup kegok idaktimekma sokbemidak.” ");
INSERT INTO naf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Atame keyegak zikalit ekbun. Ekmalu Zisasiyaŋ amgat ku zemsokbembeyet zemkulumidemti kapigok diidoye, “Nâlup, it keyet zapatnaŋ am ŋen ku diindomalu nâseip.” ");
INSERT INTO naf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yaŋgut egelaŋ zet ke nâmpemti zet zapatnaŋ zemalu msat keyet keŋan palakŋaŋ bemti mepmâge. ");
INSERT INTO naf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Âpme Zisasiyaŋ mepme keyegak am notnaŋaŋ an zetnepiŋ wati kobien. An ke we bekanaŋaŋ mpeme zetnepiŋ bembeŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Zisasiyaŋ we bekanaŋ mâpme mepme an egaŋ zetnaŋ zeye. Zeme am maŋga temaŋ tabien ekŋenaŋ nâmtemtem mti zewien, “Islael msalen muluwaŋ keboŋ ŋen ku sokbeme ekbenn.” ");
INSERT INTO naf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Palisi an ekŋenaŋ zewien, “We bekanaŋ ekŋengalen amobotnaŋaŋ mukulem mpeme we bekanaŋ taindapmâzin.” ");
INSERT INTO naf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Âpme Zisasiyaŋ mulup kegok ke mti mka temaŋ isikŋaŋ mame delaŋ zeye ma sesewat mka ŋen ŋen Kawawaŋgalen zemâtâtâtgat katnanen mama keyelen Zet Zapatnaŋ Dolakŋaŋ diindoye. Diindomti zawat liŋgit, sek sindemak mme dolakŋaŋ etaŋ bewien. ");
INSERT INTO naf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Âpme am maŋge temaŋ indikti ekŋengat keŋaŋ kembeŋ penaŋ beye. Ekŋen pembenaŋ bembeyelen keŋ yayaŋ mbienaŋgut mukulemin ku aikbien. Ekŋen sipsip damuŋinpiŋ mamti kileŋ maip sepem keboŋ mambien. ");
INSERT INTO naf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Keyepm nembaŋane ningat kapigok diindoye, “Kawawaŋgalen mulup sambe penaŋ tazin âpme mulup an imbi sambe yek. Kwep kwewetaŋ. ");
INSERT INTO naf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Keyepmti in mulup toŋaŋ dundum same mulup mimi an imbi aikindeme mulupmane sakwep mepmâbep.” ");
INSERT INTO naf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zisas egaŋ nembaŋane 12 ndatime koti we bekanaŋ mâtindendeyelen ma liŋgit ma zawat sek sindem ke mmann yek bem indandayelen winde ndamâge. ");
INSERT INTO naf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Nemba 12 ningat kwitn kapigok: Ŋeŋaŋ Saimon kwitnaŋ ŋen Pita ma yuŋaŋ Endulu ma Zebediyet nemuŋanet Zemsmak Zân. Ma Pilip ma Batolomiyu ma Tomas ma neŋ Matiyu itnaŋan takis mânep titi an mamteman ma Zems Alipiasiyet nemuŋaŋ ma Tadias ma Saimon Zelot ma Zudas, Iskaliot mka temaŋgatnaŋ. Egaŋ mamotneti bamgat Zisas zemkuwe. ");
INSERT INTO naf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Âpme Zisasiyaŋ nembaŋane 12 ningat zet zemeti zeye, “In am Zuda maŋge ku sokbembeŋaŋ msalen selaŋ ku iwep ma Samalia ekŋengalen mka temaŋ notnanen ku mebep. ");
INSERT INTO naf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Islael am maŋge ekŋen sipsip keboŋ galaŋ zemti waleletgat zapat mamaip ekŋenmagen tokwati Zet Zapat Dolakŋaŋ Penaŋ diindom ");
INSERT INTO naf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","meti kapigok zewep, ‘Kawawaŋgalen zemâtâtâtgat katnanen mama inmagen sokbem tazin’. ");
INSERT INTO naf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mti zawalin mme alik bewep ma gakikiŋaŋ mme gilik zemti wabep ma liŋgit sat mme ŋalumâbe ma we bekanaŋ indamâtindewep. In winde mulup keboŋ mimiyet toŋaŋ toŋaŋ indandaŋaŋgapmti mulup ke tosaŋepiŋ mbep. ");
INSERT INTO naf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mânep ma milawat notnaŋ ku timebep. ");
INSERT INTO naf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ele ku tiwep. Saŋgum melakandu sekŋinanen tazin ke ŋep. Setmunduŋduŋ ma toŋge ku mbep. Amnaŋ kwitnaŋ kwitnaŋ taolet mimindawep keyepmti in naptalak mebep. ");
INSERT INTO naf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mka temaŋ ma isikŋaŋ keyet keŋan moti am ŋenaŋ ekmak tatagat zemindatetime egalen mkaen metabep keyetnaŋ toti am notnaŋgalen mkaen selak selak ken ke ken ke ku mekobep. Mka indandaŋaŋ keyet tabep. ");
INSERT INTO naf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","In amgalen mkaen moti, ‘Keŋ sewakŋaŋ alak inmagen tazin,’ zeme ");
INSERT INTO naf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","mka toŋaŋaŋ tu meu indawe beme keŋ sewakŋaŋ ekŋenmak weweyet zewep. Yaŋgut in amgalen mkaen meti, ‘Keŋ sewakŋaŋ alak inmak tazin,’ zeme ekŋenaŋ zemindewep ma ekŋenaŋ indaikti mka ma tu meu ku aik indawep beme Kawawaŋgalen keŋ sewakŋaŋ ku indawep. Keŋ sewakŋaŋ ilinmak tapme mebep. ");
INSERT INTO naf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Âpme mka temanen mepme amnaŋ ku indamukume ma zelin ku nâmeŋgut zipelukŋin seŋti ke ku gilik zem kobep. ");
INSERT INTO naf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Neŋ penaŋ zema nâit, Sodom mka ma Gomola mka temanen am bekanaŋinaŋgat dopmaŋ titiyelen kanen Kawawaŋ dopmaŋ mtoti indaye yaŋgut mka keyelen am ekŋen bekanaŋinaŋgat dopmaŋ mmoti mimindawe. ");
INSERT INTO naf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nâip, sipsip tam zupmaŋ ekŋengat tuŋguwinan zemindema melip keyepm in sawekwikwit keboŋ kakanemuŋ tati weyaŋekmâtâti mambep mti sasakandenombe keboŋ sewakŋaŋ mambep. ");
INSERT INTO naf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","In kasaŋine ekŋengat eksemti mambep. Ekŋenaŋ indatimti met zet muluwen indewep ma sesewat mkaŋinan meindemti sindiwaŋ indowep. ");
INSERT INTO naf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yaŋgut ke etaŋ yek. In nâgât nembanne maip keyepm gapman ma amobotnaŋ ekŋenmagen indatimti mebep eneyet in nâgât kwizet buŋam zemâtâbep kegogapm kegok mimindawep. Âpme in ekŋengat zikalinan ma am Zuda maŋge ku sokbembeŋaŋ ekŋengat zikalinan windeŋaŋ bemti Zet Zapat Dolakŋaŋ zemkawaŋ bewep. ");
INSERT INTO naf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ekŋenaŋ amobotnaŋmagen zemindome, ‘Zet zigok zewanup?’ zemti yayaŋ ku mbep. Kan keyet in zet zenzeyelen ke dembusekŋinan bema in zet ke zewep. ");
INSERT INTO naf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kegok mimindame zet zewep ke ingalen zet ku bewe. Biwinaŋgalen Emetak Teŋaŋ zet ke keŋinanen indame zewep. ");
INSERT INTO naf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kan keyet datnaŋaŋ meniŋaŋ zemkume gakiwe ma bipmaŋaŋ nemuŋaŋ zemkumti kume gakiwe ma animbi nembayaŋ mamin biwin kasa mimindamti zemindowep. ");
INSERT INTO naf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Âpme in neŋmak mamaipgapmti am sambe ekŋenaŋ ingat nâme kaŋgaŋaŋ bewe. Yaŋgut amnaŋ an ŋen nâmkiŋpepemak sisipeŋpeŋ msame egaŋ nâmkiŋpepeŋaŋ katikŋaŋ atam tapmetneti gakiwe beme kan delaŋ zenzeŋaŋ Kawawaŋaŋ an ke mama kanzizit sawe. ");
INSERT INTO naf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ekŋenaŋ sisipeŋpeŋ mme in katikpemti kunzuŋti mka ŋenen mebep. Neŋ zet penaŋ zema nâit, in Islael mka sambe Zet Zapat Dolakŋaŋ ku timek kopme delaŋ zeme Angat Nemuŋaŋ neŋ kobap.” ");
INSERT INTO naf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Zisasiyaŋ nukŋaŋ keyet zet ŋen ewe kapigok zeye, “Melaŋgaŋenaŋ an damuŋ ku sebempenak. Ma sisiliŋ nembayaŋ amobotnaŋaŋ sebempemti mobotnaŋ ŋep ku manak. ");
INSERT INTO naf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kegogapm am ekŋenaŋ an damuŋ msawien sepem keyet kataŋ melaŋga ekŋen nukŋaŋ aikindame oloŋen palen ku mambep. Âpme an damuŋgat kwitnaŋ Beelsebul kuwien beme sepem kegogak melaŋga ekŋengat kwilin bekanaŋ penaŋ kuwep. ");
INSERT INTO naf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ekŋenaŋ kegok mimindawep keyepmti in kasaŋineyet ku kiŋgabep. Nanaŋgat kwizapatn mpalakŋaŋ beme amnaŋ nâmkawaŋ bewep. ");
INSERT INTO naf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Neŋ zet buzagen diindoma in zet ke tusumti diindoma sambeyet zempalakŋaŋ bewep. Ma in zet buzagen nâmbien ke sambemagen zempalakŋaŋ bewep. ");
INSERT INTO naf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Âpme in am sekŋin etaŋ kume gakime emetakŋin ŋep ku kukuyelen ekŋen keyet ku kiŋgabep. An ingalen emetakŋin mene sekŋin mene temakwep âtâtpeme teziŋ ŋandaŋ towebe windeŋaŋ tasain Ek ke Kawawaŋgat ek etaŋ eksempem mambep. ");
INSERT INTO naf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Keyepm kasaŋineyet kiŋgagapiŋ. In gwasembelembele indigit. Kawawaŋaŋ indikdamuŋ mam. Gwasembelembele ekŋen belakŋaŋ penaŋ. Ekŋen tosaŋin isikŋaŋ penaŋ titiyelen yaŋgut age ŋen gakime Bienaŋ manâin. ");
INSERT INTO naf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Keyaŋgut Kawawaŋ ingat nâme mobotnaŋ penaŋ mambein. ");
INSERT INTO naf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Keyepmti in kiŋgagapiŋ mambep. In tosaŋin temaŋ penaŋ keyepm Kawawaŋaŋ indikdamuŋ mme mambep. ");
INSERT INTO naf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Am ŋenaŋ neŋ mmotnembe beme am ekŋenmagen kogok manzein, ‘Neŋ Zisasmak tusu mayap,’ kogok manzein beme neŋ kegogak kululuŋen gwaen Bipmnaŋgat zikatnan zemkawaŋ bempemti, ‘Ek ningalen maŋgeen tusuye.’ zewap. ");
INSERT INTO naf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yaŋgut ŋen egaŋ am ekŋengat zikalinan zemkandabe beme neŋ kegogak kululuŋen Bipmnaŋgat zikatnan zemkandatpewap. ");
INSERT INTO naf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","35","Âpme neŋ kululuŋengatnaŋ inmak keŋ kwep mamayelen ku toban. Neŋ kululuŋengatnaŋ toti Zet Zapat Dolakŋaŋ Penaŋ indama in notnaŋaŋ nâmkiŋpeme, notnaŋaŋ ku nâmkiŋpep keyepm zet keyet in ilinak kalalaŋ tapmip. ‘Bipnemuŋaŋ kalalaŋ tapmilup. Ma mam nembayaŋ kalalaŋ tapmilup. Imbiyaŋ naniŋaŋmak kasa kasa tapmilup. ");
INSERT INTO naf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ma biwinmak kasa kasa tapmip.’ ");
INSERT INTO naf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","In gogot temaŋ mamin biwinaŋgat ma nemunambaŋineyet ku mbep. Mama mimi keyaŋ tototnaŋ bewe. Âpme neŋ nanaŋgat muluwaŋ toŋaŋ nanaŋgat kwep nâme mamopmambe. Neŋ nikme an tototnaŋ bema in nâgât keŋ kwep penaŋ ku mamneip. ");
INSERT INTO naf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","An ŋenaŋ neŋ napmâbâgalen nâmti nukŋaŋ puwe sepem neŋ nukŋaŋ puwan kegok. Ek tewen gakikiyet weyaŋ tabe. Nukŋaŋ pupuyet ku weyayaŋ mti tabe beme egaŋ nâgât zapat ŋep ku bewe. ");
INSERT INTO naf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Am ŋenaŋ msalen mamaŋaŋ nâme mobotnaŋ beme mambe egaŋ mama penaŋ ku aikbe ma naman am ŋenaŋ ek nâgât mti sisipeŋpeŋ mpeme napmâmamambe egaŋ gakimti mama kanzizitgat zapat bewe. ");
INSERT INTO naf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","An ŋenaŋ mka keŋan indatimti kwati dolakŋaŋ mimindawe ke neŋ egalen mka keŋan natetimti kwati dolakŋaŋ minewiek keboŋ. Ke kegogak Bien Kawawaŋgat mpewiek keboŋ. ");
INSERT INTO naf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma an ŋenaŋ mka keŋan nâlen mulup mimi an indaikkwati wembe ke bamgat Kawawaŋaŋ tosaŋit sepem kwep idawe. ");
INSERT INTO naf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Zet penaŋ zesowap, am ŋenaŋ an nâmkiŋpepemak tototnaŋ main egat tu teeŋaŋ bugan omsawe beme egaŋ mukulemaŋ isikŋaŋ bugan keyet tosaŋaŋ tiwe.” ");
INSERT INTO naf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zisasiyaŋ nin nembaŋene 12 zet kegok zemzikat ndame delaŋ zeme pemann tapme, mka notnaŋ sokŋanen Zet Zapat Dolakŋaŋ Penaŋ zemzikat indamimiyelen mebenn. ");
INSERT INTO naf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Âpme Zân tu zulutindende an ek mka katikŋanen tati Kilaisiyaŋ mulup mge keyet zapatnaŋ nâmti nembaŋane zemindeme meti, ");
INSERT INTO naf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Zisasiyet kapigok yaŋkwesiwien, “Zânaŋ nâsâgât tapm keyet zemane nâne geŋ Zânaŋ an Islael ninmagen kokogalen zeye ke geŋ kapi ma ewe ŋen?” ");
INSERT INTO naf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Zeme Zisasiyaŋ kapigok diindoye, “‘An zikalin beŋaŋaŋ alak zikalin taegip, selin bekanaŋaŋ set tapmaip, liŋgilin temaŋaŋ alak liŋgilin takŋelun, wakŋin kekekŋaŋ alak ekŋenaŋ wakŋin tatnâip, an gakikiŋaŋaŋ gilik zem tawalip ma am toweweŋaŋ penaŋaŋ Zet Zapat Dolakŋaŋ Penaŋ tatnâip.’ In nâlen zet nâmti mulupm tapmiap ke taegip kapiyet zet zapatn gilik zemeti Zângat zeme nâmti yaŋŋ nâmâtâsem. ");
INSERT INTO naf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Âpme an ŋenaŋ nâgât keŋ zut ku mbe beme egaŋ oloŋen mam. Zet ke mmeti Zângat dunduseip.” ");
INSERT INTO naf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Âpme Zângalen nembaŋane ekŋenaŋ gilik zemti mebienen Zânmagen Zisas egaŋ am tabien ekŋen Zângat kapigok diindoye, “In eweŋan Zânmagen msat tuŋgupman mebienen in kwileki eegalen otnâmti mebien? In Zân betut sinaŋnok tâgâyaŋ kumbume mebe kokot tapme eksât mebien? ");
INSERT INTO naf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma in msat tuŋgupman an ŋen kâlâpmaŋ dolakŋaŋ tosaŋaŋ temaŋ munduŋ tapme ke eksâgât mebien? Nâip, an kâlâwin dolakŋaŋ ekŋenaŋ amobotnaŋ ekŋengalen mkaen etaŋ mamaip. ");
INSERT INTO naf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","In zeme nâmbi, in kwileki eegalen otnâmti mebien? In golaŋ zenze an eegalen mebien? Ke penaŋ, ek golaŋ zenze an sambe mambien sebemindein enenogat ek golaŋ zenze an mobotnaŋ temaŋ penaŋ. ");
INSERT INTO naf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kawawaŋgalen Zet Itnaŋanen Zângat zemkawaŋ kapigok zenzeŋaŋ, ‘Neŋ zapat zenze an pema koti egaŋ kukŋaŋgat meti zet am keŋin gilik zenzeyelen gâgât set weyaŋ be.’ Kawawaŋaŋ kegok zeye. ");
INSERT INTO naf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Neŋ ingat zet penaŋ zeyap, Zân tu zulutindende an egaŋ am sambe msat kataŋ sebemindemti mobotnaŋ penaŋ bein, yaŋgut egaŋ nâgât gakikinnaŋgat yaŋaŋ ku nâmâtâzin. Âpme in neŋ yominaŋgat gakimti yomin katipema in sambeyaŋ nâmkiŋpenewaŋ Kawawaŋgalen zemâtâtât katnanen tapmaiwaŋ in Zân sebempeip. ");
INSERT INTO naf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kan keyet Zân tu zulutindende an egaŋ mulup yaŋbemti mmepme alak tatnup kapi an ekŋenaŋ Kawawaŋgalen zemâtâtâtgat katnanen mamayet zapatnaŋ msat kataŋ palakŋaŋ bein âpme amnaŋ zet ke nâmti zet ke ewe timti keyet keŋan mamayelen tikŋaŋin temaŋ penaŋ wemindaye. ");
INSERT INTO naf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Golaŋ zenze an itnaŋan zewien ma Mosesiyelen zii zelen zet tazinen keyet penaŋaŋ Zânaŋ tu zulutindende an ekmagen sokbemkawaŋ beme Kawawaŋgalen zemâtâtât katnanen mama kelak penaŋaŋmak bein. ");
INSERT INTO naf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Âpme itnaŋaŋ penaŋ Ilaizayaŋ mamkwati gakime golaŋ zenze an notnaŋ ekŋenaŋ an ŋen Ilaiza nemboŋ sokbewe zewien. Yaŋ alak Zân tu zulutindende an egaŋ sokbein ek Ilaiza keboŋ. Âpme in zet itnaŋaŋ nâmkiŋpeip beme in Zânaŋ zet zein ke nâmkiŋpewep. ");
INSERT INTO naf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","In zet nânâyelen tikŋaŋaŋ tazinaŋ zet kapi ŋep opeimti nâsem.” ");
INSERT INTO naf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Zisasiyaŋ pigok zeye, “In pe ziboŋ? Bemzenze zet kapigok diindosowap. Imbi nemba ŋen silik kume notnaneyaŋ dopmaŋ ku maŋgilik zemkuip. Ma silik kum tasume ku masumpeip keboŋ. ");
INSERT INTO naf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Keyet yaŋaŋ kapigok. Nâgât zetn ma Zângat zetnaŋ ke in nâme pepesut beme ku manâip. ");
INSERT INTO naf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Zânaŋ tu meu belaknik bugan manimti mamtan. Âpme am sambeyaŋ Zângat zewien, ‘Ek we bekanaŋmak main.’ ");
INSERT INTO naf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Âpme neŋ Angat Nemuŋaŋ toti tu meu nima in nikti nâgât manzeip, ‘An kapi tu meu temaŋ ma wain tu manin ma mânep takis titi an ma am yomtoŋ ekŋengat nolin.’ In ŋoktikŋin pembenaŋ benak beme nigalen meu zemkulumpepe ma ninindaset ekmâtâbiek.” ");
INSERT INTO naf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Zisasiyaŋ zet ke zemdelaŋ zemti mka temaŋ notnanen itnaŋaŋ maŋgeen ke menok temaŋ sambe penaŋ mme yomengatnan keŋin ku gilik zewienyepmti kan keyet egaŋ gilik zem meti golaŋ zet mimindaye. ");
INSERT INTO naf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Golaŋ zet kapigok diindoye, “Wakae, inmagen bekanaŋ penaŋ sokbewe. Kolazin mkaengatnaŋ am ma Besaida mkaengatnaŋ am inmagen neŋ menok kwitnaŋ kwitnaŋ temaŋ sambe mban ke eweŋan am Taia mka ma am Saidon mka temanen ke ekŋenmagen sokbenak ze nap sâk teŋgenaŋaŋ munduŋti kâyaŋ sekŋinan mulati yominaŋgat nâmti sakambuk mti kembeŋ palen talip keyet zikat indame yominmagengatnaŋ gilik zewiek. ");
INSERT INTO naf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Keyepmti neŋ in pigok diindoma nâit. Taia ma Saidon am ekŋengat dopmaŋ mututu kananen Kawawaŋaŋ yominaŋgat tosaŋaŋ mtoti ekŋengat indawe yaŋgut in yominaŋgat tosaŋin mmoti penaŋ indawe. ");
INSERT INTO naf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapaneam ingalen mka teman tatat mimi mti menok yaŋaŋ yaŋaŋ mma am in nikmotâbien yaŋgut in alak pi in sekŋin tapm molip in nâgât nâmâtâliwaŋgut kegok tapmip ke ŋep yek. Keyepmti ingat tosaŋin teziŋ ŋandaŋen towebep. Inmagen neŋ menok sepem igak igak mban kegogak Saidon mka temanen am mbak ze alak kan pigogak ewe tabiek. ");
INSERT INTO naf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Keyet neŋ pigok zema nâit, Dopmaŋ titi kanen Sodom mkaengatnaŋ yominaŋgat tosaŋaŋ mtoti indawep. Yaŋgut in dopmaŋ mmoti penaŋ indawe.” ");
INSERT INTO naf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kan keyet Zisasiyaŋ zet kapigok zeye, “Bien kululuŋ msatgalen Amobotnaŋ, neŋ gâgât wisikŋ nâmgeyap enenogat am nânâŋinpiŋ ekŋenmagen mulupdi ma Zet Zapadi Dolakŋaŋ Penaŋ ekŋenmagen mkawaŋ bemane ekmâtâbien keyaŋgut an nânâŋin temaŋ ekŋenmagen kwitnaŋ kwitnaŋ enziliwanan. ");
INSERT INTO naf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Bipm, geŋ kwitnaŋ kwitnaŋ msokbewanan ke gitaŋgat nânâyet ma nâmtikŋaŋdaŋgat mbanan. ");
INSERT INTO naf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bipmnaŋ kwitnaŋ kwitnaŋ sambe kapi betnnan bem nemâge. An ŋenaŋ nâgât yaŋŋ ku nâmâtâzin. Bipmnaŋ nâgât yaŋŋ maekmâtâzin. Ma Bipmnaŋgalen yaŋaŋ an ŋenaŋ ku maekmâtâzin nen kwep maekmâtâlap. Ma neŋ etaŋ am ombem indema Bipmnaŋgat yaŋaŋ maekmâtâlip. ");
INSERT INTO naf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Âpme neŋ an keŋ sewakŋaŋ toŋaŋ kogogapm nukŋaŋin timti neŋmagen kopme netimpema in keŋin sewak beme mait. ");
INSERT INTO naf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Neŋ ingat nukŋaŋin tiwan ke keŋ sewakŋaŋ palen tati tiwangat kopme, ‘keŋ sewakŋaŋ ke indama neŋmak tusume mamti keyet yaŋaŋ mnâit.’ Eneyet neŋ An bakbak toŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ma kwileki ŋen zikat indama in am ekŋen zet ma mama keyaŋ timtot indendeyelen ku mbep in ekŋen meleŋ belaŋ bem indeme mambep. Âpme keyaŋ meleŋ belaŋ bemindeme nâmâbep.” ");
INSERT INTO naf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kan keyet bamanen Zisas ma nembaŋane nin nsakwep Zuda am ekŋengalen Sabat tagoŋgo kanen wit mulup tuŋgupmaset meti nsakwep meuyet mti yaŋbemti wit katnaŋ tim nimbenn. ");
INSERT INTO naf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kegok mmann Palisi an ekŋenaŋ ndikti Zisasiyet kapigok dunduwien, “Pi ekbak, nembandine ekŋenaŋ muluwaŋ tapmip ke ningalen Sabat tagoŋgo kangat ŋep ku mimiyelen!” ");
INSERT INTO naf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Zeme kapigok diindoye, “Dewit ma amŋane ekŋenaŋ meuyet mti kwitnaŋ kwitnaŋ mbien zapatnaŋ ke mamaiŋ nâip. ");
INSERT INTO naf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Egaŋ Kawawaŋgalen sesewat mka temaŋen moti nupmamaŋ Kawawaŋgat wisikŋ bembeŋaŋ ke sâpe sâpe bumbu an egaŋ msame ikŋaŋ ma nembaŋane nupmamaŋ nimbien ke zii zelen tazinen sâpe sâpe bumbu ekŋenaŋ etaŋ niniyelen. Dewit egaŋ zii zet aŋgosoye keyaŋgut egat zet bekanaŋ ku manzeip. ");
INSERT INTO naf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sepem kegogak in eweŋan Mosesiyelen zii zet makumnâmbienen sâpe sâpe bumbu an ekŋenaŋ sesewat mka temaŋen ningalen Sabat tagoŋgo kan sâpe sâpe bumbu ke mulup mamtemien. Keyaŋ yom yek kok zenzeŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Neŋ pigok diindowi, an ŋen kapi tazin ek sesewat mka temaŋ mobotnaŋ sebempein. ");
INSERT INTO naf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kawawaŋgalen Zet Itnaŋaŋ zet ŋen kapigok tazin, ‘Kawawaŋaŋ zeye, “Neŋ in am aŋgalaŋ gogot mimindemti mama keyet nâmtikŋaŋ mamiyap. Wa in neŋmak keŋin kwetetepmaŋ beme mamayet sâpe sâpe mambup ke yek.”’ In zet keyet yaŋaŋ nâmbiek benak ze an ekŋen ke yominpiŋ keboŋgat zetnaŋ ku zemindowiek. ");
INSERT INTO naf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Eneyet neŋ Angat Nemuŋaŋ Sabat tagoŋgo kangalen Amobotnaŋ keyepmti neŋ ŋep ekŋenaŋ Sabat tagoŋgo kangat kwitnaŋ kwitnaŋ ke ma ke mimiyelen ŋep zemindendeyelen.” ");
INSERT INTO naf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kegok zemti nembaŋane nsakwep keyetnaŋ meti Zuda ekŋengalen sesewat mkaen mowebenn. ");
INSERT INTO naf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Âpme kan keyet an ŋen betnaŋ seleuuŋaŋ tapme Palisi an notnaŋaŋ tati Zisas ekti zelen pepeyelen nâmti yaŋkwesiwien, “Ningalen zii zelen tazinen Sabat tagoŋgo kangat am weyaŋpepeyelen ma yek?” ");
INSERT INTO naf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Zeme Zisasiyaŋ nâmti diindoye, “Inmagen ŋenaŋ sipsipmaŋ kwewetaŋ tatnak beme Sabat tagoŋgo kanen aimboŋan towepme kan keyepmti peme tadak? Yek, mpeme kwadak. ");
INSERT INTO naf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Âpme sipsip ekme nânâŋan tototnaŋ mambein. Âpme am mobotnaŋ penaŋ bein keyepmti Sabat tagoŋgo kanaŋ am mukulem mimi keyaŋ mulup penaŋaŋmak bein.” ");
INSERT INTO naf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kegok zemti an betnaŋ seleuuŋaŋmak keyet dunduye, “Bedi mututut!” Zeme betnaŋ mututupme betnaŋ dolakŋaŋ nembet keboŋ beye. ");
INSERT INTO naf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Âpme Palisi ekŋenaŋ Zisas kume gakikiyelen met ondekti zetnaŋ zewien. ");
INSERT INTO naf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Âpme Zisas kume gakikiyelen zet ke nâmti msat ke pemti belakŋaset mepme am sambeyaŋ mâti mepme am zawat sambe weyaŋindeye. ");
INSERT INTO naf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Weyaŋindemti Zisasiyaŋ ikŋaŋgat yaŋaŋ am notnaŋ ekŋenaŋ ku zempalakŋaŋ bembeyet zemkulumindeye. ");
INSERT INTO naf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ke Kawawaŋaŋ zet ŋen golaŋ zenze an Aizayayet eweŋan zeye ke penaŋaŋmak bein. ");
INSERT INTO naf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Zet ke kapigok, “Kilais kapi ek nanaŋgat sisiliŋ nemban neŋ ek ombempewan. Neŋ egat gogot mti oloŋen mampeyap. Neŋ Emetakŋ ek sama egaŋ am Zuda maŋgeen ku sokbembeŋaŋ ekŋenmagen zemkawaŋ beme neŋ zemdelaŋ zenze zet mulup teŋ ekŋenmagen mbap. ");
INSERT INTO naf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Egaŋ zet mdândâ ma kwizet ŋenzinziŋmak ku mbe. Ma egaŋ mka temaŋ keŋan selen zet kwizet temaŋ am sambeyet diindondopiŋ mbe. ");
INSERT INTO naf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Egaŋ zet katik am yaiiŋaŋ ekŋengat ku maapitilim indein. Egaŋ mulup tapm metnepeme Kawawaŋgalen zezapat dolakŋaŋ msat kataŋ mpalakŋaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Am Zuda maŋgeen ku sokbembeŋaŋ ekŋenaŋ egat webe webe palen tabep.” ");
INSERT INTO naf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Âpme kan keyet an ŋen we bekanaŋaŋ mpeme zikatnaŋ beŋaŋ ma kopa ke wati Zisasmagen mepme weyaŋpeme we bekanaŋaŋ pemepmâpme zetnaŋ zemti zikatnaŋ kegogak ekmâtâge. ");
INSERT INTO naf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mme am maŋge temaŋ tabien ekŋenaŋ muluwaŋ ke ekti nâmtemtem mti zewien, “Dewitgat Nemuŋaŋ ke kapi mene.” ");
INSERT INTO naf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kegok zeme Palisi ekŋenaŋ nâmti zewien, “Ek we bekanaŋ ekŋengat ŋeŋaŋin kwitnaŋ Beelsebul egaŋ mamaŋ bempemti winde same maindapmât indein.” ");
INSERT INTO naf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Âpme Zisasiyaŋ keŋinanen daenen zet zigok zesâip keyet ekmâtâti diindoye. “In manzeip ke neŋ Beelsebul egalen windeen we bekanaŋ maindapmâlap tazeip ke in ŋoktikŋin teŋ penaŋ yek keyepm bemzenze zet kapi zesowapgat nâit. Msat ŋeniyelen am ekŋenaŋ ilinak kasa kasa mti dolakŋaŋ ku tabep. Âpme mka temaŋ ma am maŋge ŋen ekŋenaŋ ilinak ŋenzinziŋ dopmaŋ dopmaŋ mti am mka mundumin ke peme tapme mebep. ");
INSERT INTO naf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Keyepmti maŋge ŋenaŋ maŋge ŋen kasa kasa Sadaŋgalen damuŋ mimi keŋan mbiek beme yaŋaŋ kapigok ekŋenaŋ ilinak kalalaŋ mti katikŋaŋ ku tabiek. ");
INSERT INTO naf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","In manzeip ke neŋ Beelsebul egalen windeen we bekanaŋ maindapmâlap. In nembaŋine ekŋenaŋ we bekanaŋ indapmâbiek beme ekŋengat zet sepem kegok manzeip? Yek, in kok ŋep ku zewiek. Sadaŋaŋ ikŋaŋgat windeŋaŋ ŋep ku mtopenak. Ilinaŋgat nembaŋineyaŋ mulup tapmip keyaŋ msokbenen in an dâsuki toŋ. ");
INSERT INTO naf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wa ke Beelsebulyelen windeŋaŋ yek. Kawawaŋgalen Emetak Teŋaŋ manapmukulem mme we bekanaŋ maindapmâlap kapiyaŋ msokbemindainen Kawawaŋgalen zemâtâtâtgat katnanen mama windeŋaŋ alak inmagen kapi tazin. ");
INSERT INTO naf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ma an kwiyaŋ an windeŋaŋbeŋ mkaŋan moti milawatnaŋ tinak? Ke ŋep ku mimiyelen. Ŋeŋaŋ an ke atamti setnaŋ betnaŋ zamtiŋgut milawatnaŋ tiwek. Keyet yaŋaŋ kapigok, Sadaŋ ek an kukŋaŋbeŋ keboŋ keyaŋgut neŋ egat windeŋaŋ ŋep mtopemti ŋep zemâbap. ");
INSERT INTO naf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","An ŋenaŋ neŋmak ku mambe beme ek nâgât kasan. ");
INSERT INTO naf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Keyepmti yaŋaŋ kapi diindoma nâip, An ŋenaŋ neŋmak tadak beme nâgât zetn gawepum mamti yom mbiek beme Kawawaŋaŋ yomin ŋep katipeme medak keyaŋgut an ŋenaŋ Emetak Teŋgalen winde ke Sadaŋgalen winde manzein beme Kawawaŋaŋ yom ke ku katipewe. ");
INSERT INTO naf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","In nâgâegaŋ emetak bekaŋaŋgat kwitnaŋ kumti mulup tapm ke ku nâmbep. Neŋ Emetak Teŋ egat kwitnaŋ kumti mulup kapi tapmiap. In nâgâegat nâme, ‘Emetak bekanaŋmak mulup tapm,’ nâmti zewien keyaŋ Kawawaŋgat Emetak Teŋgat kwelat zet zeme bekanaŋ mambein. Keyepmti Kawawaŋaŋ yomin ku katipeme yom kemak kwesiŋ kwesiŋ mamti mamambep. ");
INSERT INTO naf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tep ŋen ek pembenaŋ mozin beme penaŋaŋ dolakŋaŋ mapein. Ma tepmaŋ bekanaŋ bein beme penaŋaŋ bekanaŋak mapein. In tep katnanen tep penaŋ dolakŋaŋ ma bekanaŋ ke eknâmimbep. ");
INSERT INTO naf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","In nombe bekanaŋgalen alikŋane, in mama bekanaŋ penanen matalip keyepm zet bekanaŋ etaŋ manzeip. Keŋinan kwitnaŋ kwitnaŋ bekanaŋ ma dolakŋaŋaŋ gak zem matazin keyegak dembusegen sepem keboŋ masokbein. ");
INSERT INTO naf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","An ŋen keŋaŋaŋ pembenaŋ tazin egaŋ zet zesât pembenaŋak manzein. Ma an keŋaŋaŋ bekanaŋ wemsain egaŋ kogogak zet zesât bekanaŋak manzein. ");
INSERT INTO naf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Neŋ kapigok diindoma nâit, zemdelaŋ zenze kanaŋ am kwep kwep kataŋ Kawawaŋaŋ zet bekanaŋ kataŋ manzenuwen yaŋaŋ nânâyelen indeyaŋkwesime in dopmaŋ teŋ zewep. ");
INSERT INTO naf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Zelin ilinaŋgalen manzeiwen pembenaŋ ma bekanaŋ gilik zemti Kawawaŋaŋ keyet kataŋ zemdelaŋ zemindeme kwetetepmaŋ kwabep ma waleletgalen ke diindowe.” ");
INSERT INTO naf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kegok zeme zii zet zikat indanda an ma Palisi notnaŋ ekŋenaŋ kapigok zemti dunduwien, “An zikat indanda, geŋ menok ŋen mmane ekne.” ");
INSERT INTO naf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ekŋenaŋ kegok zeme diindoye, “Am msat alak kan kapiyet talip ekŋen bekanaŋ penaŋ ma Kawawaŋ bamkumpemti mamaip.” Zisasiyaŋ kapigok zemkawaŋ beye, “In neŋ menok mimiyet nâmti tatnapitilip? O alak yek, yaŋgut in menok kwewetaŋ Kawawaŋaŋ golaŋ zenze an Zonamagen mgeen keboŋ bam ekbep. ");
INSERT INTO naf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zona ek kasup ma tambumbu tuk aŋgala temaŋgat kambakŋaŋ keŋanen tage. Kegogak neŋ Angat Nemuŋaŋaŋ kasup ma tambumbu tuk msat aimboŋ keŋan tabap. ");
INSERT INTO naf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Zonayaŋ zet zapat dolakŋaŋ Ninewe am ekŋen diindoyeen yomengatnan keŋin gilik zem mâpme delaŋ zeye keyet dopmaŋ dolakŋaŋ Kawawaŋaŋ indawe. Ma ekŋenaŋ koti Kawawaŋgat zikatnan in zemindowep. Enenogat alak neŋ inmagen pi tati Zona mobotnaŋ penaŋ sebempemti tapma in nâlen zet zapatn dolakŋaŋ nâmti ewe yominangatnaŋ ku gilik zeip. Keyepmti dopmaŋ bekanaŋ temaŋ inmagen sokbewe. ");
INSERT INTO naf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Âpme imbi mobotnaŋ Siba msalengatnaŋ egaŋ beŋangatnaŋ amobotnaŋ Solomon egat zetnaŋ nâsâgât kotnâmti oloŋen mge. Âpme neŋ amobotnaŋ Solomon omba penaŋ sebempeyap. Yaŋgut neŋ ingat tuŋguwinan pi tati mulup mma in keŋinan ku mkipmaŋ mbemnemti yominaŋgatnaŋ ku gilik zeip. Keyepmti imbi mobotnaŋ Siba msalengatnaŋ egaŋ Kawawaŋgat zikatnan zemindowe. ");
INSERT INTO naf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","We bekanaŋaŋ an keŋan zempeme kwati msat tuŋgupman mundum tatagat timati mundum ŋen ku aige. ");
INSERT INTO naf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Keyepmti ikŋaŋgat kapigok zein, ‘Mkan eweŋan pemti koban keyegak gilik zemti meti eksap.’ Zemti gilik zem meti egeen mka ke toŋepiŋ ma weyaŋti kapupeme tage. ");
INSERT INTO naf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Keyepmti met we bekanaŋ notnane 7 ekŋen ke bekanaŋ penaŋ eksebempeip ekŋen ke indatime kot keyegak tatat mimi mbien. Âpme an ke eweŋan bekananik maŋgeyaŋ bekanaŋ penaŋ bem tazin. Muluwaŋ kok keyaŋ am msat kataŋ alak talip ekŋenmagen sokbemindawe.” ");
INSERT INTO naf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Zisasiyaŋ am zet tadiindomaŋgeen mamnotnane ekŋenaŋ ekmak zapat mimiyelen koti zupman baen damuŋ tapme ");
INSERT INTO naf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","maŋgeengatnaŋ ŋenaŋ zeye, “Wae, mamnodine geŋmak zapat msâgât koloyaŋ zupman damuŋ talip.” ");
INSERT INTO naf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zeme Zisasiyaŋ dunduye, “Mamnotnne ke kwi?” ");
INSERT INTO naf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kegok zemti nembaŋane tabieneset bet ombemti kapigok zeye, “Egit! Nâgât mam notnne ekŋen kapi! ");
INSERT INTO naf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwi ma kwi ekŋenaŋ Bipm kululuŋen tazin egalen zetnaŋ maŋgawepuip ekŋen nâgât mamm ma notnne beip.” ");
INSERT INTO naf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kasup keyet Zisasiyaŋ mkaengatnaŋ toti met tundua ganzenan met totatnepeme ");
INSERT INTO naf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","am maŋge sambe penaŋ koti bembuluŋ tapme indikti egaŋ waŋga dukŋan mototapme am sambe penaŋaŋ nelum gambibik palen tabien. ");
INSERT INTO naf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Egaŋ bemzenze zet palen zet notnaŋ manzemtan. Bemzenze zet ŋen kapigok zeye, “Kan ŋengat an ŋenaŋ mulupmanen wit katnaŋ timtetelime mekokogalen mege. ");
INSERT INTO naf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Egaŋ mulupmanen wit katnaŋ tatetelime notnaŋaŋ mulup selen ke towemâge. Âpme ageyaŋ koti nimbien. ");
INSERT INTO naf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma wit katnaŋ notnaŋ nanzaŋ palen towemâge. Âpme ke msat belaknik dukŋan gwaen tageyepm dukŋaŋ sakwep kwabien. ");
INSERT INTO naf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Keyepmti kindiŋaŋaŋ towesâgât olati nanzaŋ palen sagak sagak gwaen mepme kasup kukŋaŋbeŋ kwati ekme aŋgasimti memuŋ bewien. ");
INSERT INTO naf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma wit katnaŋ notnaŋ didik tuŋgupman towembien. Âpme epeemti dukŋaŋ kwapme didigaŋ mme kwati eiŋeiŋsimti yek bewien. ");
INSERT INTO naf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Âpme wit katnaŋ notnaŋ msat kelakŋaŋmagen toti kwati penaŋaŋ sambe penaŋ sokbewien. Yaŋaŋ ŋeniyet penaŋaŋ 100. Yaŋaŋ ŋeniyet penaŋaŋ 60 ma yaŋaŋ ŋeniyet penaŋaŋ 30 kogok sokbemmâge.” ");
INSERT INTO naf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Zisasiyaŋ zet ke zemdelaŋ zemti kapigok zeye, “An ŋen zet nânâyelen tikŋaŋaŋ tazinaŋ zet kapi ŋep opeimti nâsem.” ");
INSERT INTO naf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bemzenze zet kegok zeme nin nembaŋaneyaŋ ekmagen meti yaŋkwesiwenn, “Geŋ bemzenze zet ke yaŋaŋ zigogat am ekŋenmak manzenik?” ");
INSERT INTO naf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Âpme egaŋ kapigok dindoye, “Kawawaŋgalen zemâtâtâtgat katnanen mama enzilim tazin ke nembanne in nânâyelen zenzeŋaŋ. Notnaŋ ekŋenaŋ ke ku nânâyelen nâmâtâtpeye. ");
INSERT INTO naf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Am ŋen Kawawaŋgalen zetnaŋ nâmti nâmtikŋaŋ mbe beme Kawawaŋaŋ nânâ ewe tusumti sawe keyepm egaŋ nânâŋaŋ sambe penaŋ tasawe. Ma am ŋenaŋ zetnaŋ nâmtikŋaŋ ku mbe beme Kawawaŋaŋ nânâŋaŋ isikŋaŋ ke menzem tiwe. ");
INSERT INTO naf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Âpme am ŋenaŋ zikat eek ektiŋgut kwitnaŋ kwitnaŋ ku maekmâtâlip ma wagaŋ zet nâmtiŋgut yaŋaŋ ku manâmâtâlip keyepmti bemzenze zet zeleset mandiindoyap. ");
INSERT INTO naf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Âpme Aizayayaŋ golaŋ zenze an Zuda am ekŋengat Kawawaŋgalen Zet Itnaŋanen kapigok zeye, ‘Ekŋenaŋ wagaŋ nânâ ke nâmbep yaŋgut penaŋ nâmâtâtât ke ku mamip. Zikalaŋ eek ke ŋep ekbep yaŋgut kwitnaŋ kwitnaŋ ekmâtâti mama ke ku mbep. ");
INSERT INTO naf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Enenogat ekŋen ke keŋin kaliŋaŋ bembeŋaŋ ma wakŋin kekekŋaŋ ma zikalin beŋaŋ. Keyepm zikalinaŋ kwitnaŋ kwitnaŋ ku maekmâtâlip ma wakŋinaŋ kwitnaŋ kwitnaŋ ku manâmâtâlip. Ma keŋinaŋ kwitnaŋ kwitnaŋ ku maweyaŋnâmâtâlip. Kegok mti keŋin ku gilik zeme neŋ zigoset weyaŋindewak.’ ");
INSERT INTO naf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kawawaŋgalen zemâtâtâtgat katnanen mama nembanne inmak tazin e wakŋinaŋ nâmâtâti zikalinaŋ ekmâtâlip keyepmti in oloŋen palen talip. ");
INSERT INTO naf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Neŋ penaŋ diindoma nâit. Eweŋan baenen golaŋ zenze an ma an teŋ notnaŋ ekŋenaŋ niksât webe webe mbien. Ekŋenaŋ nâgât zetn nâsât mbien yaŋgut ku nâmbien. ");
INSERT INTO naf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Âpme pi wit katnaŋ muluwen ondendeŋaŋ keyet bemzenze zet diindowan. Keyet yaŋaŋ zema nâit, ");
INSERT INTO naf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","An ŋen ek Kawawaŋgalen zemâtâtâtgat katnanen mama keyet Zet Zapat Dolakŋaŋ Penaŋ dundume nâmti keŋaŋ penaŋ ku bemti mambe ekmagen Sadaŋ an bekanaŋ mimi egaŋ koti keŋanen katnaŋ teteliliŋaŋ ke mpewe. An ke katnaŋ selen toweŋge keboŋ keyet kataŋ. ");
INSERT INTO naf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma nanzaŋ palen toweŋge am keboŋaŋ Zet Zapat Dolakŋaŋ Penaŋ nâmtikŋaŋ mmambep ");
INSERT INTO naf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","yaŋgut kindiŋaŋ msat keŋan baen penaŋ ku towege e am Zet Zapat Dolakŋaŋ Penaŋ keŋinanen katikŋaŋ ku tabeyepmti nukŋaŋ sambe ma sisipeŋpeŋ sambeyaŋ sokbemti nâmkiŋpepeŋin mme mapeme towen. ");
INSERT INTO naf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma notnaŋ didik keŋan toweŋge keboŋ mambeyaŋ Zet Zapat Dolakŋaŋ Penaŋ nânâ ke nâmtiŋgut keŋanen ku bemti keŋaŋaŋ segesetgalen kwitnaŋ kwitnaŋ keyet keŋ otnânâŋaŋ bemti mame mânep milawat keyet tikŋaŋaŋ kwati Zet Zapat Dolakŋaŋ Penaŋ kume eiŋeiŋsimti penaŋepiŋ bewe. ");
INSERT INTO naf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Msat kelakŋanen toweŋge ekŋen keboŋaŋ Zet Zapat Dolakŋaŋ Penaŋ nâmti keŋinaŋ penaŋ bemti mambep. Âpme ŋen ekmagen penaŋaŋ 100 ma ŋenmagen penaŋaŋ 60 ma ŋenmagen penaŋaŋ 30 kegok masokbein.” ");
INSERT INTO naf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Âpme bemzenze zet ŋen kapigok diindoye, “Kawawaŋgalen zemâtâtâtgat katnanen mama set kapi nemboŋ: An ŋenaŋ mulupmanen wit katnaŋ dolakŋaŋ teteliye. ");
INSERT INTO naf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Âpme am sambe meluk tawemâpme kasaŋinaŋ kogeen nusi katnaŋ mgasik wit tuŋgupman time mepmâpme kunzuŋge. ");
INSERT INTO naf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Âpme wilaŋ kwati penaŋ sokbesâgât mme nusiyaŋ kegogak kwage. ");
INSERT INTO naf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Âpme mulup an ekŋenaŋ ke ekti mulup toŋaŋ dunduwien, ‘Amobotnaŋ, geŋ mulupdanen wit katnaŋ dolakŋaŋ etaŋ teteliwanan. Âpme nusi mgasik zigoset koti kwazin?’ ");
INSERT INTO naf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yaŋkwesime zeye, ‘Ke kasa ŋenaŋ koti teteliyeyaŋ kwazin.’ Zeme yaŋkwesiwien, ‘Keyepm met selumti pemann mesem, ma?’ ");
INSERT INTO naf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Zeme kapigok diindoye, ‘Yek, wa in nusi selunup zemti wit penaŋaŋ ilizuzut seluwepgapm peme tati ");
INSERT INTO naf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ilizuzut kwabalup. Âpme wit eleŋgeŋge kanaŋ bemeŋgut, mulup an ekŋenaŋ eleŋgemti nusi makumti pendem mti tewen time mot zime wit mkananen beme tabe.’” ");
INSERT INTO naf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Âpme bemzenze zet ŋen kapigok diindoye, “Kawawaŋgalen zemâtâtâtgat katnanen mama ke mastat tep katnaŋ keboŋ an ŋenaŋ ke mulupmanen ondeye. ");
INSERT INTO naf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Katnaŋ ke isikŋaŋ penaŋ. Yaŋ semem katikŋaŋ bemtiŋgut tep nemboŋ kwati sebemindemti tep temaŋ mambein. Ma age ekŋenaŋ koti betnanen mkaŋin walati matalip.” ");
INSERT INTO naf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Âpme bemzenze zet ŋen kapigok diindoye, “Kawawaŋgalen zemâtâtâtgat katnanen mama ke yis keboŋ. Ma neŋ yis keyet palen bemzema nâseip. Imbi ŋenaŋ yis isikŋaŋ buganmak plawa omba kemak weyaŋme plawa keyaŋ sememti omba penaŋ mambein.” ");
INSERT INTO naf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Zisasiyaŋ am zet ke bemzenze palen etaŋ diindomâge. Zet sosok ku zemsokbemindaye. Egaŋ bemzenze zeleset etaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kegok mme golaŋ zenze an ŋenaŋ zet kapigok zeye ke penaŋmak beye, “Bemzenze zet paleset zewap. Msat sokbeyeen keyetnaŋ zet enzililiŋaŋ takoti tage ke neŋ zemkawaŋ bewap.” ");
INSERT INTO naf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Âpme Zisasiyaŋ am indeme mepme mkaen mowege. Mot tapme nembaŋane nin ekmagen meti zewenn, “Zemane nâne, zet bemzenze nusi muluwen kwakwagat zenak ke yaŋaŋ kwileki?” ");
INSERT INTO naf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yaŋkwesimann dinndoye, “Wit katnaŋ dolakŋaŋ time mekodak ke Angat Nemuŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mulup ke msat sambe kapi keboŋ. Katnaŋ dolakŋaŋ ke Kawawaŋgalen zemâtâtâtgat katnanen mamaen mamaipgat nembaŋane keboŋ. Nusiyaŋ an bekanaŋ penaŋgalen nembaŋane keboŋ. ");
INSERT INTO naf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Âpme an kasa nusi bekanaŋ katnaŋ ondeye ek ke Sadaŋ. Âpme akumbembe ke kululuŋ msat delaŋ zewe kenok. Ma akumbembeyelen mulup an ekŋen ke ensel. ");
INSERT INTO naf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ensel ekŋenaŋ nusi selumti tewen bume ziwe sepem kegogak kan delaŋ zenzeŋan sokbewe. ");
INSERT INTO naf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Keyepmti Angat Nemuŋaŋaŋ ensel zemindeme toti am maŋgeŋane ekŋenmagengatnaŋ am bekanaŋgalen keŋ walalat ma notnaŋ mama mimiŋin bekanaŋ penaŋ mamaip. ");
INSERT INTO naf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ekŋen keboŋ ondekindemti teziŋ ŋandaŋgalen zapat indeme towebep. Ke sikalem ma zelin aŋgalikti sek sindem palen mamti mamambep. ");
INSERT INTO naf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Âpme Kawawaŋgalen am ekŋenaŋ Biwin kululuŋen gwaen tazin egat zimosetnan mambep. An ŋen zet nânâyelen tikŋaŋaŋ tazinaŋ zet kapi ŋep opeimti nâsem. ");
INSERT INTO naf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","An ŋenaŋ ŋengalen mulup an mamtan. Kasup ŋengat mulupmanen ke milawat tosaŋaŋ temaŋen aikti naman msalaŋ kwatampemti keŋaŋ saŋgamaŋ beme mkaŋan mege. Met bo milawatnaŋ sambe ke beme kwitime delaŋ zeye. Delaŋ zeme mânep ke timti met an mulup ma msat keyet toŋaŋmagen mot sokbemsamti mânewaŋ msat ke kwitiye. Kawawaŋgalen zemâtâtâtgat katnanen mama ke milawat tosaŋaŋ temaŋ keboŋ. ");
INSERT INTO naf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kegogak bemzenze zet ŋen pigok zeye. An mânep milawatnaŋ temaŋ ŋenaŋ kekek nanzaŋ satnaŋaŋ weyayaŋaŋ keyet matimatan. ");
INSERT INTO naf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Âpme egaŋ kekek nanzaŋ satnaŋaŋ weyayaŋaŋaŋ ŋen tosaŋaŋ mobotnaŋ aikti egaŋ milawatnaŋ sambe am ekŋenmagen beme kwitimâpme mânepmaŋ timti met kekek ke tosaŋaŋ mobotnaŋ ke kwitiye. Kawawaŋgalen zemâtâtâtgat katnanen mama ke kekek tosaŋaŋ temaŋ keboŋ. ");
INSERT INTO naf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kawawaŋgalen zemâtâtâtgat katnanen mama ke eleŋgolam temaŋ keboŋ am ekŋenaŋ eleŋgolam temaŋ nembuen waŋga mti mapeme towepme aŋgala sepemaŋ igak igak matip keboŋ. ");
INSERT INTO naf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Âpme ke aŋgalayaŋ gak zem tapme mandame katikŋaŋ mopme kalaŋ kumti niniyelen timti ele keŋan time toge ma ku niniyelen time mege. ");
INSERT INTO naf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Msatgalen kanaŋ delaŋ zewe sepem kegok ke sokbesâpm. Keyet Kawawaŋgalen ensel ekŋenaŋ msat ŋen msat ŋen meti am ilak pembenaŋ bembeŋaŋ ekŋengat tuŋguwinangatnan am bekanaŋ indamakumti ");
INSERT INTO naf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","indaâtâtindeme teziŋ ŋandaŋ keŋan towebep. Ke sindem temaŋ timti zelin aŋgalikti mamambep.” ");
INSERT INTO naf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kegok zemti ndayaŋkwesiye, “In neŋ zet sambe zeya ke nâmâtâlo?” Âpme nin zewenn, “Nâmâtâtnup,” ");
INSERT INTO naf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Zemann kapigok dinndoye, “In golaŋ zenze an itnaŋaŋgalen zet ke nâip in keyaŋ nâlen nembanne tati nânâŋin itnaŋaŋmak alakŋaŋ temakwep nânâ temaŋ penaŋ tiip. Kwep ŋen Kawawaŋgalen zet itnaŋaŋ ma ŋen Kawawaŋgalen zet alakŋaŋ. Zut kemak in am ŋep mzikat indanda dolakŋaŋ mbep.” ");
INSERT INTO naf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zisas egaŋ bemzenze zet sambe ke zemdelaŋ zemti ke pemti meti ");
INSERT INTO naf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","mkaŋaŋ ŋotekŋan pataŋ zemti sesewat mkaen moti Zet Zapat Dolakŋaŋ Penaŋ zemzikat indame am ekŋenaŋ tektek mti zewien, “Nânâŋaŋ temaŋ ma menok mamin kapi desetgatnaŋ penaŋ aige? ");
INSERT INTO naf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nin egat yaŋaŋ nânup. Ek an mka walalat egat nemuŋaŋ ma mamaŋ kwitnaŋ Malia ma meniŋane ekŋengat kwilin nânup Zemsmak Zosep ma Saimonmak Zuda. ");
INSERT INTO naf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma ipmane ninmak temakwep kapi mamanup. Âpme ek nânâ ma winde sambe ke desetgatnaŋ aige?” ");
INSERT INTO naf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kegok zemti peŋpeŋ mpewien. Âpme Zisasiyaŋ kapigok diindoye, “Golaŋ zenze an ŋen kwizet buŋamaŋaŋ msat notnanen tapalakŋaŋ bemepme mkaŋaŋgatnaŋ am ma notnane penaŋ ekŋenaŋ egat wisat mamimpeip.” ");
INSERT INTO naf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Âpme mka keyetnaŋ am ekŋenaŋ ku nâmkiŋpewiengapmti Zisasiyaŋ ekŋenmagen menok sambe ku mge. ");
INSERT INTO naf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Zisasiyaŋ mulup tapmme kan keyet Elolaŋ Zuda am ekŋengalen amobotnaŋ tage. ");
INSERT INTO naf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","12","Elolaŋ tipman baenen meniŋaŋ Pilip egalen imbiŋaŋ menzemti wage. Imbi ke kwitnaŋ Elodias. Ke Zân tu zulutindende an ya egaŋ zet kapigok dunduye, “Geŋ imbi wabanan ke yomaŋmak bein.” Kegok zeme ŋenzinziŋ mti Zângat betnaŋ atam zamti mka katikŋan peye. Ŋeŋaŋ zeme Elot egaŋ Zân kegogak kukuyelen nâŋge keyaŋgut Zuda am ekŋenaŋ Zângat golaŋ zenze an manzemtemiengapmti ekŋengat kiŋgati peme tage. Âpme Elotgalen sokbembe kanaŋ beme amobotnaŋ indazemtetime ekŋenaŋ kwawati ondek tapme Elodiasiyet nambaŋaŋaŋ ekŋengat zikalinan silik wendime Elolaŋ sandiyaŋ mti zeye, “Neŋ penaŋ sukwep zeyap, geŋ kwileki ŋengat zenik beme ŋep gasap.” Zeme imbi nemba ek mamaŋaŋ zempeme meti kapigok zeye, “Neŋ Zân an tu zulutindende an egat ŋokasetnaŋ eleŋgemti alak kapigogak batien bemti na.” Kegok zeme amobotnaŋ egaŋ kambekat mge yaŋgut am ekŋengat zikalinanen zemkatik beyeyepm ekŋenmagen zetnaŋ windeŋaŋ tototnaŋ besem zemti kasa kuku an zempeme mka katikŋan meti Zân bimaŋ eleŋgemti ŋokasetnaŋ batien bem koti imbi nemba same mti mamaŋ saye. Âpme Zângat nembaŋane ekŋenaŋ koti sekŋaŋ mti met sumen mebemti met Zisasiyet buŋam zapat dunduwien. Kan keyet amobotnaŋ Elot egaŋ Zisasiyet zapatnaŋ zeme nâŋge, “An ke Zân tu zulutindende an penaŋ gakikiengatnaŋ wageyepmti windeŋaŋbeŋ menok sepem igak igak mamin.” Egaŋ zet ke amobotnaŋ notnaŋ ikŋaŋgat kandaŋan mulup mamip ekŋen keyet zemsokbemindaye. ");
INSERT INTO naf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Zisasiyaŋ Zângalen zapat nâmti waŋga ŋengat moti tundua nembet meti msat tuŋgupman igak mamayelen mepme am ekŋenaŋ mege keyet zapatnaŋ nâmti mka ŋen mka ŋen am maŋge temaŋ ekŋenaŋ seleset meti ekmagen mepataŋ zeme ");
INSERT INTO naf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zisas waŋgaengatnan toti am maŋge temaŋ tabien ke indikti keŋaŋ kembeŋ penaŋ beme am zawalinmak mme alik bewien. ");
INSERT INTO naf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kegok tapminepeme msat gasi beme nembaŋane nin ekmagen koti dunduwenn, “Wae, msat tuŋgupman tatnepemann msat gasi bein. Keyet am indemane mkaŋinan kataŋ meti tu meuŋin aigit.” ");
INSERT INTO naf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zemann Zisasiyaŋ kapigok dinndoye, “Zemindeme mebegalen eneyet tazeip? In meu indame nit!” ");
INSERT INTO naf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kegok dinndome nin zewenn, “Nin nupmamaŋ 5 ma aŋgala zuletaŋ tatndain.” ");
INSERT INTO naf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Zemann egaŋ kapigok dinndoye, “Ke neŋmagen pien mti kolit!” ");
INSERT INTO naf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Âpme am kapigok zemindeye, “In msalen totalit!” Zemti egaŋ nupmamaŋ 5 aŋgala zut ke timtati kululuŋen ekme mopme Kawawaŋgat, “Wisikŋ,” zemti nupmamaŋ mutumti aŋgalamak ndame nin kalaŋkum ");
INSERT INTO naf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","am nsakwep nimbenn. Nimti am sambeyaŋ nim nalak nalak mme butnaŋ tage ke makum timann tise 12 gak zem tage. ");
INSERT INTO naf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma am tu meu ke nimbien ke an etaŋ makumann 5,000 kegok. Imbi ma nemba ekŋen ku indamakuwenn. ");
INSERT INTO naf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kegok mti Zisasiyaŋ nin ndeme waŋgaen moti tundua nembet daen nnak mepmann egaŋ am zemindeme mebekobien. ");
INSERT INTO naf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Âpme egaŋ am zemindeme mepmâpme igak etaŋ kalaŋan motati dunduye. Tapme msat tambume igak etaŋ ke tage. ");
INSERT INTO naf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kan keyet wagayaŋ tundua sutnan kopme tâgâ temaŋaŋ mebenneset koge keyepmti tu mamaŋ temaŋ kumti katikŋaŋ kwapme waŋgayaŋ tapmotopmaŋge. ");
INSERT INTO naf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Âpme msat balalaŋ tazeme Zisasiyaŋ tundua paleset meti nin tabennen sokŋan ");
INSERT INTO naf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","takopme ekti ŋakŋak mti omba penaŋ kiŋgati zewenn, “We kozin!” ");
INSERT INTO naf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Zemann Zisasiyaŋ dinndoye, “Keŋin sewakŋaŋ bek. Nen takolapgat ku kiŋgalit.” ");
INSERT INTO naf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Zeme Pitayaŋ zetnaŋ ŋandaŋaŋ nâmti zeye, “Amobotnaŋ, giti penaŋ takodik beme zemane neŋ tu paleset gâlen kobi.” ");
INSERT INTO naf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Âpme Zisasiyaŋ zeye, “Ŋepgat kot.” Zeme Pitayaŋ waŋga keŋangatnan toti yaŋbemti tu paleset Zisasmagen mege. ");
INSERT INTO naf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Metnepeme tâgâ temaŋ kume ekti kiŋgati tundua kenan towesât mti Zisasiyet kwizet kuye, “Amobotnaŋ, nata!” ");
INSERT INTO naf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kwizet kegok kume keyegak Zisasiyaŋ betnanen atamti zeye, “Geŋ kwilekiyet keŋ zut mnik? Nâmkiŋpependipiŋ, ma?” ");
INSERT INTO naf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kegok zemti waŋgaen mowepmalu tâgâyaŋ peme tage. ");
INSERT INTO naf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Âpme nembaŋane nin waŋgaen tabenn nin Zisas sesewatpemti zewenn, “Geŋ Kawawaŋgat Nemuŋaŋ penaŋ.” ");
INSERT INTO naf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Âpme nin tundua kutumti Genesalet msat ganzenan mopmann ");
INSERT INTO naf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","am ekŋenaŋ Zisasi ekmâtâti zeme mka sokŋan sokŋan ke am ekŋenaŋ am zawalinmak indatimti kobien. ");
INSERT INTO naf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Koti ekŋenaŋ Zisas kapigok wekuwien, “Nâmndemane am zawalinmagaŋ sekdi atait ma notnaŋaŋ sâkdi busiliŋaŋ etaŋ timekti zawalin ŋep delaŋ zesem.” Kegok zemti ekŋenaŋ kegok mti alik bemâbien. ");
INSERT INTO naf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kan keyet Zelusalem mkaengatnaŋ zii zet zikat indanda ma Palisi notnaŋ ekŋenaŋ Zisasmagen koti yaŋkwesimti zewien, ");
INSERT INTO naf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nembandine ekŋenaŋ eneyet yeŋsokŋine ekŋengalen zii zet taaŋgosoip? Meu niniyelen kananen bet zululugat set bembeŋaŋ ke ku mamâlip.” ");
INSERT INTO naf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kegok yaŋkwesime Zisasiyaŋ diindoye, “In zigogat ilinaŋgalen mama mimi gawepumti Kawawaŋgalen zii zet ke mamimyuŋguip? ");
INSERT INTO naf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kawawaŋgalen zet kapigok tazin, ‘Geŋ mamdi bipdi eksemindewanik,’ ma ŋen ‘an ŋenaŋ mamaŋ ma bipmaŋgat kwelat zet kuwe beme gakikiyet zapat bewe.’ ");
INSERT INTO naf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yaŋgut in kapigok manzeip, ‘An ŋen egaŋ mamaŋ ma bipmaŋgat kapigok manzein, “Kwitnaŋ kwitnaŋ it idamti idamukulem mbak yaŋgut keyaŋ neŋ Kawawaŋgat tewalaŋ msasayelen.”’ ");
INSERT INTO naf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Am notnaŋaŋ kegok mme in kapigok manzeip, ‘Mamin biwinaŋgat ŋep ku eksemindendeyelen.’ In kegok mti Kawawaŋgalen zet mtopemti ilinaŋgalen mama mimi itnaŋaŋ mamâlip. ");
INSERT INTO naf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","In an zetgalen etaŋ! In an keboŋgat golaŋ zenze an Aizayayaŋ zet ŋen kapigok kuye, ");
INSERT INTO naf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘In nâgât belak zelaŋ etaŋ manzeip. In neŋ mandiindoyap ke ku maŋgawepup. ");
INSERT INTO naf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","In nâlen zii zet ku tazikat indaip. In ilinaŋgalen zii zet zenâm mip sepem kegogak ke nâlen zii zetnok beingapmti nâgât sekŋinan etaŋ masesewatneip.’” ");
INSERT INTO naf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Zisas ek zet kegok diindomti am sambe indamandame kopme diindoye, “Neŋ zet diindoma wakbemtati nâmâtâlit! ");
INSERT INTO naf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Anaŋ meu manin ke Kawawaŋaŋmak mama main ku mambekekzin. Keyaŋgut bekanaŋ keŋangatnaŋ makwazin keyaŋ mme yommak mambein.” ");
INSERT INTO naf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kegok zeme nembaŋane nin egat kandaŋan meti dunduwenn, “Gâlen zet Palisi ekŋen diindonak keyaŋ keŋin mme kipmaŋ bein. Ke nânik?” ");
INSERT INTO naf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Zemann Zisasiyaŋ kapigok dinndoye, “Bien kululuŋen tazin egalen mulupmanen tep msikokok notnaŋ ondemti notnaŋaŋ belak kwakwatnaŋ ke egaŋ kiŋdiŋaŋ melesiŋ seluwe. ");
INSERT INTO naf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Keyepmti in Palisi ekŋen katikindeit. Ekŋen zikalin beŋaŋnok ya zikalin beŋaŋ keyaŋ beŋaŋ notnaŋ ekŋen indamukulem msâgât tapmip yaŋgut an zikatnaŋ beŋaŋaŋ zikatnaŋ beŋaŋ ikŋaŋ nemboŋak teti medak beme ilisakwep aimboŋan towebuk.” ");
INSERT INTO naf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kegok zeme Pitayaŋ kapigok dunduye, “Geŋ bemzenze zet zenak keyet yaŋaŋ zemane nâne.” ");
INSERT INTO naf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Zeme Zisasiyaŋ dinndoye. “In ewe keyet yaŋaŋ nâmâtâtâpiŋ mamaip? ");
INSERT INTO naf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Keyepmti in kegogak ku nâip. Kaŋgaleminan meu nime kambakŋinaŋ toweti setnaset makwawezin. ");
INSERT INTO naf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yaŋgut keŋ otnânânaset bekanaŋ makwazin keyaŋ mme nin Kawawaŋgat zikatnan yommak mambenup. ");
INSERT INTO naf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Amgat keŋangatnaŋ ŋoktik bekanaŋ makwazin keyaŋ mme sesepem kapigok masokbeip: Am indome gakiki, awembiŋ kalalaŋ mti mama, an imbi kambu wawat ma imbiyaŋ kegogak mamip, ma set kileŋ mama, kambu titi ma zet dâsuki zenze ma notnaŋgat zet kwelat kuku. ");
INSERT INTO naf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mama mimi keboŋaŋ Kawawaŋgat zikatnan pembenaŋ ku bein yaŋgut bet ku zuluti meu niniyelen zet keyaŋ Kawawaŋgat zikatnan mme yommak ku talip.” ");
INSERT INTO naf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Âpme Zisas ma nembaŋane nin mka ke pemti Taia ma Saidon mka temaŋ zut keyet ganzenan mebenn. ");
INSERT INTO naf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Met mamann imbi ŋen Kenan msalengatnaŋ keyaŋ koti Zisasiyet kwizet temaŋ penaŋ kumti zeye, “Amobotnaŋ, geŋ Dewitgalen alikŋaŋaŋ, ya nâgât keŋdi bugan kembeŋ nâne. Nemban we bekanaŋaŋ igagen penaŋ maoyak sain.” ");
INSERT INTO naf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kegok zeme Zisasiyaŋ nâmtiŋgut zet dopmaŋ ŋen ku gilik zem saye. Kegok mme nembaŋane nin egat zewenn, “Geŋ imbi belak zempemane melak! Ek ningat bamenen koti kwizet takuŋkozin.” ");
INSERT INTO naf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Zemann imbi ke dunduye, “Neŋ Kawawaŋaŋ Islael maŋge sipsip galaŋ zenzeŋaŋ keboŋ keyet zemneme kwatoban.” ");
INSERT INTO naf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Zeme imbiyaŋ koti Zisasiyet kendaŋaŋ pedondom samti zeye, “Amobotnaŋ, geŋ namukulem mne.” ");
INSERT INTO naf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kegok zeme Zisasiyaŋ ewe dunduye, “An imbi nemba ekŋengalen meu butnaŋ mti tam indame ŋep ku benak.” ");
INSERT INTO naf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Zeme zet dopmaŋ kapigok gilik zemti saye, “Amobotnaŋ, neŋ Islael maŋgeen ku sokbembeŋaŋ e ŋep zenik, yaŋgut tam ekŋenaŋ meu pâpmaŋ toweme ke ŋep manip.” ");
INSERT INTO naf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kegok zeme nâmti pigok zeye, “Imbi, nâmkiŋpependi temaŋ penaŋ. Keyepmti yaŋkwesinik keyet kataŋ ŋep sokbemgasem.” Zisasiyaŋ kegok zeme keyegak nembaŋaŋ dolakŋaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Âpme Zisasiyaŋ msat keyet peme tapme Galili tundua ganzenaset meti kalaŋan pataŋ zemti mot totage. ");
INSERT INTO naf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Am sambe penaŋ ekŋenaŋ ekmagen kopmâbien. Am notnaŋ sebelin wesiŋ ma zikalin beŋaŋ ma am kopa ma zawalinmak notnaŋ sambe indatimti Zisasiyet kandaŋan maŋge bemindeme indaweyaŋ indeye. ");
INSERT INTO naf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Âpme am kopa ekŋenaŋ zet zewien ma sebelin wesiŋ ekŋenaŋ pembenaŋ bewien ma zikalin beŋaŋ ekŋenaŋ zikalin ekbien. Ke mme amnaŋ ke ekti nâmtemtem mti Islael am ekŋengalen Kawawaŋ zemsesewatpewien. ");
INSERT INTO naf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kegok mti egaŋ nembaŋane nin dinndoye, “Am kasup tuk ninmak tapmien ya alak meuŋinpiŋ talipgapmti neŋ am ekŋengat kembeŋ penaŋ miyap. Mneti meupiŋ zemindema meti selen meuyet zikat gililiŋ mseip keyet yayaŋ mimindeyap.” ");
INSERT INTO naf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Zeme nin yaŋkwesiwenn, “Msat tuŋgupman pi meu desetgatnaŋ aikti indasenup ma am sambe penaŋ indamann nime ŋep bemindesem?” ");
INSERT INTO naf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kegok yaŋkwesimann egaŋ gilik zem ndayaŋkwesimti zeye, “Inmagen nupmamaŋ zigok tazin?” Kegok ndayaŋkwesime nin zewenn, “Nupmamaŋ 7 ma aŋgala isikŋaŋ bugan tazin.” ");
INSERT INTO naf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kegok zemann Zisasiyaŋ am zemindeme totabien. ");
INSERT INTO naf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Totapme egaŋ nupmamaŋ 7 ma aŋgala ke mti Kawawaŋgat, “Wisikŋ,” zemti mutumti nembaŋane nin ndame am kalaŋti indawenn. ");
INSERT INTO naf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Indamepmann am sambe ekŋenaŋ nim kiŋgapme butnaŋ tapmege ke makumti beme tise 7 gak zem tage. ");
INSERT INTO naf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Meu nimbien ke an ekŋen makumann 4 tausen kegok bewien. Âpme imbi ma nemba ekŋen ku indamakuwien. ");
INSERT INTO naf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kegok mti egaŋ am zemindeme mekopme ek ma nembaŋane nsakwep waŋgaen moti met Magadan msalen pataŋ zewenn. ");
INSERT INTO naf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Âpme Palisi ma Sadusi ekŋenaŋ Zisasmagen koti tetimaemaeyelen toweme ekne zemti mbien, “Geŋ menok mmane nin Kawawaŋgalen windeŋaŋ geŋmak tazin beme eksenup.” ");
INSERT INTO naf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kegok zeme egaŋ diindoye, “In kululuŋ piliŋ piliŋ penaŋ tapme ilak mtete kan bein manzeip. ");
INSERT INTO naf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma mseŋan manzeip, ‘Kululuŋ sop kumti map tosâpm,’ manzeip. In kululuŋen ekme mopme msat keyet sepemaŋ eknâmamip keyaŋgut nâlen muluwaŋ masokbein ke eknâm mamiwaŋgut weyaŋti yaŋaŋ ku maeknâmâtâlip. ");
INSERT INTO naf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","In am msat alak kan kapiyet talip in bekanaŋ penaŋ ma Kawawaŋ mambamkumpemti mamaip. In neŋ menok mimiyet nâmti tatnapitilip? O alak yek, yaŋgut in menok kwewetaŋ Kawawaŋaŋ golaŋ zenze an Zonamagen mgeen keboŋ bam ekbep. Menok ŋen ku msap.” Kegok zemti indem mege. ");
INSERT INTO naf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Âpme nembaŋane nin meun kandati pemann tapme Zisasmak nin tundua kutumti nembet motiŋgut otnâmbenn. ");
INSERT INTO naf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Moti Zisasiyaŋ kapigok dinndoye, “In Palisi ma Sadusi ekŋengalen yis plawa manzim semen keyet weyaŋ eksemti mambep.” ");
INSERT INTO naf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kegok zeme nin nâwennen egaŋ nupmamaŋgat tazen ke nâmti nin kegok otnâmti zenâ zenâ mbenn, “Meu ku mkotngapmti kegok zein.” ");
INSERT INTO naf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Zet kegok tazemann Zisasiyaŋ nâmti ndayaŋkwesiye, “In kwilekiyet meu kum kolo keyet zenâ zenâ tapmip? Nâmkiŋpepeŋin âlâgâlâk. ");
INSERT INTO naf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Neŋ ŋep menok mti meu aikbak. In ke ku nâmâtâlip, ma? Neŋ nupmamaŋ keyaŋ an 5,000 indama nimkiŋgapme butnaŋ tapme tise zigok beme gak zeye? In ke ku nâmtalip? ");
INSERT INTO naf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma nupmamaŋ 7 ke timti keyaŋ an 4,000 indama nimkiŋgepme in maiŋ timti tise zigok beme gak zeye? ");
INSERT INTO naf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Neŋ melesiŋ palawa manzim semen keyet penaŋgat ku zeya. Neŋ bemzenze zet zema in eneyet ku nâmâtâlo? Palisi ma Sadusi ekŋengalen zet dâsukiyet weyaŋ eksemti mambep keyet kegok zeya!” ");
INSERT INTO naf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Zet kegok dinndome nembaŋane nin nâmâtâbenn ke nupmamaŋgalen melesiŋ palawa manzim semen keyet ku dinndoye keyaŋgut egaŋ golaŋ zet Palisi ma Sadusi ekŋengalen zet dâsuki mâbiek keyet nâmti dinndoye. ");
INSERT INTO naf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Zisas egaŋ Sisalia Pilipai mka temaŋen keyet sokŋanik kot pataŋ zemti nembaŋane ningat ndayaŋkwesiye, “Am ekŋenaŋ Angat Nemuŋaŋ nâgât kwi manzeip?” ");
INSERT INTO naf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kegok zeme nin dunduwenn, “Notnaŋ ekŋenaŋ, ‘Zân tu zululut,’ an manzeip. Notnaŋaŋ, ‘Ilaiza,’ manzeip ma notnaŋaŋ, ‘Zelemaia,’ ma, ‘Golaŋ zenze an notnaŋ itnaŋaŋ,’ manzeip.” ");
INSERT INTO naf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kegok dundumann ndayaŋkwesiye, “Âpme in nâgât kwi manzeip?” ");
INSERT INTO naf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kegok ndayaŋkwesime Saimon Pitayaŋ zeye, “Geŋ Kilais, Kawawaŋaŋ an ombempepeŋaŋ ke ilak geŋ. Kawawaŋ kwesiŋ kwesiŋ mambe egat Nemuŋaŋ.” ");
INSERT INTO naf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Zeme Zisasiyaŋ Saimon Pitayet zeye, “Saimon Zonayet nemuŋaŋ, gâgât nâma tikŋaŋ bein. Nânâ ke am ŋenaŋ ku zemgap. Bipm kululuŋenaŋ zemkawaŋ bemgain. ");
INSERT INTO naf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Keyepm gâgât zeyap, geŋ kwidi alakŋaŋ Pita. (Ningalen zeleset ‘nanzaŋ katikŋaŋ’.) Geŋ zenak, nâgât Kawawaŋgat Nemuŋaŋ zenak. Zet ke ŋotekŋaŋ penaŋ keyepmti nâgât amnaŋ nâmkiŋpemneme ondek indema Sadaŋgalen windeŋaŋaŋ ku indawalabe. ");
INSERT INTO naf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Neŋ winden gama geŋ am ekŋen Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ mkawaŋ bemane ekŋenaŋ nâgât nâmkiŋpewep beme geŋ ekŋengat pigok diindowanik, ‘In Kawawaŋgalen zemâtâtâtgat katnanen mama keŋan ŋep mebep.’ Kegok zewanik. Kegok mmane Kawawaŋaŋ nâmti zewe, ‘Am in ke nâlen zemâtâtâtgat katnanen mama keŋan ŋep kobep.’ Kegok zewe. Âpme naman geŋ am ekŋen Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ mkawaŋ bemane ekŋenaŋ nâgât ku nâmkiŋpewep beme geŋ ekŋengat pigok diindowanik, ‘In Kawawaŋgalen zemâtâtâtgat katnanen mama keŋan ŋep ku mebep.’ Kegok zewanik. Kegok mmane Kawawaŋaŋ nâmti zewe, ‘Am in ke nâlen zemâtâtâtgat katnanen mama keŋan ŋep ku kobep.’” Kegok zewe. ");
INSERT INTO naf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kegok zemti nembaŋane nin zemkatik bem ndemti zeye, “Neŋ kwitn Kilais keyet zapatnaŋ am ŋen ku diindome nâmbep.” ");
INSERT INTO naf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kan keyetnaŋ Zisasiyaŋ yaŋbemti nembaŋane nin kapigok zemkawaŋ bemndeye, “Neŋ Zelusalem mkaen mopma sesewat mka temaŋgalen an damuŋ ma sâpe sâpe bumbu an ŋeŋaŋ ma an zii zet zikat indanda ekŋenaŋ sek sindem namti gakikien newep. Keyaŋgut kasup mulup mimi tuk delaŋ zeme neŋ gilik zem wati mamaen kwabap.” ");
INSERT INTO naf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kegok dinndome Pitayaŋ Zisas igak zem mandamti zemkulumpemti dunduye, “Amobotnaŋ, geŋ Kawawaŋaŋ aŋgalaŋ geme kwitnaŋ kwitnaŋ keboŋaŋ ku sokbemgawe penaŋ.” ");
INSERT INTO naf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Zeme Zisasiyaŋ gilik zemti Pita pigok dunduye, “Sadaŋ, geŋ sebe! Geŋ setn bekeknik. Geŋ zet zenik ke Kawawaŋgalen ŋoktikŋaŋgatnaŋ yek, amgat ŋoktikŋinan etaŋ tazinen ke nânik.” ");
INSERT INTO naf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kan keyegak Zisasiyaŋ nembaŋane nin pigok dinndoye, “In neŋ nâmâsât mbep beme in sekŋinaŋgalen tikŋaŋ bamkumpemti in zewep, ‘Neŋ ikŋaŋ gakiwe kegogak neŋ mopmaneti gakiwap beme keyaŋ ŋep bewe’. ");
INSERT INTO naf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Âpme an ŋen ek sekŋaŋgat yayaŋ mti zewe, ‘Neŋ ekmak ku gakiwap,’ zewe beme mama kanzizit ku tasawe. Ma an ŋen egaŋ sekŋaŋ nâgât talasiwe beme mama kanzizit ke ŋep tiwe. ");
INSERT INTO naf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","An ŋen ek msat palengalen kwitnaŋ kwitnaŋ sambe matim nalakzin beme egaŋ gakimti Kawawaŋgat, ‘Mama kanzizit tosayaŋ kwitiwap’ ke ku zewe. ");
INSERT INTO naf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nâip, neŋ Angat Nemuŋaŋ nen Bipmnaŋgalen windeŋaŋ ma busatnaŋaŋ keŋanen enselmak nenmak kwatobap. Kwatoti an imbi sambe mamaŋinaŋgat sepem dopmaŋ mutumindawap. ");
INSERT INTO naf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Neŋ penaŋ sukwep diindoma nâit, in alak talip kapi notnaŋ gakikipiŋ tapme neŋ Angat Nemuŋaŋ winden sosok mkawaŋ bemti mulupm mma eksâip.” ");
INSERT INTO naf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Âpme egaŋ gakimti wawatnaŋgat zapatnaŋ nembaŋane ningat mimindamti kasup mulup mimi 6 delaŋ peme keyet palaŋan Zisasiyaŋ Pita ma Zemsmak meniŋaŋ Zân indaikti ilinak kalaŋ ŋengat mowebien. ");
INSERT INTO naf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Motati ekme Zisasiyet sek sepemaŋ asekti mamanamaŋ beme zimosetnaŋ busatnaŋ kasup nemboŋ sokbeme melakanduŋaŋ busatnaŋ leŋganaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kegok sokbeme nembaŋane tuk ekŋenaŋ Mosesimak Ilaiza kululuŋengatnaŋ koti Zisasmak zapat tapmmalu indikbien. ");
INSERT INTO naf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Keyepmti Pitayaŋ zemkawaŋ bemti Zisasiyet zeye, “Amobotnaŋ, kapi tatnup pembenaŋ penaŋ! Nâmane ŋep beme mzalaŋ tuk walasenup kwep gâgât ŋen Mosesiyet ma ŋen Ilaizayet.” ");
INSERT INTO naf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kegok zeme zanza busatnaŋaŋmak piyaŋ indasumuŋme zanza keŋanen zet ŋande ŋenaŋ kapigok zeye, “Kapi nanaŋgat Nemun penaŋ; egat nâmtikŋaŋ mampeyap. Neŋ ek ombempewanaŋ am yomengatnaŋ indati kwabe keyet oloŋen miap. In egat zetnaŋ gawepuwep.” ");
INSERT INTO naf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kegok mme nembaŋane ekŋenaŋ zet ŋande ke nâmti igagen kiŋgati ŋenzimoselin ambulut tabien. ");
INSERT INTO naf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mme Zisasiyaŋ kot indataŋgumti zeye, “Walit, ku kiŋgalit.” ");
INSERT INTO naf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Zeme ekŋenaŋ ekme am ŋenpiŋ; Zisasiyaŋ igak tage. ");
INSERT INTO naf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Keyetnan toti Zisasiyaŋ zemkulumindemti zeye, “In kwitnaŋ mamanamaŋ ego ke am ŋen diindondopiŋ tapme neŋ Angat Nemuŋaŋaŋ gakikiengatnaŋ gilik zem wapmaŋgut.” ");
INSERT INTO naf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zeme nembaŋaneyaŋ egat yaŋkwesiwien, “Kwilekiyet mti zii zet zikat indanda an ekŋenaŋ Ilaizayaŋ kukŋaŋgat kopme Mesaya An Kawawaŋaŋ amŋane yomengatnaŋ timekwatindendeyet ombempeye keyaŋ bam kobe manzeip?” ");
INSERT INTO naf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Zeme Zisasiyaŋ pigok zeye, “An ŋen sepemaŋ Ilaizanok kukŋaŋgat penaŋ koti am ŋoktikŋin mkawaŋ bemindemti kwitnaŋ kwitnaŋ sambe weyaŋme pembenaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yaŋgut neŋ pigok diindowi: An ke Ilaizanok tipman baen kopme am ekŋenaŋ ku nâmâtâti yuŋgu yuŋgu msawien. Sepem kegok yegak neŋ Angat Nemuŋaŋ yuŋgum nawep.” ");
INSERT INTO naf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Zeme nembaŋane nin zet ke Zân tu zululut angat tazein ke nâmbenn. ");
INSERT INTO naf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kegok mti Zisasmak nembaŋane nin am maŋgeen kopataŋ zemann an ŋen Zisasiyet kandaŋan kot pedondom tati ");
INSERT INTO naf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","zeye, “Amobotnaŋ, nâgât nemunaŋgat kembeŋ mi. Ek miakimbe omba kan kataŋ sokbemsame tewen ma tuyen matozin. ");
INSERT INTO naf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kegok mame neŋ nembandine ekŋenmagen tetim kopma ekŋenaŋ ŋep ku weyaŋpeyo.” ");
INSERT INTO naf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Zeme Zisasiyaŋ zeye, “In nâmkiŋpepeŋinpiŋ. In set teŋ ku mamâlip! Neŋ inmak kwesiŋ mamti indamukulem mma ewe in nâgât ku nâmkiŋpenep. Anemba neŋmagen tetim kolit.” ");
INSERT INTO naf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aik kopme Zisasiyaŋ we bekanaŋ zet msame keyegak nemba pemti mepme nembayaŋ dolakŋaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Âpme nembaŋane nin Zisas igak tapme koti yaŋkwesiwenn, “Nin eneyet we bekanaŋ mâpmâgat olapmann bep?” ");
INSERT INTO naf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Zemann dinndoye, “Nâmkiŋpepeŋin âlâgâlâk keyepmti we bekanaŋ ke ku zempeyo. Neŋ penaŋ diindowi, in nâmkiŋpepeŋin penaŋaŋ isikŋaŋ bugan kabis alik katnaŋ isikŋaŋ bugan keboŋ taindanak beme nukŋaŋ kapi delaŋ zek zeme ŋep delaŋ zemâtnak. In kwileki ŋengat ku olabiek.” ");
INSERT INTO naf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","We bekanaŋ ekŋen keboŋ ke kwileki ŋen belakŋaŋaŋ ku indamâbâgalen. ");
INSERT INTO naf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Âpme maneti nembaŋane nin nsakwep Galili msalen meti Zisasiyaŋ nin kapigok dinndoye, “Pi maman kan belaknik neŋ Angat Nemuŋaŋ am ekŋengat belinan neme mopma ");
INSERT INTO naf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nome gakimti kasup tuk tati wabap.” Kegok zeme nâmti nin kembeŋ penaŋ mbenn. ");
INSERT INTO naf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Âpme Zisas ma nembaŋane nin Kapenuam mkaen koti sesewat mkayelen takis titi an ekŋenaŋ koti Pita yaŋkwesiwien, “Ingalen an zikat indandaŋin sesewat mka temaŋgalen takis ke mambein, ma?” ");
INSERT INTO naf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kegok zeme Pitayaŋ zeye, “Âk. Mambein.” Kegok zemti Zisasiyaŋ mka mawemtanen moti zet ewe dundupiŋ tapme Zisasiyaŋ yaŋkwesimti zeye, “Saimon, geŋ zigok nânik? Msalengalen amobotnaŋ ekŋenaŋ takis kwimagen matip? Noline ekŋenmagen ma maŋge notnaŋ ekŋenmagen matip?” ");
INSERT INTO naf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Zeme Pitayaŋ zeye, “Maŋge notnaŋ ekŋenaŋ mambeip; noline ekŋenaŋ ku mambeip.” Zeme Zisasiyaŋ zeye, “Neŋ Kawawaŋgat Nemuŋaŋ keyepm neŋ ku bewakgalenaŋgut beyap. ");
INSERT INTO naf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mneti nin ekŋen ku indamann ŋenzinziŋ mseip keyepm tunduaen meti uk pemane towepme aŋgala ŋen ŋeŋaŋ mandasenigen keyet kaŋgalemaŋ keŋan mânep mti geŋ sesewat mka temaŋgalen takis nâgât ma gâgât sepem bembeyelen aiksenik. Ke mmeti ndaŋgat takis besenik.” ");
INSERT INTO naf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kan keyet nembaŋane nin Zisasmagen koti yaŋkwesiwenn,” Kwiyaŋ Kawawaŋgalen zemâtâtâtgat katnanen mama keŋangalen amobotnaŋ bein?” ");
INSERT INTO naf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Âpme Zisasiyaŋ nemba isikŋaŋ ŋen zeme kopme tuŋguwinan pemti ");
INSERT INTO naf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","zeye, “Neŋ penaŋ sukwep diindowi, in keŋin ku gilik zeme nemunamba isikŋaŋ ekŋengat sepem mambe beme Kawawaŋgalen zemâtâtâtgat katnanen mama keŋan ku mobep. ");
INSERT INTO naf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","An ŋenaŋ ikŋaŋgat nâme topme nemba isikŋaŋnok mambe beme egaŋ Kawawaŋgalen zemâtâtâtgat katnanen mama keyet keŋan ŋeŋaŋ bein. ");
INSERT INTO naf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Geŋ neŋmak tusuwanan keyepm geŋ nemba isikŋaŋnok ke mukulem mbanik beme geŋ neŋ namukulem mnewanik bein. ");
INSERT INTO naf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","An ŋenaŋ nemba isikŋaŋnok ekŋengat nâmkiŋpepeŋin walebe beme ek ke nanzaŋ siput temaŋ bimanen andopemti âtâpeme nembu keŋan towebe keyaŋ nukŋaŋ ku ben. Kawawaŋgalen zemdelaŋ zenze katnaŋ dopmaŋ nukŋaŋ penaŋ tiwe. ");
INSERT INTO naf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wakae, msat palen inmagen sindem omba penaŋ tiwep enenogat msalen bekanaŋ mimi omba penaŋ tazin ma yommagen keŋ yuŋguŋgu omba wen ma ŋen an ŋenaŋ notnaŋaŋ zet kelakŋaŋ mti yom mbalup beme Kawawaŋaŋ an zet kelakŋaŋ mbe ke sindem omba penaŋ sawe. ");
INSERT INTO naf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Keyepm sedaŋ ma bedaŋ yomeset gatetimti mesât mbe beme eleŋgempemane mepme wesiŋ mambanik. Mineti geŋ sedi bedi ilindiŋ mmaneti teziŋ ŋandaŋ towebanigat ŋen eleŋgemti pemane mebe. ");
INSERT INTO naf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma zikatdaŋ mme bekanaset gatetimti mesât mbanik beme geŋ kwenzempemane mepme nembet etaŋgat mambanik. Mineti geŋ zikadi ilindiŋ mmaneti teziŋ ŋandaŋ towebanikgat ŋen kwenzempemane mebe. ");
INSERT INTO naf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Weyaŋ ekti mambep. In maŋgeŋine nemba isikŋaŋnok ekŋengat nâme tototnaŋ penaŋ ku bewep. Neŋ keyet zema nâit, enselŋine kululuŋen maip ekŋenaŋ Biengat zimosetnan mamaip ekŋenaŋ in zem indowep. ");
INSERT INTO naf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Angat Nemuŋaŋ neŋ am galaŋpepeŋaŋ indatimat titiyelen toban. ");
INSERT INTO naf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","In zigok manâip? An ŋen sipsipmaŋ 100 mamambiegaŋ ekŋenmagengatnaŋ kwep galaŋ zenak beme zigok mnak? Egaŋ 99 indeme tapme kwep galaŋ zenak keyet didikŋan timatnak. ");
INSERT INTO naf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Neŋ penaŋ diindoyap, ek matimatneti aikzin beme 99 ekŋengat oloŋen ku mti kwep galaŋ zenzeŋaŋ keyet oloŋen penaŋ mnak. ");
INSERT INTO naf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sekam kegogak Biwin kululuŋenaŋ nemba isikŋaŋnok kwep ŋenaŋ ku galaŋ zenzeyelen maotnâin. ");
INSERT INTO naf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Âpme nodaŋ geŋmagen yom aikzin beme geŋ gitak buzagen yomaŋ zemzikat samane egaŋ zedi nâin beme geŋ nâmane delaŋ zeme notn mpewanik. ");
INSERT INTO naf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Âk egaŋ zedi ku nâme geŋ an kwep ma zut indatetimti yaŋaŋ ilinsakwep nâmti in yom ke mukulem mpemti bandim bandim mti zikat sawep. ");
INSERT INTO naf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yaŋgut egaŋ ingalen zelin ku nâme dapmelaŋge ekŋenmak weyaŋ bep. Dapmelaŋgeyet zelin kulume egat nâme nâmkiŋpepeŋepiŋ beme egat zewep ek an zet kululu keboŋ bein. ");
INSERT INTO naf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Âpme neŋ penaŋ sukwep diindowi, neŋ winden gama geŋ am ekŋen Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ mkawaŋ bemane ekŋenaŋ nâgât nâmkiŋpewep beme geŋ ekŋengat pigok diindowanik, ‘In Kawawaŋgalen zemâtâtâtgat katnan mama keyet keŋan ŋep mebep.’ Kegok mmane Kawawaŋaŋ nâmti zewe, ‘Am in ke nâlen zemâtâtâtgat katnanen mama keyet keŋan ŋep kobep.’ Kegok zewe. Âpme naman geŋ am ekŋen Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ mkawaŋ bemane ekŋenaŋ nâgât ku nâmkiŋpewep beme geŋ ekŋengat pigok diindowanik, ‘Kawawaŋgalen zemâtâtâtgat katnan mama keyet keŋan ŋep ku mebep.’ Kegok mmane Kawawaŋaŋ nâmti zewe, ‘Am in ke nâlen zemâtâtâtgat mama keyet keŋan ŋep ku kobep.’ Kegok zewe. ");
INSERT INTO naf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Ma neŋ ewe tusumti diindowi, an zut tuk ekŋenaŋ neŋmak tusumti ondekbep beme neŋ ekŋengat tuŋguwinan mamti egat zut egelaŋ kwileki ŋengat keŋ kwep bemti dundumalu Biwin kululuŋenaŋ nâmindawe.” ");
INSERT INTO naf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Zeme Pitayaŋ Zisasmagen koti zeye, “Amobotnaŋ, âpme notn ŋenaŋ yom mname sek zigok beme neŋ yomaŋ katikpewap? Sek 7 katikpewap, ma?” ");
INSERT INTO naf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yaŋkwesime Zisasiyaŋ dunduye, “Sek 7 yek. Sek sambe yomaŋ katikpemti ku makuwanik. ");
INSERT INTO naf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Neŋ kapigok diindowi, Kawawaŋgalen zemâtâtâtgat katnan mama ke kapigok, kan ŋengat amobotnaŋ ŋenaŋ sisiliŋ anene dopmaŋ mutumsasayelen indamandaye. ");
INSERT INTO naf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yaŋbemti kwep kukŋaŋgat aikobien egalen dopmaŋaŋ mânep temaŋ penaŋ. ");
INSERT INTO naf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Egaŋ dopmaŋ temaŋ ke ŋep mututuyelen ku tasaye keyepm amobotnaŋaŋ an ikŋaŋ ke ma imbi nembaŋane ke mânep tosaŋaŋ mututuyelen ma mka ma bo milawatnaŋ ilindiŋ am belakŋaŋ ekŋenaŋ kwitime mânep dopmaŋ ke titiyelen zeye. ");
INSERT INTO naf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kegok zeme sisiliŋ anaŋ amobotnaŋgat kandaŋan pedondom samti zekâkât mpemti zeye, ‘Amobotnaŋŋ, geŋ naŋgalaŋmane neŋ gâlen mânep ilindiŋ ŋep gawap.’ ");
INSERT INTO naf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Zekâkât kegok mti dundum same amobotnaŋaŋ kembeŋ mti dopmaŋ ku mututuyelen zeye. ");
INSERT INTO naf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kegok zempeme egaŋ toti mulup an notnaŋ ŋen ekmagen mânep isikŋaŋ mge ekmagen dopmaŋ titiyelen aikti bimaŋ misik misik mti zeye, ‘Geŋ nâlen mânep dopmaŋ geŋmagen tazin ke mutumna.’ ");
INSERT INTO naf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kegok zeme an notnaŋaŋ egat kandaŋan pedondom samti zekâkât mpemti zeye, ‘Geŋ naŋgalaŋmane neŋ gâlen mânep ilindiŋ ŋep gawap!’ ");
INSERT INTO naf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dundum same kembeŋ ku mti notnaŋ mka katikŋanen pemti zeye, ‘Geŋ dopmaŋ mutu namaneŋgut belak geme kwewebanik.’ ");
INSERT INTO naf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kegok sokbeme mulup an notnaneyaŋ ekti keŋin bekanaŋ beme amobotnaŋmagen meti zapat ke msawien. ");
INSERT INTO naf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Msame amobotnaŋaŋ nâmti sisiliŋ an zeme kopme dunduye, ‘Geŋ keŋ katik penaŋ. Geŋ zekâkât mnamane neŋ gâgât kembeŋ nâmti sewakŋaŋ mgema geŋ dopmaŋ ku nawanan. ");
INSERT INTO naf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Âpme neŋ dopmaŋdi katikpema geŋ kwilekiyet nodaŋgat kembeŋ ku mbanan?’ ");
INSERT INTO naf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kegok zemti an ke ŋenzinziŋ omba msamti mka katikŋan pemti damuŋ ekŋengat pigok zemindeye, ‘In an kapi damuŋ mti sek sindem omba masamotnepeme nâlen mânep dopmaŋ mutum delaŋ zeme kwalet pewep.’” ");
INSERT INTO naf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ke zemti Zisasiyaŋ bemzenze zet ke zemdelaŋ zemti yaŋaŋ kapigok zeye, “In nolineyelen yom keŋinan penaŋ ku katikpeme kululuŋ Biwinaŋ ingalen kegok ku katikpewe.” ");
INSERT INTO naf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Âpme Zisasiyaŋ zet yaŋaŋ yaŋaŋ zemdelaŋ zemti egaŋ Galili msat katipemti Zudia msalen Zodan tu nembet mepme ");
INSERT INTO naf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","am maŋge temaŋ mâti mepme zawatmak ekŋen weyaŋindeye. ");
INSERT INTO naf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mme Palisi ekŋenaŋ ek tetipeme ekŋengalen tetimaemaeyelen toweme eksâgât koti yaŋkwesiwien, “Kawawaŋgalen zii zelaŋ anaŋ imbiŋaŋ kwitnaŋ kwitnaŋ sambe myuŋgume asekpepeyelen zein, ma yek?” ");
INSERT INTO naf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kegok yaŋkwesime Zisasiyaŋ kapigok diindoye, “In Kawawaŋgalen Zet Itnaŋaŋen ku mamakuip, ma? Ke kapigok kumpepeŋaŋ, ‘Kawawaŋaŋ yaŋbembeŋaŋ baen an ma imbi weyaŋideye’. ");
INSERT INTO naf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Weyaŋidemti kapigok zeye, ‘An ŋen ek mamaŋ bipmaŋ katim idemti imbiŋaŋmak tusumti eget kwepnok bewalup.’ ");
INSERT INTO naf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Keyepm eget ewe zut yek; kwepnok talup. Kawawaŋaŋ temakwep tusumidein keyepm amnaŋ it kalaŋidendeyelen yek.” ");
INSERT INTO naf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Zisasiyaŋ kegok zeme Palisi ekŋenaŋ pigok yaŋkwesiwien, “Âpme kwilekiyet mti Mosesiyaŋ zii zelen an ŋenaŋ imbiŋaŋ asekpepeyelen meluwaŋ kumsamti peme mebegalen nâmindeye?” ");
INSERT INTO naf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kegok yaŋkwesime Zisasiyaŋ zeye, “In keŋ katik mamti Kawawaŋgalen zetnaŋ ku mamâlip ma in imbiŋin asekpepeyelen manâip keyepm Mosesiyaŋ ke zeye. Yaŋbembeŋaŋ baen set kegok ku tage. ");
INSERT INTO naf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Keyepm neŋ diindoma nâit, An ŋenaŋ imbiŋaŋ kwitnaŋ kwitnaŋ bekanaŋ ku mme nâmbemti imbiŋaŋ asekpewe beme keyaŋ yom. Âk imbiŋaŋaŋ set kileŋ mame apmaŋaŋ asekpewe beme keyaŋ ŋep bewe.” Âk anaŋ imbiŋaŋaŋ kegok ku mme egaŋ imbiŋaŋ ŋen wabe beme ek set kileŋ anok bewe. ");
INSERT INTO naf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Zeme nembaŋane nin nâmti pigok zewenn, “Awembiŋ mamayelen kegok bein beme imbi wawapiŋ mama keyaŋ ŋep bein.” ");
INSERT INTO naf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Zemann Zisasiyaŋ kapigok dinndoye, “Zet ke am ilindiŋ ekŋengalen zapat yek. An kwep kwep Kawawaŋaŋ indamukulem mim ekŋengat zapaletaŋ. ");
INSERT INTO naf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Anaŋ imbi wawapiŋ belak maip ke yaŋaŋ tuk kapigok: Notnaŋ ekŋen keŋin mamkeŋ kegok masokbeip ma notnaŋ amnaŋ sekŋin butnaŋ walet indendeŋaŋ awembiŋ bembeyelen tikŋaŋ ku nâip ma notnaŋ keŋ sekŋin Kawawaŋgalen mulup mimiyet nâmti awembiŋ ku mambep. An ŋenaŋ mama mimi delaŋ zenzeŋaŋ kapi mâsât mbe beme ŋep mâbe.” ");
INSERT INTO naf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Âpme an imbi ekŋenaŋ nemunambaŋine isisikŋaŋ Zisasmagen indatim kopme egaŋ betnaŋaŋ sekŋinan bemti dundum indendeyet ilinak zenâwien. Zemeŋgut nembaŋane nin am ekŋen zemkulumindewann. ");
INSERT INTO naf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kegok mmann Zisasiyaŋ, “Nemba indeme neŋmagen kolit. In ku zemkulumindeit,” kegok zeye. “Am ekŋen nemba isikŋaŋ keboŋ ekŋen Kawawaŋgalen zemâtâtâtgat katnan mama keyet kandaŋan mamaip.” ");
INSERT INTO naf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kegok zemti betnaŋ sekŋinanen belaŋ atamti dundum indemti mege. ");
INSERT INTO naf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Msat ke pemti mepmann an zomolim ŋenaŋ Zisasmagen koti yaŋkwesiye, “An zikat indanda, neŋ mulup dolakŋaŋ ŋen ziboŋ mti mama kanzizitgat zapat bewap?” ");
INSERT INTO naf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kegok zeme Zisasiyaŋ kapigok dunduye, “Kwitnaŋ kwitnaŋ dolakŋaŋgat eneyet tatnayaŋkwesinik? Msalen kapi an dolakŋaŋ ŋen ku tazin. Kawawaŋ kwewetaŋ an dolakŋaŋ. Âpme geŋ mama kanzizitgat zapat besâgât mbanik beme zii zet gawepumane delaŋ zemâbe.” ");
INSERT INTO naf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Zeme an keyaŋ zeye, “Zii zet ziboŋ?” Ke zemti yaŋkwesime Zisasiyaŋ zeye, “Geŋ kasa kumti am ku kumane gakiwe, awembiŋ kalalaŋ ku mbalup, kambu ku mbanik, ma am ŋengat sekŋan dâsuki bem zenzepiŋ. ");
INSERT INTO naf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Geŋ mambipdi eksemidewanik. Mti gitangat gogot mamnik sepem kegogak amgat gogot mbanik.” ");
INSERT INTO naf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Zeme an zomolim keyaŋ kapigok dunduye, “Ke zenigen ke elak gawepumti mamiap yaŋgut ŋen ewe zigok mbap?” ");
INSERT INTO naf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kegok zeme Zisasiyaŋ dunduye, “Geŋ teŋ penaŋ mamasât nâwanik ma mama kanzizit ke tisâgât nâwanik beme met milawadi bemane kwitime keyetnaŋ mânep ke kalaŋ kumti am bekopsat indamâbanik. Kegok mbanik beme kululuŋen gwaen kwitnaŋ kwitnaŋ dolakŋaŋ geŋ tiwanik. Kegok mti neŋmak tusumti namâbanik.” ");
INSERT INTO naf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Zeme an zomolimaŋ mânep milawatnaŋ temaŋ tage keyepmti keŋaŋ beme zetnepiŋ mege. ");
INSERT INTO naf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mepme Zisasiyaŋ nembaŋane nin kapigok dinndoye, “Neŋ penaŋ zema nâit, am mânep milawalin temaŋ ekŋenmagen Kawawaŋgalen zemâtâtâtgat katnan mama keyet keŋan mebegalen olalatnaŋmak bewe. ");
INSERT INTO naf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bo temaŋaŋ buŋi aimboŋaŋ isikŋanen ŋep ku modak. Sepem kegogak am mânep milawalinmak ekŋenaŋ Kawawaŋgalen zemâtâtâtgat katnanen mama keyet keŋan mobogalen pepepeŋaŋ omba penaŋ tazin.” ");
INSERT INTO naf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kegok zeme nembaŋane nin zet ke nâmann nukŋaŋ penaŋ beme zewenn, “Kegok beme kwiyaŋ mama kanzizit ŋep tiwe?” ");
INSERT INTO naf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zemann Zisasiyaŋ zimosetnanen ndik mototi zeye, “Mânep milawalaŋ set bekekme amnaŋ Kawawaŋgalen zemâtâtâtgat katnan mama keyet keŋan ku mebep yaŋgut Kawawaŋaŋ amgat keŋin mme eleŋ belaŋ beme mama kanzizit ke ŋep tiwep.” ");
INSERT INTO naf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kegok dinndome Pitayaŋ sakwep penaŋ pigok zeye, “Nânik, nin kwitnaŋ kwitnaŋ sambe pemann tapme geŋ gapmâbenn keyepm maneti keyet dopmaŋ Kawawaŋaŋ kwileki penaŋ ndawe?” ");
INSERT INTO naf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kegok yaŋkwesime Zisasiyaŋ kapigok dinndoye, “Neŋ penaŋ sukwep diindowi. Maneti bamgat kwitnaŋ kwitnaŋ alakŋaŋ sokbemâbe kan keyet neŋ Angat Nemuŋaŋ Amobotnaŋgalen mundum windemak keyet totapma in kegogak mundum 12 keyet totati Islael maŋge 12 ekŋengat damuŋine tabep. ");
INSERT INTO naf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma am ŋenaŋ nâgât mti dapmeniŋene ipbialine ma mambiwine ma nemunambaŋine ma mkaŋin ma muluwin yaloŋti kobepgapm ekŋen keyet dopmaŋ omba penaŋ indayap ma bamgat mama kanzizit tiwep. ");
INSERT INTO naf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","An ŋenaŋ ikŋaŋgat sekŋaŋ alak pigogat mmoti, ‘Neŋ ŋep talap,’ tazein beme egaŋ bamgat tototnaŋ bewe. Ma ŋenaŋ alak tototnaŋ tapmain beme egaŋ bamgat mobotnaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kawawaŋgalen zemâtâtâtgat katnan mama keyet yaŋaŋ pigok, mse ŋengat an ŋenaŋ tambuŋan penaŋ an indatime wain mulupman mimiyelen mebien. ");
INSERT INTO naf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Egaŋ mulup mimiyelen tosa sepem kwep kina kwep kina kwep kegok indandayelen zetik mimindeme ekŋenaŋ, ‘Ŋep,’ zeme wain mulupmanen indatime mebien. ");
INSERT INTO naf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Meti tapmme 9 kilok beme an maŋge notnaŋ belak tabien ekŋenmagen meti diindoye, ");
INSERT INTO naf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘In kogogak kopme nâlen wain muluwen met indema mulup mme tosaŋaŋ ŋep indasap.’ ");
INSERT INTO naf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kegok zeme ilinsakwep wain muluwen ke mebien. Âpme 12 kilok beme sepem ewe kegogak mge. Mme 3 kilok beme ewe kegogak notnaŋ indatiye. ");
INSERT INTO naf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma 5 kilok beme ewe meti an notnaŋ mulup mimipiŋ tapme indikti diindoye, ‘In kwilekiyet kasup teepmaŋ pi belak tatnepeme msat gasim bein?’ ");
INSERT INTO naf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Zeme ekŋenaŋ zewien, ‘An ŋenaŋ mulup ke mseip ke nin ku zemndep.’ Zeme egaŋ diindoye, ‘Kopme nâlen wain muluwen meindema mulup mit.’ ");
INSERT INTO naf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ke tapme mulup tosaŋaŋ indandayelen damuŋ zempemti zeye, ‘Geŋ mulup an zemane kopmâpme mânep inda. An bam kolo ekŋen kukŋaŋgat indamti an ŋeŋaŋ kolo ekŋen bam indasenik.’ ");
INSERT INTO naf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kegok zempeme an mulup 5 kilokgat yaŋbemti mbien ekŋen mânep kina kwep kina kwep indaye. ");
INSERT INTO naf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taindame ŋeŋaŋ kobien ekŋenaŋ ekti, ‘Nin mânep mmoti ndasâpm,’ nâmti tatnepeme damuŋ egaŋ kina kwep kina kwep ekŋen kwep kwep indam mege. ");
INSERT INTO naf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mânep kegok indame ekŋenaŋ mulup toŋaŋgat ŋenzinziŋ msawien. ");
INSERT INTO naf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mti zewien, ‘An bam kolo ekŋenaŋ mulup belak kan isikŋaŋ bugan miyo. Âpme nin kasup katikŋaŋ penaŋ muluwen sek sindem palen tatnepemann msat gasim beme kwilekiyet bam kolo ekŋenmak mânep sepem kwep ndanik?’ ");
INSERT INTO naf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kegok zeme mulup toŋaŋaŋ ekŋenmagen kwep pigok dunduye, ‘Notn, geŋ ku tetiŋgeyap. Geŋ mânep kina kwepgat zema nâmane ŋep bep ");
INSERT INTO naf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","keyepm mânepdi mti met. Neŋ am bam kolo ekŋenmak geŋmak mânep sepem kwep indandayet nâma ŋep bep. ");
INSERT INTO naf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mânep nenaŋgalen ya neŋ zigok ma zigok msâgât mbak beme nâyap kataŋ mbak. Neŋ keŋ taolet mgama geŋ nâmbekananik, ma?’” ");
INSERT INTO naf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Âpme Zisasiyaŋ bemzenze zet ke zemdelaŋ zemti pigok zeye, “An ŋenaŋ Kawawaŋgalen zemâtâtât katnanen mama keyet keŋan ŋeŋaŋ mebe ma ŋenaŋ bam mebe keyaŋgut Kawawaŋaŋ eget ilizuzut mama kanzizit itdawe.” ");
INSERT INTO naf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Âpme Zisasiyaŋ Zelusalem mkaen mosât moti set ganzenaset nembaŋane nin 12 ndatime mepmambe kapigok dinndoye, ");
INSERT INTO naf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nâip, nin alak Zelusalem mkaen tapmetnup. Ya neŋ Angat Nemuŋaŋ sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ ma zii zet zikat indanda ekŋengalen belen mopma ekŋenaŋ nome gakikiyet zemdelaŋ zewep. ");
INSERT INTO naf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Âpme keyet palaŋan kasanne ekŋenaŋ Loma ekŋengalen gapman ekŋengat belinan neme mopma ekŋenaŋ pep zet mnamti sindiwaŋ nawetikti nome gakiwap. Yaŋgut kasup tuk delaŋ peme gakikiengatnaŋ gilik zem wati mamaen mobap.” ");
INSERT INTO naf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kan keyet Zân ma Zems Zebediyet nemulatnenetgat mamidaŋ idatimti Zisasiyet kandaŋan koti pedondom samti nâmitdendeyelen dundum saye. ");
INSERT INTO naf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kegok mme Zisasiyaŋ yaŋkwesiye, “Geŋ neŋ kwileki mgaŋgayelen gembein?” Zeme egaŋ zeye, “Geŋ zemkatik bemnamane nemun zut kapiyaŋ geŋ amobotnaŋ temaŋ tabanik kan keyet ŋenaŋ bedi penaset ma bedi alomset amobotnaŋ gitaŋgat kandaŋdan tabalup.” ");
INSERT INTO naf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kegok zeme Zisasiyaŋ indayaŋkwesiye, “In ku nâmti kegok yaŋkwesip. It neŋ sindem tiwap ke it ŋep tiwalup?” Zeme egelaŋ zewun, “E ŋep tiwalup.” ");
INSERT INTO naf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kegok zemalu Zisasiyaŋ zeye, “Neŋ sindem tiwap ke it penaŋ tiwalup yaŋgut nâlen betn penaset kwiyaŋ tatatgalen ma betn alomset tabe ke neŋ ŋep ku zenzeyelen. Mundum ekseseŋaŋmak ke Bienaŋ an kwi makumindeye ekŋengalen zapat tazin.” ");
INSERT INTO naf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kegok mme nemuŋane 10 nin keyet zapat nâmti egegat ŋenzinziŋ mbenn. ");
INSERT INTO naf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mmann Zisasiyaŋ nin ilindiŋ zeme kopmann dinndoye, “In nâip msalengalen amobotnaŋ ekŋen winde omba taindame zet windeŋaŋbeŋ msat palen am ekŋengat manzeip. ");
INSERT INTO naf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Set keboŋ ke ingat tuŋguwinan ŋen ku tabe. Keyepmti inmagengatnaŋ an ŋenaŋ amobotnaŋ besât nâin beme egaŋ in sambeyelen sisiliŋ an bewe. ");
INSERT INTO naf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma inmagengatnaŋ an ŋenaŋ amobotnaŋ Kawawaŋgat zikatnan besât nâwe beme egaŋ sisiliŋ nemba etaŋ kwati toŋaŋgat mulup etaŋ mpeme tosaŋaŋ ku masain keboŋ mamambe. ");
INSERT INTO naf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sepem kegogak neŋ Angat Nemuŋaŋ amnaŋ sisiliŋ mnanayelen ku koban yek. Neŋ am ekŋengat sisiliŋ mulup mimindandayelen koban ma am ekŋen nanaŋgat maman ketalasima amnaŋ mama kanzizit aiikgat nâmti gakikiyet toban.” ");
INSERT INTO naf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Âpme Zisas ma nemuŋane nin Zeliko msat pemti tapmepmann am maŋge temaŋaŋ ndamâti mebien. ");
INSERT INTO naf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Keyegak an zut zikalit beŋaŋaŋ set ganzenaŋ tapmambun, “Ya Zisas kwawezin,” zeme nâmti kwizet temaŋ kumti zewun, “Amobotnaŋ, geŋ Dewitgat alikŋaŋ, nigat kembeŋ mi!” ");
INSERT INTO naf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kegok zemalut amnaŋ eget zemkulumidemti buzak tatagalen diitdowien. Keyaŋgut egelaŋ ewe giŋgiŋ mti kwizet omba kuwun, “Amobotnaŋ, Dewitgalen alikŋaŋ, geŋ nigat kembeŋ mi!” ");
INSERT INTO naf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kegok zemalut Zisasiyaŋ metati idayaŋkwesiye, “It neŋ zigok mimidandayelen nâlup?” ");
INSERT INTO naf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kegok zeme egelaŋ zuwun, “Amobotnaŋ, nit eekgalen nâlup.” ");
INSERT INTO naf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kegok zemalut Zisasiyaŋ egegat kembeŋ mti zikalit taŋgume keyegak zikalit ekti ekmak mebun. ");
INSERT INTO naf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Âpme Zisas ma nembaŋane nin Zelusalem pataŋ zesât mti Betpage mkaen ke tati nembaŋanet zut kukŋaŋgat ");
INSERT INTO naf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","pigok zemideye, “It ŋeŋaŋ mkaen met pataŋ pepeŋak doŋki ŋen tegaŋ opemti tepum palen opepeŋaŋ nembaŋaŋ isikŋaŋ ganzenan tapme ekselup. Ke kwaleti idatetimti neŋmagen koselup. ");
INSERT INTO naf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kegok mmalut am ŋenaŋ zigok ŋen zeme, it pigok dunduselup, ‘Amobotnaŋaŋ kapiyet mulupmaŋ sasayelen zemndeme kolup.’ Kegok zemalut egaŋ keyegak nâmideme mkoselup.” ");
INSERT INTO naf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ke sokbeye ke eweŋan baenen golaŋ zenze an ŋenaŋ zet meluwaŋ kapi mge keyet kataŋ sokbemkawaŋ bein: ");
INSERT INTO naf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zaion mka temaŋgalen am diindo, ‘Egit, ingalen Amobotnaŋin ek inmagen kozin! Keŋ sewakŋaŋ toŋaŋ. Doŋki nembaŋaŋ isikŋaŋ milawat matin keyet dukŋan kozin.’” ");
INSERT INTO naf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Zeme nemba zulaŋ nâmti Zisasiyaŋ diitdoyenok met ");
INSERT INTO naf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","doŋki mam nemba idatetimti koti nin melakandundun sakŋaŋgatnaŋ gulumti doŋki egegat palen yeŋgepemann Zisasiyaŋ palaŋan mototage. ");
INSERT INTO naf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Âpme am maŋge temaŋaŋ egat set miakpepeyelen melakanduŋin timti selen yeŋgewien. Ma notnaŋaŋ niwet sinaŋ atumti selen yeŋgewien. ");
INSERT INTO naf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kegok mme am maŋge temaŋaŋ kalaŋti Zisasiyet ŋeŋaŋ ma baman meti kwizet kapigok kuwien, “Dewitgalen alikŋaŋ, nin sesewatgenup! Kawawaŋaŋ gaombem geŋgeŋaŋ kotnik keyet oloŋen penaŋ mti Kawawaŋ sesewatpene!” ");
INSERT INTO naf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kegok mme Zisasiyaŋ Zelusalem mka temaŋ keŋan mopme am mka mtoŋaŋ kwisak ke nâmti keŋin wapme yaŋkwesiwien, “An ke kwiyaŋ kozin?” ");
INSERT INTO naf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kegok yaŋkwesime am maŋge temaŋaŋ zewien, “Kapi Zisas. Ek golaŋ zenze an Nasalet Galili mkaengatnaŋaŋ kozin.” ");
INSERT INTO naf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","13","Ke moti Zisasiyaŋ sesewat mka temaŋ keŋan moti ekme amnaŋ makau ma sipsip sâpe sâpe bumbuyelen aem kwaem tapmambien. Mânep aem kwaem tapm mambiengalen mundumaŋ mgilik zeye ma sasakandenombe takwitimambien ekŋengalen mundum kegogak mgilik zemti diindoye, “Kawawaŋgalen Zet Itnaŋaŋen Kawawaŋaŋ pigok zeme meluwaŋ mimiŋaŋ, ‘Nâlen sesewat mka ke dundundu mka’ keyaŋgut in mme an kambu titi ekŋengalen enzilili mka tabein.” Kegok zemti am ekŋen ke zemindemti indamâpme toti kwawebien. ");
INSERT INTO naf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mme am zikalin beŋaŋ ma wesiŋ ekŋenaŋ sesewat mka temanen kopme weyaŋindeye. ");
INSERT INTO naf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ke tapmme nemba isisik ekŋenaŋ, “Dewitgalen alikŋaŋ, sesewatpene!” kwizet kegok kupeŋ keŋan mowepme sâpe sâpe bumbu an ekŋen ma zii zet zikat indanda ekŋenaŋ muluwaŋ mamanamaŋ ke ekti keyet ŋenzinziŋ penaŋ mti ");
INSERT INTO naf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Zisas yaŋkwesiwien, “Geŋ ekŋenaŋ kwileki tazep ke tatnânik?” Zeme Zisasiyaŋ diindoye, “Âk neŋ ŋep tatnâyap. In Kawawaŋgalen Zet Itnaŋaŋ ku mamakuip, ma? Ke kapigok kumpepeŋaŋ, ‘Geŋ nemba isisik ma nemba okak zikat indamane ekŋenaŋ gâgât sesewatgawep.’” ");
INSERT INTO naf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kegok mti Zisasiyaŋ ekŋen katiindemti Betani mkaen tambumbu kwep mepmaŋge. ");
INSERT INTO naf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Âpme tambuŋan penaŋ Zisasiyaŋ mka teman gilik zem kwakwagalen kwati meuyet mge. ");
INSERT INTO naf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mti ekme set ganzenaset pik tep tapme ekti katnaŋ niniyelen yayaŋ mge yaŋgut katnaŋ niniyelen ŋen tatapiŋ; sinaŋ etaŋ tage. Kegok ekti tepgat zeye, “Geŋ kadi ŋen ku elikbanik yek penaŋ.” Zeme keyegak tewaŋ memuŋ beye. ");
INSERT INTO naf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kegok sokbeme nembaŋane nin ekti pisemti yaŋkwesiwenn, “Zigogapm tep ke sakwep penaŋ memuŋ bep?” ");
INSERT INTO naf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kegok zemann Zisasiyaŋ pigok zeye, “Neŋ penaŋ sukwep diindowi, in keŋ zutmak ku mamti Kawawaŋgat nâmkiŋpewep beme in neŋ miyap sepem keboŋ mbep. Mti ke etaŋ yek, in nukŋaŋ kalaŋ nemboŋ keyet pigok zemsawep, ‘Nembu keŋan metot,’ zeme kegok mbe. ");
INSERT INTO naf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ma in nâmkiŋpewep beme ke ma ke mimiyet dundum same egaŋ ŋep mbe.” ");
INSERT INTO naf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zisas ek sesewat mka temanen gilik zem meti am zet zapat dolakŋaŋ tapm zikat indame sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋ keyelen an damuŋ ekŋenaŋ koti pigok yaŋkwesiwien, “An kwiyaŋ nâmgeme am sesewat mka temanen ke indamâbanan?” ");
INSERT INTO naf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kegok yaŋkwesime Zisasiyaŋ pigok zeye, “Neŋ yaŋkwesisi kwep penaŋ indayaŋkwesima, in dopmaŋ teŋ gilik zem nameŋgut neŋ an kwiyaŋ nâmneme mamiyap ke diindosap.” ");
INSERT INTO naf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kegok zemti zeye, “Zân tu zulutindende an ek am tu zulutindendeyelen an kwiyaŋ mulup ke saye? Kawawaŋaŋ nâmpeye ma amnaŋ nâmpewien?” Kegok zeme ekŋenaŋ ilinak zenâ zenâ mti zewien, “Nin zigok zesenup? ‘Kawawaŋmagengatnaŋ,’ zesenup beme egaŋ zet dopmaŋ pigok zesem, ‘Ya kok ke kwilekiyet mti ku nâmkiŋpewien?’ ");
INSERT INTO naf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma ‘Ammagengatnaŋ,’ zesenup ke nin am ekŋengat kiŋganup kelak yaŋaŋ am ekŋenaŋ Zân ek golaŋ zenze an penaŋ kegok nâmkatik bewien.” ");
INSERT INTO naf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Zemti Zisasiyet pigok zewien, “Nin ku nânup.” Kegok zeme Zisasiyaŋ ekŋengat zeye, “Neŋ kegogak an kwiyaŋ zemneme mamiyap ke ku diindosap.” ");
INSERT INTO naf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ke zemti zeye, “In zigok nâip? An ŋen ek nemuŋanet ayumuŋ mambuk. Egaŋ nemuŋaŋ yumagen meti zenak, ‘Nemun, geŋ alak wain muluwen mulup msenik.’ ");
INSERT INTO naf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Zeme nemuŋaŋ yuyaŋ zenak, ‘Yek, neŋ ku msap.’ Kegok zenak yaŋgut keŋaŋ gilik zeme naman muluwen medak. ");
INSERT INTO naf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Biwitdaŋ nemuŋaŋ yuyet sepem kogok dunduye âpme nemuŋaŋ muŋaŋ zeye, ‘Neŋ ŋep msap.’ Kegok zeye yaŋgut ku mge. ");
INSERT INTO naf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Âpme nemuŋanet egetmagengatnaŋ kwiyaŋ biwitdaŋ nâŋgenok mge?” Kegok zeme sâpe sâpe bumbu an ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ zewien, “Nemuŋaŋ yu.” Zeme Zisasiyaŋ zeye, “Neŋ penaŋ diindowi, mme takis mânep titi ma set kileŋ imbi ekŋenaŋ ŋeŋaŋ bemti Kawawaŋgalen zemâtâtâtgat katnanen mama keyet kandaŋan tapmelip. Âpme in keŋan ku talip. ");
INSERT INTO naf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zân tu zulutindende an egaŋ set teŋ zikat indame mâbâgalen ekmâtâbien yaŋgut in ku nâmkiŋpewien. Âpme takis mânep titi an ma set kileŋ imbi ekŋenaŋ nâmkiŋpewien. Ekŋenaŋ kegok mme in ekbien yaŋgut in yominaŋgatnan keŋin gilik zeme ku nâmkiŋpewien.” ");
INSERT INTO naf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ke zemti egaŋ sesewat mka temaŋgalen an damuŋ ma sâpe sâpe bumbu an ekŋengat zeye, “Wak bemti bemzenze zet ŋen zesowapgat ewe nâit. Kan ŋengat msat toŋaŋaŋ wain alikŋaŋ msatnaŋen ke onzeye. Mti kimbat kunduŋ kindiŋ bempemti wain katnaŋ misiksikgalen msat walatopemti amnaŋ mulup kalem tati eekgalen mka teepmaŋ walatpeye. Kegok mpemti wain mulupmaŋ ke kalop bemti amnaŋ ekdamuŋ mti mamayet toŋaŋ toŋaŋ indamti msat pem ŋen mege. ");
INSERT INTO naf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Egaŋ ke meti manepeme wain katnaŋ mâtâtâtgalen kanaŋ beme mulup anene zemindeme wain damuŋ ekŋenmagen wain katnaŋ titiyelen kobien. ");
INSERT INTO naf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Zemindeme kopme wain damuŋ ekŋenaŋ mulup an indatetimti kwep sidiwaŋ witikbien ma ŋen kume gakiye ma ŋen nanzaŋaŋ kuwien. ");
INSERT INTO naf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kegok mme msat toŋaŋaŋ zapat ke nâmti mulup an ewe sambe indeme kukŋaŋgat kobien ekŋen aindaŋgosomti omba penaŋ indeme kobien. Kopme wain damuŋ ekŋenaŋ ewe kukŋaŋgat mimindawien sepem kegogak mbien. ");
INSERT INTO naf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kegok mme bam delaŋ zenzeŋan ikŋaŋgat nemuŋaŋ penaŋ peme ekŋenmagen mesâgât mme keŋanen kapigok nâŋge, ‘Penaŋ sukwep pi ekŋenaŋ nemun eksempeseip.’ ");
INSERT INTO naf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kegok otnâye yaŋgut wain damuŋ ekŋenaŋ nemuŋaŋ ke ekti ilinak pigok zenâwien, ‘Pi ikŋaŋgat nemuŋaŋ penaŋ kapiyaŋ toŋaŋ bewe keyet kopme nin kumann gakime kwilekiki sambe kapi ningat zapat bek.’ ");
INSERT INTO naf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kegok zemti ekŋenaŋ nemuŋaŋ ke atamti mandamti mulup paselen tot kume gakiye.” ");
INSERT INTO naf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kegok zemti Zisasiyaŋ indayaŋkwesiye, “Msat toŋaŋaŋ wain mulupmanen kosâpm ke wain damuŋ ekŋen zigok penaŋ mimindasâpm?” ");
INSERT INTO naf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kegok zeme ekŋenaŋ zewien, “Egaŋ penaŋ sukwep am keŋ katik ekŋen ke indome gakime wain muluwen wain damuŋ alakŋaŋ indeme ekdamuŋ mti katnaŋ titi kananen timti toŋaŋgat maŋge butnaŋ sawep.” ");
INSERT INTO naf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ekŋenaŋ kegok zeme Zisasiyaŋ kapigok diindoye, “Kawawaŋgalen Zet Itnaŋanen zet ŋen kapigok tazin ke in ku mamaiŋ nâip, ma? ‘Mka walalat ekŋenaŋ tepum ŋen ekme bekanaŋ beme wisat mti peme weŋge. Tepum kewan tepum miŋaŋ beye. Sepem kegok ke Amobotnaŋ Kawawaŋaŋ mme nin ekmann ego egoŋaŋmak mambein.’ ");
INSERT INTO naf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Keyet zema nâit, Kawawaŋgalen zemâtâtâtgat katnanen mama ke in Zuda maŋgeen sokbembeyet zenzeŋaŋ ke inmagen menzem mti naman am belakŋaŋ ŋen indame ekŋenaŋ mme penaŋaŋ elikbe. ");
INSERT INTO naf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Amnaŋ, ‘Tepum ke sambuŋaŋ,’ zewien yaŋgut tepum ke kaliŋaŋ ya an keyet palen tokutun beme an ke epeewe. Ma tepum keyaŋ am keyet palen tokutun beme am ke gakime sekŋaŋ kânzunzuyaŋ bemisikbe.” ");
INSERT INTO naf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bemzenze zet zut ke zeme sâpe sâpe bumbu an ma Palisi ekŋenaŋ keyet yaŋaŋ nâmâtâti zewien, “Wakae, an pi ningat tazein.” ");
INSERT INTO naf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kegok zemti atamti mka katikŋan pepeyelen nâwien yaŋgut amnaŋ Zisasiyet golaŋ zenze an manzemtemiengapm kiŋgati peme tage. ");
INSERT INTO naf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Âpme Zisasiyaŋ ewe bemzenzeeset am zet kapigok diindoye, ");
INSERT INTO naf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kawawaŋgalen zemâtâtâtgat katnanen mama keyet yaŋaŋ kapigok. Kan ŋengat amobotnaŋgat nemuŋaŋ ŋenaŋ imbiŋaŋmak bet mututuyelen tu meu weyaŋ bemti ");
INSERT INTO naf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","mulup anne indeme am kukŋaŋgat indamandandaŋaŋ zeme kokogalen diindowien yaŋgut kokogalen ku indembeye. ");
INSERT INTO naf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kegok mme amobotnaŋaŋ mulup anene notnaŋ zemindeme am indamandandaŋaŋ ekŋengat zeye, ‘Nâlen bulmakau ma makau nembaŋaŋ temaŋ temaŋ kumti aŋo ma kwitnaŋ kwitnaŋ sambe ilak weyaŋo keyet awembiŋgalen meu niniyelen kolit.’ ");
INSERT INTO naf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kegok zeye yaŋgut am indamandadaŋaŋ ekŋenaŋ nâmpemambe ilinaŋgat tikŋaŋin nâwiengat kataŋ mepmâbien. Kwewaŋ ikŋaŋgat mulupman mege; ŋenaŋ aem kwaem mkaen mege. ");
INSERT INTO naf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kegok mme am notnaŋaŋ mulup annaŋ indatamti indome gakiwien. ");
INSERT INTO naf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kegok mme amobotnaŋaŋ ŋeŋaŋ penaŋ zime kasa kuku anne zemindeme am mulup anene indowienen ekŋen indome gakime mkaŋin temaŋ tep bume ziye. ");
INSERT INTO naf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kegok mti mulup anne diindoye, ‘Nâlen tu meu kelak weyayaŋaŋ tazin ekŋengat zapat yek. ");
INSERT INTO naf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Keyepmti am alakŋaŋ set teman meti am omba indaikseip ke indatim koseip.’ ");
INSERT INTO naf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kegok zemindeme mulup anene ekŋenaŋ set teman meti am sambe indaikbien am pembenaŋ ma am bekanaŋ kwaweti mka bemisik tabien. ");
INSERT INTO naf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kegok mme amobotnaŋaŋ am indamukukuyelen moti ekme an ŋen ondedakgalen sâk melakandu sasaŋaŋ ke ku miak tapme ege. ");
INSERT INTO naf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ekti zeye, ‘Notn, geŋ keŋan pi zigoset ondedak sâk melakandu miayakpiŋ kwatnek?’ Amobotnaŋaŋ kegok yaŋkwesime an keyaŋ zetpiŋ tage. ");
INSERT INTO naf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kegok mme amobotnaŋaŋ mulup anne diindoye, ‘Setnaŋ betnaŋ zamti zupman tambusosok keŋan peme towelak. Ke mamti sek sindem timti zetnaŋ aŋgalikme masumambe.’” ");
INSERT INTO naf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Zisasiyaŋ kegok zemti pigok zemdelaŋ zeye, “Kawawaŋaŋ am sambe indamandandaŋaŋ yaŋgut kwep kwewaŋ mebep.” ");
INSERT INTO naf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Zisasiyaŋ kegok zeme Palisi notnaŋ ekŋenaŋ buzak metati Zisas tetipemti zemkukuyelen zenâ zenâ mbien. ");
INSERT INTO naf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mti nembaŋine ma Elotgalen an notnaŋ zemindeme meti kapigok yaŋkwesiwien, “An zikat indanda, nin gâgât yaŋdi nânup. Geŋ zet dâsuki zenzepiŋ; penaŋak etaŋ manzenik. Ma zapat dolakŋaŋgalen zet ke am mobotnaŋ ma tototnaŋ sepem kwep manzikat ndanik. ");
INSERT INTO naf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Keyepmti geŋ zemane nâne. Gâlen nânâyaŋ zigok nânik? Amobotnaŋ Sisamagen takis mânep ŋep bembeyelen ma yek?” ");
INSERT INTO naf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kegok zeme egaŋ ekŋengalen nânâ bekanaŋ ke ekmâtâti diindoye, “In an zetgalen etaŋ! In kwilekiyet neŋ tatetineip?” ");
INSERT INTO naf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kegok zemti zeye, “In takis mânep mambeip ke ŋen zikat name ekbi.” Kegok zeme ekŋenaŋ mânep same ege. ");
INSERT INTO naf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ekti kapigok indayaŋkwesiye, “Am weŋaŋ ma kwit kapi kwiyelen?” ");
INSERT INTO naf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Zeme ekŋenaŋ zewien, “Ke amobotnaŋ Sisayelen.” Kegok zeme egaŋ diindoye, “Nâip, Sisayelen weŋaŋaŋ tatatnaŋ ke Sisa ikŋaŋ sawep. Âpme Kawawaŋ ikŋaŋgalen bet meluwaŋ keyepmti in ikŋaŋgat zapat mait.” ");
INSERT INTO naf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ekŋenaŋ ke zeme nâmti nâmtemtem mti pemti mebien. ");
INSERT INTO naf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kasup mulup mimi keyet Sadusi ekŋenaŋ Zisasmagen kobien. Ekŋengalen nânâyaŋ am gakiwep ke ku wabep manâip keyepmti Zisas keyet yaŋkwesiwien, ");
INSERT INTO naf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“An zikat indanda, Mosesiyaŋ kapigok zenzeŋaŋ, ‘An ŋenaŋ nemunambaŋaŋpiŋ gakin beme notnaŋ isikŋaŋaŋ imbi kwambet ke wati nemunamba egaŋ msokbewe keyaŋ an kukŋaŋgatnaŋ keyelen sip butnaŋ bewep.’” ");
INSERT INTO naf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kegok zemti ewe zewien, “Âpme an ŋenaŋ nembaŋane 7 indabege. Ya maneti ayuyaŋ imbi wati nembapiŋ gakime muŋaŋaŋ imbi kwambet ke wage. ");
INSERT INTO naf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ya muŋaŋ nembapiŋ gakime gwatnaŋaŋ kwambelin ke wage. Sepem kegogak ekŋen sambemagen sokbeme nemunambaŋinpiŋ gakiwien. ");
INSERT INTO naf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ya bam imbi kwambelin keyaŋ yek beye. ");
INSERT INTO naf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ya wawat kanaŋ an kwiyaŋ imbi ke mkipmaŋ beme egat imbiŋaŋ bewe?” ");
INSERT INTO naf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ke tetipemti kegok zeme Zisasiyaŋ zeye, “In Kawawaŋgalen Zetnaŋ Itnaŋaŋ ma egalen winde keyet kandati keyepm zet manzemyuŋguip. ");
INSERT INTO naf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wawat kanen awembiŋ mama ke ewe ku mambep. Ekŋenaŋ ensel kululuŋengatnaŋ nemboŋ bemti tabep. ");
INSERT INTO naf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yaŋgut in gakikiengatnaŋ wawat keyet manâmyuŋguipgat diindowi; Kawawaŋgalen Zet Itnaŋanen zet kapigok zenzeŋaŋ ke in ku mamaiŋ nâip, ma? ");
INSERT INTO naf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kawawaŋaŋ kapigok zeye, ‘Neŋ Abalaam ma Aisak ma Zekop ekŋengalen Kawawaŋin.’ Wa ek am gakikiŋaŋgalen Kawawaŋ yek. Egaŋ am mama kanzizitgat zapat ombemindeye ekŋengalen Kawawaŋ.” ");
INSERT INTO naf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kegok zeme am maŋge temaŋ ekŋenaŋ egalen mzikat indanda keyet nâmtemtem mbien. ");
INSERT INTO naf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Zisasiyelen zelaŋ Sadusi ekŋengalen windeŋin mtoindeme Palisi an ekŋenaŋ nâmbien. Keyepm ekŋenaŋ ilinak ondekti ");
INSERT INTO naf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ekŋenmagengatnaŋ ŋen zii zet zikat indanda keyaŋ Zisas yaŋkwesisien tetipeye, ");
INSERT INTO naf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“An zikat indanda, zii zet kwilekiyaŋ mobotnaŋ penaŋ bein?” ");
INSERT INTO naf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Zeme Zisasiyaŋ dunduye, “‘Geŋ keŋdi ma nâmamandi ma windendi ma ŋoktikdi ekŋen ke ketalasimti Amobotnaŋ Kawawaŋgat etaŋ gogot mpewanik.’ ");
INSERT INTO naf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Zet keyaŋ zii zet ŋotekŋaŋ ma zet mobotnaŋ penaŋ bein. ");
INSERT INTO naf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ŋen ewe sakam kapigok, ‘Gitaŋgat keŋdi mambeinok amgat kegogak gogot mbanik.’ ");
INSERT INTO naf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","zii zet ma golaŋ zenze an ekŋengalen zet sambe keyet keyaŋ ŋotekŋaŋ belup.” ");
INSERT INTO naf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Âpme Palisi an notnaŋ ondekti tapme Zisasiyaŋ indayaŋkwesimti kapigok zeye, ");
INSERT INTO naf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“In Kilaisiyet zigok manâip? Ek kwiyelen alikŋaŋ?” Kegok zeme ekŋenaŋ zewien, “Ek Dewitgalen alikŋaŋ.” ");
INSERT INTO naf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Zeme egaŋ diindoye, “Kwilekiyepmti Dewit ek Kawawaŋgalen Emetak Teŋaŋaŋ ekmak tapme Dewilaŋ Kilaisiyet ‘Amobotnaŋŋ,’ zeye? Zet ke Kawawaŋgalen Zet Itŋaŋanen kapigok kumpepeŋaŋ, ");
INSERT INTO naf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Amobotnaŋaŋ nâlen Amobotnaŋnnaŋgat kapigok zeye, “Geŋ koti nâlen betn penaŋset totapmane kasandine mtoindewap.”’ ");
INSERT INTO naf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Keyepmti Dewilaŋ Kilaisiyet ‘Amobotnaŋŋ,’ zeye beme ke zigoset mti Dewitgat sokŋaŋ bein? Kilais ek Dewitgalen amobotnaŋ.” ");
INSERT INTO naf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Egaŋ kegok zemti indayaŋkwesime ekŋenaŋ zet dopmaŋ gilik zem sasayet kiŋgabien. Mti kan keyetnaŋ baman gwaen yaŋkwesisi ŋen ku yaŋkwesiwien yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kan keyet palaŋaŋ Zisasiyaŋ am maŋge temaŋ ma nembaŋane ningat dinndoye, ");
INSERT INTO naf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Zii zet zikat indanda an ma Palisi ekŋenaŋ ilinaŋgat nâme Mosesinok beme zii zet alakŋaŋ mamsokbeip. ");
INSERT INTO naf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ekŋenaŋ in ekŋengalen zii zet alakŋaŋ ke mâbâgalen manzeip yaŋgut neŋ zemkulumindeyap ekŋengalen mama mimi maip ke ku mâbep. ");
INSERT INTO naf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ekŋenaŋ zii zet omtususuŋaŋ kegok mme nukŋaŋ beme ingat palen bemti ke mâlit zeme in mâti nukŋaŋ aikme mukulem ku mimindewep. Ekŋenaŋ nukŋaŋ temaŋ ke timti ingat palen bemti ilin belak penaŋ maip. ");
INSERT INTO naf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ekŋenaŋ kwitnaŋ kwitnaŋ mamip ke amnaŋ indik ekseseyelen etaŋ mamip. Saŋgum paŋaŋ palen Kawawaŋgalen zii zet kumpemti amnaŋ indidikgalen monzalaminan zampemti ma belinanen saŋgum paŋaŋ temaŋ sepem kegogak besaŋnok zampemti saŋgumin busiliŋaŋ teepteepmaŋ penaŋ amnaŋ indikti ekseseyelen mamiagip. ");
INSERT INTO naf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma ekŋenaŋ tu meu niniyelen indamandame ekŋenaŋ mundum pembenaŋ ma kukŋaŋgat totatagalen mamip. Ma sesewat mkaen ekŋenaŋ amobotnaŋ mundum pembenaŋ keyet manâmtikŋaŋ mip. ");
INSERT INTO naf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ekŋenaŋ selen amnaŋ indikti indamukumti nâme mobotnaŋ beme kwilin, ‘Zikat indanda,’ kukuyet maindembein. ");
INSERT INTO naf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma gâgât amnaŋ, ‘Zikat ndanda,’ zeme kwit keboŋ keyet ku nâmtikŋaŋ mbanik. An zikat indandaŋin kwewetaŋ main keyepm in, ‘Notn notn,’ zemti mambep. ");
INSERT INTO naf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mti in msalen am ŋengat, ‘Bien,’ ku zewep. Biwin kwewetaŋ ek kululuŋen main. ");
INSERT INTO naf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma in an ŋengat, ‘Ŋeŋaŋ bembe,’ zemindendeyet kegogak ku zewep. Ŋeŋaŋ bembeŋin kwewetaŋ tazin. Ek Mesaya. ");
INSERT INTO naf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma inmagengatnaŋ ŋenaŋ amobotnaŋ masât nâmbe beme notnaŋ ekŋengat sisiliŋ anok mambe. ");
INSERT INTO naf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma ŋenaŋ ikŋaŋgat nâme mobotnaŋ bewe beme Kawawaŋaŋ mtopewe. Ma ŋenaŋ ikŋaŋgat nâme tototnaŋ bewe beme Kawawaŋaŋ mmopewe. ");
INSERT INTO naf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Wakae, zii zet zikat indanda ma Palisi in sindem omba penaŋ tiwep! In an zegalen etaŋ! In Kawawaŋgalen zemâtâtâtgat katnanen mama keyet keŋan amnaŋ mebegalen mambekek ma manzemkekindeip. Mti ilin kegogak ku mamelip ma am kwiyaŋ mesât mamin ekŋen kegogak mme pepetnaŋmak mamben. ");
INSERT INTO naf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","In an teŋnok mamaip ma kegok tapmamti imbi kwambet mkaŋinan indamâpme kwawepme milawatnaŋ matip. Âpme in dundundu teepmaŋ nukŋaŋin ku mkawaŋ bembeyelen mandundup keyepmti wakae, in sindem omba penaŋ tiwep. ");
INSERT INTO naf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Wakae, zii zet zikat indanda ma Palisi in sindem omba penaŋ tiwep! In an zegalen etaŋ! In set omba tokwati mulup kaliŋan mti am maindatip. An kwep mme ilinaŋgat zapat mambein. An ke mme in sebemindemti bekanaŋ mimiŋin omba beme ekŋenmak in ilinsakwep teziŋ ŋandaŋgat zapat mambein. ");
INSERT INTO naf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Wakae! In an zikat beŋaŋ nolin set dâsuki tazikat indaip in sindem omba penaŋ tiwep. In manzeip, ‘An ŋen sesewat mka temaŋ teŋ keyet kwitnaŋ zetnaŋ zemkatik bewe beme zetnaŋ penaŋepiŋ bewe kegok zemti naman an ŋenaŋ sesewat mka temaŋgalen golaŋ mka miak pepeŋaŋ keyet kwitnaŋ zetnaŋ zemkatik bein beme zetnaŋ ke penaŋ manâip.’ ");
INSERT INTO naf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","In an zikat beŋ ma an seoŋ penaŋ! In nâme kwilekiyaŋ mobotnaŋ bein: gol sesewat mka temaŋ miak pepeŋaŋ tazin ke ma sesewat mka temaŋ ikŋaŋ?” Kegok zemti zeye, “Mka penaŋ keyaŋ mkayelen elimiak miakŋaŋ sebem pein. ");
INSERT INTO naf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma in kegogak manzeip, ‘An ŋenaŋ zetnaŋ sâpe sâpe bumbuyet mundumanen zetnaŋ zemti bandim mbe beme keyaŋ zetnaŋ mme penaŋepiŋ bewe,’ ma kogogak manzeip, ‘An ŋenaŋ sâpe sâpe bumbuyet mundumanen sâpe sâpe tazin keyet kwitnaŋ zetnaŋ bandim mbe beme zetnaŋaŋ penaŋ bewe.’ ");
INSERT INTO naf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","In an zikat beŋ! In nâme kwilekiyaŋ mobotnaŋ bein: sâpe sâpe bumbuyet bempeyo ke ma sâpe sâpe mundumaŋ?” Kegok zemti zeye, “Sâpe sâpe ke munduman bemti buwek keyepm sâpe sâpe mundumaŋ keyaŋ mobotnaŋ bein. ");
INSERT INTO naf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Âpme an kwiyaŋ zetnaŋ sâpe sâpe bumbuyet mundumanen zetnaŋ zemkatik bep beme wa sâpe sâpe mundumaŋ etaŋ yek egaŋ kwitnaŋ kwitnaŋ keyet palen tazin ekŋengat eyo kwilinan zetnaŋ zemkatik bep. ");
INSERT INTO naf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma an ŋenaŋ zetnaŋ sesewat mka temaŋgat kwitnaŋ kumti zetik miwen ke bandim min beme sesewat mka temaŋgat kwitnaŋ etaŋ yek, egaŋ Kawawaŋ sesewat mka temaŋ keyet toŋaŋgat zikatnan zetnaŋ bandim mti zep. ");
INSERT INTO naf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma an ŋenaŋ zetnaŋ kululuŋgat kwitnaŋ kumti zetnaŋ bandim mimiyet zep beme wa kululuŋgat etaŋ yek egaŋ Kawawaŋgalen mundum totatat ma Kawawaŋ ikŋaŋgat zikatnanen zetikŋaŋ bandim mpemti zep. ");
INSERT INTO naf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Wakae! zii zet zikat indanda ma Palisi in sindem omba penaŋ tiwep! In an zegalen etaŋ! Kwilekiki isikŋaŋ sikok ma suŋem sagom ma kambilak mayawak ma kawak muluwengatnaŋ maŋge 10magengatnaŋ maŋge kwep ke Kawawaŋgat masaip. In kwitnaŋ kwitnaŋ isikŋaŋ keyet eksemti makalopbep yaŋgut in zii zetgalen zet penaŋaŋaŋ tazin ke mamtotindeip. Zii zet ŋotekŋaŋ keyet keŋanen mama mimi kaboŋ kapi mimiyelen eksesemak mama ma aŋgalaŋ gogot palen mama ma nâmkiŋpepemak mamti mulup isisikŋaŋ Kawawaŋgat mulup bandim mimiyet taolet bembe ke eyo mimiyelen. Mama penaŋ zii zelaŋ zeinen ke in ku mamip. In kwitnaŋ kwitnaŋ isisikŋaŋgat tip butzenze mamip. ");
INSERT INTO naf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","In an zikat beŋaŋ nolin zet dâsuki tazikat indaip. In zii zet isisikŋaŋ mamâlip yaŋgut zii zet ŋotekŋaŋ mobotnaŋ ku mamâlip. In sakam an ŋenaŋ tu menzim keŋan kakalak isikŋaŋ tapme ekti ŋep mpenak yaŋgut belaŋ menzim keŋan tadage keyet yayaŋ ku mnak. ");
INSERT INTO naf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Wakae! zii zet zikat indanda ma Palisi in sindem omba penaŋ tiwep! In menzim sekŋaŋ etaŋ manzululip naman keŋanen zululupiŋ mme meu pâpmaŋ melesiŋ matazin. Ingalen mama mimiŋin sakamaŋ menzim keboŋ. In amgat zikalinan am pembenaŋnok mamaip yaŋgut keŋinan kambu ma segalen kwitnaŋ kwitnaŋaŋ bemisik wen. ");
INSERT INTO naf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Palisi an in zikalin beŋaŋ! In kukŋaŋgat menzim keŋanen meu pâpmaŋmak ke zulutiŋgulak sekŋaset zulubep. ");
INSERT INTO naf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Wakae! zii zet zikat indanda ma Palisi in sindem omba penaŋ tiwep! In an zegalen etaŋ. In sakamin am sum sekŋaset elimiakŋaŋ pembenaŋ ma kwetetepmaŋ keyaŋgut keŋaset am kasetnaŋ ma am sek tuŋaŋ sambuŋ kwilak kwilak mimiŋaŋ keboŋ. ");
INSERT INTO naf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","In sepem keboŋ sekŋinaset am zikalinan an teŋnok mamaip yaŋgut keŋŋinaset an nambalamin zut ma in yomtoŋ. ");
INSERT INTO naf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Wakae! zii zet zikat indanda ma Palisi in sindem omba penaŋ tiwep! In an zegalen etaŋ. In golaŋ zenze an ma an teŋ itnaŋaŋ gakikiŋaŋ ekŋengalen sumen elimiak pembenaŋ miak pemti ");
INSERT INTO naf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","in kapigok manzeip, ‘Nin itnaŋaŋ tipman baen ekŋen yeŋsokŋineyaŋ mambienen mambenek ze nin golaŋ zenze an ma an teŋ ekŋen ku indomann gakiwiek.’ ");
INSERT INTO naf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ingalen zet keyaŋ yaŋaŋ mkawaŋ beme in am golaŋ zenze an indome gakiwien ekŋengat alikŋine. ");
INSERT INTO naf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ŋepgat, in yeŋsokŋineyaŋ am indondo mulup mbien ke in keyegak tusumti msâbip. ");
INSERT INTO naf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","In asiŋ! In asiŋgalen alikŋane! In yominaŋgat dopmaŋ teziŋ ŋandaŋen indeme towesâgât talip ke yaŋaŋ in ku nâmâtâlip? In weyaŋ eksewep. ");
INSERT INTO naf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Keyepmti zema nâit. Neŋ golaŋ zenze an ma an nânâŋinmak ma zikat indanda indema kopme notnaŋ indome gakiwep. Notnaŋ tewen indowep ma notnaŋ sesewat mkaen sindiwaŋ indawitikbep. Ma notnaŋ sisipeŋpeŋ mimindeme mka pemŋengatnaŋ pemŋen kunzuŋti mebep. ");
INSERT INTO naf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Keyepmti an teŋ indome gakiwien an indowien ekŋen keyelen yom dopmaŋ mutumindame puwep. An ekŋen ke eweŋan yaŋbembeŋaŋ baenen Keinaŋ meniŋaŋ, Ebel an teŋ kume gakiye keyaŋ yaŋbempeye. Keyetnan Belakiyayet nemuŋaŋ Zakalaya ek sâpe sâpe bumbuyet munduman ma sesewat mka temaŋ tuŋguwitdaŋ amnaŋ nanzaŋaŋ kume gakiye ma sepem kegok ke in an notnaŋ omba indowien. ");
INSERT INTO naf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Keyet neŋ penaŋ sukwep diindowi, am sambe indom kwabien ekŋengalen yominaŋgat dopmaŋin am in alak kapi talipmagen sokbesâpm. ");
INSERT INTO naf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Zelusalem am, Zuda msalen in golaŋ zenze an maindome gakip, ma Kawawaŋgalen zet busup an indeme makolip mee nanzaŋaŋ maindoip. Neŋ in sakokolok mamaŋaŋ nembaŋane pâpmaŋ kandaŋan maŋge kwep maondakindemti am bulut tazin sepem kegok kan sambe neŋ in tima betn kandeŋan kwawowogalen nâma in ku manâmneip. ");
INSERT INTO naf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Keyepmti neŋ zema nâit, ingalen sesewat mka temaŋ ke Kawawaŋaŋ katipeme ilinaŋgat belinan tapmosâpm. ");
INSERT INTO naf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Keyepmti neŋ dindowi, in neŋ ewe ku nikbep. Ya neŋ bamgat kopma in pigok zewep, ‘Kawawaŋaŋ Nemuŋaŋ ombempeme kozin keyet nin oloŋen penaŋ mnup,’ kegok zewep.” ");
INSERT INTO naf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Zisasiyaŋ sesewat mka temaŋ katipemti toti mepme nembaŋane nin ekmagen koti pigok zewenn, “Amobotnaŋ, sesewat mka temaŋ ekpiseseyelen pi ekbaga.” ");
INSERT INTO naf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Zemann Zisasiyaŋ dopmaŋ gilik zem zeye, “In nanzaŋaŋ mka temaŋ walalatnaŋ kapi alak ego ego mip. Yaŋgut neŋ penaŋ sukwep diindosowap, maneti bamgat nanzaŋaŋ mundumin talip keyet kataŋ ku tabep. Kasa ekŋenaŋ kokume epeemti nanzaŋ igak kwep kwep lala bubuk mekobep.” ");
INSERT INTO naf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kegok zemambe met Olip Kalaŋan moti nin yaŋkwesiwan, “Zenagen ke pe zukŋan sokbewe ma geŋ kokodan kanen ma kan delaŋ zenzeŋaŋ piliŋ ziboŋ sokbewe?” ");
INSERT INTO naf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Zemann egaŋ dinndoye, “In weyaŋekmâtât mambep mineti am ŋenaŋ teti mimindeweyet. ");
INSERT INTO naf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Am notnaŋaŋ koti zewep, ‘Neŋ Kilais,’ kegok zemti am omba tetimindewep. ");
INSERT INTO naf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","In kasa kwisakŋaŋ ilinmagen sokŋan ma kasa sukwep auuyelen zapatnaŋ nâwep yaŋgut keŋin siŋsiŋ mme yayaŋ mimipiŋ. Kegok ke sokbeweyaŋgut ke kan delaŋ zenzeŋaŋ yek. ");
INSERT INTO naf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Am msat ŋengatnaŋ ma ŋengatnaŋ dopmaŋ mekum kwakum mbep ma msatgalen amobotnaŋ zulaŋ auwalup. Ma msat kataŋ meuyet kambeŋ temaŋ sokbewe ma msat sambe mâkinaŋ temaŋ mbe. ");
INSERT INTO naf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ke sepemaŋ imbiyaŋ nemba titiyelen sindem yaŋbemti manâip sepem keboŋ kwabe. ");
INSERT INTO naf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ma am notnaŋaŋ ekŋenaŋ in nâmkiŋpemneip keyepm msat palengalen amobotnaŋ ekŋengat belinan beme ekŋenaŋ sisipeŋpeŋ mimindewep. In neŋmak tusumti mambepgapmti am sambe ekŋenaŋ ingat nâme kaŋgaŋaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kan keyet am sambe nâmkiŋpepeŋinmak ku mkatik bem tabep am notnaŋ nâmkiŋpepeŋinmak zemsokbemindame ekŋenaŋ ma notnaŋaŋ am notnaŋgat ilinaŋgat keŋ kasa mimindewep. ");
INSERT INTO naf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma kegogak golaŋ zenze an dâsuki ekŋenaŋ koti am sambe keŋin mme yuŋgu mâbe. ");
INSERT INTO naf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma mama mimi bekanaŋaŋ palakŋaŋ beme am notnaŋaŋ nolinaŋgat notn notn ku mbep. ");
INSERT INTO naf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yaŋgut amnaŋ an ŋen nâmkiŋpepemak sisipeŋpeŋ msame egaŋ nâmkiŋpepeŋaŋ katikŋaŋ atam tapmetneti gakiwe beme kan delaŋ zenzeŋaŋ Kawawaŋaŋ an ke mama kanzizit sawe. ");
INSERT INTO naf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mti Kawawaŋgalen zemâtâtâtgat katnanen mama keyet zapatnaŋaŋ msat kataŋ mekopme am sambe nâmeŋgut kan delaŋ zenze sokbewe. ");
INSERT INTO naf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Âpme kan tipman baenen golaŋ zenze an Danielaŋ, ‘Kwileki ŋen mamaŋaŋmak ma kiŋgagatnaŋmak kotabe,’ keyet zetnaŋ zeye. Kwitnaŋ kwitnaŋ keyaŋ ingalen sesewat mka kambu manzeip keyet keŋan sokbem tapme am zet kapi maiŋti nâmambe ekŋenaŋ keyet yaŋaŋ nâmâtâbep. ");
INSERT INTO naf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Âpme kan keyet am Zudia msalen talip ekŋenaŋ kunzuŋti kalaŋ dukŋan mowebep. ");
INSERT INTO naf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma am ŋenaŋ mka solonan tapmambe ya kan keyaŋ sokbeme milawatnaŋ mka keŋan ku akum tiwe. Egaŋ keyegak tati kunzuŋ mebe. ");
INSERT INTO naf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma sepem kegogak am ŋenaŋ kolopmaŋ mkaŋan tapme ikŋaŋ mulupman tapmambe beme keyaŋ sokbeme kolopmaŋgat nâmti mkaŋan kokopiŋ. Egaŋ keyegak tati kunzuŋ mebe. ");
INSERT INTO naf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kan keyet imbi keŋmak ma nembaŋin okakŋaŋ ekŋenaŋ kunzunzuŋgalen timyapewep ke kembeŋ penaŋ. ");
INSERT INTO naf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","In Kawawaŋ dundum same nâmindame kunzunzuŋin map tâgâ kanen ma Sabat tagoŋgo kanen ku sokbemindawe! ");
INSERT INTO naf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Keyepm kan keyet nukŋaŋ omba penaŋ sokbemâbe. Nukŋaŋ keboŋ ke itnaŋaŋ msat sokbembeŋaŋgatnaŋ alak tatnup kapi keboŋ ŋen ku sokbeye ma bam gwaenen ŋen ku sokbewe. ");
INSERT INTO naf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Egaŋ an imbi ikŋaŋgat zapat indamakuye ekŋengapm kan ke mme danaŋ bewe ekŋen yek benak ze nukŋaŋ ke kan danaŋ ku tapme am sambe walapme delaŋ zenak. ");
INSERT INTO naf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Âpme kan keyet an ŋenaŋ pigok zewe, ‘Egit, kilais daen tazin,’ ma ‘Pi tazin,’ zeme nâmbep beme ku nâmkiŋpewep. ");
INSERT INTO naf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ma kilais dâsuki sambe ma golaŋ zenze an dâsuki sambe ekŋenaŋ sokbemti menok sepem igak igak ma mulup piseseŋaŋmak mme amnaŋ ekti nâmkiŋpemti indamâbâgalen mbep. Sepem kegogak Kawawaŋaŋ am ikŋaŋgat zapat indamakuye ekŋen keyet keŋin myuŋguindesâgât mbep. ");
INSERT INTO naf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nâip, neŋ kwitnaŋ kwitnaŋ keyet tazemsalaŋ beyap ke sokbesâpm. ");
INSERT INTO naf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Âpme amnaŋ pigok zewep, ‘Egit, kilais ek msat tuŋgupman tazin.’ Zeme ke mebepiŋ. Ma ŋen pigok zewep, ‘Ek mka keŋan tazin.’ Zeme nâmkiŋpepepiŋ. ");
INSERT INTO naf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Âpme neŋ Angat Nemuŋaŋ neŋ ambeyak sakam kasup kwakwatnasetgatnaŋ tototnaset ilindiŋ sakwep beyak mamnok neŋ kegok kobap. Kegok kopma am sambeyaŋ ŋep nikbep. ");
INSERT INTO naf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Neŋ kokotnnaŋgalen kanen nâlen maŋgeyaŋ ekme tep katnaŋ saŋgamaŋ penaŋ elikme age sambeyaŋ maondagip. Sekam kegogak kwitnaŋ kwitnaŋ ke ilinmagen sokbeme ekti nâmkawaŋ bewep. ");
INSERT INTO naf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nukŋaŋ sambe ke delaŋ peme keyegak, ‘kasup zikatnaŋ sopkusâpm ma eyoŋga busatnaŋ yek besâpm ma wenzimaŋ kululuŋengatnaŋ âtâtosâbip.’ Ma Kawawaŋaŋ kululuŋ buteme titok mme kululuŋengalen kwitnaŋ kwitnaŋ sambe keyaŋ puluk pilik zem mekobep. ");
INSERT INTO naf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","In Angat Nemuŋaŋ neŋ nâlen kokotnnaŋgalen kanaŋ ma pilinaŋgat yaŋkwesiwien kelak dindosowap. Ma in Angat Nemuŋaŋ neŋ mgulumbuk palen kululuŋen tati windemak saŋga soŋga keŋan busatnaŋmak kopma niksâbip. Am maŋge msat sambeyelen ekŋenaŋ nikti susâbip. ");
INSERT INTO naf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kan kobawen keyet lumun kwisak omba kume egaŋ enselŋane zemindeme msat ganzenaŋ nembet ma nembet ma gwaen ma baen meti am ikŋaŋgat zapat makumindendeŋaŋ ekŋen msat kataŋgatnaŋ ondekindewep. ");
INSERT INTO naf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Âpme in balam balam tep ekŋengat otnâit. Kan tep balam balam katnaŋ yaŋbemti kwapme manzeip, ‘O, ilak mtete yaŋbesâpm ma tep gwazege sinaŋaŋ taalaŋ sime’ in manzeip, ‘Tonne mtete tasâpm,’ manan sinaŋ betnaŋaŋ epeemti sinaŋaŋ tapmme manzenup, ‘Mawalam tasâpm.’ ");
INSERT INTO naf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sakam kegogak in bamgat nukŋaŋ sambe sokbeme ekti nâme kan ilak sokŋan bududuk bein keyepm in weyayaŋ mulup mtalit. ");
INSERT INTO naf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Neŋ penaŋ sukwep diindowi, am alak talip kapi ilindiŋ ku gakimâpme kwileki sambe kapi sokbesâpm. ");
INSERT INTO naf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Msat ma kululuŋ eget asekmalu delaŋ zesâpm yaŋgut nâlen zetnnaŋ delaŋ zenzeŋepiŋ matapmambe. ");
INSERT INTO naf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Am ŋenaŋ Angat Nemuŋaŋgalen kan kokogalen ke ku nâin. Ensel kululuŋengatnaŋ ekŋenaŋ ku nâip. Nemuŋaŋ neŋ kegogak ku nâyap. Bipmnaŋ igak etaŋ kan ke nâin. ");
INSERT INTO naf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Angat Nemuŋaŋ neŋ kokotnnaŋgalen ke itnaŋaŋ Noamagen sokbeye sepem kegok sokbewe. ");
INSERT INTO naf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tuŋgwam kosât mge kan keyet am ekŋenaŋ itnaŋaŋ mamimtemienok tu meu nimwiaŋbien ma an imbiyaŋ awembiŋ bemti msalengalen kwitnaŋ kwitnaŋgat otnâmti Kawawaŋgat ku otnâwien. Sepem kegok tapmme Noayaŋ waŋgaŋaŋ teman keŋan mowege. ");
INSERT INTO naf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yaŋgut ekŋenaŋ zigok sokbesâpm ke nâme dâsuki beme tatnepeme tuŋgwagemaŋ ilindiŋ indaminziliye. Sepem kok penaŋ Angat Nemuŋaŋ neŋ kosowawen sokbesâpm. ");
INSERT INTO naf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kan keyet an zut muluwen mulup tapmambaluwaŋ kwep ŋen teti meti ŋen peme tabe. ");
INSERT INTO naf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Imbi zulaŋ saŋgo sâŋsâŋ tapmambaluwaŋ kwep ŋen teti meti ŋen peme tabe. ");
INSERT INTO naf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Amobotnaŋin kan zukŋan kobe ke in ku nâipgapmti kelem mti nâpeŋ nâpeŋ mambep. ");
INSERT INTO naf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","In pigok nâit, mka toŋaŋaŋ kan kwilekiyet an kambu titiyaŋ kokogalen ke nânak beme egaŋ keik tati mkaŋaŋ damuŋ mme an kambu titiyaŋ mka ku asekti keŋan tiŋkwabiek. ");
INSERT INTO naf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sepem kegogak Angat Nemuŋaŋ neŋ in kan zukŋan sokbewap ke nânâpiŋ tapme kobapgapmti in weyaŋti nâpeŋ nâpeŋ mamambep. ");
INSERT INTO naf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mulup nemba dolakŋaŋ nânâŋaŋmagaŋ mulup kapigok mbe. Amobotnaŋaŋaŋ pem ŋen mesât mti mulup nemba notnaŋ ekŋengat damuŋ peme egaŋ indikdamuŋ mti meu kananen teŋ maindain. ");
INSERT INTO naf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kegok tapmme bamgat amobotnaŋaŋ gilik zem kobeen ekme mulup nemba egaŋ zemâtâtpeyenok tapmme ekti nâme oloŋen bewe. ");
INSERT INTO naf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Neŋ penaŋ sukwep diindowi, ek ke amobotnaŋaŋaŋ ikŋaŋgalen kwitnaŋ kwitnaŋ sambe ke egat betnan beme ekdamuŋ mbe. ");
INSERT INTO naf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Âk egaŋ mulup nemba bekanaŋ penaŋ beme egaŋ keŋan pigok nâwe, ‘Amobotnaŋŋ ek sakwep ku kobe.’ ");
INSERT INTO naf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kegok nâmti egaŋ mulup nemba notnane indomti meu ma tu katikŋaŋ an tu katikŋaŋ nini ekŋenmak nimbe. ");
INSERT INTO naf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Âpme mulup nemba egat amobotnaŋaŋ egalen kanaŋ kokogalen ku nâmâtâbe. ");
INSERT INTO naf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mti amobotnaŋaŋaŋ dopmaŋ omba penaŋ mutumsamti putatime an nambalamin zut ekŋenmak mambe. Mamti sindemgat si zemsu zemsu mti zelin aŋgalikme mamambep. ");
INSERT INTO naf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kan keyet Kawawaŋgalen zemâtâtâtgat katnanen mama ke imbi nembip 10 ekŋenaŋ taŋamin timti an ŋenaŋ imbi wawagalen kopme selen aiikgalen mebien ke sepem sokbewe. ");
INSERT INTO naf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ekŋenmagengatnaŋ imbi nemba 5 ekŋen nânâŋinpiŋ ma 5 ekŋen nânâŋinmak. ");
INSERT INTO naf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nânâŋinpiŋ ekŋenaŋ taŋamin mbienaŋgut tuŋaŋ butnaŋ ŋamgat ku mbien. ");
INSERT INTO naf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Âpme nânâŋinmak ekŋenaŋ seŋgewinan taŋam tuŋaŋ kasime topme taŋaminmak ilinsakwep mmebien. ");
INSERT INTO naf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","An imbi wawagalen egaŋ sakwep ku kopme imbi nembip ekŋenaŋ damuŋ tabienaŋ melupgat sukŋaŋ bemti meluk wembien. ");
INSERT INTO naf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tawene peme tambu sutnan temaŋ kwizet pigok koge, ‘An imbi wawagalen kozin! In wati toaigit!’ ");
INSERT INTO naf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kegok kume nâmti imbi nembip ekŋenaŋ ilindiŋ wati taŋamin weyaŋbien. ");
INSERT INTO naf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kegok mti nânâŋinpiŋ ekŋenaŋ nânâŋinmak ekŋengat zewien, ‘In nin taŋam tuŋaŋ bugan kasim ndait. Ningalen taŋamlak bep zein.’ ");
INSERT INTO naf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Zeme nânâŋinmak ekŋenaŋ gilik zemti zewien, ‘Inmak ninmak nsakwep tuŋaŋ bugan kapiyaŋ ŋep ku bendesemgat in dalaŋ mkaen met ilinaŋgat kwitim kolit.’ ");
INSERT INTO naf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kegok zemindeme imbi nembip nânâŋinpiŋ ekŋenaŋ tuŋaŋ kwitisât mebien. Ekŋenaŋ met mame mame an imbi wawagalenaŋ pataŋ peye. Âpme imbi nembip 5 damuŋ tabien ekŋenaŋ ekmak awembiŋ bembeyelen tu meuyet ondedak mkaen mowepme sekekek kege. ");
INSERT INTO naf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kegok sokbeme bamgat imbi nembip nânâŋinpiŋ ekŋenaŋ pataŋ zemti zewien, ‘Amobotnaŋ, amobotnaŋ, nâmndemane kwatne!’ ");
INSERT INTO naf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","An imbi wawagalenaŋ zeye, ‘Neŋ penaŋ diindowi, neŋ in kandat indeyap.’ ");
INSERT INTO naf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Zisasiyaŋ zet kegok zemdelaŋ zemti kapigok zeye, in kan kwilekiyet ma bet kwilekiyet ma tambuŋan ma gasiyet kobe ke ku nâip keyepmti in kelem mbep. ");
INSERT INTO naf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Maneti amobotnaŋ ŋenaŋ msat pemŋen mesât mti egaŋ mulup nembaŋane kume kopme kwilekikiŋaŋ sambe belinan bemti ekdamuŋ mimiyet zemindeye. ");
INSERT INTO naf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Egaŋ mulup nemba kwep kwep ekŋengat sepemin ma windeŋin nâmti keyet kataŋ mânep indaye. Kwep ŋen 5000 kina saye. Ŋen 2000 kina saye. Ŋen 1000 kina saye. Kegok indamâti egaŋ msat sukwep mege. ");
INSERT INTO naf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Egaŋ mepme mepme mulup nemba 5000 kina tiye egaŋ sakwep penaŋ mânep keyaŋ mulupmaŋ mmepme 5000 kina ŋen ewe mânep tâgâŋaŋ aige. ");
INSERT INTO naf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sepem kegogak mulup nemba mânep 2000 kina tiye egaŋ mulupmaŋ mmepme 2000 kina ŋen ewe mânep tâgâŋaŋ aige. ");
INSERT INTO naf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Âpme mulup nemba mânep 1000 kina tiye egaŋ mobotnaŋaŋgalen mânep ke msat walati keŋan kwatampeye. ");
INSERT INTO naf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kan teepmaŋ penaŋ delaŋ zeme bamgat mulup nemba ekŋengat amobotnaŋinaŋ gilik zem koge. Koti mânep indaye keyelen yaŋaŋ nâsât ondek indeye. ");
INSERT INTO naf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mulup nemba 5000 kina tiye egaŋ 5000 kina tâgâŋaŋ aikge ke mkoti zeye, ‘Amobotnaŋ ekbak, geŋ 5000 kina nawananaŋ neŋ mulupmaŋ sama 5000 kina tâgâŋaŋ aikban.’ ");
INSERT INTO naf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Amobotnaŋaŋ zeye, ‘Geŋ mulup nemba pembenaŋ penaŋ. Geŋ zetn gawepumti mulup pembenaŋ penaŋ mbanan. Geŋ mânep isikŋaŋ ŋep mandamuŋ mnikgapmti neŋ mânep temaŋgat damuŋ mimiyelen gewap. Geŋ neŋmak kopmane oloŋen mdi.’ ");
INSERT INTO naf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mulup nemba 2000 kina tiye egaŋ kogak koti zeye, ‘Amobotnaŋ, geŋ 2000 kina nawanan. Ekbak, neŋ mulupmaŋ sama 2000 kina tâgâŋaŋ aikban.’ ");
INSERT INTO naf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Amobotnaŋaŋaŋ pigok dunduye, ‘Geŋ mulup nemba pembenaŋ penaŋ. Geŋ zetn gawepumti mulup weyaŋti mbanan. Geŋ mânep isikŋaŋ ekdamuŋ ŋep mbanan keyepmti neŋ mânep temaŋgat damuŋ mimiyelen gewap. Keyet geŋ neŋmak kopmane oloŋen mdi.’ ");
INSERT INTO naf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Âpme mulup nemba 1000 kina tiye egaŋ koti zeye, ‘Amobotnaŋ, neŋ nâyap ke geŋ an katikŋaŋ. Geŋ mânep tuŋgupmaŋ nembandineyaŋ monze onze mulup mti onzenzeŋanengatnaŋ timti tosayet bemane kopme matinik ma geŋ mânep setnaŋ mtitiyelen omba nâmtatnik. ");
INSERT INTO naf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kegok nâmti neŋ mânep tima mebegat kiŋgati met 1000 kina ke msat keŋan atam pema matazin keyepmti ekbak, kapi gitaŋgalen mânep ikŋaŋ ke gilik zem gayap.’ ");
INSERT INTO naf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Zeme amobotnaŋaŋ gilik zemti zeye, ‘Geŋ mulup an bekanaŋ ma awisatoŋ! Geŋ nânak, neŋ mânep tuŋgupmaŋ nembanneyaŋ monze onze mulup mti onzenzeŋanengatnaŋ timti tosayet bema kopme matiap ma neŋ mânep setnaŋ mtitiyelen omba nâmtalap. ");
INSERT INTO naf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nâmane kegok beme geŋ nâlen mânepm mânep mkaŋan bewekwan ya neŋ gilik ze kobagen nenaŋgalen mânep ilindiŋ timti tâgâŋaŋ notnaŋ tiwak.’ ");
INSERT INTO naf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Amobotnaŋ kegok zemti gilik zemti an mulup an ŋengat zeye, ‘Mânep ke menzem mti an 10,000 kina tasain ke sait.’ ");
INSERT INTO naf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Amobotnaŋ keyaŋ tusumti zeye, ‘An ŋenaŋ kwileki notnaŋ tasame keyet mulupmaŋ mam beme kwileki notnaŋ ewe tusumti same ekmagen polak polak wemsawe. Âk am ŋenaŋ kwileki ŋen isikŋaŋ tasame mulupmaŋ ku mbe beme ewe kwileki isikŋaŋ penaŋ bugan tasain ke kogogak menzempewep. ");
INSERT INTO naf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Keyepmti mulup nemba bekanaŋ ke putatime zupman tambusosok keŋan ke mamti si zemsu zemsu mti zetnaŋ aŋgalikti mamambe.’ ");
INSERT INTO naf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Maneti Angat Nemuŋaŋ neŋ winde temaŋmak enselne indatetimti kosowap. Koti damuŋ mulup mimiyelen Amobotnaŋgalen munduman totasowap. ");
INSERT INTO naf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Âpme am sambe msat ŋen msat ŋen keyet keŋangatnaŋ am ilindiŋ mamkandaŋnan ondek indesowap. Sekam sipsip damuŋaŋ sipsipmak meme makalaŋidein sepem kogak mbap. ");
INSERT INTO naf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mti neŋ am teŋ maip ekŋen betn penaset zemindema tabep naman am notnaŋ betn alomeset zemindema tabep. ");
INSERT INTO naf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Maŋge bemindemti Amobotnaŋ neŋ am betn penaset pigok diindowap, ‘In Bienmak tusum talip keyepm kolit. Kawawaŋgalen zemâtâtâtgat katnanen mama keŋan mamayelen eweŋan msat sokbeme baenen ke weyaŋpepeŋaŋgat koti mama kanzizit tit. ");
INSERT INTO naf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ke pigogat neŋ meuyet mma in meu nambien. Neŋ tuyet tapmma in tu name nimban. Neŋ an mamanam kopma in notn mnemti mkaŋinan natetimobien. ");
INSERT INTO naf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Neŋ melakandunduyet olapma in melakandu nawien. Neŋ zawat mma in nikdamuŋ mbien. Neŋ mka katikŋan tapma in met nikdamuŋ mti mukulem mnembien. Keyepmti in kolit.’ ");
INSERT INTO naf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Zema am teŋ bembeŋaŋaŋ pigok gilik zesâbip, ‘Amobotnaŋ, nin kan kwilekiyet geŋ gikmann meuyet tapmmane meu gawenn ma tuyet tapmmane tu gawenn? ");
INSERT INTO naf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma geŋ denen an mamanamaŋ kopmane nin weyaŋgewenn ma melakandunduyet olapmane melakandu gawenn? ");
INSERT INTO naf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma kan kwilekiyet zawalen ma mka katikŋan wemane nin mukulem mgewenn?’ ");
INSERT INTO naf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Âpme Amobotnaŋ neŋ zet dopmaŋ pigok gilik zewap, ‘Neŋ penaŋ zema nâit, in kan ke ma keyet nâlen notn an tototnaŋ nâmkiŋpepemak mukulem mpewien in ke ek etaŋ ku mukulem mpewien. Ke neŋ mukulem mnewienok bein.’ ");
INSERT INTO naf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mti neŋ betn alomset tabep ekŋengat pigok zewap, ‘In nenemti sebeit! In teziŋ ŋandayet zapat ombemindendeŋaŋ. Teziŋ taŋamaŋ delaŋ zenzeŋepiŋ ke Sadaŋ ma enselŋane ekŋengat weyaŋpepeŋaŋ keyet keŋan towelip! ");
INSERT INTO naf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ke pigogat neŋ meuyet mma in meu ku nawien. Neŋ tuyet mma in tu ku nawien. ");
INSERT INTO naf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Neŋ an mamanam kopma in neŋ notn mnemti mkaen ku newien. Neŋ melakandunduyet olapma in neŋ melakandu ku nawien. Neŋ zawalen ma mka katikŋan tapma in ku namukulem mnewien.’ ");
INSERT INTO naf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Zema ekŋenaŋ pigok gilik zem zewep, ‘Amobotnaŋ, nin denen gikmann meuyet mmane ma tuyet mmane ma an mamanam kopmane ma melakandunduyet olapmane ma zawalen wemane ma mka katikŋan tapmane nin ku mukulem mgewenn?’ ");
INSERT INTO naf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Âpme Amobotnaŋ neŋ dopmaŋ pigok gilik zem indawap. ‘Neŋ penaŋ sukwep diindowi, in kan ke ma keyet nâlen notnne peweweŋaŋ ekŋenmagengatnaŋ ŋen mukulem ku mpewien beme in neŋ ku mukulem mnewienok bein.’ ");
INSERT INTO naf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kokgapmti zemindema ekŋenaŋ yomgalen dopmaŋ gakiki delaŋ zenzepiŋ keŋanen towebep. Âpme am teŋ Kawawaŋgat zet kandaŋan maiwaŋ mama kanzizit tiwep.” ");
INSERT INTO naf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Âpme Zisasiyaŋ zet sambe ke zemzikat indame delaŋ peme nembaŋane ningat pigok dinndoye, ");
INSERT INTO naf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Bet mulup mimi zut delaŋ peme Aŋgalalaŋ Kendo bewe ke in ŋep nâip. Kan keyet neŋ kasanneyaŋ zemnomti Angat Nemuŋaŋ amgat belinan neme tewen nowep.” ");
INSERT INTO naf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kan keyegak sâpe sâpe bumbu an ŋeŋaŋ sambe ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ sâpe sâpe bumbu an sambeyelen ŋeŋaŋin kwitnaŋ Kayapas egalen mka temanen ondekti ");
INSERT INTO naf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Zisas buzageset atamti kume gakikiyelen setnaŋgat zenâ zenâ mbien. ");
INSERT INTO naf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yaŋgut ilinak pigok zewien, “Nin kendo keŋan kapi ku msenup. Mnepemann am sambeyaŋ kasa kileŋ mseipmagengat.” ");
INSERT INTO naf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Âpme Zisasiyaŋ Betani mkaen tage ke an ŋen kwitnaŋ Saimon ek sekŋaŋ liŋgit satnaŋmak itnaŋaŋ mamtan ya Zisasiyaŋ weyaŋpeye egalen mkaen tabien. ");
INSERT INTO naf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ke motati meu tatnmann imbi ŋenaŋ wet kelakŋaŋ sesikŋaŋ pembenaŋ penaŋ seŋgepmaŋmak tosaŋaŋ temaŋ ke mkoti Zisasiyet ŋokŋan mulapeye. ");
INSERT INTO naf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Âpme imbiyaŋ kegok mme nembaŋaneyaŋ nin ekti ŋenzinziŋ mti yaŋkwesiwenn, “Kwilekiyepmti pi belak walezin? ");
INSERT INTO naf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wet kelakŋaŋ kapi tosayet beme mânep temaŋ ime kopme am bekopsat indandayelen.” ");
INSERT INTO naf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Zemann Zisasiyaŋ nin zigok zewenn ke nâmti, “In kwilekiyet mti imbi dundumti zekalumpeip? Egaŋ mnep ke pembenaŋ penaŋ. ");
INSERT INTO naf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Am bekopsat ekŋenaŋ inmak kwesiŋ penaŋ mamambep âpme neŋgut inmak kwesiŋ kapi ku mamambap. ");
INSERT INTO naf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Imbi egaŋ kwileki mip ke nâgât sekŋ kapi weyaŋti kelakŋaŋaŋ zulupeme sumen nambembeyelen mip. ");
INSERT INTO naf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Neŋ penaŋ sukwep dindowi, msat kataŋ deset ma deset Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ kapi mebennok imbi kapiyaŋ nâgât mnep kapi kogogak zenâ mti egat otnâwep.” ");
INSERT INTO naf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Âpme nembaŋane 12 ninmagengatnaŋ kwep ŋen kwitnaŋ Zudas Iskaliotgatnaŋ egaŋ sâpe sâpe bumbu an ŋeŋaŋ ekŋenmagen meti ");
INSERT INTO naf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","pigok indayaŋkwesiye, “Neŋ Zisas in zikat indamti belinan bema in tosaŋaŋ kwileki naseip?” Yaŋkwesime ekŋenaŋ mânep silwa kasetnaŋ 30 kegok makumti sawien. ");
INSERT INTO naf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Âpme Zudasiyaŋ kan keyet yaŋbemti, “Zigoset mti Zisas zemkusap,” zemti setnaŋgat timage. ");
INSERT INTO naf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Âpme Nupmamaŋ Yispiŋ Niniyelen Kendo keyet yaŋbembeŋaŋ nembaŋane nin Zisasmagen koti yaŋkwesiwenn, “Geŋ nin Aŋgalalaŋ Kendoyelen tu meu denen weyaŋ bembeyelen gambein?” ");
INSERT INTO naf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yaŋkwesimann Zisasiyaŋ zeye, “In Zelusalem mka temaŋ keŋan meti an ŋen aikseip keyet pigok dunduseip, ‘Ningalen zikat ndandayaŋ zep, “Nâlen gakiki kan ilak daŋgoin keyepm nembanemak nin Aŋgalalaŋ Kendoyet gâlen mkaen tasenup,” ‘kegok zeseip.’ ’ ");
INSERT INTO naf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nembaŋane nin Zisasiyaŋ ikŋaŋ zemâtâtndeye keyet kataŋ mâti Aŋgalalaŋ Kendoyet tu meu weyaŋ bewenn. ");
INSERT INTO naf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kegok mti mkokok kume Zisas ma nin 12 nsakwep tu meu niniyelen tomtabenn. ");
INSERT INTO naf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ke tati tu meu nimambe Zisasiyaŋ dinndoye, “Neŋ penaŋ diindowi inmagengatnaŋ ŋenaŋ neŋ zemnosem.” ");
INSERT INTO naf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kegok zeme nembaŋane nin keŋ sindem mti ikŋaŋgat kwep kwep yaŋbemti yaŋkwesiwenn, “Amobotnaŋ, geŋ nâgât tazenik, ma?” ");
INSERT INTO naf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kegok yaŋkwesimann delaŋpeme Zisasiyaŋ dinndoye, “An ŋenaŋ nupmamaŋ tu batien nsakwep pemalu towepme nselup an keyaŋ neŋ zemnosem. ");
INSERT INTO naf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Angat Nemuŋaŋ neŋ Kawawaŋgalen Zet Itnaŋaŋ zeinok gakiwap yaŋgut an ŋenaŋ Angat Nemuŋaŋ neŋ kasayet belinan besâpm an ke wakae, sindem omba penaŋ tiwe. An ke mamaŋaŋ ku ambedak ze ŋep bempenak.” ");
INSERT INTO naf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zudas an keyaŋ Zisas kasayet belinan beweyaŋ zeye, “Zikat indanda, geŋ nâgât tazenik, ma?” Zeme Zisasiyaŋ dunduye, “Geŋ zenik kok kemak.” ");
INSERT INTO naf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Zemti Zisasiyaŋ nupmamaŋ ŋen mti Kawawaŋgat wisikŋ zemutumti ndamti zeye, “In mti nit. Kapi nanaŋgat sek sesumbannok.” ");
INSERT INTO naf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nimann delaŋ zeme wain okop tageen ke mti Kawawaŋgat wisikŋ zemti kegogak ndamti zeye, “In ilindiŋ mti nit.” ");
INSERT INTO naf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ewe tatnimambe zeye, “Kapi nanaŋgat sipmnok. Kapi tâtâ alakŋaŋ ammak Kawawaŋmak sipmnaŋ tâmindeyap. Âpme sipm tewen nome sipmnaŋ tobe ke am sambe ekŋen yomengatnan indatim kwakwagat nâmti kegok mbap.” ");
INSERT INTO naf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kegok zemti zeye, “Neŋ penaŋ sukwep zema nâit, neŋ wain tu ke ninipiŋ maneti bamgat Biengalen zemâtâtât katnanen mama kululuŋen gwaen tati wain alakŋaŋ ke nsakwep nbanup.” ");
INSERT INTO naf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Zeme delaŋ zeme keyegak tapeŋ tati sesewat silik kumann delaŋ zeme mkaengatnan toti tambuyelak Olip Kalaŋan mowebenn. ");
INSERT INTO naf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Motati Zisasiyaŋ nembaŋane nin pigok dinndoye, “In kasa kuku an ekŋenaŋ kopme ekŋengat kiŋgati nemkunzuŋ mekopme nenak etaŋ tasap. Kawawaŋgalen Zet Itnaŋanen ikŋaŋ pigok zeye, ‘Neŋ sipsip damuŋ kuma gakime sipsip ekŋenaŋ kileŋ lala bubuk kunzuŋ mekobep.’ ");
INSERT INTO naf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yaŋgut bam Kawawaŋaŋ neŋ mme gakikiengatnan gilik zem watiŋgut Galili msalen mepma in bam napmâkobep.” ");
INSERT INTO naf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Zeme Pitayaŋ zemkatik bemti pigok zeye, “Nemba notnaŋaŋ bamkumgemeseip yaŋgut neŋ ŋep ku bamkumgemesap.!” ");
INSERT INTO naf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Zeme Zisasiyaŋ dopmaŋ pigok gilik zem saye, “Alak tambumbu kapiyet sakokolok apmaŋ kwitnaŋ sakwep kumti sek zut ewe kukupiŋ tapme geŋ nâgât sek tuk yaŋnesenik.” ");
INSERT INTO naf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Zeme Pitayaŋ zekaŋkaŋ mti zeye, “Neŋ nome gakikiyelen msawaŋgut neŋ geŋ ku yaŋgesap penaŋ.” Zeme nemba notnaŋ sambe nin zet sepemaŋ kwep kegogak zemâbenn. ");
INSERT INTO naf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zemti nsakwep olip muluwen msat kwitnaŋ Getsemani ke mebenn. Mepataŋ zemti Zisasiyaŋ nembaŋane ningat zeye, “In kapi totapme neŋ nenak daen metati dundumti kosap.” ");
INSERT INTO naf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Zemti egaŋ Pita ma Zebediyet nemuŋane zut idatetime mebien. Ke meti Zisasiyaŋ yaŋbemti kembeŋ ma keŋ sindem omba nâye. ");
INSERT INTO naf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nâmti nembaŋane tuk ekŋengat zeye, “Neŋ keŋŋ sindem beme gakikiyelenok tapmiap keyepm in muluk wewepiŋ. Neŋmak keik tapmasenup.” ");
INSERT INTO naf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kegok zemti belaknik bugan met ŋeŋzimosetnaset msalen kutuwemti pigok dunduye, “Bien, geŋ nâmane ŋep mimiyelen beme sek sindemgalen nukŋaŋ kapi mâtâtne! Keyaŋgut neŋ nâyapnok yek. Giti nânik kataŋ sokbesem.” ");
INSERT INTO naf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kegok mti egaŋ gilik zem koti nembaŋane tuk indikme meluk taweme indabutemti Pitayet pigok dunduye, “In tuk kwilekiyepmti neŋmak kan belaknik bugan pi keik tati otnânâ mulup bugan ku mbiek? ");
INSERT INTO naf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","In keik tati dombemti dunduit mneti nukŋanen toindosem. Keŋinaŋ nâgât kembeŋ nâyo yaŋgut sekŋinaŋ nukŋaŋ beme tawemo.” ");
INSERT INTO naf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Zisasiyaŋ sek ŋen ewe meti dunduye, “Bien, sek sindemgalen nukŋaŋ kapi ŋep ku mâtâpepeyelen beme ma neŋ ke pupuyelen penaŋ bein beme geŋ nâniknok neŋ ŋep pusap.” ");
INSERT INTO naf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Egaŋ sek ŋen ewe gilik zem koti nembaŋane koindikme meluk tawemambien enenogat zikalinan nukŋaŋ penaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Zisasiyaŋ nembaŋane katim indemti ewe gilik zem meti dundundu sek tuk mge. Ke zet eweŋan dundumti zeye keyegak dunduye. ");
INSERT INTO naf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mti egaŋ nembaŋanemagen gilik zemkoti zeye, “In ewe meluk wemwat wemwat ma kâtnâmtat kâtnâmtat tapmip? Egit! neŋ Angat Nemuŋaŋ kasannaŋ zemnomti am yomtoŋ ekŋengat belinan neneyelen kanlak bein. ");
INSERT INTO naf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wati, kopme metne! Egit, an ŋen neŋ zemnonoyelen ilak kolep!” ");
INSERT INTO naf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zisasiyaŋ ewe nembaŋane nin zet tadindome dindome Zudas nembaŋane 12 ninmagengatnaŋ kwep egaŋ am maŋge temaŋmak wanam ŋilikŋaŋ ma wenzom timti kobien. An ekŋen ke sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ zemindeme kobien. ");
INSERT INTO naf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Selen kopmambe Zudasiyaŋ pigok zemâtâtindaye, “Neŋ meti an mukumpesap ke in ekti keyegagak ataseip.” ");
INSERT INTO naf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zeyenok Zudasiyaŋ Zisasmagen teŋ mebedak zeye, “Tambuyet Amobotnaŋ!” Zemti naŋguman nuknuk mpeye. ");
INSERT INTO naf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Âpme Zisasiyaŋ pigok dunduye, “Kwilekiyet nâmkodak ze, sakwep mi!” Zeme ekŋenaŋ Zisasiyet betnaŋ kili kili atamti zampewien. ");
INSERT INTO naf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Atame an Zisasmak mamambien ekŋenmagengatnaŋ ŋenaŋ wanamaŋ ŋilikŋaŋ mandam kwati sâpe sâpe bumbu an sambeyelen ŋeŋaŋgat mulup nembaŋaŋ wakŋaŋ nembet sâmpeye. ");
INSERT INTO naf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mme Zisasiyaŋ egat pigok zeye, “Geŋ wanamdi munduman gilik zem bepe. Zigogak an ŋenaŋ wanamaŋ kasa makuip ek an notnaŋaŋ wanamaŋ kegogak aŋme gakiwe. ");
INSERT INTO naf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Âpme neŋ Biengat mukulem mimiyet yaŋkwesima egaŋ alagalak kapiyet ensel sopmaŋ sambe penaŋ ku makukuyelen zemindeme kot napmukulem mbiek. Ke geŋ ku nânik? ");
INSERT INTO naf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kawawaŋgalen Zet Itnaŋanen kapigok zenzeŋaŋ neŋ ŋep sindem titiyelen keyepm Kawawaŋgat nemukulem mimiyelen zewak beme Kawawaŋgalen zet itnaŋaŋ keyaŋ penaŋmak ku benak.” ");
INSERT INTO naf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kan keyet Zisasiyaŋ an maŋge temaŋ pigok diindoye, “In nâgât nâme an kambu tititoŋ beme in wanam ŋilikŋaŋ ma wenzomak natatayelen kolo? Neŋ kasup kataŋ Kawawaŋgalen sesewat mka temaŋ keŋan tomtati manzikat indamtemanaŋgut in ku natawien. ");
INSERT INTO naf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Keyaŋgut kwileki sambe sokbep ke nâgât Kawawaŋgalen Zet Itnaŋanen golaŋ zenze an zet meluwaŋ mge ke penaŋaŋ sokbemkawaŋ bembeyelen.” Kegok mme nembaŋane nin ilindiŋ katikpemti kunzuŋ mebenn. ");
INSERT INTO naf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Âpme am Zisas atawien ekŋenaŋ mmeti Kayapas, sâpe sâpe bumbu an sambe ekŋengalen ŋeŋaŋin egat mkaen an zii zet zikat indanda ma sesewat mka temaŋgalen an damuŋ sambeyaŋ ondektabienen ke tetimebien. ");
INSERT INTO naf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mepme Pitayaŋ ewe sukwep tati indamâti Kayapasiyet mka kimbalen mege. Meti kimbat keŋan moti zigok sokbesem ke eegalen Zuda ekŋengalen an kukŋaŋbeŋ kimbat damuŋ ekŋenmak tomtage. ");
INSERT INTO naf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Âpme sâpe sâpe bumbu an ma Zuda am ekŋengalen am ŋeŋaŋ bembeŋin sambeyaŋ Zisas zet zigoset ma kwilekiyet bemzemti gakikiyet zemdelaŋ zempepeyelen timabien. ");
INSERT INTO naf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Am sambe penaŋaŋ ŋeŋaŋ kot sokbemti dâsuki bemzewienaŋgut zet ŋen ku aikbien. Bam delaŋ zenzeŋan an zulaŋ kot sokbemti ");
INSERT INTO naf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","zewun, “An kapiyaŋ zeye, ‘Neŋ ŋep Kawawaŋgalen sesewat mka temaŋ kapi asekmatopme delaŋ zeme nan bet mulup mimi tuk kapiyet keŋan etaŋ ŋep walabak.’” ");
INSERT INTO naf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Âpme sâpe sâpe bumbu an sambeyet ŋeŋaŋinan watati Zisasiyet pigok yaŋkwesiye, “An zut egelaŋ gâgât zet bemzelut kelak ŋep nânak? Keyet geŋ dopmaŋ gilik zenzeyelen ŋen mtadik?” ");
INSERT INTO naf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yaŋkwesime Zisasiyaŋ zet ŋen ku zeye. Ewe keyegak sâpe sâpe bumbu an sambeyet ŋeŋaŋinaŋ egat yaŋkwesiye, “Neŋ Kawawaŋ mama toŋaŋ egat kwitnanen bandim mti gayaŋkwesima geŋ zemkatik bemti dino: Geŋ Kilais Kawawaŋgat Nemuŋaŋ penaŋ?” ");
INSERT INTO naf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Zeme Zisasiyaŋ gilik zemti dunduye, “Geŋ zenik kok kemak. Keyaŋgut neŋ ilinsakwep diindowi: Kan belaknik penaŋ palaŋan in taekme Angat Nemuŋaŋaŋ neŋ Kawawaŋ winde toŋaŋgat betnaŋ penaset Amobotnaŋ tati kululuŋ mgulumbik palen kosowap!” ");
INSERT INTO naf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Zeme sâpe sâpe bumbu an sambeyet ŋeŋaŋinaŋ zet ke nâmti ŋeŋaŋ zimeyepm kâlâpmaŋ mendeleti zeye, “Egaŋ Kawawaŋgat zet mobotnaŋ min. Nin egat zet ŋen zemti zemkukuyelen ewe ku timabagalen! In alagalak kapi egalen kwelat zelak nâyo! ");
INSERT INTO naf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Keyepm in zigok nâip?” Zeme ekŋenaŋ gilik zewien, “Ek yomaŋ zemsalaŋ bepgapm gakime delaŋ pesem.” ");
INSERT INTO naf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Zemti ekŋenaŋ zimosetnan zawaga wasekpemti bet mutumti kuwien ma notnaŋaŋ bet palak palak neŋguman taiwien. ");
INSERT INTO naf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Mti zikatnaŋ kwaikpemti zewien, “Geŋ gitaŋgat golaŋ zenze an manzenik. Ele, golaŋ zenze an mulup mi! Kilais, geŋ kwiyaŋ goin? Ke zemane nâne.” ");
INSERT INTO naf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Âpme Pitayaŋ mka kimbat keŋan kayakŋaŋ totapme sâpe sâpe bumbu an sambeyelen ŋeŋaŋgalen mulup imbi ekŋenmagengatnaŋ ŋenaŋ ekmagen koti zeye, “Geŋ kogok Zisas Galiliyetnaŋmak mambanan.” ");
INSERT INTO naf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kegok dunduye yaŋgut egaŋ ekŋen sambeyet zikalinan yaŋti zeye, “Neŋ geŋ kwiyet tazenik ke ku nâyap.” ");
INSERT INTO naf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Zemti egaŋ kimbat sekekegen metopme mulup imbi ŋenaŋ ekti an ekŋen tabien keyet zeye, “Ek Zisas Nasaletgatnaŋmak mamtan.” ");
INSERT INTO naf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitayaŋ ewe kogak yaŋti gilik zeye, “Neŋ penaŋ sukwep zemkatik bemti zeyap: Neŋ an ke ku nâmpeyap!” ");
INSERT INTO naf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kegok zeme belaknik bugan tati am dendaŋ tapmambien ekŋenaŋ Pitamagen koti zewien, “Penaŋ sukwep, geŋ ekŋenmagengatnaŋ ŋen kwilekiyet zedi ŋandaŋaŋaŋ zein geŋ Galili msalengatnaŋ ekŋengat nolin!” ");
INSERT INTO naf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Zeme Pitayaŋ zeye, “Neŋ zemkatik bemti zeyap. Neŋ penaŋ sukwep penaŋ zeyap! Neŋ dâsuki zeyap beme Kawawaŋaŋ dopmaŋ ŋep mutumnasem. Neŋ an ke ku nâmpeyap penaŋ!” Zeme zeme keyegak sakokolok apmaŋaŋ kwitnaŋ kuye. ");
INSERT INTO naf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kume Pitayaŋ eweŋan Zisasiyaŋ pigok dunduye ke otnâŋge, “Sakokolok apmaŋaŋ kwitnaŋ sek tuk ewe kukupiŋ tapme geŋ nâgât ku nâmpeyap zewanik.” Kegok mti keŋaŋ teŋ peme egaŋ zupman meti si omba penaŋ suye. ");
INSERT INTO naf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Âpme msat msame sâpe sâpe bumbu an ŋeŋaŋ sambe ma amgalen sesewat mka temaŋgalen an damuŋ ekŋenaŋ Zisas gakikiyet zenâmti zemdelaŋ zempewien. ");
INSERT INTO naf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Zemdelaŋ zemti betnaŋ zamti mtetim meti Loma gapmangalen amobotnaŋgat betnan bewien. An ke kwitnaŋ Pailet. ");
INSERT INTO naf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Âpme Zudas an zemkuku egaŋ egeyaŋ Zisaslak gakikiyet zemdelaŋ zempepeŋaŋ beme keŋaŋ gilik zeme mânep kasetnaŋ 30 silwawan mti sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋgalen an damuŋ gilik zem indamti ");
INSERT INTO naf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","pigok zeye, “Neŋ an teŋ zemkuma gakikiyet zapat beme yom temaŋ tiap.” Zeme ekŋenaŋ dunduwien, “Ke ningalen kwitnaŋ kwitnaŋ yek. Ke giti nâniknok msenik.” ");
INSERT INTO naf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Zeme Zudasiyaŋ mânep kasetnaŋ mkoti Kawawaŋgalen sesewat mka temaŋ keŋan peme topme katimindemti mege. Meti tapelen tage. ");
INSERT INTO naf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kegok mme sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ mânep ke makum timtati zewien, “Mânep kapi sipgalen tosa. Ke ningalen zii zelaŋ mânep keboŋaŋ Kawawaŋgalen sesewat mka temaŋgalen tewalaŋ keŋan ku bembeyelen zemkatikbembeŋaŋ.” ");
INSERT INTO naf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Keyepmti ekŋenaŋ zenâmti zemtâmpemti mânep ke mtati an menzim weyeyaŋ egalen msat kwitiwien ke am Zuda maŋgeen ku sokbembeŋaŋ indabembeyelen sumin. ");
INSERT INTO naf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kegok mti msat ke kwitnaŋ “Sip Msat” kuwienaŋ pigogat ewe makup. ");
INSERT INTO naf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kegok mme golaŋ zenze an Zelemaiayaŋ pigok zeyenok penaŋ bein, “Islael am ekŋenaŋ mânep kasetnaŋ 30 silwa ke mti egat tosaŋaŋ kwititiyelen zemtâmpewien. ");
INSERT INTO naf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mti mânewan mtati an menzim weyayaŋgalen msat kwitiwien. Ke Amobotnaŋaŋ neŋ zemâtât neŋgenok.” Ke penaŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Âpme Zisasiyaŋ Loma gapmangalen amobotnaŋgat zimosetnaŋ tapme egaŋ yaŋkwesiye, “Geŋ Zuda am ekŋengalen amobotnaŋ, ma?” Zeme Zisasiyaŋ zeye, “Geŋ zenik kok kemak.” ");
INSERT INTO naf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kegok zeme sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ Zisasiyet yom ombem zewienaŋgut Zisas ek yomepiŋ keyepm ekŋengalen zeombem zenzeŋinaŋgat dopmaŋ ŋen ku diindoye. ");
INSERT INTO naf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kegok mme Pailelaŋ egat pigok zeye, “Geŋ ekŋenaŋ zet sambe gâgât tabemzeip ke tatnânik ma yek?” ");
INSERT INTO naf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yaŋkwesiye yaŋgut Zisasiyaŋ dopmaŋ zet kwep bugan gilik zenzepiŋ mge. Kok keyepmti Loma gapmangalen amobotnaŋaŋ nâmtemtem omba penaŋ mge. ");
INSERT INTO naf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Âpme nup kan kwep kwepgat Aŋgalalaŋ Kendoyet Loma gapmangalen amobotnaŋaŋ an mka katikŋan nup kan kwepgat an kwep ma nup kan ŋengat sepem kegogak maindemekwawetemien. Am ekŋenaŋ an kwiyet kwitnaŋ makumtemienen ke matalasim indam kwatan. ");
INSERT INTO naf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kan keyet an bekanaŋ kwizetpatnaŋmak ŋen mka katikŋan matatan kwitnaŋ Zisas Balabas. ");
INSERT INTO naf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Keyepmti amnaŋ ondekme delaŋ peme Pailelaŋ pigok indayaŋkwesiye, “An kwi in neŋ belak lala kwalepema kokogalen nâip: Balabas ma Zisas am notnaŋaŋ Kilais manzeip keyet nâip?” ");
INSERT INTO naf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailelaŋ Zuda am ekŋengalen am ŋeŋaŋ bembeŋin ekŋenaŋ Zisasiyet mulupmaŋgalen ma windeŋaŋgalen keŋ kuku mti ekmagen wakobien keyet egaŋ ŋep penaŋ nâŋge. ");
INSERT INTO naf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kegok zeme Pailelaŋ zemdelaŋ zenze munduman mka keŋan totapme imbiŋaŋaŋ mulup anaŋ zempeme egat zet zapat pigok kot zeye, “Geŋ an yomepiŋ ke kwileki ŋen msasapiŋ. Neŋ an keyet paleset ki bekan bekan alak tambuyet takimbemayet.” ");
INSERT INTO naf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kegok zeme sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ an imbi sambeyet keŋin walati Pailetgat yaŋkwesime Balabas kwaletindamti Zisas gakikien pepeyelen am keŋin walabien. ");
INSERT INTO naf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kegok mbienaŋgut Pailelaŋ ewe am sambe pigok indayaŋkwesiye, “Eget zut kapimagengatnaŋ kwi in neŋ belak kwaletpepeyelen nâip?” Zeme ekŋenaŋ zewien, “Balabas!” ");
INSERT INTO naf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Zeme Pailelaŋ yaŋkwesiye, “Neŋ Zisas am notnaŋaŋ Kilais manzeip ke zigok penaŋ msap?” Ke zeme ekŋenaŋ ilindiŋ yaŋbemti kwizet kuwien, “Tewen kume gakik!” ");
INSERT INTO naf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kegok zeme Pailelaŋ ewe indayaŋkwesiye, “Ek yom kwitnaŋ kwileki mgeyepm?” Zeme ekŋenaŋ ilindiŋ kwizet kwakwak omba penaŋ mti zewien, “Tewen kume gakik!” ");
INSERT INTO naf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Âpme Pailelaŋ egeyaŋ tapmnepe kasa ŋenzinziŋ sokbembeyelenok kok beme egaŋ ewe ŋep ku zenzeyelen. Keyepmti tu mti betnaŋ am sambeyet zikalinan zuluti zeye, “An kapiyelen gakiki ke neŋ toŋaŋ ku beyap. Ke ilinaŋgalen kwitnaŋ kwitnaŋ!” ");
INSERT INTO naf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kegok zeme am sambe ilindiŋ zewien, “Pemane egalen gakikiŋaŋgalen dopmaŋ ke nin ma nemunambanne ningat palen wembe!” ");
INSERT INTO naf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kegok zeme Pailelaŋ Balabas kwaletindaye. Âpme Zisas peme witikti piliŋ tewen kukuyelen an kukŋaŋbeŋgat belinan beye. ");
INSERT INTO naf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Âpme Loma ekŋengalen kasa kuku an ekŋenaŋ Zisas aikti Pailetgalen mka temanen mmeti kasa kuku sambe ilindiŋ bembuluŋti tabien. ");
INSERT INTO naf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mti ekŋenaŋ Zisas ikŋaŋgalen sâkŋaŋ gulumpemti melakandu ŋamaŋ teepmaŋ ŋenaŋ miakpemti ");
INSERT INTO naf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","naman sepmeŋaŋ amobotnaŋgalen elimiaknok muŋgumti ŋokŋan peme toge. Mti takanzi ŋen betnaŋ penanen sawien. Ekŋenaŋ kwitnaŋ kwitnaŋ mbienen ke amobotnaŋgalen kataŋ miakpewien. Kegok miakpemti mamkandaŋan pedondom samti mobotnaŋ ma pep msamti zewien, “Zuda am ekŋengalen amobotnaŋ kwesiŋ mamanigaŋ mamambanik!” ");
INSERT INTO naf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kegok mti zawak wasekpemti takanzi mtati ŋokŋan kwep kwep meti witikbien. ");
INSERT INTO naf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Âpme ekŋenaŋ mobotnaŋ ma pep msame delaŋpeme melakandu ŋamaŋ teepmaŋ gulumpemti ikŋaŋgalen sâkŋaŋaŋ miakpewien. Mti aikti kukuyelen wapmebien. ");
INSERT INTO naf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ekŋenaŋ Zelusalem mkayelen kimbalen toti mesât meti an ŋen Sailini msalengatnaŋ kwitnaŋ Saimon aikti kasa kuku ekŋenaŋ Zisasiyelen tep pupuyelen apitilimpeme puye. ");
INSERT INTO naf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kegok mme moti msat ŋen Ibulu ekŋengalen zeleset kwitnaŋ Golgata ke pataŋ pewien. Golgata ke nanzaŋ sakamaŋ am gakikiŋaŋgalen ŋokaset nemboŋ keyepm kwit ke “Ŋokasetgalen msat” makumtemien. ");
INSERT INTO naf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pataŋ pemti ekŋenaŋ Zisas wain tu sakokolokgalen munziŋ kaŋkaŋaŋmak lelimti sawienaŋ nime ŋep kumbeme wisat mge. ");
INSERT INTO naf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kegok mme tewen masasokpemti gwilimaŋ kuwien. Ikŋaŋ kumti sâkŋaŋ maŋge kwep bemti nanzaŋ guluk gilik mti an ŋenaŋ nanzaŋ omba kumtiwien kataŋ saŋgum melakanduŋaŋ kwep kwep kalaŋ tiwien. ");
INSERT INTO naf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mme delaŋ zeme ke totati Zisasiyet damuŋ mbien. ");
INSERT INTO naf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Âpme ŋokŋaŋgat palaŋaŋ zet muluwaŋ zet ombemzemti tep palen kuwien. Ke kapigok kumpewien, ");
INSERT INTO naf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mti ekŋenaŋ an kambu titi zut Zisasmak ŋen betnaŋ penaset ma ŋen betnaŋ alomeset tewen gwilimaŋ idowien. ");
INSERT INTO naf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Âpme am keeset mebe kokot mbien ekŋenaŋ ŋok kiliŋ kiliŋ mti Zisas tipkwasisi zet pigok dunduwien, ");
INSERT INTO naf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Geŋ an kapiyaŋ Kawawaŋgalen sesewat mka temaŋ asekmatopme neman ewe bepmulup mimi tugat keŋan etaŋ walalagalen zewanan! Geŋ penaŋ Kawawaŋgat Nemuŋaŋ beme gitaŋgat sekdi aŋgalaŋti tewengatnaŋ kwatot!” ");
INSERT INTO naf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sepem kegogak sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ pep msamti pep palen pigok dunduwien, ");
INSERT INTO naf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Egaŋ am notnaŋ mukulem mamiindenaŋ ikŋaŋgat sekŋaŋ ŋep ku mukulem mpein! Ek Islael ekŋengalen Amobotnaŋ bein bemelak tewengatnaŋ kwatopme nin ekti penaŋ nâmkiŋpesenup! ");
INSERT INTO naf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Egaŋ Kawawaŋ nâmkiŋpemti manzein, ‘Neŋ Kawawaŋgat Nemuŋaŋ.’ Ŋep, kegogat kame taekmann Kawawaŋaŋ alak aŋgalaŋpesâpm manzemti ekne!” ");
INSERT INTO naf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sepem kegogak an kambu titi zut ekmak tewen idowienaŋ tipkwasisi zet dunduwun. ");
INSERT INTO naf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tewen kuwienen ke tatnepeme tinsutnan beme msat ilindiŋ sopsop kume tambumbuyaŋ sumuŋ tatnepeme 3 kilok mee kegok beye. ");
INSERT INTO naf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tambum tatnepe 3 kilok mee kegok beme Zisasiyaŋ kwizet Ibulu zeleset omba pigok kuye, “Eloi, Eloi, lama sabaktani?” Zet ke yaŋaŋ pigok, “Kawawaŋŋ, Kawawaŋŋ, geŋ kwilekiyet katiknenak?” ");
INSERT INTO naf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kegok kume am notnaŋ sokŋan ke tabien ekŋenaŋ nâmti pigok zewien, “An piwan Ilaiza golaŋ zenze an itnaŋaŋ egaŋ mukulem mpepeyelen takun.” ");
INSERT INTO naf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Âpme ekŋenmagengatnaŋ ŋenaŋ sakwep winde bem meti kwilekiŋen yembem nemboŋ ke mti wain tu akŋaŋ keyet keŋan pemetopme mwati pum kasetnaŋ dukŋan bem zampemti Zisas same niniyelen mge. ");
INSERT INTO naf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kegok msât mgeyaŋgut am notnaŋ ekŋenaŋ zewien, “Petalak, kame tati ekmann Ilaizayaŋ koti mukulem mti mâtâtpesâpm manze ekne!” ");
INSERT INTO naf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kegok tazeme Zisasiyaŋ kwizet omba ewe kumti yek beye. ");
INSERT INTO naf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kegok mti gakime Kawawaŋgalen sesewat mka temanen utu kekek saŋgum teepmaŋ mapeme totatan ke sutnan temaŋ kauyetnan eselempeme mane mane kaim delaŋ zeye. Mti mâkinaŋ mme msat titok mme nanzaŋ sambe epeewien ");
INSERT INTO naf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ma am sum sambe kegok andeye. Âpme Kawawaŋgalen an imbi sambe nâmkiŋpepemak gakiwien ekŋen mbelak zemindeme mamaen wabien. ");
INSERT INTO naf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wati ekŋenaŋ sumin katipewien. Âpme Zisasiyaŋ gakikiengatnaŋ wage keyet palaŋaŋ Zelusalem mka teman mepme am sambeyaŋ indikbien. ");
INSERT INTO naf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kegok sokbeme kasa kuku ŋeŋaŋ ma kasa kuku an Zisasiyet damuŋ tabien ekŋenaŋ mâkinaŋ mge ma kwilekiki notnaŋ sambe ke sokbemmege ke ekti igagen penaŋ kiŋgati pigok zewien, “Penaŋ sukwep, an kapilak Kawawaŋgat Nemuŋaŋ penaŋ!” ");
INSERT INTO naf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Imbi notnaŋ ekŋenaŋ kegogak sokŋanik tati Zisas ektitimti tapmambien. Imbi ekŋen ke eweŋan Galili msalen gwaenen mâpmamti mukulem mampemtemien. ");
INSERT INTO naf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ekŋen kemagengatnaŋ kwilin Malia Makdala mkaengatnaŋ ma Malia Zemsmak Zosep egegat mamit ma imbi ŋen Zebediyet imbiŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Âpme gasim beme an mânep milawatnaŋ temaŋ ŋen kwitnaŋ Zosep mkaŋaŋ kwitnaŋ Alimatia ek kegok Zisasiyet nemuŋaŋ mamtan egaŋ koti ");
INSERT INTO naf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pailetmagen meti Zisas sekŋaŋ mmet bembeyet yaŋkwesime Pailelaŋ kasa kuku anene ekŋenaŋ Zisasiyet sekŋaŋ ke Zosep sasayelen diindoye. ");
INSERT INTO naf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kegok mme Zosewaŋ mtoti saŋgum alakŋaŋaŋ sumuŋpeye. ");
INSERT INTO naf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kegok mpemti ikŋaŋgalen sum alakŋaŋ penaŋ nanzaŋ palakŋaŋ keŋan kakalimpeyeen keyet keŋan Zisasiyet sekŋaŋ bempemti nanzaŋ temaŋ ŋen wililime meti sum zetnaŋ bekek tapme mege. ");
INSERT INTO naf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Âpme Malia Makdala mkaengatnaŋ ma Malia ŋen egelaŋ zimoselit sumeset ektapmambun. ");
INSERT INTO naf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Âpme mseŋan Sabat tagoŋgo kan beye keyet sâpe sâpe bumbu an ŋeŋaŋ ma Palisi ekŋenaŋ Pailetmagen meti ondekti ");
INSERT INTO naf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ekŋenaŋ pigok zewien, “Amobotnaŋ, an dâsukitoŋ egaŋ alik mamtanen zet kapigok zeye, ‘Bet mulup mimi tuk delaŋ zeme neŋ ewe belak zem wabap.’ Kegok zeye ke nin nânup. ");
INSERT INTO naf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Keyepmti mulup zet indamane sum ekdamuŋ mtapme bet mulup mimi tuk bewe. Mneti nembaŋane ekŋenaŋ meti sekŋaŋ kambu mkwawebepgat ma am ekŋenaŋ gakikiengatnaŋ belak zem walep koke zewepmagengat ke damuŋ mbanup. Zet alik mamti zeye keyaŋ dâsuki penaŋ bein keyaŋgulak zet dâsuki temaŋ penaŋ bam sokbesâpm keyaŋ dâsuki kukŋaŋgat ke sebempesâpm.” ");
INSERT INTO naf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Zet ke kasa kuku ekŋenaŋ zeme Pailelaŋ ekŋengat kapigok zeye, “In kasa kuku an notnaŋ indatetimti sum weyaŋti penaŋ damuŋ mseip.” ");
INSERT INTO naf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kegok zeme ekŋenaŋ met sum weyaŋti damuŋ mimiyelen kasa kuku an indemti nanzaŋ sekekek ke welime mekindiŋ zeme tegaŋ melim kwalim mbien mneti amnaŋ tek ke mpemti kambu mmeseipmagen nâmti piliŋ zampewien. ");
INSERT INTO naf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Âpme Sabat tagoŋgo kan delaŋ zeme mseŋan Sonda tambuŋan msat tapmsame msame Malia Makdala mkaengatnaŋmak Malia ŋen kemak Zisasiyelen sum eksât mebun. ");
INSERT INTO naf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Âpme Amobotnaŋgalen ensel ŋenaŋ kululuŋengatnaŋ kwatoge keyepm mâkinaŋ temaŋ memendepmak mge. Ensel keyaŋ kwatoti sumen ke meti nanzaŋ sekekek mâtâpemti keyet dukŋan totapmaŋge. ");
INSERT INTO naf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ensel ek sepemaŋ ambeyak nemboŋ ma sâk miayakŋaŋ satnaŋ leŋganaŋ penaŋ. ");
INSERT INTO naf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Âpme kasa kuku damuŋ tabien ekŋenaŋ egat kiŋgagat omba mti selin belin omba wendime katik katik sim gakikiŋaŋnok msalen tokutumti wembien. ");
INSERT INTO naf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kegok mme enselaŋ imbi egegat pigok zeye, “It kiŋgagapiŋ. Ke neŋ nâyap, it Zisas tewen kukuŋaŋ egat tatimalup. ");
INSERT INTO naf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ek kapi ku tazin. Ek itnaŋaŋ zeyenok belakzem walep. Pien koti mundumaŋ bewienen egit. ");
INSERT INTO naf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","It sakwep kapiyak meti nemuŋane pigok diindoseip, ‘Eklak gakikiengatnaŋ walep. Mti egaŋ ŋeŋaŋ bemindemti Galili msalen alak mezin in ke meti ekseip!’ In neŋ zet diindowan ke nâit!” ");
INSERT INTO naf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kegok mti egelaŋ kiŋgagat ma oloŋen temakwep nâmti sum sakwep katikpemti nembaŋane ningat zapat dinndosât winde bembeŋak mebun. ");
INSERT INTO naf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Âpme Zisasiyaŋ eget memendepmak idaikti diidoye, “Tambuŋan penaŋ, keŋ sewakŋaŋ itmak tasem.” Zeme egelaŋ ekmagen koti setnaŋ ambepumti sesewatsawun. ");
INSERT INTO naf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kegok mmalut Zisasiyaŋ egegat diidoye, “It ku kiŋgalit. It meti nembanne ekŋengat zemalut ekŋenaŋ Galili daen meti ke menaikbep.” ");
INSERT INTO naf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Âpme imbi egelaŋ selen tapmepmalu an kasa kuku sum damuŋ tabien ekŋenmagengatnaŋ notnaŋaŋ gilik zemti Zelusalem mka teman meti sâpe sâpe bumbu an ŋeŋaŋ ekŋen kwitnaŋ kwitnaŋ sambe sokbeye keyet zapatnaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Zapat ke mme sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ nâmti sesewat mka temaŋgalen an damuŋ ekŋenmak ondekti zet zemtâmpewien. Kegok mti kasa kuku ekŋen mânep makukuŋaŋ temaŋ penaŋ indamti ");
INSERT INTO naf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","pigok zewien, “In am pigok diindoseip, ‘Nin meluk tawemann nembaŋaneyaŋ tambuyet koti Zisasiyet sekŋaŋ kambu mmelo.’ ");
INSERT INTO naf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Âk Loma ekŋengalen amobotnaŋaŋ zapat kapi nâsem beme nin ŋep zemann nâsem. Âpme in keyet yayaŋ ku mseip.” ");
INSERT INTO naf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kegok zeme kasa kuku ekŋenaŋ nâme ŋep beme mânewin timti zemâtâtindawienok zemebien. Kok keyepmti zapat kapiyaŋ Zuda am ekŋenmagen palakŋaŋ beyeyaŋ pigogat ewe tazin. ");
INSERT INTO naf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Âpme nembaŋane 11 nin Galili msalen meti kalaŋ ŋen Zisasiyaŋ ikŋaŋ zemâtâtndaye ke mebenn. ");
INSERT INTO naf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Meti ikŋaŋ aikbenn ya nembaŋaneyaŋ nin dundum sawennaŋgut notnaŋaŋ egaŋ gakikiengatnaŋ wage keyet keŋ zut mbien. ");
INSERT INTO naf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mme Zisasiyaŋ sokŋan koti zeye, “Winde sambe kululuŋ keŋan ma msat palen Kawawaŋaŋ neŋ name delaŋ zenzeŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Keyepmti in msat kataŋ meti am sambe Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ zikat indame nâgât nâmkiŋpeme Kawawaŋ Bipm ma nâgât kwitnnan ma Emetak Teŋ ningat kwitnnan tu zulutindewep. ");
INSERT INTO naf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mti neŋ kwitnaŋ kwitnaŋ sambe zemâtâtindawan ke gawepupuyelen kegok zikat indawep. Âpme neŋ zema nâit, neŋ kan kataŋ inmak kwesiŋ kwesiŋ mamti tapmanepema kan delaŋ zenzeŋaŋ bewe.” ");
INSERT INTO naf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Zânaŋ Kawawaŋgat Nemuŋaŋ Zisas Kilaisiyelen Zet Zapatnaŋ Dolakŋaŋ kapi yaŋbemti ku zemsokbeye. ");
INSERT INTO naf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kwitnaŋ kwitnaŋ kapuk sokbembeyet Kawawaŋgalen golaŋ zenze an Aizayayaŋ eweŋan baen meluwaŋ pigok mge: “‘Nânik!’ Kawawaŋaŋ zet pigok zeye, ‘Neŋ buŋam zapat zenzenn an ŋen zempema egaŋ koti ŋeŋaŋ bemindamti selin weyaŋindewe.’ ");
INSERT INTO naf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","An ŋenaŋ msat tuŋgupman kwizet kapigok takuin, ‘Amobotnaŋgat setnaŋ weyaŋme doaŋaŋ bak.’” ");
INSERT INTO naf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Zet keyet kataŋ Zân tu zululut anaŋ msat tuŋgupman sokbemkawaŋ beme am sambeyaŋ ekmagen meti yomengatnan keŋin gilik zemti tu zulupme Kawawaŋaŋ yomin zemzulutindendeyet mandiindomtan. ");
INSERT INTO naf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Âpme Zudia msalen ma Zelusalem mka teman am mambien ekŋen sambeyaŋ ekmagen âlâk zem meti mama mimiŋin bekanaŋ ke zemsokbeme Zânaŋ Zodan tuyen tu zulutindeye. ");
INSERT INTO naf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Âpme Zânaŋ ikŋaŋ melakanduŋaŋ teepmaŋ kamel keyet zupmaŋaŋ weyayaŋaŋ ke peme topme bitimaŋ soŋgom sekŋaŋaŋ weyayaŋaŋ pemanen zamamtan. Âpme meuŋaŋ gwidek ma bizik tuŋaŋ mee ke timti manimamtan. ");
INSERT INTO naf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Egaŋ Zet Zapat Dolakŋaŋ kapigok am zemkawaŋ bemindaye, “An bamnanen takozin, ek windeŋaŋbeŋ penaŋ, ek bekeboŋ neŋ bukaboŋaŋ eleŋaŋ timpema ŋep ku bewe. ");
INSERT INTO naf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neŋ belak in tu etaŋ manzulutindeyap. Yaŋ egaŋ ikŋaŋ kobeen Kawawaŋgalen Emetak Teŋ ke indame tiwep.” ");
INSERT INTO naf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kan keyet Zisasiyaŋ Nasalet mkaengatnan Galili msalen kopataŋ zemti Zânmagen mepme Zânaŋ Zisas Zodan tuyen tu zulutpeye. ");
INSERT INTO naf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Zulutpeme Zisasiyaŋ tuyengatnan kwapme kwapme keyegak kululuŋ ŋandem tapme Kawawaŋgalen Emetak Teŋaŋ sasakandenombe keboŋ bemti ekmagen toge. ");
INSERT INTO naf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Topme kululuŋengatnaŋ zet ŋen kapigok toge, “Geŋ nâgât Nemun dolakŋaŋ penaŋ. Neŋ gâgât gogot penaŋ mamiap. Geŋ nâgât keŋ mamim oloŋen bemnenik.” ");
INSERT INTO naf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Zemdelaŋ zeme keyegak Kawawaŋgalen Emetak Teŋaŋ Zisas peŋpeme msat tuŋgupman igak mege. ");
INSERT INTO naf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Meti ke kasup 40 kegok soŋgom kukŋaŋbeŋ didikŋaŋgatnaŋ ekŋengat tuŋguwinan meti mame Sadaŋgalen tetimaemae sambe sokbemsaye yaŋgut egaŋ katikŋaŋ bemti tage. Kegok mme Kawawaŋgalen ensel kululuŋengatnaŋ ekŋenaŋ kot mukulem mpewien. ");
INSERT INTO naf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Âpme amobotnaŋ Elolaŋ Zân mka katikŋan peme tage. Kan keyet Zisas ek Galili msalen meti Kawawaŋgalen Zet Zapat Dolakŋaŋ am sambe ");
INSERT INTO naf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","pigok manzemzikat indametan, “Kawawaŋgalen zemâtâtâtgat katnanen mama kan bududuk bein. Keyet yomengatnan keŋin gilik zemti Kawawaŋgalen Zet Zapat Dolakŋaŋ nâmti nâmkiŋpeit.” Kegok mandiindometan. ");
INSERT INTO naf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yaŋ miseŋen Zisasiyaŋ Galili tundua ganzenaset wapme wapme metneti Saimonmak datnaŋ Endulu egelaŋ tunduaen aŋgalayet eleŋgolamidan aŋgala tatimalut idige. An zut ke muluwit ŋotekŋaŋ aŋgala titi mulup ke mammtemun. ");
INSERT INTO naf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yaŋ Zisasiyaŋ metneti idikti pigok diidoye, “An zut, it neŋmak kopmalu meti neŋ aŋgala matilup kegogak am timti neŋmagen tusum indendeyelen mulup ke zikat idawap.” ");
INSERT INTO naf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Zeme egelaŋ nânâŋak eleŋgolamit mee pi timalu temepme keyegak wati Zisas mâpmebun. ");
INSERT INTO naf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Belaknik bugan dati meti naman Zebediyet nemulatnenet Zemsmak Zân idaige. Egelaŋ kegogak waŋgaŋidan tati eleŋgolamit taomkekmalu ");
INSERT INTO naf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","idikti keyegak kwizet idakumtetime nâmti biwit Zebedi ma mulup an notnaŋ waŋgaen tabien ekŋen katim indemti kot Zisas mâti mebun. ");
INSERT INTO naf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Meti ekŋenaŋ Sabat tagoŋgo kanen kan keyet Zisasiyaŋ nembaŋane ekŋen ke indatime Kapaneam mkaen moti Zuda ilinaŋgalen sesewat mkaen moweti Kawawaŋgalen Zet Zapat Dolakŋaŋ am zemzikat indammege. ");
INSERT INTO naf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Âpme amnaŋ zetnaŋ ke nâmti zet zenzeŋaŋgat nâmtemtem omba penaŋ mbien. Zisasiyaŋ naman zii zet zikat indanda an ekŋenaŋ zet manzemtemienen e silim indemti windeŋaŋbeŋ zemzikat indammege. ");
INSERT INTO naf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Âpme an ŋen we bekanaŋmagaŋ totapmaŋgeyaŋ wat kaŋkaŋ temaŋ kumti zeye, ");
INSERT INTO naf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Zisas Nasalet mkaengatnaŋ, geŋ eneyet kot omenzaŋ ndamti ndawalesâgât tapmnik? Geŋ Kawawaŋmagengatnaŋ An Teŋ penaŋ ke nâmâtâgeyap.” ");
INSERT INTO naf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zeme Zisasiyaŋ we bekanaŋ an keŋan tage keyet zemkulumpemti zeye, “Geŋ zet sambe mimipiŋ buzak angat keŋangatnan kwati belakŋan met!” ");
INSERT INTO naf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Zeme we bekanaŋaŋ an bekan piwan sekŋaŋ windeŋaŋbeŋ mbutemti kaŋkaŋ temaŋ penaŋ kumti an keŋangatnan kwati mege. ");
INSERT INTO naf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Âpme am tabien ekŋenaŋ nâmtemtem penaŋ mti ilinak met zenâ zenâ mti zewien, “An kapi kwilekiyet set alakŋaŋ penaŋ zikat ndame eknuwa? An kapi we bekanaŋ ekŋen zemindeme mebegalen keyet windeŋaŋ tasaingapmti zetnaŋ zeme gawepumti mezin.” ");
INSERT INTO naf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Âpme keyet zapatnaŋaŋ sakwep penaŋ Galili msalen ilindiŋ palakŋaŋ bemekopme am sambeyaŋ nâme delaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Zemsmak Zânaŋ Zisasmak ilinsakwep Zuda ilinaŋgalen sesewat mkaengatnan toti Saimonmak Endulu egegalen mkaen mowebien. ");
INSERT INTO naf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Âpme Saimongat tatnaŋ imbi zawat sek kikip temaŋ tapmme keyet zapatnaŋ Zisasiyet ");
INSERT INTO naf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","dundume nâmti egaŋ mka keŋaŋ tawemaŋgaen ke meti betnanen atamti mwapme keyegak zawat sek kikip bepiwan katikpeme wati timbumuluŋ indaye. ");
INSERT INTO naf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mti tatnepeme msat tambusât tapmme am notnaŋ ekŋenaŋ noline zawatmak ma we bekanaŋinmak indatimti Zisasmagen kopmâbien. ");
INSERT INTO naf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kogogak mka keyetnaŋ am mee piyaŋ ilinsakwep mka dembusegeset pi met gak zemti tabien. ");
INSERT INTO naf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Âpme egaŋ an zawalin sepem igak igak ma we bekanaŋinmak mâtindeme we bekanaŋ ekŋenaŋ Zisasiyet yaŋaŋ nâmâtâpewiengapmti egat yaŋaŋ ku zemsokbembeyet zemkulumindeye. ");
INSERT INTO naf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mulup ke tapmmetneti weŋge yaŋ tambuŋan penaŋ ewe msasapiŋ tapme Zisasiyaŋ wati mkaengatnan toti msat kwisak piŋan penaŋ igak metati dundundu mulup tapmimaŋge. ");
INSERT INTO naf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Âpme Saimonmak am notnaŋ tabienaŋ Zisas mâti mebien. ");
INSERT INTO naf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Meaikti zewien, “Zisas! Am sambe ekŋenaŋ gâgât tatimalip.” ");
INSERT INTO naf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zeme Zisasiyaŋ pigok diindoye, “Neŋ Kapaneam mka ke wa belak ku pemkola, ke nin mka sokŋanik notnaŋ tapmezinen ke meti Zet Zapat Dolakŋaŋ eyo diindondoyet nâmti kola.” ");
INSERT INTO naf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Âpme Galili msalen mka kataŋ tokwati Zuda ilinaŋgalen sesewat mkaen meti Zet Zapat Dolakŋaŋ diindomti am notnaŋ we bekanaŋaŋ keŋinan tatatnaŋ eyo mâtindeye. ");
INSERT INTO naf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Âpme an ŋen liŋgit satnaŋmagaŋ Zisasmagen kotpedondom samti pigok yaŋkwesiye. “Amobotnaŋ, geŋ ŋep weyaŋneneyelen nânik beme liŋgit satn kapi mmane ŋeluk.” ");
INSERT INTO naf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Zeme Zisasiyaŋ an ke ekti egat kembeŋ penaŋ nâmti betnaŋaŋ sekŋanen timakti zeye, “Ŋep nâmgeyapgat liŋgidi ŋepbak!” ");
INSERT INTO naf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kogok zeme keyegak liŋgit satnaŋaŋ piwan ŋelume sekŋaŋ dolakŋaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Âpme Zisasiyaŋ an keyet zeye, “Geŋ meti am ŋengat sedi dolakŋaŋ bep keyet zet zapatnaŋ ku diindomane nâseip. Geŋ belak buzak meti sâpe sâpe bumbu an ekmagen mepmane egaŋ sekdi weyaŋ wiliŋgim gikme delaŋ zeme geŋ eweŋan baenen Mosesiyaŋ sâpe sâpe zigoset bumbuyelen meluwaŋ mge keyet kataŋ Kawawaŋgat sâpe sâpe bumane amnaŋ liŋgit satnaŋdi dolakŋaŋ bep keyet yaŋaŋ nâseip.” Zisasiyaŋ zet windeŋaŋbeŋ kegok zemti keyegak zempeme mege. ");
INSERT INTO naf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yaŋgut an piwan selen mepmambe dolakŋaŋ beye, keyet zet zapatnaŋ am sambe diindom mege. Keyepmti Zisasiyaŋ mka teman am sambeyaŋ kot bemisikti bembuluŋ tabien. Keyepmti egaŋ igak msat tuŋgupman meti âlâk gâlâk tapme am mka ŋande sambeyaŋ ekmagen kopmâbien. ");
INSERT INTO naf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Zisasiyaŋ mameti ewe gilik zem Kapaneam mka teman kopataŋ zeme amnaŋ buŋamaŋ nâmbien. ");
INSERT INTO naf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nâmti am sambeyaŋ kot mka keŋan ma set dembiseen meti gak zem tapme Zisasiyaŋ Zet Zapat Dolakŋaŋ tadiindomaŋge. ");
INSERT INTO naf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Diindomambe tapme an zulak zulagaŋ an wesiŋ luanzamti Zisasmagen kobien. ");
INSERT INTO naf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Koti ekme am sambeyaŋ misik tabiengapm Zisasmagen sokŋan kokogat kwindemti mka nukŋan moti Zisas tageen penaŋ ke mka ŋokŋaŋ ampambelaŋ taiiŋaŋ ke asekbem asekbem mti aimboŋan an wesiŋ ke luaŋaŋ melesiŋ tegen timtapme âlâŋ âlâŋ peme towege. ");
INSERT INTO naf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zisasiyet kandaŋan towepme Zisasiyaŋ nâmkiŋpepeŋin kaliŋaŋ ke ekmâtâti awesiŋgat zeye, “Nemun, gâlen yomdi katikpeyap.” ");
INSERT INTO naf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Zeme zii zet zikat indanda an notnaŋ tapmambien ekŋenaŋ zet ke nâmti keŋinaŋ kapigok otnâmbien, ");
INSERT INTO naf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“An kapi Kawawaŋgat zet mobotnaŋ penaŋ min! Msalen an ŋen yom katikpepeyelen windeŋaŋ ku tazin; yom katikpepe mulup e Kawawaŋgalen etaŋ!” ");
INSERT INTO naf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nânâ keboŋ otnâme keyegak Zisasiyaŋ keŋinaŋgat yaŋaŋ ekti pigok diindoye, “Kwilekiyet in nânâ bekanaŋ keboŋ keŋinanen taotnâip? ");
INSERT INTO naf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","In nâme an wesiŋgat zet zigok zenzeyelenaŋ eleŋ beleŋ bein, ‘Yomdi delaŋ zein’; ma ‘Wati luendi gapumti met keyaŋ bein?’ ");
INSERT INTO naf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pi Angat Nemuŋaŋ neŋ keyepmti neŋ msalen am yomin katikpepeyelen Bien Kawawaŋaŋ windennaŋgayaŋ tatnain, ke mma in nâgât yaŋŋ nâmâtâtâtgalen miap.” Zemti awesiŋmageset ekti zeye, ");
INSERT INTO naf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Geŋ wati sinkwilimbaŋdi ambepelet timti mkandan met.” ");
INSERT INTO naf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Zeme egaŋ wati keyegak sinkwilimbaŋaŋ ambepelet timtoti tambaŋgumen mepme am sambeyaŋ ekti nâmtemtem temaŋ penaŋ mti zewien, “Nin muluwaŋ kapi mamanamaŋ penaŋ sokbeme eknup. Zemti Kawawaŋgat kwitnaŋ mwati sesewatpewien.” ");
INSERT INTO naf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Egaŋ mulup ke mme delaŋ zeme mka petapme toti ewe Galili tundua ganzenan negak mepme am sambeyaŋ ek ekti kot ondekti bembuluŋ tapme egaŋ Kawawaŋgalen Zet Zapat Dolakŋaŋ zemzikat indammge. ");
INSERT INTO naf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tadiindoneti toti met Alipiasiyet nemuŋaŋ Liwai takis mânep mkaen totati mulup tapmme ekti zeye, “Geŋ kopmane medi.” Zeme keyegak mulupmaŋ bee pem wati toti koge. ");
INSERT INTO naf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Koti Zisas aikme ilinsakwep meti mkaŋan pataŋ zewien. Âpme Zisasiyaŋ egalen mkaen ke moti meu tatnime am takis mânep timti butnaŋ kambuŋaŋmak ilinaŋgat matimtemien ekŋen ma am yomtoŋ ekŋenmak Zisas ikŋaŋgat nemuŋane ilinsakwep keyegak motati tu meu tatnimambien. ");
INSERT INTO naf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mme Palisi ekŋengalen maŋgeengatnaŋ an zikat indanda notnaŋaŋ meti Zisas nembaŋaneyet indayaŋkwesiwien, “Kwilekiyet Zisasiyaŋ tu meu am yomtoŋ ma an mânep takis butnaŋ kambu matip ekŋenmak pi tati tatnin?” ");
INSERT INTO naf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tazeme Zisasiyaŋ nâmti pigok diindoye, “Am zawatpiŋ ekŋenaŋ doktamagen ku mamelip, zawatmak ekŋenaŋgut doktamagen mamelip. Sepem kegogak neŋ wan am ilinaŋgat nâme teŋ mambein ekŋen indatitiyet ku toban. Am yomtoŋ ekŋen yominangatnan gilik zemti indatitiyelen toban.” ");
INSERT INTO naf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Zuda am ilinaŋgalen set Kawawaŋgat sesewatsasâti tu meu mee manzemkulumpemmatatemien. Kegogak kan ŋengat Zân tu zululut anmak Palisi ekŋengalen nembayaŋ meu zemkulumpemti tapme am notnaŋaŋ Zisasmagen koti yaŋkwesiwien, “Zân tu zululut anmak Palisi ekŋengalen nembaŋineyaŋ meu zemkulumpemti matalip âtnaman gâlen nembayaŋ kegok eneyet ku mip?” ");
INSERT INTO naf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yaŋkwesime Zisasiyaŋ pigok diindoye, “Neŋ ekŋenmak talapgapmti ekŋenaŋ oloŋen mti tu meu zemkulumpemti belak ku talip. Âpme neŋ an ŋenaŋ mge keboŋak an keyaŋ imbiŋaŋmak bet butete kanan beme notnane meuyet indamandame koti meu ninipiŋ belak ku matalip, ekŋenaŋ tu meu nimwiaŋti oloŋen mamip. ");
INSERT INTO naf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yaŋ maneti kan daŋgome an ke notnanemak tatnepeme kasa ekŋenaŋ kot mandamti mepme kan keyet kembeŋ mti tu meu ninipiŋ ŋep zemkulumpemti tabep. ");
INSERT INTO naf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mka tokan tuŋgupmanen etimbembeŋaŋ alakŋaŋ atimti ku weyaŋ bek. Weyaŋsât tapmnepemane egaŋ bululuŋ zemtobodak. Keyepmti alakŋaŋ etaŋaŋ mpemane dolakŋaŋ kaliŋaŋ tadak keboŋ. ");
INSERT INTO naf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma am ŋenaŋ siŋgapoŋ sâŋsâŋ busât selik telepmaŋen bunak beme pululuk zemti mulatnak. Keyepmti selik alakŋanen bunak beme egaŋ epeepiŋ; dolakŋaŋ zinak!” ");
INSERT INTO naf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat tagoŋgo kan ŋengat Zisasmak nembaŋane ekŋenaŋ set wit mulup tuŋgupmaset meti Sabat tagoŋgo kan keyet keŋan kwileki ŋen ku mimiyelen zenzeŋaŋaŋgut nembaŋane ekŋenaŋ mepmambe wit katnaŋ notnaŋ belinaŋ tapmâtâtnimepmambien. ");
INSERT INTO naf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Âpme Palisi ekŋenaŋ indikti Zisasiyet pigok yaŋkwesiwien, “Zisas, pi ekbak, nembandine ekŋenaŋ Sabat tagoŋgo kangalen set bembeŋaŋ notnaŋ pi kwilekiyet taaŋgosoip?” ");
INSERT INTO naf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Zeme nâmti Zisasiyaŋ pigok indayaŋkwesiye, “In yeŋsokŋ Dewit ma anene meuyet olati meluwaŋ ku mimiŋaŋ mbien. Ke papiaen muluwaŋ mimiŋaŋ e in ku mamaiŋ nâip? ");
INSERT INTO naf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatayaŋ sâpe sâpe bumbu an ŋeŋaŋ maŋge kan keyet amobotnaŋ Dewilaŋ Kawawaŋgalen sesewat mkaen moti Kawawaŋgat zikatnan nupmamaŋ bembeŋaŋ ke mnimti anene notnaŋ indame nimbien. Nupmamaŋ ke am belakŋaŋaŋ ku manimtemien. Sâpe sâpe bumbu an ekŋenaŋ etaŋ matimnimtemien keyaŋgut ekŋenaŋ meuyet penaŋ gakimti kileŋ ke anene timkotindame nimbien.” ");
INSERT INTO naf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Zet zapat ke mimindamti zeye, “Amgapmti Kawawaŋaŋ Sabat tagoŋgo kan ke mme sokbeye. Wa Sabat tagoŋgo kan keyepmti Kawawaŋaŋ am ku indaweyaŋge. ");
INSERT INTO naf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Angat Nemuŋaŋ neŋ Sabat tagoŋgo kan ma kwitnaŋ kwitnaŋ sambe wein kapiyelen Amobotnaŋin mayap.” ");
INSERT INTO naf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Zisasiyaŋ ewe gilik zemti Zuda ilinaŋgalen sesewat mkaen negak moti an betnaŋ seleuuŋaŋ ŋen tapme ege. ");
INSERT INTO naf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Âpme Palisi notnaŋ tabien ekŋenaŋ Zisasiyaŋ an kapi Sabat tagoŋgo kanen kapi weyaŋpeme ekti wapmet zelen pesenup, zemti ekdamuŋ mtabien. ");
INSERT INTO naf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Âpme Zisasiyaŋ an betnaŋ seleuuŋaŋgat zeye, “Geŋ wati ŋeŋaŋ pienen kwatat.” ");
INSERT INTO naf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Zemtetime motapme Zisasiyaŋ am pigok indayaŋkwesiye, “Sabat tagoŋgo kanen mulup dolakŋaŋ mimiyelen ma bekanaŋ mimiyelen am mamaŋin ewe weyaŋindendeyelen ma indawalapme gakikiyelen? Ze zeme nâmbi.” Indayaŋkwesime ekŋenaŋ zelinpiŋ buzak tabien. ");
INSERT INTO naf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Âpme amnaŋ keŋ katik mme Zisasiyaŋ nâme ŋep ku beme ŋenzinziŋmak tokwaindikti an betnaŋ seleuuŋaŋgat zeye, “Bedi mututut.” Zeme betnaŋ mututupme betnaŋwan dolakŋaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ke mme Palisi ekŋenaŋ sesewat mkaengatnan toti meti keyegak amobotnaŋ Elotgat mukulem mimiŋane ekŋenmak ondekti, “Set zigoset aikti Zisas kumann gakiwe,” zemti zemkabewien. ");
INSERT INTO naf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Âpme Zisasmak nembaŋane ekŋenaŋ Galili tunduaen mesât mme Galili msalengatnan am sambe penaŋaŋ indikti indamâpmebien. Mepme am sambe Zudia msalengatnaŋ ma Zelusalem mka temaŋgatnaŋ ma Idumea msalengatnaŋ ma Zodan tu nembetgatnan ma Taia ma Saidon mka temaŋ keyet nembet nembet mka isisikŋaŋ notnaŋgatnaŋ am sambe penaŋaŋ Zisas mulup mimiŋaŋgat zapatnaŋ mekopme nâmbiengapmti ekmagen ondek kopmâbien. ");
INSERT INTO naf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Am sambeyaŋ kot bembuluŋti Zisas neŋ ekbi geŋ ekbi mti Zisas bekan maŋgalaŋpeme weweyelen mbiengapmti nembaŋaneyaŋ waŋga ŋen sakwep aiksasayet zeye. ");
INSERT INTO naf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Zisasiyaŋ am sambe maweyaŋindemtangapmti am zawatmak sepem igak igagaŋ koondakti Zisas timekti dolakŋaŋ bembeyet âmandamti dopmaŋ âtâpe dopmaŋ âtâpe mti maŋgalaŋpeme weweyelen mge keyepmti, “Waŋga aiigat,” ke zeye. ");
INSERT INTO naf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","An we bekanaŋinmak kwep kwep ekŋenaŋ Zisas zimosetnaŋ kot ekti kandaŋan tokutumti ŋagak temaŋ palen tazemambien, “Geŋ Kawawaŋgat Nemuŋaŋ.” ");
INSERT INTO naf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Âpme Zisasiyaŋ we bekanaŋaŋ egat kegok zemkawaŋ kumbembeyelen zemkulumindeye. ");
INSERT INTO naf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Âpme tunduaengatnan am notnaŋ Zisasmak ilinsakwep kalaŋan mobien. Motati Zisasiyaŋ am kwiyet nâme ŋep beye ekŋen ke indazemandame ekmagen kopme ");
INSERT INTO naf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","12 ekŋen pi ikŋaŋmak mamayelen indaombemti an Kawawaŋgalen Zet Zapat Dolakŋaŋ zempalakŋaŋ bembe an zenzeyelen ma we bekanaŋ indapmobogalen zemindemti winde indaye. ");
INSERT INTO naf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","An ekŋen keyelen kwilin kapigok: Saimon (kwitnaŋ ŋen Zisasiyaŋ Pita kuye) ma ");
INSERT INTO naf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedi nemulatnenet Zemsmak meniŋaŋ Zân egelaŋ ŋenzinziŋ mti kwizet ŋagak temaŋ makumtemun, keyepmti Zisasiyaŋ egegat kwilit Boaneges kuye. Kwit keyet yaŋaŋ ningalen zeleset gilik zemann kululuŋ kwisak kegok bein. ");
INSERT INTO naf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ma Endulumak Pilip ma Batolomiyumak Matiyu ma Tomasimak (Alipiasiyet nemuŋaŋ) Zems ma Tadiasmak Saimon Zelot ");
INSERT INTO naf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Zuda Iskaliot mkaengatnaŋ. An keyaŋ maneti bam Zisas zemkuye. ");
INSERT INTO naf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Meti mkaen motapme am sambeyaŋ ekti ewe kobem misik tapme keyepmti Zisas nembaŋane ekŋenaŋ tu meu niniyelen set ku sokbemindaye. ");
INSERT INTO naf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Âpme Zisasiyet mamnotnaneyaŋ zapatnaŋ ke nâmti, “An pi keŋaŋ kilom beme mene tapm,” zemti aiksât mebien. ");
INSERT INTO naf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Âpme zii zet zikat indanda an notnaŋ ekŋenaŋ Zelusalem mka temaŋgatnaŋ koti Zisasiyet zewien, “An kapi Beelsebul keŋan tazin.” Ma am notnaŋaŋ zewien, “An kapi we bekanaŋ ekŋengalen ŋeŋaŋinaŋ winde same we bekanaŋ ekŋen am keŋinangatnan tapmâindeme melip.” ");
INSERT INTO naf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Zeme Zisasiyaŋ nâmti am ekŋen ke indamandame kopme bemzenze zet ŋen kapigok diindoye, “Sadaŋaŋ zigoset Sadaŋ ikŋaŋak mâpme medak? ");
INSERT INTO naf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ma msat kwepgalen am maŋgeyaŋ kalaŋti âmandawiek beme msat kwep am maŋge keyaŋ windeŋinbeŋ ku tabiek. ");
INSERT INTO naf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma mka ŋen keyet keŋan amnaŋ kalaŋti âmandawiek beme mka keyet kwitnaŋ bekanaŋ benak. ");
INSERT INTO naf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Âpme Sadaŋgalen mulup an ekŋenaŋ epeemti ilinak âwiek beme windembeŋ ku tabiek ma ekŋengalen mamaŋin dolakŋaŋ ŋep ku tatnak. ");
INSERT INTO naf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Âpme an ŋen windeŋaŋbeŋ penaŋ e nâmtiŋgut kwindiŋ moti milawatnaŋ kilom kambu ku matip. Egaŋ ŋeŋaŋ an katikŋaŋ beke ambeti setnaŋ betnaŋ zampeme tadak beme ŋep milawatnaŋ tinak. Bemzenze zet kapi Sadaŋgat zenzeŋaŋ. Sadaŋ ŋeŋaŋ ambeti zampeme tapmeŋgut we bekanaŋ am keŋinan talip ekŋen ke ŋep indamâbâgalen.” ");
INSERT INTO naf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Amnaŋ Zisasiyet, “We bekanaŋ keŋan tazin,” kegok zewiengapm Zisasiyaŋ zet kapi zeye, “Neŋ zet kapigok penaŋ zema nâit, amgalen mama mimi bekanaŋ sambe ŋep katikpepeyelen ma Kawawaŋgat zet mobotnaŋ mimi keyelen yom kegogak ŋep katikpepeyelen. Neŋ Emetak Teŋaŋ winde name we bekanaŋ taindapmâlapgapmti Emetak Teŋgat zet mobotnaŋ zenze keyelen yom ŋep ku katikpepeyelen. Yom ke delaŋ zenzeŋepiŋ tapmetnepeme yom keyet dopmaŋ time delaŋ zewe.” ");
INSERT INTO naf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Âpme Zisasiyet mamnotnane ekŋenaŋ mka solonan baen kotati Zisasiyaŋ kwatotogat zepeme mopme tapmambien. ");
INSERT INTO naf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Zeme am sambe ekmak mka keŋan tabienaŋ Zisasiyet zewien, “Mamnodine ekŋenaŋ zupman baen kotati gâgât tazeip.” ");
INSERT INTO naf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Zeme egaŋ am ekŋengat pigok indayaŋkwesiye, “Kwiyaŋ nâgât mamnotnne beip?” ");
INSERT INTO naf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Zemti am tabien ekŋen meindik koindik mti zeye, “In talip kapiyaŋ nâgât mamnotnne penaŋ beip! ");
INSERT INTO naf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Am ekŋen Kawawaŋgalen zet maŋgawepup ekŋenaŋ nâgât mamnotnne penaŋ beip.” ");
INSERT INTO naf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Âpme Zisasiyaŋ ewe Galili tundua ganzenanak meti Kawawaŋgalen Zet Zapat Dolakŋaŋ tazemzikat indame am sambe penaŋaŋ koti bemisik tabiengapmti egaŋ waŋga ŋengat moti tu palen tapme amnaŋ tu ganzenan gambibigen totabien. ");
INSERT INTO naf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tapme egaŋ bemzenze zet zemti nânâ sambe zemzikat indameti bemzenze zet ŋen kapigok zeye, ");
INSERT INTO naf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nâip, an ŋenaŋ wit katnaŋ muluwen meti timtetelime mekoge. ");
INSERT INTO naf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Âpme katnaŋ notnaŋaŋ bululuŋ zemti selen totemepme ageyaŋ koti ekti nimbien. ");
INSERT INTO naf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Âpme katnaŋ notnaŋaŋ bululuŋ zemti msat nanzaŋ palen toge. Ke msat isikŋaŋ bugan bududuk gwaen nanzaŋ palen etaŋ tageyepmti dukŋaŋ sakwep pataŋ zemkwage. ");
INSERT INTO naf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yaŋ kasuwaŋ kwageen kan keyet kindiŋaŋ msalen baen penaŋ ku tototnaŋgapm zime gakiye. ");
INSERT INTO naf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Âpme katnaŋ notnaŋ bululuŋ zemti didik nusi keŋanen toti kwakwat e ŋep kwage yaŋgut nusi kwati minzilime eiŋeiŋ siye. ");
INSERT INTO naf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Âpme katnaŋ notnaŋaŋ bululuŋ zemti msat kelakŋaŋ temanen togeyepm penaŋaŋ dolakŋaŋ epeem kwat temaŋ bemti tepmaŋ notnaŋgat katnaŋ 30 sokbeye. Ma tepmaŋ notnaŋgat penaŋaŋ 60 sokbeye. Ma tepmaŋ notnaŋgat penaŋaŋ 100 sokbeye.” ");
INSERT INTO naf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zisasiyaŋ bemzenze zet kegok zemdelaŋ zempemti pigok diindoye, “An ŋen zet nânâyelen tikŋaŋaŋ tazinaŋ zet kapi ŋep opeimti nâsem.” ");
INSERT INTO naf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kegok zemdelaŋ zeme amnaŋ kalaŋ mekopme Zisasmak nembaŋane ma am notnaŋ ek kwesiŋ mâpmamtemien ekŋenaŋ ilinak tati bemzenze zet keyet yaŋaŋgat yaŋkwesiwien. ");
INSERT INTO naf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yaŋkwesime egaŋ pigok diindoye, “Kawawaŋgalen zemâtâtâtgat katnanen mama keyet zet enzililiŋaŋ tazin keyet yaŋaŋ in sosok zemkawaŋ bem indandaŋaŋ. Âpme an notnaŋ belak kileŋ zupman maip ekŋengut bemzenze zet etaŋ diindondoyet zenzeŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Keyepmti Aizayayaŋ pigok zeye, ‘Ekŋenaŋ zikalaŋ eek ektiŋgut penaŋ ku maekmâtâlip. Ma wagaŋ zet nânâ e nâmtiŋgut penaŋ ku manâmâtâlip. Ekŋenaŋ weyaŋekmâtâbiek ze Kawawaŋmagen keŋ gilik zenze aikme yomin katikpenak.’” ");
INSERT INTO naf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Zisasiyaŋ zet kegok mti pigok indayaŋkwesiye, “In kwilekiyet bemzenze zet mandiindoyap keyet yaŋaŋ ku nâmâtâlip? In zigoset bemzenze zet notnaŋ sambe zewap keyet yaŋaŋ nâmâtâbep?” ");
INSERT INTO naf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kegok indayaŋkwesimti bemzenze zet keyet yaŋaŋ pigok diindoye, “An wit katnaŋ time mege ke Kawawaŋgalen zet keboŋ ");
INSERT INTO naf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ma katnaŋ notnaŋ selen totemegeen am keŋin keboŋ ke Kawawaŋgalen zet nâme keŋinan topmatazinaŋgut Sadaŋaŋ koti makumsagat min. ");
INSERT INTO naf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma am notnaŋ nanzaŋ palen toge keboŋ ekŋenaŋ Kawawaŋgalen zet nâmti keyegak zet keyet nâme dolakŋaŋ beme oloŋen temaŋ mamip. ");
INSERT INTO naf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Keyaŋgut keŋinan penaŋ Kawawaŋgalen zet zapat ku nâmkatik bemti kindiŋinaŋ ku time towewetnaŋgapm Kawawaŋgalen zet zapat dolakŋaŋgat kasa ma sisipeŋpeŋ mimindame keyegak makatikpeip. ");
INSERT INTO naf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Naman am notnaŋ ekŋen nusi keŋan totemege keboŋ. ");
INSERT INTO naf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ekŋen keboŋaŋ msatgalen nukŋaŋ sambemak mânep milawatgat tikŋaŋaŋ ma kwitnaŋ kwitnaŋ notnaŋgat eyak mimi keyaŋ mamaŋin minzilime eiŋeiŋ masimtalip. ");
INSERT INTO naf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma am notnaŋ katnaŋ msat kelakŋaŋ temanen toweŋge sepem keboŋ. Ekŋenaŋ Kawawaŋgalen Zet Zapat Dolakŋaŋ nâmti nâmkiŋpemti keyet penaŋaŋ am notnaŋmagen 30 ma notnaŋmagen 60 ma notnaŋmagen 100 mee kegok masokbeip.” ");
INSERT INTO naf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Zemti zet ŋen naman pigok tusum zeye, “Âpme amnaŋ lam koŋbemti batiyaŋ dukŋan ku makwalapenup ma mundum wewe kandaŋan ku mambepenup. Nin lam koŋti mundumaŋ tatatnanen sosok bempemann tapme am mka keŋan matalip mbusatnaŋ mambemindein. ");
INSERT INTO naf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nâlen zetn ke lam nemboŋ keyepmti in nâlen zetn zemkawaŋ bewep beme nânâ enziliŋaŋ matazin ke ewe ku enzilim tabe ma nânâ kwatam tazin mâtâpeme kawaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","An ŋen zet nânâyelen tikŋaŋaŋ tazinaŋ zet kapi ŋep opeimti nâsem. ");
INSERT INTO naf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Keyepmti in weyaŋnâmâtâbep enenogat am ŋen Kawawaŋgalen zetnaŋ nâmti nâmtikŋaŋ mbe beme Kawawaŋaŋ nânâŋaŋ ewe tusumti sawe keyepm egaŋ nânâŋaŋ sambe penaŋ tasawe. ");
INSERT INTO naf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ma am ŋenaŋ zetnaŋ nâmti nâmtikŋaŋ ku mbe beme Kawawaŋaŋ nânâŋaŋ isikŋaŋ ekmak tasain ke menzem mbe. ");
INSERT INTO naf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kawawaŋgalen zelaŋ ammagen msat kataŋ mekopme am sambeyaŋ kwati egalen zemâtâtâtgat katnanen mama keŋan mepmâbien keyet pigok bem zema nâit. An ŋenaŋ muluwen wit katnaŋ time mege. ");
INSERT INTO naf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Âpme egaŋ tambu misa pi wemwat wemwat mti katnaŋaŋ mulupmaŋ zigok tapm bee eekpiŋ mme msat keŋanak kaim igak epeemti dukŋan makwazin. ");
INSERT INTO naf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Msalaŋ ikŋaŋ katnaŋ ke mukulem mme dukŋan epeemti kwat sinaŋ betnaŋ mti penaŋaŋ mapein. Yaŋ maneti ekŋen beewan ");
INSERT INTO naf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","penaŋaŋ memuŋ memuŋ bemtemepme elaŋgeŋge kanaŋ beme wanam mti maantip.” ");
INSERT INTO naf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Âpme Zisasiyaŋ bemzenze zet ŋen kapigok zemti diindoye, “Kawawaŋgalen zemâtâtâtgat katnanen mama keyet yaŋaŋ mastat katnaŋ keboŋ. Ma neŋ mastat katnaŋ keyet palen bemzema nâseip. ");
INSERT INTO naf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Msat sambe tep katnaŋ notnaŋaŋ mastat katnaŋ sebempeip. Mastat tep keyet katnaŋ isikŋaŋ bugan penaŋ yaŋ an ŋenaŋ mulupmanen mmet ondeme ");
INSERT INTO naf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","epeem kwat sememti antemaŋelip bemti sinaŋ betnaŋ mekopme age ekŋenaŋ ke motati keyet eyoŋan mkaŋin mawalati kelin mambeip.” ");
INSERT INTO naf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zisasiyaŋ bemzenze zet keboŋ keboŋ notnaŋ sambe zemti animbi Zet Zapat Dolakŋaŋ Penaŋ nânâŋinaŋgat kataŋ mandiindomtan. ");
INSERT INTO naf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Egaŋ am sambe zet sosok yaŋaŋmak zemkawaŋ bembepiŋ belak bemzenze zet etaŋ mandiindomtan yaŋ nembaŋanemak ilinak tati naman bemzenze zet manzemtan keyet yaŋaŋ manzemkawaŋ bem indamtan. ");
INSERT INTO naf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kasup keyegak manepeme gasim beme Zisasiyaŋ nembaŋaneyet zeye, “Nin tundua nembet daeset mebegalengat kame metne.” ");
INSERT INTO naf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kegok zeme nembaŋane ekŋenaŋ am sambe bepi katim indemti Zisasiyaŋ tapmaŋgeen waŋga keyegak moti Zisasmak ilinak mepme am notnaŋaŋ waŋga notnaŋgat moti indapmoti keyegak mebien. Mepmambe Zisasiyaŋ mulukgat mti waŋga butnaŋ delaŋ zenzeŋaŋ kwilimbeŋaŋ met bemti mulukŋaŋ bekan tawemaŋge. ");
INSERT INTO naf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Taweme tâgâ lumun temaŋ penaŋ kwati tundua kumbume tundua mamaŋ temaŋ kwati waŋga keŋan tuyaŋ toti gak zesât mge. ");
INSERT INTO naf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Âpme nembaŋane ekŋenaŋ mebutemti zewien, “An zikat indanda, tuyen toti walesâpmnup pi geŋ nânâpiŋ belak muluk kwapem tawenik?” ");
INSERT INTO naf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Zemti buteme mulugengatnan wati tâgâ ma tu zemkulumidemti zeye, “It buzak talit!” Zeme tâgâyaŋ zetnaŋ gawepumti katipeme tuyaŋ titokŋepiŋ tage. ");
INSERT INTO naf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mti nembaŋane pigok indayaŋkwesiye, “In kwilekiyet kiŋgati sebelaŋ diŋdiŋ pi tapmip? In nâmkiŋpepeŋin bugan ku tazin?” ");
INSERT INTO naf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Zisasiyaŋ kegok mme nembaŋane ekŋenaŋ nâmtemtem mti ilinak buzak zenâ zenâ mti zewien, “An kapi ziboŋ penaŋgapm am ma tumak tâgâ mee piyaŋ zetnaŋ maŋgawepuipgat!” Kegok zemti tundua ganzenaŋ nembet daen mesât mebien. ");
INSERT INTO naf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Meti ekŋenaŋ tu nembet daenen Gelasen msalen pataŋ zemti ");
INSERT INTO naf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","nembaŋaneyaŋ tapme Zisasiyaŋ waŋgaengatnan toti met an ŋen we bekanaŋaŋmak kopme ege. An beke mkaŋaŋ am zaimen nanzaŋ einzuŋan ke mawemtanaŋ kwati koge. ");
INSERT INTO naf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Âpme egaŋ miŋa keyet keŋan ke weme we bekanaŋaŋ winde same mobotnaŋ mme amnaŋ waia katikŋaŋ piyaŋ setnaŋ betnaŋ manzampemtemienaŋ egaŋ mamitimutan keyepm belak katipeme kileŋ belak matokwatan. ");
INSERT INTO naf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ekŋenaŋ waia katikŋaŋ piyaŋ setnaŋ betnaŋ manzampemtemienaŋgut egaŋ met nanzaŋ palen talinzaŋ kunepeme etim toweme mametan. An ŋenaŋ windeŋaŋ bemti ek ŋep ku mtopepeyelen yek. ");
INSERT INTO naf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tambu msa egaŋ sekŋaŋ nanzaŋ aimboŋan mawetindemetemien keyet keŋan mawemetan. Mti kalaŋan mototi ŋagak mti sekŋaŋ sambe nanzaŋ mti kileŋ ikŋaŋ mawaletan. ");
INSERT INTO naf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","9","An keyaŋ Zisas beŋan daen kopme ekti windembemti mepme Zisasiyaŋ ekti zeye, “We bekanaŋ in an keŋangatnan kwati melit!” Zeme ekŋenaŋ Zisasiyet nâme mobotnaŋ beme kandaŋan pedondomti ŋagak palen yaŋkwesiwien, “Zisas Kawawaŋ Amobotnaŋ penaŋgat Nemuŋaŋ, geŋ nin kwileki minndasâgât tapmnik?” Nin Kawawaŋgat monzalaman penaŋ diŋgonup, “Nin sek sindem ku ndasenik.” Zeme Zisasiyaŋ baenen we bekanaŋ ekŋen ke kwati mebegat zeyeyepmti Zisasiyaŋ an keyet yaŋkwesiye, “Geŋ kwidi kwi?” Yaŋkwesime egaŋ zeye, “Nâgât keŋŋnan we bekanaŋ sambe talip keyepmti nâgât kwitn ‘Sambe Sopmaŋ.’” ");
INSERT INTO naf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Âpme we bekanaŋ ekŋenaŋ zet giŋgiŋ mti zewien, “Geŋ msat kapiyetnaŋ ku ndapmâpmane mesenup.” ");
INSERT INTO naf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Âpme kalaŋ keyet kandaŋan bee an ŋengalen bo sambe penaŋ tati meu tatnimambien. ");
INSERT INTO naf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Keyepmti we bekanaŋ sambe am keŋan tabienaŋ zet giŋgiŋ mti zewien, “Geŋ ndapmâpmane nin bo keŋinan ŋep metowemâsenup.” ");
INSERT INTO naf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Zeme Zisasiyaŋ we bekanaŋ nâmindeme an keŋangatnan kwati met bo keŋan towepme boyaŋ keŋin kilom beme ekŋenaŋ kunzuŋ met tundua keŋan toti tu nimti gakimtemebien. Bo ekŋen ke sambe penaŋ 2 tausen kegogaŋ toweti gakiwien. ");
INSERT INTO naf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Boyaŋ kegok mme am bo damuŋ mamtemien ekŋenaŋ ekti winde bemti met mka teman ma mka isikŋan am notnaŋgat zet zapat diindome ekŋenaŋ kwitnaŋ kwitnaŋ sokbeye ke eksât kopmâbien. ");
INSERT INTO naf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Zisasmagen koti an itnaŋaŋ we bekanaŋ sambe keŋanen tapme keŋ kilom kilom mti matokwatan ke ekme keŋan teŋ beme saŋgum melakanduŋaŋ miakti totapme ekti Zisasiyaŋ mulup kiŋgagatnaŋmak mge beke ekti kiŋgabien. ");
INSERT INTO naf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Âpme am bo damuŋ mamtemien ekŋenaŋ an we bekanaŋaŋmak mamtan egat zapatnaŋ ma bo ekŋenmagen kwitnaŋ kwitnaŋ sokbeye keyet zet zapatnaŋ am sambe diindome nâmbien. ");
INSERT INTO naf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nâmti ekŋenaŋ Zisasiyaŋ msat ke pemti mebegalen yaŋbemti apitilim pewien. ");
INSERT INTO naf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Zisasiyaŋ naman waŋgaen moti mesâgât mme an itnaŋaŋ we bekanaŋaŋmak mamtan egaŋ Zisasmak mesâgât yaŋkwesim giŋgiŋ mge. ");
INSERT INTO naf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yaŋgut Zisasiyaŋ zemkulumpemti zeye, “Geŋ ipnodine ekŋenmagen meti Amobotnaŋaŋ kembeŋ mgamti weyayaŋ mulup mme dolakŋaŋ benak keyet zet zapadi diindosenik.” ");
INSERT INTO naf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Zeme egaŋ gilik zem meti Zisasiyaŋ ekmagen kwitnaŋ kwitnaŋ mge keyet zapatnaŋ Dekapolas mka keyet keŋan diindome am ekŋenaŋ nâmti nâmtemtem temaŋ penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Âpme Zisasiyaŋ waŋgaen moti tu nembet daen mepataŋ zemti ewe nembu ganzenanak tapme am sambe penaŋaŋ ekmagen kot ondekbien. ");
INSERT INTO naf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Ekŋengat tuŋguwinangatnaŋ an ŋen kwitnaŋ Zailas, Zuda am ekŋengalen sesewat mka damuŋ an ŋen beke egaŋ koti Zisasiyet nâme mobotnaŋ beme pedondom samti pigok wekum saye, “Amobotnaŋ, neŋ namban gakisât bududuk penaŋ tapmgat geŋ koti bedaŋ sekŋanen bemti mmane alik bemti mak.” ");
INSERT INTO naf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zeme nâmti an kemak mepmalu am sambeyaŋ idamâpmeti ekŋenaŋ set tuŋgupman Zisas misik peme wesât mmebien. ");
INSERT INTO naf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Âpme am mebien ekŋengat tuŋguwinan imbi ŋen sipmaŋ makwawetnepeme nup kanaŋ 12 beye. ");
INSERT INTO naf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Imbi keyaŋ kan teepmaŋ dokta ekŋenmagen mepme ekŋenaŋ weyaŋpenup zemti mme ekŋenmagen mânepmaŋ sambe katipeme delaŋ zeme ewe sindem temaŋ timti sip omba penaŋ tusumti ewe makwawetan. ");
INSERT INTO naf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Imbi keyaŋ Zisasiyaŋ am maweyaŋindemtan keyet zapatnaŋ nâŋgeyepmti am sambeyet keŋan Zisas taŋguwi zem kilik kilik mege. ");
INSERT INTO naf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kapigok otnâmti mge, “Neŋ melakanduŋaŋ etaŋ timmeksap beme ŋep alik besap.” Zemti kilik kilik mmeti met ");
INSERT INTO naf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","melakanduŋanak timmekme keyegak sipmaŋ katime keŋanen nâme zawatnaŋ yek beye. ");
INSERT INTO naf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Imbi keyaŋ timmekme Zisasiyet windeŋaŋ notnaŋ ekmagen mepme nâmti zeye, “Kwiyaŋ melakanduŋnan timmekme nâyap?” ");
INSERT INTO naf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Zeme nembaŋane ekŋenaŋ zewien, “Am sambe penaŋaŋ misik koti gatimego. Âpme geŋ kwilekiyet, ‘Kwiyaŋ natim mekzin,’ tazenik?” ");
INSERT INTO naf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yaŋkwesime Zisasiyaŋ am timmege keyet guluk gilik mti timmage. ");
INSERT INTO naf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Âpme imbi keyaŋ timmekme sekŋanen kwitnaŋ kwitnaŋ sokbeye keyet yaŋaŋ nâmti set belaŋ diŋdiŋ mti Zisasiyet kandaŋan pedondom samti zet zapatnaŋ sambe ke msaye. ");
INSERT INTO naf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Msame Zisasiyaŋ imbi keyet zeye, “Ipm, nâmkiŋnenakgapm pembenaŋ benak keyepm keŋdi sewakŋaŋ beme meti alik benak kegogak mepmambanik.” ");
INSERT INTO naf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Egaŋ imbi keyet zet ewe zemambe tapme Zuda am ekŋengalen sesewat mka ŋeŋaŋin egalen mkaengatnan am notnaŋaŋ Zailas ekmagen koti zewien, “Nambandi walak yek bep. Keyet geŋ Zisas belak ku wakosenik.” ");
INSERT INTO naf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ekŋenaŋ zet kegok tazenâme Zisasiyaŋ nâmti keyegak Zuda am ekŋengalen sesewat mka damuŋ egat zeye, “Geŋ yayaŋ ku mi; nâmkiŋpependi mkipmaŋ be.” ");
INSERT INTO naf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kegok zemti am notnaŋ mâpmebien ekŋen zemkulumindemti Pitamak Zems meniŋaŋ Zân ekŋen etaŋ indatime mebien. ");
INSERT INTO naf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Meti Zuda am ekŋengalen sesewat mka damuŋgalen mkaen moti Zisasiyaŋ nâme amnaŋ kwisak temaŋ mti ambembesi tapmme moti ");
INSERT INTO naf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","indikti am sambe ambembesi tapmme zeye, “In kwilekiyet kwisak temaŋ mti yuyu yeye tapmip? Imbi nemba kapi ku gakip; belak muluk tawen.” ");
INSERT INTO naf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Zisasiyaŋ kegok zeme ekŋenaŋ an pi zigogat kwat siwawakŋaŋ tapmin zemti yeŋbien. Mme Zisasiyaŋ am sambe mka keŋan tapmambien ke indapmâpme zupman baen topme delaŋ zeme nemba keyet mamaŋ bipmaŋ ma nembaŋane Pitamak Zemsmak Zân etaŋ zeme ilinak nemba gakikiŋaŋ tageen ke tabien. ");
INSERT INTO naf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tati imbi nemba keyet betnaŋ atamti Zuda zeleset pigok zeye, “Talita kumi,” keyet yaŋaŋ, “Imbi nemba isikŋaŋ, neŋ geŋ wawagat zeyap!” ");
INSERT INTO naf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Zeme keyegak imbi nemba isikŋaŋ keyaŋ wati mebe kokot mge. Imbi nemba ke nup kanaŋ 12 etaŋ. Âpme imbi nemba isikŋaŋ ke gakikiengatnan wapme ekti ekŋenaŋ nâmtemtem penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Âpme Zisasiyaŋ keyet zet zapatnaŋ am ŋen ku diindondoyet zemkulumindemti nemba meu mkosame niniyet zeme meu mkot same niŋge. ");
INSERT INTO naf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Zisasiyaŋ mka ke peme tapme ikŋaŋgat mkaŋaŋ ŋotekŋaŋ Nasalet mesât mme nembaŋaneyaŋ mâti ilinsakwep mebien. ");
INSERT INTO naf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mepmane peme Zuda am ilinaŋgalen kâtnânâ kan beme sesewat mkaen moti Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ zemzikat indamiŋge. Âpme am sambe ekŋenaŋ zetnaŋ nâmti nâmtemtem penaŋ mti zewien, “Kwitnaŋ kwitnaŋ sambe mamin kapi ma nânâ temaŋ temaŋ kapi egaŋ desetgatnan penaŋ tiye? Egaŋ zigoset mulup dolakŋaŋ temaŋ temaŋ kapi aikti mamm? ");
INSERT INTO naf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nin egat yaŋaŋ nânup. Ek bipmaŋ mka walalat an ma mamaŋ kwitnaŋ Malia ma meniŋane Zemsmak Zoses ma Zudamak Saimon ma ipmanemak ke nin nâmtatnup.” Kegok zemti zemtalati mtopewien. ");
INSERT INTO naf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mtopeme Zisasiyaŋ pigok diindoye, “Kawawaŋgalen golaŋ zenze an ŋengat kwizet buŋamaŋ msat notnanen palakŋaŋ bem tapmepme ikŋaŋgat mamnotnane ma doipmane ma ikŋaŋgalen mkaengatnaŋ amnaŋ zemtalatpemti kwizet buŋamaŋ ku mamwalip.” ");
INSERT INTO naf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kegok zemti Zisasiyaŋ ekŋenmagen mulup temaŋ ŋen ku mge. Am zawalinmak kwep kwep etaŋ notnaŋ betnaŋaŋ indatamti zawalin mme alik bewien. ");
INSERT INTO naf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mkaŋaŋ ŋotekŋan am ekŋen nâmkiŋpepeŋinpiŋgapmti tektek penaŋ miindemti egaŋ mka notnanen etaŋ tokwat meti Kawawaŋgalen Zet Zapat Dolakŋaŋ zemzikat indam mge. ");
INSERT INTO naf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Zisasiyaŋ nembaŋane 12 indazem tetime kopme Kawawaŋgalen Zet Zapat Dolakŋaŋ zenzeyelen ma we bekanaŋ indapmâbâgalen winde indamti nemba zut zut zemideme mka kataŋ mekokogat zemindeye. ");
INSERT INTO naf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ekŋenaŋ mesât mme Zisasiyaŋ kapigok diindoye, “In mesâti set mebegalen toŋgaŋin etaŋ mmebep. Meu ma ele ma mânewin mee ŋen ku timebep. ");
INSERT INTO naf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sewewelin mmebep ma melakanduŋin tipmasek mee ku munduŋ bep. Sekŋinan tazin ke etaŋmak mebep.” ");
INSERT INTO naf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mti pigok diindoye, “In mepme mka keŋan ŋen indame in kwep keyegak mawemetneti mebep. ");
INSERT INTO naf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","In mka ŋen pataŋ zeme mka keyelen am ekŋenaŋ mka weweyelen ku indawep beme in mesât mbep, kan keyet zipelukŋin seŋti zewep Kawawaŋgalen ŋenzinziŋaŋ mka kapimak tazin zemti mebep.” ");
INSERT INTO naf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Zeme nâmti ekŋenaŋ msat kataŋ meti amgat zeme yomengatnan gilik zenze keyet zetnaŋ diindowien. ");
INSERT INTO naf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Diindomti we bekanaŋ sambe am keŋan indapmâindewien ma zawatmak sambe olip kelakŋaŋ tuŋaŋaŋ sekŋinan zulutindemti mme alik bewien. ");
INSERT INTO naf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","29","Elolaŋ meniŋaŋ Pilipgat imbiŋaŋ Elodias menzem wageyepmti Zânaŋ moti Elotgat zeye, “Geŋ meniŋdaŋgat imbiŋaŋ menzem wadik kapi geŋ Kawawaŋgalen zii zet tazin e aŋgosonik.” Kegok zeme Elodiasiyaŋ Zânaŋ Elotmak egegat yomit zemkawaŋ bemidaye keyet nâme ŋep ku beme Zângat ŋenzinziŋ mti zemdelaŋ zeme Elolaŋ am notnaŋ zemindeme Zân atamti setnaŋ betnaŋ zamti mka katikŋan met pewien. Imbi Elodias keyaŋ Zângat ŋenzinziŋ mti kukuyelen nâŋgeyaŋgut Elolaŋ Zân ek Kawawaŋgalen mulup an teŋ ma yomepiŋ kwetetepmaŋ mamain keyet mti mineti, “Neŋ kuma gakime Kawawaŋaŋ naman neŋ kegogak nawalebemagen,” zemti kiŋgati aŋgalaŋ peme mamti zetnaŋ zeme nânâyelen nâmtikŋaŋ mamtan. Âpme maneti peme Elot sokbembeŋaŋ keyet kan daŋgome egaŋ egat kandaŋan an ŋeŋaŋ bembe notnaŋ mamtemien ma an kasa kuku ekŋengalen ŋeŋaŋin ma Galili msat notnaŋ ekŋengalen an ŋeŋaŋ notnaŋ indamandame kopme bumuluŋti indamti tapmambien. Kan keyet Elodiasiyaŋ Zân kume gakikiyelen setnaŋ dolakŋaŋ penaŋ sokbemsaye. Elot ma an ŋeŋaŋ notnaŋ ekŋenaŋ ondek tapme Elodiasiyet nambaŋaŋaŋ ekŋengat zikalinan meti silik wendiye. Silik wendime Elot ma an ŋeŋaŋ notnaŋaŋ egome Elolaŋ nambaŋaŋ keyet zeye, “Geŋ kwileki ŋengat gembeme zemane neŋ ŋep gasap. E Kawawaŋgat zikatnan pigok zemkatik bem gayap. Geŋ kwileki belakŋaŋ ŋengat zemane ŋep gasap ma msat mandamuŋ miap kapi butnaŋ eleŋgem gaŋgayelen zemane e kegogak ŋep eleŋgemti gasap.” Zeme imbi nemba keyaŋ mka butnan gwaen mamaŋgalen meti mamaŋgat yaŋkwesiye, “Maŋge, neŋ bienaŋ kwileki nanayet zesap?” Yaŋkwesime mamaŋaŋ Zân tu zululut egat ŋenzinziŋ mamtan keyepmti nambaŋaŋgat pigok zeye, “Geŋ Zângat ŋokasetnaŋ gaŋgayet zesenik.” Zeme nambaŋaŋaŋ nâmti keyegak winde bemti amobotnaŋ Elotmagen toweti zeye, “Alak kapi Zân tu zululut angat ŋokasetnaŋ usumti batien bemti nasenik.” Zeme amobotnaŋ Elolaŋ zet ke nâmti keŋaŋ bekanaŋ penaŋ beye, yaŋgut amgat zikalinan zemkatik beyeyepm yek ŋep ku zenak. Keyepm egaŋ kasa kuku an ŋen zempeme egaŋ mka katikŋan meti Zângat bimaŋ usumti ŋokasetnaŋ batien bem mti kot nambaŋaŋ ke same egaŋ Zângat ŋokasetnaŋ pelep ke mti mamaŋ mesaye. Âpme mamaŋaŋ Zângat ŋenzinziŋ mamtan keyepmti Zângat ŋokasetnaŋ ke same egat ŋokasetnaŋ ke ekti nâme ŋep beme mti mepeme mege. Kegok mme nembaŋane ekŋenaŋ zet zapatnaŋ nâmti kot sekŋaŋ mti met miŋa keŋan wat pemti atampewien. Elot kegok mmame Zisasiyet zet zapatnaŋ msat kataŋ palakŋaŋ bemeti amobotnaŋ egat wakŋan topme nâmti zeye, “Zân tu zululut neŋ bimaŋ eleŋgewan keyaŋ naman gakikiengatnan walep keyepm windeŋaŋ igagen penaŋ tapm.” Yaŋgut am notnaŋaŋ zewien, “An kapi Kawawaŋgalen golaŋ zenze an Ilaiza,” ma notnaŋaŋ zewien, “Ek Kawawaŋgalen golaŋ zenze an itnaŋaŋ baen mamtemien ekŋen keboŋ.” ");
INSERT INTO naf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zisasiyaŋ nembaŋane zemindeme mka kataŋ mebienaŋ maneti Zisasmagen koondakti ammagen kwitnaŋ kwitnaŋ mbien ma Zet Zapat Dolakŋaŋ Penaŋ zemzikat indawien keyet zezapatnaŋ msawien. ");
INSERT INTO naf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Âpme am sambeyaŋ ekŋenaŋ tabienen ke mekopeŋ tapme Zisas ma nembaŋane ekŋenaŋ meu niniyelen kan tuŋgupmaŋ bugan ku sokbemindame keyet mti Zisasiyaŋ nembaŋaneyet zeye, “Kame, nin pi pemti msat tuŋgupman nnak daen meti bugan kâtnâmtati meu nsenup.” ");
INSERT INTO naf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Zemti ekŋenaŋ ilinak waŋgaen moti msat tuŋgupman tu nembet daeset ke mesât mebien. ");
INSERT INTO naf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tapmepme am sambe mka temangatnan ekŋenaŋ indik mâtâti ekŋenaŋ nembu gilop windem bemti nembet daen ŋeŋaŋ met pataŋ zewien. ");
INSERT INTO naf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Âpme Zisasmak nembaŋane ekŋenaŋ bam met ganzenan patakpemti Zisasiyaŋ toti met am sambe penaŋ indige. Ekŋenaŋ sipsip damuŋinpiŋnok tabiengapmti Zisasiyaŋ am ekŋengat kembeŋ penaŋ mti yaŋbemti Zet Zapat Dolakŋaŋ sambe zemzikat indam mge. ");
INSERT INTO naf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Tazemzikat indam mnepeme msat tambusât penaŋ tapmme nembaŋaneyaŋ ekti Zisasmagen meti zewien, “Msat penaŋ tambusât tapm keyet geŋ am indemane mka temanen ma isikŋanen meti meuŋin ilinaŋgat aikti kwitimti nseip.” ");
INSERT INTO naf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Zeme Zisasiyaŋ dopmaŋ pigok gilik zem zeye, “In meu ŋen aikti indame nila!” Zeme ekŋenaŋ Zisasiyet yaŋkwesiwien, “Nin 200 kina kapiyaŋ nupmamaŋ met kwiti koindamann niniyet nâmti tazenik?” ");
INSERT INTO naf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Âpme egaŋ pigok indayaŋkwesiye, “In meti eleŋinaŋ nupmamaŋ zigok tazin ze egit?” Zeme ekŋenaŋ meekti zewien, “Eleen nupmamaŋ 5 ma aŋgala zulaŋ talup.” ");
INSERT INTO naf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Zeme nâmti egaŋ nembaŋaneyet zeme am zemindeme maŋge ŋen maŋge ŋen kwaŋ sinaŋ dolakŋaŋ palen gwilelaŋ pemti totapmebien. ");
INSERT INTO naf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Maŋge notnaŋgat am 100 ma maŋge notnaŋgat am 50 kegok tapmebien. ");
INSERT INTO naf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tapmepme Zisasiyaŋ nupmamaŋ 5 kemak aŋgala zut ke timtati zikatnaŋ kululuŋen gwaen ekme mopme Kawawaŋgat, “Wisikŋ,” zemti nupmamaŋ ke meselemti nembaŋane indame ekŋenaŋ ambepelet timti am maŋge tabien kataŋ indamebien. ");
INSERT INTO naf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Indamepme am 5 tausen piyaŋ meu nimkiŋgapme meu butnaŋ kileŋ temepme ke naman nemba ekŋenaŋ akumtim akumtim mti tise 12 kegok wepme gak zeme nembaŋane ekŋenaŋ timti mebewien. ");
INSERT INTO naf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kegok mti Zisasiyaŋ ikŋaŋ ewe keyegak tati nembaŋane ekŋen ŋeŋaŋ zemindeme ekŋenaŋ waŋgaen moti tu nembet Besaida mkaen daeset mesâgât tapmepme egaŋ ikŋaŋ ke tati am sambe zemindeme mekobien. ");
INSERT INTO naf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","48","Ekŋenaŋ mekopme delaŋ zeme Zisasiyaŋ dundusâgât kalaŋan memoge. Moti Zisasiyaŋ igak kalaŋan ke dundumambe tapme gasi penaŋ beme indikme nembaŋane ekŋenaŋ ilinak etaŋ piyaŋ tundua sutnan penaŋ daen mepme tâgâ temaŋaŋ mebieneset kot indakumbume mesâgât taolapmambien. Tambu tetak piwan mulup temaŋ ke tapmmetnepeme msasâgât tapmme, Zisasiyaŋ toti tundua paleset ekŋenmagen sokŋan sebem indesâgât mge. ");
INSERT INTO naf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Egaŋ kegok mme ekŋenaŋ, “Wa, we bekanaŋaŋ kozin,” zemti kiŋgati yeye mme ");
INSERT INTO naf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Zisasiyaŋ pigok diindoye, “Kiŋgagapiŋ. Neŋ nen penaŋ takolapgat sewak talit.” ");
INSERT INTO naf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Zemti Zisasiyaŋ waŋga keŋan mowepme keyegak tâgâyaŋ katikŋaŋ takumaŋgewan bep zeme nembaŋaneyaŋ nâmtemtem temaŋ mti tabien. ");
INSERT INTO naf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ekŋenaŋ Zisasiyaŋ am sambe penaŋ meu indame nimbien windeŋaŋ keyet yaŋaŋ mee kegogak ku eknâmbien. ");
INSERT INTO naf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Âpme ekŋenaŋ tundua nembet daenen meti Genesalet msalen pataŋ zemti waŋga mandame kaiŋan mopme tekŋaŋ mandamti mot tep palen ");
INSERT INTO naf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","zampemti Zisasmak nembaŋane ekŋenaŋ toti mepme am notnaŋaŋ indikmâtâti windembemti mka kataŋ meti am zawalinmak indaluanzamtimti Zisasmagen kopmâbien. ");
INSERT INTO naf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Âpme Zisasiyaŋ mka temanen ma mka isikŋaŋ notnanen mege kan keyet am zawalinmak luemtimti tambaŋgum sutnanen koindeme wemti ekme Zisasiyaŋ takopme melakanduŋaŋ butnaŋ etaŋ ke timekti dolakŋaŋ bembeyet wekuwien. Wekume nâmindeme am zawalinmak ekŋenaŋ saŋgumaŋ busiliŋaŋ etaŋ timekti alik bemâbien. ");
INSERT INTO naf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Âpme zii zet zikat indanda an ekŋenaŋ Zelusalem mkaengatnan kot Palisi indaikme ilinsakwep met Zisasmak ondekbien. ");
INSERT INTO naf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ondak tati Zisasmak Zapat mmambe tati indikme Zisasiyet nembaŋane notnaŋ ekŋenaŋ yeŋpawineyelen zii zet tazin keyet kataŋ belin zululupiŋ tu meu taatamnimambien. ");
INSERT INTO naf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Âpme Palisi ma Zuda am ekŋenaŋ yeŋpawineyelen mama mimi ke mâti keyet kataŋ belin mee zululupiŋ tu meu ŋen ku maatamnimtemien. ");
INSERT INTO naf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma ekŋenaŋ bemkwiti kwiti mundumengatnan gilik zem meti kegogak tu zululupiŋ meu ŋen ku maatamnimtemien. Wa ke etaŋ yek, mama mimi keboŋ notnaŋ menzim bati ma okop mee pi ewe zululutnaŋ keyegak sakwalam zuluti mambumbemnimtemien. Ma mama mimi keboŋ keboŋ sambe notnaŋ ewe wemezin. ");
INSERT INTO naf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Keyepmti Palisi ma zii zet zikat indanda ekŋenaŋ Zisas nembaŋaneyelen muluwaŋ ke ekti Zisasiyet pigok yaŋkwesiwien, “Nembandine ekŋenaŋ kwilekiyet yeŋpapmnaŋgalen set tazin ke kulumti tu meu mee belin zululupiŋ bumbulumimagaŋ kileŋ tatim nip?” ");
INSERT INTO naf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yaŋkwesime Zisasiyaŋ ekŋengat pigok zeye, “Eweŋan tipman baenen Kawawaŋgalen golaŋ zenze an Aizayayaŋ in tetimaemae an keboŋgat esemteŋ penaŋ meluwaŋ pigok mge, ‘An ekŋen keboŋ keyaŋ keŋinaŋ penaŋ bamkunemti kwizet buŋamm belak sekgaŋ etaŋ mwati manzempalakŋaŋ bemneip. ");
INSERT INTO naf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mti ilinaŋgalen yeŋpawineyelen set keyaŋ nâlen zii zetnok bempemti ke am sambe zemzikat indamamipgapmti nâgât belak segaŋ etaŋ mandundunaip.’” ");
INSERT INTO naf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Zemti pigok diindoye, “In Kawawaŋgalen zii zet penaŋ ke imgulume topme ilinaŋgalen yeŋpawineyelen set sambe ke mamkatikŋan bem maip.” ");
INSERT INTO naf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Zemti ewe tusumti pigok diindoye, “In yeŋpawinaŋgalen set ke mtati Kawawaŋgalen zii zet imgulume totogalen setnaŋ dolakŋaŋ penaŋ masokbemindain. ");
INSERT INTO naf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesiyaŋ Kawawaŋmagen zet ŋen mti kapigok zeye, ‘Geŋ mambipdaŋgat nâmane mobotnaŋ bewe. An ŋenaŋ mambipmaŋgat zet mgasik zeween an ke kume gakiwe.’ ");
INSERT INTO naf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Keaŋgut in naman am set sepem ŋen zikat indame ekŋenaŋ pigok mamip. ‘Mam biwine ekŋenaŋ olat olat ke temimti mameŋgut ekŋenaŋ pi ilak Kawawaŋgat tewalaŋ sasâgât zemti bempeya.’ ");
INSERT INTO naf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Zemti mam biwine indamukulem dolakŋaŋ penaŋ ku mamiindeip. ");
INSERT INTO naf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Set kegoset in Kawawaŋgalen zii zet mtopemti ilinaŋgalen set manzemzikat indaip. Mama mimi sambe keboŋ notnaŋ sambe penaŋ mamâlip.” ");
INSERT INTO naf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kegok zemti am sambeyet ewe zeme kopme pigok diindoye, “In sambe wakbemti tapme zet kapi zema weyaŋnâmâtâlit. ");
INSERT INTO naf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kwitnaŋ kwitnaŋ nime kambakŋinan matowezin keyaŋ yom kum bein. Keŋinangatnan nânâ bekanaŋ ma dembusek bekanaŋ makwazin keyaŋ keŋin mme bekanaŋ mambein. ");
INSERT INTO naf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","An ŋen keŋanmagaŋ zet zeyap kapi nâmti ikŋaŋak opeim nâsem.” ");
INSERT INTO naf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Egaŋ zet kegok zemdelaŋ zemti am indeme mekopme mkaen mowepme nembaŋane ekŋenaŋ keyegak mâpmoti bemzenze zet zeye keyet yaŋaŋ zemâtâtindame nânâyelen yaŋkwesiwien. ");
INSERT INTO naf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yaŋkwesime Zisasiyaŋ pigok diindoye, “In kegogak ŋoktikŋinpiŋak tapmaip? ");
INSERT INTO naf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Meu nimann tipkambakŋnan matowezin keyaŋ keŋinanen toti keŋin mme bekanaŋ ku mambein. Keyaŋ belak tipkambakŋnan totapme baeset tipman makwawezin.” (Keyepmti Zisasiyaŋ meu sambe kapi ku zemkuluye ŋep etaŋ niniyelen zeye.) ");
INSERT INTO naf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Âpme keŋinangatnan nânâ ma zet bekanaŋ makwazin keyaŋ keŋin mme bekanaŋ mambein. ");
INSERT INTO naf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Am keŋaŋgatnan kwitnaŋ kwitnaŋ bekanaŋ kapigogaŋ makwazin: ŋoktik bekanaŋ, ma animbi zomolim ekŋenaŋ set kileŋ mama ma awembiŋ bembeŋaŋaŋgut notnaŋgalen imbi menzem wawat ma kambu, kasa kuku, imbi indaasek indende, mobotnaŋ sakam igak igak, dâsuki, kakiki ma amgat zet bekanaŋ notnaŋ zenze ma nânâŋin kilom maotnâip. ");
INSERT INTO naf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nânâ bekanaŋ keboŋaŋ keŋinangatnan kwati keŋin mme bekanaŋ beme Kawawaŋgat zapat ku matalip.” ");
INSERT INTO naf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kegok zemdelaŋ zemti Zisasiyaŋ mka ke peme tapme Taia ma Saidon mka temaŋ egegat msat tuŋgupmanen mege. Egaŋ meti mka tambaŋgumen moti amnaŋ egat zet zapatnaŋ ku nânâyelen otnâŋge. Yaŋgut am ekŋenaŋ mepme zapatnaŋ nâmâbiengapmti ŋep ku enzililiyelen sepem beye. ");
INSERT INTO naf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Keyepmti Zisasiyaŋ mopme mopme keyegak imbiŋenaŋ zet zapatnaŋ nâmti nambaŋaŋ we bekanaŋ ŋenaŋ mme keŋan kileŋ mambemtangapmti Zisasiyet nâme mobotnaŋ beme pedondo saye. ");
INSERT INTO naf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Imbi ke Pinisia imbi Silia mkaengatnaŋ zetnaŋ Glik zet manzemtan. Imbi keyaŋ nambaŋaŋgat keŋangatnan we bekanaŋ mâpepeyelen Zisasiyet zet giŋgiŋ mge. ");
INSERT INTO naf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Keyepmti Zisasiyaŋ imbi keyet pigok dunduye, “Nemba ekŋenaŋ meu ŋeŋaŋ manip. Âpme geŋ nâmane nembayelen meu menzemti tam ŋep ku sasayelen bein. Sepem kegogak neŋ Zuda am ekŋen ŋeŋaŋ indamukulem mtiŋgut bam am Zuda maŋgaen ku sokbemeŋaŋ in indamukulem mimiyelen.” ");
INSERT INTO naf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Zeme imbi keyaŋ dopmaŋ pigok gilik zem saye, “Amobotnaŋ, geŋ zet e penaŋ zenigaŋgut tam ekŋenaŋ nembayelen meu pâpmaŋ bap palen toweme kileŋ ke mambeseip.” ");
INSERT INTO naf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Egaŋ kegok zeme Zisasiyaŋ kapigok zeye, “Geŋ zet kegok penaŋ zenikgapmti nambandi we bekanaŋaŋ katipe mezingat gilik ze mkandan met.” ");
INSERT INTO naf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Zeme imbiyaŋ mkaŋan meti ekme nambaŋaŋ we bekanaŋ pemepme sinanen muluk dolakŋaŋ taweme ekti nâme dolakŋaŋ penaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zisasiyaŋ Taia mka katikpem met Saidon mka sebempemti Dekapolas mka sebemindemti Galili msat tunduaeset mepme ");
INSERT INTO naf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","33","am notnaŋaŋ an wakŋaŋ kekekŋaŋ zet mee zesât maolatan ke wati Zisasiyaŋ betnaŋaŋ timekme dolakŋaŋ bembeyelen nâmti ekmagen wapmebien. Wapmeti Zisasiyaŋ weyaŋpepeyet yaŋkwesiŋ giŋgiŋ msame Zisasiyaŋ nâmti egaŋ an ke wati ganzenanik meti betnan nemuŋaŋaŋ wakŋaŋ nembet nembet wapemti naman mtot zawagaŋ betnanen wasekpemti an keyet nambalamanen ");
INSERT INTO naf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","bemtati an keyet kembeŋ mti zikatnaŋ kululuŋen ekme mopme Zuda ilinaŋgalen zeleset Bipmaŋgat pigok zeye, “Epata.” Zet keyet yaŋaŋ, “Wakdi teŋ beme zet ze!” ");
INSERT INTO naf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Zeme wakŋaŋ teŋ peme zet dolakŋaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Âpme Zisasiyaŋ keyet zapatnaŋ ku zenzeyelen am indazemkulum aleme am ekŋenaŋ nâpemti keyet zapatnaŋ zempalakŋaŋ bemâbien. ");
INSERT INTO naf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ekŋenaŋ nâmtemtem penaŋ mti zewien, “An kapiyaŋ kwitnaŋ kwitnaŋ mme dolakŋaŋ etaŋ mambein. Mti kegogak am wakŋaŋ kekekŋaŋ ma zet ku manzeip ekŋen mme zet zeip ma wakŋin teŋ mapemâzin.” ");
INSERT INTO naf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Zisasiyaŋ tipman baenen am sambe meu indaye yanaman mise ŋen am sambe penaŋ ondek tapme kasup tuk bepi Zet Zapat Dolakŋaŋ tadiindometne peme, am ekŋenaŋ meu bugan mkobien e nime delaŋ zemâge. Âpme amnaŋ tu meu aikti niniyelen setnaŋ ŋen ku aikbiengapm Zisasiyaŋ nembaŋane indapmandame kopme zeye, “Neŋ am sambemak kasup tuk takwati meuŋin belaknik mkobien elak nime delaŋ zeyeyepmti alak meuŋinpiŋ tapme indikti neŋ ekŋengat kembeŋ penaŋ miap. ");
INSERT INTO naf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Am notnaŋ mkaŋin beŋangatnan penaŋ kobiengapmti belak indema gilik zem mkaŋinan mesât meti meuyet selen sukŋan bemti zikalin gililiŋ peme tokutuseip beme ŋep ku besem.” ");
INSERT INTO naf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Zeme nembaŋane ekŋenaŋ yaŋkwesiwien, “Msat tuŋgupman pi tu meu desetgat aikti indamann nseip?” ");
INSERT INTO naf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Zeme Zisasiyaŋ indayaŋkwesiye, “In nupmamaŋ zigok mtalip?” Zeme ekŋenaŋ zewien, “Nupmamaŋ 7 mtatnup.” ");
INSERT INTO naf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kegok zeme nâmti am ekŋengat zeme ondekti msalen gwilelaŋ totapme nupmamaŋ 7 ke mti Kawawaŋgat, “Wisikŋ,” zemti meselem nembaŋane kalaŋ indame ekŋenaŋ timti am indamebien. ");
INSERT INTO naf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Âpme aŋgala isikŋaŋ notnaŋ kegogak taindaye. Ke Zisasiyaŋ mti kegogak Kawawaŋgat wisikŋ zemti nembaŋane kalaŋ indame timti am kalaŋ indamebien. ");
INSERT INTO naf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Indame am 4 tausen piyaŋ meu nimkiŋgapme butnaŋ belak temege ke timti tise 7 wepme gak zeye. ");
INSERT INTO naf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kegok mti Zisasiyaŋ am zemindeme mkaŋinan mekobien. Am zemindeme mekopme Zisas ma nembaŋane ekŋenaŋ ilinak etaŋ waŋgaen moti Dalmanuta msalen daen mebien. ");
INSERT INTO naf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dalmanuta msalen met tapme Palisi an notnaŋ ekŋenaŋ Zisasmagen koti menok temaŋ notnaŋ mme ekŋenaŋ Kawawaŋgat Nemuŋaŋ penaŋ ke nâmâtâtâgalen tetipem ekbien. ");
INSERT INTO naf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mme Zisasiyaŋ ekŋen ke indikti keŋan bekanaŋ beme zeye, “Alak kan pigogak am talip ekŋen kapiyaŋ kwilekiyet menok mme eegat etaŋ manzeip? Keyepm alak kan kapiyet neŋ ekŋenmagen menok ŋen ku mma ekseip, yek penaŋ.” ");
INSERT INTO naf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Egaŋ kegok zemti katiindemti nembaŋane ilinsakwep gilik zemti waŋga keŋan ewe moti tundua nembeleset mebien. ");
INSERT INTO naf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nemba ekŋenaŋ nupmamaŋ mekwititiyet kandati nupmamaŋ kwewetaŋ waŋga keŋan tagaen ke mkobien. ");
INSERT INTO naf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Âpme Zisasiyaŋ Palisi ekŋengalen mama mimi ke ekme ŋep ku beye keyepmti selen kopmambe Zisasiyaŋ nembaŋaneyet golaŋ zet zemti bemzenze zet kapigok diindoye, “In Palisimak Elot egetgalen yis keyet eksewep.” ");
INSERT INTO naf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Zeme nembaŋane ekŋenaŋ Zisasiyelen zet keyet yaŋaŋ ku weyaŋnâmbiengapmti ilinak zenâ zenâ mti pigok zewien, “Nin nupmamaŋ ŋen kwititipiŋ belak kotngapmti Zisasiyaŋ keyet tazen.” ");
INSERT INTO naf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ekŋenaŋ kegok zenâ zenâ tapmme Zisasiyaŋ nâmti pigok indayaŋkwesiye, “In nupmamaŋ kwititipiŋ kolo keyet eneyet zenâ zenâ tapmip, in nâgât yaŋŋ ku eknâmâtâlip, ma? In keŋin uwatnaŋ penaŋ! ");
INSERT INTO naf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","In neŋ kwitnaŋ kwitnaŋ mima ‘Zikalinaŋ eek ektiŋgut ku maekmâtâlip ma zet zema wakŋinaŋ zet nânâ nâmtiŋgut ku manâmâtâlip.’ In tipman baenen am 5 tausen pi nupmamaŋ 5 etaŋ bukeyaŋgut meselem indama nimbien ke ku nâmâtâlip?” Zemti nembaŋane indayaŋkwesiye, “In nupmamaŋ nimkiŋgapme belak temepme timti ele zigok webien?” Indayaŋkwesime ekŋenaŋ zewien, “Ele 12 kegok webenn.” ");
INSERT INTO naf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Zeme Zisasiyaŋ ewe indayaŋkwesiye, “Kan ŋengat nupmamaŋ 7 mti am 4 tausen pi indama nimkiŋgapme butnaŋ totemepme timti ele zigok webien?” Indayaŋkwesime ekŋenaŋ zewien, “7 webenn.” ");
INSERT INTO naf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Zeme nâmti pigok diindoye, “In neŋ kegok mimiyet windenn tatnain keyet yaŋŋ mkawaŋ bema in nikti yaŋaŋ nâmâtâlipgapmti Palisi ekŋengalen mama mimi ku mâbep.” ");
INSERT INTO naf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Âpme Zisas ma nembaŋane ekŋenaŋ Besaida mkaen mepataŋ zeme mka keyetnan an ŋen zikatnaŋ beŋaŋ an keyet notnaneyaŋ Zisasiyaŋ sekŋane atamti mme dolakŋaŋ bembeyet watoti Zisasiyet yaŋkwesim giŋgiŋ mbien. ");
INSERT INTO naf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kegok zeme nâmti Zisasiyaŋ an zikatnaŋ beŋaŋ ke betnamti mka ganzenan ilidak baen metati Zisasiyaŋ an keyet zikatnanen zawagaŋ wasekpemti betnaŋ zikatnanen mobemti yaŋkwesiye, “Zikadan kwilekiki notnaŋ ŋep taekdik?” ");
INSERT INTO naf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Zeme an keyaŋ belak zem wat ekti zeye, “Neŋ am taliwen pi ŋep taindigap yaŋgut indikma tep ŋotekŋaŋ nemboŋ tabem temezin.” ");
INSERT INTO naf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zeme Zisasiyaŋ betnaŋ ewe zikatnan bemti weyaŋpeme zikalaŋ bikbik mti kwitnaŋ kwitnaŋ sambe bepi ekmâtâpmâge. ");
INSERT INTO naf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Âpme Zisasiyaŋ zempemti zeye, “Geŋ am mka tuŋgupman moti am keyet zapat diindondopiŋ belak buzak lolotnak mkandanen mesenik.” ");
INSERT INTO naf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Âpme Zisasiyaŋ nembaŋane ilinsakwep Sisalia Pilipai mka temaŋ manzemtemien keyelen mka isisikŋaŋ ŋengat seleset mepmambe Zisasiyaŋ nembaŋane pigok indayaŋkwesiye, “Am ekŋenaŋ nâgât kwiyaŋ tapmain manzeip?” ");
INSERT INTO naf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Indayaŋkwesime nembaŋane ekŋenaŋ zewien, “Gâgât am notnaŋaŋ, ‘Zân tu zulutindende an egaŋ gakikiengatnan wati tapmain,’ manzeip ma notnaŋaŋ, ‘Kawawaŋgalen golaŋ zenze an itnaŋaŋ ŋen egaŋ wati tapmain,’ manzeip ma notnaŋaŋ, ‘golaŋ zenze an Ilaiza egaŋ kululuŋengatnan toti tapmain,’ kegok manzeip.” ");
INSERT INTO naf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Zeme nâmti naman Zisasiyaŋ ilinaŋgat indayaŋkwesiye, “Âpme in nâgât kwi manâmneip?” Indayaŋkwesime Pitayaŋ dopmaŋ pigok gilik zem zeye, “Geŋ Kilais Kawawaŋaŋ am nin yomengatnan gilik zemndatitiyet zemgeme tobanan. Kegok penaŋ manâmgenup.” ");
INSERT INTO naf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Zeme yaŋaŋaŋ ke am notnaŋ ku zemindandayet nembaŋane zemkulumindeye. ");
INSERT INTO naf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Âpme Zisasiyaŋ nembaŋane zet zemzikat indam metneti zeye, “Angat Nemuŋaŋ neŋ mamoti amnaŋ sindem temaŋ penaŋ nawep. Sesewat mka temaŋgalen an damuŋ ma sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda an ekŋenaŋ niktakalimti nome gakiwawaŋgut naman kasup tuk etaŋ tati ewe gilik zemwabap.” ");
INSERT INTO naf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kegok zemkawaŋ bemindame keyegak Pitayaŋ Zisas wati nemba notnaŋ bamkumindemti yaŋbemti Zisasiyaŋ ku gakikiyet zemkulumpeye. ");
INSERT INTO naf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Zeme Zisasiyaŋ naman nembaŋane notnaŋ ekŋenmagen gilik zemindikti Pitayet zeye, “Geŋ Sadaŋgalen nânâ mgasik ke pemane talak! Geŋ zet zenik ke Kawawaŋgalen ŋoktik yek, amgalen ŋoktik etaŋ otnâmtiyepm zenik!” ");
INSERT INTO naf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Âpme Zisasiyaŋ am sambe ekŋen ma nembaŋane indazemtetime ekmagen kopmâpme ekŋengat zeye, “An ŋenaŋ neŋmagen tususâgât mbe beme egaŋ ikŋaŋgat sekŋaŋ mtoti segalen kwitnaŋ kwitnaŋgat ku nâmtikŋaŋ mti egaŋ sindem temaŋ Angat Nemuŋaŋ neŋ tiwap sakam keboŋ timti namâbe. ");
INSERT INTO naf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ma am ŋenaŋ ek sekŋaŋgat yayaŋ mti Kawawaŋgalen zezapat dolakŋaŋ ku mkawaŋ bewe beme egaŋ mama kanzizit ku tiwe. Yaŋgut am ŋen egaŋ sekŋaŋ nâgât talasiwe beme mama kanzizit mama ke ŋep tiwe. ");
INSERT INTO naf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Am ŋen ek msat kapiyelen milom bilombi sambe ke tim nalak nalak mam mnepeme mamaŋaŋ yuŋgume ek keyaŋ walebe. Msalengalen kwitnaŋ kwitnaŋ keyaŋ zigok mukulem mme mama kanzizit tiwe? Yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Egaŋ walelet mundumen met tazin ke naman kwitnaŋ kwitnaŋ ŋenaŋ bamamaŋaŋ ku kwitimti gilik zem wawagalen. Yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mineti am ŋenaŋ Angat Nemuŋaŋ nâgât ma Zet Zapatn Dolakŋaŋ kapi am Kawawaŋgat zemtalatpemti kileŋ mamaip ekŋengat zikalinan zemkawaŋ bembeyet sakambuk mbe beme neŋ bam kululuŋ Bipmnaŋgalen winde ma busatnaŋmak ma Kawawaŋ egalen ensel teŋ maip ekŋenmak kobap kan keyet neŋ kegogak am ekŋen keyet nâma sakambukŋaŋmak beme bamkumindewap.” ");
INSERT INTO naf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zisasiyaŋ zet ŋen ewe pigok tusumti diindoye. “Neŋ zet penaŋ sukwep penaŋ pigok zema nâit, in am talip kapiyetnaŋ am notnaŋaŋ ewe gakikipiŋ tapmetnepeme Kawawaŋgalen zemâtâtâtgat katnanen mama keyaŋ windeŋaŋmak kawaŋ beme ekbep.” ");
INSERT INTO naf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Manepeme kasup 6 mepme Zisasiyaŋ nembaŋane Zânmak Zems ma Pita indatime ilinak etaŋ kalaŋan memoti Zisasiyaŋ sek sepemaŋ asekti naman sepemaŋ igak penaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Melakanduŋaŋ mee pi satnaŋ penaŋ bemti sokŋaŋaŋ puyuk peyak penaŋ mge. Msalen an ŋenaŋ melakandu zulupme sepem keboŋ penaŋ ŋep ku benak. ");
INSERT INTO naf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Âpme nembaŋane ekŋenaŋ ke ekpeŋ tapme Mosesimak Ilaizayaŋ keyegak koti Zisasmak zenâ zenâ tapmme indikbien. ");
INSERT INTO naf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Indikti Pitayaŋ Zisasiyet zeye, “An zikat indanda, pi dolakŋaŋ penaŋ nnak kapi tatnupgapmti nâmane mka minzalaŋ tuk, ŋen gâgât, ŋen Ilaizayet, ŋen Mosesiyet walati mambanup.” ");
INSERT INTO naf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Pitayaŋ kiŋgagat palen tati zet yaŋaŋ nânâpiŋ; belak kileŋ kegok zeye.) ");
INSERT INTO naf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Zeme keyegak zanza ŋenaŋ tot indasumuŋme indidikpiŋ mbien. Âpme zanza keyet keŋanen zet kapigok sokbeye, “Kapi nanaŋgat Nemun penaŋ. Neŋ egat tikŋaŋ manâyapgat in egat zetnaŋ gawepuwep.” ");
INSERT INTO naf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Zet kegok sokbeme keyegak nembaŋane ekŋenaŋ meek koek mti Zisasiyaŋ igak etaŋ tapme ekbien. ");
INSERT INTO naf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Âpme Zisasiyaŋ kot indatimti kalaŋangatnan kwatopmambe Zisasiyaŋ Nembaŋaneyet zemkulumindemti zeye, “In kwitnaŋ kwitnaŋ e ego keyet zet zapatnaŋ am ŋen diindondopiŋ manepeme Angat Nemuŋaŋ neŋ gakikiengatnan gilik zemti wabap.” ");
INSERT INTO naf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Zet ke ekŋenaŋ nâmti keŋinan bemti ilinak pigok zenâ zenâ mti zewien, “Gakikiengatnan wawat zet kapi kwilekiyet nâmti zeina?” ");
INSERT INTO naf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ilinak kegok zem mbienaŋ yek beme Zisasiyet yaŋkwesiwien, “Zuda amgalen zii zet zemzikat indanda an ekŋenaŋ eneyet Kawawaŋgalen golaŋ zenze an Ilaiza egaŋ ŋeŋaŋ kopmeŋgut bam Mesaya An Kawawaŋaŋ amŋane yomengatnaŋ timkwatindendeyet ombempeye keyaŋ kobe manzeip?” ");
INSERT INTO naf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kegok yaŋkwesime Zisasiyaŋ pigok diindoye, “Ilaizanok ek ŋeŋaŋ penaŋ koti am yomengatnan timkwat indendeyet mulupmaŋ mimiyet zenzeŋaŋ mge. Âpme zet ŋen zenzeŋaŋ tazin kapi zigosetgat Angat Nemuŋaŋ neŋ sindem temaŋ namti bamkumneneyet Kawawaŋgalen zelen kogok meluwaŋ mimiŋaŋ? ");
INSERT INTO naf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Neŋ pigok penaŋ zema nâit, an Ilaiza nemboŋ ilak kopme amnaŋ muluwaŋ bekanaŋ sepem igak igak msawien. Kawawaŋgalen Zet Itnaŋanen meluwaŋ mimiŋaŋ keyet kataŋ sokbeye.” ");
INSERT INTO naf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Zisasmak nembaŋane tuk ekŋenaŋ kalaŋangatnan nembaŋane notnaŋ tabien ekŋenmagen toti indikme am notnaŋaŋ inda bembuluŋ tapme Zuda amgalen zii zet zemzikat indanda an ekŋenmak Zisasiyet nembaŋane notnaŋ tabien ekŋenaŋ ŋenaŋ ŋengat zemtalat ŋenaŋ ŋengat zemtalat tapmambien. ");
INSERT INTO naf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yaŋ am sambe ekŋenaŋ tatneti ekme Zisasiyaŋ daen kopme ekti Zisasiyet olimti windenbemeti mkuwien. ");
INSERT INTO naf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Met mkume Zisasiyaŋ indayaŋkwesiye, “Indati kwilekiyet dopmaŋgat tapmdândâmo?” ");
INSERT INTO naf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Âpme an ŋen ekŋengat tuŋguwinangatnan wati zeye, “An zikat indanda, neŋ nemun we bekanaŋaŋ mme zet zenzepiŋ mammgapmti geŋmagen wakolap. ");
INSERT INTO naf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nemba kapi we bekanaŋaŋ mtati msalen kutupeme kwati zawak salaŋ kwilak kwilak mti zetnaŋ aŋgalikti setnaŋ betnaŋaŋ mutututi katikŋaŋ mambein. Keyepm neŋ nembandine ekŋengat zema we bekanaŋ zempeme mebegat olalo.” ");
INSERT INTO naf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Zeme Zisasiyaŋ zet ke nâmti am tabien ma nembaŋane ekŋengat zeye, “In nâmkiŋpepeŋinpiŋ penaŋ! Neŋ inmak kan teepmaŋ kapi mamti indamukulem mamambap?” Diindomti zeye, “Anemba denze wati kopme ekbi!” ");
INSERT INTO naf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Zeme anemba ke Zisasmagen sokŋan wapmepme we bekanaŋaŋ Zisas ekti nemba piwan belak msalen mkutupeme kwati kililiŋ mti zawak salaŋ kwilak kwilak mge. ");
INSERT INTO naf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Âpme Zisasiyaŋ nemba keyet bipmaŋgat yaŋkwesiye, “Nembandi kapi kan zukŋan penaŋ yaŋbemti muluwaŋ kapi mge?” Yaŋkwesime bipmaŋaŋ zeye, “Nemba isikŋanenagak yaŋbemti mge. ");
INSERT INTO naf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","We bekanaŋ egaŋ sesepelimti wat tokwapme meti sekŋaŋ waleletgalen mulup temaŋ penaŋ mamin. Keyepmti geŋ windendi tazin beme ŋep ndapmukulem mimnde.” ");
INSERT INTO naf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Âpme Zisasiyaŋ zeye, “Kwilekiyet geŋ windendi ŋep tazin beme mbek zet e zenik? An ŋenaŋ nâmkiŋpepeŋaŋ katikŋaŋ penaŋ tabe beme kwitnaŋ kwitnaŋ zein keyet kataŋ ŋep sokbem sawe.” ");
INSERT INTO naf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Zeme keyegak nemba keyet bipmaŋaŋ sinzet palen zeye, “Neŋ nâmkiŋpemgeyap yaŋgut nâmkiŋpepen katikŋaŋ yegat napmukulem mmane geŋmagen nâmkiŋpepen katikŋaŋ bak.” ");
INSERT INTO naf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Âpme am sambe penaŋ windem bemti taondak kopme Zisasiyaŋ we bekanaŋ anemba masesepelimwati mamtan keyet zet windeŋaŋbeŋ zempemti zeye, “Geŋ anemba keŋangatnan kwati meti ewe gilik zem kapiyegak ŋen ewe ku kwatowebanik.” ");
INSERT INTO naf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Âpme we bekanaŋaŋ kwati mesât mge, kan keyet nemba bekan piwan omba penaŋ butemti we bekanaŋaŋ yeye mti kwati mepme anemba keyaŋ gakikiŋaŋnok toaŋgasim weme am ekŋenaŋ ekti zewien, “Nemba pito ilak gakip.” ");
INSERT INTO naf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kegok zeme Zisasiyaŋ nemba betnanen atamti mwat onzempeme tage. ");
INSERT INTO naf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kegok mti Zisasiyaŋ mkaen mowepme nembaŋane ekŋenaŋ keyegak moti ilinak etaŋ tati yaŋkwesiwien, “Kwilekiyet nin we bekanaŋ ke mâbâgat olapmann bep?” ");
INSERT INTO naf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yaŋkwesime Zisasiyaŋ zeye, “We bekanaŋ ekŋen keboŋ ke belak ŋep ku indamâbâgalen dundundumak tati ŋep indamâbâgalen.” ");
INSERT INTO naf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Zisasiyaŋ nembaŋane gakikiŋaŋgat zapatnaŋ ilinak diindondoyet nâŋge keyepmti ekŋenaŋ mka ke katipemti Galili msat tuŋgupmaset buzak buzak enzilimti mebien. Selen mepmambe Zisasiyaŋ nembaŋane zemzikat indamti zeye, “Angat Nemuŋaŋ neŋ maneti amgat belinan mopma ekŋenaŋ nome gakima nabewep. Yaŋ kasup tuk etaŋ tati ewe gilik zem wabap.” ");
INSERT INTO naf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Egaŋ kegok zeme ekŋenaŋ zet ke yaŋaŋ ku weyaŋnâmâtâti yaŋkwesimti nâsâgât mbienaŋgut naman kiŋgati belak peme tage. ");
INSERT INTO naf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ekŋenaŋ meti Kapaneam mkaen pataŋ zemti mka ŋengat motati Zisasiyaŋ nembaŋane indayaŋkwesimti zeye, “Selen daen in kwilekiyet tazenâmkopmo?” ");
INSERT INTO naf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kegok indayaŋkwesime ekŋenaŋ selen daenen koti, “Kwiyaŋ ningat amobotnaŋ mambe?” Zemti zenâ zenâ tapmkopmambiengapmti zelinpiŋ buzak tabien. ");
INSERT INTO naf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Âpme Zisasiyaŋ mkaen koweyeyaŋ totati nembaŋane 12 ekŋengat zeme koondak tapme zeye, “An ŋenaŋ amobotnaŋ mamasâgât nâin beme egaŋ tototnaŋ penaŋ mamti am notnaŋ ekŋen sisiliŋ mulup mimindamti mambe.” ");
INSERT INTO naf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Kegok zemti nemba isikŋaŋ ŋen wati tuŋguwinan mwat ambetati zeye, “Nemba keboŋ kapi an ŋenaŋ nâgât mti gogot mpewe beme egaŋ neŋ gogot mnewe ma ŋenaŋ neŋ gogot mnewe beme An zemneme toban ek kegogak gogot msawe.” ");
INSERT INTO naf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Âpme Zânaŋ Zisasiyet zeye, “An zikat indanda, nin an ŋenaŋ gâgât kwidan kumti we bekanaŋ mâpeme ekti ninmak ku mamaingapmti zemkulumpenn.” ");
INSERT INTO naf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kegok zeme nâmti Zisasiyaŋ nembaŋane ekŋengat pigok diindoye, “In an ŋenaŋ nâgât kwitnnan kumti muluwaŋ tototnaŋ keboŋ mme ekti ku zemkulumpewep. An keboŋ keyaŋ sakwep eleŋ beleŋ bemti nin ku zemtalatndewe. ");
INSERT INTO naf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","An ŋen mulupmnaŋgat ku zemtalatndewe ek ningat notn kegok nâmpewanup. ");
INSERT INTO naf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Neŋ pigok penaŋ zema nâit, in nâgât nembanne maipgapmti am ŋenaŋ kwitnaŋ kwitnaŋ dolakŋaŋ ŋen ma okowen tu etaŋ bemindame nimbep beme an ke tosaŋepiŋ belak penaŋ ku tabe bam maneti keyet tosaŋaŋ tiwe. ");
INSERT INTO naf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Am ŋenaŋ notnaŋ ŋen nâmkiŋpepeŋaŋ isikŋaŋ bugan tasain ek bekanaŋ mimiyet zet kelakŋaŋ mpeme bekanaŋ mbe beme an bekanaŋgat zet kelakŋaŋ mpewe ke bimanen nanzaŋ siput temaŋaŋ opempemti nembu keŋan âtâpeme towepme dolakŋaŋ bein mneti ekŋenaŋ kegok ku mme egaŋ belak tapmetneti Kawawaŋgalen zemdelaŋ zenze kanen dopmaŋ nukŋaŋ bekanaŋ penaŋ tiwe. ");
INSERT INTO naf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Sepem kegok tazingapmti bedi ŋenaŋ mama mimi bekananen gaik mesâgât mme eleŋgem pemane mebe. Geŋ mineti bedi zuzulak mmaneti teziŋ ŋandaŋ toti tewen zimti sek sindem tipeŋ mamambanikmagengat bedi eleŋgem pemane mepme bedi nembet dumaŋ maneti mama kanzizit tiwanik. ");
INSERT INTO naf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‘Âk kegok ku mbanik beme teziŋ ŋandaŋ meti sambum kuluk kwilak mti gakikipiŋ sindem tipeŋ tipeŋak mamambanik ma tewaŋ kogogak gazime sindem tipeŋ mamambanik.’ ");
INSERT INTO naf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma geŋ sedaŋ mama mimi bekanaset gapmesâgât mme sedi nembet eleŋgem pemane mepme kaŋtaŋ kaŋtaŋ mamambanik. Mineti sedi zuzulak maneti teziŋ ŋandaŋ towebanigat sedi nembet eleŋgem pemti sedi nembet dumaŋ piyaŋ kaŋtaŋ kaŋtaŋ maneti mama kanzizit aikbanik. ");
INSERT INTO naf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘Âk kegok ku mbanik beme teziŋ ŋandaŋ meti sambum kuluk kwilak mti gakikipiŋ sindem tipeŋ tipeŋak mamambanik ma tewaŋ kogogak gazime sindem tipeŋ mamambanik.’ ");
INSERT INTO naf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma geŋ zikadi ŋenaŋ mama mimi bekanaset gapmesâgât mbe beme geŋ kwenzempemane mebe. Mineti geŋ zikadi ilindiŋ maneti teziŋ ŋandaŋ towebanikgat kwenzempemane mebe. ");
INSERT INTO naf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Âk kegok ku mbanik beme teziŋ ŋandaŋ meti sambum kuluk kwilak mti gakikipiŋ sindem tipeŋ tipeŋak mamambanik ma tewaŋ kogogak gazime sindem tipeŋ mamambanik. ");
INSERT INTO naf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Neŋ geŋmak tususu mimiyet zetik mban keyet katnaŋ ku mambanik beme neŋ katikgema teziŋ ŋandaŋgat zapat bewanik. ");
INSERT INTO naf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Dalaŋ ke tikŋaŋ keyaŋgut dalaŋgat tikŋaŋ delaŋ zeme amnaŋ selen mulati maimmak kolip keboŋ. Kogogapm in dalaŋ nemboŋ keyet tikŋaŋin kwesiŋ tatagat nâmti in keŋin dolakŋaŋ tapme nolinmak keŋ kwep bemti keŋ sewakŋaŋ palen mamambep.” ");
INSERT INTO naf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Âpme Zisasiyaŋ mka ke naman katipemti Zudia msaleset meti Zodan tu nembet daen mepme am sambeyaŋ ewe koondakme manzemzikat indamtan, kegogagapm Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ diindom zikat indamiŋge. ");
INSERT INTO naf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tadiindome Palisi an notnaŋaŋ koti, “Zisas tetipemann egaŋ zet ŋen zemyuŋgume ekti wati zelen mepesenup,” zemti kapigok yaŋkwesiwien, “An ŋenaŋ imbiŋaŋ asekpepeyelen Mosesiyelen zii zelen set ŋen tazin ma yek?” ");
INSERT INTO naf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Zeme Zisasiyaŋ naman dopmaŋ yaŋkwesisiyegak kapigok indayaŋkwesiye, “Mosesiyaŋ awembiŋ kalalaŋgat zigok zeye?” ");
INSERT INTO naf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Indayaŋkwesime ekŋenaŋ zewien, “An ŋenaŋ imbiŋaŋ asekpemti zemâtâtât papia kumsame mebegat Mosesiyaŋ ŋep mimiyelen zeye.” ");
INSERT INTO naf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kegok zeme Zisasiyaŋ dopmaŋ pigok gilik zem indaye, “In keŋ katik mbiengapmti Mosesiyaŋ nâmindamti zii zet ke kumindaye wa ke Kawawaŋgalen ŋoktik penaŋ yek. ");
INSERT INTO naf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kawawaŋaŋ yaŋbemti kwitnaŋ kwitnaŋ sambe mge kan keyet egaŋ an ma imbi betnaŋaŋ penaŋ miideye. ");
INSERT INTO naf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Keyepmti Kawawaŋgalen Zet Itnaŋaŋen kapigok zein, ‘An ŋenaŋ imbiŋaŋ wazin beme egaŋ mambipmaŋ katiidemti egelaŋ keŋit segit pepep bemalu kwep beme mambalup. ");
INSERT INTO naf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kawawaŋaŋ animbi kapi tusum idendeŋaŋgapmti ilit ma am ŋenaŋ kileŋ ku kalaŋidewe.’” ");
INSERT INTO naf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mkaen motati nembaŋane ekŋenaŋ zet keyet yaŋaŋ nânâyet yaŋkwesiwien. ");
INSERT INTO naf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yaŋkwesime egaŋ yaŋaŋ pigok diindoye, “An ŋenaŋ imbiŋaŋ asekpemti an ŋengat imbiŋaŋ menzem wabe beme yom mbe. ");
INSERT INTO naf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma imbi ŋenaŋ apmaŋ asekpemti imbi ŋengat apmaŋ menzemwabe beme egaŋ awembiŋ mama ke kalaŋti yom tiwe.” ");
INSERT INTO naf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Âpme am ekŋenaŋ nembaŋine Zisasiyaŋ indati mebegat indatim kopme Zisasiyet nembaŋane ekŋenaŋ nemba isikŋaŋ ekŋengat nâme tototnaŋ beme Zisasiyaŋ ku indati mebegat zemkulumindewien. ");
INSERT INTO naf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kegok tapmme Zisasiyaŋ indikti nâme ŋep ku beme zeye, “Kululuŋen gwaen mama katikŋanen amnaŋ nemba ekŋen keboŋ bemti mebegat zenzeŋaŋgapmti nemba zemkulumindendepiŋ katiindeme neŋmagen kolit. ");
INSERT INTO naf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Neŋ penaŋ zema nâit, an ŋenaŋ nemba isisikŋaŋ ekŋenok bemti zet nâme penaŋ penaŋ etaŋ beme yaŋkwesim giŋgiŋ ku mamip. Keyet katnan yaŋkwesi yaŋkwesi mimipiŋ. Belak etaŋ nâmkiŋpewe beme ekŋen Kawawaŋgalen zemâtâtâtgat katnanen mama keyet keŋan meti masâip.” ");
INSERT INTO naf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kogok diindomti nemba kwep kwep ekmagen kopme indambetati popop kumindemambe betnaŋ ŋokŋinan bemti Kawawaŋaŋ indamukulem mimindendeyet zemgwatnaŋ mge. ");
INSERT INTO naf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Âpme Zisasiyaŋ mka ke katipemti tapmepme an mânep milawatnaŋ temaŋ keyaŋ ekti windembem kot Zisasiyet nâme mobotnaŋ beme pedondom samti yaŋkwesiye, “An zikat indanda dolakŋaŋ, neŋ zigok penaŋ mti mama kanzizit ke tiwap?” ");
INSERT INTO naf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yaŋkwesime Zisasiyaŋ dopmaŋ pigok gilik zem dunduye, “Geŋ nâgât ‘An zikat indanda dolakŋaŋ,’ zenik. Zet keyet yaŋaŋ ŋep nâmdelaŋ zemti zenik? Kawawaŋ kwewaŋ dolakŋaŋ. ");
INSERT INTO naf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Geŋ Mosesiyelen zii zet kapigok tazin ke nânik, ‘Kasa ku kuwanik, imbimak sek kileŋ ku mambanik ma kambu ku tiwanik, zet dâsuki ku zewanik ma amgalen milawat notnaŋ kileŋ ku omenzaŋ tiwanik, ma geŋ mambipdineyet kandaŋidan meti zet nânâŋ mambanik.’” ");
INSERT INTO naf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Zeme an keyaŋ zeye, “An zikat indanda, kwitnaŋ kwitnaŋ zenik ke nemba isikŋanenak baenen yaŋbemti maŋgawepumkwalap.” ");
INSERT INTO naf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zeme Zisasiyaŋ ekti nâmtikŋaŋ mpemti zeye, “Geŋ kwileki ŋen ewe mimiyelen tagain. Geŋ gilik zem mkandan meti milawadi sambe tazin ke kalaŋ kumti am bekopsat indamâpmane delaŋ zeme kopmane neŋmak meselup. Âpme keyet dopmaŋ maneti kululuŋen gwaen tiwanik.” ");
INSERT INTO naf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Zisasiyaŋ kok zeme egaŋ mânep milawatnaŋ temaŋgapm nâpeme mekwapme belak zetnepiŋ kusum tati kembeŋ palen mege. ");
INSERT INTO naf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mepme Zisasiyaŋ nembaŋane guluk gilik zem meindik koindik mti zeye. “Am mânep milawalin temaŋ ekŋenaŋ Kawawaŋgalen zemâtâtâtgat katnanen mama keŋan mebegalen e kwindendeŋaŋ temaŋ penaŋ.” ");
INSERT INTO naf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Zeme nemba ekŋenaŋ zet ke nâmti nâmtemtem penaŋ mme Zisasiyaŋ ewe pigok diindoye, “Nembanne kululuŋen gwaen mama katikŋanen mebegalen set ke nukŋaŋ penaŋ. ");
INSERT INTO naf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bo temaŋaŋ buŋi aimboŋaŋ isikŋanen ŋep ku modak. Yek penaŋ. Sepem kegogak am mânep milawalinmagaŋ Kawawaŋgalen zemâtâtâtgat katnan maip ekŋenmak tususuyelen nâmnukŋaŋ penaŋ mamip.” ");
INSERT INTO naf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kegok zeme ekŋenaŋ nâmtemtem temaŋ mti zewien, “Kok zenik beme kwiyaŋ mama kanzizit ŋep tiwe?” ");
INSERT INTO naf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zeme Zisasiyaŋ indikmototi zeye, “Mânep milawalaŋ set bekekme am Kawawaŋgalen zemâtâtâtgat katnan maip ke ku tusuwep yaŋgut Kawawaŋaŋ am ekŋen keyet keŋin mim eleŋ belaŋ beme mama kanzizit ke ŋep tiwep.” ");
INSERT INTO naf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Zeme Pitayaŋ zet ke nâmti Zisasiyet pigok dunduye, “Nânik, nin kwitnaŋ kwitnaŋ sambe bamkumpemann delaŋ zeme geŋmagen kobenn.” ");
INSERT INTO naf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zeme Zisasiyaŋ dopmaŋ pigok gilik zem saye, “Neŋ penaŋ sukwep zema nâmbak, am ŋenaŋ nâgât ma Zet Zapat Dolakŋaŋgapmti mkaŋaŋ ma dapmeniŋaŋ ma ipmamnotnane ma mambipmane ma nemunnambaŋane ma msatnaŋ mee pi katipe mâbe beme ");
INSERT INTO naf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Kawawaŋaŋ egat tosaŋaŋ 100 ewe tusum sawe. Pien msalen msat, mka ma dapmeniŋaŋ ma ipmaŋ ma mamaŋ bipmaŋ ma nemunambaŋaŋ ma mâmulupmaŋ mee pi omba samâbe. Âpme msalen kapi nâgât zet zapatn mti mame amnaŋ keyet pepetnaŋ mti sisipeŋpeŋ mpeme ola olat palen mambe keyet penaŋaŋ mama kanzizit titiyet kanaŋ daŋgoween kan keyet egaŋ mama kanzizit keyet toŋaŋ bemtabe. ");
INSERT INTO naf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Apme an ŋenaŋ ikŋaŋgat sekŋaŋ alak pigogat mmoti, ‘Neŋ ŋep talap,’ tazein beme egaŋ bamgat tototnaŋ bewe. Ma ŋenaŋ alak tototnaŋ tapmain beme egaŋ bamgat mobotnaŋ bewe.” ");
INSERT INTO naf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zisasiyaŋ ŋeŋaŋ bemindame meti met set tuŋgupman tati Zisasiyaŋ Zelusalem mkaen mopme kwitnaŋ kwitnaŋ msawep keyet zet zapatnaŋ nembaŋane ma am notnaŋ zet zapat mimindame ekŋenaŋ nâmtemtem mti kiŋgagat palen Zisas mâti Zelusalem mkaen mosâgât mobien. ");
INSERT INTO naf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","Mopmambe Zisasiyaŋ zeye, “In nâip, nin Zelusalem mkaen mosâgât tapmotnup. Âpme kan keyet Angat Nemuŋaŋ neŋ sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda an ekŋenaŋ zemnome Zuda am maŋgaengatnaŋ ku sokbembeŋaŋ ekŋengalen belen mopma ekŋenaŋ tetepulet mnamti sindiwaŋ nawitikti sindem temaŋ nameti nome gakima met nabewep yaŋgut kasup tuk etaŋ tati naman ewe gilik zem wabap.” ");
INSERT INTO naf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Âpme Zebedi nemulatnenet Zemsmak Zân egelaŋ Zisasmagen meti zewun, “An zikat indanda, nit geŋ kwileki ŋen minndandayet nâmti gayaŋkwesisâpmilup.” ");
INSERT INTO naf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zemalu Zisasiyaŋ idayaŋkwesiye, “An zut, neŋ pe kwileki miidandayet nâmti kotazelup?” ");
INSERT INTO naf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Idayaŋkwesime egelaŋ dopmaŋ kapigok zewun, “Geŋ bam Amobotnaŋ mundumdanen tabanigen nit nâmndemane ŋenaŋ gâgât sukwakalakdi penaset ma ŋenaŋ alomeset tabalup.” ");
INSERT INTO naf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zemalu Zisasiyaŋ pigok diidoye, “It zet keyet yaŋaŋ kandati kegok yaŋkwesilup. Neŋ amnaŋ sindem nawep ke okowen tu akŋaŋmak nemboŋ bemname nimbap. Ke it ŋep nimbalup? Ma sindem tiwawen amnaŋ tu zulutnewepnok ke it kegogak ŋep zulubalup?” ");
INSERT INTO naf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Âpme egelaŋ egat zewun, “Nit ŋep mbalup.” Zemalu Zisasiyaŋ pigok diidoye, “Neŋ tu okop nimbawen keyegak it ŋep nimbalup ma neŋ tu zulubawen keyegak it ŋep zulubalup. ");
INSERT INTO naf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Keaŋgut neŋ sukwakalakŋ penaset ma alomeset tatagalen keyet zetnaŋ neŋ ŋep ku zesap e Kawawaŋaŋ ikŋaŋ mundum ke tatagat am kwi ombemindeye, ekŋen keyaŋ tabep.” ");
INSERT INTO naf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","An zulaŋ Zisasiyet kegok zemalu nembaŋane notnaŋ ekŋenaŋ egegat nâme bekanaŋ beme ŋenzinziŋ miidame ");
INSERT INTO naf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Zisasiyaŋ ilinsakwep indazem tetime kot ondek tapme pigok diindoye, “Msat sambe ekŋengalen amobotnaŋ temaŋ ekŋenaŋ mulup aŋine mka kataŋ indem mepme mamti ekŋenaŋ am notnaŋ indadamuŋ mme maip in keyet yaŋaŋ ŋep nâip. ");
INSERT INTO naf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Set kaboŋ kapiyaŋ inmagen ku sokbewe. Inmagengatnaŋ an ŋenaŋ amobotnaŋ besât mbe beme egaŋ am tototnaŋ notnaŋ ekŋengat sisiliŋ mulup mimi an bewe. ");
INSERT INTO naf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma inmagengatnan an ŋenaŋ ŋeŋaŋ mamayelen nâmti notnane ekŋengat kandaŋinan mamti am sisiliŋ mulup etaŋ tosaŋinpiŋ mamip keyet kataŋ miindawep. ");
INSERT INTO naf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Neŋ Angat Nemuŋaŋ amnaŋ neŋ napmukulem mneme mamayet nâmti ku koban. Neŋ nen am notnaŋ indamukulem mimindemti neŋ nanaŋgat mamann ke ketalasimti am yomengatnaŋ kwitim indatimti mama kanzizit indandayet nâmti toban.” ");
INSERT INTO naf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Âpme Zisasmak nembaŋane ekŋenaŋ Zeliko mka sebempemti mepme am sambeyaŋ baminan indamâti mebien. Âpme Timeasiyet nemuŋaŋ Batimeas ek zikatnaŋ beŋaŋaŋ set ganzenan ke mepeme totati mânep milawatgat am mawekum indamtan. ");
INSERT INTO naf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yaŋ am notnaŋaŋ “Zisas Nasalet mkaengatnaŋaŋ takozin,” zeme nâmti ŋagak palen zemsu zemsu mti zeye, “Zisas, geŋ Dewitgat sokŋaŋaŋ nâgât kembeŋ mi!” ");
INSERT INTO naf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Egaŋ kegok ŋagak mtasume am notnaŋ ekŋenaŋ, “Buzak tat,” zemti zemkulumpewienaŋgut egaŋ ewe ŋagak temaŋ msumti zeye, “Zisas, geŋ Dewitgat sokŋaŋaŋ nâgât kembeŋ mi!” ");
INSERT INTO naf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","An zikat beŋ keyaŋ kwizet takume Zisasiyaŋ nâmti set tuŋgupman ke metati zeye, “An ke zeme neŋmagen pien wakolit!” Zeme am ekŋenaŋ egat kwizet kumti zewien, “Batimeas, Zisasiyaŋ gâgât tazeingat oloŋen palen wati daen ekmagen met!” ");
INSERT INTO naf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Zeme egaŋ zet ke nâmti tâgâ melakanduŋaŋ sakwep gaipeme toweme belaŋ bemti Zisasmagen mesât pumpem pumpem mege. ");
INSERT INTO naf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mepme Zisasiyaŋ yaŋkwesiye, “Neŋ geŋ kwileki penaŋ mgaŋgayelen nâmti tazenik?” Yaŋkwesime an zikatnaŋ beŋaŋ keyaŋ zeye, “An zikat indanda, geŋ zikatn weyaŋnemane eegalen nâmti tazeyap.” ");
INSERT INTO naf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Zeme Zisasiyaŋ pigok dunduye, “Nâmkiŋpependaŋgat penaŋaŋ zikadi alik beme ekti mesenik.” Zeme keyegak zikatnaŋ alik beme ekmâtâti Zisas mâti mege. ");
INSERT INTO naf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Zisas nembaŋane ekŋenaŋ Zelusalem mka teman sokŋanik moti Betpasi ma Betani mka zut Olip kalaŋan tazin ke mopataŋ zemti Zisasiyaŋ nemba zut zemidemti zeye, “It mkaen kainde mot pataŋ zenzeŋak ekmalu doŋki nembaŋaŋ ŋen tegaŋ opempepeŋaŋ am ŋenaŋ dukŋan ŋen ewe ku mamaŋaŋ ke tapme ekti kwalet mti koselup. ");
INSERT INTO naf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Metakwaletnepemalu an ŋenaŋ, ‘It zigok msâgât takwalelup?’ idayaŋkwesime an keyet kapigok zeselup, ‘Amobotnaŋaŋ kapi mmet samalu egaŋ mmaneti naman sakwep ewe mkoti mundumanak gilik zem opempepeyet zeme kot takwalelup.’ Kegok zemalu egaŋ nâmideme kwalet mti koselup.” ");
INSERT INTO naf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kegok zeme nemba zut egelaŋ meti doŋki nembaŋaŋ tegaŋ mka set keyet solonan opempepeŋaŋ tapme ekti metakwalepmalu ");
INSERT INTO naf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","am notnaŋ sokŋan tabienaŋ idikti zewien, “It kuwiekiyet doŋki nembaŋaŋgat tekŋaŋ ke takwalelup?” ");
INSERT INTO naf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Zeme egelaŋ Zisasiyaŋ zet zemideye keyet kataŋ zemalu nâmideme egelaŋ tekŋaŋ ");
INSERT INTO naf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","kwaleti Zisasmagen mmeti melakanduŋit gulumti doŋki bisetnaŋ palen bempemalu Zisasiyaŋ keyet palen mototati ");
INSERT INTO naf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zelusalem mka teman mopme am sambe penaŋaŋ melakanduŋin ma notnaŋ ekŋenaŋ tep belak set ganzenan tapmege bee mutumti siŋsasatnaŋ melesiŋ kot selen yeŋgemebien. ");
INSERT INTO naf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mti bembuluŋ meti ŋagak ma kwisak temaŋ mti zewien, “Kot ndapmukulem mti ndaŋgalaŋ nde! An kapi Amobotnaŋmagengatnaŋ ndamukulem minndesâgât kozingapmti kopme kwizet buŋamaŋ mwati sesewatpene. ");
INSERT INTO naf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yeŋsokŋ Dewit egaŋ am indadamuŋ mme dolakŋaŋ mambien. Keyet kataŋ an kapiyaŋ nin kot ndamukulem minndemti aŋgalaŋndesâgât kozingat kopme oloŋen mti sesewatpene!” ");
INSERT INTO naf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kegok mpeme egaŋ Zelusalem mkaen Zuda am ekŋengalen sesewat mka temaŋ keyet keŋan moti kwitnaŋ kwitnaŋ sambe bempeme wemege ke tokwati ekmâge. Mti ke manepeme msat gasi penaŋ beyeyepm nembaŋane 12 indatime Zelusalem mka katipemti Betani mkaen mebien. ");
INSERT INTO naf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mewembienaŋ mseŋan ewe gilik zem Zelusalem mka temanenak kosât koti Zisasiyaŋ meuyet penaŋ mge. ");
INSERT INTO naf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mti ekpeme mepme tep kwitnaŋ pik ŋen sinaŋ kundumaŋ temaŋ tapme ekti, “Wa katnaŋ ŋen tazinaŋ mâtâti nsap,” zemti met timapme beye. Pik katnaŋ eliligalen kanaŋ ewe ku beye. ");
INSERT INTO naf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Zisasiyaŋ pik tepmaŋgat zet kapigok zeye “Am ŋenaŋ gâgât kadi ŋen ewe ku nimbe.” Kegok zeme nembaŋane nâmbien. ");
INSERT INTO naf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kegok zeme ekŋenaŋ Zelusalem mkaen meti Zisasiyaŋ sesewat mka temaŋ keŋan mepmoti ekme amnaŋ kwaweti sâpe sâpe bumbuyet age ma mânep bemkwiti kwiti tapmme indikti egaŋ mânep mundum âtât peme kutume age mundumaŋ setnaŋ ke mâtâtindemâpme kwawepmâbien. ");
INSERT INTO naf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kegok mti muluwaŋ keboŋ ke sesewat mka temanen ewe kwitnaŋ kwitnaŋ timet timkot mimiyelen zemkulumindeye. ");
INSERT INTO naf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mti zet kapigok diindoye, “Kawawaŋgalen Zet Itnaŋanen meluwaŋ ŋen kapigok mimiŋaŋ tazin, ‘Nâlen mkannan am msat sambeyaŋ kwaweti dundundu mulup mbep!’ Âpme in naman mka kapi mme, ‘Am kambu titi ekŋengalen mkanok tabein.’” ");
INSERT INTO naf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Zisasiyaŋ kegok mme sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda an ekŋenaŋ ŋeŋin zime set ŋen aikti Zisas kume gakikiyelen nâmbien. Keyaŋgut am sambeyaŋ Zisasiyet zetnaŋgat nâme mobotnaŋ mambemtangapmti kiŋgati belak peme tage. ");
INSERT INTO naf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Âpme Zisasmak nembaŋane ilinsakwep ke manepeme tambusâgât tapmme ekŋenaŋ Zelusalem mka temaŋ katipemti Betani mkaenegak gilik zem mebien. ");
INSERT INTO naf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mewembienaŋ msame tambuŋan gilik zem koti ekme pik tep piwan memuŋaŋ penaŋ bem tapme ekti ");
INSERT INTO naf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitayaŋ Zisasiyaŋ zet zeye ke otnâmti zeye, “An zikat indanda, geŋ saŋenen pik tep saik kumpemanan piwan memuŋaŋ bem tazingat ekbak!” ");
INSERT INTO naf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Âpme Zisasiyaŋ dopmaŋ kapigok gilik zem indaye, “Neŋ zet penaŋ zema nâit, inmagengatnaŋ ŋenaŋ keŋ zutpiŋ Kawawaŋgat nâmkiŋpewe beme nukŋaŋ notnaŋ kalaŋ nemboŋ keyet kapigok zewe, ‘Geŋ epeemti nembuen towet,’ zemti zetnnaŋgat penaŋaŋ sokbembeyet zemti keŋ zutpiŋ tati dunduwe beme nukŋaŋ kalaŋnemboŋ keyaŋ ŋep etumti nembuen metowebe. ");
INSERT INTO naf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Neŋ ingat pigok penaŋ zema nâit, in nâmkiŋpepe kaliŋaŋ mti kwitnaŋ kwitnaŋ ke penaŋ sokbemindandayelen e nâmkatikbemti dunduwewen ŋep sokbemindawe. ");
INSERT INTO naf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Âpme geŋ dundusât mbanik kan keyet am ŋenmak kalalaŋit tazin beme yomaŋ ke katikpewanik. Katikpemane Kawawaŋ kululuŋen main egaŋ kegogak gâlen yomdi katikpewe. ");
INSERT INTO naf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Âk geŋ an ŋenmak yomit tazin ke ku katikpewanik beme Bipdi kululuŋen main egaŋ kegogak gâlen yomdi ku katipewe.” ");
INSERT INTO naf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Zisasiyaŋ zet kegok zemdelaŋ zeme ekŋenaŋ naman Zelusalem mkaen ewe mesâgât mebien. Meti Zisasiyaŋ ewe sesewat mka temanen moti tatokwapme sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda an ma sesewat mka temaŋgalen damuŋ notnaŋ ekŋenaŋ ekmagen kot ondekti yaŋkwesiwien, “Geŋ kwiyaŋ nâmgemti zemgeme kot am sesewat mkaen indamâtnak ma muluwaŋ mamanamaŋ notnaŋ mamnik? Keyet yaŋaŋ zemane nâne.” ");
INSERT INTO naf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yaŋkwesime Zisasiyaŋ dopmaŋ pigok diindoye, “Neŋ ŋeŋaŋ yaŋkwesisi ŋen yaŋkwesima in keyet dopmaŋ ŋeŋaŋ gilik zem nameŋgut neŋ kwiyaŋ nâmneme muluwaŋ mamanamaŋ mamiap keyet yaŋaŋ kegogak zema nâseip.” ");
INSERT INTO naf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Zemti pigok indayaŋkwesiye, “Zân tu zululut an egaŋ mulup mam ke Kawawaŋmagengatnan ma ammagengatnan timam ze zeme nâmbi?” ");
INSERT INTO naf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kegok indayaŋkwesime ekŋenaŋ ilinak zenâ zenâ mti zewien, “Nin ‘Zânaŋ mulup Kawawaŋaŋ saye,’ zesenup beme egaŋ zesem, ‘Âpme kwilekiyet in egat zetnaŋ ku manâmkiŋpeip?’ dindosem. ");
INSERT INTO naf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma nin, ‘Ammagengatnan timti mamm,’ zesenup beme naman am sambeyaŋ, ‘Egat nâme golaŋ zenze an mobotnaŋ temaŋ,’ manzeip keyepmti zet ke nâmti ndoseipmagen zemti kiŋgati peme tage.” ");
INSERT INTO naf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mti Zisasiyet zewien, “Nin egat yaŋaŋ ku nânup.” Zeme Zisasiyaŋ zeye, “In egat yaŋaŋ ku nâip keyepmti neŋ kwiyaŋ nâmneme mulup kapi mamiap keyet yaŋaŋ e kegogak ku diindosap.” ");
INSERT INTO naf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Zisasiyaŋ Zuda am ma ŋeŋaŋine ekŋengat bemzenze zet ŋen pigok diindoye, “An ŋenaŋ wain mulup mti kimbatnaŋ tokwat bembuluŋti peye. Mti wain katnaŋ misikme tuŋaŋ bembeyet nâmti mundumaŋ simenaŋ weyaŋ taimpemti mka teepmaŋ beŋan walatpemti an ŋenaŋ mka keyet dukŋan gwaen tati mulup ke ekdamuŋ mimiyet walage. Mulup ke mmâpme delaŋ zeme an notnaŋ ekŋengat belinan bemti an ekŋen keyaŋ damuŋ mme mânep keyetnaŋ mme kwapme butnaŋ ilinaŋgat timti butnaŋ ikŋaŋgat masam kwakwagat zemindemti ikŋaŋ msat ŋenŋaset mege. ");
INSERT INTO naf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yaŋ met maneti peme wain penaŋ mâtâtâgalen kanaŋ beme mulup toŋaŋaŋ mulup anaŋ ŋen zempeme mulup mammtemien ekŋenmagen meti katnaŋ notnaŋ timti met sasayelen nâmti zempeme mege. ");
INSERT INTO naf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mulup an keyaŋ mepataŋ zeme mulup damuŋ ekŋenaŋ atamti omba penaŋ witikne witikne peme weme zempeme gilik zem belak etaŋ mege. ");
INSERT INTO naf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mepme ekti mulup toŋaŋaŋ mulup an ŋen ewe zempeme mepataŋ zeme mulup an ekŋenaŋ atam tati tep pemaŋaŋ ŋokŋaŋ somti sakambuk samti ku mâpme belak gilik ze mege. ");
INSERT INTO naf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mepme ekti egaŋ ewe tusumti mulup an ŋen zempeme kopme ekŋenaŋ penaŋ kume gakiye. Gakime mulup toŋaŋaŋ mulup an sambe ewe zemindeme kopme notnaŋ penaŋ indome gakime notnaŋ belak indom peyak peyak mamtemien. ");
INSERT INTO naf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Indomwalet mme delaŋ zeme ikŋaŋgat nemuŋaŋ kwep etaŋ ek tikŋaŋ nâmpeme mamtan egaŋ igak tage. Tapme bam pigok nâmti nemuŋaŋ penaŋ ke zempeme mege, ‘Neŋ nanaŋgat nemun penaŋ kapi zempema mesemnen egat nâme mobotnaŋ beme zetnaŋ gawepuwep.’ ");
INSERT INTO naf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nâmti zempeme mepme mulup damuŋ mamtemien ekŋenaŋ nembaŋaŋ penaŋ ke kopme ekti ilinak zenâ zenâ mti zewien, ‘Maneti bam nemuŋaŋ penaŋ kapiyaŋ mulup kapi toŋaŋ beweyet kame nin kumann gakime mulup pi ningat bewe.’ ");
INSERT INTO naf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kegok zemti ekŋenaŋ atamti kume gakime sekŋaŋ mandamti paset zupman baen met peme weŋge. ");
INSERT INTO naf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Âpme mulup toŋaŋ keyaŋ bam koti am ekŋen ke zigok penaŋ mimindawe? Egaŋ koti an ekŋen ke indome gakimâpme naman mulup ke an notnaŋ ŋen indame ekŋenaŋ damuŋ mbep. ");
INSERT INTO naf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","In Kawawaŋgalen zet itnaŋaŋ zet ŋen kapigok kukuŋaŋ tazin ke in nâip, ‘Mka walalat ekŋenaŋ tepum ektalati belakŋan peme meweŋgeyaŋ tepum keyaŋ alak sutneteman peme kwatageyaŋ kaliŋaŋ penaŋ bemtazin. ");
INSERT INTO naf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Amobotnaŋ Kawawaŋaŋ ikŋaŋ ke mme sokbeyeyepmti nin ke ekmann dolakŋaŋ penaŋ bein.’” ");
INSERT INTO naf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zisasiyaŋ zet kegok diindome nâmti an ŋeŋaŋ bembe notnaŋ ekŋenaŋ, “Bemzenze zet ke ningat zein,” kegok nâmâtâti ŋeŋin zime atamti zemkukuyelen nâmbienaŋgut am sambeyaŋ zetnaŋ zeme tatnâmambien ekŋen keyet kiŋgati peme tage. ");
INSERT INTO naf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Âpme Palisi ŋeŋaŋ ma Elotgalen mulup an ŋeŋaŋ ekŋenaŋ mulup anŋin notnaŋ zemindeme Zisasi met tetipeme, “Egaŋ zet ŋen zemyuŋgume ekti met zemkusenup,” zemti zemindeme mebien. ");
INSERT INTO naf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Meti Zisasiyet zet kelakŋaŋ kapigok msawien, “An zikat indanda, nin nânuwen gâlen zedi ma mzikat indandandi esemteŋ penaŋ mamkawaŋ benik. Nin nânuwen am kwilinmak ma am kwilinpiŋ ekŋenmagen Kawawaŋgalen zezapat dolakŋaŋ sakam kwep mammkawaŋ bemindenik. Yaŋgut geŋ zet penaŋ Kawawaŋmagengatnaŋ amnaŋ mama mimi zigok tatagalen ke mammkawaŋ bemindenik. Keyepmti zemane nâne, ningalen zii zelaŋ zeinen nin mânep takis Loma gapman sasayelen ma yek?” ");
INSERT INTO naf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","“Nin ek takis mânep ŋep sawanup ma ku sawanup? Ze zemane nâne.” Zeme Zisasiyaŋ dâsukiŋinaŋgat yaŋaŋ nâmâtâti zeye, “Eneyet neŋ tatetineip? In mânep kasetnaŋ ŋen mkopme ekbi.” ");
INSERT INTO naf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Zeme ekŋenaŋ mânep kasetnaŋ ŋen mkosame ekti indayaŋkwesiye, “Mânep palen an zimosetnaŋ ma kwitnaŋ kwiyelen kumpepeŋaŋ?” Kegok indayaŋkwesime ekŋenaŋ zewien, “Loma gapmangalen amobotnaŋ kwitnaŋ Sisa egat weŋaŋmak kwitnaŋaŋ tazin.” ");
INSERT INTO naf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ekŋenaŋ kegok zeme Zisasiyaŋ zeye, “Ele, kwitnaŋ kwitnaŋ amobotnaŋ Sisayet weŋaŋ tatatnaŋ beme ek sawep ma am in Kawawaŋ ikŋaŋgalen bet muluwaŋ keyepmti in ikŋaŋgat zapat mait.” Kegok diindome ekŋenaŋ zetnaŋgat nâmtemtem mpemti peme tapme belak mepmâbien. ");
INSERT INTO naf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Âpme Sadusi ekŋenaŋ am gakikiengatnan wawat ku tazin manzemtemien keyepmti an ekŋen keyaŋ Zisasmagen koti yaŋkwesiwien, “An zikat indanda, Mosesiyaŋ zii zelen zet meluwaŋ kapigok minndaye, ‘An ŋenaŋ imbi wati nembaŋaŋ ŋen sokbembepiŋ mme an keyaŋ gakiwe beme meniŋaŋaŋ imbi kwambetnaŋ ke wati datnaŋgat mundumaŋ alikŋaŋ ŋen mme sokbewe.’ ");
INSERT INTO naf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Âpme an yaŋkogili 7 kegok mamtemien. Maneti yuŋinaŋ imbi ŋeŋaŋ wage. Wat maneti nembaŋapiŋ gakiye. ");
INSERT INTO naf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Gakime muŋaŋaŋ toti imbi keyegak wati nembaŋapiŋ maneti gakiye. Gakime gwalaŋ kegogak wage. ");
INSERT INTO naf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mti an 7 ekŋen piwan imbi kwep ke wati nembaŋinpiŋ belak etaŋ gakimâbien. Yaŋ maneti ekŋengalen imbi kwambet keyaŋ kegogak gakiye. ");
INSERT INTO naf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","An yaŋkwep 7 ekŋenaŋ imbi kwep ke wabiengapmti gakikiengatnan wawat kanen imbi ke an kwiyet imbiŋaŋ bewe?” ");
INSERT INTO naf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zeme Zisasiyaŋ pigok diindoye, “In Kawawaŋgalen winde ma egalen zetnaŋ ku weyaŋ manâmâtâlipgapmti zet ke zemyuŋguip. ");
INSERT INTO naf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","An ma imbi gakikiengatnan gilik zemwabewen awembiŋ mama ewe ku mambep. Belak Kawawaŋgalen ensel kululuŋen talip keboŋ etaŋ bemti mambep. ");
INSERT INTO naf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","In gakikiengatnan wawat ku tazin manzeip âpme Mosesiyaŋ didik kunduman tep tazime ke ekti tapme Kawawaŋaŋ zapat dundume nâmti egaŋ zapat meluwaŋ mge ke maiŋti manâmâtâlip. Kawawaŋaŋ Mosesiyet kapigok zeye, ‘Neŋ alak kapiyet Abalaamgalen Kawawaŋ ma Aisakgalen Kawawaŋ ma Zekopgalen Kawawaŋ.’ ");
INSERT INTO naf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Keyepmti neŋ ingat pigok zema nâit. Kawawaŋaŋ zet ke yaŋaŋ kapigogapmti zeye, ‘Ek am gaki meti mama kanzizit mamaip ekŋengalen Kawawaŋ wa ek am gakiki katikŋaŋ maŋgakip ekŋengalen Kawawaŋ yek. In zet ke manâmyuŋguip!’” ");
INSERT INTO naf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Âpme zii zet zikat indanda an ŋenaŋ keyak tati ekme Zisasiyaŋ Sadusi ekŋenmak zenâ zenâ mti yaŋkwesisiŋinaŋgat yaŋaŋ dolakŋaŋ tagilik zemindame egaŋ nâmti Zisasmagen meti yaŋkwesiye, “Zii zet ziboŋaŋ notnaŋ sambe bee silim indemti ŋotekŋaŋ penaŋ bein?” ");
INSERT INTO naf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yaŋkwesime Zisasiyaŋ dopmaŋ pigok gilik zem zeye, “Zii zet sambeyet ŋotekŋaŋ kwep kapiyaŋ bein, ‘Islael am in nâit, Amobotnaŋ ek kwewetaŋaŋ ningalen Kawawaŋŋ bein. ");
INSERT INTO naf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Keyepmti in Kawawaŋgat gogot mpemti keŋinmak weŋin ma ŋoktikŋinmak windeŋin bee kataŋ egat ketalasim samâbep.’ ");
INSERT INTO naf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Zii zet keyet kandaŋan zet notnaŋ ŋen kapigok tazin, ‘Gitaŋgat maŋgembein keyet kataŋ am notnaŋ ekŋengat gogot mbanik.’ Zii zet ŋenaŋ eget zut kapi ku sebemidein.” ");
INSERT INTO naf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Zeme zii zet zikat indanda an keyaŋ nâmti Zisasiyet pigok zeye, “An zikat indanda, geŋ ŋep penaŋ zenik, ‘Amobotnaŋ e Kawawaŋ kwewetaŋ egat baman ŋen ewe ku tazin. ");
INSERT INTO naf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Keyepmti am ŋenaŋ Kawawaŋgat gogot mpemti keŋaŋmak ŋoktikŋaŋ ma windeŋaŋ egat etaŋ sawe.’ Mti ikŋaŋgat manâin keyet kataŋ am notnaŋ ekŋengat keŋaŋ bewe beme sâpe sâpe bumbu ma Kawawaŋgat taolet bembe set ke sebem pemâbe.” ");
INSERT INTO naf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zii zet zikat indanda an keyaŋ yaŋaŋ dolakŋaŋ penaŋ zeme nâmti Zisasiyaŋ zeye, “Geŋ ilak Kawawaŋgalen zemâtâtâtgat katnanen mama ke titiyelen sokŋanik penaŋ kodik.” Zet esemteŋ kegok zemti selin bekekme ekŋenaŋ yaŋkwesisi ŋen ewe yaŋkwesisiyet olapme beme peme tapme mebien. ");
INSERT INTO naf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zisasiyaŋ Zelusalem sesewat mka temaŋ ke tati zet zapat tadiindoneti ekŋen kapigok indayaŋkwesiye, “Ingalen zii zet zikat indanda an ekŋenaŋ Kilais ek Dewitgat iŋsokŋaŋaŋ bam kobe manzeiwaŋgut ");
INSERT INTO naf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","eweŋan Kawawaŋgalen Emetak Teŋaŋ zet kapi amobotnaŋ Dewit zem same Dewilaŋ pigok zemkawaŋ beye, ‘Amobotnaŋ Kawawaŋaŋ nâgât Amobotnaŋŋ Kilaisiyet pigok zeye, “Geŋ Amobotnaŋgat kot betn penaneset totati windendi temaŋ timti tabanik. Âpme neŋ gapmukulem mma geŋ kasandine sambe ekŋen windeŋin mtoindewanik.”’ ");
INSERT INTO naf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewilaŋ ikŋaŋ Kilaisiyet ‘Amobotnaŋŋ’ zeye keyepmti zigoset Kilaisiyaŋ naman Dewitgat iŋsokŋaŋ bein etaŋ? Ke penaŋ neŋ Dewitgat alikŋaŋmagen sokbewan yaŋgut neŋ Kawawaŋaŋgat Nemuŋaŋ penaŋ kogogapm Dewilaŋ Kawawaŋgalen Zet Itnaŋaŋen kuyeen ke nâgât ‘Amobotnaŋŋ,’ zeye eneyet neŋ Kawawaŋaŋ zemnemetot amgat yomgat dopmaŋ gakikiyet toban.” Zisasiyaŋ kok zeme am sambe penaŋ tabienaŋ zetnaŋ nâmtikŋaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Âpme Zisasiyaŋ am sambe tazemzikat indammetneti pigok zeye, “In an zii zet zikat indanda ekŋengalen ŋoktik mgasik ke ku mâti mbep. Ekŋenaŋ melakandu teepmaŋ gwaen biminaŋgatnan baen selinan tot lapit mepme mamti ilinaŋgat nâme mobotnaŋ beme selen ma tambaŋgumen mame amnaŋ sekŋin moindendeyet etaŋ manâip. ");
INSERT INTO naf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ekŋenaŋ sesewat mkaen amobotnaŋgalen mundumen ŋeŋaŋ gwaenen etaŋ mametalip. Ma ondedak temanen ekŋenaŋ meu ma soŋgom temaŋ indame niniyelen etaŋ manâip. ");
INSERT INTO naf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ekŋenaŋ imbi kwambetgalen mânep milawat ma mkaŋin mee pi menzem timti indamâpme kileŋ mepme dundundu teepmaŋaŋ myuŋguŋguŋin beke mamim atanepeme amnaŋ ŋep ku eegalen mambein. Am ekŋen keboŋ ke maneti kan delaŋ zenze kanen Kawawaŋaŋ zem indomti tosaŋin bekanaŋ penaŋ mmoti indawe!” ");
INSERT INTO naf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Zisasiyaŋ sesewat mka temanen mânep pelep keyet sokŋanik tati ekme am sambeyaŋ mânep pelewen tabem mambien. Am sambe ekŋenaŋ mânewin temaŋ pelewen tapeme towepme ");
INSERT INTO naf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","imbi kwambet bekopsat ŋenaŋ koti mânep ŋamaŋ isisikŋaŋ zut piwan peme pelewen towege. ");
INSERT INTO naf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kegok mme Zisasiyaŋ ekti nembaŋaneyet zeme kopme pigok diindoye, “An ekŋen, neŋ penaŋ sukwep zema nâit. Imbi kwambet bekopsat kapiyaŋ mânep pelewen bep keyaŋ an imbi sambe notnaŋaŋ tewalaŋ beyo bee sebemindein. ");
INSERT INTO naf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Am mânep milawatmak notnaŋ ekŋenaŋ mânewin omba penaŋ tazinaŋgut butnaŋ bugan timti kot pelewen time towelep. Yaŋgut imbi kwambet bekopsat keyaŋ mânepmaŋ bugan tazin elak kopeme pelewen towepme delaŋ zein mkaŋanen daenen butnaŋ ŋen ewe ku tasain, yek penaŋ.” ");
INSERT INTO naf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Zisasmak nembaŋane ekŋenaŋ sesewat mka temanengatnan toti mepmambe Zisasiyet nembaŋaŋ ŋenaŋ sesewat mka temaŋ beke ektemtem mti zeye, “Wenaŋe naŋeye, an zikat indanda, gwa ekbak, nanzaŋ yaŋan tatat nemboŋ weyaŋti mka dolakŋaŋ walapepeŋaŋ gwa ekbak!” ");
INSERT INTO naf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zeme Zisasiyaŋ dopmaŋ pigok gilik zem saye, “Geŋ nanzaŋaŋ mka temaŋ walalatnaŋ kapi alak ego ego mnik. Yaŋ maneti bamgat nanzaŋaŋ mundumin talip keyet kataŋ ku tabep. Kasa ekŋenaŋ kokume epeemti nanzaŋ igak kwep kwep lala bubuk mekobep.” ");
INSERT INTO naf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Kok zemti Zelusalem mka peme tapme meti Olip kalaŋan mosât mobien. Motati Pitamak Zems Zânmak Endulu ekŋenaŋ ilinak Zisasmagen meti zikalin Zelusalem mkaeset ekme topme Zisasiyet yaŋkwesiwien, “Sesewat mka temanen daenen tati zet zenak ke kan zukŋan penaŋ sokbewe. Ma keyaŋ sokbesâgât tapmme menok zigogaŋ ŋeŋaŋ beme ekti nâmbanup kwitnaŋ kwitnaŋ gâgâegaŋ sokbembeyet zeye walak kapi sokbesâpm zewanup.” ");
INSERT INTO naf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Zeme Zisasiyaŋ pigok diindoye, “In weyaŋ eksem mambep. Mineti am notnaŋaŋ tetimindemti indatetimti mebepgat. ");
INSERT INTO naf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","An notnaŋaŋ Zisasiyet kwitnaŋ belak mimyambumti kot an imbi notnaŋ tetimindemti zewep, ‘Neŋ Kilaisiyaŋ kolap!’ ");
INSERT INTO naf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma msat butnan butnan kasa tawapmepme keyet buŋam zapatnaŋ nâwep ma kasa kwisak wekumepme keyet yayaŋ palen ku tabep. Kawawaŋaŋ kwitnaŋ kwitnaŋ keboŋaŋ ŋeŋaŋ sokbembeyet zeye yaŋgut msat kululuŋ kumasesegalen kan sakwep ku kobe. ");
INSERT INTO naf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Am maŋge kwewaŋ epeemti dopmaŋ mekum kokum mbep. Ma msat temanen amobotnaŋ zulaŋ wati âwalup. Ma msat kataŋ mâkinaŋ temaŋ mbe ma msat sambe meuyet kambeŋ temaŋ sokbemmebe. Kwitnaŋ kwitnaŋ ke imbiyaŋ nemba sokbesâpmme yaŋbemti sindem manâip keyet kataŋ sokbemmâbe. ");
INSERT INTO naf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ekŋenaŋ belak kileŋ indatimti amobotnaŋ ekŋengalen ondedagen meti zet muluwen indewep ma Zuda ekŋengalen sesewat mkaen indatim moti sindiwaŋ indawitikbep keyet eksemambep. Ekŋenaŋ kogok mimindamti gapmangalen am ŋeŋaŋ notnaŋ ma amobotnaŋ temaŋ ekŋengat zikalinan met onzemindeme tati nâgât yaŋŋ zemâtâtât mulup mbep. ");
INSERT INTO naf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kogok mme msat kataŋ Kawawaŋgalen Zet Zapat Dolakŋaŋaŋ ŋeŋaŋ am ilindiŋ bemindemeŋgut keyet sakŋan gwaenen msat kululuŋ asekbe. ");
INSERT INTO naf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Keyepmti am notnaŋ ekŋenaŋ indapmeti zem indomti mka katikŋan indesât mbep. Kan keyet in zet muluwen motati, ‘Pe zet zigok zesenup,’ zemti yayaŋ temaŋ penaŋ ku mbep. Kan keyet Kawawaŋgalen Emetak Teŋaŋ zet keŋinanen bemindeme zewep. ");
INSERT INTO naf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Âpme datnaŋaŋ meniŋaŋ kume gakikiyet mezemdelaŋ zewep. Ma biwinaŋ nembaŋane kogogak indome gakikiyet mezemdelaŋ zemindewep. Ma nemba ekŋenaŋ mambiwine kasa mimindemti indome gakikiyet zemindowep. ");
INSERT INTO naf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","In nâgât manâmkiŋpeipgapmti amnaŋ ingat nâme kaŋgaŋaŋ etaŋ bewe. Yaŋgut am ŋenaŋ nâmkiŋpepeŋaŋ katikŋaŋ bemtapmetneti gakiwe beme kan delaŋ zenzeŋaŋ Kawawaŋaŋ an ke mama kanzizit sawe. ");
INSERT INTO naf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Golaŋ zenze an Danielaŋ meluwaŋ kapigok mge, In zet kapi maiŋti weyaŋ nâit, ‘Kwileki ŋen mamaŋaŋmak ma kiŋgagatnaŋmagaŋ Zuda am ekŋengalen sesewat mkaen ku moti tatagalenaŋgut egaŋ mot ke tati indawalebeyet,’ in ke ekti am Zudia msalen mambewaŋ keyegak tapeŋ tati kunzuŋti kalaŋan mowebep. ");
INSERT INTO naf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Âpme am ŋenaŋ mka solonan tatneti gilik zem mka keŋan moti milawatnaŋ tiyap zemti tim yape yape mti kan ku walabe msalen keyegak tati kunzuŋ mebe. ");
INSERT INTO naf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma ŋenaŋ muluwen maneti gilik zem tâgâ melakanduŋaŋ msâgât mkaŋan ku mebe keyegak tapeŋ tati kunzuŋbe. ");
INSERT INTO naf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Imbi keŋmak ma imbi nembaŋin ewe okakŋaŋ nam manip bekakane ekŋen keboŋaŋ zigok penaŋ mbewe. ");
INSERT INTO naf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","In kwitnaŋ kwitnaŋ nukŋaŋbeŋ ke map tâgâ keŋan ku indandayet nâmti Kawawaŋgat dundume egaŋ mteteyet sokbembeyet nâmindewe. ");
INSERT INTO naf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kan keyet amnaŋ sek sindem tisâiwen keboŋ ke eweŋan Kawawaŋaŋ yaŋbemti kwitnaŋ kwitnaŋ msokbeye ma tuŋgupman mamkwati alak tatnup ma bam mamti masâpmnup keyet keŋaŋ ŋen ku sokbeye ma ku sokbewe. ");
INSERT INTO naf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Amobotnaŋaŋ kan ke ku mme pemkwepmaŋ benagen am ŋenaŋ alik ku manak. Yaŋgut egaŋ am ikŋaŋgat indaombemindeye ekŋengat nâmti nukŋaŋ temaŋ keyaŋ kan teepmaŋ ku sokbembeyet nâmti kan ke mme pemkwepmaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Âpme kan keyet am notnaŋaŋ tetimindemti zewep, ‘Kilais pien tazingat koegit!’ Ma ‘Kilais daen tazingat meegit!’ Zeme zelin gawepumti ku nâmkiŋpemindewep. ");
INSERT INTO naf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sadaŋaŋ am sambe winde indame ekŋenaŋ wati Kilais ma Kawawaŋgalen zapat zem zemsokbembe an ekŋengat kwilinan mimyambumti menok sepem igak igak mti Kawawaŋgalen am keŋin mme yuŋgum mâbe. Yaŋ ekŋenaŋ Kawawaŋgalen am ikŋaŋ ombemindeye ekŋengat keŋin myuŋguŋguyelen nâmbep beme ŋep mbep. ");
INSERT INTO naf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kwitnaŋ kwitnaŋ ke ewe sokbembepiŋ tapme neŋ eweŋanak yayaŋ mti diindoyapgapmti weyaŋ eksemti mambep. ");
INSERT INTO naf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sindem kan keyet kwati delaŋ zeme sakŋan gwaen kasup zikatnaŋ sopsop sime eyoŋga busatnaŋ yek bewe. ");
INSERT INTO naf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma wenzim notnaŋ kululuŋengatnan tuluk talak zemti topme enzuŋaŋ sokbeme wenzim notnaŋ tabep ekŋenaŋ ulugâlâk bemtemebep. ");
INSERT INTO naf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kogok mme neŋ Angat Nemuŋaŋ neŋ mgulumbuk palen tati windennbeŋ penaŋ ma saŋga soŋganaŋ uluŋ elaŋ tapmme kopma in nikbep. ");
INSERT INTO naf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mti keyegak neŋ ensel kululuŋengatnan zemindema, ‘Ekŋenaŋ msat butnan butnan ma msat tuŋgupman mekoti Kawawaŋaŋ amŋane ombemindendeŋaŋ ekŋen indaakume maŋge kwep kwao tabep’. ");
INSERT INTO naf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","In balam balam tep ke ekti nâmâtâlit balam balam tep keyet katnaŋaŋ dolakŋaŋ penaŋ sokbeme ekti manzenup, ‘Olak mtete kan sokŋan bein.’ ");
INSERT INTO naf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sepem kegogak nukŋaŋ sambe beke sokbeme ekti nâmbep, ‘Olak Zisas kokotnaŋgalen kan ilak sokŋan bein.’ ");
INSERT INTO naf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Neŋ penaŋ sukwep zema nâit, am in talip kapi notnaŋaŋ ewe gakikipiŋ tati ekme kwitnaŋ kwitnaŋ zeyap kapi sokbeme ekbep. ");
INSERT INTO naf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Msat ma kululuŋ eget kapi asekbalup yaŋgut nâlen zetn ku delaŋ pewe yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Neŋ kokotnaŋgalen kan ke kasup ma kan tuŋgupmaŋ desetgat kobap ke msalengatnaŋ am ŋenaŋ ku nâin penaŋ. Ma kululuŋen gwaen Kawawaŋgalen ensel ekŋenaŋ kan keyet penaŋ kobe ke ku nâip ma nenn ikŋaŋgat Nemuŋaŋ penaŋaŋgut zukŋan zemneme kobap keyelen kan ke ku nâyap. Bipm Kawawaŋaŋ igak etaŋ nâin. ");
INSERT INTO naf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kan zukŋan kobap ke ku nâipgapmti nâpeŋ nâpeŋ kelem mti mambep. ");
INSERT INTO naf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kan ke amobotnaŋ ŋenaŋ mkaŋaŋ peme tapme msat ŋenen mesâti an mulupmaŋ weyaŋdamuŋ mimiyet zemâtâtât mulup mpemti sekekek damuŋ kaliŋaŋ mimiyet zempemti pigok dunduye, ‘Neŋ kopma set kwalet newanigat nâpeŋ nâpeŋ matapmambanik.’ ");
INSERT INTO naf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sepem kegogak in weyaŋ eksemti mamambep. Neŋ gasiyet ma tambusutnan ma msat msasât tapmme ma tambuŋan kobap ke kan esemteŋ penaŋ ku nâipgapmti in nâpeŋ nâpeŋ nâgât damuŋ matapmambep. ");
INSERT INTO naf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","37","Mineti in nânâpiŋ meluk tawenepeme neŋ koti indikma endilipewepmagengat in ma am sambe zet kapi nâmti nâpeŋ nâpeŋak mamambep.” ");
INSERT INTO naf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zuda amgalen Aŋgalalaŋ Kendo Nupmamaŋ Yispiŋ Niniyelen Kendo kasup zut delaŋ zemeŋgut tatagalen tapme sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda ekŋenaŋ Zisas buzakset atamti betnaŋ zamti kume gakikiyelen zemkabewien. ");
INSERT INTO naf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yaŋgut naman pigok zemti kiŋgabien, “Mineti nin kendo kanen pigogat msenup beme amnaŋ kasa kileŋ kuseipmagengapmti pemann talak.” Zemti peme tage. ");
INSERT INTO naf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zisasiyaŋ Betani mkaen Saimon itnaŋaŋ an liŋgit satmak mamtanaŋ weyaŋpeye egalen mkaen meu nini mundumen totapme imbi ŋenaŋ wet kelakŋaŋ sesikŋaŋ dolakŋaŋ kwitnaŋ nalat ke okop nanzaŋaŋ weyayaŋaŋ keyet keŋan tapme mkoti butnaŋ ŋilikŋaŋ gwaen kume etume Zisasiyet ŋokŋan mulapme toge. Wet ke tosaŋaŋ mobotnaŋ penaŋ. ");
INSERT INTO naf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kegok mme am notnaŋ ekŋenaŋ ekme ŋep kumbeme ilinak zenâ zenâ mti zewien, “Pi kwilekiyet penaŋ wet tosaŋaŋ mobotnaŋ penaŋ pi belak kileŋ walezin? ");
INSERT INTO naf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Egaŋ wet kapi nin ndame mmet bemann tosaŋaŋ 300 kina mee kegok ndame am bekopsat ekŋen kalaŋ indawanek ze ŋep benak.” Zemti imbi keyet nâme bekanaŋ beye. ");
INSERT INTO naf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Âpme Zisasiyaŋ nâmti pigok diindoye, “Imbi kapiyaŋ neŋmagen mulup dolakŋaŋ mipgat in egat zet ŋen zenzepiŋ belak peme talak. ");
INSERT INTO naf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Am bekopsat ekŋen pi inmak kwesiŋ kapi mamambepgapmti in kwileki ŋen miindasâgât nâmti ŋep miindawep. Âpme neŋ inmak msalen kapi kwesiŋ ewe ku mambap. ");
INSERT INTO naf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Belatnik bugan bukapi tapmoti gakima am sumen nabewepgapmti egaŋ ikŋaŋgat keŋan galak eweŋanak wet sesikŋaŋ dolakŋaŋaŋ mulati zulutnein. ");
INSERT INTO naf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Neŋ penaŋ sukwep zema nâit. Am msat kataŋ Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ zemebep kataŋ imbi kapiyaŋ kwitnaŋ kwitnaŋ mnain keyet zapatnaŋ eyo zeme manâmambep.” ");
INSERT INTO naf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zisasiyet nembaŋane 12 ekŋenmagengatnaŋ nemba ŋen Zudas Iskaliot mkaengatnan egaŋ sâpe sâpe bumbu an ŋeŋaŋ ekŋenmagen meti Zisas zemsokbemindandayet zemkaliŋ bemindeye. ");
INSERT INTO naf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kegok zeme sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ nâmti oloŋen mti dopmaŋ mânep sasayet zetik mpeme Zudayaŋ set ŋen aikti Zisas zemsokbemindame atatayet mulupmaŋ mge. ");
INSERT INTO naf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nupmamaŋ yispiŋ niniyelen kendo ke kan sokŋanik beme am ekŋenaŋ sipsip makumbumtemien kan ke beyeyepm nembaŋaneyaŋ Zisasiyet yaŋkwesiwien, “Nin mkan den meti Aŋgalalaŋ Kendo tati tu meu niniyet weyaŋ besenup?” ");
INSERT INTO naf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yaŋkwesime Zisasiyaŋ nembaŋane zut zemidemti zeye, “It Zelusalem mka teman moti ekmalu an ŋenaŋ tu menzim belen mmepme aikti keyegak baman mâti mepmalu ");
INSERT INTO naf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","egaŋ mka ŋengat mowepme ekti keyegak mâpmoti mka keyet toŋaŋgat zeselup, ‘Amobotnaŋaŋ pigok zemndeme kolup. Neŋ nembannemak Aŋgalalaŋ Kendoyelen meu mka keŋaŋ de tati nsenup?’ ");
INSERT INTO naf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Zemalu egaŋ idati mka keŋan temaŋ tedukŋan gwaenen kwitnaŋ kwitnaŋ eweŋanak weyaŋ bembeŋaŋ ke zikat idame it meu ke bumbemalu kot nsenup.” ");
INSERT INTO naf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Zisasiyaŋ kegok diidome egelaŋ meti kwitnaŋ kwitnaŋ zeye keyet kataŋ penaŋ aikti Aŋgalalaŋ Kendoyelen meu niniyet weyaŋ tabumbemambun. ");
INSERT INTO naf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Âpme msat tambusât tapmme Zisasiyaŋ nembaŋane 10 indatimti mka keyet keŋan mopmâbien. ");
INSERT INTO naf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Motati meu nini mundumen totati meu nimambe Zisasiyaŋ pigok zeye, “Neŋ penaŋ sukwep penaŋ zema nâit, inmagengatnan nemba ŋenaŋ meu neŋmak pelep kwep tatnilup egaŋ zemnome kasa ekŋengat belinan bemneme ekŋenaŋ nome gakiwap.” ");
INSERT INTO naf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Zeme nembaŋane ekŋenaŋ nâme nukŋaŋ beme Zisasiyet igak kwep kwep pigok yaŋkwesiwien, “Mneti nâgât mene tazemasenigat zema nâmbi?” ");
INSERT INTO naf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kegok yaŋkwesime egaŋ pigok diindoye, “Nemba neŋmak nsakwep nupmamaŋ tu batien pemalu towepme mkwat nselup an keyet nâmti tazeyap. ");
INSERT INTO naf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kawawaŋgalen Zet Itnaŋanen neŋ Angat Nemuŋaŋaŋ neŋ zemâtâtneneŋaŋnok meti gakikiyelen zemneneŋaŋ. Wakae, neŋ zemnowe an ke sindem omba penaŋ tiwe. An ke mamaŋaŋ ku ambetnak ze dolakŋaŋ penaŋ benak.” ");
INSERT INTO naf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Zemti Zisasiyaŋ nupmamaŋ ŋen mti Kawawaŋgat wisikŋ zemutumti indamti zeye, “In mti nit kapi nanaŋgat sek sesumban.” ");
INSERT INTO naf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nime delaŋ zeme wain okop tageen ke mti Kawawaŋgat wisikŋ zemti kegogak indame nimbien. ");
INSERT INTO naf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nime zeye, “Kapi tâtâ alakŋaŋ ammak Kawawaŋmak sipmnaŋ tusum indeyap. Ke am sambe ekŋen yomengatnan indatim kwakwagat nâmti kegok mbap.” ");
INSERT INTO naf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kegok zemti zeye, “Neŋ penaŋ sukwep zema nâit, neŋ wain tu ke ninipiŋ maneti bamgat kululuŋen gwaen mama katikŋanen tati wain niyap kaboŋ yek; wain alakŋaŋ nimbap.” ");
INSERT INTO naf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Zeme delaŋ zeme keyegak tapeŋ tati sesewat silik kume delaŋ zeme mkaengatnan toti tambuyelak Olip Kalaŋan mowebien. ");
INSERT INTO naf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Motati Zisasiyaŋ nembaŋane pigok diindoye, “In kasa kuku an ekŋenaŋ kopme ekŋengat kiŋgati nemkunzuŋ mekopme nenak etaŋ teŋtewat tasap. Kawawaŋgalen Zet Itnaŋanen Kawawaŋaŋ ikŋaŋ pigok zeye, ‘Neŋ sipsip damuŋ kuma gakime sipsip ekŋenaŋ kileŋ lala bubuk kunzuŋ mekobep.’ ");
INSERT INTO naf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yaŋgut bam Kawawaŋaŋ neŋ mme gakikiengatnan gilik zem watiŋgut Galili msalen mepma in bam napmâti kobep.” ");
INSERT INTO naf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Zeme Pitayaŋ pigok zeye, “Nemba notnaŋaŋ bamkumgemeseip yaŋgut neŋ ŋep ku bamkumgemesap.” ");
INSERT INTO naf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Zeme Zisasiyaŋ dopmaŋ pigok gilik zem saye, “Alak tambumbu kapiyet sakokolok apmaŋ kwitnaŋ sakwep kumti sek zut ewe kukupiŋ tapme geŋ nâgât sek tuk yaŋnesenik.” ");
INSERT INTO naf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Zeme Pitayaŋ zekaŋkaŋ mti zeye, “Neŋ nome gakikiyelen mseiwaŋgut neŋ geŋ ku yaŋgesap penaŋ.” Zeme nemba notnaŋ sambe ekŋenaŋ zet sepemaŋ kwep kegogak zemâbien. ");
INSERT INTO naf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Zemti ilinsakwep Gesemane muluwen mebien. Mepataŋ zemti Zisasiyaŋ nembaŋaneyet zeye, “In kapi totapme neŋ nenak mulup butnan daen metati dundumti kosap.” ");
INSERT INTO naf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Zemindemti Zisasiyaŋ nembaŋane tuk Pitamak Zems ma Zân indatimti mege. Âpme yaŋbemti nukŋaŋ sambe penaŋ keyet nâmti keŋaŋ sindem igagaŋ penaŋ beme sek monzalamaŋ ululuŋ pem toge. ");
INSERT INTO naf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mti nembaŋane tuk ekŋengat zeye, “Neŋ keŋŋ sindem beme gakikiyelenok tatnâyapgat in kapi kaik tapmaseip.” ");
INSERT INTO naf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kegok zemti belaknik bugan meti keŋaŋ nukŋaŋ beme msalen ŋenzimosetnaset palak palak tokutumwemti pigok dunduye, “Bien, geŋ set eleŋ belaŋ ŋen aiknanayelen nâsenik beme aiknamane sindem temaŋ timti ku gakisap.” ");
INSERT INTO naf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kegok dundumti zeye, “Bien, Bien, geŋ nâmane sindem temaŋ kapiyaŋ dukŋnan ku mosem. Yaŋgut nâlen zet zeap ke mâti msenik yek; giti nâmtadik keyet kataŋ mâsenik.” ");
INSERT INTO naf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kegok dundum delaŋ zemti nembaŋane tuk ekŋenmagen gilik zem koti indikme meluk taweme Saimon Pitayet zeye, “Pita, geŋ ewe kegogak meluk tawenik? Kan belaknik bugan kaik tati otnânâ mulup bugan ku mbek? ");
INSERT INTO naf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","In mama mimi bekananen ku toindondoyet nâmti eksem kaik tati dundundu mulup mit. Keŋinaŋ nâgât kembeŋ nâyo yaŋgut sekŋinaŋ nukŋaŋ bein.” ");
INSERT INTO naf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Zemti ewe gilik zem met zet Bipmaŋgat dunduye kegogak ewe zemdunduye. ");
INSERT INTO naf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dundum delaŋ zemti koindikme zikalin ewe melugaŋ kwasime taweme keyet zeme ekŋenaŋ zet dopmaŋ gilik zem sasayet timabien. ");
INSERT INTO naf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Âpme met sek tuk ewe dundumti gilik zem koindikme ewe muluk taweme zeye, “In ewe tagomti meluk tawep? Angat Nemuŋaŋ neŋ zemnomti am yomtoŋ ekŋengalen belen mobogalen kann ilak sokŋanik bein. ");
INSERT INTO naf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wapme an neŋ zemsokbemneneyelen walek kozingat meti ekne!” ");
INSERT INTO naf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zisasiyaŋ nembaŋaneyet zapat kegok diindomambe tapme nemba 12 ekŋengat tuŋguwinangatnaŋ ŋen Zudasiyaŋ piwan kasa kuku an ŋeŋaŋ bemindeme kobien. Zudasiyaŋ sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda an ma sesewat mka temaŋgalen an damuŋ notnaŋ ekŋenaŋ kasa kuku an notnaŋ ekmak zemindeme wanam kukŋaŋmak ma tepemaŋ mee pi belen belen timti kopmâbien. ");
INSERT INTO naf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Selen kopmambe Zudasiyaŋ pigok zemâtâtindeye, “Neŋ meti an mkumpema in ekti keyegak weyaŋ atamti bembuluŋ wapmeseip.” ");
INSERT INTO naf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zemindatim koti keyegak Zisasmagen meti “Amobotnaŋŋ” zemti ambet mkumpeye. ");
INSERT INTO naf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kegok mme ekti kasa ekŋenaŋ met betnanen atam kitik mti tabien. ");
INSERT INTO naf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Âpme Zisasiyet nembaŋane ekŋenmagengatnaŋ ŋenaŋ ŋeŋaŋ zime wanam kukŋaŋmak pitakŋanengatnan mandapeme kwapme sâpe sâpe bumbu an ŋeŋaŋgat mulup anaŋ wakŋaŋ nembet sâmpeye. ");
INSERT INTO naf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Âpme Zisasiyaŋ pigok diindoye, “In nâgât nâme kambu titi an bema wanam kukŋaŋmak ma tepemaŋ mee pi timti kot natam kitik mtalip? ");
INSERT INTO naf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Neŋ kan kataŋ inmak sosok sesewat mka temanen an imbi Zet Zapat Dolakŋaŋ diindomti mamtemanen ke in ku natawien. Yaŋgut alak pi Kawawaŋgalen Zet Itnaŋan nâgât meluwaŋ mimiŋaŋ keyet kataŋ sokbein.” ");
INSERT INTO naf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Zeme nembaŋane sambe ekŋenaŋ kiŋgati pemkuŋkunzuŋmâpme delaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Notnaŋaŋ kuŋkunzuŋ mâpme Zisas nembaŋane ekŋenmagengatnan nemba zomolim ŋen saŋgum kwewetaŋaŋ kaik mamaŋgeyaŋ atanup zem saŋgumaŋ kwep mâtât mtapme belak talak kunzuŋ mege. ");
INSERT INTO naf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sâpe sâpe bumbu an ŋeŋaŋ ekŋen ma zii zet zikat indanda an ma damuŋ notnaŋ ekŋenaŋ sâpe sâpe bumbu an ŋeŋaŋin temaŋ egalen mkaen met ondek tati Zisas taekme Zisas zem kukuyet nâmti ekmagen wati ");
INSERT INTO naf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","tapmepme Pitayaŋ baman mâti kiŋgapeŋ beŋan daen igak takopmaŋge. Koti ekŋenaŋ zem kuku mka kimbalen toti mka keŋan mowepme Pitayaŋ kegogak kimbat keŋan toweti zupman baen sâpe sâpe bumbu an sambe ekŋengat ŋeŋaŋin egalen mulup anaŋ tep bum kâtapmambienen toti tep kâti tapmaŋge. ");
INSERT INTO naf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Âpme ekŋen sâpe sâpe bumbu an ŋeŋaŋ ma amobotnaŋ sambe ekŋenaŋ ondekti Zisasiyet nukŋaŋaŋ ŋen aikti kume gakikiyet zemtimapme beye. ");
INSERT INTO naf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Am sambe ekŋenaŋ Zisas zemkukuyelen zet dâsuki notnaŋ bemzem zewienaŋgut zelinaŋ sepem igak igak bemâge. ");
INSERT INTO naf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Âpme an notnaŋaŋ ondedagen tabienaŋ wati Zisasiyaŋ zet zeme nâmbien ke mti pigok zewien, “Nin sek ŋen tatnâmann Zisasiyaŋ kapigok zeye, ‘Neŋ sesewat mka temaŋ amnaŋ walabien bekapi ŋep asekti kasup tugat keŋan neŋ alakŋaŋ ŋen walabap.’” ");
INSERT INTO naf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Zet notnaŋ kogok zewien keyaŋ zelin sepemaŋ kwewagak ku bemâge. ");
INSERT INTO naf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mme sâpe sâpe bumbu an ŋeŋaŋ ekŋengat ŋeŋaŋinaŋ wat zimoselinan tati Zisasiyet pigok yaŋkwesiye, “Ekŋenaŋ gâgât zet sambe tabem zep; kapi geŋ dopmaŋ ŋen gilik zem indandayelen ŋen nânik ma yek?” ");
INSERT INTO naf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yaŋkwesime Zisasiyaŋ belak zetnepiŋ tapme naman ŋen pigok yaŋkwesiye, “Kawawaŋ masesewatsanup egat Nemuŋaŋ Kilais kokotnaŋgat damuŋ matatnuwan, geŋ kapi?” ");
INSERT INTO naf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yaŋkwesime Zisasiyaŋ zeye, “Penaŋ ke zenikmak. Neŋ Kilais. Angat Nemuŋaŋaŋ neŋ yaŋ bam in nikme neŋ winde toŋaŋ Kawawaŋgalen betnaŋ penaset tati gilik zem am indatisât msalen zanza palen tati tobap.” ");
INSERT INTO naf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Zeme sâpe sâpe bumbu an ŋeŋaŋ sambe ekŋengat ŋeŋaŋin bekeyaŋ nâme bekanaŋ beme ŋenzinziŋ palen ikŋaŋgat melakanduŋaŋ mendalemti zeye, “Kwilekiyet zet sambe ewe tusumzesenup? ");
INSERT INTO naf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Egaŋ Kawawaŋgat zet mobotnaŋ penaŋ min keyepmti in zuk nâip?” Zeme am sambe ekŋenaŋ zemdelaŋ zemti zewien, “Ek gakikiyelen zapat etaŋ bein.” ");
INSERT INTO naf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Zemdelaŋ zeme keyegak notnaŋaŋ yaŋbemti zawagaŋ wasekpewien ma notnaŋaŋ zikatnaŋ melakanduŋaŋ zampeme tapme kumti zewien, “Kwiyaŋ goin? Ze zemane nâne.” Tapmme sâpe sâpe bumbu an sambe ekŋengat ŋeŋaŋin egalen mulup an ekŋenaŋ kwapem penaŋ kuwien. ");
INSERT INTO naf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Âpme Pitayaŋ mka temaŋ keyet kimbat keŋan tep kât tapme sâpe sâpe bumbu an sambe ekŋengat ŋeŋaŋinaŋgat mulup imbi ŋenaŋ koti Pita ekmototi zeye, “Geŋ kapiyaŋ Zisas Nasalet mkaengatnaŋ ekmak manik.” ");
INSERT INTO naf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Zeme Pitayaŋ yaŋpemti zeye, “Geŋ zet tazenigen ke yaŋaŋ ku nâyap.” Zemti set tokwakwalen metowesât mme sakokologaŋ kwitnaŋ yaŋbem kâkâkâââk kuye. ");
INSERT INTO naf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Âpme imbi keyaŋ metneti Pita ewe aikti am tabien ekŋengat zeye, “An kapi Zisasiyelen maŋgeyengatnaŋaŋ tazin.” ");
INSERT INTO naf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Imbi keyaŋ kok zeme Pitayaŋ ewe yaŋge belaknik tapmetneti am tabien ekŋenaŋ Pitayet zewien, “Penaŋ, geŋ ekŋengalen maŋgeengatnaŋ Galili msalengatnan kopmanan.” ");
INSERT INTO naf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Zeme Pitayaŋ zeye, “Neŋ Kawawaŋgat zikatnan penaŋ zeyap, an ke ku nâyap. Neŋ dâsuki zeyap beme Kawawaŋaŋ nâgât sekŋ ŋep saik kumnewe.” ");
INSERT INTO naf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Zemambe tati nâme sakokolok apmaŋaŋ kwitnaŋ sek zut kume Pitayaŋ eweŋan baenen Zisasiyaŋ, “Sakokolok kwitnaŋ zut kukupiŋ tapme geŋ yaŋnemane sek tuk bewe,” zeye ke otnâmti keŋan bekanaŋ penaŋ beme si sum ŋetŋet temaŋ mti tusumti suye. ");
INSERT INTO naf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Msat msasâgât tapmme sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋgalen an damuŋ notnaŋ ma zii zet zikat indanda an ekŋenaŋ ondekti, “Zisas zigok msasenup,” zemti zembiliwati am notnaŋaŋ Zisas tek katikŋaŋaŋ betnaŋ zamti amobotnaŋ Pailetmagen wapmepme ");
INSERT INTO naf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailelaŋ Zisas yaŋkwesimti zeye, “Geŋ penaŋ Zuda am ekŋengalen Amobotnaŋ manik?” Zeme Zisasiyaŋ zeye, “Zet penaŋ ke zenikmak.” ");
INSERT INTO naf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Âpme sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ zet dâsuki zet sambe sekŋanen bemzewien. ");
INSERT INTO naf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kegok zeme Pailelaŋ yaŋkwesiye, “Am sambeyaŋ gâgât bemzenze zet sambe tazeip. Âpme geŋ ekŋengat zelin dopmaŋ ŋen gilik zenzeyelen mtatnik ma yek?” ");
INSERT INTO naf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yaŋkwesime Zisasiyaŋ dopmaŋ ŋen ku gilik zem zeyeyepmti Pailelaŋ nâmtemtem penaŋ mpeye. ");
INSERT INTO naf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nup kan kataŋ Aŋgalalaŋ Kendo matakwatemienen amobotnaŋ Pailelaŋ am mka katikŋaŋgatnaŋ ŋen amnaŋ zetnaŋ zemdelaŋ zempeme makwawetan. ");
INSERT INTO naf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kogogapm an notnaŋ ekŋenaŋ gapmanmak kasa mwati am notnaŋ indome gakiwien keyepmti an ekŋen ke indatimti mka katikŋaŋ meindewien. Ekŋenmagengatnaŋ an ŋen kwitnaŋ Balabas egaŋ kegogak kasaen meti am notnaŋ indoye keyepmti mka katikŋan ilinsakwep met indeme matatemien. ");
INSERT INTO naf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Âpme am sambe penaŋaŋ Pailetgalen mka solonan koondakti Pailetgat nup kan kataŋ Aŋgalalaŋ Kendoen mamtan keyet kataŋ mimiyelen yaŋkwesiwien. ");
INSERT INTO naf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yaŋkwesime egaŋ zeye, “In neŋ Zuda am ilinaŋgalen Amobotnaŋin nâmpema inmagen kokogalen nâip?” ");
INSERT INTO naf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Amobotnaŋ Pailet egaŋ sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ Zisasiyet keŋ kuku mti pien wakolo e nâmtatiyepm kegok indayaŋkwesiye. ");
INSERT INTO naf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Âpme sâpe sâpe bumbu an ŋeŋaŋ notnaŋ ekŋenaŋ am ke tabien ekŋengat keŋin walatindemti zewien, “In Zisasiyet munduman Balabas zempeme kwatotogat,” zeseip. ");
INSERT INTO naf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Zeme Pailelaŋ ewe indayaŋkwesimti zeye, “In Zuda am ilinaŋgalen Amobotnaŋin, ek neŋ zigok msasayet nâip?” ");
INSERT INTO naf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Indayaŋkwesime ekŋenaŋ ŋagak palen zewien, “Tewen kumasasok peme gakik!” ");
INSERT INTO naf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Zeme Pailelaŋ indayaŋkwesiye, “Egaŋ kwileki yom mgeyepmti tewen kuseip?” Yaŋkwesime ekŋen sambeyaŋ kwizet ŋagak ewe mti zewien, “Tewen kumasasok peme gakik!” ");
INSERT INTO naf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kegok zeme Pailelaŋ am ekŋen keŋin mme oloŋen bembeyelen nâmti Balabas nâmpeme ekŋenmagen mege. Mti Zisas zemdelaŋ zempeme Pailetgat mulup anene ekŋenaŋ sindiwaŋ witikti tewen kumasasok pepeyet kasa kuku ekŋengat belinan bemindeye. ");
INSERT INTO naf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kasa kuku an notnaŋ ekŋenaŋ Zisas wati Pailetgalen mka teman meti kasa kuku an notnaŋ indakumtetime ");
INSERT INTO naf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","kopmâpme ekŋenaŋ melakandu ŋamaŋ amobotnaŋaŋ mamunduŋmamtemien keboŋaŋ Zisas munduŋpewien. Ma amobotnaŋaŋ bunduŋ mamunduŋmamtemien keyet sesepmaŋ ekŋenaŋ sepmeŋ muŋgumti ŋokŋanen munduŋpewien. ");
INSERT INTO naf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Munduŋpemti yaŋbem kwizet kaliaŋ msamti zewien, “Zuda ekŋengalen Amobotnaŋ geŋ ewe gakikipiŋ kan teepmaŋ mamambanik!” ");
INSERT INTO naf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Zemti puŋ kasetnaŋaŋ ŋokasetnanen somti zawagaŋ wasakpemti belak segaŋ etaŋ dâsuki beke pedondom samti zemsesewatpewien. ");
INSERT INTO naf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ekŋenaŋ mobotnaŋ ma pep kegok tapmsaneti kasa kuku ekŋenaŋ Amobotnaŋgalen melakandu munduŋpewien. Ke guluŋpemti ikŋaŋgalen itnaŋaŋ keyaŋ ewe gilik ze munduŋpemti tewen kumasasok pesâgât wapmebien. ");
INSERT INTO naf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Selen mepmambe an ŋen aikbien kwitnaŋ Saimon ek Aleksandia ma Lupus egegat biwit. Ek Apelika msalengatnan mkaŋaŋ Sailini keyetnan koti Zudia msalen ke mamtan, an keyaŋ Zelusalem mka teman mesâgât tapmepmaŋgeyaŋ selen ke aikti Zisas ku masasokpepeyelen tepmaŋ ikŋaŋ pumti taolat kopmaŋge ke mukulem mti pupuyet ze kaŋkaŋ ");
INSERT INTO naf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","mpeme pume Golgata kalaŋan mowesât mowebien. Golgata kwit keyet yaŋaŋ “am ŋokanziŋaŋ ekŋengalen mundum.” ");
INSERT INTO naf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","25","Kalaŋ ke moti Zisas tambuŋan 9 kilokgat tewen masasokpemti gwilimaŋ kumpewien mti sindem temaŋ ku nânâyet nâmti wainmak sakokolokgalen munziŋ kaŋkaŋaŋmak lelimti sawienaŋ egaŋ niniyet wisat mge. Âpme kasa kuku an ekŋenaŋ kwitnaŋ kwitnaŋaŋ gulum m timti maŋge kwep bemti nanzaŋ guluk gilik mti an kwiyaŋ nanzaŋ omba kum timti kataŋ saŋgum melakanduŋaŋ kwep kwep tiwien. ");
INSERT INTO naf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kumasasokpemti tep keyet palen meluwaŋ kapigok kumpewien, ");
INSERT INTO naf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kan keyegak am indomti milawalin kambu matimtemien ekŋenmagengatnaŋ an zut ŋen Zisasiyet betnaŋ penaset ma alomeset kumasasok idewien. ");
INSERT INTO naf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kegok mme Kawawaŋgalen zet zapat itnaŋan meluwaŋ pigok mimiŋaŋ ke penaŋaŋ sokbeye, “Ekŋenaŋ ek am bekanaŋ egetmak temakwep tusumti indowien.” ");
INSERT INTO naf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Âpme amnaŋ selen mebekoti Zisas ekti tete pulet msamti zewien, “Anbeŋgwa egit! Geŋ Zelusalem sesewat mka temaŋ beke asekti kasup tugat keŋanen etaŋ walasât manzenik wan geŋ gitaŋgat sekdi mukulem mpemti tewengatnan palam kwatot!” ");
INSERT INTO naf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Naman ekŋen sâpe sâpe bumbu an ŋeŋaŋ ma zii zet zikat indanda an ekŋenaŋ ilinak zenâ zenâ mti zewien, “An kapiyaŋ am notnaŋ ŋep mamukulem miindeinaŋ naman ikŋaŋgat sekŋaŋ ŋep ku mukulem mpen. ");
INSERT INTO naf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ek Kilais Islael am ningalen Amobotnaŋ penaŋ mamain beme tep ke pemti kwatopme ekti egat penaŋ nâmkiŋpesenup.” Zeme an zut tewen ilinsakwep kumasasokindewien egelaŋ kegogak zemtalalat zet zewun. ");
INSERT INTO naf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tewen ke kumpeme anzam tatnepeme meti msat tinsutnan penaŋ 12 kilok beme kasup zikatnaŋ sop kume tambumbuyaŋ msat kataŋ sumuŋ tatnepeme gasiyet 3 kilok beye. ");
INSERT INTO naf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kan keyegak Zisasiyaŋ Zuda zeleset kwizet pigok kuye, “Eloi, Eloi, lama Sabaktani?” Zet keyet yaŋaŋ kapigok, “Kawawaŋŋ, Kawawaŋŋ, kwilekiyet bamkumnenik?” ");
INSERT INTO naf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kwizet kegok kume, am notnaŋ sokŋanik tabienaŋ nâmti pigok zewien, “Nâip, Zisasiyaŋ golaŋ zenze an Ilaizayet kwizet takun.” ");
INSERT INTO naf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Âpme Zisasiyaŋ eyak geyak temaŋ tatime an ŋenaŋ winde bemti met kwileki ŋen yembem nemboŋ ke mti wain tu akŋaŋ keyet keŋan peme topme mkwat puŋ kasetnaŋ palen zampemti Zisas same beseseyet nâmti mge. Mti zeye, “Yegat kame nin belak tati ekmann golaŋ zenze an Ilaizayaŋ kot mukulem mpesem manze ekne!” ");
INSERT INTO naf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kegok tazeme Zisasiyaŋ kwizet temaŋ kumti keyegak gakiye. ");
INSERT INTO naf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kan keyet Zelusalem sesewat mka temanen saŋgum teepmaŋ mapeme totatatnaŋ keyaŋ gwaengatnan yaŋbem endelepeme mane mane tot yaŋaŋ baen endelet delaŋ zemti metat kotat mge. ");
INSERT INTO naf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Âpme kasa kuku ekŋengat ŋeŋaŋinaŋ taekme Zisasiyaŋ gakime Golgata kalaŋan mâkinaŋ ma kwitnaŋ kwitnaŋ sambe notnaŋ ke sokbeme ekti zeye, “Penaŋ sukwep an kapi Kawawaŋgat Nemuŋaŋ penaŋ!” ");
INSERT INTO naf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Imbi notnaŋ ekŋenaŋ kegogak beŋanik tati Zisas ekti timti tapmambien. Imbi ekŋen keyet kwilin: Malia Maktala mkaengatnan ma Malia Zems nemba zomolim ma meniŋaŋ Zoses egegat mamit ma imbi ŋen Salome ekŋen kegogaŋ tapmambien. ");
INSERT INTO naf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Zisasiyaŋ Galili msalen mamtanen kan keyet imbi ekŋen ke ma imbi notnaŋ ekŋenaŋ mâpmamti mukulem mammpemtemiengapm Zisasiyaŋ Zelusalem mkaen kopme ekŋenaŋ keyegak mâti kobien. ");
INSERT INTO naf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Zuda ekŋengalen kâtnânâ kan sokŋan beme weyeyaŋ mulup mimi kan keyet Zosep Alimatia mkaengatnan an keyaŋ koti amobotnaŋ Pailet egat zikatnan nâmtalati kiŋgagapiŋ motati Zisas sekŋaŋ nâmpeme mâtâpmti mebembeyet yaŋkwesiye. Zosep ek Zuda an ŋeŋaŋ ekŋengalen maŋgeengatnan an notnaŋ ekŋenaŋ ek kwizet buŋamaŋ temaŋgapm egat nâme mobotnaŋ mambemtan. An keyaŋ Kawawaŋgalen zemâtâtâtgat katnanen mama eegat damuŋ matatan. ");
INSERT INTO naf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Egaŋ mezeme Pailelaŋ sakwep gakip zemti nâmtemtem mti kasa kuku ŋeŋaŋgat zeme kopme yaŋkwesiye, “Zisas ilak gakip?” ");
INSERT INTO naf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yaŋkwesime, “Egaŋ ilak gakip,” zeme nâmti Zosewaŋ sekŋaŋ mmet sumen bembeyet ");
INSERT INTO naf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","nâmpeme Zosewaŋ met saŋgum satnaŋ ŋen kwitimti met Zisas sekŋaŋ tewengatnan mpeme topme saŋgum satnaŋaŋ sumuŋti am sum nanzaŋ ŋen kakalim pepeŋaŋ keyet enzuŋanen mebepemti nanzaŋ temaŋ ŋen mewililipemetot aimboŋaŋ bekek tage. ");
INSERT INTO naf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malia Makdala mkaengatnaŋ ma Malia Zoseyet mamaŋ egelaŋ taekmalu Zosewaŋ Zisasiyet sekŋaŋ mmet beye. ");
INSERT INTO naf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Zuda am ekŋengalen kâtnânâ kasup kwep elak tapme delaŋ zeme imbi tuk Malia Makdala mkaengatnaŋ ma Malia Zemsiyet mamaŋ ma Salome ekŋenaŋ wet sesikŋaŋ dolakŋaŋ Zisas sekŋanen zulutpepeyet met kwitimti bewembien. ");
INSERT INTO naf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yaŋ Sonda tambuŋan penaŋ kasuwaŋ alagak pataŋ zemkwapme keyegak am zaimen mebien. ");
INSERT INTO naf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Selen mepmambe ilinak pigok zenâ zenâ mtapmepmambien, “Pe kwiyaŋ penaŋ nanzaŋ temaŋ aimboŋaŋ bekek tazin, ke mâtâtndeme keŋan moti sekŋaŋ zulupesenup?” ");
INSERT INTO naf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Zemambe ekŋenaŋ beŋaŋ pienen metati ekme nanzaŋ temaŋ penaŋ pi walak ŋenaŋ kwanzepeme nanzaŋ aimboŋaŋ ŋandem tage. ");
INSERT INTO naf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ke ekti ekŋenaŋ mobotnak amsum nanzaŋ aimboŋaŋ keyet keŋan moti ekme anemba zomolim melakanduŋaŋ satnaŋ teepmaŋaŋ mundumti bet penaset totapme ekti endilipeme ");
INSERT INTO naf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","indikti imbi ekŋengat pigok zeye, “In endilipepepiŋ neŋ nâyap in Zisas Nasalet mkaengatnaŋ tewen kumasasok peme gakime mkobemien ke eksât kolip. Ek pi ku tazin. Ilak wati melepgat mundumaŋ etaŋ pi tazingat egit. ");
INSERT INTO naf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Keyet in met Zisasiyet nembaŋane Pita ma notnaŋ ekŋengat pigok diindoit: ‘Eweŋan baenen Zisasiyaŋ diindoye keyet kataŋ in Galili msalen ŋeŋaŋ bemindemti metatme meekbep.’” ");
INSERT INTO naf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Zet kegok zeme imbi ekŋenaŋ nâmti keŋin puŋpuŋ mme sebelaŋ diŋdiŋ mti nanzaŋ keŋangatnan kwakwatnak toti am zaim katipemti windembem mebien. Kogok mbiengapm kiŋgagalaŋ sekŋin sumuŋme selen am ŋengat zapat dundundupiŋ belak windembemti mebien. ");
INSERT INTO naf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zisasiyaŋ Sonda tambuŋan penaŋ wati ŋeŋaŋ penaŋ Malia Makdala mkaengatnaŋ ke sokbemsaye. Imbi ke eweŋan baen Zisasiyaŋ ikŋaŋ we bekanaŋ 7 kegok mâpeye. ");
INSERT INTO naf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Am itnaŋaŋ baenen Zisas mâti mamtemien ekŋenaŋ keŋin nukŋaŋ beme nâpeme mekwapme sumti matatemienaŋ imbi keyaŋ winde bemti met Zisasiyaŋ sokbemsame ege keyet zapatnaŋ pigok diindoye, ");
INSERT INTO naf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Zisasiwan gakikiengatnan wati alik tapmain,” kegok diindome ekŋenaŋ zetnaŋ nâme penaŋ ku beye. ");
INSERT INTO naf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","An zut nâmkiŋpepeŋitmak egelaŋ Zelusalem mka temaŋ katipemti selen tapmepmalu Zisasiyaŋ sepemaŋ asekti am belakŋaŋ ŋen nemboŋ bemti egetmagen mesokbemidame ");
INSERT INTO naf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ilinsakwep zepmak zepmak metneti egaŋ gelaŋ zemepme an zut egelaŋ gilik zem ewe Zelusalem mkaen koti nemba notnaŋ ekŋengat diindome ekŋenaŋ zelit keyet nâme penaŋ ku beye. ");
INSERT INTO naf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Keyepmti nembaŋane 11 ekŋenaŋ meu nini mundumen totati meu tatnime Zisasiyaŋ kot sokbemindamti, “Am notnaŋaŋ neŋ gakikiengatnan wala kegok diindome kwilekiyet keŋin katikŋaŋ beme ekŋengalen zet ke ku nâmkiŋpeip?” Zemti memendep mimindamti ");
INSERT INTO naf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","naman tusum zeye, “In msat kataŋ meti am sambe Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ diindome ");
INSERT INTO naf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","am ŋenaŋ nâmkiŋpem nemti tu zulube ek mama kanzizit tiwe. Âk am ŋen egaŋ nâmkiŋpem nenepiŋ mbeen ek bamgat zet muluwen moti walelet aikbe. ");
INSERT INTO naf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Am neŋ nâmkiŋpem newep ekŋenaŋ mulup kapigok mmebep. Nâgât kwitnnanen kumti am we bekanaŋ ŋep mâindewep ma zet ŋandaŋ ŋenŋaset zewep. ");
INSERT INTO naf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma ekŋenaŋ menemae mee pi ke belaŋ ŋep atawep ma kwitnaŋ kwitnaŋ tu meu mgasik notnaŋ amnaŋ nimti gakikiyelenaŋgut ekŋenaŋ nimti ku gakiwep. Ma am zawatmak belinan sekŋinan bem dundume ekŋenaŋ ŋep ewe alik bewep.” ");
INSERT INTO naf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Zisasiyaŋ zet kegok zemdelaŋ zemti tapme Kawawaŋgalen windeyaŋ mpeme katiindemti kululuŋen moti egaŋ Kawawaŋgat betnaŋ penaŋ windeŋaŋmak keyeset totazin. ");
INSERT INTO naf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mowepme nembaŋane ekŋenaŋ Zudia msat kataŋ meti Kawawaŋgalen Zet Zapat Dolakŋaŋ pi zemkawaŋ bewien. Kan keyet Amobotnaŋaŋ ikŋaŋ winde indame menok kwitnaŋ kwitnaŋ mti zelin mme windeŋaŋbeŋ etaŋ bemâge. ");
INSERT INTO naf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","O amobotnaŋ Tiopilas, am notnaŋ ekŋenaŋ Kilais egaŋ msalen maŋge keyet zet zapatnaŋ ke mulup windeŋaŋbeŋ mti meluwaŋ mme nin ekbenn. Mti ekŋenaŋ zet zapat dolakŋaŋgalen an ekŋen yaŋbembeŋaŋ baenen Zisas ikŋaŋmak sokŋan mamti zikalinan weyaŋ eknâmâtâtmkwabien an ekŋen keyaŋ meluwaŋ ke mbien. ");
INSERT INTO naf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Âpme neŋ kegogak kukŋaŋgat penaŋ kwileki notnaŋ sokbemkwage keyet papia sambe makumti nâmâtâti amobotnaŋ Tiopilas gâgât neŋ Zisasiyelen zet zapat ekdelaŋ zewann keyet kataŋ kapi kabemti meluwaŋ kuyap. ");
INSERT INTO naf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma neŋ meluwaŋ kumgama geŋ zet zapat mgaŋgaŋaŋ ke zet zapat penaŋ kogok nâmâtâbanik. ");
INSERT INTO naf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Âpme an kwitnaŋ Elolaŋ Zuda msalen amobotnaŋ mame kan keyet sâpe sâpe bumbu an ŋen maŋge egat kwitnaŋ Zekalayasi ek Abiyayelen mulup mimi katnanengatnaŋ mamtan. Imbiŋaŋ kwitnaŋ Elisabet ek kegogak sâpe sâpe bumbu an Alongat sipbutnaŋ. ");
INSERT INTO naf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Egelaŋ Kawawaŋgat zimosetnan mama mimiŋit dolakŋaŋ kwetetepmaŋ mamkwati Amobotnaŋ Kawawaŋ egalen zet ma zii zetnaŋ maŋgawepum mâti mambun. ");
INSERT INTO naf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma Elisabet ek imbi tipkatik keyepm egelaŋ nembapiŋ mamkwatneti an imbi ilip bewun. ");
INSERT INTO naf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Âpme kan ŋengat Zekalayasiyaŋ sâpe sâpe bumbu mulupmanen Kawawaŋgalen sesewat mka temanen mge. Egaŋ mulup ke kan kataŋ mammtan keyet katnaŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sâpe sâpe bumbu an ilinaŋgalen selin sepem mama mimiŋin ek ombemti zempeme Kawawaŋgalen sesewat mka teman kambe sesikŋaŋmak dolakŋaŋ Amobotnaŋgalen zikatnan busât mowege. ");
INSERT INTO naf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Egaŋ moti kambe sesikŋaŋmak dolakŋaŋ tabume Zuda am ekŋenaŋ zupman ondek tati Kawawaŋgat dundundu mulup tapmambien. ");
INSERT INTO naf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Egaŋ kegok tapmnepeme Kawawaŋgalen enseliyaŋ sokbemti kambe sesikŋaŋ bumbu sisak ganzenaŋ bet penaset kotage. ");
INSERT INTO naf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ke kotapme Zakaliasiyaŋ ekti palapemti weŋaŋ mepme kiŋgage. ");
INSERT INTO naf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kegok mme enseliyaŋ ekti pigok dunduye, “Zakalias, geŋ kiŋgagapiŋ. Kawawaŋaŋ dundunduŋit nâyeyepmti imbindi Elisabelaŋ nemba keŋmak tati nemba ambepme egat kwitnaŋ Zân kuwanik. ");
INSERT INTO naf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kegok sokbeme keŋdan oloŋen nâwanik ma am sambe ekŋenaŋ sokbembeŋaŋgat nâmtikŋaŋ mpewep. ");
INSERT INTO naf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Egaŋ Amobotnaŋ Kawawaŋgat zikatnan an temaŋ mambe. Mti egaŋ wain ma tu katikŋaŋ notnaŋ ku nimbe. Egaŋ mamaŋgat keŋanenak taweme Emetak Teŋaŋ ekmak tabe. ");
INSERT INTO naf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma Islael am sambe yomengatnan keŋin mgilik zemindeme Amobotnaŋ Kawawaŋin sesewatpewep. ");
INSERT INTO naf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Âpme golaŋ zenze an itnaŋaŋ kwitnaŋ Ilaiza ekmagen Kawawaŋgalen Emetak Teŋgalen winde wemsaye sepem kegogak Zânmagen wemsame zet zapat dolakŋaŋ zenze an bemti mambe. Egaŋ mulup mbeen kapigok: egaŋ bipnemba ekŋen yominangatnaŋ keŋit mgilik zeme kwep tusum tabalup. Ma am keŋin katikŋaŋmak ekŋen Zânaŋ weyaŋindeme an teŋ ekŋengalen nânâyet kandaŋanen wakbemti ekŋenaŋ Amobotnaŋgat Zânaŋ zeme kataŋ weyaŋti tabep.” ");
INSERT INTO naf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Enseliyaŋ kogok zeme nâmti Zakaliasiyaŋ zet kapigok gilik zem saye, “Imbinmak nit an imbi ilip penaŋ keyepm gâlen zet ke nâma ŋep penaŋ ku bein.” ");
INSERT INTO naf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kegok zeyeyepmti enseliyaŋ pigok dunduye, “Nânik, neŋ kwitn Gabiel. Neŋ Kawawaŋgat zikatnan matalawaŋ ikŋaŋ zemneme toti zapat pembenaŋ kapi diŋgoyap ");
INSERT INTO naf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","keyaŋgut zetn ku nâmkiŋpenik keyet dopmaŋ geŋ kopa bemti zetpiŋ manepemane zet diŋgoyap kapiyaŋ penaŋaŋmak sokbewe. Bam nâlen zetn penaŋaŋ sokbeme ekbanik.” Enseliyaŋ kegok zeye. ");
INSERT INTO naf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kan tuŋgupmaŋ keyet Zakaliasiyaŋ Kawawaŋgalen sesewat mka temanen kwisiŋ penaŋ tapme an imbi ekŋenaŋ egat damuŋ kwisiŋ penaŋ tati, “Zigok tapm,” zemti yayaŋ igagen mbien. ");
INSERT INTO naf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kegok tapmnepeme bam ekŋenmagen toti zet diindosâgât olapme ekŋenaŋ pigok nâmâtâbien ek sesewat mka temanen, “Kuleki ŋen mamanamaŋaŋ sokbemsap.” Ma egaŋ belaŋ sesepmaŋ etaŋ mimindaye, zet zigoset zenak. ");
INSERT INTO naf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakaliasiyaŋ kegok ke tapmnepeme kasup mulup kan delaŋ zeme mkaŋan gilik zem mege. ");
INSERT INTO naf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Âpme bamgat imbiŋaŋ Elisabelaŋ nemba keŋmak tati mkaŋan etaŋ tatnepeme eyoŋga 5 zeye. ");
INSERT INTO naf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Delaŋ zeme pigok zeye, “Neŋ nembapiŋ mambanaŋ Kawawaŋaŋ kan kapiyet namukulem mnein keyepm am sambeyet zikalinan sakambuk ku msap.” ");
INSERT INTO naf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabelaŋ nemba keŋmak tapme eyoŋgaŋaŋ 6 beme Kawawaŋaŋ ensel Gabiel zempeme Galili msalen Nasalet mkaen mege. ");
INSERT INTO naf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mka keyet keŋan imbi nembip ŋen maŋge kwitnaŋ Malia ekmagen busup zet ŋen mmege. Ek ke an ŋen kwitnaŋ Zosep amobotnaŋ Dewitgat iŋsokŋaŋ egat imbi zapatnaŋ zempepeŋaŋ. ");
INSERT INTO naf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Enseliyaŋ Maliamagen sokbemsamti zeye, “Ai, nânik, keŋ sewakŋaŋ geŋmagen wesemin. Kawawaŋ Amobotnaŋaŋ geŋmak tazin ma egaŋ gâgât nâmtikŋaŋ mgain.” ");
INSERT INTO naf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Enseliyaŋ zet kegok zeme keŋaŋaŋ nâmkwindemti pigok nâye, “Kwilekiyet zet nukŋaŋ kaboŋ kapi dinoin?” ");
INSERT INTO naf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kegok otnâme enseliyaŋ pigok dunduye, “Malia, geŋ ku kiŋgat! Kawawaŋaŋ nâmtikŋaŋ mgain. ");
INSERT INTO naf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nânik, geŋ kambakmak tati nemba an ambeti kwitnaŋ Zisas kuwanik. ");
INSERT INTO naf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Egaŋ Amobotnaŋ penaŋ mambe. Amnaŋ egat, ‘Amobotnaŋ Temaŋ Penaŋgat Nemuŋaŋ,’ zewep. Amobotnaŋ Kawawaŋaŋ sokŋaŋ Dewitgat munduman zempeme tabe. ");
INSERT INTO naf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Âpme egaŋ Zekopgat alikŋane ekŋen Zuda am ekŋenmagen Amobotnaŋ bemti damuŋ mulup mimiŋaŋaŋ delaŋ zenzepiŋ mmobe.” ");
INSERT INTO naf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kegok zeme Maliayaŋ ensel kapigok yaŋkwesiye, “Neŋ apmpiŋ mayapgapmti zet zenik keyet penaŋaŋ zigoset sokbewe?” ");
INSERT INTO naf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kegok zeme enseliyaŋ zetnaŋ pigok gilik zemsaye, “Kawawaŋgalen Emetak Teŋaŋ gâgât keŋdan menok msokbeme nemba kambakmak tapmane Kawawaŋaŋ zewe, ‘Nemba ke nâlen Nemun Penaŋ.’ Kegok zeme Nemba ambebanik ke Teŋ Toŋaŋ mambe. ");
INSERT INTO naf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Keyepmti kapigok zema nâmbak. Imbi nodi Elisabet ek imbi iliwaŋ nemba kambakmak tapme eyoŋgaŋaŋ 6 bein. Egat, ‘Imbi tipkatik,’ manzeiwaŋgut ekmagen kegok sokbein. ");
INSERT INTO naf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Keyepmti Kawawaŋaŋ kwileki ŋen msât mnagen ku mim alenak egaŋ ŋep mnak.” ");
INSERT INTO naf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kegok zeme Maliayaŋ pigok dunduye, “Neŋ Amobotnaŋgalen mulup imbi nemba keyepmti zet zenik keyaŋ neŋmagen ŋep sokbemnasemin.” Kegok zeme enseliyaŋ pemti mege. ");
INSERT INTO naf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Enseliyaŋ mepme kan teepmaŋ ku beme Maliayaŋ sakwep penaŋ milawatnaŋ omakumbe akumbe mti Zudia msat kalaŋan mka ŋen tageen ke memoge. ");
INSERT INTO naf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mot pataŋ pemti Zakaliasiyelen mkaen moti imbiŋaŋ Elisabet ekti zem oloŋen mpeye. ");
INSERT INTO naf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Zem oloŋen mpeme tatnânepeme keyegak kambakŋanen nemba okagaŋ titokŋaŋ mge. Âpme Emetak Teŋaŋ Elisabetgat keŋan tot bemisige. ");
INSERT INTO naf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Âpme Elisabelaŋ olimti Maliayet zeye, “Kawawaŋaŋ imbi ŋenaŋ nemba kapi ambebegalen ku ombempeye. Egaŋ gâgât nâme mobotnaŋ penaŋ beme geŋ gaombem geye. Keyepmti am ekŋenaŋ gâlen nemba ke egat nâme mobotnaŋ penaŋ beme ek sesewatpewep. ");
INSERT INTO naf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Geŋ Amobotnaŋŋ ambebanigaŋ Kawawaŋaŋ zeme geŋ neŋmagen kodik keyepm oloŋen miap. ");
INSERT INTO naf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Zem oloŋen mnemane nâma keyegak keŋŋnanen nemba okagaŋ endilipemti oloŋen mme nâyap. ");
INSERT INTO naf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Geŋmagen Kawawaŋaŋ menok mme sokbembeyet zeyeen nâmkiŋpewanangapmti geŋ imbi oloŋen toŋ.” ");
INSERT INTO naf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Âpme Maliayaŋ silik kapigok kuye, “Kawawaŋ egaŋ mulup imbi nembaŋaŋ tototnaŋ penaŋ neŋ mmotneme neŋ sesewatpemti keŋnan oloŋen penaŋ nâmpema am sambeyaŋ nâgât nâmneme neŋ imbi oloŋentoŋ bemobe. Ma Kawawaŋ ek An Winde Toŋ keyepmti menok kapi neŋmagen min. Ek kwitnaŋ An Teŋ Toŋ. Egaŋ yomengatnaŋ mkwatnein. ");
INSERT INTO naf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Âpme am keŋin Kawawaŋgat nâme mobotnaŋ mambein ekŋen ilin ma alikŋaŋine ekŋenmagen aŋgalaŋ gogotnaŋaŋ wemti wemobe. ");
INSERT INTO naf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kawawaŋ ek windeŋaŋ igagen wemsain keyepm am notnaŋaŋ nânâŋinaŋgat nâme mobotnaŋ mambein ekŋen nânâŋin makume tozin. ");
INSERT INTO naf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Egaŋ amobotnaŋ notnaŋ ilinaŋgat nâme mobotnaŋ penaŋ mambein ekŋen munduminangatnaŋ zemindeme keiŋan mamtotindein, yaŋgut am ilinaŋgat nâme tototnaŋ penaŋ mambein ekŋen mmot indeye. ");
INSERT INTO naf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Egaŋ ola olat palen mamaip ekŋen indamukulem mimindein. Ma polak polak maip ekŋen ku maindamukulem mimindein. ");
INSERT INTO naf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Egaŋ yeŋsokŋne ekŋenmak zetik mimindaye ke katikŋaŋ bein. Keyet penaŋaŋ Islael amŋane ekŋen indamukulem min. ");
INSERT INTO naf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ke aŋgalaŋ gogotnaŋgat penaŋaŋ Abalaam ma egat alikŋane sambe ekŋenmagen wemoti weweyelen nâmâtâti kegok zikat sasaŋaŋ.” Silik kogok kuye. ");
INSERT INTO naf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliayaŋ eyoŋga tuk mee kegok Elisabetmak tapmâti mkaŋan gilik ze koge. ");
INSERT INTO naf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Âpme Elisabet nemba ambebegalen kanaŋ kopme nemba okak an sokbeye. ");
INSERT INTO naf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kegok sokbeme am notnaŋ sokŋan ke mambien ekŋenaŋ keyet zapatnaŋ nâmti ekmagen koti Amobotnaŋgalen aŋgalaŋ gogotgat penaŋaŋ ekmagen sokbeye keyet olim sesewatsawien. ");
INSERT INTO naf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Keyet palaŋaŋ kasup mulup mimi 7 delaŋ zeme 8gat ekŋenaŋ nemba okak keyet sekŋaŋ butnaŋ Kawawaŋgalen piliŋ antumpemti kwitnaŋ bipmaŋgat opmaŋ Zakalias kusâgât zewien. ");
INSERT INTO naf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kegok zeme mamaŋaŋ zemkulumindemti zeye, “Ekŋen, ke yek; kwitnaŋ Zân kusenup.” ");
INSERT INTO naf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mamaŋaŋ kegok zeme ekŋenaŋ kapigok zewien “An nodinemagen kwit keboŋ ŋen ku matazin!” ");
INSERT INTO naf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kegok zemti zet mmot mtot mti bipmaŋ an kopa beyeyepm belaŋ sesepmaŋ msamti yaŋkwesiwien, “Kwitnaŋ kwi kukuyelen nânik?” ");
INSERT INTO naf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yaŋkwesime egaŋ meluwaŋ mimimak papiamak meluwaŋ kukuyet belaŋ sesepmaŋ mme mkot same egaŋ, “Kwitnaŋ Zân,” kegok meluwaŋ mme ekbien. Ekti ekŋenaŋ keyet nâmtemtem igagen mbien. ");
INSERT INTO naf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kegok mme keyegak Zakalias nambalamaŋ gilik zeme zetnaŋ zemti Kawawaŋ sesewatpeye. ");
INSERT INTO naf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Âpme an notnaŋ sokŋaŋ sokŋaŋ mambien ekŋenaŋ zet zapat ke nâme igagen penaŋ beye. Ma zet timet timkot mmetnepeme Zudia msat kalaŋan zelaŋ memot sambeleŋge. ");
INSERT INTO naf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Âpme Amobotnaŋ nemba ke ektikŋaŋ mpeyepmti an imbi notnaŋ zapat ke nâme igagen penaŋ beme pigok zewien, “Anemba keboŋaŋ sememti bamgat amobotnaŋ temaŋ bewe.” ");
INSERT INTO naf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Âpme Zângat bipmaŋ Zakalias ek Emetak Teŋaŋ keŋanen bemisikme kwitnaŋ kwitnaŋ bam sokbewe keyet golaŋ zenze anaŋ zenzeŋaŋnok zet kapi zeye, ");
INSERT INTO naf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Islael am, nin Amobotnaŋŋ Kawawaŋ sesewatpene! Ikŋaŋ amŋane ninmagen koti walelelengatnan ndatin. ");
INSERT INTO naf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Itnaŋaŋ golaŋ zenze an teŋ ekŋenaŋ busup zet zewienen kelak kapi sokbemkawaŋ bein. Ke kapigok zewien, ‘Mulup anaŋ Dewitgat alikŋane nin walelelengatnaŋ ndatitiyelen Amobotnaŋ awindeŋaŋbeŋ ŋen mmonzemndain. ");
INSERT INTO naf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ma ekŋenaŋ kasa mimindawien ekŋengalen windeengatnaŋ ndamukulem mbe.’ ");
INSERT INTO naf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kawawaŋaŋ yeŋsokŋneyet kapigok diindoye, ‘Neŋ aŋgalaŋ gogot mimindewap. Ke tususu zet inmak mimiŋaŋ keyet otnâmti kegok mbap.’ ");
INSERT INTO naf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Egaŋ ningat sokŋ Abalaamgat kapigok zemkatik beye, ‘Neŋ kasaŋine ekŋengat belinaŋgatnaŋ indamukulem mimindema in nâmtalasimti neŋ sesewatnewep. ");
INSERT INTO naf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Keyet in nâgât zimosetnnan kwetetepmaŋ ma keŋinaŋ teŋ mamti zezapatn mmamkwatneti gakime delaŋ zewe.’ ");
INSERT INTO naf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Âpme nemun, gâgât amnaŋ, ‘Kawawaŋ Temaŋ penaŋgalen golaŋ zenze an,’ zewep. Geŋ Amobotnaŋaŋ ammagen kokogalen kukŋaŋgat setnaŋ weyeyaŋ mulup mti keyet zezapatnaŋ diindowanik. ");
INSERT INTO naf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mti amŋane pigok diindowanik, ‘Kawawaŋaŋ yomin katikpemti walelelengatnaŋ indatisâpm.’ ");
INSERT INTO naf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Âpme kasuwaŋ msat mme mambusatnaŋ mambeinok keyet kataŋ Kawawaŋaŋ an ŋen zempeme koti ndamukulem mti tambusosogengatnaŋ mbusatnaŋ bemndemti ikŋaŋmagen timkwatndewe. Ke Kawawaŋgalen aŋgalaŋ gogot ma keŋ sewakŋaŋgapmti kegok mimndewe. ");
INSERT INTO naf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ma busatnaŋ keyaŋ nin am tambusosok katikŋanen matatnup nin mbusatnaŋ bemndeme busatnanen kwati keŋ sewakŋaŋgalen set aiikgalen sokbeme meti aikbanup.” Egaŋ kegok zeye. ");
INSERT INTO naf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Âpme anemba ek sekŋaŋ ma nânâŋaŋ Kawawaŋmagen kegogak semen katik beye. Kegok mti msat tuŋgupman mepmanepeme Kawawaŋgalen mulup mimiyelen kanaŋ sokbeme Islael am ekŋenmagen koti sokbemkawaŋ bemindeye. ");
INSERT INTO naf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Âpme kan keyet Loma msatgalen amobotnaŋ temaŋ kwitnaŋ Ogastas egalen zemkatik bembe ŋen kapigok zemkatik beye, “Am msat kataŋ nâlen zemâtâtâtgat katnanen maip ekŋen kwilin makumti papiaen mkatikŋaŋ beseip.” ");
INSERT INTO naf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Âpme an kwitnaŋ Kwilinias ek Silia plowins amobotnaŋ temaŋ tati kan keyet mulup nembaŋane zemindeme am kwilin makuku mulup ke egaŋ kukŋaŋgat yaŋbemti mge.) ");
INSERT INTO naf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kegok sokbeme am sambe ekŋenaŋ mkaŋin ŋotakŋanen kataŋ kwilin besâgât mepmâbien. ");
INSERT INTO naf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mepmâpme Zosep egaŋ Galili msalen Nasalet mkaen maŋgeyaŋ pemti Zudia msalen Beteleem mkaen amobotnaŋ Dewit egaŋ sokbeyeen mkaŋaŋ ŋotakŋan ke kwitnaŋ bembeyelen mege. Ek amobotnaŋ Dewitgat alikŋaŋgapmti ke mege. ");
INSERT INTO naf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Egaŋ imbi zapatnaŋ Malia tetimti ilizuzut kwilit amobotnaŋgalen papiaen besât mebun. Ke Malia nemba keŋmak tetime mebun. ");
INSERT INTO naf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Beteleem ke met tatnepemalu Malia okak sokbembeyelen kanaŋ bududuk beye. ");
INSERT INTO naf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kegok sokbeme am sambeyaŋ amkupgalen mka ke bemisikti tabien keyepm Maliayaŋ bulmakau mkaŋan nemuŋaŋ yu ambeti saŋgumaŋ sumuŋti peme bulmakau batiŋan toweŋge. ");
INSERT INTO naf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Âpme msat keyegak sipsip damuŋ ekŋenaŋ tambuyet msat tuŋgupman kwaŋ tageen sipsiwin ekdamuŋ mbien. ");
INSERT INTO naf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mti tatnepeme Amobotnaŋgalen ensel ŋenaŋ ekŋenmagen sokbemindame busatnaŋaŋ mbusatnaŋ bemindeme omba penaŋ kiŋgati sebelaŋ diŋdiŋ mbien. ");
INSERT INTO naf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kegok mbien yaŋgut ensel egaŋ kapigok diindoye, “An ekŋen, in ku kiŋgalit! Neŋ zapat dolakŋaŋ ŋen diindosâgât kolap. Keyet penaŋaŋ an imbi sambe ekŋenaŋ oloŋen temaŋ palen tabep. ");
INSERT INTO naf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Alak Amobotnaŋ Kilaisiŋin yomengatnan indatiti ek Dewitgalen mka ŋotekŋan sokbemindain. ");
INSERT INTO naf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Keyepmti an am yominangatnaŋ indetitiyelen kozin egalen piliŋaŋ kapigok: In nemba okakŋaŋ penaŋ bulmakau mkaŋan saŋgumaŋ sumuŋpepeŋaŋ bulmakau batiŋanen weme meekseip.” ");
INSERT INTO naf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Zeme zeme keyegak kululuŋengatnaŋ ensel maŋge temaŋ penaŋ ekŋenaŋ kotati pigok zemti Kawawaŋgat olim sesewabien, ");
INSERT INTO naf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kululuŋ bete bete gwaen penaŋ Kawawaŋ olim sesewat mpepeyelen. Egaŋ msalen am kwi ekŋen nâmtikŋaŋ mimindeme egalen keŋ sewakŋaŋ ekŋenmak wembe.” ");
INSERT INTO naf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensel ekŋenaŋ kegok zemdelaŋ zemti gilik zemti ekŋenaŋ kululuŋen mowepme sipsip damuŋ ekŋenaŋ ilinak zenâ zenâ mti zewien, “An ekŋen, kame nin Beteleem mkaen meti Amobotnaŋaŋ kwileki sokbeme dindoin keyet penaŋaŋ meekne.” ");
INSERT INTO naf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ekŋenaŋ kegok zemti sakwep bulmakau mkaen meti Zosepmak Malia egelaŋ nemba okak pemalu batikondoen weme tapmalut moindikbien. ");
INSERT INTO naf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ke metati sipsip damuŋ ekŋenaŋ ekŋen meindikti nemba okak ekti enseliyaŋ nemba okakgat zezapat mimindaye ke diidowien. ");
INSERT INTO naf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Âpme am notnaŋ ekŋenaŋ sipsip damuŋ ekŋengalen zezapat ke nâmti nâme igagen penaŋ beme nâmtemtem mbien. ");
INSERT INTO naf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Maliayaŋ zet ke keŋan penaŋ bempemti otnâpeŋ penaŋ mamamtan. ");
INSERT INTO naf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsip damuŋ ekŋenaŋ kegok zemdelaŋ zemti gilik zemti meti enseliyaŋ kwileki sambe mzikat indame eknâm mbien keyepmti Kawawaŋgat olim sesewatbien. ");
INSERT INTO naf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Âpme mulup mimi kasup 7 delaŋ zeme 8gat nemba sekŋaŋ butnaŋ antumpemti kwitnaŋ Zisas kuwien. Kwit ke kukŋaŋgat nemba okak ku sokbeme enseliyaŋ zemsokbeye. ");
INSERT INTO naf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Âpme Mosesiyelen zii zelen tage ke mâti Maliamak Zosewaŋ sesewat mka temaŋ mobopiŋ mamtemun ya bamgat Malia egalen nemba sokbeyeyelen sip katim delaŋ zeme Zelusalem sesewat mka temanen Zisas Amobotnaŋgat zapat sasayet wapmobun. ");
INSERT INTO naf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ma Mosesiyelen zii zelen kapigok zenzeŋaŋ, “Anemba yu ekŋen Amobotnaŋgat zapat indandayelen.” ");
INSERT INTO naf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma Amobotnaŋgalen zii zelen zet ŋen kapigok mimiyelen, “Sasakandenombe awembiŋ zut yek beme kopende awembiŋ zut sâpe sâpe bumbuyelen mobogalen.” Egelaŋ ke mâti kwitnaŋ kwitnaŋ ke timti bumbuyelen mowebun. ");
INSERT INTO naf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Âpme kan keyet an ŋen kwitnaŋ Simion egaŋ Zelusalem mka teman mamtan. Ek an dolakŋaŋ Kawawaŋgalen zet gawepumti Islael am ekŋenmagen yominangatnaŋ indatitiyelen An ŋengat damuŋ mamtan. Ma egaŋ Emetak Teŋmak mamtan. ");
INSERT INTO naf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Keyepmti Emetak Teŋaŋ kapigok zemâtâtpeme mamtan, “Geŋ gakikipiŋ tapmane Kawawaŋaŋ Kilais zempeme kokogalen zetik mpepeŋaŋ ke ektiŋgut gakiwanik.” ");
INSERT INTO naf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Zeme tatnepeme Zisas mamaŋ bipmaŋaŋ wati sesewat mka temanen zii zelaŋ zenzeŋaŋ ke mâti mowebun. Kan keyet Emetak Teŋaŋ Simion zemâtâtpeme sesewat mka temanen mowet ");
INSERT INTO naf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","tapme Maliayaŋ nemba okak same ambetati Kawawaŋgat wisikŋ kapigok zeye, ");
INSERT INTO naf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Amobotnaŋ, geŋ zetikdi bandim mnik keyepmti alak mulup andi neŋ nemba okak ambetati keŋ sewakŋaŋ penaŋ beingapm nemane ŋep gakisap. ");
INSERT INTO naf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Alak neŋ nemba kapiyaŋ am nin walelelengatnaŋ ndatim kwakwagalen ke zikatnnaŋ penaŋ egap. ");
INSERT INTO naf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kawawaŋ geŋ weyeyaŋ mulup ke am sambe ekŋenaŋ ek nâmâtâtâgalen kegok mnik. ");
INSERT INTO naf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ma an geŋ pemane kozin keyaŋ Zuda am ningat tuŋgupmaŋ tati walelelengatnaŋ ndamukulem mbe ma egaŋ kegogak am Zuda maŋgeen ku sokbembeŋaŋmagen meti Kawawaŋgalen zezapat dolakŋaŋ mzikat indame ekŋenaŋ nâmâtâbep.” ");
INSERT INTO naf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kegok zemsesewatpeme nemba mamaŋ bipmaŋ egelaŋ Simionaŋ nemba okakgat zet ŋandaŋ zeye ke nâmti nâmtemtem mbun. ");
INSERT INTO naf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kegok mmalu Simionaŋ Kawawaŋaŋ eget winde idadayelen wekumti egaŋ Zisas mamaŋgat kapigok dunduye, “Nemba okak kapi Kawawaŋaŋ ikŋaŋ ombempeme koge. Ya Islael am notnaŋ egat nâmkiŋpewewaŋ ku walebep. Ma notnaŋ ekŋenaŋ egat sek kaŋgaŋ nâmpewewaŋ walebep. Nemba okak kapiyaŋ Kawawaŋgalen golaŋ zet ammagen diindome ekŋenaŋ zet ke ku mkipmaŋ bewep. ");
INSERT INTO naf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ma nemba kapiyaŋ amgalen nânâŋin enzililiŋaŋ penaŋ keyet yaŋaŋ mkawaŋ bewe. Kegok sokbeme geŋmagen sindem omba penaŋ sokbewe sakamaŋ wanam kukŋaŋ penaŋaŋ sekdi aŋme sindem mambein keboŋ penaŋ tiwanik.” Kegok zemdelaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Âpme kan keyegak imbi ilip golaŋ zenze imbi ŋen mamtan kwitnaŋ Ana. Ek imbi kwambet Panueliyet nembaŋaŋ Aseliyet sipbutnaŋ. Egaŋ an wati manepeme nup kan 7 etaŋ beme apmaŋaŋ gakime ");
INSERT INTO naf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","igak kwambet manepeme nup kanaŋ 84 beye. Egaŋ sesewat mka temanen mene mene Kawawaŋgat olim sesewati mandundum samtan ke tu meuyet nâmtalati kegok mamtan. ");
INSERT INTO naf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Egaŋ Simionaŋ olim sesewat tapmaŋgeen keyegak kot pataŋ pemti Kawawaŋgat wisikŋ zemti am notnaŋ ekŋen Kawawaŋaŋ Islael am yomengatnaŋ indatitiyelen damuŋ matatemien ekŋen nemba keyet zapat diindoye. ");
INSERT INTO naf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Âpme Zosepmak Malia egelaŋ Amobotnaŋgalen zii zelaŋ zenzeŋaŋ ke mâti kwileki mimiyet zenzeŋaŋ ke mdelaŋ zemti nemba okak wetimti gilik zemti mkaŋitdan Nasalet Galili msalen mebun. ");
INSERT INTO naf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Âpme nemba ek windeŋaŋmak ma nânâŋaŋ temaŋmak sememe Kawawaŋaŋ ek oloŋen igagen mpeye. ");
INSERT INTO naf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nup kan kataŋ Zisasiyet mamaŋ bipmaŋaŋ Aŋgalalaŋ Kendoyet Zelusalem mka temanen mamotemun. ");
INSERT INTO naf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Âpme Zisasiyaŋ nup kanaŋ 12 beme Kendoyet mamotemun kegogapm mowebien. ");
INSERT INTO naf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ke moti mame Kendo delaŋ zeme am ekŋenaŋ gilik zemti mkaŋinan mekopme an nemba Zisas ek Zelusalem mka temaŋ tapme mamaŋ bipmaŋaŋ nânâpiŋ pemti ilidak mebun. ");
INSERT INTO naf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Egelaŋ, “Wan notnaŋnemak olokati melep,” zemti mebun. Kegok tapm nepemalu kasup kwep delaŋ zeme selen ekmepmalu yek beme sipbutnaŋ ma notnane ekŋenmagen timamat mulup mbun. ");
INSERT INTO naf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Egelaŋ kegok mti ku aikbungapm egelaŋ Zelusalem mka temaŋ gilik zemti egat timapmebun. ");
INSERT INTO naf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kegok tapmalut kasup zut delaŋ zeme tugat keŋan egelaŋ Zelusalem sesewat mka temaŋ keŋan Zuda zii zet diindondo an ekŋenmak tomtati zenâ zenâ tapmme moti aikbun. ");
INSERT INTO naf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ekŋenaŋ egat nânâŋaŋ ma yaŋkwesisiŋinaŋgat dopmaŋ zeye ke ekti nâme igagen beme nâmtemtem mbien. ");
INSERT INTO naf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kegok tapme mam bipmanelaŋ ek ekti kan keyet nâmtemtem temaŋ mti mamaŋaŋ pigok dunduye, “Nemun, kwilekiyet mti geŋ pigok mimndamane bipdimak nit keŋ sindem palen gâgât timalup?” ");
INSERT INTO naf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kegok zeme egaŋ kapigok gilik zemti diidoye, “Maŋge bien, kwilekiyet natimalup? It neŋ Bipmnaŋgalen mka keŋan tatagalen ke ku nâlup?” ");
INSERT INTO naf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kegok zeme egelaŋ Zisasiyelen zetnaŋ gilik zemidaye keyet yaŋaŋ ku nâmâtâbun. ");
INSERT INTO naf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kegok sokbeme Zisasiyaŋ mamaŋ bipmaŋ egetgalen zelit gawepumti ilinsakwep gilik zemti Nasalet mkaen mebien. Meti ke mamti mamaŋ bipmaŋgalen zelit gawepumti mamtan. Mamaŋaŋ egalen zet ke keŋanen mkatikŋaŋ bemti nâmamtan. ");
INSERT INTO naf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Âpme Zisasiyaŋ sekŋaŋ sememe nânâŋaŋ kegogak nâmteleŋ peme Kawawaŋaŋ ma amnaŋ ek ekti nâmtikŋaŋ mme maŋge. ");
INSERT INTO naf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Âpme an kwitnaŋ Tibeliasiyaŋ Loma msalen amobotnaŋ temaŋ maŋge. Kan keyet an ekŋen kapiyaŋ polowins sambe Lomayelen zemâtâtât kandaŋan mambien ekŋengalen amobotnaŋ mambien: Pontias Pailet Zudia, Samalia, Idumea polowins tuk ekŋen keyelen amobotnaŋ maŋge; Elolaŋ Galili ma Pelea polowins zut keyelen amobotnaŋ maŋge. Elotgat meniŋaŋ kwitnaŋ Piliwaŋ Itulia am ma msat isikŋaŋ kwitnaŋ Talakonaitis ekŋengalen amobotnaŋ maŋge. Âpme Lisaniasiyaŋ msat isikŋaŋ kwitnaŋ Abilin ekŋengalen amobotnaŋ maŋge. ");
INSERT INTO naf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Âpme Anas ma Kaiapas egelaŋ Zelusalem sesewat mka temaŋgalen sâpe sâpe bumbu amobotnaŋ ilizuzut mambun. Kan keyet Kawawaŋaŋ zezapat Zân Zekalayasiyet nemuŋaŋgat msat tuŋgupman ke zemsame kopme ");
INSERT INTO naf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Zân egaŋ Zodan tu nembet nembet mka ŋande tapmege ke meti zezapat kapigok diindoye, “Keŋ gilik zenze aikti yomengatnan kwati tu zulupme Kawawaŋaŋ yomin katikpesem.” ");
INSERT INTO naf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Zeme zet ŋande keyet golaŋ zenze an Aizayayaŋ Kawawaŋgalen zapat itnaŋanen meluwaŋ mge keyet katnanen sokbein. Zet ke kapigok, “An ŋenaŋ msat tuŋgupman kwizet buŋam kapigok takuin, ‘Amobotnaŋaŋ kokotnaŋgalen weyeyaŋ mulup mit. Set mobototot mimiŋaŋ utume kwetetepmaŋ beme egaŋ kokogalen setnaŋ sokbak. ");
INSERT INTO naf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ma luŋ temaŋ tototnaŋ sambe msat aŋbeme kwepmâlak ma kalaŋ mobotnaŋ utume tolak. Set guŋgwaŋ guŋgwaŋ mimiŋaŋ weyaŋme teŋ bek ma set aimboŋaŋmak ma kaŋaŋ mobot totot mme kwetetepmaŋ bek. ");
INSERT INTO naf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Msalen am sambeyaŋ Kawawaŋaŋ yomengatnaŋ ndatetim kwazin ke ekmâtâbep!’” Zet ŋande ke Aizayayaŋ zeye ya Zânaŋ ewe zet ŋande keyegak zeye. ");
INSERT INTO naf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Âpme am sambe ekŋenaŋ Zânaŋ tu zulutindende ekmagen kopme kapigok diindoye, “In nombeyelen alikŋaŋ. In nâme Kawawaŋaŋ yominaŋgat dopmaŋ mutumindasâgât tapm ke walabep bein? Yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","In mama mimi dolakŋaŋ mme keyaŋ in yomengatnan keŋin gilik zewien ke sosok sokbemkawaŋ bewe. In keŋinan kapigok ku otnâit, ‘Nin Abalaamgat iŋsokŋane manup keyepm Kawawaŋaŋ ku zemndowe.’ Neŋ pigok diindoma nâit, zet ke belakŋaŋ penaŋ. Kawawaŋ egaŋ zenak beme ke ŋep zeme nanzaŋ ekŋen kapiyaŋ Abalaamgat alikŋane bewiek.” ");
INSERT INTO naf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kegok zemti zet zapat sesepmaŋ ewe tusum pigok zeye, “An ŋen ek nâmkiŋpepeŋaŋmak bewe ke tep katnaŋ maelikzin keboŋ. Âpme an ek nâmkiŋpepeŋepiŋ bewe ek tep sinaŋ memuŋ beme tobe keboŋ ke ek tepgat zapat bewe.” ");
INSERT INTO naf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kegok zeme am ekŋenaŋ yaŋkwesiwien, “Nin zigok mmann ŋep benak?” ");
INSERT INTO naf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Zeme egaŋ zet dopmaŋ kapigok gilik zemindaye, “An ŋen melakanduŋaŋ zut wemsain beme ŋen an melakanduŋepiŋ main ke sawe ma an ŋen meu nimwiaŋ wiaŋaŋmak main beme am notnaŋ tu meupiŋ ekŋen kalaŋkum indawe.” ");
INSERT INTO naf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kan keyet takis mânep titi an ekŋenaŋ kegogak Zânmagen tu zululugalen kobien. An ekŋen keyaŋ kapigok yaŋkwesiwien, “An diindondo, nin kwileki mmann ŋep benak?” ");
INSERT INTO naf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ekŋen kegok yaŋkwesime egaŋ kapigok diindoye, “In takis mânep katnaŋen bembeŋaŋ ke aŋgosomti moti matip ke katikpemti zemâtâtpepeŋanen esemteŋ matimambep.” ");
INSERT INTO naf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Âpme kasa kuku an notnaŋ ekŋenaŋ koti kegogak yaŋkwesiwien, “We nin zigok? Nin kwileki mbanup?” Zeme kapigok diindoye, “In am ekŋenmagen mânep indapilimti zem kiŋgat indemti zet mutum mutum zemti ku tiwep. In muluwinaŋgat tosaŋaŋ keŋ pembenaŋ palen indame tiwep.” ");
INSERT INTO naf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Am ekŋenaŋ webe webe mamimtemien keyet penaŋaŋ yaŋbemti sokbeme ekŋenaŋ keŋinan kapigok otnâwien, “Zân kapi Kilais sokbembeyelen zenzeŋaŋ ke mene.” ");
INSERT INTO naf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kegok zeme Zânaŋ ekŋen sambe kapigok diindoye, “Neŋ keŋin gilik zeme tu etaŋ manzulutindeyap yaŋgut bamnan An kosâpm ek Amobotnaŋ temaŋ windeŋaŋbeŋ penaŋ. Ek Amobotnaŋ penaŋ; neŋ an tototnaŋ. An keyaŋ koti ikŋaŋ Kawawaŋgalen Emetak Teŋ mulupmaŋ teziŋaŋ yom zim kwetetepmaŋ mambein kemak temakwep zulutindewe. ");
INSERT INTO naf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","An keyaŋ am nâmkiŋpepeŋinmak time maŋge ŋen motasâip mti nâmkiŋpepeŋinpiŋ kegogak time maŋge ŋen motatsâpmnen sepemaŋ imbi ŋenaŋ kawakŋaŋ ondesâgât makalopbein kogok mbe. An ke mulupmaŋ imbiyaŋ kawakŋaŋ makalopbemti bekanaŋ matime mezin keyet kataŋ egaŋ am nâmkiŋpepeŋinpiŋ timti time teziŋ ŋandan towebep. Mti kawak ketnaŋ pembenaŋ ondesât time mamotazinen kogok ke am nâmkiŋpepeŋinmak indatime ikŋaŋmak tabep.” ");
INSERT INTO naf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Âpme Zânaŋ am mama mimiŋin ekmâtâti keŋ gilik zenze aiikgalen egaŋ zapat dolakŋaŋ yomengatnaŋ indamukulem mbe keyelen golaŋ zet set katnaŋ igak igak zemsokbemindaye. ");
INSERT INTO naf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Âpme am ekŋenaŋ tu zulupme delaŋ zeme Zisasiyaŋ kegogak mepme tu zulutpeye. Kegok mti keyegak tadundume kululuŋ ŋandeme Kawawaŋgalen Emetak Teŋaŋ sasakandenombe nemboŋ bemti ekmagen toge. Ke topme kululuŋengatnaŋ zet ŋande kapigok sokbeye, “Geŋ nanaŋgat Nemun penaŋ. Neŋ gâgât nâmtikŋaŋ omba penaŋ manâyap. Neŋ geŋ gaombemgewanen am yominangatnaŋ indati kwabanik keyet oloŋen miap.” Âpme amobotnaŋ Elolaŋ meniŋaŋgalen imbi kwitnaŋ Elodias kambu menzem wage ke ma sekŋeyak notnaŋ bekanaŋ penaŋ mge keyepmti Zânaŋ egaŋ yom mge keyet musuwewet zet zeye. Kegok mme Elolaŋ Zân mka katikŋan peye ke yom temaŋ ŋen ewe tusuye. ");
INSERT INTO naf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Âpme Zisasiyaŋ nup kanaŋ 30 beme mulupmaŋ yaŋbemti mge. Am notnaŋaŋ Zisasiyet nâme Zosep ikŋaŋgat nemuŋaŋ penaŋ beye. Zosepgat bipmaŋ Eli, ");
INSERT INTO naf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliyet bipmaŋ Matat. Matatgat bipmaŋ Liwai. Liwaiyet bipmaŋ Melki. Melkiyet bipmaŋ Zanuai. Zanuaiyet bipmaŋ Zosep. ");
INSERT INTO naf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zosepgat bipmaŋ Matatias. Matatiasiyet bipmaŋ Amos. Amosiyet bipmaŋ Naum. Naumgat bipmaŋ Esili. Esiliyet bipmaŋ Nagai. ");
INSERT INTO naf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiyet bipmaŋ Mat. Matgat bipmaŋ Matatias. Matatiasiyet bipmaŋ Semein. Semeingat bipmaŋ Zosek. Zosekgat bipmaŋ Zoda. ");
INSERT INTO naf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zodayet bipmaŋ Zoanan. Zoanangat bipmaŋ Lesa. Lesayet bipmaŋ Zelubabel. Zelubabeliyet bipmaŋ Sealtiel. Sealtieliyet bipmaŋ Neli. ");
INSERT INTO naf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neliyet bipmaŋ Meliki. Melikiyet bipmaŋ Adi. Adiyet bipmaŋ Kosam. Kosamgat bipmaŋ Elimadam. Elimadamgat bipmaŋ Eili. ");
INSERT INTO naf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eiliyet bipmaŋ Zosua. Zosuayet bipmaŋ Eliezel. Eliezeliyet bipmaŋ Zolim. Zolimgat bipmaŋ Matat. Matatgat bipmaŋ Liwai. ");
INSERT INTO naf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwaiyet bipmaŋ Simion. Simiongat bipmaŋ Zuda. Zudayet bipmaŋ Zosep. Zosepgat bipmaŋ Zonam. Zonamgat bipmaŋ Eliakim. ");
INSERT INTO naf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimgat bipmaŋ Melea. Meleayet bipmaŋ Matata. Matatayet bipmaŋ Natan. Natangat bipmaŋ Dewit. ");
INSERT INTO naf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewitgat bipmaŋ Zesi. Zesiyet bipmaŋ Obet. Obetgat bipmaŋ Boas. Boasiyet bipmaŋ Salimon. Salimongat bipmaŋ Nason. ");
INSERT INTO naf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasongat bipmaŋ Aminadap. Aminadapgat bipmaŋ Alini. Aliniyet bipmaŋ Esilon. Esilongat bipmaŋ Peles. Pelesiyet bipmaŋ Zuda. ");
INSERT INTO naf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zudayet bipmaŋ Zekop. Zekopgat bipmaŋ Aisak. Aisakgat bipmaŋ Abalaam. Abalaamgat bipmaŋ Tela. Telayet bipmaŋ Naol. ");
INSERT INTO naf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naoliyet bipmaŋ Seluk. Selukgat bipmaŋ Leu. Leuyet bipmaŋ Pelek. Pelekgat bipmaŋ Abel. Abeliyet bipmaŋ Sela. ");
INSERT INTO naf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selayet bipmaŋ Kainan. Kainangat bipmaŋ Alapasat. Alapasatgat bipmaŋ Sem. Semgat bipmaŋ Noa. Noayet bipmaŋ Lemek. ");
INSERT INTO naf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemekgat bipmaŋ Metusela. Metuselayet bipmaŋ Enok. Enogat bipmaŋ Zalet. Zaletgat bipmaŋ Maalalel. Maalaleliyet bipmaŋ Kenan. ");
INSERT INTO naf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenangat bipmaŋ Enos. Enosiyet bipmaŋ Set. Setgat bipmaŋ Adam ma Adamgat bipmaŋ Kawawaŋ. ");
INSERT INTO naf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Âpme Zisas Emetak Teŋaŋ keŋanen tage keyepm egaŋ Zodan tu katipemti mepme Emetak Teŋ keyaŋ Zisas msat tuŋgupman met zeme ke meti ");
INSERT INTO naf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","msasa 40 ke Zisasiyaŋ tu meu ninipiŋ mamti egaŋ tu meuyet penaŋ gakiwaleletgalen mge. ");
INSERT INTO naf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kegok tapmme msasa 40 delaŋ zeme Sadaŋaŋ ekmagen koti yaŋaŋ m eksâti pigok dunduye, “Geŋ Kawawaŋgat Nemuŋaŋ penaŋ benik beme nanzaŋ kapi zemane meu sokbeme ŋep nsenik.” ");
INSERT INTO naf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kegok zeme Zisasiyaŋ kapigok dunduye, “Kawawaŋgalen Zet Itnaŋanen meluwaŋ kapigok kukuŋaŋ tazin, ‘Amnaŋ keŋin tu meuyet etaŋ bemti ku mamayelen. Yek penaŋ.’” ");
INSERT INTO naf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kegok zeme Sadaŋaŋ Zisas kalaŋ teepmaŋ temaŋ ŋengat dukŋan aikmoti msat kataŋ amobotnaŋ sambe ekŋengalen msat sambe zikat same ekmâpmeŋgut ");
INSERT INTO naf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Zisas kapigok dunduye, “Neŋ amobotnaŋ sambe ekŋengalen msat sambe msat kataŋ tazin ke ma ekŋengalen kwitnaŋ kwitnaŋ dolakŋaŋ sambe ke gâgât gasap. Ekŋen kwitnaŋ kwitnaŋ sambe kapi nâlen ma neŋ an ŋen ma an ŋen sasâgâti ŋep sasap. ");
INSERT INTO naf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Keyet geŋ nâgât pedondomti dundundu mnasenik beme kwitnaŋ kwitnaŋ sambe ekdigen ke gâgât gasap.” ");
INSERT INTO naf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kegok zeme Zisasiyaŋ zet dopmaŋ kapigok dunduye, “Kawawaŋgalen Zet Itnaŋanen meluwaŋ kapigok kukuŋaŋ tazin, ‘Kawawaŋ Amobotnaŋdi etaŋ pedondom samti dundum sawanik ma ek kwep etaŋ sisiliŋ mim samti mambanik.’” ");
INSERT INTO naf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kegok dundume Sadaŋaŋ Zisas Zelusalem sesewat mka temaŋ dukŋaŋen aikti mot peme tapme kapigok dunduye, “Geŋ Kawawaŋgat nemuŋaŋ beme kapiyetnan palam towet ");
INSERT INTO naf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","enenogat Kawawaŋgalen Zet Itnaŋaŋen meluwaŋ ŋen kapigok kumpepeŋaŋ tazin, ‘Kawawaŋaŋ enseliŋaŋ peme kot aŋgalaŋgeme ku walebanik.’ ");
INSERT INTO naf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma ŋen ewe kapigok, ‘Ekŋenaŋ belinaŋ gatam topme nanzaŋaŋ sedi ku aŋbe.’” ");
INSERT INTO naf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kegok zeme Zisasiyaŋ Sadaŋ kapigok dunduye, “Yaŋgut Kawawaŋgalen Zet Itnaŋaŋ meluwaŋ ŋen kapigok tazinegak, ‘Kawawaŋ Amobotnaŋdi tetimaemaeen ku pewanik.’” ");
INSERT INTO naf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sadaŋ ek yaŋaŋ kegok m ek m ek mgeyaŋ yek beme bam yaŋaŋ m eekgalen nâmti pemege. ");
INSERT INTO naf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Âpme Zisasiyaŋ Galili msalen gilik zem mepme Emetak Teŋgalen winde ekmak tage. Ke kot mame kwizapatnaŋaŋ sakwep palakŋaŋ bemti msat ke ma notnaŋ sokŋan tapmeliwen ke mekoge. ");
INSERT INTO naf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ke mekopme egaŋ Zuda amgalen sesewat mka isisikŋan sambe ke meti am Kawawaŋgalen zezapat dolakŋaŋ diindome ekŋenaŋ zetnaŋ ke nâmtikŋaŋ ma oloŋen penaŋ mti zemsesewabien. ");
INSERT INTO naf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Âpme Zisasiyaŋ Nasalet mkaen mamti semeyeen ke metapme Sabat tagoŋgo kan sokbeme sesewat mkaen kan kataŋ mametan kegogak metati Kawawaŋgalen zezapat itnaŋaŋ maiŋgalen dendaŋ watapme ");
INSERT INTO naf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","sesewat mkaengalen mulup an ŋenaŋ golaŋ zenze an Aizayayelen papia muŋguguŋaŋ meluwaŋaŋmak ke mti same mototi zet ŋen kapigok ekti maiŋge, ");
INSERT INTO naf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Aizayayaŋ kapigok zenzeŋaŋ, ‘Amobotnaŋgalen Emetak Teŋaŋ ekmagen koti egaŋ ombem neme am tototnaŋ ekŋengat zezapat dolakŋaŋ mkawaŋ bembeyelen koban. Ma am notnaŋ mka katikŋan matalip ekŋenaŋ lala mebep. Ma am zikalin beŋaŋ ekŋenaŋ zikalin ekbep. Ma am notnaŋ am notnaŋaŋ mtoindewien ekŋen ke tiŋkwatindewe. ");
INSERT INTO naf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma egaŋ Kawawaŋaŋ amŋane yomengatnaŋ indamukulem mimiyelen kanaŋ sokbein keyelen zet zapat zemkawaŋ bewe.’” ");
INSERT INTO naf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Zet kegok maiŋme delaŋ zeme papia ke muŋgumti mulup an ke samti egaŋ zet keyet yaŋaŋ mkawaŋ bembeyelen totapme animbi sambe sesewat mkaen tabien ekŋenaŋ zikat gwalalaŋ ek kwep ekbien. ");
INSERT INTO naf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kegok mme egaŋ zet yaŋbemti kapigok diindoye, “Alak zet zapat maiŋma nâip keyet penaŋaŋ neŋmagen sokbem tazin.” ");
INSERT INTO naf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kegok zeme ekŋenaŋ nâme penaŋ beme zetnaŋgat nâmtikŋaŋ mti tek tek mti nânâŋaŋgat pisem zewien, “Anemba kapi sosok Zosepgat nemuŋaŋ wa kapi.” ");
INSERT INTO naf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kegok zeme egaŋ diindoye, “Neŋ nâyap in neŋ zapat dinosâbip ke amnaŋ zezapat ke nânâŋaŋ manzeip ke kapigok, ‘Geŋ dokta benik beme gitaŋgat nodine weyaŋindesenik.’ Ma in nâgât kegogak zesâbip, ‘Geŋ Kapaneam mka temanen menok sepem igak igak mbananen ke alak kapi mkandi ŋotekŋaŋ mulupdi ke kegogak mmane ekne.’” ");
INSERT INTO naf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kegok zemti egaŋ tusum zeye, “Golaŋ zenze an ŋen mkaŋaŋ ŋotekŋan tapme ikŋaŋgalen maŋge ekŋenaŋ notn notn dolakŋaŋ ku mamimpeip.” ");
INSERT INTO naf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ma zet ŋen ewe pigogat zema nâit, “Golaŋ zenze an Ilaiza egaŋ maŋge kan keyet Islael msat kataŋ nup kan tuk ma eyoŋga 6 kegok mtete temaŋ tapme msat kataŋ meuyet kambeŋ sokbeye. Ke penaŋ kan keyet Islael msalen imbi kwambet sambe mambien. In ma neŋ nânup. ");
INSERT INTO naf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kawawaŋ egaŋ golaŋ zenze an Ilaiza imbi kwambet Islael msalen mambien ekŋen indamukulem mimiyelen ku zempeme mege. Yek penaŋ. Egaŋ ek Islael maŋgeen ku sokbembeŋaŋ mka kwitnaŋ Salepat Saidon msalen imbi kwambet ŋenmagen zempeme mukulem mpepeyelen mege. ");
INSERT INTO naf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Âpme naman golaŋ zenze an ŋen kwitnaŋ Elisayaŋ maŋgeen kan keyet Islael msalen am liŋgit katikŋaŋinmak sambe penaŋ mambien yaŋgut egaŋ ekŋenmagengatnaŋ ŋen mukulem mme dolakŋaŋ ku beye. An kwitnaŋ Naeman ek Zuda maŋgeen ku sokbembeŋaŋ ek Silia msalengatnaŋ mukulem mpeme ek etaŋ liŋgitnaŋ ŋeluye.” ");
INSERT INTO naf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Zisasiyaŋ kegok diindome am sesewat mka keŋan tabien ekŋenaŋ zet keyet nâmti ŋenzinziŋ penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kegok sokbeme ekŋenaŋ wati Zisas âtâpe âtâpem toti Nasalet mka ŋande ganzenan met pewien. Ma ekŋengalen mka ŋande ke kalaŋ temaŋ keyet dukŋan matatan. Keyepmti ekŋenaŋ mandamti kalaŋ kandaŋaset moti ekŋenaŋ Zisas ŋandaŋan âtâpeme towesât mbien ");
INSERT INTO naf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","yaŋgut egaŋ ekŋengat tuŋguwinaset mege. ");
INSERT INTO naf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Âpme Zisasiyaŋ ke toti met Galili msalen mka temaŋ kwitnaŋ Kapaneam ke pataŋ zemti Sabat tagoŋgo kanen zezapat dolakŋaŋ am ekŋen kemagen zemzikat indaye. ");
INSERT INTO naf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Egaŋ zetnaŋ windeŋaŋmak zeye keyepm amnaŋ egaŋ zezapat diindoye ke nâmti nâmtemtem mbien. ");
INSERT INTO naf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Âpme sesewat mka keyet keŋan an ŋen we bekanaŋaŋmagaŋ keyak tapmaŋge. ");
INSERT INTO naf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Yaŋ we bekanaŋ keyaŋ Zisas ekiŋgati omba penaŋ kwizet kumti zeye, “Eii! Zisas Nasalet mkaengatnaŋ, geŋ ninmak mulup msâpmnik ke nin nânup. Geŋ nin ndawaleletgalen nâmti kodik, ma? Geŋ an kwi ke neŋ ŋep nâmâtâlap. Geŋ Kawawaŋgalen Nemuŋaŋ Teŋ penaŋ.” ");
INSERT INTO naf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kegok zeme Zisasiyaŋ we bekanaŋ keyet pigok zeye, “Buzak tati an keŋangatnaŋ kwati met.” Kegok zeme we bekanaŋ an keyet keŋangatnaŋ kwaweti am ekŋengat zikalinan an ke mme tokutum peweme egaŋ ku waletpeye. ");
INSERT INTO naf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kegok sokbeme an imbi sambeyaŋ ke ekti nâmtemtem mti ilinak kapigok zemâbien, “Kae, egaŋ zet windeŋaŋbeŋ penaŋ tazein. Ke ek an kwizapatnaŋmak ma windeŋaŋmakgapm zet zeme we bekanaŋaŋ am keŋangatnan wati mamepmâlip.” ");
INSERT INTO naf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Âpme amnaŋ Zisasiyet zezapat ma menok mamanamaŋ mkwage keyaŋ Galili msalen mka ŋande igak igak sokŋan ma beŋan ke zapatnaŋaŋ mekopme delaŋ zemâge. ");
INSERT INTO naf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Âpme Zisas sesewat mkaengatnan toti Saimongalen mkaen mowege. Kan keyet Saimongat tatnaŋ imbi zawat sek kip temaŋ mti tawemaŋgeyaŋ egat yayaŋ mti Zisasiyet pigok yaŋkwesiwien, “Geŋ imbi kapi ŋep mukulem mpesenik ma yek?” ");
INSERT INTO naf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kegok zeme Zisasiyaŋ imbi weŋgeen mka keyet keŋan meti mundum imbiyaŋ tawemaŋgeen ganzenan dendaŋ tati kusum toti sekŋaŋ kipmaŋ ke atam nâmti zawat sek kikip ke zempeme egaŋ keyegak wawatnak ekŋengat tu meu weyeyaŋ mulup mge. ");
INSERT INTO naf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kegok mti tatnepeme kasup towesâgât mme Sabat tagoŋgo kan delaŋ zeme am sambeyaŋ noline zawat kwitnaŋ igak igakmak indatimti Zisasmagen kopme betnaŋ ilizuzut am kwep kwep sekŋinan beme ŋep bewien. ");
INSERT INTO naf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kegok mme we bekanaŋaŋ am keŋinangatnan kwati kwizet ŋagak omba penaŋ mti zewien, “Geŋ Kawawaŋgat Nemuŋaŋ penaŋ!” Ekŋenaŋ Zisasiyet yaŋaŋ Kilais nâmbien keyepmti egaŋ ekŋen zemkulumindemti, “Buzak talit,” zemindeye. ");
INSERT INTO naf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Âpme msat msame egaŋ toti msat tuŋgupman butnaŋ ŋen met dundundu mulup mti tapmaŋge. Âpme am ekŋenaŋ Zisas timat meti met aikti ekŋenmak mamayet aŋgalaŋbien. ");
INSERT INTO naf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ekŋenaŋ kegok mme egaŋ pigok diindoye, “Neŋ mka temaŋ kataŋ meti Kawawaŋgalen zemâtâtât katnanen mama keyet zet zapatnaŋ diindondoyelen Kawawaŋaŋ zemneneŋaŋgapmti ŋep ku tasap.” ");
INSERT INTO naf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kegok zemti Zudia msat keyelen sesewat mkaen meti Kawawaŋgalen zezapat dolakŋaŋ mandiindometan. ");
INSERT INTO naf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Âpme kasup ŋengat Zisas egaŋ Genesalet tundua ganzenan gambibigen tati Kawawaŋgalen zezapat dolakŋaŋ tazeme keyegak animbi sambeyaŋ nânâyelen kot ŋenaŋ ŋen âtâpem âtâpem mti kot bembuluŋti zetnaŋ ke nâwien. ");
INSERT INTO naf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma gambibik palen ke waŋga zut kegok tapme aŋgala titi an ekŋenaŋ waŋgaŋinaŋgatnan toti met eleŋgolaŋ temaŋ aŋgalayelen ke tazulutmambien. ");
INSERT INTO naf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kogok tapmme Zisasiyaŋ waŋga ŋengat dukŋan mowege ke toŋaŋ kwitnaŋ Saimon. Ke motati egaŋ Saimongat zeme waŋganaŋgame tundua palen mepme egaŋ ke totati Kawawaŋgalen zezapat dolakŋaŋ animbi zemzikat indaye. ");
INSERT INTO naf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Diindomâpme delaŋ zeme Saimon egat zeye, “Nin nsakwep tundua sutnatemanen imbeŋanen meti in eleŋgolaŋ temaŋ peme topme aŋgala notnaŋ tiseip.” ");
INSERT INTO naf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kegok zeme Saimonaŋ kapigok dunduye, “An zikat indanda, nin mulup temaŋ tambu tetak kapi eleŋgolaŋ penaŋgut aŋgala ŋen ku tin. Yaŋgut geŋ zenikgapmti ewe mepemti eksâpminup.” ");
INSERT INTO naf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kegok zemti ilinsakwep meti Saimongalen mulup anŋaneyaŋ eleŋgolaŋ temaŋ peme towepme aŋgala igagen penaŋ keyet keŋan atame nukŋaŋgat penaŋ mti eleŋgolaŋ tekŋaŋ etisâgât penaŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kegok mti mandam alewienaŋ ku kwapme noline waŋga ŋen mambien ekŋengat kwizet kumti bepelep mme kot indamukulem mindemti aŋgala waŋga zut keyet keŋan time topme ilizuzut gak zemkwapme waŋga tundua keŋan towesâgât mbun. ");
INSERT INTO naf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Kegok mti Saimonaŋ aŋgala maŋge temaŋ tiwien ke ekti ikŋaŋ ma an notnaŋ ekŋenaŋ ke ektemtem penaŋ mbien. Kegok sokbeme Saimon Pitayaŋ ke ekti Zisasiyet kandaŋan met pedondom samti zeye, “Amobotnaŋ, neŋ a yomtoŋ keyet geŋ nemti met!” ");
INSERT INTO naf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma Saimonmak mulup an notnane mamtemienen kwilit Zems ma Zân Zebediyet nemulatnenet egelaŋ koekti ektemtem kegogak mbun. Mme Zisasiyaŋ Saimon kapigok dunduye, “Geŋ ku kiŋgat! Geŋ aŋgala titiyaŋ bam Kawawaŋgalen zezapat dolakŋaŋaŋ am titi mambanik.” ");
INSERT INTO naf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kegok zeme ekŋenaŋ waŋga mandame gambibik palen keiŋan mowepme kwitnaŋ kwitnaŋ sambeŋin bamkumpemti Zisasmak tusumti mebien. ");
INSERT INTO naf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Âpme Zisas ek maneti mka ŋen met mame an ŋen liŋgit satnaŋmak tapmaŋgeyaŋ Zisas ekti kot kandaŋan pedondom samti weyaŋpepeyelen otnâmti keŋaŋaŋ sume kapigok zeye, “Amobotnaŋ, weyaŋne. Geŋ nâgât sekŋ mmane ŋep bembeyelen nânik beme ŋep weyaŋnesenik!” ");
INSERT INTO naf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kegok zeme Zisasiyaŋ betnaŋ sekŋanen timekti zeye, “Nâmgeyapgapm sekdi ŋep bak!” Zeme keyegak sekŋaŋ liŋgit sambe ŋeluye. ");
INSERT INTO naf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kegok mpemti Zisasiyaŋ zemkulumpemti kapigok dunduye, “Nânik, geŋ zet zapat kapi am ŋengat ku zemane nâmbep. Geŋ belak esemteŋ met sâpe sâpe bumbu anmagen meti sekdi met zikat samane wiliŋgisem. Ma Mosesiyaŋ eweŋan zeyenok sâpe sâpe bumane am sambeyaŋ nâme gâlen liŋgit satnaŋ ŋep bein ke zewep.” ");
INSERT INTO naf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Âpme an ŋep beye keyet buŋam zapalaŋ sakwep penaŋ mekopme animbi sambeyaŋ Kawawaŋgalen zezapat dolakŋaŋ Zisasiyaŋ zeme nânâyelen kobien ma am zawalinmak sambe Zisas egaŋ weyaŋindendeyelen kopme maweyaŋindemtan. ");
INSERT INTO naf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kogok mmambe Zisasiyaŋ mene mene dundunduyelen msat tuŋgupman metati mandundumtan. ");
INSERT INTO naf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Âpme kasup ŋengat Zisasiyaŋ am Kawawaŋgalen zapat dolakŋaŋ tadiindo maŋgeen Palisi an ma zii zet zikat indanda an notnaŋ ekŋenaŋ kegogak keŋan ke koti tabien. An ekŋen ke Galili ma Zudia msalen ma Zelusalem mka temaŋ keyetnaŋ kopmâbien. Tapmme am zawalinmak weyaŋindendeyelen Amobotnaŋ Kawawaŋgalen winde Zisas ekmak tasaye. ");
INSERT INTO naf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Âpme an notnaŋaŋ wesiŋ ŋen lueen lue mti koti mka Zisas tapmaŋgeen pum moti Zisasiyet kandaŋan bembeyelen moolatbien. ");
INSERT INTO naf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Am sambeyaŋ mka keŋaŋgatnaŋ bemisik peme sekekegen kot kindiŋ zeye keyepm ekŋenaŋ mowewegalen set ku sokbeye. Mme beme pumti mka ŋokŋan moweti mka ŋokŋaŋ butnaŋ asekti lueŋaŋ melesiŋ âlâlâŋ peme am sambeyet tuŋguwinan Zisasiyet kandaŋan totage. ");
INSERT INTO naf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ekŋenaŋ nâmkiŋpewienen Zisasiyaŋ an wesiŋ weyaŋpesem nâmbien keyepmti Zisasiyaŋ nâmkiŋpepeŋin ekti an wesiŋ dunduye, “Notn, gâlen yomdi katikpeyap.” ");
INSERT INTO naf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kegok zeme Palisi an ma zii zet zikat indanda an ekŋenaŋ zet ke nâmti keŋinan kapigok otnâmbien, “Amgalen yom katikpepe mulup ke Kawawaŋgalen etaŋ. Âpme an kapi ikŋaŋgat nâme kwileki penaŋ ben?” ");
INSERT INTO naf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ekŋenaŋ kegok nâme Zisasiyaŋ keŋinaŋgat yaŋaŋ ekmâtâti kapigok diindoye, “In kwilekiyet neŋ zet zeya ke nâme Kawawaŋgat mobotnaŋ mpeyap penaŋ beme nânâŋinaŋ taosolalip? ");
INSERT INTO naf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Neŋ kapigok zeya, ‘Notn, gâlen yomdi katikpeyap’. Zet ŋande zeya ke in nâme pepesut bep. Ele, in naman wak bemti egat zet ŋande ŋen zesowap kapi in eknâme pepesut ku besem. Kawawaŋgalen winde neŋmagen tatnain keyepm neŋ zet ŋande ŋen ma ŋen zewak beme penaŋaŋ sokbenak. ");
INSERT INTO naf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Neŋ Angat Nemuŋaŋ am msalen yom katikpepeyelen Bipm Kawawaŋgalen winde nayeyepmti neŋ yom ŋep katikpeyap. Keyet yaŋaŋ ekmâtâlit.” Kegok zemti an wesiŋ ke kapigok dunduye, “Neŋ gâgât zeyap, geŋ wati luendi gapumti mkandan met!” ");
INSERT INTO naf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Zeme keyegak ekŋengat zikalinan wati luaŋaŋ tawemaŋgeen wati gapumti mkaŋan mesâti mepmambe selenak tapmeti Kawawaŋgat sesewatsaye. ");
INSERT INTO naf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mme am sambeyaŋ ke ekti nâmtemtem temaŋ mti kiŋgagatmak tati Kawawaŋ sesewatpemti ilinak zenâ zenâ mti kapigok zewien, “Alak kapi menok sepem mamanamaŋ igak igak sokbeme zikatnnaŋ eknup.” ");
INSERT INTO naf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Âpme Zisasmak nembaŋane ekŋenaŋ mka temaŋ tapmambienen ke katipesâgât mti takis titi an kwitnaŋ Liwai ek mânep titi mkaŋan totapme meekti Zisasiyaŋ ek kapigok dunduye, “Geŋ koti nâlen maŋgeen tusumane metne.” ");
INSERT INTO naf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kegok dundume Liwai ek wati kwitnaŋ kwitnaŋ weyaŋ bepemti Zisasiyelen maŋgeen tusume mebien. ");
INSERT INTO naf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Meti Liwaiyelen mkaen moti egaŋ Zisasiyet nâmti tu meu temaŋ bume mânep takis titi an sambe ma an notnaŋ kegogak mototati tu meu ilinsakwep nimbien. An ekŋen meu ilinsakwep Liwaimak kobien ekŋen ke an yomtoŋ. ");
INSERT INTO naf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tatnime Palisi an ma ilinaŋgalen zii zet zikat indanda an ekŋenaŋ ke eknâme bekanaŋ penaŋ beme Zisasiyet nembaŋane ekŋenmagen meti kapigok indayaŋkwesiwien, “In kwilekiyet am yomtoŋ ma an mânep takis butnaŋ kambu matip ekŋenmak meu tatnimo?” ");
INSERT INTO naf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kegok indayaŋkwesime Zisasiyaŋ nâmti kapigok diindoye, “Am zawatpiŋ maip ekŋenaŋ doktamagen ku mamelip. Yek penaŋ. Am zawalinmagaŋ mamelip. ");
INSERT INTO naf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma neŋ am teŋ maip ekŋen indamukulem mimiyelen ku toban yek; am yomtoŋ indamukulem mima yomengatnan keŋ gilik zenze aiikgalen nâmti msalen kapi toban.” ");
INSERT INTO naf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Âpme Zisas zet kegok zeme am notnaŋ ekŋenaŋ egat kapigok zewien, “Zângalen nemba ekŋenaŋ msasa sambenik tu meu zemkulumpemti dundundu mulup mamip ma Palisi an ekŋengalenaŋ kegogak mamiwaŋgut gâlen nemba ekŋenaŋ tu meu ku zemkulumpemti dundundu mulup ku mamip.” ");
INSERT INTO naf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kegok zeme Zisasiyaŋ bemzenze zet ŋen ikŋaŋgat palen bam sokbewe keyelen bemzeye, “An ŋenaŋ imbiŋaŋ wasât mti notnanemak tapme ekŋenaŋ tu meu zemkulumpepepiŋ; oloŋen penaŋ tati tu meu nimwiaŋti tatnepemeŋgut ");
INSERT INTO naf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","an imbi wasâgât mge ek kasaŋane ekŋenaŋ koti manda mepme kan keyet notnaneyaŋ keŋ sindem palen ma tu meu zemkulumpemti tabep.” ");
INSERT INTO naf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Zisasiyaŋ bemzenze zut zesâpm kapi yaŋaŋ kwep e kapigok. Set itnaŋaŋmak ikŋaŋgalen zet zapat alakŋaŋmak pepep ŋep ku tabuk keyelen bemzenze kapi bem zeye, “Mka tokan tuŋgupmanen etimbembeŋaŋ selik alakŋaŋ antimti ku weyaŋ bek. Weyaŋsât tapmnepemane egaŋ bululuŋ zemtobodak. Keyepmti alakŋaŋ etaŋaŋ mpemane dolakŋaŋ kaliŋaŋ tadak keboŋ. ");
INSERT INTO naf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Ma am ŋenaŋ siŋgapoŋ sâŋsâŋ busât selik telepmaŋ peweweŋaŋgat ku bunak. Bunak beme seligaŋ sakwep epeeme sâŋsâŋaŋ mulatnak. Keyepmti selik alakŋanen buwek beme egaŋ epeepiŋ; dolakŋaŋ zinak! ");
INSERT INTO naf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Âpme am notnaŋaŋ mama mimi itnaŋaŋ keyet nâme dolakŋaŋ beme mâti mama mimi alakŋaŋ neŋmagengatnaŋ kapiyet nâme pepesut penaŋ mambein eneyet mama mimi alakŋaŋ neŋmagengatnaŋ tikŋaŋmak ke ekŋenaŋ ŋen ku tiwien.” ");
INSERT INTO naf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Âpme Sabat tagoŋgo kan ŋeniyet Zisas ma nembaŋaneyaŋ set wit mulup tuŋgupmaset mebetnaŋ ke moti mebien. Mepmambe nembaŋane ekŋenaŋ meuyet mti wit katnaŋ kwep kwep timti belaŋ enzaŋme wit sekŋaŋ toweme penaŋaŋ nimbien. ");
INSERT INTO naf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ekŋenaŋ kegok tapmepme Palisi an notnaŋ ekŋenaŋ indikti indayaŋkwesiwien, “In kwilekiyet Sabat tagoŋgo kangat mulup ku mimiyelen zenzeŋaŋ ke tapmip?” ");
INSERT INTO naf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kegok indayaŋkwesime Zisasiyaŋ kapigok diindoye, “In Dewit ma anene ekŋenaŋ meuyet mti kwitnaŋ kwitnaŋ mbien keyet zapatnaŋ Kawawaŋgalen Zet Itnaŋan tazinen ke in mamaiŋ nâip. ");
INSERT INTO naf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ke kapigok, Dewit egaŋ Kawawaŋgalen sesewat mka temanen moti nupmamaŋ Kawawaŋgat wisikŋ bembeŋaŋ ke sâpe sâpe bumbu an egaŋ msame ikŋaŋ ma nembaŋane nupmamaŋ ke nimbien. Ke zii zelen tazinen sâpe sâpe bumbu an ekŋenaŋ etaŋ niniyelen zenzeŋaŋ. Am notnaŋaŋ ke ku niniyelen zii zelen zemâtâtpepeŋaŋ. Dewit egaŋ zii zet aŋgosoye keyaŋgut egaŋ mge keyet bekanaŋ ku manzeip.” ");
INSERT INTO naf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kegok zemti zet kapigok zemdelaŋ zeye, “Angat Nemuŋaŋ neŋ Sabat tagoŋgo kangalen Amobotnaŋ talap.” ");
INSERT INTO naf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Âpme Sabat tagoŋgo kan ŋeniyet Zisasiyaŋ Kawawaŋgalen sesewat mka isikŋan moti Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ am zemzikat inda mme an ŋen betnaŋ penaset seleuuŋaŋ ke motapmaŋge. ");
INSERT INTO naf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma keyegak zii zet zikat indanda an ma Palisi an notnaŋ ekŋenaŋ Zisasiyaŋ am Sabat tagoŋgo kangat weyaŋindeme ekti zelen pepeyelen damuŋ motapmambien. ");
INSERT INTO naf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ekŋenaŋ kegok otnâwien yaŋgut Zisasiyaŋ ekŋengat nânâŋin ekmâtâti an betnaŋ seleuuŋaŋ keyet kapigok dunduye, “Geŋ wati neŋmagen pien sosok kotat.” Kegok zeme nânâŋak wati ekmagen mege. ");
INSERT INTO naf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ke mepme Zisasiyaŋ am sambe kapigok diindoye, “Neŋ indayaŋkwesima in zigok nâip? Keyet dopmaŋ zeme nâmbi. Ningalen zii zelaŋ zigok zein? Sabat tagoŋgo kanen kwitnaŋ kwitnaŋ dolakŋaŋ mimiyelen ma kwitnaŋ kwitnaŋ bekanaŋ mimiyelen zein? Am weyaŋindendeyelen ma am waletindendeyelen zein?” ");
INSERT INTO naf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zisasiyaŋ kegok indayaŋkwesimti am meindik koindik mti an tageen ke kapigok dunduye, “Bedi weyaŋ mututut!” Zeme keyegak an keyaŋ betnaŋ mututume dolakŋaŋ beye. ");
INSERT INTO naf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kegok sokbeme ekŋenaŋ menok ke ekti keŋinan kasayaŋ sokbeme Zisas e ma e msasayelen zet zenâ zenâ msâgât zewien. ");
INSERT INTO naf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Âpme kan keyet Zisasiyaŋ kalaŋan dundundu mulup msât moweti tambu teepmaŋ Kawawaŋgat dundum samti tapme msat msaye. ");
INSERT INTO naf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Msat msame egaŋ nembaŋane mâpmamtemien zeme ekmagen kopme indaondak indemti ekŋenmagengatnaŋ 12 kegok ombemindeyeen Zet Zapat Dolakŋaŋ Penaŋ zemkawaŋ bembeyelen an ombemindemti indemebegalen ombemindeye. ");
INSERT INTO naf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","An ekŋen keyet kwilin kapigok: Saimon, kwitnaŋ ŋen kegogak Pita Zisasiyaŋ kuye, ma datnaŋ Endulu ma Zems ma Zân ma Pilip ma Batolomiyu ma Matiyu ma Tomas ma Zems Alapeasiyet nemuŋaŋ ma Saimon amnaŋ kwitnaŋ ŋen Zelot makumtemien, ma Zuda Zemsiyet nemuŋaŋ ma Zudas, Iskaliot mka temaŋgatnaŋ. Egaŋ bamgat Zisas kasa ekŋengat belinan bewe. ");
INSERT INTO naf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Âpme egaŋ nembaŋane 12 indatimti kalaŋangatnaŋ msat doweŋan toti dapmelaŋgeŋane sambe indaige ma am sambeyaŋ kegogak ekmagen ondekbien. Am sambe ekŋen ke Zudia msalengatnaŋ ma Zelusalem mka temaŋgatnaŋ ma Taia ma Saidon mka temaŋ zut nembu ganzenangatnaŋ. ");
INSERT INTO naf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ekŋenaŋ kot zezapat dolakŋaŋ nânâyelen ma am zawalinmak weyaŋindendeyelen indatim kobien. Ma am we bekanaŋaŋ waletindendeŋaŋ kegogak kopme ekŋen sambe ke weyaŋindeye. ");
INSERT INTO naf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kegok sokbeme am sambeyaŋ ek timekti dolakŋaŋ bembeyelen nâmti windeŋaŋ mbien. Enenogat timekbienen ekŋenmagen windeŋaŋaŋ mepme ekŋenaŋ dolakŋaŋ bemâbien. ");
INSERT INTO naf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Âpme Zisasiyaŋ nembaŋane ekŋenmagen zikat indikti zet kapigok diindoye, “In yominaŋgat nâme kembeŋ mambein ma keŋ sekŋin mtoti mamaip beme in kululuŋgat zapat ombemindewan keyepm oloŋen temaŋ inmagen sokbein. ");
INSERT INTO naf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ma in mama mimi teŋ Kawawaŋaŋ indandayet windeŋaŋ mamip in oloŋen temaŋ palen talip. Eneyet Kawawaŋaŋ keŋinan nâip keyet kataŋ mimindame oloŋen palen tabep. Ma in yominaŋgat keŋinan masumsaip in oloŋen temaŋ mamip. Keyet in Kawawaŋaŋ yomin katipeme keŋin oloŋen penaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","In Angat Nemuŋaŋ neŋmak mamaip keyepm amnaŋ wisat nâmindemti ingat tikŋaŋ ku nâmti zet bekanaŋ diindomti ingat am bekanaŋ manzeip keyaŋgut oloŋen temaŋaŋ inmak taindain. ");
INSERT INTO naf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","In maneti nukŋaŋ keyaŋ inmagen sokbeme in keŋ oloŋen penaŋ mti pala motobep. Enenogat tosaŋin temaŋ kululuŋen gwaen motiwep. Wa ke in etaŋ yek; golaŋ zenze an eweŋan tipman baen mamkwabien ekŋen am ingat wisat mimindewep ekŋengat yeŋsokŋineyaŋ sisipeŋpeŋ sepem kegogak mimindamkwabien. ");
INSERT INTO naf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wakae, in alak mânep milawalin temaŋmak talip in msat kapiyelen zapat etaŋ. Inmagen sindem omba penaŋ tiwep! ");
INSERT INTO naf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wakae, inmagen sindem omba penaŋ tiwep. Enenogat in mama mimi dolakŋaŋ mâbâgalen ku nâwiengapm in kemak walebep. Ŋen ewe kapi in yominaŋgat keŋinaŋ ku masuip in Kawawaŋaŋ yomin ku katipeme keŋinaŋ bekanaŋ penaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wakae, sindem omba penaŋ tiwep. Amnaŋ ingat yaŋin bekanaŋ ke ku nâmâtâti keyepm ingat, ‘An dolakŋaŋ,’ manzeip. Sakam kegogak am ekŋengat yeŋsokŋineyaŋ itnaŋaŋ golaŋ zenze an dâsuki ekŋengat zewienok. ");
INSERT INTO naf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Âpme neŋ ingat ilinsakwep zema nâit: In kasaŋinaŋgat gogot mti am ingat wisat mamip ekŋengat pembenaŋ mimindawep. ");
INSERT INTO naf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","In amnaŋ saik kumindeip ekŋengat zet dolakŋaŋ zewep. Ma am ingat bekanaŋ mbep ekŋengat Kawawaŋgat dundum same yomin katipewe. ");
INSERT INTO naf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma am ŋenaŋ neŋgumdi nembet omba taime geŋ pemane nembet kegogak taiwe. Ma am ŋenaŋ tâgâyelen melakandu sekdanen gulum mme melakandu tipmangatnaŋ pemane kegogak gulum mbe. ");
INSERT INTO naf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma an ŋenaŋ olati kwitnaŋ ŋengat wekumgame nâmtalati sawanik. Ma am ŋenaŋ gâlen kwitnaŋ ŋen mme zemane gilik zem gaŋgayet zet katikŋaŋ ku zewanik. ");
INSERT INTO naf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Amnaŋ geŋ mgaŋgayelen manânik sepem kegogak geŋ kukŋaŋgat mimindawanik. ");
INSERT INTO naf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Âpme in am ingat gogot mamip ekŋengat etaŋ mbep beme Kawawaŋaŋ in dopmaŋ dolakŋaŋ ku indawe. Am yomtoŋ ekŋenaŋ kegogak gogot dopdop mamip. ");
INSERT INTO naf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma in notn notn am mimiŋaŋmak etaŋ mme ekŋenaŋ kegogak mamimindaip beme ke Kawawaŋaŋ in dopmaŋ pembenaŋ ku mimindawe. Enenogat am yomtoŋ ekŋenaŋ kegogak mamip. ");
INSERT INTO naf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma am ŋenaŋ kwitnaŋ kwitnaŋgat olalat penaŋ mti notnaŋgat zeme mânep sain beme notnaŋ mânep sain keyaŋ, ‘Mânepmaŋ dopmaŋ nain ma yek,’ keyet webe webe penaŋ mimipiŋ. Am yomtoŋ ekŋenaŋ kogogak dopmaŋ sam dopmaŋ sam mamip. Keyet ŋenaŋ webe webe mbe beme Kawawaŋaŋ dopmaŋ pembenaŋ ku sawe. ");
INSERT INTO naf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yaŋgut in kasaŋinaŋgat gogot mimindemti dolakŋaŋ mimindewep ma mânep indamti dopmaŋ titiyelen webe webe ku mbep beme in tosa pembenaŋ tiwep ma amnaŋ ingat ‘Amobotnaŋ Kawawaŋgat Nembaŋane,’ zewep. Kawawaŋaŋ an keŋ katik ma an bekanaŋ ekŋen keboŋ maindamukulem min. ");
INSERT INTO naf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ma Biwin Kawawaŋaŋ ingat kembeŋ mam keyepm in am sambeyet sepem kegogak kembeŋ manâmindemambep. ");
INSERT INTO naf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","In am ŋen sakwep penaŋ ku manâmbemindemambep. Am zemindowep beme Kawawaŋaŋ in zemindowe. Ma in am notnaŋ yomin katipewep sepem kegogak Kawawaŋaŋ ingat yomin katipewe. ");
INSERT INTO naf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ma in am taolet mimindame Kawawaŋaŋ in kegogak taolet mimindawe. Egaŋ in indawe ke elendanen meu sambeyaŋ gak zeme eleyaŋ etim totogalen mnak bemzenze zet keboŋgat sepem indawe. Âpme in kwitnaŋ kwitnaŋ sepem zigok amgat mbep Kawawaŋaŋ sepem amgat sawanik kegok gawe.” ");
INSERT INTO naf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kegok zemdelaŋ zemti Zisasiyaŋ bemzenze zet kapigok diindoye, “An zikat beŋ ŋenaŋ notnaŋ zikat beŋaŋ ŋen ŋep ku betnamti mebuk. Egelaŋ kegok mbuk beme ilizuzut enzuŋan toidonak. ");
INSERT INTO naf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ma nembayaŋ an zikat indandaŋaŋ sebem pepeyelen ku tazin yek. Nemba keyaŋ kwitnaŋ kwitnaŋ nâmâtâti an zikat indandayet kataŋ beme mandelaŋ zein. ");
INSERT INTO naf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Âpme geŋ kwilekiyet nodaŋgalen kakalak isikŋaŋ zikatnan tazin ke eknigaŋgut gitaŋgalen zikadan tep paŋaŋ temaŋ tazin ke ku nâmâtâtnik? ");
INSERT INTO naf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma naman tep paŋaŋ temaŋ gitaŋgalen zikadan tapmeŋgut nânâpiŋ geŋ zigoset nodaŋgat kapigok zempemane ŋep bewe, ‘Notn, nâmane zikadan kakalak isikŋaŋ tazin ke timgewi.’ An nambalamdi zut, geŋ ŋeŋaŋ gitaŋgalen tep paŋaŋ temaŋ ke mpemti zikadaŋ weyaŋ ekmâtâtiŋgut nodaŋgalen kakalak ke timpewanik. ");
INSERT INTO naf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Âpme tep dolakŋaŋaŋ penaŋaŋ bekanaŋ ku maelikzin ma tep wesiŋaŋ penaŋaŋ pembenaŋ ku elikdak. ");
INSERT INTO naf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ma amnaŋ tepgat yaŋaŋaŋ eegalen penaŋaŋaŋ manzem sokbein. Ma an ŋenaŋ saŋganeŋanen sindip katnaŋ ku mâtâtnak. Ma sepem kegogak sâkâyaŋ meyowak ku eliknak. Yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Am ŋen dolakŋaŋ keŋaŋ dolakŋaŋ egaŋ mama mimiŋaŋ pembenaŋ mkawaŋ benak. Ma an ŋen bekanaŋ egaŋ mama mimiŋaŋ bekanaŋ mkawaŋ benak. An keŋanen kwitnaŋ kwitnaŋ gak ze matazin keyaŋ zet dembusekŋanen masokbein. ");
INSERT INTO naf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kulekiyet nâgât, ‘Amobotnaŋŋ,’ zemnamti zet manzeyap ke ku maŋgawepuip? ");
INSERT INTO naf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","An ŋen neŋmagen koti zetn nâmti gawepun ek an sepem ziboŋ ke neŋ am ke ŋep mkawaŋ besâwap kapigok mbe. ");
INSERT INTO naf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ek ke an ŋenaŋ mka walage keyet kataŋ bein. An ek keyaŋ tepum msalen teepmaŋ walapme towepme nanzaŋaŋ tepum ganzenan time towepme gwatnaŋ mpeme kaliŋaŋ bemti tage. Mti mka walapme delaŋ zeme map tâgâ temaŋ kwageen tuŋgwam kwati tuyaŋ mka kumaleme gweŋgweŋ penaŋ kumti tage. Enenogat tepumaŋaŋ msat imbeŋan penaŋ towepme nanzaŋaŋ ganzenan gwatnaŋ mge kogogapm katikŋaŋ tage. ");
INSERT INTO naf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yaŋgut an ŋenaŋ zetn nâmti ku gawepuwe ek an ŋen mka windeŋepiŋ keboŋ tepumaŋ imbeŋaŋ ku toge ma nanzaŋaŋ tepum ganzenan ku gwatnaŋ mpeye. Keyepmti tuŋgwam kwageen tuyaŋ mkaŋaŋ kume tepumaŋ bik zemti mka tu palen kutume walelet temaŋ aikge. An nâgât manâmkiŋpeinen an mka katikŋaŋ walage keboŋ. Ma nâgât ku nâmkiŋpeinen an mkaŋaŋ tuwat tuwat walage keboŋ.” ");
INSERT INTO naf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Âpme Zisasiyaŋ zet zapat ke am diindome delaŋ zeme Kapaneam mka teman koge. ");
INSERT INTO naf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ke koti tapme Loma mka temaŋgalen kasa kuku an ŋeŋaŋ bembeŋinaŋgalen mulup nembaŋaŋ nâmtikŋaŋ penaŋ mamtan keyaŋ zawat nukŋaŋ mti gakikiyelen bududuk tage. ");
INSERT INTO naf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kegok sokbeme kasa kuku an ŋeŋaŋ keyaŋ Zisasiyet zet zapat nâmti egaŋ Zuda sesewat mka temaŋgalen an damuŋ indeme Zisasiyet zenânâyelen mebien egaŋ ŋep koti mulup nemba weyaŋpepeyelen zeye. ");
INSERT INTO naf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kegok zemindeme ekŋenaŋ Zisasmagen koti egat zebabak zet giŋgiŋ mti zewien, “An ke gâlen mulup mamingat mukulem mpesenik. ");
INSERT INTO naf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Egaŋ ningalen aminne gogot penaŋ mamimindein ma egaŋ ikŋaŋ mânep beme ningalen sesewat mka walatndewien.” ");
INSERT INTO naf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kegok dundume nâmti ekŋenmak meti mkaŋanen sokŋan kwapme kasa kuku an ŋeŋaŋ egaŋ an notnaŋne zet kapigok zemti zemindeme Zisasmagen meti zewien, “Amobotnaŋ, an ŋeŋaŋnnaŋ zet kapigok zep, ‘Geŋ kapi tati nâlen mkaen set kokogalen mulup ewe ku msenik.’ Neŋ an gâgât kandaŋdan talap geŋ nâlen mkaen ŋep ku kokogalen. ");
INSERT INTO naf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma kegogak neŋ nâyawen gâgât zikadan neŋ ŋep ku kokogalen geŋ amobotnaŋ penaŋ keyepmti geŋ belak zet etaŋ zemane nâlen mulup an alik besem. ");
INSERT INTO naf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Neŋ kegogak kasa kuku an ŋeŋaŋ notnaŋgalen kandaŋan tati mulupm mamiyap ma kegogak neŋ kasa kuku annemak ekŋenaŋ nâgât kandaŋnan matalip. Neŋ ann ŋengat, ‘Met,’ zema mamezin ma ŋengat, ‘Kot,’ zema makozin ma mulup nemban ŋen egat, ‘Mulup mi,’ zema zetn gawepumti mamm. Keyepm neŋ nâyawen geŋ kapi tati zedi etaŋ zemane nâlen mulup annaŋ alik besem.” ");
INSERT INTO naf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kegok zeme Zisasiyaŋ zet ke nâme nâmtemtemŋaŋmak beme gilik zem am notnaŋ baman kobien ekŋen indikti diindoye, “Neŋ zema nâit, neŋ Islael aminne inmagengatnaŋ nâmkiŋpepe temaŋ keboŋ ŋen ku aikban!” ");
INSERT INTO naf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kegok zeme amŋane ekŋenaŋ gilik zemti mkaen moti ekme mulup nembayaŋ alik bem totage. ");
INSERT INTO naf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Âpme kasup ŋen Zisasiyaŋ mka temaŋ ŋen kwitnaŋ Nain ke mepme nembaŋane ma am sambe ekmak mebien. ");
INSERT INTO naf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ke meti egaŋ mka temaŋgalen setokwakwalen kwapme am notnaŋ an gakikiŋaŋ lueen pumti setokwakwalengatnaŋ kwati sumen mesâgât mebien. An gakikiŋaŋ ke imbi kwambet ŋengat nemuŋaŋ kwep etaŋ keyaŋ gakime am sambe mka temaŋ keyetnaŋ ekmak mebien. ");
INSERT INTO naf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ke takopme Amobotnaŋ egaŋ egeen keŋaŋaŋ imbi kwambet keyet kembeŋ penaŋ mti kapigok dunduye, “We, imbi, geŋ susupiŋ.” ");
INSERT INTO naf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kegok zemti met an gakikiŋaŋgalen lue atame an tapummepmambien ekŋenaŋ kot teŋ pemti msalen an gakikiŋaŋ tobewien. Tobeme Zisasiyaŋ kapigok zeye, “An zomolim, geŋ wat!” ");
INSERT INTO naf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kegok zeme gakikiŋaŋaŋ wati yaŋbemti zet zeme Zisasiyaŋ betnanen betnamti mamaŋ saye. ");
INSERT INTO naf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kegok sokbeme am ekŋenaŋ ke ek kiŋgati Kawawaŋgat zemsesewatpemti kapigok zewien, “Golaŋ zenze an temaŋ tuŋgupmnan kapi sokbein ma Kawawaŋ ek amŋane indamukulem mimindein!” ");
INSERT INTO naf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kegok sokbeme keyet zapatnaŋaŋ Zudia msalen palakŋaŋ beye ma msat notnaŋaŋ kegogak nâme delaŋ zemâge. ");
INSERT INTO naf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Âpme Zân mka katikŋan tapme nembaŋaneyaŋ ekmagen koti Zisasiyaŋ kwitnaŋ kwitnaŋ mge keyet zapatnaŋ msawien. ");
INSERT INTO naf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ma egaŋ nembaŋane zut Zisasmagen mebegalen zemideye. Kegok zemti diidome, “Amobotnaŋmagen egat zenânâyelen meseluwen kapigok yaŋkwesiselup, ‘An kokogalen Zânaŋ zeyeen ke geŋ kapi ma ŋen?’ Meti kegok yaŋkwesiselup.” ");
INSERT INTO naf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kegok zemideme egelaŋ Zisasmagen kobunen kapigok yaŋkwesiwun, “Zân tu zulutindende an egaŋ gâgât gayaŋkwesi nânâyelen ndeme kolup, ‘An kokogalen egaŋ zeyeen geŋ kapi ma ŋen?’” ");
INSERT INTO naf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yaŋkwesimalu yegak Zisasiyaŋ kan keyegak am zawat sepem igak igak weyaŋindeye ma we bekanaŋ mâtindeye ma zikalin beŋan zikalin mme ekbien. ");
INSERT INTO naf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kegok tapmme an egelaŋ koti yaŋkwesimalut kapigok diidoye, “It kwitnaŋ kwitnaŋ eknâmâtâlut keyet met Zângat zezapat msamti kapigok dunduselup: ‘Zikalin beŋaŋaŋ zikat taegip, selin wesiŋ ma selin tapmaip ma am liŋgit satnaŋmak mma liŋgilin takŋelun ma wakŋin kekekŋaŋ mma zet tatnâip ma gakikiŋaŋ mma wati tapmaip ma an tototnaŋmagen zet zapatn dolakŋaŋ ekŋenmagen timepme tatnâip. ");
INSERT INTO naf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ma am ŋenaŋ nâgât keŋ zut ku min beme egaŋ oloŋen palen tazin.’ Kegok met Zân dunduselup!” ");
INSERT INTO naf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kegok zemideme Zângalen nemba egelaŋ gilik zemti Zânmagen mepmalut Zisas egaŋ am sambe tabien ekŋen Zângat kapigok diindoye, “In eweŋan Zânmagen betut sinaŋnok tâgâyaŋ kumbume mebe kokot tapme msat tuŋgupman eksât mebien? Yek. Zân ek windeŋepiŋ keboŋ yek. ");
INSERT INTO naf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma in msat tuŋgupman an ŋen kâlâpmaŋ dolakŋaŋ tosaŋaŋ temaŋ ke eksâgât mebien? Yek penaŋ. Nâip, an kâlâwin dolakŋaŋ ekŋenaŋ amobotnaŋnok mka pembenaŋ etaŋ keyet keŋan matalip. ");
INSERT INTO naf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","In zeme nâmbi, in kwileki eegalen otnâmti mebien? In golaŋ zenze an eegalen mebien? Ke penaŋ, ek golaŋ zenze an sambe mambien sebemindein enenogat ek nâlen set weyeyaŋ. ");
INSERT INTO naf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kawawaŋgalen zet zapat itnaŋanen Zângat kapigok zemkawaŋ bembeŋaŋ, ‘Neŋ zapat zenze an pema koti egaŋ kukŋaŋgat meti set neŋmagen keŋin gilik zenzeyelen gâgât weyaŋ be.’ Kawawaŋaŋ kegok zeye. ");
INSERT INTO naf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Neŋ ingat zet penaŋ kapi zesowap, Zân tu zulutindende an egaŋ am sambe msat kataŋ sokbemkwabienen sebemindemti mobotnaŋ penaŋ bein. Yaŋgut am in neŋ napmâti tapmaip in Kawawaŋgalen zemâtâtâtgat katnaŋ ke in weyaŋ eknâmâtâti nâmkiŋpeip keyepm Zân sebem pemti nâmâtâlip.” ");
INSERT INTO naf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Âpme am sambe ma takis mânep titi an ekŋenaŋ Zângat zetnaŋ nâwienen ekŋenaŋ Kawawaŋgalen mama mimi teŋ mâpme egaŋ tu zulutindeye. ");
INSERT INTO naf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yaŋgut Palisi an ma zii zet zikat indanda an ekŋenaŋ Kawawaŋgalen ŋoktik ku mâti wisat mpewien ma ekŋenaŋ Zânmagen tu ku zulubien. ");
INSERT INTO naf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Âpme Zisasiyaŋ pigok zeye, “Neŋ kwilekiŋen am alak talip kapiyelen mama mimiŋin keboŋmak bemzewi? Ekŋen pe ziboŋ? ");
INSERT INTO naf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ekŋen imbi nemba egaŋ silik kume notnaneyaŋ dopmaŋ ku maŋgilik zem kuip. Ma silik kum tasume ku masumpeip. Ekŋen keboŋ. ");
INSERT INTO naf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ma Zânaŋ tu meu ninipiŋ mamayelen set mâpme am sambeyaŋ Zângat kapigok zewien, ‘Ek we bekanaŋmak main!’ ");
INSERT INTO naf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma Angat Nemuŋaŋ neŋ koti tu meu ninipiŋ mamayelen set ku mâpma in nikti nâgât zet kuku mamip ke kapigok, ‘An kapi tu meu temaŋ ma wain tu manin ma mânep takis titi an ma am yomtoŋ ekŋengat nolin!’ Kegok manzeip. ");
INSERT INTO naf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","In nânâŋinmak benak beme nigalen yaŋnit meu ninindaset ma mama mimindaset ekmâtâbiek.” ");
INSERT INTO naf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Âpme Palisi ŋen kwitnaŋ Saimon egaŋ Zisasiyaŋ ekmak meu niniyelen zem mandame mkaŋan moti meu niniyelen munduman totage. ");
INSERT INTO naf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ke motapme mka temanen keyetnaŋ imbi yomtoŋ ŋenaŋ Zisas Palisiyelen mkaen tu meu niniyelen molep zeme nâmti wet kelakŋaŋ sesikŋaŋ dolakŋaŋ tosaŋaŋ temaŋ seŋgewen gak zem tatatnaŋ ke mti ");
INSERT INTO naf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","mot Zisasiyet bamanen setnanen pedondom tati si sume siapmaŋaŋ toti setnaŋ mme tutulupsek beme ŋoksinaŋaŋ kaput pemti setnaŋ nuknuk mpemti wet kelakŋaŋ sesikŋaŋ dolakŋaŋ setnanen mulapme toge. ");
INSERT INTO naf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Imbiyaŋ kegok mme Palisi egaŋ Zisas zem mandame koge egaŋ ke ekti keŋaŋaŋ kapigok otnâye, “Imbi kapi kwitnaŋ kwitnaŋ msain kapi bekanaŋ. An kapi golaŋ zenze an penaŋ benak beme imbi egat setnaŋ taatain keyet yaŋaŋ ŋep ekmâtâdak ma imbi ke imbi yomtoŋ penaŋ ke ŋep nânak!” ");
INSERT INTO naf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kegok otnâme Zisasiyaŋ kapigok dunduye, “Saimon, neŋ zet ŋen zema nâmbak.” Zeme zeye, “An zikat indanda, ŋepgat zemane nâmbi.” ");
INSERT INTO naf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Zeme Zisasiyaŋ pigok yaŋbemti zeye, “An zut ŋenaŋ mânep an mânepmak egalen ŋenaŋ 5000 kina ma ŋenaŋ 50 kina belak mti bam dopmaŋ mututuyelen nâmti mbun. ");
INSERT INTO naf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ya bam koti mânep dopmaŋ sasayelen kanaŋ sokŋan kopme eget mânepmak ku taidaye. Kegogapm mânep toŋaŋaŋ egalen mânep mbun keyet ketalasimidaye. Geŋ nânigen egetmagengatnaŋ kwiyaŋ mânep toŋaŋgat nâmtikŋaŋ mpeye?” ");
INSERT INTO naf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kegok yaŋkwesime Saimonaŋ pigok dunduye, “Neŋ nâyawen an mânep temaŋ mge keyaŋ keŋanen nâmtikŋaŋ penaŋ mpeye.” Kegok zeme Zisasiyaŋ kapigok zeye, “Geŋ ŋep zenik.” ");
INSERT INTO naf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kegok zemti imbimagen gilik zemti Saimon kapigok dunduye, “Imbi pedondom tazin kapi ekdik? Neŋ gâlen mkaen kwalaen geŋ nnaŋgalen set moti tu setn zululugalen ŋen ku nanak. Yaŋgut imbi egaŋ siapmaŋaŋ setn mme tutulupsek beme ŋoksinaŋ kaputnep. ");
INSERT INTO naf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Geŋ nâgât oloŋen mti nuknuk ku mnanak yaŋ imbi egaŋ neŋ kwatapma keyegak yaŋbemti setn nuknuk mpeme tatnup. ");
INSERT INTO naf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Geŋ wet kelakŋaŋmak nâgât ku weyaŋ benak yaŋgut imbi egaŋ wet kelakŋaŋ sesikŋaŋ dolakŋaŋ tosaŋaŋ temaŋ keyaŋ setnnan mulapme tolep. ");
INSERT INTO naf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Neŋ diŋgoma nâmbak, egaŋ ke mip ke egaŋ gogot omba mnep keyaŋ mkawaŋ bep ke yomaŋ sambe delaŋ zep. Yaŋgut am ŋenaŋ nâme yomaŋ isikŋaŋ bugan Kawawaŋaŋ yomaŋ ke katikpenak manâin beme ekmagen gogot isikŋaŋ bugan tasain.” ");
INSERT INTO naf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kegok zemti imbiyet kapigok dunduye, “Yomdi katikpeyap.” ");
INSERT INTO naf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kegok zeme am notnaŋ tu meu ilinsakwep nimti tabien ekŋenaŋ yaŋbemti nânâŋinaŋ kapigok otnâwien, “Ek kapi am yomin ŋep ku katikpepeyelen. Ek dâsuki tazen.” ");
INSERT INTO naf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ekŋenaŋ kegok otnâme Zisasiyaŋ imbi ke pigok dunduye, “Nâmkiŋpependaŋ gapmukulem mme keŋdi sewakŋaŋ beme met mamambanik.” ");
INSERT INTO naf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kan keyet palaŋan Zisasiyaŋ Galili msalen mka teman ma isikŋan sambe mameti am Zet Zapat Dolakŋaŋ Kawawaŋgalen zemâtâtâtgat katnaŋ mama kanaŋ bududuk bein ke diindom mege. Ma nembaŋane 12 ilinsakwep mamtemien ");
INSERT INTO naf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma imbi notnaŋ kegogak indamât mebien. Imbi ekŋen ke Zisasiyaŋ eweŋan we bekanaŋmak ma zawalinmak mâtindeye. Ekŋen ke kwilin kapi: Malia ek Makdala mka temangatnaŋ ekmagen we bekanaŋ 7 Zisasiyaŋ mâpeye. ");
INSERT INTO naf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ma ŋen kwitnaŋ Zoana apmaŋ kwitnaŋ Kusa ek Elotgalen mkayelen an damuŋ matatan. Ma imbi ŋen kwitnaŋ Susana ma imbi sambe notnaŋ mânep milawalin ilinaŋgalenaŋ Zisas ma nembaŋane indamukulem mbien. ");
INSERT INTO naf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Âpme mka temaŋ ŋen mka temaŋ ŋen keyelen am sambe penaŋ Zisasmagen koondakti tapme indikti egaŋ bemzenze zet kapigok zeye, ");
INSERT INTO naf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“An ŋenaŋ wit katnaŋ muluwen time mekokogalen mege. Meti wit katnaŋ msalen time mekogeen notnaŋ selen totem mepme amnaŋ mekoti selaŋ dukŋan ime ageyaŋ ekti onimbien. ");
INSERT INTO naf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sepem kegogak wit katnaŋ notnaŋ msat memuŋaŋ nanzaŋ keŋan totemepme dukŋaŋaŋ pataŋ zem kwageyaŋgut kasuwaŋ ekme memuŋ beye enenogat msat ke nanzaŋ kuluŋ kâlâŋ. ");
INSERT INTO naf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma wit katnaŋ notnaŋ nusi keŋan totem mege. Keyet dukŋaŋaŋ pataŋ zem kwapme nusiyaŋ mzilime eiŋeiŋ simti ku kwage. ");
INSERT INTO naf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma wit katnaŋ notnaŋ msat kelakŋaŋmagen toti kwati penaŋaŋ sambe penaŋ sokbeye. Yaŋaŋ kwep kwepgat penaŋaŋ keŋan katnaŋ sambe sopmaŋ kegok elik mâge.” Zisasiyaŋ zet kegok zemdelaŋ zemti zeye, “An ŋen zet nânâyelen tikŋaŋaŋ tazinaŋ zet kapi ŋep opeimti nâsem.” ");
INSERT INTO naf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Âpme Zisasiyet nembaŋane ekŋenaŋ bemzenze zet keyet yaŋaŋ nânâyelen yaŋkwesime ");
INSERT INTO naf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","egaŋ diindoye, “Kawawaŋaŋ in zet enzilim tazin sambe keyet yaŋaŋ ŋep nânâyelen nâmpepeŋaŋ enenogat bemzenze zet sambe keyaŋ Kawawaŋgalen zemâtâtâtgat katnaŋ mama kanaŋ bududuk bein ke mkawaŋ tabein yaŋgut am ekŋenmagen bemzenze zet etaŋ bewe, eneyet keŋin keyet eyak ku bemindain keyet penaŋ, ‘Am ŋenaŋ zikat eek ektiŋgut kwitnaŋ kwitnaŋ ku maekmâtâlip ma ekŋenaŋ nânâ nâmtiŋgulak yaŋaŋ ku nâmâtâbep.’ Sepem golaŋ zenze an itnaŋaŋ ekŋenaŋ zet bam sokbewe zewien kegok. ");
INSERT INTO naf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bemzenze zet zeya keyet yaŋaŋ kapigok, wit katnaŋ keyaŋ Kawawaŋgalen zetnaŋ bein. ");
INSERT INTO naf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ma wit katnaŋ selen totem mege ke sepemaŋ am Kawawaŋgalen Zet Zapat Dolakŋaŋ manâip yaŋgut Sadaŋaŋ koti Kawawaŋgalen Zet Zapat Dolakŋaŋ nâwienen ke mme Kawawaŋgat ku nâmkiŋpepeyelen ma ekmagen keŋin ku gilik zenzeyelen masokbein. ");
INSERT INTO naf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma wit katnaŋ nanzaŋ palen toweŋge ke sepemaŋ am ekŋen keboŋaŋ Zet Zapat Dolakŋaŋ nâmtikŋaŋ mti oloŋen palen mmambep yaŋgut kindiŋaŋ msat keŋan baen penaŋ ku towege ke am Zet Zapat Dolakŋaŋ keŋinanen katikŋaŋ ku tageyepmti nukŋaŋ sambe ma sisipeŋpeŋ sambeyaŋ kwabeen nâmkiŋpepeŋin mme towembe. ");
INSERT INTO naf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma wit katnaŋ notnaŋ tek kukŋaŋmak keŋan totemege ke sepemaŋ am ekŋen Zet Zapat Dolakŋaŋ nâmbewaŋgulak kwitnaŋ kwitnaŋgat yayaŋ omba penaŋ mamip ma mânep milawatgat kandaŋan mamelip ma segesetgalen kwitnaŋ kwitnaŋgat oloŋen mti ilinaŋgat etaŋ maotnâip. Mama mimiŋin keboŋ keyaŋ nâmkiŋpepeŋin mme ku mkatikŋaŋ beme towembep. ");
INSERT INTO naf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma wit katnaŋ notnaŋ msat kelakŋaŋmagen totemege am ekŋen keboŋaŋ Zet Zapat Dolakŋaŋ nâmti mkatikŋaŋ bemti mambep. Ma Kawawaŋgalen zezapat pembenaŋ am notnaŋmagen zemkawaŋ beme am ekŋen keyaŋ kegogak nâmkiŋpewep. ");
INSERT INTO naf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Âpme amnaŋ lam koŋ bemti menzimaŋ dukŋan ku makwalapenup ma mundum wewe kandaŋan ku mambepenup. Nin lam koŋti munduman tatatnanen sosok bempemann tapme am mka keŋan matalip mbusatnaŋ mambemindein. ");
INSERT INTO naf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nâlen zetn ke lam nemboŋ keyepmti in nâlen zetn zemkawaŋ bewep beme nânâ enziliŋaŋ matazin ke ewe ku enzilim tabe ma nânâ kwatam tazin mâtâpeme kawaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Keyepmti in weyaŋ nâmâtâbep enenogat am ŋen Kawawaŋgalen zetnaŋ nâmti nâmtikŋaŋ mbe beme Kawawaŋaŋ nânâŋaŋ ewe tusumti sawe keyepm egaŋ nânâŋaŋ sambe penaŋ tasawe. Ma am ŋenaŋ zetnaŋ nâmti nâmtikŋaŋ ku mbe beme Kawawaŋaŋ nânâŋaŋ isikŋaŋ ekmak tasain ke menzem mbe.” ");
INSERT INTO naf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Âpme Zisasiyet mam notnane ekŋenaŋ Zisas eksâgât kobien yaŋgut am sambeyaŋ ekmagen kot bembuluŋ tabiengapm mamnotnaneyaŋ kot olati belak ganzenan tabien. ");
INSERT INTO naf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kegok mme an ŋenaŋ indikti Zisas kapigok met dunduye, “Mamnodine ekŋenaŋ giksâgât koloyaŋ olati mka tambagumen baen talip.” ");
INSERT INTO naf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kegok zeme Zisasiyaŋ nâmti am ekŋen kapigok diindoye, “Am Kawawaŋgalen zet nâmti maŋgawepup ekŋenaŋ nâgât mam notnne beip.” ");
INSERT INTO naf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kasup ŋengat Zisas ma nembaŋane ilinsakwep waŋgaen motati egaŋ kapigok diindoye, “Kame nin tundua kutumti tundua nembet daeset metne.” Kegok zemnâmti yaŋbemti mebien. ");
INSERT INTO naf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tapmepmambe Zisas melukgapmti waŋgaen meluk weŋge. Taweme tâgâ temaŋ penaŋ kwati tundua mamaŋ temaŋ kumbume waŋga keŋan tuyaŋ towepme waleletgalen mbien. ");
INSERT INTO naf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kegok sokbeme nembaŋane ekŋenaŋ met butemti zewien, “An zikat indanda! Tundua keŋan towesât tapmnupgat wat ndaaŋgalaŋ nde!” Kegok zeme egaŋ wati tâgâ temaŋ ma tundua mamaŋ zemkulumideme egat zetnaŋ gawepumti tunduayaŋ titokŋepiŋ penaŋ tage ma tâgâyaŋ diŋpeye. ");
INSERT INTO naf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mti ekŋengat kapigok diindoye, “In nâmkiŋpepeŋin yek, ma?” Kegok zeme nemba ekŋenaŋ menok ke ekti kiŋgati nâmtemtem mti ilinak kapigok zenâwien, “An kapi kwi penaŋ? Egaŋ tâgâ ma tundua mamaŋ zeme zetnaŋ gawepulup!” ");
INSERT INTO naf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Âpme ekŋenaŋ ke metneti met tundua kutumti Galili msat tundua nembet met Gadala msalen am ekŋenmagen met pataŋ zewien. ");
INSERT INTO naf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","30","Ke meti Zisasiyaŋ keŋan mowepme mka keyetnaŋ an ŋen we bekanaŋ sambemak keyaŋ koti Zisas aikge. Egaŋ talak kwisiŋ mamkwage ma mkaen ku mawemtan, egaŋ am sumen kileŋ kileŋ mamamtan. We bekanaŋ an ke kan sambe ek damuŋ mme amnaŋ setnaŋmak betnaŋmak senaŋ zampeme mitim yaloŋti msat tuŋgupman makunzuŋ metan enenogat we bekanaŋaŋ winde same ke mamtan. Âpme we bekanaŋ an keyet keŋaŋ tabienaŋ Zisas ekti ekŋenaŋ egat kwizet ŋakŋak temaŋ kumti an ke msalen mkutum peme Zisasiyet kandaŋan pedondom samti zet omba kapigok zenzeyet zeme zeye, “Zisas geŋ Kawawaŋ Temaŋgalen Nemuŋaŋ penaŋ, geŋ ninmagen mulup msâpmnik ke nin ŋep nânup keyepm nin gâgât gawekunup keyet geŋ nin sindem temaŋ ndandapiŋ.” Zeme Zisasiyaŋ we bekanaŋ an ke keyet keŋan tageengat yaŋaŋ nâsâti an ke yaŋkwesiye, “Geŋ kwidi kwi?” Yaŋkwesime zeye, “Neŋ kwitn Sambe Sopmaŋ Penaŋ.” We bekanaŋ sambe penaŋ egat keŋan matatemien keyepm egaŋ kegok zeye. Zeme Zisasiyaŋ we bekanaŋaŋ, “Anmagengatnaŋ kwaweti mebegat,” zeme nâmti we bekanaŋaŋ ");
INSERT INTO naf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Zisas wekum samti zewien, “Geŋ nin ndapmâti ndemane we bekanaŋ nnaŋgalen mundum bekanan ke mebepiŋ.” Kegok zewien. ");
INSERT INTO naf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Âpme msat keyet bo maŋge temaŋ kalaŋ nembeleset tati meu tatnimmambien keyepm we bekanaŋ ekŋenaŋ Zisas wekumsamti egaŋ ŋep nâmindeme boyet keŋinan ŋep metobiek keyet yaŋkwesim nâwien. Yaŋkwesime Zisasiyaŋ nâmindeme ");
INSERT INTO naf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","we bekanaŋaŋ anmagengatnan kwati bo keŋinan towepmâbien. Kegok mme bo maŋge temaŋ ekŋenaŋ kagwiliŋti windem bemti ŋandaŋen palamtoti tunduaen toti tu nimti gakimâbien. ");
INSERT INTO naf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Âpme bo damuŋ ekŋenaŋ muluwaŋ sokbeye ke ekti kunzuŋti mka teman ma isikŋan meti keyet zezapat zeme nâmâbien. ");
INSERT INTO naf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Menzeme nâmti ekŋenaŋ mka katipemti kwitnaŋ kwitnaŋ sokbeye ke eegalen mebien. Meti ekŋenaŋ Zisasmagen pataŋ zemti ekme an we bekanaŋmak mamtan piwan we ekŋenaŋ peme mopme egat ŋoktikŋaŋ ŋep beme saŋgum melakandu miakti Zisasiyet setnanen totapmaŋge. Ekŋen ma bo damuŋ ilinsakwep ke koekti nâmtemtem mti kiŋgabien. ");
INSERT INTO naf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Âpme am ke tati ekme an we bekanaŋmak mamamtanaŋ pembenaŋ beye keyet zapat mimindamâbien. ");
INSERT INTO naf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ekŋenaŋ ke eknâmti Zisasiyaŋ Gadala msat katipemti mebegalen zempewien enenogat ekŋen kiŋgagalaŋ penaŋ indaige keyepmti Zisas ma nembaŋane ekŋen ilinsakwep waŋga keŋan moti mebegalen motapme ");
INSERT INTO naf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","an we bekanaŋmak Zisasiyaŋ mâpeye egaŋ Zisasmak mebegalen wekumsamti zeye, “Neŋ nâmnemane geŋmak mebi.” Yaŋgut Zisasiyaŋ ŋep ku zemti ");
INSERT INTO naf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","kapigok zempeye, “Geŋ mka temaŋdan gilik zem meti Kawawaŋaŋ muluwaŋ geŋmagen mge keyet kwizapatnaŋ mpalakŋaŋ bewanik.” Zeme nâmti an egaŋ gilik zem meti Zisasiyaŋ ek weyaŋpeye keyet zet zapatnaŋ amŋane diindomâge. ");
INSERT INTO naf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Âpme Zisasiyaŋ tundua nembet gilik zem kogeen am sambe egat olim peme koge enenogat ekŋenaŋ egat damuŋ matatemien. ");
INSERT INTO naf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kotapme sesewat mka isikŋaŋ amobotnaŋ ŋen maŋge kwitnaŋ Zailas egaŋ Zisasiyet kandaŋan pedondom samti egalen mkaen mebegalen wekumsaye. ");
INSERT INTO naf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Enenogat ek nembaŋaŋ imbi kwewetaŋ egat nup kanaŋ 12 etaŋ keyaŋ zawat nukŋaŋ gakikiyelen katnan tage. Tapme Zisasiyaŋ selen tapmepme am maŋge temaŋ ekmak bembuluŋti tapmepmambien. ");
INSERT INTO naf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tapmepmambienen tuŋguwinangatnaŋ imbi ŋen sipmaŋ nup kan 12 sipmaŋ omba penaŋ belak makwawetan. Egaŋ mânep milawatnaŋ ilindiŋ dokta ekŋen indame weyaŋpepeyelen nâmti indame ekŋenaŋ ŋep ku weyaŋpewien. ");
INSERT INTO naf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Âpme imbi keyaŋ am ekŋengat tuŋguwinaset moti Zisas bamanen meti kolopmaŋ butnaŋ atame sipmaŋ keyegak katiye. ");
INSERT INTO naf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mme Zisasiyaŋ ke nâmti zeye, “Am kwiaŋ natain?” Am sambeyaŋ, “Nin yek,” zemâbien. Zeme Pitayaŋ zeye, “An zikat indanda, am sambeyaŋ gambembuluŋti geŋmagen watakumti tatalip.” ");
INSERT INTO naf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yaŋgut Zisasiyaŋ zeye, “Am ŋenaŋ natame windennaŋ mepme nâyap.” ");
INSERT INTO naf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Âpme imbiyaŋ ke eknâyeen ilak mkawaŋ beip nâmti koti sebet diŋdiŋ mti Zisas setnaŋ kandaŋan beŋgumen gunduŋti am sambe zikalinan yaŋaŋ kwilekiyet mti ataye ma zawatnaŋ keyegak ŋep beye keyet zemkawaŋ beye. ");
INSERT INTO naf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mme Zisasiyaŋ egat kapigok zeye, “Ipm, yayaŋ mimipiŋ, geŋ nâmkiŋnenakgapm mma ŋep benik. Keyet keŋdi sewakŋaŋ beme meti mambanik.” ");
INSERT INTO naf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zisasiyaŋ kegok zemti tapme sesewat mkayelen amobotnaŋmagen an ŋenaŋ buŋam zet mkoti kapigok dunduye, “Nembandi ilak gakip, keyet an zikat indanda ku zempeman kolak.” ");
INSERT INTO naf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yaŋgut Zisasiyaŋ zet ke nâmti Zailas kapigok dunduye, “Geŋ kiŋgagapiŋ nâmkiŋpependi mkipmaŋ bemane egaŋ ŋep alik besem.” Zisasiyaŋ Zailasiyet kegok zeme nâme mebien. ");
INSERT INTO naf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Meti ekŋenaŋ Zailasiyelen mkaen mepataŋ zemti Zisasiyaŋ am mka keŋan mobogalen indaombeyeen: Pita ma Zân ma Zems ma mambipmanet ekŋen etaŋ mobogalen zemti notnaŋ zemkulumindeye. ");
INSERT INTO naf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kegok mti am si zesu zesu imbi nemba gakiye keyet tapmambien ekŋen Zisasiyaŋ kapigok diindoye, “In ku suit, imbi nemba ek ku gakip ek belak meluk etaŋ tawen.” ");
INSERT INTO naf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kegok zeme ekŋenaŋ penaŋ gakip ke nâmkatik bemti egaŋ zet zeye keyet zeyeŋ temaŋ yeŋbien. ");
INSERT INTO naf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kegok mme Zisasiyaŋ imbi nemba gakikiŋaŋaŋ tawemaŋgeen mka keŋan moweti imbi nemba keyet betnan atamti zet omba mmoti zeye, “Imbi nemba, geŋ wat.” ");
INSERT INTO naf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kegok mme mamaŋaŋaŋ gilik zeme egaŋ keyegak dendaŋ wage. Mme Zisasiyaŋ mamaŋ bipmaŋgat meu notnaŋ sait zemideme sawun. ");
INSERT INTO naf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Zisasiyaŋ kegok mme mamaŋ bipmaŋaŋ nâmtemtem penaŋ mbun. Âpme Zisasiyaŋ mamaŋ bipmaŋgat am ŋengat kwitnaŋ kwitnaŋ sokbeye keyet ku zenzeyelen zemkulumideye. ");
INSERT INTO naf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Âpme Zisas ek nembaŋane 12 zeme kot ondek tapme we bekanaŋ amgat keŋan mâtindendeyelen ma am zawalin sepem igak igak mme alik bembeyelen winde ke talasim indamâge. ");
INSERT INTO naf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mti indeme Kawawaŋgalen zezapat dolakŋaŋ diindomti Kawawaŋ ekŋenmak keŋinan damuŋ msâpm ke diindowep. Ma zawatmak weyaŋindendeyelen zezapat mindamti zemindeme mebien. ");
INSERT INTO naf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kegok zemti zemâtâtindeye, “In selen mesâpmti kwitnaŋ kwitnaŋ ŋen ku timebep. Am in indamukulem mbep ekŋen keyaŋ in indikdamuŋ mbep keyepm toŋge ma ele ma tu meu ma mânep ma melakandu zut ku timebep. ");
INSERT INTO naf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma mka temaŋ ŋen mobep beme an ŋenaŋ ingat egalen mkaen tatagalen indamandame ekmak etaŋ tati mebep. Mneti in selak selak mame mka toŋaŋaŋ, ‘Nâgât wisat mip,’ nâmindeweyet. ");
INSERT INTO naf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma in mka temaŋ ŋen pataŋ zeme am ekŋenaŋ ingalen zet ku nâmti mka weweyelen ku indame keyet Kawawaŋaŋaŋ ekŋengalen mama mimi keboŋ keyet ŋenzinziŋ min nânâyelen zipelukŋin seŋti ke ku gilik zem kobep.” ");
INSERT INTO naf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kegok zemdiindome ekŋenaŋ Zisas pemeti mka ŋande ŋen ŋen meti Zisas Kilaisiyelen zezapat dolakŋaŋ diindomti am zawatmak weyaŋ indemâbien. ");
INSERT INTO naf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Âpme Galili msalengalen amobotnaŋ kwitnaŋ Elot egaŋ Zisasiyaŋ menok igagen mme keyet zapatnaŋ nâmti, “Wa Zân tu zulutindende an gakikiengatnaŋ gilik zem koti mamaŋaŋ tin.” Kegok zeme nâŋge. Kegok nâme notnaŋaŋ, “Golaŋ zenze an Ilaiza ewe sokbemti tapmain,” zewien ma notnaŋaŋ, “Golaŋ zenze an itnaŋaŋ ŋenaŋ mamaen gilik zem koti tapmain,” nâwien. Kegok zeme Elolaŋ nâmti keŋ sindem palen tati kapigok zeye, “Zân ek neŋ zema bimaŋ eleŋgewien. Âpme an ke kwiyaŋ kegok mme neŋ zapatnaŋ tatnâyap?” Kegok zemti Zisas eegalen penaŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Âpme nembaŋane ekŋenaŋ gilik zem koti kwitnaŋ kwitnaŋ mmebien keyet zezapat Zisas msamâbien. ");
INSERT INTO naf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kegok dundume nâme ilinsakwep mepme am sambe penaŋ ekŋenaŋ mebienen ke nâmâtâti indamâti mebien. Egaŋ ŋep nâmindeme Kawawaŋgalen zemâtâtâtgat katnanen mama ke zemkawaŋ bemindaye ma am zawalinmak notnaŋ weyaŋindeye. ");
INSERT INTO naf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kegok tapmnepeme kasup zikatnaŋ towesâgât mme nembaŋane 12 ekŋenaŋ Zisasmagen koti zewien, “Kapi msat tuŋgupman penaŋ tatnup keyet geŋ am indemane mka temanen ma isikŋanen mekoti tu meu ma mka weweyelen aikseip.” ");
INSERT INTO naf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kegok zeme Zisasiyaŋ kapigok diindoye, “In ilin meu aik indait.” Kegok zeme ekŋenaŋ zet dopmaŋ kapigok gilik zemti zewien, “Ninmagen nupmamaŋ kumbuŋaŋ isisikŋaŋ 5 ma aŋgala sonaŋ isisikŋaŋ zut etaŋ tatndain.” Kegok zemti egat yaŋkwesiwien, “Geŋ nin am sambe penaŋ kapiyet meu mekwiti kokogalen tazenik?” ");
INSERT INTO naf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Âpme am tabienen ke an etaŋ indamakume 5000 kegok beye. (Âpme imbi ma nemba isisikŋaŋ ku indamakukuŋaŋ.) Âpme Zisasiyaŋ nembaŋaneyet kapigok zeye, “Am ekŋengat zeme maŋge kwep kwepgat keŋan am makume 50 50 kegok totaseip.” ");
INSERT INTO naf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Zeme nembaŋaneyaŋ egat zetnaŋ nâmti am ekŋen egaŋ zemindeye keyet kataŋ zeme totabien. ");
INSERT INTO naf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Totapme Zisasiyaŋ nupmamaŋ 5 ma aŋgala zut ke mti zikatnaŋ kululuŋen ekme mopme Kawawaŋgat, “Wisikŋ,” zemti meu ke mutumti nembaŋane indame ekŋenaŋ am ekŋen kalaŋkum indawien. ");
INSERT INTO naf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kegok mme ekŋenaŋ nimwiaŋti butnaŋ notnaŋ tapmege ke nemba ekŋenaŋ makumti beme tise 12 gak zem tage. ");
INSERT INTO naf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Âpme kan ŋengat Zisasiyaŋ igak dundundu mulup tapmaŋgeen nembaŋane ekŋenaŋ ekmagen mebien. Mepme egaŋ kapigok indayaŋkwesiye, “Amnaŋ nâgât kwi manzeip?” ");
INSERT INTO naf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kegok zeme nembaŋane ekŋenaŋ kapigok dunduwien, “Notnaŋaŋ gâgât Zân tu zulutindende an manzeip. Ma am notnaŋaŋ gâgât Ilaiza manzeip. Ma am notnaŋ golaŋ zenze an itnaŋaŋ ŋenaŋ mamain gilik zem kolep manzeip.” ");
INSERT INTO naf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kegok zeme Zisasiyaŋ nâmti ekŋengat zeye, “Âpme in nâgât an kwi manâip?” Egaŋ kegok indayaŋkwesime Pitayaŋ zeye, “Geŋ Kawawaŋaŋ ombemgeme am yomengatnaŋ indatitiyelen kobanan. An Kilais ilak geŋ ke.” ");
INSERT INTO naf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kegok zeme Zisasiyaŋ am notnaŋgat zet ke ku zenzeyelen zemkulumindeye. ");
INSERT INTO naf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Zemkulumindemti egaŋ ewe tusumti zeye, “Sesewat mka temaŋgalen an damuŋ ma sâpe sâpe bumbuyelen ŋeŋaŋin ma zii zet zikat indanda an ekŋenaŋ nâgât ku nâmtikŋaŋ mti Angat Nemuŋaŋ neŋ sindem temaŋ nambep. Neŋ nome gakimti kasup zut delaŋ zeme tugat yaŋbembeŋan ewe gilik zem mamaen wabap.” ");
INSERT INTO naf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma egaŋ ewe ekŋengat zet ŋen kapigok zeye, “Am ŋenaŋ neŋmagen tususâgât mbe beme egaŋ ikŋaŋgat sekŋaŋ mtoti segalen kwitnaŋ kwitnaŋgat ku nâmtikŋaŋ mti egaŋ kasup kataŋ sindem temaŋ Angat Nemuŋaŋ neŋ tiwap sakam keboŋ timti namâbe. ");
INSERT INTO naf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ma am ŋenaŋ sekŋaŋgat yayaŋ mti Kawawaŋgalen Zet Zapat Dolakŋaŋ ku mkawaŋ bewe beme egaŋ mama kanzizit ku tiwe. Yaŋgut am ŋen egaŋ sekŋaŋ nâgât talasiwe beme mama kanzizit mama ke ŋep tiwe. ");
INSERT INTO naf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Am ŋen ek msat kapiyelen milom bilombi sambe ke tim nalak nalak maminepeme mamaŋaŋ yuŋgume ek keyaŋ walebe. Msalengalen kwitnaŋ kwitnaŋ keyaŋ zigok mukulem mme mama kanzizit tiwe? Kegok ŋep yek. ");
INSERT INTO naf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Am ŋenaŋ nâgât ma zezapatn dolakŋaŋgat sakambuk mbe beme Angat Nemuŋaŋ neŋ kegogak kobawen an ke sakambuk mpewap. Neŋ ensel teŋmak gilik ze kobap. Ma Bipmnaŋgalen windeŋaŋ ma busatnaŋaŋ nasumuŋme kobap. ");
INSERT INTO naf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Neŋ zet penaŋ zema nâit, am in talip inmagengatnaŋ notnaŋ ku gakimti tapmoti ekme Kawawaŋgalen zemâtâtâtgat katnanen mama ke sokbesâpm.” ");
INSERT INTO naf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Âpme Zisas ek zet kegok zemti tapme sonda kwep delaŋ zeme dundundu mulup msâgât nembaŋane Pitamak, Zânmak Zemsmak indatimti kalaŋan dundusâgât mowebien. ");
INSERT INTO naf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Moti kan keyet tadundumaŋgeen ikŋaŋgat zimosetnaŋaŋ sepemaŋ kasupgalen busatnaŋ nemboŋ beye ma kâlâpmaŋ teepmaŋaŋ satnaŋ leŋganaŋ penaŋ bemti tage. ");
INSERT INTO naf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Keyegak an zulaŋ ekmak tati zet zenâ zenâ mbien. An zut ke Mosesimak Ilaizamak egelaŋ ");
INSERT INTO naf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","kululuŋengatnaŋ saŋga soŋgaŋitmak kotati Zisasiyaŋ Zelusalem mka teman gakiwe keyelen zezapat msamti Kawawaŋgalen nânâ ekmagen sokbewe keyet zemkawaŋ bempewun. ");
INSERT INTO naf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ma notnane zut ekŋenaŋ meluk temaŋ wembien yaŋgut wati Zisas saŋga soŋgamak tapme an zut ekmak tapmalut ke ekbien. ");
INSERT INTO naf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ekŋenaŋ ke ekme an zut keyaŋ yaŋbemti Zisas pemesâgât tapmmalut Pitayaŋ Zisasiyet kapigok zeye, “An zikat indanda, kapi dolakŋaŋ penaŋ tatnup keyepm nâmane mka mzalaŋ tuk walatne gâgât ŋen Mosesiyet ŋen ma Ilaizayet ŋen.” (Egaŋ zet ke yaŋaŋ ku nâmâtâti zet kegok zeye.) ");
INSERT INTO naf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kegok zeme keyegak zanza sepemaŋ ŋen busatnaŋmak keyaŋ ekŋengat dukŋinaset kwatoti an ekŋen tuk kululuŋgalen busatnaŋmak tabien ekŋen indasumuŋme Zisasiyelen nembaŋane tuk ekŋenaŋ ke ekti kiŋgati sebelaŋ dindiŋ mbien. ");
INSERT INTO naf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kegok sokbeme zet ŋande ŋen zanza keŋaset kapigok zeme ekŋenaŋ nâwien, “Kapi nâgât Nemun penaŋ; nen ombempewan. In egat zetnaŋ nâmti gawepuwep.” ");
INSERT INTO naf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Âpme ekŋenaŋ zet ke nâmti ekme Zisas igak tapme ekbien. Kegok sokbeme nemba tuk ekŋenaŋ kwitnaŋ kwitnaŋ sokbeye ke ekti kan keyet am ŋengat diindondopiŋ; keŋinan etaŋ bemti mamtemien. ");
INSERT INTO naf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ekŋenaŋ ke tatneti tapme miya balaŋ peme ekŋenaŋ kalaŋangatnan topme an imbi sambeyaŋ meti Zisasmak selen kumaikbien. ");
INSERT INTO naf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Âpme keyegak am ekŋengat tuŋguwinaŋgatnaŋ an ŋenaŋ Zisasiyet kapigok kwizet temaŋ kumti zeye, “An zikat indanda, ekbak, neŋ gâgât gawekuyap neŋ nemun ma namban sambe ku talip. Nemun kwewetaŋ kapi mukulem mpesenik.” ");
INSERT INTO naf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kegok zemti ewe zeye, “We bekanaŋ egat keŋan metoweti mme egaŋ kaŋkaŋ kumti endilipemti katik katik sim zawak sala kalak kalak mam. Ma we bekanaŋaŋ mse kwep kwepgat pemesâpmti nemba ke kumsagat omba penaŋ mpemti mamezin. ");
INSERT INTO naf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Âpme neŋ nembandine ekŋenaŋ we bekanaŋ mâbâgat indawekuma ekŋenaŋ mim aleo.” ");
INSERT INTO naf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Egaŋ kegok zeme Zisasiyaŋ am sambe tabien ekŋengat kapigok zeye, “In nâmkiŋpepeŋinpiŋ, ma? In set teŋ ku mamâlip! Neŋ inmagen menok igak igak mma in ewe Kawawaŋgalen windeyet ku nâmkiŋpeip.” Kegok zemti nemba keyet bipmaŋgat zeye, “Nemundi neŋmagen tetim kot.” ");
INSERT INTO naf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kegok zeme nembayaŋ takopmaŋgeen we bekanaŋaŋ mme nemba keyaŋ msat palen kutumti katik katik sim zawak sala kalak kalak mge. Kegok mme Zisasiyaŋ ke ekti we bekanaŋaŋ nemba ke pemti mebegalen zempeye. Kegok sokbeme nemba keyaŋ alik bemti wati bipmaŋaŋ tapmaŋgeen mege. ");
INSERT INTO naf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kegok sokbeme am sambe ekŋenaŋ Kawawaŋgalen winde temaŋ ke ekti nâmtemtem penaŋ mbien. Ke sokbeme am ekŋenaŋ Zisasiyaŋ mulup mge keyet ewe nâmtemtem tapmme egaŋ nembaŋaneyet kapigok diindoye, ");
INSERT INTO naf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Neŋ zet diindosowap kapi in kandadapiŋ! An notnaŋaŋ neŋ Angat Nemuŋaŋ natamti amobotnaŋ windemak ekŋengalen belinan nemti nome gakiwap. Ke amgat nânâyet yek; Kawawaŋ ikŋaŋgat nânâyet kok sokbewe.” ");
INSERT INTO naf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kegok zeme nembaŋane ekŋenaŋ zet keyet yaŋaŋ ku nâmâtâbien. Zet yaŋaŋ ke nukŋaŋ penaŋ; ku nâmâtâtâgalen Kawawaŋaŋ nâmpeye. Ma ekŋenaŋ kegogak zet keyet egat yaŋkwesisiyet kiŋgabien. ");
INSERT INTO naf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Âpme nembaŋane ekŋenaŋ ilinak an kwi egaŋ amobotnaŋ bewe keyet mdândâwien. ");
INSERT INTO naf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kegok tapme Zisasiyaŋ keŋinan indik mâtâti nemba isikŋaŋ ŋen mti ikŋaŋgat ganzenan pemti ");
INSERT INTO naf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ekŋengat kapigok zeye, “An ŋen nemba isisikŋaŋ nâgât mti zem oloŋen mpewe egaŋ neŋ zem oloŋen mnein sepem keboŋ bein. Ma an ŋen neŋ zem oloŋen mnewe egaŋ kegogak an neme kobanen ke zem oloŋen mpewe. Keyepmti in nemba isikŋaŋnok tototnaŋ mamambep beme Kawawaŋgat zikatnan mobotnaŋ bewep.” ");
INSERT INTO naf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Âpme Zânaŋ Zisasiyet zeye, “An zikat indanda, nin an ŋenaŋ gâgât kwidan kumti we bekanaŋ mâpeme ekti ninmak kumamaingapmti zemkulumpenn.” ");
INSERT INTO naf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kegok zeme Zisasiyaŋ Zân ma nembaŋane notnaŋ ekŋengat pigok diindoye, “An ŋen ingat ku zemtalatindein ek ingat nolin kegok nâmpeip keyepm in zemkulumpepepiŋ.” ");
INSERT INTO naf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Zisas ek kululuŋen gilik zemti mobogalen kanaŋ sokŋan beme Zelusalem mkaen mobogalen ikŋaŋ nâmdelaŋ pemti mege. ");
INSERT INTO naf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nâmdelaŋ pemti an notnaŋ egaŋ mebegalen zemindeme busup zet mmebien. Kegok zemindeme meti Samalia msalen mka temaŋ ŋenmagen met pataŋ zemti Zisasiyet mka ma kwitnaŋ kwitnaŋ aik sasayelen busup zet am ekŋen diindowien. ");
INSERT INTO naf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yaŋgut Samalia am ekŋenaŋ Zuda am ekŋenmak ku sekbem maip keyepm ekŋenaŋ ek Zelusalem mka temanen dundundu mulup msât kozin kegok nâwien. ");
INSERT INTO naf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Zisas ma nembaŋane ekŋenaŋ Samalia msalen mka teman kokogalen sokŋanik kopme an ekŋen busup zet mkobien ekŋenaŋ zet nembelen dopmaŋ diindowienen ke nâmkoti Zisas ma nembaŋane koindaikti diindomti zemkulumindewien. Kegok zeme Zems ma Zânaŋ eknâmti egelaŋ Zisasiyet kapigok zewun, “Amobotnaŋ geŋ nâmane kululuŋengatnaŋ teziŋ zemalut toti indembuk ma geŋ zigok nânik?” ");
INSERT INTO naf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kegok zemalu Zisasiyaŋ egegat gilik zemti musuwawat zet diidoye. ");
INSERT INTO naf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kegok zeme ekŋenaŋ mka temaŋ ke pemti mka temaŋ ŋen mebien. ");
INSERT INTO naf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tapmetnepeme an ŋenaŋ Zisasmagen koti kapigok dunduye, “We, geŋ deset ma deset mesâgât mmane neŋ gamâpmebap.” ");
INSERT INTO naf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kegok zeme Zisasiyaŋ kapigok dunduye, “Neŋ namâti mamayelen ŋep yaŋgut nukŋaŋ temaŋ penaŋ titiyelen. Zit ekŋen mkaŋinmak ma age ekŋen kegogak mkaŋinmak yaŋgut Angat Nemuŋaŋ neŋ mka ma mundum weweyelen ku wemnain.” ");
INSERT INTO naf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Âpme Zisasiyaŋ an ŋen ekti kapigok dunduye, “Geŋ koti neŋmagen tusum kot.” Zeme an egaŋ Zisas kapigok dunduye, “Amobotnaŋ, nâmnemane meti bipm zawalen tazin ya mmalema gakime mzilimtiŋgut gilik ze kobap.” ");
INSERT INTO naf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Zeme Zisasiyaŋ egat kapigok dunduye, “Geŋ pemane am ku napmâlip ekŋenaŋ bipdi gakime bewep. Yaŋgut geŋ meti Kawawaŋgalen zemâtâtât katnanen mama keyet zetnaŋ ammagen zemkawaŋ bemebanik.” ");
INSERT INTO naf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sepem kegogak an ŋenaŋ Zisas kapigok dunduye, “Amobotnaŋ, neŋ geŋmagen tususuyet nâyap yaŋgut geŋ nânemane kukŋaŋgat meti mam bipm ma notnneyet geŋmak mebegalen zet diindomtiŋgut gilik zemti kobap.” ");
INSERT INTO naf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Zeme Zisasiyaŋ egat kapigok dunduye, “Am ŋenaŋ mulup selen winde taben beme egaŋ gilik ze bamseset egepiŋ. Egaŋ selen weyaŋ tep kindiŋan ma nanzaŋ mee notnaŋ zigoset tazin ke ekmâtâti winde benak. Âk egaŋ bamseset ekdak beme setetek mti tokunak. Sepem kegogak am ŋenaŋ Kawawaŋgalen Zet Zapat Dolakŋaŋ mkawaŋ besât nâin beme ek bamanan gilik zemti kwitnaŋ kwitnaŋ msat palengalen ke eknâmtikŋaŋ mimipiŋ. Egaŋ kegok mbe beme Kawawaŋgalen zemâtâtâtgat katnanen maip keŋan mulup ŋep ku mbe.” ");
INSERT INTO naf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Âpme maneti Zisasiyaŋ nemba sambe makumti 72 ewe indaombemindemti mulup zet zemindeye. Kegok mti ikŋaŋ bam msat mebegalen nâŋgeen kataŋ nemba zut zut kegok zemindeme mebien. ");
INSERT INTO naf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kegok mti egaŋ ekŋengat ewe kapigok tusum zeye, “Kawawaŋgalen mulup sambe penaŋ mimiyelen tazin yaŋgut mulup am sambe yek. Kwep kwewetaŋ keyepmti in mulup toŋaŋ dundum same mulup mimi am notnaŋ aikindeme mulupmanen sakwep mepmâbep. ");
INSERT INTO naf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","In meti kapigok otnâmbep, neŋ alak in sipsip nemboŋ tam zupmaŋ ekŋengat keŋan zemindema melip keyepm in weyaŋ eksemti mebep mneti ekŋenaŋ indawalebepgat. ");
INSERT INTO naf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","In mesâpmti mânep ma ele temaŋ milawatmak ma setwewet titipiŋ mebep. Ma selen am ŋen aikti zapat belakŋaŋ zenâ zenâ ku mbep. Belak etaŋ mebep. ");
INSERT INTO naf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Âpme kan kataŋ mka ŋengat keŋan weweyelen mosâgât mti kukŋaŋgat mka toŋaŋgat kapigok dunduwep, ‘Keŋ sewakŋaŋ inmak tabe.’ ");
INSERT INTO naf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Zeme egaŋ mkaŋanen indaikti mobe beme, ‘Keŋ sewakŋaŋ geŋmak tazin,’ kegok dunduwep. Âk kegok ku mbe beme keŋ sewakŋaŋ ilinmak tapme mebep. ");
INSERT INTO naf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Âpme mka motabewen keyegak tatat mimi ke tapme tu meu ilin nimti ziboŋ indaip beme in ke mti nimbep. In mulup ekmagen mbep keyepm tu meu ŋep indame nimbep. Ma in mka kukŋaŋgat tabep ke pemti mka ŋen weweyet ku mebep.” ");
INSERT INTO naf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kegok zemti ewe kapigok tusumti zeye, “Kan kataŋ mka temaŋ ŋengat keŋan mopme amnaŋ ingat zemoloŋen mti kolit zeme meti meu ziboŋ ingat weyayaŋ mbep ke nimbep. ");
INSERT INTO naf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kegok mti am zawalinmak mka teman keyet keŋangatnaŋ weyaŋindemti am ekŋengat kapigok diindowep, ‘Kawawaŋaŋ ingalen Amobotnaŋin kozinen keyelen kanaŋ mulup anene inmagen kolip keyaŋ zemkawaŋ beinen egalen zemâtâtât katnaŋ mama ilak sokbein.’ ");
INSERT INTO naf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yaŋgut kan kataŋ mka temaŋ ŋengat keŋan mopme ekŋenaŋ ingat zemoloŋen ku mip beme mka temaŋgalen set tuŋgupman tazinen metati amgat kapigok zewep, ");
INSERT INTO naf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ingalen kânzunzuŋ ningat setnnanen imann talep ke pâmpâm kumann ilinmagen tozin keyaŋ mkawaŋ beinen Kawawaŋaŋ ingat ŋenzinziŋ min. Yaŋgut in kapigok otnâit Kawawaŋaŋ ingalen Amobotnaŋin inmagen kotati in indikdamuŋ msâpmme in ku nâmtikŋaŋ mti zempeip.’ ");
INSERT INTO naf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neŋ penaŋ zema nâit, eweŋan baenen Sodom mka teman am ekŋenaŋ bekanaŋ mimiŋinaŋgat zet mulup mimi kanen Kawawaŋaŋ dopmaŋ bekanaŋ katikŋaŋ penaŋ indaye. Âpme in mka keyelen Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ inmagen kopme in ku nâmtikŋaŋ mti ektalabien. Keyepmti Kawawaŋaŋ dopmaŋ titiyelen kanen in dopmaŋ bekanaŋ penaŋ Sodom am ekŋen sebemindemti in mobotnaŋ penaŋ tiwep.” ");
INSERT INTO naf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kegok zemti nembaŋaneyet mka temaŋ zut kapiyet zet diindoye, “Wakae, inmagen bekanaŋ penaŋ sokbewe. Kolazin mka temaŋgalen am ma Besaida mka temaŋgalen am inmagen neŋ menok igak igak temaŋ sambe mban ke eweŋan Taia mkaengalen am ma Saidon mkaengalen am ekŋenmagen sokbenak ze, nap sâk teŋgenaŋaŋ ambuluti kâyaŋ sekŋinan mulati yominaŋgat nâmti sakambuk mti zemsu zemsu palen talip keyet zikat indanagen yominmagengatnaŋ gilik zewiek. ");
INSERT INTO naf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Keyepmti neŋ in ewe pigok diindoma nâit, Taia ma Saidon ekŋen am bekanaŋ tipman baen mambien ekŋengalen dopmaŋ titiyelen kananen Kawawaŋaŋ yominaŋgat tosaŋaŋ mtoti indawe yaŋgut in yominaŋgat tosaŋin mmoti penaŋ indawe. ");
INSERT INTO naf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapaneam ingalen mka teman neŋ tatat mimi mti menok yaŋaŋ yaŋaŋ mma Kapaneam am in nikmâtâbien yaŋgut in alak pi sekŋin omba penaŋ tapmmolip. Keyepmti neŋ ingat pigok nâyap, In sekŋin omba penaŋ tapmmoliwaŋgut Kawawaŋaŋ in indeme teziŋ ŋandaŋen towebep.” ");
INSERT INTO naf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Egaŋ kegok zemti nembaŋane ekŋengat kapigok diindoye, “Am ŋenaŋ ingalen zet nâmti mkipmaŋ bewe egaŋ nâlen zet kegogak nâmti mkipmaŋ bewe. Ma am ŋenaŋ in indik kiŋgatindewe egaŋ kegogak neŋ nakiŋgat newe enenogat in zet zapat dolakŋaŋŋ manzeip ke nâlen zezapat bein. Ma ŋenaŋ neŋ makiŋgatnein egaŋ kegogak An neŋ zemneme koban ek kegogak makiŋgatpein enenogat nâlen zezapat ma Kawawaŋgalen zezapat eget sakam kwep bein.” ");
INSERT INTO naf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Âpme Zisasiyaŋ nembaŋane 72 indeme mebien ekŋenaŋ met maneti gilik zemti koti ekŋenaŋ Zisasiyet zezapat oloŋen palen kapigok dunduwien, “Amobotnaŋ, nin gâlen kwidanen we bekanaŋ amgat keŋinan kegogak zemindemann ekŋenaŋ ningalen zet gawepumti kwawabien!” ");
INSERT INTO naf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ekŋenaŋ kegok zeme egaŋ zet dopmaŋ kapigok gilik zem zemti zeye, “In kegok mbien ke enenogat Sadaŋgat windeŋaŋ tatimtopme egaŋ kululuŋengatnaŋ sakamaŋ ambeyak busatnaŋaŋ sakwep peyak mamm kegok windeŋaŋ katipemti toge ein menok nâgât kwitnnan tapmmeyepm topme ekban. ");
INSERT INTO naf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nâit, in winde indawan ke asiŋ am indindi ma lanzi ekŋen sela indiwep ma kasa ekŋengalen windeŋin kume tobe. Kegok mme kwitnaŋ ŋenaŋ ku indawalebe. ");
INSERT INTO naf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yaŋgut in we bekanaŋaŋ zelin gawepuwien keyet keŋ segeyak ku mit. Kawawaŋaŋ kwilin papiaen kululuŋen kumpepeŋaŋ ma in mama kanzizit kwesiŋ kwesiŋ mamayelen ke tiwep keyet keŋ segeyak mbep.” ");
INSERT INTO naf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Âpme kan keyet Emetak Teŋaŋ Zisas keŋanen oloŋen mimiyelen mpeme penaŋ mti kapigok zeye, “Bien, kululuŋ ma msatgalen Amobotnaŋ, neŋ gâgât wisikŋ nâmgeyap enenogat am nânâŋinpiŋ ekŋenmagen mulupdi ma zezapadi dolakŋaŋ ekŋenmagen mkawaŋ bemane ekmâtâbien keyaŋgut an nânâŋin temaŋ ekŋenmagen kwitnaŋ kwitnaŋ enziliwanan. Bipm, geŋ kwitnaŋ kwitnaŋ msokbewanan ke gitaŋgat nânâyet ma nâmtikŋaŋdaŋgat mbanan. ");
INSERT INTO naf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bienaŋ kwitnaŋ kwitnaŋ sambe kapi betnnan bem neŋge. An ŋenaŋ nâlen yaŋŋ ku manikmâtâzin; Bienaŋ kwep manikmâtâzin. Ma Biengalen yaŋaŋ kegogak an ŋenaŋ ku maekmâtâzin. Nenak kwep maekmâtâlap. Ma neŋ am ombemindema Bipmnaŋgat yaŋaŋ maekmâtâlip.” ");
INSERT INTO naf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kegok zemti Zisasiyaŋ nembaŋane 72 ekŋenmagen gilik zem zetnaŋ ŋandaŋaŋ mtoti kapigok diindoye, “In oloŋen palen talip enenogat in kwitnaŋ kwitnaŋ sambe ilin mti ma ke eknâmâtâbien. Neŋ kapigok diindowi, ");
INSERT INTO naf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","eweŋan baenen golaŋ zenze an ma an teŋ notnaŋ ekŋenaŋ kwitnaŋ kwitnaŋ mamiyap eksâtgât ma nâgât zetn nâsâgât webe webe mbien yaŋgut ku nikti nâmbien. Naman in alak nen nikti zetn nâmtiŋgut ku nâmâtâlip.” ");
INSERT INTO naf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Âpme kan ŋengat an zii zet nâmâtâtâtnaŋaŋmak ŋenaŋ koti Zisas tetipemti eegalen kot yaŋkwesiye, “An zikat indanda, neŋ kwileki mti mama kanzizitgat zapat bewap?” ");
INSERT INTO naf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kegok zeme Zisasiyaŋ nâmti kapigok dunduye, “Mosesiyelen zii zelen mama kanzizitgat zigok kumpepeŋaŋ? Keyet yaŋaŋ geŋ zigok otnânik?” ");
INSERT INTO naf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yaŋkwesime egaŋ zeye, “Geŋ keŋdi ma nâmamandi ma windendi ma ŋoktikdi ekŋen ke ketalasimti Amobotnaŋ Kawawaŋgat etaŋ gogot mpewanik. Ma zet ŋen ewe kapigok, gitaŋgat maŋgemben kataŋ am notnaŋgat kogogak gogot mbanik.” ");
INSERT INTO naf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Zeme Zisasiyaŋ zet dopmaŋ kapigok gilik zem dunduye, “Geŋ zet teŋ penaŋ zenik. Geŋ kegok mbanik beme mama kanzizit tiwanik.” ");
INSERT INTO naf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yaŋgut zii zet nâmâtâtât an egaŋ am notnaŋgat gogot ku mge keyepmti egaŋ nânâŋaŋ ke Zisasiyaŋ ku nâmâtâtâgalen nâmti egaŋ zet ŋen zesât mti zet kukŋaŋgat ke atam pemti zeye, “Nâgât notn ke an kwi?” ");
INSERT INTO naf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kegok zeme Zisasiyaŋ egat dunduye, “Kan ŋengat Zuda an ŋenaŋ Zelusalem mka temangatnaŋ Zeliko mkaen totogalen totnepeme kambu titi an ekŋenaŋ ek aikti milawatnaŋ kambu timti kume gakikiyelen wembe katnan etaŋ tapme pemti kunzuŋ mebien. ");
INSERT INTO naf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kegok sokbeme an zut Zuda maŋgaengatnaŋ sâpe sâpe bumbu an ŋenaŋ Zeliko mka temanen mebegalen nâmti set egaŋ togeen ke tatotneti an ke ekti set keiŋaset toti mege. ");
INSERT INTO naf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sepem kegogak Kawawaŋgalen sesewat mka temaŋgalen mulup an set keyegak kotneti an kemagen pataŋ zemti ekmagen sokŋan meti ekmâtâti pemti set keiŋaset toti mege. ");
INSERT INTO naf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Âpme Samalia am ekŋenaŋ Zuda am ekŋenmak kasa kasa mamip. Yaŋgut Samalia an ŋenaŋ set keyegak tapmetneti an ke egeen keŋaŋaŋ an keyet kembeŋ penaŋ nâye. ");
INSERT INTO naf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Keyepmti ekmagen sokŋan penaŋ meti wain ma tep tuŋaŋ kelakŋaŋmak kumsowienen ke bepemti sâk butnaŋ mti kwaikpeye. Kegok mti doŋkiŋaŋ dukŋan ambepeme mopme aikmeti an ŋengalen mkaen mowebun. Ke moweti ekdamuŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Âpme mseŋan mka keyet toŋaŋ mânep silwa kasetnaŋ zut msamti kapigok zempeye, ‘Geŋ an kapi weyaŋ ekdamuŋ mbanik. Âpme neŋ set kapiyegak gilik zem koti gâlen kwitnaŋ kwitnaŋ timane mebe ke neŋ koti dopmaŋ ŋep mutuwap.’” ");
INSERT INTO naf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Zisasiyaŋ zet kegok zemdelaŋ zemti zii zet zikat indanda an keyet yaŋkwesiye, “Geŋ zigok otnânik, an tuk ekŋengat tuŋguwinangatnaŋ an kwiyaŋ an kambu titiyaŋ kuwien ke notn dolakŋaŋ mpeye?” ");
INSERT INTO naf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kegok yaŋkwesime zii zet zikat indanda an keyaŋ kapigok zeye, “An egat kembeŋ nâmti mukulem mpeye ke.” Zeme Zisasiyaŋ zetnaŋ dopmaŋ gilik zeye, “Geŋ meti sakam kegogak mbanik.” ");
INSERT INTO naf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Âpme Zisas ma nembaŋane ekŋenaŋ tapmetneti mka ŋande temaŋ ŋen kopataŋ zemti Zisasiyaŋ mka temaŋ keyet keŋan moweti imbi ŋen kwitnaŋ Mata egalen mkaen mowege. ");
INSERT INTO naf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma egat weneŋaŋ kwitnaŋ Malia. Egaŋ koti Zisasiyaŋ mot totapmaŋgeen ke koti Amobotnaŋ egat setnaŋ ganzenan totati egaŋ zezapat dolakŋaŋ tazemzikat indamaŋgeen ke tatnâmaŋge. ");
INSERT INTO naf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Âpme Matayaŋ meu weyayaŋ igak tapm olati weneŋaŋgat nâmsokumti keyepm koti Zisasiyet zeye, “Amobotnaŋ, geŋ taekdik, wenennaŋ neŋ nemti geŋmagen kotapme mulup nenak tapm olalap. Zemane koti neŋ namukulem mik!” ");
INSERT INTO naf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zeme Zisasiyaŋ kapigok dunduye, “We, o Mata, geŋ kwilekiyet kwitnaŋ kwitnaŋ sambeyet yayaŋ mti nâmnukŋaŋ mnik? ");
INSERT INTO naf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maliayaŋ nâgât zetnnaŋgat nâmtikŋaŋ min keyaŋ kwitnaŋ kwitnaŋ sambe msalen kapi sebemindein. Ke ŋenaŋ menzem mimiyelen sakam yek.” ");
INSERT INTO naf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Âpme kan ŋengat Zisasiyaŋ mundum ŋen metati tadundumaŋge. Ya dundum delaŋ zeme nembaŋane ŋenaŋ egat yaŋkwesiye, “Amobotnaŋ, geŋ dundundu set katnaŋ ŋen Zânaŋ nembaŋane zemzikat indayenok zemzikat ndasenik.” ");
INSERT INTO naf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Zeme egaŋ diindoye, “In dundundu sakam kapigok dunduwep: Bien, nin gâgât kwidi mmotnuwen kogogak am sambeyaŋ mmobogat dundunup. Geŋ kot nin sambe ndadamuŋ mi. ");
INSERT INTO naf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Geŋ alak tu meu nnaŋgat weŋnok niniyet ndasenik. ");
INSERT INTO naf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nin am ekŋenaŋ myuŋgum ndandaŋaŋ makatikpenup sepem kegogak geŋ ningalen yomm katikpe. Yomgalen tetimaemaeyaŋ ndatime ku katikndewanik. Windendi ndamane bekananen ku towebanup.” ");
INSERT INTO naf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Zisasiyaŋ kegok zemti nembaŋane kapigok diindoye, “Inmagengatnaŋ am ŋenaŋ tambusutnan notnaŋ ŋenmagen medak beme meti set toŋtoŋ kumti zenak, ‘Notn, gâlen nupmamaŋ tuk nasenigaŋ dopmaŋ gawap. ");
INSERT INTO naf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nâlen notn ŋen set teepmaŋ koti kotapme neŋ meu eksasayelen ŋen ku tatnain!’ ");
INSERT INTO naf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Geŋ kegok zewek beme nodi keyaŋ mka keŋan tati kapigok zenak, ‘Geŋ nabutetepiŋ, sekekek kekpeya ma nemban ma nen ma imbin nsakwep mundumen meluk tawenup. Neŋ wati kwitnaŋ ŋen ku gasap.’ ");
INSERT INTO naf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yaŋgut neŋ kapigok diindowi, geŋ egat notnaŋ ya egaŋ ku wati gamukulem mgenak. Yaŋgut geŋ yaŋkwesiŋ giŋgiŋ mbek beme egaŋ ŋep wati nupmamaŋgat zewek ke ŋep mganak. ");
INSERT INTO naf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Âpme neŋ dundundu mimiyelen set katnaŋ ingat bemzenze zet tuk kapigok diindowi: Kawawaŋgat dundum same kwitnaŋ kwitnaŋ indawe. Ma timamat mulup mti penaŋaŋ aikbep ma ŋanda kasaŋ kume set kwaselemti kwitnaŋ kwitnaŋ indawe. ");
INSERT INTO naf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mandunduiwaŋ kwitnaŋ kwitnaŋ matip. Matimaliwaŋ penaŋaŋ maaigip ma ŋanda kasaŋ makuiwaŋ sekekek kweselemindamti kwitnaŋ kwitnaŋ maindain.” ");
INSERT INTO naf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Dundunduyelen zet ŋen ewe kapigok zeye, “Inmagengatnaŋ an ŋenaŋ nembayet biwin tatnak beme nemuŋaŋaŋ meuyet mti aŋgalayet yaŋkwesime nombe kukŋaŋbeŋ ku masain. ");
INSERT INTO naf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma egaŋ sakokolok katnaŋgat yaŋkwesime lanzi ku masain. ");
INSERT INTO naf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","In am bekanaŋ penaŋ ya nemunambaŋin kwitnaŋ kwitnaŋ dolakŋaŋ maindapelaŋguip. Âpme Biwin kululuŋen ek An dolakŋaŋ penaŋ. Egaŋ kwitnaŋ kwitnaŋ dolakŋaŋ biwineyaŋ nemba maindaip ke sebempemti mobotnaŋ penaŋ indaweyeyepm in Kawawaŋgat Emetak Teŋ ndandayelen dundum same egaŋ Emetak Teŋ ŋep indawe.” ");
INSERT INTO naf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Am ŋen we bekanaŋmak mamti zet ku manzemtan. Ek an kopa ya Zisasiyaŋ we bekanaŋ mâpeye. We bekanaŋaŋ kwawepme an keyaŋ yaŋbemti zet zeye. Kegok sokbeme am sambeyaŋ nâmtemtem mbien ");
INSERT INTO naf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","yaŋgut am notnaŋaŋ zewien, “Zisas ek we bekanaŋ ekŋengalen ŋeŋaŋ bembeŋinaŋ kwitnaŋ Beelsebul egaŋ winde same we bekanaŋ tazemindein.” ");
INSERT INTO naf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kegok zeme am notnaŋaŋ Zisas tetipemti eegalen ma egaŋ menok notnaŋ mme Kawawaŋ ekmak penaŋ tazin ke nâmti egat yaŋkwesiwien. ");
INSERT INTO naf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Âpme Zisasiyaŋ ekŋengat nânâŋinan zekukuŋaŋ mbiengapm kapigok diindoye, “Am maŋge ŋenaŋ ilinak kalaŋti maŋge ŋen maŋge ŋen bemtati maom kwaom mbiek beme ekŋenaŋ kwesiŋ ku mambiek ma ekŋenaŋ mama mimiŋinaŋ kileŋ bewiek. Sepem kegogak awembiŋ ma nemunambaŋine ekŋenaŋ ilinak kalaŋbiek beme ekŋengalen mama mimiŋinaŋ kileŋ benak. Neŋmak Sadaŋmak kasa kasa mamilup kogogapmti Sadaŋaŋ winde name egalen winde kumatotogat winde ku nanak. ");
INSERT INTO naf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Eneyet Sadaŋgalen maŋgeyaŋ kalaŋti ilinak maom kwaom mbiek beme ekŋenaŋ windemak ŋep ku tabiek. ");
INSERT INTO naf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Âpme neŋ Beelsebul egalen windeyet we bekanaŋ mamâtindeyap zeyoyepmti kwiyaŋ nembaŋine winde indame we bekanaŋŋ mâtindewep, Beelsebul egalen windeyet ma Kawawaŋgalen windeyet mamâlip? Ilinaŋgat nembaŋineyaŋ we bekanaŋ mâlo keyaŋ in zekuku miyo ke mme penaŋepiŋ bep. Eneyet nembaŋinenaŋ yaŋaŋin msokbeyo. ");
INSERT INTO naf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wa ke Beelsebulgalen windeŋaŋ yek. Kawawaŋgalen Emetagaŋ manapmukulem mme we bekanaŋ maindamâlap. Kapiyaŋ msokbemindainen Kawawaŋgalen zemâtâtâtgat katnaŋ mama keyelen winde ke alak inmagen kapi tazin. ");
INSERT INTO naf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Âpme an windeŋaŋbeŋ ŋenaŋ kasayet damuŋ msâgât timbiŋaŋ weyaŋti mkaŋaŋ damuŋ mnagen mkaŋaŋ dolakŋaŋ tadak. ");
INSERT INTO naf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yaŋgut an windeŋaŋbeŋ penaŋ ŋenaŋ koti an ke kumsagapmti timbiŋaŋ namukulem msem nâyeyeen ke, ‘Kambu titi an ke mtopesap,’ nâmti mgeyaŋgut egalen kwitnaŋ kwitnaŋ ke ma milawatnaŋ kambu tiye. Timeti notnane ekŋenmak kalakumti tiwien. ");
INSERT INTO naf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","An ŋenaŋ neŋmak ku mambe beme ek nâgât kasan. ");
INSERT INTO naf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","We bekanaŋaŋ an keŋangatnaŋ kwaweti msat tuŋgupman mundum tatagat timati mundum ŋen ku aige. Keyepmti ikŋaŋgat kapigok otnâye, ‘Mkan eweŋan pemti koban keyegak gilik zem meti eksap.’ ");
INSERT INTO naf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kegok zemti gilik zem meti egeen mka ke belak weyaŋti kaput peme toŋepiŋ tage. ");
INSERT INTO naf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Keyepmti met we bekanaŋ notnane 7 ekŋen keyaŋ bekanaŋ penaŋ ek sebempeip ekŋen ke indatime kot keyegak tatat mimi mbien. Kegok sokbeme an ke eweŋan bekananik maaŋgewan bekanaŋ penaŋ bemtazin.” ");
INSERT INTO naf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Âpme Zisasiyaŋ zet kegok zemdelaŋ zeme imbi ŋen am maŋge tabien ekŋengat tuŋguwinan tati Zisasiyet kapigok zeye, “Imbi geŋ gambage ma nam gaye egaŋ oloŋen penaŋ mbe!” ");
INSERT INTO naf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kegok zeme Zisasiyaŋ imbi keyet kapigok dunduye, “Geŋ kegok zenik, âpme nen nâyawen am Kawawaŋgalen zezapat dolakŋaŋ nâmti maŋgawepup ekŋenaŋ oloŋen penaŋ mbep.!” ");
INSERT INTO naf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Âpme am sambeyaŋ koondakbienen kan keyet Zisasiyaŋ zet ewe tusumti kapigok ekŋengat diindoye, “Am alak kan kapiyet talip in bekanaŋ penaŋ ma Kawawaŋgat ku nâmkiŋpeip! In neŋ menok ŋen mma eegat nâmti manayaŋkwesip. Yaŋgut in menok ŋen ku ekbep. Piliŋ kwewetaŋ Kawawaŋgalen golaŋ zenze an itnaŋaŋ kwitnaŋ Zonamagen sokbeye keboŋ bam ekbep. ");
INSERT INTO naf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ke kapigok golaŋ zenze an Zonayaŋ Ninewe msalen keŋ gilik zenzeyet zeye keyet piliŋ beye sepem kegogak Angat Nemuŋaŋ neŋ am alak talip in kapimagen nen piliŋ beyap. Ninewe ekŋenaŋ keŋ gilik zenzeyelen zet Zonayaŋ mediindome keŋin gilik zeye. Âpme neŋ inmagen keŋin gilik zenzeyet diindoma keŋin gilik zeme nâmkiŋpepemak mamayelen nâmti tadiindoyap. ");
INSERT INTO naf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Âpme itnaŋaŋ baenen imbi mobotnaŋ Siba msalengatnaŋ egaŋ beŋaŋgatnaŋ amobotnaŋ Solomon nânâŋaŋ temaŋ ke eksâgât nâmti koge. Âpme neŋ amobotnaŋ Solomon ek sebempeyap. Yaŋgut neŋ ingat tuŋguwinan pi tati mulup mma in keŋinan ku mkipmaŋ benemti yominaŋgatnaŋ ku gilik zeip. Keyepmti imbi mobotnaŋ Siba msalengatnaŋ eaŋ Kawawaŋgat zikatnan zemindoween, ‘Neŋ beŋangatnaŋ Solomon etaŋ eksât koban âpme in Zisas sokŋan tazinaŋgut in yaŋaŋ ku ekmâtâlipgapmti keyaŋ ingalen yom temaŋ bein.’ ");
INSERT INTO naf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Âpme Zonayaŋ zet zapat dolakŋaŋ Ninewe am ekŋen diindoyeen yomengatnan keŋin gilik zem mâpme delaŋ zeye keyet dopmaŋ dolakŋaŋ Kawawaŋaŋ indawe. Ma ekŋenaŋ Kawawaŋgat zikatnan in zemindowep. Enenogat neŋ alak inmagen pi tati Zona mobotnaŋ penaŋ sebempemti tapma in nâlen zet zapatn dolakŋaŋ nâmti ewe yomengatnaŋ ku gilik zeip. Keyepmti dopmaŋ bekanaŋ temaŋ inmagen sokbewe. ");
INSERT INTO naf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Âpme amnaŋ lam koŋ bemti menzimaŋ dukŋan ku makwalapenup. Nin lam koŋti munduman tatatnanen sosok sapemann tapme mbusatnaŋ beme amnaŋ ekti mka keŋan makwalip. ");
INSERT INTO naf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","An ŋen ek nâmamaŋaŋ Kawawaŋmagen bemti mamain ek busatnanen mamaingapmti keŋan ma sekŋaŋ busatnanen talip. Mme an ŋen ek nâmamaŋaŋ Kawawaŋmagen ku mambein an ke tembusosogen mamain kegok zenzeyelen. Keyaŋgut, ‘Neŋ ŋep Kawawaŋ mâti mamti naman kwitnaŋ kwitnaŋ msatgalen kogogak timambap,’ an keyaŋ kogok zein beme ek tambusosogen penaŋ tazin. ");
INSERT INTO naf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Weyaŋ ekmâtâbep. Mti zikalin ekpeme Kawawaŋmagen mebe keyaŋ keŋin sekŋin mme busatnaŋaŋmak bewe. Kogok ku mbep beme tembusosogen keŋin ma sekŋin pesak pewe. ");
INSERT INTO naf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Âpme keŋinan busatnaŋ tisâgât indembein ekŋenaŋ zet zapat penaŋ ke tip ma busatnaŋ kogogak tip eneyet neŋ busatnaŋ ma zet zapat penaŋ. Sepem keyet kataŋ lamaŋ mka keŋan mbusatnaŋ mambein kegok mbe.” ");
INSERT INTO naf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Âpme Zisasiyaŋ zet kegok zemdelaŋ zeme Palisi an ŋenaŋ Zisas egalen mkaen tu meu niniyelen zemmandaye. Kegok zeme mka keŋan moweti meu niniyelen mundumen totage. ");
INSERT INTO naf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ke totati betnaŋ Zuda am ilinaŋgalen zii zelaŋ bet zuluti tu meu niniyelen zenzeŋaŋ ke ku mâti bet zululupiŋ tu meu niŋge keyepm Palisi an keyaŋ ke ekti nâmtemtem mge. ");
INSERT INTO naf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kegok otnâme Zisasiyaŋ egat nânâŋaŋ ekmâtâti kapigok dunduye, “In menzim sekŋaŋ etaŋ manzulupme keŋanen zulupiŋ mme meu pâpmaŋ melesiŋ matazin. Ingalen mama mimiŋin sepem menzim keboŋ. In amgat zikalinan an pembenaŋnok mamaip yaŋgut keŋinan kambu ma sekgalen eiyak kwitnaŋ kwitnaŋaŋ bemisik wen. ");
INSERT INTO naf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wakae, inmagen bekanaŋ penaŋ sokbewe. In an kileŋ penaŋ. In zigok otnâip? Kawawaŋaŋ menzim sekŋaset weyaŋti egaŋ kegogak keŋaset weyaŋge, ma? ");
INSERT INTO naf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yaŋgut menzim ma pelep keŋan kwilekiyaŋ tazin ke timti am tototnaŋ ekŋen indawep. Kegok mme kwitnaŋ kwitnaŋ sambe inmagen kwetetepmaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Wakae, Palisi inmagen bekanaŋ penaŋ sokbewe! In kwilekiki isikŋaŋ sikokok ma suŋem saŋgo muluwengatnaŋ ma soŋgom ekŋen keboŋgalen maŋge 10magengatnaŋ maŋge kwep ke Kawawaŋgat masaip. Yaŋgut in Kawawaŋmagen kwetetepmaŋ mama ku mamaip ma ek gogot ku mampep. Egat ke mti keyet palaŋan kwitnaŋ kwitnaŋ isisikŋaŋ kegogak mbep. ");
INSERT INTO naf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Wakae, Palisi inmagen bekanaŋ penaŋ sokbewe! In sesewat mkaengalen mundum totatat dolakŋaŋ ilin ombempepeŋan etaŋ matotalip. Ma amnaŋ bem kwiti kwiti munduman indikti indamukume nâme mobotnaŋ bembeyet manâip. ");
INSERT INTO naf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wakae, inmagen bekanaŋ penaŋ sokbewe! In sum piliŋaŋ ma elimiakŋaŋpiŋ tapme am sambumbuŋan tazin ke nânâpiŋ amnaŋ dukŋan mamelip. Ma ingalen keŋin bekanaŋ penaŋ ke amnaŋ sekŋinaset ku maegip. Amnaŋ sum dukŋan egapiŋ mamelip sepem keboŋ.” ");
INSERT INTO naf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Âpme an zii zet zikat indanda ekŋenmagengatnaŋ ŋenaŋ Zisasiyet kapigok dunduye, “An zikat indanda, geŋ zet zenik keyaŋ nin kegogak mtotndein!” ");
INSERT INTO naf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kegok zeme Zisasiyaŋ zeye, “Wakae, an zii zet zikat indanda inmagen kegogak bekanaŋ penaŋ sokbewe! In nukŋaŋ sambe timbemâti am ekŋengat dukŋinan bemindeme ekŋenaŋ taolapme ilin belak kakanemuŋ bet bugan kukupiŋ mamaip. ");
INSERT INTO naf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wakae, inmagen bekanaŋ penaŋ sokbewe! In nanzaŋ temaŋ dukŋan meluwaŋ kumpemti yeŋsokŋineyaŋ golaŋ zenze an indowien ekŋengat suminanen bempewien. ");
INSERT INTO naf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ma yeŋsokŋine ekŋenaŋ golaŋ zenze an indokwebien ke nâmti, ‘Ŋep,’ zeip keyepmti in sumin elimiak pembenaŋ mamiakpeip. ");
INSERT INTO naf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Âpme Kawawaŋ an nânâŋaŋ temaŋ egaŋ kapigok zeye, ‘Neŋ golaŋ zenze an ma an zet zenze ekŋenmagen indema kopme notnaŋ indome gakiwep ma notnaŋ sisipeŋpeŋ mimindawep.’ ");
INSERT INTO naf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ingat yeŋsokŋineyaŋ kan Kawawaŋaŋ msat ma kululuŋ weyaŋgeen keyetnan yaŋbemti golaŋ zenze an ekŋen indokwebiengat dopmaŋ alak talip in Kawawaŋaŋ musuwet indesâpm. ");
INSERT INTO naf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ke yaŋbembeŋaŋ baenen Keinaŋ meniŋaŋ Abel kume gakiye ma keyetnaŋ mamkwati Zakalaya ek sesewat mka temaŋgalen sisak ma kambuk mka teŋ tuŋguwidan amnaŋ nanzaŋaŋ kume gakiye. Neŋ penaŋ zema nâit, am alak talip in keyet dopmaŋ Kawawaŋaŋ indame puwep! ");
INSERT INTO naf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Wakae, an zii zet zikat indanda inmagen bekanaŋ penaŋ sokbewe! In Kawawaŋgalen zet penaŋ amnaŋ nânâyet kwatapemti ku mamkawaŋ beip. In zet penaŋ ke ku mkipmaŋ bemti am kegogak zemkulumindeme ekŋenaŋ zet penaŋ ke ku nâmkiŋpewien!” ");
INSERT INTO naf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kegok zemdelaŋ zemti Zisasiyaŋ Palisi an keyelen mkaengatnaŋ toti pem ŋen mege. Âpme kan kataŋ Zisasiyaŋ am zet zapat mandiindome zii zet zikat indanda ma Palisi ekŋenaŋ kot ek mtopepeyelen zet zemti yaŋkwesisi sambe sepem igak igak mayaŋkwesimtemien. ");
INSERT INTO naf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma ekŋenaŋ egat yaŋaŋ m ekti tetipemti zet bekanaŋ ekŋengalen zii zelen tazinen ŋen mtopeme eknâmti zelen pepeyelen keyet mamtemien. ");
INSERT INTO naf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Âpme am tausen sambe penaŋ ŋep ku makukuyelen koti koondakti kitik kitik tati notnaŋaŋ notnaŋ kakalim notnaŋ kakalim kegok tapmme notnaŋaŋ ewe takopmambien kan keyet Zisasiyaŋ nembaŋaneyet golaŋ zet kapigok diindoye, “In Palisi ekŋengalen yis plawa manzim semen keyet weyaŋ eksemti mambep. Zet keyet yaŋaŋ ekŋen an zet nambalam zut zenze. ");
INSERT INTO naf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Âpme in yis nupmamaŋ keŋan ku egoyaŋgut nupmamaŋ sememe nâyo yis keŋan beyo. Keyet kataŋ Palisi ekŋengalen mama mimi an nambalam zulaŋ mama keyet penaŋaŋ bamgat sokbemkawaŋ beme yaŋin ekmâtâbep. ");
INSERT INTO naf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma Palisi ingalen zet mama mimi enzilim tazin ke bamgat ku enzilim tabe. Sosok sokbeme keyaŋ yaŋaŋin dâsuki ke msokbewe. ");
INSERT INTO naf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Notnne, neŋ zema nâit, amnaŋ sekŋin etaŋ kume gakime keŋ kayombaŋin kukuyelen windeyet timabep keyepmti ekŋengat ku kiŋgabep. ");
INSERT INTO naf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Neŋ An kwiyet kiŋgabep ke zikat indama egit: In Kawawaŋgat etaŋ kiŋgabep enenogat ek winde tasainen am indome gakimeŋgut teziŋ ŋandeŋen âtâtindeme towebep. Zet ke penaŋ. Egat etaŋ kiŋgabep. ");
INSERT INTO naf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Âpme in gwasembelebele indikgit ekŋen Kawawaŋaŋ nâmâtâti indikdamuŋ mamm. Gwasembelebele ek belakŋaŋ penaŋ. Ekŋen tosaŋin isikŋaŋ penaŋ titiyelen yaŋgut ekŋenmagengatnaŋ ŋen gakime Kawawaŋaŋ age ŋen gakin manâin! ");
INSERT INTO naf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Keyaŋgut in gwasembelebele belakŋaŋ penaŋ keboŋ yek. Kawawaŋaŋ nâinen in mobotnaŋ penaŋ beip. Ma in age ekŋen sebemindeip ya kwitnaŋ kwitnaŋ bekanaŋ sambe inmagen sokbeme Kawawaŋaŋ ingat nâmâtâzin keyepm kiŋgagapiŋ! ");
INSERT INTO naf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Am ŋenaŋ, ‘Neŋ Zisasiyet nâmkiŋpemti ekmagen tusuyap,’ zemti am notnaŋgat zikalinan egaŋ kegok zemkawaŋ bewe beme Angat Nemuŋaŋ neŋ kegogak Kawawaŋgalen ensel ekŋengat zikalinan an ke, ‘Nenaŋgat zapat penaŋ,’ kogok zewap. ");
INSERT INTO naf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yaŋgut am ŋenaŋ am ekŋengat zikalinan nanzemkandabeen Angat Nemuŋaŋ neŋ kegogak Kawawaŋgalen ensel ekŋengat zikalinan zemkandatpewap. ");
INSERT INTO naf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Âpme an ŋenaŋ zet bekanaŋ notnaŋ Angat Nemuŋaŋ nâgât zeiwen Kawawaŋaŋ yomin katipen yaŋgut am ŋenaŋ Emetak Teŋgalen windeyet naman Sadaŋgalen winde zeinen Kawawaŋaŋ yomin ke ku katipewe. ");
INSERT INTO naf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ma in sesewat mka isikŋaŋgalen mulup an zelen idendeyelen indateti mobep ma gapmangalen zet mulup mimi mundumen indati mebep ma amobotnaŋ ŋen zet nânâyelen windeŋaŋmak ekmagen indati mepme, ‘Zet zigok zesenup?’ ma ‘Zet kwileki zesenup?’ keyet yayaŋ mimipiŋ. ");
INSERT INTO naf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kan keyet Kawawaŋgalen Emetak Teŋaŋ zet kwileki zenzeyelen ke mzikat game zet zewanik.” ");
INSERT INTO naf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Zisasiyaŋ zet kegok zemdelaŋ zemti tapme an ŋen maŋge temaŋ kemagengatnaŋaŋ Zisasiyet zet kapigok yaŋkwesiye, “An zikat indanda, datnmak nigat bipmdaŋ gakisât mti msat ma mânep milawat datnmak nilisakwep ndaye. Ya neŋ alak milom bilombi ke nâgât butnaŋ zenzeŋaŋ ke kalopbemti nanayelen nâyapgat datnnaŋgat zemane nasem.” ");
INSERT INTO naf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","An keyaŋ kegok yaŋkwesime Zisasiyaŋ dunduye, “Notn, Bien Kawawaŋaŋ neŋ igalen zet weyayaŋgalen ma milawat milom bilombiŋit ke kalalaŋgalen nâmti ku neme koban.” ");
INSERT INTO naf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Zisasiyaŋ zet ewe tusumti am maŋge temaŋ ekŋengat kapigok diindoye, “In milawatmak mamayet eksegat ku mbep. Keyaŋ indamukulem mme mama kanzizit ku tiwep.” ");
INSERT INTO naf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kegok zemti Zisasiyaŋ bemzenze zet ŋen kapigok diindoye, “An mânep milawatnaŋmak egalen muluwen saŋgo ma meu notnaŋ dolakŋaŋ penaŋ kwage. ");
INSERT INTO naf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kegok sokbeme egaŋ nânâ mulup mge, ‘Neŋ mundum ŋen saŋgo ma meu notnaŋ bembeyelen ŋen ku tatnain. Neŋ zigok mbap?’ ");
INSERT INTO naf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kegok otnâmti egaŋ nânâŋaŋ ŋen kapigok aige: ‘Neŋ mkan isikŋaŋ sambe kapi asekma delaŋ zeme mkan temaŋ sambe walati saŋgo ma meu notnaŋ ke timti mka keyet bewap.’ ");
INSERT INTO naf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kegok otnâmti ikŋaŋgat kapigok zeye, ‘Neŋ an delaŋ zenzeŋaŋ! Neŋ kwitnaŋ kwitnaŋ sambe ke nup kan sambe tatnawe. Neŋ nanaŋgat mamann mma eleŋ beleŋ penaŋ bein ma oloŋen palen tu meu ntabap.’ ");
INSERT INTO naf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Egaŋ kegok otnâme Kawawaŋaŋ egat zeye, ‘Geŋ an kileŋ penaŋ! Geŋ tembumbu kapiyet gakisenik. Âpme kwitnaŋ kwitnaŋ sambe gitaŋgat ondekbewananen ke kwiyaŋ tiwe?’” ");
INSERT INTO naf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zisasiyaŋ zet kegok zemdelaŋ zemti ewe tusum zeye, “Am milom bilombi ilinaŋgat etaŋ maondakbeip am ekŋen keboŋ ke Kawawaŋgat zikatnan ekŋen am mânep milawalinpiŋ bewep.” ");
INSERT INTO naf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Âpme Zisasiyaŋ nembaŋaneyet kapigok diindoye, “Neŋ zet keyet butnaŋ ewe kapigok zema nâit: In alik tatagalen meuyet ma in sekŋinaŋgalen sâk melakanduyet yayaŋ mimipiŋ. ");
INSERT INTO naf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ma sâk melakanduyet ma tu meuyet etaŋ ku maotnâmambep. Naman in mama kanzizit titiyelen keyet maotnâmamambep. ");
INSERT INTO naf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","In tedukŋan gwaen gwasembelebele indigit. Ekŋenaŋ meuyet yayaŋ ku mamip. Ekŋenaŋ mmonde onde ma timondak mka mzalaŋen ku mambeip yaŋgut Kawawaŋ egaŋ meu maaikindame manip. Kogogapm Kawawaŋaŋ ingat nâme mobotnaŋ mambein. Ma egaŋ indikdamuŋ mamm keyepm yayaŋ mimipiŋ mamambep. ");
INSERT INTO naf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma am inmagengatnaŋ kwiyaŋ yayaŋ mti ikŋaŋgat mamaŋaŋ nup kanaŋ butnaŋ ŋep tusum manak? Am ŋenaŋ ŋep yek, keyepm yayaŋ mimipiŋ mamambep. ");
INSERT INTO naf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma in nup kan butnaŋ tususuyelen isikŋaŋ bukapi ŋep ku mamip ya in kwilekiyet tu meu ma sâk melakanduyet yayaŋ penaŋ mamip? ");
INSERT INTO naf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Âpme in tep belaalik msalen wein ke indigit. Ekŋenaŋ ilinaŋgat saŋgum melakanduŋin ku maweyaŋip ma mulup ku mamip. Yaŋgut keyet yaŋaŋ neŋ ingat diindoma nâit. Solomon ek mânep milawatnaŋ temaŋmak miak miakŋaŋ dolakŋaŋ yaŋgut tep belaaligat katnaŋ ego egoŋaŋmak keyet kataŋ Solomonaŋ ku miage. ");
INSERT INTO naf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Âpme Kawawaŋaŋ didik ekŋen ikŋaŋ kwapme mamiakindein yaŋgut kan belaknik tati sakwep memuŋ beme tep mambumannzin. Âpme Kawawaŋaŋ in saŋgum melakandu ŋep ku maindaingapm in yayaŋ mamip? In nâmkiŋpepeŋinpiŋ, ma? ");
INSERT INTO naf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Keyepm in nânâ mulup, ‘Tu meu kwileki nsenup?’ Keyet nâmti yayaŋ mimipiŋ. ");
INSERT INTO naf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ke am Kawawaŋ ku nâmkiŋpeip ekŋenaŋ nânâŋin keyet maketalasip. Keyaŋgut Biwin kululuŋen egaŋ in kwitnaŋ kwitnaŋ ekŋen keyet olalip ke ŋep nâmindein. ");
INSERT INTO naf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Keyepmti in naman keŋin sekŋin ketalasime Kawawaŋgalen zemâtâtât katnaŋ mama kandaŋan tabep ma Kawawaŋgalen zetnaŋ kandaŋan mepmeŋgut keyet palaŋanen tu meu saŋgum melakandu indawe.” ");
INSERT INTO naf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Zisasiyaŋ zet ewe kapigok tusum diindoye, “Nâmkiŋpepemak maŋge isikŋaŋ, in Biwin kululuŋengatnaŋ egalen zemâtâtâtgat katnaŋ mama ke ikŋaŋmak damuŋ mbep keyepm kiŋgagapiŋ mambep. ");
INSERT INTO naf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ma in milom bilombiŋin taindain ke beme amnaŋ kwitime mânep ke timti am kwiyaŋ olalip ekŋen indawep. Ma in kwitnaŋ kwitnaŋ dolakŋaŋ keboŋ mammambep beme keyaŋ Kawawaŋaŋ oloŋen mpewep. Mama mimi dolakŋaŋ keyet dopmaŋ ikŋaŋ kululuŋen gwaen indame kambu titi an ekŋenaŋ ku tiwep ma kwawaŋ ku nimbe. ");
INSERT INTO naf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","In kwitnaŋ ŋengat keŋin penaŋ maindembein beme ingat keŋin sekŋin nâmamaŋin peme keyet palen mamepmatim tazin.” ");
INSERT INTO naf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Zisasiyaŋ zet kegok zemti ewe kapigok tusumti diindoye, “In saŋgumin zamti melakanduŋin munduŋti lam koŋti peme tazime kwitnaŋ kwitnaŋ weyayaŋ mulup mme delaŋ zeme Amobotnaŋgat damuŋ tabep ");
INSERT INTO naf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","sakam kegogak amobotnaŋinaŋ awembiŋ bembeyelen mundumengatnaŋ gilik zem kobe kan keyet mulup amŋane ekŋenaŋ egat damuŋ mti weyayaŋ mulup mbep. Kan egaŋ kobeen kwizet kume mulup amŋane ekŋenaŋ sekekek sakwep kwaseleme keŋan mowebe. ");
INSERT INTO naf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kan keyet mulup amŋane ekŋenaŋ ikŋaŋ zemindeme kataŋ mâti meluk wewepiŋ egat damuŋ kaik tapmambep kogok tapmti ilinaŋgat oloŋen penaŋ mbep. Neŋ diindoma nâit, amobotnaŋ keyaŋ saŋgum melakanduŋaŋ gulum yaloŋti ŋen tim miakti ekŋengat zemindeme meu niniyelen munduman totapme egaŋ meu seŋti indawe. ");
INSERT INTO naf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Âpme amobotnaŋinaŋ tambusutnaŋ ma msasayen koindikme mulup amŋane ekŋenaŋ meluk wewepiŋ tapmambep beme ilinaŋgat kegok mbep keyet oloŋen mbep. ");
INSERT INTO naf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yaŋgut in nâmâtâlit. Mka toŋaŋaŋ kambu titiyaŋ kan zukŋan kobe ke nânak beme egaŋ mkaŋaŋ ekdamuŋ mme kambu titiyaŋ mkaŋaŋ kwaselemti kambu ku tinak. ");
INSERT INTO naf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","In sakam kegogak weyayaŋ mulup mtabep enenogat Angat Nemuŋaŋ nen in kan ku nâme neŋ memendepmak kobap.” ");
INSERT INTO naf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Zisasiyaŋ zet kegok zeme Pitayaŋ kapigok yaŋkwesiye, “Amobotnaŋ, geŋ bemzenze zet zenagen ke ningat etaŋ ma am sambe kapiyet temakwep nâmti zenak?” ");
INSERT INTO naf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pitayaŋ kegok zeme Amobotnaŋaŋ zeye, “Neŋ bemzenze zet ŋen an damuŋ nânâŋaŋ temaŋgat zesowap ke kapigok, an ŋen amobotnaŋaŋgalen mkaŋaŋ ekdamuŋ mti mulup amŋane meu indandayelen kan ke amobotnaŋ ikŋaŋ ombempeye kan keyet maindamtan. ");
INSERT INTO naf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kegok tapmnepeme amobotnaŋ keyaŋ gilik zem kobeen an mulup mamtan keyelen mulupmaŋ koekme dolakŋaŋ beme an damuŋ keyaŋ oloŋen penaŋ mpemti tosaŋaŋ temaŋ sawe. ");
INSERT INTO naf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Neŋ diindoma nâit, amobotnaŋaŋ mulup damuŋaŋ ke kwitnaŋ kwitnaŋ sambe amobotnaŋ ikŋaŋgalen ekdamuŋ mimiyelen zempewe. ");
INSERT INTO naf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yaŋgut an damuŋ keyaŋ ikŋaŋ kapigok zenak, ‘Amobotnaŋŋ sakwep ku kobe,’ kegok zemti mulup animbi ndomti meu ma tu kaliŋaŋ nimti keŋaŋ yuŋgu yuŋgu kwadak. ");
INSERT INTO naf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kegok sokbeme kan ŋengat an damuŋ keyaŋ amobotnaŋaŋaŋ kobeen ke ku nâmâtâge. Amobotnaŋaŋaŋ koekti an damuŋ ke sindiwaŋ omba penaŋ witikdak enenogat amobotnaŋaŋ mulup zet saye keyet kataŋ ku mge. Keyepmti wati met am bekanaŋ mimi ekŋengalen mundum bekananen ke peme ilinsakwep tabep. ");
INSERT INTO naf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Âpme an damuŋ keyaŋ amobotnaŋgalen nânâŋaŋ nâmâtâge yaŋgut egaŋ weyeyaŋ mulup ku mti esemteŋ penaŋ ku mâpme amobotnaŋaŋaŋ koekti sindiwaŋ omba penaŋ witikbe. ");
INSERT INTO naf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yaŋgut an damuŋ ŋen mulup amobotnaŋgalen nânâŋaŋ mulup sakam zigok mimiyelen ke ku nâmâtâti egaŋ mulup mme bekanaŋ bewe ya amobotnaŋaŋaŋ koekbeen omba penaŋ ku witikbe. An ŋen ek mânep milawatnaŋ ma nânâŋaŋ omba talasim sasaŋaŋ beme egaŋ penaŋaŋ ombaegak aikme ŋep bewe ma mulupmaŋ kogak windembeŋ mbe.” ");
INSERT INTO naf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zisasiyaŋ zet ewe kapigok tusum zeye, “Neŋ msalen am ingalen nâmkiŋpepe mkatikŋaŋ bembeyelen koban. Ma ingalen nâmkiŋpepe ikŋaŋ ke mma temaŋ bemti teziŋ keboŋ omba penaŋ ziwe. ");
INSERT INTO naf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Âpme neŋ nukŋaŋ temaŋ ma sindem omba penaŋ tiwap keyet nâmnukŋaŋ palen mmeti tima delaŋ zewe. ");
INSERT INTO naf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","In nâgâegaŋ an kasa kume totogalen koge ke manâip, ma? Yek, neŋ keyet penaŋ zema nâit, neŋ am kalalaŋgalen koban. ");
INSERT INTO naf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kan kapiyet yaŋbemti am mka kwepgat makukuŋin 5 ya kalaŋti an tugaŋ nembet ma an zulaŋ nembet nembet tati kasa kasa mbep. ");
INSERT INTO naf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sakam kegogak biwineyaŋ nemuŋine ekŋenmak kasa kasa mbep. Ma naniŋaŋ apmaŋgat mamaŋmak naniŋaŋ nemuŋaŋgat imbiŋaŋmak kasa kasa mbe. Âe yaŋaŋ kapigogat, ekŋenmagen notnaŋaŋ nâgât nâmkiŋpeme notnaŋaŋ ku nâmkiŋpewep keyepm set sakam kegok sokbewe.” ");
INSERT INTO naf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Âpme Zisasiyaŋ am maŋge temaŋ ekŋengat kapigok diindoye, “In kasup towewetnaset zanza sop kume in sakwep penaŋ, ‘Map tosâpm,’ manzeip. In kegok zeme penaŋ masokbein. ");
INSERT INTO naf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma tâgâyaŋ baeset keyetnaŋ kwapme beme in, ‘Kasup tasâpm,’ manzeip. In kegok zeme penaŋ masokbein. ");
INSERT INTO naf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","In an zet nambalam zutmak zenze! In kululuŋ ma msat egegalen sakamaŋ ekti eknâm mamip keyaŋgut kwitnaŋ kwitnaŋ alak tasokbein kapiyelen yaŋaŋ ku maeknâmâtâlip.” ");
INSERT INTO naf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Zisasiyaŋ zet ewe kapigok tusum zeye, “Neŋ nâyawen inmagen zet weyayaŋaŋ set katnaŋ kapiyaŋ ku tazin. ");
INSERT INTO naf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ke kapigok weyaŋ bep, inmagengatnaŋ an ŋen zet muluwen aik mebep beme ewe zet mulup mimi mkaen mebepiŋ tati igalen mânepgalen zet ke weyaŋbalup. Mneti geŋ zet nânâ an ekmagen gaik mepme egaŋ an dakutum ekŋengat belinan geme an dakutum ekŋenaŋ mka katikŋan kekgewep. ");
INSERT INTO naf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Neŋ zema nâmbak, geŋ mka katikŋaŋ towewepiŋ ewe belakŋaŋ tati mânep dopmaŋ sambe indamane delaŋ zewe mneti mka katikŋaŋ kwesiŋ kwesiŋ mamayelen gewepgat.” ");
INSERT INTO naf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Zisasiyaŋ zet kegok zemdelaŋ zeme kan keyet am notnaŋ Pailelaŋ zemindeme Galili am notnaŋ Kawawaŋgat sâpe sâpe tabumambienen Pailetgalen kasa kuku an ekŋenaŋ indome gakiwien keyelen zezapat Zisasiyet msawien. ");
INSERT INTO naf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kegok zeme Zisasiyaŋ ekŋengat zeye, “Galili am ekŋen set katnaŋ kegok mme indowien ekŋen keyelen yominaŋ mkawaŋ benen Galili am notnaŋ yomin sebemindeip, ma? ");
INSERT INTO naf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yek penaŋ! Neŋ zema nâit, in yomengatnaŋ ku gilik zewep beme ekŋenaŋ gakiwien in sakam kegok gakiwep.” ");
INSERT INTO naf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kegok zeme Zisasiyaŋ zet ewe tusumti kapigok zeye, “Am 18 Siloam mkaengatnaŋ ekŋen keyaŋ mka teepmaŋ kandaŋan tapme mka keyaŋ etumti indakwatame gakiwien. In nâiwen keyaŋ mkawaŋ beinen ekŋengalen bekanaŋ mimiŋinaŋ Zelusalem am sambe ekŋengalen bekanaŋ mimiŋin sebemindein, ma? ");
INSERT INTO naf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yek penaŋ! Neŋ zema nâit, in yomengatnaŋ ku gilik zewep beme in sambe sakam ekŋenaŋ gakiwienok in gakime delaŋ zewe.” ");
INSERT INTO naf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Âpme Zisasiyaŋ bemzenze zet kapigok diindoye, “An ŋenaŋ tep pik wain mulupmanen ondempeye. Ya egaŋ tep pik katnaŋgat meegeyaŋ penaŋepiŋ beye. ");
INSERT INTO naf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Keyepmti egaŋ mulup angat kapigok zeye, ‘Nânik, neŋ nup kan tuk pi tep pik katnaŋgat tepmanen mekoti ekbanaŋ ŋen ku elige. Keyepmti geŋ aŋpemane melak enenogat tep kapiyaŋ msat kelakŋaŋ saik mamm.’ ");
INSERT INTO naf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kegok zeme mulup an keyaŋ kapigok zeye, ‘Damuŋ, nup kan kwep ŋen pemane belak tapme neŋ tep yaŋan msat tokwat utumti sakokolok tipmaŋ timatopme omguluk gilik mti ekbap. ");
INSERT INTO naf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kegok mma katnaŋ elikzin ma ze ekbap. Elikbe beme dolakŋaŋ penaŋ. Âk yek bewe beme neŋ ŋep aŋbap.’” ");
INSERT INTO naf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Âpme Sabat tagoŋgo kan ŋengat Zisasiyaŋ sesewat mkaen am Zet Zapat Dolakŋaŋ Penaŋ zemzikat indaye. ");
INSERT INTO naf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kegok tapmme imbi ŋen keŋan ke tage ek we bekanaŋmak. We bekanaŋ keyaŋ nup kan 18 ekmak mamkwapme egaŋ zawat mkwage. Ma bisetnaŋaŋ kusum topme egaŋ dendaŋ esemteŋ ku matatagalen. ");
INSERT INTO naf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kogok mame Zisasiyaŋ imbi ke ekti kwizet kume kopme egaŋ egat kapigok dunduye, “Imbi, geŋ zawadi mâlap!” ");
INSERT INTO naf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kegok zemti egaŋ betnaŋaŋ imbi keyet bisetnaŋ atame keyegak bisetnaŋaŋ esemteŋ beme imbi keyaŋ Kawawaŋgat sesewage. ");
INSERT INTO naf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kegok sokbeme sesewat mkaengalen amobotnaŋaŋ Zisasiyaŋ kwitnaŋ kwitnaŋ ke Sabat tagoŋgo kangat mge keyepm egaŋ ŋenzinziŋ mge. Mmambe egaŋ am sambe tapmambien ekŋengat kapigok diindoye, “Kasup mulup 6 keyet mulup mamambep keyepmti kan ekŋen keyet koti am weyaŋindende mulup mamambep wa Sabat tagoŋgo kangat yek!” ");
INSERT INTO naf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Egaŋ kegok zeme Amobotnaŋaŋ egalen zetnaŋ nembet gilik zeye, “In an zet nambalam zut zenze! In Sabat tagoŋgo kangat makau apmaŋin ma doŋkiŋin tegen kwalet indemti mkaŋinangatnaŋ indatimti tu meu indaipgalen mundumen meti tu meu indame manip.” ");
INSERT INTO naf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kegok zemti zeye, “Imbi kapi Abalaamgalen alikŋaŋ ya we bekanaŋaŋ ekmak nup kan 18 mkipmaŋ penaŋ bemtage. Ya ek ŋep Sadaŋgalen winde Sabat tagoŋgo kanen ŋep mâpepeyelen.” ");
INSERT INTO naf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Egalen zet dopmaŋaŋ kasaŋane ekŋen mme sakambuk penaŋ tiwien. Keyegak am sambe tabien ekŋenaŋ menok sokbeye ke ekti oloŋen penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Âpme Zisasiyaŋ bemzenze zet ŋen kapigok zemti diindoye, “Kawawaŋgalen zemâtâtât katnaŋmamayet yaŋaŋ ke mastat katnaŋ keboŋ. Ma neŋ mastat katnaŋ keyet palen bemzema nâseip. ");
INSERT INTO naf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ke sepemaŋ mastat tep katnaŋ isikŋaŋ penaŋ amnaŋ mti muluwen ondeme kwati tep temaŋ sinaŋ betnaŋaŋ mme age ekŋenaŋ mkaŋin tep betnaŋ dukŋan walabien keyet sakam.” ");
INSERT INTO naf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kegok zemti ewe kapigok tusum zeye, “Kawawaŋgalen zemâtâtâtgat katnanen mama ke yis keboŋ. Ma neŋ yis keyet palen bemzema nâseip. ");
INSERT INTO naf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ke yis plawa meleseŋaŋ isikŋaŋ bugan imbi ŋenaŋ plawa omba kemak lelime keŋan kaindeyegak tasemem kwatneti temaŋ sosok makwazin keboŋ. ");
INSERT INTO naf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Zisasiyaŋ Zelusalem mka temanen mebegalen meti mka ŋande isikŋaŋ ma mka ŋande temaŋ keyelen am Kawawaŋgalen zezapat dolakŋaŋ zemzikat indaye. ");
INSERT INTO naf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kegok tapmepme an ŋenaŋ egat kapigok yaŋkwesiye, “Amobotnaŋ, geŋ zigok nânik, am kwep kwewaŋ mama kanzizit tiwep ma?” Kegok zeme Zisasiyaŋ am sambeyet diindoye, ");
INSERT INTO naf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","“In setokwakwat isikŋaŋ mama kanzizit titiyelen keyet keŋan mobogalen mulup windeŋaŋbeŋ mbep. In kegok ku mbep beme mka toŋaŋaŋ wati sekekindewe. Neŋ diindoma nâit, am sambe keŋan ke mobogalen mbep keyaŋgut ŋep ku mobep. Kegok sokbeme in zupman tati mka toŋaŋgat kwizet kumti zewep, ‘Amobotnaŋ, set kwaselemane kwatne!’ zewewaŋ egaŋ zewe, ‘In deyetnaŋ kolip? Neŋ ingat ku nâmindeyap!’ ");
INSERT INTO naf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Egaŋ kegok zeme in egalen zet dopmaŋ kapigok gilik zewep, ‘Nin tu meu geŋmak ningalen mkaen nimbenn ma geŋ ningalen mka temanen Kawawaŋgalen zezapat dolakŋaŋ mzikat ndawanan.’ ");
INSERT INTO naf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","In kegok zeme egaŋ ewe zewe, ‘In deyetnaŋ kolip ke neŋ ku nâmindeyap. In am mama mimi bekanaŋ mamipgat in sebeit!’ ");
INSERT INTO naf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kegok sokbeme in kululuŋen Kawawaŋgalen mundumen Abalaam ma Aisak ma Zekop ma golaŋ zenze an dolakŋaŋ ekŋen indikme Kawawaŋaŋ zemindeme in zupman tati sindemgat si zemsu zemsu mti zelin aŋgalikbep! ");
INSERT INTO naf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Âpme am sambe kasup kwakwatnaset ma towewetnaset ma baeset ma gwaeset nâmkiŋpepeŋinmagaŋ keŋan mowebep. Ekŋen keyaŋ Kawawaŋgalen mundumen totati Kawawaŋ ikŋaŋmak tu meu nimwiyaŋbep. ");
INSERT INTO naf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mme am ŋen kwitnaŋpiŋ tototnaŋ mamti Kawawaŋgat manâmkiŋpein egaŋ bamgat Kawawaŋgat zikatnan kwitnaŋmak bewe. Ma am ŋenaŋ kwitnaŋ mmoti windeŋaŋmak mamti Kawawaŋgat ku nâmkiŋpein egaŋ bamgat Kawawaŋgat zikatnan kwitnaŋpiŋ bewe.” ");
INSERT INTO naf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Âpme kan keyegak Palisi an notnaŋ Zisasmagen koti zewien, “Wae, amobotnaŋ Elolaŋ gosâgât zepgapm geŋ kapi pemti mesenik.” ");
INSERT INTO naf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ekŋenaŋ kegok zeme Zisasiyaŋ diindoye, “In tam kukŋaŋbeŋ keyet kapigok met dunduseip, ‘Neŋ alak ma saŋenen we bekanaŋ ammagen zemindewap ma am weyaŋindewap. Ya âgânen mulupm mdelaŋ zemti mebap.’ ");
INSERT INTO naf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Egaŋ zet kegok zemdelaŋ zemti am tabien ekŋengat kapigok diindoye, ‘Neŋ alak ma saŋen ma âgânen Zelusalem mka teman mebap.’ Golaŋ zenze an ŋen msat belakŋan kume gakikiyelen ke ŋep yek. Ek Zelusalem etaŋ mepme kume gakikiyelen. ");
INSERT INTO naf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Zelusalem am, in golaŋ zenze an ekŋen maindome gakip. Ma in Kawawaŋgalen zet busup an indeme makolip ke nanzaŋaŋ maindome gakip. Kan sambe neŋ betnnaŋ in Zelusalem am sambe indabembululuŋgalen manâyap sakam sakokolok mamaŋaŋ nembaŋane time pâpmaŋ kandaŋan maŋge mambemindein kegok. ");
INSERT INTO naf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Keyepmti neŋ zema nâit, ingalen sesewat mka temaŋ ke Kawawaŋaŋ katipeme ilinaŋgat belinan tapmosâpm. Âpme neŋ diindowi, Zelusalem am, in neŋ ewe ku nikbep ya maneti kan delaŋ zenzeen keyet in kapigok zewep, ‘Kawawaŋaŋ Nemuŋaŋ ombempeme kozin keyet nin oloŋen penaŋ mnup.’ Kegok zemeŋgut neŋ kobap.” ");
INSERT INTO naf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Âpme Sabat tagoŋgo kanen ŋengat Zisasiyaŋ Palisi amobotnaŋ ŋengalen mkaen moti tu meu nimbien. Kegok mme Palisi notnaŋaŋ Zisasiyet zikat giŋgiŋ tapmmambien. ");
INSERT INTO naf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kegok tapmme an setnaŋ betnaŋ sememeŋaŋ ŋenaŋ Zisasmagen kopme ");
INSERT INTO naf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","egaŋ ekti zii zet zikat indanda an ma Palisi an ekŋengat kapigok indayaŋkwesiye, “In zigok nâip, ningalen zii zelaŋ am Sabat tagoŋgo kanen ŋep weyaŋindendeyelen ma yek?” ");
INSERT INTO naf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kegok indayaŋkwesime ekŋenaŋ zetpiŋ diliŋ zemtabien. Kegok sokbeme Zisasiyaŋ an ke betnaŋaŋ atamweyaŋti zempeme mege. ");
INSERT INTO naf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kegok mti egaŋ ekŋengat indayaŋkwesiye, “Inmagengatnaŋ an ŋengat nemuŋaŋ mene ma makau apmaŋaŋ pusak teepmaŋ penaŋ keŋan baenen tuyaŋ tatatnaŋ keyet keŋan Sabat tagoŋgo kangat towedak beme zigok mnak? Egaŋ nemuŋaŋ mene ma makauŋaŋ ke keyegak mandame kwadak, ma yek?” ");
INSERT INTO naf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Egaŋ kegok zeme ekŋenaŋ ke nâmti sakambuk mtati zet dopmaŋ gilik zenzepiŋ diliŋ zemtabien. ");
INSERT INTO naf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tapme meu niniyelen mundumen tati Zisasiyaŋ indikme am notnaŋ zemindamandawien ekŋen keyaŋ koti mundum amobotnaŋgalen ombempewienen totabien. Kegok sokbeme Zisasiyaŋ ekti bemzenze zet ŋen kapigok diindoye, ");
INSERT INTO naf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“An ŋenaŋ geŋ awembiŋ bembeyelen tu meu niniyelen zemgamandanak beme geŋ meti amobotnaŋgalen mundumen sokŋan an imbi wawagalen tadak ekmak ŋep ku totabek, mneti mundum egat ganzenan ke amobotnaŋ geŋ sebem gein ŋengat ombem penak. ");
INSERT INTO naf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","An imbi wawagalen keyaŋ geŋmak an ŋenmak idamandanak ya egaŋ geŋmagen koti zenak, ‘Notn, geŋ mundum totadigen kapi an ŋen kapiyet ombempeye keyepm geŋ watati ek pemane totalak.’ Kegok zeme geŋ sakambuk penaŋ mti bam baenen metabek. ");
INSERT INTO naf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ma naman geŋ an imbi wawagalen keyaŋ zemgamandame geŋ meti mundum bam baen totabanik. Geŋ kegok mmane an geŋ ganzemandawe keyaŋ kot gikti zewe, ‘Notn, geŋ koti mundum nenmak sokŋan kukŋaŋgat gwaen totat.’ Kegok zeme mebanik keyaŋ mkawaŋ benen geŋ mobotnaŋ am sambeyet zikalinan kwabanik. ");
INSERT INTO naf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Am ŋenaŋ ikŋaŋgat sekŋaŋ tapmozin bewe Kawawaŋaŋ an ke mtopewe âk am ŋenaŋ ikŋaŋgat sekŋaŋ tapmtozin beme Kawawaŋaŋ an ke mmopewe.” ");
INSERT INTO naf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kegok zemti Zisasiyaŋ Palisi an ek zemandaye egat kapigok dunduye, “Kan ŋengat meundi dolakŋaŋ ŋen bumti nodi ma gitaŋgat nodi penaŋ ma gitaŋgat sip butnaŋ ma an mkaŋandaŋit kwep ŋen mânep milawatnaŋmak ekŋen ke ku zem indamandawanik enenogat geŋ meu zem indamandamti tu meu indawanik keyepm ekŋenaŋ dopmaŋ zemgamandamti gawep. Geŋ sakam kegok mnik beme dopmaŋ dilak ke tatinik. ");
INSERT INTO naf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Âpme naman tu meundi bumuluŋti am toweweŋaŋ ma am setnaŋ betnaŋ seleuuŋaŋ ma am wesiŋ ma am zikat beŋ ekŋen ke zemindamandawanik. ");
INSERT INTO naf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Geŋ kegok mbanigen Kawawaŋaŋ gâgât nâme dolakŋaŋ penaŋ bewe enenogat ekŋenaŋ gâlen tu meu dopmaŋ ŋep ku mutuwep. Kan am teŋ ekŋenaŋ sumengatnaŋ wabep kan keyet Kawawaŋaŋ dopmaŋ mutumgawe.” ");
INSERT INTO naf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Âpme an ŋen Zisas ekmak tu meu tatnmambien egaŋ Zisasiyaŋ zet zeye ke nâmti kapigok zeye, “Am Kawawaŋ mundum maekdamuŋ mnen kululuŋen ke ondekti ekmak tu meu temaŋ nimwiaŋbep am ekŋen keyaŋ oloŋen penaŋ mbep.” ");
INSERT INTO naf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Egaŋ kegok zeme Zisasiyaŋ dunduye, “An ŋenaŋ tu meu temaŋ bum ondekti am sambe zemindamandaye. ");
INSERT INTO naf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kan tu meu temaŋ bumululuŋgalen kwapme egaŋ mulup anaŋ zempeme am notnaŋ zemindamandawienen ke zeme kokogalen kapigok zempeye. Geŋ meti kapigok zesenik, ‘Kwitnaŋ kwitnaŋ sambe weyeyaŋ mulup mme delaŋ zepgat in kolit.’ ");
INSERT INTO naf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mulup an keyaŋ meti ekŋengat kegok zeme ekŋenaŋ zapat ke nâmti yaŋbemti zet tiŋko yaloŋ yaloŋ zet zewien. An kukŋaŋgat egaŋ kapigok zeye, ‘Neŋ msat butnaŋ ŋen kwitiman ya ke meti eksâbap. Keyepm nâmnemane neŋ ŋep ku kosap.’ ");
INSERT INTO naf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma an ŋenaŋ ewe kegogak zeye, ‘Neŋ makau apmaŋ 10 kwitiman ya alak ekŋen ke mulup indandayelen m ek m ek mimiyelen weyayaŋ mulup miyap. Keyepm nâmnemane neŋ ŋep ku kosap.’ ");
INSERT INTO naf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","An ŋenaŋ ewe sakam kegogak zeye, ‘Neŋ alakŋati imbi wapman ya yaŋaŋ keyepmti neŋ ŋep ku kosap.’ ");
INSERT INTO naf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kegok zemâpme mulup an keyaŋ zet sambe ke timti met an damuŋaŋ dunduye. Kegok zeme amobotnaŋaŋ ŋenzinziŋ penaŋ mti mulup anaŋgat kapigok dunduye, ‘Geŋ sakwep penaŋ mka ŋande temaŋgalen set isisikŋanen ma set temanen meti ekmane am toweweŋaŋ ma am sebelin seleuuŋaŋ ma am selin wesiŋ ma am zikalin beŋaŋ indatimane nâlen mkaen koseip.’ ");
INSERT INTO naf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kegok zeme mulup anaŋ meti egaŋ zeyenok mme delaŋ zeme koti zeye, ‘Amobotnaŋ, neŋ geŋ zemnenaknok mma delaŋ zep keyaŋgut mka keŋan amnaŋ ewe ku gak zep.’ ");
INSERT INTO naf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kegok zeme amobotnaŋaŋ mulup anaŋgat zeye, ‘Geŋ mka ŋande temaŋ ke pemti set temanen ma isikŋanen meti ekmane amnaŋ wiaŋme indatimane nâlen mkaen koti gak zeseip.’ ");
INSERT INTO naf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kegok zemti ewe kapigok tusum zeye, ‘Neŋ in nâlen mkaen kolip ingat zema nâit, am ekŋen kukŋaŋgat zem indamandama ekŋenaŋ ku kobien ekŋen keyaŋ nâlen tu meu tikŋaŋ ku nim nâwep, yek penaŋ.’” ");
INSERT INTO naf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Âpme Zisasiyaŋ Palisi an keyelen mka keŋangatnaŋ zupman toti mepme am maŋge temaŋaŋ ekmak mebien. Ke kopme egaŋ gilik zem indikti diindoye, ");
INSERT INTO naf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“An ŋenaŋ neŋ napmâti nâgât nemban kwasât nâwe beme keŋaŋaŋ nâgât omba penaŋ gogot mti mambipmaŋ ma imbiŋaŋ ma nemunambaŋane ma ikŋaŋgat ip notnane sip kwep ma ikŋaŋgat nâme tobe. Âk egaŋ kegok ku mbe beme egaŋ nâgât nemban ku tabe. ");
INSERT INTO naf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma naman an ŋenaŋ nâgât nemban tasât nâwe beme egaŋ neŋ napmâti ikŋaŋgat nukŋaŋaŋ pumti egaŋ gakikiyelen weyeyaŋ mulup mbe enenogat egaŋ nâgât manâmkiŋpein.” ");
INSERT INTO naf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kegok zemti zeye, “An inmagengatnaŋ ŋenaŋ mka teepmaŋ amnaŋ tati an kasayet dombembeyet walasât nânak beme egaŋ, ‘Mânep zigok time mebe?’ ma ‘Kwitnaŋ kwitnaŋ ziboŋ kwitiwap?’ ke nâmâtâti kwitimti mka ke ŋep walapme delaŋ zenak. ");
INSERT INTO naf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Âpme an keyaŋ kegok ke ku mnak beme mka teepmaŋ ke walat delaŋ zenzepiŋ mka ke timbilaŋge etaŋ mpeme tatnak. Egaŋ kegok mpeme am notnaŋaŋ mka ke ekti egat zet mtopepen zet zemti ek yeŋti kapigok zewiek, ");
INSERT INTO naf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘An kapi mkaŋaŋ yaŋbeye ya egaŋ ewe ku mdelaŋ zein!’ ");
INSERT INTO naf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Sepem kegogak amobotnaŋ ŋen kasa kuku anaŋ ten tausen (10,000) etaŋ ya egaŋ amobotnaŋ ŋengalen kasa kuku anaŋ twenti tausen (20,000) ekŋenmak auuyelen nânak beme egaŋ weyaŋ nâmâtâti amobotnaŋ ŋen keyelen windeŋaŋ kume totogalen ma yek keyelen nâmbiliwetnak. ");
INSERT INTO naf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kegok sokbeme egaŋ otnânagaŋ ŋep ku auuyelen benak enenogat amobotnaŋ ŋen keyelen kasa kukuŋane windeŋinbeŋ penaŋ. Keyepm egaŋ an notnaŋ indeme sabeŋan keyegak tapme amobotnaŋ ke meaikti ku auuyelen yaŋkwesimti egaŋ milawat kwilekiyet nâmtikŋaŋ min keyet yaŋkwesiwiek. ");
INSERT INTO naf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sakam kegogak am ŋenaŋ nâgât nemban ma neŋ napmâsât nâwe beme egaŋ kwitnaŋ kwitnaŋ sambe bamkumpewe.” ");
INSERT INTO naf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Âpme Zisasiyaŋ zet ewe kapigok tusum zeye, “Dalaŋ ek dolakŋaŋ ma tikŋaŋ penaŋ. Âk dalaŋaŋ tikŋaŋ delaŋ zenak beme nin tikŋaŋ ke mulupmaŋ mti ŋep ku aikbenek. ");
INSERT INTO naf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dalaŋ sakamaŋ keboŋ keyaŋ muluwen sikokok ma meu ŋep ku mukulem mme dolakŋaŋ kwakwagalen keyepm belak peme mebegalen. An ŋen zet nânâyelen tikŋaŋaŋ tazinaŋ zet kapi ŋep opeimti nâsem.” ");
INSERT INTO naf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Âpme kan ŋengat an mânep takis titi ma am yomtoŋ ekŋenaŋ Zisasmagen sokŋan egalen zet nâsâgât kobien. ");
INSERT INTO naf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kegok sokbeme Palisi ma zii zet zikat indanda an notnaŋ yaŋbemti sekaŋgaŋ zet zemti kapigok zewien, “An kapi a yomtoŋ ekŋenmak notn notn mti meu mka kwep manip!” ");
INSERT INTO naf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ekŋenaŋ kegok zeme Zisasiyaŋ bemzenze zet ŋen kapigok diindoye, ");
INSERT INTO naf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“An inmagengatnaŋ ŋen sipsipmaŋ 100 tasanak ya kwep ŋen galaŋ zenak beme egaŋ zigok penaŋ mnak? Kegok sokbenak beme egaŋ sipsip 99 ekŋen meuŋin maniniŋanen munduman indeme tapme egaŋ kwep keyet timat metneti aikdak. ");
INSERT INTO naf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Egaŋ aikdagen kan keyet oloŋen penaŋ mti ŋandeŋan oletetep peme weme ");
INSERT INTO naf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","mkaŋan pum kotnak. Kegok mti egaŋ notnane ma am egalen mkamagen sokŋan talip ekŋengat zeme koondakme diindonak, ‘Neŋ sipsipm galaŋ zeme timalawaŋ aikti oloŋen penaŋ miyap keyepm koondakme tu meu bumuluŋti nne!’” ");
INSERT INTO naf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Zisasiyaŋ kegok zemti ewe kapigok tusum zeye, “Neŋ in zema nâit, sakam kegogak msalengalen an yomtoŋ ŋenaŋ yomengatnaŋ keŋaŋ gilik zemti neŋmagen matusunen kululuŋen ekŋenaŋ oloŋen penaŋ mamip. Kegok sokbeme am 99 ekŋenaŋ yominangatnaŋ ku gilik zeip ekŋengat manâiwen ekŋen an kwetetepmaŋ penaŋ.” ");
INSERT INTO naf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kegok zemti ewe tusum zeye, “Imbi ŋen tambu kwep tu meu kwitim niniyelen silwa mânep kanziŋaŋ 5 tasanak ya ŋen galaŋ zenzeŋaŋ benagen egaŋ zigok mnak? Egaŋ lamaŋ koŋti mka keŋan kaputi weyaŋ timat metneti mânepmaŋ ke aik mti ");
INSERT INTO naf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","kan keyet oloŋen penaŋ mti notnane ma am egalen mkamagen sokŋan talip ekŋengat zeme koondakme diindonak, ‘Ekŋen, mânepm galaŋ zeme matimalawaŋ aikti oloŋen penaŋ miyap keyepm koondakme tu meu bumuluŋti nne!’ ");
INSERT INTO naf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Neŋ diindoma nâit, sakam kegogak Kawawaŋgalen enselŋane kululuŋen ekŋenaŋ a yomtoŋ ŋenaŋ mama mimiŋaŋ bekanaŋ bamkumpemti neŋmagen matusunen ensel ekŋenaŋ oloŋen penaŋ mamip.” ");
INSERT INTO naf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kegok zemdelaŋ zemti ewe kapigok tusum zeye, “An ŋen nemuŋane zomolim melezut matapmambuk. ");
INSERT INTO naf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ya nemuŋaŋ muŋaŋ bipmaŋmagen koti kapigok zenak, ‘Bien, msat ma milom bilombi bam nanayelen nâwanan ke ilak alak kapi na!’ Kegok zeme biwidaŋ msat ma milom bilombi kalaŋti nemulatnene idaye. ");
INSERT INTO naf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kegok sokbeme kasup mulup mimi notnaŋ delaŋ zeme nemuŋaŋ muŋaŋ msat ma milom bilombiŋaŋ beme amnaŋ kwitime egaŋ msat ke pemti mânepmaŋ timti pem ŋen beŋan penaŋ mege. Ke mepmamti mânepmaŋ sambe mama mimi bekananen time mepme delaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kan mânepmaŋaŋ delaŋ zeyeen meuyet kambeŋ temaŋ msat kataŋ sokbeye. Kegok sokbeme ek kwitnaŋ ŋen ku tasaye. ");
INSERT INTO naf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Keyepm egaŋ met an msat keyelen an ŋengalen mulup mge. Âpme an keyaŋ peme met egalen bo mkaen bo damuŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Egaŋ meuyet penaŋ gakisât mti boyelen meuŋaŋ ke niniyelen nâye yaŋgut bo damuŋ keyaŋ ku nâmpeme niŋge. ");
INSERT INTO naf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kegok sokbeme kan egaŋ nânâ dolakŋaŋ aigeen ikŋaŋgat kapigok zeye, ‘Bipmnaŋgalen mulup am sambe meu maniwiaŋip ya neŋ pi tati meuyet gakisowap! ");
INSERT INTO naf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Keyepm neŋ wati bipmmagen meti kapigok zewap, “Bien, neŋ Kawawaŋgat zikatnan ma gâgât zikadan yom mban. ");
INSERT INTO naf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya ‘Geŋ nâgât nemun,’ ŋep ewe ku zenzeyelen. Geŋ nemane gâgât mulup andi etaŋ tabi.”’ ");
INSERT INTO naf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kegok nâmti wati bipmaŋmagen mege. Egaŋ ewe bipmaŋgalen mkaen mebepiŋ beŋan tapmepme bipmaŋaŋ ekti keŋaŋaŋ nemuŋaŋgat kembeŋ penaŋ nâmti winde bem meti nemuŋaŋ kot ambeti zem oloŋen mpemti egaŋ gilik ze koge keyelen oloŋen penaŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kegok mti nemuŋaŋaŋ bipmaŋgat zeye, ‘Bien, neŋ Kawawaŋgat zikatnan ma gâgât zikadan yom mban. “Geŋ nâgât nemun,” zenzeyelen ŋep yek.’ ");
INSERT INTO naf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Nemuŋaŋaŋ kegok zeme bipmaŋaŋ mulup an sambeyet kwizet kume kopme diindoye, ‘An ekŋen, nemun kapi neŋ nemti mepmame wa gakiye zem mban yaŋgulak alak pi ninmak alik tazin keyepm in sakwep penaŋ met kâlâp teepmaŋ dolakŋaŋ penaŋ ke mkoti munduŋpeit ma besaŋ isikŋaŋ mkoti betnaŋ dukŋanen wepeit ma set mundunduŋ mkoti setnanen munduŋpeme tapme makau nembaŋaŋ gandenaŋ mepmti kume gakime tu meu bumuluŋti olioli temaŋ mti nsenup!’ Egaŋ kegok zemindeme zetnaŋ gawepumti tu meu weyaŋ beme nimti oloŋen mbien. ");
INSERT INTO naf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kegok sokbeme kan keyet nemuŋaŋ yuyaŋ muluwen tage. Ya egaŋ mulup mdelaŋ zemti mkaen kokogalen sokŋan koti nâme ekŋengalen olioli silik ma gwasim kwisak nâye. ");
INSERT INTO naf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Egaŋ kwisak ke nâmti mulup anaŋ ŋen ekti kwizet kume kopme yaŋkwesiye, ‘Wae, an notn, da kwileki tapmip?’ ");
INSERT INTO naf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kegok zeme mulup anaŋaŋ dunduye, ‘Muŋdi gilik zem kopme bipdaŋ makau nembaŋaŋ gandanaŋ kumti bup enenogat muŋdaŋ kasayet belinan mobopiŋ esemteŋ tati gilik ze kolep keyepm olioli tapmip.’ ");
INSERT INTO naf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kegok zeme nemuŋaŋ yuyaŋ ŋenzinziŋ penaŋ mti mka keyet keŋan mobogalen ku nâmtikŋaŋ mge keyepmti bipmaŋaŋ zupman kwatoti egat keŋan mtoti mka keŋan mobogalen wekuye. ");
INSERT INTO naf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bipmaŋaŋ kegok zeme nemuŋaŋaŋ bipmaŋgat zeye, ‘Bien, ekbak, neŋ nup kan sambe pi mulup katikŋaŋ mulup andinok gâgât mkwaban ma neŋ gâlen zet ŋen ku makuluyap. Geŋ kwileki penaŋ mnawanan? Geŋ meme nembaŋaŋ gandenaŋ bugan ŋen ku namane notnne ekŋenmak bumuluŋti ku nimbenn, yek penaŋ!’ ");
INSERT INTO naf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kegok zemti ewe zeye, ‘Ya nemundi muŋ kapiyaŋ gâlen msat ma milom bilombi beme amnaŋ kwitime mânep timeti sek kileŋ imbi indame delaŋ zeme gilik zem mkaen kolewen geŋ makau nembaŋaŋ gandenaŋ egat kumti bunak!’ ");
INSERT INTO naf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Egaŋ kegok zeme bipmaŋaŋ dunduye, ‘Ayu, nemun, geŋ neŋmak kwesiŋ matakwadik ya nâlen kwitnaŋ kwitnaŋ sambe kapi gâlen etaŋ. ");
INSERT INTO naf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nodi kapi nin ndemti mepmame wa gakiye zem mbenn yaŋgulak alak pi ninmak alik tazin keyepmti nin tu meu bumuluŋti olioli temaŋ msenup.’” ");
INSERT INTO naf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Âpme Zisasiyaŋ nembaŋane ekŋengat zet kapigok diindoye, “An mânep milawatnaŋ temaŋmak ŋen maŋge. Egaŋ an ŋen mulup damuŋ peye ya maneti am notnaŋaŋ mulup damuŋ keyaŋ mânep kambu mip kegok zemti an mulup toŋaŋmagen zem kuwien. ");
INSERT INTO naf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kegok zeme an mulup toŋaŋ keyaŋ mulup damuŋ ke zemandaye, ‘Geŋmagen zet nâya ke kwilekiyelen? Geŋ meti nâlen kwitnaŋ kwitnaŋ sambe ke kabemane topme nen kotna enenogat geŋ nâlen mulup damuŋ ewe ku tatagalen.’ ");
INSERT INTO naf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kegok zeme mulup damuŋ keyaŋ ikŋaŋgat kapigok zeye, ‘An mulup toŋaŋ muluwen zemnen ya neŋ zigok penaŋ mbap? Neŋ an pembenaŋ msat enzuŋaŋ walalatgalen winde ku tatnain ma neŋ amgat mânepgat wekukuyet sakambuk penaŋ miyap. ");
INSERT INTO naf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Oo neŋ kwileki mbap ke alakŋati nâyap. An mulup toŋaŋ zemneme notnne sambe ekŋenaŋ nikdamuŋ mbep.’ ");
INSERT INTO naf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Keyepmti am an mulup toŋaŋgalen mânep butnaŋ belak tiwien ekŋen inda zemandame egalen mkaen koondakbien. Kegok sokbeme kwep kukŋaŋgat koge keyet yaŋkwesiye, ‘Geŋ mânep amobotnaŋmagen zigok tiwanan?’ ");
INSERT INTO naf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yaŋkwesime egaŋ zeye, ‘Neŋ kelakŋaŋ tuŋaŋ nukŋaŋaŋ 800galen tiwan.’ Kegok zeme an damuŋ keyaŋ zeye, ‘Ele, kelakŋaŋ tuŋaŋ belak mbanan keyelen papia kapi tewen bumane zime alakŋaŋ kapi mti kelakŋaŋ butnaŋ 400 etaŋ kumpe.’ ");
INSERT INTO naf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kegok mti an damuŋ keyaŋ an ŋengat yaŋkwesiye, ‘Geŋ an mulup toŋaŋgalen mânep belak zigok tiwanan?’ Kegok zeme an keyaŋ zeye, ‘Neŋ wit katnaŋ bek 400 kwep kwep nukŋaŋaŋ 50 kilo kegok tiwan.’ Kegok zeme an damuŋ keyaŋ zeye, ‘Ele, wit katnaŋ belak mbanan keyelen papia kapi tewen bumane zime alakŋaŋ kapi mti bek 300 etaŋ kumpe.’ ");
INSERT INTO naf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kegok mme an damuŋ keyelen an mulup toŋaŋ an damuŋ keyaŋ ikŋaŋgat kambuŋaŋ aŋgalalaŋgalen zet nâmâtâtâtnaŋmak zeye keyet nâmti nâme moge. Enenogat am msalen Kawawaŋgat ku manâmkiŋpeip ekŋenaŋ mama mimiŋin bekanaŋ mimenzililiyelen nânâŋin pembenaŋ matatindame am Kawawaŋgat manâmkiŋpeip ekŋen sebem indeip.” ");
INSERT INTO naf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zisasiyaŋ nembaŋane zet ewe kapigok tusum zeye, “In nâwienen neŋ sakam kegok ku mimiyelen zemindewan, yek penaŋ. Neŋ notn notn tetimaeyaŋ kwititiyelen ku zemindewan. Ma tetimae keyaŋ nânâ dolakŋaŋ game mama kanzizit ke mti kwesiŋ kwesiŋ mambanik? Yek penaŋ! ");
INSERT INTO naf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","An ŋenaŋ kwitnaŋ kwitnaŋ isikŋaŋgat dâsuki ku zewe beme egaŋ kegogak kwitnaŋ kwitnaŋ temaŋgat dâsuki ku zewe. Ma an ŋenaŋ kwitnaŋ kwitnaŋ isikŋaŋgat dâsuki zewe beme temaŋgat kegogak dâsuki zewe. ");
INSERT INTO naf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","In msatgalen kwitnaŋ kwitnaŋ weyaŋti dolakŋaŋ ku ekdamuŋ mbep beme Kawawaŋgalen mulup ŋep ku nâmindeme ekdamuŋ mbep. ");
INSERT INTO naf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma in nolin ŋengalen kwitnaŋ kwitnaŋ weyaŋti dolakŋaŋ ku ekdamuŋ mbep beme kululuŋengalen kwitnaŋ kwitnaŋ Kawawaŋaŋ in ŋep ku nâmindeme ekdamuŋ mbep. ");
INSERT INTO naf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mulup an ŋenaŋ mulup damuŋ zutgat kandaŋidaŋ ŋep ku mamayelen. Egaŋ kegok mnak beme ŋengat sekaŋgaŋ mpemti ŋengat gogot mnak. In kegogak Kawawaŋgalen mulup ma mânep milawatmak mama eget temakwep idapepebemti ku mimidadayelen.” ");
INSERT INTO naf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Âpme Zisasiyaŋ zet kegok zeme Palisi ekŋenaŋ zet ke nâmâtâti ekŋenaŋ mânepgat nâmtikŋaŋ mamip keyepmti Zisasiyet zetnaŋgat wisat mbien. ");
INSERT INTO naf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ekŋenaŋ kegok mme Zisasiyaŋ indik mâtâti zeye, “In amgat zikalinan ilinaŋgat nâme mobotnaŋ penaŋ mambein yaŋgut Kawawaŋaŋ ingat keŋin maekmâtâzin. Amnaŋ in kwilekiyet nâme mobotnaŋ mambein ke Kawawaŋgat zikatnan okbi okbi mambein.” ");
INSERT INTO naf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Zisasiyaŋ zet ewe tusum zeye, “Itnaŋaŋ baen Mosesiyelen zii zelen ma golaŋ zenze an notnaŋaŋ meluwaŋ mbien amnaŋ ke mâpmane peme kan Zân tu zulutindende an egaŋ koge. Kan keyet Zânaŋ Kawawaŋgalen zemâtâtât katnanen mama keyelen zezapat dolakŋaŋ mkawaŋ beme amnaŋ zezapat dolakŋaŋ keyet nâmtikŋaŋ penaŋ mti mâbien. ");
INSERT INTO naf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kululuŋ ma msat ke Kawawaŋaŋ eleŋ beleŋ penaŋ asekbe keyaŋgut Kawawaŋ ikŋaŋgalen zet ke ku asekbe.” ");
INSERT INTO naf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Zisasiyaŋ zet ewe kapigok tusum zeye, “An ŋenaŋ imbiŋaŋ asekpemti imbi ŋen wabe beme egaŋ awembiŋ mama ke kalaŋti yom tiwe. Ma an ŋenaŋ imbi apmaŋ asekpepeŋaŋ wabe beme an keyaŋ awembiŋ kalalaŋ mti egaŋ Kawawaŋgat zikatnan yom tiwe.” ");
INSERT INTO naf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Âpme Zisasiyaŋ zet ewe kapigok tusum zeye, “An mânep milawatnaŋmak ŋen maŋge. Egaŋ kâlâp teepmaŋ dolakŋaŋ penaŋ tosaŋaŋ temaŋ mamunduŋ mamtan ma kan kataŋ egalen tatat mimiŋaŋ dolakŋaŋ penaŋ matakwatan. ");
INSERT INTO naf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Âpme an ŋen peweweŋaŋ penaŋ kwitnaŋ Lasalus egaŋ Kawawaŋgat gogot penaŋ mamtan. Ma ek sekŋaŋ ilindiŋ liŋgilaŋ pesak pepeŋaŋ ke wakoti an mânep milawatnaŋmak ke egalen kimbat setokwakwalen peme mawemtan. ");
INSERT INTO naf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ke matapme, ‘An mânep milawatnaŋmak egalen meu butnaŋ temepme makumtimti kot name nsap,’ kegok otnâmti matatan. Ma tam ekŋenaŋ koti egalen liŋgitnaŋ mambesemtemien. ");
INSERT INTO naf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kegok sokbeme Lasalus ek gakime Kawawaŋgalen ensel ekŋenaŋ kopmti Abalaamak kululuŋen gwaen mopewien. Kegok mme an mânep milawatnaŋmak keyaŋ kegogak gakime sumen mebewien. ");
INSERT INTO naf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kegok sokbeme an keyaŋ teziŋ ŋandaŋen metoti sindem temaŋ tiye. Kegok mti ekme mopme Lasalus ya Abalaamgat ganzenan beŋan tabalut idige. ");
INSERT INTO naf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ke tapmalut egaŋ idikti kwizet kapigok kume moge, ‘Bipm Abalaam, geŋ nâgât kembeŋ nâmti Lasalus zempemane tu bugan betnaŋaŋ olekti nambalam mnan olekme kipmaŋ kapiyaŋ ombem tolak enenogat tewen kapi tati sindem omba penaŋ tiyap!’ ");
INSERT INTO naf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Egaŋ kegok zeyeyaŋgut Abalaamaŋ dunduye, ‘Nemun, geŋ kapi otnâmbak, geŋ msat palen baenen mamandi dolakŋaŋ penaŋ mambanan âpme Lasalus ek an peme weweŋaŋ penaŋ maŋge. Yaŋgut egaŋ pienen nenmak oloŋen tapme geŋ teziŋ ŋandaŋen sindem tatinik. ");
INSERT INTO naf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Âpme ŋen kapi, ningat tuŋgupmnan ma gâgât tuŋgupdan ŋandaŋ temaŋ penaŋ tazin keyepmti an ŋenaŋ piengatnaŋ geŋmagen kainde kwakwagalen nâin beme ŋep ku kwadak. Ma ŋenaŋ geŋmagengatnaŋ ninmagen pien ŋep ku kwakwagalen.’ ");
INSERT INTO naf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Abalaam kegok zeme an mânep milawatnaŋmak keyaŋ kapigok zeye, ‘Bien, neŋ gâgât gawekuyap, geŋ Lasalus pemane nâlen bipmnaŋgalen mkaen melak. ");
INSERT INTO naf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mkaen ke notnne 5 ekŋenmagen meti mama mimiŋin bekanaŋ mamip keyet golaŋin timti diindome ekŋenaŋ mundum bekanaŋ sindemaŋmak neŋ talap kapi ku kobep.’ ");
INSERT INTO naf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kegok zeme Abalaamaŋ dunduye, ‘Mosesiyelen zii zet ma golaŋ zenze an notnaŋgalen golaŋ zet kumpepeŋaŋ ke maiŋti nânâyelen. Zet keyaŋ ekŋengat golaŋin titiyelen.’ ");
INSERT INTO naf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kegok zeme an mânep milawatnaŋmagaŋ kapigok zeye, ‘Bipm Abalaam, zet keyaŋ ekŋen ku mkawaŋ bem indendeyelen yaŋgut an ŋenaŋ gakikiengatnaŋ wati Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ mkawaŋ bewe beme keyaŋ mme keŋin yominaŋgatnaŋ gilik zewep.’ ");
INSERT INTO naf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Egaŋ kegok zeyeyaŋgut Abalaamaŋ dunduye, ‘Âpme ekŋenaŋ Mosesiyelen zii zet ma golaŋ zenze an ekŋengalen zet wisat mbiek beme ekŋenaŋ an gakikiengatnaŋ wadak egalen zet ku nâmti mâbiek.’” ");
INSERT INTO naf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Âpme Zisasiyaŋ zet kegok zemdelaŋ zemti nembaŋane ekŋengat kapigok diindoye, “Am yomen zet kelakŋaŋ mti tetipepeyelen keyaŋ inmagen takwasâpm keyaŋgut wakae, am ŋenaŋ yomen tetimae mbe keyaŋ sindem omba penaŋ tisâpm! ");
INSERT INTO naf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","An ŋenaŋ nemba isikŋaŋnok ekŋen kapimagengatnaŋ ŋen tetipeme yom mbe beme an walepewe ek ke nanzaŋ siput temaŋ penaŋ bimanen andopemti âtâpeme nembu keŋan toweti gakiwe keyaŋ dolakŋaŋ bein ma musuwewet keyaŋ nukŋaŋ ku bein. Mneti ekŋenaŋ kegok ku mme egaŋ belak tapmetneti Kawawaŋgalen zemdelaŋ zenze kanen dopmaŋ nukŋaŋ bekanaŋ penaŋ tiwe. ");
INSERT INTO naf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","In weyaŋ ekmâtâbep! Âpme nodi ŋen nâmkiŋpepeŋaŋmagaŋ yom kwitnaŋ ŋen mbe beme zet weyeyaŋ katnan meti weyaŋpewanik. Kegok mmane yomaŋ zemkawaŋ bein beme yomaŋ pemane mebe. ");
INSERT INTO naf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Âpme nodi keyaŋ geŋmagen kasup kwepgat yom sek zigok min beme egaŋ geŋmagen sek mbe keyet katnaŋ koti nâmsokukuŋaŋ ke zemkawaŋ bemgeme geŋ egalen yomaŋ katipewanik.” ");
INSERT INTO naf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Âpme Zisasiyaŋ zet kegok zemdelaŋ zeme nembaŋane ekŋenaŋ egat kapigok zewien, “Geŋ mukulem mindemane ningalen nâmkiŋpepenn katikŋaŋ bak.” ");
INSERT INTO naf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ekŋenaŋ kegok zeme Amobotnaŋaŋ zeye, “Kapis alik katnaŋ ek isikŋaŋ penaŋ keyaŋgut egaŋ msat keŋangatnaŋ windeŋaŋ bemti sosok pataŋ pemti sinaŋaŋ mme matimbunup. Ya ingalen nâmkiŋpepeŋin sakam keboŋ benak beme in tep kaindeyet zewiek, ‘Geŋ giti seŋti gitiyegak, nembu tuŋgupman metabanik.’ Kegok zempeme egaŋ ingat zelin gawepumti kegok mnak. Ya ingalen nâmkiŋpepeŋin sakam keboŋ benak beme in Kawawaŋgalen mulupmaŋ ŋep mme penaŋaŋ sokbenak.” ");
INSERT INTO naf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","Âpme Zisasiyaŋ zet ewe tusum zeye, “Inmagengatnaŋ ŋengat imbiŋaŋ muluwengatnaŋ mulupmaŋ mdelaŋ zemti tep yâgâp mti mkaen koti yaloŋpemti tu meu bume nimbiek keyet apmaŋaŋ mânep sawe? ");
INSERT INTO naf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yek, kegok ŋep ku mnak. Egaŋ ikŋaŋgat mulup imbiyaŋ mimiyelen zempepeŋaŋ keyet katnaŋ mip.” ");
INSERT INTO naf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Zisasiyaŋ kegok zemti ewe tusum zeye, “Inmagen sakam keboŋ keyaŋ bein. In Kawawaŋgalen mulup mti am ekŋenaŋ ingat wisikŋ zenzeyet ku wekuwep eneyet mulup e in mimiyet zemindendeŋaŋ. ‘Nin mulup an etaŋ kwizapatnpiŋ. Nin mulup zemndendeŋaŋ etaŋ katnan mâti mbenn.’” ");
INSERT INTO naf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Âpme Zisasiyaŋ Zelusalem mka teman mebegalen Galili msalen koti Samalia msalen kot pataŋ zenzeyelen koge. ");
INSERT INTO naf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Keyetnaŋ koti mka ŋande isikŋan kopataŋ zeme an liŋgilin satnaŋmak 10 ekŋenaŋ beŋan tati ");
INSERT INTO naf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kwizet kapigok kuwien, “Zisas! Amobotnaŋ! Ningat kembeŋ nâmnde!” ");
INSERT INTO naf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kegok zeme Zisasiyaŋ indikti zeye, “In sâpe sâpe bumbu an ekŋenmagen mepme ekŋenaŋ ingat sekŋin wiliŋgisem.” Kegok zemindeme ekŋenaŋ selen tapmetnepeme sek liŋgilin ŋeluye. ");
INSERT INTO naf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kegok sokbeme ekŋenmagengatnaŋ an ŋenaŋ sekŋan wiliŋgiyeyaŋ sekŋan liŋgit satnaŋ ŋelume gilik ze Zisasmagen koti Kawawaŋgat kwitnaŋ mwati kwizet kumsesewage. ");
INSERT INTO naf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kegok mmeti Zisasmagen pataŋ zemti egat setnanen msalen baenen pedondo mti egat wisikŋ zeye. (Âpme an ke Zuda am maŋgeen ku sokbembeŋaŋ ek Samalia msalengatnaŋ.) ");
INSERT INTO naf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","An keyaŋ kegok mme Zisasiyaŋ ke ekti kapigok zeye, “Neŋ nâyawen an 10 ekŋenaŋ ŋep beyo ya ekŋenaŋ neŋmagen koti Kawawaŋgat wisikŋ ŋep zenzeyelen yaŋgut 9 ekŋenaŋ belak mepme an kapi Zuda ekŋengalen maŋgeengatnaŋ yek yaŋgut ek etaŋaŋ Kawawaŋgat wisikŋ neŋmagen kozein.” ");
INSERT INTO naf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kegok zemti zeye, “Ekŋenaŋ Kawawaŋgat sesewawatgalen neŋmagen ku kolo keyaŋgut an msatnaŋ pemŋengatnaŋ kapiyaŋ etaŋ kolep.” ");
INSERT INTO naf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Zisasiyaŋ kegok zemti an keyet kapigok dunduye, “Geŋ nâgât nâmkiŋpenik keyepm geŋ ŋep benigat wati met.” ");
INSERT INTO naf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Âpme Palisi notnaŋaŋ Zisasiyet yaŋkwesiwien, “Kan kwilekiyet Kawawaŋaŋ an peme koti egalen zemâtâtât katnanen mamayet zeye keyaŋ kobe?” Ekŋenaŋ kegok yaŋkwesime Zisasiyaŋ kapigok diindoye, “Kawawaŋgalen an kobe ke amnaŋ ku eknâmâtâtâgalen set katnaŋ kegok kobe. ");
INSERT INTO naf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma am ŋenaŋ kapigok ku zewe, ‘Pien tazingat egit!’ ma ‘Daen tazingat meegit!’ Kegok ku zewe. Enenogat Kawawaŋ an peme kokogalen zeye ke ingat tuŋguwinan tazin.” ");
INSERT INTO naf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Zisasiyaŋ kegok zemti nembaŋane ekŋengat diindoye, “Âpme Angat Nemuŋaŋgalen kanaŋ kopme in kasup kwep eegalen nâmtikŋaŋ penaŋ mbep keyaŋgulak in ek ku ekbep. ");
INSERT INTO naf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma am notnaŋaŋ ingat kapigok zewep, ‘Egit, ek danen tazin!’ ma ‘Ek pien tazin!’ Kegok zeme in ke meegapiŋ. ");
INSERT INTO naf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Angat Nemuŋaŋ neŋ kokotnaŋgalen kanen sakam ambeyegaŋ kululuŋ nembetgatnaŋ nembet busatnaŋ temaŋ peyak mme am sambeyaŋ maegip sakam keboŋ kopma in nikti nâmâtâbep. ");
INSERT INTO naf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yaŋgut kukŋaŋgat am alak talip kapiyaŋ sekaŋgaŋ nâmnemti ku nâmtikŋaŋ mnemti nomti sindem ombanawep. ");
INSERT INTO naf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Âpme set katnaŋ an kwitnaŋ Noa egalen kanen sokbeyeen amnaŋ mamtemienok tu meu nimwiaŋti awembiŋ bemâti Kawawaŋgat ku otnâwien. Sakam kegok tapmambienen Noayaŋ waŋga temaŋ keŋan mowepme tuŋgwam temaŋaŋ kwati animbi ekŋen ma kwilekiki sambe indamziliye. Angat Nemuŋaŋ neŋ kokotnaŋgalen kanen sepem kegok sokbewe. ");
INSERT INTO naf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ma set katnaŋ kegogak an kwitnaŋ Lot egalen kanen sokbeye keboŋ. An imbi sambeyaŋ tu meu nimwiaŋbien ma aem kwaem mbien ma timonzewien ma mka walabien. Kegok mti Kawawaŋgat ku otnâmbien. ");
INSERT INTO naf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kan Lot an egaŋ Sodom mka temaŋ pemti mepme teziŋmak nanzaŋ salpa kululuŋengatnaŋ mapnok toti animbi indawalepme gakiwien. ");
INSERT INTO naf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sakam kegok Angat Nemuŋaŋ neŋ sosok kwakwagalen kanen sokbewe. ");
INSERT INTO naf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Âpme kan keyet am ŋenaŋ mkaŋaŋ tambaŋguman tapmambe ya keyaŋ sokbeme milawatnaŋ mka keŋan ku akum tinak. Ma sepem kegogak am ŋenaŋ muluwen tapmanak ya keyaŋ sokbeme egaŋ milawatnaŋgat nâmti mkaen ku medak. Mneti ek pemepme olatnagat. ");
INSERT INTO naf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sakam Lotgat imbiŋaŋaŋ bamanen gilik zem ekti gakiye keyet otnâit! ");
INSERT INTO naf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Âpme an ŋenaŋ sekŋaŋgat yayaŋ mti sekŋaŋ ku ketalasiwe beme egaŋ mama kanzizit ke ku tiwe. Ma an ŋenaŋ sekŋaŋ nâgât nâmti talasiwe beme egaŋ mama kanzizit ke ŋep tiwe. ");
INSERT INTO naf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Neŋ diindoma nâit, kan Angat Nemuŋaŋ neŋ kokotnnaŋgalen kanan keyet an zulaŋ tambuyet mka keŋan kwepgat meluk tawemambaluwaŋ kwep ŋen aikmepme ŋen peme tabe. ");
INSERT INTO naf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ma imbi zulaŋ saŋgo sâŋsâŋ tapmambaluwaŋ kwep ŋen teti meti ŋen peme tabe. ");
INSERT INTO naf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ma an zulaŋ muluwen mulup tapmambaluwaŋ kwep ŋen teti meti ŋen peme tabe.” ");
INSERT INTO naf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Zisasiyaŋ zet kegok zemdelaŋ zeme nembaŋane ekŋenaŋ egat yaŋkwesiwien, “Amobotnaŋ, zenigen ke msat deset sokbewe?” Ekŋenaŋ kegok yaŋkwesime Zisasiyaŋ diindoye, “Ke in nâip kan tep katnaŋ saŋgamaŋ penaŋ elikme age sambeyaŋ maondagip. Sekam kegogak kwitnaŋ kwitnaŋ ke ilinmagen sokbeme ekti nâmkawaŋ bewep.” ");
INSERT INTO naf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Âpme Zisasiyaŋ bemzenze zet kapi nembaŋaneyaŋ kan kataŋ dundume Kawawaŋaŋ nânâyelen mzikat indaye ma ekŋenaŋ nâmnukŋaŋ ku mimiyelen kapigok diindoye, ");
INSERT INTO naf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“An zet nânâ ŋen mka teman ŋengat matatan. Egaŋ Kawawaŋgalen zetnaŋ ku gawepuye ma amgat nâme ku moge. ");
INSERT INTO naf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Âpme mka temaŋ keyegak imbi kwambet ŋen ke matatan. Egaŋ an zet nânâ kemagen kan sambe mekoti zeye, ‘Kasan ŋenaŋ zelen nepgat geŋ namukulem mi!’ ");
INSERT INTO naf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Imbiyaŋ kegok zeme an keyaŋ kan teepmaŋ penaŋ ku mukulem mimiyelen nâye yaŋgut bamgat ikŋaŋgat kapigok zeye, ‘Ke penaŋ, neŋ Kawawaŋgalen zetnaŋ ku maŋgawepuyap ma amgat nâma ku mamozin. ");
INSERT INTO naf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yaŋgut imbi kwambet kapiyaŋ kan kataŋ mekoti nukŋaŋ nanayelen min keyepm mukulem mma kasaŋaŋ mtopewe. Mneti kegok ku mma mekoti tapmnanepeme sekaŋgaŋ ma egat zimosetnaŋ eegat wisat miyap!’” ");
INSERT INTO naf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Amobotnaŋ Zisasiyaŋ kegok zemti ewe kapigok tusum zeye, “An zet nânâ bekanaŋ keyaŋ imbi kwambet ke ŋep mukulem mpeye. ");
INSERT INTO naf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","In nâwien Kawawaŋgat tambu msa mandundum samti keŋinaŋ masuip ke egaŋ kasaŋine zemindomti in maindamukulem min. Ma egaŋ sakwep maindamukulem min. ");
INSERT INTO naf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Neŋ in diindoma nâit, Kawawaŋaŋ iknaŋgat pembenaŋaŋgat mti sakwep penaŋ indamukulem mamin. Am nâgât manâmkiŋpeip ma dundum naip ekŋenaŋ keŋin mkipmaŋ bemtapme kan kobawen ke koti indikbap.” ");
INSERT INTO naf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Âpme Zisasiyaŋ kegogak bemzenze zet kapi am ilinaŋgat nâme kwetetepmaŋ beme am sambe ekŋengat nâme bekanaŋ beme maindiktalalip ekŋen keyet diindoye, ");
INSERT INTO naf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ke kapigok, an zulaŋ sesewat mka temaŋ keŋan dundusât mowebun. Ŋen ek Palisi ma ŋen ek mânep takis titi an. ");
INSERT INTO naf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ke moweti Palisi an keyaŋ am notnaŋ tabien ekŋen keyaŋ eegalen nâmti kawaŋan sosok dendaŋ tati kapigok dunduye, ‘Kawawaŋ, neŋ gâgât wisikŋ zeyap. Am notnaŋaŋ kwitnaŋ kwitnaŋ guwak matimaip ma zet dâsuki manzeip ma set kileŋ mamaip. Neŋ am ekŋen keboŋ yek. Kawawaŋ neŋ gâgât wisikŋ zeyap neŋ takis mânep titi an kanda nemboŋ yek. ");
INSERT INTO naf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Neŋ sonda kataŋ kasup zut gâgâpm meu zemkulumpemti dundundu etaŋ mamiyap. Neŋ meu ma mânep milawat matiyap ekŋen keboŋgalen maŋge 10magengatnaŋ maŋge kwep ke gâgât maŋgeyap.’ ");
INSERT INTO naf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Egaŋ kegok mme mânep takis titi an egaŋ Palisi an ekmagen sokŋan ku tage. Beŋan tati zikatnaŋaŋ ŋep ku ekme mobogalen nâye ma egaŋ bekanaŋ mimiŋaŋgat nâmti sakambuk penaŋ nâmti ŋokŋaŋ kusum toweti Kawawaŋgat kapigok dunduye, ‘Kawawaŋ, neŋ yomtoŋ ke nâmti dundugayap keyepm kembeŋ nâmne!’” ");
INSERT INTO naf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Zisasiyaŋ bemzenze zet kegok zemdelaŋ zemti kapigok tusum zeye, “Neŋ diindoma nâit, takis mânep titi an keyaŋ sesewat mka temaŋ pemtoti mkaŋan mege. Ma Kawawaŋgat zikatnan an keyaŋ kwetetepmaŋ kwage. Âpme Palisi an keyaŋ kwetetepmaŋ ku kwage. Am ŋenaŋ ikŋaŋgat yomaŋgat nâme pepesut beme Kawawaŋgat sakambuk palen ku mandunduin ek ke Kawawaŋaŋ yomaŋ ku katipewe. Âpme naman am ŋenaŋ yomaŋgat nâme nukŋaŋ beme sakambuk palen mandunduin ek ke Kawawaŋaŋ yomaŋ makatipein.” ");
INSERT INTO naf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Âpme an imbi sambeyaŋ nembaŋin okakŋaŋ Zisasmagen indakopme egaŋ betnaŋaŋ sekŋin teŋguŋguyelen nâmti kobien. Kegok mme nembaŋane ekŋenaŋ ke ekti ekŋenaŋ Zisasmagen ku kokogalen zemkulumindewien. ");
INSERT INTO naf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nembaŋane ekŋenaŋ kegok mme Zisasiyaŋ nemba okak mamaŋ bipmaneyet kwizet kegok kumti nembaŋane ekŋengat diindoye, “In nemba mam biwine zemkulumindendepiŋ. In peme neŋmagen kolit. Enenogat am ekŋen nemba isikŋaŋ tototnaŋ keboŋ ekŋenaŋ Kawawaŋgalen zemâtâtâtgat katnanen mama ke tusuwep. ");
INSERT INTO naf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Neŋ penaŋ sukwep diindowi, in sekŋin ku mtoti ma yomin ku bamkumpemti nemunamba isikŋaŋ ekŋengat sepem ku mambep beme in Kawawaŋgalen zemâtâtâtgat katnanen mama ku tusuwep.” ");
INSERT INTO naf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Âpme an damuŋ ŋenaŋ Zisasmagen koti yaŋkwesiye, “An zikat indanda dolakŋaŋ, neŋ mulup dolakŋaŋ ŋen ziboŋ mti mama kanzizitgat zapat bewap?” ");
INSERT INTO naf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Egaŋ kegok zeme Zisasiyaŋ dunduye, “Geŋ nâgât, ‘An zikat indanda dolakŋaŋ zenik.’ Zet keyet yaŋaŋ ŋep nâmdelaŋ zenik? Kawawaŋ kwewaŋ dolakŋaŋ. ");
INSERT INTO naf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Geŋ Mosesiyelen zii zet kapigok tazin ke nânik. Ke kapigok kumpepeŋaŋ, ‘Geŋ awembiŋ kalalaŋ ku mbanik ma kasa kasa kumti am ku kumane gakiwe ma kambu ku mbanik ma zet dâsuki ku zewanik ma mambipdineyet kandaŋidan meti zet nânâ katnan mambanik.’” ");
INSERT INTO naf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Zisasiyaŋ kegok zeme an damuŋ keyaŋ zeye, “An zikat indanda, kwitnaŋ kwitnaŋ zenik ke nemba isikŋanenak baenen yaŋbemti gawepumkwabanaŋ ewe maŋgawepuyap.” ");
INSERT INTO naf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kegok zeme Zisasiyaŋ zet ke nâmti egat pigok dunduye, “Geŋ mulup ŋen ewe mimiyelen tagain. Geŋ gilik zem mkandan meti milawadi sambe tazin ke bemane kwitime mânep timtati am bekopsat indamtiŋgut neŋmagen kopmane meselup. Kegok mbanigen maneti dopmaŋ dolakŋaŋ kululuŋen gwaen tiwanik.” ");
INSERT INTO naf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kegok zeme an ek mânep milawatnaŋ temaŋ penaŋ tasayeyepm zet ke nâmti mânep milawatnaŋgat keŋaŋ penaŋ beye. ");
INSERT INTO naf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","An keyaŋ kegok mme Zisasiyaŋ ke ekti zeye, “Am mânep milawalin temaŋ ekŋenaŋ msalen kapi am nâmkiŋpepeŋinmak Kawawaŋgalen zemâtâtâtgat katnan maip ekŋenmak tususuyelen olalatnaŋmak mbep!” ");
INSERT INTO naf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Zisasiyaŋ zet kegok zemti ewe kapigok tusum zeye, “Bo temaŋaŋ buŋi aimboŋaŋ isikŋanen ŋep ku modak. Yek penaŋ. Sepem kegogak am mânep milawalinmagaŋ Kawawaŋgalen zemâtâtâtgat katnan maip ekŋenmak tususuyelen nâmnukŋaŋ penaŋ mamip.” ");
INSERT INTO naf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kegok zeme am tabien ekŋenaŋ zet ke nâmti egat yaŋkwesiwien, “Kegok beme kwiyaŋ mama kanzizit ŋep tiwe?” ");
INSERT INTO naf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ekŋenaŋ kegok zeme Zisasiyaŋ zeye, “Mânep milawalaŋ set bekekme am Kawawaŋgalen zemâtâtâtgat katnan maip ke ku tusuwep yaŋgut Kawawaŋaŋ am ekŋen keyet keŋin mim eleŋ beleŋ beme mama kanzizit ke ŋep tiwep.” ");
INSERT INTO naf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kegok zeme Pitayaŋ pigok zeye, “Wae, Amobotnaŋ, nânik, nin kwitnaŋ kwitnaŋ sambe pemann tapme geŋ gapmâbenn keyepm maneti keyet dopmaŋ Kawawaŋaŋ kwileki penaŋ ndawe?” ");
INSERT INTO naf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kegok yaŋkwesime Zisasiyaŋ kapigok diindoye, “Neŋ penaŋ sukwep kapigok zema nâit, am ŋenaŋ nâgât ma zet zapat dolakŋaŋgapmti mkaŋaŋ ma imbi nembaŋane ma dapmeniŋane ma ipmamnotnane ma mambipmane mee pi katipemâbe beme ");
INSERT INTO naf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Kawawaŋaŋ egat dopmaŋ omba penaŋ msalen pien sawe ma maneti bam kululuŋen mama kanzizit ke sawe.” ");
INSERT INTO naf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Âpme Zisas ek nembaŋane 12 zem indamandamti kayakŋaset toweti kapigok diindoye, “An ekŋen nâip, nin alak Zelusalem mka temanen tapmotnup. Golaŋ zenze an ekŋenaŋ tipman baen Angat Nemuŋaŋ egat zewienen ke penaŋ mkawaŋbesâpm. ");
INSERT INTO naf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Âpme Zuda am ekŋengalen amobotnaŋ Zelusalem mka temanen mambien ekŋenaŋ Loma gapman ekŋengalen amobotnaŋine Zelusalem mambien ekŋengat belinan mopma kasa kukuŋineyaŋ sokŋan tati pep zet mnamti zawagaŋ waseknewep. ");
INSERT INTO naf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kegok mti sindiwaŋ nawitikti nome gakiwap. Yaŋgut kasup tuk delaŋ peme gakikiengatnaŋ wati mamaen mobap.” ");
INSERT INTO naf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Egaŋ kegok zeme nembaŋane ekŋenaŋ zet keyet yaŋaŋ nâmkandabien. Zisasiyaŋ zet keyet yaŋaŋ ku mkawaŋ bemindemti zet keyet ekŋenmagen enzilim tage keyepm ekŋenaŋ yaŋaŋ ku nâmâtâbien. ");
INSERT INTO naf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Âpme Zisas ek metneti Zeliko mka teman sokŋanik mege. Ke mepme set ganzenaŋ an zikatnaŋ beŋaŋ ŋen totati mânep milawatgat mawekumtan. ");
INSERT INTO naf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Âpme an keyaŋ am maŋge temaŋ ekŋengat sepalak kwisakŋin ma zezet bambaŋin nâmti, “Wae, zigogat kwisak temaŋ amnaŋ tapmmukup,” am indayaŋkwesime ");
INSERT INTO naf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","am ekŋenaŋ egat zewien, “Zisas Nasalet mka temanengatnaŋ kozin.” ");
INSERT INTO naf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kegok zeme egaŋ nâmti kwizet temaŋ kumti zeye, “Zisas, geŋ Dewitgalen alikŋaŋaŋ, nâgât kembeŋ mi!” ");
INSERT INTO naf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kegok mme an ŋeŋaŋ bemti mobien ekŋenaŋ kwizet peme tatagalen zemkulumpewien. Yaŋgut egaŋ zelin ku nâmti ewe tusumti kwizet omba kumti zeye, “Geŋ Dewitgat alikŋaŋ, nâgât kembeŋ mi!” ");
INSERT INTO naf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kegok kume Zisasiyaŋ nâmti ewe ku meti selen keyegak tati zeye, “In an ke neŋmagen tetim kolit.” Zeme an zikatnaŋ beŋaŋ Zisasmagen tetim kopme yaŋkwesimti zeye, ");
INSERT INTO naf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wae, neŋ geŋmagen kwileki penaŋ mgaŋgayelen nâmti tazenik?” Kegok zeme an zikatnaŋ beŋaŋaŋ zeye, “Amobotnaŋ, neŋ zikatn ewe eegalen nâyap.” ");
INSERT INTO naf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Egaŋ kegok zeme Zisasiyaŋ kapigok dunduye, “Zikadi belak zem ekbak! Nâmkiŋpependaŋgapm zikadaŋ dolakŋaŋ bein.” ");
INSERT INTO naf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Zisasiyaŋ kegok zeme an keyaŋ zikatnaŋ keyegak ege. Kegok mme Zisas mâpmeti Kawawaŋ sesewatsaye. Ma am sambe menok ke ekbienaŋ ekŋenaŋ kegogak Kawawaŋ sesewatpewien. ");
INSERT INTO naf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Âpme Zisas ma nembaŋane ma am sambe Zeliko mka teman kot pataŋ zemti Zeliko mka tuŋgupmaset moweti mebien. ");
INSERT INTO naf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Âpme mka keyegak mânep takis titiyelen amobotnaŋ ŋen milombi lombiŋaŋ sambe ke matatan kwitnaŋ Zakias. ");
INSERT INTO naf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ya Zisasiyaŋ selen tapmepme egaŋ, “Zisas an kwi penaŋ?” nâmti eegalen mege. Egaŋ kegok mme am sambeyaŋ bembuluŋme ek an danaŋgapm Zisas ku ekti, ");
INSERT INTO naf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","“Set kapieset kosem,” ke nâmti kukŋaŋgat meti tep kwitnaŋ sikamo keyet dukŋan Zisas eksât nâmti mowege. ");
INSERT INTO naf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Âpme Zisasiyaŋ tep keyet yaŋaŋ sokŋan kokogalen koti ekme mopme Zakias ekti zeye, “Zakias, geŋ sakwep kwatot; neŋ alak gâlen mkaen geŋmak metaselup.” ");
INSERT INTO naf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Egaŋ kegok zeme Zakiasiyaŋ tep dukŋangatnaŋ sakwep kwatoti zemoloŋen mpemti keŋan oloŋen penaŋ beme Zisas aikti egalen mkaen mebun. ");
INSERT INTO naf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Zakiasiyaŋ kegok mme am sambe ke ekbienaŋ zet yupmet yupkot mti zewien, “Zisas ek ayomtoŋ egalen amkup mezin!” zewien. ");
INSERT INTO naf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Egelaŋ ke meti mka keŋan moti totati tagoun. Kegok mme Zakiasiyaŋ dendaŋ watati Amobotnaŋgat kapigok dunduye, “Amobotnaŋ, geŋ nâmbak! Neŋ milombi lombin butnaŋ kalaŋti am bekopsat indamti am notnaŋmagen tetimae mti mânewin tiwan ke sek zulak zulak dopmaŋ tusum indasap.” ");
INSERT INTO naf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Egaŋ kegok zeme Zisasiyaŋ dunduye, “Alak mka kapiyet toŋaŋ geŋmak imbindi nembandine in Kawawaŋgalen Zet Zapat Dolakŋaŋ nâmti yomin bamkumpemti Kawawaŋgalen nemunamba kwalip. ");
INSERT INTO naf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ma Angat Nemuŋaŋ neŋ am Zakias ek nemboŋ Kawawaŋgat ku manâmkiŋpemti yom mamip ekŋen indamukulem msâgât ma yomin katipepeyelen keyet toban.” ");
INSERT INTO naf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Âpme am maŋge temaŋaŋ Zisasiyelen zet nâmdelaŋ zeme egaŋ bemzenze zet ŋen zesât nâye. Kan keyet ekŋen Zelusalem mkaen sokŋan koti ekŋenaŋ otnâwienen Kawawaŋgalen zemâtâtâtgat katnan mama alak sakwep sosok sokbesâpm ke otnâme Zisasiyaŋ keŋinan indikmâtâti ");
INSERT INTO naf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","bemzenze zet ŋen kapigok zeye, “An kwizapatnaŋmak ŋen maŋge yaŋ egaŋ msat beŋaŋen mepme keyelen amobotnaŋaŋ msatnaŋgalen amobotnaŋ kwakwagalen ombempeme gilik zemti msatnaŋ yaŋaŋ kokogalen weyaŋ weyaŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kan egaŋ mebegalen tati mulup anŋane 10 ekŋengat zeme kotondakme mânep kanziŋaŋ golmak ke kwep kwep indamti kapigok diindoye, ‘An ekŋen nâit, mânep kapiyaŋ mulup notnaŋ same mânep tâgâŋaŋ butnaŋ mandamindame neŋ koti ekbap.’ ");
INSERT INTO naf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kegok zemindemti mepme am mkaŋaŋ ŋande kwep ekŋenaŋ sekaŋgaŋ nâmpewien keyepm an zet zenze notnaŋ indeme ekmagen meti kapigok zewien, ‘Nin geŋ amobotnaŋ tatagat ku ndembeme wisat mgenup.’ ");
INSERT INTO naf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ekŋenaŋ kegok zewien yaŋgut amobotnaŋ ke msat keyelen amobotnaŋ amnaŋ ombempeme gilik zem msatnaŋ yaŋan koge. Kotati mulup anene 10 ekŋen keyet zeme kopme mânep indaye keyet yaŋaŋ nânâyelen indamandaye. ");
INSERT INTO naf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kegok mti mulup an ŋen kukŋaŋgat koti amobotnaŋgat dunduye, ‘Amobotnaŋ, geŋ mânep golmak kwep nawanan ya ke mulupmaŋ sama mânep tâgâŋaŋ 10 mandawan.’ ");
INSERT INTO naf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Egaŋ kegok zeme amobotnaŋaŋaŋ dunduye, ‘Geŋ mulup nemba dolakŋaŋ penaŋ keyepm geŋ mulup dolakŋaŋ penaŋ mbanan! Geŋ kwitnaŋ kwitnaŋ isikŋaŋ weyaŋ dolakŋaŋ ekdamuŋ mbanan keyepm neŋ mka ŋande temaŋ 10 geŋ gema indikdamuŋ mbanik.’ ");
INSERT INTO naf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sakam kegogak mulup an ŋenaŋ amobotnaŋmagen koti zeye, ‘Amobotnaŋ, geŋ mânep golmak kwep nawanan ya ke mulupmaŋ sama tâgâŋaŋ 5 aikban.’ ");
INSERT INTO naf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kegok zeme amobotnaŋaŋaŋ dunduye, ‘Geŋ mka ŋande 5 gema indikdamuŋ mbanik.’ ");
INSERT INTO naf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kegok sokbeme mulup an ŋenaŋ koti zeye, ‘Amobotnaŋ, gâlen mânepdi golmak kwep ke pine. Neŋ saŋgum paŋaŋaŋ kwaikti belak mambema tazin. ");
INSERT INTO naf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Geŋ an keŋdi kaliŋaŋ keyepm neŋ gâgât kiŋgati mânep golmak belak mambema tazin.’ Kegok zemti egaŋ ewe tusum zeye, ‘Geŋ mânep amnaŋ bembeŋaŋ ke geŋ matinik ma suŋem saŋgo amnaŋ tim onzenzeŋaŋ ke geŋ kegogak matinik.’ ");
INSERT INTO naf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Egaŋ kegok zeme amobotnaŋaŋaŋ dunduye, ‘Geŋ mulup an bekanaŋ penaŋ. Gitaŋgat zedi tazenik keyet neŋ zemgosowap! Geŋ nâgât yaŋŋ nânik. Neŋ an keŋ kaliŋaŋ ma am notnaŋaŋ milawat bembeŋaŋ matiyap ma suŋem saŋgo timonzenzeŋaŋ ke matiniyap. ");
INSERT INTO naf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ya kegok benak beme kwilekiyet mti nâlen mânepm mânep mkaŋan ku bewanan? Kegok mbanan ze neŋ mânep tâgâŋaŋ notnaŋ mandam nanak.’ ");
INSERT INTO naf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Amobotnaŋaŋ kegok zemti am notnaŋ ke tabiengat zeye, ‘In mânep kwep golaŋ mimiŋaŋ ekmagen tasain ke mti an mânep 10 tasain an ke sait.’ ");
INSERT INTO naf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Egaŋ kegok zeme ekŋenaŋ zewien, ‘Amobotnaŋ, ek mânep golmak 10 tasain. Kulekiyepmti mânep kwep kapi eksasenup?’ ");
INSERT INTO naf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ekŋenaŋ kegok zeme amobotnaŋaŋ zeye, ‘Neŋ diindoma nâit an ŋen kwitnaŋ kwitnaŋ notnaŋ tasame mulupmaŋ masain beme kwitnaŋ kwitnaŋ notnaŋ ewe tusumti same ekmagen polak polak wemsawe. Âk an ŋen kwitnaŋ kwitnaŋ ŋen isikŋaŋ tasawe beme ewe kwitnaŋ kwitnaŋ isikŋaŋ penaŋ bugan tasain ke kogak menzempewep.’ ");
INSERT INTO naf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kegok zemti ewe kapigok tusum zeye, ‘Neŋ amobotnaŋ msat ŋengalen takwapma am nâgât zekuku mti nâgât ku nâmtikŋaŋ mbien ekŋen ke indatim kot nâgât zikatnnaŋ indome gakit!’” ");
INSERT INTO naf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Âpme Zisasiyaŋ bemzenze zet kegok zemdelaŋ zemti egaŋ ŋeŋaŋ mepme nembaŋane ma am sambe ekŋenaŋ Zelusalem mowewegalen mâti mowebien. ");
INSERT INTO naf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Moweti Betpage ma Betani mka ŋande teman mobogalen moti kalaŋ ŋen kwitnaŋ Olip Kalaŋ ke motati nembaŋane zut kukŋaŋgat ideme mebegalen ");
INSERT INTO naf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","buŋam zet kapigok zemideye, “An zut, Betani mka ŋanden sokŋan kanda meti keŋan moweseluwen doŋki nembaŋaŋ tegen opempepeŋaŋ amnaŋ ku mim mamaŋaŋ ke ekti kaluti neŋmagen pien tetim koselup. ");
INSERT INTO naf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","It kegok mmalut toŋaŋaŋ kapigok idayaŋkwesisem, ‘It kwilekiyet doŋki tekŋaŋ takwalelup?’ zeme it kapigok dunduselup, ‘Amobotnaŋŋnaŋ kapiyaŋ mulupmaŋ sasayelen zemndep,’ kegok zeselup.” ");
INSERT INTO naf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kegok zemideme egelaŋ meti mkaen pataŋ zemalut kwitnaŋ kwitnaŋ Zisasiyaŋ kabem idaye keyet katnaŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kan keyet ke metati doŋki ŋen ekti tegaŋ takwalepmalut doŋki keyet toŋaŋaŋ koti idayaŋkwesiye, “It kwilekiyet doŋki tekŋaŋ takwalelup, e?” ");
INSERT INTO naf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Egaŋ kegok idayaŋkwesime egelaŋ zewun, “An nodi, Amobotnaŋ kapiyaŋ mulupmaŋ sasem.” Egelaŋ zet dopmaŋ kegok zemti ");
INSERT INTO naf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","doŋki nembaŋaŋ piwan Zisasmagen teti meti tâgâ melakandu teepmaŋ gulumti doŋki palaŋan yaŋgempemti Zisas mukulem mti doŋki palaŋan ambepeme moge. ");
INSERT INTO naf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Âpme kan Zisasiyaŋ doŋki dukŋan motati megeen am sambe penaŋaŋ tâgâ melakandu teepmaŋ gulumti doŋkiyaŋ set megeen yaŋgempeme mege. ");
INSERT INTO naf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kegok sokbeme Zisas ma am ekŋenaŋ Zelusalem mka temaŋmagen sokŋan koti set isikŋaŋ Olip Muluwen towezinen ke pataŋ zewien. Ke koti am sambe Zisas mâti kobien ekŋen keyaŋ yaŋbemti Zisasiyaŋ menok temaŋ mzikat indaye keyet Kawawaŋgat wisikŋ zemti kwizet palen zemsesewati kapigok kuwien, ");
INSERT INTO naf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“‘Kawawaŋaŋ Nemuŋaŋ Amobotnaŋ ombempeme kozin keyet nin oloŋen penaŋ mnup;’ Ekŋen sambe kululuŋen talip ekŋenaŋ sesewatpeit ma nin Kawawaŋ kululuŋen gwaen penaŋ tazin egat kwitnaŋ mmot pene!” ");
INSERT INTO naf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kegok sokbeme Palisi an notnaŋ am ekŋengat tuŋguwinan ke tati Zisas ekti kapigok yaŋkwesiwien, “An zikat indanda, geŋ maŋgendine ekŋen kapi zemkulumindemane kwizetpiŋ buzak talit!” ");
INSERT INTO naf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ekŋenaŋ kegok zeme Zisasiyaŋ diindoye, “Notnne, neŋ zema nâit, ekŋenaŋ kwizet kukupiŋ mseip beme nanzaŋ ekŋenaŋ Kawawaŋgat kwitnaŋ zemsesewatseip.” ");
INSERT INTO naf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ke meti Zelusalem mka temaŋmagen sokŋan kwati Zisasiyaŋ Zelusalem ekti egaŋ keŋaŋ bekanaŋ beme sumti ");
INSERT INTO naf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kapigok zeye, “Zelusalem am, neŋ nâyawen in kwileki mti keŋ sewakŋaŋ aiikgalen ke in ku nâip alak keŋ sewakŋaŋ aiikgalen kan delaŋ zein. ");
INSERT INTO naf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Âpme bamgat kasaŋineyaŋ inmagen kot nembet nembet indabembuluŋti sepaloŋ teepmaŋaŋ ingalen kimbalen tim onzemti keyet dukŋaset moti nembet nembet kwatobep. ");
INSERT INTO naf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ke kwatoti mka temaŋ kapi kasaŋineyaŋ walebep ma am keŋan matalip ekŋenaŋ kegogak walebep. Ma mka nanzaŋaŋ walalatnaŋ ma kimbat ma sesewat mka temaŋ nanzaŋaŋ walalatnaŋ ekŋen keyaŋ mundumin katipemti lala bubuk totemebep enenogat alak Kawawaŋaŋ An in yomengatnaŋ gilik zemindatitiyet zempeme kozin ke in ku mkipmaŋ beip!” ");
INSERT INTO naf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Âpme Zisasiyaŋ kegok zemdelaŋ zemti Zelusalem mka temaŋ keŋan ke moti sesewat mka temaŋ keŋan moweti ekme amnaŋ keŋan ke aem kwaem tapmme yaŋbemti indamâti zeye, ");
INSERT INTO naf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Kawawaŋgalen Zet Itnaŋanen pigok zeme meluwaŋ mimiŋaŋ, ‘Nâlen sesewat mkan ke amnaŋ dundundu mulup ke mbep.’ Yaŋgut in naman mme, ‘An kambu titiyelen enzilili mka kwazin!’” ");
INSERT INTO naf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kegok mdelaŋ zemti msasa kataŋ sesewat mka temaŋ keŋan am zezapat dolakŋaŋ mzikat indaye. Kegok tapmme sâpe sâpe bumbu an ekŋengalen an ŋeŋaŋ bembe ekŋen ma an zii zet zikat indanda ekŋen ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ Zisas kume gakikiyelen setgat timabien. ");
INSERT INTO naf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ekŋenaŋ kegok mimiyet nâwien keyaŋgulak am sambe ekŋenaŋ egalen mzikat indandaŋaŋgat nâmtikŋaŋ penaŋ mti ekŋenaŋ egalen zet sambe ke nânâyelen etaŋ nâwien keyepm kegok ku mbien. ");
INSERT INTO naf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Âpme kasup ŋengat Zisasiyaŋ sesewat mka temaŋ keŋan tati am Kawawaŋgalen Zet Zapat Dolakŋaŋ tazikat indamaŋge. Egaŋ kegok tapmme sâpe sâpe bumbu an ekŋengalen ŋeŋaŋ bembe an ma zii zet zikat indanda an ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ ekmagen koti ");
INSERT INTO naf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kapigok yaŋkwesiwien, “Wae, geŋ winde deyetnaŋ ma kwiyaŋ nâmgame amnaŋ sesewat mka keŋan bem kwiti kwiti tapmme indamâbanan?” ");
INSERT INTO naf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ekŋenaŋ kegok yaŋkwesime Zisasiyaŋ pigok zeye, “An ekŋen, neŋ yaŋkwesisi kwep penaŋ indayaŋkwesiwi. Ele, notnne, zeme nâmbi, ");
INSERT INTO naf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Zân tu zulutindende an ek am tu zulutindendeyelen kwiyaŋ nâmpeye? Kawawaŋaŋ nâmpeye ma amnaŋ nâmpewien?” ");
INSERT INTO naf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Egaŋ kegok zeme ekŋenaŋ ilinak zenâ zenâ mti zewien, “Nin egat zigok zesenup? ‘Kawawaŋmagengatnaŋ,’ zesenup beme egaŋ zet dopmaŋ pigok zesem, ‘Yaŋ kok ke kwilekiyet mti Zângalen tu zululut mulupmaŋ ke ku nâmkiŋpewien?’ ");
INSERT INTO naf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yaŋgut nin, ‘Ammagen,’ zesenup beme am sambeyaŋ nanzaŋaŋ ndome gakisenup. Enenogat ekŋenaŋ nâiwen Zân ek golaŋ zenze an dolakŋaŋ kegok nâip.” ");
INSERT INTO naf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kegok zemti ekŋenaŋ Zisasiyet dunduwien, “Wae, deyetnaŋ ke nin ku nânup.” ");
INSERT INTO naf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kegok zeme Zisasiyaŋ diindoye, “Ele, neŋ kegogak winde deyetnaŋ timti kwitnaŋ kwitnaŋ tapmiyap ke ku zema nâseip.” ");
INSERT INTO naf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Âpme Zisasiyaŋ zet kapigok tusum zemti bemzenze zet ŋen am ekŋenmagen zemkawaŋ bemindeye, “An ŋenaŋ wain alikŋaŋ mulupmanen ondemti an notnaŋ ekŋenaŋ ekdamuŋ mti ikŋaŋgat notnaŋ sasayelen zemindemti msat pemŋen meti kwesiŋ maŋge. ");
INSERT INTO naf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ke mepmame kan wain katnaŋaŋ elikti ŋep bem weme an mulup toŋaŋ mulup an ŋen zempeme wain katnaŋ egat weŋaŋnok muluwen ke titiyelen mege. Kegok zempeme mege yaŋgut an ekŋen mulup damuŋ mamtemien ekŋen keyaŋ mulup an ke omba penaŋ kumti kwitnaŋ ŋen sasapiŋ mme belak mege. ");
INSERT INTO naf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kegok sokbeme an mulup toŋaŋ ewe mulup an ŋen zempeme muluwen ke mege yaŋgut mulup damuŋ mamtemien ekŋenaŋ kumsage penaŋ mti zet sakambuk igak igak msamti belak kwitnaŋ ŋen sasapiŋ zempeme mege. ");
INSERT INTO naf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kegok sokbeme mulup toŋaŋaŋ mulup nemba ŋen ewe zempeme keyegak mege. Yaŋgut mulup damuŋ ekŋenaŋ kumsage penaŋ mti zempeme kimbat zupman toge. ");
INSERT INTO naf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","An kemagen kegok sokbeme mulup toŋaŋ keyaŋ ikŋaŋgat zeye, ‘Neŋ zigok penaŋ mbawe? Oo, alakŋati nâyap. Neŋ nanaŋgat nemun penaŋ gogot mamiap ke zempema muluwen ke mebe. Kegok mbawen ekŋenaŋ eksemti wain katnaŋ ŋep same kobe!’ ");
INSERT INTO naf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Egaŋ ikŋaŋgat kegok zemti ikŋaŋgat nemuŋaŋ ke peme mege. Ke meti muluwen kokogalen sokŋan kopme mulup damuŋ mamtemien ekŋen mulup toŋaŋ ikŋaŋgat nemuŋaŋ ke ekti ilinak zenâ zenâ mti zewien, ‘Ikŋaŋgat nemuŋaŋ kwitnaŋ kwitnaŋ sambe kapi toŋaŋ bewe keyepm nin kuman gakime kwitnaŋ kwitnaŋ sambe kapi nin toŋaŋ bewanup.’ Kegok zewien. ");
INSERT INTO naf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ekŋenaŋ kegok zenâ zenâ tapmme mulup toŋaŋgat nemuŋaŋ keyaŋ paselengatnaŋ keŋan moti ekŋenmagen sokŋan mepme ekŋenaŋ ambeti paselen watoti kume gakiye.” Zisasiyaŋ kegok zemti am indayaŋkwesiye, “In zigok nâip, wain mulup toŋaŋaŋ an keŋ katik ekŋen kemagen zigok mimindewe?” ");
INSERT INTO naf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Egaŋ kegok zemti ewe kapigok tusum zeye, “Mulup toŋaŋ keyaŋ kasa kuku an ekŋenmak koti an keŋ katik ekŋen indome gakime wain mulup ke an notnaŋ belakŋaŋ indame ekŋenaŋ ekdamuŋ mti wain katnaŋ notnaŋ ikŋaŋgat sasayet nâmti indaye.” Egaŋ kegok zeme am tabien ekŋenaŋ ke nâmti zewien, “Yaŋgut an keŋ katik ekŋen keyaŋ kok ke ŋep ku mbiek!” ");
INSERT INTO naf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ekŋenaŋ kegok zeme Zisasiyaŋ ekŋen indikti kapigok diindoye, “Kawawaŋgalen Zet Itnaŋanen zet papiaen kapigok kumpepeŋaŋ, ‘Mka walalat an ekŋenaŋ tepum ŋen ekme bekanaŋ beme wisat mti peme weŋge. Yaŋ tepum kewan tepum miŋaŋ beye.’ Zet kapiyet yaŋaŋ zigok?” ");
INSERT INTO naf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Zemti ewe tusum zeye, “‘Tepum ke amnaŋ, “Sambuŋaŋ,” zewien yaŋgut tepum ke kaliŋaŋ. Ya amnaŋ tepum keyet dukŋan tokutuin beme tepum tapeŋ tapme am ke gakiwep. Ya tepum keyaŋ am keyet palen tokutun beme am keyaŋ kegogak gakiwe.’ Keyepm neŋ tepum kenok beyap.” ");
INSERT INTO naf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Egaŋ kegok zeme zii zet zikat indanda ma sâpe sâpe bumbuyelen an ŋeŋaŋ bembe ekŋenaŋ Zisas keyegak atamti mka katikŋan pepeyelen nâwien enenogat bemzenze zet keyaŋ ekŋen indaampuye. Ekŋenaŋ kegok mimiyelen nâwien keyaŋgut am maŋge temaŋ ekŋenaŋ nanzaŋaŋ ndoseip ke nâmti kiŋgabien. ");
INSERT INTO naf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kegok nâmti ekŋenaŋ Zisas weyaŋ maeknâmtemien. Ekŋenaŋ kegok tapmti an dâsukitoŋ notnaŋ mânewaŋ indakwitimti zemindeme an pembenaŋnok Zisasmagen zikat kambu eegalen ma egaŋ zet zemyuŋgume zii zet zikat indanda ma sâpe sâpe bumbu an ŋeŋaŋ bembe ekŋenmagen gilik zem koti zemkume ekŋenaŋ Loma gapmangalen amobotnaŋmagen zemkumti winde tasain ma zemdelaŋ zenze ekmak tazingapm zemindeme mebien. Yaŋgut an zikat kambu eek ekŋen ke an bekanaŋ. ");
INSERT INTO naf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","An zikat kambu eek ekŋen keyaŋ meti Zisasiyet yaŋkwesiwien, “An zikat indanda, nin nânuwen gâlen zedi ma mzikat indandandi esemteŋ penaŋ mamkawaŋ benik. Nin nânuwen am kwilinmak ma am kwilinpiŋ ekŋenmagen Kawawaŋgalen Zet Zapat Dolakŋaŋ sakam kwep mamkawaŋ bemindenik. Yaŋgut geŋ zet penaŋ Kawawaŋmagengatnaŋ amnaŋ mama mimi zigok tatagalen ke mammkawaŋ bem indenik. ");
INSERT INTO naf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ekŋenaŋ kegok zemti ewe tusum zewien, ‘Ele zemane nâne. Ningalen zii zelaŋ zeinen nin mânep takis Loma gapman sasayelen ma yek?’” ");
INSERT INTO naf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ekŋenaŋ kegok zeme Zisasiyaŋ ekŋengalen tetimaeŋin ke ekmâtâti kapigok diindoye, ");
INSERT INTO naf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ele, notnne, in mânep kanziŋaŋ ŋen taindain beme name ekbi. Mânep palen an zimosetnaŋ ma kwitnaŋ kwiyelen kumpepeŋaŋ?” Kegok indayaŋkwesime ekŋenaŋ zewien, “Loma gapmangalen amobotnaŋ kwitnaŋ Sisa egat weŋaŋmak kwitnaŋaŋ tazin.” ");
INSERT INTO naf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ekŋenaŋ kegok zeme Zisasiyaŋ zeye, “Ele, kwitnaŋ kwitnaŋ amobotnaŋ Sisayet weŋaŋ tatatnaŋ beme ek sawep ma am in Kawawaŋ ikŋaŋgalen bet muluwaŋ keyepmti in ikŋaŋgat zapat mait.” ");
INSERT INTO naf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kegok diindoye keyepm kan egaŋ ammak tapme ekŋenaŋ ekmagen tetimae mti zemkukuyelen ŋen ku mbien enenogat egaŋ ekŋengalen yaŋkwesisi dopmaŋ zeye keyet nâmtemtem mti zetpiŋ buzak tabien. ");
INSERT INTO naf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Âpme Sadusi an notnaŋ Zisasmagen kobien. An ekŋen keyaŋ maotnâmtemienen am gakikiŋaŋaŋ ku belek zemwabep. Kogogapmti ekŋenaŋ koti Zisasiyaŋ yaŋkwesiwien, ");
INSERT INTO naf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“An zikat indanda, Mosesiyaŋ meluwaŋ papiaen kapigok kuye, ‘An ŋenaŋ imbiŋaŋ wadak ya maneti an keyaŋ nembaŋapiŋ gakinak beme notnaŋ isikŋaŋaŋ imbi kwambet ke wati notnaŋ temaŋgalen kwitnaŋ mwawagalen nemba ambedak.’” ");
INSERT INTO naf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kegok zemti ewe tusum zewien, “Kan ŋen an ŋengat nemulatnene 7 mamkwabien. Ya yuŋinaŋ imbi wati nemunambaŋapiŋ belak gakiye. ");
INSERT INTO naf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yuŋinaŋ gakime muŋaŋaŋ imbi kwambet ke wage. ");
INSERT INTO naf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ya muŋinmagen sakam kegogak sokbeme an gwalaŋ imbi kwambet ke wage. Sakam kegogak ekŋen sambemagen ilindiŋ sokbeme nemunambaŋinpiŋ gakiwien. ");
INSERT INTO naf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ekŋenmagen kegok sokbeme bam penaŋ imbi keyaŋ gakiye. ");
INSERT INTO naf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kegok sokbeme an 7 ekŋenaŋ imbi ke mkipmaŋ bewien keyepm kan am gakikiŋaŋ belek zem mamayen wabep kan keyet imbi ke an kwiyet imbiŋaŋ penaŋ bewe?” ");
INSERT INTO naf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ekŋenaŋ kegok zeme Zisasiyaŋ diindoye, “An ma imbi alak takwalip kapiyaŋ awembiŋ mambeip ");
INSERT INTO naf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","yaŋgut an ma imbi ekŋenaŋ kululuŋgat zapat matalip ekŋenaŋ ŋep gakikiengatnaŋ belek zem wati kululuŋen mobep. An imbi ekŋen keyaŋ kululuŋen gwaen awembiŋ ku mambep. ");
INSERT INTO naf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ma ekŋenaŋ enselnok mamti ewe ku gakiwep. Ekŋen Kawawaŋgalen nemba matalip enenogat ekŋenaŋ gakikiengatnaŋ belek zem wabien. ");
INSERT INTO naf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Âpme ingalen yaŋkwesisi penaŋ am gakikiŋaŋgatnan wawat keyet yaŋaŋ nâsât nâmti mkoloen yaŋaŋ kapigok. Mosesiyaŋ am gakikiŋaŋaŋ mambelek zemwati mama kanzizit matip keyelen yaŋaŋ msokbembeyelen Kawawaŋaŋ didik kunduman tep tazime keyet Moses sokbemsame Mosesiyaŋ Kawawaŋgat kapigok zeyeyet meluwaŋ mge ke maiŋti ku manâmâtâlip? Mosesiyaŋ Kawawaŋgat kapigok zeye, ‘Geŋ alak kapiyet Abalaamgalen Kawawaŋ ma Aisakgalen Kawawaŋ ma Zekopgalen Kawawaŋ tadnik.’ ");
INSERT INTO naf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wae, ek am gakikiŋaŋgalen Kawawaŋ yek. Ek am ikŋaŋ mama kanzizitgat zapat ombemindeye ekŋengalen Kawawaŋ maŋgeyaŋ tapmain. Am gakiwien ekŋen ewe alik mamaip enenogat Kawawaŋaŋ nâmindeinen ekŋen alik ikŋaŋ nemboŋ tapmaip.” ");
INSERT INTO naf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Egaŋ kegok zeme zii zet zikat indanda an ekŋenaŋ zewien, “An zikat indanda, geŋ yaŋkwesisiyet dopmaŋ dolakŋaŋ penaŋ zenik!” ");
INSERT INTO naf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kegok ke sokbeme Zisasiyet yaŋkwesisi ŋen yaŋkwesisiyet kiŋgagatnaŋmak mbien. ");
INSERT INTO naf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Âpme Zisasiyaŋ am ekŋengat diindoye, “Am inmagengatnaŋ ŋoktik dâsuki ŋen tageen kapigok, Kilais ek Dewitgat iŋsokŋaŋaŋ etaŋ manzeip. ");
INSERT INTO naf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dewilaŋ Kilaisiyet zet kapi kulekiyet mti papia kwitnaŋ Sam keyet keŋan kapigok kuye, ‘Amobotnaŋ Kawawaŋaŋ nâlen Amobotnaŋgat pigok zeye: geŋ betn penaset kwatotati tapmopmane ");
INSERT INTO naf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kasandine mtoindewap.’ ");
INSERT INTO naf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewilaŋ Kilaisiyet ‘Amobotnaŋŋ’ zeye ke zigoset mti in ‘Dewitgat alikŋaŋ etaŋ tadak?’ Ke penaŋ Kilais neŋ sokbewan yaŋgut neŋ Kawawaŋgat Nemuŋaŋ penaŋ kogogapm Dewilaŋ zet zapat itnaŋaŋen kuyeen ke nâgât ‘Amobotnaŋŋ,’ zeye eneyet neŋ Kawawaŋaŋ zemnemetot amgat yomgat dopmaŋ gakikiyet toban.” ");
INSERT INTO naf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Âpme am sambeyaŋ wak bemti Zisasiyelen zet tatnâme egaŋ nembaŋaneyet kapigok diindoye, ");
INSERT INTO naf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“In zii zet zikat indanda an ekŋengalen ŋoktik mgasik ke ku mâti mbep. Ekŋenaŋ melakandu teepmaŋ gwaen biminaŋgatnan baen selinan tot lapit mepme mamti ilinaŋgat nâme mobotnaŋ beme selen ma tambaŋgumen mame amnaŋ sekŋin moindendeyet etaŋ manâip. Ekŋenaŋ sesewat mkaen amobotnaŋgalen mundumen ŋeŋaŋ gwaenen etaŋ mametalip. Ma ondedak temanen ekŋenaŋ meu ma soŋgom temaŋ indame niniyelen etaŋ manâip. ");
INSERT INTO naf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ma ekŋenaŋ imbi kwambetgalen mânep milawat ma mkaŋin mee pi menzem timti indamâpme kileŋ mepme dundundu teepmaŋaŋ myuŋguŋguŋin beke mamimatanepeme amnaŋ ŋep ku eegalen mambein keyepm kan delaŋ zenze kanen Kawawaŋaŋ zem indomti tosaŋin bekanaŋ penaŋ mmoti indawe!” ");
INSERT INTO naf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Âpme Zisasiyaŋ sesewat mka temaŋ keŋan mânep pelep mambeip keyet sokŋanik tati ekme am mânep milawalinmak notnaŋ ekŋenaŋ tewalaŋ mânewin temaŋ pelewen tapeme topwemaŋge. ");
INSERT INTO naf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma egaŋ kegogak ekme imbi kwambet bekopsat ŋenaŋ koti mânep ŋamaŋ isisikŋaŋ zut piwan peme pelewen towege. ");
INSERT INTO naf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kegok mme Zisasiyaŋ ekti nembaŋaneyet zeme kopme pigok diindoye, “An ekŋen, neŋ penaŋ sukwep zema nâit. Imbi kwambet bekopsat kapiyaŋ mânep pelewen bep keyaŋ an imbi sambe notnaŋaŋ tewalaŋ beyo bee sebemindein. ");
INSERT INTO naf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Am mânep milawatmak notnaŋ ekŋenaŋ mânewin omba penaŋ tatindainaŋgut butnaŋ bugan timti kot pelewen time towelep. Yaŋgut imbi kwambet bekopsat keyaŋ mânepmaŋ bugan elak kopeme pelewen towepme delaŋ zein. Mkaŋanen daenen butnaŋ ŋen ewe ku tasain, yek penaŋ.” ");
INSERT INTO naf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Âpme Zisasmak nembaŋane ekŋenaŋ sesewat mka temanengatnaŋ toti mepmambe nembaŋane notnaŋaŋ sesewat mka temaŋgalen nanzaŋ temaŋ kwetetepmaŋ ma am Kawawaŋgat taolet mânep temaŋ bewien keyelen miak miakŋaŋ dolakŋaŋ penaŋ ke ektemtem mti zewien. ");
INSERT INTO naf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ekŋenaŋ kegok zeme Zisasiyaŋ diindoye, “In kwitnaŋ kwitnaŋ ekti zeip ke kan ŋengat kasa kuku ekŋenaŋ kumasekme nanzaŋ keyaŋ mundumin katipemti lala bubuk totemebep.” ");
INSERT INTO naf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Egaŋ kegok zeme ekŋenaŋ kapigok zewien, “An zikat indanda, zenagen ke pe zukŋan sokbewe? Ma kwilekiyaŋ mkawaŋ beme kan keyaŋ kwasâpm ke nâwanup?” ");
INSERT INTO naf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ekŋenaŋ kegok zeme Zisasiyaŋ zeye, “An sambeyaŋ nâlen kwilen koti, ‘Neŋ Kilais!’ zewep ma, ‘Kan delaŋ zenze ilak kozin.’ Kegok zeme in zelin gawepumti indamâbâpiŋ. In weyaŋ ekmâtâbep mneti indayuŋguwepgat. ");
INSERT INTO naf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma in msat temaŋ ŋengalen kasa kuku an ekŋenaŋ msat temaŋ ŋengalen kasa kukumak aume nâmti in keyet kiŋgagapiŋ. Enenogat kwitnaŋ kwitnaŋ keboŋ keyaŋ kukŋaŋgat sokbewe wa ke kan delaŋ zenze yek.” ");
INSERT INTO naf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kegok zemti egaŋ ewe tusum zeye, “Msat temaŋ ŋenmak msat temaŋ ŋenmak meaum kweaum mbalup. ");
INSERT INTO naf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma mâkinaŋ temaŋ penaŋ kwabe ma meuyet kambeŋ sokbewe ma nukŋaŋ ekŋen keboŋ ke msat kataŋ sokbewe. Ma kwitnaŋ kwitnaŋ kiŋgagatnaŋmak sokbeme amnaŋ ke ekti kiŋgabep. Ma kululuŋen piliŋ mamanamaŋ sokbeme amnaŋ ekti kiŋgabep. ");
INSERT INTO naf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kan kwitnaŋ kwitnaŋ keyaŋ sokbembepiŋ mme inmagen sisipeŋpeŋ temaŋ nâgât mti mimindawep ma in notnaŋ an damuŋ ekŋengat zikalinan sesewat mkaen indatim mepme ekŋenaŋ zem indomti mka katikŋaŋ indewep. Ma in notnaŋ msalinaŋgalen amobotnaŋ temaŋ ma amobotnaŋ egat kandaŋan matalip ekŋengat zikalinan zemindowep. Nennmak matusuip keyepm nukŋaŋ kegok inmagen sokbewe. ");
INSERT INTO naf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","In kegok mbewen set katnaŋ dolakŋaŋ Kawawaŋgalen zezapatnaŋ zemkawaŋ bembeyelen sokbewe. ");
INSERT INTO naf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","In zelen ewe mebepiŋ tati, ‘Zet zigok zewanup,’ keyet yayaŋ mti nâmnukŋaŋ mimipiŋ ");
INSERT INTO naf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","enenogat nen zet zenzeyelen nânâ dolakŋaŋ indama zet zenzeyeen kanen kasaŋine ekŋenaŋ in ku mtotindewep. ");
INSERT INTO naf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma notnaŋ in mambiwin ma noline ma sip butnaŋ ekŋenaŋ msalinaŋgalen amobotnaŋ ekŋengat belinan beme mka katikŋan indewep. Ma in notnaŋ indome gakiwep. ");
INSERT INTO naf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ma in neŋ napmât maip keyepm am sambeyaŋ ingat sekaŋgaŋ nâmindewep. ");
INSERT INTO naf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yaŋgut neŋ indikdamuŋ mbap keyepm an ŋenaŋ ku indowe ma kegogak ŋokzuwin ŋen ku towembe. ");
INSERT INTO naf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","In kegok mimindame in nâmkiŋpepeen kaliŋaŋ tabewen in mama kanzizit ke ŋep tiwep.” ");
INSERT INTO naf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Âpme Zisasiyaŋ kapigok tusum zeye, “In ekme kan kasa kuku an ekŋenaŋ Zelusalem mka temaŋ kot bembuluŋme in nâwep, ‘Oweŋ, walelelak sokŋan sokbesâpm,’ ke otnâwep. ");
INSERT INTO naf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kegok sokbeween am Zudia msalen talip ekŋenaŋ kunzuŋti kalaŋ dukŋan mowebep. Ma am ŋenaŋ mka temaŋ keŋan tapmambe egaŋ ke pemti pem ŋen mebe. Ma am ŋenaŋ mka temaŋ ganzenan talip ekŋenaŋ mka temaŋ keŋan ku mobep. ");
INSERT INTO naf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kan keyet Kawawaŋaŋ Zuda am yominaŋgat dopmaŋ bekanaŋ penaŋ indawe. Ke Kawawaŋgalen Zet Itnaŋanen meluwaŋ kumpepeŋaŋ keyet katnaŋ sokbewe. ");
INSERT INTO naf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Keyaŋ sokbeween imbi keŋmak ma imbi nemba okakŋaŋmak kan keyet ekŋenaŋ kunzunzuŋgat nâmnukŋaŋ penaŋ mme ekŋenmagen kwitnaŋ kwitnaŋ bekanaŋ penaŋ sokbewe. Enenogat nukŋaŋ temaŋ penaŋ msalen kapi sokbewe ma Kawawaŋaŋ Zuda am ekŋen kemagen ŋenzinziŋ penaŋ nâmbe. ");
INSERT INTO naf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ma am notnaŋ kasaŋineyaŋ wanamaŋ indaŋme gakiwep ma notnaŋ msat beŋan beŋan indatim mepme keŋ titi mulup kaliŋaŋ mbep. Ma am Zuda maŋge ku sokbembeŋaŋ ekŋenaŋ Zelusalem mka temaŋ keŋan timkwati kwitnaŋ kwitnaŋ kumasekti kegok mme ekŋengalen kan delaŋ zeme peme tabe.” ");
INSERT INTO naf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Âpme Zisasiyaŋ zet ewe kapigok tusum zeye, “Kan keyet piliŋ mamanamaŋ sepem igak igak kasup ma eyoŋga ma wenzim ekŋenmagen sokbewe. Ma am msat sambe kataŋ ekŋenaŋ kwitnaŋ kwitnaŋ ke sokbeme kandadat mulup mbep ma nembu temaŋ kwisakŋaŋ ma nembu mamaŋ temaŋ takutume kwisakŋaŋ nomti kiŋgagat omba penaŋ mbep. ");
INSERT INTO naf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ma wenzim ma kwitnaŋ kwitnaŋ sambe ekŋen keyaŋ mundumin matokwaliwen puluk pilik pemti mundum belakŋan tokwabep keyepm am sambeyaŋ kwitnaŋ kwitnaŋ sokbesâpm keyet nâmti kiŋgagat omba penaŋ aikbep. ");
INSERT INTO naf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kegok sokbeme Angat Nemuŋaŋ neŋ zanza palen winde temaŋmak ma saŋga soŋga busatnaŋ temaŋ keŋan kopma nikbep. ");
INSERT INTO naf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Âpme kan keyaŋ yaŋbemti sokbeween in dendaŋ tati zikalin kululuŋen ekme mobe enenogat Kawawaŋaŋ in indatitiyelen kan ilak bududuk bein. Kegok otnâwep.” ");
INSERT INTO naf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Âpme Zisasiyaŋ bemzenze zet ŋen kapigok zeye, “In balam balam tep ekŋengat otnâit. ");
INSERT INTO naf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kan tep balam balam katnaŋ yaŋbemti kwapme manzeip, ‘O, ilak mtete yaŋbesâpm’. ");
INSERT INTO naf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sakam tep katnaŋ kwabe kegogak kwitnaŋ kwitnaŋ mamanamaŋ ekŋen keyaŋ sokbeme nâwep, ‘Ilak Kilaisiyelen zemâtâtât katnan mama kanaŋ sokŋan bein,’ otnâwep. ");
INSERT INTO naf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Neŋ penaŋ sukwep diindoma nâit am alak talip kapi ilindiŋ ku gakimâpme kwilekiki sambe kapi sokbesâpm. ");
INSERT INTO naf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Âpme msat ma kululuŋ asekmalut delaŋ zesâpm yaŋgut nâlen zetn delaŋ zenzeŋepiŋ matapmambe.” ");
INSERT INTO naf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Âpme Zisasiyaŋ zet ewe tusum zeye, “Weyaŋ ekmâtâbep! Mneti in amandanda ma tu kaliŋaŋ ma segalen kwitnaŋ kwitnaŋgat ŋoktikŋin temaŋ ekŋen keyet nâmkatik bemti tapmne peme kan delaŋ zenze sakwep kobeyet weyaŋ eksemti mambep. ");
INSERT INTO naf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ke sakamaŋ lelembeyaŋ kwap sakwep makuin keboŋ msat sambe am ekŋenmagen sokbewe. ");
INSERT INTO naf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","In weyaŋ ekmâtâti Kawawaŋgat dundupeŋ tapme winde indame kwitnaŋ kwitnaŋ nukŋaŋ keyaŋ inmagen gwaŋkumepme in windebeŋ tabep. In kegok mbewen Angat Nemuŋaŋ nâgât zikatnan ŋep tabep.” ");
INSERT INTO naf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Âpme kasupgat Zisasiyaŋ Zelusalem mka temanen tati egaŋ Kawawaŋgalen Zet Zapat Dolakŋaŋ sesewat mka temaŋ keŋan am mamzikat indamtan. Egaŋ kegok tapmme tambume egaŋ Olip Kalaŋan meti mawemtan. ");
INSERT INTO naf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kegok mamme msat msame am sambeyaŋ sesewat mka teman tambuŋan penaŋ Zisasiyaŋ Kawawaŋgalen Zet Zapat Dolakŋaŋ Penaŋ mkawaŋ beme nânâyelen makotemien. ");
INSERT INTO naf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Âpme Nupmamaŋ Yispiŋ Niniyelen Kendo kwitnaŋ ŋen Aŋgalaŋ Kendo sokŋan sokbeye. ");
INSERT INTO naf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ke sokbeme sâpe sâpe bumbuyelen an ŋeŋaŋ ma zii zet zikat indanda an ekŋenaŋ Zisas kume gakikiyet nâwien. Yaŋgut amnaŋ ndoseip nâmti kiŋgati Zisas kukuyelen setgat timabien. ");
INSERT INTO naf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kegok tapmme Zuda kwitnaŋ ŋen Iskaliot Sadaŋaŋ egat keŋan towege. Ek Zisasiyet nembaŋane 12 ekŋenmagengatnaŋ. ");
INSERT INTO naf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kegok sokbeme egaŋ sâpe sâpe bumbuyelen an ŋeŋaŋ ma sesewat mka temaŋgalen tipdakutum ekŋengalen amobotnaŋ ekŋenmak met Zisas set katnaŋ zigoset atamti ekŋengat belinan bembeyelen zemâtâtindaye. ");
INSERT INTO naf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kegok zeme amobotnaŋ ekŋen keyaŋ egalen zetnaŋgat oloŋen penaŋ mti ek mânewaŋ kwititiyelen zetik mbien. ");
INSERT INTO naf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kegok mme Zudas egaŋ ekŋengalen zetik keyet ŋep zeye. Ŋep zemti egaŋ Zisas set ŋen aikti ekŋengat belinan bembeyet kan amnaŋ ku mambembuluŋtemien keyet nâye. ");
INSERT INTO naf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Âpme Nupmamaŋ Yispiŋ Niniyelen Kendo keyaŋ sokbeme kan keyet sipsip nembaŋaŋ kumbumti nupmamaŋ yispiŋ kemak niniyelen kwitnaŋ Aŋgalaŋ Kendo keyaŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ke sokbeme Zisasiyaŋ Pita ma Zân egelaŋ met weyayaŋ mulup mimiyelen zemâtâtidaye ke kapigok, “It meti Aŋgalaŋ Kendo meu nimtasenupgat weyaŋ mulup mselup.” ");
INSERT INTO naf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Egaŋ kegok zeme nembaŋane egelaŋ yaŋkwesiwun, “Wae, Amobotnaŋ, nit tu meu pe mka deset weyaŋselup?” ");
INSERT INTO naf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Egelaŋ kegok yaŋkwesimalut Zisasiyaŋ diidoye, “It nâit, it mka temaŋ keŋan moweseluwen an ŋen menzim temaŋ tumak keyaŋ idaiksem. Idaikme it ek mâti mka egaŋ mepme keyegak mât moweselup. ");
INSERT INTO naf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ke moti mka toŋaŋgat kapigok dunduselup, ‘An zikat indandayaŋ gâgât yaŋkwesip: Mka keŋan nembanne Aŋgalaŋ Kendoyelen tu meu nsenup ke deset tazin?’ Kegok zeselup. ");
INSERT INTO naf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","It kegok zemalut egaŋ mka tedukŋan mot zikat idasem. Keyet keŋan mundum totatat ma menzim pelep ma meu bumbu mundumaŋ ma kwitnaŋ kwitnaŋ notnaŋ keyet keŋan tapme it tu meu weyeyaŋ mulup mselup. It nâlup?” ");
INSERT INTO naf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Zemideme egelaŋ meti kwitnaŋ kwitnaŋ Zisasiyaŋ zemideye keyet kataŋ sokbeme egelaŋ Aŋgalalaŋ Kendoyelen tu meu weyaŋbun. ");
INSERT INTO naf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Âpme tambuŋalem niniyelen kan sokbeme Zisas ma nembaŋane ekŋenaŋ mundum totatalen totabien. ");
INSERT INTO naf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ke totati egaŋ ekŋengat diindoye, “Neŋ Aŋgalalaŋ Kendo kapiyelen tu meu inmak niniyelen eweŋan baenen nâmtikŋaŋ penaŋ mban ya alak tatnnup bamgat an notnaŋaŋ sindem omba penaŋ naseip! ");
INSERT INTO naf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Neŋ diindoma nâit, neŋ Aŋgalaŋ Kendoyelen meu ewe sek ŋen ku nimbap yaŋ maneti am yomengatnaŋ timkwat indema nâmkiŋpepe aikme mulup keyaŋ delaŋ zeme kan keyet kululuŋen gwaen tu meu ke nsakwep nimbanup.” ");
INSERT INTO naf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Egaŋ ke zemti okop wain tumak mti Kawawaŋgat wisikŋ zemti ekŋengat zeye, “In kapi mti ilinak nit.” ");
INSERT INTO naf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kegok zemti zeye, “Neŋ penaŋ sukwep zema nâit, neŋ wain tu ke ninipiŋ maneti bamgat Kawawaŋgalen zemâtâtâtgat katnaŋ mama kululuŋen gwaen tati wain alakŋaŋ ke nsakwep nbanup.” ");
INSERT INTO naf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sakam kegogak egaŋ nupmamaŋ ŋen mti Kawawaŋgat wisikŋ zemutumti nembaŋane indamti zeye, “In mti nit. Kapi nanaŋgat sek sesumbannok ke ingat indayap. Ke ingat indama nimti nâgât otnânâyelen nâmti indayap.” ");
INSERT INTO naf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kan ekŋenaŋ tu meu nim delaŋ zeme sakam kegogak okop ikŋaŋ ke mti zeye, “Okop wain tumak kapi tususu alakŋaŋ inmak Kawawaŋmak. Sipmnaŋ tusum indeyap. Sipm tewen nâme sipmnaŋ tobe ke in yominaŋgatnan indatim kwakwagat nâmti kegok mbap. ");
INSERT INTO naf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yaŋgut, nembanne, in egit! An ŋenaŋ zemnowe ke ninmak meu nini munduman kapi totazin! ");
INSERT INTO naf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Angat Nemuŋaŋ neŋ Kawawaŋaŋ zemâtâtâtnaŋ set katnaŋ ke mâti gakiwap. Yaŋgut an neŋ zem nosem an kemagen bekanaŋ penaŋ sokbewe!” ");
INSERT INTO naf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Zisasiyaŋ kegok zeme nembaŋane ekŋenaŋ ilinak zenâ zenâ mti zewien, “An ekŋen, an pe kwiyaŋ kogok mbe?” Kegok zewien. ");
INSERT INTO naf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Âpme Zisasiyet nembaŋane ekŋenaŋ ilinak an kwiyaŋ mobotnaŋ bein zemti zet mmot mtot mti mdândâwien. ");
INSERT INTO naf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kegok tapmme Zisasiyaŋ nâmti diindoye, “Msalengalen amobotnaŋ ekŋen amŋin indikdamuŋ mimiyelen winde taindain. Ma an damuŋ ekŋen amnaŋ, ‘Amgalen noline,’ kwilin makuip. ");
INSERT INTO naf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yaŋgut inmagen keboŋ keyaŋ ku sokbewe. Yek penaŋ. Âpme naman ingat tuŋguwinan amobotnaŋ an kwiyaŋ tabeen ikŋaŋgat sekŋan mtoti am kwilinpiŋ ekŋengat kandaŋinan mambe. ");
INSERT INTO naf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","An kwi ek amobotnaŋ? An mundum totatalen totati meu tatnin ke ma meu menzimen taseŋzin an ke? Ke penaŋ, an mundum totatalen totati meu tatn an ke amobotnaŋ. Yaŋgut neŋ kegogak ingalen amobotnaŋin neŋ nanaŋgat sekŋ mtoti tapmamti taindamukulem miyap. ");
INSERT INTO naf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Âpme kan nukŋaŋ sepem igak igak neŋmagen sokbeyeen in neŋ ku katinewien. ");
INSERT INTO naf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bipm kululuŋen egaŋ am indikdamuŋ mimiyelen zetik mneyeyepm ma neŋ kegogak in indazetik mimindeyap ");
INSERT INTO naf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","in neŋmak kululuŋen gwaen mundum totatalen totati tu meu nsakwep nimbanup ma in mundum elimayakŋaŋmak keyet dukŋan totati Islael am maŋge 12 indikdamuŋ mbep.” ");
INSERT INTO naf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Âpme Zisasiyaŋ ewe tusum zeye, “Saimon, Saimon, geŋ nâmbak, Sadaŋaŋ ingalen nâmkiŋpepeŋin mimindikme mkatikŋaŋ bep ma tuwat tuwat talip keyelen Kawawaŋaŋ nâmpep. ");
INSERT INTO naf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yaŋgut Saimon, neŋ Kawawaŋaŋ gapmukulem mme nâmkiŋpependaŋ kaliŋaŋ tatagalen dunduya. Ya geŋ yomdi ke nâmkawaŋ bewanigen keŋdi gilik zeme nâlen zetn tapmâtigulak nodine neŋ manamâtmaip ekŋengalen nâmkiŋpepe bandim mimindewanik.” ");
INSERT INTO naf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Egaŋ kegok zeme Pitayaŋ kapigok dunduye, “Amobotnaŋ, neŋ geŋmak mka kaliŋan meti geŋmak gakikiyelen weyeyaŋ mulup miyap!” ");
INSERT INTO naf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Egaŋ kegok zeme Zisasiyaŋ dunduye, “Pita, neŋ gâgât zema nâmbak, alak tambuyet sakokolok apmaŋ kwitnaŋ kukupiŋ mme geŋ nâgât sek tuk zemkandasenik.” ");
INSERT INTO naf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Âpme Zisas nembaŋaneyet kapigok diindoye, “Neŋ indema msat notnaŋ Kawawaŋgalen zezapat dolakŋaŋ mkawaŋ bembeyelen mebienen kan keyet in mânep eleŋaŋ ma ele milawat wawat ma set wewet ke ku ti mebien kan keyet in kwitnaŋ kwitnaŋ notnaŋgat olalat mbien ma yek?” Egaŋ kegok indayaŋkwesime ekŋenaŋ zewien, “Yek penaŋ, ku olabenn.” ");
INSERT INTO naf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ekŋenaŋ kegok zeme Zisasiyaŋ zeye, “Yaŋgut alak an mânep eleŋaŋmak ma ele milawat wawat ke tiseip. Ma an ŋen wanam teepmaŋaŋ yek egaŋ kâlâp tâgâyelen munduŋ main ke beme kwitime wanamaŋ teepmaŋ kwitiwe. ");
INSERT INTO naf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ma neŋ diindoma nâit: Kawawaŋgalen zezapat itnaŋaŋ kapigok zenzeŋaŋ, ‘Ek zelen zem kuwep sakam aindondo am ma an kambutiti ekŋen maindeipnok!’ Âpme kwitnaŋ kwitnaŋ sambe golaŋ zenze an ekŋenaŋ nâgât kukuŋaŋ ke sosok sokbemkawaŋ tabein.” ");
INSERT INTO naf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Egaŋ kegok zeme ekŋenaŋ zewien, “Amobotnaŋ, ndikbak, nin wanam zut tatndain.” Zeme egaŋ zeye, “Neŋ wanam kwititiyet zeya ewan wanam penaŋ kwititiyet ku zeya. Nukŋaŋ bam sokbesâpm keyet amnaŋ zigok weyeen mulup mimiyet nâmti zeya. Keyet wanamgat zapat ŋen ewe zenzepiŋ. Ele, metne.” ");
INSERT INTO naf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Âpme Zisasiyaŋ mka temaŋ ke pemti Olip Kalaŋan mametan kegok mepme nembaŋane ekŋenaŋ mâti mebien. ");
INSERT INTO naf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ke meti ekŋenaŋ ke pataŋ zemti egaŋ ekŋengat zeye, “In kapi tati tadundumaseip mneti Sadaŋaŋ ingat yaŋin mimindikme toweseipgat.” ");
INSERT INTO naf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kegok zemindemti ekŋen katim indemti amnaŋ nanzaŋ mapemezin keyet kataŋ metati pedondomti kapigok dunduye, ");
INSERT INTO naf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bien, gitaŋgat nânâyet nâlen nukŋaŋ kapi mâtâpesenik. Yaŋgut geŋ nâlen nânân mâbâpiŋ; geŋ gitaŋgat nânândi mâsenik.” ");
INSERT INTO naf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kegok tadundume Kawawaŋgalen enselaŋ kululuŋengatnaŋ ek winde sasayelen koge. ");
INSERT INTO naf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kegok sokbeme Zisasiyaŋ gakikiyelen kan bududuk sokbeye keyepm nâmnukŋaŋ mti ewe tusum omba windeŋaŋbeŋ penaŋ dunduye ma pusinaŋaŋ sekŋanengatnaŋ sakam sipnok petak petak msalen toge. ");
INSERT INTO naf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nembaŋaneyaŋ kwitnaŋ kwitnaŋ sokbesâpm keyet nâmnukŋaŋ penaŋ mti ma tambu tetak takwabiengapm melugaŋ indome wem kopa bewien. Egaŋ dundu delaŋ zemti dendaŋ wati nembaŋanemagen meti indikme tawemambien. ");
INSERT INTO naf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Indabutemti ekŋengat zeye, “In meluk wewepiŋ. Kaik watati dundundu mulup mit. Mneti amnaŋ koti ingat nâmkiŋpepeŋinaŋgat yaŋaŋ mimindikseipgat.” ");
INSERT INTO naf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Zisasiyaŋ zet ewe tusumti tazeme an maŋge temaŋaŋ kobien. Âpme ekŋenmagengatnaŋ an Zudas ek Zisasiyet nembaŋane 12 ekŋenmagengatnaŋ egaŋ kukŋaŋgat indatim koti Zisasmagen mebien. ");
INSERT INTO naf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ke kopme Zisasiyaŋ yaŋkwesiye, “Zudas, geŋ nuknuk mnesenik keyaŋ mkawaŋ beinen Angat Nemuŋaŋ neŋ amgat belinan nesenik, ma?” ");
INSERT INTO naf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Âpme Zisasiyet nembaŋane ekŋenaŋ kwitnaŋ kwitnaŋ sokbesâpm ke ek kawaŋ bemti egat zewien, “Amobotnaŋ, geŋ nâmndemane nin wanamaŋ ekŋen indaŋsenup?” ");
INSERT INTO naf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kegok zemti ekŋenmagengatnaŋ ŋenaŋ sâpe sâpe bumbu an ŋeŋaŋ egalen mulup an ŋen wanamaŋ wakŋaŋ penaset sâmpeme enzaŋ galaŋ galaŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kegok sokbeme Zisasiyaŋ ekti zeye, “Muluwaŋ bekanaŋ ke katipe!” Kegok zemti an keyet wakŋaŋ anzam tage ke taŋgume ŋep beye. ");
INSERT INTO naf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kegok sokbeme sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋgalen an dakutum ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ Zisas atasâgât kobien ekŋen keyet zeye, “In wanam ŋilikŋaŋ ma wenzomak natatayelen kolo keyaŋgut neŋ an kambu tititoŋ yek. ");
INSERT INTO naf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Neŋ inmak kasup kataŋ Kawawaŋgalen sesewat mka temaŋ keŋan matateman ke in ku natawien. Ya alak ingalen kan neŋ natatayelen beme Sadaŋaŋ mulup bekanaŋ mamnen sosok sokbein.” ");
INSERT INTO naf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Zisasiyaŋ kegok zeme ekŋenaŋ atamti tetimet sâpe sâpe bumbu an ekŋengalen an ŋeŋaŋ egalen mka keŋan wapmobien. Âpme Pitayaŋ igak bam sukwep takopmaŋge. ");
INSERT INTO naf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ke koti ekme an notnaŋaŋ zet nânâ mka tuŋgupman tep mmenzime totatmambienen Pitayaŋ kot ekŋenmagen totage. ");
INSERT INTO naf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ke kototapme mulup imbi ŋenaŋ tewen ke totapme ekti weyaŋ zikat memuŋ ektati zeye, “An kapi kegogak Zisasmak mamtan!” ");
INSERT INTO naf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Imbiyaŋ kegok zeme Pitayaŋ yaŋti zeye, “Imbi nânik, neŋ an ke ku nâmpeyap!” ");
INSERT INTO naf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ya belaknik ke tati an ŋenaŋ Pita weyaŋ ekmâtâti zeye, “Geŋ kegogak Zisasiyelen maŋgeen mamanik!” Kegok zeyeyaŋgut Pitayaŋ ewe yaŋti zeye, “Notn, geŋ zenigen ke penaŋ sukwep an ke neŋ ku nâyap!” ");
INSERT INTO naf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ke tapmâti aua kwep kegok delaŋ zeme an ŋenaŋ ekti zet windeŋaŋbeŋ yaŋkwesimti zeye, “Kapi penaŋ, an kapi kegogak Zisasmak tapme ekban ma ek kegogak Galili msalengatnaŋ!” ");
INSERT INTO naf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kegok zeme Pitayaŋ zeye, “Notn nânik, geŋ an zenigen ke neŋ ku nâmâtâlap!” Egaŋ kegok tazeme keyegak sakokolok apmaŋaŋ kwitnaŋ kuye. ");
INSERT INTO naf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kegok kume Amobotnaŋaŋ gilik zemti Pita eksem tage. Amobotnaŋaŋ kegok mme Pitayaŋ egalen zet eweŋan dunduye ke nâmkawaŋ beyeen kapigok, “Geŋ alak sakokolok apmaŋ kwitnaŋ kukupiŋ tapme geŋ nâgât ku nâmpeyap sek tuk zesenik.” ");
INSERT INTO naf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pitayaŋ zet ŋande ke otnâmti zupman kwatoti si omba penaŋ suye. ");
INSERT INTO naf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Âpme an ekŋen Zisas ekdamuŋ mbien ekŋen keyaŋ pep zet msamti witikbien. ");
INSERT INTO naf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kegok mti saŋgum paŋaŋaŋ zikatnaŋ kwaik pemti yaŋkwesiwien, “Geŋ golaŋ zenze an manzenikgat an kwiyaŋ goin geŋ ke zemane nâne!” ");
INSERT INTO naf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kegok msamti zet bekanaŋ totot tototnaŋ sambe msawien. ");
INSERT INTO naf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Msat msame sesewat mka temaŋgalen an damuŋ ma sâpe sâpe bumbuyelen an ŋeŋaŋ ma zii zet zikat indanda ekŋenaŋ Zisas wati an damuŋ sambeyaŋ ondekbienen ke aik meti yaŋkwesiwien, ");
INSERT INTO naf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Geŋ zema nâne, geŋ Kilais, Kawawaŋ an ikŋaŋ ombemgeŋgeŋaŋ ma an kwi?” Kegok yaŋkwesime egaŋ diindoye, “Neŋ keyet yaŋaŋ ingat zesap beme in ku nâmkiŋpeseip. ");
INSERT INTO naf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma neŋ yaŋkwesisi ŋen indayaŋkwesisap beme in keyet yaŋaŋ ku dinoseip. ");
INSERT INTO naf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yaŋgut kwitnaŋ kwitnaŋ sokbesâpm kapiyet bamen Angat Nemuŋaŋ neŋ mundum bet penaset Kawawaŋaŋ an ikŋaŋmak tatagalen nâme matazin mundum ke windeyelen mundum ke nename totabap.” ");
INSERT INTO naf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Egaŋ kegok zeme ekŋen sambeyaŋ yaŋkwesiwien, “Keyepm geŋ Kawawaŋgat Nemuŋaŋ, ma?” Ekŋenaŋ kegok yaŋkwesime egaŋ diindoye, “Ilin zemkawaŋ bep kelak neŋ kapimak.” ");
INSERT INTO naf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Egaŋ kegok zeme ekŋenaŋ zewien, “Nin yegak zetnaŋ zem kukuyelen kelak nâmâtâtnup keyepm an ŋen egalen zet bandim mimiyelen ku aiksenup.” ");
INSERT INTO naf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Âpme amobotnaŋ sambe ekŋenaŋ zet ŋande ke nâmwati Zisas aikti amobotnaŋ Pailetmagen mebien. ");
INSERT INTO naf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ke metati egat zet dâsuki ekŋenaŋ Pailetgat zikatnan ombem zewien, “An kapiyaŋ ningalen amm ekŋengat amobotnaŋ Sisamagen mânep takis ku kwititiyelen zemkulumindeye ma egaŋ ikŋaŋgat ‘Amobotnaŋ Kilais’ zeye.” ");
INSERT INTO naf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ekŋenaŋ kegok zeme amobotnaŋ Pailelaŋ Zisasiyet yaŋkwesiye, “Geŋ Zuda maŋgeyelen Amobotnaŋ ma?” Zeme Zisasiyaŋ egalen zet dopmaŋ gilik zeye, “Giti ke zenik kemak.” ");
INSERT INTO naf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kegok zeme amobotnaŋ Pailelaŋ sâpe sâpe bumbuyelen an ŋeŋaŋ ma am maŋge tabien ekŋengat zeye, “Neŋ an kapi zem kukuyelen zet dolakŋaŋ penaŋ ŋen ku aigap.” ");
INSERT INTO naf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Egaŋ kegok zeme ekŋenaŋ zet omba moti zewien, “An kapiyaŋ Galili msat kataŋ yaŋbemti am keŋin mwapme gapmanmak kasa kukuyelen zempeme Zelusalem mka teman zemkwezin. Ma Zudia msalen kataŋ sakam kegogak tasokbein.” ");
INSERT INTO naf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Âpme amobotnaŋ Pailelaŋ zet ke nâmti am ekŋen indayaŋkwesiye, “An kapi Galili msalengatnaŋ, ma?” ");
INSERT INTO naf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Egaŋ otnâyeen Galili msat ke amobotnaŋ Elolaŋ maekdamuŋ min nâmti Zisas peme amobotnaŋ Elotmagen teti mebien. Elolaŋ kan keyet Zelusalem mka temanen kotage. ");
INSERT INTO naf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ya Zisas amobotnaŋ Elotmagen tetimebien kan teepmaŋ Elolaŋ Zisasiyelen zet zapat sambe ke nâmti ek eegalen maotnâmtan keyepm Zisas eegalen oloŋen penaŋ mge. Egaŋ otnâyeyen Zisas egaŋ menok ŋen mme eegalen nâye. ");
INSERT INTO naf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Keyepmti amobotnaŋ Elolaŋ Zisas yaŋkwesisi omba penaŋ yaŋkwesiye yaŋgut Zisasiyaŋ egalen zet dopmaŋ ŋen ku zeye. ");
INSERT INTO naf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kegok sokbeme sâpe sâpe bumbuyelen an ŋeŋaŋ ma zii zet zikat indanda ekŋenaŋ amobotnaŋ Elotmagen sokŋan koti Zisas zemkukuyelen zet windeŋaŋbeŋ zewien. ");
INSERT INTO naf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kegok zeme amobotnaŋ Elot ma egalen an kasa kuku ekŋenaŋ Zisas pep zet msamti zet mtopepe zet zemti kâlâp teepmaŋ dolakŋaŋ penaŋ same mundumge sepem amobotnaŋ ekŋenaŋ mamunduŋip keboŋ mundumpemti tetimti amobotnaŋ Pailetmagen gilik ze mebien. ");
INSERT INTO naf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tipman baenen amobotnaŋ Elotmak amobotnaŋ Pailet egetmagen kasa kasa takwage ya kan keyet egelaŋ notn notn pembenaŋ mbun. ");
INSERT INTO naf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ke aikti kopme amobotnaŋ Pailelaŋ sâpe sâpe bumbuyelen an ŋeŋaŋ ma sesewat mka temaŋgalen an damuŋ ma an imbi sambe zeme ondekme ");
INSERT INTO naf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kapigok indayaŋkwesiye, “In an kapiyaŋ animbi keŋin tapm yuŋgun kegok zemti in neŋmagen aiikolo yaŋgut neŋ ingat zikalinan an kapiyet yaŋaŋ mim egeyaŋ egalen bekanaŋ mimiŋaŋ in zem kuyoyen ke ŋen ku aigap. ");
INSERT INTO naf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma kegogak amobotnaŋ Elolaŋ egalen bekanaŋ mimiŋaŋ ku aikti peme ninmagen kozin. Ma an kapi nin kumann gakikiyelen bekanaŋ mimiŋaŋ ŋen ku mge. ");
INSERT INTO naf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Keyepmti neŋ zema kasa kuku an ekŋenaŋ witikme belak zem pema mesem.” ");
INSERT INTO naf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Âpme Aŋgalalaŋ Kendoyet kataŋ amobotnaŋ Pailelaŋ an kwep Zuda ekŋenmagengatnaŋ mka katikŋan tatatnaŋ ekŋen manzemindeme belak kwawetemien. ");
INSERT INTO naf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Âpme an ŋenaŋ kwitnaŋ Balabas ek am keŋin walapme Loma gapmanmak an kasa kasa Zelusalem mka temaŋ keŋan ke mti an ŋen kume gakime mka katikŋan pewien. Pailelaŋ Zisas peme belak mebegalen nâm zemeŋgut an imbi sambeyaŋ kwizet kumti zewien, “Kume gakik. Balabas belak peme mesem!” ");
INSERT INTO naf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Âpme amobotnaŋ Pailelaŋ Zisas belak peme mesât nâmti am ekŋengat yaŋkwesisi kwizet paleset kuye. ");
INSERT INTO naf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kegok kuye yaŋgut ekŋenaŋ kwizet dopmaŋ kapigok kuwien, “Tewen kume gakik! Tewen kume gakik!” kwizet kegok kuwien. ");
INSERT INTO naf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kegok kume egaŋ sek ŋen ewe indayaŋkwesime sek tuk beme kapigok zeye, “An kapiyaŋ kwileki myuŋguye? Neŋ egaŋ gakisem kapiyelen myuŋguŋguŋaŋ ŋen ku aigap! Keyepm witikti belak pemann mesem.” ");
INSERT INTO naf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Egaŋ kegok zeyeyaŋgut ekŋenaŋ kwizet ewe giŋgiŋ kumti Zisas tewen kume gakikiyelen zewien. Kwizet kegok takume amobotnaŋ Pailelaŋ zelin gawepumti ");
INSERT INTO naf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ekŋenaŋ nâwienen keyet kataŋ Zisas zemdelaŋ zempeye. ");
INSERT INTO naf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pailelaŋ kegok mti an ekŋenaŋ belak mka katikŋan kwaselen peme kwawewegalen an ke wekume belak zempeme kwawege. An ke gapmanmak kasa kasa mti an ŋen kume gakime mka katikŋan pewien. Kegok mti Zisas ekŋengat belinan beme ekŋenaŋ ilin nâwien keyet kataŋ mbien. ");
INSERT INTO naf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Âpme ekŋenaŋ kegok mti Zisasiyaŋ gakikiŋaŋgalen tepmaŋ ikŋaŋ pume mepmambe an ŋen kwitnaŋ Saimon Silini msalengatnaŋ an ke Zelusalem mka temaŋ keyelen kimbat zupman tapmaŋge ya egaŋ Zelusalem kimbat keŋan mowepme kasa kuku an ekŋenaŋ aikti apitilime Zisasiyelen gakikiŋaŋgalen tep ke pumti Zisasiyet bamanen mege. ");
INSERT INTO naf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ekŋenaŋ kegok mme an imbi sambeyaŋ Zisas mâbien ekŋengat tuŋguwinangatnaŋ imbi notnaŋ si zesum zesum egat tapm mepmambien. ");
INSERT INTO naf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ekŋenaŋ kegok tapm mepme Zisasiyaŋ gilik zem indikti zeye, “Zelusalem imbi, nâgât susupiŋ! Neŋ nâyawen dolakŋaŋ ilinaŋgat ma nembaŋineyet suit. ");
INSERT INTO naf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Enenogat kan nukŋaŋ temaŋaŋ sokbeme amnaŋ zewep, ‘Imbi ekŋen nembaŋinpiŋ ma imbi nemba okak ku maambelip ma imbi nemba okak nam ku maindap ekŋen keyaŋ oloŋen penaŋ mbep.’ ");
INSERT INTO naf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma kan keyegak amnaŋ kiŋgati ‘Kalaŋgat pigok zewep, “In epeemti ndakwatait!” ma sepem kegogak kalaŋ isikŋaŋgat zewep, “Nin aŋgalaŋ nde!” zewep!’ ");
INSERT INTO naf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Âpme an yomepiŋ ekmagen kwitnaŋ kwitnaŋ bekanaŋ ekmagen sokbein beme am yomtoŋ ekŋenmagen bekanaŋ penaŋ sokbewe!” ");
INSERT INTO naf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma keyegak kasa kuku ekŋenaŋ an zut idatim mebien. An zut ke an kambu titi ya Zisasmak idome gakikiyelen idati mebien. ");
INSERT INTO naf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ke meti kalaŋ kwitnaŋ Ŋokanziŋ Kalaŋ ke pataŋ zemti Zisas tewen kumasasok pemti mwat onzempewien. Ma Zisas betnaŋ penaset ma alomset an kambu titi zut ke tewen gakikiyelen idewien. ");
INSERT INTO naf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ekŋenaŋ kegok mme Zisasiyaŋ zeye, “Bien, ekŋenaŋ kwitnaŋ kwitnaŋ tapmip ke ku nâmâtâlip keyepm ekŋengat yomin katipe!” Egaŋ kegok zeme kasa kuku an ŋeŋaŋinaŋ sâk melakanduŋaŋ nanzaŋ bet guluk gilik mti kwiyaŋ penaŋ tisem ke nâmti mbien. ");
INSERT INTO naf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kegok sokbeme an imbi sambeyaŋ dendaŋ tati taekme keyegak Zuda ekŋengalen amobotnaŋ ekŋenaŋ Zisasiyet pep zet msamti zewien, “Egaŋ am notnaŋ maindamukulem mimindein ya ek Kilais, Kawawaŋaŋ ikŋaŋ ombempepeŋaŋ beme ikŋaŋgat sekŋaŋ ŋep mukulem mpesem!” ");
INSERT INTO naf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sakam kegok kasa kuku an ekŋenaŋ msamti ekmagen sokŋan koti wain tosaŋaŋ isikŋaŋ ke same niniyelen ke nâmti mbien. ");
INSERT INTO naf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kegok mti zewien, “Geŋ Zuda amgalen Amobotnaŋ beme gitaŋgat sekdi mukulem mi!” ");
INSERT INTO naf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Âpme meluwaŋ ŋen kapigok kumpewien, ");
INSERT INTO naf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kegok sokbeme an kambu titi zut egetmagengatnaŋ ŋenaŋ Zisasiyet pep zet msamti zeye, “Geŋ Kilais, Kawawaŋ an ikŋaŋ ombemgeŋgeŋaŋ beme gitaŋgat sekdi mukulem mti nit kegogak ndamukulem mi!” ");
INSERT INTO naf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ŋenaŋ kegok zeme ŋenaŋ zet ke nâmti ŋenzinziŋ msamti zeye, “Geŋ Kawawaŋgat kiŋgadik ma yek? Nin tuk kapi nsakwep gakikiyelen zemdelaŋ zemndeyo. ");
INSERT INTO naf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nit bekanaŋndaŋgat dopmaŋ gakisâpmilup ke ŋep yaŋgut an kapi ek myuŋguŋguŋaŋ ŋen ku tazin, yek penaŋ.” ");
INSERT INTO naf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","An keyaŋ kegok zemti Zisasiyet zeye, “Geŋ Amobotnaŋ kobanigen nâgât nâmnewanik!” ");
INSERT INTO naf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Egaŋ kegok zeme Zisasiyaŋ dunduye, “Neŋ penaŋ sukwep zeyap, alak geŋ neŋmak kululuŋen tasenik.” ");
INSERT INTO naf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Âpme 12 kilok kasup sutnaŋ bembeyelen sokŋan beme msat tambumbuyaŋ pesak peme tapmeti 3 kilok gasiyet beye. ");
INSERT INTO naf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kegok sokbeme saŋgum temaŋ Zelusalem sesewat mka temaŋ keŋan maopem peme topmatatan ke tuŋgupman edelet balalaŋ zemtoti butnaŋ butnaŋ beye. ");
INSERT INTO naf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kegok sokbeme Zisasiyaŋ kwizet temaŋ kumti zeye, “Bien, nâmamann gâlen belen beyap!” Kegok zemti gakiye. ");
INSERT INTO naf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kegok sokbeme kasa kukuyelen an ŋeŋaŋ egaŋ kwitnaŋ kwitnaŋ ke eknâmti Kawawaŋgat sesewati zeye, “Penaŋ sukwep, an kapi an kwetetepmaŋ penaŋ!” ");
INSERT INTO naf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","An imbi sambe tabien ekŋenaŋ ke ekmâtâti kembeŋ penaŋ nâmti mkaŋinan mebekobien. ");
INSERT INTO naf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Âpme am Zisas egat nâmâtâbien ma imbi ekŋen Galili msalengatnaŋ Zisas mâkobien ekŋenaŋ beŋanik tati kwitnaŋ kwitnaŋ sokbeye ke eknâmâtâbien. ");
INSERT INTO naf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Âpme an ŋen kwitnaŋ Zosep ek Zuda ekŋengalen mka temaŋ kwitnaŋ Alimatia keyetnaŋ. Ek an dolakŋaŋ ma an kwetetepmaŋ ma ek amobotnaŋ Zisas zemkuwien ekŋenmagengatnaŋ ŋen ek keyaŋgut egaŋ ekŋengalen nânâ Zisas kukuyelen nâmbiliwebien keyet nâmtikŋaŋ penaŋ ku mge. Egaŋ Kawawaŋ an ikŋaŋ ombem pepeŋaŋ koti Kawawaŋgalen zemâtâtât katnaŋ mama mamkwatan. ");
INSERT INTO naf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Keyepm egaŋ amobotnaŋ Pailetmagen meti Zisas sekŋaŋ tewen mtoti sumen bembeyelen meti yaŋkwesime amobotnaŋ Pailelaŋ ŋep nâmpeye. ");
INSERT INTO naf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ŋep nâmpeme Zosewaŋ Zisasiyet sekŋaŋ tewen mtoti sâk palakŋaŋaŋ sekŋaŋ sumuŋ pemti mti met nanzaŋ kapalaŋ enzuŋ temaŋ kwaŋ pepeŋaŋ an ŋen ku bembeŋaŋ keyet keŋan mmet beye. ");
INSERT INTO naf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma kan keyet Bepmaŋ ma Sabat tagoŋgo tatagalen sokŋan koge. ");
INSERT INTO naf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kegok sokbeme imbi ekŋen Galili msalengatnan Zisasmak kobien ekŋen keyaŋ Zosep mâti Zisas sekŋaŋ mepme sum deset bembeyelen ma sepem zigok pewesem ke eegalen mebien. ");
INSERT INTO naf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Imbi ekŋen keyaŋ ke koekti gilik zemti mkaŋinan meti wet sesikŋaŋ dolakŋaŋ Zisas sekŋaŋ kumpepeyelen ke met weyeyaŋ mulup mbien. Enenogat Sabat tagoŋgo kanen mulup ŋen ku mimiyelen ilinaŋgalen zii zelaŋ zemkatik bein. ");
INSERT INTO naf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Âpme Sabat tagoŋgo kan delaŋ zeme mseŋan Sonda tambuŋan msat tapm msame imbi ekŋen wet kelakŋaŋ weyeyaŋ mulup mbien ekŋen keyaŋ wet kelakŋaŋ ke mti sumen ke kobien. ");
INSERT INTO naf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ekŋenaŋ ke koti ekme nanzaŋ temaŋ sumgalen sekekek bekek pewien ke welilim peme ganzenan metage. ");
INSERT INTO naf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kegok sokbeme ek nâmti ekŋenaŋ keŋan mowebien yaŋgut Amobotnaŋ Zisasiyet sekŋaŋ ku tapme ekbien. ");
INSERT INTO naf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ke motati nâpeme mekwapme tatnepeme keyegak an zut melakanduŋit busatnaŋ temaŋmak keyaŋ ekŋenmagen sokŋan kotabun. ");
INSERT INTO naf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ekŋenaŋ ke ekti kiŋgagalaŋ indatime kusumti zikalinaŋ msalen baen ektatnepeme an zut keyaŋ kapigok zewun, “In kwilekiyet mti am gakikiŋaŋgalen mundumen pi an alik walep keyet kwilekiyet taegip? ");
INSERT INTO naf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","An in eegalen kolo ke kapi ku tazin. Egaŋ gakikiengatnaŋ walep. In egaŋ Galili msalen inmak tati zezapat kapigok diindoye ke otnâit ke, ");
INSERT INTO naf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Angat Nemuŋaŋ neŋ a yomtoŋ ekŋengat belen mopma tewen gwilimaŋ nowep. Ya kasup mulup mimi tuk keyet mamaen gilik zem wabap,’ kegok diindoye.” ");
INSERT INTO naf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","An zut keyaŋ kegok zemalut imbi ekŋen keyaŋ zet ŋande ke otnâmti ");
INSERT INTO naf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","sum katipemti mkaŋinan gilik zem meti kwitnaŋ kwitnaŋ eknâmmbien keyet met Zisasiyelen nemba 11 ma notnaŋgat zezapat mimindawien. ");
INSERT INTO naf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Imbi ekŋen zezapat nembaŋane ekŋengat kozewien ekŋen ke kwilin Malia Makdala mkaengatnaŋ ma Zoana ma Malia Zemsiyet mamaŋ ma imbi notnaŋ ekŋen ke. ");
INSERT INTO naf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kegok kozewien yaŋgut nembaŋane ekŋenaŋ imbi ekŋen keyelen zelin nâme pepesut imbi zezet beye ma ekŋengat ku nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pitayaŋ zet ke nâmti wawadak winde bemti sumen meti sekekegen kusum toti zikatnaŋaŋ Zisasiyelen mundumanen ke egeen saŋgum miak pewien ke etaŋaŋ tage. Ke ekti mkaŋan meti kwitnaŋ kwitnaŋ sokbeye keyet nânâ mulup temaŋ mge. ");
INSERT INTO naf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Âpme kan keyet am zut Zisas mâpmamtemien egelaŋ Emaus mka temaŋgalen selen mkaen ke mebegalen tapmepmambun. Mka keyetnaŋ Zelusalem mka temanen ke mebegalen mael 7 kegok mametemien. ");
INSERT INTO naf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Egelaŋ ke mepmambe Zisasmagen kwitnaŋ kwitnaŋ sokbeye keyet zenâ zenâ tapmepmambun. ");
INSERT INTO naf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kan egelaŋ zenâ zenâ tapmepmambunen keyegak Zisas ikŋaŋ egegat tuŋguwidan ke patak zemti ilinsakwep mebien. ");
INSERT INTO naf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ke sokbemidame egelaŋ an ke ekbun yaŋgulak egelaŋ am ke Zisas ke ku eknâmâtâbun. ");
INSERT INTO naf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Âpme Zisasiyaŋ idayaŋkwesimti zeye, “It pe kwilekiyet set teepmaŋ pi zenâ zenâ tapmkolup?” Egaŋ kegok idayaŋkwesime egelaŋ teŋ kindiŋ pemtati zimoselidan kembeŋ sakam ekbun. ");
INSERT INTO naf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Egetmagengatnaŋ an ŋen kwitnaŋ Kelopas egaŋ Zisas yaŋkwesiye, “Notn, geŋ kwitnaŋ kwitnaŋ Zelusalem mka temanen âgânen ma tugenen da sokbeye ke geŋ ku nâmâtâdik?” ");
INSERT INTO naf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kegok zeme Zisasiyaŋ zeye, “Pe kwilekiyet tazenik?” Zeme Kelopasiyaŋ zeye, “Nit kwitnaŋ kwitnaŋ Zisas Nasalet mkaengatnaŋ ekmagen sokbeyan keyet tazelup. An ke golaŋ zenze an dolakŋaŋ penaŋ. Kawawaŋaŋ ma amnaŋ egat dolakŋaŋ nâmpewien enenogat egaŋ menok temaŋ sepem igak igak mge ma zetnaŋ windeŋaŋmak zemkawaŋ beye. ");
INSERT INTO naf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kegok tapmkwapme ningalen sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋgalen an damuŋ ekŋenaŋ Loma gapmangat belinan beme gakikiyet zemdelaŋ zempeme tewen gwilimaŋ kumasasokpeme gakiyan. ");
INSERT INTO naf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nin otnâwenen an ke Kawawaŋaŋ Islael am maŋge indamukulem mimiyelen koge ke nâwenn! Âpme kwitnaŋ kwitnaŋ sokbeyanen keyetnaŋ kwati alak kasup mulup mimi tuk tatnuwen kapiyegak kwitnaŋ mamanamaŋ ŋen kegogak sokbep. ");
INSERT INTO naf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ningalen maŋgeengatnaŋ imbi notnaŋaŋ ekŋenaŋ zet alakŋaŋ dindoyo, ‘Ekŋenaŋ msat balaŋ zem topme topme sumen melo ");
INSERT INTO naf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yaŋgut Zisas egat sekŋaŋ ku ego.’ Kegok sokbeme ekŋenaŋ gilik zem koti zeyo, ‘Nin ensel ekmann enselaŋ kapigok dindop, “Zisas ek alik tazin,” kegok zep.’ ");
INSERT INTO naf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Imbi ekŋenaŋ kegok kozeme ningalen maŋgeen an notnaŋaŋ sumen ke melo ya imbi ekŋenaŋ zeyoyen kataŋ ekmâtâti Zisas ŋen ku ekti mkaen gilik zem kolo.” ");
INSERT INTO naf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kegok zemalut Zisasiyaŋ diidoye, “It ŋoktikŋitpiŋ, in golaŋ zenze an ekŋenaŋ zet zewien ke in sewak sewak penaŋ manâmkiŋpeip! ");
INSERT INTO naf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","In kapigok nânâyelen Kilais an Kawawaŋaŋ ikŋaŋ ombempepeŋaŋ ek sindem timti gakimti set katnaŋ keyaŋ mme kululuŋen meti Amobotnaŋ kwabe.” ");
INSERT INTO naf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Zisas egaŋ Kawawaŋgalen Zet Itnaŋanen Mosesiyelen papiaen yaŋbemti ma golaŋ zenze an ekŋenaŋ ikŋaŋgat meluwaŋ mbien keyet zemkawaŋ bemideye. ");
INSERT INTO naf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ekŋenaŋ ke takotneti mka kosâgât nâwienen ke pataŋ zemti Zisasiyaŋ ewe mebegalen nok mge ");
INSERT INTO naf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","yaŋgut egelaŋ zemkulumpemti zewun, “Kopmane nigalen mkaen metne enenogat kasuplak towepme tambumbuyaŋ pesak pesâpm.” Kegok zemalut Zisasiyaŋ eget idamâti egetgalen mkaen meti tabien. ");
INSERT INTO naf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ke tati meu nini munduman egetmak totati Zisasiyaŋ nupmamaŋ mtati Kawawaŋgat wisikŋ zemti meselemti eget idame ");
INSERT INTO naf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","egelaŋ kwitnaŋ kwitnaŋ egetmak takoti mkawaŋ beye ke nâmkawaŋ bemti Zisas ikŋaŋ ekmâtâbun yaŋgut ke sokbemidamti keyegak galaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kegok sokbeme egelaŋ ilidak zenâ zenâ mti zewun, “Notn, selen daenen egaŋ nigat zet zapat tazemap ma Kawawaŋgalen zet zapat itnaŋaŋ tazemkawaŋ bemndemap kan keyet nigat keŋŋdan tip busat penaŋ nâlut.” ");
INSERT INTO naf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kegok zemti keyegak wawadak Zelusalem mka temanen gilik zemebun. Ke meti Zisasiyet nembaŋane 11 ekŋenaŋ notnaŋ ekŋenmak mka keŋan ondek tapmambien ke met pataŋ zewun. ");
INSERT INTO naf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ke metapmalut ekŋenaŋ egetgat kapigok diidowien, “Amobotnaŋaŋ gakikiengatnaŋ wazan ke penaŋ. Ke Saimonmagen sokbemsayan!” ");
INSERT INTO naf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ekŋenaŋ kegok zeme egelaŋ kwitnaŋ kwitnaŋ sambe selen sokbeye keyet zemkawaŋ bewun ma nupmamaŋ meseleme Zisas eknâmâtâbun keyet zezapat mimindawien. ");
INSERT INTO naf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Egelaŋ ewe kegok tusumti tazemalut Zisas ikŋaŋ ekŋengat tuŋguwinan keyegak sokbemindamti kapigok diindoye, “Keŋ sewakŋaŋ inmak taindain.” ");
INSERT INTO naf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ke sokbemindame ekŋenaŋ, “We eknup,” zemti kiŋgagalaŋ omba penaŋ indatiye. ");
INSERT INTO naf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ekŋenaŋ kegok mme egaŋ diindoye, “In nâgât zemkandadapiŋ ma in neŋ gakikiengatnaŋ wapman keyet keŋ zut mimipiŋ! ");
INSERT INTO naf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","In nâgât setn betn gwilim zembeŋaŋ pi egit. Neŋ nenn kapimak. In nâgât sekŋ timekti nâit. We ekŋen sesumbaŋin ma kanziŋinpiŋ. Neŋ sakam we nemboŋ yek. Neŋ sesumbann ma kanziŋmak talap ke in egit.” ");
INSERT INTO naf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Egaŋ kegok zemti setnaŋ betnaŋ gwilim zembeŋaŋ zikat indeme ");
INSERT INTO naf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","nâmtemtem penaŋ mti keŋin oloŋenaŋ pesak peye yaŋgut egaŋ ekŋenmagen koti tage keyet ku nâmkiŋpewien keyepm egaŋ indayaŋkwesiye, “In meu notnaŋ kapi taindain ma yek?” ");
INSERT INTO naf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kegok zeme ekŋenaŋ aŋgala zinziŋaŋ butnaŋ msame ");
INSERT INTO naf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ekŋengat zikalinan ke niŋge. ");
INSERT INTO naf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Egaŋ ke nim delaŋ zemti ekŋengat zeye, “Kan neŋ inmak takwabanen neŋ ingat zezapat kapi diindowan: Mosesiyelen papiaen ma golaŋ zenze an kwep kwep ekŋengalen papiaen ma Sam papiaen nâgât meluwaŋ kwitnaŋ kwitnaŋ mbien ke penaŋ sokbein.” ");
INSERT INTO naf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ke zemti ekŋengat ŋoktikŋin mkawaŋ beme zet zapat keyet yaŋaŋ nâmâtâbien. ");
INSERT INTO naf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kegok mti ekŋengat diindoye, “Zet zapat kapiyaŋ nâgât Kawawaŋgalen Zet Itnaŋanen zenzeŋaŋ: An Kilais, Kawawaŋ ikŋaŋ ombempepeŋaŋ ek sindem timti kume gakime kasup mulup mimi tuk keyet gakikiengatnaŋ wabe. ");
INSERT INTO naf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma nâgât kwitnnanen zet ke amnaŋ mkawaŋ beme amnaŋ nâmti yomengatnan keŋin gilik zenzeyelen ma an Kawawaŋ ikŋaŋ ombempepeŋaŋ egaŋ amgalen yomin ke katikpepeyelen Zelusalem ammagengatnaŋ yaŋbem am sambe msat kataŋ ekŋenmagen sepem kegok sokbewe. ");
INSERT INTO naf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ma in golaŋ zenze an ekŋenaŋ zet zewien ke penaŋ sokbeme in kwitnaŋ kwitnaŋ sambe ke eknâmmbien. ");
INSERT INTO naf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Âpme nenn Bienaŋ Emetak Teŋ indandayelen zetik mimindeye ke indawap. Yaŋgut in Zelusalem mka temanen kapiyegak tapme Kawawaŋgalen Emetak Teŋaŋ winde indawe.” ");
INSERT INTO naf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kegok zemti Zisasiyaŋ nembaŋane indatimti mka temaŋ katipemti zupman toti Betani mka ŋande isikŋaŋ ke meti ondekindemti betnaŋ ilizuzut mwati zet ŋande kapigok zeye, “Keŋ sewakŋaŋ ma Kawawaŋgalen winde inmagen taindawe.” ");
INSERT INTO naf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Egaŋ zet ŋande kegok tazeme zeme keyegak ekŋen katim indemti Kawawaŋaŋ kululuŋen wapmoge. ");
INSERT INTO naf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kegok sokbeme egat zemsesewati oloŋen palen Zelusalem gilik zem mebien. ");
INSERT INTO naf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Âpme ekŋenaŋ Zelusalem ketati mse kataŋ Kawawaŋgalen sesewat mka temaŋ keŋan Kawawaŋgat manzemsesewatemien. ");
INSERT INTO naf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Eweŋan baen Zet egaŋ yaŋbemti Kawawaŋmak ilisakwep mamkwabunaŋ Zet ke Kawawaŋegak. ");
INSERT INTO naf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ke tipman baen Kawawaŋmak ilisakwep mamti ");
INSERT INTO naf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kawawaŋaŋ zempeme kwitnaŋ kwitnaŋ sambe bepi mme sokbemâge. Ek piŋan kwitnaŋ kwitnaŋ igak ŋen ku sokbemâge yek. ");
INSERT INTO naf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Zet ek mama keyet toŋaŋ egalen busatnaŋaŋ am mbusatnaŋ bemindeye. ");
INSERT INTO naf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Âpme busatnaŋaŋ tambu sosok keŋan mepme tambu sosogaŋ kunzuŋti mege. ");
INSERT INTO naf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Âpme an ŋen kwitnaŋ Zân. Ek msalen kapi am busatnaŋgat zapatnaŋ diindome am ilindiŋ busatnaŋ toŋaŋ Zisas egat zapatnaŋ nâmti nâmkiŋpepeyet nâmti Kawawaŋaŋ ikŋaŋ zempeme koge. ");
INSERT INTO naf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wa Zân ikŋaŋ am mbusatnaŋ bemindendeyet ku koge. Egaŋ belak an busatnaŋ toŋaŋ tobe keyet buŋam zapatnaŋ etaŋ manzemtan. ");
INSERT INTO naf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","An busatnaŋ toŋaŋ keyaŋ msalen kapi sokbemkawaŋ bemti am msalen mammbusatnaŋ bemindein. ");
INSERT INTO naf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ek ke eweŋan Bipmaŋmak mambunen msat kapi mme sokbeye. Ya egaŋ naman mamkwati msalen kapi amnaŋ masokbenupnok sepem sokbemeŋgut am msalengatnaŋ ekŋenaŋ naman egat yaŋaŋ penaŋ ku weyaŋ eknâmâtâbien. ");
INSERT INTO naf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Egaŋ Zuda msalen ke mame Zuda am ma ikŋaŋgat donnotnane ma eiŋbipmane mee penaŋ piyaŋ ek mtopemti wisat mpewien. ");
INSERT INTO naf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Âpme am ek notn mpemti nâmkiŋpewien ekŋen Kawawaŋgat nemunambaŋane bemti mamayet indapmukulem mimindeye. ");
INSERT INTO naf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wa animbi Kawawaŋgat nemunambaŋane penaŋ bemti mamaip ke animbiyaŋ mame nemba masokbeip sepem keboŋ yek. Ma angalen segat tikŋaŋaŋ ndabeme mamaip keyet penaŋaŋ yek. Kawawaŋaŋ ekŋenaŋ ikŋaŋgat nemunambaŋane bembeyet nâmindeme kogok ekŋenmagen sokbeye. ");
INSERT INTO naf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Âpme Zet egaŋ amnaŋ masokbenup keyet kataŋ sokbemti am ningat tuŋgupmnan kapi mamtan. Mamti keŋ taoletmak ma zetnaŋ penaŋ penaŋak zem mamti menok sepem igak igak mme amnaŋ Kawawaŋgat Nemuŋaŋ kwep etaŋ keyet mama mimiŋaŋ dolakŋaŋ ke ma windeŋaŋ temaŋ ke Bipmaŋaŋ miak peme koge ke ekbenn. ");
INSERT INTO naf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zânaŋ egat zetnaŋ pigok zemkawaŋ beye, “Neŋ an ikŋaŋ keyet buŋam zapatnaŋ diindowan, ‘An bamnan takozin egaŋ neŋ sebemnemti Amobotnaŋ penaŋ bein. Msat kululuŋ ma neŋ mee pi sokbembepiŋ tapma egaŋ tipman penaŋ baen mamkwage.’” ");
INSERT INTO naf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Egaŋ ningat tikŋaŋ manâmndein keyepmti keŋ taoletnaŋgat penaŋaŋ ikŋaŋgalen mama mimi dolak dolakŋaŋ sambe piyaŋ elimiak ndeye. ");
INSERT INTO naf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses egaŋ Kawawaŋgalen zii zet ke aikndaye. Âpme Zisas Kilaisiyaŋgut keŋ taoletmak Zet Zapat Dolakŋaŋ penaŋ timtot ndaye. ");
INSERT INTO naf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","An ŋenaŋ Kawawaŋ sepemaŋ bugan ku ege. Nemuŋaŋ neŋ Bipmmak mamayap neŋ egalen zet zapatnaŋ ke mkoti zemkawaŋ bemindama nâmbien. ");
INSERT INTO naf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Zuda amobotnaŋ ekŋenaŋ Zelusalem mkaen tati sâpe sâpe bumbu an ekŋengat kandaŋinaŋ mulup an mamaip ekŋen zemindeme Zânmagen meti pigok yaŋkwesiwien, “Geŋ pe Kilais ma an kwi? Ze zemane nâne.” ");
INSERT INTO naf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Zeme egaŋ keyegak ikŋaŋgat yaŋaŋaŋ pigok penaŋ zemkawaŋ bemti diindoye, “Neŋ wa Kilais yek.” ");
INSERT INTO naf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Zeme ekŋenaŋ naman ewe pigok yaŋkwesiwien, “Âpme geŋ an kwi? Geŋ Ilaiza?” Zeme egaŋ pigok zeye, “Neŋ ek yek.” Zeme ekŋenaŋ zewien, “Âpme geŋ nin golaŋ zenze an temaŋ ŋen ninmagen kokogat damuŋ matatnuwen geŋ kapi?” Zeme egaŋ pigok zeye, “Neŋ golaŋ zenze an ke yek.” ");
INSERT INTO naf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Zeme ekŋenaŋ pigok zewien, “Geŋ kwi penaŋ? Ze weyaŋ yaŋaŋdi zemane nâne. Am zemndeme kotn am ekŋen keyet pe zigok met zeman nâseip? Geŋ gitaŋgat penaŋ yaŋdi zigok penaŋ manzenik?” ");
INSERT INTO naf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Zeme Zânaŋ pigok diindoye, “Neŋ golaŋ zenze an Aizaya egaŋ zet pigok zeye keyet penaŋaŋ, ‘An ŋenaŋ msat tuŋgupman mamti animbiyet pigok takuin, “Pi mamti amnaŋ yomin zeme delaŋ zeme keŋin weyaŋti Amobotnaŋgat damuŋ talit,” mandiindoin!’” ");
INSERT INTO naf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Âpme an ekŋen Palisi ekŋenaŋ zemindeme kobienan ");
INSERT INTO naf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","naman pigok yaŋkwesiwien, “Nin tatnâmann geŋ, ‘Neŋ Kilais yek ma Ilaiza yek ma golaŋ zenze an ŋen yek,’ zenik. Kegok beme geŋ kwilekiyet am tu manzulutindenik?” ");
INSERT INTO naf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zeme Zânaŋ kapigok diindoye, “Neŋ am tu etaŋ manzulutindeyap. Âpme an ingat tuŋguwinan sokbeyeyaŋ mamain ek ke in ku maekmâtâlip. ");
INSERT INTO naf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","An keyaŋ bamnan gwaen takozin. An bekeboŋ beke neŋ bukaboŋ kapiyaŋ elewat temaŋ timpema ŋep ku bewe.” ");
INSERT INTO naf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ekŋenaŋ meyaŋkwesiwienen ke Betani mka Zodan tu nembet daeset tazinen ke mebien. Zânaŋ mka ke mamti am Zodan tuyen tu manzulutindemtan. ");
INSERT INTO naf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Msat msame Zânaŋ am tu zulutindemambe tati ekme Zisasiyaŋ ninmagen takopme ekti ningat pigok dindoye, “An inde takozingat egit. An kainde Kawawaŋgalen Sipsip Nembaŋaŋ. Zuda am ekŋenaŋ yomin delaŋ zenzeyet nâmti Sipsip Kawawaŋgat sâpe sâpe mambuip. Sepem kegogak Kawawaŋaŋ ikŋaŋgat Nemuŋaŋ takozin ke amgat belen beme msat sambe am ningat yom delaŋ zenzeyet kume gakiwe. ");
INSERT INTO naf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Neŋ an keyet ilak eweŋan pigok diindowan, ‘An bamnan takozin ke Amobotnaŋ temaŋ neŋ ewe sokbembepiŋ tapma egaŋ eweŋan tipman penaŋ baen mamkwage.’ ");
INSERT INTO naf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ek eweŋan Kawawaŋaŋ an yomengatnaŋ gilik zemndadagat ombempeye ke neŋ ku ekmâtâban yaŋgut Kawawaŋaŋ zet zapatnaŋ etaŋ zemkawaŋ bemname neŋ Islael am in ondekindemti egat zapatnaŋ diindoma nâmti in egaŋ kokogat weyeyaŋ mulup mti mamayet nâmti inmagen tu zululut mulup kapi mimiyet zemneme inmagen yaŋbewan.” ");
INSERT INTO naf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kogogapm Kawawaŋaŋ pigok dinoŋge, “Neŋ Emetak Teŋaŋ kululuŋengatnan age sasakandenombe nemboŋ bemti ekmagen totapme ekbanik beme an ilak ke. ");
INSERT INTO naf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nen an ke eweŋan ku nâmâtâtpewan yaŋgut Kawawaŋaŋ neŋ am tu zulutindendeyet mulup zet kapi naŋgeyaŋ pigok dinoye, ‘Nâlen Emetak Teŋaŋ toti dukŋanen tapme ekbanik beme an keyaŋ am nâlen Emetak Teŋ ke indamâbe.’ ");
INSERT INTO naf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Neŋ yaŋaŋ kegok zemâtâtname ekbangapmti muluwaŋ kegok sokbeme ekti ek ilak Kawawaŋgat Nemuŋaŋ penaŋ elak nâmâtâpewan.” ");
INSERT INTO naf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Msat msame Zânaŋ nembaŋanet zut nit ndatimti msat keyegak koti tapmambenn. ");
INSERT INTO naf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tatnepemann Zisasiyaŋ keyegak kwawepme ekti Zânaŋ nigat pigok dinitdoye, “An zut, an da egit. Ek Kawawaŋgalen Sipsip Nembaŋaŋ.” ");
INSERT INTO naf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Zeme nemba zut piwan nânâŋak keyegak Zân pemti met Zisasiyet baman mâti mebun. ");
INSERT INTO naf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mepmalu Zisasiyaŋ gilik zem idikti pigok idayaŋkwesiye, “An zut, it kwilekiyet napmâti takolup?” Ndayaŋkwesime nit pigok zewelin, “Labai, (E Ibulu zet âpme ningalen zeleset ‘an zikat indanda,’ kok zewanek.) geŋ mka pe deset mawenik.” ");
INSERT INTO naf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yaŋkwesimalu pigok dinitdoye, “It kopmalu neŋ met mkan zikat idama egit.” Zemti idati tapmetnepeme msat gasim beme ekmak ke tapmetneti tambu sutnan gilik zemti naman mkaŋidanen kobun. ");
INSERT INTO naf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","An zut Zânaŋ Zisasiyet yaŋaŋ zeme nâmti ekmagen mebun nitmagengatnaŋ nemba ŋen kwitnaŋ Endulu ek Saimon Pitayet datnaŋ. ");
INSERT INTO naf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Enduluyaŋ metneti meniŋaŋ Saimon aikti pigok dunduye, “Neŋ Mesaya, kwitnaŋ ŋen Kilais manzeip ek ilak aiga.” ");
INSERT INTO naf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kegok zemti meniŋaŋ Zisasmagen wati mepmalu Zisasiyaŋ ekti zeye, “Geŋ Saimon Zângat nemuŋaŋ muŋ. Gâgât kwidi alakŋaŋ neŋ Sipas gayap.” (Sipas kwit keyet yaŋaŋ “nanzaŋ”.) ");
INSERT INTO naf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Msat msame Zisasiyaŋ Galili msalen mesât tati Pilip selen aikti pigok dunduye, “Geŋ kopmane neŋmak medi.” Zemti wati mebun. ");
INSERT INTO naf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Âpme Pilipmak Endulu muŋanet ekŋen mkaŋin kwep Besaidayetnaŋ. ");
INSERT INTO naf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Metneti Piliwan Nataniel meaikti pigok dunduye, “Mosesimak golaŋ zenze an notnaŋaŋ itnaŋaŋ baenen an kapi Kawawaŋaŋ nin yomengatnaŋ gilik zem ndadagat ombempeye keyet zetnaŋ meluwaŋ mbien ewan penaŋaŋ alak aikti ekmak tapmanup. An ke Zisas Zosepgat nemuŋaŋ Nasalet mkaengatnaŋ.” ");
INSERT INTO naf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Zeme Natanieliyaŋ zet dopmaŋ kapigok gilik zemti saye, “Geŋ nâmane Nasalet mkaen bukanda kwileki dolakŋaŋ ŋen sokbewe bein?” Zeme Piliwaŋ zeye, “Kok zenikgat kopmane met zikat gama ekbak.” ");
INSERT INTO naf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Zemti Nataniel wati Zisasmagen mepme Zisasiyaŋ Nataniel ekti zeye, “An kapi Islael an penaŋ. Ek zet dâsuki ŋen ku manzein.” ");
INSERT INTO naf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Zeme Natanielaŋ zeye, “Zisas, neŋ pe de mama yaŋŋ nikbanangapmti kegok zenik?” Zeme Zisasiyaŋ zeye, “Piliwaŋ geŋ ewe met gaiikpiŋ tapme geŋ tep kwitnaŋ pik kandaŋan ke tapmane giga.” ");
INSERT INTO naf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Zeme nâmti egaŋ Zisas pigok dunduye, “An zikat indanda, geŋ penaŋ sukwep Kawawaŋgat Nemuŋaŋ penaŋ Islael am ningalen Amobotnaŋ Temaŋ.” ");
INSERT INTO naf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zeme Zisasiyaŋ pigok zeye, “Neŋ geŋ tep pik kandaŋan tapmane giga zeya keyepmti nâgât nâmkiŋpemnenik? Nânik, pi ewe belak yaŋbemti butnaŋ isikŋaŋ bugan ekdik. Âpme penaŋ penaŋ ewe bam sokbeme mamti ekmebanik!” ");
INSERT INTO naf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kegok dundumti naman nembaŋane ilinsakwep pigok diindoye, “Neŋ zet penaŋ ŋen pigok diindoma nâit, bamgat in taekme kululuŋ gwaenen ŋandem tapme Kawawaŋgalen ensel ekŋenaŋ Angat Nemuŋaŋ neŋmagen motopme ekbep.” ");
INSERT INTO naf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Ke mti manepeme kasup zut bemelak Galili msalen mka ŋen kwitnaŋ Kana manzeip ke animbi zut ŋen awembiŋ bemidesâgâti tu meu mee akume kopme bumti Zisas mamaŋ ma Zisas ikŋaŋ ma nembaŋane nin nsakwep ndamandame tu meu nsâgât meti ");
INSERT INTO naf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","meu tatnepemann meuyaŋ ewe tapme wain tu ilak delaŋ zeme Zisas mamaŋaŋ ekti pigok zeye, “Wae, ekŋen pi ilak wain tu delaŋ zeme belak talipgat nâmbega.” ");
INSERT INTO naf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Zeme Zisasiyaŋ mamaŋgat pigok zeye, “Maŋge, wa mulup kapi nin tapminup yek. Nâlen mulup miminn kann ewe bam sokbemnawe.” ");
INSERT INTO naf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Zeme mamaŋaŋ mulup nemba ekŋenmagen meti pigok zeye, “In tatnepeme Zisasiyaŋ kwileki ŋen mimiyet diindome zetnaŋ gawepumti mseip.” ");
INSERT INTO naf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Âpme mka keyet ganzenan menzim tosiŋ temaŋ temaŋ 7 bekapi onzemindeme matatemien. Menzim tosiŋ temaŋ kwep bekeyet tu 100 lita mee kegok makasimpemtemien. Kasimpeme tapme sesewat mkayelen amobotnaŋaŋ set bemindaye keyet kataŋ mâti kasup kataŋ selin belin manzulutemien. Menzim tosiŋ bekeboŋ sambe mka kataŋ mawemetan. ");
INSERT INTO naf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kegogapm Zisasiyaŋ mulup an ekŋen pigok diindoye, “In tu omti menzim tosiŋ temaŋ taliwen kapi kasime towepmâlak.” Zeme mulup an ekŋenaŋ menzim tosiŋ temaŋ 7 pi tu omti kasime gak zemâge. ");
INSERT INTO naf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Omkasime delaŋ zeme pigok diindoye, “In tu butnaŋ menzim isikŋaŋ kasimtimti met an meu damuŋ ke sait.” ");
INSERT INTO naf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Zeme omti mmepme tuyaŋ wain beme an meu damuŋ keyaŋ wain tu ke nim ekti kapi pe desetgatnaŋ mkolip ke ku weyaŋ nâmâtâti mulup nemba ekŋenaŋ Zisasiyaŋ zeme tu penaŋ omti mebien. Kegogapm ekŋenaŋ wain tu zigoset sokbep eyet yaŋaŋ ŋep nâmâtâbien. Kegok mme an meu damuŋ keyaŋ animbiŋaŋmak bet butewun ke zeme kopme pigok dunduye, “Ningalen set temaŋ kapigok tazin, wain tu dolakŋaŋ penaŋ ke am ŋeŋaŋ indame nimti tapmeŋgut naman bam bekanaŋnik ke maindame nip. Yaŋgut geŋ kileŋ mnak wain pembenaŋ pi belak pemane tapme bekanaŋnik ŋeŋaŋ indamane niyo. Geŋ set dâsuki mti wain tikŋaŋ kapi aŋgalaŋ pemane tapmawaŋ bam mti kolip.” ");
INSERT INTO naf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Zisasiyaŋ mka keyet yaŋbemti menok ke mti Amobotnaŋ main keyet yaŋaŋ am ekŋenmagen mkawaŋ beme nembaŋane nin windeŋaŋgat yaŋaŋ ekti nâmkiŋpewenn. ");
INSERT INTO naf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Keyetnan Zisasmak mamnotnane ma nembaŋane nin nsakwep Kapaneam mkaen ke tambu msasa isikŋaŋ bugan topmambenn. ");
INSERT INTO naf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Topmanepemann Zuda ningalen Aŋgalalaŋ Kendo elak bududuk beye keyepmti Zisasiyaŋ Zelusalem mka teman Kendo ke eksâgât mowebenn. ");
INSERT INTO naf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Moti ekme sesewat mka temaŋgat tambaŋgumen amnaŋ kwaweti Kawawaŋgat sâpe sâpe bumbuyet makau ma sipsip ma sasakandanombe mee pi time kwawepme omkwiti kwiti mti mânep sisak dukŋan bemti omaiŋ maiŋ tapmmambien. ");
INSERT INTO naf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tapmme Zisasiyaŋ indikti ŋeŋaŋ penaŋ zime egaŋ tek timti mendeŋme katikŋaŋ beme mtati makau ma sipsip mee pi wuwap indawitikti indamâpme kuŋkunzuŋ kwawepmâpme mânewin timtati time mekopme sisakŋin mtati gilik zempeme weŋge. ");
INSERT INTO naf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Âpme am sasakandenombe mtabien ekŋen indikti memendep mimindamti pigok diindoye, “In sasakandenombeŋin timti toti melit. In Biengalen mka kapi mme ingalen bemkwiti kwiti mkanok ku bek.” ");
INSERT INTO naf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Zisasiyaŋ moti kegok mme nembaŋane nin Kawawaŋgalen zet zapat itnaŋanen meluwaŋ pigok mimiŋaŋ tazin keyet otnâmbenn, “Gâlen sesewat mkayepm ŋeŋŋ penaŋ zimetip.” ");
INSERT INTO naf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Âpme Zuda amobotnaŋ ekŋenaŋ Zisasmagen koti pigok yaŋkwesiwien, “Geŋ kapigok penaŋ tapminikgat pe Kawawaŋaŋ winde game egalen windeen maminik beme geŋ menok ŋen mmane nin ekti yaŋaŋdi ekmâtâsenup?” ");
INSERT INTO naf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yaŋkwesime egaŋ keyegak pigok zeye, “In sesewat mka temaŋ kapi asekyaloŋme neŋ naman kasup tuk keyet keŋan etaŋ timtusu tusu mti walapma delaŋ zemâbe.” ");
INSERT INTO naf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Zeme ekŋenaŋ Zisasiyet pigok zewien, “Yeŋsokŋne ekŋenaŋ nup kan 46 bepi sesewat mka temaŋ kapi tawalatne walatne peme delaŋ zeye. Âpme geŋ bukapiyaŋ kasup tugat keŋan etaŋ walasât zenik?” ");
INSERT INTO naf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yaŋgut Zisasiyaŋ zet ke wa sesewat mka temaŋ keyet penaŋ nâmti ku zeye egaŋ ikŋaŋgat sekŋaŋgat nâmti zeye. ");
INSERT INTO naf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yaŋ maneti Zisasiyaŋ gakiyeyaŋ gilik zem wapme kan keyet nembaŋane nin sesewat mka temaŋ asekti walalagat zeye keyet ma Kawawaŋgalen zet zapat itnaŋanen muluwaŋ mimiŋaŋ keyet penaŋaŋ ekmagen sokbeme ekti nâmkiŋpewenn. ");
INSERT INTO naf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Zisasiyaŋ Zelusalem mka teman Aŋgalalaŋ Kendoen mamti menok temaŋ sepemaŋ igak igak mme am sambe ekŋenaŋ ke ekti Zisasiyet nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yaŋgut Zisasiyaŋ am sambe ekŋen bekapi notnaŋaŋ keŋinan ŋenzinziŋaŋ tage e indik mâtâti ekŋen sambe keyet nâme notnaŋne etaŋ ku beye. ");
INSERT INTO naf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Egaŋ am ŋeniyet yaŋaŋ nâsâti am ŋen yaŋkwesime ku dundume nâŋge. Egaŋ ikŋaŋ am keŋin baen ekti yaŋaŋin eknâmâtâge. ");
INSERT INTO naf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Palisi an ekŋenmagengatnaŋ an ŋen kwitnaŋ Nikodimas. An beke Zuda am ekŋengalen sesewat mka temaŋgalen an damuŋ temaŋ ŋen ek ke. ");
INSERT INTO naf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","An keyaŋ buzak tambuyet Zisasmagen moti pigok dunduye, “An zikat indanda, nin gâgât yaŋaŋdi nânup. Geŋ an zikat indanda penaŋ Kawawaŋmagengatnan kwatobanan. Âpme geŋ menok sepem igak igak maminik keboŋ kapi an ŋen Kawawaŋpiŋ mamti mulup keboŋ keboŋ ke ŋep ku mnak.” ");
INSERT INTO naf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Âpme Zisasiyaŋ zeye, “Neŋ penaŋ sukwep pigok zema nâmbak: An ŋenaŋ nemba okak masokbeip keyet kataŋ okak ku sokbewe beme an keyaŋ Kawawaŋmak tusumti egalen zemâtâtâtgat katnaŋen mama keŋan ke ku mebe.” ");
INSERT INTO naf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Zeme Nikodimasiyaŋ pigok zeye, “Weneŋe, an temaŋ penaŋ bekeyaŋ naman zigoset mamaŋgat keŋan toweti naman nemba okak sokbewe?” ");
INSERT INTO naf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Zeme Zisasiyaŋ naman pigok dunduye, “Neŋ zet penaŋ sukwep pigok zema nâmbak: An ŋenaŋ tuyaŋ ma Emetak Teŋmagengatnaŋ mama alakŋaŋ ke ku tiwe beme an keyaŋ Kawawaŋgalen zemâtâtât katnanen mama keŋan ŋep ku mebe. ");
INSERT INTO naf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Amgalen mamaen masokbep ekŋen amgat sepem. Âpme Emetak Teŋaŋ ammagen mulup mme mama teŋ matip ekŋen Kawawaŋgat zapat mambeip. Ekŋen ke Emetak Teŋgalen am penaŋ. ");
INSERT INTO naf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Geŋ neŋ sokbembe alakŋaŋ sokbembe,’ keyet zema geŋ nâmane nukŋaŋ penaŋ kumbek. ");
INSERT INTO naf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tâgâ ek belak kileŋ ke kumbume kwisakŋaŋ etaŋ kume manânup. Âpme geŋ pe deset yaŋbemti met deeset mamezin e ku manânik. Âpme Emetak Teŋaŋ am ŋenmagen mulup mme mama teŋ matin ekmagen Emetak Teŋaŋ tâgâyaŋ mulup maminok mamin.” ");
INSERT INTO naf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Zeme Nikodimasiyaŋ nâmti zet dopmaŋ kapigok gilik zem saye, “Pe zigok penaŋ mti alakŋaŋ sokbembeyelen nâmti zet kapi tazenik?” ");
INSERT INTO naf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Zeme Zisasiyaŋ Nikodimas pigok dunduye, “Geŋ Islael am ekŋengalen an zikat indanda temaŋaŋ zet kapi zema geŋ kwilekiyet nâmane nukŋaŋ taben? ");
INSERT INTO naf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Neŋ penaŋ pigok diŋgoma nâmbak: Neŋ kwitnaŋ kwitnaŋ sambe Kawawaŋaŋ zemâtâtname nâmban keyet zapatnaŋ ma Kawawaŋaŋ ammagen mulupmaŋ kawaŋan sosok mamme egap keyet zapatnaŋ diindoma in sambeyaŋ ningalen zet ke nâme ewe pepesut beme ku manâmkiŋpeip. ");
INSERT INTO naf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Neŋ kwitnaŋ kwitnaŋ msalen sosok masokbemâpme egip kapiyet palen bemzema in ku manâmkiŋpeip. Âpme neŋ kwitnaŋ kwitnaŋ kululuŋen gwaen masokbemezin keyet palen bemzema in zigok ŋep nâwiek? ");
INSERT INTO naf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","An ŋenaŋ kululuŋen gwaen moti kwitnaŋ kwitnaŋ tazin ke ku ege. Angat Nemuŋaŋ neŋ kululuŋengatnan toban keyepmti kululuŋen gwaen kwitnaŋ kwitnaŋ wein e nâmâtâpma delaŋ zemâzin. ");
INSERT INTO naf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Itnaŋaŋ Moses egaŋ msat tuŋgupman nombe weŋaŋ aenaŋ weyaŋti tep palen kwasim pemti mwat onzempeme tapme ekbien. Sepem kegogak Angat Nemuŋaŋ neŋ ke tep palen palak palak masasok neme wema nomti mwat onzemneme tapma ekbep. ");
INSERT INTO naf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Amnaŋ neŋ nikti nâmkiŋnemti mama kanzizit aiikgat kegok mbep. ");
INSERT INTO naf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kawawaŋ egaŋ msalen am sambe ingat gogot penaŋ mamimindein keyepmti egaŋ ikŋaŋgat Nemuŋaŋ kwep penaŋ ke ketalasimti msalen peme toge. Keyepmti am neŋ nâmkiŋnewep ekŋenaŋ walelepiŋ; mama kanzizit tiwep. ");
INSERT INTO naf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kawawaŋaŋ Nemuŋaŋ neŋ msalen neme toban ke wa am yominaŋgat dopmaŋ indandayet nâmti ku neme toban. Neŋ am yomengatnan gilik zemti indatitiyet Bipmnaŋ zemneme toban. ");
INSERT INTO naf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","An ŋenaŋ Kawawaŋgat Nemuŋaŋ neŋ manâmkiŋnein beme yomaŋgat dopmaŋ ku tiwe. Âpme an ŋenaŋ Kawawaŋgat Nemuŋaŋ neŋ ku manâmkiŋnein ek yomaŋgat dopmaŋ ilak titiyet damuŋ matazin. Elak egaŋ Kawawaŋgat Nemuŋaŋ neŋ nâmkiŋnenepiŋ mamm keyepmti sepem kegok sokbemsawe. ");
INSERT INTO naf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","E yaŋaŋ kapigogapmti tosa mgasik kapi tiwe. An ekŋenaŋ busatnaŋ msalen kapi sokbeme buŋam zapatnaŋ ekŋenmagen mepme nâmtiŋgut ekŋenaŋ bamkumpemti ekŋenaŋ mama mimi bekanaŋ mti tambusosogat zapat mambeip. ");
INSERT INTO naf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","An ŋenaŋ yom mamin beme egaŋ busatnanen mopma yomm sosok sokbesem zemti busatnaŋgat makiŋgazin. ");
INSERT INTO naf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","An ŋenaŋ Kawawaŋgalen zet nâmti maŋgawepumti main egaŋ busatnaŋgat ku makiŋgazin. Âpme egaŋ busatnanen mopme busatnaŋaŋ mama mimiŋaŋ dolakŋaŋ ke sosok mamkawaŋbein.” ");
INSERT INTO naf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ke maneti Zisasiyaŋ nembaŋane nin ndatime Zelusalem mka pemti Zudia msat butnaset ŋen meti mambenn. Ke met ekŋenmak mamti animbi tu mazulutindemtemenn. ");
INSERT INTO naf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Âpme Zân egaŋ kegogak mka ŋen kwitnaŋ Enon zeme ke Selim msaleset tu sambe penaŋ matatan ke mamti am tu manzulutindemtan. ");
INSERT INTO naf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kan keyet Zân ewe mka katikŋan pepepiŋ tapme egaŋ belak mamti mulup ke mamtan. ");
INSERT INTO naf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Zângalen nembaŋane Zudayetnaŋmak Zuda an ŋenmak tu zululugat ");
INSERT INTO naf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","mdândâmti Zângat nembaŋane ekŋenaŋ Zânmagen meti pigok dunduwien, “An zikat indanda, geŋ an ŋen Zodan tu nembet daeset tapme zikat ndamane ekbenn an keyaŋ alak am tu tazulutindeme am sambe pi ekmagen etaŋ ondek mepmâpme delaŋ zein.” ");
INSERT INTO naf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zeme Zânaŋ nâmti pigok diindoye, “An ŋen Kawawaŋaŋ mulup ŋen zemdelaŋ zem sasapiŋ mme egaŋ mulup belak keŋan galak ku mamin. ");
INSERT INTO naf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Neŋ Kilais yek, neŋ belak Kawawaŋaŋ an keyet zapatnaŋ zenzeyet ŋeŋaŋ zemneme koti zema nâmbien. Âpme in zet ke eneyet sakwep penaŋ kandabien.’ ");
INSERT INTO naf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","An ŋeniyet imbi zapat zempepeŋaŋ an keyaŋ imbi keyet apmaŋ penaŋ. Yaŋ egaŋ imbiŋaŋ kemak bet butemti keŋ oloŋen mme notnane ekŋenaŋ zapatnaŋ nâmti ekmak tusumti ilinsakwep oloŋen mamip. Keŋ oloŋen temaŋ penaŋ keboŋ ke sokbemnanayelen kan elak alak penaŋ kapi sokbemnain. ");
INSERT INTO naf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Zisasiyet kwizet buŋamaŋaŋ palakŋaŋ beme kopme nâlenaŋ naman uluk zemti towebe. ");
INSERT INTO naf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","An ŋen msalen kapiyetnaŋ sokbembeŋaŋ egaŋ kwitnaŋ kwitnaŋ msalen kapiyetnaŋ etaŋ ekti manzein. Âpme an kululuŋen gwaengatnan tototnaŋ ek kwitnaŋ kwitnaŋ sambe kapiyet Amobotnaŋaŋ tazin. ");
INSERT INTO naf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Egaŋ kululuŋen kwitnaŋ kwitnaŋ sambe tazin keyet zapatnaŋ zemeŋgut am ekŋenaŋ nâme dâsuki beme ku nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Âpme an ŋenaŋ zetnaŋ ke nâmti mamkitik pein beme egaŋ Kawawaŋgat yaŋaŋ an zet penaŋ penaŋaŋ zemti main, e nâmâtâpewep. ");
INSERT INTO naf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kawawaŋaŋ an zempeme toge an keyaŋ koti Kawawaŋgat yaŋaŋ manzemkawaŋbein. Keyepmti Kawawaŋgalen Emetak Teŋaŋ winde omba penaŋ same egalen windeen mulup mamin. ");
INSERT INTO naf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bipmaŋaŋ Nemuŋaŋ egomti kwitnaŋ kwitnaŋ sambe bepi egaŋ damuŋ mimiyet betnanen bemâge. ");
INSERT INTO naf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Âpme an ŋenaŋ Kawawaŋgat Nemuŋaŋ ke manâmkiŋpein beme mama kanzizit eweŋan msalen kapiyegak yaŋbemti masokbemsain yaŋgut am ŋenaŋ Kawawaŋgat Nemuŋaŋ egalen zet ke ku gawepuwe beme mama kanzizit ke ku tiwe. Am keboŋ ekŋenmagen Kawawaŋgalen welili eweŋanak msalen kapiyegak masokbemindain.” ");
INSERT INTO naf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Zisasiyet zapatnaŋ Palisi ekŋengat pigok kot zeme nâmbien: Zisasiyaŋ am tu tazulutindein eyaŋ Zânaŋ am tu zulutindeye ekŋen indasebemindeye. ");
INSERT INTO naf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Zisasiyaŋ ikŋaŋ am tu ku zulutindeye nembaŋane nin etaŋ am tu zulutindewenn.) ");
INSERT INTO naf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","5","Amnaŋ Zudia msat pemti Galili msalen mesât Samalia msat tuŋgupmaset beke tapmetne metne Galili msalen mapataŋ zemtemien. Âpme Zisasiyet zet sambe kegok tazeme nâmti egaŋ nin nembaŋane ndatime Zudia msat pemann tapme Galili msalen gilik zemti mesât Samalia msaleset beke tapmetne metne mka ŋande ŋen kwitnaŋ Saika zeme ke pataŋ zewenn. Mka ke Zekowaŋ nemuŋaŋ Zosep msat saye keyet ganzenan matatan. ");
INSERT INTO naf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Msat keyegak Zekowaŋ tu pusak timpeyeyaŋ maomnimtemien. Âpme Zisasiyaŋ set teepmaŋ kotne kotne tinsutnan penaŋ beme sebetnaŋ sukŋaŋ beme tu pusak solonan ke moti totapmaŋge. ");
INSERT INTO naf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ke tot tagom tati nembaŋane nin zemndeme mkaen tu meu kwitim tisât mepmann Zisasiyaŋ igak tu pusagen ke totati ekme Samalia imbi ŋenaŋ tu osâgât menzimaŋ kwindiŋti kot tuyen osât tapmme Zisasiyaŋ ekti pigok yaŋkwesiye, “Geŋ tu bugan bemti namane nimbi.” ");
INSERT INTO naf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kegok yaŋkwesime imbi keyaŋ pigok dunduye, “Islael ammak Samalia am nin zapat zenâ zenâ kwep ku mammnup. Yaŋ geŋ eneyet koti tuyet nâgât tatnayaŋkwesinik?” ");
INSERT INTO naf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Zeme Zisasiyaŋ pigok dunduye, “Kawawaŋaŋ geŋ kwileki ŋen taolet gasât tapm ma neŋ an tuyet tadiŋgoyap nâgât yaŋŋ nânâpiŋ keyepmti tapminik âk nâmti ze nayaŋkwesimane neŋ tu zikatnaŋ kwapeŋ matazin keyetnaŋ gama nimbek.” ");
INSERT INTO naf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Zeme Samalia imbi keyaŋ pigok zeye, “Amobotnaŋ tu kapi pusak beŋan penaŋ baen mambemtimkwatnup. Âpme geŋ tu oo menzimdi ŋen ku tagain ke geŋ tu zikatnaŋmak e deset tazinaŋ omti nasenik? ");
INSERT INTO naf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ningat sokŋ Zekop egaŋ tu pusak temaŋ kapi timpeye. Mti ikŋaŋ ma nemuŋane ma sipsip ma makauŋane ekŋenaŋ tu kwep kapi manimzulutemien. Âpme geŋ Zekop ek sebempemti naman tu dolakŋaŋ penaŋ ŋen zikatnaŋmak makozin ke desetgatnaŋ aikndasâgât tazenik?” ");
INSERT INTO naf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Samalia imbi keyaŋ kegok zeme Zisasiyaŋ kapigok dunduye, “In tu kapi ometnimti ewe tuyet mti mene mene mamekotomnip. ");
INSERT INTO naf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Âpme nâlen tu tazeyap ke am ŋen sama nimbe beme egaŋ tuyet ŋen ewe ku atotoyelen. Neŋ tu sawap ke keŋanen baen tu yeeŋaŋ dolakŋaŋ zikatnaŋmak penaŋ kwati telepgat tati mama aiksame mambe.” ");
INSERT INTO naf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Zeme Samalia imbi keyaŋ pigok dunduye, “Amobotnaŋ, geŋ tu tazenik ke namane nimti tuyet ŋen ewe atotopiŋ mamambap. Mti tuyen pien mene mene mamekolap e alakŋaŋ ŋen ewe ku mekobap.” ");
INSERT INTO naf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kegok zeme Zisasiyaŋ pigok dunduye, “Geŋ meti apdimak wati kolit.” ");
INSERT INTO naf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Zeme imbi keyaŋ zeye, “Neŋ apmpiŋ; belak mamayap.” Zeme Zisasiyaŋ pigok zeye, “Geŋ, ‘Neŋ apmpiŋ,’ e penaŋ zenik. ");
INSERT INTO naf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yaŋgut geŋ an 5 ekŋenmak mamkwati asekindemkwabanan. Ya alak pi ŋen wapmanik ke gitaŋgat apdi penaŋ yek keyepmti geŋ, ‘Apm yek,’ zet e penaŋ zenik.” ");
INSERT INTO naf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Zeme imbi keyaŋ pigok dunduye, “Amobotnaŋŋ alagati neŋ gâgât yaŋaŋdi nâyap. Geŋ Kawawaŋmagen golaŋ zenze an ŋen penaŋ. ");
INSERT INTO naf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Âpme geŋ nânik, ekŋen yeŋsokŋne ekŋenaŋ kalaŋ kapiyet dukŋan motati Kawawaŋgat mandundum samtemien. Âpme Zuda am ingulak Zelusalem mka teman ke tati Kawawaŋgat mandundum saip.” ");
INSERT INTO naf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Zeme Zisasiyaŋ pigok zeye, “Imbi, neŋ pigok zema nâmbak, in kan ke penaŋ sokbeme kalaŋ kapiyet ma Zelusalem mkaen met ondekti Bien ku dundum sawep. ");
INSERT INTO naf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","In keyet yaŋaŋ nânâpiŋ; belak ek masesewatsaip. Âpme Islael am ningut egat yaŋaŋ nâmâtâti maminup. Kawawaŋaŋ Zuda am ningat tuŋgupmnangatnaŋ an ŋen am yomengatnaŋ gilik ze ndatitiyet peme kokogat zenzeŋaŋ ");
INSERT INTO naf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","kan kelak alak kapi sokbem tazin. Âpme egalen am maŋge penaŋ ekŋenaŋ keŋinaŋ penaŋ Emetagalen set esemteŋ penaŋ tazin keyet kataŋ mamti Bien dundum sawep. Bienaŋ am ekŋen keboŋgat nâme dolakŋaŋ mambein. ");
INSERT INTO naf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kawawaŋ ek an enzililiŋaŋ mamain keyepmti amnaŋ ek sesewatsasâgât mbep beme ekŋengalen sesewawalin ke keŋinan baenengatnaŋ kwapme mama mimiŋin esemteŋ penaŋ kemak tati sesewatsawep.” ");
INSERT INTO naf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Zeme imbiyaŋ pigok dunduye, “Mesaya ma kwitnaŋ ŋen Gilik zeleset Kilais makuip egaŋ sokbemti kwitnaŋ kwitnaŋ sambe keyet yaŋaŋ zemkawaŋ bemndandayet zenzeŋaŋ e neŋ nâyap.” ");
INSERT INTO naf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Âpme Zisasiyaŋ pigok dunduye, “An e sokbembeyet zenzeŋaŋ elak neŋ kapi tati zet tadiŋgoyapmak.” ");
INSERT INTO naf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kegok tazeme zemelak nin nembaŋane ilak meu kwitim timti koti ekmann Zisasiyaŋ Samalia imbi kemak zapat tapmme ekti nâmtemtem mbien. Mti imbiyet, “Geŋ pi kwileki tapmnik?” ma Zisasiyet Samalia imbiyet, “Zet kwileki tadundumann?” mee ke idayaŋkwesisâgât mbennaŋgut nâmann ŋep ku beme belak pemann tage. ");
INSERT INTO naf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Âpme imbi piwan tu menzimaŋ mee piwan peme weme belak windembemti mkaen meti am pigok diindoye, ");
INSERT INTO naf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“In kopme neŋ Zuda an ŋen kotazingat met zikat indama egit. An keyaŋ nâlen yomm sambe bepi sosok zemkawaŋ bem namâlep. An ke Kilais sokbembeyet zenzeŋaŋ wa ke mene?” ");
INSERT INTO naf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","31","Zeme nâmti am bee ilinsakwep Zisasmagen kosât ewe selen takopme kan keyet nembaŋane nin pigok zewenn, “An zikat indanda tu meu bugan niya!” ");
INSERT INTO naf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Âpme egaŋ ningat zeye, “Neŋ tu meu sepemaŋ ŋen tatnain e in kunâip.” ");
INSERT INTO naf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kegok zeme nâmti nemba nin nnak pigok zenâmbenn, “Am pe kwiyaŋ meu mkot same niwaŋ?” ");
INSERT INTO naf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tazemann ndikti pigok dinndoye, “Neŋ Bienaŋ mulupmaŋ mimiyet zemneme toban keyepmti egalen mulupmaŋ mdelaŋ zesap keyaŋ tu meunok penaŋ bein. ");
INSERT INTO naf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","In pigok manzeip, ‘Meu muluwen ondemann kwati eyoŋga zulak zulak beme meu penaŋ masokbein.’ Yaŋgut neŋ pigok diindoma nâit, in teŋ zemwati mulup egit muluwen meu penaŋ sokbembe temaŋ ilak alak kapi sokbein. ");
INSERT INTO naf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Âpme an ŋenaŋ mulup mti keŋanen mapein kemak am nusi mti penaŋaŋ maakumtin. Egelaŋ ilisakwep muluwit keyet tosaŋaŋ timti oloŋen temaŋ mbalup. Sepem kegogak an nâmkiŋpepemak ŋenaŋ an ŋen Kawawaŋgalen Zet Zapat Dolakŋaŋ dunduye. Âpme naman ŋenaŋ mukulem mme yomengatnan keŋan gilik zemti kululuŋen mobotgat zapat bemti main keyepmti an zut keyaŋ muluwidaŋgat tosaŋaŋ ilizuzut timti oloŋen ilisakwep mbalup. ");
INSERT INTO naf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Âpme nin set kapigok maminup: An ŋenaŋ mulupmaŋ mti maondein. Âpme an ŋenaŋ mukulem mti nusi kayak mti penaŋaŋ timti time maŋge kwep mamozin. ");
INSERT INTO naf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Âpme neŋ in nâlen muluwen meti mulup nembanne indamukulem mti ekŋenmak ilinsakwep meu penaŋ akum time temakwep mobogat nâmti zemindeyapgat melit.” ");
INSERT INTO naf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tazeme Samalia imbi piwan meti animbi sambe ekŋen pigok diindoye, “Neŋ yom kwitnaŋ kwitnaŋ mkwaban piwan egaŋ zemkawaŋ bemti namâpme delaŋ zep.” Zet kegok zeme nâmti am sambeyaŋ ek nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Keyepmti Samalia am ekŋenaŋ Zisasmagen koti ekŋenmak mamayet yaŋkwesime Zisasiyaŋ nâme ŋep beme nin meti ekŋengalen mkaen kasup zuletaŋ nsakwep mambenn. ");
INSERT INTO naf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ke met mamti zet zapatnaŋ diindome am sambe penaŋaŋ ewe tusumti Zisasiyet nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mti imbi Zisas ŋeŋaŋ met aige ek ke pigok dunduwien, “Nin ŋeŋaŋ geŋ zet zemane nânnaŋ pi ilak nin penaŋ dembusekŋanen zetnaŋ penaŋ nâmti nâmkiŋpenup. An kapi penaŋ Kilais msat sambe am nin pi yomengatnan gilik zemti ndatiwe.” ");
INSERT INTO naf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Âpme Zisas nembaŋane nin kasup zut pi Samalia am ekŋenmak ke maneti naman gilik zemti Galili msalen mebenn. ");
INSERT INTO naf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mesât mepmambe Zisasiyaŋ ikŋaŋ pigok zeye, “Golaŋ zenze an ŋen ikŋaŋgalen mkaŋaŋ ŋotakŋanen ke tapme ikŋaŋgalen maŋge ŋeneyaŋ zetnaŋ gawepumti egat nâme mobotnaŋ ku mambein.” ");
INSERT INTO naf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Âpme Zisasmak nembaŋane nin meti Galili msalen pataŋ zemann Galili msalen animbi ekŋenaŋ oloŋen mti ndazemtetime mkaen mobenn. Nin Aŋgalalaŋ Kendoyet Zelusalem mka teman baen met mamti ekmann Zisasiyaŋ menok notnaŋ mme ekbenn keyepmti Zisas ekti ndazemtetime mobenn. ");
INSERT INTO naf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ke nin moti keyetnan mane mane naman Kana mka msalen tu zeme wain beye mka keyegak met pataŋ zewenn. Âpme Kapaneam mka keyet gapmangalen amobotnaŋ ŋen maŋge egat nemuŋaŋ zawat nukŋaŋ penaŋ mti mawemtan. ");
INSERT INTO naf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Âpme Zisasmak nin Zudia msalengatnan ewe Galili msalen kopmann zeme nâmti amobotnaŋ piwan Kana mka msalen meti nembaŋaŋ gakisât penaŋ tapmme koge keyepmti Zisasi wati mebegat yaŋkwesim nâŋge. ");
INSERT INTO naf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Âpme Zisasiyaŋ pigok dunduye, “In kapi neŋ menok ma kwitnaŋ kwitnaŋ zikalinan mamanamaŋ sokbeme ekti zetn nâmkiŋpesât maâip.” ");
INSERT INTO naf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Zeme amobotnaŋ keyaŋ pigok zeye, “Amobotnaŋ Zisas, nemban gakisemmagat kopmane sakwep medi.” ");
INSERT INTO naf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Zeme Zisasiyaŋ pigok zeye, “Nemundi ilak alik beingat ŋepgat gitak met!” Zeme amobotnaŋ keyaŋ Zisasiyet zetnaŋ nâmkiŋpemti mege. ");
INSERT INTO naf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Selen tapmepme sisiliŋ nembaŋane ekŋenaŋ ek aiksâgât selen metaikti pigok dunduwien, “Nemundi alik bep.” ");
INSERT INTO naf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Zeme egaŋ indayaŋkwesiye, “Kan zukŋan penaŋ alik bep?” Zeme ekŋenaŋ zewien, “Saŋenen kasup sutnaŋ teman penaŋ tapme kan keyet zawatnaŋ yek bep.” ");
INSERT INTO naf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kegok zeme amobotnaŋ keyaŋ yaŋaŋ pigok nâmâtâge. Kan keyet penaŋ Amobotnaŋ Zisasiyaŋ zemnemti pigok zep, “Nemundi ilak alik bep.” Ke nâmti mam ip don notnane zemâtâtindame nâmti ilinsakwep Zisasiyet nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Zisasiyaŋ Zudia msalengatnan Galili msalen sek zut meti menok ke mme sek zulak beye. ");
INSERT INTO naf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ke manepeme Zuda am ekŋengalen kendo temaŋ ŋen beme Zisasiyaŋ Zelusalem mka teman mege. ");
INSERT INTO naf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Âpme Zelusalem mka temaŋ keyet keŋan tu lemunan temanik ŋen sipsip set tokwakwat manzemtemien keyet solonan matatan. Âpme tu lemunaŋ keyet nembet nembet mka mzalaŋ 5 walapeme matatan. Ma Zuda ekŋengalen zelinaset tu keyet kwitnaŋ Betesda makumtemien. ");
INSERT INTO naf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Âpme mzalaŋ keyet keŋanen am zawatmak ma am zikalin beŋaŋ ma am setnaŋ wesiŋ ma selin belin wesiŋ bembeŋaŋ sambeyaŋ ke wemti tu titok mme ekti towewegat damuŋ matatemien. ");
INSERT INTO naf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ke tatnepeme kan notnaŋgat tu lemunan keyet palen Kawawaŋgalen enselaŋ kululuŋengatnaŋ ŋenaŋ tot titok mme ekti an kwiyaŋ ŋeŋaŋ penaŋ mapalamti totan egaŋ sakwep sekŋaŋ dolakŋaŋ mambemtan. ");
INSERT INTO naf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Âpme an ŋen setnaŋ betnaŋ wesiŋ yaŋ kan teepmaŋ nup kan 38 pi notnaŋ ekŋenaŋ windeŋaŋ bemti towepme egaŋ olapme beme belak ke kwesiŋ matatan. ");
INSERT INTO naf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Âpme Zisasiyaŋ an ke kan teepmaŋ penaŋ matatan ke ekti kembeŋ penaŋ mti yaŋkwesiye, “Geŋ dolakŋaŋ bembeyet nânik ma yek?” ");
INSERT INTO naf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Zeme an wesiŋ keyaŋ zeye, “Amobotnaŋ, an notn dolakŋaŋ penaŋ kwiyaŋ tu titok mme sakwep nambepeme tu keŋan towebak? Nen towesât ewe wati tiktik takuma an ŋenalak sakwep palam tu lemunan toti ilak alik mambein.” ");
INSERT INTO naf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Zeme Zisasiyaŋ pigok dunduye, “Geŋ sindi ambepelet timti met.” ");
INSERT INTO naf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Zeme keyegak an keyaŋ wawadak Zisasiyet nânâpiŋ belak sinaŋ ambepeleti mkaŋan mesât mege kasup keyegak Sabat tagoŋgo kan tapmambien. ");
INSERT INTO naf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Keyepmti Zuda amobotnaŋ notnaŋ ekŋenaŋ an dolakŋaŋ beye ke selen aikti egat pigok dunduwien, “Alak Sabat tagoŋgo kan sutnan milawadi ambepeleti wati kodik ke set dolakŋaŋ penaŋ yek.” ");
INSERT INTO naf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Zeme egaŋ pigok diindoye, “An weyaŋnep egaŋ pigok dinop, ‘Geŋ wati sindi ambepelet timti met.’” ");
INSERT INTO naf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Zeme nâmti an keyet pigok yaŋkwesiwien, “An wati sindi ambepelet met diŋgop an ke geŋ kwitnaŋ nâmtadik?” ");
INSERT INTO naf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yaŋkwesime an sekŋaŋ weyayaŋaŋ keyaŋ Zisas daŋan ku nâmâtâge. E eneyet am sambe penaŋ tabien keyepmti Zisasiyaŋ sakwep am tuŋgupmaset enzilimege. ");
INSERT INTO naf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yaŋ ke maneti Zisasiyaŋ an ke sesewat mka temanen tapme aikti aŋkeŋoo zet pigok dunduye, “Geŋ sekdi ilak dolakŋaŋ bep. Keyet geŋ bekanaŋ ŋen mbanikmagat eksemti mamambanik. Mineti nan nukŋaŋ temaŋ penaŋ ŋen dukdan mobeyet.” ");
INSERT INTO naf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Zeme an piwan Zisas weyaŋ ekmâtâti met Zuda amobotnaŋ pigok diindoye, “An weyaŋnewan kwitnaŋ Zisas.” ");
INSERT INTO naf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Zisasiyaŋ Sabat tagoŋgo kan sutnan penaŋ an ke weyaŋpeye keyepmti Zuda amobotnaŋ ekŋenaŋ Zisasiyet nâme ŋep ku beme kan keyet yaŋbemti Zisas kume gakikiyet zetnaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ŋenzinziŋ mme Zisasiyaŋ pigok diindoye, “Bienaŋ am tagoŋgoŋepiŋ indamukulem mammin âpme neŋ sepem kegogak mamiyap.” ");
INSERT INTO naf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Âpme Zuda an ŋeŋaŋ ekŋenaŋ Zisasiyaŋ an ŋen Sabat tagoŋgo kan sutnan weyaŋpeye keyet ma Kawawaŋgat nâgât Bipm penaŋ nit mulup tagoŋgoŋepiŋ mamilup zeye keyepmti ŋeŋin penaŋ zime kume gakikiyet zewien. ");
INSERT INTO naf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Âpme Zisasiyaŋ zet pigok diindoye, “Neŋ penaŋ sukwep pigok zema nâit: Neŋ Kawawaŋgat Nemuŋaŋ neŋ keŋnangalak mulup ku mamiap. Neŋ Bienaŋ mulup mme ekti keyegak mamiap. ");
INSERT INTO naf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Âpme Bienaŋ Nemuŋaŋ neŋ ke manigoin keyet mti mulup mamiap kataŋ egaŋ weyaŋ zikat name mamiap. Yaŋ mulup mma maegip ke etaŋ yek. Temaŋ penaŋ ewe zikat name mma in ekti nâmtemtem penaŋ mbep. ");
INSERT INTO naf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bienaŋ am gakikiengatnan mme mawalip. Keyepmti Nemuŋaŋ neŋ kegogak an ŋen gakikiengatnan mma wasât mbawen ŋep mma wabep. ");
INSERT INTO naf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Âpme Bienaŋ ikŋaŋ am mama titiyet ma walelet keyet zelin ku zemdelaŋ zewe. Mulup ke Bienaŋ nâgât betnnan etaŋ beme delaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Keyepmti amnaŋ Bipmnaŋgat kwizet buŋamaŋ mamwalip sepem kegogak Nemuŋaŋ nâgât kwizet buŋamm mwabep. An ŋenaŋ nâgât kwizet buŋamm ku mwabe beme egaŋ Bipm zemneme koban an keyet kwizet buŋamaŋ kegogak ku mwabe. ");
INSERT INTO naf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Neŋ penaŋ zema nâit: An ŋenaŋ nâlen zet kapi nâmti An zemneme toban ek nâmkiŋpewe beme an keyaŋ walelet ku aikbe. Egaŋ msalen kapiyegak gakiki ma yom dopmaŋ titi set e pemti mama kanzizit elak tiyeyaŋ mamain. ");
INSERT INTO naf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Neŋ zet penaŋ pigok diindoma nâit: Kan alak tatnuwen kapiyet keyepmti am mama mimi bekanaŋgalen seleset mâti mamaip ekŋenaŋ neŋ Kawawaŋgat Nemuŋaŋ nâlen zet nâmti nâmkiŋpewep beme naman mama kanzizit aikbep. ");
INSERT INTO naf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bien ek mama keyet ŋotekŋaŋ âpme Nemuŋaŋ neŋ kegogak mamayet ŋotekŋaŋ bembeyet Bienaŋ nâmneŋge. ");
INSERT INTO naf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Neŋ Angat Nemuŋaŋ keyepmti Kawawaŋ Bipmnaŋ amgat zet zemdelaŋ zenze mulup ke mimiyet zemdelaŋ zemneŋge. ");
INSERT INTO naf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","In neŋ zet zeyap keyet nâme setnaŋ ku mimiyelenok ku besem. Kan ŋen besâpmnen am zaimen am tawep ekŋenaŋ kwizetn nâmti wapmâpme delaŋ zewe. ");
INSERT INTO naf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Âpme am mama mimiŋin dolakŋaŋ mti mambien ekŋenaŋ mama kanzizit titiyet oloŋen palen wapmâbep. Âpme am mama mimiŋin bekanaŋ ekŋenaŋ yominaŋgat dopmaŋ timti teziŋ ŋandaŋ towesât bembesipeŋ wapmâbep. ");
INSERT INTO naf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Neŋ nanaŋgat keŋŋnaŋgalak mulup ke ku mamiyap. Bipmnaŋgalen zet keyet katnaŋ am mama mimiŋinaŋgat kataŋ zet muluwen indemti dopmaŋ esemtaŋak mutumindawap. Ke wa nenaŋgalen zet yek An zemneme koban egalen zet gawepumti mbap. ");
INSERT INTO naf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Neŋ nanaŋgat yaŋŋ nenak zema in nâme penaŋ ku mambein. ");
INSERT INTO naf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nâgât yaŋŋ Bipm Kawawaŋaŋ manzemkawaŋ bemnein keyaŋ penaŋ bein. ");
INSERT INTO naf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","In Zân an tu zululut an ekmagen yaŋkwesime egaŋ zet penaŋ ŋotekŋaŋ ilak ke zemkawaŋ bemindame nâmbien kemak. ");
INSERT INTO naf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wa Zânaŋ nâgât yaŋŋ zemkawaŋ bemindaye ke nâgât kwizet buŋamm temaŋ bembeyet nâmti yek. In nâgât yaŋŋ nâmâtâti neŋmagen keŋ gilik zenze aikti mama kanzizitgalen set ke mâti mebegat diindoye. ");
INSERT INTO naf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zân an tu zulutindende egaŋ lam temaŋnok bemti in mbusatnaŋ bemindeme sokŋan in kan isikŋaŋ bugan ke ekti belak etaŋ egowien. ");
INSERT INTO naf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Âpme nâgât yaŋŋ bee Bienaŋ ikŋaŋ manzemkawaŋbein. Ek ke wan Zân keboŋ yek. Ek windeŋaŋ sepemaŋ igak penaŋ. Egaŋ neŋ mulupm ke mimiyet zemneme koban. Mulup ke mima mulup keyaŋ neŋ Kawawaŋ ikŋaŋgat Nemuŋaŋ e sosok mamimsokbemnein. ");
INSERT INTO naf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Bienaŋ nâgât yaŋŋ in ilak zemkawaŋ bemindame nâmnembien. In ekmak dopmaŋ ek dopmaŋ ek ku mamip ma egaŋ indik tati zet ikŋaŋ esemteŋ penaŋ diindome ku manâip. Âpme in naman neŋ egaŋ zemneme koti egalen zet manzemkawaŋ beyap mee pi ku manâmkiŋpemneip. ");
INSERT INTO naf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","In Kawawaŋgalen Zet Itnaŋaŋen zet kapigok tazin ke maiŋti yaŋaŋ maomkakalimti nâip. Zet keyet keŋan mama kanzizit aiksenup zematimaliwaŋ zet keyaŋ nâgât yaŋŋ manzemâtâtindainen mama kanzizit neŋmagen titiyelen. ");
INSERT INTO naf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Âpme in neŋmak tusum mamti mama kanzizit titiyelen e ewe wisalagak mamip. ");
INSERT INTO naf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Âpme wa neŋ amnaŋ sekŋ mmobotgat am tuŋgupman belak motati ku manzeyap. ");
INSERT INTO naf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Neŋgut ingat yaŋaŋin elak nâma delaŋ zein. In keŋinan Kawawaŋ gogot penaŋ ku mampeip. ");
INSERT INTO naf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Neŋ Bienaŋ ikŋaŋgat munduman zemneme toban keyaŋgut in neŋ ku nâmkiŋpemneip. Âpme an ŋenaŋ igak nânâŋak koti neŋ an keboŋ keboŋ zemeŋgut in an ke sakwep manâmkiŋpeip. ");
INSERT INTO naf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mti ilinak notnaŋaŋ notnaŋgat kwizet buŋamaŋ mwat notnaŋaŋ notnaŋgat kwizet buŋamaŋ mwat mmamti keyet nâme dolakŋaŋ mambein. Keboŋ ke ingat kwizet buŋamin zigok mwabe? Naman in zigoset nâgât nâmkiŋpemnewep? ");
INSERT INTO naf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","In nâgât pigok ku nâseip egaŋ Bipmaŋmagen meti nin zemndowe neŋ egok ŋep ku mbap. In Mosesimagen mawetekummaip keyepmti Mosesiyaŋ Bipmagen zemindowe. ");
INSERT INTO naf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Egaŋ zet kuye ke nâgât kuye. Yaŋ in Mosesiyelen zet penaŋ nâmkiŋpewiek ze elak nâgât nâmkiŋpenewiek. ");
INSERT INTO naf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","In Mosesiyaŋ zet kuye ke ku nâmkiŋpewien keyepmti naman neŋ zet manzeyap, kapi zigoset nâmkiŋpewiek?” ");
INSERT INTO naf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Zisasiyaŋ zet kegok zeme delaŋ zeme Galili tundua kwitnaŋ ŋen Taibilias manzemtemien tundua ke somti nembet daeset mebenn. ");
INSERT INTO naf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mepmann animbi sambe ekŋenaŋ Zisasiyaŋ animbi zawatmak ma wesiŋ mee pi taweyaŋindeme ekmambiengapmti keyegak ndamâti mebien. ");
INSERT INTO naf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Âpme Zisasmak nin nembet moti ndatimti kalaŋ dukŋan gwaenen moti totapmambenn. ");
INSERT INTO naf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kan keyet Zuda am ekŋengalen Aŋgalaŋ Kendo sokŋan beye. ");
INSERT INTO naf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Âpme Zisasiyaŋ am maŋge temaŋ penaŋ kwaweti weme indikti egaŋ Pilip pigok yaŋkwesiye, “Pilip, am maŋge temaŋ penaŋ kapi nupmamaŋ desetgat penaŋ kwitimti am sambe kapi indamann nseip?” ");
INSERT INTO naf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Zisasiyaŋ, “Kwitnaŋ kwitnaŋ zigok msap e nâmtati,” Pilipgat belak tetipem ege.) ");
INSERT INTO naf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Âpme Piliwaŋ wa penaŋ penaŋ zep mene zemti pigok zeye, “Nin mânep 200 Kina bukapiyaŋ meu kwitimti am maŋge temaŋ bekapi indamann isiksik bugan munzuti nseip mene.” ");
INSERT INTO naf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Zeme Zisasiyet nembaŋaŋ ŋen Endulu Saimon Pitayet datnaŋ egaŋ Zisasiyet pigok dunduye, ");
INSERT INTO naf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Zisas, anemba ŋenaŋ nupmamaŋaŋ 5 ma aŋgalaŋaŋ zut etaŋ eleŋan weti tapme ekti aikolap. Âpme am sambe kamendepmaŋ bekaboŋ bekapi bukapi zigok munzutindamann ŋep benak?” ");
INSERT INTO naf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Zeme nâmti Zisasiyaŋ ningat pigok dinndoye, “In am ekŋen zemindeme sutnakwep totalit.” Zeme nin am zemindemann kwaŋ sinaŋ yati gwilelaŋ totabien an 5000. Âpme imbimak nembamak ekŋen ku indamakukuŋaŋ. ");
INSERT INTO naf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Zisasiyaŋ nupmamaŋ ke mti Kawawaŋgat wisikŋ zemti mutumti am tapmebienen indaye. Mti aŋgala sepem kegogak meselemti am kalaŋti indamepme nimâbien. ");
INSERT INTO naf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Meu nimkiŋgapme temepme Zisasiyaŋ ningat pigok dinndoye, “Nime meu butnaŋ totemelep e belak wemti walesemmagengat akume maŋge kwep molak.” ");
INSERT INTO naf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Âpme nin nupmamaŋ 5 etaŋ bukapiwan Zisasiyaŋ mme sambe beme nimwiaŋme butnaŋ temege. Pi timti tise 12 kapi wepme gak zeye. ");
INSERT INTO naf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Âpme am ekŋenaŋ Zisasiyaŋ menok ke mme ekti pigok zewien, “Kawawaŋmagen golaŋ zenze an temaŋ msalen pi sokbembeyet zenzeŋaŋ kelak an ikŋaŋ kapimak!” ");
INSERT INTO naf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Zemti Zisas atamti amobotnaŋin onzempesâgât tazenâme egaŋ wak kambu nâmti nâme ŋep kumbeme igak buzak kalaŋan mowege. ");
INSERT INTO naf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Msat ilak gasi penaŋ beme nembaŋane nin nnak tundua ganzenan toti waŋga ŋen mti Kapaneam mka msalen daen mesât nâmti towebenn. Towepmann msat tambuyeyepmtilak Zisas ke tapme nnak waŋga ŋen mti mebenn. ");
INSERT INTO naf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tapmepmann tâgâ omba penaŋ kumbume tundua mamaŋ omba penaŋ takume ekmambe tapmepmambenn. ");
INSERT INTO naf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nin waŋgaen moti ilak beŋan daen tu sutnan kegok tapmepmann Zisasiyaŋ kalaŋangatnan toti nembu paleset ninmagen sokŋanik tapmepme nin ekti, “Wa! we eknup,” zemti kiŋgabenn. ");
INSERT INTO naf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kegok mmann ndikti kwizet kumti zeye, “Neŋ nen takolapgat in ku kiŋgalit.” ");
INSERT INTO naf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Zemti met pataŋ zeme nin betnamann waŋgaen molak zem tapminepeme waŋgayaŋ ilak msat mesât nâmti mebiennen ke met sakwep metage. ");
INSERT INTO naf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Animbi sambe ekŋenaŋ tundua nembet daen tatnepeme msat msame zewien, “Saŋen tambuyet waŋga kwewetaŋ tapme ekmenn elak Zisaspiŋ nembaŋaneyaŋ etaŋ moti mepme indikmen.” ");
INSERT INTO naf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kegok zemti tatnepeme waŋga notnaŋ Taibilias mkaesetgatnan Amobotnaŋ Zisasiyaŋ Bipmaŋgat wisikŋ zeme tu meu sambe sokbeme amnaŋ nimwiaŋbien keeset kot pataŋ zemâbien. ");
INSERT INTO naf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Âpme am ekŋenaŋ Zisas ma nin ndatimati naman waŋga keyet moti Kapaneam mka msalen meti tokwat ndatimabien. ");
INSERT INTO naf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Timat meti met ndaaikti Zisasiyet zewien, “An zikat indanda, geŋ zukŋan tu nembet daengatnan kopmanan?” ");
INSERT INTO naf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yaŋkwesime zet kapigok diindoye, “Neŋ zet penaŋ sukwep zema nâit: Neŋ menok windeŋaŋbeŋ inmagen mamiyap keyet nâmkiŋpemnemti ku kolo yek. In meu sambe penaŋ aikindama nimti ekmien keyepmti nâgât tatokwatnatimalip. ");
INSERT INTO naf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","In kwitnaŋ kwitnaŋ walebe keyet mulupmaŋ ku mbep. Mama katikŋaŋ keyelen meu keyet mulupmaŋ weyaŋ mbep. Mama katikŋaŋgalen meu ke Angat Nemuŋaŋaŋ neŋ indandayet Kawawaŋaŋ ikŋaŋ nâmneme ŋep beme zemdelaŋ zemneŋge.” ");
INSERT INTO naf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Zeme zet dopmaŋ pigok gilik zemti sawien, “Nin mulup pe ziboŋ ke mmann Kawawaŋaŋ ningat nâme dolakŋaŋ bewe.” ");
INSERT INTO naf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yaŋkwesime pigok diindoye, “An Kawawaŋaŋ zempeme koge ke nâmkiŋpewep keyaŋ muluwin ŋotekŋaŋ penaŋ bein.” ");
INSERT INTO naf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Zeme ekŋenaŋ zet pigok dunduwien, “Geŋ pe menok ziboŋ penaŋ mmane ekti nâmkiŋpemgewanup? Ma geŋ pe mulup ziboŋ penaŋ mbanigat tazenik? ");
INSERT INTO naf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nin yeŋsokŋne ekŋenaŋ msat tuŋgupman meu piŋan mamti meuŋin kululuŋengatnaŋ topme nimti mambien. Keyet Kawawaŋgalen Zet Itnaŋanen pigok meluwaŋ mamaiŋ nânup, ‘Kawawaŋaŋ meu kululuŋengatnaŋ aikindame manimtemien.’” ");
INSERT INTO naf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Âpme Zisasiyaŋ pigok diindoye, “Neŋ zet penaŋ diindoma nâit: Moses egaŋ meu kululuŋengatnaŋ penaŋ ke ku indaye. Mosesiyaŋ Bien Kawawaŋgat dundume Bienaŋ kululuŋengatnaŋ meu ke belak sekŋin etaŋ bandim mimiyet maindamkwatan. Âpme alak meu penaŋ ke Kawawaŋaŋ ikŋaŋ am indapmukulem penaŋ mimiyet nâmti kululuŋengatnan peme toti alak ingat tuŋguwinan kapi tazin. ");
INSERT INTO naf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Meu kululuŋengatnaŋaŋ toti am mama maaikindain ke Kawawaŋmagen meu penaŋ elak kapi tazin.” ");
INSERT INTO naf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Zeme ekŋenaŋ zewien, “Amobotnaŋ, geŋ meu zenik ke nin manndamambanik.” ");
INSERT INTO naf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Zeme dopmaŋ pigok diindoye, “Mamayelen meu elak neŋ kapimak. Am ŋenaŋ neŋmagen wetekumti mambe beme egaŋ meuyet ku mbe. Ma am ŋenaŋ neŋ nâmkiŋpemnewe beme egaŋ kegogak tuyet ku atowe. ");
INSERT INTO naf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Neŋ pigok diindoma nâit: in neŋ zikalinaŋ ke niktiŋgut ewe ku manâmkiŋpemneip. ");
INSERT INTO naf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bienaŋ am nâmindeme neŋmagen makolip ekŋen ke neŋ ŋep ku zemindema mebep. ");
INSERT INTO naf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Neŋ kululuŋen gwaengatnan toban e wa msalen kapi nanaŋgat nânânnaŋgat etaŋ mamayet ku toban. An zemneme toban egalen zet gawepumti keyet kataŋ mamayet toban. ");
INSERT INTO naf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bienaŋ am nâmdelaŋ zemti nâlen belen bemindeye. Ekŋen ke maneti walelet aikbiekmagengapm neŋ indikdamuŋ dolakŋaŋ mti maneti bam kobawen ekŋen ke ilindiŋ gakikiengatnan mamaen mkwatindewap. An zemneme toban egalen nânâ ilak zeya kegok. ");
INSERT INTO naf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Am neŋ nikmâtâti manâmkiŋpemneip ekŋen bam gakikiengatnan mwat indema mama kanzizit keyet toŋaŋ bewep. Biengalen nânâŋaŋ kegok penaŋ tazin.” ");
INSERT INTO naf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zisasiyaŋ “Neŋ meu kululuŋengatnaŋ” zeye keyepmti Zuda am ekŋenaŋ nâme bekanaŋ beme zet mmot mtot sambe penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mti pigok zewien, “Zisas pi mamaŋ bipmaŋ Zosep ma Malia e nâmidenup. Âpme naman egaŋ zigoset neŋ kululuŋengatnan kwatoban pi tazein?” ");
INSERT INTO naf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Zemti ilinak zet ŋunuŋ ŋunuŋ tapmmepme Zisasiyaŋ indikti pigok diindoye, “In zet ŋunuŋ ŋunuŋ peme talak. ");
INSERT INTO naf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nâip, an ŋenaŋ ikŋaŋgat keŋaŋgalak neŋmagen kokot ke ŋep ku tazin. Bienaŋ an ke nâmpemeŋgut ŋep neŋmagen kokogalen. Âpme neŋ an neŋmagen kobe ke maneti bam kokot kananen koti gakikiengatnan mwat pewap. ");
INSERT INTO naf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Golaŋ zenze an egaŋ Kawawaŋgalen Zet Itnaŋanen pigok meluwaŋ mbien, ‘Kawawaŋaŋ ikŋaŋ am sambe ikŋaŋgat yaŋaŋ zemkawaŋ bemindawe.’ Keyepmti an ŋenaŋ Biengalen zet ke nâmti keyet kataŋ mambe egaŋ neŋmagen kobe. ");
INSERT INTO naf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","An ŋeŋaŋ Bien sepemaŋ bugan ku ege yek penaŋ. Neŋ Kawawaŋmagengatnan toban neŋ etaŋ gulak nâmpeyap. ");
INSERT INTO naf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Neŋ zet penaŋ pigok diindoma nâit: An ŋenaŋ neŋ nâmkiŋpemnewe beme egaŋ mama kanzizit tiwe. ");
INSERT INTO naf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mamayelen meu e neŋ. ");
INSERT INTO naf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yeŋsokŋine ekŋenaŋ msat tuŋgupman mamti meuŋin meu kululuŋengatnaŋ manimtemien yaŋgut gakimâpme delaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Âpme meu kululuŋengatnan kwatoge ke an ŋenaŋ nimbe beme egaŋ ŋep ku gakiwe. ");
INSERT INTO naf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mama keyelen meu kululuŋengatnan toge elak nen kapi. Keyepmti an ŋenaŋ meu kululuŋengatnan tototnaŋ ke nimbe beme ek mama kanzizit mameti mambe. Sesumban keyaŋ meunok bein ke msat sambe am indama nime keyaŋ mama kanzizit aikindaweyet indawap.” ");
INSERT INTO naf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Âpme Zuda am ekŋenaŋ ke nâmti ilinak ŋenzinziŋ mti zewien, “An kapiyaŋ zigoset ikŋaŋgat sesumbanaŋ munzut ndame nin niniyet tazein?” ");
INSERT INTO naf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tazenâme Zisasiyaŋ indikti pigok diindoye, “Neŋ penaŋ sukwep penaŋ pigok zema nâit: In nâgât sesumbann ma sipm ke ku nimbep beme in mama kanzizit ku tiwep. ");
INSERT INTO naf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","An ŋenaŋ nâlen sip sesumbann nimbe beme egaŋ mama kanzizitgat zapat bemti mame neŋ kobawen ek gakikiengatnan mima wabe. ");
INSERT INTO naf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nâlen sip sesumbann ke tu meu nemboŋ penaŋ ");
INSERT INTO naf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","keyepmti an ŋenaŋ nâgât sipm sesumbann ke nimbe beme egaŋ neŋmak tusuwe. Âpme neŋ ekmak tususu dolakŋaŋ mti mambalup. ");
INSERT INTO naf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bien Kawawaŋ ek mama toŋaŋ egaŋ ikŋaŋ zemneme toban. Neŋ ekmak mamayap keyepmti neŋ mama kanzizit timtalap. Kegogapm an ŋenaŋ neŋ natnimbe beme egaŋ nâgât pembenaŋnnaŋgat mti mama kanzizit timti mamambe. ");
INSERT INTO naf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Meu kululuŋengatnan toge wa e yeŋsokŋineyaŋ msat tuŋgupman mamti meu manimtemien sepem keboŋ yek. Ekŋenaŋ meu ke timti manimkwatemienaŋgut gakim mâbien. Âpme an ŋenaŋ nâlen meu zeyap kapi nimbe beme egaŋ gakikipiŋ kwesiŋ kwesiŋ mameti mambe.” ");
INSERT INTO naf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Zisasiyaŋ Kapaneam sesewat mkaen am Zet Zapat Dolakŋaŋ tazemzikat indametneti ikŋaŋgat zet zapatnaŋ kapi zeye. ");
INSERT INTO naf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Am notnaŋ ek mâti mamtemien ekŋenaŋ zetnaŋ ke nâmti pigok zewien, “Zet kapi pe zeme nâmann keŋŋ penaŋ ku bein. Zet keboŋ ke an kwiyaŋ ŋep apumti zenak?” ");
INSERT INTO naf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Zemti wisat zet mme Zisasiyaŋ keŋinan baen indikmâtâti pigok diindoye, “In zet zeya keyet nâme keŋin penaŋ ku beme wisat mnemti mesât tatnâip! ");
INSERT INTO naf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Âpme in tati ekme Angat Nemuŋaŋ neŋ gilik zemti naman mundumnan maneti tobanen keyegak mowepma in ke ekti pe zigok nâmbep? ");
INSERT INTO naf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nin mambipmmagen masokbenup ke ekŋenaŋ mama msat palen kapi mamayelen mme masokbenup keyaŋgulak Kawawaŋgalen Emetak Teŋaŋ mama alakŋaŋ titiyelen keŋnan mam mme sokbein. Keyepmti neŋ zet zeya ke Kawawaŋgalen zet in mama indandayelen ke diindoya. Âpme an ŋenaŋ zet ke nâmkiŋpewe beme egaŋ Emetak Teŋaŋ mama kanzizit ke same mamambe. ");
INSERT INTO naf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Âpme inmagen am notnaŋaŋ zet keyet nâme penaŋepiŋ beme ku nâmkiŋpeyo.” (Zisasiyaŋ am zet zapatnaŋ dolakŋaŋ kapi bamkumpewep ma maneti bam an zemkuwe e mee eweŋanak indikmâtâpme mamamtemien keyepmti egaŋ zet kegok diindoye.) ");
INSERT INTO naf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mti zet butnaŋ ŋen pigok tusum zeye, “Neŋ kegogapmti eweŋan pigok diindoya an ŋen Bienaŋ keŋaŋ mim eleŋ beleŋ bembepiŋ mme egaŋ igak nânâŋak nâlen ŋep ku kobe.” ");
INSERT INTO naf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Zeme kan keyet am notnaŋ ekŋen Zisas mâti mamamtemien ekŋenaŋ ewe mâti mamayet wisat mti bamkumpemti mepmâbien. ");
INSERT INTO naf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Âpme Zisasiyaŋ nembaŋane 12 nin pigok ndayaŋkwesiye, “In am notnaŋaŋ tapmelip kegogak nemti mesât tatnâip?” ");
INSERT INTO naf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Zeme Saimon Pitayaŋ pigok zeye, “Amobotnaŋŋ, nin geŋ gemti naman kwimagen mebanup? Mama katikŋaŋ titiyelen zetnaŋ geŋ etaŋ manzemâtâtndamane nânup. ");
INSERT INTO naf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nin geŋmak mamti pigok manânup geŋ Kawawaŋgat Nemuŋaŋ teŋ penaŋ e nâmgemti manâmkiŋpemgenup.” ");
INSERT INTO naf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Zeme Zisasiyaŋ nin pigok dinndoye, “Neŋ nemba in 12 kapi indatimamayap yaŋgut ingat tuŋguwinaŋgatnaŋ ŋen Sadaŋmak mamain.” ");
INSERT INTO naf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Egaŋ Zudas Saimongat nemuŋaŋ Iskaliot mkaengatnan keyet nâmti zeye. Zudas ke nemba 12 ninmagengatnaŋ an ŋen ilak ke. Yaŋ maneti an keyaŋ Zisas zemkuwe. ");
INSERT INTO naf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Zelusalem mka teman Zuda amobotnaŋ mambien ekŋenaŋ Zisas kume gakikiyet zeme nâme Zisasiyaŋ ilinaŋgalen msalen Zudia ke mebepiŋ Galili msalen mka isisikŋaŋ sambe tokwati mulup mamtan. ");
INSERT INTO naf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Âpme Zuda am ekŋengalen mka mzalaŋ isikŋaŋ walati Mzalaŋ Kendo keyet weweyelen ilak sokŋan beye. ");
INSERT INTO naf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Âpme Zisas ikŋaŋgat meniŋane ekŋenaŋ koti pigok dunduwien, “Geŋ Galili msalen pien mamti menok sepem igak igak maminik kegogak Zudia msadan gwaen meti mmane amdine ekŋenaŋ gikbep. ");
INSERT INTO naf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","An ŋenaŋ kwizet buŋamaŋ temaŋ tisât nâmti mulup enzilimti ku mamin. Geŋ mulup kegok msât yaŋbewanangat sosok sokbemti mulup mmane am msat sambe ekŋenaŋ gikmâtâbep.” ");
INSERT INTO naf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Meniŋane ekŋenaŋ Zisas nâmkiŋpepepiŋ mtopemti zet kegok zewien. ");
INSERT INTO naf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Zeme Zisasiyaŋ pigok diindoye, “In Zelusalem mka teman moti mulup e ma e msâti kileŋ belak mamolip. Âpme neŋgulak ke mobotgalen kan ewe ku beingapmti talap. ");
INSERT INTO naf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Am ekŋenaŋ in belak ekŋengat kandaŋinan zet nânâŋ mame zigogat ekŋenaŋ kasa mimindawep? Neŋgulak ekŋengat myuŋguŋguŋin zemkawaŋ bemindama keyepmti neŋ kasa kasa mamimnaip. ");
INSERT INTO naf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","In Kendoyet ŋepgat ilinak Zelusalem mka teman mowelit. Âpme neŋ ke mobogalen kan ewe ku beingapmti sakwep ku mosap.” ");
INSERT INTO naf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kegok zemti Galili mkaenak tage. ");
INSERT INTO naf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tapme ekŋenaŋ pemti mepme egaŋ igak bam meti am keŋan buzak buzak tatokwapmaŋge. ");
INSERT INTO naf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Âpme Kendo beme Zuda amobotnaŋ ekŋenaŋ am indayaŋkwesimti zewien, “Zisas ek de tazin zenâit?” ");
INSERT INTO naf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Indayaŋkwesime am sambe ekŋenaŋ egat zapatnaŋ omba mezem kozem mme palakŋaŋ beye. Mme am notnaŋaŋ zewien, “An ke an dolakŋaŋ.” Âpme notnaŋaŋ naman pigok zewien, “Yek, an ke am keŋin mme mayuŋgumtemezin.” ");
INSERT INTO naf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amnaŋ Zuda amobotnaŋ ekŋengat kiŋgati zet sosok sosok ku zewien. ");
INSERT INTO naf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Âpme Kendo tapmetnepeme sutnateman bemeŋgut Zisasiyaŋ sesewat mka temanen moti am Kawawaŋgalen Zet Itnaŋan zemzikat indame ");
INSERT INTO naf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Zuda amobotnaŋ ekŋenaŋ nâmtemtem temaŋ mti zewien, “An kapi ningalen zii zet zikat indanda anne ekŋengat kandaŋinan ku maŋgeyaŋ egaŋ zigok mti Kawawaŋgalen Zet Itnaŋaŋgalen yaŋaŋ kapi dolakŋaŋ penaŋ tazemâtâzin?” ");
INSERT INTO naf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Zeme Zisasiyaŋ pigok diindoye, “Neŋ Kawawaŋgalen Zet Itnaŋaŋ diindoyap kapi wan nanaŋgat keŋnnaŋgalak yek. An zemneme koban ekmagengatnaŋ timti tazeyap. ");
INSERT INTO naf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Âpme an ŋenaŋ zet kapi Kawawaŋmagengatnaŋ ma nenmagengatnaŋ nâsât mbem beme egaŋ eleŋ beleŋ bemti Kawawaŋgalen zet ke gawepumti neŋmagengatnaŋ ke ŋep nâmâtâbe. ");
INSERT INTO naf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","An ŋenaŋ ikŋaŋgat etaŋ nâmti mulup mbe beme egaŋ belak ikŋaŋgat kwizet buŋamaŋ etaŋ mwabe. Mme neŋ An zemneme toban egat kwizet buŋamaŋ mwasât toban wa neŋ zet ke dâsuki ku manzeyap. Zet penaŋ penaŋak zemti kwizet buŋamaŋ mamwapeyap. ");
INSERT INTO naf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesiyaŋ zii zet mtotindaye ke inmagengatnaŋ an ŋenaŋ ke ŋeselak penaŋ gawepume delaŋ penaŋ ku manzein. Âpme in naman neŋ zii zet ku maŋgawepuyap zemnome gakikiyet pi manzeip?” ");
INSERT INTO naf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Zeme am sambeyaŋ pigok zewien, “Geŋ kwiyaŋ gosât manzein? Geŋ penaŋ keŋdanen we bekanaŋaŋ totapme zet kileŋ kileŋ tazenik.” ");
INSERT INTO naf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Zeme Zisasiyaŋ pigok diindoye, “Neŋ Sabat tagoŋgo kanen menok temaŋ kwep mma ekbien keyepmti in nikti nâmtemtem omba penaŋ mamimneip. ");
INSERT INTO naf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Neŋ pigok diindoma nâit, Mosesiyaŋ in nemuŋine sekŋin butnaŋ antim indendeyet zemindeme mamip yaŋgut ke Mosesiyaŋ ikŋaŋ set ke ku yaŋbeye; ingat yeŋsokŋine ekŋenaŋ yaŋbewien. Yaŋ mulup ke mamkwatne kwatnelak alak pilak nemba sokbembeŋin mâti Sabat tagoŋgo kanen eyo mamip. ");
INSERT INTO naf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","In Mosesiyelen zii zet ke gawepumti Sabat tagoŋgo kanen eyo nemuŋine sekŋin butnaŋ maantip. Âpme neŋ an wesiŋ ŋen Sabat tagoŋgo kanen sekŋaŋ mma dolakŋaŋ penaŋ beye keyet naman kwilekiyet nâgât ŋenzinziŋ mbien? ");
INSERT INTO naf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","In zet nâmâtâtâpiŋ belak kileŋ ku manzemambep. In weyaŋ nâgât yaŋŋ nâmâtâlit. Neŋ Kawawaŋgalen nânân dolakŋaset kwitnaŋ kwitnaŋ penaŋak manzemti mamiap.” ");
INSERT INTO naf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Âpme Zelusalem mka mtoŋ notnaŋ ekŋenaŋ pigok zewien, “An damuŋ ekŋenaŋ an kusât manzeiwan an ikŋaŋ kapi manze egit. ");
INSERT INTO naf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Egaŋ zet sosok penaŋ am sutnan penaŋ kapi tazeme amobotnaŋnne ekŋenaŋ ekti eneyet ku zemkulumpeip? Ekŋenaŋ ek ilak Kilais e sosok ekti keyepmti belak nâmpeme tati tazein mene? ");
INSERT INTO naf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nin an kapiyelen mkaŋaŋ ŋotekŋaŋ ŋep nânup. Âpme Kilais kobe ek nin yaŋaŋaŋ ma mkaŋaŋ mee ŋep ku nâmpewanup.” ");
INSERT INTO naf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Zisasiyaŋ Zelusalem sesewat mka teman ke tati am ikŋaŋgat yaŋaŋ diindomambe nâme kegok zeme nâmti bim ŋandeŋaŋ mwati pigok diindoye, “In nâgât yaŋŋ penaŋ zigoset koban ke ku nâmâtâlip. Neŋ nenak keŋŋ naŋgalak ku toban. An zet penaŋ penaŋak manzein An keyaŋ zemneme toban nâip. Âpme in An ek ku nâmâtâpeip. ");
INSERT INTO naf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Neŋ ikŋaŋmak manepema zemneme toban keyepmti neŋ egat nâmâtâpeyap.” ");
INSERT INTO naf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kegok zeme ŋeŋin zime wati mka katiŋan met pesât nâmbien yaŋgut Kawawaŋaŋ egat kanaŋ beye e ewe ku koge keyepmti atatayet belin nukŋaŋ beme peme tage. ");
INSERT INTO naf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Âpme am notnaŋ sambe tabien ekŋenaŋ Zisas nâmkiŋpemti pigok zewien, “Kilais egaŋ koti menok sepem igak penaŋ mbe zenzeŋaŋ elak an kapiyaŋ set kwitnaŋ kwitnaŋ sambe bee mme delaŋ tazein.” ");
INSERT INTO naf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Am ekŋenaŋ zet kusuŋ kasak tapmme Palisi ekŋenaŋ nâmti met sâpe sâpe bumbu an ŋeŋaŋ ekŋenmak zenâmti sesewat mka temaŋgalen antipdakutun zemindeme Zisas wati met mka katikŋan pesât mebien. ");
INSERT INTO naf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Âpme Zisasiyaŋ pigok diindoye, “Neŋ kan isikŋaŋ bugan kapi inmak maneti bam gilik zemti naman An zemneme koban ekmagen mowebap. ");
INSERT INTO naf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Âpme in neŋ natimabep yaŋgut ŋep ku naikbep. Neŋ met mambawen ke in ku kobep.” ");
INSERT INTO naf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kegok zeme Zuda amobotnaŋ ekŋenaŋ pigok zemti ilinak zenâ zenâ mbien, “An kapi pe deset buzak penaŋ mepme nin timabanupgat tazein? Ma ek pe Glik msalen Zuda am notnane ekŋenmagen met enzilim mamti ikŋaŋgat yaŋaŋ dâsuki ke Glik am diindosâgât mene nâmti pigok tazein? ");
INSERT INTO naf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘In natimati ŋep ku naikbep ma mebap ke in ku kobep,’ zet keboŋ ke yaŋaŋ penaŋ zigogat nâmti tazein?” ");
INSERT INTO naf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Zuda am ekŋenaŋ Mzalaŋ Kendo ilak tat delaŋ zesât mme sâpe sâpe bumbu an ekŋenaŋ mawaŋ kokogat dundusât towepme Zisasiyaŋ tuŋguwinan watati zet memendepmaŋmak pigok zeye, “Am ŋen tuyet maatoin beme egaŋ nenmagen koti tu nimbe. ");
INSERT INTO naf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kawawaŋgalen Zet Itnaŋanen tu ke Emetak Teŋgat nâmti zet zemak zemak mimiŋaŋ keyet yaŋaŋ kapigok, ‘An ŋenaŋ neŋ nâmkiŋpemnewe beme egat keŋanen tu am mama maaikindain keyaŋ an keyet keŋanen zikatnaŋmaknok kwati kwesiŋ matapmambe.’” ");
INSERT INTO naf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Zet kegok tazin keyepmti am Zisas nâmkiŋpewien ekŋengat Zisasiyaŋ pigok zetik mimindaye, “In kapi tapme neŋ kululuŋen mundum elimiakŋaŋmak keyet keŋan gilik zem moti Emetak Teŋ zempema inmak totmambe.” ");
INSERT INTO naf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Am ekŋenaŋ zet ke nâmti ilinak Zisasiyet pigok zemebien, “An kapi penaŋ golaŋ zenze an nin egat kokogat damuŋ matatnuwen ilak kapi.” ");
INSERT INTO naf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Âpme am notnaŋaŋ pigok zewien, “An kapi penaŋ Kilais Kawawaŋaŋ ikŋaŋ ombempeme kokogat zeye.” Zeme am notnaŋaŋ zewien, “Kilais ek Galili msalen kapi ku sokbembeyet zenzeŋaŋ? ");
INSERT INTO naf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kawawaŋgalen Zet Itnaŋanen zet pigok zenzeŋaŋ, ‘Kilais ek amobotnaŋ Dewitgat sokŋaŋ keyepmti egaŋ Dewitgalen mka ŋotakŋan Beteleem sokbembeyet zenzeŋaŋ.’” ");
INSERT INTO naf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Am ekŋenaŋ Zisasiyet zet kegok zemti ilinak kalaŋbien. ");
INSERT INTO naf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mti am notnaŋ ekŋenaŋ Zisas atamti met mka katikŋan pesât mbienaŋgut belak peme tage. ");
INSERT INTO naf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Âpme sesewat mka temaŋgalen antipdakutum zemindeme mebien ekŋenaŋ naman belak etaŋ gilik zemti Palisi ma sâpe sâpe bumbu ekŋengalen an ŋeŋaŋ ekŋenmagen mepme indikti ekŋenaŋ pigok indayaŋkwesiwien, “In zigogat Zisas wawapiŋ belak pi kolip?” ");
INSERT INTO naf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Indayaŋkwesime ekŋenaŋ zewien, “Egaŋ zet manzein kegok ke an ŋenaŋ zet keboŋ penaŋ ŋen ŋep ku zenzeyelen keyepmti nâmtemtem mti ku atan kotnup.” ");
INSERT INTO naf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Zeme Palisi ekŋenaŋ pigok diindowien, “In egaŋ keŋin kegogak myuŋgup mene wa kapi? ");
INSERT INTO naf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","In ekme sâpe sâpe bumbu ekŋengalen an ŋeŋaŋ ma Palisi an ninmagengatnaŋ notnaŋ ekŋenaŋ egat zetnaŋ ŋen nâmkiŋpeme ekbien? ");
INSERT INTO naf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Am ek mâti tapmaip ekŋen ke Mosesiyelen zii zet kapi ku weyaŋ manâmâtâlip keyepmti am ekŋen ke maneti bamgat Kawawaŋaŋ indawalebe.” ");
INSERT INTO naf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Âpme Palisi an ekŋengat tuŋgupwinangatnaŋ an ŋen kwitnaŋ Nikodimas. An keyaŋ itnaŋaŋ tambuyet moti Zisasmak zapat mbun. Ek keyaŋ notnane ekŋengat pigok zeye, “In nin an ŋen yomaŋmak ma yek keyet yaŋaŋaŋ nânâpiŋ belak etaŋ gakikiyet zetnaŋ zemdelaŋ zenzeyet zetnaŋ ŋen zii zelen meluwaŋ mimiŋaŋ ŋen ku tazin.” ");
INSERT INTO naf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Zeme notnane sambe ekŋenaŋ pigok dunduwien, “Geŋmak ek msalit Galili kwepgapmti m aŋgalaŋ pemti tazenik? Geŋ Kawawaŋgalen zet meluwaŋ itnaŋaŋ mimiŋaŋ ke weyaŋ maiŋti keyet nânâ mulup omba mbegen An Kawawaŋaŋ ombempeye ke sokbembeyet zenzeŋaŋ ke Galili msalen kapi ku sokbembeyet zenzeŋaŋ ekbek.” ");
INSERT INTO naf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mti ondedagen zet mmot mtot mti belak kalaŋti ekŋenaŋ mkaŋinan mekopme Zisasiyaŋ Olip Kalaŋan mowege. ");
INSERT INTO naf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","2","Zisasiyaŋ Olip Kalaŋan ke mopmanepeme msame toti sesewat mka temanen mowepme am sambe penaŋaŋ ek ekti ekmagen met pende pende tapmme egaŋ ke totati Kawawaŋgalen zet zapat dolakŋaŋ tadiindome ");
INSERT INTO naf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","kan keyet Palisi ma an zii zet zikat indanda an ekŋenaŋ imbi ŋen set kileŋ mame ekti wati met am tuŋguwinan onzempemti Zisasiyet zewien, ");
INSERT INTO naf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“An zikat indanda, imbi kapi apmaŋ pemti met set kileŋ manepeme ekti wati gâlen kotnup. ");
INSERT INTO naf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","6","Imbi ekŋen kaboŋ kapi nin nanzaŋ timti indomann gakikiyet Mosesiyaŋ zii zelen zemâtâtndaye.” Ekŋenaŋ, “Nin yaŋkwesimann Zisasiyaŋ zet zigok ŋen zeme ekti wati zelen met pesenup,” zemti pigok yaŋkwesiwien, “Amobotnaŋ imbi kapi zigok msasenup ze zemane nâne?” Zeme Zisasiyaŋ kusum tati betnaŋ yuyaŋ msalen baen meluwaŋ takumaŋge. ");
INSERT INTO naf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Âpme ekŋenaŋ yaŋkwesim giŋgiŋ penaŋ mme egaŋ nâmtage tageyaŋ yek bemeŋgut teŋ zem wat indikti pigok diindoye, “Inmagengatnaŋ an ŋen yomepiŋ kwetetepmaŋ penaŋ main egaŋ yaŋbemti imbi kapi nanzaŋaŋ kukŋaŋgat kumeŋgut in sambeyaŋ kummeti kume gakisem.” ");
INSERT INTO naf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Zemindamti egaŋ ewe kusum toti msalen baen betnaŋ yuyaŋ meluwaŋ takumaŋge. ");
INSERT INTO naf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Âpme ekŋenaŋ ilinak pe an kwiyaŋ yaŋbem kume ekti kusenup zemti meek koek mbienaŋ yek beme an penaŋ penaŋ ŋeŋaŋ yaŋbemti pakpak kwep kwep toti kwawet mme eyetnan am notnaŋ ekŋenaŋ tapmetne metne peme delaŋ zemâge. Âpme imbi kemak Zisasmak ilidak etaŋ tabun. ");
INSERT INTO naf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Âpme Zisasiyaŋ teŋ zem wati ekme imbi piwan igak tapme ekti zeye, “Am gosâgât kot tapmmo ekŋen pi wan de melo? An ŋenaŋ tati geŋ ku gonak?” ");
INSERT INTO naf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Zeme imbiyaŋ pigok zeye, “Amobotnaŋ, am pi kunzuŋ mepme delaŋ zep.” Âpme Zisasiyaŋ zeye, “Neŋ kegogak yomdaŋgat dopmaŋ ŋen ku zemgoŋgoyelen. Geŋ mepmamti set kileŋ mama manik ke pemane tabe.” ");
INSERT INTO naf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Âpme kan ŋengat Zisasiyaŋ sesewat mka temaŋ keŋan tati am zet ŋen pigok diindoye, “Neŋ msat sambe bekapiyelen taŋam keyepmti am ŋenaŋ neŋ napmâti mamambe beme egaŋ tambusosok keŋan ku mambe. Ek nâlen busatnaŋaŋ mbusatnaŋ bempeme egaŋ ekmâtâti mama dolakŋaŋ mambe.” ");
INSERT INTO naf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kegok zeme Palisi ekŋenaŋ pigok dunduwien, “Pi gitiyegak yaŋaŋdi dinndonik kapi nâmann penaŋ ku bein.” ");
INSERT INTO naf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Zeme Zisasiyaŋ pigok diindoye, “Neŋ nanaŋgat yaŋŋ zeyap kapi penaŋepiŋ ku bein. Neŋ deyetnaŋ koban ma maneti naman deeset mebap e nâmâtâtati tazeyap. Âpme in ke ku nâmti belak kileŋ tazeip. ");
INSERT INTO naf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","In neŋ zet zeya keyepmti ilinaŋgalen nânâŋinaŋ ma mama mimiŋin mamimkwalip ke nâmti keyet kataŋ zet muluwen neip. Âpme neŋ am zet muluwen nenak ku pepeyelen. ");
INSERT INTO naf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Neŋ kwileki ŋeniyet am ŋengat zetnaŋ zemdelaŋ zesâti esemteŋ penaŋ zemdelaŋ zempewak. Neŋ am zet muluwen indendeyet mulup e nenak etaŋ ku mamiyap. Bien zemneme koban egaŋ napmukulem mnemeŋgut nilisakwep ŋep mimiyelen. ");
INSERT INTO naf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ilinaŋgalen zii zelinan zetgat yaŋaŋ kapigok tazin, ‘An zulaŋ an ŋeniyet yaŋaŋ kok kok main zemalu amnaŋ nâme penaŋ mambein.’ ");
INSERT INTO naf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Âpme neŋmak Bipm zemneme toban nit nilisakwep nâgât yaŋŋ bandim mti manzemkawaŋbein keyepmti neŋ nanaŋgat zema zetn penaŋ mambein.” ");
INSERT INTO naf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Zet kegok diindome ekŋenaŋ pigok yaŋkwesiwien, “Bipdi pe deset tapme tazenik?” Zeme pigok diindoye, “In nâgât yaŋŋ ku maekmâtâlip keyepmti Bipm kegogak ku manâmâtâpeip. In nâgât nâmâtâbiek ze Bipm kegogak nâmâtâpewiek.” ");
INSERT INTO naf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zisasiyaŋ Kawawaŋgat tewalaŋ mânep bembe boŋgis matatan mka keŋaŋ keyet keŋan tati am zet zapat dolakŋaŋ tadiindometneti zet kapi zeye. Keyepmti am ekŋenaŋ ek wati mka katikŋan met pesât nâmbienaŋgut Kawawaŋaŋ egat kanaŋ beye e ewe ku beye keyepmti atatayet belin nukŋaŋ beye. ");
INSERT INTO naf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mti Zisasiyaŋ ewe pigok tusumti diindoye, “Neŋ indemti mepma in natimapme yek beme bekanaŋin msekpeŋ gakiwembep. Neŋ meti mambap ke in ŋep ku kobep.” ");
INSERT INTO naf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kegok zeme Zuda am ekŋenaŋ zewien, “‘Neŋ mebap ke in ku kobep,’ kegok ke yaŋaŋ kwilekiyet nâmti tazein? Ikŋaŋ sekŋaŋ waleti gakisâgât mene nâmtazein?” ");
INSERT INTO naf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Âpme Zisasiyaŋ pigok diindoye, “In msat kapiyelen am. Âpme neŋ kululuŋen gwaengatnaŋ wan neŋ msat kapiyetnaŋ yek. ");
INSERT INTO naf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Keyepmti neŋ eweŋanak pigok diindoya in yomin melesiŋ maneti gakiwep. In neŋ Kilais mayap ke ku nâmkiŋpemnewep beme in maneti yomin sekpeŋ gakiwembep.” ");
INSERT INTO naf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Zeme nâmti pigok yaŋkwesiwien, “Âpme geŋ kwi? Ze zemane nâne.” Zisasiyaŋ pigok diindoye, “Neŋ ilak yaŋŋ zemkawaŋ bemindama nâmâlo kemak. ");
INSERT INTO naf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Neŋ ingalen nukŋaŋ sambe weme ekti ŋep zemindondoyelen yaŋgut belak ekpemti mamayap. An zemneme toban egaŋ keyet zet esemteŋ zemti dopmaŋ mutumindawe. Âpme neŋ belak zetnaŋ zeme eknâm mban ke etaŋ msalen kapi mamti am sambe kapiyet sosok manzemkawaŋ bemindayap.” ");
INSERT INTO naf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Zisasiyaŋ Bipmaŋgat zapatnaŋ kegok diindome amobotnaŋ ekŋenaŋ ku weyaŋ nâmâtâbien. ");
INSERT INTO naf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Keyepmti Zisasiyaŋ tusumti ewe pigok diindoye, “In Angat Nemuŋaŋ neŋ tewen nâmti mwat onzemnemtiŋgut neŋ Kilais keyet yaŋaŋ weyaŋ ekmâtâbep. Neŋ wa mulup mamiyap kapi nanaŋgat windeyet mamiyap yek. Bienaŋ zet zemâtâtneŋge keyet kataŋ zet am manzemâtâtindayap. ");
INSERT INTO naf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","An zemneme toban ek neŋmak mamain. Âpme neŋ mulup sambe zemti mma egaŋ manigoin keyepmti egaŋ ku manemezin.” ");
INSERT INTO naf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Zet kegok zeme am sambeyaŋ zetnaŋ ke nâme penaŋ beme nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Âpme Zuda am Zisas nâmkiŋpewien ekŋen keyet pigok diindoye, “In neŋ zet diindoyap keyet katnanen mamti nemunambanne penaŋ bewep. ");
INSERT INTO naf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","In nâlen zet ke mâti keyet kataŋ mame keyaŋ bekanaŋgalen kikitek ke elaŋgemindeme neŋmak tusumti belak lala mambep.” ");
INSERT INTO naf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Âpme am notnaŋ Zisasiyet ku nâmkiŋpewien ekŋenaŋ zet ke nâmti zet dopmaŋ pigok dunduwien, “Nin Abalaamgat nemunambaŋane nin an kwiyaŋ ndaŋgalaŋti kandaŋan ndeme matatnupgapmti geŋ ningat, ‘In kikitekŋin e kwalet indema belak lala mambep.’ Pi zenik?” ");
INSERT INTO naf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Zeme Zisasiyaŋ pigok diindoye, “Neŋ penaŋ sukwep pigok diindoma nâit. An ŋen yom mamimambe beme an ke yomgat kandaŋan meti egat sisiliŋ muluwetaŋ mamimambe. ");
INSERT INTO naf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sisiliŋ an egaŋ amobotnaŋ egalen mkaen kwesiŋ matazin keyaŋgut nemuŋaŋ yek. An keyet nemuŋaŋ penaŋaŋ kelak ikŋaŋgat nemuŋaŋ. ");
INSERT INTO naf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Keyepmti Kawawaŋgat Nemuŋaŋ neŋ yomgalen kikitek keŋan mamti sisiliŋ mulup mamip ke kalutindewap beme in belak lala penaŋ mambep. ");
INSERT INTO naf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","In Abalaamgat iŋsokŋane e neŋ nâmindeyap. Keyepmti neŋ zet diindoma zetnnaŋ belak ingat sekŋinan mot kumti gwalalaŋ kumti matozin keyepmti in neŋ nosât manzeip. ");
INSERT INTO naf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Neŋ Bienaŋ kwitnaŋ kwitnaŋ zikat name ekban keyet zapatnaŋ mandiindoyap. Âpme in biwineyaŋ kwitnaŋ kwitnaŋ zikat indawien ke mamip.” ");
INSERT INTO naf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Zeme pigok dunduwien, “Ningat bipm Abalaam.” Zeme Zisasiyaŋ pigok diindoye, “In Abalaamgat nemunambaŋane penaŋ mambiek ze Abalaamaŋ Kawawaŋgat zetnaŋ kandaŋan mamamtan keyet sepem mamambiek. ");
INSERT INTO naf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Neŋ Kawawaŋgalen zet penaŋaŋ kapi mandiindoma in naman nâme dâsuki beme nosât mamip. Abalaamaŋ muluwaŋ bekanaŋ keboŋ ke ŋen ku mge. ");
INSERT INTO naf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","In biwinaŋgalen set mâti mamip.” Âpme ekŋenaŋ pigok zewien, “Nin an ŋenmagengatnaŋ ku sokbewenn; Kawawaŋ ek ningat Bipm penaŋ.” ");
INSERT INTO naf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Zeme Zisasiyaŋ pigok zeye, “In Biwin Kawawaŋ ze in Egaŋ neŋ zemneme toban keyepmti in neŋ ŋep notn mnewiek wa neŋ nanaŋgat keŋnaŋ galak etaŋ ku toban Kawawaŋaŋ ikŋaŋ zemneme toban. ");
INSERT INTO naf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","In zigogat penaŋgapm keŋ katik mmame neŋ zetn zema keŋinan ku matowezin? Ma zigogat neŋ zet zema wakŋin ku mambeip? ");
INSERT INTO naf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","In biwin Sadaŋ keyepmti egaŋ zemâtâtindame egalen nânâen mulup mamip. An ke eweŋan am indawalelet mulup mgeyaŋ ewe mamimkwazin. Egaŋ Kawawaŋgalen zet bamkumpeye keyepmti egat keŋanen zet penaŋ zenze ke ŋen ku matazin. Ek zet dâsuki zenze keyaŋ mama mimiŋaŋ beyeyepm ek an dâsukitoŋ ma zet dâsuki zenze ke bipmaŋ ek. ");
INSERT INTO naf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","In egat kandaŋan meti mamaip keyepmti neŋ Kawawaŋgalen zet penaŋ kapi diindoma in ke nâmti zetn ke ku manâmkiŋpeip. ");
INSERT INTO naf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Inmagen an ŋenaŋ nâlen yomm ŋen zemkawaŋ bemname nâsap? Neŋ an teŋ penaŋ mamayawaŋ zet zapat dolakŋaŋ kapi diindoma in kwilekiyet penaŋ zetn ku manâmkiŋpeip? ");
INSERT INTO naf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Am Kawawaŋgat zapat mamaip ekŋenaŋ Kawawaŋgat zetnaŋ manâip. Âpme in Kawawaŋgat zapat ku mamaip keyepmti in zetnaŋgat wisat mamip.” ");
INSERT INTO naf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Zeme Zuda am ekŋenaŋ zet dopmaŋ pigok gilik zemti sawien, “Nin kegogapmti manzenup Samalia an geŋ kapi we bekanaŋaŋ keŋdan tapme zet kileŋ kileŋ tazenik.” ");
INSERT INTO naf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Zeme Zisasiyaŋ pigok diindoye, “Neŋ we bekanaŋaŋ keŋŋ ku mimyuŋguin. Neŋ Bipm Kawawaŋgat kwitnaŋ mamwapeyap. Âpme ingulak neŋ niktalati selaŋ nime belakŋaŋ penaŋ mambeyap. ");
INSERT INTO naf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wa neŋ nanaŋgat kwizapatn temaŋ bembeyet nâmti mulupmaŋ ku mamiyap. Nâgât kwizet buŋamm mwati zenze mulup ke An ŋenaŋ mbe. An ke zemdelaŋ zenze anaŋ mbe. ");
INSERT INTO naf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Neŋ zet penaŋ pigok diindoma nâit, An ŋenaŋ nâlen zet gawepumti mim mambe beme ek gakikiyelen set ku aikbe.” ");
INSERT INTO naf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kegok zeme Zuda am ekŋenaŋ pigok zewien, “We bekanaŋaŋ keŋanen tazin zet e penaŋ tazenup! Abalaam gakiye ma golaŋ zenze an ekŋen sambe kegogak gakimâbien. Âpme geŋ na zet pigok tazenik, ‘An ŋenaŋ nâlen zet kapi gawepumti mambe beme egaŋ ku gakiwe.’ ");
INSERT INTO naf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bipm Abalaam temaŋ bepiwan gakiye. Âpme geŋ bukapiyaŋ ek sebempesâgât zenik? Golaŋ zenze an sambe bepi kegogak gakime delaŋ zemâge. Âpme geŋ ziboŋ penaŋgapm kok zemti gitaŋgat sekdi omba penaŋ mmodik?” ");
INSERT INTO naf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Zeme Zisasiyaŋ pigok diindoye, “Neŋ nanaŋgat sekŋ mmopma ŋep penaŋ ku benak. Bipm in egat, ‘Kawawaŋŋ,’ manzeip egaŋgut nâgât kwizet buŋamm mamwazin. ");
INSERT INTO naf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","In ek ke ku maweyaŋ nâmâtâpeip âpme neŋgut ek manâmâtâpeyap. Neŋ zigok dâsuki ke ek ku nâmpeyap zesap e mtilak in nemboŋ an dâsukitoŋ besapgat. Neŋ egat yaŋaŋ nâmâtâti keyepmti zetnaŋ maŋgawepuyap. ");
INSERT INTO naf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Biwin Abalaam ke neŋ kopma niknikgat keŋaŋ seŋme muluk kaik matatan. Yaŋ nen koban kapiyet belak sesepmaŋ Kawawaŋaŋ zikat same ekti keŋ oloŋen penaŋ nâŋge.” ");
INSERT INTO naf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Zeme Zuda am ekŋenaŋ zewien, “Geŋ ewe anemba nup kandi 50 bembepiŋ bukapiyaŋ Abalaam zigoset ekbanan?” ");
INSERT INTO naf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Zeme Zisasiyaŋ pigok zeye, “Neŋ penaŋ pigok zema nâit, neŋ Abalaam ewe sokbembepiŋ tapme mambanaŋ ewe mamamkwalap.” ");
INSERT INTO naf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kegok zeme ekŋenaŋ ŋeŋin zime nanzaŋ timti kusât mme egaŋ buzak am keŋan keŋanset sesewat mka temaŋ pemti zupman toweti mege. ");
INSERT INTO naf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Zisasiyaŋ kunzuŋ toti nembaŋane ndatime nsakwep selen tapmetneti selen ke an ŋen zikatnaŋ beŋaŋ mamkeŋ keboŋ sokbembeŋaŋ aikbenn. ");
INSERT INTO naf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aikti nin Zisas pigok yaŋkwesiwenn, “An zikat indanda, an kapi kwiyelen yomgat zikatnaŋ beŋaŋ kapi mamkeŋ sokbeye mamaŋ bipmaŋ egetgalen yomgat ma nemba kapi ikŋaŋgalen yomgapmti kapigok sokbeye?” ");
INSERT INTO naf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Zemann Zisasiyaŋ pigok dinndoye, “Wa ke mamaŋ bipmaŋgalen yomgat ma ikŋaŋgalen yomgapmti kegok ku sokbeye. Kawawaŋgalen winde ke ekmagen sokbemkawaŋ bembeyet ek keboŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nin an zemneme koban egalen mulup ewe kasup tapme kapiyet tapmmambanup. Yaŋ kan ŋeniyet msat tambuwe beme ilak mulup mimiyet setnaŋ yek bewe. Zet kapiyet yaŋaŋ pigok zemâtâpma nâit: Nin ewe alik mamti kan kapiyet An zemneme toban egalen mulup mbanup. Maneti gakiwanup beme egalen mulup ŋen ku mimiyelen. ");
INSERT INTO naf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Neŋ msatgalen busatnaŋgapmti neŋ msalen kapi mamamti am mambusatnaŋ bemindeyap kegok mti am ŋoktikŋin mkawaŋ bema ekŋenaŋ Kawawaŋgat yaŋaŋ manâmâtâlip.” ");
INSERT INTO naf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kegok zemti zawagaŋ msat wasekpemti lelimâpme bakŋaŋ beme mkwati zikat sâkŋanen witiliwaŋ zulutpemti pigok zempeye, ");
INSERT INTO naf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Geŋ meti Siloam lemuŋan ke zimosedan witilip kapi zulupmane kwawesem.” (Siloam zet keyet yaŋaŋ Zempeme mege). Âpme an piwan meti zimosetnaŋ tuyen zuluti zikatnaŋ dolakŋaŋ beme mkaŋaŋ gilik zemti kopme ");
INSERT INTO naf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","am notnane ma am notnaŋ mânep milawatgat mawekumindame ektemien ekŋenaŋ ekti ilinak dopmaŋ yaŋkwesim yaŋkwesim mti zewien, “An kapi selen totati nin mânep milawatgat mawekumndain wan an kapi?” ");
INSERT INTO naf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Âpme am notnaŋ ekŋenaŋ zewien, “An ikŋaŋ kapimak,” zeme notnaŋaŋ, “Yegat,” zemti, “An kapimak ŋenmak egat sepemit kwepgat.” Kegok zeme an ikŋaŋ keyaŋ pigok zeye, “Nenen mânep milawatgat mawekumindayap kemak.” ");
INSERT INTO naf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Zeme pigok yaŋkwesiwien, “Geŋ zigok mti zikadi ekdak?” ");
INSERT INTO naf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yaŋkwesime pigok diindoye, “An ŋen kwitnaŋ Zisas an keyaŋ zawakŋaŋmak msatmak lumaŋti zikatn sâkŋan gwaen kaput nemti pigok dinop, ‘Geŋ Siloam tu lemuŋan meti witilip zulupmane melak’ zemnep. Âpme neŋ meti zikatn sâkŋanen witilip kaputnep ke zulupma mepme zikatn pembenaŋ beme ega.” ");
INSERT INTO naf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kegok zeme pigok yaŋkwesiwien, “An ke deset tazin ke geŋ nânik?” Yaŋkwesime zeye, “An ke pe deset tazin ke neŋ ku nâyap.” ");
INSERT INTO naf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Âpme am ekŋenaŋ an zikatnaŋ ege ke Palisimagen wati mebien. ");
INSERT INTO naf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Zisasiyaŋ an zikatnaŋ zawakŋaŋmak msatmak lumaŋti zikatnaŋ weyaŋpeye ke Sabat tagoŋgo kanen mge keyepmti wati mebien. ");
INSERT INTO naf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mepme Palisi an ekŋenaŋ ewe pigok yaŋkwesiwien, “Geŋ zikadi pe zigok mti ekdak?” Yaŋkwesime pigok diindoye, “Neŋ msalaŋ zikatnan zulutneme met tuyen zuluti zikatn ega.” ");
INSERT INTO naf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Zeme Palisi ekŋenmagengatnaŋ an notnaŋaŋ pigok zewien, “An zikadi weyaŋpeye ek Kawawaŋgalen mulup an yek. Keyepmti nin Sabat tagoŋgo kanen ke tapmann egaŋ tagoŋgo sutnan penaŋ mulup mip.” Zeme notnaŋaŋ pigok zewien, “Ek a yomtoŋ mamanak ze egaŋ mulup keboŋ ke zigok mnak?” Kegok zemti ilinak zet mmot mtot mbien. ");
INSERT INTO naf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mti an zikatnaŋ beŋaŋ weyaŋpeye ek sek tuk ewe pigok yaŋkwesiwien, “An zikadi weyaŋgep an keyet geŋ zigok nâmpenik?” Yaŋkwesime egaŋ pigok zeye, “An ke neŋ nâmpema golaŋ zenze an ŋen bein.” ");
INSERT INTO naf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Âpme Zuda amobotnaŋ ekŋenaŋ an kapi pe zikatnaŋ beŋaŋ kapuk sokbeye. Zemti keŋ zut mbienaŋ yek beme mamaŋ bipmaŋ idazemtetime kopmalu pigok idayaŋkwesiwien, ");
INSERT INTO naf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Nemuŋit kapi ilak penaŋ zikatnaŋ beŋaŋ sokbeye? Ek zigok mti zikatnaŋ egap ke it bugan nâlup?” ");
INSERT INTO naf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Idayaŋkwesime mambipmanelaŋ pigok zewun, “Ek nigat nemunit penaŋ okakŋanak zikatnaŋ beŋaŋ sokbeye e nit ŋep nâlup. ");
INSERT INTO naf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yaŋgut naman zigok mti zikatnaŋ egap ma an kwiyaŋ zikatnaŋ weyaŋpep ke nit ku nâlup. Ek ilak an temaŋ kwitnaŋ kwitnaŋ ikŋaŋ nâmâtâtâtnaŋmak keyet ikŋaŋ weyaŋ yaŋkwesime diindome nâit!” ");
INSERT INTO naf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Zuda amobotnaŋ ekŋenaŋ zet kapigok zemkatik bewien. An ŋenaŋ Zisasiyet Kilais zewe beme ek mâpman paset zupman belakŋan mebe zewien keyepmti mamaŋ bipmaŋ egelaŋ Zuda amobotnaŋ ekŋengat kiŋgati zet pigok zewun, “Ek ilak semem delaŋ zenzeŋaŋgat ikŋaŋ yaŋkwesime yaŋaŋaŋ diindome nâit!” ");
INSERT INTO naf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Zemalu ekŋenaŋ an zikatnaŋ bekanaŋ weyaŋpeye ke ewe zeme kopme pigok dunduwien, “Geŋ Kawawaŋgat zikatnan zapadi penaŋ penaŋak zemane nâne. Nin an weyaŋgep keyet yaŋaŋ nânup an ke an yomtoŋ.” ");
INSERT INTO naf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Zeme an keyaŋ pigok diindoye, “An ke an yomtoŋ ma yek ke neŋ yaŋaŋ ku nâmâtâlap. Yaŋgut neŋ eweŋan zikatn beŋaŋ mamtemanaŋ egaŋ mme zikatn ekman e penaŋ nâmtalap.” ");
INSERT INTO naf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Zeme ewe pigok yaŋkwesiwien, “Pe sepem zigok penaŋ mti zikadi mme ekmanan?” ");
INSERT INTO naf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yaŋkwesime pigok diindoye, “Neŋ zet elak diindoma nâyo e ewe ku nâmâtâlo. Eneyet zet ewe ikŋaŋ keyegak diindoma nânâyet tatnayaŋkwesip? In egat kandaŋan meti egat nembaŋane bembeyet nâmti tatnayaŋkwesip?” ");
INSERT INTO naf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Zeme kwelatnaŋ kumti zewien, “Egat nemuŋaŋ elak geŋ kapimak ningut Mosesiyet nembaŋane. ");
INSERT INTO naf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moses ek Kawawaŋaŋ zet dunduye e nin nâmtatnup. Âpme an ke deeset sokbemti mulupmaŋ tapm kozin ke nin ku nâmpenup.” ");
INSERT INTO naf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Zeme an keyaŋ zet pigok gilik zemindaye, “In an zikatn weyaŋnep egat sokbembeŋaŋgat kanda zenze mulup mme neŋ nâmtemtem penaŋ mimindeyap. ");
INSERT INTO naf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kawawaŋaŋ am yomtoŋ ekŋengalen dundunduŋin ku manâin ke nin nânup. Egaŋ am kwizet buŋamaŋ mamopeip ekŋen etaŋ manâmindein. Egaŋ ikŋaŋgalen nânâŋaŋ ke amnaŋ mimiyet nâmbiliwege. ");
INSERT INTO naf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nin msat kululuŋ sokbembeŋangatnan alak pi tatnup pi an ŋenaŋ am zikatnaŋ beŋaŋ ŋen weyaŋpepeŋaŋ keyet zapatnaŋ ŋen ku manânup yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Keyepmti an ke Kawawaŋmagengatnaŋ ku kodak ze mulup kegok ke igak zigoset mnak?” ");
INSERT INTO naf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Zeme pigok dunduwien, “An bekanaŋ yomdimak mamkwabananaŋ ewe mamanik geŋ bukaboŋaŋ nin kapi set zikat ndasât tazenik?” Kegok zemti sesewat mkaengatnan zempeme zupman toti mege. ");
INSERT INTO naf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Zempeme paset zupman mege zapat ke amnaŋ ilinak zenâ zenâ tapmmepme Zisasiyaŋ wak kambu nâŋge. Keyepmti an ke selen aikti pigok yaŋkwesiye, “Geŋ Angat Nemuŋaŋ egat nâmkiŋpenik ma yek?” ");
INSERT INTO naf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Âpme an keyaŋ zeye, “Amobotnaŋ, geŋ zenik ke an kwi ze zikat namane ekti ŋep nâmkiŋpempewi!” ");
INSERT INTO naf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Zeme Zisasiyaŋ pigok dunduye, “Neŋ zet tadiŋgoma tatniknik an elak neŋ kapimak.” ");
INSERT INTO naf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Zeme an keyaŋ zeye, “Amobotnaŋ, neŋ penaŋ nâmkiŋpemgeyap.” Kegok zemti tot pedondom samti sesewatpeye. ");
INSERT INTO naf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Âpme Zisasiyaŋ pigok zeye, “Neŋ am yaŋaŋin mimsokbembeyet msalen toban keyepmti am notnaŋ zikalin beŋaŋ ekŋenaŋ zikalin dolakŋaŋ ekbep. Âpme am zikalin ekti mamaip ekŋenaŋ zikalin naman beŋaŋ bewe.” ");
INSERT INTO naf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kegok zeme Palisi am ekmak ilinsakwep tabien ekŋenaŋ zet ke nâmti pigok zewien, “Zeme nin mee kogok zikatn beŋaŋ nâmndenik?” ");
INSERT INTO naf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Zeme Zisasiyaŋ pigok diindoye, “In an zikalin beŋaŋ mamambiek ze in yominpiŋ mamambiek. In ilinaŋgat, ‘Nin an zikatn beŋaŋ yek,’ manzeip keyepmti in yominmak mamaip.” ");
INSERT INTO naf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Zisasiyaŋ zet ŋen pigok zeye, “Neŋ zet penaŋ sukwep pigok diindoma nâit, An ŋenaŋ sipsip ekŋengalen kimbalen towesâgât egaŋ set penaŋ tapme kimbat dukŋaŋ belakŋaset aŋgosomti towebe beme an ke kambutoŋ ma an sage kuku toŋaŋ kegok zewanup. ");
INSERT INTO naf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","An ŋenaŋ set tokwakwaleset meti sipsip ekŋenmagen mebe beme an ke sipsip toŋaŋ penaŋaŋ mowezin nâmpewanup. ");
INSERT INTO naf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mopme setokwakwat damuŋ egaŋ ek sipsip toŋaŋ penaŋ e ekmâtâti kwalet peme moti sipsip kwilinan kwilinan indakumtetime toŋinaŋgat bim ŋandaŋaŋ nâmti ekmagen kopme indatimti zupman baen matowezin. ");
INSERT INTO naf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ikŋaŋgat zapat ke indatimti zupman toti mepme ekŋenaŋ bim ŋandaŋaŋ nâmti ekmâti mamâmelip. ");
INSERT INTO naf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ekŋenaŋ an bimŋandaŋin mamanamaŋ ekŋen ku maindamâti melip. Ekŋenaŋ bimŋandaŋin sepemaŋ igak ke nâmti makiŋgakunzuŋip.” ");
INSERT INTO naf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zisasiyaŋ am ningat nâmti bemzenze zet sipsip palen bemti zeme am ekŋenaŋ pe bemzenze zet kapi yaŋaŋ kwilekiyet zein ke ku nâmâtâbien. ");
INSERT INTO naf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Keyepmti Zisasiyaŋ bemzenze zet kapiyet yaŋaŋ kapigok zeye, “Neŋ penaŋ sukwep penaŋ diindoma nâit, sipsip ekŋengalen setokwakwat e neŋ. ");
INSERT INTO naf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Neŋ ewe sokbembepiŋ tapma am tetimaemae ŋeŋaŋ sokbemti inmagen kobien ekŋen an kambu titinok mamti zet dâsuki, ‘Neŋ Kawawaŋaŋ an zempeme kosât zetik mge nen kapi,’ zemti mambien keyepmti nâlen am ekŋenaŋ zelin ku mâbien. ");
INSERT INTO naf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Âpme neŋ amgalen sekekek keyepmti am ŋenaŋ neŋ nâmkiŋpemneinen ek aŋgalaŋ pewap. Neŋ ekŋen indikdamuŋ mimindema mamambep. ");
INSERT INTO naf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Âpme an kambu titi ekŋenaŋ belak buzakset moti kwitnaŋ kwitnaŋ kumsagat mti sipsip mee kileŋ indomkumti notnaŋ buzak kambu indatimti mesâgât makolip. Yaŋgut neŋ sipsip ekŋen indadamuŋ dolakŋaŋ mimindema ekŋenaŋ kakanemuŋ mamti mamobep. ");
INSERT INTO naf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Âpme neŋ sipsip toŋaŋ penaŋ keyepmti ekŋenmagen kwileki ŋen sokbeme ekŋengapmti ŋep gakiwap. ");
INSERT INTO naf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mme sipsip damuŋ belak tosayelak etaŋ nâmti mamin ek toŋaŋ penaŋ yek keyepmti mulup wisat palen tapneti ekme tam zupmaŋ ŋenaŋ sipsip indim nsât kwindiŋ kwapme ekti sipsipgat yayaŋ mimipiŋ ketalat indemti yayaŋaŋgat kunzuŋme tam zupmaŋaŋ kwati indimâpme makalaŋ mekolip. ");
INSERT INTO naf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ek sipsip damuŋ penaŋ yek keyepmti egaŋ sipsip ekŋengat yayaŋ mimipiŋ kiŋgati makunzuŋzin. ");
INSERT INTO naf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Neŋ sipsip ekŋengat toŋin penaŋ mamayap keyepmti Bienaŋ nâgât mama miminnaŋgat yaŋaŋ dolakŋaŋ nâmnein mme neŋ kegogak egat nâmâtâpeyap. Sepem kegogak neŋmak sipsip maŋganne nin dopmaŋ nâm dopmaŋ nâm mti maŋga kwep mamanup. Keyepmti kwileki ŋen sipsipmagen sokbeme neŋ sipsip ekŋengapmti maman ŋep ketalasiwak. ");
INSERT INTO naf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Âpme neŋ sipsip maŋganne notnaŋ ewe maip wa ekŋen kimbat kapiyet keŋangatnaŋ yek. Neŋ ekŋen ke eyo indakakalima kot neŋmak kapi mamti bimŋanden nâme delaŋ zeme sipsiwaŋ maŋga kwep tapme nenn kwep indadamuŋ mbap. ");
INSERT INTO naf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Neŋ maman ketalasimti gakiwap ya naman gilik zem wati maman ke naman tiwap keyepmti Bien Kawawaŋaŋ nâgât nâmneme dolakŋaŋ penaŋ mambein. ");
INSERT INTO naf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","An ŋenaŋ nânâŋak neŋ kileŋ nome ku gakiwap neŋ nen nâmâtâtati mamann ketalasiwap. Ya naman gilik zemti wawagalen winde ke tatnain. Bipmnaŋ neŋ kegok mimiyet nâmneŋge.” ");
INSERT INTO naf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Zisasiyaŋ zet kegok zeme nâmti Zuda am ekŋenaŋ nâme ŋep ku beme ilinaŋgat bet wanok zet mmot mtot mbien. ");
INSERT INTO naf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mti am sambe penaŋaŋ pigok zewien, “An kapi we bekanaŋaŋ keŋaŋ mme yuŋgume zet kileŋ kileŋ tapmme in eneyet momtati zetnaŋ taweyaŋ nâip?” ");
INSERT INTO naf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Âpme naman am notnaŋaŋ pigok zewien, “An ŋen we bekanaŋaŋ keŋan tapme zet dolak dolakŋaŋ kaboŋ kapi ŋep ku zenak. Ma an zikatnaŋ beŋaŋ mee ŋep ku weyaŋpenak.” ");
INSERT INTO naf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Zelusalem sesewat mka kambuk mme belakŋaŋ bembeŋaŋaŋ Omzuluti mme kambuk bembeŋaŋgalen Kendo ke nup kan kataŋ matakwatemien. Yaŋ nup kan kataŋ Kendo ke mawalam keŋan masokbein. ");
INSERT INTO naf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","24","Âpme Zisasiyaŋ sesewat mka temaŋ keyet keŋaŋ ŋen Solomon zeme keyet setokwakwalen ke mebe kokot tapmme Zuda am ekŋenaŋ tokwat bembuluŋ tati pigok yaŋkwesiwien, “Geŋ eneyet yaŋaŋdi sosok penaŋ zemkawaŋ bembepiŋ mmane nin gâgât weyaŋ ku manâmâtâtnup? Geŋ penaŋ Kilais, an Kawawaŋaŋ ombemgeŋgeŋaŋ beme yaŋaŋdi weyaŋ zemâtâtndamane nâne!” ");
INSERT INTO naf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Âpme Zisasiyaŋ pigok diindoye, “Neŋ nanaŋgat yaŋŋ diindoma in ku manâmkiŋpemneip. Neŋ Bipmnaŋgalen windeyet mulup dolak dolakŋaŋ mamiyap keyaŋ nanaŋgat yaŋŋ Kawawaŋaŋ ikŋaŋ zemneme toban ke mammsokbemnain. ");
INSERT INTO naf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Âpme in nâlen sipsip maŋganne penaŋ bemti ku mamaip keyepmti zetn ku manâmkiŋpeip. ");
INSERT INTO naf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Âpme am nâlen sipsip maŋga bemti mamaip ekŋenaŋ bimŋanden nâmti neŋ manamâpmaip. ");
INSERT INTO naf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Keyepmti neŋ mama kanzizit indama walelepiŋ kwesiŋ kwesiŋ mameti mamambep. Ekŋen ke nâlen belengatnan am ŋenaŋ ku indamenzemtimti mebe yek penaŋ. ");
INSERT INTO naf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Am ekŋen ke Bipmnaŋ ikŋaŋ nâlen belen mamayet naŋgeyepmti mame ikŋaŋ maindadamuŋ min. Ek windeŋaŋ igagen penaŋ keyepmti am ekŋen ke an ŋenaŋ nâlen belengatnan ku indamenzem tiwe. ");
INSERT INTO naf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bienmak nit keŋ kwep penaŋ bemti mulup mamilup.” ");
INSERT INTO naf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kegok zeme Zuda am ekŋenaŋ nâme ŋep ku beme nanzaŋ ambepelet timti kusât mbien. ");
INSERT INTO naf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mme Zisasiyaŋ pigok diindoye, “Neŋ mulup dolak dolakŋaŋ sambe penaŋ Biengalen windeen mamima egip. Âpme in mulup mamiyap ke mulup ziboŋ ke ekme bekanaŋ beme nanzaŋ timti nosât tapmip?” ");
INSERT INTO naf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zeme Zuda am ekŋenaŋ zewien, “Wa geŋ mulup dolakŋaŋ maminik keyet mti gosât ku tapminup. Giti zet mobotnaŋ mti geŋ am nin nemboŋak yaŋgut, ‘Neŋ Kawawaŋ,’ tazenik keyepmti gosât pi tapmnup!” ");
INSERT INTO naf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","Kegok zeme Zisasiyaŋ pigok diindoye, “Kawawaŋgalen Zet Itnaŋanen pigok zenzeŋaŋaŋ tazin, Kawawaŋaŋ an zemdelaŋ zenze an mamkwabien ekŋengat pigok zeye, ‘In mulup kegok mamip enenogat in Kawawaŋ nemboŋ.’ Kawawaŋgalen zet sambe ke tapmezin ke anaŋ nin ku omenzaŋpepeyelen yek penaŋ. Âpme neŋ Kawawaŋaŋ ikŋaŋ mulup dolakŋaŋ mimiyet zemdelaŋ zemneme msalen kapi toban keyepmti neŋ Kawawaŋgat Nemuŋaŋ zema in eneyet egaŋ set ku mimiŋ mti Kawawaŋ mtopemti sek mmobot zet tazein manzeip. ");
INSERT INTO naf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","In mulup mamiyap kapi ekme Bipmnaŋgalen kataŋ ku mambein beme zetn kapi bamkumpeme ŋep bewe. ");
INSERT INTO naf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Âk ekme mulupm Kawawaŋaŋ mnak keyet kataŋ mamiyap wa zet manzeyap etaŋ yek. Mulupm mamima egip keeset eyo ekti Bienmak nit keŋ kwep bemti mulup mamilup e ndik mâtâbep.” ");
INSERT INTO naf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kegok diindome ekŋenaŋ ŋeŋin penaŋ zime wati mka katikŋan pene zeminepeme yumbemindemti toti mege. ");
INSERT INTO naf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Meti Zodan tu nembet daen Zânaŋ am tu itnaŋaŋ manzulutindemtanen ke meti mamtan. ");
INSERT INTO naf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ke meti mame am sambeyaŋ ekmagen koti pigok zewien, “Zânaŋ menok ŋen ku mme ekbenn. Âpme Zânaŋ an ikŋaŋ kapiyet nâmti zet sambe zemâge ke an kapimagen penaŋaŋmak etaŋ tasokbemâzin.” ");
INSERT INTO naf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Zemti am sambeyaŋ egat nâmkiŋpemâbien. ");
INSERT INTO naf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani mka msalen ke an ŋen mamtan kwitnaŋ Lasalus ek zawat temaŋ penaŋ mti tapme ipmanet Maliamak Mata egelaŋ ke tati mamomtatemun. ");
INSERT INTO naf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lasalusiyet ipmaŋ Malia kapiyaŋ maneti bam Amobotnaŋ Zisas gakikiŋaŋgalen kan bududuk beme wet kelakŋaŋ sesikŋaŋ dolakŋaŋ penaŋ piyaŋ ek setnanen zulutpemti ŋoksinaŋaŋ kaput pewe. ");
INSERT INTO naf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasalusiyet ipmanet zut keyaŋ iwitdaŋgat yayaŋ mti Zisasmagen zet pigok bemalu mege: “Amobotnaŋ, nodi penaŋ Lasalus piwan zawat temaŋ tapm weingat kot eksenik.” ");
INSERT INTO naf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Âpme Zisasiyaŋ zet ke nâmti pigok zeye, “Zawat keyet penaŋaŋ wa gakiki sokbembeyet yek. Kawawaŋgat Nemuŋaŋ egalen kwizet buŋamaŋ msalen pien palakŋaŋ beme Kawawaŋgat kwizet buŋamaŋ mwat onzempepeyet kegok sokbein.” ");
INSERT INTO naf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Zisasiyaŋ Lasalus ipmanet Matamak Malia ekŋen kemak notn notn dolakŋaŋ mti mamtemien. ");
INSERT INTO naf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Âpme Zisasiyaŋ zapat ke nâmpemti mka keyegak kasup zut pi ewe tage. ");
INSERT INTO naf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yaŋ msame wati Zisasiyaŋ nembaŋane ningat pigok zeye, “Kame naman Zudia mkaenak gilik zemti metne.” ");
INSERT INTO naf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Zeme nin pigok dunduwenn, “An zikat indanda, geŋ alagati kanda manepemane nanzaŋaŋ gosâgât mme kunzuŋti kotn yanaman keyegak gilik zemti mesâgât tazenik?” ");
INSERT INTO naf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yaŋkwesimann pigok dinndoye, “Pi ewe tambuŋanak mulup mimiyelen kan ewe teepmaŋ tazin. An ŋen kasupgat zikatnaŋ ekmâtâti mepme kwileki ŋenaŋ sekŋaŋ ŋen ku mawalezin. ");
INSERT INTO naf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","An ŋenaŋ tambuyet mamezin beme egaŋ busatnaŋ ku tazingapmti tambusosokgat pumpem pumpem olat metiŋgut tep palen ma nanzaŋ palen mee sekŋaŋ mawalezin.” ");
INSERT INTO naf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kegok zemti zet ŋen ewe pigok tusumti ningat zeye, “Notn Lasalus ek zawat mti muluk tawein yaŋ neŋ meti butema wasem.” ");
INSERT INTO naf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Zeme nembaŋane nin pigok zewenn, “Amobotnaŋ, egaŋ zawat mti muluk tawen beme ikŋaŋ ŋep alik bemti wabe.” ");
INSERT INTO naf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Zisasiyaŋ Lasalus penaŋ gakiye ke met mme wawagat nâmti zeye. Âpme nemba nin nâmann zawat mti muluk tawenaŋ met buteme wasem kok nâmti zewenn. ");
INSERT INTO naf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Âpme Zisasiyaŋ naman pigok weyaŋ zemkawaŋ bemndaye, “Lasalus ek tambumbu tuk weŋge yaŋ neŋ meti butema ewe wasem. ");
INSERT INTO naf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Neŋ zawat zapatnaŋ nâmban yaŋgut kapiyegak mamann gakiyan. Âpme neŋ ekmagen mulup mma in ekti nâmkiŋpepe kaliŋaŋ aikbep keyepmti nâma dolakŋaŋ penaŋ bein. Ele kame nin ilak ek eksât metne.” ");
INSERT INTO naf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Âpme ninmagengatnaŋ nemba ŋen kwitnaŋ Tomas kwitnaŋ ŋen Glik zeleset Didimas makumtemien ke ningalen zeleset nemba pepet kok zewanek. Egaŋ nin pigok dinndoye, “Kame nin sambe bepi nsakwep ekmak mepmann ndome gakimâbanup.” ");
INSERT INTO naf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Zisasmak nin ewe kainde maman Lasalus met beme kasup zulak zulak pi sumen weme egaŋ bam mege. Keyepmti kwapataŋ zemann am ekŋenaŋ zewien, “Lasalus ilak tugan bewen.” ");
INSERT INTO naf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani mka ke beŋan penaŋ yek; Zelusalem mka temaŋ keyet sokŋanik. (Mail zut mee kegok mamekotemien.) ");
INSERT INTO naf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Keyepmti Zuda am sambe ekŋenaŋ Matamak Malia iwit gakime ambembesi mimidesât mepmâbien. ");
INSERT INTO naf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Âpme Matayaŋ Zisasmak nin kotnup zeme nâmti weneŋaŋ ke tapme egaŋ windembem toti selen meti ndaige. ");
INSERT INTO naf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kegok mti Zisasiyet pigok dunduye, “Amobotnaŋ, geŋ kapi mambek ze ipm ku gakinak. ");
INSERT INTO naf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yaŋgut alak pigogat geŋ kwileki ŋeniyet nâmti bipdi dundum samane egaŋ keyet penaŋaŋ ŋep mamgain.” ");
INSERT INTO naf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Zeme Zisasiyaŋ pigok dunduye, “Geŋ yayaŋ ku mi, ipdi Lasalus ek ŋep gilik zemti wasem.” ");
INSERT INTO naf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Zeme nâmti Matayaŋ pigok zeye, “Maneti bam kan temanen gilik zemti wabe e ŋep nâyap.” ");
INSERT INTO naf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Zeme Zisasiyaŋ pigok zeye, “Gakikiengatnan wawat ma mama keyet ŋotekŋaŋ neŋ keyepmti am ŋenaŋ neŋ nâmkiŋpemnewe beme gakiwe yaŋgut neŋ ŋep mamaŋaŋ ewe gilik zemsawap. ");
INSERT INTO naf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma am ŋen ewe sekŋaŋ melesiŋ mamti neŋ nâmkiŋpemnewe beme egaŋ gakikipiŋ mamambe. Geŋ neŋ zet zeyap kapi ŋep nâmkiŋpenik?” ");
INSERT INTO naf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Zeme Matayaŋ zeye, “Amobotnaŋ, geŋ Kilais, Kawawaŋgat Nemuŋaŋ, msalen kapi totogat buŋam zapatnaŋ zenzeŋaŋ elak geŋ kapi e penaŋ nâmkiŋpemgeyap.” ");
INSERT INTO naf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Zet kegok zemti met weneŋaŋ Maliayet zeme kopme igak buzak pigok dunduye, “An zikat indanda ilak kotati gâgât tazein.” ");
INSERT INTO naf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Zeme Maliayaŋ nânâŋak wati sakwep Zisasmak nin tabenen mege. ");
INSERT INTO naf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nin mka set biman baen tati Mata zempeme kwapme ewe keyegak totapmambenn. ");
INSERT INTO naf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zeme nâmti Maliayaŋ mka keŋangatnan sakwep wawatnak toti mepme Zuda am ekmak ambembesien tapmambien ekŋenaŋ wa sumen daen susât mezin mene zemti mâti kwatopmâbien. ");
INSERT INTO naf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Âpme Maliayaŋ windembemti mka set biman baen toti ndikme tapmmann Zisas pedondom samti pigok zeye, “Amobotnaŋ, geŋ kapi tabek ze ipm ŋep ku gakinak.” ");
INSERT INTO naf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Zemti sume Zuda am ek mâti mebien ekŋenaŋ ek mukulem mti ambembesi temaŋ mbien. Tapmme Zisasiyaŋ indikti keŋaŋ bekanaŋ penaŋ beme siyaŋ bimaŋ soye. ");
INSERT INTO naf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Some pigok indayaŋkwesiye, “In sekŋaŋ pe denen bemien?” Indayaŋkwesime ekŋenaŋ zewien, “Amobotnaŋ, kopmane meti sumaŋ zikat gaman ekbak.” ");
INSERT INTO naf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Met zikat same ekti Zisasiyaŋ siap ulu alep timti suye. ");
INSERT INTO naf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Sume Zuda am ekŋenaŋ ekti zewien, “An pi an kapimak notn notn penaŋ mti mamalup keyepmti egat tasuin egip.” ");
INSERT INTO naf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Âpme notnaŋ ekŋenaŋ zewien, “An kapi an ŋen zikatnaŋ beŋaŋ ŋen weyaŋpeye keyet zapatnaŋ mekopme nâmbenn. Kogogapm an kapi sakwep kodak ze Lasalus kapi ŋep weyaŋpeme alik tadak.” ");
INSERT INTO naf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Âpme Zisasiyaŋ keŋaŋ ewe bekanaŋ penaŋ beme sum sokŋan penaŋ mebenn. Lasalus gakime sekŋaŋ mti met miŋa keŋan wepemti nanzaŋ temaŋ ŋen wilili peme met einzuŋaŋ bekek tage. ");
INSERT INTO naf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Keyet mti Zisasiyaŋ sumpemti pigok zeye, “In nanzaŋ temaŋ kapi kwanzepeme kaiŋan melak.” Zeme an gakiye keyet mâŋaŋaŋ pigok zeye, “Amobotnaŋ, tambumbu zulak zulak ilak sumen tapme tozin yalak pi sek sesikŋaŋ tapein pi zigogat nanzaŋ kwanzempepeyet tazenik.” ");
INSERT INTO naf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Zeme Zisasiyaŋ pigok dunduye, “Neŋ zet daen diŋgoya e nâmane betetnaŋ bein. Geŋ belak nâmkiŋpem nemane neŋ Kawawaŋgalen winde keyet penaŋaŋ mma sokbeme eksenik.” ");
INSERT INTO naf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","Âpme am notnaŋ ekŋenaŋ nanzaŋ temaŋ bepiwan kwanzepeme mepme Zisasiyaŋ zikatnaŋ kululuŋen gwaen ekme mopme pigok dunduye, “Bien, geŋ dundundun kan kataŋ nâmti manamukulem mnik keyepmti wisikŋ diŋgoyap. Neŋ am maŋge sambe talip ekŋen kapiyaŋ neŋ giti penaŋ zemnemane koban keyet yaŋaŋ ekmâtâtâtgat mulup msât tati diŋgoyap.” ");
INSERT INTO naf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kegok zemti kwizet temaŋ pigok kuye, “Lasalus, geŋ pien kwatot!” ");
INSERT INTO naf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Zeme am gakikiŋaŋ piwan banisiyaŋ setnaŋ betnaŋ kwasim pepeŋaŋ ma ŋokŋaŋ saŋgum meselem zempewien melesiŋ kwatopme Zisasiyaŋ zeye, “In banisiyaŋ betetak temaŋ mpepeŋaŋ e kwalet pemti peme melak.” Zeme kwalet pewien. ");
INSERT INTO naf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Âpme Zuda am sambe Maliayet ipmaŋgat siyet kobien ekŋenmagengatnaŋ am sambe notnaŋaŋ Zisasiyaŋ muluwaŋ mamanamaŋ mme ekti nâmkiŋpempewien. ");
INSERT INTO naf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Âpme notnaŋaŋ belak Palisi ekŋenmagen meti Zisasiyaŋ Lasalus gakikiengatnan mme watage keyet zet zapatnaŋ mimindawien. ");
INSERT INTO naf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Minindame nâmti sâpe sâpe bumbu an ŋeŋaŋ temaŋ ma Palisi egat kandaŋan mambien ekŋenaŋ an ŋeŋaŋ bembe notnaŋ indazemtetime kot ondekme pigok diindowien, “An kapi muluwaŋ mamanamaŋ omba penaŋ am sutnan tapmmezin kapi zigok msawanup? ");
INSERT INTO naf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nin nâmti belak nâmpemti mamann am sambe bepi ekmagen met tusumâpme delaŋ zeme Loma amobotnaŋ manndadamuŋ min egaŋ ekme ŋep ku beme ningalen sesewat mka temaŋ pi kumasek yaloŋti aminne eyo indom yalom bep!” ");
INSERT INTO naf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ekŋengat tuŋguwinaŋgatnaŋ an ŋen kwitnaŋ Kaipas ek kan keyet sâpe sâpe bumbu sambe ekŋengat ŋeŋaŋin mamtan. An keyaŋ pigok diindoye, “In sambe bekapi keŋinpiŋ penaŋ! ");
INSERT INTO naf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nin am sambe bekapi waleletgat zapat etaŋ bemâpmann ŋep ku bewe keyepmti an kwewaŋ ningat dopm gakimti am sambe pi ma nin mee eyo ndamukulem mbe.” ");
INSERT INTO naf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Zet ke belak ikŋaŋgat keŋaŋgalak ku zeye. Kawawaŋaŋ zet ke keŋanen beme zemkawaŋ beye. Nup kan keyet egaŋ sâpe sâpe bumbu sambe ekŋengat ŋeŋaŋin mamtan keyepmti kwitnaŋ kwitnaŋ bam sokbewe keyet zetnaŋ zemkawaŋ beye. Zisas ek penaŋ Zuda am nin yomengatnan gilik zemti ndatitiyet gakikiyet zenzeŋaŋ. ");
INSERT INTO naf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Wa ke Zuda am ekŋen etaŋ indamukulem mimiyet etaŋ ku gakiwe. Egaŋ gakimti am Kawawaŋgalen maŋge msat kataŋ mamanup nin bepi ondekndeme maŋga kwep bemti mamambanup. ");
INSERT INTO naf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Âpme Zuda an ŋeŋaŋ ekŋenaŋ kan keyet yaŋbemti Zisas kume gakikiyet zetnaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Âpme Zisas Zuda amobotnaŋ ekŋenaŋ mineti gakikiŋaŋ temaŋ ewe tapme sutnateman kume gakinakmagengapmti Zuda msalen sosok penaŋ ku maŋge egaŋ nin msat tuŋgupman keyet ganzenan mka ŋen kwitnaŋ Epalaim zeme ke met mamtemenn. ");
INSERT INTO naf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Zuda am ekŋengalen Aŋgalalaŋ Kendoŋin ke sokŋan beme mka isisikŋaŋ am sambe ekŋenaŋ Zelusalem mka teman yominaŋgat nâmti Kawawaŋgat sâpe sâpe busâgât eweŋanak ŋeŋaŋ mepmâbien. ");
INSERT INTO naf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Meti Zuda am ekŋenaŋ sesewat mka temanen motati Zisas zimosetnaŋ timati ilinak met zenâm kot zenâm mti zewien, “An kapi pe Aŋgalalaŋ Kendoyet kapi kopme eksenup manze weyaŋ zeme nâne.” ");
INSERT INTO naf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Zeme Palisi an ma sâpe sâpe bumbu ŋeŋaŋ ekŋenaŋ zet pigok am zemkabem indawien, “Zisas kopme ekti ningat kot sakwep zemsokbemndaseip. Mme nin an ke wati met mka katikŋaŋ pesenup.” ");
INSERT INTO naf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aŋgalalaŋ Kendo tatagalen kasup 6 ewe tapme Zisasmak nin Betani mkaen mebenn. Nin mka ke Lasalus gakikiengatnan mme wage keyet motabenn. ");
INSERT INTO naf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Zisasmak nin mepmann ekti notnane ekŋenaŋ tu meu weyaŋ bume mopme ambepeleti met Matayelen mkaen tapme am zeme moti Zisasmak nin Lasalusmak totapmann Matayaŋ tu meu timti kalop bem ndame nimbenn. ");
INSERT INTO naf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ke tati tatnimann Maliayaŋ wet sesikŋaŋ dolakŋaŋ penaŋ tosaŋaŋ mobotnaŋ penaŋ makwitimtemien ke nukŋaŋaŋ temaŋ pi mkoti keyaŋ Zisasiyet setnan mulapme topme zulutpemti ŋoksinaŋaŋ kapupeye. Âpme mka keŋaŋ tapmambenn bee wet sesik dolakŋaŋ bepiyaŋ pimpemti tage. ");
INSERT INTO naf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Âpme nembaŋane ningat tuŋgupmnaŋgatnaŋ Zudas ek Iskaliot mkaengatnaŋ nemba keyaŋ maneti Zisas bam zemkuwe. ");
INSERT INTO naf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Egaŋ nâmti pigok zeye, “Wet kelakŋaŋ sesikŋaŋ dolakŋaŋ penaŋ kaboŋ kapi belak mti met bemann amnaŋ 300 Kina ndame mti am bekopsat ekŋen indawenek ze ŋep benak!” ");
INSERT INTO naf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Egaŋ wa mânep ke timti am bekopsat penaŋ indasât nâmti ku zeye. Egaŋ ningalen mânep ele nemuŋŋ ke mmamti mânep ndame mwatpemti mânep butnaŋ buzak kambu matim makumkwitim nimtan keyepmti ndame wanok kok mbak nâmti zeye. ");
INSERT INTO naf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Âpme Zisasiyaŋ pigok zeye, “In imbi kapiyet zet sambe zenzepiŋ. Egaŋ wet sesikŋaŋ dolakŋaŋ ke neŋ sekŋ kapi zulutneinen maneti gakima nabembeyet nâmti kwitimti beme matazin yaŋ alak kapi zulutnein. ");
INSERT INTO naf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Am bekopsat sambe ekŋen bepi inmak msalen kapi kan teepmaŋ ewe mamambep mme neŋ inmak kan teepmaŋ ewe ku mambap.” ");
INSERT INTO naf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Âpme Zisasiyaŋ Betani mkaen ke met Lasalusmak mame Zuda am ekŋenaŋ zapatnaŋ nâmti Zisasmak Lasalus an Zisasiyaŋ gakikiengatnan mme wage an ke eyo ilisakwep idiksâgât kobien. ");
INSERT INTO naf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Zuda am ekŋenaŋ Lasalusmageset sâpe sâpe bumbu an ekŋen bamkum indemti Zisas mâti mepmâbien. Keyepmti sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ Zisasmak Lasalus ilisakwep idome gakikiyet zetnaŋ zewien. ");
INSERT INTO naf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Msat msame am sambe penaŋ ekŋenaŋ Aŋgalalaŋ Kendo tasâgât Zelusalem mka kopmâbien ekŋenaŋ zet pigok nâmbien: Zisas ewe selen baen takozin zeme nâmti ");
INSERT INTO naf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ekŋenaŋ niwet sinaŋ mee pi mutum timti Zisasmak nin selen baen ndaiksâgât mepmâbien. Met ndaikti kwizet buŋamaŋ mwati kwizet pigok kumebien, “An kapi Amobotnaŋ Kawawaŋaŋ ikŋaŋ zempeme kozingat Kawawaŋgat kwizet buŋamaŋ mwati sesewatpene! Kawawaŋaŋ ikŋaŋ Islael am ningalen Amobotnaŋ kapi keŋ sewakŋaŋ mpen.” ");
INSERT INTO naf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Keyet Kawawaŋgalen Zet Itnaŋanen kapigok zenzeŋaŋ keyet kataŋ Zisasiyaŋ doŋki nembaŋaŋ ŋen aikti keyet dukŋan totati moge. ");
INSERT INTO naf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Am Zaion mka temaŋ talip in ku kiŋgalit. Amobotnaŋin ilak kozin. Egaŋ doŋki nembaŋaŋ ŋeniyet dukŋan mot totati ingalen kozin.” ");
INSERT INTO naf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nembaŋane nin kwitnaŋ kwitnaŋ sokbeye ke ekbennaŋgut yaŋaŋ ku nâmâtâbenn. Yaŋ bam Zisasiyaŋ gakimti kululuŋen mundumaŋ saŋga soŋgaŋaŋmak keyet keŋan ewe mowepme nin Kawawaŋgalen Zet Itnaŋanen zet keyet yaŋaŋ eknâmâtâti pigok otnâmbenn, “O, an pi sesewatpewenn ke meluwaŋ pi mimiŋaŋ keyet kataŋ penaŋ msawenn.” ");
INSERT INTO naf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Zisasiyaŋ Lasalus gakikiengatnan mme wapme am sambe tati ekbien ekŋenaŋ meti am notnaŋ zet zapat mimindame ");
INSERT INTO naf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","am sambe penaŋ ekŋenaŋ zapat ke nâme delaŋ zeye keyepmti ekŋenaŋ selen meti Zisas aikbien. ");
INSERT INTO naf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aiksâgât selen mepmâpme Palisi ekŋenaŋ indikti ilinak zenâ zenâ mti zewien, “Nin belak zet mulup etaŋ tapmmann am sambe bepi ilak ekmagen met tusume delaŋ zemâzin!” ");
INSERT INTO naf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Zuda am Aŋgalalaŋ Kendoyet Zelusalem mka teman Kawawaŋ sesewatsasât mopmâbien kan keyet Glik am notnaŋaŋ kegogak Kawawaŋ sesewatsasâgât koti tapmambien. ");
INSERT INTO naf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yaŋ an ekŋen keyaŋ Pilip Galili msat keyet mka ŋen Betsaida keyetnaŋ ekmagen meti zewien, “An notn, nin Zisas eksâgât nâmti kotnup.” ");
INSERT INTO naf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Zeme Piliwaŋ met Enduluyet zeme wati ilisakwep Zisasmagen meti “Glik am notnaŋ giksât kolip,” ");
INSERT INTO naf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","zemalu Zisasiyaŋ nâmti zeye, “Kawawaŋaŋ Angat Nemuŋaŋ kwizet buŋamaŋ mwat peme amnaŋ eegalen temaŋ ilak daŋgoin. ");
INSERT INTO naf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Neŋ zet penaŋ pigok zema nâit, nin saŋgom alik kwewetaŋ sumuŋti kasiŋen bemann e ikŋaŋ kwep keyak matazin. Yaŋ msalen met ondemann moti penaŋ bilimak sambe mapein. ");
INSERT INTO naf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Âpme an ŋenaŋ msalen kapi mamti nâgât kwizet buŋamnaŋgapmti mamaŋaŋ ketalasiwe beme bam mama kanzizit tiwe. Âpme am ŋenaŋ nâgât kwizapatnnaŋgat mti mamaŋaŋ ketalat ku pewe beme bam an ke walelet aikbe. ");
INSERT INTO naf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Am ŋenaŋ nâlen sisiliŋ nemba besât nâmbe beme neŋ mambawenak napmâpmeti mulupm mti mambe. Am ŋenaŋ nâlen mulup mti mambe beme Bienaŋ kwizet buŋamaŋ mwapewe. ");
INSERT INTO naf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Pi gakikiyelen kan sokŋan penaŋ kopme nâmti keŋŋ sindem penaŋ bein. We, ne pe zigok msap? ‘Bien, geŋ kan bewanan kapi sebem neneyelen zesap ma zigok?’ Wa kegok yek, sindem kegok ke titiyet msalen kapi toban. ");
INSERT INTO naf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Keyepmti Bien, geŋ ŋepgat nukŋaŋ beke pemane nâgât palen mopme keyaŋ gâgât kwizet buŋamdi mwabe!” Zeme kululuŋengatnaŋ zet pigok sokbeye, “Geŋ mmane nâgât kwizet buŋamm msalen ke palakŋaŋ beyeyaŋ ewe mmane omba penaŋ palakŋaŋ bem mekobe.” ");
INSERT INTO naf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Âpme am sambe ninmak tapmambenn ekŋenaŋ kwisak ke nâmti zewien, “Kululuŋ kwisak kun.” Zeme am notnaŋaŋ zewien, “Kawawaŋgalen ensel ŋenaŋ Zisas zet tadunduin.” ");
INSERT INTO naf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Zeme Zisasiyaŋ zet ke nâmti pigok zeye, “Wa zet ke nâgât mti ku zep. Ingat mti kululuŋengatnaŋ zet ke sokbep. ");
INSERT INTO naf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pi ilak msalen am Kawawaŋaŋ zelin nâmti keyet dopmaŋ mutumindandayelen kan bein. Keyepmti msalengalen mama mimi mgasik keyelen toŋaŋ Sadaŋ ilak mkutupeme wembe. ");
INSERT INTO naf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Âpme neŋ tep palen palak palak wema nomnemti mwatonzemnewep kan keyet msat sambe am ekŋenaŋ zapatn ke nâmti neŋmagen kot tusumti mambep.” ");
INSERT INTO naf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ke Zisasiyaŋ gakiki zigok gakiwe keyet zetnaŋ zemkawaŋ bemindaye. ");
INSERT INTO naf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Zeme nâmti am tabien ekŋenaŋ pigok dunduwien, “Nin Kawawaŋgalen Zet Itnaŋanen zet kapigok maeknup, Kilais ek msalen koti gakikipiŋ kwesiŋ kwesiŋ mamambe. Âpme naman geŋ eneyet pigok zenik, Angat Nemuŋaŋ ek tewen kumti mwatonzempewep. Geŋ Angat Nemuŋaŋ ke pe an kwiyet penaŋ nâmti tazenik?” ");
INSERT INTO naf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yaŋkwesime Zisasiyaŋ zet dopmaŋ pigok gilik zem diindoye, “Nâlen taŋamm busatnaŋaŋ ingat tuŋguwinan kan isikŋaŋ bugan busatnaŋ bemti tabe. Tapme in taŋam sokŋaset ke ekti mebep. Mineti in tambusosok temaŋaŋ indasumuŋme keyet keŋan mebepmagengat ek titiwep. Geŋ tambusosok kiŋkiŋaŋ keŋan mebegen set ŋep ekmâtâti ku mebek. ");
INSERT INTO naf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Keyepmti taŋamm busatnaŋ toŋaŋ neŋ ewe kapi yagak tapma in nâgât nâmkiŋpemti nâgât nemunamban penaŋ bewep.” Zisasiyaŋ zet kegok dinndomti buzak pak zemti met enzilim mebenn. ");
INSERT INTO naf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Zisasiyaŋ am zikalin palen penaŋ menok sepem igak igak mme ekbienaŋgut am sambe penaŋaŋ ku nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bee golaŋ zenze an Aizayayaŋ eweŋan baen zeye keyet kataŋ amnaŋ mbien. Egaŋ pigok zeye, “Amobotnaŋ, am pe kwiyaŋ penaŋ ningalen zet nâmkiŋpewe? Ma Amobotnaŋaŋ am pe kwi penaŋmagen menok mme windendi temaŋ ke ekbep?” ");
INSERT INTO naf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Amnaŋ Zisas ku nâmkiŋpewien keyet zetnaŋ eweŋan golaŋ zenze an Aizayayaŋ ikŋaŋak zet ŋen ewe pigok zeye, ");
INSERT INTO naf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Am ekŋenaŋ zet zapatn nâmti nâme belakŋaŋ mambein keyepmti am ekŋen keyaŋ kwitnaŋ kwitnaŋ ŋen ekti yaŋaŋ nâmâtâbiekmagengapmti Amobotnaŋaŋ zikalin ma keŋin mee pi mme bubep pemâge. Mineti ekŋenaŋ eknâmâtâti keŋ gilik zenze aikme weyaŋindenakmagengapmti kegok mge.” ");
INSERT INTO naf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Golaŋ zenze an Aizayayaŋ zet zeye kapi egaŋ Zisasiyelen mulupmaŋgat windeŋaŋ bam kwabe beke ektati egat zetnaŋ kapi zeye. ");
INSERT INTO naf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Âpme an ŋeŋaŋ bembe notnaŋ ekŋenaŋ Zisas nâmkiŋpewien. Yaŋgut nâmkiŋpepenn sosok zemkawaŋ bemann Palisi ekŋenaŋ ndiksokbemti paset zupman ndamâpme towebanupmagen zemti buzak mamtemien. ");
INSERT INTO naf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ma am ekŋenaŋ zapatn nâmti mme kwizapatn tototnaŋ bewemagen zemti nâme nukŋaŋ beye. Mti ekŋenaŋ Kawawaŋ kwizet buŋamaŋ mwatpepeyet nâme tototnaŋ beye. ");
INSERT INTO naf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","45","Zisasiyaŋ zet pigok bekap penaŋ zeye, “Am ŋenaŋ neŋ nikmâtâti nâmkiŋpemnewe beme wa neŋ etaŋ yek an zemneme toban ek eyo ekmâtâti nâmkiŋpempewe. ");
INSERT INTO naf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Neŋ kululuŋgatnan msalen kapi am mbusatnaŋ bemindesâgât toban. Âpme am ŋenaŋ neŋ nâmkiŋpemnewe beme egaŋ tambusosogengatnan nâlen busatnanen kwabe. ");
INSERT INTO naf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Am ŋenaŋ zetn nâmti wisat mti bamkumpewe yaŋgut neŋ keyet dopmaŋ ku sawap. Neŋ wa am yominaŋgat dopmaŋin indandayet msalen kapi ku toban am yomengatnan gilik zemti indatitiyet toban. ");
INSERT INTO naf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Âpme am ŋenaŋ neŋ bam kumnemti zetnnaŋgat wisat mbe beme bam zet mulup temanen tabe. Zet zema wisat mamin zet kapiyaŋ ikŋaŋ kan delaŋ zenzeŋaŋgat zet muluwen peme tati ekbe. ");
INSERT INTO naf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wa neŋ zet kapi nanaŋgat keŋnaŋgalak ku manzeyap. Bien zemneme toban egaŋ ikŋaŋ zenzeyet zemâtâtnaŋge keyet kataŋ penaŋ manzemkawaŋ beyap. ");
INSERT INTO naf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Neŋ zetnaŋ ikŋaŋ kapiyaŋak am mama kanzizit maaikindain e nâmkiŋpemti keyepmti egalen zet ke ikŋaŋ zemâtâtnaŋgenok esemteŋ manzemkawaŋ beyap.” ");
INSERT INTO naf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aŋgalalaŋ Kendo tatagalen kasup kwep ewe tapme Zisasiyaŋ pigok nâŋge, “Olak, neŋ msat kapi pemti Bipmmagen mobogalen kan ilak bududuk penaŋ bein,” nâmti ammak nin ek nâmkiŋpemti ekmak oloŋkati oloŋen palen mamamtemenn keyepmti ningat kembeŋ temaŋ penaŋ nâmndeye. ");
INSERT INTO naf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Zisas ma nembaŋane nin tambume tu meu nsâti mot ondektati tatnneti pemann Saimongat nemuŋaŋ Zudas Iskaliot mkaengatnaŋ ek Sadaŋaŋ Zisas zemkukuyet zet kelakŋaŋ mpeye. ");
INSERT INTO naf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Âpme Zisasiyaŋ pigok nâŋge, “Bienaŋ kwitnaŋ kwitnaŋ sambe pi nâgât betnnan beye. Âpme neŋ ikŋaŋmagengatnan toban yanaman ewe gilik zemti naman ikŋaŋmagennak mowebap.” ");
INSERT INTO naf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ke nâmtati egaŋ meu nini mundumengatnan wati kâlâpmaŋ teepmaŋ sakŋangatnaŋ bee gulupeme weme taot mti pemanen kwasimpemti ");
INSERT INTO naf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","tu pelewen kasime topme mti yaŋbemti nembaŋane nin sambe setn palakŋaŋ zulutndemti taot pemanen zampeye ke mti takaput ndemepmaŋge. ");
INSERT INTO naf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tapmmetneti Saimon Pitamagen koti setnaŋ zulupesâpme egaŋ pigok zeye, “Amobotnaŋ, geŋ eneyet neŋ bukapiyet setn penaŋ pi zulutnesenik?” ");
INSERT INTO naf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Zeme Zisasiyaŋ pigok dunduye, “Neŋ muluwaŋ tapmiyap kapiyet yaŋaŋ penaŋ alak kapi ku nâmâtâdik bamgegut o nâgâek piwan yaŋaŋ pigogapmti tapmnemaŋge e nâmâtâbanik.” ");
INSERT INTO naf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Âpme Pitayaŋ pigok zeye, “Yek penaŋ, geŋ nâgât setn zululupiŋ!” Zeme Zisasiyaŋ pigok zeye, “Neŋ sedi ku zulutgesap beme geŋ neŋmak tususunit ewe ku tabe.” ");
INSERT INTO naf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Zeme Pitayaŋ pigok dunduye, “Amobotnaŋ, kegok beme setn etaŋ yek, betn ma ŋokŋ mee temakwep zulutne!” ");
INSERT INTO naf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Zeme Zisasiyaŋ pigok dunduye, “Amnaŋ tu zuluti bam belaknik meti kot witilip selinan etaŋ zuluti matalip. In sambe kapi yompiŋ kwetetepmaŋ etaŋ bemâbien. Âpme tuŋguwinaŋgatnaŋ an kwewaŋ kwetetepmaŋ penaŋ ku mamain.” ");
INSERT INTO naf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Egaŋ an zemkuwe egat nâmti keyepmti pigok zeye, “In sambe kapi dolakŋaŋ etaŋ yek; an kwep bekanaŋ.” ");
INSERT INTO naf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Setn zulut mepme delaŋ zeme kot kâlâpmaŋ ewe mim munduŋti met munduman tot tagom tati pigok dinndoye, “In neŋ selin zulutindeya kapiyet yaŋaŋ ŋep nâip? ");
INSERT INTO naf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","In nâgât Amobotnaŋŋ ma An zikat indandan manzeip e ŋep nâmnemti manzeip. ");
INSERT INTO naf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","15","Âpme neŋ Amobotnaŋin ma An zikat indandaŋin manâmneip neŋ alak selin zulutindema egip sepem kegogak in ilinak ŋenaŋ ŋengat setnaŋ zulutpem ŋenaŋ ŋengat setnaŋ zulutpem mammambep. ");
INSERT INTO naf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Neŋ zet penaŋ pigok diindoma nâit, sisiliŋ nemba ŋenaŋ Amobotnaŋaŋ sebempemti egaŋ mobotnaŋ ku mamain ma amobotnaŋ ŋenaŋ nemba ŋen mulup zet manzempeme mezin beme nemba mamezin keyaŋ an mulup zet masain ke ŋep ku mamtopein. ");
INSERT INTO naf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","In zet kapi dinndoma nâyo keyet kataŋ penaŋ mbep beme in set ke ekme dolakŋaŋ beme oloŋen mbep. ");
INSERT INTO naf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Neŋ zet kapi zema in sambe ilinsakwep ku indati mâzin. Neŋ in sambe kapi nenn nâmti indati mâban. Âpme kwep ŋen bekanaŋ e nâmtiŋgut waban keyepmti ekmagen Kawawaŋgalen Zet Itnaŋanen zet ŋen pigok tazin ke katikŋaŋ bewe, ‘An neŋmak meu pelep kwep nilut egaŋ neŋ zemnowe.’ ");
INSERT INTO naf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kwitnaŋ kwitnaŋ kapi penaŋ ewe sokbembepiŋ tapme neŋ eweŋanak diindoyap keyepmti kwitnaŋ kwitnaŋ nâgât palen tasokbeme ekti pigok nâmbep. ‘O, Amobotnaŋaŋ ikŋaŋ zeme nâmbenn wan penaŋaŋ ilak alak kapi sokbemsame eknupmak,’ nâmbep. ");
INSERT INTO naf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Neŋ zet penaŋ sukwep pigok zema nâit, am ŋenaŋ neŋ an ŋen zempema kopme egaŋ kwitnaŋ kwitnaŋ dolakŋaŋ mimindawe beme wa ekŋen mimindanup zemti neŋmak Bien zemneme koban nit eyo keŋ taolet minndawe.” ");
INSERT INTO naf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Zisasiyaŋ zet kegok zeme delaŋ zeme Zudasiyaŋ alak zemnosem e nâmti keŋaŋ bekanaŋ penaŋ beme nembaŋane nin pigok zem sokbemndaye, “Neŋ penaŋ sukwep penaŋ zema nâit, ingat tuŋguwinaŋgatnaŋ ŋenaŋ neŋ zemnosem.” ");
INSERT INTO naf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Zeme nâmti nembaŋane nin weŋŋ mepme nnak meek koek mti pe kwiyet nâmti zein zemti nâpemann mekwapme tabenn. ");
INSERT INTO naf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Âpme nemba ninmagengatnaŋ Zisasiyaŋ nâmpeme dolakŋaŋ penaŋ mambemtan nemba keyaŋ Zisasiyet solonan penaŋ totapmaŋge. ");
INSERT INTO naf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Keyepmti Saimon Pitayaŋ nemba keyet zikat petaŋ mti zeye, “Kwiyet nâmti tazein ze belaknik yaŋkwesimane ningat zeme nâne.” ");
INSERT INTO naf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Âpme neŋ uluŋzemet Zisasiyet wakŋanen bemti pigok yaŋkwesiwan, “Amobotnaŋ, geŋ zet kapi ninmagengatnaŋ kwiyet nâmti tazenik? Ze zemane nâne.” ");
INSERT INTO naf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yaŋkwesima Zisasiyaŋ pigok dinoye, “Neŋ meu tuŋanen nupmamaŋ pema topme olek sama nsem an keyet nâmti tazeyap.” Kegok zemti nupmamaŋ peme topme mkwati Saimongat nemuŋaŋ Zudas Iskaliot mkaengatnaŋ ke same mti niŋge. ");
INSERT INTO naf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nime nime keyegak Sadaŋaŋ keŋanen toti keŋaŋ mme yuŋgume delaŋ zeye. Âpme Zisasiyaŋ pigok dunduye, “Geŋ keŋdan kwileki msâgât tatnânik elak sakwep meti miya!” ");
INSERT INTO naf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Zisasiyaŋ Zudas zet kegok tadundume nemba nin tabenn nin Zisasmak Zudas egelaŋ zet eneyet tazelup ke ku nâmbenn. ");
INSERT INTO naf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Keyepmti nemba notnaŋaŋ pigok otnâmbien Zudas ek ningalen mânep egaŋ mandamuŋ min keyepmti Zisasiyaŋ Kendoyet meu nim tabanupgat nâmti meu met kwititiyet mene ma am bekopsat ŋen mânep met sasayet tazempein mene nâmti tapmambenn. ");
INSERT INTO naf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Âpme nupmamaŋ Zisasiyaŋ Zudas olek same nim pemti keyegak tambu sutnan toti mege. ");
INSERT INTO naf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zudasiyaŋ toti mepme mepme Zisasiyaŋ nembaŋane nin pigok dinndoye, “Angat Nemuŋaŋ neŋ alak nukŋaŋ palen mopma keyaŋ kwizet buŋamm temaŋ tisowap. Âpme nâgât paleseti Kawawaŋgalen kwizet buŋamaŋ kegogak temaŋ bemesâpm. ");
INSERT INTO naf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Âpme Kawawaŋaŋ Angat Nemuŋaŋ neŋ kwizet buŋamm ammagen mpalakŋaŋ beme neŋ egat kwitnaŋ kegogak mwat onzempewap. Kelak belaknik penaŋ kapi sokbeme eksâip. ");
INSERT INTO naf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nembanne, neŋ inmak kan isikŋaŋ bugan kapi etaŋ tasâpmnup. Âpme bamgat in neŋ tokwati natimapme bewe. Âpme neŋ zet Zuda an damuŋ diindowan keyegak naman ingat diindoma nâit, ‘Neŋ mebap ke in ŋep ku kobep.’ ");
INSERT INTO naf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kegogapm neŋ zii zet alakŋaŋ pigok diindoma nâit: In ilinak ŋenaŋ ŋengat gogot ŋenaŋ ŋengat gogot mti gogot palenak mambep. Neŋ in gogot mimindemti indatimamkolap sepem kegok in ilinak mti mambep. ");
INSERT INTO naf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","In kegok mti dolakŋaŋ mame am ekŋenaŋ in nâgât nembanne mamaip e sosok nâmâtât indewep.” ");
INSERT INTO naf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Âpme Saimon Pitayaŋ pigok yaŋkwesiye, “Amobotnaŋ, geŋ pe deset mebanik?” Yaŋkwesime Zisasiyaŋ pigok zeye, “Neŋ mebawen geŋ keyegak ŋep ku kobanik bamgulak ŋep kobanik.” ");
INSERT INTO naf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Zeme Pitayaŋ pigok zeye, “Amobotnaŋ, geŋ pigogat neŋ ku gapmât kokogat zenik? Neŋ gâgât mti geŋmak meti maman ŋep ketalasiwap nânik!” ");
INSERT INTO naf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Âpme Zisasiyaŋ pigok dunduye, “Geŋ nâgât mti neŋmak meti sekdi ketalasi sâgât zenik? Neŋ penaŋ sukwep pigok zema nâmbak, tambu sutnan sakokolok kwitnaŋ ewe kukupiŋ tapme geŋ sek tuk zemkandat newanik.” ");
INSERT INTO naf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Zisasiyaŋ nembaŋane nin pigok dinndoye, “In nâgât kembeŋ temaŋ mti keŋinaŋ yayaŋ temaŋ ku mit in belak Kawawaŋmak nit nsakwep nâmkiŋpemndemti windemak talit. ");
INSERT INTO naf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bienaŋ mamainen gwaen mka sambe sambe penaŋ wemezin e ku tatnak ze neŋ met mkaŋin weyaŋpepeyet zetnaŋ kapi ku diindowak. ");
INSERT INTO naf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Neŋ pi meti mundumin beke weyaŋne weyaŋne pema delaŋ zemeŋgut naman gilik zemkoti indatima nsakwep meti neŋmak ke mamambanup. ");
INSERT INTO naf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Neŋ mebap in mka set ke nâip.” ");
INSERT INTO naf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Zeme Tomasiyaŋ pigok yaŋkwesiye, “Amobotnaŋ, geŋ pe deset mebanik? Nin zet tazenik kapi ku weyaŋ nâmâtâtnup keyepmti nin pe set zigoset gâlen ke kwabanup?” ");
INSERT INTO naf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Zeme Zisasiyaŋ pigok zeye, “Set ma zet penaŋ ma mama keyet toŋaŋ neŋ. Neŋ kandat nemti ŋenaŋ igak set belakŋaset Bienmagen ŋep ku mobogalen. ");
INSERT INTO naf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","In eweŋanak baen mamkwabennen ke nâgât Kilais kegok nâmâtât nembiek ze Bipmnaŋgat kegogak ŋep nâmâtâpewiek. Yaŋ alak pi kwitnaŋ kwitnaŋ sambe nâgât palen kwapmâsâpm ke ekti Biengat yaŋaŋ ŋep ekmâtâsâip.” ");
INSERT INTO naf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kegok zeme Piliwaŋ pigok zeye, “Geŋ Bipdi ke de ze zikat ndamane nin ekti nâmann delaŋ zeme oloŋen palen mambanup.” ");
INSERT INTO naf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Zeme Zisasiyaŋ pigok dunduye, “Pilip, neŋ kan teepmaŋ bepi inmak mamkwaban pi geŋ ewe yaŋŋ ku niknamâtâtnik? Am ŋenaŋ neŋ maniknâmâtâzin beme egaŋ Bien maekmâtâzin. Âpme geŋ zigogat pigok nayaŋkwesinik, ‘Geŋ Bipdi ke de tazin ze zikat ndamane ekne’? ");
INSERT INTO naf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bienmak nit kwep mamamti napmukulem mme mulup mamiyap pi Pilip, geŋ ewe ku manndikmâtâdik? Neŋ zet sambe mandiindoyap ke wa nanaŋgat keŋnaŋgalak ku manzeyap. Bienaŋ neŋmak mamti zet keŋŋnaŋ bemneme manzeyap. ");
INSERT INTO naf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bienmak nit kwep mamalup manzeyap. In zet ke penaŋ nâmkiŋpewep. Neŋ zelaŋ etaŋ zema nâme zet dâsukinok besemagengat mulup sambe mamiyap beke ekti penaŋ nâmkiŋpemnembep. ");
INSERT INTO naf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Neŋ zet penaŋ pigok diindoma nâit, am ŋenaŋ neŋ nâmkiŋpemnewe beme egaŋ neŋ mulup mamiyap kaboŋaŋ ŋep mbe. Ya wa ke etaŋ yek egaŋ neŋ mamiyap ke sebempemti sambe mmebe. Neŋ Bienmagen mobap keyepmti am ekŋen ke winde indamti indamukulem mimindema ekŋenaŋ mulup kegok mbep. ");
INSERT INTO naf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","In neŋ nâmkiŋpemnemti nâgât kwitnnanen kwileki ŋeniyet nâmti dundum name neŋ keyet penaŋaŋ ŋep maaikindamambap. Kegok mma Bienaŋ nâgât paleset kwizet buŋamaŋaŋ temaŋ tiwe. ");
INSERT INTO naf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","In nâgât gogot mti mamambep beme in nâlen zetn manzeyap kapi maŋgawepup. ");
INSERT INTO naf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Keyepmti neŋ moti Bipmnaŋgat zema egaŋ ingat mukulem mimiŋin ŋen peme toti inmak kwesiŋ kapi mamti maindamukulem mmambe. ");
INSERT INTO naf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Zet penaŋgalen Emetak Teŋ kapi am msalen nâmkiŋpepeŋinpiŋ belak kileŋ mamaip ekŋenaŋ ku tiwep. Ekŋenaŋ ek ku ekbien ma keyet yaŋaŋ ku nâip. Âpme ingut egat yaŋaŋ nâip keyet mti ingat keŋinan mame in egat yaŋaŋ nâmpeip. ");
INSERT INTO naf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Neŋ gakimti indemti mebet katikŋaŋ penaŋ ku mebap; Neŋ bam ewe gilik zemti inmagen kobap. ");
INSERT INTO naf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Neŋ kan isikŋaŋ bugan kapi tapmoti gakimti naman wabap. Âpme am msalen belak kileŋ mamaip ekŋenaŋ ku nikbep. Âpme ingut ŋep nâmkiŋpemnemti mamaip keyepmti nikbep. Neŋ mama kanzizit ke indama timti mambep. ");
INSERT INTO naf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Neŋ gakikiengatnan wabap kan keyet Bienmak nit kwep penaŋ bemti mambalup ma neŋ kegogak inmak kwep bemti mambanup. Keyet yaŋaŋ ŋep mamaŋinaŋ ekmâtâbep. ");
INSERT INTO naf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Am ŋenaŋ nâlen zeomkalili sambe kapi nâmti gawepumti nâgât kandaŋnnan meti nâgât gogot mimnewe beme Bipmnaŋ an ke kegogak gogot mpewe. Âpme neŋ an ke gogot mpemti yaŋŋ penaŋ zemkawaŋ bem sama nâmâtâtnembe.” ");
INSERT INTO naf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kegok zeme nâmti Zudas Iskaliot mkaengatnaŋ keyet opmaŋaŋ pigok yaŋkwesiye, “Amobotnaŋ, geŋ kwilekiyet yaŋaŋdi am sambe bepi aŋgalaŋ indemti nin etaŋ kapi zemkawaŋ bem ndasâgât etaŋ pi zenik?” ");
INSERT INTO naf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yaŋkwesime Zisasiyaŋ zet dopmaŋ pigok gilik saye, “An ŋenaŋ neŋ gogot mnewe beme egaŋ nâlen zet nâmti ŋep gawepuwe. Âpme Bipmnaŋ ek gogot penaŋ mpewe keyepmti Bienmak nit nsakwep ekmagen koti ekmak mamambalup. ");
INSERT INTO naf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Âpme an ŋenaŋ nâgât wisat nâmnembe beme egaŋ zigoset zetn nâmti ŋep gawepuwe. Zet sambe mandiidomkwapma nâip ke wa nenaŋgalen ŋoktikŋnaŋgat etaŋ yek. Bien zemneme toban ekmagengatnaŋ ke timti mandiindoyap. ");
INSERT INTO naf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nenn ewe inmak kapiyak mamti zet kapi mandiindoma nâip. ");
INSERT INTO naf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Âpme neŋ moti zema Bienaŋ mukulem mimiŋin Emetak Teŋ ke zempeme egaŋ toti nânâ dolakŋaŋ sambe sambe zikat indamâbe. Mti neŋ zet diindoma in notnaŋ kandapmâbien mee pi ewe mbutem indame nâmbep. ");
INSERT INTO naf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Neŋ indemti mesât tati betziŋŋ keŋ sewakŋaŋ palen mama ke indayap wa ke am belakŋaŋ ŋenaŋ mamimindaip keboŋ yek nenaŋgalen keŋ sewakŋaŋ penaŋ ke keŋinan bemindeyap. Keyepmti neŋmagen kwitnaŋ kwitnaŋ nukŋaŋ sambe sokbeme ekti in keŋin yayaŋ temaŋ kwapme ku kiŋgabep. ");
INSERT INTO naf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Neŋ ŋeŋaŋ pigok diindoma nâyo, ‘Neŋ indemebawaŋ met maneti bam ewe inmagen gilik zemti kobap.’ In keŋin neŋmagen penaŋ bempemti mamambiek ze neŋ Bien an windeŋaŋbeŋ ekmagen mobap zema nâmti oloŋen temaŋ mbiek. ");
INSERT INTO naf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pi ewe kwitnaŋ kwitnaŋ sokbembepiŋ tapme eweŋanak tadiindoyap keyepmti in tati ekme kwitnaŋ kwitnaŋ nâgât palen ke sokbeme ekti zet tazema nâip kapi nâmkiŋpewep. ");
INSERT INTO naf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Neŋ zet sambe teepmaŋ ku diindosap msat kapiyelen damuŋ Sadaŋ ek ilak kokogalen bududuk penaŋ min. Egaŋ neŋ ŋep ku mtot neneyelen. ");
INSERT INTO naf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Neŋ Bienaŋ ikŋaŋ zemâtâtneye keyet kataŋ Bien gogot msamti zetnaŋ gawepumti mulup sambe kapi mmepma msalen am sambe kapiyaŋ nikmâtâpmâbep. Keyet wapme ilak mka pi pemti metne. ");
INSERT INTO naf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Neŋ wain tep yaŋaŋ ŋotekŋaŋ penaŋ âpme wain mulup keyet toŋaŋ Bienaŋ ikŋaŋ bein. ");
INSERT INTO naf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Keyet mti mulupmaŋ mmeti ekme betnaŋ ŋen neŋmagen om mebetnaŋaŋgut penaŋaŋ pepepiŋ tapme ekti maantimpeme mezin. Âpme naman betnaŋ ŋen ekme penaŋaŋ dolakŋaŋ maelikzin beme egaŋ weyaŋ betnaŋ bekanaŋ notnaŋ eleŋgem time topme tati penaŋaŋ sambe maelikzin. ");
INSERT INTO naf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","In neŋ zet diindoma zetn nâmti nâmkiŋpemti ilak kwetetepmaŋ bemti neŋmagen tusumâbien. ");
INSERT INTO naf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Keyet mti in neŋmak tususuŋin dolakŋaŋ mme neŋ inmak tususu kegogak dolakŋaŋ mti mamambanup. Âpme wain tep betnaŋ ŋen pemanen daen tususupiŋ belak igak tuŋgupman anzam tati penaŋaŋ igak ŋep ku maelikzin. Egaŋ tep penaŋmak daen tusum tatiŋgut penaŋaŋ maelikzin. Âpme in kegogak neŋmak tususupiŋ mambep beme in penaŋin dolakŋaŋ zigoset elikbe? ");
INSERT INTO naf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Wain tepmaŋ bee neŋ mme sinaŋ betnaŋ e in keyepmti am ŋen neŋmak tususunit kwep tabe beme am kemagen penaŋaŋ omba elikmâbe. In neŋ nemti ilinak etaŋ anzam tati kwileki ŋen pembenaŋ ku aikbep. ");
INSERT INTO naf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","An ŋen neŋmak tususuŋaŋ tapme keyet penaŋaŋ ku sokbein beme neŋ tususunit ke eleŋgem pewe. Âpme wain betnaŋ eleŋgem time towemti aŋgasimti memuŋ bem weme timti tewen time moti manzin ek sepem kegogak msawep. ");
INSERT INTO naf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","In neŋmak tususuŋin kwep tapme zetn gawepumti mambep beme in kwileki ŋeniyet nâmti dundum nawep beme neŋ keyet penaŋaŋ msokbewap. ");
INSERT INTO naf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","In ammagen mulup mme am nâmkiŋpepemak sambe sokbemâbep beme set keyeset am ekŋenaŋ in nâgât nemunnambanne penaŋ mamti mulup mamip e indikmâtâti Kawawaŋgat kwizet buŋamaŋ omba penaŋ mwabep. ");
INSERT INTO naf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Âpme in neŋmak tususuŋin matazin keyepmti in am sambe gogot mamimindeip keyepmti neŋ ingat gogot penaŋ mamimindeyap sepem kegogak Bien Kawawaŋaŋ neŋ gogot penaŋ mamnain. ");
INSERT INTO naf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Âpme neŋ Biengalen zet sambe bee gawepumti mamiap keyepmti Bienaŋ nâgât gogot penaŋ mamnain. In sepem kegogak nâlen zetn sambe gawepumti mambep beme neŋ ingat gogot penaŋ mimindewap. ");
INSERT INTO naf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Âpme neŋ oloŋen palen mamayap keyepmti in neŋmak pepep bemamti kwitnaŋ kwitnaŋ zeya kapi kegogak mbep beme in neŋ mamayapnok keŋ oloŋen palen mamambep. ");
INSERT INTO naf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Neŋ ingat zemâtâtât zet ŋen kapigok diindoma nâit, neŋ in gogot mamimindeyap sepem kegok in ilinak ŋenaŋ ŋengat gogot mti mamambep. ");
INSERT INTO naf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","An ŋenaŋ am notnaneyet mti mamaŋaŋ kileŋ ketalasiwe beme an keyet nâma amgat gogot omba penaŋ mamimindein kegok nâmpewap. ");
INSERT INTO naf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","In mulup zet diindoyap keyet kataŋ mâti mme neŋ indikma nâgât notnne penaŋ bewep. ");
INSERT INTO naf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Neŋ ingat sisiliŋ nembanne ewe ku zeyap neŋ ingat notnne penaŋ zeyap. Sisiliŋ an egaŋ amobotnaŋaŋgalen keŋanen zet zigok tazin ke ku manzeme nâinaŋgut Bienmagengatnaŋ zet sambe timti toban bee in sambe diindoma nâmâbien keyepmti neŋ ingat nâma notnne penaŋ mambemâzin. ");
INSERT INTO naf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","In neŋ ku nabien; neŋ in neŋmak mamayet indati zemindema meti muluwin dolakŋaŋ mme penaŋaŋ sambe sokbemti wemti kwesiŋ tatagalen keyet diindowan. Keyepmti in met mulup mimamambe kwileki ŋeniyet olati nâgât kwitnnanen Bien dundum same egaŋ indamukulem mimindewe. ");
INSERT INTO naf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Neŋ zemâtâtât zet ŋen pigok diindoma nâyo keyegak ewe zema nâit, in ilinak ŋenaŋ ŋeniyet gogot mti mamambep. ");
INSERT INTO naf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","In mulup tapmim mepme am ekŋenaŋ indik talati mtoindewep beme in nenn mamimname egip keyet otnâmbep. ");
INSERT INTO naf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","In am ekŋen kemak tusumti mambiek ze ekŋenaŋ kasa kasa ŋep ku mimindawiek. Neŋ in am kapiyet tuŋguwinangatnan indatimti set ŋen zikat indama ilinaŋgalen set itnaŋaŋ ke bamkumpemti nâlen mama mimi mâti mamip. Keyet mti indiktalati mtoindewep. ");
INSERT INTO naf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","In neŋ zet ŋen pigok diindowan e nâip, ‘Sisiliŋ nembayaŋ amobotnaŋaŋ sebempemti mobotnaŋ ŋep ku manak.’ Keyepmti am ekŋenaŋ neŋ sisipeŋpeŋ mimnawien sepem kegogak in mimindawep. Ma am notnaŋaŋ nâlen zet gawepuwien sepem kegogak am notnaŋaŋ ingalen zelin ŋep gawepuwep. ");
INSERT INTO naf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Am nâmkiŋpepepiŋ ekŋen kapiyaŋ neŋ Kawawaŋaŋ ikŋaŋ zemneme toti mulup mamiap ke ekŋenaŋ ku nâmâtâlip. Keyepmti ekŋenaŋ in neŋmak tusumti mamaip keyepmti in omba penaŋ mtoindewep. ");
INSERT INTO naf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Neŋ msalen kapi toti am ekŋen ke zet zapatn kapi ku diindowan ze zet kapiyaŋ yomin sosok ku mkawaŋ bem indenak. Pi zemkawaŋ bewan keyepmti yomin sosok mamimkawaŋbein. Kwileki ŋenaŋ yomin ke ŋep ku aŋgalaŋpepeyelen. ");
INSERT INTO naf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","An ŋenaŋ neŋ niktalati mammtotnein beme egaŋ Bien kegogak mammtopein. ");
INSERT INTO naf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Neŋ am tuŋguwinan menok temaŋ temaŋ amnaŋ ku mimiyelen ke mamkolap ke ku mbak ze ekŋenaŋ nâgât ŋenzinziŋ mti yom temaŋ ku aikbiek. Pi neŋ yomin mimsokbema yomin ke ekmâtâtiŋgut ekŋenaŋ naman nâgâek mtopenup zemti Bien kululuŋen main ek eyo mammtopeip. ");
INSERT INTO naf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kegok mme golaŋ zenze an zet ŋen kapigok zenzeŋaŋ ke penaŋaŋ masokbein, ‘Ekŋenaŋ yompiŋ belak tuŋgupman penaŋ ŋenzinziŋ msamti mammtopeip.’ ");
INSERT INTO naf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Neŋ mulupgat indamukulem mimiŋin Emetak Teŋ Bienmak mamain ke moti zempema toti egaŋ Bien Kawawaŋmak nigat yaŋŋ weyaŋ zemkawaŋ bem indame nâmâtât ndewep. ");
INSERT INTO naf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Âpme neŋ in indatimti mulup yaŋbemti mkopma nikbien keyet zet zapatn am zemkawaŋ bemindame nâmâbep. ");
INSERT INTO naf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Mineti amnaŋ kwitnaŋ kwitnaŋ nukŋaŋ ŋen mimindame nâmkiŋpepeen sukŋaŋ bewepmagat zet eweŋanak tipman baen pigok diindowan. ");
INSERT INTO naf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Am ekŋenaŋ in Zuda am ekŋengalen sesewat mkaen mebegat zemkulumindemti pase zupman indewep ma kan ŋen beme am ekŋenaŋ nin Kawawaŋgalen mulup penaŋ tapminup zemtati mamti in indome gakiwep. ");
INSERT INTO naf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ekŋenaŋ Bienmak nigat yaŋŋ ku weyaŋ manâmâtâlip keyepmti sepem kegok mimindawep. ");
INSERT INTO naf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Neŋ zet eweŋanak kapi tadiindomkwapma nâip keyepmti manepeme kwitnaŋ kwitnaŋ keboŋ sokbemindame ekti zewep. ‘O, Amobotnaŋaŋ zet dindoye walak penaŋaŋ piki sokbemndain,’ zewep. Zet kapi ilak kan teepmaŋ tipman baen mamkwabennen ke ku diindowan. Pilak Bienmagen mobogalen kann bududuk beme nâmti keyepm tadiindoyap. ");
INSERT INTO naf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pi neŋ An zemneme toban ekmagen mobogalen kan bududuk penaŋ beme mosât tapmma inmagen ŋenaŋ pigok ku nayaŋkwesin, ‘Geŋ pe deset mebanik?’ ");
INSERT INTO naf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Neŋ indemesât zet kapi zema keyepmti in belak kembeŋaŋ keŋin bemisikme belak zelinpiŋ talip. ");
INSERT INTO naf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Neŋ zet penaŋ pigok zema nâit, neŋ mobap ke ingat mti mobap. Âk neŋ ku mobap beme mukulem mimiŋin ke ŋep ku todak keyepmti neŋ moti ek zempema tobe. ");
INSERT INTO naf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Âpme egaŋ koti am msalen kapi yominaŋgat yaŋaŋ zikat indawe ma egaŋ mama mimi teŋ ke yaŋaŋ zikat indawe ma yominaŋgat dopmaŋ zemindondo keyet yaŋaŋ zikat indawe. ");
INSERT INTO naf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Âpme ekŋenaŋ yominaŋgat yaŋaŋ pigok ekbep ekŋenaŋ neŋ ku manâmkiŋpemneip keyaŋ yomin bein. ");
INSERT INTO naf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ekŋenaŋ mimyuŋguŋguŋinaŋgat nâme ŋep mambein. Kulekiyet neŋ Biengalen melap yaŋgut in ewe neŋ ŋep ku nikbep. ");
INSERT INTO naf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ekŋenaŋ Kawawaŋaŋgalen yominaŋgat dopmaŋ zemindondo keyet yaŋaŋ ku nâip. Kwilekiyet msalengalen damuŋ Sadaŋ ek eweŋan zemkuye. ");
INSERT INTO naf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Zet keboŋ keboŋ ke diindondoyelen sambe penaŋ timtalap yaŋgut alak kapigogat sambe diindoma zigok ambepeleseip. ");
INSERT INTO naf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Emetak Teŋaŋ tobe kan keyet egaŋ Kawawaŋ an zet penaŋgat ŋotekŋaŋ keyet yaŋaŋ zemâtâtindamti mama mimi dolakŋaŋ keyelen set zikat indame nâmâtâbep. Egaŋ kwitnaŋ kwitnaŋ ikŋaŋgat keŋanegak etaŋ ku zewe. Nen zemâtâtsama nâmti kwitnaŋ kwitnaŋ bam sokbemâbe keyet zapatnaŋ diindowe. ");
INSERT INTO naf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Zet ke nâgât keŋŋnaŋgatnaŋ timti zemkawaŋ beme nâgât kwizet buŋammnaŋ msalen palakŋaŋ penaŋ bemti mekobe. ");
INSERT INTO naf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bienmagen kwitnaŋ kwitnaŋ tazin keyet toŋaŋ neŋ keyepmti neŋ zet pigok eweŋan diindoya, Emetak Teŋaŋ nâlen keŋnanengatnaŋ zet timti in diindowe. ");
INSERT INTO naf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Neŋ kan isikŋaŋ bugan tazin kapi delaŋ zeme mepma in neŋ natimati ilinak mame neŋ met belaknik bugan mamti naman gilik zemkopma nikbep.” ");
INSERT INTO naf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kegok zeme nin nnak sek putuŋ pitiŋ mti zewenn, “An kapi zet kapi pe yaŋaŋ zigogat nâmti pigok pi zein? ‘Kan isikŋaŋ bugan tazin ke delaŋ zeme mepma natimabep yaŋ met belaknik maneti naman ewe gilik zemti inmagen kopma nikbep.’ Naman zet ŋen pigok zep, ‘Neŋ Bienmagen mobap?’” ");
INSERT INTO naf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kegok zemti ewe sakwalamti zewenn, “An kapi, ‘Pe kan isikŋaŋ bugan tazin,’ tazein kapi kwilekiyet nâmti tazeinaŋ? Ke nin yaŋaŋ ku nâmâtâtnup!” ");
INSERT INTO naf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zem mbenaŋ yek beme Zisas yaŋkwesisâgât tapmmann Zisasiyaŋ ndik mâtâti zeye, “‘Neŋ kan isikŋaŋ bugan tazin ke beme mepma natimabep. Ya naman met kan isikŋaŋ bugan tati naman gilik zem kopma nikbep,’ zeya keyet in zenâmti nayaŋkwesisât tapmip? ");
INSERT INTO naf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Neŋ zet penaŋ pigok zema nâit, neŋ nome gakima in nâgât si kembeŋ temaŋ tapmme am nâmkiŋpepeŋinpiŋ ekŋenaŋ keŋ oloŋen temaŋ penaŋ mbep. In kembeŋ palen ke manepeme neŋ bam gilik zemti indatisât kopma nikti oloŋen temaŋ mbep. ");
INSERT INTO naf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Imbi ekŋenaŋ nemba sokbesâpme sek sindem omba penaŋ timti keŋin sindem mambein. Yaŋ bam nemba sokbeme nembaŋaŋ ke ekti sindem titiŋaŋ ke nâme betetnaŋ beme keŋ oloŋen temaŋ mamip. ");
INSERT INTO naf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Âpme in sepem kegogak kan isikŋaŋ bugan kapi in si kembeŋ mti mambep. Manepeme neŋ mamaen gilik zem wapma nikti naman keŋ oloŋen penaŋ mbep. Keŋ oloŋen keboŋ ke am ŋenaŋ ku menzemmbe. ");
INSERT INTO naf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Neŋ Bienmagen mobap kan keyet in kwileki ŋeniyet yaŋaŋ penaŋ nâsâgât ŋen ku nayaŋkwesiwep. Neŋ penaŋ sukwep pigok zema nâit, in kwileki ŋeniyet olati Bien dundum same egaŋ nâgât pembenaŋnaŋgapmti kwilekiyet olati wekuwep ke indawe. ");
INSERT INTO naf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Neŋmak tusumti mamkwabien kan keyet in kwileki ŋeniyet olati nâgât kwitnnanen Biengat ku yaŋkwesiwien. Yaŋ alak pi in nâgât kwitnnanen kwileki ŋengat olati Biengat yaŋkwesime egaŋ kwitnaŋ kwitnaŋ ŋep indame olalapiŋ timamti oloŋen palenak mambep. ");
INSERT INTO naf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Neŋ zet sambe diindomkwaban ke belak bemzenze zet etaŋ diindomkwaban. Maneti bamgat neŋ bemzenze zet ŋen ewe ku diindowap neŋ Biengat yaŋaŋ belak sosok zemkawaŋ bemti zemâtâtindama nâmâbep. ");
INSERT INTO naf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kan keyet in nâlen bembeŋaŋ keyepmti nâgât kwitnanen Biengat gwaen dundum same neŋ ingat munduminan tati Biengat manzemtemanok ewe ku zewap. ");
INSERT INTO naf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Neŋ Kawawaŋmagengatnan kwatoban e in nâmkiŋpemnemti nâgât gogot penaŋ mamimneip keyepmti Bienaŋ ingat sepem kegogak gogot penaŋ mamimindein. ");
INSERT INTO naf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Neŋ Bien pemti msalen pien inmagen kwatoban yaŋ pi naman in indemti kululuŋen Bienmagen gilik zem mowebap.” ");
INSERT INTO naf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kegok zeme nin nâmti pigok dunduwenn, “Geŋ alak pi bemzenze zet ŋen zenzepiŋ sosok belak zemâtâtndamane nâmâtâtnup. ");
INSERT INTO naf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Keyepmti nin gâgât pigok nâmgenup geŋ an ŋenaŋ gayaŋkwesisipiŋ mme geŋ gitiyegak kwitnaŋ kwitnaŋ sambe beeyet yaŋaŋ manâmâtâpmane delaŋ zein. Keyepmti geŋ Kawawaŋmagengatnan tobanan e nâmkiŋpemgenup.” ");
INSERT INTO naf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Zeme Zisasiyaŋ pigok dinndoye, “Kapi zema in alakŋatiŋgut nâmkiŋpemneip? ");
INSERT INTO naf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kan belaknik penaŋ kapi in neŋ nemti kunzuŋti mkaŋinan me enzilim kot enzilim msâip. Ke nem mekopme neŋ nenak etaŋ ku tabap Bienaŋ namukulem mti neŋmak tabe. ");
INSERT INTO naf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","In neŋmak tusumti mamaip keyepmti in keŋ sewakŋaŋ palen mamayet nâmti zet sambe bee diindomkwala. In msalen kasa kasa mimindame keyet keŋaŋ nâmisim mamaip. Âpme nenn msalengalen kwitnaŋ kwitnaŋ bekanaŋ sambe kapiyelen windeŋaŋ mtopemâban.” ");
INSERT INTO naf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Zisasiyaŋ zet kegok zemdelaŋ zemti zikatnaŋ kululuŋen gwaen ekme mopme pigok dunduye, “Bien, gakiki kann ilak bududuk penaŋ bein. Kan keyet geŋ nâgât kwizet buŋamm mwapmane neŋ naman gâgât kwizet buŋamdi mwabap. ");
INSERT INTO naf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kawawaŋ, geŋ msalen am sambe bekapi ilindiŋ neŋ indadamuŋ mimiyet nâgât kandaŋnnan yaloŋ indemti indadamuŋ mimiyet winde nawanan. Mti am geŋ gitaŋgat zapat penaŋ ombem indewanan ekŋen ke neŋ mama kanzizit indawap. ");
INSERT INTO naf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Amnaŋ mama kanzizit ke yaŋaŋ kapigoset mti matip: geŋ Kawawaŋ penaŋ mamanik ma Zisas Kilais neŋ nemane toban am ekŋenaŋ yaŋnit kegok penaŋ nâmâtâtndemtiŋgut mama kanzizit ŋep tiwep. ");
INSERT INTO naf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Geŋ mulup mimiyet zemnemane tobanaŋ mulup bepi mmetne metne pema msalen kwizet buŋamdaŋ palakŋaŋ bemti tazin. ");
INSERT INTO naf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bien, msat kululuŋ ewe ku sokbeme neŋ eweŋan geŋmak mamti kwizet buŋamm temaŋmak mamamteman. Sepem kegogak pi ewe gilik zemti geŋmagen kwapma kwizet buŋam ke ewe namane timti gâgât monzalamdanen mamambap. ");
INSERT INTO naf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Msalen am sambe penaŋ kapiyet keŋan am gitaŋgat zapat ombemindewanan ekŋen ke nâlen belen beindewanan ekŋenmagen kwizapadi ilak zemkawaŋ bemindama nâmti mkatikbemâpme delaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mti ekŋenaŋ neŋ mulup kwitnaŋ kwitnaŋ sambe mamiyap ekŋen kapi winde geŋmagengatnaŋetaŋ matimiyap elak ekŋen sambeyaŋ eknâme delaŋ penaŋ zemâzin. ");
INSERT INTO naf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Zet sambe nawanan e diindoma delaŋ zeye. Ekŋenaŋ penaŋ nâmkiŋpeip neŋ geŋmagengatnan koban. Ma geŋ nemane koban. ");
INSERT INTO naf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Keyepmti neŋ geŋ am gitaŋgat zapat ekŋen ke nâgât belen bewanan ekŋen keyet etaŋ nâmti pigok dundum gayap. ");
INSERT INTO naf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Am sambe geŋ nâlen belen bemane maindadamuŋ miap pi toŋaŋ nilizuzut belup ya am ekŋen kapiyaŋ nâgât kwizet buŋamm ŋep mwatnewep. ");
INSERT INTO naf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Âpme neŋ msalen pien kwesiŋ penaŋ ku mambap ilak geŋmagen kwakwagalen kan bududuk bein. Âpme amdine ekŋen bekakan nâlen belen bemane maindadamuŋ mkwalap pi ewe msalen kapi kwesiŋ mamambep. Keyepmti Bien, An teŋ mamanik, geŋ kwileki ŋenaŋ mto indeweyet indadamuŋ dolakŋaŋ mimindemane mambep. Âpme ekŋenaŋ gâlen winde ke sosok ekmâtâti keŋ kwep bemti kume kwaopme mambep. Nit keŋ kwep bemti mamalup sepem kegogak ");
INSERT INTO naf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","neŋ ekŋenmak mamayap. Kan kapiyet neŋ gâlen windeen zet zapadi dolakŋaŋ kapi zemti mkatikŋaŋ bemindewan keyepmti ekŋen sambe penaŋ ku walebien. Kawawaŋgalen Zet Itnaŋanen zet tazin ke katikŋaŋ bembeyet an kwewetaŋaŋ set tetakŋaŋ palakŋaŋ beme mmetneti mme pilik zeme teziŋ ŋandaŋgat zapat beye. ");
INSERT INTO naf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Neŋ ilak geŋmagen kokogat kann bududuk beme keyepmti neŋ ekŋengat yayaŋ mimindemti dundum gayap. Geŋ indamukulem mimindemane oloŋen palen mambep nen mamayap sepem kegogak. ");
INSERT INTO naf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Âpme neŋ zedi zemâtâtndama ekŋenaŋ ke nâmti neŋmak tusume mamanup keyepmti am ninmak tusumti ku mamaip ekŋenaŋ nsakwep ŋenzinziŋ minndamti mamtot ndeip. ");
INSERT INTO naf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Wa neŋ geŋ msalen kapiyetnan indatimti mobogat nâmti ku dundum gayap. Mneti Sadaŋgalen windeyaŋ mtoindewemagengapmti geŋ indapmukulem mimindemane mamayet nâmti dundum gayap. ");
INSERT INTO naf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Neŋ msat kapiyet zapat ku mamayap sepem kegogak ekŋen kapiyaŋ msat kapiyet zapat ku mamaip. ");
INSERT INTO naf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Geŋ gitaŋgat zedi penaŋ sukwep penaŋ keyaŋ keŋin mmane kwetetepmaŋ penaŋ beme ekŋenaŋ yomgalen mama mimi bekanaŋ ke bamkumpemti gâgât zapaletaŋ mamambep. ");
INSERT INTO naf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Geŋ neŋ msalen pien zedi penaŋ sukwep penaŋ ke zempalakŋaŋ bembeyet zemnemane toti mamiyap kegogak ekŋen bekakan kapi neŋ zemindema msalen kapi ammagen zedi ke tim mebep. ");
INSERT INTO naf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Neŋ ekŋenaŋ gâlen zedi teŋ penaŋ kapi nâmti gâgât kandaŋdan penaŋ kokogat nâmti indamukulem mimiyet keŋŋ temaŋ penaŋ matazin. ");
INSERT INTO naf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ya wan neŋ ekŋengat etaŋ nâmti ku dundum gayap ekŋenaŋ kapi mamti zedi timepme am notnaŋaŋ zelin nâmti nâgât nâmkiŋpemnemti mambep ekŋengat eyo nâmti dundum gayap. ");
INSERT INTO naf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bien, neŋmak geŋmak keŋ kwep bemti gogot palen mamalup sepem kegogak ekŋenaŋ nitmak tusumti ilinak keŋ kwep bemti gogot palen mame am notnaŋ gâlen zet zapat dolakŋaŋ bamkumpemti mamaip ekŋenaŋ geŋ giti neŋ zemnemane toban ke penaŋ nâmkiŋpemnewep zemti dundum gayap. ");
INSERT INTO naf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Geŋmak nit keŋ kwep bemti mamalup sepem kegogak ekŋenaŋ ilinak keŋ kwep bemti mamambep. Geŋ neŋ nigomti kwizet buŋamm temaŋ nambanan sepem kegogak neŋ ekŋen kegogak indikgomti kwizet buŋamin mamwalap. ");
INSERT INTO naf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Geŋmak nit keŋ kwep bemti mamalup sepem kegogak neŋ ekŋenmak keŋ kwep bemti mamanup. Kegogak ekŋenaŋ ilinak keŋ kwep penaŋ bemti mambep. Sepem kegok mti mame am gâlen zet bamkumpemti mamaip ekŋenaŋ mama mimiŋin dolakŋaŋ ke ekti penaŋ geŋ giti zemnemane toban ma geŋ gogot mnemti ekŋen eyo gogot mamimindanik e nâmâtâbep. ");
INSERT INTO naf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bien, geŋ am indamakumti nâgât betnnan bewanan. Keyepmti ekŋenaŋ neŋ kwabap keyegak kwabep. Mti ekŋenaŋ geŋ msat kululuŋ ewe sokbembepiŋ tapme geŋ nâgât gogot penaŋ mnemti kwizet buŋamm temaŋ nawanan kwizet buŋamm temaŋ ke ekmâtâbep. ");
INSERT INTO naf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bien, An teŋ penaŋ mamanik, am sambe msalen pi wemelip ekŋen bepiyaŋ gâgât yaŋdi eweŋan ku nâmbien neŋ kwep gâgât yaŋdi nâmgeyap. Keyepmti geŋ am ekŋen ke nânâŋin mkawaŋ bemane ekŋenaŋ neŋ geŋmagengatnan toban e nâmâtâtnewep. ");
INSERT INTO naf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Neŋ am ekŋen kemagen zet zapadi zemâtâtindawan yaŋ pi ewe manzemâtâtindamelap. Keyet geŋ nâgât gogot mamimnenik sepem kegogak ekŋengat gogot mimindewanik.” ");
INSERT INTO naf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Zisasiyaŋ dundundu kegok dundumepme delaŋ zeme wati nin ndatime mka pem toti met Kidolon tu somti tu nembet daen olip mulup temaŋ matatanen ke mobenn. ");
INSERT INTO naf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mulup keyet keŋan Zisasiyaŋ ninmak kan kataŋ ke meti maondaktemenn keyepmti Zudasiyaŋ mulup set ke nâme delaŋ zein. ");
INSERT INTO naf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Keyepmti ekŋenaŋ ke mepme Zudasiyaŋ meti zeme sâpe sâpe bumbu an ŋeŋaŋ ma Palisi ekŋenaŋ an kasa kuku ma sesewat mkayelen an tipdakutum mee pi zemindeme Zudas Zisasiyaŋ ikŋaŋ nembaŋaŋ wati mamtan egaŋ ikŋaŋ ŋeŋaŋ bemti indatime ŋelip sage timti tambuyet taŋam koŋti koŋti piyaŋ Zisas wasâgât kopmâbien. ");
INSERT INTO naf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Âpme Zisasiyaŋ am kasayaŋ koti kwitnaŋ kwitnaŋ sambe mnamâseip e nâme delaŋ zeye keyepmti ekŋenaŋ takopme kopme egaŋ keeselak ekŋenmagen sokŋan meti pigok zeye,” In an pe kwiyet tatimalip?” ");
INSERT INTO naf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Zeme ekŋenaŋ zewien,” Nin Zisas Nasalet mkaengatnaŋ ek tatimatnup.” Zeme Zisasiyaŋ pigok zeye, “Ne toka kapi talap.” ");
INSERT INTO naf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Zeme ekŋenaŋ weŋin mepme tikande kande meti toindomâge. ");
INSERT INTO naf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mme Zisasiyaŋ ewe indayaŋkwesiye, “In an pe kwiyet tatimalip?” Indayaŋkwesime zewien, “Nin Zisas Nasalet mkaengatnaŋ egat tatimatnup.” ");
INSERT INTO naf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Zeme Zisasiyaŋ pigok diindoye, “Neŋ pi talap,” tazeyap pe tatnâip ma yek? In neŋ tatnatimalip beme nembanne indondopiŋ; nen kwep natamti napmelit. ");
INSERT INTO naf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sepem kegok sokbeme Zisasiyaŋ ekŋengat dunduyeen keyet penaŋaŋ sokbem katik beye, “Nemba akum namane maindadamuŋ mkwalap ekŋenmagengatnaŋ ŋenaŋ ku walege.” ");
INSERT INTO naf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Âpme Saimon Pitayaŋ Zisasiyepmti gembo pitakŋanen yuŋmamaŋge pi sakwep seŋkwati sâpe sâpe bumbu an ŋeŋaŋ egalen sisiliŋ nemba ŋen kwitnaŋ Malakas zeme ke ek wakŋaŋ penaset sâmpeme mege. ");
INSERT INTO naf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kegok mme Zisasiyaŋ Pita pigok dunduye,” Geŋ gembondi sakwep mti mkaŋan wepe. Bienaŋ neŋ sindem temaŋ kapi titiyet zemneŋge pi alak geŋ naman bekek nesât tapmnik?” ");
INSERT INTO naf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Zemti tapme am ek wati kosât mebien ekŋenaŋ Zisas atamti betnaŋ tegaŋ zampemti wati mebien. ");
INSERT INTO naf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ekŋenaŋ ŋeŋaŋ Kaipasiyet tatnaŋ Anas ekmagen wati mebien. Kaipas egaŋ nup kan keyet sâpe sâpe bumbu an sambe ekŋengat ŋeŋaŋin temaŋ mamayet ombempeme mamtan. ");
INSERT INTO naf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaipas an keyaŋ Zuda am ekŋengalen ondedagen tati zet kapigok zeye, “Zisasiyaŋ tapme nin nukŋaŋ temaŋ aikbanupgat nin ek kwep kumann gakime dolakŋaŋ mambanup.” ");
INSERT INTO naf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pitamak notnaŋ kwep ŋenmak Zisas zet muluwen wati mepme mâti eksât mebun. Nemba ŋen ke sâpe sâpe bumbu an sambe ekŋengalen ŋeŋaŋin temaŋ keyaŋ egat nâmpein keyepmti Zisas wati egalen mka keŋan mopme mâti keyegak mowege. ");
INSERT INTO naf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","17","Âpme Pitayaŋgut igak paset zupman baen tati notnaŋ mebun ke sâpe sâpe bumbu an sambe ekŋengalen ŋeŋaŋin temaŋ egaŋ nâmpein keyepmti egaŋ nâmtalati met imbi sekekek damuŋ keyet zeme nâmti Pita set kwalet peme keŋan kwapme imbi keyaŋ Pita sepemaŋ ekti yaŋkwesiye, “Geŋ kapi an kandayet nembaŋaŋ ŋen tagigap.” Yaŋkwesime Pitayaŋ yaŋti zeye, “Geŋ pe kwiyet tazenik ne pi ka yegat.” ");
INSERT INTO naf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kegok zempemti mulup an ma kasa kuku an ekŋenaŋ tâgâyet mti tep bume zime bembuluŋti kât tapmambienen ke mot wanzaŋgum tati tep kât tapmaŋge. ");
INSERT INTO naf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Âpme sâpe sâpe bumbu an sambe ekŋengalen ŋeŋaŋin temaŋ keyaŋ Zisasiyet nembaŋane nin zigoset indatiye ma egaŋ zet ziboŋ zikat indammge pe zigok penaŋ manzein keboŋ keboŋ keyet yaŋaŋ nâsâgât tayaŋkwesimaŋge. ");
INSERT INTO naf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Âpme Zisasiyaŋ pigok dunduye, “Neŋ am sambe ekŋengat tuŋguwinan ma Zuda am nnaŋgalen sesewat mka temanen ma am ondedakŋin tema temanen sosok belak zetn zemzikat mti mkawaŋ bemeban. ");
INSERT INTO naf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Âpme geŋ nâgât pi eneyet tatnayaŋkwesinik? Am sambe zet mandiindoma nâip ekŋen ke indayaŋkwesimane zet pe zigok mandiindoyap e ekŋenaŋ zeme nâmbak.” ");
INSERT INTO naf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kegok zeme an tipdakutum damuŋ mti tapmambien ekŋenmagengatnaŋ ŋenaŋ bepalaksat naŋgumaŋ somti zeye, “Geŋ sâpe sâpe bumbu an sambe ekŋengalen ŋeŋaŋin temaŋ kapi zet keboŋ ke eneyet dundunik?” ");
INSERT INTO naf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Zeme Zisasiyaŋ an ke ekti pigok zeye, “Neŋ zet bekanaŋ ma pembenaŋ zeya ze yaŋaŋ weyaŋ zemane nâmti tapmaŋgut nowek. Geŋ belak kileŋ etaŋ eneyet nonik?” ");
INSERT INTO naf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Zeme Anasiyaŋ sâpe sâpe bumbu an sambe ekŋengalen ŋeŋaŋin mulupmaŋ temaŋ delaŋ zeme belak pemti mamtan keyepmti Zisas betnaŋ ewe zapeŋ ke tapme zempeme sâpe sâpe bumbu an sambe ekŋengalen ŋeŋaŋin alakŋaŋ tatnaŋ Kaipas ekmagen wati mebegat zemindeye. ");
INSERT INTO naf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Âpme Pitayaŋ ewe tep ke kâpmambe tapme am notnaŋaŋ ekti yaŋkwesiwien, “Geŋ kapi pe an kandayet nembaŋane ekŋengat tuŋguwinaŋgatnaŋ ŋen geŋ kapi ma zem tatnânup?” Âpme egaŋ zeye, “Neŋ yek penaŋ.” ");
INSERT INTO naf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Zeme Pitayaŋ sâpe sâpe bumbu ŋeŋaŋgat mulup anaŋ ŋen wakŋaŋ sâmpeye keyet notnaŋaŋ ekti zeye, “Geŋ saŋenen ekmak ilinsakwep muluwen daen mamane gikman pi.” ");
INSERT INTO naf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Zeme Pitayaŋ yaŋti zeye, “Neŋ penaŋ egat ku nâyap.” Zeme zeme keyegak pepup apmaŋaŋ yaŋbemti kâkâkâââk kuye. ");
INSERT INTO naf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tambuyet pi Kaipasiyelen mkaen ke zet mulup mti tapmetnepeme msame watoti naman Loma amobotnaŋ Pailet Zelusalem mkaen matatan ekmagen wati meti ilin penaŋ amobotnaŋ Pailet egalen mkaen ku mobien. Ekŋenaŋ puk nâmti mbien, “Nin Aŋgalalaŋ Kendoyen tu meu niniyelen kan sokŋanik bein kapi egalen mkaen mopmann ŋep ku besem.” Kegok nâmti zupman baenak kot tabien. ");
INSERT INTO naf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ekŋenaŋ wakoti belak tambaŋgumen baen tapme indikti Pailelaŋ mka keŋangatnan toti pigok indayaŋkwesiye, “In an ke pe yom zigok mme wati kotalip?” ");
INSERT INTO naf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Indayaŋkwesime ekŋenaŋ zewien, “An kapi bekanaŋ ku mnak ze nin wati geŋmagen kapi ku kobenek.” ");
INSERT INTO naf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Zeme amobotnaŋ Pailelaŋ pigok diindoye, “In ilinaŋgalen zii zelin tazin keyet kataŋ nâmtati zetnaŋ zemdelaŋ zempeit.” Zeme Zuda am ekŋenaŋ zewien, “Nin am ŋen zetnaŋ zemdelaŋ zemti kumann gakikiyet ku nâmndendeŋaŋ.” ");
INSERT INTO naf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zuda am ekŋenaŋ kegok zemti Zisas Loma amobotnaŋgat betnan beme Zisasiyaŋ maneti bam tep palen nomti masasoknewep zeye zet ke penaŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Âpme Pailelaŋ mkaŋaŋ keŋan motati Zisas zemandame mopme pigok yaŋkwesiye,” Geŋ penaŋ Zuda am ekŋengalen Amobotnaŋ manze zemane nâmbi?” ");
INSERT INTO naf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yaŋkwesime Zisasiyaŋ zeye, “Zet ke am notnaŋaŋ zeme nâmti zenik ma gitaŋgat keŋdaŋgalak nâmti tazenik?” ");
INSERT INTO naf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Zeme Pailelaŋ zeye, “Neŋ Zuda an keyepmti nâgât tatnayaŋkwesinik? Zet ke gitaŋgat amdine ma sâpe sâpe bumbu an ŋeŋaŋdine ekŋenaŋ geŋ zigok mmane gikti gati nâlen pi kolo?” ");
INSERT INTO naf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Zeme Zisasiyaŋ zeye, “Wa neŋ Amobotnaŋ msat kapiyetnaŋ yek. Neŋ Amobotnaŋ kululuŋen gwaengatnaŋ. Neŋ msat kapiyelen Amobotnaŋ mambak ze neŋ aminne zemindema ekŋenaŋ nadamuŋ katikŋaŋ mtapme Zuda am ekŋenaŋ ŋep ku natamti kobiek.” ");
INSERT INTO naf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Zeme nâmti Pailelaŋ zeye, “Âpme geŋ Amobotnaŋ temaŋ ŋen geŋ bekapi?” Yaŋkwesime Zisasiyaŋ pigok zeye, “Giti zenik kemak! Neŋ zet penaŋ ŋotekŋaŋ kapi zemkawaŋ bembeyet nâmti msalen kapi toti am mamaen sokbewan. Am zet penaŋ ŋotekŋaŋ kapiyet yaŋaŋ manâmâtâlip ekŋenaŋ nâlen zetn manâip.” ");
INSERT INTO naf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Zeme Pailelaŋ nâmti pigok zeye, “Zet penaŋ ŋotekŋaŋ ke pe kwilekiyet nâmti tazenik?” Kegok zemti ewe tambaŋgumen toti Zuda am pigok diindoye, “Neŋ ankaŋgwayelen yomaŋ ŋen ku aigap. ");
INSERT INTO naf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Keyepmti neŋ ilinaŋgalen set tazin keyet kataŋ Aŋgalalaŋ Kendo kataŋ am mka katikŋanen tatatnaŋ an ŋen ilin zeme nâmpema zupman makwawezin keyet kataŋ zeme neŋ Zuda ilinaŋgalen Amobotnaŋin kapi belak zempema totogalen nâip?” ");
INSERT INTO naf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Âpme ekŋenaŋ kwizet ŋak ŋak temaŋ mti zewien, “Wa ek yek. Balabasiŋgut belak zempemane tolak!” Balabas egaŋ Loma gapman mtoindeme keyepmti ekŋenaŋ wati mka katikŋaŋ mepewien. ");
INSERT INTO naf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Amgat zemiŋgeyaŋ yek beme gilik zem mka keŋan wapmoti Zisas kume gakikiyet zetnaŋ zemdelaŋ zemti kasa kuku an zemindeme sindiwaŋ witikti ");
INSERT INTO naf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","sepmeŋ muŋguŋti ŋokŋanen peme topme kâlâp teepmaŋ ŋamaŋ piyaŋ munduŋpeme tapme ");
INSERT INTO naf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","zimosetnan met ondektati kwizet kaliaŋ temaŋ msamti mbien ke pep mtiyepm zewien, “Geŋ Zuda am ekŋengalen Amobotnaŋ kan teepmaŋ telepgat penaŋ mamambanik.” Zemti bepalaksat neŋguman taiwien. ");
INSERT INTO naf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Âpme Pailet egaŋ Zuda am ekŋenmagen ewe toweti zeye, “Neŋ an kaŋgwa yomaŋ penaŋ timapma bemeyepmti watotindesât totdiindoyap. Keyepmti in ilin nâmti talip keyet kataŋ msaseip.” ");
INSERT INTO naf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Zemti mot Zisas ek sepmeŋ tekŋaŋ ŋokŋan kwasim pewien ma kâlâp ŋamaŋ teepmaŋ munduŋ pewien mee bee melesiŋ watoti Pailelaŋ zikat indamti zeye, “In an bukapi ekti kembeŋ bugan mip ma yek?” ");
INSERT INTO naf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Zeme sâpe sâpe bumbu an ŋeŋaŋ ekŋen ma amiŋine sambe ekŋenaŋ kwizet ŋakŋak mti zewien, “Tewen kume gakik! Tewen kume gakik!” Kume Pailelaŋ zet dopmaŋ pigok gilik zemti indaye, “Neŋ yomaŋ ŋen ku aiga keyet in ilin nâipnok wati met tewen kume gakik!” ");
INSERT INTO naf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Âpme Zuda am ekŋenaŋ pigok zewien, “An keyaŋ ikŋaŋgat, ‘Neŋ Kawawaŋgat Nemuŋaŋ,’ zemti mobotnaŋ mamm. Ma zii zetnnan an mobotnaŋ keboŋ ke indome gakikiyet zenzeŋaŋ. Keyepmti an Kawawaŋgat zet mobotnaŋ mamin kapi kume gakisem.” ");
INSERT INTO naf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Zeme Pailelaŋ zet mobotnaŋ mamm zewien ke nâmti kiŋgage. ");
INSERT INTO naf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mti Zisas ewe mka keŋan gilik zem wapmoti pigok yaŋkwesiye, “Geŋ pe mkandi ŋotekŋaŋ pe deset?” Yaŋkwesime Zisasiyaŋ zetnaŋ dopmaŋ gilik zemsasapiŋ; ");
INSERT INTO naf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","belak etaŋ tapme Pailelaŋ pigok dunduye, “Geŋ zetn dopmaŋ ŋen eneyet ku gilik zemti nanik? Neŋmagen winde zemdelaŋ zema tewengoŋgoyelen ma belak zemgema mebegalen tatnain ke ku nâmnenik?” ");
INSERT INTO naf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Zeme Zisasiyaŋ pigok dunduye, “Geŋ nâgât zetn zemdelaŋ zenze keyet winde Kawawaŋ kululuŋen gwaen mamain egaŋ gaye keyepmti geŋ nâgât zetn zemdelaŋ zesâpmnik. Belak ze geŋ nâgât zetn ŋep ku zemdelaŋ zewek. Mme am nati kot gâlen belen neyo ekŋengalen yominaŋ gâlen sebempein.” ");
INSERT INTO naf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailelaŋ zet ke nâmti set ŋen aikti Zisas belak zempeme kwaweweget zeme Zuda am ekŋenaŋ kwizet kaliaŋ kumti zewien, “Geŋ an ke belak zempemane mesem beme damuŋdi temaŋ Sisa ekmak Loma mka ŋotakŋan tazin ekmak tususundi ku tabe. An ŋenaŋ amobotnaŋ nen kwep zemti amobotnaŋ Sisa mimtopewe beme Sisayaŋ ekmak kasa kasa mbe.” ");
INSERT INTO naf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailelaŋ zet ke nâmti egaŋ Zisas wati zupman baen toti egaŋ zemdelaŋ zenze munduman mototage. Mundum ke nanzaŋaŋ weyaŋti kwetetepmaŋ mpepeŋaŋ keyepmti Ibulu zeleset Gabata makumtemien. ");
INSERT INTO naf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kan ke ilak Aŋgalalaŋ Kendo saŋen ŋokŋan tatagalen beye keyepmti zet mulup ke tapmimetnepeme tinsutnan penaŋ beme Pailelaŋ Zuda am pigok diindoye, “In Amobotnaŋin wa piyet egit!” ");
INSERT INTO naf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Zeme ekŋenaŋ kwizet kaliaŋ temaŋ kumti zewien, “An ke kumeŋ gakik, kumeŋ gakik, tewen kumasasokpeit!” Âpme Pailelaŋ zet dopmaŋ pigok diindoye, “Ilinaŋgalen Amobotnaŋin kapi neŋ tewen kumasasokpepeyet nâmti tazeip?” Zeme sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ Pailetgat pigok zewien, “Wa nin amobotnaŋŋ zutmak yek. Nin amobotnaŋŋ Sisa kwewetaŋ.” ");
INSERT INTO naf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Am sambeyaŋ zet sambe ke mme ekti Pailelaŋ nâme ŋep kumbeme Zisas nâmisimti tewen kumasasokpepeyet zemdelaŋ zempeye. ");
INSERT INTO naf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Zemdelaŋ zempeme kasa kuku an ekŋenaŋ Zisas tep palen bemkukuyelen tepmaŋ bee ikŋaŋ mesame pumti Golgata kalaŋan mowebien. “Golgata” ke Ibulu ekŋengalen zeleset makuip âpme ningalen zeleset ŋokaset Kalaŋ kuwanek. ");
INSERT INTO naf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ke wapmoti tewen kumasasok pewien. Zisas tuŋgupman kumpemti an zut nembet nembet gakikiyet kogogak kumindewien. ");
INSERT INTO naf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Âpme Pailelaŋ zeme Zisas kuwien tep keyet dukŋanen gwaen meluwaŋ kapigok kumpewien, ");
INSERT INTO naf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Zisas kumpewien msat keyet sokŋan bee Zelusalem mka ŋande temaŋ ke matatan. Âpme Amobotnaŋ Pailelaŋ zeme meluwaŋ ke Ibulu ekŋengalen zeleset ma Glik ma Latin zeleset kumpeme tage. Âpme amnaŋ setemamen mekoti zet ke maiŋnâmbien. ");
INSERT INTO naf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Keyepmti sâpe sâpe bumbu an ŋeŋaŋ ekŋenaŋ ekme ŋep ku beme Pailetgat pigok dunduwien, “Geŋ, ‘Zuda am ekŋengalen Amobotnaŋ kegok eneyet kumpenak.’ Yegat, asekti naman pigok kumpe, ‘An kapiyaŋ ikŋaŋgat pigok manzein, “Neŋ Zuda ekŋengalen Amobotnaŋ.” ’” ");
INSERT INTO naf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Zeme Pailelaŋ pigok zeye, “Neŋ zet ilak kumpeya ewe asekti naman sepem ŋen ewe ku kusap.” ");
INSERT INTO naf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","Âpme an kasa kuku ekŋenaŋ Zisas tewen kumpeme tapme sekŋanen kwitnaŋ kwitnaŋ gulum m timti maŋge zulak zulak beme tapme ikŋaŋgat ikŋaŋgat toŋaŋ toŋaŋ tiwien. Âpme kâlâpmaŋ keŋaŋgatnaŋ teepmaŋ keŋgut ku seliliŋaŋ keyepmti pigok zewien, “Pi mineti mendelepmann kileŋ besemagengat kopme nin nanzaŋ guluk gilik mti an kwiyaŋ ŋeŋaŋ kwasem beme egaŋ kâlâp ke mti mesem zemti kegok mbien.” Sepem kegok mme Kawawaŋgalen Zet Itnaŋanen meluwaŋ pigok mimiŋaŋ tazin keyet kataŋak beye, “Ekŋenaŋ sekŋanen kwitnaŋ kwitnaŋ gulum m timti toŋaŋ toŋaŋ tiwien. Âpme kâlâp teepmaŋ keŋaŋgatnaŋ ke nanzaŋ guluk gilik mti an ŋeŋaŋ kwage egaŋ mge.” ");
INSERT INTO naf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Zisas tewen kumpeme tapme Zisas ikŋaŋgat mamaŋ ma maweneŋaŋ Malia Kolopasiyet imbiŋaŋ ma Malia Makdala mkaengatnaŋ imbi ekŋen keyaŋ Zisasiyet kembeŋ nâmti met tep mwatonzempewien kandaŋan tati ekpeme mopme tapmambien. ");
INSERT INTO naf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tapmann Zisasiyaŋ nâgât gogot penaŋ mamtan kegogapm mamaŋmak nit tapmalu ndikti mamaŋgat zeye, “Maŋge, nemundi kemak mamambalup.” ");
INSERT INTO naf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Zemti neŋ nikti zeye, “Geŋ mamdi talup kapimak mamambanik.” Âpme ke tatneti kwawesâti neŋ Zisasiyet mamaŋ wati mkannanen meti ekdamuŋ mpema mamamtan. ");
INSERT INTO naf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Zisasiyaŋ tewen ke anzam tati gakikiyaŋ keŋaŋ minzilim kopme nâmti pigok nâŋge. Mulup msalen mkoban ewan ilak alak delaŋ zein. Zemti Kawawaŋgalen Zet Itnaŋanen zet ŋen kapigok tazin ke penaŋaŋ bembeyet zet pigok zeye, “Neŋ tuyet penaŋ miyapgat tu ŋen omti name nimbi.” ");
INSERT INTO naf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Âpme ekŋenaŋ menzim ŋen wain tu akŋaŋ penaŋ pi kasim pepeŋaŋ ke ekti yembem notnaŋ timti takaset dukŋan gwaen tegaŋ ŋeliwen zampemti peme menzim keŋan ke towepme mkwati peme mane mane dembusekŋan mot olaŋme ke ululuk niŋge. ");
INSERT INTO naf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wain tu akŋaŋ penaŋ ke nimti zeye, “Ilak msalen mulup mimin delaŋ zein.” Kegok zemti gakimti ŋokŋaŋaŋ gwak zemtoge. ");
INSERT INTO naf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kan ke Aŋgalalaŋ Kendo tatagat kan sokŋanik penaŋ beye keyepmti Zuda am ekŋenaŋ Pailetgat pigok zewien, “Saŋenen tagoŋgo kanen am sekŋaŋ ekŋenaŋ tep dukŋanak ku tabep.” Zeme Pailelaŋ an kasa kuku ekŋenaŋ am ekŋen ke met selin kasetnaŋ kume etume anzam tati gakime sekŋin timti met indabembeyet nâmindeye. ");
INSERT INTO naf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","33","Âpme kasa kuku an ekŋenaŋ meti an zut bekanaŋ mimi Zisasmak idowien. Eget ke met ŋen setnaŋ kasetnaŋ kume etume met ŋen setnaŋ kasetnaŋ kume etume Zisasmagen koti ekbienalak ek ilak gakim weŋgeyepmti setnaŋ kasetnaŋ ku kume etuye. ");
INSERT INTO naf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Belak kasa kuku an ŋenaŋ ŋeliwaŋ gatnaneset omti ŋelip seŋkwapme sipmak tumak lumaŋ tobun. ");
INSERT INTO naf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Neŋ sokŋan ke tati ekma kwitnaŋ kwitnaŋ ke nanaŋgat zikatn palen sokbeme ekban keyepmti zet kapi kumti indayap. In zet kapi nâme penaŋ sukwep penaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kwitnaŋ kwitnaŋ kapi Kawawaŋgalen Zet Itnaŋanen zet ŋen kapigok tazin ke penaŋaŋmak bembeyet nâmti sokbemmâge, “Ekŋenaŋ kanziŋaŋ ŋen ku kume etuwe.” ");
INSERT INTO naf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Naman zet itnaŋanen keyegak zet ŋen pigok tazin, “Ekŋenaŋ ŋeliwaŋ omti seŋme amnaŋ zikalin gwalalaŋ ek ekbep.” ");
INSERT INTO naf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Âpme Zosep Alimatia mkaengatnaŋ an ke Zisasiyelen maŋge yaŋgut sosok sokbemti mama Zuda amobotnaŋ ekŋenaŋ nikmâtâti mka katikŋan met newepmagen zem meti buzak enzilim mamtan. An keyaŋ Zisas sekŋaŋ mti met bembeyet Pailet yaŋkwesime ŋep bembeyet nâmpeme met Zisas sekŋaŋ mâtâtosât mege. ");
INSERT INTO naf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Met mâtâtoti tobeme tapme Nikodimas an tambuyet buzak moti Zisasmak zet zenâmbun an keyaŋ bam mâti mege. Egaŋ mesâti wet am sekŋin mme sesikŋaŋ dolakŋaŋ mapein ma keyaŋ am sekŋin mme sambumbupiŋ kwesiŋ matazin ke mti mege keyet nukŋaŋaŋ 50 kilo mee kegok. ");
INSERT INTO naf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Meti Zosep mukulem mme egelaŋ Zisas sekŋaŋ Zuda ilin am gakime sekŋin miak indemti maindabemtemien keyet kataŋ wet sesikŋaŋ dolakŋaŋ zulutpemti sâk satnaŋaŋ weyaŋ sumuŋpemalu tapme besât luanzamti mebun. ");
INSERT INTO naf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Zisas kuwien msat keyet nembet daeset tep belak mulup ŋen matatan ke nanzaŋ temaŋ ŋen eweŋan am bembeyet nâmti kakalimpepeŋaŋ ke am ŋen ku indabembeŋaŋ belak etaŋ matatan. ");
INSERT INTO naf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Âpme Zuda am ekŋen ilak tagoŋgo kan tatagat kan bududuk penaŋ beye keyepmti egelaŋ Zisasiyet sekŋaŋ sakwep mâtâpmti sokŋan ke met bempemti kobun. ");
INSERT INTO naf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sonda tambuŋan penaŋ msat ewe sasat takume Malia Makdala mkaengatnaŋ keyaŋ Zisas sekŋaŋ eksâgât meti ekme an zulaŋ nanzaŋ temaŋ ŋen wilili pemalu met enzuŋ bekek tage e naman wililipeme kaiŋan met tage. ");
INSERT INTO naf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kegok ekti egaŋ weŋaŋ mepme windembem mane mane Saimon Pitamak neŋ Zisasiyaŋ nâgât gogot mamtan ninmagen meti zeye, “An zut, Amobotnaŋ sekŋaŋ piwan ewande ŋen mmelo mme neŋ sumen daen meti ekma yek bep!” ");
INSERT INTO naf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kegok zeme Pitamak neŋmak nâmti am sumen daen eksât mebelin. ");
INSERT INTO naf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Windembem mane mane Pita ewe sewak sewak tapmepme neŋ sakwep windembem met sumen pataŋ zewan. ");
INSERT INTO naf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Meti keŋan baen ku toweban. Belak zupman baen tati bim kekesimti saŋgum satnaŋ etaŋ baen tapme ekban. ");
INSERT INTO naf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Âpme Pitayaŋ bam met pataŋ zemti keŋan keim toweti saŋgum satnaŋ kwasimpewien kwep weme ege. ");
INSERT INTO naf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ma ŋokŋanen sâk kwasim pepeŋaŋ e kegogak weyaŋ mutumti igak bempepeŋaŋ tapme ege. ");
INSERT INTO naf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Âpme neŋ kegogak keŋan toweti nilisakwep kwitnaŋ kwitnaŋ sambe ke ekmâti pigok nâmkiŋpewan. Zisasiyaŋ ikŋaŋ wasât zeme nâmban walek penaŋ kapi wati melep. ");
INSERT INTO naf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mme nemba notnaŋ ekŋenaŋ Kawawaŋgalen Zet Itnaŋanen Zisasiyaŋ gakikiengatnan wawagat zetnaŋ meluwaŋ mimiŋaŋ ke ekŋenaŋ ku nâmbien. ");
INSERT INTO naf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ke ekti egelaŋ belak weŋit mepme am zaimengatnan kwakwadak mkaen mebun. ");
INSERT INTO naf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Âpme Malia Makdala mkaengatnaŋ keyaŋ naman met sum ganzenan ganzenan ke tokwat sumti mgeyaŋ yek beme met bimkekesimti zikatnaŋ sum keŋan baen ekpeme mepme Kawawaŋgalen ensel zut kâlâwit satnaŋ satnaŋaŋ miakpewun piyaŋ Zisas peme wengeen ke ŋenaŋ setnaŋaŋ weŋgeeset ŋenaŋ ŋokŋaŋaŋ weŋgeeset totapmambun. ");
INSERT INTO naf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Egelaŋ imbi ke ekti zewun, “Imbi, geŋ pe kwilekiyet nâmti tasunik?” Âpme egaŋ zeye, “Amobotnaŋ nnaŋgalen sekŋaŋ pi ewande ŋen mmepme munduman timapma beme tasuyap.” ");
INSERT INTO naf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kegok zemti gilik zemti wa belakŋan zem Zisas ikŋaŋ ege yaŋgut kapi Zisas ke ku ekmâtâge. ");
INSERT INTO naf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Âpme Zisasiyaŋ pigok yaŋkwesiye, “Imbi, geŋ pe kwilekiyet tasunik?” Zeme imbi keyaŋ wa mulup kapiyet damuŋaŋ ŋenaŋ mene tazin zemti pigok dunduye, “An sum damuŋ, geŋ mene an sekŋaŋ kapi mti ewande ŋen met benak beme zemane nâmti met mkobi.” ");
INSERT INTO naf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Zeme Zisasiyaŋ Malia pigok dunduye, “Malia!” Zeme nâmti Maliayaŋ eleŋ zem kwat Zisas ekti Zuda zeleset pigok zeye, “Laboni!” (Zet keyet yaŋaŋ An Zikat Indanda.) ");
INSERT INTO naf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Zemti endilipemti atasât mme Zisasiyaŋ pigok dunduye, “Geŋ kot sekŋ timakmakpiŋ! Neŋ Bienmagen ewe mobopiŋ talapgat! Geŋ notnne ekŋenmagen meti pigok diindo, ‘Neŋ nin sambeyet Bipmmagen ma nin sambeyet Kawawaŋmagen mowebap.’” ");
INSERT INTO naf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Zeme nâmti Malia Makdala mkaengatnaŋ keyaŋ sakwep windembemti Zisas ikŋaŋgat nembaŋane ninmagen meti pigok dinndoye, “Neŋ Amobotnaŋ ekti kolap!” Zemti zet dunduye ke dinndomâge. ");
INSERT INTO naf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","20","Âpme Sonda tambuyet nin mka kwep ŋeniyet mot ondek tati Zuda amobotnaŋ ekŋengat kiŋgati setn kili kili penaŋ kekti tapmann Zisasiyaŋ belak tuŋgupmnan ke petak zem kwatati pigok dinndoye, “Inmagen keŋ sewakŋaŋaŋ wembe.” Kegok zemti betnaŋ zembeŋaŋ nembet nembet ma gatnanen zembeŋaŋ ke zikat ndaye. Âpme nin Zisas ekti keŋŋ dolakŋaŋ penaŋ beme tabenn. ");
INSERT INTO naf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Âpme ewe pigok dinndoye, “Inmagen keŋ sewakŋaŋaŋ wembe. Bienaŋ neŋ zemneme toti inmagen mulup mban kegogak neŋ in muluwen mebegat zemindeyap.” ");
INSERT INTO naf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kegok zemti indakumbumti zeye, “In Emetak Teŋ tit. ");
INSERT INTO naf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","In am yomin zemzulutindewep beme yomin penaŋ yek bewe. Âk am notnaŋgat yomaŋ tatagat nâmpewep beme yomaŋ ke kaliŋaŋ tabe.” ");
INSERT INTO naf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Âpme Zisas nembaŋane 12 ninmagengatnaŋ nemba ŋen kwitnaŋ Tomas ek keyet kwitnaŋ ŋen Didimas manzemtemenn, ningalen zeleset, nemba pepet kegok zewanek. Egaŋ ewande ŋen mame Zisasiyaŋ nemba notnaŋ etaŋ sokbemindaye. ");
INSERT INTO naf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Keyepmti nemba notnaŋ nin Zisas sokbemndame ekbenn nin zewenn, “Nin Amobotnaŋ sokbemndame ekŋ.” Zemann Tomasiyaŋ pigok dinndoye, “Neŋ nen penaŋ betnaŋ palakŋan gwilim zembeŋaŋ ke ma gatnanen ŋelip zembeŋaŋ ke betnaŋ atam ektiŋgut zelin kapi nâma penaŋ bewe.” ");
INSERT INTO naf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Zemti mamotnepeme Sonda ŋen beme naman Tomasmak nsakwep mka keŋaŋ ŋengat ondekti mka wanok setnaŋ keŋaset kili kili kekpemti tapmambenn. Tatnepemann Zisasiyaŋ ewe tuŋgupmnan pataŋ zem kwatati pigok zeye, “Keŋ sewakŋaŋ inmagen wembe.” ");
INSERT INTO naf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Zemti Tomas pigok dunduye, “Geŋ zewanangat betn zembeŋaŋ pi timak ekbak ma betdaŋ daen pemane mepme ŋelip zembeŋaŋ timak nâmbak. Mti keŋ zut ewe mimipiŋ; penaŋ nâmkiŋpemne.” ");
INSERT INTO naf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Zeme Tomasiyaŋ atam ekti zeye, “Geŋ penaŋ Amobotnaŋŋ ma Kawawaŋŋ!” ");
INSERT INTO naf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Zeme Zisasiyaŋ pigok dunduye, “Geŋ natimak ekti keyepmti nâmkiŋpemnenigat. Âpme am neŋ sepem eekpiŋ belak manâmkiŋpemneip am ekŋen ke Kawawaŋaŋ indamukulem mimindeme oloŋen palen penaŋ mamambep!” ");
INSERT INTO naf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zisasiyaŋ ewe msalen pien mamti menok sepemaŋ igak igak sambe penaŋ nembaŋane ningat zikatnnaŋ mamimkwapme ektemenn. Sambe bee papiaen pi ku kuma delaŋ zemâge. ");
INSERT INTO naf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bugan pi kumpepeŋaŋ pi ilak kapigogapmti kukuŋaŋ. In sambeyaŋ maiŋnâmti Zisas ek Kilais ek Kawawaŋgat Nemuŋaŋ penaŋ ke nâmkiŋpepeyet bugan kapi kumpewan. Keyepmti an ŋenaŋ zet kapi maiŋnâmti egat nâmkiŋpewe beme egaŋ mama kanzizit aikbe. ");
INSERT INTO naf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","3","Mamoti Zisas nembaŋane 7 ke nin kapigok: Saimon Pita, Tomas kwitnaŋ ŋen Nemba pepet, Natanael Galili mkaengatnaŋ ma Zebediyet nemulatnenet ma nembaŋane zut nit ewe Taibilias tundua ganzenan met ondek tapmmann Saimon Pitayaŋ nin pigok dinndoye, “Neŋ aŋgalayet timasât tapmiap.” Zeme nin nsakwep meti waŋgaen moti meti tambu tetak pi mulup temaŋ mti aŋgala ŋen ku atawenn. ");
INSERT INTO naf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ke tapmimetnepemann ilak msaye. Âpme Zisasiyaŋ gambibik palen daen tapmame ekbenn. Yaŋgut nin an ke Zisas ke ku nâmâtâpewenn. ");
INSERT INTO naf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mme Zisasiyaŋ ndikti kwizet pigok kuye, “An ekŋen da, in aŋgala ŋen mandayo ma yek?” Ndayaŋkwesime nin zewenn, “Yek, ŋen ku mandann.” ");
INSERT INTO naf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Zeme pigok dinndoye, “In eleŋgolamin mti naman waŋga ganzenan bet penaset peme topme aŋgala omba mandait.” Zeme nin eleŋgolam mti waŋga nembeleset pemann towepme aŋgalayaŋ totne totne eleŋgolam bepi gak zem tapme eleŋgolam mandamann kwasâgât teŋteŋ penaŋ siwenn. ");
INSERT INTO naf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Âpme neŋ Zisasiyaŋ nâmneme dolakŋaŋ mambemtan keyaŋ Pitayet pigok zewan, “Pita, an kanda ilak Amobotnaŋaŋ ikŋaŋ tazin nânik.” Zeme Saimon Pitayaŋ nânâŋak kâlâpmaŋ mti biman kaikti tuyen palam toti tukutumti tu paleset zelelaŋ mege. ");
INSERT INTO naf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","9","Âpme waŋga bugan nembu sutnanik daen 100 mita mee kegok tage keyepmti nemba notnaŋ nin waŋga mme kaiŋan mopmann eleŋgolam aŋgala melesiŋ mandapemann kaiŋanik motapme gambibik palen gwaen moti ekmann tep kwetnanen aŋgala ma meu mee piyaŋ tazimaŋge. ");
INSERT INTO naf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Âpme Zisasiyaŋ dinndoye, “In aŋgala tiyo e notnaŋ pienen mti kolit.” ");
INSERT INTO naf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Zeme Saimon Pitayaŋ waŋgaen moti eleŋgolam tekŋaŋ pi kwaleti eleŋgolam aŋgala melesiŋ mandamti katikŋan mot peme weŋge. Keŋanen bee aŋgala temaŋ temaŋ penaŋ 153 bekapiyaŋ tabien yaŋgut eleŋgolam tekŋaŋ ku etiye. ");
INSERT INTO naf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mme Zisasiyaŋ pigok dinndoye, “In aŋgala ke tapme pien kot meu timti nit.” Zeme nin ilak Amobotnaŋ elak nâmpewenn keyepmti nin, “Geŋ pe an kwi?” kegok ke ku yaŋkwesiwenn. ");
INSERT INTO naf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Âpme Zisasiyaŋ kot totati aŋgalamak meu tewen tapmaŋge ke timti kalaŋ ndame nimbenn. ");
INSERT INTO naf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Zisasiyaŋ gakikiengatnan wati nin sek zut ilak sokbemndaye yalak kan piyet sokbemndame sek tuk bein. ");
INSERT INTO naf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nin meu ke ndame nimann delaŋ zeme Zisasiyaŋ Saimon Pita pigok yaŋkwesiye, “Saimon, Zângat nemuŋaŋ, nodine ekŋenaŋ nâgât keŋin temaŋ penaŋ bemti gogot mamimneip. Âpme geŋ nâgât zigok penaŋ manâmnenik?” Zeme Pitayaŋ zeye, “Amobotnaŋ, neŋ gâgât gogot omba penaŋ mamiyap elak ŋep nâmnenik.” Zeme Zisasiyaŋ zeye, “Geŋ nâlen sipsip maŋge maindadamuŋ mmambanik.” ");
INSERT INTO naf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kegok zemti ewe keyegak sakwalamti zeye, “Saimon, Zângat nemuŋaŋ, geŋ penaŋ nâgât gogot penaŋ maminik?” Zeme Pitayaŋ zeye, “Amobotnaŋ, neŋ gâgât gogot penaŋ mamimgeyap e nâmnenik.” Zeme Zisasiyaŋ zeye, “Geŋ sipsip maŋganne maindikdamuŋ mmambanik.” ");
INSERT INTO naf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Zeme Zisasiyaŋ ewe sakwalamti pigok yaŋkwesiye, “Saimon, Zângat nemuŋaŋ, geŋ penaŋ nâgât gogot mamimnenik?” Egaŋ zet sepemaŋ kwep ke yaŋkwesime sek tuk beme Pitayaŋ nâmti keŋaŋ bekanaŋ penaŋ beme zeye, “Amobotnaŋ, geŋ kwitnaŋ kwitnaŋ sambeyet yaŋaŋ nâmane delaŋ manzein. Neŋ gâgât gogot mamimgeyap e kegogak nâmnenik.” Zeme Zisasiyaŋ zeye, “Geŋ sipsip maŋganne kapi maindikdamuŋ mmambanik. ");
INSERT INTO naf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Neŋ penaŋ sukwep penaŋ pigok diŋgoma nâmbak, geŋ nembaengatnan mamkwabanan yaŋ ewe mamobanik pi bitimdi giti zamti set deset ma deset mesâti giti nâmtati mamepmambanik. Yaŋ maneti an penaŋ bewanik kan keyet geŋ bedi etaŋ mwapmane am notnaŋ ekŋenaŋ bitimdi zamgemti geŋ mesât ku nâmbanigen ke gaik mebep.” ");
INSERT INTO naf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zisasiyaŋ kegok zemti Pitayaŋ zigok gakiwe keyet zet bimbim zet zeye gakikiŋaŋ sepemaŋ igak keyaŋ Kawawaŋgat kwizet buŋamaŋ mim wawagat zeye. Zet kegok dundumâti pigok dunduye, “Geŋ nâlen nemba penaŋ kwati mamambanik.” ");
INSERT INTO naf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Âpme Pitayaŋ gilik zemti ekme Zisasiyaŋ neŋ nemba ektikŋaŋ mampemtan keyaŋ egegat bamidan penaŋ mepma nikbun. Neŋ Aŋgalalaŋ Kendoen meu tatnimambenn kan keyet neŋ Zisasiyet wakŋan bemti pigok yaŋkwesiwan, “Amobotnaŋ, pe kwiyaŋ geŋ zemgowe?” ");
INSERT INTO naf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Neŋ bamidan taidamâtmepma Pitayaŋ nikti Zisas pigok yaŋkwesiye, “Amobotnaŋ, nemba kapi bam amnaŋ zigok msame gakiwe?” ");
INSERT INTO naf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yaŋkwesime Zisasiyaŋ pigok dunduye, “Egaŋ ewe alik mame neŋ gilik zemti kobap ma gakime kobap e nen nâyap. Âpme geŋ zet keyet eneyet tatnayaŋkwesinik? Geŋ nâlen nemba penaŋ kwati mamambanik.” ");
INSERT INTO naf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Âpme am Zisas nâmkiŋpemti mamtemien notnaŋ ekŋenaŋ zet ke nâmti Zângat pigok zemyuŋguwien, “Nemba kapi ku gakiwe.” Wa Zisasiyaŋ ek gakikipiŋ telepgat mamambe keyet nâmti ku zeye. Pitayaŋ yaŋkwesime keyepmti Zisasiyaŋ pigok zeye, “Egaŋ ewe alik mame neŋ gilik zemti kobap ma gakime kobap e nen nâyap. Âpme geŋ zet keyet eneyet tatnayaŋkwesinik?” ");
INSERT INTO naf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Neŋ kwitnaŋ kwitnaŋ sambe ke eknâm mima delaŋ zemâge keyepmti zet sambe beke papiaen kapi weyaŋ zemâtâti kumâti peyap. Keyepmti nin zet meluwaŋ kumpeye kapiyet nâmann penaŋ penaŋak bein. ");
INSERT INTO naf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Âpme Zisasiyaŋ kwitnaŋ kwitnaŋ mkwage sambe bee ilindiŋ papiaen kuma topmâdak ze papia ŋotekŋaŋ sambe penaŋ sokbemâdak. ");
INSERT INTO naf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiopilas an notn, neŋ eweŋan tipman baen papia kum gawan ke Emetak Teŋaŋ Zisas winde same egaŋ kwitnaŋ kwitnaŋ mti ombemindendeŋaŋŋane nânâ zikat indamkwage keyet Zapatnaŋ ma mulupgat yaŋaŋ zikat indamti msat kataŋ mekoti mulupmaŋ mimiyet mulup belinan bemindemti kululuŋen mowege keyet zapatnaŋ kum gama ekbanan. ");
INSERT INTO naf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Âpme Zisas amnaŋ sindem sameti kume gakime bewienaŋ bamgat gilik zem wati kasup 40 kegok ewe msalen kapiyegak mamti Ombemindendeŋaŋŋane kan sambe sokbemenzilimimindamti maŋge. Mneti ekŋenaŋ pe penaŋ wageyaŋ main ma yek kegok zemti keŋ zut mbiekgapmti egaŋ yaŋaŋaŋ zemkawaŋ bem indamti Kawawaŋgalen zemâtâtât katnanen mama keyet zapatnaŋ kegogak diindoye. ");
INSERT INTO naf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Âpme kan ŋengat ondek tati Zisasiyaŋ Ombemindendeŋaŋŋaneyet zeye, “In Zelusalem mka temaŋ kapi ku peme tapme mebep. In kapiyak tatnepeme neŋ eweŋan kwileki ŋen Bienaŋ indandayet zetik mge keyet zapatnaŋ zema nâmbien ke sokbemindawe. ");
INSERT INTO naf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nâip, Zânaŋ am tu etaŋaŋ manzulutindemtan yaŋ kan belaknik kapi mamopme Kawawaŋaŋ Emetak Teŋ ingat keŋinan bemindewe.” ");
INSERT INTO naf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Zisasiyaŋ Ombemindendeŋaŋŋanemak Olip kalaŋan mot ondek tati Ombemindendeŋaŋŋaneyaŋ Zisasiyet yaŋkwesiwien, “Amobotnaŋ, geŋ alak Islael am maŋge ndaondak ndemti ningalen Amobotnaŋŋ temaŋ bemane nin Itali msalen amobotnaŋ Loma mka teman tazin egat kandaŋan ewe ku tabanup?” ");
INSERT INTO naf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kegok yaŋkwesime Zisasiyaŋ zeye, “Bienaŋ kwitnaŋ kwitnaŋ ke mme sokbembeyelen windeŋaŋ tasainaŋ kanaŋ beye ke ewe tazingat in eneyet keyet tatnayaŋkwesip yaŋgut ke ingalen kwitnaŋ kwitnaŋ yek. ");
INSERT INTO naf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","In belak kapi tatnepeme Emetak Teŋaŋ kopme in ke time winde indame nâgât zet zapat zenze an bemti Zelusalem mkaen ma Zudia msalen mka sambe tapmezinen ma Samalia msalen mka sambe tapmezinen ma msat sambe zet zapatn zempalakŋaŋ beme pelelaŋ bem mekobe.” ");
INSERT INTO naf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Zisasiyaŋ zapat kegok diindomti tapme Kawawaŋaŋ mme Zisasiyaŋ eleŋ beleŋ bemti kululuŋen mopme Ombemindendeŋaŋŋane ekŋenaŋ ektitipeŋ tatnepeme zanza ŋenaŋ koti utuk kekme eekpiŋ mbien. ");
INSERT INTO naf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Mopme ekŋenaŋ kululuŋen gwaenegak ektitipeŋ tatnepeme keyegak an zut melakanduŋit satnaŋaŋ ekŋenmagen sokbem tati zewun, “Galili mkaengatnaŋ an, in kwilekiyet zikalin kululuŋen gwaenen negak ekpeme mowepme talip? Zisas in taekme indemti kululuŋen mowelep ek maneti sepemaŋ keboŋak ewe gilik zemkopme ekbep.” ");
INSERT INTO naf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kegok zeme nâmti ekŋenaŋ Olip Kalaŋ ke katipemti Zelusalem mkaen gilik zemti mebien. Olip Kalaŋaŋgatnan Zelusalem mkaen mametemienen set tuŋgupmaŋ ke maeliŋaŋ butnaŋ etaŋ mametemien. ");
INSERT INTO naf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Meti Zelusalem mka temanen pataŋ zemti mot mundumin matatemien keyegak an kwilin kapigogaŋ motabien: Pita, Zân, Zems, Endulu, Pilip, Tomas, Batolomiyu, Matiyu, Zems, Alipiasiyet nemuŋaŋ, ma Saimon, itnaŋaŋ an maŋge Zilot ekŋenmak maŋge ekmak Zuda, Zemsiyet nemuŋaŋ an kegogaŋ tapmambien. ");
INSERT INTO naf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","An ekŋen ke ma Malia Zisasiyet mamaŋ ma imbi notnaŋ ma Zisasiyet meniŋane ekŋenaŋ keŋ kwep bemti dundundu mulup kan kataŋ omteŋ mamkwatemien. ");
INSERT INTO naf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Kan kataŋ kegok maondak metne peme bamgat ondedak ŋengat am nâmkiŋpepeŋinmak 120 kegogaŋ tapme Pitayaŋ ondedagen ke watati zeye, “Dapmeniŋŋne, eweŋan tipman baenen Kawawaŋgalen Emetak Teŋaŋ Zudasiyaŋ Zisas kasa ekŋen zemsokbemindame atawep keyet zet zapatnaŋ Dewit zemsokbemsame zemkawaŋ beye keyet penaŋaŋ ilak sokbeme ekbenn ke. ");
INSERT INTO naf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zudas ek ningalen maŋgaengatnaŋ Zisasiyaŋ ikŋaŋ mulup ninmak mimiyelen nâmti ombempeyeyaŋgut egaŋ kileŋ beye.” ");
INSERT INTO naf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Keyepmti egaŋ myuŋguŋguŋaŋgalen tosaŋaŋ ke timti msat kwitiye. Msat ke kwitimti msatnanen ke met anzamti diliŋ zem tokumti kambakŋaŋ epeeme tipmaŋ wiselepmaŋ âlâk zemti zupman kwawege. ");
INSERT INTO naf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kogok mme Zelusalem mka temanen am sambe tabien ekŋenaŋ Zudasiyet zapatnaŋ ke nâmti msat keyet kwitnaŋ ilinaŋgat zelinaset Akeldama zewien, zet ke ningalen zeleset gilik zewanegen, Sip Sombem kegok benak). ");
INSERT INTO naf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Âpme Pitayaŋ Kawawaŋgalen zet zapat itnaŋaŋ Sam papiaen zet tazin ke mti pigok zeye, “‘Mkaŋaŋ ŋepgat belak tabe an ŋenaŋ ke ku tabe.’ Âpme Sam ikŋaŋ keyegak zet ŋen pigok tazin, ‘Mulupmaŋgut an ŋenaŋ toŋaŋ bemti mbe.’ ");
INSERT INTO naf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Keyepmti nin Zuda egat munduman an ŋen Zân tu zululut anaŋ mulup mge keyetnaŋ yaŋbemti kwat Zisas Kawawaŋaŋ kululuŋen wati moge. Kan tuŋgupmaŋ ke ninmak mamkwati kwitnaŋ kwitnaŋ sambe bee ekmâtâpme delaŋ zemâge. An keboŋ aikmann ninmak mamti Zisas wawatnaŋgalen zet zapat kapi zemkawaŋ bewe.” ");
INSERT INTO naf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pitayaŋ kegok zeme an zut idaikbien. An ŋen kwitnaŋ Zosep Balsabas manzemtemien ma ikŋaŋ keyak kwitnaŋ ŋen Zastas ma an ŋengat kwitnaŋ Matias. ");
INSERT INTO naf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Idaikidemti dundundu mulup mti zewien, “Amobotnaŋ, geŋ am ningat keŋŋnaŋgat yaŋaŋ nâmâtâdik. Keyepmti geŋ an zut kapiyet nâmane an kwiyaŋ Zuda an mama mgasik mâti metneti keyet dopmaŋ timti gakiye. Egat munduman tati egaŋ Zisasiyaŋ mulup zet ndaye ke mimiyet nânik beme aik ndamane eksenup.” ");
INSERT INTO naf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kegok dundumti ekŋenaŋ takaset zut teepmaŋ ŋen pemkwepmaŋ ŋen mti butnaŋ baen aŋgalaŋ tati butnaŋ etaŋ zenzelim peme kwatapme Matiasiyaŋ teepmaŋ seŋ mge keyepmti egaŋ Zudasiyelen mundum ke time Ombemindendeŋaŋ ewe 12 munduminan egaŋ kwapme kegok beye. ");
INSERT INTO naf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","2","Nup kan kataŋ Pentikos Kendoyet Kawawaŋgat sâpe sâpe bumbuyet kwitnaŋ kwitnaŋ timti buluŋ belaŋ mmekoti mambemtemien ke beme am nâmkiŋpepemak ekŋenaŋ mka keŋaŋ kwepgat ondek tatnepeme keyegak kululuŋengatnan tâgâ kwisaknok temaŋ penaŋ kumtoti ekŋenaŋ mka tabienen ke kwisakŋaŋaŋ bemisik tage. ");
INSERT INTO naf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kwisak kokume ekbienaŋ taŋam nambalam keboŋaŋ am tabien kataŋ ekŋenmagen pelelaŋ beme tapmâge. ");
INSERT INTO naf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Emetak Teŋaŋ keŋinanen bemisik indemti zet sambe keŋinan bemindeye kataŋ yaŋbemti zet ŋen ŋenaset zemâbien. ");
INSERT INTO naf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Âpme Zuda am sambe mulupgapmti msat sambe mekoti mamtemien ekŋenaŋ Kawawaŋgat zetnaŋ kandaŋan mamamtemien. Ekŋenaŋ kendo keyet koti keyegak tapmambien. ");
INSERT INTO naf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yaŋ Emetak Teŋ toge kan keyet am ekŋen keyaŋ tatnâme kwisak temaŋ takume pe kwilekiyaŋ tapm zemti weŋin mepme kwaweti ekme Zisasiyet nembaŋane ekŋen Emetak Teŋaŋ nânâ indame ekŋenaŋ zet zapat dolakŋaŋ tazeme am sambe keyaŋ nâme zelinan esemteŋ tazeme nâmâtâpmâbien. ");
INSERT INTO naf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Meluwaŋ mamanamaŋ kegok mme ekŋenaŋ nâmtemtem temaŋ mti zewien, “An ekŋen zet ŋen ŋenaset tazeip an ekŋen kapi Galili msalengatnaŋ etaŋ. ");
INSERT INTO naf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nin msat kataŋ met ambesomti ekŋengalen zet nâwenn zet keyegak ikŋaŋgat ikŋaŋgat kapi zigoset nâmti zeme nâmâtâpmann delaŋ zein. ");
INSERT INTO naf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nin bepi msat sambe kapigogatnan kopmobenn: Palitia, Midia, Elam Mesopotamia msalengatnaŋ, Zuda, Kapadosia, Pontas, Esia, ");
INSERT INTO naf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pilisia, Pampilia, Izip ma Libia msat ilindiŋ ke Sailini msat keyet sokŋanik. Ninmagengatnaŋ am notnaŋ Loma mka temaŋgatnan kopmâbien. ");
INSERT INTO naf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ma Zuda am penaŋ ma am Zuda maŋgaen tususuŋaŋ ma notnaŋaŋ Kilit ma Alebia msat sambe keyetnan kopmâbien. Kawawaŋaŋ an ekŋen kapimagen menok temaŋ mme ekŋenaŋ am sambe nin bepi ninaŋgat zetnnaset Kawawaŋgalen zet zapatnaŋ pi zemâtâtndame tuluŋ telaŋ penaŋ weyaŋ nâmâtâtnup.” ");
INSERT INTO naf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ekŋenaŋ ke ku weyaŋ ekmâtâti nâmtemtem mti ilinak zenâ zenâ mti zewien, “Kwitnaŋ kwitnaŋ kapi yaŋaŋ zigoset sokbein?” ");
INSERT INTO naf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mme am notnaŋ ekŋenaŋ an nâmkiŋpepeŋinmak ekŋengat zet kanzowak mti zewien, “Ekŋen tu katikŋaŋ niyoyaŋ keŋin kileŋ beme zet kilom kilom tazeip.” ");
INSERT INTO naf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Âpme Ombemindendeŋaŋ 11 ekŋenaŋ ilinsakwep watati Pitayaŋ am sambe penaŋ tabien ekŋengat kwizet kumti pigok diindoye, “Zuda am notnne ma amkup notnaŋ koti Zelusalem mkaen tadik, in wakŋin weyaŋ beme neŋ kwitnaŋ kwitnaŋ tasokbein kapiyet yaŋaŋ zema weyaŋ nâit. ");
INSERT INTO naf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","In nâme nin kapiyaŋ tu katikŋaŋ nimti keŋŋ kileŋ tabein mene kegok otnâmndeip. Yaŋgut yek. Pi ewe tambuŋan 9 kilok etaŋ pimak. ");
INSERT INTO naf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Muluwaŋ kapi sokbembeyelen Kawawaŋgalen golaŋ zenze an Zoel egaŋ kapiyet eweŋan baenen Kawawaŋaŋgalen Zet Itnaŋanen pigok zeme nâmti meluwaŋ kapigok mge, ‘Kan bududuk beme neŋ nemunambaŋine ekŋenaŋ neŋmagen bamgat zigok sokbeweyet zet timti zemkawaŋ bemâbep. Ma nembaŋine zomolim notnaŋ ekŋen zikalin mitima meluwaŋ mamanamaŋ notnaŋ ekbep ma ailip ekŋen kwitnaŋ kwitnaŋ notnaŋ kieset zikat indama ekbep ma Emetakŋ Teŋ msat sambe am keŋinan bemisik indewap. ");
INSERT INTO naf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ma kan keyet sisiliŋ animbinne ekŋen Emetakŋ Teŋaŋ keŋinan mulat indema ekŋenaŋ neŋmagen bamgat zigok sokbeweyet zet indama zemkawaŋ bemâbep. ");
INSERT INTO naf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Neŋ kululuŋen ma msalen menok notnaŋ kapigok mma sokbemâbe. Msalen tep temaŋ zime kasak temaŋ kwaikbe ma am sipmaŋ kileŋ mulapmebep ma kululuŋen neŋ kasup zikatnan mma sopsop kuwe ma eyoŋga zikatnaŋaŋ ŋamaŋ sip nemboŋ beme Amobotnaŋaŋ kopme oloŋen mimi keyet kanaŋ ke bewe. ");
INSERT INTO naf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kegok sokbeme an ŋenaŋ Amobotnaŋgat kwitnanen dunduwe beme egaŋ aŋgalaŋpewe.’ ");
INSERT INTO naf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Islael am notnne, in zet kapi tatnâme zema nâit: Kawawaŋaŋ ikŋaŋ Zisas Nasalet mkaengatnaŋ mulup same egaŋ inmagen menok kwitnaŋ kwitnaŋ mzikat indamkwapme ekmâtâbien. ");
INSERT INTO naf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ewaŋan tipman baen Kawawaŋaŋ ikŋaŋ ke mimiyelen nâmâtâtpeye keyet kataŋ inmagen sokbeme in an bekanaŋ mimi penaŋ ekŋengat belinan beme ekŋenaŋ tewen kumasasok peme tati gakiye. ");
INSERT INTO naf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yaŋgut gakikiyelen windeyaŋ ku atam tage. Kawawaŋaŋ mme gilik zem wati gakikiyelen nukŋaŋ sambe beye gaipeme weŋge. ");
INSERT INTO naf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Keyet Dewilaŋ eweŋan Zisasiyet zetnaŋ kapigok zemkawaŋ beye, ‘Neŋ Amobotnaŋ ekma zimosetnnan kwesiŋ matazin. Egaŋ nâgât betn penaset tazingapmti kwilekiŋen nukŋaŋaŋ ku naikbe. ");
INSERT INTO naf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Egaŋ neŋ gakikiengatnan mme wapma mama kanzizit nanayet zetik mneŋgeyet webem mayap. Keyepmti neŋ nâma dolakŋaŋ penaŋ beme zetn oloŋen palen manzeyap. ");
INSERT INTO naf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Geŋ ek ketalatpemane am gakikiŋaŋ mundumen ku tabe. Ma geŋ Nemundi Teŋ ek pemane gakimti sekŋaŋ msalen ku sambuwe. ");
INSERT INTO naf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Geŋ mama kanzizitgalen set zikat nawanan. Âpme gâgât monzalamdan neŋ oloŋen temaŋ penaŋ mbap.’ ");
INSERT INTO naf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Notnne, neŋ yeŋŋ sokŋ Dewit egat zet pigok penaŋ zemkawaŋ bema nâit. Ek ilak itnaŋaŋ gakime bewien yaŋ bewien ke am zaimaŋ sosok tapme maeknup. ");
INSERT INTO naf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ek golaŋ zenze an mamkwapme Kawawaŋaŋ egat zetik mpemti kapigok zemkatik bempeye. In sokdine ekŋenmagengatnaŋ an ŋen aikma egaŋ nâlen Amobotnaŋ mundumm ke tiwe. ");
INSERT INTO naf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ke nâmti eweŋanak tipman baen Kilaisiyaŋ gakimti wabeyet zetnaŋ pigok zeye, ‘Kawawaŋaŋ am gakikiŋaŋ ekŋengat tuŋguwinan peme wemti sekŋaŋaŋ ku sambuwe.’ ");
INSERT INTO naf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Zet keyet kataŋ Zisas ek Kawawaŋaŋ gakikiengatnan mme wapme nin Zisas walep elak penaŋ ekmâtâbenn. Keyet zapatnaŋ kapi manzemkawaŋ benup. ");
INSERT INTO naf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Egaŋ wati moti Kawawaŋgat betnaŋ penaset moti tapme Kawawaŋaŋ Zisasiyet Emetak Teŋ peme totogat zetik mpeye keyet kataŋ Emetak Teŋ peme toti ninmak tati mulup mme in alak egat yaŋaŋ kapi sokbeme egip. ");
INSERT INTO naf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Dewit sekŋaŋ melesiŋ kululuŋen ku moge yaŋgut zet belak kapigok etaŋ zeye, ‘Kawawaŋaŋ nâlen Amobotnaŋgat pigok dunduye, “Kot betn penaset tot tapmane neŋ kasandine maŋge kwep bemindema geŋ windeŋin mtoindewanik.” ’ ");
INSERT INTO naf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Keyepmti Islael am in pigok nâmkatik beseip, in Zisas an yomengatnan ndatitiyet koge an ke tep palen kume gakiye. Kilais ek ke Kawawaŋaŋ alak mtati Amobotnaŋ onzempeme tazin.” ");
INSERT INTO naf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pitayaŋ zet kegok zeme amnaŋ nâmtemtem mti Pita ma ombemindendeŋaŋ an notnane notnaŋ pigok indayaŋkwesiwien, “Notnne, nin zigok penaŋ mmann ŋep penaŋ besem?” ");
INSERT INTO naf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Zeme Pitayaŋ pigok diindoye, “In kwep kwewaŋ bekanaŋin eknâmti yomengatnaŋ gilik zemti Zisas Kilais nâmkiŋpemti egat kwitnanen tu zulutme Kawawaŋaŋ ingat yomin katikpewe. Kegok mme Kawawaŋaŋ in Emetak Teŋ taolet m indawe. ");
INSERT INTO naf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ilin ma nemunambaŋine ma am msat sambe tapmelip kapi Amobotnaŋ Kawawaŋgat zetnaŋ nâmti ekmagen kobep kataŋ egaŋ Emetak Teŋaŋ indandayet zetik mpeye ke indawe.” ");
INSERT INTO naf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitayaŋ zet kegok diindomti ewe tusumti golaŋ zet pigok diindoye, “In am myuŋguŋguŋin temaŋ ekŋenmagen peme tapme keŋin gilik zemti kobep. Am bekanaŋ ekŋen ke Kawawaŋaŋ indawaletbe nâip!” ");
INSERT INTO naf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kegok zeme kasup keyegak am 3000 mee kogaŋ Kawawaŋgalen zet zapat dolakŋaŋ nâmti nâmkiŋpeme tu zulutindeme Kilaisiyelen am maŋge ekŋenmagen tusuwien. ");
INSERT INTO naf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Âpme am ekŋen kapi ombemindendeŋaŋ ekŋenaŋ Kawawaŋgalen zet zapat dolakŋaŋ mandiindom kwatemien. Mti keŋ kwep penaŋ bemti tambuŋalem niniyet ma dundundu mulup mimiyet mene mene maondaktemien. ");
INSERT INTO naf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Âpme Kawawaŋaŋ ombemindendeŋaŋ ekŋengat palesetgatnaŋ menok sambe penaŋ mgeyepmti am sambe ekŋenaŋ nâmtemtem palen mamkwabien. ");
INSERT INTO naf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Am nâmkiŋpepemak ekŋenaŋ keŋ kwep bemti kwitnaŋ kwitnaŋin sambe bee temakwep apalak tim nimwiaŋ wiaŋ mmamkwabien. ");
INSERT INTO naf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ma ekŋenaŋ msalin mkaŋin ma kwitnaŋ kwitnaŋin sambe bee ketalasime amnaŋ keyet tosaŋaŋ mânep indame timti ondek bemti naman ilinagak olat zeme kataŋ kalaŋ indame matimtemien. ");
INSERT INTO naf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ekŋenaŋ tambu misa kataŋ Zuda am ilinaŋgalen sesewat mka teman ilindiŋ maondaktemien. Ondekpemti naman kalaŋti mka ŋen mka ŋen mekoti meu time kwawepme ilindiŋ kalaŋ kumnimti oloŋen palen tati tambuŋalem manimetemien. ");
INSERT INTO naf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mama mimi dolakŋaŋ kegok mkwati Kawawaŋ kwizet buŋamaŋ mwati sesewatsamkwapme am notnaŋaŋ ke egomti ekŋenmagen tusumti nâmkiŋpepe aikme Amobotnaŋ Kawawaŋ ikŋaŋgalen maŋgeen ke matusum indemtan. ");
INSERT INTO naf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kan ŋeniyet Pitamak Zân egelaŋ 3 kilok dundundu kanaŋ beme Zuda am ilinaŋgalen sesewat mka teman dundundu mulup msât mowebun. ");
INSERT INTO naf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Âpme an ŋen setnaŋ wesiŋ mamkeŋ keboŋ sokbembeŋaŋ an ke notnaneyaŋ tambu msa luaen luenzamti kot Zuda ilinaŋgalen sesewat mka temaŋ keyet “Setokwakwat Dolakŋaŋ” manzemtemien keeset peme tati ekme am sambeyaŋ sesewat mka temanen mobot totot mme indikti mânep milawatgat mawekumindamtan. ");
INSERT INTO naf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","4","An keyaŋ tati idikme Pitamak Zân egelaŋ sesewat mka teman mowesât mmalu idikti kegogak mânep milawatgat idawekume egelaŋ ek eksememuŋ mtati Pitayaŋ pigok dunduye, “Geŋ pien ndikbak!” ");
INSERT INTO naf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","6","Mme an setnaŋ bekanaŋ egaŋ wa kwileki ŋen nasâpmilup mene zemti eleŋzemoidikme Pitayaŋ egat zeye, “Nit mânep milawat mene ŋen ku tatndain. Kwewetaŋ tatndain ke gasâpmilup. Zisas Kilais Nasalet mkaengatnaŋ egat kwitnanen zeyapgat wati met!” ");
INSERT INTO naf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Kegok zemti betnaŋ penaset betname setnaŋ ŋandoŋaŋ dolakŋaŋ beme sakwep eleŋ beleŋ bemti wat mutututi mebekokot mti egetmak ilinsakwep sesewat mka temaŋ keŋan moti set mamaŋaŋgat oloŋen mti palam mobot totot mti Kawawaŋ zemsesewatpeye. ");
INSERT INTO naf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Âpme an keyaŋ set tapmamti Kawawaŋ tasesewatsame am sambeyaŋ ekti nâmtemtem mti zewien, “Sesewat mka temaŋ ‘Sekekek Dolakŋaŋ’ manzeip ke totati mânep milawatgat ndawekumti matazin wa an ikŋaŋ kapimak zemti nâmtemtem mbien.” ");
INSERT INTO naf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","12","An keyaŋ Pitamak Zân egetmagen met ilinsakwep mka keŋan ŋen kwitnaŋ Solomon makumtemien ke mame amnaŋ indikti buluŋ bililiŋ ilinsakwep ekŋenmak ke met ondektati nâmtemtem temaŋ mti tapme Pitayaŋ am ke indikti pigok diindoye, “Am in kapi kwilekiyet an wesiŋ dolakŋaŋ bep keyet ektemtem mti nit ŋandem tatndigip? Kwitnaŋ kwitnaŋ ke ndaŋgat windenidaŋgat ma teŋ mamanndaŋgat mamaŋaŋ ku aiksalut. ");
INSERT INTO naf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nit yeŋsokŋne Abalaam ma Aisak ma Zekop mee ekŋengalen Kawawaŋ egaŋ Nemuŋaŋ Zisas ek Amobotnaŋ mwat onzempemti winde temaŋ saye. An ke in zemkumti kasa kuku an ekŋengat belinan beme ekŋenaŋ wati amobotnaŋ Pailetmagen mepme egaŋ yomaŋ ŋen ku aikti belak zempeme mebegalen mgeyaŋgut in zekaŋkaŋ mti kume gakikiyet zewien. ");
INSERT INTO naf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","In An Teŋ ma Kwatetepmaŋ ek bamkumpemti amobotnaŋ Pailetgat kwizet kaliaŋ kumti an bekanaŋ am indom enzilili ke nâmpeme inmagen totogat zewien. ");
INSERT INTO naf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mti in An mama toŋaŋ ek kume gakiye yaŋgut Kawawaŋaŋ gakikiengatnan mme gilik zem wage. Nin an keyet zet zapatnaŋ manzempalakŋaŋ benup. ");
INSERT INTO naf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Keyepmti nit Zisasiyaŋ ikŋaŋ winde ndame nit nâmkiŋpepemak tati ikŋaŋgat kwitnanen an kapi mmalu dolakŋaŋ bemti ingat zikalinan tapme taegip kapi. ");
INSERT INTO naf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Notnne, neŋ ŋep nâmindeyap in ma amobotnaŋine in Zisasiyet yaŋaŋ ku nâmtiyepm ek yomepiŋaŋgut belak kegok msawien. ");
INSERT INTO naf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","In meluwaŋ ke mme Kawawaŋaŋ golaŋ zenze anane ekŋengat zeme ekŋenaŋ Kilais sindem nâmeti gakikiyet zet zapatnaŋ dolakŋaŋ papia itnaŋanen meluwaŋ mkwabien ke penaŋaŋmak beye. ");
INSERT INTO naf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Keyepmti in yomengatnaŋ keŋin gilik zemti Kawawaŋmagen kopme egaŋ mama mimiŋin bekanaŋ ke katikpemti gilik zemindatime in sek welelaŋin kwawepme mambep. ");
INSERT INTO naf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Zisas Kilais ke Kawawaŋaŋ ninmagen peme kokogat ombempeye. Yaŋ maneti zempeme ninmagen kapi toge. ");
INSERT INTO naf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Zisasiyaŋ Bipmaŋgalen mowegeen keyegak mame Bipmaŋaŋ msat kululuŋ pi asekti naman alakŋaŋ mme sokbemâbe keyet zetikŋaŋ eweŋan golaŋ zenze anane teŋ zemindeme ekŋenaŋ keyet zapatnaŋ esemteŋ zemkawaŋ bemâbien. ");
INSERT INTO naf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Golaŋ zenze an ekŋen keyet tuŋguwinaŋgatnaŋ ŋen Moses egaŋ zet kapigok zemsokbeye, ‘Amobotnaŋ Kawawaŋaŋ inmagengatnaŋ nolin ŋen mwat onzempeme egaŋ neŋ golaŋ zenze an mamayap keyet kataŋ mamti zetnaŋ zeme nâmti gawepuwep. ");
INSERT INTO naf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Golaŋ zenze an keyelen zetnaŋ am notnaŋaŋ gawepumti ekmagen ku tusuwep beme Kawawaŋgalen maŋgeengatnan zemindeme zupman meti walelet aikbep.’ ");
INSERT INTO naf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Âpme eweŋan tipman baenen golaŋ zenze an Samuel ma notnaŋ egat bamaŋ mamkwabien ekŋenaŋ kan kapi sokbembeyet zetnaŋ papiaen meluwaŋ mkwabien. ");
INSERT INTO naf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","In golaŋ zenze an ekŋengat nemunambaŋine in kapiyet Kawawaŋaŋ yeŋsokŋin Abalaamak tususu mti egat zetik pigok mpeye ke toŋaŋ in bewep. Kawawaŋaŋ egat pigok zeye, ‘Neŋ gâlen maŋgaengatnaŋ an ŋen egat pembenaŋgapmti msalen am sambe talip ekŋenmagen kwitnaŋ kwitnaŋ dolakŋaŋ mimindawap.’ ");
INSERT INTO naf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","In kapiyepm Kawawaŋaŋ eweŋan nâmâtâti Nemuŋaŋ Zisas zempeme kot msalen kapi sokbeye ke in ŋeŋaŋ mama mimi bekananengatnan indapmukulem mti gilik zemindatitiyet kegok mge.” ");
INSERT INTO naf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","3","Pitamak Zânaŋ ke tati animbi zet kegok diindomambe tapmalu sâpe sâpe bumbu an ekŋen ma Zudayelen sesewat mka temaŋgalen an tipdakutum ekŋengat ŋeŋaŋin ma zii zet zikat indanda an ekŋenaŋ kopmâbien. Ekŋenaŋ kotati ekme Pitamak Zânaŋ Zisasiyaŋ wage ma am gakikiŋaŋaŋ wabep keyet zapatnaŋ animbi sambe tadiindom kwapmalu ekŋenaŋ keyet nâme ŋep ku beme indatimti zemidosât nâmbienaŋgut msat gasi beyeyepmti belak idatimti met mka katikŋan sekek idewien. ");
INSERT INTO naf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yaŋgut am egetgalen zet nâmti notnaŋaŋ nâmkiŋpepe aikti Zisasmagen tusume am nâmkiŋpepemak sambe penaŋ temakwep 5000 mee kogok beye. ");
INSERT INTO naf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","7","Msa msame sâpe sâpe bumbu an ŋeŋaŋ ma sesewat mka temaŋgalen an damuŋ notnaŋ ma zii zet zikat indanda an ekŋenaŋ meti sâpe sâpe bumbu an ŋeŋaŋin temaŋ Anas ma egalen maŋgaengatnaŋ am notnaŋ ma Kaipas ma Zân ma Aleksandia ma sâpe sâpe bumbu an notnaŋ ekŋenmak temakwep Zelusalem mka teman ondekti Pitamak Zân tuŋguwinan onzemidemti pigok idayaŋkwesiwien, “It winde kwiyaŋ ma kwiyet kwitnanen ma meluwaŋ zigok penaŋ mti an wesiŋ kapi mmalu dolakŋaŋ beyan?” ");
INSERT INTO naf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Idayaŋkwesime Pitayet keŋanen Emetak Teŋaŋ zet same zelin dopmaŋ pigok gilik zemindaye, “Sâpe sâpe bumbu an ŋeŋaŋŋne ma sesewat mka temaŋgalen an damuŋŋne in nit awesiŋ ke zigok penaŋ mti mmalu dolakŋaŋ bep keyet yaŋaŋ penaŋ nâsâgât ndayaŋkwesimti talip. ");
INSERT INTO naf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Keyepmti nit zemkawaŋ bemalu in ma Islael am ilinsakwep yaŋaŋ nâmâtâlit. Zisas Kilais Nasalet mkaengatnaŋ e in tewen kumasasok peme gakime bewien. Yaŋ Kawawaŋaŋ naman gakikiengatnan mme wageyaŋ main. Egat kwitnanen an wesiŋ kapi sekŋaŋ mmalu dolakŋaŋ beyanaŋ kapi tapme taegip. ");
INSERT INTO naf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","An Zisas keyet Kawawaŋgalen Zet Itnaŋanen baen meluwaŋ kapigok mimiŋaŋ tazin, ‘Mka walalat an ekŋenaŋ tepum ŋen bekanaŋ zemti peme meweŋgeyaŋ alak tepum keyaŋ mka tepumaŋ kaliŋaŋ penaŋ bemti mka atam tazin.’ ");
INSERT INTO naf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kawawaŋaŋ msalen an ŋenaŋ am ŋen yomengatnan gilik zemti indatitiyet winde ŋen ku saye. Egaŋ Zisasiyaŋ mulup ke mimiyet nâmti ek etaŋ saye.” ");
INSERT INTO naf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Zet keboŋ keboŋ etaŋ tazemalu am tabienaŋ nâmti zewien, “An zut kapiyaŋ nânâ mka temanen ku mebun. Zisasmak belak mamtemunaŋgut nânâ kaboŋ kapi deeset tiwunaŋ kiŋgagapiŋ pi nâmtalati tazelup.” Zemti nâmtemtem penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Âpme ekŋenaŋ an setnaŋ bekanaŋ weyaŋpewun ke egetmak ilinsakwep tapme indikti zet dopmaŋ ŋen gilik zemindandayet nâme ŋep ku beme peme tage. ");
INSERT INTO naf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kegok zemti tabienaŋ yek beme eget zemideme zupman towepmalu ilinak tati pigok zenâ zenâ mbien, ");
INSERT INTO naf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“An zut kapi zigok mimidasenup,” zem zenâwien? “Egelaŋ menok ke msokbemalu Zelusalem mkaen animbi sambeyaŋ keyet zapatnaŋ ilak nâme delaŋ zep keyepmti nin ŋep ku iyaŋ indendeyelen bein.” ");
INSERT INTO naf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Zem mbienaŋ yek beme zewien, “Yegat mulup ewe tusum mmalu am sambeyaŋ nâmbepgapmti nin zemkiŋgagat zet zemann egelaŋ keyet kiŋgati Zisasiyet kwitnaŋ ewe ku mpalakŋaŋ bewalup.” ");
INSERT INTO naf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kegok zemnâmpemti naman idazemtetime mka keŋanenak mowepmalu pigok zewien, “It am ŋen ewe Zisasiyet yaŋaŋ ŋen ku zemzikat indawalup.” ");
INSERT INTO naf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kegok zeme Pitamak Zân egelaŋ zewun, “Nit zet kapi zemalu ilin opem nâit. Ingalen zet gawepumti Kawawaŋgalen zet peŋ pemalu toweme keyet Kawawaŋaŋ nigat nâme zigok bewe? ");
INSERT INTO naf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nit Zisasiyet mulupmaŋgat yaŋaŋ sambe be ekmâtâpmalu delaŋ zeye. Keyepmti kwizapatnaŋ kapi belak atam pemalu ku tabe.” ");
INSERT INTO naf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Egelaŋ kegok zemalu an ŋeŋaŋ ekŋenaŋ zemkiŋgagat zet notnaŋ ewe tusumdiidomti belak ideme toti mebun. Am sambe ekŋenaŋ muluwaŋ ke ekti Kawawaŋgat sesewatsawien keyepmti an temaŋ temaŋ ekŋen keyaŋ kwindemti an zut ke kwileki ŋen ku miidawien. ");
INSERT INTO naf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","An wesiŋ Pitamak Zânmak menok temaŋ egat palen mti weyaŋpewun. An ke nup kanaŋ 40 sebempein. ");
INSERT INTO naf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pitamak Zânaŋ amobotnaŋ ekŋenaŋ katikideme egelaŋ nâmkiŋpepemak am nolitne ekŋenmagen koti ondedagen sâpe sâpe bumbu an ma sesewat mka temaŋgalen an damuŋ notnaŋ ekŋenaŋ zet zewien keyet zapatnaŋ mimindawien. ");
INSERT INTO naf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Âpme ekŋenaŋ zet ke nâmti keŋin ondek kwep bemti Kawawaŋgat pigok dunduwien, “Amobotnaŋ, geŋ kululuŋ msat ma nembu temaŋ ma kwitnaŋ kwitnaŋ sambe mamaŋaŋmak wemezin kapi mmane sokbem mâge. ");
INSERT INTO naf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Geŋ ningat yeŋsokŋ Dewit mulup andi Emetakdi Teŋaŋ keŋaŋ m eleŋ beleŋ beme zet kapigok zeye, ‘Zigogat am Zuda maŋgaen ku sokbembeŋaŋ ekŋenaŋ Amobotnaŋgat ŋenzinziŋ mti kusât tapmip? Ma pe kwilekiyet am ekŋen kapiyaŋ ondekti kwitnaŋ kwitnaŋ yaŋaŋ yaŋepiŋ kapi msâgât tazenâip? ");
INSERT INTO naf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Msalen an damuŋ sambe ekŋenaŋ Amobotnaŋ Kawawaŋ ma Nemuŋaŋ Kilais egetmak âsâgât keŋ kwep bemti zenâ zenâ tapmip.’ ");
INSERT INTO naf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Dewilaŋ zeye keyet kataŋ amobotnaŋ Elotmak amŋane Islael ekŋenmak am Zuda maŋgeen ku sokbembeŋaŋmak amobotnaŋin Pailet ekŋenaŋ mka temaŋ kapi temakwep bemti Kawawaŋ geŋ Zisas mulup andi teŋ ke pemane am yomengatnan ndatitiyet ombempemti zempemane koge ek kume gakikiyet mulupmaŋ penaŋ sukwep mbien. ");
INSERT INTO naf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Geŋ eweŋan baen mulup andi kemagen kwitnaŋ kwitnaŋ ke sokbembeyet zemkabewanan keyet kataŋ sokbemsaye. ");
INSERT INTO naf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yaŋ alak pi naman nin Zisas mâti mamann amnaŋ ningat kasa tapminndaip keyet Amobotnaŋ geŋ kasa keyet keŋan winde ndamti ndamukulem mmane nin kiŋgagapiŋ gâlen zet zapadi dolakŋaŋ kapi ammagen windeŋambeŋ zemkawaŋ bemann zet zapadaŋ palakŋaŋ bewe. ");
INSERT INTO naf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kawawaŋ, geŋ mulup andi teŋ, Zisas egat mti winde ndamane nin am zawatmak ekŋen mmann alik bewep ma nemundi Zisas egat kwitnanen nin menok yaŋaŋ igak igak mbanup.” ");
INSERT INTO naf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kegok dundum delaŋ zeme mka ondek tapmambienen ke titok temaŋ mti mekwapme Kawawaŋgalen Emetak Teŋaŋ am tabien bee keŋinan topme ekŋenaŋ kiŋgagapiŋ eleŋ belaŋ bemti zet zapat dolakŋaŋ am keŋan windeŋambeŋ penaŋ zemkawaŋ bemebien. ");
INSERT INTO naf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Zisas nâmkiŋpepeŋaŋ am ekŋenaŋ ondekti keŋ kwep bemti milawalin mee toŋan toŋan ku timamkwabien ekŋenaŋ milawalin belak apapalak timamkwabien. ");
INSERT INTO naf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kegok taindame ombemindendeŋaŋ ekŋenaŋ Zisas gakikiengatnan wage keyet zapatnaŋ windeŋaŋbeŋ am ekŋengat zemkawaŋ bewien. Âpme am nâmkiŋpepemak ekŋengat tuŋguwinan Kawawaŋgalen keŋ taolelaŋ bemisik tage. ");
INSERT INTO naf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ekŋenmagen ŋenaŋ ola olat palen ku maŋge. Ekŋenaŋ msalin mee tage ke an ŋenaŋ kwitime mânep ke mti met ombemindendeŋaŋ an ekŋengat belinan mambemtemien. ");
INSERT INTO naf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Âpme ekŋenaŋ ke timtati am ŋenaŋ kwileki ŋengat olati kot zeme kataŋ milombiŋinanengatnan ke timtati maindatemien. ");
INSERT INTO naf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Âpme kan keyet an ŋen Zosep ombemindendeŋaŋ ekŋenaŋ kwitnaŋ Banabas manzemtemien. (Banabas kwit keyet yaŋaŋ, An Zemgwatnaŋ Mimi.) An ke Liwaiyelen maŋgeengatnaŋ msatnaŋ Saipalasiyetnaŋ. ");
INSERT INTO naf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","An keyaŋ msatnaŋ an ŋeniyet zeme kwitime mânep ke mti kot ombemindendeŋaŋ ekŋengat belinan beye. ");
INSERT INTO naf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Awembiŋ zut ŋen mamamtemun apmaŋ kwitnaŋ Ananias imbiŋaŋ Sapila egelaŋ kegogak msalit butnaŋ ŋen tosayet zemalu amnaŋ kwitiwien ");
INSERT INTO naf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","3","yaŋgut mânep piwan timti imbiŋaŋmak zenâmti keŋ kwep bemti mânewit butnaŋ enzilim pemti butnaŋ etaŋ apmaŋaŋ mti met ombemindendeŋaŋ ekŋenmagen beme Pitayaŋ mânep ke ekti zeye, “Ananias, geŋ kwilekiyet Sadaŋaŋ keŋdi myuŋgume mânep msadaŋgat tosaŋaŋ tinak ke butnaŋ buzak enzilimpemti butnaŋ etaŋ mti kot Emetak Teŋ tatetipenik? ");
INSERT INTO naf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Geŋ msadi kegok nâmti belak pemane gitaŋgat zapat tadak. Ma an keyaŋ msadi kwitime mânepdi giti timti kwilekindi ŋen msât nâmti mbek piwan? Geŋ kwilekiyet mânep ekti keŋdi puŋpuŋ mme kegok mnak. Geŋ wa nin ku tetindenak; Kawawaŋ tetipenak nânik!” ");
INSERT INTO naf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Zet kegok zeme Ananiasiyaŋ nâmti keyegak tokutumti gakime am notnaŋ tabien ekŋenaŋ ekti kiŋgabien. ");
INSERT INTO naf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Âpme an zomolim notnaŋ tabien ekŋenaŋ moti egat sekŋaŋ sâgaŋ sumuŋti met am sumen bewien. ");
INSERT INTO naf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","Ke mti belaknik tatnepeme Ananiasiyet imbiŋaŋaŋ apmaŋgat zapat nânâpiŋ belak kwawopme keyegak Pitayaŋ egat zeye, “Msatgalen mânep kapi etaŋaŋ apdaŋ mti kobep?” Zeme imbiŋaŋaŋ zeye, “Ilak buke etaŋ keyalak ke mkobepmak.” ");
INSERT INTO naf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Zeme Pitayaŋ zeye, “Abdimak it kwilekiyet Emetak Teŋ tetipepeyet keŋit kwep belut? Nemba zomolim set tokwakwalen talip ekŋen kaimaŋ abdi mmet beyo yaŋ geŋ kegogak gapmet beseip!” ");
INSERT INTO naf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kegok zeme imbiwan setnaŋ kandaŋan ke tot gakiweme an nemba zomolim tabien ekŋenaŋ mka keŋan kwati sekŋaŋ mti apmaŋ bewien keyet solonan mebewien. ");
INSERT INTO naf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kegok mme am nâmkiŋpepeŋinmak maŋge ma am notnaŋ ekŋenaŋ zapat ke nâmti zemkiŋgagat omba penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","13","Ombemindendeŋaŋmak am nâmkiŋpepemak ekŋenaŋ keŋ kwep bemti sesewat mka temaŋ keŋaŋ ŋen Solomon manzemtemien ke maondaktemien. Mti tokwati am tuŋguwinan menok sepem igak igak mme ekti am notnaŋaŋ nâmkiŋpepemak ekŋengat nâmindeme mobotnaŋ beme ekŋenmak tususâgât manâmtemien yaŋgut Zuda amobotnaŋ notnaŋgat makiŋgatemien. ");
INSERT INTO naf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yaŋgut mulup ke ewe tusum mmepme animbi sambe penaŋaŋ Zisas nâmkiŋpemti ombemindendeŋaŋ ekŋengalen maŋgeen omba penaŋ metusumâbien. ");
INSERT INTO naf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Âpme ombemindendeŋaŋ an ekŋenaŋ menok sambe mme kwizet buŋamaŋaŋ mekopme nâmti keyepm am ekŋenaŋ noline zawat sek sindemak indaluanzam timti Pitayaŋ kasuwen kwawepme weŋaŋaŋ ekŋengat paleset kwawepme dolakŋaŋ beseip zemti ekŋen set ganzenan sin yaŋgemindeme toti selen dombem tapmebien. ");
INSERT INTO naf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Âpme Zelusalem mka temaŋ keyet sokŋanik mka tapmege keyet am sambe penaŋ ekŋenaŋ kegogak noline zawat sek sindemak ma we bekanaŋaŋ keŋinan tatatnaŋ indatimti kopme Pitayaŋ weyaŋindeme dolakŋaŋ bemâbien. ");
INSERT INTO naf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Mulup dolakŋaŋ kegok tapm mepme sâpe sâpe bumbu an sambe ekŋengat ŋeŋaŋin ma notnane Sadusi notnaŋ ekŋenaŋ ilinsakwep ombemindendeŋaŋ ekŋengat nâmbekambemindemti keyegak wati met indatamti mka katikŋan meindeme ");
INSERT INTO naf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","tatnepeme tambu sutnan Kawawaŋgalen enselaŋ toti set kwaletindemti zupman indatimtoweti zeye, “In meti sesewat mka temaŋ keŋan moti animbi mama mimi alakŋaŋ kapiyet zapatnaŋ ewe tusumti diindoseip.” ");
INSERT INTO naf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ombemindendeŋaŋ ekŋenaŋ zet ke nâmti toti met tambuŋan penaŋ sesewat mka temanen moti animbi zezapat diindomâbien. Âpme sâpe sâpe bumbu an sambe ekŋengat ŋeŋaŋin ma notnane ekŋenaŋ Zuda am ekŋengalen amobotnaŋ sambe ekŋenaŋ kopme ondektati ombemindendeŋaŋ zelen indendeyet nâmti zet beme mekopme an ŋeŋaŋ notnaŋ zemindeme mka katikŋaŋ meti ombemindendeŋaŋ ekŋen indatim kopme amobotnaŋ zimoselinan tati yaŋaŋin zenzeyet nâmti zemindeme mebien. ");
INSERT INTO naf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Am indatisât mebien ekŋenaŋ mka katikŋaŋgalen an damuŋ ekŋen ilinsakwep damuŋ mti tapme moindaikti mka katikŋaŋ set mâtâti keŋan moti ekme ombemindendeŋaŋ ekŋen ŋen ku tabiengapmti meti zewien, ");
INSERT INTO naf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nin met pataŋ zemti set damuŋ ekŋen bee nsakwep sekekek kaliŋaŋ tapme ekti set mâtâti moekmann ombemindendeŋaŋ ekŋenaŋ keŋan ku talo.” ");
INSERT INTO naf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Zet kegok zeme nâmti sâpe sâpe bumbu an sambe ekŋengat ŋeŋaŋin ma sesewat mka temaŋgalen antipdakutum ekŋengat ŋeŋaŋin ekŋenaŋ ombemindendeŋaŋ ekŋenaŋ kwawabien ke zeme nâmti nâmtemtem temaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tazem timatnepeme an ŋenaŋ pataŋ zemkwati zeye, “An in mka katikŋan met kek indeyo ekŋen piwan kwawaloyaŋ sesewat mka teman daen moti animbi Zet Zapat Dolakŋaŋ Penaŋ tadiindoip.” ");
INSERT INTO naf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Zeme nâmti sesewat mka temaŋgalen damuŋ mimi egat ŋeŋaŋinaŋ an notnaŋ ndatime sesewat mka temanen meti nin mot ekŋengat zet zenepemann amnaŋ nanzaŋaŋ ndoseipmagen zemti kiŋgapeŋ met ombemindendeŋaŋ ekŋen zesewak sewak mimindemti indatkobien. ");
INSERT INTO naf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Indatim koti amobotnaŋ ondedagen indat koindeme ekŋengat tuŋguwinan tapme sâpe sâpe bumbu an sambeyet ŋeŋaŋinaŋ pigok indayaŋkwesiye, ");
INSERT INTO naf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nin an kapiyet kwit zapatnaŋ am ekŋenmagen zempalakŋaŋ ku bembeyet zemkulumindewan. Âpme in Zelusalem mkaen am zapat ke ewe zempalakŋaŋ bemti an Zisas ke kuwien e nin kukuŋaŋnok manzemndoip.” ");
INSERT INTO naf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Zeme Pitamak ombemindendeŋaŋ notnaŋ ekŋenaŋ dopmaŋ pigok gilik zem zewien, “Nin amgalen zet gawepumti Kawawaŋgalen zet kulumann ŋep penaŋ ku bewe. ");
INSERT INTO naf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","In Zisas tewen kumti masasokpeme gakiye yaŋgut yeŋsokŋnemak ningalen Kawawaŋaŋ buteme wageyaŋ ewe alik mamain. ");
INSERT INTO naf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Âpme Kawawaŋaŋ mme wapme wapmoti ikŋaŋgat betnaŋ penaset Amobotnaŋ peme tati Islael am yomengatnan keŋŋ gilik zemann ndatitiyet mulup zet eyo saye. Keyepmti Islael amnaŋ Zisasmagen yom zemkawaŋ bemann egaŋ yomm katimndendeyet damuŋ matazin. ");
INSERT INTO naf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nin zet tazenuwen pi wa kwitnaŋ kwitnaŋ notnaŋ sokbemâpme eknâmâtâben ke manzemkawaŋ benup. In Kawawaŋgalen zet gawepumti mame Kawawaŋaŋ Emetakŋaŋ Teŋ ikŋaŋgat keŋ taoletnaŋgapmti tewalaŋ indaye egaŋ in zet sambe kapi zemkawaŋ bemindame kegogak ekmâtâbep.” ");
INSERT INTO naf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Zet kegok zeme an ŋeŋaŋ ekŋenaŋ nâmti keŋin bekanaŋ penaŋ beme ombemindendeŋaŋ ekŋen indome gakikiyet zenâ zenâ mbien. ");
INSERT INTO naf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amobotnaŋgalen ondedak keyet keŋan an ŋen Gamaliel ek an zii zet zikat indanda. An ke am sambeyaŋ nâmpeme mobotnaŋ penaŋ mambemtan. Egaŋ watati, “Ombemindendeŋaŋ ekŋen belaknik zemindeme zupman baen towewegat,” zeye. ");
INSERT INTO naf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Zeme ombemindendeŋaŋ ekŋen zemindeme towepme ilinak tati amobotnaŋ sambe ekŋengat zeye, “In an ekŋen kapi kwileki ŋen mimindasâgât nâseip beme weyaŋnâmâtâtati mseip. ");
INSERT INTO naf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Itnaŋaŋ tipman baen an ŋen kwitnaŋ Teudas egaŋ wati, ‘Neŋ amobotnaŋ,’ zem mme am 400 kegogaŋ ekmagen met wetekumti manepeme an ke kume amŋane ekŋenaŋ kalaŋ mekopme ondedak nin takwage ewan yek beye. ");
INSERT INTO naf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ya naman bam an ŋen Zuda zeme ke Galili mkaengatnaŋ egaŋ gapmanan am kwilin bemtiti mulup mge kan keyet am notnaŋ Zudayaŋ zet kelakŋaŋ mimindeme koti ek mâti meti amobotnaŋ notnaŋ mtoindesâgât mme ekŋenaŋ ek kegogak kume gakime maŋgeŋane ekŋen indomkume kalaŋ mekobien. ");
INSERT INTO naf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Keyepmti in am ekŋen kapi indondopiŋ belak indeme talit. An ŋenaŋ ŋeŋaŋ bemti tapm beween mulup tabep kapiyaŋ ŋep towembe. ");
INSERT INTO naf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Âk Kawawaŋaŋ ikŋaŋ ŋeŋaŋ beme tapmip beme in m aleme yek bewe. Mneti nin Kawawaŋgalen mulupgat kasa mbanupmagengat eksewanup!” ");
INSERT INTO naf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kegok zeme an ŋeŋaŋ notnaŋ tabien ekŋenaŋ nâme ŋep beme ombemindendeŋaŋ ekŋen ewe indazemtetime mopme sindiwaŋ indomti Zisasiyet kwizet buŋamaŋ ewe tusumti ku zenzeyelen zemkulumindemti zemindeme ");
INSERT INTO naf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","toti met Zisasiyet kwizet buŋamaŋgapmti katikŋaŋ bemtati sindem ma sakambuk time keyet Kawawaŋaŋ nâme ŋep beyeyepmti oloŋen mti ");
INSERT INTO naf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","kan kataŋ sesewat mka temanen ma am nâmkiŋpepemak ekŋengalen mka kataŋ ondekmeti Zisas Kilaisiyet kwizet buŋamaŋ ewe zempalakŋaŋ bemebien. ");
INSERT INTO naf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kan keyet am nâmkiŋpepemak maŋge temaŋ penaŋ sokbemti mambien keyepmti am Glik zet manzemtemien ekŋenaŋ zewien, “In am zet Ibulu manzeip in kan kataŋ meu ma milawat makalaŋkuip kataŋ ningalen kwambet notnaŋ dolakŋaŋ ku maweyaŋindeip.” Kegok zemti zetnaŋ belaknik bugan sokbeye. ");
INSERT INTO naf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Keyepmti ombemindendeŋaŋ 12 ekŋenaŋ nâmkiŋpepemak am ekŋen ondekindemti zewien, “Nin segalen bandimgat yayaŋ mti Kawawaŋgalen buŋam zapat zenze mulup pemann toweme ŋep ku bewe. ");
INSERT INTO naf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Keyepmti notnne, in ilinaŋgat tuŋguwinaŋgatnaŋ an nânâŋinmak ma an kwizet buŋamin dolakŋaŋ Emetak Teŋaŋ keŋinan bemisik matazin. Ekŋen keboŋ indik mâtâti an 7 indaikti kopme nin segalen bandim mulup maminup kapi ekŋengat belinan bemann ekŋenaŋ mbep. ");
INSERT INTO naf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Âpme nin dundundu ma Kawawaŋgalen zet zapat ammagen zemzikat indanda mulup etaŋ mbanup.” ");
INSERT INTO naf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Zet ke zeme nâmkiŋpepemak am ekŋenaŋ nâme ŋep beme an 7 kapigok indaikbien: Stiwen ek an nâmkiŋpepeŋaŋ kaliŋaŋ ma keŋanen Emetak Teŋaŋ bemisik matatan. Ek ma Pilip ma Polokolasimak Naikena ma Taimonmak Pamenas ma Nikolas an kapi Antiok msalengatnan egaŋ Zuda am ekŋenmak eweŋan kot tusumti am nâmkiŋpepemak bewien an ekŋen kegok indaikbien. ");
INSERT INTO naf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mti an ekŋen kapi ombemindendeŋaŋ ekŋenmagen indatimepme ekŋenaŋ belin ŋokŋinan bemti dundum indemti mulup ke belinan bemindewien. ");
INSERT INTO naf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kegok mme Kawawaŋgalen zelaŋ meti Zelusalem am m eleŋ beleŋ bemindeme Zisas nembaŋane ekŋenmagen tatusumepme sambe penaŋ beye ma sâpe sâpe bumbu an notnaŋ sambe ekŋenaŋ nâmkiŋpepe aikti ekŋenmagen metusumâbien. ");
INSERT INTO naf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiwen ek Kawawaŋmagengatnaŋ keŋ taolet ma windeyaŋ bemisik tapme am sambe tuŋguwinan menok kwitnaŋ kwitnaŋ sambe mge. ");
INSERT INTO naf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kegok mme Zuda am notnaŋ msalin yaŋaŋ pemti Silia ma Aleksandia ma Silisia ma Esia msalen met mamaŋaŋaŋ koti sesewat mka ŋen kwitnaŋ “Am Lala” ekŋengalen manzemtemien ke kot tusumti mamamtemien ekŋen keyaŋ yaŋbemti Stiwenmak zet mmot mtot mbien. ");
INSERT INTO naf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Âpme Kawawaŋgalen Emetak Teŋaŋ Stiwen nânâ dolakŋaŋ same zet tazemaŋge keyepmti an notnaŋaŋ egalen zetgat windeŋaŋ ŋep ku mtopepeyelen sepem tabemaŋge. ");
INSERT INTO naf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Keyepmti ekŋenaŋ am notnaŋ zet dâsuki notnaŋ bemzenzeyet zet kelakŋaŋ buzak set mimindeme ekŋenaŋ zet dâsuki pigok zewien, “Penaŋ, nin tatnâmann egaŋ Mosesimak Kawawaŋ egetgat zet mobotnaŋ tapmmaŋge.” ");
INSERT INTO naf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ekŋenaŋ kok zemti am notnaŋ ma sesewat mka temaŋgalen an damuŋ notnaŋ ma zii zet zikat indanda an notnaŋ ekŋengat keŋin walapme ekŋenaŋ zelin nâmti kot Stiwen wati ondedak temanen mebien. ");
INSERT INTO naf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ekŋenaŋ am notnaŋ Stiwengat bemzenze zet notnaŋ zenzeyet zemindeme ekŋenaŋ ondedagen meti sekŋaŋ bemzenze zet notnaŋ sambe Stiwengat ewe pigok zewien, “Kan sambe an kapiyaŋ sesewat mka kapiyet ma Mosesiyelen zii zet zemtalalat zet manzeme eknup. ");
INSERT INTO naf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nin tatnâmann egaŋ zet ŋen ewe pigok zeye, ‘Zisas Nasalet mkaengatnaŋ egaŋ sesewat mka temaŋ bekapi kumasek muti Mosesiyaŋ mama mimi notnaŋ zikat ndaye ke egaŋ mguluk gilik mme naman sepemaŋ ŋen bewe,’” kok zeye. ");
INSERT INTO naf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Âpme am notnaŋ amobotnaŋ ekŋenmak ondedak temanen tapmambien ekŋenaŋ Stiwen zimosetnaŋ ekme Kawawaŋgalen ensel ekŋengalen zimoselin keboŋ beme weyaŋeksememuŋ mtapmambien. ");
INSERT INTO naf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Âpme sâpe sâpe bumbu an ŋeŋaŋaŋ Stiwengat pigok yaŋkwesiye, “Amnaŋ gâgât zet sambe tazeip kapi penaŋ ma dâsuki ze zemane nâmbi?” ");
INSERT INTO naf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yaŋkwesime Stiwenaŋ pigok zeye, “Bipnotnne, neŋ pigok zema nâit. Yeŋsokŋ Abalaamaŋ ewe Alan mka msalen mebepiŋ Mesopotamia msalen mame busatnaŋ toŋaŋ Kawawaŋaŋ sokbemsamti pigok dunduye, ");
INSERT INTO naf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Neŋ msat ŋen zikat gama geŋ amdine ma msadi kapi katikpemti ke mepmambanik.’ ");
INSERT INTO naf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Zemti zempeme Abalaamaŋ nâmti keyet kataŋ Kalidia msat ke pemti met Alan mkaen matatan. Mka ke Silia msat keyet keŋan tazin. Ya ke met manepeme bipmaŋ e gakime naman Kawawaŋaŋ zempeme mka ke pemti msat ŋen kot tiye yaŋ msat timpeye keyegak nin matatnup. ");
INSERT INTO naf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wa msat ke egat penaŋ ku saye ma msat butnaŋ bugan ku ketalasim saye yek. Egaŋ nembaŋepiŋ maŋge yaŋgut Kawawaŋaŋ maneti msat ke ekmak nembaŋane indandayet zetik mimindeye. ");
INSERT INTO naf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mti Kawawaŋaŋ zet ŋen ewe kapigok dunduye, ‘Iŋsokdine ekŋenaŋ nup kan 400 pi msat tuŋgupman belak mamti amgat sisiliŋ mulup etaŋ mti ola olat palen ma sek sindem palen mambep.’ ");
INSERT INTO naf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mti Kawawaŋaŋ zet ŋen ewe pigok zeye, ‘Am maŋge kwiyaŋ sisiliŋ mulup an etaŋ indatimti mambep ekŋen ke neŋ dopmaŋ mutumindamti gilik zemindatima koti msat kapi mamti neŋ etaŋ sesewatnamti mambep.’ ");
INSERT INTO naf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kok zemti egaŋ Abalaamak tususu mge keyet piliŋaŋ Abalaamgat nemuŋaŋ ŋen sokbeme sekŋaŋ butnaŋ antitiyet zempeye keyepmti Abalaam manepeme nemuŋaŋ Aisak sokbemtapme kasup 8 beme Aisakgat sekŋaŋ butnaŋ antimpeye. Âpme Aisakgat nemuŋaŋ Zekop sokbeme Aisagaŋ Zekop sakam kegogak mpeye. Yanaman Zekopgat nembaŋane 12 sokbewien ekŋen bee Zekowaŋ sakam kegogak etaŋ mimindeye. ");
INSERT INTO naf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Âpme yeŋsokŋne an 12 keyaŋ meniŋin isikŋaŋ Zosep biwinaŋ gogot penaŋ mampemtan keyepmti ekpeŋpeŋ mpemti an ekŋenmagen beme mânep indamti Izip msalen wapmeti sisiliŋ an peme mamtan ");
INSERT INTO naf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","yaŋgut Kawawaŋaŋ ekmak tati nukŋaŋ sambe keyet keŋan mukulem mti nânâ dolakŋaŋ same mulupmaŋ dolakŋaŋ mme Izip am ekŋengalen amobotnaŋ Palaoyaŋ egomti nâmpeme ikŋaŋgalen kwitnaŋ kwitnaŋ damuŋ mti Izip amgalen amobotnaŋ eyo mamtan. ");
INSERT INTO naf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kan keyet meuyet kambeŋ temaŋ Izip msalen ma Kenan msalen sokbem weme yeŋsokŋne ekŋenaŋ meuyet penaŋ timabien. ");
INSERT INTO naf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kegok tapme Zekowaŋ nâme amnaŋ Izip msalen meu tapme takwitip kegok zeme nâmti nembaŋane zemindeme meu kwitisât Izip msalen mebien. Met kwitimti kot e nime delaŋ zeme ");
INSERT INTO naf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","naman sekŋan ewe mepme meniŋin Zosewaŋ yaŋaŋaŋ datnaneyet zemâtâtindame amobotnaŋ Palao egaŋ Zosepgat sipbutnane nâmâtâtindeye. ");
INSERT INTO naf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Âpme Zosewaŋ datnaneyaŋ met biwin Zekop aiikokogalen zeme ekŋenaŋ met biwin aikti amŋane notnaŋ indaaikti kobien ekŋen am 75 kogaŋ ");
INSERT INTO naf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","koti Izip msalen ke maneti Zekowaŋ gakiye. Âpme Zekopgat nemuŋane ningat yeŋsokŋne ekŋenaŋ ewe Izip msalen keyegak maneti kegogak gakimâbien. ");
INSERT INTO naf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gakime iŋsokŋine ekŋenaŋ indatim met Sikem msat Abalaamaŋ am sumgat nâmti Emo ekŋengalen msat butnaŋ ŋen kwitiye ke maindabemtemien. ");
INSERT INTO naf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Âpme Kawawaŋaŋ Abalaamgat zetik mpeye keyet kanaŋ daŋgome Islael am ekŋenaŋ Izip msalen omba penaŋ ");
INSERT INTO naf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","sambeleŋti mame Izip amobotnaŋ alakŋaŋ ŋen sokbeye keyaŋ Zosewaŋ mamti mulup dolakŋaŋ mkwage keyet yaŋaŋ ");
INSERT INTO naf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","kandati ningat yeŋsokŋne ekŋenmagen meluwaŋ mgasik penaŋ mti zeme mulup temaŋ penaŋ mamtemien. Âpme amobotnaŋ alakŋaŋ keyaŋ yeŋsokŋne ekŋenaŋ nemuŋine indatimti met zupman indeme gakikiyet zemkatik bemindeme nemba an timti met tuyen matimemetan. ");
INSERT INTO naf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kan keyet Moses nemba okak sokbeye ek sek sepemaŋ dolakŋaŋ penaŋ. Âpme mamaŋ bipmaŋaŋ eyoŋga tuk pi mkaŋinan ke buzak enzilimpeme tapme matatemien. ");
INSERT INTO naf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tapmetneti met suasembeen peme weme tuyen mebeme Palaoyet nambaŋaŋaŋ metneti aikti nemba ke mkot toŋaŋ bemti ekdamuŋ mme ");
INSERT INTO naf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","bugan sememe Izip am ilinaŋgalen mama mimiŋinaŋgalen nânâ ke ma zet zemusuwewet zenze ke zemzikat sam mme egaŋ zet zemâtâti mulupmaŋ dolakŋaŋ mkwage. ");
INSERT INTO naf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mosesiyaŋ ke manepeme nup kan 40 mee kok beme Islael am notnane bugan meindidigalen ");
INSERT INTO naf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","nâmti indiksât selen tapmetneti ekme Izip an ŋenaŋ Islael an ŋen takume ekti Mosesiyaŋ notnaŋ Islael ke mukulem mpemti Izip an bee kume gakiye. ");
INSERT INTO naf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mti Mosesiyaŋ Islael am maŋgeŋene kapiyaŋ kapigok nâip nâŋge. Kawawaŋaŋ nâgât pembenaŋ nnaŋgapmti gilik zemndatiwe. Nâip nâŋge yaŋgut ekŋenaŋ kegok ku nâmbien. ");
INSERT INTO naf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Naman mise ŋen ewe indiksâgât meti ekme Islael an zulaŋ ilidak taâmalu idikti idasubemti zeye, ‘In sip kwewaŋ kwilekiyet taâlup?’ ");
INSERT INTO naf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Zeme an aŋkuk ŋeŋaŋ yaŋbemti mge egaŋ notnaŋ takumaŋge e peme tapme Moses âtâpeme mepme ŋenzinziŋ msamti zeye, ‘Geŋ kwiyaŋ nin ndadamuŋ mti zemdelaŋ zenze mulup mimiyet zemgeye? ");
INSERT INTO naf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Geŋ saŋen Izip an ŋen kumane gakiyan ewan alak naman neŋ nâmane gakikiyet nâmti kot tazenik?’ ");
INSERT INTO naf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kegok zeme nâmti Mosesiyaŋ Izip amobotnaŋ egaŋ zapat kapi nâmti nowemagen zemti kiŋgati Midian ekŋengalen msalen kunzuŋmet ke mamti imbiŋaŋ msat keyetnaŋ wati mame nemuŋanet yumuŋ zut sokbewun. ");
INSERT INTO naf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Egaŋ Midian msalen ke meti nup kan 40 kegok mame delaŋ zeme kan tuŋgupmaŋ keyet Sainai Kalaŋ kandaŋan msat tuŋgupman am piŋan ke mame Kawawaŋgalen enselŋenaŋ tep ŋotekŋan tep tazime keyet keŋaset sokbemsaye. ");
INSERT INTO naf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosesiyaŋ tep ke tazime yaŋaŋ ekmâtâsâgât nâmti mululumti sokŋan tapmetnepeme Amobotnaŋaŋ Mosesiyet pigok dunduye, ");
INSERT INTO naf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Moses, neŋ yeŋsokdine Abalaam, Aisak ma Zekop ekŋengalen Kawawaŋ.’ Zeme Mosesiyaŋ zet ke nâmti kiŋgati sebelaŋ diŋdiŋ mti mot eegat nâmtemtem mti belak kusumti tage. ");
INSERT INTO naf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Âpme Amobotnaŋaŋ zeye, ‘Geŋ msat imti tadik ke kambuk penaŋ keyet setwewedi gulumm. ");
INSERT INTO naf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Neŋ Izip msalen aminne sisipeŋpeŋ mimindame sek sindem temaŋ palen tati si kembeŋ mname nâmti indamukulem msât kwatolap. Keyet geŋ wati Izip msalen meti indatim kot.’ ");
INSERT INTO naf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kawawaŋaŋ zet kegok zeme Mosesiyaŋ kiŋgaga e yaŋaŋ kapigogat. Egaŋ Izip msalen daen mame Islael am ekŋenaŋ ek kiŋgati zewien, ‘Geŋ kwiyaŋ ningalen amobotnaŋ ma damuŋ temaŋ geye?’ Zeme kunzuŋti koge an ke naman tep ŋotekŋan tep tazime Kawawaŋgalen enselaŋ tep keŋan sokbemsame ke ekti kusumtapme Kawawaŋaŋ Islael am ekŋengat amobotnaŋin onzempemti zempeme meti Islael am ŋeŋaŋ bemindemti indatim kokogat mege. ");
INSERT INTO naf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Izip msalen meti indatimkosât tati Izip msalen menok sepemaŋ igak igak mme amobotnaŋ Palaoyaŋ ekti kiŋgatindeme selen indatimeti nup kan 40 pi Nembu Ŋamanen ma msat tuŋgupman mee pi menok sepem igak igak mti indatimti koge. ");
INSERT INTO naf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Kopmambe Mosesiyaŋ Islael am pigok diindoye, ‘Bam Kawawaŋaŋ ningat tuŋgupmnaŋgatnaŋ notn ŋen mti onzempeme neŋ golaŋ zenze an mayapnok mambe.’ ");
INSERT INTO naf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Âpme Mosesiyaŋ indatimti met msat tuŋgupman ondekindeme tapme egaŋ ikŋak Sainai Kalaŋan mowepme ensel egaŋ zet zapat dunduye. Mme Mosesiyaŋ zet mamaŋaŋmak ke nâmtimtoti nin dindome nâmâtâbenn. ");
INSERT INTO naf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Yaŋgut yeŋsokŋne ekŋenaŋ Mosesiyelen zetgat wisat mti bamkumpemti nânâŋinaŋ gilik zemti naman Izip msalen mesâgâlak manâmtemien. ");
INSERT INTO naf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Âpme Mosesiyaŋ kalaŋan ke moti ewe ke mame Islael am ekŋenaŋ Elongat zewien, ‘Geŋ ningat kawawaŋ ŋen weyaŋnda. Mosesiyaŋ Izip msalengatnan ndatim kot msat tuŋgupman pi kilom ndemti deset melep e nin ku nânupgat geŋ ke mimndamane keyaŋ ŋeŋaŋ bemndame naman gilik zemti Izip mkaenak mebanup.’ ");
INSERT INTO naf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Zeme egaŋ makau nembaŋaŋ weŋaŋ ŋen ke betnaŋaŋ weyaŋpeme weme bepmeluwaŋin ke ekti oloŋen mti sâpe sâpe bum samti age silik temaŋ msawien. ");
INSERT INTO naf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mobotnaŋ kegok mme Kawawaŋaŋ indikti pigok nâmti bamkumindeye. Ekŋenaŋ kasup eyoŋga ma wenzimgat ŋep sesewatsasayelen nâmti kegok mge. Muluwaŋ keboŋ keyet golaŋ zenze an ekŋenaŋ Kawawaŋaŋ Islael am ekŋengat zet pigok zeye ke mtati Kawawaŋgalen Zet Itnaŋanen meluwaŋ kapigok mge, ‘Islael am, in msat tuŋgupman nup kan 40 mambien kan keyet in sipsip ma makau kumti sâpe sâpe ke nâgât buwien? ");
INSERT INTO naf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","In kawawaŋin nopiom Mâlok ek sesewatsamti egalen sesewat mka mzalaŋ walalatnaŋ ke luaŋzamti mamaip. Ma in kawawaŋin wenzim Lepan ke sesewatsamti egat weŋaŋ weyaŋpeme weme luaŋzamti mamaip. Keyepmti neŋ zemindema Babilon mka temaŋ ke sebempemti naman beŋan daen mebep.’ ");
INSERT INTO naf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Eweŋan yeŋsokŋne ekŋenaŋ msat tuŋgupman mamtemien ke ekŋenaŋ Kawawaŋ penaŋgalen sesewat mka mzalaŋ ke gapum mamti egat masesewatsamtemien. Mka mzalaŋ ke Kawawaŋaŋ ikŋaŋ Moses sokbemsamti mka mzalaŋ zigok walalagalen keyet weŋaŋ zikat samti zemâtâtsaye keyet kataŋ walabien. ");
INSERT INTO naf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bam yeŋsokŋne ekŋenaŋ biwine ekŋenmagen sesewat mka mzalaŋ ke mgapumti Zosuayaŋ ŋeŋaŋ bemindeme kasaen mepme Kawawaŋaŋ ikŋaŋ indamukulem mti kasaŋine indamâpme mepme msat kapi indaye. Âpme sesewat mka mzalaŋ ke matakwatnepeme Dewit amobotnaŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Âpme Zekopgalen Kawawaŋaŋ Dewit keŋ sewakŋaŋ mpeme nâmti Kawawaŋgat sesewat mka ŋen walalagat nâmti Kawawaŋgat yaŋkwesiye yaŋgut Kawawaŋaŋ ku nâmpeye. ");
INSERT INTO naf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Maneti bam Dewitgat nemuŋaŋ Solomonaŋ Kawawaŋgalen sesewat mka ke walage. ");
INSERT INTO naf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yaŋgut Amobotnaŋ Temaŋ Penaŋ kululuŋen main egaŋ sesewat mka amnaŋ walalatnaŋ keyet keŋan ku matazin. Kegogapmti Kawawaŋaŋ ikŋaŋ pigok zeme golaŋ zenze an Aizayayaŋ meluwaŋ pigok mge, ");
INSERT INTO naf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Amobotnaŋaŋ pigok zein, “Kululuŋ ke nâlen mundumm penaŋ ke tati msalen belak setnnaŋ etaŋ maimtalap. Keyepmti in nâlen mka pe sepemaŋ ziboŋ penaŋ walabep? Ma neŋ mundumm ziboŋanen penaŋ tot kâtnâm tabap? ");
INSERT INTO naf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Neŋ betnnaŋ kwitnaŋ kwitnaŋ ke ku mban ma?” ’ ");
INSERT INTO naf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","In an keŋin katikŋaŋ penaŋ Kawawaŋgalen zet wakŋinaŋ nânâ nâmtiŋgut keŋinan penaŋ ku mambeip. Mti itnaŋaŋ yeŋsokŋineyaŋ mamtemienok in Emetak Teŋaŋ inmagen mulup msâpmme in kan kataŋ belak maâtâpeme mezin. ");
INSERT INTO naf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","An Teŋ toŋaŋ sokbembeyelen zet golaŋ zenze an ekŋenaŋ manzemkwatemien ekŋenmagen ŋen aŋgalaŋ pewien? Sokŋine ekŋenaŋ an keboŋ sambe penaŋ indomwalet mkwabien. Yaŋ maneti an ikŋaŋ ke sokbeme am in kapiyaŋ kume gakiye. ");
INSERT INTO naf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","In Kawawaŋgalen zii zet ensel ekŋenaŋ indawien ke nânâ nâmtiŋgut makuluip nâip!” ");
INSERT INTO naf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiwenaŋ zet kegok diindome an ŋeŋaŋ ondedagen tabien ekŋenaŋ tiwin kwasime egat ŋenzinziŋ temaŋ penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mme Stiwen Emetak Teŋaŋ keŋanen bemisikme zikatnaŋ kululuŋen gwaen ekme mopme Kawawaŋgalen busatnaŋ keŋan Zisasiyaŋ Kawawaŋgat betnaŋ penaset tapme ");
INSERT INTO naf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ekti zeye, “Kululuŋen gwaen egit! Neŋ kululuŋ ŋandeme Kawawaŋgat Nemuŋaŋ am mamaen sokbeye egaŋ Kawawaŋgat betnaŋ penaset tapme egap!” ");
INSERT INTO naf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","60","Kegok zeme am sambe tabien ekŋenaŋ wakŋin bekekti zet oyak oyak temaŋ mti wati ekmagen windembemti met âtâpeme mebe kokot mti tetimti Zelusalem mka temaŋ solonan baen topemti an ŋeŋaŋ ekŋenaŋ kolowin sakŋaŋgatnaŋ gulumti an zomolim Sâl egat kandaŋan bempeme tapme ekŋenaŋ yaŋbemti nanzaŋ mâtâti kume an notnaŋaŋ indamukulem mti kume egaŋ kusumtati Amobotnaŋ Zisasiyet pigok dunduye, “Amobotnaŋ Zisas, geŋ nâlen emetakŋ mi!” Kegok zemti tot pedondom tati kwizet temaŋ penaŋ kumti zeye, “Geŋ an ekŋen tatnoip kapiyelen myuŋguŋguŋin katipe.” Kegok zemti wembekatnaŋ topme gakime Sâlaŋ ke tati ekti keyet nâme dolakŋaŋ penaŋ beye. Âpme sesewat mka temaŋgalen an damuŋ ekŋenaŋ gilik zem meti sâpe sâpe bumbu an ŋeŋaŋ temaŋ egat zapatnaŋ met zeme nâŋge. ");
INSERT INTO naf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Âpme an notnaŋ Zisasiyelen mama mimi mâti mamtemien ekŋenaŋ nâmtalat meti Stiwengat sekŋaŋ mti am sumen mmet bemti ambembesi temaŋ mbien. Kan keyet penaŋ yaŋbemti am nâmkiŋpepemak Zelusalem mkaen mamtemien ekŋen kasa kasa mimindame ekŋenaŋ kalaŋti Zudia ma Samalia msalen mekopme ombemindendeŋaŋ ekŋenaŋ etaŋ Zelusalem mkaen matatemien. ");
INSERT INTO naf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Âpme Sâl egaŋ setetekŋaŋ palakŋaŋ beme ŋeŋaŋ bemti animbi nâmkiŋpepemak indawaleti ekŋengalen mka kataŋ moti indatime kwawepme mka katikŋaŋ timet maindemtan. ");
INSERT INTO naf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kegok mti am nâmkiŋpepemak indamâpme ekŋenaŋ msat sambe lala bubuk mekoti Zet Zapat Dolakŋaŋ Penaŋ msat sambe zemkawaŋ bemâbien. ");
INSERT INTO naf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Âpme Piliwan Samalia am ekŋengalen mka ŋande temaŋ ŋengat pataŋ zemti am Kilaisiyelen Zet Zapat Dolakŋaŋ Penaŋ zemkawaŋ bemindame ");
INSERT INTO naf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","am sambe ekŋenaŋ zetnaŋ nâmti tikŋaŋgat mbien. Ma kwitnaŋ kwitnaŋ mamanamaŋ mti ");
INSERT INTO naf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","am we bekanaŋinmak sambe tabien ekŋen we bekanaŋin indapmâpme am keŋangatnan kwati ŋakŋak mti kunzuŋbien ma am sambe notnaŋ selin belin wesiŋ mee pi mme dolakŋaŋ bemâbien. ");
INSERT INTO naf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Keyepmti mka keyelen am ekŋenaŋ Pilipgat oloŋen mti Kawawaŋgat kwizet buŋamaŋ mwabien. ");
INSERT INTO naf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Âpme mka temaŋ keyet keŋan an ŋen mamtan kwitnaŋ Saimon egaŋ ke mamti aŋkambuk mulup nup kan sambe penaŋ mamtan. Mti egaŋ ikŋaŋgat sekŋaŋ mmoti, “Neŋ amobotnaŋ mayap,” zeme animbi sambeyaŋ egat nâmpeme mobotnaŋ mambemtan. ");
INSERT INTO naf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Egaŋ kegok mme amobotnaŋ ma tototnaŋ ekŋenaŋ Saimongat zetnaŋ nâme mobotnaŋ beme zewien. “An kapiyaŋ Kawawaŋmagen Winde Temaŋ manzeip ke timti mamin.” ");
INSERT INTO naf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Âpme egaŋ aŋkambuk mulup nup kan sambe penaŋ mti mamkwage keyepmti am ekŋenaŋ egat nâme mobotnaŋ penaŋ mambemtan. ");
INSERT INTO naf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kegok mti manepeme Piliwaŋ met pataŋ zemti animbi sambe Kawawaŋgalen zemâtâtât katnanen mama keyet yaŋaŋ ma Zisas Kilaisiyet yaŋaŋ zemkawaŋ bemindame nâmti nâmkiŋpepe aikme tu zulutindeye. ");
INSERT INTO naf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Âpme Saimon egaŋ kegogak zet nâmkatik bemti nâmkiŋpepe aikme tu zulutpeme Pilipgat kandaŋan mame Piliwaŋ kwitnaŋ kwitnaŋ mamanamaŋ mme ekti nâmtemtem mamtan. ");
INSERT INTO naf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Âpme Samalia am ekŋenaŋ Kawawaŋgalen zet zapat nâmti mkatik bewien keyet zapatnaŋ Zelusalem mka teman ombemindendeŋaŋ ekŋenmagen mepme nâmti ekŋenaŋ Pitamak Zân zemideme ");
INSERT INTO naf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Samalia msalen mepataŋ zemti am nâmkiŋpepemak ekŋenaŋ Emetak Teŋmak bembeyet nâmti Amobotnaŋgat dundum sawun. ");
INSERT INTO naf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tipman baenen ekŋenmagen Emetak Teŋaŋ ku toge belak Amobotnaŋ Zisasiyet nâmkiŋpeme egat kwitnanen tu etaŋ zulutindewien. ");
INSERT INTO naf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Keyepmti ombemindendeŋaŋ zut egelaŋ belit ŋokŋinan bemti dundumalu Emetak Teŋaŋ tot keŋinanen bemisikme ");
INSERT INTO naf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon an keyaŋ tati ekme ombemindendeŋaŋ zut keyaŋ amgat belit ŋokŋinan bemti dundumalu amnaŋ Emetak Teŋmak tabeme indikti egaŋ winde ke kwitisât met mânepmaŋ timti egetmagen koti zeye, ");
INSERT INTO naf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“It winde tapmilup ke neŋ namalu neŋ kegogak am notnaŋ betnnan ŋokŋinan bema Emetak Teŋmak bewep.” ");
INSERT INTO naf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Zeme Pitayaŋ pigok gilik zemsaye, “Geŋ nâmane Kawawaŋgalen taolet takozin kapi mânewaŋ ŋep kwititiyelen bein? Keyepmti geŋ mânepdi tipeŋ teziŋ ŋande towebanik! ");
INSERT INTO naf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Geŋ ŋoktik bekanaŋ kegok nânik keyaŋ nitmak tusumti mulup kaboŋ kapi ŋep ku mimiyelen. Kawawaŋaŋ ŋoktikdi kegok tazin ke ekti nâme bekanaŋ bein. ");
INSERT INTO naf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Keyepmti geŋ otnânândi bekanaŋ taotnânik ke pemane tapme keŋdi gilik zemti Amobotnaŋ Kawawaŋgat dundum samane egaŋ nânândi bekanaŋ keyelen yom katipewe. ");
INSERT INTO naf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Geŋ mama mimi bekanaŋ keboŋ keboŋ keyaŋ keŋdanen gak zemti tazin keyepmti nit mulup dolakŋaŋ kapi tapmmalu geŋ ndikti eyak penaŋ tapmmane gigup.” ");
INSERT INTO naf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Zemalu Saimonaŋ egegat zeye, “Ililagak nâgât mti Amobotnaŋgat dundumalu egaŋ napmukulem mneme kwitnaŋ kwitnaŋ zelup keyaŋ neŋmagen ku sokbemâbe.” ");
INSERT INTO naf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Egelaŋ Kawawaŋaŋ egetmagen mulup zigok mge keyet zapatnaŋ ma Amobotnaŋgalen Zet Zapat Dolakŋaŋ Penaŋ Samalia am zemkawaŋ bemindamalu delaŋ zeme Zelusalem mka teman mesât mepmambe sele selen mka isisikŋaŋ notnaŋ indaikmeti am Zet Zapat Dolakŋaŋ Penaŋ diindom diindom piyaŋ mebun. ");
INSERT INTO naf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Âpme Kawawaŋgalen ensel egaŋ Pilipmagen koti zeye, “Geŋ wati toti Zelusalem mkaengatnan Gaza mkaen mesât mamelip set keeset mâti mesenik.” ");
INSERT INTO naf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Zeme nâmti Piliwaŋ set ke metneti selen an ŋen Itiopia msalengatnaŋ aige. An ke Itiopia imbi mobotnaŋ Kandasi egalen mânep ekdamuŋ mamtan. Egaŋ Zelusalem mka teman Kawawaŋgat sesewat mulup met mti ");
INSERT INTO naf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","gilik zemti mkaŋan mesât kalisiŋan mototati mepmambe ");
INSERT INTO naf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","golaŋ zenze an Aizayayelen meluwaŋ ke tapmaiŋ mepme Emetak Teŋaŋ Pilip zempemti zeye, “Geŋ kalis tapmezin kainde met aikti an kemak melit.” ");
INSERT INTO naf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","33","Zeme Piliwaŋ winde bemti met sokŋan ke meti nâme an keyaŋ golaŋ zenze an Aizayayaŋ papia pigok kuye ke tapmaiŋ maŋge, “Ekŋenaŋ sipsipnok kume gakikiyet wati kolip. Ekŋenaŋ sipsip zupmaŋ eleŋgesâti wati kopme kwitnaŋ ku makuin sepem kegogak an ke wati kopme egaŋ yeye ŋen ku mge. Ekŋenaŋ omba penaŋ mtopemti zetnaŋ esemteŋ zemdelaŋ zenzepiŋ belak kume gakiye keyepmti nin egat iŋsokŋane ŋen ku mamame indiknup.” Âpme Piliwaŋ zet ke nâmti yaŋkwesime, “Zet ke maiŋti zigogak penaŋ nâmti zenzeŋaŋ keyet yaŋaŋ bugan tatnânik?” Yaŋkwesime an keyaŋ pigok zeye, “An ŋenaŋ zet kapiyet yaŋaŋ ku zemâtâtname neŋ nenak etaŋ zigoset yaŋaŋ nâmâtâbak? Keyet kwati neŋmak kapi totati zet kapiyet yaŋaŋ weyaŋ zemâtâtnamane nâmbi.” ");
INSERT INTO naf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Zemtetime motapme amobotnaŋ keyaŋ Pilip pigok yaŋkwesiye, “Geŋ zemane nâmbi an papia kuye kapi ikŋaŋgat nâmti kuye ma anŋengat nâmti kuye?” ");
INSERT INTO naf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yaŋkwesime Piliwaŋ golaŋ zenze an keyelen zet ke mtati Zisasiyelen Zet Zapat Dolakŋaŋ Penaŋ kemak pepep bemti zemkawaŋ bemsame ");
INSERT INTO naf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","mepmambe amobotnaŋ keyaŋ zeye, “Tu pi tazingat geŋ neŋ tu zulutneneyet nâmane ŋep beme zulutnesenik?” ");
INSERT INTO naf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Zeme Piliwaŋ zeye, “Geŋ Zisas Kilais ilak penaŋ nâmkiŋpenik beme zenik kegok ŋep mimiyelen.” Zeme an keyaŋ zeye, “Zisas Kilais ek Kawawaŋgat Nemuŋaŋ penaŋ e ŋep nâmkiŋpeyap.” ");
INSERT INTO naf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Zemti mulup anaŋ zeme kalis atam tapme Pilipmak amobotnaŋaŋ tuyen toweti Piliwaŋ tu zulutpemti ");
INSERT INTO naf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ilisakwep kaiŋan kwati keyegak Amobotnaŋgalen Emetak Teŋaŋ Pilip wati mepme amobotnaŋ keyaŋ Pilip ŋen ku ege. Mti egaŋ setnaŋ mesâgât nâmti kogeen ke mâti keŋ oloŋen palen mege. ");
INSERT INTO naf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Âpme Pilip wapmeti Azotus mka msalen met peme egaŋ mka temaŋ notnaŋ ke tokwapmeti am Zet Zapat Dolakŋaŋ Penaŋ diindom diindom meti Sisalia mka msalen met pataŋ zeye. ");
INSERT INTO naf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Âpme Sâlaŋ am Amobotnaŋ Zisas mâti mamamtemien ekŋen indikti timti indapmâtindome gakikiyelen mulupmaŋ temaŋ penaŋ mamimtan keyepmti egaŋ sâpe sâpe bumbu an ŋeŋaŋ temaŋ ekmagen meti ");
INSERT INTO naf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","zemâtâtât papia ŋen same mti Damaskas mkaen Zuda ilinaŋgalen sesewat mka isisikŋaŋ kataŋ meti animbi Amobotnaŋ Zisasiyelen set alakŋaŋ mâti maip ekŋen indatimatimti kokogat yaŋkwesime sâpe sâpe bumbu aniyaŋ zemâtâtât zet kapigok kumsaye. An ma imbi ekŋenaŋ Amobotnaŋ Zisasiyelen mama mimi alakŋaŋ kapi mâti maip beme egaŋ ŋep indatimti belin zamtimti Zelusalem mkaen indatim kobe. ");
INSERT INTO naf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kegok kumsame mti Damaskas mka sokŋanik mepme kululuŋengatnaŋ busatnaŋ temaŋ penaŋaŋ toti egat palen mbusatnaŋ bemti tage. ");
INSERT INTO naf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kegok mme egaŋ msat palen tot kutum wemti tati nâme zet ŋen kapigok sokbeye, “Sâl, Sâl, geŋ kwilekiyet neŋ napmât giŋgiŋ penaŋ mti nawalesât mulupmaŋ temaŋ tapmnik?” ");
INSERT INTO naf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Zeme Sâliyaŋ pale kaim wepeŋ tati yaŋkwesiye, “Amobotnaŋ, geŋ kwi?” Zeme Amobotnaŋaŋ zeye, “Neŋ Zisas, geŋ napmât giŋgiŋ mti nawalesât maminik kapimak. ");
INSERT INTO naf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Keyet geŋ wati mka temaŋ daen mepmaneŋgut bam an ŋenaŋ mulupdi zigok mbanik ke zemâtâtgame nâmbanik.” ");
INSERT INTO naf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Âpme Sâlmak am notnaŋ mebien ekŋenaŋ muluwaŋ ke ekti weŋin mepme zetpiŋ belaŋ diliŋ zem tati nâme zet ke sokbeye yaŋgut ekŋenaŋ am penaŋ ke ku ekbien. ");
INSERT INTO naf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Âpme Sâlaŋ wati zikat eksâgât olapme am notnane ekŋenaŋ betnamti Damaskas mkaen mebien. ");
INSERT INTO naf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ke mepeme kasup tuk pi zikatnaŋ beŋaŋ piyaŋ tu meu mee ninipiŋ; belak mawemtan. ");
INSERT INTO naf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Âpme Zisas nâmkiŋpepeŋaŋ an ŋen kwitnaŋ Ananias zeme ke egaŋ Damaskas mkaen ke matatan. An keyet Amobotnaŋaŋ kie kienok sokbemsamti Ananiasiyet pigok kuye, “Ananias!” Zeme Ananiasiyaŋ zeye, “Amobotnaŋ, neŋ pine talap.” ");
INSERT INTO naf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Zeme Amobotnaŋaŋ pigok dunduye, “Geŋ wati Set Teŋ manzeip keeset meti Zudayelen mkaen moti an ŋen Tasas mkaengatnaŋaŋ dundundu mulup tapmgat moti aiksenik. An keyet kwitnaŋ Sâl. ");
INSERT INTO naf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Egaŋ tati geŋ kie kienok gikme geŋ ekmagen meti bedaŋ ŋokŋanen bemane zikatnaŋ ewe dolakŋaŋ beme ekmâtâlep.” ");
INSERT INTO naf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Amobotnaŋaŋ kegok dundume nâmti Ananiasiyaŋ ke nâme nukŋaŋ beme zeye, “Amobotnaŋ, am sambe ekŋenaŋ an keyet yaŋaŋ pigok manzeme nâyap. Egaŋ Zelusalem mkaen amdine geŋ gapmâtmaip ekŋen ke egaŋ sambe penaŋ maindawalezin. ");
INSERT INTO naf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","An ke sâpe sâpe bumbu an ŋeŋaŋaŋ nâmpemti papia same mti Damaskas mka temaŋ pien animbindine geŋ sesewatgamti mandundumganup. Nin setn betn zamti mka katikŋaŋ ndatimti mesât kozan.” ");
INSERT INTO naf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Zeme Amobotnaŋaŋ zeye, “Geŋ ŋepgat met an ke nen mulup an aikman. Egaŋ nâgât kwizet buŋamm mti am Zuda maŋgeen ku sokbembeŋaŋ ma amobotnaŋine ma Islael am ekŋenmagen meti zemkawaŋ bemnewe keyet geŋ met ekti zikatnan weyaŋpe. ");
INSERT INTO naf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Âpme nenn egaŋ kwizet buŋamm mmamti sek sindem tiwe keyet set zikat sama ekbe.” ");
INSERT INTO naf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Zeme Ananiasiyaŋ mka zemâtâtpeye ke esemteŋ met aikti mka keŋan moti betnaŋaŋ Sâl ŋokŋanen bemti zeye, “Sâl notn bekan, Amobotnaŋ Zisasiyaŋ selen baen sokbemgame ekdak. Egaŋ neŋ kot zikadi mma ewe eegalen zemneme kolap. Egaŋ geŋ zikadi ekti Emetak Teŋmak bembeyet tazein.” ");
INSERT INTO naf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Zeme keyegak zikatnaŋ keŋangatnan aŋgala galaŋaŋ pâpmaŋ nemboŋ piyaŋ doloŋ zem topme zikatnaŋ weyaŋ ekti wati zeme Zisasiyet kwitnanen tu zulutpemti ");
INSERT INTO naf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","bam tu meu same nimti windeŋaŋ timti ");
INSERT INTO naf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","keyegak Zuda am ilinaŋgalen sesewat mka sambe meti Zisasiyet yaŋaŋ zempalakŋaŋ bemti pigok zeye, “Zisas ek Kawawaŋgat Nemuŋaŋ penaŋ.” ");
INSERT INTO naf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kegok zeme nâmti amnaŋ nâmtemtem mti zewien, “An kapiyaŋ Zelusalem mkaen daen an kwitn kapi kumti sesewatsame egaŋ indom walet mammnaŋ naman pien koti kegogak animbi kwit keyegak kumti masesewatsaip. Ekŋen kapi belin zamtimti sâpe sâpe bumbu an ŋeŋaŋ ekŋenmagen indatimti mesât koge e wa an ikŋaŋ kapi manzeegit?” ");
INSERT INTO naf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Yaŋgut Sâlaŋ Zet Zapat Dolakŋaŋ Penaŋ ke windeŋaŋbeŋ zemti amgat Zisas ek Kilais keyet yaŋaŋ weyaŋ diindomti zemâtâpme am Zuda Damaskas mkaen matatemien ekŋenaŋ zet ŋen dundunduyet olati ŋeŋin penaŋ zime ");
INSERT INTO naf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ekŋenaŋ ilinak ondedak mti Sâl kume gakikiyet zemtâwien. ");
INSERT INTO naf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Zuda am ekŋenaŋ kegok zemti tambuyet ma msayet mka temaŋ keyet set biman baen damuŋ mtati Sâl topme kusenup zemti tapme egaŋ zapalin ke nâŋge. ");
INSERT INTO naf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kegok mme Sâlgat notnane Zisas nâmkiŋpepeŋaŋ ekŋenaŋ tambusutnan buzak Sâl suasembeen weti kimbat enzuŋaset tegen timtati peme âlâlâlâŋ zupman baen toweti mege. ");
INSERT INTO naf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sâl egat yaŋaŋaŋ manâmtemien keyepmti egaŋ Zelusalem mkaen gilik zem meti am Zisas nâmkiŋpepeŋaŋ ekŋenmak ondeksât mme ekŋenaŋ egat nâme Zisasiyet kasa mamm wan an kapi nâmbien keyepmti ek kiŋgatpeme ");
INSERT INTO naf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Banabasiyaŋ Sâl tetimti ombemindendeŋaŋ ekŋenmagen meti Amobotnaŋaŋ Sâl Damaskas selen sokbemsamti zet dunduye ma Sâlaŋ Damaskas mkaen moti Zisasiyet yaŋaŋ windeŋaŋbeŋ penaŋ zemâtâge keyet yaŋaŋ zemkawaŋ bemindame ekŋenaŋ nâmâtât peme ");
INSERT INTO naf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ekŋenmak ke tati egaŋ Zelusalem am nâmkiŋpepemak ekŋengalen ondedakŋinan kan kataŋ meti Amobotnaŋgat kwizet buŋamaŋ windeŋaŋbeŋ manzempalakŋaŋ bemtan. ");
INSERT INTO naf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mti Zuda am Glik zet manzemtemien ekŋenmak Sâlmak zet zapat dolakŋaŋgat zet mmot mtot mti Zuda Glik zet manzemtemien ekŋengat ŋeŋin zime set ŋen aikti Sâl kume gakikiyet nâmbien. ");
INSERT INTO naf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Âpme am notnane notnaŋ Zisas nâmkiŋpepeŋaŋ ekŋenaŋ zapat ke nâmti Sâl wati Sesalia mka teman topeme Tasas mkaen mege. ");
INSERT INTO naf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Âpme Zudia ma Galili ma Samalia msalen am Zisas nâmkiŋpepeŋaŋ maŋge mambien ekŋenmagen sisipeŋpeŋaŋ ku sokbeye keyepmti ekŋengat tuŋguwinan sewakŋaŋaŋ weme Emetak Teŋaŋ indapmukulem mimindeme nâmkiŋpepeen gweŋ gweŋ kumti Amobotnaŋgat kandaŋaŋegak mambien. Âpme Am notnaŋ Emetak Teŋaŋ keŋin m eleŋ beleŋ beme ekŋenaŋ kot am nâmkiŋpepemak ekŋenmagen tusume indama kume omba penaŋ beye. ");
INSERT INTO naf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitayaŋ msat kataŋ Zet Zapat Dolakŋaŋ Penaŋ mandiindom metneti Zisas nâmkiŋpepeŋaŋ Lida mka msalen mamtemien ekŋenmak kegogak met mamti Zet Zapat Dolakŋaŋ Penaŋ diindoye. ");
INSERT INTO naf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Egaŋ mka keyetnaŋ an ŋen kwitnaŋ Inias ek setnaŋ wesiŋ bembeŋaŋaŋ nup kan 8 pi egaŋ set mee bugan mebepiŋ belak mkaen milam mawemtan. ");
INSERT INTO naf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Yaŋ Pitayaŋ an ke meekti pigok dunduye, “Inias Zisas Kilaisiyaŋ mme dolakŋaŋ benik keyet geŋ wati sindi weyaŋ kutumbe.” Zeme egaŋ keyegak pututuk zemwati sinaŋ bekan kutum bemti mebe kokot mge. ");
INSERT INTO naf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pitayaŋ muwaŋ kegok mme Lida am ma Selon am ekŋenaŋ an wesiŋ wati mepme ekti Amobotnaŋ Zisasiyet nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Âpme naman Zopa mka msalen imbi ŋen nâmkiŋpepeŋaŋmak mamtan kwitnaŋ Tabita kwitnaŋ ŋen Glik zeleset Dokas makumtemien. Egaŋ kan kataŋ am sambe bee keŋ taolet mimindamti am bekopsat notnaŋ ola olat palen mamtemien ekŋen indapmukulem mti maweyaŋindemtan. ");
INSERT INTO naf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Âpme Pitayaŋ ewe Lida mka msalen keyegak mame kan keyegak imbi keyaŋ zawat temaŋ mti gakime tuyaŋ sekŋaŋ zulutpemti met mka keŋan sakŋan gwaen mopeme weŋge. ");
INSERT INTO naf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Âpme Zopa mka ke Lida mka keyet sokŋanit matatan. Keyepmti Zopa am nâmkiŋpepemak ekŋenaŋ Pita Lida mkaen kotazin zeme nâmti ekŋenaŋ Zopa an zut zemideme meti Pitayet zewun, “Lida am ekŋenaŋ nit geŋ gaikti sakwep mebegat zemndeme gaikmesâgât kolup.” ");
INSERT INTO naf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Zemalu Pitayaŋ milawatnaŋ bekan mutuweti egetmak Zopa mkaen mebien. Met pataŋ zeme keyegak wati Dokas mka keŋaŋ ŋen tedukŋan gwaen peme weme tapmambien ke wati mopme imbi kwambet sambe ekŋenaŋ Pita bembuluŋtati Dokasiyaŋ alik mamti kâlâwin teepmaŋ ma kwitnaŋ kwitnaŋ notnaŋ sambe selim indamâge ke zikat samti si kundundu tapmmambien. ");
INSERT INTO naf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mme Pitayaŋ am ekŋen ke zemindeme zupman towepmâpme igak tot pedondom tati Kawawaŋgat dunduye. Dundum delaŋ zemti zimosetnaŋ imbi gakikiŋaŋ tage keeset ekti zeye, “Tabita wat!” Zeme imbi gakikiŋaŋaŋ belak zemti Pita waekme ");
INSERT INTO naf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pitayaŋ met betname am nâmkiŋpepemak ma imbi kwambet ekŋen indakumtetime kwapmâpme Dokas mme alik beye ke zikat indame ekti oloŋen temaŋ penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Âpme keyet zapatnaŋaŋ Zopa animbi sambe bee nâme delaŋ zeme am sambe penaŋaŋ Amobotnaŋgat nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mme Pitayaŋ an ŋen Saimon soŋgom sekŋaŋaŋ kwitnaŋ kwitnaŋ notnaŋ maweyaŋtan an keyelen mkaen kan teepmanik mawemtan. ");
INSERT INTO naf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisalia msalen Loma an ŋen mamtan kwitnaŋ Konelias. Ek kasa kuku an 100 ekŋengalen an damuŋin. Ekŋen keyet amnaŋ “Itali ekŋengalen kasa kuku an” manzemtemien. ");
INSERT INTO naf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Koneliasiyaŋ Kawawaŋgat nâme mobotnaŋ beme ek mâti mamtan. Keyepmti egalen mkaen animbi mamtemien ekŋenaŋ ilinsakwep Kawawaŋgat masesewatsamtemien. Âpme Konelias egaŋ ikŋaŋ Kawawaŋgat mene mene penaŋ mandundum samtan. Mti Zuda animbi bekopsat notnaŋ indapmukulem omba penaŋ mamimtan. ");
INSERT INTO naf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Koneliasiyaŋ kegok mamimkwatnepeme kan ŋeniyet Kawawaŋgalen ensel ŋenaŋ gasiyet 3 kilok keyet kie kienok sokbemsamti egat kwitnanen kumti zeye, “Konelias!” ");
INSERT INTO naf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Zeme Koneliasiyaŋ ensel ekti weŋaŋ mepme eksememuŋ mtage tageyaŋ yek beme yaŋkwesiye, “Amobotnaŋ, zigok ze zemane nâmbi?” Zeme Amobotnaŋaŋ zeye, “Taolet mimindi ma dundundundi Kawawaŋmagen ilak mopme nâp. ");
INSERT INTO naf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Keyet geŋ an ŋen zempemane Zopa mkaen meti an ŋen kwitnaŋ Saimon ma ikŋaŋ keyegak kwitnaŋ ŋen Pita manzeip ke wati koti kapi koseip. ");
INSERT INTO naf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","An ke opmaŋ Saimon soŋgom sekŋaŋaŋ milawat weyeyaŋ egalen mkaen tazin. An keyelen mka nembu ganzenan penaŋ baen matazin.” ");
INSERT INTO naf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kawawaŋgalen ensel egaŋ kegok zemti galaŋ zemepme Koneliasiyaŋ mulup anenet zut ma kasa kuku an ŋen mkaŋaŋ ekdamuŋ mmamti egaŋ Koneliasmak ilizuzut Kawawaŋgat nâme mobotnaŋ beme mamamtemun. ");
INSERT INTO naf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","An ekŋen ke zeme kopme zet weyaŋ zemâtâtindame nâmti Pita wasâgât Zopa mkaen mebien. ");
INSERT INTO naf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ekŋenaŋ selen ke tapmetne peme tambume tambuyet eyo tusumti tapmetne metnepeme msat msame met Zopa mkaen pataŋ zewien. Âpme Pitayaŋ kan keyegak tambuŋan dundundu mulup msâgât mka dukŋan gwaen mowege. ");
INSERT INTO naf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Opmaŋgat imbiŋaŋaŋ meu ewe tabume Pitayaŋ mowege keyepmti egaŋ meuŋaŋgat wiselepmaŋ alaŋaŋ beme kan keyet kie kienok kwileki ŋen pigok sokbemsame ege. ");
INSERT INTO naf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kululuŋ gwaen ŋandeme saŋgum temaŋ wakŋaŋ zulak zulak piyaŋ kululuŋ keŋangatnan peme Pitamagen âlâlâlâŋ piyaŋ toge. ");
INSERT INTO naf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Saŋgum keyet keŋan zit sepem igak igak ma nombe sepem igak igak ma age sepem igak igak piyaŋ misik tapme toge. ");
INSERT INTO naf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Âpme zet ŋen kapigok sokbeye, “Ele Pita, geŋ wati ekŋen kapi kumaŋti ni.” ");
INSERT INTO naf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Zeme Pitayaŋ zeye, “Amobotnaŋ, neŋ kwitnaŋ kwitnaŋ kaboŋ kapi niniyet zemkulumneneŋaŋ keyepmti ŋep ku kumaŋti nsap.” ");
INSERT INTO naf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Zeme zet ewe pigok sokbeye, “Kawawaŋaŋ mme dolakŋaŋ bein ke geŋ keyet mgasik zenzepiŋ.” ");
INSERT INTO naf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Muluwaŋ kegok sokbemsame sek tuk beme ekme beewan naman gilik zemti melesiŋ kululuŋenagak mowege. ");
INSERT INTO naf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Âpme Pitayaŋ muluwaŋ kie kienok ege keyet yaŋaŋ nânâyet nânâ mulup temaŋ tapmme kan keyegak Koneliasiyaŋ am zemindeme kobien. Ekŋenaŋ Saimon Pitayet timati amgat mezeme mka zemâtâtindame nâmti met egalen mkaen setokwakwalen tati ");
INSERT INTO naf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","zewien, “Saimon Pita mka kapi tazin ma yek?” ");
INSERT INTO naf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Âpme Pitayaŋ ewe muluwaŋ keyet yaŋaŋ nâsâgât nânâ mulup temaŋ tapmmepme Emetak Teŋaŋ pigok dunduye, “Pita nânik, an tugaŋ baen gâgât kot tatimalip. ");
INSERT INTO naf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Keyet geŋ totindaikti taŋga taŋgandi kutum weti ekŋenmak mebegat nâmane nukŋaŋ beme nâmtemtem ku msenik. An ekŋen ke nenn zemindema gaiksâgât kolo.” ");
INSERT INTO naf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Âpme Pitayaŋ gwaengatnan toti sekekek mâtâti ekŋenmagen zupman toweti zeye, “An in kapiyaŋ nâgât tatnatimapmo? In kwilekiyet kolo ze zeme nâmbi?” ");
INSERT INTO naf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Zeme pigok dunduwien, “Kasa kuku an ŋeŋaŋ Konelias ek Kawawaŋ sesewatsamti mama teŋ mame Zuda am ekŋenaŋ egat nâme dolakŋaŋ mambein. Ek Kawawaŋgalen ensel teŋ egaŋ geŋ gati egalen mkaen mepmann geŋ zapat dundumane nânâyelen dundume nâmti zemndeme geŋ gaiksâgât kotnup.” ");
INSERT INTO naf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kegok zeme nâmti Pitayaŋ an ekŋen ke mkaen indatim moti timbum muluŋti indatime wembienaŋ msame wati mesât mme Zopa am nâmkiŋpepeŋaŋ notnaŋ ekŋenaŋ Pitamak an tuk kobien ekŋenmak ilinsakwep mebien. ");
INSERT INTO naf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ekŋenaŋ Sisalia msalen mesât tapmetnepeme msat tambume tambuyet eyo metnepeme msame msayet meti Sisalia mkaen pataŋ zewien. Âpme Koneliasiyaŋ am sipbutnane kwep ma am notnane notnaŋ zeme kopme eweŋanak ondekti ekŋengat posi tapmambien. ");
INSERT INTO naf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Keyepmti Pitayaŋ set kwaleti mka keŋan mopme Koneliasiyaŋ kandaŋan sokŋanik met pedondom samti zemsesewatpeye. ");
INSERT INTO naf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Âpme Pitayaŋ pigok dunduye, “Konelias wat! Neŋ kegogak geŋ nemboŋ mkaengatnaŋ amnegak.” ");
INSERT INTO naf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pitayaŋ ekmak zet zenâmambe ilisakwep mka keŋan motneti am sambe tapme indikti ");
INSERT INTO naf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pitayaŋ ekŋengat pigok diindoye, “In Zuda am nin am notnaŋ belakŋaŋ ekŋenmak metati zapat zenâ zenâ mimi ma ekŋenmagen metatat keyet zemkatik bembeŋaŋ tazin ke ilin nâip. Yaŋgut neŋ Kawawaŋaŋ kie kienok sokbemnamti an ŋeniyet bekanaŋ ŋep ku zenzeyelen dinomti zemneme inmagen kapi kola. ");
INSERT INTO naf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Keyepmti in nâgât zet beme mege ke nâmti inmagen kokogalen nâmtemtem ku mban. Keyepmti in yaŋaŋ eneyet nazemtetiyo ze zeme nâmbi?” ");
INSERT INTO naf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Zeme Koneliasiyaŋ dunduye, “Neŋ muluwaŋ ŋen pigok sokbemname ekti manepema kasup ilak tuk mezin keyet zema nâmbak. Ne gasiŋeniyet 3 kilok mee kok beme dundundu mulup tapmma an ŋen melakanduŋaŋ satnaŋ penaŋ puyuk peyak piyaŋ sokbemnamti ");
INSERT INTO naf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","pigok dinoyan, ‘Konelias, Kawawaŋaŋ dundundundi ma taolet mimindi ke ekti gâgât nâmgeme dolakŋaŋ penaŋ bein. ");
INSERT INTO naf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Keyepm geŋ Zopa mkaen am zemindemane an ŋen kwitnaŋ Saimon Pita ke tetim koseip. An ke opmaŋ Saimon soŋgom sekŋaŋaŋ milawat weyeyaŋ egalen mka nembu ganzenan ke mawein kegok zemâtâtnap.’ ");
INSERT INTO naf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Keyepm neŋ an tuk kapi zemindema geŋmagen kopmien. Âpme geŋ zetn gawepumti kodak keyepm neŋ gâgât nâma dolakŋaŋ bein. Kawawaŋgat zimosetnaŋ ondekti tatnupgat geŋ Amobotnaŋaŋ zet zigok zemkawaŋ bem game timti kodak ze zemâtâtndamane nâsenup.” ");
INSERT INTO naf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Zeme Pitayaŋ yaŋbemti pigok zeye, “Kawawaŋ egaŋ am segeset nâmndeme mobototot ku mambein ke nâmkiŋpeyap. ");
INSERT INTO naf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yaŋgut msat sambe am kwi ekŋenaŋ Kawawaŋgat kandaŋan meti mama mimi teŋ penaŋ mti mamaip. Am ekŋen keyet Kawawaŋaŋ tikŋaŋ manâmindein. ");
INSERT INTO naf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Am sambe nin kapiyelen Amobotnaŋ Temaŋ Zisas Kilais ek nâmkiŋpemti Kawawaŋmak mama sewakŋaŋ mmamayet Kawawaŋaŋ ikŋaŋ keyet zetnaŋ Islael am ninmagen zemkawaŋ bemndaye e in nâmtalip. ");
INSERT INTO naf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Zânaŋ am tu zuluti Kawawaŋmak tusumti mama keyet yaŋaŋ diindom kwage. Keyet sekŋan gwaen Zisasiyaŋ Galili msalen yaŋbemti kwitnaŋ kwitnaŋ nukŋaŋbeŋ mpeme keyetnan Zudia msat sambe bee eyo palakŋaŋ bemekoge. ");
INSERT INTO naf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Âpme Zisas Nasalet mkaengatnaŋ ek Kawawaŋaŋ winde ma Emetak Teŋ same egaŋ Zuda mka kataŋ mekoti am keŋ taolet mimindaye ma Sadaŋaŋ am mme wesiŋ bembeŋaŋ ma am notnaŋ keŋin mme yuŋgume mamtemien eboŋ eboŋ e Sadaŋ mâpme mepme mme dolakŋaŋ bewien. Kawawaŋaŋ ekmak tati mukulem kegok mme mulup temaŋ temaŋ sepem kegok mkwage. ");
INSERT INTO naf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Âpme Zuda am ningalen msalen ma Zelusalem mka temanen kwitnaŋ kwitnaŋ mge ma zet zemkwatnapeme Zuda am ekŋenaŋ ŋenzinziŋ mti tep palen kumasasok peme gakiye ke nin ekmâtâbenn. ");
INSERT INTO naf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Âpme sekŋaŋ sumen met beme sumen ke kasup tuk wenepeme bamgat Kawawaŋaŋ mme gilik zemti wati sokbemndam galaŋ mkwage. ");
INSERT INTO naf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wa ke am belakŋaŋ ekŋenmagen penaŋ ŋen ku sokbeye. Egaŋ gakikiengatnan gilik zem wati am zapatnaŋ dolakŋaŋ zenze am Kawawaŋaŋ eweŋan ndaige nin etaŋ sokbemndame nin ekmak meu nimti zenâ zenâ kwep mbenn. ");
INSERT INTO naf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Âpme Kawawaŋaŋ ek mmoti am gakikiŋaŋ ma alik mamanup ningalen zemdelaŋ zenze an onzempeye. Egaŋ mosâti nin ikŋaŋgat zet zapatnaŋ ke nin am msat kataŋ zemkawaŋ bemindandayet mulup zet ndamti moge. ");
INSERT INTO naf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Âpme am ŋenaŋ egat nâmkiŋpewe beme Kawawaŋaŋ egat pembenaŋgat mti yomin zulutindewe. Ewaŋan golaŋ zenze an ekŋenaŋ zet kegok zemkwabien.” ");
INSERT INTO naf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitayaŋ zet kegok diindomambe tapme Emetak Teŋaŋ toti am nâmti tapmambien ekŋengat keŋinan gak zemti tage. ");
INSERT INTO naf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Âpme Zuda am nâmkiŋpepemak notnaŋ Zopa mkaengatnan Pitamak mebien ekŋenaŋ ekme Kawawaŋaŋ am Zuda maŋgeen ku sokbembeŋaŋ ekŋenmagen eyo Emetak Teŋ indame ");
INSERT INTO naf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ekŋenaŋ zet ŋande igak igak zemti Kawawaŋgat kwitnaŋ mwat zemsesewatpeme ekŋenaŋ indikti nâmtemtem temaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Âpme Pitayaŋ zeye, “Nin ilak Emetak Teŋ timti Zisas Kilaisiyet kwitnanen tu zulubenn keyepmti am ekŋen kapi kegogak Emetak Teŋ ilak tiyo. Âpme nin naman kwilekiyet Zisas Kilaisiyet kwitnanen tu zululugat aŋgalaŋ indesenup?” ");
INSERT INTO naf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kegok zemti Konelias ikŋaŋ ma amŋane ekŋen bee Zisas Kilaisiyet kwitnanen tu zulutindeme Pita aŋgalaŋme kasup mulup mimi notnaŋ pi ekŋenmak ke ewe tati Zet Zapat Dolakŋaŋ Penaŋ diindomkwage. ");
INSERT INTO naf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ombemindendeŋaŋ notnane notnaŋ ma am nâmkiŋpepeŋinmak Zudia msalen mambien ekŋenaŋ am Zuda maŋgeen ku sokbembeŋaŋ eyo Kawawaŋgalen Zet Zapat Dolakŋaŋ nâmti mkitik zewien keyet zapatnaŋ mme nâmbien. ");
INSERT INTO naf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Keyepmti Zuda am nâmkiŋpepemak Zelusalem mkaen mamti am sekŋin butnaŋ antitiyet zet windeŋaŋ mamimtemien ekŋenaŋ Pitayaŋ am ekŋen ke sekŋin butnaŋ antitipiŋ belak indemti gilik zemkopme ekti nâme ŋep ku beyeyepmti Pita mtopemti pigok zewien, ");
INSERT INTO naf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Geŋ kwilekiyet am Zuda maŋgeen ku sokbembeŋaŋ sekŋin butnaŋ ku antitiŋaŋ ekŋengalen mkaen met mamane ekŋenaŋ tu meu kileŋ game mti manimtemanan.” ");
INSERT INTO naf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kegok zeme Pitayaŋ kwitnaŋ kwitnaŋ sambe am ekŋen kaindemagen sokbemindaye keyet yaŋanen baengatnan yaŋbemti pigok zemâtâti zemkawaŋ bemindaye. ");
INSERT INTO naf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Neŋ Zopa mkaen dundundu mulup tapmma kie kienok Amobotnaŋaŋ muluwaŋ kapigok zikat name ekban. Kuleki ŋen saŋgum temaŋ keboŋ busiliŋaŋ zulak zulak piyaŋ kululuŋen gwaengatnan âlâlâlâŋ neŋmagen totapme ");
INSERT INTO naf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ne keŋan baenen weyaŋ ekbanen keyet keŋan soŋgom didikŋaŋgatnaŋ sepem igak igak ma nombe sepem igak igak ma age sepem igak igak piyaŋ keŋan beke misik tapme ekban. ");
INSERT INTO naf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Âpme neŋmagen zet ŋen kapigok sokbeme nâmban, ‘Pita, geŋ wati kwitnaŋ kwitnaŋ keŋan tazin ke tim aŋti ni!’ ");
INSERT INTO naf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Âpme neŋ zet ke nâmti zewan, ‘Amobotnaŋ, neŋ kwitnaŋ kwitnaŋ zemkulumneneŋaŋ ma bekanaŋ keboŋ ku maniap, yek penaŋ.’ ");
INSERT INTO naf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kegok zema kululuŋengatnaŋ zet ŋen ewe kapigok sokbeme nâmban, ‘Kawawaŋaŋ kwitnaŋ kwitnaŋ mme dolakŋaŋ bein ke geŋ ku zemtalat.’ ");
INSERT INTO naf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Zet kegok sek tuk zeme nâma naman kwitnaŋ kwitnaŋ beewan gilik zemti sembe melesiŋ kululuŋen mowepme ");
INSERT INTO naf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","keyegak an ŋen Sisaliayetnaŋaŋ an tuk kapi zemindeme neŋ naiksâgât mka neŋ matatemanen ke kot tapme ");
INSERT INTO naf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Emetak Teŋaŋ nâgât pigok dinoye, ‘Geŋ toti am kot talip ekŋen kemak mebegat nâmtemtem ku msenik.’ Kegok zeme neŋ toindikti ekŋenmak mesât mma am nâmkiŋpepemak an 6 ekŋenaŋ napmât meti nsakwep kasa kuku an ŋeŋaŋ Konelias egalen mkaen mowepmann ");
INSERT INTO naf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","egaŋ zapat kapigok dinndoye, ‘Nâlen mkaen Kawawaŋgalen ensel ŋenaŋ kwati pigok dinop. Geŋ am zemindemane Zopa mkaen meti an ŋen kwitnaŋ Saimon Pita ek wati kopme ");
INSERT INTO naf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","egaŋ zet zeme nâmti geŋ ma maŋgendine in nâmkiŋpepe aikme Kawawaŋaŋ in yomengatnan gilik zemindatiwe.’ ");
INSERT INTO naf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Âpme neŋ Zet Zapat Dolakŋaŋ Penaŋ diindomambe tapma eweŋan Emetak Teŋ ninmagen toge sepem kegogak ekŋenmagen topme ");
INSERT INTO naf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","neŋ kwitnaŋ kwitnaŋ ke ekti Amobotnaŋaŋ zet pigok zeye ke otnâmban, ‘Zânaŋ animbi tu etaŋ zulutindeye âpme neŋ Emetak Teŋaŋ keŋinan bemisikindewap.’ ");
INSERT INTO naf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Keyepmti nin Amobotnaŋ Zisas Kilais nâmkiŋpemti zet zapatnaŋ dolakŋaŋ zemkawaŋ bemindamann egaŋ nin Emetak Teŋ ketalasim ndaye sepem kegogak egaŋ Emetakŋaŋ Teŋ ketalasim indame neŋ bukaboŋaŋ zigok Kawawaŋgat zemkulumpewak.” ");
INSERT INTO naf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kegok diindome ekŋenaŋ zet ke nâme penaŋ beme Kawawaŋgat zemsesewatpemti pigok zewien, “Kawawaŋaŋ am Zuda maŋgeen ku sokbembeŋaŋ ekŋen kegogak yomengatnan keŋ gilik zenze aikti mama kanzizit keyet toŋaŋ bembeyet eyo tatnâmindein.” ");
INSERT INTO naf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiwen kuwien kan keyet am nâmkiŋpepemak Zelusalem mkaen mambien ekŋenaŋ ke ekti sekŋin zime msat kataŋ kalaŋti kileŋ mekobien. Notnaŋaŋ beŋaŋ Pinisia msalen mepmâbien ma notnaŋaŋ Saiplas msalen mepmâbien ma notnaŋaŋ Antiok mka teman mebien. Kegok mekoti Kawawaŋgalen Zet Zapat Dolakŋaŋ Zuda am eweŋan meti msat ke mamaŋaŋ ekŋenmak ilinak etaŋ zenâ zenâ mti mamamtemien. ");
INSERT INTO naf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Yaŋgut am nâmkiŋpepemak notnaŋ Saiplas msalen ma notnaŋ Sailini mka teman Zuda am nâmkiŋpepemak mambien notnaŋ ekŋenaŋ Antiok mka teman meti am Zuda maŋgeen ku sokbembeŋaŋ ekŋen kegogak Zisasiyelen Zet Zapat Dolakŋaŋ Penaŋ diindome ");
INSERT INTO naf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Amobotnaŋgalen windeyaŋ ekŋenmagen sokbemindame am sambe penaŋaŋ nâmkiŋpepe aikti Amobotnaŋmagen tusumâbien. ");
INSERT INTO naf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Keyet zet zapatnaŋ Zelusalem mka teman met pataŋ zeme nâmti Banabas zempeme egaŋ Antiok mka teman meti ");
INSERT INTO naf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","indikme Kawawaŋgalen keŋ taoletnaŋ ekŋenmak tapme indikti nâme dolakŋaŋ beme keŋinaŋ Amobotnaŋmagen ewe kaliŋaŋ bemtatagat nâmti animbi sambe zemgwatnaŋ mimindeye. ");
INSERT INTO naf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas ek an dolakŋaŋ nâmkiŋpepeŋaŋ temaŋ ma Emetak Teŋaŋ egat keŋan bemisik matatan. Keyepmti Zet Zapat Dolakŋaŋ Penaŋ zeme am sambe penaŋaŋ nâmti nâmkiŋpepe aikti Amobotnaŋmagen ewe tusumâbien. ");
INSERT INTO naf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Âpme Banabasiyaŋ Talasas mkaen Sâl eksâgât meti ");
INSERT INTO naf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","meaikme ilisakwep gilik zemti Antiok mkaen koti Antiok mkaen animbi nâmkiŋpepeŋaŋ sambe ekŋengat tuŋguwinan ke nup kan kwep mamti am Zet Zapat Dolakŋaŋ Penaŋ diindom zikat indam mammtemun. Âpme kan keyet am Kilais nâmkiŋpepeŋaŋ ekŋenaŋ yaŋbemti kwilin Kilaisiyelen am maŋge ke kuwien. ");
INSERT INTO naf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kan keyet golaŋ zenze an notnaŋ ekŋenaŋ Zelusalem mka temaŋ katikpemti Antiok mkaen kobien. ");
INSERT INTO naf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Âpme golaŋ zenze an kobien ekŋengat tuŋguwinaŋgatnaŋ an ŋen kwitnaŋ Agabas. Ek Emetak Teŋaŋ zet keŋanen bempeme egaŋ ondedak temaŋ ŋeniyet motati msat sambe kambeŋ temaŋ sokbewe keyet zet zapatnaŋ diindoye. Yaŋ maneti Loma amobotnaŋ Kolodiasiyaŋ maŋge kan keyet zetnaŋ zeye keyet penaŋaŋ sokbeye. ");
INSERT INTO naf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Keyepmti am nâmkiŋpepemak ekŋenaŋ Zudia am nâmkiŋpepemak noline indamukulem mimiyet zenâmti ");
INSERT INTO naf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","am kwep kwewaŋ mânewin taindaye kataŋ sepem minok ondek bemti Banabasimak Sâl zemideme egelaŋ mânep ke timti Zudia msalen am nâmkiŋpepemak ekŋengalen an ŋeŋaŋine mambien ekŋenmagen mmebun. ");
INSERT INTO naf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Âpme Elolaŋ yaŋbemti am notnaŋ nâmkiŋpepemak indom walet mti notnaŋ belak mka katikŋan timet indeye. ");
INSERT INTO naf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Elolaŋ zeme kasa kuku an ekŋenaŋ Zems Zângat datnaŋ ek wanam kukŋaŋbeŋaŋ omeseleme gakiye. ");
INSERT INTO naf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Egaŋ muluwaŋ mgasik kegok mme Zuda am ekŋenaŋ set keyet nâme dolakŋaŋ beme indikti keŋin wapme Pita kegogak Aŋgalalaŋ Kendoyet atamti mka katikŋan mepeye. ");
INSERT INTO naf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pigok nâmti mepemti kasa kuku an 16 kapi indeme damuŋ mammtatemien. Ke tapme nin Aŋgalalaŋ Kendo kapi tapmann delaŋ zeme naman keyegak tusumti Nupmamaŋ Yispiŋ Manimtemien Kendo ke yaŋbemtati keyet kuma gakiwe zemti wati mepeye. ");
INSERT INTO naf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Âpme am nâmkiŋpepemak ekŋenaŋ Kawawaŋaŋ Pita mka katikŋanen mukulem mpepeyet dundundu mulup mene mene mkwabien. ");
INSERT INTO naf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Elolaŋ Pita wati zelen onzempepeyelen kanaŋ saŋen nokŋan tapme tambu keyet kasa kuku an zulaŋ nembet nembet tati damuŋ katikŋaŋ mmalu egetgat tuŋguwidan sen katikŋaŋ zulaŋ zampepeŋaŋ beye melesiŋ tawemaŋge. Âpme kasa kuku an notnaŋ ekŋenaŋ setokwakwalen baen damuŋ katikŋaŋ mti tapmambien. ");
INSERT INTO naf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Âpme keyegak Amobotnaŋgalen ensel ŋenaŋ mka keŋan ke belak sokbemtapme busatnaŋaŋaŋ mka keŋaŋ bee mbusatnaŋ bemti tage. Âpme Kawawaŋgalen ensel keyaŋ Pita butemti zeye, “Pita, sakwep wati dendaŋ tat!” Zeme Pitayaŋ dendaŋ pututuk wapme setnaŋ betnaŋ sen katikŋaŋaŋ zampepeŋaŋ ewan belak puluk pilik pemti topmâge. ");
INSERT INTO naf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kegok mme Kawawaŋgalen enselaŋ Pitayet zeye, “Pita, geŋ bitimdi weyaŋ zamti set wewedi weti melakanduŋdi teepmaŋ mti pemane topme napmât kot.” ");
INSERT INTO naf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","11","Zeme Pitayaŋ zeye kegok mti Amobotnaŋgalen ensel ke mâti ilisakwep kasa kuku an notnaŋ ekŋenaŋ setokwakwat ŋeŋaŋ gwaen damuŋ mti tapmambienen ke topmalu set ikŋaŋ dâlâŋ zeme toti met namaŋ sekekek ŋen towepmalu e kegogak ikŋaŋ belak dâlâŋ zeme toti eyetnan met kimbatgalen sekek aen temaŋ ke mepmalu belak ikŋaŋ etaŋ ŋandeme zupman baen toti mka temanen mebun. Amobotnaŋgalen enselaŋ Pita wati kwitnaŋ kwitnaŋ mmege ke Pitayaŋ nâme kapi penaŋ tapmiap ma belak kie kien tapmiap mene kegok otnâŋge. Selen metneti Amobotnaŋgalen ensel egaŋ galaŋ zemti mepme Pitayaŋ keyegak keŋaŋ teŋ peme nâmti pigok nâŋge, “Penaŋ sukwep pi neŋ nâmâtâlap. Amobotnaŋaŋ ensel ŋen zempeme toti egaŋ Elotgalen belengatnan ma Zuda am ekŋenaŋ neŋmagen kwitnaŋ kwitnaŋ mnasâgât mimien keyetnan naŋgalaŋti natozin.” ");
INSERT INTO naf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Egaŋ kegok otnâmti keŋaŋ yayaŋ kwapme met Zângat mamaŋ Malia egalen mkaen memoge. Am nâmkiŋpepemak sambe ekŋenaŋ egalen mkaen ke ondek tati Pitayet nâmti dundundu mulup tapmmambien. ");
INSERT INTO naf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Âpme Pitayaŋ moti setokwakwat zupmaset baen kwat set toŋtoŋ takume mulup imbi nemba kwitnaŋ Loda egaŋ am pe kwiyaŋ set toŋtoŋ kwatakuin zemti eksâgât koti ");
INSERT INTO naf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pitayet zet ŋandaŋaŋ nâmti segeyak mti set kwalelepiŋ belak mka keŋan gwaen meti am notnaŋ tabiengat pigok diindoye, “Pitawan kolewaŋ kamba tazin.” ");
INSERT INTO naf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Zeme ekŋenaŋ zewien, “Keŋdi kileŋ beme tazenik! Pita pi mka katikŋan daen tazin.” Zeme egaŋ zekaŋkaŋ mti zeye, “Penaŋ sukwep ek kamba kotazin.” Zeme ekŋenaŋ zewien, “Bati ke ensel ŋenaŋ mene kotapme ekti kotazenigat.” ");
INSERT INTO naf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Âpme Pitayaŋ ewe set toŋtoŋ giŋgiŋ kupeŋ tapme ekŋenaŋ meti set kwaleti ekti weŋin mepme zezebaŋbaŋ omba mbien. ");
INSERT INTO naf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Âpme Pitayaŋ ekŋenaŋ zet temaŋ temaŋ ku zenzeyelen nâmti belak belaŋ sesepmaŋ mti zemkulumindeye. Mti egaŋ Amobotnaŋaŋ mka katikŋaŋgatnan gilik zemti aŋgalaŋ peye keyet zet zapat mimindamti zeye, “In meti Zems (Zisasiyet meniŋaŋ) ekmak am notnane notnaŋgat zet zapat kapi met miindaseip.” Kegok zemindemti toti naman msat butnaset ŋen mege. ");
INSERT INTO naf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Âpme tambuŋan penaŋ kasa kuku an ekŋenaŋ wati Pitayet ekme yek beme weŋin mepme zewien, “Ege! Pita pi zigoset melep?” Zemti tokwatimabienaŋ yek beme zet beme ");
INSERT INTO naf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elotmagen mepme egaŋ nâmti kasa kuku an notnaŋ ewe zemindeme Pita aiikgalen tokwat timabienaŋ yek beme kasa kuku an 16 Pita damuŋ mti tabien ekŋen met indatimti zet muluwen met indeme zet zesât olabiengapmti Elotgat mezeme egaŋ zemdelaŋ zemindeme Pitayet munduman ekŋen ke indome gakiwien. Elolaŋ Zudia msat pemti Sisalia mka msalen topmaneti gilik zem kokogat nâmti towege. ");
INSERT INTO naf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Kan keyet Elolaŋ Taia ma Saidon animbi ekŋengat ŋenzinziŋ temaŋ mimindeye. Keyepmti animbi sambe mka keyetnaŋ ekŋenaŋ temakwep bemkoti meluwaŋ damuŋaŋ Balastas ekmagen mot zet zemti ŋenzinziŋ kapi yek bembeyelen nâmti egaŋ indatimti amobotnaŋ Elotmagen mepme zelin weyayaŋgat nâmti zet kelakŋaŋ mpewien. E yaŋaŋ kapigogat ekŋenaŋ Amobotnaŋgalen msalen ke meti meu makwitimtemien keyepmneti egaŋ setnaŋ bekekme olati meuyet gakiwanupmagen zemti yayaŋ mti muluwaŋ kegok mbien. ");
INSERT INTO naf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","22","Âpme Elolaŋ yaŋkwesisiŋin keyet dopmaŋ gilik zemindandayet nâmti kan bemindaye ke daŋgome amobotnaŋgalen miak miak sopmaŋ ke mti amobotnaŋgalen mundumen mototati zet tadiindome am sambe ekŋenaŋ kaliaŋ temaŋ kumti zewien, “Zet kapi dolakŋaŋ penaŋ Kawawaŋaŋ manzein keyet kataŋ penaŋ tazein.” ");
INSERT INTO naf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kegok zemsesewatpeme Elolaŋ ikŋaŋgat nâme mopme Kawawaŋgat nâme tototnaŋ beye keyepmti kan keyegak Amobotnaŋgalen ensel egaŋ nâmbekam bempeme binaŋ keŋanen imkume gakiye. ");
INSERT INTO naf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kegok mme Kawawaŋgalen zelaŋ windeŋaŋbeŋ palakŋaŋ bemti msat kataŋ mekoge. ");
INSERT INTO naf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Âpme Banabasimak Sâl egelaŋ Zelusalem mka temanen mulup zemidendeŋaŋ ke mmalu delaŋ zeme egelaŋ Antiok mkaen mesât mti Zân Mak ek wati ilinsakwep mebien. ");
INSERT INTO naf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok dapmelaŋge keyet keŋan golaŋ zenze an ma an zikat indanda kapigogaŋ mambien: Balabas ma Simion an sopmaŋ makumtemien ma Lusias Sailini mkaengatnaŋ ma Manaen ekmak amobotnaŋ Elotmak egelaŋ ilisakwep zenzelim mamti same mbun ma Sâl am ekŋen kogaŋ ke mamti mulup mamtemien. ");
INSERT INTO naf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ekŋen keyaŋ meu zemkulumpemti Kawawaŋmagen keŋin ondek bemti sesewatpemti tapmambien. Âpme Emetak Teŋaŋ ekŋengat zeye, “In Banabasimak Sâlmak ideme egelaŋ neŋ mulup mimiyelen nâmti zewan ke met mbalup.” ");
INSERT INTO naf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ekŋenaŋ meu zemkulumpemti dundundu muluwen an zut eget ke Kawawaŋaŋ mulup keyet ombem idep nânâyet tati eksokbemti belinan ŋokŋidan atamti mulup ke mimiyet zemgwatnaŋ mimidamti ideme mebun. ");
INSERT INTO naf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Emetak Teŋaŋ zemideme egelaŋ meti Selusia mkaen toweti waŋga ŋen mti msat nembu tuŋgupman tageen kwitnaŋ Saiplas ke meti ");
INSERT INTO naf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","egelaŋ mka ŋotakŋan Salamis ke mot pataŋ zemti Zuda am ekŋengalen sesewat mka tapmege kataŋ meti Kawawaŋgalen Zet Zapat Dolakŋaŋ zemkawaŋ bewun. Zânaŋ eget idamukulem mti ilinsakwep mulup mbien. ");
INSERT INTO naf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ekŋenaŋ msat ke meti Zisasiyelen Zet Zapat Dolakŋaŋ zempemalu mane mane nembet daen mka ŋen Papos ke pataŋ zemti mka keyetnaŋ Zuda aŋkambuk ŋen aikbun. Kwitnaŋ Bal Zisas an keyaŋ ikŋaŋgat, “Neŋ golaŋ zenze an” kogok manzemtan. ");
INSERT INTO naf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","An keyaŋ msat keyelen gapman ŋeŋaŋ kwitnaŋ Selegias Pâlas an kemak notn notn mmamtemun an ke nânâŋaŋ temaŋ penaŋ. Amobotnaŋ temaŋ keyaŋ Banabasimak Pâlaŋ Kawawaŋgalen Zet Zapat Dolakŋaŋ dundumalu nânâyet nâmti idazemtetime kobun. ");
INSERT INTO naf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yaŋgut aŋkambuk Bal Zisas kwitnaŋ ŋen Glik zeleset Elimas makumtemien an keyaŋ amobotnaŋ temaŋ egaŋ Sâlmak Banabas egelaŋ Kawawaŋgalen Zet Zapat Dolakŋaŋ ke zemalu nâme penaŋ ku bembeyelen timyape yape zet notnaŋ dunduye. ");
INSERT INTO naf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yaŋgut Sâl kwitnaŋ ŋen Pâl manzemtemien an ke Emetak Teŋgalen windeyaŋ keŋanen misik tapme Elimas zikat memuŋ ektati zeye, ");
INSERT INTO naf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Sadaŋgat nemuŋaŋ, geŋ mama teŋ keyet kasa mpemti am tetimaemae omba mimindamti Kawawaŋgalen zet pi imkwatamane belakŋaŋ penaŋ mambein. Geŋ mama mimi bekanaŋ ke geŋmagen omba penaŋ gak zem tazin nânik! ");
INSERT INTO naf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Keyepmti alak Amobotnaŋ Kawawaŋaŋ betnaŋaŋ zikadi enzuŋgeme beŋan besem. Âpme geŋ kasup ŋen eekpiŋ mane pemane kan sambe mebe.” Pâlaŋ zet kegok zeme keyegak sakwep zanza keboŋaŋ tot Elimasiyet zikatnaŋ bekekme tambusosok beme Elimas zikatnaŋ eksât olage. Mti, “An ŋen aikma napbetnamti set zikat name mebi,” zemti olati bemanzat mege. ");
INSERT INTO naf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Muluwaŋ kegok sokbeme gapman an ŋeŋaŋ keyaŋ Amobotnaŋ Zisasiyelen windeŋaŋ temaŋ ke ekti nâmtemtem temaŋ mti Zisasiyelen zet keyet nâme penaŋ beme Zisasiyet nâmkiŋpeye. ");
INSERT INTO naf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pâlmak am notnaŋ ekmak mebien ekŋenaŋ Papos mka ke peme tapme waŋga ŋen mti Pampilia msalen Pelga mka temanen ke mebien. Âpme Zânaŋ ekŋen katikindemti igak Zelusalem mkaen gilik zemti koge. ");
INSERT INTO naf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Âpme ekŋenaŋ Pelga mka ke peme tapme naman Pisidia msalen meti Antiok mkaen ke mulup mti manepeme Sabat tagoŋgo kan ke beme Zuda am ekŋengalen sesewat mkaen motati ekme ");
INSERT INTO naf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ekŋenaŋ Mosesiyelen zii zet ma golaŋ zenze an ekŋenaŋ zet kuwien ke maiŋ mepme delaŋ zeme sesewat mka keyet ŋeŋaŋ ekŋenaŋ Pâl ma amŋane mototabien ekŋengat pigok indayaŋkwesiye, “Notnne, in animbi kapi zemgwatnaŋ mimindendeyelen zet ŋen mti talip beme kwatati diindome nâit.” ");
INSERT INTO naf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Zeme Pâlaŋ wati belaŋ sesepmaŋ mti zeye, “Islael am ma am notnne Zuda maŋgeen ku sokbembeŋaŋ in Kawawaŋgat masesewatsaip, in wakŋin weyaŋ bemti tapme zet kapi zema nâit. ");
INSERT INTO naf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Islael am ningalen Kawawaŋ egaŋ yeŋsokŋne ekŋen ikŋaŋgat zapat penaŋ indaombemindeye. Yaŋ ekŋenaŋ Izip msalen lueŋ mamti omba penaŋ sokbem sambeleŋti mame Kawawaŋaŋ Kenan msalen indatimti kosât tati egaŋ Izip amobotnaŋ Palaomagen menok sepem igak igak mme ekti kiŋgatnâmindeme Izip msat pemti mebien. ");
INSERT INTO naf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Selen msat tuŋgupman indatim kopme ekŋenaŋ mobotnaŋ msamkobienaŋgut egaŋ sewakŋan mti indadamuŋ mamimkotnepeme nup kan 40 bepi set tuŋgupman ke delaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kan keyet Kenan msalen am maŋge 7 bepi Kawawaŋaŋ indaasekti ekŋengalen msat ke yeŋsokŋne ekŋengat indame ekŋenaŋ msat ke toŋaŋ bemti mame ");
INSERT INTO naf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","nup kan 450 kegok delaŋ zeme keyet baman gwaen Kawawaŋaŋ zemdelaŋ zenze an notnaŋ indaaikme ekŋenaŋ mamti amgat zelin nâmti maindamusuwat indemkwatnapeme golaŋ zenze an Samueliyaŋ sokbemti mulupmaŋ mkwage. ");
INSERT INTO naf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Zuda maŋge ekŋenaŋ amobotnaŋin ŋen aiikgat zeme Kawawaŋaŋ Benzamingalen maŋgeengatnaŋ an ŋen Kis egat nemuŋaŋ Sâl ek aikindame egaŋ Amobotnaŋ mulup mti indamamkwatnepeme nup kan 40 pi delaŋ zeye. ");
INSERT INTO naf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Yaŋgut naman Kawawaŋaŋ ikŋaŋ zempemti mundumanen Dewit ek nâmpeme amobotnaŋ tapme zeye, ‘Neŋ Zesiyet nemuŋaŋ Dewit ek ekma dolakŋaŋ penaŋ beme keyepmti amobotnaŋ mamayelen nâmti aiga. Egaŋ nâlen ŋoktik ke mâti keyet kataŋ mulupmaŋ mbe.’ ");
INSERT INTO naf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kawawaŋaŋ amobotnaŋ Dewit egat sokŋaŋ ŋen sokbemti Islael animbi sambe yomengatnan gilik zemti indatitiyet Islael am zetik mimindeye keyet penaŋ Zisasiyaŋ kot sokbeye. ");
INSERT INTO naf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Eweŋan Zisasiyaŋ mulupmaŋ ewe mimipiŋ tapme Zân tu zululut anaŋ ŋeŋaŋ yaŋbemti Islael am ekŋen mama mimiŋin bekanaŋ ke katikpemti keŋ gilik zenze aikme tu zulutindendeyet zetnaŋ windeŋaŋbeŋ diindom kwage. ");
INSERT INTO naf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Zânaŋ Kawawaŋaŋ mulup zempeye ke mmepme ilak delaŋ zenzeyelen bududuk beme am pigok indayaŋkwesiye, ‘In nâgât nâme kwi mambeyap? Wa in nâme neŋ an ŋen kokogalen damuŋ mamip ke bein? An ikŋaŋ ke ewe bam daen takozin an bekeboŋ beke neŋ bukaboŋaŋ elenn sama time ŋep ku bewe.’ ");
INSERT INTO naf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ip notnne Abalaamgat iŋsokŋane ma notnne Zuda maŋgeen ku sokbembeŋaŋ Kawawaŋ masesewatsaip ingat pigok zema nâit, an yomengatnan gilik zemndadagat zenzeŋaŋ e ninmagen sokbembeyet nâmti zenzeŋaŋ. ");
INSERT INTO naf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yaŋŋ an ke sokbeme Zelusalem animbi sambe ma an ŋeŋaŋine ekŋenaŋ an yomengatnan gilik zemndatitiyet koge elak an kapi kegok nânâpiŋ ma ekŋenaŋ kâtnânâ kendo kataŋ golaŋ zenze an ekŋenaŋ an kapiyet meluwaŋ mimiŋaŋ mamaiŋ kwatnup ke an kapi e nâmâtâtâpiŋ belak etaŋ ekandatpemti kume gakiye. Kegok mme golaŋ zenze an ekŋenaŋ zet meluwaŋ mbien bee penaŋaŋmak etaŋ bemâge. ");
INSERT INTO naf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Zuda am ekŋenaŋ an keyelen myuŋguŋguŋaŋ ŋen gakikiyelen kataŋ ku aikbien yaŋgut ekŋenaŋ egat ŋenzinziŋ etaŋ mpemti amobotnaŋ Pailelaŋ zemdelaŋ zeme kume gakikiyet zekaŋkaŋ penaŋ mbien. ");
INSERT INTO naf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kegok mme golaŋ zenze an ekŋenaŋ an kapi muluwaŋ kapigok msameti kume gakikiyet zetnaŋ eweŋan meluwaŋ mkwabien keyet kataŋ am ekŋenaŋ tewen kumasasokpewienaŋ mâtâpmti am sumen met bewien ");
INSERT INTO naf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","yaŋgut Kawawaŋaŋ am sumengatnan mme gilik zemti wage. ");
INSERT INTO naf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Âpme am nâmkiŋpepemak notnaŋ ekmâti Galili msalengatnan Zelusalem mkaen mebien. Ekŋen kemagen Zisasiyaŋ gakikiengatnan gilik zem wati sokbemenzilim sokbemenzilim mamkwatan. Am ekŋen keyaŋ keyet zapatnaŋ am diindom kwabien. ");
INSERT INTO naf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Kawawaŋaŋ yeŋsokŋne ekŋengat Nemuŋaŋ penaŋ peme totogat zetik mimindeye keyet penaŋaŋ elak ningalen kanen kapi Nemuŋaŋ Zisas gakikiengatnan mme wage keyepmti Banabasimak nit inmagen kapi Zet Zapat Dolakŋaŋ ke mti koti tazelup. Keyet zapatnaŋ Kawawaŋgalen Zet Itnaŋaŋ Sam tuŋgupmaŋ zut keyet keŋan meluwaŋ kapigok mimiŋaŋ tazin, ‘Geŋ Nemunn penaŋ alak neŋ gâgât Bipdi penaŋ beyap.’ ");
INSERT INTO naf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Zisas gakikiengatnan gilik zemti wageyaŋ ŋen ewe gakimti ku sambuwe. Keyepmti Kawawaŋaŋ keyet zet kapigok zeye, ‘Neŋ Dewitmagen zetik mban keyet penaŋ kwitnaŋ kwitnaŋ dolakŋaŋ in indamâbap.’ ");
INSERT INTO naf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Naman Kawawaŋgalen Zet Itnaŋaŋ Sam ikŋaŋ keyegak pemaŋ ŋen naman pigok zein, ‘Geŋ Andi Teŋ ek kileŋ pemane msalen ŋep ku sambuwe.’ ");
INSERT INTO naf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Amobotnaŋ Dewitgat yaŋaŋ pigok nânup. Dewilaŋ Kawawaŋgalen am mambien ekŋenmagen Kawawaŋaŋ mulup zempeye ke ekŋengat tuŋguwinan mmeti gakime sekŋaŋ mti yeŋsokŋ notnaŋ indabewien mundum keyegak mebeme sekŋaŋaŋ msalen ke sambuye. ");
INSERT INTO naf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yaŋgut Zisas ek Kawawaŋaŋ mme gakikiengatnan gilik zem wage. Ek sekŋaŋ msalen ke ku sambuye. ");
INSERT INTO naf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Keyepmti notnne in pigok penaŋ nâseip. Nin ingat zet sosok zemkawaŋ bemti kapigok manzenup. Yom delaŋ zenzeyelenset e Zisasmageset etaŋ tazin. ");
INSERT INTO naf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosesiyelen zii zet sambe ke gawepumti mame Kawawaŋaŋ keyet mti yomin ku makatipein yek. Am sambeyaŋ Zisas ek kwep nâmkiŋpemeŋgut Kawawaŋaŋ egat mti yomin ŋep makatipein. ");
INSERT INTO naf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Golaŋ zenze an ŋenaŋ Kawawaŋaŋ zet kapigok zeme nâmti meluwaŋ pigok mge. Ke penaŋaŋ inmagen sokbewemagengat weyaŋ eksemti mambep. Kawawaŋaŋ ekŋengat pigok zeye, ");
INSERT INTO naf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘In nâip, neŋ nukŋaŋ temaŋ inmagen sokbewe keyet zapatnaŋ diindomaŋgut in zetn nâme pepesut mambein ma neŋ am ŋen zempema koti zapat keyegak diindome e kegogak zetnaŋ nâme pepesut beme neŋ mamimtotneip. Keyepmti neŋ kwitnaŋ kwitnaŋ nukŋaŋbeŋ penaŋ inmagen sokbembeyet zewan ke pema kopme in ekti kiŋgati gakim temebep!’” ");
INSERT INTO naf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pâlaŋ zet kegok zeme delaŋ zeme Banabasimak egelaŋ toti kwawesât mmalu animbi sambeyaŋ zewien. It kot Sabat tagoŋgo kan ŋen tabanuwen zet ikŋaŋ kapiyegak ewe tusumti zemâtâpmalu nâmbanup. ");
INSERT INTO naf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kegok zemti sesewat mkaengatnan asek toti Zuda am ma am Zuda maŋgeen ku sokbembeŋaŋ Zudayelen nâmkiŋpepe keyet kataŋ nâmkiŋpemti mamaŋaŋ ekŋenaŋ Pâlmak Banabasimak idapmât mepme egelaŋ gwatnaŋ zet diindomti Kawawaŋgalen keŋ taoletnaŋ ekŋenmagen weme ekŋenaŋ eegalen mulupmaŋ mti mamayet diindowun. ");
INSERT INTO naf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Naman Sabat tagoŋgo kanaŋ ŋeniyet mka temaŋ keyelen animbi sambe penaŋaŋ Kawawaŋgalen zet nâsâgât sesewat mkaen kwaweti bemisik tabien. ");
INSERT INTO naf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Âpme Zuda sesewat mka keyet keŋan ŋeŋaŋ mambien ekŋenaŋ ekme animbi sambe penaŋaŋ kwaweti weme indikti nâmbekam bembe mimindemti ekŋenaŋ Pâlmak Banabas egegat zelit windeŋaŋ mtoidendeyet nâmti zemtalalat zet zewien. ");
INSERT INTO naf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kegok mme Pâlmak Banabasiyaŋ zet windeŋambeŋ ewe pigok zewun, “Islael am in zet kapi ŋeŋaŋ diindome nânâyelen zenzeŋaŋaŋgut in bamkumpemti mama kanzizit mama keyet wisat mnup zeipgapmti ŋep nit in katimindemti am Zuda maŋgeen ku sokbembeŋaŋ ekŋenmagen etaŋ mulup mmann nâmbep. ");
INSERT INTO naf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Amobotnaŋaŋ pigok zemndeye, ‘Neŋ am Zuda maŋgeen ku sokbembeŋaŋ ekŋenmagen busatnaŋ mti mebegat zemindeyap. In msat sambe tapmezinen mekoti animbi indapmukulem mimindeme nâgât nâmkiŋpem neme Kawawaŋaŋ yomengatnan gilik zemindatiwe.’” ");
INSERT INTO naf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Âpme am Zuda maŋgeen ku sokbembeŋaŋ ekŋenaŋ zet ke nâmti oloŋen temaŋ mti Kawawaŋgat wisikŋ zewien. Âpme am mama kanzizitgat zapat bembeyet Kawawaŋaŋ eweŋan nâmindeye ekŋenaŋ zet zapat dolakŋaŋ nâmti nâmkiŋpewien. ");
INSERT INTO naf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mme msat keyet keŋan Amobotnaŋ Zisasiyelen Zet Zapatnaŋ Dolakŋaŋaŋ palakŋaŋ bemti mekoge. ");
INSERT INTO naf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yaŋgut Zuda am sesewat mka keyet ŋeŋaŋ mambien ekŋenaŋ mka keyelen imbi kwizet buŋamin temaŋ Kawawaŋgat mandundumtemien ma an ŋeŋaŋ notnaŋ ekŋengat keŋin walapme ekŋenaŋ Pâlmak Banabas idapmâpme msat ke pemti belakŋan mebun. ");
INSERT INTO naf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Egelaŋ Aikoniam mka msalen mesât tati mama mimiŋin bekanaŋ ke timti mamayet nâmindemti selidaŋgalen kakalakŋaŋ ke kapupmalu mka keyegak topmâpme mebun. ");
INSERT INTO naf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Âpme naman am notnaŋ Zet Zapat Dolakŋaŋ ke nâmti Zisas nâmkiŋpewien ekŋenaŋ oloŋen palenagak mame Emetak Teŋaŋ ekŋengat keŋinan bemisik tage. ");
INSERT INTO naf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Egelaŋ Aikoniam mka teman ke meti muluwaŋ sepemaŋ kapigok mbun. Egelaŋ Zuda am ekŋengalen sesewat mkaen moti Zet Zapat Dolakŋaŋ setnaŋmak weyaŋ bemti zemâtâpmalu Zuda am ma Glik am sambeyaŋ Zisasiyet nâmkiŋpepe aikmâbien. ");
INSERT INTO naf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Âpme Zuda am notnaŋ Zisasiyet ku nâmkiŋpewien ekŋenaŋ wati am Zuda maŋgeen ku sokbembeŋaŋ notnaŋ zet kelakŋaŋ mimindeme ekŋenaŋ nâmkiŋpepemak am ekŋengat ŋenzinziŋ mimindawien. ");
INSERT INTO naf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pâlmak Banabasiyaŋ kan teepmaŋnik Aikoniam mkaen ke ewe nâmisim mamti Kawawaŋgalen Zet Zapat Dolakŋaŋ windeŋambeŋ penaŋ zemkawaŋ bewun. Âpme Amobotnaŋaŋ ikŋaŋ winde idame menok mbun. Keyepmti animbi sambeyaŋ Kawawaŋgalen keŋ taoletnaŋ keyet penaŋaŋ ekti nâmtemtem mti zet keyet nâme penaŋ etaŋ beye. ");
INSERT INTO naf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Keyepmti mka keyet keŋanen animbi sambeyaŋ kalaŋ kumti notnaŋaŋ met Zuda am Zisasiyet kwizapatnaŋgat kasa mamimtemien ekŋenmak tabien ma notnaŋaŋ epeemti Pâlmak Banabas egetmak metabien. ");
INSERT INTO naf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Âpme Zuda am ma am Zuda maŋgeen ku sokbembeŋaŋ ekŋen ma ŋeŋaŋine ekŋenaŋ ondekti keŋ kwep bemti Pâlmak Banabas nanzaŋaŋ idome gakikiyet zemtâwien. ");
INSERT INTO naf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Âpme egelaŋ zet ke nâmti kunzuŋ naman Likonia msalen mka isisikŋaŋ wemegeen ke Kawawaŋgalen Zet Zapat Dolakŋaŋ zepemalu mane mane met mka ŋande temaŋ temaŋ zut Lisitalamak Delebe ke pataŋ zewun. ");
INSERT INTO naf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Âpme Listala mkaen ke an ŋen mamkeŋ setnaŋ wesiŋ sokbembeŋaŋaŋ ke tapme ekbun an ke set mebe kokot bugan ku mamimtan penaŋ. ");
INSERT INTO naf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yaŋ Pâlaŋ zet tazeme an keyaŋ totati zet ke nâmambe tapme Pâlaŋ zikat memuŋ an ke ekti nâŋge, “An wesiŋ kapi nâmkiŋpepeŋaŋ ŋep tazin yaŋ neŋ ŋep mukulem mma dolakŋaŋ besem nâyap.” ");
INSERT INTO naf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kegok nâmti an keyet zet pigok zeye, “Geŋ wat mutututi sedaŋ imti tat.” Zeme keyegak sakwep pututuk wati dendaŋ mebe kokot mge. ");
INSERT INTO naf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pâlaŋ muluwaŋ mamanamaŋ kegok mme am sambeyaŋ ekti Likonia ilinaŋgalen zeleset ŋakŋak mti zewien, “Nin nopiom zut masesewatidanup piwan am nemboŋ bemti kwatolulaŋ pi tuŋgupmnan tapmalup.” ");
INSERT INTO naf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Zemti Banabas egat kwitnaŋ nopiom Zeus kuwien. Âpme Pâl ek zemâtâtât an keyepmti egat kwitnaŋ nopiom Elemes kuwien. ");
INSERT INTO naf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nopiom Zeus egalen sesewat mka temaŋ ke mka temaŋ keyet ganzenan daen matatan. Yaŋ sesewat mka temaŋ keyet sâpe sâpe bumbu an ŋenaŋ makau ma tep katnaŋ dolak dolakŋaŋ ke timti an zut egegat sâpe sâpe bumidasâgât met ambepelet timti mka temaŋ keyelen kimbat setokwakwalen koge. ");
INSERT INTO naf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kegok mme Banabasimak Pâl egelaŋ zapat ke nâmti weŋit mepme kâlâwit kumendelet muti windeŋitbeŋ am sambeyet keŋan meti kwizet ŋagak pigok kuwun, ");
INSERT INTO naf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Am in pi kwilekiyet muluwaŋ kapigok penaŋ kapi tapmip? Nit an in talip kaboŋak! Nit Zet Zapat Dolakŋaŋ kapi zemalu in nâmti kwitnaŋ kwitnaŋ belakŋaŋ kapi time mepme gilik zemti Kawawaŋ penaŋ mamaŋaŋmak ekmagen mebegalen nâmti manzenup. Kawawaŋ nit zapatnaŋ tazelup kapiyaŋ msat kululuŋ ma nembu ma kwitnaŋ kwitnaŋ sambe weme eknup bepi mme sokbeye. ");
INSERT INTO naf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kan tipman baenen am Kawawaŋaŋ nâmindeme belak kileŋ lala bubup mamkwabien. ");
INSERT INTO naf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Yaŋgut Kawawaŋaŋ am ekŋenaŋ nikseipmagen zemti ku enziliye. Egaŋ kululuŋen mamti am keŋ sewakŋaŋ mimndamti map ma muluwinan kwitnaŋ kwitnaŋ mme dolakŋaŋ sokbeme manimwiaŋti oloŋen palen mamanup.” ");
INSERT INTO naf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","An zulaŋ zet mulup temaŋ kegok mti zekaŋkaŋ mti zemkulumindeme sâpe sâpe bumidasât tapmambien e naman peme tage. ");
INSERT INTO naf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kegok mme Zuda am notnaŋ Antiok ma Aikoniam mka metatatnaŋ ekŋenaŋ animbi Zuda maŋgeen ku sokbembeŋaŋ notnaŋ keŋin walapme ekŋenaŋ Pâl nanzaŋaŋ kumti wa gakip nâmti sekŋaŋ mandamti tot mka temaŋ ganzenan baen totpeme ");
INSERT INTO naf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","weme nâmkiŋpepemak am ekŋenaŋ kot ondekti mti mebene zemtapmnepeme egaŋ wat indikti met mka temanenak ke moweŋgeyaŋ msame wati Banabas ilisakwep Delebe mka teman ke meti ");
INSERT INTO naf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Zet Zapat Dolakŋaŋ am ekŋengat zemkawaŋ bemalu am sambe ekŋenaŋ koti Zisasiyelen maŋge bemâbien. Âpme egelaŋ bam gilik zemti ewe Listala, Aikoniam, Antiok am nâmkiŋpepemak wiliŋgim indik indik mebun. ");
INSERT INTO naf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","23","Zisasiyelen maŋge ekŋen nâmkiŋpepeŋinaset zemgwatnaŋ mimindem mimindem mti animbi keyet ŋeŋaŋine eyo aikindemti tu meu zemkulumpemti belak tati ekŋengat dundundu mulup mti Amobotnaŋgat betnanen indem indem mmebun. Mti pigok zemebun, “Nin msalen sisipeŋpeŋ palen kapi mametneti bam Kawawaŋmak mama kanzizit gwaen tatagalen zemndendeŋaŋaŋ manup.” ");
INSERT INTO naf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kegok mti egelaŋ Pisidia msat sutnatemaset kumalu balaŋ zeme meti Pampilia msalen pataŋ zemti ");
INSERT INTO naf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pelga mka msalen Zet Zapat Dolakŋaŋ zemkawaŋ bemti eyetnan toti Atalia mka msalen met pataŋ zewun. ");
INSERT INTO naf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Egelaŋ Atalia mkaen ke waŋgaen mopmalu idatimti naman Antiok mkaen kobun. Mka ke am nâmkiŋpepemak ekŋenaŋ an zut ke tipman baenen Kawawaŋgalen keŋ taolelaŋ egetmak tati idamukulem mme mulup mimiyet dundum idamti zemidedeŋaŋ ke ilak mdelaŋ zemti kobun. ");
INSERT INTO naf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Âpme animbi nâmkiŋpepemak sambe ekŋen ondek indemti Kawawaŋaŋ mukulem mimideme mulup mammetneti kobun keyet zapatnaŋ ma Kawawaŋaŋ am Zuda maŋgeen ku sokbembeŋaŋ ekŋen eyo nâmkiŋpepeyet set mâtâtindeye keyet zapatnaŋ mimindamti ");
INSERT INTO naf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ekŋenmak ke kan teepmaŋ mamamtemun. ");
INSERT INTO naf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Zudia mkaengatnaŋ am nâmkiŋpepeŋaŋ notnaŋaŋ Antiok mkaen meti am nâmkiŋpepeŋinmak mka ke mamb