﻿USE sofia;
DROP TABLE IF EXISTS sofia.nabNT_vpl;
CREATE TABLE nabNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nabNT_vpl WRITE;
INSERT INTO nabNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Je³su²jah³lai²na² wãn³txa² ã³si³wxe³jau³xai²la¹wa². A²nxe³jah¹lai²li² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹lo²su² ta¹hxai²hẽ¹la². Nxe³sxã³ Jah¹lai²na² a²wĩ³na²nãu³xu¹tai²na² ĩ³yau¹ũ³jau³xai²la¹wa². A²nxe³sxã³ Je³su²jah³la² sũ̱³nu²tu̱³ Ta³vi²yah³lo²su² ta¹hxai²hẽ¹la². Ta³vi²yah³la² sũ̱³nu²tu̱³ A³bra³ãu²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nxa²ha¹te¹ A³bra³ãu²ah³lai²na² sa²kxai³lu² a²ki³lha³tu̱³ I³sa²kah³lo²su² ta¹hxai²hẽ¹la². I³sa²kah³la²ki³lha³tu̱³ Ja³ko²ah³lo²su² ta¹hxai²hẽ¹la². Ja³ko²ah³la²ki³lha³nãu³tu̱³ Ju³ta²ah³lo²su² a²lon³yah³la²nãu³su² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ju³ta²ah³la² sa²kxai³lu² a²sĩ̱³sa³ka³lxu³nu¹tai²na² so¹ka³tu̱³ a²ki³lha³nãu³tu̱³ ha¹li¹ a³li³lah¹kxi²ta¹hxai²hẽ¹la². Nxe³te²na² ĩ³lxa² Pe³re²sah³lo²su² Sa³ra²ah³lo²su² nxe³ya³ta¹hxai²hẽ¹la². Pe³re²sah³la²ki³lha³tu̱³ Es³ro³mah³lo²su² ta¹hxai²hẽ¹la². Es³ro³mah³la²ki³lha³tu̱³ A³rãu²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","A³rãu²ah³la²ki³lha³tu̱³ A³mi³na³ta²bah³lo²su² ta¹hxai²hẽ¹la². A³mi³na³ta²bah³la²ki³lha³tu̱³ Na²a³sõ²mah³lo²su² ta¹hxai²hẽ¹la². Na²a³sõ²mah³la²ki³lha³tu̱³ Sal³mõ²mah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sal³mõ²mah³la² a²sxe³xa³ka³lxa² Ra³ka²ba³ka³lxu³su² nxe³ya³sxã³ a²ki³lha³tu̱³ Bo³a²sah³lo²su² ta¹hxai²hẽ¹la². Bo³a²sah³la² a²sxe³xa³ka³lxa² Ru²ta³ka³lxu³su² nxe³ya³sxã³ a²ki³lha³tu̱³ O³be²jah³lo²su² ta¹hxai²hẽ¹la². O³be²jah³la²ki³lha³tu̱³ Je²sah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Je²sah³la²ki³lha³tu̱³ Ta³vi²yah³lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² I³sa³e² nũ̱³ka̱³txa² a²wa³kxẽn³yah³lo²su² ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ Ta³vi²yah³la² I³sa³e² nũ̱³ka̱³txa² a²wa³kxẽn³yah³lai²na² a²sxe³xa³ka³lxa² a²wi¹lhĩ¹na² U³ri²ah³la² sxe³xa³ka³lxu³su² ta¹hxai²hẽ¹la². A²nxe³ya³sxã³ a²ki³lha³tu̱³ Sa³lo³mãu²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sa³lo³mãu²ah³la²ki³lha³tu̱³ Ro³bo³ãu²ah³lo²su² ta¹hxai²hẽ¹la². Ro³bo³ãu²ah³la²ki³lha³tu̱³ A³bi³a²ah³lo²su² ta¹hxai²hẽ¹la². A³bi³a²ah³la²ki³lha³tu̱³ A³sa²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","A³sa²ah³la²ki³lha³tu̱³ Jo³sa³fa²ah³lo²su² ta¹hxai²hẽ¹la². Jo³sa³fa²ah³la²ki³lha³tu̱³ Jo³rãu²ah³lo²su² ta¹hxai²hẽ¹la². Jo³rãu²ah³la²ki³lha³tu̱³ O³si³a²sah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","O³si³a²sah³la²ki³lha³tu̱³ Jo³tãu²ah³lo²su² ta¹hxai²hẽ¹la². Jo³tãu²ah³la²ki³lha³tu̱³ A³ka²sah³lo²su² ta¹hxai²hẽ¹la². A³ka²sah³la²ki³lha³tu̱³ E³se³ki³a²sah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","E³se³ki³a²sah³la²ki³lha³tu̱³ Ma³na³se²sah³lo²su² ta¹hxai²hẽ¹la². Ma³na³se²sah³la²ki³lha³tu̱³ A³mõ²mah³lo²su² ta¹hxai²hẽ¹la². A³mõ²mah³la²ki³lha³tu̱³ Jo³si²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jo³si²ah³la²ki³lha³tu̱³ Je³ko³ni²ah³lo²su² a²lon³ti³nãu³su² ta¹hxai²hẽ¹la². A²nxe³tãu³a² Ba³bi³lo²na² nũ̱³ka̱³txa² wxã³sxã³ so¹hxa³kxi²sxã³ Ba³bi³lo²na²ko³nãu³a² sa³wxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hã²wxãn³txa³ Ba³bi³lo²na²ko³nãu³a² sa²wxe³nyhain¹nũ²la² hã²wxãn³txa³ Je³ko³ni²ah³la²ki³lha³nãu³tu̱³ Sa³la³ti³e²lah³lo²su² ta¹hxai²hẽ¹la². Sa³la³ti³e²lah³la²ki³lha³tu̱³ So³ro³ba³be²lah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","So³ro³ba³be²lah³la²ki³lha³tu̱³ A³bi³u²jah³lo²su² ta¹hxai²hẽ¹la². A³bi³u²jah³la²ki³lha³tu̱³ E³li³a³kĩ²mah³lo²su² ta¹hxai²hẽ¹la². E³li³a³kĩ²mah³la²ki³lha³tu̱³ A³so²rah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","A³so²rah³la²ki³lha³tu̱³ Sa³to²kah³lo²su² ta¹hxai²hẽ¹la². Sa³to²kah³la²ki³lha³tu̱³ A³ki²mah³lo²su² ta¹hxai²hẽ¹la². A³ki²mah³la²ki³lha³tu̱³ E³li³u²jah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","E³li³u²jah³la²ki³lha³tu̱³ E³li³a³sa²rah³lo²su² ta¹hxai²hẽ¹la². E³li³a³sa²rah³la²ki³lha³tu̱³ Ma³tã²ah³lo²su² ta¹hxai²hẽ¹la². Ma³tã²ah³la²ki³lha³tu̱³ Ja³ko²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ja³ko²ah³la²ki³lha³tu̱³ Jo³se²ah³lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² sa²kxai³lu² a²sxe³xa³ka³lxa² Ma³ri²a³ka³lxu³su² ta¹hxai²hẽ¹la². Ma³ri²a³ka³lxai²na² sa²kxai³lu² wẽn³su² Je³su²jah³lo²su² a³li³lah¹ta¹hxai²hẽ¹la². A²nxe³jah¹la² Je³su²jah³la² ĩ³yĩ¹li²hain¹jau³xa²sa¹. Kris²tu³jah¹lo²su¹. Nxe³ta¹hxai²hẽ¹la². A²nxe³jau³xai²na² a²si³yxau³jau³xa²su² Txa²wã¹sũ̱³na² hi²sen³su² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la²nũ³a² so¹jah¹lai²la¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jã¹nxe³jut3su² Je³su²jah³la² sũ̱³na²nãu³su² ta¹hxai²hẽ¹la². Nxe³sxã³ A³bra³ãu²ah³la² ã³si³wxe³ki̱³ka³tu̱³ Ta³vi²yah³la² hãi¹nxã¹ki̱³kxai²nãn²tu̱³ a²sũ̱³na²nãu³xa² ĩ³yĩ¹lih²xai³ain¹te²nãu³tu̱³ hxi²ka² hxan³sxã³ ha¹li¹ ha¹li¹ wxa²sa²so¹xi²sxã³ 14 nxe³ki̱³te²ju²hẽ³la². Te²yã¹nxe³sxã³ Ta³vi²yah³la² ã³si³wxe³ki̱³ka³tu̱³ hu³ Ba³bi³lo²na²ko³nãu³a² sa²tã³nyhain¹tãu³nai³tã² hãi¹nxã¹ki̱³kxai²nãn²tu̱³ a²sũ̱³na²nãu³xa² ĩ³yĩ¹lih²xai³ain¹te²nãu³tu̱³ hi³ka² hxan³sxã³ ha¹li¹ ha¹li¹ wxa²sa²so¹xi²sxã³ 14 nxe³ki̱³te²ju²hẽ³la². Te²yã¹nxũn³sxã³ Ba³bi³lo²na²ko³nãu³a² sa²tã³nyhain¹tãu³nai³tã² ã³si³wxe³ki̱³kxai²nãn²tu̱³ hu³ Kris²tu³jah¹la² a³li³lah¹ju³ta² hãi¹nxã¹ki̱³kxai²nãn²tu̱³ a²sũ̱³na²nãu³xa² ĩ³yĩ¹lih²xai³ain¹te²nãu³tu̱³ hxi²ka² hxan³sxã³ ha¹li¹ ha¹li¹ wxa²sa²so¹xi²sxã³ 14 nxe²ki̱³te²ju²hẽ³la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jã¹nxe³jut3su² Je³su² Kris²tu³jah¹la² a³li³lah¹jau³su² nxe³te³nah¹lxi¹. Ma³ri²a³ka³lxai²na² Je³su²jah³la² a²hã³ka³nai²na² nxe³ta¹ka³lxai²na² sa²kxai³lu² Jo³se²ah³la² so¹nyhu¹kxi³ju³ta³nũ³a² e³hau³kon³ta³lu²nain¹ta¹hxai²hẽ¹la². E³hau³kon³ta³lu²nain¹nũ²la² yxãn¹ta¹ so¹nyhu¹xa³ta̱³lxa¹ Ma³ri²a³ka³lxa² wẽh³ni³ta¹hxai²hẽ¹la². Hai³txi³ Jo³se²ah³lo²la³ wĩn¹txi²nxa³ta̱³lxa¹ Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² te²hi²sen³su² wẽ³sai²la² a²ẽ¹nai²na² ũh³wxe³ni¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nxa²ha¹te¹ Jo³se²ah³lo²kxai³lu² ju¹tai²li² ã³ne³wxe³nũ²la², Ma³ri²a³ka³lxa² wẽh³ni³ju³ta² ã³ne³wxe³nũ²la² a²ẽ¹na² ne³kxe³kxi²nha²ta¹hxai²hẽ¹la². Ne³kxe³kxi²nha²te³nah¹lxi¹: — Wain³txi³ kãi³jah¹lo²sa¹xã¹. Hai³txi³ kuh³lxa³thin¹sxã³ kãi³te²txã³xã¹. Ta¹ka³lxai²na² wẽ³sa² wẽh³ni¹kxa² wet1sa²jah¹lo²sxa³xã¹. Nxe³kxan²ti³ kwa² ĩ³ãu²lxi²sa²ju³ta² ten³sa²nxa³nhã¹. Nxe³sa²nxa³ha²kxai³ kwa² hãi³a² ã³a¹tũ¹xã¹. Ma³ri²a³ka³lxa² ã³a¹tũ¹xã¹. Nxe³nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nxe³tãu³ãn²tu̱³ta¹ nũ¹ha̱in³nha²tãu³a² Txa²wã¹sũ̱³na² sa²si¹hã³jah¹la² oh³xan¹jah¹la² wxa²kan³sxã³ wxã³ta¹hxai²hẽ¹la². Wxã³ka³tu̱³ Jo³se²ah³la² sxa³sxã³ ãu³xi²ta¹hxai²hẽ¹la². Ãu³xi²tãu³a² ã³nhxi²sxã³nho³kxi²ta¹hxai²hẽ¹la². Ã³nhxi²sxã³nho³kxi²te³nah¹lxi¹. Txa²wã¹sũ̱³na² sa²si¹hã¹jah¹la² ã³tĩ³sxã³ e³kxi²te³nah¹lxi¹: — Jo³se²ah³lãi³. Ta³vi²yah³lu¹ta² a²ne³sa³wit3si¹lxi¹. Txa²wãn³txa² e³kxi¹nx2ta¹jau³xa² wi¹lain³kxi¹sẽ¹li¹. “Ta¹ka³lxa² Ma³ri²a³ka³lxa² so¹nha¹tũ¹xã¹.” Nxi¹lxi¹. Nxẽ¹nha²kxai³ hxi²waun³txi³txa³hẽ¹li¹. Ta¹ka³lxai²na² so¹sẽ¹li¹. Wẽ³sai²na² ta¹ka³lxa² wẽh³ni¹kxa² hai³txi³ yuh³xai²nãn¹te² we¹kxe³su² nxe²nxa³i¹. Yxãn¹ta¹ Sũ̱³na² yãu³ka³jxah¹la² te²hi²sen³su² wĩn¹txi²nxa³kxan²ti³ wẽ³sa² wet1jah¹lai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A²nxe³ta¹ka³lxa² wẽ³sa² a³li³lah¹kxi²tu¹wi¹. A²ki³lha³lxa² a³li³lah¹kxi²tu¹wi¹. Nxe³kxai²nãn²tu̱³ a²ĩ³lxa² Je³su²jah³lo²su¹ nxe² ĩ³yĩ¹li²txa²hẽ³li¹. Nxe³sxã³ hã²wxãn³txa³ wẽ³sai²li² txon¹nũ²la² a²nũ²a²nãu³xai²na² ko̱³nxe³ti³ kãi³ain¹ju³ta² a²yxo²ha³kxa¹ ã³wa²sut1ti³hit1tain¹tu¹wi¹. Oh³xan¹jah¹la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A²nxe³jau³xai²na² kxã³nhxĩ¹nai³tãn²jau³xa² Sũ̱³na² ĩ³hen³txi²tũ̱³ka̱³txai²na² wãn³txa² jau³xau³hxai²tẽx1ta³la³ jau³xain²txi³ nxe³ta¹hxai²hẽ¹la². Nxe³jau³xu¹tai²na² te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","— Nxe³jah³lxi³wxi¹. Tu¹ha³ka³lxa² in³txa² wĩn¹ti²nxa³ta¹ka³lxa² wẽh³nĩ¹tu¹wi¹. Wẽh³nĩ¹ka³tu̱³ wẽ³sai²li² a²ki³lha³lxai²li² a³li³lah¹kxi²tu¹wi¹. Nxe³kxai²nãn²tu̱³ a²ĩ³lxa² ĩ³lxi³hain¹tu¹wi¹. E³ma³nu³e²lah³lo²su¹. Nxe³ta¹hxai²hẽ¹la². A²nxe³te² ĩ³lxai²na² a²si³yxau³tãu³khai³xai²na² Txa²wã¹sũ̱³na² ã³nũ²kxi²sxã³ yxau³ah³nẽ³na³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nxe³nũ²la² hã²wxãn³txa³ Jo³se²ah³lo²kxai³ txu¹lxi²ka³tu̱³ ĩ³sa²yxau³ta¹hxai²hẽ¹la². Ĩ³sa²yxau³nũ²la² oh³xa² sa²si¹hã³jah¹lai²na² wãn³txai²na² sa²yxo²we¹ta¹hxai²hẽ¹la². Sa²yxo²we¹te³na¹ Ma³ri²a³ka³lxa²kxai³lu² so¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","So¹kxan²ti³ hai³txi³ ũ³whĩn¹txi³nyha¹sxã³ o²la³kxi²nyha¹ta¹hxai²nxa³hẽ¹la². Wẽ³sai²kxai³lu² a³li³lah¹xa³ta̱³lxa¹ ũ³whĩn¹ti³nyha¹ta¹hxai²nxa³hẽ¹la². Nxa²ha¹te¹ wẽ³sai²li² a³li³la²kxi²te³na¹ wẽ³sai²na² ĩ³yĩ¹li²yha³ta¹hxai²hẽ¹la². Je³su²jah³lo²su¹ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jã¹nxe³ju³kxai³lu² kxã³nhxĩ¹nu¹tai²na² E³ro²jah³la² kãin²jah¹la² Ju³te²an¹ko³xa² a²wa³kxẽn³yah³la² yxau²xai³lhĩ¹nu¹tai²na² Je³su²jah³la² a³li³lah¹ta¹hxai²hẽ¹la². Be³lẽ²thĩ³na² Ju³te²a²ko³xan¹thĩ³na² a³li³lah¹ta¹hxai²hẽ¹la². Nxe³tãu³ãn²tu̱³ a²nũ²a² a²hoh³lxi³khai¹nũ̱³ka̱³txa² ha³lo²a² u²lyxau¹ko³xa² u³je³na² a³li³xi²tãu³an¹ko³xa² a³li³xain¹nũ²la² wxã³ain¹ta¹hxai²hẽ¹la². Wxã³ain¹nũ²la² Je³ru³sa³lẽ²thĩ³na² Ju³te²a² ko³xan¹thĩ³na² kãin²khaix1nxe³thĩ³nãn²ta³ ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wi¹hain¹sxã³ e³kxain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","— Ĩh¹nũ¹la³ta̱³ Ju³te²a² wa³kxẽn³yah³lo²nũ³a² kwẽn¹ta² a³li³lah¹jah¹la² he¹ji¹wi¹? Txa²ha³lo²a² a³li³sĩ¹na¹hĩ¹nai³tã² a²hxi³ka²ta³khai³xa² ĩ²sĩ¹na¹hẽ³li¹. Nxe³ka³tai²na² ĩ²sĩ¹na¹ha²kxai³ wẽ³sai²li² sa²nẽn¹kxi²te³lhxã³ wxã³ye¹nx2ti³nha¹wi¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nxe³nxa²ha¹te¹ nxe³jau³jau¹xai²na² ain³kxain¹nũ²la² E³ro²jah³la² yu̱h³lxi³khaix1ta¹hxai²hẽ¹la². — A²wa³kxẽn³yah³lo²sa¹ju³ta² sa²tã³ni²lã³kxi²sa²te³na³na¹. Nha²jau³su² E³ro²jah³la² ta¹hxai²hẽ¹la². Te²yã¹nxũn³sxã³ Je³ru³sa³lẽ² tũ̱³ka̱³txa² whãi²na¹ E³ro²jah³la² yã¹nxe² yu̱h³lxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nxe³te²kxa³ya̱³lhu² E³ro²jah³lai²na² te²hi²sen³su² a²nũ²a² hxi²kan¹txi³nãu³xa² nxe³te²he³la³kxa² ã³yã³nũ²kxi²xi²si¹hain¹ta¹hxai²hẽ¹la². Wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txi³nãu³xa² ĩ³kaix1tha²kxai³ ha³te̱h³nxã³nxa² a²hoh³lxi³su² nũ̱³ka̱³txa² ĩ³kaix1tha²kxai³ nxe³ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Kris²tu³jah¹la² Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3jah¹la²nũ³ãn²ta² a³li³la¹jen³nũ³a² ĩh¹nũ¹la³ta̱³ a³li³la¹ji¹wi¹? Nxẽn³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nxe³nxa²ha¹te¹ ĩ³ye³sxã³ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Be³lẽ²thĩ³na² Ju³te²a² ko³xan¹thĩ³na² a³li³la¹kxi²nẽ³tu¹wi¹. Sũ̱³na² hen³txi³jah¹lai¹tã³ Sũ̱³na² wãn³txa² au³hxai²jau³yai¹tã² nxe³ta¹hxai²hẽ¹li¹. Nxe³jau³jau¹xai²na² nxe³te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Wxãi²na² Be³lẽ²thĩ³nãn¹tũ̱³ka̱³txi³si²yah³lxi¹lxi¹. Ju³te²a²ko³xan¹thĩ³nãn¹tũ̱³ka̱³txi³syah¹lxi¹lxi¹. Thĩn³kãi²nxa³te²hũ̱³kxan²ti³ Ju³te²a² hxi²kan¹te²nãu³xai²na² kãin²te²lo³yah³lxi¹lxi¹. Nxe³sxã³ wxa²nũ̱³ka̱³txa² a²nũ²a² ka³na³ka³na³jah¹la²nũ³a² hxi²kan¹ta² si³yxau³ti³lo³nx2tu¹wi¹. Nxe³kxai²nãn²tu̱³ txa²nũ̱³ka̱³txai²na² I³sa³e² nũ̱³ka̱³txi³su² txa²nũ̱³ka̱³txi³su² ha²kxai³ a²wa³kxẽn³no³nĩn¹tu¹wi¹.” Nxe³jau³xai²na² nxe³ta¹hxai²hẽ¹li¹. Ha³te̱h³nxã³nxa² a²hoh³lxi³su² nũ̱³ka̱³txa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nxe³nxa²ha¹te¹ E³ro²jah³lu¹ta²kxai³lu² a²hoh³lxi³su² nũ̱³ka̱³txa² hãi³a² kaix1tain¹sãn²nũ²la² hi³ka²ta³u¹tai²na² wxã³je²nãu³wa³kxai³tã² ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ĩ³wã̱³txi³sxã³ ĩ²so¹nũ²la² Be³lẽ²thĩ³na² ĩ³sa²si¹hã³ain¹ta¹hxai²hẽ¹la². Ĩ³sa²si¹hã³ain¹te³nah¹lxi¹: — Be³lẽ²thĩ³na² ai³jah¹lxi³hẽ¹li¹. Ai³yah³lxin¹kxai²nãn²tu̱³ wẽ³sai²li² ã³ten³khai¹nxe³jah³lxi³hẽ¹li¹. Ã³ten³sxã³ ĩ³ha¹txi²yah³lxin¹kxai²nãn²tu̱³ ĩ³hen³txi³sah¹lxi³hẽ¹li¹. Sah¹lxin¹kxai²nãn²tu̱³ hã²wxãn³txa³ wxã³nũ³na¹tu¹wi¹. Wxã³na¹kxai²nãn²tu̱³ sa²nẽn¹kxi²nũn³na¹tu¹wi¹. E³ro²jah³la² ĩ³ki³ha¹kain¹sxã³ e³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nxe² e³ta³lun²nxa²ha¹te¹ a²hoh³lxi³su² nũ̱³ka̱³txai²na² sa²kxai³lu² ã³waix3tain¹ta¹hxai²hẽ¹la². Ã³waix3tain¹tãu³ hi³ka²tai³ta³lxi² u³je³na² a³li³xi²tãu³an¹ko³xai²na² a³li³ai¹nhĩ¹nai³tã² ĩ²ain¹ta¹hxai²ti³ai¹ti²tu³wa². Nxe³sxã³ hi³ka²tain²txi³ ĩ²xain¹ta¹hxai²hẽ¹la². Ĩ²xain¹ka³tu̱³ ai³ain¹tĩh³na² ne³ka³ta²ain¹ta¹hxai²hẽ¹la². Ne³ka³ta²ain¹sxã³ wẽ³sai²na² sxa³thĩ³na² ã³nhau³kot3sĩ¹na¹ ã³yit1ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jã¹nxe³jut3su² ai³ain¹tãu³a² hi³ka²tain²txi³ ĩ²ain¹te³na¹ kãin²ka³li³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nxa²ha¹te¹ ai³nũ²la² sxi²ha² wẽ³sa² sxa³thĩ³na² a³txain¹nũ²la² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wih¹ka³tu̱³ Wẽ³sai²na² ĩ²i² Wẽ³sa² hã³ka³na² Ma³ri²a³ka³lxa² ĩ²i² nxe³ain¹ta¹hxai²hẽ¹la². Ĩ²ain¹ka³tu̱³ ã³ka³ti³wxe³sãn²nũ²la² sa²nẽn¹kxain¹ta¹hxai²hẽ¹la². Sa²nẽn¹kxain¹tãu³a² yen³kxa² wi¹kxa² ũ³hũ¹ain¹ta¹hxai²hẽ¹la². Ou²ro²ki³a² ũ³hũ¹ha²kxai³ wi¹lũ³tũ̱³xa² ĩn³sẽ²su²tũ̱³xa² ũ³hũ¹ha²kxai³ wi¹lũ³jau³xa² mi²ra³jau³xa² ũ³hũ¹ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nxe² ta³lu²nain¹nũ²la² hã²wxãn³txa³ a³li³xain¹ta¹hxai²hẽ¹la². Kxã³nxai³tã² Be³lẽ²thĩ³na² a³li³xai¹nxa³ta̱³lxa¹ hxi²sxã³nhon³yah³lxi³ta¹hxai²hẽ¹la². Hxi²sxã³nhon³yah³lxi³te³nah¹lxi¹, Txa²wã¹sũ̱³na² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. E³ro²jah³lai¹tã² sxi²ha² ã³wa̱³lah³lxi³txa³hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². Nxe² hxi²sxã³nhon³yah³lxi³ta¹hxai²hẽ¹la². Nxe³ha²kxai³ tĩh³na² wxã³ain¹tĩh³nai¹tã² ĩ³xai¹nxa³ha²kxai³ tĩh³nu³ ã̱³lxi³ ĩ³xai¹nha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nxe³nxa²ha¹te¹ tĩh³nu² ã̱³lxi³ ĩ³xain¹tãu³a² Jo³se²ah³la² sxa³sxã³ ãu³xi²nũ²la² hxi²sxã³nhon³ta¹hxai²hẽ¹la². Nxe³tãu³a² Txa²wã¹sũ̱³na² ha³lo²an¹jah¹la² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Ĩ³ye³kxi²te³nah¹lxi¹: — Jo³se²ah³lãi³. Ĩ³sa²yxau³txu¹li¹. Wẽ³sai²na² tẽ³i² a²hã³ka³nãin²txi³ tẽ³i² nxẽ³ka³tu̱³ E³ji²ta²ko³xa² ih³saun³txa²hẽ³li¹. E³ro²jah³la² Wẽ³sa² ĩ³su²lhã³te³na³li¹. Nxe³ha²kxai³ wa³su³txi³ ih³saun³jah¹lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ ha³lo²ai²li² yxau²xai³jah¹lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ yxau²ta³lun²na³na¹. Nxe³kxai²nãn²tu̱³ ĩ³hen³txi³nx2ta¹tu¹wi¹. Oh³xan¹jah¹la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nxe² hxi²sxã³nhon³ta³lun²nũ²la² txu¹lxi²ka³tu̱³ wẽ³sai²na² tẽ³i² a²hã³ka³nãin²txi³ tẽ³i² nxe³ka³tu̱³ ka³nxah³tãu³an²tu̱³ wa³su³txi³ ih³saun³sxã³ E³ji²ta²ko³xa² ai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hã²wxãn³txa³ E³ji²ta²ko³xa³nãu³a² yxau²xai³lain¹ta¹hxai²hẽ¹la². E³ro²jah³la² ka³te̱³na² he¹tãu³a² yxau²xai³lain¹ta¹hxai²hẽ¹la². Jã¹nxe³jut3su² kxã³nxai³tã² Txa²wã¹sũ̱³na² wãn³txa² hen³txi³jah¹la² jau³xau³hxai²tẽx1ta² e³ta¹hxai²hẽ¹la². E³te³nah¹lxi¹: — Sũ̱³na² Si³yxau³jah¹lo²na¹xai²na² Txa²ki³lha³lxa²khai³xai²na² E³ji²ta²ko³nãu³a² ĩ³kaix1sxã³ sa²sai¹ai¹na¹hẽ³li¹. Nxe³jau³xau³hxai²tẽx1tã² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nxe³nxa²ha¹te¹ E³ro²jah³lai²na² sa²kxai³lu¹ a²hoh³lxi³su² nũ̱³ka̱³txai²na² wa̱³li²nxa³ju³ta³nũ³a² ĩ²nũ²la² ĩ³a̱n³txi³khaix1ta¹hxai²hẽ¹la². Ĩ³a̱n³txi³te³nah¹lxi¹. A²sa³wi³ha³lxa² kwa³na³te²an¹jau³kxai³lu¹: — Nxe³jah³lxi³wxi¹. Be³lẽ²thĩ³na² ã³nxai² Ra²ma²thĩ³na² ã³nxai² ha³lo²a² ti²ta³lo³kxai²na² ã³nxai² nxe² ã³ten³jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ in³txa² wẽ³ha³lxa² jũ¹lxi³te²a² kwẽ³kxa² ye³ha¹li¹ kwẽ³kon³sxã³ hi¹nai¹nxa³kxai²nãn²tu̱³ nxe³te²na² a²yxo²ha³kxa¹ ĩ³sun²tã¹jah¹lxi³hẽ¹li¹. Ã³tox3ã¹nxe³jah³lxi³hẽ¹li¹. Nxe³ju³tai²na² E³ro²jah³lai²na² a²ẽ¹nãn¹jau³kxai³lu¹: — Nxe³na¹kxai²nãn²tu̱³ Wẽ³sai³ta³lxi² ĩ³su²lhã³kxai¹na¹tũ¹xã¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jã¹nxe³jut3su² kxã³nxai³tã² Je³re³mi²ah³lu¹tai²na² wãn³txa² jau³xau³hxai²tẽx1ta² e³ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","— Ra²ma²thĩ³nãn¹tũ̱³ka̱³txa² kãin² nã̱³ni² kãin² ĩ³ãin²ta³kxi² nxe³ain¹te²sin²tai¹. Ra³ke²la³ka³lxai²na² sa²kxai³lu² a²wẽ³ha³lxi³khai³xa² ĩ³nã̱n³kxain¹na³li¹. Wẽ³ha³lxan²tu̱³ sun²tã¹hxa³kxain¹na³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² hxi²kan¹txi³ a²ka³lxa¹te²nãu³xa² ya³lo³txai¹nxa³lho³li¹. Nxe³ta¹hxai²hẽ¹la². A²nxe³thĩ³nãin²ti³ kxã³nxu¹tai²na² Ra³ke²la³ka³lxi³nu¹ta²kxai³lu² ya³lu²te³lhxã³ nxe³hĩ¹nu¹tai²na² kãin² nã̱n³ta¹hxai²hẽ¹la². A²wẽ³ha³lxi³khai³xa² wi¹ton²kxi²nxa³ta̱³lxa¹ ã³nhxi²ka¹txa³ha²kxai³ kãin² nã̱n³ta¹hxai²hẽ¹la². Nxe³kxaix3jã¹nxũn³sxã³ Ra²ma²thĩ³nãn¹ta¹ka³lxi³nãu³xa² te²yã¹nxe² nã̱n³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nxe³nxa²ha¹te¹ hã²wxãn³txa³ E³ro²jah³lai¹tã² ya³lu²ta¹hxai²hẽ¹la². Ya³lu²nũ²la² Sũ̱³na² ha³lo²an¹jah¹la² wxã³ta¹hxai²hẽ¹la². Wxã³te³na¹ Jo³se²ah³lo²kxai³lu² sxa³sxãu³xi²nũ²la² hxi²sxã³nhon³tãu³a² ĩ³ye³kxi²nha²ta¹hxai²hẽ¹la². Ĩ³ye³kxi²nha²te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","— Nxex3sa²lxi¹. Ĩ³sa²yxau³txu¹li¹. Wẽ³sai²na² a²hã³ka³nũ¹na² nxe³sxã³ tẽ³txa²hẽ³li¹. Tẽ³sxã³ ĩ³xi²txu¹li¹. I³sa³e²ko³xa² ĩ³xi²txu¹li¹. Wẽ³sai²na² ĩ³su²lhã³ain¹ju³ta² ten³jah¹la² ya³lu²na²hẽ³li¹. Nxe³ha²kxai³ ĩ³xi²txu¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nxe² hxi²sxã³nhon³ta³lun²ka³tu̱³ ĩ³sa²yxau³ta¹hxai²hẽ¹la². Ĩ³sa²yxau³ka³tu̱³ hã²wxãn³txa³ Wẽ³sai²na² a²hã³ka³nai²na² nxe³sxã³ tẽ³sxã³ ĩ³xi²yain¹ta¹hxai²hẽ¹la². I³sa³e²ko³xai²na² ĩ³xi²yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nxe³nxa²ha¹te¹ ĩ³xi²tãu³ãn²tu̱³ a²ha³lo²a² ha³ta̱³nxe³jau³xa² ĩ³hen³txi²nyhain¹ta¹hxai²hẽ¹la². Ĩ³hen³txi²nyhain¹te³ãn¹jau³kxai³lu¹: — E³ro²jah³lai¹tã² Ju³te²an¹ko³xai²na² I³sa³e² ko³xa² kãi²nxa³ko³xai²na² ha³txih³xan¹ko³xai²na² a²hxi²kan¹jah¹laix1tã² ya²la³tu̱³ ya³lu²na²hẽ³li¹. Ya³lu²ha²kxai³ a²ki³lha³lxa² Ar³ke³lau²sah³la² ã³wẽ̱³not3sxã³ ha³lo²a² wa³kxẽn³yah³la² hxi²kan¹txi³lon³na³li¹. Nxe³jau³xai²na² ha³ta̱³nxe³jau³su² ĩ³hen³txi³nyhain¹ta¹hxai²hẽ¹la². Ĩ³hen³txi³nũ²la² yuh³lxi³jau³su² thĩ³na² yxau²xai³thĩ³nai³tã² hai³txi³ wa̱³li²sxã³ yxau²xai³to³ta¹hxai²nxa³hẽ¹la². Nxe²nxa³kxe³su² hxi²sxã³nhon³txi²si¹ha²kxai³ Txa²wã¹sũ̱³na² wa̱³li²si¹hxa³jau³su² ain³kxi²ha²kxai³ ha³lo²a² ã̱³xa² Ka³li³le²a²ko³xa²nãu³a² I³sa³e² ko³xa² kãi²nxa³ko³xai²na² ha³txih³xan¹ko³xai²na² ai³sxã³ yxau²xai³lyain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ko¹xai²na² yxau²xai³lyain¹nũ²la² Na³sa³re²thĩ³na² ã³wih¹sxã³ yxau²xai³lyain¹ta¹hxai²hẽ¹la². Jã¹nxe³jut3su² kxã³nxai³tã² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹la²nãu³xa² jau³xau³hxai²tẽx1ta² e³kxain¹ta¹hxai²hẽ¹la². E³kxain¹te³nah¹lxi¹: — Jah¹lai²li² Na³sa³re²thĩ³nãn¹jah¹lo²sin¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nxe³nxa²ha¹te¹ jũ¹nxa² kxã³nãu³a¹ Jo³ãu² Ba³tis²jah³la² wxã³ta¹hxai²hẽ¹la². Ju³te²a² ko³nãu³a² a²nũ²a² yxau³ai¹nxa³ko³nãu³a² Jo³ãu² Ba³tis²jah³la² he¹xai³ta¹hxai²hẽ¹la². A²nũ²a² ĩ²li³te²nãu³a² wxã³kxai²nãn²tu̱³ Sũ̱³na² Wãn³txa² ĩ³hen³txin³txain¹ta¹hxai²hẽ¹la². Ĩ³hen³txin³tain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","— Nxex3jah³lxi³sa²lxi¹. Wxa²ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ã³sxã³ ã³nxa̱³wã²na³jah¹lxi³hẽ¹li¹. Ã³sxã³ ĩ³ãin²ta³kxi²nha¹jah³lxi³hẽ¹li¹. Txa²wã¹sũ̱³na² a²hxi²kan¹ta² si³yxau³tãu³lot3ju³ta³nũ³a² ti³hẽn¹te³na³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A²nxe³ju³tai²na² kxã³nhxĩ¹nai³tã² I³sa³i²ah³lu¹tai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lu¹tai²na² jau³xau³hxai²tẽx1ta² nxe³ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — A²nũ²a² ã̱³jah¹la² wxã³tu¹wi¹. Ha³lo²ai²na² a²nũ²a² yxau³ai¹nxa³ko³nãu³a² ai³sxã³ ĩ³ye³kxi²tu¹wi¹. Ĩ³ye³kxi²te³nah¹lxi¹: “A²nũ²a² hxi²kan¹jah¹lo²su² wxã³ju³ta²nũ³a² yũ³kxai²nãn²tu̱³ a²wxã³tĩh³na³nũ³a² wxa²hau³ko³tain¹te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³sxã³ Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹la² wxã³ju³ta²nũ³a² wxa²ẽ¹nãu³ai²na² wxa²hau³ko³nha¹jah³lxi³hẽ¹li¹. Ya²la³tu̱³ wxã³ti³wa³ki³lxon³na³li¹.” Nxe³ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jã¹nxe³jah¹la² Jo³ãu² Ba³tis²jah³lai²na² sa²kxai³lu² wã²la² ũ³whih²kxi²nha²ka³lo³a² nxe³ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: Ka³me²la² a²wã²la² tẽ³sxã³ ũ³whih²kxi²nha²ha²kxai³ a²sĩ̱³ĩ¹nha²ka³lo³a² po¹na² wã²la² wxa²sĩ̱³ĩ¹nha²ha²kxai³ nxe³te²ju²hẽ³la². Yain³txa² te²a² so¹lxi³ yain³te²ju²hẽ³la². Ka³ya̱t3su² ĩ³so¹jĩ²ha²kxai³ txu³ha²yau³xa² so¹lxi³ ĩ³na²ha²kxai³ nxe³jah¹lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nxa²ha¹te¹ a²nũ²a²nãu³xai²na² Je³ru³sa³lẽ²thĩ³nãn¹tũ̱³ka̱³txi³su² a³li³nũ²la² wxã³ha²kxai³ Ju³te²a²ko³xan¹tũ̱³ka̱³txa² wxã³ha²kxai³ Jor³tãu²yau³xa² a²ha³lo²khai³xa² a²yxo²ha³kxa¹ wxã³sxã³ tĩ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A²nxe³tũ̱³ka̱³txai²na² sa²kxai³lu¹ a²ko̱³nxe³ti³ kãi³ain¹ju³ta² Sũ̱³na² ĩ³hen³txain¹sãn²nũ²la² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nyhu¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² sa²kxai³lu¹ ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² Txa²wã¹sũ̱³na² hxi²ki³kxai³lu² ã³wa²su¹jau³su² yxo²ĩ²ah³lxi³ta¹hxai²hẽ¹la². Yxo²ĩ²ah³lxi³ha²kxai³ ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nyhu¹ah³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nxe³tãu³ãn²tu̱³ fa³ri³se²a² nũ̱³ka̱³txa² wxã³ha²kxai³ sa³tu³se²a² nũ̱³ka̱³txa² wxã³ha²kxai³ ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nyhu¹te³lhxã³ wxã³ain¹tãu³a¹ Jo³ãu² Ba³tis²jah³la² e³te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Txa²wã¹sũ̱³nai²li² a̱n³txi¹nx2ti³na³li¹. Nxe³sxã³ wxa²ẽ¹nãn¹jau³su² nxe³te³nah¹lxi¹: “Ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹sain¹kxai²nãn²tu̱³ wi¹lhin¹yex1sain¹tũ¹xã¹, a²nũ²a² a²yxo²ha³kxa²su¹.” Nxe³nyhah¹lxin¹kxan²ti³ ti³he¹nxe²nxa³wi¹. Nxe³sxã³ wi¹lhin¹ki³lxo³yah³lxin¹kxan²ti³ Txa²wã¹sũ̱³nai²li² ĩ³ki²ha¹kxi²yah³lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ya²la³tu̱³ wxa²ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ã³sxã³ ĩ³ãin²ta³kxi²nha²si¹nx2ti³kxai²nãn²tu̱³ wain³txi³ kãi³sxã³ yxau²xai³jah¹lxi³hẽ¹li¹. Hi³a²ne³kxai²na² wi¹lye²kxai²nãn²tu̱³ a²nxã̱³kxai²na² wi¹nũn³te²ju²hẽ³li¹. Te²yã¹nxe³jah³lxi³nũ³nhẽ¹li¹. Wi¹tẽ³kxai²na² wi¹lxa³nxã̱³kxi²kxa²yã¹nxa² wi¹kãi³sxã³ yxau²xai³jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nxe³yãn¹ta¹ wãn³txi³la³ ĩ³wa²lũ³xi²sah³lxin¹jau³la³ nxe² e³kxi²sah¹lxi³txa³hẽ¹li¹. Sah²lxan³te³nah¹lxi¹: “A³bra³ãu²ah³lu¹tai²na² a²ne³tah²nãu³su² ki̱³tã³li¹. Nxe³ki̱³ju³tan¹te²kxa³ya̱³lhu² wi¹lhxã³ ĩ²nẽ³tu¹wi¹.” Nxe² ĩ³ye³kxi²syah¹lxi³txa³hẽ¹li¹. Nxe³sxã³ A³bra³ãu²ah³lu¹tai²na² wxa²sũ̱³nu²khai³su² kxan²ti³ Txa²wã¹sũ̱³na² hxi²kan¹khaix1jah¹lai²la¹wi¹. Ten³kxai²nãn²tu̱³ kwa²txah³la³kai²na² tẽ³sxã³ A³bra³ãu²ah³lu¹tai²na² a²ne³tah²nãu³a² ka³te̱³na² wet1si¹jau³su² hxi²ka¹nhĩ̱³nx2na³li¹, Txa²wã¹sũ̱³na²su¹. Nxe³kxai²nãn²tu̱³ A³bra³ãu²ah³lu¹tai²na² wẽ³ha³lxi³su² ti³hi¹tai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jã¹nxe³jut3su² hi³a²ne³kxai²na² ĩ²li³te²la³ wi¹nã̱³kxi²nxa³kxai²nãn²tu̱³ a²nũ²a² hxi²ka² ĩ³tau³ka²tã³sãn²nũ²la² ha³nxe²a² yat3sxã³ hxa³te²ju²hẽ³li¹. Nxe³te³lhxã³ kxa²yã¹nxe² wi¹kãi³sxã³ yxau²xai³yah²lxan³kxai²nãn²tu̱³ ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nxe³nũ²la² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹tũ̱³ka̱³txai²na² ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Jã¹nxa¹jut3su² txai²na² sa²kxai³lu² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nxa²lxin¹ju³ta³nũ³a² hxi²ka¹nhĩ̱³na¹wi¹. Wxa²ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ã³sxã³ ĩ³ãin²ta³kxi²nha²si¹nx2ti³sãn²ka³tu̱³ ũ³hũ¹kxi²sa²sai¹nxa²lxin¹ju³ta² hxi²ka¹nhĩ̱³na¹i¹. Nxe³nx2ta¹kxa²ha³ta̱³nxãn²tu̱³ txa²si³yo³na² a²nũ²a² hxi²kan¹txi³ wa³to²hi²sa²jah¹la² wxã³tu¹wi¹. Wxã³te³na¹ hxi²kan¹txi³ wa³to²hi²sa³ha²kxai³ a²yu³kxa² yu³wi²kxi²nha²ka³lo³a² tẽ³sxã³ ã³nhit1sxã³ ã³si³tẽ³kxi²na¹kxe³su² hxi²ka¹nhĩ̱²nxa³nha²wi¹. A²nxe³jah¹lai²na² sa²kxai³lu² Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² ũ³hũ¹nx2ti³ha²kxai³ wxa²ẽ¹nãu³ai²na² ã³nhxan³ka²ti³nx2ti³ha²kxai³ nxe³jah¹lo²su²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jã¹nxe³kxe³hũ̱³nxe² hai³sxa² wa³kxẽn³yah³lai²na² hai³sxa² wi¹wen¹ha²kxai³ a̱n³sxã³ yain³ta³ki³a² wxa²so¹te²ju²hẽ³li¹. Wxa²so¹kxai²nãn²tu̱³ wã³na̱³la³ka³lo³a² hxi²tẽ³nha²sxã³ yain³txa³ki³a² ĩ³ya³lan³kxi²xai³te²ju²hẽ³li¹. Ĩ³ya³lan³kxi²nũ²la² yain³txa³ki³a² a²wi¹ki³a² so¹sxã³ ũ³wha¹ha²kxai³ a²ka³lo³a² ã³na¹sxã³ ũ³thũ²kxa² sa²hẽt1sa²kxai³ nxe³ki̱³te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³sxã³ a²nũ²a² wi¹lhin¹te²nãu³xa² oh³nãu³nũ¹ka³nãn¹ko³xa² ũh³wxe³ũh¹hai¹nha²kxai³ a²nũ²a² ĩ³lxa³thi¹nxa³te²a² yuh³nãu³nãn¹ko³xa² ha³lo²a² i³sa²tẽ³ko³xa² ã³na¹kxai¹nha²kxai³ nxẽn³tain¹tu¹wi¹. Jo³ãu² Ba³tis²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nxe³nxa²ha¹te¹ nxe³nũ²la² Je³su²jah³la² Ka³li³le²a²ko³xa² a³li³nũ²la² wxa²kan³sxã³ wxã³nũ²la² Jor³tãu²yau³xan¹ko³xa² ã³nxai³ta¹hxai²hẽ¹la². Jo³ãu² Ba³tis²jah³la² ĩ³ha¹txi²te³lhxã³ ã³nxai³ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³ha¹txi²te³na¹ Jo³ãu² Ba³tis²jah³la² hxi²ka² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹si¹jau³su² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yxãn¹ta¹ ũ³hũ¹kxi²sa²sai¹nyhu¹xa³ta̱³lxa¹ Jo³ãu² Ba³tis²jah³lai²na² wãn³txi³kxai³lu¹: — Wxãi²li² ko̱³nxe³ti³ kãi³jah¹lo²sxa³lxi¹. Ũ³hũ¹kxi²sa²sai¹nxa²ha¹ju³ta² wai³nxa³wi¹. Ũ³hũ¹kxi²sa²sai¹san¹ju³ta² wai³nhĩ̱³nx2na³li¹. Nxe³kxan²ti³ txa²hxi²ka² ũ³hũ¹kxi²sa²sai¹si¹nxa²ha¹jau³nũ³su² wxã³san¹kxai²nãn²tu̱³ti¹. Jo³ãu² Ba³tis²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Nxe²nxa³wi¹. Txa²wã¹sũ̱³na² wãn³txa² wain³txi³ sa²yxo²we¹te³la¹wi¹. Nxe³ta¹hxai²hẽ¹la². Nxe² e³kxi²ta³lun²nyhu¹nũ²la² Jo³ãu² Ba³tis²jah³la² hxi²ka² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nxe³nxa²ha¹te¹ ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nyha¹nhũ²la² Je³su²jah³lai²na² ĩ̱³yau³xa² wxa²li³ta¹hxai²hẽ¹la². Nxe³te³na¹ oh³sĩ̱³na² sa²yxo²hai¹ta¹hxai²hẽ¹la². Sa²yxo²hai¹ka³tu̱³ kwa³sxa³xa² hũ̱³nxe² Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² oh³nãu³a² a³ka³nxi²xi²ye²ka³tu̱³ Je³su²jah³lai²na² ãn³ka³la³kxi³we̱³kxi²yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ã³ka³la³kxi³we̱³kxi²yain¹sxã³ oh³nãu³an¹te²a² wãn³txa² ain³kxain¹ta¹hxai²hẽ¹la². Ain³kxain¹te³nah¹lxi¹: — Jah¹lai²na² Txa²ki³lha³lxa²khai³xai²la¹wi¹. A³lxi²na¹kxah³lai²la¹wi¹. Wi¹lxo³kxi²sain¹jah¹lai²la¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nxa²ha¹te¹ Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² hi²sen³su² Je³su²jah³la² ã³nũ²kxi²xai³sxã³ ha³lo²ai²na² a²nũ²a² yxau³nũ¹xa³ko³xa² ã³sa²so¹si¹ta¹hxai²hẽ¹la². Nxe³tãu³a² Txa²wã¹sũ̱³na² a²ten³jau³su² sa²yxo²ã³ ĩ³wa³ka³nxe³sain³si¹jau³su² Sa³ta³na²jah¹la² hi²sen³su² ã³tĩ̱³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jã¹nxe³jut3su² Je³su²jah³lai²na² sa²kxai³lu² ye³ka³lxa¹txi³ a³lan²ta¹hxai²hẽ¹la². Hxi²ka² hxan³sxã³ wxa²sa²wa²la³kxi²sxã³ wxa²sa²wa²la³kxi²nũn³sxã³ te²yã¹nxe² wxa²sa²wa²la³kxi²nũn³sxã³ a³lan²ta¹hxai²hẽ¹la². 40 nxe² a³la²ni² 40 nxe² ka³nxa³hi² nxe³ta¹hxai²hẽ¹la². Nxe³tãu³a² yain³txa² kwa² ã³na¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ heh³lxi³ yxau³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nxe³nxa²ha¹te¹ Sa³ta³na²jah¹la² ã³tĩ̱³sxã³ e³kxi²ta¹hxai²hẽ¹la². E³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² Tah²su² nxĩ¹nha²kxai³ txah³lxa³kxai²na² e³kxi²txai¹nhẽ³li¹. Txah³lxa³kxa² tẽ³sxã³ yain³txi³nũ³xa² ĩ³yat1sxã³ wet1si¹jau³su² ĩ³ye³kxi¹sẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Kwa²nxi¹lxi¹. Txa²wã¹sũ̱³na² a²ten³jau³sxa³wi¹. Sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: “Yain³txi³khai³xa² so¹lxi³ yain³sxã³ yxau²xai³yah³lxi³txa³hẽ¹li¹. Txa²wã¹sũ̱³na² wãn³txa² a²yxo²sai¹jau³xai²na² hãi¹nxe³ti³jau³xa¹ wet1yxau²xai³jah¹lxi³hẽ¹li¹.” Nxe³ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nxa²ha¹te¹ nxe³nũ²la² Sa³ta³na²jah¹lai²na² hi²sen³su² ã³sa²so¹nũ²la² Je³ru³sa³lẽ²thĩ³na² wi¹lhin¹thĩ³nãu³a² ã³sa²so¹nũ²la² Sũ̱³na² sxi²ha² kĩ³khaix1thĩ³na² a²ne³ka³nah²nãu³a² ũh³wxe³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ũh³wxe³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² Tah²su² nxĩ¹nha²kxai³ yuh³ã³na¹nha¹txa²hẽ³li¹. Nxĩn¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² Si³yxau³ka³jah¹la² a²hxi²ki³kxai³lu² wi¹lhau³ko³txa²tu¹wi¹. Nxe³nĩn¹ju³ta²nũ³a² Sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² hi²sen³su² oh³xan¹ta² nũ̱³ka̱³txai²na² wi¹lhau³ko³txa²si¹hain¹jau³su² ĩ³ye³kxain¹na²hẽ³li¹. Nxe³sxã³ wi¹lhau³ko³txain¹kxai²nãn²tu̱³ a²hxi²ki³khai³xa² ã³sa²so¹nxain¹tu¹wi¹. Txah³lxa³kxi³su² ã³yu̱³kxĩh³ton³nxa²kxa²ya̱n³txi³su² nxe³nxa²ha¹wi¹.” Nxe³ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: — Kwa²nxi¹lxi¹. Sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1ta² yau³xã̱³xai²na² nxe³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² Si³yxau³jah¹la² Wxa²hxi²kan¹txa² Si³yxau³jah¹la² wi¹la³ ã³si³tẽ³kxi²ju³ta² ye²si¹jau³su² wã³nxĩn¹ju³ta² o²la³kxi²sain³txa³hẽ¹li¹.” Nxe³ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jã¹nxe³jut3su² Sa³ta³na²jah¹lai²na² hxi²ka² ã³sa²so¹nũ²la² wã³la² kĩ³khai¹nxe³ka³txa² ũh³we̱³kxi²ta¹hxai²hẽ¹la². Nxe³tãu³a² ha³lo²a² yuh³xan¹ta² ha³lo²a² a²yxo²ha³kxa¹ yuh³xan¹ta² nũ̱³ka̱³txi³nãu³xa² a²yxo²ha³kxa¹ wã²nã³ũ¹hain¹ta¹hxai²hẽ¹la². Wi¹khai¹nxe³ye²kxe³su² wã²nã³ũ¹hain¹ta¹hxai²hẽ¹la². Wã²nã³ũ¹hain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","— Ju¹tai²na² ha³lo²ai²na² hãi¹nxe³ju³ta² ũ³hũ¹nxa²ha¹tu¹wi¹. Wxãi²na² ã³ka³ti³we̱³sãn²sxã³ sa²nẽn¹kxi²san¹kxai²nãn²tu̱³ ũ³hũ¹nxa²ha¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txa² ĩ³wa²lũ³xi²ti³an¹jau³xa² kwa³na³te³nah¹lxi¹: — Sa³ta³na²jah¹lãi³. Ã³waix3txa²hẽ³li¹. Ten³nxa²hxa³nhai¹. Txa²wã¹sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² Si³yxau³jah¹lai²na² Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹lai²na² so¹lxi³ ã³ka³ti³wxe³sxã³ sa²nẽn¹kxi¹jah³lxi³hẽ¹li¹. Jah¹lai²na² so¹lxi³ sa²yxo²wet1sxã³ yau²xai³jah¹lxi³hẽ¹li¹.” Nxe³ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nxa²ha¹te¹ nxe² e³kxi²ta³lun²nũ²la² Sa³ta³na²jah¹la² ã³waix3sxã³ a³li³ta¹hxai²hẽ¹la². Ã³waix3sxã³ a³li³nũ²la² oh³xan¹ta² nũ̱³ka̱³txa² wxa²kan³sxã³ wxã³nũ²la² Je³su²jah³lo²kxai³ yain³txa² ũ³hũ² ĩ³nxũ²kwa̱i³lxũ¹ni² nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nxa²ha¹te¹ hã²wxãn³txa³ Jo³ãu² Ba³tis²jah³la² sxi²ha² kan²thĩ³na² ũ³tĩ̱¹kxi²wxe³ain¹jau³su² ha³ta̱³nxe³ta¹hxai²hẽ¹la². A²nxe³jau³xai²na² Je³su²jah³la² ain³kxi²sãn²nũ²la² Na³sa³re²thĩ³na² Ka³li³le²a² ko³xan¹thĩ³na² ai³lhxã³ ã³wih¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nxe³sxã³ Na³sa³re²thĩ³na² yxau²xai³hxai²na²hẽ³ nxe³thĩ³na² a³li³nũ²la² Ka³far³na³ũ²thĩ³na² ã³ya²kxi²sa²tẽ³ta¹hxai²hẽ¹la². Ĩ̱³ye³na² kãin²je³na² u²lxan³thĩn³su² ta¹hxai²hẽ¹la². A²nxe³ko³xai²na² a²ĩ³lxa² Se³bu³lo²na²ko³su² ha²kxai³ Naf3ta³li²ko³su² ha²kxai³ nxe³ta¹hxai²ti³ai¹ti²tu³wa². ");
INSERT INTO nabNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nxe² ã³ya³kxi²sxã³ yxau²xai³kxe³su² I³sa³i²ah³lu¹tai²na² wãn³txa² Sũ̱³na² ĩ³hen³txi³jau³xau³hxai²tẽx1tã² e³ta¹hxai²hẽ¹la². E³te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","— Se³bu³lo²na³ko³xa² Naf3ta³li²ko³nãu³a² ĩ̱³ye³na² kãin²je³na² a²wa̱³kan¹ko³nãu³a² yxãn¹ta¹ Jor³tãu²yau³xa² a²ha² ya¹nãn¹ko³nãu³a² Ka³li³le²a²ko³xa² nxe³te²nũ̱³ka̱³txe²nãu³xa² Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³xai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A²nxe³te²nãu³xa² wãn³txa² wi¹jau³xa² yũ²na³li¹. Ka³nxah³ju³ta² yxau²xai³tũ̱³ka̱³txi³sin²ta²wi¹. A²nxe³te²nãu³xa² ha³lo²a² ha³te¹khai¹nxe³ju³ta² ĩ³ain¹na²hẽ³li¹. Te²yã¹nxe³sxã³ a²nũ²a²nãu³xa² ya³lu²te²hũ̱³nxe² yxau²xai³te²nãu³xa² ha³lo²a² ka³nxah³khai¹nxe³ju³ta² nxe³tũ̱¹ka̱³txai²na² sa²kxai³lu² ha³lo²a² sa²kxĩ̱³kxi²su² ĩ²ain¹na²hẽ³li¹. A²ẽ¹nãu³ai²na² ya³lu²ju³ta² so¹lxi³ yũ³na²hẽ³li¹. Nxe³yãn¹ta¹ hĩ¹na² ka³tẽ³na² wi¹tãu³a² yũ³ain¹na³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jã¹nxe³sxã³ Je³su²jah³lai²na² yxau²xai³ka³tu̱³ wãn³txa² wi¹jau³xa² ĩ³hen³txi³ ã³si³wxe³ta¹hxai²hẽ¹la². Ĩ³hen³txi³te³nah¹lxi¹: — Wxa²ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ã³sxã³ ã³nxa³wã²na¹jah¹lxi³hẽ¹li¹. Ã³sxã³ ĩ³ãin²ta³kxi²nha¹jah³lxi³hẽ¹li¹. Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³a²wxã³ti³wa̱³kxi³lxon³na³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nxa²ha¹te¹ hã²wxãn³txa³ Je³su²jah³la²kxai³lu² ĩ̱³ye³nai²na² Ka³li³le²a² ye³nai²na² a²yxo²ka³te̱h³tĩh³na² ã³nxai³ta¹hxai²hẽ¹la². Ã³nxai³nũ²la² in³txa² ha¹lin¹te²a² ĩ²ta¹hxai²hẽ¹la². Si³mãu²ah³la² Pe²jah³la² ĩ³yĩ¹li²nũn³jah¹lo²su² ha²kxai³ Ãn³tre²ah³lo²su² ha²kxai³ a²lon³ti³nyha¹ta¹hxai²hẽ¹la². A²nxe³ya³te²na² a̱i³na² ta³lã²la²ka³lo³a² ĩ̱³ye³na² ã³na¹i² sa²sai¹xi² nxe² o²la³kxi²ya³ta¹hxai²hẽ¹la². Ju¹tai²na² so¹lxi³ o²la³kxi²ya³te²ju²hẽ³la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jã¹nxe³sxã³ a²lon³ti³nãu³xa² ĩ²yah³nũ²la² ĩ³ye³kxi²te³nah¹lxi¹: — Nxex3jah³wxi¹. Ã³si³tẽ³sa¹hẽ¹li¹. A̱i³na² ã³na¹yah³to³hxain¹tai¹ti²tu³wi¹. Yxãn¹ta¹ ã³si³tẽ³sa¹hin¹kxai²nãn²tu̱³ a²nũ²a² ĩ³kaix1so¹ja³hin¹ju³ta² ĩ³yau¹ũ³nx2ta¹tu¹wi¹, ã³si³tẽ³kxi²sa²si¹hain¹jau³su¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nxe²e³ta³lun²nhĩ¹na¹ a²kwẽn¹tai²na¹ a̱i³na² ta³lã²la²ka³lo³a² ã³sxã³ ã³si³tẽ³kxi²ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nxe³ka³tu̱³ta¹ jũ¹nxa² yan¹nãu³a² ã³nxai³ain¹ka³tu̱³ta¹ Se³be³te²u²jah³la² a²ki³lha³nãu³xa² Jo³ãu²ah³la² Ti³a²kah³la² nxe³ya³sxã³ ka³no¹a² ka³lo³ẽ¹na² ã³wxe³ain¹ta¹hxai²hẽ¹la². Ã³wxe³sxã³ a̱i³na² ta³lã²la²ka³lo³a² sa²ka³tũ¹sxã³ sa²hau³ko³tain¹je²ta¹hxai²hẽ¹la². Nxe³te³na¹ a²kwẽn¹tai²na¹ Je³su²jah³lo²kxai³lu² ĩ³kaix1tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ĩ³kaix1te³na¹ Jo³ãu²ah³la² Ti³a²kah³la² nxe³ya³sxã³ a²wĩ³na² ã³waix3ti² ka³no¹a² ka³lo³a² ã³i² nxe³yah³nũ²la² Je³su²jah³la² hi¹txai³lya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nxa²ha¹te¹ hã²wxãn³txa³ Ka³li³le²a²ko³nãu³a² Je³su²jah³la² ai³lha²thet3ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ta¹ Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³nãu³xa² ã³wih¹xai³lha²thet3sxã³ wãn³txa² wi¹jau³xa² ĩ³hen³txi³ha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³a² nxe³jau³xa² ĩ³yau¹ũ³ha²kxai³ nxe³ta¹hxai²hẽ¹la². Nxe³kxa²yu³su² a²nũ²a² ĩ²li³te²na¹ ĩ³ta³ka³txa² ĩ³ton³ta̱³nxa² kwa²ha̱i²ha̱in²ta̱³nxa² nxe³te²na² ã³tĩ̱³kxai²nãn²tu̱³ nxe³te²na² whãi²na¹ wi¹we²txi²ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nxe³te²kxa³ya̱³lhu² Je³su²jah³la² a²ha³ta̱³nxa² u²lxi³ ã³na¹ha²kxai³ ai³lhxã³ Si²ri³a³ko³nãn¹tũ̱³ka̱³txa² ain³kxain¹ta¹hxai²hẽ¹la². Ain³kxain¹nũ²la² ĩ³ta³ka³txa² ĩ²li³ka³txa² ĩ³ton³te²a² yũ³kxai²nãn²tu̱³ ã³sa²so¹ha²kxai³ ĩh³nha²ju³ta² yũ³te²a² ã³sa²so¹ha²kxai³ a²nũ²ai²na² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³yxau³jah¹lo²su² te²na² ã³sa²so¹ha²kxai³ ã³tau³txẽ³kat3sũ̱³ka³ta² yũ³te²su² te²na² ã³sa²so¹ha²kxai³ a²nũ²ai²na² nũ³kan²ta³kxi²te²na² ã³sa²so¹ha²kxai³ a²nũ²a² wi¹lain³ta³kxi²te²nãu³xa² nxe³yain¹ta¹hxai²hẽ¹la². Nxe³sxã³ Je³su²jah³la² hi²sen³su² tũ̱¹ka̱³txai²na² a²yxo²ha³kxa¹ we²txin²tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jã¹nxe³te²kxa²ya̱n³tu̱³ a²nũ²a² ka³lxa²khai¹nxe³te²nãu³xa² Ka³li³le²a²ko³xan¹te²nãu³xã² Te³ka²po³li²ko³xan¹te²nãu³xã² Je³ru³sa³lẽ²thĩ³nãn¹te²nãu³xã² Ju³te²a²ko³xan¹te²nãu³xã² ha³lo²ai²na² Jor³tãu²yau³xa² ha³tih³xan¹ko³nãn¹te²nãu³xã² nxain¹sxã³ Je³su²jah³lo²kxai³ ã³si³tẽ³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ã³si³tẽ³kxain¹tũ̱³ka̱³txa² Je³su²jah³la² ĩ²kxain¹nũ²la² wã³la³ka³txa² wxa²ka³la³ta¹hxai²hẽ¹la². Wxa²ka³la³ka³tu̱³ ã³wxe³ta¹hxai²hẽ¹la². Ã³wxe³nũ²la² a²sa³wi¹ha³lxa² ya̱u³son³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ya̱u³son³kxain¹nũ²la² Je³su²jah³la² a²yxo²wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². Ĩ³yau¹ũ³hain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","A²nũ²a² ĩ²li³te²na² a²ẽ¹nãn¹jau³kxai³lu¹: — “Txa²ẽ¹nãu³ai²na² a̱u³txi³ hxi²ka¹nha¹ju³ta² yũ³ti³hex1sa²nxa³nha¹. Txa²wã¹sũ̱³na² so¹lxi³ hxi²nũn¹sa²jah¹lai²la¹wi¹.” Nxe³yah³lxin¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Kxãn³nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³a² yxau²xai³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hĩ¹nai²na² ãin²ti³sxã³ nã̱n³ta² ha³lo²ai²na² hin¹yah³lxin¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Kxãn³nãu³a¹ ĩ³nxũ²kwa̱i³lxũ¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hĩ¹nai²na² Txa²wã¹sũ̱³na² yen³nãu³a² thãi³ti³la² yxau²xai³yah³lxin¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Kxãn³nãu³a¹ Txa²wã¹sũ̱³na² wãn³txa² ĩ³ye³kxi¹nx2ti³jau³xai³tã² hãi¹nxe³ti³xa¹ sa²hau³ko³tũh¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","A²nũ²a² he³ja³lu²te²nãn²tu̱³ yain³txa² yxo²kwa̱in³te²ju²hẽ³li¹. Ya̱³lxu²khaix1te²nãn²tu̱³ ĩ̱³yau³xa² yxo²kwa̱in³te²ju²hẽ³li¹. Nxe³tũ̱³ka̱³txai²li² yã¹nxe² Txa²wã¹sũ̱³na² wain³txi³ kãi³ju³ta³nũ³a² ten³sxã³ kãi³yah³lxin¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Kxã³nãu³a¹ a²nũ²a² yain³ta³lun²te²na² ũ³kxi²kxa² yã¹nxe³sxã³ ha³lo²a²nũ³a² ã̱³xa² ten³yah²lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","A²nũ²a² ã̱³xai²na² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³jah³lxin¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Kxã³nãu³a¹ Txa²wã¹sũ̱³na² hxi²ki³kxai³lu² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³txa²txi³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hĩ¹nai²na² wxa²ẽ¹nãu³ai²na² wi¹ju³ta² so¹lxi³ yũ³yah³lxin¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Txa²wã¹sũ̱³na² yã¹nxe² yxau²xai³yah³lxi¹nha²kxai³ kxãn³nãu³a¹ Txa²wã¹sũ̱³nain²txi³ ye³ĩ²yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hĩ¹nai²na² a²nũ²a² ã³nhãu²no³nyhu¹kxi³ju³ta² o²la³kxi²yah³lxin¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Kxãn³nãu³a¹ Txa²wã¹sũ̱³na² te²hi²sen³su² a²ki³lha³lhxu² ti³hi¹txa²lxi³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hĩ¹nai²na² wain³ju³ta² so¹lxi³ kãi³yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² khãuh³lxa³thin¹nx2tain¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Kxã³nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹txa² Si³yxau³tãu³lot3ju³ta³nũ³a² yxau²xai³lyah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Hĩ¹nai²na² Txa²wãn³txa² sa²yxo²we¹jah³lxi¹lxi¹. Yxah³lxin¹ju³tan¹te²kxa³ya̱³lhu² a²nũ²ai²na² Sũ̱³na² wãn³txa² sa²yxo²ã³te²su² te²a² ko̱³nxe³ti³ e³kxi²nx2ti³ta̱³nxa² khãuh³lxa³ti³nx2ti³ta̱³nxa² ki³han³jau³su² e³kxi²nũ¹nx2ti³ta̱³nxa² nxe³nx2ti³kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kãin² ka³lih³sxã³ wi¹lxon³kxi¹jah³lxi³hẽ¹li¹. Kxãn³nãu³a¹ Txa²wã¹sũ̱³na² ha³lo²ai²na² oh³nãn¹ko³nãu³a¹ ũ³yho³hi¹nx2ti³ju³ta³nũ³a² wi¹ju³ta² yũ³nx2ti³tu¹wi¹. Jã¹nxe³sxã³ ko̱³nxe³ti³ kãi³nx2ti³kxa²yã¹nxe² kxã³nhxĩ¹nu¹tai²na² wxa²ne³hẽ³tu¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² khãuh³lxa³tain¹nũn³ta¹hxai²hẽ¹li¹, Sũ̱³na² wãn³txa² sa²yxo²ã³ain¹te²nũ̱³ka̱³txa²su¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nxa²ha¹te¹ sa̱h²ne³ka² yã¹nxe³yah³lxi¹lxi¹. Sa̱h²ne³kai²na² a²nũ²a² hxi²ka² tẽ³sxã³ yain³txa² ũ³sa²wi²ki̱³kxai²nãn²tu̱³ wi¹yain³kxi²ki̱³te²ju²hẽ³li¹. Yxãn¹ta¹ sa̱h²ne³kxai²li² a²kxah²ju³ta² sũ¹nxe³kxi²kxai²nãn²tu̱³ hai³txi³ ten³ki̱³te²sxa³yu²hẽ³li¹. Ki̱³sxa²kxai³ kwa² ka³la²ko³ki̱³te²ju²hẽ³li¹. Nxe³te²hũ̱³yah³lxi¹lxi¹. Wi¹kãi³sxã³ yxau²xai³yah³lxin¹ju³tai²li² a²nũ²a² e³lxah²lxi³xa³kxai²nãn²tũ³ kwa² ha²ya̱³kxa³lxi³sah¹lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Te²yã¹nxe³jut3su² Txa²wã¹ha³lo²ai²na² a²ha²tet1jut3sũ̱³yah³lxi³tũ̱³ka̱³txi³syah¹lxi¹lxi¹. Wã³la³ka³txa² a²ne³ka³nah²nãu³a² sxi²je³na² we¹ki̱³kxai²nãn²tu̱³ hãi³i² yxau³hĩ̱³nx2nxa³wi¹. A²nũ²a² a²yxo²ha³kxa¹ e³lxah¹ ĩ²ain¹tu¹wi¹. Te²yã¹yxah³lxi¹lxi¹. Wi¹kãi³sxã³ yxau²xai³yah³lxin¹ju³tai²li² a²nũ²a² e³lxah²lxi³kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txa² e³lxah²lxi³ ĩ²ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jã¹nxe³sxã³ lã³pi³ãu²tẽ³na² hxi²tẽ³ki̱³kxai²nãn²tu̱³ hai³txi³ kwa³ta³lẽ³na² ũ³tĩ¹kxi²ki̱³te²sxa³yu²hẽ³li¹. Hãi¹nxe³sxã³ ha³lo²a² ko¹kon¹ju³ta² ũh³wxe³ki̱³te²ju²hẽ³li¹. Nxe³ki̱³kxai²nãn²tu̱³ txa²wã¹sxi²ha² whãi²na¹ wi¹ko¹ko²tũh¹lxi²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Te²yã¹nxe³jut3su² lã³pi³ãu²tẽ³na² sa²kĩ̱³ki̱³kxai²nãn²tu̱³ ha³lo²a² wi¹lha²tet1te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe² kãi³yah³lxin¹ju³tai²na² a²nũ²a² a²yxo²ha³kxa¹ e³lxah²lxi²na³li¹. Nxe³ha²kxai³ wi¹kãi³yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² oh³nãn¹ko³xai²na² yxau³jah¹lai²na² sa²nẽn¹kxain¹tu¹wi¹. Nxe³ju³ta² kãi³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nxa²ha¹te¹ wxa²ẽ¹nãn¹jau³su² nxe³yah³lxin¹te³nah¹lxi¹: “Txa²wã¹sũ̱³na² wãn³txu¹tai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txai²na² wãn³txu¹tai²na² nxe³jau³xai²na² whãi²na¹ ã³na¹si¹jau³su² Je³su²jah³la² a²ten³jau³su² na³xã¹.” Nxe³yah³lxin¹jau³tu̱³ nxe³yah³lxi³txa³hẽ¹li¹. Wai³nxa³wi¹. Nxe³to³ta¹ Txa²wã¹sũ̱³na² wãn³txu¹txai²na² hãi¹nxe³ti³xa¹ sa²yxo²wet1sxã³ kãi³jah¹lo²sa¹wi¹. Nxe³ye¹nxa²lxa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Txa²wã¹ha³lo²ai²na² oh³nãn¹ko³nãu³a² yuh³nãn¹ko³nãu³a² nxe³sxã³ wa³su³txi³ tĩ¹hxan³kxi²nẽ³lxa³lho³li¹. Nxẽn²nxa³tãu³a² Txa²wã¹sũ̱³na² wãn³txu¹tai²na² tĩ¹hxan³kxi²nẽ³lxa³lho³li¹. Wãn³txai²na² yxau³ka³na³ka³na³kxan²ti³ yau³jũ¹lxi³jau³su² kxan²ti³ hai³txi³ tĩ¹hxan³kxi²nẽ³lxa³lho³li¹. Jã¹nxe³jau³xu¹tai²na² jau³xau³hxai²tẽx1ta² we¹ta³lun²sãn²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jã¹nxe³ha²kxai³ a²nũ²a² ĩ²li³te²la³ wãn³txai²na² e³kxi²te³nah¹lxi¹: “Sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1ta² ten³sa²nxa³nhai¹. Ã³na¹hxa³ta¹tũ¹xã¹. A²nũ²a² ã̱³xa² jau³jau¹xai²na² ã³na¹hxa³si¹hain¹jau³su² ĩ³yau¹ũ³ai¹na¹tũ¹xã¹.” Nxe³jau³xai²na² a²nũ²a² nxe²e³kxi²ke³la³te²kxai³ kxã³nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹txa² Si³yxau³tãu³lot3ju³ta³nũ³a² yũ³hĩ¹na¹ jah¹lai²li² hai³txi³ ĩ³sa²nẽn¹kxi²ju³ta² yũ²nxa³lho³li¹. Nxe³yãn¹ta¹ Sũ̱³na² wãn³txa² whãi²na¹ ĩ³yau¹ũ¹hxa³ti² sa²yxo²we¹ti² nxe³kxai²nãn²tu̱³ hã²wxãn³txa³ Sũ̱³na² A²hxi²kan¹txa² Si³yxau³tãu³lot3ju³ta³nũ³a² yũ³hĩ¹na¹ kãin² ĩ³sa²nẽn¹kxi²ju³ta² yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nxe³jah³lxi³sa²lxi¹. E³kxi¹nx2ta¹wi¹. Ha³te̱h³nxã³nxa² a²hoh³lxi³su² nũ̱³ka̱³txa² fa³ri³se²a² nũ̱³ka̱³txa² nxain¹sxã³ Txa²wã¹sũ̱³na² a²ten³jau³su² sa²yxo²we¹tai¹nxa³wi¹. Nai¹nxa³ha²kxai³ wxãi²na² sa²kxai³lu² wa³to²hi² wi¹la³ wet1jah²lxan³kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² A²hxi²kan¹txa² Si³yxau³tãu³lot3ju³ta³nũ³a² yũ³nx2ti³xa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nxe³nxa²ha¹te¹ txa²wã¹yah³la²nãu³xa² ain³kxain¹jau³xu¹tai²na² nxe³te³nah¹lxi¹: “A²nũ²a² ã̱³xa² ĩ³sun²tã¹ki̱³ju³ta² wai³nxa³wi¹. Ĩ³sun²tã¹ain¹yah³lxin¹kxai²nãn³tu̱³ wxa²hxi²kan¹txi³nãu³xai²na² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³sxã³ ĩ³sun²tã¹nx2ti³ha³tai¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nxe³yãn¹ta¹ Txa²wãn³txa² e³kxi¹nx2ta¹jau³xai²na² nxe³nx2ta¹te³nah¹lxi¹: “Wxa²lo³nai²na² ĩ³a̱n³ta³kxi²nĩn¹kxai²nãn²tu̱³ wxa²hxi²kan¹txi³nãu³xai²na² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³sxã³ ĩ³sun²tã¹nx2ti³ha³tai¹.” Te²yã¹nxe³sxã³ wxa²lo³nai²na² nxe²e³kxi²yah³lxin¹te³nah¹lxi¹: “Ra²ka²jah¹lo²si¹lxi¹. Ĩ³lxi³thi¹nxa³jah¹lo²si¹lxi¹.” Nxe³yah³lxin¹kxai²nãn²tu̱³ Si³ne²tri³o²tũ̱³ka̱³txai²na² Ju³te²a² a²hxi²kan¹ti³nũ̱³ka̱³txai²nãn²ta² hxi²ka² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³sxã³ ĩ³sun²tã¹nx2ti³ha³tai¹. Te²yã¹nxũn³sxã³ nxe² e³kxah²lxin¹te³nah¹lxi¹: “A²hoh³lxi³su² yũ³nxãn²nxa³i¹.” Nxe² e³kxah¹lxin¹kxai²nãn²tu̱³ ha³lo²a² ko̱³nxe³khaix1ju³ta² ha³nxe² ĩ̱³sa²tẽ³ju³tai²na² yxau³yah³lxin¹ju³ta³nũ³a² yũ³yah³lxi¹nha³tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nxe³ha²kxai³ Txa²wã¹sũ̱³na² sxi²ha² ai³sxã³ ã³wih¹yah³lxin¹kxai²nãn²tu̱³: “Txa²wã¹sũ̱³nai²na² yen³kxa² ũ³hũ¹ai¹na¹tũ¹xã¹.” Yah³lxin¹kxai²nãn²tu̱³ ĩ²sxã³ ĩ³sa²wa²lho¹xi²nha¹jah³lxi³sã²nhẽ³li¹. Yah³lxin¹kxai²nãn²tu̱³ wxa²wã³tã̱³xai²na² hit3txã²ti³kxe³su² ĩ³sa²wa²lho¹xi²yah³lxin¹kxai²nãn²tu̱³ hãi¹nxã¹jah¹lxi³sã²nhẽ³li¹. Yen³kxai²na² Sũ̱³na² ũ³hũ¹ain¹yah³lxin¹ju³ta³nũ³ai²na² hãi¹nxã¹jah¹lxi³sã²nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Nxe³yah³lxi³sã²nĩn¹ka³tu̱³ wxa²wã³tã̱³xai²li² hãu²non³si¹jau³su² e³kxi²nyha¹jah³lxi³hẽ¹li¹. Nxe²na³na¹ hã²wxãn³txa³nu² yen³kxin³txi² tẽ³xi²ka³tu̱³ Sũ̱³na² ũ³hũ¹tain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wa³su³txi³ hãu²not3nyha¹jah³lxi³hẽ¹li¹. Yxãn¹ta¹ nyhah¹lxan³kxai²nãn²tu̱³ wxa²wã³tã̱³xai²li² tẽ³nxa²lxi³sxã³ hxi²kan¹ta² si³yxau³jah¹la² ã³sa²so¹nx2ti³ha³ta²wi¹. Ã³sa²so¹nx2ti³kxai²nãn²tu̱³ po³li²sa²jah¹la² sa²nũ¹nx2ti³ha³ta²wi¹. Sa²nũ¹nx2ti³kxai²nãn²tu̱³ sxi²ha² kan²thĩ³na² ũ³tĩ¹kxi¹nx2ti³ha³ta²wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nxe³nx2ti³kxai²nãn²tu̱³ ya²la³tu̱³ wa³su³txi³ ã³wa²su¹kxi¹nx2ti³xa³lho³li¹. Yen³kxa² ũ³yho³hi²ta³lun²yah³lxi³sã²nĩn¹ka³tu̱³ hã²wxãn³txa³ ã³wa²su¹kxi¹nx2ti³ju³ta³nũ³a² yũ³hĩ̱³nx2na³li¹. Nxe³ju³ta² yã¹nxe³sxã³ Txa²wã¹sũ̱³na² ã³wa²su¹si¹nx2ti²jau³su² ĩ³ye³kxah²lxan³kxai²nãn²tu̱³ ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³ha³tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Txa²wã¹sũ̱³na² wãn³txa² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: “Txu¹ha² ã̱³xai²na² ũ³whĩn¹ta³kxi²nyhu¹ah³lxi³txa³hẽ¹li¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nxe³yãn¹ta¹ e³kxi¹nx2ta¹tu¹wi¹. Txu¹ha² ã̱³xai²na² ĩ²yah³lxin¹kxai²nãn²tu̱³ wxa²ẽ¹nãu³ai²na² e³yah³lxin¹jau³su² nxe³te³nah¹lxi¹: “Txu¹hai²li² ũ³whĩn¹ti³sah²lxun¹nãn³kũ².” Nxe³yah³lxin¹kxai²nãn²tu̱³ wxa²ẽ¹nãu³ai²na² ya²la³tu̱³ txu¹hai²na² ũ³whĩn¹ta³kxi²nyah¹lxin¹kxa² yã¹nxe² hxi²ki³te²li³ yah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jã¹nxe³te²kxa²ya̱³tu̱³ wxa²ye³ki³ki³a² ye³wi¹tãu³a² ko̱³nxe³ti³ kãi³si¹nyhah¹lxin¹kxai²nãn²tu̱³ wxa²ye³sai¹nha²sxã³ u²lxã³na¹jah³lxi³hẽ¹li¹. A²nxe³ju³tai²na² ye³ki³ka³na³ka³na³ki³a² ã³na¹sxã³ ã³ye³ki³kho³nhãn³kxai²nãn²tu̱³ jũ¹nxe² ãin²ta³lxi³nha²hĩ̱³ki̱³tã³li¹. Yxãn¹ta¹ txa²wã¹nũ²a² whãi²na¹ ha³lo²a² ko³xai²na² ha³nxe²a² i̱³sa²tẽ³ko³xa² ã³na¹nẽ³tain¹kxai²nãn²tu̱³ kãin² ãin²ta³lxi³nha²hĩ̱³ki̱³tã³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te²yã¹nxe³jut3su² wxa²hxi²kai²na² hxi²wi¹tãu³a² hxi²kai²na² ko̱³nxe³ti³ hxi²kãi³nyhah¹lxin¹kxai²nãn²tu̱³ ĩ³hxi²ki²lho¹nha²sxã³ u²lxã³na¹jah³lxi³hẽ¹li¹. A²nxe³ju³tai²na² hxi²ka² ka³na³ka³na³te²a² ã³na¹sxã³ ã³nhxi²kho³nyhah¹lxin¹kxai²nãn²tu̱³ jũ¹nxe² ãin²ta³lxi³nyhah¹lxi³hĩ̱³nxa¹lxi¹. Yxãn¹ta¹ txa²wã¹nũ²a² whãi²na¹ ha³lo²a² ko³xai²na² ha³nxe²a² i³sa²tẽ³ko³xa² ã³na¹nẽ³tain¹kxai²nãn²tu̱³ kãin² ãin²ta³lxi³nha²hĩ̱³ki̱³tã³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Txa²wã¹yah³la²nãu³xu¹tai²na² wãn³txa² nxe³te³nah¹lxi¹: “A²nũ²ai²na² a²ẽ¹nãn¹jau³kxai³lu¹ nxe³te³nah¹lxi¹: ‘Txu¹sa²khai³ta¹ka³lxa² ã³na¹a¹tũ¹xã¹.’ Nxe³kxai²nãn²tu̱³ ha³te̱h³nxã³nxa² tẽ³sxã³ a²ten³jau³su² ũ³wha²li¹jah³lxi³hẽ¹li¹. Nxe³txã³nxai²na² tẽ³sxã³ txu¹hai²na² ũ³hũ¹jah³lxi³sãn²sxã³ ã³wa²sut1sxã³ yxau³hĩ̱³nx2na³li¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nxe³yãn¹ta¹ Txa²wãn³txai²na² ĩ³yau¹ũ¹nx2ta¹jau³xa²sa¹: Txu¹hai²na² txu¹sa²khai³ta¹ka³lxa² in³txa² ã̱³xai²na² ũ³whĩn¹ti³nhãn²nxa³ta¹ka³lxa² nxe³ta¹ka³lxãin²txi³ tẽ³sxã³ ã³na¹kxai²nãn²tu̱³ hã²wxãn³txa³ in³txa² ã̱³xah³la² so¹nh³kxai²nãn²tu̱³ txu¹hai²na² te²ain²txi³ a²nũ²a² ã̱³xa² ũ³whĩn¹ti³nyhu¹kxa²yã¹nxe² hxi²ki³la³hĩ̱³nx2na³li¹. Ko̱³nxe³ti³ kãi³ju³tai²la¹wi¹. Te²yã¹nxũn³sxã³ in³txi³su² ĩ²li³jah¹lai²na² sa²kxai³lu² txu¹hai²li² ã³na¹kxi²ta¹ka³lxai²li² nxe³ta¹ka³lxãin²txi³ so¹nh³kxai²nãn²tu̱³ nxe³jah¹lai²na² txu¹ha² ã̱³xa² ũ³whĩn¹ti³nhyu¹kxa² yã¹nxe² hxi²ki³lon³jah¹lo²su² hĩ̱³nx2na³li¹. Ko̱³nxe³ti³ kãi³ju³tai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nxa²ha¹te¹ txa²wã¹yah³la²nãu³xu¹tai²na² yau³xã̱³xai²na² ain³kxain¹jau³xu¹tai²na² nxe³te³nah¹lxi¹: “Wxãi²na² e³in¹jau³su² nxĩn¹te³nah¹lxi¹: ‘Txa²wã¹sũ̱³nu²sa²na³li¹. Txa²wãn³txa² ya²la³lyau³xai²la¹wi¹.’ Nxĩn¹jau³su² nxĩn¹kxai²nãn²tu̱³ ya²la³tu̱³ wãn³txi³khai³xa² so¹lxi³ e³txa²hẽ³li¹. Yxãn¹ta¹ ki³han³jau³su² e³in¹kxai²nãn²tu̱³ e³in¹jau³nũ³a² nxe³txa³hẽ¹li¹. Nxe²nxa³te³nah¹lxi¹: ‘Txa²wã¹sũ̱³na² ã³ye³yxo²nũ¹sa²na³li¹. Ya²la³lyau³xai²la¹i¹.’ Nxẽn¹jau³su² nxe³txa³hẽ¹li¹.” Kxã³nhxĩ¹nai³tã¹jau³su² ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nxe³yãn¹ta¹ Txa²yxo²wãn³txa² e³a¹jau³xai²na² ã̱³lxi²jau³xai²la¹i¹. Nxe³na¹te³nah¹lxi¹: Wãn³txa² e³in¹jau³nũ³a² ã³ye³yxo²nũ¹nẽ³ju³ta³nũ³a² e³txa³hẽ¹li¹. Oh³nãn¹ko³xai²na² ã³ye³yxo²nũ¹nẽ³ju³ta³nũ³su² wai³nxa³wi¹. A²nxe³ko³xai²na² Txa²wã¹sũ̱³na² Si³yxau³jah¹lai²na² ã³wxe³ko³xai²la¹i¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yuh³nãn¹ko³xai²na² ã³ye³yxo²nũ¹nẽ³jau³nũ³su² wai³nxa³wi¹. Nxe³ko³xai²na² Sũ̱³na² yu³kxai²na² ti̱³yu̱³wxe³nha²ju³tai²la¹wi¹. Je³ru³sa³lẽ²thĩ³na² ã³ye³yxo²nũ¹nẽ³jau³nũ³su² wai³nxa³wi¹. Nxe³thĩ³nai²na² Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3jah¹la² a²sxi²khai³xai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wxa²ne³kxa³nãu³xai²na² ã³ye³yxo²nũ¹nẽ³jau³nũ³su² wai³nxa³wi¹. Nxe³sxã³ wxa²ne³kĩ̱³sxai²na² ne³ti̱³ti̱³yo²ta̱³nxa² ne³hãn³ta̱³nxa² nxe³sxã³ hxi²kan¹nxã²nxa³i¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hãi¹nxe³sxã³ e³in¹jau³nũ³su² nxĩn¹te³nah¹lxi¹: “Nxẽn²na³li¹.” Ta̱³nxa², “Nxe²nxa³wi¹.” Ta̱³nxa², nxĩn¹jau³su² ã³nhĩ̱³nx2na³li¹. Nxĩn¹kxa²yu³su² jau¹xai²lan¹nha²kxai³ wai³nhĩ̱²nxa³wi¹. Ko̱³nxe³ti³ kãi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nxa²ha¹te¹ txa²wã¹yah³la²nãu³xu¹tai²na² ain³kxain¹te³nah¹lxi¹: “A²nũ²a² ko̱³nxe³ti³ kãi³ũh¹nxa²kxai²nãn²tu̱³ ã³wa²to²hi²sxã³ kãi³ũh¹txa³hẽ¹li¹. Nxĩn¹ju³kxai³la¹. A²nũ²a² ã̱³xai²na² wxa²ye³na² sa²ye³sai¹nxain¹kxai²nãn²tu̱³ nxe³kxai²nãn²tu̱³ jah¹lai²na² ye³nai²na² te²yã¹nxe² kãi³sxã³ ã³wa²la³kxi²nhãn¹kxai²nãn²tu̱³ sa²ye³sai¹ai¹nĩn¹kxai²nãn²tu̱³ nxe³ju³ta²nũ³a² wain³te²ju²hẽ³li¹. Te²yã¹nxũn³sxã³ a²nũ²a² ã̱³xai²na² wxa²wxi²ai²na² sa²wxi²sa²tã³nxain¹kxai²nãn²tu̱³ nxe³kxai²nãn²tu̱³ jah¹lai²na² wxi²ai²na² te²yã¹nxe³ kãi³sxã³ ã³wa²la³kxi²nhãn¹kxai²nãn²tu̱³ sa²wxi²sa²tã³ai¹nĩn¹kxai²nãn²tu̱³ nxai¹nĩn¹ju³ta³nũ³a² wain³te²ju²hẽ³li¹.” Nxe³jau³xau³hxai²tẽx1jãx1sxã³ jau³xai²na² nxe³ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nxe³yãn¹ta¹ txa²yxo²wãn³txa² e³a¹jau³xai²na² jau³xã̱³lxi²na³li¹. Nxe³na¹jau³xa²sa¹. Ko̱³nxe³ti³ kãi³ũ¹nxain¹jah¹la² ĩ³wa³lxĩn³txa³hẽ¹li¹. Nxe²nxa²te²kxa³ya̱n³txi³su² wxa²ne³xa² wxa²ne³wi¹tãu³ai²na² wxa²ne³su²nxain¹kxai²nãn²tu̱³ wxa²ne³ha³tih³nãu³a² ã³nxa̱³yxo¹o³tũ³txai¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A²nũ²a² ã̱³xai²na² wãn³txi³kxai³lu¹: “Wxa²ha³la³sẽ³nãn¹ta³ka³lo³a² yxo²kwa̱in³sa³nha¹. So¹kxi²si¹jau³su² txa²hxi²kan¹jah¹la² ĩ³ye³kxai¹na¹tũ¹xã¹.” Nxe³kxai²nãn²tu̱³ wxa²ha³la³sẽ³nãn¹ta³ka³lo³a² ũ³hũ¹txai¹nhẽ³li¹. Nxe³kxa²yu³su² wxa²wã²la²ka³lo³a² wi²kxi²nhãn¹ka³lo³a² kwa²sa²son¹ka³tu̱³ ũ³hũ¹tain¹nũ³nhẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te²yã¹nxũn³sxã³ a²nũ²a² hxi²kan¹te²su² te²na² e³kxi¹nxain¹kxai²nãn²tu̱³ nxe³te³nah¹lxi¹: “Txa²yen³kxa² sa²nah³so¹sxã³ ũ³hũh¹sẽ¹li¹. Tĩh³nai²na² ai³na¹tĩh³na² ũ² ki³lo²me³tro³tĩh³na² ã³si³tẽ³kxi¹sẽ¹li¹.” Jau³su² nxe³nxain¹kxai²nãn²tu̱³ tĩh³na² ki³lo²me³tro³tĩh³na² tĩh³nha¹li¹ yen³kxai²na² sa²nah³so¹sxã³ ã³si³tẽ³kxi¹txai¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te²yã¹nxe³jut3su² a²nũ²ai²na² wxa²yen³kxai²na² a²ten³jau³su² e³kxi¹nxain¹kxai²nãn²tu̱³ ũ³hũ¹txai¹nhẽ³li¹. Te²yã¹nxe³sxã³: “Wxa²yen³kxa² kwa² ũ³hũ¹sẽ¹li¹.” Nxe³nxain¹kxai²nãn²tu̱³ kwa² ũ³hũ¹txai¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nxa²ha¹te¹ txa²wã¹yah³la²nãu³xu¹tai²na² yau³ã̱³xai²na² ain³kxain¹jau³xu¹tai²na² nxe³te³nah¹lxi¹: “A²nũ²a² wa³kxa² yxau³nũ¹jah¹la² a³lxi¹jah³lxi³hẽ¹li¹. Yxãn¹ta¹ wxa²ko̱¹ko̱¹ah³la² hi̱t3jah¹lxi³hẽ¹li¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² wãn³txi³sxa³wi¹. A²nũ²a² ĩ³tih³nxe³nx2ti³ te²nãu³xu¹tai²na² wãn³txi³su² ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nxe³yãn¹ta¹ txa²yxo²wãn³txa² e³kxi¹nx2ta¹tu¹wi¹. Wxa²ko̱¹ko̱¹nãu³xa² a³lxin¹txi³txai¹nhẽ³li¹. Ha³lo²a² khãuh³lxa³ti³hi¹nx2ti³si¹hain¹jau³nũ³a² Sũ̱³na² ĩ³ye³kxi²nx2tain¹kxai²nãn²tu̱³ nxe³kxan²ti³, “Wi¹lhin¹ju³ta² so¹lxi³ yxau³txai²lã¹. Khãuh³lxa³ti³hit1sah²lxin¹tũ̱³ka̱³txi³ ĩ³nxai²na²sa¹.” Yah³lxin¹jau³su² Sũ̱³na² ĩ³ye³kxi¹txain¹yah³lxi³hẽ¹li¹. Ĩ³hi̱³txã²tain¹te²na² sa²kxai³lu² wi¹ju³ta³nũ³a² so¹lxi³ ĩ³wa²lã³xi²txain¹yah³lxi³hẽ¹li¹. A²nũ²ai²na² yxo²ha³nxe³lhxa³txi³ ko̱³nxe³ti³hit1sxã³ ĩ³yĩ¹li¹nx2ti³ta̱³nxa² khãuh³lxa³ti³nx2ti³ta̱³nxa² nxe³nx2tain¹kxai²nãn²tu̱³ Sũ̱³na² wi¹lĩ²si¹hain¹ju³ta³nũ³a² Sũ̱³na² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nxe² kãi³ũ¹hain¹yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹wĩ³na² Si³yxau³tãu³a² oh³na² yxau³jah¹la² a²ki³lha³lxa²nãu³lot3nx2ti³tu¹wi¹. A²nxe³jah¹lai²na² sa²kxai³lu² Txa²wã¹sũ̱³nai²na² sa²kxai³lu² a²nũ²a² a²yxo²ha³kxa¹ wi¹lhin¹te²la³ ta̱³nxa² ko̱³nxe³thin¹te²la³ ta̱³nxa² nxe³te²na² a²yxo²ha³kxa¹ u³je³na³ka² ĩ³ha³te¹kxi²te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ a²nũ²ai²na² wi¹kãi³ta̱³nxa² ko̱³nxe³ti³ kãi³ta̱³nxa² a²yxo²ha³kxa¹ wẽ³ha²yau³xa² wẽ³hã¹si¹jau³su² sa²si¹hã³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jã¹nxe³kxe³kxa²ya̱³lhu² a²nũ²a² a³lxi²nx2tain¹te²na² so¹lxi³ a³lxi²yah³lxin¹kxai²nãn²tu̱³ ũ³yho³hi²yah³lxin¹ju³ta³nũ³a² kãi²nhĩ̱²nxa³lho³li¹. Nxe³sxã³ a²nũ²a²nãu³xa² ũ³yho³hi²ki̱³ki³a² so¹kxi²nẽ³tũ̱³ka̱³txa² te²yã¹nxe² kãi³ain¹nũn³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te²yã¹nxe³jut3su² a²nũ²a² ne³khauh²hain¹yah³lxin¹te²na² wxa²wã³tã̱³nãu³sxu² kxai²nãn²tu̱³ nxe³te²na² so¹lxi³ wi¹le³kxain¹yah³lxin¹kxai²nãn²tu̱³ wai³nhĩ̱²nxa³wi¹. A²nũ²a² Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³xa² te²yã¹nxe² kãi³ain¹nũn³te²ju²hẽ³li¹. Nxe³te²nãu³xa² hai³txi³ ã³wa²to²hi² wi¹le³kxi²yah³lxi³hĩ̱³nx2nxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jã¹nxe³kxa²ya̱n³ti³su² Txa²wã¹sũ̱³na² Si³yxau³jah¹la² Oh³na² yxau³jah¹la² hãi¹nxe³kxe³hũ̱³sxã³ a³lxi²nha²jah¹lai²la¹wi¹. Nxe³kxa²yã¹nxe² kãi³sxã³ a³lxi²nha¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ju¹ta³la³ nxe³ha²kxai³ wi¹lhin¹sxã³ kãi³yah³lxin¹kxai²nãn²tu̱³ a²nũ²a² sa²nẽn¹kxi¹nx2tain¹jau³nũ³su² yũ³tu¹wi¹. Nxe³nx2tain¹ju³ta² wi¹na³li¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² sa²nẽn¹kxi²si¹nx2ti³jau³su² jau³xa² so¹lxi³ kãi³sxã³ ãn³ten³jah¹lxi³hẽ¹li¹. Nxe³to³ta¹ nxe² kãi³sxã³ ãn³ten³yah²lxan³kxai²nãn²tu̱³ kxã³nãu³a¹ Wxa²wĩ³na² Si³yxau³ka³txa² Oh³nãn¹jah¹la² wi¹kãi³yah³lxin¹kxa²yo³ha² ũ³hũ¹nx2ti³xa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jã¹yxah³lxin¹jut3su² a²nũ²a² yen³kxi³txa²te²na² hxi²nũ¹nu³hain¹yah³lxi³to³hin¹tãu³a² hai³txi³ ju¹ta³la³ kãin² ĩ³yũ¹khaix1yah³lxi³txa³hẽ¹li¹. A²nũ²a² kwa² wi¹lhin¹ki³lxo³te²nãu³xa² nxe² kãi³ain¹te²ju²hẽ³li¹. Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih¹sxã³ ĩ³yũ¹kxi² sxi²je³na² ai³sxã³ ĩ³yũ¹kxi² nxain¹te²ju²hẽ³li¹. Kwa² sa²nẽn¹kxi²nha²ju³ta² yxo²kwa̱i³nain¹te²ju²hẽ³li¹. A²nxe³te²nãu³xa² kãi³ain¹kxa²yo³ha² hĩ¹na¹ so¹lxi³ yũ³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yxãn¹ta¹ wxa²nũ̱³ka̱³txa² te²yã¹xah³lxi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ a²nũ²a² ĩ²nx2ti³xa³tãu³a² yen³kxi³txa²jah¹la² hxi²nũ¹tain¹jah¹lxi³hẽ¹li¹, kãin²te²lo³nx2tain¹kxa²ya̱n³txi³su¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nxe³yah³lxin¹kxai²nãn²tu̱³ hãi³a² wi¹kãi³ye²yah³lxi¹nha²kxai³ Txa²wã¹wĩ³na² Si³yxau³jah¹la² hãi³a² kãi³ki̱³kxa² ĩ²nẽ³jah¹la² ũ³yho³hi¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nxa²ha¹te¹ Txa²wã¹sũ̱³na² e³kxi²yah³lxi³to³hin¹tãu³a² a²nũ²a² wi¹lhin¹ki³lxo³te²nãu³xa² te²yã¹nxe² kãi³yah³lxi³txa³hẽ¹li¹. A²nxe³te²nãu³xai²na² sa²kxai³lu² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih¹sxã³ a²nũ²a² ne³kxaix3tãu³a² ĩ³sa²nxũ³sxã³ e³kxi²to³hi² sxi²je³na² nu²ki³ye³lot3tãu³a² ĩ³sa²nxũ³sxã³ e³kxi²to³hi² nxain¹te²ju²hẽ³li¹. Kwa²sa²nẽn¹kxi²nha²ju³ta² yxo²kwa̱i³nain¹te²ju²hẽ³li¹. A²nxe³te² he³la³kxi³nãu³xai²na² hĩ¹na¹ so¹lxi³ kãi³ain¹kxa²yo³ha² yũ³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yxãn¹ta¹ wxãi²na² sa²kxai³lu²: “Sũ̱³na² e³kxi²to³ha¹tũ¹xã¹.” Yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ĩ²kxi²nẽ³jah¹la² nũh¹lxi³ ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² te²hi²sen³su² hãi³a² e³kxi²ki̱³to³jau³xai²na² ĩ²kxi²nẽ³jah¹la² Te²hi²sen³kxai³lu² ũ³yho³hi¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jã¹nxe³sxã³ Sũ̱³na² e³kxi²yah³lxi³to³hin¹tãu³a² wãn³txa² yau³ka³lxa¹txi³ kwa²to³toh³lxi³jau³xa² e³kxi²yah³lxi³toh³txa³hẽ¹li¹. Nxe³te²yãx1jau³xa² Sũ̱³na² wãn³txa² ĩ²ai¹nxa³tũ̱³ka̱³txa² nxe³te²yãx1jau³xa² e³ain¹to³te²ju²hẽ³li¹. A²nxe³te²nãu³xai²na² sa²kxai³lu²: “Yau³ka³lxa¹txi³ kwa²to³toh³lxi³ Sũ̱³na² e³kxi²sĩn¹to³ha¹kxai²nãn²tu̱³ ain³kxi²sa²sĩn¹tũ¹xã¹.” Ain¹jau³su² nxain¹ta¹ hai³txi³ ain³kxi²nũ¹hai¹nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nxe³ha²kxai³ te²yã¹nxe² kãi³yah³lxi³txa³hẽ¹li¹. Txa²wã¹sũ̱³na² te²hi²sen³kxai³lu² ã³ten³yah³lxin¹jau³su² e³kxi²yah³lxan³ta̱³lxa¹ ã²la² wi¹ko̱³nh²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nxe³yãn¹ta¹: “Sũ̱³na² e³kxi²na¹tũ¹xã¹.” Yxah³lxin¹kxai²nãn²tu̱³ jau¹xai²na² e³li³kxi³jau³nũ³a² e³kxi¹jah³lxi³hẽ¹li¹. Nxe³te³nah¹lxi¹: “Txa²wã¹wĩ³na² oh³na² yxau³jah¹lãi³. Wi¹lhin¹sxã³ sa²nẽn¹kxi² kãin²te²lo³txa²ju³ta² ten³sa²sĩ¹nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Wxa²wãn³txa² wi¹jau³xa² A²hxi²kxan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³su² nxe³jau³xa² wa³su³txi³ yũ³nũ¹sa²nhĩn¹ju³ta³nũ³a² ten³sa²sĩ¹nhai¹. Oh³nãn¹ko³nãu³a¹ ten³nxa²ju³ta² hãi¹nxe³sxã³ wa³su³txi³ sa²yxo²wet1sxã³ kãi³ ta³lu²nain¹te²tu³wi¹. Nxe³kxa²yã¹nxe³sxã³ yuh³nãn¹ko³nãu³a² te³xa²yã¹nxe² sa²yxo²wet1sxã³ kãi³ ta³lu²nain¹ju³ta³nũ³a² ten³sa²sĩ¹nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yain³txa² hãi¹nxa² ũ³hũ²sa²sĩ¹nĩ¹nhĩn¹txai³sa²sĩ¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","A²nũ²a² ã̱³xai²na² ko̱³nxe³ti³ kãi³ũ¹sain¹sĩn¹kxai²nãn²tu̱³ ne³wã²na³ũ¹hain¹sĩ¹na¹wi¹. Nxe³ain¹sĩ¹na¹kxa²yã¹nxe³sxã³ ko̱³nxe³ti³ kãi³ũh¹nxa²sĩ¹na¹ju³ta² ne³wã²na³ũ¹sa²sĩ¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ha³lo²a² ko̱³nxe³ti³ kãi³si¹sĩ¹na¹ju³ta³nũ³a² ã³sa²so¹sa²sĩn¹txa³hẽ¹li¹. Yxãn¹ta¹ ko̱³nxe³ju³ta² ã³non²ta³kxi¹sa²sĩ¹nhẽ³li¹. Jã¹nxe³jut3su² wxãi²na² so¹lxi³ ha³lo²ai²na² a²wa³kxẽn³yah¹lo²sĩ¹nha²kxai² nũ³kxũn³ta² si³yxau³jah¹lo²sĩ¹nha²kxai³ wxi²kin³ti³ton³jah¹lo²sĩ¹nha²kxai³ nxe³sa²tẽ³sĩ¹nĩ¹lxi¹. Ta³lu²na¹wi¹. A²mẽ³.” Nxe³kxa² he³la³kxi³su² Sũ̱³na² ĩ³ye³kxi¹jah³lxi³to³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jã¹nxe³jut3su² a²nũ²a² ã̱³xai²na² ko̱³nxe³ti³ kãi³ũh¹nx2ti³kxai²nãn²tu̱³ wi¹lhin¹sxã³ ne³wã²na³txain¹yah³lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ti² Wxa²wĩ³na² Oh³na²yxau³jah¹la² ko̱³nxe³ti³ kãi³yah³lxin¹kxe³su² ne³wã²na³ũh¹nx2ti³nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nxe³yãn¹ta¹ wxa²ẽ¹nãn¹jau³su² nxe³ke³la³te²kxai³ te³nah¹lxi¹: “Jah¹lai²li² ko̱³nxe³ti³ kãi³ũ¹sain¹na²hẽ³na¹. Ne³wã²na³ũ¹hain¹nxa³lho³na¹.” Nxĩn¹ke³la³te²kxai³ Txa²wã¹sũ̱³na² te²hi²sen³su² wxa²ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ne³wã²na³ũh¹nx2ti³hĩ̱²nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nxa²ha¹te¹ Sũ̱³na² e³kxi²te³lhxã³ yain³txa² ĩ³yain³ju³ta² ã³na¹yah³lxin¹kxai²nãn²tu̱³ khãuh³lxa³ti³ki³lxo³nha²yah³lxi³txa³hẽ¹li¹. Wi¹lhin¹ki³lxo³nha²jah¹la² te²yã¹nxe² kãi³te²ju²hẽ³li¹. A²nxe³jah¹lai²na² he³la³kxi³su² yain³txa² ĩ³yain³ju³ta² ã³na¹ain¹kxai²nãn²tu̱³ wxa²ye³hi̱³nhã²nxa³ha²kxai³ hxi²khai²lxi²nxa³ha²kxai³ ne³te²kxai³la¹ khãuh³lxa³ti³nxa² yain³txa² ĩ³yain³ju³ta² ã³na¹yain¹kxe³su² a²nũ²a² yxo²ha³kxa¹ ĩ²ain¹ju³ta² yxo²kwa̱i³nain¹te²ju²hẽ³li¹. Jã¹nxe³ju³ta² hĩ¹na² so¹lxi³ ũ³yho³hi²hain¹ju³ta² ta³lu²nain¹tu¹wi¹. Ki³han³nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Nxe³yãn¹ta¹ wxãi²na²: “Sũ̱³na² ĩ³ye³kxi²te³la¹nhai¹. Yain³txa² ĩ³yain³ju³ta² ã³na¹a¹tũ¹xã¹.” Yxah³lxin¹kxai²nãn²tu̱³ wxa²ye³hi̱³nha² wxa²hxi²khai²lxi² nxe³te²kxa³ya̱³lhu² a²nũ²a² ã̱³xai²na² ĩ²nxa²tain¹kxai²nãn²tu̱³ yain³txa² ĩ³yain³ju³ta² ã³na¹yah³lxin¹ju³ta² ĩ²nxa²ti³xa³lho³li¹. Nxe³te²kxa³ya̱n³tu̱³ta¹ Wxa²sũ̱³nai²na² ĩ²ki̱³sxa³jah¹la² ĩ²nxa²ti³tu¹wi¹. Ĩ²nxa²ti³ha²kxai³ kxã³nãu³a¹ ũ³yho³hi¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nxa²ha¹te¹ yen³kxa² kãin² ũ³wha¹ah³lxi³txa³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ wa³la²la² ĩ³kho³kxi²ha²kxai³ yen³kxa² ĩ³nã̱n¹kxi²sxã³ khon³nha²kxai³ nxe³kxi²nẽ³te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ a²nũ²a² ko̱³nxe³thin¹jah¹la² hãi³a² wxã³sxã³ kãi³sa²no¹ki²nẽ³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nxe³yãn¹ta¹ oh³nãu³nãn¹ko³xa² wi¹kãi³yah³lxin¹kxa²yo³nhũ³a² ũ³wha¹jah¹lxi³hẽ¹li¹. Nxa²lxin¹kxai²nãn²tu̱³ hai³txi³ wa³lan²txa³ ĩ³kho³kxi¹nx2ti³xa³ha²kxai³ ĩ³nã̱n¹kxi²sxã³ kho³thxa³txa³ha²kxai³ nxẽn²nxa³lho³li¹. Te²yã¹nxũn³sxã³ a²nũ²a² ko̱³nxe³thin¹jah¹la² hãi³a² wxã³sxã³ kãi³sa²no¹ki²nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nxe³sxã³ wxa²yan³txi³nũ³a² ũ³ha¹ah³lxin¹ti³xa² so¹lxi³ wxa²ẽ¹nãu³a² nũ¹ha̱in³nyhah¹lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Nxa²ha¹te¹ txa²wã¹ye³nai²li² ye³wi¹kxai²nãn²tu̱³ txa²wã¹nũ²a² whãi²na¹ wi¹lo²la³kxi²nha²ki̱³te²ju²hẽ³li¹. Yxãn¹ta¹ ye³wi¹lxa³kxai²nãn²tu̱³ txa²wã¹nũ²la³ whãi²na¹ hai³txi³ wi¹lo²la³kxi²nha²ki̱³te²sxa³yu²hẽ³li¹. Nxe³kxa²yã¹nxe³jut3su² txa²wã¹ẽ¹nãu³ai²na² wi¹kxai²nãn²tu̱³ wi¹kãi³sxã³ yxau²xai³ki̱³tã³li¹. Yxãn¹ta¹ txa²wã¹ẽ¹nãu³ai²na² wi¹lxa³kxai²nãn²tu̱³ wi¹kãi³sxã³ yxau²xai³ki̱³sxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nxa²ha¹te¹ a²nũ²a² ha¹lin¹te²na² nxe³ya³sxã³ nxe³te²na² wãn³txai²na² hxi²kan¹ti³ sa²yxo²we¹ta³lxi³ki̱³te²sxa³yu²hẽ³li¹. Nxe³sxã³ txa²wã¹hxi²kan¹yah³nẽ³jah¹la² ka³na³ka³na³te²na² ĩ³hi̱³ki̱³sa²kxai³ txa²wã¹hxi²kan¹yah³nẽ³jah¹la² ã³xai²na² a³lxi²ki̱³sa²kxai³ nxe³ki̱³te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ txa²wã¹hxi²kan¹yah³nẽ³jah¹la² ka³na³ka³na³te²na² sa²yxo²we¹ki̱³sa²kxai³ txa²wã¹hxi²kan¹yah³nẽ³jah¹la² ã̱³xai²na² sa²yxo²ã³ki̱³sa²kxai³ nxe³ki̱³te²ju²hẽ³li¹. Jã¹nxe³jut3su² Txa²wã¹sũ̱³na² so¹lxi³ sa²yxo²we¹ta̱³nxa² yen³kxa² kwa²ũ³ha¹kxi²ki̱³ju³ta³nũ³a² o²la³kxi²ta̱³nxa² yu³ka³na³ka³na³ju³ta² so¹lxi³ hxi²kan¹txi³ kãi³ki̱³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jã¹nxe³jut3su² na¹ha²kxai³ ya²la³tu̱³ e³kxi¹nx2ta¹i¹. Wi¹yxau³yah³lxin¹ju³ta² hxi²waun³ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. Yain³txi³su² yain³yah³lxin¹kxe³nũ³su² ta̱³nxa² ĩ³na²kxi³jau³su² ĩ³na²yah³lxin¹kxe³nũ³su² ta̱³nxa² hxi²waun³ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. Wã²la² ka³lo³ai²li² ũ³whi²kxi²nhãn¹ka³lo³nũ³ai²li² hxi²waun³txi³nha²sxã³ yxau²xai³ah³lxi³txa³hẽ¹li¹. A²nxe³jut3su² ka³te̱³na² yxau²xai³ki̱³ju³ta² sa²kxai³lu² yain³txi³su² a³lxi² wa³to²hi²te²ju²hẽ³li¹. Te²yã¹nxũn³sxã³ txa²wã¹nũ²ai²na² sa²kxai³lu² wã²la²ka³lo³su² a³lxi² wa³to²hi²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nxe³sxã³ a̱i³kxe³su² ĩ²jah¹lxi³hẽ¹li¹. Hai³sxai²li² ũ³whĩ̱¹ai¹nxa³ha²kxai³ yain³txi³su² wxa²so¹sxã³ ũ³wha¹ai¹nxa³ha²kxai³ nxai¹nxa³kxan²ti³nũ¹ Txa²wã¹sũ̱³na² Oh³nãn¹jah¹la² hi²sen³su² ũ³yhai¹tain¹te²ju²hẽ³li¹. Jã¹nxe³kxe³hũ̱³nxe² Txa²wã¹sũ̱³na² te²kxai³lu² ã²la² kãi²non³sxã³ a³lxi²sa²tẽ³nx2ti³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kãin² hxi²waun³ta³kxi²nyhah¹lxin¹kxai²nãn²tũ³ ã²la² a³lu²on³sxã³ ka³te̱³na² yxau²xai³yah³lxi³hĩ̱²nxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Te²yã¹nxe³jut3su² wã²la² ũ³whi²kxi²nyhah¹lxin¹ka³lo³a² hxi²waun³ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. Si³sa³yãu³sa² ha³lo²a² wen¹ka² ĩ²jah¹lxi³hẽ¹li¹. Hai³txi³ hai³sxa³la³ wa³ko³nai¹nxa³ha²kxai³ wãn²txa³ we¹tai¹nxa³ha²kxai³ ain¹te²sxa³yu²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sa³lo³mãu²ah³lu¹tai²na² I³sa³e² nũ̱³ka̱³txa² a²wa³kxẽn³ta² kãin²jah¹lo²su² ta¹hxai²ti³ai¹ti²tu³wi¹. Yen³kxih³khai¹nxe³ha²kxai³ wã²la² wi¹khaix1ka³lo³a² ũ³whi²kxi²nha²ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³kxan²ti³nũ¹ si³sa³yãu³sa³kxai²na² wi¹wa³to²hi²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hĩ¹na¹ wi¹we¹nha²kxai³ ka³nxa³ha²ta³ai²na² i̱³hxa³nha²kxai³ nxe³te²ju²hẽ³li¹. Txa²wã¹sũ̱³na² te²hi²sen³kxai³lu² ĩ³wi¹we¹je²ta¹hxai²ti³ai¹ti²tu³wi¹, si³sa³yãu³sa³kxa² so¹lxi³ kxan²ti³na¹. Nxe³te²yã¹nxe² Txa²wã¹sũ̱³nain²txi³ hxi²kan¹txi³ wi¹lhau³ko³tũ¹nx2ti³tu¹wi¹, hxi²kan¹sxã³ wa³to²hi²yah³lxi¹nha²kxai³lu¹. Jã¹yxah³lxin¹ju³ta² yxo²ĩ²syah¹lxin¹ju³ta² kãin²ye¹nxa²ti³xa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jã¹nxe³jut3su² hxi²waun³ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. E³yah³lxin¹jau³su² nxe³yah³lxi³txa³hẽ¹li¹. Nxe³yah²lxan³te³nah¹lxi¹: “Ĩh¹nxe² yain³txa³nu³la³ so¹kxi²sxã³ yai³nhĩ̱³ki̱³ji¹? Ĩh¹nxe² na²ki̱³jau³nũ³la³ so¹kxi²sxã³ ĩ³na²hĩ̱³ki̱³ji¹? Wãn²ta³ ĩh¹nxe³ka³lo³la³ ũ³whi²kxi²nha²hĩ̱³ki̱³ji¹?” Nxe³yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nxe³ju³tai²na² a²yxo²ha³kxa¹ Sũ̱³na² wãn³txa² yxo²ĩ²ai¹nxa³tũ̱³ka̱³txi³nãu³xai²na² yen³kxa² yxo²kwa̱in³sxã³ ã³te³nain¹te²ju²hẽ³li¹. Nxe³yãn¹ta¹ wxãi²kxai³ ha³lo²a² ã³taut3to³jah³lxin¹kxe³su² Wxa²wĩ³na² Si³yxau³tãu³a¹ Oh³nãn¹jah¹lai²na² Hi²sen³kxai³lu² taut3to³jah³lxin¹kxa² whãi²na¹ ĩ²jah¹lo²su² na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nxe³yah³lxi¹nha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²wet1hxa³jah³lxin¹ju³ta² txa²nũ² ã³te³ni² Sũ̱³na² wi¹lhin¹ti³hit1txa²lxi³ju³ta³nũ³a² txa²nũ² ã³te³ni² nxe³jah³lxi³sã²nhẽ³li¹. Yxah³lxin¹kxai²nãn²tu̱³ yen³kxai²na² ã³taut3to³txai³yah³lxin¹kxai²li² ũ³tet1sũ³nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jã¹nxe³jut3su² ka³nxa³ha²tai²nãn¹ta² yen³kxi³nũ³a² hxi²waun³ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. Txa²wã¹sũ̱³na² hxi²ka²nãu³a² yxau²xai³yah³lxin¹ju³tan¹te²ka³ya̱³lhu² hĩ¹na² sa²kxai³lu² hxi²waun³ta³kxi²yah³lxan³sxã³ ã³wa²sut1sxã³ yxau²xai³yah³lxi¹lxi¹. Ka³nxa³ha²ta³ai²na² te²yã¹yxah³lxi³nũ³nĩn¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","A²nũ²a² ã̱³xai²na² yxo²wa³su³txi²sxã³ ko̱³nxe³ti³ ĩ³yĩ¹li¹yah³lxi³txa³hẽ¹li¹. Nxe³yãn¹ta¹ nxe³yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² hxi²ka² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nxe³sxã³ a²nũ²a² ã̱³xai²na² ĩ³yĩ¹lain¹yah³lxin¹kxa²yã¹nxe² ĩ³yĩ¹li¹nx2tain¹tu¹wi¹. Hxi²kxã̱u³khaix1nxe³sxã³ o²la³kxi²nyhu¹ah³lxin¹kxa² yã¹nxe² Txa²wã¹sũ̱³na² hxi²kxã̱u³khaix1nxe³sxã³ kãi³ũh¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Wxa²wã³tã̱³xa² ko̱³nxe³ti³ kãi³jut3su² ju³ta² ko̱³nxe³ti³ ĩ³yĩ¹li¹yah³lxi³txa³hẽ¹li¹. Ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² kãin² wa³to²hi²na³li¹. Nxe³yah³lxin¹ju³ta² wai³nxa³wi¹. A²nxe³ju³tai²na² yã¹nx2na³li¹. Wxa²wã³tã̱³xai²li² hi³a² sĩ̱³na² ye³wi²kxe³su² yũ³hĩ̱³nx2na³li¹. Nxe³yãn¹ta¹ hi³sa³ka³txa² ã³ye³wau¹kxi²nha²hĩ̱³nxa¹lxi¹. Nxe³kxe³su² wxa²ẽ¹nãn¹jau³kxai³lu²: “Txa²wã³tã̱³xai²li² hi³a² sĩ̱³na² sa²ye³sai¹kxi²na¹tũ¹xã¹.” Nxe³yah³lxin¹jau³su² yxãn¹ta¹ hi³sa³ka³txa² ã³ye³wau¹kxi²nha²kxe³su² ĩ²nyhah¹lxan³kxe³su² wai³nhĩ̱³nx2nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nxe³sxã³ wxa²wã³tã̱³xai²li² e³kxain¹yah³lxin¹te³nah¹lxi¹: “Hi³a² sĩ̱³na² sa²ye³sai¹kxi¹nxa²sĩ¹na¹tu¹wi¹.” Nxe³yah³lxin¹jau³su² yxãn¹ta¹ hi³sa³ka³txa² ã³ye³wau¹kxi²nha²kxe³su² yũ³yah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nxe³yah³lxin¹ju³kxai³lu² wxãi²li² wi¹lhin¹ki³lxo³jah¹lo²su² yah³lxi¹lxi¹. Hi³sa³ka³txa² sa²ye³sai¹nhat1jah³lxi³sã²nhẽ³li¹. Nxe³sãn²nũ²la² wi¹lĩ²nha²sxã³ wxa²wã³tã̱³xai²li² hi³a² sĩ̱³na² sa²ye³sai¹kxi²nyhah¹lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yen³kxa² wi¹lhin¹kxa² yũ³yah³lxin¹kxa² tẽ³sxã³ wai³a³lxa² kwa²a³na¹ũ³yah³lxi³txa³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ ã³wa²lhxã³ ye³kãi²ne³nx2ti³ha³tai¹. Te²yã¹nxe³jut3su² txah³lxa³ki³a² a³lxi²ki³ai²na² yũ³yah³lxin¹kxai²nãn²tu̱³ kwa³jan³ta² yxa³kxa² ha³lo²a² yuh³xã¹na¹ũ³yah³lxi³txa³hẽ¹li¹. Nxe² ã³na¹ũ³yah³lxin¹kxai²nãn²tu̱³ yxa³kxai²li² ti̱³ka³la³ju³ta² yũ²na³li¹. Nxe³sãn²ka³tu̱³ hã²wxãn³txa³ ã³nhe¹kxi²sxã³ ĩ³ya²lu¹nx2ti³ha³tai¹. Nxe³ju³kxai³lu² nxe³kxa²yã¹nxe³sxã³ Sũ̱³na² wãn³txa² ĩ³hen³txi³yah³lxin¹tãu³a² nxe³jau³jau¹xai²na² a̱n³ta³kxi²sxã³ en²txain¹kxai²nãn²tu̱³ ha²ya̱³kxa² ĩ³hen³txi³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Txa²wã¹sũ̱³na² ĩ³wã̱³jah³lxin¹kxai²nãn²tu̱³ a²wi¹ju³ta² ũ³hũ¹nx2ti³tu¹wi¹. Te²yã¹nxe³sxã³ yen³kxa² ã³ten³yah³lxin¹kxai²nãn²tu̱³ a³ya³ti²yah³lxin¹tu¹wi¹. Te²yã¹nxũn³sxã³ sxi²ha² a²yxo²a² ĩ³yxo²to¹tot1jah³lxin¹kxai²nãn²tu̱³ sa²yxo²than²yex1nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Te²yã¹nxe³kxe³hũ̱³sxã³ Sũ̱³na² ĩ³wã̱³jah³lxin¹kxai²nãn²tu̱³ nxe³yah³lxi³te² ĩ³nxãn²tu̱³ a²wi¹ju³ta² ũ³hũ¹nx2ti³tu¹wi¹. Yen³kxa² ã³ten³yah³lxi³te² ĩ³nxãn²tu̱³ a³ya³ti²yah³lxin¹tu¹wi¹. Sxi²ha² ĩ³yxo²to¹tot1jah³lxin¹te² ĩ³nxãn²tu̱³ sa²yxo²than²ye¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Jã¹nxe³ju³kxai³la¹ wxa²wẽ³sai²na² yain³tũ̱³xa² ĩ³wã̱³txi³nx2ti³kxai²nãn²tu̱³ txah³lxa³kxa² ũ³hũ¹yah³lxi³hĩ̱³nhãn¹te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Te²yã¹nxũn³sxã³ a̱i³na² ĩ³wã̱³txi³nx2ti³kxai²nãn²tu̱³ txih³xa³ ũ³hũ¹yah³lxi³hĩ̱³nhãn¹te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hai³txi³ ti³he¹nx2nxa³wi¹. Ko̱³nxe³ti³hin¹yah³lxin¹kxan²ti³ yen³kxa² wi¹te²na² so¹lxi³ wxa²wẽ³ha³lxai²na² ũ³hũ¹ain¹yah³lxi³hĩ̱³nxa¹lxi¹. Te²yã¹nxe³ha²kxai³ Txa²wã¹sũ̱³na² Si³yxau³jah¹la² Oh³nãn¹jah¹la² sa²kxai³lu² ĩ³wã̱³ti³yah³lxin¹kxai²nãn²tu̱³ yen³kxa² wi¹kxa² wa³to²hi²sxã³ ũ³hũ¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jã¹nxe³jut3su² a²nũ²a² wi¹lo²la³kxi¹nx2tain¹ju³ta² ten³yah³lxin¹kxa²yã¹nxe² kãi³ũ¹txain¹yah³lxi³hẽ¹li¹. Nxe³jau³xa² Txa²wã¹sũ̱³na² wãn³txa² jau³xau³hxai²tẽx1ta² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² wãn³txa² nxe² ĩ³ye³kxi²nẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yuh³nãu³ãn¹ko³xa² hin¹ki̱³tãu³a¹ tĩh³na² yxau²xai³ki̱³tĩh³na² ha¹lin¹tĩh³na² yũ²na³li¹. Nxe³sxã³ kãin²tĩh³nai²na² sa²kxai³lu² a²nũ²a² ka³lxa²tũ̱³ka̱³txa² yxau²xai³lain¹tĩh³nũ²su² te²ju²hẽ³li¹. A²nxe³tĩh³nai²li² yxau²xai³ki̱³kxai²nãn²tu̱³ hã²wxãn³txa³ yan¹nãu³a¹ khãuh³lxa³ti³sa²tẽ³nhẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nxe³nxa²ha¹te¹ ha³tih³xan¹tĩh³nai²na² kãi²nxa³tĩh³na² yxau²xai³ki̱³kxai²nãn²tu̱³ hã²wxãn³txa³ yan¹nãu³a¹ Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³a² yũ³nũ¹nhẽ³tu¹wi¹. Ka³te̱³na² wi¹tãu³a² yxau²xai³ki̱³tu¹wi¹. A²nxe³tĩh³nai²na² sa²kxai³lu² a²nũ²a² ka³lxa²nxa³tũ̱³ka̱³txa² yxau²xai³tĩh³nũ³su² te²ju²hẽ³li¹. A²nxe³jut3su² tĩh³na² kãi²nxa³tĩh³na² ya³lo³txi²sxã³ yxau²xai³jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sũ̱³na² wãn³txa² ĩ³hen³txi³nẽ³tũ̱³ka̱³txa² nxe³ki³lxo³nxe³tũ̱³ka̱³txai²na² wxã³ha³ta²wi¹. Wi¹lhin¹sxã³ thãi³ti³la² ki³lxo³tai¹nha²kxai³ a²tai²na² o³ve²a²hũ̱³ye²tain¹tu¹wi¹. Yxãn¹ta¹ a̱u³txi³ a²ẽ¹nãu³ai²na² ko̱³nxe³thi¹nai¹nha²kxai³ ã³na¹nx2ti³te³lhxã³ nxai¹nha²kxai³ ha̱u³hũ̱³te²sin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nxe³ha²kxai³ Txa²wã¹sũ̱³na² ĩ³sa²si¹hã³ye²nxai¹nxa³ju³ta² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. O²la³kxi²ye²yhain¹ju³ta² wi¹lhin¹jut3su² ta̱³nxa² ko̱³nxe³thin¹jut3su² ta̱³nxa² a²ẽ¹nãu³ai²na² wi¹ko³nyha¹lxin¹tu¹wi¹. U²va²ki³a² kwa² hu³kxẽ¹ha² ĩ²li³tẽ¹ha² kũh²sxa³te²sxa³yu²hẽ³li¹. Te²yã¹nxe³sxã³ fi²ko²nxã̱³kxa² kwa² hi³sa³ka³txa² ã³nxã̱³kxi²te²sxa³yu²hẽ³li¹. Nxe³te²sxa³jai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jã¹nxe³ha²kxai³ hi³sa³ka³txa² wi¹ka³txai²na² sa²kxai³lu² wi¹ta³nxã̱³kxa² so¹lxi³ ã³nxã̱³kxi²te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ hi³sa³ka³txa² ko̱³ka³txai²na² sa²kxai³lu² ko̱³nxe³ta³nxã̱³kxa² so¹lxi³ ã³nxã̱³kxi²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Te²yã¹nxũn³jut3su² hi³sa³ka³txa² wi¹ka³txai²na² hxi²kan¹txi³ a²nxã̱³kxa² ko̱³nxe³ta³nxã̱³kxa² ã³nxã̱³kxi²te²sxa³yu²hẽ³li¹. Hi³sa³ka³txa² ko̱³ka³txai²na² hxi²kan¹txi³ a²nxã̱³kxa² wi¹ta³nxã̱³kxa² ã³nxã̱³kxi²te²sxa³yu²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jã¹nxe³jut3su² hi³sa³ka³txa² wi¹nxã̱³kxi¹hxa³kxai²nãn²tu̱³ hãi¹sxã³ a²nũ²a² hxi²ka² tau³ka²sa²tã³nũ²la² ha³nxe²a² ũ³thũ²ka³tu̱³ i̱³hxan³ye²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jã¹nxe³jut3su² a²nũ²a² o²la³kxi²ye²yhain¹ju³ta² ĩ²yah³lxi¹nhĩ¹na² a²ẽ¹nãu³ai²na² a³la³kxah¹lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","A²nũ²a² ĩ²li³te²a² hxi²kan¹txi³ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³a² yxau²xai³lai¹nxa³lho³li¹. Nxe²e³kxain¹kxan²ti³: “Nxe³sa¹lxi¹. Txa²hxi²kan¹jah¹lo²si¹lxi¹.” Nxe²e³kxi²kxan²ti³nũ¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³a² yxau²xai³lai¹nxa³lho³li¹. Yxãn¹ta¹ Txa²wĩ³na² Oh³nãn¹jah¹la² Si³yxau³jah¹lai²na² a²ten³jau³su² sa²yxo²we¹kxai²nãn²tu̱³ nxe³te²na² ĩ²li³te²la³ oh³nãn¹ko³nãu³a² ã³wih¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A²nxe³tãu³a¹ kwa² ĩ³ye³kxi²sain¹tu¹wi¹. Ĩ³ye³kxi²sain¹ju³ta³nũ³a² nxe³te³nah¹lxi¹: “Txa²wã¹hxi²kan¹jah¹lãi³. Nxe³sa²sĩ¹lxi¹. Wxa²wãn³txai²na² ĩ³hen³txi³sĩ¹na¹tai¹ti²tu³wi¹. Wxa²ĩ³lxa² ĩ³ye³sxã³ ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³na² a³li³si¹jau³su² kwa³na³sĩ¹na¹tai¹ti²tu³wi¹. Te²yã¹nxe³sxã³ wxa²ĩ³lxa² ĩ³ye³sxã³ nũ³kxũn³khai¹nxe³ju³ta² o²la³kxi²sĩ¹na¹tai¹ti²tu³wi¹. Nxe³sĩ¹na¹ha²kxai³ wxa²sa³wi³ha³lxi³khai³su² sĩ¹na¹wi¹.” Nxe³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nxe³nxa²ha¹te¹ ĩ³wa²lũ³xi²na¹jau³nũ³su² nxe³na¹te³nah¹lxi¹: “Ĩ²nx2ta¹tũ̱³ka̱³txi³su² yah²lxa³lxi¹. Ã³waix3jah¹lxi³hẽ¹li¹. Ko̱³nxe³thin¹ju³ta² kãi³tũ̱³ka̱³txi³syah¹lxi¹lxi¹.” Nxe³ai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jã¹nxe³na¹jut3su² a²nũ²a² ĩ²li³te²na², Txa²wãn³txa² ain³kxi²te²nãn²tu̱³ sa²yxo²wet1sain¹kxai²nãn²tu̱³ a²nũ²a² a²hoh³lxah³la² yã¹te²hũ̱³na³li¹. A²nxe³jah¹lai²na² a²hoh³lxah³lai²na² sa²kxai³lu² sxi²ha² ton³nũ²nhai¹. Txah³lxa³kxa² ũ³si³ka³tũ²kxi²sxã³ ton³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ton³ta³lu²nain¹ka³tu̱³ hã²wxãn³txa³ wẽ³ha²yau³xa² kãin² wẽ³hã¹yain¹nũ²nhai¹. Kãin² wẽ³hã¹ye²ha²kxai³ ka³wã³lxai²na² kãin² hũx1tha²kxai³ it3ta² kãin² it3tha²khai³ nxe³kxa²ha³ta̱³nxãn²ti³ hai³txi³ sxi²lha³ sa²khot3je²nxa³nũ²nhai¹, txah³lxa³kxa² ũ³si³ka³tũ²kxi²sxã³ to³nai¹nha²kxai³lu¹. Nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² Txa²wãn³txa² sa²yxo²we¹jah¹lai²na² nxe³kxa²yã¹nxe²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nxe³yãn¹ta¹ a²nũ²a² ĩ²li³te²na² Txa²wãn³txa² ain³kxi²sa²te²nãn²tu̱³ sa²yxo²ã³sain¹kxai²nãn²tu̱³ a²nũ²a² hxi²ka̱u³ka̱un³jah¹lo²hũ̱³na³li¹. A²nxe³jah¹lai²na² sa²kxai³lu² sxi²ha² ton³nũn³nũ²nhai¹. Ka³yã̱³la² ũ³si³ka³tũ²kxi²sxã³ ton³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nxe³ka³tu̱³ ton³ta³lun²nxa²ha¹te¹ wẽ³ha²yau³xa² kãin² wẽ³hã¹ha²kxai³ ka³wã³lxa² kãin² hũx1tha²kxai³ it3ta² kãin² it3tha²kxai³ nxe³te²kxa³kxa¹ sxi²hai²li² sa²kho³kxi²ye²nu²nhai¹. Sa²nai¹hxa³je²nũ²nhai¹, ka³yã̱³la² ũ³si³ka³tũ²kxi²sxã³ txon³kxi²ha²kxai³lu¹. Nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² Txa²wãn³txa² sa²yxo²ã³sa²jah¹lai²na² yã¹nx2na³li¹. Jã¹nxe³na¹jau³su² nxe³ye¹nxa²lxa¹wi¹. Nxe³jau³xai²na² a²yxo²ha³kxa¹ a²sa³wi³ha³lxai²na² a²nũ²a² ã³si³tẽ³kxi²tũ̱³ka̱³txai²na² nxe³sxã³ Je³su²jah³la² a²yxo²wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nxe²e³ta³lun²tãu³a² a²nũ²a² ain³kxi²tũ̱³ka̱³txa² o²lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","O²lain¹te³nah¹lxi¹: — Je³su²jah³lai²na² wãn³txa² hxi²kan¹jah¹la² wãn³txa² e³jah¹lai²la¹wi¹. Nxe³kxa²ha³tih³xan²tu̱³ ha³te̱h³nxã³nxa² a²hoh³lxi³su² nũ̱³ka̱³txa² te²yã¹nxe² wxi²kan¹sxã³ e³ai¹nxa³wi¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nxa²ha¹te¹ e³ta³lun²nũ²la² wã³la³ka³txa² ka³nxi²ta¹hxai²hẽ¹la². Ka³nxi²te³na¹ a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² ã³si³tẽ³la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nxe³tãu³a² in³jah³la² khon³ta³kxi²sxã³ ka̱³lã̱un³ta³kxi²jah¹la² hi²sen³su² Je³su²jah³la² ĩ²te³lhxã³ wxã³ta¹hxai²hẽ¹la². Wxã³nũ²la² ãn³kax3ti³wxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. “Wxa²ĩ³ta³ka³txa² hxi²kan¹txi³ we²txi²nxa²ha¹tũ¹xã¹.” Sa²ki³kxai³lu¹. Nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nxa²ha¹te¹ Je³su²jah³la² sa²nxũ³sin²nha²sxã³ wxa²wxai³ta¹hxai²hẽ¹la². Wxa²wxai³te³nah¹lxi¹: — Ten³sa³nhai¹. We²txi¹nxa²ha¹wi¹. Nxe²e³ta³lun²nhĩ¹na¹ a²ĩ³ta³ka³txai²li² we²txi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nxa²ha¹te¹ Je³su²jah³la² ãh¹e³kxi²te³nah¹lxi¹: — Nxe³nxa²ha¹ju³tan¹te²kxa³ya̱³lhu² wã³nxĩn¹ta² si³yxau³jah¹la² ai³sẽ¹li¹. Ain¹tãu³a² we²txi¹nxa²ha¹ju³ta² a²nũ²a² a²xã̱³xa² ĩ³hen³txi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ wã³nxĩn¹ta² si³yxau³jah¹lan²tu̱³ ai³sxã³ ĩ³yau¹ũ¹nhat1je¹txai¹nhẽ³li¹. Nxai¹nĩn¹kxai²nãn²tu̱³ hã²wxãn³txa³ ka³yxuh³xa² Moi³se²ah³lu¹tai²na² ĩ³yau¹ũh¹nxain¹kxe³su² ũ³hũ¹txai¹nhẽ³li¹. Nxai¹nĩn¹kxai²nãn²tu̱³ wã³nxĩn¹jah¹lai²na² sa²kxai³lu² ka³yxuh³xai²na² tẽ³sxã³ Sũ̱³na² ũ³hũ¹yhain¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ a²nũ²a² a²yxo²ha³kxa¹ Txa²wã¹sũ̱³na² we²txi²nxain¹ju³ta² ĩ³yau¹ũ³nha²yai¹nĩn¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nxa²ha¹te¹ Ka³far³na³ũ²thĩ³na² ai³sxã³ ã³wih¹ta¹hxai²hẽ¹la². Nxe³te³na¹ Ro³ma²no³ nũ̱³ka̱³txa² so³ta²to² a²wa³kxẽn³yah³lo²su² ã³tĩ³xi²ta¹hxai²hẽ¹la². Ã³tĩ³xi²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","— Nxe³txi¹. Txa²sa³wi³sa² ĩ³ton³kxi²sa³na²hẽ³li¹. A²nũ²ai²na² whãi²na¹ kan²ta³kxi²nha²sxã³ sxi²ha² sxa³ha²kxai³ khãuh³lxa³ti³nha²khai¹nxa²hẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nxe³ha²kxai³ Je³su²jah³lo²kxai³lu² ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: — Wxã³na¹tu¹wi¹, we²txi²te³lha³ku¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nxa²ha¹te¹ Ro³ma²no² nũ̱³ka̱³txa² so³ta²to² a²wa³kxẽn³yah³lai²na² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Nxe³sa²lxi¹. Txai²li² wxa²ye³na² kãin² sa²nxa³wi¹. Txa²sxih²nãu³a² ã³si³tẽ³kxi²san¹ju³ta³nũ³su² ãu²li²sa³nhai¹. Nxe³sa³ha²kxai³ hãi¹nxe³sxã³ a²wãn³txa² so¹lxi³ ĩ³ye³kxin¹kxai²nãn²tu̱³ txa²sa³wi³sĩ³na² we²nxi²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jã¹nxe³na¹jut3su² te²yã¹nxũn³na¹wi¹. hxi²kan¹jah¹lo²su² yũ³sa²nũ³nha²kxai³ so³ta²to² nũ̱³ka̱³txa² sa²yxo²wet1sain¹tũ̱³ka̱³txa² yu³nũ³na¹ha²kxai³ te²sa¹wi¹. Nxe³sxã³ txa²sa³wi³sxai²na² ai³si¹ha¹jau³su² ĩ³ye³kxi²na¹kxai²nãn²tu̱³ ai³hĩ̱³nx2na³li¹. Te²yã¹nxe³sxã³ sa³wi³sxa² ã̱³xai²li² wxã³si¹jau³su² ĩ³kaix1so¹na¹kxai²nãn²tu̱³ ya²la³tu̱³ ã³wxã³hĩ̱³nx2na³li¹. Te²yã¹nxũn³sxã³ txa²wa³ka³lxa² wa³kon³si¹ha¹jau³su² ĩ³ye³kxi²na¹kxai²nãn²tu̱³ ya²la³tu̱³ wa³kon³kxi²sai¹nhĩ̱³nx2na³li¹. Te²yã¹nxũn³te²sa¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² jau¹xai²na² ain³kxi²nũ²la² ka³lih¹ti³hain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ ã³si³tẽ³kxi²tũ̱³ka̱³txa² ĩ³ye³kxi²te³nah¹lxi¹: — Ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Ju¹tai²na² sa²kxai³lu² jah¹la²nu¹tai²li² ĩ²sain¹te²sai¹nxa³nũ²nhai¹. Nxe³ta¹ yxo²ĩ²sain¹nũ²nhai¹. Yxãn¹ta¹ I³sa³e² nũ̱³ka̱³txa² a²yxo²ha³kxa¹ hxi²ka¹na¹ju³ta² ye³ka³lxa¹txi³ ĩ²sai¹nhxai²na²hẽ³li¹. Yxãn¹ta¹ kũ³we²ki²la² yxo²ĩ²sai¹nhxai²nxa³hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Kxã³nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³su² yũ³hĩ¹na¹ A³bra³ãu²ah³lu¹tai²na², I³sa²kah³lu¹tai²na² Ja³ko²ah³lu¹tai²na² nxe³sxã³ Txa²wã¹sũ̱³na² me²sa²ka³lo³a² ĩ³yain³te³lhxã³ ã³wxe³ain¹tu¹wi¹. Nxe³tãu³a¹ a²nũ²a² ka³lxa¹te²nãu³xa² ha³lo²a² u³je³na² a³li³xi²tãu³an¹ko³xai²na² wxã³ai¹nha²kxai³ u³je³na² kan³tãu³an¹ko³xai²na² wxã³ai¹nha²kxai³ nxe³sxã³ wxã³sxã³ yai³nain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nxain¹ta¹ Ju³te²a² nũ̱³ka̱³txi³nãu³xa² yxo²ĩ²sai¹nxa³te²na² ka³lxa¹te²nãu³xa² oh³nãn¹ko³nãu³a² u²sa²tã³ain¹tu¹wi¹. Ha³lo²a² ka³nxah³khai¹nxe³ju³ta² u²sa²tã³ain¹tu¹wi¹. Nxe³tãu³a² tũ̱¹ka̱³txain²txi³ ye³khãuh³lxa³thi¹nain¹ju³tan¹te²kxa³ya̱³lhu² kãin² nã̱³nai¹nha²kxai³ kãin² yxo²ka³ta̱³ta̱³tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txa² Ro³ma²no² nũ̱³ka̱³txa² nũ³kxũn³jah¹la² e³kxi²te³nah¹lxi¹: — Ĩ³xi¹txu¹li¹. Yxo²ĩ²san¹kxa²yã¹nxe² wxa²sa³wi³sxai²li² we²txi²na¹wi¹. Nxe³jau³su² ha²kxai³ ĩ³ye³kxi²hĩ¹na¹ sa³wi³sai²li² we²nxi²ta³lun²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nxa²ha¹te¹ Je³su²jah³la² ai³nũ²la² Pe²jah³la² sxi²ha² ã³wih¹ta¹hxai²hẽ¹la². Ã³wih¹tãu³a² Pe²jah³la² a²hã̱i³na² ĩ³hi¹la³kxi²ka³txa² ĩ³ton³sxã³ sxa³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A²nxe³ju³tai²na² Je³su²jah³la² te²hi²sen³kxai³lu² ĩ²tãu³a² ta¹ka³lxai²na² hxi²ka² hxi²ki³ta¹hxai²hẽ¹la². Hxi²ki³hĩ¹na¹ ĩ³hi¹la³kxi²ka³txa² we²txi²ta¹hxai²hẽ¹la². We²txi²nũ²la² ĩ³sa²yxau³nũ²la² yain³txa²kxai³lu² ãu¹la³kxi²nũ²la² wet1sxã³ ũ³hũ¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nxa²ha¹te¹ ka³nxa³hi¹te³lhxã³tãu³a² sa²kxai³lu² a²nũ²a² ka³lxa¹txi³ wxã³ain¹ta¹hxai²hẽ¹la². A²nũ²a² ko̱³nxe³te²a² yãu³ka³txa² nxu²kwa̱i³yxau³jah¹la² tẽ³sxã³ wxã³ai¹ni² ĩ³ta³ka³khai³xa² ĩ³ton³jah¹la² tẽ³sxã³ wxã³ai¹ni² nxe³ain¹ta¹hxai²hẽ¹la². Nxe³te²nãu³xa² Je³su²jah³la² hi²sen³su² ĩ²ain¹tãu³a² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau³te²a² a³li³si¹jau³su² kwa³na³ha²kxai³ ĩ³ta³ka³khai³xa² we²txi²ha²kxai³ nxe³sxã³ a²nũ²a² a²yxo²ha³kxa¹ we²txi²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jã¹nxe³jut3su² kxã³nhxĩ¹nu¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lai²na² I³sa³i²ah³lu¹tai²na² a²wãn³txa² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: — Jah¹lai²na² sa²kxai³lu² txa²wã¹ĩ³ta³ka³txa² ã³wa²su¹tẽ³lha²kxai³ txa²wã¹nũ²ai²na² khãuh³lxa³ti³nha²ki̱³ju³ta² ã³wa²su¹tẽ³lha²kxai³ nxe³jah¹lo²su²na³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nxa²ha¹te¹ a²nũ²a²nãu³xa² ka³lxa¹khai¹nxe³kxe³su² ã³nũ²kxi²ye²ha²kxai³ Je³su²jah³lai²na² hi²sen³su² ĩ̱³ye³nai²na² yxo²ha³ti³lhi³si¹jau³su² e³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nxe³tãu³a² in³jah³la² ha³te̱h³nxã³nxa² a²hoh³lxah³la² wxã³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Tih³nxe³sa²jah¹lãi³. Ha³lo²a² ĩ²li³tãu³a² ã³nxai³lin¹tãu³a² ã³si³te³kxi¹nx2ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Nxe³sa²lxi¹. Wai³a³lxa²si³ta³lã²tẽ¹nai²na² a²sxi²lho³tẽ³na² yũ³te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ a̱i³kai²na² a²ye³sa² wet1sxã³ a²sxi²lho³ju³ta² yũ³te²ju²hẽ³li¹. Nxe³ain¹ta¹ Txai²na² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²kah³lai²na² hai³txi³ ha³lo²a² kwa² sxa³na¹ju³ta³nũ³a² yũ³sa²nxa³wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hã²wxãn³txa³nu² a²sa³wi³sxa² ã̱³jah¹la² wxã³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Ã³si³tẽ³kxi¹nxa²ha¹tu¹wi¹. Nxe³yãn¹ta¹ Txa²wĩ³na² ka³te̱n³su² hin¹tãu³a² yxau³kxi²nũ³na¹tu¹wi¹. Hã²wxãn³txa³ ya³lu²sãn²nũ²la² sa²nĩ̱¹kxi²sã²na¹ka³tu̱³ ã³si³tẽ³kxi¹nxa²ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wxãi²li² ã³si³tẽ³kxi²sẽ¹li¹. A²nũ²a² ĩ²li³te²su² te²a² Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²we¹txa³kxai²nãn²tu̱³ a²nũ²a² ya³lu²te²a² yã¹nxe²na³li¹. Nxe³te²na² sa²kxai³lu² wxa²ka³lxa¹te²su² te²a² ya³lu²kxai²nãn²tu̱³ sa²nĩ̱¹kxi²txai²li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nxe²e³ta³lun²nũ²la² ã³waix3si¹jau³su² ka³no¹a²ka³lo³a² ã³wih¹ta¹hxai²hẽ¹la². Nxe³sxã³ a²sa³wi³ha³lxi³nãu³xa² ã³si³tẽ³la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nxain¹nũ²la² ĩ̱³ye³nai²na² yxo²ha³ti³lhi³tãu³a² it3ta² ũ̱n³txi³ sa²xit3ã³si³wxe³ta¹hxai²hẽ¹la². Nxe³sxã³ ũ̱n³txi³ sa²xit3tha²kxai³ ĩ̱³yau³xai²na² sa²ne³kxi²kxain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ Je³su²jah³lai²na² sa²kxai³lu² hxi²tha³ha²kxai³ sxa³sxã³ ãu³xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nxe³ti̱³kxai³lu¹ a²sa³wi³ha³lxai²na² sa²kxai³lu² Je³su²jah³la² wxa²yũ³kxain¹te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Txu¹lxi¹si¹lxi¹. Ã³non²ta³kxi²sa¹si¹lxi¹. Ã³nxũ¹tẽ³te³lhxã³ sĩn¹na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nxe³nxa²ha¹te¹ Je³su²jah³la² txu¹lxi²nũ²la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ yu̱h³lxah³lxin¹ji¹wi¹? Txa²wã¹sũ̱³na² kãin² yxo²ĩ²yah²lxan³tai¹. Nxe²e³nũ²la² ĩ³sa²yxau³nũ²la² it3tai²na² ĩ̱³ye³nai²na² nxe³sxã³ yxo²xũ̱n³txi³ ĩ³kwa̱i²kxi²ha²kxai³ ha³lo²a² ã³nhãu²no³je²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nxe³ju³tan¹te²kxa³ya̱n³tu̱³ in³txi³nãu³xai²na² ĩ³yxo²o²lha² ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Ĩh¹jah¹lo²ta̱n³te²la¹xã³? Jah¹lai²na² wãn³txa² it3ta² ũ̱n³ju³ta² ã³wxe³si¹jau³su² ĩ̱³ye³na² sa²hãu²not3si¹jau³su² nxe³ten¹tu³wi¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nxa²ha¹te¹ ĩ̱³ye³nai²na² yxo²ha³tih³nãu³a¹ yxau³son³kxi²nũ²la² ha³lo²a² Ka³ta³rẽ²na³ko³xa² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wih¹te³na¹ in³txa² ha¹lin¹jah¹la² ne³khau²sxã³ ĩ³ha¹te²nyhain¹ta¹hxai²hẽ¹la². A²nxe³te² in³txai²na² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³yxau³ta¹hxai²hẽ¹la². Sxi²khai³xa² yũ³ya³hxa³ha²kxai³ a²nũ²a² ya³lun²te²a² sxa³ko³xa² hoh³ya³ta¹hxai²hẽ¹la². A̱n³txi³khaix1nxe³jau³su² nũ³kxũn³khai¹nxe³jau³su² ko̱³nxe³te² yãu³ka³txa² ko̱³nxe³ti³ kãi³si¹yha³jau³su² kãi³ya³ta¹hxai²hẽ¹la². A²nxe³ju³ta² a²nũ²a²nãu³xai²na² yuh³lxi³si¹jau³su² tĩh³nai²na² ã³nxai³ain¹te²sxa³yu²hẽ³la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jã¹nxe³jut3su² Je³su²jah³la² ĩ²ya³sxã³ in³txai²na² a²yxo²wãn³txa² ĩ³kaix1ja³te³nah¹lxi¹: — Nxe³sãn²si¹lxi¹. Txa²wã¹sũ̱³na² Tah²sa²nhi¹lxi¹. Ĩh¹nxe³sa²sĩn¹te³lin¹ji¹wi¹? Ha³lo²a² ã³nhau³ko³nxa³ta̱³lxa¹ ĩ³khãuh³lxa³ti³sa²sĩn¹nhĩn¹jau³su² wxãn³nhĩn¹ji¹wi¹? Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A²nxe³tãu³a² ha³lo²a² ul²ye²nxa³kxe³su² kwa³jan³ta² yxa³kxa² ka³lxa²te²nãu³xa² hoh³sxã³ ũh³yait1tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ũh³yait1tain¹te³na¹ ko̱³nxe³te² yãu³ka³txai²na² wãn³txi³kxai³lu¹, Je³su²jah³la² ĩ³wã̱³txi³ya³te³nah¹lxi¹: — Nxũ²kwa̱i³li³sa²sih¹nhĩn¹jau³nũ³su² kwa³na³sa²sĩ¹nhĩn¹kxai²nãn²tu̱³ yxa³kxa³nãu³xai²na² nxũ²kwa̱i³yxau³sĩ¹na¹ju³ta² ten³sa²sĩn¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ã³waix3jah¹hin¹kxai²lẽ¹. Jau³su² nxũ²la² ya²la³tu̱³ nxũ²kwa̱i³li³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ yxa³kxai²na² nxũ²kwa̱i³wi¹hain¹ta¹hxai²hẽ¹la². Nxe³tãu³ yxa³kxa³nãu³xa² a²yxo²ha³kxa¹ ĩ³ye³na² ne³kxu̱²nxa² wã³la³ka³txa² wxa²kan³kxi²si¹hain¹jau³su² ĩ̱³ye³nãu³a² sa²tã³nũ²ta³lxi³si¹jau³su² ĩ³lon³ta³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nxe³te²kxa³ya̱n³tu̱³ in³txai²na² yxa³kxai²na² wa³kxẽ³nãu³xa² ĩ²ain¹nũ²la² yuh³lxa³txi³ ã³ni³hain¹ta¹hxai²hẽ¹la². Ã³nih³sxã³ a²sxi²yhe³nai²na² ã³wih¹ka³tu̱³ a²nũ²a² yxo²ha³kxa¹ ĩ³hen³txi³nyhain¹ta¹hxai²hẽ¹la². In³txa² ko̱³nxe³te² yãu³ka³txa² a³li³si¹hain¹ju³tin³txi² ĩ³hen³txi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A²nxe³jut3su² sxi²je³na² yxau²xai³tũ̱³ka̱³txi³nãu³xa² a²yxo²ha³kxa¹ Je³su²jah³la² ne³khauh²si¹hain¹jau³su² a³li³ain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Je³su²jah³la² ĩ²sxã³ ã³tĩ̱³nũ²la² yuh³lxai¹nha²kxai³ ha³lo²a² ã³waix3si¹hain¹jau³su² win¹ta²te²lxi³ ĩ³wã̱³txi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² ka³no¹a²ka³lo³a² ã³wih¹ka³tu̱³ ĩ̱³ye³nai²na² yxo²ha³ti³lhi³ka³tu̱³ a²sxi²jen³khai³xa² Ka³far³na³ũ²thĩ³na² wi³xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wi³xi²tãu³a² in³txi³nãu³xa² ne³khauh²nyhain¹ta¹hxai²hẽ¹la². A²nxe³te²nãu³xai²na² in³txa² ĩ³ton³jah¹la² kan²ta³kxi²ka³txa³la³ ĩ³ton³jah¹la² tẽ³sxã³ wxã³ain¹ta¹hxai²hẽ¹la². Hãi¹sxã³ sxa³ye²ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² a²kãin²ju³ta² in³txi³nãu³xa² yxo²ĩ²ain¹tũ̱³ka̱³txi³su² ha²kxai³ sãn²sxã³ ĩ²nhai¹nha²kxai³ in³txa² kan²ta³kxi²jah¹la² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wẽ³sãi³. Nxex3txi¹. Nxũ²kwa̱i³lxũ¹txa²hẽ³li¹. Wxa²ko̱³nxe³ti³ kãi³in¹ju³ta² sa²wa²su¹txa²ha¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nxe²e³ta³lun²nũ²la² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²nãu³xa² a²ha³tih³sa² te²nãu³xa² e³lain¹te³nah¹lxi¹: — Je³su²jah³lai²li² Txa²wã¹sũ̱³nu²su² ki³lxot3sxã³ kãi³nĩn²tai¹. Yxãn¹ta¹ Txa²wã¹sũ̱³nu²su² nxa³wi¹. Nxe³ha²kxai³ ko̱³nxe³thin¹jah¹lo²su² na³li¹. Ain¹jau³su² ki³han³sxã³ e³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² tũ̱¹ka̱³txai²na² a²ẽ¹nãn¹jau³xai²na² wi¹ko̱³nha²kxai³ e³kxi²xi²te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ko̱³nxe³jau³su² wxa²ẽ¹nãu³a² e³kxi²nyhah¹lxin¹ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nxe³ha²kxai³ ĩh¹jau³la³ wãn³txa² wa³sut3jau³la³te²la¹xã³? “Wxa²ko̱³nxe³ti³ kãi³in¹ju³ta² sa²wa²su¹txa²ha¹wi¹.” Nxe³jau³xai²la³ta̱³nxa²: “Ĩ³ton³jah¹lãi³. Ĩ³sa²yxau³sxã³ ã³nxĩ³xi¹sẽ¹li¹.” Nxe³jau³xai²la³ta̱³nxa² nxe²hĩ̱³ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yxãn¹ta¹ Txai²na² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²kah³lo²su² na¹ha²kxai³ wxi²ka¹na¹ju³ta² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Nxe³ha²kxai³ ĩ³ton³jah¹lo² ĩ³nxai²na² ĩ³ye³kxi¹nxa²ha¹wi¹. Ĩ³sa²yxau³txi¹. Wxa²sxan¹ka³lo³ai²na² sa²so¹sxã³ ã³nxĩ³txu¹li¹. Nxe³nxa²ha¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nxe²e³ta³lun²nũ²la² kan²ta³kxi²jah¹la² wã²nxũ̱h¹lxi³ ĩ³sa²yxau³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ ã³nxĩ³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nxa²ha¹te¹ a²nũ²a²nãu³xai²na² ã³si³tẽ³kxi²te²nãu³xai²na² ju¹tai²na² ĩ²ain¹sxã³ ka³lih³kxain¹ta¹hxai²hẽ¹la². Ka³lih³kxain¹sxã³ Txa²wã¹sũ̱³na² sa²nẽn¹kxi²i² wxi²kin³ti³to³ni² nxe³yain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² kãin²jah¹lo²su² na³li¹, a²nũ²a² nxe² ĩ³hxi²ka¹tha²kxai³lu¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nxe³nũ²la² ã³nxai³nũ²la² in³txa² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txa² ka³na³ka³na³jah¹la² ĩ³ha¹txi²ta¹hxai²hẽ¹la². Ma³te²ah³lo²su² nha²ta¹hxai²hẽ¹la². A²nxe³jah¹la² sa²kxai³lu² Ro³ma²no²ko³xan¹ta² hxi²kan¹jah¹la² te²hi²sen³su² ĩ³sa²si¹hã³ta¹hxai²hẽ¹la². A²nxe³jah¹la² ã³wxe³sxã³ ũ³yho³hi²ki³ka² so¹kxi²ju³ta² o²la³kxi²ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ Je³su²jah³la² hi²sen³kxai³lu² ã³wa²to¹tain¹tãu³ ĩ²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Ã³si³tẽ³kxi²sẽ¹li¹. Je³su²jah³lai²na² wãn³txa² nxe³ta¹hxai²hẽ¹la². Nxe³nũ²la² Ma³te²ah³lu¹ta²kxai³lu² ĩ³sa²yxau³nũ²la² ã³si³tẽ³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hã²wxãn³txa³ sxi²ha² ã³wih¹nũ²la² ĩ³yain³te³lhxã³ ã³wxe³ta¹hxai²hẽ¹la². Je³su²jah³la² ã³wxe² a²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txa³ ka³lxa¹tũ̱³ka̱³txa² ã³wxe² a²nũ²a²nãu³xa² ko̱³nxe³ju³ta² kãi³te²su² te²nãu³xa² ka³lxa¹te²nãu³xa² ã³wxe² a²sa³wi³ha³lxi³nãu³xa² ã³wxe² ain¹sxã³ ĩ³yai³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nxe³ju³tai²na² fa³ri³se²a² nũ̱³ka̱³txa² ã³nhai¹tũn³te²nãu³xai²na² ĩ²ain¹ta¹hxai²hẽ¹la². Ĩ²ai¹nha²kxai³ Je³su²jah³la² a²sa³wi³ha³lxi³nãu³xa² ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩ³tih³nxe³nx2ti³jah¹la² sa²kxai³lu² a²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txi³su² a²nũ²a²nãu³xa² ko̱³nxe³ju³ta² kãi³te²su² te²nãu³xa² nxe³te²su² ain¹sxã³ ã³wxe³sxã³ ĩ³yain³ya³hain¹ju³tu¹tai²na² ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ã³wxe³sxã³ ĩ³yain³ya³hain¹sĩn¹te²sin²ta²ku²? Wi¹kãi³jah¹lo²sin¹ke³la³te²kxai³ nxe² ĩ³yain³ya³hai¹nhĩ̱³nx2nxa³wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nxe³jau³xai²na² Je³su²jah³la² ain³kxain¹tãu³, ĩ³wa²lũ³xain¹te³nah¹lxi¹: — A²nũ²a² wi¹lain³kxi²nha² te²hi²sen³su² hĩ³ne³kxa² wa³kxẽn³yah³la² ã³ten³te²sxa³yu²hẽ³li¹. Yxãn¹ta¹ a²nũ²a² ĩ³ton³te²su² te²a² so¹lxi³ ã³ten³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Txa²wã¹sũ̱³na² wãn³txa² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: “Wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³nyhu¹ah³lxin¹ju³ta² ten³sa³nhai¹. Yxãn¹ta¹ yen³kxa² ũ³hũ¹sah¹lxin¹ju³ta² so¹lxi³ ten³sa²nxa³nhai¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³jau³jau¹xai²na² a²si³yxau³tãu³a² wi¹ko̱³nha¹jah³lxi³hẽ¹li¹. Jã¹nxe³sxã³ txai²li² hai³txi³ a²nũ²ai²na²: “Wi¹lhin¹sa³nha¹. Ko̱³nxe³ti³ kãi³a¹ju³ta² yũ²nxa³nha¹.” Nxe³te²su² te²na² ĩ³kaix1so¹te³lhxã³ wxãn²nxa³wi¹. Yxãn¹ta¹ a²nũ²a² ko̱³nxe³jah¹la² so¹lxi³ ko̱³nxe³ti³ kãi³ju³ta² ĩ³ãin²ta³kxi²nha²sxã³ ã³na¹la³kxi²nha²te²su² te²na² so¹lxi³ wxa²wa²su¹tain¹te³lhxã³ wxã³na¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nxa²ha¹te¹ Jo³ãu² Ba³tis²jah³la² sa³wi³ha³lxi³nãu³xa² wxã³sxã³ ĩ³wã̱³txain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Nxe³sa²lxi¹. Fa³ri³se²a² nũ̱³ka̱³txi³nãu³xai²na² Jo³ãu² Ba³tis²jah³la² a²sa²wi³ha³lxi³na² nxe³sĩn¹sxã³ Txa²wã¹sũ̱³na² ĩ³ka³li³kxi²te³lhxã³ heh³lxi² yxau³sĩn¹to³ha¹wi¹. Yxãn¹ta¹ wxa²sa³wi³ha³lxi³nãu³xa² hai³txi³ ti³he¹nxai¹nxa³wi¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ heh³lxi² yxau³ain¹to³hxa³ji¹ku¹. Sĩ¹na¹nhai¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Yxau³nuh¹nx2ta¹tãu³a² ĩ³ãin²ta³kxi²nha²sxã³ heh³lxi² yxau³yah³lxin¹ju³ta² wai³nxa³wi¹. A²nxe³ju³ta² in³txa² txu¹ha² so¹nyhu¹kxai²nãn²tu̱³ a²ya̱³la²nãu³xa² ĩ³kaix1so¹yhain¹te²ju²hẽ³li¹. Ĩ³kaix1so¹sxã³ ã³yãn³nũ²kxi²sxã³ kãin² ĩ³yain³ya³hain¹te²ju²hẽ³li¹. Nxe³ju³ta² sa²kxai³lu² a²wẽ³sãi¹yah³la² yxau³ye²yhai¹nhĩ¹na¹ ĩ³kaix1so¹ain¹tũ̱³ka̱³txai²na² ĩ³ãin²ta³kxi²nha²sxã³ heh³lxi² yxau³ain¹ju³ta² wai³nxa³wi¹. Yxãn¹ta¹ yxan¹nãu³a¹ a²wẽ³sãi¹yah³lai²na² so¹kxain¹sxã³ sa²tã³tĩ̱¹kxi²nyhain¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ nxe³hĩ¹na¹ a²nũ²a² ĩ³kaix1so¹ain¹tũ̱³ka̱³txa² ĩ³ãin²ta³kxi²nha²sxã³ heh³lxi² yxau³ain¹ju³ta² wain³tu¹wi¹. Jã¹nxe³ju³kxai³lu² fa³ri³se²a² nũ̱³ka̱³txai²na² Jo³ãu² Ba³tis²jah³la² a²sa³wi³ha³lxi³nãu³xai²na² nxain¹sxã³ txa²wã¹yah³la²nãu³xu¹tai²na² wãn³txa² sa²yxo²wet1si¹hain¹jau³su² heh³lxi² yxau³ain¹te²ju²hẽ³li¹. Ne³to³ta¹ txa²sa³wi³ha³lxai²na² sa²kxai³lu² ã³waix3txai¹na¹hĩ¹na¹ so¹lxi³ heh³lxi² yxau³ain¹tu¹wi¹. Ã³waix3txa¹na¹kxe³su² ĩ³ãin²ta³kxai¹nha²kxai³ heh³lxi² yxau³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jã¹nxa¹jau³su² a²nũ²a² wã²la² ũ³whi²kxi²nha²ka³lo³ai²na² tĩ³ka³lo³a² ã³ten²ti³kxai²nãn²tu̱³ hai³txi³ tah²ka³lo³a² ũ³nhũ²kxi²sxã³ ũh³yxãi¹ain¹te²sxa³yu²hẽ³li¹. Tah²ka³lo³ai²na² ũ³nhũ²kxi²ki̱³ke³la³te²kxai³ ũ³wha̱t3kxai²nãn²tu̱³ tah²ko³lo³ain²ti³ ĩ³jot1sa²kxai³ tĩ³ka³lo³a² ĩ³jot1txa³ha²kxai³ nxe³sxã³ ã³ten²ti³hĩ̱³nx2na³li¹. Te²yã¹nxe³kxe³hũ̱³nxe² txa²wã¹yah³la²nãu³xu¹tai²na² wãn³txa² a̱in³so¹ki̱³sxã³ hã²wxãn³txa³ te²yã¹nxe² Txa²wãn³txa² ã³ki³ka³ti³kxi²ki̱³kxai²nãn²tu̱³ nxe³ju³kxai³lu² wai³nxa³wi¹. Txa²wãn³txa² so¹lxi³ a̱in³so¹kxi³ju³ta² wain³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te²yã¹nxe³jau³su² hai³txi³ ka³yxuh³xa² wã²lẽ¹na² tĩ³ka³lo³ẽ¹nãn²ta³ yain³txi³yau³xa² txah²yau³xa² ã³nẽ¹na³wi¹sxã³ ũ³wha̱³ki̱³te²sxa³yu²hẽ³li¹. Ã³nẽ¹na³wi¹sxã³ ũ³wha³ki̱³ke³la³te²kxai³ a²yain³txi³yau³xai²na² sa²kxai³lu² wã²lẽ¹nai²li² ĩ³txi³ha̱u³kxi²sxã³ ĩ³khot3sxã³ a²yau³xa² ã³nẽ¹na³hxa³te²ju²hẽ³li¹. Nxe³ha²kxai³ a²yain³txi³yau³xain²txi³ ha³li³hxa³ni² a²ẽ¹nãin²ti³ ã³kho³ti² nxe³te²ju²hẽ³li¹. Yxãn¹ta¹ yain³txi³yau³xa² tah²yau³xan²ta³ wã²lẽ¹na² ta²hẽ¹nãu³a² ã³nẽ¹na³wi¹sxã³ ũ³wha³ki̱³te²ju²hẽ³li¹. Nxe³ki̱³kxai²nãn²tu̱³ a²ẽ¹nai²na² ã³khot3txa³ha²kxai³ a²yain³txi³yau³xa² ã³nẽ¹a³na¹xa³ha²kxai³ nxe³te²ju²hẽ³li¹. Te²yã¹nxe³kxe³hũ̱³nxe² Txa²wãn³txa² a²ha³tih³xa² sa²yxo²we¹tha²kxai³ txa²wã¹yah³la²nãu³xu¹tai²na² wãn³txa² a²ha³tih³xa² sa²yxo²we¹tha²kxai³ nxe³ju³kxai³lu² wai³nxa³wi¹. Txa²wãn³txa² hãi¹nxe³jau³xa¹ sa²yxo²we¹ju³ta² so¹lxi³ wain³na³li¹. Nxe³jau³su² Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nxa²ha¹te¹ wãn³txai²na² e³ta³lun²nxa³ta̱³lxa¹ Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² a²wa³kxẽn³yah¹la² ã³tĩ̱³ta¹hxai²hẽ¹la². Ã³tĩ̱³sxã³ Je³su²jah³la² a²ne³kxai³tãu³a² ã³ka³ti³wxe³ta¹hxai²hẽ¹la². Ã³ka³ti³wxe³sxã³ ĩ³ye³te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²ka³ne³lxa² kwẽn¹ta²kxai³ ya³lu²kxi²sa³na²li¹. Yxãn¹ta¹ ya³lu²kxi²sa³kxan²ti³ ã³wxãn¹ju³ta² ten³sa³nhai¹. Wxãn¹kxai²nãn²tu̱³ txa²wẽ³sai²li² wxa²wxain¹kxai²nãn²tu̱³ ka³te̱n³sa²xi²tu¹wi¹. Nxe³ju³tai²na² ten³sa³nhai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nxe³ha²kxai³ ĩ³sa²yxau³sxã³ ã³wxã³ta¹hxai²hẽ¹la². A²sa³wi³ha³lxi³nãu³xa² ã³si³tẽ³la³kxain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nxa²ha¹te¹ ã³wxã³ain¹ti̱³kxai³lu² txu¹ha³ka³lxa² aun³ta² tĩ̱³xain¹ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxai²na² kãin² ĩ³ton³to³ta¹hxai²hẽ¹la². Hxi²ka² hxan³sxã³ ha¹li¹ wxa²hait1so¹xi²nũn³txa³ kwẽ³ko³nhĩ¹nai³tã² sa²kxai³lu² ĩ³si³ti³hon³ka³txa² ã³nĩ³ton³ãn³si³wxe³ha²kxai³ nxe³hĩ¹nãn¹te²tu̱³ ĩ³to³nxi²tu³ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxai²na² Je³su²jah³la² yon³nãu³a¹ ã³tĩ̱³ha²kxai³ a²wã²la²ka³lo³a² wxa²to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nxe³sxã³ a²ẽ¹nãn¹jau³kxai³lu¹: — Je³su²jah³lai²na² wã²la² kwa²hãi¹nxe² wxa²to³ha¹kxai²nãn²tu̱³ we²nxi²sa³tũ¹xã¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nxe³tãu³ Je³su²jah³lai²na² sa²kxai³lu² sa²wa³ti̱³nha²sxã³ ĩ³ye³te³nah¹lxi¹: — Nxex3sa²nxi¹. Ĩ³nxũ²kwa̱i³lxũ¹txi³nha¹sẽ¹ni¹. Yxo²ĩ²sa¹nha²kxai³ we²nxi¹nxi¹. Nxe³jau³su² nxe³tãu³ a²kwẽn¹tai²na¹ ta¹ka³lxai²na² ĩ³ta³ka³txa² we²nxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nxe³nũ²la² a²wa³kxẽn³yah³lai²na² sxi²ha² ã³nxai³sxã³ ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². Ã³tĩ̱³sxã³ ã³wih¹te³na¹ a²nũ²a² ka³lxa²tũ̱³ka̱³txa² wãi²lhũ̱³ka³txa² kãin² hai³ni² ã̱³xa² nũ̱³ka̱³txa² ã³ka³nxẽ¹ka³nxẽ¹ka³nxe² kãi²nxon³yã¹nxe² nxe³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nxe² ĩ²sxã³ ĩ³ye³kxain¹te³nah¹lxi¹, Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Nxex3jah³lxi³hẽ¹li¹. Ã³waix3kxi¹jah³lxi³hẽ¹li¹. Hai³txi³ wẽ³sa³la³ ya³lu²nxa³wi¹. Hãi¹sxã³ ãu³xi²na²li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²nũ²a²nãu³xai²na² yxo²ĩ²nyhai¹nxa³jau³su² ĩ³yxo²kwa³lxi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nxe³nxa²ha¹te¹ tũ̱¹ka̱³txai²na² ã³waix3si¹hain¹jau³kxai³la¹ sxi²ha² ã³wi²xi²ta¹hxai²hẽ¹la². Ã³wi²xi²sxã³ wẽ³sai²na² a²hxi²kai²na² hxi²ki³sxã³ sa²yxo²ka³ta³wxe³ta¹hxai²hẽ¹la². We²nxi²khaix1nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jã¹nxe³jut3su² wẽ³sa² we²nxi²ju³ta² u²lxi³ ha³ta̱³nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nxa²ha¹te¹ Je³su²jah³la² ãh¹ã³nxai³nũ²la² in³txa² ha¹li¹ a²yo³na² ã³si³tẽ³kxi²ya³ta¹hxai²hẽ¹la². A²nxe³ya³jah¹la²nãu³xa² ye³han³ya³ta¹hxai²hẽ¹la². A²nxe³sxã³ ã³si³tẽ³kxi²ya³sxã³ ĩ³kaix1ja³te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lo³txa²kah³lo²si¹lxi¹. Nxĩ¹nha²kxai³ ye³han³sa²sĩn¹ju³tai²na² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sa²sĩ¹nhẽ³li¹. Nxe³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² sxi²ha² ã³wih¹nũ²la² hã²wxãn³txa³ ye³han³jah¹la³nãu³xai²li² ã³wih¹sxã³ ã³tĩ³ya³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Je³su²jah³la² ĩ³wã̱³txi³te³nah¹lxi¹: — Nxex3jah³wxi¹. Hxi²kan¹txi³ we²txi²nx2ta¹ju³ta³nũ³a² yxo²ĩ²sya¹te³sin¹ji¹wi¹? Nxe³ta¹hxai²hẽ¹la². Nxe² ĩ³wa²lũ³xi²ya³te³nah¹lxi¹: — Yxo²ĩ²nxa²sĩ¹na¹nha²wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nxe³ka³tu̱³ wxa²ye³wxai³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³jah³wxi¹. Yxo²ĩ²sya¹hi¹nha²kxai³ wxa²we²txi¹nx2ta¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nxe³tãu³ ye³we²txi²ya³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ yxo²sa³te̱¹txi³ ĩ³ye³kxi²te³nah¹lxi¹: — We²txi¹nx2ta¹wi¹. Yxãn¹ta¹ ju¹tai²na² a²nũ²a² ã̱³xa² ĩ³yau¹ũ³nha²ya³txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nxe² ĩ³ye³kxi²kxan²ti³ Je³su²jah³lai²na² nũ³kxũn³sxã³ o²la³kxi²ju³ta² a²nũ²a²nãu³xa² a²yxo²ha³kxa¹ ĩ³yau¹ũ³nyha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nxa²ha¹te¹ in³txai²na² ye³we²txi²ya³te²na² a³li³xi²tãu³a² a²nũ²a²nãu³xa² ya̱u³son³kxi²ta¹hxai²hẽ¹la². Nxe³te²nãu³xa² in³txa² yxo²ka³tũ³nha²kxai³ ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³yxau³ha²kxai³ a²nxe³te² in³txa² ã³sa²so¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nxe³sxã³ Je³su²jah³lai²na² sa²kxai³lu² jut3sĩ²nũ²la² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³si¹jau³su² kwa³na³ta¹hxai²hẽ¹la². Nxe³ha²kxai³ ya²la³tu̱³ nxũ²kwa̱i³li³ha²kxai³ yxo²ka³tũ³ju³ta² yxo²we²txi²ha²kxai³ ta¹hxai²hẽ¹la². A²nxe³jut3su² ã³si³tẽ³la³kxi²te²nãu³xa² ju³ta² ĩ²nũ²la² ĩ³wã̱³wã̱³txi²sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²wã¹ha³lo²ai²na² I³sa³e²ko³nãu³a² hai³txi³ ĩ²ki̱³sxa³ju³tai²la¹wi¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nxe³yãn¹ta¹ fa³ri³se²a² nũ̱³ka̱³txai²na² ã³nhai¹tũn³te²nãu³xai²na² wãn³txa² ki³han³jau³su² ĩ³wa²lũ³xain¹te³nah¹lxi¹: — A²ta³a² hxi²kan¹jah¹lo²su² te²a² a²sa³wi³sxai²la¹wi¹. Nxe³ha²kxai³ ĩ³hxi²ka¹txai¹nha²kxai³ ko̱³nxe³te² yãu³ka³txa² a³li³si¹jau³su² kwa³na³in²tai¹. Txa²wã¹sũ̱³nu²su² ti³he¹xai¹nxa³wi¹. Fa³ri³se²a² nũ̱³ka̱³txai²na² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hã²wxãn³txa³ sxi²jen³nãu³a² kãin²thĩn³su² ta̱³nxa² kãi²nxa³thĩn³su² ta̱³nxa² hãi¹nxe³thĩ³na¹ ai³lha²thet3ta¹hxai²hẽ¹la². Nxe³tãu³a² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih¹to³ha²kxai³ Sũ̱³na² wãn³txa² ĩ³hen³txi² Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹txa² Si³yxau³tãu³lot3ju³ta³nũ³a² nxe³jau³xa² ĩ³yau¹ũ³hi² a²nũ²a² ĩ³ta³ka³txa² whãi²na¹ we²txi² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nxe³sxã³ a²nũ²a² ã³si³tẽ³la³kxi²tũ̱³ka̱³txi³su² ĩ²sxã³ ĩ³ãin²ta³lxi²nha²ta¹hxai²hẽ¹la². Nxe³sxã³ a²ẽ¹nãn¹jau³kxai³lu¹: — Tũ̱³ka̱³txai²na² o³ve²a² yã¹xain¹na³na¹. Tĩh³na² tĩ¹kxi²kxai²nãn²tu̱³ kwa²hãi¹nxe² ã³nxai³lha²the³ti² kwa² khãuh³lxa³thi¹ni² nxe³te²ju²hẽ³li¹, o³ve²a² a²wa³kxẽ³nxa² yũ²nxa³te²na²su² nxe³kxe³hũ̱³nxe² tũ̱¹ka̱³txai²na² yã¹xain¹na³na¹. Nxe²e³kxi²nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nxe³ha²kxai³ a²sa³wi³ha³lxa² ĩ³ye³kxi²te³nah¹lxi¹: — Tũ̱³ka̱³txai²na² sa²kxai³lu² hai³sxa² yain³txa² sxa³ko³xa² wi¹wen¹ko³xa² yã¹xain¹na³li¹. Yxãn¹ta¹ wxa²ni²lho¹kxi³tũ̱³ka̱³txa² ka³lxa²ti³he¹xai¹nxa³wi¹. Nxe³kxa² yã¹nxe³sxã³ a²nũ²a² yxo²ĩ²sain¹te³lhxã³ te²nũ³su² te²nãu³xa² ka³lxa¹na³li¹. Yxãn¹ta¹ ĩ³yau¹ũ³nyhain¹te²nũ³su² te²nãu³xa² ka³lxa¹txi³he¹xai¹nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nxe³ha²kxai³ hai³sxa² Wa³kxẽ³nxa² Si³yxau³jah¹la² Txa²wã¹sũ̱³na² Si³yxau³jah¹la² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. Wxa²so¹tũ̱³ka̱³txa² ã̱³xa² ã³nũ²kxi²sxã³ ĩ³kaix1tain¹si¹ki̱³jau³su² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² a²sa³wi³ha³lxa² hxi²ka²hxan³sxã³ ha¹li¹ wxa²hait1so¹xi²nũn³tũ̱³ka̱³txa² ĩ³kaix1ta¹hxai²hẽ¹la². Ĩ³kaix1sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³sa²si¹hã³nx2ta¹tu¹wi¹. A²nũ²a² ĩ²lu³te²a² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³yxau³kxai²nãn²tu̱³ hxi²kan¹txi³ nxũ²kwa̱i³li³ain¹sih¹nx2ta¹jau³su² ĩ³sa²si¹hã³nx2ta¹ha²kxai³ a²nũ²a² ĩ²lu³te²a² a²ĩ³ta³ka³txa² ĩ²li³ka³txa² we²txain¹sih¹nx2ta¹jau³su² ĩ³sa²si¹hã³nx2ta¹ha²kxai³ jã¹nxe³te³lhxã³ nx2ta¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jã¹nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² ĩ³lxi²hain¹jau³xa²sa¹. A²wi¹lhĩ¹nãn¹jah¹la² sa²kxai³lu² Si³mãu²ah³la² ta̱³nxa² Pe²jah³la² ta̱³nxa² nxe³jau³xa² yau³ha¹li¹ ĩ³yĩ¹li²te²ju²hẽ³la². A²lon³yah³la² Ãn³tre²ah³lo²su² ta¹hxai²hẽ¹la². Ti³a²kah³la² a²lo³nai²li² Jo³ãu²ah³la² nxe³ya³ta¹hxai²hẽ¹la². A²nxe³ya³te²na² a²wĩ³nu²su² Se³be³te²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fi³li²pah³lo²su² ha²kxai³ Bar³to³lo³me²ah³lo²su² ha²kxai³ ta¹hxai²hẽ¹la². To³me²ah³lo²su² ha²kxai³ Ma³te²ah³lo²su² a²nũ²a² ũ³yho³hi²ki̱³ki³a² so¹kxi²nẽ³jah¹lo²su² ha²kxai³ ta¹hxai²hẽ¹la². Ti³a²kah³la² Au³fe²ah³la² a²tah²su² ha²kxai³ Le³be²ah³la² Ta³te²ah³la² nxe³ĩ³lxa² ha¹li¹ ĩ³yĩ¹li²te²ju²hẽ³la². Nxe³jah¹lo²su² ha²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Si³mãu²ah³lo²su² ha²kxai³ a²nxe³te²a² ã̱³lxi³sxã³ se³lo²ti³nũ̱³ka̱³txi³si²ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ Ju³tas² Is³ka³ri³o²jah³lo²su² yxan¹nãu³u¹ta²kxai³ ko̱¹ko̱¹xa² hxi²ka²nãu³a¹ Je³su²jah³la² ã³yũ³ain¹jah¹lo²nũ³su² ha²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A²nxe²te² in³txi³nãu³xai²li² a²sa³wi³ha³lxi³khai³su² ha²kxai³ ĩ³sa²si¹hã³si¹hain¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩ³sa²si¹hã³nx2ta¹tu¹wi¹. Nxe³nx2ta¹kxai²nãn²tu̱³ hai³txi³ Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³lxa³ ai³yah³lxa³nha²kxai³ Sa³ma³ri³tã²na² sxi²jen³ti³la³ ai³yah³lxa³nha²kxai³ nxe³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Hãi¹nxe³sxã³ I³sa³e² nũ̱³ka̱³txa² a²sxi²ti³nãu³xai²na² so¹lxi³ ai³jah³lxi³hẽ¹li¹. Tũ̱¹ka̱³txai²na² sa²kxai³lu² o³ve²a² aun³tih¹sa³tĩ¹lxi³te²a² a²wa³kxẽn³yah³la² ĩ²te²sxa³yu²hẽ³li¹. Nxe³kxa²yã¹nxe³ju³ta² tũ̱¹ka̱³txai²li² Txa²wã¹sũ̱³na² ĩ²ai¹nxa³tũ̱³ka̱³txi³su² na³li¹. A²nxe³txa³nũ̱¹ka̱³txai²na² so¹lxi³ ai³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nxe³sxã³ ai³yah³lxin¹kxai²nãn²tu̱³ wãn³txa² wi¹jau³xa² ĩ³hen³txi³txain¹jah³lxi³hẽ¹li¹. Nxe³ain¹yah³lxin¹te³nah¹lxi¹: “Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lon³ju³ta³nũ³a² wxã³ti³wa³ki³lxon³na³li¹.” Nxex3tain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nxe³yah³lxin¹tãu³a² ĩ³ta³ka³txa² ĩ³ton³te²a² we²txi²yah³lxi¹nha²kxai³ a²nũ²a² ya³lu²kxai²nãn²tu̱³ ka³te̱n³su² ĩ³sa²yxau³xi²si¹yhah³lxi¹nha²kxai³ a²nũ²a² khon³ta³kxi²sxã³ ka̱³lã̱un³ta³kxi²te²a² ĩ³we²nxi²yah³lxi¹nha²kxai³ a²nũ²a² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³yxau³te²na² ĩ³nxũ²kwa̱i³li³si¹jau³su² kwa³na³yah³lxi¹nha²kxai³ nxex3jah³lxi³hẽ¹li¹. Wã²nxũ̱h¹sxã³ ĩ³hxi²ka¹txa²lxa¹wi¹. Yen³kxa² ũ³yho³hi²sah¹lxin¹ju³ta² ten³sa²nxa³nhai¹. Nxe³nx2ta¹kxa²yã¹nxe³sxã³ wi¹kãi³yah³lxin¹kxa²yo³ha² so¹kxi²yah³lxi³txa³hẽ¹li¹. Wã²nxũ̱h¹lxi³ a²nũ²a²nãu³xai²na² hxi²nũn¹tai¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jã¹nxe³sxã³ ai³yah³lxin¹kxai²nãn²tu̱³ ũ³yho³hi²ki³a² ou²ro²ki³su² ta̱³nxa² pra²ta²ki³su² ta̱³nxa² ko²bre²ki³su² ta̱³nxa² sa²so¹sxã³ tẽ³yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wã²lẽn¹ta³ tẽ³xãn³nha²kxai³ wã²la²ka³lo³la³ ka³lo³ã̱³ka³lo³la³ tẽ³xãn³nha²kxai³ yu³wi²kxi²nhãn¹ka³lo³la³ ko³lo³ã̱³ka³lo³la³ tẽ³xãn³nha²kxai³ tãu²ka³ta³la³ tẽ³xãn³nha²kxai³ nxe³jah³lxi³hẽ¹li¹. Nxe³sxã³ ã³nhxi²nũn¹ta³kxain¹yah³lxin¹te²su² te²na² yen³kxa² wã²nhũ¹nx2ti³tu¹wi¹. Nxe³ju³tai²na² wain³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nxe³ha²kxai³ ai³yah³lxin¹tãu³a¹ sxi²jen³na² ã³wih¹yah³lxin¹kxai²nãn²tu̱³ thĩ¹nai²na² yxau²xai³te²a² wi¹lhin¹sxã³ sxi²lho³nx2ti³te²a² ã³ten³jah³lxi³hẽ¹li¹. Nxe³te²he³la³kxah³la² a³txi²yah³lxin¹kxai²nãn²tu̱³ nxe³thĩ³nai²na¹ yau²xai³jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jã¹nxe³sxã³ sxi²ha² ã³wih¹yah³lxin¹kxai²nãn²tu̱³ wi¹lĩ³hen³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nxe³yah³lxin¹kxai²nãn²tu̱³ sxi²ha² yxau²xai³tũ̱³ka̱³txa² wi¹lhin¹kxi² sa²wi¹son¹nx2ti³kxai²nãn²tu̱³ a²wi¹lhin¹yah³lxin¹ju³ta² yxau³ya³nx2ti³tu¹wi¹. Yxãn¹ta¹ wi¹lhin¹kxi² sa²wi¹son¹nx2ti³xa³kxai²nãn²tu̱³ a²wi¹lhin¹yah³lxin¹ju³ta² yxau³ya³nx2ti³xa³lho³li¹. Sa²wa²li¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te²yã¹nxe³sxã³ sxi²je³na² ĩ²li³jen³su² je³nãn²tu̱³: “Wxãi²na² ten³nxa²lxi³sĩ¹nxa³nhai¹.” Nxe³nx2tain¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txi³la³ ain³kxi²ti³ten³ti³he¹xai¹nxa³kxai²nãn²tu̱³ sxi²je³nai²nãn²tu̱³ wa²li³jah³lxi³hẽ¹li¹. Wa²li³yah³lxin¹kxai²nãn²tu̱³ kĩ̱h³nũ³xa² wxa²yu̱³kxa² ti³son¹tũ̱³xa² ti³yu̱³tu̱n³ta³kxi²nha¹jah³lxi³hẽ¹li¹. Nxe³ain¹yah³lxin¹kxai²nãn²tu̱³ ko̱³nxe³ti³ kãi³ain¹ju³ta² ĩ³yau¹ũ³ain¹yah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Kxã³nãu³u¹tai²na² So³to²ma²thĩ³nu¹tai²na² Ko³mo²ra²thĩ³nu¹tai²na² ha¹lin¹thĩ³nu¹tai²na² ko̱³nxe³thin¹khai¹nxe³thĩn³sain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Nxai¹nha²kxai³ yxan¹nãu³a¹ Txa²wã¹sũ̱³nu²su² te²hi²sen³su² ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² sa³te̱¹txi³ ũ³yho³hain¹tu¹wi¹. Yxãn¹ta¹ sxi²jen³ta³ en²nxa²lxain¹thĩ³na² ã²la² sa³te̱¹txi³ ã³wa²tot1sxã³ ũ³yho³hain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nxe³jah³lxi³sa²lxi¹. O³ve²a² yã¹yxah³lxi¹lxi¹. Tũ̱¹ka̱³txai²na² ĩ³sa²si¹hã³nx2ta¹tũ̱³ka̱³txai²na² hau³xa² yã¹nxain¹na³li¹. Ko̱³nxe³ti³ kãi³sxã³ yxau²xai³ju³ta² so¹lxi³ te³nain¹na³li¹. Nxe³ha²kxai³ ĩ²khai¹nxe³jah³lxi³hẽ¹li¹. Jã¹nxe³sxã³ txih³xa² ne³kheh¹te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe² ne³kheh¹khaix1nxe³jah³lxi³hẽ¹li¹. Te²yã¹nxũn³sxã³ kwa³sxa³xa² wi¹lhin¹te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe² wi¹lhin¹khai¹nxe³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jã¹nxe³jut3su² te²yã¹nxe² a²nũ²a² ĩ²khai¹nxe³jah³lxi³hẽ¹li¹. Nxe³jah¹lai²li² khãuh³lxa³thi¹txa²lxi³ha³tai¹. Wxa²hxi²kan¹txi³nãu³xa² ã³sa²so¹nx2ti³ha³tai¹. Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³sa²so¹nx2ti³sxã³ ĩ³ta³lo³su²nx2ti³ha³tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yxo²ĩ²sah³lxin¹ju³tan¹te²kxa³ya̱³lhu² wxa²ha³lo²a² wxa²wa³kxẽ³nxa² si³yxau³kxa³ta² Ko³ver³na³to²yah³lo²su² ha²kxai³ ã³sa²so¹nx2ti³ha²kxai³ wxa²nũ̱³ka̱³txa² a²wa³kxẽ³nxa² si³yxau³kxa³ta² pre³si³tẽn²jah³lo²su² ha²kxai³ ã³sa²so¹nx2ti³ha²kxai³ nxe³nx2tai¹nha³tai¹. Nxe³nx2tain¹kxai²nãn²tu̱³ yxo²ĩ²sah³lxin¹ju³ta² ĩ³wã̱³txi¹nx2tain¹tu¹wi¹. Nxe³nx2tain¹kxai²nãn²tu̱³ tũ̱¹ka̱³txai²na² whãi²na¹ Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³xa² whãi²na¹ nxe³sxã³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³hen³txain¹yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nxe³yãn¹ta¹ nxe³nx2tain¹kxai²nãn²tu̱³ hxi²waun³txi³yah³lxi³txa³hẽ¹li¹. Nxe³yah³lxin¹jau³su² nxe³yah²lxan³te³nah¹lxi¹: “Ĩh¹nxe³ ĩ³wa²lũ³xai¹na¹lhon³ku¹. Ĩh¹nxe³jau³ta̱³ ĩ³ye³kxai¹na¹lhon³ku¹. Nxa¹nha¹.” Nxe³jau³su², nxe²e³yah³lxi³txa³hẽ¹li¹. Nxe²nxa³ha²kxai³ ĩ³wa²lũ³xi²yah³lxi¹nhĩ¹na¹ wãn³txa² wain³jau³xan²tu̱³ wi¹ko̱³nh²yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wxa²wãn³txi³khai³sxu² e³yah²lxan³tho³li¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² Yãu³ka³jxah¹lai²na² wãn³txa² a²yxo²e³jau³su² yũ³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","Nxe³hĩ¹nai²na² yxo²ĩ²sah³lxin¹ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² ka³lxa¹txi³ ĩ³a̱n³ta³kxi¹nx2tain¹tu¹wi¹. A²nũ²a² yxo²ĩ²xa³te²na² sa²kxai³lu² a²lon³khai³xa² ĩ³su²lhã³si¹jau³su² ã³yũ³so¹ain¹tu¹wi¹. A²wĩ³na² sa²kxai³lu² a²wẽ³sa² khai³xa² ã³yũ³so¹ai¹nha²kxai³ a²wẽ³ha³lxai²na² sa²kxai³lu² a²wĩ³na² a²hã³ka³na² nxe³sxã³ ã³yũ³so¹ai¹nha²kxai³ nxe³ai¹nha³tai¹. Te²yã¹nxe³jut3su² nxe³nx2tain¹kxai²nãn²tu̱³ sa²yxo²ã³syah¹lxi³txa³hẽ¹li¹. Sa²yxo²ã³syah²lxan³kxai²nãn²tu̱³ kxã¹nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³a² yxau²xai³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jã¹nxe³jut3su² sxi²je³nai²na² ĩ²li³jen³su² khãuh³lxa³ti¹nx2tain¹kxai²nãn²tu̱³ sxi²je³na² nĩ³nã̱³sa²nũn³thĩ³na² aun³txi²xai³jxah³lxi³hẽ¹li¹. Wãn³txi³khai³su² e³kxi¹nx2ta¹wi¹. I³sa³e²ko³xan¹ta² sxi²je³na² thĩ³ka³lxa²khai¹nxe³te²jai¹ti²tu³wi¹. Ka³lxa¹ha²kxai³ hxi²kan¹txi³ sxi²yhen³ti³nãu³xa² whãi²na¹ ai³lha²thet3jah³lxan³tho³li¹. Nxe³yah²lxan³nxa³ta̱³lxa¹ Txai²li² ne³ka³ta²sxã³ a³ka³nxi²sxã³ ã³wa̱³li²sã²na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jã¹nxe³jut3su² ha³te̱h³nxã³nxa² o²la³kxi²ta³lu²nxa³jah¹la² kãi²nxa³wi¹. Yxãn¹ta¹ ĩ³tih³nxe³jah¹la² kãin²ti²lã²na³li¹. Te²yã¹nxe³sxã³ a²sa³wit3su² hxi²ka¹nxa³wi¹. Yxãn¹ta¹ a²sũ̱³nu²yah³lo²khai³xa² hxi²kan¹ti³lã²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jã¹nxe³jut3su² a²nũ²ai²na² ha³te̱h³nxã³nxa² ĩ³tih³nxe³kxa² yã¹nxe³te²lo³te³lhxã³ yã¹nxe³kxai²nãn²tu̱³ e³lain¹te³nah¹lxi¹: “Ĩ³tih³nxe³jah¹lai²la¹wi¹.” Nxe³te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ hxi²kan¹kxa² yã¹nxe³te²lo³te³lhxã³ yã¹nxe³kxai²nãn²tu̱³ e³lain¹te³nah¹lxi¹: “Hxi²kan¹jah¹lai²la¹wi¹.” Nxe³kxa² yã¹nxe³sxã³ wxa²hxi²kan¹txa² si³yxau³jah¹lo²su² te²sa¹kan²ti³ e³lain¹te³nah¹lxi¹: “A²ta³a² si³yxau³jah¹lai²la¹wi¹.” Nxe³ha²kxai³la¹ wxãi² ĩ³nxai²na² txa²sa³wi³ha³lxi³su² yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² e³lain¹tu¹wi¹. Nxain¹te³nah¹lxi¹: “Ta³nxũ̱¹ka̱³txai²na² a²ta³nũ̱³ka̱³txi³sain¹na³li¹.” Nxe³jau³su² te²ai²li² nxe³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jã¹nxe³jut3su² a²nũ²a² yu̱h³lxah³lxi³txa³hẽ¹li¹. Ko̱³nxe³ti³ kãi³ũh¹nx2tain¹ju³ta³nũ³su² hãi³a² he³son³kxain¹kxan²ti³ Txa²wã¹sũ̱³na² ĩ²kxi²jah¹lai²la¹wi¹. Ĩ²kxi²ha²kxai³ hã²wxãn³txa³ yan¹nãu³a¹ sa²hau³ko³tũh¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ka³nxah³tai²na² wãn³txa² e³kxi¹nx2ta¹jau³xai²na² a³la²ni²tãu³a² a²nũ²a² yxo²ha³kxa¹ jau¹xain²txi³ ĩ³hen³txi³tain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jã¹nxe³jut3su² txa²wã¹nũ²ai²na² ĩ³su²lhã³nẽ³jah¹la² yu̱h³lxah³lxi³txa³hẽ¹li¹. Nxe³te²su² hxi²kan¹txi³ txa²wã¹yãu³ka³txa² ĩ³su²lhã³nẽ³lxa³lho³li¹. Yxãn¹ta¹ wxa²yãu³ka³txai²na² wxa²nũ²ai²na² nxe³sxã³ whãi²na¹ tẽ³sxã³ ha³lo²a² ko̱³nxe³ko³xa² ha³nxe²i̱³sa²tẽ³ko̱³xa² ã³na¹kxi³jah¹la² Txa²wã¹sũ̱³na² Si³yxau³ka³jah¹lai²na² so¹lxi³ yu̱h³lxi³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Txa²wã¹sũ̱³na² wi¹lxa² hau³ko³tũ¹nhẽ³na³li¹. Nxe³ju³kxai³lu² a̱i³ka² wẽ³sa² ha¹lin¹te²su² te²a² hxi²tẽ³nyhah²lxin¹kxai²nãn²tu̱³ ũ³yho³hi²ki³a² ki³ka³na³ka³nat3sxã³ ũ³yho³hi¹nx2ti³hĩ̱³nx2na³li¹. A²yo³ha² kãi²nxa³wi¹, a̱i³ka² a³lxi²nxa³ha²kxai³lu¹. Nxe³kxan²ti³nũ¹ Txa²wã¹sũ̱³na² hi²sen³su² a̱i³kai²na² ki³ka³na³ku² kxan²ti³ yuh³xai²na² a³hi²kxai²nãn²tu̱³ Sũ̱³na²kxai³lu² ĩ²kxi³lxi³hxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jã¹nxe³kxa²yu³su² Txa²wã¹sũ̱³nu²kxai³lu² A²hoh³lxi³ Si³yxau³jah¹lo²su² na³li¹. Wi¹lxa² hau³ko³tũ¹nx2ti³ju³ta² ten³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jã¹nxe³ha²kxai³ hxi²waun³txi²yah³lxi³txa³hẽ¹li¹. A̱i³ka² wẽ³sa² jũ¹nxa² so¹lxi³ a³lxi²hxai²na²hẽ³li¹. Ki³ka³lxa¹txi³ a²nũ²kxi²ki̱³kan²ti³ hai³txi³ a²yoh³la³ kãin²ti³he¹nx2nxa³wi¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² a³lxi² wa³to²hi¹nx2ti³hxai²na²hẽ³li¹. Nxe³nx2ti³ju³tan¹te²kxa³ya̱³lhu² wi¹wi¹nxe² sa²hau³ko³nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","A²nũ²a² ĩ²li³te² ĩ³nxai²na² a²nũ²a² ã̱³xa² ĩ³hen³txi³yah³lxin¹te³nah¹lxi¹: “Je³su²jah³la² a²sa³wit3su²na¹wi¹.” Yah³lxin¹jau³su² yah³lxin¹kxai²nãn²tu̱³ Txa²sũ̱³na² oh³xa² yxau³ta²si³yxau³kxah³la² ĩ³ye³kxi²na¹tu¹wi¹. Nxe³na¹te³nah¹lxi¹: “Jah¹lai²li² txa²sa³wi³sai²la¹wi¹.” Nxe³na¹jau³su² nxe³na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nxe³yãn¹ta¹ a²nũ²a² ĩ²li³te² ĩ³nxai²na² a²nũ²a² ã³xa² ĩ³hen³txi³yah³lxin¹te³nah¹lxi¹: “Je³su²jah³la² a²sa³wit3su²nxa³wi¹.” Yah³lxin¹jau³su² yah³lxin¹kxai²nãn²tu̱³ Txa²sũ̱³na² oh³xa² yxau³ta²si³yxau³kxah³la² ĩ³ye³kxi²na¹tu¹wi¹. Nxe³na¹te³nah¹lxi¹: “Jah¹lai²li² txa²sa³wit3su²nxa³wi¹.” Nxe³na¹jau³su² nxe³na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jã¹nxa¹ju³kxai³lu² wxã³na¹ju³tan¹te²kxa³ya̱³lhu² a²nũ²a²nãu³xa² hãu²non³sxã³ yxau²xai³nyhu¹ah³lxi³ju³ta³nũ³a² yũ²nxa³lho³li¹. Nxe³to³ta¹ he¹kxi²nyhu¹ah³lxi³ju³ta³nũ³a² yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nxe³ju³kxai³lu² wxã³na¹ju³tan¹te²kxa³ya̱³lhu² a²ki³lha³lxai²na² sa²kxai³lu² a²wĩ³na² ã³nhe¹kxi²ha²kxai³ a²ka³ne³lxai²na² sa²kxai³lu² a²hã³ka³na² ã³nhe¹kxi²ha²kxai³, a²sĩ̱³sai²na² sa²kxai³lu² a²hã̱i³na² ã³nhe¹kxi²ha²kxai³ nxe² ã³nhe¹kxi²nyhu¹ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nxe³sxã³ wxa²yu³ta³khai³xa² a²ha³tih³xa² ã³nhai¹son³kxi²yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jã¹nxe³jut3su² a²nũ²a² te² ĩ³nxai²na² sa²kxai³lu² wxa²wĩ³na² wxa²hã³ka³na² nxe³sxã³ a³lxain¹yah³lxi³te²sin¹yu²hẽ³li¹. Yxãn¹ta¹ ã³wa²to²hi² a³lxi²sa²tẽ³sah¹lxan³kxai²nãn²tu̱³ nxe³te² ĩ³nxãn²tu̱³ hxi²kan¹txi³ txa²sa³wi³ha³lxi³lot3sah¹lxan³tho³li¹. Te²yã¹nxe³sxã³ a²nũ²a² te² ĩ³nxai²na² sa²kxai³lu² wxa²ki³lha³lxa² wxa²ka³ne³lxa² nxe³sxã³ a³lxain¹yah³lxi³te²sin¹yu²hẽ³li¹. Yxãn¹ta¹ ã³wa²to²hi² a³lxi²sa²tẽ³sah¹lxan³kxai²nãn²tu̱³ nxe³te² ĩ³nxãn²tu̱³ hxi²kan¹txi³ txa²sa³wi³ha³lxi³lot3sah¹lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nxe³ha²kxai³ ĩ³hit1sah²lxin¹kxai²nãn²tu̱³ ĩ³ye³khãuh³lxa³thi¹nx2tain¹ju³ta³nũ³a² ta̱³nxa² ĩ³su²lhã³nx2tain¹ju³ta³nũ³a² ta̱³nxa² nxe³nx2tain¹ju³ta³nũ³a² yu̱h³lxah³lxin¹ju³tan¹te²kxa³ya̱³lhu² Txa²wãn³txa² sa²yxo²ã³syah¹lxin¹kxai²nãn²tu̱³ hxi²kan¹txi³ Txa²sa³wi³ha³lxi³syah²lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jã¹nxa¹jau³su² wxãi²na² sa²kxai³lu² ĩ³ye³kxi²nyhah¹lxin¹kxai²nãn²tu̱³: “Yu̱h³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²wi¹la¹tãu³a¹ a³lxi²sa³nha¹. Je³su²jah³lai²na² wãn³txa² sa²yxo²ã³a¹kxan²ti³ ya³lu²ju³ta² ten³sa²nxa³nha¹.” Nxe³nyhah¹lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³lyah²lxan³tho³li¹. Yxãn¹ta¹: “Yu̱h³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²wi¹la¹tãu³la³ a³lxi²sa²nxa³nha¹. Je³su²jah³lai²na² wãn³txa² yxo²ĩ²a¹ju³tan¹te²kxa³ya̱³lhu² ĩ³su²lhã³sain¹kxan²ti³ yxo²ĩ²a¹ju³ta² ã³na¹nxa³lho³na¹.” Nxe³yah³lxin¹kxai²nãn²tu̱³ Txa²sa³wi³ha³lxi³syah¹lxin¹tu¹wi¹. Nxe³kxa²yu³su² Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³lyah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jã¹nxe³jut3su² ai³lha²thet3jah³lxin¹tãu³a² wa²su¹wa²sun¹sxã³ ã³wih¹si¹nx2tain¹jau³su² e³kxi²nx2tain¹kxai²nãn²tu̱³ nxe³te²nãn²tu̱³ wa²su¹wa²sun¹sxã³ ã³wih¹si¹sain¹jau³su² e³kxi²sain¹nũn³na³li¹. Nxe³sxã³ wa²su¹wa²sun¹sxã³ ã³wih¹si¹sain¹kxai²nãn²tu̱³ ĩ³sa²si¹hã³sa²jah¹la² wa²su¹wa²sun¹sxã³ ã³wih¹si¹nyhain¹jau³su² e³kxain¹nũn³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Te²yã¹nxe³sxã³ a²nũ²a² ĩ²li³te²a² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹la² wa²su¹wa²sun¹sxã³ ã³wih¹si¹nyhain¹tãu³a² nxe²e³te³nah¹lxi¹: “Jah¹lai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lai²la¹wi¹. Nxe³ha²kxai³ wa²su¹wa²sun¹sxã³ ã³wih¹si¹hai¹na¹tũ¹xã¹.” Nxe³jau³su² nxe³te²nãn²tu̱³ Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹la² ĩ³hen³txi³kxa² yo³ha² yã¹nxe³sxã³ ũ³yho³hi²nyhain¹nũn³tu¹wi¹. Te²yã¹nxe³sxã³ a²nũ²a² wi¹lhin¹jah¹la² wa²su¹wa²sun¹sxã³ ã³wih¹si¹nyhain¹tãu³a² nxe²e³te³nah¹lxi¹: “Jah¹lai²na² wi¹lhin¹jah¹lai²la¹wi¹. Nxe³ha²kxai³ wa²su¹wa²sun¹sxã³ ã³wih¹si¹hai¹na¹tũ¹xã¹.” Nxe³jau³su² nxe³te² ĩ³nxãn²tu̱³ wi¹lhin¹jah¹la² ũ³yho³hi²ka² yo³ha² yã¹nxe² ũ³yho³hi²nyhain¹nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Te²yã¹nxũn³sxã³ a²nũ²a² ĩ²li³te²a² a³lxi²sai¹nha²kxai³ ĩ̱³yau³xa² sũ²jau³xa² ĩ³na²jau³su² a²nũ²a² ã̱³jah¹la² ũ³hũ¹nyhain¹sxã³ e³te³nah¹lxi¹: “Jah¹lai²li² kãi²nxa³kxan²ti³ Sũ̱³na² sa³wi³sxai²la¹wi¹. Nxe³ha²kxai³ ĩ̱³yau³xa² ĩ³na²jau³xa² ũ³hũ¹ai¹na¹tu¹wi¹.” Nxe³jau³su² nxe³jah¹lai²na² sa²kxai³lu² ya²la³tu̱³ wi¹kãi³ain¹kxa²yo²ha² yũ³tu¹wi¹. Jã¹nxa¹jau³su² tai²li² nxe³ye¹nxa²lxa¹wi¹. Nxe³jau³xai²na² Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nxa²ha¹te¹ Je³su²jah³la² hi²sen³kxai³lu² a²sa³wi³ha³lxa² a²to²se³ nũ̱³ka̱³txa² ĩ³yau¹ũ³ta³lun²te³na¹ ã³waix3ta¹hxai²hẽ¹la². Sxi²jen³nãu³a² ai³lha²thet3sxã³ ai³sxã³ wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³hi² Sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³hen³txi² Je³su²jah³la² a²yxo²wãn³txa² a²nũ²a² yxo²ha³kxa¹ nxẽn³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nxa²ha¹te¹ Jo³ãu² Ba³tis²jah³lai¹txa³lxi³ sxi²ha² kan²txi³ ũ³tĩ¹kxi²sxã³ sxa³jah¹lai²na² sa²kxai³lu² Kris²tu³jah¹la² wã³nxĩn¹sxã³ o²la³kxi²jau³su² ha³ta̱³nxe³nũ²la² a²sa³wi³hxa³lxa² ĩ³kaix1tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nxe³sxã³ ĩ³kaix1tũ²la² Je³su²jah³la² ĩ³wã̱³txi³si¹jau³su² ĩ³sa²si¹hã³ah³lxin¹tain¹ta¹hxai²hẽ¹la². Ĩ³sa²si¹hã³te³nah¹lxi¹: — Txa²wã¹sũ̱³na² Si³yxau³tãu³u¹tai²na² ũ³sa²si¹hã³ũh¹sa²sĩn¹jah¹lo²su² nĩn¹ji¹wi¹? Nxe²nxa³kxai²nãn²tu̱³ a²nũ²a² ã̱³xa² wah³nxe³sa²sĩn¹te³lin¹ji¹wi¹? Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Nxex3jah³lxi³wxi¹. Wãn³txa² ain³kxah¹lxin¹jau³su² ha³lo²a² ĩ²yah³lxin¹jut3su² whãi²na¹ Jo³ãu² Ba³tis²jah³la² wxa²li³sxã³ ĩ³hen³txi³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ye³han³te²su² te²a² ye³we²txi²ha²kxai³ ha³lxu³ha² ai³te²su² te²a² sa²yu̱³we²txi²ha²kxai³ a²nũ²a² khon³ta³kxi²sxã³ ka̱³lã̱un³ta³kxi²te²su² te²a² we²txi²ha²kxai³ a²ne³nxẽ³na² ne³ka³tũ³te²su² te²a² ne³we²txi²ha²kxai³ a²nũ²a² ya³lu²te²su² te²a² ka³te̱n³su² ĩ³sa²yxau³xi²ti³hi¹tha²kxai³ a²nũ²a² yen³kxi³txa²te²su² te²a² Sũ̱³na² wãn³txa² wi¹jau³su² txa²wã¹ẽ¹nãu³a² sa²hau³ko³tain¹si¹hain¹jau³su² ĩ³hen³txi³nhyai¹nha²kxai³ nxe³jau³su² jau³xa² ha³kxa¹ ĩ³hen³txi³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Txa²wãn³txa² hxi²ye¹ta³lxain¹sxã³ en²sai¹nxa³te²su² te²a² wi¹lhin¹khaix1xain¹na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nxe²e³ta³lun²nũ²la² Jo³ãu² Ba³tis²jah³la² a²sa³wi³ha³lxa² aun³txi³sxã³ ĩ³xain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Je³su²jah³lai²na² sa²kxai³lu² sa²wa²nha²sxã³ a²nũ²a² ã³si³tẽ³la³kxi² te²nãu³xa² ĩ³ye³kxain¹te³nah¹lxi¹: — Jo³ãu² Ba³tis²jah³lai¹tã² ai³sxã³ ĩ²yah³lxi¹nhĩ¹nai³tã² ĩh¹nxe³te²ta̱³ ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? Ka³tĩ³ka²txã³nxa² kwa² sa³xit3sxã³ sa²hai³hain³jut3sũ³nxe² a²nũ²a² ĩ³wã̱³wã̱³ta³kxi²sain¹jah¹la² ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? ");
INSERT INTO nabNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nxe²nxa³kxai²nãn²tu̱³ ĩh¹te²ta̱³ ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? A²nũ²ai²na² yen³kxih³jah¹la² wã²la² a³lxi²khai¹nxe³ka³lo³a² au³khaix1nxe³ka³lo³a² wi¹khai¹nxe³ka³lo³a² nxe³ka³lo³ai²na² ũ³whi²kxi²nha²jah¹la² ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? Nxẽn²nxa³wi¹. A²nũ²a² wã²la² wi¹khai¹nxe³ka³lo³a² wih²kxi²nha²te²he³la³kxa² a²nũ²a² sxi²ha² kãin²te²si³yau³jxah¹la² sxi²ha² so¹lxi³ yxau²xai³lain¹te²jai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nxe²nxa³kxai²nãn²tu̱³ ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ai³lyah³lxin¹thai¹li¹? Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹la² ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? Jau¹xai²na² wain³jau³xai²la¹wi¹. Yxãn¹ta¹ ĩ³hen³txi³tũ̱³ka̱³txa² ã³wa²to²hi²sxã³ yxau²sa²tẽ³jah¹lai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Txa²wã¹sũ̱³na² wãn³txa² jau³xau³hxai²tẽx1ta² nxe³nẽ³te³nah¹lxi¹: “Ne³ka²a³sah¹lxi³wxi¹. Txa²sa³wit3su² ne³ka³ta²nxa²sxã³ ĩ³sa²si¹hã³a¹tu¹wi¹. Nxa¹kxai²nãn²tu̱³ a²nũ²a²nãu³xa² ĩ³tih³nxain¹tu¹wi¹. Txa²wãn³txa² hxi²kan¹txa² Si³yxau³tãu³lo³jah¹lo²sih¹nxa²ha¹jau³su² nxe³jau³xai²na² ĩ³hau³ko³tain¹tu¹wi¹.” Nxe³ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jã¹nxa¹jau³su² ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Sũ̱³na² wãn³txa² ĩ³hen³txi³nũ̱³ka̱³txu¹tai²nãn¹jau³xai²na² wxi²kan¹jau³xai²la¹wi¹. Yxãn¹ta¹ Jo³ãu² Ba³tis²jah³la² wãn³txa² ĩ³tih³nxe³jau³xai²na² wxi²kan¹sxã³ wa³to²hi²na³li¹. Nxe³kxan²ti³nũ¹ Txa²sa³wi³ha³lxai²na² hxi²kan¹tũ̱³ka̱³txi³sai¹nxa³kxan²ti³nũ¹ wãn³txa² ĩ³hen³txi³si¹hai¹na¹jau³xai²na² wxi²kan¹sxã³ wa³to²hi²sa²tẽ³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jã¹nxe³sxã³ txa²nũ² Jo³ãu² Ba³tis²jah³lo²nu¹ta²kxai³lu² Sũ̱³na² wãn³txa² ĩ³tih³nxe³te²ti³ai¹ti²tu³wi¹. A²nũ²a² ĩ²li³te²na² ã³yxo²o³tũ¹kxai²nãn²tu̱³ Sũ̱³na² hi²sen³kxai³lu² wi¹lhin¹sxã³ ĩ³ũ¹hai¹nhĩ̱³nx2na³li¹. Nxe³jau³su² Jo³ãu² Ba³tis²jah³la² ĩ³tih³nxe³te²ti³ai¹ti²tu³wi¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² ka³lxa¹te²nãu³xa² Txa²wãn³txa² a̱in³so¹ai¹nha²kxai³ ya³lo³txi²sxã³ Sũ̱³na² wãn³txa² yxo²ĩ²ain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A²kxã³nxãn¹jau³xu¹tai²na² Sũ̱³na² wãn³txa³ ĩ³hen³txi³nũ̱³ka̱³txai²na² a²yxo²ha³kxa¹ Moi³se²ah³lu¹tai²na² Sũ̱³na² wãn³txa² ũ³wha²li¹jau³xu¹tai²na² nxe³sxã³ Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³a² ĩ³yau¹ũ³nhẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³ka³tu̱³ hã²wxãn³txa³ Jo³ãu² Ba³tis²jah³la² ĩ³yau¹ũ¹nhẽ³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³tai²li² hĩ¹na² yũ²na³li¹.” Nxe³nẽ³ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A²nxe³jau³xu¹tai²na² E³li²ah³lu¹jãx1jah¹la² wxã³ju³ta²nũ³a² ĩ³yau¹ũ³nhẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³jah¹la² wxã³jah¹lai²na² Jo³ãu² Ba³tis²jah³lo²su² na³li¹. Ya²la³lyau³tu̱³ ã³ten³nxa²ti³kxai²nãn²tu̱³ yxo²ĩ¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A²ne³nxẽ³na² yũ¹nx2ti³kxai²nãn²tu̱³ ain³kxi¹sah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nxe³yãn¹ta¹ a²nũ²a² a²hĩ¹nãn¹te²nũ̱³ka̱³txi³nãu³xa² ĩh¹nxe³txe²hũ̱³nhĩ̱³te²la¹xã³? Wẽ³ha³lxa² yã¹nxain¹na³li¹. Sxi²je³na² kwa² wa³ni̱³lo³nain¹te²ju²hẽ³li¹. Wa³ni̱³lon³sxã³ ĩ³kaix1nyhu¹ain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Wãn³txa² wi¹lhin¹jau³xa² ĩ³hain³sih¹nx2ti³sĩ¹na¹tai¹ti²tu³wi¹. Yxãn¹ta¹ ĩ³ka³li³kxi²ya³sai¹nxãn³tai¹ti²tu³wi¹. Hã²wxãn³txa³nũ² ĩ³ãin²ta³kxi²jau³xa² ĩ³hain³sih¹nx2ti³sĩ¹na¹tai¹ti²tu³wi¹. Yxãn¹ta¹ nã̱n³kxi²ya³sai¹nxãn³tai¹ti²tu³wi¹.” Nxe³kxe³hũ̱³sxã³ a²nũ²a² a²hĩ¹nãn¹te² nũ̱³ka̱³txi³nãu³xa² kã³nxai³tãn¹tũ̱³ka̱³txa² yã¹nxain¹na³li¹. Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txa² e²nain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jã¹nxe³jut3su² Jo³ãu² Ba³tis²jah³la² wxã³hĩ¹nai³tã² yain³txa² kwa²hãi¹nxe² ã³na¹ha²kxai³ vĩn²yau³xa² ĩ³na²xa³ha²kxai³ Jo³ãu² Ba³tis²jah³la² ta¹hxai²hẽ¹li¹. Nxe³te³na¹ a²nũ²ai²na² e²nain¹sxã³ wãn³txa² wai³nxa³jau³su² e³lain¹te³nah¹lxi¹: “Jo³ãu² Ba³tis²jah³lai²li² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³yxau³jah¹lo²sin²tai¹.” Nxe² e³lain¹na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jã¹nxẽn³tai¹. Txai²li² wxã³na¹hĩ¹nai³tã² yain³txa² ĩ³yai³ni² yain³jau³xa² ĩ³na² nxa¹tai¹ti²tu³wi¹. Nxe³na¹ta¹ a²nũ²ai²na² wãn³txi³kxai³lu¹, en²kxi²sain¹te³nah¹lxi¹: “Je³su²jah³lai²na² yain³txa² kãin² yain³jah¹lai²la¹wi¹. Yain³jau³xa² ĩ³na²sa³wen¹jah¹lai²la¹wi¹. A²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txi³nãu³xa² ko̱³nxe³thin¹tũ̱³ka̱³txa² nxe³sxã³ ã³ya̱³lxi²nyhain¹jah¹lai²la¹wi¹.” Nxe² e³lain¹na²hẽ³li¹. Nxe³lxain¹kxan²ti³ a²nũ²ai²na² a²hoh³lxi³su² te²a² wain³txi³ kãi³kxai²nãn²tu̱³ a²wẽ³ha³lxa² wain³txi³ ĩ²ye²ain¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nxe²e³ta³lun²nũ²la² sxi²jen³ti³nãu³xa² ĩ³kwa̱ix1ta¹hxai²hẽ¹la². A²nxe³thĩ³nãu³xa² Je³su²jah³la² hi²sen³kxai³lu² wã³nxĩn¹sxã³ o²la³kxi²nũ¹hain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ nxe³kxan²ti³nũ¹ hai³txi³ a²ko̱³nxe³ti³ kãi³ain¹ju³ta² ã³na¹ain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jã¹nxe³jut3su² sxi²jen³txi³nãu³xa² ĩ³kwa̱ix1txain¹te³ãn¹jau³kxai³lu¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ko²ra³sĩ²thĩ³nãn¹tũ̱³ka̱³txãi³. Bet3sa³i²ta³thĩ³nãn¹tũ̱³ka̱³txãi³. Ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. Kxã³nhxĩ¹nai³tãn¹thĩ³na² Ti²ro³thĩ³nãn¹tũ̱³ka̱³txai³tã² Si³tõ²thĩ³nãn¹tũ̱³ka̱³txai³tã² nxe³sxã³ ko̱³nxe³thin¹khai¹nxai¹nha²kxai³ ya³lu²hxa³nain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ wã³nxĩn¹sxã³ kãi³ũh¹nx2ta¹ju³ta² ĩ²ain¹ke³la³te²kxai³ a²ko̱³nxe³ti³ kãi³ain¹ju³tu¹tai²na² ã³na¹sxã³ ã³yxo²o³tũ¹sai¹nhĩ̱³nx2na³li¹. Wã²la² sa²kẽ³nã²ka³lo³a² ũ³whi²kxi²nha²sxã³ ha³nxe²a² sin³so³xa² ã³wxe³sãn²sxã³ ã³yxo²o³tũ¹sai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nxe³kxa²ha³ta̱³nxãn²ti³ yxan¹nãu³a¹ txa²wã¹o²la³kxi²ki̱³kxa²yo³ha² Sũ̱³na² ũ³yho³hi²nẽ³tãu³a¹ Ti²ro³thĩ³nãn¹tũ̱³ka̱³txai³tã² Si³tõ²thĩ³nãn¹tũ̱³ka̱³txai³tã² nxe³sxã³ ko̱³nxe³ti³ kãi³ain¹kxa²yo³ha² kãi²nxa³lho³li¹. Yxãn¹ta¹ ko̱³nxe³ti³ kãi³yah³lxin¹kxa²yo³ha² ã²la² kãi²non³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nxa²ha¹te¹ Ka³far³na³ũ²thĩ³nãn¹tũ̱³ka̱³txi³ ĩ³nxai²na² sa²kxai³lu¹: “Oh³nãn¹ko³nãu³a² Sũ̱³na² ha³lo²a²nãu³a² ka³la³sxã³ ã³wi¹ha¹tũ¹xã¹.” Nxĩn¹jau³su² yxãn¹ta¹ yu̱h³xan¹ko³nãu³a² ha³nxe² i̱³ko³nãu³a² sa²yu̱³lho̱¹txa²tu¹wi¹. Kxã³nhxĩ¹nu¹tai²na² So³to²ma²thĩ³na² ko̱³nxe³thin¹khaix1ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³ha²kxai³ ko̱³nxe³thin¹sxã³ kãi³ain¹kxa²yo³ha² ũ³hũ¹nyhain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ wã³nxĩn¹sxã³ o²la³kxi²nũh¹nx2ta¹ju³ta² ĩ²ain¹ke³la³te²kxai³ hai³txi³ ya³lu²hxa³nai¹nhĩ̱²nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nxe³kxa²ha³ta̱³nxãn²ti³ yxan¹nãu³a¹ Txa²wã¹sũ̱³nu²kxai³lu² a²nũ²a² yxo²ha³kxa¹ a²wa³kxẽn³su² tu¹wi¹. Nxe³tãu³a² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² So³to²ma²thĩ³nũ¹tai²nãn¹tũ̱³ka̱³txa² kãin² ye³khãuh³lxa³ti³hi¹tain¹tu¹wi¹. Yxãn¹ta¹ wxa²nũ̱³ka̱³txi³ ĩ³nxai²na² sa²kxai³lu² ye³khãuh³lxa³ti³hi¹txa²lxi³ju³ta³nũ³a² kãin² wha²to²hi¹nx2tain¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nxe³ka³tu̱³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²te³nah¹lxi¹: Je³su²jah³la² ĩ³ye³kxi²ti³ãn¹jau³kxai³lu¹: — Txa²wĩ³nãi³. Oh³xan¹thĩ³na² whãi²na¹ yuh³xan¹thĩ³na² whãi²na¹ A²hxi²kan¹ta² Si³yxau³jah¹lo²si¹lxi¹. Nxĩn¹sxã³ ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²nãu³xa² a³la³kxi²khai¹nxe³te²nãu³xa² nxe³sxã³ wa³ka³la² kãi³in¹ju³tai²na¹ wãn³txa² ĩ³tih³nĩn¹jau³xai²na¹ ĩ³yau¹ũ³ai¹nxã³nhẽ³li¹. Yxãn¹ta¹ a²hoh³lxi³sxa³te²su² te²nãu³xa¹ wxa²wãn³txai²na² ĩ³yau¹ũ³ai¹nĩ¹nhẽ³li¹. Nxai¹nĩ¹nha²kxai³ sa²nẽn¹kxi¹nxa²ha¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wã²nxũ̱h¹lxi³sxã³ nxe²kãi³ĩ¹nhẽ³li¹. Nxe³jau³su² Je³su²jah³lo²kxai³lu² Sũ̱³na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nxe³ha²kxai³lu¹ Je³su²jah³la² ãh¹ ĩ³ye³te³nah¹lxi¹: — Yen³kxai²na² a²yxo²ha³kxa¹ Txa²wĩ³na² ũ³hũ¹sa³na²hẽ³li¹. Txa²wĩ³na² so¹lxi³ a²ki³lha³lxa²na¹xai²na² ĩ²sa²jah¹lai²la¹wi¹. Te²yã¹nxe³sxã³ Txa²wĩ³na² ĩ²te²la³ yũ²nxa³wi¹. Txai²na² a²ki³lha³lxa²na¹xai²na² so¹lxi³ ĩ²jah¹lo²sa¹wi¹. Te²yã¹nxũn³sxã³: “A²nũ²a² ã̱³xai²na² Txa²wĩ³na² ĩ³yau¹ũ³hai¹na¹tũ¹xã¹.” Nxa¹kxai²nãn²tu̱³ nxe³jah¹lai²na² sa²kxai³lu² Wĩ³na² ĩ²jah³lo²su² nũ³nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jã¹nxa¹jut3su² wxa²ẽ¹nãu³ai²na² hxi²tha³ah³lxin¹te² ĩ³nxai²na² yen³kxa² sa³te̱²kxa² sa²nah³so¹sxã³ hxi²tha³te²hũ̱³nxe² te² ĩ³nxai²na² nxe³sxã³ ã³wxã³jah³lxi³hẽ¹li¹. Yxah³lxin¹kxai²nãn²tu̱³ wxa²ẽ¹nãu³ai²na² ã³wa²su¹nha²sxã³ yxau²xai³nũ¹nxa²lxa¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Txa²wa³ka³li³yu³ta² sa²yu³ta³lot3jah¹lxi³hẽ¹li¹. Nxe³sxã³ txa²wãn³txa² ĩ³tih³nxe³nx2ta¹jau³xa² wi¹ko̱³nha¹jah³lxi³hẽ¹li¹. Txai²na² thãi³ti³la²khai¹nxe² yxau²xai³jah¹lo²sa¹wi¹. A²nũ²a²nãu³xai²na² yu³hẽ³nãu³ai²na² yxau²xai³jah¹lo²sa¹wi¹. Nxe³na¹kxa²yã¹nxe² yxau³nũ²nha¹jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ wxa²ẽ¹nãu³ai²na² ã³wa²su¹nha²sxã³ yxau²xai³lyah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jã¹nxe³jut3su² txa²wa³ka³li³yu³ta² sa²yu³ta³lot3jah³lxin¹ju³ta² ĩ³wi¹lxon³kxi¹jah³lxin¹kxi³te²ju²hẽ³li¹. Sa²ka³la³hẽn¹kxi²yah³lxin¹kxe³hũ̱³nxe² wa³lo³lon³te²ju²hẽ³li¹. Je³su²jah³lai²na² wãn³txa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txa² e³ta³lun²nũ²la² sa²ba³to³ nxe³hĩ¹na² hai³sxa² wi³txa² ã³nxai³ta¹hxai²hẽ¹la². Je³su²jah³la² ã³nxai² a²sa³wi³ha³lxa² ã³nxai³li² nxain¹ta¹hxai²hẽ¹la². Nxe³tãu³a² he³hain¹jau³su² yain³txi³nã̱³kxa² wxa²ni²lho¹sxã³ yai³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nxe³nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² ã³nhai¹tũn³te²nãu³xai²na² ĩ²ain¹tãu³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Nxex3txi¹. Ju³te²a² nũ̱³ka̱³txi³su² sa²ba³to³ nxe³tãu³a² a²wah³ka³lxa² a²yxo²ha³kxa¹ ã³na¹xai³ki̱³te²jai¹ti²tu³wi¹. Nxe³yãn¹ta¹ wxa²sa³wi³ha³lxa² jau³jau¹xai²na² sa²yxo²ã³ain¹ti²tu³wi¹, yain³ti³nã̱³kxa² wxa²ni²lho¹ai¹nha²kxai³lu¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Sũ̱³na² ũ³wha²li¹txã³nxa² ĩ²yah³lxin¹ta²lu¹wi¹. Ta³vi²yah³lu¹tai²na² he³ha²kxai³ a²sa³wi³ha³lxi³nãu³xu¹tai²na² he³hai¹nha²kxai³ nxain¹ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nxain¹tãu³kxai³lu² Sũ̱³na² sxi²ha² ã³wih¹nũ²la² yain³tũ̱³xai²na² Sũ̱³na² ũ³yho³hi²tũ̱³xai²na² wxa²so¹sxã³ ĩ³yain³kxain¹ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³tũ̱¹xai²na² Sũ̱³na² sxi²ha² hau³ko³tũ̱³ka̱³txa² wã³nxĩn¹te²ka³txa² so¹lxi³ yain³tũ̱³su² ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³kxa²ha³ta̱³nxãn²ti³ yai³nain¹ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te²yã¹nxũn³jut3su² Sũ̱³na² sxi²ha² hau³ko³tũ̱³ka̱³txa² a²yxo²ha³kxa¹ sa²ba³to³ nxe³ti³xai²na² jau³jau¹xai²na² sa²yxo²ã³xai³ain¹te²ju²hẽ³li¹. Nxain¹kxan²ti³ hxi²ki³la³ te²sxa³yu²hẽ³li¹. Ju¹tai²na² ĩ²yah³lxin¹ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nxe³yãn¹ta¹ wãn³txi³khai³xa² e³kxi¹nx2ta¹wi¹. Txa²wã¹sũ̱³na² sxi²ha² wa³to²hi² wxi²kan¹jah¹lo²sa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sũ̱³na² ũ³wha²li¹txã³nxa² nxe³te³nah¹lxi¹: “Wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³nyhu¹ah³lxin¹ju³ta² ten³sa³nhai¹. Yen³kxa² ũ³hũ¹sa²nhĩn¹ju³ta² so¹lxi³ ten³sa²nxa³nhai¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³jau³su² ha³kxa¹ jau³jau¹xai²na² wi¹ko̱³nh²yah³lxin¹ke³la³te²kxai³ a²nũ²a² hxi²ki³la²nxa³te²na² ko̱³nxe³ti³ ĩ³yĩ¹li²yah³lxi³hĩ̱³nx2nxa³lxi¹. Yxãn¹ta¹ yah²lxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nxe³na¹kxa²yu³su² Txai²na² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² sa²ba³to³ nxe³ti³xa² a²wa³kxẽn³yah³lo²sa¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nxe²e³ta³lun²nũ²la² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ã³wih¹te³na¹ in³txa² hxi²yã³nãn³ta³kxi²jah¹la² ĩ²ye²ta¹hxai²hẽ¹la². Nxe³te³na¹ fa³ri³se²a² nũ̱³ka̱³txa² ĩ³wã̱³txain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Sa²ba³to³ nxe³ti³xa² a²nũ²a² ĩ³ton³kxai²nãn²tu̱³ we²txi²ju³ta³nũ³su² wai³nhĩ̱³ji¹wi¹? Fa³ri³se²a² nũ̱³ka̱³txa² nxe³ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² ko̱³nxe³thin¹ju³ta² a³ti²si¹kxi³jau³nũ³su² ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Wxa²nũ̱³ka̱³txi³ ĩ³nxai²na² ka³na³ka³na³jah¹la² te² ĩ³nxai²na² o³ve²a² ka³na³ka³na³te²a² so¹lxi³ yũ³hĩ̱³nxa¹lxi¹. Nxẽn¹ka³tu̱³ o³ve²ai²na² sa²ba³to³ nxe³hĩ¹na¹ kxĩh³nxẽ¹na² ã³wi¹hĩ̱³nx2na³li¹. Nxe³ju³tai²na² nxe³kxai²nãn²tu̱³ sa²ba³to³ nxe³ti³xa² nxe³kxan²ti³nũ¹ o³ve²ai²na² kxĩh³nxẽ¹na² sa²sai²lho¹xi²hĩ̱³nxãn¹ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jã¹nxe³kxe³hũ̱³sxã³ a²nũ²su² a³lxi²wa³to²hi²khaix1nxe³te²ju²hẽ³li¹. Nxe³te²kxa³ya̱n³tu̱³ wi¹kãi³ũh¹ki̱³ju³ta² sa²ba³to³ nxe³ti³xa² nxe³kxan²ti³nũ¹ wain³te²ju²hẽ³li¹. Nxe³jau³su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nxe²e³ta³lun²nũ²la² sa²wa³ti̱³nha²sxã³ hxi²yã³nãn³ta³kxi²jah¹la² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³hxi²sin²nha¹sẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ ĩ³hxi²sin²nha²hĩ¹na¹ a²hxi²ka² sa²kxai³lu² ĩ³hxi²we²nxi²ta¹hxai²hẽ¹la². A²hxi²kxã̱¹xa² yã¹nxe² hxi²wi¹lxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² a³li³ain¹ka³tu̱³ ĩ³he³son³kxi²nyhain¹sxã³ Je³su²jah³la² ĩ³su²lhã³si¹hain¹jau³su² ĩ³ne³wa³ko³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nxa²ha¹te¹ Je³su²jah³lo²kxai³lu² ju¹tai²na² ĩ²nha²nũ²la² ã³waix3ta¹hxai²hẽ¹la². Ã³waix3te³na¹ a²nũ²a²nãu³xa² ka³lxa²khai¹nxe³te²nãu³xa² aun³ta² ĩ³hi¹tain¹ta¹hxai²hẽ¹la². Nxe³tãu³a² a²nũ²a² ĩ³ton³te²a² ka³lxa¹sxã³ ĩ³hi¹tain¹yah³lxi³nũn³ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ Je³su²jah³la² hxi²ki³kxai³lu² we²txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. We²txi¹nx2ta¹wi¹. Nxe³nx2ta¹kxa²ha³ta̱³nxãn²ti³ a²nũ²a² ã̱³xa² ĩ³hen³txi³yah³lxi³txa³hẽ¹li¹. Je³su²jah³la² wãn³txa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A²nxe³jut3su² kxã³nxu¹tai²na² I³sa³i²ah³lu¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lu¹tai²na² a²wãn³txi³su² nxe³ta¹hxai²hẽ¹la². Nxe³jau³xau³hxai²tẽx1ta³la³ te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","— Nxe³jah³lxi³sa²lxi¹. Jah¹lai²li² Txa²sa³wi³sai²la¹wi¹. Ĩ³kaix1so¹na¹kxah³lai²la¹wi¹. A³lxi²na¹kxah³lai²la¹wi¹. Ĩ³wi¹lxon³kxi²sa²jah¹lai²la¹wi¹. Ã³nũ²nxi²sxã³ ai³na¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ a²nũ²a²nãu³xa² a²yxo²ha³kxa¹ ko̱³nxe³ti³ kãi³ain¹ju³ta² ã³wa²su¹kxi²na¹ju³ta³nũ³a² ĩ³hen³txain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hai³txi³ kwa² ĩ³he¹he¹kxi²nyhu¹xa³ha²kxai³ kwa² ĩ³kaix1nyhu¹xa³ha²kxai³ sxi²jen³nãu³ai²na² kwa² ĩ³kãi²non³si¹nha¹jau³su² ĩ³ye³li³xa³ha²kxai³ nxe³jah¹lai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ka³tĩ³kxa³ti²nxãn³su² sa²ka³lũt3sxã³ sxa³nxã³nxa² sa²nãu³lxi²nxa³lho³li¹. Te²yã¹nxe³sxã³ lã³pi³ãu²te³na² ũ³hũ¹lxi³te³lhxã³ tẽ³na² hai³txi³ ũ³hũ¹lxi²nxa³lho³li¹. Nxe³kxa²yã¹nxe² a²nũ²a² yxo²ĩ²sxã³ hxi²tha³kxai²nãn²tu̱³ hai³txi³ ĩ³ya²lu¹thxa³kxi²nxa³lho³li¹. Nxe²nxa³ha²kxai³ ĩ³nxũ²kwa̱i³lxũ¹txain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jã¹nxe³jut3su² Jah¹la² wãn³txai²na² sa²kxai³lu² a²nũ²a²nãu³xai²na² a²yxo²ha³kxa¹ yxo²ĩ²ain¹tu¹wi¹. I³sa³i²ah³lu¹tai²na² wãn³txa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nxa²ha¹te¹ in³txa² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³yxau³jah¹la² ã³sa²so¹ain¹ta¹hxai²hẽ¹la². A²nxe³jah¹la² ye³han³ye²ha²kxai³ yxo²kan²ye²ha²kxai³ nxe³jah¹lo²su² ta¹hxai²hẽ¹la². A²nxe³te²kxai³lu² Je³su²jah³la² hi²sen³kxai³lu² in³txa² ĩ²kxi²nũ²la² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³si¹jau³su² kwa³na³ta¹hxai²hẽ¹la². Nxe³tãu³ yxo²we²txi²xi²ha²kxai³ ye³we²txi²xi²ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A²nxe³ju¹tai²na² a²nũ²a² ĩ³hi¹tain¹te²nãu³xa² ĩ²kxain¹nxa²ha¹te¹ o²lai¹nha²kxai³ ĩ³ye³lain¹te³nah¹lxi¹: — Je³su²jah³lai²li² wã³nxĩn¹khaix1jah¹lo²sin²tai¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹lo²su² yxau³sxã³ wah³nxe³kxi²ki̱³jah¹lo²su² nxe³jah¹lain²txi³ te²sin²tai¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nxe³yãn¹ta¹ fa³ri³se²a² nũ̱³ka̱³txai²na² ã³nhai¹tũn³te²nãu³xai²na² e³kxi²nyhain¹te³nah¹lxi¹: — Je³su²jah³lai²na² sa²kxai³lu² Bel³se³bu²ah³la² a²ta³nãu³xa² a²hxi²kan¹jah¹lo²su² ha²kxai³ nxe³jah¹la² a²sa³wit3sin²tai¹. Nxe³te²si¹nha²kxai³ hxi²kan¹txi³ ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³si¹jau³su² ĩ³ye³kxi²te²sin¹yu²hẽ³li¹. Fa³ri³se²a²nãu³xa² nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu² fa³ri³se²a² ẽ¹nãn¹jau³su² wi¹ko̱³nha²ha²kxai³ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. A²nũ²a²nãu³xai²na² sa²kxai³lu² wã²nxũ̱h¹lxi³ ã³nhe¹kxi²nyhain¹kxai²nãn²tu̱³ ya³lu²hxan³nyhain¹te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ sxi²je³na² ta̱³nxa² kwa² sxi²ha² ta̱³nxa² a²nũ²a² yxau²xai³te²nãu³xa² ã³nhai²ta³lxi³sxã³ yxau³ain¹kxai²nãn²tu̱³ kan²txi³ yxau²sa²tẽ³ai¹nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te²yã¹nxũn³sxã³ Sa³ta³na²jah¹la²kxai³lu² wã²nxũ̱h¹sxã³ nxũ²kwa̱i³li³si¹nha²jau³su² ĩ³ye³kxi²nha²kxai²nãn²tu̱³ hai³txi³ a²ha³lo²ai²na² nũ³kxũn³txi³ yxau²sa²tẽ³xa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nxe³ha²kxai³ wxa²wãn³txa² e³yah³lxin¹te³nah¹lxi¹: “Je³su²jah³lai²li² Bel³se³bu²ah³la² a²sa³wi³sai²la¹wi¹.” Yah³lxin¹jau³su² yxãn¹ta¹ fa³ri³se²a² nũ̱³ka̱³txe² ĩ³nxai²na² wxa²wẽ³ha³lxa² kãi³a¹kxa² yã¹nxe² kãi³ain¹nũn³na³li¹. Nxe³ai¹nha²kxai³ wxa²nũ̱³ka̱³txai²na² ĩh¹te²ta̱³ sa³wi³ha³lxi³la³ te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nxe³yãn¹ta¹ Txa²wã¹sũ̱³na² Yãu³ka³txa² Te²hi²sen³su² ĩ³hxi²kat1sa²ha²kxai³ hxi²kan¹txi³ ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³si¹jau³su² ĩ³ye³kxi²na¹wi¹. Nxe³na¹kxe³su² ya²la³txi³ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹lo²su² ye²te²sa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Te²yã¹nxe³jau³su² sxi²ha² wa³kxẽn³yah³la² nũ̱³kxũn³jah¹lo²su² ye²kxai²nãn²tu̱³ hxi²kan¹ti³ sxi²hai²na² ã³wih¹ka³tu̱³ a²yen³kxa² kãi³kxi²ti³hex1nxe³hĩ̱³nx2nxa³wi¹. Yxãn¹ta¹ nũ̱³kxũn³jah¹lai²na² i³sxã³ sa²tai³kxain¹ke³la³te²kxai³ sxi²hai²na² ã³wih¹ka³tu̱³ a²yen³kxa² yxo²ha³kxa¹ hxi²kan¹ti³ kãi³kxi²sxã³ wxa²so²hxa³hĩ̱³nx2na³li¹. Nxe³na¹ha²kxai³ a²ta³nãu³xa² a²hxi²kan¹jah¹la² Bel³se³bu²ah³lan²tu̱³ nxe² kãi³kxi²na¹hẽ³li¹. Hxi²kan¹ta² Si³yxau³jah¹lo²sa¹wi¹. Nxe³na¹ju³tan¹te²kxa³ya̱³lhu² a²ta³ai²na² a²nũ²ẽ¹na² nxũ²kwa̱i³yxau³te²su² te²a² nxũ²kwa̱i³li³si¹hai¹na¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nxe³ain¹jut3su² a²nũ²ai²na² ã³ya̱³lxi²sai¹nxa³te²su² te²a² txa²ko̱¹ko̱¹sain¹na³li¹. Te²yã¹nxe³sxã³ o³ve²a² yã¹nxe² ã³nũ²kxi²sai¹nxa³te²su² te²a² ha³te̱n¹txi² aun³txi³si¹hain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Jã¹nxe³ha²kxai³ a²nũ²a² ĩ²li³te²su² te²an²tu̱³ ko̱³nxe³ti³ kãi³kxai²nãn²tu̱³ hã²wxãn³txa³ ĩ³ãin²ta³kxi²nha²sxã³ ã³yxo²o³tũ¹kxai²nãn²tu̱³ ã³wa²su¹tain¹ju³ta² yũ²na³li¹. Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹lo²su² te²sa¹jah¹lo²na¹xai²na² ko̱³nxe³te²lot3sain¹kxan²ti³ ã³wa²su¹tain¹ju³ta³nũ³a² yũ³tu¹wi¹. Nxe³to³ta¹ wxãi²na² wai³nxa³jau³xa² e³lah³lxin¹jau³kxai³lu¹: “A²ta³a² hxi²kan¹ta² hi²sen³su² Je³su²jah³la² ĩ³hxi²ka¹tin²tai¹.” Yah³lxin¹jau³su² yah³lxin¹ta¹ Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² ko̱³nxe³te²lo³jah³lxi¹lxi¹. A²nxe³jau³xai²na² sa²kxai³lu² Sũ̱³na² Yãu³ka³jxah¹la² ko̱³nxe³te²lo³jau³xai²na² sa²kxai³lu² hai³txi³ ã³wa²sut1ju³ta² yũ²nxa³wi¹. Te²yã¹nxe³sxã³ yan¹nãu³a¹ ko̱³nxe³ti³ kãi³yah³lxin¹kxa² yo³ha² a³ya³ti²ju³ta³nũ³a² yũ³hĩ¹na¹ ã³wa²su¹ju³ta²nũ³a² yũ²nxa³lho³li¹. Hxi²ki³te²la³ yxau²sa²tẽ³ju³ta³nũ³a² so¹lxi³ yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jã¹nxe³kxe³hũ̱³jau³su² hi³sa³ka³txai²na² wi¹kxai²nãn²tu̱³ a²nxã̱³kxa² wi¹te²jai¹ti²tu³wi¹. Yxãn¹ta¹ hi³sa³ka³txai²na² ko̱³nxe³kxai²nãn²tu̱³ a²nxã̱³kxa² ko̱³nxe³te²jai¹ti²tu³wi¹. Nxe³sxã³ hi³a²nxã̱³kxi³khai³sxu² ĩ²ki̱³sa²kxai³ hi³a² wi¹ta̱³nxa² ko̱³nxe³ta̱³nxa² ĩ²ki̱³te²jai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nxe³ha²kxai³ wxãi²nãu³ ĩ³nxai²na² fa³ri³se²a² nũ̱³ka̱³txi³ ĩ³nxai²na² txih³xa² wẽ³ha³lxa³ yã¹yxah³lxi¹lxi¹. Ko̱³nxe³thin¹khai¹yxah³lxi¹lxi¹. Yxãn¹ta¹ wãn³txa² wi¹jau³xa² ĩ³yxo²e³yah³lxi¹lxi¹. Ju¹tai²na² wai³nxa³wi¹. Ya²la³txi³ txa²wã¹ẽ¹nãu³ai²na² nũh¹ e³kxi²nha²kxa² yã¹nxe² txa²wã¹yxo²e³jau³su² nxe³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jã¹nxe³sxã³ a²nũ²a² wi¹lhin¹te²a² a²ẽ¹nãu³ai²na² wi¹lhi¹nha²kxai³ wi¹lo²la³kxi²te²ju²hẽ³li¹. Nxe³ain¹ta¹ a²nũ²a² ko̱³nxe³thin¹te²a² a²ẽ¹na² whãi²na¹ ko̱³nxe³thi¹nha²kxai³ wi¹lo²la³kxi²te²sxa³yu²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jã¹nxe³ju³kxai³lu¹ ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Wãn³txa² toh³lxi³jau³xai²na² whãi²na¹ e³yah³lxin¹te²tu̱³ yan¹nãu³a¹ kãi³yah³lxin¹kxa² yo³ha² a³ya³ti²kxe³su² nxe³ti³xa¹ ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nxe³sxã³ wxa²wãn³txai²na² wi¹jau³xa² sa²yxo²sai¹kxai²nãn²tu̱³ wi¹lhin¹te²lo³nx2ti³tu¹wi¹. Yxãn¹ta¹ wxa²wãn³txa² ko̱³nxe³jau³xa² sa²yxo²sai¹kxai²nãn²tu̱³ ko̱³nxe³thin¹te²lo³nx2ti³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nxa²ha¹te¹ a²nũ²a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²su² te²a² fa³ri³se²a² nũ̱³ka̱³txi³su² te²su² te²a² nxe³sxã³ ka³na³ku² ã³tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³la² tih³nxe³nha¹jah¹lãi³. Wã³nxĩn¹sxã³ kãi³in¹ju³ta² wã²nã³ũ¹sa²sĩ¹nhẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ko̱³nxe³thin¹khai¹yxah³lxi¹lxi¹. Sũ̱³na² ĩ³sa²si¹hã³sa²jau³su² jau³xa² ten³ti³he¹yxah³lxa³lxi¹. Yah²lxa³nha²kxai³ Sũ̱³na² ĩ³sa²si¹hã³sa²kxe³su² wã³nxĩn¹sxã³ kãi³a¹ju³ta³la³ ĩ³ye³kxi²sah¹lxi¹nhẽ²li¹. Nxe³yãn¹ta¹ hĩ¹na¹ wã³nxĩn¹na¹ju³ta³la³ wã²nã³ũ¹nx2ti³nxa³lho³li¹. Wãn³txa² wã²nã³ũ¹nx2ta¹jau³xa² tĩ³yau³xu¹tai²na² so¹lxi³ Jo²na³jah³lu¹tai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lu¹tai²na² wãn³txa² so¹lxi³ ĩ³yũ¹jah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nxe³jau³xu¹tai²na²sa¹. Jo²na³jah³lu¹tai²na² sa²kxai³lu² ye³ha¹li¹ ka³na³ki¹ a³la²ni²tãu³a² a̱i³na² a²ẽ¹nai²na² ka³te̱n³su² sxa³ta¹hxai²ti³ai¹ti²tu³wi¹. Hã²wxãn³txa³ a³li³sa²sai¹xi²ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² sa²kxai³lu² ye³ha¹li¹ ka³na³ki¹ a³la²ni²tãu³a¹ kxĩh³nxẽ¹na² ya³lu²sxã³ sxa³na¹tu¹wi¹. Hã²wxãn³txa³ ka³te̱n³su² ĩ³sa²yxau³na¹tu¹wi¹. Nxe³ju³tai²na¹ Sũ̱³na² sa²si¹hã³sa²ju³ta² e³lxah¹ ĩ²yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jã¹nxe³jut3su² yan¹nãu³a¹ Txa²wã¹sũ̱³na² sa²kxai³lu² a²nũ²a² yxo²ha³kxa¹ kãi³ain¹kxa² yo³ha² a³ya³txi²kxe³su² nxe³ti³xa¹ Ni³ni³ve²thĩ³nãn¹ta² nũ̱³ka̱³txu¹tai³na² nxe³te²hi²sen³su² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2tain¹tu¹wi¹. A²nxe³te²nãu³xu¹tai²na² sa²kxai³lu² Jo²na³jah³lu¹tai²na² wãn³txa² ain³kxai¹nha²kxai³ ko̱³nxe³thi¹nain¹ju³tu¹tai²na² ã³na¹ain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Jo²na³jah³la² hxi²kan¹jah¹lo²su² ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ kãin² wa³to²hi²jah¹lo²sa¹wi¹. Nxe³sa³kxan²ti³nũ¹ Txa²wãn³txa² sa²yxo²wet1sah¹lxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Te²yã¹nxe³jut3su² kxã³nhxĩ¹nu¹tai²na² Se²ba³thĩ³na² a²wa³kxẽn³na¹ka³lxu¹tai²na² sa²kxai³lu² Sa³lo³mãu²ah³lu¹tai²na² wãn³txa² a²hoh³lxi³khai¹sa²jau³xa² ain³kxi²te³lhxã³ u²lxan¹thĩ³na² a³li³sxã³ wxã³ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³ta¹ka³lxai²na² sa²kxai³lu² yan¹nãu³a¹ Txa²wã¹sũ̱³na² sa²kxai³lu² a²nũ²a² kãi³ain¹kxa² yo³ha² a³ya³ti²kxe³su² nxe³ti³xa¹ ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³tu¹wi¹. Kxã³nhxĩ¹nu¹tai²na² Sa³lo³mãu²ah³lu¹tai²na² wãn³txa² wi¹lain³kxi²ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ Txai²na² sa²kxai³lu² Sa³lo³mãu²ah³la² ĩ³kãin² wa³to²hi²na¹jah¹lo²sa¹wi¹. Nxe³sa³kxan²ti³nũ¹ Txa²wãn³txa² ain³kxi²ti³ten³yah³lxa³lxi¹. Nxe³ye¹nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nxe³ha²kxai³la¹ ko̱³nxe³te² yãu³ka³txa² a²nũ²a² nxũ²kwa̱i³li³kxai²nãn²tu̱³ ha³lo²ai²na² ĩ̱³yau³xa² yũ²nxa³ko³xa² a²hãi¹nxe³ti³xa¹ ã³wxe³sxã³ ĩ³ye¹nxi²si¹jau³su² ã³ten³sxã³ ai³lha²thet3tin²tai¹. Yxãn¹ta¹ ĩ³ye¹nxi²je³na² ĩ²xa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nxe³yãn¹ta¹ ĩ²xa³kxe³su² e³nha²te³nah¹lxi¹: “Txa²sxi²ha² a³li³a¹thĩ³nai³tã² ã³wa̱³li²na¹tũ¹xã¹.” Ain¹jau³su² ã³wa̱³li²tãu³ a²nũ²ẽ¹nai³ta³lxi² a²nũ²yũ²nxa³ha²kxai³ wi¹we²txi³ha²kxai³ wi¹lhau³ko³nha²kxai³ nxe³ye²kxe³su² ha³lo²a² ai³lxin²tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ai³ka³tu̱³ ko̱³nxe³te² yãu³ka³txi³nãu³xa² ha¹li¹ ha¹li¹ ha¹li¹ ka³na³ki¹ nxe³te²nãu³xa² ko̱³nxe³ti³khaix1 wa³to³hain¹te²nãu³xa² ĩ³ha¹txai¹nĩn²tai¹. Nxe³te²nãu³xa² sa²so¹sxã³ ã³wa̱³li²xi²sa²tẽ³in²tai¹. Nxe³ju³tai²kxai³lu² in³txa² ẽ¹nãu³a² ko̱³nxe³ti³ ã³wa²to²hin²tai¹. Te²yã¹nxe³jut3su² hĩ¹na² yxau³yah³lxin¹te² ĩ³nxai²na² sa²kxai³lu² ko̱³nxe³thin¹khai¹yxah³lxin¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³li²ta³lu²nai¹nxa³ta̱³lxa¹ a²hã³ka³nai²na² ã³wxã² a²lon³ti³tãu³xa² ã³wxã² nxain¹ta¹hxai²hẽ¹la². Ha³lo²a² yxau³sxã³ ĩ³ye³kxi²nyhu¹si¹nyhain¹jau³su² ã³te³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nxe³sxã³ ĩ³hen³txi³te³nah¹lxi¹: — Je³su²jah³lãi³. Nxe³txi¹. Wxa²hã³ka³nai¹tã² wxa²lon³txi³tãu³xa² ha³lo²a² yxau³ain¹na³li¹. Ĩ³ye³kxi¹nxa²te³lhxã³ wxã³ain¹na³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Txa²hã³ka³nai¹ta̱³ txa²lon³ti³tãu³ãn²ta̱³ ĩ̱h¹te²la³ta̱³nain¹te²la¹xã³? Nxe² e³nũ²la² a²sa³wi³ha³lxi³nãu³xa² wã²nã³ũ¹hain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","— Tũ̱¹ka̱³txai²na² txa²hã³ka³nũ²su² ha²kxai³ txa²lon³ti³tãu³su² ha²kxai³ nxe³kxi²sain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nxe³sxã³ a²nũ²a² ĩ²li³te²na² sa²kxai³lu² Txa²wĩ³na² Oh³nãn¹jah¹a² Si³yxau³jah¹lai²na² a²ten³jau³su² sa²yxo²wet1sxã³ kãi³kxai²nãn²tu̱³ nxe³te²nãn²tu̱³ txa²hã³ka³nũ²su² ha²kxai³ txa²lon³ti³tãu³su² ha²kxai³ ne³te²sain¹na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nxa²ha¹te¹ sxi²hai²na² a³li³xi²nũ²la² ĩ̱³ye³na² ne³kxu̱n²nãu³a² ai³sxã³ ã³wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ã³wxe³ka³tu̱³ a²nũ²a²nãu³xa² ka³lxa²khai¹nxe³sxã³ ã³wxã³wxã³yain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ Je³su²jah³la² te²kxai²lu² ka³no¹a²ka³lo³a² ã³wih¹wxe³ha²kxai³ a²nũ²a²nãu³xa² te²kxai³lu² ha³lo²ai²na² ĩ̱³ye³nai²na² ne³kxu̱n²nãu³a² yxau³ai¹nha²kxai³ nxẽn³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A²nxe³tãu³a² Je³su²jah³la² hi²sen³su² wãn³txa² ĩ³yau¹ũ³jau³xa² yau³ka³lxa¹txi³ ĩ³tih³nxain¹ta¹hxai²hẽ¹la². Ĩ³tih³nxe³te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. A²nũ²ai²na² hai³sxa³nãu³a² ai³nũ²nhai¹. Yain³ta³ki³a² wi¹ki³a² ũ³whĩ̱¹te³lhxã³ wxa²sa²tãu³wa³ya²txũ³lhain¹sxã³ ũ³whĩ̱¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ũh³wĩ̱¹tãu³a² yain³ta³ki³ai²na² ki³jũ¹nxe² ã³nhai¹tãu³a² sa²kxai³lu² tĩh³na² yxo²ki³sa² ã³yun¹na³nũ²nhai¹. Ã³yun¹na³tãu³ a̱i³ka³nãu³xa² wa³su³txi³ wxã³sxã³ yai³nhxa³kxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ãh¹ki³jũ¹nxe² ã³nhai¹tãu³a² sa²kxai³lu² txah³lxa³kxa² si³yu³hẽ³nãu³a² nxe³kxĩ̱h³nxũ³xa² ã³yun¹na³nũ²nhai¹. A²nxe³ kxĩh³nxai²na² au³la³ka²txi³nh²nxa³ha²kxai³ wa³su³txi³ ka³lũ̱³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ka³lũ̱³te³na¹ u³je³na³kai²li² wxa²ki³ka³la³ka³tu̱³ ĩ³wãn³ya²lun¹ti³nũ²nhai¹. Nxe³ju³tan¹te²kxa³ya̱³tu̱³ yain³ta³ki³ne³ka² a̱u³txi³ sxa²nxa³ha²kxai³ ya²lun¹txi³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ãh¹ki³a² jũ¹nxe² ã³nhai¹tãu³a² sa²kxai³lu² ha³lo²a² ũ³yen³ko³xa² ã³yun¹na³nũ²nhai¹. A²nxe³ki³ai²na² sa²kxai³lu² ka³lũ̱³xi²nũ²nhai¹. Nxe³ta¹ ũ³yen³ko³su² ha²kxai³ hi³a² kha¹ka³txa² ka³lxa¹txi³ ka³lũ̱³ye²nũ³nha²kxai³ nxe³te²kxai³lu² yain³ta³nxe²kxa² wãn³ne³sa³te³kxi²sxã³ ya²lun¹txi²ye²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nxe³yãn¹ta¹ ãh¹ki³a² jũ¹nxe² ã³nhai¹tãu³a² sa²kxai³lu² kxĩh³nũ̱³xa² ti̱³ti̱n³tũ̱³xa² ã³yun¹na³nũ²nhai¹. A²nxe³ki³ai²na² sa²kxai³lu² wi¹ka³lũ̱³ha²kxai³ wi¹we¹nha²kxai³ yain³txa³ki³a² kãin² ki³kan²kxi²ha²kxai³ kãin² a̱n³nũ²nhai¹. A²nxe³ki³ai²na² sa²kxai³lu² a²hãi¹nxe³ki³sa² ki³an²tu̱³ wa̱³li̱³kha³lhon¹txi² ã³ki³i¹nhe¹ha²kxai³ a²hãi¹nxe³ki³sa² ki³an²tu̱³ ka³lxa¹txi³ ã³ki³i¹nhe¹ha²kxai³ a²hãi¹nxe³ki³sa² ki³an²tu̱³ kũ³we²ki²la² ka³lxa²nxa³txi³ ã³ki³i¹nhe¹ha²kxai³ nxũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jã¹nxa¹jau³su² wi¹ko̱³nyah¹lxi³ti³ten³nxa²lxin¹kxai²nãn²tu̱³ wi¹lain³kxi¹sah¹lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nxe²e³ta³lun²nũ²la² a²sa³wi³ha³lxai²na² sa²kxai³lu² ã³tĩ̱³sxã³ ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ a²nũ²a²nãu³xa² ĩ³yau¹ũ³jau³xa² so¹lxi³ e³kxai¹nĩn¹ji¹wi¹? Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wxa²yu³tai²na² so¹lxi³ wãn³txai²na² tah²yau³xai²na² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² a²nũ²a² ẽ¹nãu³a² sa²hau³kot3jau³nũ³su² nxe³jau³jau¹xai²na² txa²nũ² ã³ne³wxe³yah³lxin¹tu¹wi¹. Yxãn¹ta¹ tũ̱¹ka̱³txai²na² hĩ¹na² ã³ne³wxe³ti³he¹xai¹nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nxe³ju³tan¹te²kxa³ya̱n³tu̱³ in³txi³su² yen³kxih³kxai²nãn²tu̱³ ã²la² kãin²sxã³ ũ³yhen³kxi²nyhain¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ yen³kxi³khai¹nxe³hĩ̱³nx2na³li¹. Te²yã¹nxe³sxã³ in³txi³su² yen³kxi³txa²te²su² te²a² jũ¹nxe² so¹lxi³ yen³kxih³kxi³su² sa²so¹kxi²nyhain¹tu¹wi¹. Nxe³sxã³ yen³kxi³ txa²khaix1nxe³hĩ̱³nx2na³li¹. Nxe³te²ju²hẽ³li¹. Te²yã¹nxe³kxe³hũ̱³nxe² Sũ̱³na² wãn³txa² jũ¹nxe² ã³ne³wxe³yah³lxi¹nha²kxai³ kãin²non³sxã³ ã³ne³wxe³yah³lxin¹tu¹wi¹. Tũ̱¹ka̱³txai²na² ã³ne³wxe³ai¹nxa³ha²kxai³ ĩ³yau¹ũ³jau³xa² so¹lxi³ ain³kxain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jã¹nxa¹jau³su² wãn³txa² ĩ³yau¹ũ³jau³xa² so¹lxi³ e³kxai¹na¹wi¹. Nxai¹na¹kxan²ti³ ĩ²ain¹kxan²ti³ ã³ye³wxe³ai¹nxa³lho³li¹. Ain³kxain¹kxan²ti³ ã³ne³wxe³ai¹nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A²nxe³sxã³ I³sa³i²ah³lu¹tai²na² wãn³txa² Sũ̱³na² wãn³txa² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: “Wxãi²na² sa²kxai³lu² ne³kat1sa²tẽ³yah³lxin¹tu¹wi¹. Yxãn¹ta¹ ã³ne³wxe³yah²lxan³tho³li¹. Ĩ²sa²tẽ³kah¹lxin¹tu¹wi¹. Yxãn¹ta¹ wi¹lĩ²sa²tẽ³yah²lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","A²nxe³tũ̱³ka̱³txai²na² a²ẽ¹nãu³ai²na² kan²na³li¹. A²yen³na² whãi²na¹ wxa²ye³tĩ¹nha² a²ne³nxẽ³na² whãi²na¹ wxa²ne³tĩ̱¹nha² nxe³kxa²yã¹nxain¹na³li¹. Nxe³sxã³ ã³ne³wxe³ai¹nx3tho³li¹. Nxai¹nxa³ke³la³te²kxai³ a²yen³na² ã³ye³wxe³ai¹nha²kxai³ a²ne³nxẽ³na² ain³kxai¹nha²kxai³ nxe³sxã³ a²ẽ¹nãu³ai²na² Txa²wãn³txa² ã³ne³wxe³ain¹kxai²nãn²tu̱³ yxo²ĩ²sain¹sxã³ sa²hau³ko³tai¹hĩ̱³na¹wi¹. Yxãn¹ta¹ nxai¹nxa³wi¹.” I³sa³i²ah³lu¹tai²na² wãn³txa² nxe³ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yxãn¹ta¹ wxãi²kxai³ txa²sa³wi³ha³lxi³syah¹lxin¹te² ĩ³nxai²kxai³ te²yã¹yxah³lxa³lxi¹. Wxa²ye³na² wi¹lĩ²yah³lxi¹nha²kxai³ wxa²ne³nxẽ³na² wi¹lain³kxi²yah³lxi¹nha²kxai³ nxe³yah³lxi¹lxi¹. Nxe³ha²kxai³ wi¹lhin¹sxã³ ĩ²nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kxã³nhxĩ¹nai³tã² Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² a²nũ²a² wi¹lhi¹nain¹te²nãu³xu¹tai²na² nxe³sxã³ yen³kxa² ĩ²yah³lxin¹ju³tain²txi³ ĩ²ti³te³nai¹nha²kxai³ wãn³txa² ain³kxah¹lxin¹jau³xain²txi³ ain³kxi²ti³te³nai¹nha²kxai³ nxe³ain¹ta¹ hxi²ka¹nain¹te²sxa³jai¹ti²tu³wi¹. Nxe³ye¹nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jã¹nxa¹jau³su² yain³txa³ki³su² ã³yun¹na³jau³xin³ti³ a²si³yxau³tãu³a² ĩ³yau¹ũ¹nx2ta¹tu¹wi¹. Ain³kxi²sah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","A²nũ²ai²na² sa²kxai³lu² wãn³txa² tah²yau³xai²na² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² a²nũ²a² ẽ¹nãu³a² sa²hau³kot3jau³nũ³su² nxe³jau³jau¹xai²na² ain³kxi²sxã³ ã³ne³wxe²nxa³kxai²nãn²tu̱³ Sa³ta³na²jah¹la² a²ta³a² hxi²kan¹jah¹la² wxã³sxã³ ne³wã²na³ti³hi¹te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe² yain³txa³ki³a² tĩh³na² ne³ku²nxa² ã³yun¹na³ki³ai²yã¹nxe³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A²nũ²ai²na² sa²kxai³lu² Sũ̱³na² wãn³txa² wi¹jau³xa² ain³kxi²kxai²nãn²tu̱³ wi¹lxon³kxi²sxã³ ain³kxi²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nxe³yãn¹ta¹ a̱u³txi³ yxo²ĩ²xa³kxe³su² ha³lo²a² ko̱³nxe³to³nha²kxai³ Sũ̱³na² wãn³txa² ain³kxi²ju³tan¹te²kxa³ya̱³lhu² ĩ³khãuh³lxa³thi¹nai¹nha²kxai³ nxe³te²ju²hẽ³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² wãn³txai²na² wa³su³txi³ sa²yxo²ã³te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe² yain³ta³ki³ai²na² kxĩh³nxa² txah³lxi³ju³tai²na² ã³yun¹na³ki³ai²yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A²nũ²a² ã̱³xai²na² sa²kxai³lu² Sũ̱³na² wãn³txa² ain³kxi²nũn³te²ju²hẽ³li¹. Yxãn¹ta¹ ha³lo²a² hxi²waut3ta³lxi³nha²khaix1nxe³ha²kxai³ a²yen³kxa² ta̱³nxa² a²ha³te̱h³nxã³nxa² ũ³yho³hi²ki̱³txã³nxa² ta̱³nxa² kãin² yxo²kwa̱i³nai¹nha²kxai³ wãn³txa² wi¹jau³xa² ã³na¹ain¹sxã³ hai³txi³ Sũ̱³na² sa²yxo²we¹ti³hex1te²sxa³yu²hẽ³li¹. Nxe³kxa²yã¹nxe² yain³ta³ki³ai²na² ha³lo²a² ũ³yen³ko³nãu³a² ã³yun¹na³ki³ai²yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A²nũ²a² ã̱³xai²na² sa²kxai³lu² Sũ̱³na² wãn³txa² ain³kxi²hĩ¹na¹ wa³su³txi³ ã³ne³wxe³te²ju²hẽ³li¹. Nxe³sxã³ ã³nhai¹tũ³tũ̱³ka̱³txa² Txa²wã¹sũ̱³na² wãn³txa² ain³kxa²so¹sxã³ kan²txi³ i³ka³tu̱³ wi¹lhin¹khai¹nxe³sxã³ sa²yxo²we¹tai¹nha²kxai³ ãh¹ ã³nhai¹tũ³tũ̱³ka̱³txa² ãh¹ ĩ²li³te²a² wi¹lhin¹sxã³ sa²yxo²we¹tai¹nha²kxai³ ãh¹ ã³nhai¹tũ³tũ̱³ka̱³txa² ãh¹ ĩ²li³te²a² jũ¹nxe² wi¹lhin¹sxã³ sa²yxo²we¹tai¹nha²kxai³ nxe³te²ju²hẽ¹li¹. Nxe³kxa² yã¹nxe² yain³ta³ki³ai²na² kxĩh³nxa² ti̱³ti̱n³tũ̱³xa² ã³yun¹na³ki³ai²yã¹nx2na³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ãh¹lxi³sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Ha³lo²a² yan¹nãu³a¹ a²nũ²a² kãi³ain¹kxa² yo³ha² a³ya³ti²ti³wa³kxa² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. A²nũ²ai²na² yain³ta³ki³a² wi¹ki³a² ũ³whĩ̱¹kxi²jah¹lai²yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nxe³jah¹lo²su² nũ²nhai¹. Nxe³yãn¹ta¹ ka³nxah³ti³na² ãu³xi²ti̱³kxai³lu² a²nũ²a² a²ko̱¹ko̱¹su² jah¹la² hãi³a² wxã³nũ²nhai¹. Wxã³te³na¹ a²ki³a² ko̱³nxe³ki³a² hãi³a² ũ³whĩ̱¹kxi²nũ²nhai¹. Nxe³ka³tu̱³ ih³xi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hã²wxãn³txa³nũ² yain³txa³ki³ai²na² ka³lũ̱³ha²kxai³ wi¹we¹nha²kxai³ ai³la² a̱n³ye²nũ²nhai¹. A²nxe³tãu³a² ko̱³nxe³ki³ai²li² te²yã¹nxe³sxã³ ka³lũ³hi² wi¹we¹ni² a̱³ni² nxe³ye²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nxa²ha¹te¹ hai³sxa² wa³kxẽn³yah³lai²na² a²sa³wi³ha³lxa² ã³tĩ̱³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: “Ãu³la³na³xãi³. Nxe³si¹lxi¹. Yain³txa³ka² wi¹ki³ai²na² so¹lxi³ ũ³whĩ̱¹nhĩn¹ta²lu¹wi¹. Yxãn¹ta¹ ĩh¹te²a³ hxi²ki³ta̱³ ko̱³nxe³ki³ai²li² wen¹sĩn¹te²la¹xã³?” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: “Ko̱¹ko̱¹su² jah¹la² hxi²ka² kãi³ũ¹nhẽ³lin¹tai¹.” Nxe³nũ²nhai¹. Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² wãn³txi³kxai³lu¹: “Nxe³kxai²nãn²tu̱³ ko̱³nxe³tẽ³kxa² wxa²ha³txut1sxã³ wxa²nũ²kxi²sĩn¹te³la¹ji¹wi¹?” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nxa²ha¹te¹ wa³kxẽn³yah³lai²na² a²wãn³txi³kxai³lu¹: “Nxe²nxa³wi¹. Hĩ¹na² wxa²nũ²kxi²yah³lxin¹kxai²nãn²tu̱³ yain³txa³ne³kxa² wi¹tẽ³kxa² wxa²ha²txut1jah¹lxin¹kxa²ya̱n³txi³su² nxa¹nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hãi¹nxã¹jah¹lxi³sã²nhẽ³li¹. A²yut3su² we¹nain¹txai²lxi¹. Hã²wxãn³txa³ a̱n³ta³lun²kxai²nãn²tu̱³ yain³txa³ka² wxa²ni²lho¹tũ̱³ka̱³txa² ĩ³ye³kxai¹na¹tu¹wi¹. Nxe³ai¹na¹te³nah¹lxi¹: ‘Ko̱³nxe³tẽ³kxa² wxa²nũ²kxi² sa²so¹jah³lxi³sã²nhẽ³li¹. Yah³lxi³sã²nĩn¹ka³tu̱³ ũ³thũ²hxa³jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹ka³tu̱³ yain³txa³ne³kxa² wi¹kxa² wxa²kxi²so¹jah³lxi³nũ³nhẽ¹li¹, ũ³wha¹a¹thĩ³na²su¹.’ Nxe³ai¹na¹tu¹wi¹.” A²wa³kxẽn³yah³la² nxe³nũ²nhai¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ãh¹lxi³sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wãn³txa² ĩ³yau¹ũ³nx2ta¹jau³xai²yã¹nx2na³li¹. Te³nah¹lxi¹: Hai³sxa² yxau³tẽ³kxa² a²wa³kxẽn³yah³la² yain³txa³ki³a² mos³tar²ta²ki³a² ũ³whĩ̱¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A²nxe³ki³ki¹ai²na² ki³jũ¹lxi³khai¹nxe³ki³su² kxan²ti³ ta³ki¹ai²na² ka³lũ̱³xi²nũ²la² wi¹lwen¹nũ²la² hai³sxa² yxau³tẽ³kxa² wa³to²hi²ton¹nũ²nhai¹. Hi³khai³xa² wen¹nũ²nhai¹. Nxe³sxã³ a̱i³ka² ã³wxã³ha²kxai³ yeh³nxi³nũ²nhai¹. Nxe³kxa² yã¹nxe³sxã³ Txa²wãn³txa² sa²yxo²we¹jah³lxin¹kxai²nãn²tu̱³ wi¹la² ĩ³xã̱³lxi³ti³hi¹txa²ti³tu¹wi¹. Nxe³sxã³ a²wi¹lhĩ¹na² jũ¹nxa² so¹lxi³ yxo²ĩ²sah¹lxin¹kxan²ti³ ye³jen¹na² ã³kãi²non³sxã³ yxo²ĩ²sah¹lxin¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ãh¹lxi³sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wãn³txa² ĩ³yau¹ũ³nx2ta¹jau³xai²yã¹nx2na³li¹. Nxe³jau³xa²sa¹, txu¹ha³ka³lxai²na² te²hi²sen³su² yain³txa² ĩ³wa¹ki³nũ³a² tẽ³ha²kxai³ tri²ka²nũ̱³xa² nẽ³nha¹li¹ ka³na³ki¹ ne³ki³lhi³tẽ³na² ũ³sa²wi¹sxã³ ũ³kxẽ³ni³nũ²nhai¹. Nxe³kxai²nãn²tu̱³ tri²ka²nũ̱³xa² whãi²na¹ ĩ³wa¹je²nũ²nhai¹. Nxe³kxa² yã¹nxe³sxã³ a²wi¹lhĩ¹na² a²nũ²a² ka³lxa¹nxa³te² ĩ³nxai²na² yxo²ĩ²sah³lxi¹lxi¹. Yxãn¹ta¹ yan¹nãu³a¹ a²nũ²a² ka³lxa¹txi³ yxo²ĩ²sain¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jã¹nxe³jut3su² wãn³txa² jau³jau¹xai²na² so¹lxi³ ĩ³yau¹ũ³jau³xai²na² so¹lxi³ e³ta¹hxai²hẽ¹la². E³lxah²lxi³jau³la³ ĩ³ye³kxi²ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nxe³sxã³ wãn³txa² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lu¹tai²na² wãn³txa² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: — Txai²na² sa²kxai³lu² wãn³txa² hãi³a² txa²wã¹ha³lo²a² ãn³si³wxe³hĩ¹nu¹tai²nãn¹te²tu̱³ hãi³a² yxau³jau³xan²tu̱³ ĩ³yau¹ũ³a¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². A²nxe³jau³xu¹tai²na² hĩ¹na¹ we¹ta³lun²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hã²wxãn³txa³ Je³su²jah³lo²su² te²kxai³lu² a²nũ²a²nãu³xai²na² ã³ain¹nũ²la² sxi²ha² ã³wi²xi²ta¹hxai²hẽ¹la². Ã³wi²xi²nũ²la² a²sa³wi³ha³lxi³nãu³a² ã³tĩ̱³ain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Wãn³txa² ko̱³nxe³ki³a² ũ³whĩ̱¹jau³su² ĩ³yau¹ũ³sah¹lxi³hẽ¹li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Txai²na² sa²kxai³lu² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹. Yain³txa³kxa² wi¹kxa² ũ³whĩ̱¹jah¹lai²yãx1jah¹lo²sa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Txa²wã¹ha³lo²ai²na² sa²kxai³lu² hai³sxa²yã¹nx2na³li¹. A²nũ²ai²na² Txa²wãn³txa² yxo²ĩ²sah¹lxin¹te² ĩ³nxai²na² yain³txa³ki³a² wi¹ki³ai²yã¹yxah³lxi¹lxi¹. Sa³ta³na²jah¹la² ĩ³hi²txain¹te²nãu³xa² ko̱³nxe³ki³ai²yã¹nxain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A²ta³a² a²hxi²kan¹jah¹lai²na² Sa³ta³na²jah¹lai²na² sa²kxai³lu² a²nũ²a² a²ko̱¹ko̱¹su² jah¹lai²yã¹nx2na³li¹. Txa²wã¹ha³lo²a² ne³ki³son³ti³wa³kxa² nxe³tãu³su² tãu³ai²na² sa²kxai³lu² hai³sxa² wxa²ni²lho¹kxi²ti³xai²yã¹nx2na³li¹. Oh³xan¹jah¹lo²nãu³xai²na² sa²kxai³lu² yain³txa² wxa²ni²lhon¹tũ̱³ka̱³txai²yã¹nxain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nxe³sxã³ txa²wã¹ha³lo²a² ne³ki³son³ti³wa³kxa² tãu³su² tãu³a² sa²kxai³lu² ko̱³nxe³tẽ³kxa² wxa²nũ²kxi²so¹sxã³ ũ³thũ²hxa³txain¹kxa² yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jã¹nxe³tãu³a² Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² sa²kxai³lu² oh³xan¹te²nãu³xa² ĩ³sa²si¹hã³a¹tu¹wi¹. Ĩ³sa²si¹hã³a¹te³na¹ a²nũ²a² ko̱³nxe³ti³ kãi³si¹nyhain¹te²nãu³xa² whãi²na¹ Sũ̱³na² wãn³txa² sa²yxo²ã³te²na² whãi²na¹ nxe³sxã³ wã²nxa³kxi² so¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wã²nxa³kxi² so¹na¹kxai²nãn²tu̱³ ha³nxe²a² i̱³sa²tẽ³ju³ta² ã³na¹sxã³ wxe³ain¹tu¹wi¹. Nxe³tãu³a² tũ̱¹ka̱³txain²txi³ ye³khãuh³lxa³thi¹nain¹ju³tan¹te²kxa³ya̱³lhu² kãin² nã³ni² kãin² wxi²ka³ta³ta³ti² nxe³sa²tẽ³yah³lxi³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nxe³te²kxa³kxa¹ a²nũ²a² wi¹lhin¹te²lo³te²nãu³xai²na² sa²kxai³lu² Txa²wĩ³na² ha³lo²a²nãu³a² ã³wih¹si¹nyhai¹nha²kxai³ u³je³na³ka² ha²te¹kxa² yã¹nxe² wxi²kin³ti³to³nai¹nha²kxai³ nxe³ain¹tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. Jã¹nxa¹jau³su² wi¹ko̱³nyhah¹lxi³ti³ten³nxa²lxin¹kxai²nãn²tu̱³ ain³kxi¹sah¹lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ãh¹lxi³sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²sa³wi³ha³lxi³lon³ju³ta² a³lxi²khai¹nxe³ju³tai²la¹wi¹. Nxe³sxã³ yen³kxa² a³lxi²khai¹nxe³kxa² hai³sxa²nãu³a² hãi³a² sxa³kxa²yã¹nx2na³li¹. A²nũ²ai²na² kwa² ai³sxã³ a³txi²kxai²nãn²tu̱³ hã²wxãn³txa³ sa²no¹xi²nũ²nhai¹. Nxe³ka³tu̱³ ka³lih³kxi²nha²sxã³ a²yen³kxi³khai³xai²na² ã³nũ²kxi²nũ²la² hai³sxa² a²wa³kxẽn³yah³la² yen³kxa² whãi²na¹ ũ³yho³hi²nũ²nhai¹. Nxe³nũ²la² ta²ko¹xai²na² yen³kxa² hãi³a² sxa³ko³xai²na² so¹kxi²nũ²nhai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ãh¹lxi³sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²sa³wi³ha³lxi³lon³ju³ta² a³lxi²khai¹nxe³ju³tai²la¹wi¹. Nxe³sxã³ a²nũ²ai²na² txah³lxa³ki³a² a³lxi²ki³a² pe²ro³la³ki³a² ã³ten³jah¹la² yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A²nxe³jah¹lai²na² sa²kxai³lu² txah³lxa³ki³a² a³lxi²ki³a² so¹kxi²nyhu¹kxi³te² nũ̱³ka̱³txa² ai³lha²thet3sxã³ ã³ten³nũ²nhai¹. Nxe³tãu³a² a³lxi²ki³a² ĩ²kxai²nãn²tu̱³ hã²wxãn³txa³ a²yen³kxi³khai³xa² whãi²na¹ ã³nũ²kxi²nũ²la² tẽ³sxã³ ũ³yho³hi²ha²kxai³ ta³ki¹ai²na² so¹kxi²nũ²nhai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ãh¹lxi³sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a²nãu³xa² kãi³ain¹kxa² yo³ha² ĩ³yĩ¹li²hain¹ju³ta³nũ³a² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. A̱i³na² ta³lã²na³ki²ka³lo³a² yã¹nxe³na³li¹. A²nxe³ka³lo³ai²na² a̱i³na² ĩ²li³te² he³la³kxa² ĩ³ne³kxih²li² ta³lã²na³ki²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ĩ³ne³kxih¹nũ²la² ka²lo¹ai²na² sa²sai²lho¹nũ²nhai¹. Sa²sai²lho¹nũ²la² ã³wxe³ka³tu̱³ a̱i³na² wi¹te²a² ũ³ha¹i² a̱i³na² ko̱³te²a² ã³na¹i² nxe² wxa²nxa³ki²so¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Te²yã¹nxe³kxe³hũ̱³nxe² txa²wã¹ha³lo²a² ne³ki³so¹nhxan³nhĩ¹na¹ Txa²wã¹sũ̱³na² hi²sen³kxai³lu² oh³xan¹te²nãu³xa² ũ³sa²si¹hã³tu¹wi¹. A²nũ²a² ko̱³nxe³thin¹te²nãu³xa² a²yxo²ha³kxa¹ wã²nxa³kxi²so¹si¹hain¹jau³su² ũ³sa²si¹hã³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nxe³ka³tu̱³ ko̱³nxe³thin¹te²nãu³xan²ta³ ha³lo²ai²na² ha³nxe²a² i̱³xai³ju³tai²na² ã³na¹sxã³ wxe³ain¹tu¹wi¹. Nxe³tãu³a² tũ̱¹ka̱³txain²txi³ ye³khãuh³lxa³thi¹nain¹ju³tan¹te²kxa³ya̱³lhu² kãin² nã̱³ni² kãin² wxi²ka³ta³ta³ti² nxe³sa²tẽ³yah³lxi³tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jã¹nxa¹jau³su² wãn³txa² ĩ³yau¹ũ¹nx2ta¹jau³su² a²yxo²ha³kxa¹ ã³ne³wxe²sa²sai¹yah³lxin¹ta¹ji¹wi¹? Je³su²jah³la² ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ĩ³wã²lũ³xain¹te³nah¹lxi¹: — Kwa²nxi¹lxi¹. Ã³ne³wxe²sa²sai¹sĩ¹na¹wi¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Wãn³txa² ĩ³yau¹ũ³jau³xin³ti² ã³ne³wxe²sa²sai¹yah³lxin¹kxai²nãn²tu̱³ a²nũ²a² yã¹yxah³lxi¹lxi¹. Sũ̱³na² wãn³txa² ĩ³tih³nxe³jah¹la² a²hoh³lxi³su² jah¹la² yã¹yxah³lxi¹lxi¹. Txa²wãn³txa² tah²yau³xa² ĩ³yau¹ũ¹nx2ta¹jau³xai²na² ã³ne³wxe³yah³lxi¹lxi¹. Nxe³yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² Sũ̱³na² wãn³txu¹tai²na² ĩ³yau¹ũ³hi² Txa²wãn³txa² Tah²yau³xai²na² ĩ³yau¹ũ³hi² nxe³yah³lxin¹tu¹wi¹. Nxe³yah¹lxi¹nha²kxai³ sxi²ha² wi¹thĩ³na² a²wa³kxẽn³yah³la² yã¹yxah³lxi¹lxi¹. Nxe³sxã³ a²ya̱³lxi³te²su² te²a² wxã³kxai²nãn²tu̱³ yen³kxa² a³lxi²ki³u¹tai²na² ta̱³nxa² tah²yu³tu¹tai²la³ ta̱³nxa² wã²nã³ũ¹nyhain¹na³li¹. Txa²wãn³txa² ĩ³yau¹ũ³yhah³lxin¹kxai²nãn²tu̱³ te²yã¹nxe² ai³yah³lxi¹lxi¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nxa²ha¹te¹ ĩ³ye³ta³lu²nhxa³tũ²la² ã³waix3ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ã³waix3tũ²la² ã³nxai³sxã³ a²sxi²jen³khai³xa² Na³sa³re²thĩ³na² ã³wih²xi²ta¹hxai²hẽ¹la². Wih²xi²ka³tu̱³ Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih¹sxã³ Sũ̱³na² wãn³txa² ĩ³hen³txi³ta¹hxai²hẽ¹la². Ĩ³hen³txi³ta³lun²tãu³a² ain³kxi²tũ̱³ka̱³txai²na² sa²kxai³lu² ĩ³wã̱³txi³sxã³ e³kxi²nyhain¹te³nah¹lxi¹: — Jah¹lai²li² a²hoh³lxi³khai¹sa²sxã³ ĩ³ye³ha²kxai³ wã³nxĩn¹khaix1nxe³sxã³ o²la³kxi²ha²kxai³ nxe³jah¹lai²la¹wi¹. Yxãn¹ta¹ ĩh¹nxet3sxã³ hxi²ka¹nai¹nhĩ̱³te²la¹ku² ki̱³nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sxi²ha² txon³jah¹lo²su² jah¹la² ta²hai²la¹wi¹. A²hã³ka³nai²na² Ma³ri²a³ka³lxai²la¹wi¹. A²lon³ti³tãu³xa² Ti³a²kah³lo²su² ha²kxai³ Jo³se²ah³lo²su² ha²kxai³ Si³mãu²ah³lo²su² ha²kxai³ Ju³ta²sah³lo²su² ha²kxai³ nxe³ain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A²ha³lĩn³ti³tãu³xa² txa²wã¹yu³ta² yxau²xai³lain¹na³li¹. Nxe³ha²kxai³ ĩh¹nxet3sxã³ ã³nut1sxã³ kãi³hĩ̱³te²la¹ku² ki̱³nhai¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nxe³ha²kxai³ hxi²ye¹ta³lxain¹sxã³ e²nain¹ta¹hxai²hẽ¹la². Nxe³ta¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lai²na² sa²kxai³lu² a²sxi²jen³khai³xan¹ta² nũ̱³ka̱³txai²na² so¹lxi³ a²sxi²khai³xan¹ta² nũ̱³ka̱³txai²na² so¹lxi³ sa²nẽn¹kxi²kxi³la³ yũ³te²sxa³yu²hẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jã¹nxe³ha²kxai³ yxo²ĩ²ai¹nxa³ha²kxai³ hxi²kan¹txi³ wã³nxĩn¹sxã³ o²la³kxi²ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nxa²ha¹te¹ nxe³ti̱³kxai³lu² E³ro²jah³la² Ka³li³le²a²ko³xai²na² a²hxi²kan¹jah¹lai²na² sa²kxai³lu² Je³su²jah³la² o²la³kxi²kxe³su² ha³ta̱³nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nxe³te³na¹ a²sa³wi³ha³lxa² ĩ³ye³kxi²te³nah¹lxi¹, E³ro²jah³lai²na² wãn³txi³kxai³lu¹: — Jah¹lai²li² Jo³ãu² Ba³tis²jah¹lo²sin²tai¹. Ka³te̱n³su² ĩ³sa²yxau³xi²te²sin²tai¹. Nxe³kxe³su² hxi²kan¹khai¹nxe³sxã³ wã³nxĩn¹ti³ o²la³kxin²tai¹. E³ro²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A²kxã³nxa² E³ro²jah³la² te²hi²sen³su² Jo³ãu² Ba³tis²jah³lo²su² te²kxai³ hxi²ki³nũ²la² sa²hxi²tai³kxi²nũ²la² sxi²ha² kan²thĩ³na² ũ³tĩ̱¹kxi²wxe³si¹ta¹hxai²hẽ¹la². A²nxe³jut3su² a²lon³yah³la² Fi³li²pah³lo²su² jah¹la² a²sxe³xa³ka³lxa² E³ro³ti²a³ka³lxu³su² hxai²na²hẽ³la². A²nxe³ta¹ka³lxai²na² hxi²ki³la³sxã³ ũ³txĩ¹kxi²wxe³si¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jã¹nxe³sxã³ kxãn³kxai³ Jo³ãu² Ba³tis²jah³lai²na² a²wãn³txi³kxai³lu¹: — E³ro²jah¹lãi³. Kãi³in¹ju³ta² wai³nxa³wi¹. Wxa²lon³na² sxe³xa³ka³lxa² so¹kxin¹kxai²nãn²tu̱³ wai³nxa³wi¹. Jo³ãu² Ba³tis²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nxa²ha¹te¹ E³ro²jah³lai²na² ẽ¹nãn¹jau³kxai³lu²: — Jo³ãu² Ba³tis²jah³la² su²lhã³si¹ha¹tũ¹xã¹. Jau³su² nxe³ta¹ a²nũ²a²nãu³xa² kwa²hãi¹nxe² ã³si³tẽ³la³kxi²te²nãu³xai²na² wãn³txi³kxai³lu¹: — Jo³ãu² Ba³tis²jah³lai²li² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lai²la¹wi¹. Ain¹jau³su² ha²kxai³ yu̱h³lxi³jau³su² E³ro²jah³lo²su² te²kxai³lu² Jo³ãu² Ba³tis²jah³la² hãi¹sxã³ ũ³tĩ̱¹kxi²wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nxa²ha¹te¹ a²ha² yan¹nãu³kxai³lu¹ E³ro²jah³lai²na² a²hi²sen³kxai³lu¹ a²hã³ka³na² ẽ¹na² a³li³la¹hain¹ju³tai³tã² ain³kxi¹xi²te³lhxã³ kãi³ain¹ta¹hxai²hẽ¹la². Kãi³ain¹ju³ta²sa¹, E³ro³ti²a³ka³lxai²na² a²ka³ne³lxai²na² wxã³sxã³ nũh¹ ã³nha³te̱³yain¹ta¹hxai²hẽ¹la². Nxe³sxã³ E³ro²jah³la² ĩ³ka³lxi³kxi²ta¹hxai²hẽ¹la². A²nxe³ju³tai²li² E³ro²jah³la² ya̱³lxi³te²nãu³xa² yxau³sxã³ ĩ²lxain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nxa²ha¹te¹ E³ro²jah³lai²na² a²wãn³txi³kxai³lu¹: — Ĩ³ka³lxi³kxi³san¹nhĩ¹. Nxe³sa¹nha²kxai³ yen³kxa² ĩ²li³ju³ta² ĩ³wã̱³txi³san¹kxai²nãn²tu̱³ ũ³hũ¹nxa²ha¹tũ¹xĩ¹. Txa²wã¹sũ̱³na² ĩ²nẽ³lha²kxai³ ya²la³tu̱³ nxe²kãi³ũ¹nxa²ha¹tũ¹xĩ¹. E³ro²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nxa²ha¹te¹ wãin²ta¹ka³lxai²na² sa²kxai³lu² ai³sxã³ a²hã³ka³nai²na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Ĩ³ye³kxi²ka³tu̱³ a²hã³ka³nũ³nu¹ta²kxai³lu² ĩ³wa²lũ³xi²jau³su² ĩ³yau¹ũ³sãn²nũ²la² wãin²ta¹ka³lxa² te²kxai³ E³ro²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Jo³ãu² Ba³tis²jah³la² a²ne³ka² so¹lxi³ ten³sa³nhai¹. Pra²ta²ka³lo³a² ũ³yhe³hẽ²ti³sxã³ ũ³hũ¹sẽ¹li¹. Kwẽn¹tai²na¹ ten³sa³nhai¹. Wãin²ta¹ka³lxai²na² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nxe³ju³tha²kxai³ E³ro²jah³lai²na² ĩ³ãin²txi³ta¹hxai²hẽ¹la². Yxãn¹ta¹ ha³la³je¹nĩn³kxai³ a²wãn³txai²na² a²yen³kxa² wãin²ta¹ka³lxai²na² ũ³hũ¹te³lhxã³ nxe³jau³xai²na² yxo²a̱n³ta³ti³ e³jau³xai²na² a²nũ²a² yxo²ha³kxa¹ ĩ²i² ain³kxi² nxe³ain¹ta¹hxai²hẽ¹la². Nxe³ai¹nha²kxai³ E³ro²jah³lai²na² sa²kxai³lu² wãn³txai²na² ĩ³wa²li²ju³ta³la³ ten³ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nxe³ha²kxai³ kwẽn¹ta²kxai³ a²sa³wi³sa² kwa³na³kxi²ta¹hxai²hẽ¹la². Sxi²ha² kan²thĩ³na² ai³sxã³ Jo³ãu² Ba³tis²jah³la² ũ³nhe³ki²lho¹si¹jau³su² ĩ³sa²si¹hã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nxe³ka³tu̱³ Jo³ãu² Ba³tis²jah³la² ũ³nhe³ki²lho¹nũ²la² a²ne³kai²na² pra²ta²ka³lo³a² ũ³yhe³hẽ²ti³sxã³ wãin²ta¹ka³lxai²na² ũ³hũ¹ain¹ta¹hxai²hẽ¹la². Ũ³hũ¹ain¹ka³tu̱³ ta¹ka³lxai²na² a²hi²sen³kxai³lu² a²hã³ka³na² ũ³hũ¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nxe³ju³tai²na² Jo³ãu² Ba³tis²jah³lai²na² a²sa³wi³ha³lxa² ain³kxain¹ka³tu̱³ ya³lu²te²a² a²ne³ki³txa²ti³hit1sxã³ so¹sxã³ sa²nĩ̱³kxain¹ta¹hxai²hẽ¹la². Sa²nĩ̱³kxain¹nũ²la² Je³su²jah³la² ĩ³hen³txi³si¹jau³su² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² E³ro²jah³lai²na² wãn³txa² ain³kxi¹nxa²ha¹te¹ ka³no¹a²ka³lo³a² ã³wih¹sxã³ ã³waix3ta¹hxai²hẽ¹la². Ha³lo²ai²na² a²nũ²a² yũ³ai¹nxa³je³na² nũh¹xai³sxã³ ã³yit1ta¹hxai²hẽ¹la². Nxe³yãn¹ta¹ a²nũ²a²nãu³xa² ã³si³tẽ³la³kxi²tũ̱³ka̱³txai³tã² ã³waix3jau³su² ain³kxi²tãu³a² sxi²jen³nãu³a² a³li³ain¹sxã³ a²yu³kxa² ĩ³hi²txai³lain¹ta¹hxai²hẽ¹la². Nxe²xai³lain¹nxa²ha¹te¹ ĩ³ne³khauh²kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nxe³nxa²ha¹te¹ Je³su²jah³la² ka³no¹a²ka³lo³a² a³li³xi²tãu³a² tũ̱¹ka̱³txai²na² ka³lxa¹khai¹nxe³tũ̱³ka̱³txa² ĩ²kxain¹ta¹hxai²hẽ¹la². Ĩ²kxain¹te³na¹ ĩ³ãin²ta³kxi²khaix1xain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ ĩ³ton³te²na² ĩ²li³te²na² Je³su²jah³la² hxi²ki³kxai³lu² we²txa³lxi³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nxe³nũ²la² ka³nxah³ta³lon³tãu³a² a²sa³wi³ha³lxa² ã³tĩ̱³ain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ti¹ai²na² sxi²jen³ti³la³ yũ²nxa³ti²tu³wi¹. Ha³lo²a² yain³kxi²ki̱³ju³ta² ha³nãu³hi²nẽ³te¹ni²tu³wi¹. Nxe³ha²kxai³ a²nũ²a²nãu³xa² ĩ³hit2txain¹tũ̱³ka̱³txa² he³hain¹jau³su² sxi²jen³txi³nãu³a² ĩ³sa²si¹hã³txai¹nhẽ³li¹, yain³txa² so¹kxi²nyhain¹te³la³ku¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu²: — Ã³waix3si¹nhẽ³lain¹jau³su² wi¹lxa³wi¹. Wxãi²na¹ yain³txa² ũ³hũ¹txain¹yah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nxa²ha¹te¹: — Yxãn¹ta¹ yain³txa² yũ³ki̱³kxa² kãi²nxa³wi¹. Yain³tũ̱³xa² tũ̱³ha¹li¹ tũ̱³ha¹li¹ ka³na³ki¹ so¹lxi³ a̱i³na² ha¹li¹ so¹lxi³ nxe³te²na² so¹lxi³ yũ³nẽ³na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nxa²ha¹te¹: — Yain³txai²na² a̱i³nai²na² wxa²nũ³ũ¹sah¹lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jã¹nxe³ha²kxai³lu¹: — Si³sa³yu³ta² ã³wxe³si¹hain¹yah³lxin¹jau³su² a²nũ²a² yxo²ha³kxa¹ ĩ³ye³kxi¹txain¹yah³lxi³hẽ¹li¹. Je³su²jah³lai²na² e³jau³su² ha²kxai³ yain³tũ̱³xa² a̱i³na² nxe³sxã³ hxi²tẽ³nha²nũ²la² ten³sa²tã³ka³la³yxo²nũ²la² Sũ̱³na² ĩ³wi¹lxon³kxi²ki̱³jau³su² ĩ³ye³ta¹hxai²hẽ¹la². Nxe²e³ta³lun²ka³tu̱³ yain³tũ̱³xa² wã²nãu²lxi³sxã³ a²sa³wi³ha³lxa² ũ³hũ²xai³ka³tu̱³ a²nũ²a²nãu³xai²na² sa²nũ²xai³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nxe³sxã³ a²nũ²a² a²yxo²ha³kxa¹ yai³nai¹nha²kxai³ ũ³kxain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² hã²wxãn³txa³ yain³txa² wã²nãu²lxi³kxi³su² wã³kon³kxe³su² wxa²yo³so¹ka³tu̱³ ha³ti²a² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³tẽ³na² ĩ³ne³kxi¹lhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A²nxe³sxã³ a²nũ²a²nãu³xa² in³txi³nãu³xa² wa̱³li̱³kha³lhon¹tũ̱³ka̱³txa² ka³lxa²khai¹nxe³sxã³ 5.000 nxe² wa̱³li̱³kha³lhon³txi³ta¹hxai²hẽ¹la². Nxe³kxa²yu³su² a²txu¹txi³nãu³xai²na² a²wẽ³ha³lxi³nãu³xai³na² nxe³sxã³ ĩ³yain³sxã³ ũ³kxain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nxa²ha¹te¹ kwẽn¹ta²kxai³ yain³kxi³su² ta³lun²ka³tu̱³ Je³su²jah³la² hi²sen³su² a²sa³wi³ha³lxai²na² ka³no¹a²ka³lo³a² ã³wih¹sxã³ ĩ̱³ye³nai²na² yxo²ha³ti³lhi³si¹hain¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a² a²nũ²a²nãu³xin³txi² ĩ³xi²si¹hain¹jau³su² ĩ³sa²si¹hã³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ĩ³sa²si¹hã³ka³tu̱³ nũh¹xai³sxã³ wã³la³ka³txa² ka³la³nũ²la² Txa²wã¹sũ̱³na² e³kxi²ta¹hxai²hẽ¹la². Nxe³sxã³ ka³nxa³hi²hĩ¹nãn¹te²tu̱³ nũh¹lxi² e³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jã¹nxe³ti̱³kxai³lu² a²sa³wi³ha³lxa² ka³no¹ai²na² ĩ̱³ye³na² nxũ²kwa̱i³ye³la³nãu³a¹ ne³hẽn³kxi² hãu¹tãu³a² it3ta² kãin²te²a² sa²it3txa²kxai³ ĩ̱³yau³xa² ũn³jau³xa² ne³khau²xi²ha²kxai³ nxe³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nxa²ha¹te¹ ka³la³ka³la²a² ĩ³yxai²lxi²ti³xa² Je³su²jah³lo²kxai³lu² ĩ̱³yau³xa² a²ne³ka³na²ha² ti³ne³wxe³ yxau²xai³sxã³ wxã³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xa² ka³no¹a² yxau³ain¹te²nãu³xa² u²lxi³ ten³sa²tã³ain¹tãu³ Je³su²jah³la² ĩ²ain¹ta¹hxai²hẽ¹la². Ĩ²ain¹sxã³ o²lha²kxai³ ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — A²yãu³ka³txi³sa²lxã²na³na¹. Nxain¹jau³su² ĩ³wxa¹nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nxain¹nxa²ha¹te¹ a²kwẽn¹tai²na¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Nxũ²kwa̱i³lxũ¹jah¹lxi³hẽ¹le¹. Txain¹ta³ta¹we¹. Yu̱h³lxah³lxi³txa³lxe¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nxa²ha¹te¹ Pe²jah³lai²na² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Ya³la³tu̱³ nxĩn¹kxai²nãn²tu̱³ ĩ̱³ye³na² a²ne³ka³na²ha² ti³ne³wxe³ yxau²xai³sxã³ ã³nxai³sxã³ ã³tĩ̱³si¹nxa²ha¹jau³su² ĩ³ye³kxi¹sẽ¹li¹. Pe²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³ti³kxai³lu¹: — Ã³wxã³txu¹li¹. Jau³su² nxe³ha²kxai³ Pe²jah³lo²su² te²kxai³lu² ka²no¹a²ka³lo³a² a³li³xi²nũ²la² ĩ̱³yau³xa² a²ne³ka³na²ha² ã³nxai³sxã³ Je³su²jah³lo²kxai³ ã³nhe²kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nxe³nxa²ha¹te¹ Pe²jah³lo²kxai³lu² it3tai²na² nũ³kxũn³sa²ik3kxi³su² ĩ²tãu³ yu̱h³lxi³jau³su² ã³nxũ̱¹txãn³si³wxe³ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³kaix1te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Ã³non²ta³kxi¹sẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nxe³nũ²la² a²kwẽn¹tai²na² Je³su²jah³la² hi²sen³kxai³lu² a²hxi²ka² ĩ³sa³nxũn³sxã³ hxi²ki³kxi²ta¹hxai²hẽ¹la². Te³nah¹lxi¹: — Yxo²ĩ²san¹ju³tai²na² kãi²nxãn³tai¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ĩ³wã̱³wã̱³txi³san¹ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nxe²e³ta³lun²nũ²la² ka³no¹a²ka³lo³a² ã³wi²xi²ya³ta¹hxai²hẽ¹la². Nxe³tãu³ kwẽn¹ta²kxai³ it3tai²na² ã³wxe³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nxe³ju³tai²na² ka³no¹a² yxau³ain¹te²na² ĩ²ai¹nha²kxai³ e³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ya²la³tu̱³ Txa²wã¹sũ̱³na² Tah²si¹lxi¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nxa²ha¹te¹ ĩ̱³ye³nai²na² yxo²ha³ti³lhi³ka³tu̱³ ha³lo²a² Je³ne³sa³re²ko³xa² wa²li³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nxe³ka³tu̱³ ha³lo²a² yxau²xai³lain¹te²nãu³xa² Je³su²jah³la² ĩ²kxi²xain¹tãu³a¹ a²nũ²a² ĩ³ton³te²a² sa²so¹ain¹ta¹hxai²hẽ¹la². Ti²ta³lo³an¹ko³xai²na² ĩ³sa²si¹hã³sxã³ ĩ³ta³ka³txa² yũ³te²na² sa²so¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sa²so¹ain¹te²na² a²ẽ¹nãn¹jau³kxai³lu¹: — Je³su²jah³lai²na² a²wã²la² yxo²ka³teh³tĩh³nãu³a² so¹lxi³ wxa²to³ha¹kxai²nãn²tu̱³ a²kwẽn¹tai²na¹ we²nxi²ta³lun²sa³tũ¹xã¹. Nyhain¹jau³su² nxe³sxã³ wxa²to³nyhain¹te²na¹ ĩ²li³te²na¹ a²kwẽn¹tai²na¹ we²nxi²ta³lu²nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nxa²ha¹te¹ a²nũ²a² fa³ri³se²a² nũ̱³ka̱³txa² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² ã³nhai¹tũ³tũ̱³ka̱³txa² ĩ³sa²si¹hã³ain¹ta¹hxai²hẽ¹la². Je³ru³sa³lẽ²thĩ³na² a³li³ain¹sxã³ Je³su²jah³la² ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","— Txa²wã¹si³yah³la²nãu³xu¹tai²nãn¹jau³xa² ĩ³tih³nxe³nẽ³lain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³nẽ³lain¹te³nah¹lxi¹: “Yain³te³lhxã³ yxah³lxin¹kxai²nãn²tu̱³ hxi²khai²lxi²jah³lxi³sã²nhẽ³li¹. Yxah³lxin¹kxai²nãn²tu̱³ wxa²ẽ¹nãu³ai²na² Sũ̱³na² yen³nãu³a² wi¹lhin¹ye²tu¹wi¹.” Txa²wã¹si³yah³la²nãu³xu¹tai²na² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³yãn¹ta¹ wxa²sa³wi³ha³lxai²na² sa²kxai³lu² te²yã¹nxe² kãi³yai¹nxãn³tai¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ wãn³txu¹tai²nãn¹jau³xai²na² sa²yxo²ã³ain¹ji¹wi¹? Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Kwa²nxi¹lxi¹. Wxa²si³yah³la²nãu³xu¹tai²na² wãn³txa² so¹lxi³ sa²yxo²we¹jah³lxi³hxain¹nhẽ³li¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² wãn³txa² ĩ³ye³kxi²nẽ³jau³xu¹tai²na² sa²yxo²ã³yah³lxi³hxai¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nxe³sxã³ Txa²wã¹sũ̱³na² wãn³txai²na² nxe³te³nah¹lxi¹: “Wxa²wĩ³na² wxa²hã³ka³nai²na² wi¹kãi³ũh¹xai³jah¹lxi³hẽ¹li¹.” Ta¹hxai²hẽ¹li¹. A²nxe³jau³xa² yã¹nxe³te³nah¹lxi¹: “Wxa²wĩ³na² ta̱³nxa² wxa²hã³ka³na² ta̱³nxa² ko̱³nxe³jau³su² nxe² kãi³ain¹kxai²nãn²tu̱³ nxe³te²su² te²a² ĩ³su²lhã³jah¹lxi³hẽ¹li¹.” Txa²wã¹sũ̱³na² wãn³txa² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nxe³yãn¹ta¹ wxa²wãn³txa² e³kxah¹lxin¹jau³su² nxe³yah³lxin¹te³nah¹lxi¹: “A²nũ²a² ĩ²li³te²su² te²a² a²wĩ³na² ta̱³nxa² a²hã³ka³na² ta̱³nxa² yen³kxa² wã³kon³kxain¹kxe³su² ĩ³ye³kxi²te³nah¹lxi¹: ‘Wĩ³na² nxe³txi¹. Txa²yen³kxa² ũ³hũ¹na¹tũ¹xã¹. Nxa¹hẽ¹li¹. Yxãn¹ta¹ sa²yat1sxã³ Txa²wã¹sũ̱³na² so¹lxi³ ũ³hũ¹ai¹na¹tu¹wi¹, txa²yen³kxai²na²su¹.’ Nxe³jau³su². ");
INSERT INTO nabNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nxe³kxai²nãn²tu̱³ yen³kxa² ũ³hũ¹ai¹nxa³ju³ta² wain³na³li¹.” Nxe³yah³lxi³to³hi¹nhẽ³li¹. Nxe³yãn¹ta¹. Nxe² kãi³yah³lxin¹kxe³su² ha²kxai³ Sũ̱³na² wãn³txa² ĩ³hxi²ka¹nxa³si¹yhah³lxin¹jau³su² nxe³te²lo³jah³lxi¹nha²kxai³ wxa²si³yah³la²nãu³xu¹tai²na² wãn³txa² sa²wa²lho¹xi²yah³lxi¹nha²kxai³ nxe³yah³lxi³to³hi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wi¹lhin¹ki³lxo³tũ̱³ka̱³txi³su² yah³lxi¹lxi¹. I³sa³i²ah³lu¹tai²na² wãn³txa² nxe³jah¹lu¹tai²na² wãn³txai²na² ĩ³yau¹ũ³nhẽ³jah¹lo²yãx1jah¹lo²nãu³syah¹lxi¹lxi¹. Nxe³te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Txa²nũ̱³ka̱³txai²na² a²yxo²wãn³txa² so¹lxi³ sa²nẽn¹kxi²ti³hit1sain¹na³li¹. Yxãn¹ta¹ a²ẽ¹nãn¹jau³xai²na² Sũ̱³na² Na¹xai²na² ten³sain¹jau³xa² yũ³ai¹nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yxãn¹ta¹ kwa²hãi¹nxe² sa²nẽn¹kxi²sa²ki³lxot3sai¹nhxai²na²hẽ³li¹. A²wãn³txai²na² ĩ³tih³nxe³nyhain¹jau³xai²na² a²nũ²a² wãn³txa² sa²so¹sxã³ Sũ̱³na² wãn³txi³su²ki³lxo³jau³su² ĩ³tih³nxe³nyhain¹to³hxai²na²hẽ³li¹. Nxe³jau³su² I³sa³i²ah³lu¹tai²na² wãn³txa² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Je³su²jah³lai²na² a²yxo²wãn³txa² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nxe²e³ta³lun²nũ²la² a²nũ²a²nãu³xa² ĩ³hit2tain¹tũ̱³ka̱³txa² ĩ³kaix1tain¹te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Ain³kxi²sa²sxã³ a³la³kxi¹jxah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Txa²wã¹yxo²a² ũh³yxo²wi¹nhẽ³kxe³su² hai³txi³ ko̱³nxe³ti³hit1tẽ³lxa³wi¹. Yxãn¹ta¹ txa²wã¹yxo²a² sa²yxo²sai¹nẽ³kxe³su² ko̱³nxe³ti³hit1tẽ³na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nxa²ha¹te¹ Je³su²jah³la² a²sa³wi³ha³lxai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Wãn³txa² kwẽn¹ta² e³kxin¹jau³xai²na² sa²kxai³lu² fa³ri³se²a² nũ̱³ka̱³txa² ã³nhai¹tũn³te²nãu³xai²na² ĩ³a̱n³txi¹si¹hai¹ni¹nhẽ²li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Hai³sxa³nãu³ai²na² hĩ³ne³kxa² Txa²wĩ³na² Oh³xan¹jah¹lai²na² sa²kxai³lu² ũh³wĩ̱¹xa³tẽ³kxa² hãi¹nxe³ti³xa¹ ha³tut1si¹hain¹jau³su² kwa³na³ain¹tu¹wi¹. Nxe³kxe³hũ̱³sxã³ fa³ri³se²a² nũ̱³ka̱³txa² sa²kxai³lu² hĩ³ne³kxa² Txa²wĩ³na² ũ³whĩ̱¹xa³tẽ³kxa² yã¹xain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nxai¹nha²kxai³ hãi¹nxã¹txain¹yah³lxi³hẽ¹li¹. A²nũ²a² ye³han³jah¹la² yã¹nxain¹na³li¹. Nxe³sxã³ ye³han³tũ̱³ka̱³txa² ne³ka²ta¹sxã³ ã³sa²so¹nyhain¹na³li¹. Nxe² kãi³ain¹ke³la³te²kxai³ kxĩh³nxẽ¹na² ne³ka²ta¹jah¹la² ã³nãu²i² yo³nãn¹tũ̱³ka̱³txa² ã³nãu²ai¹ni² nxe³yain¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nxa²ha¹te¹ Pe²jah³lai²na² a²wãn³txi³kxai³lu¹: — Je³su²jah³lãi³. Jau³jau¹xai²na² ĩ³yau¹ũ³txa²sĩ¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Tũ̱¹ka̱³txai²na² yã¹nxe² ain³kxi²sah¹lxan³ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yain³txa² ĩ²li³te²la³ txa²wã¹yxo²ai²na² ũh³yxo²wih¹nha²sxã³ ĩ³yo¹ki̱³kxai²nãn²tu̱³ txa²wã¹ẽ¹nãu³lon³sxã³ tan²sa²tã³ki̱³te²jai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yxãn¹ta¹ txa²wã¹yxo²ai²na² sa²yxo²sai¹kxai²na² sa²kxai³lu² txa²wã¹ẽ¹nãu³ãn¹jau³xa² so¹lxi³ sa²yxo²sai¹nha²kxi²te²jai¹ti²tu³wi¹. A²nxe³ju³tai²na² so¹lxi³ Txa²wã¹sũ̱³na² yen³nãu³a² ĩ³ko̱³nxe³ti³hin¹nẽ³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Jã¹nxe³sxã³ txa²wã¹ẽ¹nãu³ai²na² wã²nxũ̱¹ha̱in³nha²jau³xai²na² sa²ne³sai¹nha²ju³ta²sa¹: Ko̱³nxe³ti³ a̱in³nha²jau³su² sa²ne³sai¹nha²ha²kxai³ a²nũ²a² su²lhã³nyhu¹kxi³ju³ta³nũ³a² sa²ne³sai¹nha²ha²kxai³ a²nũ²a² ã̱³xa² a²txu¹ha² ũ³whĩn¹ta³kxi²nyhu¹kxi³ju³ta³nũ³a² sa²ne³sai¹nha²ha²kxai³ ko̱³nxe³thin¹sxã³ o²la³kxi²kxi³ju³ta³nũ³a² sa²ne³sai¹nha²ha²kxai³ yen³kxa² kãi³kxi²nyhu¹kxi³ju³ta³nũ³a² sa²ne³sai¹nha²ha²kxai³ ki³han³sxã³ ko̱³nxe³ti³ kãi³ti³hit1jau³su² sa²ne³sai¹nha²ha²kxai³ ki³han³jau³su² ã³ye³yxo²nũ¹nyhu¹kxi³jau³su² ĩ³ne³kxe³kxi²nha²ki̱³sa²kxai³ txa²wã¹ẽ¹nãu³ai²na² te²jai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ju¹tai²na² so¹lxi³ Txa²wã¹sũ̱³na² yen³nãu³a² ĩ³ko̱³nxe³ti³ ti³hi¹tẽ³te²ju²hẽ³li¹. Yxãn¹ta¹ kwa²hãi¹nxe² ĩ³yain³te³lhxã³ nxe³ki̱³ti³wa³kxa¹ hxi²khai²lxi²ki̱³sxa³ke³la³te²kxai³ hai³txi³nũ² Txa²wã¹sũ̱³na² yen³nãu³a² ĩ³ko̱³nxe³ti³ ti³hi¹tẽ³lhĩ̱³nx2nxa³wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hã²wxãn³txa³ Je³su²jah³la² a³li³xi²nũ²la² Ti²ro³thĩ³nãn¹ta³ko³nãu³a² Si³tõ²thĩ³nãn¹ta³ko³nãu³a² ã³nxai³ta¹hxai²hẽ¹la². A²sa³wi³ha³lxa² ã³si³tẽ³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nxe³tãu³a² txu¹ha² Ka³na³ã²ko³xan¹ta¹ka³lxa² Ju³te²a² nũ̱³ka̱³txi³sxa³ta¹ka³lxa² a²sxi²khai³xa² a³li³kxi²nũ²la² Je³su²jah³la² ã³tĩ̱³sxã³ ĩ³kaix1te³nah¹lxi¹: — Txa²wã¹hxi²kan¹jah¹lãi³. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3txa²jah¹lo²su² jah¹lo²si¹lxi¹. Txa²wãi³lxi³na² we²txi²ju³ta² hxi²ka¹nĩn¹ju³ta² yũ²na³li¹. Jã¹nxe³sxã³ ko̱³nxe³te² yãu³ka³txai²na² hxi²ka² txa²wãi³lxi³na² nxũ²kwa̱i³yxaun³tai¹. Khãuh³lxa³thi²kxi²sain¹na²hẽ³li¹. Nxe³ju³tai²na² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nxe³ju³tan¹te²kxa³ya̱n³tu̱³ Je³su²jah³la² ĩ³wa²lũ³xi²ta¹hxai²nxa³hẽ¹la². Nxe³te³na¹ a²sa³wi³ha³lxai²na² wãn³txi³kxai³lu¹: — Je³su²jah³lãi³. Ta¹ka³lxai²na² ã³ni³si¹nhẽ³jau³su² ĩ³sa²si¹hã³txa²hẽ³li¹. Txa²wã¹yo³na² ĩ³kaix1txi²nẽ³to³nha³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — A²nũ²ai²na² I³sa³e² nũ̱³ka̱³txi³su² te²a² o³ve²a² tĩ¹kxi²xai³kxa² yã¹nxe³ te²nãn²tu̱³ nxe³te²a² so¹lxi³ sa²hau³kot3si¹hai¹na¹jau³su² wxã³na¹hẽ³li¹. A²nũ²a² Ju³te²a² nũ̱³ka̱³txi³sxa³te²su² te²na² sa²hau³ko³tai¹na¹ju³ta² ti³wa³ki³lo³nxa³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nxe³tãu³ãn²tu̱³ta¹ ta¹ka³lxai²na² sa²kxai³lu² yxau³son³kxi²nũ²la² ã³ka³ti³wxe³ka³tu̱³ ĩ³ye³te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Hxi²nũn¹sẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nxa²ha¹te¹: — Nxe³sa²nxi¹. Wẽ³ha³lxai²na² yain³txũ³xa² sa²so¹sxã³ wai³a³lxa² ũ³hũ³sxã³ ũ³yhai¹kxi²kxi³ju³ta² wai³nhĩ̱³nx2nxa³xĩ¹. Ta¹hxai²hẽ¹la². Jã¹nxe³jut3su² Ju³te²a² nũ̱³ka̱³txi³su² te²an²tu̱³ wẽ³ha³lxi³su¹ nxe² ĩ³yĩ¹li²ha²kxai³ Ju³te²a² nũ̱³ka̱³txi³sxa³te²su² te²an²tu̱³ wai³a³lxi³su¹ nxe² ĩ³yĩ¹li²ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jã¹nxe³nxa²ha¹te¹ ta¹ka³lxai²na² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Nxe²nxa³wi¹. Yxãn¹ta¹ a²wa³kxẽn³yah³lai²na² ĩ³yain³ka³lo³a² yu³hẽ³nãu³a² wai³a³lxa² hi²sen³su² wah³nxain¹sxã³ yain³tũ̱³xa² kwa² ã³na¹kxe³su² ĩ³yai³nxai³lain¹te²ju²hẽ³li¹. Wxa²nũ̱³ka̱³txi³su² te²sxa³kxan²ti³ txa²wãi³lxi³na² we²txi¹sĩ¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³nxi¹. Yxo²ĩ²sa²sxã³ te³nĩn¹jau³su² ha²kxai³ ain³kxi¹nxa²ha¹xĩ¹. Wxa²wẽ³sai²na² kwẽn¹tai²na¹ we²txi²na¹xĩ¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Hã²wxãn³txa³ ko¹xai²na² a³li³xi²nũ²la² ĩ̱³ye³na² Ka³li³le²a²ye³na² yxo²ka³te³tĩh³na² ã³nxai³ta¹hxai²hẽ¹la². Ã³nxai³tãu³a² wã³la³ka³txa² ka³la³sxã³ ã³wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nxe³tãu³a¹ a²nũ²a²nãu³xa² ka³lxa¹sxã³ wxã³sxã³ nũ²nain¹ta¹hxai²hẽ¹la². Ain¹sxã³ a²nũ²a² ĩ³ton³te²na² tẽ³ain¹ta¹hxai²hẽ¹la². Nxe³sxã³ a²nũ²a² yu̱³kan²ta³kxi²te²su² te²a² ye³han³te²su² te²a² yxo²kan²te²su² te²a² nũ̱³ya³nãn³ta³kxi²te²su² te²a² nxe³sxã³ ĩ²li³ka³txa² ĩ³ton³kxi²te²su² te²a² tẽ³ain¹ta¹hxai²hẽ¹la². Tẽ³ain¹nũ²la² Je³su²jah³la² yu³hẽ³nãu³a¹ ũh³wxe³ain¹ka³tu̱³ a²nũ²a² a²yxo²ha³kxa¹ Je³su²jah³la² hxi²ka² we²txa³lxi³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nxe³ka³tu̱³ta¹ tẽ³ain¹tũ̱³ka̱³txa² ĩ²ain¹te³nah¹lxi¹ a²nũ²a² yxo²kan²te²su² te²a² wi¹le³ha²kxai³ nũ̱³ya³nãn³ta³kxi²te²su² te²a² nũ̱³wi¹lha²kxai³ yu̱³kan²ta³kxi²te²su² te²a² wi¹lã³nxai³ha²kxai³ ye³han³te²su² te²a² wi¹lĩ²ha²kxai³ nxe³ju³tai²na¹ ĩ²tãu³ o²lain¹sxã³ I³sa³e² A²hxi²kan¹ta² Txa²wã¹sũ̱³na² Si³yxau³jah¹la² ĩ³sa²nẽn¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² a²sa³wi³ha³lxa² ĩ³kaix1sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Tũ̱¹ka̱³txai²na² ĩ³ãin²ta³kxi²na¹nhai¹. Ye³ha¹li¹ ka³na³ki¹ a³lan²tãu³a² ã³si³tẽ³la³kxa² ho³ha³sain¹na²hẽ³li¹. Nxe³hĩ¹nãn¹te²tu̱³ yain³txi³la³ yũ³ai¹nxa³ha²kxai³ ã³nxai³si¹hai¹na¹jau³su² ten³sa²nxa³nhai¹, heh³ti³sxã³ hxi²tha² ã³ya³hain¹kxa²ya̱n³ti³su² nxa¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Ti¹ai²li² a²nũ²a² yũ²nxa³ko³sin²tai¹. Nxe³ha²kxai³ yain³txi³nũ̱³la³ ũ³kxain¹tũ̱³nũ³la³ ĩh¹nũ¹la³ta̱³ so¹kxi²sĩ¹nhĩ̱³ki̱³te²la¹xã³? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nxe³ha²kxai³ Je³su²jah³la² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Yã¹te² yain³txi³nũ̱³txa³ yũ³nx2ti³ji¹wi¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — Yain³txi³nũ̱³xa² nũ̱³ha¹li¹ nũ̱³ha¹li¹ nũ̱³ha¹li¹ ka³na³ki¹ yũ³sĩn¹na³li¹. A̱i³na² jũx1te²xa² jũ¹nxe² yũ³nũn³sĩn¹na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nxa²ha¹te¹ a²nũ²a²nãu³xa² ã³wxe³si¹hain¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nxe³ka³tu̱³ yain³txi³nũ̱³xa² hxi²tẽ³nha² a̱i³na² hxi²tẽ³nha² nxe³sxã³ Sũ̱³na² ĩ³wi¹lxon³kxi²ki̱³jau³xa² ĩ³ye³ta¹hxai²hẽ¹la². Ĩ³ye³ta³lun²nũ²la² yain³txi³nũ̱³xai²li² wxa²nãu²lxi³sxã³ a²sa³wi³ha³lxa² ũ³hũ²xai³ka³tu̱³ a²nũ²a²nãu³xai²na² wxa²nhũ²xai³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nxe³sxã³ a²nũ²a²nãu³xai²na² a²yxo²ha³kxa¹ yai³nai¹nha²kxai³ ũ³kxin²tain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² yain³txa² wxa²nãu²lxi³kxe³su² wã³kon³kxe³su² wxa²na³so¹sxã³ ha³ti²a² nẽ³nha¹li¹ nẽ³nha¹li¹ nẽ³nha¹li¹ ka³na³ki¹ ne³ki²lhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A²nxe³sxã³ a²nũ²a²nãu³xa² in³txi³nãu³xa² wa̱³li̱³kha³lhon¹tũ̱³ka̱³txa² ka³lxa¹khai¹nxe³sxã³ 4.000 nxe² wa̱³li̱³kha³lhon¹tũ̱³ka̱³txi³la³ ta¹hxai²hẽ¹la². Nxe³kxa²yu³su² a²txu¹txi³nãu³xai²na² a²wẽ³ha³lxi³nãu³xai²na² nxe³sxã³ ĩ³yain³sxã³ ĩ³xũ³kxi²nyhain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jã¹nxe³nũ²la² hã²wxãn³txa³ a²nũ²a²nãu³xai²na² yai³nain¹tũ̱³ka̱³txa² Je³su²jah³la² hi²sen³kxai³lu² ĩ³xi²si¹hain¹jau³su² ĩ³sa²si¹hã³ain¹ta¹hxai²hẽ¹la². Hã²wxãn³txa³ ka³no¹a²ka³lo³a² ã³wih¹ka³tu̱³ ĩ̱³ye³na² yxo²ha³ti³lhi³xi²nũ²la² Ma³ka³tã²ko³xa³ wa²li³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nxa²ha¹te¹ Ma³ka³tã²ko³xa² wa²li³sxã³ ã³wih¹tãu³a² fa³ri³se²a² nũ̱³ka̱³txi³su² te²a² sa³tu³se²a² nũ̱³ka̱³txi³su² te²a² nxe³sxã³ ã³nhai¹tũ³tũ̱³ka̱³txa² sa²kxai³lu² Je³su²jah³la² ko̱³nxe³ti³hit1si¹hain¹jau³su² ã³tĩ̱³sxã³ ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². Je³su²jah³la² oh³nãu³a² wã³nxĩn¹sxã³ kãi³ju³ta² ĩ³yau¹ũ³ju³ta² ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Ka³nxa³hi²nẽ³te³lhxã³ tãu³a² ĩ³ye³kxi²yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yah³lxin¹te³nah¹lxi¹: “Oh³sĩ̱³nai²na² he³hen³yen²tai¹. Nxe³ha²kxai³ ha³lo²a² wi¹ko¹kon¹tu¹wi¹.” Nxe³yah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te²yã¹nxe³sxã³ ã¹ka³nxa³ha²ta³a² nxe³yah³lxin¹te³nah¹lxi¹: “Oh³sĩ̱³nai²na² he³he³nha²kxai³ ti̱³ti̱³nha²kxai³ yen²tai¹. Nxe³ha²kxai³ kãin² wẽ³hã¹nẽ³tu¹wi¹.” Nxe³yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yah³lxi¹nha²kxai³ oh³sĩ̱³nai²na² ã³ye³wxe³yah³lxi¹nhẽ³li¹. Nxe³yãn¹ta¹ wã³nxĩn¹sxã³ o²la³kxi²na¹ju³ta² ĩ²yah³lxin¹kxan²ti³ ã³ye³wxe³sah¹lxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wã³nxĩn¹sxã³ ĩ³yau¹ũ³nx2ta¹ju³ta³nũ³a² ten³yah³lxi¹nhẽ³li¹. Ko̱³nxe³thin¹khai¹yxah³lxi¹nha²kxai³ a²ko̱³nxe³ti³su² o²la³kxi²yah³lxi¹nha²kxai³ yah³lxi³te²si¹lxi¹. Yxãn¹ta¹ wã³nxĩn¹sxã³ ĩ³yau¹ũ³nx2ta¹ju³ta³nũ³a² yũ³nx2ti³xah³lho³li¹. Jo²na³jah³lu¹tai²na² a̱i³na² ẽ¹nãu³ai²na² ka³te̱n³su² sxa³jah¹lu¹tai²na² ĩ³yau¹ũ³jau³xa² so¹lxi³ yũ³nx2ti³na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². Nxe³nũ²la² ã³waix3tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hã²wxãn³txa³ ĩ̱³ye³na² ã³yxo²ha³ti³lhi³ain¹ta¹hxai²hẽ¹la². Ã³yxo²ha³ti³lhi³ain¹tãu³a² a²sa³wi³ha³lxai²na² sa²kxai³lu² a²kxã³nxa² yain³tũ̱³xa² nxe³wã²na³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Fa³ri³se²a² nũ̱³ka̱³txa² sa³tu³se²a² nũ̱³ka̱³txa² nxe³sxã³ a²yain³txa² ĩ³wat1tũ̱³xa² ĩ²jah¹lxi³hẽ¹li¹. Ĩ³ko̱³nxe³ton³kxi¹nx2tai¹nha³ta²wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xai²na² sa²kxai³lu² Je³su²jah³lai²na² wãn³txa² ain³kxi²nũ²la² e³kxi²nyhain¹te³nah¹lxi¹: — Yain³tũ̱³xa² yain³kxi²ki̱³tũ̱³nũ³a² ne³wã²na³ki̱³sa²kxai³ Je³su²jah³lai²na² wãn³txa² nxe² e³kxi²nẽ³na²li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nxe³yãn¹ta¹ Je³su²jah³lo²kxai³lu² e³kxi²nyhain¹jau³xa² ĩ²nha²nũ²la² ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Yxo²ĩ²sah¹lxin¹ju³ta³la³ kãi²nxa³wi¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ yain³tũ̱³xa² yũ³yah²lxan³kxe³su² ĩ³ye³ye³yah³lxin¹ji¹wi¹? Yain³tũ̱³xa² ne³wã²na³yah³lxin¹ju³ta² hxi²ye¹ta³lxi³sa²nxa³nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kxã³nxai³tã² a²nũ²a² ka³lxa¹txi³nãu³xa² wa̱³li̱³kha³lhon¹tũ̱³ka̱³txa² 5.000 nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² yain³tũ̱³xa² tũ̱³ha¹li¹ tũ̱³ha¹li¹ ka³na³ki¹ so¹lxi³ yu³kxan²ti³ a²nũ²a²nãu³xa² yain³sxã³ ĩ³xũ³kxi²sãn²nũ²la² yain³txa² wã³kon³kxa² ha³ti²a² nẽ³ka³lxa¹txi³ ne³ki²lhain¹tẽ³na² ne³wã²na³yah³lin¹ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Te²yã¹nxe³sxã³ kxã³nxa² a²nũ²a² ka³lxa¹txi³nãu³xa² wa̱³li̱³kha³lhon¹tũ̱³ka̱³txa² 4.000 nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² yain³tũ̱³xa² tũ̱³ha¹li¹ tũ̱³ha¹li¹ tũ̱³ha¹li¹ ka³na³ki¹ so¹lxi³ yũ³kxan²ti³ a²nũ²a²nãu³xa² yain³sxã³ ĩ³xũ³kxi²sãn²nũ²la² yain³txa² wã³kon³kxa² ha³ti²a² nẽ³ka³lxa¹txi³ ne³ki²lhain¹tẽ³na² nxe³kxe³su² ne³wã²na³yah³lxin¹ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ã³ne³toh³yhah¹lxan³ji¹wi¹? Hai³txi³ yain³txa³khai³xa² e³kxi¹nx2ti³nxa³hẽ³li¹. Yxãn¹ta¹ fa³ri³se²a² nũ̱³ka̱³txa² sa³tu³se²a² nũ̱³ka̱³txa² nxe³sxã³ yain³txa² ĩ³wat1tũ̱³xa² e³a¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nxe²e³tãu³a¹ ã³ne³wxe³ain¹ta¹hxai²hẽ¹la². Hai³txi³ yain³txi³khai³xa² ĩ³wat1tũ̱³xa² e³kxi²nxa³ha²kxai³ fa³ri³se²a² nũ̱³ka̱³txa² sa³tu³se²a² nũ̱³ka̱³txa² nxe³sxã³ ko̱³nxe³ti³ kãi³ain¹ju³ta² ĩ³yau¹ũ³jau³xa² e³kxi²ha²kxai³ nxe³jau³su² ã³ne³wxe³ ã³si³wxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nxa²ha¹te¹ Se²sa³re²a² Fi³li³po²thĩ³nãn¹ko³xai²na² ã³nxai³ain¹ta¹hxai²hẽ¹la². Ain¹tãu³a² Je³su²jah³la² a²yxo²wãn³txa² a²sa³wi³ha³lxa² ĩ³wã̱³txi³te³nah¹lxi¹: — A²nũ²a² ã̱³xa³nãu³xai²na² sa²kxai³lu² ĩ³yĩ¹li²sain¹jau³xa² e³kxi²nyhain¹kxai²nãn²tu̱³ ĩh¹nxe³jau³ta̱³ ĩ³yĩ¹li²sain¹jau³su² ĩ³ye³lain¹te²la¹xã³? Ĩ³yau¹ũ³nha¹jah³lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Nxe²nxa³wi¹. A²nũ²a²nãu³xai²na² a²ha³tih³xa³ Jo³ãu² Ba³tis²jah³lo²su² ka³te̱n³su² ĩ³sa²yxau³xi²sxã³ wa̱³lxi³jah¹la² ĩ³yĩ¹li²nxai¹nha²kxai³ ã̱³xa² ha³tih³xai²na² sa²kxai³lu² E³li²ah³lo²su² ĩ³yĩ¹li²nxai¹nha²kxai³ ã̱³xa² ha³tih³xai²na² sa²kxai³lu² Je³re³mi²ah³lo²su² ĩ³yĩ¹li²nxai¹nha²kxai³ ã̱³xa² ha³tih³xai²na² sa²kxai³lu² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²su² ĩ³yĩ¹li²nxai¹nha²kxai³ nxe³nyhain¹sĩ¹nhxai²na²hẽ³li¹. A²sa³wi³ha³lxa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txa² ĩ³wã̱³txain¹ti³an¹jau³kxai³lu²: — Nxe³yãn¹ta¹ wxãi²nãn²ta³ ĩh¹nxe³jau³ta̱³ ĩ³yĩ¹li²syah¹lxin¹jau³su² e³yah³lxin¹ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nxa²ha¹te¹ Si³mãu² Pe²jah³lai²na² te²kxai³lu² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wxãi²nãn²ta³ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²jah¹lo²si¹lxi¹. Txa²wã¹sũ̱³na² ka³te̱³na² Si³yxau³jah¹lai²na² Tah²si¹lxi¹. Pe²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nxa²ha¹te¹ Je³su²jah³lai²na² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Wai³ni¹lxi¹. Wi¹lhin¹te²si¹lxi¹. Si³mãu²ah³la² Jo²nah³la² tah²si¹lxi¹. Yxãn¹ta¹ kwa² a²nũ²khai³xa² ĩ³yau¹ũ¹nxa²jau³sxa³wi¹. Txa²wĩ³nu²khai³xa² Oh³nãn¹jah¹la² te²hi²sen³su² ĩ³yau¹ũ¹nxa²jau³xai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Te²yã¹nxe³sxã³ e³kxi²nxa²nũn³na¹wi¹. Pe²jah³lo²si¹lxi¹. Wxa²ĩ³lxai²na² a²si³yxau³tãu³a²su¹ txah³lxa³kxa² wẽn³su² nxe³te²ju²hẽ³li¹. Jã¹nxe³sxã³ sxi²ha² txon³tũ̱³ka̱³txai²na² sa²kxai³lu² txah³lxa³kxa² tẽ³sxã³ kxĩh³nxa² si³tah³nãu³a² ũh³wxe³ain¹te²ju²hẽ³li¹. Hã²wxãn³txa³ a²sxi²khai³xa² ũ³txo³nain¹te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³sxã³ txah³lxa³kxa² si³tah³nãu³a² ũh³wxe³kxa²yã¹nxi¹lxi¹. Txa²wãn³txa² yxo²ĩ²sain¹te² nũ̱³ka̱³txa² a²sxi²ha² yã¹xain¹na³li¹. Jã¹nxe³jut3su² Txa²wãn³txa² ĩ³tih³nxai¹nĩn¹ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² ka³lxa¹txi³ yxo²ĩ²sain¹tu¹wi¹. A²nxe³jut3su² nxe³kxe³su² ya³lu²nẽ³ju³ta³nũ³a² hxi²kan¹txi³ ã³nhe¹kxi²sxã³ ã³nhai³sa³ko³txa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jã¹nxe³jut3su² yan¹nãu³a² yxo²ĩ²sain¹te²nãu³xa² a²wa³kxẽn³yah³lo²su² ti³hi¹txa²ha¹tu¹wi¹. Nxa²ha¹kxai²nãn²tu̱³ oh³nãn¹ko³nãu³ai²na² sa²kxai³lu² ĩ²li³ju³ta² sa²tai²kxa¹kxai²nãn²tu̱³ wxãi²nãn²tu̱³ yuh³nãn¹ko³nãu³a² sa²tai³kxai¹nĩn¹tu¹wi¹. Yxãn¹ta¹ oh³nãn¹ko³nãu³ai²na² ã³wa²su¹kxa¹kxai²nãn²tu̱³ yu̱h³nãn¹ko³nãu³a² ã³wa²su¹txai¹nũ³nĩn¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jã¹nxe³ha²kxai³ a²sa³wi³ha³lxa² ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹. Yxãn¹ta¹ a²nũ²a² ã̱³xai²na² ĩ³hen³txain¹yah³lxi³txa³hẽ¹li¹. Ye¹nx2ta¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nxe³ha²kxai³lu¹ nxe³hĩ¹nãn¹te²tu̱³ a²sa³wi³ha³lxa² ĩ³yau¹ũ³to³te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² Je³ru³sa³lẽ²thĩ³na² ai³na¹ju³ta³nũ³a² yũ²na³li¹. Nxa¹kxai²nãn²tu̱³ I³sa³e² hxi²kan¹txi³su² te²a² Sũ̱³na² sxi²ha² wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txi³su² te²a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²a² nxe³sxã³ te²nãu³xa² ĩ³a̱n³ta³kxi²sai¹nha²kxai³ khãuh³lxa³txi³sai¹nha²kxai³ ĩ³su²lhã³si¹sain¹tu¹wi¹. Nxe³nũ²la² hã²wxãn³txa³ ye³ha¹li¹ ka³na³ki¹ a³la²ni²sxã³ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nxa²ha¹te¹ Pe²jah³lai²na² sa²kxai³lu² Je³su²jah³la² jũ¹nxe² ã³waix3kxi²ya³sxã³ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²hxi²kan¹jah¹lãi³. Ju¹tai²na² nxe² kãi³nxain¹ju³ta³nu³a² wai³nxa³wi¹. Txa²wã¹sũ̱³na² wi¹lĩ²nxa²tu¹wi¹. Nxe² kãi³ũh¹ti³he¹nxain¹nxa³lho³li¹. Pe²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nxa²ha¹te¹ Je³su²jah³la² sa²wa³ti̱³nha²sxã³ Pe²jah³la² ne³nxẽ³na² ĩ³ye³kxi²te³nah¹lxi¹: — Sa³ta³na²jah¹lãi³. Txa²si³yo³na² ã³waix3txu¹li¹. Hxi²ka̱u³ka̱ut3san¹nhai¹. Txa²wã¹sũ̱³nai²na² a²ten³jau³su² ten³nxa²nxa³i¹. A²nũ²ai²na² a²ten³jau³xai²na² so¹lxi³ te³ni¹lxi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nxa²ha¹te¹ Je³su²jah³la² ãh¹e³kxi²te³nah¹lxi¹: A²sa³wi³ha³lxa² ain³kxi²ti³an¹jau³kxai³lu¹: — Nxe³jah³lxi³wxi¹. A²nũ²a² ĩ²li³te²nãn²tu̱³ ã³si³tẽ³kxi²ti³ten³sain¹kxai²nãn²tu̱³ a²ẽ¹nãu³a¹ a̱u³txi³ ten³khai¹nxe³ju³tan²tu̱³ ã³na¹txai²lxi¹. Te²yã¹nxe³sxã³ yxo²ĩ²sain¹ju³tan¹te²kxa³ya̱n³tu̱³ ya²lu¹ju³ta³nũ³a² yu̱h³lxin²nxa³sxã³ ã³si³tẽ³kxi²sain¹txai²li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jã¹nxe³sxã³ a²nũ²a² ĩ²li³te²na² ĩ³ye³kxi²nha²kxai²nãn²tu̱³: “Yuh³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²wi¹la¹tãu³a¹ a³lxi²sa³nha¹. Je³su²jah³lai²na² wãn³txa² sa²yxo²ã³a¹kxan²ti³ ya³lu²ju³ta² ten³sa²nxa³nha¹.” Nxe³nha²kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³lxa³lho³li¹. Yxãn¹ta¹: “Yuh³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²wi¹la¹tãu³la³ a³lxi²sa²nxa³nha¹. Je³su²jah³lai²na² wãn³txa² yxo²ĩ²a¹ju³tan¹te²kxa³ya̱³lhu² ĩ³su²lhã³sain¹kxan²ti³ yxo²ĩ²a¹ju³ta² ã³na¹nxa³lho³na¹.” Nxe³nha²kxai²nãn²tu̱³ Txa²sa³wit3su² sain¹tu¹wi¹. Nxe³kxa²yu³su² Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Te²yã¹nxũn³sxã³ yu̱h³nãu³an¹te² yen³kxa² a²hãi¹nxe³ti³xa¹ so¹kxi²hxa³kxai²nãn²tu̱³ yxãn¹ta¹ a²ẽ¹nãu³ai²na² a²ka³te̱n³su² ju³ta² tĩ̱¹kxi²kxai²nãn²tu̱³ nxe³te²su² te²na² ju³ju¹tai²na² a²yxo²ha³kxa¹ tĩ̱¹kxi²hĩ̱³nx2na³li¹. Hxi²kan¹txi³ ã³wa²li²sxã³ yen³ka³lxa¹kxan²ti³ so¹kxi²xi²hĩ̱³nx2nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yan¹nãu³a¹ Txai²na² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² sa²kxai³lu² Txa²wĩ³na² wxi²kin³ti³ton³ju³ta² ĩ³wxi²kin³ti³ton³sa²sãn²ka³tu̱³ oh³nãn¹ta² sa²si¹hã³tũ̱³ka̱³txa² ã³si³tẽ³kxa² wa²kan³sxã³ wa̱³li²na¹tu¹wi¹. Nxa¹kxai²nãn²tu̱³ a²nũ²a² a²yxo²ha³kxa¹ kãi³xai³ain¹kxa²yo³su² wi¹lhin¹ta̱³nxa² ko̱³nxe³thin¹ta̱³nxa² ũ³yho³hi²xai³ai¹na¹tu¹wi¹. Nxe³ye¹nxa²lxa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Ti¹ai²na² sa²nxũn³sxã³ ain³kxi²sah¹lxin¹te² ĩ³nxai²na² a²ha³tih³ ĩ³nxai²nãn²tu̱³ ya³lu²ju³ta³nũ³a² wa³su³txi³ yũ³yah²lxan³tho³li¹. Wa̱³li²na¹ju³ta³nũ³a² ĩ²sah²lxin¹tu¹wi¹. Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²kxe³nũ³su² a²nũ²a² yxo²ha³kxa¹ hxi²kan¹tãu³lot3sa²ju³ta³nũ³a² ĩ²sah²lxin¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nxa²ha¹te¹ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ a³lan²ni²tãu³kxai³lu² Je³su²jah³la² sa²kxai³lu² Pe²jah³la² ĩ³kaix1tha²kxai³ Ti³a²kah³la² ĩ³kaix1tha²kxai³ a²lon³yah³la² Jo³ãu²ah³la² ĩ³kaix1tha²kxai³ nxe³tũ̱³ka̱³txãn²tu̱³ tẽ³sxã³ wã³la² kĩ³ka³txa² nũh¹lxi³sxã³ ka³la³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ka³la³ain¹ka³tu̱³ a²ne³ka³nah²nãu³a² he¹ain¹tãu³a² Je³su²jah³lai²na² sa²kxai³lu² ĩ³ã̱³lxi³to³nha²ta¹hxai²hẽ¹la². A²yen³nãu³ai²na² sa²kxai³lu² u³je³na³ka² yã¹nxe² ĩ³kxĩ̱³nha²ha²kxai³ a²wã²la² ũ³whi²kxi²nha²ka³lo³ai²na² ha²te¹ju³ta² yã¹nxe² ĩ³han³kxi²txi³nha²ha²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nxe³tãu³ Moi³se²ah³lu¹tai²na² E³li²ah³lu¹tai²na² nxe³ya³sxã³ kwẽn¹ta²kxai³ ã³wxã³ye²yhain¹ta¹hxai²hẽ¹la². Nxe³sxã³ e³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nxain¹tãu³a² Pe²jah³lai²na² e³kxi²te³nah¹lxi¹: — Je³su²jah³la² Txa²hxi²kan¹jah¹lãi³. Ti¹ai²li² ha³lo²a² wi¹khaix1sĩn¹nhai¹. Nxe³sĩ¹nha²kxai³ sxi²ha² thĩ³nha¹li¹ ka³na³ki¹ txon³sĩ¹na¹tu¹wi¹. Wxa²sxi²ha² txo³ni² Moi³se²ah³la² sxi²ha² txo³ni² E³li²ah³la² sxi²ha² txo³ni² nxe³sĩn¹nxa²lxa¹tu¹wi¹, ten³nxa²ke³la³te²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nxe²e³ta³lu²nxa³ta̱³lxa¹ oh³sĩ̱³nai²na² ha²te¹khai¹nxe³sĩ̱³na² ne³ka³ka³khai¹nxe³ha²kxai³ ã³tĩ¹kxai¹nha²kxai³ ã³ye³ãu²la²to³tain¹ta¹hxai²hẽ¹la². Nxe³tãu³ãn²tu̱³ oh³sĩ̱³nãn¹ta² wãn³txa² ain³kxi²nyhain¹te³nah¹lxi¹: — Jah¹lai²na² Txa²ki³lha³lxa² a³lxi²khaix1na¹jah¹lai²la¹wi¹. Wi¹lxo³kxi²khaix1sa²jah¹lai²la¹wi¹. Wi¹lain³kxi¹txai¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² sa²kxai³lu² jau³jau¹xai²na² ain³kxi²tãu³ ã³kxu²thu²kxa² ã³ya³hain¹ta¹hxai²hẽ¹la², kãin² o²lai¹nha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³ a²sa³wi³ha³lxi³su² te²kxai³ ã³tĩ̱³sxã³ wxa²wa̱i³kxain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Yu̱h³lxah³lxi³txa³hẽ¹li¹. Ĩ³sa²yxau³jah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nxe³sxã³ ĩ³sa²yxau³ain¹ka³tu̱³ Je³su²jah³la² so¹lxi³ ĩ²ain¹ta¹hxai²hẽ¹la². A²nũ²a² ã̱³jah¹la² ĩ²ain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hã²wxãn³txa³ a³ka³nxain¹tãu³a² Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Hxi²sxã³nho³jut3sũ̱³ju³ta² a²nũ²a² ã̱³xa² ĩ³hen³txi³yah³lxi³sãn²txa³hẽ¹li¹. Hã²wxãn³txa³ ya³lu²sxa³sã²na¹ka³tu̱³ ka³te̱n³su² ĩ³sa²yxau³xi²sã²na¹ka³tu̱³ hã²wxãn³txa³ a²nũ²a² ĩ³hen³txain¹yah³lxin¹ju³ta³nũ³a² wain³na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² ĩ³wã̱³txain¹te³nah¹lxi¹: — “E³li²ah³lu¹tai²na² txa²nũ² wxã³tu¹wi¹.” Ha³te̱h³nxã³nxa² a²hoh³lxi³su² nũ̱³ka̱³txa² ĩ³hen³txi³nẽ³lain¹to³hxai²na²hẽ³li¹. Ĩh¹nxe³sxã³ nxe²e³kxain¹tax1ji¹wi¹? A²sa³wi³ha³lxa² nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ya²la³tu̱³ E³li²ah³la² wxã³tu¹wi¹. Txa²ne³hẽ³txa² wxã³sxã³ yen³kxa² yxo²ha³kxa¹ sa²hau³ko³tũ¹sa²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yxãn¹tah¹lxa¹ wãn³txi³khai³su² e³kxi¹nx2ta¹wi¹. E³li²ah³la² ã²la² wxã³na²hẽ³li¹. Nxe³txai¹tã² ã³ye³wxe³kxain¹nxa³hẽ³li¹. Ko̱³nxe³ti³ kãi³ju³ta² so¹lxi³ te³nai¹nha²kxai³ ko̱³nxe³ti³ kãi³ũ¹hain¹na²hẽ³li¹. Jã¹nxa¹jut3su² nxe³kxa²yã¹nxe² ko̱³nxe³ti³ kãi³ũ¹sain¹nũn³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nxe²e³ta³lun²ka³tu̱³ e³lẽ³na¹ wãn³txai²na² ã³ye³wxe³ain¹ta¹hxai²hẽ¹la². Jo³ãu² Ba³tis²jah³la² ĩ³yau¹ũ³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nxa²ha¹te¹ kan³sxã³ wa̱³lain¹nxa²ha¹te¹ a²nũ²a²nãu³xai²li² ĩ³hit2tain¹tũ̱³ka̱³txi³nãu³xai²li² ĩ³ha¹txain¹ta¹hxai²hẽ¹la². Ĩ³ha¹txain¹nũ²la² hã²wxãn³txa³ in³txa² ka³na³ka³nat3sxã³ ã³nhe²kxi²ha²kxai³ ã³ka³ti³wxe³nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","— Txa²hxi²kan¹jah¹lãi³. Wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sẽ¹li¹, txa²ki³lha³lxai²na²su¹. Ã³tau³tẽ³kat3sũ̱³ka³txa² kãin² ĩ³ton³na³li¹. Ha³nxe²a² ã³ya³hi² ka³wã³lxai²na² ã³ya³hi² to³hxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Wxa²sa³wi³ha³lxa² we²txain¹si¹jau³su² sa²so¹sxã³ ũ³hũ¹ai¹na¹li¹. Nxe³ta¹ hxi²ka¹nai¹nxa³hẽ²li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Ã³ne³tot3syah¹lxa³lxi¹. Yxo²ĩ²nxã²nxa³sxã³ wain³txa̱in³kxah²lxa³lxi¹, kan²txi³ yxau³kxi¹nx2ta¹kxan²ti³nu¹. E̱n²nx2ta¹ha³ta²wi¹. Wẽ³sai²li² tẽ³sxã³ wxã³jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nxe² e³nxa²ha¹te¹ wẽ³sa² tẽ³sxã³ wxã³ain¹nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² ko̱³nxe³te² yãu³ka³txa² ĩ³kwa̱i²kxi²nũ²la² wẽ³sa² nxũ²kwa̱i³li³ta¹hxai²hẽ¹la². A²kwẽn¹tai²na¹ we²txi²ta³lun²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hã²wxãn³txa³ a²sa³wi³ha³lxai²na² sa²kxai³lu² nũh¹lxi³sxã³ ã³tĩ̱³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³si¹sa²nhĩn¹jau³su² ĩh¹nxe³kxa²ya̱n³ti³ta̱³ hxi²kan¹sĩ¹nxãn³thĩ²li¹? ");
INSERT INTO nabNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Je³su²jah³lai²na² ĩ³wa²lũ³xi²ti³ãn¹jau³kxai³lu¹: — Jũ¹nxe² so¹lxi³ yxo²ĩ²sah¹lxi¹nhẽ³li¹, wãn³txi³su² e³kxi¹nx2ta¹wi¹. Mos³ta²ta²ki³a² yã¹nxe² a²kãin²ju³ta² yxo²ĩ²yah³lxin¹kxai²nãn²tu̱³ wã³la³ka³txai²na² hxi²kan¹txi³ e³yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yah³lxin¹te³nah¹lxi¹: “Wã³la³ka³txãi³. Ti¹ai²na² a³li³txu¹li¹. Nũ¹ka³na¹ ã³yit1sxã³ yxau³txu¹li¹.” Nxe³yah³lxin¹jau³su² ya²la³tu̱³ a³li³hĩ̱³nx2na³li¹. “Hxi²kan¹sa²nxa³nha¹.” Yxah³lxin¹jau³su² yũ³yah²lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yxãn¹ta¹ ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³si¹kxe³su² kan²na³li¹. Yain³txa² ĩ³yain³ki̱³ju³ta² ã³na¹sãn²nũ²la² Txa²wã¹sũ̱³na² ĩ³ye³kxi²sãn²nũ²la² nxe³hĩ¹na² so¹lxi³ ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³hĩ̱³nx2na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nxa²ha¹te¹ Ka³li³le²a²ko³xa² ã³nũ²kxi²nyhain¹ta¹hxai²hẽ¹la². Nxe³tãu³ãn²tu̱³ Je³su²jah³lai²na² sa²kxai³lu² a²sa³wi³ha³lxa² ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² ko̱¹ko̱¹xa² hxi²ka² ã³yũ³so¹sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nxe³sain¹kxai²nãn²tu̱³ ĩ³su²lhã³sain¹tu¹wi¹. Yxãn¹ta¹ su²lhã³sain¹kxan²ti³ ye³ha¹li¹ ka³na³ki¹ a³la²ni²tãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹. Je³su²jah³la² nxe² e³ta³lun²ka³tu̱³ a²sa³wi³ha³lxa² ĩ³ãin²txi³khai¹xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hã²wxãn³txa³ Ka³far²na³ũ²thĩ³na² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wi¹hain¹tãu³a² a²nũ²a² ũ³yho³hi²ki̱³ki³a² so¹kxi²nyhain¹jah¹la² Pe²jah³la² ã³tĩ̱³te³nah¹lxi¹: — Pe²jah³lãi³. Wxa²hxi²kan¹jah¹lai²na² ũ³yho³hi²ki³a² ki³ha¹li¹ ũ³yho²hi²ki̱³kxe³su² ũ³hũ¹sai¹nhxai²nxãn³thai¹li¹? Nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nxe³ha²kxai³ Pe²jah³lai²na² a²wãn³txi³kxai³lu¹: — Kwa²nxi¹lxi¹. Txa²hxi²kan¹jah¹lai²na² ũ³yho³hi²hxai²na²hẽ³li¹. Ta¹hxai²hẽ¹la². Nxe³nũ²la² hã²wxãn³txa³ sxi²ha² ã³wih¹nũ²la² Je³su²jah³la² ĩ³wã̱³txi³te³nah¹lxi¹: — Pe²jah³lãi³. Ĩ³ye³kxi¹sẽ¹li¹. Txa²wã¹ha³lo²a² yuh³xan¹ko³nãu³xa² a²wa³kxẽn³nãu³a² te²hi²sen³kxai³lu² ũ³yho³hi²ki̱³ki³ai²na² ĩh¹te²la³ta̱³ so¹kxi²hĩ̱³te²la¹xã³? A²sa³wi³ha³lxi³nãu³su² ta̱³nxa² kwa² ã³wxã³tũ̱³ka̱³txai²la³ ta̱³nxa² nxe³hĩ̱³te²la¹xã³? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹: ");
INSERT INTO nabNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","— Kwa² wxã³tũ̱³ka̱³txa² ũ³yho³hi²ki³a² sa²so¹kxi²te²ju²hẽ³li¹. Pe²jah³la² ta¹hxai²hẽ¹la². Nxe³sxã³ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Nxe³kxai²nãn²tu̱³ a²sa³wi³ha³lxi³khai³xa² ã³wa²sut1sxã³ yxau³ain¹te²sin²ta²wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yxãn¹ta¹ kwa² ĩ³yxaih¹nẽ³lain¹kxa²ya̱n³txi³su² ĩ̱³ye³nai²na² ai³txu¹li¹. Ain¹kxai²nãn²tu̱³ ta³nu³la² a̱i³na² sai¹ta³wxi²a² ã³na¹txa²hẽ³li¹. Nxẽn¹ka³tu̱³ a̱i³na² sain¹te²a² a²wi¹lhĩ¹nãn¹te²a² sa²yxo²hai¹txa²hẽ³li¹. Nxe³te²na² yxo²ẽ¹nãu³a¹ ũ³yho³hi²ki³a² wxi²sxa³ye¹nx2tu¹wi¹. Nxe³ki³ai²na² wxa²ya³la³xo¹sai¹kxit1sxã³ ũ³yho³hi²ki̱³tũ̱³ka̱³txa² ũ³hũ¹txai¹nhẽ³li¹. Nai¹nĩn¹kxai²nãn²tu̱³ wxãi²na² Txai²na² ã³wa²sut1sxã³ yxau³ki̱³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hã²wxãn³txa³nũ² a²sa³wi³ha³lxa² ã³tĩ̱³ain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lo³txa²hĩ¹na² ĩh¹jah¹lo²ta̱³ hxi²kan¹txi³yxau³jah¹lo²su² hĩ̱³te²la¹xã³? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nxa²ha¹te¹ wẽn³su² sa²so¹sxã³ nxũ²kwa̱i³ye³ye³lot3sxã³ ũh³wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ũh³wxe³ka³tu̱³ a²sa³wi³ha³lxi³nãu³xai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Wãn³txi³su² ĩ³ye³kxi¹nx2ta¹wi¹. Wẽ³ha³lxa² yã¹nxe² ã³yxo²o³tũ¹sxã³ yxo²ĩ²sah¹lxi³hẽ¹li¹. Nxe³sah¹lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²ju³ta³nũ³su² tãu³su² tãu³a² txa²sa³wi³ha³lxi³syah¹lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wxa²ẽ¹nãu³ai²nãn²tu̱³ wẽ³sai²na² yã¹nxe² ĩ³kãi²not3txa³kxe³su² yũ³nyhah¹lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²ju³ta³nũ³su² tãu³su² tãu³a² ĩ³kãi²not3ti³hit1txa²ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te²yã¹nxũn³sxã³ a²nũ²a² ĩ²li³te²na² a³lxi²sa³ha²kxai³ wẽ³sai²na² te²yã¹nxe³ te²he³la³ku³la³ sa²hau³kot3txi³nyhain¹kxai²nãn²tu̱³ txai²na² hxi²nũ¹sain¹kxa² yã¹nxe³hĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","A²nũ²ai²na² yxo²ĩ² ã³si³wxe³te²na² sa²kxai³lu² Txa²wãn³txa² sa²yxo²ã³si¹jau³su² ĩ³tih³nxe³yah³lxi³txa³hẽ¹li¹. Nxe² ĩ³tih³nxain¹kxa²yo³ha² kãin² khãuh³lxa³thin¹tu¹wi¹. A²nũ²a² tah³lxa³kxa² sa³txe̱²khai¹nxe³ka³txa² tẽ³sxã³ ĩ³yxe²ta³kũ¹nha²te²su² jah¹lan²tu̱³ ĩ̱³yau³xa² u¹jau³xa² so¹sxã³ ãn³sa³nũ̱¹ke³la³te²kxai³ nxe³jah¹la² khãuh³lxa³ti³nha²ju³ta² kãi²nhĩ̱³nx2na³li¹. Nxe³kxa²ha³tih³xan²tu̱³ a²nũ²ai²na² kwẽn¹ta² yxo²ĩ² ã³si³wxe³te²na² sa²kxai³lu² Txa²wãn³txa² sa²yxo²ã³sa²si¹hain¹jau³su² ĩ³tih³nxe³te²su² jah¹lan²tu̱³ ko̱³nxe³thin¹khaix1jah¹lo²su² hĩ̱³nx2na³li¹. A²nxe³jah¹la²kxai³la¹ khãuh³lxa³thi¹ wa³to²hi²hai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Txa²wã¹yuh³xan¹ko³nãu³ai²na² hin¹ki̱³tãu³a¹ ko̱³nxe³ti³ kãi³si¹nhẽ³ju³ta² yũ³hxai²ti³ai¹ti²tu³wi¹. Nxe³ha²kxai³ ko̱n³ton³tu¹wi¹. Yxãn¹ta¹ ko̱³nxe³ti³kãi³sih¹nx2ti³jah¹la² ko̱³ton³khai¹nxe³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jã¹nxe³ha²kxai³ ko̱³nxe³ti³ kãi³yah³lxin¹kxa²ya̱n³ti³su² wi¹lĩ²nha¹jah¹lxi³hẽ¹li¹. Nxe³yãn¹ta¹ wxa²hxi²ka² ta̱³nxa² wxa²yu̱³kxa² ta̱³nxa² ko̱³nxe³ti³ kãi³sih¹nx2ti³jau³su² kxai²nãn²tu̱³ ĩ³hxi²yo³la³kã¹nha² ta̱³nxa² ĩ³yu̱³yo³la³kã¹nha² ta̱³nxa² nxe³jah³lxi³hẽ¹li¹. Nxe³ha²kxai³ hxi²ka³na³ka³nat3sxã³ o̱³nha²ta̱³nxa² yu̱³ka³na³ka³nat3sxã³ o̱³nha²ta̱³nxa² nyha¹lxin¹kxan²ti³ yan¹nãu³a¹ ka³te̱³na² ne³ki³so³nxa³ju³ta² ã³wi¹yhah³lxin¹kxai²nãn²tu̱³ wi¹lhin¹yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yãn¹ta¹ hxi²kha¹li¹ o̱³nha²ta̱³nxa² yu̱³kha¹li¹ o̱³nha²ta̱³nxa² nha¹jah³lxi³sxã³ ha³nxe²a² a²lan²ju³ta² ĩ³yũ¹li²nxa³ju³ta² ã³wih¹yah³lxin¹kxai²nãn²tu̱³ ye³khãuh³lxa³ti³nha²khai¹yxah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te²yã¹nxe³sxã³ wxa²ye³nai²na² ko̱³nxe³ti³ kãi³sih¹nx2ti³jau³su² kxai²nãn²tu̱³ ũ³yhe³ki³sa²tã³nha¹jah³lxi³hẽ¹li¹. Nxe³sxã³ ye³ki³ka³na³ka³nat3sxã³ ye³o³nyhah¹lxin¹kxan²ti³ yan¹nãu³a¹ ka³te̱³na² ne³ki³so³nxa³ju³ta² ã³wih¹yah³lxin¹kxai²nãn²tu̱³ wi¹lhin¹yah³lxi³hĩ̱³nxa¹lxi¹. Yxãn¹ta¹ ye³ki³ha¹li¹ ye³o³nyhah¹lxin¹sxã³ ha³nxe²a² i̱³sa²tẽ³ju³ta² ĩ³yũ¹li²nxa³ju³ta² ã³wih¹yah³lxin¹kxai²nãn²tu̱³ ye³khãuh³lxa³ti³nha²khai¹yxah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jã¹nxa¹jau³su² wãn³txi³su² e³kxi¹nx2ta¹wi¹. A²nũ²a² yxo²ĩ² ã³si³wxe³te²na² ne³wã²na³yah³lxi³txa³hẽ¹li¹. Nxe³sxã³ Txa²wã¹sũ̱³na² yen³nãu³a² a²oh³xan¹jah¹lo²khai³xai²na² a²nũ²a² yxo²ĩ² ã³si³wxe³te²na² ĩ³hau³ko³tũ̱³ka̱³txai²li² he¹ho³si¹hxai¹na¹hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jã¹nxa¹jau³su² a²nũ²a² ko̱³nxe³thin¹sxã³ kãi³te²na² a²ẽ¹na² sa²hau³ko³te³lhxã³ wxã³na¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nxex3jah³lxi³sa²lxi¹. A²nũ²ai²na² o³ve²a² ka³lxa¹txi³ 100 nxe³ tũ̱³ka̱³txa² a²wa³kxẽn³yah³lo²sa²nũ²nhai¹. A²nxe³jah¹la² wi¹lhau³ko³tain¹tãu³a² o³ve²a² ka³na³ka³nat3sxã³ wã³la³ka³txa²nãu³a² ã³nxai³sa³tĩ¹kxi²nũ²nhai¹. Nxe³ai¹nha²kxai³ a²wa³kxẽn³yah³lo²su² te²hi²sen³kxai³lu² o³ve²a² a²ka³lxa¹tãu³xa² ã³nũ²la² ã³nxai³sa³tĩ¹te²li² ã³ten³te³lhxã³ ai³lha²thet3tũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Hã²wxãn³txa³ o³ve²a² ã³nxai³sa³tĩ¹te²nãn²tu̱³ ĩ³ha¹txi²kxai²nãn²tu̱³ kãin² ka³lxi³lhain¹nũ²nhai¹. A²ka³lxa¹tũ̱³ka̱³txa² ka³li³lhai¹nha²kxai³ ã³nxai³sa³tĩ¹te²li² kãin² ka³li³lha²kxai³ nxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Te²yã¹nxe³kxe³hũ̱³nxe² Txa²wã¹sũ̱³na² Oh³xan¹jah¹lo²kxai³lu² a²nũ²a² yxo²ĩ² ã³si³wxe³te²na² ka³na³ka³na³kxan²ti³ ya³lu²ha²kxai³ Sũ̱³na² yen³nãu³a² ã³tĩ¹kxi²ju³ta³nũ³su² te³nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jã¹nxe³jut3su² wxa²wã³tã̱³xai²na² ko̱³nxe³ti³ kãi³ũh¹nx2ti³kxai²nãn²tu̱³ ĩ³yau¹ũ³txain¹yah³lxi³sã²nhẽ³li¹. Nxe³yah³lxi³sã²nĩn¹ka³tu̱³ wi¹lain³kxi¹nx2tain¹kxai²nãn²tu̱³ ã³nhãu²no³jah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yxãn¹ta¹ ain³kxi¹nx2ti³xa³kxai²nãn²tu̱³ a²nũ²a² ha¹li¹ ta̱³nxa² ha¹li¹ ka³na³ki¹ ta̱³nxa² ã³sa²so¹sxã³ ĩ³ye³kxi¹xi¹txai¹nhẽ³li¹. Yxah³lxin¹kxai²nãn²tu̱³ ã³ye³yxo²nũ¹nxai¹nhĩ̱³nx2na³li¹, wxa²yxo²wãn³txa² ko̱³nxe³ti³ kãi³ũh¹nx2ti³ju³tai³tã² ĩ³ye³kxai¹nĩn¹jau³xa²su¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jã¹nxe³sxã³ ain³kxi¹nx2ti³xa³kxai²nãn²tu̱³ Txa²wãn³txa² yxo²ĩ²sxã³ yxau²xai³tũ̱³ka̱³txa² ĩ³hen³txi³txain¹yah³lxi³hẽ¹li¹. Nxe³sxã³ yxo²ĩ²tũ̱³ka̱³txa² ain³kxai¹nxa³kxai²nãn²tu̱³ Ju²te²a² nũ̱³ka̱³txi³sxa³te²su² ĩ³yĩ¹li²ha²kxai³ a²nũ²a² ũ³yho²hi²ki³a² so¹kxi²nẽ³jah¹la² yã¹nxe² he³la³kxah³la² ĩ³yĩ¹li²ha²kxai³ a²nũ²a² ĩ³lxa³thi¹nxa³te²a² ĩ³yĩ¹li²ha²kxai³ nxe³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Wãn³txi³su² ĩ³ye³kxi¹nx2ta¹wi¹. Ha³lo²ai²na² ĩ²li³ju³ta² wxi²kan¹sxã³ ĩ³hau³kot3jah³lxin¹kxai²nãn²tu̱³ oh³nãu³nũ¹ka³na¹ jau¹xain²txi³ a²kxã³nxa² ã²la² ĩ³hau³ko³tain¹te²sin²ta²wi¹. Te²yã¹nxe³sxã³ ha³lo²ai²na² ĩ²li³ju³ta² wxi²kan¹sxã³ ã³wa²su¹jah¹lxin¹kxai²nãn²tu̱³ oh³nãu³nũ¹ka³na¹ ju¹tain²txi³ a²kxã³nxa² ã²la² ã³wa²su¹tain¹te²sin²ta²wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jã¹nxe³jut3su² txa²wã¹ha³lo²a² yu̱h³xan¹ko³nãu³xai²na² a²nũ²a² ha¹lin¹te² ĩ³nxai²na² ha³lo²a² ka³na³ka³na³ju³ta² ten³yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² oh³xa²yxau³jah¹la² nxe²ĩ³ye³kxi²yah³lxin¹kxai²nãn²tu̱³ ya²la³tu̱³ ĩ³we¹txa²ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jã¹nxe³ha²kxai³ a²nũ²a² ha¹li¹ ta̱³nxa² ha¹li¹ ka³na³ki¹ ta̱³nxa² nxe³te² ĩ³nxai²na² yxo²ĩ²syah¹lxin¹te² ĩ³nxãn²tu̱³ ã³nũ²kxi²yah³lxin¹kxai²nãn²tu̱³ wxa²nũ²ki³ye³lot3sxã³ yxau²xai³la¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nxa²ha¹te¹ Pe²jah³la² ã³tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Txa²wã³tã̱³xai²na² ko̱³nxe³ti³ kãi³ũ¹hain¹to³kxai²nãn²tu̱³ ĩh¹nxe² ã³nhxai²na¹te²ta²hẽ³li¹? Ye³ka³lxa¹txi³txa³ ne³wã²na³hain¹to³ha¹ju³ta² ne³ki³son³sxã³ ã³na¹a¹hĩ̱³ji¹wi¹? Ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ ka³na³ki¹ ã³nhĩ̱³na¹te²lã¹xã³? Pe²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txa² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Kwa²nxi¹lxi¹. Ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ ka³na³ki¹ ã³ũ¹hai¹nĩn¹kxai²nãn²tu̱³ a²ne³kit3sxa³wi¹. Yxãn¹ta¹ se²te³ ve²ses³ se³tẽn²ta³ nxe² ye³ka³lxa¹khai¹nxe³to³hain¹sã²nĩn¹ka³tu̱³ a²ne³kit3su² tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jã¹nxe³ju³kxai³lu² Txa²wã¹sũ̱³na² ĩ³ãin²ta³kxi²nẽ³lhxã³ ko̱³nxe³ti³ kãi³ki̱³ju³ta² ne³wã²na³jau³su² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Ha³lo²a² a²wa³kxẽn³yah³la² yã¹nx2na³li¹. A²nxe³jah¹lo²kxai³lu² yen³kxih³khaix1nũ²nhai¹. In³txa² ũ³yho³hi²txã³nxa² kwa²sa²so¹xi²te²nãu³xa² a²nũ²a² ka³lxa¹ain¹nũ²nhai¹. Nxe³te²nãu³xa² ũ³yho³hi¹xi²si¹jau³su² ã³yã³nũ²kain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nxe³tãu³ãn²tu̱³ a²nũ²a² ka³na³ka³na³jah¹la² ũ³yho³hi²txã³nxa² 10.000 nxe³txã³nxa² nxã³ka³lxa¹txi³ kxã³nxai³tã² kwa²sa²so¹xi²ha²kxai³ nxe³txã³nxai²na² ũ³yho³hi¹xi²si¹jau³su² kwa³na³kxi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nxe³yãn¹ta¹ ũ³yho³hi²txã³nxa² yũ²nxa³ha²kxai³ a²yen³kxi³khai³xa² a²nũ²xã̱³xai²na² so¹kxi²si¹jau³nũ³su² te³nha²kxai³ a²nũ²khai³xa² yo³ha² te³nha²kxai³ a²sxe³xa² a²yo³ha² te³nha²kxai³ a²wẽ³ha³lxa² yo³ha² te³nha²kxai³ a²wa³kxẽn³yah³lo²su² nũ²nhai¹. Nxe³sxã³ ũ³yho³hi²hain¹kxai²nãn²tu̱³ kwa² wa³ka³li³lo³tain¹nũ²nhai¹. Nxe³kxai²nãn²tu̱³ ũ³yho³hi²txã³nxai³tã² a²kxã³nxa² kwa² sa²so¹kxi²kxa² yo³ha² ũ³yho³hi¹xi²hĩ̱³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nxa²ha¹te¹ in³jah³lai²na² sa²kxai³lu² ã³ka³ti³wxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Txa²hxi²kan¹jah¹lãi³. Ha³lo³kxi² yxaut3sã²nhẽ³li¹. Ye³jen¹tãu³su² ũ³yho³hi²txã³nxai³tã² whãi²na¹ ũ³yho³hi¹hxa³txa²ha¹tu¹wi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nxe³te²kxa³ya̱n³tu̱³ a²wa³kxẽn³yah³lai²na² sa²kxai³lu² ĩ³yan³ta³kxi²nha²sxã³ ũ³yho³hi²txã³nxai³tã² a²yxo²ha³kxa¹ ne³wã²na³nũ²nhai¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² in³txai²na² ã³wa²sut1sxã³ ĩ³xi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nxa²ha¹te¹ in³jah³lai²li² ã³wa²sut1sxã³ ĩ³xi²tãu³a² in³txa² ã̱³xai²na² ĩ³ne³khau²hain¹nũ²nhai¹. A²nxe³jah¹lai²na² sa²kxai³lu² in³txa² ã̱³xai²na² sa²kxai³lu² nxe³te²hxi²ka² ũ³yho³hi²txã³nxa² jũ¹txã³nxa² so¹lxi³ txã³nxãi²na² a²kxã³nxa² kwa²sa²so¹kxi²nũ²nhai¹. Jã¹nxe³tãu³a² in³txa² a²wi¹lhĩ¹nãn¹jah¹lai²na² ĩ³xa̱n³txi³sxã³ in³txa² ã̱³xai²na² wxa²yxe²ta³ta³ki³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Ũ³yho³hi²txã³nxa² kwa²sa²so¹kxi²san¹txã³nxai³tã² hĩ¹na² ũ³hũ¹sẽ¹li¹.” Nxe³nyha¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nxe³ha²kxai³lu¹ in³txa² ã̱³xai²na² wãn³txi³kxai³lu¹ ã³ka³ti³wxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Ha³lo³kxit1sã²nhẽ³li¹. Ye³jen¹na² ũ³yho³hi²txã³nxa² a²yxo²ha³kxa¹ ũ³yho³hi¹xi²nxa²ha¹tu¹wi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nxe³yãn¹ta¹ in³txa² a²wi¹lhĩ¹nãn¹jah¹la² a²yen³kxi³khai³xa² ten³khaix1nxe³ha²kxai³ in³txa² ã̱³jah¹la² hxi²ki³nũ²la² sxi²ha² kan²thĩ³na² ã³na¹sã³wxe³si¹nũ²nhai¹, ũ³yho³hi²txã³nxa² ũ³hũ¹xi²si¹sãn²jau³su¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xai²na² ju¹tai²na² ĩ²kxain¹nũ²la² ĩ³yan³ta³kxai¹nha²kxai³ ha³lo²a² wa³kxẽn³yah³la² ĩ³hen³txain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nxa²ha¹te¹ a²wa̱³kxẽn³yah³lai²na² sa²kxai³lu² in³txa² a²wi¹lhĩ¹nãn¹jah¹la² ĩ³kaix1sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Wxãi²li² kwa²wa³ka³li³yut3ta³lot3san¹jah¹lo²si¹lxi¹. Nxe³yãn¹ta¹ ko̱³nxe³thin¹khai¹nxi¹lxi¹. Wi¹lhin¹sxã³ ĩ³ye³kxi²san¹tai¹ti²tu³wi¹. Nxe³sa¹nha²kxai³ ĩ³ãin²ta³kxi²nha²khaix1nxe³nxa²ha¹tai¹ti²tu³wi¹. Nxe³sxã³ yen³kxa² ũ³yho³hi¹xi²san¹ju³ta³nũ³a² ne³wã²na³ũ¹nxa²ha¹tai¹ti²tu³wi¹, wi¹lhin¹sxã³ ĩ³ye³kxi²sa¹nha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nxe³nxa²ha¹ha²kxai³ in³txa² ã̱³jah¹la²kxai³ wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³tai¹nĩn¹ju³ta² wai³nhĩ̱³ta²lu¹wi¹. Yxãn¹ta¹ wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³txã²ha¹ha²kxai³ jã¹nxe² nxẽ²nxãn³tai¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nxe²e³ta³lun²ka³tu̱³ a²wa̱³kxẽn³yah³lai²na² sa²kxai³lu² ĩ³a̱n³ta³kxi²nha²sxã³ ũ³yho³hi²txã³nxai³ta³lxi³ kwa²sa²so¹kxi²txã³nxai³tã² ũ³yho³hi¹xi²si¹jau³su² kwa³na³kxi²nũ²nhai¹. Nxe³kxa²yo³su² nxe³ti̱³kxai³la² ye³khãuh³lxa³ti³si¹sa²jau³su² a²sa³wi³sa² kwa³na³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jã¹nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² wxa²wã³tã̱³xai²na² ko̱³nxe³ti³ kãi³ũh¹nx2ti³kxai²nãn²tu̱³ wxa²ẽ¹nãu³ai²na² a̱u³txẽ¹nãu³ai²na² ne³wã²na¹ain¹yah¹lxan³kxai²nãn²tu̱³ Txa²wĩ³na² oh³na² yxau³jah¹lai²na² sa²kxai³lu² nxe²kãi³ũh¹nx2ti³tu¹wi¹. Yxãn¹ta¹ wxa²wã³tã̱³xai²na² ko̱³nxe³ti³ kãi³ũh¹nx2ti³kxai²nãn²tu̱³ wxa²ẽ¹nãu³ai²na² a̱u³txẽ¹nãu³ai²na² ne³wã²na³ain¹yah³lxin¹kxai²nãn²tu̱³ Txa²wĩ³na² oh³na² yxau³jah¹lai²na² sa²kxai³lu² nxe²kãi³ũh¹nx2ti³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txa² ĩ³yau¹ũ³ta³lun²ka³tu̱³ Ka³li³le²a²ko³xa² a³li³xi²nũ²la² Jor³tãu²yau³xa² yxo²ha³txih³nãu³a² Ju³te²a²ko³nãu³a² ã³nxai³ta¹hxai²hẽ¹la². Nxe³tãu³a² a²sa³wi³ha³lxa² ã³si³tẽ³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nxe³tãu³ãn²tu̱³ a²nũ²a²nãu³xa² ka³lxa¹txi³ ĩ³hi¹tain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ a²nũ²a² ĩ³ton³te²su² te²a² ĩ²kxain¹kxai²nãn²tu̱³ we²txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nxe³ka³tu̱³ fa³ri³se²a² nũ̱³ka̱³txa² a²ha³tih³xa² ã³tĩ̱³kxain¹ta¹hxai²hẽ¹la². Wãn³txa² ĩ³ki³ha¹kxi²si¹hain¹jau³su² ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². Ĩ³wã̱³txain¹te³nah¹lxi¹: — Je³su²jah³lãi³. In³txai²na² sa²kxai³lu² ĩ²li³tãu³a² a²txu¹ha³ka³lxa² ã³na¹kxai²nãn²tu̱³ wain³ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Sũ̱³na² wãn³txu¹txai²na² ne³wã²na³yah³lxin¹ta²lu¹wi¹. Nxe³jau³xu¹tai²na² nxe³te³nah¹lxi¹: “A²wi¹lhĩ¹nu¹tai²kxai³lu² Txa²wã¹sũ̱³na² hi²sen³su² in³txi³su² txu¹su² wet1ta¹hxai²ti³ai¹ti²tu³wi¹.” ");
INSERT INTO nabNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Te²yã¹nxũn³te³nah¹lxi¹: “Nxe³ju³kxai³lu² in³txai²na² sa²kxai³lu² a²wĩ³na² a²hã³ka³nai²na² nxe³sxã³ ã³waix3tũ²la² a²sxe³xa³ka³lxa² so¹lxi³ tẽ³tu¹wi¹. Nxe³ha²kxai³ in³txa² txu¹ha² a²nũ²ka³na³ka³na³ton³tu¹wi¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jã¹nxe³ha²kxai³ a²nũ²a² ha¹lo³nxa³wi¹. A²nũ²ka³na³ka³na³jah³na³li¹. Nxe³ha²kxai³ Txa²wã¹sũ̱³na² hi²sen³kxai³lu² ã³nũ²kxi²ya³te²sya¹hin²ta²wi¹. Nxe³kxe³su² a²nũ²ai²na² sa²kxai³lu² ã³nhai²ta³lxi³si¹hain¹kxai²nãn²tu̱³ nxe²kãi³yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nxa²ha¹te¹ fa³ri³se²a² te²nãu³xai²na² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Moi³se²ah³lu¹tai²na² wãn³txa² ĩ³tih³nxe³nẽ³lain¹te³nah¹lxi¹: “A²txu¹ha² ã³na¹ti³ten³kxai²nãn²tu̱³ ha³te̱h³nxã³nxa² ã³na¹hxa³txã³nxa² ũ³wha²li¹lhxã³ ũ³hũ¹txai¹li¹.” Nxe³jau³xu¹tai²na² Moi³se²ah³lu¹tai²na² nxe³nẽ³lain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³jau³jau¹xai²na² ĩh¹nxe³kxa²ya̱n³ti³ta̱³ txu¹ha² ã³na¹hxa³txã³nxa² ĩ³tih³nxe³nẽ³lain¹nũ²lhai¹li¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²we¹ti³ten³nxa²lxa³nha²kxai³ Moi³se²ah³lu¹tai²na² wãn³txa² ũ³wha²li¹ta¹hxai²hẽ¹li¹, wxa²sxe³xa³ka³lxu³khai³xa²su¹. Yxãn¹ta¹ a²wi¹lhĩ¹nãu³u¹tai²nãn¹te²tu̱³ Txa²wã¹sũ̱³na² ten³jau³sxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jã¹nxa¹jau³su² in³txa² a²ten³te²su² te²an²tu̱³ a²sxe³xa³ka³lxa² ã³na¹ka³tu̱³ txu¹ha² ã̱³lxi³te²a² so¹ain¹ke³la³te²kxai³ txu¹ha² ã̱³xa² ũ³whĩn¹ta³kxi²kxa² yã¹nxe² hxi²ki³lot3hĩ̱³nx2na³li¹. Ko̱³nxe³ti³ kãi³hĩ̱³nx2na³li¹. Te²yã¹nxe³sxã³ txu¹ha² ã³na¹ta¹ka³lxa² in³txa² ã̱³jah¹la² so¹ke³la³te²kxai³ in³txa² ã̱³xa² ũ³whĩn¹ta³kxi²kxa² yã¹nxe² hxi²ki³lot3hĩ̱³nx2na³li¹. Ko̱³nxe³ti³ kãi³hĩ̱³nx2na³li¹. A²nxe³ta¹ka³lxa² a²sxe³xa³ka³lxa² a²wi¹lhĩ¹na² so¹nyhai¹nxa³ta̱³lxa¹ in³txa² ã̱³xai²li² ũ³whĩn¹ta³kxi² o²la³kxi²nyhu¹ke³la³te²kxai³ txu¹ha² ã³na¹ju³ta² wai³nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² wãn³txa² ĩ³wa²lũ³xain¹te³nah¹lxi¹: — In³txai²na² txu¹hai²na² nxe² kãi³nyhu¹ain¹ke³la³te²kxai³ so¹nyhu¹kxi³ju³ta² a²wi¹lhĩ¹na² wi¹lxa³hẽ³li¹. Nxũh¹lxa³txi³su² yxau²xai³ju³ta² wi¹lhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Jau¹xu¹tai²na² sa²kxai³lu² a²nũ²a² ã³ne³to³hxa³te²na² yũ³te²ju²hẽ³li¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² ĩ³hau³kot3sa²kxai³ nxe³te²su² te²a² wi¹ko̱³nha² a³la³kxain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","A²nũ²ai²na² so¹nyhu¹kxi³ju³ta² hxi²ka¹nyhai¹nxa³te²na² yũ³hxai²na²hẽ³li¹. A²ha³tih³xai²na² wẽ³sa² txo¹nai¹nhĩ¹nãn¹te²tu̱³ a²nũ²khai³xa² wi¹lxa³ha²kxai³ hxi²kan¹txi³ so¹nyhu¹kxi³te²sxa³yu²hẽ³li¹. Ãh¹ a²ha³tih³xai²na² a²hxi²kan¹jah¹la² so¹nyhu¹sih¹xa³jau³su² in³txa² ya³la³ki³a² ya³la³ki²sa²tã³ha²kxai³ hxi²kan¹txi³ so¹nyhu¹kxi³te²sxa³yu²hẽ³li¹. Ãh¹ a²ha³tih³xai²na² Txa²wã¹sũ̱³na² wa³ka³la² so¹lxi³ te³nain¹jau³su² so¹nyhu¹kxi³te²sxa³yu²hẽ³li¹. A²nxe³jau³su² wã²nxũ̱¹hĩ²sxã³ hxi²kan¹kxi³kxe³su² ã³kãi³jah¹lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hã²wxãn³txa³ a²nũ²a² a²wẽ³ha³lxa² tẽ³ain¹ta¹hxai²hẽ¹la². Je³su²jah³la² Sũ̱³na² wi¹lxo³kxi²nẽ³txi³si¹hain¹jau³su² wxa²ne³wai³te²si¹hain¹jau³su² tẽ³ain¹ta¹hxai²hẽ¹la². A²nxe³ju³tai²na² a²sa³wi³ha³lxi³nãu³xa² ĩ³kwa̱i²kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nxa²ha¹te¹ Je³su²jah³lai²na² jut3sĩ²nũ²la² e³te³nah¹lxi¹: — Ne³ka²sah¹lxi³sa²lxi¹. Wẽ³ha³lxa² tẽ³sxã³ wxã³ain¹ju³tai²na² ĩ³hxi²ko²lain¹yah³lxi³txa³hẽ¹li¹. Wẽ³sai²li² a²wĩ³na² wãn³txa² yxo²ĩ²te²ju²hẽ³li¹. Nxe³yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² Txa²wã¹sũ̱³na² wãn³txa² yxo²ĩ²jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² Txa²wã¹sũ̱³na² ha³lo²a² yxau³yah³lxin¹ju³ta³nũ³a² yũ³nx2ti³tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nxe²e³nũ²la² wẽ³ha³lxai²na² Sũ̱³na² wi¹lhin¹sxã³ ĩ²ti³hi¹te³lhi¹hain¹jau³su² wxa²ne³wai³tũ²la² ha³lo²ai²na² ã³waix3ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nxa²ha¹te¹ in³txa² sa³nxe³la³kxah³la² ã³tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Tih³nxe³sa²jah¹lãi³. Ĩh¹ju¹ta̱³ wi¹ju³ta³la³ kãi³a¹ke³la³te²kxai³ ka³te̱³na² wi¹tãu³a² so¹kxi²hĩ̱³na¹te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nxa²ha¹te¹ Je³su²jah³lai²na² ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ yen³kxi³la³ wi¹ju³ta³la³ ĩ³wã̱³txi³san¹ji¹wi¹? Txa²wã¹sũ̱³na² so¹lxi³ wi¹lhin¹khaix1jah¹lai²la¹wi¹. Yxãn¹ta¹ ka³te̱³na² wi¹tãu³nũ³a² ã³wih¹ti³ten³nxa²kxai²nãn²tu̱³ Sũ̱³na² wãn³txu¹tai²na² sa²yxo²we¹thxa³txa²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nxa²ha¹te¹: — Ĩh¹jau¹la³hĩ̱³te²la¹xã³? Ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — A²nũ²a² su²lhã³nyhu¹ah³lxi³txa³hẽ¹li¹. Txu¹ha² ã̱³xa¹ka³lxa² ũ³whĩn¹ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. A²nũ²a² ã̱³xai²na² yen³kxa² kãi³kxi²nyhu¹ah³lxi³txa³hẽ¹li¹. A²nũ²a² ã̱³xai²na² ĩ³ki³ha¹kxi²nyhu¹ah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wxa²hã³ka³nai²na² wxa²wĩ³na² nxe³sxã³ sa²nẽn¹kxain¹yah³lxin¹ju³ta² so¹lxi³ kãi³ũh¹txain¹yah³lxi³hẽ¹li¹. A²nũ²a² a²wa³kxa² yxau³nũ¹nxa²te²a² a³lxi²nha¹jah³lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nxa²ha¹te¹ sa²nxe³la³kxah³lai²na² a²wãn³txi³kxai³lu¹: — Jau¹xai²na² a²yxo²ha³kxa¹ sa²yxo²we¹jah¹lo²sa¹wi¹. Ĩh³jau¹ta̱³ on³te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Sa²yxo²we¹thxa³ti³ten³nxa²kxai²nãn²tu̱³ nxe³sẽ¹li¹. Wxa²yen³kxa² sa²so¹sxã³ a²nũ²a² ã̱³xa² so¹kxi²si¹hin¹jau³su² kãi³txa²hẽ³li¹. Nxĩn¹kxai²nãn²tu̱³ so¹kxi²nxain¹kxa² yo³ha² tẽ³sxã³ a²nũ²a² yen³kxi³txa²te²na² wã²nhũh²xai³txai¹nhẽ³li¹. Nxĩn¹kxai²nãn²tu̱³ oh³nãu³nũ¹ka³na¹ yen³kxa² wi¹ju³ta³nũ³a² yũ³nxa²tu¹wi¹. Jã¹nxe³sxã³ nxe² kãi³ta³lu²nĩn¹kxai²nãn²tu̱³ ã³wxã³sxã³ ã³si³tẽ³kxi¹sẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nxe³jau³xai²na² sa²kxai³lu² sa³nxe³la³kxah³lai²na² sa²kxai³lu² ain³kxi²te³na¹ ĩ³ãin²txi³sxã³ ĩ³ta¹hxai²hẽ¹la². Yen³kxih³khaix1nxe³ha²kxai³ yen³kxa² a³lxi²ha²kxai³ hãi¹sxã³ ĩ³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² a²sa³wi³ha³lxi³nãu³xa² ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Wãn³txi³su² ĩ³ye³kxi¹nx2ta¹wi¹. A²nũ²a² kãin² yen³kxi³te²su² te²a² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ju³ta² wa³lxe³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jã¹nxa¹jau³su² ka³me²la² ka³yxuh³xa² kãin²khaix1te²su² te²a² hai³txi³ a²ku¹wxi²si³xẽ¹na² ã³wih¹sxã³ ã³wa²to¹ti³he¹nxe³lhĩ̱³nx2nxa³wi¹. Yxãn¹ta¹ a²nũ²a² kãin² yen³kxih³khai¹nxe³te²su² te²a² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ju³ta² wa³to²hi² wa³lxe³te²ju²hẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² jau³jau¹xai²na² ain³kxi²tãu³ ĩ³wã̱³wã̱³ta³kxi²nha²sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²wã¹ha³lo²nãu³a² a²nũ²ai²li² yen³kxi³kxai²nãn²tu̱³ Txa²wã¹sũ̱³nu²su² wi¹lhin¹sxã³ ĩ²jah¹lo²su² ye²te²ju²hẽ³li¹. Nxe³jut3su² ha²kxai³ a²nũ²a² yen³kxi³te²su² te²na² kxã̱u³nxa³sxã³ Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³kxai²nãn²tu̱³ a²nũ²a²nãu³xa² hãi¹nxe³ti³xa¹ Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ki̱³sxa³lho³li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nxe³nũ²la² Je³su²jah³la² ĩ²sa²sai¹ain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² hxi²kan¹ti³he¹xai¹nxa³wi¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² hi²sen³su² hxi²kan¹te²lo³jah¹lai²la¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nxa²ha¹te¹ Pe²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Nxex3sãn²si¹lxi¹. Txa²wã¹yen³kxi³khai³xa² ã³na¹sãn²sĩ¹na¹ka³tu̱³ wxãi²na² so¹lxi³ ã³si³tẽ³la³kxi²sĩ¹na¹wi¹. Nxe³sĩ¹na¹ha²kxai³ ĩh¹nxe² ũ³yho³hi²sa²sĩn¹te³ji¹wi¹? Pe²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Wãn³txi³su² ĩ³ye³kxi¹nx2ta¹wi¹. Yan¹nãu³a¹ Txa²wã¹ha³lo²a² tah²lxi³wet1sĩ¹na¹ wxi²kin³ti³ton³sxã³ ha³lo²a² a²yxo²ha³kxa¹ a²wa³kxẽn³si¹ta¹tu¹wi¹. Nxa¹kxai²nãn²tu̱³ wxãi²na² sa²kxai³lu² ã³si³tẽ³kxi²sah¹lxi¹nha²kxai³ Txai²yã¹nxe³sxã³ I³sa³e² nũ̱³ka̱³txi³nãu³xa² ha³txi²ha² hxi²ka² hxan³sxã³ ha¹li¹ wa²sa²so¹xi²nũn³ka³tu̱³ nxe³te²nũ̱³ka̱³txi³nãu³xa² a²wa³kxẽn³su² yah³lxi³nũ³nĩn¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nxe³tãu³a² a²nũ²a² ĩ²li³te²na² Txai²na² a³lxi²sai¹nha²kxai³ sxi²ha² ã³na¹i² a²lon³nãu³xa² ã³na¹i² a²ha³lĩ³ti³nãu³xa² ã³na¹i² a²wĩ³na² ã³na¹i² a²hã³ka³na² ã³na¹i² a²wẽ³ha³lxi³khai³xa² ã³na¹i² hai³sxa² ã³na¹i² nxe³ain¹kxai²nãn²tu̱³ ã³si³tẽ³la³kxi²sain¹te²na² sa²kxai³lu² kãin² wa³to²hi²sxã³ ũ³yho³ha¹nu¹ju³ta² yũ³tu¹wi¹. Nxe³ai¹na¹kxa²yu³su² ka³te̱³na² wi¹tãu³la³ ũ³hũ¹ai¹na¹tu¹wi¹. Te²yã¹nxe³nũn³sxã³ kãi³ũh¹nx2ti³nũ³na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nxe³kxan²ti³nũ¹ sa²nẽn¹kxi²nha²yah³lxi³txa³hẽ¹li¹. Te²yã¹nxe³jut3su² a²nũ²a² ka³lxa²te²nũ̱³ka̱³txa² ĩ³sa²nẽn¹kxain¹ju³ta² yũ³kxan²ti³ yan¹nãu³a¹ ĩ³sa²nẽn¹kxai¹nxa³ju³ta² yũ³tu¹wi¹. Te²yã¹nxe³sxã³ a²nũ²a² ka³lxa²te²nũ̱³ka̱³txa² ĩ³sa²nẽn¹kxai¹nxa³ju³ta² yũ³kan²ti³ yan¹nãu³a¹ ĩ³sa²nẽn¹kxain¹ju³ta² yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jã¹nxe³jut3su² yan¹nãu³a¹ a²nũ²ai²na² kãi³ain¹kxa² yo³ha² a³ya³ti³na¹tãu³a² a²nũ²a² hai³sxa² wa³kxẽn³yah³lo²su² yã¹nxũ³na¹tu¹wi¹. A²nxe³jah¹lai²na² sa²kxai³lu² hai³sxa³nãu³a² ĩ³wa³kon³kxi²tũ̱³ka̱³txa² ĩ³kaix1te³lhxã³ ĩ³yũ¹li²nxa³ta̱³lxa¹ ai³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ĩ³kaix1te³na¹ ĩ³kaix1so¹tũ̱³ka̱³txa² ũ³yho³hi²ki³a² ki³ka³na³ka³na³ki³a² wain³txi³ yo³hi²ye²kxe³su² ũ³hũ¹si¹hain¹jau³su² ĩ³hau³ko³tũh¹nyhain¹nũ²nhai¹. Nxũ²la² hai³sxa³nãu³a² ũ³sa²si¹hã³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hã²wxãn³txa³ ki³ka³la³xi²tãu³a² sxi²je³na² ai³tãu³a² in³txi³nãu³xa² wa³ko³nai¹nxa³te²a² ĩ³ha¹txain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nxe³te²nãu³a² ĩ³ye³kxi²te³nah¹lxi¹: “Txa²hai³sxa³nãu³a² ai³sxã³ wa³kon³kxi²sah¹lxi³hẽ¹li¹. Sah¹lxin¹kxai²nãn²tu̱³ ka³nxah³ta³lon³tãu³a² wain³ju³ta² ũ³yho³hi¹nx2ta¹tu¹wi¹.” Nxe³jau³su² ha²kxai³ in³txi³nãu³xa² ai³sxã³ hai³sxa² wa³kon³kxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Te²yã¹nxe³sxã³ ne³ka³ka³tãu³a² ai³sxã³ ãh¹ĩ³kaix1so¹xi² ĩ³sa²si¹ta³xi²tãu³a² ai³sxã³ ãh¹ĩ³kaix1so¹xi² nxe³to³nhũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Te²yã¹nxe³sxã³ ka³nxa³hi²nxa³ta̱³lxa² ai³lxi²sxã³ in³txa² ãh¹ĩ³ha¹txain¹nũ²nhai¹. Nxe³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: “Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ a³lan²ta² hãi¹nxe³ti³xa² u̱³txi³ wa³kon³yah²lxan³tai¹?” Nxũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nxe³ha²kxai³lu¹: “A²nũ²a² ĩ³kaix1sain¹sĩ¹nxa³kxi³su¹.” Nxũ²nhai¹. Nxe³sxã³ ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: “Txa²hai³sxa² ai³sxã³ wa³kon³kxi²sah¹lxi³to³hẽ¹li¹.” Nxũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nxa²ha¹te¹ ka³nxa³hi²tãu³a² hai³sxa² wa³kxẽn³yah³lai²na² sa²kxai³lu² a²sa³wi³sa² hxi²kan¹jah¹la² ĩ³ye³kxi²te³nah¹lxi¹: “A²nũ²a²nãu³xa² wa³kon³kxi²nẽ³lain¹te²nãu³xa² ĩ³kaix1txa²hẽ³li¹. Ĩ³kaix1tai¹nĩ¹kxai²nãn²tu̱³ wa³kon³kxi²nẽ³lain¹kxa² yo³ha² ũ³hũ²xai³txai¹nhẽ³li¹. Ã³ne³ki³sot3sxã³ wxã³ain¹te²na² ũ³yho³hi² ãn³si³wxe³sã²nĩn¹ka³tu̱³ hã²wxãn³txa³ a²wi¹lhĩ¹nãn¹ta² wxã³te²nãu³xa² ã³ne³ki³so³tĩ¹nha²kxai³ nxe³sẽ¹li¹.” Nxũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nxa²ha¹te¹ in³txi³nãu³xin³txi² ka³nxa³hi²nxa³ta̱³lxa¹ ã³si³wxe³sxã³ wa³kon³kxain¹tũ̱³ka̱³txa² ũ³yho³hi²ki³a² ki³ka³na³ka³na³ki³a² ũ³hũ²xai³ain¹nũ²nhai¹. Nxe²hu³xai³sxã³ wa³kon³kxain¹tũ̱³ka̱³txai²na² a²yxo²ha³kxa¹ ũ³yho³hi²ki³a² ki³ka³na³ka³na³ki³a² ũ³hũ²xai³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Te²yã¹nxe² ai³sxã³ a²wi¹lhĩ¹na² ã³si³wxe³sxã³ wa³kon³kxain¹tũ̱³ka̱³txai²na² a²ẽ¹nãn¹jau³kxai³lu¹: “Ki³ka³lxa¹txi³ ũ³yho³hi²sa²te³lxa²na³na¹.” Yhain¹jau³su² yxãn¹ta¹ ki³ka³na³ka³na³ki³ãin²txi³ so¹kxain¹nũn³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nxe³te³kxa²ya̱n³tu̱³ti¹ hai³sxa² wa³kxẽn³yah³la² ĩ³kwa̱i²kxi²te³lhxã³ ã³tĩ̱³ain¹nũ²nhai¹. Nxain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Tũ̱¹ka̱³txai²na² a²ne³ki³sot3sxã³ wxã³tũ̱³ka̱³txa² jũ¹nxa² so¹lxi³ wa³ko³nain¹te¹ni²tu³wi¹. Yxãn¹ta¹ txa²nũ̱³ka̱³txa² a²lan²ta² hãi¹nxe² wa³kon³kxi²nxa²sĩ¹na¹te¹ni²tu³wi¹. Sa³txe̱¹txi³ wa³kon³kxi²sĩ¹nha²kxai³ wãn³ya³lu²sa²sĩ¹nha²kxai³ nxe³sĩ¹na¹te¹ni²tu³wi¹. Yxãn¹ta¹ tũ̱¹ka̱³txai²na² ki³ka³na³ka³na³kain²txi³ ũ³yho³hai¹nĩ¹nha²kxai³ txa²nũ̱³ka̱³txi³nãu¹xai²na² ki³ka³na³ka³na³kain²txi³ ũ³yho³hi²sa²sĩ¹nĩ¹nha²kxai³ nxĩ¹nhẽ²li¹.” Nxũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nxa²ha¹te¹ a²wa³kxẽn³yah³lai²na² wãn³txi³kxai³lu² a²nũ²a² ka³na³ka³na³jah¹la² ĩ³ye³kxi²te³nah¹lxi¹: “Nxe³txi¹. Txa²ya̱³lxi¹lxi¹. Ko̱³nxe³ti³ kãi²ũ¹nxa²hxã³nhẽ²li¹. Ũ³yho³hi²ki³a² ki³ka³na³ka³na³ki³a² ĩ³hau³ko³ki̱³ten¹tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nxe³ki̱³sa²kxai³ so¹kxi²san¹ta³ki³ai²na² tẽ³sxã³ ĩx3txu¹li¹. Na¹ta¹ ã³ne³ki³sot3sxã³ wxã³jah¹la² ki¹ain²txi³ ũ³hũ¹ti³ten³sa³nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Txa²yen³kxai²na² a²ten³nha¹jau³su² o²la³kxi²na¹tu¹wi¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ txa²yen³kxa² a³lxi²nxa³kxe³su² a²nũ²a² ã̱³xa² hxi²nũ¹nai¹na¹ju³tan¹te²kxa³ya̱n³tu̱³ ha²ya̱³kxa² yxo²kwa̱in³txa²hẽ³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jã¹nxa¹jau³su² ã³ne³ki³so³te²na² sa²kxai³lu² ne³ka³ta²xai³ha²kxai³ ne³ka³ta² ã³si³wxe³te²na² sa²kxai³lu² ã³ne³ki³sot3si¹ha²kxai³ nxain¹tu¹wi¹. Jã¹nxe³jut3su² a²nũ²a² ĩ³kaix1tai¹na¹te²nãu³xa² ka³lxa¹khai¹nxe³ha²kxai³ ĩ²sxã³ so¹kxi²na¹te²nãu³xa² ka³lxa²ai¹nxa³ha²kxai³ nxe³te²ju²hẽ³li¹. Jã¹nxa¹jau³su² nxe³ye¹nx2ta¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hã²wxãn³txa³ Je³ru³sa³lẽ²thĩ³na² ka³la³xi²te³lhxã³ ain¹tãu³a² Je³su²jah³lai²na² sa²kxai³lu² a²sa³wi³ha³lxa² a²to²se³te²nãu³xa² nũh¹lxi³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","— Nxe³jah³lxi³sa²lxi¹. Je³ru³sa³lẽ²thĩ³na² ã³nxai³ki̱³tu¹wi¹. Nxe³ki̱³kxai²nãn²tu̱³ Txai²na² so¹sain¹sxã³ a²nũ²a² wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txi³nãu³xa² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txi³nãu³xa² nxe³te²nãu²xai²na² a²hxi²ka² sa²so¹sain¹tu¹wi¹. Nxe³sain¹kxai²nãn²tu̱³ ya³lu¹sain¹jau³su² ĩ³yĩ¹li²sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nxe³ka³tu̱³ Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³xa² sa²nũ¹sain¹tu¹wi¹. Sa²nũ¹sain¹sxã³ ko̱³nxe³ ĩ³ka³lxi¹lũ¹sai¹nha²kxai³ ĩ³ta³lo³wait1sai¹nha²kxai³ nxe³te²kxa³kxa¹ hi³sa³ka³txa² ũ³hxi²kĩ¹la³kxi²sain¹tu¹wi¹. Nxe³sxã³ ya³lut1sai¹nha²kxai³ sa²nĩ̱³kxi²sain¹tu¹wi¹. Hã²wxãn³txa³ ye³ha¹li¹ ka³na³ki¹ a³lan²tãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹, Txa²wã¹sũ̱³na² Hxi²kan¹txa² Si³yxau³tãu³lot3sa²jah¹lo²na¹ha²kxai³lu¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nxa²ha¹te¹ nxe³nũ²la² Se³be³te²ah³la² a²sxe³xa³ka³lxai²na² sa²kxai³lu² a²ki³lha³lxa²nãu³xa² Jo³ãu²ah³lo²su² ha²kxai³ Ti³a²kah³lo²su² ha²kxai³ nxe³te²an²tu̱³ sa²so¹sxã³ Je³su²jah³la² ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². Ã³tĩ̱³sxã³ Je³su²jah³la² yen³nãu³a² ã³ka³ti³wxe³sxã³ ĩ³ye³kxi²te³lhxã³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txa² nxe³te³nah¹lxi¹: — Ĩh¹nxe³tin¹ji¹xi¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — Wxãi²na² wxa²ha³lo²a² a²wa³kxẽn³sin¹kxai²nãn²tu̱³ txa²ki³lha³nãu³xai²na² wxa²wi¹tãu³a² sa²we¹txi² wxa²wa̱³tãu³a² sa²we¹txi² nxe³si¹hain¹jau³su² ĩ³hau³ko³tũh¹txai¹nhẽ³li¹. Ta¹ka³lxai²na² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nxa²ha¹te¹ Je³su²jah³la² a²ki³lha³nãu³xa² ĩ³ye³kxi²te³nah¹lxi¹: — A²yen³kxa² ten³ya³hin¹ju³ta² ã³ne³wxe³ya³hxa³lxi¹. A²nũ²a² ko̱³nxe³thin¹te²nãu³xa² khãuh³lxa³ti³sain¹tu¹wi¹. Te²yã¹nxe²nx2ti³ju³tai²nãn²tu̱³ hxi²kan¹nx2ti³ji¹wi¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ĩ³wa²lũ³xi²ya³te³nah¹lxi¹: — Hxi²kan¹sĩ¹na¹wi¹. Ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nxa²ha¹te¹ ĩ³ye³kxi²ya³te³nah¹lxi¹: — Khãuh³lxa³txi³sain¹kxa²yã¹nxe² khãuh³lxa³txi¹nx2tain¹nũn³tu¹wi¹. Yxãn¹ta¹ txa²wi¹tãu³a¹ sa²we¹txi²jut3sa²ha²kxai³ txa²wã̱³tãu³a¹ sa²we¹txi²jut3sa²ha²kxai³ nxe³kxi³nũ³su² hxi²kan¹sa²nxa³nhai¹. Txa²wĩ³na² ha³lo²ai²la¹wi¹. Nxe³sxã³ Txa²wĩ³na² ã³ten³te²su² te²na² so¹lxi³ sa²we¹tain¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nxa²ha¹te¹ a²sa³wi³ha³lxa² wã³kon³te²nãu³xa² hxi²ka²hxan³sxã³ wã³kon³te²nãu³xai²na² sa²kxai³lu² a²lon³ti³tãu³su² te²a² ĩ³a̱n³ta³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nxa²ha¹te¹ Je³su²jah³la² hi²sen³su² a²sa³wi³ha³lxa² ã³yã³nũ²kxi²si¹hain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² ã̱³xa² wi¹lhin¹ wa³to²hi²nha¹yah³lxi³txa³hẽ¹li¹. Ju³te²a² nũ̱³ka̱³txi³sxa³te²na² a²wa³kxẽn³txi³nãu³xai²na² sa²kxai³lu² a²sa³wi³ha³lxi³nãu³xa² ĩ³kãin²txi³nha²sxã³ nũ³kxũn³txi³ ĩ³wa³kxẽn³txain¹to³te²jai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nxe³yãn¹ta¹ te²yã¹nxe² kãi³ũ¹nyha¹lxi³txa³hẽ¹li¹. Wxa²yu³tai²na² ĩ²li³te² ĩ³nxai²nãn²tu̱³: “Hxi²kan¹te²sa¹i¹.” Nxe³jau³tu̱³ ten³yah³lxin¹kxai²nãn²tu̱³ wxa²yu³ta² a²hãi¹nxe³ti³xa² ã³non²ta³kxi²txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te²yã¹nxũn³sxã³: “Txai²na² a²si³yxau³jah¹lo²sa¹wi¹.” Nxe³jau³tu̱³ ten³yah³lxin¹kxai²nãn²tu̱³ a²nũ²a² yxo²ha³kxa¹ a²wa³ka³li³lo³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jã¹nxa¹jau³su² Txai²na² sa²kxai³lu² wa³ka³li³lo³sa²si¹hain¹jau³nũ³su² wxã²nxa³wi¹. Yxãn¹ta¹ a²nũ²a² yxo²ha³kxa¹ ã³non²ta³kxi²te³lhxã³ wxã³na¹wi¹. A²nũ²a²nãu³xai²na² a²ko̱³nxe³ti³ kãi³sxã³ te²hxi²ki³lxain¹kxe³su² ã³wa²su¹te³lhxã³ ya³lu²na¹tu¹wi¹. Nxe³te³lhxã³ wxã³na¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nxa²ha¹te¹ ãh¹ã³nxai³ain¹tãu³a² Je³ri³ko²thĩ³na² a³li³ain¹ta¹hxai²hẽ¹la². A³li³ain¹tãu³a² a²nũ²a²nãu³xa² ka³lxa¹te²nãu³xa² ĩ³hi²txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nxe³tãu³a² in³txa² ye³han³te²a² ha¹li¹ tĩh³na² ne³kxu̱n²nãu³a² ã³wxe³ya³ta¹hxai²hẽ¹la². Nxe³te³na¹ Je³su²jah³la² ã³wa²to²hi²jau³xa² ain³kxain¹te³na¹ ĩ³kaix1tain¹te³nah¹lxi¹: — Txa²wã¹hxi²kan¹jah¹lãi³. Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3txa²jah¹lo²si¹lxi¹. Wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sa²sĩ¹nhẽ³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nxe³te²kxa³ya̱n³tu̱³ti¹ a²nũ²a² ã³si³tẽ³la³kxain¹tũ̱³ka̱³txai²na² ã³ka³nahx2si¹jau³su² ĩ³kwa̱i²kxain¹ta¹hxai²hẽ¹la². Nxe³yãn¹ta¹ in³txi³nãu³xa² ĩ³ka³na²ya³to³hxa³te³nah¹lxi¹: — Txa²wã¹hxi²kan¹jah¹lãi³. Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3txa²jah¹lo²si¹lxi¹. Wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sa²sĩ¹nhẽ³li¹. Ain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nxa²ha¹te¹ Je³su²jah³la² ĩ³kaix1tain¹jau³xa² ain³kxi¹nxa²ha¹te¹ ã³yit1tũ²la² ĩ³kaix1so¹ain¹te³nah¹lxi¹: — Ĩh¹nxe³ju³ta̱³ kãi³ũh¹nx2ta¹ju³ta³la³ ten³nxa²lxin¹ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nxa²ha¹te¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Txa²wã¹hxi²kan¹jah¹lãi³. Ye³we²txi²sa³nhĩn¹ju³ta² ten³khaix1sa²sĩ¹nhai¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ãin²ta³kxi²sxã³ wxa²ye³waix3ta¹hxai²hẽ¹la². Nxe³tãu³ wa³su³txi³ ye³we²txi²ta³lain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ ã³si³tẽ³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nxa²ha¹te¹ ãh¹ã³nxai³lxi³tãu³a² Je³ru³sa³lẽ²thĩ³na² ya̱u³so³nain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ Bet3fa³je²thĩ³na² ã³yit1txain¹ta¹hxai²hẽ¹la². A²nxe³thĩ³nai²na² wã³la² o³li³ve²ra³ka³txa² u²lxa³ko³su² ta¹hxai²hẽ¹la². A²nxe³thĩ³na² ã³yi¹ka³tu̱³ Je³su²jah³lo²kxai³lu² a²sa³wi³ha³lxa² in³txa² ha¹li¹ ĩ³sa²si¹hã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ĩ³sa²si¹hã³te³nah¹lxi¹: — Sxi²je³na² kãi²nxa³je³na² ã³wih¹ja¹hu¹li¹. Yxah³hin¹kxai²nãn²tu̱³ a²kwẽn¹tai²na¹ ju³mẽn²ta² ka²va¹lhũ̱³te²a² a²hã³ka³na² sa²tai²kxã¹sxã³ ĩ²ya³hi¹nha²kxai³ a²wẽ³sa² ĩ²ya³hi¹nha²kxai³ yxa³hin¹tu¹wi¹. A²nxe³te²na² sa²ta²la³kxi²sxã³ tẽ³sxã³ wa̱³li¹ja³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nxe³ya³hin¹tãu³a² a²nũ²a² ĩ²nx2ti³sxã³ ĩ³wã̱³txi¹nx2ti³kxai²nãn²tu̱³ ĩ³ye³kxi²ja¹hẽ¹li¹. Nxe³ya³hin¹te³nah¹lxi¹: “Txa²wã¹hxi²kan¹jah¹la² ten³na³li¹.” Yxa³hin¹jau³su² ha²kxai³ ju³mẽn²ta² ha¹lin¹te²a² ũ³sa²si¹hã³nx2ti³tu¹wi¹. Je³su²jah³lai²na² wãn³txa² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jã¹nxe³jut3su² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lu¹tai²na² jau³xau³hxai²tẽx1ta² nxe²e³ta¹hxai²hẽ¹la². Nxe²e³te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","— Si³ãu²thĩ³na² yxau³tũ̱³ka̱³txa² ĩ³hen³txi³txain¹yah³lxi³hẽ¹li¹. Wxa²hxi²kan¹jah¹la² wxã³tu¹wi¹. Yxo²thãi³ti³la² wxã³ha²kxai³ ju³mẽn²ta² ã³ka³tih³ya̱u³kxi²ha²kxai³ wxã³tu¹wi¹. Yen³kxa² ã³ka³tih³wxe³nha²te² ka³yxuh³xa² tẽ³sxã³ ã³ka³tih³ya̱u³sxã³ wxã³tu¹wi¹. Sũ̱³na² wãn³txu¹txai²na² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jã¹nxe³jut3su² a²sa³wi³ha³lxa² ha¹lin¹te²na² ã³nxai³yah³nũ²la² Je³su²jah³la² e³kxi²jau³xa² yã¹nxe³sxã³ ha³lo²a² ĩ³ha¹txi²ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nxe³ha²kxai³ ju³mẽn²ta² a²hã³ka³na² a²wẽn³sa² nxe³sxã³ sa²so¹ain¹ta¹hxai²hẽ¹la². Nxe³tãu³a² a²wã²la³ka³lo³a² ã³ka³ti³hẽ¹tha²kxai³ Je³su²jah³lo²su² te²kxai³ a³ka³tih³wxe³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nxa²ha¹te¹ ne³ka³ta² ai³tũ̱³ka̱³txa² ka³lxa¹tũ̱³ka̱³txa² a²wã²la³ka³lo³khai³xa² tĩh³na² Je³su²jah³la² ã³nxai³tĩh³na² ũ³ha¹sxã³ ai³ai¹nha²kxai³, a²nũ²a² ã̱³xa² ka³lxa¹tũ̱³ka̱³txa² he³la³nxã³nxa² sa²nãu²so¹sxã³ tĩh³na² ũ³ha¹sxã³ ai³ai¹nha²kxai³, nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nxa²ha¹te¹ a²ka³lxa¹tũ̱³ka̱³txa² a²ne³ka³ta²a² ai³ai¹nha²kxai³ a²ka³lxa¹tũ̱³ka̱³txa² a²si³yo³na² ai³ai¹nha²kxai³ nxe³ain¹sxã³ ĩ³kaix1tain¹te³nah¹lxi¹: — Ĩ³sa²nẽn¹kxi¹nxa²sĩ¹na¹tu¹wi¹. Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lo³txa²jah¹lo²si¹lxi¹. Ta³vi²yah³lu¹tai²na² txa²wã¹hxi²kan¹jah¹lu¹tai²na² a²ne³tah²su² te²si¹lxi¹. A²nxe³jah¹lu¹ta² yã¹nxe² sa²hau³ko³tẽ³tu¹wi¹. Wxi²kin³ti³ton³khaix1jah¹lai²la¹wi¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nxa²ha¹te¹ nxe²xai³ain¹sxã³ Je³ru³sa³lẽ²thĩ³na² ã³wih¹hain¹tãu³a² thĩn¹nãn¹ta²nũ̱³ka̱³txa² on²ta³kxi²nyhain¹sxã³ e³kxain¹te³nah¹lxi¹: — Ĩh¹jah¹lo²ta̱n³ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nxa²ha¹te¹ ã³si³tẽ³kxi²tũ̱³ka̱³txai²na² a²wãn³txi³kxai³lu¹: — Jah¹lai²li² Je³su²jah³lai²la¹wi¹. Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²sa¹wi¹. Na³sa³re²thĩ³na² Ka³li³le²a²ko³xan¹thĩ³na² yxau²xai³jah¹lo²su² na³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nxa²ha¹te¹ Txa²wã¹sũ̱³na² sxi²ha² ã³wi¹hain¹nxa²ha¹te¹ a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² yen³kxa² so¹kxi²nyhu¹sxã³ o²la³kxi² ũ³yho³hi²ki̱³ki³a² so¹kxi²nyhu¹sxã³ o²la³kxi² kwa³sxa³xa² ũ³yho³hi²sxã³ ũ³hũ¹te²a² o²la³kxi² nxe³ye²yah³lxi³ta¹hxai²hẽ¹la². Jã¹nxe³ju³kxai³lu² Je³su²jah³la² hi²sen³su² yen³kxa² ũ³yho³hi²nyhain¹te²na² ha³lo²a² sa²tã³kxai¹nha²kxai³ ũ³yho³hi²ki̱³ki³ai²na² a²me²sa²ka³lo³a² ũ³sa²tã³ha²kxai³ kwa³sxa³xa² ũ³yho³hi²sxã³ ũ³hũ¹te²na² ã³wxe³ka³lo³ai²na² ũ³sa²tã³ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wha²li¹txã³nxa² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: “Txa²sxi²hai²na² sa²kxai³lu² ĩ³ye³kxi²sah¹lxin¹thĩ³nai²la¹wi¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ ĩ³ã̱³lxi³to³nha²sxã³ yen³kxa² kãi³kxi²nyhu¹kxi³thĩn³su² ĩ³ã̱³lxi³ton³yah³lxi¹nhẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hã²wxãn³txa³ sxi²hẽ¹nãu³a² a²nũ²a² ye³han³te²su² te²a² a²ha³lxu²kxa² ai³te²su² te²a² ã³wih¹sxã³ ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ tũ̱¹ka̱³txai²na² a²yxo²ha³kxa¹ wi¹we²txi²ta³lun²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nxa²ha¹te¹ a²nũ²a² wã³nxĩn¹ta² si³yxau³kxa²te²nãu³xa² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²nãu³xa² nxe³sxã³ nũ³kxũn³sxã³ kãi³ũ¹hain¹ju³ta² ĩ²kxai¹nha²kxai³ wẽ³ha³lxai²na² ka³lxi¹sxã³ ĩ³ye³lain¹jau³su² nxe³te³nah¹lxi¹: — Ta³vi²yah³lu¹tai²na² Ta²ha² Wxi²kin³ti³ton³khaix1jah¹lo²si¹lxi¹. Nxe³jah¹lai²li² ĩ³sa²nẽn¹kxi²a³sah¹lxi³wxi¹. Nxe³ain¹jau³su² ain³kxai¹nha²kxai³ kãin² yxai¹hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yxaih¹ha²kxai³ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Wẽ³ha³lxai²na² wãn³txa² toh³lxi³jau³su² ain³kxain¹nxãn³ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Jau³jau¹xai²na² ain³kxai¹na¹nhai¹. Nxe³na¹ha²kxai³ wãn³txa² ũ³wha²li¹txã³nxu¹tai²na² nxe³te³nah¹lxi¹: “A²nũ²a² wxi²ka¹nai¹nxa³te²na² a²yxo²wãn³txa² wẽ³sa² a²su³su³yau³xa² i³te²na² a²yxo²wãn³txa² nxe³sxã³ ĩ³sa²nẽn¹kxi²nxain¹na³li¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³jau³jau¹xai²na² ĩ²yah³lxin¹ta²lu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nxe²e³ta³lun²nũ²la² Je³ru³sa³lẽ²thĩ³na² a³li³ain¹ka³tu̱³ Be³tãn²ya³thĩ³na² ã³wih¹sxã³ sxa³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nxa²ha¹te¹ a²ka³nxa³ha²ta³a² Be³tãn²ya³thĩ³na² a³li³ain¹nũ²la² Je³ru³sa³lẽ²thĩ³na² wa̱³li²tãu³a² Je³su²jah³lo²kxai³ heh³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nxe³ka³tu̱³ ai³tãu³ãn²tu̱³ hi³sa³ka³txa² fi²ko³nxẽ³kxa² ka̱x3ka³na³ka³nat3sxã³ ĩ²ta¹hxai²hẽ¹la². Yxau³son³tãu³ a²nxã̱³kxa² yũ²nxa³ki³su¹ a²nxã³nxa² so¹lxi³ yũ³kxi³sã¹ ĩ³ye³kxi²te³nah¹lxi¹: — Fi²ko²nxã³ki³nũ³a² yũ¹ti³he¹nxa³lho³li¹. Nxe²e³te³na¹ a²kwẽn¹tai²na¹ a²nxe²kxai²na² ĩ³ya³nat3sã³ya³lu²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","A²nxe³ju³kxai³lu² a²sa³wi³ha³lxi³nãu³xa² ĩ³wã̱³wã̱³txi³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹nxet3sa²kxai³ fi²ko²nxẽ³kxa² a²kwẽn¹tai²na¹ ĩ³ya³nat3sxã³ ya²lun¹jã¹nxẽn³ta²? Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txa² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wãn³txi³su² e³kxi¹nx2ta¹wi¹. Yxo²ĩ²yah³lxin¹kxai²nãn²tu̱³ hai³txi³ ĩ³wã̱³wã̱³nha²txi³ ti³hex1yah³lxan³kxai²nãn²tu̱³ fi²ko²nxẽ³kxa² kãi³ũ¹ha¹kxa² yã¹nxe² he³la³ko³la³ kãi³yah³lxi³nũ³nĩn¹tu¹wi¹. Nxe³kxa²yu³su² wã³la³ka³txa² ĩ³ye³kxah¹lxin¹kxai²nãn²tu̱³ nxe³te³nah¹lxi¹: “Ã³ha²txu²kxa² sai¹nha¹sẽ¹li¹. Ĩ̱³ye³na² kãin²je³na² ã³sa³nũ¹xi¹sẽ¹li¹.” Yxah³lxin¹jau³su² nxe³kxai²nãn²tu̱³ sa²yxo²we¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jã¹nxe³ju³kxai³lu² ĩ²li³ju³ta² ĩ³wã̱³txi³sah¹lxin¹jau³su² yxo²ĩ²sah¹lxin¹kxai²nãn²tu̱³ ju³tain²txi³ sa²nũ¹nx2ti³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nxa²ha¹te¹ Txa²wã¹sũ̱³na² sxi²ha² ã³wih¹ta¹hxai²hẽ¹la². A²nũ²a²nãu³xa² wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³ain¹ta¹hxai²hẽ¹la². Ĩ³yau¹ũ³ain¹ti̱³kxai³lu² a²wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txa² a²nũ²a²nãu³xa² a²hxi²kan¹ta³nãu³xa² nxe³sxã³ ĩ³tĩ̱³yain¹sxã³ ĩ³wã̱³txain¹te³nah¹lxi¹: — Ĩh¹jah¹lo²ta̱³ ĩ³sa²si¹hã³nxain¹thai¹li¹? Ĩh¹nxe² ĩ³hxi²ka¹txa²hĩ̱³te²la¹xã³? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Yau³ka³na³ka³nat3sxã³ yau³ã̱³lxi³jau³xa² ĩ³wã̱³txi¹nx2ta¹tu¹wi¹. Wain³txi³ ĩ³wa²lũ³xi²sah¹lxin¹kxai²nãn²tu̱³ ĩ³hxi²kat1sa²jah¹la² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jo³ãu² Ba³tis²jah³lai²na² sa²kxai³lu² a²nũ²a² tẽ³sxã³ ĩ̱³ye³na² ũ³hũ¹kxi²sa²sai¹ain¹kxe³su² ĩh¹ti³xa² ĩ³sa²si¹hã³jah¹lo²ta̱³te²la³hĩ̱³te²la¹xã³? Txa²wã¹sũ̱³nu²khai³xai²la³ ta̱³nxa² a²nũ²khai³xai²la³ ta̱³nxa² nxe² ĩ³yau¹ũ³jah¹lxi³sã²nhẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². Nxa²ha¹te¹ wã²nxũ̱h¹e³kxi²nyhain¹te³nah¹lxi¹: — “Oh³nãu³a¹ ĩ³sa²si¹hã³kxai²la¹wi¹.” Nxe²e³kxi²ki̱³kxai²nãn²tu̱³ ĩ³wa²lũ³xi²nẽ³lai¹nhĩ̱³te³nah¹lxi¹: “Nxe³kxi³sa²kxai³ ĩh¹nxe³kxa²ya̱n³ti³ta̱³ Jo³ãu² Ba³tis²jah³lai²na² wãn³txa² yxo²ĩ²yah²lxan³thai¹li¹?” Nxe³nẽ³lain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yxãn¹ta¹: “A²nũ²khai³xa² ĩ³sa²si¹hã³kxai²la¹wi¹.” Nxe³ki̱³kxai²nãn²tu̱³ yu̱h³lxi³nẽ³na³li¹. A²nũ²a²nãu³xai²na²: “Jo³ãu² Ba³tis²jah³la³ Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²su¹.” Nxain¹jau³su² ha²kxai³ su²lhã³kxi²nẽ³lain¹kxa²ya̱n³txi³su² ki̱³nhai¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nxa²ha¹te¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ko̱³nxe³sĩ¹nxa³nhai¹. Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Nxe³kxai²nãn²tu̱³ ĩ³sa²si¹hã³sa²jah¹la² ĩ³yau¹ũ³nx2ti³xa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nxe³yãn¹ta¹ ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi¹nx2ta¹tu¹wi¹. In³txai²na² a²ki³lha³lxa² ha¹li¹ yũ³nũ²nhai¹. Nxe³ka³tu̱³ta¹ ye³kan¹jah¹la² ĩ³ye³kxi²te³nah¹lxi¹: “Wẽ³sãi³. Hĩ¹na²su² txa²hai³sxa² wa³kon³txa²hẽ³li¹.” Nxũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nxe³ha²kxai³ ĩ³wa²lũ³xi²te³nah¹lxi¹: “Ha³yo¹. Ai³sxã³ wa³ko³na¹tu¹wi¹.” Nxe³jau³su² nxe³ta¹ wa³ko³nxa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ã³ta³lo³hẽ¹tãu³a² wẽ³sai²na² kãi²nxa³jah³la² ĩ³ye³kxi²te³nah¹lxi¹: “Hai³sxa² ai³sxã³ wa³kon³txa²hẽ³li¹.” Jau³su² nxe³ta¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: “Ten³sa²nxa³nhai¹. Wa³kon³nxa³lho³li¹.” Nxũ²nhai¹. Nxe³yãn¹ta¹ ye³jen¹na² ĩ³ãin²ta³kxi²nha²sxã³ ĩ³ya̱¹tha²kxai³ ai³sxã³ wa³kon³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jã¹nxe³ju³ta² ĩh¹jah¹lo²ta̱³ wĩ³na² wãn³txa² a²ten³jau³su² sa²yxo²we¹jah¹lo²su² hĩ̱³te²la¹xã³? Je³su²jah³la² ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Kãi²nxa³jah¹lo²su¹. Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah¹lai²na² a²wãn³txi³kxai³lu¹: — Wãn³txi³su² e³kxi¹nx2ta¹wi¹. A²nũ²a² ũ³yho³hi²ki³a² so¹kxi²nẽ³tũ̱³ka̱³txai²na² txu¹ha² ko̱³nxe³thin¹sxã³ o²la³kxi²ta¹ka³lxai²na² nxe³sxã³ ko̱³nxe³ti³ kãi³sxã³ yxau²xai³lain¹ju³ta² ã³na¹ha²kxai³ ã³nhxi²wxe³nu¹sain¹ju³tan¹te²kxa³ya̱³lhu² Txa²wã¹sũ̱³na² ha³lo²a² ã³wi¹hain¹ju³ta³nũ³a² yũ³tu¹wi¹. Nxe³to³ta¹ wxãi²nãu³ ĩ³nxai²na² a²nũ²a²nãu³xai²na² a²hxi²kan¹te²nãu³ ĩ³nxai²na² yxo²ĩ²sah²lxan³ju³tan¹te²kxa³ya̱³lhu² ã³wi¹yhah³lxin¹ju³ta³nũ³a² yũ²nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kxã³nxai³tã² Jo³ãu² Ba³tis²jah³lai¹tã² wxã³sxã³ wãn³txa² wain³tĩh³na² ĩ³tih³nxe³nx2ti³tai¹ti²tu³wi¹. Yxãn¹ta¹ yxo²ĩ²yah²lxan³nhẽ³li¹. Yxãn¹ta¹ ko̱³nxe³ti³ kãi³sxã³ yxau²xai³ye²tũ̱³ka̱³txai²na² sa²kxai³lu² a²wãn³txa² yxo²ĩ²ain¹na²hẽ³li¹. Hã²wxãn³txa³ ju¹tai²na² ĩ²yah³lxin¹kxan²ti³ ko̱³nxe³ti³ kãi³sxã³ yxau²xai³yah³lxin¹ju³ta² ĩ³ãin²ta³kxi²nyhah¹lxa³nha²kxai³ yxo²ĩ²yah²lxan³nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nxa²ha¹te¹ wãn³txa² yau³ã̱³xa² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Hai³sxa² a²wa³kxẽn³yah³lo²su² nũ²nhai¹. A²hai³sxai²na² u²va²tẽ³kxa² ĩ³whĩ̱¹i² a²yxo²ka³te̱h³nãu³xa² txah³lxa³kxa² tẽ³sxã³ yxo²wxaih²na³kxa² ai³sxã³ txon³nũ²nhai¹. Nxe³nũ²la² yain³txa² ũh³wxĩ̱¹so¹ka³txa² hau³kot3sxã³ we¹tũ²nhai¹. Sxi²ha² kĩ³khai¹nxe³thĩ³na² ũ³txo³te²ka³kxa¹ a²nũ²a² ã̱³xa² wi¹wa³kon³kxi²si¹hain¹jau³su² ũ³hũ¹hain¹nũ²nhai¹. Hã²wxãn³txa³ ha³lo²a² u²lxan¹ko³xa² ã³nxai³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nxe³nũ²la² hã²wxãn³txa³ hai³sxai²na² wi¹wen¹nũ²la² wi¹nã̱³kxi²ti³wa³kxa² a²wa³kxẽn³yah³lai²na² sa²kxai³lu² hai³sxa² a²yo³ha² so¹kxi²si¹jau³su² a²sa³wi³ha³lxa² ĩ³sa²si¹hã³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ĩ³sa²si¹hã³te³na¹ wa³kon³kxain¹tũ̱³ka̱³txa² ko̱³nxe³thin¹sxã³ kãi³ain¹nũ²nhai¹. Sa²si¹hã³tũ̱³ka̱³txa² nũ³kxũn³txi³ sa²so¹ka³tu̱³ ka³na³ku² ĩ³wai¹tha²kxai³ ka³na³ku² ĩ³su²lhã³ha²kxai³ ka³na³ku² txah³lxa³kxa² tẽ³sxã³ ã³na¹sã³ya²lu¹tha²kxai³ nxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ã³ta³lo³hẽ²tãu³a² a²sa³wi³ha³lxa² ã̱³xa² nũ̱³ka̱³txa² ka³lxa²ton³tũ̱³ka̱³txa² ĩ³sa²si¹hã³nũ²nhai¹. Nxain¹ta¹ a²wi¹lhĩ¹nãn¹tũ̱³ka̱³txan²tu̱³ te²yã¹nxe² khãuh³lxa³txain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hã²wxãn³txa³ a²wa³kxẽn³yah³lai²na² ẽ¹nãn¹jau³kxai³lu¹: “Txa²wẽ³sai²na² sa²nẽn¹kxain¹te³lxã²na³na¹.” Nxe³jau³su² wẽ³sai²li² ĩ³sa²si¹hã³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nxe³ta¹ hai³sxa² wa³kon³kxi²tũ̱³ka̱³txai²na² sa²kxai³lu² wẽ³sai²na² wxã³ju³ta² ĩ²ain¹nũ²la² ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: “Txa²wã¹wa³kxẽn³yah³la² ki³lha³lxa² wxãn³na²wi¹. Ĩ³su²lhã³a³sah¹lxi³wxi¹. Nxe³ki̱³kxai²nãn²tu̱³ hai³sxa² so¹kxi²ki̱³tu¹wi¹.” Nxe³nyhain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nxain¹ka³tu̱³ wẽ³sai²li² sa²so¹nũ²la² hai³sxa² sa²li¹ha³lo²sa²tã³ka³tu̱³ ĩ³su²lhã³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jã¹nxe³jut3su² hai³sxa² wa³kxẽn³yah³lai²na² sa²kxai³lu² ĩ³xi²tãu³a² ĩh¹nxe³kãi³ũ¹hĩ̱³te³ji¹wi¹? Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nxa²ha¹te¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Ko̱³nxe³thin¹khai¹xain¹te²sin²tai¹. Nxe³sxã³ ko̱³nxe³thi¹nain¹kxa² yo³ha² ĩ³su²lhã³ain¹tu¹wi¹. Hã²wxãn³txa³ a²nũ²a² ã̱³xa³nãu³xa² hai³sxa² wa³kon³kxi²si¹hain¹jau³su² ĩ³kaix1so¹ain¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ hai³sxa² yain³txa² wain³txi³ wxa²nhũ¹ain¹tu¹wi¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxu¹tai²na² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³te³nah¹lxi¹: “Txah³lxa³kxa³txa² a²nũ²a² sxi²ha² ton³te²nũ̱³ka̱³txai²na² o̱³nxa³jau³su² ĩ³ye³kxain¹sxã³ so¹sxã³ ã³sxã³ ã³na¹ain¹ka̱³txa² kwẽn¹tai²na² ã³si³ka³la¹tã³khai³xain¹ka³txa² hxi²kan¹khai¹nxe³ta³ka³txa²lxã²na³li¹. Nxe³ju³tai²na² Txa²wã¹sũ̱³na² kãi³ain¹na²hẽ³li¹. Nũ̱³kxũn³khai¹nxe³ju³txai²la¹wi¹.” Ũ³wha²li¹txã³nxu¹tai²na² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³jau³xai²li² ĩ²yah³lxin¹ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jã¹nxa¹jau³su² ĩ³ye³kxi¹nx2ta¹wi¹. Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²wet1sxã³ yxau²xai³kxe³su² en²yah³lxi¹nha²kxai³ a²nũ²a² ã̱³xa² nũ̱³ka̱³txa² ĩ³yau¹ũ³hain¹tu¹wi¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² Sũ̱³na² wãn³txain²txi³ sa²yxo²wet1sxã³ yxau²xai³lain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jã¹nxe³jut3su² txah³lxa³kxa³txai²li² kwa²sa²tã³yu̱³to³kxai²nãn²tu̱³ kãin² ã³nĩ¹ton³tah³lxi³hĩ̱³nx2na³li¹. Yxãn¹ta¹ txah³lxa³kxa³txai²li² ã³hi³sã³nhe¹ta²lxi³kxai²nãn²tu̱³ sa³txe̱¹ha²kxai³ ã³ya²lu¹txa²lxi³hĩ̱³nx2na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nxa²ha¹te¹ a²nũ²a² wã³nxĩn¹ta² si³yxau³te²su² ã³nhai¹tũn³te²nãu³xai²na² fa³ri³se²a² nũ̱³ka̱³txi³su² ã³nhai¹tũn³te²nãu³xai²na² nxe³sxã³ Je³su²jah³lai²na² wãn³txa² ĩ³yau¹ũ³jau³xai²na² ain³kxain¹ka³tu̱³ wi¹ko̱³nyhain¹ta¹hxai²hẽ¹la². Sũ̱³na² wãn³txa² e²nain¹ju³tan¹te²kxa³ya̱³lhu² ĩ³kwa̱i²kxi²si¹hain¹jau³su² wi¹ko̱³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A²nxe³jau³xan²tu̱³ ĩ³a̱n³ta³kxain¹sxã³: — Je³su²jah³la² hxi²ki³ki̱³tũ¹xã¹. Nyhain¹ta¹ a²nũ²a² ãn³si³tẽ³la³kxain¹tũ̱³ka̱³txai²na² yu̱h³lxa³kxi²nyhain¹jau³su² ã³sxã³ wah³nxain¹ta¹hxai²hẽ¹la². — Je³su²jah³lo²kxai³lu² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lai²la¹wi¹. Tũ̱¹ka̱³txai²na² wãn³txa² nxe³ha²kxai³ yu̱h³lxi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nxa²ha¹te¹ Je³su²jah³la² ãh¹ e³kxi²sxã³ ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³nu²kxai³lu² ha³lo²a² a²wa³kxẽn³yah³la² yã¹nxe³hĩ̱³nx2na³li¹. Ha³lo²a² yu̱h³xan¹ko³xa² a²wa³kxẽn³yah³lai²na² sa²kxai³lu² a²ki³lha³lxa² txu¹ha² so¹te³lhxã³ nxũ²nhai¹. Nxe³ha²kxai³ yain³txa² kãin² yain³kxi²ki̱³ju³ta³nũ³a² ĩ³hau³ko³tũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nxe³te³na¹ a²nũ²a² ĩ³kaix1so¹si¹jau³su² a²sa³wi³ha³lxa² ĩ³sa²si¹hã³ain¹ta¹hxai²hẽ¹la². Nxain¹ta¹ wxã³ju³ta² te³nai¹nxa³jau³su² nxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ãh¹lxi³sxã³ a²sa³wi³ha³lxa² ĩ³ye³kxain¹te³nah¹lxi¹: “Yain³te³lhxã³ ĩ³kaix1so¹ai¹na¹tũ̱³ka̱³txa² ĩ³ye³kxi¹txain¹yah³lxi³hẽ¹li¹. Nxain¹yah³lxin¹te³nah¹lxi¹: ‘Ka³yxuh³xa² sĩ̱³na² ãu¹la³kxi²hxa³ta¹i¹. Po¹nai²na² ha³nẽ³txi²na¹te²na² ĩ³su²lhxã³ yo³li³na¹li¹. Yain³txa² a²yxo²ha³kxa¹ te³kxi²ta³lu²na¹li¹. Nxe³na¹ha²kxai³ ã³wxã³jah¹lxi³hẽ¹li¹.’ ” ");
INSERT INTO nabNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nxe³ta¹ wet1txai¹nxa³nũ²nhai¹. Hãi¹nxe³sxã³ a²wa³ka³li³yu³khai³xa² o²la³kxi²yah³lxi³nũ²nhai¹. Ka³na³ku² hai³sxa² ai³lha²kxai³ ka³na³ku² yen³kxa² so¹kxi²nyhain¹te³lhxã³ ai³lha²kxai³ nxe³yah³lxi³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ka³na³kon¹te²na² sa²kxai³lu² a²sa³wi³ha³lxai²na² hxi²ki³ha²kxai³ khãuh³lxa³tai¹nha²kxai³ su²lhã³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nxa²ha¹te¹ ha³lo²a² wa³kxẽn³yah³lai²na² sa²kxai³lu² ĩ³a̱n³ta³kxi²khai¹nxe³sxã³ a²ya̱³lxi³nãu³xa² nũ³kxũn³txe²nãu³xa² ĩ³sa²si¹hã³ain¹nũ²nhai¹. Ĩ³sa²si¹hã³ai¹nha²kxai³ a²nũ²a² we¹tai¹nxa³te²nãu³xa² ĩ³su²lhã³ain¹sãn²nũ²la² sxi²ta³ta² hi¹la³kxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hã²wxãn³txa³ a²sa³wi³ha³lxa² ĩ³ye³kxi²xi²te³nah¹lxi¹: “Txa²wẽ³sai²na² txu¹ha² so¹te³lhxã³ nx2na³li¹. Nxa¹ta¹ a²nũ²a² ĩ³kaix1so¹ai¹na¹tũ̱³ka̱³txa² ĩ³li³thin¹ti³he¹xai¹nxa³wi¹. Nxe³ha²kxai³ en²txai¹na¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nxai¹na¹ha²kxai³ tĩh³na² kãin²tĩh³na² ai³yah³lxin¹sxã³ a²nũ²a² ĩ²li³te²na² ĩ³ha¹jah³lxin¹kxai²nãn²tu̱³ wxã³si¹hain¹jau³su² ĩ³ye³kxi¹txain¹yah³lxi³hẽ¹li¹.” A²wa³kxẽn³yah³la² nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nxe³te²kxa³ya̱n³tu̱³ a²sa³wi³ha³lxan²tu̱³ a³li³sxã³ ã³nxai³ain¹nũ²la² a²nũ²a² wi¹lhin¹te²na² ĩ³ha¹txi² ko̱³nxe³thin¹te²na² ĩ³ha¹txi² nxai¹nha²kxai³ a²yxo²ha³kxa¹ ã³sa²so¹ain¹nũ²nhai¹. Nxe³te²kxa³kxa¹ sxi²ha² ĩ³ne³kxi¹hain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nxa²ha¹te¹ a²wa³kxẽn³yah³lai²na² hi²sen³kxai³lu² wxã³ain¹tũ̱³ka̱³txa² ten³sa²tã³nũ²la² in³txai²na² wã²la² wi¹ka³lo³a² so¹nyhain¹kxa² wã²la² en²kxe³su² ĩ²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nxe³ha²kxai³ ĩ³ye³kxi²te³nah¹lxi¹: “Nxex3sa²lxi¹. Ĩh¹nxet3sxã³ wã²la² so¹nyhain¹kxa²ka³lo³a² ũ³whih²kxi²nha²nxa³sxã³ ã³wi¹hin¹thi²li¹?” Nxũ²nhai¹. Nxe³ha²kxai³ in³txai²na² hxi²kan¹txi³ e³kxi²nxa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nxa²ha¹te¹ a²wa³kxẽn³yah³lai²na² wãn³txi³kxai³lu¹, a²sa³wi³ha³lxai²na² ain³kxi²ti³an¹jau³kxai³lu¹: “Jah¹lai²na² so¹sxã³ sa²hxi²tai³kxi² sa²yu̱³tai³kxi² nxe³txain¹yah³lxi³hẽ¹li¹. Yxah³lxin¹kxai²nãn²tu̱³ ha³lo²a² ka³nxah³khai¹nxe³ju³ta² ha³lo²sa²tã³jah¹lxi³hẽ¹li¹. Nxe³tãu³a² ye³khãuh³lxa³thin¹ju³tan¹te²kxa³ya̱³lhu² kãin² nã̱³ni² kãin² wxi²ka³ta³ta³ti² nxe³ain¹tu¹wi¹.” A²wa³kxẽn³yah³la² nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jã¹nxe³kxe³hũ̱³nxe² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² a²nũ²a² ka³lxa¹khai¹nxe² ĩ³kaix1tain¹na³li¹. Nxe³kxan²ti³ ka³lxa²nxa³tũ̱³ka̱³txa² so¹lxi³ ĩ²so¹ain¹na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² ã³waix3tain¹nũ²la² he³son³kxi²nyhain¹ta¹hxai²hẽ¹la²: — Ko̱³nxe³te³si¹jau³su² Je³su²jah³la² wah³nxe² yxau²xai³ki̱³tu¹wi¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nxe³ha²kxai³ fa³ri³se²a² nũ̱³ka̱³txa² a²sa³wi³ha³lxa² ĩ³sa²si¹hã³i² E³ro³ti³ã²na² nũ̱³ka̱³txa² ĩ³sa²si¹hã³i² nxe³nyhain¹sxã³ ã³tĩ̱³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³la² ĩ³tih³nxe³sa²jah¹lãi³. Wãn³txa² ya²la³lyau³xa² e³jah¹lo²si¹lxi¹. Txa²wã¹sũ̱³na² wãn³txa² wain³txi³ ĩ³yau¹ũ³hai¹nhxai¹nhẽ³li¹. A²nũ²a² ĩ²li³te²a² ye³a̱n³txa³nih¹kxan²ti³ hxi²kan¹khai¹nxe³kxan²ti³ wxãi²na² yu̱h³lxi³jah¹lo²sxã³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nxĩ¹nha²kxai³ wãn³txa² wain³jau³xan²tu̱³ ĩ³yau¹ũ¹sah¹lxi³sĩ¹nhẽ³li¹. Ro³ma²no² nũ̱³ka̱³txa² a²hxi²kan¹jah¹la² Se²sa³jah¹lo²su² a²nũ²a² ũ³yho³hi²ki̱³ki³ai²na² ũ³hũ¹ain¹ki̱³ta̱³nxa² hãi¹nxã¹ta̱³nxa² ĩh¹nxe² wain³txi³ kãi³sĩn¹te³la¹ji¹wi¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nxa²ha¹te¹ Je³su²jah³la² hi²sen³kxai³lu² wãn³txai²na² ta²ko¹ta²kon¹jau³xai²na² wi¹ko̱³nh²sxã³ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ wãn³txa² ko̱³nxe³jau³xa² sa²yxo²sai¹sa²te³lhxã³ ten³nx2ti³ji¹wi¹? Wi¹lhin¹ki³lxo³tũ̱³ka̱³txi³syah¹lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ũ³yho³hi²ki³ai²na² tẽ³sxã³ ũ³hũ¹sah¹lxi³hẽ¹li¹. Ĩ²ti³ten³sa³nhai¹. Ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ ũ³yho³hi²ki³ai²na² ũ³hũ¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jã¹nxe³te³nah¹lxi¹: — A²nũ²a² ye³na² ũ³wha²li¹lho¹ain¹kxe³su² te²a² ĩh¹nxe³te²a² a²ye³nhũ̱³ji¹wi¹? Ĩh¹te²a² a²ĩ³lxi³su² ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nxa²ha¹te¹: — Se²sa³jah¹la² a²yen³su² ha²kxai³ a²ĩ³lxi³su² ha²kxai³ te²la¹wi¹. Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Se²sa³jah¹la² a²yen³kxi³khai³xa² ũ³hũ¹yah³lxi¹nha²kxai³ Txa²wã¹sũ̱³na² a²yen³kxi³khai³xa² ũ³hũ¹yah³lxi¹nha²kxai³ nxe²xai³jah¹lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jã¹nxe³jut3su² jau¹xai²na² ain³kxain¹nxa²ha¹te¹ ĩ³o²nha²sxã³ ã³waix3txain¹sxã³ ĩ³xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jã¹nxe³hĩ¹nai³kxai³lu² sa³tu³se²a² nũ̱³ka̱³txa² ã³nhai¹tũn³te²nãu³xai²na² ã³wxã³ain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱¹ka̱³txai²na² sa²kxai³lu² a²nũ²a² ya³lu²kxai²nãn²tu̱³ ka³te̱n³su² ĩ³sa²yxau³xi²ju³ta³nũ³a² yxo²ĩ²ain¹ta¹hxai²nxa³hẽ¹la². A²nxe²te²nãu³xa² ã³nhai¹tũ̱³ka̱³txa² ã³tĩ̱³sxã³ ĩ³wã̱³txain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","— Je³su²jah³la² ĩ³tih³nxe³nẽ³jah¹lãi³. Ĩ³yau¹ũ³sa²sĩ¹nhẽ³li¹. Moi³se²ah³lu¹tai²na² wãn³txa² jau³xau³hxai²tẽx1ta² Sũ̱³na² wãn³txa² ĩ³yau¹ũ¹nhẽ³te³nah¹lxi¹: “In³txi³su² ya³lu²kxi²kxai²nãn²tu̱³ a²wẽ³ha³lxi³khai³xa² yũ²nxa³kxe³su² ha²kxai³ a²lon³yah³lai²na² sa²kxai³lu² a²txu¹ha² so¹nyha¹ta¹ka³lxai³tã² so¹nyha¹txai²li¹, a²lo³na² ya³lu²ã³jah¹la² ta²ha² wet1si¹jau³su¹.” Moi³se²ah³lu¹tai²na² ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nxa²ha¹te¹ Txa²wã¹ha³tih³nãu³ai²na² a²lon³ti³tãu³xa² ha¹li¹ ha¹li¹ ha¹li¹ ka³na³ki¹ yxau²xai³lain¹na²hẽ³li¹. Nxe³te³na¹ ye³kan¹jah¹la² txu¹ha² so¹nha²hẽ¹li¹. Hã²wxãn³txa³ ya³lu²na²hẽ³li¹. Ya³lu²ha²kxai³ a²lon³yah³lai²na² sa²kxai³lu² a²txu¹hai²na² so¹nh²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ye³jen¹nãu³a² ya³lu²nũ³nha²kxai³ a²lo³na² ã̱³xa² txu¹ha² so¹nha²kxai³ ya³lu²kxi² a²lo³na² ã̱³xa² txu¹ha² so¹nha²kxai³ ya³lu²kxi² te²ka³kxa¹ a²lon³ti³tãu³xa² a²yxo²ha³kxa¹ ya²lun¹txi²hxan³kxain¹na²hẽ³li¹. Yxãn¹ta¹ hxi²kan¹txi³ wẽ³sa² we¹txi²nyhai¹nxa³hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hã²wxãn³txa³ txu¹hai²li² ya³lu²nũn³na²hẽ³la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jã¹nxe³ha²kxai³ yan¹nãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²ki̱³tãu³a¹ ta¹ka³lxai²na² sa²kxai³lu² ĩh¹te²la³ta̱³ in³txa² a²wẽ³sãi¹lxo³khai³lxa³te³ji¹wi¹, a²yxo²ha³kxa¹ so¹xai³ai¹nha²kxai³lu¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Kwa²yxah³lxi¹lxi¹. Txa²wã¹sũ̱³na² wãn³txa² ã³ne³to³yah²lxa³nha²kxai³ Sũ̱³na² wã³nxĩn¹ju³ta³la³ ã³ne³to³yah²lxa³nha²kxai³ nxe³yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yan¹nãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²ki̱³tãu³a¹ txu¹ha² so¹nhyu¹ki̱³ju³ta³nũ³a² yũ²nxa³lho³li¹. Oh³xan¹ta² nũ̱³ka̱³txa² yãx1ki̱³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nxe³yãn¹ta¹ Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxũ¹txai²na² sa²kxai³lu² ka³te̱n³su² ĩ³sa²yxau³xi²ki̱³kxe³nũ³su² ĩ³yau¹ũ¹nx2ti³ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nxe³tãu³u¹tai²na² nxe³te³nah¹lxi¹, “Txai²na² A³bra³ãu²ah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ I³sa²kah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ Ja³ko²ah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ hĩ¹na¹ nxe³te²sa¹wi¹.” Nxe³ta¹hxai²hẽ¹li¹. Nxe³jau³su² ha²kxai³ ha¹li¹ ka³na³ki¹ jah¹lo²nãu³xai²na² ka³te̱n³su² yxau³ain¹na³li¹. Txa²wã¹sũ̱³na² a²sa³wi³ha³lxi³nãu³xa² yxo²ha³kxa¹ ka³te̱n³su² na³li¹. Kxã³nãu³u¹ta²kxai³ ya³lu²ain¹kxa²ha³ta̱³nxãn²tu̱³ hĩ¹na² ka³te̱n³sain¹na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nxa²ha¹te¹ jau³jau¹xai²na² a²nũ²a²nãu³xai²na² ain³kxain¹tãu³a² o²lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nxa²ha¹te¹ fa³ri³se² nũ̱³ka̱³txai²na² sa²kxai³lu² sa³tu³se²a² nũ̱³ka̱³txa² ĩ³wã̱³txain¹ju³ta² ain³kxain¹nxa²ha¹te¹ ã³nũ¹nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ã³nũ¹nain¹sxã³ ka³na³ka³na³te²na² ha³te̱h³nxã³nxa² a³la³kxi²khaix1jah¹la² ĩ³ye³ta³la̱i³na³kxi²si¹jau³su² ĩ³wã̱³txain¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","— Ĩ³tih³nxe³nẽ³jah¹lãi³. Ha³te̱h³nxã³nxa² Txa²wã¹sũ̱³na² wãn³txu¹tai²na² ĩh¹jau¹la³ta̱³ ã³wa²to²hi² wxi²kan¹jau³la²hĩ̱³te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — “Txa²wã¹sũ̱³na² Si³yxau³jah¹la² Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹lai²na² a³lxi²txai¹nhẽ³li¹. Wxa²ẽ¹nãu³ai²na² whãi²na¹ a³lxi²txai¹nhẽ³li¹. Txa²wã¹sũ̱³na² wãn³txa² yxo²kwa̱i³nha²kxai³ wi¹lain³kxi¹nha²kxai³ nxe³txai¹nhẽ³li¹.” ");
INSERT INTO nabNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nxe³jau³jau¹xu¹tai²na² ã³wa²to²hi² wxi²kan¹jau¹la²te²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ã³ta³lo³hẽ¹jau³xai²na²sa¹: “Wxa²wa̱³kxa²yau³nũh¹nxa²te²a² a³lxi²nha²kxa² yã¹nxe² a³lxi¹tai¹nhẽ³li¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","A²nxe³jau³xu¹txai²na² Txa²wã¹sũ̱³na² wãn³txu¹tai²na² si³tah³lxi³yxau³te²ju²hẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jã¹nxe³tãu³ai²kxai³lu² fa³ri³se²a² nũ̱³ka̱³txa² ã³nũ²kxi²sxã³ yxau³ain¹tãu³a² Je³su²jah³lai²na² a²yxo²wãn³txa² nxe³te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","— Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹lo²su² ĩh¹te²la³ tah²su²hĩ̱³te²la¹xã³? Nxa²ha¹te¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Ta³vi²yah³la² a²ne³ta²sin²tai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Kxã³nhxĩ¹nu¹tai²na² Ta³vi²yah³lu¹tai²na² sa²kxai³lu² Sũ̱³na² Yãu³ka³jxah¹la² ã³si³tẽ³kxi²ha²kxai³ a²hxi²kan¹ti³lho³kxe³su² ĩ³ye³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Txa²wã¹sũ̱³na² Si³yxau³jah¹la² a²yxo²wãn³txi³kxai³lu² Txa²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la² ain³kxi²ti³an¹jau³kxai³lu¹: ‘Txa²wi¹nẽ³tãu³a¹ ã³wxe³txu¹li¹. Nxĩn¹kxai²nãn²tu̱³ wxa²ko̱¹ko̱¹xa² a²yxo²ha³kxa¹ wxa²yu̱³hẽ³nãu³a² wa³ka³ti³lot3sxã³ ah³si¹hai¹na¹tu¹wi¹.’ Txa²wã¹sũ̱³na² Si³yxau³jah¹la² ta¹hxai²hẽ¹li¹.” Ta³vi²yah³lu¹tai²na² ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jã¹nxe³jau³su² Ta³vi²yah³lu¹tai²na² a²yxo²wãn³txa² a²hxi²kan¹jah¹lo²si¹ke³la³te²kxai³ ĩh¹nxe³sxã³ a²ta²lhot3hĩ̱³te²la¹xã³? Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nxa²ha¹te¹ a²nũ²a²nãu³xai²na² hxi²kan¹ti³ ĩ³wa²lũ³xain¹ta¹hxai²nxa³hẽ¹la². Nxe³sxã³ nxe³hĩ¹nãn¹te²tu̱³ ãh¹ĩ³wã̱³tain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nxa²ha¹te¹ Je³su²jah³la² ãh¹e³kxi²ta¹hxai²hẽ¹la². A²nũ²a² nũ̱³ka̱³txa² ain³kxi² a²sa³wi³ha³lxa² ain³kxi² nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Nxain¹te³nah¹lxi¹: — A²nũ²a² ũ³wha²li¹txã³nxu¹txai²na² a²hoh³lxi³su² nũ̱³ka̱³txai²na² fa³ri³se²a² nũ̱³ka̱³txai²na² nxe³sxã³ Moi³se²ah³lu¹tai²na² wãn³txa² hxi²kan¹sxã³ ĩ³yau¹ũ³ti³hit1tain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nxai¹nha²kxai³ ĩ³ye³kxi¹nx2tain¹jau³xai²na² whãi²na¹ sa²yxo²we¹txain¹yah³lxi³hẽ¹li¹. Yxãn¹ta¹ kãi³ain¹kxa²yã¹nxe² kãi³yah³lxi³txa³hẽ¹li¹. A²nxe³tũ̱¹ka̱³txai²na² sa²kxai³lu² yau³xã̱³lxi² ĩ³ye³i² yau³ã̱³lxi² kãi³i² nxain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Te²yã¹nxe³sxã³ wãn³txa² sa³te̱²jau³xa² sa²yxo²wet1sxã³ kãi³si¹jau³su² a²nũ²a² ã̱³xa² kwa³na³ain¹na³li¹. Yxãn¹ta¹ jau¹xain²txi³ sa²yxo²we¹nhai¹nxa³wi¹. Te²yã¹nxe³kxe³hũ̱³nxe² a²nũ²a² ã̱³xa² yen³kxa² sa³te̱²kxa² ã³ta³lo³hẽ¹so¹si¹hain¹na³li¹. Yxãn¹ta¹ yen³kxain²txi³ a²hxi²ka³ wẽ³sa³ka³kxan²ti³ ũ³hxi²nũ¹nai¹nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nxẽ²nxa³kxa²yu³su² a²nũ²a² e³la² ĩ²kxain¹kxi³nũ³su² o²la³kxain¹te²ju²hẽ³li¹. Sũ̱³na² ha³te̱h³nxã³nxa² tẽ³sxã³ a²yen³nãu³a² ũ³yhe³hẽ¹nha² a²nxũ̱²ka² ã³nxũ²ki³hẽ¹nha² nxain¹te²ju²hẽ³li¹. Sũ̱³na² a³lxi²ye²ain¹kxe³su² Sũ̱³na² ĩ³ye³kxi²te³lhxã³ tãu³a¹ a²wã²la³ka³lo³khai³xai²na² tĩh³na² a³lu²tĩh³nu² ũ³kũ²txi² ai³ain¹te²ju²hẽ³li¹. A²nxe³tũ̱¹ka̱³txai²na² sa²kxai³lu² tĩh¹na² a²lu²txi³ wa³to²hi²ye²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","A²nũ²a² ã³nũ²kxi²sxã³ yain³kxi²nyhai¹nhxai²na²hẽ³ nxe³tãu³a² ã³wxe³ju³ta² sa²nẽn¹kxi²khaix1nxe³te²a² ã³wxe³ka³lo³a² yxo²kwa̱i³nai¹nha²kxai³ Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² te²yã¹nxe³sxã³ ã³wxe³ka³lo³a² sa²nẽn³nha²khaix1nxe³te²a² ã³wxe³ka³lo³a² yxo²kwa̱i³nain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sxi²je³na² ã³nxai³ain¹kxai²nãn²tu̱³ sa²nẽn¹kxi²sxã³ ĩ³kaix1tain¹te²ju²hẽ³li¹. A²nũ²a² ã̱³xai²na² ĩ³kaix1te³nah¹lxi¹: “Wxãi²li² txa²hxi²kan¹jah¹lo²si¹lxi¹.” Nxe³jau³su² yxo²kwa̱i³no³tain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nxe³yãn¹ta¹ wxãi²nãn²ta³: “Txa²hxi²kan¹jah¹lãi³.” Nxe²ĩ³ye³kxi¹nx2tain¹jau³su² yxo²kwa̱in³yah³lxi³txa³hẽ¹li¹. Txa²wã¹sũ̱³na² so¹lxi³ A²hxi²kan¹txa² Si³yxau³jah¹lai²la¹wi¹. Wxãi²nãn²ta³ a²lon³ti³tãu³su² nyhah¹lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te²yã¹nxe³sxã³ wxãi²nãn²ta³: “Txa²wĩ³na² Si³yxau³jah¹lãi³.” A²nũ²a² yuh³xan¹te²na² nxe² ĩ³lxi²yah³lxi³txa³hẽ¹li¹. Wxa²wĩ³na² Si³yxau³kah³la² ka³na³ka³na³tã³li¹, Oh³nãn¹jah¹lo²su¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Te²yã¹nxũn³sxã³ wxãi²nãn²ta³: “Txa²wa³kxẽn³ta³ si³yxau³kxah¹lãi³.” Nxe²e³ah³lxi³txa³hẽ¹li¹. Txai²na² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² so¹lxi³ Wxa²wa³kxẽn³ta² Si³yxau³kah³lo²sa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nxe³yãn¹ta¹: “Txa²nũ̱³ka̱³txa² ã³wa²to²hi² hxi²kan¹to³na¹kxi³nũ³su² ten³sa³nha¹.” Yxah³lxin¹kxai²nãn²tu̱³ wxa²yu³txai²na² yu³hẽn³nãu³a² hxi²nũ¹txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wxãi²nãn²ta³ ĩ²li³te² ĩ³nxãn²ta³ wi¹le³kxi¹nx2tain¹ju³ta³nũ³a² ten³yah³lxin¹kxai²nãn²tu̱³ yu̱³hẽn³yxau³nha¹jah³lxi³hẽ¹li¹. Te²yã¹nxe³sxã³ yu̱³hẽn³yxau³nyhah¹lxin¹kxai²nãn²tu̱³ hxi²kan¹txi³lo³txa²lxi³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nxa²ha¹te¹ ũ³wha²li¹txã³nxũ¹tai²na² a²hoh³lxi³su² tũ̱³ka̱³txi³su² te² ĩ³nxa² fa³ri³se²a² nũ̱³ka̱³txi³su² te²ĩ³nxa² wi¹lhin¹ki³lxo³yah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. A²nũ²a² Txa²wã¹sũ̱³na² nũ̱³ka̱³txi³lxon³ju³ta² te³nain¹kxai²nãn²tu̱³ ã³na¹ain¹yah³lxi¹nhẽ³li¹. Nxe³sxã³ Txa²wãn³txa² en²yah³lxi¹nha²kxai³ a²nũ²ai²na² Txa²wãn³txa² sa²yxo²we¹te³lhxã³ te²su² te²na² ã³na¹yah³lxi¹nha²kxai³ nxe³yah³lxi¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Wi¹lhin¹ki³lxo³yah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³to̱n³khaix1yah³lxin¹tu¹wi¹. Txu¹ta³ka³lxa² wha³te̱³son³ta¹ka³lxai²na² sxi²ha² kãi³so¹ah³lxi¹nhẽ³li¹. Hã²wxãn³txa³ ĩ³yan³txa³kxi²ki³lxot3si¹yhah³lxin¹jau³su² wãn³txa² ka³lxa²khai¹nxe³jau³xa² Sũ̱³na² ĩ³ye³kxi²yah³lxin¹tu¹wi¹. Nxe³yah³lxi¹nha²kxai³ a²hxi²ki³la³ yah³lxin¹ju³ta² ã²la² kãi²non³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Wi¹lhin¹ki³lxo³yah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³to̱n³khaix1yah³lxin¹tu¹wi¹. Yu̱h³xan¹ta² ha³lo²a² ai³lha²thet3jah³lxi¹lxi¹, a²nũ²a² ka³na³ka³nat3sxã³ ã³si³tẽ³kxi¹nx2ti³si¹jau³su¹. Ã³si³tẽ³kxi¹nx2ti³kxai²nãn²tu̱³ ko̱³nxe³ti³ kãi³yah³lxin¹kxa² kãi³ wa³to²hi²si¹hain¹yah³lxi¹nhẽ³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² wxãi²yãx1nxe³sxã³ ha³nxe²a² i̱³je³na² ã³na¹sa²tẽ³ain¹ju³ta³nũ³a² yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","A²nũ²a² ye³han³te²nãu³xa² ne³ka³ta²te²na² so¹te²na² yã¹yxah³lxi¹lxi¹. Yxãn¹ta¹ wxa²ẽ¹nãu³ai²na² wain³txi³ a̱in³nyhah¹lxa³nha²kxai³ ye³han³kxa² yã¹yxah³lxi³nũ³ni¹lxi¹. Nxe³sxã³ ki³han³jau³su² ĩ³ye³yah³lxin¹te³nah¹lxi¹: “‘Wãn³txi³su² e³a¹wi¹. Sũ̱³na² sxi²ha² ã³ye³yxo²nũ¹sa²na³li¹.’ Nxe³jau³xai²na² a²nũ²a² nxe²e³kxai²nãn²tu̱³ we¹ta³lun²nxa³kxan²ti³ ko̱³nxe³ju³ta² yũ³hĩ̱³nx2nxa³wi¹. Yxãn¹ta¹: ‘Wãn³txi³su² e³a¹wi¹. Sũ̱³na² sxi²ha² ou²ro²ka³lo³a² a³lxi²khai¹nxe³ka³lo³a² ã³ye³yxo²nũ¹sa²na³li¹.’ Nxe³jau³xai²na² e³kxai²nãn²tu̱³ a²wãn³txi³khai³xa² kãi³ũh¹kxe³su² o²la³kxi¹sẽ¹li¹.” A²nxe³jau³xai²na² e³yah³lxi¹lxi¹. Yxah³lxi¹nha²kxai³ ko̱³nxe³to̱n³khaix1yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ã³ne³to³ti³he¹yxah³lxa³lxi¹. Wxa²ẽ¹nãu³ai²na² wain³txi³ a̱in³nyhah¹lxa³nha²kxai³ ye³han³kxa² yã¹yxah³lxi¹lxi¹. Ou²ro²ka³lo³a² a³lxi²na³li¹. Yxãn¹ta¹ sxi²hai²na² ũ³ha³la³hẽ¹nha²thĩ³na² ã²la² a³lxi²khaix1te²ju²hẽ³li¹. Jã¹nxe³sxã³ sxi²hai²na² sa²kxai³lu² ou²ro²ka³lo³a² ã³nha³la³hẽ¹nha²kxa² ĩ³wxi²kin³ti³ton³si¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Te²yã¹nxe³sxã³ ãh¹jau³xa² yã¹jau³xa² e³yah³lxin¹te³nah¹lxi¹: “‘Wãn³txi³su² e³a¹wi¹. Txah³lxa³kxai²na² Sũ̱³na² ũ³yhen³kxi²ye²ka̱³txa² ã³ye³yxo²nũ¹sa²na³li¹. Sũ̱³na² ĩ³ki³ha¹kxi²ye²nxa³kxi³sã¹.’ Nxe³jau³xai²na² a²nũ²a² nxe² e³kxai²nãn²tu̱³ we¹ta³lun²nxa³kxan²ti³ ko̱³nxe³ju³ta² yũ³hĩ̱³nx2nxa³wi¹. Yxãn¹ta¹ yen³kxa² txah³lxa³kxa² ũ³nhe³wxe³jah¹lai²na² wãn³txi³kxai³lu¹: ‘Sũ̱³na² ũ³hũ¹kxi³nũ³su² ã³ye³yxo²nũ¹sa²na³li¹, Sũ̱³na² ĩ³ki³ha¹kxi²ye²nxa³kxi³sã¹.’ Nxe³jau³su² nxe² e³kxai²nãn²tu̱³ wãn³txi³khai³xa² kãi³ũh¹kxe³su² o²la³kxi²txai²lxi¹.” Nxe³jau³xai²na² e³yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wxa²ẽ¹nãu³ai²na² wain³txi³ a̱in³nyhah¹lxa³nha²kxai³ ye³han³kxa² yã¹yxah³lxi¹lxi¹. Ĩh¹ju³ta³la³ wxi²kin³ti³ton³sa³wa³to²hi²hĩ̱³te²la¹xã³? Txah³lxa³kxi³su² Sũ̱³na² ũ³yho²hi²si¹ka³txai²la³ ta̱³nxa² yen³kxi³khai³xa² ũ³hũ¹ke̱³kxi³nũ³ai²la³ ta̱³nxa², Ĩh¹ta²yen³kxa² kãin²wa³to²hi²te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ã³ye³yxo²nũ¹ki̱³kxai²nãn²tu̱³ txah³lxa³kxa² ã³ye³yxo²nũ¹ki̱³i² yen³kxa² ũh³wxe³kxi²ki̱³kxa² ã³ye³yxo²nũ¹ki̱³i² te²a² whãi²nah¹lxi³hĩ̱³ki̱³tã³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te²yã¹nxe³sxã³ Sũ̱³na² sxi²ha² ã³ye³yxo²nũ¹si¹ki̱³jau³su² e³kxi²ki̱³kxai²nãn²tu̱³ Sũ̱³na² sxi²ha² ã³ye³yxo²nũ¹ki̱³sa²kxai³ thĩ¹na² yxau²xai³jah¹la² ã³ye³yxo²nũ¹ki̱³sa²kxai³ nxe³hĩ̱³ki̱³tã³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te²yã¹nxũn³sxã³ oh³nãn¹ko³xa² ã³ye³yxo²nũ¹si¹ki̱³jau³su² e³kxi²ki̱³kxai²nãn²tu̱³ Sũ̱³na² ã³wxe³ka³lo³a² ã³ye³yxo²nũ¹ki̱³sa²kxai³ ã³wxe³ka³lo³a² wa³kxẽn³yah³la² ã³ye³yxo²nũ¹ki̱³sa²kxai³ nxe³hĩ̱³ki̱³tã³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ũ³wha²li¹txã³nxu¹tai²na² a²hoh³lxi³su² tũ̱³ka̱³txi³su² te²ĩ³nxai²na² fa³ri³se²a² nũ̱³ka̱³txi³su² te² ĩ³nxai²na² nxe³sxã³ wi¹lhin¹ki³lxo³yhah¹lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³to̱n³khaix1yah³lxin¹tu¹wi¹. Yen³kxa² jũ¹nxe³te²su² te²a² yain³kxi²ki̱³ki³a² or³ta³lã²ki³su² ta̱³nxa² ẽn²tro³ki³su² ta̱³nxa² ko³mĩn²yo³ki³su² ta̱³nxa² yũ³yah³lxin¹kxa² ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ yũ³yah³lxin¹kxai²nãn²tu̱³ ki³ka³na³ka³nat3sxã³ Sũ̱³na² ũ³hũ¹yah³lxi³hĩ̱³nxa¹lxi¹. Yxãn¹ta¹ ha³te̱h³nxã³nxu¹tai²na² ĩ³yau¹ũ³nhẽ³jau³su² ya²la³lo³khai¹su² wain³txi³ kãi³ũh¹kxe³su² ta̱³nxa² a²nũ²a² ã̱³xai²na² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³tũh¹kxe³su² ta̱³nxa² e³la² kãi³ũh¹kxe³su² ta̱³nxa² nxe³ju³tai²na² yxo²ha³kxa¹ sa²yxo²ã³yah³lxi¹lxi¹. Nxe³ju³tai²na² a²wi¹lhĩ¹nãn¹te²a² yxo²ha³kxa¹ kãi³yah³lxin¹ju³ta² wain³na³li¹. Te²yã¹nxe³sxã³ ne³ki³san¹te²a² sa²yxo²ã³yah³lxin¹ju³ta² wai³nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wxa²ẽ¹nãu³ai²na² wain³txi³ a̱in³nyhah¹lxa³nha²kxai³ ye³han³kxa² yã¹yxah³lxi¹lxi¹. Khũn³sa¹txa² ĩ³yo¹lah³lxin¹kxai²nãn²tu̱³ ĩ³yxe²ta²yxãi²nxa²lxi³hĩ̱³nx2na³li¹. Yxãn¹ta¹ Ka³me²lai²na² ka³yxuh³xa² kãin²te²na² wa³nũt1sxã³ ĩ³yo¹lhxat3jah³lxi³hĩ̱³nxa¹lxi¹. Nxe³ju³ta² yã¹nxe² ki³han³sxã³ e³yah³lxin¹te³nah¹lxi¹: “Kãi³ki̱³ju³ta² jũ¹nxe² so¹lxi³ ko̱³nxe³thin¹kxai²nãn²tu̱³ wi¹na³li¹. Yxãn¹ta¹ ko̱³nxe³thin¹khai¹nxe³kxai²nãn²tu̱³ wi¹ti³he¹nxa³wi¹.” Nxe³yah³lxin¹jau³su² wai³nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jã¹nxe³jut3su² wi¹lhin¹ki³lxo³yhah¹lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³to̱n³khaix1yah³lxin¹tu¹wi¹. Ka³ne²kxẽn³su² ta̱³nxa² pra²ta²ka³lo³su² ta̱³nxa² a²tai²na¹ wxa²hi̱³lxi³sxã³ wxa²hxan³kxa²jah³lxi³hĩ̱³nxa¹lxi¹. Yxãn¹ta¹ Wxa²ẽ¹nãu³ai²na² a²nũ²a² yen³kxa² kãi³kxi²nyhu¹ah³lxin¹ju³ta² yũ³ha²kxai³ yen³kxa² kãin²ka³tã³yah³lxin¹ju³ta² yũ³ha²kxai³ yen³kxa² kãin² yxo²kwa̱in³yah³lxin¹ju³ta² yũ³ha²kxai³ nxe³kxa²yã¹xah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fa³ri³se²a² nũ̱³ka̱³txi³su² te² ĩ³nxai²na² wxa²ẽ¹nãu³ai²na² wain³txi³ a̱in³nyhah¹lxa³nha²kxai³ ye³han³kxa² yã¹yxah³lxi¹lxi¹. A²wi¹lhĩ¹na² txa²nũ² ka³ne²kẽ³nai²na² pra²ta²ka³lo³ai²na² a²ẽ¹nãu³ai²na² wxa²hi̱³lxi³sã²nĩn¹ka̱³tu̱³ a²txai²na¹ ã³nhxan³ka²ti³nũ³nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jã¹nxe³jut3su² ũ³wha²li¹txã³nxu¹tai²na² a²hoh³lxi³su² nũ̱³ka̱³txi³su² te² ĩ³nxai²na² fa³ri³se²a² nũ̱³ka̱³txi³su² te² ĩ³nxai²na² nxe³sxã³ wxa²ẽ¹nãu³ai²na² wain³txi³ a̱in³nyhah¹lxa³nha²kxai³ ye³han³kxa² yã¹yxah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³to̱n³khaix1yah³lxi¹lxi¹. A²nũ²a² ya³lu²te²na² sa²nĩ̱³kxi²ki̱³tẽ³na² yãx1yah³lxi¹lxi¹. Nxe³sxã³ a²txai²na¹ tĩn²ta²yau³xa² hãn³jau³xa² tẽ³sxã³ ũ³to¹la³kxi²sxã³ ĩ³hãn³ne³ki³te²ju²hẽ³li¹. Yxãn¹ta¹ a²ẽ¹nãu³ai²na² ya³lu²te²a² a²su³ai²na² so¹lxi³ ka³lun³ju³tai²na² so¹lxi³ yũ³te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","A²nũ²a² ã̱³xai²nãn²tu̱³ ĩ²nx2tain¹kxai²nãn²tu̱³ wi¹lhin¹ye²yah³lxi¹lxi¹. Yxãn¹ta¹ wxa²ẽ¹nãu³ai²na² sa²kxai³lu² wi¹lhin¹ki³lxo³ju³ta² so¹lxi³ yũ³nyhah¹lxi¹nha²kxai³ Sũ̱³na² wãn³txa² sa²yxo²ã³yah³lxin¹ju³ta² so¹lxi³ yũ³nyhah¹lxi¹nha²kxai³ nxe³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jã¹nxe³jut3su² ũ³wha²li¹txã³nxũ¹tai²na² a²hoh³lxi³su² tũ̱³ka̱³txi³su² te² ĩ³nxai²na² fa³ri³se²a² nũ̱³ka̱³txi³su² te² ĩ³nxai²na² nxe³sxã³ wi¹lhin¹ki³lxo³yhah¹lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³to̱n³khaix1yah³lxi¹lxi¹. Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² kwã̱³kxẽ¹na² ũ³txon³yah³lxi¹lxi¹. Nxe³sxã³ a²nũ²a² wi¹lhin¹te²u¹tai²na² a²kwã̱³kxẽ¹na² ũh³yxo²tĩ̱¹kxi²ka̱³txa² wi¹wha²li¹la³kxi²yah³lxi¹lxi¹. Nxe³sxã³ ĩ³ye³yah³lxin¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","“Txa²wĩ³na²nãu³xu¹tai²na² yxau²xai³lai¹nhĩ¹nai³tã² hin¹sĩ¹na¹ke³la³te²kxai³ hai³txi³ Sũ̱³na² wãn³txa² ĩ³hen³txi³te²nãu³xu¹tai²na² a²ti³ha²yau³xa² ha³li³hxan³sxã³ ĩ³ya²lu¹tain¹si¹sĩ¹nxa³wi¹.” Yah³lxin¹jau³su² nxe³yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nxe³ha²kxai³ wxa²wãn³txi³khai³xa² hxi²ki³la³nx2ti³na³li¹. Sũ̱³na² wãn³txa² ĩ³hen³txi³nũ̱³ka̱³txu¹tai²na² ĩ³su¹lhã³te³nu¹tai²na² wẽ³ha³lxi³yah¹lxi³te²si¹lxi¹. Te²yã¹nxe² kãi³yah³lxi³nũ³ni¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nxain¹kxa²yã¹nxe² kãi³yah³lxin¹ju³ta² ta³lun²yah³lxin¹ju³ta² hxi²ki³lon³yah³lxin¹ju³tai²lẽ¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Txih³xa² ha³nxeh³lxi³te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³sxã³ wxãi²na² ha³nxeh³lxi³yah³lxi³nũ³ni¹lxi¹. Nxe³yah³lxi¹nha²kxai³ ha³nxe²a² i̱³sa²tẽ³ju³ta³nũ³a² hxi²kan¹txi³ ih³saun³yah³lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nxe³ha²kxai³lu¹ Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txa² ĩ³sa²si¹hã³i² a²nũ²a² a³la³kxi²khaix1te²na² ĩ³sa²si¹hã³i² ũ³wha²li¹txã³nxu¹tai²na² a²hoh³lxi³su² te²na² ĩ³sa²si¹hã³i² nxe³nx2ta¹tu¹wi¹. Nxa¹kxai²nãn²tu̱³ a²ha³tih³xa² ĩ³su²lhã³i² a²ha³tih³xa² hi³sa³ka³txa² ĩ³hxi²kĩ¹la³kxi² a²ha³tih³xa² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih¹so¹sãn²sxã³ ĩ³wai¹txi² a²ha³tih³xa² khãuh³lxa³txi³sa²thet3ti² nxain¹yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nxe³ta³lun²yah³lxin¹kxai²nãn²tu̱³ hxi²ki³la³khaix1yah³lxin¹tu¹wi¹. A²nũ²a² wi¹lhin¹te²nãu³xa² sun²tã¹ain¹te²nãu³xa² whãi²na¹ A³be²lah³lu¹tai²na² wi¹lhin¹khaix1jah¹lu¹tai²na² su²lhã³ai¹nhĩ¹nãn¹te²tu̱³ Sa³ka³ri²ah³lu¹tai²na² Ba³ra³ki²ah³lu²tai²na² tah²su² ha²kxai³ a²nxe³jah¹lai²na² sa²kxai³lu² Sũ̱³na² sxi²hẽ¹na² su²lhã³ain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Jã¹nxe³te²nãu³xu¹tai²na² a²yxo²ha³kxa¹ hxi²ki³la³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wãn³txi³su² e³kxi¹nx2ta¹wi¹. Hĩ¹na² hin¹yah³lxin¹te² ĩ³nxai²na² ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² khãuh³lxa³ti³nx2ti³nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nxa²ha¹te¹ Je³ru³sa³lẽ²thĩ³na² yxau²xai³yah³lxin¹te² ĩ³nxai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txa² su²lhã³ain¹yah³lxi³to³hi¹nha²kxai³ wxã³nũ¹nx2tain¹tũ̱³ka̱³txai²na² wha³tin³kxain¹yah³lxi¹nha²kxai³ nxe³sxã³ ko̱³nxe³to̱n³khaix1yah³lxi¹lxi¹. Yah³lxi¹nha²kxai³ ka³la³ka³la² a²hã³ka³nai²na² wẽ³ha³lxa² a²nxe̱³ki³yu³hẽ³nãu³a² wã²nut1te²ju²hẽ³li¹. Jãx1te²hũ̱³nxa¹tũ¹xã¹. Wxa²wẽ³ha³lxa² nxe³nx2ti³to³ha¹tai¹ti²tu³wi¹. Ye³ka³lxa¹txi³nx2ti³to³ha¹tai¹ti²tu³wi¹. Yxãn¹ta¹ ten³yah²lxan³tai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nxe³ha²kxai³ nxe³hĩ¹nãn¹te²tu̱³ wxa²sxi²ha² a²nũ²a² yũ³ai¹nx2tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ya²la³tu̱³ wãn³txan²tu̱³ ĩ³ye³a¹wi¹. Hĩ¹nãn¹te²tu̱³ ĩ²sah²lxan³tho³li¹. Kxãn³nãu³a² wxa²wãn³txi³nũ³su² ĩ³ye³kxah²lxin¹te³nah¹lxi¹: “A²nũ²ai²na² Txa²wã¹sũ̱³na² sa²si¹hã³nẽ³jah¹la² wi¹lhin¹jah¹lo²su²na³li¹.” Yah³lxin¹jau³nũ³su² yxah³lxi³sã²nĩn¹ka³tu̱³ hã²wxãn³txa³ ĩ²sah¹lxin¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nxa²ha¹te¹ Je³su²jah³la² e³ta³lun²nũ²la² Txa²wã¹sũ̱³na² sxi²ha² a³li³ta¹hxai²hẽ¹la². A³li³tãu³a² a²sa³wi³ha³lxai²na² sa²kxai³lu² sxi²ha² wi¹txo³nain¹ju³tai³tã² wã²nã³ũ¹hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Sxi²hai²na² txah³lxa³kxa² wi¹lhau³kot3je¹nxain¹nĩn²tai¹. Yxãn¹ta¹ kxãn³nãu³a² txah³lxa³kxa² a²yxo²ha³kxa¹ wxa²nai¹ain¹tu¹wi¹. Ya²la³tu̱³ hai³txi³ ka³tha¹li¹ ã³ne³hẽ²kxi²ka³txa² yũ²nx3tho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hã²wxãn³txa³ o³li³ve²ra³ka³txa² ka³la³sxã³ ã³wxe³ye²ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ a²sa³wi³ha³lxa² ã³tĩ̱³sxã³ wã²nxũ̱h¹ ĩ³wã̱³tain¹te³nah¹lxi¹: — Nxe³sãn²si¹lxi¹. Ĩh¹nxe³hĩ¹na² wxa²nai¹ain¹te³ji¹wi¹? Ĩh¹nxe³ti³wa̱³kxa² wa̱³lin¹ju³ta³nũ³a² ĩ²ki̱³te³ji¹wi¹? Ĩh¹nxe³ti³wa̱³kxa² txa²wã¹ha³lo²a² ne³ki³son³ju³ta²nũ³a² ĩ²sxã³ a³la³kxi²hĩ̱³ki̱³te³ji¹wi¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wi¹lĩ²nha²khai¹nxe³jah¹lxi³hẽ¹li¹. Ĩ³ki³ha¹kxi¹nx2ti³ha³tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","A²nũ²a² ka³lxa¹te²a² wxã³yah³lxi³ha³tai¹. Txai²la³ki³lxo̱³tu¹wi¹. Nxe³sxã³ wxã³sxã³ ki³han³jau³su² e³yah³lxi³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹. Wxa²kan³sxã³ wa̱³li²na¹hẽ³li¹.” Nxe³jau³su² e³yah³lxi³to³ha³tai¹. Nxe³yah³lxi³to³ha²kxai³ wxa²nũ̱³ka̱³txa² ka³lxa¹txi³ ã³nhai¹tũ¹sxã³ ĩ³ki³ha¹kxi¹nx2ti³ha³tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jã¹nxa¹jau³su² ti¹na² yxau³tũ̱³ka̱³txi³nãu³xai²na² kãin² ã³nhe¹kxi²nyhu¹sxã³ su²lhã³nhyain¹kxai²nãn²tu̱³ nũ¹ka³na¹ u²tãu³ai³tã² yxau³tũ̱³ka̱³txi³nãu³xai³tã² kãin² ã³nhe¹kxi²nyhu¹sxã³ su²lhã³nyhain¹kxai²nãn²tu̱³ nxe³jau³xa² ain³kxi²yah³lxin¹kxai²nãn²tu̱³ ĩ³yu̱³lyhah³lxi³txa³hẽ¹li¹. Wãn³txi³su² kxan²ti³ hai³txi³ hĩ¹nãn²tu̱³ ha³lo²ai²nãn²tu̱³ ne³ki³so³nx3tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","A²nũ²a² nũ̱³ka̱³txa² a²nũ²a² nũ̱³ka̱³txi³ ã̱³xa² a²lhun³tu² ã³nhe¹kxi²nyhai¹nha²kxai³ a²hxi²kan¹ta² si³yxau³tãu³a¹ a²hxi²kan¹ta² si³yxau³tãu³ ã̱³xa² a²lhun³tu² ã³nhe¹kxi²nyhu¹ha²kxai³ a²nũ²a² sxi²je³na² ka³lxa¹je³na² yain³txi³ txa²khaix1nxe³sxã³ he³ja²lun¹ti³ha²kxai³ ha³lo²a² kxĩh³nxa² sa²wi¹win¹nũh¹lxi²ha²kxai³ nxe³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Txu¹ha² wẽh³ni³khaix1ta¹ka³lxa² ĩh³ju³ta² wxã³kxai²nãn²tu̱³ wẽ³sa² a³li³lah¹kxi²ju³ta² hãi¹nxe³sxã³ ã³si³wxe³te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ ju¹tai²na² wxã³nũ¹nx2ti³kxai²nãn²tu̱³ khãuh³yxah³lxin¹ju³ta² ã³si³wxe³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Hã²wxãn³txa³ i³nx2tain¹sxã³ a²nũ²a² khãuh³lxa³thin¹kxi²ju³ta² ã³yũ³nx2tai¹nha²kxai³ ĩ³su²lhã³nx2tai¹nha²kxai³ nxe³nx2tain¹tu¹wi¹. Txa²wãn³txa² kan²txi³ ã³hxi²wxe³nũ¹sah¹lxi¹nha²kxai³ a²nũ²a² nũ̱³ka̱³txi³nãu³xa² a²yxo²ha³kxa¹ ĩ³xa̱n³ta³kxi¹nx2tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nxe³nx2ti³kxai²nãn²tu̱³ a²nũ²a²nãu³xa² ka³lxa¹tãu³a² txa²wãn³txa² sa²yxo²ã³sxã³ ã³waix3sain¹tu¹wi¹. Nxe³sxã³ a²nũ²ai²na² sa²kxai³lu² a²nũ²a² ã̱³xa² ko̱³nxe³ti³ kãi³tũ̱³ka̱³txa² ã³yã³nũt1sa²kxai³ ĩ³xa̱n³ta³kxi²nyhai¹nha²kxai³ nyhain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nxe³kxa²yu³su² a²nũ²ai²na² sa²kxai³lu² Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txa² si¹ki³lxo³tha²kxai³ ĩ³ki³ha¹kxi¹nx2tai¹nha³tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A²nũ²a² ko̱³nxe³ti³ kãi³ju³ta² kãi²no³nha²kxai³ a²nũ²a² a³lxi²nyhu¹kxi³ju³ta² kãi²nxa³ton³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jã¹nxe³jut3su² a²nũ²ai²na² Txa²wãn³txa² yxo²ĩ²sxã³ yxau²xai³kxai²nãn²tu̱³ nxe³te²su² te²na² a²ẽ¹nãu³ai²na² ã³wa²sut1sxã³ yxau³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jã¹nxe³sxã³ txa²wã¹ha³lo²ai²na² yuh³xan¹ko³nãu³xan¹ta² nũ̱³ka̱³txa² hãi¹nxe³ti³xa¹ ĩ³hen³txain¹tu¹wi¹. A²nũ²a² ĩ²li³te²na² ko̱³nxe³ti³ kãi³ju³ta² ĩ³ãin²ta³kxi²nha²sxã³ ã³kxai²nãn²tu̱³ yxo²ĩ²sain¹kxai²nãn²tu̱³ nxe³te²su² te²na² a²ẽ¹na² sa²hau³ko³tai¹na¹ju³ta² yũ³jau³nũ³su² ĩ³hen³txain¹tu¹wi¹. Nxe² ĩ³hen³txi³ ta³lun²sãn²te²ka³kxa¹ wa̱³li²na¹ju³ta² yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nxe³yãn¹ta¹ ĩ³lxi³thin¹ti³he¹nxa³jah¹la² a²yen³kxa² yxo²ha³kxa¹ wxa²khot3thun¹jah¹la² wxã³sxã³ Txa²wã¹sũ̱³na² sxi²ha² ã³wih¹sxã³ sa²nxũ³sxã³ yxau³ain¹tu¹wi¹. Nxe³ju³ta² wain³ti³hex1te²sxa³yu²hẽ³li¹. A²nxe³ju³tai²na² Ta³ni³e²lah³lu¹tai²na² wãn³txa² ũ³wha²li¹lhxã³ wxã³ju³ta²nũ³a² ĩ³yau¹ũ³nẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. Ha³te̱h³nxã³nxai²na² kãi³yain¹ju³ta² yũ³hĩ¹na¹ ã³ye³wxe³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A²nxe³jah¹lai²na² wxã³sxã³ yxau³ju³ta² ĩ²yah³lxin¹kxai²nãn²tu̱³ ã³naun³ti² ã³nih³jah¹lxi³hẽ¹li¹. Ju³te²a²ko³xa² yxau³te²su² te² ĩ³nxa² wã³la² kĩ³ka³txa² ã³nih³jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","A²nxe³ju³ta² a²nũ²a² sxi²ha² ne³ka³nah²nãu³a¹ he¹yah³lxin¹kxai²nãn²tu̱³ wxa²yen³kxa² sxi²hẽ¹nãu³ai²na² wi²sxa³kxai²nãn²tu̱³ ã³wi²xi²sxã³ so¹yah³lxi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ u²lã³ni¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Te²yã¹nxe³sxã³ a²nũ²a² hai³sxa³nãu³a¹ he¹yah³lxin¹kxai²nãn²tu̱³ ã³wa²li²sxã³ wã²la² ha³la³sa³nãn¹ka³lo³a² wxa²so¹xi²te³lhxã³ sxi²ha² ã³wi¹hxi²sxã³ wxa²so¹xah¹lxi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ u²lã³ni¹jah³lxi³sã²nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ko̱³nxe³jah¹lai²na² wxã³ju³tai²nãn²tu̱³ txu¹ha² wẽ³nhain¹te²su² te²na² kãin² khãuh³nxain¹tu¹wi¹. Txu¹ha² a²wẽ³sa² ũ³hi³lain¹te²su² te²na² kãin² khãuh³nxain¹nũn³tu¹wi¹, hxi²kan¹txi³ yãn¹txi³ ã³ni³hai¹nxa³ha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nxe³yãn¹ta¹ wa̱³txi²tãu³a¹ ta̱³nxa² sa²ba³to³ nxe³tãu³a¹ ta̱³nxa² nxe³sxã³ ã³nih³yah³lxin¹ke³la³te²kxai³ kãin² khãuh³yxah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yah³lxin¹kxa²ya̱n³ti³su² Txa²wã¹sũ̱³na² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nxe³hĩ¹nãu³ãn²tu̱³ ha³lo²a² ko̱³nxe³khai¹nxe³ju³ta² ĩ³lxa³thin¹ti³hex1nxa³ju³ta² yũ³tu¹wi¹. Txa²wã¹si³kxã³nãu³hĩ¹nũ¹tai²nãn¹te²tu̱³ Txa²wã¹sũ̱³na² ha³lo²ai²na² we¹thĩ¹nãn¹te²tu̱³ a²ko̱³nxe³ju³ta² yũ³ju³ta³nũ³a² kũ³we²ki²la² ko̱³nxe³thi¹nxa³ha²kxai³ yxan¹nãu³a¹ ha³lo²a² nxe²xai³tãu³a¹ ko̱³nxe³ju³ta² yũ³ju³ta³nũ³a² kũ³we²ki²la² ko̱³nxe³thi¹nxa³ha²kxai³ nxe³te²ju²hẽ³li¹. Nxe³yãn¹ta¹ a²ko̱³nxe³ju³tai²nãn²tu̱³ ĩ³ye³kxi¹nx2ta¹ju³tai²nãn²tu̱³ so¹lxi³ ã²la² ko̱³nxe³thin¹khai¹nxe³ju³ta² yũ³hĩ̱³nx2na³li¹. Nxe³ju³ta² a²nũ²a² ã²la² kxa²kãin² khãuh³lxa³ti³hĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nxe³ha²kxai³ Txa²wã¹hxi²kan¹ta² si³yxau³tãu³a¹ ha³lo²ai²nãn²tu̱³ ko̱³nxe³khai¹nxe³ju³tai²nãn²tu̱³ ã³yã³ni²lã³ain¹sãn²tu¹wi¹, a²nũ²a² Txa²wã¹sũ̱³na² hxi²ka² ã³yũ³so¹xi²kxe³su² te²a² a³lxi²khaix1ai¹nha²kxai³lu¹. Ã³yã³ni²lã³ai¹nxa³ke³la³te²kxai³ hai³txi³ a²nũ²a² ka³na³ka³na³ta² he³la³ku³ ka³te̱n³su² yxau²xai³hĩ³nx2nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nxe³nxa²ha¹te¹ a²nũ²a² a²ten³te²su² te²an²tu̱³ ĩ³ki³han³jau³su² ĩ³ye³kxi¹nx2ti³kxai²nãn²tu̱³: “Ti¹na² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹la² he¹na³li¹.” Ta̱³nxa², “Nũ¹ka³na¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹la² he¹na³li¹.” Ta̱³nxa² nxe³nx2tain¹kxai²nãn²tu̱³ yxo²ĩ²ain¹sxã³ yxau²xai³lyah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","A²nũ²a² ã³wxã³ain¹sxã³ ĩ³ki³ha¹kxi¹nx2tain¹tu¹wi¹. Nxe³ju³ta² ka³na³ku² te²a²: “Txai²li² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹.” Ka³na³ku² nũn³te²a²: “Txai²li² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²sa¹wi¹.” Nxe³nx2tain¹tu¹wi¹. Nain¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² nũ³kxũn³ki³lxot3sxã³ kãi³ain¹tu¹wi¹. Ain¹sxã³ a²nũ²a² Sũ̱³na² ã³yũ³so¹te² ĩ³nxai²na² ĩ³ki³ha¹kxi¹nx2tai¹nha³ta²wi¹. On³sxã³ yxo²ĩ²ain¹yah³lxin¹kxa²ya̱n³ti³su² ye¹nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yan¹nãu³a² ha³lo²ai²nãn²tu̱³ nxe²xai³tu¹wi¹. Nxe³yãn¹ta¹ Txai²li² kwẽn¹tai²na² ĩ³hen³txi¹nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jã¹nxe³jut3su² ĩ³ki³ha¹kxi¹nx2ti³jau³su² nxe²e³kxi¹nx2tain¹te³nah¹lxi¹: “Ha³lo²a² sxi²ha² yũ²nxa³ko³nãu³a² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹la² he¹na³li¹.” Ta̱³nxa², “A²sxi²hẽ¹na² he¹na³li¹.” Ta̱³nxa². Nxe³nx2tain¹kxai²nãn²tu̱³ sa²yxo²we¹jah³lxi³txa³hẽ¹li¹. Ki³ha¹kxi¹nx2tain¹jau³xai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","U³je³na² a³li³xi²tãu³a² ha³lai³nĩ³kxai²nãn²tu̱³ wa³su³txi³ u³je³na² kan³tãu³a² ĩ³ko̱x1ko̱¹tũ³na³li¹. Nxe³kxe³hũ̱³nxe² wa³su³txi³ wxã³kxa²yã¹nxe³sxã³ wxã³na¹ju³ta³nu³a² e³la² ĩ²yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jã¹nxe³jut3su² ka³yxuh³xa² ya³lu²sxa̱³ti³xa² wa³lu³hxa² ã³nũn²kxi²te²ju²hẽ³li¹. Nxe³ye¹nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yxan¹nãu³a¹ a²ko̱³nxe³ju³tai²nãn²tu̱³ ne³ki³son³kxai²nãn²tu̱³ a³lan²tan¹ta³ki³ain²ti³ ĩ³ka²nxa¹hi²ha²kxai³ ka³nxah³txan¹ta³ki³ain²txi³ ĩ³ka²nxa¹hi²ha²kxai³ i³la³kxa² wẽ³ha³lxa² whãi²na¹ oh³sĩ̱n³nãu³a¹ ã³nhait1sa²kxai³ oh³nãu³a¹ yxau³te²su² te²a² hxi²ka̱u³ka̱un³ti³ ã³nxai³lai¹nha²kxai³ nxe³ain¹tu¹wi¹. Nxe³sxã³ o³sĩ̱³na² whãi²na¹ ĩ³ã̱³lxi³ton³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nxe³tãu³a¹ ĩ³na¹je³nãu³wa³ki³khai³xa² ĩ²ain¹tu¹wi¹. Nxe³te²kxa²ya̱n³tu̱³ a²nũ²a² nũ̱³ka̱³txi³nãu³xai²na² a²yxo²ha³kxa¹ ko̱³nxe³ti³ kãi³ain¹ju³ta² ĩ³ãin²ta³kxi²nyhain¹sxã³ nã̱³nain¹tu¹wi¹. Jã¹nxe³sxã³ Txai²na² oh³sĩ̱n³nãn¹ka³lo³a² hãn³ta³ka³lo³a² whãi²na¹ a³ka³nxi²na¹ka³tu̱³ wxã³na¹tu¹wi¹. Nũ̱³kxũn³txi³ ĩ³kĩx3khai¹nxe³ha²kxai³ wxã³na¹tu¹wi¹. Wxã³na¹ju³tai²nãn²tu̱³ a²nũ²a² yxo²ha³kxa¹ ĩ²sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nxa¹kxai²nãn²tu̱³ oh³xan¹ta² hxi²kan¹jah¹la² wãi²lhũ̱³ka³txa² wxa²no²la³kxi²si¹hai¹na¹jau³su² ĩ³sa²si¹hã³ai¹na¹tu¹wi¹. Nxe³sxã³ wxa²no²la³kxi²hĩ¹na¹ oh³xan¹ta² nũ̱³ka̱³txa² ka³lxa²te² nũ̱³ka̱³txa² ĩ³sa²si¹hã³ai¹nũ³na¹tu¹wi¹. Nxe³ai¹na¹kxai²nãn²tu̱³ a²nũ²a²nãu³xa² Txa²wã¹sũ̱³na² ã³yũ³so¹kxe³so¹lxi³kxe³nãu³xa² nxe³te²nãu³xa² yuh³xan¹ko³nãu³xa² u²lxi³ yxau³yah³lxi³kxan²ti³ ãn³sa²so¹sxã³ ã³sa²ki³nũ²kxai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jã¹nxa¹jau³su² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi¹nx2ta¹wi¹. Nxe³na¹te³nah¹lxi¹: “Ta³kon³ta³ki³yãu³su² ha̱u³ta³lun²sxã³ ãn³ki³i²nha³na¹ nxe³kxai²nãn²tu̱³ kwẽ³kon³ju³ta² ya̱u³son³te²jai¹ti²tu³wi¹. Nxe³ju³ta² kwẽ³kon³ju³ta² hau³kon³na³na¹ nxe³je³nãu³wa³kxa² a²ĩ³lxa² ta³kon³ta³ka³ta² ĩ³yau¹ũ³nhẽ³lain¹te²jai¹ti²ti¹.” ");
INSERT INTO nabNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jã¹nxe³kxe³hũ̱³nxe² ha³lo²ai²na² ã³wxã³na¹je³nãu³wa³kxa² nxe³kxa²yã¹nxe² yũ³nũn³na³li¹. Wãn³txi³su² e³kxi¹nx2ta¹wi¹. Ju¹tai²na² e³kxi¹nx2ta¹ju³tin³ti² ko̱³nxe³khaix1ju³tin³ti² ĩ²yah³lxin¹kxai²nãn²tu̱³ ã³wxã³na¹ju³ta³nũ³a² a²kwẽn¹tai²na¹ yũ³tu¹wi¹. Wxa²sxi²yxo²a² ã³ya̱u³son³kxi²nx2ta¹kxa²yã¹nxe³hĩ̱³nx2na³li¹. Na¹jau³su² wã²nxũ̱h¹ a³la³kxi¹jxah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wãn³txi³su² e³kxi¹nx2ta¹wi¹. Ju¹tai²na² ĩ²yah³lxin¹kxai²nãn²tu̱³ hĩ¹na² ka³te̱n³su² yxau²xai³tũ̱³ka̱³txa² ya³lu²ai¹nxa³ta̱³lxa¹ jau¹xai²na² a²yxo²ha³kxa¹ kãi³ta³lun²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Oh³nãu³nũ¹ai²na² hxa³ni² ha³lo²a² yuh³xai²na² hxa³ni² nxe³ain¹tu¹wi¹. Nxe³yãn¹ta¹ Txa²wãn³txa² so¹lxi³ ya²la³ti³ yxau²sa²tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nxe³yãn¹ta¹ nxe³ju³ta²nũ³ai²na² ĩ³ye³kxi¹nx2ta¹ju³ta²nũ³a² ũ³hũ¹nhẽ³lain¹je³nãu³wa³kxa² a²nũ²a² yxo²ha³kxa¹ ko̱³nhai¹nxa³ha²kxai³ oh³xan¹ta² nũ̱³ka̱³txa² ko̱³nain¹nũ³nxa³ha²kxai³ Txai²na¹xai²na² ko̱³nhũ³nxa³ha²kxai³ ya³sain¹tu¹wi¹. Nxe³je³nãu³wa³kxa² Txa²wĩ³na² so¹lxi³ wi¹ko̱³nha²te²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Txai²na² a³kan³sxã³ wxã³na¹ju³ta³nu³a² No³e²ah³lu¹ta² he¹tãu³su² tãu³a² yã¹nxe³tu¹wi¹. Kxã³nhxĩ¹nu¹tai²na² No³e²ah³lu¹tai²na² txa²wã¹ha³lo²a² yxau³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nxe³tãu³u¹tai²na² ĩ̱³yau³xa² ũ³hũx3ti³wa³kxa² a²ka³lxa¹ti³nãu³xu¹tai²na² kwa²ĩ³yain³kxi²nyhu¹i² kwa²ĩ³na²kxi²nyhu¹i² txu¹ha² so¹kxi²nyhu¹i² txu¹ha² ũ³hũ¹nyhu¹i² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²nyhai¹nxa³i² ain¹sxã³ No³e²ah³lu¹tai²na² sa²kxai³lu² na³vi²o²tẽ³na² ar²ka³tẽ³na² ã³wih¹ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yxãn¹ta¹ No³e²ah³lu¹tai²na² wãn³txa² a³la³kxi²yain¹ta¹hxai²nxa³hẽ¹li¹. Ĩ̱³yau³xa² wẽ³hã¹sxã³ ã³so¹ai¹nhĩ¹na¹ a³la³kxi²yain¹ta¹hxai²hẽ¹li¹. Te²yã¹nxe³kxe³hũ̱³nxe² Txai²na² a³kan³sxã³ wxã³na¹ju³ta³nu³a² a³la³kxi²yain¹nx2tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jã¹nxe³ju³kxai³lu² in³txa² ha¹li¹ hai³sxa² tau³ya³tãu³a² ka³na³ki² sa²so¹ha²kxai³ ka³na³ki² ot3sa²kxai³ nxe³ya³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ai¹nha²kxai³ txu¹ha² ha¹li¹ nxũ̱³sa² o²la³kxi²ya³tãu³a² ka³na³ki² sa²so¹ha²kxai³ ka³na³ki² ot3sa²kxai³ nxe³ya³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nxe³ha²kxai³ ha³lo²a² nũ¹hĩ²jah¹lxi³hẽ¹li¹, wa̱³li²na¹je³nãu³wa³kxa² ko̱³yah³lxa³nha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Te²yã¹nxe³ju³kxai³lu² ka³nxah³ti³na² so¹lxi³ yen³kxa² kãi³jah¹la² hãi³a² wxã³te²ju²hẽ³li¹. Nxe³kxi³sa²kxai³ sxi²ha² wa³kxẽn³yah³lai²na² sa²kxai³lu² yen³kxa² kãi³jah¹la² wxã³je³nãu³wa³kxa² a³la³kxi²ke³la³te²kxai³ ye³ten³nha²sxã³ wah³nxe³hĩ̱³nx2na³li¹. Sxih²yxo²a² yxo²ĩ¹in¹kxe³su² yen³kxa² tĩ¹kxi¹nxa²hĩ̱³nx2nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jã¹nxe³jut3su² ye³ten³nha²kxi³hũ̱³nxe² wahx3nxe³jah³lxi³hẽ¹li¹. Nxe³sxã³ wxa²ẽ¹nãn¹jau³kxai³: “Hĩ¹na² wxã²nxa³lho³na¹.” Nxe³yah³lxin¹jau³su² nxe³ti³wa³kxa² wxã³na¹ha³ta²wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Te²yã¹nxe³jut3su² sxi²ha² wa³kxẽn³yah³la² a²sa³wi³sa² wi¹lhin¹te²na² so¹lxi³ ã³ne³wxe³khaix1te²na² so¹lxi³ a²sxi²khai³xa² hau³kot3si¹jau³su² ũh³wxe³te²ju²hẽ³li¹. A²nxe³jah¹lai²na² sa²kxai³lu² wi¹lhi¹nha²kxai³ yain³txi³su² ũ³hũ²xai³ain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wi¹kãi³kxai²nãn²tu̱³ a²wa³kxẽn³yah³la² wxã³tãu³a² wi¹lxon³kxi²kxai²nãn²tu̱³ kãi³ti³hit1tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Wãn³txi³su² e³kxi¹nx2ta¹wi¹. Yen³kxa² a²yxo²ha³kxa¹ hau³ko³te³lhxã³ ũh³wxe³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nxe³yãn¹ta¹ a²sa³wi³sa² a²ẽ¹na² e³ke³la³te²kxai³ nxe³te³nah¹lxi¹: “Txa²hxi²kan¹jah¹la² kxãn³sa²sxã³ wxã²nxa³lho³na¹.” Yha²jau³su², ");
INSERT INTO nabNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nxe³ka³tu̱³ a²wa³kxẽn³yah³lai²na² sa³wi³ha³lxa² ã̱³xai²na² ĩ³wai¹tã³si³wxe³ha²kxai³ kãin² yai³nha²kxai³ kãin² ĩ³na²sa³we¹nha²kxai³, ");
INSERT INTO nabNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nxe³tãu³ãn²tu̱³ta¹ ko̱³nha²nxa³ku¹ha² a²wa³kxẽn³yah³la² ĩ³xi²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nxe³sxã³ a²sa³wi³sai²li² kãin² ĩ³wait1si¹ha²kxai³ ha³lo²a² wi¹lhin¹ki³lxo³te²nãu³xa² ũh³wxe³si¹je³na² ũ³tĩ̱¹kxa² wxe³kxain¹tu¹wi¹. Nxe³tãu³a² ye³khãuh³lxa³thin¹ju³tan¹te²kxa³ya̱³lhu² kãin² nã̱³ni² kãin² wxi²ka³ta³ta³ti² nxe³sa²tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jã¹nxa¹jau³su² a²nũ²a² a²ẽ¹na² sa²hau³ko³te²nũ³a² ĩ³yau¹ũ³hi² a²ẽ¹na² sa²hau³ko³txa³te²nũ³a² ĩ³yau¹ũ³hi² nxe³nx2ta¹tu¹wi¹. A²nxe³te²na² wãin²te²nãu³xa² yã¹nxe³ti³hĩ̱³nx2na³li¹. A²nxe³te²nãu³xai²na² in³txa² kwẽn¹tai²na² txu¹ha² so¹te³lhxã³ jah¹la² wahx3nxain¹nũ²nhai¹. Wi¹lxon³kxi²jau³nũ³a² ĩ³ye³kxi²te³lhxã³ wahx3nxain¹nũ²nhai¹. Nxe³sxã³ ka³nxa³hi²ha²kxai³ lã³pi³ãu²tẽ³na² tẽ³sxã³ a³li³ain¹ka³tu̱³ wahx3nxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","A²nxe²te²wãin²te²nãu³xa² a²wã³kxi³kxai³ ha¹li¹ ha¹li¹ ka³na³ki¹ a³la³kxi²yai¹nha²kxai³ a²wã³kxi³kxai³ ha¹li¹ ha¹li¹ ka³na³ki¹ a³la³kxi²ye³yhai¹nxa³ha²kxai³ nxe³te²wãin²te²nãu³su² nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A²nxe³sxã³ a³la³kxi²ye²yhai¹nxa³te² wãin²te²nãu³xa² o²lyau³xa² taut3ton³jau³xa² sa²so¹ai¹nxa³ha²kxai³ lã³pi³ãu²tẽ³na² so¹lxi³ sa²so¹ha²kxai³ nxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nxe³yãn¹ta¹ a³la³kxi²ye²yhain¹te² wãin²te²nãu³xa² lã³pi³ãu²tẽ³na² sa²so¹ha²kxai³ o²lyau³xẽ¹na² ãh¹ sa²so¹ai¹nha²kxai³ nxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jã¹nxe³jut3su² in³txai²na² txu¹ha² so¹nh³jah¹la² wa³su³txi³ wa̱³li²nxa³ha²kxai³ wãin²te²nãu³xai²na² wah³nxa² hxi²tha³nhai¹nha²kxai³ ãu³xi² ã³si³wxe³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nxa²ha¹te¹ ka³nxah³ta² wi³ta³lon³sxã³ ĩ³kaix1tain¹jau³su² ain³kxain¹nũ²nhai¹. Ain³kxain¹te³nah¹lxi¹: “In³txa² wẽ³sãi¹ah³lai²na² wxã²na³ni¹. Ã³ne³khauh²kxi¹jah³lxi³hẽ¹ni¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nxe² ain³kxi²nyhu¹te³na¹ wãin²te²nãu³xa² a²yxo²ha³kxa¹ ĩ³sa²yxau³nũ²la² a²lã³pi³ãu²khai³xai³tã² wxa²hau³kot3sxã³ tẽ³sxã³ ai³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nxe³tãu³a¹ a³la³kxi²ye²yhai¹nxa³te² wãin²te²nãu³xai²na² a²yxo²wãn³txi³kxai³lu¹: a³la³kxi²ye²yhain¹te² wãin²te²nãu³xai²na² ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: “Nxe³jah³lxi³si¹nxi¹. Wxa²ol²yau³xa² wã²nhũh¹syah¹lxi³sĩ¹ni¹. Lã³pi³ãu²tẽ³na² tẽ³sĩ¹na¹kxa² ĩ³yũ¹la³kxi²sa²sĩn¹na²ni¹.” Nxe³nyhain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nxa²ha¹te¹ a³la³kxi²ye²yhain¹te² wãin²te²nãu³xa² sa²kxai³lu² ĩ³wa²lũ³xi²nyhain¹te³nah¹lxi¹: “Kwa²nhi¹nxi¹. Hxi²kan¹sa²sĩ¹nxa³nhi¹. O²lyau³xa² whãi²na¹ hxa³nẽ³kxa²ya̱n³txi³su² nũh¹xai³yah³lxin¹sxã³ o²lyau³xa² so¹kxi²nyhu¹kxi³thĩ³na² ai³sxã³ tah²yau³xa² so¹kxi¹jah³lxi³hẽ¹ni¹.” ");
INSERT INTO nabNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nxe³nũ²la² a³la³kxi²ye²yhai¹nxa³te² wãin²te²nãu³xai²na² o²lyau³xa² ãh¹so¹kxi²te³lhxã³ a³li³ain¹tãu³a² in³txai²li² wa̱³li²nũ²nhai¹. Wa̱³li²sxã³ wah³nxe³te²wãin²te²nãu³xa² ĩ³yain³kxi²te³lhxã³ ã³wi¹hya³hain¹nũ²nhai¹. Ã³wih¹nũ²la² hã²wxãn³txa³ wi²wxã³je³nãu³wa³kxa² ha³nãu³hi²ha²kxai³ sxih²yxo²a² ũh³yxo²ĩ¹nũ²la² yain³kxi²nyhain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hã²wxãn³txa³ a³la³kxi²ye²yhai¹nxa³te² wãin²te²nãu³xa² ã³wa̱³lain¹nũ²la² ĩ³yxo²to¹to¹tain¹te³nah¹lxi¹: “Sa²yxo²than²kxi²sa²sĩ¹nhẽ³li¹.” Nxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nxa²ha¹te¹ in³txai²li² ĩ³wa²lũ³xi²te³nah¹lxi¹: “Nxe³sa²nxi¹. Ya²la³tu̱³ ã³ye³wxe³nxa²lxi³nxa³nhi¹. Hxi²kan¹sa²nxa³nhi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jã¹nxa¹jau³su² ye³ten³nha²sxã³ wahx3nxe³jah³lxi³hẽ¹li¹. Ha³lo²a² wa̱³li²na¹ti³wa³kxa² ko̱³yhah¹lxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Te²yã¹nxũn³jau³su² ĩ³ye³kxi¹nx2ta¹tu¹wi¹. Wi¹kãi³kxi²sain¹te²su² te²na² a²yo³ha² wi¹lũ³yho³hai¹na¹kxi³nũ³su² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Nxe³kxa²yã¹nxe² hĩ̱³nx2na³li¹. Nxe³te³nah¹lxi¹, in³txi³su² yen³kxi³nh²jah¹la² ha³lo²a² u²la²nãn¹ko³xa² ai³te³lhxã³ nxũ²nhai¹. Nxe³sxã³ a²sa³wi³ha³lxa² ĩ³kaix1sxã³ a²yen³kxi³khai³xa² wã²nhũh¹xai³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A²wi¹lhĩ¹nãn¹ta² sa³wi³sa² ũ³yho³hi²ki³ki³a² ki³ha¹li¹ ki³ha¹li¹ ka³na³ki¹ nxe² ka³lxa²ki³a² wã²nhũh¹nũ²nhai¹. Ã³ta³lo³hẽ¹te² sa³wi³sa² ki³ha¹li¹ wã²nhũ¹ha²kxai³ ne³ki³son³te² sa³wi³sa² ki³ka³na³ki² wã²nhũ¹ha²kxai³ nxain¹sxã³ ũ³yho³hi²nyhu¹ki³a² hxi²ka¹nain¹kxa² yã¹nxe² a²yen³kxi³khai³xa² wã²nhũ²xai³ain¹nũ²nhai¹. Nxe³ka³tu̱³ u²lxai³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nxe²ai³tãu³a² a²wi¹lhĩ¹nãn¹ta² a²sa³wi³sa² yen³kxa² ũ³yho³hi²ki³a² ki³ha¹li¹ ki³ha¹li¹ ka³na³ki¹ so¹kxi²jah¹lai²na² sa²kxai³lu² ki³ai²na² tẽ³sxã³ wain³txi³ wa³kon³kxi²ha²kxai³ ki³lã̱³xa² ãh¹ki³ha¹li¹ ki³ha¹li¹ ka³na³ki¹ ãh¹so¹kxi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Te²yã¹nxe³jut3su² ã³ta³lo³hẽ¹te² sa³wi³sa² ũ³yho³hi²ki³a² ki³ha¹li¹ so¹kxi²jah¹lai²na² sa²kxai³lu² ki³ai²na² tẽ³sxã³ wain³txi³ wa³kon³kxi²ha²kxai³ ki³lã̱³xa² ãh¹ki³ha¹li¹ ãh¹so¹kxi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nxe³yãn¹ta¹ ne³ki³son³te²a² ũ³yho³hi²ki³a² ki³ka³na³ka³nat3sxã³ so¹kxi²jah¹lai²na² sa²kxai³lu² ta³ki¹ai²na² tẽ³sxã³ a³li³nũ²nhai¹. Ha³lo²a² ai³nũ²la² kxĩh³nxa² wxa²xu³sxã³ ũ³yho³hi²ki³ai²na² wã²nhũ¹hain¹ki³ain²ti³ ũ³whĩ̱¹kxi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Hã²wxãn³txa³ ye³ka³lxa¹txi³ a³lan²ton³tãu³a² yen³kxa² a²wa³kxẽn³yah³la² ĩ³xi²nũ²nhai¹. Ĩ³xi²ka³tu̱³ a²yen³kxa² ĩ³hau³kot3si¹jau³su² a²sa³wi³ha³lxa² ĩ³kaix1tũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nxe³te³na¹ a²wi¹lhĩ¹nãn¹ta² sa³wi³sa² ũ³yho³hi²ki³a² ki³ha¹li¹ ki³ha¹li¹ ka³na³ki¹ so¹kxi²jah¹lai²na² sa²kxai³lu² ki³lã̱³xa² so¹kxi²ki³ain²ti³ hxi²tẽ³nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Txa²sũ̱³nãi³. Ũ³yho³hi²ki³a² ki³ha¹li¹ ki³ha¹li¹ ka³na³ki¹ ũ³hũ¹san¹tai¹ti²tu³wi¹. Nxe³yãn¹ta¹ ki³lã̱³xa² ãh¹lxi³sxã³ ki³ha¹li¹ ki³ha¹li¹ ka³na³ki¹ ãh¹so¹kxi²na¹hẽ³li¹. Ĩ²txa²hẽ³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nxa²ha¹te¹ a²wa³kxẽn³yah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: “Wi¹na³li¹. Yen³kxa² jũ¹nxe² ũ³hũ¹nxa²ha¹kxai³tã² wi¹wi¹nxe² wa³kon³kxi²sa²te²sin¹tai¹. Nxe³ha²kxai³ yen³kxa² kãi²li³sxã³ ũ³hũ¹sa³wxe³nxa²ha¹tu¹wi¹, sa²hau³kot3si¹nxa²ha¹jau³su¹. Wi¹lo²la³kxi²xai³ki̱³tu¹wi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Te²yã¹nxe³sxã³ ã³ta³lo³hẽ²te² sa³wi³sa² ũ³yho³hi²ki³a² ki³ha¹li¹ so¹kxi²jah¹lai²na² sa²kxai³lu² ki³lã̱³xa² so¹kxi²ki³ain²ti³ hxi²tẽ³nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Txa²sũ̱³nãi³. Ũ³yho³hi²ki³a² ki³ha¹li¹ ũ³hũ¹san¹tai¹ti²tu³wi¹. Nxe³na¹ta¹ ki³lã̱³xa² ãh¹lxi³sxã³ ki³ha¹li¹ ãh¹so¹kxi²na¹hẽ³li¹. Ĩ²txa²hẽ³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nxa²ha¹te¹ a²wa³kxẽn³yah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: “Wi¹na³li¹. Yen³kxa² jũ¹nxe² ũ³hũ¹nxa²ha¹kxai³tã² wi¹wi¹nxe² wa³kon³kxi²sa²te²sin¹tai¹. Nxe³sa¹nha²kxai³ yen³kxa² kãin² ũh³hũ¹sa³wxe³nxa²ha¹tu¹wi¹, sa²hau³kot3sih¹nxa²ha¹jau³su¹. Wi¹lo²la³kxi²xai³ki̱³tu¹wi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Te²yã¹nxe³sxã³ ne³ki³san³te² sa³wi³sa² ũ³yho³hi²ki³a² ki³ka³na³ka³nat3sxã³ so¹kxi²jah¹lai²na² sa²kxai³lu² wai³nxa³jau³su² ĩ³ye³kxi²te³nah¹lxi¹: “Txa²sũ̱³nãi³. Hxi²kxã̱u³jah¹lo²si¹lxi¹. Yain³txa² wa³kon³nxã³kxan²ti³ hãi¹sxã³ wa³kon³kxi²nxain¹kxa² yen³kxa² sa²so¹nha²kxai³ yain³txa³ki³a² ũh³wĩ̱¹xan³kxan²ti³ yain³txa² ũ³whĩ̱¹kxi²nxain¹kxa² yain³txa² sa²so¹nha²kxai³ nxe³te²si¹lxi¹. Wxa²yen³kxa² kãi²non³nha²kxai³ wxa²sa³wi³ha³lxai²na² yen³kxa² kãi²no³txa³ha²kxai³ nxe³te²si¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nxĩ¹nha²kxai³ yu̱h³lxi³nxa²ha¹hẽ¹li¹. Nxa²ha¹ha²kxai³ a³li³a¹nũ²la² kxĩh³nxẽ¹na² wxa²yen³kxa² ũ³whĩ̱¹kxi²na¹hẽ³li¹. Nxe³sxã³ wxa²yen³kxai²na² ti¹na² yũ³ye¹nx2na³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nxa²ha¹te¹ a²wa³kxẽn³yah³lai²na² wãn³txi³kxai³lu¹: “Ko̱³nxe³thin¹khai¹nxi¹lxi¹. Ĩ³lxa³thin¹ti³he¹nx2nxa³lxi¹. Yain³txa² wa³kon³nxa³kxan²ti³ hãi¹sxã³ sa²so¹na¹ha²kxai³ yain³txa³ki³a² ũh³wĩ̱¹nxa³kxan²ti³ yain³txa² sa²so¹na¹ha²kxai³ nxe³na¹jut3su² ĩ²san¹ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nxĩ¹nha²kxai³ ĩh¹nxe³kxa²ya̱n³ti³ta̱³ txa²yen³kxa² tẽ³sxã³ a²nũ²a² ũ³yho³hi²ki³a² o²la³kxain¹tũ̱³ka̱³txa² kwa² ũ³hũ¹ai¹nxã³thai¹li¹? Nxĩn¹ke³la³te²kxai³ hã²wxãn³txa³ ĩ³xi²na¹tãu³a² txa²yen³kxai²na² ka³lxa¹ton³kxi³nũ³su² ũ³hũ¹xi²sa²hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jã¹nxa¹jau³su² nxa²ha¹te¹ txa²sa²wi³ha³lxi³ ã̱³lxah³lxin¹te² ĩ³nxai²na² nxe³jah³lxi³hẽ¹li¹. Ki³ka³na³ka³nat3sxã³ tẽ³ain¹kxa² sa²so¹kxi²txai¹nhẽ³li¹. Sa²so¹kxi²sxã³ jah¹la² ki³a² hxi²ka² hxan³sxã³ ki³ai²na² hxi²tẽ³nha²jah¹la² ũ³hũ¹txai¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nxe³sxã³ a²nũ²a² yen³kxi³nh²te²na² ãh¹ kãi²non³sxã³ yen³kxa² ũ³hũ¹nyhain¹tu¹wi¹. Nxe³sxã³ yen³kxih³khai¹nxe³tu¹wi¹. Yxãn¹ta¹ a²nũ²a² yen³kxi³txa²jah¹la² yen³kxa² jũ¹nxe² yũ³kxan²ti³ sa²so¹xi²hxa³txain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jã¹nxe³sxã³ jah¹lai²na² ĩ³la³thi¹nxa³jah¹lai²na² sa²kxai³lu² tẽ³sxã³ ha³lo²a² ka³nxah³ha²lu²on³ju³ta² ũ³sa²tã³ũ¹tain¹yah³lxi³hẽ¹li¹. A²nxe³tãu³a² ye³khãuh³lxa³thin¹ju³tan¹te²kxa³ya̱³lhu² kãin² ĩ³nã̱³nha²kxai³ kãin² wxi²ka³ta³ta³tha²kxai³ nxe³tu¹wi¹.” A²wa³kxẽn³yah³la² nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nxa²ha¹te¹ yan¹nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²tu¹wi¹. Nxe³sa²hĩ¹na¹ a³ka³nxi²sxã³ wa̱³li²na¹tu¹wi¹. Nxa¹kxai²nãn²tu̱³ oh³xan¹ta² nũ̱³ka̱³txa² tẽ³lĩ³xi²na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jã¹nxe³tãu³a¹ a²nũ²a² nũ̱³ka̱³txi³nãu³xai²na² a²yxo²ha³kxa¹ ã³yã³ki³nũn²kxi²sain¹tu¹wi¹. Nxe³te³na¹ ha³na³ka³lxi³ sa³wxe² ha³na³ka³lxi³ sa³wxe² ai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nxe³te³na¹ a²nũ²a²nãu³xai²na² yxo²ĩ²sain¹te²nãu³xa² wã²nxa³kxa² so¹sxã³ txa²wi¹lha²tãu³a² ũh³wxe³ai¹na¹ha²kxai³ a²wã³kon³tũ̱³ka̱³txa² txa²wã̱³tãu³a² ũh³wxe³ai¹na¹ha²kxai³ nxe³ai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nxa¹kxai²nãn²tu̱³ txa²wi¹lha²tãu³a² sa³wxe³te²nãu³xa² ĩ³ye³kxi²na¹tu¹wi¹. Nxe³na¹te³nah¹lxi¹: “Wxã³jah³lxi³hẽ¹li¹. Txa²wĩ³na² ĩ³wi¹lxon³kxi¹nx2ti³tu¹wi¹. A²wi¹lhĩ¹nu¹tai²kxai³ ha³lo²a² tah²ko³xa² ĩ³ye³hau³ko³ta¹hxai²ti³ai¹ti²tu³wi¹. Hĩ¹na² ko³xain²txi³ ũ³hũ¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nxe³sxã³ kxã³nxai³tã² heh³sa³hẽ¹li¹. Yxãn¹ta¹ yain³txa² ũ³hũ¹sah¹lxin¹tai¹ti²tu³wi¹. Ya̱³lxu²sa³ha²kxai³ ĩ³na²kxi³jau³xa² ũ³hũ¹sah¹lxin¹tai¹ti²tu³wi¹. Txa²ya̱n³ta³ yũ³sa²nxa³ha²kxai³ sxi²ha² ũ³hũ¹sah¹lxin¹tai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wã²la² txa²sa³ha²kxai³ wã²la² ũ³hũ¹sah¹lxin¹tai¹ti²tu³wi¹. Ĩ³ton³sa³ha²kxai³ wxã³sĩ²sah¹lxin¹tai¹ti²tu³wi¹. Sxi²ha² kan²thĩ³na² ũ³tĩ¹kxi²sai¹nha²kxai³ wxã³sĩ²sah¹lxin¹tai¹ti²tu³wi¹.” Nxe³na¹jau³su². Nxe²e³kxai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nxa²ha¹te¹ wi¹lhin¹te²nãu³xa² ĩ³wa²lũ³xi²sain¹tu¹wi¹. Nxe³sain¹te³nah¹lxi¹: “Txa²hxi²kan¹ta² Si³yxau³kah³lãi³. Ĩh¹nxe³hĩ¹nai³tã² nxe² ĩ²nxa²sĩ¹na¹lhai¹li¹? Heh³nxa²ha²kxai³ yain³txa² ũ³hũ¹nxa²sĩ¹na¹lhai¹li¹? Ya̱³lxu²nxa²ha²kxai³ ĩ³na²kxi³jau³xa² ũ³hũ¹nxa²sĩ¹na¹lhai¹li¹? ");
INSERT INTO nabNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wxa²ya̱³la² yũ²nxã²nxa³ha²kxai³ sxi²ha² ũ³hũ¹nxa²sĩn¹na¹lhai¹li¹? Wã²la² txa²nxa²ha²kxai³ wã²la² ũ³hũ¹nxa²sĩn¹na¹lhai¹li¹? ");
INSERT INTO nabNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ĩ³ton³nxa²ha²kxai³ wxã³sĩ²nxa²sĩn¹na¹lhai¹li¹? Sxi²ha² kan²thĩ³na² ũ³tĩ¹kxi¹nxain¹sĩ¹nha²kxai³ wxã³sĩ²nxa²sĩn¹na¹lhai¹li¹? Ĩh¹nxe³hĩ¹nai³tã² nxe²kãi³ũh¹nxa²sĩn¹na¹lhai¹li¹?” Nxe³sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nxa²ha¹te¹ ĩ³ye³kxai¹na¹tu¹wi¹. Nxai¹na¹te³nah¹lxi¹: “Wãn³txi³su² ĩ³ye³kxi¹nx2ta¹wi¹. Txa²sa³wi³ha³lxi³nãu³xa² kãi²nxa³kxan²ti³ wi¹kãi³ũ¹yhah³lxin¹kxai²nãn²tu̱³ wi¹kãi³ũh¹sah³lxi³nũ³nhĩ̱³nxa¹lxi¹.” ");
INSERT INTO nabNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nxe³nũ²la² a²wã̱³tãu³a² sa²wxe³si¹hai¹na¹te²nãu³xa² yxo²ĩ²sai¹nxa³te²nãu³xa² ĩ³ye³kxai¹na¹tu¹wi¹. Ĩ³ye³kxai¹na¹te³nah¹lxi¹: “Ã³waix3sah¹lxi³hẽ¹li¹. Ko̱³nxe³thin¹yah³lxi¹lxi¹. Ha³lo²ai²li² ha³nxe²a² i̱³ju³ta² ã²la² ãu¹la³kxi³ko³xai²na² a²ta³a²nãu³xa² ũ³sa²tã³kxi²si¹ju³ta³nũ³a² ũ³sa²tã³nx2tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kxãn³nxai³tã² heh³sa³ha²kxai³ hai³txi³ yain³txi³la³ ũ³hũ¹sah¹lxan³nxãn³tai¹ti²tu³wi¹. Ya̱³lxu²sa³ha²kxai³ ĩ³na²kxi²jau³xa² ũ³hũ¹sah¹lxan³nxãn³tai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Txa²ya̱n³ta³ yũ³sa²nxa³kxe³su² wxa²sxi²ha² ũ³hũ¹sah¹lxan³tai¹ti²tu³wi¹. Wã²la² txa²sa²ha²kxai³ wã²la² ũ³hũ¹sah¹lxan³tai¹ti²tu³wi¹. Ĩ³ton³ta̱³nxa² sxi²ha² kan²thĩ³na² ũ³tĩ¹kxi²sain¹ta̱³nxa² nxe³ha²kxai³ wxã³sĩ²sah²lxan³tai¹ti²tu³wi¹.” Nxai¹na¹jau³su² nxe² e³kxai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nxa²ha¹te¹ a²wã̱³tãu³a² sa²wxe³ai¹na¹tu̱³ka̱³txa² ĩ³wa²lũ³xi²sain¹tu¹wi¹. Nxe³sain¹te³nah¹lxi¹: “Txa²hxi²kan¹jah¹lãi³. Ĩh¹nxe³hĩ¹nai³tã² heh³nxa²ha²kxai³ ya̱³lxu¹nxa²ha²kxai³ a²ya̱n³ta² yũ³nxã²nxa³ha²kxai³ wã²la² txa²nxa²ha²kxai³ ĩ³ton³nxa²ha²kxai³ sxi²ha² kan²thĩ³na² ũ³tĩ¹kxi²nxai¹nha²kxai³ nxe³nxa²ju³tai²na² ĩ²nxa²sĩ¹na¹kxan²ti³ wi¹kãi³ũh¹nxa²sĩn¹nxa³lhai¹li¹?” Nxain¹jau³su² nxe² e³kxi²sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nxa²ha¹te¹ ĩ³wa²lũ³xai¹na¹tu¹wi¹. Nxe³ai¹na¹te³nah¹lxi¹: “Wãn³txi³su² ĩ³ye³kxi¹nx2ta¹wi¹. Txa²sa³wi³ha³lxi³nãu³a² wi¹kãi³ũh¹nx2tai¹nxa³kxai²nãn²tu̱³ wi¹kãi³ũh¹sah²lxan³tai¹ti²tu³wi¹.” Nxai¹na¹jau³su² nxe² e³kxai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","A²nxe³te²nãu³xai²na² sa²kxai³lu² ha³lo²a² ha³nxe² i̱³sa²tẽ³ju³ta² khãuh³lxa³ti³sa²tẽ³nhain¹tu¹wi¹. Nxe³yãn¹ta¹ wi¹lhin¹te²nãu³xai²na² sa²kxai³lu² ka³te̱³na² wi¹tãu³a¹ wi¹lhin¹sxã³ yxau²sa²tẽ³ain¹tu¹wi¹. Je³su²jah³lai²na² wãn³txa² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nxa²ha¹te¹ wãn³txai²na² e³hxa³ta³lun²nũ²la² a²sa³wi³ha³lxi³nãu³xa² ãh¹e³kxi²te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","— Ye³ha¹li¹ a³la²ni²tãu³a² Pas²kwa²nxe³je³nãu³wa³kxa² ya̱u³son³ye²tu¹wi¹. Nxe³tãu³a² hi³sa³ka³txa² ĩ³hxi²kĩ¹la³kxi²sxã³ ĩ³ya²lut1sain¹ju³ta³nũ³a² ã³yũ³sain¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². A²nxe³je³nãu³wa³kxa² Ju³te²a² nũ̱³ka̱³txa² ã³yã³ki³nũ²kxi¹xi²sxã³ kxã³nhxĩ¹nu¹ta²kxai³ Sũ̱³na² Si³yxau³tãu³a¹ nũ³kxũn³txi³ sa²hau³ko³tain¹ti³u³tu¹ta²kxai³ sa²wa²lho¹xi²sxã³ ain³kxi¹xi²te³lhxã³ o²la³kxain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nxe³ain¹ti̱³kxai³lu² wã³nxĩn¹ta² si³yxau³te²nãu³xai²na² a²nũ²a²nãu³xa² a²hxi²kan¹te²nãu³xai²na² nxe³sxã³ ã³yã³nũ²kxain¹ta¹hxai²hẽ¹la². Kai³fa²sah³la² sxi²han²tu̱³ wã³nxĩn¹ta² si³yxau³te²nãu³xa² a²hxi²kan¹khaix1jah¹la² sxi²ha² ã³yã³nũ²kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Je³su²jah³la² hãi³a² i³so¹si¹hain¹jau³su² ĩ³su²lhã³si¹hain¹jau³su² ã³yã³nũ²kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nxe³tãu³a² ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Pas²kwa²nxe³je³nãu³wa³kxa² o²la³kxi²ki̱³tãu³a² hãi¹nxã¹a³sah¹lxi³sã²lxi¹, a²nũ²a²nãu³xa² ã³nhe¹kxi²nẽ³lain¹kxa²ya̱n³txi³su¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nxa²ha¹te¹ Je³su²jah³la² Be³tãn²ya³thĩ³na² ã³nxai³ta¹hxai²hẽ¹la². A²sa³wi³ha³lxa² ã³si³tẽ³kxain¹ta¹hxai²hẽ¹la². Ã³nxai³sxã³ Si³mãu²ah³la² sxi²ha² sxi²lhot3ta¹hxai²hẽ¹la². A²nxe³jah¹la² Si³mãu²ah³lai²li² kxã³nhxĩ¹nai³tã² ĩ³ta³ka³txa² ka̱³lxã̱un³sxã³ khon³ta³kxi²nẽ³ka̱³txa² ĩ³ton³ta³kxi²ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² sxi²ha² sxi²lhot3ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","A²nxe³tãu³a² ã³wxe³sxã³ ĩ³yai³nain¹tãu³a² txu¹ha³ka³lxa² wi¹lũ³jau³xẽ¹na² a³la³bas²tro³ẽ¹na² a³lxi²khaix1tẽ³na² jũ¹lxi³tẽ³na² hxi²tẽ³nha²sxã³ ã³wxã³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ wi¹lũ³jau³xẽ¹na² wxa²nãu²lxi²sxã³ a²yau³xa² ũ³whi¹sai¹sxã³ ũ³nhe³kẽn¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nxe³ain¹ka³tu̱³ a²sa³wi³ha³lxi³nãu³xa² ĩ²ai¹nha²kxai³ ĩ³yxai¹hain¹sxã³ ĩ³ye³lain¹te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ wi¹lũ³jau³xa² kwa² hxa³kxi²nha²lxã²nãn³khi³ nxa¹nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","A²nxe³jau³xai²na² tẽ³sxã³ a²yo³ha²khai³xa² so¹kxi²ki̱³ke³la³te²kxai³ a²yo³khai³xa² kãin²kxe³su² a²nũ²a² yen³kxi³txa²tũ̱³ka̱³txa² ã³yxu¹nũ³ai¹nhĩ̱³ki̱³tã³li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² e³kxi²nyhain¹jau³xa² a³la³kxi²ha²kxai³ ĩ³ye³kxi²te³nah¹lxi¹: — Ta¹ka³lxa² ĩ³xa̱n³ta³kxah¹lxi³txa³lxi¹. Wi¹kãi³ũh¹sain¹na²li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A²nũ²a² yen³kxi³txa²tũ̱³ka̱³txa² yxau²sa²tẽ³kxi¹nx2tain¹na³li¹. Yxãn¹ta¹ Txai²na² yxau²sa²tẽ³ũh¹nx2ti³nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nxe³sxã³ jau³xai²na² wi¹lũ³yau³xa² txa²ne³ka² ũ³nhe³kẽn²kxi²sai¹nhĩ¹na¹ txa²nũ²a² ya³lu²na¹ju³tũ³su² ãu¹la³kxi²sain¹na²li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wãn³txi³su² e³kxi¹nx2ta¹wi¹. Sũ̱³na² wãn³txa² wi¹jau³xa² u²lxi³ ha³ta̱³nxe³tu¹wi¹. Yu̱h³xan¹ko³nãu³a² a²yxo²ha³kxa¹ ha³ta̱³nxe³tu¹wi¹. Nxe³tãu³a² txu¹hai²li² wi¹kãi³ũh¹sain¹ju³ta² te²yã¹nxe² u²lxi³ ha³ta̱³nxe³tu¹wi¹, sa²nẽn¹kxi²si¹jau³su¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nxa²ha¹te¹ a²sa³wi³ha³lxa² ã³nhai¹tũ¹nũn³te²na² Ju³tas² Is³ka³ri³o²jah³lai²na² sa²kxai³lu² wã³nxĩn¹ta² si³yxau³kxa³te²nãu³xa² ã³nxai³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³la² ã³yũ³nx2ta¹kxai²nãn²tu̱³ ĩh¹nxe² ũ³yho³hi²sah¹lxi³hĩ̱³nxãn¹ji¹wi¹? Ta¹hxai²hẽ¹la². Nxũ²la² pra²ta²ki³a² ũ³yho³hi²ki³a² hxi²ka²hxan³sxã³ ha¹li¹ ha¹li¹ wxa²sa²wa²la³kxi²sxã³ nxe³ki³nãu³xa² 30 nxe³ki³a² ũ³yho³hi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nxe³hĩ¹nãn¹te²tu̱³ Ju³tas² Is³ka³ri³o²jah³lai²na² hi²sen³kxai³lu² Je³su²jah³la² ã³yũ³ain¹si¹jau³nũ³su² o²la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nxe³nxa²ha¹te¹ Ju³te²a² nũ̱³ka̱³txai²na² yain³txa² wa³lo¹lo¹nxa³tũ̱³xai²na² ĩ³yai³nain¹to³ju³ta² ã³si³wxe³tãu³a¹ a²sa³wi³ha³lxai²na² ã³tĩ̱³sxã³ e³kxain¹te³nah¹lxi¹: — Yain³txa² wa³lo¹lo¹nxa³tũ̱³xai²na² yain³kxi²kxi³ju³ta² ĩh¹nu¹ãn¹thĩn³ta̱³ yain³kxi²thĩ³nũ³a² sa²hau³kot3sĩn¹te³la¹ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nxe³ha²kxai³ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Sxi²je³na² ã³nxai³jah¹lxi³hẽ¹li¹. Yxah³lxin¹kxai²nãn²tu̱³ in³txa² ĩ³ha¹jah¹lxin¹tu¹wi¹. Ĩ³ha¹jah³lxin¹kxai²nãn²tu̱³ ĩ³ye³kxi¹txain¹te³an¹jau³kxai³lu¹: “Txa²wã¹yah³la² wãn³txi³kxai³lu¹: ‘Ha³lo²a² ne³ka³ka³tã³li¹. Pas²kwa²nxe³je³nãu³wa³kxai²na² Txai²na² Txa²sa³wi³ha³lxa² nxe³sxã³ wxa²sxi²ha² ã³wxã³sxã³ yain³kxi²sĩ¹na¹tu¹wi¹.’ Nxe³sain¹na²li¹.” Nxe³tai¹nhẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nxe³nũ²la² Je³su²jah³lai²na² wãn³txa² sa²yxo²we¹thxa³tain¹ta¹hxai²hẽ¹la². Pas²kwa²nxe³je³nãu³wa³kxa² ãu¹la³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hã²wxãn³txa³ ka³nxa³hi²tãu³a² ã³wxe³ha²kxai³ a²sa³wi³ha³lxa² a²to²se³nxe³tũ̱³ka̱³txa² ã³wxe²xai³ai¹nha²kxai³ yain³yah³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yain³yah³lxi³tãu³ãn²tu̱³ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Wãn³txi³su² ĩ³ye³kxi¹nx2ta¹wi¹. Wxãi²nãu³ ĩ³nxa² ã³nhai¹tũ³te² ĩ³nxai²na² ko̱¹ko̱¹xa² hxi²ka²nãu³a¹ ã³yũ³sai¹nĩn¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nxa²ha¹te¹ a̱u³txi³ a²ẽ¹nãu³ai²na² kãin² ãin²tai¹nha²kxai³ ĩ³wã̱³wã̱³txi²te³nah¹lxi¹: — Txa²sũ̱³yah³lãi³. Txai²la³hĩ̱³na¹ji¹wi¹? Nxe²xai³lain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — A²yain³txi³nũ̱³xa² sa²so¹sxã³ yain³txi³yau³xa² ũ³hũ¹kxi²sai¹ya³sa²jah¹la² ka³na³ka³na³te² ĩ³nxai²na² ko̱¹ko̱¹xa² hxi²ka²nãu³a¹ ã³yũ³sain¹jah¹lo²su² na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ya²la³tu̱³ su²lhã³sain¹tu¹wi¹. Nxe³jau³xai²na² ũ³wha²li¹txã³nxu¹tai²na² nxe² ĩ³yau¹ũ¹nhẽ³ta¹hxai²hẽ¹li¹. Yxãn¹ta¹ ã³yũ³sain¹jah¹lai²na² sa²kxai³lu² ko̱³nxe³ton³khaix1jah¹lo²su² na³li¹. Hai³txi³ a³li³lah¹xa³sxã³ txo¹nxa³ke³la³te²kxai³ ã²la² wi¹lhĩ̱³nx2na³li¹, jah¹lo²su¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nxa²ha¹te¹ Ju³ta²sah³lai²na² ko̱¹ko̱¹xa² hxi²ka²nãu³a¹ ã³yũ³jah¹lai²na² sa²kxai³lu² ĩ³wã̱³txi³te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Txai²la³hĩ̱³nxãn¹ji¹wi¹? Ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Wxa²wãn³txa² e³in¹jau³xai²la¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nxa²ha¹te¹ yai³nain¹tãu³a² Je³su²jah³la² hi²sen³su² yain³tũ̱³xa² hxi²tẽ³sãn²nũ²la² Sũ̱³na² ĩ³wi¹lxon³kxi²si¹jau³xa² ĩ³ye³kxi²sãn²sxã³ wxa²nãu²lxi³sxã³ a²sa³wi³ha³lxa² ũ³hũ²xai³lain¹ta¹hxai²hẽ¹la². Ũ³hũ²xai³lain¹sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Yain³tũ̱³xai²li² Txa²nũ²ai²yã¹nx2na³li¹. So¹kxi²sa²sxã³ yain³jah¹lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nxe³nũ²la² ĩ³na²tẽ³na² hxi²tẽ³nha²nũ²la² Sũ̱³na² ĩ³wi¹lxon³kxi²si¹jau³xa² ĩ³ye³kxi²sxã³ ũ³hũ²xai³ain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Ĩ³na²xai³jxah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","A²nxe³jau³jau¹xai²na² Txa²ti³ha²yau³xai²yã¹nx2na³li¹. Wãn³txa² tah²yau³xa² ĩ³ye³kxi¹nx2ta¹jau³xai³jã¹nxe² kãi³ũh¹nx2ta¹jau³nũ³ai²la¹wi¹. A²nũ²a² ko̱³nxe³ti³ kãi³ju³ta² sa²wa²sut1si¹ha¹jau³nũ³su² Txa²ti³ha²yau³xa² ha³li³hxan³sa³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nxe³yãn¹ta¹ nxe³kxa²yã¹nxa¹ju³ta³ ĩ³na²kxi³jau³xa² wa³su³txi³ ĩ³na²xi²nxa³lho³li¹. Txa²wĩ³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²hĩ¹na¹ ĩ³na²xi²ki̱³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nxe³nxa²ha¹te¹ ĩ³yain³ta³lu²nain¹ni² ĩ³na²ta³lu²nain¹ni² nxain¹ka³tu̱³ ka³li³nhẽ³jau³xa² ĩ³hai³nain¹sãn²ka³tu̱³ wã³la³ka³txa² o³li³ve²ra³kat3su¹ nxe³hxai²na²hẽ³ nxe³ka³ka¹txai²na² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nxe³te³na¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxu¹tai²na² wãn³txa² nxe³te³nah¹lxi¹: “O³ve²a² nũ̱³ka̱³txa² a²wa³kxẽn³yah³la² ĩ³su²lhã³a¹tu¹wi¹. Na¹ha²kxai³ o³ve²a² nũ̱³ka̱³txai²na² sa²kxai³lu² ã³ni³sxã³ ĩ³ha³te¹ha³ten¹tain¹tu¹wi¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³jau³xai²yã¹nxe³kxi³hũ̱³nxe² hĩ¹na¹ ka³nxah³nxe³hĩ¹na¹ wxa²nũ̱³ka̱³txai²na² hãi¹nxe³ti³xa¹ ĩ³yãu²lxi¹nx2ti³tu¹wi¹, Txai²na²su¹. Nxe³sxã³ ã³waix3sxã³ ã³sxã³ ã³nih³sah¹lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nxe³yãn¹ta¹ hã²wxãn³txa³ ka³te̱n³su² ĩ³sa²yxau³xi²na¹ka³tu̱³ Ka³li³le²a²ko³xa²nãu³a¹ ã³ne³ka²ta¹nx2ta¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nxa²ha¹te¹ Pe²jah³la² a²wãn³txi³kxai³lu¹: — Kwa²nxi¹lxi¹. Ãu²li²sxã³ ã³nih²nxã²nxa³lho³li¹. A²nũ²a² ã̱³xa² ãu²li² hxa³nain¹kxan²ti³ txai²li² ti³he¹nxẽ²nxa³lho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wãn³txi³su² e³kxi¹nx2ta¹wi¹. Ka³nxah³tai²nãn²tu̱³ ka³la³ka³la²a² ĩ³yxai²lxoh³lxi²nxa³ta̱³lxa¹ wxãi²na² Pe²jah³lo² ĩ³nxai²na² sa²kxai³lu² ten³si¹sa²nxãn³jau³su² ye³ha¹li¹ ka³na³ki¹ ĩ³ye³kxi²xin¹tu¹wi¹. “Je³su²jah³la² ĩ²te²txã³wi¹.” Nxẽn¹jau³su² e³ye³kxi²xi¹nĩn¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nxe³yãn¹ta¹ Pe²jah³la² yxo²xũ̱n³txi³ ĩ³ye³kxi²te³nah¹lxi¹: — Ko¹ko¹su² ĩ³su²lhã³sain¹kxa²ha³ta̱³nxãn²ti³ hai³txi³ ten³si¹sa²nxãn³jau³su² ĩ³ye³ti³he¹nxe²nxa³lho³li¹. Pe²jah³la² ta¹hxai²hẽ¹la². Te²yã¹nxe³sxã³ a²sa³wi³ha³lxa² whãi²na¹ te²yã¹nxe² e³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nxa²ha¹te¹ Je³su²jah³la² a²sa³wi³ha³lxa² nxe³sxã³ ha³lo²a² Jet3se³ma³ni²ko³xa² ã³nxai³ain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Ti¹na² ã³wxe³sxã³ wah³nxe³sah¹lxi³hẽ¹li¹. Nũ¹a² ai³sxã³ Sũ̱³na² ĩ³ye³kxi²te³la¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nxe²e³nũ²la² sa³wi³ha³lxa² ha¹li¹ ka³na³ki¹ Pe²jah³lo¹na² Se³be³te²ah³la² a²ki³lha³nãu³xa² ã³sa²so¹ka³tu̱³ jũ¹nxe² yan¹nãu³a¹ ã³nxai³ain¹ta¹hxai²hẽ¹la². Nxe³tãu³a² ha³lo²a² ko̱³nxe³khaix1ju³ta³nũ³a² sa²te̱²txi³ ĩ³ãin²txi³ha²kxai³ hxi²waun³ta³txi² ĩ³ãin²txi³ha²kxai³ Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nxe³te³nah¹lxi¹: — Ãin²ti³ya³lu²te²hũ̱³sa³nhai¹. Ti¹na² ã³wxe³sxã³ wahx3nxe³sah¹lxi³hẽ¹li¹. Jũ¹nxe² yan¹nãu³a¹ ai¹na¹ka³tu̱³ Sũ̱³na² ĩ³ye³kxi²na¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nxe² e³kxi²nũ²la² jũ¹nxe² yan¹nãu³a² ã³nxai³sxã³ ã³kxu²thu²kxa² wxe³sxã³ Sũ̱³na² e³kxi²te³nah¹lxi¹: — Txa²wĩ³nãi³. A²yen³kxa² hãi¹nxe³ti³xa¹ hxi²kan¹te²si¹lxi¹. Nxe³ha²kxai³ a²ko̱³nxe³ju³tai²na² khãuh³lxa³ti³sa²ju³tai²na² sa²wa²tot1so¹kxi²sẽ¹li¹. Yxãn¹ta¹ ten³nxa²nxa³kxai²nãn²tu̱³ wxa²wãn³txa² so¹lxi³ sa²yxo²we¹txa²ti³ten³sa³nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nxe² e³ta³lun²nũ²la² a²sa³wi³ha³lxa² ã³wa̱³li²ka³tu̱³ a²yxo²ha³kxa¹ ãu²xi²yain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² sa²kxai³lu² Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Pe²jah³lãi³. Jũ¹nxe³ju³ta² he³la³ku³ hxi²kan¹txi³ ĩ³ye³ten³nha²sxã³ yxau³yah²lxan³ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ye³ten³nha²sxã³ yxau³jah¹lxi³sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹, ko̱³nxe³ju³ta³la³ ã³wih²kxi¹nxa²ti³kxa²ya̱n³ti³su¹. Wxa²ẽ¹nãu³a² a²wi¹ju³ta³la³ ten³khaix1yah³lxi¹lxi¹. Yxãn¹ta¹ wxa²sĩ̱³nai²na² sĩ̱³wi¹nx2ti³ju³ta³la³ hau³kon³yah³lxa³lxi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nxe³ka³tu̱³ jũ¹nxe² ã³waix3ti¹xi²nũ²la² Sũ̱³na² ĩ³ye³kxi²xi²te³nah¹lxi¹: — Wĩ³na² nxe³txi¹. Khãuh³lxa³ti³sa²ju³ta² hxi²kan¹txi³ sa²wa²tot1so¹kxi²sa²nxa³kxai²nãn²tu̱³ a²yen³kxa² ten³nxa²ju³ta² so¹lxi³ ten³sa³nhai¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nxe²e³ta³lun²nũ²la² a²sa³wi³ha³lxa² ã³wa̱³li²xi²ta¹hxai²hẽ¹la². Yxãn¹ta¹ ãu³xain¹to³ta¹hxai²hẽ¹la², hxi²kan¹sxã³ ye³ten³nha²sxã³ yxau³ai¹nxa³ha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jã¹nxe³sxã³ ã³waix3ti¹xi²nũ²la² Sũ̱³na² wãn³txain²txi³ ĩ³ye³kxi²xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hã²wxãn³txa³ wa̱³li²xi²ka³tu̱³ ĩ³ye³kxi²te³nah¹lxi¹: — Ãu³xi²sxã³ ĩ³ye¹nxi²sa²tẽ³ye²yah³lxin¹ta²lu¹wi¹. Hãi¹nxo¹nha¹jah³lxi³sã²nhẽ³li¹. Ha³lo²a² hau³kon³na³li¹. Hĩ¹nai²na² ko̱³nxe³thin¹te² hxi²ka²nãu³a² ã³yũ³sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ĩ³sa²yxau³sxã³ ã³nxai³ya³sah¹lxi³wxi¹. Ã³yã³yũ³sa²jah¹lo²su² te²a² ya̱u³son³nẽ³na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nxe³nxa²ha¹te¹ ĩ³ye³ta³lun²nxa³ta̱³lxa¹ a²sa³wi³ha³lxa² ã³nhai¹tũ³jah¹la² ka³na³ka³na³te²a² Ju³ta²sah³lo²kxai³lu² ã³tĩ̱³ta¹hxai²hẽ¹la². Ã³tĩ̱³te³na¹ wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txa² a²nũ²a² hxi²kan¹te²nãu³xa² nxe³sxã³ a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² ĩ³sa²si¹hã³ai¹nha²kxai³ Ju³ta²sah³la² ã³si³tẽ³la³kxain¹ta¹hxai²hẽ¹la². Yu̱³la² kãin²te²su² te²na² tẽ³lxi² hi³ki²a³li³su² te²na² tẽ³lxi² nxẽn³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jã¹nxe³ju³kxai³lu² a²kxã³nxai³tã² ã³yũ³so¹jah¹la² ĩ³ye³kxi²nyhain¹ta¹hxai²hẽ¹la². Nyhain¹te³nah¹lxi¹: — In³txa² ĩ³yxo²sai¹la³kxi²na¹tu¹wi¹. Nxe³na¹te²a² kan²txi³ i³sxã³ sa²so¹jah¹lxi³hẽ¹li¹. Ju³ta²sah³la² a²kxã³nxai³tã² nxẽn³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jã¹nxe³ju³kxai³lu² Ju³ta²sah³lai²na² sa²kxai³lu² Je³su²jah³la² ã³tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Nxe³nũ²la² ĩ³yxo²sai¹la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²ya̱³lxãi³. A²ten³nxa²ju³ta² kãi³sẽ¹li¹. Nxe² e³ta³lun²nũ²la² ko̱¹ko̱¹xa² nũ̱³ka̱³txi³nãu³xai²na² ã³tĩ̱³sxã³ i³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nxa²ha¹te¹ Je³su²jah³la² sa³wi³ha³lxa² ka³na³ka³na³te²nãn²tu̱³ yu̱³la² kãin²ta³wxi²a² hxi²tẽ³nha¹nxa²ha¹te¹ wã³nxĩn¹te² si³yxau³kah³lai²na² sa³wi³sa² ĩ³su²ta¹hxai²hẽ¹la². Ĩ³su²te³na¹ a²ne³nxẽ³na² ũ³nhe³i²lã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Yu̱³lai²li² ũ³whi²xi¹sẽ¹li¹. Nxe³jut3su² a²nũ²a² ĩ²li³te²a² yu̱³la² tẽ³sxã³ ĩ³su²lhã³kxai²nãn²tu̱³ nxe³jah¹lain²txi³ yu̱³la² ĩ³su²lhã³ain¹nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Jã¹nxa¹jut3su² ten³sa³kxai²nãn²tu̱³ Txa²wĩ³na² ã³non²ta³kxi²sa²hĩ̱³nx2na³li¹. Oh³nãn¹ta³ nũ̱³ka̱³txa² wa̱³li̱³kha³lhon¹tũ̱³ka̱³txa² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²wa²la³kxi² nxe³tũ̱³ka̱³txi³kxi³nãu¹xa² ĩ³sa²si¹hã³sxã³ ã³non²ta³kxi²sai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yxãn¹ta¹ Sũ̱³na² ũ³wha²li¹txã³nxu¹tai²na² a²wãn³txa² yã¹nxe² kãi³ye²na¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jã¹nxe³tãu³a² tũ̱¹ka̱³txi³nãu³xa² ãh¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Hi³sa³ka³txa² hi³ki²a³la² tẽ³sxã³ wxã³yah³lxin¹ti²ti¹. A²nũ²ai²na² yen³kxa² kãi³kxi²jah¹la² i³sxã³ sa²so¹kxa²yã¹nxe² i³sxã³ sa²so¹sah¹lxin¹ta²lu¹wi¹. A³lan²ta² hãi¹nxe² Sũ̱³na² sxi²ha² ã³wxe³sxã³ wãn³txa² wi¹jau³xa² ĩ³yau¹ũ¹nx2ta¹tai¹ti²tu³wi¹. Nxe³na¹tãu³ai³tã² i³sxã³ sa²so¹sah¹lxan³tai¹ti²ti¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yxãn¹ta¹ Sũ̱³na² ũ³wha²li¹txã³nxu¹tai²na² we¹ta³lun²si¹jau³su² kãi³ũ¹sah³lxi¹lxi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². Nxe³nũ²la² Je³su²jah³la² sa³wi³ha³lxi³nãu³xa² a²yxo²ha³kxa¹ ã³waix3sxã³ ih³sau³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nxa²ha¹te¹ a²nũ²a²nãu³xai²na² Je³su²jah³la² i³sxã³ sa²so¹nũ̱³ka̱³txa² wã³nxĩn¹te² si³yxau³kah³la² Kai³fa²sah³la² sxi²ha² ã³sa²so¹ain¹ta¹hxai²hẽ¹la². A²nxe³thĩ³na² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txi³su² te²na² a²nũ²a² hxi²kan¹txi³nãu³su² te²na² nxe³sxã³ a²kxã³nxa² ã³nũ¹nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nxe³yãn¹ta¹ Pe²jah³la² hi²sen³kxai³lu² u²lxi³ ĩ³hit1xai³ta¹hxai²hẽ¹la². Ai³lhxã³ Kai³fa²sah³la² sxi²ha² wai²ha² yxo²tã̱³lxa² ã³wih¹ka³tu̱³ so³ta²to²nãu³xa² ã³wxe³ye²ta¹hxai²hẽ¹la². Je³su²jah³la² kãi³ũ¹nyhain¹kxi³nũ³su² ã³wxe³sa³wah³nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nxe³ti̱³kxai³lu² wã³nxĩn¹ta² hxi²kan¹te²nãu³xai²na² sa²kxai³lu² hxi²kan¹ta² a²nũ²kxi²tũ̱³ka̱³txai²na² sa²kxai³lu² a̱in³nhain¹ta¹hxai²hẽ¹la². Je³su²jah³lai²na² ĩ³su²lhã³ain¹si¹hain¹jau³su² a̱in³nhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yxãn¹ta¹ hxi²kan¹ti³ a̱in³nha²ti³he¹xain¹ta¹hxai²nxa³hẽ¹la². A²nũ²a² ka³lxa¹txi³ wãn³txa² ki³han³jau³xa² Je³su²jah³la² ĩ³ye³ki³ha¹kxain¹kxan²ti³ a̱in³nha²ti³he¹xain¹ta¹hxai²nxa³hẽ¹la². Nxe³nũ²la² in³txa² ha¹li¹ wxã³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Wxã³sxã³ ĩ³ye³ya³te³nah¹lxi¹: — Je³su²jah³lai²na² wãn³txa² ain³kxi²sĩ¹na¹hẽ³li¹. Nxe³sxã³ ain³kxi²sĩ¹na¹te³nah¹lxi¹: “Hxi²kan¹txi³ Txa²wã¹sũ̱³na² sxi²ha² sa²nai¹a¹kxai²nãn²tu̱³ hã²wxãn³txa³ ye³ha¹li¹ ka³na³ki¹ a³lan²tãu³a² ũ³txo³nxi²na¹tu¹wi¹.” Nxe³jau³xai²li² ain³kxi²sĩ¹na¹hẽ³li¹. In³txai²li² nxe³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nxa²ha¹te¹ wã³nxĩn¹te²nãu³xa² a²hxi²kan¹jah¹lai²na² sa²kxai³lu² ĩ³sa²yxau³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Jau³jau¹xai²na² ĩ³wa²lũ³xi²nxãn³ji¹wi¹? Ĩh¹nxe³jau³ta̱³ ko̱³te³kxi²nxain¹thi²li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nxe³yãn¹ta¹ Je³su²jah³lo²kxai³lu² ka³nahx2nxe³sxã³ yxau³ta¹hxai²hẽ¹la². Nxe³te³na¹ wã³nxĩn¹te²nãu³xa² a²hxi²kan¹jah¹lai²na² a²wãn³txi³kxai³lu¹: — E³lxah¹ ĩ³yau¹ũ³sa²sĩ¹nhẽ³li¹. Sũ̱³na² Si³yxau³jah¹la² ĩ²nẽ³lha²kxai³ ya²la³tu̱³ ĩ³yau¹ũ³sa²sĩ¹nhẽ³li¹. Sũ̱³na² Ta²nhĩn¹ji¹wi¹? Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3txa²jah¹lo²sin¹ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wain³na³li¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹. Yxãn¹ta¹ wãn³txi³su² e³kxi¹nx2ta¹wi¹. Ye³jen¹na² yan¹nãu³a¹ ĩ²sah¹lxin¹tu¹wi¹. Txa²wã¹sũ̱³na² Si³yxau³kah³lai²na² a²wi¹tãu³a² wxi²kin³ti³ton³ti³hit1sain¹sxã³ ã³wxe³na¹ha²kxai³ oh³sĩ̱³nãu³a² wxa²kan³sxã³ wa̱³li²na¹ha²kxai³ nxe³na¹ju³ta² ĩ²sah¹lxin¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nxe³jau³xai²na² sa²kxai³lu² wã³nxĩn¹te²nãu³xa² a²hxi²kan¹jah¹la² ain³kxi²te³na¹ a²ha³la³se³nãn¹ka³lo³khai³xa² sa²ten²txi³ta¹hxai²hẽ¹la². Sa²ten²txi³te³nah¹lxi¹: — Txa²wã¹sũ̱³na² ko̱³nxe³te²lo³tain¹na³li¹. Hãi¹nxã¹a³sah¹lxi³wxi¹. Wxãn³txai²li² Sũ̱³na² ko̱³nxe³te²lo³jau³xai²na² ain³kxi²ki̱³ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nxe³ki̱³sa²kxai³ ĩh¹nxe³ki̱³te³ji¹wi¹? Ta¹hxai²hẽ¹la². Nxe³ha²kxai³ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Su²lhã³ain¹ju³ta² so¹lxi³ wain³na³li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nxain¹ka³tu̱³ a²nũ²a² ĩ²li³te² hi²sen³kxai³lu² ĩ³ye³ka³su³hẽn¹kxi²ha²kxai³ a²hxi²kai²na² ĩ³su²lai¹nha²kxai³ ĩ³wai¹tha²kxai³ nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nxe³ain¹te³nah¹lxi¹: — Wxãi²li² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3txa²jah¹lo²sin¹ke³la³te²kxai³ ĩ³su²nxa²jah¹la² ĩ³yau¹ũ³sa²sĩ¹nhẽ³li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nxe³ain¹ti̱³kxai³lu² Pe²jah³lai²na² sa²kxai³lu² sxi²ha² wai²ha² yxo²tã̱³lxa² ã³wih¹sxã³ ã³yxo²wxe³ta¹hxai²hẽ¹la². Nxe³tãu³ãn²tu̱³ti¹ wã³nxĩn¹jah¹lai²na² sa³wi³sa³ka³lxi³na² ã³tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Wxãi²li² Je³su²jah³la² ka³li³le²a²ko³xan¹jah¹la² ã³si³tẽ³kxai¹nũ³nĩn¹tai¹tu³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nxe³nxa²ha¹te¹ ĩ³ki³ha¹kxi²jau³su² ĩ³wa²lũ³xi²te³nah¹lxi¹. Pe²jah³lai²na² wãn³txi³kxai³lu¹: — Jau¹xai²na² ko̱³nha²nxa³nhĩ¹. Ĩ²te²txã³xĩ¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hã²wxãn³txa³ sxi²ha² wai²ha² yxo²tã̱³lxa² a³li³xi²te³na¹ a²sa³wi³sa³ka³lxa² ã̱³xa³ka³lxa² ĩ²kxain¹ta¹hxai²hẽ¹la². Ĩ²kxain¹sxã³ a²nũ²a² kwa² yxau²xai³ain¹te²na² ĩ³ye³kxi²te³nah¹lxi¹: — Jah¹lai²na² sa²kxai³lu² Je³su²jah³la² Na³sa³re²thĩ³nãn¹jah¹la² ã³si³tẽ³kxi²na²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jã¹nxa²ha¹te¹ ĩ³ki³ha¹kxi²jau³su² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Jah¹lai²li² ĩ²a¹jah¹lo²su² te²txã³xĩ¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jũ¹nxe² ye³je¹na¹ kwa² yxau²xai³te²nãu³xa² ã³tĩ̱³ain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³la² a²sa³wit3su² ta²lu¹wi¹. Jah¹la² yxo²wãn³txa² e³kxa²yã¹nxe² e³i¹lxi¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nxe²e³tãu³a² Pe²jah³lai²na² sa²kxai³lu² yxo²a̱n³ta³ti³ ĩ³ki³ha¹kxain¹te³nah¹lxi¹: — Jah¹la² ĩ³ye³kxah²lxin¹kxah³lai²na² ĩ²ti³hex1te²txã³wi¹. Txa²wãn³txai²na² e³a¹jau³xai²na² Txa²wã¹sũ̱³na² wi¹lain³kxi²sain¹na³li¹. Ki³ha¹kxi¹nx2ta¹ke³la³te²kxai³ a̱n³txi³ju³ta² ũ³hũ¹sai¹nhĩ̱³nx2na³li¹. Pe²jah³la² ta¹hxai²hẽ¹la². Nxe²e³ta³lun²tãu³ ka³la³ka³la²a² ĩ³yxai²lxoh³lxi²xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nxe³ka³tu̱³ Je³su²jah³lai²na² wãn³txin³txi² ain³kxi²xi²ta¹hxai²hẽ¹la². Ain³kxi²xi²ti³an¹jau³kxai³lu¹: — Ka³la³ka³la²a² ĩ³yxai²lxoh³lxi²xi²nxa³ta̱³lxa¹ wxãi²na² Pe²jah³lo³ ĩ³nxai²na² sa²kxai³lu² ye³ha¹li¹ ka³na³ki¹ ten³si¹sa²nxãn³jau³nũ³su² ĩ³ye³kxi²xin¹tu¹wi¹. Ha³la³je¹nai³tã² Je³su²jah³lai²na² wãn³txa² ta¹hxai²hẽ¹la². Nxe³jau³xai²na² Pe²jah³lai²na² ain³kxi²xi²ka³tu̱³ ha³lo²a² a³li³sxã³ kãin² ĩ³nã̱n³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nxa²ha¹te¹ a²ka³nxa³ha²ta³kxai³lu¹ wã³nxĩn¹te² si³yxau³ka³ta²nãu³xa² a²nũ²a² a²hxi²kan¹te²nãu³xa² nxe³sxã³ ã³sa²ki³nũ²kxain¹ta¹hxai²hẽ¹la². Je³su²jah³la² ĩ³su²lhã³si¹hain¹jau³su² a̱in³nha²sxã³ nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A̱in³nha²ta³lun²nũ²la² sa²hxi²tai³kxi²sxã³ tẽ³sxã³ ãn³sa²so¹sxã³ ha³lo²a² wa³kxẽn³yah³la² Pi³la²jah³lo²su² ha²kxai³ a²hxi²ka² ã³yũ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nxa²ha¹te¹ Ju³ta²sah³lai²na² ko̱¹ko̱¹xa²hxi²ka³nãu³a² ã³yũ³ain¹jah¹lai²na² sa²kxai³lu² ha³lo²a² yxau³sxã³ ten³sa²tã³ta¹hxai²hẽ¹la². Je³su²jah³la² ya³lu²si¹hain¹jau³su² ĩ²ha²kxai³ ĩ³ãin²ta³kxi²ta¹hxai²hẽ¹la². Ĩ³ãin²ta³kxi²ha²kxai³ ũ³yho³hain¹ki³ai³tã² hxi²tẽ³nha²nũ²la² wã³nxĩn¹ta² si³yxau³ka³ta²nãu³xa² a²nũ²a² a²hxi²kan¹txi³nãu³xa² nxe³sxã³ tũ̱¹ka̱³txai²na² ũ³hũ¹xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ũ³hũ¹xi²te³ãn¹jau³kxai³lu¹: — Ko̱³nxe³ti³ kãi³a¹hẽ³li¹. A²nũ²a² hxi²ki³la³nxa³te²na² ĩ³ki³ha¹kxi²sxã³ ã³yũ³nx2tai¹na¹hẽ³li¹. Ta¹hxai²hẽ¹la². Nxe³yãn¹ta¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Txa²ha³lo²sxa³wi¹. Nũ¹hĩ²txa²hẽ³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nxe³ka³tu̱³ ũ³yho³hi²ki³ai²na² tẽ³sxã³ Txa²wã¹sũ̱³na² sxi²hẽ¹na² ã³na¹ka³tu̱³ a³li³ta¹hxai²hẽ¹la². A³li³nũ²la² ne³kxe³kxi²nha²te³nah¹lxi¹: — Ya²lu²na¹tũ¹xã¹. Nxe³jau³tu̱³ tĩh³na² a³lo³xĩh³na² tẽ³nha²sxã³ sa²yxe²ta³tai²kxi²nha²sxã³ ha³lo²a² kĩ³ju³ta² a³li²sin³sxã³ sa²ya²lu¹nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nxa²ha¹te¹ wã³nxĩn¹ta² si³yxau³ka³ta²nãu³xa² ũ³yho³hi²ki³ai²na² tẽ³nyhain¹te³nah¹lxi¹: — Ĩh¹nxe³ki̱³thon³ku² ki̱³nhai¹. Ũ³yho³hi²ki³ai²na² sa²kxai³lu² Sũ̱³na² sxi²ha² ũ³ha¹sxã³ wxe³kxi²ki̱³kxe³su² wai³nhĩ̱³nx2nxa³wi¹. A²nũ²a² su²lhã³kxa² ũ³yho³hi²ki³ai²la¹wi¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nxe² e³kxi²ta³lun²nyhain¹nũ²la² ha³lo²a² kwa³ta³la² we¹jah¹la² ha³lo²ai²na² so¹kxain¹ta¹hxai²hẽ¹la². A²nxe³ko³nãu³a¹ a²nũ²a² wa³nũt3jah³la² wxã³kxai²nãn²tu̱³ kwa²hãi¹nxe² ya³lu²kxai²nãn²tu̱³ a²nxe³ko¹xai²na² sa²nĩ̱³kxi²ko³su² te²ju²hẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jã¹nxe³jut3su² ko¹xai²na² sa²kxai³lu² tih³yau³xan¹ko³su¹ nxe² ĩ³lxi¹kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","A²nxe³ju³tai²na² sa²kxai³lu² kxã³nhxĩ¹nu¹tai²nãn¹jau³xa² we¹ta³lun²ta¹hxai²hẽ¹la². Nxe³sxã³ Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lu¹tai²na² Je³re³mi²ah³lu¹tai²na² wãn³txa² ũ³wha²li¹te³nah¹lxi¹: — Ũ³yho³hi²ki̱³ki³a² hxi²ka² hxan³sxã³ ye³ha¹li¹ ka³na³ki¹ wxa²sa²wa²la³kxi²sxã³ nxe³ki³ai²na² sa²kxai³lu² 30 nxe³ki³ai²na² sa²kxai³lu² a²nũ²a² ũ³yho³hi²kxe³su² na³li¹. A²nxe³sxã³ I³sa³e² sa³wi³ha³lxa² nxe²hau³ko³tain¹na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nxe³kxai²nãn²tu̱³ kwa³ta³la² we¹jah¹lai²na² ha³lo²a² so¹kxain¹na²hẽ³li¹. Nxe³ju³tai²na² Sũ̱³na²kxai³lu² nxe³ ĩ³yau¹ũ³sa³na²hẽ³li¹. Je³re³mi²ah³lu¹tai²na² wãn³txa² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nxa²ha¹te¹ Pi³la²jah³la² yen³nãu³a² Je³su²jah³la² ã³yũ³ain¹ta¹hxai²hẽ¹la². Nxe³sxã³ Pi³la²jah³la² ĩ³wã̱³txi³te³nah¹lxi¹: — Ju³te²a² nũ̱³ka̱³txa² Si³yxau³jah¹lo²sin¹ji¹wi¹? Ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wxa²wãn³txai²na² wain³na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nxe³ka³tu̱³ wã³nxĩn¹ta³ si³yxau³ka³ta²nãu³xa² a²nũ²a² a²hxi²kan¹ti³nãu³xa² nxe³sxã³ ko̱³nxe³ti³hit1si¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Nxain¹kxan²ti³ ka³nahx1sxã³ yxau³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nxa²ha¹te¹ Pi³la²jah³lai²na² wãn³txi³kxai³lu¹: — Wãn³txa² ka³lxa¹txi³ ko̱³nxe³ti³hit1nxain¹jau³su² e³kxain¹na²li¹. Ain³kxi²nhãn²nxãn³ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nxe³yãn¹ta¹ wãn³txi³la³ yau³ka³na³ka³na³kxan²ti³ hai³txi³ ĩ³wa²lũ³xi²ta¹hxai²nxa³hẽ¹la². Nxe³ju³tai²li² Pi³la²jah³lu¹ta²kxai³lu² ĩ²nũ²la² ĩ³wã̱³wã̱³txi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nxa²ha¹te¹ Pas²kwa²nxe³je³nãu³wa³kxa² nxe²xai³ti³wa³kxa² ha³lo²a² wa³kxẽn³yah³la² te²hi²sen³su² nxe² kãi³ũ¹hain¹ta¹hxai²hẽ¹la². A²nũ²ai²na² sxi²ha² kan²thĩ³na² ũ³tĩ̱¹kxi²wxe³te²na² ĩ³lxi²te²na² ka³na³ka³na³jah¹lan²tu̱³ than²kxi²sa²tã³ũ¹nyhain¹to³ta¹hxai²hẽ¹la². Ju³te²a² nũ̱³ka̱³txai²na² te³nain¹kxah³lo²su² jah¹la² than²kxi²sa²tã³ũ¹nyhain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nxe³ju³ta² sa²kxai³lu² in³txa² ko̱³nxe³thin¹khaix1jah¹la² Ba³ra³ba²sah³la²kxai³lu² tĩ̱¹kxi²wxe³ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² sa²kxai³lu² a²nũ²a²nãu³xai²na² a²yxo²ha³kxa¹ ĩ²ain¹jah¹lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nxe³nxa²ha¹te¹ Ju³te²a² nũ̱³ka̱³txi³nãu³xa² ã³yã³sa²kxi³nũ²kxain¹tãu³ãn²tu̱³ Pi³la²jah³lai²na² a²yxo²wãn³txa² ĩ³ye³kxi²te³nah¹lxi¹: — In³txa² ka³na³ka³na³te²a² than²kxi²sa²tã³ũ¹hain¹to³hxai²na¹hẽ³li¹. Jã¹nxa¹tu¹wi¹. Nxe³na¹ha²kxai³ in³txa² ha¹li¹ tĩ̱¹kxa²wxe³yain¹na³li¹. Nxe³na¹jut3su² ĩh¹jah¹lo²ta̱³ than²kxi²sa²tã³ũ¹te³la¹ji¹wi¹? Ba³ra³ba²sah³lo²su² ta̱³nxa² Je³su²jah³la² txa²wã¹ha³lo²a² si³yxau³jah¹lo²ye²kxi³jah¹la² ta̱³nxa² ĩ³yau¹ũ³sah¹lxi³hẽ¹li¹. Pi³la²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nxe³sxã³ Pi³la²jah³la² a²ẽ¹nãn¹jau³kxai³lu¹: — Je³su²jah³la² wã³nxĩn¹sxã³ o²la³kxi²ha²kxai³ ka³tã³khai¹xain¹nha²kxai³ ã³yũ³nyhain¹na²na¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jã¹nxe³ti̱³kxai³lu² a²hxi²kan¹jah³la² ã³wxe³ka³lo³a² ã³wxe³tãu³ãn²tu̱³ Pi³la²jah³lai²na² sxe³xa³ka³lxa² ĩ³sa²si¹hã³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Jah¹lai²li² Je³su²jah³lai²li² wi¹lhin¹khaix1jah¹lo²sin²tai¹. Ka³nxah³ti³na² nxe²hxi²sxã³nhot3sa³hẽ²li¹. Nxe³sa³ha²kxai³ ko̱³nxe³ ĩ³yĩ¹lain¹ju³ta³nũ³a² kãi³txa³hẽ¹li¹. Ko̱³nxe³ti³ ĩ³yĩ¹lai¹nĩn¹kxa²ya̱n³txi³su² hxi²waun³txi³khaix1sa³hẽ²li¹. A²sxe³xa³ka³lxa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nxe³to³ta¹ wã³nxĩn¹ta² si³yxau³ka³ta²nãu³xa² a²nũ²a² hxi²kan¹txi³nãu³xa² nxe³sxã³ a²nũ²a² nũ̱³ka̱³txa² ĩ³ye³kxain¹te³nah¹lxi¹: — Ba³ra³ba²sah³la² so¹lxi³ than²kxi²sa²tã³ũ¹nhe³lhi¹hain¹jau³su² ĩ³wã̱³txi³sain³txain¹yah¹lxi³sĩ¹nhẽ³li¹. Yah³lxi¹nha²kxai³ Je³su²jah³la² ĩ³su²lhã³si¹hain¹jau³su² e³kxi¹txain¹yah³lxi³hẽ¹li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jã¹nxe³ju³kxai³lu² Pi³la²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — In³txa² ha¹lin¹te²a² ĩh¹jah¹lo²ta̱³ than²kxi²sa²tã³ũ¹te³la¹ji¹wi¹? Ta¹hxai²hẽ¹la². Nxe³ha²kxai³lu¹: — Ba³ra³ba²sah³la² so¹lxi³ than²kxi²sa²tã³ũ¹txai¹nhẽ³li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nxa²ha¹te¹ Pi³la²jah³lai²na² a²wãn³txi³kxai³lu²: — Nxe³na¹kxai²nãn²tu̱³ Je³su²jah³la² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹la² ye²yah³lxin¹kxe³su² nxe³jah¹lai²na² sa²kxai³lu² ĩh¹nxe² kãi³ũ¹ha¹ju³ta³nũ³a² ten³yah³lxin¹ji¹wi¹? Ta¹hxai²hẽ¹la². Nxe³ha²kxai³: — Hi³sa³ka³txa² ũ³hxi²kĩ¹la³kxi²sxã³ su²lhã³txai¹nhẽ³li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nxa²ha¹te¹ Pi³la²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ĩh¹nxe² ko̱³nxe³thin¹sxã³ kãi³lhai¹li¹? Nxe³jau³su² ha²kxai³ ã²la² yxo²xũn³txi³ ĩ³kaix1txain¹te³nah¹lxi¹: — Kwa²nxi¹lxi¹. Hi³sa³ka³txa² ũ³hxi²kĩ¹la³kxi²txai¹nhẽ³li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nxe³ka³tu̱³ hxi²kan¹txi³ wãn³txa² ĩ³wa²li²si¹hai¹nxa³kxe³su² a³la³kxi²ha²kxai³ hãi¹sxã³ kwa²he¹kxi²si¹nyhain¹jau³nũ³su² a³la³kxi²ha²kxai³ Pi³la²jah³lo²nu¹ta²kxai³lu² hãi¹nxã¹ta¹hxai²hẽ¹la². Ĩ̱³yau³xẽ¹na² tẽ³nũ²la² a²nũ²a² nũ̱³ka̱³txa² a²yen³nãu³a² hxi²khai²lxi²ye²ta¹hxai²hẽ¹la². Hxi²khai²lxi²ye²te³nah¹lxi¹: — Jah¹lai²na² ko̱³nxe³thin¹jah¹lo²sxa³wi¹. Su²lhã³kxe³ju³ta² hxi²ki³la³te²la²nxa³wi¹. Nũh¹ĩ²txain¹yah³lxi³hẽ¹li¹. Pi³la²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nxa²ha¹te¹ a²nũ²a² nũ̱³ka̱³txai²na² a²wãn³txi³kxai³lu¹: — Txa²nũ̱³ka̱³txi³na¹xai²na² so¹lxi³ txa²wẽ³ha³lxi³na¹xai²na² so¹lxi³ jah¹lai²na² su²lhã³kxa² hxi²ki³te²la³sĩ¹na¹wi¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nxe³te³na¹ Ba³ra³ba²sah³la² than²kxi²sa²tã³ũ¹nyhain¹ta¹hxai²hẽ¹la². Te²yã¹nxe³sxã³ so³ta²to² hxi²ka²nãu³a² Je³su²jah³la² ĩ³ta³lo³wait1si¹sãn²nũ²la² hi³sa³ka³txa² ũ³hxi²kĩ¹la³kxi²si¹hain¹jau³su² ã³yũ³nyhai¹nha²kxai³ Pi³la²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nxa²ha¹te¹ Pi³la²jah³lai²na² a²so³ta²to² nũ̱³ka̱³txa² hi²sen³su² Prai³a³to²ri³ã²thĩ³na² Je³su²jah³la² sa²so¹ain¹ta¹hxai²hẽ¹la². Nxe³sxã³ so³ta²to² nũ̱³ka̱³txa² a²yxo²ha³kxa¹ ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². Ã³tĩ̱³ain¹sxã³ ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Je³su²jah³lai²li² ĩ³ka³lxi¹lha¹sah¹lxi³wxi¹. Ko̱³nxe³ti³ kãi³ũ¹sxã³ wã²la² sau¹saun¹ka³lo³a² ũ³whi²kxi² wai³la² wxa²xu³kxi²sxã³ ũ³nhe³hẽn¹txi² nxe³ya³sah¹lxi³wxi¹. So³ta²to² nũ̱³ka̱³txa² nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nxe³te³na¹ Je³su²jah³la² a²wã²la³ka³lo³a² sa²sai¹kxi²sãn²nũ²la² wã²la²ka³lo³a² sau¹saun¹ka³lo³a² tẽ³sxã³ Je³su²jah³lan²tu̱³ ũ³whi²kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Wai³la² wxa²xu³kxain¹sxã³ ũ³nhe³hẽn¹tai¹nha²kxai³ hi³sa³ka³txa² wẽ³sa² wxi²kan¹kat3sũ̱³ka³txa² hxi²ka² wi¹tãu³a² ũ³hxi²wxe³kxi²nha²ha²kxai³ a²ne³kxai³tãu³a² ã³ka³ti³wxe³kxain¹nha²kxai³ ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Wi¹lhin¹te²si¹lxi¹. Ju³te²a² nũ̱³ka̱³txa² A²hxi²kan¹ta² Si³yxau³jah¹lo²si¹lxi¹. Ta¹hxai²hẽ¹la². Nxain¹jau³su² nxe² ĩ³wai³ka³si³xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nxe³nũ²la² ĩ³ye³ka³su³hẽn¹kxai¹nha²kxai³ hi³sa³ka³txa² wẽ³sa² sa²so¹xi²sxã³ ka¹txain²txi³ ĩ³ne³su²lai¹nha²kxai³ nxain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nxe³sxã³ ko̱³nxe³ti³ ĩ³wai³ka³si³xain¹nũ²la² wã²la² sau¹saun¹ka³lo³ai²na² sa²sai¹kã³ain¹nũ²la² a²wã²la³ka³lo³khai³xa² ũ³whi²kxain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ ĩ³hxi²kĩ¹la³kxi²si¹hain¹jau³su² ã³sa²so¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nxa²ha¹te¹ sxi²ha² a³li³ain¹tãu³a² Si³mãu²ah³la² Si³re²na²ko³xan¹jah¹la² ne³khau²hain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ hi³sa³ka³txa² Je³su²jah³la² ĩ³hxi²kĩ¹la³kxi²ka³txa³nũ³a² sa²tã³ka³la³kxi²hẽt1so¹nha²si¹jau³su² Si³mãu²ah³lan²tu̱³ yxo²xũ̱n³txi³ ĩ³kwa³na³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nxe³ka³tu̱³ ã³nxai³ain¹ka³tu̱³ wã³la³ka³txa² ko³ko²ta²ka̱t3su² nxe³jau³xa² a²si³yxau³tãu³a² sa²kxai³lu² txa²wã¹ne³ka³lo³su² nxe³hxai²na²hẽ³ ka̱³txa²nãu³a² tẽ³sxã³ ai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nxe³hĩ¹na¹ vĩn²yo³jau³xa² hĩ³ne³kxa² fel²yau³xa² ĩ³nẽ³ju³ta² ã³wxe³nẽ³jau³xa² nxe² ũ³ke³ni²jau³xa² ũ³hũ¹ain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ ĩ³nxũ̱n³sain³nũ²la² ĩ³na²ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nxe³nũ²la² hi³sa³ka³txa² ĩ³hxi²kĩ¹la³kxain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Je³su²jah³la² wã²la²ka³lo³a² sa²so¹te²txai³ain¹sxã³ tah³lxa³wẽ³sa² o²la³kxain¹sxã³ a²wa³kxẽn³yah³la² nũ̱¹ha̱in³nyhain¹ka³tu̱³ wã²la²ka³lo³ai²na² sa²kxai³lu² wxa²nũ³te²txai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nxe³ka³tu̱³ ha³lo²a² ã³wxe³ain¹sxã³ yxau²xai³sxã³ ten³sa²tã³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jã¹nxe³tãu³a² hi³a²ka³lo³a² wãn³txa² ũ³wha²li¹lhãn²sxã³ a²ne³ta³lxo³ka³nãu³a¹ ũ³kũ¹tain¹ta¹hxai²hẽ¹la². Ũ³wha²li¹lain¹jau³xa²sa¹: — Je³su²jah³lai²na² Ju³te²a² nũ̱³ka̱³txa² a²hxi²kan¹ta² si³yxau³jah¹lai²la¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jã¹nxe³tãu³a¹ in³txa² ha¹li¹ o³nxa³ti³ kãi³ya³ta¹hxai²hẽ³la². A²nũ²a² yen³kxa² nũ³kxũn³txi³ kãi³kxain¹ta¹hxai²hẽ¹la². Nxe³ya³te²na² tẽ³sxã³ ĩ³hxi²kĩ¹la³kxi²yain¹nũn³ta¹hxai²hẽ¹la². Je³su²jah³la² a²wi¹tãu³a² ka³na³ku² ĩ³hxi²kĩ¹la³kxa²wxe² a²wã̱³tãu³a¹ ka³na³ku² ĩ³hxi²kĩ¹la³kxa²wxe² nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nxa²ha¹te¹ a²nũ²a² kwa² wa³to²hi²te²nãu³xa² ĩ³ne³wa³nxĩn³wa³nxin³nha²sxã³ ĩ³wai³ka³si³xi²jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nxain¹te³nah¹lxi¹: — “Txa²wã¹sũ̱³na² sxi²ha² sa²nai¹hxa³sãn²sxã³ ye³ha¹li¹ ka³na³ki¹ a³la²ni²sxã³ ã¹sa²to³nxi²na¹tu¹wi¹.” Nxĩn¹jau³su² e³in¹tai¹ti²tu³wi¹. Ya²la³tu̱³ Sũ̱³na² Tah²sin¹kxai²nãn²tu̱³ ĩ³hxi²ta²la³kxi²nha²sxã³ a²hi³sa³ka³txa² ka²nxĩ¹nhu¹li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Te²yã¹nxe³sxã³ wã³nxĩn¹ta² si³yxau³ka³ta²nãu³xa² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²nãu³xa² a²nũ²a² hxi²kan¹txi³su² te²nãu³xa² nxain¹sxã³ yxo²ĩ²yhai¹nxa³jau³su² ĩ³wai³ka³si³xi²jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nxain¹te³nah¹lxi¹: — A²nũ²a² ã̱³xa² sa²hau³ko³tain¹to³tai¹ti²tu³wi¹. Yxãn¹ta¹ wã²nxũ̱h¹ hxi²kan¹txi³ sa²hau³ko³nhãn²nxãn³tho³li¹. I³sa³e² a²wa³kxẽn³yah³lai²la¹wi¹. Nxe³ha²kxai³ hi³sa³ka³txa² kan³ke³la³te²kxai³ yxo²ĩ²sĩ¹nhĩ̱³na¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Txa²wã¹sũ̱³na² yxo²ĩ²ain¹te²sin²tai¹. Nxe³ha²kxai³ Sũ̱³nai²na² sa²kxai³lu² wi¹lhin¹sxã³ ĩ²kxain¹kxai²nãn²tu̱³ ã³wa²su¹txai¹lxi¹. A²yxo²wãn³txa² ain³kxi²ki̱³jau³su² nxe³te³nah¹lxi¹: “Sũ̱³na² Tah²su² te²sa¹wi¹.” Nxe³jau³xai²na² e³ha²kxai³lu¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Te²yã¹nxe³sxã³ in³txa² o̱³nxa²ti³ kãi³ya³te²na² ĩ³hxi²kĩ¹la³kxi²yain¹te²na² te²yã¹nxe³jau³su² yxo²ĩ²nyhai¹nxa³jau³xa² ĩ³wai³ka³si³xain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nxa²ha¹te¹ ha³lo²a² whãi²na¹ ka³nxa³hi²khai¹nxe³ta¹hxai²hẽ¹la². A³lan²ta² ne³ka³ka³thĩ¹nãn¹tu̱³ ã³ka³nxa³hi²ta¹hxai²hẽ¹la². Ã³sa²ti¹tã³xi²tãu³a² so¹lxi³ ha²te¹ti³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nxe³te³na¹ ki³kan³te³na¹ Je³su²jah³la² kãin² ĩ³wxan¹sxã³ ĩ³kaix1te³nah¹lxi¹: — E³li¹ e³li¹ la³ma³ sa³ba³ka²ta³ni¹. Ta¹hxai²hẽ¹la². A²nxe³jau³xai²na² a²si³yxau³tãu³a² nxe³te³nah¹lxi¹: — Txa²sũ̱³nu²khai³xah³lãi³. Txa²sũ̱³nu²khai³xah³lãi³. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ã³na¹san¹thi²li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nxe³jau³xai²na² a²nũ²a² kwa² yxau³sxã³ ĩ²tũ̱³ka̱³txa² wai³nxa³txi³ ain³kxai¹nxa³nũ²la² ĩ³ye³kxain¹te³nah¹lxi¹: — E³li²ah³lu¹tai²na² ĩ³kaix1tain¹nĩn²tai¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nxe³te³na¹ a²kwẽn¹tai²na¹ in³txa² kwa² yxau³tũ̱³ka̱³txa² ka³na³ka³na³jah¹la² ã³nih³sxã³ ĩ³yi²lho¹tũ³xa² so¹sxã³ yain³txa³yau³xa² kah³jau³xa² ũ³hũ̱¹sxã³ ũ³whi¹sai¹te³na¹ hi³sa³ka³txa² ũ³ki³wi²kxi²sxã³ Je³su²jah³la² ĩ³o̱n³na²si¹hain¹jau³su² ũh³yxo²tẽ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nxe³yãn¹ta¹ a²nũ²a²nãu³xai²na² wãn³txi³kxai³lu¹: — Ha³lo³kxit1sã²nhẽ³li¹. E³li²ah³la² sa²hau³kot3te³lhxã³ wxã³si¹jau³nũ³su² ĩ²wah³nxe³jah³lxi³sã²nhẽ³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nxa²ha¹te¹ Je³su²jah³la² kãin² ĩ³kwa̱ix1xi²ka³tu̱³ a²wi¹tãu³a² a³li³sxã³ ya³lu²ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nxe³hĩ¹na¹ wã²la² a̱u³khaix1ka³lo³a² Txa²wã¹sũ̱³na² a²sxi²ha² nxũ²kwa̱i³ye³la³nãu³a² a̱u³txi³yxau³thĩ³na¹ yxo²tĩ̱¹ka³lo³a² ãn³ten³ti³ta¹hxai²hẽ¹la². Oh³nãu³a¹ ã³ten³txi² wxa²kan³ka³tu̱³ yu̱³hxai²na² sa²kxai³lu² ã³ten³txi³sxã³ ã³yxo²hai²ta³lxi³ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² Sũ̱³na² yxau³je³na² e³lxah²lxi³ ĩ²ye²ta¹hxai²hẽ¹la². Jã¹nxe³te³na¹ kxĩh³nxa² kãin² sa²wi¹wi¹ni² txah³lxa³kxa² kãin²ka³txa² kwa² a²yxo²hai²ta³lxi² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jã¹nxe³te³na¹ kwã̱³kxẽ³na² a²nũ²a² sa²nĩ̱³kxi²tẽ¹na² yxo²hai²ta³lxi³sxã³ a²nũ²a² ya³lu²te²nãu³xa² wi¹lhin¹te²na² ka³lxa¹sxã³ ka³te̱n³su² ĩ³sa²yxau³xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nxe³sxã³ Je³su²jah³lai²nãn²tu̱³ ka³te̱n³su² ĩ³sa²yxau³xi²hĩ¹nã¹nũ³a² Je³ru³sa³lẽ²thĩ³na² ã³wi¹hai¹nha²kxai³ a²nũ²a² ka³te̱n³ti³ yxau³te²nãu³xa² wã²nã³ũ¹yhe²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nxa²ha¹te¹ so³ta²to² a²hxi²kan¹jah¹lai²na² sa²kxai³lu² a²sa³wi³ha³lxai²na² sa²kxai³lu² Je³su²jah³la² ĩ²yxau³sxã³ wah³nxai¹nha²kxai³ Je³su²jah³la² ya³lu²ju³ta² ĩ²ai¹nha²kxai³ kxĩh³nxa² sa²wi¹win¹ju³ta² ĩ²ai¹nha²kxai³ yen³kxa² a²yxo²ha³kxa¹ ĩ²ai¹nha²kxai³ kãi²no²lain¹sxã³ e³kxain¹te³nah¹lxi¹: — Ya²la³tu̱³ Sũ̱³na² Tah²yah³lo²sin²tai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jã¹nxe³ju³kxai³lu² txu¹ti³nãu³xa² ka³lxa¹txi³nãu³xa² a²kxã³nxai³tã² ka³li³le²a²ko³xa² yxau²xai³lhĩ¹nãn¹te²tu̱³ Je³su²jah³la² ã³si³tẽ³la³kxain¹ta¹hxai²hẽ¹la². A²nxe³te²nãu³xa² hi²sen³su² wi¹lã³non²ta³kxain¹ta¹hxai²hẽ¹la². A²nxe³te²nãu³xa² ĩ²yxau³ain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A²nxe³sxã³ a²ha³tih³nãu³a² Ma³ri²a³ Ma³ta³lẽ²na³ka³lxai²na² Ti³a²kah³la² hxi²ka¹nxa³jah¹lan²tu̱³ Jo³se²ah³la² nxe³sxã³ te²na² a²hã³ka³na² Ma³ri²a³ka³lxu³su² nũn³ta¹ka³lxai²na² Se³be³te²ah³la² wẽ³ha³lxai²na² hã³ka³nu²su² te²na² ain¹sxã³ ĩ²yxau³yain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nxa²ha¹te¹ sũ²ni²tãu³a² in³jah³la² A³ri³ma³te²a²thĩ³nãn¹jah¹la² yen³kxih³khaix1jah¹la² Jo³se²ah³lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹la² Je³su²jah³la² sa³wit3su²nũn³nha²kxai³ ya³lu²ju³ta² ĩ²nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A²nxe³jah¹lai²na² sa²kxai³lu² Pi³la²jah³la² ãn³tĩ̱³ta¹hxai²hẽ¹la². Ã³tĩ̱³sxã³ Je³su²jah³la²nũ²a² ĩ³wã̱³txi³ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Pi³la²jah³la² hi²sen³su² Je³su²jah³la²nũ²a² ũ³hũ¹nha²si¹hain¹jau³su² sa²si¹hã³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nxe³ka³tu̱³ Jo³se²ah³lo²kxai³lu² Je³su²jah³la² a²nũ²a² hi³sa³ka³txa² sa²sai¹kxã¹nũ²la² sa²so¹nũ²la² wã²la² wi¹ka³lo³a² tah²ka³lo³an²tu̱³ tẽ³sxã³ wxa²wa³lã̱u²kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nxe³nũ²la² Jo³se²ah³la² a²tah³lxa³kxẽ¹khai³xa² tah²hẽn³su² ha²kxai³ ũ³whi²wxe³ta¹hxai²hẽ¹la². A²nxe³tẽ¹nai²na² sa²kxai³lu² tah³lxa³ka³txa² wxa²xu³sxã³ wẽ³si¹nyhain¹jau³su² Jo³se²ah³la² a²kxã³nxai³tã² sa²si¹hã³ta¹hxai²hẽ¹la². Jã¹nxe³jut3su² ya³lu²te²nũ²a² ũ³whi²wxe³ta³lun²nũ²la² tah³lxa³ka³txa² kãin²ka³txa² ũ³wa³ti³kxi² sa²tã³sxã³ ũh³yxo²tĩ̱¹kxi²ta¹hxai²hẽ¹la². Ũh³yxo²tĩ̱¹kxi²nũ²la² ĩ³xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nxe³ju³ta² Je³su²jah³la² sa²nĩ̱³kxi³ju³ta² ã³wxe³sxã³ ĩ²yxau³ain¹ta¹hxai²hẽ¹la², txu¹ti³nãu³xa² Ma³ri²a² Ma³ta³lẽ²na³ka³lxa² nxe³ha²kxai³ Ma³ri²a² ã̱³xa¹ka³lxa² nxe³ha²kxai³ ha¹lin¹ta¹ka³lxa² ã³wxe³sxã³ ĩ²yxau³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nxa²ha¹te¹ a²lan²nũ³tãu³a¹ pas²kwa² yain³txa² hau³ko³ta³lun²ti³xa² ha³nau³hĩ²na³na¹ ãh¹a³la²ni²tãu³a¹ wã³nxĩn¹ta² si³yxau³ka³ta²nãu³xa² fa³ri³se²a² nũ̱³ka̱³txa² ain¹sxã³ Pi³la²jah³la² sxi²ha² ã³yã³sa²kxi³nũ²kxain¹ta¹hxai²hẽ¹la². Sa²ba³to³ nxe³kxan²ti³nũ¹ wxã³sxã³ ã³yã³sa²kxi³nũ²kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nxe³sxã³ ĩ³ye³ain¹te³nah¹lxi¹: — Nxex3sa²lxi¹. Jah¹lai²na² ya³lu²jah¹la² ĩ³ki³ha¹kxi²nẽ³jah¹lai²na² wãn³txa² ain³kxi²xi²sĩ¹na¹wi¹. Nxe³jau³xai²na²sa¹: “Ye³ha¹li¹ ka³na³ki¹ a³lan²tãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹.” Nxe³jau³xai³tã² ain³kxi²xi²sĩ¹na¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nxe³ha²kxai³ txah³lxa³kxẽ¹na² a²nũ²a² kan²txi³ ĩ²yxau³si¹hain¹jau³su² ĩ³sa²si¹hã³txai¹nhẽ³li¹. Ya³lu²jah¹lai²na² a²sa³wi³ha³lxa² hãi³a² wxã³sxã³ a²nũ²a² son²sih³kxain¹kxa²ya̱n³txi³su² ki̱³nhai¹. Nxe³ain¹ke³la³te²kxai³ a²nũ²a² ĩ³hen³txai¹nhĩ̱³te³nah¹lxi¹: “Ya²la³tu̱³ ka³te̱n³su² ĩ³sa²yxau³xi²ti²tu³wi¹.” Ain¹jau³nũ³su² nxe³ke³la³te²kxai³ a²ne³ki³son³sxã³ ã³ke̱³tũ¹ain¹ju³ta² ko̱³nxe³ti³nũ¹sain¹sĩn¹tu¹wi¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nxa²ha¹te¹ Pi³la²jah³lai²na² a²wãn³ti³kxai³lu¹: — So³ta²to² nũ̱³ka̱³txa² yũ³yah³lxi¹lxi¹. Txah³lxa³kxẽ¹na² wi¹lhau³ko³jah¹lxi³hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nxe³ka³tu̱³ a³li³ain¹nũ²la² txah³lxa³kxẽ¹na² kan²txi³ wi¹lhau³ko³tha²kxai³ a²nũ²a² ĩ²yxau³sa²tẽ³te²nãu³xa² sa²si¹hã³ai¹nha²kxai³ txah³lxa³kxa² ũh³yxo²tĩ̱¹kxi²wxe³ka³txa² ũ³txã¹tha²kxai³ nxe³ain¹ta¹hxai²hẽ¹la². A²nxe³ka³txai²na² ũ³txã¹tain¹ju³tai²na²sa¹. Kũ̱³ni³nho²su² ũ³txã¹tain¹ju³tan¹te²kxa³ya̱³lhu² hxi²kan¹txi³ sa²yxo²tha²nain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nxa²ha¹te¹ sa²ba³to³ nxe³ti³xa² ha³nãu³hi²na³na¹ ĩ³yũ¹li²nxa³ta̱³lxa¹ to³mĩn²ko³ nxe³ton³tãu³a¹ txu¹ti³nãu³xai³tã² Ma³ri²a² Ma³ta³lẽ²na³ka³lxai³tã² Ma³ri²a² ã̱³xa¹ka³lxai³tã² ain¹sxã³ txah³lxa³kxẽ¹na² ĩ²xi²te³lhxã³ ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nxa²ha¹te¹ a²kxã³nxa² a²kwẽn¹tai²na¹ kxĩh³nxa² kãin² sa²wi¹win¹ye²ta¹hxai²hẽ¹la². Nxe³sxã³ oh³xan¹jah¹la² wxa²kan³sxã³ wxã³nũ²la² txah³lxa³kxai²li² sa²yxo²than²kxi²ta¹hxai²hẽ¹la². Nxe³te³na¹ txah³lxa³kan²tu̱³ ã³wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A²nxe³jah¹lai²na² sa²kxai³lu² ha³lai³yu³hũ̱³nha²kxai³ a²wã²la³ka³lo³khai³xa² hãn³khai¹nxe³sxã³ ne²ve²nũ̱³xa² yã¹nxe³hũ̱³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nxa²ha¹te¹ so³ta²to² nũ̱³ka̱³txa² ĩ²yxau³sxã³ wah³nxe³kxain¹te²nãu³xa² kãin² o²lai¹nha²kxai³ ĩ³ka³ta³ta³tain¹ta¹hxai²hẽ¹la². A²nũ²a² ya³lu²te²hũ̱³sxã³ sxa³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nxa²ha¹te¹ oh³xan¹jah¹lai²na² wãn³txi³kxai³lu¹. Txu¹txa² ĩ³ye³kxi²te³nah¹lxi¹: — Yu̱h³lxah³lxi³txa³hẽ¹ni¹. Je³su²jah³la² ĩ³hxi²kĩ¹la³kxain¹sxã³ ya³lu²jah¹lai¹tã² ã³ten³yah³lxin¹ju³ta³nũ³a² ĩ²te²sa¹xĩ¹. ");
INSERT INTO nabNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yxãn¹ta¹ ti¹ai²na² yũ²nxa³xi¹. Ka³te̱n³su² ĩ³sa²yxau³xi²na²ni¹. E³kxi¹nx2ti³ka²yã¹nxe² ĩ³sa²yxau³xi²na²ni¹. Yxãn¹ta¹ sa²nĩ̱³kxi²tẽ¹na² ya³lu²sxa³je³nai³tã² ã³wih¹sxã³ ĩ²ja¹hẽ¹ni¹. ");
INSERT INTO nabNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ya³hin¹kxai²nãn²tu̱³ ĩ²ta³lun²yah³hin¹kxai²nãn²tu̱³ a²sa³wi³ha³lxa² ai³sxã³ ĩ³hen³txi³tain¹yah³hẽ¹ni¹. Ka³te̱n³su² ĩ³sa²yxau³xi²jau³su² ĩ³hen³txi³tain¹yah³hẽ¹ni¹. Ya³lu²sxã³ sxa³nxa³xĩ¹. Nxa²ha¹te¹ Ka³li³le²a²ko³nãu³a² ĩ³ne³ka²tah¹na²ni¹. Nũ¹ai²na² ne³khau²hxi²yah³hin¹tu¹xĩ¹. Nxe³yah³nx2ta¹xĩ¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nxe³ka³tu̱³ ka³lih¹lxi²sxã³ o²lai¹nha²kxai³ txah³lxẽ¹na² a³li³ain¹nũ²la² yãn¹txi³ ã³nxai³sxã³ a²sa³wi³ha³lxa² ĩ³hen³txi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nxe² a³li³sxã³ ã³nxai³ain¹tãu³a² Je³su²jah³la² hi²sen³su² ne³khauh²xain¹ta¹hxai²hẽ¹la². Ne³khauh²xi²sxã³ wi¹le³kxain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ ã³tĩ̱³ain¹nũ²la² ã³ka³ti³wxe³nũ²la² a²yu³ki³sxã³ ĩ³sa²nẽn¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Yu̱h³lxah³lxi³txa³hẽ¹ni¹. Hãi¹nxe³sxã³ txa²wã³tã̱³nãu³xa² ĩ³hen³txi³txain¹ya³hẽ¹ni¹. “Ka³li³le²a²ko³nãu³a² ã³nxai³sxã³ ne³khauh²xai¹na¹tu¹wi¹.” Nxe³na¹jau³su² ĩ³hen³txi³txain¹yah³hẽ¹ni¹. Je³su²jah³la² ta¹hxai²hẽ¹la². Nxe³jau³su² ain³kxi²nũ²la² a³li³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nxa²ha¹te¹ a³li³ya³ti̱³kxai³lu² so³ta²to² te²nãu³xa² txah³lxẽ¹na² ĩ²yxau³sxã³ wahx3nxain¹te²nãu³xa² Je³ru³sa³lẽ²thĩ³na² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wi¹hain¹sxã³ wã³nxĩn¹ta² si³yxau³ka³ta³nãu³xã² ĩ³hen³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nxa²ha¹te¹ wã³nxĩn¹ta² si³yxau³ka³ta²nãu³xa² a²nũ²a² hxi²kan¹txi³su² te²nãu³xa² ã³nũ¹tain¹sxã³ a̱in³nhain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ so³ta²to² nũ̱³ka̱³txa² ũ³yho³hi²ki³a² kãin² ũ³yho³hi²hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nxe³te³nah¹lxi¹: — A²nũ²a² ĩ³wã̱³txã¹nyhain¹kxai²nãn²tu̱³ nxe² ĩ³wa²lũ³xi¹jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹te³nah¹lxi¹: “Ka³nxah³ti³na² ãu³xi²sĩ¹na¹tãu³a² ya³lu²jah¹la² sa³wi³ha³lxa² hãi³a² wxã³sxã³ a²nũ²a² so²a²sih³kxi²nyhain¹nũ²nhai¹.” Ki³han³jau³xa² nxe² e³kxi¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nxa²ha¹te¹ wãn³txai²na² ãu³xah³lxin¹jau³xai²na² sa²kxai³lu² Pi³la²jah³la² wxa²hxi²kan¹jah¹lai²na² a²ne³nxẽ³na² ã³wih¹kxai²nãn²tu̱³ wi¹le³kxi²sĩ¹na¹tu¹wi¹. Nxe³kxe³su² ko̱n³ton³kxi¹nx2ti³xah³lho³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nxe² e³kxi²ta³lun²nũ²la² so³ta²to² nũ̱³ka̱³txai²na² sa²kxai³lu² ũ³yho³hi²ki³a² so¹sxã³ wãn³txin³txi² ki³han³jau³xin³ti² sa²yxo²we¹tain¹ta¹hxai²hẽ¹la². Jã¹nxe³jau³su² nxe³hĩ¹nãn¹te²tu̱³ wãn³txin³txi² u²lxi³ ha³ta̱³nxe³jau³su² Ju³te²a² nũ̱³ka̱³txa² yxo²ĩ²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nxa²ha¹te¹ Je³su²jah³la² sa³wi³ha³lxa² hxi²ka² hxan³sxã³ ka³na³ka³nat3sxã³ wxa²hait1so¹xi²nũn³tũ̱³ka̱³txai²na² sa²kxai³lu² Ka³li³le²a²ko³xa² ã³nxai³ain¹ta¹hxai²hẽ¹la². Wã³la² wã²nã³ũ¹ka³txai³tã² ka³la³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nxa²ha¹te¹ Je³su²jah³la² ĩ²ain¹te³na¹ ĩ³sa²nẽn¹kxain¹ta¹hxai²hẽ¹la². Nxe³yãn¹ta¹ a²sa³wi³ha³lxa² ka³na³ku² ĩ³wã̱³wã̱³jain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nxe³ka³tu̱³ ã³tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Oh³nãu³nũ¹ka³nãu³a¹ yu̱h³nãu³nũ¹ka³nãu³a¹ a²hãi¹nxe³ti³xa¹ A²hxi²kan¹ta² Si³yxau³kat3su² tãu³sa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nxe³te²sa¹ha²kxai³ ha³lo²a² yu̱h³xan¹ko³nãu³xa² a²yxo²ha³kxa¹ ai³jah³lxi³sxã³ a²nũ²a²nãu³xai²na² txa²sa³wi³ha³lxi³lon³jah¹lxi³hẽ¹li¹. Yxah³lxin¹kxai²nãn²tu̱³ ĩ̱³yau³xa² ũ³hũ̱¹kxi²sa²sai¹nyha¹ju³ah³lxi³hẽ¹li¹. Yxah³lxin¹tãu³a² Txa²wĩ³na² ĩ³lxa² ũ³hũ̱¹kxi²sa²sai¹nyhah¹lxi¹nha²kxai³ A²tah²na¹xai²na² ĩ³lxa² ũ³hũ̱¹kxi²sa²sai¹nyhah¹lxi¹nha²kxai³ Sũ̱³na² Yãu³ka³jxah¹la² ĩ³lxa² ũ³hũ̱¹kxi²sa²sai¹nyhah¹lxi¹nha²kxai³ nxe³sxã³ ũ³hũ̱¹kxi²sa²sai¹nyha¹ju³ah³lxi³hẽ¹li¹. Txa²sa³wi³ha³lxi³sye¹nxain¹ju³ta² e³lxah²lxi³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yxah³lxin¹kxai²nãn²tu̱³ Txa²wãn³txa² ĩ³ye³kxi¹nx2ta¹jau³xai²na² a²yxo²ha³kxa¹ sa²yxo²wet1si¹hain¹jau³su² ĩ³yau¹ũ³txain¹yah³lxi³hẽ¹li¹. Nxe³ya¹nx2ta¹wi¹. Ã³si³tẽ³kxi²sa²tẽ³nx2ta¹tu¹wi¹. Yuh³xan¹ko³nãu³a² ne³ki³so³nxa³tãu³a¹ ã³si³tẽ³kxi²sa²tẽ³nx2ta¹tu¹wi¹. Nxe³ya³nx2ta¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la².");
INSERT INTO nabNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wãn³txa² wi¹jau³xa² Je³su²jah³la² Txa²wã¹sũ̱³na² Ta²ha² yxau²xai³ju³ta² ĩ³yau¹ũ³nẽ³jau³xa², hĩ¹na² ãn³si³wxe²na³la². A²nxe³jah¹lai²na² sa²kxai³lu² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Nxe³jau³xai²na²sa¹, kxã³nhxĩ¹nu¹tai²na² I³sa³i²ah³lu¹tai²na² ũ³wha²li¹txã³nxu¹tai²na² nxe³te³nah¹lxi¹: — A²nũ²a² ã̱³jah¹la² wxã³tu¹wi¹. Ha³lo²ai²na² a²nũ²a² yxau³ai¹nxa³ko³nãu³a² ai³sxã³ ĩ³ye³tu¹wi¹. Ĩ³ye³kxi²te³nah¹lxi¹: “A²nũ²a² hxi²kan¹jah¹lo²su² wxã³ju³ta²nũ³a² yũ³kxai²nãn²tu̱³ ã³wxã³tĩh³na²nũ³a² wxa²hau³ko³tain¹te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³sxã³ Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹la² wxã³ju³ta²nũ³a² wxa²ẽ¹nãu³ai²na² wxa²hau³ko³nha¹jah³lxi³hẽ¹li¹. Ya²la³tu̱³ wxã³ti³wa³ki³lxon³na³li¹.” Nxe³tu¹wi¹. I³sa³i²ah³lu¹ta²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nxe³nxa²ha¹te¹ Jo³ãu² Ba³tis²jah³lo²su² te²kxai³lu¹, wxã³sxã³ ha³lo²ai²na² a²nũ²a² yxau³ai¹nxa³ko³nãu³a¹ he¹ta¹hxai²hẽ¹la². He¹te³na¹ a²nũ²a² ka³lxa¹txi³ ã³yã³nũ²kxain¹ta¹hxai²hẽ¹la². Ã³yã³nũ²kxain¹nũ²la² Jo³ãu² Ba³tis²jah³la²kxai³la¹ ĩ³hen³txain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² yũ³khaix1yah³lxi¹lxi¹. Yxah³lxi¹nha²kxai³ ĩ³ãin²ta³kxi¹nha¹jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² hi²sen³su² ko̱³nxe³ti³ kãi³yah³lxin¹kxa² wah³xa² ã³wa²su¹txa²ti³tu¹wi¹. Nxe³yah³lxin¹ju³tan¹te²kxa³ya̱n³tu̱³ta¹ ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹si¹ha¹jau³su² ã³tĩ̱³kxi¹sah¹lxi³hẽ¹li¹. Jo³ãu² Ba³tis²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nxe³ha²kxai³ a²nũ²a² Ju³te²a²ko³xa² yxau³ain¹te²su² te²a² hãi¹nxe³ti³xa¹ a³li³i² Je³ru³sa³lẽ²thĩ³na² yxau³ain¹te²su² te²a² hãi¹nxe³ti³xa¹ a³li³i² nũ²la² ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³xa² ã³nxai³ain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² a²ko̱³nxe³ti³ kãi³ain¹ju³ta² Sũ̱³na² ĩ³hen³txain¹sãn²nũ²la² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² sa²kxai³la¹ ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² Txa²wã¹sũ̱³na² hxi²ki³kxai³lu² ã³wa²su¹jau³su² yxo²ĩ²yah³lxi³ta¹hxai²hẽ¹la². Yxo²ĩ²yah³lxi³ha²kxai³ ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹yah³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jo³ãu² Ba³tis²jah³lai²na² sa²kxai³lu² ka³yxuh³xa² ka³me²la² a²wã²la²ka³lo³a² ũ³whi²kxi²nha²ha²kxai³ po¹na² a²wã²la² sa²sĩ̱³ĩ¹nha²ha²kxai³ ka³ya̱³txa² ĩ³yai³ni², txu³ha²yau³xa² ĩ³na² nxe³ha²kxai³ nain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A²nxe³jah¹lo²su² jah¹la² a²wãn³txi³kxai³lu¹ a²nũ²a² yxo²ha³kxa¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²si³yo³na² a²nũ²a² hxi²kan¹txi³ wa³to²hi²sa²jah¹la² wxã³tu¹wi¹. Wxã³te³na¹ hxi²kan¹txi³ wa³to²hi²sa³ha²kxai³ a²yu³kxa² yu³wi²kxi²nha²ka³lo³a² sa²yu³ta²la³kxi²nũ¹ha¹kxe³su² hxi²ka¹nhĩ̱²nxa³nha²wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Txai²na² ĩ̱³yau³xa² so¹lxi³ ũ³hũ¹kxi²sa²sai¹ya³nx2ta¹ti²ti¹. Yxãn¹ta¹ jah¹lai²na² hi²sen³su² Txa²wã¹sũ̱³na² A²yãu³ka³jxah¹la² Wi¹lhin¹jah¹la² ũ³hũ¹nxa²lxi³ha²kxai³ wxa²ẽ¹nãu³ai²na² ã³nhxan³ka²ti³nxa²lxi³ha²kxai³ nxe³jah¹lo²su² na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","10","Nxe³hĩ¹nu¹tai²na², Je³su²jah³la² Na³sa³re²thĩ³na² Ka³li³le²a²ko³xan¹thĩ³na² yxau³ta¹hxai²hẽ¹la². A²nxe³thĩ³na² a³li³nũ²la² Jo³ãu² Ba³tis²jah³la² hxi²ka² ũ³hũ¹kxi²sa²sai¹si¹jau³su² Jor²tãu²yau³xa² ã³nxai³ta¹hxai²hẽ¹la². Nxe³sxã³, Jo³ãu² Ba³tis²jah³lai²na² a²hi²sen³kxai³lu² so¹sxã³, ũ³hũ¹kxi²sa²sai¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹, ĩ̱³yau³xa² a³li³ain¹te³nah¹lxi¹, oh³sĩ̱³nãu³a¹ sa²yxo²hai¹sxã³, kwa³sxa³hũ̱³nxe² Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² oh³nãu³a¹ a³ka³nxi²xi²ye²ka³tu̱³ Je³su²jah³lai²na² ãn³ka³la³kxi³wxe³ka̱in¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nxe³tãu³ãn²tu̱³ti¹ oh³nãu³an¹te²a² wãn³txa² ain³kxain¹ta¹hxai²hẽ¹la². Ain³kxain¹te³nah¹lxi¹: — Wxãi²li² Txa²ki³lha³lxa²khaix1si¹lxi¹. A³lxi¹nxa²ha¹kxah³lo²si¹lxi¹. Wi¹lxo³kxi²khaix1san¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Nxe³nxa²ha¹te¹ kwẽn¹ta²kxai³lu¹ Txa²wã¹sũ̱³na² A²yãu³ka³jxah¹la² hi²sen³kxai³lu¹, Je³su²jah³la² ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³nãu³a¹ ã³sa²so¹si¹ta¹hxai²hẽ¹la². Nũ¹ã¹ ka³yxuh³xa² ũ̱n³txa² he¹tãu³a¹ ye³ka³lxa¹txi³ a³lan²ta¹hxai²hẽ¹la². Ye³hxi²ka² hxan³sxã³ wxa²sa²wa²la³kxi²sxã³ wxa²sa²wa²la³kxi²nũn³sxã³ te²yã¹nxe² wxa²sa²wa²la³kxi²nũn³sxã³ a³lan²ta¹hxai²hẽ¹la². 40 nxe² a³la²ni²ta¹hxai²hẽ¹la². Nxe³hĩ¹na¹, Sa³ta³na²jah¹la² a²hi²sen³su² o²la³kxi²sxã³ Je³su²jah³la² Txa²wã¹sũ̱³na² a²ten³jau³su² jau³xa² ã³na¹si¹jau³su² ĩ³wa³ka³nxe³sain³ta¹hxai²hẽ¹la². Yxãn¹ta¹ hai³txi³ hxi²ka¹nha²txi³ti³hex1ta¹hxai²nxa³hẽ¹la². Nxe³nũ²la² oh³xan¹te² nũ̱³ka̱³txa² wxa²kan³sxã³ wxã³nũ²la² Je³su²jah³la² sa²hau³ko³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nxe³nxa²ha¹te¹ hã²wxãn³txa³ Jo³ãu² Ba³tis²jah³lai²na² sxi²ha² kan²thĩ³na² ũ³tĩ̱¹kxi²wxe³ain¹nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu² Ka³li³le²a²ko³nãu³a¹ ã³nxai³sxã³, Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ĩ³ye³kxi²te³nah¹lxi¹: — Ha³lo²a² hau³kon³na³li¹. Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³a² wxã³ti³wa³ki³lxon³na³li¹. Nxe³ha²kxai³lu¹ ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ã³sa²wa²nha²sxã³ ã³na¹jah¹lxi³hẽ¹li¹. Yah³lxin¹ka³tu̱³ Txa²wãn³txa² wi¹jau³xa² so¹lxi³ yxo²ĩ²sah¹lxi³hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nxe³nxa²ha¹te¹ a²lon³ti³tãu³xa² Si³mãu²ah³la² Ãn³tre²ah³la² ain¹sxã³ a̱i³na² hoh³lxi³su² ya³ta¹hxai²hẽ¹la². Ai¹nha²kxai³ ĩ̱³ye³na² Ka³li³le²ye³na² ta³lã²la²ka³lo³a² ã³na¹ya³ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹ Je³su²jah³lo²su² te²kxai³lu¹ ĩ̱³ye³nai²na² a²yxo²ka³te̱³nhãu³ã¹ ã³nxai³te³nah¹lxi¹ a²lon³ti³tãu³xai²na² ĩ³ha¹txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","18","Ĩ³ha¹txain¹sxã³, ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³ja³sa²lxi¹. Ãn³si³tẽ³sya¹hẽ¹li¹. A̱i³na² ã³na¹yah³to³hxain¹tai¹ti²ti¹. Yxãn¹ta¹ ãn³si³tẽ³sya¹hin¹kxai²nãn²tu̱³ a²nũ²a² ĩ³kaix1so¹ya³hin¹ju³ta² ĩ³yau¹ũ³nx2ta¹tu¹wi¹, ã³si³tẽ³kxi²sya¹si¹hai¹na¹jau³su¹. Ta¹hxai²hẽ¹la². Nxe³sxã³ ta³lã²la²ka³lo³nãu³xai²na² ã³ya³sxã³, kwẽn¹ta²kxai³ Je³su²jah³la² ã³si³tẽ³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nxe³ka³tu̱³ta¹ jũ¹nxe² yxan¹nãu³a¹ Ti³a²kah³la², Se³be³te²ah³la² ta²ha² yxau² a²lo³na² Jo³ãu²ah³la² yxau² ka²no¹a² yxau³ya³sxã³ ta³lã²la²ka³lo³a² ã³sa²ka³tũ¹sxã³ ãn³sa²hau³ko³ja³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nxe³ka³tu̱³ Je³su²jah³la² ya̱u³son³kxain¹sxã³ ĩ³kaix1tain¹ta¹hxai²hẽ¹la². Ĩ³kaix1te³na¹ Jo³ãu²ah³la² Ti³a²kah³la² nxe³ya³sxã³ a²wĩ³na² ka²no¹a²nãu³a¹ ã³na¹i² a²sa³wi³ha³lxi³nãu³xã² ka²no¹a²nãu³a¹ ã³na¹i² nxe³sxã³ ãn³si³tẽ³nhya¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nxe³nxa²ha¹te¹ Ka³far³na³ũ²thĩ³na² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ sa²ba³to³ nxe³ju³kxai³lu² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wi¹hain¹ka³tu̱³ Je³su²jah³la² hi²sen³kxai³lu² Txa²wã¹sũ̱³na² wãn³txa² ĩ³yau¹ũ³nhyain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nxe² wxã³jau³xai²na² sa²kxai³lu² a²nũ²a²nãu³xa² ain³kxain¹ka³tu̱³ ĩ³wã̱³wã̱³ta³kxi²nha²sxã³ ã³no²non²ta³kxi²nhyain¹ta¹hxai²hẽ¹la². Je³su²jah³la² wxi²kan¹khai¹nxe³sxã³ ĩ³ye³ha²kxai³ hai³txi³ ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² ĩ³ye³kxu¹jã¹nxẽ²nxa³ha²kxai³ a²nũ²a² hãi¹nxe³ti³xã¹ ĩ³wã̱³wã̱³ta³kxi²nha²sxã³ ã³no²non²ta³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nxe³nxa²ha¹te¹ ã³nũ²kxi²thĩ³nãu³ai²na² a²nũ²a² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau³jah¹la² he¹ta¹hxai²hẽ¹la². A²nxe³jah¹la² ĩ³wxan¹te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","— Je³su²jah³lãi³. Na³sa³re²thĩ³nãn¹jah¹lo²si¹lxi¹. Ĩh¹nxet3sa¹nhĩn¹ji¹wi¹? Sun²tã²hxat3sa²sĩn¹te³lhxã³ wxã³nhĩn¹ji¹wi¹? Wxãi²na² ĩ²nxa²te²sa¹wi¹. Txa²wã¹sũ̱³na² Tah²si¹lxi¹. Ko̱³nxe³ju³ta² yũ³ti³hex1jah¹lo²si¹lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nxa²ha¹te¹ Je³su²jah³lai²na² ko̱³nxe³te²a² yãu³ka³txa² wxi²kan¹sxã³ kwa³na³te³nah¹lxi¹: — In³txai²li² ka³nahx2nxe³sxã³ nxũ²kwa̱i³li³txa²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nxe³ka³tu̱³ ko̱³nxe³te²a² yãu³ka³txai²na² sa²kxai³lu² kãin² wxan¹khaix1nxe³ka³tu̱³, in³txai²na² ã³nhẽ¹nhẽ¹nhyain¹te³na¹, nxũ²kwa̱i³li³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nxe³jut3su² ha²kxai³ a²nũ²a² hãi¹nxe³ti³xã¹ kãin² o²lain¹sxã³ ĩ³wã̱³txi³nhyu¹te³nah¹lxi¹: — Ju¹tai²na² ĩh¹nxe³ju³khai³sa²hĩn³te²la¹ku². Jah¹lai²na² wãn³txa² tah²yau³khai³sa²te²la¹ku². Ki̱³nhai¹. Je³su²jah³lai²na² wxi²kan¹txi³ kwa³na³te²la¹i¹. Kwa³na³kxai²nãn²tu̱³ ko̱³nxe³te²a² yãu³ka³txa² ha³ta̱³nxãn²txi³ sa²yxo²wet1sxã³ a³li³ain¹na²li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nxe³ju³ta² sa²kxai³ Je³su²jah³la² wxi²kan¹txi³ kãi³ye²jau³su² a²nũ²a² yxo²ha³kxa¹ Ka³li³le²a²ko³nãu³a¹ yxau³te²a² yxo²ha³kxa¹ ain³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nxe³nxa²ha¹te¹, ã³ki³nũ²kxi²thĩ³nai²na² a³li³ain¹nxa²ha¹te¹ Je³su²jah³la² Ti³a²kah³la² Jo³ãu²ah³la² whãi²na¹ sxi²ha² thĩ³nã̱³xã¹ ã³wi¹hain¹ta¹hxai²hẽ¹la². A²nxe³thĩ³nai²na² a²wa³kxẽ³nũ̱³ka̱³txa² Si³mãu²ah³la² Ãn³tre²ah³la² nxe³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","31","A²nxe³thĩ³nãu³ai²na² Si³mãu²ah³lai²na² a²hã̱i³na¹ka³lxa² ĩ³hi̱¹la³kxi²sxã³ ĩ³to³nha²kxai³ sxa³ye²ta¹hxai²hẽ¹la². Nxe³ju³tai²na² Je³su²jah³la² ĩ³hen³txain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ Je³su²jah³lo²su² te²kxai³lu² wxã³sxã³ txu¹hai²na² hxi²ki³sxã³ sa²yxo²ka²la¹te³te³na¹, wa³su³txi³ ĩ³hi̱¹la³kxi²ka³txai²na² ã³wa²su¹ta¹hxai²hẽ¹la². Nxe³ju³kxai³lu¹ txu¹ha³ka³lxai²na² a²hi²sen³kxai³lu¹ Je³su²jah³lai²na² nũ̱³ka̱³txa² yain³txa² sa²hau³kot3sxã³ ũ³hãu¹la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nxe³nũ²la² ki³kan³nũ²la² a²nũ²a² wi¹lain³nha²te² hi²sen³kxai³lu¹ a²nũ²a² ã̱³xa² ĩ³ton³te²su² te²a² a²hãi¹nxe³ti³xa¹ tẽ³i² a²nũ²a² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau³te²su² te²a² a²hãi¹nxe³ti³xa¹ tẽ³i² ain¹sxã³ Je³su²jah³la² ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nxe³sxã³ sxi²yhe³nai²na² Ka³far³na³ũ²thĩ³nãn¹tũ̱³ka̱³txa² a²hãi¹nxe³ti³xa¹, tĩ̱³nyhain¹ta¹hxai²hẽ¹la². Tĩ̱³nyhain¹sxã³, Je³su²jah³la² yxau³thĩ³na² yxo²ti²ta³lo³kxa² ã³nũ̱t1sxã³ yxau³ain¹ta¹hxai²hẽ¹la². Ĩ³ta³ka³txa² ĩ²li³te²su² ĩ³ton³te²a² ka³lxa¹tũ̱³ka̱³txi³su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A²nxe³tũ̱³ka̱³txai²na² Je³su²jah³la² sa²we²ti² ko̱³nxe³te²a² yãu³ka³txa² ka³lxa¹txi³ Je³su²jah³la² wxa²sa²tã³kxi² nxe³ta¹hxai²hẽ¹la². Nxe³ju³ta² Je³su²jah³la² ko̱³nxe³te²a² yãu³ka³txi³nãu³xa² kan²txi³ ãn³ka³na²si¹jau³su² ĩ³kwa³na³ain¹ta¹hxai²hẽ¹la². Je³su²jah³la² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹lo²tain¹kxe³su² a³la³kxai¹nha²kxai³ ka³nahx2nxe³sxã³ yxau³si¹hain¹jau³su² kwa³na³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nxe³nxa²ha¹te¹, ka³nxa³ha²ta³kxai³lu² ĩ³yũ¹li²ti³he¹nxa³tãu³kxai³lu² Je³su²jah³lai²na² ĩ³sa²yxau³nũ²la² ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³xa², ã³nxai³nũ²la², Txa²wã¹sũ̱³na² nũh¹ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A²nxe³ti̱³kxai³lu² Si³mãu²ah³la² nũ̱³ka̱³txi³kxai³lu¹ Je³su²jah³la² ĩ³hi¹txai³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ain¹te³na¹ Je³su²jah³la² ĩ³ha¹txi²te³na¹: — A²nũ²a² yxo²ha³kxa¹ ã³ten³nxain¹na²li¹. Si³mãu²ah³la² nũ̱³ka̱³txa² nxe² e³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Yxan¹nãu³a¹ sxi²yhe³na¹ ã̱³xã¹ ã³nxai³yah³sah¹lxi³hẽ¹li¹, Txa²wã¹sũ̱³na² wãn³txa² ĩ³ye³kxain¹si¹ha¹jau³su¹. Nxe³ai¹na¹ju³ta³nũ³su² Txa²wã¹sũ̱³na² sa²si¹hã³sain¹na²hẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nũ²la² Ka³li³le²a²ko³xai²na² yxo²ha³kxa¹ ai³lha²thet3ta¹hxai²hẽ¹la². Nxe³sxã³ Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³nãu³xa² ã³wih¹to³ka³tu̱³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³hen³txi² ko̱³nxe³te²a² yãu³ka³txa² ĩ³sa²si¹hã³i² nxe² ai³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nxe³nxa²ha¹te¹ a²nũ²a² khon³ta³kxi²sxã³ ka̱³lã̱un³ta³kxi²jah¹la² ai³sxã³ Je³su²jah³la² wxã³sxĩ²ta¹hxai²hẽ¹la². Wxã³sxã³ ãn³ka³ti³we̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Txa²ĩ³ta³ka³txa² ten³nxa²kxai²nãn²tu̱³ sa²hau³kot3sa²hĩ̱³nxa¹lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Nxa²ha¹te¹ Je³su²jah³la² ĩ³nũ̱³si̱n²nha²sxã³ wxa²wxai³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³txi¹. Ten³sa³nhai¹. Wxa²ĩ³ta³ka³txa² we²txi¹nxa²ha¹wi¹. Ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ wa³su³txi³ a²ĩ³ta³ka³txai²li² we²nxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ yxo²sa³te̱¹txi³ ĩ³ye³kxain¹te³nah¹lxi¹: — We²txi¹nxa²ha¹ju³tan¹te²kxa³ya̱³lhu² wã³nxĩn¹te²a² si³yxau³jah¹la² sxi²ha² ai³sẽ¹li¹. Ain¹tãu³a² we²txi¹nxa²ha¹ju³ta² a²nũ²a² ã̱³xa² ĩ³hen³txi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ wã³nxĩn¹te²a² si³yxau³jah¹lan²tu̱³ ai³sxã³ ĩ³yau¹ũ¹nhat1je¹txai¹nhẽ³li¹. Nai¹nĩn¹kxai²nãn²tu̱³ hã²wxãn³txa³ ka³yxuh³xa² Moi³se²ah³lu¹tai²na² ĩ³yau¹ũ¹nxain¹kxe³su² ũ³hũ¹txai¹nhẽ³li¹. Nxai¹nĩn¹kxai²nãn²tu̱³ wã³nxĩn¹te²a² sa²kxai³lu² ka³yxuh³xai²na², Sũ̱³na² ũ³hũ¹yhain¹tu¹wi¹. Nxai¹nĩn¹kxai²nãn²tu̱³ a²nũ²a² yxo²ha³kxa¹ we²txi¹nxa²ha¹ju³ta² e³lxah²lxi³je¹nxain¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yxãn¹ta¹ jah¹lai²na² sa²kxai³lu² ã³nxai³ain¹ka³tu̱³, ĩ³ta³ka³txai²na² we²nxi²jau³xa² a²nũ²a² yxo²ha³kxa¹ kãin² ĩ³ye³kxain¹to³ta¹hxai²hẽ¹la². Ai¹nha²kxai³ Je³su²jah³la² hi²sen³kxai³lu² sxi²yhen³nãu³xãn²ta³ ã³wih¹ta¹hxai²nxa³hẽ¹la², a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² ã³ki³ka³ti³kxain¹sxã³ ã³nhxi²ka̱u³ka̱u³txain¹kxa²ya̱n³ti³sa². Ai²nha²kxai³, Je³su²jah³lo²su² te²kxai³lu² ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³xa² so¹lxi³ yxau³ta¹hxai²hẽ¹la². Yxau³kxan²ta¹ a²nũ²a² sxi²yhen³nãu³xa² hãi¹nxe³ti³xa² a³li³sxã³ Je³su²jah³la² ĩ²te³lhxã³ tĩ̱³nhãun¹nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nxe³nxa²ha¹te¹ ye³ka³lxa¹txi³ a³la²ni²nxa³ha²kxai³ Je³su²jah³la² Ka³far³na³ũ²thĩ³na² ã³wa̱³li²ta¹hxai²hẽ¹la². Nũ²la² a²sxi²lho³thĩ³na² ha³ta̱³nxa² a²nũ²a² ã̱³xa² ain³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ain³kxain¹te³na¹ a²nũ²a² ka³lxa¹khaix1tũ̱³ka̱³txa² Je³su²jah³lai²na² yxau³thĩ³na² tĩ̱³xain¹ta¹hxai²hẽ¹la². Nxe³sxã³ ka³lxa¹khaix1nxe³ha²kxai³ hxi²kan¹ti³ sxih²yxo² ti²ta³lo³kxa³nãu³a¹ ã³nũ²kxi²sxã³ he¹ain¹ta¹hxai²nxa³hẽ¹la². Nxe³tãu³ãn²ta³ Je³su²jah³la²kxai³lu² Sũ̱³na² a²wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nxe³nxa²ha¹te¹ in³txi³nãu³xa² ha¹li¹ ha¹lin¹tũ̱³ka̱³txa², wxã³ain¹ta¹hxai²hẽ¹la². In³txa² ĩ³ton³jah¹la² kan²ta³kxi²sxã³ ĩ³ton³jah¹la² hãi¹sxã³ sxa³ye²ta¹hxai²hẽ¹la². A²nxe³jah¹la² so¹sxã³ ka²ma²ka³lo³a² whãi²na¹ ã³ki³wxen³ta³kxi²sxã³ sa²so¹sxã³ wxã³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nxe³ain¹tah¹lxa¹ sxi²hẽ¹nãu³a² a²nũ²a² nũ̱³ka̱³txa² ã³ka³tũ̱³je²nyhai¹nha²kxai³ hxi²kan¹txi³ ã³wi¹hain¹ta¹hxai²nxa³hẽ¹la². Nxe²nxa³ha²kxai³ sxi²ha² ne³ka³nah²nãu³a² ĩ³ka³la³nũ²la² te²la²ka³lo³a² sa²sain¹ta³kxi²ain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² ĩ³ton³jah¹la² ka²ma²ka³lo³a² whãi²na¹ Je³su²jah³la² a²ne³kxai³tãu³a² a²nũ²a² a²nxũ²kwa̱i³wi³tan²ta² ũ³yhu³lhxot1sxã³ ũ³ha¹ain¹ta¹hxai²hẽ¹la². — Je³su²jah³la² hxi²ka² kan²ta³kxi²nẽ³ka³txa² we²txi²ju³ta² yũ³tũ¹xã¹. Ain¹jau³su² ũ³wha¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nxe³ju³tai²na² Je³su²jah³la² wi¹ko̱³nh²nxa²ha¹te¹ kan²ta³kxi²jah¹lai²na² ĩ³ye³kxi²te³nah¹lxi¹: — Sa³nxe³la³kxah³lãi³. Wxa²ko̱³nxe³ti³ kãi³in¹ju³ta² ã³wa²su¹ti¹nxa²ha¹wi¹. Je³su²jah³la² wãn³txa² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nxe³ju³ta²kxai³ ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² ka³na³ku² te²su² te²a² thĩ¹nãu³ai²na² ã³wxe³sxã³ ĩ²yxau³ain¹ta¹hxai²hẽ¹la². Nxe³tũ̱³ka̱³txai²na² a²ẽ¹nãu³a² ĩ³wã̱³wã̱³txi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Nxe³nyhain¹te³nah¹lxi¹: — Je³su²jah³lai²na² wãn³txai²na² Txa²wã¹sũ̱³na² Si³yxau³jah¹la² so¹lxi³, hxi²kan¹ti³ ĩ³ye³jau³xai²la¹wi¹. A²nũ²a² ko̱³nxe³ti³ kãi³ki̱³ju³tai²nãn²tu̱³ Txa²wã¹sũ̱³na² Si³yxau³jah¹la² so¹lxi³ hxi²kan¹ti³ wxa²wa²su¹tẽ³te²jai¹ti²ti¹. Nxe³ha²kxai³ Je³su²jah³lai²na² a²nũ²a²khai³so¹lxi³jah¹lai²na² a²wãn³txai²na² Txa²wã¹sũ̱³na² ko̱³nxe³te²lo³jau³su² na³li¹. Nxe³jau³su² ki³han³sxã³ e³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Nxain¹nxa²ha¹te¹ Je³su²jah³la²kxai³ he³son³kxi²nyhain¹jau³xa² wi¹ko̱³nha²nũ²la² ĩ³ye³kxain¹te³nah¹lxi¹: — He³son³yah³lxin¹jau³xa² ha²ya̱³kxa² e³li³jah³lxi³hẽ¹li¹. Ne³kxa²a³sah¹lxi³wxi¹. Ĩh¹jau¹la³ta̱³ wãn³txa² wa³su³jau³la³te²la¹xã³? “Wxa²ko̱³nxe³ti³ kãi³in¹ju³ta² ã³wa²su¹txa²ha¹wi¹.” Nxe³jau³xai²la³ta̱³nxa²: “Ĩ³ton³jah¹lãi³. Ĩ³sa²yxau³sxã³ ã³nxĩ³xi¹sẽ¹li¹.” Nxe³jau³xai²la³ta̱³nxa² nxe³hĩ̱³ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yxãn¹ta¹ Txai²na² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²kah³lo²su² Na¹ha²kxai³ wxi²ka¹na¹ju³ta² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Nxe³ha²kxai³ ĩ³ton³jah¹lo² ĩ³nxai²na² ĩ³ye³kxi¹nxa²ha¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ĩ³sa²yxau³sxã³ wxa²sxan¹ka³lo³ai²na² whãi²na¹ sa²so¹sxã³ ã³nxĩ³txu¹li¹. Nxe³nxa²ha¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nxe³ju³tan¹te²kxa³ya̱n³tu̱³ in³txai²na² sa²kxai³lu², wa³su³txi³ sxa³sxã³ ĩ³sa²yxau³sxã³ a²sxa³ka³lo³ai²na² sa²so¹sxã³ a³li³xi²ye²yhain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ a²nũ²a² yxo²ha³kxa¹ ĩ³wã̱³wã̱³ta³kxain¹sxã³ ã³no²non²ta³kxain¹sxã³ ĩ³ye³kxi²lã³ain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² nũ̱³kxũn³khai¹nxe³sxã³ wi¹lhin¹khai¹nxe³te²la¹wi¹. Ha³lo²ai²na² Sũ̱³na² kãi³ju³ta² hĩ¹na² so¹lxi³ ĩ²ki̱³tã³li¹. Kxã³nxai³ta³li² te²u¹jã¹nxe³ju³ta³la³ ĩ²ti³hex1ki̱³sxa³tai¹ti²ti¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nxe³nxa²ha¹te¹, Je³su²jah³la² ĩ̱³ye³na² yxo²ki³sa³nãu³a¹ ã³nxai³to³ta¹hxai²hẽ¹la². Nxe³sxã³ a²nũ²a² yxo²ha³kxa¹ ãn³ki³ka³ti³kxain¹sxã³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hã²wxãn³txa³ Je³su²jah³lo²kxai³lu² a³li³xi²nũ²la² a²nũ²a² ũ³yho³ha³ki²ka² so¹kxi²nẽ³jah¹lai²na² Le³vi²ah³lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² sa²kxai³lu² sxi²ha² ũ³yho³ha³ki²ka² ũ³wha¹thĩ³na² ã³wxe³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Je³su²jah³la²kxai³lu² ĩ²sxã³ ĩ³kaix1te³nah¹lxi¹: — Ã³si³tẽ³kxi¹sẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². Nxe³ai¹nha²kxai³ Le³vi²ah³la²kxai³lu² Je³su²jah³la² ã³si³tẽ³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hã²wxãn³txa³ Je³su²jah³lo²su² te²kxai³lu² Le³vi²ah³lai²na² sxi²ha² ã³wih¹sxã³ ã³wxe³sxã³, ĩ³yain³ta¹hxai²hẽ¹la². Je³su²jah³la² ã³wxe² a²sa³wi³ha³lxi³nãu³xa² ã³wxe², a²nũ²a²nãu³xa² ko̱³nxe³ju³ta² kãi³to³te²su² te²nãu³xa² ka³lxa¹te²nãu³xa² ã³wxe², a²nũ²a² ũ³yho³ha³ki²ka² so¹kxi²nẽ³tũ̱³ka̱³txa² ka³lxa¹tũ̱³ka̱³txa² ã³wxe² ain¹sxã³ ĩ³yai³nain¹ta¹hxai²hẽ¹la², a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² Je³su²jah³la² ã³si³tẽ³kxai¹nha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nxe³ju³tai²na² fa³ri³se²a² nũ̱³ka̱³txa², ã³nhai¹tũ³te²nãu³a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² ã³nhai¹tũ³te²nãu³a² ain¹sxã³ ĩ²ain¹ta¹hxai²hẽ¹la². Ĩ²ai¹nha²kxai³ Je³su²jah³la² a²sa³wi³ha³lxi³nãu³xã² ĩ³ye³kxain¹te³nah¹lxi¹: — Wxa²hxi²kan¹jah¹la² a²hi²sen³su² a²nũ²a² ũ³yho³ha³ki²ka² so¹kxi²nẽ³tũ̱³ka̱³txi³su² a²nũ²a²nãu³xa² ko̱³nxe³ju³ta² kãi³te²su² te²nãu³xa² nxe³te²su² ain¹sxã³ ã³wxe³sxã³ ĩ³yain³ya³hain¹ju³tu¹tai²na², ĩh¹nxe³kxa²ya̱n³ti³ta̱³ wãi³na² ã³wxe³sxã³ ĩ³yain³ya³hain¹sĩn¹te²sin²tã³? Wi¹kãi³jah¹lo²sin¹ke³la³te²kxai³ nxe² ĩ³yain³ya³hai¹nhĩ̱³nx2nxa³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nxe³jau³xai²na² Je³su²jah³la² ain³kxain¹tãu³ ĩ³wã²lũ³xain¹te³nah¹lxi¹: — A²nũ²a² wi¹lain³nha² te²hi²sen³su², hai³txi³ hĩ³ne³kxa² wa³kxẽn³yah³la² ã³ten³te²sxa³yu²hẽ³li¹. Yxãn¹ta¹ a²nũ²a² ĩ³ton³te²su² te²a² so¹lxi³, hĩ³ne³kxa² wa³kxẽn³yah³la² ã³ten³te²ju²hẽ³li¹. Jã¹nxe³ha²kxai³ Txai²li¹ hai³txi³ a²nũ²ai²na²: “Wi¹lhin¹sa³nha¹. Ko̱³nxe³ti³ kãi³a¹ju³ta² yũ²nxa³nha¹.” Nxe³te²su² te²na² ĩ³kaix1so¹te³lhxã³ wxãn²nxa³wi¹. Yxãn¹ta¹ a²nũ²a² ko̱³nxe³jah¹la² so¹lxi³ ko̱³nxe³ti³ kãi³ju³ta² ĩ³ãin²ta³kxi²nha²sxã³ ã³na¹la³kxi²nha²te²su² te²na² so¹lxi³ wxa²wa²su¹tain¹te³lhxã³ wxã³na¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nxe³nxa²ha¹te¹ Jo³ãu² Ba³tis²jah³la² sa³wi³ha³lxi³ nũ̱³ka̱³txa² nxe³ha²kxai³ fa³ri³se²a² nũ̱³ka̱³txa² nxe³ha²kxai³ ha¹lin¹tũ̱³ka̱³txa², Txa²wã¹sũ̱³na² ĩ³ka³li³kxi²te³lhxã³, kwa²hãi¹nxe² he³lhxi² yxau³ain¹to³ta¹hxai²hẽ¹la². Nxe³ju³ta² a²nũ²a² wxã³sxã³ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Jo³ãu² Ba³tis²jah³la² a²sa³wi³ha³lxi³nũ̱³ka̱³txa² kwa²hãi¹nxe² heh³lxi² yxau² fa³ri³se²a² nũ̱³ka̱³txa² a²sa³wi³ha³lxi³nũ̱³ka̱³txa² kwa²hãi¹nxe² heh³lxi² yxau², ain¹to³nha³li¹. Yxãn¹ta¹, wxa²sa³wi³ha³lxi³nãu³xai²na² nxe³ain¹to³hxa³wi¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³, wxa²sa³wi³ha³lxi³nãu³xai²na² kwa²hãi¹nxe² heh³lxi² yxau³ain¹to³hxa³ji¹ku¹, sĩ¹na¹nhai¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Yxau³nuh¹nx2ta¹tãu³a² ĩ³ãin²ta³kxi²nha²sxã³ heh³lxi² yxau³yah³lxin¹ju³ta² wai³nxa³wi¹. A²nxe³ju³ta² in³txa² txu¹ha² so¹nyhu¹kxai²nãn²tu̱³, a²ya̱³la²nãu³xã² ĩ³kaix1so¹yhain¹te²ju²hẽ³li¹. Ĩ³kaix1so¹sxã³ ãn³yãn³nũ²kxi²sxã³ kãin² ĩ³yain³ya³hain¹te²ju²hẽ³li¹. Nxe³ju³ta² sa²kxai³lu² a²wẽ³sãi¹ai²na² yxau³ye²yhai¹nhĩ¹na¹ ĩ³kaix1so¹ain¹tũ̱³ka̱³txai²na² ĩ³ãin²ta³kxi²nha²sxã³ heh³lxi² yxau³ain¹ju³ta² wai³nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yxãn¹ta¹ yxan¹nãu³a¹ a²wẽ³sãi¹ai²na² so¹kxain¹sxã³ sa²tã³tĩ̱¹kxi²yhain¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ nxe³hĩ¹na¹ a²nũ²a² ĩ³kaix1so¹ain¹tũ̱³ka̱³txa² ĩ³ãin²ta³kxi²nha²sxã³ heh³lxi² yxau³ain¹ju³ta² wain³tu¹wi¹. Jã¹nxe³ju³kxai³lu² fa³ri³se²a² nũ̱³ka̱³txai²na² sa²kxai³lu² txa²wã¹yah³la²nãu³xu¹tai²na² wãn³txa² sa²yxo²wet1si¹hain¹jau³su² he³lhxi² yxau³ain¹te²ju²hẽ³li¹. Ne³to³ta¹ txa²sa³wi³ha³lxai²na² sa²kxai³lu² ã³waix3tai¹na¹hĩ¹na¹ so¹lxi³ he³lhxi² yxau³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jã¹nxa¹jau³su² a²nũ²a² wã²la² ũ³whi²kxi²nha²ka³lo³ai²na² tĩ³ka³lo³a² ã³ten²ti³kxai²nãn²tu̱³ hai³txi³ tah²ka³lo³a² ũ³nhũ²kxi²sxã³ ũh³yxãi¹ain¹te²sxa³yu²hẽ³li¹. Tah²ka³lo³ai²na² ũh³nhũ²kxi²ki̱³ke³la³te²kxai³ ũ³wha̱t3kxai²nãn²tu̱³ tah²ka³lo³ain²ti³ ĩ³jot1sa²kxai³ tĩ³ka³lo³a² ĩ³jot1txa³ha²kxai³ nxe³sxã³ ã³ten²ti³hĩ̱³nx2na³li¹. Te²yã¹nxe³kxe³hũ̱³nxe² txa²wã¹yah³la²nãu³xu¹tai²na² wãn³txa² a̱in³so¹ki̱³kxai²nãn²tu̱³ hã²wxãn³txa³ Txa²wãn³txa² ũ³nhũ²kxi²ki̱³kxai²nãn²tu̱³ nxe³ju³kxai³lu² wai³nxa³wi¹. Txa²wãn³txa² so¹lxi³ a̱in³so¹kxi³ju³ta² wain³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jã¹nxe³sxã³, hai³txi³ ka³yxuh³xa² wã²lẽn¹ta³ tĩ³ka³lo³ẽn¹ta³ yain³txi³yau³xa² txah²yau³xa² ã³nẽ¹na³wi¹sxã³ ũ³wha̱¹ki̱³te²sxa³yu²hẽ³li¹. Ã³nẽ¹na³wi¹sxã³ ũ³wha̱¹ki̱³ke³la³te²kxai³ a²yain³txi³yau³xai²na² sa²kxai³lu² wã²lẽ¹nai²li² ĩ³txi³ha̱u³kxi²sxã³ ĩ³khot3sxã³ a²yau³xa² ĩ³yẽ¹na³hxa³te²ju²hẽ³li¹. Nxe³ha²kxai³ a²yain³txi³yau³xain²txi³ ãn³tĩ̱¹i² a²ẽ¹nãin²ti³ ã³tĩ̱¹i² nxe³te²ju²hẽ³li¹. Yxãn¹ta¹ yain³txi³yau³xa² tah²yau³xa² wã²lẽ¹na² tah²ka³lo³ẽ¹nãu³a², ã³nẽ¹na³wi¹sxã³ ũ³wha̱¹ki̱³te²ju²hẽ³li¹. Te²yã¹nxe³kxe³hũ̱³nxe² Txa²wãn³txa² a²ha³tih³xa² sa²yxo²we¹tha²kxai³ txa²wã¹yah³la²nãu³xu¹tai²na² wãn³txa² a²ha³tih³xa² sa²yxo²we¹tha²kxai³ nxe³jau³kxai³lu² wai³nxa³wi¹. Txa²wãn³txa² hãi¹nxe³jau³xa¹ sa²yxo²we¹ju³ta² so¹lxi³ wain³na³li¹. Nxe³jau³su² Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nxe³nxa²ha¹te¹, sa²ba³to³ nxe³jut3su², Ju³te²a² nũ̱³ka̱³txa² yxo²ha³kxa¹ ĩ³ye¹nxi²to³jut3su² ain¹to³ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ sa²ba³to³ nxe³ju³tai²na² Je³su²jah³la² a²sa³wi³ha³lxi³nãu³xa² whãi³na¹, yain³txa² wen¹ko³xa² ã³nxai³ain¹ta¹hxai²hẽ¹la². Ã³nxai³ain¹te³na¹ a²sa³wi³ha³lxi³nãu³xai²na² sa²kxai³lu² yain³txa³nã̱³kxa² wxa²ni²lho² ã³si³wxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nxe³nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² ã³nhai¹tũ³te²nãu³xai²na² wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩ²txa²sĩ¹nhẽ³li¹. Ju³te²a² nũ̱³ka̱³txi³su² sa²ba³to³ nxe³tãu³a² a²wa³ka³la² a²yxo²ha³kxa¹ ã³na²xai³ki̱³te²jai¹ti²tu³wi¹. Nxe³yãn¹ta¹ wxa²sa³wi³ha³lxa² jau³jau¹xai²na² sa²yxo²ã³ain¹ti²tu³wi¹, yain³ti³nã̱³kxa² wa²ni²lho¹ai¹nha²kxai³lu¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yxãn¹ta¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ fa³ri³se²a² nũ̱³ka̱³txa² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Sũ̱³na² wha²li¹txã³nxa² ĩ²yah³lxin¹ta²lu¹wi¹. Ta³vi²yah³lu¹tai²na² he³ha²kxai³ a²sa³wi³ha³lxi³nãu³xu¹tai²na² he³hai¹nha²kxai³ nxain¹ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nxe³tãu³u¹tai²na², A³bi³a³ta²rah³lu¹tai²na² wã³nxĩn¹te² si³yxau³ka³txa² nxe³ta¹hxai²hẽ¹li¹. Nxe³nxa²ha¹te¹ Ta³vi²yah³lu¹tai²na² sa²kxai³lu² Txa²wã¹sũ̱³na² sxi²ha² ã³wih¹nũ²la² yain³ti³nũ̱³xai²na² Sũ̱³na² ũ³yho³hi²tũ̱³xai²na² wxa²so¹sxã³ ĩ³yain³kxain¹ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³tũ̱³xai²na² Sũ̱³na² sxi²ha² hau³ko³tũ̱³ka̱³txa² so¹lxi³ yain³ti³nũ̱³su² ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jã¹nxa¹jau³su² ĩ³ye³kxi¹nx2ta¹i¹. Txa²wã¹sũ̱³na² a²hi²sen³su² a²nũ²a² wet1sãn²ka³tu̱³ hã²wxãn³txa³nũ² a²nũ²a² hxi²nũ¹nẽ³te³lhxã³ sa²ba³to³ nxe³ju³ta² ĩ³ye¹nxi²ki̱³ju³ta²nũ³su² hau³ko³kxi²nẽ³ta¹hxai²hẽ¹li¹. Hãi¹nxe³sxã³ a²nũ²a² sa²yxo²wet1si¹ja³kxa³nũ³su² hai³txi³ Txa²wã¹sũ̱³na² sa²ba³to³ nxe³ju³ta² we¹ta¹hxai²nxa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nxe³na¹kxa²yu³su² Txai²na² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²kah³lo²na¹xai²na² sa²ba³to³ nxe³ti³xa² a²wa³kxẽn³yah³lo²sa¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nxe³nxa²ha¹te¹ sxi²ha² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² Je³su²jah³la² ã³wi²xi²ta¹hxai²hẽ¹la². Ã³wi²xi²te³na¹ in³txa² hxi²yã³nãn³ta³kxi²jah¹la² ĩ²yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nxe³ju³ta² sa²kxai³lu¹ a²nũ²a² ã³nũ²kxain¹tũ̱³ka̱³txa² a²hi²sen³kxai³lu¹ Je³su²jah³la² hxi²we²txi²ju³ta² ĩ²te³lhxã³ wahx3nxain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ ko̱³nxe³thin¹sxã³ he³son³kxi²nyhain¹te³nah¹lxi¹: — Sa²ba³to³ nxe³ki̱³tãu³a² hxi²we²txi²kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxa² sa²yxo²ã³kxi³ju³ta² ĩ²ki̱³txai²li¹. Nxe² ko̱³nxe³thin¹sxã³ he³son³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ a²nũ²a² hxi²yã³nãn³ta³kxi²jah¹lai²na² ĩ³ye³kxi²te³nah¹lxi¹: — Ã³wxã³txu¹li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nxe³ha²kxai³lu¹ a²nũ²a² nũ̱³ka̱³txai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Ne³kxa²sah¹lxi³sa²lxi¹. Sa²ba³to³ nxe³ti³xa² wi¹lo²la³kxi² ta̱³nxa² ko̱³txo²la³kxi² ta̱³nxa² ĩh¹ju³ta² wai³nhĩ̱n³te²la¹xã³? Te²yã¹nxe³sxã³ a²nũ²a² ĩ³ya²lu¹ta̱³nxa² we²txi² ta̱³nxa² ĩh¹ju³ta² wai³nhĩ̱n³te²la¹xã³? Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nxe³nũ²la² Je³su²jah³lo²su² te²kxai³lu¹ ĩ³xa̱n³txi³sxã³ a²nũ²a² yxo²ha³kxa¹ sa²wa³ti̱³nha²sxã³ ĩ²sa²sai¹ain¹ta¹hxai²hẽ¹la². Ju³te²a² nũ̱³ka̱³txai²na² a²ya³la³tu̱³jau³xa² yxo²kwĩn¹kxain¹kxe³su² Je³su²jah³la² ĩ³ãin²txi³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Je³su²jah³la² a²wãn³txi³kxai³lu¹ in³txai²na² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³hxi²sin²nhat1sã²nhẽ³li¹. Nxe³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ in³txai²na² sa²kxai³lu¹ sa²hxi²sin²nha²sãn²ka³tu̱³, a²hxi²ka² sa²kxai³lu² ĩ³we²nxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nxe³nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txai²na² wa²li³ain¹sxã³, E³ro²jah³la² a²sa³wi³ha³lxi³nãu³xa² whãi³na¹ ã³nũ²kxain¹ka³tu̱³, Je³su²jah³la² ĩ³su²lhã³ain¹si¹hain¹ja³kxa³nũ³su² he³son³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yxãn¹ta¹ Je³su²jah³lai²na² a²sa³wi³ha³lxai²na² whãi²na¹, a³li³ain¹sxã³ ĩ̱³ye³na² kãin²je³na² ã³nxai³ain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² Ka³li³le²a²ko³xa² a³li³i² ka³lxa¹nũn³tũ̱³ka̱³txi³ ã̱³xa² Ju³te²a²ko³xa² a³li³i² ka³lxa¹nũn³tũ̱³ka̱³txi³ ã̱³xa² Je³ru³sa³lẽ²thĩ³na² a³li³i² ka³lxa¹nũn³tũ̱³ka̱³txi³ ã̱³xa² I³tu³me²a³ko³xa² a³li³i² nũ¹ã¹ Jor³tãu²yau³xa² a²yxo²ha³ti³nhãu³ã¹ a²nũ²a² ka³lxa¹nũn³tũ̱³ka̱³txi³ ã̱³xa² a³li³i² Ti²ro³thĩ³na² a²ti²ta³lo³kxa³nãu³a¹ a³li³i² Si³tõ²thĩ³na² a²ti²ta³lo³kxa³nãu³a¹ a³li³i² ain¹ka³tu̱³ Je³su²jah³la² ãn³si³tẽ³kxain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² Je³su²jah³la² kãi³ũh¹ju³tan¹jau³xa² ain³kxain¹ta¹hxai²hẽ¹la². Ain¹sxã³ tĩ̱³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ain¹ka³tu̱³ Je³su²jah³lo²su² te²kxai³lu² a²nũ²a² ĩ³ton³te²su² te²a² ka³lxa¹txi³nãu³xa² ĩ³we²nxain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ a²nũ²a² ĩ³ton³te² nũ̱³ka̱³txi³ ã̱³xa² ka³lxa¹nũn³tũ̱³ka̱³txa² tĩ̱³nyhain¹sxã³ Je³su²jah³la² wxa²wxai³te³lhxã³ ã³yãn³ja³lxu²sa²tã³nyhu¹i², sa²wxa²li²nyhu¹i² nxe³nyhain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² sa²kxai³lu² Je³su²jah³la² a²wãn³txi³kxai³lu¹ a²sa³wi³ha³lxi³nãu³xai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Ka²no¹a² so¹sxã³ sa²hau³ko³kxi²sah¹lxi³hẽ¹li¹, a²nũ²a² ka³lxa¹tũ̱³ka̱³txai²na² ã³nũ̱²kxi²sa²sxã³ ãn³kho³kxi²sain¹kxa²ya̱n³ti³su¹. Nxa¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nxe³ju³tai²na² ko̱³nxe³te² a²yãu³ka³txi³nãu³xa² hi²sen³su² Je³su²jah³la² ĩ²ain¹to³ha²kxai³ ã³yxo²thu²ka̱³kxain¹ka³tu̱³ ĩ³wxan¹to³te³nah¹lxi¹: — Wxãi²na² Txa²wã¹sũ̱³na² Tah²si¹lxi¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nxe³ha²kxai³ Je³su²jah³la² a²wãn³txi³kxai³lu¹ yxo²xũ̱n³txi³ ĩ³kwa³na³ain¹to³te³nah¹lxi¹: — Txa²wã¹sũ̱³na² Tah²sa¹ju³ta² a²nũ²a²nãu³xai²na² ĩ³yau¹ũ³yah³lxi³txa³hẽ¹li¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nxe³nxa²ha¹te¹, Je³su²jah³lo²kxai³lu¹ wã³la³ka³ta³nãu³a¹ ã³nxai³ain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ a²nũ²a² te³nain¹kxa² so¹lxi³ ĩ³kaix1so¹ain¹ta¹hxai²hẽ¹la². Ain¹sxã³ ĩ³kaix1so¹ain¹tũ̱³ka̱³txai²na² ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","In³txi³nãu³xa² hxi²ka²hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³tũ̱³ka̱³txa² ĩ³nxa³kxi² ĩ³kaix1so¹ain¹ta¹hxai²hẽ¹la². Ĩ³kaix1so¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Kan²txi³ ã³si³tẽ³sah¹lxi³hẽ¹li¹. Sah¹lxin¹kxai²nãn²tu̱³ ĩ³sa²si¹hã³nx2ta¹tu¹wi¹. A²nũ²a² yxo²ha³kxa¹ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa², ĩ³yau¹ũ³hain¹yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ko̱³nxe³te² a²yãu³ka³txa² a²nũ²ai²na² nxũ²kwa̱i³yxau³te²su² te²a² ĩ³ha¹jah³lxin¹kxai²nãn²tu̱³ nxũ²kwa̱i³li³ain¹si¹ha¹jau³su² ĩ³sa²si¹hã³nx2ta¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A²nxe³sxã³ ĩ³kaix1so¹tũ̱³ka̱³txa²sa¹: Si³mãu²ah³la² a²ĩ³lxa² ã̱³xa² Pe²jah³lo²su² nxe³ha²kxai³ ");
INSERT INTO nabNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ti³a²kah³la² Se³be³te²ah³la² a²ta²ha² nxe³ha²kxai³ Jo³ãu²ah³la² Ti³a²kah³lai²na² a²lo³na² nxe³ha²kxai³ a²ha¹lin¹jah¹la²nãu³xai²na² Je³su²jah³la² ãh¹ĩ³yĩ¹li²ta¹hxai²hẽ¹la². — Wxãi²na² ta²li¹ti³hũ̱³ya³hi¹lxi¹. Ya³hin¹ha²kxai³ Bo³a³ner²jah³la² ĩ³yĩ¹li²nx2ta¹i¹. Je³su²jah³la² nxe² ĩ³yĩ¹li²jau³su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Nxe³nxa²ha¹te¹ jã¹nxe³sxã³ ĩ³kaix1so¹tũ̱³ka̱³txa²sa¹: Ãn³tre²ah³la² nxe³ha²kxai³ Fi³li²pah³la² nxe³ha²kxai³ Bar³to³lo³me²ah³la² nxe³ha²kxai³ Ma³te²ah³la² nxe³ha²kxai³ To³me²ah³la² nxe³ha²kxai³ Ti³a²kah³la² Au³fe²ah³la² a²ta²ha² nxe³ha²kxai³ Ta³te²ah³la² nxe³ha²kxai³ Si³mãu²ah³la² nxe³ha²kxai³ a²nxe³te²a² ã̱³lxi³sxã³ se³lo²ti³nũ̱³ka̱³txi³si²ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ Ju³tas² Is³ka³ri³o²jah³la² yxan¹nãu³u¹ta²kxai³ ko̱¹ko̱¹xa² hxi²ka²nãu³a¹ Je³su²jah³la² ã³yũ³ain¹jah¹lo²nũ³su² nxe³ha²kxai³, nxe³ain¹ta¹hxai²hẽ¹la². In³txi³nãu³xai²na² yxo²ha³kxa¹ Je³su²jah³la² a²hi²sen³kxai³lu² ĩ³kaix1so¹ta³lun²ka³tu̱³ sxi²ha² ĩ³xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nxe³nxa²ha¹te¹, a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² ãn³sa²ki³nũ²kxain¹to³ta¹hxai²hẽ¹la². Nxe³kxa²yu³su² Je³su²jah³lai²na² a²sa³wi³ha³lxi³nãu³xai²na² ain¹sxã³, hxi²kan¹ti³ ĩ³yai³nain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nxe³jau³xai²na² Je³su²jah³la² a²ya̱³la²nãu³xã² ain³kxain¹nxa²ha¹te¹ i³sxã³ sa²so¹te³lhxã³ wxã³ain¹ta¹hxai²hẽ¹la². — Wi¹lain³nha²te²la¹ku². Wen¹te²la¹ku². Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nxe³nxa²ha¹te¹ ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² Je³ru³sa³lẽ²thĩ³na² a³li³sxã³ wxã³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lai²na² sa²kxai³lu² Bel³se³bu²ah³la² a²ta³nãu³xa² a²hxi²kan¹jah¹lo²su² ha²kxai³ nxe³jah¹la² a²sa³wit3sin²tai¹. Nxe³te²si¹ha²kxai³ ã³si³tẽ³kxi²ha²kxai³ hxi²kan¹txi³ ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³si¹jau³su² ĩ³ye³kxi²te²sin¹yu²hẽ³li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yxãn¹ta¹ Je³su²jah³lo²su² te²kxai³lu¹ ĩ³kaix1tain¹sxã³ wãn³txai²na² ĩ³yau¹ũ³jau³xai²na² ĩ³yau¹ũ³hain¹te³nah¹lxi¹: — Ha³lo²ai²na² nxe³te²nũ³nhũ̱³na³li¹. A²ta³a² nũ̱³ka̱³txa² a²hxi²kan¹te² si³yxau³tãu³a¹ Sa³ta³na²jah¹lai²la¹wi¹. Nxe³ha²kxai³, hai³txi³ Sa³ta³na²jah¹lo²la³ a²ta³a² nũ̱³ka̱³txi³khai³xa² ãn³sa²tã³hxa³tai¹nx3tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jã¹nxa¹jau³su², a²nũ²a² nũ̱³ka̱³txa² wã²nxũ̱h¹lxi³ ã³nhe¹kxi²yhu¹ain¹kxai²nãn²tu̱³ ya³lu²hxan³kxi²nyhain¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jã¹nxe³sxã³ a²wã³tã̱³xa²nãu³xã² a²nũ²su² te²an²tu̱³ ã³nhai²ta³lxi²sxã³ yxau²xai³lain¹kxai²nãn²tu̱³ hxa³tai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jã¹nxe³ke³la³te²kxai³, Sa³ta³na²jah¹la² a²sa³wi³ha³lxi³nãu³xa² ĩ³yxo²kwĩn¹kxi²nyhu¹sxã³ ã³nhe¹kxi²nyhu¹ke³la³te²kxai³ kan²txi³ yxau³ai¹nhĩ̱³nx2nxa³wi¹. Nain¹kxai²nãn²tu̱³, hxan³khaix1ai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jã¹nxa¹jau³su² sxi²ha² wa³kxẽn³yah³la² nũ̱³kxũn³jah¹lo²su² ye²kxai²nãn²tu̱³ hxi²kan¹ti³ sxi²hai²na² ã³wih¹sxã³ a²yen³kxa² kãi³kxi²ti³hex1nxai¹nhĩ̱³nx2nxa³wi¹. Yxãn¹ta¹ nũ̱³kxũn³jah¹lai²na² i³sxã³ sa²tai³ta³lxi³kxain¹ke³la³te²kxai³ nxe³sãn²nũ²la² sxi²hai²na² ã³wih¹sxã³ a²yen³kxa² yxo²ha³kxa¹ hxi²kan¹ti³ kãi³wxa²so²hxa³thĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. A²nũ²a² a²ten³te²su² te²an²tu̱³ a²ko̱³nxe³ju³ta² ĩ²li³ju³tan²tu̱³ kãi³ain¹kxai²nãn²tu̱³ wãn³txa² ko̱³nxe³jau³xa² Txa²wã¹sũ̱³na² ko̱³nxe³te²lo³jau³xa² ĩ³ye³kxain¹kxai²nãn²tu̱³, hã²wxãn³txa³ ĩ³ãin²ta³kxi²nha²sxã³ ã³yxo²o³tũ²ain¹kxai²nãn²tu̱³ ã³wa²su¹tain¹ju³ta³nũ³a² yũ³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nxe³to³ta¹ wãn³txa² wai³nxa³jau³xa² e³kxain¹jau³kxai³lu¹: “A²ta³a² hxi²kan¹ta² hi²sen³su² Je³su²jah³la² ĩ³hxi²ka¹tin²tai¹.” Nxain¹jau³su² ain¹ta¹ Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² ko̱³nxe³te²lo³tain¹na³li¹. A²nxe³jau³xai²na² sa²kxai³lu² Sũ̱³na² Yãu³ka³jxah¹la² ko̱³nxe³te²lo³jau³xai²na² sa²kxai³lu² hai³txi³ ã³wa²su¹ju³ta² yũ²nxa³wi¹. Te²yã¹nxe³sxã³ yan¹nãu³a¹ ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² a³ya³tain¹ju³ta³nũ³a² yũ³hĩ¹na¹ ã³wa²su¹ju³ta²nũ³a² yũ³ai¹nxa³lho³li¹. Hxi²ki³te²la³ yxau²sa²tẽ³ju³ta³nũ³a² so¹lxi³ yũ³ain¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nxe³ju³ta² ha³la³je¹nĩn³kxai³ ha³te̱h³nxã³nxa² hoh³lxi³su² tũ̱³ka̱³txa² a²wãn³txa²su¹: — Je³su²jah³la² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau²na³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². A²nxe³jau³xai²na² Je³su²jah³la² ĩ³wa²lũ³xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nxe³nxa²ha¹te¹, Je³su²jah³la² a²hã³ka³na² hi²sen³su² Je³su²jah³la² a²lon³ti³tãu³xa² hi²sen³su² wxã³ain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ ha³lo²a² sxi²ha² ti²ta³lo³ka³nãu³a¹ yxau³ain¹ka³tu̱³ Je³su²jah³la² wa²li³si¹hain¹jau³su² ĩ³kaix1tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nxe³ju³ta² a²nũ²a² kãin² tũ̱³ka̱³txa² Je³su²jah³la² ãn³ki³ka³tih³kxa²wxe³ain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² a²wãn³txi³kxai³lu¹: — Nxet3sĩ¹lxi¹. Wxa²hã³ka³na² wxa²lon³txi³tãu³xa² ha³lo²a² he¹ain¹sĩn¹na³li¹. Ĩ³ye³kxi¹nxa²ti³te³nain¹sĩn¹na³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Yxãn¹ta¹ Je³su²jah³la² wãn³txi³kxai³lu¹: — A²nũ²a² ã̱³xa², txa²hã³ka³na² hũ̱³te²su² yũ², txa²lon³ti³tãu³xa² hũ̱³te²su² yũ² nxe³ain¹na³li¹. Nxe³sxã³ ãn³sa²wa³ti³nha²sxã³ a²nũ²a² ã³ki³ka³tih³kxain¹sxã³ ã³wxe³yain¹tũ̱³ka̱³txa² sa²kxai³lu² ĩ²sa²so¹ai¹nha²kxai³ ĩ³ye³kxain¹te³nah¹lxi¹: — Wxãi²na² txa²hã³ka³na² txa²lon³ti³tãu³xã² hũ̱³yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","A²nũ²a² a²ten³te² ten³jau³su² te²an²tu̱³ Txa²wã¹sũ̱³na² a²ten³jau³su² sa²yxo²wet1sxã³ kãi³kxai²nãn²tu̱³ a²nxe³te²su² te²he³la³ku³ txa²lon³su² nxe³ha²kxai³ txa²ha³lĩ³ti³su² nxe³ha²kxai³ txa²hã³ka³nu²su² nxe³ha²kxai³ nxe³te²sain¹na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nxe³nxa²ha¹te¹ Je³su²jah³lo²kxai³lu² ĩ̱³ye³na² a²yxo²ka³te̱h³nãu³a¹ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². Ai¹nha²kxa̱i³ a²nũ²a² kãi²li³khaix1tũ̱³ka̱³txa² ã³nũ²kxain¹ta¹hxai²hẽ¹la². Ai¹nha²kxa̱i³ Je³su²jah³lai²na² sa²kxai³lu², ka²no¹a² ĩ̱³ye³na² sxa³ka³lo³a² ã³wih¹ta¹hxai²hẽ¹la². Ai¹nha²kxa̱i³ kãi²li³tũ̱³ka̱³txai²na² sa²kxai³lu² a²yxo²ha³kxa¹, ĩ̱³ye³na² a²yxo²ka³te̱h³nãu³ai²na² yxau³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A²nxe³tãu³a² Je³su²jah³la² hi²sen³su² wãn³txa² ĩ³yau¹ũ³jau³xa² yau³ka³lxa¹txi³ ĩ³tih³nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ĩ³tih³nxain¹te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. A²nũ²a² hai³sxa² wa³kxẽn³yah³la² yain³txa³ki³a² wi¹ki³a² wxa²sa²tãu³wa³ya²txũ³lhain¹sxã³ ũ³whĩ̱¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ũ³whĩ̱¹tãu³a² ki³ka³na³ku² ki³su² ki³a² tĩh³na² yxo²ki³sa² ã³yun¹na³nũ²nhai¹. Ã³yun¹na³tãu³ a̱i³ka² wxã³sxã³ yai³nhxa³je²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ãh¹ki³ka³na³ku² ki³su² ki³a² kxĩh³nũ̱³xa² a̱u³txi³ tah³lxa² yũ³ko³xa² ã³yun¹na³nũ²nhai¹. A²nxe³ kxĩh³nxai²na² kxĩh³nxa² a̱u³lxa³ha²kxai³ wa³su³txi³ ka³lũ̱³ye²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ka³lũ̱³ye²te³na¹ u³je³na³kai²li² wxa²ki³ka³la³ka³tu̱³ ĩ³wa³ne²nũ²sxã³ wãn³txi³ye²nũ²nhai¹. Nxe³ju³tan¹te²kxa³ya̱³tu̱³ yain³ta³ki³a² a²nxe²kxa² a̱u³txi³ sxa²nxa³ha²kxai³ ya²lun¹txi³ye²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ãh¹ki³ka³na³ku² ki³su² ki³a² ha³lo²a² ũ³yen³ko³xa² ã³yun¹na³nũ²nhai¹. A²nxe³ki³ai²na² sa²kxai³lu² ka³lũ³xi²ye²nũ²nhai¹. Nxe³ta¹ ũ³yen³ko³su² ha²kxai³ hi³a² kha¹ka³txa² ka³lxa¹txi³ ka³lũ³ye²nũ³nha²kxai³ nxe³te²kxai³lu² yain³ta³nxe²kxa² wa³ne³sa³te³kxi²sxã³ ya²lun¹txi²ye²ha²kxai³ hai³txi³ wi¹ki³la³ ã³ki³i²yhe²nxa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nxe³yãn¹ta¹ ãh¹ki³ka³na³ku² ki³su² ki³a² kxĩh³nũ̱³xa² ti̱³ti̱n³tũ̱³xa² ã³yun¹na³nũ²nhai¹. A²nxe³ki³ai²na² sa²kxai³lu² wi¹ka³lũ̱³ha²kxai³ wi¹we¹nha²kxai³ yain³txa² kãin² ki³kan²kxi²ha²kxai³ kãin² sxa³ye²nũ²nhai¹. A²nxe³ki³ai²na² sa²kxai³lu² ã³nhai¹tũ³ta³ki³sa² ki³an²tu̱³ kũ³we²ki²la² ka³lxa²nxa³txi³ ãn³ki³i¹yhe²ha²kxai³, ã̱h¹ã³nhai¹tũ³ta³ki³sa² ki³an²tu̱³ ka³lxa¹txi³ ã³ki³i¹yhe²ha²kxai³, hã²wxãn³txa³ ãh¹ ã³nhai¹tũ³ta³ki³sa² ki³an²tu̱³ wa̱³li̱³kha³lhon¹txi³ ãn³ki³i¹yhe²ha²kxai³ nxe³ye²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jã¹nxa¹jau³su² wi¹ko̱³nyah¹lxi³ti³ten³nxa²lxin¹kxai²nãn²tu̱³, wi¹lain³kxi¹sah¹lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ain¹ka³tu̱³, hã²wxãn³txa³ ye³jen¹nãu³kxai³ kãi²li³tũ̱³ka̱³txai²na² a³li³yai¹nha²kxai³ Je³su²jah³la² nũh¹yxau³hĩn¹kxai³ a²sa³wi³ha³lxi³nãu³xa² nxe³ha²kxai³ a²nũ²a² on³sxã³ he¹yain¹tũ̱³ka̱³txa² nxe³ha²kxai³ whãi²na¹ Je³su²jah³lai²na² ĩ³wã̱³txain¹te³nah¹lxi¹: — Wãn³txa², ĩ³yau¹ũ³jau³xai²na² ĩ³ye³kxi²sa²nhĩn¹jau³xai²na² a²si³yxau³tãu³a² ĩ³tih³nxe³sa²sĩ¹nhẽ³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Wxa²yu³tai²na² so¹lxi³ wãn³txai²na² tah²yau³xai²na² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² a²nũ²a² ẽ¹nãu³a² sa²hau³ko³jau³nũ³su² nxe³jau³jau¹xai²na² txa²nũ² ã³ne³wxe³yah³lxin¹tu¹wi¹. Yxãn¹ta¹ tũ̱¹ka̱³txai²na² hĩ¹na² ti³he¹xai¹nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nain¹kxai²nãn²tu̱³, Wi¹lĩ²ain¹kxa²ha³ta̱³nxãn²ti³ wi¹ne³ka¹nain¹kxa²ha³ta̱³nxãn²ti³ ã³ne³wxe³ai¹nhĩ̱³nx2nxa³wi¹. Ã³ne³wxe³ain¹ke³la³te²kxai³, a²ko̱³nxe³ti³ kãi³ain¹ju³ta² sa²ne³wa³ti̱³nhai¹nha²kxai³ sa²wa²su¹tai¹nhĩ̱³nx2na³li¹. Jã¹nxain¹kxa²ya̱n³ti³su², Txa²wã¹sũ̱³na² wãn³txa² ĩ³yau¹ũ³jau³xai²na² so¹lxi³, ĩ³ye³kxain¹na³li¹, a²nũ²a² ã̱³xa²su¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jã¹nxe³jau³su² Je³su²jah³la² wãn³txi³kxai³lu² a²sa³wi³ha³lxi³nãu³xa² ĩ³ye³kxain¹te³nah¹lxi¹: — Wãn³txa² ĩ³yau¹ũ³jau³xa² ka³lxa²na³li¹. Nxe³jau³jau¹xai²na² ĩ³ye³kxi¹nx2ta¹jau³xai²na² ã³ne³wxe³yah²lxa³lxi¹. Yxãn¹ta¹ jau¹xai²na² ha³ta̱³nxãn²txi³ ã³ne³wxe³yah²lxan³kxai²nãn²tu̱³, ĩh¹nxet3sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² yxo²ha³kxa¹ ã³ne³wxe³yah³lxi³hĩ̱³nxãn¹te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jã¹nxa¹jau³su² wãn³txai²na² e³kxi¹nx2ta¹jau³xai²na² a²si³yxau³tãu³a¹ ĩ³yau¹ũ³nx2ta¹tu¹wi¹. A²nũ²a² yain³txa³ki³a² wxa²sa²tãu³wa³ya²txũ³lhain¹sxã³ ũ³whĩ̱¹jah¹lo²su² te²an²tu̱³ a²nũ²a² Txa²wã¹sũ̱³na² wãn³txa² ĩ³ye³jah¹lo²su² kxa²yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A²ki³ai²nãn²tu̱³ tĩh³na² yxo²ka³teh³nãu³a² ã³yun¹na³sxã³ sxa³ye²ki³ai²nãn²tu̱³, a²nũ²a² ã̱³xa² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²kxa² yã¹nxe³te²ju²hẽ³li¹. Yxãn¹ta¹, ain³kxain¹tãu³a¹, kwẽn¹ta²kxai³, Sa³ta³na²jah¹la² a²ta³a² hxi²kan¹jah¹lan²tu̱³ wxã³sxã³ a²wãn³txa² wi¹jau³xai²na² ã³wa²lho¹kxain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jã¹nxe³sxã³ a²ki³ai²nãn²tu̱³ tah³lxi³ju³tai²na² ã³yun¹na³ki³kxa² yã¹nxe³ju³tan²tu̱³, a²nũ²a² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²kxa² yã¹nx2na³li¹. Te²nãn²tu̱³ a²wãn³txai²na² ain³kxain¹ka³tu̱³ ĩ³ka³li³hai¹nha²kxai³ wãn³txai²na² te³nain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yxãn¹ta¹ te²na² yain³txa³ka³ta² a²nxe²ka² yũ²nxa³kxe³yã¹nxe² yxau²xai³jah¹lo²yã¹nx2na³li¹. Nxe³ha²kxai³ a̱u³txi³ yxo²ĩ²xa³kxe³su² ha³lo²a² ko̱³nxe³to³nha²kxai³ Sũ̱³na² wãn³txa² ain³kxi²ju³tan¹te²kxa³ya̱³lhu² ĩ³khãuh³lxa³thi¹nai¹nha²kxai³ nxe³te²ju²hẽ³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² wãn³txai²na² wa³su³txi³ sa²yxo²ã³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A²ki³ai²na² ha³lo²a² ũ³yen³ko³nãu³a² ã³yun¹na³ki³kxa² yã¹nxe³ju³tan²tu̱³ a²nũ²a² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²kxa² yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Yxãn¹ta¹ ha³lo²a² hxi²waut3ta³lxi³nha²khaix1nxe³ha²kxai³ a²yen³kxa² ta̱³nxa², a²ha³te̱h³nxã³nxa² yo³hi²ki̱³txã³nxa² ta̱³nxa² kãin² yxo²kwa̱i³nai¹nha²kxai³, Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ã³na¹ain¹sxã³ kwa² wa³ni̱³lon³sxã³ yxau²xai³lai¹nha²kxai³ nxe³kxa² yã¹nxain¹na³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² Sũ̱³na² wãn³txa² sa²yxo²we¹tain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ãh¹ki³ai²nãn²tu̱³, kxĩh³nũ̱³xa² ti̱³ti̱n³tũ̱³xa² ã³yun¹na³sxã³ sxa³ye²ki³ai²nãn²tu̱³ wa̱³li̱³kha³lhon¹sxã³ ãn³ki³i¹yhe²nũ²nhai¹. Nxe³kxa² yãx1ju³tai²nãn²tu̱³, a²nũ²a² Txa²wã¹sũ̱³na² wãn³txa² ain³kxa²so¹sxã³ kan²txi³ i³te²ju²hẽ³li¹. Nxe³te²a² ã³nhai¹tũ³tũ̱³ka̱³txa² ĩ²li³te²a² jũ¹nxe² wi¹lhin¹sxã³ sa²yxo²wet1sai¹nha²kxai³ ãh¹ ã³nhai¹tũ³tũ̱³ka̱³txa² ãh¹ ĩ²li³te²a² wi¹lhin¹sxã³ sa²yxo²wet1sai¹nha²kxai³ ã̱h¹li³nũn³sxã³ ã³nhai¹tũ³tũ̱³ka̱³txa² ãh¹ ĩ²li³nũn³te²a² wi¹lhin¹khai¹nxe³sxã³ sa²yxo²wet1sai¹nha²kxai³, nxe³kxa² yã¹nx2na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³te³nah¹lxi¹: — Ĩh¹nxe³te³lhxã³ sa²kĩx3ki̱³tẽ³na² ũ³thũ²sxã³ sxi²hẽ¹nãu³a¹ tẽ³sxã³ ã³wih¹ki̱³te²la¹xã³? Hai³txi³ kwa³ta³lẽ³na² ũ³tĩ̱¹kxi²wxe³ki̱³sxa³ha²kxai³ hai³txi³ ka²ma²ka³lo³a² sxa³sxã³ ãu³xi²ki̱³ka³lo³a² a²yu³hẽ³nãu³a¹ ũh³wxe³ki̱³sxa³ha²kxai³ nxe³ki̱³te²sxa³yu²hẽ³li¹. Yxãn¹ta¹ kĩn³txi³ ũh³wxe³ki̱³kxai²nãn²tu̱³ sxi²hẽ¹nãu³a¹ whãi²na¹ wxa²ko²ko²ta²nẽ¹te²jai¹ti²ti¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jã¹nxa¹jut3su² kxãn³nãu³ãn²tu̱³ Txa²wã¹sũ̱³nu²kxai³lu² oh³na² yxau³jah¹la²kxai³lu² yen³kxa² hãi³te²a² whãi²na¹ wã²nã³ũ¹nx2ti³tu¹wi¹. Jã¹nxe³sxã³ Txa²wã¹sũ̱³na² yen³kxa² ũ³ho¹ain¹kxa² whãi²na¹ ĩ³yau¹ũ¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jã¹nxa¹jau³su² wi¹ko̱³nyhah¹lxi³ti³ten³nxa²lxin¹kxai²nãn²tu̱³ Txa²wãn³txai²na² wi¹lain³kxi¹sah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wxa²kãi³nyhu¹ah³lxin¹kxa² yã¹nxe² Txa²wã¹sũ̱³na² kãi³ũh¹nx2ti³tu¹wi¹. Ã³wa²to²hi² kãi³ũh¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A²nũ²a² yen³kxi³nh²te²na² ãh¹ kãi²non³sxã³ yen³kxa² ũ³hũ¹nyhain¹tu¹wi¹. Yxãn¹ta¹ a²nũ²a² yen³kxi³txa²jah¹la² yen³kxa²jũ¹nxe² yũ³kxan²ti³ sa²sai¹xi²hxa³tain¹tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Nxe³ha²kxai³la¹, ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wãn³txa² ĩ³yau¹ũ¹nx2ta¹jau³xa² yã¹nx2na³li¹. Nxe³te³nah¹lxi¹. A²nũ²a² hai³sxa²nãu³a¹ yain³txa³ki³a² wxa²sa²tãu³wa³ya²txũ³lhain¹sxã³ ũ³whĩ̱¹nũ²nhai¹. Nxe³ka³tu̱³, ka³nxah³ti³na² ãu³xi² a³lan²tin³na² ĩ³sa²yxau² jã¹nxe² jã¹nxe² nxe³kxai²nãn²tu̱³ a²ki³ai²nãn²tu̱³ wi¹ka³lũ̱³xi² wi¹we¹ni² ye²nũ²nhai¹. Yxãn¹ta¹ a²nxe³ki³ai²na² ĩh¹nxet3sxã³ wi¹ka³lũ̱³sxã³ wi¹wen¹te²sin²ta²ku². Ki̱³nhai¹. Ko̱³nxe²ki̱³sxa³nhai¹. Nũ²nhai¹. Nxe³kxa² yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","29","Kxĩh³nũ̱³nãu³a¹ yxau³te²ki³a² kwa²hãi¹nxe² ãn³ki³i¹yhe²nũ²nhai¹. A²wi¹lhĩn¹ju³ta² kã̱un³sxã³ ka³lũ̱³ka³tu̱³ a²nxã³nxa² ka³lũ̱³ka³la²na³na¹. Nxe³ka³tu̱³, a²wxi²a² ã³wxi²i²sxã³ ã³wxi²kan²kxi²na³na¹. Nxe³ka³tu̱³ hai³sxa² wa³kxẽn³yah³la² wãn³txi³kxai³lu¹: “Ka³ya̱³txa² kan¹na²hẽ³ni¹. Wxa²nãu²so¹jah³lxi³hẽ¹ni¹.” Nxe³nũ²nhai¹. Txa²wãn³txa² yã¹nx2na³li¹. Wxa²ẽ¹nãu³ai²na² a³la³kxi² kãi²non³tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ãh¹lxi³sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wãn³txa² ĩ³yau¹ũ³nx2ta¹jau³xa² yã¹nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nxe³te³nah¹lxi¹. Yain³txa³ki³a², Mos³tar²ta³ki³a² yã¹nx2na³li¹. Nxe³ki³ai²na² kxĩh³nũ̱³xa² ũ³whĩ̱¹ki̱³tãu³a¹ hĩ³ne³ka³ki³a² yxo²ha³kxa¹ ki³jũ¹lxi²sa²sai¹ki³ai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","A²nxe³ki³ki¹ai²na² ki³jũ¹lxi³khai¹nxe³ki³su² kxan²ti³ ta³ki¹ai²na² ka³lũ̱³nũ²la² wi¹wen¹nũ²la² hai³sxan¹tẽ³kxa² ã³wa²tot1sa²sai¹nũ²nhai¹. Hi³a²khai³xa² wen¹nũ²nhai¹. Nxe³sxã³ a̱i³ka² ã³wxã³ha²kxai³ yeh²nxi³nũ²nhai¹. Nxe³kxa² yã¹nxe³sxã³ Txa²wãn³txa² sa²yxo²we¹jah³lxin¹kxai²nãn²tu̱³ wi¹la² ĩ³ã̱³lxa³ti³hi¹txã²ti³tu¹wi¹. Nxe³sxã³ a²wi¹lhĩ¹na² jũ¹nxa² so¹lxi³ yxo²ĩ²sah¹lxin¹kxan²ti³ ye³jen¹na² ĩ³kãi²non³sxã³ yxo²ĩ²sah¹lxin¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jã¹nxe³sxã³ wãn³txa² ĩ³yau¹ũ³jau³xa² ka³lxa¹jau³xa² te²u¹jã¹nxe³jau³xa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². A²nũ²a² hxi²kan¹ti³ wi¹ko̱³nyhain¹kxa² yã¹nxe³sxã³ ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wãn³txa² ĩ³yau¹ũ³jau³xa² so¹lxi³ ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²si³yxau³tãu³khai³xai²na² sa²kxai³lu² a²sa³wi³ha³lxi³nãu³xa² so¹lxi³ wã²nxũ̱h¹ ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nxe³nxa²ha¹te¹ sũ²ni²khai¹nxũ²la² Je³su²jah³la² wãn³txi³kxai³lu¹ a²sa³wi³ha³lxi³nãu³xa² ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩ³ye³na² Ka³li³le²a² ye³na² yxo²ha³ti³lhi³a³sah¹lxi³wxi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nxe³te³na¹, a²nũ²a² nũ̱³ka̱³txa² ka³lxa¹txi³ wxã³sxã³ ãn³sa²ki³nũ²kxain¹tũ̱³ka̱³txa² ĩ³sa²si¹hã³yhain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ Je³su²jah³lo²su² te²kxai³ a²sa³wi³ha³lxi³khai³nũ̱³ka̱³txa² sa²kxai³lu² whãi²na¹ ka²no¹a²ka³lo³ai²na² ũ̱h³nxũ̱³sa²tã³nũ̱¹xi²sxã³ ai³ain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² ka²no¹a² ã̱³ka³lo³a² kũ³we²ki²la² ka³lxa²nxa³ka³lo³nãu³xa² ai³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nxain¹tãu³a² kãin² sa²xit3jain¹ta¹hxai²hẽ¹la². Sa²xit3sxã³ ĩ̱³yau³xa² sa²so¹sxã³ sa²ta³kãu³sxã³ sa²ka²la¹so¹ain¹ta¹hxai²hẽ¹la². Ka²no¹ai²na² ĩ³ni³sa²wi¹sxã³ ã³nũ̱¹te³lhxã³ yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nxe³hĩ¹kxai³lu² Je³su²jah³lo²su² te²kxai³lu² ka²no¹a² si³ka³la³nhãu³ã¹ sxa³sxã³ ãu³xi²nũ²la² wã²la²ka³lo³a² ãn³ne³ka²la¹nha²sxã³ sxa³sxã³ ãu³xi²ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xai²na² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³tu¹lxi²si¹hain¹jau³xa²sa¹: — Tih³nxe³sa²jah¹lãi³. Nxet3sĩ¹lxi¹. Ĩ³lo³nxi²nẽ³te³lhxã³ sĩn¹na³li¹. Hxi²waun³ta²kxi¹nha²sĩn¹nxãn³ji¹wi¹? Yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nxe³nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu¹ ĩ³sa²yxau³sxã³ i³txai²na² ĩ³kwa̱i²kwa̱i²kxi²ha²kxai³, ĩ̱³yau³xai²na² ĩ³ye³kxi²ha²kxai³: — Ã³yit1sxã³ ã³nhãu²no³txa²sã²nhẽ³li¹. Nxe³ta¹hxai²hẽ¹la². Nxe³sxã³ i³txai²na² ã³wxe², ĩ̱³ye³nai²na² ã³nhãu²no³ti² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nxe³ha²kxai³lu¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ yu̱h³li³nx2ti³ji¹wi¹? Hãi¹nxe³sxã³ Txa²wã¹sũ̱³na² so¹lxi³ yxo²ĩ²jah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xai²na² sa²kxai³lu¹ ĩ³yon²ta³kxi²nha²sxã³ ĩ³ye³kxi²nyhu¹te³nah¹lxi¹: — Ĩh¹nxe³jah¹lo²ta̱n³te²la¹xã³? Jah¹lai²na² wãn³txa² it3ta² ũ̱n³ju³ta² ã³wxe³si¹jau³su² ĩ̱³ye³na² sa²hãu²not3si¹jau³su² nxe³ten¹tu³wi¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nxe³nxa²ha¹te¹ ĩ̱³ye³nai²na² ã³yxo²ha³ti³sai¹ain¹ta¹hxai²hẽ¹la². Nxe³sxã³ ha³lo²a² Je³ra²sa² nũ̱³ka̱³txa² yxau³ta³ko³xa² ã³wi¹hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ã³wi¹hain¹tãu³a¹ Je³su²jah³lai²na² ka²no¹a² a³li³tãu³a¹ a²nũ²a² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau³jah¹lo²su² te²kxai³lu¹ ne³khau²hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","A²nxe³jah¹la² ya³lu²te²a² sa²nĩ̱³kxi²ko³nãu³a¹ yxau³jah¹lo²su² ta¹hxai²hẽ¹la². Hai³txi³ a²nũ²a² ã̱³xa² hxi²kan¹ti³ ũh³wxe³ain¹ta¹hxai²nxa³hẽ¹la². Ye³ka³lxa¹txi³ kwa³thi³lĩh³na² sa²hxi²kĩ¹i² sa²yu̱x3kĩ¹i² nain¹to³kxan²ti³ ya³lot3sxã³ ĩ³hxau³kxi²nyhain¹to³ta¹hxai²hẽ¹la². Hxi²kan¹ti³ ĩ³hau³kot3tain¹to³ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A²nxe³jah¹la² ya³lu²te²a² sa²nĩ̱³kxi²ko³nãu³a¹ nũh¹yxau² wã³la³ka³txa²nãu³a¹ nũh¹yxau² ka³nxah³ti³na² wxan¹to³hi² tah³lxa³ka³ta² to̱¹ka³ta² ũ³yho³li³nha²to³hi² a³lan²ti³nha² jã¹nxe³to³hi² nxe³yain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nxe³nxa²ha¹te¹ jah¹lai²na² sa²kxai³lu² Je³su²jah³la² u²ten³sa²tã³sxĩ²tãu³ yãn³txi³ ĩ³ha²no¹nha²kxai³ Je³su²jah³lai²na² ĩ³sa²nẽ¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — A²ta³a² ko̱³nxe³jah¹lãi³. Wa²li³txu¹li¹. Jah¹lai²na² wxa²nxũ²kwa̱i³li³txu¹li¹. Ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ in³jah¹lai²na² sa²kxai³lu¹ wxan¹te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²wã¹sũ̱³na² Si³yxau³jah¹la² Tah²si¹lxi¹. Ĩh¹nxe³sa²te³lin¹ji¹wi¹? Ĩ³khãu³lhxa³ti³sa²txa³hẽ¹li¹. Txa²wãn³txai²na² ĩ³wã̱³txi³sain³nxa²ha¹jau³xai²na² Txa²wã¹sũ̱³na² hi²sen³su² oh³nãu³a¹ yxau³jah¹la² hi²sen³su² ain³kxi²sa²jau³xai²la¹i¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — Ĩh¹nxet3sxã³ ĩ³yĩ¹li²nhãn¹ji¹wi¹, wxa²ĩ³lxa²su¹? Ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ jah¹lai²na² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Txa²ĩ³lxa² Yxo²ka³lxa¹jah¹lo²sa¹wi¹, ka³lxa¹khaix1te²sa²sĩ¹nha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jã¹nxa¹jau³su² ta²ko¹xai²na² a³li³si¹sa²nhĩn¹jau³su² ĩ³sa²si¹hã³sa²sĩn¹txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nxe³hĩ¹nãu³a² wã³la³ti²ka³nãu³a¹ ka³yxuh³xa² kwa³jan³ta² yxa³kxa² ũ³yhait1ho³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nxe³ain¹ye²ha²kxai³ a²ta³a² nũ̱³ka̱³txa² a²wãn³ti³kxai³lu¹ Je³su²jah³la² ĩ³wã̱³txi³sain³te³nah¹lxi¹: — Yxa³kxa³nãu³xai²na² ĩ³sa²si¹hã³sa²sĩ¹nhẽ³li¹. Ka³yxuh³xai²na² ã³nxũ²kwa̱i³wi¹ti³ten³sa²sĩn¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³ti³kxai³lu¹: — Jã¹nxe³jah³lxi³hẽ¹li¹. Nxe³sxã³, a²ta³a² nũ̱³ka̱³txai²na² sa²kxai³lu² in³txai²na² wxa²nxũ²kwa̱i³li³ain¹sxã³, yxa³kxi³nãu³xai²na² ã³nxũ²kwa̱i³wi¹hain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ yxa³kxa² ka³lxa¹tũ̱³ka̱³txa² sa²kxai³lu² yxo²ha³kxa¹ a²wã³la³ti²ka³nãu³ai²na² ã³ni³hi²kan³sxã³ ĩ̱³yen³nãu³ai²na² ã³yu¹nũ̱³sxã³ ĩ³lo³nxi² ya²lun¹ti²hxan³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nxe³ha²kxai³lu¹ yxa³kxa² nũ̱³ka̱³txai²na² a²wa³kxẽn³ti³nãu³xa² sa²kxai³lu² yuh³lxa³txi³ ã³ni³hain¹ta¹hxai²hẽ¹la². Sxi²yhe³nai²na² ã³ni³hi² Je³ra²sa² nũ̱³ka̱³txa² a²ko³xai²na² yxo²ha³kxa¹ ã³ni³hi² nxe³ain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ ha³lo²ai²na² ĩ³ye³kxa²sa²sai¹ain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³, a²nũ²a² yxo²ha³kxa¹ aun³ti² wxã³ain¹ta¹hxai²hẽ¹la², ha³lo²ai²na² ĩ²te³lhxã³ka². ");
INSERT INTO nabNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aun³ti² wxã³ain¹ka³tu̱³ Je³su²jah³lai²na² ĩ³ha¹txai¹nha²kxai³ in³txai²na² a²ta³a² nxũ²kwa̱i³li³nyhain¹jah¹lai²na² ĩ²ai¹nha²kxai³, nxe³ain¹ta¹hxai²hẽ¹la². In³txai²na² wã²la² wi¹wi²kxi²nha²sxã³ yxau³ha²kxai³ wi¹lxon³kxi² yxau³ha²kxai³ ta¹hxai²hẽ¹la². Nxe³ju³ta² a²nũ²a²nãu³xai²na² ĩ²ain¹tãu³, yu̱h³lã¹khaix1ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","18","Nxe³ju³ta² sa²kxai³lu¹ a²nũ²a² ha³la³je¹nai³kxai³ ha³lo²a² ĩ²ain¹tũ̱³ka̱³txa² sa²kxai³lu¹ ĩ³ye³sxã³ aun³ti² wxã³ain¹tũ̱³ka̱³txai²na² ĩ³hen³txain¹ta¹hxai²hẽ¹la². Ĩ³hen³txain¹te³nah¹lxi¹, a²nũ²a² ko̱³nxe³te² a²yãu³ka³txi³nãu³xai²na² nxũ²kwa̱i³yxau³jah¹la² we²nxi²ju³ta² ha³ta̱³nxain²txi³ ĩ³yau¹ũ³ai¹nha²kxai³ yxa³kxa² nũ̱³ka̱³txa² ĩ³ya²lun¹ti³ju³ta² ĩ³yau¹ũ³ai¹nha²kxai³ ta¹hxai²hẽ¹la². Ai¹nha²kxai³ a²nũ²a² aun³ti² wxã³ain¹tũ̱³ka̱³txai²na² ain³kxain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²ha³lo²a² ko¹xai²na² wxa²li³txa²sĩ¹nhẽ³li¹. Ta¹hxai²hẽ¹la². Nxe³hĩ¹kxai³lu¹ Je³su²jah³lai²na² sa²kxai³lu¹ wa²li³te³lhxã³ nxe³ha²kxai³ ka²no¹a² ã³wih¹ka³tu̱³ a²nũ²a² a²ta³a² nxũ²kwa̱i³li³yain¹jah¹la² wxã³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Ã³si³tẽ³nxa²ha¹ju³ta² ten³khaix1sa³nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yxãn¹ta¹ hai³txi³ Je³su²jah³lo³la³ hãi¹nxe² wxã²nã¹ta¹hxai²nxa³hẽ¹la². Nxe³ju³kxai³lu¹ Je³su²jah³la² a²wãn³ti³kxai³lu¹: — Wxa²sxi²yhe³na² wxa²ya̱³lxi³nãu³xa² sxi²ha² ĩ³txu¹li¹. Nĩn¹ka³tu̱³ Txa²wã¹sũ̱³na² kãi³kxi¹nxa²ju³ta², ĩ³hen³txi³txai¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nxe³nxa²ha¹te¹ jah¹lai²na² sa²kxai³lu² ĩ³sxã³, a²sxi²yhen³nãu³xai²na² hxi²ka² hxan³jen³nãu³xa² yxo²ha³kxa¹ ĩ³hen³txain¹ta¹hxai²hẽ¹la². Je³su²jah³lai²na² kãi³kxi²ju³ta² ĩ³hen³txi³sxã³ ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². Nxe³sxã³ a²nũ²a² yxo²ha³kxa¹ kãin² ĩ³wã̱³wã̱³txi³kxi²nhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nxe³nxa²ha¹te¹, ĩ̱³ye³na² a²yxo²ha³tih³nãu³a¹ Je³su²jah³lai²na² ka²no¹a² ã³yxo²ha³ti³sa²sai¹ka³tu̱³ a³li³hĩ¹na¹ a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² sa²kxai³lu² ã³nũ²kxain¹sxã³ yxau³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Nxe³ju³ta² in³txa² a²ĩ³lxa² Jai²rah³la² ta¹hxai²hẽ¹la². A²nxe³jah¹la² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² a²hxi²kan¹jah³lo²su² ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ Jai²rah³lo²su² te²kxai³lu¹ wxã³sxã³ Je³su²jah³la² ĩ²ain¹ka³tu̱³, ãn³ka̱³ti̱³wxe³sxã³, ĩ³wã̱³txain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²ka³ne³lxa² ya³lu²kxi²sa²tẽ³na³li¹. Wxã³sxã³ txa²ka³ne³lxai²na² wxa²wxai³kxi¹sẽ¹li¹. Nĩn¹kxai²nãn²tu̱³ we²nxi²xi²tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nxe³ha²kxai³ Je³su²jah³lai²na² sa²kxai³lu², Jai²rah³la² ã³si³tẽ³kxa² ã³nxai³ain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² ã³ki³ka³ti³kxain¹sxã³ ãn³kax3tũ̱³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Nxe³nxa²ha¹te¹ a²nũ²a² ka³lxa¹tũ̱³ka̱³txai²na² nxe³tau³ta² ka³na³ka³na³ta¹ka³lxu³su² ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxai²na² kãin² ĩ³ton³to³ta¹hxai²hẽ¹la². Hxi²ka²hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³sxã³ kwẽ³ko³nhĩ¹nai³ta² sa²kxai³lu², ĩ³si³ti³hon³ka³txa² ã³nĩ³ton³ ãn³si³wxe³ta¹hxai²hẽ¹la². Nxe³ha²kxai³ hĩ³ne³kxa² hoh³lxi³sa²jah³la² ĩ³ta³ka³txai²na² o²la³kxi²te³lhxã³ a²ha³te̱h³nxã³nxa² ũ³yho³hi²txã³nxa² hãi¹nxe³ti̱³xa² ũ³hũ¹hxa³tain¹kxan²ti³nũ¹ hai³txi³ we²nxi²ti³hex1ta¹hxai²nxa³hẽ¹la². Hãi¹nxe³sxã³ khãuh³lxi³ton³nha²ha²kxai³ hãi¹nxe³sxã³ ã²la² kãin² ĩ³ton³to³ha²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nxe³nxa²ha¹te¹ ta¹ka³lxai²na² sa²kxai³lu² Je³su²jah³la² a²nũ²a² ĩ³ton³te²su² te²a² we²txi²jau³su² ain³kxi²nha²ta¹hxai²hẽ¹la². Nxe³ha²kxai³ wxã³sxã³ Je³su²jah³la² ĩ³hit1sxã³ ã³ya̱u³son³kxi²ka³tu̱³ a²wã²la²ka³lo³a² wxa²to³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nxe³ju³ta² ta¹ka³lxai²na² a²ẽ¹nãn¹jau³la³ ĩ³ye³kxi²nha²te³nah¹lxi¹: — Je³su²jah³la² a²wã²la³ka³lo³a² he³la³ku³ wxa²to³kxi²na¹kxai²nãn²tu̱³ we²nxi²sa³tũ¹xã¹. Nxe³nha²sxã³ wxa²to³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wxa²to³kxi²ka³tu̱³ wa³su³txi³ ĩ³ta³ka³txai²li² we²nxi²ta¹hxai²hẽ¹la². — Txa²nũ²ai²na² wa²su¹wa²sun¹khaix1sa³nhã¹. Nxe³nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nxe³nxa²ha¹te¹, Je³su²jah³la² a²ẽ¹nãn¹jau³kxai³lu¹: — Txa²sĩ̱³na² wi¹la¹tãu³a² so¹kxi²sain¹na²na¹. Nxe³nha²ta¹hxai²hẽ¹la². Nxe³ha²kxai³ a²nũ²a² nũ̱³ka̱³txai²na², a²nxũ²kwa̱i³ye³la³nãu³a¹ ã³sa²wa³ti̱³nha²sxã³ ĩ³ye³te³nah¹lxi¹: — Ĩh¹te²la³ta̱³ txa²wã²la³ka³lo³ai²na² wxa²to³syah¹lxin¹si²lxi¹? Nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","32","Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xa² a²wãn³txi³kxai³lu¹ ĩ³ye³li³te³nah¹lxi¹: — A²nũ²a² kãi²li³tũ̱³ka̱³txai²na² ã³ki³ka³ti³kxi²wxe³sxã³ ãn³to³nxain¹sĩn¹na³li¹. Nxe³nxai¹nha²kxai³ ĩh¹nxe³kxa²ya̱n³ti³ta̱³: “Ĩh¹te²ta̱³ wxa²to³sain¹ji¹wi¹?” Nxe³nhĩn¹jau³xai²na² ĩ³ye³nhĩn¹ji¹wi¹? Nxain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² a²nũ²a² wxa²to³te²a² ĩ²te³lhxã³ Je³su²jah³la² sa²wa³ti̱³nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yxãn¹ta¹ tu¹ha³ka³lxai²na² sa²kxai³lu², ju¹tai²na² sa²kxai³lu² ã³ne³wxe³khai¹xain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³, kãin² yu̱h³lxi³ha²kxai³ ĩ³ka³ta³txa³sa²ha²kxai³ wxã³sxã³ Je³su²jah³la² ã³ka³ti³wxe³ka³tu̱³ ha³lo²a² hãi¹nxe³ti³xa¹ ĩ³yau¹ũ³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxi²te³nah¹lxi¹: — Nxet3sã¹nxi¹. Yxo²ĩ²sa¹nha²kxai³ we²txi¹nxa²ha¹xĩ¹. Wa²su¹wa²su¹ yxau²xai³txa²hẽ³ni¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nxe³nxa²ha¹te¹, Je³su²jah³la² ĩ³ye³kxi²nyhain¹ti̱³kxai³lu² a²nũ²a² ka³na³ku² Jai²rah³lai²na² sxi²ha² wxã³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Jai²rah³lãi³. Nxet3sĩ¹lxi¹. Wxa²ka³ne³lxin³txi² ya³lu²kxi¹nx2na²li¹. Nxe³ha²kxai³ Je³su²jah³lai²na² ĩ³hxi²ka̱u³ka̱u³sĩn¹txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nxe³kxan²ta¹ jau¹xai²na² ĩ³ye³kxain¹kxan²ta¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ a²hxi²kan¹jah¹lai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Yuh³lxi³txa³hẽ¹li¹. Hãi¹sxã³ yxo²ĩ²sẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","38","Nxa²ha¹te¹ Je³su²jah³lai²na² hi²sen³kxai³lu¹, a²nũ²a²nãu³xai²na² ã³si³tẽ³kxain¹te²nãu³xa² ha³lo²a² yxau³sxã³ wahx3nxe³si¹hain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ Pe²jah³la² so¹lxi³, Ti³a²kah³la² so¹lxi³, Jo³ãu²ah³la² Ti³a²kah³la² a²lo³na² so¹lxi³, Je³su²jah³la² ã³si³tẽ³la³kxah¹lxi³sxã³ a²sxi²ha² ya̱u³son³yah³lxi³ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹ thĩ¹nai²li² a²nũ²a²nãu³xã² yxau³te²nãu³xa², kãi²nxon³sxã³, kãin²nã̱n³ti³sxã³ hxi²ka̱u³ka̱u³nha²sxã³ he¹li³ye²yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nxe³ju³ta²kxai³, Je³su²jah³la² ã³wih¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ hxi²waun³txi³nha²sxã³ kãin²nã̱n³khaix1yah³lxin¹ji¹? Hai³txi³ wẽ³sa³la³ ya³lu²nxa³wi¹. Hãi¹nxe³sxã³ kãin² ãu³xi²na³li¹? Nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yxãn¹ta¹ a²nũ²a²nãu³xai²na² yxo²ĩ²ai¹nxa³jau³su² ĩ³yxo²kwa³lxi³nyhain¹ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ Je³su²jah³lo²kxai³lu¹ a²nũ²a² a²yxo²ha³kxa¹ aun³ta²li³si¹nyhain¹ta¹hxai²hẽ¹la². Nxe³sxã³ a²wĩ³na² so¹lxi³, a²hã³ka³na² so¹lxi³, Je³su²jah³la² sa³wi³ha³lxi³nãu³xai²na² so¹lxi³ sxã³ Je³su²jah³la² tẽ³li³yhu¹sxã³ a²wẽ³sa² sxa³thĩ³na² ã³wi¹hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ã³wi¹hain¹ka³tu̱³ Je³su²jah³lo²su² te²kxai³lu² wẽ³sa² a²hxi²ka² hxi²ki³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Wẽ³sãi³. Ĩ³sa²yxau³nxi¹. Nxe³nxa²ha¹xi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nxe³hĩ¹na¹ wa³su³txi³ wẽ³sa²kxai³ ĩ³sa²yxau³ka³tu̱³, ã³nxai³ta¹hxai²hẽ¹la², wãi²ta² wẽ³sa²kxai³la². Nxe³ju³ta² ãn³si³tẽ³kxi²tũ̱³ka̱³txai²na² kãin² wã̱³txi³lo³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yxãn¹ta¹ Je³su²jah³lai²na² sa²kxai³lu¹, yxo²xũ̱n³txi³ ĩ³kwa³na³ain¹te³nah¹lxi¹: — Ju¹tai²na² a²nũ²a² ã̱³xa² ĩ³hen³txain¹yah³lxi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ wẽ³sai²na² yain³txa² ũ³hũ¹jah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nxe³nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu¹ nũ¹ã¹ wa²li³ain¹ka³tu̱³ a³li³lah¹sxã³ ton¹ta³ko³xai²na² ã³nxai³xi²ta¹hxai²hẽ¹la². Nxe³sxã³ a²sa³wi³ha³lxi³nãu³xai²na² sa²kxai³lu² ã³si³tẽ³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nxe³nxa²ha¹te¹, Sa²ba³to³ nxe³ju³kxai³lu² Ju³te²a² nũ̱³ka̱³txa² ĩ³ye¹nxain¹to³ju³kxai³lu² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih¹sxã³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². Wãn³txa² jau¹xai²na² a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² sa²kxai³lu² ain³kxain¹ka³tu̱³ ĩ³wã̱³wã̱³txain¹sxã³ yxo²o²lain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Je³su²jah³la² ĩh¹nxe³ju³khai³xa² ĩ³hxi²ka¹txai¹nhĩ̱³te²la¹ku¹? Ĩh¹te²ta̱³ wxi²kan¹jau³xa² ĩ³tih³nxe³hĩ̱³te²la¹ku¹? Ĩh¹nxe³sxã³ wã³nxĩn¹sxã³ kãi³hĩ̱³te²la¹ku¹? Ki̱³nhai¹. Ko̱³nũ¹hxain¹ki̱³sxa³nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Jah¹lai²na² hãi¹nxe³sxã³ sxi²ha² ton³ju³ta² a²hoh³lxi³su² jah¹lai²la¹wi¹. Jah¹la² Ma³ri²a³ka³lxai²na² a²ki³lha³lxa² nxe³ha²kxai³ Ti³a²kah³lai²na² Jo³se²ah³lai²na² Ju³ta²sah³lai²na² Si³mãu²ah³lai²na² ain¹sxã³ a²kan³ti³nãu³xa² nxe³ha²kxai³ nxe³jah¹la¹wi¹. A²ha³lĩ³ti³nãu³xa² yxau³ye²nẽ³lain¹na³li¹. Hxi²kan¹jah¹lo²sxa³wi¹. Nxe³sxã³ hxi²ye¹ta³lxain¹sxã³ e²nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² a²wãn³txa² hen³txi³jah¹lo²su² te²kxai³lu¹ a²nũ²a² yxo²ha³kxa¹ yxo²ĩ²ain¹na³li¹. Yxãn¹ta¹ a²wã³tã̱³xa²nãu³xa² hi²sen³ta̱³ so¹lxi³ yxo²ĩ²ai¹nxa³ha²kxai³, sxi²yhen³khai³xa² yxau³yain¹tũ̱³ka̱³txa² hi²sen³ta̱³ so¹lxi³ yxo²ĩ²ai¹nxa³ha²kxai³, a²nũ̱³ka̱³txi³khai³xa² hi²sen³ta̱³ so¹lxi³ yxo²ĩ²ai¹nxa³ha²kxai³ ain¹na³li¹. Jã¹nxe³sah²lxin¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nxe³ha²kxai³ Je³su²jah³la² hxi²kan¹ti³ nũ̱³kxũn³ju³ta² kãi³ta¹hxai²nxa³hẽ¹la². Hãi¹nxe³sxã³ a²nũ²a² ĩ³ton³te²su² ka³lxa²nxa³te²su² te²a² so¹lxi³, wxa²hxi²to³hain¹sxã³ ĩ³we²nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A²nũ²a² yxo²ĩ²ai¹nxa³ju³ta² Je³su²jah³la² ĩ³wã̱³wã̱³nxe³khaix1ain¹ta¹hxai²hẽ¹la². Nxe³sxã³ sxi²yhen³nãu³xa² ai³lha²thet3sxã³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","9","Nxe³nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu¹ a²sa³wi³ha³lxi³nãu³xai²na² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³tũ̱³ka̱³txai²na² ĩ³kaix1so¹sxã³, ha¹li¹ wxa²hau³kot3sxã³ ĩ³sa²si¹hã³ain¹ta¹hxai²hẽ¹la². Ĩ³sa²si¹hã³ain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³li³si¹tain¹yah³lxi³hẽ¹li¹. Txa²hxi²ka¹na¹ju³ta² ũ³hũ¹nx2ta¹wi¹. Yxãn¹ta¹ ai³yah³lxin¹ju³ta² a²yen³kxa² tẽ³sxã³ ai³yah³lxi³txa³hẽ¹li¹. Tãu²nxa² so¹lxi³, tẽ³sxã³ ã³nxai³jah¹lxi³hẽ¹li¹. Hai³txi³ yain³txi³nũ̱³la³ tẽ³xa³i² wã²lẽn¹ta³ tẽ³xa³i² ha³te̱h³nxã³nxa² ũ³yho²hi²ki̱³txã³nxa² wã²lẽn¹ta³ wi¹so¹sxã³ tẽ³xa³i² nxe³yah³lxi³txa³hẽ¹li¹. Yu³wi²kxi²nyhah¹lxin¹ka³lo³a² so¹lxi³ yu̱³wi²ki²nha¹jah³lxi³hẽ¹li¹. Yxãn¹ta¹ wã²la²ka³lo³la³ tẽ³yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jã¹nxain¹jau³su² ĩ³ye³kxain¹jau³xa²sa¹: — Sxi²yhe³na² ĩ²li³jen³su² je³nãn²tu̱³ ã³nxai³yah³lxin¹kxai²nãn²tu̱³ sxi²ha² ã³wih¹te³lhxã³ a²wa³kxẽn³yah³la² ka²la¹txa²lxain¹kxai²nãn²tu̱³ a²nxe³jah¹lo²su² jah¹la² sxi²ha² so¹lxi³ ãu³xi², yai³ni², nxe³jah³lxi³hẽ¹li¹. Sxi²yhe³nai²na² he¹yah³lxi¹nhĩ¹nãn¹te²tu̱³ sxi²ha² ã̱³xa² ã³ya¹ya¹jah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yxãn¹ta¹ sxi²yhe³na² ĩ²li³jen³su² je³nãn²tu̱³: “Wxãi²na² ten³nxa²lxi³sĩ¹nx3nhai¹.” Ne³nx2tain¹kxai²nãn²tu̱³, Txa²wã¹sũ̱³na² wãn³txi³la³ ain³kxi²ti³ten³ti³he¹xai¹nxa³kxai²nãn²tu̱³ sxi²yhe³nai²nãn²tu̱³ wa²li³jah³lxi³hẽ¹li¹. Wa²li³yah³lxin¹kxai²nãn²tu̱³ kĩ̱h³nũ̱³xa² wxa²yu̱³kxa² ti³so¹yah³lxin¹tũ̱³xa² ti³yu̱³tu̱n³ta³kxi²nha¹jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ a²ko̱³nxe³ti³ kãi³ain¹ju³ta² ĩ³yau¹ũ³ain¹yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","13","Nxe³ka³tu̱³ a²sa³wi³ha³lxi³nãu³xai²na² ã³nxai³ain¹ka³tu̱³ a²nũ²a² yxo²ha³kxa¹ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³hen³txain¹ta¹hxai²hẽ¹la². Txa²wã¹ko̱³nxe³ti³ kãi³ki̱³ju³ta² ã³na¹sxã³ ã³ta³lo³ta³wxe³ki̱³si¹jau³su² ĩ³hen³txi² ko̱³nxe³te²a² yãu³ka³txa² ka³lxa¹txi³ nxũ²kwa̱i³li³si¹hai¹ni² a²nũ²a² ĩ³ton³te²su² te²a² ka³lxa¹txi³ o²lyau³xa² a³se³to²na²yau³xa² tẽ³sxã³ wxa²ne³to̱¹la³kxi²sxã³ ĩ³we²txi² nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nxe³ju³ta² sa²kxai³lu² Je³su²jah³la² kãi³ju³ta² sa²kxai³lu² a²nũ²a² yxo²ha³kxa¹ ĩ³ye³lain¹ta¹hxai²hẽ¹la². Nxe³ain¹jau³xa² a²hxi²kan¹ta² si³yxau³jah¹la² E³ro²jah³lo²su² te²kxai³lu² ain³kxain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ a²nũ²a² ĩ²li³te²a² e³te³nah¹lxi¹: — Jo³ãu² Ba³tis²jah³la² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nẽ³jah¹lo²su² ya³lu²ka³tu̱³ hã²wxãn³txa³ ka³te̱n³su² ĩ³sa²yxau³xi²ha²kxai³ hĩ¹na² a²yen³kxa² hxi²kan¹ti³ kãi³ain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ain¹ka³tu̱³ a²nũ²a² ã̱³xa² ĩ²li³te²a² e³te³nah¹lxi¹: — E³li²ah³lo²su² te²la¹i¹. Nxe³ain¹ka³tu̱³ a²nũ²a² ã̱³xa² ĩ³lxi³nũn³te²a² e³te³nah¹lxi¹: — Jah¹lai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lai²la¹i¹. Kxã³nhxĩ¹nai³tã² ĩ³sa²si¹hã³nẽ³kxu¹jã¹nxe³jah¹lai²la¹i¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yxãn¹ta¹ jau¹xai²na² E³ro²jah³lai²na² ain³kxi²ka³tu̱³ ĩ³ye³te³nah¹lxi¹: — Ha³la³je¹nai³tã² Jo³ãu² Ba³tis²jah³la² ũ³nhe³ki²lho¹si¹hai¹na¹jau³su² kwa³na³ai¹na¹hẽ³li¹. A²nxe³jah¹la² hĩ¹na² ka³te̱n³su² ĩ³sa²yxau³xi²na³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nxe³jau³xai²na² sa²kxai³lu¹, ha³la³je¹nhĩ¹nai³kxai³lu¹ E³ro²jah³lai²na² a²lon³na² a²ĩ³lxa² Fi³li²pah³la² ĩ³yĩ¹li²ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Fi³li²pah³lai²na² a²sxe³xa³ka³lxa² a²ĩ³lxa² E³ro³ti²a³ka³lxa² ĩ³yĩ¹li²ta¹hxai²hẽ¹la². E³ro³ti²a³ka³lxai²na² sa²kxai³lu² E³ro²jah³lai²na² a²hi²sen³kxai³lu² ha³la³je¹nhĩ¹nai³kxai³lu² hait1so¹kxi²yha¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ta¹ Jo³ãu² Ba³tis²jah³lai²na² sa²kxai³lu¹ E³ro²jah³lai²na² ĩ³tih³nxe³jau³xa²sa¹: — E³ro²jah¹lãi³. Nxet3sĩ¹lxi¹. Wxa²lon³na² Fi³li²pah³la² a¹he¹na³li¹. Nxe³kxa²yu³su² a²sxe³xa³ka³lxai²na² hait1so¹kxi²yha¹hin¹ju³ta² wai³nxa³wi¹. Kãi³in¹ju³ta² Txa²wã¹sũ̱³na² te³nxa³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nxe³ha²kxai³ E³ro³ti²a³ka³lxai²na² a²hi²sen³kxai³lu² Jo³ãu² Ba³tis²jah³la² ĩ³xa̱n³ta³kxi²khai¹xain¹ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² a²wẽ³sãi¹yah³lai²na² sa²kxai³lu² Jo³ãu² Ba³tis²jah³la²kxai³ i³ain¹sãn²sxã³ sa²tai³kxain¹sxã³ sxi²ha² kan²thĩ³na² ũ³tĩ̱¹kxain¹ta¹hxai²hẽ¹la². Jã¹nxe³kxa²yu³su² E³ro³ti²a³ka³lxai²na² sa²kxai³lu² Jo³ãu² Ba³tis²jah³lai²na² ĩ³su²lhã³ti³ten³khaix1ain¹ta¹ hxi²kan¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hxi²ka¹nai¹nxa³ju³ta²sa¹: E³ro²jah³lai²na² sa²kxai³lu¹ a²ẽ¹nãn¹jau³kxai³lu¹: — Jo³ãu² Ba³tis²jah³lai²na² wi¹lhin¹khai¹nxe³sxã³ wain¹khaix1jah¹lai²la¹xã¹. A²ko̱³nxe³ju³ta³la³ yũ³ti³hex1jah¹lo²sxa³xã¹. Yu̱h³lxai¹na¹nhã¹, Jo³ãu² Ba³tis²jah³lai²na²su¹. Ain¹to³ta¹hxai²hẽ¹la². Ai¹nha²kxai³ a²sxe³xa³ka³lxa² a̱n³txi³ju³ta²kxai³ ĩ³su²lhã³ain¹kxa²ya̱n³ti³su² E³ro²jah³lai²na² sa²kxai³lu² Jo³ãu² Ba³tis²jah³lai²na² ã³non²ta³kxi²to³ta¹hxai²hẽ¹la². Ain¹sxã³ Jo³ãu² Ba³tis²jah³lai²na² wãn³txa² E³ro²jah³lai²na² ain³kxi²sxã³ kãin² yu̱h³li³to³nha²sxã³ ĩ³wã̱³wã̱³ta³kxi²nha²kxan²ti³nũ¹ ka³lih³kxi²nha²sxã³ ain³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nxe³to³ta¹ a²ha² ya̱n³nãu³kxai³lu¹ E³ro²jah³lai²na² a²hi²sen³kxai³lu¹ a²hã³ka³na² ẽ¹na² a³li³la¹hain¹ju³tai³tã² ain³kxi¹xi²nha²te³lhxã³ kãi³ain¹ta¹hxai²hẽ¹la². Kãi³ain¹ju³ta²sa¹, a²sa³wi³ha³lxi³nãu³xa² ka³lxa¹txi² so³ta²to² nũ̱³ka̱³txa² a²hxi²kan¹ti³nãu³xã² hãi¹nxe³ti̱³xa² ka³lxa¹txi² Ka³li³le²a²ko³xa² a²hxi²kan¹ti³nãu³xa² ka³lxa¹txi², nxe³ain¹ka³tu̱³ ã³yã³nũ²kxain¹ta¹hxai²hẽ¹la². Ain¹sxã³ a²yain³txa² ka³lxa¹txi³ kãin² ĩ³yai³ni², yain³txi³yau³xa² ũ̱n³jau³xa² kãin² ĩ³na², nxe³ain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ta¹ E³ro³ti²a³ka³lxa² a²ẽ¹nãn¹jau³kxai³lu¹ e³kxi²nha²te³nah¹lxi¹: — Hĩ¹na² txa²ha³lo²a² hau³kon³na³na¹. Hĩ¹na² Jo³ãu² Ba³tis²jah³lai²na² su²lhã³ai¹na¹ju³ta³nũ³a² a̱in³nha¹nhã¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nxe³ju³ta²kxai³ E³ro³ti²a³ka³lxa² a²ka³ne³lxa² ya³sxã³ a²nũ²a² ã³yã³nũ²kxain¹thĩ³nãu³a¹ ã³wih¹sxã³ nũ̱h¹ ã³ha³te̱³yain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² E³ro²jah³la² kãin² ĩ³ka³li³kxi², E³ro²jah³la² ĩ³ka²la¹tũ̱³ka̱³txa² kãin² ĩ³ka³li³kxi² nxe³yhain¹te³nah¹lxi¹ E³ro²jah³lai²na² a²wãn³txi³kxai³lu¹ wãin²ta¹ka³lxai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Yã¹te² yen³kxa² ten³nxa²ji¹xi¹? A²yen³kxa² a²te³nĩn¹kxa² ĩ³wã̱³txi³san¹kxai²nãn²tu̱³ ũ³hũ¹nxa²ha¹tũ¹xĩ¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jã¹nxe³sxã³ E³ro²jah³la² a²wãn³txi³kxai³lu¹: — Txa²yen³kxa² yxo²ha³kxa² ha³ta̱³nxãn²txi³ ĩ³ha³la³tãu²so¹sxã³ ũ³hũ¹nxa²ha¹tũ¹xĩ¹, ĩ³wã̱³txi³san¹kxe³la³ti¹. Ki³han³nxa³xi¹. Nxe³ju³ta² txa²wãn³txai²na² ĩ³wa²li²na¹ke³la³te²kxai³, Txa²wã¹sũ̱³na² a²ko̱³nxe³ju³ta² ũ³hũ¹sa²hĩ̱³nx2na³ni¹. Jã¹nxe³sa²kxa²ya̱n³ti³su² na¹nhi¹. Nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nxe³nxa²ha¹te¹ wãin²ta¹ka³lxai²na² sa²kxai³lu² wa²li³sxã³ a²hã³ka³na² ĩ³wã̱³txi³te³nah¹lxi¹: — Hã³kãi³. Nxe³nxi¹. Yã¹te²a² yen³kxa² ĩ³wã̱³tain¹hĩ̱³na¹te²la¹ku²? Na¹nhi¹. Ta¹hxai²hẽ¹la². Yxãn¹ta¹: — “Jo³ãu² Ba³tis²jah³la², ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nẽ³jah¹la² a²ne³ka² so¹lxi³ ten³sa³nha²wi¹.” Nxe³txai¹nhẽ³ni¹. A²hã³ka³nai²na² wãn³txa² ĩ³wã²lũ³xi²jau³xa² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nxe³nxa²ha¹te¹ a²wãin²ta¹ka³lxai²na² sa²kxai³lu² ã³ni³hi² ĩ³whi¹xi²ka³tu̱³ a²hxi²kan¹te²a² sa²kxai³lu² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Jo³ãu² Ba³tis²jah³la², ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nẽ³jah¹la² a²ne³ka² so¹lxi³ pra²ta²ka³lo³a² ũ³yhe³hẽ²ti³sxã³ ũ³hũ²xa¹sẽ¹li¹. Kwẽn¹tai²na² ten³sa³nhai¹. Nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nxe³ju³ta²kxai³ a²hxi²kan¹ta² si³yxau³jah¹lai²na² ĩ³ãin²txi³khaix1ta¹hxai²hẽ¹la². Yxãn¹ta¹ ha³la³je¹nĩn³kxai³ a²wãn³txai²na² a²yen³kxa² wãin²ta¹ka³lxai²na² ũ³hũ¹te³lhxã³ nxe³jau³xai²na² yxo²a̱n³ta³ti³ e³ain¹jau³xai²na² a²nũ²a² yxo²ha³kxa¹ ĩ²i² ain³kxi² nxe³ain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ E³ro²jah³lai²na² sa²kxai³lu² wãn³txai²na² ĩ³wa²li²ju³ta³la³ ten³ta¹hxai²nxa³hẽ¹la². A²nũ²a² yxo²ha³kxa¹ a²ẽ¹nãu³a¹ o̱³nxa³jau³su² ĩ³ye³kxain¹kxa²ya̱n³ti³su² Sũ̱³na² ko̱³nxe³ju³ta³la³ ũ³hũ¹ain¹kxa²ya̱n³ti³su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Nxe³ha²kxai³ kwẽn¹ta²kxai³ so³ta²to²jah¹la² ĩ³kwa³na³ta¹hxai²hẽ¹la². Jo³ãu² Ba³tis²jah³la² ũ³nhe³ki²lho¹sxã³ tẽ³sxã³ wxã³si¹hain¹jau³su² ĩ³kwa³na³ta¹hxai²hẽ¹la². Ain¹ka³tu̱³, so³ta²to²jah¹lai²na² sa²kxai³lu² a³li³sxã³ sxi²ha² kan²thĩ³na² ã³wih¹ta¹hxai²hẽ¹la². Nxe³nũ²la² yu̱³la² kãin²ta³wxi²a² tẽ³sxã³, Jo³ãu² Ba³tis²jah³la² a²ne³ka² ũ³nhe³ki²lho¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ a²ne³kai²na² pra²ta²ka³lo³a² ũ³yhe³hẽ²ti³so¹sxã³ a²wãin²ta¹ka³lxai²na² ũ³hũ¹ka³tu̱³ ta¹ka³lxai²na² a²hi²sen³kxai³lu² a²hã³ka³na² ũ³hũ¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nxe³ju³tai²na² Jo³ãu² Ba³tis²jah³lai²na² a²sa³wi³ha³lxa² ain³kxain¹ka³tu̱³ ya³lu²tai²na² a²ne³ki³la³ yũ²nxa³sxã³ a²nũ²a²nãu³ai²na² so¹lxi³ so¹sxã³ sa²nĩ̱³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nxe³nxa²ha¹te¹ hã²wxãn³txa³ Je³su²jah³la² ĩ³sa²si¹hã³ta³nũ̱³ka̱³txai²na² sa²kxai³lu², ã³wa̱³lain¹ka³tu̱³ a²yen³kxa² kãi³ain¹ju³ta² a²yen³kxa² a²nũ²a² ã̱³xa² ĩ³yau¹ũ³yhain¹jau³xa² a²hãi¹nxe³ti³xa² Je³su²jah³la² ĩ³hen³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nxe³hĩ¹na² a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² Je³su²jah³la² ĩ²te³lhxã³ ã³tĩ̱³i² wxa̱³li² jã¹nxe² nxe³ain¹to³ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Je³su²jah³lai²na² a²sa³wi³ha³lxi³nãu³xai²na² whãi²na¹, hxi²kan¹ti³ yain³txa²ha³ta̱³nxãn²ti³ ĩ³yai³nain¹to³ta¹hxai²nxa³hẽ¹la². Ai¹nha²kxai³, Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³xa² nũ̱h¹ ã³nxai³ya³sah¹lxi³hẽ¹li¹. Nũ¹ã¹ jũ¹nxe² ĩ³ye¹nxi²ya³sah¹lxi³hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ai¹nha²kxai³ ka²no¹a² nũ̱h¹ ã³wi¹hain¹ka³tu̱³ ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³xa² ã³nxai³te³lhxã³ wa²li³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yxãn¹ta¹ wa²li³ain¹ju³ta² a²nũ²a²nãu³xai²na² ĩ²ai¹nha²kxai³ ain³kxi²xain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ sxi²yhen³nãu³xa² hãi¹nxe³ti̱³xa¹ wa²li³sxã³ a²yu³kxa² ã³ni³hain¹ka³tu̱³ a²ko̱¹xai²na² sa²kxai³lu² a²nũ²a² yxau³ai¹nxa³ko³xai²na² sa²kxai³lu² a²ne³hẽ³txa¹ ã³wi¹hũ³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nxe³ka³tu̱³ Je³su²jah³lo²su² te²kxai³lu² ãn³yxo²ha³ti³lhi³nũ²la² ka²no¹a² a³li³ka³tu̱³, a²nũ²a²nãu³xai²na² ka³lxa¹tũ̱³ka̱³txai²na² ĩ²ain¹tãu³ Je³su²jah³lai²na² ãin²ta³lxi³nha²ta¹hxai²hẽ¹la². Ãin²ta³lxi³nha²te³nah¹lxi¹: — Tũ̱¹ka̱³txai²na² o³ve²a³ nũ̱³ka̱³txi³hũ̱³na³na¹. O³ve²a² nũ̱³ka̱³txa² a²wa³kxẽn³yah¹la² yũ²nxa³kxe³hũ̱³nxe² hxi²ka̱u³ka̱u³nha²sxã³ yxau²xai³tũ̱³ka̱³txi³hũ̱³na³na¹. Nxe³ha²kxai³ ã³nãin²ta³lxi³sa³nhã¹. Je³su²jah³la² a²ẽ¹nãu³a¹ nxe³nha²ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ka³lxa¹jau³xa² ĩ³yau¹ũ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nũ²la² sũ²ni²khai³nxe³nũ²la² a²sa³wi³ha³lxi³nãu³xai²na² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Ti¹ai²na² sxi²jen³ti³la³ yũ²nxa³ti²tu³wi¹. Hĩ¹na² ka³nxa³hi²tẽ³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nxe³ha²kxai³ a²nũ²a²nãu³xai²nãn²tu̱³ ĩ³sa²si¹hã³txain¹sĩ¹nhẽ³li¹. Ha³lo²ai²na² ta̱³nxa², sxi²yhen³nãu³xa² ta̱³nxa² a²yain³txa² so¹kxain¹si¹hain¹jau³su² ĩ³sa²si¹hã³txain¹sĩ¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yxãn¹ta¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹, ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wxãi²na² ũ³hũ¹txain¹yah³lxi³hẽ¹li¹, a²yain³txa²sa². Nxe³ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xa² a²wãn³txi³kxai³lu¹: — Hxi²kan¹sa²sĩ¹nxa³nha²wi¹. A²nũ²a² nũ̱³ka̱³txai²na² yain³txa³tũ̱³xa² te³nain¹tũ̱³xa² kãin²khaix1na³li¹. Nxe³tũ̱³xai²na² sa²kxai³lu² a²nũ²a² ka³na³ka³na³jah¹la² kwẽ³kxa² hãi¹nxe³ti̱³xa² wa³ko³ni² yxau²xai³kxai²nãn²tu̱³ hxi²kan¹ti³ ũ³yho³hi²nxa³lho³li¹. Nxe³ha²kxai³ hxi²kan¹ti³hex1sa²sĩ¹nx3nhai¹. Ĩh¹nxe³thĩ̱³nha¹ji¹ku¹? Nha¹nhai¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yxãn¹ta¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — Yain³tũ̱³xa² yũ³ah³lxin¹tũ̱³xa² ai³sxã³ wxa²hau³ko³jah¹lxi³sã²nhẽ³li¹. Nxe³ta¹hxai²hẽ¹la². Nxe³sxã³ wxa²hau³ko³ta³lu²nain¹ka³tu̱³ ĩ³hen³tain¹jau³xa²sa¹: — Yain³tũ̱³xa² tũ̱³ha¹li¹ tũ̱³ha¹li¹ ka³na³ki¹ tũ̱³xa² yũ² a̱i³na² ha¹li¹ yũ² nxe³sĩn¹nĩn²su²li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nxe³ain¹ka³tu̱³ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — Si³sa³yu³ta² au³ju³ta² ã³nhai²wxe²xai³jah¹lxi³hẽ¹li¹. Ha³na³ka³lxi² ã³nũ²kxi²sxã³ jũ¹nxe² so¹lxi³ ã³wxe², jũ¹nxe² so¹lxi³ ã³wxe² jã¹nxe² nxe²xai³jah³lxi³hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nxe³nxa²ha¹te¹ a²nũ²a²nãu³xai²na² hxi²ka² hxan³sxã³ ye³ha¹li¹ ye³ha¹li¹ wxa²sa²wa²la³kxi¹xi²nũ̱³ka̱³txa² a²nũ̱³ka̱³txi³su² ha³na³ka³lxi³ ã³wxe² jã¹nxe² jã¹nxe² ã²la² kãi²lxi³tũ̱³ka̱³txa² ã³wxe² nxe²xai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nxe³nxa²ha¹te¹ Je³su²jah³lo²kxai³lu¹ yain³tũ̱³xai²na² tũ̱³ha¹li¹ tũ̱³ha¹li¹ ka³na³ki¹ tũ̱³xa² wxa²sa²so¹xi² a̱i³nai²na² ha¹li¹ wxa²sa²so¹xi² nxe³ta¹hxai²hẽ¹la². Nxe³sxã³ ten³sa²tã³ka³la³yxo²nũ²la² a²yain³txa² Txa²wã¹sũ̱³na² ĩ³wi¹lxon³kxi²jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Nxe³nũ²la² a²yain³tũ̱³xai²na² so¹sxã³ wxa²nãu²lxi³sxã³ nxe³tũ̱³xai²na² sa²kxai³lu² a²sa³wi³ha³lxi³nãu³xai²na² sa²kxai³lu² ũ³hũ¹ain¹ta¹hxai²hẽ¹la². Hã²wxãn³txa³ a²nũ²a² yxo²ha³kxa¹ ũ³hũ²xai³ain¹ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ a̱i³nai²na² wxa²nãu²lxi³sxã³ a²nũ²a² yxo²ha³kxa¹ ũ³hũ²xai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Nxe³ka³tu̱³, a²nũ²a²nãu³xa² hãi¹nxe³ti̱³xa¹ ĩ³yain³tain¹ka³tu̱³ ũ³kxain¹ta¹hxai²hẽ¹la². Yain³txa³tũ̱³xa² a̱i³na² wxa²nãu²lxi³kxe³su² ũ³kxain¹nxa²ha¹te¹ a²wã³kxi³kxai³ wã²nxa³kxa² so¹sxã³ ha³ti²a² hxi²ka² hxan³sxã³ nẽ³nha¹li¹ wxa²sa²so¹xi²nũn³tẽ³na², ne³ki¹lhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nxe³ju³tai²na² sa²kxai³lu², in³txa² nũ̱³ka̱³txa² hãi¹nxe³ti̱³xa¹ ka³lxa¹khai¹nxe³tũ̱³ka̱³txa² 5.000 nxe² yain³tũ̱³xai²na² ĩ³yain³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nxe³nxa²ha¹te¹, kwẽn¹ta²kxai³ yain³ta³lun²ka³tu̱³ Je³su²jah³la² hi²sen³su² a²sa³wi³ha³lxai²na² ka³no¹a²ka³lo³a² ã³wih¹sxã³ ĩ̱³ye³nai²na² Bet3sa³i²ta³thĩ³na² yxo²ha³ti³lhi³si¹hain¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a² a²nũ²a²nãu³xin³txi² ĩ³xi²si¹hain¹jau³su² ĩ³sa²si¹haun¹ta²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ĩ³sa²si¹haun¹ta²ain¹ka³tu̱³ nũh¹xai³sxã³ wã³la³ka³txa² wxa²ka³la³nũ²la² Txa²wã¹sũ̱³na² e³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nũ²la² ka³nxa³hi²nũ²la², ka²no¹a²ka³lo³ai²na² ĩ̱³ye³na² nxũ²kwa̱i³ye³la³nãu³a² ne³hẽn³kxa² hãu¹ha²kxai³ Je³su²jah³la² so¹lxi³, ha³lo²a² nũ̱¹he¹ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nxe³tãu³a¹ i³txa² nũ̱³kxũn³txi³ ka²no¹a²ka³lo³ai²na² sa²ne³khau²kxain¹ju³ta²kxai³ a²sa³wi³ha³lxi³nãu³xa² hxi²kan¹ti³ ũ³kwa³lxĩ¹nha²sxã³ ai³ai¹nxa³ju³ta²kxai³ nxe³ta¹hxai²hẽ¹la². Nxe³ju³tai²na² a²yxo²ha³kxa¹ Je³su²jah³lai²na² sa²kxai³lu² ĩ²ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹ ka³la³ka³la²a² ĩ³yxai²lxi²ti³xa² Je³su²jah³la² ĩ̱³yau³xa² a²ne³ka³na²ha² wxã³yain¹ta¹hxai²hẽ¹la². A²yu³kxa² wxã³ta¹hxai²hẽ¹la². — Ã³wa²to¹tai¹na¹tũ¹xã¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yxãn¹ta¹ a²sa²wi³ha³lxi³nãu³xai²na² a²hi²sen³kxai³lu² ĩ²ain¹ta¹hxai²hẽ¹la². Je³su²jah³la² ĩ̱³yau³xa² a²ne³ka³na²ha² ã³wxã³ju³ta² ĩ²ain¹ta¹hxai²hẽ¹la². — Ya³lu²te² yãu³ka³txi³sa²lxã²nx3nha²khi³. Nain¹jau³su², ĩ³wxan¹sxã³ yu̱h³lxi³khai¹nxẽn³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yxãn¹ta¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Txai¹ta³li³na¹we¹. Yu̱h³lxah³lxi³txa³hẽ¹le¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nxe³sxã³ Je³su²jah³lai²na² sa²kxai³lu² ka²no¹a²ka³lo³a² wi³kxain¹ta¹hxai²hẽ¹la². Ain¹sxã³ i³txai²na² wxa²nhãu²no³jain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²sa³wi³ha³lxi³nãu³xai²na² kãin² yu̱h³lxai¹nha²kxai³ kãin² wã̱³tai¹nha²kxai³ ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nxe³ain¹ju³ta² yain³txi³nũ̱³xa² a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² ĩ³yã̱³lã̱³tain¹ju³tai³tã² a²si³yxau³tãu³khai³xa² ã³ne³to³hain¹ta¹hxai²nxa³hẽ¹la². Ai¹nha²kxai³ yu̱h³lxai¹nha²kxai³ wã̱³tai¹nha²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nxe³nxa²ha¹te¹ ã³yxo²ha³ti³lhi³ain¹ka³tu̱³ ha³lo²a² Je³ne³sa³re²ko³xa² wa²li³hain¹ka³tu̱³ ka²no¹a² sa²ha³lo²sa²ta̱³ain¹te³na¹ hi³sa³ka³txa² kan²ka³ta² sa²nĩ¹sa²tai³ka¹tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nxe³ain¹ka³tu̱³ kwẽn¹ta²kxai³ a²nũ²a²nãu³xa² hi²sen³su² Je³su²jah³la² ĩ²kxi²xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ai¹nha²kxai³, sxi²nhãu³xai²na² yxo²ha³kxa¹ ã³ni³sxã³ ã³wi¹hain¹ka³tu̱³ a²nũ²a² ĩ³ton³te²su² te²a² sxa³ain¹ka³lo³a² whãi²na¹ sa²ye³hẽn²ti³so¹nyhain¹ka³tu̱³ Je³su²jah³la² a²he¹tãu³a² sa²kxai³lu² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ain¹ka³tu̱³ Je³su²jah³la² he¹tãu³a¹ ĩ²li³tãu³a¹ sxi²yhen³nãu³a¹ ta̱³nxa², sxi²ha² ka³lxa¹thĩ³nãu³a¹ ta̱³nxa², ha³lo²a² ta̱³nxa² a²nũ²a² wi¹lain³kxi²nha²te² hi²sen³kxai³lu² a²nũ²a² ĩ³ton³te²a² tẽ³sxã³ sxi²yhe³na² nxũ²kwa̱i³ye³li³nãu³a¹ a²yuh³xa² ũh³wxe³yhain¹ka³tu̱³ wi¹lain³kxi²nha²tũ̱³ka̱³txa² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Wxa²wã²la² yxo²ka³teh³nãu³a¹ ha³ta̱³nxãn²txi³ a²nũ²a² ĩ³ton³te²su² te²a² wxa²to³hũx1ti³ten³nxain¹na³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ a²nũ²a² ĩ³ton³te²su² te²an²tu̱³ Je³su²jah³la² wã²la² yxo²ka³teh³nãu³a¹ wxa²to³hain¹te²nãu³xa² ha³kxa¹, we²nhxa³sa²sai¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Nxe³nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa², Ju³te²a² nũ̱³ka̱³txi³nãu³xa² ã³nhai¹tũ̱³ka̱³txi³su² ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ kxã³nxai³tã² txa²wã¹si³yah³la²nãu³xu¹tai²na² a²wãn³txa² ĩ³wẽ̱³not3so¹ain¹jau³xa², fa³ri³se²a² nũ̱³ka̱³txain²txi³ sa²wai³wait3sxã³ sa²yxo²we¹ti² Ju³te²a² nũ̱³ka̱³txi³nãu³xain²ti³ yxo²ha³kxa¹ sa²wai³wait3sxã³ sa²yxo²we¹ti² nxe³ain¹to³ta¹hxai²hẽ¹la². Nxe³ain¹kxa²yu³su² kãin² wxa²hxi²han³ta³kxi²ti³nha²sãn²sxã³ ĩ³yai³nain¹to³ta¹hxai²hẽ¹la². — Kãin² wxa²hxi²han³ta³kxi²ti³nha²sãn²ki̱³sxa³kxai²nãn²tu̱³ ĩ³yain³ki̱³sxa³lho³li¹. Nxe³ain¹to³ta¹hxai²hẽ¹la². Jã¹nxai¹nha²kxai³, ha³lo²a² a²yen³kxa² so¹kxi²nyhu¹ain¹tãu³a¹ ã³sxã³ sxi²ha² ã³wi¹hai¹nha²kxai³ txa²wã¹nũ²a² hãi¹nxe³ti³xa¹ wxa²ho³xi²han³kxi²ti³nha²sãn²sxã³ ĩ³yai³nain¹to³ta¹hxai²hẽ¹la². Wxa²ho³xi²han³kxi²ti³nhai¹nxa³kxai²nãn²tu̱³ hai³txi³ ĩ³yain³ti³hex1nai¹nhĩ̱³nx2to³ta¹hxai²nxa³hẽ¹la². Jã¹nxain¹nũ³nha²kxai³, ka³lxa¹txi³ yau³xã̱³xa² txa²wã¹si³yah³la²nãu³xu¹tai²na² wẽ̱³no̱t3so¹ain¹jau³xa² fa³ri³se²a² nũ̱³ka̱³txai²na² sa²yxo²we¹tain¹to³ta¹hxai²hẽ¹la². Nxe³jau³xa²sa¹: Kwa³ta³lẽ³na² ĩ³na²ki̱³tẽ³na² wxa²hi̱³hi̱³la³kxi², kwa³ta³lẽ³na² te³tu³kxi²ki̱³tẽ³na² wxa²hi̱³hi̱³la³kxi², kwa³thi³lẽ³na² ĩ²li³tẽ³na² wxa²ye³hi̱³hi̱³li² nain¹to³ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ ha³te̱h³nxã³nxa² ho³lhxi³su² tũ̱³ka̱³txa² kwa² ã³nhai¹tũ̱³ka̱³txa² Je³ru³sa³lẽ²thĩ³na² a³li³ka³tu̱³ wxã³ain¹ta¹hxai²hẽ¹la². Wxã³ain¹tũ̱³ka̱³txa² sa²kxai³lu², fa³ri³se²a² nũ̱³ka̱³txa² sa²kxai³lu² whãi³na¹, ã³sa²nũ²kxi²sxã³ Je³su²jah³la² ĩ³ha¹txi²sxã³ he¹ye²yhain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³, nxe³hĩ¹na² Je³su²jah³la² a²sa³wi³ha³lxi³nãu³xã² ĩ³yai³nain¹ta¹hxai²hẽ¹la². Txa²wã¹hxi²nã³txa² whãi²na¹ wxa²hxi²han³ta³kxi²nhai¹nxa³kxe³tu̱³ ĩ³yai³nain¹ta¹hxai²hẽ¹la². Nxe³ju³tai²na² hxi²nã³ti³sxã³ ĩ³yai³nain¹ju³tai²na² fa³ri³se²a² nũ̱³ka̱³txai²na² ã³nhai¹tũ³te²nãu³xai²na² hi²sen³su² ĩ²i² ha³te̱h³nxã³nxa² hoh³lxi³su² tũ̱³ka̱³txai²na² ã³nhai¹tũ³te²nãu³xai²na² hi²sen³su² ĩ²i² nxe³ain¹ka³tu̱³ Je³su²jah³la² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ĩ³ye³kxain¹te³nah¹lxi¹: — Wxa²sa³wi³ha³lxi³nãu³xai²na², hai³txi³ txa²wã¹si³yah³la²nãu³xu¹tai²na² ã³wẽ̱³not3sxã³ ũ³hũ¹nẽ³jau³xa² sa²yxo²we¹tai¹nxa³te¹ni²ti¹. Yxãn¹ta¹ hxi²nã³ti³ ĩ³yai³nain¹te¹ni²ti¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ txa²wã¹si³yah³la²nãu³xu¹tai²na² ũ³hũ¹nẽ³jau³xa² sa²yxo²we¹tai¹nxa³te²la¹xã³? Nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Wxãi²na² wi¹lhin¹ki³lxot3sxã³ yxau²xai³yah³lxi³to³hi¹lxi¹. Yxau²xai³yah³lxin¹ju³ta² kxã³nhxĩ¹nai³tã² I³sa³i²ah³lu¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³ye³ain¹ta¹hxai²ti³ai¹ti²ti¹. A²nxe³jah¹lu¹tai²na² ũ³wha²li¹lain¹jau³xa²sa¹: “Txa²nũ̱³ka̱³txai²na² a²yxo²wãn³txa² so¹lxi³ sa²nẽn¹kxi²ti³hit1sain¹na³li¹. Yxãn¹ta¹ a²ẽ¹nãn¹jau³xai²na². Sũ̱³na² na¹xai²na² ten³sain¹jau³xa² yũ³ai¹nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yxãn¹ta¹ kwa²hãi¹nxe² sa²nẽn¹kxi²sa²ki³lxot3sai¹nhxai²na²hẽ¹li¹. A²wãn³txai²na² ĩ³tih³nxe³nyhain¹jau³xai²na² a²nũ²a² wãn³txa² sa²so¹sxã³ Sũ̱³na² wãn³txi³su² ki³lxo³jau³su² ĩ³tih³nxe³nyhain¹to³hxai²na²hẽ³li¹.” Nxe³jau³su² I³sa³i²ah³lu¹tai²na² wãn³txa² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wxãi²na², te²yã¹nxe³sxã³ kãi³yah³lxi³to³hi¹lxi¹. Yah¹lxi¹nha²kxai³ Txa²wã¹sũ̱³na² ĩ³kwa³na³nẽ³jau³xa² sa²yxo²ã³yah³lxi¹nha²kxai³ a²nũ²a² wãn³txa² so¹lxi³ a²nũ²a² ĩ³wẽ̱³no³tũh¹nẽ³jau³xa² so¹lxi³ sa²wai³wait3sxã³ sa²yxo²we¹jah³lxi³to³hi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wxãi²na², sa²nẽn¹nha² ko̱³nxe³ti³ kãi³yah³lxi³to³hi¹lxi¹. Yah³lxin¹ju³ta²: “Txa²wã¹sũ̱³na² wãn³txi³la³ ĩ³kwa³na³nẽ³jau³la³ o³nxa³wi¹.” Nxe³yah³lxi³to³hi¹lxi¹. Yah³lxi¹nha²kxai³, txa²wã¹si³yah³la²nãu³xu¹tai²na² wxa²wẽ̱³not3so¹yah³lxin¹jau³xa² so¹lxi³, a²nũ²a² wãn³txa² so¹lxi³ sa²wai³wait3sxã³ sa²yxo²we¹jah³lxi³to³hi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jã¹nxa¹jau³su² Moi³se²ah³lu¹tai²na² wãn³txi³kxai³lu¹: “Wxa²wĩ³na² wxa²hã³ka³nu¹na² wi¹kãi³ũh¹xai³jah¹lxi³hẽ¹li¹.” Ta¹hxai²hẽ¹li¹. A²nxe³jau³xa² yã¹nxe³te³nah¹lxi¹: “Wxa²wĩ³na² ta̱³nxa² wxa²hã³ka³na² ta̱³nxa² ko̱³nxe³jau³su² nxe³ti³hi¹txain¹kxai²nãn²tu̱³ nxe³te²su² te²a² ĩ³su²lhã³jah¹lxi³hẽ¹li¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nxe³yãn¹ta¹ wxa²wãn³txa² e³kxah²lxin¹jau³su² nxe³yah³lxin¹te³nah¹lxi¹: “A²nũ²a² ĩ²li³te²su² te²a² a²wĩ³na² ta̱³nxa² a²hã³ka³na² ta̱³nxa² yen³kxa² tau³to³nain¹kxe³su² ĩ³ye³kxi²te³nah¹lxi¹: ‘Wĩ³na², nxe³txi¹. Txa²yen³kxa² ũ³hũ³na¹tũ¹xã¹.’ Nxa¹hẽ¹li¹. Yxãn¹ta¹ sa²yat1sxã³ Txa²wã¹sũ̱³na² so¹lxi³ ũ³hũ¹ai¹na¹tu¹wi¹, txa²yen³kxai²na²su¹.” Nxe³ain¹jau³su². ");
INSERT INTO nabNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nxe³ain¹kxai²nãn²tu̱³ wxa²nũ̱³ka̱³txai²na² a²wãn³txi³kxai³lu¹ a²nũ²ai²na² ĩ³ye³kxain¹yah³lxin¹te³nah¹lxi¹: “Wxa²yen³kxai²na² wxa²wĩ³na² wxa²hã³ka³na² ũ³hũ¹ai¹nxa³ju³ta² wain³na³li¹. Sũ̱³na² yen³kxai²la¹wi¹, hĩ¹na²su¹.” Nxe³yah³lxi³to³hi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nxe³yah³lxi¹nha²kxai³, Txa²wã¹sũ̱³na² wãn³txi³khai³xa² ĩ³hxi²ka¹nxa³si¹yhah³lxin¹jau³su² nxe³te²lo³jah³lxi¹nha²kxai³ wxa²si³yah³la²nãu³xu¹tai²na² wãn³txa² sa²wa²lho¹xi²yah³lxi¹nha²kxai³ nxe³yah³lxi³to³hi¹lxi¹. A²yen³kxa² ã̱³xa² te²u¹jã¹nxe³te²a² ka³lxa¹te²a² kãi³yah³lxi³to³hi¹lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","15","Nxe³nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu¹ a²nũ²a²nãu³xa² yxo²ha³kxa¹ ĩ³kaix1sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² yxo²ha³kxa¹ nex3ka²kxi²sah¹lxi³hẽ¹li¹. Sah¹lxin¹kxai²nãn²tu̱³ wi¹ko̱³nha¹jah³lxi³hẽ¹li¹. Txa²wã¹yxo²a² ũh³yxo²wih¹nẽ³kxe³su² hai³txi³ ko̱³nxe³ti³hit1tẽ³lxa³wi¹. Yxãn¹ta¹ txa²wã¹yxo²a² sa²yxo²sai¹nẽ³kxe³su² ko̱³nxe³ti³hit1tẽ³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","A²ne³nxẽ³na² yũ¹nx2ti³kxai²nãn²tu̱³ ain³kxi¹sah¹lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nxe³nxa²ha¹te¹ a²nũ²a²nãu³xai²na² ã³ain¹sxã³ sxi²ha² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wi¹hain¹ka³tu̱³ a²sa³wi³ha³lxi³nãu³khai³xai²na² sa²kxai³lu² Je³su²jah³la² ĩ³ye³kxain¹sxã³ wãn³txai²na² ĩ³yau¹ũ³jau³xai²na² ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Wxãi²na² ã³ne³to³nxa²lxi³nũn³ta²lu¹wi¹. Jã¹nxa¹jau³su² ĩ³ye³kxi¹nx2ta¹wi¹. Ko̱³nxe³ti³ kãi³ki̱³ju³tai²nãn²tu̱³ yain³txi³la³ ĩ²li³te²la³ ĩ³yain³ki̱³kxa² ha³ta̱³nxãn²txi³, hai³txi³ ko̱³nxe³ti³ kãi³ki̱³te²sxa³yu²hẽ³li¹. Jau¹xai²na² ã³ne³wxe³nx2ti³xa³ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","A²yain³txai²na² ĩ³yain³sxã³ txa²wã¹ẽ¹nãu³ai²na² ã³wih¹sxã³ tan³sa²tã³ki̱³te²jai¹ti²ti¹. Ta¹hxai²hẽ¹la². Nxe³jau³xai²na² a²si³yxau³tãu³a¹ yain³txa² yxo²ha³kxa¹ wi¹te²ju²hẽ³la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jã¹nxe³sxã³ Je³su²jah³la² wãn³txa² nxe³te³nah¹lxi¹: — Kwa²hãi¹nxe² txa²wã¹ẽ¹nãu³a¹ tẽ³ki̱³jau³xa² ko̱³nxe³jau³xai²la¹wi¹. Nxe³jau³xai²na² ne³kxe³kxi²nha²ki̱³sa²kxai³ hã²wxãn³txa³ txa²wã¹hxi²ka² ko̱³nxe³ti³ kãi³ki̱³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Txa²wã¹ẽ¹nãu³a¹ tẽ³ki̱³jau³xa²sa¹. Wãn³txa² ko̱³nxe³ti³ a̱in³nha²ki̱³jau³xa² tẽ³i², ko̱³nxe³thin¹sxã³ o²la³kxi²yhu¹ki̱³jau³xa² tẽ³i² a²nũ²a² ã̱³xa² a²yen³kxa² kãi³kxi²yhu¹ki̱³jau³xa² tẽ³i², su²lhã³yhu¹ki̱³jau³xa² tẽ³i² ã̱³xa² sxe³xa³ka³lxa¹ ũ³whĩn¹ti³kxi²yhu¹ki̱³jau³xa² tẽ³i² ã̱³xa² wẽ³sãi¹ah³la² ũ³whĩn¹ti³kxi²yhu¹ki̱³jau³xa² tẽ³i² a²nũ²a² ã̱³xa² yen³kxa² yxo²kwa̱i³no³nyhu¹ki̱³ju³ta² tẽ³i² a²yen³kxa² ko̱³nxe³ju³ta² kãi³ki̱³jau³xa² tẽ³i² ki³han³sxã³ ko̱³nxe³ti³ kãi³ti³hi¹ki̱³jau³xa² tẽ³i² kwa²yxo²ka̱u³ka³ti³ e³ki̱³jau³xa² tẽ³i² a²nũ²a² ã̱³xa² ĩ³ka³tã̱³yhu¹ki̱³jau³xa² tẽ³i² a²nũ²a² ã³xa² o³nxa³sxã³ ĩ³ye³kxi²yhu¹ki̱³jau³xa² tẽ³i² yxo²sa³te̱³txi³ ĩ³ye³kxi²yhu¹ki̱³jau³xa² tẽ³i² wãn³txa² wain³jau³xa² sa²yxo²ã³ki̱³jau³xa² tẽ³i², nxe³jau³xa²nãu³xai²na² whãi²na¹ txa²wã¹ẽ¹nãu³a¹ tẽ³ki̱³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tẽ³ki̱³kxai²nãn²tu̱³ a²nũ²a² ne³kxe³kxi²nha²ki̱³kxai²nãn²tu̱³ ko̱³nxe³ju³ta² kãi³ki̱³te²ju²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nxe³nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu² ĩ³sa²yxau³sxã³ nũ¹ã¹ a³li³ain¹ka³tu̱³ Ti²ro³thĩ³nãn¹ko³nãu³a³ Si³tõ²thĩ³nãn¹ko³nãu³a² ã³nxai³ta¹hxai²hẽ¹la². Ã³nxai³ka³tu̱³ sxi²ha² ã³wih¹ta¹hxai²hẽ¹la². — Thĩ¹nãu³ai²li² nũ̱h¹yxau³ti³ten³sa³nhã¹. Yxau³na¹ju³ta² a²nũ²a² ã̱³xa² ĩ²kxi²sain¹ju³ta² ten³sa²nxa³nhã¹. Je³su²jah³la² nxe³nha²ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²nũ²a² ka³na³ku² te²a² ĩ²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ain¹ka³tu̱³ txu¹ha² yau³ã̱³lxi³ti³ e³ta¹ka³lxu³su² te²a² Si²ri³a³ko³xa² to̱n¹ta¹ka³lxu³su² te²a², Kre²ka²yau³xa² so¹lxi³ e³ta¹ka³lxu³su² te²a² ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxai²na² a²ka³ne³lxa² ĩ³ton³kxi²ta¹hxai²hẽ¹la². Ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau³ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ ta¹ka³lxai²na² sa²kxai³lu² Je³su²jah³la² yxau³ju³ta² ain³kxi²ka³tu̱³ wxã³sxã³ Je³su²jah³la² a²yu³kxa² ãn³yxo²thu²kxi² ã³yu̱³ka̱³ta¹hxai²hẽ¹la². Nxe³sxã³, ĩ³ye³kxi²te³nah¹lxi¹: — Ko̱³nxe³te²a² yãu³ka³txa² txa²wẽ³sa² nxũ²kwa̱i³yxau²na³li¹. Te²su² ĩ³sa²si¹hã³kxi²txai¹nhẽ³li¹. Txu¹ha³ka³lxai²na² a²wãn³txa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yxãn¹ta¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹ txu¹ha³ka³lxai²na² ĩ³ye³kxi²te³nah¹lxi¹: — Ha³lo³kxit1sã²nhẽ³ni¹. Ju³te²a² nũ̱³ka̱³txai²na² txa²ya̱³lxa³khai³xai²na² sa²hau³kot3sã²na¹tũ¹xĩ¹. Na¹kxai²nãn²tu̱³ hã²wxãn³txa³ a²nũ²a² ã̱³lxi³te²su² sa²hau³ko³tũ³na¹tũ¹xĩ¹. Nxe³jut3sũ̱³ju³ta²sa¹. A²wi¹lhĩn¹khai¹xa² a²wẽ³ha³lxi³khai³xa² ĩ³yai³nain¹sãn²ka³tu̱³ hã²wxãn³txa³nũ² ãn³ta³lo³hẽ²ti²nũ²la² wai³a³lxi³nãu³xa² sa²kxai³lu² ũ³yhai¹tain¹te²ju²hẽ³ni¹. Ju¹ta² wain³na³ni¹. Nxe³ha²kxai³ ha³lo³kxit1sã²nhẽ³ni¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yxãn¹ta¹ txu¹ha³ka³lxai²na² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Wxa²wãn³txa² wain³khai¹nx2na³li¹. Yxãn¹ta¹ wẽ³ha³lxi³nãu³xa² ĩ³yai³nain¹kxai²nãn²tu̱³ a²yain³txa²nũ̱³xa² a²yu³hxai²na² a³hi²te²su² ã³yã̱³nũ̱³nũ̱¹tã³tũ̱³xa², a²wai³a³lxi³nãu³xa² sa²kxai³lu² ũ³yhai¹tain¹te²jai¹ti²tu³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxi²te³nah¹lxi¹: — Wxa²wãn³txai²na² wain³nũn³na³ni¹. Na¹ha²kxai³ a²yen³kxa² te³nĩn¹kxa², kãi³sxã³ ũ³hũ¹nxa²ha¹tũ¹xĩ¹. Ko̱³nxe³te² a²yãu³ka³txai²na², wxa²ka³ne³lxa² nxũ²kwa̱i³li³na²ni¹. Wa²su¹wa²su¹xai³txu¹ni¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nxe³ka³tu̱³ txu¹ha³ka³lxai²na² sa²kxai³lu² ĩ³xi²ka³tu̱³ a²wẽ³sai²na² sa²kxai³lu² a²sxa³ka³lo³a² wi¹lain³kxi²nha²sxã³ sxa³ta¹hxai²hẽ¹la². Ko̱³nxe³te² a²yãu³ka³txai²na² yũ³ti³he¹yxe²ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nxe³nxa²ha¹te¹ Je³su²jah³la² Ti²ro³thĩ³nãn¹ko³nãu³xa² wa²li³xi²sxã³ Si³tõ²thĩ³na² ã³wa²to¹ti², sxi²yhen³nãu³xã² hxi²ka² hxan³jen³nãu³xã² ã³wa²to¹ti² nxe³sxã³ ĩ̱³ye³na² Ka³li³le²a²ye³na² ã³nxai³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nxe³nxa²ha¹te¹ in³txa² hxi²kan¹ti³ha²kxai³ ne³ka³tũ³ha²kxai³ nxe³jah¹lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹la² a²nũ²a²nãu³xa² hi²sen³kxai³lu² tẽ³sxã³ ai³ain¹ka³tu̱³ Je³su²jah³la² ĩ³wã̱³txi³te³nah¹lxi¹: — Je³su²jah³lãi³, jah¹la² wxa²wxait3sĩ¹nhẽ³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","34","Nxe³te³na¹, Je³su²jah³lo²su² te²kxai³lu¹ in³txai²na² ĩ³yũ³so¹ta¹hxai²hẽ¹la². Nxe³nũ²la² a²hxi²ka² wẽ³ha³lxa² a²nũ²a² ĩ³ton³jah¹lai²na² a²ne³nxẽ³na² wxa²ne³tĩ̱¹la³kxain¹ka³tu̱³ ĩ³ka³su³hã¹sãn²sxã³ wxa²yu²he̱³to³hain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ oh³sĩ̱n³nãu³a¹ ten³sa²ka²la¹sxĩ²ka³tu̱³ ĩ³yat1sai¹kxi²nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — We²txi¹jxa³hxu¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nxe³sxã³ in³txai²na² sa²kxai³lu² e³xa³ju³ta² yxo²we²nxi²sxã³ wi¹lĩ³ye³i² nẽ³ka³tũ³ju³ta² we²nxi²sxã³ wi¹ne³kat1sa²tã³i² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nxe³te³na¹, Je³su²jah³la² a²wãn³txi³kxai³lu¹ a²nũ²a²nãu³xai²na² hãi¹nxe³ti³xa¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Ju¹tai²na² ĩ²yah³lxin¹ju³ta² a²nũ²a² ã̱³xa² ĩ³hen³txi³yah³lxi³txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². Yxãn¹ta¹, kãin² ĩ³ye³kxain¹to³kxa² ha³ta̱³nxãn²txi³nũ¹ kãin² ĩ³ye³kxain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ain¹sxã³ a²nũ²a² yxo²ha³kxa¹ ĩ³wã̱³wã̱³txi³sxã³ ĩ³ye³kxi²yhain¹te³nah¹lxi¹: — Je³su²jah³lai²na² a²yen³kxa² hãi¹nxe³ti³xa¹ wi¹khai¹nxe³sxã³ kãi³na³li¹. Kãi³ha²kxai³, a²nũ²a² ne³ka³tũ³jah¹la² ha³ta̱³nxãn²txi³ hĩ¹na² wi¹ne³kat1sa²tã³i², a²nũ²a² hai³txi³ ĩ³ye³xa³jah¹la² ha³ta̱³nxãn²txi³ hĩ¹na² ĩ³ye³i² nxain¹na³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hã²wxãn³txa³ a²nũ²a² ka³lxa¹khaix1tũ̱³ka̱³txa² ãn³yãn³ki³nũ²kxain¹ta¹hxai²hẽ¹la². Ain¹nũ²la² yain³txi³ txa²khaix1ai¹nha²kxai³ Je³su²jah³lo²su² te²kxai³lu¹ a²sa³wi³ha³lxi³nãu³xa² ĩ³kaix1sxã³ ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ĩ³ye³kxain¹te³nah¹lxi¹: — Tũ̱¹ka̱³txai²na² ĩ³ãin²ta³kxi²na¹nhai¹. Ye³ha¹li¹ ka³na³ki¹ a³lan²tãu³a² ã³si³tẽ³la³kxi² yxau³kxi²sain¹na²hẽ³li¹. Nxe³hĩ¹nãn¹te²tu̱³ yain³txi³la³ yũ³ai¹nxa³tai¹tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yũ³ai¹nxa³ha²kxai³ heh³ti³ ya²lun¹tain¹kxa²ya̱n³ti³su² hai³txi³ ĩ³sa²si¹hã³ai¹na¹ju³ta² ten³sa²nxa³nhai¹, u¹lxi³ wxã³ai¹nha²kxai³lu¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xai²na² a²wãn³txi³kxai³lu¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ha³lo²ai²na² a²nũ²a² yxau³ai¹nxa³ko³su² ye²ha²kxai³ ĩh¹nxet3sxã³ ka³lxa¹ain¹tũ̱³ka̱³txai²na² ĩ³yã̱³lã̱³ja³hain¹sĩn¹ki̱³te³ji¹wi¹? Hxi²ka¹nha²sĩn¹nx3nhai¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wã̱³txain¹te³nah¹lxi¹: — Yã¹te² yain³txi³nũ̱³txa³ yũ³nx2ti³ji¹wi¹? Nxe³ain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³, a²sa³wi³ha³lxi³nãu³xai²na² a²wãn³txi³kxai³lu²: — Nũ̱³ha¹li¹ nũ̱³ha¹li¹ nũ̱³ha¹li¹ ka³na³ki¹ yũ³sĩn¹na³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nxe³nxa²ha¹te¹ Je³su²jah³la² hi²sen³kxai³lu¹ a²nũ²a²nãu³xa² ã³wxe³si¹hain¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Nxain¹ka³tu̱³ yain³tũ̱³xai²na², hxi²tẽ³nha²nũ²la² Txa²wã¹sũ̱³na² ĩ³wi¹lxon³kxi²ki̱³jau³xa² ĩ³ye³kxi²ka³tu̱³ wxa²nãu²nãu²lxi³sxã³ a²sa³wi³ha³lxi³nãu³khaix3ai²na² sa²kxai³lu² ũ³hũ²xai³ain¹ta¹hxai²hẽ¹la². Nxe³sxã³ a²sa³wi³ha³lxi³nãu³khaix3ai²na² sa²kxai³lu², a²nũ²a² ã̱³xa² ka³lxa¹tũ̱³ka̱³txai²na² sa²kxai³lu² wxa²nhũ²xai³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jã¹nxai¹nha²kxai³, a̱i³na² wẽ³ha³lxi³su² kwa²ha³ya̱³kxa² ka³lxa²nxa³te²a² yũ³ain¹nũn³ta¹hxai²hẽ¹la². Te²su² hxi²tẽ³nha²nũ²la² ĩ³wi¹lxon³kxi²ki̱³jau³xai²na² ĩ³ye³kxi²sãn²ka³tu̱³, a²sa²wi³ha³lxi³khai³xa² ũ³hũ²xai³ka³tu̱³ a²nũ²a²nãu³xai²na² sa²nũ²xai³nyhain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nxe³sxã³ a²nũ²a² yxo²ha³kxa¹ ũ³kxin²tain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² yain³txa² wxa²nãu²lxi³kxe³su² a²wã³kon³kxe³su² wxa²sa²wi¹sxã³ ha³ti²a² nẽ³nha¹li¹ nẽ³nha¹li¹ nẽ³nha¹li¹ ka³na³ki¹ ne³ki²lhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A²nxe³sxã³ a²nũ²a²nãu³xa² wa̱³li̱³kha³lhon¹tũ̱³ka̱³txa² ka³lxa¹khai¹nxe³sxã³ 4.000 nxe² wa̱³li̱³kha³lhon¹tũ̱³ka̱³txi³su² ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² Je³su²jah³la² hi²sen³kxai³lu² ĩ³xi²si¹hain¹jau³su² ĩ³sa²si¹hã³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nxe³te³na¹ kwẽn¹ta²kxai³ Je³su²jah³la² a²sa³wi³ha³lxi³nãu³khai³xai²na² whãi²na¹ ka²no¹a² ã³wi¹hain¹ka³tu̱³ ha³lo²a² Tal³ma³nũ²ta³ko³xa² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nxe³nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² ã³nhai¹tũ³te²nãu³xai²na² a²hi²sen³kxai³lu² tĩ̱³yhain¹sxã³ Je³su²jah³la² ĩ³wã̱³wã̱³txi³sxã³ ĩ³ye³ye³kxa² ĩ³sa²nũ̱¹xi²yhain¹ta¹hxai²hẽ¹la². — Oh³nãu³a² wã³nxĩn¹sxã³ kãi³ju³ta² wã²na³ũ¹sah¹lxi³hẽ¹li¹. Nxe³ain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ Je³su²jah³la² ko̱³nxe³ti³hi¹tain¹jau³su² ĩ³ye³kxi²sai³nain¹ta¹hxai²hẽ¹la², fa³ri³se²a² nũ̱³ka̱³txai²na²sa². ");
INSERT INTO nabNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nxe³sxã³ Je³su²jah³lo²kxai³lu¹ kãin² ãin²ti³sxã³ ĩ³ye³te³nah¹lxi¹: — Wxãi²na² yxau²xai³yah³lxin¹tũ̱³ka̱³txi³ ĩ³nxai²na² wã³nxĩn¹ti³ ĩ³yau¹ũ¹nx2ta¹ju³ta² ten³yah³lxin¹nhai¹. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ten³yah³lxin¹ji¹wi¹? A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹i¹. Hai³txi³ wã³nxĩn¹ti³ ĩ³yau¹ũ¹nx2ta¹ju³ta³la³ wã²nã³ũh¹nx2ti³nxa³lho³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² ã³ain¹sxã³ ka²no¹a²ka³lo³a² ã³wi¹hain¹ka³tu̱³, ĩ̱³ye³na² yxo²ha³ti³nhãu³ã¹ ã³nxai³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ĩ³ye³nai²na² yxo²ha³ti³lhi³ain¹tãu³a² a²sa³wi³ha³lxi³nãu³khaix3ai²na² yain³tũ̱³xa² ne³wã²na³ain¹ta¹hxai²hẽ¹la². Ka³na³ka³na³tũ̱³xa² so¹lxi³ ka²no¹a²nãu³a² yũ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ai¹nha²kxai³ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Fa³ri³se²a² nũ̱³ka̱³txa² E³ro²jah³la² nxe³sxã³ a²yain³txa² ĩ³wa̱¹tũ̱³xa² ĩ²jah¹lxi³hẽ¹li¹. Ã³toh³nx2ti³ha³tai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nxe³jau³xai²na² yain³txi³nũ̱³yau³xai²na² a²sa³wi³ha³lxi³nãu³xa² nũ̱h¹ĩ³ye³kxi²nhain¹te³nah¹lxi¹: — Yain³tũ̱³xa² yũ³nẽ³lxa³i¹. Nxe³ha²kxai³ nẽ³lain¹na²li¹. Nxe³nhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nyhain¹jau³su², Je³su²jah³lai²na² ain³kxain¹ka³tu̱³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ yain³tũ̱³xa² yũ³nẽ³lxa³jau³su² e³ah¹lxin¹ji¹wi¹? Ha³lo²a² ĩ³yah³lxan³ji¹wi¹? Ã³ne³wxe³nx2ti³xa³ji¹wi¹? Ĩ³ne³wã³nũn³kxi¹nx2ti³ji¹wi¹? Nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","— Wxa²ye³na² whãi²na¹ yũ³nx2ti³kxan²ti³, ĩ²yah³lxan³ji¹? Wxa²ne³nxẽ³na² whãi²na¹ yũ³nx2ti³kxan²ti³, ain³kxi²nyhah¹lxan³ji¹? Nxe³wãn²yah³lxin¹ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ha³la³je¹nhĩ¹nai³tã², yain³tũ̱³xa² nũ̱³ha¹li¹ nũ̱³ha¹li¹ ka³na³ki¹ wxa²nãu²lxa¹sxã³, a²nũ²a² ka³lxa¹tũ̱³ka̱³txi³su² 5.000 nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² ũ³hũ²xai³ai¹na¹hĩ¹nai³tã² a²yain³tũ̱³xa² a²wã³kon³te²tũ̱³xa² ĩh¹nxe² ha³ti²a² ne³ki¹sxã³ so¹ah³lxin¹thai¹li¹? Nxe³ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — Ha³ti²a² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³tẽ³na¹, ne³ki¹sxã³ so¹a³sain¹tai¹ti²ti¹. A²sa³wi³ha³lxi³nãu³xa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jã¹nxe³sxã³ Je³su²jah³la² e³kxain¹te³nah¹lxi¹: — Ha³la³je¹nũn³tãu³ai³tã² nũ̱³ha¹li¹ nũ̱³ha¹li¹ nũ̱³ha¹li¹ ka³na³ki¹ wxa²nãu²lxa¹sxã³, a²nũ²a² ka³lxa¹tũ̱³ka̱³txi³su² 4.000 nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² ũ³hũ²xai³ai¹na¹hĩ¹nai³tã² a²wã³kon³te²tũ̱³xa² ĩh¹nxe² ha³ti²a² ne³ki¹sxã³ so¹ah³lxin¹thai¹li¹? Nxe³nxa²ha¹te¹: — Ha³ti²a² nẽ³nha¹li¹ nẽ³nha¹li¹ nẽ³nha¹li¹ ka³na³ki¹ ne³ki¹sxã³ so¹a³sain¹tai¹ti²ti¹. A²sa³wi³ha³lxi³nãu³xai²na² nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ai¹nha²kxai³ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — Wãn³txai²na² a²si³yxau³tãu³khai³xa² ã³nẽ³wxe³nx2ti³lã²nxãn³khi³. Nxe³nx2ta¹nhai¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nxe³nxa²ha¹te¹ Je³su²jah³la² nũ̱³ka̱³txa² Bet3sa³i²ta³thĩn³su² ta¹hxai²hẽ¹la². Nxe³thĩ³na² ã³wi¹hain¹ka³tu̱³, a²nũ²a² nũ̱³ka̱³txi³ ã̱³xa² sa²kxai³lu² ye³han³jah¹la² tẽ³nũ²la² Je³su²jah³la² ĩ³ha¹txi²te³lhxã³ tĩ̱³nyhain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Wxa²to³txain¹sĩ¹nhẽ³li¹. A²nũ²a²nãu³xai²na² ĩ³wã̱³txi³sxã³ ĩ³ye³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nxe³nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu¹ ye³han³jah¹lai²na² a²hxi²ki³kxai³lu¹ hxi²ki³sxã³, tẽ³sxã³ ha³lo²a² sxi²yhe³na² yxo²tu³ka³nãu³a¹ ã³nxai³ya³ta¹hxai²hẽ¹la². Nxe³sxã³ a²ye³na² ye³han³jah¹lai²na² a²ye³na² txa²wã¹yxo²ka²si¹yhau³xa² wxa²ye³wã̱³lã̱³kxain¹ka³tu̱³ a²hxi²ka² wxa²wxai³ain¹ka³tu̱³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹nxe³ju³ta² ĩ²in¹ji¹wi¹? Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nxe³nxa²ha¹te¹ ye³han³jah¹lai²na² a²wãn³txi³kxai³lu¹: — A²nũ²a² ĩ²a¹wi¹. Yxãn¹ta¹ hi³sa³kat3sũ̱³tain¹na³li¹. Te²su² ã³nxai³ain¹na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nxe³nxa²ha¹te¹ Je³su²jah³lo²kxai³lu² jã¹nxe³sxã³ wxa²ye³wxai³ai¹nha²kxai³, wi¹ten³sa²tã³ain¹ta¹hxai²hẽ¹la². A²yen³kxa² yxo²ha³kxa¹ wi¹lĩ²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nxe³nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu² ĩ³ye³kxi²te³nah¹lxi¹: — Sa²wai³wait3sxã³ wxa²sxi²yhen³khai³xai³tã² ĩ³xi²txu¹li¹. Yxãn¹ta¹ sxi²yhe³nai²na² ti¹nãn²ta³, ã³wih¹txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nxe³nxa²ha¹te¹, Se²sa³re²a² Fi³li³po²thĩ³nãn¹ko³xai²na² ã³nxai³ain¹ta¹hxai²hẽ¹la². Ain¹tãu³a² Je³su²jah³la² a²yxo²wãn³txa² a²sa³wi³ha³lxa² ĩ³wã̱³txi³te³nah¹lxi¹: — A²nũ²a² ã̱³nãu³xai²na² sa²kxai³lu² ĩ³yĩ¹li²sain¹jau³xa² e³kxi²nyhain¹kxai²nãn²tu̱³ ĩh¹nxe³jau³ta̱³ ĩ³yĩ¹li²sain¹jau³su² e³lain¹te²la¹xã³? Ĩ³yau¹ũ³nha¹jah³lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³khai³xai²na² wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³wã²lũ³xain¹te³nah¹lxi¹: — A²nũ²a²nãu³xai²na² a²ha³tih³xa² Jo³ãu² Ba³tis²jah³lo²su² ka³te̱n³su² ĩ³sa²yxau³xi²sxã³ wa̱³li²jah¹la² ĩ³yĩ¹li²nxai¹nha²kxai³ ã̱³xa² ha³tih³xai²na² sa²kxai³lu² E³li²ah³lo²su² ĩ³yĩ¹li¹nxai²nha²kxai³ ã̱³xa² ha³tih³xai²na² sa²kxai³lu² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²su² ĩ³yĩ¹li²nxai¹nha²kxai³ nxe³nyhain¹sĩ¹nhxai²na²hẽ³li¹. A²sa³wi³ha³lxa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³wã̱³txain¹te³nah¹lxi¹: — Yxãn¹ta¹ wxãi²nãn²ta³ ĩh¹nxe³jau³ta̱³ ĩ³yĩ¹li²syah¹lxin¹jau³su² e³yah³lxin¹ji¹wi¹? Nxe³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Pe²jah³lai²na² te²kxai³lu¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wxãi²na² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²jah¹lo²si¹lxi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nxe³ha²kxai³lu¹ Je³su²jah³la² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Nxe³jau³jau¹xai²na² a²nũ²a² ã̱³xa² ĩ³hen³txain¹yah³lxi³txa³hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jã¹nxain¹jau³su² Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³yau¹ũ³hain¹jau³xa²sa¹: — Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² Je³ru³sa³lẽ²thĩ³na² ai³na¹ju³ta³nũ³a² yũ²na³li¹. Nxa¹kxai²nãn²tu̱³ I³sa³e² a²hxi²kan¹txi³su² te²a² Sũ̱³na² sxi²ha² wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txi³su² te²a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²a² nxe³sxã³ te²nãu³xa² ĩ³a̱n³ta³kxi²sai¹nha²kxai³ khãuh³lxa³txi³sai¹nha²kxai³ ĩ³su²lhã³sa²si¹nyhain¹jau³su² ĩ³kwa³na³nyhain¹tu¹wi¹. Nxe³nũ²la² hã²wxãn³txa³ ye³ha¹li¹ ka³na³ki¹ a³la²ni²sxã³ ka³te̱n³su¹ ĩ³sa²yxau³xi²na¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nxe³jau³xai²na² yxo²wain³ti³ ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ Pe²jah³la² a²hi²sen³kxai³lu² Je³su²jah³lo²kxai³lu² ĩ³yũ³so¹sxã³ ĩ³kwa̱i²kxi²te³nah¹lxi¹: — Jã¹nxe³txa³hẽ¹li¹. Ta¹hxai²hẽ¹la², Pe²jah³la² wãn³txa²sa². ");
INSERT INTO nabNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nxe³nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu¹ sa²wa³ti̱³nha²sxã³ a²sa³wi³ha³lxi³nãu³xai²na² ĩ²sa²sai¹ain¹ka³tu̱³ Pe²jah³lai²na² ĩ³kwa̱i²ta³lxi³te³nah¹lxi¹: — Sa³ta³na²jah¹lãi³. Txa²si³yo³na² ã³waix3txu¹li¹. Txa²wã¹sũ̱³na² a²ten³jau³su² ten³nxa²nxa³i¹. A²nũ²ai²na² a²ten³jau³xai²na² so¹lxi³ te³ni¹lxi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jã¹nxe³jau³su² a²nũ²a²nãu³xai²na² ã³si³tẽ³kxain¹te²nãu³xa² a²sa³wi³ha³lxa² ain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. A²nũ²a² ĩ²li³te²nãn²tu̱³ ã³si³tẽ³kxi²ti³ten³sain¹kxai²nãn²tu̱³ a²ẽ¹nãu³a¹ a̱u³txi³ ten³khai¹nxe³ju³tan²tu̱³ ã³na¹txai²lxi¹. Te²yã¹nxe³sxã³ yxo²ĩ²sain¹ju³tan¹te²kxa³ya̱n³tu̱³ ĩ³ya²lut1ju³ta³nũ³a² yu̱h³lxi²nxa³sxã³ ã³si³tẽ³kxi²sain¹txai²li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jã¹nxa¹jau³su² wxãi²na² sa²kxai³lu² ĩ³ye³kxi²nyhah¹lxin¹kxai²nãn²tu̱³: “Yu̱h³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²wi¹la¹tãu³a¹ a³lxi²sa³nha¹. Je³su²jah³lai²na² wãn³txa² sa²yxo²ã³a¹kxan²ti³ ya³lu²ju³ta² ten³sa²nxa³nha¹.” Nxe³nyhah¹lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³lyah²lxan³tho³li¹. Yxãn¹ta¹: “Yu̱h³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²wi¹la¹tãu³la³ a³lxi²sa²nxa³nha¹. Je³su²jah³lai²na² wãn³txa² yxo²ĩ²a¹ju³tan¹te²kxa³ya̱³lhu² Je³su²jah³lai²na² wãn³txa² ĩ³hen³txai¹na¹ju³tan¹te²kxa³ya̱³lhu² ĩ³su²lhã³sain¹kxan²ti³ yxo²ĩ²a¹ju³ta² ã³na¹nxa³lho³na¹.” Nxe³yah³lxin¹kxai²nãn²tu̱³ Txa²sa³wi³ha³lxi³syah¹lxin¹tu¹wi¹. Nxe³kxa²yu³su² Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³lyah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Te²yã¹nxũn³sxã³ yu̱h³nãu³ãn¹ta² yen³kxa² a²hãi¹nxe³ti³xa¹ so¹kxi²hxa³kxai²nãn²tu̱³ yxãn¹ta¹ a²ẽ¹nãu³ai²na² a²ka³te̱n³yu³ta² tĩ̱¹kxi²kxai²nãn²tu̱³ nxe³te²su² te²na² ju³ju¹tai²na² a²yxo²ha³kxa¹ tĩ̱¹kxi²hĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ya³lu²ki̱³kxai²nãn²tu̱³ a²ka³te̱n³sa²ki̱³ju³khai³xa² hxi²kan¹ti³ ũ³yho³hxi²sxã³ so¹xi²ki̱³sĩ̱³nx2nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A²nũ²a²nãu³xai²na² yxau²xai³lain¹tũ̱³ka̱³txai²na² ko̱³nxe³ti³ kãi³ain¹to³hi² Txa²wã¹sũ̱³na² ã³na¹sxã³ ã̱³xa²sũ̱³na² te³nain¹to³hi² nxe³ain¹to³nha³li¹. A²nxe³tũ̱³ka̱³txai²na² a²nũ²a² ĩ²li³te²an²tu̱³ Txai²li² ĩ³yãu²lxi² txa²wãn³txa² wi¹jau³xa² ĩ³yãu²lxi² nxe³sain¹kxai²nãn²tu̱³ Txai²li² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² yan¹nãu³a¹ wxã³na¹tu¹wi¹. Txa²wĩ³na² wxi²kin³ti³ton³ju³ta² wxã³na¹tu¹wi¹. Sũ̱³na² sa³wi³ha³lxi³nãu³xa² wi¹lhin¹te²nãu³xa² oh³nãu³a¹ yxau³te²nãu³xã¹, ã³si³tẽ³kxi²sa²sxã³ wxã³na¹tu¹wi¹. Wxã³na¹kxai²nãn²tu̱³ ãu²li²sa²jah¹lai²na² sa²kxai³lu², Txai²li² ãu³lxain¹nũ³na¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Jã¹nxa¹ju³kxai³lu² a²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lo³sa³ju³ta³nũ³su² nxe³jau³xai²na² yxau³son³na³li¹. Wxa²nũ̱³ka̱³txe² ĩ³nxai²na² ka³na³ki²nũ² ya³lu²yah³lxi³xa³ta³lxa¹ ju¹tai²na² ĩ²yah³lxin¹tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nxe³nxa²ha¹te¹, ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ a³lan²ni²tãu³kxai³lu², Je³su²jah³lo²su² te²kxai³lu² wã³la³ka³txa² kĩn³khaix1ka³ta² ka³la³ta¹hxai²hẽ¹la². Nxe³te³na¹ Pe²jah³la² Ti³a²kah³la² Jo³ãu²ah³la² whãi²na¹, Je³su²jah³la² ãn³sa²so¹sxã³ ka³la³ya³hain¹ta¹hxai²hẽ¹la². Ka³la³ya³hain¹ka³tu̱³ a²ne³ka³nah²nãu³a² he¹ain¹tãu³a² Je³su²jah³la²nũ²a² sa²yã¹nha²ha²kxai³ ã̱³lxa³txi³ ĩ³we¹yhe²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A²wã²la³ka³lo³a² ũ³whih²kxi²nha²ka³lo³a² wã²la² yãn³txi³ hã³ka³lo³a² ĩ³ya¹nha²ha²kxai³ kãin² hã³ni² nxe³ju³tan¹te²kxa³ya̱n³tu̱³ti¹ ye³ha²te¹ta³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nxe³tãu³ Moi³se²ah³lu¹tai²na² E³li²ah³lu¹tai²na² ain¹sxã³ a³ka³nxa² wxã³yai¹nha²kxai³ Je³su²jah³la² ĩ³ye³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nxe³tãu³a¹ Pe²jah³lai²na² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³la² Txa²hxi²kan¹jah¹lãi³. Ti¹ai²li² ha³lo²a² wi¹yxau³khaix1sĩ¹na¹nhai¹. Nxe³sĩ¹nha²kxai³ sxi²ha² thĩ³nha¹li¹ ka³na³ki¹ txon³sĩ¹na¹tu¹wi¹. Wxa²sxi²ha² txo³ni² Moi³se²ah³la² sxi²ha² txo³ni² E³li²ah³la² sxi²ha² txo³ni² nxe³sĩ¹na¹tu¹wi¹, ten³nxa²sĩn¹ke³la³te²kxai³lu¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nxe³ju³ta² a²sa³wi³ha³lxi³nãu³xa² kãin² yu̱h³lai¹nha²kxai³ ĩ³wã̱³wã̱³ta³kxi²nha²sxã³ ĩ³ye³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nxe³nxa²ha¹te¹ oh³sĩ̱³na² hã³thĩ̱³na² a³hxi²sxã³ ãn³tĩ¹kxai¹nha²kxai³ oh³sĩ̱³nãn¹ta² wãn³txa² ain³kxain¹te³nah¹lxi¹: — Je³su²jah³lai²na² Txa²ki³lha³lxa² a³lxi²khaix1na¹jah¹lai²la¹wi¹. Wi¹lain³kxi¹txai¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ain¹ka³tu̱³ a²ha² kwẽn¹ta²kxai³ a²sa³wi³ha³lxi³nãu³xai²na² sa²kxai³lu² sa²ne³wa³ti̱³nha²sxã³ ĩ²sa²sai¹ain¹ka³tu̱³ Je³su²jah³la² so¹lxi³ ĩ²ain¹ta¹hxai²hẽ¹la². A²nũ²a² ã̱³te²su² yũ³ye²ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","10","Nxe³nxa²ha¹te¹ wã³la³ka³txai²na² wxa²ka³nain¹nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ a²sa³wi³ha³lxai²na² ĩ³ye³kxi²te³nah¹lxi¹: — Ju¹tai²na² ĩ²syah¹lxin¹ju³tai²na² a²nũ²a² ã̱³xa² ĩ³hen³txi³ti³hex1yah³lxi³sãn²txa³hẽ¹li¹. Hã²wxãn³txa³ Txai²na¹xai²na² ya³lu²na¹ka³tu̱³ ka³te̱n³ti³ ĩ³sa²yxau³xi²na¹tãu³a² hã²wxãn³txa³ a²nũ²a² ĩ³hen³txain¹yah³lxin¹ju³ta³nũ³a² wain³na³li¹. Ta¹hxai²hẽ¹la². Nxe³sxã³ a²sa³wi³ha³lxai²na² ko̱n³ton³ti³khaix1ain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ nxe³ju³tai²na² sa²kxai³lu² ĩ³ye³lain¹te³nah¹lxi¹: — Ya³lu²sãn²sxã³ ka³te̱n³su² ĩ³sa²yxau³xi²ju³ta² a²si³yxau³tãu³khai³xa² ĩh¹nxe³khaix3te²la¹ku¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nxe³te³nah¹lxi¹ a²sa³wi³ha³lxi³nãu³xa² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³wã̱³txain¹te³nah¹lxi¹: — Ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² e³jau³xa²sa¹: “E³li²ah³lu¹tai²na² txa²nũ² wxã³tu¹wi¹.” Ain¹na³li¹. Nxe³ju³ta² ĩh¹nxe³kxa²ya̱n³ti³ta̱³ wãn³txa² jau³xai²na² ĩ³ye³ain¹te²la¹xã³? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Ya²la³tu̱³ E³li²ah³la² wxã³tu¹wi¹. Txa²ne³hẽ³txa² wxã³sxã³ yen³kxa² yxo²ha³kxa¹ sa²hau³kot3tũ¹sa³tu¹wi¹. Nxe³to³ta¹ a²nũ²a²nãu³xa² en²sain¹sxã³ ko̱³nxe³ti³ kãi³ũ¹sain¹tu¹wi¹. Nxe³ju³ta²nũ³a² ha³te̱h³nxã³nxa² ũ³wha²li¹ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yxãn¹tah¹lxa¹ wãn³txi³khai³su² e³kxi¹nx2ta¹wi¹. E³li²ah³la² ã²la² wxã³na²hẽ³li¹. Nxe³txai³tã² a²hxi²kan¹ti³nãu³a² hi²sen³su² ko̱³nxe³ti³ kãi³ju³ta² so¹lxi³ te³nai¹nha²kxai³ ko̱³nxe³ti³ kãi³ũ¹hain¹na²hẽ³li¹. Nxe³ju³ta² ha³te̱h³nxã³nxa² ũ³wha²li¹ta¹hxai²ti³ai¹ti²tu³wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nxe³nxa²ha¹te¹, Je³su²jah³la² nũ̱³ka̱³txa² a²hi²sen³kxai³lu² a²sa³wi³ha³lxi³nãu³khai³xa² wã³kon³tũ̱³ka̱³txa² ya̱u³so³nain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² a²nũ²a² ka³lxa¹tũ̱³ka̱³txi³ ã̱³xa² hi²sen³kxai³lu² a²wã³kon³tũ̱³ka̱³txai²na² ã³ki³ka³ti³kxi²yhai¹nha²kxai³, a²ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² a²hi²sen³kxai³lu² a²wã³kon³tũ̱³ka̱³txai²na² ĩ³wã̱³wã̱³txi³sxã³ ĩ³ye³kxi²yhai¹nha²kxai³, ta¹hxai²hẽ¹la². Nxe³ju³tai²na² Je³su²jah³la² nũ̱³ka̱³txa² ya̱u³son³sxã³ ĩ²kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nxe³nxa²ha¹te¹ a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² hi²sen³kxai³lu¹ Je³su²jah³la² ĩ²ain¹tãu³ ĩ³wã̱³wã̱³ta³kxai¹nha²kxai³ ã³ni³sxã³ wi¹la³ ĩ³hen³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ain¹te³na¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹nxe³jau³ta̱³ ĩ³ye³kxain¹yah³lxin¹ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yxãn¹ta¹ ka³lxa¹tũ̱³ka̱³txai²na² tau³ta² a²nũ²a² ka³na³ka³na³te²su² te²a² ĩ³ye³kxi²te³nah¹lxi¹: — Tih³nxe³sa²jah¹lãi³. Txa²wẽ³sai²na² tẽ³sxã³ tĩ̱³nxa²ha¹wi¹. Ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau²na³li¹. Nxe³ha²kxai³ txa²wẽ³sai²na² hxi²kan¹txi³ ĩ³ye³xa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A²nxũ²kwa̱i³yxau²na³na¹ nain¹ka³tu̱³ kĩ̱h³nũ̱³xa² ti³sa²tã³ yxo²ka²tũ¹yhai¹nha²kxai³ kãin² yxo²ka³si³ha²kxai³ kãin² wxi²ka³ta³ta³tha²kxai³ a²nũ²ai²na² ĩ³kan²ta³kxi²ti³ha²kxai³ ain¹na³li¹. Ju¹ta² wxa²sa³wi³ha³lxi³nãu³xai²na² ĩ³ye³kxai¹na¹li¹, ko̱³nxe³te²a² yãu³ka³txa² ĩ³nxũ²kwa̱i³li³si¹hain¹jau³su¹. Yxãn¹ta¹, hxi²kan¹ti³hex1nai¹nxa³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ã³ne³tot3syah¹lxa³lxi¹. Yxo²ĩ²nxa³sxã³ wain³txi³ ain³kxah²lxa³lxi¹, kan²txi³ yxau³kxi¹nx2ta¹kxan²ti³nu¹. Wẽ³sa² tẽ³sxã³ wxã³jah¹lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ain¹ka³tu̱³ wẽ³sai²na² sa²kxai³lu² tẽ³sxã³ wxã³ain¹ka³tu̱³ ko̱³nxe³te² yãu³ka³txai²na² sa²kxai³lu² Je³su²jah³la² ĩ²tãu³ a²wẽ³sai²na² tẽ³sxã³ ĩ³ka³ta̱³ta̱³kxai¹nha²ha²kxai³ kĩ̱h³nũ̱³xa² ã³ya³hain¹sxã³ ã³nhe¹nhe¹ain¹sxã³ ãn³wa³ti³wa³ti³txa¹ain¹sxã³ ĩ³yxo²wxãun¹nha²khaix1sxã³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","22","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu² a²wẽ³sa² wĩ³na² ĩ³wã̱³txi³te³nah¹lxi¹: — Ĩh¹nxe³hĩ¹nai³tã² ã³nxũ²kwa̱i³wi¹lhai¹li¹? Nxe³sxã³ ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: — A²wẽ³son³ti³hĩ¹nai³tã² ĩ³to³nain¹na²hẽ³li¹. Ye³ka³lxa¹txi³ ha³nxe²a²nãu³a¹ ã³ya³hi²sxã³ ã³nhi̱³li² ye³ka³lxa¹txi³ ĩ̱³yau³xa²nãu³a¹ ã³ya³hi²sxi³ ã³nũ̱¹i² nxe³hxai²na²hẽ³li¹, ĩ³ya³lu²si¹jau³su¹. Yxãn¹ta¹ hxi²kan¹nxa²ke³la³te²kxai³ wxa²hau³kot3sa²sĩ¹nhẽ³li¹. Txa²khãuh³lxa³ti³hit1sa²sĩn¹ju³ta² ĩ³ãin²ta³kxi²sa²sĩ¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — “Hxi²kan¹nhĩ̱³nxãn¹ji¹?” Nxe³sa²txa³hẽ¹li¹. Yxo²ĩ²san¹kxai²nãn²tu̱³ a²yen³kxa² a²te³nĩn¹kxa² Txa²wã¹sũ̱³na² hi²sen³su² wxa²hau³ko³txa²tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nxe³nxa²ha¹te¹: — Yxo²ĩ²nxa²ha¹wi¹. Sa²wai³wait3sxã³ yxo²ĩ²nxa²ha¹ju³ta² sa²wet1sẽ¹li¹. A²wĩ³na² wãn³txa² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nxe³ka³tu̱³ a²nũ²a²nãu³xa² ã³ni³sxã³ ã³yã³nũ²ki² ã³si³wxe³ain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² Je³su²jah³la² ĩ²ka³tu̱³ wxi²kan¹sxã³ ko̱³nxe³te²a² yãu³ka³txa² ĩ³kwa̱i²kxi²te³nah¹lxi¹: — Ko̱³nxe³te²a² yãu³ka³txãi³, ne³ka³tũ³si¹te² yãu³ka³txãi³, yxo²ka³tũ̱³si¹te² yãu³ka³txãi³. Ĩ³kwa³na³nxa²ha¹wi¹. Wẽ³sai²na² wxa²nxũ²kwa̱i³li³txu¹li¹. Ã³wi²xi²ti³hex1txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nxe³nxa²ha¹te¹ ko̱³nxe³te²a² a²yãu³ka³txai²na² kãin² wxan¹ka³tu̱³ wẽ³sai²na² kãin² ã³nhe¹nhe¹khaix1ain¹ka³tu̱³, a²nxũ²kwa̱i³li³ta¹hxai²hẽ¹la². Nxe³sxã³ a²wẽ³sai²na² sa²kxai³lu² ya³lu²te²hũ̱³nxe² sxa³ta¹hxai²hẽ¹la². Nxe³ju³ta² a²nũ²a² ka³lxa¹te²a² ĩ³ye³ain¹te³nah¹lxi¹: — Ya³lu²na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yxãn¹ta¹ Je³su²jah³la² hxi²ki³sxã³ sa²yxo²ka³ta³wxe³ain¹ka³tu̱³ wẽ³sai²na² ĩ³sa²yxau³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nxe³nxa²ha¹te¹ ye³jen¹nãu³a¹ Je³su²jah³la²kxai³ sxi²nhãu³ã¹ ã³wih¹ka³tu̱³ a²sa³wi³ha³lxi³nãu³khai³xa² nũ̱h¹ ĩ³wã̱³txain¹te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ko̱³nxe³te² yãu³ka³txai²na² hxi²kan¹ti³ nxũ²kwa̱i³li³si¹sĩ¹nxa³thi²li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nxa²ha¹te¹ Je³su²jah³la²kxai³ ĩ³wa²lũ³xi²te³nah¹lxi¹: — A²yãu³ka³txai²na² te²u¹jã¹nxe³ka² he³la³ku³la³ wa³su³txi³ nxũ²kwa̱i³li³si¹te²sxa³yu²hẽ³li¹. Hãi¹nxe³sxã³ sa²wai³wait3sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²ki̱³sa²kxai³, ĩ³sa²si¹hã³ki̱³te²ju²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nxe³nxa²ha¹te¹, Je³su²jah³la² nũ̱³ka̱³txai²na² wa²li³ain¹ka³tu̱³ Ka³li³le²a²ko³xa² wxa²ha³nãu³hain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ he¹ain¹ju³ta² ha³ta̱³nxa² a²nũ²a² ã³xa² ain³kxain¹ju³ta² Je³su²jah³la² te³nain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Hãi¹nxe³sxã³ nũ̱h¹yxau³sxã³ a²sa³wi³ha³lxi³nãu³xa² wãn³txi³khai³xa² ĩ³yau¹ũ³ti³ten³ta¹hxai²hẽ¹la². Ĩ³yau¹ũ³te³nah¹lxi¹: — A²nũ²a² ko̱¹ko̱¹xa² hxi²ka² ã³yũ³nhi²sain¹tu¹wi¹. Nxe³sain¹kxai²nãn²tu̱³ ĩ³su²lhã³sain¹tu¹wi¹. Yxãn¹ta¹ su²lhã³sain¹kxan²ti³ ye³ha¹li¹ ka³na³ki¹ a³la²ni²tãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yxãn¹ta¹ nxe³jau³xai²na² sa²kxai³lu² a²sa³wi³ha³lxi³nãu³xai²na² ã³ne³wxe³ain¹ta¹hxai²nxa³hẽ¹la². Ain¹kxan²ti³ yu̱h³lain¹jau³su² wãn³txai²na² a²si³yxau³tãu³khai³xa² ĩ³wã̱³txain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nxe³nxa²ha¹te¹ Ka³far³na³ũ²thĩ³na² ã³wi¹hain¹nxa²ha¹te¹ Je³su²jah³lo²su² te²kxai³lu¹ sxi²ha² ã³wih¹sxã³ yxau³ka³tu̱³ a²sa³wi³ha³lxi³nãu³xai²na² ĩ³wã̱³txi³te³nah¹lxi¹: — Tĩh³na² ã³nxai³yah³lxin¹tãu³a² ĩh¹nxe³jau³ta̱³ ĩ³ye³kxi²nyhah¹lxin¹yu²lhi²li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yxãn¹ta¹ ko̱n³ton³tain¹ta¹hxai²hẽ¹la². — Txa²wã¹wa³kxẽ³na¹xai²na¹, ĩh¹te²la³ta̱³ hxi²kan¹ti³la³ ki̱³te³ji¹wi¹? Nxe³jau³xai²na² tĩh³na² ĩ³ye³lain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ ko̱n³ton³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nxe³nxa²ha¹te¹ Je³su²jah³lo²kxai³lu¹ ã³wxe³sxã³, a²sa³wi³ha³lxi³nãu³xai²na² hxi²ka²hxan³sxã³ ha¹li¹ wxa²hait1so¹xi²nũn³te²su² te²a² ĩ³kaix1sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩ¹ne³ka²sah¹lxi³sã²lxi¹. A²nũ²a² a²ten³te²su² te²an²tu̱³: “Hxi²kan¹txi³su² ti³ten³sa³nhã¹.” Nĩn¹kxai²nãn²tu̱³, a²nũ²a² yxo²ha³kxa¹ a²wa³ka³li³lo³je²txai¹nhu¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nxe³te³na¹, wẽn³su² sa²so¹sxã³ nxũ²kwa̱i³ye³ye³lot3sxã³ ũh³wxe³ka³tu̱³ wxa²sa²ha³lxo¹so¹ka³tu̱³, a²sa³wi³ha³lxi³nãu³xai²na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a² ĩ²li³te² ĩ³nxa² a³lxi²sa¹nha²kxai³ wẽ³sai²na² te²yã¹nxe³ te²he³la³ku³la³ sa²hau³ko³tai¹nĩn¹kxai²nãn²tu̱³ Txai²na² hxi²nũ¹san¹kxa² yã¹nxe³hĩ̱³nx2na³li¹. Hxi²nũ¹san¹kxai²nãn²tu̱³ Sũ̱³na² ĩ³sa²si¹hã³sa²jah¹lo²su² te²a² hxi²nũ¹nain¹kxa² yã¹nxe³hĩ̱³nx2na³li¹. Hai³txi³ Txai²na² so¹lxi³ hxi²nũ¹sa²hĩ̱³nx2nxa³lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nxe³nxa²ha¹te¹ Jo³ãu²ah³la² a²wãn³txi³kxai³lu¹: — Ĩ³tih³nxe³sa²jah¹lãi³. In³txa² ĩ²sĩ¹na¹hẽ³li¹. A²nxe³jah¹la² wxi²ka¹nĩn¹ju³ta² ĩ²so¹nxain¹sxã³ ko̱³nxe³te²a² yãu³ka³txa² a³li³si¹jau³su² ĩ³kwa³na³ain¹na²hẽ³li¹. Yxãn¹ta¹ ĩ³hit2txi²nxai¹nxa³ha²kxai³: “Hãi¹nxã¹txai¹nhẽ³li¹.” Nxe³si¹jau³su² kwa³na³ain¹sĩ¹na¹hẽ³li¹, ĩ³hi²txi²nẽ³lxa³ha²kxai³lu¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yxãn¹ta¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — Ĩ³hxi²ko²lain¹yah³lxi³txa³hẽ¹li¹. Nxe³ju³tai²na² ĩ³yau¹ũ³nx2ta¹wi¹. A²nũ²a² a²ten³te²su² te²an²tu̱³, Wxi²ka¹na¹ju³ta² ĩ²so¹sa²sxã³ wã³nxĩn¹sxã³ kãi³ain¹kxai²nãn²tu̱³ hai³txi³ kwẽn¹ta²kxai³ wãn³txa² ko̱³nxe³jau³xa² ĩ³ye³kxi²sai¹nxa³lho³li¹. Nxe³ha²kxai³ ya³nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","A²nũ²a² ĩ³ko̱x1ko̱¹son²kxi²nẽ³lai¹nxa³te²su² te²an²tu̱³ txa²wã¹yan³tain¹te²lxã²na³li¹. Nxe³ha²kxai³ ĩ³hxi²ko²lain¹yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. Wxãi²na² txa²sa³wi³ha³lxi³nãu³sah¹lxi¹lxi¹. Yah³lxi¹nha²kxai³, a²nũ²a² ĩ²li³te²a² a³lxi²sai¹nha²kxai³ ĩ̱³yau³xa² ka³te³ha² ne³ki¹sxã³ ĩ³na²te³lhxã³ ũ³hũ¹nxa²lxain¹kxai²nãn²tu̱³ te²kxai³ a²yo³ha² yũ³ain¹tu¹wi¹. Txa²wã¹sũ̱³na² a²ya³la³tu̱³ ũ³yho³hain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","A²nũ²ai²na² yxo²ĩ² ã³si³wxe³te²na² sa²kxai³lu² Txa²wãn³txa² sa²yxo²ã³si¹jau³su² ĩ³tih³nxe³yah³lxi³txa³hẽ¹li¹. Nxe² ĩ³tih³nxain¹kxa²yo³ha² kãin² khãuh³lxa³thin¹tu¹wi¹. A²nũ²a² tah³lxa³kxa² sa³txe̱²khai¹nxe³ka³txa² tẽ³sxã³ ĩ³yxe²ta³kũ¹nha²te²su² jah¹lan²tu̱³ ĩ̱³yau³xa² u¹jau³xa² so¹sxã³ ãn³sa³nũ̱¹ke³la³te²kxai³ nxe³jah¹la² khãuh³lxa³ti³nha²ju³ta² kãi²nhĩ̱³nx2na³li¹. Nxe³kxa² ha³tih³xan²tu̱³ a²nũ²ai²na² kwẽn¹ta² yxo²ĩ² ã³si³wxe³te²na² sa²kxai³lu² Txa²wãn³txa² sa²yxo²ã³sa²si¹hain¹jau³su² ĩ³tih³nxe³te²su² jah¹lan²tu̱³ ko̱³nxe³thin¹khaix1jah¹lo²su² hĩ̱³nx2na³li¹. A²nxe³jah¹la²kxai³la¹ khãuh³lxa³ti³ wa³to²hi²hai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ko̱³nxe³ti³ kãi³yah³lxin¹kxa²ya̱n³ti³su² wi¹lĩ²nha¹jah¹lxi³hẽ¹li¹. Nxe³yãn¹ta¹ wxa²hxi²ka² ko̱³nxe³ti³ kãi³sih¹nx2ti³te³lhxã³ kxai²nãn²tu̱³ ĩ³hxi²yo³la³kã¹nha¹jah³lxi³hẽ¹li¹. Nxe³ha²kxai³ hxi²ka³na³ka³na³ta² so¹lxi³ yũ³ah³lxin¹kxan²ti³ yan¹nãu³a¹ ka³te̱³na² ne³ki³so³txa³ju³ta² ã³wi¹yhah³lxin¹kxai²nãn²tu̱³ wi¹lhin¹yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yãn¹ta¹ hxi²kha¹li¹ yũ³ah³lxin¹sxã³ ha³nxe²a² i̱³sa²tẽ³ju³ta² ĩ³yũ¹li²nxa³ju³ta² ã³wih¹ah³lxin¹kxai²nãn²tu̱³ khãuh³lxa³ti³nha²khai¹yxah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nxe³tãu³a² a²nũ²a² ya³lu²ju³ta² yũ²nxa³ha²kxai³ ha³nxe²a² i̱³sa²tẽ³ju³ta² yũ³ha²kxai³ nxe³sa²tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te²yã¹nxe³sxã³ wxa²yu̱³kxa² ko̱³nxe³ti³ kãi³sih¹nx2ti³te³lhxã³ kxai²nãn²tu̱³ ĩ³yu̱³yo³la³kã¹nha¹jah³lxi³hẽ¹li¹. Nxe³ha²kxai³ yu̱³ka³na³ka³na³ta² so¹lxi³ yũ³ah³lxin¹kxan²ti³ yan¹nãu³a¹ ka³te̱³na² ne³ki³so³txa³ju³ta² ã³wi¹yhah³lxin¹kxai²nãn²tu̱³ wi¹lhin¹yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yãn¹ta¹ yu̱³kha¹li¹ yũ³ah³lxin¹sxã³ ha³nxe²a² i̱³sa²tẽ³ju³ta² ĩ³yũ¹li²nxa³ju³ta² ã³wih¹yah³lxin¹kxai²nãn²tu̱³ khãuh³lxa³txi³nha²khai¹yxah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nxe³tãu³a² a²nũ²a² ya³lu²ju³ta² yũ²nxa³ha²kxai³ ha³nxe²a² i̱³sa²tẽ³ju³ta² yũ³ha²kxai³ nxe³sa²tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te²yã¹nxe³sxã³ wxa²ye³nai²na² ko̱³nxe³ti³ kãi³sih¹nx2ti³te³lhxã³ kxai²nãn²tu̱³ ũ³yhe³ki³sa²tã³nha¹jah³lxi³hẽ¹li¹. Nxe³sxã³ ye³ki³ka³na³ka³nat3sxã³ ye³yũ³ah³lxin¹kxan²ti³ yan¹nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa³hĩ¹na¹ yxau³yah³nx2ti³kxai²nãn²tu̱³ wi¹lhin¹yah³lxi³hĩ̱³nxa¹lxi¹. Yxãn¹ta¹ ye³ki³ha¹li¹ ye³yũ³ah³lxin¹sxã³ ha³nxe²a² i̱³sa²tẽ³ju³ta² ĩ³yũ¹li²nxa³ju³ta² ã³wih¹yah³lxin¹kxai²nãn²tu̱³ khãuh³lxa³ti³nha²khai¹yxah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nxe³tãu³a² a²nũ²a² ya³lu²ju³ta² yũ²nxa³ha²kxai³ ha³nxe²a² i̱³sa²tẽ³ju³ta² yũ³ha²kxai³ nxe³sa²tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jã¹nxa¹jau³su² kxã³nhxĩ¹nu¹tai²na² ka³yxuh³xa² ũ³hi̱³lhxã³ Txa²wã¹sũ̱³na² ũ³hũ¹ain¹ki̱³kxai²nãn²tu̱³, sa̱h²ne³kxa² ũ³kah¹sãn²sxã³ wxa²sĩ̱³nã̱u³ta³lxi³sãn²sxã³ ũ³hi̱³lhxã³ ũ³hũ¹ain¹to³ki̱³ta¹hxai²ti³ai¹ti²tu³wi¹. Jã¹nxe³to³ki̱³tã³li¹. Jã¹nxe³sxã³ a²nũ²a² sa²yxo²wet1sah²lxin¹kxai²nãn²tu̱³ ã³ne³wxe³yah³lxin¹tu¹wi¹. Nxe³yah³lxin¹kxai²nãn²tu̱³, wxa²ẽ¹nãu³nũ¹ai²na² whãi²na¹ wi¹le³nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sa̱h²ne³ki³su² tẽ³ki̱³kxai²nãn²tu̱³ yain³txa² ũ³sa²wi²kxi²ki̱³kxai²nãn²tu̱³ wi¹yain³ki̱³te²ju²hẽ³li¹. Yxãn¹ta¹ a²kah³ju³ta² yũ²nxa³sxã³ sũ̱¹kxai²nãn²tu̱³ hxi²kan¹txi³ kah³xi²te²sxa³yu²hẽ³li¹. Te²yã¹nxe³kxe³hũ̱³sxã³ hãu²no³nyhu¹sxã³ yxau²xai³yah³lxin¹kxai²nãn²tu̱³ sa̱h²ne³kxa² yã¹nxe² a²nũ²a² wi¹kãi³ũ¹hain¹yah³lxi³hĩ̱³nxa¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³sa²yxau³sxã³ a³li³ka³tu̱³ Ju³te²a²ko³nãu³a¹ Jor³tãu²yau³xa² a²yxo²ha³tih³nãu³a¹ ã³wi¹hain¹ta¹hxai²hẽ¹la². Nxe³ju³tai²na² a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² tĩ̱³nhãun¹sxã³ Je³su²jah³la² ĩ²ain¹te³lhxã³ tĩ̱³xain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Je³su²jah³la² wãn³txa² ĩ³yau¹ũ³hain¹to³kaix3 jã¹xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nxe³nxa²ha¹te¹ fa³ri³se²an¹te²a² ka³na³ku² wxã³ain¹sxã³ Je³su²jah³la² ĩ³ki³ha¹kxi²si¹hain¹jau³su² ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². Ĩ³wã̱³txain¹te³nah¹lxi¹: — Je³su²jah³lãi³. In³txai²na² sa²kxai³lu² ĩ²li³tãu³a² a²txu¹ha³ka³lxa² ã³na¹kxai²nãn²tu̱³ wain³ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ĩh¹nxe³jau³ta̱³ Moi³se²ah³lu¹tai²na² ĩ³ye³kxi¹nx2tain¹ta¹hxai²hẽ²lhai¹li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nxe³nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: — Moi³se²ah³lu¹tai²na² hãi¹nxa² ã³ni³lain¹ju³tai³ta²su¹: “In³jah³lo²su² te²ĩ̱³nxa²: ‘Txa²sxe³xa³ka³lxa² ã³na¹a¹tũ¹xã¹.’ Nẽn¹kxai²nãn²tu̱³ wxa²sxe³xa³ka³lxa² ã³na¹te³lhxã³ nẽn¹jau³su² ha³te̱h³nxã³nxa² tẽ³sxã³ a²ten³jau³su² ũ³wha²li¹txa²hẽ³li¹. Nẽn¹kxai²nãn²tu̱³ a²sxe³xa³ka³lxa² ã³na¹in¹ju³ta² yũ²na³li¹.” Nxe³ju³ta² Moi³se²ah³lu¹tai²na² hãi¹nxa² ã³ni³lain¹ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yxãn¹ta¹ Je³su²jah³la² wãn³txi³kxai³lu²: — Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²we¹ti³ten³nxa²lxa³nha²kxai³, Moi³se²ah³lu¹tai²na² wãn³txa² txu¹ha² ã³na¹te³lhxã³ nxe³jau³xai²na² ũ³wha²li¹lhxã³ ũ³hũ¹nx2tain¹ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yxãn¹ta¹ a²wi¹lhĩ¹nu¹tai²nãn¹te²tu̱³, Txa²wã¹sũ̱³na² a²hi²sen³kxai³lu¹ in³txa² we¹ti² txu¹ha² we¹ti² nxe³to³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jã¹nxe³ju³kxai³lu² in³txai²na² sa²kxai³lu² a²wĩ³na² a²hã³ka³nũ¹na² nxe³sxã³ ã³waix3tũ²la² a²sxe³xa³ka³lxa² so¹lxi³ tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nxe³sa³ha²kxai³ in³txa² txu¹ha² a²nũ²ka³na³ka³nat3ton³tu¹wi¹. A²nũ²a² ha¹li¹o³nxa³wi¹. A²nũ²ka³na³ka³nat3jah³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nxe³ha²kxai³ Txa²wã¹sũ̱³na² hi²sen³kxai³lu² ã³nũ²kxi²ya³te²sin²ta²wi¹. Nxe³kxe³su² a²nũ²ai²na² sa²kxai³lu² ã³nhai²ta³lxi³si¹hain¹kxai²nãn²tu̱³ nxe² kãi³yah³lxi³txa³hẽ¹li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nxe³ju³tai²na² sa²kxai³lu² sxi²ha² ã³wi¹hain¹ka³tu̱³ a²sa³wi³ha³lxai²na² jã¹nxe³ju³ta² ĩ³wã̱³txi³sain³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nxe³nxa²ha¹te¹ Je³su²jah³la² wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — In³txa² a²ten³te²su² te²an²tu̱³ a²sxe³xa³ka³lxa² ã³na¹ka³tu̱³ txu¹ha² ã̱³lxi³te²a² so¹ain¹ke³la³te²kxai³ txu¹ha² ã̱³xa² ũ³whĩn¹ta³kxi²nyhain¹kxa² yã¹nxe² hxi²ki³lot3hĩ̱³nx2na³li¹. Ko̱³nxe³ju³ta² kãi³kxi²hĩ̱³nx2na³li¹, in³jah¹la²sa³. ");
INSERT INTO nabNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jã¹nxe³jau³su² txu¹ha² a²ten³te²su² te²an²tu̱³ a²wẽ³sãi¹ai²na² ã³na¹ka³tu̱³ in³txa² ã̱³lxi³te²a² so¹ain¹ke³la³te²kxai³, in³txa² ã̱³lxi³te²a² ũ³whĩn¹ta³kxi²nyha²kxa² yã¹nxe² hxi²ki³lot3ta¹ka³lxu³su² hĩ̱³nx2na³li¹. Ko̱³nxe³ti³ kãi³ju³tai²la¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nxe³nxa²ha¹te¹ a²nũ²a² a²wẽ³ha³lxa² tẽ³ain¹ta¹hxai²hẽ¹la². Je³su²jah³la² wxa²wxai³tai²la¹ ain¹jau³su² tẽ³kxain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²sa³wi³ha³lxi³nãu³xã² ĩ³hxi²ko²lain¹jau³su² yxo²xũn³txi³ ĩ³kwa̱i²kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nxe³ju³ta² sa²kxai³lu¹ Je³su²jah³lai²na² ĩ²ka³tu̱³ ĩ³xa̱n³txi³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ne³ka²sah¹lxi³sa²lxi¹. Wẽ³ha³lxa² tẽ³sxã³ wxã³ain¹ju³tai²na² ĩ³hxi²ko²lain¹yah³lxi³txa³hẽ¹li¹. Wẽ³sai²li² a²wĩ³na² wãn³txa² yxo²ĩ²te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² Txa²wã¹sũ̱³na² wãn³txa² yxo²ĩ²jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² Txa²wã¹sũ̱³na² ha³lo²a² yxau³yah³lxin¹ju³ta³nũ³a² yũ³nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A²ya³la³tu̱³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³su² nxe³jau³xa² ten³nxa²lxi³kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²we¹jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³ai²li² ĩ²yah³lxin¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nxe³sxã³ a²wẽ³ha³lxi³nãu³xai²na² sa²ha³lxo¹so¹ain¹sxã³ wxa²wxai³ain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wi¹ju³ta² ũ³hũ¹nx2ti³tũ¹xã². Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nxe³nxa²ha¹te¹, Je³su²jah³la² ã³nxai³xi²te³lhxã³ nxa²ha¹te¹ in³txa² sa²kxai³lu² ã³ni³ha²non¹sxã³ ĩ³ha¹txi²sxã³ ãn³kax3ti³wxe³sxã³ ĩ³wã̱³txi³te³nah¹lxi¹: — Tih³nxe³sa²jah¹lãi³. Wi¹lhin¹jah¹lo²si¹lxi¹. Nxet3sã²lxi¹. Yã¹te²a̱³ wi¹ju³ta³la³ kãi³a¹ke³la³te²kxai³ ka³te̱³na² wi¹tãu³la² so¹kxi¹nxa²hĩ̱³na¹te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nxe³nxa²ha¹te¹ Je³su²jah³la² wãn³txi³kxai³lu¹ ĩ³ye³kxi²te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ wi¹lhin¹jah¹lo²su² san¹ji¹wi¹? Txa²wã¹sũ̱³na² so¹lxi³ wi¹lhin¹te²ju²hẽ³li¹. Ã̱³xa² hai³txi³ wi¹lhin¹te²sxa³yu²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Txa²wã¹sũ̱³na² wãn³txu¹tai²na² ain³kxi²to³hxain¹tai¹ti²tu³wi¹: “Su²lhã³i², ã̱³xa² sxe³xa³ka³lxa² so¹sxã³ ũ³whĩn¹ta³kxi², ã̱³xa² yen³kxa² kãi³kxi² a²nũ²a² ã̱³xa² ki³ha¹kxi²sxã³ ko̱³nxe³ti³ kãi³ti³hi¹jau³su² ĩ³ye³kxi²nyhu¹i² ki³han³jau³xa² ã³ye³yxo²nũ¹ni² nxe³yah³lxi³txa³hẽ¹li¹. Wxa²wĩ³na² wxa²hã³ka³na² wi¹kãi³ũh¹xai³jah³lxi³hẽ¹li¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nxe³nxa²ha¹te¹ in³txai²na² sa²kxai³lu¹ ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: — Tih³nxe³sa²jah¹lãi³. Sa³nxe³la³kxa² wet1sa²hĩ¹nãn¹te²tu̱³ nxe³jau³xai²na² sa²yxo²wet1sa²sai¹hxai²na¹hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yxãn¹ta¹ Je³su²jah³lo²su² te²kxai³lu² ĩ²ain¹sxã³ a³lxi²sxã³, ĩ³ye³kxi¹te³nah¹lxi¹: — Yu³ka³na³ka³na³ton³na³li¹. Wxa²yen³kxa² sa²so¹sxã³ a²nũ²a² ã̱³xa² so¹kxi²nxa²si¹jau³su² kãi³txa²hẽ³li¹. Nxĩn¹kxai²nãn²tu̱³ so¹kxi²nxain¹kxa² yo³ha² tẽ³sxã³ a²nũ²a² yen³kxi³txa²te²na² wã²nhũh²xai³txai¹nhẽ³li¹. Nxĩn¹kxai²nãn²tu̱³ oh³nãu³nũ¹ka³na¹ yen³kxa² wi¹ju³ta³nũ³a² yũ³nxa²tu¹wi¹. Jã¹nxe³sxã³ nxe² kãi³ta³lu²nĩn¹kxai²nãn²tu̱³ ã³wxã³sxã³ ã³si³tẽ³kxi¹sẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nxe³jau³xai²na² sa²kxai³lu², in³txai²na² sa²kxai³lu² ain³kxi²te³na¹ ĩ³ye³han³ti³nha²sxã³ ĩ³ãin²txi³sxã³ ĩ³ain¹ta¹hxai²hẽ¹la², kãin² yen³kxi³nha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nxe³nxa²ha¹te¹ Je³su²jah³la²kxai³lu¹ a²sa³wi³ha³lxi³nãu³xa² sa²kxai³lu¹ ĩ²sa²sai¹ain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² kãin² yen³kxi³te²su² te²a², Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ju³ta² wa³lxe³te²ju²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","Nxe³jau³xai²na² sa²kxai³lu², a²sa³wi³ha³lxi³nãu³khai³xa² ĩ³wã̱³wã̱³tain¹ta¹hxai²hẽ¹la². Nxe³to³ta¹ Je³su²jah³lo²kxai³lu¹ ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wẽ³ha³lxãi³. Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ju³ta² wa³lxe³te²ju²hẽ³li¹. Jã¹nxa¹jau³su² ka³me²la² ka³yxuh³xa² kãin²khaix1te²su² te²na² hai³txi³ a²ku¹wxi²si³xẽ¹na² ã³wih¹sxã³ ã³wa²to¹ti³he¹nxe³lhĩ̱³nx2nxa³wi¹. Yxãn¹ta¹ a²nũ²a² kãin² yen³kxih³khai¹nxe³te²su² te²a² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ju³ta² wa³to²hi²te²ju²hẽ³li¹ wa³lxe³ju³ta²su¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nxe³sxã³ a²sa³wi³ha³lxi³nãu³xã² kãin² ĩ³wã̱³wã̱³txi³ yxau³ain¹sxã³ ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Txa²wã¹ha³lo²a²nãu³a² a²nũ²ai²li² yen³kxi³kxai²nãn²tu̱³ Txa²wã¹sũ̱³nu²su² wi¹lhin¹sxã³ ĩ²jah¹lo²su² ye²te²ju²hẽ³li¹. Nxe³jut3su² ha²kxai³ a²nũ²a² yen³kxih³te²su² te²na² kxã̱u³nxa³sxã³ Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³kxai²nãn²tu̱³ a²nũ²a²nãu³xa² hãi¹nxe³ti³xa¹ Sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ki̱³sxa³lho³li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yxãn¹ta¹ Je³su²jah³la² ĩ²sa²sai¹ain¹sxã³ ĩ³ye³kxain¹te²an¹jau³kxai³lu¹: — Nxe³ju³tai²na² a²nũ²a² hxi²kan¹ti³he¹xai¹nxa³wi¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² hi²sen³su² hxi²kat1te²lo³jah¹lai²la¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nxe³nxa²ha¹te¹ Pe²jah³lo²kxai³lu¹ ĩ³ye³ãn³si³wxe³te³nah¹lxi¹: — Nxet3sã²lxi¹. Txa²yen³kxa² hãi¹nxe³ti³xa¹ ã³na¹sxã³ ãn³si³tẽ³kxi¹nxa²sĩ¹na¹tai¹ti²tu³wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yxãn¹ta¹ Je³su²jah³la² wãn³txi³kxai³lu¹: — A²nũ²a² a²ten³te²su² te²an²tu̱³ Txai²na² a³lxi²sai¹nha²kxai³ txa²wãn³txa² wi¹jau³xa² a³lxai¹nha²kxai³, sxi²ha² ã³na¹i² a²lon³ti³tãu³xa² ã³na¹i² a²ha³lĩ³ti³nãu³xa² ã³na¹i² a²hã³ka³na² ã³na¹i² a²wĩ³na² ã³na¹i² a²wẽ³ha³lxi³nãu³xa² ã³na¹i² a²ha³lo²a²ko³xa² ã³na¹i² nxe³ain¹kxai²nãn²tu̱³, a²ha² kwẽn¹tai²na² ye³ka³lxa¹txi³ sxi²ha² yũ² ka³lxa¹txi³ a²lon³nãu³xa² yũ², ka³lxa¹txi³ a²ha³lĩ³ti³nãu³xã² yũ² ka³lxa¹txi³ a²hã³ka³na² yũ² ka³lxa¹txi³ a²wĩ³na² yũ² ka³lxa¹txi³ a²wẽ³ha³lxa² yũ² ka³lxa¹txi³ a²ha³lo²a²ko³xa² yũ² nxe³ain¹tu¹wi¹. Nxe³yãn¹ta¹, hau³hau³kon³sxã³ a²nũ²a² ã̱³xa² ko̱³nxe³ju³ta² ye³khãuh³lxa³thin¹sxã³ kãi³ain¹tu¹wi¹. Nxe³kxa²yu³su² yxan¹nãu³a¹ ka³te̱³na² wi¹tãu³a¹ yxau²xai³lain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nxe³kxan²ti³nũ¹ sa²nẽn¹kxi²nha²yah³lxi³txa³hẽ¹li¹. Nxe³sxã³ a²nũ²a² ka³lxa²te²nũ̱³ka̱³txa² a²hĩn¹txi³ ĩ³sa²nẽn¹kxain¹ju³ta² yũ³kxan²ti³ yan¹nãu³a¹ ĩ³sa²nẽn¹kxai¹nxa³ju³ta² yũ³tu¹wi¹. Te²yã¹nxe³sxã³ a²nũ²a² ka³lxa²te²nũ̱³ka̱³txa² a²hĩn¹txi³ ĩ³sa²nẽn¹kxai¹nxa³ju³ta² yũ³kxan²ti³ yan¹nãu³a¹ ĩ³sa²nẽ¹kxain¹ju³ta² yũ³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nxe³nxa²ha¹te¹ Je³ru³sa³lẽ²thĩ³na² wa²li³nhẽ¹tĩh³na² ã³nxai³ain¹nxa²ha¹te¹ Je³su²jah³la² ãn³ne³ka³ta¹nyhain¹sxã³ ai³yain¹ta¹hxai²hẽ¹la². Ai³yain¹te³na¹ a²sa³wi³ha³lxi³nãu³xa² ãn³si³tẽ³tũ̱³ka̱³txa² sa²kxai³lu² ĩ³wã̱³txain¹to³ha²kxai³ yu³lhain¹to³ha²kxai³ ain¹ta¹hxai²hẽ¹la². Nxe³ju³tai²na² sa²kxai³lu² Je³su²jah³la² a²hi²sen³kxai³lu² a²sa³wi³ha³lxi³nãu³khai³xa² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³tũ̱³ka̱³txa² ĩ³yũ³so¹ka³tu̱³ ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ĩ³ye³kxain¹te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Je³ru³sa³lẽ²thĩ³na² ã³nxai³ki̱³tu¹wi¹. Nxe³ki̱³kxai²nãn²tu̱³ Txai²na² so¹sain¹sxã³ a²nũ²a² wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txi³nãu³xa² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txi³nãu³xa² nxe³te²nãu³xai²na² a²hxi²ka³nãu³a² ã³na¹sain¹tu¹wi¹. Nxe³sain¹kxai²nãn²tu̱³ ya³lu²si¹sain¹jau³su² ĩ³yĩ¹li²sain¹tu¹wi¹. Nxe³ka³tu̱³ Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³xa² sa²nũ¹sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sa²nũ¹sain¹sxã³ ko̱³nxe³ ĩ³ka³lxi¹lũ¹sain¹ka³tu̱³ ĩ³ye³ka³su³hẽn¹kxi²sain¹ka³tu̱³ ũn³txi³ ĩ³ta³lo³wait1sain¹ka³tu̱³ ĩ³su²lhã³sain¹tu¹wi¹. Nxe³yãn¹ta¹ ye³ha¹li¹ ka³na³ki¹ a³lan²tãu³kxai³lu², ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹, Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²su² na¹ha²kxai³lu¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nxe³nxa²ha¹te¹ Se³be³te²ah³la² a²tah²nãu³su² Ti³a²kah³la² Jo³ãu²ah³la² nxe³ya³ta¹hxai²hẽ¹la². A²nxe³te² tah²nãu³xai²na² sa²kxai³lu² Je³su²jah³la² wxã³sxã³ ĩ³ye³kxi²ya³te³nah¹lxi¹: — Ĩ³tih³nxe³sa²jah¹lãi³. A²yen³kxa² ĩ³wã̱³txi³nxa²ya³ha¹kxai²nãn²tu̱³ ũ³hũ¹sa²sĩn¹te³lin¹ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Yã¹te²a² wxa²hau³ko³kxi¹nx2ta¹ju³ta³nũ³su² ten³nx2ti³ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nxa²ha¹te¹ ĩ³wã²lũ³xi²ya³te²an¹jau³kxai³lu¹: — Wxãi²na² wxa²ha³lo²a² a²wa³kxẽn³sin¹kxai²nãn²tu̱³ ka³na³ki³ wxa²wi¹tãu³a¹ ã³wxe², ka³na³ki² wxa²wa̱³tãu³a¹ ã³wxe² nxe³ya³ha¹ju³ta² ten³ya³sa³nhai¹. Nxe³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yxãn¹ta¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — A²yen³kxa² ten³ya³hin¹ju³ta² ã³ne³wxe³ya³hxa³lxi¹. A²nũ²a² ko̱³nxe³thin¹te²nãu³xa² khãuh³lxa³ti³sain¹tu¹wi¹. Jã¹nxe³nx2tain¹ju³ta³nũ³a² hxi²kan¹ti³ en³ya²te³lin¹ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nxe³nxa²ha¹te¹ ha¹lin¹tũ̱³ka̱³txa² wãn³txi³kxai³lu¹: — Hxi²kan¹ya³ha¹wi¹. Nxe³ya³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² wãn³txi³kxai³lu¹: — Txai²li² khãuh³lxa³ti³sain¹tu¹wi¹. Na¹ha²kxai³ wxãi²na² jã¹nxe³sxã³ khãuh³lxa³ti³nx2tain¹nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nxe³yãn¹ta¹ txa²wi¹nẽ³tãu³a¹ ã³wxe² txa²wã̱³tãu³a¹ ã³wxe² nxe³ya³hin¹ju³ta² hxi²kan¹ti³ ũ³hũ¹nx2ti³nxa³lho³li¹. Ju¹tai²na² Txa²wã¹sũ̱³na² a²ha³lo²ai²la¹wi¹. Txa²ha³lo²sxa³wi¹. Txa²wã¹sũ̱³na² a²ten³te²su² te²na² so¹lxi³ sa²we¹tain¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nxe³jau³xai²na² sa²kxai³lu² a²sa³wi³ha³lxa² wã³kon³te²nãu³xa² hxi²ka² hxan³tũ̱³ka̱³txa² ain³kxain¹sxã³ kãin² ĩ³xa̱n³txin³tain¹ta¹hxai²hẽ¹la². Jo³ãu²ah³lai²na² ĩ³xa̱n³ta³kxi² Ti³a²kah³lai²na² ĩ³xa̱n³ta³kxi² ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yxãn¹ta¹ Je³su²jah³lo²su² te²kxai³lu¹ a²sa³wi³ha³lxa² hãi¹nxe³ti³xa¹ ĩ³kaix1tain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² Ju³te²a² nũ̱³ka̱³txi³sxa³tũ̱³ka̱³txa² nxe²xai³te²jai¹ti²tu³wi¹. A²hxi²kan¹te² hi²sen³su² a²sa³wi³ha³lxa² yxo²ha³nxe¹lhxa³txi³ hxi²kan¹txi³lo³tain¹te²jai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yxãn¹ta¹, wxãi²na² jã¹nxe³yah³lxi³txa³hẽ¹li¹. Wxa²yu³ta², ĩ²li³te² ĩ̱³nxãn²tu̱³. “Hxi²kan¹te²sa¹i¹.” Nxe³jau³tu̱³ ten³nxa²kxai²nãn²tu̱³, wxa²yu³ta² a²hãi¹nxe³ti³xa¹ ĩ³wa³ka³lxi³lo³txai¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","45","Jã¹nxa¹jau³su², “Txai²na² a²si³yxau³jah¹lo²sa¹wi¹.” Nxa¹jau³su² ten³nxa²kxai²nãn²tu̱³ a²nũ²a² yxo²ha³kxa¹ ã³wa³ka³lxi³lo³txai¹nhẽ³li¹. Jã¹nxa¹jau³su² Txai²na² sa²kxai³lu² wa³ka³li³lo³sa²si¹hai¹na¹jau³nũ³su² wxã²nxa³wi¹. Yxãn¹ta¹ a²nũ²a² yxo²ha³kxa¹ ã³non²ta³kxi²te³lhxã³ wxã³na¹wi¹. A²nũ²a²nãu³xai²na² a²ko̱³nxe³ti³ kãi³sxã³ wã²nxũh¹lain¹ju³tai²na² ã³wa²su¹te³lhxã³ ya³lu²kxai¹na¹tu¹wi¹. Nxain¹te³lhxã³ wxã³na¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nxe³nxa²ha¹te¹ Je³su²jah³la² nxe³ha²kxai³ a²sa³wi³ha³lxi³nãu³xa² nxe³ha²kxai³, ã̱³lxi³tũ̱³ka̱³txa² ka³lxa¹tũ̱³ka̱³txa² nxe³ha²kxai³ whãi²na¹, tẽ³li³nyhu¹sxã³ Je³ri³ko²thĩ³na² ai³ain¹ta¹hxai²hẽ¹la². A²nxe³thĩ³na² wa²li³ain¹tãu³a¹ a²nũ²a² ye³han³jah¹la² Bar³ti³me²ah³la² tĩh³na² kxa³lxu³sa³kxu²nxa² ã³wxe³ta¹hxai²hẽ¹la². A²nxe³jah¹la² Ti³me²ah³la² a²ki³lhan³ta³ ta¹hxai²hẽ¹la². Nxe³ju³ta² a²yen³kxa² ĩ³yai³nxũ³yhain¹te³lhxã³ o²la³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nxe³te³na¹ Je³su²jah³la² Na³sa³re²thĩ³na² to̱n¹jah¹la², ya̱u³son³ju³ta² ain³kxain¹te³na¹ ĩ³kaix1jain¹ta¹hxai²hẽ¹la². Kãin² ĩ³kaix1jain¹te²an¹jau³kxai³lu¹: — Je³su²jah³lãi³. Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3txa²kah³lo²si¹lxi¹. Ye³han³sa²ju³tai²na² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nxe³ju³ta³la³ a²nũ²a² ka³lxa¹tũ̱³ka̱³txai²na² a²wãn³txi³kxai³lu¹ yxo²xũ̱n³txi³ ĩ³kwa̱i²kxain¹te³nah¹lxi¹: — Ã³ka³nah²nxe³sĩ¹nhẽ³li¹. Ain¹ta¹hxai²hẽ¹la². Nain¹kxa²ha³ta̱³nxãn²ti³ ã²la² kãin² ĩ³kaix1jain¹jau³xa²sa¹: — Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3txa²kah³lo²si¹lxi¹. Wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nxe³tãu³a¹ Je³su²jah³la² a²hi²sen³kxai³lu² ã³yit1sxã³ ĩ³kaix1so¹ain¹ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ a²nũ²a² ka³lxa¹tũ̱³ka̱³txai²na² ĩ³kaix1tain¹te²an¹jau³kxai³lu¹: — Ya³lo³txi²sĩ¹nhẽ³li¹. Je³su²jah³la² ĩ³kaix1txa²sĩn¹nhai¹. Ĩ³sa²yxau³sxã³ ait3sĩ¹nu¹li¹. Yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nxe³te³na¹ a²nũ²a² ye³han³jah¹lai²na² wã²la²ka³lo³a² ha³la³sãn¹ka³lo³a² sa²sai²ã³sxã³ ĩ³sa²yxau³sxã³ Je³su²jah³la² ã³tĩ̱³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nxe³te³na¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — Ĩh¹nxe³ju³ta² kãi³ũh¹nxa²ha¹ju³ta² ten³nxa²ji¹wi¹? Nxe³ha²kxai³lu¹ ye³han³jah¹lai²na² a²wãn³txi³kxai³lu¹: — Txa²hxi²kan¹jah¹lãi³. Ye³we²txi²san¹ju³ta² ten³khaix1sa³nhai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — Ã³nxai³txu¹li¹. Hĩ¹na¹ yxo²ĩ²sa¹nha²kxai³ ye³we²txi¹nxa²ha¹wi¹. Ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ wa³su³txi³ ye³we²nxi²sxã³, Je³su²jah³la² ãn³si³tẽ³kxa² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²sa³wi³ha³lxi³nãu³xa² Je³ru³sa³lẽ²thĩ³nãn¹tĩh³na² ã³nxai³ain¹ta¹hxai²hẽ¹la². Ã³nxai³ain¹te³na¹ wã³la² o³li³ve²ra³ka³txa² ya̱u³son³kxain¹ta¹hxai²hẽ¹la². A²nxe³ti³wa³kxa² sxi²jen³txa² thĩ³nha¹li¹ wã³la³ka³txa² yxo²yxau³ta¹hxai²hẽ¹la². Nxe³thĩn³txa² Bet3fa³je²thĩn³su² ha²kxai³ Be³tãn²ya³thĩn³su² ha²kxai³ nxe³ta¹hxai²hẽ¹la². A²nxe³thĩ³na² ã³yi¹ka³tu̱³ Je³su²jah³lo²kxai³lu² a²sa³wi³ha³lxa² ha¹li¹ ĩ³sa²si¹hã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nxe³ju³kxai³lu¹ Je³su²jah³la² wãn³txi³kxai³lu¹ ĩ³sa²si¹hã³yhain¹te²an¹jau³kxai³lu¹: — Sxi²je³na² ha³ti³hi³nãu³a¹ ai³jah³hẽ¹li¹. Ya³hin¹kxai²nãn²tu̱³ a²kwẽn¹tai²na¹ ju³mẽn²ta² ka²va¹lhũ̱³te²a² wẽ³sa² nxe³te²a² sa³tai³kxa² wxe³sain¹te²a² ĩ²yah³hin¹tu¹wi¹. A²nxe³te²a² a²ka³tih³ya̱u³ai¹nhxai²nxa³hẽ³li¹. Nxe³te²a² sa²ta²la³kxi²so¹jah³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ya³hin¹kxai²nãn²tu̱³ a²nũ²a² ĩ²li³te²an²tu̱³ ĩ³wã̱³txi³nx2tain¹kxai²nãn²tu̱³: “Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ sa²ta²la³kxi²ya³hin¹ji¹wi¹?” Nxe³nx2tain¹kxai²nãn²tu̱³ ĩ³ye³kxi¹txain¹ya³hẽ¹li¹. “Txa²hxi²kan¹jah¹la² a²ten³jau³su² ha²kxai³ sa²si¹hã³sain¹sĩn¹na²li¹.” Nxe³txain¹ya³hẽ¹li¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nxe³nxa²ha¹te¹ ã³nxai³ya³te³na¹ ya²la³la¹ ju³mẽn²ta² wẽ³sa² sa²tai³kxi²kxa² sxih²yxo²a² a²ti²ta³lo³kxa² yxo²wxe³ain¹kxe³su² te²a² ĩ²ya³ta¹hxai²hẽ¹la². A²nxe³te²a² sa²ta²la³kxi²ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nxe³ju³ta² sa²kxai³lu² a²nũ²a² ha³lo²a² he¹ain¹te²a² ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ju³mẽn²ta² wẽ³sai²na² sa²ta²la³kxi²ya³hin¹ji¹wi¹? Nxain¹ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ya³ti³an¹jau³kxai³lu¹: — Txa²hxi²kan¹jah¹la² a²ten³jau³su² ha²kxai³ sa²si¹hã³sain¹na²li¹. Nxe³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nyhai¹nha²kxai³, ju³mẽn²ta² wẽ³sai²na² tẽ³sxã³ Je³su²jah³la² ũ³hũ¹yhain¹ka³tu̱³ wã²la²ka³lo³a² so¹sxã³ ũ³ka³ti³hẽt1ta¹hxai²hẽ¹la². Hã²wxãn³txa³ Je³su²jah³lai²na² sa²kxai³lu² ã³ka³ti³ya̱u³ye²ha²kxai³ ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nxa²ha¹te¹ ne³ka³ta²a² ai³ain¹tũ̱³ka̱³txa² ka³lxa¹tũ̱³ka̱³txa² a²wã²la³ka³lo³khai³xa² tĩh³na² Je³su²jah³la² ã³nxai³tĩh³na² ũ³ha¹xai³ain¹ha²kxai³ a²nũ²a² ã̱³xa² ka³lxa¹tũ̱³ka̱³txa² he³la³nxã³nxa² sa²nãu²so¹sxã³, tĩh³na² ũ³ha¹ai³ain¹nũ³nha²kxai³ nxe³ain¹ta¹hxai²hẽ¹la². Nxe³ain¹ju³ta² tĩh³na² Je³su²jah³la² wi¹wxa²hau³ko³kxai¹si¹hain¹jau³su² ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nxe³ha²kxai³lu¹ ã³ne³ka²ta¹sxã³ ho³hain¹tũ̱³ka̱³txain²ti³ ĩ³kaix1ti² a²si³yo³na² ho³hain¹tũ̱³ka̱³txain²ti³ ĩ³kaix1ti² nxe³ain¹ta¹hxai²hẽ¹la². Ĩ³kaix1tain¹te²an¹jau³kxai³lu¹: — Je³su²jah³la² ĩ³sa²nẽn¹kxi²a³sah¹lxi³wxi¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹lai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kxã³nhxĩ¹nu¹tai²na² Ta³vi²yah³lu¹tai²na² sa²kxai³lu² ĩ³wa³kxẽn³to³tẽ³lain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Te²u¹jã¹nxe³te²su² te²a² hĩ¹na² ã̱h¹ ũ³hũ¹nẽ³tu¹wi¹. Nxe³ha²kxai³, Wxi²kin³txi³ton³ta² Si³yxau³jah¹lai²la¹wi¹. Nxe² e³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nxe³nxa²ha¹te¹ Je³ru³sa³lẽ²thĩ³na² Je³su²jah³la²kxai³ ã³wi¹hain¹ka³tu̱³ Txa²wã¹sũ̱³na² sxi²ha² ã³wi¹hain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ a²yen³kxa² yxo²ha³kxa¹ ĩ²ain¹ta¹hxai²hẽ¹la². Nũ²la² ki³kan³nũ²la² a³li³ain¹ta¹hxai²hẽ¹la². A²sa³wi³ha³lxi³nãu³xa² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³te²nãu³xa², ã³si³tẽ³kxain¹ka³tu̱³, Be³tãn²ya³thĩ³na² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ain¹te³na¹ ka³nxa³ha²ta³kxai³lu² Be³tãn²ya³thĩ³nai²na² a³li³sxã³ ã³nxai³ain¹ka³tu̱³ Je³su²jah³la² heh³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nxe³ka³tu̱³, yain³txi³ka³ta² fi²ko²ne³kxa² ã²hã¹ u²la¹ ten³sa²tã³ta¹hxai²hẽ¹la². A²nxe³ka³ta² ãn³ya̱u³son³kxi²ta¹hxai²hẽ¹la². Yain³txa³nã̱³kxa² so¹sxã³ ĩ³yain³te³lhxã³ ya̱u³son³kxi²ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²ka³tai²na² a²nxã̱³kxa² yũ²nxa³kxe³su² a²nxã³nxa² so¹lxi³ ĩ²ain¹ta¹hxai²hẽ¹la². Ha³lo²la³ yain³txa³nã̱³kxa² ka³to³je³na³kxa² ãn³si³wxe²nxa³ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nxe³te³na¹ Je³su²jah³la² wãn³txi³kxai³lu¹ a²yain³txa²ka³tai²na² ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³hĩ¹nãn¹te²tu̱³ wen¹nxã²nxa³lho³li¹. Nĩn¹ka³tu̱³ wxa²nxã̱³kxa³la³ a²nũ²la³ ĩ³yain³kxi¹ti³he¹nxẽ²nxai¹nx3tho³li¹. Nxe³ta¹hxai²hẽ¹la². Nxe³jau³xai²na² a²sa³wi³ha³lxi³nãu³xa² ain³kxi²khaix1ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nxe³nxa²ha¹te¹ Je³ru³sa³lẽ²thĩ³na² wxã³ain¹nxa²ha¹te¹ Txa²wã¹sũ̱³na² sxi²ha² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wi¹hain¹ka³tu̱³, a²nũ²a² ka³lxa²tũ̱³ka̱³txa² yen³kxa² so¹kxi²nyhu¹sxã³ o²la³kxi² ũ³yho³hi²ki̱³ki³a² so¹kxi²nyhu¹sxã³ o²la³kxi² kwa³sxa³xa² ũ³yho³hi²sxã³ ũ³hũ¹te²a² o²la³kxi² nxe³nyhu¹ye²ta¹hxai²hẽ¹la². Jã¹nxe³ju³kxai³lu² Je³su²jah³la² hi²sen³su² yen³kxa² ũ³yho³hi²nyhu¹ain¹te²na² ha³lo²a² sa²tã³kxai¹nha²kxai³ ũ³yho³hi²ki̱³ki³a² a²me²sa²ka³lo³a² ũ³sa²tã³ha²kxai³ kwa³sxa³xa² ũ³yho³hi²sxã³ ũ³hũ¹te²na² ã³wxe³ka³lo³ai²na² ũ³sa²tã³ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ain¹sxã³ a²nũ²a² a²yen³kxa² tẽ³sxã³ Txa²wã¹sũ̱³na² sxi²hẽ¹na² ã³wa²to²ka² ai³si¹ja³kxa³nũ³su² ĩ³hxi²ko²lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nxe³nxa²ha¹te¹ Je³su²jah³la² wãn³txi³kxai³lu¹ ĩ³yau¹ũ³te³lhxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wha²li¹txã³nxa² jau³xau³hxai²tẽx1ta² nxe³te³nah¹lxi¹: “Txa²sxi²hai²na² sa²kxai³lu² a²nũ²a² nũ̱³ka̱³txi³nãu³xai²na² a²yxo²ha³kxa¹ ĩ³ye³kxi²sain¹thĩ³nai²la¹wi¹.” Ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ ĩ³ya̱¹nxa²sxã³ yen³kxa² kãi³kxi²nyhu¹kxi³thĩn³su² ĩ³ya̱¹ton³yah³lxi¹nhẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nxe³jau³xai²na² sa²kxai³lu², wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txa² ain³kxai¹nha²kxai³, ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² ain³kxai¹nha²kxai³ ain¹sxã³ Je³su²jah³la² ĩ³su²lhã³te³lhxã³ o²la³kxain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² a²nũ²a² yxo²ha³kxa¹ Je³su²jah³la² wãn³txa² ĩ³wã̱³wã̱³txi³sxã³ he¹lain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ ha¹lin¹tũ̱³ka̱³txai²na² yu̱³lhain¹jau³su² Je³su²jah³la² ĩ³su²lhã³si¹jau³nũ³su² te³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nxe³nxa²ha¹te¹ sũ²ni²khaix1nxe³sxã³ Je³su²jah³la² nũ̱³ka̱³txa² Je³ru³sa³lẽ²thĩ³na² wa²li³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ka³nxa³ha²ta³kxai³lu¹ ã³nxai³ain¹ka³tu̱³ yain³txa³ka³tai²na² sa²kxai³lu² ã³wa²tot1sxĩ²ain¹ta¹hxai²hẽ¹la². A²nxe³ka³ta² ĩ³ya³nat3sxã³ ya³lu²ju³tu¹tai²na² ĩ²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nxe³hĩ¹na² Pe²jah³la² hi²sen³kxai³lu² ain³kxi¹xi²nũ²la² Je³su²jah³la² wãn³txa² a²sũ²ta³ti³kxai³ ĩ³ye³jau³kxai³ ain³kxi¹xi²ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Yain³txa³ka³tai²na² ko̱³nxe³te²lo³tin¹ka³tai²na² ĩ³ya³na²kxi²sxã³ ya³lun²su²li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Yxãn¹ta¹ Je³su²jah³la² wãn³txi³kxai³lu¹ ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: — Txa²wã¹sũ̱³na² yxo²ĩ²jah³lxi³hẽ¹li¹. A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. A²nũ²a² a²ten³te²su² te²an²tu̱³ wã³la³ka³txai²na² ĩ³ye³kxi²yah³lxin¹kxai²nãn²tu̱³, “Wxa²ha²txut1sai¹sxã³ ĩ̱³ye³na² kãin²je³na² ã³na¹txa²hẽ³li¹.” Yah³lxin¹kxai²nãn²tu̱³ hau³hau³kon³sxã³ wxa²ẽ¹nãu³a¹ hai³txi³ ĩ³wã̱³wã̱³ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ sa²wai³wait3sxã³ Txa²wã¹sũ̱³na² yxo²ĩ²yah³lxin¹kxai²nãn²tu̱³ a²yen³kxa² ten³yah³lxin¹kxa² yũ³khaix1yah³lxin¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","— Jã¹nxa¹jau³su² Txa²wã¹sũ̱³na² ĩ³ye³kxi²yah³lxin¹kxai²nãn²tu̱³ ĩ³wã̱³wã̱³ta³kxi²nhyah¹lxin¹kxai²nãn²tu̱³ ĩ³wã̱³wã̱³ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. Hãi¹nxe³sxã³: “A²yen³kxa² te³na¹kxe³su² te²a² yũ³khaix1sa³tu¹wi¹.” Nxe³jah³lxi³hẽ¹li¹. Kan²txi³ yxo²ĩ²sah¹lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ yũ³khaix1yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jã¹nxa¹jau³su² e³a¹wi¹. Ĩ³sa²yxau³sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²yah³lxin¹kxai²nãn²tu̱³ a²nũ²a² ĩ²li³te²hũ̱³te²su² te²a² ko̱³nxe³ti³ kãi³ũh¹nx2ti³kxai²nãn²tu̱³, nxe³ju³tai²na² wi¹lhin¹sxã³ ne³wã²na³txain¹yah³lxi³hẽ¹li¹. Nain¹yah³lxin¹kxai²nãn²tu̱³, Wxa²wĩ³na² oh³na² yxau³jah¹la² ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ne³wã²na³nx2ti³nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yxãn¹ta¹ wxa²ẽ¹nãn¹jau³su² nxe³ke³la³te²kxai³ te³nah¹lxi¹: “Jah¹lai²li² ko̱³nxe³ti³ kãi³ũ¹sain¹na²hẽ³na¹. Ne³wã²na³ũ¹hain¹nxa³lho³na¹.” Yah³lxin¹ke³la³te²kxai³ Wxa²wĩ³na² oh³na² yxau³jah¹la² ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ne³wã²na³ũh¹nx2ti³hĩ̱²nxa³wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nxe³nxa²ha¹te¹ Je³ru³sa³lẽ²thĩ³na² Je³su²jah³la² nũ̱³ka̱³txa² ã³wxa̱³lain¹ka³tu̱³ Txa²wã¹sũ̱³na² sxi²nhãu³ã¹ ã³nxai³ain¹ta¹hxai²hẽ¹la². Ã³nxai³ain¹ka³tu̱³, wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txa², ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa², a²nũ²a²nãu³xa² a²hxi²kan¹te² nũ̱³ka̱³txa² whãi²na¹ ã³tĩ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ã³tĩ³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ĩh¹nxe² ĩ³hxi²ka¹txa²hĩ̱³te²la¹xã³? Ĩh¹jah¹lo²ta̱³ ĩ³sa²si¹hã³nxain¹thai¹li¹? Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Wãn³txa² yau³ka³na³ka³na³jau³xa² yau³ã̱³lxi³jau³xa² ĩ³wã̱³txi¹nx2ta¹tu¹wi¹. Nxe³nx2ta¹jau³xai²na² ĩ³wa²lũ³xi²sah¹lxi³sã²nhẽ³li¹. Sah²lxin¹kxai²nãn²tu̱³, ĩ³hxi²kat1sa²jah¹la² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Yxãn¹ta¹ sa²lxan³kxai²nãn²tu̱³ nxe³nx2ti³nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jo³ãu² Ba³tis²jah³lai¹tã² sa²kxai³lu² a²nũ²a² tẽ³sxã³ ĩ̱³ye³na² ũ³hũ¹kxi²sa²sai¹ain¹kxe³su² ĩh¹jah¹lo²ta̱³ ĩ³sa²si¹hã³ain¹thai¹li¹? Txa²wã¹sũ̱³nu²khai³xai²la³ ta̱³nxa² a²nũ²khai³xai²la³ ta̱³nxa² ĩh¹nxe³hĩ̱³te²la¹xã³? Nxe³na¹jau³xai²na² ĩ³wa²lũ³xi²sah¹lxi³sã²nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nxe³nxa²ha¹te¹, wã²nxũ̱h¹ e³kxi²nyhain¹te³nah¹lxi¹: — “Txa²wã¹sũ̱³na² ĩ³sa²si¹hã³kxah³lai²la¹wi¹.” Nxe²e³kxi²ki̱³kxai²nãn²tu̱³ ĩ³wa²lũ³xi²nẽ³lai¹nhĩ̱³te³nah¹lxi¹: “Nxe³kxi³sa²ha²kxai³ ĩh¹nxe³kxa²ya̱n³ti³ta̱³ Jo³ãu² Ba³tis²jah³lai²na² wãn³txa² yxo²ĩ²yah²lxan³thai¹li¹?” Nxe³nẽ³lain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yxãn¹ta¹: “A²nũ²khai³xa² ĩ³sa²si¹hã³kxah³lai²la¹wi¹.” Nxe³ki̱³kxai²nãn²tu̱³ yu̱h³lxi³nẽ³na³li¹. A²nũ²nãu³xai²na²: “Jo³ãu² Ba³tis²jah³la² Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²khai³su¹.” Nxain¹jau³su² ha²kxai³ ya³lu²kxi²nẽ³lain¹kxa²ya̱n³txi³su² ki̱³nhai¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nxe³ha²kxai³ ĩ³wa²lũ³xi²te²an¹jau³kxai³lu¹: — Ko̱³nha²sĩn¹nxa³nhai¹. Nxe³ain¹ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ Je³su²jah³la² wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Hã³xã¹. Ko̱³nyhah¹lxan³kxai²nãn²tu̱³, ĩ³sa²si¹hã³sa³jah¹la² ĩ³yau¹ũ³nx2ti³nxa³lho³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nxe³nxa²ha¹te¹ Je³su²jah³la² wãn³txa² yau³xã̱³xa² ĩ³yau¹ũ³ta¹hxai²hẽ¹la². Ĩ³yau¹ũ³te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Hai³sxa² a²wa³kxẽn³yah³lo²su² nũ²nhai¹. A²hai³sxai²na² u²va²nẽ³kxa² ũ³whĩ̱¹nũ²nhai¹. Ũ³whĩ̱¹i² a²yxo²ka³te̱h³nãu³xa² txah³lxa³kxa² tẽ³sxã³ ũh³yxo²wxaih²na³kxa²xai³sxã³ txon³nũ²nhai¹. Sxi²ha² kĩ³khai¹nxe³thĩ³na² ũ³txo³te²ka³kxa¹ a²nũ²a² ã̱³xa² wi¹wa³kon³kxi²si¹hain¹jau³su² ũ³hũ¹ain¹nũ²nhai¹. Hã²wxãn³txa³ ha³lo²a² u²lxan¹ko³xa² ã³nxai³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hã²wxãn³txa³ ã³ki³i²tãu³a² sa²kxai³lu² yain³txa³kxa² wã²nhu¹nyhu¹si¹jau³su² a²sa³wi³sa² sa²si¹hã³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yxãn¹ta¹ hai³sxa² kwa²hau³ko³tũ̱³ka̱³txa²kxai³lu² kãi³ye²ha²kxai³ wã²nhũ¹nyhai¹nxa³ke³tu̱³ hãi¹sxã³ su²la³kxa² sa²wa²ye²nyhain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nxe³nxa²ha¹te¹ a²sa³wi³sa² ã̱³xa² yain³ta³ka² wã²nhu¹nyhu¹si¹jau³su² ĩ³sa²si¹hã³nũn³nũ²nhai¹. Yxãn¹ta¹ kwa²hau³ko³tũ̱³ka̱³txa²kxai³lu² ĩ³ne³ku³lai¹nha²kxai³ ko̱³nxe³ti³ ãu²li²ton³nha²kxai³ nxe³nyhain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nxe³nxa²ha¹te¹ a²sa³wi³sa² ã̱³xa² ãn³ta³lo³hẽ²ti²to³kxa² ĩ³sa²si¹hã³kxah³la² kwa²hau³ko³tũ̱³ka̱³txai²na² ĩ³su²lhã³ain¹nũ²nhai¹. Jã¹nxe³sxã³ ye³ka³lxa¹txi³ hai³sxa² wa³kxẽn³yah³lai²na² a²sa³wi³ha³lxa² ĩ³sa²si¹hã³ain¹ta¹ kwa²hau³ko³tũ̱³ka̱³txai²na² sa²kxai³lu² a²sa³wi³ha³lxa² ka³na³ku² te²a² ĩ³wai¹txi², ka³na³ku² te²a² su²lhã³i² ain¹to³nhũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nxe³ju³ta² sa²kxai³lu², a²wa³kxẽn³yah³la² a²ki³lha³lxa² hãi¹nxe² wẽ³nha³kxa² a³lxi²khai¹nxe³kxa² hãi¹nxe² on³kxi²nũ²nhai¹. Nxe³te³na¹ a²wa³kxẽn³yah³lai²na² a²ẽ¹nãn¹jau³kxai³lu¹: “Txa²wẽ³sxai²na² ĩ³sa²si¹hã³a¹tũ¹xã¹. A²nxe³te²a² kwa²hau³ko³tũ̱³ka̱³txai²na² sa²nẽn¹kxain¹kxi³sã¹.” Nxe³jau³tu̱³ ĩ³sa²si¹hã³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yxãn¹ta¹ a²ki³lha³lxai²na² hai³sxa² ya̱u³son³ye²hĩ¹na¹ tũ̱¹ka̱³txai²na² wãn³txi³kxai³lu¹ wxa²nxũh¹ ĩ³ye³ain¹te³nah¹lxi¹: “Txa²wã¹wa³kxẽn³yah³la² ki³lha³lxa² wxãn³na²wi¹. Ĩ³su²lhã³a³sah¹lxi³wxi¹. Nxe³ki̱³kxai²nãn²tu̱³ hai³sxa² so¹kxi²ki̱³tu¹wi¹.” Nxe³ain¹jau³su². ");
INSERT INTO nabNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","I³sxã³ su²lhxã³ ĩ³ya²lu¹tain¹ka³tu̱³ A²ki³lha³lxai²li² ũ³ha³lo²sa²tã³nã̱¹ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nxe³jau³su² nxe³ju³tan¹te²kxa³ya̱³tu̱³ a²wa³kxẽn³yah³lai²na² ĩh¹nxe³ta³ kãi³te³ji¹wi¹? Nxe³ju³ju¹tai²na² e³kxi¹nx2ta¹tu¹wi¹. A²nxe³jah¹lai²na² sa²kxai³lu² ĩ³xi²ka³tu̱³ ĩ³lxi³thi¹nxa³tũ̱³ka̱³txai²na² sun²tã²hxa³tain¹tu¹wi¹. Nain¹ka³tu̱³ a²nũ̱³ka̱³txi³ ã̱³xa² hai³sxai²na² sa²si³wẽ̱³no³tũ¹hain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxu¹tai²na² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³te³nah¹lxi¹: “Txah³lxa³kxa³txa², a²nũ²a² sxi²ha² ton³te²nũ̱³ka̱³txai²na² o̱³nxa³jau³su² ĩ³ye³kxain¹sxã³ so¹sxã³ ã³sxã³ ã³na¹ain¹ka̱³txa², kwẽn¹tai²na² si³ka³lah³xan¹ka³khai³xa² hxi²kan¹khai¹nxe³ka³txi³lã²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nxe³ju³tai²na² Txa²wã¹sũ̱³na² kãi³ain¹na²hẽ³li¹. Nũ̱³kxũn³khai¹nxe³ju³txai²la¹wi¹.” Ũ³wha²li¹txã³nxũ¹tai²na² nxe³ta¹hxai²ti³ai¹ti²ti¹. Nxe³jau³xai²li² ĩ²yah³lxin¹ta²lu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nxe³sxã³ wãn³txa² hãi³jau³xai²na² Je³su²jah³la² hi²sen³su² ĩ³ye³kxain¹sxã³ wã³nxĩn¹te² si³yxau³ka̱³nũ̱³ka̱³txai²na² ko̱³nxe³ti³ kãi³ain¹ju³ta² ĩ³kwa̱i²kxũ¹nhain¹ta¹hxai²hẽ¹la². Nxe³jau³xai²na² tũ̱¹ka̱³txai²na² sa²kxai³lu² wi¹ko̱³ni²ye²nyhain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ Je³su²jah³la² i³sxã³ ũ³tĩ̱¹kxi²ti³ten³khaix1ain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ yu̱h³lxain¹ta¹hxai²hẽ¹la². — A²nũ²a² kãi²li³nũ̱³ka̱³txai²na² ĩ³xa̱n³ta³kxi²nẽ³lain¹kxa²ya̱n³ti³su² ki̱³nhai¹. Ta¹hxai²hẽ¹la². Ai¹nha²kxai³, wã³nxĩn¹te² nũ̱³ka̱³txai²na² sa²kxai³lu² hãi¹nxe³sxã³ Je³su²jah³la² ã³ain¹sxã³ ĩ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nxe³nxa²ha¹te¹ fa³ri³se²a² kwa² ã³nhai¹tũ̱³ka̱³txi³la³ha²kxai³ E³ro²jah³la² a²sa³wi³ha³lxa² kwa² ã³nhai¹tũ̱³ka̱³txi³la³ha²kxai³ ã³nũ²kxain¹sxã³ Je³su²jah³la² ãn³tĩ̱³xain¹ta¹hxai²hẽ¹la². Nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² ãn³tĩ̱³xain¹ka³tu̱³ ko̱³nxe³ti³ e³jau³su² ain³kxain¹te³lhxã³ Je³su²jah³la² wah³nxe² yxau²xai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ai¹nha²kxai³ ã³tĩ̱³xain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩ³tih³nxe³nẽ³jah¹lãi³. Wãn³txa² ya²la³lyau³xa² e³jah¹lo²sa² nhi¹lxi¹. A²nũ²a² ĩ²li³te²a² ye³a̱n³txa³nih¹kxan²ti³ hxi²kan¹khaix1kxan²ti³ wxãi²na² yu̱h³lxi³jah¹lo²su² sĩ¹nxa³lxi¹. Yxãn¹ta¹, sa²wai³wait3sxã³ Txa²wã¹sũ̱³na² wãn³txa² wain³txi³ ĩ³yau¹ũ³ai¹nhxai²nĩ¹nhẽ³li¹. Nxĩ¹nha²kxai³ wãn³txa² wain³jau³xan²tu̱³ ĩ³yau¹ũ³sa²sĩ¹nhẽ³li¹. Ro³ma²no² nũ̱³ka̱³txa² a²hxi²kan¹jah¹la² Se²sa³jah¹lo²su² a²nũ²a² ũ³yho³ha³kxi²ki³ai²na² ũ³hũ¹ain¹ki̱³ta̱³nxa² hãi¹nxã¹ta̱³nxa² ĩh¹nxe² wain³txi³ kãi³sĩn¹te³la¹ji¹wi¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yxãn¹ta¹ tũ̱¹ka̱³txai²na² wi¹lhin¹ki³lxo³nxe³ju³ta² Je³su²jah³la² wi¹ko̱³nha²ta¹hxai²hẽ¹la². Wi¹ko̱³nha²kxe³su² ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ wãn³txa² ko̱³nxe³jau³xa² sa²yxo²sai¹sa²te³lhxã³ ten³nx2ti³ji¹wi¹? Ũ³yho³ha³kxi²ki³ai²na² tẽ³sxã³ ũ³hũ¹sah¹lxi³hẽ¹li¹. Ĩ²ti³ten³sa³nhai¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nxe³nxa²ha¹te¹ tẽ³sxã³ ũ³hũ¹ain¹nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Ta³ki¹ai²na² a²ta³lo³nãu³ai²na² wãn³txa² jau¹xai²na² ũ³wha²li¹lain¹jau³xa² ĩh¹te²a² a²ĩ³lxi³su²ji¹wi¹? A²nũ²a² ye³na² ũ³wha²li¹lain¹kxe³su² te²a² ĩh¹nxe³te²a² a²ye³nhũ̱³ji¹wi¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — A²ĩ³lxai²na² Se²sa³jah¹la² a²ĩ³lxi³su² ha²kxai³ a²ye³nai²na² Se²sa³jah¹la² a²ye³nhũ̱³nha²kxai³ sĩn¹te²jai¹ti²ti¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Se²sa³jah¹la² a²yen³kxi³khai³xa², ũ³hũ¹xi²yah³lxi¹nha²kxai³ Txa²wã¹sũ̱³na² a²yen³kxi³khai³xa², ũ³hũ¹xi²yah³lxi¹nha²kxai³ nxe²xai³jah³lxi³hẽ¹li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². Nxe³jau³xai²na² ĩ³wã̱³wã̱³ta³kxi²nyhain¹sxã³ ã³ko̱n³ton³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nxe³nxa²ha¹te¹, Sa³tu³se²a² nũ̱³ka̱³txa² ã³nhai¹tũ³te²nãu³xai²na² a²wãn³txi³kxai³lu¹ ĩ³ye³ain¹to³jau³xa²sa¹: — A²nũ²a² ya³lu²kxai²nãn²tu̱³ ka³te̱n³su² ĩ³sa²yxau³xi²ju³ta³nũ³a² yũ²nxa³lho³li¹. Nain¹to³ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² kwa² ã³nhai¹tũ̱³ka̱³txa² wxã³sxã³ Je³su²jah³la² ĩ³wã̱³txi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ĩ³wã̱³txi³nyhain¹te³nah¹lxi¹: — Je³su²jah³la² ĩ³tih³nxe³nẽ³jah¹lãi³. Ĩ³yau¹ũ³sa²sĩ¹nhẽ³li¹. Moi³se²ah³lu¹tai²na² wãn³txa² e³jau³xau³hxai²tẽx1ta² Sũ̱³na² wãn³txa² ĩ³yau¹ũ³nẽ³te³nah¹lxi¹: “In³txi³su² ya³lu²kxi²kxai²nũn³tu̱³ a²wẽ³ha³lxi³khai³xa² yũ²nxa³kxe³su² ha²kxai³ a²lon³yah³lai²na² sa²kxai³lu² a²txu¹ha² so¹nyha¹ta¹ka³lxai³tã² so¹nyha¹txai²li¹, a²lo³na² ya³lu²kxi²jah¹la² ta²ha² wet1si¹jau³sa¹.” Moi³se²ah³lu¹tai²na² ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nxe³nxa²ha¹te¹ a²lon³ti³tãu³xa² ha¹li¹ ha¹li¹ ha¹li¹ ka³na³ki¹ yxau³ain¹nũ²nhai¹. A²hxi²kan¹te²a² txu¹ha² so¹ka³tu̱³ hã²wxãn³txa³ ye³jen¹nãu³a² ya³lu²nũ²nhai¹. Hai³txi³ wẽ³sa³la³ yũ³ti³he¹nxa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nxe³ha²kxai³ wẽ³sa² yũ²nxa³ha²kxai³ a²lon³yah³la² so¹nũ²nhai¹. Nxe³nũ²la² in³txa² ya³lu²nũn³nũ²nhai¹. Hã²wxãn³txa³ a²lo³na² ã̱³xah³la² so¹nyhu¹i² ya³lu² nxe³nũ²nhai¹. Hai³txi³ wẽ³sa³la³ we¹ti³hex1to³hxa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nxe²xai³sxã³ a²lon³ti³tãu³xa² ya²lun¹txa²hxan³nũ²nhai¹. Yxãn¹ta¹ hxi²kan¹txi³ wẽ³sa² we¹txa³nũ²nhai¹. Hã²wxãn³txa³ txu¹hai²na² so¹sxã³ ã³ain¹ta¹ka³lxu³su² ha²kxai³lu¹ ya³lu²nũn³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jã¹nxe³ha²kxai³lu¹ yan¹nãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²ki̱³tãu³a¹ ta¹ka³lxai²na² sa²kxai³lu² ĩh¹te²la³ta̱³ in³txa² wẽ³sãi¹ah³lo²khai³su² hĩ̱³te³ji¹wi¹, a²yxo²ha³kxa¹ so¹nha²xai³ain¹na²ha²kxai³lu¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Kwa²yxah³lxi¹lxi¹. Txa²wã¹sũ̱³na² wãn³txa² ã³ne³to³yah³lxa³nha²kxai³ Sũ̱³na² wã³nxĩn¹ju³ta³la³ ã³ne³to³yah³lxa³nha²kxai³ nxe³yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yan¹nãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²ki̱³tãu³a¹ txu¹ha² so¹ki̱³ju³ta³nu³a² yũ²nxa³lho³li¹. Oh³xan¹ta² nũ̱³ka̱³txa² yã¹nxa²ki̱³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kxã³nxu¹tai²na² Moi³se²ah³lu¹tai²na² wãn³txa² ĩ³yau¹ũ¹nhẽ³jau³xa² wi¹ko̱³nyhah¹lxin¹ta²lu¹wi¹. A²nũ²a² ya³lu²te²na² ka³te̱n³su² ĩ³sa²yxau³xi²si¹kxe³su² ĩ³yau¹ũ¹nhẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. Wãn³txu¹tai²na² hi³a² nxã³nxa² ka³te̱n³nxã³nxa² i̱³sa²tẽ³kxan²ti³ wã²nhxa³nxa³kxe³su² nxe³jau³xu¹tai²nãn¹jau³xa² nxe³te³nah¹lxi¹: “Txai²na² A³bra³ãu²ah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ I³sa²kah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ Ja³ko²ah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ hĩ¹na¹ nxe³te²sa¹wi¹.” Txa²wã¹sũ̱³na² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nxe³ha²kxai³ ha¹li¹ ka³na³ki¹ jah¹lo²nãu³xai²na² ka³te̱n³su² yxau³ain¹na³li¹. Txa²wã¹sũ̱³na² a²sa³wi³ha³lxi³nãu³xa² yxo²ha³kxa¹ ka³te̱n³sa²na³li¹. Kxã³nãu³u¹ta²kxai³ ya³lu²ain¹kxa²ha³ta̱³nxãn²tu̱³ hĩ¹na² ka³te̱n³sain¹na³li¹. Nxe³ha²kxai³ wxa²nũ̱³ka̱³txai²na² Txa²wã¹sũ̱³na² a²ya³la³tu̱³jau³xa² ã³ne³wxe³yah²lxa³lxi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nxe³nxa²ha¹te¹, ha³te̱h³nxã³nxa² a²hoh³lxi³su¹ tũ̱³ka̱³txa² ka³na³ka³na³jah¹la² ya̱u³son³ta¹hxai²hẽ¹la². Ya̱u³son³nũ²la² Je³su²jah³la² a²wãn³txa² sa³tu³se²a² nũ̱³ka̱³txai²na² ĩ³ye³kxi²yhain¹jau³xai²na² wain³txi³ ĩ³wa²lũ³xain¹jau³xai²na² ain³kxain¹ta¹hxai²hẽ¹la². Ain³kxain¹ka³tu̱³ ha³te̱h³nxã³nxa² a²hoh³lxi³su² jah¹lai²na² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³wã̱³txi³te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wãn³txu¹tai²na² ĩh¹jau¹la³ta̱³ wa³to²hi² wxi²kan¹jau³la³ te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wa³to²hi² wxi²kan¹jau³xa²sa¹: “I³sa³e² nũ̱³ka̱³txãi³. Ĩ¹ne³ka²sah¹lxi³wxi¹. Sũ̱³na² Si³yxau³tãu³ai²na² A²hxi²kan¹txa² Si³yxau³tãu³ai²na² hãi¹nxe² ka³na³ka³na³jah¹lo²su² na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nxe³ha²kxai³ Txa²wã¹sũ̱³na² Si³yxau³kah³la² Txa²wã¹hxi²kan¹ta² Si³yxau³kah³lai²na² a³lxi²txai¹nhẽ³li¹. Wxa²ẽ¹nãu³ai²na² whãi²na¹ a³lxi²txai¹nhẽ³li¹. Txa²wã¹sũ̱³na² wãn³txa² yxo²kwa̱i³nha²kxai³ wi¹lain³kxi¹nha²kxai³ nũ³kxũn³txi³ sa²yxo²we¹tha²kxai³ nxe³txai¹nhẽ³li¹.” ");
INSERT INTO nabNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nxe³nxa²ha¹te¹ ã³ta³lo³hẽ¹jau³xa²sa¹: “Wxa²wa̱³kxa² yxau³nũh¹nxa²te²su² te²a² a³lxi²nha²kxo² yã¹nxe² a³lxi²txai¹nhẽ³li¹.” Ha¹lin¹jau³xai²nãn²tu̱³ wa³to²hi² wxi²kan¹khaix1jau³xai²la¹wi¹. Hai³txi³ ã²la² wxi²kan¹jau³la³ yũ²nxa³wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nxe³nxa²ha¹te¹ ha³te̱h³nxã³nxa² a²hoh³lxah³lai²na² a²wãn³txi³kxai³lu¹: — Ĩ³tih³nxe³sa²jah¹lãi³. Wxa²wãn³txa² wain³khai¹nx2na³li¹. Txa²wã¹sũ̱³na² hãi¹nxe² ka³na³ka³na³tã³li¹. Hai³txi³ Sũ̱³na² ã̱³la³ yũ³ti³he¹xai¹nxa³wi¹. Nxe³nĩn¹jau³xai²na² a²ya³la³jau³khaix3ai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Txa²wã¹sũ̱³na², txa²wã¹ẽ¹nãu³a¹ whãi²na¹ a³lxi²ki̱³sa²kxai³ Txa²wã¹sũ̱³na² wãn³txa² wi¹lain³kxi²nẽ³lha²kxai³ nũ³kxũn³txi³ sa²yxo²we¹ki̱³sa²kxai³ txa²wã¹wa̱³kxa² yxau³nũ¹nhẽ³te²su² te²a² a³lxi²nẽ³nha²kxa² yã¹nxe² a³lxi²ki̱³sa²kxai³ nxe³ju³tai²na² whãi²na¹ wa³to²hi² wxi²kan¹ju³tai²la¹wi¹. Hai³txi³ ka³yxuh³xa² su²lhã³sxã³ ũ³hi̱³lhxã³ Txa²wã¹sũ̱³na² ũ³hũ¹ain¹ki̱³ke³la³te²kxai³, nxe³ju³ta² wa³to²hi² wxi²ka¹nhĩ̱³nx2nxa³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nxe³jau³xai²na² sa²nẽn¹nha²jau³xai²na² ĩ³wa²lũ³xi²kxe³su² Je³su²jah³la² a²hi²sen³kxai³lu² ain³kxain¹ka³tu̱³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²wet1sxã³ yxau²xai³ju³ta² jũ¹nxa² ã³ne³wxe³ton³nĩ¹lxi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². Nxe³hĩ¹nãn¹te²tu̱³ a²nũ²a² yxo²ha³kxa¹ yu̱³lhxai¹nha²kxai³, hai³txi³ Je³su²jah³la² ĩ³wã̱³txi³sain³ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nxe³nxa²ha¹te¹ Txa²wã¹sũ̱³na² sxi²hẽ¹nãu³a¹ Je³su²jah³la² ĩ³ye³ta¹hxai²hẽ¹la². Wãn³txa² ĩ³yau¹ũ³te³lhxã³ ĩ³ye³te³nah¹lxi¹: — Ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² a²wãn³txi³kxai³lu¹: “Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹lo²su² jah¹la² Ta³vi²yah³lu¹tai²na² a²ne³tah²nãu³ai²la¹wi¹.” Nxe³ain¹na³li¹. Nxe³jau³xai²na² a²si³yxau³tãu³khai³xa² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nxe³nx2ta¹te³nah¹lxi¹: Kxã³nhxĩ¹nu¹tai²na² Ta³vi²yah³lu¹tai²na² ĩ³ye³ta¹hxai²hẽ¹li¹. Wãn³txa² Txa²wã¹sũ̱³na² A²yãu³ka³jxah¹la² a²hi²sen³su² ĩ³ye³sxã³ ũ³hũ¹ain¹jau³su² ĩ³ye³ta¹hxai²hẽ¹li¹. Ĩ³ye³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² Si³yxau³jah¹la² a²yxo²wãn³txi³kxai³lu² Txa²wã¹hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la² ain³kxi²ti³an¹jau³kxai³lu¹: ‘Txa²wi¹nẽ³tãu³a¹ ã³wxe³txu¹li¹. Nxĩn¹kxai²nãn²tu̱³ wxa²ko̱¹ko̱¹xa² a²yxo²ha³kxa¹ wxa²yu³hẽ³nãu³a² wa³ka³ti³lot3sxã³ a³hi²si¹hai¹na¹tu¹wi¹.’ Txa²wã¹sũ̱³na² Si³yxau³jah¹la² ta¹hxai²hẽ¹li¹.” Ta³vi²yah³lu¹tai²na² ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jã¹nxe³jau³su² Ta³vi²yah³lu¹tai²na² a²yxo²wãn³txa² a²hxi²kan¹jah¹lo²si¹ke³la³te²kxai³ ĩh¹nxe³sxã³ a²ta²lhot3hĩ̱³te²la¹xã³? Je³su²jah³la² ta¹hxai²hẽ¹la². Nxe³jau³xai²na² a²nũ²a² kãi²li³tũ̱³ka̱³txa² ain³kxain¹ka³tu̱³ kãin² ka³li³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²hi²sen³kxai³lu¹ a²nũ²a²nãu³xa² ĩ³yau¹ũ³hain¹te³nah¹lxi¹: — Ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² wi¹lĩ²jah¹lxi³hẽ¹li¹. Nxe³tũ̱³ka̱³txa² hi²sen³su² wã²la² a³lu²ka³lo³a² ũ³whi²kxi²nha²nũ²la² a²nũ²a² hxi²kan¹te²yã¹nha²kxe³su² yxo²kwa̱i³no³tai¹nhxai²na²hẽ³li¹. Tĩh³na² sxi²je³na² nxũ²kwa̱i³ye³lo³tĩh³na² ã³nxai³tãu³a² wi¹le³kxi²nyhain¹ju³ta² yxo²kwa̱i³no³tain¹nũ³nhxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³nai²na² ã³wxe³ka³lo³a² sa²nẽn³nha²khaix1nxe³te²a² ã³wxe³ka³lo³a² yxo²kwa̱i³no³tai¹nha²kxai³ a²nũ²a² ã³nũ²kxi²sxã³ yain³kxi²nyhai¹nhxai²na²hẽ³ nxe³tãu³a² te²yã¹nxe³sxã³ ã³wxe³ju³ta² sa²nẽn¹kxi²khaix1nxe³ta² ã³wxe³ka³lo³a² yxo²kwa̱i³no³tai¹nha²kxai³ nxe³nyhai¹nhxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nxe³kxa²yu³su² txu¹ha² wha³te̱³son³ta¹ka³lxa² yen³kxa² kãi³so¹kxi²te³lhxã³ nxe³ai¹nhxai²na²hẽ³li¹. Nxe³ain¹tãu³a² Txa²wã¹sũ̱³na² yau³ka³lxa¹txi³ wi¹le³kxi²ki³lxo³xai¹nhxai²na²hẽ³li¹. Ain¹ta¹ ain³kxi²nyhai¹nxa³lho³li¹. Kxãn³nãu³a¹ ko̱³nxe³khai¹nxe³sxã³ ĩ³yĩ¹li²nu¹hain¹tu¹wi¹. Yxãn¹ta¹ nxe²kãi³ai¹nxa³tũ̱³ka̱³txa² ko̱³nxe³ti³ ĩ³yĩ¹li²nu¹hain¹ju³ta² kũ³we²ki²la² kãi²nxa³lho³li¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nxe³nxa²ha¹te¹, kwa³ta³la² kãin²tẽ³na² Sũ̱³na² sxi²nhãu³ã¹ sxa³tẽ³na², ta¹hxai²hẽ¹la². A²nxe³tẽ³na², a²nũ²a² ka³lxa²te²nãu³xa² wxã³sxã³ a²yen³kxa² ũ³yho³ha³kxi²ki³a² ũ³whi¹sxã³ ũ³wha̱¹ain¹ta¹hxai²hẽ¹la², Txa²wã¹sũ̱³na² ũ³hũ¹te³lha³ka². Nxe³nxa²ha¹te¹ Je³su²jah³la² ã³wxã³sxã³ kwa³ta³lẽ³nai²na² un²ta³kxi²nxa³je³na² ã³wxe³ain¹ka³tu̱³ a²nũ²a² ĩ²te³lhxã³ ã³wxe³ta¹hxai²hẽ¹la². Nxe³tãu³a¹ a²nũ²a² a²yen³kxih³khaix1sa² te²a² ka³lxa¹tũ̱³ka̱³txa² wxã³sxã³ a²yen³kxa² ũ³yho³ha³kxi²ki³a² sa²kxai³lu² ki³ka³lxa¹txi³ ũ³wha̱¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nxe³ju³ta² txu¹ha² wha³te̱³son³ta¹ka³lxa² yen³kxi³txa²ta¹ka³lxa², ã³wxã³sxã³ ki³jũ¹lxi³ki³a² ki³ha¹li¹ ũ³wha̱¹ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ain³te³na¹, Je³su²jah³lo²su² te²kxai³lu¹, a²sa³wi³ha³lxi³nãu³xa² ĩ³kaix1so¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. Wha³te̱³son³ta¹ka³lxai²na² yen³ki³ txa²ta¹ka³lxai²na², a²yen³kxa² ũ³wha̱¹ki³a² kãi²nxa³kxan²ti³ Txa²wã¹sũ̱³na² yen³nãu³a² a²yo³ha² kãin²ye²na³li¹. Yxãn¹ta¹ a²nũ²a² a²wã³kon³tũ̱³ka̱³txa² yxo²ha³kxa¹ Txa²wã¹sũ̱³na² yen³nãu³a² a²yo³ha² kãin²ye²ai¹nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nxe³ju³ta² a²nũ²a² yxo²ha³kxa¹ a²yen³kxi³ki̱³ki³a² a²wã³kon³kxain¹kxa² so¹lxi³ ũ³hũ¹ain¹te¹ni²ti¹. Yxãn¹ta¹ ta¹ka³lxai²na² sa²kxai³lo³ yen³kxi³txa²kxa²ha³ta̱³nxãn²ti³nũ¹ a²yen³kxa² yũ³kxe³su² yxo²ha³kxa¹ ũ³hũ²hxa³te¹ni²ti¹. A²yain³txi³khai³xa² ũ³yho³ha³kxi²ki³a² yxo²ha³kxa¹ ũ³hũ¹te¹ni²ti¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nxa²ha¹te¹ Txa²wã¹sũ̱³na² sxi²ha², Je³su²jah³la² a³li³ta¹hxai²hẽ¹la². A³li³tãu³a² a²sa³wi³ha³lxa² ka³na³ka³na³te² hi²sen³su² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³tih³nxe³sa²jah¹lãi³. Ĩ²txa²hẽ³li¹. Thĩ¹nai²na² yxo²ha³kxa¹ kãin²khaix1ni² wi¹khaix1ni² nx2na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nxe³yãn¹ta¹ Je³su²jah³la² wãn³txi³kxai³lu¹ ĩ³wa²lũ³xi²te²an¹jau³kxai³lu²: — Sxi²hai²na² txah³lxa³kxa² wi¹txo³nain¹ju³ta² ĩ²in¹ji¹wi¹? Nxe³to³ta¹ kxãn³nãu³a² txah³lxa³kxa² a²yxo²ha³kxa¹ wxa²nai¹ain¹tu¹wi¹. Ya²la³tu̱³ hai³txi³ ka³tha¹li¹ ã³ne³hẽ²si²ka³txa² yũ²nx3tho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nxe³nxa²ha¹te¹ wã³la³ka³txa² O³li³ve²ra³ka³txa² Txa²wã¹sũ̱³na² sxih²yxo²a² ten³na¹ain¹je³nai²na² Je³su²jah³la² a²nũ̱³ka̱³txa² ã³wxe³ain¹ta¹hxai²hẽ¹la². Ã³wxe³ain¹te³na¹, Pe²jah³la², Ti³a²kah³la², Jo³ãu²ah³la² Ãn³tre²ah³la² whãi²na¹, wxa²nxũh¹ ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ĩ³wã̱³txain¹te³nah¹lxi¹: — Nxe³sãn²si¹lxi¹. Ĩh¹nxe³hĩ¹na² wxa²nai¹ain¹sĩn¹te³ji¹wi¹? Ĩh¹nxe³ti³wa̱³kxa² ya̱u³son³sxã³ txa²wã¹ha³lo²a² ne³ki³son³ju³ta²nũ³a² ĩ²sxã³ wi¹ko̱³nha²hĩ̱³ki̱³te³ji¹wi¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nxe³nxa²ha¹te¹ Je³su²jah³la² wãn³txi³kxai³lu¹ ĩ³ye³kxi²te³nah¹lxi¹: — Wi¹lĩ²nha²khai¹nxe³jah¹lxi³hẽ¹li¹. Ĩ³ki³ha¹kxi¹nx2ti³ha³tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A²nũ²a² ka³lxa¹te²a² wxã³yah³lxi³ha³tai¹. Txai²yã¹nxe³ki̱³lxon³tu¹wi¹. Nxe³sxã³ wxã³sxã³ ki³han³jau³su² e³yah³lxi³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹. Wxa²kan³sxã³ wa̱³li²na¹hẽ³li¹.” Nxe³jau³su² e³yah³lxi³to³ha³tai¹. Nxe³yah³lxi³to³ha²kxai³ wxa²nũ̱³ka̱³txa² ka³lxa¹ ã³nhai¹tũ¹sxã³ ĩ³ki³ha¹kxi¹nx2ti³ha³tai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jã¹nxa¹jau³su², ti¹na² yxau³tũ̱³ka̱³txi³nãu³xai²na² kãin² ã³nhe¹kxi²nyhu¹sxã³ su²lhã³nyhain¹kxai²nãn²tu̱³ nũ¹ka³na¹ u²tãu³ai³tã² yxau³tũ̱³ka̱³txi³nãu³xai³tã² kãin² ã³nhe¹kxi²nyhu¹sxã³ su²lhã³nyhain¹kxai²nãn²tu̱³ nxe³jau³xai²nãn²tu̱³ ain³kxi²yah³lxin¹kxai²nãn²tu̱³ ĩ³yu̱h³lxah³lxi³txa³hẽ¹li¹. Ya²la³lyau³su² kxan²ti³ hai³txi³ hĩ¹nãn²tu̱³ ha³lo²ai²nãn²tu̱³ ne³ki³so³nx3tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","A²nũ²a² nũ̱³ka̱³txa² a²nũ²a² nũ̱³ka̱³txi³ ã̱³xa² a²lhun³tu², ã³nhe¹kxi²nyhai¹nha²kxai³ a²hxi²kan¹ta² si³yxau³tãu³a¹ a²hxi²kan¹ta² si³yxau³tãu³ ã̱³xa² a²lhun³tu², ã³nhe¹kxi²nyhu¹ha²kxai³ ha³lo²a² ka³lxa¹ko³xa² kxĩh³nxa² sa²wi¹wi¹nha²kxai³ a²nũ²a² yain³txi³ txa²khai¹nxe³ha²kxai³ he³ja²lun¹ti³ha²kxai³ nxe³ain¹tu¹wi¹. Nain¹kxai²nãn²tu̱³ txu¹ha² wẽh³ni³khaix1ta¹ka³lxa² ĩh³ju³ta² wxã³kxai²nãn²tu̱³ wẽ³sa² a³li³lah¹kxi²ju³ta² hãi¹nxe³sxã³ ã³si³we³te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ ju¹tai²na² wxã³nũ¹nx2ti³kxai²nãn²tu̱³ khãuh³yxah³lxin¹ju³ta² ã³si³wxe³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nxe³yãn¹ta¹ ha³lo²ai²na² sa²wai³wait3sxã³ nũ¹hĩ²jah¹lxi³hẽ¹li¹. Ju³te²a² nũ̱³ka̱³txa² hxi²kan¹ta³ nũ̱³ka̱³txa² ã³yã³nũ²kxai¹nha²kxai³ nxe³sxã³ i³nx2ti³sxã³ ãn³yũ³nx2tai¹nha²kxai³, Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³nãu³a² ĩ³ta³lo³su²nx2ti³ha²kxai³, nxe³nx2ti³ha³tai¹. Txa²wãn³txa² yxo²ĩ²sah³lxin¹ju³tan¹te²kxa³ya̱³lhu² wxa²ha³lo²a² wa³kxẽ³nxa² si³yxau³ka³txa² ko³ver³na³to²yah³lo²su² ha²kxai³ ã³sa²so¹nx2ti³ha²kxai³ wxa²nũ³ka³txa² wa³kxẽ³na² si³yxau³kxa³ta² Pre³si³tẽn²jah³lo²su² ha²kxai³ ã³sa²so¹nx2ti³ha²kxai³ nxe³nx2tai¹nha³tai¹. Nxe³nx2tain¹kxai²nãn²tu̱³ yxo²ĩ²sah³lxin¹ju³ta² ĩ³wã̱³txi¹nx2ti³tu¹wi¹. Nxe³nx2tain¹kxai²nãn²tu̱³ txũ̱¹ka̱³txai²na² whãi²na¹ Sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³hen³txain¹yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yah³lxi¹nha²kxai³ ha³lo²a² hãi¹nxe³ti³xa² a²nũ²a² yxo²ha³kxa¹ wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³ain¹yah³lxin¹tu¹wi¹. A²nũ²a² ĩ²li³te²na² ko̱³nxe³ti³ kãi³ju³ta² ĩ³ãin²ta³kxi²nha²sxã³ ã³kxai²nãn²tu̱³ yxo²ĩ²sain¹kxai²nãn²tu̱³ nxe³te²su² te²na² a²ẽ¹na² sa²hau³ko³tai¹na¹ju³ta² yũ³jau³nũ³su² ĩ³yau¹ũ³ain¹yah³lxin¹tu¹wi¹. Ĩ³yau¹ũ³ta³lu²nain¹yah³lxan³tãu³a² ha³lo²ai²na² ne³ki³so³nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nxe³nx2tain¹kxai²nãn²tu̱³ i³nx2tain¹sxã³ a²nũ²a² ãn³yãn³nũ²kxi²ju³ta² ã³yũ³nx2tain¹kxai²nãn²tu̱³ hxi²waun³ta³kxi²nhyah¹lxi³txa³hẽ¹li¹. “Ĩh¹nxet3sxã³ ĩ³ye³kxai¹na¹lhon³ku².” Nxe³yah³lxi³txa³hẽ¹li¹. Nxe³nx2tain¹kxai²nãn²tu̱³ wãn³txa² wi¹jau³xa² Txa²wã¹sũ̱³na² a²hi²sen³su² ũ³hũ¹nx2ti³tu¹wi¹. Nxe³jau³xai²na² so¹lxi³ ĩ³ye³kxi²txain¹yah³lxi³hẽ¹li¹. Wxãi²na² ĩ³ye³kxain¹yah³lxin¹jau³xa² hai³txi³ wxa²wãn³txi³khai³sxa³lho³li¹. Txa²wã¹sũ̱³na² A²yãu³ka³jxah¹la² Wi¹lhin¹jah¹la², nxũ²kwa̱i³yxau³nx2ti³jah¹la² ĩ³ye³kxi¹nx2ti³si¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Nxe³hĩ¹na¹ yxo²ĩ²sah³lxin¹ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² a²yxo²ha³kxa¹ ĩ³a̱n³ta³kxi¹nx2tain¹tu¹wi¹. A²nũ²a² yxo²ĩ²xa³te²na² sa²kxai³lu² a²lon³khai³xa² ĩ³ya²lut1si¹jau³su² ã³yũ³so¹nha¹tu¹wi¹. A²wĩ³na² sa²kxai³lu² a²wẽ³sa² khai³xa² ã³yũ³so¹ha²kxai³ a²wẽ³ha³lxai²na² sa²kxai³lu² a²wĩ³na² a²hã³ka³na² nxe³sxã³ ã³yũ³so¹nyhai¹nha²kxai³ nxe³nyhai¹nha³tai¹. Te²yã¹nxe³jut3su² nxe³nx2ti³kxai²nãn²tu̱³ sa²yxo²ã³syah¹lxi³txa³hẽ¹li¹. Sa²yxo²ã³syah²lxan³kxai²nãn²tu̱³ kxã³nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³a² yxau²xai³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nxe³yãn¹ta¹, ĩ³lxi³thin¹ti³he¹nxa³jah¹la² a²yen³kxa² yxo²ha³kxa¹ wxa²khot3thun¹jah¹la², wxã³sxã³, Txa²wã¹sũ̱³na² sxi²ha² ã³wih¹sxã³ sa²nxũ³sxã³ yxau³ain¹tu¹wi¹. Nxe³ju³ta² wain³ti³hex1te²sxa³yu²hẽ³li¹. A²nxe³jah¹lai²na² wxã³sxã³ yxau³ain¹na³na¹ nxe³yah³lxin¹kxai²nãn²tu̱³ ã³naun³ti² ã³nih³jah¹lxi³hẽ¹li¹. Ju³te²a²ko³xa² yxau³te²su² te² ĩ³nxa² wã³la² kĩ³ka³txa² ã³nih³jah¹lxi³hẽ¹li¹. Ũ³wha²li¹txã³nxu¹txai²na² ĩ²yah³lxin¹kxai²nãn²tu̱³ ã³ye³wxe³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nxe³ju³ta² a²nũ²a² sxi²ha² ne³ka³nah²nãu³ã¹ he¹yah³lxin¹kxai²nãn²tu̱³ wxa²yen³kxa² sxi²hẽ¹nãu³ai²na² wi²sxa³kxai²nãn²tu̱³ ã³wi²hxi²sxã³ so¹yah³lxi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ u²lã³ni¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jã¹nxe³sxã³ a²nũ²a² hai³sxa³nãu³a¹ he¹yah³lxin¹kxai²nãn²tu̱³ ã³wa²li²sxã³ wã²la² ha³la³sa³nãn¹ka³lo³a² wxa²so¹xi²te³lhxã³ sxi²ha² ã³wi²hxi²sxã³ wxa²so¹xah¹lxi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ u²lã³ni¹jah³lxi³sã²nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ko̱³nxe³jah¹lai²na² wxã³ju³tai²nãn²tu̱³ txu¹ha² wẽ³nhain¹te²su² te²na² kãin² khãuh³nxain¹tu¹wi¹. Txu¹ha² a²wẽ³sa² ũ³hi³lain¹te²su² te²na² kãin² khãuh³nxain¹nũn³tu¹wi¹, hxi²kan¹txi³ ã³ni³hai¹nxa³ha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nxe³yãn¹ta¹ wa̱³txi²tãu³a¹ ã³nih³yah³lxin¹ke³la³te²kxai³ kãin² khãuh³yxah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yah³lxin¹kxa²ya̱n³ti³su² Txa²wã¹sũ̱³na² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nxe³hĩ¹nãu³ãn²tu̱³ ha³lo²a² ko̱³nxe³khai¹nxe³ju³ta² ĩ³lxi³thin¹ti³he¹nxa³ju³ta² yũ³tu¹wi¹. Txa²wã¹si³kxã³nãu³hĩ¹nũ¹tai²nãn¹te²tu̱³ Txa²wã¹sũ̱³na² ha³lo²ai²na² we¹thĩ¹nãn¹te²tu̱³ a²ko̱³nxe³ju³ta² yũ³ju³ta² kũ³we²ki²la² ko̱³nxe³thi¹nxa³ha²kxai³ yxan¹nãu³a¹ ha³lo²a² nxe²xai³tãu³a¹ ko̱³nxe³ju³ta² yũ³ju³ta³nũ³a² kũ³we²ki²la² ko̱³nxe³thi¹nxa³ha²kxai³ nxe³te²sxa³yu²hẽ³li¹. Nxe³yãn¹ta¹ a²ko̱³nxe³ju³tai²nãn²tu̱³ ĩ³ye³kxi¹nx2ta¹ju³tai²nãn²ta² so¹lxi³ ã²la² ko̱³nxe³thin¹khai¹nxe³ju³ta² yũ³hĩ̱³nx2na³li¹. Nxe³ju³ta² a²nũ²a² ã²la² kxa²kãin² khãuh³lxa³ti³hĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nxe³ha²kxai³ Txa²wã¹hxi²kan¹ta² si³yxau³tãu³a¹ ha³lo²ai²nãn²tu̱³ ko̱³nxe³khai¹nxe³ju³tai²nãn²tu̱³ ã³yã³ni²lã³ain¹sãn²tu¹wi¹, a²nũ²a² Txa²wã¹sũ̱³na² hxi²ka² ã³yũ³so¹xi²kxe³su² te²a² a³lxi²khaix1ai¹nha²kxai³lu¹. Ã³yã³ni²lã³ai¹nxa³ke³la³te²kxai³ hai³txi³ a²nũ²a² ka³na³ka³na³ta² he³la³ku³ yxau²xai³lhĩ̱³nx2nxa³wi¹. A²yxo²ha³kxa¹ hxan³khaix1hĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nxe³nxa²ha¹te¹ a²nũ²a² a²ten³te²su² te²an²tu̱³ ĩ³ki³han³jau³su² ĩ³ye³kxi¹nx2ti³kxai²nãn²tu̱³: “Ti¹na² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la² he¹na³li¹. Ĩ²jah¹lxi³hẽ¹li¹.” Ta̱³nxa², “Nũ¹ka³na¹, Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la² he¹na³li¹.” Ta̱³nxa² nxe³nx2tain¹kxai²nãn²tu̱³ yxo²ĩ²ain¹sxã³ yxau²xai³lyah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","A²nũ²a² ã³wxã³ain¹sxã³ ĩ³ki³ha¹kxi¹nx2tain¹tu¹wi¹. Nxe³ju³ta² ka³na³ku² te²a²: “Txai²li² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹.” Ka³na³ku² nũn³te²a²: “Txai²li² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²sa¹wi¹.” Nxe³nx2tain¹tu¹wi¹. Nain¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² a²nũ³kxũn³ju³ta² ki³lxot3sxã³ kãi³ain¹tu¹wi¹. Ain¹sxã³ a²nũ²a² Sũ̱³na² ã³yũ³so¹te² ĩ̱³nxai²na² ĩ³ki³ha¹kxi¹nx2tain¹tu¹wi¹. On²sxã³ yxo²ĩ²ain¹yah³lxin¹kxa²ya̱n³ti³su² ye¹nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yxa¹nã¹nhĩ¹na² ha³lo²ai²nãn²tu̱³ nxe²xai³tu¹wi¹. Nxe³yãn¹ta¹ Txai²li² kwẽn¹tai²na² ĩ³hen³txi³nx2ta¹wi¹. Jã¹nxe³nx2tain¹kxa²ya̱n³ti³su² nũ¹hĩ²jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yxan¹nãu³a¹ a²ko̱³nxe³ju³tai²nãn²tu̱³ ne³ki³son³kxai²nãn²tu̱³ a³lan²tan¹ki³ain²ti³ ĩ³ka³nxa³hi²ha²kxai³, ka³nxah³tan¹ki³ain²ti³ ĩ³ka³nxa³hi²ha²kxai³ nxe³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jã¹nxe³sxã³ i³la³kxa² wẽ³ha³lxa² whãi²na¹ oh³sĩ̱n³nãu³a¹ a³hai¹nha²kxai³ oh³nãu³a¹ yxau³te²su² te²a² hxi²ka̱u³ka̱un³ti³ ã³nxai³lai¹nha²kxai³ nxe³ain¹tu¹wi¹. Nxe³sxã³ o³sĩ̱³na² whãi²na¹ ĩ³ã̱³lxi³ti³si¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nxe³tãu³a¹ Txai²na² oh³sĩ̱n³nãn¹ka³lo³a² hãn³ta³ka³lo³a² whãi²na¹ a³ka³nxi²na¹ka³tu̱³ wxã³na¹tu¹wi¹. Nũ̱³kxũn³txi³ ĩ³kĩx3khai¹nxe³ha²kxai³ wxã³na¹tu¹wi¹. Wxã³na¹ju³tai²nãn²tu̱³ a²nũ²a² yxo²ha³kxa¹ ĩ²sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nxe³na¹kxai²nãn²tu̱³ oh³xan¹ta² nũ̱³ka̱³txa² ka³lxa¹te² nũ̱³ka̱³txa² ĩ³sa²si¹hã³ai¹na¹tu¹wi¹. Ĩ³sa²si¹hã³ai¹na¹kxai²nãn²tu̱³ a²nũ²a² Txa²wã¹sũ̱³na² ã³yũ³so¹kxe³so¹lxin³te²kxai³ so¹sxã³ wxa²sa²nũ²ti²ai¹na¹tu¹wi¹. Nũ¹ã¹ u̱³je³na³kxa² a³li³xi²tãu³a² sxa³ain¹te²ain²ti³ ãn³sa²so¹xi² nũ¹ã¹ u̱³je³na³kxa² kan³tãu³a¹ sxa³ain¹te²ain²ti³ ã³sa²so¹xi² nũ¹ã¹ u̱³je³na³kxa² a²ta³nã³nẽ³nãu³a¹ sxa³ain¹te²ain²ti³ ã³sa²so¹xi² nxe² wxa²sa²nũ²ti²ai¹na¹tu¹wi¹. Ha³lo²a² yxo²ha³kxa¹ sxa³ain¹te²su² te²a² Sũ̱³na² ã³yũ³so¹kxe³so¹lxin³kxe³su² te²a² ãn³sa²so¹sxã³ ã³sa²ki³nũ²kxai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jã¹nxa¹jau³su², ĩ³yau¹ũ³jau³su² ĩ³ye³kxi¹nx2ta¹tu¹wi¹. Nxe³na¹te³nah¹lxi¹: “Ta³kon³ta³ki³yãu³su² ha̱u³ta³lun²sxã³ ãn³ki³i²nha³na¹ nxe³kxai²nãn²tu̱³ kwẽ³kon³ju³ta² ya̱u³son³te²jai¹ti²tu³wi¹. Nxe³ju³ta² kwẽ³kon³ju³ta² hau³kon³na³na¹ nxe³je³na³kxa² ta³kon³ta³ka³ta² ĩ³yau¹ũ³nẽ³lain¹te²jai¹ti²tu³wi¹.” ");
INSERT INTO nabNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jã¹nxe³kxe³hũ̱³nxe² ha³lo²ai²na² ã³wxã³na¹je³na³kxa² nxe²kxa²yã¹nxe² yũ³nũn³na³li¹. Ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Ju¹tai²na¹ e³kxi¹nx2ta¹ju³tin³ti² ko̱³nxe³khai¹nxe³ju³tin³ti² ĩ²yah³lxin¹kxai²nãn²tu̱³ ã³wxã³na¹ju³ta³nũ³a² a²kwẽn¹tai²na¹ yũ³tu¹wi¹. Wxa²sxih²yxo²a² ã³ya̱u³son³kxi²nx2ta¹kxa² yã¹nxe³hĩ̱³nx2na³li¹. Na¹jau³su² wã²nxũ̱h¹ wi¹ko̱³nha¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. Ju¹tai²na² ĩ²yah³lxin¹kxai²nãn²tu̱³ hĩ¹na² ka³te̱n³su² yxau²xai³tũ̱³ka̱³txa² ya³lu²ai¹nxa³ta̱³lxa¹ jau¹xai²na² a²yxo²ha³kxa¹ kãi³ta³lun²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Oh³nãu³nũ¹ai²na² hxa³ni² ha³lo²a² yuh³xai²na² hxa³ni² nxe³ain¹tu¹wi¹. Nxe³yãn¹ta¹ Txa²wãn³txa² so¹lxi³ ya²la³ti³ yxau²sa²tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nxe³yãn¹ta¹, nxe³ju³ta²nũ³ai²na² ĩ³ye³kxi¹nx2ta¹ju³ta²nũ³a² ũ³hũ¹nẽ³lain¹je³nãu³wa³kxa², a²nũ²a² yxo²ha³kxa¹ ko̱³nhai¹nxa³ha²kxai³ oh³xan¹ta²nũ̱³ka̱³txa² ko̱³nhain¹nũ³nxa³ha²kxai³, Txai²na¹xai²na² ko̱³nha²nũn³nxa³ha²kxai³, ya³sai¹nx3tho³li¹. Nxe³je³nãu³wa³kxa² Txa²wĩ³na² so¹lxi³ wi¹ko̱³nha²te²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nxe³ha²kxai³, ha³lo²a² nũ¹hĩ²jah¹lxi³hẽ¹la², wa̱³li²na¹je³nãu³wa³kxa² ko̱³yah³lxa̱³nha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ha³lo²ai²na² nxe³te²nũ³nhũ̱³na³li¹. In³txa² sxi²ha² a³li³sxã³ ĩ³ain¹nũ²nhai¹. Ĩ³ai¹nxa³hĩ¹na¹, a²sa³wi³ha³lxi³nãu³xa² yxo²ha³kxa¹ ka³na³ka³nat3sxã³ ha³na³ka³lxi³ kaix1so¹sxã³ a²wa³ka³li³yu³khai³xa² wxa²nũt3sxã³ ĩ³yau¹ũ³ai¹nha²kxai³ a²nũ²a² sxih²yxo²a² yxo²we¹jah¹la² wi¹lĩ²te³lhxã³ ĩ³ye³kxai¹nha²kxai³ nxe³sxã³ ĩ³ain¹nũ²nhai¹. Ha³lo²ai²na² nxe³te²hũ̱³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jã¹nxe³te²nũ³nhũ̱³yah³lxi¹lxi¹. Nxe³ha²kxai³ wi¹lĩ²jah¹lxi³hẽ¹li¹. Sxi²hai²na² a²wa³kxẽn³yah³lai¹ta³lxi²: “Ĩh¹nxe³hĩ¹na¹ ĩ³xain¹te³ji¹ku¹. Ko̱³nhain¹ki̱³sxa³nhai¹.” Nxe³te²nũ³nhũ̱³yah³lxi¹lxi¹. “Sũ²ni²khaix1tãu³a¹ ta̱³nxa², ka³nxah³ti² wi³te²lon³ta̱³nxa², ka³la³ka³la²a² ĩ³yai²lxi²tãu³a¹ ta̱³nxa², a³lan²tin³ti² ten³sa²tã³xi²tãu³a¹ ta̱³nxa² ĩ³xain¹te³ji¹ku¹. Ain¹ki̱³nhai¹.” Nxe³te²nũ³nhũ̱³yah³lxin¹nha²wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wxã³na¹je³nãu³wa³kxa² ko̱³nhyah³lxan³nha²wi¹. Nxe³ha²kxai³ wi¹lĩ²jah¹lxi³hẽ¹li¹. Kan²txi³ ãu³xi²yah³lxin¹kxa²yu³hxa², sxi²ha² wa³kxẽn³yah³lai¹tã² yãn¹ti³ ĩ³xi²ye²nx2tain¹kxa²ya̱n³ti³su², nxe³ye¹nxa²lxa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nxe³jau³xai²na² ĩ³ye³kxi¹nx2ta¹jau³xai²na² a²nũ²a² yxo²ha³kxa¹ ĩ³ye³kxai¹na¹wi¹. “Wi¹lĩ²jah¹lxi³hẽ¹li¹.” Nxe³ai¹na¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nxe³nxa²ha¹te¹ kxã³nhxĩ¹nai³kxai³ Ju³te²a² nũ̱³ka̱³txa² khãuh³lxa³ti³hin¹sxã³ yxau²xai³lai¹nhĩ¹nu¹tai²na² Txa²wã¹sũ̱³na² nũ̱³kxũn³txi³ ã³wa²su¹tain¹ta¹hxai²hẽ¹la². Nxe³hĩ¹nãn¹te²tu̱³ Ju³te²a² nũ̱³ka̱³txa² ha³lo²ai²na² ain³kxi²xi²nha²si¹hain¹jau³su² ãn³yã³nũ²kxain¹sxã³ yain³txi³nũ̱³xa² wa²lo¹lo¹nxa³tũ̱³xa² ĩ³wa¹kxi³la³ sa³wi¹hxa³tũ̱³xai²na² so¹lxi³ ĩ³yai³nain¹to³ta¹hxai²hẽ¹la². Yãn³tai²na² ã³yã³nũ²kxain¹je³nãu³wa̱³kxa² ya̱u³son³kxain¹ta¹hxai²hẽ¹la². Ye³ha¹li¹ a³la²ni¹xi²sxã³ ha³lo²a² hau³ko³nxa³ti̱³xa̱³lxa¹ sa²kxai³lu², wã³nxĩn¹te² si³yxau³ka³txa² nũ̱³ka̱³txa² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² whãi²na¹ a²hi²sen³su², ĩ³ne³wa³kon³nyhain¹ta¹hxai²hẽ¹la². Je³su²jah³la² hãi²i³sxã³ ũ³tĩ̱¹kxi²sxã³ su²lhã³te³lhxã³ ĩ³ne³wa³kon³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nxe³ju³ta² ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Wa²lo¹lo¹nxa³tũ̱³xa² ĩ³yain³ki̱³sĩ¹na¹ hau³hau³kot3sxã³ Je³su²jah³la² i³ya³sah¹lxi³txa³hẽ¹li¹. A²nũ²a² yxo²ha³kxa¹ ã³nhe¹kxi²nẽ³lain¹kxa²ya̱n³ti³su² ki̱³nhai¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nxe³nxa²ha¹te¹, in³txa² Si³mãu²ah³la² khon³ta³kxi²sxã³ ka̱³lã̱un³ta³kxi²jah¹la² sxi²yhe³na² Be³tãn²ya³thĩ³na² yxau³ain¹to³jah¹lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² a²sxi²nhãu³ã¹ Je³su²jah³la² ã³wxe³sxã³ ĩ³yain³yain¹ta¹hxai²hẽ¹la². A²nxe³tãu³a² ã³wxe³sxã³ ĩ³yai³nain¹tãu³a² txu¹ha³ka³lxa² ã³wxã³sxã³ tah³lxẽ¹na² wẽ³sa² a²ĩ³lxa² A³la³bas²tro³ẽ¹na², tẽ³sxã³ ã³wxã³ta¹hxai²hẽ¹la². A²nxe³tẽ³nai²na² hĩ³ne³kxa² ha³nẽ³jau³xa² wi¹lũ³khai¹nxe³jau³xa² a³lxi²khai¹nxe³jau³xa² a²ĩ³lxa² Nar²tu³yau³xa² wxe³ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹, txu¹ha³ka³lxai²na² sa²kxai³lu² tah³lxẽ¹nai²na² wxa²nãu²lxi³sxã³, wi¹lũ³jau³xai²na² sa²kxai³lu² Je³su²jah³la² ũ³nhe³kẽn¹kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nxe³ain¹ka³tu̱³ a²nũ²a² kwa² ĩ³yain³yain¹nũn³te²su² te²a² ĩ³xa̱n³ta³kxi²sxã³ a²ẽ¹nãu³a¹ ĩ³ye³kxi²nha²te³nah¹lxi¹: — A²nxe³jau³xai²na² a³lxi²khaix1jau³xai²la¹wi¹. Txu¹ha³ka³lxai²na² ĩh¹nxe³kxa²ya̱n³ti³ta̱³ kwa² hxa³kxi²nha²tã²nxãn³khi³. Nha¹nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nxe³jau³xai²na² ũ³yho³hi²ki̱³ke³la³te²kxai³ ũ³yho³hi²ki̱³txã³nxa² sa²kxai³lu², a²nũ²a² yen³kxi³txa²te²su² te²a² ũ³hũ¹ai¹nhĩ̱³ki̱³tã³na¹. Ta¹hxai²hẽ¹la². Ain¹sxã³ ĩ³kwa̱i²ta³lxi³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yxãn¹ta¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ a²nũ²a²nãu³xai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Ta¹ka³lxai²na² hãix1nã¹jah³lxi³hẽ¹li¹. Ĩ³kwa̱i²kxah¹lxi³txa³hẽ¹li¹. Kãi³ũ¹sain¹ju³tai²na² wi¹khaix1na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A²nũ²a² a²yen³kxi³txa²te²su² te²a² yxau²sa²tẽ³kxi²nyhah¹lxain¹te²ju²hẽ³li¹. Nxe³sxã³ ĩ²li³tãu³a² wi¹kãi³ũ¹hain¹yah³lxin¹ju³ta³nũ³a² yũ²na³li¹. Yxãn¹ta¹ Txai²na² yxau²sa²tẽ³nũ¹nx2ti³nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ta¹ka³lxai²na² a²yen³kxa² yũ³ain¹kxa² yxo²ha³kxa¹ wxa²hau³kot3sain¹ten¹tu³wi¹. Nxe³ju³ta² txa²nũ²ai²na² ka³te̱n³sa²na¹kxa² ha³ta̱³nxãn²txi³ hĩ³ne³ki³yau³xai²na² wi¹lũ³te²yau³xa² tẽ³sxã³ txa²nũ²ãin²txi³ ũ³nhe³kẽn¹ya³sai¹nhĩ¹na¹ ya³lu²na¹ju³ta³nũ³su² ãu¹la³kxi²sain¹na²li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. Sũ̱³na² wãn³txa² wi¹jau³xa² u²lxi³ ha³ta̱³nxe³tu¹wi¹. Yu̱h³xan¹ko³nãu³a² a²yxo²ha³kxa¹ ha³ta̱³nxe³tu¹wi¹. Nxe³tãu³a² txu¹hai²li² wi¹kãi³ũh¹sain¹ju³ta² te²yã¹nxe² u²lxi³ ha³ta̱³nxe³nu̱n³tu¹wi¹, sa²nẽn¹kxi²si¹jau³su¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nxe³nxa²ha¹te¹, yãn³tai²na² a²sa³wi³ha³lxa² ã³nhai¹tã³nũ³te²na² Ju³tas² Is³ka³ri³o²jah³lai²na² sa²kxai³lu² wã³nxĩn¹te² si³yxau³kxa³te²nãu³xa² ã³nxai³ta¹hxai²hẽ¹la². Nxe³te²na² hxi²ka² ãn³yã³yũ¹ain¹si¹hain¹jau³su² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nxe³jau³xai²na² ain³kxain¹ka³tu̱³ wã³nxĩn¹te² si³yxau³ka³txa² nũ̱³ka̱³txai²na² sa²kxai³lu² ĩ³ka³li³kxi²khaix1nyhai¹nha²kxai³ ũ³yho³hi²txã³nxa² ũ³hũ¹kxi³nũ³su² e³hau³ko³nye²nyhain¹ta¹hxai²hẽ¹la². Nxe³hĩ¹nãn¹te²tu̱³ Ju³tas² Is³ka³ri³o²jah³lai²na² hi²sen³kxai³lu² Je³su²jah³la² ã³yũ¹ain¹si¹jau³nũ³su² o²la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nxe³nxa²ha¹te¹ Ju³te²a² nũ̱³ka̱³txai²na² ãn³yã³nũ²kxain¹sxã³ yain³txa² wa²lo¹lo¹nxa³tũ̱³xai²na² ĩ³yai³nain¹nxa³je³na³ka² ye²ain¹ti³xa² o³ve²a² wẽ³sa² su²lain¹ti³wa³kwe³nxa² ãn³si³wxe³tãu³a¹ hau³ko³ni² Txa²wã¹sũ̱³na², kxã³nhxĩ¹nu¹tai²na² ã³wa²su¹tain¹ju³tu¹tai²na² ain³kxi²xain¹si¹hain¹jau³su² o³ve²a² wẽ³sa² ĩ³su²lhã³to³tãu³a¹ hau³kon³nũ³ni² ta¹hxai²hẽ¹la². Nxe³tãu³a¹ a²sa³wi³ha³lxi³nãu³xai²na² Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Yain³txa² wa²lo¹lo¹nxa³tũ̱³xa² ĩ³wa¹ki³la³ sa²wi¹hxa³tũ̱³xai²na² yain³ni² o³ve²a² wẽ³sa² ĩ³so¹jĩ² nxe³ki̱³kxi³ju³ta² ĩ¹nhũ¹ãn¹thĩn³ta̱³ yain³kxi²thĩ³nũ³a² sa²hau³kot3sĩn¹te³la¹ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ a²sa³wi³ha³lxa² a²ha¹lin¹ya³ti³xa² ĩ³sa²si¹hã³ain¹te²an¹jau³kxai³lu¹: — Sxi²je³na² ã³nxai³ja¹hẽ¹li¹. Ã³nxai³ya³hin¹kxai²nãn²tu̱³ in³txa² ĩ³ha¹txi¹nx2ti³tu¹wi¹. Nxe³jah¹la² ĩ̱³yau³xẽ¹na² ũ³whi¹so¹tẽ³na² sa²ka³la³ki²wxe³kxi²so¹nyhe¹nx2ti³tu¹wi¹. Nxe³jah¹la² ĩ³hi²txi¹jxa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ya³hin¹kxai²nãn²tu̱³ sxi²ha² a²wa³kxẽn³yah³la² ĩ³ye³kxi²txain¹ya³hẽ¹li¹: “Txa²wã¹yah³la² ĩ³ye³kxi¹nxa²si¹sa²sĩn¹jau³su² sa²si¹hã³sa²sĩn¹na²li¹. ‘Ĩh¹thĩn¹ta̱³ Txai²nãu¹xai²na² yain³txa² wa²lo¹lo¹nxa³tũ̱³xa² yai³na¹thĩ³nu³la³ sĩn¹te²la¹xã³?’ Nxe³sa²sĩ¹nhẽ²li¹.” Nxe³ja³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ya³hin¹kxai²nãn²tu̱³ oh³xan¹thĩ³na², kãin²thĩ³na² wi¹thĩ³na² wã²na³ũh¹nx2ti³tu¹wi¹. A²nxe³thĩ³nãu³ai²na² a²yen³kxa² yxo²ha³kxa¹ wi¹lhau³kot3sxã³ sxa³tu¹wi¹. A²nxe³thĩ³nai²na² yain³txa² we¹ja¹hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nxe³ka³tu̱³ a²sa³wi³ha³lxa² a²ha¹lin¹ya³ti³xa² sxi²je³na² ã³wi¹hain¹ka³tu̱³, ha³lo²a² ĩ²ain¹ta¹hxai²hẽ¹la². Je³su²jah³la² ĩ³ye³kxain¹kxu¹jã¹nxe³ju³ta² ĩ²ain¹ta¹hxai²hẽ¹la². Ain¹ju³ta² thĩ¹nai²na² yain³txa² wet1ja³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nxe³nxa²ha¹te¹ ka³nxa³hi²tãu³a¹, Je³su²jah³lai²na² sa²kxai³lu² a²sa³wi³ha³lxi³nãu³xa² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³tũ̱³ka̱³txa² whãi²na¹, ã³sa²so¹nũ²la² thĩ¹nai²na² ã³wi¹hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nxe³ain¹ka³tu̱³ ã³wxe³sxã³ ĩ³yai³nain¹ka³tu̱³ Je³su²jah³lo²su² te²kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. Ĩ³yain³kxi²sah¹lxin¹tũ̱³ka̱³txi³ ĩ̱³nxai²na² ka³na³ka³na³te²su² te² ĩ³nxa² ko¹ko¹xa² hxi²ka² ã³yũ³sa²yai¹nĩn¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nxe³ju³ta² a²sa³wi³ha³lxi³nãu³xai²na² kãin² ĩ³ãin²txi³khaix1ain¹ka³tu̱³ ã³si³wi¹wi¹sxã³ Je³su²jah³la² ĩ³wã̱³tain¹te³nah¹lxi¹: — Txai²la³ te³la¹ji¹? Txai²li² nxe²nx3tho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Wxãi²na² a²yain³txi³nũ̱³xai²na² so¹sxã³ a²yau³xai²na² ũ³hũ̱¹kxa² yain³kxi²sah²lxin¹ti²tu³wi¹. Wxa²yu³ta² hxi²ka²hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³tũ̱³ka̱³txe² ĩ³nxa² ka³na³ka³na³te²su² te² ĩ³nxa², ko¹ko¹xa² hxi²ka² ã³yũ³sa²yai¹nĩn¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ya²la³tu̱³ su²lhã³sain¹tu¹wi¹. Nxe³jau³xai²na² ũ³wha²li¹txã³nxu¹tai²na² nxe²ĩ³yau¹ũ³nẽ³ta¹hxai²hẽ¹li¹. Yxãn¹ta¹ ã³yũ³sain¹jah¹lai²na² sa²kxai³lu² ko̱³nxe³ti³hin¹khaix1jah¹lo²su² na³li¹. Hai³txi³ a³li³lah¹xa³sxã³ txo¹nxa³ke³la³te²kxai³ ã²la² wi¹lhĩ̱³nx2na³li¹, jah¹lo²su¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nxe³nxa²ha¹te¹ ĩ³yai³nain¹tãu³a² Je³su²jah³la² yain³txa³nũ̱³xai²na² wxa²sa²so¹sxã³ Txa²wã¹sũ̱³na² ĩ³wi¹lxon³kxi²si¹jau³xa² ĩ³ye³kxi²sãn²sxã³ wxa²nãu²lxi³sxã³ a²sa³wi³ha³lxa² ũ³hũ²xai³ain¹ka³tu̱³ ĩ³ye³kxain¹te³nah¹lxi¹: — Yain³tũ̱³xai²li² Txa²nũ²ai² yã¹nx2na³li¹. So¹kxi²sa²sxã³ yain³jah¹lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nxe³nũ²la² ĩ³na²ki̱³tẽ³na² hxi²tẽ³nha²nũ²la² Txa²wã¹sũ̱³na² wi¹lxo³kxi²jau³nũ³a², ĩ³ye³kxi²sãn²sxã³ ũ³hũ¹xai³ain¹ka³tu̱³ a²nũ̱³ka̱³txai²na² yxo²ha³kxa¹ ĩ³na²xai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nxe³ju³tai²na² sa²kxai³lu¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Jau¹xai²na² Txa²ti³ha²yxau³xa² yã¹nx2na³li¹. Wãn³txa² tah²yau³xa² ĩ³ye³kxi¹nx2ta¹jau³xai³ jã¹nxe² kãi³ũh¹nx2ta¹jau³nũ³ai²la¹wi¹. A²nũ²a² ko̱³nxe³ti³ kãi³ju³ta² ã³wa²sut1si¹ha¹jau³nũ³su² Txa²ti³ha²yau³xa² ha³li³hxan³sa³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nxe³yãn¹ta¹ nxe³kxa² yã¹nxa¹ju³ta² ĩ³na²kxi²jau³xa² wa³su³txi³ ĩ³na²xi²nxa³lho³li¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²hĩ¹na¹ ĩ³na²xi²ki̱³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nxe³nxa²ha¹te¹ ĩ³yain³ta³lu²nain¹ni² ĩ³na²ta³lu²nain¹ni² nxain¹ka³tu̱³ ka³li³nhẽ³jau³xa² ĩ³hai³nain¹sãn²ka³tu̱³, wã³la³ka³txa² O³li³ve²ra³kat3su¹ nxe³hxai²na²hẽ³ nxe³ka³ka¹txai²na² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nxe³te³na¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxu¹tai²na² wãn³txa² nxe³te³nah¹lxi¹: “O³ve²a² nũ̱³ka̱³txa² a²wa³kxẽn³yah³la² ĩ³su²lhã³a¹tu¹wi¹. Na¹ha²kxai³ o³ve²a² nũ̱³ka̱³txai²na² sa²kxai³lu² ã³ni³sxã³ ĩ³hax3te̱¹hax3te̱n¹tain¹tu¹wi¹.” Nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³jau³kxa² yã¹nxe³kxe³hũ̱³nxe² wxa²nũ̱³ka̱³txai²na² hãi¹nxe³ti̱³xa² ĩ³yãu²lxi²syah¹lxin¹tu¹wi¹, Txai²na²su¹. Nxe³sxã³ ã³waix3sxã³ ã³nih³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yxãn¹ta¹ hã²wxãn³txa³ ka³te̱n³su² ĩ³sa²yxau³xi²na¹ka³tu̱³, Ka³li³le²a²ko³xa²nãu³a¹ ã³ne³ka²ta¹nx2ta¹tu¹wi¹. Je³su²jah³la³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nxe³nxa²ha¹te¹ Pe²jah³la² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Kwa²nxi¹lxi¹. Ãu²li¹nxa²sxã³ ã³nih²nxã²nxa³lho³li¹. A²nũ²a² ã̱³xa² ãu²li¹hxan³txain¹kxan²ti³nũ¹ txai²li² ti³he¹nxẽ²nxa²hxa³lho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — A²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. Ka³nxah³tai²nãn²tu̱³ ka³la³ka³la²su² ye³ha¹li¹ ĩ³yai²lxi²nxa³ta̱³lxa¹ wxãi²na² sa²kxai³lu² Pe²jah³lo² ĩ̱³nxai²na² sa²kxai³lu² ten³si¹sa²nxãn³jau³nũ³su² ye³ha¹li¹ ka³na³ki¹ ĩ³ye³kxi²xin¹tu¹wi¹. “Je³su²jah³lai²na² ĩ²te²txã³wi¹.” Nxẽn¹jau³xai²na², ye³ha¹li¹ ka³na³ki¹ ĩ³ye³kxi²xin¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yxãn¹ta¹ Pe²jah³lai²na² yxo²xũ̱n³txi³ ĩ³ye³kxi²te³nah¹lxi¹: — Kox1ko¹su² ĩ³su²lhã³sain¹kxa² ha³ta̱³nxãn²txi³ hai³txi³ ten³nxa²hxa³jau³nũ³su² ĩ³ye³ti³he¹nxe²nxa³lho³li¹. Pe²jah³la² ta¹hxai²hẽ¹la². Te²yã¹nxe³sxã³ a²sa³wi³ha³lxa² hãi¹nxe³ti̱³xa¹ ĩ³ye³kxu¹jã¹xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²sa³wi³ha³lxa² whãi²na¹, ha³lo²a² Jet3se³ma³ni²ko³xa² ã³nxai³ain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — Ti¹na² ha³lo³kxa² ã³wxe³jah³lxi³sã²nhẽ³li¹. Txai²na² Txa²wã¹sũ̱³na² ĩ³ye³kxi²na¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nxe³sxã³ Pe²jah³la², Ti³a²kah³la², Jo³ãu²ah³la² ã³sa²so¹sxã³ ã³nxai³ain¹ka³tu̱³ Je³su²jah³lai²na² kãin² hxi²waun³ta³kxi²nha²sxã³ ãin²ta³kxi²nha²khaix1ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nxe³te³nah¹lxi¹: — Ãin²ti³ya³lu²te²hũ̱³sa³nhai¹. Ti¹na² ã³wxe²yxau³sxã³ wah³nxe³sah¹lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nxe² e³kxi²nũ²la² jũ¹nxe² yan¹nãu³a² ã³nxai³sxã³ kĩ̱h³nũ̱³xa² ãn³yxo²thu²kxa¹sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Ha³lo²a² a²ko̱³nxe³ju³ta² ã³nxẽ̱³txi³nha²te³lhxã³ nxe³ju³ta² ã³wxe³sa²si¹ha¹jau³su² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nxe³te³nah¹lxi¹: — Txa²wĩ³nãi³. A²yen³kxa² hãi¹nxe³ti̱³xa¹ hxi²kan¹te²si¹lxi¹. Nxe³ha²kxai³lu¹ a²ko̱³nxe³ju³tai²na² khãuh³lxa³ti³sa²ju³tai²na² sa²wa³to²kxi²sa²hẽ³li¹. Yxãn¹ta¹ ten³nxa²nxa³kxai²nãn²tu̱³ wxa²wãn³txa² so¹lxi³ we¹ti³ten³sa³nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nxe²e³ta³lun²nũ²la² ã³wa̱³li²ka³tu̱³ a²sa³wi³ha³lxi³nãu³xa² ãu³xi²yain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² sa²kxai³lu² Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Si³mãu²ah³lãi³. Ãu³xi¹lxi¹. Jũ¹nxe²ju³ta² he³la³ku³ hxi²kan¹ti³ ĩ³ye³ten³nha²sxã³ yxau²xai³lxan³ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ye³ten³sxã³ yxau³jah¹lxi³sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹, ko̱³nxe³ju³ta³la³ ã³wih²kxi¹nxa²ti³kxa²ya̱n³ti³su¹. Wxa²ẽ¹nãu³a² a²wi¹ju³ta³la³ ten³khaix1yah³lxi¹lxi¹. Yxãn¹ta¹ wxa²sxĩ̱³nai²na² sĩ̱³wi¹lhin¹ju³ta² hau³ko³nxa²lxa³lxi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ĩ³ye³kxã¹ain¹ka³tu̱³ ã³nxai³ka³tu̱³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²jau³xai³jau¹xain²txi³ ãh¹ ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nxe² e³ta³lun²nũ²la² a²sa³wi³ha³lxa² ã³wa̱³li²xi²ta¹hxai²hẽ¹la². Yxãn¹ta¹ ãu³xain¹to³ta¹hxai²hẽ¹la², hxi²kan¹sxã³ ye³ten³sxã³ yxau³ai¹nxa³ha²kxai³la². Nxe³ha²kxai³la¹ ĩ³ye³wã³nã³wã³nãn³tai¹nha²kxai³ hxi²kan¹ti³ Je³su²jah³la² ĩ³wa²lũ³xin²tain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nxe³sxã³ Je³su²jah³la² ãh¹ ã³nxai³ka³tu̱³ ã³wa̱³li² ãh¹ ã³ta³lo³hẽ²ti²to³ka³tu̱³ a²sa³wi³ha³lxi³nãu³xai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Ãu³xi²sxã³ ĩ³ye¹nxĩ²sa²tẽ³ye²yah³lxin¹ta²lu¹wi¹. Hãi¹nxo¹nha¹jah³lxi³sã²nhẽ³li¹. Ha³lo²a² hau³kon³na³li¹. Hĩ¹nai²na² ko̱³nxe³thin¹te² hxi²ka²nãu³a² ã³yũ³sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ĩ³sa²yxau³sxã³ ã³nxai³ya³sah¹lxi³wxi¹. A²nũ²a² ã³yã³yũ³sa²jah¹lo²su² te²a² ya̱u³son³nẽ³na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nxe³nxa²ha¹te¹ ĩ³ye³ta³lu²nxa³ta̱³lxa¹ a²sa³wi³ha³lxa² a²hãi¹nxũ³jah¹la² ka³na³ka³na³te²a² Ju³ta²sah³lo²kxai³lu² ã³tĩ̱³ta¹hxai²hẽ¹la². A²nũ²a² ka³lxa¹tũ̱³ka̱³txa² yu̱³la² kãin²te²a² tẽ³i², hi³ki²a³la² tẽ³i² nxain¹tũ̱³ka̱³txa² ãn³si³tẽ³kxa² ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² sa²kxai³lu², wã³nxĩn¹te² si³yxau³ka³ta³nãu³xa², ha³te̱h³nxã³nxa² a²hoh³lxi³sa²nãu³xã² a²nũ²a² hxi²kan¹te²nãu³xa² ĩ³sa²si¹hã³ain¹tũ̱³ka̱³txi³la³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jã¹nxe³ju³kxai³lu² a²kxã³nxai³tã² ã³yũ³so¹jah¹la² ĩ³ye³kxi²nyhain¹ta¹hxai²hẽ¹la². Nyhain¹te³nah¹lxi¹: — Nxe³jah³lxi³hẽ¹li¹. In³txa² ĩ³yxo²sai¹la³kxi²na¹tu¹wi¹. Nxe³na¹kxe³su² nẽ²na³na¹, kan²txi³ i³sxã³ sa²so¹sxã³ tẽ³jah¹lxi³hẽ¹li¹. Ju³ta²sah³la² a²kxã³nxai³tã² nxẽn³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nxe³nxa²ha¹te¹ Ju³ta²sah³lai²na² sa²kxai³lu² Je³su²jah³la² ã³tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Nxe³ta¹hxai²hẽ¹la². Nxe³nũ²la² ĩ³yxo²sai¹la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nxe² e³ta³lun²nũ²la² a²nũ²a² ko̱¹ko̱¹xa²nũ̱³ka̱³txai²na² ã³tĩ̱³sxã³ i³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yxãn¹ta¹ a²nũ²a² kwa² yxau³nũn³te²su² te²a² yu̱³la² kãin²te²a² hxi²so¹nha²sxã³, wã³nxĩn¹te² si³yxau³ka³txa² a²sa³wi³sa² ĩ³su²lhxã³ ĩ³ne³nxẽ³ni²lã³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ a²nũ²a² kãi²lxi³tũ̱³ka̱³txai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Hi³sa³ka³txa² hi³ki²a³la² tẽ³sxã³ wxã³yah³lxin¹ti²ti¹. A²nũ²ai²na² yen³kxa² kãi³jah¹la² i³sxã³ sa²so¹kxa² yã¹nxe² i³sxã³ sa²so¹sah¹lxin¹ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A³lan²ta² hãi¹nxe² Sũ̱³na² sxi²ha² ã³wxe³na¹sxã³ wãn³txa² wi¹jau³xa² ĩ³yau¹ũ¹nx2ti³ta¹tai¹ti²tu³wi¹. Nxe³na¹tãu³ai³tã² i³sxã³ sa²so¹sah¹lxan³nxa³tai¹ti²ti¹. Yxãn¹ta¹ Sũ̱³na² ũ³wha²li¹txã³nxu¹tai²na² we¹ta³lun²si¹jau³su² kãi³ũ¹sah³lxi¹lxi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ain¹ka³tu̱³ a²sa³wi³ha³lxi³nãu³xai²na² a²hãi¹nxe³ti³xa² ã³waix3sxã³ ih³sau³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yxãn¹ta¹ sa³nxe³la³kxa² ka³na³ka³na³te²su² te²a² wã²la²ka³lo³a² yxãi¹nxã²nxa³ka³lo³a² ã³wi²kxi²nha²te²su² te²a² ã³si³tẽ³kxain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ ka³lxa¹tũ̱³ka̱³txai²na² sa²kxai³lu² ĩ³ye²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ĩ³ye²nyhain¹ka³tu̱³ta¹ sa³nxe³la³kxah³lai²na² sa²kxai³lu² wã²la²ka³lo³ai²na² ã³na¹sxã³ a²nũ²so¹lxi³ ã³nih³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nxe³nxa²ha¹te¹, wã³nxĩn¹te² si³yxau³ka̱³ta³nãu³xa² a²nũ²a² a²hxi²kan¹te²nãu³xa² ha³te̱h³nxã³nxa² a²hoh³lxi³si²nãu³xa² whãi²na¹, ãn³yã³sa²ki³nũ²kxain¹ta¹hxai²hẽ¹la². Nxe³ain¹ka³tu̱³ Ju³ta²sah³lai²na² nũ̱³ka̱³txai²na² a²hi²sen³kxai³lu² Je³su²jah³la² tẽ³sxã³ wã³nxĩn¹te² si³yxau³khaix3ka̱² hxi²ka² ã³yũ³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nxe³yãn¹ta¹ Pe²jah³la² a²ha¹ u²la¹ ĩ³hit1xai³ta¹hxai²hẽ¹la². Ai³lhxã³ wã³nxĩn¹te² si³yxau³ka³txa² a²sxi²ha² wai²ha² yxo²tã̱³lxa² ã³wih¹ka³tu̱³ so³ta²to² nũ̱³ka̱³txa²kxai³ ã³wxe³ye²ta¹hxai²hẽ¹la². Nxe³sxã³ ha³nxe²a² ã³yxo²wxe³kxi²sxã³ hxi²kẽ³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nxe³ti̱³kxai³lu² wã³nxĩn¹ta² hxi²kan¹te²nãu³xai²na² sa²kxai³lu² hxi²kan¹ta² ã³nũ²kxi²tũ̱³ka̱³txa² sa²kxai³lu² a̱in³nha²ti³te³nain¹ta¹hxai²hẽ¹la². Je³su²jah³lai²na² ĩ³su²lhã³ain¹si¹hain¹jau³su² a̱in³nha²ti³te³nain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹, hxi²kan¹ti³ a̱in³nha²ti³he¹nxain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nxe³ju³ta² a²nũ²a² ka³lxa¹te²hi²sen³su² wãn³txa² ki³han³jau³xa² Je³su²jah³la² ĩ³ye³ki³ha¹kxain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ hai³txi³ wãn³txa² ĩ³ye³ain¹jau³xai²na² ĩ³we¹nyhain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jã¹nxe³ju³tai²na² a²nũ²a² ka³na³ku² te²a² ĩ³sa²yxau³ain¹ka³tu̱³ ĩ³ye³ki³ha¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ĩ³ye³ki³ha¹kxain¹te³nah¹lxi¹: — Je³su²jah³lai²na² a²wãn³txa² ain³kxi²sĩ¹na¹hẽ³li¹. Nxe³jau³xa²sa¹: “Txa²wã¹sũ̱³na² sxi²hai²na², a²nũ²a² hxi²ka² to³nain³thĩ³nai²na² sa²nai¹a¹tu¹wi¹. Na¹kxai²nãn²tu̱³ ye³ha¹li¹ ka³na³ki¹ a³la²ni²sxã³ sxi²ha² ã̱³lxi³thĩ³na² txa²hĩ³na² sa²ton³ta³lu²na¹tu¹wi¹. A²nũ²a² hxi²ka² sa²to³nai¹nxa³thĩ³na², Txai²li² sa²to³na¹tu¹wi¹.” Nxe³na²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nain¹ta¹ hai³txi³ we¹nyhain¹jau³la³ yũ³ti³hex1ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nxe³nxa²ha¹te¹ wã³nxĩn¹te²nãu³xa² a²hxi²kan¹jah¹lai²na² sa²kxai³lu² a²nũ²a² nũ̱³ka̱³txai²na² nxũ²kwa̱i³ye³ye³lo³tãu³a¹ ĩ³sa²yxau³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Jau³jau¹xai²na² ĩ³wa²lũ³xi¹nxãn³ji¹wi¹? Ĩh¹nxe³jau³ta̱³ ko̱³te³kxi²nxain¹thi²li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yxãn¹ta¹ Je³su²jah³lai²na² sa²kxai³lu² ka³nahx2nxe³sxã³ yxau³ta¹hxai²hẽ¹la². Nxe³te³na¹ wã³nxĩn¹te²nãu³xa² a²hxi²kan¹jah¹lo²kxai³lu¹ ãh¹ ĩ³wã̱³txi³te³nah¹lxi¹: — Wxãi²na² Txa²wã¹sũ̱³na² Tah²sin¹ji¹wi¹? Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²jah¹lo²sin¹ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³te²sa¹wi¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² Si³yxau³kah³lai²na² a²wi¹nẽ³tãu³a² wxi²kin³ti³ton³ti³hit1sain¹sxã³ ã³wxe³na¹ha²kxai³ oh³sĩ̱³nãu³a² wxa²kan³sxã³ wa̱³li²na¹ha²kxai³ nxe³na¹ju³ta² ĩ²sah²lxin¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nxe³nxa²ha¹te¹ wã³nxĩn¹te²nãu³xa² a²hxi²kan¹jah¹lo²kxai³lu¹ ain³kxi²te³na¹ a²ha³la³se³nãn¹ka³lo³khai³xa² wxa²ten²txi³ta¹hxai²hẽ¹la². Wxa²ten²txi³te³nah¹lxi¹: — Hãi¹nxã¹a³sah¹lxi³wxi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wãn³txai²li² Txa²wã¹sũ̱³na² ko̱³nxe³te²lo³jau³xai²na² ain³kxi²ki̱³ti²tu³wi¹. Nxe³ki̱³sa²kxai³ ĩh¹nxe³ki̱³te³ji¹wi¹? Nxe³yhain¹ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ a²nũ²a² ã³ki³nũ²kxi²tũ̱³ka̱³txai²na² a²hãi¹nxe³ti³xa¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Su²lhã³ain¹ju³ta² so¹lxi³ wain³na³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ain¹ka³tu̱³ a²nũ²a² ĩ²li³te²a² hi²sen³su² Je³su²jah³la² ĩ³ye³ka³su³hẽn¹kxi²ha²kxai³ a²nũ²a² ã̱h¹ ĩ²li³nũn³te² hi²sen³su² Je³su²jah³la² ũ³yhe³tĩ̱¹sãn²sxã³ ĩ³wait1sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹nxe³te²ta̱³ ĩ³wai¹txain¹sĩn¹ji¹wi¹? Ĩ³ye³kxi²sa²sĩ¹nhẽ³li¹. Nxe³ain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² so³ta²to² nũ̱³ka̱³txa² wxa²wai¹tain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nxe³ain¹ti̱³kxai³lu² Pe²jah³lai²na² sa²kxai³lu¹ sxi²ha² wai²ha² yxo²tã̱³lxa² ã³wih¹sxã³ ã³yxo²wxe³ta¹hxai²hẽ¹la². Nxe³tãu³ãn²tu̱³ta¹ wã³nxĩn¹jah¹la² a²sa³wi³sxa² wãin²ta¹ka³lxu³na² wxã³ka³tu̱³ Pe²jah³lai²na² hxi²kẽ³li³ju³ta² ĩ²ka³tu̱³ ĩ³ye³kxi²te³nah¹lxi¹: ");
INSERT INTO nabNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","— Wxãi²na² Je³su²jah³la² Na³sa³re²thĩ³na² yxau³jah¹la² ãn³si³tẽ³kxain¹nũn³to³hin¹tai¹ti²ti¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yxãn¹ta¹ Pe²jah³lai²na² a²wãn³txi³kxai³lu¹ ĩ³ki³ha¹kxi²jau³su² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Jah¹lai²li² ĩ²te²txã³xĩ¹. Wxa²wãn³txai²na² ãn³ne³wxe³ti³hex1sa²nxãn³nhi¹. Ta¹hxai²hẽ¹la². Nxe³sxã³, sxih²yxo²a² a³li³xi²ta¹hxai²hẽ¹la². A³li³xi²hĩ¹na¹ ka³la³ka³la²a² ĩ³yxai²lxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nxe³ka³tu̱³ wãin²ta¹ka³lxai²na² sa²kxai³lu² Pe²jah³lai²na² ĩ²xi²tãu³ a²nũ²a² kwa² yxau²xai³lain¹te²a² ĩ³ye³kxa² ã³si³wxe³te³nah¹lxi¹: — Jah¹lai²na² Je³su²jah³la² a²sa³wi³sxai²la¹wi¹. Wãin²ta¹ka³lxai²na² a²wãn³txa² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Jã¹nxa²ha¹te¹ ĩ³ki³ha¹kxi²jau³su² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ti³he¹nx2nxa³xĩ¹. Pe²jah³la² nxe³ta¹hxai²hẽ¹la². Nxe³ai¹nha²kxai³ a²ha¹ kwẽn¹tai²na² a²nũ²a² kwa² yxau²xai³te²a² a²wãn³txi³kxai³lu¹ Pe²jah³lai²na² ĩ³ye³kxi²te³nah¹lxi¹: — Ka³li³le²a²ko³nãu³a¹ yxau³sxã³ to̱n¹khaix3nĩn¹ko³lxã²na³li¹. Nĩ¹nha²kxai³ Je³su²jah³la² nũ̱³ka̱³txa² ka³na³ka³na³te²si¹lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yxãn¹ta¹ Pe²jah³lai²na² sa²kxai³lu² yxo²a̱n³ta³ti³ ĩ³ye³kxi²te²an¹jau³kxai³lu¹: — Jah¹la² ĩ³ye³kxah²lxin¹kxah³lai²na² ĩ²ti³hex1te²txã³i¹. Txa²wãn³txai²na² e³a¹jau³xai²na² Txa²wã¹sũ̱³na² wi¹lain³kxi²sain¹na³li¹. Ki³ha¹kxi¹nx2ta¹ke³la³te²kxai³ a̱n³txi³ju³ta² ũ³hũ¹sai¹nhĩ̱³nx2na³li¹. Pe²jah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nxe³ain¹tãu³ kwẽn¹ta²kxai³ ka³la³ka³lan¹ti² ye³ãn³ta³lo³hẽ²ti²sxã³ ĩ³yxai²lxi²ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Pe²jah³lai²na² sa²kxai³lu² Je³su²jah³la² wãn³txa² ain³kxi²xi²ta¹hxai²hẽ¹la². Nxe³jau³xai²na²: — Ka³la³ka³la²a² ye³ãn³ta³lo³hẽ²ti² ĩ³yxai²lxi²ta³lu²nxa³ta̱³lxa¹ wxãi²na² sa²kxai³lu² ye³ha¹li¹ ka³na³ki¹ ten³si¹sa²nxãn³jau³nũ³su² ĩ³ye³ta³lu²nĩn¹tu¹wi¹. Ha³la³je¹nai³tã² Je³su²jah³la² wãn³txa² ta¹hxai²hẽ¹la². Nxe³jau³xai²na² Pe²jah³lai²na² ain³kxi²xi²ka³tu̱³ kãin² ĩ³ãin²ta³kxi²sxã³ ĩ³nã̱n³khaix1ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nxe³nxa²ha¹te¹ a²ka³nxa³ha²ta³kxai³lu¹ ã¹ka³nxa³ha²ta³a¹, wã³nxĩn¹ta² si³yxau³ka̱³ta²nãu³xa² ĩ³kaix1ti², a²nũ²a² a²hxi²kan¹ta² nũ̱³ka̱³txa² ĩ³kaix1ti² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² ĩ³kaix1ti², a²nũ²a²nãu³xa² a²hxi²kan¹ti³nãu³xa² ĩ³kaix1ti² ain¹sxã³ ã³sa²ki³nũ²kxain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txa² hi²sen³kxai³lu² Je³su²jah³la² ĩ³su²lhã³si¹hain¹jau³su² a̱in³nha²te³lhxã³ nxain¹ta¹hxai²hẽ¹la². A̱in³nha²ta³lu²nain¹ka³tu̱³ Je³su²jah³la² sa²tai³kxi²sxã³ sa²so¹sxã³ ha³lo²a² a²hxi²kan¹ta² si³yxau³jah¹la² Pi³la²jah³la² a²hxi²ka²nãu³a² ã³yũ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nxe³nxa²ha¹te¹ Pi³la²jah³lai²na² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ĩ³wã̱³txi³te³nah¹lxi¹: — Wxãi²na² Ju³te²a² nũ̱³ka̱³txai²na² a²si³yxau³jah¹lo²sin¹ji¹wi¹? Nxe³ta¹hxai²hẽ¹la². Yxãn¹ta¹: — Wxa²wãn³txai²na² wain³na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nxe³ka³tu̱³ wã³nxĩn¹ta² si³yxau³ka³te²nãu³xa² Je³su²jah³la² ko̱³nxe³ti³hit1si¹jau³su² kãin² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nxe³nxa²ha¹te¹ Pi³la²jah³lai²na² a²wãn³txi³kxai³lu¹ Je³su²jah³la² ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ã³ka³nah²nxe³sxã³ yxaun¹ji¹wi¹? Tũ̱¹ka̱³txai²na² ko̱³nxe³ti³hi¹txa²si¹hain¹ju³ta³la³ ĩ³tih³nxe³sa²ye²nxain¹jau³xa² ain³kxi²nhãn¹ta¹nxe³ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yxãn¹ta¹ Je³su²jah³la² ã³ka³nah²nxe³sxã³ yxau³yain¹ta¹hxai²hẽ¹la². Nxe³ju³kxai³lu² Pi³la²jah³lo²kxai³lu² kãin² ĩ³wã̱³ta³kxi²nha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nxa²ha¹te¹ yain³tũ̱³xa² wa²lo¹lo¹nxa³tũ̱³xa² yai³nain¹je³na³kxa² nxe³xai³ti³wa³kxa² ha³lo²a² wa³kxẽn³yah³la² te²hi²sen³su² nxe² kãi³ũ¹hain¹ta¹hxai²hẽ¹la². A²nũ²ai²na² sxi²ha² kan²thĩ³na² ũ³tĩ̱¹kxi²sxa³te²na² ĩ²li³te²na² ka³na³ka³na³kan²tu̱³ than²kxi²sa²tã³sxã³ sa²nũ¹xi²nyhain¹to³ta¹hxai²hẽ¹la². Ju³te²a² nũ̱³ka̱³txai²na² te³nain¹kxah³lo²su² jah¹la² than²kxa² sa²nũ¹xi²nyhain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nxe³ju³ta² sa²kxai³lu² in³jah³la² ko̱³nxe³thin¹jah¹la² Ba³ra³ba²sah³la² tĩ̱³kxi²sxa³ta¹hxai²hẽ¹la². A²nxe³jah¹la² nũ̱³ka̱³txa² a²hi²sen³kxai³lu² ha³la³je¹nhĩn¹kxai³lu² a²hxi²kan¹ti³nãu³xa² ã³nhe¹kxi²nyhain¹sxã³ a²nũ²a² su²lhã³ain¹ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² tĩ̱¹kxi²sxa³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","10","Nxe³nxa²ha¹te¹ Ju³te²a² nũ̱³ka̱³txai²na² ka³lxa¹tũ̱³ka̱³txai²na² ya̱u³so³nain¹ka³tu̱³ yxo²xũ̱n³txi³ Pi³la²jah³la² ĩ³wã̱³txi³sain³te³nah¹lxi¹: — A²nũ²a² ka³na³ka³na³te²su² than²kxa² sa²nũ¹xi²sa²to³nhĩn¹tai¹ti²ti¹. Kwẽn¹tai²na² jã¹nxe³sa²sĩ¹nhẽ³li¹. Nxe³ta¹hxai²hẽ¹la². Yxãn¹ta¹ Pi³la²jah³lai²na² sa²kxai³lu² wã³nxĩn¹ta² si³yxau³ka̱³ta³nãu³xa² a²ẽ¹nãn¹jau³la³ a³la³kxain¹ta¹hxai²hẽ¹la². Kãin² ĩ³ka³tã³nai¹nha²kxai³ Je³su²jah³la² ãn³yũ³ain¹ju³ta²kxai³ a³la³kxain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ju³te²a² nũ̱³ka̱³txa² a²si³yxau³jah¹la² than²kxa² sa²nũ¹xi¹nx2ta¹tu¹wi¹. Ju¹tai²na² ten³nxa²li³xa³ji¹wi¹? Pi³la²jah³la² a²wãn³txa² nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yxãn¹ta¹ wã³nxĩn¹ta² si³yxau³ka̱³ta³nãu³xai²na² a²hi²sen³kxai³lu² a²nũ²a² kãin²tũ̱³ka̱³txai²na² ĩ³ye³kxain¹te³nah¹lxi¹: — Ba³ra³ba²sah³la² so¹lxi³ than²kxi²sa²tã³sxã³ ũ³hũ¹xi²nẽ³lhi¹hain¹jau³su² ĩ³wã̱³txi³sain³txain¹yah³lxi³sĩ¹nhẽ³li¹. Yah³lxi¹nha²kxai³ Je³su²jah³la² ten³ki̱³sxa³jau³su² ĩ³ye³kxi¹txain¹yah³lxi³sĩ¹nhẽ³li¹. Nyhain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Ba³ra³ba²sah³la² so¹lxi³ te³nain¹si¹hain¹jau³su² a²nũ²a² kãi³li³tũ̱³ka̱³txai²na² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nxe³nxa²ha¹te¹ Pi³la²jah³la² ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Ba³ra³ba²sah³la² ten³yah³lxi¹lxi¹. Yxãn¹ta¹ jah¹lai²na² Ju³te²a² nũ̱³ka̱³txa² a²si³yxau³jah¹la² ĩ³yĩ¹li²yah³lxi³to³hin¹jah¹la² ĩh¹nxet3sxã³ kãi³kxi²te³la¹ji¹wi¹? Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nxe³nxa²ha¹te¹ a²nũ²a² kãi³li³tũ̱³ka̱³txai²na² kãin² ĩ³wxa¹nain¹te³nah¹lxi¹: — Hi³sa³ka³txa² ĩ³hxi²kĩ¹la³kxi²sxã³ ĩ³ya²lu¹tain¹sĩ¹nhẽ³li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nxe³nxa²ha¹te¹ Pi³la²jah³lai²na² a²wãn³txi³kxai³lu¹: — Ĩh¹nxe² ko̱³nxe³thin¹sxã³ kãi³hĩ̱³thai¹li¹? Nxe³ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²nũ²a² yxo²ha³kxa¹ kãin² ĩ³kaix1tain¹te³nah¹lxi¹: — Hi³sa³ka³txa² ĩ³hxi²kĩ¹la³kxi²sxã³ ĩ³ya²lu¹tain¹sĩ¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nxe³ha²kxai³ Pi³la²jah³lai²na² a²hi²sen³kxai³lu² a²nũ²a² kãi²li³tũ̱³ka̱³txai²na² ĩ³wi¹lxon³kxain¹si¹hain¹jau³su² Ba³ra³ba²sah³lai²na² than²kxi²sa²tã³si¹sxã³ ũ³hũ¹xain¹ta¹hxai²hẽ¹la². Te²yã¹nxe³sxã³ Je³su²jah³lai²na² sa²kxai³lu² ũn³txi³ ĩ³ta³lo³wait1si¹hain¹ka³tu̱³ hi³sa³ka³txa² ũ³hxi²kĩ¹la³kxi²si¹hain¹jau³su² ã³yũ³yhai¹nha²kxai³ Pi³la²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nxe³nxa²ha¹te¹ so³ta²to² nũ̱³ka̱³txa² hi²sen³su² Je³su²jah³la² so¹ka³tu̱³ a²hxi²kan¹ta² si³yxau³jah¹la² sxi²ha² kãin²thĩ³na² Prai³a³to³ri³ã²thĩ³nãn²tu̱³ ã³wi¹hain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ so³ta²to² nũ̱³ka̱³txai²na² yxo²ha³kxa¹ ã³nũ²kxi²si¹hain¹jau³su² ĩ³kaix1tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nxe³te³na¹ so³ta²to² nũ̱³ka̱³txai²na² sa²kxai³lu¹ wã²la²ka³lo³a² sau³saun³ka³lo³a² tẽ³sxã³ Je³su²jah³lai²na² ũ³whi²kxai¹nha²kxai³ wa̱i³la² wxa²xu³kxain¹sxã³ ũ³nhe³hẽn¹tai¹nha²kxai³ nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ain¹ka³tu̱³ ĩ³sa²nẽn¹kxi²ki³lxot3sxã³ ĩ³ki³wai³ka³si³xain¹te³nah¹lxi¹: — Wi¹lhin¹te²si¹lxi¹. Ju³te²a² nũ̱³ka̱³txa² A²hxi²kan¹ta² Si³yxau³jah¹lo²si¹lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","20","Ain¹sxã³, hi³sa³ka³txa² wẽ³sa² hxi²so¹xi²sxã³ Je³su²jah³la² ĩ³ne³su²lai¹nha²kxai³ ĩ³ye³ka³su³hẽn¹kxai¹nha²kxai³ ã³ka³ti³wxe³kxain¹sxã³ wi¹lhin¹ki³lxo³jau³xa² ĩ³ye³ki³ha¹kxain¹sxã³ ko̱³nxe³ti³ ĩ³yxo²kwa³lxi³nyhain¹ta¹hxai²hẽ¹la². Nxain¹te²ka³ka¹ wã²la² sau³saun³ka³lo³ai²na² sa²sai¹kxain¹sxã³, Je³su²jah³la² a²wã²la³ka³lo³khai³xa² ũ³whi²kxi²xain¹ta¹hxai²hẽ¹la². Hã²wxãn³txa³ ĩ³hxi²kĩ¹la³kxi²si¹hain¹jau³su² sa²so¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nxe³nxa²ha¹te¹ Si³mãu²ah³la² Si³rẽ²ne²ko³xa² to̱n¹jah¹lo²su² ta¹hxai²hẽ¹la². A³le³syãn²trah³la² Ru²fu²jah³la² a²wĩ³nu²su² ta¹hxai²hẽ¹la². A²nxe³jah¹lo²su² te²kxai³lu² a²kxã³nxa¹ ha³lo²a² wa²li³sxã³ wxã³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ so³ta²to² nũ̱³ka̱³txai²na² sa²kxai³lu² hi³sa³ka³txa² Je³su²jah³la² ĩ³hxi²kĩ¹la³kxi²ka³txa³nũ³a² sa²tã³ka³la³kxi²hẽt1so¹nha²si¹jau³su² Si³mãu²ah³lan²tu̱³ yxo²xũ̱n³txi³ ĩ³kwa³na³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nxe³ka³tu̱³ ã³nxai³ain¹ka³tu̱³ wã³la³ka³txa² Ko²ko³ta³ka̱t3su² nxe³jau³xa² a²si³yxau³tãu³a² sa²kxai³lu² txa²wã¹ne³ka³lo³su² nxe³hxai²na²hẽ³ ka³txa²nãu³a² sa²so¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nxe³hĩ¹na¹ vĩn²yo³jau³xa² hĩ³ne³kxa² mi²ra³jau³xa² ĩh³nẽ³ju³ta² ã³wxe³lu¹nhẽ³jau³xa² nxe² ũ³ke³ni²jau³xa² ũ³hũ¹ain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ Je³su²jah³la² ĩ³nxũn³sain³nũ²la² ĩ³na²ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nxe³nũ²la² hi³sa³ka³txa² ĩ³hxi²kĩ¹la³kxain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Je³su²jah³la² wã²la²ka³lo³a² wxa²sa²so¹te²txai³ain¹sxã³ tah³lxa² wẽ³sa² o²la³kxain¹sxã³ a²wa³kxẽn³ton³yah³la² nũ̱¹ha̱in³nyhain¹ka³tu̱³ wã²la²ka³lo³ai²na² sa²kxai³lu² wxa²nũ³te²txai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","U³je³na³ka² wxa²ki³ka³la³nũ²la² ĩ³hxi²kĩ¹la³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nxe³ju³ta² hi³a²ka³lo³a² wãn³txa² ũ³wha²li¹lhãn²sxã³ a²ne³ta³lxo³ka³nãu³a¹ ũ³kũ¹tain¹ta¹hxai²hẽ¹la². Ũ³wha²li¹lain¹jau³xa²sa¹: — Je³su²jah³la² Ju³te²a² nũ̱³ka̱³txa² a²hxi²kan¹ta² si³yxau³jah¹lai²la¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nxe³ju³ta² a²nũ²a² kãi³su²lhã³to³jah¹la² ha¹lin¹jah¹la² ĩ³hxi²kĩ¹la³kxain¹nũn³ta¹hxai²hẽ¹la². A²wi¹nẽ³tãu³a¹ ka³na³ka³na³jah¹la² ĩ³hxi²kĩ¹wxe² a²wã̱³tãu³a¹ ka³na³ka³na³jah¹la² ĩ³hxi²kĩ¹wxe² nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","A²nxe³jut3su² kxã³nhxĩ¹nu¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ũ³wha²li¹txã³nxu¹tai²na² nxe³te³nah¹lxi¹: — Jah¹lai²li² ko̱³nxe³ti³ kãi³tũ̱³ka̱³txi³su² ti³hi¹tain¹na²hẽ³li¹. Nxe³txã³nxu¹tai²na² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nxe³nxa²ha¹te¹ a²nũ²a² kwa² wa³to²hi²te²nãu³xa² ĩ³ne³wa³nxĩn¹wa³nxĩn¹nha²sxã³ ĩ³wai³ka³si³xi²jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Nxain¹te³nah¹lxi¹: — Ha³we¹. “Txa²wã¹sũ̱³na² sxi²ha² sa²nai¹hxat3sãn²sxã³ ye³ha¹li¹ ka³na³ki² a³la²ni²sxã³ ã̱h¹sa²to³nxi²na¹tu¹wi¹.” Nxĩn¹jau³su² e³in¹tai¹ti²ti¹. ");
INSERT INTO nabNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hĩ¹na² wã²nxũ̱h¹ ĩ³hxi²ta²la³kxi²nha²sxã³ hi³sa³ka³txa² ka³nxi¹nhu¹li¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jã¹nxe³jau³xa² wã³nxĩn¹ta² si³yxau³ka̱³ta²nãu³xa² ha³te̱h³nxã³nxa² a²hoh³lxi³si²nãu³xa² whãi²na¹, yxo²ĩ²nyhai¹nxa³jau³su² ĩ³wai³ka³si³xi²sxã³ ĩ³ye³lain¹te³nah¹lxi¹: — Jah¹lai²na² a²nũ²a² ã̱³xa² sa²hau³ko³tain¹to³tai¹ti²tu³wi¹. Yxãn¹ta¹ wã²nxũ̱h¹lxi³ hxi²kan¹ti³ sa²hau³ko³nha²nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","I³sa³e² a²wa³kxẽn³yah³lo²su² ha²kxai³ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹lo²su² ha²kxai³ nxe³ke³la³te²kxai³ hi³sa³ka³txa² ĩ³hxi²ta²la³kxi²nha²sxã³ ĩ³ka³nxi²kxai²nãn²tu̱³ yxo²ĩ²sĩ¹nhĩ̱³na¹wi¹. Nxe³ain¹ta¹hxai²hẽ¹la². Te²yã¹nxe³sxã³ in³txa² ko̱³nxe³ti³ kãi³ya³te²na² hi³sa³ka³txa² ã̱³xa³ka³txa² ĩ³hxi²kĩ¹la³kxi²yain¹te²na² te²yã¹nxe³jau³su² yxo²ĩ²nyhai¹nxa³jau³su² ĩ³wai³ka³si³xain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nxa²ha¹te¹ ha³lo²a² whãi²na¹ ka³nxa³hi²khaix1nxe³ta¹hxai²hẽ¹la². A³lan²ta² ne³ka³ka³nhĩ¹nãn¹te²tu̱³ ã³ka³nxa³hi²ta¹hxai²hẽ¹la². Ã³ki³kan³tãu³a¹ so¹lxi³ ĩ³ha²te¹txi²ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ki³kan³nũ²la² Je³su²jah³la² kãin² ĩ³wxan¹sxã³ ĩ³kaix1te³nah¹lxi¹: — E³li¹ e³li¹ la³ma³ sa³ba³ka²ta³ni¹. Ta¹hxai²hẽ¹la². A²nxe³jau³xai²na² a²si³yxau³tãu³a² nxe³te³nah¹lxi¹: — Txa²sũ̱³nu²khai³jah¹lãi³. Txa²sũ̱³nu²khai³jah¹lãi³. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ã³na¹san¹thi²li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nxe³jau³xai²na² a²nũ²a² kwa² yxau³sxã³ ĩ²tũ̱³ka̱³txa² wai³nxa³txi³ ain¹kxain¹nũ²la² ĩ³ye³kxain¹te³nah¹lxi¹: — Ne³kat1jah³sah¹lxi³sĩ¹nhẽ³li¹. E³li²ah³lu¹tai²na² ĩ³kaix1tain¹nĩn²tai¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nxe³te³na¹ a²kwẽn¹tai²na¹ kwa²yxau³sxã³ ĩ²tũ̱³ka̱³txa² ka³na³ka³na³jah¹la² ã³nih³sxã³ ĩ³yi²lho¹tũ̱³xa² so¹sxã³ yain³txa² yau³xa² kah³jau³xa² ũ³hũ̱¹sxã³ ũ³whi¹sai¹te³na¹ hi³sa³ka³txa² ũ³ki³wi²kxi²sxã³ Je³su²jah³la² ĩ³xo̱n³so¹si¹hain¹jau³su² ũh³yxo²tẽ³kxain¹ta¹hxai²hẽ¹la². Ain¹te³nah¹lxi¹: — Ha³lo³kxa² yxau³a³sah¹lxi³hẽ¹li¹. E³li²ah³lu¹tai²na² wxã³sxã³ sa²hxi²ta²la³kxi²te³lhxã³ wxã³si¹jau³nũ³su² ĩ²wahx3nxe³yah³sah¹lxi³hẽ¹li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nxe³ka³tu̱³ Je³su²jah³la² kãin² ĩ³kwa̱ix1sxã³ ya³lu²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nxe³hĩ¹na¹ wã²la² a̱u³khaix1ka³lo³a² Txa²wã¹sũ̱³na² a²sxi²ha² nxũ²kwa̱i³ye³la³nãu³a¹ a̱u³ti³yxau³thĩ³na¹ yxo²tĩ̱¹ka³lo³a² ã³ten²ti³ta¹hxai²hẽ¹la². Oh³nãu³a¹ ã³ten³txi² wxa²kan³ka³tu̱³ yu̱³hxai²na² sa²kxai³lu² ãn³ten³ti³sxã³ ã³yxo²hai²ta³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nxe³ju³ta² so³ta²to² a²hxi²kan¹jah¹lai²na² sa²kxai³lu² Je³su²jah³la² yxo²ĩ²tãu³a¹ sa²nxũ³ta¹hxai²hẽ¹la². A²nxe³jah¹la² Je³su²jah³la² ya³lu²ju³ta² ĩ²ain¹tãu³ ĩ³ye³te³nah¹lxi¹: — Jah¹lai²na² ya²la³tu̱³ Sũ̱³na² Tah²yah³lo²sin²tai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Nxe³nxa²ha¹te¹ ha³la³je¹nhĩ¹nai³kxai³ Je³su²jah³la² Ka³li³le²a²ko³xa² he¹ai¹nhĩ¹kxai³ txu¹ti³nãu³xa² hi²sen³su² Je³su²jah³la² ã³si³tẽ³kxi² a²yen³kxa² wi¹lã³non²ta³kxi² yhain¹to³ta¹hxai²hẽ¹la². Ka³lxa¹tũ̱³ka̱³txi³su² ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txa² ha¹li¹ ka³na³ki¹ ta¹ka³lxi³nãu³xa² a²ĩ³lxa²sa¹: Ma³ri²a³ Ma³ta³lẽ²na³ka³lxa² nxe³ha²kxai³ Ma³ri²a³ka³lxa² Ti³a²kah³la² ka̱u³ka̱un³jah¹la² a²hã³ka³na² Jo³se²ah³la² a²hã³ka³na² nxe³ha²kxai³ Sa³lo²ma³ka³lxa² nxe³ha²kxai³ ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txa² hĩ¹na² u̱²yxau³sxã³ Je³su²jah³la² hxi²kĩ¹la³kxain¹ju³ta² ĩ²ain¹ta¹hxai²hẽ¹la². Nxe³ju³ta² ha³la³je¹nhĩ¹nai³kxai³ txu¹ti³nãu³xã̱³xa² ka³lxa¹tũ̱³ka̱³txa² Je³su²jah³la² ã³si³tẽ³kxa²sxã³ Je³ru³sa³lẽ²thĩ³na² ã³wi¹hain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² u²lyxau³yain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nxe³hĩ¹na² sa²ba³to³ nxe³ju³ta² ye³ka³na³ka³nat3sxã³ a³la²ni²hĩ¹nai³kxai³ Ju³te²a² nũ̱³ka̱³txa² a²yain³txa² wet1sxã³ ãu¹la³kxain¹to³tãu³a¹ ta¹hxai²hẽ¹la². A²nxe³tãu³a¹ sũ²ni²khai¹nxe³tãu³a¹ Jo³se²ah³la² A³ri³ma³te²a³thĩ³nãn¹jah¹la² Ju³te²a² nũ̱³ka̱³txa² hxi²kan¹jah¹la²nãu³xa² ka³na³ka³na³jah¹la² wi¹lhin¹khaix1jah¹la² ta¹hxai²hẽ¹la². A²nxe³jah¹la² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta² wahx3nxe³jah¹lo²su² ta¹hxai²hẽ¹la². Jah¹lai²na² sa²kxai³lo³ ya³lo³txi²sxã³ Pi³la²jah³lai²na² ã³nxai³sxĩ²ka³tu̱³ Je³su²jah³la²nũ²a² ĩ³wã̱³txi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nxe³jau³xai²na² sa²kxai³lu² Pi³la²jah³lai²na² sa²kxai³lu² ain³kxi²tãu³ ĩ³wã̱³wã̱³txi³nha²ta¹hxai²hẽ¹la². — Hĩ¹na² Je³su²jah³la² ya³lu²te²tãn²ku². Nxe³nha²ta¹hxai²hẽ¹la². Nxe³ha²kxai³ so³ta²to² nũ̱³ka̱³txa² hxi²kan³jah¹la² ĩ³kaix1so¹sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lai²na² ya³lu²ta¹nx3thi²li¹? Nxe³yhu¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nxe³nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ya³lu²na²li¹. Ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Pi³la²jah³lai²na² a²wãn³txi³kxai³lu¹: — Ya³lu²jah¹la²nũ²a² so¹txu¹li¹, ten³nxa²kxai²nãn²tu̱³txa¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nxe³nxa²ha¹te¹ Jo³se²ah³lai²na² sa²kxai³lu² wã²la² hã³ta³ka³lo³a² tẽ³ka³tu̱³ a²nũ²su² sa²ta²la³kxi²nyhu¹sxã³ ãn³ka³nxi²ka³tu̱³ wã²la²ka³lo³ai²na² sa²kxai³lu² wxa²wã³lã̱u²kxi²nyhu¹sxã³ tah³lxa³ka³tẽ¹nãu³a¹ ũ³whi²wxe³ta¹hxai²hẽ¹la². A²ẽ¹nãu³a¹ wã³la³ka³txa² tah³lxa³ka³ta² wxa²xu³sxã³ wxa²we¹tẽ³nãu³a¹ ũ³whi²wxe³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ a²ẽ¹nai²na² tah³lxa³kxa² kãin²ka³ta² ũ³wa³ti³kxi² sa²tã³sxã³ ũh³yxo²tĩ̱¹kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nxe³ju³ta² Je³su²jah³la² sa²nĩ̱³kxi²ju³ta² txu¹ti³nãu³xa² Ma³ri²a³ Ma³ta³lẽ²na³ka³lxa² nxe³ha²kxai³ Ma³ri²a³ka³lxa² Jo³se²ah³la² a²hã³ka³na² nxe³ha²kxai³ ha¹lin¹ta¹ka³lxa² ĩ²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nxe³nxa²ha¹te¹ sa²ba³to³ nxe³ti³xa² ha³nãu³hi²na³na¹ nxe³ka³tu̱³ ka³nxah³ti³wi³ta³lon³tãu³a¹ txu¹ti³nãu³xa² Ma³ri²a³ Ma³ta³lẽ²na³ka³lxa² nxe³ha²kxai³ Ma³ri²a³ka³lxa² Ti³a²kah³la² a²hã³ka³na² nxe³ha²kxai³ Sa³lo²ma³ka³lxa² nxe³ha²kxai³ ain¹sxã³ hĩ³ne³kxa² wi¹lũ³tẽ³kxa² ũ³yho³hi²sxã³ so¹ain¹ta¹hxai²hẽ¹la² Je³su²jah³la²nũ²a² wxa²to̱¹la³kxi²te³lha³ka². ");
INSERT INTO nabNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ain¹ka³tu̱³ hã²wxãn³txa³ To³mĩn²ko³ nxe³ju³ta²kxai³ u³je³na³kai²na² a³li³xi²hĩn¹kxai³ txu¹ti³nãu³xai²na² sa²kxai³lu² aun³ta² ã³nxai³ain¹ta¹hxai²hẽ¹la². Nũ¹ka³na¹ sa²nĩ̱³kxain¹ju³ta² aun³ta² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aun³tain¹tãu³a² ĩ³ye³kxi²nyhu¹te³nah¹lxi¹: — Tah³lxa³ka³lo³ai²na² yxo²tĩ̱¹nha²ka³lo³ai²na² ĩh¹nxe³te²ta̱³ sa²yxo²than²kxi²nẽ³lain¹te³ji¹xĩ¹, kãin²khaix1ka³lo³sa²ha²kxai³lu¹? Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yxãn¹ta¹ ten³sa²tã³ain¹te³na¹ kãin²khaix1nxe³ka³lo³ai²li² ũh³yxo²than²nha²ju³ta³nu¹tai²na² ĩ²lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nxe³ain¹ka³tu̱³ tah³lxa³kẽ¹nãu³ai²na² ã³wi¹hain¹ka³tu̱³ in³txa² sa³nxe³la³kxa² ĩ²ain¹ta¹hxai²hẽ¹la². Sa³nxe³la³kxa² wã²la² hãn³ka³lo³a² ũ³whi²kxi²nha²jah¹la² yxau³ta¹hxai²hẽ¹la². A²nxe³jah¹la² txu¹ti³nãu³xa² a²wi¹nẽ³tãu³ai²nãn²tu̱³ ã³wxe³ta¹hxai²hẽ¹la². O²khaix1xain¹sxã³ yu̱h³lxi³khaix1ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yxãn¹ta¹ jah¹lai²na² wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te²an¹jau³kxai³lu¹: — O²lhxã³ ĩ³wã̱³jah³lxi³txa³hẽ¹ni¹. Je³su²jah³la² Na³sa³re²thĩ³na² to̱n¹jah¹la² Ju³te²a² nũ̱³ka̱³txa² hi³sa³ka³txa² ĩ³hxi²kĩ¹la³kxi²sxã³ ĩ³ya²lu¹kxe³su² jah¹la² ãn³ten³yah³lxi¹nxi¹. Yxãn¹ta¹ jah³lai²na² ka³te̱n³su² ĩ³sa²yxau³xi²na²ni¹. Hai³txi³ ti¹nãn²ta³ he¹ti³he¹xai¹nxa³xi¹. Tẽ¹nai²li² hã̱i¹kxain¹te³nai¹ti²tu³ni¹. Ĩ²jah¹lxi³hẽ¹ni¹. ");
INSERT INTO nabNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jã¹nxa¹jau³su² hĩ¹na² sa²kxai³lu² ĩ³sxã³ Pe²jah³la² ĩ³hen³txi² a²sa³wi³ha³lxi³nãu³xã̱³xa² ĩ³hen³txi², whãi²na¹ nxe³jah³lxi³hẽ¹ni¹. Ĩ³hen³txain¹yah³lxin¹jau³kxai³lu¹: “Je³su²jah³la² ne³ka³ta²nx2ti³sxã³ Ka³li³le²a²ko³xa² ã³nxai³tu¹wi¹. Nũ¹ã¹ ĩ²syah¹lxin¹tu¹wi¹.” Jau¹xai²na² ha³la³je¹nai³tã² Je³su²jah³la² ĩ³ye³kxi¹nx2ti³tai¹ti²tu³nĩ¹. Jã¹nxe³jau³su² nxe³txain¹yah³lxi³hẽ¹ni¹. Nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nxe³nxa²ha¹te¹ txu¹ti³nãu³xai²na² tah³lxẽ¹na² a³li³ain¹sxã³ ã³ni³hain¹ta¹hxai²hẽ¹la². Kãi²no²nha²ha²kxai³ ĩ³ka³ta̱³ta̱³tain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ hai³txi³ wãn³txi³la³ a²nũ²a² ã̱³xa² ĩ³ye³kxain¹ti³hex1ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nxe³nxa²ha¹te¹ To³mĩn²ko³ nxe³ju³ta² ĩ³yũ¹li²nxa³ta̱³lxa² Je³su²jah³lo²su² te²kxai³lu² ka³te̱n³su² ĩ³sa²yxau³xi²te³na¹ Ma³ri²a³ Ma³ta³lẽ²na³ka³lxa² ĩ³ha¹txi²ta¹hxai²hẽ¹la². A²kxã³nxai³kxai³ ta¹ka³lxa² a²nxũ²kwa̱i³nãu³a¹, ko̱³nxe³te²a² yãu³ka³txa² ka³lxa¹te²nãu³xa² ha¹li¹ ha¹li¹ ha¹li¹ ka³na³ki¹ tũ̱³ka̱³txa² nxũ²kwa̱i³yxau³kxain¹ta¹hxai²hẽ¹la². A²nxe³ a²ta³a² nũ̱³ka̱³txai²na² Je³su²jah³la² a²ka³te̱³na² yxau²xai³lhĩ¹nai³tã² nxũ²kwa̱i³li³si¹hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nxe³nxa²ha¹te¹ ta¹ka³lxai²na² sa²kxai³lu² ã³nxai³ka³tu̱³ Je³su²jah³la² a²ya̱³la²nãu³xa² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². A²ya̱³la²nãu³xai²na² kãin² ãin²tai¹nha²kxai³ kãin² ĩ³nã̱³nai¹nha²kxai³ Ma³ri²a³ Ma³ta³lẽ²na³ka³lxai²na² sa²kxai³lu² ã³wxã³yain¹sxã³ ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yxãn¹ta¹ Je³su²jah³la² ka³te̱n³su² ĩ³sa²yxau³xi²jau³xa² ta¹ka³lxai²na² Je³su²jah³la² ĩ²ain¹jau³xa² ĩ³yau¹ũ¹hain¹to³ta¹ a²ya̱³la²nãu³xai²na² sa²kxai³lu² yxo²ĩ²ti³he¹xain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nxe³ka³tu̱³ hã²wxãn³txa³ a²ya̱³la²nãu³xai²na² ha¹lin¹te²su² te²a² ha³lo²a² ã³nxai³ya³tãu³ Je³su²jah³lai²na² sa²kxai³lu² ã̱³lxi³ sa²ya̱¹nha²sxã³ ã̱³lxi³te²hũ̱³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ha¹lin¹te²na² sa²kxai³lu² ã̱h¹ ã³wa²li²ya³sxã³ a²ya̱³la²nãu³xai²na² wã³kon³tũ̱³ka̱³txa² ĩ³hen³txi³nyhain¹ta¹hxai²hẽ¹la². Je³su²jah³lai²na² ĩ³ã̱³lxi³te²hũ̱³yain¹jau³xa² ĩ³hen³txain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²wã³kon³tũ̱³ka̱³txai²na² hai³txi³ ĩ³we¹nyhain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hã²wxãn³txa³ ye³jen¹nãu³a¹ a²sa³wi³ha³lxi³nãu³khai³xa² hxi²ka² hxan³sxã³ ka³na³ka³nat3sxã³ wxa²sa²so¹xi²nũn³tũ̱³ka̱³txa² ã³wxe³sxã³ ĩ³yai³nain¹tãu³a² Je³su²jah³lo²su² te²kxai³lu² wxã³yain¹ta¹hxai²hẽ¹la². Wxã³yain¹sxã³ sa²yxo²we¹nyhai¹nxa³ju³ta² ĩ³kwa̱i²kxai¹ni² ã³ne³to³hai¹nxa³ju³ta² ĩ³kwa̱i²kxai¹ni² nxe³ain¹ta¹hxai²hẽ¹la². Ka³te̱n³su² ĩ³sa²yxau³xi²ju³tai²na² a²nũ²a² ĩ²ain¹te²na² a²wãn³txa² a²sa³wi³ha³lxi³nãu³xai²na² yxo²ĩ¹ai¹nxa³ha²kxai³lu¹ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nxe³nxa²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Ha³lo²a² yxo²ha³kxa¹ ã³nxai³jah³lxi³hẽ¹li¹. Ã³nxai³yah³lxin¹kxai²nãn²tu̱³ a²nũ²a² hãi¹nxe³ti³xa¹ ĩ³yau¹ũ¹tain¹yah³lxi³hẽ¹li¹. Ain¹yah³lxin¹te³nah¹lxi¹: Je³su²jah³la² ka³te̱n³su² ĩ³sa²yxau³xi²ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² ko̱³nxe³ti³ kãi³sxã³ yxau²xai³ju³ta² ĩ³ãin²ta³kxi²nha²sxã³ Je³su²jah³la² yxo²ĩ²ain¹kxai²nãn²tu̱³ ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² wa²su¹ti³hi¹tu¹wi¹. Nxe³jau³xai²na² a²nũ²a² yxo²ha³kxa¹ ĩ³yau¹ũ³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nxain¹yah³lxin¹kxai²nãn²tu̱³ a²nũ²a² a²ten³te²su² te²an²tu̱³ yxo²ĩ²sain¹kxai²nãn²tu̱³ ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹nẽ³jau³xa² sa²yxo²wet1sain¹kxai²nãn²tu̱³ te²su² a²ko̱³nxe³ti³ kãi³ain¹ju³ta² wa²su¹tain¹tu¹wi¹. Yxãn¹ta¹ a²nũ²a² sa²yxo²ã³sain¹te²su² te²an²tu̱³ a²ko̱³nxe³ti³ kãi³ju³ta² yxau²sa²tẽ³ai¹nha²kxai³ yxan¹nãu³a¹ Txa²wã¹sũ̱³na² ko̱³nxe³te²lo³jau³su² yxau²xai³lain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A²nũ²a² yxo²ĩ²sain¹kxai²nãn²tu̱³ a²yen³kxa² wã³nxĩn¹ju³ta² kãi³ain¹tu¹wi¹. Kãi³ain¹ju³ta²sa¹: Txa²ĩ³lxa² ĩ³yĩ¹li²sa²sxã³ ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³li³si¹hi² wãn³txa² yau³xã̱³xa² tah²yau³xa² ĩ³ye³i² nxe³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Jã¹nxain¹kxai²nãn²tu̱³ txih³xa² yxo²ko̱³nxe³te²a² wxa²sa²so¹ain¹kxai²nãn²tu̱³ kho³nai¹nxa³ha²kxai³ tih³na³la³yau³xa² ĩ³na²ain¹kxai²nãn²tu̱³ kho³nai¹nxa³ha²kxai³ nxe³ain¹tu¹wi¹. Jã¹nxain¹kxai²nãn²tu̱³ a²nũ²a² ĩ³ton³te²su² te²a² wxa²wxai³ain¹kxai²nãn²tu̱³ we²nxain¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nxe³nxa²ha¹te¹ Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹la² Je³su²jah³la² ĩ³ye³ta³lu²nain¹nxa²ha¹te¹ oh³nãu³a¹ Txa²wã¹sũ̱³na² A²hi²sen³kxai³lu² so¹sxã³ ka³la³ka³tu̱³ Sũ̱³na² wi¹nẽ³tãu³a¹ ã³wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nxe³jut3su² ha²kxai³ a²sa³wi³ha³lxi³nãu³xai²na² ã³nxai³ain¹ka³tu̱³ ha³lo²a² ĩ²li³je³na² ã³nxai³ain¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³ai¹nha²kxai³ hau³hau³kon³nũ²la² Je³su²jah³la² a²hi²sen³kxai³lu² a²sa³wi³ha³lxi³nãu³xai²na² hxi²nũ¹te³lhxã³ a²yen³kxa² nũ̱³kxũn³te²su² o²la³kxai¹nha²kxai³ nxe³ta¹hxai²hẽ¹la². Nxe³ha²kxai³ wãn³txai²na² a²sa³wi³ha³lxai²na² ĩ³ye³ain¹jau³xai²na² Je³su²jah³la² a²hi²sen³kxai³lu² sa²hxi²ka¹tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Te³o²fah³lãi³. Wi¹lhin¹ti³ hxi²kan¹khaix1jah¹lo²si¹lxa². Wãn³txa² ĩ³ye³kxi¹nxa²ha¹tu¹wa². A²nũ²a² ka³lxa¹txi³ Txa²wã¹sũ̱³na² A²hxi²kan¹jah¹la² wxã³sxã³ yxau³ya³sain¹jau³xa² ũ³wha²li¹lhai³nain¹na²hẽ³la². Nxe³jau³jau¹xai²na² ain³kxi²nẽ³lain¹tai¹ti²tu³wa². ");
INSERT INTO nabNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jã¹nxe³ju³ta² sa²kxai³la¹ Txa²wã¹sũ̱³na² A²hxi²kan¹jah¹la²kxai³lu² wxã³sxã³ yxau³ya³sai¹nhĩ¹nãn¹te²tu̱³ ĩ²ain¹tũ̱³ka̱³txi³su² yai¹nha²kxai³ a²sa³wi³ha³lxi³su² yai¹nha²kxai³ nxe³tũ̱³ka̱³txi³su² na²hẽ³la². Nxe³te²kxai³la¹ wãn³txai³tã² ũ³wha²li¹lho¹sxã³ ĩ³hen³txi³nẽ³lain¹tai¹ti²tu³wa². ");
INSERT INTO nabNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","A²nxe³ju³kxai³lu² tũ̱¹ka̱³txa² yã¹nxe³sxã³ a²wi¹lhĩ¹nãn¹te²tu̱³ ĩ²sxã³ ã³si³tẽ³kxi²na¹kxah³lo²su² nũn³te²sa¹wa². Nxe³jah¹lo²sa¹ha²kxai³ nxe³jau³jau¹xai²na² wi¹wi¹nxe² wain³txi³ hau³kot3sxã³ ai³jau³xai³tã² ĩ³hen³txi³nxa²ha¹tu¹wa². ");
INSERT INTO nabNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ũ³wha²li¹lye¹nxa²ha¹tu¹wa². Nxe³nxa²ha¹ha²kxai³ wi¹ko̱³sxã³ a³la³kxin¹tu¹wa². Lu²kah³lo²na¹xai²na² nxe³nxa²ha¹wa². ");
INSERT INTO nabNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nxe³te³nah¹lxi¹ kxãn³nxai³tã² E³ro²jah³lai²na² Ju³te²a² nũ̱³ka̱³txa² a²wa³kxẽn³yah³lo²su² ta¹hxai²hẽ¹la². A²nxe³hĩ¹nai³tã² Sa³ka³ri²ah³la² Txa²wã¹sũ̱³na² sxi²ha² hau³ko³ta¹hxai²hẽ¹la². A³bi²a³ nũ̱³ka̱³txi³su² a²nu²la³ta¹hxai²hẽ¹la². A²nxe³jah¹la² a²sxe³xa² I³sa³be²la³ka³lxi²su² ta¹hxai²hẽ¹la². Nxe³ta¹ka³lxa² A³bi³a²sah³la² a²nũ̱³ka̱³txi³su² nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","A²nxe³te²sya¹ha²kxai³ Txa²wã¹sũ̱³na² yen³nãu³a² wi¹lhin¹yain¹ya³ta¹hxai²hẽ¹la². Nxe³ya³ha²kxai³ a²nũ²a² ĩ²li³te²a² hxi²ka² hxi²kan¹txi³ ko̱³nxe³ti³hi¹tain¹ya³ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nxe³ain¹yah³xa³ha²kxai³la¹ ta¹ka³lxa²kxai³lu² hxi²kan¹txi³ wẽh³ni²nxa³ha²kxai³ a²wẽ³sa³la³ yũ³ya³ta¹hxai²nxa³hẽ¹la². Nxe³ya³kxa²yu³su² yah³lo¹ni² a̱³ka³lxo¹ni² ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nxa²ha¹te¹ Txa²wã¹sũ̱³na² sxi²ha² wxa²sa³ha³la³ti²lho¹xi²sxã³ tẽ³sxã³ wa³ko³nai¹nhxai²na²hẽ³la². Jã¹nxain¹ta¹hxai²hẽ¹la², in³txi³nãu³xa²sa³. ");
INSERT INTO nabNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ai¹nha²kxai³ wxa²wẽ̱³not3sa²kxai³ ha³nxe²a² wha³lxin¹txa² wi¹lũ³ju³ta² ũ³thũ²hain¹ju³ta² tẽ³nũ²la² thĩ¹na² ã³wi¹hain¹to³hxai²na²hẽ³la². Jã¹nxain¹to³ta¹hxai²hẽ¹la², Sũ̱³na² ĩ³sa²nẽn¹kxi²si¹jau³sa³. ");
INSERT INTO nabNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ã³wih¹tãu³ãn²tu̱³ti¹ sxi²ti²ta³lo³kxai²li² a²nũ²a² ka³lxa¹txi³ wah³nxain¹tãu³ãn²tu̱³ti¹ Txa²wã¹sũ̱³nai²li² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nxa²ha¹te¹ Sa³ka³ri²ah³la²kxai³lu² txah³lxa² ne³ka³nah²nãu³a² yax3txain¹tho³xa² a²wi¹nẽ³tãu³a² yxau³sxã³ wa³kon³tãu³a² Txa²wã¹sũ̱³na² ha³lo²an¹jah¹la² a³ka³nxi²sxã³ wxã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nxa²ha¹te¹ Sa³ka³ri²ah³la² ĩ²ai¹nha²kxai³ hxi²waun³txi³sxã³ o²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nxa²ha¹te¹ oh³xan¹jah¹lai²na² wãn³txi³kxai³lu¹: — Sa³ka³ri²ah³lãi³. O²lha²txa³hẽ¹li¹. Txa²wã¹sũ̱³na² ĩ³ye³kxi²to³hin¹jau³xai³tã² ain³kxi¹nxain¹na²hẽ³li¹. Ain³kxi¹nxai¹nha²kxai³ wxa²sxe³xa³ka³lxa² I³sa³be²la³ka³lxa² wẽ³nhi³tu¹wi¹. Wẽ³nhi³ka³tu̱³ wxa²wẽ³sa² we¹tin¹kxi³nũ³a² a³li³lah¹kxi²tu¹wi¹. Nxẽn¹kxai²nãn²tu̱³ wẽh³sai²li² ĩ³lxin¹jau³xa²sa¹: “Jo³ãu²ah³lo²su¹.” Nxe³sẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nxe³ya³hi¹nha²kxai³ kãin² ka³lih³nx2ti³tu¹wi¹. Te²yã¹nxe³sxã³ a²nũ²a² ka³lxa¹te²nãu³xa² ĩ³ka³li³hain¹nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","A²nxe³jah¹lai²li² Txa²wã¹sũ̱³na² kãin²ye²tu¹wi¹. Hai³txi³ vĩn²yau³sa² ta̱³nxa² ũ̱n³jau³sa² ta̱³nxa² ĩ³na²ti³he¹xai¹nxa³lho³li¹. Hãi¹nxe³sxã³ a³li³lah¹xa³hĩ¹nãn¹te²tu̱³ Txa²wã¹sũ̱³na² A²yãu³ka³txa² ã³nxũ²kwa̱i³wih¹sa²tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ai¹nha²kxai³ Txa²wã¹sũ̱³na² Si³yxau³jah¹lai²na² wãn³txa² ĩ³yau¹ũ³hain¹ju³tan¹te²kxa³ya̱³lhu² I³sa³e² nũ̱³ka̱³txa² a²nũ²a² ka³lxa¹txi³ sa²yxo²wet1 ã³si³wxe³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","E³li²ah³lu¹tai²na² Txa²wã¹sũ̱³na² sa²si¹hã³ũ¹nx2ti³ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³jah¹lu¹ta²kxai³lu¹ Sũ̱³na² Yãu³ka³jxah¹la² ã³si³tẽ³kxi²ha²kxai³ ĩ³nũ³kxũn³si²ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³kxa²yã¹nxe³sxã³ Jo³ãu²ah³lo²su² nũn³tu¹wi¹. Sũ̱³na² Yãu³ka³jxah¹lain²txi³ ã³si³tẽ³kxi²nũn³tu¹wi¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² a²wĩ³na²nãu³xa² ã²wẽ³ha³lxi³khai³xa² a³lxa³kxin²tai¹nha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²ã³tũ̱³ka̱³txa² ĩ³wa²la³kxin²tai¹nha²kxai³ nxẽn³txain¹tu¹wi¹. Nxe³sxã³ I³sa³e² nũ̱³ka̱³txa² hi²sen³su² Txa²wã¹sũ̱³na² hxi²kan¹jah¹lai²na² wxã³ju³ta²nũ³a² sa²hau³ko³ta³lu²nain¹tu¹wi¹. Oh³xan¹jah¹la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nxa²ha¹te¹ Sa³ka³ri²ah³lai²na² wãn³txi³kxai³lu¹: — Nxex3txi¹. Txa²sxe³xa³ka³lxa² a̱³ka³lxo¹ni² txai²na² yah³lo¹ni² ã̱h¹sa²sĩn¹na³li¹. Ĩh¹nxet3sxã³ wẽh³ni³hĩ̱³na¹ji¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nxa²ha¹te¹ oh³xan¹jah¹lai²na² wãn³txi³kxai³lu¹: — Txai²li² Ka³bri³e²lah³lo²sa¹wi¹. Txa²wã¹sũ̱³na² a²yen³nãu³a² yxau³na¹ha²kxai³ wãn³txa² wi¹jau³xa² ĩ³tih³nxe³nxa²si¹sain¹jau³su² sa²si¹hã³sain¹na²li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sai¹nha²kxai³ yxo²ĩ²nhxãn³su³li¹. Nxẽn²nxãn³kxan²ti³ ye³jen¹na² ya²la³tu̱³jex1tu¹wi¹. Yxãn¹ta¹ yxo²ĩ²sa²nxã³nha²kxai³ ĩ³ye³xan³tho³li¹. Yxo²kan²ta³kxi²nxa²tu¹wi¹. Kxãn³nãu³a² txa²wãn³txa² kãi³ta³lu²nhĩ¹na¹ wi¹lĩ³ye³xin¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nxe³ain¹tãu³ãn²tu̱³ti¹ ha³lo²a² yxau³tũ̱³ka̱³txa² kãin² wah³nxe³sxã³ e³lain¹te³nah¹lxi¹: — Thĩ¹na² kxãn³sa² yxau³ain¹na²li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nyhain¹nxa²ha¹te¹ Sa³ka³ri²ah³la² a³li³xi²te³na¹ hxi²kan¹txi³ ĩ³ye³xa³ha²kxai³ hãi¹sxã³ wxa²ye³wxã̱i³wxã̱i³sa²tã³ain¹ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² wa̱³lain¹ta¹hxai²hẽ¹la². Nxain¹tãu³a² ĩ³ye³lain¹te³nah¹lxi¹: — Hxi²sxã³nhon³jut3sũ̱³ju³ta² ĩ²in²tai¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nxa²ha¹te¹ kxãn³nãu³a² Sa³ka³ri²ah³lo²nu¹ta²kxai³lu² in³jah³la² ã̱³xa² ã³si³wẽ̱³not3ha²kxai³ ĩ³xi²ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hã²wxãn³txa³ a²sxe³xa³ka³lxa² wẽh³ni³ha²kxai³ i³la³kxa² ki³ka³lxa¹tãu³kxai³la¹ a²sxi²ha² yxau³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nxa²ha¹te¹ ta¹ka³lxai²na² a²wãn³txi³kxai³la¹: — Kxã³nhxĩ¹nai³tã² wẽ³sa³ txa²sa³ha²kxai³ ãu²li²sxai²hẽ¹li¹. Yxãn¹ta¹ hĩ¹na² wẽh³nha¹ha²kxai³ ãu²li²sa²hxai²nxa³hẽ¹li¹. Txa²wã¹sũ̱³na² wi¹lxo³kxi²sa³nhai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nxe³nxa²ha¹te¹ ta¹ka³lxa²kxai³la¹ wẽh³ni² ã³si³wxe³hĩ¹nãn¹te²tu̱³ i³la³ka² ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ sa²tã²tĩ¹ka³tu̱³ hã²wxãn³txa³ Txa²wã¹sũ̱³na² hi²sen³kxai³lu² Ka³bri³e²lah³lai¹tã² oh³xan¹jah¹lai¹tã² ãh¹ sa²si¹hã³xi²ta¹hxai²hẽ¹la². Sxi²yhe³na² ne³nã̱³xan¹thĩ³na² Na³sa³re²thĩ³na² sa²si¹hã³xi²ta¹hxai²hẽ¹la². A²nxe³thĩ³na² Ka³li³le²a²ko³xan¹thĩn³su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A²nxe³thĩ³na² Ma³ri²a³ka³lxa² yxau²xai³ta¹hxai²hẽ¹la². Jã¹nxe³ta¹ka³lxa² Ta³vi²yah³lo²nu¹txai²na² I³sa³e² nũ̱³ka̱³txa² wa³kxẽn³yah³lo²nu¹txai²na² a²ne³tah²nãu³su³ ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxain²txi³ Jo³se²ah³la² hi²sen³su² so¹nyhu¹kxi³ju³ta³nũ³a² e³hau³ko³ta³lun²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jã¹nxe³ta¹ka³lxu²su² kxan²ta² Ka³bri³e²lah³la² hi²sen³kxai³lu² Ma³ri²a³ka³lxa² sa²kxai³lu² tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Ma³ri²a³ka³lxãi³. Wi¹lhĩ¹nĩ¹nxi¹. Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²nxa²ha²kxai³ wi¹lxo³kxi¹nxa²tũ¹xĩ¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nxa²ha¹te¹ Ma³ri²a³ka³lxu³nu¹ta²kxai³lu² ã³ne³wxe²nxa³jau³su² e³kxi²nha²te³nah¹lxi¹: — Ĩh¹nxe³hĩ̱³te²la¹ku². Nxa¹nhai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Oh³xan¹jah¹lai²na² wãn³txi³kxai³lu¹: — Wã̱³wã̱³ta³kxi²nha²txa³hẽ¹ni¹. Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²nxa²na²hẽ³ni¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nxĩ¹nha²kxai³ ye³jen¹na² wẽ³nhĩn¹tũ¹xĩ¹. Wẽ³nhĩn¹ka³tu̱³ wẽ³sa² a³li³lah¹kxi²nxa²tũ¹xĩ¹. Nxe³ka³tu̱³ wẽ³nyhe³nxã¹kxa², “Je³su²jah³lo²su¹.” Nxe³sẽ¹ni¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Txa²wã¹sũ̱³na² kãin² ĩ³sa²nẽn¹kxi²sxã³ a²ki³lha³lxa²khai³xa² ye²kxe³su² ĩ³yau¹ũ³nyhain¹tũ¹xĩ¹. Txa²wã¹sũ̱³na² Si³yxau³jah¹la² hi²sen³kxai³lu² wxa²ka³lxa¹ti³nãu³xa² I³se²e² nũ̱³ka̱³txan²tu̱³ wa³kxẽn³ti³hit1tũ¹xĩ¹. A²nxe³jah¹lai²li² wxa²ki³lha³lxain²txi³ Ta³vi²yah³lu¹tai²na² wxa²wa³kxẽn³yah³lu¹tai²na² a²ne³tah²nãu³su² jah¹lai²la¹xi¹. Kxã³nhxĩ¹nai³tã² wxã³sxã³ ĩ³wa³kxẽn³sain¹sa²tẽ³ju³ta³nũ³su² ĩ³ye³kxũ¹ta¹hxai²hẽ¹ni¹. Wxa²wẽ³sai²na² jah¹lain²txi²na³ni¹. Nxe³ye¹nxa²ha¹xĩ¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nxa²ha¹te¹ Ma³ri²a³ka³lxai²na² wãn³txi³kxai³lu¹: — Txai²li² in³txi³ txa²sa³ha²kxai³ nũh¹yxau²xai³la¹ha²kxai³ ĩh¹nxe³sĩ̱³nxa¹te²la¹ku². Nxa¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nxa²ha¹te¹ oh³xan¹jah¹lai²na² wãn³txi³kxai³lu¹: — Txa²wã¹sũ̱³na² Si³yxau³jah¹lai²na² Yãu³ka³jxah¹la² hi²sen³su² wĩn¹txi¹nxã²nxa³kxan²ti³ wẽ³sa² ũ³whẽh³ni³nxa²tũ¹xĩ¹. Nxĩn¹te³na¹ wxa²wẽ³sa² Txa²wã¹sũ̱³na² ki³lha³lhxu²tũ¹xĩ¹. Wi¹lhin¹khaix1jah¹lo²si²tũ¹xĩ¹. Nxe³kxi¹nxain¹tũ¹xĩ¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nxa²ha¹te¹ wxa²wã³tã̱³ta² I³sa³be²la³ka³lxai³tã² wẽh³ni³nũn³na³ni¹. Nxe³ta¹ka³lxa² hxi²kan¹txi³ wẽh³nĩ³hxai²nxa³tai¹tu³ni¹. Yxãn¹tah¹lxa¹ ta¹ka³lxai²li² i³la³kxa² ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ sa²tã³tĩ¹ka³tu̱³ wẽh³nĩ³na²hẽ³ni¹, a̱³ka³lxon¹kxan²ti³nu¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","A²nxe³jut3su² Txa²wã¹sũ̱³na² hxi²ki³kxai³lu² ĩ²li³ju³ta² hxi²ka¹nhĩ̱³nx2na³ni¹. Oh³xan¹jah¹la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nxa²ha¹te¹ Ma³ri²a³ka³lxu³nu¹ta²kxai³ ĩ³wa²lũ³xi²ti³ãn¹jau³kxai³lu¹: — Txa²wã¹sũ̱³na² a²wa³kxẽn³no³sa²ka³lxu³sa¹wi¹. Sa³ha²kxai³ Txa²wã¹sũ̱³na² e³kxi²nha²jau³xa² so¹lxi³ ten³sa³nhai¹. Nxe³ha²kxai³ wi¹nha¹wi¹. Ta¹hxai²hẽ¹la². Nxe² e³ta³lun²nũ²la² oh³xan¹jah¹la² a³li³xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nxa²ha¹te¹ hã²wxãn³txa³ Ma³ri²a³ka³lxa²kxai³lu² a³li³nũ²la² wã³la³ka³txa² yũ³ko³xa² Ju³te²a² ko³xan¹thĩ³na² wa³su³txi³ ai³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ai³nũ²la² Sa³ka³ri²ah³la² sxi²ha² ã³wih¹ta¹hxai²hẽ¹la². Ã³wih¹nũ²la² I³sa³be²la³ka³lxa² ĩ³ye³kxi²nyha¹te³nah¹lxi¹: — Nxe³nxi¹. Wi¹lhi¹nĩ¹nxi¹. Nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nyha¹nxa²ha¹te¹ jau³jau¹xai²na² I³sa³be²la³ka³lxa² ain³kxi²hĩ¹na¹ a²wẽ³sa² yxau³nit1te²a² hxa³lxi²ye²ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ Txa²wã¹sũ̱³na² Yãu³ka³txa² nxũ²kwa̱i³wih¹nũ²la² a²yxo²wãn³txa² ĩ³ye³kxi²si¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ĩ³ye³kxi²si¹te³nah¹lxi¹: — Tu¹txi³nãu³xa² yxo²ha³kxa¹ ĩ³ye³kxi¹nxain¹tũ¹xĩ¹. Nxain¹te³nah¹lxi¹: “Wxãi²na² sa²kxai³lu² wi¹lhin¹khaix1sĩ¹nĩ¹nxĩ¹.” Nxe³nxain¹jau³su² ĩ³ye³kxi¹nxain¹tũ¹xĩ¹. Kxãn³nãu³a¹ wxa²wẽ³sa² a³li³lah¹tũ¹xĩ¹. Nxe³te²a² wi¹lhin¹nũn³tũ¹xĩ¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Txa²hxi²kan¹ta² Si³yxau³jah¹la² a²hã³ka³na² wxã³sxĩ²sain¹na³na¹. Kãin²ju³tai²la³xã¹. Yxãn¹ta¹ txai²li² kãin²sa²nxa³xã¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wxa²wãn³txa² ain³kxi²sa¹nhĩ¹na¹ wẽ³sa² yxau³ni¹sa³te²a² ka³lih³sxã³ hxa³lxi²nhi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nxe³ha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² yxo²ĩ²ĩ¹nha²kxai³ wi¹lhin¹khaix1nĩ¹nxi¹. I³sa³be²la³ka³lxa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nxa²ha¹te¹ Ma³ri²a³ka³lxai²na² wãn³txi³kxai³lu¹: — Txa²wã¹sũ̱³na² Si³yxau³jah¹la² sa²nẽn¹kxi²na¹nhi¹. Nxe³jau³xai²na² txa²ẽ¹nãn¹jau³la³ e³kxi²nha¹nhi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Txa²wã¹sũ̱³na² Si³yxau³jah¹lai²na² txa²ẽ¹nãu³ai²na² ko̱³nxe³ti³ kãi³a¹kxa² wah³xa² sa²sai¹kxi²sain¹jah¹lai²na² ĩ³ka³lih³sa³nhi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Txai²na² sa²kxai³lu² kwa²hãi¹nxe² Txa²wã¹sũ̱³na² a²wa³kxẽ³no³sa²ka³lxu³sa¹xĩ¹. Nxe³sa³kxan²ti³ ne³wãn²sai¹nxa³hẽ³ni¹. Nxe³hĩ¹nãn¹te²tu̱³ a²nũ²a² yxo²ha³kxa¹ Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²sa²si¹hain¹jau³su² ĩ³ye³kxi²sain¹tũ¹xĩ¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Txa²wã¹sũ̱³na² Nũ³kxũn³ta² Si³yxau³jah¹lai²la¹xi¹. Wi¹kãi³ũh¹sain¹na³ni¹. Wi¹lhin¹khaix1jah¹lai²la¹xi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sa²yxo²we¹txain¹tũ̱³ka̱³txa² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³tain¹to³tũ¹xĩ¹. Ha²ya̱³kxa²ti³ti³he¹xai¹nxa³lho³ni¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A²nũ²a² kãin²te²lo³nhain¹tũ̱³ka̱³txa² yxo²ha³kxa¹ nũ³kxũn³txi³ ĩ³hxi²ka̱u³ka̱u³nain¹na³ni¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nxai¹nha²kxai³ a²nũ²a² a²si³yxau³te²su² te²a² sa²hxi²ka¹txa³ha²kxai³ a²nũ²a² kãi²nxa³te²lo³nh³te²su² te²a² hxi²kan¹ti³hi¹txai¹nha²kxai³ ai¹nhxai²na²hẽ³ni¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jã¹nxe³ju³kxai³lu² heh³khaix1te²a² yain³txa² ũ³hũ¹ai¹nha²kxai³ yxãn¹ta¹ yen³kxih³te²a² hãi¹sxã³ yen³kxi³txa²sxã³ a³li³si¹jau³su² kwa³na³ha²kxai³ nxe³ai¹nhxai²na²hẽ³ni¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nxe³jut3su² wãn³txu¹tai²na² txa²ka³lxa¹txi³nãu³xu¹txai²na² ĩ³ye³kxain¹jau³xa² yxo²ha³kxa¹ we¹ta³lu²nũ¹hain¹na²hẽ³ni¹. Nxe³te²kxai³la¹ A³bra³ãu²ah³lu¹tai²na² a²ne³tah²nãu³u¹tai²nãn²tu̱³ ko̱³nxe³ti³ kãi³ain¹ju³ta² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³tain¹ta¹hxai²ti³ai¹ti²tu³ni¹. Jã¹nxe³sa²tẽ³yain¹na³ni¹. I³sa³e² nũ̱³ka̱³txa² txa²nũ̱³ka̱³txi³khai³xan²tu̱³ ã³non²ta³kxi²nẽ³na³ni¹. Nxe³jau³su² Ma³ri²a³ka³lxa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nxa²ha¹te¹ i³la³ka² ki³ha¹li¹ ka³na³ki¹ sa²tã³tĩ¹ka³tu̱³ I³sa³be²la³ka³lxai²na² sxi²ha² yxau³kxi²ka³tu̱³ a³li³sxã³ wa̱³li²xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nxa²ha¹te¹ ye³jen¹nãu³a² I³sa³be²la³ka³lxa² ti̱²kãin²nha²ta¹hxai²hẽ¹la². A²wẽ³sa² a³li³lah¹kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A³li³lah¹kxi²tãu³ãn²tu̱³ti¹ a²nũ̱³ka̱³txi³nãu³xã² a²ya̱³lxi³nãu³xã² a²ka³lxa¹txi³nãu³xã² ain¹sxã³ Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²ye²si¹jau³su² ain³kxain¹nũ²la² ka³lih³sxã³ ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³tin²tai¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nxa²ha¹te¹ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ a³lan²ni²sxã³ a²wẽ³sa² ũ³sa³si³tũ³ko¹kxã¹nha²te³lhxã³ wxã³ain¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a² nxe² e³lain¹te³nah¹lxi¹: — “Sa³ka³ri²ah³lo²su².” Ĩ³lxi²ki̱³tũ¹xĩ¹, a²wĩ³na² nxe² ĩ³lxih²nha²ha²kxai³lu¹. Ain¹tah¹lxa¹ a²hã³ka³na² ten³yain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nxa²ha¹te¹ a²hã³ka³na² ĩ³wa²li²yain¹te³nah¹lxi¹: — Nxe²nxa³wi¹. Yxãn¹ta¹: “Jo³ãu²ah³lo²su¹.” Ki̱³tu¹wi¹. A²hã³ka³na² yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nxa²ha¹te¹ ãh¹ ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² te²yã¹nxe² ĩ³lxi²nha²te²la³ yũ³sĩ¹ki̱³sxa³xi¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ai¹nha²kxai³ ĩ³lxi²hain¹jau³nũ³a² a²wĩ³na² wxa²ye̱³wxã̱ix3so¹ain¹sxã³ ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nxa²ha¹te¹ Sa³ka³ri²ah³la² hi²sen³su² ũ³wha²li¹lho¹ain¹txã³nxa² wxa²so¹nũ²la² ũ³yhe³ka¹te³nah¹lxi¹: — “Jo³ãu²ah³lo²su¹.” Nxe² ĩ³lxi²sĩ¹na¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nxe³ju³tan¹te²tu̱³ti¹ Sa³ka³ri²ah³la²kxai³lu² ãh¹ĩ³sai¹sxã³ ĩ³ye³xi²ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wi¹lhin¹khai¹nx2na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A²nxe³ju³tai²li² ĩ²ai¹nha²kxai³ kãin² on²tain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² Ju³te²a²ko³nãu³a² wã³la³ka³txãn¹ko³nãu³a² u²la³ ha³ta̱³nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jã¹nxe³kxan²ta² Txa²wã¹sũ̱³na²nãu³xa² hxi²ka² yxau³ye²kxe³su² ĩ²ai¹nha²kxai³ wã²nxũ̱¹ha̱in³nha²sãn²sxã³ ĩ³ye³lain¹te³nah¹lxi¹: — Wẽ³sai²li² ĩh¹nxe³ton¹sxã³ kãi³hĩ̱³te³ji¹ku¹. Ki̱³nhai¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ain¹nxa²ha¹te¹ Sa³ka³ri²ah³la² hi²sen³kxai³lu² Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² nxũ²kwa̱i³wi¹ha²kxai³ ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wi¹lhin¹khai¹nx2na³li¹. I³sa³e² nũ̱³ka̱³txa² A²si³yxau³jah¹lai²la¹wi¹, txa²nũ̱³ka̱³txai²na²su¹. Ĩ²nẽ³te³lhxã³ wxã³na²hẽ³li¹. Wxã³nũ²la² txa²wã¹ko̱³nxe³ti³ kãi³ki̱³ju³ta² sa²hau³ko³tẽ³na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Txa²wã¹sũ̱³na² hxi²kan¹jah¹la² sa²si¹hã³sain¹jah¹la² kãin²khaix1nx2na³li¹. Nxe³jah¹la² Ta³vi²yah³lu¹tai²na² Sũ̱³na² wãn³txa² sa²yxo²we¹jah¹lo²su² ha²kxai³ a²ne³tah²nãu³su² na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nxe³jau³xai²na² kxã³nhxĩ¹nu¹tai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² wi¹lhin¹tũ̱³ka̱³txai²na² ĩ³hen³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ĩ³hen³txain¹te³nah¹lxi¹: — “Txa²wã¹sũ̱³na² hi²sen³su² ko̱¹ko̱¹nũ̱³ka̱³txa² a̱n³ta³kxi²nẽ³lain¹tũ̱³ka̱³txa² a²yan³txi³su² ã³non²ta³kxi²nẽ³lain¹na²hẽ³li¹.” Ain¹ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nxe³jut3su² txa²wã¹ka³lxa¹txi³nũ̱³ka̱³txu¹tai²na² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³tin²tain¹jau³su² ko̱³nxe³ti³ kãi³ain¹kxa² wah³xa² ũ³yhoh³xai¹nxa³ha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² ĩ³ye³kxũ¹jau³xu¹tai²na² wi¹lhin¹khaix1jau³xan²tu̱³ kãi³ta³lu²nha²kxai³ nxe³nũ¹hain¹na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Jã¹nxe³ju³kxai³lu² A³bra³ãu²ah³lu¹tai²na² te²yã¹nxe² ĩ³ye³kxũ¹nũn³te³nah¹lxi¹: “Wxa²ko̱¹ko̱¹nũ̱³ka̱³txa² ã³non²ta³kxi¹nx2ta¹tu¹wi¹. Yu̱h³lxi³nx3txi³xa³lho³li¹.” Nxe³nx2ti³ju³tan¹te²kxa³ya̱³lhu² kan²txi³ sa²yxo²wet1sah¹lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nxe³ha²kxai³ ka³te̱n³su² yxau³yah³lxin¹tãu³a² a³lan²ta² yxo²ha³kxah¹lxi³sxã³ wi¹lhin¹sxã³ kãi³sa²tẽ³yah³lxi¹nha²kxai³ wain³te²lo³nha²sxã³ sa²yxo²wet1sah¹lxi¹nha²kxai³ nxe³sah²lxin¹tu¹wi¹. Txa²wã¹sũ̱³na² nxe³ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jã¹nxe² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wẽ³sãi³. Wxãi²na² sa²kxai³lu² Txa²wã¹sũ̱³na² Si³yxau³jah¹lai²li² a²wãn³txa² ĩ³hen³txi³jah¹lo²sin¹tu¹wi¹. Nxĩ¹nha²kxai³ ne³ka³ta²a² wxã³sxã³ Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹la² a³ka³nxi²sxã³ wxã³ju³ta²nũ³a² a²nũ²a² ẽ¹nãu³ai²na² wxa²hau³ko³tũ²xai³si¹hain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nxĩn¹ka³tu̱³ a²nũ̱³ka̱³txa² ĩ³yau¹ũ¹hai¹nĩn¹te³nah¹lxi¹: “Wxa²ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ã³na¹yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²nx2ti³sãn²sxã³ ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² nxe³wã²na³kxi¹nx2ti³tu¹wi¹, ĩ³ãin²ta³lxi²sai¹nha²kxai³la¹.” ");
INSERT INTO nabNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Te²yã¹nxe³ju³ta² sa²kxai³lu² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³tẽ³lha²kxai³ a³lan²ju³ta² ĩ³ha²te¹kxi²nẽ³jut3sũ̱³nxe² txa²wã¹ẽ¹nãu³a² sa²hau³ko³tẽ³tu¹wi¹. Nxe³nẽ³kxai²nãn²tu̱³ ko̱³nxe³ti³ kãi³ki̱³ju³ta² ã³wa²su¹kxi²nẽ³li² hãu²nxe³sxã³ yxau²xai³nha²si¹nhẽ³li² nxe³nẽ³tu¹wi¹. Sa³ka³ri²ah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nxa²ha¹te¹ a²wẽ³sa²kxai³lu² Jo³ãu²ah³la²kxai³lu² wi¹txon¹nha²kxai³ a²ẽ¹nãu³ai²na² wxi²kan¹to³nha²kxai³ nxe³ta¹hxai²hẽ¹la². I³sa³e² nũ̱³ka̱³txai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi²nxa³ta̱³lxa¹ ha³lo²a² a²nũ²a² yũ²nxa³ko³xu¹tai²na² yxau²xai³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","Nxe³nxa²ha¹te¹ nxe³ain¹tãu³a² Au³kus²jah³la² Ro³ma²no²ko³xa² kãin²ko³xa² a²wa³li³kha³lah³lo²sa²ta¹hxai²hẽ¹la². A²nxe³jah¹la² a²ha³lo²a² a²hãi¹nxe³ti³xa¹ ĩ³kwa³na³ain¹ta¹hxai²hẽ¹la². A²sxi²jen³khai³xa² txon¹nhĩn¹thĩ³nai³tã² a²nũ²a² wxa²hau³kot3so¹si¹hain¹jau³su² ũ³wha²li¹lho¹si¹hain¹jau³su² ĩ³kwa³na³ain¹ta¹hxai²hẽ¹la², jah¹la²sa². Nxe³ain¹tãu³a² a²wi¹lhĩ¹na² ũ³wha²li¹lho¹hĩ¹nai³tã² Ki³ri²ah³la² Si²ri³a³ko³xa² sa²hau³ko³ta¹hxai²hẽ¹la². A²nxe³hĩ¹nai³tãn²tu̱³: — Wxa²txon¹nhĩn¹thĩ³nai³tã² ĩx3sĩn¹sxã³ a²nũ²a² nũ̱³ka̱³txa² ũ³wha²li¹lho² ha³lo²a² ũ³ha²li¹lho² nxex3sĩ¹nhẽ³li¹. Nxe² ĩ³kwa³na³ain¹ta¹hxai²hẽ¹la². A²nxe³ju³kxai³lu² a²nũ²a² yxo²ha³kxa¹ a²sxi²yhen³khai³xa² a²txo¹nain¹thĩ³na² ĩ³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nxe³xai¹nha²kxai³ Jo³se²ah³la²kxai³lu² Na³sa³re²thĩ³na² Ka³li³le²a²ko³xan¹thĩ³na² a³li³nũ²la² a²sxi²yhe³na² a²txon¹jen³khai³xai³tã² Be³lẽ²thĩ³na² Ju³te²a²ko³xan¹thĩ³nãn²tu̱³ ã³nxĩ³te³lhxã³ ain¹ta¹hxai²hẽ¹la². Nxe³thĩ³na² Ta³vi²yah³lu¹tai²na² a²sxi²su² ta¹hxai²hẽ¹la². A²nxe³jah¹la² Ta³vi²yah³lu¹tai²na² a²ne³tah²nãu³su² ha²kxai³ Be³lẽ²thĩ³na² ĩ³xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A²nxe³jah¹la² a²sxe³xa² so¹te³lhxã³ nhya¹ta¹ka³lxa² tẽ³sxã³ ĩ³nhya¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nxe³ha²kxai³ ũ³wha²li¹lhau³ko³te³lhxã³ ĩ³ya³ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³sa²yxau³ain¹tãu³a² ta¹ka³lxa² Ma³ri²a³ka³lxa² wẽh³ni³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nxe³nũ²la² Be³lẽ²thĩ³na² ĩ³ai¹nhĩ¹na² a²ki³lha³lxa² a²hxi²kan¹te²su² te²a² a³li³lah¹ta¹hxai²hẽ¹la². Po¹na² sxi²hẽ¹na² a³li³lah¹ta¹hxai²hẽ¹la², a²nũ²a² sxi²ha² ne³ki³ha²kxai³la². Nxe³sxã³ wã²la² tẽ³sxã³ wxa²wã³lã̱u²kxi²so¹sxã³ ko²syẽ¹na² ã³na¹sxã³ ã³wih¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ain¹nxa²ha¹te¹ ha³lo²a² a²wa̱³kan¹ko³xa² o³ve²a² sa²hau³ko³tũ̱³ka̱³txa² he¹lain¹ta¹hxai²hẽ¹la². Ka³nxah³tai²na² wah³nxa³ki²lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nxe³ain¹tãu³a² nxe³hĩ¹na¹ oh³xan¹jah¹la² wxa²kan³ta¹hxai²hẽ¹la². Nxe³sxã³ wxã³hĩ¹na¹ ha³lo²a² sa²ko¹ko¹ta¹hxai²hẽ¹la². Sa²ko¹ko¹ju³tan¹te²kxa³ya̱³lhu² kãin² on²tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ain¹nxa²ha¹te¹ oh³xan¹jah¹la² a²wãn³txi³kxai³lu¹: — On²txi³sah¹lxi³txa³hẽ¹li¹. Wãn³txa² wi¹jau³xa² a²nũ²a² yxo²ha³kxa¹ ain³kxi²sah²lxin¹jau³nũ³a² ĩ³hen³txi³nx2ti³te³lhxã³ wxã³na¹wi¹. A²nũ²a² yxo²ha³kxa¹ ĩ³ka³li³nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hĩ¹na¹ Ta³vi²yah³la² sxi²yhe³na² wẽ³sa² wi¹khaix1te²a² a³li³lah¹na²li¹. A²nxe³jah¹la² a²nũ²a² yxo²ha³kxa¹ ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ã³wa²su¹jah¹lo²nũ³su² tu¹wi¹. Txa²wã¹sũ̱³na² Hxi²kan¹txa² Si³yxau³tãu³lo³jah¹lo²su² na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","A²nxe³te²a² po¹na² sxi²ha² wxa²wã³lã̱u²kxi²nha²sxã³ ko²syẽ¹na² ã³na¹sxã³ ã³wi¹ha²kxai³ sxa²na³li¹. Nxe³ju³ta² ĩ²ah³lxin¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nxa²ha¹te¹ wa³su¹txi³ oh³xan¹ta² nũ̱³ka̱³txa² wxa²ka³nxi² wxã³yain¹ta¹hxai²hẽ¹la². Wxã³yain¹nũ²la² Txa²wã¹sũ̱³na² ĩ³sa²nẽn¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nxe³te³nah¹lxi¹: — Txa²wã¹sũ̱³na² oh³xa² yxaut3jah¹la² kãi²te²a² Si³yxau³jah¹lai²la¹wi¹. Nxe³ha²kxai³ ĩ³wxi²kin³ti³ton³ti³hit1txai¹yah³lxi³hẽ¹li¹. Yxah³lxin¹sxã³ a²nũ²a² yuh³xan¹ko³xan¹ta³ nũ̱³ka̱³txa² wi¹lhin¹sxã³ yxau³ain¹tu¹wi¹, Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²ai¹nha²kxai³lu¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ĩ³ye³ta³lu²nain¹nũ²la² oh³xa² wxa²ka³la³xi²yain¹ta¹hxai²hẽ¹la². Ain¹nxa²ha¹te¹ o³ve²a² sa²hau³ko³tũ̱³ka̱³txi³nu¹ta²kxai³lu² ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Nũ¹ka³na¹ Be³lẽ²thĩ³na² ai³sĩ²a³sah¹lxi³wxi¹. Txa²wã¹sũ̱³na² kwẽn¹ta² ĩ³ye³kxi²nẽ³lain¹jau³xa² ain³kxi² ĩ²i² a³sah¹lxi³wxi¹. Nxẽn³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nxe³ain¹nũ²la² wa³su³txi³ ai³ain¹nũ²la² po¹na² sxi²ha² a³li³kxi²nyhain¹nũ²la² Ma³ri²a³ka³lxa² Jo³se²ah³la² ĩ²ain¹ta¹hxai²hẽ¹la². Nxe³sxã³ a²wẽ³sa² whãi²na¹ ĩ² nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hã²wxãn³txa³ ĩ²ta³lun²nũ²la² ĩ³xain¹tãu³a² wãn³txai³tã² oh³xan¹jah¹lai²na² wãn³txai³tã² a²nũ²a² yxo²ha³kxa¹ ĩ³hen³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nxe³ai¹nha²kxai³ o³ve²a² sa²hau³ko³tũ̱³ka̱³txai²na² wãn³txa² ain³kxain¹te²na² ĩ³yon²txi³nyhain¹te³nah¹lxi¹: — Ĩh¹nxe³te²la¹ku². Wãn³txa² ya²la³tu̱³te²nha²ku². Ki̱³nhai¹. Nxe³yhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nxa²ha¹te¹ Ma³ri²a³ka³lxa²kxai³ ju¹tai²li² ĩ²sxã³ ne³wa³kon³sa²tẽ³nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nxa²ha¹te¹ o³ve²a² sa²hau³ko³tũ̱³ka̱³txa² ã³naun³ta² ĩ³xain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ Txa²wã¹sũ̱³na² sa²nẽn¹kxi²nyhain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² Kãin²ta² Si³yxau³jah¹lai²la¹wi¹. Oh³xan¹jah¹la² sa²si¹hã³ũ¹nhẽ³jah¹lai²na² wãn³txin³txi² ya²la³tu̱³ ĩ²ki̱³ten¹tu³wi¹. Nxe³ki̱³sa²kxai³ Sũ̱³na² sa²nẽn¹kxi²a³sah¹lxi³wxi¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ain¹nxa²ha¹te¹ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ a³lan²ni²nũ²la² nxe³hĩ¹na¹ wẽ³sa² ũ³sa³si³tũ³ko¹kxã¹nha²te³lhxã³ a²nũ²kxi²xain¹ta¹hxai²hẽ¹la². — Je³su²jah³lo²su¹. Nxe² ĩ³lxi²nyhain¹ta¹hxai²hẽ¹la². Nxe³te²ĩ³lxa² a²wi¹lhĩ¹na² Ma³ri²a³ka³lxa² wẽh³ni²nxa³hĩ¹nai³tã² oh³xan¹jah¹la² wxa²kan³sxã³ ĩ³lxi²hain¹ta¹hxai²hẽ¹la². — Je³su²jah³lo²su¹. Nxe² ĩ³lxi²hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Ain¹nxa²ha¹te¹ a²wi¹lhĩ¹nu¹tai²na² Moi³se²ah³lu¹tai²na² hi²sen³su² Txa²wã¹sũ̱³na² wãn³txa² ũ³wha²li¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Txu¹ha² kwẽn¹ta² wẽ³sa² a³li³la¹kxi²ta¹ka³lxu² ĩ³nxai²na² wẽ³sa² tu³kxi²tãu³a¹ wa³ka³li³yu³ta² hãi¹nxã¹txa²sã²nhi¹. Moi³se²ah³lu¹tai²na² nxe³ta¹hxai²hẽ¹la². Ain¹jau³su² ha²kxai³ Ma³ri²a³ka³lxa²kxai³ ain³kxi²nha²sxã³ ã³ta¹hxai²hẽ¹la². Nxe³nũ²la² a²wẽ³sa² tu³kxi¹nxa²ha¹te¹ Txa²wã¹sũ̱³na² sxi²ha² Je³ru³sa³lẽ²thĩ³nãn¹ta² sxi²ha² wẽ³sai²li² tẽ³sxã³ ã³wih¹ka³tu̱³ wã²nã³ũ¹hi² yen³kxa² hxi²tẽ³nha²sxã³ ũ³hũ² nxe³ain¹ta¹hxai²hẽ¹la². Nxe³ju³kxai³lu¹ kxã³nhxĩ¹nu¹tai²na² Txa²wã¹sũ̱³na² kwa³na³te³nah¹lxi¹: — Wxa²ki³lha³lxa² a²hxi²kan¹te²nãu³xa² ten³sa³nhai¹. Nxe³te²nãu³xa² txa²sa³wi³ha³lxi³nãu³si²tu¹wi¹. Ãh¹lxi³sxã³ kwa³sxa³xa² ki³ha¹li¹ kwa³jan³ta² kwa³sxa³xai²la³ ta̱³nxa² sa³wxe³nãn¹te²la³ ta̱³nxa² nxex3sxã³ tẽ³sxã³ Txa²wã¹sũ̱³na² sxi²nhãu³ai²na² ũ³hũ¹sẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nxa²ha¹te¹ nxe³ain¹tãu³a² a²nũ²a² Si³me³ãu²ah³la² Je³ru³sa³lẽ²thĩ³na² yxau²xai³ta¹hxai²hẽ¹la². A²nxe³jah¹lai²li² Txa²wã¹sũ̱³na² wãn³txa² wi¹lhin¹sxã³ wet1ta¹hxai²hẽ¹la². Te²yã¹nxe³sxã³ I³sa³e² nũ̱³ka̱³txa² A²hxi²kan¹jah¹la² Txa²wã¹sũ̱³na² hxi²ka² wxã³jah¹la² kãin² wah³nxain¹ta¹hxai²hẽ¹la². A²nxe³jah¹lai²li² Txa²wã¹sũ̱³na² A²yãu³ka³txa² ã³si³tẽ³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ã³si³tẽ³kxi²sxã³ nxe³te³nah¹lxi¹: — Si³me³ãu²ah³lãi³. Hĩ¹na² wa³su³txi³ ya³lu¹nxã²nxa³lho³li¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la² ĩ²sã²nĩn¹tu¹wi¹. Yan¹nãu³a¹ sa²kxai³lu¹ ya²lun¹ju³ta² yũ³tu¹wi¹. Nxe³jau³xai²na² ĩ³hen³txi³nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ai¹nha²kxai³ Txa²wã¹sũ̱³na² Yãu³ka³txa² ã³si³tẽ³kxi²sxã³ Si³me³ãu²ah³la² ai³ya³sxã³ Txa²wã¹sũ̱³na² sxi²ha² ã³wih¹ya³ta¹hxai²hẽ¹la². Nxe³tãu³ãn²tu̱³ti¹ a²wẽ³sãi¹ah³la² a²hã³ka³nai²na² nxe³sxã³ Je³su²jah³la² sa²ha³lxo¹so¹sxã³ wxã³ain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² Moi³se²ah³lu¹tai²na² wãn³txa² we¹te³lhxã³ ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nxa²ha¹te¹ Si³me³ãu²ah³la² sa²kxai³lu² wẽ³sa² sa²ha²lxo¹so¹kxi²nũ²la² Txa²wã¹sũ̱³na² ĩ³sa²nẽn¹kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","Nxe³te³nah¹lxi¹: — Sũ̱³na² nxe³txi¹. Wãn³txa² ĩ³ye³kxi²san¹jau³xai³tã² hĩ¹na² ta³lun²ye¹tu¹ti²tu³wi¹. Nxe³ju³ta² wxa²hxi²kan¹jah¹la² txa²yen³nãu³a² ĩ²a¹wi¹. Nxe³jah¹la² kxã³nxa² ũ³yhe³kxũ¹sa²nhĩn¹jah¹la² a²nũ²a² yxo²ha³kxa¹ ĩ²ain¹tu¹wi¹. A²nxe³jah¹la² I³sa³e² nũ̱³ka̱³txi³sxa³te²nãu³xa² a²yxo²ha³kxa¹ wxa²wãn³txa² ĩ³hen³txi³nyhai¹nha²kxai³ I³sa³e² nũ̱³ka̱³txa² Txa²wã¹sũ̱³na² kãin²si¹hain¹jau³su² ĩ²hen³txai¹nha²kxai³ nxe³ain¹tu¹wi¹. Ai¹nha²kxai³ ya³lu²na¹ju³ta² hĩ¹na² wi¹na³li¹. Ka³lih³khaix1sa³nha²wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ĩ³ye³ta³lun²nxa²ha¹te¹ a²wĩ³na² a²hã³ka³na² whãi²na¹ wãn³txai²na² ain³kxai¹nha²kxai³ o²lya³ta¹hxai²hẽ¹la². O²lya³te³nah¹lxi¹: — Ĩh¹nxe³te²la¹ku². Ki̱³nhai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Nxa²ha¹te¹ Si³me³ãu²ah³lai²na² wãn³txi³kxai³lu¹: — Nxe³jah³wxi¹. Txa²wã¹sũ̱³na² wi¹lhin¹ti³hi¹txa²ti³na³li¹. Nxe³jau³su² e³sãn²ka³tu̱³ Ma³ri²a³ka³lxa² e³kxi²te³nah¹lxi¹: — Ma³ri²a³ka³lxĩ¹. Wxa²wẽh³sai²li² kxãn³nãu³a² a²nũ²a² I³sa³e² nũ̱³ka̱³txa² ka³na³ka³nat3te²a² ã³kãi²non³si¹ha²kxai³ a²ka³na³ka³nat3te²a² a²kãi²nxa³tot3si¹ha²kxai³ nxe³ain¹tu¹xĩ¹. Nxain¹kxai²nãn²tu̱³ a²nũ²a² ka³lxa¹te²a² sa²yxo²ã³ain¹tũ¹xĩ¹. Nxain¹kxai²nãn²tu̱³ti² a̱u³txi³ ãin²ti³khai¹nxe³nxa²tu¹xĩ¹. A²nxe³jah¹lo²kxai³lu² a²nũ²a² a²ẽ¹nãn¹jau³la³ ĩ³sai¹ai¹nxa³jau³la² wi¹ko̱³nha²hxat3tain¹tu¹xĩ¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nxa²ha¹te¹ nxe³ain¹tãu³ãn²tu̱³ti¹ txu¹ha² A²na³ka³lxa² yxau³nũn³ta¹hxai²hẽ¹la². Nxe³ta¹ka³lxai²na² sa²kxai³lu² a²wĩ³na² Fa³nu³e²lah³lo²su² ha²kxai³ a²ka³lxa¹ti³nãu³xa² A³se²ra³ nũ̱³ka̱³txi³su² ha²kxai³ nxe³ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxa²kxai³lu² kwẽ³kxa² ko³ha¹li¹ ko³ha¹li¹ ko³ha¹li¹ ka³na³ki²tãu³a² in³txa² so¹nyhain¹sxã³ yxau³ya³ta¹hxai²hẽ¹la². Nxe³nũ²la² jah¹la² ya³lu²kxi²ta¹hxai²hẽ¹la². Ya³lu²kxi¹nxa²ha¹te¹ kwẽ³kxa² ka³lxa¹txi³ 84 nxe² kwẽ³kon³tãu³a² nũh¹yxau³ha²kxai³ a̱¹ka³lxon³khaix1nxe³sxã³ kxãn³su² yxau²xai³ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxa²kxai³lu¹ Txa²wã¹sũ̱³na² wi¹lhin¹ju³ta² ĩ³hen³txi³to³ta¹hxai²hẽ¹la². Txa²wã¹sũ̱³na² sxi²ha² wi³xi²ta¹hxai²hẽ¹la². Wi³xi²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Kãin²khaix1nxi¹lxi¹. Nxe² ĩ³ye³sxã³ ã³ti³hex1ta¹ka³lxu²su² nxa³ha²kxai³ yain³txa² ã³na¹ha²kxai³ hãi¹sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jã¹nxe³kxan²ta² Si³me³ãu²ah³lo²kxai³lu² ĩ³ye³ta³lun²kxan²ta² ta¹ka³lxa²kxai³lu² A²na³ka³lxa²kxai³lu² wi³xi²ta¹hxai²hẽ¹la². Wi¹xi²nũ²la² Txa²wã¹sũ̱³na² sa²nẽn¹kxi²ta¹hxai²hẽ¹la². Nxe³jau³xai²na² sa²kxai³lu² Je³ru³sa³lẽ²thĩ³nãn¹tũ̱³ka̱³txa² Sũ̱³na² Hxi²kan¹ta² Si³yxau³jah¹lai²na² wxã³ju³ta²nũ³a² wah³nxain¹te²nãu³xa² a²yxo²ha³kxa¹ ain³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ain¹nxa²ha¹te¹ Moi³se²ah³la² kwa³na³jau³xu¹tai²na² sa²yxo²we¹ta³lu²nain¹nxa²ha¹te¹ Ka³li³le²a²ko³xa² ĩ³ain¹ta¹hxai²hẽ¹la³, Je³su²jah³la² a²wĩ³na² a²hã³ka³nũ¹ta²sa³. A²sxi²yhen³khai³xa² Na³sa³re²thĩ³na² ĩ³xi²sxã³ yxau³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nxe³tãu³a² a²wẽ³sa²kxai³lu² wi¹txo¹ni² nũ³kxũn³txo¹ni² wxi²kan¹sxã³ txo¹ni² nxe³ta¹hxai²hẽ¹la². Nxe³kxa²yu³su² Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Kxã³nhxĩ¹nu¹tai²na² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² I³sa³e² nũ̱³ka̱³txa² ã³non²ta³kxi²ta¹hxai²hẽ¹la². E³ji²ta²ko³xa² a³li³si¹hain¹jau³su² ã³non²ta³kxi²ta¹hxai²hẽ¹la². Nxe³hĩ¹nu¹tai²nãn¹te²tu̱³ kwẽ³kxa² hãi¹nxe³ti³xa¹ ye³ka³na³ka³nat3sxã³ Sũ̱³na² kãi³ũ¹hain¹ju³tu¹tai²na² ĩ³sa²wa²lho¹xain¹ta¹hxai²hẽ¹la². Je³ru³sa³lẽ²thĩ³na² ã³nũn²ta³kxain¹sxã³ ĩ³sa²wa²lho¹xain¹ta¹hxai²hẽ¹la². Nxe³ti³xai²na² sa²kxai³lu² pas²kwa²ti³xa²su¹. Nxe³ta¹hxai²hẽ¹la². Jã¹nxe³ju³ta² Je³su²jah³la² a²wĩ³na² a²hã³ka³nai²na² nxe³ya³sxã³ jã¹nxe³ya³to³ta¹hxai²hẽ¹la². Hã²wxãn³txa³nũ² Je³su²jah³la²kxai³lu² kwẽ³kxa² hxi²ka² hxan³sxã³ ãh¹ ha¹li¹ wxa²sa²so¹xi²nũn³ka³tu̱³ kwẽ³kon³sxã³ txo¹nhĩ¹na¹ a²wĩ³na² a²hã³ka³nai²na² nxe³ya³te²kxai³lu² wẽ³sai²na² ã³sa²so¹sxã³ ai³yain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Nxa²ha¹te¹ ã³sa²wa²lho¹xi²ta³lun²nyhain¹nxa²ha¹te¹ a²wĩ³na² a²hã³ka³na² ĩ³xi²te³lhxã³ a³li³ain¹ta¹hxai²hẽ¹la². Je³su²jah³la² ã³si³tẽ³kxain¹te³ji¹xã¹. Ain¹tah¹lxa¹ hai³txi³ ain¹ta¹hxai²nxa³hẽ¹la². Hãi¹sxã³ Je³ru³sa³lẽ²thĩ³na² yxau³ye²ta¹hxai²hẽ¹la². Nxe³ha²kxai³ a²wĩ³na² a²hã³ka³na² ju¹tai²na² ko̱³nhe²ya³nxa³ha²kxai³ ye³ka³na³ka³nat3sxã³ a³lan²ni²sxã³ a³li³sxã³ ã³nxĩ³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hã²wxãn³txa³ ĩ²xi²ya³hxa³ha²kxai³ hxi²waun³ta³kxi²ya³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ a²nũ̱³ka̱³txa² ã³si³tẽ³kxain¹te²nãu³xa² whãi²na¹ ĩ²ai¹nxa³ha²kxai³ Je³ru³sa³lẽ²thĩ³na² ã³te³nxi²te³lhxã³ wa̱³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wa̱³lain¹nũ²la² ye³ha¹li¹ ka³na³ki¹ a³lan²nũ²la² Txa²wã¹sũ̱³na² sxi²ha² ã³wih¹ka³tu̱³ ĩ²kxain¹ta¹hxai²hẽ¹la². A²kxã³nxa² wa̱³li²sĩ²ai¹nxa³ta̱³lxa¹ jah¹la²kxai³lu² a²hoh³lxa³nũ̱³ka̱³txa² ã³tĩ̱³xi²nũ²la² nxũ²kwa̱i³ye³lot3sxã³ ã³wxe³ta¹hxai²hẽ¹la². Nxe³nũ²la² ain³kxi²nyhu¹ha²kxai³ wãn³txa² ĩ³wã̱³txi³nyhu¹ai¹nha²kxai³ nxe³nyhu¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nxe³nyhu¹ju³tan¹te²kxa³ya̱³lhu² wẽ³sai²na² wãn³txa² ain³kxain¹te²a² on²tain¹ta¹hxai²hẽ¹la², Je³su²jah³lai²na² wãn³txa² wxi²kan¹jau³su² ha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jã¹nxe³kxan²ta² a²wĩ³na² a²hã³ka³na² nxe³ya³sxã³ Txa²wã¹sũ̱³na² sxi²nhãu³ai²na² ã³wih¹sxã³ ĩ²ai¹nha²kxai³ kãin² o²lai¹nha²kxai³ ta¹ka³lxa² ĩ³ye³kxi²te³nah¹lxi¹: — Wẽ³sãi³. Ĩh¹nxe³nhĩn¹thai¹li¹? Kãin² ã³ten³nxa²nha¹hẽ³li¹. Hxi²waun³txi³khaix1sa²sĩ¹nhẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ten³sya¹hin¹thai¹ni¹? Txa²wĩ³na² sxi²ha² ã³wih¹sxã³ ã³wxe³na¹ha²kxai³ ĩ²sya¹hxan³thai¹ni¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nxa²ha¹te¹ jau¹xai²na² a³la³kxi²ti³hex1ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ã³si³tẽ³kxi²sxã³ Na³sa³re²thĩ³na² ĩ³xi²sxã³ yxau³ain¹to³ta¹hxai²hẽ¹la². A²wĩ³na² a²hã³ka³na² wãn³txa² yxo²ha³kxa¹ we¹ta¹hxai²hẽ¹la². A²nxe³ju³tai²li² a²hã³ka³na² a²ẽ¹nãu³ai²na² a̱in³so¹tu³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² wi¹txo¹ni² wxi²kan¹to³ni² nxe³ye²ta¹hxai²hẽ¹la². Nxe³kxa²yu³su² Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²ai¹nha²kxai³ a²nũ²a² yxo²ha³kxa¹ ka³li³lhi³sxã³ ĩ²ai¹nha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","3","Ju¹ta³la³ nxe³ha²kxai³ Ti³be³ri²ah³lai¹tã² Ro³ma²no²ko³xa² kãin²ko³xa² ã³wẽ̱³non³sxã³ ã³wa³li³khan³tot3ta¹hxai²hẽ¹la². Kwẽ³kxa² ka³lxa¹ton³nũ²la² 15 nxe² kwẽ³kon³nũ²la² Jo³ãu² Ba³tis²jah³la²kxai³lu² ha³lo²ai²li² a²nũ²a² yxau³ai¹nxa³ko³xa² ho³tãu³a² Txa²wã¹sũ̱³na² hi²sen³su² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Nxe³jah¹la² Sa³ka³ri²ah³la² ki³lha³lhxu² ta¹hxai²hẽ¹la². Jã¹nxe³hĩ¹nai³tã² Ju³te²a²ko³xa² Põn³si³o³ Pi³la²jah³la² a²wa³li³kha³lah³lo²lo³tha²kxai³ Ka³li³le²a²ko³xa² E³ro²jah³la² a²wa³li³kha³lah³lo²lo³tha²kxai³ I³te³ri²a²ko³xa² Tra³ko³ni²ta³ko³xa² ko³ha¹lin¹ko³xa² Fi³li²pah³la² a²wa³li³kha³lah³lo²lo³tha²kxai³ nxe³jah¹la² E³ro²jah³la² a²lon³syhe²nyha¹ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ A³bi³le²nã²ko³xa² Li³sa³ni²ah³la² a²wa³li³kha³lah³lo²lo³tha²kxai³ nxe³ta¹hxai²hẽ¹la². Nxe³hĩ¹na² Txa²wã¹sũ̱³na² sxi²ha² Kai³fa²sah³lai¹tã² A³na²sah³lai¹tã² nxe³sxã³ sa²hau³ko³tain¹ta¹hxai²hẽ¹la². Jã¹nxe³tãu³ãn²tu̱³ti¹ Jo³ãu² Ba³tis²jah³lo²kxai³lu² Jor³tãu²yau³xan¹ko³nãu³a² ai³lha²thet3ta¹hxai²hẽ¹la². Yuh³xan¹ta² ha³lo²a² whãi²na¹ ai³lha²thet3te³na¹ a²nũ²a² ka³lxa¹txi³ ã³yã³nũ²kxain¹ta¹hxai²hẽ¹la². Ã³yã³nũ²kxain¹nũ²la² Jo³ãu² Ba³tis²jah³la²kxai³la¹ ĩ³hen³txain¹te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² yũ³khaix1yah³lxi¹lxi¹. Yxah³lxi¹nha²kxai³ ĩ³ãin²ta³kxi¹nyha¹jah¹lxi³hẽ¹li¹. Nxe³nyhah¹lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² hi²sen³su² ko̱³nxe³ti³ kãi³yah³lxin¹kxa² wah³xa² sa²wa²su¹txa²ti³tu¹wi¹. Nxe³nyhah¹lxin¹ju³tan¹te²kxa³ya̱n³tu̱³ta¹ ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹si¹ha¹jau³su² ã³tĩ̱³kxi¹sah¹lxi³hẽ¹li¹. Jo³ãu² Ba³tis²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nxe³jut3su² I³sa³i²ah³lu¹tai²na² kxã³nxa² ũ³wha²li¹txã³nxu¹tai²na² nxe² e³te³nah¹lxi¹: — A²nũ²a² ã̱³jah¹la² wxã³tu¹wi¹. Ha³lo²ai²na² a²nũ²a² yxau³ai¹nxa³ko³nãu³a² ai³sxã³ ĩ³ye³kxi²tu¹wi¹. Ĩ³ye³kxi²te³nah¹lxi¹: “A²nũ²a² hxi²kan¹jah¹lo²su² wxã³ju³ta²nũ³a² yũ³kxai²nãn²tu̱³ ã³wxã³tĩh³nũ³a² wxa²hau³ko³tain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wain³tĩh³na² a³li³ha²kxai³ tĩh³na² kĩn³sxih²ju³ta² ĩ³wau³waut3sxi²ha²kxai³ tĩh³na² ka²yãu¹ka²yãu¹ju³ta² ĩ³ha³la³tu³la³kxi²ha²kxai³ tĩh³na² yax3lũ¹yax3lũ¹si¹ju³ta² sa²ne³ka³tũ²si²ha²kxai³ nxe³te²ju²hẽ³li¹. A²nxe³jut3su² tĩh³na²nũ³a² wa³su³hĩ̱³te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³sxã³ Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹la² wxã³ju³ta²nũ³a² wxa²ẽ¹nãu³ai²na² wxa²hau³ko³nha¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nxe³ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² yxo²ha³kxa¹ Txa²wã¹sũ̱³na² hxi²ka¹nain¹ju³ta² ĩ²ain¹tu¹wi¹. Nxe³sxã³ ko̱³nxe³ti³ kãi³ain¹ju³ta² ĩ³ãin²ta³kxi²nha²sxã³ Sũ̱³na² wãn³txa² yxo²ĩ²ain¹kxai²nãn²tu̱³ a²ẽ¹na² sa²hau³ko³tũ¹hain¹tu¹wi¹. Nxe³ju³ta² ĩ²ain¹tu¹wi¹. Ya²la³tu̱³ wxã³ti³wa³ki³lxon³na³li¹.” Nxe³jau³su² ĩ³ye³kxi²tu¹wi¹. I³sa³i²ah³lu¹ta²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nxa²ha¹te¹ a²nũ²a² ĩ̱³yau³xa² ũ³hũ̱¹kxi²sa²sai¹ju³ta² a²ten³te²nãu³xa² ka³lxa¹txi³ wxã³ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Jo³ãu² Ba³tis²jah³la² ĩ²ain¹te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Txa²wã¹sũ̱³nai²li² a̱n³txi¹nx2ti³na³li¹. Nxe³sxã³ wxa²ẽ¹nãn¹jau³su² nxe³nyha¹lxin¹te³nah¹lxi¹: “Ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹sain¹kxai²nãn²tu̱³ wi¹lhin¹yex1sain¹tũ¹xã¹, a²nũ²a² yxo²ha³kxa²su¹.” Nxe³nyhah¹lxin¹kxan²ti³ ti³he¹nxe³nx2ti³xa³wi¹. Nxe³sxã³ wi¹lhin¹ki³lxo³jah³lxin¹kxan²ti³ Txa²wã¹sũ̱³nai²li² ĩ³ki³ha¹kxi²yah³lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","9","Nxe³ha²kxai³ wxa²ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ya²la³tu̱³ ã³yah³lxin¹kxai²nãn²tu̱³ wi¹lhin¹yah³lxin¹ju³ta² wã²nã³ũ¹sah¹lxi³hẽ¹li¹. Jã¹nxe³ju³kxai³lu² hi³a³ ne³ka² ĩ²li³hxa³te²la³ wi¹nã̱³kxi²nxa³kxai²nãn²tu̱³ a²nũ²a² hxi²ka² ĩ³tau³ka²tã³sãn²nũ²la² ha³nxe²a² yat3sxã³ hxa³te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³sxã³ wi¹kãi³yah²lxan³kxai²nãn²tu̱³ ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³tu¹wi¹. A²nxe³ju³kxai³lu²: “A³bra³ãu²ah³lu¹tai²na² a²ne³tah²nãu³su² sĩn¹te²sa¹wi¹.” Yah³lxin¹jau³xa² e³yah³lxi³txa³hẽ¹li¹. E³yah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² hi²sen³su² txah³lxa³kxa² tẽ³sxã³ A³bra³ãu²ah³lu¹tai²na² a²ne³tah²nãu³su² wet1ti³hit1ju³ta² hxi²kan¹na³li¹. Nxe³ye¹nx2ta¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nxa²ha¹te¹ tũ̱¹ka̱³txai²na² wãn³txi³kxai³lu¹: — Nxe³kxai²nãn²tu̱³ ĩh¹nxet3sxã³ o²la³kxi²sĩn¹te³la¹ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — A²nũ²ai²li² a²ha³la³san¹ka³lo³a² ka³lo³ha¹li¹ yũ³yah³lxin¹kxai²nãn²tu̱³ ka³lo³ka³na³ka³nat3sxã³ tẽ³sxã³ a²nũ²a² a²ha³la³san¹ka³lo³la³ yũ²nxa³te²a² wã²nhũ¹txai¹yah³lxi³hẽ¹li¹. Te²yã¹nxe³sxã³ yain³txa² wã²nhũ¹txai¹yah³lxi³nũ³nhẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nxa²ha¹te¹ in³txa² ũ³yho³hi²ki̱³ka² so¹kxi²nẽ³tũ̱³ka̱³txa² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹ju³ta² te³nai¹nha²kxai³ yxau³so³nain¹ta¹hxai²hẽ¹la². Nxe³tũ̱³ka̱³txa² hi²sen³su² ro³ma²no² ũ³yho³hi²txã³nxa² sa²so¹xai³lain¹ta¹hxai²hẽ¹la². I³sa³e² nũ̱³ka̱³txa² sa²so¹xai³lain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²li² ya̱u³so³nain¹nũ²la² ĩ³ye³kxain¹te³nah¹lxi¹: — Hxi²kan¹jah¹lãi³. Txai²nãu¹xai²na² ĩ̱³yau³xa² ũ³hũ̱¹kxi²sa²sai¹sa²nhĩn¹te³lhxã³ ĩh¹nxe² o²la³kxi²sĩn¹te³la¹ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nxa²ha¹te¹ ĩ³ye³kxain¹te³nah¹lxi¹: — A²yo³ha² wain³txã³nxa² so¹lxi¹ so¹kxi²txai¹yah³lxi³hẽ¹li¹. Wain³ta² a²yo³ha² ã³sen³sai¹te²la³ so¹kxai¹yah³lxi³txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nxa²ha¹te¹ so³ta²to² nũ̱³ka̱³txa² ĩ³wã̱³txi³ti³an¹jau³kxai³lu¹: — Txa²nũ̱³ka̱³txi³nãu³xa²sa¹. Ĩh¹nxe³sxã³ o²la³kxi²sĩn¹te³la¹ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — Nũ̱³kxũn³txi³ yen³kxa² sa²so¹kxai¹yah³lxi³txa³hẽ¹li¹. Yah³lxi¹nha²kxai³ a²nũ²a² ko̱³nxe³te²lo³jah³lxi³txa³hẽ¹li¹. Yah³lxi¹nha²kxai³ yen³kxa² ũ³yho³hi²nxa²lxain¹txã³nxa² hãi¹sxã³ ĩ³ka³li³jah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nxa²ha¹te¹ a²nũ²a² ya³lo³txi²sxã³ ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Jah¹lai²li² Txa²wã¹sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lo³jah¹lo¹la³te²la¹ku². Ki̱³nhai¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nxa²ha¹te¹ a²nũ̱³ka̱³txa² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²si³yo³na² a²nũ²a² hxi²kan¹txi³ wa³to²hi²sa²jah¹la² wxã³tu¹wi¹. Wxã³te³na¹ hxi²kan¹txi³ wa³to²hi²sa³ha²kxai³ a²yu³kxa² yu³wi²kxi²nha²ka³lo³a² sa²ta²la³kxi²nũ¹ha¹kxe³su² hxi²ka¹nhĩ̱²nxa³nha²wi¹. Nxe²nxa³ha²kxai³ ĩ̱³yau³xa² ũ³hũ̱¹kxi²sa²sai¹nx2ta¹ju³ta² hxi²ka¹nhĩ̱³na¹wi¹. Txa²si³yo³na² wxã³jah¹lai²na² sa²kxai³lu² Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² ũ³hũ¹nx2ti³ha²kxai³ wxa²ẽ¹nãu³ai²na² ã³nhxan³ka²ti³nx2ti³ha²kxai³ nxe³jah¹lo²su² na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jã¹nxe³kxe³hũ̱³nxe² hai³sxa² wa³kxẽn³yah³lai²na² hai³sxa² wi¹we¹nha²kxai³ ki³kan²tãu³a² yain³ta³ki³a² wxa²so¹te²ju²hẽ³li¹. Wxa²so¹kxai²nãn²tu̱³ wã³na³la³ka³lo³a² hxi²tẽ³nha²sxã³ yain³txa³ki³a² ĩ³ya³lan³kxi²xai³te²ju²hẽ³li¹. Ĩ³ya³lan³kxi²nũ²la² yain³ta³ki³a² a²wi¹ki³a² so¹sxã³ ũ³wha¹ha²kxai³ a²ka³lo³a² ã³na¹sxã³ sa²ya̱t3sa²ha²kxai³ nxe³ki̱³te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³sxã³ a²nũ²a² wi¹lhin¹te²nãu³xa² oh³nãu³nũ¹ka³nãn¹ko³xa² ũh³wxe³ũh¹hai¹nha²kxai³ a²nũ²a² ĩ³lxa³thi¹nxa³te²a² yuh³nãn¹ta³ko³xa² ha³lo²a² i̱³sa²tẽ³ko³xa² ã³na¹kxai¹nha²kxai³ nxẽn³tain¹tu¹wi¹. Jo³ãu² Ba³tis²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A²nxe³jau³xa² wi¹jau³xa² yau³ka³lxa¹txi³ Sũ̱³na² wãn³txa² ĩ³hen³txi³sxã³ e³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nxa²ha¹te¹ Jo³ãu² Ba³tis²jah³lo²nu¹ta²kxai³lu² E³ro²jah³la² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Ĩ³ye³kxi²te³nah¹lxi¹: — E³ro²jah¹lãi³. Wxãi²na² ko̱³nxe³thin¹khaix1ni¹lxi¹. E³ro³ti²a³ka³lxa² so¹kxi²nyha¹hin¹ju³ta² ko̱³nxe³ti³ kãi³ju³tai²la¹wi¹. Wxa²lon³yah³la² a²sxe³xai²la¹wi¹. Nxe³ha²kxai³ wxãi²na² so¹kxi²nyha¹hin¹ju³ta² ko̱³nxe³ti³ kãi³ju³tai²la¹wi¹. Ta¹hxai²hẽ¹la². Nxe³ain¹kxan²ti³nũ¹ sa²yxo²we¹tai¹nxa³ha²kxai³la¹ ko̱³nxe³ti³ o²la³kxi² kãi²non³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jã¹nxe³kxa²yu³kxai³la¹ kxã³ta³lon³tãu³a² E³ro²jah³la² hi²sen³kxai³lu² Jo³ãu² Ba³tis²jah³lo²kxai³ sa²so¹sxã³ sxi²ha² kxan²thĩ³na² ũ³tĩ̱¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nxa²ha¹te¹ ũ³tĩ̱¹kxai¹nxa³ta̱³lxa¹ Jo³ãu² Ba³tis²jah³la²kxai³ a²nũ²a² ĩ̱³yau³xa² ũ³hũ̱¹kxi²sa²sai¹ta³lun²nũ²la² Je³su²jah³la² ĩ̱³yau³xa² ũ³hũ̱¹kxi²sa²sai¹nũn³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ũ³hũ̱¹kxi²sa²sai¹nxa²ha¹te¹ Je³su²jah³la²kxai³la¹ Txa²wã¹sũ̱³na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Nxe³tãu³a¹ oh³sĩ̱n³na² sa²yxo²hai¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Sa²yxo²hai¹ka³tu̱³ kwa³sxa³xa² hũ̱³nxe² Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² oh³nãu³a² a³ka³nxi²xi²ye²ka³tu̱³ Je³su²jah³lai²na² a²ka³la³ki²wxe²kxi²ta¹hxai²hẽ¹la². Ain¹tãu³ãn²tu̱³ti¹ oh³nãu³an¹te²a² wãn³txa² ain³kxain¹ta¹hxai²hẽ¹la². Ain³kxain¹te³nah¹lxi¹: — Wxãi²li² txa²ki³lha³lxa²khai³si¹lxi¹. A³lxi¹nxa²ha¹kxah³lo²si¹lxi¹. Wi¹lxo³kxi²khaix1san¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nxa²ha¹te¹ Je³su²jah³la² hi²sen³kxai³lu² a²wah³ka³li³yu³ta² ãn³si³wxe³ta¹hxai²hẽ¹la². A²nxe³jah¹lai²li² Jo³se²ah³la²ki³lha³lxin²tai¹. Ain¹ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ Je³su²jah³la² sa²kxai³lu² kwẽ³kon³sxã³ 30 nxe² ye³ka³lxa¹txi³ kwẽ³kon³sxã³ wa³ka³li³yu³ta² ã³si³wxe³ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ Jo³se²ah³la² wĩ³nu²tu̱³ E³li²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","E³li²ah³la² wĩ³nu²tu̱³ Ma³ta²jah³lo²su² ta¹hxai²hẽ¹la². Ma³ta²jah³la² wĩ³nu²tu̱³ Le³vi²ah³lo²su² ta¹hxai²hẽ¹la². Le³vi²ah³la² wĩ³nu²tu̱³ Me³ki²ah³lo²su² ta¹hxai²hẽ¹la². Me³ki²ah³la² wĩ³nu²tu̱³ Ja³nai²ah³lo²su² ta¹hxai²hẽ¹la². Ja³nai²ah³la² wĩ³nu²tu̱³ Jo³se²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jo³se²ah³la² wĩ³nu²tu̱³ Ma³ta³ti²ah³lo²su² ta¹hxai²hẽ¹la². Ma³ta³ti²ah³la² wĩ³nu²tu̱³ A³mo²sah³lo²su² ta¹hxai²hẽ¹la². A³mo²sah³la² wĩ³nu²tu̱³ Na³ũ²ah³lo²su² ta¹hxai²hẽ¹la². Na³ũ²ah³la² wĩ³nu²tu̱³ Es³li²ah³lo²su² ta¹hxai²hẽ¹la². Es³li²ah³la² wĩ³nu²tu̱³ Na³ka³i²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Na³ka³i²ah³la² wĩ³nu²tu̱³ Ma³a³te²ah³lo²su² ta¹hxai²hẽ¹la². Ma³a³te²ah³la² wĩ³nu²tu̱³ Ma³ta³ti²ah³lo²su² ta¹hxai²hẽ¹la². Ma³ta³ti²ah³la² wĩ³nu²tu̱³ Se³me³i²ah³lo²su² ta¹hxai²hẽ¹la². Se³me³i²ah³la² wĩ³nu²tu̱³ Jo³se²ah³lo²su² ta¹hxai²hẽ¹la². Jo³se²ah³la² wĩ³nu²tu̱³ Jo³ta²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jo³ta²ah³la² wĩ³nu²tu̱³ Jo³ã³nã²ah³lo²su² ta¹hxai²hẽ¹la². Jo³ã³nã²ah³la² wĩ³nu²tu̱³ Re³sa²ah³lo²su² ta¹hxai²hẽ¹la². Re³sa²ah³la² wĩ³nu²tu̱³ So³ro³ba³be²lah³lo²su² ta¹hxai²hẽ¹la². So³ro³ba³be²lah³la² wĩ³nu²tu̱³ Sa³la³ti³e²lah³lo²su² ta¹hxai²hẽ¹la². Sa³la³ti³e²lah³la² wĩ³nu²tu̱³ Ne³ri²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ne³ri²ah³la² wĩ³nu²tu̱³ Me³ki²ah³lo²su² ta¹hxai²hẽ¹la². Me³ki²ah³la² wĩ³nu²tu̱³ A³ti²ah³lo²su² ta¹hxai²hẽ¹la². A³ti²ah³la² wĩ³nu²tu̱³ Ko³sã²ah³lo²su² ta¹hxai²hẽ¹la². Ko³sã²ah³la² wĩ³nu²tu̱³ E³ma³tã²ah³lo²su² ta¹hxai²hẽ¹la². E³ma³tã²ah³la² wĩ³nu²tu̱³ E²rah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","E²rah³la² wĩ³nu²tu̱³ Jo³su³e²ah²lo²su² ta¹hxai²hẽ¹la². Jo³su³e²ah³la² wĩ³nu²tu̱³ E³li³e²sah³lo²su² ta¹hxai²hẽ¹la². E³li³e²sah³la² wĩ³nu²tu̱³ Jo³rĩ²ah³lo²su² ta¹hxai²hẽ¹la². Jo³rĩ²ah³la² wĩ³nu²tu̱³ Ma³ta²jah³lo²su² ta¹hxai²hẽ¹la². Ma³ta²jah³la² wĩ³nu²tu̱³ Le³vi²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Le³vi²ah³la² wĩ³nu²tu̱³ Si³me³ãu²ah³lo²su² ta¹hxai²hẽ¹la². Si³me³ãu²ah³la² wĩ³nu²tu̱³ Ju³ta²ah³lo²su² ta¹hxai²hẽ¹la². Ju³ta²ah³la² wĩ³nu²tu̱³ Jo³se²ah³lo²su² ta¹hxai²hẽ¹la². Jo³se²ah³la² wĩ³nu²tu̱³ Jo³nã²ah³lo²su² ta¹hxai²hẽ¹la². Jo³nã²ah³la² wĩ³nu²tu̱³ E³lya³kĩ²mah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","E³lya³kĩ²mah³la² wĩ³nu²tu̱³ Me³le³a²ah³lo²su² ta¹hxai²hẽ¹la². Me³le³a²ah³la² wĩ³nu²tu̱³ Me³na²ah³lo²su² ta¹hxai²hẽ¹la². Me³na²ah³la² wĩ³nu²tu̱³ Ma³ta³ta²ah³lo²su² ta¹hxai²hẽ¹la². Ma³ta³ta²ah³la² wĩ³nu²tu̱³ Na³tã²ah³lo²su² ta¹hxai²hẽ¹la². Na³tã²ah³la² wĩ³nu²tu̱³ Ta³vi²yah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ta³vi²yah³la² wĩ³nu²tu̱³ Je²sah³lo²su² ta¹hxai²hẽ¹la². Je²sah³la² wĩ³nu²tu̱³ O³be²jah³lo²su² ta¹hxai²hẽ¹la². O³be²jah³la² wĩ³nu²tu̱³ Bo³a²sah³lo²su² ta¹hxai²hẽ¹la². Bo³a²sah³la² wĩ³nu²tu̱³ Sa²lah³lo²su² ta¹hxai²hẽ¹la². Sa²lah³la² wĩ³nu²tu̱³ Na³sõ²mah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na³sõ²mah³la² wĩ³nu²tu̱³ A³mi³na³ta²bah³lo²su² ta¹hxai²hẽ¹la². A³mi³na³ta²bah³la² wĩ³nu²tu̱³ A³ta³mi²ah³lo²su² ta¹hxai²hẽ¹la². A³ta³mi²ah³la² wĩ³nu²tu̱³ A³nhi²ah³lo²su² ta¹hxai²hẽ¹la². A³nhi²ah³la² wĩ³nu²tu̱³ Es³rãu²ah³lo²su² ta¹hxai²hẽ¹la². Es³rãu²ah³la² wĩ³nu²tu̱³ Pe³re²sah³lo²su² ta¹hxai²hẽ¹la². Pe³re²sah³la² wĩ³nu²tu̱³ Ju³ta²ah³lo²su² ta¹hxai²hẽ¹la². Ju³ta²ah³la² wĩ³nu²tu̱³ Ja³ko²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ja³ko²ah³la² wĩ³nu²tu̱³ I³sa²kah³lo²su² ta¹hxai²hẽ¹la². I³sa²kah³la² wĩ³nu²tu̱³ A³bra³ãu²ah³lo²su² ta¹hxai²hẽ¹la². A³bra³ãu²ah³la² wĩ³nu²tu̱³ Te³ra²ah³lo²su² ta¹hxai²hẽ¹la². Te³ra²ah³la² wĩ³nu²tu̱³ Na³ko²rah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na³ko²rah³la² wĩ³nu²tu̱³ Se³ru²kah³lo²su² ta¹hxai²hẽ¹la². Se³ru²kah³la² wĩ³nu²tu̱³ Ra³ka³u²ah³lo²su² ta¹hxai²hẽ¹la². Ra³ka³u²ah³la² wĩ³nu²tu̱³ Fa³le²kah³lo²su² ta¹hxai²hẽ¹la². Fa³le²kah³la² wĩ³nu²tu̱³ E³pe²rah³lo²su² ta¹hxai²hẽ¹la². E³pe²rah³la² wĩ³nu²tu̱³ Sa²lah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sa²lah³la² wĩ³nu²tu̱³ Kai³nã²ah³lo²su² ta¹hxai²hẽ¹la². Kai³nã²ah³la² wĩ³nu²tu̱³ A³fa³sat2jah³lo²su² ta¹hxai²hẽ¹la². A³fa³sat2jah³la² wĩ³nu²tu̱³ Se²mah³lo²su² ta¹hxai²hẽ¹la². Se²mah³la² wĩ³nu²tu̱³ No³e²ah³lo²su² ta¹hxai²hẽ¹la². No³e²ah³la² wĩ³nu²tu̱³ La³ma²kah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","La³ma²kah³la² wĩ³nu²tu̱³ Me³tu³sa³lẽ²ah³lo²su² ta¹hxai²hẽ¹la². Me³tu³sa³lẽ²ah³la² wĩ³nu²tu̱³ E³no²kah³lo²su² ta¹hxai²hẽ¹la². E³no²kah³la² wĩ³nu²tu̱³ Ja³re²jah³lo²su² ta¹hxai²hẽ¹la². Ja³re²jah³la² wĩ³nu²tu̱³ Ma³la³le²lah³lo²su² ta¹hxai²hẽ¹la². Ma³la³le²lah³la² wĩ³nu²tu̱³ Kai³nã²ah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kai³nã²ah³la² wĩ³nu²tu̱³ E³no²sah³lo²su² ta¹hxai²hẽ¹la². E³no²sah³la² wĩ³nu²tu̱³ Se²tah³lo²su² ta¹hxai²hẽ¹la². Se²tah³la² wĩ³nu²tu̱³ A³tãu²ah³lo²su² ta¹hxai²hẽ¹la². Nxe³jah¹la² Txa²wã¹sũ̱³na² hi²sen³su² wã²nxũ̱h¹wet1ta¹hxai²hẽ¹la³, a²hã³ka³na² a²wĩ³na² yũ²nxa³ha²kxai³la². Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jã¹nxe³kxan²ta² Je³su²jah³la²kxai³lu² Jor³tãu²yau³xa² a³li³nũ²la² ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³xa² ai³lha²thet3ta¹hxai²hẽ¹la². Txa²wã¹sũ̱³na² Yãu³ka³txa² hi²sen³su² nxũ²kwa̱i³yxau³sa²tẽ³ha²kxai³ ã³si³tẽ³kxi²ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³tih³nxe³sxã³ ã³so¹xai³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nxe³nyhai¹nhĩ¹na² Sa³ta³na²jah¹la² wxã³nũ²la² Txa²wã¹sũ̱³na² a²ten³jau³su² sa²yxo²ã³ ĩ³wa³ka³nxe³sain³si¹ta¹hxai²hẽ¹la². A³lan²ta² ye³ka³lxa¹txi³sxã³ 40 nxe² ye³ka³lxa¹txi³ a³la²ni²ta¹hxai²hẽ¹la². Nxe³tãu³a² yain³txa² kwa² ã³na¹ha²kxai³ he³ha² yxau³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nxa²ha¹te¹ Sa³ta³na²jah¹la²kxai³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²wã¹sũ̱³na² Tah²su² nxĩ¹nha²kxai³ txah³lxa³kxa² tẽ³sxã³ yain³txa³nũ̱³xa² wxa²ya¹ta²sxã³ wxa²wet1txa²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Kwa²nxi¹lxi¹. Txa²wã¹sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1 jau³xu¹tai²na² nxe³te³nah¹lxi¹: “Yain³txi³khai³xa² so¹lxi³ yain³sxã³ yxau²xai³yah³lxi³txa³hẽ¹li¹. Txa²wã¹sũ̱³na² wãn³txa² hãi¹nxe³ti³jau³xa¹ wet1yxau²xai³jah¹lxi³hẽ¹li¹.” Ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","7","Nxa²ha¹te¹ Sa³ta³na²jah¹la² hi²sen³su² Je³su²jah³la² sa²so¹sxã³ wã³la² kĩ³khai¹nxe³ka³txa² ũh³wxe³kxi²ta¹hxai²hẽ¹la². Nxe³tãu³a² ha³lo²ai²li² yxo²ha³kxa¹ yuh³xan¹ta² nũ̱³ka̱³txi³nãu³xa² a²yxo²ha³kxa¹ a²kwẽn¹tai²na¹ wã²nã³ũ¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ko¹xai²na² yxo²ha³kxa¹ txa²ha³lo²su² tai¹tu³wi¹. Txai²na¹xai²na² ha³lo²a² a²wa³kxẽn³su²na¹tai¹tu³wi¹. Nxe³ha²kxai³ ha³lo²ai²na² a²nũ²a² ã̱³xa² ũh³wxe³ai¹na¹ju³ta² hxi²ka¹na¹wi¹. Ai¹na¹ha²kxai³ txa²yu³hẽ³na² sa²yxo²we¹je²san¹kxe³su² ã³ka³tih³wxe¹sẽ¹li¹. Nxĩn¹ka³tu̱³ sa²nẽn¹kxi²sa²hẽ³li¹. Nxe³san¹ju³tan¹te²kxa³ya̱n³tu̱³ ju¹tai²li² ũ³hũ²nxa²ha¹tu¹wi¹. A²wa³kxẽn³su²hit1txã²ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Kwa²nxi¹lxi¹. Txa²wã¹sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1jau³xu¹tai²na² nxe³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² Si³yxau³kah³la² Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹la² so¹lxi³ ã³ka³ti³wxe³sxã³ sa²nẽn¹kxi¹txa²hẽ³li¹. Nxe³jah¹la² so¹lxi³ sa²yxo²wet1sxã³ yxau²xai³jah¹lxi³hẽ¹li¹.” Ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nxa²ha¹te¹ Sa³ta³na²jah¹la² hi²sen³kxai³lu² Je³su²jah³la² sa²so¹ã³nũ²la² Je³ru³sa³lẽ²thĩ³na² ã³wih¹nũ²la² Txa²wã¹sũ̱³na² sxi²ha² a²ne³ka³nah²nãu³a² ũh³wxe³kxi²ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³ye³kxi²ti³ãn¹jau³kxai³lu¹: — Je³su²jah³lãi³. Wxãi²na² Txa²wã¹sũ̱³na² Tah²su² nxĩ¹nha²kxai³ a³li²sin³sxã³ ã³ya³hi¹sẽ¹li¹. Nxĩn¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² Si³yxau³jah¹la² a²hxi²ki³kxai³lu² wi¹lhau³ko³txa²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nxĩn¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1jau³xu¹tai²na² yau³xã̱³xai²na² nxe³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² hi²sen³su² oh³xan¹ta² nũ̱³ka̱³txa² wi¹lhau³ko³txa²si¹hain¹jau³su² ĩ³ye³kxain¹na²hẽ³li¹.” ");
INSERT INTO nabNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ãh¹jau³xa²sa¹: “Wi¹lhau³ko³txain¹kxai²nãn²tu̱³ a²hxi²ki³khai³xa² ã³sa²so¹nxain¹tu¹wi¹. Txah³lxa³kxa² sa²tã³yu̱³kxĩh³to³txa²kxa²ya̱n³txi³su² nxe³nxa²ha¹wi¹.” Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nxa²ha¹te¹ Je³su²jah³la² wãn³txi³kxai³lu¹: — Kwa²nxi¹lxi¹. Txa²wã¹sũ̱³na² wãn³txu¹tai²na² jau³xau³hxai²tẽx1 jau³xu¹tai²na² yau³xã̱³xai²na² nxe³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² Si³yxau³jah¹la² Wxa²hxi²kan¹txa² Si³yxau³jah¹la² wi¹la² ã³si³tẽ³kxi²ju³ta² ye²si¹jau³su² wã³nxĩn¹ju³ta² o²la³kxi²sain³txa³hẽ¹li¹.” Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nxa²ha¹te¹ Sa³ta³na²jah¹la²kxai³lu² Txa²wã¹sũ̱³na² a²ten³jau³su² sa²yxo²ã³ ĩ³wa³ka³nxe³sain³si¹jau³xa² e³hxa³tũ²la² hãi¹nxa¹sxã³ ã³waix3tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nxa²ha¹te¹ ye³jen¹nãu³a² Ka³li³le²a²ko³xa² ã³wa̱³li²ta¹hxai²hẽ¹la², Je³su²jah³la²sa³. Nxe³te³na¹ Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² nũ̱³kxũn³txi³ ã³si³tẽ³kxi²ta¹hxai²hẽ¹la². Nxe³jut3su² u²lxi³ ha³ta³nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jã¹nxe³nũ²la² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³nãu³xa² ã³wi¹lha²the³to³ta¹hxai²hẽ¹la². Ã³wih¹nũ²la² Sũ̱³na² wãn³txa² ĩ³hen³txi³ta¹hxai²hẽ¹la². A²nxe³jau³xai²na² ain³kxain¹ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² yxo²ha³kxa¹ sa²nẽn¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nxa²ha¹te¹ Na³sa³re²thĩ³na² txo¹nain¹thĩ³na² ĩ³xi²nũ²la² sa²ba³to³ nxe³hĩ¹na² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² wi²xi²to³hxai²kxai³ jã¹nxe³to³ta¹hxai²hẽ¹la². Nxe³nũ²la² Txa²wã¹sũ̱³na² ũ³wha²li¹txãn³nxa² ĩ³yau¹ũh¹si¹jau³su² ĩ³sa²yxau³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ĩ³sa²yxau³nũ²la² I³sa³i²ah³lu¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lu¹tai²la³ha²kxai³ kxã³nhxĩn¹nũ¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ũ³wha²li¹ta¹hxai²hẽ¹la². Nxe³txã³nxa² ũ³wha²li¹txãn³nxai²li² ũ³hũ¹ain¹nũ²la² sa²hai¹nũ²la² wãn³txai²li² a³txi²sxã³ ĩ³ye³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ĩ³ye³te³nah¹lxi¹: — Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² ã³si³tẽ³kxi²sa²na³li¹. Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² a²nũ²a² ko̱³nxe³te²a² ĩ³hen³txi³te³lhxã³ sa²si¹hã³sain¹na³li¹. Sai¹nha²kxai³ a²nũ²a² ũ³tĩ̱¹kxi²yxau³te²a² wa³su³txi³ a³li³xi²si¹jau³nũ³su² ĩ³hen³txi³ha²kxai³ a²nũ²a² ye³han³te²a² wi¹lĩ²sxã³ wet1si¹jau³nũ³su² ĩ³hen³txi³ha²kxai³ a²wah³ka³te²a² ã³wa²sut1si¹jau³nũ³su² ĩ³hen³txi³ha²kxai³ nxe³ai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Jã¹nxe³sxã³ Txa²wã¹sũ̱³na² hi²sen³kxai³lu² ko̱³nxe³ti³ kãi³kxa² wah³xa² ã³wa²su¹tũ¹hain¹ti³wa³kxa² ya̱u³son³si¹jau³su² ĩ³hen³txai¹na¹tu¹wi¹. Nxe³jau³xa² Je³su²jah³lo²kxai³ ĩ²sxã³ ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nxe² ĩ³ye³ta³lun²nũ²la² ta²nxã¹nxai²na² sa²wa̱³lã̱u²kxi²sxã³ ũ³hũ¹xi²ta¹hxai²hẽ¹la². Nxũ²la² ã³wxe³xi²ta¹hxai²hẽ¹la². Ã³nũ²kxi²tũ̱³ka̱³txa² ain³kxi² yxau²xai³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nxe³ha²kxai³la¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Jau¹xai²na² e³ain¹jau³xu¹tai²li² hĩ¹na² ã³si³wxe²na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nxa²ha¹te¹ a²nũ²a² ain³kxain¹tũ̱³ka̱³txa² wi¹le³ha²kxai³ kwa²on²tain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ nxe²e³kxi²ji¹? Jah¹lai²li² hãi¹sxã³ Jo³se²ah³la² ta²hai²la¹wi¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³jah³lxi³wxi¹. Wãn³txai²na² e³kxi²sah¹lxin¹ta²lu¹wi¹. Nxe³jau³xa²sa¹, wxãi²na² hĩ³ne³kxa² wa³kxẽn³si¹lxi¹. Nxĩ¹nha²kxai³ wã²nxũ̱h¹we¹txi²nhi¹lxi¹. Nxe³jau³xai²na² e³kxi²sah¹lxin¹ta²lu¹wi¹. Ãh¹lxi³jau³xa²sa¹: Ka³far³na³ũ²thĩ³nai²na² wi¹lo²la³kxin¹ju³ta² ain³kxi²sĩ¹na¹hẽ³li¹. Wxa²txo¹nĩn¹thĩ³na² te²yã¹nxe³ we¹txa²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yãn¹tah¹lxi¹ a²nũ²ai²na² Txa²wã¹sũ̱³na² wãn³txa² hen³txi³te²nãn²tu̱³ a²sxi²yhen³khai³xan¹ta³ nũ̱³ka̱³txa² en²tain¹te²ju²hẽ³li¹. Nxe³te²yã¹nxe³sxã³ en²txi³sain¹nũn³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ne³ka²sah¹lxi³wxi¹. Kxã³nhxĩ¹nu¹tai²kxai³lu² E³li²ah³lu¹tai²na² yxau³hĩ¹nũ¹tai²kxai³lu² Ju³te²a² tu¹ha² a²wha³te̱³son³ta¹ka³lxu³nãu³xa² ya²la³tu̱³ ka³lxa¹txi³ yũ³ta¹hxai²hẽ¹li¹. Nxe³ain¹ta¹ ye³ha¹li¹ ka³na³ki¹ ye³kwẽ³kon³ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ha³lo²a² whãi²na¹ wẽh³ha²yau³xa² ã³na¹xa³tãu³a² hai³txi³ Ju³te²a² tu¹ha³ka³lxa² ka³lxa¹kxan²ti³ hai³txi³ ã³non²ta³kxi²te³lhxã³ sa²si¹hã³ũ¹hxa³ha²kxai³ yxãn¹ta¹ Si³tõ²ko³xa² Sa³rep2ta³thĩ³nãn¹ta¹ka³lxa² a²wha³te̱³son³ta¹ka³lxai²na² so¹lxi¹ ã³non²ta³kxi²te³lhxã³ sa²si¹hã³ũh¹ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Te²yã¹nxe³sxã³ E³li³se²ah³la² yxau³hĩ¹nu¹ta²kxai³lu² Ju³te²a² nũ̱³ka̱³txi³nãu³a² a²nũ²a² khon³ta³kxi²sxã³ ka³lã̱un³ta³kxi²sxã³ kãin² ĩ³ton³tain¹ta¹hxai²hẽ¹li¹. Yxãn¹ta¹ hai³txi³ we²txain¹ta¹hxai²nxa³hẽ¹li¹. Yxãn¹ta¹ Na³mãu²ah³la² so¹lxi³ Si²ri³a³ nũ̱³ka̱³txi³su² jah¹lai²na² so¹lxi³ we²txain¹ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nxa²ha¹te¹ wãn³txai²li² ain³kxain¹nxa²ha¹te¹ ã³nũ²kxain¹tũ̱³ka̱³txa² kãin² a̱n³ta³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nxain¹ju³tan¹te²kxa³ya̱³lhu² ĩ³sa²yxau³ain¹nũ²la² Je³su²jah³la² hxi²ki³sa²wa²yat1sa²tã³ha³lo²sai¹ain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ wã³la² ne³ka³nah³nãn¹je³na² sxi²yhe³na² txo³nain¹jen³ka³si²ha²kxai³ ka³la³ain¹nũ²la² Je³su²jah³la² ã³na¹sxã³ a³ka³ti²sxã³ ã³ya²lu¹tũ¹xã¹. Ain¹jau³su² ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ain¹ta¹ hxi²ka¹nain¹ta¹hxai²nxa³hẽ¹la². Nxa²ha¹te¹ Je³su²jah³lo²kxai³lu² a²hãix1tĩh³na² ĩ³ka³nxi²sxã³ ã³waix3ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ĩ³ka³nxi²nũ²la² Ka³far³na³ũ²thĩ³na² Ka³li³le²a²ko³xan¹thĩ³nai²na² ã³wih¹ta¹hxai²hẽ¹la². Ã³wih¹nũ²la² sa²ba³to³ nxa²hĩ¹na¹ a²nũ²a² ã³nũ²kxi²te²a² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ai¹nha²kxai³ ain³kxain¹tũ̱³ka̱³txa² ĩ³yxo²o²lhain¹ta¹hxai²hẽ¹la³, wxi²kan¹txi³ ĩ³ye³kxai¹nha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nxe³ain¹tãu³a² ã³nũ²kxi²thĩ³nãu³ai²na² in³txa² ko̱³nxe³te²a² yãu³ka³txa² kxã³nxa² nxũ²kwa̱i³wih¹ta¹hxai²hẽ¹la². Nxe³jah¹la² ĩ³wxan¹sxã³ kaix1ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Kaix1te³nah¹lxi¹: — Je³su²jah³lãi³. Na³sa³re²thĩ³nãn¹jah¹lo²si¹lxi¹. Ĩh¹nxet3sa²nhĩn¹ji¹wi¹? Sun²tã¹hxat3sa²sĩn¹te³lhxã³ wxã³nhĩn¹ji¹wi¹? Ĩ²nxa²te²sa¹wi¹. Txa²wã¹sũ̱³na² Tah²si¹lxi¹. Ko̱³nxe³ju³ta² yũ³ti³hex1jah¹lo²si¹lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² ko̱³nxe³te²a² yãu³ka³txa² wxi²kan¹txi³ kwa³na³te³nah¹lxi¹: — In³txai²li² ka³nahx2nxe³sxã³ nxũ²kwa̱i³li³txa²hẽ³li¹. Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ko̱³nxe³te²a² yãu³ka³txa² ã³nhẽ¹nhẽ¹yain¹te³na¹ ã³na¹nũ²la² nxũ²kwa̱i³li³ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² in³txai²li² wi¹lain³kxi²xi²ye²ta¹hxai²hẽ¹la². Nxe³jut3su² we¹txain¹ju³ta² a²nũ²a² yxo²ha³kxa¹ ĩ²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nxa²ha¹te¹ a²nũ̱³ka̱³txa² kãin² o²lain¹sxã³ ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Ĩh¹nxe³ju³khai³nxe³hĩn³te²lã¹xã³? Jah¹lai²li² ko̱³nxe³te²a² a²yãu³ka³txa² wxi²kan¹txi³ kwa³na³ha²kxai³ nxũ²kwa̱i³li³ain¹txã²na³li². Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nxe³jut3tai²li² ha³lo²a² u²lxi³ ha³ta³nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² a³li³xi²nxa²ha¹te¹ Si³mãu²ah³la² sxi²ha² ã³nxai³sxã³ ã³wih¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a² a²hã̱i³na¹ka³lxa² kãin² ĩ³hĩ̱¹la³kxi²ha²kxai³ Je³su²jah³la² ĩ³hen³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nxe³ha²kxai³ a²sxan³ka³lo³a² ã³nxai³sxã³ ã³ya̱u³son³kxi²nũ²la² ĩ³ta³ka³txai²na² we²nxi²si¹jau³su² kwa³na³ta¹hxai²hẽ¹la². Nxe³nũ²la² a²kwẽn¹tai²na¹ we²txi²nũ²la² ĩ³sa²yxau³sxã³ yain³txa² hau³kot3sxã³ ũ³hãu¹la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nxa²ha¹te¹ ka³nxa³hi²te³lhxã³ tãu³a² a²nũ²a² ĩ³ta³ka³txa² ĩ³ton³te²a² yxo²ha³kxa¹ sa²so¹nũ²la² Je³su²jah³la² ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² wxa²wai³te²a² a²hãi¹nxe³ti³xa¹ we²txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nxa²ha¹te¹ ko̱³nxe³te²a² a²yãu³ka³txa² kãin² a³li³nũ²la² ĩ³wxan¹sxã³ kaix1jain¹ta¹hxai²hẽ¹la². Kaix1jain¹te³nah¹lxi¹: — Wxãi²na² Txa²wã¹sũ̱³na² Tah²si¹lxi¹. Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹lo²sin¹kxe³su² a³la³kxai¹nha²kxai³ ka³nahx2sxã³ yxau³si¹hain¹jau³su² kwa³na³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nxe³ai¹nha²kxai³ ĩ³yũ¹li²nxa³ta̱³lxa¹ sxi²yhe³na² a³li³xi²nũ²la² ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³xa² nũh¹xai³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Ka³far³na³ũ²thĩ³nãn¹tũ̱³ka̱³txa² ã³nĩ²xi²te³lhxã³ a³li³ain¹ka³tu̱³ hã²wxãn³txa³ ĩ³ha¹txi²nũ²la² a³li³sxã³ ã³waix3si¹hai¹nxa³jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Sxi²yhe³na² yxo²ha³kxa¹ ai³lha²thet3sã²na¹tu¹wi¹. Nxa¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³su² nxe³jau³xa² ĩ³hen³txai¹na¹tu¹wi¹. Nxe³ai¹na¹ju³ta²nũ³su² Txa²wã¹sũ̱³na² sa²si¹hã³sain¹na²hẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nxe³ain¹jut3su² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³nãu³xa² Ju³te²a²ko³xan¹thĩ³nãu³xa² whãi²na¹ ai³lha²thet3tũ²la² Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³hen³txa² ai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hã²wxãn³txa³ ĩ̱³ye³na² Je³ne³sa³re²ye³na² yxo²ka³teh³nãu³a² ai³sxã³ ã³yit1ta¹hxai²hẽ¹la². Nxe³tãu³a² a²nũ²a² ka³lxa¹txi³ Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²te³lhxã³ wxã³sxã³ ã³nũ²kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nxe³ai¹nha²kxai³ a²ne³ku̱n²nãu³a² ka³no¹a² ka³lo³ha¹li¹ ĩ²yain¹ta¹hxai²hẽ¹la². A²nxe³te²a² a̱i³na² sai¹te³lhxã³ ain¹ka³lo³su² ta¹hxai²hẽ¹la². Yxãn¹ta¹ a̱i³na² sai¹tũ̱³ka̱³txa² a³li³nũ²la² ta³lã²la²ka³lo³a² wxa²hi̱³la³kxi²yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nxe³ain¹kxan²ta² Je³su²jah³la²kxai³lu² ka²no¹a² ã³wih¹nũ²la² a²wa³kxẽn³yah³la² Si³mãu²ah³lo²su² ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ ã³wih¹nũ²la² ĩ³ye³kxi²te³nah¹lxi¹: — Ha³lo²a² jũ¹nxe² ã³nhai¹a³sa³wi¹. Nyha¹ta¹hxai²hẽ¹la². Nxe³nũ²la² ã³wxe³ka³tu̱³ ã³nũ²kxi²tũ̱³ka̱³txai²li² Txa²wã¹sũ̱³na² wãn³txa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hã²wxãn³txa³ ĩ³yau¹ũ³ta³lu²nain¹nũ²la² ĩ³ye³kxi²nyha¹te³nah¹lxi¹: — Si³mãu²ah³lãi³. Ĩ̱³ye³na² u̱t1tãu³a² ta³lã²na²ka³lo³a² tẽ³sxã³ ã³na¹sxã³ ã³nũ̱¹jah¹lxi³hẽ¹li¹. A̱i³na² sai¹a³sah¹lxi³wxi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nxa²ha¹te¹ Si³mãu²ah³lai²na² ĩ³wa²lũ³xi²nyha¹ti³ãn¹jau³kxai³lu¹: — Je³su²jah³la² txa²hxi²kan¹jah¹lãi³. O²la³kxi²sxã³ ã³a³lan²sĩn¹na¹hẽ²li¹. Nxe³nha¹kxan²ti³ hai³txi³ a̱in³ta³ sai¹ti³hex1sĩ¹nxa³hẽ²li¹. Yxãn¹ta¹ ĩ³ye³kxi²sa²nhĩ¹nha²kxai³ ta³lã²na²ka³lo³a² ã³na¹sxã³ ã³nũ̱¹ta¹tu¹wi¹. Nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nxa²ha¹te¹ ã³na¹sxã³ ã³nũ̱¹tain¹nũ²la² a̱i³na² ka³lxa¹txi³ sa²sai¹ai¹nha²kxai³ ta³lã²na²ka³lo³ai²na² sa²ten²ta³kxi²te³lhxã³ ta¹hxai²hẽ¹la², a̱i³na² ka³lxa¹sxã³ sax2txe̱¹yai¹nha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nxe³ai¹nha²kxai³ a²ya̱³la²nãu³xa² ka³no¹a² ka³lo³ã̱³sa²nũ³ka³lo³a² wxa²ye̱³wxã̱ix3so¹nyhain¹ta¹hxai²hẽ¹la². Nxe³sxã³ ã³wxã³ain¹nũ²la² ka³no¹a² ka³lo³ha¹lin¹ti³xa² a̱i³na² ne³ki¹sxã³ sa²sai¹ai¹nha²kxai³ ã³nxũ̱t1te³lhxã³ ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ain¹jut3su² Si³mãu² Pe²jah³la²kxai³lu² Je³su²jah³la² hxi²kan¹khai¹nxe³jut3su² ĩ²nxa²ha¹te¹ a²ne³kxai³tãu³a² ã³ka³ti³lhu³ta³kxa² wxe³sxã³ ĩ³ye³kxi²nyha¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ko̱³nxe³ti³ kãi³jah¹lo²sa¹wi¹. Nxe³na¹ha²kxai³ ã³nix3txu¹li¹. Nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jã¹xain¹jut3su² Pe²jah³lai²na² a²sa³wi³ha³lxi³nãu³xai²na² sa²kxai³lu² ain¹sxã³ a̱i³na² ka³lxa¹txi³ sai¹nha²kxai³ on²tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Te²yã¹nxe³jut3su² Si³mãu²ah³la² ya̱³li²nyhain¹tũ̱³ka̱³txa² Se³be³te²ah³la² ki³lha³nãu³su² ta¹hxai²hẽ¹la². Nxe³te²na² ĩ³lxa² Ti³a²kah³lo²su² ha²kxai³ Jo³ãu²ah³lo²su² ha²kxai³ ya³ta¹hxai²hẽ¹la². A²nxe³ya³te²a² on²txain¹ta¹hxai²hẽ¹la². Jã¹nxe³ju³kxai³lu² Je³su²jah³la²kxai³lu² ĩ³wa²lũ³xi²nyha¹te³nah¹lxi¹: — Pe²jah³lãi³. O²txa³hẽ¹li¹. A̱i³na² ã³na¹to³hxain¹tai¹ti²tu³wi¹. Yxãn¹ta¹ a¹hĩ¹nãn¹te²tu̱³ ã³si³tẽ³san¹kxai²nãn²tu̱³ a²nũ²a² ĩ³kaix1so¹nĩn¹ju³ta² ĩ³yau¹ũ³nxa²ha¹tu¹wi¹, ã³si³tẽ³kxi²sa²si¹hain¹jau³su¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ain¹nxa²ha¹te¹ ka²no¹a² sa²ne³ha³lo²sa²tã³nũ²la² Je³su²jah³la²kxai³ ĩ³hit2txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nxa²ha¹te¹ ye³jen¹nãu³kxai³lu² sxi²yhe³na² Je³su²jah³la²kxai³ ã³wih¹ta¹hxai²hẽ¹la². Nxe³nũ²la² a²nũ²a² khon³ta³kxi²sxã³ ka̱³lã̱un³ta³kxi²ta¹hxai²hẽ¹la². Nxe³jah¹la² ya̱u³son³kxi²ta¹hxai²hẽ¹la². Ya̱u³son³kxi²nũ²la² jah¹la²kxai³lu² Je³su²jah³la²kxai³ ĩ²nũ²la² a²ne³kxaix3tãu³a² ã³ka³ti³wxe³ta¹hxai²hẽ¹la². Nxe³sxã³ win¹ta²te²lxi³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. “Wxa²ĩ³ta³ka³txa² hxi²kan¹txi³ we²txi¹nxa²ha¹tũ¹xã¹.” Sa¹ki³la³te²ki³lha³ti¹. Nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nxa²ha¹te¹ Je³su²jah³la²kxai³ sa²nũ̱³sin²sxã³ wxa²wxai³nyha¹sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Ten³sa³nhai¹. Wxa²ĩ³ta³ka³txa² ã³wa²su¹tũh¹nxa²ha¹wi¹. Nxe³nyha¹ta¹hxai¹hẽ¹la². Nxe³nyha¹hĩ¹na¹ a²nũ²a² kwẽn¹tai²na² ĩ³to³nain¹te²a² a²kwẽn¹tai²na¹ we²txi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A²nxe³jut3su² Je³su²jah³la²kxai³la¹ ĩ³ye³kxain¹ti³ãn¹jau³kxai³lu¹: — Nxe³nxa²ha¹ju³tan¹te²kxa³ya̱³lhu² wã³nxĩn¹ta² si³yxau³jah¹la² ai³sẽ¹li¹. Ain¹tãu³a² we²txi²nxa²ha¹ju³ta² a²nũ²a² ã̱³xa² ĩ³hen³txi³txa³hẽ¹li¹. Hãi¹nxe³sxã³ wã³nxĩn¹ta² si³yxau³jah¹lan²tu̱³ ka³yxuh³xa² Moi³se²ah³lu¹tai²na² ĩ³yau¹ũh¹nxain¹kxe³su² ũ³hũ¹txai¹nhẽ³li¹. Nxai¹nĩn¹kxai²nãn²tu³ hã²wxãn³txa³ wã³nxĩn¹jah¹lai²na² sa²kxai³lu² ka³yxuh³xai²na² tẽ³sxã³ Sũ̱³na² ũ³hũ¹yhain¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ti² a²nũ²a² a²yxo²ha³kxa¹ Txa²wã¹sũ̱³na² we²txi²nxa²ju³ta² ĩ³yau¹ũ³yhe²ai¹nĩn¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nxe³yãn¹tah¹lxa¹ nxe² ĩ³ye³kxi²kxan²ti³nũ¹ ju¹tai²na² u²lxi³ ha³ta̱³nxe² ĩ³ye³e²nyhain¹ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² a²nũ²a²nãu³xa² kãin² ã³nũ²kxi²nũ²la² Je³su²jah³lai²na² wãn³txa² ain³kxi² ĩ³to³nain¹te²a² we²txi² nxe³te³lhxã³ ã³nũ²kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nxe³nyhain¹to³ta¹ Je³su²jah³la²kxai³lu² ã³waix3tũ²la² ha³lo²ai²li² a²nũ²a² yxau³ai¹nxa³ko³xa² ã³nxai³to³ta¹hxai²hẽ¹la². Txa²wã¹sũ̱³na² ĩ³ye³kxi²te³lhxã³ ã³nxai³to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ain¹nxa²ha¹te¹ kxã³non³tãu³a² a²nũ²a² ãh¹lxi³sxã³ kãin² ã³nũ²kxi²nyhain¹ta¹hxai²hẽ¹la². Sxi²yhe³na² Ka³li³le²a²ko³xan¹thĩ³nãu³a² a³li³i² sxi²yhe³na² Ju³te²a²ko³xan¹thĩ³nãu³xa² a³li³i² Je³ru³sa³lẽ²thĩ³na² a³li³i² nxe³ain¹ta¹hxai²hẽ¹la². Jã¹nxe³tũ̱³ka̱³txa² fa³ri³se²a² nũ̱³ka̱³txi³su² ha²kxai³ Txa²wã¹sũ̱³na² wãn³txai²na² ĩ³yau¹ũ³tũ̱³ka̱³txi³su² ha²kxai³ nxe³yain¹sxã³ sxi²yhe³na² a³li³sxã³ ã³nũ²kxi²nyhain¹nũ²la² ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². Ain¹tãu³a² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² Je³su²jah³la² kãin² ã³nhi²ka¹tha²kxai³ a²nũ²a² yxo²ha³kxa¹ nũ̱³kxũn³sxã³ ĩ³we²txa³lxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nxe³tãu³ãn²tu̱³ti¹ in³txi³nãu³xa² wxã³ain¹ta¹hxai²hẽ¹la². Nxe³tũ̱³ka̱³txai²li² in³txa² kan²ta³kxi²ha²kxai³ hãi¹sxã³ ka²ma²ka³lo³a² sxa³ta¹hxai²hẽ¹la². Nxe³te²a² ka²ma²ka³lo³a² whãi²na¹ ã³ki³wxen³ta³kxi²sxã³ sa²so¹sxã³ ã³nxai³ain¹ta¹hxai²hẽ¹la². Nxe³ain¹nũ²la²: — Ã³wih¹sĩn¹ki̱³tũ¹xã¹. Kan²ta³kxi²jah¹la² tẽ³sxã³ Je³su²jah³la² a²ne³kxai³tãu³a² ũ³ha¹a̱³sĩn¹ki̱³tũ¹xã¹. In³txi³nãu³xa² ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nxe³ain¹tah¹lxa¹ sxi²hẽ¹nãu³a² a²nũ²a² nũ̱³ka̱³txa² ã³ka̱³tũ̱³je²nyhai¹nha²kxai³ hxi²kan¹txi³ ã³wih¹hain¹ta¹hxai²nxa³hẽ¹la². Nxe²nxa³ha²kxai³ sxi²ha² ne³ka³nah²nãu³a² ĩ³ka³la³nũ²la² te²la²ka³lo³a² sa²sain¹ta³kxi²ain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² ĩ³ton³jah¹la² ka²ma²ka³lo³a² whãi²na¹ Je³su²jah³la² a²ne³kxai³tãu³a² a²nũ²a² a²nxũ²kwa̱i³wit3ta² ũ³yhu³lhxot1sxã³ ũ³ha¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","— Je³su²jah³la² hxi²ka² kan²ta³kxi²nẽ³ka³txa² we²txi²ju³ta² yũ³tũ¹xã¹. Ain¹jau³su² ũ³ha¹ain¹ta¹hxai²hẽ¹la². Nxe³ju³tai²na² Je³su²jah³la²kxai³ wi¹ko̱³nh²nxa²ha¹te¹ ã³yxo²o³tũ¹nũ²la² ĩ³ton³jah¹la² ĩ³ye³kxi²te³nah¹lxi¹: — Wxa²ko̱³nxe³ti³ kãi³in¹ju³ta² ã³wa²su¹txa²ha¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² nxain¹sxã³ he³son³kxi²nyhain¹sxã³ ki³han³jau³su² e³lain¹te³nah¹lxi¹: — A²nũ²a² ko̱³nxe³ti³ kãi³ju³ta² Txa²wã¹sũ̱³na² so¹lxi³ hxi²kan¹txi³ ne³wã²na³ain¹te²ju²hẽ³li¹. Yxãn¹ta¹ Je³su²jah³lai²li² a²nũ²khai³xai²la¹wi¹. Hxi²kan¹nxa³wi¹. Nxe³ha²kxai³ Sũ̱³na² ko̱³nxe³te²lo³jah¹lo²su² na³li¹. Nxe³jau³su² ki³han³sxã³ e³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","23","Ain¹nxa²ha¹te¹ Je³su²jah³la²kxai³ he³son³kxi²nyhain¹jau³su² wi¹ko̱³nh²nũ²la² ĩ³ye³kxi²te³nah¹lxi¹: — He³son³jah³lxin¹jau³xa² ha³ya³kxa² e³li³jah³lxi³hẽ¹li¹. Nxe³ka²a³sah¹lxi³wxi¹. Ĩh¹jaut3ta̱³ wãn³txa² wa³sut3jau³la³te²la¹xã³? “Wxa²ko̱³nxe³ti³ kãi³in¹ju³ta² ã³wa²su¹txa²ha¹wi¹.” Nxe³jau³xai²la³ta̱³nxa²: “Ĩ³ton³jah¹lãi³. Ĩ³sa²yxau³sxã³ ã³nxĩ³xi¹sẽ¹li¹.” Nxe³jau³xai²la³ta̱³nxa² nxe²hĩ̱³ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yxãn¹ta¹ Txai²na² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³lot3sa²kah³lo²su² na¹ha²kxai³ wxi²ka¹na¹ju³ta² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Nxe³ha²kxai³ ĩ³ton³jah¹lo² ĩ³nxai²na² ĩ³ye³kxi¹nxa²ha¹wi¹. Ĩ³sa²yxau³txi¹. Wxa²sxan¹ka³lo³ai²na² sa²so¹sxã³ ã³nxĩ³txu¹li¹. Nxe³nxa²ha¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nxe³ju³tan¹te²kxa³ya̱n³tu̱³ ĩ³ton³jah¹la² wa³su³txi³ ĩ³sa²yxau³nũ²la² a²sxa³ka³lo³a² sa²so¹sxã³ ã³nxĩ³xi²ta¹hxai²hẽ¹la². Txa²wã¹sũ̱³na² sa²nẽn¹kxi² kãi²non³jau³su² a²nũ²a² yxo²ha³kxa¹ ĩ³ye³kxi²lã³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nxe³ai¹nha²kxai³ a²nũ²a² yxo²ha³kxa¹ ĩ³wã̱³wã̱³txi³sxã³ ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² nũ̱³kxũ̱n³khaix1nxe³sxã³ wi¹lhin¹khai¹nx2na³li¹. Kwẽn¹tai²na¹ ĩ²ki̱³tã³li¹. Yxãn¹ta¹ kxã³nxai³kxai³lu² te²xi²yã¹nxe³ju³ta² ĩ²ki̱³sxai²nxa³tai¹tu³wi¹. Tah¹ hĩ¹na¹ ĩ²ki̱³tã³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hã²wxãn³txa³ Je³su²jah³la²kxai³lu² a³li³xi²nũ²la² a²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³jah¹lai²na² Le³vi²ah³lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² sa²kxai³lu² sxi²ha² ũ³yho³hi²ki³ka² ũ³ha¹thĩ³na² ã³wxe³ta¹hxai²hẽ¹la². Nxe³te²na² Pu³pli³ka²no² nũ̱³ka̱³txi³su² ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ta¹ Je³su²jah³la²kxai³lu² ĩ²sxã³ ĩ³kaix1te³nah¹lxi¹: — Ã³si³tẽ³kxi²sẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nxe³ai¹nha²kxai³ Le³vi²ah³la²kxai³lu² a²yen³kxa² whãi²na¹ wxa²wxe²a³nũ²la² ã³si³tẽ³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nxe³ju³tan¹te²kxa³ya̱³lhu² hã²wxãn³txa³ Le³vi²ah³la² a²sxi²nhãu³a² yain³txa² kãin² we¹tain¹ta¹hxai²hẽ¹la². Nxe³sxã³ Je³su²jah³la²kxai³ wxã³sxã³ ĩ³yain³si¹jau³su² kaix1tain¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txa² ka³lxa¹txi³ ã³wxã³ha²kxai³ a²nũ²a² ã̱³xa² ka³lxa¹txi³ nũ¹nain¹sxã³ yai³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nxe³ain¹nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txi³nãu³a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² nxain¹sxã³ ju¹ta² ĩ²ain¹sxã³ kãin² ĩ³hi̱³ta³lxi³sxã³ Je³su²jah³la² a²sa³wih³ha³lxa² ĩ³kwa̱i²kxain¹te³nah¹lxi¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ a²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txi³su² ko̱³nxe³ju³ta² kãi³te²su² te²nãu³xa² nxe³te²su² ain¹sxã³ ã³nũ²kxi²sxã³ yain³ni² ĩ³na² nxe³kxah³lxin¹si²li¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²nyhain¹ti³ãn¹jau³kxai³lu¹: — Ne³ka²sa²sa²lxi¹. A²nũ²a² wi¹lain³kxi²nha²te² hi²sen³su² hĩ³ne³kxa² wa³kxẽn³yah³la² ã³ten³te²sxa³yu²hẽ³li¹. Yxãn¹ta¹ a²nũ²a² ĩ³ton³te²su² te²a² so¹lxi³ ã³ten³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Te²yã¹nxe³sxã³ a²nũ²ai²na²: “Wi¹lhin¹sa³nha¹. Ko̱³nxe³ti³ kãi³a¹ju³ta² yũ²nxa³nha¹.” Nxe³te²su² te²na² ĩ³kaix1so¹ai¹na¹ju³ta² yũ²nxa³wi¹. Yxãn¹tah¹lxa¹ hãi¹sxã³ ko̱³nxe³jah¹la² so¹lxi³ a²ko̱³nxe³ti³ kãi³ju³ta² ĩ³ãin²ta³kxi²nha²sxã³ ã³na¹la³kxi²nha²te²su² te²na² so¹lxi³ wxa²wa²su¹tain¹te³lhxã³ ĩ³kaix1so¹ai¹na¹ju³ta² yũ²na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nyhain¹nxa²ha¹te¹ ĩ³ye³kxi²nyhain¹te³ãn¹jau³kxai³lu¹: — Je³su²jah³lãi³. Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ Jo³ãu² Ba³tis²jah³la² sa³wi³ha³lxai²na² sa²kxai³lu² Sũ̱³na² ĩ³ka³li³kxi²te³lhxã³ he³lhxi² yxau³to³hain¹sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxain¹to³lhai¹li¹? Ai¹nha²kxai³ fa³ri³se²a² a²sa³wi³ha³lxa² te²yã¹yxain¹nũ³nhxai²na²hẽ³li¹. Ain¹ta¹ wxa²sa³wi³ha³lxa² hai³txi³ ti³hex1yu̱³nxãn²nxa³wi¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Yxau³nuh¹nx2ta¹tãu³a² ĩ³ãin²ta³kxi²nha²sxã³ he³lhxi² yxau³yah³lxin¹ju³ta² wai³nxa³wi¹. A²nxe³ju³ta² in³txa² txu¹ha² so¹nyhu¹kxai²nãn²tu̱³ a²ya̱³la²nãu³xa² ĩ³kaix1so¹yhain¹te²ju²hẽ³li¹. Nxe³ju³ta² sa²kxai³lu² a²wẽ³sãi¹yah³la² yxau³ye²yhai¹hĩ¹na¹ ĩ³kaix1so¹ain¹tũ̱³ka̱³txai²na² ĩ³ãin²ta³kxi²nha²sxã³ he³lhxi² yxau³ain¹ju³ta² wai³nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yxãn¹ta¹ yxan¹nãu³a¹ a²wẽ³sãi¹yah³lai²na² so¹kxain¹sxã³ sa²tã³tĩ̱¹kxi²nyhain¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ nxe³hĩ¹na¹ a²nũ²a² ĩ³kaix1so¹ain¹tũ̱³ka̱³txa² ĩ³ãin²ta³kxi²nha²sxã³ he³lhxi² yxau³ain¹ju³ta² wain³tu¹wi¹. Jã¹nxe³ju³kxai³lu² fa³ri³se²a² nũ̱³ka̱³txai²na² Jo³ãu² Ba³tis²jah³la² a²sa³wi³ha³lxi³nãu³xai²na² nxain¹sxã³ txa²wã¹yah³la²nãu³xu¹tai²na² wãn³txa² sa²yxo²wet1si¹hain¹jau³su² he³lhxi² yxau³ain¹te²ju²hẽ³li¹. Ne³to³ta¹ txa²sa³wi³ha³lxai²na² sa²kxai³lu² ã³waix3txai¹na¹hĩ¹na¹ so¹lxi³ he³lhxi² yxau³ain¹tu¹wi¹. Ã³waix3txa¹na¹kxe³su² ĩ³ãin²ta³kxi²nha²sxã³ he³lhxi² yxau³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nxe³ha²kxai³la¹ ĩ³yau¹ũ³jau³xa² ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a² wã²la² kwẽn¹ta² yxãi¹ka³lo³a² wi¹ka³lo³a² tẽ³sxã³ ko̱³nxe³ka³lo³a² ã³ten²ti³ka³lo³a² ũ³nhũ²kxi²sxã³ ũh³yxãi¹yain¹te²sxa³yu²hẽ³li¹. Yxãn¹ta¹ ũh³yxãi¹yain¹ke³la³te²kxai³ wã²la² wi¹ka³lo³a² ã³kho³te²ju²hẽ³li¹. Jã¹nxe³kxa²yu³su² wã²la² tĩ³ka³lo³la³ ã³sai¹hĩ̱³nx2nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jã¹nxe³jau³su² yain³txi³yau³xa² txah²yau³xa² hai³txi³ ka³yxuh³xa² wã²lẽ¹na² tĩ³ka³lo³ẽ¹nãn²ta³ ã³nẽ¹na³wi¹sxã³ ũ³wha¹ki̱³te²sxa³yu²hẽ³li¹. Ã³nẽ¹na³wi¹sxã³ ũ³wha¹ki̱³ke³la³te²kxai³ a²yain³txi³yau³xai²na² sa²kxai³lu² wã²lẽ¹nai²li² ĩ³txi³ha̱u³kxi²sxã³ ĩ³khot3sxã³ a²yau³xa² ã³nẽ¹na³hxa³te²ju²hẽ³li¹. Nxe³ha²kxai³ a²yain³txi³yau³xain²txi³ ha³li³hxa³ni² wã²lẽ¹nain²ti³ ã³kho³ti² nxe³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yxãn¹ta¹ yain³txi³yau³xa² tah²yau³xan²ta³ wã²lẽ¹na² ta²hẽ¹nãu³a² ã³nẽ¹na³wi¹sxã³ ũ³wha¹ki̱³te²ju²hẽ³li¹. Nxe³ki̱³kxai²nãn²tu̱³ wã²lẽ¹nai²na² ã³kho³txa³ha²kxai³ a²yain³txi³yau³xa² ã³nẽ¹a³na¹xa³ha²kxai³ nxe³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A²nxe³sxã³ a²nũ²a² vĩn²yau³xa² tĩn³yau³xa² tẽ³sxã³ ĩ³na²ain¹kxai²nãn²tu̱³ tah²jau³xa² ãh¹ ã³te³nain¹te²sxa³yu²hẽ³li¹. Nxe³ha²kxai³lu¹: “Tĩ³yau³xa² ã²la² wi¹na³li¹.” Nxain¹te²ju²hẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nxa²ha¹te¹ kxã³nãu³a² Je³su²jah³la² a²sa³wi³ha³lxa² whãi²na¹ hai³sxa² ha³nãu³ha² ai³ain¹ta¹hxai²hẽ¹la². Ain¹tãu³a² a²sa³wi³ha³lxa² yain³txa³nã̱³kxa² wxa²ni̱²lho¹nũ²la² wxa²ti̱³kxi²sxã³ wxa²ki³ka³tuk1kxa² sai¹sxã³ yai³nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ain¹nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² ĩ²ain¹te³nah¹lxi¹: — Yain³txa³nã̱³kxa² wxa²ni̱²lho¹yah³lxi¹lxi¹. Nxe³to³ta¹ Ju³te²a² nũ̱³ka̱³txa² sa²ba³to³ nxe³tãu³a² a²wa³ka³la² a²yxo²ha³kxa¹ ã³na¹xai³ki̱³te²jai¹ti²tu³wi¹. Nxe³yah³lxin¹ta¹ jau³jau¹xai²na² sa²yxo²ã³yah³lxin¹ten¹tu³wi¹, yain³ti³nã̱³kxa² wxa²ni²lho¹yah³lxi¹nha²kxai³lu¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Nxa²ha¹te¹ Je³su²jah³lai²na² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Nxe³jah³lxi³sa²lxi¹. Sũ̱³na² ũ³wha²li¹txã³nxa² ĩ²nx2ti³ta²lu¹wi¹. Ta³vi²yah³lu¹tai²na² he³ha²kxai³ a²sa³wi³ha³lxi³nãu³xu¹tai²na² he³hai¹nha²kxai³ nxain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Nxain¹tãu³kxai³lu² Sũ̱³na² sxi²ha² ã³wih¹nũ²la² yain³tũ̱³xai²na² Sũ̱³na² ũ³yho³hi²tũ̱³xai²na² wxa²so¹sxã³ ĩ³yain³kxain¹ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³tũ̱³xai²na² Sũ̱³na² sxi²ha² hau³ko³tũ̱³ka̱³txai²na² so¹lxi³ yain³tũ̱³su² ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³kxa²ha³ta̱³nxãn²ti³ yai³nain¹ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nxe³na¹kxa²yu³su² Txai²na² Sũ̱³na² Hxi²kan¹ta² Si³yxau³tãu³la³sa²kah³lo²na¹xai²na² sa²ba³to³ nxe³ti³xa² a²wa³kxẽn³yah³lo²sa¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hã²wxãn³txa³ ãh¹ sa²ba³to³ nxe³ti³xa² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih²xi²nũ²la² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³to³hain¹ta¹hxai²hẽ¹la². Nxe³tãu³a² in³txa² a²hxi²wi¹nẽ³tãu³a² hxi²yã³nãn³ta³kxi²sxã³ ã³wih¹sxã³ ã³wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fa³ri³se²a² nũ̱³ka̱³txa² wxã³sxã³ ã³wih¹hi² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² wxã³sxã³ ã³wih¹hi² nxe³ain¹ta¹hxai²hẽ¹la². Nxe³te²nãu³xai²na² sa²kxai³lu² hxi²we²txi²ju³ta² ĩ²te³lhxã³ wahx3nxain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ ko̱³nxe³thin¹sxã³ he³son³kxi²nhain¹te³nah¹lxi¹: — Sa²ba³to³ nxe³ki̱³tãu³a² hxi²we²txi²kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxa² sa²yxo²ã³kxi³ju³ta² ĩ²ki̱³txai²li¹. Nxe² ko̱³nxe³ti³ he³son³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nxa²ha¹te¹ he³son³kxi²nyhain¹jau³xa² Je³su²jah³la²kxai³lu² a³la³kxi²ha²kxai³ hxi²yã³nãn³ta³kxi²jah¹la² e³kxi²te³nah¹lxi¹: — Ĩ³sa²yxau³sxã³ ã³wxãx3txu¹li¹. Nxe³jau³su² nũ²la² in³txai²li² ĩ³sa²yxau³sxã³ ã³wxã³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³la¹: — Ne³kxa²sah¹lxi³sa²lxi¹. Sa²ba³to³ nxe³ti³xa² wi¹lo²la³kxi²ta̱³nxa² ko̱³to²la³ki²ta̱³nxa² ĩh¹ju³ta² wai³nhĩ̱³te²la¹xã³? Te²yã¹nxe³sxã³ a²nũ²a² su²lhã³ta̱³nxa² we²txi²ta̱³nxa² ĩh¹ju³ta² wai³nhĩ̱n³te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ai¹nha²kxai³la¹ ĩ²sa²sai¹ain¹ka³tu̱³ in³txai²li² e³kxi²te³nah¹lxi¹: — Ĩ³hxi²sin²nha²si¹hain¹jau³kxai³lu¹. Nxe³ha²kxai³ ĩ³hxi²sin²nha²sxã³ we²txi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nxa²ha¹te¹ a²nũ²a² he³son³kxi²nyhain¹tũ̱³ka̱³txin³ti² kãin² ĩ³a̱n³ta³kxi²sxã³ ĩ³ye³lain¹te³nah¹lxi¹: — Ĩh¹nxet3sxã³ Je³su²jah³la² su²lhã³hĩ̱³ki̱³te³ji¹ku¹. Tũ̱¹ka̱³txai²li² nxe² e³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hã²wxãn³txa³ Je³su²jah³la²kxai³lu² wã³la³ka³txa² ka³la³ta¹hxai²hẽ¹la², Sũ̱³na² ĩ³ye³kxi²te³lha³ka². Nxe³sxã³ Txa²wã¹sũ̱³na² e³kxa³lan²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nxe³nũ²la² a³lan²ni²nũ²la² a²sa³wi³ha³lxa² ĩ³kaix1ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txi³nãu³xa² a²sa³wi³ha³lxa² hxi²ka² hxan³sxã³ ha¹li¹ wxa²hait1so¹xi²nũn³tũ̱³ka̱³txa² ĩ²sxã³ sa²so¹te³nah¹lxi¹: — Sa²si¹hã³nx2ta¹tũ̱³ka̱³txi³syah¹lxin¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nxe³ha²kxai³la¹ tũ̱¹ka̱³txai²li² ĩ³yĩ¹li²jau³xa²sa¹ Si³mãu²ah³lo²su² ha²kxai³ a²nxe³jah¹la² ĩ³lxa² ã̱³xai²na² Pe²jah³lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹lo²kxai³lu² a²lon³yah³la² Ãn³tre²ah³lo²su² ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ Ti³a²kah³lo²su² ha²kxai³ Jo³ãu²ah³lo²su² ha²kxai³ Fi³li²pah³lo²su² ha²kxai³ Bar³to³lo³me²ah³lo²su² ha²kxai³. ");
INSERT INTO nabNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ma³te²ah³lo²su² ha²kxai³ To³me²ah³lo²su² ha²kxai³ Ti³a²kah³lo²su² ha²kxai³ a²nxe³jah¹lai²li² au³fe²ah³la² ki³lha³lhxu² ta¹hxai²hẽ¹la². Jã¹nxe³sxã³ Si³mãu²ah³lo²su² ha²kxai³ a²nxe³te²a² ã̱³lxi³sxã³ Se³lo²ti³ nũ̱³ka̱³txi³si²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jã¹nxe³sxã³ Ju³ta²sah³lai²na² ha¹lo³ta³lxi³sxã³ ka³na³ki² te²a² Ti³a²kah³la² ki³lha³lhxu² ha²kxai³ ã̱³xai²na²su² Is³ka³ri³o²jah³lo²su² ha²kxai³ nxe³ta¹hxai²hẽ¹la². A²nxe³te²nãn²tu̱³ kxã³nãu³a¹ Je³su²jah³la²kxai³ ĩ³ki³ha¹kxi²jah¹lo²su² ta¹hxai²hẽ¹la². Ĩ³ki³ha¹kxi²sxã³ a²nũ²a² ko̱³nxe³thin¹tũ̱³ka̱³txa² ã³yã³yũ¹kxain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²na² a²yxo²ha³kxa¹ Je³su²jah³la²kxai³lu² ĩ²sxã³ sa²so¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Nxe³nũ²la² ĩ³kaix1so¹ta³lun²nũ²la² a³ka³nxain¹tãu³a² wã³la² yxe²ta²wau³waun³ju³ta² ã³yit1tãu³a² a²nũ²a² ka³lxa¹txi³ nũ²kxi²ta¹hxai²hẽ¹la². Ju³te²a²ko³xan¹te²a² wxã² Je³ru³sa³lẽ²thĩ³nãn¹te²a² wxã² ĩ̱³ye³nai²na² yxo²ka³teh³xan¹ko³xa² a²sxi²je³nai²na²sa¹ Ti²ro³thĩ³nãn¹te²a² wxã² Si³tõ²thĩ³nãn¹te²a² wxã² nxe³ai¹nha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²te³lhxã³ nũ²kxi²ta¹hxai²hẽ¹la². Ai¹nha²kxai³lu¹ ĩ³ta³ka³txa² ĩ³ton³te²a² we²txi²ju³ta³nũ³a² wah³nxa³kxi² a²ko̱³nxe³te²a² a²yãu³ka³txa² nxũ²kwa̱i³wi¹sxa³te²a² nxũ²kwa̱i³li³si¹jau³nũ³su² wah³nxa³kxi² nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nxe³ai¹nha²kxai³ wxa²wxai³sai³nain¹ju³tan¹te²kxa³ya̱³lhu² a²hãi¹nxe³ti³xa¹ we²txain¹ta¹hxai²hẽ¹la², Je³su²jah³la² wa³nxĩ¹nha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ain¹nxa²ha¹te¹ Je³su²jah³la²kxai³lu² a²sa³wi³ha³lxa² ĩ²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxex3jah³lxi³wxi¹. Yen³kxi³txa¹nxa²lxi³ji¹wi¹? Nxe³nx2ti³kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Yah³lxi¹nha²kxai³ kxãn³nãu³a¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³a² yxau²xai³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ãh¹jau³xa²sa¹ hĩ¹na² he³ja³lu¹nxa²lxi³ji¹wi¹? Nxe¹nx2ti³kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Yah³lxi¹nha²kxai³ kxãn³nãu³a² ũ³kxi¹nx2ti³tu¹wi¹. Hĩ¹na² kãin² na̱n³yah³lxin¹ji¹wi¹? Yah³lxin¹kxai²nãn²tu̱³ ka³lih³jah¹lxi³hẽ¹li¹. Yah³lxi¹nha²kxai³ kxãn³ton³sxã³ kãin² ka³lxi¹yhah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Sa²yxo²wet1sah¹lxin¹te² ĩ³nxai²na² ka³lih³jah¹lxi³hẽ¹li¹. Yah³lxi¹nha²kxai³ kxãn³ton³sxã³ ĩ³a̱n³ta³kxi¹nx2txai¹nha²kxai³ ã³ten³nxa²lxai¹nxa³ha²kxai³ ko̱³nxe³ti³hi¹txa²txi³si¹hain¹jau³su² ha²kxai³ ha³ya³kxa³ti³lo³txa²tai¹nha²kxai³ nxe³nx2tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nxe³nx2tain¹kxan²ti³nũ¹ kãin² ka³lih³jah¹lxi³hẽ¹li¹. Nxe³nx2tain¹kxa² yã¹nxe³sxã³ yãn³tai²na¹ Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³nũ̱³ka̱³txu¹tai²na² nxe³nyhain¹to³ta¹hxai²ti³ai¹ti²tu³wi¹. Jã¹nxe³nx2tain¹ju³kxai³lu² ka³lxi¹sxã³ a³li²sin³jah¹lxi³hẽ¹li¹. Nxe³nx2tain¹sxã³ khãuh³lxa³txi³yhah¹lxin¹kxa² yo³ha² wi¹ju³ta² kãin² yũ³nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yxãn¹ta¹ yen³kxi³te² ĩ³nxai²na² hĩ¹na² so¹lxi³ ka³lih³khaix1yah³lxi¹lxi¹. Yxãn¹ta¹ kxã³ton³sxã³ ĩ³ãin²ta³kxi¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Te²yã¹nxe³sxã³ yain³txa² kãin² yũh³te² ĩ³nxai²na² hĩ¹na²kxai³ ka³lih³yah³lxi¹lxi¹. Yxãn¹ta¹ kxã³nãu³a² he³ja²lun¹ti³nx2ti³tu¹wi¹. Nxe³nx2ti³ha²kxai³ ye³khãuh³lxa³thi¹yah³lxin¹tu¹wi¹. Te²yã¹nxe³sxã³ hĩ¹na²kxai³ kãin² ka³lxih¹te² ĩ³nxai²na² ka³li³yhah³lxi¹lxi¹. Yxãn¹ta¹ kxã³nãu³a² ãin²ti³sxã³ nã̱n³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Te²yã¹nxe³sxã³ hĩ¹na²kxai³ a²nũ²a² yxo²ha³kxa¹ wi¹le³nx2ti³na³li¹. Nxe³nx2ti³kxa² yã¹nxe³ju³ta² kxã³nhxĩ¹nu¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³ki³lxo³tũ̱³ka̱³txu¹tai²na² te²yã¹nxe² kãi³ũ¹nyhain¹to³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nxa²ha¹te¹ ne³ka²kxi²syah¹lxin¹te² ĩ³nxai²na² ĩ³ye³kxi¹nx2ta¹tu¹wi¹. Wxa²ko̱¹ko̱¹nũ̱³ka̱³txa² a³lxi¹tai¹yah³lxi³hẽ¹li¹. Ĩ³a̱n³ta³kxi¹nx2tain¹te²su² te²a² ĩ³wa²lũ³xi²sxã³ ĩ³a̱n³ta³kxi²nxãn²nxa³sxã³ wi¹la³ kãi³ũh¹txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","A²nũ²a² ko̱³nxe³te²lo³txa²tain¹kxan²ti³ wi¹la³te²lo³txain¹yah³lxi³hẽ¹li¹. Te²yã¹nxe³sxã³ a²nũ²a² ko̱³nxe³ti³ kãi³ũh¹nx2tain¹kxan²ti³ Txa²wã¹sũ̱³na² nxe² ĩ³ye³kxi²txain¹yah³lxi³hẽ¹li¹. Nxe²e³kxain¹yah³lxin¹te³nah¹lxi¹: “Txa²wã¹sũ̱³na² nex3txi¹. Tũ̱¹ka̱³txai²li² ko̱³nxe³ti³ kãi³ũ¹sain¹na²hẽ³li¹. Nxe³sain¹kxan²ti³ wi¹lĩ²txai¹nhẽ³li¹.” Txa²wã¹sũ̱³na² nxe³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te²yã¹nxe³sxã³ wxa²ne³su²nx2tain¹kxai²nãn²tu̱³ wxa²ne³ha³tih³nãu³a² ã³na̱³wa³ti̱³tũ¹txain¹yah³lxi³hẽ¹li¹. Wxa²wã²la²ka³lo³a² wi²kxi²nhãn¹ka³lo³a² kãi³kxi¹nx2tain¹kxai²nãn²tu̱³ wxa²ha³la³sẽ³nãn¹ka³lo³a² a³lxi²yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Te²yã¹nxe³sxã³ wxa²yen³kxa² yxo²kwa̱in³kxi¹nx2tain¹kxai²nãn²tu̱³ ũ³hũ¹txain¹yah³lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ ũ³hũ¹xi¹nx2ti³si¹hain¹jau³su² ĩ³ye³kxain¹yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A²nxe³ju³ta² a²nũ²a² wi¹lo²la³kxi¹nx2tain¹ju³ta² ten³nxa²lxi³kxa² yã¹nxe³sxã³ kãi³ũh¹txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","35","A²nũ²a² a³lxi¹nx2tain¹te²na² so¹lxi³ ĩ³wa²lũ³xi²sxã³ a³lxain¹yah³lxin¹ji¹wi¹? A²nũ²a² wi¹kãi³ũh¹nx2tain¹te²na² so¹lxi³ ĩ³wa²lũ³xi²sxã³ wi¹kãi³ũ¹hain¹yah³lxin¹ji¹wi¹? A²nũ²a² kãin² yen³kxih³te²a² so¹lxi³ kwa²ũ³hũ¹ain¹yah³lxin¹ji¹wi¹? Nxe² kãi³ain¹yah³lxi³txa³hẽ¹li¹. A²nũ²a² ko̱³nxe³thin¹te²a² ju¹tai²na² a²yxo²ha³kxa¹ te²yã¹nxe² kãi³ai¹nhxai²na²hẽ³li¹. Yxãn¹ta¹ a²nũ²a² wxa²ko̱¹ko̱n¹nũ̱³ka̱³txa² a³lxi²nha¹jah³lxi³hẽ¹li¹. Wi¹kãi³ũh¹txain¹yah³lxi³hẽ¹li¹. Yen³kxa² wã²nxũ̱h¹ ũ³hũ¹nha¹jah³lxi³hẽ¹li¹. Ũ³yho³hxi¹nx2tain¹ju³ta³nũ³a² ne³wa³kon³nyhah¹lxi³txa³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ oh³nãu³nũ¹ka³na¹ wi¹kãi³yah³lxin¹kxa² yo³ha² kãin² yũ³nx2ti³tu¹wi¹. Yah³lxin¹kxai²nãn²tu̱³ti² Txa²wã¹sũ̱³na² Si³yxau³jah¹lai²na² a²ki³lha³nãu³su² ti³hi¹txa²ti³tu¹wi¹. Nxe³ha²kxai³ te²yã¹nxe³ju³tai²li² Txa²wã¹sũ̱³na² kãi³jah¹lo²su² hxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jã¹nxe³jut3su² Txa²wã¹wĩ³na² Si³yxau³jah¹la² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³te³lhxã³ wi¹ju³ta³lo³tẽ³na³li¹. Nxe³nẽ³kxa² yã¹nxe³sxã³ a²nũ²a² ã̱³xai²na² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³ko³jah³lxin¹sxã³ wi¹ju³ta³lo³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","A²nũ²a² ã̱³xai²na² ko̱³nxe³ti³ ju³ta² a³ya³txi²yah³lxi³txa³hẽ¹li¹. Nxe³yah²lxan³kxai²nãn²tu̱³ ko̱³nxe³ti³ ju³ta² a³ya³txi¹nx2tai¹nxa³lho³li¹. Jã¹nxe³ju³kxai³la¹ a²nũ²a² ã̱³xai²na² kãi³ain¹ju³ta² ko̱³nxe³ti³ ĩ³yĩ¹lai¹yah³lxi³txa³hẽ¹li¹. Nxe³yah²lxan³kxai²nãn²tu̱³ ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2tai¹nxa³lho³li¹. Te²yã¹nxũn³sxã³ ko̱³nxe³ti³ kãi³ũh¹nx2tain¹ju³ta² ne³wã²na³jah¹lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² ne³wã²na³nx2tain¹nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","A²nũ²a² yen³kxi³txa²te²su² te²a² wxa²yen³kxa² wã²nhũ¹ah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² hi²sen³su² yen³kxa² wã²nhũ¹nx2ti³nũn³tu¹wi¹. Nxe³sxã³ yen³kxa² ka³lxa¹txi³ tẽ³sxã³ wxa²hxi²ka² ũ³hxi²kũ²xai³nx2ti³tu¹wi¹. Nxe³sxã³ hxi²kan¹txi³ hxi²tẽ³nyhah¹lxan³so³li¹, yen³kxa² ka³lxa¹txi³ hũ¹nx2ti³ha²kxai³la². Nxe³ju³kxai³lu² hxi²kxã̱u³ti²la³nxa³nha²sxã³ o²la³kxi²nyhu¹ah³lxin¹kxa² yã¹nxe² Txa²wã¹sũ̱³na² hxi²kxã̱u³ti²la³nxa³sxã³ kãi³ũh¹nx2ti³tu¹wi¹. Ã³wa²to²hi² kãi³ũh¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ãh¹lxi³sxã³ ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a² ye³han³jah¹la² yã¹nx2na³li¹. Nxe³sxã³ a²nũ²a² nũ̱³ka̱³txa² ye³han³tũ̱³ka̱³txa² ne³ka³ta² ĩ³hau³ko³kxain¹sxã³ ai³kxai²nãn²tu̱³ kxĩh³nxẽ¹na² ne³ka³ta² ai³jah¹lai²li² a³hi² ĩ³hi²tain¹tũ̱³ka̱³txa² a³hai¹ni² nxe³yain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Te²yã¹nxe³kxe³hũ̱³nxe² a²nũ²a² a²hoh³lxi³su² te²a² hxi²kan¹na³li¹. Yxãn¹ta¹ a²hoh³lxi³su²nxa³te²a² hxi²ka¹nxa³wi¹. Yxãn¹ta¹ tih³xain¹nũ³nhĩ¹na¹ a²hoh³lxi³su²nũn³tu¹wi¹. Nxe³sxã³ hxi²kan¹nũn³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Wxa²wã³tã̱³xa² ko̱³nxe³ti³ kãi³jut3su² ju³ta² ko̱³nxe³ti³ ĩ³yĩ¹li¹yah³lxi³txa³hẽ¹li¹. Ko̱³nxe³ti³ kãi³yah³lxin¹ju³ta² kãin² wa³to²hi²na³li¹. Nxe³yah³lxin¹ju³ta² wai³nxa³wi¹. A²nxe³ju³tai²na² yã¹nx2na³li¹. Wxa²wã³tã̱³xai²li² hi³a² sĩ̱³na² ye³we²kxe³su² yũ³hĩ̱³nx2na³li¹. Nxe³yãn¹ta¹ hi³sa³ka³txa² ã³ye³wau¹kxi²nha²hĩ̱³nxa¹lxi¹. Nxe³kxe³su² wxa²ẽ¹nãn¹jau³kxai³lu²: “Txa²wã³tã̱³xai²li² hi³a² sĩ̱³na² sa²ye³sai¹kxi²na¹tũ¹xã¹.” Nxe³yah³lxin¹jau³su² yxãn¹ta¹ hi³sa³ka³txa² ã³ye³wau¹kxi²nha²kxe³su² ĩ²nyhah¹lxan³kxe³su² wai³nhĩ̱³nx2nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nxe³sxã³ wxa²wã³tã̱³xai²li² e³kxain¹yah³lxin¹te³nah¹lxi¹: “Hi³a² sĩ̱³na² sa²ye³sai¹kxi¹sĩn¹nxa²ha¹tu¹wi¹.” Nxe³yah³lxin¹jau³su² yxãn¹ta¹ hi³sa³ka³txa² ã³ye³wau¹kxi²nha²kxe³su² yũ³yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³yah³lxin¹ju³kxai³lu² wxãi²li² wi¹lhin¹ki³lxo³jah¹lo²su² yah³lxi¹lxi¹. Hi³sa³ka³txa² sa²ye³sai¹nhat1jah³lxi³sã²nhẽ³li¹. Nxe³sãn²nũ²la² wi¹lĩ²nha²sxã³ wxa²wã³tã̱³xai²li² hi³a² sĩ̱³na² sa²ye³sai¹kxi²nyhah¹lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jã¹nxe³ju³kxai³lu² hi³sa³ka³txa² wi¹ka³txai²na² sa²kxai³lu² hai³txi³ ko̱³ta³nxã̱³kxa² ã³nxã̱³ki²te²sxa³yu²hẽ³li¹. Te²yã¹nxe³sxã³ hi³sa³ka³txa² ko̱³ka³txai²na² sa²kxai³lu² wi¹ta³nxã̱³kxa² ã³nxã̱³ki²te²sxa³yu²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jã¹nxe³ju³kxai³lu² hi³sa³ka³khai³xa² yxo²ha³kxa¹ ã³nxã̱³kxi³khai³xa² so¹lxi³ nxã̱³kxi³te²ju²hẽ³li¹. Fi²ko²nxã̱³kxa² kwa²hi³sa³kax3khai³xa² ã³nxã³kxi²te²sxa³yu²hẽ³li¹. Te²yã¹nxe³ju³kxai³lu¹ u²va²ki³a² kwa²hu³kxẽ¹ha² kũh²sxa³te²sxa³yu²hẽ³li¹. U²va²kxẽ¹ha² so¹lxi³ kũh²sxa³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jã¹nxe³ju³kxai³la¹ a²nũ²a² wi¹lhin¹te²a² a²ẽ¹nãu³ai²na² wi¹lhi¹nha²kxai³ wi¹lo²la³kxi²te²ju²hẽ³li¹. Nxe³ain¹ta¹ a²nũ²a² ko̱³nxe³thin¹te²a² a²ẽ¹na² whãi²na¹ ko̱³nxe³thi¹nha²kxai³ wi¹lo²la³kxi²nha²te²sxa³yu²hẽ³li¹. Nxe³ju³kxai³lu² a²ẽ¹nãn¹jau³khai³xai²na² so¹lxi³ a²yxo²khai³xa² ĩ³ye³kxi²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nxe³ain¹nxa²ha¹te¹ e³kxi²sah¹lxin¹jau³kxai³lu¹: “Txa²hxi²kan¹jah¹lo²si¹lxi¹.” Sah¹lxin¹tai¹ti²tu³wi¹. Yxãn¹ta¹ ĩh¹nxe³kxa²ya̱n³ti³ta̱³ txa²wãn³txa² sa²yxo²wet1sah²lxan³ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","49","Ne³ka²sah¹lxi³wxi¹. Hĩ¹na² ĩ³yau¹ũ¹nx2ta¹jau³xa² ĩ³ye³kxi¹nx2ta¹tu¹wi¹. A²nũ²a² sxi²ha² txon³te³lhxã³ ain¹nũ²nhai¹. Ain¹ka³tu̱³ta¹ ka³wã³lxa³ nxe³ku̱²nxa² a̱u³txi³ wxa²xu³sxã³ ũh³ya³lã̱ux3sxã³ kan²txi³ ũh³wxe³ain¹nũ²nhai¹. Hã²wxãn³txa³ ka³wã³lxa² hũx1kxan²ti³ a³hi²yai¹nxa³nu²nhai¹. Jut1ai²li² a²nũ²a² yãx1nhĩ̱³nx2na³li¹. Txa²wãn³txai²na² ain³kxi²sxã³ sa²yxo²we¹kxai²nãn²tu̱³ nxe³jah¹lai²li² a²nũ²a² yã¹nxai¹nhĩ̱³nx2na³li¹. Hai³txi³ yxo²ĩ²sxã³ hxi²tha²on³te²sxa³yu²hẽ³li¹. Yxãn¹ta¹ Txa²wãn³txa² ain³kxi²sxã³ sa²yxo²ã³ain¹kxai²nãn²tu̱³ a²nũ²a² ã̱³xa² yã¹nxai¹nhĩ̱³nx2na³li¹. Nxe³te²na²sa¹, a²nũ²ai²li² sxi²ha² txon³nũn³nũ²nhai¹. Yxãn¹ta¹ jah¹lai²li² hai³txi³ a̱u³txi³ ũ³si³wxe²nxa³nũ²nhai¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² hã²wxãn³txa³nũ² ka³wã³lxa² hũx1thĩ¹na² a³hi²sxã³khox3je²nũ²nhai¹. Nxe³ju³tai²li² a²nũ²a² yãx1hĩ̱³nx2na³li¹. Txa²wãn³txa² sa²yxo²ã³te²su² te²a² te²yãx1hĩ̱³nx2na³li¹. Yxo²ĩ²sxã³ hxi²tha²on³te²ju²hẽ³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nxa²ha¹te¹ tũ̱¹ka̱³txai²na² e³kxi²ta³lun²ka³tu̱³ Ka³far³na³ũ²thĩ³na² ai³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ain¹tãu³a² Ro³ma²no² nũ̱³ka̱³txa² so³ta²to² a²wa³kxẽn³yah³la² yxau³ta¹hxai²hẽ¹la². Nxe³te²a² sxi²hẽ¹nai²na² a²sa³wi³sa² ĩ³ton³sxã³ ya³lu²kxi²te³lhxã³ sxa³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ai¹nha²kxai³ a²sa³wi³sa² a³lxi²ha²kxai³ Je³su²jah³la² ya̱u³son³jau³xa² ain³kxain¹ka³tu̱³ Ju³te²a² yah³la²nãu³xa² sa²si¹hã³ain¹te³nah¹lxi¹: — Je³su²jah³la² wxã³te³lhxã³ nxũ²nhai¹. Jau³xa³ ain³kxi²na¹wi¹. Tãu³a² ai³jah³lxi³sxã³ ne³khauh²jah³lxi³hẽ¹li¹. Ne³khau²hah³lxin¹kxai²nãn²tu̱³ ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. Ĩ³ye³kxah¹lxin¹te³nah¹lxi¹: “Jah¹la² sa³wi³sxa² ĩ³ton³kxi²sĩn¹na³li¹. Nxe³kxe³su² hxi²waun³ta³kxi²nha²sĩn¹na²li¹. Nxe³sĩn¹sxã³ wxã³sxã³ we²txi²si¹nxain¹sĩn¹jau³su² ĩ³ye³kxi²sain¹sĩn¹na²li¹.” Nxe³na¹jau³su² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Nxa²ha¹te¹ yah³la²nãu³xa²kxai³lu² a³li³ain¹nũ²la² Je³su²jah³la² ne³khau²hain¹nũ²la² win¹ta²jau³lxi³ ĩ³ye³kxah²lxi³te³nah¹lxi¹: — Nxex3si¹lxi¹. Je³su²jah³lãi³. Jah¹lai²li² wi¹lhin¹khaix1sĩn¹nhxai²na²hẽ³li¹. Txa²nũ̱³ka̱³txa² a³lxi²sa²sĩn¹nhxai²na²hẽ³li¹. Nxe³ha²kxai³ sxi²ha² a²nũ²kxi²nha¹thĩ³na² txon³kxi²sain¹sĩn¹na²hẽ³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² jah¹la² wi¹lhin¹sxã³ ain³kxi¹txai¹nhẽ³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ai¹nha²kxai³ ne³khauh²sxã³ ã³sa²so¹sxã³ tẽ³xĩ³xain¹nxa²ha¹te¹ jah¹la² sxi²ha² ya̱u³son³nũ²la² so³ta²to² wa³kxẽn³yah³la² sa³wi³sa² ã̱³xa² ĩ³hen³txain¹te³lhxã³ sa²si¹hã³ta¹hxai²hẽ¹la². Sa²si¹hã³te³nah¹lxi¹: — Nxex3sa²lxi¹. Txa²sxi²ha² wxã³txa³hẽ¹li¹. Txai²li² wxa²ye³na² kãin²sa²nxa³wi¹. Txa²sxih²nãu³a² wxã³sxã³ ã³wi¹hin¹ju³ta³nũ³a² ãu²li²sa³nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nxe³sa³ha²kxai³ wxã³sxã³ ã³tĩ̱³nxa²sxã³ ĩ³ye³kxi¹nxa²ha¹ju³ta² ãu²li²sa³nhai¹. Nxe³sa³ha²kxai³la¹ hãi¹nxe³sxã³ wãn³txa² u²lxi³ ĩ³ye³a³na¹in¹kxai²nãn²tu̱³ txa²sa³wi³sai²na² we²txi²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jã¹nxe³na¹jut3su² te²yã¹nxũn³na¹wi¹. Hxi²kan¹jah¹lo²su² yũ³sa²nũ³nha²kxai³ sa²yxo²wet1sain¹tũ̱³ka̱³txa² yũ³nũ³na¹ha²kxai³ te²sa¹wi¹. Nxe³sxã³ txa²sa³wi³sai²na² ai³si¹ha¹jau³su² ĩ³ye³kxi²na¹kxai²nãn²tu̱³ ai³hĩ̱³nx2na³li¹. Te²yã¹nxe³sxã³ txa²sa³wi³sa² ã̱³xai²li² wxã³si¹jau³su² ĩ³kaix1so¹na¹kxai²nãn²tu̱³ ya²la³tu̱³ ã³wxã³hĩ̱³nx2na³li¹. Te²yã¹nxũn³sxã³ txa²wa³ka³lxah³la² wa³kon³si¹ha¹jau³su² ĩ³ye³kxi²na¹kxai²nãn²tu̱³ ya²la³tu̱³ wa³kon³kxi²sai¹nhĩ̱³nx2na³li¹. Te²yã¹nxũn³te²sa¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nxa²ha¹te¹ jau¹xai²na² ain³kxi²nxa²ha¹te¹ Je³su²jah³la² ã³yxo²o³tũ¹nũ²la² tũ̱¹ka̱³txa² ã³nhi²tain¹tũ̱³ka̱³txa² ĩ³ye³kxi²te³nah¹lxi¹: — Ju¹tai²na² sa²kxai³lu² jah¹la²nũ¹tai²li² ĩ²sain¹te²sai¹nxa³nũ²nhai¹. Nxe³ta¹ yxo²ĩ²sain¹nũ²nhai¹. Yxãn¹ta¹ I³sa³e² nũ̱³ka̱³txa² a²yxo²ha³kxa¹ hxi²ka¹na¹ju³ta² ye³ka³lxa¹txi³ ĩ²sai¹nhxai²na²hẽ³li¹. Yxãn¹ta¹ kũ³we²ki²la² yxo²ĩ²sai¹nhxai²nxa³hẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxa² sa²kxai³lu² so³ta²to² wa³kxẽn³yah³lai²na² sxi²ha² wa³lxai¹nhĩ¹na² ĩ³ton³jah¹la²kxai³ we²txi²ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A³lan²nũn³tãu³a² Na³ĩ²thĩ³na² Je³su²jah³la²kxai³lu² ai³ta¹hxai²hẽ¹la². Ai³tãu³ãn²tu̱³ a²sa³wi³ha³lxa² ã³si³tẽ³kxi² a²nũ²a² ka³lxa¹txi³ ã³nhit1txi² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yãn³txai²na¹ sxi²je³nãn¹ta¹ka³lxu³su² a²wẽ³sa² ka³na³ka³na³jah¹la² so¹lxi³ a³li³lah¹ta¹hxai²hẽ¹la². Hã²wxãn³txa³ tu¹hai²na² a²wẽ³sãi¹yah³la² ya³lu²ta¹hxai²hẽ¹la². Hã²wxãn³txa³nũ² in³txa² wẽ³sa²kxai³ sa³nxe³la³kxi³lo³nhĩ¹na² ya³lu²nũn³ta¹hxai²hẽ¹la². Ya³lu²kxan²ta¹ in³txai²na² kwẽn¹ta²kxai³ ya³lu²jah¹lai²li² ki³li³la³kxi² sa²so¹sxã³ a³li³ain¹ta¹hxai²hẽ¹la². Nxe³ai¹nha²kxai³ sxi²je³na² yxau³tũ̱³ka̱³txa² ka³lxa¹txi³ ã³nhi¹nyhain¹ta¹hxai²hẽ¹la². Ã³nhi¹nyhain¹sxã³ sxi²je³na² ã³ya̱u³so³nhĩ¹na¹ a³li³tũ̱³ka̱³txin³ti² ĩ³ha¹txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ĩ³ha¹txain¹nũ²la² Je³su²jah³lo²kxai³lu² ĩ³yan³ta³kxi²nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³nã̱n³ta̱³nxi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nxe² e³kxi²ta³lun²nũ²la² hi³a² ka³lo³ẽ¹na² kwã̱³kxẽ¹na² ya̱u³son³kxi²nũ²la² wxa²wxai³sain³nũ²la² ki³li³la³kxi² sa²so¹tũ̱³ka̱³txa² ã³yit1tain¹ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ya³lu²jah¹la²kxai³ ĩ³ye³kxi²ti³an¹jau³kxai³lu¹: — Nxex3txi¹. Ĩ³sa²yxau³txi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nxa²ha¹te¹ ya³lu²jah¹la²kxai³ kwẽn¹tai²na¹ ĩ³sa²yxau³nũ²la² ĩ³ye³ã³si³wxe³ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² Je³su²jah³la² hi²sen³kxai³lu² in³txai²li² kwẽn¹ta² ka³te̱n³si²jah¹lai²na² sa²kxai³lu² wi¹lxo³kxi²nha²sxã³ a²hã³ka³na² sxi²ha² ã³wa̱³li²ta¹hxai²hẽ¹la². Ũ³hũ¹xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jã¹nxe³ju³tan¹te²kxa³ya̱n³tu̱³ti¹ tũ̱¹ka̱³txai²na² kãin² on²tain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² kãin²khaix1nx2na³li¹. Wi¹lĩ²nẽ³lain¹na³li¹. Nxe³nẽ³lai¹nha²kxai³ Sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹la² wxi²kan¹khaix1te²a² ĩ³sa²si¹hã³nẽ³lain¹na³li¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jã¹nxe³ain¹jut3su² jau¹xai²na² u²lxĩ³hen³txi³nyhain¹ta¹hxai²hẽ¹la². Ju³te²a²ko³xa² yxo²ha³kxa¹ a²wa³kã¹ko³xa² yxo²ha³kxa¹ nxe³jau³jau¹xa² ha³ta̱³nxe³ye²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nxa²ha¹te¹ ju¹tai²na² Jo³ãu² Ba³tis²jah³la² a²sa³wi³ha³lxa² ĩ²ain¹ta¹hxai²hẽ¹la². Ĩ²ain¹nũ²la² Jo³ãu² Ba³tis²jah³la² ĩ³hen³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ain¹nxa²ha¹te¹ Jo³ãu² Ba³tis²jah³la²kxai³lu² a²sa³wi³ha³lxa² ha¹li¹ ĩ³kaix1so¹nũ²la² sa²si¹hã³ain¹te³nah¹lxi¹: — Je³su²jah³lai¹tã³ nxe² ĩ³wã̱³txi³txai¹ya³hẽ¹li¹. “Je³su²jah³lãi³. Txa²wã¹sũ̱³na² Si³yxau³tãu³u¹tai²na² ĩ³sa²si¹hã³ũ¹sa³nxa²sĩn¹jah¹la² nhĩn¹ji¹wi¹? Nxe²nxã³kxai²nãn²tu̱³ a²nũ²a² ã̱³xa² wah³nxe³sa²si¹sĩn¹te³lin¹ji¹wi¹?” Nxe³txai¹ya³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nxa²ha¹te¹ a³li³ya³nhũ²la² Je³su²jah³la² ya̱u³so³nain¹nũ²la² ĩ³ye³kxi²ya³te³nah¹lxi¹: — Nxex3txi¹. Jo³ãu² Ba³tis²jah³la² ĩ³wã̱³txi¹nxa²si¹sain¹sĩn¹jau³su² e³kxi²sain¹sĩn¹te³nah¹lxi¹: “Txa²wã¹sũ̱³na² Si³yxau³tãu³u¹tai²na² ĩ³sa²si¹hã³ũ¹sa³nxa²sĩn¹jah¹la² nhĩn¹ji¹wi¹? Nxe²nxã³kxai²nãn²tu̱³ a²nũ²a² ã̱³xa² wah³nxe³sa²si¹sĩn¹te³lin¹ji¹wi¹? Nxe³tai¹ya³hẽ¹li¹.” Nxe³sain¹sĩn¹na²hẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nxe³ain¹ti̱³kxai³lu² Je³su²jah³la² hi²sen³kxai³lu² a²nũ²a² ĩ³ta³ka³txa² a²yxo²ha³kxa¹ ã²la² we²txi² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³li³si¹jau³su² ã²la² kwa³na³i² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Nxex3jah³wxi¹. Ju¹tai²li² kwẽn¹ta² ĩ²yah³hin¹ju³ta² wãn³txai²li² kwẽn¹ta² ain³kxa¹hin¹jau³xa² ĩ³hen³txi³ja¹hẽ¹li¹. Nxe³ju³ta²sa¹: Ye³han³te²su² te²a² ye³we²txi²ha²kxai³ ha³lxu³ha² ai³te²su² te²a² a²yu³wi¹lha²kxai³ a²nũ²a² khon³ta³kxi²sxã³ ka̱³lã̱un³ta³kxi²te²su² te²a² we²txi²ha²kxai³ a²ne³nxẽ³na² ne³ka³tũ³te²su² te²a² nxe³we²txi²ha²kxai³ a²nũ²a² ya³lu²te²su² te²a² ka³te̱n³su² ĩ³sa²yxau³xi²ha²kxai³ a²nũ²a² yen³kxi³txa²te²su² te²a² Sũ̱³na² wãn³txa² wi¹jau³xa² ko̱³nxe³ti³ kãi³ain¹ju³ta² wa³hxa² ã³wa²su¹ti³hit1tain¹ju³ta³nũ³a² nxe³jau³xan²tu̱³ ĩ³hen³txi³nyhai¹nha²kxai³ nxe³jau³su² ha³kxa¹ ĩ³hen³txi³ja¹hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Txa²wãn³txa² ĩ³wã̱³wã̱³txi³sxã³ sa²yxo²ã³sai¹nxa³te²su² te²a² wi¹lhin¹khaix1xain¹na³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nxa²ha¹te¹ ain³kxi²yah³nũ²la² ĩ³ya³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² ã³sa²wa³ti̱³nxa²xi²sxã³ a²nũ²a² ã³si³tẽ³la³kxi² te²nãu³xa² ĩ³ye³kxain¹te³nah¹lxi¹: — Jo³ãu² Ba³tis²jah³lai¹tã² ai³sxã³ ĩ²yah³lxi¹nhĩ¹nai³tã² ĩh¹nxe³te²he³la³kah³la³ ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? Ka³tĩ³ka³ti²nxã³nxa² kwa² sa³xit3sxã³ sa²hai³hain³jut3sũ̱³nxe² a²nũ²a² ĩ³wã̱³wã̱³ta³kxi²sain¹jah¹la² ĩ³te³lhxã³ ai³lyah³lxin¹thai¹li¹? ");
INSERT INTO nabNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nxe²nxa³kxai²nãn²tu̱³ ĩh¹te²he³la³kxah³la² ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? A²nũ²ai²na² yen³kxih³jah¹la² wã²la² a³lxi²khai¹nxe³ka³lo³a² au³khai¹nxe³ka³lo³a² wi¹khai¹nxe³ka³lo³a² ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? Nxẽn²nxa³wi¹. A²nũ²a² wã²la² wi¹khaix1ka³lo³a² wih²kxi²nha²te²he³la³kxa² a²nũ²a² sxi²ha² kãin² te²si³yxau³kxah³la² sxi²ha² so¹lxi³ yxau²xai³lain¹te²jai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nxe²nxa³kxai²nãn²tu̱³ ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ai³lyah³lxin¹thai¹li¹? Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹la² ĩ²te³lhxã³ ai³lyah³lxin¹thai¹li¹? Jau¹xai²na² wain³jau³xai²la¹wi¹. Yxãn¹ta¹ ĩ³hen³txi³tũ̱³ka̱³txa² ã³wa²to²hi²sxã³ yxau²sa²tẽ³jah¹lai²la¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Txa²wã¹sũ̱³na² wãn³txa² jau³xau³hxai²tẽx1 jau³xu¹tai²na² nxe³nẽ³te³nah¹lxi¹: “Ne³ka²a³sah¹lxi³wxi¹. Txa²sa³wit3su² ne³ka³ta²nxa²sxã³ ĩ³sa²si¹hã³a¹tu¹wi¹. Nxa¹kxai²nãn²tu̱³ a²nũ²a²nãu³xa² ĩ³tih³nxain¹tu¹wi¹. Txa²wãn³txa² Hxi²kan¹txa² Si³yxau³tãu³lo³jah¹lo²sih¹nxa²ha¹jau³su² nxe³jau³xai²na² ĩ³hau³ko³tain¹tu¹wi¹.” Nxe³ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jã¹nxa¹jau³su² ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²nãn¹jau³xai²na² wxi²kan¹jau³xai²la¹wi¹. Yxãn¹ta¹ Jo³ãu² Ba³tis²jah³la² wãn³txa² ĩ³tih³nxe³jau³xai²na² wxi²kan¹sxã³ wa³to²hi²na³li¹. Nxe³kxan²ti³nũ¹ Txa²sa³wi³ha³lxai²na² hxi²kan¹tũ̱³ka̱³txi³sai¹nxa³kxan²ti³nũ¹ wãn³txa² ĩ³hen³txi³si¹hai¹na¹jau³xai²na² wxi²kan¹sxã³ wa³to²hi²sa²tẽ³na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nxa²ha¹te¹ a²nũ²a² yxo²ha³kxa¹ wãn³txai²li² ain³kxain¹nũ²la² Txa²wã¹sũ̱³na² wain³txi³ kãi³ũ¹hain¹jau³su² Sũ̱³nu²kxai³lu² sa²nẽn¹kxain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²li² kxã³nxai³tã² Jo³ãu² Ba³tis²jah³la² hi²sen³su² ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹ain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ a²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txa² te²yã¹nxain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ain¹ta¹ fa³ri³se²a² nũ̱³ka̱³txi³su² te²a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txi²su² te²a² nxe³te²su² Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²ã³ain¹ta¹hxai²hẽ¹la². Kxã³nhxĩ¹nai³tã² Jo³ãu² Ba³tis²jah³la² hi²sen³kxai³lu² hai³txi³ ĩ̱³yau³xa² ũ³hũ¹kxi²sa²sai¹ain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ãh¹lxi³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³yãn¹ta¹ a²nũ²a² a²hĩ¹nãn¹te²nũ̱³ka̱³txi³nãu³xa² ĩh¹nxe³kxe³hũ̱³nhĩ̱³te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wẽ³ha³lxa² yã¹nxain¹na³li¹. Sxi²je³na² kwa² wa³ni̱³lo³nain¹te²ju²hẽ³li¹. Wa³ni̱³lon³sxã³ kaix1nyhu¹ain¹te³nah¹lxi¹: “Wãn³txa² wi¹lhin¹jau³xa² ĩ³hain³kxi²sĩn¹nx2ta¹tai¹ti²tu³wi¹. Yxãn¹ta¹ ĩ³ka³li³kxi²ya³sai¹nxãn³tai¹ti²tu³wi¹. Hã²wxãn³txa³nũ² ĩ³ãin²ta³kxi²jau³xa² ĩ³hain³kxi²sĩn¹nx2ta¹tai¹ti²tu³wi¹. Yxãn¹ta¹ nã̱n³kxi²ya³sai¹nxãn³tai¹ti²tu³wi¹.” Nxe³kxe³hũ̱³sxã³ a²nũ²a² a²hĩ¹nãn¹te² nũ̱³ka̱³txi³nãu³xa² kã³nxai³tãn¹tũ̱³ka̱³txa² yã¹nxain¹na³li¹. Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txa² en²tain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jã¹nxe³jut3su² Jo³ãu² Ba³tis²jah³la² wxã³hĩ¹nai³tã² yain³txa² kwa²hãi¹nxe² ã³na¹ha²kxai³ vĩn²yau³xa² ĩ³na²xa³ha²kxai³ Jo³ãu² Ba³tis²jah³la² ta¹hxai²hẽ¹li¹. Nxe³te³na¹ a²nũ²ai²na² en²txain¹sxã³ wãn³txa² wai³nxa³jau³su² e³lain¹te³nah¹lxi¹: “Jo³ãu² Ba³tis²jah³lai²li² ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³yxau³jah¹lo²sin²tai¹.” Nxe² e³lain¹na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jã¹nxẽn³ta¹ Txai²li² wxã³na¹hĩ¹nai³tã² yain³txa² ĩ³yai³ni² yain³jau³xa² ĩ³na² nxa¹tai¹ti²tu³wi¹. Nxe³na¹ta¹ a²nũ²ai²nãn²ta² wãn³txi³kxai³lu¹, en²kxi²sain¹te³nah¹lxi¹: “Je³su²jah³lai²na² yain³txa² kãin²yain³jah¹lai²la¹wi¹. Yain³jau³xa² ĩ³na²sa³wen¹jah¹lai²la¹wi¹. A²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txi³nãu³xa² ko̱³nxe³thin¹tũ̱³ka̱³txa² nxe³sxã³ ã³ya̱³lxi²nyhain¹jah¹lai²la¹wi¹.” Nxe²e³lain¹na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nxe³lain¹kxan²ti³ a²nũ²ai²na² a²hoh³lxi³su² te²a² wain³txi³ kãi³kxai²nãn²tu̱³ a²wẽ³ha³lxa² wain³txi³ kãi³ain¹nũn³tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nxa²ha¹te¹ a²nũ²a² fa³ri³se²ah³la² ĩ³kaix1so¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ã³wxã³sẽ¹li¹. Txa²sxi²ha² yain³ya³sa³wi¹. Ta¹hxai²hẽ¹la². Ai¹nha²kxai³ Je³su²jah³la² ĩ³sa²yxau³sxã³ wxã³nũ²la² sxi²hẽ¹nãu³a² ã³wih¹sxã³ ã³wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Ain¹nxa²ha¹te¹ txu¹ha² sxi²je³na² yxau²xai³ta¹ka³lxa² ko̱³nxe³thin¹ta¹ka³lxu³su² ta¹hxai²hẽ¹la². Nxe³ta¹ka³lxa² hi²sen³su² fa³ri³se²ah³la² sxi²ha² ĩ³yai³nain¹jau³xa² ain³kxi¹nxa²ha¹te¹ wi¹lũ³jau³xẽ¹na² ne³kih¹tẽ³na² tẽ³sxã³ tĩ̱³ta¹hxai²hẽ¹la². Je³su²jah³la² a²yon³nãu³a² wxã³sxã³ ã³wxe³ta¹hxai²hẽ¹la². Ã³wxe³ka³tu̱³ kãin² nã̱n³kxe³su² a²ye³yãu³sxa² ã³yu³kxẽ¹kxi²ta¹hxai²hẽ¹la². Nxe³nũ²la² ta¹ka³lxai²na² a²ne³kĩ̱³sai²na² Je³su²jah³la² a²yu³kxa² sa²yu̱³hon³ta³kxi²ta¹hxai²hẽ¹la². Ĩ³yu̱³jut1sxã³ ĩ³yu̱³sai¹la³kxi²ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ wi¹lũ³jau³xai²na² ãn³yu̱³kẽn¹kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nxa²ha¹te¹ fa³ri³se²ah³la²kxai³lu² ju¹tai²na² ĩ²ain¹nũ²la² a²ẽ¹na² ĩ³ye³kxi²nha²jau³kxai³lu¹: — Jah¹lai²li² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²su² ke³la³te²kxai³ ta¹ka³lxai²na² ko̱³nxe³thin¹te²sin¹ju³ta² wi¹ko̱³nha²hĩ̱³nx2na³na¹. Yxãn¹ta¹ ti³he¹yxe²nxãn³tã¹. Nxe³nha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nha¹nxa²ha¹te¹ Je³su²jah³la²kxai³ e³kxi²te³nah¹lxi¹: — Si³mãu²ah³lãi³. Ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi¹nxa²ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — Ĩ³ye³kxi²sẽ¹li¹. Ain³kxi¹nxa²ha¹tu¹wi¹. Fa³ri³se²ah³lai²na² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — In³txa² ha¹lin¹te²su² te²a² yen³kxi³txa²ya³nhu²nhai¹. Ya³ha²kxai³ a²wa³kxẽn³yah³la² kwa² ũ³hũ¹si²yha³jau³su² ĩ³ye³kxi²ya³nhũ²nhai¹. Ya³ka³tu̱³ kwa² ũ³hũ¹nũ²nhai¹. Ka³na³ka³nat3te²a² ha³te̱h³nxã³nxa² 500 txã³nxa² kãin²txã³nxa² ũ³hũ¹ha²kxai³ ã̱³xah³la² ha³te̱h³nxã³nxa² 50 txã³nxa² kãi²nxa³txã³nxa² ũ³hũ¹ha²kxai³ nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hã²wxãn³txa³ ha³te̱h³nxã³nxa² ũ³hũ¹xi²je³na² ti³wa³ki³lon³ta¹ ha³te̱h³nxã³nxa² yũ³ya³hxa³ha²kxai³la¹ hxi²kan¹ya³hxa³nũ²nhai¹. Yah²hxa³ha²kxai³ a²wa³kxẽn³yah³lai²na² hi²sen³kxai³lu² ĩ³yan³ta³kxi²nyha¹ha²kxai³ ũ³yho³hxi²txã³nxa² ũ³hũ¹xi²ya³ju³ta² ã³wa²su¹kxi²nũ²nhai¹. A²nxe³ju³kxai³lu² nxe³ain¹kxai²nãn²tu̱³ ĩh¹te²la³ta̱³ ha³te̱h³nxã³nxa² a²wa³kxẽn³yah³la² a³lxi² wa³to²hi²te²la³hĩn³te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nxa²ha¹te¹ Si³mãu²ah³la² wãn³txi³kxai³lu¹: — Ha³te̱h³nxã³nxa² kãin²txã³nxa² ã³wa²su¹kxi²te²la³hĩ̱³nx2na³li¹. Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Wain³txi³ ĩ³yĩ¹li¹lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nxe³ha²kxai³la¹ txu¹hai²li² wxa²la̱k1kxi²nũ²la² ãh¹ ĩ³ye³te³nah¹lxi¹: — Si³mãu²ah³lãi³. Ne³ka²sa²sa²lxi¹. Wxa²sxi²ha² ã³wi¹ha¹ten¹tu³wi¹. Na¹ta¹ wxãi²li² wxa²yu³hi̱n³ta³kxih²sã²nxãn³ten¹tu³wi¹. Nxẽ²nxãn³ta¹ ta¹ka³lxai²li² a²ye³yãu³sxa² wxa²yu̱³hi̱n³ta³kxi²sain¹nũ²la² a²ne³kxĩ̱³sxa² sa²yu³hon³ta³kxi²sain¹ten¹tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wxãi²li² ĩ³yxo²jut1sã²nxãn³ten¹tu³wi¹. Yxãn¹ta¹ ta¹ka³lxai²li² ĩ³yu̱³yu̱³jut1sa²sxã³ sa²ju³ti³na² hai³txi³ ã³na¹xa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wxãi²na² wxa²ne³to̱¹lyxau³sa²nxãn³ten¹tu³wi¹. Yxãn¹ta¹ ta¹ka³lxa² wi¹lũ³jau³xa² tẽ³sxã³ ũ³yhu̱³to¹la³kxi²sain¹ten¹tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nxe³ju³tan¹te²kxa³ya̱³lhu² ta¹ka³lxai²na² kuh³lxa³sin¹khaix1ta¹ka³lxu³su² te²jai¹ti²tu³wi¹. Yxãn¹ta¹ kuh³lxa³sin¹ta² kãi³kxai³tã² ã³na¹ha²kxai³ kãi³ju³tai³tã² wah³yu³ta² ne³wã²na³kxi²sa²tẽ³a¹hẽ³li¹. Nxe³ju³tan¹te²kxa³ya̱n³tu̱³ti¹ kãin² a³lxi²sain¹na³li¹. Nxe³kxa²ha³tih³xan²tu̱³ a²nũ²a² ĩ²li³te²su² te²na² sa²kxai³lu² ko̱³nxe³ti³ kãi³kxa² a²wah³yu³ta² kãi²nxa³ke³la³te²kxai³ ne³wã²na³kxi²sa²tẽ³a¹ju³ta² kãi²nhĩ̱³nx2nxa³wi¹. A²nxe³te²he³la³kxai²na² jũ¹nxa² so¹lxi³ a³lxi²sai¹nhĩ̱³nx2na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nxa²ha¹te¹ txu¹ha² e³kxi²te³nah¹lxi¹: — Wxa²ko̱³nxe³ti³ kãi³in¹ju³ta² ne³wã²na³kxi²sa²tẽ³kxi¹nxa²ha¹hẽ³ni¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nxa²ha¹te¹ yai³nain¹tũ̱³ka̱³txa²kxai³lu² ĩ³ye³lain¹te³nah¹lxi¹: — Ĩh¹te²la³ta̱³ ko̱³nxe³ti³ kãi³ki̱³ju³ta² ya²la³tu̱³ ne³wã²na³kxi²nẽ³te²la³hĩ̱³ji¹wi¹? Nxe³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nxa²ha¹te¹ Je³su²jah³la² sa²kxai³lu² txu¹ha³ka³lxa²kxai³lu² e³kxi²te³nah¹lxi¹: — Txa²wãn³txa² yxo²ĩ²sa¹nha²kxai³ wxa²ẽ¹nãu³ai²na² wi¹lhin¹ti³hi¹txa²ha¹hẽ²ni¹. Nxe³nxa²ha¹ha²kxai³ wi¹lhin¹sxã³ ĩ³sẽ¹ni¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hã²wxãn³txa³ sxi²jen³nãu³a² kãin²thĩn³su² ta̱³nxa² kãi²nxa³thĩn³su² ta̱³nxa² hãi¹nxe³thĩ³na¹ ai³lha²thet3ta¹hxai²hẽ¹la². Nxe³tãu³a² Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² a²hxi²kan¹txa² si³yxau³tãu³lot3ju³ta³nũ³a² nxe³jau³xa² ĩ³yau¹ũ³ta¹hxai²hẽ¹la². Nxe³ti̱³kxai³lu² a²sa³wi³ha³lxa² hxi²ka² hxan³sxã³ ãh¹ ha¹li¹ wxa²sa²so¹kxi²sxã³ nxe³tũ̱³ka̱³txa² ã³si³tẽ³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Nxe³ain¹ka³tu̱³ta¹ txu¹ti³nãu³xa² ka³lxa¹txi³ ã³si³tẽ³kxi²nyhain¹nũn³ta¹hxai²hẽ¹la². Nxe³tũ̱³ka̱³txa² kã³nxa² Je³su²jah³la² hxi²ki³kxai³lu² we²txi²nyhain¹ta¹hxai²hẽ¹la². Ĩ³ta³ka³khai³xa² we²txi² a²nũ²a² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxaut3te²a² nxũ²kwa̱i³li³si¹hain¹jau³su² kwa³na³i² nxe³ain¹ta¹hxai²hẽ¹la². Nxe³tũ̱³ka̱³txa²sa¹: Ma³ri²a² Ma³ta³lẽ²na³ka³lxu³su² ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxa² ko̱³nxe³te²a² yãu³ka³txa² hi²sen³su² ã³nxũ²kwa̱i³yxaut3ta¹hxai²hẽ¹la². Yãu³ka³txa² ha¹li¹ ha¹li¹ ha¹li¹ ka³na³ki¹ ã³nxũ̱²kwa̱i³wih¹ain¹ta¹hxai²hẽ¹la². Nxe³ta¹ka³lxai²na² Je³su²jah³lo²kxai³lu² nxũ²kwa̱i³li³xi²si¹hain¹jau³su² kwa³na³ta¹hxai²hẽ¹la². Ai¹nha²kxai³ Jo³ã²na³ka³lxai²na²su² in³txa² so¹ha²kxai³ Ku²sah³lo²su¹ ta¹hxai²hẽ¹la². A²nxe³jah¹la² E³ro²jah³la² a²sa³wi³sa³la³ta¹hxai²hẽ¹la². Ai¹nha²kxai³ Su³sã²na³ka³lxa² ã³si³tẽ³kxi² txu¹ti³nãu³xa² ka³lxa¹txi³ Je³su²jah³la² hi²sen³kxai³lu² we²txi²nũ¹hain¹ju³tan¹te²kxa³ya̱³lhu² ã³si³tẽ³kxi²nyhain¹ta¹hxai²hẽ¹la². Nxe³ain¹jut3su² Je³su²jah³la² nũ̱³ka̱³txa² yen³kxi³la³ yũ²nxa³ha²kxai³ wã²nhũ¹nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nxe³ain¹nũ²la² a²nũ²a² ka³lxa¹txi³ nũ¹nain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² Je³su²jah³la²kxai³lu² wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²ai²na² hai³sxa³nãu³a² ai³nũ²nhai¹. Yain³ta³ki³a² wi¹ki³a² ũ³whĩ̱¹te³lhxã³ wxa²sa²tãu³wa³ya²txũ³lhain¹sxã³ ũ³whĩ̱¹nũ²nhai¹. Ũ³whĩ̱¹tãu³a² yain³ta³ki³ai²na² ki³ka³na³ku² ki³su² ki³a² tĩh³na² yxo²ki³sa² ã³yun¹na³nũ²nhai¹. Ã³yun¹na³tãu³ a²nũ²a² ai³sxã³ ti̱³ti³ha²kxai³ a̱i³ka³nãu³xa² wxã³sxã³ yai³nhxa³kxi²ha²kxai³ nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ãh¹ki³ka³na³ku² ki³su² ki³a² kxĩh³nũ̱³xa² a̱u³txi³ si³tah³lxi³ kxĩh³nũ̱³xa² ã³yun¹na³nũ²nhai¹. Nxe³nũ²la² ka³lũ³nũ²la² ĩ̱³yau³xa² yũ²nxa³kxe³su² ĩ³wa³ne²ni² wxãn³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ãh¹ki³ka³na³ku² ki³su² ki³a² ha³lo²a² ũ³yen³ko³xa² ã³yun¹na³nũ²nhai¹. A²nxe³ki³ai²na² sa²kxai³lu² ka³lũ³xi²nũ²nhai¹. Nxe³ta¹ ũ³yen³ko³su² ha²kxai³ hi³a² kha¹ka³txa² ka³lxa¹txi³ ka³lũ³ye²nũ³nha²kxai³ nxe³te²kxai³lu² yain³ta³nxe²kxa² wã²ne³sa³te³kxi²sxã³ ya²lun¹txi²ye²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nxe³yãn¹ta¹ ãh¹ki³ka³na³ku² ki³su² ki³a² kxĩh³nũ̱³xa² ti̱³ti̱n³kxĩ̱h³nxa² ã³yun¹na³nũ²nhai¹. A²nxe³ki³ai²na² sa²kxai³lu² wi¹ka³lũ³ha²kxai³ wi¹we¹nha²kxai³ yain³txa² kãin² ki³kan²kxi²ha²kxai³ kãin² sxa³nũ²nhai¹. Jã¹nxa¹jau³su² wi¹ko̱³nyhah¹lxi³ti³ten³nxa²lxin¹kxai²nãn²tu̱³ wi¹lain³kxi¹sah¹lxi³hẽ¹li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxi³nũ̱³ka̱³txa² ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². Ĩ³wã̱³txain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Jau¹xai²na² a²si³yxau³tãu³khai³xa² ĩh¹te²ta̱n³te²la¹xã³? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nxa²ha¹te¹ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wxa²yu³tai²na² so¹lxi³ wãn³txai²na² tah²yau³xai²na² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² a²nũ²a² ẽ¹nãu³a² sa²hau³ko³jau³nũ³su² nxe³jau³jau¹xai²na² txa²nũ² ã³ne³wxe³yah³lxin¹tu¹wi¹. Yxãn¹ta¹ tũ̱¹ka̱³txai²na² hĩn¹ti² ti³he¹xai¹nxa³wi¹. Wãn³txa² ĩ³yau¹ũ³jau³xa² so¹lxi³ e³kxai¹na¹wi¹. Nxai¹na¹kxan²ti³ ĩ²ain¹kxan²ti³ ã³ye³wxe³ai¹nxa³lho³li¹. Ain³kxain¹kxan²ti³ ã³ne³wxe³ai¹nxa³lho³li¹. Yxãn¹ta¹ wxãi²na² wi¹lĩ²yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","12","Jã¹nxe³ha²kxai³la¹ wãn³txa² ĩ³yau¹ũ³jau³xa² a²si³yxau³tãu³khai³xa²sa¹. Yain³txa³ki³ai²na² sa²kxai³lu² Txa²wã¹sũ̱³na² wãn³txa² te²yã¹nx2na³li¹. Ki³ka³na³ki² tĩh³na² ne³ku̱n²nãu³a² a³hi²yain¹ki³ai²na² a²nũ²a² ain³kxain¹te²la³ te²yã¹nx2na³li¹. Nxe³te³na¹ Sa³ta³na²jah¹lai²na² sa²kxai³lu² wxã³nũ²la² a²ẽ¹nãu³ai²na² a²jau¹xa² sa²kxai³lu² sa²sai²lho¹kxi²nyhain¹na³li¹. Sũ̱³na² wãn³txa² yxo²ĩ²ain¹kxai²nãn²tu̱³ ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² ã³wa²su¹tũ¹hain¹kxa²ya̱n³txi³su² sa²sai²lho¹kxi²nyhain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ki³lã̱³xa² kxĩh³nũ̱³xa² a²si³tah³nãu³a² tah³lxa³kxa² hãi¹kxi²ju³ta² a³hi²yain¹ki³ai²na² ne³ki³ai²nãn²tu̱³ kxĩh³nũ̱³xa²nãu³a² a²nxe²ka² a̱u³txi³ yxau²nxa³kxe³su² wi¹we¹nxa³wi¹. A²nxe³kxa² yã¹nxe³sxã³ a²nũ²a² yã¹nx2na³li¹. Txa²wã¹sũ̱³na² wãn³txa² yxo²ĩ²ai¹nha²kxai³ ka³li³hain¹na³li¹. Yxãn¹ta¹ hã²wxãn³txa³ ha³lo²a² ko̱³ton³tãu³a² Txa²wã¹sũ̱³na² wãn³txa² ã³na¹la³kxi²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Te²yã¹nxũn³sxã³ ki³lã̱³xa² ũ³yen³ko³xa² a³hi²yain¹ki³ai²na² nxe³ki³ai²nãn²tu̱³ hxi²kan¹txi³ wi¹we¹nxa³wi¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² ki³kan²kxi²te²a² wxa²ni²lho¹kxi²nyhai¹nxa³wi¹. Nxe³ki³ai²na² a²nũ²a² yã¹nx2na³li¹. Txa²wã¹sũ̱³na² wãn³txa² ain³kxain¹na³li¹. Ain³kxain¹te³na¹ ha³lo²a² hxi²waut3ta³lxain¹to³ha²kxai³ a²yen³kxa² kãin² yxo²kwa̱i³nai¹nha²kxai³ kwa² wa³ni̱³lon³sxã³ yxau²xai³lai¹nha²kxai³ nxain¹na³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² yxo²ĩ²sxã³ yxau³ai¹nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Te²yã¹nxũn³sxã³ ki³lã̱³xa² kxĩh³nũ̱³xa² ti̱³ti̱³nũ²tũ̱³xa² a³hi²yain¹ki³ai²na² a²nũ²a² yã¹nx2na³li¹. A²nxe³te²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ wi¹ko̱³nha²so¹ain¹na³li¹. A²nxe³te²a² a²ẽ¹nãu³ai²na² wi¹lhin¹sxã³ Txa²wã¹sũ̱³na² wãn³txa² ya³nãn³ta³ki²la²sxã³ kan²txi³ sa²yxo²we¹tain¹na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ãh¹lxi³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Te²yã¹nxe³jut3su²: “Lã³pi³ãu²tẽ³na² tẽ³sxã³ sa²kĩ̱x3ta¹tũ¹xã¹.” Nxe³ki̱³kxai²nãn²tu̱³ ĩh¹nũ¹la³ta̱³ ũh³wxe³hĩ̱³ki̱³te²la¹xã³? Hai³txi³ kwa³ta³lẽ³tã³ ũ³tĩ¹kxi²ki̱³sxa³ha²kxai³ hai³txi³ ka²ma²ka³lo³la³ yuh³hẽ³nãu³a² ũh³wxe³ki̱³sxa³ha²kxai³. Nxe³ki̱³sxa³kxan²ti³ oh³xa² ũ³kũh¹sĩ̱³ki̱³tã³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² sxi²ha² whãi²na¹ wxa²ko²ko²txi³hĩ̱³nx2na³li¹. Nxe³ki̱³kxai²nãn²tu̱³ thĩ¹nai²na² a²nũ²a² ã³wih¹kxai²nãn²tu̱³ wi¹lĩ²ki̱³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jã¹nxa¹jut3su² kxãn³nãu³ãn²tu̱³ Txa²wã¹sũ̱³nu²kxai³lu² Oh³na² yxau³jah¹la²kxai³lu² yen³kxa² hãi³te²a² whãi²na¹ wã²nã³ũ¹nx2ti³tu¹wi¹. Jã¹nxe³sxã³ Txa²wã¹sũ̱³na² yen³kxa² ũ³ho¹ain¹kxa² whãi²na¹ ĩ³yau¹ũ¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jã¹nxe³jut3su² wãn³txa² ain³kxah²lxin¹jau³xai²na² wi¹lain³kxi¹jah³lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ wãn³txa² kãin² yxo²ĩ²yah³lxin¹kxai²nãn²tu̱³ kãin² yen³kxih¹nxa²lxain¹tu¹wi¹. Yxãn¹ta¹ yxo²ĩ²ti³he¹xah³lxan³kxai²nãn²tu̱³: “Yen³kxa² yũ³sa²sĩn¹tũ¹xã¹.” Nxe³yah³lxin¹kxan²ti³ sa²so¹hxa³kxi¹nx2tain¹tu¹wi¹. Nxe³jau³su² Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ain¹nxa²ha¹te¹ Je³su²jah³la² a²hã³ka³na² a²lon³ti³tãu³xa² ã³wxã³ain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ a²nũ²a² ka³lxa¹txi³ ã³ka²lxa¹ti³nha²sxã³ yxau³e²nyhai¹nha²kxai³ hxi²kan¹txi³ ã³nhe²kxi²nyhain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ain¹nxa²ha¹te¹ a²nũ²a² sa²kxai³lu² Je³su²jah³la²kxai³ ĩ³hen³txi³nyhain¹te³nah¹lxi¹: — Nxex3txi¹. Wxa²hã³ka³na² wxa²lon³txi³tãu³xa² ĩ²nxa²te³lhxã³ wxã³ain¹na³li¹. Ha³lo²a² yxau³ain¹na³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nxe³ha²kxai³ ĩ³wa²lũ³xi²nyhain¹ti³ãn¹jau³kxai³lu¹: — Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²we¹nyhain¹te²a² txa²hã³ka³na² txa²lon³txi³tãu³xa² te²yã¹xain¹na³li¹. Nxe³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nxa²ha¹te¹ Je³su²jah³la² sa²kxai³lu² a²sa³wi³ha³lxa² whãi²na¹ tẽ³nũ²la² ka³no¹a² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wi¹hain¹nũ²la² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ̱³ye³na² Ka³li³le²a²ye³na² yxo²ha³ti³li³yha³sah¹lxi³wxi¹. Nxe³jau³kxai³lu² e³kxi²nũ²la² ũ̱h³nxũ̱³sa²tã³nũ̱¹xi²sxã³ ai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ai³ain¹tãu³a² Je³su²jah³la² ã̱u³xi²te³lhxã³ sxa³yain¹ta¹hxai²hẽ¹la². Ãu³xi²yain¹kxa²si³yo³na² it3ta² ũn³te²a² sa²xit3jain¹ta¹hxai²hẽ¹la². Sa²xit3jain¹te³na¹ ka³no¹ai²li² ĩ̱³yau³xa² sa²ni³sa²wih¹yain¹ta¹hxai²hẽ¹la². Nxe³ain¹ju³tan¹te²kxa³ya̱³lhu² ã³nxũ¹te³lhxã³ yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nxe³nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xai²na² sa²kxai³lu² Je³su²jah³lo²su² te²kxai³lu² wxa²yũn³kxi²sxã³ ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³la² txa²hxi²kan¹jah¹lãi³. Nxex3si¹lxi¹. Ã³nxũ¹txe³lhĩn¹te³na³li¹. Nxe³ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ Je³su²jah³la²kxai³lu² txu¹lxi²ka³tu̱³ it3tai²na² ĩ̱³ye³na² ũ̱n³je³nai²na² yxo²xũ̱n³txi³ ĩ³kwa̱i²kxi²ta¹hxai²hẽ¹la², it3ta² ã³wxe³si¹jau³sa². Nxe³ju³tan¹te²kxa³ya̱³lhu² sa²hãu²not3sxã³ ã³yit1je²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nxe³nxa²ha¹te¹ sa²hãu²not3sxã³ ã³yit1txã²ha¹te¹ Je³su²jah³la² a²wãn³txi³kxai³lu¹: — Hxi²ka¹na¹ju³ta² yxo²ĩ²sah²lxin¹ta²nxa³wi¹. Ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ on²txai¹nha²kxai³la¹: — Ĩh¹te²la³khai³nxe³ji¹ku¹. Ki̱³nhai¹. It3ta² ũn³te²a² ã³wxe³si¹jau³su² ĩ̱³ye³na² sa²hãu²not3si¹jau³su² ain¹ten¹tu³wi¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nyhain¹nxa²ha¹te¹ ĩ̱³ye³na² yxo²ha³ti³li³nxa²ha¹te¹ Je³ra²sa²ko³xa² ai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Ai³ain¹nxa²ha¹te¹ Je³su²jah³la² sa²kxai³lu² ka³no¹a² a³li³nũ²la² in³txa² ĩ³ha¹txi²ta¹hxai²hẽ¹la². A²nxe³te²a² ko̱³nxe³te²a² a²yãu³ka³txa² ã³nxũ²kwa̱i³wi¹ta¹hxai²hẽ¹la². Ye³ka³lxa¹txi³ ã³wih¹to³ta¹hxai²hẽ¹la². A²nxe³jah¹la²kxai³ hai³txi³ wã²la²ka³lo³la³ ũ³whi²kxih²nh²nxa³ha²kxai³ hai³txi³ a²sxi²lha³ sxa²nxa³ha²kxai³ nxe²nxa³ha²kxai³la¹ hãi¹sxã³ ha³lo²a² a²nũ²a² ya³lu²te²a² sxa³ko³xa² so¹lxi³ ho³ta¹hxai²hẽ¹la². Nxe³ju³ta² Je³ra²sa² nũ̱³ka̱³txa² hi²sen³kxai³lu² kwa³thi³lĩh³na² hxi²tẽ³nha²sxã³ sa²hxi²tai³kxain¹to³ta¹hxai²hẽ¹la². Ain¹kxan²ti³nũ¹ jah¹la²nũ¹ta²kxai³lu² sa²hxi²hxa̱u³kxi²nha²sxã³ sa²hxi²tai³kxain¹tĩh³na² sa²yo³li³yain¹to³ta¹hxai²hẽ¹la². Nxe³ju³kxai³lu² ko̱³nxe³te²a² yãu³ka³txa² hi²sen³kxai³lu² a²nxũ²kwa̱i³wi¹jah¹la² kwa³na³ain¹to³ta¹hxai²hẽ¹la². Ha³lo²a² a²nũ²a² yxau³ai¹nxa³ko³xai²na² kwa³na³sxã³ ai³si¹ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ jah¹la² sa²kxai³lu² Je³su²jah³la² ĩ²ain¹tãu³a² hxi²kan¹sxã³ ã³sen³sai¹ta¹hxai²hẽ¹la². Nxe³jut3su² a³la³kxi²nũ²la² a²ne³kxaix3tãu³a² ã³ka³ti³wxe³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹ ko̱³nxe³te²a² yãu³ka³txa² a²ne³nxẽ³na² kwa³na³te³nah¹lxi¹: — In³txai²na² a³li³xi¹jah³lxi³hẽ¹li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². Nxe³te³na¹ in³txa² ĩ³wxan¹sxã³ ĩ³kaix1ta¹hxai²hẽ¹la². Ĩ³kaix1te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²wã¹sũ̱³na² Si³yxau³jah¹la² Tah²si¹lxi¹. Ĩh¹nxe³sa²te³lin¹ji¹wi¹? Ĩ³khãuh³lxa³ti³sa²txa³hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²nyha¹te³an¹jau³kxai³lu¹: — Ĩh¹nxet3sxã³ ĩ³yĩ¹li²nhãn¹ji¹wi¹ wxa²ĩ³lxa²su¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ĩ³wa²lũ³xi²nyhu¹ti³ãn¹jau³kxai³lu¹: — Txa²ĩ³lxa² Yxo²ka³lxa¹jah¹lo²sa¹wi¹, ka³lxa¹khaix1te²sa²sĩ¹nha²kxai³lu¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nxe³ha²kxai³la¹ ãh¹ ĩ³ye³kxain¹te³nah¹lxi¹: — Ha³lo²a² ĩ³khãuh³lxa³ti³sa²sĩ¹nhĩn¹jen³nũ³a² sa²si¹hã³sa²sĩn¹txa³hẽ¹li¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nxe³nyhain¹nxa²ha¹te¹ wã³la³ti²ka³nãu³a² ka³yxuh³xa² yxa³kxa² ka³lxa¹txi³ ũ³nyhai¹tain¹to³ta¹hxai²hẽ¹la². Nxe³ain¹ye²ha²kxai³ ko̱³nxe³te²a² yãu³ka³txa² sa²kxai³lu² Je³su²jah³la²kxai³ ĩ³wã̱³txain¹ti³an¹jau³kxai³lu¹: — Yxa³kxa³nãu³xa² ĩ³sa²si¹hã³sa²sĩ¹nhẽ³li¹. Ka³yxuh³xai²na² a²nxũ²kwa̱i³wi¹kxain¹ti³ten³sa²sĩ¹nhai¹. Ain¹jau³kxai³lu² nxa²ha¹te¹: — Jã¹nxe³jah³lxi³hẽ¹li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ain¹nxa²ha¹te¹ ko̱³nxe³te²a² yãu³ka³txai²na² sa²kxai³lu² in³txi³su² te²kxai³lu² nxũ²kwa̱i³li³xi²nũ²la² yxa³kxa³nũ¹ta²kxai³lu² a²nxũ²kwa̱i³wi¹hain¹ta¹hxai²hẽ¹la². Ain¹ju³tan¹te²kxa³ya̱³tu̱³ti¹ yxa³kxa³nũ¹ta²kxai³lu² a²wã³la³ti²ka³nãu³ai²na² ã³ni³hi²kan³sxã³ ĩ̱³ye³na² ã³yu¹nũ̱³sxã³ ĩ³lo³nxi² ya²lun¹ti²hxan³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nxe³te²kxa³ya̱n³tu̱³ in³txai²na² yxa³kxai²na² wa³kxẽ³nãu³xa² ĩ²ain¹nũ²la² yuh³lxa³txi³ ã³ni³hain¹ta¹hxai²hẽ¹la². Sxi²yhe³na² ã³ni³hi² Je³ra²sa²ko³xa² ã³ni³hi² ain¹sxã³ ha³lo²ai²na² ĩ³ye³kxa²sa²sai¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nyhain¹nxa²ha¹te¹ tũ̱¹ka̱³txai²li² wxã³sxã³ ĩ²ye²nyhain¹ta¹hxai²hẽ¹la². Wxã³sxã³ ĩ²ye²nyhain¹te³na¹ Je³su²jah³lo²kxai³ ya̱u³so³nain¹te³na¹ ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³li³jah¹la² ĩ²ain¹ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² sa²kxai³lu² Je³su²jah³lai²na² a²ne³kxai³tãu³a² ã³wxe³sxã³ yxau³ye²ta¹hxai²hẽ¹la². Nxe³ye²hĩ¹nãn¹te²tu̱³ wã²la² ũ³whi²kxi²nha² wain³txi³ wã²nxũ̱¹ha̱in³nha² nxe³ye²ta¹hxai²hẽ¹la². Nxe³ju³kxai³lu² tũ̱¹ka̱³txai²li² wxã³ain¹tũ̱³ka̱³txa² ĩ²ain¹ju³tan¹te²kxa³ya̱³lhu² on²txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ain¹nxa²ha¹te¹ ĩ²ta³lu²nain¹nũ²la² ĩ³xain¹ta¹hxai²hẽ¹la². Ĩ³xain¹tãu³a² in³txa² we²nxi²ju³tĩ³na² ĩ³hen³txi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nxe³nyhain¹ju³tan¹te²kxa³ya̱³lhu² a²nũ̱³ka̱³txa² Je³ra²sa² nũ̱³ka̱³txa² a²yxo²ha³kxa¹ on²tai¹nha²kxai³ Je³su²jah³lai²na² yu̱h³lxi³sxã³ a³li³xi²jau³su² kãin² ĩ³ye³kxi²nyhain¹ta¹hxai²hẽ¹la². Nxe³jut3su² ha²kxai³ ka³no¹a² ã³wi¹hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nxa²ha¹te¹ in³txai²na² ko̱³nxe³te²a² yãu³ka³txa² a³li³xain¹jah¹la² Je³su²jah³lo²su² te²kxai³ win¹ta²te²lxi³ ĩ³ye³kxi²ti³ãn¹jau³kxai³lu¹: — Ã³si³tẽ³kxi¹nxa²ha³la²wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nxe³nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²nyha¹ti³ãn¹jau³kxai³lu¹: — Ĩ³xi¹sẽ¹li¹. Wxa²nũ̱³ka̱³txai²na² sa²kxai³lu² ĩ³yau¹ũ¹txai¹nhẽ³li¹. Txa²wã¹sũ̱³na² we²txi²nxa²ju³ta² ĩ³yau¹ũ¹txai¹nhẽ³li¹. Ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² in³txai²na² sa²kxai³lu² sxi²hẽ¹nãu³a² ã³nxai³sxã³ ha³ta̱³nxe³ye²nyhain¹ta¹hxai²hẽ¹la². Je³su²jah³la² we²txi²ju³ta² ha³ta̱³nxe³ye²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nxa²ha¹te¹ Je³su²jah³la² yxo²ha³ti³lhi³xi²sxã³ wa̱³li²nũ²la² a²nũ²a² a²yxo²ha³kxa¹ ka³li³sxã³ wah³xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ain¹nxa²ha¹te¹ a²nũ²a² Jai²rah³lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹la² Ju³te²a² nũ̱³ka̱³txa² a²nũ²kxi²thĩ³na² hau³ko³ta¹hxai²hẽ¹la². A²nxe³jah¹lai²li² wxã³nũ²la² Je³su²jah³lai²na² a²ne³kxai³tãu³a² ã³ka³ti³wxe³ye²ta¹hxai²hẽ¹la². Nxe³nũ²la² win¹ta²te²lxi³ e³kxi²ti³ãn¹jau³kxai³lu¹: — Je³su²jah³lãi³. Txa²sxi²ha² wxã³sẽ¹li¹. Txa²ka³ne³lxa² ĩ³ton³sxã³ ya³lu²kxi²te³lhxã³ sa³na²li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","A²nxe³ta¹ka³lxa² kwẽ³kxa² hxi²ka² hxan³sxã³ ãh¹ ko³ha¹li¹ kwẽ³kon³sxã³ yxau³ta¹hxai²hẽ¹la². Te²a² so¹lxi³ a²wẽ³sa³lo³ta¹hxai²hẽ¹la². Jã¹nxe³kxan²ta² ĩ³ye³kxi²nyhah¹nũ²la² ã³si³tẽ³kxa² ai³ain¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a² a²nũ²a²nãu³xa² ka³lxa¹txi³ ã³nũ²kxi²sxã³ ã³ki³ka³tih³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nxa²ha¹te¹ txu¹ha² ã³si³tẽ³kxi²ta¹ka³lxu³su² te²na² kãin² ti³ho³na¹sxã³ ĩ³to³ta¹hxai²hẽ¹la². Kxã³nxai³tã² kwẽ³kxa² hxi²ka² hxan³sxã³ ãh¹ ko³ha¹li¹ kwẽ³ko³nhĩ¹nai³tã² txu¹ha² ĩ³ta³ka³txai²na² ã³si³wxe³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ta¹ a²nũ²a² hĩ³ne³kxa² wa³kẽn³yah³la² wã³nxĩn¹ti³ o²la³kxain¹kxan²ti³ hxi²kan¹txi³ we²txi²ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A²nxe²ta¹ka³lxa²kxai³la¹ a²yo³na² ya̱u³son³sxã³ Je³su²jah³la² wã²la²ka³lo³a² wxa²wxai³nũ¹ta¹hxai²hẽ¹la². Nxe² wxa²wxai³nũ¹thĩ¹na¹ wa³su³txi³ we²txi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nxe³nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Ĩh¹te²la³ta̱³ wxa²wxai³syah²lxin¹si²lxi¹. Nxa²ha¹te¹: — Txai²lan²nxa³li¹. A²yxo²ha³kxa¹ nxe²ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Pe²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. A²nũ²a² ka³lxa¹txi³ ã³to³to³la³kxi²nxain¹ten¹tu³wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nxa²ha¹te¹ Je³su²jah³la²kxai³ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Hxi²kan¹sxã³ we²txain¹te²sa¹wi¹. Jã¹nxa¹jau³su² ĩ²te²sa¹wi¹. Jã¹nxa¹li¹. Nxe³ha²kxai³ a²nũ²ain²txi³ wxa²wxai³nut1sain¹te²nũ³sẽ²li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nxa²ha¹te¹ tu¹hai²li² hxi²kan¹txi³ ĩ³hãi³ai¹nxa³kxe³su² Je³su²jah³la² o²ta¹hxai²hẽ¹la². Nxe³ha²kxai³ wxã³nũ²la² Je³su²jah³la² a²ne³kxai³tãu³a² ã³ka³ti³wxe³ta¹hxai²hẽ¹la². Ã³ka³ti³wxe³nũ²la² we²nxi²si¹ja³kxa³nũ³su² wxa²wxai³sa̱in³kxe³su² wa³su³txi³ we²txi²ju³ta² ĩ³yau¹ũ³ta¹hxai²hẽ¹la². Nxe³jau³su² a²nũ²a²nãu³xa² a²yxo²ha³kxa¹ ain³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nxa²ha¹te¹ Je³su²jah³la²kxai³ ĩ³wa²lũ³xi²te³nah¹lxi¹: — Nxe³thã²nxi¹. Yxo²ĩ²sa¹nha²kxai³ we²txi¹nxa²ha¹xĩ¹. Wa²su¹wa²su¹ ai³txu¹ni¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nxa²ha¹te¹ ĩ³ye³kxi²nyhain¹ti̱³kxai³lu² in³txai²na² Jai²rah³lai²na² a²sa³wi³sa² wxã³sxã³ ĩ³ye³kxi²ti³ãn¹jau³kxai³lu¹: — Jai²rah³lãi³. Ĩ³tih³nxe³nẽ³jah¹lãi³. Wxa²wẽ³sin³txi² ya³lu²kxi²nẽ³na²li¹. Ĩ³hxi²ka̱u³ka̱u³nha²sĩn¹txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nxa²ha¹te¹ Je³su²jah³lo²kxai³ jau³jau¹xai²na² ain³kxi²nũ²la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Yu̱h³lxah³lxi³txa³hẽ¹li¹. Hãi¹sxã³ yxo²ĩ²syah¹lxi³hẽ¹li¹. Ta¹ka³lxa² we²nxi²tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nxe³nxa²ha¹te¹ Jai²rah³la² sxi²ha² ya̱u³so³nain¹ka³tu̱³ ã³wi¹hain¹ta¹hxai²hẽ¹la². Je³su²jah³la² so¹lxi³ a²sa³wi³ha³lxa² so¹lxi³ nxe³te²su² Pe²jah³lo¹na² Jo³ãu²ah³lo¹na² Ti³a²kah³lo¹na² nxain¹ta¹hxai²hẽ¹la². A²nxe³te²a² so¹lxi³ wẽ³sa² a²wĩ³na² whãi²na¹ a²hã³ka³na² whãi²na¹ nxe³te²a² so¹lxi³ ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã̱³xa² nũ̱³ka̱³txa² ha³lo²a² yxau³sxã³ wah³nxe³si¹hain¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hã²wxãn³txa³nu² ã³wi¹hain¹tãu³a² a²nũ²a² ka³lxa¹txi³ yũ³ye²ta¹hxai²hẽ¹la². A²nxe³te²a² kãin² ĩ³nã̱n³ti² kãin² wxa¹ni³ ain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ Je³su²jah³la²kxai³ ĩ³ye³kxi²ti³ãn¹jau³kxai³lu¹: — Nã̱n³jah³lxi³ta̱³lxi¹. Ta¹ka³lxa² ya³lu²nxa³wi¹. Hãi¹sxã³ ãu³xi²na³li¹. Je³su²jah³lo²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nxa²ha¹te¹ wẽ³sai²na² ya³lu²sxa³ye²ain¹kxe³su² a³la³kxain¹nxa²ha¹te¹ yxo²ka³lxi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ain¹nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² a²wẽ³sa² hxi²ki³nũ²la² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³nxi¹. Ĩ³sa²yxau³nxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nxa²ha¹te¹ wẽ³sa² sa²kxai³lu² a²yãu³ka³txi³khai³xa² nxũ²kwa̱i³wih¹xi²sxã³ wa³su³txi³ ka³te̱n³su² ĩ³sa²yxau³xi²ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ Je³su²jah³la² wãn³txi³kxai³lu¹: — Yain³txa² ũ³hũ¹jah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nxe³ain¹jut3su² wẽ³sa² a²wĩ³na² whãi²na¹ a²hã³ka³na² whãi²na¹ ka³lih³khaix1te³nah¹lxi¹: — Ta¹ka³lxa² we²txi²na³li¹. Te²yã¹nxe³ju³ta² hai³txi³ ĩ²ki̱³sxa³wi¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² kãin²khaix1jah¹lo²sin²ta²wi¹. Ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — A²nũ²a² ã̱³lxi³te²a² wẽ³sa² we²txi²ju³tin³txi³ ĩ³ye³kxain¹yah³lxi³txa³hẽ¹li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ain¹nxa²ha¹te¹ a³lan²ton³tãu³a² Je³su²jah³la²kxai³lu² a²sa³wi³ha³lxa² hxi²ka² hxan³sxã³ ãh¹ ha¹li¹ wxa²sa²so¹xi²nũn³sxã³ nxe³tũ̱³ka̱³txa² ĩ³kaix1so¹ta¹hxai²hẽ¹la². Ĩ³kaix1so¹sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a² ĩ³ta³ka³txa² a²hãi¹nxe³ti³xa¹ we¹txa²lxai¹yah³lxin¹ju³ta² hĩ¹na² hxi²kan¹ti³hi¹ta²lxa¹ha²kxai³ a²nũ²a² ko̱³nxe³te²a² yãu³ka³txa² yũ³te²a² nxũ²kwa̱i³li³si¹jau³su² kwa³na³yah³lxin¹ju³ta² hxi²kan¹ti³hi¹txa²lxa¹ha²kxai³ nxe³nxa²lxa¹wi¹. Nxe³nxa²lxa¹kxe³su² a²hxi²kan¹jah¹lo²la²yãx1yah³lxin¹tu¹wi¹. Nxe³jau³su² Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nxe² e³ta³lun²nũ²la² sa²si¹haun³tain¹ta¹hxai²hẽ¹la². Sa²si¹haun³tain¹te³nah¹lxi¹: — Sxi²je³na² yxo²ha³kxa¹ ã³naun³ti¹jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹tãu³a² Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³su² nxe³jau³xa² ĩ³yau¹ũ³txain¹yah³lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ a²nũ²a² ĩ³ta³ka³txa² yũ³te²a² hãi¹nxe³ti³xa¹ we²txi²txai¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nxe³yah³lxin¹kxai²nãn²tu̱³ti² yen³kxa² tẽ³yah³lxi³txa³hẽ¹li¹. Nxe³sxã³ khauh²sa²ka³txa³la² tẽ³yah³lxa³nha²kxai³ wã²lẽn¹ta³ tẽ³yah³lxa³nha²kxai³ yain³txi³la³ tẽ³yah³lxa³nha²kxai³ ha³te̱h³nxã³nxa² ũ³yho³hxi²ki̱³txã³nxãn²ta³ tẽ³yah³lxa³nha²kxai³ wã²la²ka³lo³la³ ũ³whẽ̱³no³tã³wi²kxi²nyha¹lxin¹ka³lo³la³ tẽ³yah³lxa³nha²kxai³ nxe³jah³lxi³hẽ¹li¹. Yxãn¹ta¹ a²nũ²so¹lxi³ a̱un³txi¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yah³lxin¹kxai²nãn²tu̱³ sxi²ha² wi¹lã³wi¹yhah³lxin¹kxai²nãn²tu̱³ kan²txi³ yxau³jah¹lxi³hẽ¹li¹. Hen³txi³ta³lun²sãn²na³na¹ yah³lxin¹ka³tu̱³ a³li³xi¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yxãn¹ta¹ wi¹lã³wi¹yhah²lxan³kxai²nãn²tu̱³ti² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²ti³ten³ti³he¹xai¹nxa³kxai²nãn²tu̱³ sxi²je³nai²nãn²tu̱³ wa²li³jah³lxi³hẽ¹li¹. Wa²li³yah³lxin¹kxai²nãn²tu̱³ kxĩh³nũ̱³xa² wxa²yu̱³kxa² ti³son¹tũ̱³xa² ti³yu̱³tu̱n³ta³kxi²nha¹jah³lxi³hẽ¹li¹. Nxe³ain¹yah³lxin¹kxai²nãn²tu̱³ ko̱³nxe³ti³ kãi³ain¹ju³ta² ĩ³yau¹ũ³ain¹yah³lxi³hĩ̱³nxa¹lxi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nxa²ha¹te¹ ĩ³ye³ta³lun²nxa²ha¹te¹ a²sa³wi³ha³lxi³nũ̱³ka̱³txai²na² a³li³ain¹sxã³ ai³lha²thet3tain¹ta¹hxai²hẽ¹la². Nxe³tãu³a² Txa²wã¹sũ̱³na² wi¹jau³xa² ĩ³hen³txi³ha²kxai³ ĩ³ta³ka³txa² yũ³te²a² we²txa³lxai¹nha²kxai³ ain¹tah¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nxa²ha¹te¹ E³ro²jah³la² Ka³li³le²a²ko³xai²na² a²hxi²kan¹jah¹lo²su² ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ta¹ a²sa³wi³ha³lxai²na² sa²kxai³lu² wãn³txai²na² jau³jau¹xai²na² ain³kxain¹nxa²ha¹te¹ E³ro²jah³la² ne³nxe³na² ĩ³hen³txi³yah³lxi³ta¹hxai²hẽ¹la². Ĩ³hen³txi³yah³lxi³te³nah¹lxi¹: — Jo³ãu² Ba³tis²jah³la² ka³te̱n³su² ĩ³sa²yxau³xi²te²sin²tai¹. Jau³jau¹xai²na² ka³na³ku² te²na² ĩ³hen³txi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ã̱³jah¹lai²na² sa²kxai³lu²: — E³li²ah³la² ka³te̱n³su² ĩ³sa²yxau³xi²te²sin²tai¹. Jau³jau¹xai²na² ĩ³hen³txi³ha²kxai³: — Sũ̱³na² wãn³txa² ĩ³hen³txi³ nũ̱³ka̱³txai³tã² ka³na³ka³na³te²a² ka³te̱n³su² ĩ³sa²yxau³xi²te²sin²tai¹. Nxe³jau³xai²na² ka³lxa¹txi³ E³ro²jah³la² ĩ³hen³txi³ha²kxai³ nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nxe³ju³tan¹te²kxa³ya̱³lhu² E³ro²jah³la²kxai³lu² a̱in³nha²te³nah¹lxi¹: — Jo³ãu² Ba³tis²jah³lai¹tã² ũ³nhe̱³ki²lho¹si¹hai¹na¹jau³su² kwa³na³ai¹na¹hẽ³li¹. Yxãn¹ta¹ jah¹lai²li² ĩh¹jah¹lo²ta̱n³te²la¹ku². Nxa¹nhai¹. Ĩ²ti³ten³khaix1sa³nhai¹. E³ro³jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jã¹nxe³kxan²ta² nxe³nũ²la² a²sa³wi³ha³lxi³nũ̱³ka̱³txai³li² ã³wa̱³lain¹ta¹hxai²hẽ¹la². Ã³wa̱³lain¹nũ²la² ã³nũ¹nain¹nũ²la² ai³lha²thet3tain¹ju³tai³tã² nxe³kxe³su² ĩ³hen³txain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² Bet3sa³i²ta³thĩ³na² kãi²nxa³thĩ³na² a²sa³wi³ha³lxi³nãu³xa² nũ¹hĩ³ye³kxi²te³lhxã³ ã³sa²so¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nxe³tah¹lxa¹ a²nũ²a² ka³lxa¹te²a² ĩ²ain¹ti̱³kxai³lu² aun³txi² hit1tai³lain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³su² nxe³jau³xa² ka³lih³sxã³ ĩ³yau¹ũ³ha²kxai³ a²nũ²a² ĩ³ton³txi³nũ̱³ka̱³txa² wxã³kxai²nãn²tu̱³ we²txi³ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nxa²ha¹te¹ a¹sũ²ni²tãu³a² a²sa³wi³ha³lxi³nũ̱³ka̱³txa² ã³tĩ̱³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Ĩ²sa²sa²lxi¹. Hĩ¹na² sũ²nẽ³lhĩn¹na³li¹. Heh³sa²sĩn¹nhai¹. Txa²nũ̱³ka̱³txi³nãu³xai²li² heh³sa²sĩ¹nha²kxai³ wxã³ain¹tũ̱³ka̱³txa² he³hai¹nha²kxai³ nxe³ain¹sĩn¹na³li¹. Yxãn¹ta¹ ti¹ai²li² yain³txi³la³ yũ²nxa³ha²kxai³ sxa³ki̱³thĩn³ta³ yũ²nxa³ha²kxai³ nxe³sĩn¹na³li¹. Nxe³sĩ¹nha²kxai³ sxi²jen³nãu³a² yain³txa² sa²so² sxa³sxãu³xain¹thĩ³na² ãu¹la³kxi²nha² nxe³si¹hain¹jau³su² ĩ³sa²si¹hã³txai¹nhẽ³li¹. Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Wxãi²nãu³ ĩ³nxai²na¹ yain³txa² ũ³hũ¹txai¹yah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹: — Yxãn¹ta¹ yain³txa² yũ³ki̱³kxa² kãi²nxa³wi¹. Yain³tũ̱³xa² nũ̱³ha¹li¹ nũ̱³ha¹li¹ ka³na³ki¹ so¹lxi³ a̱i³na² ha¹li¹ so¹lxi³ nxe³te²na² so¹lxi³ yũ³nẽ³na³li¹. Nxe³nha¹ju³tan¹te²kxa³ya̱³lhu² yain³txa² so¹kxi²nha¹ju³ta² ĩ³sa²si¹hã³sa²sĩn¹te³lin¹ji¹, a²nũ²a² yxo²ha³kxa¹ ĩ³yain¹si¹sa²nhĩn¹jau³su¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A²nxe³tũ̱³ka̱³txai²na² ka³lxa¹khaix1ta¹hxai²hẽ¹la². In³txa² 5.000 nxe² ka³lxa¹khaix1ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — A²nũ²a² ã³nũ²kxi²sxã³ ã³wxe³si¹hain¹yah³lxin¹jau³su² ĩ³ye³kxi¹txai¹yah³lxi³hẽ¹li¹. Nxe³ain¹yah³lxin¹ju³kxai³la¹, a²nũ²a²nãu³xai²na² hxi²ka² hxan³sxã³ ye³ha¹li¹ ye³ha¹li¹ wxa²sa²wa²la³kxi¹xi²tũ̱³ka̱³txa² 50 nxe² a²nũ̱³ka̱³txi³su² ha³na³ka³lxi³ ã³wxe² jã¹nxe² jã¹nxe² nxe²xai³si¹hain¹yah³lxin¹jau³su² ĩ³ye³kxi¹txai¹yah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nxe³nũ²la² wãn³txai²na² sa²yxo²we¹thxa³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² yain³tũ̱³xai²li² a̱i³nai²li² nxe³sxã³ hxi²tẽ³nha²nũ²la² ten³sa²tã³ka³la³yxo²nũ²la² Sũ̱³na² ĩ³wi¹lxon³kxi²ki̱³jau³su² ĩ³ye³ta¹hxai²hẽ¹la². Nxe²e³ta³lun²ka³tu̱³ yain³tũ̱³xa² a̱i³na² nxe³sxã³ wã²nãu²lxi³sxã³ a²sa³wi³ha³lxa² ũ³hũ²xai³ka³tu̱³ a²nũ²a²nãu³xai²na² sa²nũ²xai³yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nxe³ha²kxai³ a²nũ²a² yxo²ha³kxa¹ yai³nai¹nha²kxai³ ũ³kxain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² hã²wxãn³txa³ yain³txa² wxa²nãu²lxi³kxe³su² wã³kon³kxe³su² wxa²nxa³ki²so¹ka³tu̱³ ha³ti²a² hxi²ka² hxan³sxã³ nxẽ³nha¹li¹ wxa²sa²so¹xi²nũn³tẽ³na² ĩ³ne³kxi²lhain¹ta¹hxai²hẽ¹la². Yain³txa² kãin² wã³kon³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ain¹nxa²ha¹te¹ ha³la³jen¹nãu³su² Je³su²jah³la²kxai³ a³li³nũ²la² Txa²wã¹sũ̱³na² nũh¹e³kxi²ta¹hxai²hẽ¹la². Nxe³te³na¹ a²sa³wi³ha³lxa² ã³wxã³sxã³ ĩ³wã̱³tain¹te³nah¹lxi¹: — A²nũ²a²nãu³xai²li² ĩh¹nxe³jau³ta̱³ ĩ³yĩ¹li²sain¹jau³su² e³lain¹te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nxa²ha¹te¹ ĩ³wa²lũ³xain¹ti³an¹jau³kxai³lu¹: — Nxe³nxa³wi¹. A²nũ²a²nãu³xai²na² a²ha³tih³xa² Jo³ãu² Ba³tis²jah³lo²su² ĩ³yĩ¹li¹nxai¹nha²kxai³ ã̱³xa² ha³tih³xai²na² sa²kxai³lu² E³li²ah³lu¹tai²na² ĩ³yĩ¹li¹nxai¹nha²kxai³ ã̱³xa² ha³tih³xai²na² sa²kxai³lu² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹txai²na² ka³te̱n³su² ĩ³sa²yxau³xi²ha²kxai³ wa̱³li² te²su² te²a² ĩ³yĩ¹li¹nxai¹nha²kxai³ nxe³nyhain¹sĩ¹nhxai²na²hẽ³li¹. A²sa³wi³ha³lxa² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Nxe³yãn¹ta¹ wxãi²nãn²ta³ ĩh¹nxe³jau³ta̱³ ĩ³yĩ¹li²syah¹lxin¹jau³su² e³yah³lxin¹ji¹wi¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Pe²jah³lai²na² wãn³txi³kxai³lu¹: — Wxãi²nãn²ta³ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²jah¹lo²si¹lxi¹. Txa²wã¹sũ̱³na² Ka³te̱n³ta² Si³yxau³jah¹lai²na² Tah²si¹lxi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ĩ³ye³kxi²te³nah¹lxi¹: — Jau¹xai²na² a²nũ²a² ĩ³hen³txain¹yah³lxi³txa³hẽ¹li¹. Hãi¹sxã³ kwa² ain³kxa² so¹kxi¹txai¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yxãn¹ta¹ kxãn³ton³tãu³a¹ Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² khãuh³lxa³txi³sa²ju³ta³nũ³a² yũ³tu¹wi¹. A²nũ²a² I³sa³e² hxi²kan¹txi³su² te²a² Sũ̱³na² sxi²ha² wã³nxĩn¹te² si³yxau³tũ̱³ka̱³txi³su² te²a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²a² nxe³sxã³ te²nãu³xa² ĩ³yen²ta³kxi²sai¹nha²kxai³ ĩ³su²lhã³si¹sain¹tu¹wi¹. Nxe³nũ²la² hã²wxãn³txa³ ye³ha¹li¹ ka³na³ki¹ a³lan²ka³tu̱³ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hã²wxãn³txa³ a²nũ²a² yxo²ha³kxa¹ ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²sah¹lxi³wxi¹. A²nũ²a² ĩ²li³te²nãn²tu̱³ ã³si³tẽ³kxi²ti³ten³sain¹kxai²nãn²tu̱³ a²ẽ¹nãu³a¹ a̱u³txi³ ten³khaix1nxe³ju³tãn²tu̱³ ã³na¹txai¹lxi¹. Te²yã¹nxe³sxã³ yxo²ĩ²sain¹ju³tan¹te²kxa³ya̱n³tu̱³ ĩ³ya²lut1ju³ta³nũ³a² yu̱h³lxin²nxa³sxã³ ã³si³tẽ³kxi²sain¹txai²li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te²yã¹nxe³ju³kxai³lu² a²nũ²a² te³nah¹lxi¹: “Yu̱h³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²ẽ¹na² wi¹la¹tãu³a² a³lxi²sah³nha¹. Je³su²jah³lai²na² wãn³txa² sa²yxo²ã³a¹kxan²ti³ ya³lu²ju³ta² ten³sa²nxa³nha¹.” Nxe³kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³ju³ta³nũ³a² yũ²nxa³lho³li¹. Yxãn¹ta¹: “Yu̱h³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²ẽ¹na² wi¹la¹tãu³la³ a³lxi²sa²nxa³nha¹. Je³su²jah³lai²na² wãn³txa² yxo²ĩ²a¹ju³tan¹te²kxa³ya̱³lhu² su²lhã³sain¹kxan²ti³ yxo²ĩ²a¹ju³ta² ã³na¹nxa³lho³na¹.” Nxe³kxai²nãn²tu̱³ Txa²sa³wi³ha³lxi³sain¹tu¹wi¹. Nxe³kxa²yu³su² Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³ju³ta³nũ³a² yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nxe³ha²kxai³ yuh³xan¹ko³xa² yxo²ha³kxa¹ a²wa³kxẽn³syah³lxin¹kxan²ti³ wxa²ẽ¹nãu³ai²na² wxa²ka³te̱n³su² yah³lxin¹ju³ta²kxai³ ã³tĩ¹kxi² kãin² khãuh³lxa³txi³nyhah¹lxi¹ni² nxe³kxai²nãn²tu̱³ wi¹lyah³lxi³hĩ̱³nxãn¹ji¹wi¹? Hai³txi³ wi¹ti³he¹xai¹nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nxe³ju³kxai³la¹ hĩ¹na² Txai²li² ĩ³yãu²lxi² Txa²wãn³txa² wi¹jau³xa² ĩ³yãu²lxi² nxe³sah¹lxin¹kxai²nãn²tu̱³ kxãn³nãu³a¹ wxã³na¹hĩ¹na² kãin² wxi²kin³ti³ton³na¹tu¹wi¹. Txa²wã¹sũ̱³nu²kxai³ a²wxi²kin³ti³ton³ju³tain²txi³ oh³xan¹tũ̱³ka̱³txai²na² a²wxi²kin³ti³ton³ju³tain²txi³ Txa²wxi²kin³ti³to³na¹ju³tain²txi³ nxe³nx2na³li¹. Jã¹nxe³hi¹na² ãu²li²to³txa²lxa¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jã¹nxa¹ju³kxai³lu² a²ya³la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³su² nxe³jau³xai²na² yxau³son³na³li¹. Wxa²nũ̱³ka̱³txe² ĩ³nxai²na² ka³na³ki²nũ² ya³lu²yah³lxi³xa³ta³lxa¹ ju¹tai²na² ĩ²yah³lxin¹tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ĩ³ye³ta³lun²nũ²la² hã²wxãn³txa³ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ a³la²ni²sxã³ Je³su²jah³la²kxai³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²xi²nyha¹te³lhxã³ a³li³nũ²la² wã³la³ka³txa² ka³la³ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ta¹ a²sa³wi³ha³lxai²na² Pe²jah³lo²su² ha²kxai³ Jo³ãu²ah³lo²su² ha²kxai³ Ti³a²kah³lo²su² ha²kxai³ nxe³sxã³ ã³sa²so¹sxã³ ai³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ã³sa²so¹sxã³ ai³nyhain¹ka³tu̱³ta¹ Txa²wã¹sũ̱³na² e³kxain¹tãu³a² a²yen³nãu³a² ye³ã̱³lxi³hi² a²wã²la²ka³lo³a² whãi²na¹ kãin² hãn³ni² nxe³ju³tan¹te²kxa³ya̱n³tu̱³ti¹ kãin² ye³ha²te¹ta³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A²nxe³ti̱³kxai³lu² in³txa² ha¹li¹ kwẽn¹ta²kxai³ a²ta³lye²nyhain¹ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³ye³kxin²txi³nyhain¹ta¹hxai²hẽ¹la². Nxe³te²a² Moi³se²ah³lo²su² ha²kxai³ E³li²ah³lo²su² ha²kxai³ nxe² ĩ³yĩ¹li²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jã¹nxe³te²na² sa²kxai³lu² Txa²wã¹sũ̱³na² ha³te̱t1ju³ta² ĩ³kĩ³kxain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ta¹ ĩ³ye³kxi²nyhain¹ka³tu̱³ta¹ Je³su²jah³la²kxai³lu² Je³ru³sa³lẽ²thĩ³na² ã³wih¹tãu³a¹ a̱n³txi³tũ̱³ka̱³txa² hi³ka² su²lhã³si¹hain¹ju³ta³nũ³su² ĩ³ye³kxi²nyhain¹ta¹hxai²hẽ¹la². Nxe³jau³xai²na² kxã³nhxĩ¹nai³tã² Txa²wã¹sũ̱³na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A²nxe³yãn³txai²na¹ Pe²jah³la² sa²kxai³lu² a²ya̱³lxi³nũ̱³ka̱³txai²na² sa²kxai³lu² nxe³sxã³ hxi²tha³ai¹nha²kxai³ kãin² ãu³xain¹ta¹hxai²hẽ¹la². Ain¹nũ²la² ĩ³tu¹lxi²nũ²la² Je³su²jah³lai²na² in³txai²na² ĩ³ye³kxi²nyhain¹ju³ta² ĩ²i² sa²ha²tet1ju³ta² ĩ²i² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nxa²ha¹te¹ in³txai²li² a³li³te³lhxã³ nx2na³na¹ ai¹nhĩ¹na¹ Pe²jah³lai²na² sa²kxai³lu² ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³la² txa²hxi²kan¹jah¹lãi³. Ti¹ai²li² ha³lo²a² wi¹khaix1sĩ¹na¹nhai¹. Nxe³sĩ¹nha²kxai³ sxi²ha² nẽn³nha¹li¹ ka³na³ki² txo³na¹tu¹wi¹. Wxa²sxi²ha² txo³ni² Moi³se²ah³la² sxi²ha² txo³ni² E³li²ah³la² sxi²ha² txo³ni² nxe³nxa²lxa¹tu¹wi¹. Nxe³jau³su² Pe²jah³lai²na² a²yxo²e³jau³su² kxan²ti³ a²si³yxau³tãu³khai³xa² ã³ne³to³ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nxa²ha¹te¹ e³kxi²tãu³a² o³sĩ̱³na² ã³tĩ̱¹kxain¹nũ²la² a²sa³wi³ha³lxi³nãu³xa² on²txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nxe³ain¹tãu³a² o³sĩ̱³nãn¹jau³xa² ain³kxain¹te³nah¹lxi¹: — Jah¹lai²li² Txa²ki³lha³lxai²la¹wi¹. Ĩ²sxã³ sa²so¹ai¹na¹hẽ³li¹. Ain³kxi¹txai¹yah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nxa²ha¹te¹ ĩ³ye³ta³lun²nũ²la² Je³su²jah³la² so¹lxi³ ĩ²kxain¹ta¹hxai²hẽ¹la². Hã²wxãn³txa³ a³la²ni²xi²tãu³a² a²ka³nxain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ ju¹tai²na² a²nũ²a² ã̱³lxi²nũn³tũ̱³ka̱³txa² ĩ³ye³kxi²nyhain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nxa²ha¹te¹ a²ka³nxi²nũ²la² a²nũ²a² ka³lxa¹nũ̱³ka̱³txa² ne³khauh²xi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nxa²ha¹te¹ a²nũ²a²nãu³xai²na² in³txa² ka³na³ka³nat3sxã³ ĩ³kaix1te³nah¹lxi¹: — Tih³nxe³sa²jah¹lãi³. Txa²wẽ³sa² sa²hau³ko³kxi²sa²sã²nhẽ³li¹. Nũ¹ta² we³ta¹jah¹lai²la¹wi¹. Nxe³sxã³ a³lxi²khaix1sa³nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nxe³te²na² ko̱³nxe³te²a² yãu³ka³txa² a̱n³txi³ ã³wih¹nũ²la² kãin² wxan¹si¹hi² nũ³kxũn³txã³nhe¹kxi²hi² nxe³to³hxai²na²hẽ³li¹. Jã¹nxe³na²li¹. Nxe³hĩ¹na² kãin² yxo²ka³sih¹xi²ha²kxai³ wa³su³txi³ a³li³ti³he¹xai¹nxa³hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nxa²ha¹te¹ a³li³si¹hain¹jau³su² wxa²sa³wi³ha³lxa² win¹ta²te²lxi³ ĩ³ye³kxai¹na¹li¹. Yxãn¹ta¹ hxi²ka¹nai¹nxãn³su²li¹. Nxai¹nxa³ha²kxai³ sa²hau³ko³kxi²sa²sã²nhẽ³li¹. Nxe³ye¹nxa²ha¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ã³ne³tot3syah¹lxa³lxi¹. Yxo²ĩ²nxa³sxã³ wain³txa̱in³kxah²lxa³lxi¹, kan²txi³ yxau³kxi¹nx2ta¹kxan²ti³nu¹. Wẽ³sai²li² tẽ³sxã³ wxã³jah¹lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nxa²ha¹te¹ so¹sxã³ wxã³tãu³a² ko̱³nxe³te²a² yãu³ka³txa² kãin² ã³nhe¹kxi²sxã³ wẽn³sa² sa²tã³kxi²ta¹hxai²hẽ¹la². Nxe³ain¹nxa²ha¹te¹ Je³su²jah³la² hi²sen³kxai³lu² ko̱³nxe³te²a² yãu³ka³txa² ĩ³kwa̱i²kxi¹nxa²ha¹te¹ wẽ³sai²li² we²txi²ta¹hxai²hẽ¹la². We²txi²nũ²la² a²wĩ³na² ũ³hũ¹xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nxe³jut3su² a²nũ²a²nãu³xa²kxai³lu² Txa²wã¹sũ̱³na² nũ̱³kxũn³sxã³ o²la³kxain¹ju³ta² ĩ²ain¹ta¹hxai²hẽ¹la². Nxain¹ju³tan¹te²kxa³ya̱³lhu² on²tain¹ta¹hxai²hẽ¹la². Ain¹nxa²ha¹te¹ nxe³ain¹ti̱³kxai³lu² Je³su²jah³la² ã³yxo²o³tũ¹nũ²la² a²sa³wi³ha³lxa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ĩ³ye³kxi²te³nah¹lxi¹: — Ain³kxi²khai¹nxe³sah¹lxi³hẽ¹li¹. A²nũ²a²nãu³xai²na² ko¹ko¹xa²nãu³xai²na² hxi²ka² ã³yũ³so¹sain¹tu¹wi¹. Nxe³jau³xai²na² ne³wã²yah³lxi³txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nxe³to³ta¹ nxe³jau³jau¹xai²na² a²si³yxau³tãu³khai³xa² tĩ̱²kxi²ha²kxai³ hxi²kan¹txi³ a³la³kxain¹ta¹hxai²nxa³hẽ¹la². Ain¹kxan²ti³ yu̱h³lxain¹jau³su² jau³jau¹xai²na² ĩ³wã̱³txain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nxe³nũ²la² hã²wxãn³txa³ ĩ³ye³nyhain¹ta¹hxai²hẽ¹la². Ĩ³ye³nyhain¹te³nah¹lxi¹: — Txa²wã¹ki̱³nãu¹xai²na² ĩh¹jah¹lo²ta̱³ kãin²txi³yxau³jah¹lo²su²hĩ̱³te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² a²sa³wi³ha³lxai²na² ẽ¹nãn¹jau³xai²li² a³la³kxi¹nxa²ha¹te¹ wẽn³su² tẽ³sxã³ ã³ka³lu³sa³wxe³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nxe³nũ²la² a²sa³wi³ha³lxa²kxai³ ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²ka²sah¹lxi³wxi¹. A²nũ²a² ĩ²li³te² ĩ³nxa² a³lxi³sa¹nha²kxai³ wẽ³sai²na² sa²hau³ko³tai¹nĩn¹kxai²nãn²tu̱³ Txai²na² hxi²nũ¹san¹kxa² yã¹nxe³hĩ̱³nx2na³li¹. Hxi²nũ¹san¹kxai²nãn²tu̱³ Sũ̱³na² ĩ³sa²si¹hã³sa²jah¹lo²su² te²a² hxi²nũ¹nain¹kxa² yã¹nxe³hĩ̱³nx2na³li¹. Te²yã¹nxe³sxã³ wxa²ẽ¹nãn¹jau³xan²tu̱³ e³kxi²nhã¹jau³xan²tu̱³: “Txa²nũ̱³ka̱³txa² ĩ³kãin²txi³nha²sxã³ wa³to²hi²sain¹kxan²ti³ wi¹na³na¹.” Nxe²e³kxah¹lxin¹te² ĩ³nxãn²tu̱³ kãin²txi³ yxau³jah¹lo²su² hĩ̱³nxa¹lxi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nxa²ha¹te¹ Jo³ãu²ah³la²kxai³lu² ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²si³yxau³jah¹lo²si¹lxi¹. A³lan²tai³tã² in³txa² ĩ²sĩ¹na¹hẽ³li¹. Nxe³jah¹la² wxi²ka¹nĩn¹ju³ta² ĩ³so¹nxain¹sxã³ ko̱³nxe³te²a² yãu³ka³txa² a³li³si¹jau³su² ĩ³kwa³na³ai¹nhẽ³li¹. Yxãn¹ta¹ ĩ³hi²txi²nxai¹nxa³ha²kxai³: “Hãi¹nxã¹txai¹nhẽ³li¹.” Nxe³si¹hain¹nha¹jau³su² kwa³na³ain¹sĩ¹na¹hẽ³li¹, wxa²sa³wi³ha³lxi³sxa³ha²kxai³lu¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ĩ³hxi²ko²lain¹yah³lxi³txa³hẽ¹li¹. A²nũ²ai²li² wxa²ko̱¹ko̱¹sai¹nxa³kxai²nãn²tu̱³ wxa²ya̱³lhxain¹na³li¹. Nxe³ha²kxai³ ĩ³hxi²ko²lain¹yah³lxi³txa³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kxãn³ta³lon³tãu³a² Txa²wã¹sũ̱³na² ha³lo²a² ĩ³ka³la³si¹ja³kxa³nũ³su² ya̱u³so³nhĩ¹na² Je³ru³sa³lẽ²thĩ³na² ã³nxai³ti³wa̱³kxa² ya̱u³son³nha²kxai³ nũ¹kan¹sxã³ ai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nxe³ha²kxai³ Sa³ma²ri²a²thĩ³na² a²sxi²ha² ãu³xi²thĩ³nũ³a² sa²hau³kot3si¹jau³su² sa²si¹hã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sa²si¹hã³nxa²ha¹te¹ ai³nũ²la² ã³wi¹hain¹nũ²la² thĩ¹na² sa²hau³ko³ki̱³te²sa¹ji¹xã¹. Ain¹tah¹lxa¹ yxau²xai³tũ̱³ka̱³txa² yxa̱ih¹ha²kxai³ ũ̱n³txi³ e³kxain¹te³nah¹lxi¹: — Ã³nxai³jah¹hẽ¹li¹. Je³su²jah³lai²na² wxãi²li² nxe³yah³lxi³ ĩ³nxai²na² Je³ru³sa³lẽ²thĩ³nãn¹tĩh³na² ai³yah³lxi¹nha²kxai³ ten³nxa²lxi³nxa³nhai¹. Ain¹ya³ha²kxai³ aun³ta² wa̱³la² ĩ³xi²ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ain¹nxa²ha¹te¹ Jo³ãu²ah³la²kxai³ Ti³a²kah³la²kxai³ nxe³sxã³ ĩ²ain¹tãu³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. E³li²ah³lu¹tai²na² yã¹nxe³sxã³ oh³xa² ha³nxe²a² sa²si¹hã³sĩ¹na¹kxai²nãn²tu̱³ Sa³ma³ri³tã²na² nũ̱³ka̱³txa² ũ³thũ²kxain¹nha¹ju³ta² ten³nxa²sĩn¹ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ã³yxo²ko³tũ¹te³nah¹lxi¹: — Nxex3jah³wxi¹. Ten³sa²nxa³nhai¹. Txa²wã³nxĩ¹na¹ju³ta² wi¹ko̱³nh³yah³hxa³lxi¹. Ya³hxa³nha²kxai³ Txai²na² sa²kxai³lu² a²nũ²a² su²lhã³te³lhxã³ wxã²nxa³ha²kxai³ yxãn¹ta¹ we²txi²si¹ja³kxa³nũ³a² so¹lxi³ wxã³na¹ha²kxai³ nxa¹hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nxe³ain¹jut3su² ã³nxai³sxã³ sĩ³nã̱³xa² sxa³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ã³nxai³ain¹tãu³a² in³txa² wxã³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Ha³lo²a² ĩ²li³je³na² ã³nxai³lin¹tãu³a² ã³si³tẽ³kxi¹nxa²ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Wai³a³lxa²si³ta³lã²tẽ¹nai²na² a²sxi²lho³tẽ³na² yũ³te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ a̱i³kai²na² a²ye³sa² wet1sxã³ a²sxi²lho³ju³ta² yũ³te²ju²hẽ³li¹. Nxe³ain¹ta¹ a²nũ²a² oh³xa² wxã³jah¹lo²na¹xai²na² hai³txi³ ha³lo²a² kwa² sxa³na¹ju³ta³nũ³a² yũ²nxa³wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nxa²ha¹te¹ a²nũ²a² ã̱³sa²nũn³te²a² ĩ³ye³kxi²te³nah¹lxi¹: — Ã³si³tẽ³kxi¹sẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Txa²wĩ³na² ka³te̱n³su² hin¹tãu³a² yxau³kxi²nũ³na¹tu¹wi¹. Hã²wxãn³txa³ ya³lu²kxi²sãn²nũ²la² sa²nĩ̱³kxi²sã²na¹ka³tu̱³ ã³si³tẽ³kxi¹nxa²ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Nxet3sã²lxi¹. A²nũ²a² ĩ²li³te²su² te²a² Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²we¹txa³kxai²nãn²tu̱³ a²nũ²a² ya³lu²te²a² yã¹nxe²na³li¹. Nxe³te²na² sa²kxai³lu² wxa²ka³lxa¹te²su² te²a² ya³lu²kxai²nãn²tu̱³ sa²nĩ̱¹kxi²txai²li¹. Nxĩ¹nha²kxai³ wxãi²na² sa²kxai³lu² hãi¹nxe³sxã³ ã³si³tẽ³kxi¹sẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nxa²ha¹te¹ a²nũ²a² ã̱³sa²nũn³te²a² ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Ã³si³tẽ³kxi²ti³ten³khaix1sa³nhai¹. Yxãn¹ta¹ ĩ³xi²sã²na¹ka³tu̱³ txa²ka³lxa¹ti³nãu³xa² ĩ³yxo²sai¹la³kxi²sã²na¹tu¹wi¹. Hã²wxãn³txa³ ã³si³tẽ³kxi¹nxa²ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — A²nũ²ai²nãn²tu̱³ a²wa³ka³li³yu³khai³xa² ã³si³wxe³kxai²nãn²tu̱³ hã²wxãn³txa³ ã³na¹sxã³ ã³waix3kxai²nãn²tu̱³ nxe³te²a² he³la³ko³la³ hai³ya̱³khin¹te²ju²hẽ³li¹. Te²yã¹nxe³kxe³hũ̱³nxe² ĩ³hit1sah²lxin¹kxai²nãn²tu̱³ nxe³yah³lxin¹ta¹ ã³na¹sxã³ ã³waix3sah²lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³su² nxe³jau³xai²na² hxi²kan¹txi³ a³la³kxah²lxan³tho³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","3","Nxa²ha¹te¹ hã²wxãn³txa³ Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹la²kxai³lu² a²nũ²a² ã̱³lxi³nũn³tũ̱³ka̱³txa² 70 nxe² ĩ³kaix1so¹ain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² ĩ³ye³kxi²te³nah¹lxi¹: — Ye³jen¹na² sxi²yhen³na² ka³lxa¹txi³ ã³nxai³lha²the³ta¹tu¹wi¹. Nxe³na¹ju³ta³nũ³su² ha²kxai³ ĩ³sa²ne³ka³ta¹hã³nha²sxã³ ũ³sa²si¹hã³nx2ta¹tu¹wi¹. Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³hen³txi³si¹ja³kxa³nũ³su² ũ³sa²si¹hã³nx2ta¹tu¹wi¹. Nxe³nx2ta¹ha²kxai³la¹ nũ¹a² ha¹li¹ sa²si¹hã³i² nũ¹a² ha¹li¹ sa²si¹hã³i² nũ¹a² ha¹li¹ sa²si¹hã³i² nũ¹a² ha¹li¹ sa²si¹hã³i² nxe³nx2ta¹tu¹wi¹. Nxe³nx2ta¹ka³tu̱³ta¹ o³ve²a² wẽn³sa² yã¹yxah³lxi¹lxi¹. Nxe³te²na² sa²kxai³lu² ha³lo²a² he¹lain¹tãu³a² hau³xa² ka³lxa¹txi³ ho³hai¹nha²kxai³ ĩ³so¹jĩ²te³lhxã³ ai¹nhĩ̱³nx2na³li¹. Nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² ha³lo²a² ha³nxeh³lxi³ju³ta² ĩ³ha¹txi¹nx2ti³to³ha³ta²wi¹. Te²yã¹nxe³ju³ta² hai³sxa² yain³txa² sxa³ko³xa² wa²ni²lho¹kxi³tũ̱³ka̱³txa² yã¹xah³lxi¹lxi¹. A²nxe³ko³xai²na² wi¹we¹nha²kxai³ hxi²kan¹txi³ wa²ni²lho²hxa³tai¹nxa³lho³li¹. Nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² sxi²jen³nãu³xa² ka³lxan¹ti³ha²kxai³ hxi²kan¹ti³ ai³lha²thet3thxa³jah²lxan³tho³li¹. Yah²lxa³nha²kxai³ a²wa³kxẽn³ta² Si³yxau³jah¹la² wi¹lĩ³ye³kxi²txain¹yah³lxi³hẽ¹li¹. Nxe³yah³lxin¹te³nah¹lxi¹: “A²nũ²a² ã̱³xa² hxi²nũn¹ta³kxi²si¹sain¹sĩn¹ja³kxa³nũ³su² ã³nũ²kxi²sxã³ ĩ³so¹ta²sĩ¹nhẽ³li¹.” Win¹ta²te²lxi³ nxe² ĩ³ye³kxi¹txain¹yah³lxi³hẽ¹li¹. Nxe³yah³lxin¹te³na¹ ain³ta³kxi¹jxah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yxah³lxin¹kxai²nãn²tu̱³ wã²lẽn¹ta³ tẽ³yah³lxa³nha²kxai³ ha³te̱h³nxãn³nxẽn¹ta³ tẽ³yah³lxa³nha²kxai³ yu³wi²kxi²nha²ka³lo³la³ wẽ̱³no³kxa² tẽ³yah³lxa³nha²kxai³ nxe³jah³lxi³hẽ¹li¹. Tĩh³na² ai³yah³lxin¹tãu³a² a²nũ²a² ne³khauh²hah³lxin¹kxãi²nãn²tu̱³ ĩ³ye³kxah¹lxi³txa³hẽ¹li¹. Hãi¹sxã³ ã³yit1txa³sxã³ ã³wa²to¹jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yah³lxin¹kxai²nãn²tu̱³ sxi²ha² ã³wih¹yah³lxin¹ti³wa³kxa¹ ĩ³ye³kxah¹lxi³sã²nĩn¹te³nah¹lxi¹: “Sũ̱³na² hãun²ju³ta² ã³wxe³nũh¹nxa²lxi³ju³ta² ten³sa³nhai¹.” ");
INSERT INTO nabNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yah³lxin¹ka³tu̱³ sxi²ha² wa³kxẽn³yah³la² wi¹lhin¹ye¹nx2ti³kxai²nãn²tu̱³ Sũ̱³na² hãun²ju³ta² wi¹lã³wxe³nũ¹hain¹tu¹wi¹. Yxãn¹ta¹ sxi²ha² wa³kxẽn³yah³la² wi¹lhi¹nxa³kxai²nãn²tu̱³ Sũ̱³na² hãun²ju³ta² ĩ³sa²si¹wha²nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wi¹lhin¹sxã³ ã³wih¹yah³lxin¹kxai²nãn²tu̱³ hãi¹sxã³ yxau³jah¹lxi³hẽ¹li¹. Sĩn³ka³lxa¹ti³ yxau²sa²thet3jah³lxi³txa³hẽ¹li¹. Kwa²yain³txa² yũ³ain¹kxa² yai³ni² ĩ³na² nxe³jah³lxi³hẽ¹li¹. Wa³kon³kxi²sah¹lxi¹nha²kxai³ yain³txa² kwa² ũ³hũ¹nx2tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jã¹nxe³sxã³ sxi²yhe³na² ã³wih¹yah³lxin¹tãu³a² wi¹lĩ³hen³txi¹nx2tain¹kxai²nãn²tu̱³ kwa²yain³txi³su² yain³jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ĩ³ta³ka³txa² yũ³te²su² te²a² ĩ²ain¹yah³lxin¹kxai²nãn²tu̱³ we²txain¹yah³lxi³hẽ¹li¹. Nxe³ain¹yah³lxin¹ka³tu̱³ ĩ³ye³kxain¹yah³lxin¹te³nah¹lxi¹: “Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³su² nxe³jau³xa² ye³jen¹na² yũ³nũh¹nx2ti³tu¹wi¹.” Nxe³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yxãn¹ta¹ sxi²je³nai²nãn¹ta² wãn³txi³kxai³lu¹: “Wxãi²na² ten³nxa²lxi³sĩ¹nxa³nhai¹.” Nxe³nx2tain¹kxai²nãn²tu̱³ wa²li³jah³lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ ĩ³ye³kxi²txai¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ain¹yah³lxin¹te³nah¹lxi¹: “Kxĩh³nũ̱³xa² sxi²je³nãn¹ta² kxĩh³nũ̱³xa² txa²yu³ti³son¹tũ̱³xa² ti³yu³hen²ta³kxi²ye²sĩ¹nx2ta¹wi¹. Nxe³ye²sĩ¹nx2ta¹kxe³su² ko̱³nxe³ti³ kãi³syah¹lxin¹ju³ta² yũ³khaix1je¹nx2ti³na³li¹. Nxe³yãn¹ta¹ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³su² nxe³jau³xa² ya̱u³son³na³li¹. Nxe³jau³su² wi¹ko̱³nha¹jah³lxi³hẽ¹li¹.” Nxe³yah³lxin¹jau³nũ³a² ĩ³ye³kxi¹txai¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jã¹nxe³ju³kxai³lu² kxãn³ton³tãu³a² Txa²wã¹sũ̱³nu²kxai³lu² a²nũ²a² yxo²ha³kxa¹ a²wa³kxẽn³su²tu¹wi¹. Nxe³tãu³a¹ Txa²wã¹sũ̱³na² hi²sen³kxai³lu² So³to²ma²thĩ³nu¹tai²nãn¹tũ̱³ka̱³txa² kãin² ye³khãuh³lxa³ti³hi¹tain¹tu¹wi¹. Yxãn¹ta¹ nyhain¹je³na² wi¹lhin¹sxã³ ã³wih¹yah²lxan³je³nai²nãn¹tũ̱³ka̱³txa² ye³khãuh³lxa³ti³hi¹tain¹ju³ta³nũ³a² wa³to²ha² he¹tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nxa²ha¹te¹ Ko²ra³sĩ²thĩ³na² Bet3sa³i²ta³thĩ³na² nxe³tũ̱³ka̱³txi³ ĩ³nxai²na² ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. Kxã³nhxĩ¹nai³tãn¹thĩ³na² Ti²ro³thĩ³nãn¹tũ̱³ka̱³txai³tã² Si³tõ²thĩ³nãn¹tũ̱³ka̱³txai³tã² nxe³sxã³ ko̱³nxe³thin¹khai¹nxai¹nha²kxai³ ya³lu²hxa³nain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ wã³nxĩn¹sxã³ kãi³ũh¹nx2ta¹ju³ta² ĩ²ain¹ke³la³te²kxai³ a²ko̱³nxe³ti³ kãi³ain¹ju³tu¹tai²na² ã³na¹sxã³ ã³yxo²o³tũ¹sai¹nhĩ̱³nx2na³li¹. Wã²la² sa²kẽ³nã²ka³lo³a² ũ³whi²kxi²nha²sxã³ ha³nxe²a² wã²nhxan³tũ̱³xa² ã³wxe³sãn²sxã³ ã³yxo²o³tũ¹sai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nxe³kxa²ha³ta̱³nxãn²ti³ yan¹nãu³a¹ txa²wã¹o²la³kxi²ki̱³kxa² yo³ha² Sũ̱³na² ũ³yho³hi²nẽ³tãu³a¹ Ti²ro³thĩ³nãn¹tũ̱³ka̱³txai³tã² Si³tõ²thĩ³nãn¹tũ̱³ka̱³txai³tã² nxe³sxã³ ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² kãi²nxa³lho³li¹. Yxãn¹ta¹ ko̱³nxe³ti³ kãi³yah³lxin¹kxa² yo³ha² ã²la² kãi²non³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nxa²ha¹te¹ Ka³far³na³ũ²thĩ³nãn¹tũ̱³ka̱³txe² ĩ³nxai²na² sa²kxai³lu¹: “Oh³nãn¹ko³nãu³a² Sũ̱³na² ha³lo²a²nãu³a² ka³la³sxã³ ã³wi¹ha¹tũ¹xã¹.” Nxĩn¹jau³su² yxãn¹ta¹ yu̱h³xan¹ko³nãu³a² ha³nxe² i̱³ko³nãu³a² sa²yu̱³lho̱t1tin¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nxa²ha¹te¹ 70 nxe³tũ̱³ka̱³txa² ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Ai³lah³lxin¹tãu³a² wxa²wãn³txa² ain³kxi¹nx2tain¹kxai²nãn²tu̱³ Txa²wãn³txa² ain³kxi²sain¹nũn³na³li¹. Yxãn¹ta¹ wxa²wãn³txa² sa²yxo²ã³nx2tain¹kxai²nãn²tu̱³ Txa²wãn³txa² sa²yxo²ã³sain¹nũn³na³li¹. Te²yã¹nxe³sxã³ Txa²wãn³txa² sa²yxo²ã³sain¹kxai²nãn²tu³ sa²si¹hã³sain¹jah¹la² sa²yxo²ã³ain¹nũn³na³li¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nxa²ha¹te¹ kxãn³nãu³a² aun³txa² wa̱³lxain¹tãu³a² kãin²ka³lih³lhe¹kxain¹te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Ko̱³nxe³te²a² yãu³ka³txa² a³li³ain¹si¹nha¹jau³su² kwa³na³ain¹sĩ¹na¹hẽ³li¹. Sa²hi²kat1sah²nhĩ¹nha²kxai³ yxo²ha³kxa¹ sa²yxo²wet1sain¹sĩ¹na²hẽ³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ha³lai³xa² wa³su³txi³ ĩ³wa³tu³ki̱³kxa² yã¹nxe³sxã³ Sa³ta³na²jah¹la² sa²hi²kat1txa³kxe³su² oh³nãu³a² wa³su³txi³ a³hi²sxã³ wa²ka³nxe² wxã²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nxe³yãn¹ta¹ ne³ka²a³sah¹lxi³sã²lxi¹. Wã³nxĩn¹na¹ju³ta² ũ³hũ¹nx2ta¹tai¹ti²tu³wi¹. Nxe³nx2ta¹ha²kxai³ txih³xa² ĩ³nxa²lxi³kxan²ti³ sxe³sxe³kxa² ũh³nxa²lxi³kxan²ti³ ũh³hĩ¹to³txa²lxi³xa³lho³li¹. Te²yã¹nxe³sxã³ Sa³ta³na²jah¹la² nũ³kxũn³kxan²ti³ hxi²kan¹txi³ wa³ka³to³txa²lxi³xa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nxe³ju³tai²li² wi¹na³li¹. Yxãn¹ta¹ wxa²ĩ³lxai²li² oh³nãu³a² nũ¹ka³na¹ Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxa² ũ³wha²li¹la³kxi²sa²tẽ³ju³ta² ã²la² wi¹lhĩ̱³nx2na³li¹. Nxe³jut3su² ka³lih³jah¹lxi³hẽ¹li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nxa²ha¹te¹ Je³su²jah³lo²kxai³la¹ Sũ̱³na² Yãu³ka³txa² ka³lih³si¹ha²kxai³ ĩ³ye³kxi²ta¹hxai²hẽ¹la². Txa²wã¹sũ̱³na² ne³nxe³na² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wĩ³nãi³. Oh³xan¹thĩ³na² whãi²na¹ yuh³xan¹thĩ³na² whãi²na¹ A²hxi²kan¹ta² Si³yxau³jah¹lo²si¹lxi¹. Nxĩn¹sxã³ ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²nãu³xa² a³la³kxi²khai¹nxe³te²nãu³xa² nxe³sxã³ wa³ka³la² kãi³in¹ju³tai²na¹ wãn³txa² ĩ³tih³nxĩn¹jau³xai²na¹ ĩ³yau¹ũ³hain¹nxã³nhẽ³li¹. Yxãn¹ta¹ a²hoh³lxi³sxa³te²nãu³xa¹ wxa²wãn³txai²na² ĩ³yau¹ũ³hai¹nĩ¹nhẽ³li¹. Nxai¹nĩ¹nha²kxai³ sa²nẽn¹kxi¹nxa²ha¹wi¹. Wã²nxũ̱h¹lxi³sxã³ nxe²kãi³ĩ¹nhẽ³li¹. Nxe³jau³su² Je³su²jah³lo²kxai³lu² Sũ̱³na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nxe³ha²kxai³lu¹ Je³su²jah³la² ãh¹ ĩ³ye³te³nah¹lxi¹: — Yen³kxa² a²yxo²ha³kxa¹ Txa²wĩ³na² ũ³hũ¹sa³na²hẽ³li¹. Txa²wĩ³na² so¹lxi³ a²ki³lha³lxa²na¹xai²na² ĩ²sa²jah¹lai²la¹wi¹. Te²yã¹nxe³sxã³ Txa²wĩ³na² ĩ²te²la³ yũ²nxa³wi¹. Txai²na² a²ki³lha³lxa²na¹xai²na² so¹lxi³ ĩ²jah¹lo²sa¹wi¹. Te²yã¹nxũn³sxã³: “A²nũ²a² ã̱³xai²na² Txa²wĩ³na² ĩ³yau¹ũ³hai¹na¹tũ¹xã¹.” Nxa¹kxai²nãn²tu̱³ nxe³jah¹lai²na² sa²kxai³lu² Wĩ³na² ĩ²jah¹lo²su² nũ³nhĩ̱³nx2na³li¹. Je³su²jah³lo²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nxa²ha¹te¹ hã²wxãn³txa³ a²sa³wi³ha³lxa² hxi²ka² hxan³sxã³ ãh¹ ha¹li¹ wxa²sa²so¹xi²nũn³sxã³ nxe³tũ̱³ka̱³txa² nũ¹hĩ³ye³kxi²te³nah¹lxi¹: — Nxex3jah³lxi³sa²lxi¹. Ju¹tai²li² ĩ²ah³lxi¹nha²kxai³ wi¹lhin¹yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Te²yã¹nxe³ju³kxai³lu² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³ tũ̱³ka̱³txu¹tai²na² a²yxo²ha³kxa¹ I³sa³e² nũ̱³ka̱³txa² a²wa³kxẽn³nai³tã² a²yxo²ha³kxa¹ ju¹ta² ĩ²ti³te³nain¹ta¹hxai²hẽ¹li¹. Te²yã¹nxe³sxã³ wãn³txa² ain³kxah²lxin¹jau³xa² ain³kxi²ti³te³nain¹ta¹hxai²hẽ¹li¹. Nxe³ain¹te²ji¹xã¹. Ain¹tah¹lxa¹ nxe³ain¹ta¹hxai²nxa³hẽ¹li¹. Nxe³ha²kxai³ ĩ²yah³lxi¹nha²kxai³ wi¹lhin¹yah³lxi¹lxi¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nxa²ha¹te¹ ha³te̱h³nxã³nxa² a²hoh³lxi³su² jah¹la² ã³tĩ̱³nũ²la² ĩ³ye³ta³lxai¹kxi²ye³si¹jau³su² ĩ³ye³kxi²te³nah¹lxi¹: — Tih³nxe³sa²jah¹lãi³. Ã¹te²ta̱³ wi¹ju³ta³la³ kãi³a¹ke³la³te²kxai³ ka³te̱³na² wi¹tãu³la³ so¹kxi²hĩ̱³na¹te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxu¹tai²na² ĩh¹nxe³te²la¹xã³? Ĩh¹nxet3sxã³ ĩ³yau¹ũ³nxa²te³la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nxa²ha¹te¹ jah¹lai²na² wãn³txi³kxai³lu¹: — Txa²wã¹sũ̱³na² ũ³wha²li¹txãn³sxu² te³nah¹lxi¹: “Txa²wã¹sũ̱³na² Si³yxau³kah³la² Txa²wã¹hxi²kan¹ta² Si³yxau³kah³lai²na² a³lxi¹tai¹nhẽ³li¹. Wxa²ẽ¹nãu³ai²na² whãi²na¹ a³lxi¹tai¹nhẽ³li¹. Txa²wã¹sũ̱³na² wãn³txa² yxo²kwa̱i³nha²kxai³ nũ³kxũn³txi³ sa²yxo²we¹tha²kxai³ wi¹lain³kxi²nha²ha²kxai³ nxe³txai¹nhẽ³li¹. Te²yã¹nxũn³sxã³ a²nũ²a² a²wã̱³kxa² yxau³nũ¹nx2ti³te²na² a³lxi²nha²kxa² yã¹nxe² a³lxi²txai¹nũn³nhẽ¹li¹.” Jau³jau¹xai²na² Txa²wã¹sũ̱³na² wha²li¹txã³nxu¹tai²na² nxe³ta¹hxai²hẽ¹li¹. Jah¹la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Wain³txi³ e³i¹lxi¹. Jau³jau¹xai²na² hãi¹nxe³ti³xa¹ sa²yxo²wet1hxa³tin¹kxai²nãn²tu̱³ ka³te̱³na² wi¹tãu³la³ yũ¹nxa²tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nxa²ha¹te¹ jah¹la²kxai³ wi¹lhin¹ye²nha²kxe³su² wã²nã³ũ¹sain¹sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³ha²kxai³ ĩh¹te²la³ta̱³ a²wa̱³kxa² yxau³nũ¹sa²te²la³hĩ̱³te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²sa²sa²lxi¹. A²nũ²a² ai³nũ²nhai¹. Je³ru³sa³lẽ²thĩ³na² a³li³nũ²la² Je³ri³ko²thĩ³nãn¹tĩh³na² si³ka³la³hi²nũ²nhai¹. Nxe³sxã³ a³li³sxã³ si³ka³la³hi²tãu³a² kuh³lxa³thin¹tũ̱³ka̱³txa² ne³khauh²hain¹nũ²la² ĩ³su²lhxã³ ĩ³yĩx1to³tai¹nha²kxai³ a²wã²la² kãi³kxai¹nha²kxai³ ain¹ka³tu̱³ ã³ain¹nũ²nhai¹. Ĩ³ya²lu¹te³lhxã³ ai¹nha²kxai³ ã³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nxa²ha¹te¹ ye³jen¹na² a²nũ²ai²na² Sũ̱³na² yen³nãu³a² ã³ye³yxo²nũ¹nyhain¹jah¹la² ã³si³hẽ²kxi²nũ²nhai¹. Ã³si³hẽ²kxi²tãu³a² sun²ta³kxi²sã³ain¹jah¹lai²li² ĩ²nũ²nhai¹. Ĩ²ka³tu̱³ta¹ tĩh³na² ya¹nãn²tĩh³na² ã³ni²lhxã³ si³ka³la³hi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nxa²ha¹te¹ ye³jen¹nũn³tãu³a² Le³vi²a² nũ̱³ka̱³txi³sa²jah¹la² a²jã¹nxe² ã³si³hẽ²kxi²nyhain¹nũ²nhai¹. Ai¹nha²kxai³ ĩ²ain¹sãn²sxã³ tĩh³na² ne³ha³ti³hi²nãn¹tĩh³na² ã³ni²lhxã³ si³ka³la³hi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nxa²ha¹te¹ Sa³ma²ri²a²ko³xan¹jah¹la² a²jã¹nxe² ã³si³hẽ²kxi²nyhain¹nũ²nhai¹. Nxe³te²a²kxai³lu² ĩ²ain¹te³na¹ ĩ³yan³ta³kxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ã³tĩ̱³ain¹nũ²nhai¹. Nxe³nũ²la² o²lyau³xa² yũ³ha²kxai³ vĩn²yau³xa² yũ³ha²kxai³ nxe³sxã³ ĩ²su²lain¹je³na² wxa²to̱¹lain¹nũ²nhai¹. Nxe³sãn²nũ²la² sa²tai³kxain¹nũ²la² hã²wxãn³txa³ a²ka³fa¹la³ khai³xa² tẽ³nũ²la² so¹sxã³ ũ³ka³ti³wxe̱³kxi²nũ²la² ã³sa²so¹xi²nũ²nhai¹. Ã³sa²so¹xi²nũ²la² sxa³sxãu³xi²thĩ³na² ai³sxã³ ũ³ha̱¹nũ²nhai¹. Nxe³thĩ³nãn¹ta² wa³kxẽ³na² wi¹la³ ĩ²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ã¹ka³nxa³ha²ta³a² thĩ¹nai²na² a²wa³kxẽn³yah³la² e³kxi²te³nah¹lxi¹: “Wi¹la³ hau³ko³txai¹nhẽ³li¹. Ã³wa̱³li²na¹tãu³a² ũ³yho³hi¹nxa²ha¹tu¹wi¹. Hĩ¹na² ki³ha¹li¹ ũ³yho³hi¹nxa²ha¹ka³tu̱³ kxãn³nãu³a² wã³kon³kxai²nãn²tu̱³ jã¹nxe² ũ³yho³hi¹nxa²ha¹tu¹wi¹.” Ain¹nũ²nhai¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jã¹nxe³jau³kxai³la¹: — Nxe³jau³xai²li² in³txa² ha¹li¹ ka³na³ki² te²a² ĩh¹te²la³ta̱³ ĩ³ton³jah¹la² a²wa̱³kxa² yxau³nũ¹sa²te²la³ hĩ̱³te²la¹xã³? Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nxa²ha¹te¹ jah¹lai²li² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³yan³ta³kxain¹jah¹la² a²wa̱³kxa² yxau³nũ¹sa²te²hũ̱³jah¹lai²lxã²na³li¹. Ta¹hxai²hẽ¹la². Nxũ²la² Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Nxe³kxai²nãn²tu̱³ jah¹la² kãi³kxi²nũx1 jã¹nxe² a²nũ²a² ã̱³xa² kãi³ũh¹txai¹nhẽ³li¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nxa²ha¹te¹ Je³su²jah³la² a²sa³wi³ha³lxi³nãu³xa² nxe³ain¹sxã³ aun³tain¹nũ²la² sxi²je³na² wxa²li³ain¹ta¹hxai²hẽ¹la². Wxa²li³ain¹nxa²ha¹te¹ Mar²ta³ka³lxa² sxi²je³nãn¹ta¹ka³lxu³su² ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxai²na² wãn³txi³kxai³lu¹: — Txa²sxi²ha² ã³wi²kxi²sxã³ ĩ³yain³ya³sah¹lxi³sĩ¹nhẽ³li¹. Nxe³nyhain¹nxa²ha¹te¹ ã³wi²kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","40","A²nxe³ta¹ka³lxa² a²ha³lĩn³ta³ka³lxa² Ma³ri²a³ka³lxu³su² ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² ã³wih¹kxan²ta² Ma³ri²a³ka³lxai²na² sa²kxai³lu² Je³su²jah³lai²na² a²ne³kxai³tãu³a² ã³wxe³nũ²la² a²wãn³txa² ĩ³yau¹ũ³jau³xa² ain³kxi²ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Mar²ta³ka³lxai²na² sa²kxai³lu² a²wa³ka³li³yu³ta² hxi²ye¹ta³lxi³nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Txa²ha³lĩ³ta² wa³ka³li³yu³ta² a̱³nũ²la² hãi¹sxã³ ã³wxe²na³li¹. Ã³nhi²nũ¹sa²si¹hai¹nĩn¹jau³su² ĩ³ye³kxi¹tai¹lxi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Mar²ta³ka³lxãi³. Ĩ²sã³ni¹. Wxa²wa³ka³lxi³yu³ta² kãin² hxi²waun³ta³txi²nha²khaix1nĩ¹nxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nxe³ai¹nĩn¹ta¹ yu³ka³na³ka³na³ju³ta² on³na³ni¹. Nxe³ju³ta² Ma³ri²a³ka³lxa² ĩ²sxã³ sa²so¹na²ni¹. Txa²wãn³txa² ain³kxi²sa³na²ni¹. Ju¹tai²na² ã²la² wi¹na³ni¹. Sa²sai¹kxin²nxa³lho³ni¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nxa²ha¹te¹ ha³la³jen¹nãu³a² Je³su²jah³la²kxai³lu² Txa²wã¹sũ̱³na² ĩ³ye³kxi²te³lhxã³ a³li³ta¹hxai²hẽ¹la². Hã²wxãn³txa³ ĩ³ye³kxi²ta³lun²nxa²ha¹te¹ a²sa³wi³sa² ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Jo³ãu² Ba³tis²jah³lai¹tã² a²yxo²wãn³txa² a²sa³wi³ha³lxi³khai³xa² ĩ³ye³kxain¹sĩn¹ta¹hẽ¹li¹. Txa²wã¹sũ̱³nai²li² wain³txi³ ĩ³ye³kxi²jau³xa² ĩ³yau¹ũ³nyhain¹sĩn¹ta¹hẽ¹li¹. Nxe³jãx1jau³xa² ĩ³yau¹ũ³sa²nhĩn¹ju³ta² ten³sa²nũn³sĩn¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²sah¹lxi³wxi¹. “Txa²wã¹sũ̱³na² ĩ³ye³kxi²ti³ten³sa³nha¹.” Yxah³lxin¹kxai²nãn²tu̱³ nxe² e³kxi¹jah³lxi³hẽ¹li¹: “Txa²wã¹wĩ³nãi³. Wi¹lhin¹sxã³ sa²nẽn¹kxi² kãin²no³txa²ju³ta² ten³sah²sĩn¹nhai¹. Wa³su³txi³ A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²ju³ta³nũ³su² ten³sa²sĩn¹nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yain³txa² hãi¹nxe² ũ³hũ¹sa²nhĩn¹tu¹xai³sa²sĩ¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A²nũ²a² ã̱³xai²na² ko̱³nxe³ti³ kãi³ũ¹sain¹sĩn¹kxai²nãn²tu̱³ ne³wã²na³ũ¹hain¹sĩ¹na¹wi¹. Nxe³ain¹sĩ¹na¹kxa² yã¹nxe³sxã³ ko̱³nxe³ti³ kãi³ũh¹nxa²sĩ¹na¹ju³ta² ne³wã²na³ũ¹sa²sĩ¹nhẽ³li¹. Ha³lo²a² ko̱³nxe³ti³ kãi³si¹sĩ¹na¹ju³ta³nũ³a² ã³sa²so¹sa²sĩn¹txa³hẽ¹li¹.” Nxe³jau³xa² he³la³kxa² Txa²wã¹sũ̱³na² ĩ³ye³kxi²txai¹yah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Nxe²e³ta³lun²nũ²la² a²sa³wi³ha³lxa² ĩ³ye³kxi²xi²te³nah¹lxi¹: — Ne³ka²sah¹lxi³wxi¹. Ĩ³yau¹ũ³nx2ta¹jau³xa² ĩ³ye³kxi¹nx2ta¹tu¹wi¹. A²nũ²a² sxi²lho³jah¹lo²su² nũ²nhai¹. A²nxe³jah¹lai²na² sa²kxai³lu² kã³nxah³ta³wi³ta² sxi²ha² a³li³nũ²la² a²ya̱³lxa² sxi²ha² ai³sxã³ ã³tĩ̱³nũ²la² ĩ³kaix1so¹sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Nxex3sa²lxi¹. Yain³ta³nũ̱³xa² so¹kxi¹nx2te³lhxã³ wxã³na¹wi¹. Txa²wã³tã̱³ah³la² sxi²ha² u²lxi³thĩ³na² ĩ²sa²te³lhxã³ wxã³na²li¹. Yxãn¹ta¹ yain³ti³la³ yũ³sa²nxa³ha²kxai³ ãu²li²sa³hẽ²li¹. Nxe³sa²ju³tan¹te²kxa³ya̱³lhu² yain³txi³nũ̱³xa² nũ̱³ha¹li¹ ka³na³ki¹ ũ³hũ¹sẽ¹li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nxa²ha¹te¹ sxi²ha² wa³kxẽn³yah³la² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: “U̱³lha³nhai¹. Txa²wẽ³ha³lxa² ãu³xa³kxi²sa³nhai¹. Nxe³ha²kxai³ hxi²kan¹sa²nxa³nhai¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nxe³jut3su² ne³ke³la³te²kxai³ ĩh¹nxe³tai¹nhĩn³te³ji¹wi¹? Ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Ain³kxi²nha¹jxah³lxi³hẽ¹li¹. Ya̱³li³nyha¹ha²kxai³ u̱³kxan²ti³nũ¹ ĩ³ye³ye³kxi²nyha¹ha²kxai³ yain³txa² te³nain¹tũ̱³xai²li² ũ³hũ¹ai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Te²yã¹nxe³kxe³hũ̱³sxã³ Txa²wã¹sũ̱³na² ĩ³wã̱³jah³lxin¹kxai²nãn²tu̱³ yen³kxa² wi¹kxa² ũ³hũ¹nx2ti³tu¹wi¹. Te²yã¹nxe³sxã³ yen³kxa² ã³ten³yah³lxin¹ju³ta² ã³ya³jah³lxin¹tu¹wi¹. Te²yã¹nxũn³sxã³ sxi²ha² a²yxo²a² ĩ³yxo²to¹tot1jah³lxin¹kxai²nãn²tu̱³ sa²yxo²than²yex1tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Te²yã¹nxe³kxe³hũ̱³sxã³ Sũ̱³na² ĩ³wã̱³jah³lxin¹kxai²nãn²tu̱³ nxe³yah³lxi³te² ĩ³nxãn²tu̱³ a²wi¹ju³ta² ũ³hũ¹nx2ti³tu¹wi¹. Yen³kxa² ã³ten³yah³lxi³te² ĩ³nxãn²tu̱³ a³ya³ti²yah³lxin¹tu¹wi¹. Sxi²ha² ĩ³yxo²to¹to¹jah³lxin¹te² ĩ³nxãn²tu̱³ sa²yxo²than²ye¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Te²yã¹nxe³ju³kxai³la¹ wxa²wẽ³sai²li² yain³tũ̱³xa² ĩ³wã̱³txi³nx2ti³kxai²nãn²tu̱³ tah³lxa³kxa² ũ³hũ¹yah³lxi³hĩ̱³nhãn¹te²la¹xã³? Te²yã¹nxe³sxã³ a̱i³na² ĩ³wã̱³txi³nx2ti³kxai²nãn²tu̱³ txi³hxa² ũ³hũ¹yah³lxi³hĩ̱³nhãn¹te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Te²yã¹nxũn³sxã³ a̱i³ka³nãu³xa² ĩ³wã̱³txi¹nx2ti³kxai²nãn²tu̱³ sxe³sxe³kxa² ũ³hũ¹yah³lxi³hĩ̱³nhãn¹te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ti³he¹nxa³wi¹. Ko̱³nxe³ti³hin¹yah³lxin¹kxan²ti³ yen³kxa² wi¹te²a² so¹lxi³ wxa²wẽ³ha³lxa² ũ³hũ¹ain¹yah³lxi³hĩ̱³nxa¹lxi¹. Te²yã¹nxe³ha²kxai³ Txa²wã¹sũ̱³na² Si³yxau³jah¹la² Oh³nãn¹jah¹la² sa²kxai³lu² ĩ³wã̱³txi³yah³lxin¹kxai²nãn²tu̱³ Sũ̱³na² Yãu³ka³txi³khai³xa² ũ³sa²si¹hã³nx2ti³tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hã²wxãn³txa³ a²nũ²ai²na² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau³te²a² ĩ³ha¹txain¹ta¹hxai²hẽ¹la². A²nxe³jah¹lai²li² hxi²kan¹txi³ e³ta¹hxai²nxa³hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² hi²sen³kxai³lu² a²ko̱³nxe³te²a² yãu³ka³txa² nũ̱³kwa̱i³wi²sxa³te²a² yxo²xũn³txi³ a³li³si¹jau³su² kwa³na³ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² wa³su³txi³ a³li³ha²kxai³ we²txi³ha²kxai³ wi¹le³xi²ye²ta¹hxai²hẽ¹la². Nxe³jut3su² a²nũ²a²nãu³xa² on²txain¹sxã³ ĩ³ye³lain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² kãin²khaix1nx2na³li¹. Ka³lih³khaix1sa²sĩ¹nhai¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nxe³to³ta¹ a²nũ²a² yxo²ĩ³ai¹nxa³tũ̱³ka̱³txa² e³ki³ha¹kxain¹te³nah¹lxi¹: — Jah¹lai²li² Bel³se³bu²ah³la² a²ta³a² hxi²kan¹txi³su² te²a² a²sa³wi³sai²la¹wi¹. Nxe³ha²kxai³ hxi²kan¹ti³hi¹txai¹nha²kxai³ ko̱³nxe³te²a² yãu³ka³txa² a³li³si¹jau³su² kwa³na³in²tai¹. Txa²wã¹sũ̱³nu²su² ti³he¹xai¹nxa³wi¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nxa²ha¹te¹ a²nũ²a² ã̱³xai²na² ã³wxã³ain¹ta¹hxai²hẽ¹la². Ko̱³nxe³ti³hi¹nain¹jau³su² ĩ³ye³kxi²sai³nain¹ta¹hxai²hẽ¹la². Ĩ³ye³kxi²sxã³ ĩ³wã̱³txain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² ya²la³tu̱³ ĩ³hxi²ka¹txain¹kxai²nãn²tu̱³ oh³nãu³a² wã³nxĩn¹sxã³ kãi³ju³ta² wã²na³ũ¹sa²sĩ¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ain¹nxa²ha¹te¹ Je³su²jah³la² te²kxai³lu² a²ẽ¹nãn¹jau³xa² wi¹ko̱³nha²ha²kxai³ ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²sah¹lxi³sa²lxi¹. A²nũ²a²nãu³xai²na² sa²kxai³lu² wã²nxũ̱h¹lxi³sxã³ ã³nhe¹kxi²nyhu¹ain¹kxai²nãn²tu̱³ ya³lu²kxa²hxa³kxi²nyhain¹te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ sxi²ha² a²yu³tai²na² ã³nhai²ta³lxi²sxã³ yxau³ain¹kxai²nãn²tu̱³ kan²txi³ yxau²sa²tẽ³ai¹nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te²yã¹nxe³sxã³ Sa³ta³na²jah¹la² nũ̱³ka̱³txa² he¹kxi²nyhu¹ain¹kxai²nãn²tu̱³ ã³nhai²ta³lxi³hain¹tu¹wi¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² nũ³kxũn³yai¹nxa³ha²kxai³ wa³su³txi³ hxa³nain¹tu¹wi¹. Jã¹nxe³yah³lxin¹jau³kxai³lu¹: “Jah¹la² Bel³se³bu²ah³la² a²sa³wit3su² ha²kxai³ ĩ³wã³nxĩn¹txi³nĩn²tai¹. Nxe³ha²kxai³ ko̱³nxe³te²a² yãu³ka³txa² a³li³si¹jau³su² wxi²kan¹sxã³ kwa³na³in²tai¹.” Nxe² ĩ³ye³lah³lxĩ¹nhẽ²li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nxe³ha²kxai³ wxa²wãn³txa² e³yah³lxin¹te³nah¹lxi¹: “Je³su²jah³lai²li² Bel³se³bu²ah³la² sa³wi³sai²la¹wi¹.” Yah³lxin¹jau³su² yxãn¹ta¹ wxa²nũ̱³ka̱³txe² ĩ³nxai²na² wxa²wẽ³ha³lxa² kãi³yah³lxin¹kxa² yã¹nxe² kãin³ain¹nũ³na³li¹. Nxe³ai¹nha²kxai³ wxa²nũ̱³ka̱³txai²na² ĩh¹te²la³ta̱³ sa³wi³ha³lxin³ta̱³ hĩ̱³te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yxãn¹tah¹lxa¹ Txa²wã¹sũ̱³na² Yãu³ka³txa² Te²hi²sen³su² ĩ³hxi²kat1sa³ha²kxai³ hxi²kan¹txi³ ko̱³nxe³te² yãu³ka³txa² nxũ²kwa̱i³li³si¹jau³su² ĩ³ye³kxi²na¹wi¹. Nxe³na¹kxe³su² ya²la³txi³ Txa²wã¹sũ̱³na² A²hxi²kan¹txa² Si³yxau³tãu³lot3sa²jah¹lo²su² ye²te²sa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Te²yã¹nxe³jut3su² a²nũ²a² nũ̱³kxũn³te²a² sxi²ha² wi¹lhau³ko³kxai²nãn²tu̱³ a²yen³kxa² a²yxo²ha³kxa¹ wi¹yxau³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yxãn¹ta¹ a²nũ²a² ã²la² nũ̱³kxũn³te²a² wxã³sxã³ he¹li³nũ²la² ĩ³sun²txi³nyhain¹kxai²nãn²tu̱³ hu³kxi³su² he¹kxi²nyhain¹ta³ka³tai²na² yxo²ĩ²nyhain¹ka³txan²tu̱³ i³sxã³ sa²ni²lho¹kxi² a²yen³kxa² sa²so¹kxi²nxain¹ka³tu̱³ tẽ³sxã³ ĩ³xain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jã¹nxe³jut3su² a²nũ²a² ã³ya̱³lxi²sai¹nxa³kxai²nãn²tu̱³ txa²ko̱¹ko̱¹sain¹na³li¹. Te²yã¹nxe³sxã³ o³ve²a² yã¹nxe² ã³nũ²kxi²sxã³ yxau³ya³sai¹nxa³kxai²nãn²tu̱³ ha³te̱n¹txain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Te²yã¹nxe³ju³kxai²lu² ko̱³nxe³te²a² yãu³ka³txa² a²nũ²a² nxũ²kwa̱i³li³kxai²nãn²tu̱³ ha³lo²ai²na² ĩ̱³yau³la³ yũ²nxa³ko³xai²na² sa²kxai³lu² ĩ³ye¹nxi²te³lhxã³ ai³lha²thet3tin²tai¹. Nxe³to³ta¹ hxi²kan¹txi³ ĩ³ye¹nxi²xa³kxai²nãn²tu̱³ ĩ³ye³kxi²nha²te³nah¹lxi¹: “Txa²sxi²ha² a³li³a¹thĩ³nai³tã² ã³wa̱³li²na¹tũ¹xã¹.” Ain¹jau³su² ha²kxai³ ã³wa̱³lin²tai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ã³wa̱³li²tãu³a² a²nũ²ẽ¹nai³ta³lxi³ a²nũ²yũ²nxa³ha²kxai³ wi¹we¹txi³ha²kxai³ wi¹lhau³ko³nha²kxai³ nxe³ye²tin²tai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nxe³ye²kxe³su² ha³lo²a² ai³lxi²nĩn²tai¹. Ai³lxi²ka³tu̱³ ko̱³nxe³te² yãu³ka³txi³nãu³xa² ha¹li¹ ha¹li¹ ha¹li¹ ka³na³ki¹ nxe³te²nãu³xa² ko̱³nxe³ti³khaix1 wa³to³hain¹te²nãu³xa² ĩ³ha¹txin²txai¹nĩn²tai¹. Nxe³te²nãu³xa² sa²so¹sxã³ ã³wa̱³li²xi²sa²tẽ³in²tai¹. Nxe³ju³tai²kxai³lu² in³txa² ẽ¹nãu³a² ko̱³nxe³ti³ ã³wa²to²hin²tai¹. Nxe³ye²nx2ta¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nxe³ta³lun²nũ²la² txu¹ha² ĩ³kaix1te³nah¹lxi¹: — Je³su²jah³lãi³. Wxa²hã³ka³na² wẽh³ni³nxa²sxã³ kũh¹txa²sxã³ we¹txa²ta¹ka³lxa² ka³lih³khaix1ta¹ka³lxi³su² na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Wain³na³ni¹. Yxãn¹ta¹ a²nũ²ai²li² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ sa²yxo²we¹kxai²nãn²tu̱³ nxe³te²a² ã²la² kãin² ka³lih³hain¹na³ni¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nxa²ha¹te¹ ĩ³ye³ta³lun²nũ²la² a²nũ²a² ã³wxã³wxã³ai¹nha²kxai³ ka³lxa¹txi³ ã³nũ¹tain¹ta¹hxai²hẽ¹la². Nxe³te³na¹ ĩ³ye³kxi²te³nah¹lxi¹: — Ko̱³nxe³thin¹khai¹yxah³lxi¹lxi¹. Sũ̱³na² ĩ³sa²si¹hã³sa²jau³su² jau³xa² ten³ti³he¹yxah³lxa³lxi¹. Yah²lxa³nha²kxai³ Sũ̱³na² ĩ³sa²si¹hã³sa²kxe³su² wã³nxĩn¹sxã³ kãi³a¹ju³ta³la³ ĩ³ye³kxi²sah¹lxi¹nhẽ³li¹. Nxe³yãn¹ta¹ hĩ¹na¹ wã³nxĩ¹na¹ju³ta³la³ wã²nã³ũ¹nx2ti³nxa³lho³li¹. Wãn³txa² wã²nã³ũ¹nx2ta¹jau³xa² tĩ³yau³xu¹tai²na² so¹lxi³ ĩ³yũ¹yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nxe³jau³xu¹tai²na²sa¹. Jo²na³jah³lu¹tai²na² sa²kxai³lu² ye³ha¹li¹ ka³na³ki¹ a³la²ni²tãu³a² a̱i³na² a²ẽ¹nai²na² ka³te̱n³su² sxa³ta¹hxai²ti³ai¹ti²tu³wi¹. Hã²wxãn³txa³ a³li³sa²sai¹ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² sa²kxai³lu² ye³ha¹li¹ ka³na³ki¹ a³la²ni²tãu³a¹ kxĩh³nxẽ¹na² ya³lu²sxã³ sxa³na¹tu¹wi¹. Hã²wxãn³txa³ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹. Nxe³ju³tai²na¹ Sũ̱³na² sa²si¹hã³sa²ju³ta² e³lxah²lxi³ ĩ²yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jã¹nxe³jut3su² kxã³nhxĩ¹nu¹tai²na² Se²ba³thĩ³na² a²wa³kxẽn³na¹ka³lxu¹tai²na² sa²kxai³lu² Sa³lo³mãu²ah³lu¹tai²na² wãn³txa² a²hoh³lxi³khaix1nxe³jau³xa² ain³kxi²te³lhxã³ u²lan¹thĩ³na² a³li³sxã³ wxã³ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³ta¹ka³lxai²na² sa²kxai³lu² yan¹nãu³a¹ Txa²wã¹sũ̱³na² sa²kxai³lu² a²nũ²a² kãi³ain¹kxa² yo³ha² a³ya³ti³kxe³su² nxe³ti³xa¹ ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³tu¹wi¹. Kxã³nhxĩ¹nu¹tai²na² Sa³lo³mãu²ah³lu¹tai²na² wãn³txa² wi¹lain³kxi²ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ Txai²na² sa²kxai³lu² Sa³lo³mãu²ah³la² ĩ³kãin²wa³to²hi²na¹jah¹lo²sa¹wi¹. Nxe³sa³kxan²ti³nũ¹ Txa²wãn³txa² ain³kxi²ti³ten³nxa²lxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Te²yã¹nxe³jut3su² yan¹nãu³a¹ Txa²wã¹sũ̱³na² sa²kxai³lu² a²nũ²a² yxo²ha³kxa¹ kãi³ain¹kxa² yo³ha² a³ya³txi²kxe³su² nxe³ti³xa¹ Ni³ni³ve²thĩ³nãn¹ta² nũ̱³ka̱³txu¹tai²na² nxe³te²hi²sen³kxai³lu² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2tain¹tu¹wi¹. A²nxe³te²nãu³xu¹tai²na² sa²kxai³lu² Jo²na³jah³lu¹tai²na² wãn³txa² ain³kxai¹nha²kxai³ ko̱³nxe³thi¹nain¹ju³tu¹tai²na² ã³na¹ain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Jo²na³jah¹la² hxi²kan¹jah¹lo²su² ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ kãin²wa³to²hi²jah¹lo²sa¹wi¹. Nxe³sa³kxan²ti³nũ¹ Txa²wãn³txa² sa²yxo²wet1sah²lxa³lxi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nxe³ha²kxai³lu¹ yau³xã̱³xa² ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²ai²li² lã³pi³ãu²tẽ³na² tẽ³sxã³ ũ³thũ²kxi²sa²no¹ki̱³sxa³ha²kxai³ kwa³ta³lẽ³na² ũ³tĩ¹kxi²wxe³ki̱³sxa³ha²kxai³ nxe³kxi³te²sxa³yu²hẽ³li¹. Yxãn¹ta¹ kĩ³txi³ ũ³kũt1tũ²la² sxi²hẽ¹na² yxo²ha³kxa¹ wi¹sa²kĩ̱x3te²ju²hẽ³li¹. A²nũ²a² ye³khe¹txi³ ã³wi¹hai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","36","Txa²wã¹ye³nai²li² ye³wi¹kxai²nãn²tu̱³ txa²wã¹nũ²a² whãi²na¹ wi¹lo²la³kxi²nha²ki̱³te²ju²hẽ³li¹. Yxãn¹ta¹ ye³wi¹lxa³kxai²nãn²tu̱³ txa²wã¹nũ²a² whãi²na¹ hai³txi³ wi¹lo²la³kxi²nha²te²sxa³yu²hẽ³li¹. Nxe³kxa²yã¹nxe³jut3su² txa²wã¹ẽ¹nãu³ai²na² wi¹lxa³kxai²nãn²tu̱³ wi¹kãi³sxã³ yxau²xai³ki̱³sxa³wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ĩ³ye³ta³lun²nũ²la² fa³ri³se²a² in³jah³la² ã³tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²sxi²ha² ã³wih¹sxã³ ĩ³yain³kxi²sẽ¹li¹. Nxai¹nha²kxai³ ã³wi¹hain¹nũ²la² ã³wxe³ain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ Je³su²jah³la² hxi²khai²lxi²sã²nxa³sxã³ ã³wxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ã³wxe³ka³tu̱³ta¹ fa³ri³se²ah³la²kxai³ ju¹ta² ĩ²nũ²la² o²nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nxa²ha¹te¹ Je³su²jah³lo²kxai³ Txa²wã¹hxi²kan¹ta² Si³yxau³jah¹lo²kxai³lu² ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²sa²sa²lxi¹. Wi¹lhin¹ki³lxot3jah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³to̱n³khaix1yah³lxin¹tu¹wi¹. Ka³ne²kxẽn³su² ta̱³nxa² pra²ta²ka³lo³su² ta̱³nxa² a²tai²na¹ wxa²hi³la³kxi²sxã³ wxa²hxan³kxa³txi³yah³lxi³hĩ̱³nxa¹lxi¹. Yxãn¹ta¹ wxa²ẽ¹nãu³ai²na² a²nũ²a² yen³kxa² kãi³kxi²nyhu¹ah³lxin¹ju³ta² yũ³ha²kxai³ ko̱³nxe³ti³hin¹ju³ta² kãin² yũ³ha²kxai³ nxe³kxa² yã¹yxah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","A²hoh³lxi³sa²yah³lxa³lxi¹. A²wi¹lhĩ¹nu¹tai²na² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² a²nũ²a² yxo²ha³kxa¹ we¹jah¹lo²su² ta¹hxai²ti³ai¹ti²tu³wi¹. A²nũ²khai³su² we¹txi² a²ẽ¹nãu³ai²na² we¹txi² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nxe³ha²kxai³ ko²pẽ³na² pra²to²ka³lo³ai²na² yen³kxa² wxi²sxa³te²a² tẽ³nũ²la² a²nũ²a² yen³kxi³txa²sxã³ sxa³te²a² wã²nhũ¹txai¹yah³lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ wxa²ẽ¹nãu³a² ĩ³ha³ne³nx2ti³jut3sũ̱³nxe² wi¹lhin¹nxa²lxi³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yxãn¹ta¹ wxa²nũ̱³ka̱³txai²na² fa³ri³se²a² nũ̱³ka̱³txi³su² te² ĩ³nxai²na² wi¹lhin¹ki³lxo³jah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. Yah¹lxi¹nha²kxai³ yen³kxa² jũ¹nxe³te²su² te²a² yain³kxi²ki̱³ki³a² or³ta³lã²ki³su² ta̱³nxa² a³ru²ta³ki³su² ta̱³nxa² hĩ³ne³ki³nxã³nxa² yũ³yah³lxin¹kxa² nxã³nha¹li¹ nxã³nha¹li¹ nxã³nha¹li¹ nxã³nha¹li¹ nxã³nha¹li¹ yũ³yah³lxin¹kxai²nãn²tu̱³ nxãn³ka³na³ka³nat3sxã³ Txa²wã¹sũ̱³na² ũ³hũ¹yah³lxi³hxain¹tai¹ti²tu³wi¹. Yxãn¹ta¹ ha³te̱h³nxã³nxu¹tai²na² ĩ³yau¹ũ³nẽ³jau³su² ã²la² wxi²kan¹kxe³su² wain³txi³su² kãi³ũh¹kxe³su² ta̱³nxa² Txa²wã¹sũ̱³na² a³lxai¹yah³lxin¹kxe³su² ta̱³nxa² nxe³ju³tai²na² ha³kxa¹ sa²yxo²ã³yah³lxi¹lxi¹. Nxe³ju³tai²na² a²wi¹lhĩ¹nãn¹te²a² yxo²ha³kxa¹ kãi³yah³lxin¹ju³ta² wain³na³li¹. Te²yã¹nxe³sxã³ ne³ki³san¹te²a² sa²yxo²ã³yah³lxin¹ju³ta² wai³nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Te²yã¹nxe³sxã³ fa³ri³se²a² nũ̱³ka̱³txi³ ĩ³nxai²na² ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² wxi²kan¹ti³ton³te²na² ã³wxe³ju³ta² yxo²kwa̱in³yah³lxi¹nha²kxai³ sxi²je³na² ã³nxai³yah³lxin¹kxai²nãn²tu̱³ sa²nẽn¹kxi³sxã³ ĩ³kaix1nx2ti³te²ju²hẽ³li¹. A²nũ²a² ã̱³xai²na² ĩ³kaix1te³nah¹lxi¹: “Wxãi²li² txa²hxi²kan¹jah¹lo²si¹lxi¹.” Nxe³jau³su² yxo²kwa̱in³yah³lxi¹nha²kxai³ nxe³yah³lxi³hxai¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yxah³lxi³nha²kxai³ ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. Wxa²nũ̱³ka̱³txai²na² kxĩh³nxa² kwã̱³kxẽ¹na² yãx1yah³lxi¹lxi¹. Nxe³je³nai²li² a²nũ²a²nãu³xai²na² sxa³ye²je³nai³tã² ko̱³nhxai¹nxa³ha²kxai³ sa²ka³nex3tai¹nha²kxai³ ko̱³to³nain¹te²ju²hẽ¹li¹. Nxe³kxa² yãx1yah³lxin¹sxã³ wxa²ẽ¹nãu³ai²na² ko̱³nxe³khaix1na³li¹. Nxe³ha²kxai³ a²nũ²a² ĩ²li³te²a² ĩ³tih³nxe³yah³lxin¹kxai²nãn²tu̱³ ko̱³nxe³te²lo³tũn³tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nxa²ha¹te¹ ha³te̱h³nxã³nxa² a²hoh³lxi³sa²jah¹la² ĩ³ye³kxi²te³nah¹lxi¹: — Tih³nxe³sa²jah¹lãi³. Nxe³jau³xai²li² yxo²xũ̱n³txi³ ĩ³kwa̱i²kxi²sa²nhĩn¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Wxãi²na² wxa²nũ̱³ka̱³txai²na² ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. Yah³lxi¹nha²kxai³ wãn³txa² sa³te̱¹jau³xa² sa²yxo²wet1sxã³ kãi³si¹jau³su² a²nũ²a² ã̱³xa² kwa³na³yah³lxi¹lxi¹. Yxãn¹ta¹ jau¹xain²txi³ sa²yxo²we¹jah²lxa³lxi¹. Te²yã¹nxe³kxe³hũ̱³nxe² a²nũ²a² ã̱³xa² yen³kxa² sa³te̱¹kxa² ã³ta³lo³hẽ¹so¹si¹yhah³lxi¹lxi¹. Yxãn¹ta¹ yen³kxain²txi³ a²hxi²ka² wẽ³sa²kxan²ti³ ũ³hxi²nũ¹yah³lxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nxe³ha²kxai³ ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. Yah³lxi¹nha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² wxa²ka³lxa¹ti³nãu³xu¹tai²na² hi²sen³kxai³lu² sun²tã¹ain¹te³nai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nxe³ain¹ju³tu¹tai²na² e³kxah²lxin¹te³nah¹lxi¹: “Ĩ³sun²tã¹nyhain¹ju³tu¹tai²na² wi¹lhi¹tain¹na²hẽ³li¹.” Yah³lxin¹jau³su² nxe³ha²kxai³ wxa²ka³lxa¹ti³nãu³xu¹tai²na² ya²la³tu̱³ sun²tã¹nyhain¹ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ wxa²nũ̱³ka̱³txi³nãu³xai²na² wxa²hxi²nũ¹nain¹tũ̱³ka̱³txa² yã¹yxah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nxe³yah³lxin¹kxe³su² Txa²wã¹sũ̱³na² wãn³txi³kxai³lu¹: “Txa²wãn³txa² ĩ³hen³txi³ta¹tũ̱³ka̱³txai²na² ĩ³kaix1so¹ai¹na¹tũ̱³ka̱³txi³sa²te²a² nxe³sxã³ sa²si¹hã³a¹tu¹wi¹. Ai¹na¹ta¹ sun²tã¹ĩ² kãin² ĩ³yĩ¹to³ti² nxe³nyhai¹nha³ta²wi¹.” Txa²wã¹sũ̱³na² nxe³ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Nxe³ha²kxai³la¹ wxãi²na² wxa²nũ̱³ka̱³txi³khai³xa² Txa²wã¹sũ̱³na² hi²sen³su² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³tu¹wi¹. Kxã³nhxĩ¹nu¹ta²kxai³ txa²nũ̱³ka̱³txa² sun²tã¹sain¹ju³tan¹te²kxa³ya̱³lhu² hĩ¹nai²na² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³tu¹wi¹. A²wi¹lhĩ¹nu¹ta²kxai³ A³be²lah³lu¹tai²na² su²lhã³ju³tu¹tai²na² Sa³ka³ri²ah³lai¹tã² sun²tã¹ju³tai³tã² nxe³jah¹la² Txa²wã¹sũ̱³na² sxi²hẽ¹nãu³a² sun²tã¹ain¹te³nai¹ti²tu³wi¹. Jã¹nxe³ju³kxai³la¹ wxa²nũ̱³ka̱³txa² sun²tã¹ain¹yah³lxin¹ju³ta² yxo²ha³kxa¹ ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jã¹nxe³yah³lxin¹ju³kxai³la¹ wi¹lhin¹ki³lxo³jah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³ton³khai¹yxah³lxin¹tu¹wi¹. A²nũ²a² Txa²wã¹sũ̱³na² nũ̱³ka̱³txi³lxon³ju³ta² te³nain¹kxai²nãn²tu̱³ ã³na¹ain¹yah³lxi¹nhẽ³li¹. Nxe³sxã³ Txa²wãn³txa² en²yah³lxi¹nha²kxai³ a²nũ²ai²na² Txa²wãn³txa² sa²yxo²we¹te³lhxã³ te²su² te²na² ã³na¹yah³lxi¹nha²kxai³ nxe³yah³lxi¹nhẽ³li¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Nxe²e³ta³lun²nũ²la² a³li³ta¹hxai²hẽ¹la². Nxa²ha¹te¹ jau¹xai²li² ĩ³a̱n³ta³kxain¹nũ²la² ta³nxũ̱¹ka̱³txa²kxai³lu² ko̱³nxe³te²lo³tai¹nha²kxai³ ki³ha¹kxi²so¹te³lhxã³ ĩ³wã̱³txi³sai³nain¹ta¹hxai²hẽ¹la². — Ũ³tĩ̱¹kxi²na¹tũ¹xã¹. Ain¹jau³su² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nxe³nxa²ha¹te¹ a²nũ²a² ka³lxa¹khaix1nxe³sxã³ ã³wã³wã³sxã³ ã³ka̱³tũx3tain¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a² a²sa³wi³ha³lxa² ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²sah¹lxi³sa²lxi¹. Fa³ri³se²a² nũ̱³ka̱³txa² wi¹lĩ²jah¹lxi³hẽ¹li¹. Ĩ³ki³ha¹kxi²nx3ti³ha³tai¹. Wi¹lhin¹ki³lxo³tain¹na³li¹. Yxãn¹ta¹ a²ẽ¹nãu³ai²na² ko̱³nxe³ti³ kãi³sxã³ yxau²xai³lain¹na³li¹. Nxe³ju³tai²li² ã³ke³tũ¹nx2ti³ha³ta²wi¹. Yain³txa² ĩ³wa̱¹txi³nũ̱³xa² tẽ³ki̱³kxai²nãn²tu̱³ yain³txa³nũ̱³xa² ã³kwa³lxĩ¹sãn²sxã³ yain³tũ̱³xa² whãi²na¹ ĩ³wa̱¹te²ju²hẽ³li¹. Te²yã¹nxe³kxe³hũ̱³sxã³ fa³ri³se²a² nũ̱³ka̱³txai²na² wãn³txa² jũ¹nxa² ain³kxi²yah³lxin¹kxai²nãn²tu̱³ tũ̱¹ka̱³txai²na² yã¹nxe² kãi³yah³lxi¹nha³ta²wi¹. Ju¹tai²na² wi¹ko̱³nha¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nxe³ha²kxai³la¹ hãi³a² kãi³sxã³ yxau²xai³lain¹ju³tai²na² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² e³lxah²lxi³si¹hain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nxe³jut3su² ha²kxai³ ka³nxah³tai²na² wãn³txa² e³kxah¹lxin¹jau³xai²na² a³lan²tãu³a² a²nũ²a² yxo²ha³kxa¹ jau¹xain²txi³ ain³kxain¹tu¹wi¹. Te²yã¹nxe³sxã³ sxi²hẽ¹nãu³a² wãn³txa² he³son³kxah²lxin¹jau³xai²na² jau¹xain²txi³ yxo²kãi²lxi³ e³kxi²jau³xan²ta³ a²nũ²a² yxo²ha³kxa¹ ain³kxain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nxa²ha¹te¹ txa²ya̱³lxah²lxin¹te² ĩ³nxai²na² ne³ka²a³sah¹lxi³wxi¹. Txa²wã¹nũ²ai²na² ĩ³ya²lu¹tẽ³jah¹la² yu̱h³lxah³lxi³txa³hẽ¹li¹. Nxe³te²su² hxi²kan¹txi³ txa²wã¹yãu³ka³txa² ĩ³ya²lu¹tẽ³lxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yxãn¹ta¹ wxa²yãu³ka³txai²na² wxa²nũ²ai²na² nxe³sxã³ whãi²na¹ tẽ³sxã³ ha³lo²a² ko̱³nxe³ko³xa² ha³nxe² i̱³sa²tẽ³ko³xa² ã³na¹kxi²jah¹la² Txa²wã¹sũ̱³na² Si³yxau³ka³jah¹lai²na² so¹lxi³ yu̱h³lxi³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Jã¹nxe³ju³kxai³lu² a̱i³ka² wẽ³sa² ki³ha¹li¹ ki³ha¹li¹ ka³na³ki¹ nxe³te²a² hxi²tẽ³yah³lxin¹kxai²nãn²tu̱³ ũ³yho³hi²ki³a² ki³ha¹li¹ ki³su² nxe³ki³a² ũ³yho³hi¹nx2ti³hĩ̱³nx2na³li¹. A²yo³ha² kãi²nxa³wi¹, a̱i³ka² a³lxi²nxa³ha²kxai³lu¹. Nxe³kxan²ti³nũ¹ Txa²wã¹sũ̱³na² yen³nãu³a² ne³wã²na³ju³ta² yũ³jah¹lo²sxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jã¹nxe³ju³kxai³la¹ Txa²wã¹sũ̱³nu²kxai³lu² A²hoh³lxi³ Si³yxau³jah¹lo²su² na³li¹. Nxe³sxã³ txa²wã¹ne³kĩ̱³sxa² yxo²ha³kxa¹ ĩ³hau³kot3tai¹nhxai²na²hẽ³li¹. Te²yã¹nxe³ju³kxai³lu² a̱i³ka² wẽ³sa² ki³kãi²nxa³kxan²ti³ a³lxi²te²ju²hẽ³li¹. Nxe³kxa²ha³tih³xan²tu̱³ wxãi²nãn²tu̱³ a³lxi² wa³to²hi²nũh¹nx2ti³te²ju²hẽ³li¹, Txa²wã¹sũ̱³na² yen³nãu³a²su¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² yu̱h³lxah³lxi³txa³hẽ¹li¹. Nxe³ye²nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nxa²ha¹te¹ a²nũ²a² ĩ²li³te² ĩ³nxai²na² a²nũ²a² ã̱³xa² ĩ³hen³txi³yah³lxin¹te³nah¹lxi¹: “Txai²li² Je³su²jah³la² a²sa³wi³sa̱¹wi¹.” Yah³lxin¹kxai²nãn²tu̱³ oh³xan¹tũ̱³ka̱³txa² ĩ³hen³txi³na¹tu¹wi¹. Nxe³na¹te³nah¹lxi¹: “Jah¹lai²li² txa²sa³wi³sai²la¹wi¹.” Nxe³na¹jau³su² nxe³ai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yxãn¹ta¹ a²nũ²a² ĩ²li³te² ĩ³nxai²na² a²nũ²a² ã̱³xa² ĩ³hen³txi³yah³lxin¹te³nah¹lxi¹: “Txai²li² Je³su²jah³lai²na² a²sa³wit3sin²nxa³wi¹. Yah³lxin¹kxai²nãn²tu̱³ oh³xan¹tũ̱³ka̱³txa² ĩ³hen³txi³na¹tu¹wi¹.” Nxe³na¹te³nah¹lxi¹: “Jah¹lai²li² txa²sa³wit3su²nxa³wi¹.” Nxe³na¹jau³su² nxe³ai¹na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jã¹nxe³ha²kxai³ a²nũ²a² ĩ²li³te²su² te²an²tu̱³ ko̱³nxe³ti³ kãi³kxai²nãn²tu̱³ hã²wxãn³txa³ ĩ³ãin²ta³kxi²nha²sxã³ ã³yxo²o³tũ¹kxai²nãn²tu̱³ ã³wa²su¹tain¹ju³ta² yũ²na³li¹. Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²su² te²sa¹jah¹lo²na¹xai²na² ko̱³nxe³te²lot3sain¹kxan²ti³ ã³wa²su¹tain¹ju³ta³nũ³a² yũ³tu¹wi¹. Nxe³to³ta¹ wxãi²na² wai³nxa³jau³xa² e³lah³lxin¹jau³kxai³lu¹: “A²ta³a² hxi²kan¹ta² hi²sen³su² Je³su²jah³la² ĩ³hxi²kat1tin²tai¹.” Yah³lxin¹jau³su² yah³lxin¹ta¹ Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² ko̱³nxe³te²lo³jah³lxi¹lxi¹. A²nxe³jau³xai²na² sa²kxai³lu² Sũ̱³na² Yãu³ka³jxah¹la² ko̱³nxe³te²lo³jau³xai²na² sa²kxai³lu² hai³txi³ ã³wa²su¹ju³ta² yũ²nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nxe³ha²kxai³lu¹ a²nũ²a² a̱n³txi³te²a² sa²kxai³lu² sa²so¹nxa²lxi³kxai²nãn²tu̱³ Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³nãu³a² sa²so¹ta̱³nxa² ha³lo²an¹ta² a²si³yxau³ka³txa² sa²so¹ta̱³nxa² nxe³nx2tain¹kxai²nãn²tu̱³ ĩ³wa³lxĩn³yhah³lxin¹jau³nũ³a² hxi²waun³jah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sa²so¹nx2ti³hĩ¹na¹ Txa²wã¹sũ̱³na² A²yãu³ka³txa² hi²sen³kxai³lu² wãn³txa² ĩ³wa²lũ³xain¹yah³lxin¹jau³nũ²a² ĩ³yau¹ũ¹nx2ti³tu¹wi¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² yu̱h³lxah³lxi³txa³hẽ¹li¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ĩ³ye³ta³lun²nũ²la² aun³txa² wxã³ain¹tũ̱³ka̱³txa² a²nũ²a² ka³na³ka³na³te²a² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³tih³nxe³nẽ³jah¹lãi³. Txa²wĩ³na² ya³lu²sa²sĩ¹nha²kxai³ yen³kxa² ũ³hũ¹sain¹sĩn¹na²hẽ³li¹. Sain¹sĩ¹nha²kxai³ txa²lon³na² wã²nũ̱t3ja³sa²si¹hai¹na¹jau³su² nxa¹nhai¹. Na¹jau³xai²li² ĩ³ye³kxi¹txai¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ĩ³kwa̱i²kxi²te³nah¹lxi¹: — Nxex3sa²lxi¹. Wxa²yen³kxa² wain³txi³ wxa²hau³kot3sãn²sxã³ wã²nhũ¹nx2ta¹ju³ta² yũ²nxa³wi¹. Hai³txi³ txa²wa³ka³li³yut3sxa³wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nxe³ha²kxai³la¹ tũ̱¹ka̱³txai²li² ĩ³ye³kxi²te³nah¹lxi¹: — Yen³kxa² hãi¹nxe² yxo²kwa̱in³yah³lxi³txa³hẽ¹li¹. Kãin² yen³kxih³yah³lxin¹kxan²ti³ kãn³su² hin¹yah²lxan³so³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nxe³ha²kxai³lu¹ ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a² yen³kxih³khaix1te²a² hai³sxa² wi¹ko³xa² a̱³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nxe³nũ²la² yain³txa² kãin²sa²so¹ha²kxai³ a²ẽ¹na² e³kxi²nh²te²nah¹lxi¹: “Txa²hai³sxa² wi¹wen¹khaix1nẽn³ta²kũ². Yxãn¹ta¹ yain³txa² sa²ta̱³a¹thĩ³nũ³a² sĩ³kãi²nxa³kũ². Nxe³ha²kxai³ ĩh¹nxe³ta¹lhon³ku² nxa¹nha²kũ². ");
INSERT INTO nabNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yxãn¹ta¹ nxe² kãi³a¹tũ¹xã¹. Yain³txa² sa²ta̱³a¹thĩ³nũ³a² sa²hai¹sa²so¹na¹tũ¹xã¹. Nxa¹kxai²nãn²tu̱³ yain³txa² kãin² sa²ta̱³a¹ha²kxai³ txa²yen³kxa² yxo²ha³kxa¹ ũ³ha¹a¹ha²kxai³ nxa¹tũ¹xã¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nxa¹kxai²nãn²tu̱³ ĩ³ye³kxi²nha¹tũ¹xã¹. Nxe³nha¹te³nah¹lxi¹: ‘Txai²li² wi¹lhin¹khaix1na¹xã¹. Txa²yen³kxa² ka³lxa¹sa³xã¹. Nxe³sxã³ kwẽ³kon³ju³ta² ko³ka³lxa¹txi³ kwẽ³kon³sa³kxan²ti³ hxan³kxi²sa²nxa³lho³na¹. Nxe³sa²nxa³ha²kxai³ kãin² ĩ³yai³ni² kãin² ĩ³na² wi¹lxo³kxi²nha¹khaix1nxe² na¹tũ¹xã¹.’ ” Nxe³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nxa²ha¹te¹ Txa²wã¹sũ̱³na² ĩ³wa²lũ³xi²te³nah¹lxi¹: “Wxãi²na² ã³ne³wxe²nxa³lxi¹. Ka³nxah³tai²na² ya²lu¹nxa²tu¹wi¹. Nxãn¹kxai²nãn²tu̱³ ĩh¹te²ta̱³ wxa²yen³kxa² so¹kxi¹nxain¹te³ji¹wi¹?” Txa²wã¹sũ̱³na² nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Te²yã¹nxe³jut3su² a²nũ²ai²li² yen³kxa² wã²nxũ̱h¹ ũ³ha¹te²su² te²na² sa²kxai³lu² yxãn¹ta¹ Txa²wã¹sũ̱³na² yen³nãu³a² yen³kxi³txa²jut3sa²kxai³ nxe³jah¹la² yã¹nx2na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nxe³ha²kxai³la¹ a²sa³wi³ha³lxa² ãh¹ ĩ³ye³kxi²ti³ãn¹jau³kxai³lu¹: — Jã¹nxa¹jau³su² yain³txi³su² yain³yah³lxin¹kxe³nũ³a² hxi²waun³ta³kxi²nyhah¹lxi³txa³hẽ¹li¹. Te²yã¹nxe³sxã³ wã²la²ka³lo³ai²li² ũ³whih²kxi²nhãn¹ka³lo³nũ³ai²li² hxi²waun³ta³kxin²nha²sxã³ yxau²xai³ah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A²nxe³ju³kxai³lu² ka³te̱³na² yxau²xai³ki̱³ju³ta² sa²kxai³lu² yain³txi³su² a³lxi² wa³to²hi²te²ju²hẽ³li¹. Te²yã¹nxũn³sxã³ txa²wã¹nũ²ai²na² sa²kxai³lu² wã²la²ka³lo³su² a³lxi² wa³to²hi²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","A̱i³ka² ĩ²jah¹lxi³hẽ¹li¹. Yain³txa² ũh³wĩ̱¹xa³ha²kxai³ yain³txa² sa²so²nxa³ha²kxai³ yain³txa² sa²ta̱³thĩ³nũ³a² yũ²nxa³ha²kxai³ nxe³te²ju²hẽ³li¹. Nxe³kxan²ti³ Txa²wã¹sũ̱³na² sa²kxai³lu² a̱i³ka² a³lxi²na³li¹. Yxãn¹ta¹ wxãi²li² a³lxi² wa³to²hi² nxe³nx2ti³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nxe³ha²kxai³lu¹ ka³te̱³na² yxau²xai³lyah³lxin¹ju³ta³nũ³a² hxi²waun³ta³kxi²nyhah¹lxin¹kxan²ti³ hai³txi³ ã²la² a³lu²on³sxã³ ka³te̱³na² yxau²xai³lyah³lxi³hĩ̱²nxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yxah³lxin¹ju³ta² ha³lo²a² yu³jũx1ju³ta² hxi²kan¹txi³ kãi³yah²lxan³kxai²nãn²tu̱³ ha³lo²a² yu³tã³lxi³ju³ta² hxi²waun³jah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Te²yã¹nxe³sxã³ si³sa² yãu³sa² ha³lo²a² wen¹kxa² ĩ²jah¹lxi³hẽ¹li¹. Hai³txi³ hai³sxa³la³ wa³ko³nai¹nxa³ha²kxai³ wãn²ta³ wet1tai¹nxa³ha²kxai³ ain¹te²sxa³yu²hẽ³li¹. Sa³lo³mãu²ah³lu¹tai²na² I³sa³e² nũ̱³ka̱³txa² a²wa³kxẽn³ta² kãin²jah¹lo²su² ta¹hxai²ti³ai¹ti²tu³wi¹. Yen³kxih³khaix1nxe³ha²kxai³ wã²la² wi¹khaix1ka³lo³a² ũ³whi²kxi²nha²ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³kxan²ti³nũ¹ si³sa² yãu³sa³kxai²na² wi¹wa³to²hi²te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nxe³ha²kxai³ Txa²wã¹sũ̱³na² hi²sen³su² si³sa² yãu³sa² wi¹la³ we¹te²ju²hẽ³li¹. Nxe³te²a² hĩ¹na² wi¹la³ we¹nha²kxai³ ka³nxa³ha²ta³a² i̱³hxa³nha²kxai³ nxe³te²ju²hẽ³li¹. A²nxe³te²a² wi¹la³ we¹nhĩ¹na² wi¹lhĩ¹txu¹xai³te²ju²hẽ³li¹. A²nxe³ju³tai²li² yxo²ĩ²yah²lxan³ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jã¹nxe³ju³kxai³lu² yain³txa² yain³yah³lxin¹ju³ta³nũ³la³ ĩ³na²kxi²yah³lxin¹jau³nũ³la³ nxe² hxi²waun³txi³yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nxe³ju³tai²na² a²yxo²ha³kxa¹ Sũ̱³na² wãn³txa² yxo²ĩ²ai¹nxa³tũ̱³ka̱³txi³nãu³xai²na² yen³kxa² yxo²kwa̱in³sxã³ ãn³te³nain¹te²ju²hẽ³li¹. Nxe³yãn¹ta¹ wxãi²kxai³ ha³lo²a² ã³taut3to³jah³lxin¹kxe³su² Wxa²wĩ³na² Si³yxau³tãu³a¹ hi²sen³kxai³lu² taut3to³jah³lxin¹kxa² whãi²na¹ ĩ²jah¹lo²su² na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nxe³yah³lxi¹nha²kxai³ Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²wet1hxa³jah³lxi³sã²nhẽ³li¹. Yxah³lxin¹kxai²nãn²tu̱³ yen³kxai²na² ã³taut3to³txai³yah³lxin¹kxai²li² ũ³tet1sũ³nx2ti³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nxe³ha²kxai³la¹: — Txa²sa³wi³ha³lxi³sah¹lxi¹lxi¹. Yu̱h³lxah³lxi³txa³hẽ¹li¹. Txa²wã¹sũ̱³na² hi²sen³su² oh³xa² a²ha³lo²a² si³yxau³tãu³su² ti³hi¹txa²lxi³ju³ta² ten³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nxe³ha²kxai³ wxa²yen³kxa² sa²kxai³lu² a²nũ²a² yen³kxi³txa²te²a² wã²nhũ¹txai¹yah³lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ oh³nãu³a² so¹lxi³ Txa²wã¹sũ̱³na² ha³lo²a² so¹lxi³ wxa²yan³txi³nũ³a² a³lxi²kxi³nũ³a² so¹lxi³ ũ³ha¹jah¹lxi³hẽ¹li¹. Nxe³yah³lxin¹kxai²nãn²tu̱³ hai³txi³ kãi³kxi¹nx2tai¹nxa³ha²kxai³ hai³txi³ kho³nxa³ha²kxai³ hai³txi³ hxa³nxa³ha²kxai³ nxe³ye¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nxe³jut3su² wxa²yan³txi³nũ³a² ũ³ha¹ah³lxin¹ti³xa² so¹lxi³ wxa²ẽ¹nãu³a² nxũ¹hain³nyhah¹lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","38","Nxe³ha²kxai³lu¹ ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi¹nx2ta¹tu¹wi¹. Sxi²ha² wa³kxẽn³yah³la² sa²kxai³lu² txu¹ha² so¹ju³tan¹te² yain³txa³nũ³a² yain³te³lhxã³ a³li³nũ²nhai¹. Nxe³nũ²la² a²sa³wi³ha³lxa² whãi²na¹ wa̱³li²ju³ta² wah³nxa³kxi²nũ²nhai¹. Hã²wxãn³txa³ wa̱³li²tãu³a² ĩ³yxo²to¹tot1sĩ¹na² wa³su³txi² sa²yxo²than²kxi²nũ²nhai¹. Nxe³ha²kxai³ a²sa³wi³ha³lxai²na² ye³ten³kxe³su² wi¹lhin¹ye²nũ²nhai¹. Ka³nxah³ta² wi³ta³lon³tãu³a² ta̱³nxa² a³lan²ti³lĩ³lxi² ta̱³nxa² wa̱³li²kxai²nãn²tu̱³ ye³ten³su² wi¹lhin¹ye²nũ²nhai¹. Nxain¹kxai²nãn²tu̱³ wi¹lhin¹sxã³ wah³nxain¹ju³tan¹te²kxa³ya̱³lhu² a²wa³kxẽn³yah³la² sa²kxai³lu² yain³txa² tẽ³sxã³ kwa²ũ³hũ¹nũ²nhai¹. Te²yã¹nxe³sxã³ Txa²wã¹sũ̱³na² wxã³ju³ta² ye³ten³sxã³ wah³nxe³jah³lxi³hẽ¹li¹. Yen³kxa² hau³kot3sxã³ wxe³ti² wã²la²ka³lo³a² ũ³whi²kxi²nha² lã³pi³ãu²tẽ³na² sa²kĩx3sxã³ ũ³thũ²ka²sa²wxe² nxe³kxa²yã¹nxe³kxe³hũ̱³sxã³ hau³kot3sxã³ wah³nxe³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Te²yã¹nxe³ju³kxai³lu² ka³nxah³ti³na² so¹lxi³ yen³kxa² kãi³jah¹la² hãi³a² wxã³te²ju²hẽ³li¹. Nxe³kxi³sa²kxai³ sxi²ha² wa³kxẽn³yah³lai²na² sa²kxai³lu² yen³kxa² kãi³jah¹la² wxã³je³nãu³wa³kxa² wi¹ko̱³nha²ke³la³te²kxai³ ye³ten³sxã³ wah³nxe³hĩ̱³nx2na³li¹. A²sxih²yxo²a² ũ³kãu³txi²nxã³kxe³su² yen³kxa² tĩ¹kxi²nxa³kxe³su² nxe³hĩ̱²nxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jã¹nxe³jut3su² ye³ten³nha²kxi³hũ̱³nxe² wah³nxe³jah³lxi³hẽ¹li¹. Nxe³sxã³ wxa²ẽ¹nãn¹jau³kxai³: “Hĩ¹na² wxã²nxa³lho³na¹.” Nxĩn¹jau³su² nxe³ti³wa³kxa² wxã³na¹ha³ta²wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nxa²ha¹te¹ Pe²jah³lai²na² a²wãn³txi³kxai³lu¹: — Txa²hxi²kan¹jah¹lãi³. Jau¹xai²li² txa²nũ̱³ka̱³txi³nãu³xa² so¹lxi³ ĩ³ye³kxi²ta̱³nxa² a²nũ²a² yxo²ha³kxa¹ ĩ³ye³kxi²ta̱³nxa² nxẽn¹si²lxi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ĩ³ye³kxi²te³nah¹lxi¹: — Sxi²ha² wa³kxẽn³yah³la² a²sa³wi³sa² wi¹lhin¹te²na² so¹lxi³ ne³kheh¹te²na² so¹lxi³ a²sxi²khai³xa² ĩ³hau³kot3si¹jau³su² ũh³wxe³te²ju²hẽ³li¹. A²nxe³jah¹lai²na² sa²kxai³lu² wi¹lhi¹nha²kxai³ yain³txi³su² ũ³hũ¹xai³lain¹te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wi¹kãi³kxai²nãn²tu̱³ a²wa³kxẽn³yah³la² wxã³tãu³a² ĩ³wi¹lxon³kxi²kxai²nãn²tu̱³ wi¹lhin¹ti³hi¹tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Yen³kxa² yxo²ha³kxa¹ hau³kot3si¹jau³su² ũh³wxe³kxi²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yxãn¹ta¹ nxe²nxa³kxai²nãn²tu̱³ wã²nxũ̱h¹ e³kxi²te³nah¹lxi¹: “Txa²si³yxau³ka³txa³ wa³sut3si¹nxa³lho³na¹.” Nxe³jau³su² ha²kxai³ a²si³yxau³ka³txai²na² sa³wi³ha³lxa² in³txi³su² ta̱³nxa² txu¹su² ta̱³nxa² ĩ³wait1ãn³si³wxe³hĩ̱³nx2na³li¹. Nxe³te³na¹ kãin² ĩ³yai³ni² ĩ³na²sxã³ we¹ni² nxe³hĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nxe³tãu³a² ko̱³nha²nxa³ku¹ha² a²si³yxau³jah¹la² ĩ³xi²tu¹wi¹. Nxe³kxai²nãn²tu̱³ jah¹lai²li² ũn³txi³ ĩ³wait1sãn²ka³tu̱³ ko̱³nxe³thin¹tũ̱³kxa³txa² ha³lo²a² ũ³tĩ̱³kxa² wxe³kxai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Te²yã¹nxe³sxã³ a²sa³wi³sai²li² kwa³na³kxain¹jau³xa² ã³ne³wxe³kxai²nãn²tu̱³ yxãn¹ta¹ kwa²hãi¹nxe² wet1txa³kxai²nãn²tu̱³ nxe³te²na² sa²kxai³lu² kãin² ĩ³wai¹txai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yxãn¹ta¹ a²sa³wi³sai²li² kwa³na³kxain¹jau³xa² kũ³we²ki²la² ã³ne³wxe²nxa³kxai²nãn²tu̱³ kãin² ĩ³wai¹txai¹nxa³lho³li¹. Jã¹nxe³jut3su² yen³kxa² kãin² ũ³hũ¹ain¹kxai²nãn²tu̱³ nxe³jah¹lo²kxai³lu² wã²nhũh¹si¹ja³kxa³nũ³su² kãin² ĩ³ye³kxi²tain¹tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","— Nxa²ha²kxai³ ha³lo²a² yxo²ha³kxa¹ heh³ni³kxi³kxa²yãx1 wxã³na¹hẽ³li¹. Wa³su³txi³ ã³si³wxe³na¹txai²lã¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Te²yã¹nxe³sxã³ ĩ̱³yau³xa² ũ³hũ̱¹kxi²sa²sai¹kxi³jut3sũ̱³nxe² ya³lu²na¹ju³ta² yũ³tu¹wi¹. Nxe³na¹ju³kxai³lu² ta³lun²kxi³sxa³ta̱³lxa¹ hxi²ka̱u³ka̱u³nha²te³lxa¹nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Jã¹nxa¹ju³kxai³lu² wxã³na¹ju³tan¹te²kxa³ya̱³lhu² a²nũ²a²nãu³xa² hãu²non³sxã³ yxau²xai³nyhu¹ah³lxi³ju³ta³nũ³a² yũ²nxa³lho³li¹. Nxe³to³ta¹ he¹kxi²nyhu¹ah³lxi³ju³ta³nũ³a² yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","A²hĩn¹tãu³a² a²nũ²a² ha¹li¹ ha¹li¹ ka³na³ki¹ sxi²ha² sĩ³ka³na³ka³na³thĩ³na² a²yut3su² nyhu¹ain¹te²nãn²tu̱³ a²nũ²a² ha¹lin¹te²na² a²nũ²a² ã̱³xa² ha¹li¹ ka³na³ki¹ nxe³tũ̱³ka̱³txa² he¹kxi²nyhu¹ah³lxi³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A²wĩ³na² a²ki³lha³lxa² ã³nhe¹kxi²nyhu¹ha²kxai³ a²hã³ka³na² a²ka³ne³lxa² ã³nhe¹kxi²nyhu¹ha²kxai³ a²hã̱i³na² a²sã³nxe³lxa² he¹kxi²nyhu¹ha²kxai³ nxe³nyhu¹ain¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nxa²ha¹te¹ Je³su²jah³la²kxai³la¹ a²nũ²a²nãu³xa² ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — U³je³na² kan³tãu³a² o³sĩ̱³na² yũ³kxai²nãn²tu̱³ nxe³yah³lxin¹te³nah¹lxi¹: “Wẽ³ha²yau³xa² wxãn³tu¹wi¹.” Yxah³lxin¹jau³su² ha²kxai³ ya²la³tu̱³ wxã³ye¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te²yã¹nxe³sxã³ u³je³na² ta³nãn³nãu³a² kãin² ik3kxai²nãn²tu̱³ nxe³yah³lxin¹te³nah¹lxi¹: “A³lan²khaix1tu¹nhẽ³tu¹wi¹.” Yxah³lxin¹jau³su² ha²kxai³ ya²la³tu̱³ wxã³ye¹nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nxe³yah³lxin¹ju³kxai³lu² wi¹lhin¹ki³lxo³jah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³thin¹khai¹yxah³lxi¹lxi¹. Ha³lo²ai²la³ ta̱³nxa² o³sĩ̱³nai²la³ ta̱³nxa² ye³khe¹yah³lxi¹lxi¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² wãn³txa² ã³ne³wxe³yah²lxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Wain³txi³ o²la³kxah³lxin¹ju³ta³nũ³a² hxi²kan¹txi³ ã³ya³jah¹lxan³kxai²lẽ¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","A²nũ²a² ĩ³xa̱n³ta³kxi¹nx2ti³kxai²nãn²tu̱³ hxi²kan¹ta² si³yxau³jah¹la² ã³sa²so¹nx2ti³ha³ta²wi¹. Nxe³nx2ti³kxa²ya̱n³txi³su² wa³su³txi³ ĩ³hãu²no³nyhu¹jah³lxi³hẽ¹li¹. Yxãn¹ta¹ nxe³yah²lxan³kxai²nãn²tu̱³ a²hxi²kan¹ta² si³yxau³jah¹la²kxai³lu² sxi²ha² kan²thĩ³na² ũ³tĩ̱¹kxi²nx2ti³si¹hain¹jau³su² kwa³na³ai¹nha³ta²wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nxe³nx2tain¹kxai²nãn²tu̱³ wa³su³txi³ ã³wa²su¹kxi¹nx2ti³xa³lho³li¹. Yen³kxa² ũ³yho³hi²ta³lun²yah³lxi³sã²nĩn¹ka³tu̱³ hã²wxãn³txa³ ã³wa²su¹kxi²nx2ti³ju³ta³nũ³a² yũ³hĩ̱³nx2na³li¹. Nxe³ye¹nxa²lxa¹wi¹. Je³su²jah³la²kxai³lu² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nxa²ha¹te¹ ĩ³ye³ta³lun²nũ²la² a²nũ²a² ã³tĩ̱³sxã³ ĩ³hen³txi³te³nah¹lxi¹: — Je³su²jah³lãi³. Pi³la²jah³la² sa²kxai³lu² hxi²ki³te²la³ka³tu̱³ Ka³li³le²a² nũ̱³ka̱³txa² sun²tã¹nyhain¹nũ²hẽ³li¹. Txa²wã¹sũ̱³na² sxi²ha² kwẽn¹tai²na¹: “Yen³kxa² ũ³hũ¹na¹tũ¹xã¹.” Ai¹nhĩ¹na¹ ã³wih¹nũ²la² ã³si³hẽ²kxi²te²a² hi²sen³su² sun²tã¹nyhain¹nũ²hẽ³li¹. Nxe³ha²kxai³ ko̱³nxe³thin¹khai¹nxẽn³tai¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ain¹nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ka³li³le²a² nũ̱³ka̱³txai²li² ko̱³nxe³thin¹ wa³to²hain¹tũ̱³ka̱³txi³su² ha²kxai³ sun²tã¹ain¹thai¹li¹? ");
INSERT INTO nabNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ti³he¹nxa³wi¹. Yxãn¹ta¹ wxãi² ĩ³nxai²na² sa²kxai³lu² ĩ³ãin²ta³kxi²nha²sãn²sxã³ wxa²ko̱³nxe³thin¹yah³lxin¹ju³ta² ã³na¹la³kxi²nyhah¹lxan³kxai²nãn²tu̱³ ya²lu²nxa²lxi³ju³ta² yũ³nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jã¹nxe³ju³kxai³lu² kxã³nhxĩ¹nu¹tai²na² sxi²ha² kĩ³thĩ³na² Si³lo³e²thĩ³na² nxe³thĩ³nu¹tai²na² ã³ya³hi²ta¹hxai²ti³ai¹ti²tu³wi¹. Ã³ya³hi²hĩ¹nu¹tai²na² a²nũ²a²nãu³xa² 18 nxe³te²nãu³xu¹tai²na² ã³ya²lu¹ta²lxi³ta¹hxai²ti³ai¹ti²tu³wi¹. A²nxe³tũ̱¹ka̱³txu¹tai²na² ko̱³nxe³thin¹ wa³to²hain¹tũ̱³ka̱³txi³su² ha²kxai³ ã³ya²lu¹ta²lxi³ta¹hxai²yu²lhai¹li¹? Te²yã¹nxe³sxã³ Je³ru³sa³lẽ²thĩ³nãn¹tũ̱³ka̱³txa² wi¹lhin¹ wa³to²hain¹tũ̱³ka̱³txi³su² ta¹hxai²yu²lhai¹li¹? ");
INSERT INTO nabNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ti³he¹xai¹nxa³wi¹. Yxãn¹ta¹ wxãi²na² sa²kxai³lu² ĩ³ãin²ta³kxi²nha²sãn²sxã³ wxa²ko̱³nxe³thin¹yah³lxin¹ju³ta² ã³na¹la³kxi²nyhah¹lxan³kxai²nãn²tu̱³ ã³ya²lu¹txa²lxi³ju³ta² yũ³nx2ti³tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nxa²ha¹te¹ Je³su²jah³la²kxai³la¹ ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Hai³sxa³nãu³a² fi²ko²nẽ³ka² wi¹wen¹nũ²nhai¹. Wi¹wen¹ka³tu̱³ta¹ a²wa³kxẽn³yah³la² a²nã̱³ka² wxa²so¹te³lhxã³ wxã³nũ²nhai¹. Yxãn¹ta¹ hai³txi³ yũ³ye²nxa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yũ³ye³nxa³nũ²la² a²sa³wi³sa² ĩ³kaix1so¹te³nah¹lxi¹: “Ye³ha¹li¹ ka³na³ki¹ kwẽ³kon³tãu³a² fi²ko²nã̱³ka² wxa²so¹te³lhxã³ wxã³na¹ta¹ hai³txi³ ĩ²tuh³nxa³hẽ¹li¹. Nxe²nxa³ha²kxai³ tau³kxi²lũ³ã¹txa²hẽ³li¹. Hai³sxa² a³lxi²sa³nhai¹. Ki³lã̱³lxi²ki³a² ũh³wĩ̱¹a¹tu¹wi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nxa²ha¹te¹ a²sa³wi³sa² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: “Hãi¹nxe²wxe³sã²nhẽ³li¹. Ye³ka³na³ka³nat3sxã³ kwẽ³kxa² wahx3nxe³sxã³ ĩ²ya³sa²sã²nhẽ³li¹. Nxe³ki̱³kxai²nãn²tu̱³ kĩ̱h³nxa² ũ³kxẽ³ni²sxã³ wxa²si³sa²ta³kxi²na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hã²wxãn³txa³ nã̱³kxi²kxai²nãn²tu̱³ wi¹tu¹wi¹. Ta¹ nã̱³kxi²hxa³kxai²nãn²tu̱³ nxe³hĩ¹na²sa² tau³kxi²lũ³ã¹a¹tu¹wi¹.” Ain¹nũ²nhai¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nxe³nũ²la² hã²wxãn³txa³ sa²ba³to³ nxe³tãu³a² Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³wih¹nũ²la² Txa²wã¹sũ̱³na² wãn³txa² ĩ³yau¹ũ³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ĩ³yau¹ũ³tãu³a² txu¹ha² ĩ³ton³ta¹ka³lxu³su² ta¹hxai²hẽ¹la². A²nxe³ta¹ka³lxai²li² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³yxau³ha²kxai³ hxi²kan¹txi³ ĩ³sin²kxi²nha²sxã³ ai³ta¹hxai²nxa³hẽ¹la². Hãi¹sxã³ ku²thu²kxa² ai³ta¹hxai²hẽ¹la². Kwẽ³kxa² ye³ka³lxa¹txi³ kwẽ³kon³sxã³ 18 nxe² kwẽ³kon³tãu³a² sxa²xai³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nxa²ha¹te¹ Je³su²jah³la²kxai³la¹ ĩ²kxi²nũ²la² ĩ³kaix1so¹te³nah¹lxi¹: — Ĩ²sã³ni¹. Hĩ¹na² wxa²xĩ³ta³ka³txa² ã³wa²su¹txa²ha¹xĩ¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nxe²e³ta³lun²nũ²la² txu¹hai²na² wxa²ta³lo³wxa̱i³nũ²la² we²txi²ta¹hxai²hẽ¹la². We²txi¹nxa²ha¹te¹ wa³su³txi³ ĩ³sin²kxi²nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wi¹lhin¹khai¹nx2na³li¹. Nũ̱³kxũn³khaix1nx2na³li¹. Wi¹lxo³kxi²sa³nhai¹. Txu¹ha²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nxe³ju³tai²na² thĩ¹na² wa³kxẽn³yah³la² ĩ²ta¹hxai²hẽ¹la². Ĩ²nxa²ha¹te¹ kãin² hi̱t3te³nah¹lxi¹: — Ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ a³lan²tãu³a² so¹lxi³ wa³ka³li³yu³ta² o²la³kxi²ki̱³te²jai¹ti³tu³wi¹. Nxe³kxi³sa²kxai³ sa²ba³to³ nxe³tãu³a² Ju³te²a² nũ̱³ka̱³txa² wa³kon³ki̱³te²sxa³yu²hẽ³li¹. Ki̱³sxa³ha²kxai³ sa²ba³to³ nxe³hĩ¹na² we²txi²sih¹nxa²lxi³jau³su² wxã³yah³lxi³txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Wi¹lhin¹ki³lxo³jah³lxi¹lxi¹. Yxãn¹ta¹ ko̱³nxe³thin¹yah³lxi¹lxi¹. Wxa²pon¹su² ta̱³nxa² wxa²ka³va¹lhu² ta̱³nxa² yũ³yah³lxin¹kxa² sa²ta²la³kxi²so¹sxã³ ka³wã³lxa² tẽ³sxã³ ã³nxai³ka³tu̱³ ũ³tih¹yah³lxi³hxai¹nhẽ³li¹, sa²ba³to³ nxe³kxan²ti³nũ¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Te²yã¹nxe³ju³kxai³lu² ta¹ka³lxa² A³bra³ãu²ah³lo²nu¹tai²na² a²sa³wi³sa³ka³lxu³su² na³li¹. Nxe³yãn¹ta¹ Sa³ta³na²jah¹la² hi²sen³su² kwẽ³kxa² ko³ka³lxa¹txi³ 18 nxe² kwẽ³kon³tãu³a² kan²ta³kxin²tai¹. Nxe³ha²kxai³ we²txai¹na¹ju³ta² wain³na³li¹, sa²ba³to³ nxe³kxan²ti³nũ¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nxa²ha¹te¹ jau¹xai²na² ain³kxi²nũ²la² hi̱t3txain¹tũ̱³ka̱³txai²na² ãu²lxa²to³nain¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ tũ̱¹ka̱³txai²na² ĩ³hi²txain¹nũ̱³ka̱³txai²na² sa²kxai³lu² Je³su²jah³lai²na² o²la³kxi²ju³ta² ĩ²ai¹nha²kxai³ ĩ³ka³lih³kxi²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nxa²ha¹te¹ Je³su²jah³la²kxai³la¹ ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wãn³txa² ĩ³yau¹ũ³nx2ta¹jau³xa² yã¹te²ta³ yãx1hĩ̱³te²la¹xã³? Nxe³jau³jau¹xai²na² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mos³tar²ta²ki³a² yã¹nx2na³li¹. Nxe³ki³ai²na² tẽ³sxã³ ũh³wĩ̱¹nũ²la² wi¹wen¹te²ju²hẽ³li¹. Hã²wxãn³txa³ hi³a² kĩn³ka³txa² we¹nha²kxai³ a̱i³ka² a²ye³sa² ã³nhẽ¹ti³te²ju²hẽ³li¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","— Nxe³ha²kxai³la¹ Txa²wãn³txa² ĩ³yau¹ũ³nx2ta¹jau³xa² yã¹te²ta³ yãx1hĩ̱³te²la¹xã³? Nxe³jau³jau¹xai²na² ĩ³yau¹ũ³nx2ta¹tu¹wi¹. Ain³kxi²sah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yain³txa² ũ³wha¹tũ̱³xa² yã¹nx2na³li¹. Nxe³tũ̱³xa² txu¹hai²li² tẽ³sxã³ tri²ka²nũ̱³xa² ye³ha¹li¹ ka³na³ki¹ ũ³hau³kot3sxã³ ũ³kwa³lxĩ¹te²ju²hẽ³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² tũ̱¹xai²na² yxo²ha³kxa¹ kãin² ĩ³wa¹je²te²ju²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ĩ³ye³kxi²ta³lun²nũ²la² Je³ru³sa³lẽ²thĩ³nãn¹tĩh³na² ai³ta¹hxai²hẽ¹la². Txa²wã¹sũ̱³na² wãn³txa² ĩ³yau¹ũ³si¹ja³kxa³nxũ³su² sxi²je³na² yxo²ha³kxa¹ ã³nxai³lha²the³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nxe²xai³ain¹tãu³a² in³txa² ã³tĩ̱³sxã³ ĩ³wã̱³txi³te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Txa²wã¹sũ̱³na² wãn³txa² ĩ³hi²txain¹tũ̱³ka̱³txi³nũ³a² ka³lxa²ai¹nxa³ji¹wi¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Txa²wã¹sũ̱³na² ha³lo²a² ã³wih¹ki̱³ju³ta³nũ³a² kan²na³li¹. Ĩ²li³ju³ta² kãi³sxã³ ã³wih¹ki̱³te²sxa³yu²hẽ³li¹. A²nũ²a² ka³lxa¹khaix1nxe³te²nãu³xa² ã³wih¹ti³te³nain¹ta¹ wain³txi³ ã³te³nai¹nxa³ha²kxai³ ã³wi¹hai¹nxa³lho³li¹. Sxih²yxo²a² kãi²nxa³te²yxo²hũ̱³nxe² Sũ̱³na² wãn³txa² yxo²ĩ²te²na² so¹lxi³ ã³wih¹te²ju²hẽ³li¹. Nxe³kxe³su² ha²kxai³ nxũ²kwa̱i³lxũ¹sxã³ sxih²yxo²a² kãi²nxa³te²yxo²a² ã³wih¹kxe³hũ̱³nxe² Sũ̱³na² wãn³txa² yxo²ĩ²sxã³ yxau²xai³jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te²yã¹nxe³sxã³ sxi²ha² wa³kxẽn³yah³la² ĩ³sa²yxau³sxã³ sxih²yxo²a² ũh³yxo²wĩ̱¹tu¹wi¹. Nxe³kxai²nãn²tu̱³ ti²ta³lo³kan¹tũ̱³ka̱³txa² ĩ³kaix1sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: “Txa²hxi²kan¹jah¹lãi³. Sa²yxo²than²txa²sĩ¹nhẽ³le¹.” Nxe³nũ²la² sxi²hẽ¹nãn¹jah¹lai²na² wãn³txi³kxai³lu¹: “Ĩh¹nhu¹nãn¹te²ta̱n³yah³lxin¹ji¹wi¹?” ");
INSERT INTO nabNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nxa²ha¹te¹ ĩ³wa²lũ³xain¹ti³an¹jau³kxai³lu¹: “Txa²sxi²je³nai²na² ĩ³tih³nxe³nĩn¹tai¹tu³we¹. Ĩ³yai³ni² ĩ³na² nxe³ki̱³tai¹tu³we¹.” Nxe³ain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nxe³ha²kxai³lu¹: “Wxãi²nãu³ ĩ³nxai²na² ĩ²nx2ti³te²txã³wi¹. Ã³sxã³ ã³waix3jah¹lxi³hẽ¹li¹. Ko̱³nxe³thin¹sxã³ kãi³sxã³ yxau²xai³lyah³lxi¹lxi¹.” Nxa¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","A³bra³ãu²ah³lu¹tai²na² I³sa²kah³lu¹tai²na² Ja³ko²ah³lu¹tai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² a²yxo²ha³kxa¹ Txa²wã¹sũ̱³na² ha³lo²a² oh³xan¹ko³nãu³an²ta³ yxau²xai³ti³hi¹je²tain¹tu¹wi¹. Yxãn¹ta¹ wxãi²na² sa²kxai³lu² ha³lo²a² sa²tã³nx2ti³tu¹wi¹. Nxe³nx2ti³kxe³su² ye³khãuh³lxa³thi¹nx2ti³ju³tan¹te²kxa³ya̱³lhu² kãin² nã̱³ni² kãin² wxi²ka³ta³ta³ti² nxe³sa²tẽ³yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nxe³kxa²yon³kxai³lu² u³je³na² a³li³xi²tãu³su² tãu³a² u³je³na² kan³tãu³su² tãu³a² u³je³na² ta³nãn³nãu³su² tãu³a² a²nũ²a² ka³la¹txi³ Txa²wã¹sũ̱³na² ha³lo²a² oh³xan¹ko³nãu³an²ta³ ã³nũt1tain¹tu¹wi¹. Nxe³hĩ¹na² ã³wxe³sxã³ yain³kxih²nyhain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jã¹nxe³hĩ¹na¹ a²nũ²a² ã³ne³ki³so³te²na² sa²kxai³lu² ka³na³ki²nũ² ne³ka²ta¹xai³si¹ha²kxai³ a²nũ²a² ne³ka³ta² ãn³si³wxe³te²na² sa²kxai³lu² ka³na³ki²nũ² ã³ne³ki³sot3si¹ha²kxai³ nxe³ain¹tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Fa³ri³se²a² nũ̱³ka̱³txa² a²hãi¹nxe³hĩ¹na² ã³wxã³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — A³li³txu¹li¹. E³ro²jah³la² su²lhã³nxa²te³lhxã³ nxe³ain¹na³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Jah¹lai²na² wai³a³lxa²ta³lã²tẽ¹nhũ̱³na³li¹. Wain³txi³ ĩ³ye³ai¹nxa³wi¹. Nxe²nxa³ha²kxai³ ĩ³wa²lũ³xi²tain¹yah³lxi³hẽ¹li¹. Nxe³yah³lxin¹te³nah¹lxi¹: “Hĩ¹na² ko̱³nxe³te²a² yãu³ka³txa² nxũ²kwa̱i³li³si¹hai¹na¹ha²kxai³ ĩ³ta³ka³txa² we²txai¹na¹ha²kxai³ nxa¹tu¹wi¹. Hĩ¹na² o²la³kxi² ka³nxa³ha²ta² o²la³kxi² nxe³sxã³ ka³nxa³ha²ta³nũn³tãu³a² ta³lun²na¹tu¹wi¹.” E³ro²jah³la² nxe³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","A²nxe³na¹kxan²ta² hĩ¹na² ã³nxai³li² ka³nxa³ha²ta² ã³nxai³li² te²yã¹nxũn³tãu³a² ã³nxai³li² nxe³na¹tu¹wi¹. Nxe³na¹te²kxai³lu² Je³ru³sa³lẽ²thĩ³na² so¹lxi³ Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txa² su²lhã³ain¹tai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nxe³ha²kxai³la¹ Je³ru³sa³lẽ²thĩ³na² yxau²xai³yah³lxin¹te² ĩ³nxai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txa² su²lhã³ain¹yah³lxi³to³hi¹nha²kxai³ wxa²nũ¹nx2tain¹tũ̱³ka̱³txai²na² wha³tin³kxain¹yah³lxi¹nha²kxai³ nxe³sxã³ ko̱³nxe³to̱n³khaix1yah³lxi¹lxi¹. Yah³lxi¹nha²kxai³ ka³la³ka³la²a² a²hã³ka³nai²na² wẽ³ha³lxa² a²nxe̱³ki³yu̱³hẽ³nãu³a² wã²nut1te³ju²hẽ³li¹. Jãx1te²hũ̱³na¹tũ¹xã¹. Wxa²wẽ³ha³lxa² nxe³nx2ti³to³ha¹tai¹ti²tu³wi¹. Ye³ka³lxa¹txi³nx2ti³to³ha¹tai¹ti²tu³wi¹. Yxãn¹ta¹ ten³yah²lxan³tai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nxe³ha²kxai³ nxe³hĩ¹nãn¹te²tu̱³ wxa²sxi²ha² a²nũ²a² yũ²ai¹nx3tho³li¹. Ya²la³tu̱³ wãn³txan²tu̱³ ĩ³ye³a¹wi¹. Hĩ¹nãn¹te²tu̱³ ĩ²xi²sah²lxan³tho³li¹. Kxãn³nãu³a² wxa²wãn³txi³nũ³su² ĩ³ye³kxah²lxin¹te³nah¹lxi¹: “A²nũ²ai²na² Txa²wã¹sũ̱³na² sa²si¹hã³nẽ³jah¹la² wi¹lhin¹jah¹lo²su² na³li¹.” Yah³lxin¹jau³nũ³su² yah³lxi³sã²nĩn¹ka³tu̱³ hã²wxãn³txa³ ĩ²xi²sah¹lxin¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Hã²wxãn³txa³ sa²ba³to³ nxe³hĩ¹na² fa³ri³se²a² kãin²jah¹lai²na² sa²kxai³lu² a²sxi²ha² yain³ya³si¹jau³su² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Nxe³nũ²la² sxi²ha² ã³wi¹yha³ta¹hxai²hẽ¹la². Ã³wi¹yha³te³na¹ a̱n³txi³tũ̱³ka̱³txa² hãi³a² ĩ²yxau³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nxe³ka³tu̱³ta¹ ĩ³ton³jah¹la² ã³tĩ̱³xain¹ta¹hxai²hẽ¹la². A²nxe³jah¹lai²na² sa²kxai³lu² a²nũ²nãu³a² whãi²na¹ wan¹sxã³ ĩ³ton³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nxa²ha¹te¹ Je³su²jah³la²kxai³ ĩ²kxi²nũ²la² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txi³su² te²a² fa³ri³se²a² nũ̱³ka̱³txi³su² te²a² ĩ³wã̱³txi²te³nah¹lxi¹: — Sa²ba³to³ nxe³ti³xa² a²nũ²a² ĩ³ton³te²su² te²a² we²txi²kxai²nãn²tu̱³ wain³te²lã¹xã³? Moi³se²ah³lu¹tai²na² wãn³txu¹txai²na² ĩh¹nxe³te²tũ²lhai¹na²? Nxe³jau³jau¹xai²na² wi¹ko̱³nyhah¹lxin¹ta²lu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yxãn¹ta¹ ĩ³wa²lũ³xain¹ta¹hxai²nxa³hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² hi²sen³kxai³lu² ĩ³ton³jah¹la² we²txi²sãn²nũ²la² ih³xi²si¹jau¹su² sa²si¹hã³xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nxe³ha²kxai³la¹ ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²a³sah¹lxi³wxi¹. Wxa²wẽ³sa² ta̱³nxa² wxa²po¹na² ta̱³nxa² nxe³te²a² kxĩh³nũ³xẽ¹na² ĩ̱³yau³xẽ¹na² ã³nãu²ke³la³te²kxai³ ĩ²kxai¹nhĩ¹na¹ wa³su³txi³ sa²sai¹xi²hĩ̱³nxãn¹ji¹, sa²ba³to³ nxe³kxan²ti³nũ¹? Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nxa²ha¹te¹ hxi²kan¹txi³ ĩ³wa²lũ³xain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nxa²ha¹te¹ a²nũ²a²nãu³xa² yain³te³lhxã³ nũ¹nain¹te²nãu³xa² sa²kxai³lu² a²si³yxau³ka³txai²na² ã³wxe³ka³lo³a² so¹lxi³ te³nain¹ta¹hxai²hẽ¹la². Nxe³jut3su² ĩ²nũ²la² Je³su²jah³la²kxai³lu² wãn³txa² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ĩ³ye³kxi²te³nah¹lxi¹: — In³txa² sa³nxe³la³kon³te³lhxã³ ã³nũ²kxi²sxã³ yain³yah³lxin¹kxai²nãn²tu̱³ a²si³yxau³ka³txa³ he³la³kai²na² ã³wxe³ka³lo³a² wxe³ah³lxi³txa³hẽ¹li¹, a²nũ²a² hxi²kan¹sxã³ wa³to²hi²te²a² ĩ³kaix1ju³tan¹te²kxa³ya̱n³tu̱³ wxã³kxa²ya̱n³txi³sa³. ");
INSERT INTO nabNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wxã³kxai²nãn²tu̱³ sxi²ha² wa³kxẽn³yah³la²kxai³lu² wxãi²li² jah¹la² ha¹li¹ ĩ³kaix1so¹nx2ti³jah¹lo²kxai³lu² ĩ³ye³kxi¹nx2ti³tu¹wi¹. Ĩ³ye³kxi¹nx2ti³te³nah¹lxi¹: “Jah¹lai²na² yxau³ka³lo³ai²na² ã³wxe¹lxi¹. Ĩ³sa²yxau³txu¹li¹. Jah¹lai²li² kãin² wa³to²hi²na³li¹. Nxe³ha²kxai³ ju¹xa¹ ã³wxe³txu¹li¹.” Nxe³ain¹jau³su² ha²kxai³ kwa² ã³wxe³ka³lo³a² ãu²la²to³nha²ha²kxai³ ã³wxen¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nxe³yãn¹ta¹ ã³wih¹xi¹nhĩ¹na² kwa² ã³wxe³ka³lo³a² yxau³sẽ¹li¹. Nĩn¹kxai²nãn²tu̱³ kãin²jah³la² wxã²nxa³kxai²nãn²tu̱³ nxe²ĩ³ye³kxi²nxain¹te³nah¹lxi¹: Ya²ha³wi¹. Ti¹a² ã³wxe³ka³lo³a² wi¹ka³lo³a² yxaut3txu¹li¹. Nxe³nxa²kxai²nãn²tu̱³ wxã³ain¹tũ̱³ka̱³txa² a²yxo²ha³kxa¹ wi¹le³kxi²nxain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nxe³ju³kxai³lu² wxãi²nãn²ta³ ĩ²li³te² ĩ³nxãn²ta³ wi¹le³kxi¹nx2tain¹ju³ta³nũ³a² ten³yah³lxin¹kxai²nãn²tu̱³ a²yu³hẽ³nãu³a² yxau³nha¹jah³lxi³hẽ¹li¹. Te²yã¹nxe³sxã³ a²yu³hẽ³nãu³a² yxau³nyhah¹lxin¹kxai²nãn²tu̱³ ĩ³kãi²non³si¹nx2ti³tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nxe³ha²kxai³lu¹ sxi²ha² wa³kxẽn³yah³lai²na² ĩ³ye³kxi²jau³su² nxe³te³nah¹lxi¹: — Nxex3sa²lxi¹. A²nũ²a² ĩ³yain³kxi²te³lhxã³ ĩ³kaix1so¹ai¹nĩn¹kxai²nãn²tu̱³ wxa²ya̱³lxi²nũ̱³ka̱³txi³su² ta̱³nxa² wxa²lon³txi³tãu³su² ta̱³nxa² a²nũ²a² yen³kxih³te²su² ta̱³nxa² nxe³te²na² so¹lxi³ ĩ³kaix1so¹ain¹txa³hẽ¹li¹. Tah¹ nĩn¹kxai²nãn²tu̱³ ĩ³wa²lũ³xi²sxã³ ĩ³kaix1so¹nx2ti³nhyu¹tu¹wi¹. Nxain¹kxe³su² ũ³yho³hi²nxai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yxãn¹ta¹ a²nũ²a² yen³kxi³txa²te²a² a²ha³lxu²ha² ai³te²a² yu³kan²ta³kxi²te²a² ye³han³te²a² nxe³te² he³la³kxi³nãu³xa² ĩ³yain³te³lhxã³ si¹hin¹jau³su² ĩ³kaix1so¹txain¹nũ³nhẽ¹li¹. Nxain¹kxe³su² nxĩn¹tãu³a² hxi²kan¹txi³ ĩ³wa²lũ³xi²sxã³ ũ³yho³hi²nxai¹nhĩ̱³nx2nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nxĩn¹kxai²nãn²tu̱³ hxi²kan¹txi³ ũ³yhoh³xi²nxai¹nxa³ha²kxai³ kxãn³ton³tãu³a² a²nũ²a² wi¹lhin¹te²a² yxo²ha³kxa¹ ya³lu²sãn²ki̱³ka³tu̱³ hã²wxãn³txa³ ka³te̱n³su² ĩ³sa²yxau³xi²ki̱³tãu³a² Txa²wã¹sũ̱³na² hxi²ka² ũ³yho³hi¹nx2ti³tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nxa²ha¹te¹ in³txa² yain³kxi²te²nãu³su² jah¹la² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jut3su² tãu³a² wxã³tu¹wi¹. Nxe³tãu³a² Txa²wã¹sũ̱³na² ã³wxe³sxã³ yain³ka³lo³nũ³a² ã³wxe³te²a² wi¹lhin¹jah¹lo²su² tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wain³na³li¹. Ã³wih¹sxã³ ã³wxe³te²la³ ke³la³ti¹. Nxe³ju³tai²li² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi¹nxa²ha¹tu¹wi¹. Nxe³te³nah¹lxi¹, ha³lo²a² wa³kxẽn³yah³la² yain³txa² kãin² we¹tũ²nhai¹. A²ya̱³lxi³nũ̱³ka̱³txa² ĩ³yain³si¹hain¹jau³su² ĩ³kaix1so¹ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yain³ti²wa²kxa²wxe³hĩ¹na¹ a²sa³wi³sa²kxai³lu² sa³wi³ha³lxi³nãu³xa² wxã³si¹hain¹jau³su² ũ³sa²si¹hã³nũ²nhai¹. Ũ³sa²si¹hã³te³nah¹lxi¹: “Yã³hit1jah³lhu¹li¹. Yain³txa² we¹ta³lun²na¹li¹.” Ain¹jau³su² ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nxa²ha¹te¹ hxi²kan¹txi³ wxã³ai¹nxa³nhai¹. A²yxo²ha³kxa¹ ĩ³ki³han³sxã³ e³ain¹nũ²nhai¹. A²wi¹lhĩ¹nãn¹te²a² nxe³te³nah¹lxi¹: “Hai³sxa² kwẽn¹ta² so¹kxai¹na¹ha²kxai³ ĩ²te³lhxã³ nxa¹nhai¹. Nxe³na¹ha²kxai³ hxi²kan¹sa²nxa³nhai¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ã̱³su² te²a² nxe³te³nah¹lxi¹: “Po¹na² ha¹li¹ ha¹li¹ ha¹li¹ ha¹li¹ ha¹li¹ nxe³sxã³ kwẽn¹ta² so¹kxai¹na¹hẽ³li¹. Wi¹la³ tẽ³sxã³ ã³nxai³nha¹. Nxe³na¹tu¹wi¹. Nxe³ha²kxai³ hxi²kan¹sa²nxa³nhai¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ã̱³sa²nũn³te²a² nxe³te³nah¹lxi¹: “Kwẽn¹tai²na¹ txu¹ha² so¹na¹wi¹. Nxe³ha²kxai³ hxi²kan¹txi³ wxã³nxa³nhai¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nxa²ha¹te¹ a²sa³wi³sa²kxai³lu² jau³jau¹xai²na² ain³kxi²sãn²nũ²la² ĩ³xi²nũ²nhai¹. Ĩ³xi²nũ²la² a²wa³kxẽn³yah³la² ĩ³hen³txi³nũ²nhai¹. Nxa²ha¹te¹ a²wa³kxẽn³yah³la²kxai³ ĩ³a̱n³txi³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Sxi²je³na² ã³wa̱³li¹sẽ¹li¹. Nĩn¹kxai²nãn²tu̱³ yen³kxi³txa²te²a² sa²so¹nha²kxai³ yu³kan²ta³kxi²te²a² sa²so¹nha²kxai³ ye³han³te²a² sa²so¹nha²kxai³ a²ha³lxu²ha² ai³te²a² sa²so¹nha²kxai³ nxe³sẽ¹li¹. Wa³su³txi³ ai³txu¹li¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ye³jen¹nãu³a² a²sa³wi³sa² ĩ³xi²tãu³a² ĩ³ye³kxi²xi²te³nah¹lxi¹: “Txa²hxi²kan¹jah¹lãi³. Wxa²wãn³txa² ĩ³ye³kxi²san¹jau³xin³na² a²yxo²ha³kxa¹ we¹ta³lu²na¹li¹. Yxãn¹ta¹ wxa²sxi²ha² hai³txi³ ne³kxih³xa³wi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nxa²ha¹te¹ a²wa³kxẽn³yah³lai²na² wãn³txi³kxai³lu¹: “Ha³lo²a²nãu³a² ai³txu¹li¹. Ain¹ka³tu̱³ a²nũ²a² ĩ²li³te²na² ĩ³ye³kxai¹nĩ¹nha²kxai³ sa²so¹ai¹nĩ¹nha²kxai³ nxe³sẽ¹li¹. Txa²sxi²ha² ã³ne³kih¹hain¹ju³ta² ten³sa³nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yxãn¹ta¹ a²wi¹lhĩ¹na² ĩ³kaix1txai¹na¹tu̱³ka̱³txa² wxã³ai¹nxa³lho³li¹. Txa²yain³txi³su² ĩ³wah³kã³nxe³kxi²sai²nxa³lho³li¹.” Ain¹nũ²nhai¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nxe²e³ta³lun²nũ²la² a³li³sxã³ ã³nxai³ta¹hxai²hẽ¹la². Nxe³nũ²la² a²nũ²a² ka³lxa¹khaix1nxe³tũ̱³ka̱³txa² ĩ³hi¹txai¹nha²kxai³ ã³yi¹ka³tu̱³ ã³yxo²o³tũ¹xi²sxã³ ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. A²nũ²a² ã³si³tẽ³kxi²sa²ti³te³nain¹kxai²nãn²tu̱³ kwa²ã³si³tẽ³kxi²sain¹ju³ta² yũ²nxa³lho³li¹. Yxãn¹ta¹ ya²la³tu̱³tain¹kxai²nãn²tu̱³ a²wĩ³na² a²hã³ka³na² a²sxe³xa² a²wẽ³ha³lxa² a²lon³ti³tãu³xa² a²ha³lĩn³ti³tãu³xa² nxain¹sxã³ a³lxi²nyhai¹nhxai²na²hẽ³li¹. Nyhain¹kxan²ti³ txai²na² a³lxi² wa³to²hi²sain¹ju³ta² so¹lxi³ wain³na³li¹. Nxe³kxai²nãn²tu̱³ te²na² so¹lxi³ txa²sa³wit3su² tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te²yã¹nxe³sxã³ ĩ³hit1sah²lxin¹kxai²nãn²tu̱³ ĩ³ye³khãuh³lxa³thi¹txa²lxain¹ju³ta³nũ³su² ta̱³nxa² ĩ³ya²lu¹txa²lxain¹ju³ta³nũ³su² ta̱³nxa² nxe³nxa²lxain¹ju³ta³nũ³su² yu̱h³lxah³lxin¹ju³tan¹te²kxa³ya̱³lhu² txa²wãn³txa² sa²yxo²ã³sah¹lxin¹kxai²nãn²tu̱³ hxi²kan¹txi³ txa²sa³wit3sa²yah²lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Te²yã¹nxe³ju³kxai³lu² a²nũ²ai²li² sxi²ha² kĩn³thĩ³na² txon³te³lhxã³ ain¹kxai²nãn²tu̱³ ã³si³wxe²nxa³ta̱³lxa¹ ũ³yho³hi²txã³nxa² hau³kot3sã²nhĩ̱³nx2na³li¹. Hã²wxãn³txa³ sxi²ha² kãin²thĩn³su² ta̱³nxa² kãi²nxa³thĩn³su² ta̱³nxa² hxi²ka¹nain¹thĩn³ta³ txo³nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hau³ko³txa³ke³la³te²kxai³ sxi²ha² txon³ã³si³wxe³hĩ¹na¹ hxi²kan¹txi³ ta³lu²nhĩ̱³nx2nxa³wi¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² ĩ³wã³ka³si³xai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nxe³ain¹te³nah¹lxi¹: “Jah¹lai²li² sxi²ha² txon³ã³si³wxe³kxan²ta¹. Hxi²kan¹txi³ ta³lun²ye²nxa³wi¹. Hxi²kan¹ye²nxãn³ta²wi¹.” Nxe³ai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Te²yã¹nxe³jut3su² ha³lo²a² a²si³yxau³kax3jah³la² sĩ³nã̱³xãn¹jah¹la² su²nhyu¹te³lhxã³ wxã³hĩ̱³nx2na³li¹. Wxã³kxai²nãn²tu̱³ ha³lo²a² wxa²hau³kot3sã²nhĩ̱³nx2na³li¹. In³txi³nãu³xa² ka³lxa¹txi³ 10.000 nxe³tũ̱³ka̱³txa² tẽ³kxai²nãn²tu̱³ ã̱³xa² 20.000 nxe³tũ̱³ka̱³txa² hxi²kan¹txi³ ã³wã³lxĩ³nyhe²nyhain¹kxai²nãn²tu̱³ a³li³sxã³ ne³khau²nyhai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yxãn¹ta¹ hxi²kan¹txi³ ã³wa³lxĩ³nyhe²nyhai¹nxa³kxai²nãn²tu̱³ a²sa³wi³ha³lxa² hãu²not3si¹hain¹jau³su² ũ³sa²si¹hã³ũ¹nyhai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te²yã¹nxe³jut3su² wxa²yen³kxa² a³lxah³lxin¹kxai²nãn²tu̱³ hxi²kan¹txi³ sa³wi³ha³lxin³nxa²lxi³nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Te²yã¹nxe³ju³kxai³la¹ sah²ne³ki³su² tẽ³ki̱³kxai²nãn²tu̱³ yain³txa² ũ³sa²wi²si²ki̱³kxai²nãn²tu̱³ wi¹yain³kxi²ki̱³te²ju²hẽ³li¹. Yxãn¹ta¹ a²kah³ju³ta² sũ¹nxe³kxi²kxai²nãn²tu̱³ hxi²kan¹txi³ ãh¹lxi³sxã³ ã³kah³nxe³xi²te²sxa³yu²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A²nxe³ki³ai²na² tẽ³ki̱³kxai²nãn²tu̱³ hai³sxa²nãu³a² ã³na¹xai³ki̱³kxa²ha³ta̱³nxãn²txi³ hai³txi³ wi¹la³ wen¹si¹te²sxa³yu²hẽ³li¹. Nxe³to³ta¹ hãi¹nxe³sxã³ ha³lo²a² sa²yxu¹kxã³ki̱³te²ju²hẽ³li¹. Nxe³na¹jau³su² ya²la³tu̱³ wi¹ko̱³nyhah¹lxi³ti³ten³nxa²lxin¹kxai²nãn²tu̱³ wi¹lain³kxi¹sah¹lxi³hẽ¹li¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ain¹nxa²ha¹te¹ a²nũ²a²nãu³xa² Je³su²jah³lai²na² wãn²txa² ain³kxi²te³lhxã³ ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². A²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³tũ̱³ka̱³txi³su² te²a² ã³tĩ̱³i² ko̱³nxe³ju³ta² kãi³te²su² te²a² ã³tĩ̱³i² nxe³tũ̱³ka̱³txa² ka³lxa¹sxã³ ã³tĩ̱³xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ain¹nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² ã³nhai¹tũ³te²nãu³xai²na² yxa̱ih¹tẽ³txi³ ĩ³ye³kxi² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² ã³nhai¹tũ³te²nãu³xai²na² yxa̱ih¹tẽ³txi³ ĩ³ye³kxi² nyhain¹ta¹hxai²hẽ¹la². Ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Jah¹lai²li² a²nũ²a² ko̱³nxe³ju³ta² kãi³te²a² ĩ³yain³kxi²te³lhxã³ ã³si³tẽ³kxain¹na³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ain¹nxa²ha¹te¹ Je³su²jah³la²kxai³lu² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nxe³te³nah¹lxi¹: — Ne³ka²kxi²sah¹lxi³sã²lxi¹. A²nũ²ai²na² o³ve²a² ka³lxa¹txi³ 100 nxe³tũ̱³ka̱³txa² a²wa³kxẽn³yah³lo²su² nũ²nhai¹. A²nxe³jah¹la² wi¹lhau³ko³tain¹tãu³a² o³ve²a² ka³na³ka³nat3sxã³ ha³lo²a² ih³sa³tĩ¹kxain¹nũ²nhai¹. Nxe³ai¹nha²kxai³ o³ve²a² a²ka³lxa¹te²nãu³xa² ha³lo²a² ã³nũ²la² ih³sa³tĩ¹te²a² ã³ten³nũ²nhai¹. Nxe³sxã³ ã³te³nxi² ã³te³nxi² ain¹ka³tu̱³ ĩ²sxã³ at3txi²nũ²la² sa²so¹xi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sa²so¹xi²te³na¹ sa²tã³ka³la³hẽ¹nha²nũ²la² ka³lih³kxi²la²nha² ĩ³xi²nũ²nhai¹. Ĩ³xi²ka³tu̱³ a²ka³lxa¹txa² sa²tã³nũ²kxi²xain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ĩ³xi²ka³tu̱³ta¹ a²ya̱³la²nũ̱³ka̱³txa² ĩ³kaix1te³nah¹lxi¹: “Nxex3jah³lxi³wxi¹. O³ve²a² ih³sa³tĩ¹kxi²sa²kxai³tã² so¹xi²na¹li¹. Nxe³na¹ha²kxai³ ka³lih³khaix1sa³nhai¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² ĩ³ka³li³ha³sah¹lxi³wxi¹.” Nxe³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Te²yã¹nxe³kxe³hũ̱³nxe² a²nũ²a² nũ̱³ka̱³txa² ka³lxa¹tũ̱³ka̱³txa² 99 nxe³tũ̱³ka̱³txa² wi¹lhin¹sxã³ yxau³ain¹nũ²nhai¹. Nxe³te²nãu³ãn²tu̱³ Txa²wã¹sũ̱³na² nũ̱³ka̱³txa² oh³xan¹tũ̱³ka̱³txa² ka³li³hain¹tu¹wi¹. Yxãn¹ta¹ a²nũ²a² ko̱³nxe³thin¹te²a² ka³na³ka³nat3sxã³ ĩ³ãin²ta³kxi²nha²sxã³ a²ko̱³nxe³ti³ kãi³ju³ta² ã³na¹kxai²nãn²tu̱³ ka³lih³ wa³to²hain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Te²yã¹nxe³sxã³ txu¹hai²li² ũ³yho³hi²ki³a² ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ 10 nxe³ki³ai²na² tẽ³sxã³ ũ³ha¹nũ²nhai¹. A²nxe³ki³ai²na² ki³ka³na³ka³nat3sxã³ tĩ¹kxi²kxai²nãn²tu̱³ sxi²ha² whãi²na¹ sa²kxĩ̱x3sxã³ ũh³wxe²txi³nũ²la² kãin² ã³te³nxi²te²kxa³kxa¹ tĩ¹kxi²ki³ai³tã² ĩ³ha¹txi²sxã³ so¹xi²hĩ̱³nx2na³li¹. Nxe³jut3su² nxe³ai¹nhxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A²nxe³jut3su² tĩ¹kxi²ki³ai³tã² so¹xi²ka³tu̱³ a²ya̱³li³nũ̱³ka̱³txa² txu¹ti³nãu³xã² ka³lxa¹txi³ ã³nũ²kxain¹te³nah¹lxi¹: “Ka³lih³ha³sah¹lxi³nxi¹. Ũ³yho³hi²ki³ai²na² tĩ¹kxi²sa²ki³ai³tã² so¹xi²na¹ni¹. Nxe³na¹ju³tan¹te²kxa³ya̱³lhu² ka³lih³ha³sah¹lxi³nxi¹.” Nxe³ai¹nhxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Te²yã¹nxe³kxe³hũ̱³nxe² oh³xan¹ta² nũ̱³ka̱³txa² Txa²wã¹sũ̱³na² sa³wi³ha³lxa² kãin² ka³li³hain¹tu¹wi¹. A²nũ²a² ko̱³nxe³thin¹te²a² a²ko̱³nxe³ti³ kãi³ju³ta² ã³na¹kxai²nãn²tu̱³ kãin² ka³li³hain¹tu¹wi¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nxe³ha²kxai³lu¹ ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a² yxau³nũ²nhai¹. A²ki³lha³lxa² ha¹li¹ yxau² a²wĩ³na² yxau² nxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ain¹nxa²ha¹te¹ ka³ka̱un³jah¹la² kãi²nxa³jah¹lai²na² sa²kxai³lu² a²wĩ³na³ ĩ³ye³kxi²te³nah¹lxi¹: “Wĩ³na² nxex3txi¹. Wxa²yen³kxa² wxa²hau³kot3sxã³ wã²nhũ¹sa²sĩ¹nhẽ³li¹.” Nxai¹nha²kxai³ yen³kxa² hau³kot3sxã³ wã²nhũ¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wã²nhũ¹nũ²la² hã²wxãn³txa³ ka³ka̱un³jah¹la² sa²kxai³lu² yen³kxa² wxa²nũ²kxa²so¹nũ²la² ha³lo²a² u²lan¹ko³xa² ai³nũ²nhai¹. Nxe³tãu³a² yen³kxa² wa³su³txi³ wxa²sa²ya¹txũ³nũ²nhai¹, ko̱³nxe³thin¹sxã³ yxau²xai³lha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nxa²ha¹te¹ ha³lo²ai²li² yain³txa² yai³nhxa³txai¹nha²kxai³ ha³lo²a² yxau²xai³tũ̱³ka̱³txa² whãi²na¹ he³hain¹nũ²nhai¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² heh³khaix1nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nxe³ka³tu̱³ta¹ ha³lo²a² yxau³tũ̱³ka̱³txa² kwa²ã³ya̱³lxi³nũ²nhai¹. Nxa²ha¹te¹ kwa³jan³ta² yxa³kxa² ũ³yhait1si¹jau³su² ha³lo²a² ĩ³sa²si¹hã³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nxa²ha¹te¹ ũ³yhai¹tain¹tãu³a² he³ha²kxai³ yxa³kxa² yain³txa² yxo²kwa̱in³to³nhũ²nhai¹. Ĩ³yain³kxi²te³lhxã³ ain¹tah¹lxa¹ hai³txi³ ũ³hũ¹nyhai¹nxa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ain¹jut3su² a²ẽ¹nãu³ai²na² wxa²nxũ¹ha̱in³nha²te³nah¹lxi¹: “Txa²wĩ³na² a²sa³wi³ha³lxa² yain³txa² kãin² yũ³hxai²na²hẽ³na¹. Ain¹kxa²ha³tih³xan²tu̱³ txai²li² heh³ja³lut2sa³nha¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nxe³na¹ha²kxai³ ĩ³sa²yxau³sxã³ ĩ³na¹tũ¹xã¹, txa²wĩ³na² sxa³thĩ³na²sã¹. Na¹kxai²nãn²tu̱³ ĩ³ye³kxai²na¹te³nah¹lxi¹: ‘Wĩ³na² nxex3txi¹. Ko̱³nxe³thin¹te²sa¹wi¹. Oh³xa² nũ¹ka³na¹ Txa²wã¹sũ̱³na² ko̱³nxe³ti³ kãi³ũ¹ha¹ha²kxai³ wxãi²na² ko̱³nxe³ti³ kãi³ũh¹nxa²ha¹ha²kxai³ nxe³na¹hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nxe³nx2ta¹ju³kxai³lu¹ hĩ¹nãn¹te²tu̱³ wxa²ki³lha³lxu¹xi²na¹ju³ta³nũ³la³ hxi²kan¹sa²nxa³lho³li¹. Hãi¹sxã³ wxa²sa³wi³su¹xi²na¹tu¹wi¹.’ Nxe³ai¹na¹tũ¹xã¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ain¹jau³su² ha²kxai³ ĩ³sa²yxau³sxã³ ĩ³nũ²nhai¹. Nxe³nxa²ha¹te¹ u²lxĩ³xi²ti̱³kxai³lu² a²wĩ³na²kxai³lu² ĩ²ain¹tãu³a² ye³khãuh³lxa³nha²yai¹nha²kxai³ ã³nih³sxã³ ã³ne³khauh²kxi²ha²kxai³ wxa²yxe²ta³wau¹kxi²ha²kxai³ ka³li³hain¹jau³su² ĩ³yxo²sai¹la³kxi²ha²kxai³ nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nxa²ha¹te¹ wẽ³sa²kxai³lu² ĩ³ye³kxi²ti³ãn¹jau³kxai³lu¹: “Wĩ³na² nxex3txi¹. Ko̱³nxe³thin¹te²sa¹wi¹. Oh³xa² nũ¹ka³na¹ Txa²wã¹sũ̱³na² ko̱³nxe³ti³ kãi³ũ¹ha¹ha²kxai³ wxãi²na² ko̱³nxe³ti³ kãi³ũh¹nxa²ha¹ha²kxai³ nxe³nxa²ha¹hẽ³li¹. Nxe³nxa²ha¹ha²kxai³ wxa²ki³lha³lxu¹xi²na¹ju³ta³nũ³la³ hxi²kan¹sa²nxa³lho³li¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nxa²ha¹te¹ a²wĩ³na² sa²kxai³lu² a²sa³wi³ha³lxa² ĩ³ye³kxain¹te³nah¹lxi¹: “Nxe³jah³lxi³wxi¹. Wã²lai²na² wi¹khaix1ka³lo³a² sa²so¹sxã³ ũ³whi²kxi² ya³lau³xa² ũ³hxi²wxe³kxi² a²yu³kxan¹ka³lo³a² ũ³yhu̱³wi²kxi² jah¹la² nxe³txain¹sĩ¹nhẽ³li¹. Sa²toh³xã¹nxe³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yah³lxin¹tãu³a² po¹na² wẽ³sa² ha³nẽ³te²a² su²lhxã³ hi̱³jah¹lxi³hẽ¹li¹. Sa²kwxã³not3sxã³ sa²toh³xã¹nxe³jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Txa²wã¹wẽ³sai³ta³lxi² kxã³nxai³tã¹ ya²lu²kxi²sa²te²nũ³tũ²hẽ³li¹. Yxãn¹ta¹ hĩ¹na² ka³te̱n³su² ĩ³xai¹nĩn²tai¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² kãin² ĩ³yain³sãn²ka³tu̱³ kãin² ka³lih³ki̱³tu¹wi¹.” A²wĩ³nu²kxai³ nxe³nũ²nhai¹. Nxe³ha²kxai³ kãin² ĩ³ka³lxih³ ã³si³wxe³ain¹nũ²nhai¹. Hai³ni² sa²ha³te¹ti² yain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nxe³ain¹ti̱³kxai³lu² a²sai³lah³la² hai³sxa² wa³kon³nũ²nhai¹. Hã²wxãn³txa³ wa³kon³ta³lun²nũ²la² ĩ³xi²nũ²nhai¹. Ĩ³xi²tãu³a² sxi²ha² ya̱u³so³nxi²tãu³a² ĩ³wi¹lxo³kxi²nyhain¹jau³xa² ain³kxi² sa²ha³te¹ju³ta² ĩ²i² nxe³yain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nxe³ha²kxai³la¹ a²sa³wi³sa² ĩ³kaix1tũ²la² sxi²hai²na² hai³nain¹ju³ta² ĩ³ye³kxi²nũ²nhai¹. Ĩ³ye³kxi²te³nah¹lxi¹: “Hain³ye²nxain¹nhai¹. Ĩh¹nxe³tain¹si²lxi¹?” ");
INSERT INTO nabNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nxa²ha¹te¹ a²sa³wi³sa² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: “Wxa²lon³yah³lai¹tã² ĩ³xi²na²li¹. Wi¹lhin¹sxã³ ĩ³xi²ha²kxai³ wxa²wĩ³na² sa²kxai³lu² po¹na² wẽ³sa² ha³nẽ³te²na² su²lhi¹sain¹jau³su² ĩ³ye³kxi²sain¹na²li¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nxa²ha¹te¹ ain³kxain¹nxa²ha¹te¹ ĩ³a̱n³tain¹ju³ta³la³ te³nain¹te²nu³sxan³tai¹. Nxe³ain¹jut3su² a²wĩ³na² jau³jau¹xai²na² ain³kxi²nũ²la² a³li³xi²nũ²la² win¹ta²te²lxi³ ĩ³ye³kxi²nũ²nhai¹. Nxe² ĩ³ye³kxi²te³nah¹lxi¹: “Wxa²lon³yah³lai¹tã² ĩ³xi²na²li¹. Ĩ³ka³li¹ha³sẽ¹li¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","30","Nxa²ha¹te¹ a²sai³lah³la² ĩ³yxaih¹tẽ³txi³ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: “Kwẽ³kxa² ko³ka³lxa¹txi³ wa³kon³kxi¹nxa²ha¹tai¹ti²tu³wi¹. Nxe³nxa²ha¹tãu³a² ĩ³ye³kxi²san¹jau³xa² wet1txa²ha¹ju³ta² so¹lxi³ yũ³te²sa¹wi¹. Yxãn¹ta¹ hĩ¹na² sa²kxai³lu² wxa²wẽ³sai²li² wxa²yen³kxa² sa²so¹nũ²la² sa²so¹hxat3tain¹nũ²nhai¹. Txu¹ti³nãu³xa² ko̱³nxe³thin¹ta³ka³lxi³nãu³xã² wã²nhũ²hxa³nyhain¹nũ²nhai¹. Nxe³ai¹nha²kxai³ ĩ³xi²nũ²la² nxe³ain¹ju³tan¹te²kxa³ya̱³lhu² po¹na² wẽ³sa² ha³nẽ³te²a² hi̱³lain¹si¹hin¹jau³su² ĩ³ye³kxai¹nĩn²tai¹. Jã¹nxa¹ju³kxai³lu² ka³pri²ta² wẽ³sa² jũ¹nxe³kxan²ti³ ũ³sa²nxãn³tai¹ti²tu³wi¹, txa²ya̱³lxi³nũ̱³ka̱³txa² ĩ³ka³lxih³nũ³sĩn¹te³la³ku¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nxe³nxa²ha¹te¹: “Wẽ³sa² nxex3txi¹. Txa²sxi²ha² kan²txi³ yxau³ya³ha¹tu¹wi¹. Txa²yen³kxa² yxo²ha³kxa¹ wxa²yen³kxi³su² nũn³na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ain¹jut3su² kãin² ĩ³ka³lxih³hin¹ju³ta² wain³na³li¹. Wxa²lo³nai²li² kxã³nxa² ya³lu²kxi²nẽ³lha²kxai³ hĩ¹na² ka³te̱n³ti³ yxau³ha²kxai³ wi¹na³li¹. A²nxe³jah¹lai²li² ko̱³nxe³thin¹sxã³ ih³sa³tĩ¹jah¹lai¹ta³lxi² ĩ³xi²na²li¹. Nxe³ha²kxai³ wi¹na³li¹.” Ain¹nũ²nhai¹. Nxe³jau³su² Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nxa²ha¹te¹ ĩ³ye³ta³lun²nũ²la² Je³su²jah³la²kxai³lu² a²sa³wi³ha³lxa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Ĩ³ye³kxi²te³nah¹lxi¹: — Sxi²ha² wa³kxẽn³yah³la² kãin² yen³kxi³nhũ²nhai¹. Nxe³ka³tu̱³ta¹ yen³kxa² ĩ²ũ³hain¹si¹jau³su² a²sa³wi³sa² sa²wxe³ain¹nũ²nhai¹. Yxãn¹ta¹ jah³lai²li² yen³kxa² wain³txi³ hau³ko³txa³ha²kxai³ ha³te̱h³nxãn³nxa² kãi³hxat3sa²kxai³ nxe³nũ²nhai¹. Nxe³ju³tai²li² a²wa³kxẽn³yah³lai²na² ne³nxẽn³kxai³lu² ĩ³yau¹ũ¹hain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nxa²ha¹te¹ a²wa³kxẽn³yah³la²kxai³la¹ ĩ³kaix1so¹te³nah¹lxi¹: “Nxex3sa²lxi¹. Ko̱³nxe³kxan²ti³ sa²hau³ko³tin¹jau³xa² ain³kxai¹na¹hẽ³li¹. Nxe³ju³tai²li² ten³sa²nxa³ha²kxai³ ha³te̱h³nxãn³nxa² wxa²hau³kot3sã²nĩn¹ka³tu̱³ wa³kon³kxi²san¹ju³ta³ ne³ki³son³tu¹wi¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nxa²ha¹te¹ yen³kxa² hau³ko³jah¹lai²na² a²ẽ¹nãn¹jau³kxai³lu¹: “Wa³kon³kxai¹na¹ju³ta² ne³ki³son³te³lhxã³ nx2na³na¹. Nxe³kxai²nãn²tu̱³ ĩh¹nxe³ta³ kãi³a¹lhon³ku² nxa¹nha¹. Nũ̱³kxũn³txi³ wa³ko³na¹ju³ta² hxi²kan¹sa²nxa³ha²kxai³ a²yo³ha² so¹lxi³ ai³nxũ³hai¹na¹ju³ta² ãu²lxa²to³nha¹ha²kxai³ nxa¹nha¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nxe³na¹jau³su² hĩ¹na¹ ĩ²a¹xã¹ te²yã¹nxe² we¹ta¹tũ¹xã¹. Wa³kon³kxai¹na¹ju³ta² ne³ki³son³na³na¹. Hã²wxãn³txa³ txa²ya̱³lxa³nãu³xa² ka³lxa¹ha²kxai³ ã³nũ²kxi²sxã³ yxau³ya³sain¹tũ¹xã¹.” Nxe³nha²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nxe³nũ²la² a²nũ²a²nãu³xai²li² a²si³yxau³ka³txa² yen³kxa² kwa²ũ³hũ¹tũ̱³ka̱³txa² ka³na³ka³nat3sxã³ ĩ³kaix1te³nah¹lxi¹: “Nxex3txi¹. Txa²wã¹si³yxau³ka³txa² yã¹ta² yen³kxi³ta̱³ ũ³hũ¹nxain¹thai¹li¹?” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: “A³se³to²na²jau³xa² tã³po²rẽ¹na² nẽn³ka³lxa¹txi³ 100 nxe² ũ³sain¹na²hẽ³li¹.” Nxe³nũ²nhai¹. Nxa²ha¹te¹ ĩ³ye³kxi²ti³ãn¹jau³kxai³lu¹: “Txãn¹nxai²li² ũ³hau³ko³txã³nxai²la¹wi¹. Nxe³ta³nxã¹nxai²li² tã³po²rẽ¹na² 50 nxe² ka³lxa²nxa³tẽ³na² ũ³wha²li¹txa²hẽ³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nxe³nũ²la² a²ã̱³xah³la² ĩ³ye³kxi²te³nah¹lxi¹: “Wxãi²na²sa¹ yã¹te²yen³kxi³ta̱³ ũ³hũ¹nxain¹thai¹li¹?” Ain¹nũ²nhai¹. Nxa²ha¹te¹: “Tri²ka²ki³a² sa²kẽ³na² nẽn³ka³lxa¹txi³ 100 nxe² ũ³hũ¹sain¹na²hẽ³li¹.” Ain¹nũ²nhai¹. Nxa²ha¹te¹ jah¹lai²na² wãn³txi³kxai³lu¹: “Nxex3sa²lxi¹. Sa²kẽ³na² 80 nxe² ka³lxa²nxa³tẽ³na² ũ³wha²li¹txa²hẽ³li¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nxa²ha¹te¹ a²wa³kxẽn³yah³lai²na² sa²kxai³lu² jau³jau¹xai²na² ain³kxi²nũ²la² ĩ³ye³kxi²te³nah¹lxi¹: “Jah¹lai²li² ne³khen¹tai¹. Ki³ha¹kxi²sain¹kxan²ti³ ne³khen¹tai¹. Ko̱³nxe³thin¹tũ̱³ka̱³txai²li² yen³kxa² so¹kxi²nyhu¹kxi³tãu³a² ne³khe¹khaix1xain¹te²ju²hẽ³li¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² ĩ³hit1tain¹tũ̱³ka̱³txa² kũ³we²ki²la² ne³khe¹ain¹te²sxa³yu²hẽ³li¹.” Nxe³ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Te²yã¹nxe³ju³kxai³la¹ nxe² o²la³kxah³lxin¹kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ha³lo²a² ya²la³tu̱³ ã³wi¹hah³lxi³hĩ̱³nxãn¹te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ti³he¹nxa³wi¹. Nxe³yãn¹ta¹ yen³kxa² jũ¹lxi³te²a² wain³txi³ o²la³kxah³lxin¹kxai²nãn²tu̱³ ã²la² kãin²te²su² ju³ta² wain³txi³ o²la³kxah¹lxi³nũ³nĩn¹tu¹wi¹. Yxãn¹ta¹ jũ¹nxe² ki³han³sxã³ o²la³kxah¹lxin¹kxai²nãn²tu̱³ ã²la² kãin²te²su² ju³ta² ki³han³sxã³ o²la³kxah¹lxi³nũ³nĩn¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jã¹nxe³ju³kxai³lu² wxa²yen³kxi³khai³xa² wain³txi³ o²la³kxah²lxan³kxai²nãn²tu̱³ a²ha²jã¹nxe² Txa²wã¹sũ̱³na² yen³kxa² hxi²kan¹txi³ wain³txi³ o²la³kxah²lxan³so³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wain³txi³ o²la³kxah²lxan³kxai²nãn²tu̱³ti² wi¹la³ wa³kon³yah³lxin¹kxa² yo³ha² Txa²wã¹sũ̱³na² sa²kxai³lu² ũ³yho³hi¹nx2ti³xa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","A²nxe³jut3su² a²nũ²a² ha¹lin¹te²na² nxe³ya³sxã³ nxe³te²na² wãn³txai²na² hxi²kan¹ti³ sa²yxo²we¹ka³te²sxa³yu²hẽ³li¹. Nxe³sxã³ txa²wã¹hxi²kan¹ti³lo³tẽ³jah¹la² ka³na³ka³na³te²na² ĩ³hi̱³ki̱³sa²kxai³ txa²wã¹hxi²kan¹ti³lo³tẽ³jah¹la² ã̱³xai²na² a³lxi²ki̱³sa²kxai³ nxe³hĩ̱³ki̱³te²ju²hẽ³li¹. Te²yã¹nxe³sxã³ txa²wã¹hxi²kan¹ti³lo³tẽ³jah¹la² ka³na³ka³na³te²na² sa²yxo²we¹ki̱³sa²kxai³ txa²wã¹hxi²kan¹ti³lo³tẽ³jah¹la² ã̱³xai²na² sa²yxo²ã³ki̱³sa²kxai³ nxe³ki̱³te²ju²hẽ³li¹. Jã¹nxe³jut3su² Txa²wã¹sũ̱³na² so¹lxi³ sa²yxo²we¹ta̱³nxa² yen³kxa² kwa² ũ³ha¹kxi²ki̱³ju³ta³nũ³a² o²la³kxi²ta̱³nxa² yu³ka³na³ka³na³ju³ta² so¹lxi³ hxi²kan¹txi³ kãi³ki̱³te²ju²hẽ³li¹. Je³su²jah³lo²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txa² jau³jau¹xai²na² ain³kxain¹ta¹hxai²hẽ¹la². A²nxe³tũ̱³ka̱³txai²li² ũ³yho³hi²txã³nxa² a³lxi²khai¹xai¹nha²kxai³ ĩ³wa³ka³si³xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ko̱³nxe³ti³ o²la³kxah³lxi¹lxi¹. Yah³lxi¹nha²kxai³ a²nũ²a² wi¹le³kxi¹nx2tain¹ju³ta² ya³ni̱³li³yah³lxi¹lxi¹. Nxe² wi¹le³kxi¹nx2tain¹te³nah¹lxi¹: “Wain³txi³ o²la³kxah³lxi¹lxi¹.” Nxe³jau³xa² ya³ni̱³li³yah³lxi¹lxi¹. Yxãn¹ta¹ wi¹lhin¹ki³lxo³nyhah³lxi¹lxi¹. Nxe³ju³tai²li² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² a²ẽ¹na² e³yah³lxin¹jau³xa² yxo²ha³kxa¹ a³la³kxi¹nxa²lxi³na³li¹. A³la³kxi²ha²kxai³ ten³nxa²lxi³xa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","A²kxã³nxãn¹jau³xu¹tai²na² Sũ̱³na² wãn³txa² ũ³wha²li¹jau³xu¹tai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² nxe³jau³xu¹tai²na² ĩ³yau¹ũ³nyhain¹ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³ka³tu̱³ hã²wxãn³txa³ Jo³ãu² Ba³tis²jah³la² wxã³sxã³ ĩ³yau¹ũ¹nhẽ³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³tai²li² hĩ¹na² yũ²na³li¹.” Nxe³nẽ³ti³ai¹ti¹tu³wi¹. Nxe³nẽ³lhĩ¹nãn¹te²tu̱³ a²nũ²a² ĩ²li³te²na² ã³yxo²o³tũ¹sxã³ Sũ̱³na² yxo²ĩ²kxai²nãn²tu̱³ a²ẽ¹na² sa²hau³ko³ju³ta² yũ²na³li¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² ka³lxa¹te²nãu³xa² Sũ̱³na² wãn³txa² a̱in³so¹ai¹nha²kxai³ ya³lo³txi²sxã³ Sũ̱³na² yxo²ĩ²ain¹na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kxã³nãu³a¹ txa²wã¹ha³lo²ai²na² oh³nãn¹ko³nãu³a² yuh³nãn¹ko³nãu³a² nxe³sxã³ tĩ¹hxa³kxi²nẽ³ju³ta² yũ³tu¹wi¹. Nxe³kxan²ti³nũ¹ Txa²wã¹sũ̱³na² wãn³txa² a³lu²xa³jau³su² jau³kxan²ti³ hai³txi³ tĩ¹hxa³kxi²nẽ³lxa³lho³li¹. Wãn³txu¹tai²na² e³kxi²jau³xu¹jã¹nxe² we¹thxa³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","A²nxe³ju³kxai³lu² in³txai²li² txu¹ha² tĩ³na³ka³lxa² ã³nũ²la² txu¹ha² ta²ha¹ka³lxa² so¹kxai²nãn²tu̱³ txu¹ha² ã̱³xa² ũ³whĩn¹ta³kxi²nyhu¹kxa² yã¹nxa² hxi²ki³lxo³jah¹lo²su² hĩ̱³nx2na³li¹. Ko̱³nxe³ti³ kãi³ju³tai²la¹wi¹. Ãh¹lxi³sxã³ in³txa² txu¹ha² so³sxã³ye²nhyu¹in¹kxa² ti¹a² sxa³nũn³te²a² so¹ye³nyhu¹in¹kxai²nãn²tu̱³ txu¹ha² ã̱³xa² ũ³whĩn¹ta³kxi²nyhu¹kxa² yã¹nxe² hxi²ki³lxo³jah¹lo²su² hĩ̱³nx2na³li¹. Ko̱³nxe³ti³ kãi³ju³tai²la¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","— Nxa²ha¹te¹ a²nũ²a² yen³kxih³khaix1te²a² yxau³nũ²nhai¹. A²wã²la³ka³lo³a² a³lxi²ka³lo³a² so¹lxi³ ũ³whi²kxi²nha²ha²kxai³ yain³txa² wi¹te²a² so¹lxi³ yai³nha²kxai³ ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Nxa²ha¹te¹ in³txa² yen³kxi³txa²te²a² yxau³nũn³nũ²nhai¹. A²sxih²yxo²a² a³lan²ta² yxo²ha³kxa¹ yxo²sxa³to³nhũ²nhai¹. Jah¹la²kxai³la¹ ĩ³yau³xa³kxi²sxã³ ka̱³lã̱un³ta³kxi²nũ²nhai¹. Nxe³ha²kxai³ hxi²kan¹txi³ wa³ko³nxa³ha²kxai³ hãi¹sxã³ yain³txa² yen³kxih³jah¹la² wã³kon³kxe³su²: “Ã³yũ³xi²sa²te³ji¹xã¹.” Ain¹tah¹lxa¹ yain³txi³la³ ã³yũ³xai¹nxa³nũ²nhai¹. Nxe³yãn¹ta¹ wai³a³lxa² wxã³nũ²la² yau³xa³kxi²je³na² ĩ³tũ̱n³ta³kxi²nũ²nhai¹. A²nxe³jah¹la² La²sa³ro³jah³lo²su² nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hã²wxãn³txa³ jah¹la²kxai³lu² ya³lu²nũ²nhai¹. Ya³lu²nũ²la² oh³xan¹tũ̱³ka̱³txa² wxã³sxã³ oh³nãu³a¹ A³bra³ãu²ah³la² yxaut3ju³ta² sa²so¹sũh³wxe³ain¹nũ²nhai¹. Hã²wxãn³txa³nũ² yen³kxih³jah¹la² ya³lu²nũ³nha²kxai³ sa²nĩ̱³kxain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sa²nĩ̱³kxain¹ka³tu̱³ ha³lo²a² ko̱³nxe³khaix1ju³ta² kãin² ye³khãuh³lxa³ti³nha²khai¹nxũ²nhai¹. Nxe³ain¹tãu³a² sa²yxo²ka²la¹nha²nũ²la² u²ju³ta² A³bra³ãu²ah³la² ĩ²ha²kxai³ La²sa³ro³jah³la² ã³ka³lu³sa²wxe³nha²kxe³su² ĩ²ha²kxai³ ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nxa²ha¹te¹ ĩ³kaix1te³nah¹lxi¹: “A³bra³ãu²ah³lĩ¹. Txa²wĩ³nĩ¹. Nxex3txe¹. Wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sẽ¹le¹. La²sa³ro³jah³la² sa²si¹hã³txai¹nhẽ³le¹. Ĩ̱³yau³xa² wxa²hxi²kũ̱³nha²sxã³ txa²yo²he³wa̱x3sa³si¹hai¹na¹jau³su² nxe³na¹nha²we¹. Txai²li² khãuh³nha²khai¹nxa¹nha²we¹. Ha³nxe²a² a³lan²khaix1nx3nha²we¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nxa²ha¹te¹ A³bra³ãu²ah³lu¹tai²na² wãn³txi³kxai³lu¹: “Wẽ³sa² nxex3txe¹. Yuh³xan¹ko³xa² yxau¹nhĩn¹nai³tã² yen³kxa² wi¹te²a² yũ²khaix1nĩ¹nha²kxai³ jah¹la² kãin² ye³khãuh³lxa³ti³ha²kxai³ nyha¹hin¹tai¹tu³we¹. Yxãn¹ta¹ hĩ¹na² jah¹lai²li¹ wi¹lhin¹sxã³ yxau³ha²kxai³ wxãi²na² khãuhx3nha²khaix1nxĩ¹nha²kxai³ ya³hin¹ti²tu³we¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nxe³kxa²yu³su² wxa²ha³lo²a² txa²ha³lo²a² wit3txa² a²ẽ¹na² u̱³tẽ³na² yũ³te²ju²hẽ³le¹. Nxe³tẽ³na² a²nũ²a² yxo²ha³ti³lhi³te²nũ³a² hxi²kan¹txi³ yxo²ha³ti³lhi³ai¹nxa³lho³le¹.” ");
INSERT INTO nabNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Nxa²ha¹te¹ yen³kxih³jah¹lai²na² wãn³txi³kxai³lu¹: “Wĩ³na² nex3txe¹. Nxẽn²nxãn³kxai²nãn²tu̱³ txa²sxi²je³nai³tã² sa²si¹hã³txai¹nhẽ³le¹. Txa²wã³tã̱³nãu³xa² ha¹li¹ ha¹li¹ ka³na³ki¹ yũ³hxai²na¹hẽ³le¹. Wxã³sxã³ khãuh³lxa³txi³nain¹kxa²ya̱n³txi³su² nxa¹nha²we¹. Nxe³ha²kxai³ wxã³si¹nyhai¹nxa³jau³su² ĩ³hen³txi³nyhu¹si¹nyhai¹na¹jau³su² nxa¹nha²we¹. Nxe³ha²kxai³ La²sa³ro³jah³la² sa²si¹hã³txai¹nhẽ³le¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nxa²ha¹te¹ A³bra³ãu²ah³lai²na² wãn³txi³kxai³lu¹: “Wxa²lon³txi³tãu³xa² Sũ̱³na² wãn³txa² ũ³wha³li¹txã³nxu¹tai²na² yũ³ha²kxai³ Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² wãn³txa² yũ³ha²kxai³ nxe³jau³xai²na¹ ain³kxain¹txai²lẽ¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nxa²ha¹te¹ yen³kxih³jah¹lai²na² wãn³txi³kxai³lu¹: “Wĩ³na² nxex3txe¹. Kwa²nxi¹lxe¹. Ya³lu²tũ̱³ka̱³txa² ka³te̱n³su² ĩ³sa²yxau³xi²sxã³ wxã³ke³la³te²kxai³ nxe³jah¹la² ain³kxi²nũ²la² ĩ³ãin²ta³kxi²nha²sxã³ a²ko̱³nxe³ti³ kãi³ju³ta² ã³na¹la³kxi²nhai¹nhĩ̱³nx2na³le¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nxa²ha¹te¹ A³bra³ãu²ah³lu¹tai²na² wãn³txi³kxai³lu¹: “Nxe²nxa³we¹. Txa²wã¹sũ̱³na² wãn³txa² ũ³wha³li¹txã³nxu¹tai²na² Sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² wãn³txa² ain³kxai¹nxa³kxai²nãn²tu̱³ a²nũ²a² ya³lu²te²a² ka³te̱n³su² ĩ³sa²yxau³xi²sxã³ wxã̱³kxan²ti³ ain³kxai¹nhĩ̱³nx2nxa³we¹.” Ain¹nũ²nhai¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nxa²ha¹te¹ a²sa³wi³ha³lxa² ĩ³ye³kxi²te³nah¹lxi¹: — Txa²wã¹yuh³xan¹ko³nãu³ai²na² hin¹ki̱³tãu³a¹ ko̱³nxe³ti³ kãi³si¹nhẽ³ju³ta² yũ³hxai²ti³ai¹ti²tu³wi¹. Nxe³sxã³ ko̱³nxe³ton³tu¹wi¹. Yxãn¹ta¹ hxi²ki³su² te²lẽ¹. Ko̱³nxe³ton³khaix1nxe³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A²nũ²a² tah³lxa³kxa² sa²txe̱²khai¹nxe³ka³txa² tẽ³sxã³ ĩ³yxe²ta³kũ¹nha²te²su² jah¹lan²tu̱³ ĩ̱³yau³xa² u¹jau³xa² so¹sxã³ ãn³sa³nũ̱¹ke³la³te²kxai³ nxe³jah¹la² khãuh³lxa³ti³nha²ju³ta² kãin²hĩ̱³nx2na³li¹. Nxe³kxa²ha³tih³xan²tu̱³ a²nũ²ai²na² kwẽn¹ta² yxo²ĩ² ã³si³wxe³te²na² sa²kxai³lu² Txa²wãn³txa² sa²yxo²ã³sa²si¹hain¹jau³su² ĩ³tih³nxe³te²su² jah¹lan²tu̱³ ko̱³nxe³thin¹khaix1jah¹lo²su² hĩ̱³nx2na³li¹. A²nxe³jah¹la²kxai³la¹ khãuh³lxa³ti³ wa³to²hi²hai¹nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jã¹nxe³ju³kxai³lu² wi¹lĩ²jah¹lxi³hẽ¹li¹. Wxa²wã³tã̱³xai²li² ko̱³nxe³ti³ kãi³ye²nxain¹kxai²nãn²tu̱³ ĩ³kwa̱i²kxi¹txai¹nhẽ³li¹. Nxẽn¹kxai²nãn²tu̱³ ĩ³ãin²ta³kxi²nha²kxai²nãn²tu̱³ nxe³wã²na³txai¹nhẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nxe³ha²kxai³la¹ ye³ka³na³ka³nat3sxã³ a³lan²tãu³a² yau³ha¹li¹ yau³ha¹li¹ yau³ha¹li¹ ka³na³ki¹ hi̱³txain¹kxai²nãn²tu̱³ hã²wxãn³txa³ ĩ³ãin²ta³lxi²nxain¹kxai²nãn²tu̱³ ju¹tai²na² yxo²ha³kxa¹ nxe³wã²na³txa²hẽ³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² a²wãn³txi³kxai³lu¹: — Je³su²jah³lãi³. Kãin² yxo²ĩ²nxa²nha¹ju³ta² ten³sa²sĩ¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Yxo²ĩ²sah¹lxin¹jut3tai²na² yain³txa³ki³a² mos³tar²ta²ki³a² ki³jũ¹nxe²ka² yã¹nxi³la²sxã³ jũ¹nxe³ yxo²ĩ²sah¹lxin¹kxai²nãn²tu̱³ hi³a² a³mo³re²ra²nẽ³ka² nxe²ĩ³ye³kxah³lxin¹te³nah¹lxi¹: “A³mo³re²ra²nẽ̱³kãi³. Sa²ha³txu²kxa²sai¹nhat1sxã³ ĩ̱³ye³na² kãin²je³na² ũh³wĩ̱¹nha¹sẽ¹li¹.” Nhãn¹kxai²nãn²tu̱³ a³mo³re²ra²nẽ³kxai²li² ĩ³we²txa²lxi³hĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yxãn¹ta¹ yxo²kãin²txi³nha²sxã³ a̱in³nyha¹yah³lxi³txa³hẽ¹li¹. Wxa²sa³wi³sai²na² hai³sxa² wa³kon³ta̱³nxa² o³ve²a² hau³ko³ta̱³nxa² nxe³hĩ̱³nx2na³li¹. Nxe³sxã³ ĩ³xi²nũ²la² nxe²ĩ³ye³kxai¹nhĩ̱³nxãn¹te²la¹xã³? “Wxãi²thã²ta³ ĩ³yain³txa²sã²nhẽ³li¹.” Jau¹xai²na² ĩ³ye³kxai¹nhĩ̱³nxãn¹te²la¹xã³? ");
INSERT INTO nabNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ti³he¹nx2nxa³wi¹. Yxãn¹ta¹ nxẽn¹te³nah¹lxi¹: “Yain³txa² ũ³txe³kxi¹sãn²nũ²la² ũ³hũ¹sa²sã²nĩn¹ka³tu̱³ yain³ta³lun²na¹kxai²nãn²tu̱³ hã²wxãn³txa³ txa²si³yo³na² yain³txa²hẽ³li¹.” Nxe³jau³xai²na² ĩ³ye³kxai¹nhĩ̱³nxa¹lxi¹, kwa²wa³kon³kxi¹nxa²jah¹lo²su² ha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nxe³jau³kxai³la¹ ĩ³ye³kxain¹yah³lxin¹jau³su² wet1txain¹kxai²nãn²tu̱³: “Wi¹lxo³kxi³sa¹lxi¹.” Ain¹jau³su² wxa²sa³wi³sa² ĩ³ye³kxi¹te²sxa³yu²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Te²yã¹nxe³ju³kxai³lu² Txa²wã¹sũ̱³na² kwa²wa³kon³kxi²yah³lxi¹nha²kxai³ ĩ³wa²lũ³xai¹yah³lxin¹te³nah¹lxi¹: “Txai²li² kãin²sa²nxa³wi¹. Wxa²wa³ka³lxi³nũ³a² so¹lxi³ nxe³te²si²na¹wi¹. Ĩ³ye³kxi²san¹ju³ta² yxo²ha³kxa¹ sa²wet1te²si²na¹wi¹.” Nxẽn¹tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nxa²ha¹te¹ Je³su²jah³la²kxai³la¹ Je³ru³sa³lẽ²tĩh³na² ai³ta¹hxai²hẽ¹la². Ai³te³na¹ Sa³ma²ri²a² ko³xa² Ka³li³le²a² ko³xa² wi³tãn¹tĩh³na² ai³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ai³tãu³ãn²tu̱³ sxi²je³na² yxau³son³sxã³ ã³wih¹ta¹hxai²hẽ¹la². Nxe³tãu³ãn²tu̱³ta¹ a²nũ²a² in³txi³nãu³xa² ha¹li¹ ha¹li¹ ha¹li¹ ha¹li¹ ha¹li¹ a²sĩ̱³na² ka̱³lã̱un³ta³kxi²sxã³ ĩ³to³nain¹te²nãu³xa² ĩ³ha¹txi²nyhain¹ta¹hxai²hẽ¹la². Sxi²je³na² yxo²ka³teh³xa² ai³tãu³a² u²lxi³je³na² ã³yit1tain¹ka³tu̱³ Je³su²jah³la² ten³sa²tã³ain¹tãu³a² ĩ²ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nxe³ain¹te³nah¹lxi¹: — Je³su²jah³lĩ¹. Wxãi²li² Txa²wã¹hxi²kan¹jah¹lo²si¹lxe¹. Txa²ĩ³ta³ka³txa² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sa²sĩ¹nhẽ³le¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nxa²ha¹te¹ ĩ²kxain¹nũ²la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Wã³nxĩn¹ta² si³yxau³jah³la²nãu³xa² ai³jah¹lxi³sxã³ wã²nã³ũ¹nha¹je¹tain¹yah³lxi³hẽ¹li¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². Nxe³nũ²la² aun³txa² ai³ain¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a¹ wa³su³txi³ we²nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nxe³te³na¹ in³txa² ka³na³ka³na³te²su² te²kxai³lu² we²nxi²ye²kxe³su² wa̱³li²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wa̱³li²nũ²la² Je³su²jah³la² a²yen³na² ã³kxu²thu²kxa¹sxã³ ĩ³kaix1te³nah¹lxi¹: — Txa²wã¹sũ̱³na² wã³nxĩn¹jah¹lo²si¹lxi¹. Nxĩ¹nha²kxai³ we²txi²sa¹nha²kxai³ wi¹lxo³kxi³san¹nhai¹. Ain¹jau³su² ta¹hxai²hẽ¹la². A²nxe³jah¹lai²li² Sa³ma²ri²a²ko³xan¹jah¹lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — A²nũ²a² ka³lxa¹txi³ 10 nxe³sxã³ we²txai¹na¹li¹. Yxãn¹ta¹ ka³na³ka³na³te²a² so¹lxi³ Sa³ma²ri²a²ko³xan¹jah¹la² so¹lxi³ ã³wa̱³lin²ju²li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","19","Jah¹la² so¹lxi³ txa²nũ̱³ka̱³txi³sxa³kxan²ti³ ã³wa̱³lin²ju²li¹, Txa²wã¹sũ̱³na² wi¹le³kxi²te³lha³ku¹. Ain¹jau³su² ha²kxai³ ã³kxu²thu²kxa¹jxah¹la²kxai³ ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³sa²yxau³sxã³ ĩx3txu¹li¹. Yxo²ĩ²sah¹lxin¹nha²kxai³ we²txi¹nx2ta¹ten¹tu³wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nxa²ha¹te¹ ĩ³ye³ta³lun²nũ²la² fa³ri³se²a²nãu³xa² ã³nhai¹tũ³te²nãu³xai²na² ĩ³wã̱³txain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³su² tãu³su² tãu³a² ĩh¹nxe³hĩ¹na² ã³si³wxe³te³ji¹wi¹? Ain¹tah¹hxai²hẽ¹la². Ain¹nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²ju³tan¹ti²wa³kxa² ĩ²yah³lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Txa²wã¹ẽ¹na² so¹lxi³ ĩ²nha²ki̱³tu¹wi¹. Yxãn¹ta¹ wxa²ye³na² ĩ²yah³lxan³tho³li¹. Nxe³jut3su² ha²kxai³: “Ti¹a² wxã²na³li¹.” Jau³xai²la³ ta̱³nxa²: “Ju¹xa² wxã³nai¹.” Jau³xai²la³ ta̱³nxa² nxe³jau³jau¹xai²na² e³yah²lxan³tho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nxa²ha¹te¹ a²sa³wi³ha³lxa² ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Kxãn³nãu³a² nũ³kxũn³sxã³ ã³wa̱³li²na¹ju³ta² ĩ²nx2ti³lxun¹nxa²ti³tu¹wi¹. Yxãn¹ta¹ ĩ²syah¹lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nxe³hĩ¹na² ĩ³ye³kxi¹nx2tain¹te³nah¹lxi¹: “Ti¹kxai²lxã²na³li¹.” Ain¹jau³su² ta̱³nxa²: “Nũ¹ka³nai²lxã²na³li¹.” Nxe³jau³tai²la³ ta̱³nxa² nxain¹kxai²nãn²tu̱³ ain³kxah²lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ha³lai³xa² ha³lai³nĩ³kxai²nãn²tu̱³ ha³lo²a² whãi²na¹ ĩ³ko²ko²kxi²te²ju²hẽ³li¹. Nxe³kxa² yã¹nxe³sxã³ wa̱³li²na¹ju³ta³nũ³a² a²nũ²a² hãi¹nxe³ti³xa¹ ul²yxau³ain¹kxan²ti³ ĩ²kxi²sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nxe³yãn¹ta¹ wa̱³lin²nxa³ta̱³lxa¹ hĩ¹na² yxau³tũ̱³ka̱³txa² a²hxi²ki³kxai³lu² ye³ka³lxa¹txi³sxã³ khãuh³lxa³ti³sain¹to³tu¹wi¹, en²txi³sain¹tũ̱³ka̱³txa²su¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kxã³nhxĩ¹nu¹tai²na² No³e²ah³lu¹tai²na² yxau³hĩ¹nu¹ta² yã¹nxe³kxe³hũ̱³nxe² a²kan³sxã³ wxã³na¹ju³ta³nu³a² yã¹nxe³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jã¹nxe³hĩ¹nu¹tai²na² tũ̱¹ka̱³txu¹tai²na² kwa²ĩ³yain³kxi²nyhu¹i² kwa²ĩ³na²kxi²nyhu¹i² txu¹ha² so¹kxi²nyhu¹i² txu¹ha² ũ³hũ²nyhu¹i² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³nyhu¹ain¹te³na¹ No³e²ah³lu¹tai²na² sa²kxai³lu² na³vi²o²tẽ³na² ar²ka³tẽ³na² ã³wi¹nhũ²la² wẽ³ha²yau³xa² ã³ãn³si³wxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe² wẽ³hã¹hũx3sa²kxai³ a²nũ²a² hãi¹nxe³ti³xa¹ ya²lun¹ta² hxan³ta¹hxai²ti³ai¹ti²tu³wi¹. Te²yã¹nxe³kxe³hũ̱³nxe² ha³lo²a² wah³nxai¹nxa³ti³wa³kxa² Txai²na² a²kan³sxã³ wxã³na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jã¹nxe³ju³kxai³lu¹ kxã³nhxĩ¹nu¹tai²na² Lo²ah³lu¹tai²na² yxau³hĩ¹nu¹tai²na² a²nũ²a² yxo²ha³kxa¹ kwa²ĩ³yain³kxi²nyhu¹i² kwa²ĩ³na²kxi²nyhu¹i² yen³kxa² so¹kxi²nyhu¹i² hai³sxa² ũh³wĩ̱¹i² sxi²ha² txo³ni² ain¹ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","So³to²ma²thĩ³nu¹tai²na² Lo²ah³lu¹ta²kxai³lu² a³li³hĩ¹na¹ oh³xa² wẽh³ha²yau³xa² yã¹nxe³la²sxã³ ha³nxe² i̱³kxa² ah³hi² ẽn³syo²fre²nũ̱³xa² i̱³kxa² ah³hi² nxe³ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² yxo²ha³kxa¹ wxã³ya²lun¹ta³lxa² hxan³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Te²yã¹nxe³kxe³hũ̱³nxe² a²nũ²a² wah³nxe³sai¹nxa³ti³wa³kxa² Txai²na² a²kan³sxã³ wxã³na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nxe³hĩ¹na¹ a²nũ²a² sxi²ha² ne³ka³nah²nãu³a¹ he¹kxai²nãn²tu̱³ yen³kxa² sxi²hẽ¹nãu³ai²na² wi²sxa³kxai²nãn²tu̱³ ã³wih²xi²sxã³ so¹ju³ta²nũ³a² yũ²nxa³lho³li¹. Hãi¹nxe³sxã³ u²lã³ni³txai²la¹. Te²yã¹nxe³sxã³ a²nũ²a² hai³sxa³nãu³a¹ he¹kxai²nãn²tu̱³ sxi²ha² ã³wih²xi²ju³ta² yũ²nxa³lho³li¹. Hãi¹nxe³sxã³ u²lã³ni³txai²la¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nxe³ha²kxai³ Lo²ah³lu¹tai²na² a²sxe³xa² ne³wã²yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Te²yã¹nxe³ju³kxai³la¹ a²nũ²a² e³te³nah¹lxi¹: “Yu̱h³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²wi¹na¹tãu³a¹ a³lxi²sa³nha¹. Je³su²jah³lai²na² wãn³txa² sa²yxo²ã³a¹kxan²ti³ ya³lu²ju³ta² ten³sa²nxa³nha¹.” Nxe³kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³ju³ta³nũ³a² yũ²nxa³lho³li¹. Yxãn¹ta¹: “Yu̱h³xai²na² ti¹ai²na² yxau³na¹tãu³a² txa²wi¹na¹tãu³la³ a³lxi²sa²nxa³nha¹. Je³su²jah³lai²na² wãn³txa² yxo²ĩ²a¹ju³tan¹te²kxa³ya̱³lhu² ĩ³ya²lut1sain¹kxan²ti³ yxo²ĩ²a¹ju³ta² ã³na¹nxa³lho³na¹.” Nxe³kxai²nãn²tu̱³ Txa²sa³wi³ha³lxi³sain¹tu¹wi¹. Nxe³kxa²yu³su² Txa²wã¹sũ̱³na² ha³lo²a² yxau²xai³ju³ta³nũ³a² yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jã¹nxe³ju³kxai³la¹ ka³nxah³tai²na² in³txa² ha¹li¹ ãu³xi²ya³tãu³a² ka³na³ki³ sa²so¹ha²kxai³ ka³na³ki³ ot3sa²kxai³ nxe³ya³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nxe³ya³ha²kxai³ txu¹ha² ha¹li¹ nxũ̱³sa² o²la³kxi²ya³tãu³a² ka³na³ki² sa²so¹ha²kxai³ ka³na³ki² ot3sa²kxai³ nxe³ya³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nxe³ya³ha²kxai³ in³txa² ha¹li¹ hai³sxa² tau³ya³tãu³a² ka³na³ki² sa²so¹ha²kxai³ ka³na³ki² ot3sa²kxai³ nxe³ya³tu¹wi¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² wãn³txi³kxai³lu¹: — Txa²hxi²kan¹jah¹lãi³. Jau¹xai²na² ĩh¹nxu¹la²ta̱n³te³ji¹wi¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la²kxai³ ĩ³yau¹ũ³jau³xa² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Ka³yxuh³xa² ya³lu²sxa̱³je³na² wa³lu³hxa² ã³nũ²kxi²te²ju²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ain¹nxa²ha¹te¹ ãh¹ ĩ³ye³kxi²ta¹hxai²hẽ¹la²: — Ĩ³nxũ²kwa̱i³lxũ¹nha²sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²sa²tẽ³to³jah¹lxi³hẽ¹li¹. Nxe³jau³xa² ĩ³yau¹ũ³te³lhxã³ ãh¹ ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nxe³ha²kxai³lu¹: — Sxi²hẽ¹nãu³ai²na² a²hxi²kan¹jah¹lo²su² nũ²nhai¹. A²nxe³jah¹la²kxai³la¹ yu̱h³lxi³ti³hex1ai¹nxa³nũ²nhai¹. A²nũ²a² yu̱h³lxai¹nxa³ha²kxai³ Txa²wã¹sũ̱³na² yu̱h³lxai¹nxa³ha²kxai³ nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nxe³ju³kxai³lu² txu¹ha² wã³ha³te³son³ta¹ka³lxa² sxi²je³nãn¹ta¹ka³lxu³su² nũ²nhai¹. A²nxe³ta¹ka³lxa²kxai³ ĩ³ye³kxi²te³nah¹lxi¹: “Txa²hxi²kan¹jah¹lãi³. Ain³kxi²sẽ¹li¹. Ko̱³nxe³ti³ kãi³sain¹jah¹la² ĩ³wai³kxũ¹sẽ¹li¹.” Nxe³jau³xa² ĩ³ye³ye³kxi²to³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nxa²ha¹te¹ jah¹la²kxai³lu² a²ẽ¹nãn¹jau³kxai³lu¹: “Ta¹ka³lxai²li² ain³kxai¹na¹ju³ta³la³ ten³sa²nxa³nha¹. Txa²wã¹sũ̱³na² yu̱h³lxi³sa²nxa³ha²kxai³ a²nũ²a² yu̱h³lxi³sa²nxa³ha²kxai³ nxa¹nha¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nxe³sa²nxa³kxan²ti³nũ¹ hxi²that3sain¹kxa²ya̱n³txi³su² nxa¹nha¹. Kwa²ĩ³wai³kxũ¹ai¹na¹tũ¹xã¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A²nxe³jut3su² hxi²kan¹jah¹la²kxai³lu² ko̱³nxe³thin¹kxan²ti³ ĩ³wai³kxũ¹ye²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Te²yã¹nxe³ju³kxai³lu² Txa²wã¹sũ̱³na² wi¹lhin¹sa²sai¹ye²kxe³su² nxe³te² hi²sen³kxai³lu² a²nũ²ai²na² ĩ²sxã³ ã³yũ³so¹te²nãu³xa² ya²la³tu̱³ ĩ³wai³kxũ¹ain¹tu¹wi¹. Ye³ka³lxa¹txi³ a³lan²tãu³a² ĩ³kaix1to³hain¹kxan²ti³ ĩ³hxi²nũ¹nũ¹hain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wa³su³txi³ ĩ³wai³kxũ¹ain¹tu¹wi¹. Jã¹nxa¹ju³kxai³la¹ a²kan³sxã³ wa̱³li²na¹hĩ¹na¹ ti¹ai²nãn¹ko³nãu³a¹ ĩ³nxũ²kwa̱i³lxũ¹nha²sxã³ Sũ̱³na² ĩ³ye³kxi²sa²tẽ³to³te²na² ka³na³ki² te²a² yũ³ye²tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nxe³ha²kxai³la¹ yau³ã̱³xai²na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². In³txa² ĩ³ye³kxi²nha²te³nah¹lxi¹: — Txai²na² so¹lxi³ hxi²kan¹te²lã³na¹nha¹. Txai²na² so¹lxi³ wi¹lhin¹te²lã³na¹nha¹. Nxe²e³kxa²yã¹nxe³tũ̱³ka̱³txa² ĩ³yau¹ũ³te³lhxã³ Je³su²jah³la² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Nxe³nũ²nhai¹. In³txa² ha¹lin¹ti³nũ²nhai¹. Txa²wã¹sũ̱³na² sxi²ha² ã³wi¹yha³nhũ²nhai¹. Ã³ne³ka²ta¹te²a² fa³ri³se²ah³lo²su² nxe³ha²kxai³ ã³ta³lo³hẽ¹te²a² a²nũ²a² ũ³yho³hi²ki³ka² so¹kxi²nẽ³jah¹la² nxe³ha²kxai³ nxe³ya³nhũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ain¹nxa²ha¹te¹ fa³ri³se²ah³la²kxai³ txa²nũ² Txa²wã¹sũ̱³na² yxo²ha³txe³ti³nha²sxã³ nũh¹e³kxi²ti³ãn¹jau³kxai³lu¹: “Sũ̱³na² nex3txi¹. A²nũ²a² yxo²ha³kxa¹ ko̱³nxe³khai¹xai¹nhxai²na²hẽ³li¹. Kãi³kxi²nyhu¹i² wain³ju³ta² o²la³kxi²nyhu¹xa³i² tu¹ha² ã̱³xa² ũ³whĩn¹ta³kxi² nxe³ai¹nhxai²na²hẽ³li¹. Yxãn¹ta¹ txai²li² ti³hex1te²txã³wi¹. Nxe³na¹kxa²yo³kxai³la¹ jah¹lai²li² a²nũ²a² ũ³yho³hi²ki̱³kxa² so¹kxi²nẽ³jah¹lai²na² yã¹nxẽn²nxa³wi¹. Ã̱³lxi³na¹wi¹. Nxe³jut3su² wi¹lxo³kxi²nha¹nha²wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yxãn¹tah¹lxi¹ txai²na² sa²kxai³lu² ye³ka³na³ka³na³ta³ sa²ba³to³ nxe³hĩ¹na² ĩ³yai³na¹ju³ta² ye³ha¹li¹ ã³na¹a¹ha²kxai³ yen³kxa² 10 nxe² so¹kxi²na¹ke³la³te²kxai³ ka³na³ka³nat3te²a² ũ³hũ¹nxa²ha¹ha²kxai³ nxe³te²sa¹wi¹.” Nxe³jau³xai²li² fa³ri³se²ah²la² ĩ³ye³kxi²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ain¹nxa²ha¹te¹ ã̱³lxi³jah¹la² u²lxi³yxau³jah¹la² ãin²ti³nha²sxã³ ã³kxu²thu²kxa² ai³nũ²nhai¹. Txa²wã¹sũ̱³na² ĩ³ye³kxi²te³nah¹lxi¹: “Sũ̱³na² nxex3txi¹. Ko̱³nxe³khaix1te²sa¹wi¹. Nxe³te²sa¹ha²kxai³ ko̱³nxe³ti³ kãi³a¹ju³ta² wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sẽ¹li¹.” Nxe³jau³su² nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nxe²e³ta³lun²nũ²la² jah¹la²kxai³lu² a³li³nũ²la² ka³nxi²sxã³ ĩ³xi²tãu³a² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² ko̱³nxe³ti³ kãi³ju³ta² nxe³wã²na³kxi²nũ²nhai¹. Nxe³ju³tan¹te²kxa³ya̱³lhu² wi¹lhin¹te²lot3sxã³ ĩ³nũ²nhai¹. Nxa²ha¹te¹ ã̱³lxi³jah¹lai²na² fa³ri³se²ah³lai²na² hai³txi³ nxẽn²nxa³nũ²nhai¹. Nxe³ye¹nx2ta¹wi¹. Jã¹nxe³jut3su² a²nũ²a² a²kãin²jah¹lo²su² kxe³su² yxo²kwa̱i³no³tain¹kxai²nãn²tu̱³ kxãn³nãu³a¹ Txa²wã¹sũ̱³na² hi²sen³kxai³lu² ĩ³kãi²nxa³te²lo³tain¹tu¹wi¹. Yxãn¹ta¹ hĩ¹nai²na² a²kãi²nxa³jah¹lo²su² kxe³su² yxo²kwa̱i³no³tain¹kxai²nãn²tu̱³ kxãn³nãu³a¹ Txa²wã¹sũ̱³na² hi²sen³kxai³lu² ĩ³kãin²te²lo³tain¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ain¹nxa²ha¹te¹ a²nũ²a² a²wẽ³ha³lxa² tẽ³ain¹ta¹hxai²hẽ¹la². Je³su²jah³la² wxa²ne³wxaix3te³lhxã³ tẽ³kxain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xa² ĩ²ain¹nxa²ha¹te¹ ĩ³hxi²ko²lain¹si¹jau³su² yxo²xũn³txi³ ĩ³kwa̱i²kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ain¹jut3su² Je³su²jah³la³ jut3sĩ²nũ²la² a²sa³wi³ha³lxi³nãu³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Ne³ka²sah¹lxi³sa²lxi¹. Wẽh³ha³lxa² tẽ³sxã³ wxã³ain¹ju³tai²na² ĩ³hxi²ko³lain¹yah³lxi³txa³hẽ¹li¹. Wẽ³sai²li² a²wĩ³na² wãn³txa² yxo²ĩ²te²ju²hẽ³li¹. Nxe³kxa²yã¹nxe³kxe³hũ̱³nxe² Txa²wã¹sũ̱³na² wãn³txa² yxo²ĩ²jah³lxi³hẽ¹li¹. Nxe³yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² Txa²wã¹sũ̱³na² ha³lo²a² yxau³yah³lxin¹ju³ta³nũ³a² yũ³nx2ti³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya²la³tu̱³ Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³su² nxe³jau³xa² ten³nxa²lxi³kxai²nãn²tu̱³ Txa²wã¹sũ̱³na² wãn³txa² sa²yxo²we¹jah¹lxi³hẽ¹li¹. Nxe³yah³lxin¹ju³tan¹te²kxa³ya̱³lhu² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³ai²li² ĩ²yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hã²wxãn³txa³ a²nũ²a² hxi²kan¹te²su² te²a² ya̱u³son³ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³wã̱³txi³ti³an¹jau³kxai³lu¹: — Txa²hxi²kan¹jah¹lãi³. Wi¹lhin¹jah¹lo²si¹lxi¹. Ĩh¹nxe² o²la³kxi²nha²sxã³ ka³te̱³na² wi¹tãu³la³ so¹kxi²hĩ̱³na¹te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ wi¹lhin¹te²su² san¹ji¹wi¹? Txa²wã¹sũ̱³na² so¹lxi³ wi¹lhin¹jah¹lo²lxã²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Txa²wã¹sũ̱³na² wãn³txu¹txai²na² ain³kxi²to³hxain¹tai¹ti²tu³wi¹. Nxe³jau³xa²sa¹: “Txu¹ha² ã̱³xa¹ka³lxa² ũ³whĩn¹ta³kxi²nyhu¹txa³hẽ¹li¹. A²nũ²a² ĩ³su²lhã³nyhu¹txa³hẽ¹li¹. Yen³kxa² kãi³kxi²nyhu¹txa³hẽ¹li¹. A²nũ²a² ko̱³nxe³te²lo³nyhu¹txa³hẽ¹li¹. Wxa²wĩ³na² wxa²hã³ka³nu¹na² sa²nẽn¹kxai¹nĩn¹ju³ta² so¹lxi³ kãi³ũh¹txai¹nhẽ³li¹.” Nxe³jau³jau¹xu¹tai²na² yxo²ha³kxa¹ sa²yxo²we¹txa²hẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Sa³nxe³la³kon³sa³hĩ¹nãn¹te²tu̱³ sa²yxo²wet1sa²sai¹hxai²na¹hẽ³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nxa²ha¹te¹ Je³su²jah³lai²na² a²wãn³txi³kxai³lu¹: — Yu³ka³na³ka³na³ton³na³li¹. Wxa²yen³kxa² sa²so¹sxã³ a²nũ²a² ã̱³xa² so¹kxi²nxa²si¹jau³su² kãi³txa²hẽ³li¹. Nxĩn¹kxai²nãn²tu̱³ so¹kxi²nxain¹kxa² yo³ha² tẽ³sxã³ a²nũ²a² yen³kxi³txa²te²na² wã²nhũh²xai³txai¹nhẽ³li¹. Nxĩn¹kxai²nãn²tu̱³ oh³nãu³nũ¹ka³na¹ yen³kxa² wi¹ju³ta³nũ³a² yũ³nxa²tu¹wi¹. Jã¹nxe³sxã³ nxe² kãi³ta³lu²nĩn¹kxai²nãn²tu̱³ ã³wxã³sxã³ ã³si³tẽ³kxi¹sẽ¹li¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nxe³jau³xai²na² sa²kxai³lu² in³txai²na² sa²kxai³lu² ain³kxi²te³na¹ ãin²ta³kxi²nha²ta¹hxai²hẽ¹la³, kãin² yen³kxih³ha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nxa²ha¹te¹ Je³su²jah³la²kxai³ ĩ²kxi²nũ²la² ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a² kãin² yen³kxih³te²su² te²a² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ju³ta² wa³lxe³te²ju²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jã¹nxa¹jau³su² ka³me²la² ka³yxuh³xa² kãin²khaix1te²su² te²na² hai³txi³ a²ku¹wxi²si³xẽ¹na² ã³wih¹sxã³ ã³wa²to¹ti³he¹nxe³lhĩ̱³nx2nxa³wi¹. Yxãn¹ta¹ a²nũ²a² kãin² yen³kxih³khai¹nxe³te²su² te²a² Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ju³ta² wa³to²hi² wa³lxe³te²ju²hẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nxa²ha¹te¹ a²nũ²a² ain³kxi²tũ̱³ka̱³txan¹te²a² a²wãn³txi³kxai³lu¹: — Txa²wã¹ha³lo²a²nãu³a² a²nũ²ai²li² yen³kxih³kxai²nãn²tu̱³ Txa²wã¹sũ̱³na²su² wi¹lhin¹sxã³ ĩ²jah¹lo²su² ye²te²ju²hẽ³li¹. Nxe³jut3su² ha²kxai³ a²nũ²a² yen³kxih³te²su² te²na² kxã̱u³nxa³sxã³ Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³kxai²nãn²tu̱³ a²nũ²a²nãu³xa² hãi¹nxe³ti³xa¹ Txa²wã¹sũ̱³na² wãn³txa² ain³kxi²sxã³ yxau²xai³ki̱³sxa³lho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nxe³nũ²la² Je³su²jah³la² ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² hxi²kan¹ti³he¹xai¹nxa³wi¹. Yxãn¹ta¹ Txa²wã¹sũ̱³na² hi²sen³su² hxi²kan¹te²lo³jah¹lai²la¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nxa²ha¹te¹ Pe²jah³lai²na² wãn³txi³kxai³lu¹: — Nxex3txi¹. Txa²wã¹yen³kxi³khai³xa² ã³na¹sãn²sĩ¹na¹ka³tu̱³ wxãi²na² so¹lxi³ ã³si³tẽ³la³kxi¹sĩ¹na¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Ya²la³tu̱³ ĩ³ye³kxi¹nx2ta¹wi¹. A²nũ²a² ĩ²li³te²na² Txai²na² a³lxi²sai¹nha²kxai³ sxi²ha² ã³na¹i² a²sxe³xa³ka³lxa² ã³na¹i² a²lon³ti³nãu³xa² ã³na¹ai¹ni² a²wĩ³na² ã³na¹i² a²hã³ka³na² ã³na¹i² a²wẽ³ha³lxi³khai³xa² ã³na¹ai¹ni² nxe³ain¹kxai²nãn²tu̱³ ã³si³tẽ³la³kxi²sain¹te²na² sa²kxai³lu² kãin² wa³to²hi²sxã³ ũ³yho³hai¹na¹ju³ta² yũ³tu¹wi¹. Nxe³ai¹na¹kxa²yu³su² a²kan³sxã³ wa̱³li²na¹hĩ¹na¹ ka³te̱n³su² ĩ³sa²yxau³xi²ti³hi¹tai¹na¹tu¹wi¹. Te²yã¹nxe³nũn³sxã³ kãi³ũh¹nx2ti³nũ³na¹tu¹wi¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hã²wxãn³txa³ a²sa³wi³ha³lxa² hxi²ka² hxan³sxã³ ãh¹ ha¹li¹ wxa²sa²so¹kxi²nũn³sxã³ nxe³te²nãu³xa² nũh¹lxi³sxã³ ĩ³ye³kxi²ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Nxex3jah³lxi³wxi¹. Je³ru³sa³lẽ²thĩ³na² ã³nxai³ki̱³tu¹wi¹. Nxe³ki̱³kxai²nãn²tu̱³ Sũ̱³na² wãn³txa² ĩ³hen³txi³te²nãu³xu¹tai²na² e³kxi²sye¹nyhain¹jau³xu¹jã¹nxe² kãi³hxa³je²sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nxe³ju³kxai³la¹ Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³xa² a²hxi²ki³kxai³lu² ã³yãu³hũ¹nha²sain¹tu¹wi¹. Nxe³sain¹nũ²la² khãuh³lxa³ti³sain¹ni² ĩ³wa³ka³si³sain¹ni² ye³ka³su³hẽ¹kxi² nxe³sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hã²wxãn³txa³ ĩ³ta³lo³wait1sain¹sãn²nũ²la² ĩ³su²lhã³sain¹tu¹wi¹. Nxe³ka³tu̱³ hã²wxãn³txa³ ye³ha¹li¹ ka³na³ki¹ a³lan²ni²sxã³ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nxa²ha¹te¹ a²sa³wi³ha³lxi³nũ̱³ka̱³txai²na² sa²kxai³lu² jau³jau¹xai²na² a²si³yxau³tãu³khai³xa² ã³ne³to³ti³hex1ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ĩ³ye³ta³lu²nain¹nũ²la² Je³ru³sa³lẽ²thĩ³nãn¹tĩh³na² ã³nxai³ain¹to³ta¹hxai²hẽ¹la². Nxe³nũ²la² Je³ri³ko²thĩ³na² ya̱u³son³tãu³a¹ a²nũ²a² ĩ³hat1txi³nyhain¹ta¹hxai²hẽ¹la². A²nxe³jah¹la² yen³kxa² ai³nxũ³nyhu¹te³lhxã³ ã³wxe³e²nyhu¹ta¹hxai²hẽ¹la². Ye³ha³nha²kxai³ hxi²kan¹txi³ yen³kxa² ĩ²sxã³ o²la³kxi²ta¹hxai²nxa³hẽ¹la². Hãi¹nxe³sxã³ tĩh³na² ne³ku̱²nxa² ã³yi¹ka³tu̱³ a²yen³kxa² ai³nxũ³sa²tẽ³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nxe³ha²kxai³la¹ a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² wxã³yain¹ju³ta² ain³kxai¹nha²kxai³ ĩ³wã̱³txain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: Ĩh¹te²ta̱n³yah³lxi¹nhã¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nxa²ha¹te¹ ĩ³wa²lũ³xain¹ti³an¹jau³kxai³lu¹: — Je³su²jah³la² Na³sa³re²thĩ³na² yxau²xai³jah¹lai²li² ã³wa²to²ka² wxã³tu¹wi¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nyhain¹nxa²ha¹te¹ kãin² ĩ³kaix1ti³ãn²jau³kxai³lu¹: — Je³su²jah³lĩ¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²kah³lo²si¹lxe¹. Nxĩ¹nha²kxai³ wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sẽ¹le¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nxe³nxa²ha¹te¹ a²nũ²a²nãu³xa² ne³ka³ta²a² wxã³ain¹te²nãu³xa² ĩ³ye³kxain¹te³nah¹lxi¹: — Ka³nahx2nxe³sẽ¹li¹. Ĩ³kaix1txa³hẽ¹li¹. Ain¹jau³su² nxe² ain³kxi²kxan²ti³ kãin² ĩ³kai¹xi²te³nah¹lxi¹: — Je³su²jah¹lĩ¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²kah³lo²si¹lxe¹. Nxĩ¹nha²kxai³ wi¹lhin¹sxã³ thãi³ti³la² sa²hau³kot3sẽ¹le¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nyhain¹nxa²ha¹te¹ Je³su²jah³la²kxai³lu² jau³jau¹xai²na² ain³kxi²tãu³a² ã³yit1ta² ai³ain¹sxã³ jah¹la² ã³sa²so¹sxã³ wxã³si¹hain¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu² ã³sa²so¹sxã³ wxã³ain¹nũ²la² ĩ³wã̱³txi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nxe³te³nah¹lxi¹: — Ĩh¹nxe³ju³ta̱³ kãi³ũh¹nxa²ha¹ju³ta³la³ ten³nxa²ji¹wi¹? Nxe³ha²kxai³lu¹: — Txa²hxi²kan¹jah¹lãi³. Ye³we²txi³san¹ju³ta² ten³sa³nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nxa²ha¹te¹ Je³su²jah³la²kxai³ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Ye³we²txi¹nxa²ha¹wi¹. Yxo²ĩ²sa¹nha²kxai³ hĩ¹na² ye³we²txi¹nxa²ha¹wi¹. Nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nxe³ju³tan¹te²kxa³ya̱³lhu² kwẽn¹tai²na¹ ye³we²nxi²ta¹hxai²hẽ¹la². Nxe³hĩ¹nãn¹te²tu̱³ Je³su²jah³la² ã³si³tẽ³kxi² Txa²wã¹sũ̱³na² ĩ³sa²nẽn¹kxi² nxe³ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³kxai³lu² a²nũ²a² yxo²ha³kxa¹ ye³we²txi²ju³ta² ĩ²ain¹tũ̱³ka̱³txa² Txa²wã¹sũ̱³na² sa²nẽn¹kxain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nxa²ha¹te¹ Je³ri³ko²thĩ³na² wxa²li³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nxe³ka³tu̱³ta¹ Sa³ke²ah³la² yen³kxih³khaix1jah¹lo²su² ta¹hxai²hẽ¹la². A²nũ²a² ũ³yho³hi²ki̱³kxa² so¹kxi²nẽ³tũ̱³ka̱³txa² a²hxi²kan¹jah³lo²su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A²nxe³jah¹la² hi²sen³su² Je³su²jah³la² ĩ²ti³ten³khai¹ta¹hxai²hẽ¹la². Nxe³yãn¹ta¹ kĩ³txi³ sa²nxũ²nxa³ha²kxai³ ĩ³hit2tain¹tũ̱³ka̱³txa² ka³lxa¹ai¹nha²kxai³ ã³yxe²ta³sin²thĩn²te³lha³ta¹ ã³nhi²ka¹tain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ai¹nha²kxai³lu¹ Sa³ke²ah³la²kxai³lu² ne³ka³ta²sxã³ ã³nih³nũ²la² Je³su²jah³la² ã³wa²to¹tĩh³na²nũ³a² ã³yit1ta¹hxai²hẽ¹la². Ã³yit1tũ²la² si³ko³mo²ra²nẽ³ka² ĩ³ka³la³sxã³ ya̱u³kxi²sxã³ wah³nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nxa²ha¹te¹ Je³su²jah³la² ã³wa²to¹kxa² wxã³nũ²la² sa²yxo²ka²la¹nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Sa³ke²ah³lãi³. Wa³su³txi³ ĩ³ka³nxi¹sẽ¹li¹. Wxa²sxi²ha² ã³wih¹ti³ten³khaix1sa³nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nxa²ha¹te¹ Sa³ke²ah³la²kxai³ wa³su³txi³ ĩ³ka³nxi²nũ²la² ĩ³ka³lih³nũ²la² sxi²ha² tẽ³sxã³ ã³wih²xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ã³wih²xi²nũ²la² kwa²ĩ²ain¹tũ̱³ka̱³txa² a²yxo²wãn³txi³su² nxe³te³nah¹lxi¹, hi̱³the³sot3tain¹te³nah¹lxi¹: — Je³su²jah³lai²li² a²nũ²a² ko̱³nxe³thin¹te²a² sxi²ha² yxau³kxain¹nĩn²tai¹. Nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nxa²ha¹te¹ Sa³ke²ah³la²kxai³ ĩ³sa²yxau³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Txa²yen³kxa² a²nũ²a² yen³kxi³txa²te²a² wã²nhũ¹ai¹na¹tu¹wi¹. Te²yã¹nxe³sxã³ a²nũ²a² yen³kxa² ka³na³ka³nat3sxã³ ĩ³ki³ha¹kxi²sxã³ kãi³kxi² so¹kxain¹na¹te²su² te²nãn²tu̱³ yen³kxa² ha¹li¹ ha¹li¹ nxe³ti³xa¹ ũ³hũ¹xai¹na¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu²: — Hĩ¹na²su² sxi²ha² thĩ¹nai²nãn¹tũ̱³ka̱³txa² ko̱³nxe³ti³ kãi³sxã³ yxau²xai³lain¹ju³ta² ã³wa²su¹tai¹na¹ju³ta² yũ²na³li¹, A³bra³ãu²ah³lu¹tai²na² a²ne³tah²nãu³su² ha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jã¹nxe³jut3su² a²nũ²a² ko̱³nxe³ti³ kãi³sxã³ yxau²xai³te²su² te²nãn²tu̱³ a²ẽ¹na² sa²hau³ko³tũh¹te³lhxã³ wxã³na¹hẽ³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nxa²ha¹te¹ ain³kxain¹tũ̱³ka̱³txai²na²: — Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² A²hxi²kan¹ta² Si³yxau³tãu³lot3ju³ta³nũ³su² nxe³jau³xa² wa³su³txi³ ya̱u³son³te²ji¹xã¹. Ain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ta¹ Je³ru³sa³lẽ²thĩ³na² ai³ain¹tãu³ãn²tu̱³ta¹ ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ĩ³ye³kxi²te³nah¹lxi¹: — A²nũ²a² ha³lo²a² yxau³nũ²nhai¹. A²nxe³jah¹la²kxai³lu² ĩ³ye³nha²nũ²nhai¹. Ĩ³ye³nha²te³nah¹lxi¹: “Ha³lo²a² u²ko³xa² a²si³yxau³kax3su² te²lo³sa²kxe³nũ³su² ã³nxai³te³lhxã³ nxa¹nha¹. Nxe³sa³kxai²nãn²tu̱³ hã²wxãn³txa³ ĩ³xi²na¹tũ¹xã¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nxe³ka³tu̱³ a²sa³wi³ha³lxa² 10 nxe³te²a² ka³lxa¹txi³ ĩ³kaix1so¹te³nah¹lxi¹: “Hĩ¹na² ai³na¹tu¹wi¹. Nxa¹ha²kxai³ ũ³yho³hi²ki³a² ki³ka³na³ka³nat3sxã³ ũ³hũ²xai³nx2ta¹tu¹wi¹. Nxe³nx2ta¹kxai²nãn²tu̱³ ai³na¹tãu³a² yen³kxa² so¹kxi²nyhu¹ah³lxin¹nũ²la² yen³kxa² ãh¹so¹kxi¹jxah³lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ ĩ³xi²na¹hĩ¹na¹ ĩ³hau³ko³ki̱³tu¹wi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nxe³tah¹lxa¹ ai³ain¹ka²si³yo³na² a²ka³lxa¹ti³khai³xa² sa²kxai³lu² ĩ³a̱n³ta³kxai¹nha²kxai³ u²ko³xai²na² a²si³yxau³ka³txa² sa²si¹hã³ain¹te³nah¹lxi¹: “Jah¹lai²li² a²si³yxau³kax3su² sain¹sĩn¹ju³ta² ten³sa²sĩn¹nxa³nhai¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nxa²ha¹te¹ kxãn³nãu³a² jah¹la²kxai³lu² a²hxi²kan¹jah¹la² son¹sxã³ wa̱³li²nũ²nhai¹. Wa̱³li³tãu³a² a²sa³wi³ha³lxa² ũ³yho³hain¹tũ̱³ka̱³txai³tã² ĩ³kaix1so¹xi²nũ²la² ũ³yho³hi²ki³ai³tã² hau³kot3si¹hain¹jau³su² ĩ³wã̱³txain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nxa²ha¹te¹ a²wi¹lhĩ¹nãn¹te²a² ĩ³ye³kxi²te³nah¹lxi¹: “Txa²hxi²kan¹jah¹lãi³. Ki¹ai²na² ũ³hũ¹san¹ki³ai³tã² o²la³kxi²na¹ka³tu̱³ hĩ¹na² ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ ki³ha¹li¹ 10 nxe³ki³a² so¹kxai¹na¹hẽ³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nxa²ha¹te¹ a²hxi²kan¹jah¹lai²na² a²wãn³txi³kxai³lu¹: “Wi¹na³li¹. Yen³kxa² kãi²nxa³te²a² ũ³hũ¹nxa²ha¹tai¹ti²tu³wi¹. Nxe³ju³tai²li² wi¹wa³kon³kxi²san¹ju³tan¹te²kxa³ya̱³lhu² hĩ¹na² sxi²je³na² ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ ye³ha¹li¹ 10 nxe³je³na² a²sxi²jen³na² ka³lxa¹je³na² a²wa³kxẽn³yah³lo²sin¹tu¹wi¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nxa²ha¹te¹ ã³ta³lo³hẽ²ti²jah¹lai²na² wãn³txi³kxai³lu¹: “Txa²hxi²kan¹jah¹lãi³. Ki¹ai²na² ũ³hũ¹san¹ki³ai³tã² o²la³kxi²na¹ka³tu̱³ hĩ¹na² ki³ha¹li¹ ki³ha¹li¹ ka³na³ki¹ so¹kxai¹na¹hẽ³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nxa²ha¹te¹ a²hxi²kan¹jah¹lai²na² a²wãn³txi³kxai³lu¹: “Wi¹wa³kon³kxi²san¹ju³tan¹te²kxa³ya̱³lhu² hĩ¹na² sxi²je³na² ye³ha¹li¹ ye³ha¹li¹ ka³na³ki² sxi²jen³na² ka³lxa¹je³na² a²wa³kxẽn³yah³lo²sin¹tu¹wi¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","A²sa²wi³sa² ã̱³xa² tĩ̱³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: “Txa²hxi²kan¹jah¹lãi³. Ki¹ai²na² ũ³hũ¹san¹ki³ai³tã² wã²la²ka³lo³a² wxa²wã³lã̱u²kxi²sã²na¹ka³tu̱³ kan²txi³ ũ³ha¹a¹hẽ³li¹. Ki¹ai³ta³lxi²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nxa¹ka³tu̱³ta¹ wxãi²na² ha²ya̱³kxa² yen³kxa² a³lxi²jah¹lo²sxa³lxi¹. Wa³ko³nxã³kxan²ti³ a²nũ²a² yen³kxa² kwa² sa²so¹nha²kxai³ hai³sxa² ũ³whĩ¹nxã³kxan²ti³ yain³txa² kwa² sa²so¹nha²kxai³ nxĩn¹tai¹ti²tu³wi¹. Nxĩ¹nha²kxai³ yu̱h³lxi³nxa²ha¹hẽ¹li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: “Wxãi²na² ko̱³nxe³thin¹khai¹nxi¹lxi¹.” Nxe² e²kxi³san¹jau³xi³na²sa¹: “Wxãi²na² sa²kxai³lu² ha²ya̱³kxa² yen³kxa² a³lxi²jah¹lo²sxa³lxi¹. Wa³ko³nxã³kxan²ti³ yen³kxa² kwa² sa²so¹nha²kxai³ hai³sxa² ũ³whĩ¹nxã³kxan²ti³ yain³txa² kwa² sa²so¹nha²kxai³ nxe³te²si¹lxi¹.” Nxĩn¹jau³su² san¹ten¹tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nxe³na¹ju³kxai³lu²: “Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ ki³ki¹ai²li² a²nũ²a² ũ³yho³hi²ki³a² o²la³kxain¹tũ̱³ka̱³txa² ũ³hũ¹ai¹nxã³thai¹li¹? Nxĩn¹ke³la³te²kxai³ ĩ³na¹tãu³a² ki³ka³lxa¹ti³lo³nhĩ̱³nx2na³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nxa²ha¹te¹ kwa²wxã³ain¹tũ̱³ka̱³txa² ĩ³ye³kxi²te³nah¹lxi¹: “Ki³ka³na³ka³nat3sxã³ tẽ³ain¹kxa² sa²so¹kxi²txai¹nhẽ³li¹. Sa²so¹kxi²sxã³ jah¹la² ki³a² hxi²ka² hxan³sxã³ ki³ai²na² hxi²tẽ³nha²jah¹la² ũ³hũ¹txai¹nhẽ³li¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nxe³nxa²ha¹te¹ tũ̱¹ka̱³txai²na² wãn³txi³kxai³lu¹: “Txa²hxi²kan¹jah¹lãi³. Jah¹lai²li² ki³ka³lxa¹txi³ 10 nxe² yũ³ten¹tu³wi¹.” Ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: “A²nũ²a² yen³kxih³te²na² ãh¹ kãi²non³sxã³ yen³kxa² ũ³hũ¹nyhain¹tu¹wi¹. Yxãn¹ta¹ a²nũ²a² yen³kxi³txa²jah¹la² yen³kxa² jũ¹nxe² yũ³kxan²ti³ sa²so¹xi²hxa³txain¹tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jã¹nxa¹ju³kxai³lu² ĩ³a̱n³ta³kxi²sain¹tũ̱³ka̱³txai³tã³ a²hxi²kan¹jah¹lo²su² ai¹na¹ju³ta³nũ³a² ã³ten³sai¹nxa³tũ̱³ka̱³txai³tã² tẽ³sxã³ wxã³jah¹lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ ti¹ai²na² sun²tã¹jah¹lxi³hẽ¹li¹.” Nxe³nũ²nhai¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ĩ³ye³ta³lun²nũ²la² Je³ru³sa³lẽ²thĩ³nãn¹tĩh³na² wa̱³lxa² ka³la³xi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nxe³nũ²la² wã³la² o³li³ve²ra³kat3su² ya̱u³son³ta¹hxai²hẽ¹la². A²nxe³ti³wa³kxa² sxi²jen³txa² thĩ³nha¹li¹ wã³la³ka³txa² yxo²yxau³ta¹hxai²hẽ¹la². Nxe³thĩn³txa² Bet3fa³je²thĩn³su² ha²kxai³ Be³tãn²ya³thĩn³su² ha²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","A²nxe³tãu³a² a²sa³wi³ha³lxa² ha¹li¹ sa²si¹hã³te³nah¹lxi¹: — Sxi²je³na² ha³ti³hi³nãu³a¹ ai³jah³hẽ¹li¹. Ya³hin¹kxai²nãn²tu̱³ ju³mẽn²ta² ka²va¹lhũ̱³nãn²ta² wẽ³sa² nxe³te²a² sa²tai³kxa²wxe³sain¹te²a² ĩ²yah³hin¹tu¹wi¹. A²nxe³te²a² ã³ka³ti³ya̱u³ai¹nhxai²nxa³hẽ³li¹. Nxe³te²a² sa²ta²la³kxi²so¹jah³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nxe³ya³hin¹te³na¹ a²nũ²a² nxe² ĩ³wã̱³txi³nx2ti³kxai²nãn²tu̱³: “Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ sa²ta²la³kxah³hin¹ji¹wi¹?” Nxe³nx2tain¹kxai²nãn²tu̱³ ĩ³wa²lũ³xain¹ya³hin¹ti³ãn¹jau³kxai³lu¹: “Txa²hxi²kan¹jah¹la² a²ten³jau³su² ha²kxai³ sa²si¹hã³sain¹sĩn¹na²li¹.” Nxe³txain¹ya³hẽ¹li¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nxa²ha¹te¹ ã³nxai³yah³nũ²la² ya²la³la¹ Je³su²jah³la² e³kxi²ya³jau³xa² yã¹nxa²sxã³ ha³lo²a² ĩ³ha¹txi²ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nxe³ha²kxai³ sa²ta²la³kxi²ya³tãu³a² ju³mẽn²ta² wẽ³sa² a²wa³kxẽ³nxa² wãn³txi³kxai³lu¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ sa²ta²la³kxi²ya³hin¹ji¹wi¹? Nxain¹ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Txa²hxi²kan¹jah¹la² a²ten³jau³su² ha²kxai³ sa²si¹hã³sain¹sĩn¹na²li¹. Nxe³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nxe² ĩ³ye³hau³ko³tũ²la² ju³mẽn²ta² wẽ³sa² sa²so¹sxã³ ã³nxi³xi²ya³ta¹hxai²hẽ¹la². Ĩ³xi²ya³tãu³a² wã²la²ka³lo³a² so¹sxã³ ũ³ka³ti³hẽt1ta¹hxai²hẽ¹la². Hã²wxãn³txa³ Je³su²jah³la²kxai³ ã³ka³ti³ya̱u³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nxe³nũ²la² ju³mẽn²ta² ã³ka³ti³ya̱u³sxã³ ai³tãu³a² a²sa³wi³ha³lxi³nãu³xa²kxai³lu² a²wã²la³ka³lo³khai³xa² tẽ³nũ²la² tĩh³na² ũ³ha¹sxa²xai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nxe³nũ²la² Je³ru³sa³lẽ²thĩ³na² ya̱u³son³nũ²la² o³li³ve²ra³ka³txa² a³ka³nxe³te³lhxã³ tãu³a¹ a²sa³wi³ha³lxa² ka³lxa¹khaix1nxe³tũ̱³ka̱³txa² ã³nhe²kxi²yain¹ta¹hxai²hẽ¹la². Txa²wã¹sũ̱³na² wã³nxĩn¹sxã³ o²la³kxi²ju³ta² ĩ²ai¹nha²kxai³ ka³li³hain¹jau³su² Txa²wã¹sũ̱³na² sa²nẽn¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nxain¹te³nah¹lxi¹: — Je³su²jah³la² ĩ³sa²nẽn¹kxi²a³sah¹lxi³wxi¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹lai²la¹wi¹. Nxe³ha²kxai³ oh³nãu³nũ¹ka³nãn¹tũ̱³ka̱³txa² wi¹lhin¹sxã³ yxau³ain¹tu¹wi¹, Txa²wã¹sũ̱³na² wi¹lhin¹sxã³ ĩ²ai¹nha²kxai³lu¹. Nxe³ha²kxai³ Txa²wã¹sũ̱³na² ĩ³sa²nẽ¹kxi¹jah³lxi³hẽ¹li¹. A²sa³wi³ha³lxai²na² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nxa²ha¹te¹ fa³ri³se²a² nũ̱³ka̱³txai²na² ĩ³kwa̱i²kxain¹te³nah¹lxi¹: — Je³su²jah³lãi³. Wxa²sa³wi³ha³lxa² ka³nahx2si¹hai¹nĩn¹jau³su² ĩ³kwa³na³txai¹nhẽ³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ĩ³ka³nahx2ain¹ke³la³te²kxai³ txah³lxa³kxa³txa² sa²kxai³lu² ĩ³kaix1txai¹nhĩ̱³nx2na³li¹. Txa²wã¹sũ̱³na² wi¹lhin¹jau³su² ĩ³sa²nẽ¹kxai¹nhĩ̱³nx2na³li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nxa²ha¹te¹ hã²wxãn³txa³ Je³ru³sa³lẽ²thĩ³na² ten³sa²tã³te³na¹ kãin² ĩ³ãin²ta³kxi²nha²ha²kxai³ ĩ³nã̱n³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ĩ³nã̱n³te³nah¹lxi¹: — Je³ru³sa³lẽ²tũ̱³ka̱³txi³ ĩ³nxãi³. Ko̱³nxe³ton³khai¹yxah³lxi¹lxi¹. Wxa²ẽ¹nãu³ai²na² sa²hãu²no³nx2ta¹ju³ta² yũ³nx2ti³hĩ̱³nx2na³li¹. Yxãn¹ta¹ hxi²kan¹txi³ ĩ²yah³lxi³hĩ̱²nxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yah²lxa³nha²kxai³ ye³jen¹na² ko̱¹ko̱n¹nũ̱³ka̱³txa² wxã³sxã³ ã³ki³wa³nũ³kxi¹nx2tain¹tu¹wi¹. Nxe³nx2tain¹kxai²nãn²tu̱³ hxi²kan¹txi³ a³li³si³kxah¹lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nxe³nx2tain¹kxai²nãn²tu̱³ti² wxa²nũ̱³ka̱³txa² a²yxo²ha³kxa¹ sun²tã¹nx2tain¹tu¹wi¹. Nxe³kxa²yu³ha² txah³lxa³kxa² ũ³hẽ²ta²ka³la³yah³lxin¹ki²a² yxo²ha³kxa¹ sa²nai¹ã³ain¹tu¹wi¹. Txa²wã¹sũ̱³na² kwẽn¹ta² wxã³nũh¹nx2ti³ju³ta² ã³ne³wxe³yah²lxa³nha²kxai³ nxe³nx2tain¹tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nxa²ha¹te¹ Txa²wã¹sũ̱³na² sxi²ha² ã³wih¹nũ²la² a²nũ²a² yen³kxa³ so¹kxi²nyhu¹tũ̱³ka̱³txa² ĩ²ain¹ta¹hxai²hẽ¹la². Ĩ²ka³tu̱³ta¹ a³li³si¹jau³su² yxo²xũ̱n³txi³ kwa³na³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kwa³na³ain¹te³nah¹lxi¹ Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxa² nxe³te³nah¹lxi¹: “Txa²sxi²ha² ĩ³ye³kxi²sah³lxin¹thĩ³nai²la¹wi¹.” Nxe³jau³su² tai¹ti²tu³wi¹. Nxe³yãn¹ta¹ yen³kxa² kãi³kxi²tũ̱³ka̱³txai²na² a²sxi²sin²ta²wi¹. Nxe³thĩn³su² sa²ne³yax1jah³lxin¹tai¹ti²tu³wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hã²wxãn³txa³ a³lan²ta² yxo²ha³kxa¹ thĩ¹nai²na² Txa²wã¹sũ̱³na² wãn³txa² ĩ³yau¹ũ³hain¹ta¹hxai²hẽ¹la². Nxe³yãn¹ta¹ wã³nxĩn¹ta² si³yxau³ka³te²nãu³xa² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²nãu³xa² a²nũ²a² a²hxi²kan¹txi³nãu³xa² nxe³sxã³ su²lhã³te³lhxã³ o²la³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ain¹tah¹lxa¹ ã³si³tẽ³kxi²tũ̱³ka̱³txai²li² kãin² ain³kxain¹ju³tan¹te²kxa³ya̱³lhu² ĩ³hxi²ka¹nyhain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nxa²ha¹te¹ ha³la³jen¹su² Txa²wã¹sũ̱³na² wãn³txa² wi¹jau³xa² ĩ³yau¹ũ³tãu³a² tũ̱¹ka̱³txai²na² a̱n³txi³tũ̱³ka̱³txai³ta³lxi² ã³nũ²kxi²nũ²la² aun³txa² tĩ̱³yain¹ta¹hxai²hẽ¹la², Txa²wã¹sũ̱³na² sxi²ha²sa³. ");
INSERT INTO nabNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tĩ̱³ain¹nũ²la² ĩ³ye³kxain¹te³nah¹lxi¹: — Ĩh¹jah¹lo²ta̱³ ĩ³sa²si¹hã³nxa²lhai¹li¹? Ĩh¹nxe² ĩ³hxi²ka¹txa²hĩ̱³te²la¹xã³? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Nxe³jah³lxi³wxi¹. Yau³xã̱³lxi³jau³xa² ĩ³wã̱³txi¹nx2ti³nũ³na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jo³ãu² Ba³tis²jah³lai¹tã² sa²kxai³lu² a²nũ²a² tẽ³sxã³ ĩ̱³ye³na² ũ³hũ¹kxi²sa²sai¹ain¹kxe³su² ĩh¹jah¹lo²ta̱³ ĩ³sa²si¹hã³ain¹thai¹li¹? Txa²wã¹sũ̱³nu²khai³xai²la³ ta̱³nxa² a²nũ²khai³xai²la³ ta̱³nxa² nxe² ĩ³yau¹ũ³jah¹lxi³txa²sã²nhẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nxa²ha¹te¹ hit3the³so³nyhain¹te³nah¹lxi¹: — Ĩh¹jau¹la³ta̱³ ĩ³wa²lũ³xi²ki̱³te³ji¹? Ki̱³sa²kxai³: “Txa²wã¹sũ̱³na² sa²si¹hã³ain¹nĩn²tai¹.” Nxe³ki̱³jau³su² nxe³ki̱³kxai²nãn²tu̱³ ĩ³wa²lũ³xi²nẽ³te³nah¹lxi¹: “Wain³na³li¹. Yxo²ĩ²txai¹yah³lxi³hẽ¹li¹.” Nẽn³jau³su². ");
INSERT INTO nabNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nxe³yãn¹ta¹: “A²nũ²a² hi²sen³su² sa²si¹hã³ain¹nĩn²tai¹.” Nxe³ki̱³jau³su² nxe³ki̱³kxai²nãn²tu̱³ ã³si³tẽ³kxain¹tũ̱³ka̱³txa² hi²sen³su² txah³lxa³kxa² hxi²tẽ³nha²sxã³ wha³tin³kxi²nẽ³lain¹tu¹wi¹, Jo³ãu² Ba³tis²jah³lai¹tã² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³jah¹lo²su² ye²yhai¹nha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nxe³ye²yhain¹jau³su² ha²kxai³ a̱n³txi³tũ̱³ka̱³txai²na² wãn³txi³kxai³lu¹: — Ĩh¹jah¹lo²ta̱³ ĩ³sa²si¹hã³ain¹te²la¹ku² sĩ¹na¹nhai¹. Ko̱³nxe³sĩ¹nxa³nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nxa²ha¹te¹ Je³su²jah³la²kxai³ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Nxe³kxai²nãn²tu̱³ ĩ³sa²si¹hã³sa³jah¹la² ĩ³yau¹ũ³nx2ti³nxa³lho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nxe²e³ta³lun²nũ²la² ĩ³yau¹ũ³jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Nxe³jah³lxi³sa²lxi¹. Hai³sxa² a²wa³kxẽn³yah³lo²su² nũ²nhai¹. A²hai³sxai²na² u²va²tẽ³kxa² ũ³whĩ̱¹nũ²nhai¹. Ũ³whĩ̱¹ta³lun²nũ²la² a²nũ²a² ã̱³xa² wi¹wa³kon³si¹hain¹jau³su² ũ³hũ¹ain¹nũ²nhai¹. Ain¹ka³tu̱³ hã²wxãn³txa³ ha³lo²a² u²lxan¹ko³xa² ã³nxai³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hã²wxãn³txa³ ã³ki³i²tãu³a² sa²kxai³lu² yain³txa³kxa² wã²nhu¹nyhu¹si¹jau³su² a²sa³wi³sa² sa²si¹hã³nũ²nhai¹. Yxãn¹ta¹ sa²hau³ko³tũ̱³ka̱³txa²kxai³lu² kãi³ye²ha²kxai³ wã²nhũ¹nyhai¹nxa³ke³tu̱³ hãi¹su²la³kxa² sa²wa²nyhain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nxa²ha¹te¹ a²sa³wi³sa² ã̱³xa² yain³ta³ka² wã²nhũ¹nyhu¹si¹jau³su² sa²si¹hã³xi²nũ²nhai¹. Yxãn¹ta¹ sa²hau³ko³tũ̱³ka̱³txa²kxai³lu² ĩ³wa̱it1txi²ha²kxai³ ko̱³nxe³ti³ ĩ³ãu²lxi²to³tha²kxai² nxe³nyhain¹nũ²nhai¹. Nxe³ka³tu̱³ wã²nhũ¹nyhai¹nxa³ke³tu̱³ sa²wa²nyhain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nxa²ha¹te¹ a²sa³wi³sa² ã̱³xa² sa²si¹hã³xain¹ta¹ hai³txi³ wet1txai¹nxa³ha²kxai³ ĩ³su²lain¹sxã³ kãin² ĩ³yĩx1tot3sxã³ so¹sxã³ ã³na¹ai¹nha²kxai³ ain¹nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ain¹nxa²ha¹te¹ a²wa³kxẽn³yah³la²kxai³lu² wã²nxũ̱h¹ha̱in³nha²te³nah¹lxi¹: “Ĩh¹nxe³ta¹lhon³kũ². Nxa¹nhai¹. Ãh¹ hĩ¹na² nũ¹ta²wẽ³sa³khai³xa² ĩ³sa²si¹hã³a¹tũ¹xã¹. Jah¹lai²na² so¹lxi³ yũ³na¹kxa² a³lxi²na¹kxa² sa²nẽn¹kxain¹kxi³sã¹.” Nxe³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yxãn¹tah¹lxa¹ sa²hau³ko³tũ̱³ka̱³txa²kxai³ wxã³yai¹nhĩ¹na¹ ĩ³ye³lain¹te³nah¹lxi¹: “Txa²wã¹wa³kxẽn³yah³la² ki³lha³lxa² wxãn³na²wi¹. Ĩ³su²lhã³a³sah¹lxi³wxi¹. Nxe³ki̱³kxai²nãn²tu̱³ hai³sxa² so¹kxi²ki̱³tu¹wi¹.” Nxe³lain¹jau³su². ");
INSERT INTO nabNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ĩ³su²lĩ³ya²lut1sxã³ sa²tã³nyhain¹nũ²nhai¹. Nxe³ain¹jut3su² ha²kxai³ a²wa³kxẽn³yah³la² ĩ³xi²tãu³a² ĩh¹nxe³ta³ kãi³te³ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ne³ka²sah¹lxi³wxi¹. A²wa³kxẽn³yah³lai²na² hi²sen³kxai³lu² ĩ³xi²kxai²nãn²tu̱³ tũ̱¹ka̱³txai²li² sun²tã¹sãn²ka³tu̱³ nũ̱³ka̱³txi³ ã̱³xa² sa²si³wẽ̱³no³tain¹tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ain³kxain¹tũ̱³ka̱³txai²na² a²wãn³txi³kxai³lu¹: — Nxe³sĩn¹txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Txa²wã¹sũ̱³na² wha²li¹txã³nxu¹tai²na² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³te³nah¹lxi¹: “Txah³lxa³kxa³txa² a²nũ²a² sxi²ha² ton³te²nũ̱³ka̱³txai²na² o̱³nxa³jau³su² ĩ³ye³kxain¹sxã³ so¹sxã³ ã³sxã³ ã³na¹ain¹ka³txa² kwẽn¹tai²na² si³ka³lah³ã̱³ka³khai³xa² hxi²kan¹khai¹nxe³ka³txa³lã̱²na³li¹.” Ũ³wha²li¹txã³nxu¹tai²na² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. Nxe³jau³xai²li² ĩ²yah³lxin¹ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nxe³ha²kxai³la¹ txah³lxa³kxa³txai²li² kwa²sa²tã³yu̱³to³kxai²nãn²tu̱³ kãin² ã³nĩ¹to³ta³lxi³hĩ̱³nx2na³li¹. Yxãn¹ta¹ txah³lxa³kxa³txai²li² ã³hi³sã³nhe¹ta²lxi³kxai²nãn²tu̱³ sa³txe̱¹ha²kxai³ ã³ya²lu¹txa²lxi³hĩ̱³nx2na³li¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nxa²ha¹te¹ ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txi²su² te²a² wã³nxĩn¹ta² si³yxau³ka³txe²nãu³su² te²a² ko̱³nxe³ti³ ĩ³yĩ¹li²hain¹jau³su² a³la³kxain¹ta¹hxai²hẽ¹la². Nxe³ju³tan¹te²kxa³ya̱³lhu²: — Wã²nũ³so¹sxã³ ũ³tĩ¹kxi²ki̱³te²ji¹xã¹. Ain¹tah¹lxa¹ a²nũ²a²nãu³xa² yu̱h³lxain¹jau³su² hi³ka¹nai¹nxa³ha²kxai³ hãi³a² wah³nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nxe³ha²kxai³la¹ kãin² ĩ³a̱n³ta³kxai¹nha²kxai³ a²sa³wi³ha³lxa² kwa³na³ain¹ta¹hxai²hẽ¹la². Kwa³na³ain¹te³nah¹lxi¹: — Jah¹lai²na² wãn³txa² hãi³a² ain³kxi¹jah³lxi³hẽ¹li¹. Wi¹lhin¹ki³lxo³nxe³jah³lxi³hẽ¹li¹. Nxe³sxã³ ki³han³jau³su² e³kxai²nãn²tu̱³ ĩ³hen³txi³sah¹lxi³hẽ¹li¹. Sah¹lxin¹kxai²nãn²tu̱³ Ro³ma²no² a²si³yxau³jah¹la² ĩ³ye³kxai¹na¹ka³tu̱³ ũ³tĩ̱¹kxain¹tu¹wi¹. Nxe³ju³ta² ten³sa²sĩn¹nhai¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nxa²ha¹te¹ sa²si¹hã³jah¹lai²na² wãn³txi³kxai³lu¹: — Je³su²jah³lãi³. Txa²wã¹hxi²kan¹jah¹lo²si¹lxi¹. Wãn³txa² ya²la³lyau³xa² e³jah¹lo²si¹lxi¹. Txa²wã¹sũ̱³na² wãn³txa² wain³txi³ ĩ³yau¹ũ³ai¹nhxai¹nhẽ³li¹. A²nũ²a² ĩ²li³te²a² ye³a̱n³txa³nih¹kxan²ti³ hxi²kan¹khaix1kxan²ti³ wxãi²na² yu̱h³lxi³jah¹lo²sxã³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nxĩ¹nha²kxai³ wãn³txa² wain³jau³xan²tu̱³ ĩ³yau¹ũ³sah¹lxi³sĩ¹nhẽ³li¹. Ro³ma²no² nũ̱³ka̱³txa² a²hxi²kan¹jah¹la² Se²sa³jah¹lo²su² a²nũ²a² ũ³yho³hi²ki³ai²na² ũ³hũ¹ain¹ki̱³ta̱³nxa² hãi¹nxã¹ta̱³nxa² ĩh¹nxe² wain³txi³ kãi³sĩn¹te³la¹ji¹wi¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nxa²ha¹te¹ Je³su²jah³la²kxai³lu² a²ẽ¹nãn¹jau³xa² a³la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ĩ³ye³kxi²te³nah¹lxi¹: — Ũ³yho³hi²ki³a² wã²nã³ũ¹sya¹hẽ¹li¹. A²nũ²a² ye³na² ũ³wha²li¹lain¹kxe³su² te²a² ĩh¹nxe³te²a² a²ye³nhũ̱³ji¹wi¹? Ĩh¹te²a² a²ĩ³lxi³su² ji¹wi¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ĩ³wa²lũ³xain¹ti³an¹jau³kxai³lu¹: — Se²sa³jah¹la² a²yen³su² ha²kxai³ a²ĩ³lxi³su² ha²kxai³ te²la¹wi¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Se²sa³jah¹la² a²yen³kxi³khai³xa² ũ³hũ¹yah³lxi¹nha²kxai³ Txa²wã¹sũ̱³na² a²yen³kxi³khai³xa² ũ³hũ¹yah³lxi¹nha²kxai³ nxe²xai³jah³lxi³hẽ¹li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nxe³ju³kxai³lu² wain³txi³ ĩ³wa²lũ³xi²ha²kxai³ a²nũ²a² ka³lxa¹txi³ yxau³yai¹nha²kxai³ hxi²kan¹txi³ ĩ³ki³han³si¹hai¹nxa³ha²kxai³ hãi¹sxã³ ka³nahx2sxã³ yxau²xai³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nxa²ha¹te¹ ĩ³ye³ta³lun²nũ²la² sa³tu³se²a² nũ̱³ka̱³txa² ã³wxã³ain¹ta¹hxai²hẽ¹la². Nxe³tũ̱³ka̱³txai²na² sa²kxai³lu² a²nũ²a² ya³lu²kxai²nãn²tu̱³ ka³te̱n³su² ĩ³sa²yxau³xi²ju³ta³nũ³a² yxo²ĩ²ain¹ta¹hxai²nxa³hẽ¹la². A²nxe³te²nãu³xa² ã³nhait1tũ̱³ka̱³txa² ã³tĩ̱³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ã³tĩ̱³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Je³su²jah³la² ĩ³tih³nxe³nẽ³jah¹lãi³. Ĩ³yau¹ũ³sa²sĩ¹nhẽ³li¹. Moi³se²ah³lu¹tai²na² wãn³txa² jau³xau³hxai²tẽx1ta² Sũ̱³na² wãn³txa² ĩ³yau¹ũ³nẽ³te³nah¹lxi¹: “In³txi³su² ya³lu²kxi²kxai²nãn²tu̱³ a²wẽ³ha³lxi³khai³xa² yũ²nxa³kxe³su² ha²kxai³ a²lon³yah³lai²na² sa²kxai³lu² a²txu¹ha² so¹nyha¹ta¹ka³lxai³tã² so¹nyha¹txai²li¹, a²lon³ya³lu²jxah¹la² ta²ha² wet1si¹jau³sa¹.” Moi³se²ah³lu¹tai²na² ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nxa²ha¹te¹ a²lon³ti³tãu³xa² ha¹li¹ ha¹li¹ ha¹li¹ ka³na³ki¹ yxau³ain¹nũ²nhai¹. A²hxi²kan¹te²a² txu¹ha² so¹ka³tu̱³ hã²wxãn³txa³ ye³jen¹na² ya²lu²nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nxe³ha²kxai³ wẽ³sa² yũ²nxa³ha²kxai³ a²lon³yah³la² so¹nũ²nhai¹. Nxe³nũ²la² in³txa² ya³lu²nũn³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hã²wxãn³txa³ a²lon³na² ã̱³xa² so¹kxi² ya³lu² nxe²xai³sxã³ a²lon³ti³tãu³xa² ya³lun¹txa²hxan³nũ²nhai¹. Yxãn¹ta¹ hxi²kan¹txi³ wẽ³sa² we¹txi²nyhai¹nxa³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hã²wxãn³txa³ txu¹hai²na² ya³lu²nũn³nũ²nhai¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jã¹nxe³ha²kxai³lu¹ yan¹nãu³a¹ ka³te̱n³su² ĩ³sa²yxau³xi²ki̱³tãu³a¹ ta¹ka³lxai²na² sa²kxai³lu² ĩh¹te²la³ta̱³ in³txa² wẽ³sãi¹ah³lo²khai³su² hĩ̱³te³ji¹wi¹, a²yxo²ha³kxa¹ so¹nha²xai³ain¹na²ha²kxai³lu¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ne³ka²sah¹lxi³wxi¹. Yu̱h³xan¹ta³nũ̱³ka̱³txa² in³txa² txu¹ha² so¹nyhai¹nhxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ai¹nha²kxai³ oh³nãu³nũ¹ka³na¹ Txa²wã¹sũ̱³na² hi²sen³su² a²nũ²a² sa²yxo²we¹txain¹te²a² ka³te̱n³su² ti³hi¹tai¹nhĩ¹na¹ so¹nyhu¹kxi³ju³ta² yũ²nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nxe³ha²kxai³ oh³xan¹ta² nũ̱³ka̱³txa² txu¹ha² so¹nyhu¹xa³ha²kxai³ ya³lu²ju³ta² yũ²nxa³ha²kxai² nxain¹te²ju²hẽ³li¹. Nxe³kxa²yã¹xain¹tu¹wi¹. Ya³lu²xain¹ju³ta² yũ²nxa³ha²kxai² ka³te̱n³su² ĩ³sa²yxau³xain¹ju³ta² yxau²sa²tẽ³ai¹nha²kxai² nxain¹tu¹wi¹, Txa²wã¹sũ̱³na² wẽ³ha³lxi³su² ti³hi¹tai¹nha²kxai³lu¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kxã³nxu¹tai²na² Moi³se²ah³lu¹tai²na² wãn³txa² ĩ³yau¹ũ¹nhẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. A²nũ²a² ya³lu²te²na² ka³te̱n³su² ĩ³sa²yxau³xi²si¹kxe³su² ĩ³yau¹ũ¹nhẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. Wãn³txu¹tai²na² hi³a² nxã³nxa² ka³te̱n³nxã³nxa² i̱³sa²tẽ³kxan²ti³ i̱³hxa³txa³kxe³su² nxe³jau³xu¹tai²nãn¹jau³xa² nxe³te³nah¹lxi¹: “Txai²na² A³bra³ãu²ah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ I³sa²kah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ Ja³ko²ah³la² Sũ̱³na² Si³yxau³kah³lo²sa¹ha²kxai³ hĩ¹na¹ nxe³te²sa¹wi¹.” Txa²wã¹sũ̱³na² nxe³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nxe³jau³su² ha²kxai³ ha¹li¹ ka³na³ki² jah¹lo²nãu³xai²na² ka³te̱n³su² yxau³ain¹na³li¹. Txa²wã¹sũ̱³na² a²sa³wi³ha³lxi³nãu³xa² yxo²ha³kxa¹ ka³te̱n³su² na³li¹. Kxã³nãu³u¹ta²kxai³ ya³lu²ain¹kxa²ha³ta̱³nxãn²tu̱³ hĩ¹na² ka³te̱n³sain¹na³li¹. Nxe³ha²kxai³ a²yxo²ha³kxa¹ ka³te̱n³su² ye²nx2tain¹na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nxa²ha¹te¹ ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txa² ĩ³ye³kxain¹te³nah¹lxi¹: — Wain³txi³ e³i¹lxi¹. Ain¹jau³su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ãu²lxa²to³nha²kxai³ ĩ³wã̱³txain¹kxe³su² ha²kxai³ hãi¹nxa¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³ai¹nhxai²na²hẽ³li¹. “Kris²tu³jah¹la² Ta³vi²yah³lu¹tai²na² a²ne³tah²nãu³ai²la¹wi¹.” Ain¹jau³su² hxai²na²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ain¹ta¹ Ta³vi²yah³lu¹tai²na² hain³jau³xu¹tai²nãn¹jau³su² nxe³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² Si³yxau³jah¹la² a²yxo²wãn³txi³kxai³lu² Txa²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la² ain³kxi²ti³an¹jau³kxai³lu¹: ‘Txa²wi¹nẽ³tãu³a² ã³wxe³txu¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nxĩn¹kxai²nãn²tu̱³ wxa²ko̱¹ko̱¹xa² a²yxo²ha³kxa¹ wxa²yu³hẽ³nãu³a² wa³ka³ti³lot3sxã³ ah³si¹hai¹na¹tu¹wi¹.’ Txa²wã¹sũ̱³na² Si³yxau³jah¹la² ta¹hxai²hẽ¹li¹.” Ta³vi²yah³lu¹tai²na² ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jã¹nxe³jau³su² Ta³vi²yah³lu¹tai²na² a²yxo²wãn³txa² a²hxi²kan¹jah¹lo²si¹ke³la³te²kxai³ ĩh¹nxe³sxã³ a²ta²lhot3hĩ̱³te²la¹xã³? Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nxe²e³ta³lun²nũ²la² a²yxo²o³tũ¹nũ²la² a²sa³wi³ha³lxa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Nxe³te³nah¹lxi¹: — Ha³te̱h³nxã³nxa² hoh³lxi³su² tũ̱³ka̱³txa² wi¹lĩ²jah¹lxi³hẽ¹li¹. Nxe³tũ̱³ka̱³txa² hi²sen³su² wã²la² a²lu²ka³lo³a² ũh³wih²kxi²nha²nũ²la² a²nũ²a² hxi²kan¹te²sa²ye²kxe³su² yxo²kwa̱i³no³tai¹nhxai²na²hẽ³li¹. Tĩh³na² sxi²je³na² nxũ²kwa̱i³ye³lo³tĩh³na² ã³nxai³tãu³a² wxi²kan¹te²sa²si¹nyhain¹jau³su² yxo²kwa̱i³no³tain¹nũ³nhxai²na²hẽ³li¹. Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³nai²na² ã³wxe³ka³lo³a² sa²nẽn¹nha²khaix1nxe³te²a² ã³wxe³ka³lo³a² yxo²kwa̱i³no³tai¹nha²kxai² a²nũ²a² ã³nũ²kxi²sxã³ yain³kxi²nyhai¹nhxai²na²hẽ³ nxe³tãu³a² te²yã¹nxe³sxã³ ã³wxe³ju³ta² sa²nẽn¹kxi²khaix1nxe³ta² ã³wxe³ka³lo³a² yxo²kwa̱i³no³tai¹nha²kxai² nxe³nyhai¹nhxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nxe³kxa²yu³su² txu¹ha² wha³te̱³son³ta¹ka³lxa² yen³kxa³ kãi³so¹kxi²te³lhxã³ nxe³ai¹nhxai²na²hẽ³li¹. Nxe³ain¹tãu³a² Txa²wã¹sũ̱³na² yau³ka³lxa¹txi³ wi¹le³kxi²ki³lxo³xai¹nhxai²na²hẽ³li¹. Ain¹ta¹ ain³kxi²nyhai¹nxa³lho³li¹. Kxãn³nãu³a¹ ko̱³nxe³khai¹nxe³sxã³ ĩ³yĩ¹li²nu¹hain¹tu¹wi¹. Yxãn¹ta¹ nxe²kãi³ai¹nxa³tũ̱³ka̱³txa² ko̱³nxe³ti³ ĩ³yĩ¹li²nu¹hain¹ju³ta² kũ³we²ki²la² kãi²nxa³lho³li¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ĩ³ye³ta³lun²nũ²la² a²nũ²a² yen³kxih³te²nãu³xa² ĩ²ta¹hxai³hẽ¹la². Kai²syẽ¹na² ũ³yho³hi²ki³a² ũ³whi¹ye²tũ̱³ka̱³txa² yxau³sxã³ ĩ²yxau³ta¹hxai²hẽ¹la². A²nũ²a² yen³kxih³khaix1te²a² wxã³nũ²la² ki³ka³lxa¹txi³ ũ³whi¹yhe²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nxe³ain¹tãu³a² txu¹ha¹ka³lxa² wha³te̱³son³ta¹ka³lxa² yen³kxi³txa²ta¹ka³lxa² wxã³nũ²la² ki³jũ¹lxi³ki³a² ki³ha¹li¹ ũ³whi¹yhe²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Nxe³ju³kxai³lu² ĩ²nũ²la² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ²sah¹lxi³sã²lxi¹. Ta¹ka³lxai²li² ki³kãi²lxi²nxa³kxe³su² kxan²ti² Txa²wã¹sũ̱³na² yen³nãu³a² a²yo³ha² kãin²ye²na³li¹. Yxãn¹ta¹ a²nũ²a² ã̱³xa² a²yo³ha² kãin²ye²nxa³wi¹. Nxe³ju³tai²li² yen³kxih³tũ̱³ka̱³txa² a²wã³kon³ki³a² so¹lxi³ ũ³whih¹ye²ain¹na²li¹. Yxãn¹ta¹ ta¹ka³lxai²li² hãi¹ki³li³ ũ³whi¹yhe²na²li¹. Nxe³ha²kxai³ a²yo³ha² kãin²ye²na³li¹, ta¹ka³lxa²su¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xa² hi²sen³kxai³lu² Txa²wã¹sũ̱³na² sxi²ha² ĩ²nũ²la² e³lxi³ain¹te³nah¹lxi¹: — Txah³lxa³kxa² wi¹lũ³hẽ¹ti² wi¹lũ³wha²li¹li² nxai¹nĩn²tai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ĩ²sah¹lxi³sã²lxi¹. Txah³lxa³kxa² wi¹lhau³kot3thẽx1je¹nxain¹nĩn²tai¹. Nxe³kxan²ti³ kxãn³nãu³a² txah³lxa³kxa² a²yxo²ha³kxa¹ sa²nai¹ain¹tu¹wi¹. Hai³txi³ ka³tha¹li¹ ã³ne³hẽ²kxi²ka³txa² yũ²nx3tho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nxa²ha¹te¹ ĩ³wã̱³tain¹te³nah¹lxi¹: — Je³su²jah³la² ĩ³tih³nxe³sa²jah¹lãi³. Ĩ³yau¹ũ³sa²sĩn¹nhẽ³li¹. Ĩh¹nxe³hĩ¹na² sa²nai¹ain¹te³ji¹wi¹? Ĩh¹nxe³ti³wa̱³kxa² ya̱u³son³sxã³ wi¹ko̱³nha²hĩ̱³ki̱³te³ji¹wi¹? Nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Wi¹lĩ²nha²khai¹nxe³jah¹lxi³hẽ¹li¹. Ĩ³ki³ha¹kxi¹nx2ti³ha³tai¹. Nxe³ha²kxai³ a²nũ²a² ka³lxa¹te²a² wxã³sxã³ ki³han³jau³su² e³yah³lxi³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹.” Nxe³jau³su² e³yah³lxi³to³hi²: “Hĩ¹na² wxã²na³li¹.” Nxe³jau³su² e³yah³lxi³to³hi² nxe³nx2tain¹kxai²nãn²tu̱³ wet1txai¹yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jã¹nxa¹jau³su² ti¹na² yxau³tũ̱³ka̱³txi³nãu³xai²na² kãin² ã³nhe¹kxi²nyhu¹sxã³ su²lhã³nyhain¹kxai²nãn²tu̱³ nũ¹ka³na¹ u²tãu³ai³tã² yxau³tũ̱³ka̱³txi³nãu³xai³tã² kãin² ã³nhe¹kxi²nyhu¹sxã³ su²lhã³nyhain¹kxai²nãn²tu̱³ nxe³jau³xa² ain³kxi²yah³lxin¹kxai²nãn²tu̱³ ĩ³yu̱³lyhah³lxi³txa³hẽ¹li¹. Ya²la³lyau³su² kxan²ti³ hai³txi³ hĩ¹nãn²tu̱³ ha³lo²ai²nãn²tu̱³ ne³ki³so³nx3tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nxe³sxã³ a²nũ²a² nũ̱³ka̱³txa² a²nũ²a² nũ̱³ka̱³txi³ ã̱³xa² a²lhun³tu² ã³nhe¹kxi²nyhai¹nha²kxai³ a²hxi²kan¹ta² si³yxau³tãu³a¹ a²hxi²kan¹ta² si³yxau³tãu³ ã̱³xa² a²lhun³tu² ã³nhe¹kxi²nyhu¹ha²kxai³ nxe³nyhain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ha³lo²a² kxĩh³nxa² sa²wi¹win¹nũh¹lxi²ha²kxai³ ĩ³ta³ka³txa² kãin² wxã³nũh¹lxi³ha²kxai³ a²nũ²a² sxi²je³na² ka³lxa¹je³na² yain³txi³ txa²khaix1nxe³sxã³ he³ja²lun¹ti³ha²kxai³ oh³sĩ̱n³nãu³a² ĩ³yo²la²ti³ju³ta³nũ³a² yũ³ye²ha²kxai³ nxe³ju³tan¹te²kxa³ya̱³lhu² kãin² yu̱h³lxain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yxãn¹ta¹ wxã²nxa³ta̱³lxa¹ a̱n³txi³tũ̱³ka̱³txa² i³nx2tain¹sxã³ ye³khãuh³la³thi¹nx2tain¹tu¹wi¹. Ju³te²a² nũ̱³ka̱³txa² ã³nũ²kxi²thĩ³na² ã³yũ³nx2tain¹nũ²la² ũ³tĩ̱¹kxi¹nx2tain¹tu¹wi¹. Ha³lo²a² a²wa³kxẽn³ti³nãu³xa² ko̱³nxe³ti³ ĩ³yĩ¹li¹nx2tain¹tu¹wi¹. Txa²wãn³txa² kan²txi³ yxo²ĩ²sah¹lxi¹nha²kxai³ a²nũ²a² nũ̱³ka̱³txi³nãu³xa² ĩ³a̱n³ta³kxi¹nx2tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nxe³nx2tain¹kxai²nãn²tu̱³ a²ya³la³tu̱³jau³xa² sa²yxo²wet1sah²lxin¹jau³xa² ĩ³yau¹ũ³hain¹yah³lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yah³lxi¹nha²kxai³: “Ĩh¹nxe³ju³ta̱³ wa³lxĩ³nha¹lhon³ku².” Nxe³jau³xa² ĩ³ye³kxah²lxi³txa³hẽ¹li¹. Hxi²waun³jah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yxãn¹ta¹ ĩ³wã̱³txi¹nx2ti³hĩ¹na¹ txa²wãn³txi³khai³xa² ũ³hũ¹nx2ta¹tu¹wi¹. Na¹kxai²nãn²tu̱³ wxa²ko̱¹ko̱n¹nũ̱³ka̱³txa² wãn³txai²na² e³yah³lxin¹jau³xai²na² ain³kxain¹kxai²nãn²tu̱³ hxi²kan¹txi³ e̱n²nhai¹nxa³sxã³ ĩ³wa²lũ³xi²nx2txai¹nxa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nxe³kxa²yu³su² wxa²nũ̱³ka̱³txi³khai³xa² a̱n³ta³kxi²nx2tain¹tũ̱³ka̱³txa² hxi²ki³kxai³ ã³yãu³hũ¹nx2tain¹tu¹wi¹. Wxa²wĩ³na² ta̱³nxa² wxa²lon³txi³tãu³xa² ta̱³nxa² wxa²wã³tã̱³xa² ta̱³nxa² kwa²ya̱³lxi²tũ̱³ka̱³txi³su² ta̱³nxa² nxe³sxã³ ã³ke³tũ¹nx2tain¹sxã³ sun²tã¹nx2tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nxe³hĩ¹nai²na² yxo²ĩ²sah¹lxin¹ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² yxo²ha³kxa¹ ĩ³a̱n³ta³kxi¹nx2tain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nxe³nx2tain¹kxan²ti³ wxa²ne³kĩ̱³sa² ka³na³ka³na³kxan²ti³ tĩ̱¹kxi¹nx2ti³xa³lho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ya³nãn³ta³ki²la²sxã³ yxo²ĩ²yah³lxin¹kxai²nãn²tu̱³ ya³lu²yah³lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nxa²ha¹te¹ a²nũ²a² a̱n³txi³tũ̱³ka̱³txai²na² wxã³hĩ¹na¹ Je³ru³sa³lẽ²thĩ³na² ã³ki³ka³ti³ki²txai¹nhi¹na¹ sxi²je³nãn²ta³ sa²nai¹ain¹ju³ta² ya̱u³son³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nxe³kxai²nãn²tu̱³ Ju³te²a²ko³xa² yxau³te²su² te² ĩ³nxa² wã³la² kĩ³ka³txa² ã³nih³jah¹lxi³hẽ¹li¹. Sxi²je³na² yxau³te²su² te² ĩ³nxa² ã³naun³tih¹jah³lxi³hẽ¹li¹. Te²yã¹nxe³sxã³ ha³lo²a² ã³nxai³te²su² te² ĩ³nxa² a²sxi²khai³xa² wa̱³li¹yah³lxi³txa³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","A²nxe³hĩ¹na² ko̱³nxe³ti³ kãi³te²nãu³xa² ta³lan²txai²na² ye³khãuh³lxa³thi¹nyhain¹kxi³ai²la¹wi¹. Nxe³ju³ta²nũ³a² Txa²wã¹sũ̱³na² ũ³wha²li¹txãn³nxu¹tai²na² kxãn³nxãn¹txã³nxu¹tai²na² ĩ³ye³kxũ¹nẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nxe³ha²kxai³ txu¹ha² wẽh³nhain¹te²su² te²na² kãin² khãuh³nxain¹tu¹wi¹. Txu¹ha² a²wẽ³sa² ũ³hi³lain¹te²su² te²na² kãin² khãuh³nxain¹nũn³tu¹wi¹. Nxe³kxa²yu³su² Txa²wã¹sũ̱³na² hi²sen³su² I³sa³e² nũ̱³ka̱³txa² ko̱³nxe³ti³ kãi³ain¹kxa²yo³ha² ko̱³nxe³ti³ ĩ³yĩ¹lai¹nha²kxai³ ha³lo²a² yxo²ha³kxa¹ ko̱³ton³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jã¹nxe³ju³ta² ã³nhe¹kxi²sxã³ sun²tã¹sxã³ ya³lu²ai¹nha²kxai³ Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³xa² hi²sen³su² a²nũ²a² sa²so¹sxã³ ha³lo²a² u²lxan¹ko³xa³nãu³xa² kan²txi³ ũh³wxe³ha²kxai³ nxe³ain¹ta¹hxai²hẽ¹li¹. Nxe³nũ²la² tũ̱¹ka̱³txai²li² Je³ru³sa³lẽ²thĩ³na² ã³wih¹nũ²la² yxau²sa²tẽ³ain¹tu¹wi¹. Hã²wxãn³txa³ wa³ka³to³nain¹ju³ta² ne³ki³so³nain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jã¹nxe³ju³kxai³lu² u³je³na³ki³su² te²a² i³la³kxi³su² te²a² hi³ka²ta³su² te²a² sa²ne³yax1tain¹tu¹wi¹. Ĩ̱³ye³na² kãin² hxa³lxi²ha²kxai³ a²nũ²a² hxi²ka̱u³ka̱u³nhain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A²nxe³ju³kxai³lu² a²nũ²a²nãu³xai²li² ĩ²ai¹nha²kxai³ yu̱h³lxi³ya²lun¹tain¹tu¹wi¹, o³sĩ̱³na² ko̱¹ko̱¹sa²ye²kxe³su² ĩ³ã̱³lxi³si¹ha²kxai³la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Hã²wxãn³txa³ oh³sĩ̱n³nãn¹ka³lo³a² hãn³ta³ka³lo³a² whãi²na¹ ãn³ka³nxi²na¹ka³tu̱³ wxã³na¹tu¹wi¹. Nũ̱³kxũn³txi³ ĩ³kĩx3khai¹nxe³ha²kxai³ wxã³na¹tu¹wi¹. Wxã³na¹ju³tai²nãn²tu̱³ a²nũ²a² yxo²ha³kxa¹ ĩ²sain¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ju¹tai²li² ã³si³wxe³hĩ¹na¹ ĩ³sa²yxau³sxã³ sa²yxo²ka²la¹nha¹jah³lxi³hẽ¹li¹. Txa²wã¹sũ̱³na² sa²yxo²we¹tai¹yah³lxin¹tũ̱³ka̱³txe² ĩ³nxai²na² ã³wa²su¹jah³lxin¹ju³ta³nũ³a² ti³wa³ki³lon³tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nxe³ha²kxai³lu¹ ĩ³yau¹ũ³jau³xa² ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Te²yã¹nxe³jut3su² sa³wxe³na² ĩ²jah¹lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ta³kon³ta³ki³yãu³su² ha̱u³ta³lun²sxã³ ãn³ki³i²nha³na¹nxe³hĩ¹na¹ yxo²kwẽ³kon³ju³ta² ya̱u³so³nhĩ̱³nx2na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Te²yã¹nxe³ju³kxai³lu² ju¹tai²na² ĩ³yau¹ũ¹nx2ta¹ju³tin³ti² ĩ²yah³lxi¹nhĩ¹na¹ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²ju³ta³nũ³su² yũ³tu¹wi¹. Nxe³sxã³ wa³su³txi³ wxã³na¹tu¹wi¹. Hi³yãu³sa³kxa² ha̱u³ta³lun²sxã³ ãn³ki³i²nha²ti³hũ̱³nxe² wa³su³txi³ wxã³na¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ya²la³tu̱³ e³kxi¹nx2ta¹wi¹. Ju¹tai²na² ĩ²yah³lxin¹kxai²nãn²tu̱³ hĩ¹na² ka³te̱n³su² tũ̱³ka̱³txa² ya³lu²ai¹nxa³ta̱³lxa¹ jau¹xai²na² yxo²ha³kxa¹ kãi³ta³lun²tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Oh³nãu³nũ¹ai²na² hxa³ni² ha³lo²a² yuh³xai²na² hxa³ni² nxe³ain¹tu¹wi¹. Nxe³yãn¹ta¹ txa²wãn³txa² so¹lxi³ ya²la³tu̱³ yxau²sa²tẽ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nxe³jut3su² wi¹lĩ²jah¹lxi³hẽ¹li¹. Wxã³na¹ju³ta² o²nx2ta¹kxa²ya̱n³txi³su² nxa¹nhai¹. Kãin² ĩ³yai³ni² kãin² ĩ³na²sxã³ we¹ni² kãin² hxi²waun³txi² nxe³yah³lxi³txa³hẽ¹li¹. Nxe³ha²kxai³ wi¹lĩ²syah²lxan³kxai²nãn²tu̱³ ka³yxuh³xa² ta³lã²la² wi³kxai²nãn²tu̱³ wa³su¹txi³ ũ³tĩ¹kxi²te²ju²hẽ³li¹. Nxe³ju³ta² yã¹nxe² wxã³na¹ju³ta² wa³su³txi³ yũ³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nxe³ju³tai²li² a²nũ²a² yuh³xa² yxau³tũ̱³ka̱³txa² yxo²ha³kxa¹ ĩ²kxi²sah²lxin¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wi¹lĩ²jah¹lxi³hẽ¹li¹. Txa²wã¹sũ̱³na² ĩ³nũ³kũ̱n³nxe³lhi¹hah³lxin¹jau³su² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. Yah³lxin¹kxai²nãn²tu̱³ ju³ta² ã³wa²to¹ta³lun²ka³tu̱³ hã²wxãn³txa³ Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² wxa²yen³nãu³a² ĩ²sah¹lxin¹tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","A²nxe³tãu³a² a³lan²ta² hãi¹nxe³ti³xa¹ Txa²wã¹sũ̱³na² sxi²ha² ai³nũ²la² a²nũ²a² ĩ³yau¹ũ³to³ta¹hxai²hẽ¹la². Nxe³yãn¹ta¹ ka³nxah³ta² hãi¹nxe³ti³xa¹ a³li³nũ²la² O³li³ve²ra³ka³txa² ka³la³to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ai¹nha²kxai³ ĩ³yũ¹li²nxa³ta̱³lxa¹ a²nũ²a²nãu³xa² ka³lxa¹khaix1nxe³sxã³ Je³su²jah³lai²na² wãn³txa² ain³kxi²te³lhxã³ ha²kxai³ Txa²wã¹sũ̱³na² sxi²ha² ã³wi¹hain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nxa²ha¹te¹ Pas²kwa²nxe³tũ̱³xa² yai³nain¹ju³ta³nũ³a² ya̱u³son³ta¹hxai²hẽ¹la². A²nxe³ti³xai²na² kxã³nhxĩ¹nu¹tai²na² Txa²wã¹sũ̱³na² hi²sen³kxai³lu² I³sa³e² nũ̱³ka̱³txu¹tai²na² ã³non²ta³kxi²ta¹hxai²hẽ¹la². Nxe³hĩ¹nãn¹te²tu̱³ kwẽ³kon³kxa² hãi¹nxe³ti³xa¹ ye³ka³na³ka³nat3sxã³ Sũ̱³na² kãi³ũ¹hain¹ju³tu¹tai²na² ã³sa²wa²lho¹xi²yhain¹ta¹hxai²hẽ¹la². Nxe³tãu³a² yain³txa² wa²lo¹lo¹nxa³tũ̱³xa² ĩ³wa¹kxi³la³ sa³wi¹hxa³tũ̱³xai²na² so¹lxi³ yai³nain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jã¹nxe³ju³kxai³lu² Pas²kwa²nxe³ti³xa² ya̱u³son³ti³xa² a²nũ²a² ko̱³nxe³thin¹sxã³ kãi³ain¹ta¹hxai²hẽ¹la². Wã³nxĩn¹te²a² si³yxau³tãu³a² nxe³te²nãu³xa² ha³te̱h³nxã³nxa² hoh³lxi³su² te²nãu³xa² nxe³tũ̱³ka̱³txai²na² ko̱³nxe³thin¹sxã³ he³son³kxi²nyhain¹ta¹hxai²hẽ¹la². Nxe³ain¹tah¹lxa¹ Je³ru³sa³lẽ²thĩ³nãn¹tũ̱³ka̱³txa² ĩ³a̱n³ta³kxi²nyhain¹kxa²ya̱n³ti³su² yu̱h³lxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nxa²ha¹te¹ nxe³nyhain¹ti̱³kxai³lu² Ju³ta²sah³la² Is³ka³ri³o²jah³la² ĩ³yĩ¹lih²nũn³jah¹la² nxe³te²a² Sa³ta³na²jah¹la² hi²sen³su² ã³si³tẽ³kxi²ta¹hxai²hẽ¹la². A²nxe³jah¹la² Je³su²jah³la² a²sa³wi³ha³lxi³su² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²tũ̱³ka̱³txi³su² nxe³tau³ta² ka³na³ka³na³jah¹lo²su² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A²nxe³sxã³ Sa³ta³na²jah¹lai²na² ã³si³tẽ³kxi²jah¹la² hi²sen³kxai³lu² ã³nxai³tãu³a² wã³nxĩn¹te²a² si³yxau³kxa³te³nãu³xa² te²a² Txa²wã¹sũ̱³na² sxi²ha² a²so³ta²to² nũ̱³ka̱³txi³su² te²a² nxe³sxã³ ã³yã³nũ²kxi²nhyain¹ta¹hxai²hẽ¹la². Nyhain¹sxã³ ĩ³ye³kxi²nyhain¹te³nah¹lxi¹: — Je³su²jah³la² ã³yãu³hũ¹nx2ta¹tu¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nxa²ha¹te¹ jau³jau¹xai²na² ain³kxain¹nxa²ha¹te¹ ka³li³hai¹nha²kxai³ ũ³yho³hi²txã³nxa² ũ³hũ¹kxi³nũ³su² e³hau³ko³nye²nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nxe³jau³xai²na² Ju³ta²sah³la²kxai³lu² ain³kxi²nũ²la² ka³lih³kxi²la²nha² e³kxi²te³nah¹lxi¹: — Wi¹na³li¹. Jah¹lai²li² ã³yãu³hũ¹nx2ta¹tu¹wi¹. Nxe² ĩ³he³son³kxi²nyhain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² Je³su²jah³la² ã³yãu³hũ¹te³lhxã³ yxai¹nha²kxai³ hãi³a² wahx3nxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nxa²ha¹te¹ Pas²kwa²nxe³tũ̱³xa² wa³lo¹lo¹nxa³tũ̱³xa² yai³nain¹nxe³je³nãu³wa³ka² ye²ain¹ti³xa² o³ve²a² wẽ³sa² su²lain¹ti³wa³kwe³nxa² yxau³son³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nxe³hĩ¹na¹ Je³su²jah³la² hi²sen³kxai³lu² Pe²jah³lo²su² te²a² Jo³ãu²ah³lo²su² te²a² nxe³sxã³ sa²si¹hã³te³nah¹lxi¹: — Pas²kwa²nxe³tũ̱³xa² yain³ki̱³thĩ³nũ³a² sa²hau³kot3ja¹hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nxa²ha¹te¹: — Ĩh¹nũ¹ãn¹thĩn³ta̱³ yain³kxi³thĩ³nũ³a² sa²hau³kot3sĩn¹te³la¹ji¹wi¹? Nxe³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ĩ²sah¹wxi¹. Sxi²je³na² ã³nxai³ja¹hu¹li¹. Nxe³ya³hin¹tãu³a² in³txa² ĩ³ha¹txi¹nx2ti³tu¹wi¹. Nxe³jah¹la² ĩ̱³yau³xẽ¹na² ũ³whi¹so¹tẽ³na² sa²ka³la³ki²wxe³kxi²so¹nyhe¹nx2ti³tu¹wi¹. Nxe³jah¹la² ĩ³hi²txi¹ja¹hẽ¹li¹. Sxi²ha² wi³xi²thĩ³na² ã³wih²kxi¹ja³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ya³hin¹kxai²nãn²tu̱³ sxi²ha² a²wa³kxẽ³nxa² ĩ³ye³kxi²ya³hin¹te³nah¹lxi¹: “Txa²wã¹yah³la² ĩ³ye³kxi¹nxa²si¹sa²sĩn¹jau³su² sa²si¹hã³sa²sĩn¹na²li¹. ‘Ĩh¹thĩn¹ta̱³ Txai²nãu¹xai²na² Pas²kwa²nxe³tũ̱³xa² yai³na¹thĩ³nu³la³sĩn¹te²la¹xã³?’ Nxe³sa²sĩ¹nhẽ²li¹.” Nxex3ja¹hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ya³hin¹kxai²nãn²tu̱³ oh³xan¹thĩ³na² kãin²thĩ³na² wi¹thĩ³na² wã²na³ũh¹nx2ti³tu¹wi¹. Nxe³thĩ³na² wi¹lhau³kot3ja¹hẽ¹li¹. Je³su²jah³la²kxai³lu² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ĩ³ye³ta³lun²nũ²la² a³li³xi²ya³ta¹hxai²hẽ¹la². Nxe³ya³ha²kxai³ wãn³txa² e³kxi²jau³xa¹ yxo²ha³kxa¹ ĩ²hxat3ja³ta¹hxai²hẽ¹la². A²nxe³thĩ³nãu³ai²na² Pas²kwa²nxe³tũ̱³xa² sa²hau³ko³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nxa²ha¹te¹ ha³lo²a² ã³nhau³hau³kot3hĩ¹na¹ Je³su²jah³lai²na² sa²kxai³lu² a²sa³wi³ha³lxi³nãu³xa² hxi²ka² hxan³sxã³ ha¹li¹ wxa²sa²so¹xi²nũn³tũ̱³ka̱³txa² ã³sa²so¹nũ²la² thĩ¹nai²na² ã³wi¹hain¹ta¹hxai²hẽ¹la². Ã³wi¹hain¹nũ²la² me²sa²ka³lo³a² ã³wxe²xai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Khãuh³lxa³ti³sxã³ su²lhã³sain¹ju³ta² ti³wa³ki³lon³na³li¹. Nxe³sa²ju³kxai³lu² sai¹nxa³ta̱³lxa¹ Pas²kwa²nxe³tũ̱³xa² yain³ki̱³ju³ta² yxo²kwa̱in³khaix1sa³hẽ²li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nxe³tũ̱³xa² nxe³tũ̱³xa²yã¹nxe³tũ̱³xa² ãh¹lxi³sxã³ wa³su³txi³ ĩ³yai³nxi²ki̱³sxa³lho³li¹. Kxãn³ton³tãu³a² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³su² ã³si³wxe³hĩ¹na² jã¹nxũ³na¹tu¹wi¹. Nxe³hĩ¹na² Pas²kwa²nxe³ju³ta² yain³kxi²jau³xu¹tai²na² ta³lu²nhxa³tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nxa²ha¹te¹ Je³su²jah³la²kxai³la¹ ĩ³na²kxẽ¹na² hxi²tẽ³nha²nũ²la² Txa²wã¹sũ̱³na² ĩ³wi¹lxon³kxi²si¹jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Nxe³nũ²la² a²sa³wi³ha³lxi³nãu³xa² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩ³na²kxẽ¹na² tẽ³sxã³ ĩ³na²xai³jxah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nxe³yãn¹ta¹ nxe³kxa²yã¹nxa¹ju³ta² ĩ³na²kxi³jau³xa² wa³su³txi³ ĩ³na²xi²nxa³lho³li¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²hĩ¹na¹ ĩ³na²xi²yah³lxi³ki̱³tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hã²wxãn³txa³ yain³tũ̱³xa² hxi²tẽ³sãn²nũ²la² Sũ̱³na² ĩ³wi¹lxon³kxi²si¹jau³xa² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Nxe³sãn²ka³tu̱³ a²sa³wi³ha³lxa² wã²nãu²lxi²sxã³ ũ³hũ²xai³ain¹ta¹hxai²hẽ¹la². Ũ³hũ²xai³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Yain³tũ̱³xai²na² Txa²nũ²a² yã¹nx2na³li¹. Ya³lu²kxi²nũh¹nx2ta¹tu¹wi¹. Yain³tũ̱³xai²li² ya³lu²kxi²nũh¹nx2ta¹kxa² ĩ²xi²sah¹lxin¹tũ̱³xai²li² yain³nũh¹sah¹lxi³to³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Te²yã¹nxe³sxã³ yain³ta³lun²ka̱³tu̱³ hã²wxãn³txa³ ĩ³na²kxẽ¹na² ũ³hũ¹ain¹te³nah¹lxi¹: — Ĩ³na²xai³jxah³lxi³hẽ¹li¹. A²nxe³jau³jau¹xai²na² Txa²ti³ha²yau³xa² yã¹nx2na³li¹. Wãn³txa² tah²yau³xa² ĩ³ye³kxi¹nx2ta¹jau³xai³ jã¹nxe² kãi³ũh¹nx2ta¹jau³nũ³ai²la¹wi¹. A²nũ²a² ko̱³nxe³ti³ kãi³ju³ta² ã³wa²sut1si¹ha¹jau³nũ³su² Txa²ti³ha²yau³xa² ha³li³hxan³sa³tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ne³ka²sah¹lxi³wxi¹. Jah¹lai²li² ã³yãu³hũ¹sa²jah¹la² txa²wã¹me²sa³ka³lo³a² ã³wxe²na³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Su²lhã³sain¹sxã³ ya³lu²na¹tu¹wi¹. Nxe³ju³ta² Txa²wã¹sũ̱³na² wãn³txu¹tai²na² ĩ³ye³kxũ¹nẽ³ta¹hxai²ti³ai¹ti²tu³wi¹. Yxãn¹ta¹ ã³yãu³hũ¹sa²jah¹lo²kxai²lẽ¹. Ko̱³nxe³ton³khai¹nxe³tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nxa²ha¹te¹ jau¹xai²li² ain³kxain¹te³na¹ e³lain¹te³nah¹lxi¹: — Ĩh¹jah¹lo²ta̱³ ko̱³te³hin¹te²la¹xã³? Nxe² e³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nxe² e³lain¹nxa²ha¹te¹ jau¹xai²li² ta³lun²nũ²la² a²sa³wi³ha³lxa² e³kxi²nyhu¹ain¹ta¹hxai²hẽ¹la². Nxe³te³nah¹lxi¹: — Txai²li² hxi²kan¹txi³lxã³na¹wi¹. Yxãn¹ta¹ wxãi²li² kãin²te²sxa³lxi¹. Ãh¹lxi³sxã³: — Kwa²nxi¹lxi¹. Txai²na² so¹lxi³ hxi²kan¹te³lxã³na¹wi¹. Wxãi²na² kãin²te²sxa³lxi¹. Nxe³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Ju³te²a² nũ̱³ka̱³txi³sxa³te²nãu³xa² a²si³yxau³ka³txa² hi²sen³su² a²sa³wi³ha³lxi³nãu³xa² yxo²xũn³txi³ kwa³na³nyhain¹te²ju²hẽ³li¹. Ai¹nha²kxai³ a²sa³wi³ha³lxa² nxe² e³lain¹te³nah¹lxi¹: “Jah¹lai²li² wi¹la³ ã³non²ta³kxi²nẽ³jah¹lai²la¹wi¹.” Ain¹jau³su². Te³nai¹nhxai²na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nxain¹kxan²ti³ te²yã¹xah³lxi³txa³hẽ¹li¹. Yxãn¹ta¹: “Hxi²kan¹te²sa¹wi¹.” Nxe³jau³jau¹xai²na² e³yah³lxin¹kxai²nãn²tu̱³ a²nũ²a² hxi²ka¹nxa³te²a² yã¹nxe² ĩ²ũ¹nha¹jah³lxi³hẽ¹li¹. Te²yã¹nxe³sxã³: “A²wa³kxẽn³su² te²sa¹wi¹.” Nxe³jau³jau¹xai²na² e³yah³lxin¹kxai²nãn²tu̱³ kwa² sa³wi³sa²yã¹nxa² ã³non²ta³kxi²nũ¹nha¹jah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Te²yã¹nxe³ju³kxai³lu² ĩh¹jah¹lo²ta̱³ hxi²kan¹ wa³to²hi² jah¹lo²la³te²la¹xã³? Yain³txi³su² ãu¹la³kxi²sxã³ ũ³hũ²jah¹lo²su² te²la³ ta̱³nxa², hãi¹nxe³sxã³ ã³wxe³sxã³ yain³jah¹lo²su² te²la³ ta̱³nxa², ĩh¹jah¹lo²ta̱³ hxi²kan¹ wa³to²hi² jah¹lo²su² hĩ̱³te²la¹xã³? Nxe²nxa³wi¹. Hãi¹sxã³ ã³wxe³sxã³ yain³jah¹lo²su² te²na² hxi²kan¹ wa³to²hi² jah¹lo²su² te²la¹wi¹. Nxe³to³ta¹ Txai²na² sa²kxai³lu² yain³txa² ãu¹la³kxi²jah¹lo²kxa² yã¹nxe³sxã³ a²wa³ka³li³lo³jah¹la²yã¹nxa¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nxe³na¹ha²kxai³ ã³si³tẽ³kxi²sah²lxin¹tai¹tu³wi¹. Ha³lo²a² ko̱³ton³kxi²sa²kxan²ti³ kan²txi³ ã³si³tẽ³kxi²sah³lxin¹tai¹ti²tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sah¹lxi¹nha²kxai³ Txa²wĩ³na² hxi²ki³kxai³lu² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²tu¹wi¹. Nxe³sa³kxai²nãn²tu̱³ ha³lo²a² a²yxo²ha³kxa¹ a²wa³kxẽn³si¹ta¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nxa¹kxai²nãn²tu̱³ Txai²yã¹nxe³sxã³ I³sa³e² nũ̱³ka̱³txi³nãu³xa² ha³tih³xa² hxi²ka² hxan³sxã³ ha¹li¹ wa²sa²so¹xi²nũn³ka³tu̱³ nxe³te²nũ̱³ka̱³txi³nãu³xa² a²wa³kxẽn³si¹yah³lxin¹nũ³nĩn¹tu¹wi¹. Nxe³yah³lxin¹kxa²yu³su² txa²yai³na¹ka³lo³a² ã³wxe³sxã³ yain³kxi²syah¹lxin¹tu¹wi¹. Je³su²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nxe³ha²kxai³la¹: — Si³mãu²ah³lãi³. Ne³ka²sa²sa²lxi¹. Sa³ta³na²jah¹la² e³kxi²sain¹te³nah¹lxi¹: “Je³su²jah³lĩ¹. Wxa²nũ̱³ka̱³txai²li² ũ³hũ¹sẽ¹li¹. Sa²yxo²ã³nxain¹ju³ta² ĩ³ye³kxi²sai³nai¹na¹tu¹wi¹.” Sa³ta³na²jah¹la² nxe³sain¹na²hẽ³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ain¹ta¹ Txa²wã¹sũ̱³na² ĩ³ye³kxai¹na¹hẽ³li¹, kan²txi³ yxo²ĩ²sah¹lxi³si¹hin¹jau³su¹. Nxe³ha²kxai³ ã³yxo²o³tũ¹xi²san¹kxai²nãn²tu̱³ txa²sa³wi³ha³lxa² yxo²ĩ²sain¹nũn³si¹hin¹jau³su² ã³nxũ²kwa̱i³lxũ¹txi³txai¹nhẽ³li¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nxa²ha¹te¹ Pe²jah³lai²na² wãn³txi³kxai³lu¹: — Txa²hxi²kan¹jah¹lãi³. Kan²txi³ ã³si³tẽ³kxi¹nxa²ha¹tu¹wi¹. Ũ³tĩ̱¹kxi²sain¹kxan²ti³ su²lhã³sain¹kxan²ti³ ya²la³tu̱³ sa²yxo²ã³nxa²sa²sĩ¹nxa³lho³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Pe²jah³lãi³. Ne³ka²sa²sa²lxi¹. Ka³nxah³tai²na² ka³la³ka³la²a² ĩ³yxai²lxi²nxa³ta̱³lxa¹ jau³nũ³a² nxe²e³in¹te³nah¹lxi¹: “Je³su²jah³la² ĩ²ti³hex1te²txã³wi¹.” Nxe²ĩ³ki³ha¹kxi²san¹jau³xa² ye³ha¹li¹ ka³na³ki¹ ĩ³ye³kxi²xin¹tu¹wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nxa²ha¹te¹ Je³su²jah³la²kxai³la¹ e³kxi²te³nah¹lxi¹: — Kxã³nhxĩ¹nai³tã² sa²si¹hã³nx2ta¹hĩ¹nai³tã² ha³te̱h³nxã³nxẽ¹ta̱³ yũ²nxa³ha²kxai³ wã²lẽ¹ta̱³ yũ²nxa³ha²kxai³ yu³wi²kxi²nha²ka³lo³a² wẽ̱³no³kxi³la³ yũ²nxa³ha²kxai³ nxe³kxan²ti³ yã¹te²ta̱³ wã³kon³kxi¹nx2ti³lhai¹li¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — Wã³kon³sĩn¹nxa³tai¹tu³wi¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nxa²ha¹te¹: — Hĩ¹kxai³ ha³te̱h³nxã³nxẽ¹na² ta̱³nxa² wã²lẽ¹na² ta̱³nxa² yũ³ke³la³te²kxai³ so¹xi¹jah³lxi³hẽ¹li¹. Yah³lxi¹nha²kxai³ yu̱³la² kãin² ta³wxi²a² yũ²nxa³kxai²nãn²tu̱³ so¹kxi²txai¹yah³lxi³hẽ¹li¹, wxa²wã²la²ka³lo³a² ũ³hũ¹ai¹yah³lxin¹kxan²ti³nũ¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nxe³ha²kxai³ Txa²wã¹sũ̱³na² ha³te̱h³nxã³nxu¹tai²na² nxe³te³nah¹lxi¹: “A²nũ²a²nãu³xa² te²hi²sen³su² Txa²wã¹sũ̱³na² hxi²kan¹jah¹la² ĩ³ye³ki³ha¹kxain¹te³nah¹lxi¹: ‘Jah¹lai²li² ko̱³nxe³thin¹jah¹la² he³la³kxi³sye¹txi³na³li¹.’ Nxe²e³ain¹tu¹wi¹.” Ũ³wha²li¹txã³nxu¹tai²na² nxe³ta¹hxai²hẽ¹li¹. Hĩ¹na² nxe³kxa²yã¹nxe³jut3su² kãi³ta³lun²sain¹tu¹wi¹. Je³su²jah³la²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nxa²ha¹te¹ a²sa³wi³ha³lxai²na² wãn³txi³kxai³lu¹: — Ĩ²sa²si¹lxi¹. Ti¹ai²li² yu̱³la² kãin²ta³wxi²a² wxi²ha¹li¹ yũ³sĩn¹na³li¹. Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹: — Ãn²na³li¹. Je³su²jah³la² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nxa²ha¹te¹ e³ta³lun²nxa²ha¹te¹ Je³su²jah³la²kxai³lu² a³li³nũ²la² wã³la³ka³txa² O³li³ve²ra³ka³txa² ka³la³hxai²na²hẽ³ jã¹nxe³to³ta¹hxai²hẽ¹la². Nxe³tãu³a² ã³si³tẽ³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jã¹nxe³sxã³ ka³la³to³nhũ²la² ã³yi¹ka³tu̱³ e³kxi²te³nah¹lxi¹: — Txa²wã¹sũ̱³na² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. Ko̱³nxe³ju³ta³la³ ã³wih¹kxi¹nx2ti³kxa²ya̱n³txi³su² nxe³nx2ta¹nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nxe³nũ²la² jũ¹nxe² ã³ya̱¹not3ta¹hxai²hẽ¹la². Nxe³nũ²la² ã³ka³ti³lhu³ta³kxa² wxe³sxã³ Txa²wã¹sũ̱³na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","E³kxi²te³nah¹lxi¹: — Wĩ³na² nxex3txi¹. Ten³nxa²ke³la³te²kxai³ a²ko̱³nxe³ju³tai²na² khãuh³lxa³ti³sa²ju³tai²na² sa²wa²tot1so¹kxi²sẽ¹li¹. Yxãn¹ta¹ ten³nxa²nxa³kxai²nãn²tu̱³ wxa²wãn³txa² so¹lxi¹ we¹txa²ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nxe²e³ti̱³kxai³lu² oh³xan¹jah¹la² a³ka³nxi²nũ²la² ãn³sĩ³nxũ̱n³nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nxe³ha²kxai³ jã¹nxe³sxã³ ã³ka³ti³lhu³ta³kxa² wxe³sxã³ Txa²wã¹sũ̱³na² e³kxi²ta¹hxai²hẽ¹la². Nxe²e³kxi²tãu³a² ãin²ti³sa²txe̱¹khaix1nxe³ha²kxai³ ĩ³kax3lã̱ux3ka³lã̱u¹nha²jau³xa² a²tih³yau³khai³xa² ha³li³at1ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hã²wxãn³txa³ e³ta³lun²nũ²la² a²sa³wi³ha³lxa² ã³wa̱³li²sxĩ²nũ²la² ãin²ti³khaix1nxe³ha²kxai³ ãu³xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ãu³xain¹ka³tu̱³ta¹ Je³su²jah³la² e³kxi²te³nah¹lxi¹: — Ĩh¹nxe³ha²kxai³ ãu³xah³lxin¹ji¹wi¹? Txa²wã¹sũ̱³na² ĩ³ye³kxi¹jah³lxi³hẽ¹li¹. Ko̱³nxe³ju³ta³la³ ã³wih¹kxi¹nx2ti³kxa²ya̱n³txi³su² nxe³nx2nhai¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nxa²ha¹te¹ ĩ³ye³kxi²ta³lun²nxa³ta̱³lxa¹ a²nũ²a² ka³lxa¹tũ̱³ka̱³txa² ya̱u³so³nain¹ta¹hxai²hẽ¹la². Nxain¹sxã³ a²sa³wi³ha³lxa² ã³nhai¹tũ³jah¹la² ka³na³ka³na³te²a² Ju³ta²sah³lo²kxai³lu² ne³ka³ta²a² wxã³ye²ta¹hxai²hẽ¹la². Nxe³kxan²ta² ya̱u³son³kxi²nũ²la² Je³su²jah³la² ĩ³yxo²sai¹la³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ju³ta²sah³lãi³. Ĩ³yxo²sai¹la³kxi²san¹jau³xa² ã³yãu³hũ¹kxi²san¹ji¹wi¹? Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nxa²ha¹te¹ a²sa³wi³ha³lxa² hi²sen³kxai³lu² wxã³ain¹tũ̱³ka̱²txa² ĩ²ain¹tãu³a² ĩ³ye³ain¹te³nah¹lxi¹: — Txa²hxi²kan¹jah¹lãi³. Yu̱³la² kãin²ta³wxi²a² hxi²tẽ³nha²sxã³ sun²tã¹sĩn¹te³la¹ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nxe²e³ain¹ti̱³kai³lu² Je³su²jah³lai²na² a²sa³wi³ha³lxai²na² ka³na³ka³nat3sxã³ wã³nxĩn¹ta² si³yxau³kah³lai²na² a²sa³wi³sa² ya̱u³son³kxi²nũ²la² yu̱³la² kãin²ta³wxi²a² hxi²tẽ³nha²ta¹hxai²hẽ¹la². Nxe³te³na¹ a²ne³nxẽ³na² a²nẽ³wi¹tãu³a² ũh³nxe³i²lã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Hãi¹nxã¹jah¹lxi³sã²nhẽ³li¹. Nxe³jau³su² nũ²la² in³txa² ne³nxẽ³na² txa²wã¹ne³wi¹nẽ³tãu³a² wxa²ne³wxai³sa̱in³sxã³ wxa²ne³we²txi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nxa²ha¹te¹ wã³nxĩn¹ta² Si³yxau³kah³lo²su² te²a² a²so³ta²to² nũ̱³ka̱³txi³su² te²a² Ju³te²a² a²hxi²kan¹tũ̱³ka̱³txi³su² te²a² nxe³te²su² Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Yu̱³la² kãin²ta³wxi²a² tẽ³i² hi³sa³ka³txa² tẽ³i² yah³lxin¹sxã³ wxã³yah³lxin¹ti²ti¹. A²nũ²a² yen³kxa² kãi³kxi²jah¹la² i³sxã³ sa²so¹kxa² yã¹nxe³ i³sxã³ sa²so¹sah¹lxin¹ta²lu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Txa²wã¹sũ̱³na² sxi²ha² ye³ka³lxa¹txi³ ã³yũh¹sxai²na¹tai¹ti²tu³wi¹. Na¹tãu³ai³tã² so¹sah¹lxi³hxai²nxã³tai¹ti²tu³wi¹. Yxãn¹ta¹ hĩ¹na² ka³nxa³hi²ha²kxai³ Sa³ta³na²jah¹la² nũ³kxũn³sxã³ o²la³kxi²te²ju²hẽ³li¹. Te²yã¹nxe³ha²kxai³ wxa²nũ̱³ka̱³txai²na² ko̱³nxe³ti³ o²la³kxah³lxin¹tu¹wi¹. Je³su²jah³lo²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ain¹nxa²ha¹te¹ Je³su²jah³lo²kxai³ i³sxã³ sa²so¹ai¹nha²kxai³ wã³nxĩn¹ta² si³yxau³kah³la² hxi²kan¹jah¹la² a²sxi²ha² tĩ̱¹kxain¹sxã³ ã³wi¹hain¹ta¹hxai²hẽ¹la². Nxain¹tãu³a² Pe²jah³la²kxai³ a²si³yo³na² sxi²ha² wai²ha² yxo²tã̱³lxa² ã³wih¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A²nxe³thĩ³na² ti²ta³lo³ka² ha³nxe²a² sa²ya³tain¹ta¹hxai²hẽ¹la². A²nxe³tho³xai²na² Pe²jah³lo²kxai³lu² tĩ̱³nũ²la² a²yxo²we̱³ka²nũ¹hain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nxe³tãu³a² wã³nxĩn¹ta² si³yxau³kah³la² hxi²kan¹jah¹la² a²sa³wi³sa¹ka³lxa² e³te³nah¹lxi¹: — Jah¹lai²li² Je³su²jah³la² a²si³tẽ³kye¹nxain¹na²li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nxa²ha¹te¹ Pe²jah³la² ki³ha¹kxain¹sxã³ e³kxi²te³nah¹lxi¹: — Nxex3sa²nxi¹. Jah¹lai²li² hai³txi³ ĩ²te²txã³xĩ¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ye³jen¹nãu³a² in³txa² ĩ²ain¹nũ²la² e³kxi²te³nah¹lxi¹: — Wxãi²na² Je³su²jah³la² a²sa³wit3sin¹tai¹. Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Pe²jah³lai²na² ĩ³ki³ha¹kxi²sxã³ a²wãn³txi³kxai³lu¹: — Nxex3sa²lxi¹. Txai²li² ti³he¹nxẽ²nxa³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ye³jen¹nũn³tãu³a² in³txa² ã̱³xa² ĩ²ain¹te³nah¹lxi¹: — Jah¹lai²li² ã³si³tẽ³kxain¹te²nu³tã³li¹. Ka³li³le²a² a²nũ̱³ka̱³txi³su² ye²ha²kxai³lu¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nxa²ha¹te¹ Pe²jah³la² ĩ³ki³ha¹kxi²sxã³ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Nxex3sa²lxi¹. Jau¹xai²li² ko̱³nha²ti³hex1te²txã³wi¹. Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ e³ta³lun²hĩ¹na¹ ka³la³ka³la²a² ĩ³yxai²lxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nxe³tãu³a² Je³su²jah³la² sa²ne³wa³ti̱³nha²sxã³ Pe²jah³la² ten³sa²tã³ta¹hxai²hẽ¹la². Nxe³hĩ¹na¹ Pe²jah³la² sa²kxai³lu² Je³su²jah³la² a²wãn³txai²li² ĩ³ne³sai¹xi²nha²ta¹hxai²hẽ¹la². Nxe³jau³xa²sa¹: — Ka³nxah³ta² ka³la³ka³la²a² ĩ³yxai²lxi²nxa³ta̱³lxa¹ wxãi²na² Pe²jah³lo² ĩ³nxai²na² sa²kxai³lu² ye³ha¹li¹ ka³na³ki¹ ten³si¹sa²nxãn³jau³nũ³su² ĩ³ye³kxi²xin¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nxe³jau³xai²na² Pe²jah³lai²na² ain³kxi²xi²ka³tu̱³ ha³lo²a² a³li³xi²nũ²la² ãin²ta³kxi²nha²sxã³ kãin²nã̱n³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nxa²ha¹te¹ so³ta²to² nũ̱³ka̱³txa² Je³su²jah³la² tĩ̱³kxain¹tũ̱³ka̱³txai²na² ĩ³wai³ka³si³jau³su² ĩ³ye³kxai¹ni² ĩ³su²lai¹ni² nxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nxe³ain¹kxa²yu³su² wã²la²ka³lo³a² tẽ³sxã³ ũ³yhe³tĩ¹kxain¹nũ²la² ĩ³su²lain¹ka³tu̱³ ĩ³wã̱³txi³te³nah¹lxi¹: — Ĩh¹te²ta̱³ ĩ³su²nxain¹thi²li¹? Ĩ³yau¹ũ³sẽ¹li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te²yã¹nxe³ju³ta² ko̱³nxe³te²lo³jau³xa² yau³ka³lxa¹txi³ ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","A³lan²ton³tãu³a² Ju³te²a² a²hxi²kan¹ta² nũ̱³ka̱³txi³su² te²a² wã³nxĩn¹ta² si³yxau³tũ̱³ka̱³txi³su² te²a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² tũ̱³ka̱³txi³su² te²a² ain¹sxã³ ã³nũ²kxi²nũ²la² Je³su²jah³la² sa²so¹ain¹ka³tu̱³ e³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","E³kxain¹te³nah¹lxi¹: — Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²jah¹lo²sin¹ji¹wi¹? Ĩ³yau¹ũ³nha²sẽ¹li¹. Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²te³nah¹lxi¹: — Ĩ³yau¹ũ³nx2ta¹kxai²nãn²tu̱³ yxo²ĩ²sah²lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yxãn¹ta¹ ĩ³wã̱³txi³nx2ta¹kxai²nãn²tu̱³ hai³txi³ ĩ³wa²lũ³xi¹sah²lxan³tho³li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yxãn¹tah¹lxa¹ ye³jen¹na² yan¹nãu³a¹ Txai²na² Sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²na¹xai²na² ĩ²sah¹lxin¹tu¹wi¹. Txa²wã¹sũ̱³na² Si³yxau³jah¹la² a²wi¹nẽ³tãu³a² ã³wxe³na¹tu¹wi¹. Je³su²jah³lo²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nxa²ha¹te¹ a²yxo²ha³kxa¹ ĩ³wã̱³txain¹te³nah¹lxi¹: — Wxãi²na² Txa²wã¹sũ̱³na² Ta²su² nĩn¹ji¹wi¹? Ain¹ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Wain³txi³ e³yah³lxi¹lxi¹. Txai²la³na¹wi¹. Je³su²jah³lo²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nxa²ha¹te¹ e³kxi²nyhain¹te³nah¹lxi¹: — Hĩ¹na² ĩ²ki̱³ti²tu³wi¹. Je³su²jah³la² a²yxo²wãn³txa² Sũ̱³na² ko̱³nxe³te²lo³jau³xa² ain³kxi²ki̱³ti²tu³wi¹. Hãi¹nxã¹a³syah¹lxi³sa²lxi¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nxa²ha¹te¹ e³kxi²nyhain¹nũ²la² ã³nũ²kxi²tũ̱³ka̱³txai²na² hi²sen³kxai³lu² Je³su²jah³la²kxai³ ã³nũ²kxa² so¹sxã³ ai³ain¹ta¹hxai²hẽ¹la². Pi³la²jah³la² sxi²ha² ã³nxai³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nxe³nũ²la² ã³nũ²kxa² so¹ain¹tũ̱³ka̱³txa² ĩ³ki³ha¹kxi²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lai²li² txa²wã¹nũ̱³ka̱³txa² ã³ke³tũ¹ain¹na²hẽ³li¹. Nxe³te³nah¹lxi¹: “Ro³ma²no² nũ̱³ka̱³txa² a²hxi²kan¹jah¹la² Se²sa³jah¹lo²su² a²nũ²a² ũ³yho³hi²ki̱³ki³a² ũ³yho³hi²yah³lxi³txa³hẽ¹li¹.” Nxe³jau³su² ha²kxai³: “Txai²li² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3sa²jah¹lo²sa¹wi¹. Wxa²si³yxau³kax3sa¹wi¹.” Nxe³jau³xa² yxo²ha³kxa¹ nxe² ain³kxi²sĩ¹na¹hẽ³li¹. Ĩ³ki³ha³nain¹jau³xa² ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nxa²ha¹te¹ Pi³la²jah³lai²na² a²wãn³txi³kxai³lu¹: — Wxãi²na² Ju³te²a² nũ̱³ka̱³txai²na² a²hxi²kan¹ta² si³yxau³jah¹lo²sin¹ji¹wi¹? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Wxa²wãn³txai²na² wain³na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nxa²ha¹te¹ Pi³la²jah³la² hi²sen³kxai³lu² e³kxi²te³nah¹lxi¹. Wã³nxĩn¹ta² si³yxau³tũ̱³ka̱³txi³su² te²a² a²nũ²a²nãu³xa² a²yxo²ha³kxa¹ ain³kxain¹te³nah¹lxi¹: — Jah¹lai²li² ko̱³nxe³ti³ kãi³ju³ta² hai³txi³ ĩ²a¹jah¹lo²sxa³wi¹. Wi¹lhin¹jah¹lo²sye¹nx2ti³na³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nxa²ha¹te¹ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Kwa²nxi¹lxi¹. Jah¹lai²na² wãn³txa² he¹li²nha²si¹nyhain¹jau³su² ĩ³yau¹ũ³hxai²na²hẽ³li¹. Jã¹nxe³na³li¹. Nũ¹ka³na¹ Ka³li³le²a²ko³xa² ã³si³wxe³nũ²la² Ju³te²a²ko³xa² ã³wa²to²hi²ka³tu̱³ hĩ¹na² wxã²na³li¹. Ain¹jau³su² kãin² ki³han³jau³su² e³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nxa²ha¹te¹ Pi³la²jah³la²kxai³lu² ĩ³ye³kxi²te³nah¹lxi¹: — Jah¹lai²li² Ka³li³le²a² ko³xan¹jah¹lo²su² te²la¹xã³? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","8","Nxa²ha¹te¹: — Wain³sĩn¹na³li¹. Ta¹hxai²hẽ¹la². Nxe³te³na¹ Pi³la²jah³la² hi²sen³kxai³lu² ĩ³sa²si¹hã³nyhai¹nha²kxai³ E³ro²jah³la² sxi²ha² ã³wih¹si¹nyhain¹ta¹hxai²hẽ¹la². A²nxe³jah¹la²kxai³ Ka³li³le²ko³xa² a²wa³kxẽn³yah³lo²su² ta¹hxai²hẽ¹la². Jã¹nxe³tãu³a² Je³ru³sa³lẽ²thĩ³na² yxau²xai³ta¹hxai²hẽ¹la². Kxãn³su² Je³su²jah³la²kxai³ ĩ²ain¹ju³ta² ten³kxe³su² ka³lih³kxi²la²ta¹hxai²hẽ¹la². Kxã³nhxĩ¹nai³tã² Je³su²jah³la² hxi²ka¹nain¹jau³xa² ain³kxai¹nha²kxai³ hĩ¹na² sa²kxai³lu² a²ya³la³lhu²si¹nhẽ³tũ¹xã¹. Ain³jau³su² nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nxa²ha¹te¹ E³ro²jah³la²kxai³ kãin² ĩ³wã̱³txi¹nyha¹ta¹hxai²hẽ¹la². Nxe³ta¹ Je³su²jah³la²kxai³ hai³txi³ ĩ³we¹nyha¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nxe³ain¹kxa²yu³su² wã³nxĩn¹ta² si³yxau³tũ̱³ka̱³txi³su² te²a² ha³te̱h³nxã³nxa² a²hoh³lxi³su² te²nãu³xa² ain¹sxã³ ki³ha¹kxi²sxã³ ko̱³nxe³ti³hi¹jau³su² ĩ³ye³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nxa²ha¹te¹ E³ro²jah³lo²su² te²a² a²so³ta²to² nũ̱³ka̱³txi³su² te²a² nxe³te²a² sa²kxai³lu² ĩ³wa³ka³si³ai¹ni² ĩ³ha³nũ̱³nxe² nxain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ wã²la² wi¹khaix1ka³lo³a² tẽ³sxã³ Je³su²jah³la²kxai³ ũ³whi²kxain¹nũ²la² Pi³la²jah³la² sxi²ha² ĩ³wha̱¹li²si¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nxa²ha¹te¹ kxã³nhxĩ¹nai³tã³ E³ro²jah³la² Pi³la²jah³la² hi̱³nyha¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ hĩ¹nãn¹te²tu̱³ ya̱³li³xi²nyha¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nxa²ha¹te¹ wã³nxĩn¹ta² si³yxau³tũ̱³ka̱³txi³su² te²nãu³xa² Ju²te²a² nũ̱³ka̱³txa² hxi²kan¹txi³nũ̱³ka̱³txi³su² te²nãu³xa² a²nũ²a² yxo²ha³kxa¹ Pi³la²jah³la² hi²sen³kxai³lu² ĩ³kaix1so¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹ Je³su²jah³lai²li² hi²sen³kxai³lu² a²nũ²a² nũ̱³ka̱³txa² he¹li²nha²si¹nyhain¹jau³su² tẽ³sxã³ e³kxi²sah¹lxin¹ten¹tu³wi¹. Yxãn¹ta¹ wãn³txa² ka³lxa¹txi² wã̱³txai¹na¹ten¹tu³wi¹. Ĩ³wã̱³txai¹na¹kxan²ti³ ko̱³nxe³ti³ kãi³ju³ta² hai³txi³ a³ya³txi²nxa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na¹kxa²yu³su² E³ro²jah³la² te²yãx1ta¹hẽ¹li¹. Nxe³ha²kxai³ sa²si¹hã³xi²sain¹tai¹tu³wi¹. Ain¹jut3su² jah¹lai²li² ko̱³nxe³ti³ kãi³ha²kxai³ ĩ³ya²lut1si¹ha¹jau³nũ³su² hxi²ki³ye²nx2ti³xa³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nxe²nxa³ju³tan¹te²kxa³ya̱³lhu² hãi¹sxã³ ĩ³wai¹tain¹si¹sã²na¹ka³tu̱³ wxa²wa²sut1sxã³ ũ³hũ¹xi¹nx2ta¹tu¹wi¹. Pi³la²jah³la²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nxa²ha¹te¹ kxã³nhxĩ¹nai³tã² Pas²kwa²nxe³tũ̱³xa² yai³nai¹nhĩ¹nai³tã³ a²nũ²a² ũ³tĩ̱¹kxi²tũ̱³ka̱³txa² a²nũ²a² ka³na³ka³na³te²a² wxa²wa²sut1sxã³ sa²tã³xi²to³ta²hxai²hẽ¹la². Nxe³sxã³ ye³ka³lxa¹txi³ Pas²kwa²nxe³tũ̱³xa² yai³nain¹ju³ta² Pi³la²jah³la² hxi²ka² jã¹xain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nxain¹kxan²ta² te²yã¹nxe³ju³ta² te³nai¹nha²kxai³ a²nũ²a² yxo²ha³kxa¹ kãin² ĩ³kaix1tain¹te³nah¹lxi¹: — Je³su²jah³la² su²lhã³txa²sĩ¹nhẽ³li¹. Ba³ra³ba²sah³la² so¹lxi³ wxa²wa²sut1sxã³ sa²tã³xit1sĩ¹nhẽ³li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nxa²ha¹te¹ Ba³ra³ba²sah³la² sa²kxai³lu² a²kxã³nxai³tã² a²nũ²a² su²lhã³ha²kxai³ Je³ru³sa³lẽ²thĩ³na² a²wa³kxẽn³nũ̱³ka̱³txa² he¹li²nha²si¹nyhain¹jau³su² o²la³kxi²ha²kxai³ ain¹ju³tan¹te²kxa³ya̱³lhu² ũ³tĩ̱¹kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nxa²ha¹te¹ Pi³la²jah³la² hi²sen³kxai³lu² Je³su²jah³la² wxa²wa²sut1sxã³ sa²tã³xi²ju³ta² ten³jau³su² ãh¹ ĩ³ye³kxain¹ta¹hxãi²he¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ain¹tah¹lxa¹ yxo²xũn³txi³ ĩ³wa²lũ³xain¹te³nah¹lxi¹: — Hi³sa³ka³txa² ũ³hẽt1sxã³ ĩ³hxi²kĩ¹la²kxi²sxã³ ĩ³ya²lu¹tai¹nhẽ³li¹. Ũ³hxi²kĩ¹hẽt1txai¹nhẽ³li¹. Nxe³nyhain¹to³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nxa²ha¹te¹ Pi³la²jah³la² ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Ĩh¹nxe³ta̱³ ko̱³nxe³ti³ kãi³ te²la¹xã³? Ko̱³nxe³ti³ kãi³ha²kxai³ ĩ³ya²lut1si¹ha¹jau³nũ³su² hxi²ki³ye²nx2ti³xa³wi¹. Nxe³ha²kxai³ ĩ³wai¹txi²sã²na¹ka³tu̱³ wxa²wa²sut1sxã³ sa²tã³xi²si¹hai¹na¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nxa²ha¹te¹ Je³su²jah³la² ĩ³hxi²kĩ¹la³kxi²si¹hain¹jau³xa² yxo²xũn³txi³ e³jau³xai²na² ĩ³ye³sxã³ ã³na¹ti³he¹xain¹ta¹hxai²nxa³hẽ¹la². A̱i³na¹ Pi³la²jah³la² ye̱³ye̱³non¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ain¹ju³tan¹te²kxa³ya̱³lhu² Je³su²jah³la²kxai³ su²lhã³si¹hain¹jau³su² Pi³la²jah³lai²na² a²yxo²wãn³txa² kwa³na³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nxe³ain¹kxa²yu³su² Ba³ra³ba²sah³la² a²nũ²a² nũ̱³ka̱³txa² he¹li²nha²si¹nyhain¹jau³su² a²nũ²a² su²lhã³ha²kxai³ nxe³jah¹la² ũ³tĩ̱¹kxain¹jah¹lai¹tã² wxa²wa²sut1sxã³ sa²tã³xi²si¹nyhain¹jau³xa² te³nain¹ta¹hxai²hẽ¹la². Je³su²jah³la² su²lhã³si¹nyhain¹jau³su² te³nai¹nha²kxai³ Pi³la²jah³la² hi²sen³kxai³lu² sa²yxo²we¹nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nxa²ha¹te¹ Je³su²jah³la² tẽ³sxã³ a³li³ain¹ta¹hxai²hẽ¹la². Nxe³ain¹tãu³a² Si³mãu²ah³la² Si³re²ne²ko³xan¹jah¹la² ne³khau²hain¹ta¹hxai²hẽ¹la². Nxe³jah¹la² a²ha³lo²khai³xa² a³li³nũ²la² Je³ru³sa³lẽ²thĩ³na² ã³wih¹te³lhxã³ ta¹hxai²hẽ¹la². A²nxe³jah¹la²kxai³ tũ̱³ka̱³txai²na² hi²sen³kxai³lu² i³ain¹ta¹hxai²hẽ¹la². Hi³sa³ka³txa² sa²tã³ka³la³kxi²hẽt1so¹nha²si¹hain¹jau³su² kwa³na³ain¹ta¹hxai²hẽ¹la². Nxe³ha²kxai³ Je³su²jah³la² yo³na² ĩ³hit1ai³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nxa²ha¹te¹ tũ̱¹ka̱³txa² ka³lxa¹tũ̱³ka̱³txa³ ĩ³hi¹txain¹ta¹hxai²hẽ¹la². Nxe³te²a² txu¹ti³nãu³xa² ĩ³hi¹txain¹te²a² ãin²tai¹nha²kxai³ kãin² nã̱n³kxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nxa²ha¹te¹ Je³su²jah³la² ĩ²ain¹nũ²la² sa²wa³ti̱³nha²sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³jah³lxi³nxi¹. Je³ru³sa³lẽ²thĩ³na² a²wa³kxẽ³na³ka³lxi²nãu³syah¹lxi¹nxi¹. Txai²li² ĩ³nã̱n³kxi²sah¹lxi³txa³hẽ¹ni¹. Yxãn¹ta¹ wxãi²na² wxa²wẽ³ha³lxa² wxa²nxũh¹ ĩ³nã̱n³kxi²nha¹jah³lxi³hẽ¹ni¹. ");
INSERT INTO nabNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ye³jen¹nãu³a² wxa²ha³lo²a² ko̱³ton³kxi²khaix1nxe³nx2ti³tũ¹xĩ¹. Nxe³tãu³a² e³kxain¹tu¹xĩ¹. Nxe³te³nah¹lxi¹: “Txuh¹hai²li² wẽ³sa³ txa²te²a² ka³li³hi² txu¹hai²li² wẽh³ni²nxa³te²a² ka³li³hi² txu¹hai²li² wẽ³sa² i³lxa³te²a² ka³li³hi² nxe³nx2tain¹tũ¹xĩ¹.” ");
INSERT INTO nabNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nxe³hĩ¹na¹ wã³la³ka³txa³ e³kxain¹te³nah¹lxi¹: “Ũ³tĩ¹kxi²sẽ¹li¹. A³hi²sxã³ ĩ³ya²lut1sẽ¹li¹.” Nxe³ain¹tu¹xĩ¹. ");
INSERT INTO nabNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ai¹nha²kxai³ ko̱³nxe³ti³ kãi³ũ¹sain¹na³li¹. Nxe³kxa²yã¹nxe³kxa²ha³tih³xan²tu̱³ ko̱³nxe³ti³ kãi³wa³to²hi²nũ¹nx2tain¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nxa²ha¹te¹ in³txa² ko̱³nxe³ti³ kãi³sxã³ yxau²xai³jah¹la² ũ³tĩ̱¹kxi²te²a² ha¹lin¹sxã³ su²lhã³si¹hain¹jau³su² ãn³sa²so¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nxe³ai¹nha²kxai³ wã³la³ka³txa² txa²wã¹ne̱³ka³lo³kat3su² ta¹hxai²hẽ¹la². Nxe³ka³txa² ka³la³ain¹nũ²la² Je³su²jah³la² tẽ³sxã³ hi³sa³ka³txa² ĩ³hxi²kĩ¹wxe³ai¹nha²kxai³ in³txa² ko̱³nxe³ti³ kãi³sxã³ yxau²xai³jah¹la² ha¹lin¹te²a² hi³sa³ka³txa² ĩ³hxi²kĩ¹wxe³ain¹ya³ha²kxai³ nxe³ain¹ta¹hxai²hẽ¹la². A²nxe³sxã³ wi³txã¹ka³txa² Je³su²jah³la² ĩ³hxi²kĩ¹wxe³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nxa²ha¹te¹ Je³su²jah³lai²na² sa²kxai³lu² Txa²wã¹sũ̱³na² e³kxi²te³nah¹lxi¹: — Wĩ³na² nxe³txi¹. Ko̱³nxe³ti³ kãi³sain¹jut3su² wi¹ko̱³nhai¹nxa³wi¹. Nxe³ha²kxai³ ne³wã²na³txai¹nhẽ³li¹. Ta¹hxai²hẽ¹la². Nxe³nxa²ha¹te¹ so³ta²to² nũ̱³ka̱³txa² txah³lxa³ki³a² wxa²sa²tã³ain¹sãn²sxã³ Je³su²jah³la² wã²la²ka³lo³a² so¹kxi²sxã³ wxa²nũt3tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nxa²ha¹te¹ a²nũ²a²nãu³xa² ĩ²yxau²xai³ain¹tãu³a² Ju³te²a² nũ̱³ka̱³txa² a²si³yxau³ka³txa² ĩ³wai³ka³si³xi²jau³su² ĩ³ye³kxain¹te³nah¹lxi¹: — A²nũ²a² ã̱³xa² sa²hau³ko³tain¹to³tai¹ti²tu³wi¹. Yxãn¹ta¹ wã²nxũ̱h¹sxã³ hxi²kan¹txi³ sa²hau³ko³nha²nxa³lho³li¹. Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3jah¹lo²su² ke³la³te²kxai³ wã²nxũ̱h¹sxã³ sa²hau³ko³nha²txai²li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Te²yã¹nxe³sxã³ so³ta²to² nũ̱³ka̱³txa² ya̱u³son³nũ²la² ĩ³wai³ka³si³xi²sxã³ yain³txa³yau³xa² kxa̱h³yau³xa² ĩ³na²si¹jau³su² ũ³hũ¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nxe³sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ju³te²a² nũ̱³ka̱³txa² a²hxi²kan¹txa² si³yxau³kax3sin¹ke³la³te²kxai³ sa²hau³ko³nha¹sẽ¹li¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ai¹nha²kxai³ hi³a²ka³lo³a² wãn³txa² ũ³wha²li¹lhãn²sxã³ a²ne³ta³lxo³ka³nãu³a¹ ũ³kũ¹tain¹ta¹hxai²hẽ¹la². Ũ³wha²li¹lain¹jau³xa²sa¹: — Je³su²jah³lai²li² Ju³te²a² nũ̱³ka̱³txa² a²hxi²kan¹ta² si³yxau³jah¹lai²la¹wi¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nxa²ha¹te¹ in³txa² ko̱³nxe³ti³ kãi³sxã³ yxau²xai³jah¹la² ka³na³ka³na³te²a² ĩ³wai³ka³si³nũn³te³nah¹lxi¹: — Wxãi²li² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³txa²jah¹lo²su² nxĩn¹ke³la³te²kxai³ sa²hau³ko³nha²sẽ¹li¹. Nhãn¹kxai²nãn²tu̱³ jãx1sa¹nhũn³sĩ¹nhẽ³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nxa²ha¹te¹ in³txa² ko̱³nxe³thin¹te²a² ã̱³xa² a²wãn³txi³kxai³lu¹: — Txa²wã¹sũ̱³na² o²nxã²nxa³ji¹wi¹? Jah¹la² yã¹nxe² ya³lu²nũn³nĩn¹tu¹wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nxe³sxã³ su²lhã³nẽ³lain¹ju³ta² wain³na³li¹. Yxãn¹ta¹ Je³su²jah³lai²li² hai³txi³ ko̱³nxe³thin¹sxã³ yxau²xai³jah¹lo²sxa³wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nxe³sxã³ ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Je³su²jah³lãi³. Ĩ³ye³kxi¹nxa²ha¹tu¹wi¹. Kxã³ton³sxã³ a²nũ²a² Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lot3txa²tãu³a¹ wxãi²na² nxe³wã²sa²txa³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nxa²ha¹te¹ Je³su²jah³la² ĩ³wa²lũ³xi²ti³an¹jau³kxai³lu¹: — Hĩ¹na² Txa²wã¹sũ̱³na² yxau³ju³ta² ĩ³na¹tu¹wi¹. Nxa¹kxai²nãn²tu̱³ ã³sa²so¹nxa²ha¹tu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nxa²ha¹te¹ ha³lo²a² whãi²na¹ ka³nxa³hi²khai¹nxe³ta¹hxai²hẽ¹la². A³lan²ta² ne³ka³ka³nhĩ¹nãn¹te²tu̱³ ã³ka³nxa³hi²ta¹hxai²hẽ¹la². Ã³ki³kan³tãu³a¹ so¹lxi³ ĩ³ha²te¹txi²ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nxe³hĩ¹na¹ wã²la²ka³lo³a² a̱u³ka³lo³a² Txa²wã¹sũ̱³na² sxi²ha² a̱u³tan¹thĩ³na¹ yxo²tĩ¹ka³lo³a² ã³ten²ti²sxã³ ã³yxo²hai²ta³lxi³ta¹hxai²hẽ¹la². Ã³ka³lo³ha¹lo³ta³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nxa²ha¹te¹ Je³su²jah³la² kãin² ĩ³kaix1te³nah¹lxi¹: — Wĩ³na² nxex3txi¹. Txa²yãu³ka³txa² ũ³hũ¹nxa²ha¹wi¹. Ain¹jau³su² nxe³sxã³ ya³lu²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nxa²ha¹te¹ so³ta²to²jah¹la² a²hxi²kan¹jah¹la² ju¹tai²na² ĩ²te³nah¹lxi¹: — Jah¹lai²li² ya²la³tu̱³ wi¹lhin¹jah¹lo²su²te²nũ³tã³li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nxe³ha²kxai³ a²nũ²a²nãu³xa² kwa² ten³sa²tã³ain¹te²nãu³xa² ya³lu²yain¹nxa²ha¹te¹ ãin²ti³sxã³ aun³txa² wa̱³li²xain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nxa²ha¹te¹ Je³su²jah³lai²na² a²sa³wi³ha³lxa²kxai³lu² u²lxi³ yxau³sxã³ ten³sa²tã³ain¹ta¹hxai²hẽ¹la². Ai¹nha²kxai³ txu¹ti³nãu³xa² Ka³li³le²a² ko³xa² yxau²xai³lhĩ¹nãn¹te²tu̱³ ã³si³tẽ³la³kxain¹ta¹hxai²hẽ¹la². A²nxe³te²nãu³xa² ten³sa²tã³ain¹nũn³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nxa²ha¹te¹ Jo³se²ah³la² A³ri³ma³te²a²thĩ³na² Ju³te²a²ko³xa² sxa³thĩn³su² ta¹hxai²hẽ¹la². A²nxe³thĩ¹nãn¹jah¹la² yxau³sxã³ ĩ²nũn³ta¹hxai²hẽ¹la². A²nxe³jah¹la² wi¹lhin¹jah¹lo²su² ta¹hxai²hẽ¹la². Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³ju³ta³nũ³su² wah³nxe³ta¹hxai²hẽ¹la². A²nxe³jah¹la²kxai³lu² Je³su²jah³la² su²lhã³ain¹ju³ta² ten³ta¹hxai²nxa³hẽ¹la². Ju³te²a² a²hxi²kan¹jah³lo²su² kxan²ti³ ten³ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A²nxe³jah¹lai²na² sa²kxai³lu² Pi³la²jah³la² ã³tĩ̱³ta¹hxai²hẽ¹la². Je³su²jah³la²nũ²a² ya³lu²ta²nũ²a² sa²nĩ̱³kxi²si¹jau³su² ĩ³wã̱³txi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nxa²ha¹te¹ wi¹lĩ³wa²lũ³xi²nxa²ha¹te¹ Jo³se²ah³la²kxai³lu² hi³sa³ka³txin³ti³ sa²sai¹kxã¹kxain¹ta¹hxai²hẽ¹la². Nxe³nũ²la² wã²la²ka³lo³a² lĩn²yo²ka³lo³a² wi¹ka³lo³a² sa²wa̱³lã̱u²kxi²nũ²la² txah³lxa³kxẽ¹na² sa²so¹sxã³ ũ³whi¹sxã³ ũ³tĩ̱¹kxa²wih¹ta¹hxai²hẽ¹la². Nxe³tẽ³na² kwã̱³kxa² tah²hẽn³su² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","56","Nxa²ha¹te¹ txu¹ti³nãu³xa² Ka³li³le²an¹ta¹ka³lxu³nãu³xa² a²sa³wi³ha³lxi³su² ha²kxai³ Jo³se²ah³la²kxai³ ã³si³tẽ³kxi²nũ²la² txah³lxa³kxẽ¹na² ĩ²ha²kxai³ Je³su²jah³la² ũ³whih¹wxe³je³na² ĩ²ain¹ta¹hxai²hẽ¹la². Ĩ²ain¹nũ²la² ã³ya³wa²lain¹ta¹hxai²hẽ¹la². Hã²wxãn³txa³ a²nũ²a² ya³lu²te²a² wxa²to̱¹la³kxi²jau³nũ³a² hau³ko³tain¹ta¹hxai²hẽ¹la³, txu¹ti³nãu³xa²sa³. Nxai¹nha²kxai³ ka³nxa³ha²ta² Ju³te²a² nũ̱³ka̱³txa² a²sa²ba³to³ nxe³nha²kxai³ Txa²wã¹sũ̱³na² ũ³wha²li¹txã³nxa² wet1si¹nyhain¹jau³su² hãi¹sxã³ ĩ³ye¹nxi²sxã³ yxau³ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nxa²ha¹te¹ to³mĩn²ko³ nxe³hĩ¹na² ĩ³yũ¹li²nxa³ta̱³lxa¹ txu¹ti³nãu³xa² sa²kxai³la¹ a²jã¹nxe² wa̱³lain¹ta¹hxai²hẽ¹la². Ĩ̱³yau³xa² a²nũ²a² ya³lu²te²a² wxa²to̱¹la³kxi²jau³xa² tẽ³sxã³ wa̱³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nxa²ha¹te¹ kwã̱³kxẽ¹na²kxai³lu² txah³lxa³ka³lo³a² kãin²ka³lo³a² tẽ³sxã³ ũh³yxo²tĩ¹ain¹ta¹hxai²hẽ¹la². Nxe³kxan²ta² txu¹ti³nãu³xa²kxai³lu² wa̱³lain¹tãu³a¹ kwã̱³kxẽ¹na²kxai³lu² a²ne³hẽ³txa¹ sa²yxo²than²nha²sxã³ yxau³ye³ta¹hxai²hẽ¹la². A²nxe³tẽ³na² ãn³tĩ̱³tãu³a² ĩ²te³na¹ sa²yxo²than²nha²sxã³ yxau³ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nxe³ain¹nũ²la² yxo²than²nha²sxã³ yxau³ye²ha²kxai³ ã³wi¹hain¹ta¹hxai²hẽ¹la². Nxe³ka³tu̱³ a²nũ²la³ Je³su²jah³la² Txa²wã¹hxi²kan¹jah¹lai²na² a²nũ²la³ yũ³ne¹yhe²yhain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nxa²ha¹te¹ ĩ²ai¹nxa³ha²kxai³ e³lain¹te³nah¹lxi¹: — Ĩh¹nxe³te²sin²ta²ku². Ki̱³nhĩ¹. Ain¹tãu³a² in³txa² ha¹li¹ ĩ³ha¹txi²nyhain¹ta¹hxai²hẽ¹la². A²nxe³te²a² a²wã²la³ka³lo³a² ha³te̱¹tha²kxai³ hxi²kan¹txi³ ĩ²nxũ̱n³kxi²nyhain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Txu¹ti³nãu³xa² ju¹ta² ĩ²sxã³ o²nha²sxã³ ĩ³ye³ãu²la²to³tha²kxai³ ĩ²sxã³ sa²kxu²thu¹nha²ta¹hxai²hẽ¹la². Nxe³ain¹ti̱³kxai³lu² in³txi³nãu³xa² a²wãn³txi³kxai³lu¹: — Ĩh¹nxe³kxa²ya̱n³ti³ta̱³ txah³lxẽ¹na² a²nũ²a² ya³lu²te²a² sa²nĩ̱³kxain¹tẽ³na² nũ²kxah¹lxin¹thi²ni¹? ");
INSERT INTO nabNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hĩ¹nai²li² a²nũ²a² yũ²nxa³xĩ¹. Ka³te̱n³su² ĩ³sa²yxau³xi²na²ni¹. A³li³xi²na²ni¹. Nxe³ju³kxai³lu² kxã³nxai³tã² Ka³li³le²a²ko³xa² yxau³hĩ¹nai³tã¹jau³xa² nxe³hĩ¹nai³tã² ne³ka²kxah¹lxan³sai¹ni¹? Nxe³wã²nxa²lxin¹ji¹? ");
INSERT INTO nabNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nxe³jau³xa²sa¹: “Ko̱³nxe³thin¹tũ̱³ka̱³txa² hi²sen³kxai³lu² sa²so¹sain¹nũ²la² hi³sa³ka³txa² ĩ³hxi²kĩ¹la³kxi²sain¹sxã³ ĩ³ya²lut1sain¹tu¹wi¹. Nxe³sain¹kxa²ha³ta̱³nxãn²tu̱³ ye³ha¹li¹ ka³na³ki¹ a³lan²ni²sxã³ ka³te̱n³su² ĩ³sa²yxau³xi²na¹tu¹wi¹.” Nxe³jau³xai³tã² ain³kxi²yah³lxin¹tai¹ti²tu¹ni¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Ain¹nxa²ha¹te¹ txu¹ti³nãu³xã² wãn³txa² tĩ³yau³xai³tã² sa²wa²lho¹xain¹ta¹hxai²hẽ¹la². Sa²wa²lho¹xain¹sxã³ ĩ³xain¹ka³tu̱³ a²sa³wi³ha³lxa² hxi²ka² hxan³sxã³ ka³na³ka³nat3sxã³ wa²sa²so¹xi²nũn³ka³tu̱³ nxe³tũ̱³ka̱³txa² a²sa³wi³ha³lxa² hãi¹nxe³ti³xa¹ nxe³jau³xai²na² yxo²ha³kxa¹ ĩ³hen³txain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A²nxe³txu¹txi³nãu³xa² ĩ³lxi²nyhain¹tũ̱³ka̱³txa²sa¹: Ma³ri²a² Ma³ta³lẽ²na³ka³lxa² nxe³ha²kxai³ Jo³ã²na³ka³lxa² nxe³ha²kxai³ Ma³ri²a³ka³lxa² nxe³ha²kxai³ a²nxe³ta¹ka³lxai²na³ Ti³a²kah³la² a²hã³ka³nũ²la³ta¹hxai²hẽ¹la². Ai¹nha²kxai³ txu¹ti³nãu³xa² ka³lxa¹txi³ a³li³ain¹nũ²la² a²sa³wi³ha³lxi³nũ̱³ka̱³txa² ĩ³ha¹txi²sxã³ nxe³jau³xai²na² ĩ³hen³txi³nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nxe³nyhain¹tah¹lxa¹ a²sa³wi³ha³lxi³nũ̱³ka̱³txa² jau³jau¹xai²na² hai³txi³ yxo²ĩ²nyhain¹ta¹hxai²nxa³hẽ¹la³: — Toh³li³ta² wãn³txai²la¹wi¹. Nxe²e³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nxa²ha¹te¹ jau³jau¹xai²na² ain³kxi²nũ²la² Pe²jah³la² ĩ³sa²yxau²ã³ka³tu̱³ Je³su²jah³la² kwã̱³kxẽ¹na² txah³lxẽ¹nãn²ta³ ã³nih³nũ²la² ã³ku²thu²kxa¹sxã³ ã³wih¹ta¹hxai²hẽ¹la². Ã³wih¹nũ²la² wã²la²ka³lo³a² Je³su²jah³la² ẽ³kxain¹ka³lo³a² so¹lxi³ sxa³ne²yhe²ta¹hxai²hẽ¹la². Yxãn¹ta¹ Je³su²jah³la² yũ³ne¹yhe²ta¹hxai²nxa³hẽ¹la². Nxe³sxã³ a³li³sxã³ ĩ³xi²tãu³a²: — Ĩh¹nxe³te²sin²sun²kũ¹. Nxe² e³nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nxa²ha¹te¹ sũn²ta³txai²na² a²sa³wi³ha³lxa² ha¹lin¹te²a² Je³ru³sa³lẽ²thĩ³na² a³li³nũ²la² E³ma³u²thĩ³na² ai³ya³ta¹hxai²hẽ¹la². Nxe³thĩ³na² 10 ki³lo²me³tro³ nxe² u²lxi³ye²ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nxe³ya³ti̱³kxai³lu² Je³su²jah³la² ya³lu²ju³ta² e³kxi²nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nxe³yah³nxa²ha¹te¹ Je³su²jah³la² ĩ³hi¹tai³lhxã³ a²tĩh³na² ai³le²tĩh³na² ĩ³ha¹txi²ya³ta¹hxai²hẽ¹la². Ĩ³ha¹txi²sxã³ ã³sa²so¹ã³ya³ka³tu̱³ ai³yah³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yxãn¹ta¹ ko̱³nyhain¹ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Ai³ya³hin¹tãu³a² ĩh¹nxe³jau³ta̱³ wã̱³wã̱³nx2ti³jau³ta̱³ e³la³hin¹thi²li¹? Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nxa²ha¹te¹ ã³yit1txã²ha¹te¹ Kle³o²pah³la² ãin²ta³kxi²nha²sxã³ e³kxi²te³nah¹lxi¹: — Je³ru³sa³lẽ²thĩ³na² ha³la³ka³lxa³lo³nĩn¹kxan²ti³ jau¹xai²na² ã³ne³wxe³nxa²nxa³ta³lu¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Ĩh¹nxe³jaut3ta̱n³te²la¹xã³? Ta¹hxai²hẽ¹la². Nxa²ha¹te¹ ĩ³wa²lũ³xi²ya³ti³an¹jau³kxai³lu¹: — Je³su²jah³la² Na³sa³re²thĩ³nãn¹jah¹lo²su¹. Nxe³jah¹lai²li² Txa²wã¹sũ̱³na² wãn³txa² hen³txi³jah¹lo²su¹. Ain¹ta¹hẽ¹li¹. Ai¹nha²kxai³ hxi²kan¹nẽ³lxa³ju³ta² kãin² o²la³kxi²sain¹sĩn¹na²hẽ³li¹. Nxe³ju³tai²na² Txa²wã¹sũ̱³na² wãn³txa² wain³txi³ sa²yxo²we¹jah¹lo²su² ye²ta¹hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nxe³to³ta¹ wã³nxĩn¹ta² si³yxau³tũ̱³ka̱³txi³su² te²nãu³xa² txa²wã¹hxi²kan¹ti³su² te²nãu³xa² ain¹sxã³ ĩ³ya²lut1si¹jau³su² ĩ³yĩ¹li²hain¹ta¹hẽ¹li¹. Nxain¹ju³tan¹te²kxa³ya̱³lhu² hxi²kĩ¹la³kxain¹ta¹hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nxe³kxan²ti³ Txa²wã¹sũ̱³na² A²hxi²kan¹jah¹lai²li² I³sa³e² nũ̱³ka̱³txa² wxa²wa²su¹tũ¹nhẽ³jah¹lo²su² te²ji¹xã¹. Nha¹jau³su² nxe³sã²nha¹kxa²yu³su² ye³ha¹li¹ ka³na³ki¹ a³la²ni²te²jai¹tu³wi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jã¹nxe³kxa²yu³su² ĩ³yũ¹li²nxa³ta̱³lxa¹ txu¹ti³nãu³xa² kwã̱³kxẽ¹na² ai³ain¹tãu³a² ĩ³wã̱³wã̱³ta³kxi²sa²sĩ¹nhẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Je³su²jah³lo²la³ hai³txi³ ĩ²ain¹ta¹hxa³hẽ²li¹. Hã²wxãn³txa³ ĩ³xain¹nũ²la² e³kxi²sain¹te³nah¹lxi¹: “Hxi²sxã³nho³jut3sũ̱³ju³ta² ĩ²sĩ¹na¹hẽ³li¹. Nxe³ju³tai²na² oh³xan¹jah¹la²nãu³xa² ĩ³hen³txi³sain¹sĩn¹te³nah¹lxi¹: ‘Je³su²jah³la² ka³te̱n³su² yxau²na³ni¹.’ Nxe³sain¹sĩn¹na²hẽ³li¹.” Nyhain¹ta¹hẽ¹li¹. Nxe³jau³xai²na² on²txi³khaix1sa²sĩ¹nhẽ²li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jã¹nxe³ha²kxai³la¹ txa²wã¹nũ̱³ka̱³txa² ka³na³ki² sa²nĩ̱³kxi²tẽ³na² ã³nxai³nũ²la² ĩ³hen³txi³sain¹sĩ¹kxa²yã¹nxe³jut3su² ĩ²ain¹ta¹hẽ²li¹. Nxe³ta¹ Je³su²jah³lo²la³ hai³txi³ ĩ²ain¹ta¹hxa³hẽ²li¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nxa²ha¹te¹ Je³su²jah³lai²na² wãn³txi³kxai³lu¹: — Wxãi²na² ã³ne³to³ti³he¹nxe³nx2ti³xa³wi¹. Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³nũ̱³ka̱³txa² e³ain¹jau³xai³tã² wa³su¹txi³ ã³ne³wxe³yah²lxa³lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nxe³jau³xai³tã² ĩ³ye³kxũ¹ain¹te³nah¹lxi¹: “Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la² ju¹tai²na² ha³kxa¹ ye³khãuh³lxa³ti³sain¹tu¹wi¹. Nxe³sxã³ ĩ³su²lhã³ain¹sãn²ka³tu̱³ hã²wxãn³txa³ ka³te̱n³su² ĩ³sa²yxau³xi²tu¹wi¹. Nxe³te²kxa³kxa¹ kãin² wxi²kin³ti³ton³tu¹wi¹.” Nxe³jau³su² ĩ³ye³kxũ¹nẽ³lain¹ta¹hxai²hẽ¹li¹. Nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nxe³nũ²la² ũ³wha²li¹txã³nxa² tẽ³nũ²la² Moi³se²ah³lu¹tai²na² ũ³wha²li¹jau³xa² a²yxo²ha³kxa¹ Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³nũ̱²ka̱³txu¹tai²na² wãn³txa² ũ³wha²li¹jau³xa² a²yxo²ha³kxa¹ nxe³jau³su² tẽ³nũ²la² Je³su²jah³la² su²lhã³ain¹ju³ta² ĩ³yau¹ũ¹nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nxa²ha¹te¹ E³ma³u²thĩ³na² ya̱u³son³nxa²ha¹te¹ ã³wa²to¹te³lhxã³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yxãn¹ta¹ ã³yit1tũ²la² e³kxain¹te³nah¹lxi¹: — Txa²sxi²ha² sxa³sxã³ ãu³xi²sẽ¹li¹. Ka³nxah³hi²nẽ³te³na³li¹. Ain¹ta¹hxai²hẽ¹la². Nxe³jau³su² ha²kxai³ sxi²ha² ã³wi¹yhah³lxi³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nxa²ha¹te¹ ã³wi¹nhũ²la² ĩ³yain³te³lhxã³ ã³wxe³ain¹nũ²la² yain³tũ̱³xa² hxi²tẽ³nha²nũ²la² Txa²wã¹sũ̱³na² ĩ³wi¹lxon³kxi²ki̱³jau³su² ĩ³ye³kxi²ta¹hxai²hẽ¹la². Hã²wxãn³txa³ yain³tũ̱³xa² ha³la³tãu²lxũ¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nxe³ju³tai²na² ĩ²ai¹nhĩ¹na¹ ã³ye³wxe³ain¹ta¹hxai²hẽ¹la². Ain¹ta¹ ã³ye³wxe³ai¹nhĩ¹na¹ wã³sã² yxain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nxa²ha¹te¹ e³kxi²nyha¹te³nah¹lxi¹: — Wãn³txa² ĩ³yau¹ũ³nẽ³lhĩ¹na¹ ĩ³xi²ki̱³tãu³a² txa²wã¹ẽ¹nãu³ai²na² ka³lih³khaix1nẽ³lhẽ²li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nxa²ha¹te¹ wa³su¹txi³ ĩ³sa²yxau³nũ²la² Je³ru³sa³lẽ²thĩ³na² wa̱³lain¹ta¹hxai²hẽ¹la². Nxe³tãu³a² a²sa³wi³ha³lxa² hxi²ka² hxan³sxã³ ka³na³ka³nat3sxã³ wa²sa²so¹xi²nũn³ka³tu̱³ nxe³nũ̱³ka̱³txi³su² te²a² a²sa³wi³ha³lxa² ka³lxa¹txi³ nũ¹nain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nxain¹sxã³ ĩ³ye³kxain¹te³nah¹lxi¹: — Ya²la³tu̱³ Txa²wã¹hxi²kan¹jah¹la² ka³te̱³nai²la¹wi¹, Si³mãu²ah³la² ĩ²ye²ha²kxai³lu¹. Ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nxa²ha¹te¹ ĩ³ye³kxi²ya³te³nah¹lxi¹: — Ĩ³xi²nha¹tãu³a² Txa²wã¹sũ̱³na² wãn³txa² yxo²ha³kxa¹ ĩ³hau³ko³tũh¹sa²sĩn¹na²li¹. Nxe³ha²kxai³ sxi²ha² wi³xi²sĩ¹na¹ka³tu̱³ hã²wxãn³txa³ yain³tũ̱³xa² wxa²nxũ²xai³sa²sĩ¹nhĩ¹na¹ ã³ye³wxe³sa²sĩ¹nhẽ²li¹. Sĩ¹na¹jut3su² Je³su²jah³la² ka³te̱n³ti³ yxau²na³li¹. Ye¹nx2ta¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nxa²ha¹te¹ ĩ³hen³txain¹ti̱³kxai³lu² Je³su²jah³la² hi²sen³kxai³lu² a²sa³wi³ha³lxa² a²nxũ²kwa̱i³wi³tãu³a² wxã³sxã³ ã³yũ²txi²ta¹hxai²hẽ¹la². Nxe³sxã³ ĩ³ye³kxi²te³nah¹lxi¹: — Yu̱h³lxah³lxi³txa³hẽ¹li¹. Wi¹lxo³kxix1jah³lxi³hẽ¹li¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yxãn¹ta¹ on²tai¹nha²kxai³ nxe²e³kxain¹te³nah¹lxi¹: — A²yãu³ka³txi³su² ji¹xã¹. Nyhain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nxa²ha¹te¹ Je³su²jah³la² ĩ³ye³kxi²te³nah¹lxi¹: — Ĩh¹nxe³ka²ya̱n³ti³ta̱³ ĩ³wã̱³wã̱³ta³kxi²nha²sxã³ on²txi³nx2ta¹ji¹wi¹? ");
INSERT INTO nabNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Txa²hxi²ka² ĩ² txa²yu̱³kxa² ĩ² nxe³sah¹lxi³hẽ¹li¹. Wxa²wxai³sain³sah¹lxin¹kxai²nãn²tu̱³ yxo²ĩ²syah¹lxin¹tu¹wi¹. Txai²li² a²yãu³ka³txi³sin²nxa³wi¹. Yxãn¹ta¹ a²nũ²khai³sa¹wi¹. Nxe³ju³tai²na² a²yãu³ka³txa² hai³txi³ a²sĩ̱n³ta³ yũ²nxa³ha²kxai³ hai³txi³ a²su³la³ yũ²nxa³ha²kxai³ nxe³te²jai¹tu³wi¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nxe³nũ²la² a²hxi²ka² wã²nã³ũ¹hi² a²yu³kxa² wã²nã³ũ¹hi² nxe³sxã³ wã²nã³ũ¹ta³kxi²nha²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nxe³ta¹ ka³lih³khaix1ain¹kxan²ti³ hai³txi³ yxo²ĩ²ain¹ta¹hxai²nxa³hẽ¹la². Nxa²ha¹te¹ ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Yain³txa² ũ³hũ¹sah¹lxi³hẽ¹li¹. Ĩ³yain³te³la¹wi¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nxe³nũ²la² a̱i³na² hi̱³nha²te²a² ũ³hũ¹ain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ai¹nha²kxai³ wxa²nhĩ²yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nxa²ha¹te¹ ãh¹ ĩ³ye³kxi²te³nah¹lxi¹: — Nxe³na¹ju³tai²li² ĩ³yau¹ũ³nx2ta¹tai¹tu³wi¹. Txa²wã¹sũ̱³na² ha³te̱h³nxã³nxa² yxo²ha³kxa¹ ya²la³tu̱³tai¹tu³wi¹. Moi³se²ah³lu¹tai²na² wãn³txa² ya²la³tu̱³ti² Txa²wã¹sũ̱³na² wãn³txa² ĩ³hen³txi³tũ̱³ka̱³txu¹tai²na² wãn³txa² ya²la³tu̱³ti² Ta³vi²yah³lu¹tai²na² wãn³txa² ya²la³tu̱³ti² nxe³tai¹tu³wi¹. Sa²yxo²we¹nha²sxã³ kãi³ta³lun²na¹hẽ³li¹. Je³su²jah³la² ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nxe³te³na¹ Txa²wã¹sũ̱³na² ha³te̱h³nxã³nxai³tã² ĩ³la³kxi²ti³hi¹tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","— Jã¹nxe³sxã³ Txa²wã¹sũ̱³na² ha³te̱h³nxã³nxa² ĩ³yau¹ũ³sa²jau³su² nxe³te³nah¹lxi¹: “Txa²wã¹sũ̱³na² A²hxi²kan¹ta² Si³yxau³tãu³lo³jah¹la² kãin² ye³khãuh³lxa³ti³sãn²nũ²la² ya³lu²tu¹wi¹. Yxãn¹ta¹ ye³ha¹li¹ ka³na³ki¹ a³lan²ni²sxã³ ka³te̱n³su² ĩ³sa²yxau³xi²tu¹wi¹.” Txa²wã¹sũ̱³na² ha³te̱h³nxã³nxa² nxe³ta¹hxai²hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nxe³ju³tan¹te²kxa³ya̱³lhu² a²nũ²a² ko̱³nxe³ti³ kãi³sxã³ yxau²xai³ju³ta² ĩ³ãin²ta³kxi²nha²sxã³ Je³su²jah³la² yxo²ĩ³ain¹kxai²nãn²tu̱³ ko̱³nxe³ti³ kãi³ain¹kxa² yo³ha² ã³wa²su¹ti³hi¹tu¹wi¹. Nxe³jau³xai²na² Je³ru³sa³lẽ²thĩ³na² ĩ³hen³txi² ã³si³wxe³ka³tu̱³ hu³ a²nũ²a² nũ̱³ka̱³txa² ka³lxa¹txi³nãu³xa² yxo²ha³kxa¹ ĩ³hen³txi³txain¹yah³lxi³hẽ¹li¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nxe³jau³jau¹xai²na² wãn³txa² tĩ³yau³xu¹tai²na² ĩ³ye³kxũ¹jau³xu¹tai²nãn²tu̱³ Txai²na² sa²kxai³lu² sa²yxo²we¹nha²sxã³ kãi³ta³lu²na¹tai¹ti²tu³wi¹. Nxe³ju³tai²na² ã³ye³yxo²nũ¹kxa² nũ̱³ka̱³txi³su² yah³lxi¹lxi¹. ");
INSERT INTO nabNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nxe³yah³lxi¹nha²kxai³ ye³jen¹na² Txa²wã¹sũ̱³na² Yãu³ka³jxah¹la² ĩ³sa²si¹hã³ũh¹nx2ta¹tu¹wi¹. Nxe³ju³ta² Txa²wã¹wĩ³na² ĩ³ye³kxũ¹nx2ti³tai¹ti²tu³wi¹. Jã¹nxe³ha²kxai³ Je³ru³sa³lẽ²thĩ³na² wah³nxe² yxau³jah¹lxi³sã²nhẽ³li¹. Sũ̱³na² Yãu³ka³txa² a³ka³nxa² wxã³sxã³ ã³si³tẽ³kxi¹nx2ti³hĩ¹na¹ ĩ³hxi²ka¹ti³hi¹txa²ti³tu¹wi¹. Nxe³ye¹nx2ta¹wi¹. Je³su²jah³lo²kxai³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ĩ³ye³ta³lun²nũ²la² a²sa³wi³ha³lxa² ã³sa²so¹nũ²la² Je³ru³sa³lẽ²thĩ³na² a³li³ain¹ta¹hxai²hẽ¹la². A³li³nũ²la² Be³tãn²ya³thĩ³na² ai³ain¹ta¹hxai²hẽ¹la². Ain¹ka³tu̱³ ã³yit1tũ²la² a²hxi²ka³la¹nha²ta²hxai²hẽ¹la². Nxe³sxã³ wãn³txa² wi¹lhin¹ti³hit1jau³su² a²sa³wi³ha³lxa² ne³nxẽ³na² ĩ³ye³kxi²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nxe² ĩ³ye³kxi²tãu³a² ã³waix3sxã³ oh³xa² ka³la³xi²ye²ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nxa²ha¹te¹ a²sa³wi³ha³lxi³nãu³xu¹ta²kxai³lu² Txa²wã¹sũ̱³na² sa²nẽn¹kxi²jau³su² e³kxain¹nũ²la² Je³ru³sa³lẽ²thĩ³na² ka³lih³kxi²sxã³ ã³wa̱³lain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nxain¹ka³tu̱³ Txa²wã¹sũ̱³na² sxi²ha² ã³wih¹to³hain¹sxã³ Txa²wã¹sũ̱³na² sa²nẽn¹kxi²to³hain¹ta¹hxai²hẽ¹la².");
INSERT INTO nabNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Txa²wã¹si³kxã³nãu³u¹tai²na² A²wãn³txi³khai³su² jah¹la² yxau³ta¹hxai²hẽ¹la². A²yen³kxa² yũ²nxa³ha²kxai³ a²nũ²a² yũ²nxa³ha²kxai³ nxe³tãu³u¹tai²na² jah¹la² so¹lxi³ yxau³ta¹hxai²hẽ¹la². A²wãn³txi³khai³su² Jah¹la² sa²kxai³lu² Txa²wã¹sũ̱³na² Si³yxau³tãu³la³ yxau³ya³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nxe³sxã³ A²wãn³txi³khai³su² Jah¹la² sa²kxai³lu² yxau², Txa²wã¹sũ̱³na² Si³yxau³tãu³la³ yxau², txa²wã¹si³kxã³nãu³u¹tai²na² nxe³ya³yhu¹ta¹hxai²hẽ¹la². A²wãn³txi³khai³su² Jah¹lain²txi³, Txa²wã¹sũ̱³na² Si³yxau³tãu³ain²txi³ nxe³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A²nxe³jah¹la² hxi²ka² a²yen³kxa² yxo²ha³kxa¹ wet1sa²sai¹ta¹hxai²hẽ¹la². A²yen³kxa² we¹txa³kxe³su² wã³ko³kxe³su² ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A²wãn³txi³khai³su² Jah¹la² sa²kxai³lu² ka³te̱³na² si³yxau³tãu³su² tãu³a² sa²kxai³lu² nxe³ta¹hxai²hẽ¹la². A²nxe³jah¹la² sa²kxai³lu¹ ka³te̱³na² wi¹tãu³a¹ ũ³hũ¹nhẽ³lha²kxai³, tĩh³na² wain³tĩh³na² so¹lxi³ wi¹tĩh³na² so¹lxi³ ĩ³yau¹ũ³nẽ³lha²kxai³, nxe³sxã³ sa²ha²te¹kxi²nẽ³jut3sũ̱³nxe² a²nũ²a² yxo²ha³kxa¹ nxe³te²ki̱³na¹xai²na¹ sa²hau³ko³tẽ³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nxe³sxã³ sa²ha²te¹jah¹lai²na² sa²kxai³lu² ka³nxah³ju³ta² sa²ha²tet1sa²tẽ³na³la². Nxe³kxan²ta² hxi²kan¹txi³ a²ta³a² hxi²ka², ka³nxah³ta² a²wa³kxẽn³yah³la² hxi²ka², ko̱³nxe³ti³ kãi³si¹nhẽ³jah¹la² hxi²ka², wxa²nũ¹li²nxa³wa². Ha³lo²a² nxe³jut3sũ̱³na³la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nxe³nxa²ha¹te¹ in³txa² Jo³ãu² Ba³tis²jah³lo²su² ta¹hxai²hẽ¹la². A²nxe³jah¹la² Txa²wã¹sũ̱³na² Si³yxau³tãu³a¹ ĩ³sa²si¹hã³kxe³su² jah¹la² ta¹hxai²hẽ¹la². Nxe³ha²kxai³ txa²wã¹ha³lo²ai²na² wxã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wxã³nũ²la² sa²ha²te¹kxi²nẽ³jah¹lai²na² sa²kxai³lu², Je³su²jah³lo²su² te²kxai³lu² ũ³yhe³ka¹tẽ³te³lhxã³ wxã³ta¹hxai²hẽ¹la². A²nũ²a² hãi¹nxe³ti³xa¹ Sũ̱³na² sa²yxo²wet1si¹nhẽ³jau³nũ³su² Jo³ãu² Ba³tis²jah³la² wxã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hai³txi³ Jo³ãu² Ba³tis²jah³lo²la³ sa²ha²te¹kxi²nẽ³jah¹lo²su² ta¹hxai²nxa³hẽ¹la². Hãi¹nxe³sxã³ sa²ha²te¹kxi²nẽ³jah¹la² ũ³yhe³ka¹tẽ³te³lhxã³ Jo³ãu² Ba³tis²jah³la² wxã³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yxãn¹ta¹ kwẽn¹tai²na² sa²ha²te¹kxi²nẽ³jah¹lo²khai³xa², a²nũ²a² yxo²ha³kxa¹ sa²ha²te¹kxi²nẽ³jah¹lo²su² jah¹la², txa²wã¹ha³lo²ai²na² ã³wxã³te³lhxã³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","11","A²nxe³jah¹la² sa²kxai³lu² ha³lo²ai²na² yuh³xan¹ko³xai²na² yãn³tai²na² wet1sa²sai¹ta¹hxai²hẽ¹la². Yxãn¹ta¹ kwẽn¹tai²na² ha³lo²ai²na² wxã³ye²yhain¹kxan²ti³ hxi²kan¹kxan²ti³ ha³lo²an¹tũ̱³ka̱³txi³la³ hãi¹nxe³sxã³ wã̱³txi³nũ¹yhain¹ta¹hxai²hẽ¹la². Jã¹nxe³kxan²ti³ a²ka³lxa¹ta² sxi²ha² ã³wxã³ye²yhain¹kxan²ti³ a²ka³lxa¹ti³su² te²la³ Ju³te²a² nũ̱³ka̱³txi³la³ha²kxai³ ã³yxo²o³tũ²ain¹to³ta¹hxai²nxa³hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ain¹nxa²ha¹te¹ a²nũ²a² ka³na³ki² o̱n³tãu³su² tãu³a¹ ã³yxo²o³tũ²yah³lxi³ka³tu̱³ sa²we¹tain¹ta¹hxai²hẽ¹la². — A²nxe³tãu³su² tãu³a¹ yxo²ha³kxa¹ Sũ̱³na² Si³yxau³tãu³a¹ wẽ³ha³lxai²la¹i¹. Je³su²jah³la² wãn³txa² hxi²kan¹txi³ ĩ³wẽ³ha³lxi³lo³tain¹jau³su² yain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sũ̱³na² wẽ³ha³lxa² wẽ³ha³lxi³lo³tẽ³ju³ta²sa¹: Hãi¹nxe³sxã³ Sũ̱³na² wẽ³ha³lxi³lo³kxe³su² te²nãu³xa² so¹lxi³ Sũ̱³na² wẽ³ha³lxin³te²ju²hẽ³la². Yxãn¹ta¹ a²nũ²a² hxi²kan¹khai¹nxe³kxan²ti³ a²wẽ³sa² we¹kxa² yuh³xai²nãn¹te² wẽ³sa² so¹lxi³ wet1sa²kxai³, a²nũ²a² a²ẽ¹nãu³a¹ wẽ³nhĩ²nha²kxan²ti³ yuh³xai²nãn¹te² wẽ³sa² so¹lxi³ wet1sa²kxai³, in³txa² txu¹ha² ten³nha²yu³kxan²ti³ yuh³xai²nãn¹te² wẽ³sa² so¹lxi³ wet1sa²kxai³ te²ju²hẽ³la². Jã¹nxe³sxã³ Sũ̱³na² wẽ³ha³lxi³lo³kxe³su² te²a² a²nũ²a² Je³su²jah³la² sa²we¹tain¹te²su² te²nãu³xa² so¹lxi³ wẽ³ha³lxi³lo³tain¹ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nxe³nxa²ha¹te¹ A²wãn³txi³khai³su² jah¹lai²na² sa²kxai³lu² Je³su²jah³lo²su² te²kxai³lu¹ ha³lo²ai²na² wxã³ta¹hxai²hẽ¹la². Txa²wã¹nũ²ãin²ti³ wen¹nũ²la² a²nũ²khai³su² wen¹nũ²la² ha³lo²a² yuh³xan¹ko³xai²na² wxã³ta¹hxai²hẽ¹la². Jũ¹nxe² kxãn³su² yxau³ya³nhẽ³ta¹hxai²hẽ¹la². Nxe³ju³ta² a²ya̱³li³nãu³xa² a²ye³na² ĩ²ain¹ta¹hxai²hẽ¹la². Ĩ²ain¹ju³ta²su¹: A²wãn³txi³khai³su² jah¹lai²na² wxi²kin³ti³ton³ta¹hxai²hẽ¹la². Txa²wã¹wĩ³na² si³yxau³jah¹lo²khai³xa² a²ki³lha³lxa² hãi¹nxe³te²a², hãi¹nxe² we¹kxe³su² te²a² sa²kxai³lu² wxi²kin³ti³ton³khaix1ta¹hxai²hẽ¹la². A²nxe³jah¹lo²su² te²kxai³lu¹ kãin² hãun²ya¹ta² wi¹lhin¹jah¹lo²su² nxe³ha²kxai³ a²ya³la³lyau³tu̱³ a²si³yxau³tãu³su² nxe³ha²kxai³ ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nxe³nxa²ha¹te¹ Jo³ãu² Ba³tis²jah³la² ĩ³kaix1sxã³, Je³su²jah³la² hxi²kan¹khaix1ju³ta² ĩ³yau¹ũ³nhẽ³te³lhxã³ ĩ³kaix1te³nah¹lxi¹: — Jah¹lai²na² txa²si³yo³na¹ wxã³jah¹lai²la¹i¹. Yxãn¹ta¹ sa²sen³sai¹sa²sxã³ hxi²kan¹khaix1jah¹lai²la¹i¹, yãn³ta² yũ³sa²nxa³hĩ¹nu¹tai²na² yxau²xai³jah¹lo²su² ha²kxai³lu¹. Ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jah¹lai²na² kãin² hãun²ya¹ta² wi¹lhin¹jah¹lo²su² ta¹hxai²hẽ¹la². Nxe³ha²kxai³ kãin² hãun²ya¹ta² wi¹lhin¹sxã³ a²nũ²a² yxo²ha³kxa¹ ki̱³na¹xai²na² whãi²na¹, sa²hau³ko³tẽ³ta¹hxai²hẽ¹la². ");
INSERT INTO nabNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jã¹nxe³ju³ta²sa¹ Moi³se²ah³lu¹tai²na² Sũ̱³na² wã²nxa³kxa² so¹jah¹lo²su² ta¹hxai²ti³ai¹ti²tu³wa². A²nxe³jah¹lu¹tai²na² Sũ̱³na² wãn³txa² ĩ³kwa³na³nẽ³jau³xu¹tai²na² tẽ³nũ²la² txa²wã¹si³yah³la²nãu³u¹tai²na² ĩ³