﻿USE sofia;
DROP TABLE IF EXISTS sofia.mzz_vpl;
CREATE TABLE mzz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mzz_vpl WRITE;
INSERT INTO mzz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Valea Giamaina dede Ieisu Keliso Yaubada Natuna paipaina. Nakabavelamu topalimatamatana imai tomoꞌotoqa inavonedi inavalabubuna. ");
INSERT INTO mzz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Base Yaubada natovesipupu Aisea igililia Yaubada ivesipupu ivo, “Kunoqai, naqai gutopalimatamatana aikalaqeieni inagumeta mukenao inavusia. ");
INSERT INTO mzz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Walakaimaiqe topalimatamatananina bonana bwaiginaeqa ieqoleqole ivo, ‘Tomwaya nakeda kwavusia, nakabatauya kwaisivetonovidi.’” ");
INSERT INTO mzz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Beqa Dioni topalimatamatananina imai walakaimaiqe tomoꞌotoqa ibabitaisodi wete Yaubada navalea tomoꞌotoqa waidie ilalauguguyeni ivo, “Mikapoinaeqa kwanuavila, we Yaubada mikapoina inanuataqonidi. We aibabitaisomi nuavila kanakiakiaya waimie, paina gunabei mikapoinaeqa kwanuavila.” ");
INSERT INTO mzz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Beqa tomoꞌotoqa matatabudi imiamia Iudia navikai naqeneye wete Ielusalema vanuqa balasi naqeneye isauyedi inaqo Dioni inavevaneneqeni. Tutuyanina dikapoina ivesipupuyedi, Dioni ibabitaisodi bwasi Iolidani waineye. ");
INSERT INTO mzz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","We Dioni kaleko mwesimwesiana ikweseni kaisaya kanawavaqa kameli* vutuvutunaeqa iyoqonidi, we kanawakila talobwana waineye ivewakileni kaisaya bununaeqa ivalabubunidi. Tutuya puena limwana wete maikawa ikanikani. ");
INSERT INTO mzz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","We tutuya puena tomoꞌotoqa ivonevonedi ivo, “Muligue tamo tomoqo imaimai. Gumanina veluvelulunaotoqina matautauda Yau, beqa Yau ge kagusala kanakaqe yapayapa kanabulava aisobwanu aiqeuya. ");
INSERT INTO mzz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yau amaiqa bwasieqa aibabitaisomi, we gumanina muligue imaimaiqa Yaubada Vaitabuna Giamaina beqa inababitaisomi.” ");
INSERT INTO mzz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","No tutuyanina waineye, Ieisu itauya Nasaletaeqa vikai Galili naqeneye inaqo Dioni waineye, we bwasi Iolidani waineye, Dioni Ieisu ibabitaisoi. ");
INSERT INTO mzz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","We tutuyanina bwasieqa ipoia, ikisalaga abame. Abama ikawapiai, we Yaubada Vaitabuna ikiseni kanakisa mesai malasi iobuma waineye ilugu. ");
INSERT INTO mzz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","We abameꞌeqa Yaubada bonana isauyeni ivo, “Komu, Natugu nuapougu. Avenapwayewemu, wete amwasanemu bwaigina.” ");
INSERT INTO mzz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yaubada ivoneni ikakava, we no waineye vedimadimanaeqa Yaubada Vaitabuna Giamaina Ieisu ivetuneni inaqo walakaimaiqe. ");
INSERT INTO mzz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Noko waineye kaiata 40 naqedie walakaimaiqe imiamia, we Seitani iekautovoni wayaqina kapoina waineye inayatoi. Walakaimaiqe imiamia kaisaya walawalakai gamwadie, we mulineye Yaubada naꞌanelose abameꞌeqa imai kanakaivaisa iveleni. ");
INSERT INTO mzz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","No tutuyanina waineye Kini Elodi gunabei Dioni Tobabitaiso vanuqa kabakaimatavuloqa waineye iginoleni, matautauda Ieisu inaqo Galili waineye tomoꞌotoqa waidie Yaubada navalea ivesipupuyeni. ");
INSERT INTO mzz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","No waineye iesipupu ivo, “Tutuya gunabei ilekwa. Yaubada nakedakeda kaivauna natomoꞌotoqa kadiloina paipaidi saiqanaqa inamai. Mikapoinaeqa kwanuavila, we Valea Giamaina kwavetumaqaneni.” ");
INSERT INTO mzz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","We tamo kaiata waineye Waya Galili kwadeweye ilalauvasana tovuata kadikailuqa ikisedi, Saimoni metaina Anidulu divuataeqa iyayaubani waya waineye. ");
INSERT INTO mzz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ikisedi iveqole waidie ivo, “Kwamai kwavemuliegu. Mesai de iqana kwakonakonadiqa, we Yau aivevemi banikodiqa tomoꞌotoqa kwaikonadi kwaimaiedi waigue inavetumaqanegu.” ");
INSERT INTO mzz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","No waineye vedimadimanaeqa divuata ibailedi ivemulieni. ");
INSERT INTO mzz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","We ivemulieni iveqanaqo saiqanaqa kwadeweye Ieisu Sebedi menatunavo Diemesi, Dioni ikisedi divuata kawalabukina iyaqiyaqili diwaga waineye. ");
INSERT INTO mzz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","We divuata iyaqiyaqili Ieisu iveqole waidie ivo, “Kwamai. Kwavemuliegu.” Beqa tamadi menatolituqavo wageye ikiawedi, we ivemulieni. ");
INSERT INTO mzz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","We tutuyanina ilekwa tamo vanuqa kanawavaqa Kapeneumi waineye, no Kaiata Kabaveyawai* waineye Ieisu ilugu vanuqa kabavelaukui* naqeneye iekaivevena Yaubada navalea tomoꞌotoqa waidie. ");
INSERT INTO mzz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Taunina navelulunaeqa iekaivevena, we ge mesai loina kaditovekaivevenavo iekaivevena beqa tomoꞌotoqa nuadi ivilele bwaigina. ");
INSERT INTO mzz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","We tutuyanina vanuqa kabavelaukui* naqeneye iekaivevena, we tomoqo vaitabu kapoina iekuniqeni iveqole bonana bwaiginaeqa ");
INSERT INTO mzz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ivo, “Banikodiqa, uvale kumai waimeye, Ieisu tomoqo Nasaleta? Kumai de waineye kileoma? Ayagovimu komu Yaubada Natuna Vesivesinuana.” ");
INSERT INTO mzz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","We Ieisu ivona bonana veluveluluninaeqa ivo, “Kuvekwada! Tomoqo kubaileni. Kusauyemu. Kunaqo.” ");
INSERT INTO mzz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Matautauda vaitabu kapoina ibwau bonana bwaiginaeqa tomoqonina ivelaudididiqa we vaitabu kapoina tomoqo waineye isauyeni. ");
INSERT INTO mzz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tutuyanina isauyeni tomoꞌotoqa puedi nuadi ivilele kaisedi waidie iesipupu ivo, “Dede vakai? Dede vekaivevena kaivauna wete menaveluluna. We tomoqonina menaveluluna vaitabu kapoidi iloinedi naloina ivematamataneni.” ");
INSERT INTO mzz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","We tutuyanina waineye vikai Galili matatabuna naqeneye vedimadimanaeqa Ieisu valeana bwaigina paipaina isapayavula. ");
INSERT INTO mzz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","We vedimadimanaeqa Ieisu mekanatovemulivo vanuqa kabavelaukui* ikiaweni inaqo Saimoni metaina Anidulu divanuqe Diemesi, Dioni ikweyabudi. ");
INSERT INTO mzz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tutuyanina waineye Saimoni lawana mokamokaidi vovodi iveyauyauta iviqa kadikivi waineye ikenokeno, no waineye Ieisu ivoneni paipaidi. ");
INSERT INTO mzz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Beqa inaqo ilugu waidie dimadie ikavikavina isivetovoidi. Vedimadimanaeqa vovodi yauyauta ikakava matautauda kadi isiobu ikani. ");
INSERT INTO mzz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","We tutuyanina gunabei lavilavie, valavala iketoniveni tomoꞌotoqa ditoviqavo wete gumanidiavo vaitabu kapoidi iekuniqedi ikewadi imaiedi Ieisu waineye. ");
INSERT INTO mzz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","We tomoꞌotoqa puedi vanuqa bwaigina waineye isikauqidi vanuqa mataneye. ");
INSERT INTO mzz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Vanuqa mataneye Ieisu tomoꞌotoqa puedi kadiviqa sulidi, sulidi ikavegiagiamaidi wete mesai gumanidiavo vaitabu kapoina waidie iveuqeuqedi isauyedi. We vaitabu kapoidi iyagovi Ieisu Yaubada Natuna Vesivesinuana beqa ge idatagwanedi tamo vakai inavesipupuyedi. ");
INSERT INTO mzz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","We matalovalovanineye Ieisu itovoi vanuqa ikiaweni inaqo kawalawamaiqe no waineye Yaubada waineye iesipupu. ");
INSERT INTO mzz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mulineye Saimoni mekanakweyabuvo inaqo ilalaualeni. ");
INSERT INTO mzz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","We ibabaneni ivoneni ivo, “Tomoꞌotoqa puedi ilalaualemu.” ");
INSERT INTO mzz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ibaivila ivonedi ivo, “Kwamai tainaqo vanuqa tupwaidiavo sulidi vivideye waidie. Yaubada navalea aivesipupuyeni tomoꞌotoqa waidie. De lamunanina amai.” ");
INSERT INTO mzz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Beqa Galili kanamatatabu waineye inaqo Yaubada navalea ilauguguyeni vanuqa kabavelaukui* naqedie wete vaitabu kapoidi tomoꞌotoqa waidieꞌeqa iveuqeuqedi isauyedi. ");
INSERT INTO mzz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tamo kaiata tamo tomoqo mekanaviqa bununeye kanawavaqa lepelo imai Ieisu waineye manawaneye isobwanu ielaukui vaivaituqana ivo, “Kago wayaqimu kigiavemaqetagu.” ");
INSERT INTO mzz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","We Ieisu tomoqo bonana inoqai nuana inaqei dimana isiketoi ikavikavini ivo, “Eee, Yau tagwatagwanigu. Kuvegiagiamai!” ");
INSERT INTO mzz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","We vedimadimanaeqa tomoqo bununeye lepelo ikakava ivegiagiamai vaituqana. ");
INSERT INTO mzz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wete Ieisu bonana veluveluluninaeqa ivoneni ");
INSERT INTO mzz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ivo, “Ge tamo aitoi kivoneni paipaigu, we vedimadimanaeqa kunaqo tovelomu* waineye kuvekaivevenemu. We kinaqo velomu kikalaqei Mosese naloina mesai kiakiaya tomoꞌotoqa waidie gunabei kuvegiagiamai.” ");
INSERT INTO mzz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","We tomoqonina Ieisu ge idavekimataneni inaqo vikai puena waidie tomoꞌotoqa ivonevonedi, we valea isapayavuleni vikai puena waidie. Beqa Ieisu ge kanasala inanaqo vanuqa bwaigidi waidie tutuyanina tomoꞌotoqa ietonovi paina kago mesai yoko bwaigina inamai. Beqa vikai bwaigidi ikiawedi inaqo kawalawamaiqe, we no waineye tutuya puena imiamia. Wete vikai puedi waidieꞌeqa kaditomotoqavo inaqo Ieisu waineye. ");
INSERT INTO mzz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kaiata tupwaidiavo ikakava Ieisu ivila vaituqana inaqo Kapeneumi waineye, we tupwaidiavo tomoꞌotoqa gunabei inoqai imai vanuqe. ");
INSERT INTO mzz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tomoꞌotoqa puedi imiakauqa vanuqa waineye vanuqa iveadaꞌadaqeni ge tamo kabamia wete vanuqa kawaneye mesai. We Ieisu iesipupu Yaubada navalea waidie. ");
INSERT INTO mzz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","We tomoqovo kadikumapuli sevusevu waineye tomoqo bwalobwalogona ikavalai imaieni vanuqe. ");
INSERT INTO mzz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tutuyanina imaieni vanuqe ikisedi tomoꞌotoqa yoko puedi keda itutubodabodai ge kadisala inanaweni Ieisu waineye. Beqa luvewana waineye ilagaveni vanuqa tabwaneye itaviponuya ikakava. Tomoqonina bwalobwalogona mesevusevuna iveonoqi mekanabulava ivekilaloi makanuadi iobu Ieisu manawaneye. ");
INSERT INTO mzz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","We tutuyanina iobu Ieisu manawaneye bwalobwalogona ikiseni wete divetumaqana ikiseni beqa ivoneni ivo, “Natugu, mukapoina gunabei anuataqonidi.” ");
INSERT INTO mzz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","We no waineye tupwaidiavo Mosese naloina kanatovekaivevenavo iekalamia. Ienuana nuapoudie ivo, ");
INSERT INTO mzz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kaia Yaubada kaisena kanasala kapoina inanuataqonidi. Banikodiqa de mesai iesipupuyedi? Beqa ivovonamaimaiqa Yaubada isiwataoni iesipupu mesai nigo Yaubada kadikailuqa idavesala!” ");
INSERT INTO mzz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","We vedimadimanaeqa Ieisu vaitabunaeqa dinuanuana iyagovi ivonedi ivo, “Komi uvale we mesai kwaenuanedi nuapoumie? Gunabei nuapoumi akisedi. ");
INSERT INTO mzz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Dede memeqanina tamo tobwalogo waineye anavo, ‘Mukapoina gunabei anuataqonidi’ paina ge tamo aitoi idayagovi oge inalausimatala. We dede ge memeqanina tamo tobwalogo aivoneni, ‘Kutovoi kamusevusevu kukewai kutauya kunaqo,’ paina tomoꞌotoqa kadisala inakiseni vakai inasauyeni. ");
INSERT INTO mzz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Beqa Yau aivona vakai mwauna aivalabubuni beqa no kwaiyagovi veluluna Yaubada ivelegu, Yau Mwaqitana Kanatomoqo,* we meguveluluna kapoina ainuataqonidi pwayapwaya waineye.” Matautauda bwalobwalogona ivoneni ivo ");
INSERT INTO mzz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Avonemu kutovoi kamusevusevu kukavalai kunaqo muvanuqe.” ");
INSERT INTO mzz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tomoqo bwalobwalogona vedimadimanaeqa itovoi kanasevusevu ikavalai itauya, we tomoꞌotoqa puedi ietonovi wete nuadi ivilele Yaubada ididigeni ivo, “Ge tamo yawaida waineye valabubunanina tadakiseni.” ");
INSERT INTO mzz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ieisu mekanatovemulivo Kapeneumi ibaileni inaqo Waya Galili vivineye. We yoko bwaigina imai waineye Ieisu Yaubada navalea iekaivevena waidie. ");
INSERT INTO mzz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tutuyanina iveqanaqo saiqanaqa ikiseni tomoqo kanawavaqa Libai tamana Alipio imiamia nakabalituqa naqeneye takisi ikewakewa Loma gabemani paipaina. Ieisu iveqole waineye ivo, “Kuvemuliegu.” Libai itovoi ivemulieni. ");
INSERT INTO mzz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mulineye Ieisu Libai navanuqe lavilavie ikanikani. Takisi kanatokewavo puedi wete tomoꞌotoqa kapoidi taiau tutuya puena Ieisu itatalakwavini gumanidiavo, wete Ieisu mekanatovemulivo taiau ikanikani. ");
INSERT INTO mzz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","We tupwaidiavo Mosese naloina kanatovekaivevenavo, yoko tupwaidiavo Palisivo*, ikiseni Ieisu takisi kanatokewavo wete tomoꞌotoqa kapoidi taiauda ikanikani beqa kanatovemulivo ivonedi ivo, “Vakai paipaina tomoꞌotoqa dede takisi kanatokewavo we tomoꞌotoqa kapoidi taiau ikanikani?” ");
INSERT INTO mzz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tutuyanina Ieisu divona inoqai ivesipupu waidie ivo, “Tomotoqanidiavo togatogagadi ge doketa paipaina inanuanuana. Gebuka! Gumanidiavo toviqa kadisala doketa inalaualeni.” We ivesipupu waidie, “Yau ge tomoꞌotoqa giamaidi paipaidi adamai. Yau tomoꞌotoqanidiavo kapoidi paipaidi amai.” ");
INSERT INTO mzz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tamo kaiata Dioni Tobabitaiso kanatovemulivo we tupwaidiavo Palisivo* iekudiqana tapwololo paipaina. No waineye tomoꞌotoqa tupwaidiavo imai ivoneni ivo, “Dioni kanatovemulivo wete Palisivo* kaditovemulivo iekudiqana, we banikodiqa komu kamutovemulivo giladi ikanikani ge idaekudiqana?” ");
INSERT INTO mzz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","We Ieisu ivonedi ivo, “Tutuyanina tomoqo vavine inanaqia tomoqonina enavo, banikodiqa iekudiqana? Gebuka! Tutuyanina meꞌenavo taiau ge idaekudiqana inakani velataubama medimwasana. ");
INSERT INTO mzz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tamo kaiata tomoqonina kanatalavualavo gamwadieꞌeqa inakewai. Kaiatanidiavo no waidie inaekudiqana paina nuadi inakapo.” ");
INSERT INTO mzz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wete ivonedi ivo, “Yau dede nuanuana kaivauna amaieni aivekaiveveneni waimie ge mibubuna tutuaina taiauda idavesala. Kaleko tutuaina ge kanasala kaleko kaivauna beqa kibwadai. Kago mesai kailegwa waineye inakawalabuki paina kaleko kaivauna inaqoqova, we kalekonina tutuaina inakawalabuki. ");
INSERT INTO mzz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wete mesai ge kanasala oine* kaivauna inaꞌiwaqi inaobu oine* kabaꞌiwaqa kaisaya bununa tutuaina waineye. Kago no mesai aitoi inavalabubunediqa kaisaya bununa inakawapiai paina oine* inapatai inavetageyoi kaisaya bununa ge kanasala kaisena inapatai. Beqa oine* wete kaisaya bununa inakavekapoi. Gebuka! Ge de mesai inavalabubunediqa we tomoꞌotoqa oine* kaivauna inaꞌiwaqi inaobu kaisaya bununa kaivauna waineye.” ");
INSERT INTO mzz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Me-Diu Dikaiata Kabaveyawai* waineye Ieisu mekanatovemulivo inaqonaqo witi kanatanoqa naqeneye. Tutuyanina inaqonaqo kanatovemulivo witi vuadi igadidi ikanikani. ");
INSERT INTO mzz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","We tupwaidiavo Palisivo* ikisedi no mesai ivavalabubunedi Ieisu ivoneni ivo, “Kukiseni! Daketoboda imiamia ge Kaiata Kabaveyawai* waineye tailituqa, we uvale kamutovemulivo ilitulituqa Kaiata Kabaveyawai* waineye?” ");
INSERT INTO mzz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","We ibaivila Palisivo* waidie ivo, “Aa dede gililinina Buki waineye, Deibida wete enavo taiauda ivalabubuni tutuyanina ilase wayaqidi inakani beqa gunabei kwawawai kwanoqai, we uvale ge kwadanuakawananaqaia? ");
INSERT INTO mzz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Deibida Yaubada navanuqa naqeneye ilugu ivelaukui tupwaidiavo beledi paipaidi. No tutuyanina Abiata natutuya tovelomuvo bwaigidi kaditogumeta* waineye itagwaneni Deibida tupwaidiavo beledi iveleni. No beledinina pilopilona, we gunabei ikalaqeieni Yaubada mataneye. Kaia tovelomu* kaditagwana beledinidiavo inakanidi, we Deibida tupwaidiavo ikanidi. Wete ikewadi tupwaidiavo iveledi tomoꞌotoqa taiau imiamia ikani, we Yaubada ge idakawakapoieni.” ");
INSERT INTO mzz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","We wete ivonedi, “Yaubada Kaiata Kabaveyawai* ivalabubuni tomoꞌotoqa kadikaivaisa paipaidi. We Yaubada ge tomoꞌotoqa idavalabubunidi Kaiata Kabaveyawai* inakaivaiseni. ");
INSERT INTO mzz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yau Mwaqitana Kanatomoqo* beqa Kaiata Kabaveyawai* Yau Kanatomwaya!” ");
INSERT INTO mzz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tamo Kaiata Kabaveyawai* waineye Ieisu ivila vaituqana ilugu vanuqa kabavelaukui* naqeneye tomoqo dimana gemwayana ikiseni imiamia. ");
INSERT INTO mzz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","We tupwaidiavo tomoꞌotoqa wayaqidi Ieisu inakuvani, beqa iematakaikaieni kago togemwaya inakavegiagiamaia Kaiata Kabaveyawai* waineye. ");
INSERT INTO mzz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","We tomoqo dimana gemwayana ivoneni ivo, “Kumai kutovoi tomoꞌotoqa matadie.” ");
INSERT INTO mzz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Matautauda ivelautoliedi ivo, “Vakaiebei loina giamaina Kaiata Kabaveyawai* paipaina: Giamaina taivalabubuni oge kapoina taivalabubuni? Oge tomoqo yawaina taiketoyavuya oge tomoqo yawaina taikavekapoi?” Ge tamo aitoi navelautoli idabaivilai. ");
INSERT INTO mzz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Matautauda Ieisu mekanakapoka waidie ikisalelele. Beqa Ieisu nuana ikapo divedebapakala paipaina. Matautauda tomoqo dimana gemwayana ivoneni ivo, “Dimamu kusiketoi.” We dimana isiketoi ivegiagiamai vaituqana. ");
INSERT INTO mzz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Beqa Palisivo* itauya inaqo Kini Elodi kanatokaivaisavo waidie, taiauda nuanua italaqi Ieisu inaluvewapai. ");
INSERT INTO mzz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Beqa Ieisu mekanatovemulivo inaqo Waya Galili doleneye. Yoko bwaigina Galilieqa italakwavini. Tomoꞌotoqa puedi valea inoqai Ieisu kabanuavilele** ivalabubunidi paipaidi beqa imai waineye Iudia eqa, Ielusalema, Idumea wete tupwaidiavo vikai Iolidani bwasi vivineye waidieꞌeqa we Taia wete Saidoni vividie waidieꞌeqa. ");
INSERT INTO mzz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Tomoꞌotoqa puedi Ieisu gunabei ikavegiagiamaidi beqa toviqa iebipelapela wayaqidi Ieisu inakavikavini. Paina yoko bwaigina, we Ieisu ge wayaqina inabibini beqa kanatovemulivo ivonedi ivo, “Waga kwavalabubuni paipaigu inakenokeno.” ");
INSERT INTO mzz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","We tutuya puena vaitabu kapoidi tomoꞌotoqa iekuniqedi Ieisu ikiseni isobwanu mataneye iveqole ivo, “Komu, Yaubada Natuna!” ");
INSERT INTO mzz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","We ivona veluveluluna ivo, “Ge tamo aitoi kwaivoneni Yau paipaigu.” ");
INSERT INTO mzz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ieisu ilaga koyeye tomoqovo gumanidiavo wayaqina iqoledi imai waineye. ");
INSERT INTO mzz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tutuyanina imai waineye tomoqovo 12 ivesinuedi taiauda inanaqo we kadiwavaqa iqoledi apositolovo*. We ivonedi ivo, “Yau wayaqigu komi taiauda taimiamia mulineye aivetunemi kwainaqo Guvalea Giamaina kwailauguguyeni tomoꞌotoqa waidie. ");
INSERT INTO mzz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","We tutuyanina aivetunemi lauguguya paipaina veluluna aivelemi kamisala wete vaitabu kapoidi kwaikwavinedi tomoꞌotoqa naqedie.” ");
INSERT INTO mzz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","We apositolovo* 12 ivesinuedi kadiwavaqa deqoidi: Saimoni (Ieisu iqoleni Pita kananuanuana gileu), ");
INSERT INTO mzz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi natunavo Diemesi taina Dioni taiauda, Ieisu iqoledi Boanege (kananuanuana Kanitala Natunavo) ");
INSERT INTO mzz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anidulu, Pilipi, Batolomiu, Madiu kanawavaqa tamo Libai, Tomasi, Diemesi, Alipio natuna, Tadiasi, Saimoni gumanina Seloti ");
INSERT INTO mzz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","we Iudasa Isakaliota gumanina Ieisu kanatoketoqiluva. ");
INSERT INTO mzz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","We Ieisu mekanatovemulivo taiauda inaqo tamo vanuqa waineye ilugu, we yoko bwaigina isikauqa vaituqana waineye, we ge kadisala inakani. ");
INSERT INTO mzz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tutuyanina nasusuvo inoqai paipaina ivo, “Gumanina qauqauna”, we inaqo wayaqidi imaseagai inanaweni divanuqa waineye. ");
INSERT INTO mzz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tutuyanina Ieisu nasusuvo inaqo, tupwaidiavo Mosese naloina kanatovekaivevenavo Ielusalemaeqa iobuma iesipupu, “Bialesibubi kaisena gumanina vaitabu kapoidi kaditogumeta Ieisu iekuniqeni! Vaitabu kapoina ditogumeta naveluluna beqa kanasala vaitabu kapoidi inakwavinedi.” ");
INSERT INTO mzz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Beqa Ieisu loina kanatovekaivevenavo iqoledi waidie ivesipupu vonawakedubalaeqa ivo, “Banikodiqa, Seitani kanasala Seitani inakwavineni? ");
INSERT INTO mzz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kago kabaloina tamoqana inaketovegeia yoko kailuqa taiau inaetalaqa we no kabaloinanina ge kanasala inakenokeno. ");
INSERT INTO mzz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wete mesai susu tamoqana inaketovegeia yoko kailuqa ediavo taiau inaetalaqa we no susunina ge kanasala inakenokeno. ");
INSERT INTO mzz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Beqa kago Seitani nakabaloina inaketovegeia nayokovo taiau inaetalaqa ge kanasala inakenokeno kaia inakakava. ");
INSERT INTO mzz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Dede vonawakedubala Seitani paipaina: Ge tamo aitoi kanasala tomoqo veluvelulunina navanuqe inalugu nasakuvo inavainaqodi, we naqaida tomoqonina veluvelulunina inayoqoni matautauda kanasala nasakuvo vanuqeꞌeqa inavainaqodi. ");
INSERT INTO mzz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yau avona mwaqitana waimie Yaubada kanasala tomoꞌotoqa dikapoina puena wete divonamaimaiqa ge medivekimatana puena inanuataqonidi. ");
INSERT INTO mzz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","We kago aitoi Yaubada Vaitabuna ge inavekimataneniqa paipaina inavonamaimaiqa, Yaubada ge kanasala nakapoinanina inanuataqoni, we nakapoinanina inakenovaqata.” ");
INSERT INTO mzz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","We Ieisu de mesai ivonedi, paina vaitabu kapoidi ikekewaluguaqetedi Yaubada Vaitabuna naveluluna beqa, we tomoꞌotoqa vonamaimaiqaeqa iesipupu Yaubada Vaitabuna waineye paina iesipupu ivo, “Vaitabu kapoina Ieisu iluguya.” ");
INSERT INTO mzz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ieisu nasusuvo imai ilekwa vanuqa waineye maleweye itovotovoi. Tamo tomoqo ivetuneni inaqoleni. ");
INSERT INTO mzz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","We yoko bwaigina imia kwaikwaipipineni we tupwaidiavo tomoꞌotoqa ivoneni ivo, “Inamu, taimwavo, novumwavo maleweye ilalaualemu.” ");
INSERT INTO mzz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ibaivila waidie, “Aitoi gumanina inagu wete eqavoi taigwavo?” ");
INSERT INTO mzz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Matautauda ikisalelele tomoꞌotoqa ikisedi imia kwaikwaipipineni ivo, “Kwakiseni! De tomoꞌotoqanidiavo kaia Yau inagwavo wete taigwavo! ");
INSERT INTO mzz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aitoi gumanina Yaubada nanuanuana ivavalabubuniqa gumanina taigu, novugu wete inagu.” ");
INSERT INTO mzz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wete Waya Galili vilaneye Ieisu ivelamu iekaivevena vaituqana. Yoko puedi inaqo inoqai iesipupu, we waga waya tabwaneye ieputeyeni waineye idodoqa naqeneye imiabui, tomoꞌotoqa puedi itovotovoi kwadeweye. ");
INSERT INTO mzz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ieisu vonawakedubalaeqa iesipupu, wete iekaivevena tomoꞌotoqa waidie saku puena paipaidi. ");
INSERT INTO mzz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Vona wakedubalaeqa ivonedi ivo, “Dede kwanoqai. Tamo tomoqo natanoqa ivuani waipei isapayavuledi natanoqe. ");
INSERT INTO mzz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tutuyanina waipei isasapayavuledi waipei tupwaidiavo ibeku kedeye, manuqa imai ikanidi. ");
INSERT INTO mzz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","We waipei tupwaidiavo ibeku lasalasa waidie pwayapwaya ge bwaigina we kaia itabwa ilaga, ");
INSERT INTO mzz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","we kwalamidi ge idaobuotoqa beqa valavala igabu tabwadinidiavo siaidi imwatu. ");
INSERT INTO mzz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","We waipei tupwaidiavo ibeku iobu mosomoso mwalamwalaqidi waidie itabwa ilaga mosomoso mwalamwalaqidi itaula vuyovuyoidi ge vuadi idayatodi. ");
INSERT INTO mzz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","We waipei tupwaidiavo ibeku iobu pwayapwaya giamaina waineye itabwa giagiamai. Tupwaidiavo ivuaqa giamaina mesai 30, tupwaidiavo ivuaqa saiqana giamaina mesai 60 wete tupwaidiavo ivuaqa giamaiotoqidi mesai 100.” ");
INSERT INTO mzz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","We Ieisu ivonedi ivo, “Kago komi metaniqami, guvona kwainoqai vakai aesipupuyeni waimie.” ");
INSERT INTO mzz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tamo tutuya Ieisu mekanatovemulivo kadiyoko 12 wete tomoꞌotoqa tupwaidiavo ivelautolieni vonawakedubala paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ieisu ibaivila ivonedi, “Komi gumanimiavo gunabei avesinuemi valea vavaigavudi aigiavemaqetaimo waimie, Yaubada nakedakeda kaivauna tomoꞌotoqa kadiloina paipaidi gunabei ielamu inasauyedi paipaidi. Ge kanasala tomoꞌotoqa sulidi waidie aivesipupu luguaqeta, we kaia aivesipupu vonawakedubalaeqa. ");
INSERT INTO mzz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yau mesai aivalabubunediqa paina melamuna base tamo Yaubada natovesipupu Buki waineye igililia kanamwaqitana inalausimatala, ‘No inalauala, inalauala ge kanasala inakiseni o inayagovi, We no inavevaneneqa, inavevaneneqa ge kanasala inayagovi, kago mesaida inanoqai nuadi inakawananaqai dikapoinaeqa inanuavila wete Yau dikapoina ainuataqonidi.’” ");
INSERT INTO mzz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ieisu ivelautoliedi ivo, “Banikodiqa, ge kwadayagoviqa kananuakawananaqai vonawakedubala kanagiavemaqeta? Vakai vonawakedubala kwaiyagovi? ");
INSERT INTO mzz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tomoqo waipei isasapayavuleni mesai gumanina Yaubada valeana iesipupuyeni tomoꞌotoqa waidie. ");
INSERT INTO mzz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tupwaidiavo tomoꞌotoqa mesai waipei ibeku keda waineye—vonanidiavo inanoqai we Seitani inamai vedimadimanaeqa inakewayavuledi. ");
INSERT INTO mzz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","We tupwaidiavo tomoꞌotoqa mesai waipei ibeku iobu pwayapwaya lasalasana tabwaneye—Yaubada valeana inanoqai medimwasana, ");
INSERT INTO mzz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","we kwalamidi ge idaobuotoqa wete ge inakalamaqiqita tutuya kaniakwanina. We tutuyanina waineye veviqa wete ketotovona inalekwa waidie paina Yaubada valeana ietumaqaneni paipaina, vedimadiamanaeqa divetumaqana inakakava we inabaileni. ");
INSERT INTO mzz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tupwaidiavo tomoꞌotoqa mesai waipei ibeku iobu mosomoso mwalamwalaqidi waidie itabwa ilaga. De tomoꞌotoqanidiavo valea inoqai ");
INSERT INTO mzz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","we inuanuana tupwaidiavo saku paipaidi yawaidi dimia waineye, we wayaqiotoqidi mane wete tupwaidiavo saku. We sakunidiavo valea ikaivuyovuyoidi, we ge idavuaqa. ");
INSERT INTO mzz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","We tupwaidiavo tomoꞌotoqa mesai waipei ibeku iobu pwayapwaya giamaina waineye. Valea inoqai inuapwateni ivuaqa, tupwaidiavo 30, tupwaidiavo 60 wete tupwaidiavo 100.” ");
INSERT INTO mzz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ieisu ivonedi ivo, “Mwaqitana, tomoꞌotoqa maqeta ge kanasala somala dibuneye inayatoi, o ge ginae beqa inatalapwateni? Beqa kanasala somala tabwaneye inayatoi. ");
INSERT INTO mzz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Saku vavaigavudi matatabuna kaia mesai beqa Yau kanasala aigiavelausimataledi, we saku tumutumudi mesai noko beqa Yau kanasala aisinawedi. ");
INSERT INTO mzz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","We kago komi metaniqami kwainoqai vakai aesipupuyeni waimie.” ");
INSERT INTO mzz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ieisu ivonedi ivo, “Kwavevaneneqa vekavekai kwainoqai. Kago ketoavanina kwaivelituqeni, wete Yaubada ketoavanina inavelituqeni waimie, we Yaubada inakavesulaiotoqidi. ");
INSERT INTO mzz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Paina aitoi gumanina Yaubada navona inavekimataneniqa, Yaubada nayagova inakavesulaidi. We gumanidiavo Yaubada navona ge idavekimataneni, inakaivuyovuyoi vakai siaina inoqai.” ");
INSERT INTO mzz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ieisu ivo, “Vesipusipupu dede banikodiqa Yaubada nakedakeda kaivauna isauyeni natomotoqavo inaloinedi paipaina: Tomoqo waipei ibagulidi natanoqe. ");
INSERT INTO mzz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lovane ikenokeno, we kaiate ilitulituqa, we tutuya puepuena waipei ilagalaga, we banikodiqa itabwetabwedimo tomoqonina ge idayagovi. ");
INSERT INTO mzz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pwayapwaya kaisena libi igigiavetabwadi, naqaida inaketopia inatabwa inalaga matautauda inalaga inalaga inavetageyoiotoqa matautauda inavuaqa. ");
INSERT INTO mzz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","We tutuyanina kanikani inagumaqa, tomoqo tavi inavelamu.” ");
INSERT INTO mzz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ieisu ivo, “Vakai vonawakedubala kanasala aivonemi Yaubada nakedakeda kaivauna isauyeni natomotoqavo inaloinedi paipaina? ");
INSERT INTO mzz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yaubada nanuanuana dede mesai kailugu bilana siaiotoqidi tomoꞌotoqa ibagubagulidi. ");
INSERT INTO mzz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","We kago inatabwa inalaga inavebwaigaotoqa ge mesai tupwaidiavo mosomoso, dimana inavelaqalaqadi beqa kaikwakuneye kanasala manuqa waineye inaveqiuva.” ");
INSERT INTO mzz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","We Ieisu tomoꞌotoqa ivonedi vonawakedubala puena beqa, we tomoꞌotoqa de mesai ivesipupuyedi kadiketowaveye inayagovi. ");
INSERT INTO mzz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","We Ieisu kaia vonawakedubalaeqa iesipupu waidie, we tutuyanina tovemulivo kaisekavadi ieyaqoyagova waineye vakai puena igiavemaqetadi waidie. ");
INSERT INTO mzz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","No kaiatanina, lavilavie, Ieisu kanatovemulivo ivonedi ivo, “Kwaidodoqa taibala Waya Galili vikaineye.” ");
INSERT INTO mzz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Giladi wageye imiamia kanatovemulivo idodoqa taiauda ibala. We tomoꞌotoqa puepuedi ikiawedi ibala mali vikaie tupwaidiavo waga taiau. ");
INSERT INTO mzz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tutuyanina yaqina bwaigina ivelamu inunuqa, we kaiayava waga inigenigei, bwasi waga ituvedovedodoqi. ");
INSERT INTO mzz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","We waga mulineye Ieisu ikenokeno kanakenolaulagata waineye. We kanatovemulivo igololo bwaigina ilauvaqoni ivo, “Kutovoi, kutovoi! Kida saiqanaqa taiwapa. Tovekaivevena, komu paipaida kunuanuana kago mesai taiwapa?” ");
INSERT INTO mzz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Itovoi ivonedi bonana veluvelulunaeqa ivo, “Yaqina, nunuqa kaiana!” Wete kaiayava ivonedi, “Kwakawataqonimi!” Wete yaqina ivekwada, we kaiayava iniwalova. ");
INSERT INTO mzz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Beqa ivonedi ivo, “Vakai paipaina kwagololo? Wete vakai paipaina giladi ge kwadavetumaqanegu?” ");
INSERT INTO mzz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","We tovemulivo igololo bwaigina kaisekavadiqa iesipupu, “Aitoi tomoqo dede? Menaveluluna yaqina wete kaiayava ivonedi ivekwada, we navona ivematamataneni.” ");
INSERT INTO mzz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ieisu mekanatovemulivo itupa ilekwa Waya Galili doleneye, no vikainina waineye me-Gelasa tomoꞌotoqa divikai. ");
INSERT INTO mzz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kaiatanina waineye Ieisu waga waineyeꞌeqa iobu, vedimadimanaeqa tamo tomoqo ovu* waineyeꞌeqa imai. Tomoqo dede vaitabu kapoidi iluguya isasasaleni. ");
INSERT INTO mzz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","Basenaqai ge tamo aitoi kanasala inavekuniqeni—tutuya matatabuna kaqena wete dimana taiauda seni beqa iyoqonidi. We tutuya matatabuna isenia, we seni isidabadabadi beqa ge tamo aitoi kanasala inasenia. Kaiata wete lovana naqedie isasasala koyeye we taumata gamwadie imiamia ieqoleqole wete taunina gileueqa ilalaqi. ");
INSERT INTO mzz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","We kaiatanina kanikieꞌeqa ikisanaqo Ieisu ikiseni matautauda ilaukwavina ilaukwavina inaqo manawaneye isobwanu. ");
INSERT INTO mzz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","We Ieisu ivoneni ivo, “Vaitabu kapoina tomoqo waineyeꞌeqa kuluguaqeta!” We tomoqo iveqole bonana bwaiginaeqa ivo, “Ieisu Yaubada Tabwaotoqineye Natuna! Vakai wayaqimu waigue? Yaubada kanawavaqaeqa avelaukuiemu ge kikaniqodadaqeguqa!” ");
INSERT INTO mzz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","We Ieisu ivelautolieni, “Banikodiqa kamuavaqa?” We ibaivila ivo, “Dede meyokoma beqa kamawavaqa Ligioni.” ");
INSERT INTO mzz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","We giladi ielaukui ielaukui Ieisu waineye vaitabu kapoidi ge inavetunedi vikaimaiqe inasauyedi. ");
INSERT INTO mzz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","We koya vivineye bawe yoko bwaigina iduaduala, ");
INSERT INTO mzz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","beqa vaitabu kapoidi Ieisu ivelaukuieni ivo, “Kuvetunema kainaqo bawe waidie, beqa kanasala naqedie kailugu.” ");
INSERT INTO mzz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ieisu itagwanedi mesai inavalabubunedi, we vaitabu kapoidi tomoqo waineyeꞌeqa isauyedi inaqo bawe waidie ilugu. We koyeyeꞌeqa bawenidiavo matatabudi mepatalina kadiyoko 2,000 ivelalaukwavina iobu bwaqale iobu waya naqeneye ivekalamonumonu. ");
INSERT INTO mzz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","We tomoꞌotoqanidiavo bawe kaditovekisabodaboda igololo ideqa inaqo tomoꞌotoqa waidie vakai isauyeni ivesipupuyeni vanuqa bwaigidi wete vanuqa siaidi waidie. No waineye yoko puedi inaqo wayaqidi vakai isauyeni inakiseni, ");
INSERT INTO mzz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","we Ieisu waineye imai ikiseni base tomoqonina vaitabu kapoidi iluguyaqa kanawavaqa Ligioni. We kanakaleko ikweseni imiamia wete nuana ge idaqau. No waineye tomoꞌotoqa puedi igololo. ");
INSERT INTO mzz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tomotoqanidiavo ikiseniqa tomoꞌotoqa tupwaidiavo ivonedi vakai isauyeni tomoqonina vaitabu kapoidi iluguyaqa wete bawe paipaidi. ");
INSERT INTO mzz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Beqa Ieisu ivoneni divanuqa inakiaweni. ");
INSERT INTO mzz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tutuyanina Ieisu wageye idododoqa, we tomoqonina vaitabu kapoidi iluguyaqa Ieisu ivelaukuieni ivo, “Kanasala taiauda tainaqo?” ");
INSERT INTO mzz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","We Ieisu ge idatagwaneni beqa ivo, “Kuvila mususuvo waidie kuvonedi Tomwaya saku bwaigina ivalabubuni waimue ikavegiagiamaimu, we mwaqitana ivenapwayewemu.” ");
INSERT INTO mzz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Beqa tomoqonina inaqo vanuqa bwaigidi kadiyoko Teni Kawalawa (Dekapolisia) waidie iesipupu vakai Ieisu gunabei ivalabubuniqa paipaina, we puepuedi inoqai nuadi ivilele. ");
INSERT INTO mzz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ieisu wagaeqa itupa ivila vaituqana ibalama Waya Galili doleneye. Tutuyanina ibalama vikaineye waya doleneye itovotovoi, wete tomoꞌotoqa imai itovoi kwaikwaipipineni. ");
INSERT INTO mzz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","We tamo tomoqo kanawavaqa Iailo imai no waineye gumanina vanuqa kabavelaukui* iekisabodebodeni. We tutuyanina Iailo Ieisu ikiseni inaqo ilekwa waineye kaqena iveketonokuyedi. ");
INSERT INTO mzz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Matautauda ivelaukui veluveluluna ivo, “Yau natugu vavinena saiqanaqa inawapa beqa tainaqo dimamu kiyatoi waineye inavegiagiamai we inamiamia.” ");
INSERT INTO mzz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Beqa Ieisu taiauda inaqo, wete yoko bwaigina tomoꞌotoqa ivemulieni iekaibibibineni, we Ieisu gamwaneye itautauya. ");
INSERT INTO mzz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","We tamo vavina noko vevine kadiviqa ikewadi dayaqa iulaula diqaba 12 naqedie. ");
INSERT INTO mzz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","We disaku wete digileu matatabuna ikalaqeiedi doketa waidie, we ge kanasala idakaivaisedi. We giladi iloloala kaia kadiviqanina iebwaigamo. ");
INSERT INTO mzz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","We gunabei Ieisu valeana inoqai beqa kaisedi ienuana de mesai ivesipupuyedi ivo, “Kanasala kago kanakalekoqa kadakavikavini we kadavegiagiamai.” Beqa inaqo mulineye yoko gamwadie kanakaleko ikavikavini. ");
INSERT INTO mzz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ge tutuya kaniakwanina dayaqa iulaula isaya, we vovodie ivebaeni no viqa ikakava. ");
INSERT INTO mzz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","No kaiatanina waineye, Ieisu iyagovi naveluluna isauyeni kanalautovona ilautovoni itunuvilai yoko gamwadie ivo, “Aitoi kagukaleko ikavikavini?” ");
INSERT INTO mzz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","We Ieisu kanatovemulivo ivona waineye ivo, “Kukiseni tomoꞌotoqa ibibibinimu beqa banikodiqa kivonedimo ‘aitoi ikavikavinigu?’” ");
INSERT INTO mzz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","We Ieisu ikisalelele wayaqina tomotoqanina inakiseni ikavikaviniqa. ");
INSERT INTO mzz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vavina igololo wete ielaudididiqa paina iyagovi vakai gunabei isauyeni waidie beqa imai Ieisu waineye mataneye isobwanu matautauda vakai puepuena paipaidi ivona vekavekaieni. ");
INSERT INTO mzz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Matautauda Ieisu ivonedi ivo, “Natugu, kwavetumaqanegu beqa kwavegiagiamai. Kamiviqa gunabei ikakava beqa kwanaqo memimwasana.” ");
INSERT INTO mzz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tutuyanina Ieisu iesipupu, tupwadiavo tomoꞌotoqa imai Iailo navanuqeꞌeqa we ivoneni ivo, “Natumu vavinena gunabei yawaina ikakava beqa tovekaivevena ge kigiaveqauya.” ");
INSERT INTO mzz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","We Ieisu gunabei inoqai vakai Iailo iesipupuyeni waineye matautauda waineye ivo, “Ge kigololo kaia kivetumaqanegumo.” ");
INSERT INTO mzz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","We Ieisu inaqo Pita, Diemesi, we taina Dioni taiauda inaqo—ge tupwaidiavo yoko idatagwanedi taiauda inanaqo. ");
INSERT INTO mzz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Matautauda Ieisu mekanatovemulivo kadikaitonu ilekwa Iailo navanuqe, we tomoꞌotoqa puedi ikisedi ibwaubwau, itaitaiqa wete itaiqavolovoloqa. ");
INSERT INTO mzz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Beqa Ieisu ilugu vanuqa naqeneye we ivo, “Vakai paipaina nuami ikapo we kwataitaiqa? We gwamana dede ikenokeno ge idawapa.” ");
INSERT INTO mzz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","We inamaqaoqeni, we tovemoqai matatabudi Ieisu ivonedi isauyedi maleweye. Beqa gwamana inana tamana wete kanatovemulivo kadikaitonu taiauda ilugu tamo pitadaba naqeneye gwamana ikenokeno waineye. ");
INSERT INTO mzz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","We dimaneye ikavikavina ivoneni ivo, “Talita koum.” Kanasivila, “Gwamana siaina, avonemu kutovoi!” ");
INSERT INTO mzz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","We vedimadimanaeqa itovoi isasasala. (We gwamananina kanadiqaba 12.) We kaia tomoꞌotoqa nuadi ivileleotoqa. ");
INSERT INTO mzz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","We Ieisu igiavepakalidi ivo, “Ge tamo aitoi kwaivoneni,” we ivo, “Gwamana kanikani kwaiveleni inakani.” ");
INSERT INTO mzz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ieisu mekanatovemulivo ivila vaituqana inaqo taunina kanatuvadeye nakabataulai waineye. ");
INSERT INTO mzz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","We Kaiata Kabaveyawai* waineye Ieisu vanuqa kabavelaukui* naqeneye ivelamu iekaivevena. We tomoꞌotoqa puedi no waineye imiamia we tutuyanina inoqai nuadi ivilele. We kaisekavadiqa ivelautoliedi ediavo ivo, “Kaiebei dede nanuauya puena ikewai?” we “Banikodiqa nayagova bwaigina?” we “Banikodiqa no imai mesai kabanuavilele* ivavalabubunidi?” ");
INSERT INTO mzz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kaisekavadiqa ivesipupu ivo, “De kaia tokaiyoqona, Meli natudi we Diemesi, Diosepa, Iudasa wete Saimoni tatadi. We novunavo kaniabadi taiau tamiamia.” Beqa ibaileni ge wayaqidi inavetumaqaneni. ");
INSERT INTO mzz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ieisu waidie ivesipupu ivo, “Mali tomoꞌotoqa Yaubada natovesipupu ivekimatanedi we tomoꞌotoqa taunidi divanuqe wete disusuvo ge idavekimatanedi.” ");
INSERT INTO mzz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","We tomoꞌotoqa ge idavetumaqaneni, beqa nuana ivilele. Beqa ge kanasala tamo vakai kabanuavilele* inavalabubunidi no waineye, we kaia tomoꞌotoqa waidie dimana iyatodi ikavegiagiamaidi no vikainina waineye. We kaia ikakapavivila vanuqa waidie iekaivevena tomoꞌotoqa waidie. ");
INSERT INTO mzz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ieisu kanatovemulivo kadikuma 12 iqoledi ivetunedi kailuqa kailuqa inaqo vanuqa sulidi sulidi waidie. We veluluna iveledi vaitabu kapoidi inavelulunapeledi ");
INSERT INTO mzz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","we igiavepakalidi ivo, “Ge tamo vakai kwaikewai mitauyanina waineye kaia miutoqana—kanikani gebuka, kaleko meyawanina gebuka wete gileu kamuyawana waineye gebuka. ");
INSERT INTO mzz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kami kaqe yapayapa kwaikwesenidi, we ge tamo kaleko kwaikewadi.” ");
INSERT INTO mzz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","We ivonedi ivo, “Vakai vanuqa waineye kwainaqo kago inamwasanemi, tamo tomoqo navanuqe taiauda kwaimiamia kaiata kanamatatabu kanaketoava vanuqanina kwaikiaweni. ");
INSERT INTO mzz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","We kago kwaimai vanuqa waidie kaditomoꞌotoqa ge inamwasanemi wete bonami ge inanoqai, kwaikiawedi, we kamikaqe yapayapa kaupualina kwaitutuvutuqi inaobu. Beqa no kadivemataluana waidie inanuavila!” ");
INSERT INTO mzz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Beqa isauyedi tomoꞌotoqa waidie iesipupu ivo, “Mikapoina waidieꞌeqa kwainuavilami, we kwaisivilami Yaubada waineye.” ");
INSERT INTO mzz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","We vaitabu kapoidi ikewaluguaqetedi, we olibe* bunamana beqa toviqa puedi kunukunudi ibunamadi ikavegiagiamaidi. ");
INSERT INTO mzz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","We vikai puedi waidie tomoꞌotoqa Ieisu paipaina iesipupu, paina gunabei kanawavaqa valeana isapayavuleni. We tupwaidiavo tomoꞌotoqa iesipupu, “Kanagumanina Dioni Tobabitaiso we no waineye tomoꞌotoqa wapadi gamwadie iyawasa vaituqana beqa noko kabanuavilele* ivalabubunidi.” Tupwaidiavo tomoꞌotoqa wete iesipupu ivo, “Kanagumanina Ilaitia ivila vaituqana imai.” Wete tupwaidiavo ivo, “Kanaweye Yaubada natovesipupu basenaqai mesai Yaubada natopalimatamatana imiamia.” We Kini Elodi valea dede inoqai Ieisu nalituqa paipaina we Elodi ivo, “Dede Dioni Tobabitaiso! Base tamo tutuya gunabei tolauqavia avetuneni inaqo kodona igusuya, we deqoina iyawasa vaituqana!” ");
INSERT INTO mzz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Dede vesipusipupunina. No tutuyanina waineye Ieisu navekaivevena ge idavelamu, we Elodi taina Pilipi mwanena inaqidi vavinenidi kadiwavaqa Elodiasa. Tutuyanina waineye Dioni Elodi waineye ivesipupu ivo, “Komu, ge kanasala taimu mwanena kinaqidi,” beqa Elodi natolauqaviavo ivetunedi inaqo Dioni ikavikavini iyoqoni vanuqa kabakaimatavuloqa waineye iginoleni. We Elodi tutuya puena wayaqina Dioni inamai waineye taiau inaesipupu, we tutuyanina Dioni waineye iesipupu Elodi nuana ikapo we nuana ivilele, paina Dioni vakai ivesipupuyedi nuana ikewai, we wayaqina inaevaneneqeni. We Elodiasa kadikapoka ioqalaotoqa Dioni waineye wayaqidi inaluvewapai, we Elodi iyagovi Dioni gumanina tomoqo giamaiotoqina wete totonotonovina Yaubada waineye beqa igololoyeni we italabodebodeni. No paipaina, Elodiasa ge kanasala Dioni inaketoqiluveni inaluvewapai. ");
INSERT INTO mzz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","We tutuyanina Elodi natubuqa patina ivalabubuni, we Elodiasa dikawasasa imai kaiatanina Dioni inaketoqiluveni inaluvewapai. Kaiatanina waineye kanikani ivalabubuni gabemani kaditogumetavo, tolauqavia kaditogumetavo wete gumanidiavo guyoguyodi Galili waineye paipaidi. ");
INSERT INTO mzz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","We Elodiasa natudi vavinena imai isuya, we Elodi wete kanaulatauvo igiavemwasanidi. Beqa kini vavinenina kaniabana ivelautolieni ivo, “Vakai wayaqimu? Kanasala vakai wayaqimu aivelemu.” ");
INSERT INTO mzz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","We ivonadabadaba waineye ivo, “Yaubada waineye avonalaga vakai kivelaukuieni paipaina aivelemu mesaida Yau guvikai mesaida komu.” ");
INSERT INTO mzz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Matautauda kaniabanina isauyeni inana waidie ivelautoliedi ivo, “Vakai aivelaukuieni?” We inana ibaivila ivo, “Dioni Tobabitaiso kunukununa.” ");
INSERT INTO mzz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Vedimadimanaeqa kaniabanina ivila inaqo kini waineye Dioni kunukununa ivelaukuieni ivo, “Sideqoina wayaqigu Dioni Tobabitaiso kunukununa takula waineye kidodoqi kivelegu.” ");
INSERT INTO mzz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kini Elodi nuana ikapo, we paina base dikani kanaulatauvo taiauda waineye ivonadabadabaqa beqa ge wayaqina vavinenina inakatupwaieni. ");
INSERT INTO mzz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Beqa tamo tolauqavia ivetuneni ivoneni ivo, “Kunaqo Dioni Tobabitaiso kodona kugusuya kunukununa kumaieni.” We tamo Elodi natolauqavia itovoi itauya inaqo Dioni kodona igusuya, ");
INSERT INTO mzz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","we kunukununa takula waineye idodoqi imaieni kaniabanina iveleni ikewai inana iveledi. ");
INSERT INTO mzz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","We tutuyanina Dioni kanatovemulivo valeana inoqai, kaiatanina waineye imai Dioni vovona ikewai inaweni ovuye* iyatoi, me-Diu tubudiavo kaditaumata waineye. ");
INSERT INTO mzz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ieisu naꞌapositolovo 12 ivila imai Ieisu waineye ivoneni vakai ivalabubunidiqa wete ivekaivevenediqa tomoꞌotoqa waidie. ");
INSERT INTO mzz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","We tutuyanina waineye tomoꞌotoqa puedi imaimai waidie wete ivilavila waidieꞌeqa beqa Ieisu we kanatovemulivo ge tamo lana idakenokeno inakani. Beqa Ieisu ivonedi ivo, “Komi kaisemiqa kwaimai we yoko taikiawedi tainaqo kwaiveyawai kawalawamaiqe.” ");
INSERT INTO mzz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","We kaisekavadi wageye idodoqa itauya ibala Waya Galili waineye ge tamo tomoꞌotoqa vikainina waineye idamiamia. ");
INSERT INTO mzz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","We tutuyanina inaqonaqo tomoꞌotoqa puedi ikisedi we iyagovidi beqa tomoꞌotoqa vanuqa matatabudi waidie waya doleneyeꞌeqa italakwavini. We noko vikainina waineye naqaida ilekwa mulineye Ieisu mekanatovemulivo waga beqa ilekwa ilugu. ");
INSERT INTO mzz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","We tutuyanina Ieisu iobu wageyeꞌeqa yoko bwaigina imiamia ikisedi mesai sipi ge mekaditovekisabodaboda beqa nuana inaqei waidie Yaubada valeana iesipupuyedi. ");
INSERT INTO mzz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","We gunabei lavilavie kanatovemulivo imai waineye ivoneni ivo, “De vikainina waineye ge tamo aitoi idamiamia, we valavala gunabei inaketoniveni. ");
INSERT INTO mzz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Beqa tomoꞌotoqa kuvetunedi inanaqo gweda vivideye we vanuqa vivideye waidie taunidi kadi inagimwane.” ");
INSERT INTO mzz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","We ibaivila ivonedi ivo, “Komi kaisemi kanikani kwaiveledi inakani.” We ivoneni ivo, “Be banikodiqa, dede 200 gileu o dinali bwaigina kago taikaiyavuyavuleni beledi paipaina beqa tomoꞌotoqa yoko inakani!” ");
INSERT INTO mzz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","We Ieisu ivelautoliedi ivo, “Beledi kaivia waimie? Kwainaqo kwailauwala.” Tutuyanina ibabanedi ivoneni ivo, “Beledi dimanina we iqana kailuqa imiamia.” ");
INSERT INTO mzz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Matautauda Ieisu yoko ivonedi, “Kwamiabui katugugunaeqa mosomoso kalakalawidi tabwadie.” ");
INSERT INTO mzz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Beqa imiabui katuguguna waidie tupwaidiavo katuguguna waidie 50 wete mesai tupwaidiavo waidie 100. ");
INSERT INTO mzz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","We Ieisu beledi dimanina, iqana kailuqa ikewadi ikisalaga abama waineye paipaidi ivelaukui Yaubada waineye, matautauda beledi igiatomwai wete iqana kanatovemulivo iveledi we tomoꞌotoqa waidie ikalaqeiedi. ");
INSERT INTO mzz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tomoꞌotoqa matatabudi ikani kadisala, ");
INSERT INTO mzz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","we kanatovemulivo tomoꞌotoqa nigidi beledi tupwatupwadi wete iqana tupwatupwadi igwagwadi ginae kanayoko 12 iveadaqidi. ");
INSERT INTO mzz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","We tomoqovo kadiyoko 5,000 ivekanidi, we vevine gwagwama taiauda ge idawawadi. ");
INSERT INTO mzz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","No waineye vedimadimanaeqa Ieisu kanatovemulivo 12 ivonedi inadodoqa wageye inagumeta inabala Waya Galili Betisaida waineye, we Ieisu kaisena imiamia yoko inaveyavulidi. ");
INSERT INTO mzz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","No waineye Ieisu yoko iveduduwedi ivo, “Eee, kwanaqo,” we Ieisu kaisena itovoi itauya inaqo koya waineye ilaga ivelaukui. ");
INSERT INTO mzz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","No lovananina waineye Ieisu kanatovemulivo diwaga naqeneye Waya Galili gamwaneye inaqonaqo, we Ieisu kaisena kavale imiamia. ");
INSERT INTO mzz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","We ikisanaqo kanatovemulivo itoge ibeubeuta paina yaqina kaia ivileviledi. We saiqanaqa vanuqa inakawananaqai kawakawaie isauyeni waidie itauya inaqonaqo bwasi tabwaneye itauya didiga mesai nigodibei kago idakiawedi. ");
INSERT INTO mzz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","We tutuyanina ikisanaqo Ieisu ikiseni bwasi tabwaneye itauya imaimai we ivemegoi ivo, “Oge yalua?” Ikwekweleni. ");
INSERT INTO mzz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tutuyanina tovemulivo puedi ikiseni igololo bwaigina. We vedimadimanaeqa Ieisu ivonedi ivo, “Kwainuavatu. Kanayau. Ge kwaigololo!” ");
INSERT INTO mzz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Matautauda wageye idodoqa kanatovemulivo waidie, we yaqina ivekwada iniwalova. Kanatovemulivo nuadi ivelele, ");
INSERT INTO mzz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","paina gunabei ikiseni base beledi waineye ivalabubunidi ivepue, we giladi ge kanasala beledi kanakiakiaya ivalabubuni idanuakawananaqaia; nuadi tabodadi ge idakawabwegabwegadi. ");
INSERT INTO mzz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","We ibala Waya Galili waineye imai Genesaleta waineye no waineye diwaga ilaipweni. ");
INSERT INTO mzz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ieisu mekanatovemulivo wageye iobu tomoꞌotoqa puedi Ieisu ikinanai. ");
INSERT INTO mzz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","We ilaukwavina inaqo vikai puena waidie toviqa ikewadi imaiedi tupwaidiavo mesevusevudi vikainidiavo waineye gunabei inoqai Ieisu imiamia. ");
INSERT INTO mzz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","We vikai puedi waidie Ieisu inaqo mesai vanuqa siaidi, vanuqa bwaigidi o tanoqa kadigwedeye tomoꞌotoqa toviqa ikewadi inawedi kabavegimwane waineye iyatodi. We Ieisu ivelaukuieni ivo, “Kanasala kamukalekoqa gudina kitagwanema kadakavikavini?” We puedi ikavikaviniqa Ieisu naveluluna beqa ivegiagiamai. ");
INSERT INTO mzz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Palisivo* wete me-Diu puedi dibubuna tutuaina puedi kanavekaivevena tubudiavo waidieꞌeqa iemulieni. Kadivedi, bwasi kabagoi wete nau inalegwa vekavekaidi beqa Tomwaya mataneye giamaidi. We tutuyanina kabavegimwaneꞌeqa inavila inamai dimadi inalegwa vekavekaidi dikailegwaeqa matautauda inakani. Tutuya puena naqaida dimadi inakailegwa mulineye inakani tubudiavo divekaivevena ietutuyameni. Tamo tutuya Mosese naloina kanatovekaivevenavo Ielusalemaeqa imai Palisivo* taiauda Ieisu igamweni ievaneneqeni. Tutuyanina Ieisu ievaneneqeni, we ikisedi kanatovemulivo kadi ikanikani dimadi ge idakailegwa. ");
INSERT INTO mzz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Beqa ivoneni ivo, “Kamutovemulivo ikanikani, we dimadi bwanebwanenedi ge idakailegwa Yaubada mataneye ge maqemaqetadi. Vakai paipaina ge tubudavo divekaivevena idavemulieni?” ");
INSERT INTO mzz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ibaivila waidie ivo, “Komi tokatupoe, nuatabwamieqa nigodibei giamaimi. We base tutuya Yaubada natovesipupu Aisea igililia komi paipaimi. Igililia dede mesai: Yaubada ivesipupu, ‘Tomotoqanidiavo dede gabuladieqa ivekimatanegu, we nuapoudi imia kanikie waigueꞌeqa. ");
INSERT INTO mzz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Taunidi dibubunaeqa iekaivevena, we ivo de Yaubada naloinaeqa beqa disobwanu ge mekananuakawananaqai wete ge mevuanaqa.’” ");
INSERT INTO mzz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Matautauda ivonedi ivo, “Komi, Yaubada naloina kwabaqapeleni, we kaia taunimi mivekaivevena kwaemulieni.” ");
INSERT INTO mzz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wete waidie ivo, “Komi, kwanuani kwavo kima kavavalabubuna vekavekai, we Yaubada naloina kwabaileni, we tubumiavo divekaivevena vekavekai waidieꞌeqa kwaemuliedi. ");
INSERT INTO mzz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dede tamo keda banikodiqa kwavalabubunedi noko. Base Mosese igililia Yaubada naloina naqeneye ivo, ‘Tamamu inamu kuvekimatanedi’ wete ‘aitoi inavona kapo tamana inana waidie, tomoqonina kwaluvewapai.’ ");
INSERT INTO mzz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","We komi de mesai kwaekaivevenedi—kago aitoi mane oge saku inakalaqeieni tamana oge inana inakaivaisedi kanasala inavonedi, ‘Yau saku waigue dede kanasala aivelemi inakaivaisemi; we paina gunabei Yaubada waineye avonadabedabedi, beqa ge kanasala aivelemi.’ ");
INSERT INTO mzz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kago no mesai inavonedi, kwanavo navesipupu giamaina, kwaigiavekwadai nakaivaisa tamana inana waidie. ");
INSERT INTO mzz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kago de mesai kwaivalabubunediqa, tubumiavo divekaivevena kwaemulieni Yaubada naketoboda kwaibaia. Kaia de mesai avonemi tamo keda Yaubada naketoboda kwabaia, we puedi keda Yaubada naketoboda wete kwabaidi.” ");
INSERT INTO mzz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","We Ieisu tomoꞌotoqa iqole vaituqanedi, we imai waineye waidie ivesipupu, “Puepuemi, kwavevaneneqa vekavekai, kwaiyagovi guvona kananuakawananaqai. ");
INSERT INTO mzz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ge tamo kanikani tomoqo inakania kawaneye inalugu inakavebwanenei Yaubada mataneye. Vakai tomoqo naqeneyeꞌeqa inaluguaqeta kanasala inakavebwanenei Yaubada mataneye.” ");
INSERT INTO mzz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Matautauda Ieisu tomoꞌotoqa ikiawedi ilugu vanuqe kanatovemulivo ivelautolieni ivo, “Vakai vonawakedubala kananuakawananaqai kasiotoqa kuvesipupuyeni?” ");
INSERT INTO mzz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ibaivila ivo, “Banikodiqa? Ge kwadayagovi de kananuanuana guvona? Nuami ikawananaqaidi oge gebuka? Tomoqo kanikani inakania, ge inanaqo nuapouneye, we inanaqo gamoneye inasauyeni. Beqa ge kanasala inakavebwanenei Yaubada mataneye.” Tutuyanina ivesipupu mesai ivo, “Kanikani sulidi, sulidi giamaidi Yaubada mataneye ge tamo kanikani inakavekapoida.” ");
INSERT INTO mzz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Beqa wete ivesipupu ivo, “We vakai tomoꞌotoqa naqeneyeꞌeqa isauyeni imai, tomoꞌotoqa ikavebwanenei Yaubada mataneye. ");
INSERT INTO mzz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","De kedakedanidiavo naqeneyeꞌeqa tomoqo nuapouneye isauyedi—nuanua kapoidi, kaidale, vainaqo, tomoꞌotoqa kadiluvewapa, gimala, ");
INSERT INTO mzz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","vemomogai wete wayaqina saku tupwaidiavo, vetalavuala ivalabubuni, ketupoe, mesai kaisaya divalabubuna, vedebasagugu, kavekapo, nualaga wete, kwavakwavana. ");
INSERT INTO mzz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kedakedanidiavo puena dede iluguaqeta tomoqo nuapouneye ikavebwanenei Yaubada mataneye.” ");
INSERT INTO mzz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tutuyanina Ieisu vanuqa ikiaweni inaqo vikai Taia vivineye ilugu tamo tomoqo navanuqa naqeneye. Ge wayaqina tomoꞌotoqa inayagovi imiamia noko waineye, we ge kanasala inavaigavu. ");
INSERT INTO mzz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Tamo vavine valeana inoqai gunabei imai waineye. Dede vavinenidi ge me-Diu, we gumanidi Ponisia vikai Silia waineye itubuqa. We vaitabu kapoina natudi vavinena iluguya iviqa. Beqa imai Ieisu waineye mataneye isobwanu ivelaukui wayaqidi vaitabu kapoina natudi waineye inakwavineni. ");
INSERT INTO mzz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","We Ieisu iyagovi gumanidi ge vavine Diu ivonedi ivo, “Ge giamaina gwagwama kadi aikewai aitaweni koukou waidie inakania, we gwagwama naqaida inakani kadisala.” ");
INSERT INTO mzz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Vavine ibaivila ivo, “Tomwaya vakai kuvesipupuyeni kanamwaqitana, we koukou somala dibuneye mesai ikanikanimo gwagwama kadimugumugu iyavuyavuta somala waineyeꞌeqa.” ");
INSERT INTO mzz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","We ivonedi ivo, “Mibaivila waigue giamaina mwaqitana, beqa vaitabu kapoina gunabei natumi waineyeꞌeqa akewaluguaqeteni, beqa kwavila kwanaqo mivanuqe.” ");
INSERT INTO mzz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Beqa inaqo divanuqe natudi ikiseni kabakeno waineye ikenokeno. Vaitabu kapoina gunabei isauyeni. ");
INSERT INTO mzz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tutuyanina waineye Ieisu Taia navikai ikiaweni inaqo ilugu Saidoni ikiaweni inaqo Galili Waya waineye we Teni Kawalawa (Dekapolisia) divikaie. ");
INSERT INTO mzz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Noko waineye tamo tomoqo taniqana kuluna wete meana daluna tomoꞌotoqa imaieni waineye, ivelaukuieni wayaqidi dimana inayatoi waineye inakavegiagiamaia. ");
INSERT INTO mzz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tomoqo ivegumetai kadikailuqa inaqo tomoꞌotoqa waidieꞌeqa kaisedi, we dimana iyatodi tomoqo taniqana kailuqa naqedie. Matautauda dimana waineye igiwala tomoqonina meana ikavikavini. ");
INSERT INTO mzz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tutuyanina meana ikavikavini ikisalaga abame ikalayawaina ivesipupu ivo, “Epata!” kananuanua, “Kwakawabwegami.” ");
INSERT INTO mzz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","We vedimadimanaeqa tomoqo taniqana ikawabwegadi, meana ipeto ivesipupu vekavekai. ");
INSERT INTO mzz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Beqa Ieisu ge idatagwanedi tali tomoꞌotoqa waidie inavesipupu vakai isauyeni paipaina. Vona veluveluluninaeqa ivonedi, we ge navona idanoqai kaia tomoꞌotoqa puedi ivonedi banikodiqa Ieisu tomoqo taniqana kuluna wete meana daluna ikavegiagiamaia. ");
INSERT INTO mzz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tutuyanina tomoꞌotoqa vona inoqai Ieisu paipaina itoalavunuqidi ivo, “Ieisu saku puena ivalabubunidi giamaidi. Tomoꞌotoqa taniqadi kuludi ikavegiagiamaidi inoqaya, wete tomoꞌotoqa meadi daludi ikavegiagiamaidi ivesipupu.” ");
INSERT INTO mzz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tutuyanina waineye yoko bwaigina imai imiakauqa ge mekadi beqa Ieisu kanatovemulivo iqoledi imai waineye ivonedi ivo, ");
INSERT INTO mzz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yoko dede taiauda tamiamia gunabei kaiata kaitonu ge mekadi beqa avenuainainaqeyedi. ");
INSERT INTO mzz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kago mesai aivetunedi inanaqo divanuqe mekadilase kedeye inabeku. Wete mesai tupwaidiavo malaveꞌeqa imai.” ");
INSERT INTO mzz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","We kanatovemulivo ibaivila waineye ivo, “Ge tamo aitoi de waineye idamiamia. Vakaiebei beledi taikewadi tomoꞌotoqa taivekanidi?” ");
INSERT INTO mzz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Matautauda ivelautoliedi ivo, “Kaivia beledi waimie?” We ibaivila ivo, “Beledi 7.” ");
INSERT INTO mzz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Beqa yoko ivonedi pwayepwayeye imiabui beledi 7 ikewadi ivelaukui Yaubada waineye. Matautauda beledi igiatomwai ikalaqeiedi kanatovemulivo waidie yoko inavekanidi, we de mesai ivalabubunedi. ");
INSERT INTO mzz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wete iqana siaidi tupwaidiavo ikenokeno ikewadi ivelaukui paipaidi Yaubada waineye. Matautauda kanatovemulivo ivonedi ivo, “Yoko puedi kwaveledi inakani.” ");
INSERT INTO mzz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","We tomoꞌotoqa puedi ikani ikabiawa. Wete nigila puena kanatovemulivo igwagwadi ginae 7 iveadaqidi mekanikaninidi. ");
INSERT INTO mzz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","No waineye tomoꞌotoqa kadiyoko oge mesai 4,000 Ieisu ivekanidi. Mulineye ivetunedi inaqo divanuqe. ");
INSERT INTO mzz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tutuyanina waineye vedimadimanaeqa Ieisu idodoqa waga waineye kanatovemulivo taiau inaqo vikai Dalimanuta waineye. ");
INSERT INTO mzz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","No waineye tupwaidiavo Palisivo* imai ivekaiwewewena taiauda. Wayaqidi Ieisu inavekautovoni beqa ivelautolieni ivo, “Kima wayaqima kiakiaya kabanuavilele* Yaubada waineyeꞌeqa imai kivevema.” ");
INSERT INTO mzz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ieisu nuapouna iveviqa ikalayawaina ivo, “Vakai paipaina komi lagata dede kwaelautoliegu tamo kiakiaya aivalabubuni paipaimi? Aivonemi mwaqitana, ge kiakiaya aivalabubuni kwaikiseni.” ");
INSERT INTO mzz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Matautauda Ieisu mekanatovemulivo Palisivo* ikiawedi ivila inaqo wageye idodoqa inabala mali vikaie Waya Galili waineye. ");
INSERT INTO mzz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","We kanatovemulivo nuadi ivulu beledi ge idakewadi, we kaitamoqanaqa ikewai taiauda wageye. ");
INSERT INTO mzz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tutuyanina waineye Ieisu igiavepakalidi ivo, “Kwavekisabodebodemi Palisivo* wete Elodi diꞌisiti ge waineye kwaisikwana.” ");
INSERT INTO mzz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","We kanatovemulivo kaisekavadi waidie iesipupu vakai Ieisu gunabei ivesipupuyeni waidie paipaina ivo, “Beledi ge tadakewadi beqa isiti paipaina iesipupu.” ");
INSERT INTO mzz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","We Ieisu iyagovi vakai iesipupuyeni ivonedi ivo, “Banikodiqa, kwaenuanedi we mesai kwavo beledi ge tamo kadakewai? Komi giladi ge kwadanuakawananaqai paipaigu! Nuami tabodadi ge idakawabwegabwegadi! ");
INSERT INTO mzz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Komi mematami we ge kwadakisa vekavekai! Komi metaniqami we ge kwadanoqaya vekavekai! Kwanuani vakai avalabubunidi base beledi 5 agiatomwai akalaqeiedi 5,000 tomoꞌotoqa kadiyoko avekanidi. We kaivia nigila meginaedi kwaveadaqidi?” We ibaivila ivo, “Ginae 12.” ");
INSERT INTO mzz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Matautauda ivelautoliedi ivo, “No tutuyanina beledi 7 agiatomwai akalaqeiedi 4,000 tomoꞌotoqa kadiyoko avekanidi, kaivia ginae nigila kwaveadaqidi?” We ibaivila ivo, “Ginae 7.” ");
INSERT INTO mzz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Matautauda ivonedi ivo, “Banikodiqa, giladi ge kwadanuakawananaqai vakai avesipupuyeni?” ");
INSERT INTO mzz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Matautauda Ieisu mekanatovemulivo inaqo vanuqa bwaigina Betisaida waineye. No waineye tupwaidiavo tomoꞌotoqa tomoqo matana pwalupwaluna imaieni waineye ivelaukuieni wayaqidi inakavikavini inakavegiagiamaia. ");
INSERT INTO mzz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","We Ieisu tomoqo matana pwalupwaluna dimaneye ikavikavina iluguaqeteni vanuqeꞌeqa. Matautauda tomoqo matana igiwalidi, dimana iyatoi matana waidie ivelautolieni ivo, “Kanasala vakai kikisedi?” ");
INSERT INTO mzz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tomoqo ikisalagata ivo, “Tomoꞌotoqa akisedi mesaida welavi iekalatauya.” ");
INSERT INTO mzz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","We Ieisu dimana iyato vaituqani tomoqo mataneye, matautauda tomoqo matana ikisalagata ivegiagiamai ikisa vekavekai. ");
INSERT INTO mzz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Matautauda ivesipupu ivo, “Ge kinaqo vanuqa bwaigina waineye tonotonovina kuvila kunaqo muvanuqe.” ");
INSERT INTO mzz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Matautauda Ieisu mekanatovemulivo inaqo Sisalia Pilipai vanuqa bwaigina vivineye. Tutuyanina itauya inaqonaqo kedeye ivonedi ivo, “Banikodiqa tomoꞌotoqa iesipupu nigodibei Yau aitoi?” ");
INSERT INTO mzz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","We ibaivila ivo, “Tupwaidiavo tomoꞌotoqa iesipupu ivo, ‘Kana Dioni Tobabitaiso’, tupwaidiavo iesipupu ivo, ‘Kana Yaubada natovesipupu Ilaitia gumanina basenaqai imiamia,’ we tupwaidiavo iesipupu ivo, ‘Kana Yaubada natovesipupu basenaqai imiamia iyawasa vaituqana.’” ");
INSERT INTO mzz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Matautauda ivelautoliedi ivo, “We komi, banikodiqa kwaesipupu nigodibei Yau aitoi?” Pita ibaivila ivo, “Komu Keliso Yaubada Kanavesivesinua!*” ");
INSERT INTO mzz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Matautauda igiavepakalidi ivo, “Ge kanasala tamo aitoi kwaivoneni Yau paipaigu kwanavo ‘Gumanina Keliso Yaubada Kanavesivesinua.*’” ");
INSERT INTO mzz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Matautauda ivelamu kanatovemulivo waidie ivesipupu vakai inasauyeni waineye paipaina. Ivo, “Yau, Mwaqitana Kanatomoqo*, aiveviqa bwaigina, matautauda Diu tomoqovo bwaigidi, tovelomuvo bwaigidi* wete Mosese naloina kanatovekaivevenavo inabailegu. We kaguqaviavo inaluvewapagu, we kaiata kaitonu inakakava wapaeqa aitovoi vaituqana.” ");
INSERT INTO mzz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","De mesai iesipupuyedi inuakawananaqai beqa Pita ikewaluguaqeteni saiqanaqa iveqanaqo ivoneni bonana veluveluluninaeqa ivo, “Komu ge muwapa paipaina kivesipupu luguaqeta!” ");
INSERT INTO mzz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","We itunuvilai kanatovemulivo ikisedi Pita ivoneni bonana veluveluluninaeqa ivo, “Seitani, kuveqanaqo waigueꞌeqa! Komu munuanua ge mesai Yaubada nanuanua, we komu tomoꞌotoqa dinuanuana mesai.” ");
INSERT INTO mzz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Matautauda Ieisu yoko iqoledi wete kanatovemulivo taiau imai vivineye waidie ivesipupu, “Kago komi wayaqimi kwaivemulieguqa, taunimi migiamaina kwaibailedi, we kamilaukenobalabala kwaikewai kwaikavalai matautauda kwaivemuliegu. ");
INSERT INTO mzz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aitoi wayaqina yawaina inavekokoleni inamiakapo, we yawaina vaqata inakaivuyovuyoi. We aitoi yawaina inakaivuyovuyoi we inavemuliegu we Guvalea Giamaina inavekimataneni, yawaina vaqata inababaneni. ");
INSERT INTO mzz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","We kago tamo aitoi saku puepuena giamaina inakewadi pwayapwaya de waineye, we yawaina vaqata ge inakewaiqa noko sakunidiavo ge inakaivaiseni. ");
INSERT INTO mzz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Paina kago tomoqo yawaina vaqata inakaivuyovuyoi, ge kanasala takonaeqa inatakonai we inakewavileni. ");
INSERT INTO mzz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Beqa komi lagata dede waineye kwamiamiaqa kaisemi mikedakeda kwaemuliedi ge kwadavekimatana vekavekaiegu, paina komi mesai tomoꞌotoqa gumanidiavo gimala ivalabubunidi wete tupwaidiavo saku kapoidi ivavalabubunidi. Kago aitoi lagata dede waineye inavovomayamayaqegu we guvekaivevena inavovomayamayaqedi matautauda mulineye Yau, Mwaqitana Kanatomoqo,* gumanina aivovomayamayaqeni tutuyanina aivila aimai pwayapwaya dede waineye Tamagu mataꞌuduꞌudulinaeqa wete naꞌanelosevo pilopilodi taiauda.” ");
INSERT INTO mzz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Matautauda ivonedi ivo, “Yau avona mwaqitana, tupwaimiavo de waineye naqaida Yaubada nakedakeda kaivauna imaimaiqa menaveluluna natomoꞌotoqa inaloinedi paipaina kamukabei kwaikiseni, matautauda mulineye kwaiwapa.” ");
INSERT INTO mzz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kaiata sikisi ikakava, Ieisu, Pita, Diemesi wete Dioni imaseagadi taiauda ilagavedi koya kaniakwanina tabwaneye, we no waineye matadie kanakisa isivilavila. ");
INSERT INTO mzz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","No waineye kanakaleko itatala we namanamalaotoqidi. Ge tamo aitoi pwayepwayeye inalegwai mesai inatataledi. ");
INSERT INTO mzz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Matautauda Yaubada natovesipupuvo Ilaitia wete Mosese ilausimatala waidie Ieisu taiauda ivesipupu. ");
INSERT INTO mzz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Beqa Pita ivesipupu Ieisu waineye ivo, “Tovekaivevena, kida de waineye tamiamia giamaina. Kima ukweta kaitonu kaiyoqonidi tamo komu, tamo Mosese wete tamo Ilaitia komi paipaimi.” ");
INSERT INTO mzz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita wete tovemulivo kadikailuqa igololo bwaigina, beqa ge idayagovi vakai inavesipupuyeni. ");
INSERT INTO mzz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tutuyanina waineye waumana imai italakapupudi, we Yaubada bonana isauyeni waumana naqeneyeꞌeqa ivo, “Dede Natugu nuapougu gumanina avenapwayeweni, beqa kwavevaneneqeni!” ");
INSERT INTO mzz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","We tutuyanina vedimadimanaeqa kanatovemulivo ikisalelele ge tamo aitoi idakiseni taiauda, kaia Ieisu kaisenaqa. ");
INSERT INTO mzz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tutuyanina waineye koyeyeꞌeqa iobuobuma igiavepakalidi ivo, “Ge tamo aitoi kwaivoneni vakai kwakiseni koyeye. Mulineye Mwaqitana Kanatomoqo* wapaeqa inatovoi vaituqana, matautauda tomoꞌotoqa kwaivonedi.” ");
INSERT INTO mzz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","We paina Ieisu ivekimataneni ge tamo aitoi idavoneni we kaisedi waidie de mesai ivesipupuyedi ivo, “Ieisu navona wapaeqa inatovoi vaituqana, vakai kananuakawananaqai?” ");
INSERT INTO mzz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Beqa ivelautolieni ivo, “Uvale Mosese naloina kanatovekaivevenavo ivo, ‘Naqaida Yaubada natovesipupu Ilaitia kawaie inavila inamai pwayepwayeye, matautauda mulineye Keliso Yaubada Kanavesivesinua* inamai?’” ");
INSERT INTO mzz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Beqa Ieisu ivo, “We mwaqitana Ilaitia inagumeta inamai vakai puepuena inavalabubunidi Keliso Yaubada Kanavesivesinua* namai paipaina. We banikodiqa, Yaubada Nabuki waineye ivona paipaigu Yau Mwaqitana Kanatomoqo aiveviqaotoqa, we tomoꞌotoqa inabailegu? ");
INSERT INTO mzz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yau avona mwaqitana waimie, Ilaitia gunabei imai, we tomoꞌotoqa vakai wayaqidi waineye ivalabubuni. Kaia mesai basenaqaida Yaubada Nabuki waineye natovesipupu igililia gumanina paipaina, mesai gunabei isauyeni.” ");
INSERT INTO mzz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","We Ieisu mekanatovemulivo kadikaitonu koyeyeꞌeqa ivila iobuma ikisanaqo tupwaidiavo kanatovemulivo ikisedi tomoꞌotoqa puedi imiakauqedi, we loina kanatovekaivevenavo taiauda iekawadibidibi. ");
INSERT INTO mzz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tutuyanina tomoꞌotoqa Ieisu ikiseni itoalavunuqidi ilaukwavina inaqo Ieisu waineye ivonamwasamwasaneni. ");
INSERT INTO mzz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","We ivelautoliedi ivo, “Vakai paipaina tovekaivevenavo taiauda kwaekawadibidibieni?” ");
INSERT INTO mzz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","We tomoqo yoko naqedie ibaivila waineye ivo, “Tovekaivevena, vaitabu kapoina natugu iluguya ge kanasala inavesipupu beqa amaieni waimue. ");
INSERT INTO mzz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","No tutuyanina kago vaitabu kapoina naveluluna inavelamu gwamana naqeneye, inataweni inaobu pwayepwayeye, kawaneye buebue, nigona inaekapaligota we inatotola. Kamutovemulivo avelaukuiedi wayaqigu vaitabu kapoina inakwavineni inasauyeni, we ge kadisala.” ");
INSERT INTO mzz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","We Ieisu ibaivila waidie ivo, “Aa komi, banikodiqa ge kwadavetumaqanegu? Gunabei tutuya puena taiauda tamiamia! Tutuya kaivia akalamaqiqita paipaimi? Gwamana kwamaseagai kwamaieni waigue!” ");
INSERT INTO mzz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Beqa gwamana Ieisu waineye imaieni. We tutuyanina vaitabu kapoina Ieisu ikiseni, gwamana naqeneye ivelamu menaveluluna ipetoi, we gwamana wete ibeku iobu pwayepwayeye ivelikolikoko we kawaneye buebue. ");
INSERT INTO mzz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","We Ieisu gwamana tamana ivelautolieni ivo, “Malavia dede viqanina ivelamu waineye?” Ibaivila ivo, “Natutuya gwamana waineye ivelamu. ");
INSERT INTO mzz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tutuya puena vaitabu kapoina ietumwetumweuyeni itawetaweni kaie wete iobuobu bwasie, pai vaitabu kapoina wayaqina gwamana inaluvewapai. Kago komu kamusala, beqa kudavenuainainaqeyema we kudakaivaisema.” ");
INSERT INTO mzz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ieisu waineye ivesipupu ivo, “Banikodiqa kwavo, ‘Komu kamusala?’ We aitoi Yaubada inavetumaqaneni, Yaubada waineye vakai puedi kanasala inavalabubunidi!” ");
INSERT INTO mzz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","We vedimadimanaeqa gwamana tamana iveqole bonana bwaiginaeqa ivo, “Avetumaqana. We guvetumaqana ge bwaigina, beqa kukaivesegu guvetumaqana inavebwaiga.” ");
INSERT INTO mzz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","We Ieisu yoko ikisedi ivelamu imaimai waineye, beqa vaitabu kapoina igiavepakali ivo, “Vaitabu kapoina tomoꞌotoqa taniqadi kukavekuludi ge kanasala inanoqaya, wete meadi kukavekapoidi ge kanasala inavesipupu. Aloinemu gwamana waineye kusauyemu ge wete kivila waineye!” ");
INSERT INTO mzz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tutuyanina waineye vaitabu kapoina ibwau, gwamana ipetoi menaveluluna matautauda isauyeni gwamana waineyeꞌeqa. Gwamana kanakisa mesaida tomoqo wapana, beqa tomoꞌotoqa puedi ikiseni ivo, “Gwamana gunabei iwapa!” ");
INSERT INTO mzz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","We Ieisu dimaneye ikavikavini isivetovoia. ");
INSERT INTO mzz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mulineye Ieisu inaqo vanuqe ilugu matautauda kanatovemulivo kaisekavadi ivelautolieni ivo, “Uvale, kima ge kanasala vaitabu kapoina kaikwavineni inasauyeni?” ");
INSERT INTO mzz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","We ibaivila ivo, “Dede vaitabunidiavo kapoidi ge kanasala taikwavineni inasauyeni, kaia kago taivelaukuimo mulineye inasauyeni.” ");
INSERT INTO mzz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","We Ieisu mekanatovemulivo vikai noko ibaileni, itauya inaqo ilugu Galili Polovinisi waineye. Ieisu ge wayaqina meqavoi inayagovi vakaiebei imiamia, ");
INSERT INTO mzz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","paina kanatovemulivo iekaivevenedi ivo, “Kawaie Yau, Mwaqitana Kanatomoqo* kaguqaviavo inaketoqiluvegu, tomoꞌotoqa dimadie gumanidiavo inaluvewapagu, we kaiata kaitonu inakakava wapaeqa aitovoi vaituqana.” ");
INSERT INTO mzz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","De mesai ivesipupuyedi, we navona ge idanuakawananaqaia, we igololo beqa ge idavelautolieni paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","We Ieisu mekanatovemulivo Kapeneumi waineye ilekwa tamo tomoqo navanuqe ilugu matautauda ivelautoliedi ivo, “Komi kedeye vakai kwaekawadibidibieni?” ");
INSERT INTO mzz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kedeye ediavo taiauda iekawadibidibi ivo, “Aitoi gumanina kanawavaqa bwaigina waideyeꞌeqa?” Beqa, ge tamo vakai idavesipupuyeni waineye. ");
INSERT INTO mzz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tutuyanina waineye Ieisu imiabui, apositolovo 12 iqoledi imai waineye, matautauda ivesipupu waidie ivo, “Aitoi wayaqina gumeta, no gumanina taunina inasiobuyeni taunina inavemuliotoqa we inavetolituqa enavo paipaidi.” ");
INSERT INTO mzz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","We gwamana ikewai gamwadie isivetovoia dimanaeqa gwamana italaqavuya ivonedi ivo, ");
INSERT INTO mzz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“We aitoi gwamana de mesai inavonamwasamwasaneni kaguwavaqaeqa, wete Yau inavonamwasamwasanegu, we ge Yau kaisegu, wete gumanina ivetunegu inavonamwasamwasaneni.” ");
INSERT INTO mzz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dioni Ieisu ivoneni ivo, “Tovekaivevena, kima tamo tomoqo kakiseni kamuavaqaeqa vaitabu kapoidi ieuqeuqedi, we paina gumanina ge kadayoko, beqa katalabodeni kavoneni kavo, ‘Ge mesai kivalabubunedi.’” ");
INSERT INTO mzz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","We ivo, “Tomoqo ge kwaiketobodeni. Ge tamo aitoi kabanuavilele inavalabubunidi kaguwavaqaeqa, we vedimadimanaeqa inavona kapo paipaigu. ");
INSERT INTO mzz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aitoi gumanina ge kadatalavuala, gumanina kadayoko. ");
INSERT INTO mzz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Avona mwaqitana waimie, beqa kago aitoi siaina inakaivaisemi paina komi kagutovemulivo, mesai tupwaidiavo bwasi inagoia inavelemi, kanabaivila ge inavuyo kaia inababaneni.” ");
INSERT INTO mzz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","We Ieisu ivesipupu ivo, “Kago tamo aitoi gumanina siaina inavetumaqanegu, gumanina mesai gwamana siaina dede, inaweweseni we gunabei kapoina waineye inabeku, Yaubada kaimatavuloqa inaveleni. We kago gileu tageyoina kodoneye inalaipweni ligwagweye inataweni inaobu, we no kaimatavuloqanina ge bwaigina. ");
INSERT INTO mzz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kago dimamu inawewesemu kapoina waineye kibeku, kugusuyavuleni. Beqa giamaina dimamu tamoqana ge idakenokeno beqa kanasala yawaina vaqata kibabaneni, we guvalaiawa dimamu kailuqa taiau Kaiyabeyabela waineye kinaqo, kainina ge menakakava. ");
INSERT INTO mzz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","We kago kaqemu inawewesemu kapoina waineye kibeku, kugusuyavuleni. Beqa giamaina kaqemu tamoqana ge idakenokeno beqa kanasala yawaina vaqata kibabaneni, we guvalaiawa kaqemu kailuqa taiau inatawemu Kaiyabeyabela waineye kiobu. ");
INSERT INTO mzz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kago matamu inawewesemu kapoina waineye kibeku, kukewayavuleni. Beqa giamaina matamu tamoqana Yaubada nakabaloina waineye kiluguveni kimiamia, we guvalaiawa matamu kailuqa taiau inatawemu Kaiyabeyabela waineye kiobu. ");
INSERT INTO mzz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","No vikainina waineye, ‘Mwatamwata tomoꞌotoqa ikanikanidi ge inawapa, we kai ge inakakava.’ ");
INSERT INTO mzz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","We kagutovemulivo puepuedi mwauna inababanedi kabaketotovona waidie kadilautovona mesai kai, beqa no waineye inakavegumaqidi. ");
INSERT INTO mzz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","We ligwagwa saku giamaina, we kago naveluluna wete kanavebae inakakava ge kadasala wete taiveligwagwa vaituqani. Kago komi kwaivekawadibidibi wavaqa bwaigina paipaina, beqa komi mesai ligwagwa kanavebae inakakava. We ge mesaida, we mesaida kanikani ietavoqi ligwagwa beqa—kwaimiagiagiamai emiavo taiauda.” ");
INSERT INTO mzz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ieisu vikai Kapeneumi ikiaweni inaqo Iudia navikaie ibala Iolidani bwasi idamani bolimana waineye. We yoko puedi imai waineye iekaivevena waidie mesai tutuya puena ivavalabubuni. ");
INSERT INTO mzz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","We Palisivo* wayaqidi inavekautovoni beqa imai waineye ivelautolieni ivo, “Daloina ikenokeno banikodiqa kanasala tomoqo mwanena inaveiobudi o gebuka?” ");
INSERT INTO mzz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","We ibaivila ivo, “Mosese loina ivelemi, banikodiqa ivesipupuyedi?” ");
INSERT INTO mzz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","We ivo, “Mosese naloina tomoqo itagwaneni lubulubu inagililia inavo, ‘Aveiobumi. Kwatauya.’ we mwanena inaveledi. Mulineye inaveuqeuqedi inanaqo.” ");
INSERT INTO mzz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","We Ieisu ibaivila waidie ivo, “Komi debami pakalidi, beqa Mosese loina igililia paipaimi. ");
INSERT INTO mzz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","We kwanuani naqaida, tutuyanina Yaubada tomoꞌotoqa ivalabubunidi, ‘lamoqina wete vavinena ivalabubunidi.’ ");
INSERT INTO mzz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Beqa tomoqovo tamadiavo inadiavo inabailedi memwanediavo inavemialuqedi, ");
INSERT INTO mzz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","we inavebunu kaitamoqana.’ Beqa no gumanidiavo gebu kadikailuqa we kaia kaitamoqana. ");
INSERT INTO mzz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","We Yaubada ivemialuqedi, beqa ge tamo aitoi inavemiakedi.” ");
INSERT INTO mzz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mulineye ivila vanuqe, Ieisu kanatovemulivo ivelautolieni de vonanina paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","We ibaivila waidie ivo, “Kago tomoqo mwanena inaveiobuyedi tamo vavine sulidi inanaqidi, we gunabei gimala inavalabubuni. ");
INSERT INTO mzz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","No mesai, kago vavine mwanedi inabaileni tamo tomoqo sulina inanaqia, no vavinenidi wete gimala inavalabubuni.” ");
INSERT INTO mzz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","We tupwaidiavo tomoꞌotoqa gwagwama imaiedi Ieisu waineye wayaqidi dimana inayatoi bunudie, we kanatovemulivo iyaqaidi. ");
INSERT INTO mzz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ieisu ikisedi kanakapoka ioqala kanatovemulivo ivonedi ivo, “Yaubada nakabaloina gumanidiavo mesai dede gwagwamanidiavo paipaidi, beqa gwagwama ge kwaitalabodedi, kwatagwanedi inamai waigue. ");
INSERT INTO mzz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yau avona mwaqitana, kago tomoꞌotoqa tamoqana ge inamwasana wete ge inatagwana Yaubada nakabaloina mesai gwagwama itagwatagwanedi, beqa ge kanasala Yaubada nakabaloina waineye inalugu.” ");
INSERT INTO mzz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Matautauda gwagwama ikewadi kabikabineye ivemiabuidi, dimana waidie iyatodi ivelaukui Yaubada waineye gwagwamanidiavo ivonavenapwayewedi. ");
INSERT INTO mzz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","We tutuyanina Ieisu itauya inaqonaqo kedeye, tamo tomoqo ilaukwavina waineye tutuqana iveketonokuyedi ivelautolieni ivo, “Tovekaivevena Giamaina, vakai aivalabubuni yawaigu vaqata aibabaneni?” ");
INSERT INTO mzz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","We Ieisu ivo, “Uvale kuqolegu giamaina? Ge tamo aitoi giamaiotoqina, kaia Yaubada kaisena giamaiotoqina. ");
INSERT INTO mzz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Muvelautoli kanabaivila paipaina de mesai, gunabei Yaubada naloinavo kuyagovi: ‘Ge kiluvewapa; Ge kigimala; Ge kivainaqo; Ge tomoꞌotoqa kivemwaumaimaiqidi; Ge tomoꞌotoqa kikatupwaiedi disaku kikwayedi; tamamu inamu kivekimatanedi.’” ");
INSERT INTO mzz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","We ivesipupu waineye ivo, “Tovekaivevena gututuya gwamana waineyeꞌeqa kanaketoava deqoina de loinanidiavo avemuliedi.” ");
INSERT INTO mzz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","We Ieisu ietonovi ivenapwayeweni waineye ivesipupu ivo, “Valabubuna kaitamoqana ge kudavalabubuni. Kunaqo muvanuqe, musaku puepuena kuvegimwaneyedi, mane kukalaqeiedi yomuyomudi waidie, matautauda kamubaivila paipaina Yaubada kawaie abame inavelemu. Mulineye, kimai kivemuliegu.” ");
INSERT INTO mzz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tomoqonina guyoguyoꞌotoqina ge wayaqina nasakuvo puedi inavegimwaneyedi wete inakalaqeiedi, beqa tutuyanina vona inoqai menanuakapo ivila inaqo. ");
INSERT INTO mzz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Matautauda Ieisu ikisalelele ivesipupu kanatovemulivo waidie ivo, “Mwaqitana, gumanidiavo disakuvo boudi mwauotoqina waidie Yaubada nakabaloina kanalugu paipaina.” ");
INSERT INTO mzz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","We kanatovemulivo nuadi ivilele navona beqa. Wete Ieisu ivesipupu vaituqana waidie ivo, “Natugwavo, dede mwauotoqina Yaubada nakabaloina kanalugu paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Banikodiqa, kaisaya bwaigina kanawavaqa kameli* kanasala yaima matana siaina waineye inalugu o gebuka? Wete mwaqitana, mesaida tomoqo guyoguyona Yaubada nakabaloina waineye ge kanasala inalugu.” ");
INSERT INTO mzz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","We nuadi ivileleotoqa kaisekavadi ivesipupu ivo, “Kago de mesaida, ge tamo aitoi ketoyavu inababaneni. Aa?” ");
INSERT INTO mzz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ieisu ietonovidi ivesipupu ivo, “Tomoꞌotoqa ge kanasala taunidi inaketoyavudi, we Yaubada kanasala vakai puepuena inavalabubuni, wete Yaubada kanasala inaketoyavudi.” ");
INSERT INTO mzz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Beqa Pita ivesipupu waineye ivo, “Kunoqai. Kima banikodiqa, gunabei vakai puena kabailedi, we kavemuliemu?” ");
INSERT INTO mzz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","We ivonedi ivo, “Avona mwaqitana, kago aitoi navanuqa, tainavo, novunavo, inana, tamana, natunavo o napwayapwaya inabailedi matautauda inamai inavemuliegu, we tupwaidiavo tomoꞌotoqa Valea Giamaina inavesipupuyeni waidie, ");
INSERT INTO mzz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","we yawaina waineye Yaubada inabaivilai, wete kanabaivilanina tabwaneye inayatoi inakavesulaia, beqa navanuqavo, tainavo, novunavo, inanavo, natunavo we napwayapwayavo inababanedi. We tomoqonina veviqa inababaneni wete inabaileni, we kamukabei imaimai yawaina vaqata inababaneni ge menakakava. ");
INSERT INTO mzz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","We tomoꞌotoqa puedi gumanidiavo deqoina igumegumeta tutuya imaimai kawaie inavemuliotoqa, wete tomoꞌotoqa puedi gumanidiavo deqoina iemuliotoqa tutuya imaimai kawaie inagumeta.” ");
INSERT INTO mzz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","We gunabeida itauya kedeye inaqonaqo inalaga Ielusalema, we Ieisu igumegumeta. We kanatovemulivo nuadi ivilele, we wete tomoꞌotoqa mulineye inaqonaqo igololo. We Ieisu kanatovemulivo kadikuma 12 iqoledi imai waineye, waidie ivesipupu vaituqana vakai puena paipaidi, kamukabeida inasauyedi waineye Ielusalema naqeneye. ");
INSERT INTO mzz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ivesipupu ivo, “Kwavevaneneqa, kida gunabei kedeye tanaqonaqo Ielusalema. Noko waineye, Yau Mwaqitana Kanatomoqo, kagutoketoqiluva inaketoqiluvegu tovelomuvo bwaigidi* wete loina kanatovekaivevenavo waidie. Diloina inavalabubuni guwapa paipaina, we inakalaqeiegu tomialuguaqeta waidie. ");
INSERT INTO mzz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Gumanidiavo inasaidibiegu wete inagiwaligu kabakaipitala beqa inanigegu inaluvewapagu. We kaiata kanavetonu waineye, wapaeqa aitovoi vaituqana.” ");
INSERT INTO mzz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Matautauda Diemesi wete Dioni, Sebedi natunavo imai Ieisu waineye ivesipupu ivo, “Tovekaivevena, vakai kaivelaukuieni waimue wayaqima komu kivalabubuni paipaima.” ");
INSERT INTO mzz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","We ivelautoliedi ivo, “Vakai wayaqimi aivalabubuni?” ");
INSERT INTO mzz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","We ibaivila ivo, “Mututuya kimiabui mukabaloina matauꞌudulina waineye tomoꞌotoqa waidie kiloina kanasala kitagwanema manawamue kaimiabui, tamo kamukataqie we tamo kamukelie, taiauda tailoina.” ");
INSERT INTO mzz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","We Ieisu ivonedi ivo, “Komi vakai kwaelaukuieni ge kwadayagovi. Komi kamisala veviqa vedina beqa aiyemu wete beqa kwaiyemu? Wete babitaisonina waineye aibabitaiso beqa kwaibabitaiso?” ");
INSERT INTO mzz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","We ivesipupu waineye ivo, “Kima kamasala.” We waidie ivesipupu ivo, “Komi kawaie vedinina aiyemu beqa komi kwaiyemu, wete kabababitaisonina beqa aibabitaiso beqa kwaibabitaiso. ");
INSERT INTO mzz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","We Yau ge kagusala aivesinua aitoi taiauda kailoina, inamiabui kagukataqie wete kagukelie. Noko kabamiabuinidiavo Yaubada inakalaqeiedi gumanidiavo ivesinuedi waidie.” ");
INSERT INTO mzz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tutuyanina waineye tovemulivo kadikuma 10 inoqai Diemesi wete Dioni taiauda divelaukui paipaina kadikapoka ioqala Diemesi Dioni waidie. ");
INSERT INTO mzz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Beqa kanatovemulivo iqoledi imai waineye, Ieisu ivesipupu waidie ivo, “Komi gunabei kwayagovi noko gumanidiavo tomialuguaqeta waidie ivetogumeta wayaqidi inagumetedi we ditomotoqavo waidie inaloina pakaledi. ");
INSERT INTO mzz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Beqa komi ge kwaivetutuyamedi. Kago komi aitoi wayaqina kanawavaqa inavebwaiga, gumanina inavetolituqa enavo paipaidi. ");
INSERT INTO mzz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","We kago wayaqimu kigumeta komu tomoꞌotoqa puedi dikabavetutuyekwa. ");
INSERT INTO mzz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Paina Yau Mwaqitana Kanatomoqo amai ge wayaqigu tomoꞌotoqa paipaigu inalituqa. Amai tomoꞌotoqa paipaidi ailituqa, we wayaqigu aiwapa kaniqodadaqa aikewai tomoꞌotoqa puepuedi paipaidi, we aitakonadi aiviledi.” ");
INSERT INTO mzz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Gunabei Ieisu mekanatovemulivo ilekwa Ieliko waineye. Mulineye Ieliko ikiaweni inaqonaqo, yoko bwaigina italakwavinidi. Tamo tomoqo matana pwalupwaluna kanawavaqa Batimio, Timio natuna, kedeye imiabui ielaukui mane paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tutuyanina inoqai tomoꞌotoqa iesipupu ivo, “Ieisu Nasaletaeqa imaimai” we itoge iveqole ivo, “Ieisu Deibida natuna, kudavenuainainaqeyegu.” ");
INSERT INTO mzz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tomoꞌotoqa puedi iyaqaia ivo, “Kuvekwada!” We kaia iveqole bonana bwaiginaeqa ivo, “Deibida natuna, kudavenuainainaqeyegu!” ");
INSERT INTO mzz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","We Ieisu inaqonaqo ivekwada tomoꞌotoqa ivonedi ivo, “Kwaqoleni inamai dede waineye.” Beqa iqoleni tomoqonina matana pwalupwaluna ivo, “Kutovoi, kumwasana, Ieisu iveqole paipaimu.” ");
INSERT INTO mzz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","We itovoi memasona kanatalauma isitakia iyatoi we imai Ieisu waineye. ");
INSERT INTO mzz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","We Ieisu ivoneni ivo, “Vakai wayaqimu waigue aivalabubuni waimue?” We matana pwalupwaluna ivo, “Tovekaivevena, wayaqigu matagu inavegiagiamai.” ");
INSERT INTO mzz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ieisu ivoneni ivo, “Kunaqo, muvetumaqanaeqa kuvegiagiamai.” We vedimadimanaeqa matana ikisalagata kedeye Ieisu ivemulieni. ");
INSERT INTO mzz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tutuyanina itauya inaqonaqo Ielusalema vivineye, saiqanaqa inalekwa Bedipegi wete Bedani waidie Koya Olibe waineye Ieisu kanatovemulivo kadikailuqa ivetunedi inagumeta ");
INSERT INTO mzz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","we ivonedi ivo, “Kwanaqo vanuqa matadeye. Tutuyanina kwailekwa no waineye kwailugu, doniki natuvauna kwaikiseni no waineye italaipweni, ge tamo aitoi waineye idadodoqatovoni, kwayavuya kwamaieni waigue. ");
INSERT INTO mzz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kago aitoi inavelautoliemi inavo, ‘Uvale, kwayavuyavuya?’ Komi kwanavo, ‘Tomwaya wayaqina inavelituqeni tutuya kalakusana wete inavevilai.’” ");
INSERT INTO mzz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Itauya inaqo ilekwa ikiseni doniki tamo tomoqo navanuqa kawana kanakoqala waineye masikeda waineye ilaipweni. We tutuyanina ivelamu iqeuqeuya ");
INSERT INTO mzz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tomoꞌotoqa tupwaidiavo itovotovoi ivelautoliedi, “Uvale doniki kwayavuyavuya?” ");
INSERT INTO mzz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ibaivila waidie mesai Ieisu ivona waidie beqa tomoꞌotoqa itagwanedi doniki ikewai inaweni. ");
INSERT INTO mzz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tutuyanina doniki imaieni Ieisu waineye, kadikalekoeqa doniki dumwena iesoi, we Ieisu imialaga doniki dumweneye. ");
INSERT INTO mzz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tomoꞌotoqa puedi kadikalekoeqa keda iesoi, we tupwaidiavo welavi ibaidi melugulugudi beqa keda iesoi. ");
INSERT INTO mzz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Medimwasana igumegumeta wete iemuli we iekalabwau, “Osana! Yaubada ivonavenapwayewemu! Yaubada kanawavaqaeqa kumai. ");
INSERT INTO mzz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kadidigemu tubuma Deibida tubuleleleqina waineye kumaimai kima kiloinema! Kadidigemu Yaubada abama tabwaotoqineye!” ");
INSERT INTO mzz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ieisu ilugu Ielusalema inaqo Vanuqa Pilo waineye. We ikisalelele saku puedi ikisedi. Matautauda vanuqa gunabei ilavia, itauya inaqo vanuqe Bedani we kanatovemulivo kadikuma 12 taiauda. ");
INSERT INTO mzz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","We tamo kaiata Bedani ikiaweni ivila inaqonaqo Ielusalema waineye Ieisu ilase. ");
INSERT INTO mzz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kanikieꞌeqa ikisanaqo modaba ikiseni meluguna, beqa inaqo ikisavetovetonovi, nigo mevuana. We inaqo waineye ikiseni lugu kavana, paina modaba ge ditutuya vuaqa. ");
INSERT INTO mzz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Beqa Ieisu modaba ivoneni ivo, “Ge tamo aitoi wete vuamueqa inakani.” We kanatovemulivo ievaneneqeni. ");
INSERT INTO mzz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","We ilekwa Ielusalema Ieisu ilugu Vanuqa Pilo masikedaneye ivelamu togimwane wete tovegimwane ikwavinedi. Tosivedavedamana dikabayato mane kabasivedavedamana, wete bunetutu kaditovegimwane dikabamiabui itutuyuaidi. ");
INSERT INTO mzz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","We ge idatagwanedi tamo aitoi disaku inakavaladi inayoqodaba inalugu Vanuqa Pilo masikedaneye inasauyedi vikaineye. ");
INSERT INTO mzz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Matautauda ivekaivevena waidie ivo, “Mwaqitana kwayaqovi? Buki Pilo naqeneye igililia Yaubada ivo, ‘Guvanuqa Pilo inaqoleni vanuqa kabavelaukui tomoꞌotoqa paipaidi kabaloina puedi waidie.’ We komi gunabei kwasivilai deqoina mesai tovainaqo dikabavaigavu.” ");
INSERT INTO mzz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Beqa tovelomuvo bwaigidi* wete loina kanatovekaivevenavo inoqai ivelamu kedakeda ilalauala wayaqidi Ieisu inaluvewapai. We igololoyeni paina tomoꞌotoqa puedi nuadi ivilele navekaivevenaeqa. ");
INSERT INTO mzz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","We gunabei vanuqa ilavia Ieisu mekanatovemulivo Ielusalema ikiaweni. ");
INSERT INTO mzz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","We ikawananaqai kawakawaie ivila inaqonaqo Ielusalema. Tutuyanina kedeye inaqonaqo, modaba ikiseni base Ieisu iyaqaia ibwavu tabwaneyeꞌeqa iobu lamuneye. ");
INSERT INTO mzz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","We Pita inuani vakai isauyeni beqa ivesipupu Ieisu waineye ivo, “Tovekaivevena kukiseni! Modabanina base kuyaqaia gunabei ibwavu.” ");
INSERT INTO mzz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","We Ieisu ivesipupu waidie ivo, “Kwavetumaqana Yaubada waineye. ");
INSERT INTO mzz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Avona mwaqitana waimie, aitoi koya dede inavoneni inavo, ‘Kutovoi kuobu ligwagweye’, we ge menavenuanaluqa nuapouneye, menavetumaqana vakai inavesipupuyeni kaia inasauyeni waineye. ");
INSERT INTO mzz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Beqa dede paipaina avonemi: Kago vakai paipaina kwaivelaukui, kwaivetumaqana gunabei kwababaneni, matautauda waimie Yaubada inakalaqeieni vakai kwaivelaukuieni paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","We kago kwaitovoi kwaivelaukui, vakai kapoidi emiavo ivalabubunidi waimie we kamikapoka inaoqala, kwainuataqonidi, matautauda Tamami abame mikapoina inanuataqonidi.” ");
INSERT INTO mzz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ieisu we kanatovemulivo inaqo vaituqana Ielusalema. Tutuyanina Ieisu inaqo ilugu Vanuqa Pilo masikedaneye isasasala, tovelomuvo bwaigidi* wete loina kanatovekaivevenavo wete tomoqovo bwaigidi imai Ieisu waineye. ");
INSERT INTO mzz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ivelautolieni ivo, “Vakai loina naveluluna beqa togimwane wete tovegimwane kukwavinedi iluguaqeta Vanuqa Pilo navikaie? Aitoi veluluna ivelemu mesai kuvavalabubunedi?” ");
INSERT INTO mzz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","We Ieisu ibaivila ivo, “Velautoli tamo aivelautoliemi kwaibaivila waigue, matautauda aivonemi aitoi loina wete veluluna ivelegu de mesai avavalabubunedi. ");
INSERT INTO mzz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kwavonegu, Dioni naveluluna aitoi iveleni tomoꞌotoqa ibabitaisodi. Banikodiqa, Yaubada waineyeꞌeqa o tomoꞌotoqa waidie? Kwabaivila waigue.” ");
INSERT INTO mzz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Beqa ivelamu kaisekavadi ielautoliedi, paina ivo, “Kago tanavo, ‘Abameꞌeqa’, we inavo, ‘Uvale ge kwadavetumaqaneni?’ ");
INSERT INTO mzz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","We kago tanavo, ‘Tomoꞌotoqa waidie’, we tomoꞌotoqa inanigeda.” Paina tomoꞌotoqa puedi iyagovi Dioni gumanina tovesipupu, beqa igololo tomoꞌotoqa waidie. ");
INSERT INTO mzz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Beqa Ieisu waineye ibaivila ivo, “Kima ge kadayagovi.” Ieisu ivo, “Yau mesaida, ge aivonemi aitoi veluluna wete loina ivelegu mesai avavalabubunedi.” ");
INSERT INTO mzz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Matautauda Ieisu vonawakedubalaeqa ivesipupu waidie ivo, “Tomoqo tamo oine ibaguli tanoqa waineye. Kala ivalabubuni ivelauvivila. We oine kababibi wete kabavekisabodaboda iyoqonidi. Matautauda tupwaidiavo tovekisabodaboda ikewadi, tanoqa iveledi inavekisabodebodeni we inaqo kanikie. ");
INSERT INTO mzz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","We tutuya tavi waineye, tamo tolituqa ivetuneni inanaqo tovekisabodaboda waidie kanakalaqei inakewai tavinina waineye. ");
INSERT INTO mzz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","We tovekisabodaboda ikavikavini, inigei, ivetuneni dimakavakavana ivila. ");
INSERT INTO mzz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Matautauda tonibagula wete tamo tolituqa ivetuneni. We tovekisabodaboda kunukununeye ikainige, we ivalabubuna kapo waineye. ");
INSERT INTO mzz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wete tonibagula tamo tolituqa ivetuneni, wete iluvewapai. We tupwaidiavo tolituqa wete ivetunedi waidie, mesai ivalabubunedi, tupwaidiavo iluvewapadi tupwaidiavo ituveyawayawaidi. ");
INSERT INTO mzz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","We tamoqaotoqina itupwa, gumanina tonibagula natuna nuapouna gumanina ivenapwayeweni. Matautauda kabavekakava natuna ivetuneni tovekisabodaboda waidie ivo, ‘Anuani natugu inavekimataneni.’ ");
INSERT INTO mzz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","We oine tovekisabodaboda ivo, ‘Dede gumanina tonibagula natuna, gumanina kawaie tonibagula inawapa we tanoqa dede inakewai, beqa tainigei tailuvewepai. We oine kanatanoqa dede kida waideye inamiamia.’ ");
INSERT INTO mzz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Beqa tomoqonina ikavikavini iluvewapai itaweni iobu oine kanatanoqa mulineye. ");
INSERT INTO mzz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Beqa banikodiqa tonitanoqa inavalabubunedi? Inamai tanoqa kanatovekisabodabodavo inanigedi, we oine kanatanoqa inakalaqeieni mali tomoꞌotoqa waidie. ");
INSERT INTO mzz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Komi Buki Pilo naqeneye kwawawai o gebuka? Ivo ‘We gileu toyoqona ibaileni, dede gunabei ivekoqala. ");
INSERT INTO mzz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dede imai Yaubada waineyeꞌeqa we de paipaina nuada ivilele.’” ");
INSERT INTO mzz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Beqa me-Diu togumetavo kedakeda ilalauala Ieisu inakavikavini, paina iyagovi de vonawakedubalanina beqa paipaidi iesipupu. We yoko igololoyedi beqa ikiaweni iyavula. ");
INSERT INTO mzz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tamo tutuya togumetavo Palisivo wete Elodi kanatokaivaisavo tupwaidiavo ivetunedi inaqo Ieisu waineye, velautolieqa inakatupwaieni. ");
INSERT INTO mzz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","We imai ivesipupu nuatabwadieqa waineye ivo, “Tovekaivevena, kima kayagovimu komu tovona mwaqitana wete komu ge tamo aitoi vakai paipaimu inuanua kudagololoyeni we ge tamo aitoi kanawavaqa bwaigina paipaina kudanuanuana, we mwaqitana Yaubada nakedakeda kuekaiveveneni.” Matautauda ivelautolieni, “Mosese ivona kida mane Yaubada waineye taikalaqei. Beqa kaivelautoliemu, kago giamaina takisi taiyato Sisa waineye? Kanasala taiyato, o ge taiyato?” ");
INSERT INTO mzz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","We dinuanuana gunabei iyagovidi iekautovona inakaibedebedeni ivo, “Uvale kwaekautovona kwaikaibedebedegu? Dinali kwamaieni kwavelegu aikiseni.” ");
INSERT INTO mzz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dinali tamo imaieni Ieisu waineye ivonedi, “Aitoi kanununa wete kanawavaqa?” We ivo, “Sisa.” ");
INSERT INTO mzz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Beqa Ieisu ivonedi ivo, “Sisa paipaina Sisa waineye kwaikalaqei, we Yaubada paipaina Yaubada waineye kwaikalaqei.” Ieisu navonaeqa nuadi ivilele. ");
INSERT INTO mzz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi* dinuanuana nigodibei tovoi vaituqana gebuka. We tupwaidiavo imai Ieisu waineye ivelamu ielautolieni ivo, ");
INSERT INTO mzz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tovekaivevena, Mosese loina igililia paipaida kago tomoqo tatana inawapa kwabulina inakiawedi we ge menatuna taina inanaqidi we tutuyanina inavenatuna gwagwamanidiavo mesai tatana natunavo. ");
INSERT INTO mzz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tamo tomoqo tainavo kadikuma 6 taiauda imiamia, kanagumeta inaqidi iwapa we ge menatuna. ");
INSERT INTO mzz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wete taina kanaveluqa vavinenidi inaqidi, tomoqo iwapa we ge tamo menatuna, kadivetonu wete mesai. ");
INSERT INTO mzz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kadikuma 7 nidiavo vavinenidi inaqidi iwapa we ge tamo aitoi menatuna. Kabavekakava vavine iwapa. ");
INSERT INTO mzz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Beqa tovoi vaituqana waineye vavinenidi aitoi mwanedi, paina kadikuma 7 inaqidi?” ");
INSERT INTO mzz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ieisu waidie ivesipupu ivo, “Kaia kwaqauotoqa, paina komi Buki Pilo kananuakawananaqai wete Yaubada naveluluna ge kwadayagovidi. ");
INSERT INTO mzz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Paina tutuyanina towapa inatovoi vaituqana gumanidiavo mesaida anelosevo abame we ge inanaqi. ");
INSERT INTO mzz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","We towapa ditovoi vaituqana paipaina, banikodiqa, ge kwadawawai Mosese nabuki naqeneye kaiyabeyabela welavi siaidi waidie ikalakalata vesipusipupuna? No waineye igililia Yaubada welavi siaidi ikalakalata beqa ivesipupu luguaqeta, ‘Yau Ebelaꞌamo na-Yaubada, Aisake na-Yaubada, wete Iakobo na-Yaubada.’ ");
INSERT INTO mzz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gumanina ge tomoꞌotoqa towapa di-Yaubada, we tomoꞌotoqa meyawaidi di-Yaubada, beqa iveveda tutuyanina Ebelaꞌamo, Aisake wete Iakobo iwapa pwayepwayeye gunabei itovoi vaituqana, we Yaubada mataneye meyawaidi. Beqa tutuyanina komi kwavo towapa ge inatovoi vaituqana, komi kaia kwakatupoeotoqa.” ");
INSERT INTO mzz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","We loina kanatovekaivevena tamo imai inoqai iekawaviviqa. We iyagovi Ieisu divelautoli puedi ibaivila giagiamaidi. We loina kanatovekaivevena Ieisu ivelautolieni ivo, “Vakai loina bwaigaotoqina?” ");
INSERT INTO mzz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ieisu ibaivila ivo, “Loina bwaigaotoqina de mesai, ‘Me-Isileli, kwavevaneneqa! Tomwaya da-Yaubada kaia gumanina kaisena Tomwaya. ");
INSERT INTO mzz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tomwaya mi-Yaubada kwaivenapwayeweni nuapoumi matatabunaeqa, vaitabumi matatabunaeqa, nuami matatabunaeqa, wete miveluluna matatabunaeqa.’ ");
INSERT INTO mzz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","We kanaveluqa ivo, ‘Iamu kuvenapwayeweni mesaida taunimu kamuvenapwayewa.’ Dede loinanidiavo kailuqa bwaigaotoqidi ge wete tamo.” ");
INSERT INTO mzz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","We loina kanatovekaivevena Ieisu ivoneni ivo, “Tovekaivevena, mubaivila giamaikavana. Mwaqitana da-Yaubada kaia tamoqana, Yaubada kaisena ge tamo aitoi manawaneye. ");
INSERT INTO mzz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Taivenapwayeweni nuapouda matatabunaeqa danuanua matatabunaeqa daveluluna matatabunaeqa wete edavo taivenapwayewedi mesai taunida. Dede loinanidiavo bwaigaotoqidi, matautauda kalaqeimaimaiqa gabugabunidi wete tupwaidiavo kabavelomu.” ");
INSERT INTO mzz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ieisu inoqai tomoqo nabaivila waineye giamaikavadi. Beqa ivoneni ivo, “Komu kaia Yaubada nakabaloina vivineye.” We mulineye tomoꞌotoqa igololo beqa ge tamo aitoi inaveluluna inavelautoli katupoe Ieisu waineye. ");
INSERT INTO mzz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","We Ieisu iekaivevena Vanuqa Pilo masikedaneye ivelautoli ivo, “Banikodiqa, loina kanatovekaivevenavo ivo Keliso Yaubada Kanavesivesinua* Deibida tubuleleleqina? ");
INSERT INTO mzz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yaubada Vaitabuna nuanuana giamaina iveleni Deibida waineye, beqa Deibida ivesipupu ivo, ‘Tomwaya ivona gutomwaya waineye, “Kumiabui kataqigue vikai vekivekimatanina waineye, kanaketoava kamutalavualavo aiyatodi kaqemu matakwanineye.’” ");
INSERT INTO mzz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Gilili waineye Deibida kaisena Keliso iqoleni Tomwaya beqa banikodiqa, nigo Keliso Kini Deibida tubuleleleqina?” We yoko bwaigina medimwasana Ieisu ievaneneqeni. ");
INSERT INTO mzz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","We Ieisu navekaivevena waineye ivonedi ivo, “Kwavekisabodebodemi loina kanatovekaivevenavo waidie, gumanidiavo wayaqidi kaleko kaniakwanidi inakwesenidi, wayaqidi tomoꞌotoqa inavekimatanedi kabavegimwane waidie. ");
INSERT INTO mzz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wete wayaqidi kabamia giamaidi tomoꞌotoqa matadie inamialagalaga vanuqa kabavelaukui naqedie, wete wayaqidi kani bwaigidi waidie matadie inamiabui tomwatomwayavo taiauda. ");
INSERT INTO mzz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Gumanidiavo kwabukwabulavo inakatupwaiedi divanuqa inakwayedi, wete divelaukui ilaukaniakwanidi tomoꞌotoqa inakisedi inavo tomoꞌotoqa giamaidi. We kamukabeida tomoꞌotoqanidiavo kadikaimatavuloqa Yaubada inaveledi bwaigaotoqina!” ");
INSERT INTO mzz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Vanuqa Pilo masikedaneye, Ieisu mane kabayato tamo vivineye imiabui tomoꞌotoqa ietonovidi, we dimane iyatoyato. Tomoꞌotoqa guyoguyodi puedi dimane bwaigidi iyatoyatodi. ");
INSERT INTO mzz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Matautauda kwabula yomuyomudi imai, dimane mesai toea bweubweudi kailuqa idodoqidi kabayato waineye. ");
INSERT INTO mzz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ieisu kanatovemulivo iqolekauqidi waidie ivesipupu ivo, “Aivonemi mwaqitana, dede kwabulanidi yomuyomudi dikalaqeimaimaiqa isaki, matautauda tupwaidiavo. ");
INSERT INTO mzz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Paina tupwaidiavo iyato we diloyato bwaigidi imiamia, we gumanidi yomuyomudi vakai dimia paipaina gunabei iyatosaweni.” ");
INSERT INTO mzz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","No tutuyanina Ieisu Vanuqa Pilo naqeneyeꞌeqa isasauyeni kanatovemulivo tamo ivesipupu waineye ivo, “Tovekaivevena, kukiseni, gileu bwaigidi wete vanuqa kanakisa giamaiotoqina!” ");
INSERT INTO mzz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ieisu ibaivila ivo, “Dede vanuqanidiavo kukisedi giamaidi! We kamukabeida me-Diu kadiqaviavo puepuena inakavekapoidi ge tamo gileu inamiamia ediavo tabwadie.” ");
INSERT INTO mzz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ieisu Koya Olibe tabwaneye imiabui Vanuqa Pilo ikisabaleni. We Pita, Diemesi, Dioni wete Anidulu kaisediqa imai Ieisu waineye ivelautolieni ");
INSERT INTO mzz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ivo, “Kudavonema, malavia dede kuvesipupuyedi inasauyedi. Wete vakai kiakiaya beqa naqai inavekaivevena, matautauda inasauyedi?” ");
INSERT INTO mzz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","We Ieisu ivonedi ivo, “Kwavekisabodebodemi, ge tamo aitoi inakatupwaiemi. ");
INSERT INTO mzz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tomoꞌotoqa puedi inamai kaguwavaqaeqa, inavo, ‘Yau Keliso!’, we tomoꞌotoqa puedi inakatupwaiedi. ");
INSERT INTO mzz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tutuyanina qavia butudi kwainoqaidi wete tupwaidiavo qavia valeadi kwainoqaidi, ge kwaigololo. Avonemi, dede sakunidiavo naqaida de mesai inasauyedi, we noko ge kabavekakava. ");
INSERT INTO mzz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Paina tomoꞌotoqa kadiyoko bwaigina wete tamo tomoꞌotoqa kadiyoko bwaigina taiauda inaetalaqa, we kabaloina tamo wete kabaloina taiauda inaetalaqa. Tutuyanina waineye yoyoyo vikai puena waidie wete lase bwaigina wete valabubuna kapoidi pwayapwaya matatabuna waidie. We no valabubuna kapoidinidiavo kaia kabavelamu mesai tutuyanina vavine mwau waidie diveviqa ivelamu kadilautovona ilalautovoni, we mulineye diveviqa inavebwaiga. ");
INSERT INTO mzz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kwaivekisabodebodemi! Tomoꞌotoqa inamai inakavikavinimi inanawemi togumetavo bwaigidi waidie vonayavu paipaina, wete inanigemi kabakaipitala beqa vanuqa kabavelaukui naqedie Yau paipaigu. Komi kwaitovoi toloinavo wete kinivo matadie Yau paipaigu, Yau kwaivesipupuyegu waidie. ");
INSERT INTO mzz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kabavelamu Valea Giamaina kwaisapayavuleni kabaloina puena waidie, mulineye tutuya kabavekakava inamai. ");
INSERT INTO mzz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","We tutuyanina inakavikavinimi inanawemi vonayavu paipaina ge kwaivenuanaluqa mulineye vakai kago kwaivesipupuyeni. Mivonanidiavo ge komi kwaivesipupu, we tutuyanina waineye vonanidiavo Yaubada Vaitabuna inavelemi mesai kwaivesipupuyedi. ");
INSERT INTO mzz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tomoqo taina inakalaqeieni toloinavo waidie inaluvewapai we tama natudiavo inakalaqeiedi waidie inaluvewapadi. We gwagwama inatovoi inadiavo wete tamadiavo waidie inaetalaqa we inakalaqeiedi toloinavo waidie inaluvewapadi. ");
INSERT INTO mzz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tomoꞌotoqa puedi inabailemi paina Yau kwavetumaqanegu, we aitoi inatovoi pakalaqa, kabavekakava waineye ketoyavu inababaneni. ");
INSERT INTO mzz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Matautauda Ieisu ivo, “No tutuyanina saku kapoiotoqina komi kwaikiseni inatovoi vikainina ge nakabatovoi. (Vemataluana towawa waidie: Komi kwaivekautovona kwainuakawananaqaia saku dede paipaidi!) No tutuyanina gumanidiavo Iudia waineye kwaivonedi inadeqa koya waidie. ");
INSERT INTO mzz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","We eqavoi vanuqa kanakubu beabeana tabwaneye inatovotovoi kwaivonedi ge kanasala inaobu divanuqa naqeneye saku inakewai inadeqa vedimadimanaeqa. ");
INSERT INTO mzz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wete eqavoi tanoqe kwaivonedi ge inanaqo vanuqe kadivaiqavu paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kaiatanidiavo waineye mwau bwaigaotoqina toveinainaqe wete tovesusu waidie. ");
INSERT INTO mzz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yaubada waineye kwaivelaukui sakunidiavo ge inasauyedi wailuku kanatutuya waineye. ");
INSERT INTO mzz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","No tutuyanina waineye kaiata mwau bwaigiotoqina. Yaubada pwayapwaya ivalabubuni imai kasiotoqa ge mesai mulineye wete ge inasauyedi. ");
INSERT INTO mzz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Veviqanidiavo kanatutuya Yaubada inalaukalakusai. Kago ge Yaubada inalaukalakusai, tomoꞌotoqa matatabudi inawapa. Paina wayaqina inakaivaisedi tomoꞌotoqanidiavo ivesinuedi paipaina beqa tutuyanina Yaubada inalaukalakusai. ");
INSERT INTO mzz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Tutuya mulineye Keliso katupoe, wete tovesipupu katupoe inasauyedi kiakiaya kabanuavilele inavalabubunidi. Kago kadisala Yaubada natomoꞌotoqa vesivesinuadi inavekautovona inakatupwaiedi. Beqa tamo aitoi inamai inavonemi inavo, “Kwakise! Side Keliso!” o inavo, “Sino vikai waineye Keliso!” bonadi ge kwaivetumaqanedi. ");
INSERT INTO mzz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Beqa kwaivekisabodebodemi! De valeanina gunabei avonemi, beqa no tutuyanina ge tamo aitoi inakatupwaiemi. ");
INSERT INTO mzz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","We no tutuyanina mwau bwaigiotoqina mulineye, valavala inavaitomai, wetaki ge inagabu. ");
INSERT INTO mzz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mwatuia abameꞌeqa inayavuta we tovelulunavo abama waineye inavekalapeto. ");
INSERT INTO mzz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Matautauda tomoꞌotoqa puepuedi inakiseni Mwaqitana Kanatomoqo inalausimatala waumana tabwaneye, we inamaimai menaveluluna wete mataꞌuduꞌudulina. ");
INSERT INTO mzz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","We naꞌanelosevo inavetunedi inanaqo pwayapwaya matatabuna matana pulina waidie Yaubada natomotoqavo vesivesinuadi inagwagwakauqidi, pwayapwaya vikaineyeꞌeqa wete inanaqo vikaineye.” ");
INSERT INTO mzz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","We Ieisu ivelamu ivesipupu, “Kabakisa modaba waineye tutuyanina luguna inayatoyatodi wete inadiadia kwaiyagovi tutuya bagula. ");
INSERT INTO mzz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Beqa no mesai de valabubunanidiavo kwaikisedi inasauyedi kwaiyagovi Yau Mwaqitana Kanatomoqo gumai saiqanaqa ailekwa. ");
INSERT INTO mzz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Avona mwaqitana waimie, lagata dede ge inakakava kanaketoava valabubunanidiavo avesipupuyedi waimie inasauyedi. ");
INSERT INTO mzz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Abama wete pwayapwaya inakakava, we guvona ge inakakava inamiavaqata.” ");
INSERT INTO mzz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Wete Ieisu ivonedi ivo, “Guvilavaituqana kanakaiata wete kanatutuya ge tamo aitoi idayagovi, anelose abame ge idayagovi, wete Yau Yaubada natuna ge adayagovi, we kaia Tamagu kaisena iyagoyagovi. ");
INSERT INTO mzz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Beqa kwaimia laugamasa wete kwaivekisabodebodemi, paina ge kwadayagovi malavia gututuya vilavaituqana inalekwa. ");
INSERT INTO mzz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tamo kabakisa aivonemi: We kago mesai tamo tomoqo inatauya we navanuqa kanatolituqavo inayatoi dimadie inaekisabodebodeni, wete natolituqavo tamoqana tamoqana dilituqa inaveledi inavavalabubuni, we masikeda kanatomiagamata inavoneni inamia laugamasa inaekisabodaboda. ");
INSERT INTO mzz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Beqa komi kwaimia laugamasa we kwaivekisabodebodemi, tawe, paina komi ge kwadayagovi malavia tonivanuqa inavilavaituqana, oge lavilavie, o lovana gamwane, o kamukamu inagwaqegwaqe, o mamale. ");
INSERT INTO mzz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kwavekisabodebodemi! Beqa ge inamai vedimadimanaeqa inababanemi kwaikenokeno. ");
INSERT INTO mzz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Vakai waimie avesipupuyeni, mesai avesipupu puedi waidie, kwaimia laugamasa!” ");
INSERT INTO mzz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kaiata kailuqa inakakava mulineye, me-Isileli Vesikaqalataqona* kananuavekavina kanakani wete Beledi Tutubeabeana Ge Mekanaisiti* kanakani inavalabubuni. Tutuyanina tovelomuvo bwaigidi* wete loina kanatovekaivevenavo kedakeda ilalauala banikodiqa Ieisu vaigavueqa inakavikavini. ");
INSERT INTO mzz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","We ivo, “Sagali naqeneye ge taikavikavini kago mesai tomoꞌotoqa inadaba taiau taivetalaqa.” ");
INSERT INTO mzz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","We Ieisu Bedani imiamia Saimoni Lepelo navanuqe ikanikani, we vavine bunama maqaina giamaina imaieni. Kanawavaqa nadi we kanatutula bwaigina, we botolina gileu giamaina kanawavaqa alabasita beqa ivalabubuni. We bunamanina imaieni botolina itutubaia Ieisu kunukununa iꞌiwaqi. ");
INSERT INTO mzz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tomoꞌotoqa tupwaidiavo vavivenidi ikisedi vakai ivalabubuni Ieisu waineye paipaina kadikapoka ioqala ediavo waidie iesipupu ivo, “Uvale bunama maqaina giamaina we iekamubwadodoyeni? ");
INSERT INTO mzz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kadisala idavegimwaneyeni mane kanabwaiga 300 seluba idakewai yomuyomudi idaveledi.” De mesai ibwadubwaduyedi. ");
INSERT INTO mzz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","We Ieisu ivonedi ivo, “Kaiana! Ge kwaitalabodebodeni. Uvale kwabwadubwaduyedi? Vavinenidi saku giamaina ivalabubuni waigue. ");
INSERT INTO mzz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tutuya puena yomuyomudi komi taiauda kwaimiamia. Beqa kanasala kwaikaivaisedi tupwaidiavo kaiata waidie. We Yau ge komi taiauda taimiamia. ");
INSERT INTO mzz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Vavine dede dikaivaisa waigue bwaigina we ge tamo vakai beqa inavalabubuna waigue. Vovogu ibunama vaqateni inavalabubuni kagutavuna paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Avona mwaqitana waimie pwayepwayeye vikai puena waidie tomoꞌotoqa valeagu giamaina inanoqanoqai, wete vavine vesipusipupuna inanoqai vakai ivalabubuni waigue, kananuavekavina paipaina.” ");
INSERT INTO mzz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tutuyanina waineye Ieisu kanatovemulivo 12 waidieꞌeqa tamo, kanawavaqa Iudasa Isakaliota, inaqo tovelomuvo bwaigidi* waidie inaketoqiluveni. ");
INSERT INTO mzz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iudasa Isakaliota navona inoqai imwasanaotoqa we ivo, “Mane kaivelemu.” Beqa Iudasa itauya inaqo kedakeda inalauala Ieisu inakalaqeieni tovelomuvo bwaigidi waidie. ");
INSERT INTO mzz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","We tutuyanina Beledi Tutubeabeana Ge Mekanaisiti kanakaiata kabavelamu waineye me-Diu sagali ivavalabubuni, kaiatanina waineye, kaisaya sipi natuvaudi inigedi imaiedi Vesikaqalataqona* kanakani paipaina inavalabubuna. Ieisu kanatovemulivo ivelautolieni, “Vakaiebe waineye wayaqimu kainaqo Vesikaqalataqona* kanakani kaivalabubuni komu paipaimu?” ");
INSERT INTO mzz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Beqa Ieisu kanatovemulivo kadikailuqa ivonedi, “Kwainaqo Ielusalema tamo tomoqo bwasi kabagoi ikavalai inaqonaqo kwaibabaneni, komi kwaivemulieni taiau kwainaqo. ");
INSERT INTO mzz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Vanuqanina waineye inalugulugu taiauda kwailugu tonivanuqa kwaivoneni kwanavo, ‘Tovekaivevena ivo: ‘Vakaiebe tutudabanina waineye Yau wete kagutovemulivo taiauda kaikani Vesikaqalataqona* kananuavekavina kanakani?’ ");
INSERT INTO mzz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Matautauda tutudaba bwaigina waineye kivi navalabubuni taiauda we tabwaneye inavevemi waineye kanikani kwaivalabubuni paipaida.” ");
INSERT INTO mzz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tovemulivo itauya inaqo Ielusalema, sakunidiavo mesai Ieisu ivesipupuyedi waidie ibabanedi. We kanikani ivalabubuni, Vesikaqalataqona* kananuavekavina paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","We lavilavie Ieisu mekanatovemulivo kadikuma 12 imai. ");
INSERT INTO mzz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kabakani waineye ikanikani Ieisu ivo, “Avona mwaqitana, tamo waimieꞌeqa inaketoqiluvegu, gumanina taiauda kakanikani.” ");
INSERT INTO mzz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","We tovemulivo nuadi ikapo ivelamu iesipupu tamoqana, tamoqana waineye ielautolieni, “Oge Yau?” ");
INSERT INTO mzz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ieisu ibaivila ivo, “Tamo komi kamikuma 12 waimieꞌeqa, tamo deqoina Yau taiauda kakanikani. ");
INSERT INTO mzz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","We Mwaqitana Kanatomoqo inawapa mesai Buki Pilo waineye ivesipupu. We toketoqiluva gumanina veviqa bwaigina inababaneni. We giamaina oge tutuya base toketoqiluvanina inana ge idavetubuqi beqa kaimatavuloqa bwaigina ge idababaneni.” ");
INSERT INTO mzz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","We ikanikani, Ieisu beledi ikewai ivelaukui ivekaiwa, matautauda igiatomwai, kanatovemulivo iveledi ivo, “Kwakewai, dede vovogu.” ");
INSERT INTO mzz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Matautauda vedi ikewai ivekaiwa Yaubada waineye, kanatovemulivo iveledi puepuedi beqa iyemu. ");
INSERT INTO mzz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ieisu ivesipupu ivo, “Dayaqigu dede. Ilailolo tomoꞌotoqa puepuedi paipaidi. Yau dayaqigunina Yaubada navonadabadaba kaivauna kanagiavepakala. ");
INSERT INTO mzz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Avona mwaqitana waimie, oine ge wete aiyemuya kanaketoava Yaubada nakabaloina waineye oine kaivauna aiyemu.” ");
INSERT INTO mzz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Matautauda kewa tamo ikeweni isauyedi inaqo Koya Olibe waineye. ");
INSERT INTO mzz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","We Ieisu kanatovemulivo waidie ivesipupu ivo, “Matatabumi Yau kwaikiawegu kwaivekaladeqa. Yaubada navona Buki naqeneye dede mesai, ‘Sipi tokisavekavina ainigei, we sipi inakalisapa.’ ");
INSERT INTO mzz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yaubada wapaeqa inasivetovoigu aigumeta ainaqo Galili mulineye komi kwaimai.” ");
INSERT INTO mzz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","We Pita Ieisu waineye ivesipupu, “Oge dede matatabudi inakiawemu inavekaladeqa, we Yau gebuka.” ");
INSERT INTO mzz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ieisu ivesipupu Pita waineye, “Avona mwaqitana waimue, de lovananina waineye, komu muvekewa kaitonu kunavo, ‘Yau ge adayagovi!’ we mulineye kamukamu inagwaqe kailuqa.” ");
INSERT INTO mzz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","We Pita menaveluluna iesipupu ivo, “Kago komu taiauda taiwapa, we ge aivekewemu!” Wete enavo puedi mesai iesipupu Ieisu waineye. ");
INSERT INTO mzz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ieisu kanatovemulivo taiauda inaqo kawalawa kanawavaqa Gedesemani waineye, Ieisu tovemulivo ivonedi ivo, “Kwamiabui kwaimiamia, Yau ainaqo aivelaukui.” ");
INSERT INTO mzz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pita, Diemesi wete Dioni imaseagadi taiauda inaqo. Ieisu ivelamu nuapouna iveviqa wete inuakapo. ");
INSERT INTO mzz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Beqa Ieisu ivesipupu waidie ivo, “Yau nuapogu ieviqa saiqanaqa inaluvewapagu. Beqa de waineye kwaimiamia we ge kwaikeno kwaimia laugamasa.” ");
INSERT INTO mzz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ieisu itauya inaqo saiqana kanikie ilaukabubu ielaukui oge Yaubada idatagwaneni veviqa kanavikaie ge idanaqo. ");
INSERT INTO mzz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ivo, “Tamagu, tamagu komu saku puena kamusala kivalabubunidi, beqa veviqa kanavedi dede kukewai we ge aiyemuya, we Yau ge gunuanua kivalabubuni, we komu munuanuana.” ");
INSERT INTO mzz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","We Ieisu ivila imai ikisedi kanatovemulivo kadikaitonu ikenokeno, Pita waineye ivesipupu, “Saimoni, komu kukenokeno? Uvale ge kamusala kikisakisa tamo maibala paipaina?” ");
INSERT INTO mzz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","We ivesipupu waidie ivo, “Komi vaitabumi wayaqina giamaina kwaivalabubuni, we komi vovomi ibwalogo. Komi kwaimia laugamasa beqa kwaiveluluna beqa kapoina ge inawewesemi waineye kwaibeku.” ");
INSERT INTO mzz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wete inaqo ivelaukui, vonanidiavo iluvaituqanidi. ");
INSERT INTO mzz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Matautauda ivila imai tovemulivo waidie ikisedi wete ikenomataiva ikenokeno; paina matadi idudunaotoqa. Beqa ge idayagovi banikodiqa bonana inabaivilai. ");
INSERT INTO mzz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kanavetonu waineye ivila imai ivesipupu waidie, “Komi giladi kwakenokeno we kwaeyawai? Kaiana! Tutuya gunabei imai! Kwakiseni, Mwaqitana Kanatomoqo inakalaqeiegu tokapoina dimadie. ");
INSERT INTO mzz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kwatovoi tainaqo. Kwakise, side kagutoketoqiluva!” ");
INSERT INTO mzz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ieisu giladi iesipupu, we Iudasa tamo tovemulivo 12 waidieꞌeqa ilekwa. Mulineye yoko bwaigina medikepata wete mediwabibi. Tovelomuvo bwaigidi*, loina kanatovekaivevenavo wete tomoqovo bwaigidi, ivetunedi inaqo. ");
INSERT INTO mzz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kenaoye Iudasa toketoqiluva kiakiaya tamo gunabei ivesipupuyeni ikakava yoko waidie ivo, “Kwaikisawai tomoqonina aiyaoqi gumanina kwaikavikavini kwainaweni.” ");
INSERT INTO mzz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iudasa ilekwa inaqo Ieisu waineye ivo, “Tovekaivevena!” We iluaqavuya iyaoqi. ");
INSERT INTO mzz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Matautauda ikavikavini itoge ialakikikia. ");
INSERT INTO mzz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","We tamo tomoqo itovotovoi vividie nakepata isiokei tovelomuvo bwaigidi kaditogumeta* natolituqa taniqana igusuya. ");
INSERT INTO mzz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ieisu ivesipupu waidie ivo, “Banikodiqa, kwamai waigue memikepata memiwabibi, kwaikavikavinigu, tadavo Yau mesaida toloinabai? ");
INSERT INTO mzz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaiata, kaiata Yau komi taiauda, tamiamia aekaivevena waimie Vanuqa Pilo masikedaneye, we ge kwadakavikavinigu? Dede isasasauyeni beqa Buki Pilo naqeneye ivesipupu paipaigu kanamwaqitana inasauyeni.” ");
INSERT INTO mzz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","We Ieisu kanatovemulivo puedi ibaileni ideqa. ");
INSERT INTO mzz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tamo tomoqo tubuauna kanakaleko kaia kaitamoqaotoqina ikweseni yoko iemuliedi. Tomoqonina ikiseni nigo idakavikavini. ");
INSERT INTO mzz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","We kanakaleko isiyavuya dimadie we vovo kavakavana ideqa. ");
INSERT INTO mzz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","We tutuyanina Ieisu kanatokavikavinavo inaweni tovelomuvo bwaigidi kaditogumeta* navanuqe, we tovelomuvo bwaigidi* matatabudi, tomoqovo bwaigidi wete loina kanatovekaivevenavo imai imiakauqa. ");
INSERT INTO mzz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ivemulieni saiqana kanikie inaqo tovelomuvo bwaigidi kaditogumeta* navanuqe masikedaneye ilugu, maleweye imiabui tolituqavo taiauda, kai waineye ievala. ");
INSERT INTO mzz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","We tovelomuvo bwaigidi* wete me-Diu Togumetavo* puepuedi Ieisu kanavemwau paipaina ilalaualeni no beqa kadisala inayatoi wapa waineye, we ge kadisala inababaneni. ");
INSERT INTO mzz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tovonakaivaisa puepuedi katupoeꞌeqa ivesipupu Ieisu paipaina, we divesipupunidiavo ge idavesala. ");
INSERT INTO mzz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","We tomoqovo tupwaidiavo itovoi katupoeꞌeqa ivesipupu ");
INSERT INTO mzz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ivo, “Kima kanoqai de mesaida ivesipupuyedi, ‘Yau de Vanuqa Pilo tomoꞌotoqa dimadieqa iyoqoni aiqeuyavuleni, we Yau kaiata kaitonu inakakava Vanuqa Pilo kaivauna aiyoqoni, tomoꞌotoqa ge kanasala dimadieqa inayoqoni.’” ");
INSERT INTO mzz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Oge de mesai ivesipupuyedi, we divesipupuvo ge tamo idavesala. ");
INSERT INTO mzz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","We tovelomuvo bwaigidi kaditogumeta* tomoꞌotoqa yoko gamwadie Ieisu ivelautolieni, “Uvale komu ge wayaqimu divona paipaimu kibaivilai?” ");
INSERT INTO mzz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","We Ieisu iekwada, ge tamo vona idavesipupuyeni. Wete tovelomuvo bwaigidi kaditogumeta* ivelautolieni, “Komu Keliso, Gumanina Tadididigeni Natuna?” ");
INSERT INTO mzz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ieisu ibaivila ivo, “Ee, Yau. De mesai Yaubada nabuki ivesipupuyeni, komi Yau Mwaqitana Kanatomoqo kwaikiseni Toveluluna kataqineye aimiabui, we waumana tabwaneye aiobuma.” ");
INSERT INTO mzz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","We tovelomuvo bwaigidi kaditogumeta* Ieisu navona inoqai kanakapoka ioqala, kanakaleko ilabuki we ivo, “Kima ge wayaqima tupwaidiavo vonakaivaisa! ");
INSERT INTO mzz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kwanoqai navonamaimaiqa Yaubada isiwataoni. Banikodiqa minuanua?” Matatabudi ivo, “Ieisu ivalabubunakapo beqa inawapa.” ");
INSERT INTO mzz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","We tupwaidiavo ivelamu Ieisu igiwagiwali, wete matana kalekoeqa ipania dimadieꞌeqa inigenigei, we ivonevoneni, “Kago komu Yaubada natovesipupu kivonema aitoi inigemu?” We wete tolauqaviavo ikewai inaweni itoge inigei. ");
INSERT INTO mzz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","We Pita giladi imiabui imiamia tovelomuvo bwaigidi kaditogumeta* navanuqa masikedaneye, we tamo vavine tovelomuvo bwaigidi kaditogumeta* natolituqa imai. ");
INSERT INTO mzz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","We tutuyanina Pita ikiseni ievala, ikisanaqo ikisavetovetonovi ivo, “Komu wete Ieisu tomoqo Nasaleta iana.” ");
INSERT INTO mzz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","We ivekeweni ibaivila ivo, “Ge adayagoviqa vakai kwaesipupuyeni,” matautauda itovoi inaqo kala kawaneye itovotovoi. We kamukamu lamoqina igwaqe. ");
INSERT INTO mzz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tolituqa vavinedi no waineye ikiseni, wete ivesipupu vaituqana tomoꞌotoqa itovotovoi waidie, “Dede tomoqonina tamo iadi!” ");
INSERT INTO mzz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wete Pita ivekewa vaituqana ivo, “We ge mwaqitana.” Tutuya kalakusana waineye tomoꞌotoqa itovotovoi Pita iwewesa vaituqaneni, “Mwaqitana komu tamo iadi paina me-Galili.” ");
INSERT INTO mzz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","We Pita ivonedi ivo, “Avonalaga Yaubada waineye avona mwaqitana! Tomoqonina kwaesipupuyeni ge adayagovi!” ");
INSERT INTO mzz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","No waineye kamukamu lamoqina igwaqe veluqai, we Pita inuani base vakai Ieisu waineye ivesipupuyeni ivo, “Naqaida komu kivekewegu kaitonu kunavo, ‘Ge adayagovi’ mulineye kamukamu lamoqina inagwaqe veluqai.” Beqa ivelamu ilaumataqeu. ");
INSERT INTO mzz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","We kawakawaiotoqe tovelomuvo bwaigidi*, tomoqovo bwaigidi, loina kanatovekaivevenavo, wete me-Diu Togumetavo* matatabudi itagwana Ieisu inawapa. Beqa ditolauqaviavo dimana iyoqonidi ivegumetai inanaweni Pailato Loma gabemani waineye inavemwauya. ");
INSERT INTO mzz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","We Pailato Ieisu ivelautolieni ivo, “Komu me-Diu dikini?” We ibaivila ivo, “Vakai kuvesipupuyeni mwaqitana.” ");
INSERT INTO mzz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Beqa tovelomuvo bwaigidi* valabubuna kapoidi beqa ivemwauya. ");
INSERT INTO mzz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","We Pailato ivelautoli vaituqaneni ivo, “Banikodiqa, ge kudabaivila? Kunoqai! Valabubuna kapoidi puedi beqa iemwaumu!” ");
INSERT INTO mzz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","We Ieisu ge tamo vakai idavesipupuyeniqa, beqa Pailato nuana ivilele. ");
INSERT INTO mzz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","We diqaba tamoqana, tamoqana Vesikaqalataqona* sagalina kanakaiata waineye Pailato navalabubuna tamo tomoqo gumanina vanuqa kabakaimatavuloqa naqeneye, aitoi gumanina me-Diu wayaqidi inavelaukuieni, Pailato inayavuya. ");
INSERT INTO mzz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","No kaiatanina tomoqo, kanawavaqa Balabasi, vanuqa kabakaimatavuloqa naqeneye imiamia. Loma tolauqaviavo dede tomoqonina ikavikavini tupwaidiavo tovetalaqavo taiauda, gumanidiavo me-Loma diloina ikawakapoyeni we wete tupwaidiavo tomoꞌotoqa iluvewapadi. ");
INSERT INTO mzz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Beqa yoko bwaigina imai Pailato ivelaukuieni tamo aitoi inayavuya mesai diqaba tamoqana, tamoqana waidie ivavalabubunedi. ");
INSERT INTO mzz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","We Pailato gunabei iyagovi tovelomuvo bwaigidi* Ieisu ivedebadebaguyeni beqa Ieisu ikalaqeieni waineye beqa tomoꞌotoqa ivelautoliedi ivo, “Wayaqimi me-Diu mikini aiyavuya paipaimi?” ");
INSERT INTO mzz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","We tovelomuvo bwaigidi* ivona veluveluluna tomoꞌotoqa waidie beqa Pailato ivoneni ivo, “Balabasi kuyavuya inanaqo, we Ieisu ge kiyavuya!” ");
INSERT INTO mzz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","We Pailato ivelautoli vaituqanedi ivo, “Vakai wayaqimi waigue tomoqo dede waineye aivalabubuni gumanina tupwaimiavo kwavo, ‘Me-Diu dikini?’” ");
INSERT INTO mzz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","We iveqole bonadi bwaigidieqa ivo, “Kututupwateni!” ");
INSERT INTO mzz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","We Pailato ivelautoliedi ivo, “Banikodiqa? Vakai tamo valabubuna kapo ivalabubuni?” We wete iveqole mediveluluna ivo, “Kututupwateni!” ");
INSERT INTO mzz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","We Pailato wayaqina yoko inagiavemwasanidi, beqa Balabasi iyavuya inaqo. We tolauqaviavo ivonedi beqa Ieisu inigei ikewai inanaweni inatupwateni. ");
INSERT INTO mzz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","We tolauqaviavo Ieisu inaweni Pailato navanuqa kabaloina kanamasikedeye iluguveni matautauda tolauqaviavo matatabudi iqolekauqidi. ");
INSERT INTO mzz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","We kaleko yaqoyaqona mesai kini kadivaiqavu ikewai beqa Ieisu ivesipapai. We bulava mwalamwalaqidi ikewadi imetanidi kunukununeye iyatoi ");
INSERT INTO mzz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","we isasaidibieni ivo, “Kamwasanemu, komu me-Diu dikini!” ");
INSERT INTO mzz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","We utoqanaeqa kunukununeye ikakainige wete igiwagiwali. We mataneye kaqedi iveketonokuyedi iekimataneni mesai kini. ");
INSERT INTO mzz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","We isasaidibieni ikakava vovoneye kaleko yaqoyaqona isitakia, we taunina kanakalekoeqa ivekweseni ikewai inaweni inatutupwateni. ");
INSERT INTO mzz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","We itauya inaqonaqo tomoqo Sailini ikiseni kanawavaqa Saimoni, Alekisana, Lupuso tamadi. Gumanina tanoqeꞌeqa imaimai, we kedeye ibabaneni iloineni Ieisu kanalaukenobalabala ikavalai. ");
INSERT INTO mzz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","We Ieisu inaweni vikai kanawavaqa Goligota waineye. (Goligota kanayagova kunukunu kanavikai.) ");
INSERT INTO mzz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Matautauda oine wete mulo taiauda ivalabubuni Ieisu iveleni nigo idayemu, we Ieisu ibaileni. ");
INSERT INTO mzz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","We kanakalekovo ikewadi isenai bou tamoqana tamoqana waidie. We gileu ikewadi, we tamo gova igoveni beqa kalekonidiavo bou tamoqana tamoqana ikalaqeiedi. ");
INSERT INTO mzz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","We kawakawaie tutuya mesai 9 koloki Ieisu itutupwateni. ");
INSERT INTO mzz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bodi igililia vonanina beqa iemwauya ivo, “Dede me-Diu dikini.” We bodinina laukenobalabala waineye itutupwateni kunukununa tabwaneye. ");
INSERT INTO mzz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ieisu wete tovainaqo kadikailuqa taiauda itutupwatedi. Ieisu kanalaukenobalabala gamwaneye, we tamo tovainaqo kanalaukenobalabala kanakataqie tamo kanakelie. ");
INSERT INTO mzz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","We tomoꞌotoqa puedi itauya inaqonaqo kenaoye ikudekude wete ilotomwasiꞌieni ivo, “Ee! Kukisa! Komu kuvo, ‘Vanuqa Pilo aiqeuya kaiata kaitonu aiyoqona vaituqani.’ ");
INSERT INTO mzz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Beqa taunimu kuketoyavumu laukenobalabala waineyeꞌeqa kuobuma.” ");
INSERT INTO mzz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","We tovelomuvo bwaigidi* wete loina kanatovekaivevenavo ediavo taiauda isaidibieni kaisekavadi ivo, “Kwakise, tupwaidiavo iketoyavudi, we banikodiqa, taunina ge idaketoyavuya! ");
INSERT INTO mzz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Base ivonaqa ivo, ‘Yau Keliso Yaubada Kanavesivesinua* me-Isileli dikini,’ beqa kanasala laukenobalabala waineye inaobuma kida taikiseni taivetumaqaneni.” We kadikailuqa laukenobalabala tabwaneye taiauda itautaula kanakataqie we kanakelie Ieisu iyaqaia. ");
INSERT INTO mzz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kaiata gamwana kanalavilavi waineye pwayapwaya matatabuna ivaitomai kanaketoava 3 koloki lavilavi. ");
INSERT INTO mzz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","No tutuyanina 3 koloki Ieisu iveqole bonana bwaiginaeqa ivo, “Eloi, Eloi lama sabakitanai?” Kananuakawananaqai ivo, “Gu-Yaubada, gu-Yaubada vakai paipaina kukiawegu?” ");
INSERT INTO mzz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","We tomoꞌotoqa tupwaidiavo itovotovoi inoqai ivo, “Kwanoqai oqe, Ilaitia iqoleqoleni.” ");
INSERT INTO mzz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tamo tomoqo ilaukwavina inaqo balou ikutuvi oine yuyuyuna waineye itutumwalaqeni welavi mataneye isilagai Ieisu inaveyemuya, we ivo, “Kwavekwada. Taikiseni oge Ilaitia inamai laukenobalabala waineyeꞌeqa inakewa obuyeni.” ");
INSERT INTO mzz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","We Ieisu iveqole bonana bwaiginaeqa yawaina ikakava. ");
INSERT INTO mzz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","We Vanuqa Pilo naqeneye kalekonina beqa tutuya matatabuna tutudaba Pilopilona ibububuliqa ikawalabukaluqedi tabwaneye iobu dibuneye. ");
INSERT INTO mzz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","We tolauqaviavo kaditogumeta itovotovoi Ieisu kanalaukenobalabala dibuneye ikiseni Ieisu banikodiqa iwapedimo. Beqa ivo, “Mwaqitana tomoqo dede Yaubada Natuna.” ");
INSERT INTO mzz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","We vevine tupwaidiavo ietonova kanikieꞌeqa. Waidieꞌeqa Meli Magidalini, we tamo Meli Diemesi siaina we Iosese inadi wete Salome. ");
INSERT INTO mzz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","We wete vevine puedi no waineye, gumanidiavo base inaqo Ielusalema Ieisu taiauda. Base tutuyanina Ieisu Galili imiamia dede vevinenidiavo iemulieni wete iekisabodebodeni. ");
INSERT INTO mzz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Vanuqa bwaigina Alimadiaeqa tomoqo kanawavaqa Diosepa. Gumanina ivekimataneni bwaigina me-Diu Togumetavo* diyoko tamo naqeneye, we ilalaugamasa Yaubada nakabaloina paipaina. Saiqanaqa valavala inaketoniveni no kaiatanina waineye ivavalabubuna Kaiata Kabaveyawai paipaina, beqa Diosepa inuavatu inaqo Pailato ikiseni ivelaukuieni Ieisu vovona paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tutuyanina Pailato ielaukuieni itoalavunuqi ivo, “Aa, Ieisu yawaina gunabei ikakava?” Beqa tolauqaviavo kaditogumetanina Ieisu itutupwateni laukenobalabala waineye iqoleni, we ivelautolieni ivo, “Ieisu yawaina gunabei ikakava?” ");
INSERT INTO mzz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","We ibaivila ivo, “Mwaqitana.” Pailato inoqai, beqa Ieisu vovona itagwaneni Diosepa waineye. ");
INSERT INTO mzz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","We Diosepa kaleko giamaina wete tatatalina igimwanei imaieni, laukenobalabala waineye Ieisu vovona isitakia iobuyeni iumai ikewai inaweni iyatoi ovu* waineye, base tomoꞌotoqa gileu italaluguveni waineye. We gileu bwaigina beabeana vivivilina ivelikolikokoi inaweni ovunina kawana itutubodai. ");
INSERT INTO mzz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","We Meli Magidalini wete Meli Iosese inana Ieisu vovona waineye iyatoyatoi we ietonovi. ");
INSERT INTO mzz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","We tutuyanina Kaiata Kabaveyawai gunabei ikakava, Meli Magidalini we Meli Diemesi inana wete Salome inaqo bunama maqaina giamaina igimwanei wayaqidi inanaqo Ieisu vovona inabunamai. ");
INSERT INTO mzz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","We wiki kanakaiata gumegumetana waineye kawakawaiotoqe valavala bakamidiqa ivulaoqa inaqo ovu* waineye. ");
INSERT INTO mzz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","We inaqonaqo iesipupu kedakeda kaisedi ivo, “Aitoi gileu bwaigina ovu* kawaneye idavelikolikokoi paipaida?” ");
INSERT INTO mzz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","We tutuyanina ilekwa ikisanaqo gileunina bwaigina gunabei ivelikolikokoi ibala. ");
INSERT INTO mzz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tutuyanina ilugu ovunina naqeneye tamo tomoqo tubuauna ikiseni kaleko tatatalina ikweseni kadikataqie imiabui imiamia, we ikiseni igololo. ");
INSERT INTO mzz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","We anelose ivesipupu waidie ivo, “Ge kwaigololo komi Ieisu tomoqo Nasaleta kwalalaualeni gumanina itupwateni, weye gunabei wapaeqa itovoi vaituqana, gumanina ge idamiamia de waineye. Kwakise side waineye vovona iyatoi. ");
INSERT INTO mzz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","We kwanaqo kanatovemulivo kwavonedi wete Pita taiauda kwavoneni kwanavo, ‘Gumanina igumegumeta Galili. No waineye kwaikiseni base mesai ivonemi.’” ");
INSERT INTO mzz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tutuyanina inoqai no vevinenidiavo nuadi ivilele wete igololo isauyedi ovuyeꞌeqa ilaukwavina ikiaweni. We paina igololo beqa kedeye ge tamo aitoi idavoneni. ");
INSERT INTO mzz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tutuyanina kawakawaiotoqe wiki kanakaiata kabavelamu waineye, Ieisu gunabeida itovoi vaituqana Meli Magidalini waidie naqaida ilausimatala. Base dede vavinenidi waidie vaitabu kapoidi kadiyoko 7 ikwavinedi. ");
INSERT INTO mzz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","We inaqo kanatovemulivo gumanidiavo nuadi ikapo wete itaitaiqa Ieisu paipaina ivonedi vakai isauyeni. ");
INSERT INTO mzz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","We tutuyanina Meli ivonedi ivo, “Kakiseni; Ieisu gunabeida itovoi vaituqana,” we divona ge idavetumaqaneni. ");
INSERT INTO mzz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mulineye, tutuyanina vanuqa bwaigina Ielusalema ikiaweni inaqonaqo, Ieisu ilausimatala kanatovemulivo kadikailuqa waidie. We ge kadisala inayagovi paina kanakisa sulina. ");
INSERT INTO mzz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","We tutuyanina iyagovi ivila inaqo kanatovemulivo tupwaidiavo ivonedi, we divona ge idavetumaqaneni. ");
INSERT INTO mzz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mulineye Ieisu ilausimatala kanatovemulivo 11 waidie ditutuya kani waineye. We iyaqaidi ivo, “Nuami tabodadi ge idakawabwegabwegadi wete ge kwadavetumaqanegu. Oge gunabei ikisegu gutovoi vaituqana mulineye we ivemataluanimi, uvale divona ge kwadavetumaqanedi?” ");
INSERT INTO mzz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ivonedi ivo, “Kwasauyemi kwanaqo vanuqa tamoqana tamoqana pwayapwaya matatabuna waidie Valea Giamaina kwalauguguyeni tomoꞌotoqa puepuedi waidie. ");
INSERT INTO mzz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aitoi gumanina inavetumaqanegu we inababitaiso, gumanina ketoyavu inababaneni. We aitoi ge inavetumaqanegu kaimatavuloqa inababaneni nakapoina paipaina. ");
INSERT INTO mzz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","We kagutovetumaqanavo kiakiaya veluvelulunidi inavalabubunidi. Kaguwavaqaeqa vaitabu kapoidi tomoꞌotoqa naqedie inakwavinedi inasauyedi, we bonana sulidi sulidi ge idayagovidi we beqa inavesipupu. ");
INSERT INTO mzz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Gumanidiavo baisoa kapoidi dimadieqa inakavikavinidi, we siwaya inayemu ge inakavekapoidi. Wete dimadi toviqa waidie inayatodi inakavegiagiamaidi.” ");
INSERT INTO mzz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","We mulineye Tomwaya Ieisu iesipupu waidie ikakava, we Yaubada imaseagai ilagaveni abame, ivemiabuia Yaubada kataqineye vikai vekimakimatanina waineye. ");
INSERT INTO mzz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","We kanatovemulivo inaqo vikai puena waidie Valea Giamaina ilalauguguyeni, we Tomwaya ikaivaisedi dilauguguya igiaveluveluluni paina naveluluna beqa kabanuavilele ivalabubunidi tomoꞌotoqa ikisedi. ");
ALTER TABLE mzz_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
