﻿USE sofia;
DROP TABLE IF EXISTS sofia.mzq_vpl;
CREATE TABLE mzq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mzq_vpl WRITE;
INSERT INTO mzq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teopilu henu pinelangkai, Adio mia mpeꞌusaha poꞌuki tutulu mongkono henu gagi i olondo, ");
INSERT INTO mzq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","heleo henu ro paleleꞌo ndi ikito, mia henu amba-ambano mengkitoakeo mataro ka paleleꞌo olai kareba raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hoꞌioto raaꞌa, umaringgu paresaꞌo mentee-mentee opio henu gagi teꞌembu la amba-ambano, iaku mokosiꞌo nggale umukiꞌakomu teꞌatora tumondaꞌo posunsuno tutuluno. ");
INSERT INTO mzq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Taꞌalu liraꞌa, iiko bisa tumoꞌorio taꞌalu lowono henu upinaguruꞌako mentee suꞌu. ");
INSERT INTO mzq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tempono i Herode gagi mokole i waawute Iudea, hina aso puꞌu petewawo pesomba henu mengeengako i Sakaria. Iwono raaꞌa aso mia teꞌembu la bawaano i Abia. Walino mboꞌu inuleno Petewawo Pesomba Langkai Haruni, ngeeno i Elisabe. ");
INSERT INTO mzq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iworo neea mia henu tinuwuro mokonsanaaꞌiro Ue Ala ka iworo takau kano pompasala-sala tumondaꞌo lowono parenta ka atora-atoraro i Ue. ");
INSERT INTO mzq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kanggo iworo karo peꞌana akono i Elisabe bita ka iworo mboꞌu mosuꞌoiroto. ");
INSERT INTO mzq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Aso tempo, tempono bawaano i Abia mohawe tiano moꞌangga i Doharo Ue Ala, i Sakariato henu lumolakoꞌakeo anggaꞌa gagi puꞌu petewawo pesomba i aroro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Puꞌu petewawo pesomba pia mompatantu isia nggale mendamo i laro Doharo Ue Ala saru mompake lotrei. I Sakaria kono lotrei mendamo monsunu dupa rahea. ");
INSERT INTO mzq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tempono dupa raaꞌa sinunu, lowono mia henu i bungkuno mekakai. ");
INSERT INTO mzq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bingkosako aso malaꞌekaro Ue Ala mopokiteo koroino ndi Sakaria. Malaꞌeka raaꞌa mentada i koanano poꞌianga ponsunua dupa. ");
INSERT INTO mzq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tempono i Sakaria kumiteo malaꞌeka raaꞌa, iwono takau tekokoni ka doito. ");
INSERT INTO mzq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kanggo malaꞌeka raaꞌa mepau ndi iwono, “Hooto doito Sakaria, pekakaimu hinorioto. I Elisabe walimu nggale meꞌanaꞌako aso ana tama ka iiko asolekono ngumeengakeo Iohane. ");
INSERT INTO mzq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iiko nggale sanaa ka memawongko ka adio mia mpoꞌunde taꞌalu ana raaꞌa pineꞌanaꞌakoto. ");
INSERT INTO mzq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Iwono nggale gagi mia henu takau mantudu i aroro Ue Ala. Iwono kano poꞌenu anggoro ara enua henu mompokomolangu. Iwono nggale bukeako Penao Mempori teꞌembu la kompono ineno. ");
INSERT INTO mzq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Adio to Isaraeli nggale no waweiro mekule ndi Ue Alaro. ");
INSERT INTO mzq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iwono nggale koleko-leko meleꞌeruiꞌiro Ue Ala ka mompasadiꞌakeo ansalaRo i laro roso ka pobawa henu menggena saru nabi Elia, kano aroaro uma-uma meꞌambo mekule la ana-anaro ka mia henu tai metenunu ndi iworo Ue Ala nggale mekule mompewowolo henu mentee. Lowono raaꞌa no wowauꞌo Iohane kano mompasadia aso bawaa henu pototono ndi iworo Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Humoringo raaꞌa i Sakaria mepau la malaꞌeka raaꞌa, “Ehende kunggale tumoꞌorio lowono raaꞌa? Akono mosuꞌo akuto. Walinggu mboꞌu mosuꞌooto takau nggale meꞌana.” ");
INSERT INTO mzq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaꞌeka raaꞌa sumangki, “Iaku neea Gabrieli, henu biasa mentada i aroro Ue Ala. No tenaꞌaku mepau ndi iiko ka pauꞌakomu kareba meꞌambo neea. ");
INSERT INTO mzq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lowono henu kupauꞌakomu, aso tempo asolekono gagi. Kanggo akono iiko kau peꞌale-aleo opio henu kupauꞌo, iiko nggale gagi bebe ka kaulo mokopepau ranta anamu pineꞌanaꞌako.” ");
INSERT INTO mzq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kontongaano raaꞌa mia henu mensikorio i Sakaria kombaa, akono iwono epieꞌoto lahi i laro Doharo Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tempono i Sakaria meluarako teꞌembu i Doharo Ue Ala, iwono andono bisa mepauꞌakero. Kumiteo raaꞌa, ro mentoꞌorioto taꞌalu iwono monggito arapio i laro Doharo Ue Ala, akono iwono butu no kawe-kaweꞌiro ka andono pokopepau. ");
INSERT INTO mzq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Menseno popio oleo, umarioto anggaꞌano. Kanoamba mekule i dohano. ");
INSERT INTO mzq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ambono epie teꞌembu rahea, mentiaꞌoto i Elisabe walino. Olimo betuꞌe epieno i Elisabe kano hori meluarako teꞌembu i dohano. I Elisabe mepau, ");
INSERT INTO mzq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Iwonoto neea henu winowauro Ue Ala ndi iaku. Iworo barakatiꞌaku ka umoninio mokokoꞌiinggu i aroro mia akono bitanggu.” ");
INSERT INTO mzq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Menseno i Elisabe mentia oono betuꞌe, Ue Ala tumenaꞌo malaꞌeka Gabrieli lumeko i wute Nasare laꞌaso waawute i Galilea. ");
INSERT INTO mzq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gabrieli tinena lumeko laꞌaso ana erowai henu ambono petao mengeengako i Maria. Iwono raaꞌa mesamboraoto saru aso tama henu mengeengako Iusu inuleno mokole Daudi. ");
INSERT INTO mzq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tempono malaꞌeka raaꞌa mewunso i dohano i Maria, malaꞌeka raaꞌa mongee, “Taabe, ikomiu henu pineꞌaroa, Ue kumongkomiko.” ");
INSERT INTO mzq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria takau tekokoni humoringo pauno malaꞌeka raaꞌa, ranta mesisikeno i laro aroano, pio pengkonoano petabe raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaꞌeka raaꞌa mongee ndi iwono, “Hooto doito Maria, akono iiko pineꞌaroa i arono Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iiko nggale mentia ka nggale meꞌanaꞌakeo aso ana tama ka iiko nggale ngumengakeo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iwono nggale gagi marambaa ka ngineengako Anaro Ue Ala henu i wawono takau. Ka Ue Ala nggale mokogagio puꞌu poparenta heleo mia mosuꞌono i Daudi. ");
INSERT INTO mzq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iwono nggale gagi mokole la lowono inuleno Iako iwonoto Isaraeli henu tai hina tampulaano ka poparentaNo tai hina pinggoaano.” ");
INSERT INTO mzq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mongeeꞌoto i Maria la malaꞌeka raaꞌa, “Ehende nggale bisa gagi, akono iaku da ana erowai?” ");
INSERT INTO mzq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sumangki malaꞌeka raaꞌa, “Penao Mempori nggale hawe ndi iiko ka pobawaro Ue Ala nggale kumongkomiko, hoꞌioto puꞌuno ana henu nggale pineꞌanaꞌakomu raaꞌa nggale nginee mempori, Anaro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Pewowoloꞌo Maria, i Elisabe petiamu raaꞌa, tekonai mentia oono betuꞌe mapono mosuꞌooto ka mia mpongee, iwono bita. ");
INSERT INTO mzq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kanggo akono la Ue Ala kano hina henu tai gagi.” ");
INSERT INTO mzq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mongeeꞌoto i Maria, “Iaku neea ataro i Ue, gagito la ngkoroinggu heleo henu pinaumiu.” Umari raaꞌa, lumekooto malaꞌeka mobintao i Maria. ");
INSERT INTO mzq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kano epie teꞌembu rahea, lumekooto i Maria laꞌaso inie i waawute Iudea henu makuntoruku. ");
INSERT INTO mzq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Menseno hawe ndepano iwono mewunso i dohano i Sakaria ka metabe ndi Elisabe. ");
INSERT INTO mzq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tempono i Elisabe humoringo petabeno i Maria, ana-ana henu nopentiaꞌakeo raaꞌa melelu ka i Elisabe bukeako Penao Mempori. ");
INSERT INTO mzq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kanoamba i Elisabe mepau mompetea ndi Maria lenie, “Ue Ala barakatiko torea teꞌembu la lowono erowai mesue ka ana henu upentiaꞌakeo Ro barakatiꞌo Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tembio kano gagi lenie ndi iaku ranta ineno Uenggu hawe mai tepohaweꞌakune? ");
INSERT INTO mzq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kiteo, tempono kuhoringo petabemu, ana henu i laro komponggu melelu moꞌunde. ");
INSERT INTO mzq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Meꞌurakoto akono iiko mompeꞌalo-alo taꞌalu pio henu pinauro Ue Ala ndi iiko mentee suꞌu nggale gagi.” ");
INSERT INTO mzq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","I Maria mepau, “Penaonggu umunde-undeꞌiro Ue Ala, ");
INSERT INTO mzq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ka aroanggu sanaa, akono Ue Ala kumaduduiꞌaku, ");
INSERT INTO mzq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","akono Ue Ala kumiteoto tinuwunggu, ataRo henu mokokoꞌundu. Menteeꞌano mompamula oleo neea, lowono mia nggale mpongee iaku neea binarakatiro Ue Ala, ");
INSERT INTO mzq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","akono Ue Ala henu pobawa mowowau henu langkai ndi iaku ka ngeeRo Mempori. ");
INSERT INTO mzq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ue Ala mehohawaꞌiro mia henu metotoako ndi Iworo hawe la inulero. ");
INSERT INTO mzq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iwono mowowau henu kombaaꞌakoa saru pobawaNo ka Iwono sumaariiro mia henu mompelangka-langkai. ");
INSERT INTO mzq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mokole Nopotiingiro teꞌembu la petundaꞌaro ka mia henu mokokoꞌundu No pokolangkaiꞌiro. ");
INSERT INTO mzq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mia henu momoli No pokomowotoꞌo saru kaanga henu meꞌambo, kanggo mia henu sugi Ro tenaꞌiro lumeko saru kae molimbo. ");
INSERT INTO mzq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","AtaRo to Isaraeli Ro tulungiiro akono Ro pewowoloꞌo pompehohawaRo, ");
INSERT INTO mzq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","henu dinandiRo la mia mosuꞌondo i Burahima ka inuleno, hawe la pokotompaano.” ");
INSERT INTO mzq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Umari raaꞌa otolupo betuꞌe epieno no poꞌia i Maria ndi Elisabe, umari raaꞌa kanoamba mekule i inieno. ");
INSERT INTO mzq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Haweoto betuꞌeno i Elisabe nggale meꞌana. Iwono meꞌanaꞌakeo aso ana tama. ");
INSERT INTO mzq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tempono petengi-tengi dohano ka petiano humoringo taꞌalu Ue Ala mopokiteo pompehohawaRo ndi iwono, iworo lowo mensanaa meronga-ronga saru iwono. ");
INSERT INTO mzq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kohoalu oleono, mehaweiroto i dohano i Sakaria mentondaꞌo gau petindiꞌano ana-ana raaꞌa, ka iworo minggi ngumengaakeo ana-ana raaꞌa i Sakaria, montonda ngeeno umano. ");
INSERT INTO mzq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kanggo ineno ana-ana raaꞌa mongee, “Hooto, iwono asolekono ngineengako Iohane.” ");
INSERT INTO mzq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Humoringo raaꞌa, iworo mpongeeꞌakeo, “Kano hina teꞌaso mia i olono petiamu henu mengeengako ngee liraꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Gagi iworo mpesikeno la umano ana-ana raaꞌa butukoa ro kawe-kaweꞌo, nggale ngineengako isia ana-ana raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","I Sakaria momoni wasu poꞌukia ka no ukiꞌo, “Ngeeno Iohane.” Iworo lowo kombaa. ");
INSERT INTO mzq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tempo koa raaꞌa mboꞌu, i Sakaria mokopepauꞌoto ka umunde-undeꞌiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kumiteo lowono raaꞌa, lowono petengi-tengi doharo doito ka lowono henu gagi raaꞌa iworo mempopauꞌo la lowono inie henu hina i torukuno Iudea. ");
INSERT INTO mzq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lowono mia henu humoringo raaꞌa numaꞌo i laro aroaro ka mepau, “Nggale gagi pioke ana-ana neea?” Akono ro mengkiteo pobawaro Ue Ala kumongkomio. ");
INSERT INTO mzq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ka i Sakaria, umano ana-ana raaꞌa bukeako Penao Mempori ka iwono mompokotehawe pau henu nggale gagi lenie, ");
INSERT INTO mzq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Inundeꞌiroto Ue Alaro to Isaraeli akono Iworo tepotowoakero bawaaRo ka motolahiiro. ");
INSERT INTO mzq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ropoweikito aso mia pongkadudui henu moroso teꞌembu la inuleno i Daudi ataRo, ");
INSERT INTO mzq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","heleo henu dinandiRo teꞌembu asompihe teliu la wiwiro nabi-nabiRo henu tinimakiRo. ");
INSERT INTO mzq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iwono medandi motolakito teꞌembu la uwelindo, ka teꞌembu la ngkaero lowono mia henu umoꞌalieꞌakito, ");
INSERT INTO mzq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","karo popokiteo pompehohawaRo la mia mosuꞌondo asompihe, ka pedandiRo henu mempori raaꞌa nggale Ropokomengkaaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Iwonoto pedandiꞌa henu Ro pauꞌo teliu la sumpa la mia mosuꞌondo i Burahima, ");
INSERT INTO mzq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kato tepotola teꞌembu la ngkaero uwelindo, ka ikito bisa mesombaiꞌiro henu kano hina doitondo. ");
INSERT INTO mzq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Iworo medandi liraꞌa, kano i laro tinuwundo i wawontolino neea, ikito bisa mesombaiꞌiro montonda tuwu mempori ka mokonsanaaꞌo aroaRo. ");
INSERT INTO mzq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka iiko ananggu, iiko ungga nggale ngineengako nabiro Ue Ala henu i wawono takau, akono iiko ungga nggale meleꞌeruiꞌiro Ue Ala mompasadiaꞌakeRo ansalaRo. ");
INSERT INTO mzq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Iiko ungga nggale mompalele la bawaaRo mongee iworo nggale inampuni, taꞌalu Ue Ala umampuniꞌiroto teꞌembu la halaro. ");
INSERT INTO mzq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Akono peꞌaroaro Ue Alando henu bukeako pompehohawa tepotowoꞌakito heleo mataꞌoleo wantahikito teꞌembu i suruga, ");
INSERT INTO mzq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kano wantahio mia henu tuwu la rokomaano ka henu doito la matea, kano wawokito i laro tuwuꞌa henu sintuwu.” ");
INSERT INTO mzq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anano i Sakaria raaꞌa kolangka-langkaino ka komoro-morosono petondano ndi iworo Ue Ala, ka iwono moꞌia la pada one ranta hawe tempono no pamulaꞌo anggaꞌano mompalele pauro Ue Ala la to Isaraeli. ");
INSERT INTO mzq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kano epie umarino Iohane pineꞌanaꞌako, Mokole Langkai Roma moluarako parenta metena la lowono henu la pomparentaꞌa i Roma mepeꞌuki ngee. ");
INSERT INTO mzq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iwonoto neea peꞌukia ngee henu koꞌaso winowau tempono Kireniu gagi akele i Siria. ");
INSERT INTO mzq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gagi lowono mia tempo raaꞌa mpekule mpeꞌuki ngee i inie mpuꞌuro. ");
INSERT INTO mzq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Liraꞌa koamboꞌu Iusu lumeko teꞌembu i Nasare i waawute Galilea, lumeko i waawute Iudea i inieno Daudi henu ngineengako Beteleme, akono iwono mboꞌu teꞌembu inuleno i Daudi. ");
INSERT INTO mzq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Iusu lumeko mepeꞌuki ngee saru samborano i Maria henu tekonai mentia. ");
INSERT INTO mzq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kontongaaro i Beteleme, haweoto tempono i Maria nggale meꞌana. ");
INSERT INTO mzq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","No peꞌanaꞌakeo aso ana tama, anano henu koꞌaso. Anano raaꞌa tinongohako tarango hawu, kanoamba pinolero la dula, akono iworo tai mohawe doha peratoꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","I wute raaꞌa, hina to pompakambi henu mpoꞌia la mpada mpogagai pinotuwuro, notekonai wongi. ");
INSERT INTO mzq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bingkosako mentadaoto malaꞌekaro i Ue orambiakero ka marambaaro i Ue wantahiiro, ranta karo tedoa medoito. ");
INSERT INTO mzq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kanggo malaꞌeka raaꞌa mongee, “Hooto doito. Pehoringakeo, iaku hawe mowawo kareba meꞌambo ndi ikomiu, iwonoto kareba henu tedoa mawongkoa lowono mia. ");
INSERT INTO mzq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Oleo neea i inieno Daudi, hinaoto Mokole Pongkaduduimiu, Iwonoto Kirisitu Ue. ");
INSERT INTO mzq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Neea tondonino, ikomiu nggale mehaweꞌo aso dolo-dolo tinongohako saru tarango hawu ka pinolero la dula.” ");
INSERT INTO mzq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bingkosako malaꞌeka raaꞌa romperongao adio malaꞌeka mesue, henu mpoꞌunde-unde ndi Ue Ala. Ro mpongee, ");
INSERT INTO mzq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Marambaa tiaro Ue Ala henu i suruga, ka sintuwu karodoa i wawontolino, la mia henu mokonsanaaꞌo aroaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Menseno malaꞌeka-malaꞌeka mobintairo ka mpekule i suruga, to pompakambi raaꞌa mpepau-pau pada iworo, “Maito to meleko i Beteleme, mengkiteo arapio henu gagi ndepano, heleo henu pinauro i Ue ndi ikito.” ");
INSERT INTO mzq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Umarino raaꞌa pompari-pariiroto meleko, ro mehaweꞌoto i Maria ka Iusu, ka dolo-dolo raaꞌa henu tekonai pinolero la dula. ");
INSERT INTO mzq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Temporo to pompakambi mengkiteo dolo-dolo raaꞌa, ro mempauꞌoto opio henu pinauno malaꞌeka mongkono dolo-dolo raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ka lowono mia henu mehoringo opio henu pinauro to pompakambi raaꞌa, gagi mengkombaa lowo iworo. ");
INSERT INTO mzq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kanggo i Maria numaaꞌo lowono raaꞌa i laro aroano ka mewowoloꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Umari raaꞌa mpekuleiroto to pompakambi raaꞌa ka mpoꞌunde-unde ka mompelangkai Ue Ala, akono lowoakoano henu ro mehoringo ka ro mengkiteo, lowono menggena heleo opio henu ngineeno malaꞌeka raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Menseno sombo hoalu oleo tinuwuno Ana raaꞌa, Iwono tinindi ka ngineengako Iesu, heleo ngee henu pinauno malaꞌeka tempono ambono pentiaꞌakeo ineNo. ");
INSERT INTO mzq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Menseno sombo patompulo oleo Maria meꞌana, haweoto tempono tiano Iusu ka i Maria lumeko i Ierusale nggale wowauꞌo pokomemporia koroi umarino meꞌana montonda atora Taura Musa. Iworo mewaweo mboꞌu Iesu kano pinewengako ndi Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Gau raaꞌa ro wowauꞌo, akono hina teꞌuki la atora Taura lenie, “Lowono ana tama henu koꞌaso, asolekono pinewengako tiaro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iworo mboꞌu nggale mompesombaꞌako pesomba, iwonoto aso pasa sui-sui wurongkonggou ara oruo anano sui-sui marapati, heleo henu pinatantuoto la atora Taura. ");
INSERT INTO mzq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tempo raaꞌa i Ierusale, hina aso mia mengeengako i Simeo. Iwono aso mia henu mentee ka metenunu ndi Ue. Iwono epieꞌoto monsisikori Mokole Pongkadudui Henu Dinandiro Ue Ala hawe mongkadudui to Isaraeli. Penao Mempori kumongkomio, ");
INSERT INTO mzq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ka Penao Mempori umarioto mepau ndi iwono, mongee iwono ambonolo mate taꞌalu ambono kiteo Mokole Pongkadudui Henu Dinandiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","I Simeo hawe i Doharo Ue Ala akono pontaateno Penao Mempori. Tempo raaꞌa mboꞌu Iusu ka i Maria waweo Iesu nggale pinewengako ndi Ue Ala tumondaꞌo atora Taura, ");
INSERT INTO mzq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","no aleo Ana raaꞌa ka sumoseneo kanoamba umunde-undeꞌiro Ue Ala no pongee lenie, ");
INSERT INTO mzq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lenie Ue, poꞌinengoto ataMiu neea lumeko i laro sintuwu karodoa montonda pauMiu. ");
INSERT INTO mzq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Akono matanggu kumiteo pongkadudui henu teꞌembu ndi Ikomiu, ");
INSERT INTO mzq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pongkadudui raaꞌa henu Ipatindaꞌoto i aroro lowono tongku. ");
INSERT INTO mzq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ana neea heleo wanta henu nggale wantahio lowono tongku mesue, ka Iwono nggale mowawo marambaa la tongkuMiu to Isaraeli.” ");
INSERT INTO mzq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Humoringo henu pinauno i Simeo mongkono Iesu raaꞌa, tedoa kombaa umaNo ka ineNo. ");
INSERT INTO mzq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kanoamba i Simeo barakatiꞌiro ka mongee ndi i Maria, ineNo Ana raaꞌa, “Kiteo, heleo henu pinatantu Ue Ala, mongee teꞌembu la Ana neea adio mia Isaraeli nggale mensinolangi ka adio koamboꞌu henu kinadudui. Iwono nggale gagi tondoni teꞌembu la Ue Ala ka adio mia tai mentarimaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ka akono Iwono, mengkaaꞌoto opio henu pinewowoloro adio mia. Maria, mahaki aroamu teꞌingga heleo aroamu inuhuꞌako ponai.” ");
INSERT INTO mzq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Raheaꞌo mboꞌu hina aso nabi erowai, henu mengeengako i Hana anano i Panueli teꞌembu la tongkuno Asere. Iwono raaꞌa mosuꞌooto suꞌu. Opisu ntaꞌu no pebawaa saru tamano, ");
INSERT INTO mzq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ka lenie iwono tuwu erowai, ka tinuwuno halumpuloto ka ompa taꞌu. Iwono raaꞌa makari lumeko la Doharo Ue Ala, mowanda ka wongi mesomba ndi Ue Ala saru mepuasa ka mekakai. ");
INSERT INTO mzq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tempono i Simeo mepau, i Hana mboꞌu hawe rahea. Iwono hawe umunde-unde Ue Ala ka no pauꞌo mongkono Ana raaꞌa la lowono to Isaraeli henu hina rahea henu mensikorio tolaa teꞌembu la mapariaro. ");
INSERT INTO mzq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Umari Iusu ka i Maria wowauꞌo lowono parenta atora Taura, mpekuleiroto la mpoꞌiangaro i waawute Nasare i Galilea. ");
INSERT INTO mzq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ana raaꞌa kolangka-langkaiNo ka komoro-morosoNo ka Iwono gagi mokosongka ka Ue Ala takau mehohawaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sombo ntaꞌu mia mosuꞌono Iesu lumeko i Ierusale la oleo langkai Paskaa to Iahudi. ");
INSERT INTO mzq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Menseno hopuloto ka oruo ntaꞌu tinuwuno Iesu, melekoiroto i Ierusale heleo henu biasano ro mewowauꞌo to Iahudi la oleo langkai. ");
INSERT INTO mzq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Menseno umarioto oleo langkai raaꞌa, mekuleiroto mia mosuꞌoNo. Iworo tai tumoꞌorio mongee Iesu meꞌiaꞌako Ierusale. ");
INSERT INTO mzq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iworo mongee No tondaꞌo lowono mia henu mperongaro. Aso oleoto ro melolako kanoamba ro wusuꞌo Iesu i olono petiaro ka mia mesue henu tepotoꞌoriro. ");
INSERT INTO mzq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Akono iworo tai tepohaweꞌakeo, hoꞌioto karo pekule mboꞌu i Ierusale lumeko wusuꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Koꞌotolunoto oleo ro wusuꞌo, ro haweoto Iesu i Doharo Ue Ala, tekonai metunda meronga saru mia mpande atora Taura, mehoringakero ka mesikeno ndi iworo. ");
INSERT INTO mzq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Lowono mia henu mehoringo opio henu pinauNo, takau mengkombaa akono takau adio henu No toꞌorio, ka sangkiNo takau mentee. ");
INSERT INTO mzq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tempono mia mosuꞌoNo kumiteo Iesu, iworo tekokoni ka ineNo mongee ndi Iwono lenie, “Ana, tembio Kau powowau lenie ndi ikami? Iaku ka umaMu salalaro wusuKo.” ");
INSERT INTO mzq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu sumangki, “Uma, ine, tembio kai wusu Aku? Ikomiu kai toꞌorio mongee Iaku neea asolekono moꞌia i Doharo UmaNggu.” ");
INSERT INTO mzq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kanggo karo hawe laroꞌo opio ngineeNo. ");
INSERT INTO mzq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kanoamba Iesu mekule merongairo i Nasare, ka pia metenunu la mia mosuꞌoNo. Ka ineNo numaaꞌo lowo henu gagi raaꞌa i laro aroano. ");
INSERT INTO mzq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu kolangka-langkai ka pande ka Ro pehohawaꞌo Ue Ala ka mia. ");
INSERT INTO mzq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","La ntaꞌu hopulo ka olimo teꞌembu la poparentano Mokole Langkai Tiberiu, tempono i Pontiu Pilatu gagi akele i waawute Iehuda, ka i Herode gagi mokole i waawute Galilea, i Pilipu petiano gagi mokole i waawute Iturea ka i Tarakoniti, i Lisania gagi mokole i waawute Abilene, ");
INSERT INTO mzq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","I Hanasi ka i Kaiapa gagi Petewawo Pesomba Langkai. Tempo raaꞌa haweoto pauno Ue Ala ndi Iohane anano i Sakaria la pada one. ");
INSERT INTO mzq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Menseno Ue Ala mepau liraꞌa, lumekooto Iohane la lowono waawute i lembono korono Iarade ka iwono mepau mokora, “Imemoseato ka impewengakeo koroimiu binaho kano Ue Ala umampunio lowono halamiu. ");
INSERT INTO mzq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Henu no wowauꞌo Iohane raaꞌa menggena heleo henu teꞌuki la Wunta nabi Iesaia. Lenie no pongee, Hina mia henu mepau mokora la pada one, ‘Patindaꞌo ansalaro i Ue, pomoliꞌo ansala henu nggale teliuꞌaNo. ");
INSERT INTO mzq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lowono lembono nggale hinowui, toruku ka tamungku nggale pinelembo. Ansala henu molengku nggale pinomoli, ka ansala henu makuntoruku nggale pinokorata. ");
INSERT INTO mzq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ka lowono mia i wawontolino neea, nggale kumiteo Ue Ala mongkadudui mia.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Adio mia mehawe ndi Iohane momoni kano binaho. Iohane mongee ndi iworo, “Ikomiu inuleno ule meꞌipo! Hooto impompewowolo mongee, taꞌalu binaho komiuto, ikomiu bisa molao teꞌembu la tekudaro Ue Ala henu nggale hawe. ");
INSERT INTO mzq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gagi taꞌalu tinuwumu moseaꞌoto, popokiteoto gaumu henu meꞌambo. Hooto impompewowolo i laro aroamiu, ‘Ikami neea inuleno i Burahima gagi ikami tai nggale kono pohukuro Ue Ala.’ Kupauꞌakomiu, Ue Ala bisa baliꞌo wasu-wasu raaꞌa gagi ana-anano i Burahima. ");
INSERT INTO mzq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pohukuro Ue Ala heleo uase henu tetindaoto la mpuꞌuno kau ka lowono kau henu tai mewue meꞌambo, nggale tinuehi kanoamba tinadi la apui.” ");
INSERT INTO mzq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mia adio mesikeno ndi iwono, “Taꞌalu lesie, pio henu asolekono ki mpowowau?” ");
INSERT INTO mzq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sumangkioto Iohane, “Isia henu hina oruo lembano, asolekono no weiꞌakeo aso lembano la henu tai hina lembano, ka isia hina kangaano asolekono no poweiꞌo la henu tai hina kangaano.” ");
INSERT INTO mzq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tempo raaꞌa mehawe mboꞌu to ponsinga sima henu minggi pebaho ka mpesikeno ndi iwono, “Guru, opio henu asolekono kimewowauꞌo?” ");
INSERT INTO mzq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","No sangkiiro, “Hooto imponsinga torea, henu pinatantuoto ndi ikomiu.” ");
INSERT INTO mzq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Popioꞌiro sorodadu mboꞌu hawe mpesikeno ndi iwono, “Ikami, opio henu kinggale mpowowau?” Iohane sumangkiiro, “Hooto alongkoraꞌo doiro mia ka hooto petuluriako la mia saru tuluri henu tai mentee kano iiko bisa umaleo doino. Pesombooto tinuwumu saru gagimu.” ");
INSERT INTO mzq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lowono mia rahea mpesikori ka monsikori manasa Iohane neea Mokole Pongkadudui Henu Dinandiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hoꞌioto kano Iohane mongee ndi iworo lowo, “Iaku bahoꞌakomiu saru uwoi. Kanggo, Iwono henu lalua pobawa sekono iaku nggale hawe. Wowoho onggono sapatuNo tokoa, tai tepototo. Iwono nggale bahoꞌakomiu saru Penao Mempori ka apui. ");
INSERT INTO mzq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iwono nggale monsiaꞌo mia henu meꞌambo ka mia mosaꞌa, heleo duku henu tetindaoto la ngkaeNo nggale mokomorinaꞌo pae ranta kano morina, ka mokosiꞌo pae henu morina i laro siꞌeNo. Kanggo pae henu moꞌapa, nggale No soruo la apui henu tai pinokopepate.” ");
INSERT INTO mzq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Da adio patudu mesue henu pinaleleno Iohane tempono mompalele Kareba Meꞌambo la mia adio. ");
INSERT INTO mzq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aso tempo Iohane kumuahakeo mokole Herode akono umaleo i Herodia walino petiano gagi walino, ka akono lowono winowauno henu mosaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kanggo mokole Herode tumambaiꞌo mosaꞌano saru mondamoho Iohane i laro tarungku. ");
INSERT INTO mzq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Menseno adio mia mebinaho, ka tempono Iesu mboꞌu binaho ka tekonai mekakai, teꞌungkahioto langi, ");
INSERT INTO mzq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ka metiiꞌoto Penao Mempori heleo sui-sui marapati i wawoNo. Ka tehori suara teꞌembu i langi, no pongee, “Ikoto AnaNggu henu Kupehohawaꞌo, henu mokomawongkoꞌo aroaNggu.” ");
INSERT INTO mzq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tempono Iesu pamulaꞌo anggaꞌaNo, tinasere tinuwuno Iesu tolu mpuloto ntaꞌu. Montonda pohaweno mia, Iwono raaꞌa anano Iusu. Iusu raaꞌa anano i Eli. ");
INSERT INTO mzq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","I Eli anano i Matati, i Matati anano i Lewi, i Lewi anano i Maleki, i Maleki anano Ianai, Ianai anano Iusu, ");
INSERT INTO mzq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iusu anano i Matika, i Matika anano i Amosi, i Amosi anano i Naimi, i Naimi anano i Heseli, i Heseli anano i Nagai, ");
INSERT INTO mzq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","i Nagai anano i Maati, i Maati anano i Matika, i Matika anano i Simei, i Simei anano Ioseki, Ioseki anano Ioda, ");
INSERT INTO mzq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ioda anano Iohanani, Iohanani anano i Resa, i Resa anano i Serubabeli, i Serubabeli anano i Salatie, i Salatie anano i Neri, ");
INSERT INTO mzq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","i Neri anano i Maleki, i Maleki anano i Adi, i Adi anano i Kosami, i Kosami anano i Elimoda, i Elimoda anano i Eri, ");
INSERT INTO mzq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","i Eri anano Iesua, Iesua anano i Eliese, i Eliese anano Iorimi, Iorimi anano i Matati, i Matati anano i Lewi, ");
INSERT INTO mzq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","i Lewi anano i Simeo, i Simeo anano Iehuda, Iehuda anano Iusu, Iusu anano Ionami, Ionami anano i Eliaki, ");
INSERT INTO mzq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","i Eliaki anano i Melea, i Melea anano i Mina, i Mina anano i Matata, i Matata anano i Nata, i Nata anano i Daudi, ");
INSERT INTO mzq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","i Daudi anano Isai, Isai anano i Obe, i Obe anano i Boasi, i Boasi anano i Salamo, i Salamo anano i Nahaso, ");
INSERT INTO mzq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","i Nahoso anano i Aminada, i Aminada anano i Adimini, i Adimini anano i Arani, i Arani anano i Heseroni, i Heseroni anano i Peresi, i Peresi anano Iehuda, ");
INSERT INTO mzq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iehuda anano Iako, Iako anano Isaki, Isaki anano i Burahima, i Burahima anano i Tera, i Tera anano i Nahori, ");
INSERT INTO mzq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","i Nahori anano i Serugi, i Serugi anano i Rehu, i Rehu anano i Pelegi, i Pelegi anano i Eberi, i Eberi anano i Salamo, ");
INSERT INTO mzq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","i Salamo anano i Kenani, i Kenani anano i Arapasa, i Arapasa anano i Semi, i Semi anano i Noho, i Noho anano i Lame, ");
INSERT INTO mzq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","i Lame anano i Metusala, i Metusala anano i Eno, i Eno anano Iaresi, Iaresi anano i Mahaleli, i Mahaleli anano i Kenani, ");
INSERT INTO mzq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","i Kenani anano i Enosi, i Enosi anano i Seti, i Seti anano i Adama, Adama anano Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tempono Iesu mobintao korono Iarade, Iwono bukeako Penao Mempori. Penao Mempori waweo Iesu lumeko la mpada one. ");
INSERT INTO mzq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Rahea Mokole Onisu umara-arahakeo Iesu patompulo oleo epieno. Tempono patompulo oleo epieno raaꞌa kano hori monggaa arapio, hoꞌioto puꞌuno Iesu mokoninggo. ");
INSERT INTO mzq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mongeeꞌoto Mokole Onisu ndi Iesu, “Iiko anano Ue Ala. Gagi tenaꞌo wasu neea kano gagi roti.” ");
INSERT INTO mzq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sumangki Iesu ndi iwono, “Hina teꞌuki la Wunta Mempori, ‘Mia tuwu kano butu teꞌembu la roti koa.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kanoamba Mokole Onisu waweo Iesu laꞌaso poꞌianga henu medongke, aso mpepiroꞌa koa nopopokiteoꞌakeo lowono poparentaꞌa i wawontolino. ");
INSERT INTO mzq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mokole Onisu mboꞌu mongee ndi Iwono, “Lowoakoano pobawa ka marambaa raaꞌa aku weiko, akono lowono raaꞌa winei akuto ka aku weiꞌakeo ara ndi isia henu kupeꞌaroaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gagi taꞌalu Upesombaiꞌaku, lowono raaꞌa nggale gagi tiaMu.” ");
INSERT INTO mzq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kanggo Iesu mongee ndi iwono, “Hina teꞌuki la Wunta Mempori, ‘Pesombaiꞌo Ue Alamu ka butu ndi Iwono upesomba.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kanoamba no waweo mboꞌu Iesu lumeko i Ierusale, no naaꞌo i mbumbungeno Doharo Ue Ala, kanoamba mongeeꞌakeo, “Mentee, Iiko anano Ue Ala. Gagi dontaihakeo koroiMu teꞌembu endea ndebehi, ");
INSERT INTO mzq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","akono hina teꞌuki la Wunta Mempori, ‘Iwono nggale parentaꞌiro malaꞌeka-malaꞌekaNo mentulungiKo’, ");
INSERT INTO mzq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ka ‘Iro mensakoKo saru kaero, kano hooto kareMu kono wasu.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu mepau ndi iwono, “Hina teꞌuki la Wunta Mempori, ‘Hooto uꞌara-arahakeo Ue Alamu.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Menseno Mokole Onisu umari umara-arahakeo Iesu saru lowono poꞌara-arahakono raaꞌa, no pobintaoto ka sumikorio tempo henu meꞌambo. ");
INSERT INTO mzq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kanoamba Iesu mekuleoto i Galilea ka Iwono bukeako Penao Mempori. Kareba mongkono Iwono tepaleleoto la lowono waawute raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iwono tekonai mompaguru i laro doha-doha pesombaꞌa to Iahudi, ka lowono mia meꞌunde-undeꞌIro. ");
INSERT INTO mzq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu lumeko mboꞌu i Nasare i inie poꞌiangaNo langkai. Heleo biasano tempono oleo Penao-naoꞌa to Iahudi, Iwono lumeko la doha pesombaꞌa to Iahudi, ka mentada nggale mobasa Wunta Mempori. ");
INSERT INTO mzq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Iwono wineiꞌako Wunta henu inukino nabi Iesaia ka No wolaꞌo Wunta raaꞌa, No haweꞌo laino henu winusuNo kanoamba basaꞌo. Laino raaꞌa no pongee lenie, ");
INSERT INTO mzq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Penaoro i Ue hina ndi Iaku, akono Iwono motoro Aku mompopotehaweꞌo Kareba Meꞌambo la mia henu mekarampini. Ka Iwono tumenaꞌAku mompalele tolaa la mia henu rinako tempono la mpeteaꞌa, ka mompalele la mia henu memorawu mongee iworo nggale tompa, motolahiro mia henu teꞌata, ");
INSERT INTO mzq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ka mompalele taꞌalu temponoto Ue Ala mopokiteo pompehohawaNo la bawaaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Menseno umari No basaꞌo Wunta raaꞌa, No tutuꞌo Wunta raaꞌa ka No weiꞌakeo la mia henu moꞌangga la doha pesombaꞌa rahea. Kanoamba Iwono metunda, ka lowono mataro mia henu laro doha pesombaꞌa raaꞌa ntetutu ndi Iwono akono minggi mehoringo pompaguruNo. ");
INSERT INTO mzq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Umarino raaꞌa Iesu paguruꞌiro lenie, “Oleo neea mengkaaꞌoto pau henu teꞌuki la Wunta Mempori tempono imehoringo.” ");
INSERT INTO mzq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lowono mia mompau henu meꞌambo mongkono Iesu ka mengkombaa akono opio henu ngineeNo mompokosanaa aroa. Ro mpongee, “Kano Iwono ka neea anano Iusu?” ");
INSERT INTO mzq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kanoamba No pongeeꞌakero, “Matantu ikomiu nggale mompau Akune potundaano pau neea, ‘O dotoro, pokotompaꞌo koroimu liomu.’ Pengkonoano, ‘Wowauꞌo koamboꞌu i inieMu neea, heleo henu ki mehoringo Ikomiu wowauꞌo i Kapernau.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Umarino raaꞌa Iesu mepau mboꞌu, “Pewowoloꞌo, kano hina nabi henu pinelangkai la mpoꞌianga teꞌembuano. ");
INSERT INTO mzq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kanggo pewowoloꞌo, opio henu gagi la tempono nabi Elia saaꞌa. Otolu ntaꞌu torea epieno kano hori tii use, ranta kano gagi mokoninggoa la lowono tongku. Tempo raaꞌa adio tuwu erowai la to Isaraeli. ");
INSERT INTO mzq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Maupono lesie, Ue Ala kano tenaꞌo i Elia lumeko tumulungio laꞌaso mia teꞌembu ndi iworo. Kanggo iwono tinena lumeko montulungi laꞌaso tuwu erowai henu kano mia to Isaraeli i inie Sarapa, i waawute Sidoni. ");
INSERT INTO mzq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Liraꞌa koamboꞌu tempono nabi Elisa, adio mia Isaraeli henu kono haki melowe. Kanggo kano hina teꞌaso mia teꞌembu la to Isaraeli henu pinokotompa, butu i Naama mia to Siria raaꞌa henu pinokotompa.” ");
INSERT INTO mzq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mehoringo raaꞌa, lowono mia henu i laro doha pesombaꞌa to Iahudi raaꞌa gagi mentekuda. ");
INSERT INTO mzq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kanoamba iworo mpentada mensaario Iesu teꞌembu i inie raaꞌa. Nasare winangu i wawono toruku. Gagi ro mewaweo Iesu hawe i wiwino wingke. Tinunggairo mewaweo Iesu rahea akono iworo minggi medontaiꞌo Iesu la wingke raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kanggo Iesu teliu i oloro, ka lumeko mobintairo. ");
INSERT INTO mzq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kanoamba Iesu lumeko i Kapernau aso inie i waawute Galilea. Sombo oleo Penao-naoꞌa to Iahudi Iesu mompaguru i laro doha pesombaꞌa to Iahudi. ");
INSERT INTO mzq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iworo takau mengkombaa humoringo pompaguruNo, akono henu pinauNo nororonganio pobawaRo. ");
INSERT INTO mzq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","I doha pesombaꞌa to Iahudi raaꞌa hina aso mia henu pinendamohino onisu mepau mokora mongee lenie, ");
INSERT INTO mzq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“He, Iesu to Nasare, opio tinunggaiMu ndi ikami? Iiko hawe nggale sumolangi kami? Iaku tumoꞌorio isia Iiko. Iiko henu mempori tinimakiro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kanggo Iesu wurasaiꞌo onisu raaꞌa ka mongee, “Komino, peluarako teꞌembu la mia raaꞌa!” Kanoamba onisu raaꞌa mepasiakeo mia raaꞌa i tonga-tongano mia adio ka meluarako teꞌembu la mia raaꞌa, kanggo kano pokomahakiꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mengkiteo raaꞌa lowono mia henu rahea gagi mengkombaa ka mpepau aso mia ka aso mia lenie, “Mahenu takau pauNo, akono saru pobawa No parentaꞌo onisu-onisu ranta karo mpeluarako.” ");
INSERT INTO mzq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ka kareba mongkono Iesu tepalele la lowono waawute raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Menseno Iesu mobintao doha pesombaꞌa, Iwono lumeko i dohano i Simo. Rahea, ineno walino i Simo tekonai mokula nsaꞌa. Iworo momonio ndi Iesu kano pokotompaꞌo ineno walino i Simo. ");
INSERT INTO mzq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gagi Iesu mentada orambi la poturiano erowai raaꞌa, kanoamba kumuahakeo hakino raaꞌa. Hakino raaꞌa meluarako teꞌembu ndi iwono ka erowai raaꞌa ronga mewangu ka moꞌatoraꞌakero kaanga. ");
INSERT INTO mzq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Menseno sumooꞌoto oleo, lowono mia mewaweo petiaro henu memahaki ndi Iesu henu merupa-rupa hakino. Iwono motopao kaeNo i wawono aso mia ka aso mia ka mokotompaꞌiro. ");
INSERT INTO mzq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ka onisu-onisu meluarako teꞌembu la adio mia saru meꞌoraꞌako, “Iiko anaro Ue Ala.” Kanggo Iesu umonto mateꞌiro onisu-onisu raaꞌa kano hooto ro pepau, akono ro mentoꞌorio mongee Iesu Mokole Pongkadudui Henu Dinandiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Isomono, Iesu mobintao inie raaꞌa ka lumeko laꞌaso poꞌianga henu molimbo. Adio mia wusuꞌo ka mengkonaiꞌo Iesu. Menseno ro mengkonaiꞌo Iesu, iworo peꞌusaha umontoo Iesu kaindono pobintairo. ");
INSERT INTO mzq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kanggo Iwono mepau ndi iworo, “Iaku asolekono lumeko i inie waali paleleꞌo Kareba Meꞌambo iwonoto Ue Ala mompuꞌu momparenta i olono bawaaNo, akono hoꞌioto Ue Ala tumenaꞌAku i wawontolino neea.” ");
INSERT INTO mzq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gagi lumekooto Iesu mompalele Kareba Meꞌambo i doha-doha pesombaꞌa to Iahudi i Iudea. ");
INSERT INTO mzq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Aso tempo Iesu mentada i wiwi rano Genesare. Adio mia mpedudumpali orambiakeo Iesu minggi mehoringakeo pauro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","No kiteo oruo bangka i wiwi rano. To pobunde bou metiiꞌoto ka tekonai woꞌohio bundero. ");
INSERT INTO mzq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mewueꞌakooto Iesu laꞌaso bangka, iwonoto bangkano i Simo ka tumenaꞌo i Simo sumorongo bangkano olai teꞌesi teꞌembu i wiwino rano. Kanoamba Iesu metunda ka mompaguru mia adio teꞌembu i wawo bangka. ");
INSERT INTO mzq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Menseno umari mepau, No pongeeꞌakeoto i Simo, “Waweo bangkamiu la onaloano, ka petadiakeoto bundemiu kano ikomiu mohawe bou.” ");
INSERT INTO mzq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sumangki i Simo, “Guru, aso wongito ki mpoꞌangga takau mobunde bou kanggo kano hina pio-pio ki mpohawe. Kanggo akono Ikomiu henu metena, aku nggale metadiakeo bunde neea.” ");
INSERT INTO mzq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Menseno i Simo ka pokowalino henu meꞌaso bangka mompetadiako bunde, iworo mohawe adio takau bou ranta bundero minggi tebire. ");
INSERT INTO mzq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Gagi ro mengkaweꞌo pokowaliro henu la bangka mesue mai mokowaliiro. Pokowaliro raaꞌa memai ka iworo mperonga-ronga meꞌihiꞌo oruo bangka raaꞌa bukeako bou ranta bangka-bangka raaꞌa minggi tondu. ");
INSERT INTO mzq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Menseno i Simo Peturu kumiteo henu gagi, iwono menggoluntu i arono Iesu ka mongee, “Ue, pobinta aku, akono iaku neea mia tehala.” ");
INSERT INTO mzq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iwono mepau liraꞌa akono iwono saru pokowalino takau mengkombaa mengkiteo adio takau bou henu ro bundeꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Liraꞌa koamboꞌu pokowalino i Simo iwonoto Iakobu ka Iohane, anano i Sebedeu. Mongeeꞌoto Iesu ndi i Simo, “Hooto doito, mompuꞌu oleo neea iiko gagi pobunde mia.” ");
INSERT INTO mzq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Menseno ro mediiꞌo bangkaro i wiwi rano, ro pobintao lowoakoano ka tumondaꞌo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aso tempo Iesu tekonai la inie langkai. Rahea hina aso mia henu koroino bukeako haki melowe. Menseno no kiteo Iesu, iwono metotoako i aroro Iesu ka momoni ndi Iesu ka mongee, “Ue, taꞌalu Ikomiu poli, Ikomiu bisa pokotompa aku.” ");
INSERT INTO mzq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Menseno humoringo, Iesu tumeteakeo kaeNo, numangkiho mia raaꞌa ka mongee, “Poli Iaku, tompato.” Tempo koa raaꞌa mboꞌu tompa haki loweno. ");
INSERT INTO mzq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iesu umontoo mia raaꞌa pauꞌakeo la mia mesue mongkono opio henu gagi ka mongee, “Lekoto, popokiteo koroimu la puꞌu petewawo pesomba, pewengakeoto pesomba pokomemporia koroi teꞌembu la hakimu heleo henu petenano i Musa, kano mia mengkiteo taꞌalu iiko tompakoto.” ");
INSERT INTO mzq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kanggo, kareba mongkono Iesu sani tepalele olai, ka adio mia mehawe mehoringakeo Iesu ka pinokotompa hakiro. ");
INSERT INTO mzq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Maupo lesie Iwono tepipihe lumeko la mpoꞌia-ianga henu molimbo nggale mekakai. ");
INSERT INTO mzq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","I aso tempo, tempono Iesu mompaguru, hina popioꞌiro mia to Parisi ka mia mpande atora Taura metunda mehoringakeo Iesu. Iworo mehawe teꞌembu i inie-inie i waawute Galilea ka Iudea ka teꞌembu i Ierusale. Pobawaro Ue Ala kumongkomio Iesu, ranta Iwono bisa mompokotompa mia mahaki. ");
INSERT INTO mzq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tempo raaꞌa mboꞌu, hina popio mia molembara aso mia pungku i wawo poturiano. Iworo mpeꞌusaha mewaweo mia raaꞌa i laro doha kano iwono bisa ninaa i arono Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kanggo iworo kano bisa mewaweo mewunso, akono adio mia rahea. Pokotompaano iworo mpewueꞌako mewaweo mia pungku raaꞌa i wawono ato doha henu melembo ka meꞌungkahio ato raaꞌa. Kanoamba ro potiiꞌo mia raaꞌa saru poturiano i tonga-tongano mia adio mepontu i arono Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tempono Iesu kumiteo pompeꞌalo-aloro, mepauꞌoto Iesu, “Petia, halamu inampunioto.” ");
INSERT INTO mzq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mehoringo raaꞌa, mia mpande atora Taura ka mia to Parisi mompewowolo i laro aroano, “Iwono neea mepau bisa moꞌampuni hala, gagi Iwono neea sumosaꞌaiꞌo Ue Ala. Kano hina mia henu bisa moꞌampuni hala, saliwano Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kanggo Iesu tumoꞌorio pinewowoloro, ka mongeeꞌakero, “Hootomiu pompewowolo liraꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ndeake henu lalua moruana, Iaku mongeeꞌakeo la mia neea, ‘Halamu inampunioto’ ara mongee, ‘Pewanguto ka koleko-lekoto’? ");
INSERT INTO mzq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kanggo lenie Iaku nggale mopokiteo ndi ikomiu taꞌalu i wawontolino neea Ana Manusia pobawa moꞌampuni hala.” Umarino raaꞌa, Iesu mepauꞌoto la mia pungku raaꞌa, “Kupauꞌakomu, pewanguto, bintio poturiamu ka pekuleto i dohamu.” ");
INSERT INTO mzq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tempo raaꞌa mboꞌu mewanguoto mia pungku raaꞌa i aroro, bintio poturiano ka mekule i dohano, saru umunde-undeꞌiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lowono mia mengkombaa ka umunde-undeꞌiro Ue Ala, ka iworo takau medoito. Mongeeiroto, “Oleo neea ikito mengkiteoto henu takau kombaaꞌakoa.” ");
INSERT INTO mzq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Umari raaꞌa, Iesu meluarako teꞌembu i inie raaꞌa ka kumiteo aso mia to ponsinga sima henu mengeengako i Lewi, tekonai metunda la mpoꞌianga poꞌanggaꞌaro to ponsinga sima. Iesu mepau ndi iwono, “Tonda Akuto!” ");
INSERT INTO mzq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mentadaoto i Lewi mobintao lowoakoano ka tumondaꞌo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Menseno raaꞌa i Lewi mowowau aso rame-rame langkai tiano Iesu i dohano. Adio to ponsinga sima ka mia mesue monggaa meronga-ronga saru iworo. ");
INSERT INTO mzq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mengkiteo raaꞌa popioꞌiro to Parisi ka mia mpande atora Taura henu hina rahea mpoꞌamu-amu la ana guruno Iesu. Iworo mpongee, “Tembio ikomiu monggaa mperonga-ronga saru to ponsinga sima ka mia tehala?” ");
INSERT INTO mzq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu sumangkiiro, “Mia moroso kano momparalu dotoro, mia mahaki koa henu momparalu dotoro. ");
INSERT INTO mzq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iaku hawe i tolino kano mompoboi mia henu rumekeꞌo koroino mentee, kanggo mompoboi mia tehala kano mosea teꞌembu la halaro.” ");
INSERT INTO mzq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Popioꞌiro mia mongee ndi Iesu, “Ana guruno Iohane ka ana guruno to Parisi pia mepuasa ka mekakai, kanggo tembio ana guruMu monggaa ka moꞌenu?” ");
INSERT INTO mzq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu sumangkiiro, “Kano pototono sambeꞌe umbu ngkoroi tama tinena mepuasa, taꞌalu umbu ngkoroi tama tekonai rumoronganiiro la mpetaoꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kanggo, hina teꞌingga tempono umbu ngkoroi tama raaꞌa inalo teꞌembu ndi iworo. Tempoto raaꞌa ro nggale mpepuasa.” ");
INSERT INTO mzq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kanoamba Iesu montutulu ndi iworo aso eo-eono tuwuꞌa sombo oleo lenie, “Kano hina mia teꞌaso mobire lemba woꞌu ka tinombeliako la tarango lemba. Akono taꞌalu lesie, lemba woꞌu raaꞌa nggale masola ka bana henu imebireho teꞌembu la lemba woꞌu raaꞌa kano pototono tinombeliako la tarango raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Liraꞌa mboꞌu uwoi anggoro henu da sarai, kano bisa inihii la kandu kuli mosuꞌo. Akono taꞌalu lesie, uwoi anggoro henu da sarai raaꞌa nggale teꞌili ka kandu kuli raaꞌa nggale tebire. Pokotompaano uwoi anggoro raaꞌa tesolo ka kandu kuli raaꞌa gagi tesia-sia. ");
INSERT INTO mzq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Uwoi anggoro henu da sarai asolekono ninaa la kandu kuli henu da woꞌu. ");
INSERT INTO mzq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ka kano hina teꞌaso mia henu umari moꞌenu uwoi anggoro henu epie minggi moꞌenu mboꞌu uwoi anggoro henu woꞌu, akono iwono nggale mongee, ‘Meꞌamboopo uwoi anggoro henu epieꞌoto.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tempono oleo Penao-naoꞌa to Iahudi, Iesu ka ana guruNo menteliu laꞌaso lere gandu. Tempono ro mengkoleko-leko, ana guruNo mpoꞌopu arapopio wuku gandu raaꞌa, ro mengkulisio ka ro mengkaango. ");
INSERT INTO mzq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kanggo popioꞌiro to Parisi henu hina rahea mepau ndi iworo, “Menteeꞌano taꞌalu montonda atora agama, ikomiu kano bisa mpoꞌangga la oleo Penao-naoꞌa to Iahudi akono molinggei gau raaꞌa” ");
INSERT INTO mzq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu sumangki, “Ikomiu matantu umari mebasaꞌo Wunta Mempori mongkono opio henu no wowauꞌo Daudi saaꞌa. Tempo raaꞌa iwono ka lowono mia henu mentondaꞌo memokoninggo. ");
INSERT INTO mzq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mokole Daudi mendamo la kemaro Ue Ala momoni kaanga la puꞌu petewawo pesomba ka moꞌalo roti henu pinesombaako ndi Ue Ala ka kumaango, kanoamba moweiꞌakeo mboꞌu la pokowalino. Kanggo menteeꞌano kano hina teꞌaso mia ineheako monggaa roti raaꞌa saliwano puꞌu petewawo pesomba koa.” ");
INSERT INTO mzq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iesu mongee mboꞌu ndi iworo, “Ana Manusia henu pobawa mopatantu opio henu bisa winowau la oleo Penao-naoꞌa to Iahudi.” ");
INSERT INTO mzq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","I tempo oleo Penao-naoꞌa to Iahudi henu mesue, Iesu mendamo la doha pesombaꞌa to Iahudi ka mompaguru. Rahea hina mia henu kape kae koanano. ");
INSERT INTO mzq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rahea mboꞌu hina popioꞌiro mia mpande atora Taura ka to Parisi. Iworo tekonai mempoporoꞌo Iesu taꞌalu Iwono nggale mompokotompa mia la oleo Penao-naoꞌa to Iahudi, kano iworo pohawe ansala pokontehalaꞌo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kanggo Iesu tumoꞌorio pinewowoloro, kanoamba mepau la mia henu mate kae koanano raaꞌa, “Maito pentada i tonga-tongano endea!” Maiꞌoto mia raaꞌa ka mentada i tonga-tongaro. ");
INSERT INTO mzq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kanoamba Iesu mepau la mia henu hina rahea, “Iaku nggale mesikeno ari ndi ikomiu, opio henu bisa winowau la oleo Penao-naoꞌa to Iahudi, mowowau henu meꞌambo ara mowowau henu mosaꞌa? Mongkadudui mia ara mompepate mia?” ");
INSERT INTO mzq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Umarino raaꞌa Iesu mewalili mekaniiro henu i bolilino ka mepauꞌakeo mia henu kape kaeno raaꞌa, “Teteakeo kaemu.” Mia raaꞌa no teteakeo kaeno ka tompaoto suꞌu kaeno. ");
INSERT INTO mzq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mengkiteo raaꞌa, mia mpande atora Taura ka to Parisi takau mentekuda. Kanoamba iworo mepau aso mia ka aso mia, opio henu asolekono ro mewowauꞌo ndi Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tempo raaꞌa, lumekooto Iesu mekakai laꞌaso tamungku. Rahea, No pekakai aso wongi takau ndi Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Menseno mewanta, No poboiꞌiro ana guruNo memai ndi Iwono, ka montimaki hopulo ka oruo teꞌembu i oloro. Kohopulo ka oruono mia henu No timakio raaꞌa, No ngeengakeo rasul. Ngee-ngeero iwonoto: ");
INSERT INTO mzq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","I Simo henu No ngeengakeo Peturu, i Andaria andino i Simo, Iakobu ka Iohane, i Pilipu ka i Bartolomeu, ");
INSERT INTO mzq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu ka i Tomasi, Iakobu anano i Alapiu, ka i Simo henu pinoboi to Seloti, ");
INSERT INTO mzq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iudasi anano Iakobu ka Iudasi Iskarioti henu meꞌoliakeo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Menseno Iesu ka ana guruNo metii teꞌembu la tamungku raaꞌa, iworo mpenao-nao ka mentada la melemboano. Adio mia henu pia tumondaꞌo Iesu tepumpu rahea meronga-ronga mia mesue henu hawe teꞌembu la lowono waawute Iudea, teꞌembu i Ierusale, teꞌembu i waawute Tirusu ka Sidoni henu moꞌia i wiwi tahi. ");
INSERT INTO mzq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iworo mehawe minggi mehoringakeo Iesu mompaguru ka kano pinokotompa teꞌembu la hakiro. Iworo henu pinendamohino onisu hawe mboꞌu ka pinokotompa. ");
INSERT INTO mzq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lowono mia raꞌiroa mpeꞌusaha minggi uminiꞌo Iesu, akono hina pobawa meluarako teꞌembu ndi Iesu henu mompokotompairo lowo. ");
INSERT INTO mzq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu mekaaniiro lowono ana guruNo ka mongee, “Memeꞌura komiuto henu mekarampini, akono ikomiuto bawaa la poparentano Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Memeꞌura komiuto henu lenie mokoninggo, akono ikomiu ungga nggale pinokomowoto. Memeꞌura komiuto henu lenie mebaꞌie, akono ikomiu ungga nggale mototao.” ");
INSERT INTO mzq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Memeꞌura komiuto, taꞌalu mia alieꞌakomiu, kano tarima komiu, peꞌuru-uru komiu ka tumata komiu akono ikomiu tumondario Ana Manusia. ");
INSERT INTO mzq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mensanaa ka memawongko komiuto tempono mia mewowau komiu liraꞌa, akono saromu langkai i suruga. Ka liraꞌa mboꞌu mia mosuꞌoro asompihe mowowau henu mosaꞌa la nabi-nabi asompihe. ");
INSERT INTO mzq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kanggo wainto komiupo suꞌu henu lenie mensugi, akono imentarimaꞌoto lowono sanaamiu i laro sugimiu lenie. ");
INSERT INTO mzq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wainto komiupo suꞌu, henu lenie mowoto, akono ikomiu nggale mokoninggo. Wainto komiupo suꞌu, henu lenie mototao, akono ikomiu nggale masusa ka mebaꞌie. ");
INSERT INTO mzq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wainto komiupo suꞌu, taꞌalu lowono mia umunde-unde komiu, akono liraꞌa mboꞌu nabi-nabi henu kano mentee asompihe inunde-unde heleo raaꞌa mia mosuꞌono mia henu lenie umunde-unde komiu.” ");
INSERT INTO mzq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kanggo ikomiu henu mehoringaKune, Kupauꞌakomiu, impehohawaꞌo uwelimiu. Impowowauto meꞌambo la mia henu meꞌalieꞌakomiu. ");
INSERT INTO mzq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pomonito ndi Ue Ala kano Iwono moweiꞌakeo ura la mia henu tumando komiu. Pekakaiꞌakeo mia henu mosaꞌa gauno ndi iiko. ");
INSERT INTO mzq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Taꞌalu hina mia tumampeleꞌo kombisimu asonimbi, pewengakeo mboꞌu kombisimu henu asonimbino. Ka taꞌalu hina mia umaleo lemba mentaamu, pewengakeo mboꞌu lembamu henu mesueno. ");
INSERT INTO mzq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Isia tokoa henu momoni ndi iiko weiꞌakeoto, ka taꞌalu hina henu moꞌalo arapio-piomu, hooto pomonio mekule. ");
INSERT INTO mzq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Opio henu inehemu mia no powowau ndi iiko, wowauꞌo mboꞌu la mia mesue. ");
INSERT INTO mzq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Taꞌalu ikomiu butukoa mowowau pompehohawa la mpokowalimu henu mehohawako, hooto pomperorohi mongee Ue Ala nggale barakatiko akono pompehohawamu seea, akono mia tehala mboꞌu mehohawaꞌo mia mehohawaꞌiro. ");
INSERT INTO mzq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Taꞌalu ikomiu mowowau meꞌambo la mia henu mowowau meꞌambo ndi ikomiu, hooto pomperorohi mongee Ue Ala nggale barakatiko akono mia tehala mowowau liraꞌa mboꞌu. ");
INSERT INTO mzq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Taꞌalu ikomiu mompesaboꞌako doi la mia, ka komiu momperorohi pokuleno, hooto pomperorohi mongee Ue Ala nggale barakatiko. Akono mia tehala mboꞌu mompesaboꞌako doiro la mia henu tehala kano iworo tumarimaꞌo mekule menggena adiono. ");
INSERT INTO mzq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kanggo, ikomiu asolekono mehohawaꞌo uwelimu ka powowau meꞌambo ndi iworo. Ponsaboꞌakeoto arapiomu la mia, ka hooto ponsikori pokuleno. Taꞌalu lesie impowowau, langkai saromiu ka hoꞌioto gaumiu mompokiteo koroimiu gagi anaro Ue Ala henu i Wawono Takau. Akono Ue Ala meꞌambo aroa la mia henu tai tumoꞌorio tarimakasi ka la mia mosaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ikomiu asolekono meꞌaroa heleo Umamu i suruga meꞌaroa.” ");
INSERT INTO mzq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Hooto impopokosala, kaindono Ro pokonsala komiu Ue Ala. Hooto impohuku mia, kaindono nohuku komiu Ue Ala. Ikomiu asolekono moꞌampuni mia, kano ikomiu inampuni. ");
INSERT INTO mzq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Poweiꞌakeo, kano ikomiu mboꞌu pinoweiꞌako Ue Ala adio takau. Pompoweiro Ue Ala henu adio takau ndi ikomiu raaꞌa, bisa pinokomenggena saru inuse henu sinaꞌu mompake ponsaꞌu henu mentee. Inuse raaꞌa inihii la ponsaꞌu raaꞌa ranta memunsu ka rinonso ranta modato, kanoamba tinambai mboꞌu ranta tesosala. Akono ponsaꞌu henu pinakemiu la mia mesue, hoꞌio mboꞌu henu Ue Ala pakeꞌo ndi ikomiu.” ");
INSERT INTO mzq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu mongee mboꞌu ndi iworo aso ande-ande mpau lenie, “Kano bisa mia morawu montaate mia morawu, akono oruo mia raaꞌa matantu tedontai la pareki. ");
INSERT INTO mzq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kano hina aso ana guru lumalumio guruno. Kanggo taꞌalu iwono umarioto mepaguru, iwono nggale menggena heleo guruno. ");
INSERT INTO mzq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tembio kau kiteo mopuli la matano petiamu, kanggo tompa kau i laro matamu liomu kau kiteo? ");
INSERT INTO mzq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ehende kau bisa mepau la petiamu, ‘Petia, maito ku oninio mopuli la matamu,’ Kanggo tompa kau i laro matamu kau kiteo? Hei, mia henu mompeꞌende-ende meꞌambo. Luarakeoto ari tompa kau i laro matamu, kau penggito takau ka kau bisa koa umoninio mopuli i laro matano petiamu.” ");
INSERT INTO mzq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kano hina puꞌu kau henu meꞌambo, moluarako wue henu mosaꞌa. Liraꞌa koamboꞌu, kano hina puꞌu kau henu mosaꞌa, moluarako wue henu meꞌambo. ");
INSERT INTO mzq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Akono lowono puꞌu kau tinoꞌori teꞌembu la wueno. Wue ara kano inopu teꞌembu la puꞌuno rui, ka kano hina wueno anggoro inopu teꞌembu laro rui. ");
INSERT INTO mzq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mia henu meꞌambo, moluarako henu meꞌambo teꞌembu la ihi aroano henu meꞌambo, ka mia henu mosaꞌa moluarako henu mosaꞌa teꞌembu i laro aroano henu mosaꞌa. Akono opio henu pinauno meluarako teꞌembu i laro aroano.” ");
INSERT INTO mzq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Tembio ikomiu pebooli ndi Iaku, ‘Ue, Ue’, kanggo ikomiu kano mpowowau opio henu pinauNggu? ");
INSERT INTO mzq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kunggale pauꞌakomiu, heleo pio penggenano lowono mia henu mehawe ndi Iaku, mehoringakeo henu pinauNggu ka wowauꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iworo raaꞌa menggena saru mia henu mowangu doha. Iwono mongkeke wute teꞌonalo ka mowowau pundasi wasu. Umari raaꞌa haweoto mowo rumumpaꞌo doha raaꞌa. Kanggo, mowo raaꞌa kano bisa humokao doha raaꞌa, akono doha raaꞌa moroso pundasino. ");
INSERT INTO mzq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kanggo araisia henu mehoringo pauNggu ka kano wowauꞌo, iwono raaꞌa menggena heleo mia mowangu doha henu kano hina pundasino. Menseno hawe mowo, doha raaꞌa tehoka ka mawata masolano.” ");
INSERT INTO mzq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Umarino Iesu mepau la mia adio, Iwono lumeko i waawute Kapernau. ");
INSERT INTO mzq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rahea hina aso petewawo sorodadu Roma henu hina aso mia atano henu takau no pehohawaꞌo. Atano raaꞌa tekonai mahaki meꞌisei ka minggi mate. ");
INSERT INTO mzq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Menseno ponggawa sorodadu humoringo mongkono Iesu, no tenaꞌiroto popioꞌiro mia-mia mosuꞌoro to Iahudi lumeko ndi Iesu momoni kano Iesu mai mokotompaꞌo atano henu mahaki raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lumekoiroto henu tinena hieno ndi Iesu, ro pomonio takau ka mongee, “Ponggawa sorodadu raaꞌa pototonokoa Itulungio, ");
INSERT INTO mzq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","akono No pehohawa kito to Iahudi, ka iwono tumanggumio powangua doha pesombaꞌa mami.” ");
INSERT INTO mzq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Umari raaꞌa, Iesu lumeko merongairo. Mensero meꞌorambi la dohano petewawo sorodadu raaꞌa, ponggawa sorodadu raaꞌa montena popioꞌiro pokowalino lumeko pauꞌakero Iesu, “Uma, hooto pokomasusaꞌo koroiMiu mai i dohanggu, akono iaku kano pototono tumarima Komiu i dohanggu. ");
INSERT INTO mzq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iaku mboꞌu kano pototono mai ndi Ikomiu. Pepau tokoa teꞌaso oruo mpali pau, atanggu raaꞌa konokoa tompa. ");
INSERT INTO mzq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Akono kupeꞌale-aleo iwono konokoa tompa. Akono iaku neea mia henu tinena mboꞌu ka hina mboꞌu sorodadu henu kutenaꞌo. Taꞌalu iaku montena aso mia sorodadunggu, ‘Lekoto!’ Lumekooto suꞌu. Taꞌalu iaku mboꞌu mongee laꞌaso mia henu mesue, ‘Maitoto!’ Iwono mai suꞌu. Ka taꞌalu montena aso mia atanggu, ‘Anggaꞌo neea!’ No anggaꞌo koa suꞌu.” ");
INSERT INTO mzq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Humoringo pau raaꞌa, takau kombaa Iesu ka mewalili la mia adio henu tumondaꞌIro ka mongee, “Kupauꞌakomiu, pompeꞌalo-alo henu langkai heleo neea amboKu hori mongkonai maupo la to Isaraeli.” ");
INSERT INTO mzq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Menseno iworo henu tinena raaꞌa mekule la dohano ponggawa sorodadu, ro mengkiteo atano raaꞌa tompaoto. ");
INSERT INTO mzq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kano epie teꞌembu rahea, lumekooto Iesu laꞌaso waawute henu mengeengako Nai. Ana guruRo ka mia adio tumondaꞌIro. ");
INSERT INTO mzq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Menseno Iesu orambiakeo panganso pendamoha i inie raaꞌa, hina aso mia ana monguro henu mate linembara meluarako teꞌembu i inie raaꞌa leko kinaburu. Ana monguro raaꞌa ana aso-asono, ka ineno henu tuwu erowai. Adio mia teꞌembu i inie raaꞌa mokowalio tuwu erowai raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Menseno Iesu kumiteo tuwu erowai raaꞌa, No mokokounduakeo tuwu erowai raaꞌa ka mongee, “Ine, hooto baꞌie.” ");
INSERT INTO mzq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kanoamba Iesu orambiakeo lembara raaꞌa ka numangkiho lembara raaꞌa ranta mia henu polembara raꞌiroa menao-nao. Umari raaꞌa Iesu mepau la mia mate raaꞌa, “O ana monguro, Iaku mepauꞌakomu, pewanguto!” ");
INSERT INTO mzq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mewanguoto mia raaꞌa, metunda ka mompamulaoto mepau. Kanoamba Iesu weiꞌakeo ineno. ");
INSERT INTO mzq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mengkiteo henu gagi raaꞌa, lowono mia henu hina rahea medoito ka ro meꞌunde-undeꞌiro Ue Ala. Ro mpongee, “Haweoto aso nabi langkai hawe i olondo,” ka iworo mepau mboꞌu, “Haweoto Ue Ala tumulungio bawaaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Umari raaꞌa tepaleleoto kareba mongkono Iesu i waawute Iudea ka la lowono inie henu tepoꞌorambino. ");
INSERT INTO mzq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tempono Iohane to pobaho i laro tarungku, ana guruno mepauꞌakeo lowono henu No wowauꞌo Iesu. Umari raaꞌa Iohane mompoboi oruo ana guruno, ");
INSERT INTO mzq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ka tumenaꞌiro lumeko ndi Iesu mesikeno ndi Iwono lenie, “Ikomiuke Mokole Pongkadudui Henu Dinandiro Ue Ala teꞌembu asompihe, ara ikami monsikori mia mesue?” ");
INSERT INTO mzq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Menseno ana guruno Iohane henu oruo raaꞌa hawe ndi Iesu, mongeeiroto, “Iohane to pobaho tumena kami mesikeno ndi Ikomiu, ‘Ikomiuke Mokole Pongkadudui Henu Dinandiro Ue Ala teꞌembu asompihe, ara ikami nggale monsikori mia mesue?’” ");
INSERT INTO mzq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tempo raaꞌa Iesu mompokotompa adio mia teꞌembu la manggerupa hakiro ka monsaari adio penao mosaꞌa henu mompewunsoki mia. Ka adio koamboꞌu mia morawu pinokotompaNo ranta karo gagi mpenggito. ");
INSERT INTO mzq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Gagi, Iesu sumangki la ana guruno Iohane, “Impekuleto ka pauꞌakeo Iohane pio henu kinitomu ka pio henu hinorimu: Mia henu morawu menggito, mia henu pungku koleko-leko, mia henu mahaki melowe gagi tompa, mia henu mobongo gagi mohori, mia henu mate gagi tuwu mekule ka la mia henu mokokolaro pinaleleꞌako Kareba Meꞌambo. ");
INSERT INTO mzq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Meꞌuraoto suꞌu mia henu moroso pompeꞌalo-alono ndi Iaku ka tai humapu Aku.” ");
INSERT INTO mzq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Menseno henu tinenano Iohane raaꞌa mekule, mepauꞌoto Iesu mongkono Iohane la mia adio lenie, “Opio henu imelekoako mompekokaani la pada one? Mompekokaani kure henu linelusino angi ehempano eheramai? Matantu Aio. ");
INSERT INTO mzq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Gagi, opio henu leko pinekokaanimiu ndepano? Ikomiu lumeko mompekokaani mia henu meparewa henu masuli? Aio koamboꞌu. Akono mia henu meparewa masuli ka tuwu mareꞌe, moꞌia i dohano mokole. ");
INSERT INTO mzq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gagi pio tuduno kai meleko ndepano? Mompekaani nabi? Taꞌalu lesie, mentee komiuto. Kanggo Iaku mepau ndi ikomiu, Iohane raaꞌa i wawonopo kasikono nabi. ");
INSERT INTO mzq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Akono mongkono Iohane hina teꞌuki la Wunta Mempori lenie, ‘Kiteo, Iaku tumenaꞌo tinenaNggu teleꞌeruakoMu, iwono nggale mompasadia ansala henu nggale teliuꞌaMu.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iaku pauꞌakomiu, “Lowono henu pineꞌanaꞌakono erowai i wawontolino neea, i aroro Ue Ala kano hina henu mantuduopo ka Iohane to pobaho. Kanggo mia henu tai mantudu lahi i laro Poparentaro Ue Ala, iwono mantuduopo ka Iohane.” ");
INSERT INTO mzq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lowono mia henu hina rahea saru to ponsinga sima henu humoringo pauno Iesu, pokomenteeꞌo Ue Ala, akono ro pewengakeo koroiro no bahoꞌiro Iohane. ");
INSERT INTO mzq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kanggo to Parisi ka mia mpande atora Taura karo tai mentarimaꞌo poꞌehero Ue Ala ndi iworo, akono iworo karo mempoli no bahoꞌiro Iohane. ");
INSERT INTO mzq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu mongee, “Heleo pioke Kuponggenaꞌakeo mia henu tuwu lenie? ");
INSERT INTO mzq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iworo raaꞌa menggena heleo ana-ana henu metunda i pasa ka singge mepau aso mia ka aso mia lenie. ‘Ikami mompuuri silolu ndi ikomiu, kano ikomiu sanaa, kanggo ikomiu kai penari, ikami menani nani matea, kano ikomiu masusa, kanggo kai tai mebaꞌie.’ ");
INSERT INTO mzq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Liraꞌa mboꞌu Iohane to pobaho hawe, iwono kano ponggaa roti ara moꞌenu anggoro, ikomiu mongee, ‘Iwono nopewunsokio onisu.’ ");
INSERT INTO mzq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kanggo Ana Manusia hawe, Iwono monggaa ka moꞌenu, ikomiu mongee, ‘Kiteo! Mia neea ponggaaNo adio ka poꞌenuNo adio. Iwono mesambeꞌeakero to ponsinga sima ka mia tehala.’ ");
INSERT INTO mzq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kanggo pandeꞌaro Ue Ala bisa mboꞌu kinito teꞌembu la powowauno mia henu tumarimaꞌo pandeꞌaro Ue Ala raaꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Aso to Parisi henu mengeengako i Simo umundaꞌo Iesu mai i dohano monggaa saru iwono. Gagi, Iesu lumeko i dohano to Parisi raaꞌa, ka monggaa meronga-ronga. ");
INSERT INTO mzq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hina aso erowai henu tuwu i laro hala moꞌia i inie raaꞌa. Menseno erowai raaꞌa humoringo mongee Iesu tekonai monggaa i dohano to Parisi raaꞌa, iwono mowawo aso botoro henu winowau teꞌembu la wasu henu ngineengako puala, bukeako boka mana meꞌambo. ");
INSERT INTO mzq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iwono mentada i bungkuno Iesu orambi la kareNo kongko baꞌie ka uwoi matano teꞌiti la kareno Iesu, no paꞌisio saru wuuno. Kanoamba no wowoongo kareno Iesu ka humahiꞌakeo saru boka mana meꞌambo raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tempono kumiteo opio henu winowauno erowai raaꞌa, to Parisi henu umundaꞌo Iesu raaꞌa mepau i laro aroano, “Taꞌalu mia neea aso nabi, matantu No toꞌorio erowai henu numangkiho raaꞌa. Akono erowai raaꞌa tuwu i laro hala.” ");
INSERT INTO mzq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kanggo Iesu mepau ndi iwono, “Simo, hina aso rupa henu minggi Kupauꞌakomu.” Sumangki i Simo, “Pauꞌakuneto, Guru.” ");
INSERT INTO mzq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu mongee, “Hina oruo mia henu mepasua laꞌaso mia henu mompesaboꞌako doi. Aso mia mepasua lima etu pera, ka henu aso mia lima mpulo doi pera. ");
INSERT INTO mzq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akono iworo andoro mentuꞌaiꞌo baraꞌo, hoꞌioto mia henu mompesaboꞌako doino raaꞌa no paꞌisiakero pasuaro. Taꞌalu lesie, isiake henu takau langkai pompehohawano la mia henu mompesaboꞌako doino raaꞌa?” ");
INSERT INTO mzq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sumangki i Simo, “Pontaserenggu, mia henu adio pasuano.” Iesu mongee, “Mentee pohawemu seea.” ");
INSERT INTO mzq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kanoamba Iesu mewalili la erowai raaꞌa, ka mepau ndi Simo, “Kiteo opio henu winowauno erowai neea. Iaku mendamo i laro dohamu, kau pompasadiaꞌakune uwoi Kupakeꞌo woꞌohio kareNggu. Kanggo erowai neea wahaꞌo kareNggu saru uwoi matano ka paisiakeo wuuno. ");
INSERT INTO mzq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Iaku hawe i dohamu, kau wowoongaNggu. Kanggo erowai neea mompamula Kuhawe endea, iwono kano penao-nao wowoongo kareNggu. ");
INSERT INTO mzq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Iiko kau bokaꞌo uluNggu saru boka henu mana meꞌambo, kanggo erowai neea no bokaꞌo kareNggu saru boka henu mana meꞌambo. ");
INSERT INTO mzq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gagi Kupauꞌakomu, pompehohawano henu adio ndi Iaku mopokiteo taꞌalu halano henu adio inampunioto. Kanggo mia henu inampuni teꞌesi, teꞌesi mboꞌu pompehohawano.” ");
INSERT INTO mzq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kanoamba Iesu mongee la erowai raaꞌa, “Halamu inampunioto.” ");
INSERT INTO mzq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ka mia henu monggaa saru Iwono mepau i laro aroaro, “Kano mentee mia neea. Tembio Iwono mepau, Iwono bisa moꞌampuni hala.” ");
INSERT INTO mzq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kanggo Iesu mepau la erowai raaꞌa, “Pompeꞌalo-alomu kumaduduiko. Pekuleto tesanaa aroamu.” ");
INSERT INTO mzq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kano epie teꞌembu rahea, Iesu lumeko mebolili la adio waawute mompalele Kareba Meꞌambo taꞌalu mompamulaoto Ue Ala momparenta i wawontolino neea. Kohopulo ka oruo ana guruNo meronga-ronga saru Iwono. ");
INSERT INTO mzq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Liraꞌa koamboꞌu popioꞌiro erowai henu umarioto pinokotompa teꞌembu la penao mosaꞌa ka teꞌembu la hakiro. Iworo raaꞌa, iwonoto Maria henu ngineengako i Magdalena henu teꞌembu la koroino, Iesu monsaari opisu penao mosaꞌa, ");
INSERT INTO mzq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Iohana walino i Kusa. I Kusa raaꞌa petewawono lowono mia henu moꞌangga ndi mokole Herode, i Susana ka adio mboꞌu erowai henu mesue. Lowono erowai raaꞌa mompokowali la anggaꞌano Iesu ka ana guruNo, saru opio henu hina ndi iworo. ");
INSERT INTO mzq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Aso tempo adio mia teꞌembu la waawute hawe tepotowoꞌakeo Iesu. Menseno mia adio raaꞌa tepumpu, Iesu mompau aso ande-ande mpau ndi iworo lenie, ");
INSERT INTO mzq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hina aso mia puꞌu porawo lumeko morawo wuku pahoꞌano. Tempono morawo, waali wuku pahoꞌano raaꞌa tedontai la wiwi ansala, ranta melolaꞌango mia ka sui-sui mengkaango ranta kano pinggo. ");
INSERT INTO mzq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waali tedontai la wawono wute henu melaro wasu, ka menseno tuwu kano epie no tuwu mosuꞌioto, akono kano pohawe uwoi. ");
INSERT INTO mzq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waali tedontai la wute henu melaro rui. Menseno tuwu, wuku pahoꞌa raaꞌa tuwu merongaakeo rui raaꞌa, ka laro rui raaꞌa no asiꞌo pinopaho raaꞌa ranta kano mate. ");
INSERT INTO mzq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ka waali mboꞌu tedontai la wute henu monuwo. Wuku pahoꞌa raaꞌa tuwu meꞌambo ranta mewue meluka aso etu.” Umarino Iesu mompau ande-ande mpau raaꞌa, Iwono mepau ndi iworo, “Araisia henu hina birino, pehoringakeo temeꞌambo opio henu pinauNggu neea.” ");
INSERT INTO mzq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Humoringo raaꞌa, mesikenooto ana guruNo pio pengkonoano ande-ande mpau raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iesu sumangkiiro, “Ikomiu pinoweiꞌakoto mpande teꞌembu la Ue Ala kai mentoꞌorio mantii henu tewuni mongkono Ue Ala momparenta. Kanggo mongkono henu tewuni raaꞌa pinopotoꞌoriako la mia mesue la ande-ande mpau. Taꞌalu liraꞌa, maupo ro mengkiteo karo mentoꞌorio opio henu gagi, maupo ro mehoringo karo mentoꞌorio.” ");
INSERT INTO mzq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Lenie pengkonoano ande-ande mpau raaꞌa. Wuku pahoꞌa raaꞌa iwonoto pauro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Henu tedontai la wiwi ansala raaꞌa, menggena heleo pauro Ue Ala henu ro mehoringo mia, kanggo Mokole Onisu hawe umaleo pauro Ue Ala raaꞌa teꞌembu la pinewowoloro kano hooto ro pompeꞌalo-alo ka kinadudui. ");
INSERT INTO mzq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Henu tedontai la wute melaro wasu raaꞌa, menggena heleo pauro Ue Ala henu ro mehoringo mia, ro mentarimaꞌo mawongko aroa. Kanggo karo pehaka ka pompeꞌalo-aloro sarai koa. Menseno hawe poꞌara-arahako, iworo mobintao pompeꞌalo-aloro. ");
INSERT INTO mzq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Henu tedontai laro rui, menggena heleo pauro Ue Ala henu ro mehoringo mia, kanggo koꞌepi-epieno iworo salalaro mongkono tuwuꞌa, sugi ka sanaa i wawontolino neea. Hoꞌioto puꞌuno karo tai mpohaweꞌako wue henu motaha. ");
INSERT INTO mzq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Henu tedontai la wute henu monuwo, menggena heleo pauro Ue Ala henu ro mehoringo mia saru aroa meꞌambo, ka ro kongko metenunu i laro pompeꞌalo-aloro, ranta karo mpoluarako winowau henu meꞌambo.” ");
INSERT INTO mzq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iesu mepau mboꞌu, “Kano hina mia henu mompolanga palita kanoamba pupusiakeo gumba ka numaaꞌo la totono poturia. Kanggo asolekono no naaꞌo la poꞌiangano laano, kano mia henu hawe i laro doha raaꞌa mengkiteo wantano. ");
INSERT INTO mzq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Akono lowono henu pinupusi nggale inungkahi, ka lowono henu tewuni nggale pinopotoꞌori. ");
INSERT INTO mzq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hoꞌioto puꞌuno, pewowoloꞌo araꞌehende ikomiu mompehoringako pauro Ue Ala, akono araisia henu montarima pauRo Ue Ala, Ue Ala nggale tumambaiꞌo pio henu ro mentoꞌorio. Kanggo araisia henu kano poli montarima pauro Ue Ala, maupo pio henu ro rekeꞌo tumoꞌorio asolekono Ue Ala umaleo mekule teꞌembu ndi iworo.” ");
INSERT INTO mzq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tempono Iesu mompaguru, ineNo ka petiaNo hawe ndi Iwono. Kanggo iworo karo bisa orambiakeo akono adio mia mepumpu meboliliꞌo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hina aso mia henu mai pauꞌakeo Iesu, “Uma, ineMu ka petia-petiaMu raheaꞌiro i bungkuno, iworo minggi tepohaweꞌakoMiu.” ");
INSERT INTO mzq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Humoringo raaꞌa, Iesu sumangkiiro, “Henu humoringo ka wowauꞌo pauro Ue Ala, iworoto ineNggu ka petiaNggu.” ");
INSERT INTO mzq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aso tempo Iesu meꞌula laꞌaso bangka saru ana guruNo, ka Iwono mepau ndi iworo, “Maito, kato mensumomba i asontonano rano.” Gagi melekoiroto. ");
INSERT INTO mzq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tekonairo mensumomba, Iesu tekoturi. Bingkosako mepuuri angi meroku i tonga rano raaꞌa ranta bangkaro no mpewunsokio uwoi ka minggi tondu. ");
INSERT INTO mzq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mengkiteo raaꞌa, ana guruNo lumeko wanguꞌo Iesu, ro mpongee, “Guru! Guru! Mate kitoto!” Iesu mewangu ka kumuahakeo angi ka pue raaꞌa. Tempo koa raaꞌa mboꞌu angi ka pue raaꞌa temonto. Angi andono pepuuri mboꞌu ka rano raaꞌa gagi rodo. ");
INSERT INTO mzq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Umarino raaꞌa Iesu mepau la ana guruNo, “Tembio kai tai mompeꞌalo-alo ndi Iaku?” Medoito ka kombaa takau lowono ana guruNo ka mepau aso mia ka aso mia, “Isiake menteeꞌano mia neea ranta angi ka uwoi metenunu ndi Iwono?” ");
INSERT INTO mzq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ambono epie teꞌembu rahea, haweoto Iesu ka ana guruNo i waawute Gerasa henu i asontonano rano Galilea. ");
INSERT INTO mzq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Menseno Iesu metii teꞌembu la bangka lumeko i waawute, aso tama henu pinewunsokino penao mosaꞌa mai teꞌembu la inie raaꞌa tepotowoꞌakeo. Epieꞌoto mia raaꞌa kano peparewa ka iwono andono poꞌia i doha, kanggo iwono moꞌia i kaburu. ");
INSERT INTO mzq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tempono no kiteo Iesu, iwono koꞌora-ora ka menggoluntu i arono Iesu ka mepau mokora, “Iesu anaro Ue Ala henu i wawono takau, pio tinunggaiMu ndi iaku? Hooto wainto pokomasusaꞌaku!” ");
INSERT INTO mzq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iwono mepau liraꞌa, akono Iesu parentaꞌo penao mosaꞌa raaꞌa meluarako teꞌembu la mia raaꞌa. Akono menggoꞌadioto penao mosaꞌa raaꞌa mewunsokio mia raaꞌa, ranta mia raaꞌa ginagai mpihe, inonggoꞌako rante ka pinongu. Kanggo no biteho mpihe rante raaꞌa, ka penao mosaꞌa raaꞌa no waweo lumeko la pada one. ");
INSERT INTO mzq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ka Iesu mesikeno ndi iwono, “Isiake ngeemu?” Iwono sumangki, “Legio.” Iwono mepau liraꞌa akono adio penao mosaꞌa mewunsokio. ");
INSERT INTO mzq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Umarino raaꞌa penao mosaꞌa raaꞌa momonio ndi Iesu kano iworo hooto pinarenta lumeko i wingke matea. ");
INSERT INTO mzq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kano olai teꞌembu rahea, adio takau boe henu tekonai mpowusu kaangaro i korimbino toruku. Penao mosaꞌa raꞌiroa momoni ndi Iesu kano iworo ineheako mewunsokiiro boe raꞌiroa. Iesu uminduꞌakero pomoniro. ");
INSERT INTO mzq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kanoamba, mpeluarakoiroto penao mosaꞌa raꞌiroa teꞌembu la mia raaꞌa ka lumeko mewunsokiiro boe raꞌiroa. Kanoamba boe raꞌiroa mperipo ka medontaihako teꞌembu la korimbino toruku tii la rano ranta karo memate tondu lowo. ");
INSERT INTO mzq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tempono popioꞌiro mia henu mpogagai boe raꞌiroa mengkiteo pio henu gagi, iworo mperipo ka mempopauꞌo henu gagi raaꞌa la mia i iniero ka i inie henu tepoꞌorambiro. ");
INSERT INTO mzq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Humoringo raaꞌa, mia raꞌiroa teꞌembu i waawute ka ini-inie henu orambi rahea mpeluarako nggale kumiteo opio henu gagi raaꞌa. Mensero mehawe ndi Iesu, iworo mengkiteo mia henu pinewunsokino penao mosaꞌa raaꞌa metunda orambi la ngkareNo Iesu, iwono meparewaoto ka pinewowolono meꞌambooto. Kumiteo raaꞌa, iworo lowo tedoa medoito. ");
INSERT INTO mzq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mia henu mengkiteo lioro pio henu gagi, mepauꞌakero mia henu amba hawe, araꞌehende mia pinewunsokino penao mosaꞌa raaꞌa pinokotompa. ");
INSERT INTO mzq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ka lowono mia i Gerasa momoni kano Iesu mobintairo, akono iworo tedoa medoito. Umarino raaꞌa Iesu mewueꞌako la bangka ka mpekule. ");
INSERT INTO mzq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mia henu binintano penao mosaꞌa raaꞌa momoni ndi Iesu kano ineheako koa tumondaꞌo Iesu. Kanggo Iesu tumenaꞌo mekule, No pongee, ");
INSERT INTO mzq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pekuleto i dohamu ka tutuluꞌoto lowono henu winowauro Ue Ala ndi iiko.” Lumekooto mia raaꞌa mebolili la lowono inie ka paleleꞌo lowoakoano henu winowauno Iesu la ngkoroino. ");
INSERT INTO mzq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tempono Iesu mekule i asontonano rano, Iwono ro mentotowoꞌo saru aroa mawongko, akono Iwono ro mensikorio. ");
INSERT INTO mzq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tempo koa raaꞌa mboꞌu hawe aso mia henu mengeengako Iaeru, henu puꞌu petewawo i doha pesombaꞌa to Iahudi. Iaeru menggoluntu i kareNo Iesu momoni kano Iesu mai la dohano. ");
INSERT INTO mzq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Akono, anano henu aso-asono teꞌaso tokoa no penao, minggi mate. Anano raaꞌa erowai, tuwuno tinasere hopulo ka oruo ntaꞌu. Tempono Iesu la ngkoleko-lekoꞌa lumeko i dohano Iaeru, mia adio pedudumpali koleko-leko orambiakeo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","I olono mia henu pedudumpali raꞌiroa hina aso erowai henu hopulo ka oruo ntaꞌuto ntepipihe no mahaki korea-rea. Lowono aga-agano pinggo no pakeꞌo mobara dotoro, kanggo kano hina teꞌaso mia bisa mokotompaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Erowai raaꞌa orambiakeo Iesu teꞌembu i bungkuNo, no inio tompano lembano ka bingkosako tompaoto hakino. ");
INSERT INTO mzq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tempo raaꞌa mesikeno Iesu, “Isia numangkihaKu?” Lowono mia mehapu. I Peturu mepau, “Guru, adio mia henu mpehowu ka pedudumpali orambiakoMiu.” ");
INSERT INTO mzq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kanggo Iesu mepau, “Hina aso mia henu numangkihaKu, akono Kurasaꞌo hina pobawa henu meluarako teꞌembu la koroiNggu.” ");
INSERT INTO mzq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tempono erowai raaꞌa kumiteo mongee pio henu winowauno raaꞌa kano bisa mewuniakeo, iwono mai mondidi-ndidi menggoluntu i arono Iesu. Iwono tumutuluꞌakero mia adio raaꞌa tembio kano nangkiho tompano lembano Iesu, ka tempono no inio tompano lembano Iesu bingkosako tompaoto hakino. ");
INSERT INTO mzq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Umarino raaꞌa Iesu mepau la erowai raaꞌa, “O anaNggu, iiko tompa akono iiko mompeꞌalo-alo ndi Iaku. Pekuleto tesanaa aroamu.” ");
INSERT INTO mzq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tempono Iesu da mepau, haweoto aso mia teꞌembu i dohano Iaeru, mepau ndi Iaeru lenie, “Anamu mateoto. Hooto mboꞌu pokomasusaꞌo Guru.” ");
INSERT INTO mzq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tempono Iesu humoringo pau raaꞌa, Iwono mepau ndi Iaeru, “Hooto doito, pompeꞌalo-alo tokoa ndi Iaku. Anamu olokoa tekadudui.” ");
INSERT INTO mzq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Temporo mehawe i dohano Iaeru, kano hina teꞌaso mia tokoa henu No eheakeo Iesu mendamo. Butu i Peturu, Iohane, Iakobu, umano ana raaꞌa ka ineno mboꞌu henu No eheakeo Iesu mendamo. ");
INSERT INTO mzq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lowono mia rahea mebaꞌie ka meꞌau-auꞌo ana-ana raaꞌa. Kanggo Iesu mepau, “Hooto imebaꞌie, ana-ana neea kano mate, butukoa moturi.” ");
INSERT INTO mzq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iworo mpototahio Iesu, akono ro mentoꞌorio suꞌu mongee ana-ana raaꞌa mateoto. ");
INSERT INTO mzq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kanoamba Iesu uminiꞌo kaeno ana-ana raaꞌa ka mepau, “Ana, pewanguto.” ");
INSERT INTO mzq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mekuleoto penaono ana-ana raaꞌa, ka tempo koa raaꞌa mboꞌu iwono mewangu ka mentada. Umarino raaꞌa Iesu tumenaꞌiro moweiꞌakeo kaanga ana-ana raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kumiteo raaꞌa, mia mosuꞌono ana-ana raaꞌa kombaa takau. Kanggo Iesu umontoiro kaindoro pauꞌo maupo ndi isia tokoa pio henu gagi raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu mompoboi hopulo ka oruo ana guruNo ka moweiꞌakero roso ka pobawa kano iworo bisa monsaari lowono penao mosaꞌa henu mompewunsoki mia ka mompokotompa haki. ");
INSERT INTO mzq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kanoamba Iwono tumenaꞌiro lumeko mompalele araꞌehende Ue Ala momparenta ka lumeko mompokotompa mia mahaki. ");
INSERT INTO mzq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iesu mepau ndi iworo, “Hooto impowawo pio-pio la ngkoleko-lekoaꞌmiu. Hooto powawo tuko ara pebaku, roti ara doi, ara oruo nangge lemba. ");
INSERT INTO mzq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Inderio doha henu tumarima komiu, impoꞌiato rahea ranta kai meleko teꞌembu i inie raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Taꞌalu hina mia henu tai tumarima komiu, pobintao inie raaꞌa, tantamio pampawu la ngkaremiu kano gagi tondoni ndi iworo taꞌalu iworo nggale no hukuꞌiro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Umari raaꞌa melekoiroto la ini-inie, mompalele Kareba Meꞌambo ka mompokotompa mia mahaki inderio tokoa ro meleko. ");
INSERT INTO mzq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tempono i Herode mokole i Galilea humoringo lowono henu gagi raaꞌa, iwono gagi dungku akono popioꞌiro mia mempauꞌo taꞌalu Iohane to pobaho pinotuwu mekule teꞌembu la matea. ");
INSERT INTO mzq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hina mboꞌu mia henu mongee, i Elia haweoto mekule. Mia mesue mboꞌu mongee, taꞌalu aso nabi teꞌembu asompihe tuwu mekule. ");
INSERT INTO mzq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kanggo i Herode mongee, “Uluno Iohane kupoleiꞌoto. Isiake menteeꞌano Mia henu kuhoringo mowowau lowono raaꞌa?” Gagi, i Herode meꞌusaha kano bisa koa no tepohaweꞌakeo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pekulero ana guru raꞌiroa, iworo tumutuluꞌakero Iesu lowono arapio henu umarioto ro meꞌanggaꞌo. Umarino raaꞌa, Iesu waweiro lumeko tekasi orambi laꞌaso waawute henu mengeengako Betsaida. ");
INSERT INTO mzq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kanggo mia adio raaꞌa tumoꞌorio poꞌianga lekoꞌaro ka iworo mentondariiro. Tempono mia adio raaꞌa mehawe, Iesu tumotowoꞌiro ka paguruꞌiro araꞌehende Ue Ala momparenta bawaaNo. Iesu mboꞌu mompokotompaꞌiro henu memahaki. ");
INSERT INTO mzq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tempono oleo mompuꞌu soo, mehaweiroto hopulo ka oruo ana guruno Iesu ka mongee, “Tenaꞌiroto mia adio raꞌiroa meleko la ini-inie henu orambi teꞌembu endea, karo iworo mpowusu poꞌianga peratoꞌaro ka kangaaro, akono ikito neea la mpoꞌianga henu molimbo.” ");
INSERT INTO mzq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kanggo Iesu mepau ndi iworo, “Ikomiu henu asolekono mempakairo.” Iworo mesangki, “Henu hina ndi ikami, butukoa olimo roti ka oruo koa bou. Gagi, ikami asolekono meleko mpoꞌoli kaanga tiaro lowono mia neeroa?” ");
INSERT INTO mzq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iworo mepau liraꞌa, akono rahea hina olimo sowu mia tama henu pepumpu. Kanoamba Iesu pongeeꞌakero la ana guruNo, “Tenaꞌiroto mia adio raꞌiroa mpetunda pepoko-pokosi, aso ntia limo mpulo mia.” ");
INSERT INTO mzq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ana guruNo mewowauꞌo heleo henu No tenaꞌakero ka tumenaꞌiro lowono mia adio raꞌiroa mpetunda. ");
INSERT INTO mzq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Umarino raaꞌa Iesu umaleo olimo wuku roti ka oruo bou raaꞌa, Iwono mensoꞌa i langi ka mekakai montarimakasi ndi Ue Ala. Umari raaꞌa roti ka bou raaꞌa No subi-subiho ka No weiꞌakero la ana guruNo karo tia-tiaꞌakero la mia adio raꞌiroa. ");
INSERT INTO mzq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Lowono mia mponggaa ranta karo memowoto. Umari raaꞌa, ana guruNo mepumpuo toreano kaanga henu ro mengkaango, hopulopo ka oruo baki toreano. ");
INSERT INTO mzq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Aso tempo, Iesu mekakai aso-asono. Mehaweiroto ana guruNo hawe meroronganio Iesu. Umarino mekakai, Iesu mesikeno ndi iworo, “Montonda mia adio, isiake Iaku neea?” ");
INSERT INTO mzq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ana guruNo mesangki, “Hina mia mongee, Iohane to pobaho. Hina mboꞌu henu mongee nabi Elia, ka henu mesue mboꞌu mongee aso mia teꞌembu la nabi-nabi asompihe henu tuwu mekule.” ");
INSERT INTO mzq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iesu mesikeno mboꞌu la ana guruNo, “Taꞌalu ikomiu, isiake menteeꞌano Iaku neea?” Peturu sumangki, “Ikomiuto Mokole Pongkadudui Henu Dinandiro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Gagi, Iesu umontoiro takau, kaindoro mempopauꞌo ndi isia tokoa, taꞌalu Iwonoto Mokole Pongkadudui Henu Dinandiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iesu mepau mboꞌu, “Ana Manusia nggale montanggumi adio marasaiꞌa ka Iwono tai tinarima la mia-mia mosuꞌoro to Iahudi, kapala petewawo pesomba, ka mia mpande atora Taura. Umari raaꞌa iworo nggale pepateo Iesu. Kanggo koꞌotoluno oleo Iwono pinotuwu mekule teꞌembu la mateaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kanoamba Iesu mepau mboꞌu la lowono mia henu hina rahea, “Araisia henu minggi tumonda Aku, iwono asolekono humapuo koroino mompoꞌaha kau pinotambano sombo oleo ka tumonda Aku mpihe. ");
INSERT INTO mzq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Akono araisia henu patongaꞌo koroino liono, iwono kanolo mohawe tuwuꞌa henu tai hina tampulaano. Kanggo araisia henu tai patongaꞌo koroino liono akono tumonda Aku, iwono nggale mohawe tuwuꞌa henu tai hina tampulaano. ");
INSERT INTO mzq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kano hina tuduno aso mia no peꞌueꞌo lowono ihino wawontolino, taꞌalu iwono kano kinadudui ka kano bisa tuwu meronga saru Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Araisia mokokoꞌii akono Iaku ka pompaguruNggu, Ana Manusia mboꞌu nggale mokokoꞌii umakuiꞌo taꞌalu Iwono hawe i laro wanta pobawaNo ka wanta pobawaRo UmaNo ka malaꞌeka-malaꞌeka henu mempori. ");
INSERT INTO mzq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iaku pauꞌakomiu, menteeꞌano nggale hina popioꞌiro mia henu hina endea henu ambono mate, taꞌalu amboro mengkiteo Ue Ala pamulaꞌo poparentaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Samana hoalu oleo teꞌembu la pompaguruNo Iesu raaꞌa, Iesu waweiro i Peturu, Iohane ka Iakobu lumeko mekakai i wawono toruku. ");
INSERT INTO mzq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tempono Iesu mekakai, bali raꞌiNo, ka parewaNo gagi mompute mangkilo. ");
INSERT INTO mzq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bingkosako hina oruo mia mepauꞌakero Iesu. Iworo raaꞌa, i Musa ka i Elia. ");
INSERT INTO mzq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iworo mompopokiteo koroiro saru wanta pobawa ka mepauꞌakero Iesu mongkono araꞌehende No nggale mate i Ierusale. ");
INSERT INTO mzq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tempo raaꞌa, i Peturu ka pokowalino tekoturiiroto. Bingkosako iworo mewangu, ro mengkiteo Iesu i laro wanta pobawaNo ka oruo mia mentada orambiakeo. ");
INSERT INTO mzq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ka tempono oruo mia raaꞌa nggale mobintao Iesu, i Peturu mepau ndi Iesu, “Guru, sanaa suꞌu ikami endea. Meꞌambo taꞌalu ikami mowowau otolu laika, aso tiaMiu, aso tiano i Musa ka aso tiano i Elia.” Kanggo i Peturu kano toꞌorio opio henu pinauno raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tempono i Peturu mepau liraꞌa, bingkosako hawe seru walungiiro ka iworo gagi doito. ");
INSERT INTO mzq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Umarino raaꞌa, ro mehoringo Ue Ala mepau teꞌembu i laro nseru raaꞌa lenie, “Iwonoto neea anaNggu henu Kutimakio. Pehoringakeoto pio henu pinauNo.” ");
INSERT INTO mzq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Menseno andoro mehoringo henu mepau raaꞌa, aso-asoNo tokoa Iesu ro mengkiteo. Tempo raaꞌa, ana guruNo raaꞌa andoro pompau pio ka kano hina teꞌaso mia henu mempopauꞌo la mia mesue mongkono pio henu kinitoro raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tisomono, tempono ro mpetii teꞌembu i toruku raaꞌa, mehaweiroto mia adio tepohaweꞌakero Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tempo raaꞌa mboꞌu, hina aso mia teꞌembu la mia adio raaꞌa umoraꞌako, no pongee, “Guru, iaku momonio ndi Ikomiu kai mai koa mekaanio ananggu. Akono butu aso-asono koa ananggu wainto. ");
INSERT INTO mzq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Taꞌalu iwono nopewunsokio penao mosaꞌa, bingkosako iwono koꞌora-ora. Penao mosaꞌa raaꞌa wowauꞌo ana-ana raaꞌa mepale-palempe ranta kano mewure ngangano. Penao mosaꞌa raaꞌa bobarasaꞌo mpihe ka kano poli meluarako teꞌembu la ana-ana raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Umari akuto momoni la ana guruMiu karo mensaario penao mosaꞌa henu mewunsokio ananggu raaꞌa, kanggo karo pokosaario.” ");
INSERT INTO mzq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu mepau, “Hei, ikomiu mia henu tai mompeꞌalo-alo ka tesosaelo. Popiopo epieno Kupoiꞌa i olomiu ka sabaraakomiu? Waweoto anamu nderamai.” ");
INSERT INTO mzq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tempono ana-ana raaꞌa lumeko orambiakeo Iesu, penao mosaꞌa raaꞌa mepasiakeo ka wowauꞌo ana-ana raaꞌa mepale-palempe. Kanggo Iesu kumuahakeo penao mosaꞌa raaꞌa, No pokotompaꞌo ana-ana raaꞌa ka ana-ana raaꞌa No pokuleo la umano. ");
INSERT INTO mzq_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Lowono mia henu hina rahea kombaa mengkiteo pobawaro Ue Ala henu langkai. ");
INSERT INTO mzq_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Tempono lowono mia rahea da mengkombaa akono lowono henu winowauNo Iesu raaꞌa, Iesu mepau la ana guruNo, ");
INSERT INTO mzq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pehoringakeo ka naaꞌo temeꞌambo i laro aroamiu pio henu Kupauꞌakomiu. Ana Manusia nggale pinewengako la mia henu pobawa.” ");
INSERT INTO mzq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kanggo ana guruNo karo mehawe laroꞌo pio henu pinauNo, hangano pengkonoano tewuni ndi iworo, hoꞌioto karo tai bisa mehawe laroꞌo. Ka iworo mboꞌu karo taha mpesikeno ndi Iwono pio pengkonoano henu pinauNo raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aso tempo ana guruno Iesu mpesansa mongkono isia henu takau paralu i oloro. ");
INSERT INTO mzq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kanggo Iesu tumoꞌorio pio henu pinewowoloro. Iesu moꞌalo aso ana-ana motutu, No pontadaꞌo i horiNo. ");
INSERT INTO mzq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Umarino raaꞌa, No pongee la ana guruNo, “Araisia tumarimaꞌo henu heleo ana-ana motutu neea, akono mia raaꞌa mompeꞌalo-alo ndi Iaku, iwono mboꞌu tumarimaꞌAku. Ka araisia henu tumarimaꞌAku iwono mboꞌu tumarimaꞌo Ue Ala henu tumenaꞌAku. Akono araisia henu tai paralu lahi i olomiu iwonoto henu takau paralu.” ");
INSERT INTO mzq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iohane ana guruno Iesu mepau, “Guru, ikami kumiteo aso mia monsaari penao mosaꞌa henu mewunsokio aso mia, pakeꞌo ngeeMiu. Kimeꞌontoo mia raaꞌa, akono iwono kano peꞌasondo.” ");
INSERT INTO mzq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu mepau ndi Iohane, “Hooto imeꞌontoo, akono araisia henu tai umewa komiu, iwono raaꞌa peꞌasomiu.” ");
INSERT INTO mzq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Menseno orambioto tempono Iesu tewueꞌako i suruga, No poꞌasooto aroaNo lumeko i Ierusale. ");
INSERT INTO mzq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","No tenaꞌiro arapopio mia meleꞌeruiꞌIro lumeko laꞌaso inie i Samaria mompasadia lowoakoano tiaRo. ");
INSERT INTO mzq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kanggo to Samaria henu mpoꞌia i inie raaꞌa karo mentarimaꞌo Iesu, akono iworo mentoꞌorio tinunggaino lekono Iesu, lumeko i Ierusale. ");
INSERT INTO mzq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tempono Iakobu ka Iohane humoringo raaꞌa, mpongeeiroto, “Ue, polike Ikomiu kaki memparentaꞌo apui metii teꞌembu i langi sumolangiiro?” ");
INSERT INTO mzq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kanggo, Iesu mewalili ndi iworo ka meꞌetahakero. ");
INSERT INTO mzq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Umarino raaꞌa melekoiroto la inie mesue. ");
INSERT INTO mzq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tempono Iesu ka ana guruNo lumiuakeo koleko-lekoꞌaro, hina aso mia mepau ndi Iwono, “Iaku nggale tumonda Komiu, ara inderio tokoa Ileko.” ");
INSERT INTO mzq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu mongeeꞌakeo, “Serigala hina aa poꞌiangano, sui-sui hina senono, kanggo Ana Manusia kano hina poꞌianga nggale penao-naoꞌaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ka Iesu mepau la mia mesue, “Tonda Akuto!” Kanggo mia raaꞌa mongee, “Uma, poweiꞌaku ari tempo mekule kumaburuꞌo umanggu, ku kaburuꞌo ari kakuꞌamba tumonda Komiu.” ");
INSERT INTO mzq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu mongeeꞌakeo, “Poꞌinengoto mia mate kumaburuꞌo mia mate. Kanggo iiko, lekoto ka paleleꞌoto akono Ue Ala mompamulaoto momparenta bawaaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mia mesue mboꞌu mongee, “Ue, iaku nggale tumonda Komiu, kanggo poweiꞌaku ari tempo, lumeko meparamisi la petianggu.” ");
INSERT INTO mzq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kanggo Iesu sumangki, “Kano meꞌambo mia henu monteko mewalili ari i bungkuno. Liraꞌa koamboꞌu mia henu tumonda Aku. Taꞌalu no pewowoloꞌo mpihe pio henu pinobintano, iwono kano pepototo gagi bawaa la Poparentaro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Umarino raaꞌa montisoiroto Ue Iesu pisu mpulo mia henu tumondaꞌiro henu mesue ka tumenaꞌiro mpeꞌoru-oruo meleꞌeruiꞌIro lumeko la sombo inie henu nggale lekoꞌaNo. ");
INSERT INTO mzq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","No pongeeꞌakero, “Sowiꞌa lano adio, kanggo henu mpoꞌangga henu nggale mensowiꞌo butu teꞌesi. Hoꞌioto puꞌuno mpomonioto la henu mompeꞌue sowiꞌa, kano pontambai henu moꞌangga mensowiꞌo sowiꞌa raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gagi lekomiuto, kanggo ikomiu asolekono metangkoro. Akono Iaku tumena komiu lumeko, heleo ana bimba lumeko i oloro serigala. ");
INSERT INTO mzq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hooto powawo ponaaꞌa doi, tasi ponaaꞌa baku, ara oruo pasa sandala. Taꞌalu ikomiu metabeiro mia henu tepotowoakomiu i ansala hooto pepau adio. ");
INSERT INTO mzq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Taꞌalu impewunsokio aso doha, ikomiu asolekono pauꞌo petabe lenie, ‘Sintuwu karodoa la lowono mia i doha neea.’ ");
INSERT INTO mzq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Taꞌalu hina mia henu umehe sintuwu la doha raaꞌa, petabe henu ipauꞌo raaꞌa nggale moꞌia ndi iwono. Kanggo taꞌalu kano liraꞌa, henu pinaumiu raaꞌa nggale mepokule mboꞌu ndi ikomiu. ");
INSERT INTO mzq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Impoꞌiato la dohano mia henu tumarima komiu. Imponggaato ka mpoꞌenuto opio henu ro wei komiu. Akono, henu mpoꞌangga asolekono mohawe ponsulo. Hooto impelimba teꞌembu la doha raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Taꞌalu ikomiu mpewunso i laro aso inie, ka ro mentotowo komiu, imponggaato arapio henu ro mempalenaꞌakomiu. ");
INSERT INTO mzq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pokotompaꞌiroto mia henu memahaki rahea ka pauꞌakero taꞌalu orambioto tempono Ue Ala momparenta heleo Mokole. ");
INSERT INTO mzq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kanggo taꞌalu ikomiu mpewunso i laro aso inie ka ikomiu tai tinarima, lekomiuto la ansala langkai i laro inie raaꞌa ka pauꞌoto lenie, ");
INSERT INTO mzq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kondepo pampawu teꞌembu i iniemiu henu metako la ngkare mami, kimetantamio ndi ikomiu, gagi tondoni taꞌalu Ue Ala ungga humuku komiu. Kanggo kai mentoꞌorio koa, orambioto tempono Ue Ala momparenta heleo Mokole.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iesu lumiuakeo pauNo, “Kupauꞌakomiu, taꞌalu temponoto Ue Ala mobitara mia, moliteeꞌopo pohuku henu nggale tinanggumiro to Sodomo sekonopo mia henu i inie raaꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Iesu mepau mboꞌu, “Masola komiuto to Korasi! Masola komiuto to Betsaida! Akono taꞌalu i inie Tirusi ka i inie Sidoni asompihe winowau lowoakoano henu kombaaꞌakoa heleo henu winowau ndi ikomiu, maupo iworo kano to Iahudi, epieꞌoto ro pompake lemba henu pinake tempono matea, gagi tondoni taꞌalu iworo moseairoto teꞌembu la halaro. ");
INSERT INTO mzq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gagi la oleo pebitaraꞌa ungga moliteeꞌopo pohuku henu tinarimaro to Tirusi ka Sidoni teꞌembu la pohuku henu imentarimaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ka ikomiu to Kapernau! Ikomiu mpongee, ikomiu ungga winueꞌako i suruga? Aio! Ikomiu nggale pinotii la marasaiꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Umari raaꞌa Iesu mepau la pisu mpulo mia henu tumondaꞌIro, “Araisia henu mehoringakomiu, iwono mehoringaKune mboꞌu. Araisia henu kano tarima komiu, iwono mboꞌu kano tarima Aku. Ka araisia henu kano tarima Aku, iwono mboꞌu kano tarimaIro henu tumenaꞌAku.” ");
INSERT INTO mzq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kanoamba koꞌopisu mpulono mia henu tumondaꞌo Iesu raaꞌa, mpekule saru memawongko takau aroaro ka mpepau, “Ue, penao mosaꞌa mboꞌu metenunu ndi ikami akono ngeeMiu.” ");
INSERT INTO mzq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu mepau ndi iworo, “Kukiteo Mokoleno Onisu tedontai teꞌembu i langi heleo koliki. ");
INSERT INTO mzq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pewowoloꞌo neea, umari Akuto moweiꞌakomiu pobawa kano bisa koa ikomiu molandapi ule ka kasi-kasi, ka pobawa numangio lowo rosono uwelimiu ranta kano hina arapio mokonsolangi komiu. ");
INSERT INTO mzq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Maupono lesie hooto imensanaa akono penao mosaꞌa metenunu ndi ikomiu. Kanggo mensanaa komiuto akono ngeemiu teꞌukioto i suruga.” ");
INSERT INTO mzq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tempo raaꞌa mboꞌu, Penao Mempori mokomawongkoꞌiro Iesu, ka Iesu mepau, “Iaku moꞌunde-unde ndi Ikomiu UmaNggu, Ue langi ka wawontolino, akono lowono raaꞌa Ikomiu wunio la mia henu mpande ka montoꞌori, kanggo Ikomiu pauꞌakero la mia henu tinuwuno rineke i totono. Hoꞌioto henu mokonsanaaꞌo aroamiu Uma.” ");
INSERT INTO mzq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kanoamba Iesu mepau la mia henu hina rahea, “Lowoakoano raaꞌa Ro weiꞌAkuneto Uma ndi Iaku. Kano hina teꞌaso mia henu tumoꞌorio araisia anaro Ue Ala, butukoa UmaNggu henu tumoꞌorio. Ka kano hina teꞌaso mia tumoꞌorio UmaNggu, butukoa anaNo henu tumoꞌorio, ka ndi isia henu nggale No pauꞌakeo Ana raaꞌa mongkono isia Uma.” ");
INSERT INTO mzq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Umari raaꞌa Iesu mewalili la mia henu tumondaꞌIro ka butu mepau ndi iworo, “Memeꞌura suꞌu matamiu mengkiteo opio henu imengkiteo lenie neea. ");
INSERT INTO mzq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kupauꞌakomiu, adio nabi ka mokole minggi mengkiteo pio henu kinitomiu, kanggo karo bisa mengkiteo. Iworo minggi mpohori pio henu hinorimiu, kanggo karo bisa mehoringo.” ");
INSERT INTO mzq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hina aso tempo mentada mia mpande atora Taura umara-arahakeo Iesu, No pongee, “Guru, opio henu paralu kupowowau kaku pohawe koa tuwuꞌa henu tai hina tampulaano?” ");
INSERT INTO mzq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sumangki Iesu, “Opio henu teꞌuki la atora Taura? Opio henu binasamu rahea?” ");
INSERT INTO mzq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sumangkioto, “Pehohawaꞌo Ue Alamu ka tompaano aroamu, ka tompaano sumangamu, ka tompaano rosomu, ka tompaano pandemu, ka pehohawaꞌo peꞌaso mia heleo koroimu.” ");
INSERT INTO mzq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mongee Iesu, “Sangkimu seea mentee, wowauꞌoto lesie, kongkomu koa mohawe tuwuꞌa henu tai hina tampulaano.” ");
INSERT INTO mzq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kanggo akono minggi mokomenteeꞌo koroino, mia mpande atora Taura raaꞌa mepau ndi Iesu, “Isiake peꞌasonggu henu paralu kupehohawaꞌo seea?” ");
INSERT INTO mzq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mongee Iesu, “Hina aso mia metii teꞌembu i Ierusale lumeko i Ierikho. I tonga ansala ro towokio mia mosaꞌa. Ro meꞌaleo lowo arapio henu la ngkoroino, kanoamba ro mentunduhio kano minggi mate, kanoamba ro pobintao. ");
INSERT INTO mzq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tempo raaꞌa teliu aso mia puꞌu petewawo pesomba i ansala raaꞌa. Tempono no kiteo mia raaꞌa, no lilimio ka koleko-leko mpihe. ");
INSERT INTO mzq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Liraꞌa koamboꞌu aso mia Lewi henu moꞌangga i Doharo Ue Ala teliu la mpoꞌianga raaꞌa. Menseno no kiteo mia raaꞌa, no liungo la asonimbino ansala. ");
INSERT INTO mzq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kano epie teliuꞌoto mia hawe henu teꞌembu i waawute Samaria. Tempono no kiteoto mia raaꞌa, teꞌuse aroano, no mokokounduakeo. ");
INSERT INTO mzq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","No orambiakeoto mia raaꞌa, kanoamba woꞌohiakeo mobelano ka anggoro kanoamba pakuliakeo boka kanoamba waluakeo mobelano. Umari raaꞌa no bintio wueꞌakeo la kalideno, no waweo la doha peratoꞌa. Rahea no parakaiꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tisomono no poweiꞌakeo oruo lempe doi pera la ueno doha peratoꞌa raaꞌa. Kanoamba mongeeꞌakeo, ‘Parakaiꞌo mia neea taꞌalu tai sombo ongkosono kongkonggu koa amba umeuꞌo taꞌalu mekuleakuto.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Menseno Iesu tumompakio pauNo, mesikenooto la mia mpande atora Taura raaꞌa, “Montonda pohawemu, isia i oloro otolu mia raaꞌa, henu peꞌasono mia henu rinampasi raaꞌa?” ");
INSERT INTO mzq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sumangki mia raaꞌa, “Mia henu mehohawaꞌo ka tumulungio.” Sumangki Iesu, “Lekoto, wowauꞌoto lesie!” ");
INSERT INTO mzq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Umari raaꞌa Iesu ka mia henu tumondaꞌo lumiuakeo koleko-lekoꞌaro ka teliu laꞌaso inie. I inie raaꞌa hina aso erowai henu mengeengako i Marta umundaꞌiro Iesu i dohano. ");
INSERT INTO mzq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","I Marta raaꞌa, hina aso petiano henu mengeengako i Maria. I Maria raaꞌa metunda orambi la ngkareno Ue Iesu, mehoringakeo pompaguruNo. ");
INSERT INTO mzq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kanggo i Marta butu tetala momparakai kaanga. Iwono lumeko ndi Iesu ka mepau, “Ue, tembio Ikomiu moꞌineenganggu moꞌangga aso-asonggu, petianggu kano tulungiaku wainto. Tenaꞌoto kano pokowaliaku.” ");
INSERT INTO mzq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","I Ue mepau, “Marta, Marta, biraba lahi usalalaro ka takau tetala lahi iiko la adio rupa. ");
INSERT INTO mzq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kanggo butu aso rupa koa henu paralu ka i Maria raaꞌa notimakioto henu paralu raaꞌa ka iwonoto raaꞌa henu lalua meꞌambo, henu kano hina teꞌaso mia bisa umaleo teꞌembu ndi iwono.” ");
INSERT INTO mzq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aso tempo Iesu mekakai laꞌaso poꞌianga. Umarino Iesu mekakai, aso mia ana guruNo mepau ndi Iwono, “Ue, paguru kami mekakai heleo Iohane paguruꞌiro ana guruno.” ");
INSERT INTO mzq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesu mepau ndi iworo, “Taꞌalu ikomiu mekakai, pauꞌoto lenie: Uma, pinokolangkai ngeeMiu henu mempori, Ipoparentato i wawontolino heleo mokole. ");
INSERT INTO mzq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Powei kamito kaanga henu kiparaluꞌo sombo oleo, ");
INSERT INTO mzq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ka ampuni kamito teꞌembu la lowono halamami, heleo ikami mboꞌu moꞌampuni lowono mia henu sala ndi ikami. Ka hooto Ipoꞌineenggami inara-arahako.” ");
INSERT INTO mzq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Umari raaꞌa Iesu mepau mboꞌu ndi iworo, “Taꞌalu tuduano hina i olomiu henu lumeko la dohano pokowalimiu porontonga wongi ka momoni lenie, ‘Petia, poposaboꞌakune wainto teꞌotolu roti, ");
INSERT INTO mzq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","akono hina aso pokowalinggu henu tekonai laro koleko-lekoꞌano teliu i dohanggu ka kano hina kaanga henu kunggale moweiꞌakeo.’ ");
INSERT INTO mzq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tuduano henu mompeꞌue doha sumangki, ‘Hooto risuiꞌaku. Panganso binonsooto, iaku saru ananggu moturi kamito. Iaku kaku pokopewangu moweiꞌakomu pio henu pinomonimu.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iaku mepau ndi ikomiu, “Maupono iiko pokowalino, iwono kanolo mewangu moweiꞌakomu pio henu pinomonimu. Kanggo akono iiko kau mokokoꞌii momoni nggoe-nggoe, iwono asolekono mewangu moweiꞌakeo opio henu pinaralumu. ");
INSERT INTO mzq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Gagi Iaku mepau ndi ikomiu pomonioto ndi Ue Ala, kongkono koa No poweikomiu. Wusuꞌoto opio henu pinaralumiu, matantu ikomiu humaweꞌo. Tingkooto bonso, matantu ikomiu inungkahiako. ");
INSERT INTO mzq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Akono sombo mia henu momoni, matantu nggale wineiꞌako. Sombo mia henu mowusu, matantu nggale mohawe, ka sombo mia henu motingko-tingko bonso, matantu nggale inungkahiako. ");
INSERT INTO mzq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Matantu kano hina ikomiu uma-uma taꞌalu anamiu momoni roti ikomiu moweiꞌakeo wasu, momoni bou ikomiu moweiꞌakeo ule, ");
INSERT INTO mzq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","momoni tawu manu, ikomiu moweiꞌakeo kasi-kasi. ");
INSERT INTO mzq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gagi, taꞌalu ikomiu henu mosaꞌa winowaumiu, imentoꞌorio moweiꞌakero henu meꞌambo la anamiu, tamuako Umamu i suruga. Iwono matantu mompowei Penao Mempori la mia henu momoni ndi Iwono.” ");
INSERT INTO mzq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aso tempo Iesu monsaari penao mosaꞌa henu mompewunsoki aso mia ka wowauꞌo mia raaꞌa gagi bebe. Tempono penao mosaꞌa raaꞌa meluarako, mia raaꞌa bisaoto mepau mekule. Kumiteo raaꞌa lowono mia henu hina rahea mengkombaa. ");
INSERT INTO mzq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kanggo popio mia mpepau, “Saru pobawa Belsebu, mokoleno lowono onisu, Iwono monsaari penao mosaꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Henu mesueno umara-arahakeo, momoni kano Iwono mowowau tondoni henu kombaaꞌakoa kano popokiteo taꞌalu pobawaNo teꞌembu la Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kanggo, Iesu tumoꞌorio arapio pinewowoloro, hoꞌioto puꞌuno Iwono mepau, “Sombo poparenta henu pada umewa i oloro, matantu kaloro bisa pontaha, ka sombo sombori henu pada metea matantu nggale teponsia. ");
INSERT INTO mzq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Liraꞌa mboꞌu taꞌalu Mokole Onisu monsaari onisu mesueno, iwono umewaꞌo koroino liono. Taꞌalu liraꞌato matantu poparentano nggale tesia-sia. Iaku mepau lenie akono ikomiu mongee taꞌalu Iaku monsaari penao mosaꞌa saru pobawano Belsebu. ");
INSERT INTO mzq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Taꞌalu Iaku monsaari penao mosaꞌa saru pobawano Belsebu, pau Akune, saru pobawano isia ana gurumiu monsaari penao mosaꞌa? Matantu saru pobawaro Ue Ala! Gagi, henu winowauro ana gurumiu raꞌiroa henu mopokiteo taꞌalu petulurimiu ndi Iaku raaꞌa kano mentee. ");
INSERT INTO mzq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kanggo, taꞌalu Iaku monsaari penao mosaꞌa saru pobawaro Ue Ala, pengkonoano Ue Ala mompamulaoto momparenta ndi ikomiu.” ");
INSERT INTO mzq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Taꞌalu hina aso mia henu moroso gumagaiꞌo dohano ka parewa mpeteano sombo, matantu kano hina mia henu bisa moꞌalo ihi dohano. ");
INSERT INTO mzq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kanggo, taꞌalu hina aso mia henu morosoopo ka iwono hawe sumapoiꞌo ka numangio, matantu mia henu morosoopo raaꞌa umaleo lowo parewa mpetea henu no perorohio mia henu mogagai doha raaꞌa ka tumia-tiaꞌo la mpokowalino. ");
INSERT INTO mzq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Araisia tai meꞌaso Akune, iwono umewa Aku ka araisia henu tai tumulungi Aku la mpoanggaꞌaNggu mowawo mia ndi Iworo Ue Ala, iwono monsolangi anggaꞌaNggu.” ");
INSERT INTO mzq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Iesu mepau mboꞌu, “Taꞌalu penao mosaꞌa meluarako teꞌembu laꞌaso mia, iwono nggale lumeko koleko-leko la pada one mowusu poꞌiangano. Kanggo taꞌalu kano pohawe poꞌiangano, penao mosaꞌa raaꞌa mepau lenie, ‘Iaku nggale mekule mboꞌu la doha henu pinobintanggu.’ ");
INSERT INTO mzq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Gagi lumekooto iwono la doha raaꞌa ka humaweꞌo doha raaꞌa morinaoto rinoahi ka teꞌatoraoto. ");
INSERT INTO mzq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Umari raaꞌa, lumekooto penao mosaꞌa raaꞌa umuluꞌakeo opisu penao mosaꞌa mesueno henu mosaꞌa takau ka iwono ka iworo mewunso la doha raaꞌa, ka moꞌia rahea. Pokotompaano, tumuwuno mia raaꞌa mosaꞌaopo ka amba-ambano.” ");
INSERT INTO mzq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tekonai Iesu mepau, koꞌora-oraoto aso erowai teꞌembu i tonga-tongano mia adio mepau ndi Iwono lenie, “Meꞌuraoto suꞌu ineMu henu mentiaꞌakoMu ka moꞌuoKo.” ");
INSERT INTO mzq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kanggo Iesu mepau, “Meꞌuraopo mboꞌu mia henu humoringo ka wowauꞌo pauro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tempono mia adio tepumpu meboliliꞌo Iesu. Iwono mepau ndi iworo, “Mia henu tuwu lenie neea, takau mosaꞌa winowauro. Iworo mpomoni tondoni kanggo kanolo hina tondoni henu mesueno henu Ue Ala nggale weiꞌakero, butu tondoni henu gagi ndi nabi Iunusu tempo saaꞌa henu Ue Ala nggale weiꞌakero. ");
INSERT INTO mzq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Heleo Iunusu gagi petondoni la to Niniwe, liraꞌa mboꞌu ungga Ana Manusia gagi petondoni la mia henu tuwu lenie neea. ");
INSERT INTO mzq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tempono oleo pebitaraꞌa, mokole erowai teꞌembu i Seba nggale pinotuwu mekule meronga-ronga saru mia henu tuwu lenie neea, ka iwono ungga nggale mopokiteo winowauro henu sala. Akono iwono hawe teꞌembu tompano wawontolino humoringo mpande teꞌembu la mokole Solema. Menteeꞌano endea hina aso mia henu pandeopo ka mokole Solema, kanggo ikomiu kai poli mehoringakeo! ");
INSERT INTO mzq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tempono oleo pebitaraꞌa, mia Niniwe nggale tuwu mekule meronga-ronga saru ikomiu henu tuwu lenie neea. Mia Niniwe raaꞌa ungga nggale tuwu mekule ka mopokiteo salaro mia, akono iworo moseaꞌoto teꞌembu la halaro menseno ro mehoringo kareba henu pinauno Iunusu. Menteeꞌano endea hina aso nabi henu langkaiꞌopo ka Iunusu kanggo kai mempoli mosea.” ");
INSERT INTO mzq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iesu lumiuakeo mboꞌu pauNo, “Kano hina teꞌaso mia monsusungi hulo kanoamba numaaꞌo la mpoꞌianga henu tewuni. Kano pupusiakeo mboꞌu loia, kanggo matantu no naaꞌo la mpoꞌiangano laano, kano mia henu mewunso i laro doha mengkiteo wantano. ");
INSERT INTO mzq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matamiu seea iwonoto hulono koroimiu. Taꞌalu matamiu meꞌambo, lowono koroimiu mewanta, kanggo taꞌalu matamiu mahaki matantu lowono koroimiu rokoma. ");
INSERT INTO mzq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hoꞌioto puꞌuno ikomiu asolekono metangkoro kano wanta henu hina ndi ikomiu kano gagi rokoma. ");
INSERT INTO mzq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Taꞌalu lowono koroimiu mewanta, ka kano hina henu rokoma, matantu lowono tuwumu mewanta heleo hulo wantahiko.” ");
INSERT INTO mzq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Menseno Iesu umari mompaguru, aso mia to Parisi umundaꞌo lumeko monggaa la dohano. Iesu lumeko la dohano to Parisi raaꞌa ka metunda monggaa. ");
INSERT INTO mzq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tempono to Parisi raaꞌa kumiteo Iesu monggaa kano woꞌohio kaeNo ari montonda atora agamaro to Iahudi, iwono kombaa. ");
INSERT INTO mzq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kanggo Ue Iesu mepau, “Ikomiu to Parisi, molodui mangko ka tabo butu i bungkuno koa, kanggo i laro koroimiu bukeako modoko ka winowaumiu henu mosaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hei ikomiu mia bebe, Ue Ala henu mokogagio henu i bungkuno henu tekito ka i larono henu kano tekito. ");
INSERT INTO mzq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gagi, hooto imemodoko ka hooto impowowau henu mosaꞌa. Poweiꞌakero la mia henu mekarampini opio henu hina ndi ikomiu kano ikomiu mempori takau i aroro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Memasola komiuto to Parisi, akono ikomiu metenunu mompowei hopulo persee ndi Ue Ala teꞌembu solasi, rampalemo ka rampa-rampa mesueno, kanggo ikomiu kano momoli ka kano mompehohawa la Ue Ala. Menteeꞌano heleo liraꞌa henu asolekono imewowauꞌo ka hooto imengkolupeo pompaguru henu mesueno. ");
INSERT INTO mzq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Memasola komiuto to Parisi, akono inehemiu mpetunda la mpoꞌianga petundaꞌaro henu pinelangkai la doha pesombaꞌa to Iahudi. Ka inehemiu taꞌalu hina mia melangkai komiu i pasa. ");
INSERT INTO mzq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Memasola komiuto, akono ikomiu heleo kaburu henu tai hina tondonino ranta mia henu teliu i wawono kano toꞌorio. Liraꞌa mboꞌu ikomiu, i bungkuno meꞌambo kanggo i laro aroamiu mosaꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aso mia i oloro mia mpande atora Taura mepau ndi Iesu, “Guru, taꞌalu Ikomiu mepau liraꞌa, pengkonoano Ikomiu pokomokokoꞌii kami.” ");
INSERT INTO mzq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu sumangki, “Memasola komiuto mia mpande atora Taura, akono ikomiu mompowei la mia atora-atora henu mobea karo mewowauꞌo, kanggo ikomiu maupo teꞌesi tokoa kai poli tumulungiiro wowauꞌo atora raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Memasola komiuto, akono ikomiu mompokomeꞌambo kaburuno nabi-nabi henu pinepatero mia mosuꞌomiu asompihe. ");
INSERT INTO mzq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Henu winowaumiu raaꞌa, mopokiteo taꞌalu ikomiu meꞌaroaꞌo pio henu winowauro mia mosuꞌomiu asompihe. Akono mia mosuꞌomiu asompihe mepateiro nabi-nabi raꞌiroa, ka ikomiu pokomeꞌamboꞌo kabururo. ");
INSERT INTO mzq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hoꞌioto puꞌuno saru mpandero Ue Ala mepau mongkono ikomiu, ‘Iaku nggale montena nabi-nabi ka rasul-rasul ndi iworo, kanggo aso ntia ro pepateo ka henu mesueno ro bobarasaꞌo.’ ");
INSERT INTO mzq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gagi, mia henu tuwu lenie neea asolekono montarima pohuku, akono rearo lowono nabi henu tesolo mompuꞌu wawontolino pinokogagi, ");
INSERT INTO mzq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mompuꞌu la reano i Abeli hawe la reano i Sakaria henu pinepate i olono poꞌianga ponsunua pesomba saru Doharo Ue Ala. Pihepo mboꞌu Kupauꞌakomiu, ikomiu henu tuwu lenie asolekono montarima pohuku akono lowono sala henu winowau raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Memasola komiuto, hei mia mpande atora Taura, akono ikomiu heleo mia henu monaa gonti pendamoha i laro bolongko pepotoꞌori mongkono poꞌehero Ue Ala, kanggo ikomiu kai poli mendamo i laro bolongko raaꞌa. Ikomiu koa henu umontoiro mia mesue henu minggi mendamo ka minggi tumoꞌorio poꞌehero Ue Ala” ");
INSERT INTO mzq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Menseno Iesu mobintao poꞌianga raaꞌa, mia mpande atora Taura raꞌiroa ka to Parisi tekosi karo meꞌeheo. Teꞌembu rahea mompamulairoto mempaanio Iesu kano poli koa mepau mongkono adio rupa. ");
INSERT INTO mzq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sombo pio henu pinauNo Iesu, iworo mpehoringakeo takau. Gagi, taꞌalu hina henu sala No pauꞌo, hina ansalaro merakoꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tempono sowuno mia adio tepumpu, ranta karo pedudumpali orambiakeo Iesu, mompuꞌuiroto Iesu mompaguru, Iwono mepau ari la ana guruNo. Iesu mepau, “Petangkoro la tapero to Parisi iwonoto gauro henu tekito meꞌambo i bungkuno koa. ");
INSERT INTO mzq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kanolo hina teꞌaso henu tepupusi henu tai nggale inungkahi ka kano hina teꞌaso henu tinako henu tai nggale tinoꞌori. ");
INSERT INTO mzq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Akono lowono henu ikomiu pauꞌo la rokomaano nggale hinori la mewantaano, ka pio henu impetanga-tangaꞌakeo i laro bolongko nggale pinopau teꞌembu la mbumbungeno doha.” ");
INSERT INTO mzq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Iaku mepau mboꞌu ndi ikomiu pokowaliNggu, “Hooto imedoito ndi iworo henu bisa mepateo koroi, ka umarino raaꞌa iworo karo bisa mboꞌu mpowowau pio-pio. ");
INSERT INTO mzq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kanggo Iaku mepau ndi ikomiu, aso mia tokoa henu imedoitoꞌakeo. Imedoitoto ndi Ue Ala henu kano butukoa pobawa mompepate, kanggo pobawa koamboꞌu metadiakeo mia la naraka. Iaku mepau suꞌu ndi ikomiu, imedoitoto ndi Iworo. ");
INSERT INTO mzq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Imentoꞌorio koa mongee olimo sui-sui dena pineꞌoliako masempo butu oruo doi pera henu takau motutu rekeno. Kanggo kano hina teꞌaso tokoa henu no kolupeo Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Laluaꞌopo ikomiu, sombo laino wuumiu Ro doaꞌoto Ue Ala. Hoꞌioto puꞌuno, hooto imedoito akono ikomiu No pehohawa komiupo Ue Ala sekonopo sui-sui dena henu adio.” ");
INSERT INTO mzq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Iaku mepau mboꞌu ndi ikomiu, araisia henu umakuiꞌo i aroro mia taꞌalu iwono tumonda Aku, Ana Manusia mboꞌu ungga umakuiꞌo i aroro malaꞌekaro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kanggo araisia henu humapu Aku i aroro mia, iwono mboꞌu ungga Kuhapuo i aroro malaꞌekaro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Araisia mepau teꞌaso umewaꞌiro Ana Manusia, iwono da bisa kinadudui. Kanggo araisia henu sumosaꞌaiꞌo Penao Mempori iwono kanolo bisa kinadudui. ");
INSERT INTO mzq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Taꞌalu ikomiu rinako ka winawo meꞌaro la puꞌu petewawo agama ara la to poparenta, hooto ikomiu salalaro mongkono araꞌehende ikomiu meꞌoloiꞌo koroimiu, ara mongkono pio henu nggale mempauꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akono i tempo raaꞌa mboꞌu Penao Mempori nggale paguru komiu opio henu nggale ikomiu pauꞌo.” ");
INSERT INTO mzq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aso mia teꞌembu la mia adio raaꞌa pepumpu rahea mepau ndi iworo Iesu, “Guru, pauꞌakeo la petianggu kano poweiꞌakune tia pusaka teꞌembu la mia mosuꞌo mami.” ");
INSERT INTO mzq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kanggo Iesu mepau, “Petia, kano hina mia henu motoro Aku gagi puꞌu pobitara ara gagi puꞌu pontia pusaka i olomiu.” ");
INSERT INTO mzq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kanoamba Iesu mepau mboꞌu la mia pepumpu rahea, “Petangkoroto kano ikomiu hooto minggi peꞌueꞌo lowo ihino wawontolino. Akono maupo aga-agando adio, kano aga-aga raaꞌa henu nggale mokopotuwu kito.” ");
INSERT INTO mzq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Umari raaꞌa Iesu montutuluꞌakero aso ande-ande mpau lenie, “Hina aso mia henu sugi henu takau adio wue pinopahono i lereno. ");
INSERT INTO mzq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iwono mesikeno la aroano lenie, ‘Pio henu kunggale wowauꞌo? Akono andono hina ponaꞌa henu kunggale pakeꞌo numaꞌo wue pinopahonggu.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pokotompaano iwono mongee, “Lenie henu asolekono kuwowauꞌo! Iaku betaho siꞌenggu, kakuꞌamba mowangu mboꞌu siꞌe henu lalua langkai nggale ponaaꞌanggu gandu ka lowono aga-aganggu.” ");
INSERT INTO mzq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Umarino raaꞌa iaku nggale mongee la koroinggu lenie, “Adioto aga-aga henu unaaꞌo. Sombooto no pinake la popio ntaꞌu. Penao-naoto, mponggaato, poꞌenuto ka pesana-sanaato.” ");
INSERT INTO mzq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kanggo Ue Ala mepau la mia raaꞌa, “Iiko mia bebe, wongi koa neea mboꞌu Iaku nggale umaleo penaomu. Gagi, wineiꞌako ndi isia lowono henu ninaamu raaꞌa?” ");
INSERT INTO mzq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Liraꞌato henu nggale gagi la mia henu mpeꞌusaha mopumpu aga-aga tiano koroino liono ka iwono kano sugi i aroro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iesu mepau ndi iworo henu tumondaꞌIro, “Hoꞌioto puꞌuno Iaku mepau ndi ikomiu, hooto imensalalaro mewowoloꞌo tuwumiu, mongkono arapio henu nggale imengkaango. Ka hooto imensalalaro mewowoloꞌo koroimiu mongkono opio henu nggale pinakemiu. ");
INSERT INTO mzq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Akono tuwu raaꞌa mantuduopo ka kaanga ka koroi mantuduopo ka parewa. ");
INSERT INTO mzq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Perurupaꞌo sui-sui paa-paa, iworo karo pompaho ka karo mensowi. Iworo kano hina siꞌero, kanggo Ue Ala moweiꞌakero kaanga. Tamuako ikomiu, mantudu komiupo i aroro Ue Ala sekonopo sui-sui raꞌiroa. ");
INSERT INTO mzq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Isia teꞌembu ndi ikomiu henu saru salalarono moko tambaiꞌo tinuwuno maupo butu teꞌesi tokoa? ");
INSERT INTO mzq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Gagi, taꞌalu henu motutu heleo montambai tinuwu ikomiu kailo pokowowauꞌo, tembio kai mensalalaro mongkono kaanga ka parewa? ");
INSERT INTO mzq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kiteoto sisi bonse henu tuwu i lere. Iworo karo mpoꞌangga mobea ka iworo karo pontanu. Kanggo Iaku mepau ndi ikomiu, mokole Solema, maupo no sugi iwono kano peparewa meꞌambo heleo sisi bonse raꞌiroa. ");
INSERT INTO mzq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Taꞌalu liraꞌa Ue Ala moko meꞌamboꞌo sisi bonse i lere henu oleo neea tuwu ka isomo tinadi la apui. Tamuako ikomiu, asolekono Ue Ala nggale mowei komiu parewa henu pinaralumiu, hei ikomiu mia tai mompeꞌalo-alo lahi! ");
INSERT INTO mzq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Gagi, hooto imedungku mpewowoloꞌo arapio inggale mponggaa ka arapio henu inggale mpoꞌenu. Ka hooto imensalalaro mongkono lowoakoano raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Lowono raaꞌa pia ro mewusuꞌo mia kano to Iahudi i wawontolino neea. Menteeꞌano, Umamiu i suruga tumoꞌorio taꞌalu ikomiu paraluꞌo lowoakoano raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gagi henu takau mantudu, peꞌusahato kano Ue Ala momparenta i laro ntinuwumiu. Taꞌalu liraꞌato imewowauꞌo, lowono pinaralumiu henu mesueno matantu Iwono nggale moweiꞌakomiu. ");
INSERT INTO mzq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ikomiu ana guruNggu maupono kano adio komiu, hooto imedoito. Akono Umamiu henu i suruga saru sanaa aroa mokogagi komiu gagi bawaaNo i laro PoparentaNo. ");
INSERT INTO mzq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Impeꞌoliakeoto aga-agamiu, doino tia-tiaꞌo la mia mokokolaro. Wowauꞌoto kadu-kadu henu tai nggale molulu, iwonoto raaꞌa aga-aga henu tai hina pinggoano i suruga, inderio henu mponako kano pokoponakoo mboꞌu ka ane kano bisa mokomowuruꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wowauꞌoto lowoakoano raaꞌa akono inderio aga-agamiu no poꞌia, rahea mboꞌu aroamiu.” ");
INSERT INTO mzq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Iesu lumiuakeo mboꞌu pauNo lenie, “Ikomiu asolekono sadia mpihe momparakai Ue Ala heleo ata mpeboo-boo ntonga mpihe, ka mompolanga mpihe palita. ");
INSERT INTO mzq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ka ikomiu asolekono heleo ata-ata henu monsikori ueno mekule teꞌembu la mpetaoꞌa. Taꞌalu iwono hawe ka metingko-tingko bonso, iworo ronga umungkahiakero bonso. ");
INSERT INTO mzq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Meꞌurairoto suꞌu ata raꞌiroa, taꞌalu uero mekuleoto humaweꞌiro tekonai pegagai. Mentee suꞌu Iaku mepau ndi ikomiu, uero raaꞌa nggale metangkoro ka tumenaꞌiro metunda ka moweiꞌakero kaanga. ");
INSERT INTO mzq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Liraꞌa mboꞌu taꞌalu iwono hawe porontonga wongi ara orambi mowanda ka humaweꞌiro tekonai pegagai, meꞌurairoto suꞌu. ");
INSERT INTO mzq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kanggo Iaku mepau ndi ikomiu, taꞌalu ueno doha tumoꞌorio langku popio mia monako hawe, matantu ueno doha raaꞌa megagai, ka kano poꞌineengo mia monako raaꞌa mendamo i laro dohano. ");
INSERT INTO mzq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Liraꞌa koamboꞌu ikomiu. Ikomiu asolekono pegagai mpihe sombo oleo, akono tempono haweꞌaRo mekule Ana Manusia, ikomiu kai mentoꞌorio.” ");
INSERT INTO mzq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Umari raaꞌa i Peturu mesikeno, “Ue, samana ikami henu tinungkaiMu la ande-ande mpau neea ara lowono mia?” ");
INSERT INTO mzq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Iesu sumangki saru ande-ande mpau lenie, “Nginehele hina teꞌaso ata henu metenunu ka mpande, atato raaꞌa henu nggale pinotorono ueno gagi puꞌu petewawo ata henu mesue, kano iwono moweiꞌakero kaanga sombo oleo. ");
INSERT INTO mzq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Meꞌuraoto suꞌu ata henu pinotoro raaꞌa tempono ueno raaꞌa hawe humaweꞌo mowowau heleo raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mentee suꞌu Iaku mepau ndi ikomiu, ueno raaꞌa nggale motoroꞌo gagi moꞌurusu lowono aga-agano. ");
INSERT INTO mzq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kanggo taꞌalu ata raaꞌa mepau i laro aroano lenie, ‘Uenggu da epie kanoamba mekule.’ Teꞌembu rahea mompamulaoto tumunduhio ata-ata henu mesueno, tama ka erowai ka monggaa saru moꞌenu ranta kano molangu. ");
INSERT INTO mzq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kanggo tekonai no mowowau liraꞌa, bingkosako haweoto ueno la oleo ka tempo henu kano toꞌorio. Ueno raaꞌa teꞌingga nggale humukuꞌo ata raaꞌa menggena heleo pohukuꞌa la mia henu tai metenunu ndi iworo Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ata henu tumoꞌorio poꞌeheno ueno, kanggo iwono kano pegagai ka iwono kano wowauꞌo poꞌeheno ueno, asolekono tinunduhi menggo adio. ");
INSERT INTO mzq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kanggo ata henu kano toꞌorio poꞌeheno ueno ka mowowau henu tai mentee ranta wowauꞌo kano tinunduhi, iwono kanolo tinunduhi menggo adio. Liraꞌa koamboꞌu isia henu pinoweiꞌako adio, nggale pinomoni adio teꞌembu ndi iwono. Ka araisia henu No pineꞌalo-aloꞌakero Ue Ala adio, Ue Ala mboꞌu nggale momoni adio teꞌembu ndi iwono.” ");
INSERT INTO mzq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Iaku hawe nggale mompetadiako apui teposisalaa i wawontolino ka Iaku takau merorohio apui raaꞌa melangaoto. ");
INSERT INTO mzq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kanggo Iaku asolekono montarima marasaiꞌa. AroaNggu takau kano rodo ambono marasaiꞌa raaꞌa gagi. ");
INSERT INTO mzq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hooto impewowoloꞌo taꞌalu Iaku hawe mowawo sintuwua i wawontolino. Iaku mepau ndi ikomiu, Iaku mowawo teposisalaa. ");
INSERT INTO mzq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Akono mompamula oleo neea, nggale hina teposisalaa. Tuduano hina olimo mia i larono aso doha teposisala. Otolu mia umewaꞌo oruo mia ara henu oruo mia umewaꞌo henu otolu mia. ");
INSERT INTO mzq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iworo nggale pada umewa, henu uma umewaꞌo anano tama ka anano henu tama umewaꞌo umano, henu ine umewaꞌo anano henu erowai ka anano erowai umewaꞌo ineno. Ine nggale umewaꞌo walino anano tama ka erowai umewaꞌo ineno walino.” ");
INSERT INTO mzq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu mepau mboꞌu la mia adio raꞌiroa, “Tempono imengkiteo seru mewueꞌako i asonimbino sooꞌano oleo, ikomiu mpongee, ‘Use nggale tii’, ka gagi koa suꞌu heleo henu ngineemiu. ");
INSERT INTO mzq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Liraꞌa mboꞌu taꞌalu angi mepuuri teꞌembu i selata, ikomiu mepau, ‘Oleo nggale mopeda,’ Ka gagi koa suꞌu heleo ngineemiu. ");
INSERT INTO mzq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hei ikomiu mia henu mompeꞌende-ende meꞌambo! Ikomiu mentoꞌorio mengkiteo tegauno wawontolino ka langi, kanggo ikomiu kai mentoꞌorio pio-pio mongkono kegagia-kegagia henu tekonai gagi lenie. ");
INSERT INTO mzq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tembio ikomiu kai patantuꞌo liomiu pio henu mentee? ");
INSERT INTO mzq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Taꞌalu iiko ka uwelimu lumeko meronga-ronga la puꞌu pobitara, peꞌusahato kano ikomiu mosintuwu i tonga ansala. Taꞌalu aio, uwelimu raaꞌa nggale wawoko lumeko la puꞌu pobitara ka puꞌu pobitara raaꞌa nggale mewengakomu la henu mogagai tarungku henu nggale mondamoko laro tarungku. ");
INSERT INTO mzq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iaku mepauꞌakomiu, iiko kaulo mpokopeluarako teꞌembu la tarungku taꞌalu ambo ubaraꞌo leso doi henu nopatantuꞌo puꞌu pobitara.” ");
INSERT INTO mzq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tempo raaꞌa popioꞌiro mia mehawe ka pauꞌakero Iesu mongkono popio mia to Galilea henu pinepateno i Pilatu i Doharo Ue Ala ranta rearo merampu ka reano pinotuwu henu ro pesombaꞌakeo ndi iworo Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu mepau, “Ikomiu mpongee, to Galilea raaꞌa tumanggumio masusaa heleo raaꞌa akono halaro langkaiꞌopo teꞌembu la lowono mia mesue henu i Galilea? ");
INSERT INTO mzq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aio! Kupauꞌakomiu, taꞌalu ikomiu kai mosea teꞌembu la halamiu, ikomiu lowo nggale mate marasai heleo to Galilea raꞌiroa. ");
INSERT INTO mzq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ara samana ikomiu mompewowolo hopulo ka hoalu mia henu mate dinunsino menara i Siloa, halaro langkaiꞌopo ka lowono mia henu mpoꞌia i Ierusale? ");
INSERT INTO mzq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aio. Kupauꞌakomiu, taꞌalu ikomiu kai mosea teꞌembu la halamiu, ikomiu lowo nggale mate menggena heleo iworo.” ");
INSERT INTO mzq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Umari raaꞌa Iesu tumutuluꞌakero aso ande-ande mpau lenie, “Hina aso mia henu mompeꞌue puꞌuno ara i lere anggorono. Aso tempo, ueno lere raaꞌa lumeko mowusu wueno ara. Kanggo, kano hina wueno no pohawe. ");
INSERT INTO mzq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pokotompaano no pongeeꞌakeo la mia henu mogagai lere raaꞌa, ‘Kiteo, otolu ntaꞌuto kumai mowusu wueno kau ara neea, kanggo kano hina wueno kupohawe. Tuehioto kau neea, akono kau neea butu mompinggo-pinggo monuwono wute.’ ");
INSERT INTO mzq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kanggo henu mogagai lere raaꞌa mepau, ‘Ue, poꞌinengoto ari kau raaꞌa tuwu aso ntaꞌu mboꞌu. Ambapo kukekeo wute boliliꞌo puꞌuno ara raaꞌa kakuꞌamba pupuꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kato toꞌorio taꞌu ramai ara mewueꞌoto. Taꞌalu kano pewue mboꞌu, poꞌineengoto ue utenaꞌaku tumuehio puꞌu ara raaꞌa’” ");
INSERT INTO mzq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tempono oleo Penao-naoꞌa to Iahudi, Iesu mompaguru laꞌaso doha pesombaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Rahea hina aso erowai henu hopulo ka hoalu ntaꞌuto nopewunsokio penao mosaꞌa henu wowauꞌo bungkulosu ka andono pokopentada momoli. ");
INSERT INTO mzq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tempono Iesu kumiteo erowai raaꞌa, No poboiꞌo ka mepau ndi iwono, “Ine, hakimu pinokotompaoto.” ");
INSERT INTO mzq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kanoamba Iesu motopao kaeNo la koroino erowai raaꞌa, ka tempo koa raaꞌa mboꞌu erowai raaꞌa mokopentadaoto momoli ka mompamulaoto umunde-undeꞌiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kanggo kapala doha pesombaꞌa to Iahudi raaꞌa tekuda, akono Iesu mompokotompa mia mahaki la oleo Penao-naoꞌa to Iahudi. Kapala doha pesombaꞌa to Iahudi raaꞌa mepau la mia henu hina rahea, “Hina oono oleo i larono aso minggu mpoꞌangga. Tempo raaꞌa mehawe komiuto kano pinokotompa, hooto imehawe la oleo Penao-naoꞌando.” ");
INSERT INTO mzq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kanggo Ue Iesu mepau, “Ikomiu mia henu mompeꞌende-ende meꞌambo. Matantuoto ikomiu nggale mompotola sapi ara kalidemiu teꞌembu la dampano kano ikomiu mopoꞌenuiro la oleo Penao-naoꞌa to Iahudi. ");
INSERT INTO mzq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Oleo neea, endea, erowai neea inuleno i Burahima henu hopuloto ka hoalu ntaꞌu no ponguo pobawano Mokole Onisu. Pototonoto laano no pinotola teꞌembu la mponguno raaꞌa, maupono la oleo Penao-naoꞌa to Iahudi.” ");
INSERT INTO mzq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","SangkiNo Iesu raaꞌa, wowauꞌo ewaNo raꞌiroa mokokoꞌii, ka lowono mia mesue henu hina rahea sanaa akono lowono henu kombaaꞌakoa henu winowauro Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Umari raaꞌa Iesu mepau, “Taꞌalu Ue Ala momparenta heleo Mokole, araꞌehende tegauno? Saru pioke Ku bisa mokomenggenaꞌakeo? ");
INSERT INTO mzq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tegauno Poparentaro Ue Ala raaꞌa heleo wuku mpahoꞌa henu takau motutu henu rinawono mia i lereno. Wuku mpahoꞌa raaꞌa tuwu ka gagi aso puꞌu kau ka sui-sui mpeseno la sampano.” ");
INSERT INTO mzq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu lumiuakeo pauNo, “Iaku monggenaꞌakeo saru pio tegauno i laro Poparentaro Ue Ala? ");
INSERT INTO mzq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tegauno i laro Poparentaro Ue Ala raaꞌa heleo tape henu inalono aso erowai kanoamba kinangke saru patompulo litere tarigu ranta lowono tarigu henu kinangke raaꞌa teꞌili.” ");
INSERT INTO mzq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Umari raaꞌa Iesu lumiuakeo koleko-lekoꞌaNo lumeko i Ierusale. Iwono koleko-leko lumiungo inie langkai ka inie motutu, ka mompaguru pauro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hina aso mia henu mesikeno ndi Iwono, “Ue, teꞌesi koake mia henu nggale pinoweiꞌako tuwuꞌa henu tai hina tampulaano i suruga?” ");
INSERT INTO mzq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Iesu sumangki, “Peꞌusahato mpendamo la panganso henu moꞌasi, akono Iaku pauꞌakomiu, adio mia henu meꞌusaha mendamo, kanggo iworo karo pokopendamo. ");
INSERT INTO mzq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Taꞌalu ueno doha mebonsooto, ikomiu nggale mentada i bungkuno, metingko-tingko la bonso ka mepau, ‘Ueno doha, ungkahiakami wainto bonso.’ Kanggo ueno doha nggale mepau ndi ikomiu, ‘Kaku toꞌori komiu.’ ");
INSERT INTO mzq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ikomiu nggale mepau, ‘Ikami neea monggaa ka moꞌenu meronga Komiu, ka Ikomiu paguru kami i lowono ansala i laro inie mami.’ ");
INSERT INTO mzq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kanggo Iwono nggale mepau ndi ikomiu, ‘Kaku toꞌori komiu. Imelekoto teꞌembu i aroNggu, ikomiu lowo henu mpowowau henu mosaꞌa.’ ");
INSERT INTO mzq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tempono imengkiteo i Burahima, Isaki, Iako, ka lowono nabi pesana-sanaa i laro suruga, ikomiu nggale mebaꞌie ka marasai, akono ikomiu nggale tinadi i bungkuno suruga. ");
INSERT INTO mzq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Adio mia henu kano to Iahudi nggale mehawe teꞌembu la peloꞌano oleo, teꞌembu la sooꞌano oleo, teꞌembu la utara ka teꞌembu la selata nggale monggaa i suruga. ");
INSERT INTO mzq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ka menteeꞌano, hina popioꞌiro mia henu rineke tai mantudu, nggale pinelangkai i laro suruga. Ka hina popioꞌiro mia henu rineke mantuduopo, iworo karo mpendamo i laro suruga.” ");
INSERT INTO mzq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tempo koa raaꞌa mboꞌu popioꞌiro to Parisi hawe ndi Iesu ka mepau, “Ilekoto teꞌembu endea, akono mokole Herode minggi mepate Komiu.” ");
INSERT INTO mzq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kanggo Iesu sumangkiiro, “Imelekoto, pauꞌakeo serigala raaꞌa, ‘Horingo, Iaku monsaari onisu ka mompokotompa mia mahaki oleo neea ka isomo, ka la oleo koꞌotoluno anggaꞌaNggu konoto umari.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Umari raaꞌa Iesu mepau la mia henu hina rahea, “Maupono arapio henu gagi, Iaku asolekono lumiuakeo koleko-lekoꞌaNggu, oleo neea, isomo ka teꞌepua akono kano hina nabiro Ue Ala pinepate la inie mesueno butukoa Ierusale. ");
INSERT INTO mzq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kiteo, ikomiu to Ierusale, ikomiu umari pompepate nabi-nabi ka ikomiu motumpai mia henu tinena ndi ikomiu saru wasu ranta mate. Menggoꞌadioꞌoto nginehele Kuminggi pumpu komiu, menggena heleo ineno manu mopumpu anano i totono panino, kanggo ikomiu kai mempoli. ");
INSERT INTO mzq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Menteeꞌano Ue Ala kanolo meriongo mboꞌu waawutemiu. Iaku mepau ndi ikomiu, ikomiu andoilo mengkitoaKu mboꞌu ranta ikomiu mepau, ‘Binarakatioto henu hawe heleo tinenaro Ue Ala!’ ” ");
INSERT INTO mzq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","La oleo Penao-naoꞌa to Iahudi, Iesu lumeko monggaa i dohano aso mia puꞌu petewawono to Parisi. Iworo henu hina ndepano merurupaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ndepano hina aso mia henu mahaki hawe i aroro Iesu. Kare ka kaeno melolamba. ");
INSERT INTO mzq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu mesikeno la mia mpande atora Taura raꞌiroa ka to Parisi henu hina rahea, “Montonda atora agamando, bisa koake mompokotompa mia mahaki la oleo Penao-naoꞌa to Iahudi ara aio?” ");
INSERT INTO mzq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kanggo iworo mengkomino lowo. Kanoamba Iesu uminiꞌo kaeno mia henu mahaki raaꞌa, mokotompaꞌo ka tumenaꞌo mekule. ");
INSERT INTO mzq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Umari raaꞌa Iesu mepau ndi iworo, “Taꞌalu hina anamiu ara sapimiu tedontai la aa, matantuoto ikomiu mewueꞌakeo, maupono la oleo Penao-naoꞌa to Iahudi.” ");
INSERT INTO mzq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kano hina maupo teꞌaso mia teꞌembu ndi iworo henu taha sumosangkio henu pinauro Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tempono Iesu kumiteo mia henu hawe mpeꞌusaha mpetunda la petundaa henu pinelangkai, Iwono mompau ande-ande mpau neea ndi iworo, ");
INSERT INTO mzq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Taꞌalu hina teꞌembu ndi ikomiu inunda lumeko la mpetaoꞌa, hooto impetunda la petundaꞌaro mia henu pinelangkai. Akono samana ueno doha raaꞌa umundaꞌiro mboꞌu mia henu pinelangkaiꞌopo ka ikomiu. ");
INSERT INTO mzq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ueno doha raaꞌa teꞌingga olo mongeeꞌakomiu, ‘Pelimba iiko teꞌembu sehea. Weiꞌakeo la pokowalinggu neea petundaa seea.’ Pokotompaano ikomiu gagi mokokoꞌii akono ikomiu asolekono melimba la petundaa henu i bungkuno takau. ");
INSERT INTO mzq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Gagi, taꞌalu ikomiu inunda la mpetaoꞌa, impetundato la petundaa henu i bungkuno takau, kano ueno doha raaꞌa mai ndi ikomiu ka mepau, ‘Pokowali, lekoto petunda la petundaaro henu pinelangkai.’ Gagi taꞌalu liraꞌa, ikomiu mpohawe pompelangkai i aroro lowono totoko henu mesue. ");
INSERT INTO mzq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Akono araisia henu melangkaiꞌo koroino, nggale pinetotoako ka araisia henu metotoakeo koroino iwono nggale pinelangkai.” ");
INSERT INTO mzq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesu mepau la mia henu umundaꞌo, “Taꞌalu iiko mowowau rame-rame mowanda ara wongino, hooto undaiꞌiro poko-pokowalimu, peti-petiamu, ara petengi-tengi dohamu henu sugi, akono iworo mboꞌu ungga nggale ponsulo umundako mekule la rame-ramero. Taꞌalu liraꞌa, iiko mohawekoto ponsulo teꞌembu la meꞌambomu. ");
INSERT INTO mzq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Meꞌamboopo taꞌalu iiko mowowau rame-rame, undaꞌiroto mia henu mekarampini, mia henu salantuwu, mia henu pungku, ka mia morawu. ");
INSERT INTO mzq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Taꞌalu liraꞌa upowowau, Ue Ala nggale barakatiko, akono iworo kano hina pio-pioro nggale ro ponsulo meꞌambomu. Lowono raaꞌa nggale sinulo ndi iiko taꞌalu temponoto Ue Ala motuwuꞌo mekule lowono mia henu mentee.” ");
INSERT INTO mzq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Humoringo raaꞌa, aso mia teꞌembu la mia henu merongairo Iesu monggaa mepau, “Memeꞌurairoto suꞌu mia henu bisa monggaa merongairo Ue Ala taꞌalu Iworo hawe momparenta heleo Mokole.” ");
INSERT INTO mzq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kanggo Iesu mepau, “Hina aso mia mowowau rame-rame langkai, ka adio mia henu inundano. ");
INSERT INTO mzq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tempono rame-rame raaꞌa nggale pinamulaoto, iwono tumenaꞌo atano lumeko pauꞌakero la lowono mia henu inundano, ‘Maitoto, akono lowono pinasadiaꞌoto.’ ");
INSERT INTO mzq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kanggo loworo mpetengku kaloro mehawe la rame-rame raaꞌa. Henu aso mia mepau la ata raaꞌa, ‘Tabeamiu tokoa. Akono oleo neea iaku nggale lumeko mekanio wute henu da saraipo kuꞌolio.’ ");
INSERT INTO mzq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Henu mesueno mepau, ‘Tabeamiu tokoa. Kakulo bisa hawe, akono oleo neea iaku nggale lumeko umara-arahakeo olimo pasa sapi henu da saraipo kuꞌolio.’ ");
INSERT INTO mzq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Henu aso mia mboꞌu mepau, ‘Dahapo kuꞌumari metao, kakulo bisa mai.’ ");
INSERT INTO mzq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ata raaꞌa mekule ka pauꞌo lowono raaꞌa la ueno doha henu tumenaꞌo raaꞌa. Humoringo lowono raaꞌa, ueno doha raaꞌa tekuda takau ka tumenaꞌo atano, ‘Kerohoa leko la ansala langkai ka sampa-sampano ansala i laro inie, ka undaꞌiroto mia henu mekarampini, mia salantuwu, mia morawu ka mia pungku.’ ");
INSERT INTO mzq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Umari no wowauꞌo lowono raaꞌa, ata raaꞌa pauꞌakeo la ueno doha raaꞌa, ‘Lowono henu utenaꞌakune raaꞌa umarioto winowau. Kanggo maupono liraꞌa da adio petundaa henu molimbo.’ ");
INSERT INTO mzq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ueno doha raaꞌa mepau, ‘Ilekoto la lowono ansala langkai ka sampa-sampano ansala i bungku inie. Lowono mia henu utepotowoakeo, udadaꞌiro memai ranta kano buke dohanggu. ");
INSERT INTO mzq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iaku mepau ndi ikomiu, kano hina teꞌaso mia henu inunda amba-ambano nggale monggaa la rame-ramenggu neea.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Umari raaꞌa, adio mia merongairo Iesu la koleko-lekoꞌaro. Iesu mewalili ndi iworo ka mepau, ");
INSERT INTO mzq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Taꞌalu hina aso mia henu minggi tumonda Aku, ka iwono nopehohawaꞌopo ine umano, walino, ana-anano, peti-petiano ara koroino liono, iwono kanolo bisa gagi ana guruNggu. ");
INSERT INTO mzq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Araisia henu tai poli montanggumi marasaiꞌa ranta kano mate ka tumonda Aku, iwono kanolo bisa gagi ana guruNggu. ");
INSERT INTO mzq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tuduano hina aso mia henu mosongkapi mowangu doha medongke, matantuoto iwono metunda ari rumekeꞌo popio angkosono, kano toꞌorio koa ara sombo koa doino mowangu doha raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Akono taꞌalu kano rekeꞌo ari ongkosono, nggale mansa doino butu sombo hawe la pundasino, andono hina mboꞌu doi nggale no pakeꞌo lumiuakeo powangua doha raaꞌa. Pokotompaano lowono mia henu kumiteo, tumetewehio, ");
INSERT INTO mzq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ka mepau, ‘Mia neea mompamula mowangu doha, kanggo kano pokoliuakeo.’ ");
INSERT INTO mzq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Liraꞌa koamboꞌu, taꞌalu hina aso mokole mosongkapi lumeko metea saru mokole mesue. Matantuoto iwono metunda ari mompewowolo temeꞌambo, bisake sorodaduno henu hopulo sowu raꞌiroa bisa umewaꞌo mokole henu monaa sorodadu oruo mpulo sowu mia, ara aio. ");
INSERT INTO mzq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Taꞌalu kano pokoewaꞌo, matantu tempono uwelino da olai iwono nggale montena aso mia lumeko momoni posintuwua. ");
INSERT INTO mzq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Liraꞌato mboꞌu, sombo mia henu tai motolaho lowono henu hina ndi iworo, iworo karo bisa gagi ana guruNggu. ");
INSERT INTO mzq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ohio laano adio tinuduno. Kanggo, taꞌalu ohio raaꞌa gagi morini, matantuoto andono bisa mboꞌu pinokomeꞌohio. ");
INSERT INTO mzq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ohio raaꞌa andono bisa takau pinake i lere ara mompokomonuwo wute. Gagi, ohio raaꞌa asolekono tinadi. Isia henu mebiri, pehoringakeoto temeꞌambo opio henu pinauNggu raaꞌa!” ");
INSERT INTO mzq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aso tempo, heleo biasano adio to ponsinga sima ka mia tehala mai ndi Iesu mehoringakeo pompaguruNo. ");
INSERT INTO mzq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kumiteo raaꞌa, to Parisi ka mia mpande atora Taura pemburuki ka mepau, “Seꞌ, Iwono neea tumarimaꞌiro mia tehala ka monggaa meronga-ronga saru iworo.” ");
INSERT INTO mzq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Humoringo raaꞌa, Iesu mepau ndi iworo laꞌaso ande-ande mpau lenie, ");
INSERT INTO mzq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Taꞌalu hina aso mia monaa aso etu bimba ka aso tetadi, matantu no pobintairo bimbano henu osio mpulo ka osio raaꞌa la pada one, ka lumeko wusuꞌo henu tetadi raaꞌa ranta kano haweꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Taꞌalu no haweoto bimba raaꞌa, iwono sanaa takau ranta no poꞌahao la oweano ka no waweo mekule. ");
INSERT INTO mzq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kohaweno i doha, iwono moboiꞌiro pokowalino ka petengi-tengi dohano ka mepau ndi iworo, ‘Maito kato mpesana-sanaa, akono bimbanggu henu tetadi kuhaweꞌoto mekule.’ ");
INSERT INTO mzq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Gagi Iaku mepau ndi ikomiu, liraꞌa koamboꞌu malaꞌeka-malaꞌekaro Ue Ala i suruga. Mensanaairopo akono aso mia tehala mosea, sekonopo osio mpulo ka osio mia mentee henu tai momparalu moseaꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tuduano mboꞌu, hina aso erowai henu hina hopulo doi perano, ka aso pera tetadi. Matantu iwono nggale mompolanga palita ka rumoahio dohano wusuꞌo doino ranta kano haweꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Taꞌalu no haweꞌoto, iwono nggale moboiꞌiro pokowalino ka petengi-tengi dohano ka mepau ndi iworo, ‘Maito kato mpesana-sanaa, akono doi peranggu henu tetadi kuhaweꞌoto mekule.’ ");
INSERT INTO mzq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Liraꞌa koamboꞌu malaꞌeka-malaꞌekaro Ue Ala i suruga. Iworo nggale sanaa takau taꞌalu aso mia tehala mosea teꞌembu la halano.” ");
INSERT INTO mzq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu mepau mboꞌu, “Hina aso mia henu hina oruo anano, anano raꞌiroa pada tama. ");
INSERT INTO mzq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Henu tompasusu mongee la umano, ‘Uma, weiꞌakuneto aga-aga henu gagi tianggu.’ Gagi umano tumiaꞌo aga-agano la anano henu oruo raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Popio oleo teꞌembu rahea, ana henu tompasusu raaꞌa meꞌoliakeo lowo tiano ka lumeko la waawute henu olai. Ndepano nopokopinggoꞌo mpena doino ka tuwu montonda poꞌeheno ka mowowau henu mosaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Menseno lowono doino pinggo, Gagioto mokoninggoa la lowono waawute raaꞌa, ranta iwono mboꞌu mompamula masusa. ");
INSERT INTO mzq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pokotompaano, iwono lumeko moꞌangga laꞌaso mia i waawute raaꞌa. Mia raaꞌa tumenaꞌo lumeko i lereno kano pogagai boeno. ");
INSERT INTO mzq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Iwono mokoninggo takau ranta iwono minggi umihiiꞌo kompono saru paka boe. Maupono iwono mokoninggoto takau, kano hina teꞌaso mia henu moweiꞌakeo kaanga. ");
INSERT INTO mzq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pokotompaano no pokopewowoloꞌo pinogauno ka mepau i laro aroano, ‘Takau adio mia henu mpoꞌangga la umanggu ka mpohawe kaanga henu mpetotorea, kanggo iaku endea andono epie kaku mateako ninggo. ");
INSERT INTO mzq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lenie iaku nggale lumeko teꞌembu endea, mekule la umanggu ka iaku mepau ndi iwono, Uma, iaku tehala akuto ndi iworo Ue Ala ka ndi ikomiu. ");
INSERT INTO mzq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Iaku kano pototono mboꞌu gagi anamiu uma. Poꞌinengoto iaku gagi atamiu uma.’ ");
INSERT INTO mzq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Umari raaꞌa iwono lumeko la umano. Tempono iwono da olai, umano kumiteo. Meluarakoto pompehohawano umano, ka meripo tumotowoꞌo, kumopuiꞌo ka wowoongo. ");
INSERT INTO mzq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ka mepauꞌoto ana raaꞌa la umano, ‘Uma, tehala akuto ndi iworo Ue Ala ka ndi ikomiu. Iaku kano pototono mboꞌu nginee anamiu.’ ");
INSERT INTO mzq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kanggo umano mepau la atano raꞌiroa, ‘Waweo nderamai lemba henu takau meꞌambo ka pakeꞌakeo ndi iwono. Pasaꞌakeo sinsi la tonisono ka sapatu la ngkareno. ");
INSERT INTO mzq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ka aleo aso ana sapi henu monuwo, gereꞌakito, kato mengkaango mpesana-sanaa. ");
INSERT INTO mzq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Akono ananggu neea hele nggoto mate, kanggo tuwu mekule. Ananggu neea henu tetadi hinawe mekule.’ Umari raaꞌa mompamulairoto mporame-rame. ");
INSERT INTO mzq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tekonairo mporame-rame, anano henu kaka tekonai moꞌangga i lere. Tempono no pekule ka orambioto la dohano, no horingo unino silolu ka penaniro mia henu melumense. ");
INSERT INTO mzq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kanoamba no poboiꞌo aso mia atano ka mesikeno ndi iwono, ‘Tembio kano hina rame-rame i doha neea?’ ");
INSERT INTO mzq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ata raaꞌa sumangkio, ‘Andimu mekuleoto ka umamu mogere aso ana sapi henu monuwo, akono no haweoto mekule anano da motea-tea.’ ");
INSERT INTO mzq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Humoringo lowono raaꞌa, ana henu kaka raaꞌa gagi tekuda, ka kano poli mendamo i laro doha. Gagi umano hawe popandeiꞌo kano poli koa mendamo i laro doha. ");
INSERT INTO mzq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ana raaꞌa sumangkio umano, ‘Uma, mepetaꞌu-taꞌuoto iaku moꞌangga ndi ikomiu heleo atamiu ka amboku hori umewaꞌo petenamiu. Kanggo, ambo ihori moweiꞌaku aso ana bembe kaku pakeꞌo mpesana-sanaa saru poko-pokowalinggu. ");
INSERT INTO mzq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kanggo tempono anamiu henu mompinggo-pinggo aga-agamu saru erowai tehala mekule, ikomiu mogereꞌakeo ana sapi henu monuwo.’ ");
INSERT INTO mzq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Umano mepau, ‘Ananggu, iiko meronga mpihe saru iaku ka lowono aga-aganggu, aga-agamu mboꞌu. ");
INSERT INTO mzq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kanggo, oleo neea ikito asolekono mporame-rame ka mpesana-sanaa, akono andimu hele nggoto mate, kanggo tuwu mekule. Andimu neea henu tetadi hinawe mekule.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu mompau mboꞌu aso ande-ande mpau la ana guruNo raꞌiroa lenie, “Hina aso mia henu sugi henu hina aso mia puꞌu poꞌatora aga-agano. Puꞌu poꞌatora aga-aga raaꞌa tinuluri mompinggo-pinggo doino mia sugi raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mia sugi raaꞌa moboiꞌo puꞌu poꞌatora aga-aga raaꞌa ka mepau ndi iwono, ‘Iaku kaku sanaa humoringo kareba taꞌalu iiko mokompinggoꞌo mpena doinggu. Gagi, ukiꞌakuneto mongkono araꞌehende uꞌatoraꞌo aga-aganggu, akono mompuꞌu oleo neea andono iiko mboꞌu henu umatoraꞌo aga-aganggu.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Humoringo raaꞌa, puꞌu poꞌatora aga-aga raaꞌa mepau i laro aroano, ‘Opio henu bisa kuwowauꞌo? Akono uenggu mokompenao-naoꞌaku teꞌembu la anggaꞌanggu moꞌatora aga-agano. Iaku kaku pontuꞌai mobingku, iaku mokokoꞌii taꞌalu momoni-moni. ");
INSERT INTO mzq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kutoꞌorio pio henu kunggale wowauꞌo, kano hina koa mia henu tumarimaꞌaku la dohano taꞌalu temponoto uenggu mokompenao-naoꞌaku teꞌembu la mpoꞌanggaꞌanggu.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Umari raaꞌa no poboiꞌo lowono mia henu mepasua la ueno. Iwono mesikeno la mia henu hawe amba-ambano, ‘Popio pasuamu la uenggu?’ ");
INSERT INTO mzq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mia raaꞌa sumangki, ‘Aso etu loia boka.’ Umari raaꞌa no pongeeꞌakeo, ‘Nooto sura pasua. Kerahoa petunda ka ukiꞌoto mekule sura pasuamu henu baru mongee iiko mepasua lima mpulo loia.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Umari raaꞌa iwono mesikeno la mia mesue, ‘Araꞌehende iiko? Popio adiono pasuamu la uenggu?’ Mia raaꞌa sumangki, ‘Aso etu karu gandu.’ Iwono mepau la mia raaꞌa, ‘Nooto sura pasua, ukiꞌo mekule pasuamu gagi halu mpulo karu gandu.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Humoringo pio henu no powowau puꞌu poꞌatora aga-aga henu tai mentee raaꞌa, ueno raaꞌa umunde-undeꞌo akono iwono adio akalano.” Umari raaꞌa Iesu mepau, “Biasa laano mia henu tumondaꞌo gau i wawontolino neea, iworo pandeiropo umatoraꞌo urusuꞌaro sekonopo mia henu tuwu laro wanta. ");
INSERT INTO mzq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iaku mepau ndi ikomiu, pakeꞌoto sugi i wawontolino neea montulungi mia mesue kano adio pokowalimu. Taꞌalu sugi i wawontolino pinggooto, Ue Ala ungga nggale tumarima komiu la mpoꞌianga henu inggale mpoꞌiangario ranta pokotompaano.” ");
INSERT INTO mzq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Araisia henu pineꞌalo-alo la urusuꞌa henu motutu, bisa mboꞌu pineꞌalo-alo la urusuꞌa henu langkai. Ka araisia henu tai pineꞌalo-alo la urusuꞌa henu motutu, kano bisa mboꞌu pineꞌalo-alo la urusuꞌa henu langkai. ");
INSERT INTO mzq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Gagi, taꞌalu ikomiu kai pineꞌalo-alo moꞌurusu sugi i wawontolino henu mosaꞌa neea, matantuoto kano hina mia henu meꞌalo-alo komiu moꞌurusu sugi henu menteeꞌano. ");
INSERT INTO mzq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka taꞌalu ikomiu tai pineꞌalo-alo moꞌurusu aga-agaro mia mesue, matantuoto kanolo hina mia henu poli moweiꞌakomiu aga-aga kano gagi aga-agamiu. ");
INSERT INTO mzq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kano hina aso ata bisa moꞌangga la oruo ueno, akono henu aso teꞌingga no oꞌalieꞌakeo ka henu aso no pehohawaꞌo. Ara iwono teꞌingga metenunu laꞌaso mia ka henu mesueno kano periongo. Ikomiu kailo bisa moꞌangga ndi iworo Ue Ala ka mboꞌu moꞌangga ka mohawe sugi i wawontolino neea.” ");
INSERT INTO mzq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tempono iworo mehoringo lowono raaꞌa to Parisi pototahio Iesu akono iworo inehero doi. ");
INSERT INTO mzq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kanggo Iesu mepau ndi iworo, “Ikomiu mokomenteeꞌo koroimiu i aroro mia, kanggo Ue Ala tumoꞌorio pio henu i laro aroamiu, akono arapio henu inunde-undero mia, Ro alieꞌakeo Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Atora Taura ka Wuntaro nabi-nabi pinalele ranta Iohane to pobaho hawe. Mompuꞌu haweano Iohane to pobaho, pinaleleꞌako Kareba Meꞌambo mongkono Poparentaro Ue Ala, ka lowono mia mpeꞌusaha karo megagi bawaa i laro Poparentaro Ue Ala raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kanggo, atora Taura ka Wuntaro nabi-nabi kongkono pihe pinake. Moruanaopo langi ka wawontolino no tetadi sekono aso hurupu teꞌembu la atora Taura tetadi. ");
INSERT INTO mzq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sombo mia henu tumadio walino ka moꞌalo mboꞌu erowai mesue, iwono raaꞌa monsosabo. Ka sombo mia henu moꞌalo erowai henu no tadio walino, iwono mboꞌu monsosabo.” ");
INSERT INTO mzq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Hina aso mia henu sugi, pia meparewa lemba ungu ka bana molusa. Iwono tuwu sanaa i laro sugino sombo oleo. ");
INSERT INTO mzq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka hina mboꞌu aso mia henu mokokolaro mengengako i Lasaru, memboleako orambi la panganso dohano mia sugi raaꞌa. Koroino i Lasaru bukeako kowo, ");
INSERT INTO mzq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ka iwono minggi montadi mokoninggono saru kaanga torea henu tedontai teꞌembu la mejano mia sugi raaꞌa. Ka dahu mehawe mensilaꞌeo kowono. ");
INSERT INTO mzq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kanoamba mia mokokolaro raaꞌa mate, ka penaono ro waweo malaꞌeka-malaꞌekaro Ue Ala orambi ndi Burahima. Ambono epie teꞌembu rahea, mateoto mboꞌu mia sugi raaꞌa ka kinaburu. ");
INSERT INTO mzq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","La poꞌiangaro mia mate, mia sugi raaꞌa marasai takau. Ka tempono mensoꞌa i wawono, no kiteo i Burahima teꞌembu olai ka i Lasaru metunda i horino. ");
INSERT INTO mzq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iwono umoraꞌako ndi Burahima, no pongee lenie, ‘Uma Burahima pehohawaꞌaku. Tenaꞌo i Lasaru kano emoakune tompa tonisono la uwoi ka mokomoriniꞌakune elonggu, akono iaku mompemarasai akuto lahi laro apui neea.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kanggo i Burahima mepau, ‘Ananggu, pewowoloꞌo tempono utuwu i wawontolino, iiko pinoweikoto henu meꞌambo kanggo i Lasaru mohawe lowono henu mosaꞌa. Lenie neea i Lasaru pinokonsanaa kanggo iiko pinokomarasai. ");
INSERT INTO mzq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kano butu raaꞌa, ikami ka iiko mboꞌu noꞌolosio wingke henu malua ka onalo takau, ranta mia henu minggi mesaki teꞌembu endea lumeko ndi iiko, iworo karo pokopesaki. Liraꞌa koamboꞌu kano hina teꞌaso mia henu bisa mesaki teꞌembu rahea mai ndi ikami.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Umari raaꞌa iwono mepau, ‘Taꞌalu lesie, kupomonio ndi iiko uma, tenaꞌoto i Lasaru lumeko la dohano umanggu, ");
INSERT INTO mzq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","akono da hina olimo mia petianggu. Iwono asolekono pauꞌakero laano, karo hooto mendamo i laro poꞌianga henu marasai neea.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","I Burahima mepau, ‘Ndi iworo hina wunta inukino i Musa ka nabi-nabi. Poꞌinengiroto ro mentondaꞌo pompaguru i laro wunta raaꞌa.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Iwono sumangki, ‘Umanggu Burahima, seea kano sombo. Kanggo taꞌalu hina mia henu tuwu mekule teꞌembu la mateano lumeko pauꞌakero, iworo nggale mosea teꞌembu la halaro.’ ");
INSERT INTO mzq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kanggo i Burahima mepau, ‘Taꞌalu iworo karo mpehoringakeo pio henu pinauno i Musa ka nabi-nabi, iworo mboꞌu karo pompeꞌalo-alo maupono hina mia henu tuwu mekule teꞌembu la matea lumeko pauꞌakero.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu mepau la ana guruNo, “Matantuoto nggale hina mia henu mompososaelo mia mesue i laro hala, kanggo masolaoto mia henu mowowau liraꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Meꞌamboopo weꞌuno mia raaꞌa pinodoe-doehako wasu pogiliꞌa henu langkai kanoamba pinotondu laro tahi. Meꞌamboopo liraꞌa kaindono iwono mompososaelo aaso mia teꞌembu la mia henu molusa pompeꞌalo-alono ndi Iaku. ");
INSERT INTO mzq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hoꞌioto puꞌuno, petangkoroto! Taꞌalu peꞌaso pompeꞌalo-alomu mowowau hala ndi iiko, pompauꞌakeo. Taꞌalu iwono meꞌoꞌole ampuniꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Taꞌalu i larono aso oleo menggoꞌopisu no powowau hala ndi iiko, ka menggoꞌopisu mboꞌu no hawe ndi iiko mongee, ‘Iaku meꞌoꞌoleakuto.’ Iiko asolekono umampuniꞌo.” ");
INSERT INTO mzq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Umari raaꞌa, rasulNo raꞌiroa mpepau ndi Iwono, “Ue, pokomorosoꞌo mboꞌu pompeꞌalo-alomami.” ");
INSERT INTO mzq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sumangkiiro i Ue, “Taꞌalu pompeꞌalo-alomiu heleo wuku mpahoꞌa henu takau motutu tokoa, ikomiu bisa mpepau la puꞌu ara neea, ‘Utewekato, ka utepaho i laro tahi!’ Puꞌuno ara raaꞌa matantu tumondaꞌo paumiu.” ");
INSERT INTO mzq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tuduano hina aso mia teꞌembu ndi ikomiu monaa aso mia ata henu monteko ara mompakambi pinotuwu. Menseno atano raaꞌa mekule teꞌembu la poꞌanggaꞌano, matantuoto kailo mepau ndi iwono lenie, ‘Maito, kerahoa ponggaa.’ ");
INSERT INTO mzq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kanggo ikomiu teꞌingga nggale mepau lenie, ‘Pasadiaꞌakune ari kaanganggu, euꞌoto parewamu ka sikori akuto hawe kaku umari. Umari raaꞌa kau amba bisa monggaa ka moꞌenu.’ ");
INSERT INTO mzq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ikomiu kailo montarimakasi la ata raaꞌa taꞌalu iwono tumondaꞌo pio henu notinenaꞌako. ");
INSERT INTO mzq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Liraꞌato mboꞌu ikomiu. Taꞌalu imentondaꞌoto lowono henu imentinenaꞌako, ikomiu asolekono mepau, ‘Ikami neea ata henu kano hina tinuduno. Ikami butu mewowauꞌo pio henu asolekono kimewowauꞌo.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","La ngkoleko-lekoꞌaro Iesu lumeko i Ierusale, Iesu lumiungo tida inie Samaria ka Galilea. ");
INSERT INTO mzq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Menseno Iesu mewunsokio aso inie, hopulo mia henu mahaki melowe lumeko tumotowoꞌIro. Iworo mpoꞌia mpentada ola-olai ");
INSERT INTO mzq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ka koꞌora-ora, “Iesu, Guru! Ipehohawa kami!” ");
INSERT INTO mzq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu mekokaniiro ka mepau, “Imelekoto la puꞌu petewawo pesomba ka momonio karo pekokaanio koroimiu.” Ka tekonairo koa i tonga nsala, tompaoto haki lowero. ");
INSERT INTO mzq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aso mia teꞌembu ndi iworo menseno kumiteo hakino tompaoto, iwono mekule ndi Iesu ka koꞌora-ora umunde-undeꞌiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tempono hawe i aroro Iesu, iwono menggoluntu ka montarimakasi ndi Iworo. Mia raaꞌa to Samaria. ");
INSERT INTO mzq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Umari raaꞌa Iesu mepau, “Hopuloꞌiro mia hieno henu pinokotompa. Lumeko nderioke henu osioꞌiro raꞌiroa? ");
INSERT INTO mzq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tembio butu mia kano to Iahudi henu hawe mboꞌu umunde-undeꞌiro Ue Ala?” ");
INSERT INTO mzq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Umari raaꞌa Iesu mepau la mia raaꞌa, “Pentadato ka lekoto. Iiko tompa akono iiko mompeꞌalo-alo ndi Iaku.” ");
INSERT INTO mzq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Popioꞌiro to Parisi mpesikeno ndi Iesu, “Arateꞌepie Ue Ala hawe momparenta i wawontolino?” Sumangki Iesu, “Poparentaro Ue Ala kano pinamula saru tondoni henu bisa kinito. ");
INSERT INTO mzq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kano hina mboꞌu teꞌaso mia bisa pokompepau, ‘Kiteo, Iwono endeaꞌo!’ Ara, ‘Ndepano Iwono!’ Akono menteeꞌano Ue Ala mompamulairoto momparenta i olomiu.” ");
INSERT INTO mzq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Umari raaꞌa Iesu mepau la ana guruNo, “Hina tempono ikomiu minggi merasaiꞌo teꞌaso oleo teꞌembu la tempono Ana Manusia henu hawe teꞌembu ndi Iworo Ue Ala nggale momparenta, kanggo ikomiu kailo merasaiꞌo oleo raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ka hina mia nggale mepau ndi ikomiu, ‘Kiteo, Iwono ndepanoꞌo!’ Ara, ‘Iwono endeaꞌo!’ Kanggo hooto mpeꞌale-aleo henu pinauro ka hooto imentondaꞌiro lumeko kumiteo pio henu pinauro. ");
INSERT INTO mzq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Akono menggena heleo koliki tesangkilo teꞌembu i tompano langi henu aaso la tompano langi henu mesue, liraꞌato mboꞌu ungga haweꞌaro mekule Ana Manusia imengkiteo. ");
INSERT INTO mzq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kanggo ambono gagi lowono raaꞌa, Iwono asolekono montanggumi adio marasaiꞌa ka mia henu tuwu lenie neea karo mentarimaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Araꞌehende gauro mia tempono i Noho da tuwu, liraꞌato mboꞌu gauro mia taꞌalu oleono Ana Manusia hawe mekule. ");
INSERT INTO mzq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iworo mponggaa ka mpoꞌenu, metao ka mempinopotao, hawe kano mpewunso i Noho la ngkapala. Umari raaꞌa hawe lolowi henu motonduꞌo wawontolino ka mokoropuꞌiro. ");
INSERT INTO mzq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Liraꞌa mboꞌu gauro mia i waawute Sodomo tempono i Loꞌoti da tuwu. Iworo mponggaa ka mpoꞌenu, iworo mpoꞌoli ka pompeꞌoliako, iworo pompaho ka mpowangu doha. ");
INSERT INTO mzq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kanggo, tempono i Loꞌoti meluarako teꞌembu i Sodomo, apui ka belerang bingkosako tii heleo use teꞌembu i langi ka mokoropuꞌiro lowo mia. ");
INSERT INTO mzq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Liraꞌa koamboꞌu gauro mia taꞌalu Ana Manusia hawe mekule. ");
INSERT INTO mzq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tempo raaꞌa, isia henu tekonai i wawono atono dohano, hiaꞌato mboꞌu no petii umaleo aga-agano i laro doha. Liraꞌa koamboꞌu mia henu tekonai moꞌangga i lere, hiaꞌato mboꞌu no pekule i dohano moꞌalo aga-agano. ");
INSERT INTO mzq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Impewowoloꞌo pio henu gagi la walino i Loꞌoti! ");
INSERT INTO mzq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Araisia henu meꞌusaha kumaduduiꞌo tinuwuno, iwono nggale tetadi tinuwuno. Ka araisia henu tetadi tinuwuno akono tumondaꞌiro Ue Ala, iwono nggale kinadudui. ");
INSERT INTO mzq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iaku mepau ndi ikomiu, taꞌalu wongi hina oruo mia moturi laꞌaso poturia, henu aso mia winawo ka henu mesue pinobinta. ");
INSERT INTO mzq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Taꞌalu hina oruo erowai meronga-ronga mogili pae, henu aaso winawo ka henu mesue pinobinta. ");
INSERT INTO mzq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Taꞌalu hina oruo mia i lere, henu aaso winawo ka henu mesue pinobinta.” ");
INSERT INTO mzq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Umari raaꞌa ana guruNo mpesikeno ndi Iesu, “Ue, inderio ungga henu liraꞌa no nggale gagi?” Sumangki Iesu, “Inderio henu hina pinotuwu mate, rahea pepumpu paa-paa mponggaa.” ");
INSERT INTO mzq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu mompauꞌakero ana guruNo aso ande-ande mpau karo hooto meꞌotu-otu mpekakai. ");
INSERT INTO mzq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","No pongee, “Hina aso puꞌu pobitara moꞌia laꞌaso waawute. Iwono kano doito ndi Iworo Ue Ala ka kano hina teꞌaso mia henu no pelangkaiꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","I waawute raaꞌa mboꞌu, hina aso tuwu erowai henu pia hawe la puꞌu pobitara raaꞌa ka mepau, ‘Tulungi aku umaropio ewanggu henu mokorugiꞌaku.’ ");
INSERT INTO mzq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Menggopopioꞌakoto puꞌu pobitara raaꞌa kano poli tumulungio. Kanggo, koꞌepi-epieno iwono mepau i laro aroano lenie, ‘Maupono kaku doito ndi iworo Ue Ala ka kano hina teꞌaso mia kupelangkaiꞌo, ");
INSERT INTO mzq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kanggo tuwu erowai raaꞌa hawe mpihe mokomasusaꞌaku. Meꞌamboopo kutulungio umutuhio pebitaraꞌaro, kano hooto no mai mpihe mokomasusaꞌaku.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Umari raaꞌa Ue Iesu mepau, “Pehoringakeo temeꞌambo pio henu pinauno puꞌu pobitara henu tai meꞌambo raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gagi, puꞌu pobitara henu tai meꞌambo raaꞌa umehe tumulungio pebitaraꞌano tuwu erowai raaꞌa, liraꞌa mboꞌu Ue Ala matantu nggale tumulungiiro mia henu tinimakiNo henu mekakai ndi Iworo mowanda ka wongi. Iwono kanolo montadi-tadi tempo tumulungiiro. ");
INSERT INTO mzq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iaku mepau ndi ikomiu, Ue Ala nggale ronga mokomenteeꞌiro! Kanggo, taꞌalu Ana Manusia hawe, hinake pompeꞌalo-alo ndi Iworo henu No haweꞌo i wawontolino neea?” ");
INSERT INTO mzq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesu mompau aso ande-ande mpau la mia henu rumekeꞌo koroino mentee ka mompeꞌuru-uru mia mesue lenie, ");
INSERT INTO mzq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Hina oruo mia lumeko mekakai i Doharo Ue Ala. Aso mia to Parisi ka aso mia to ponsinga sima. ");
INSERT INTO mzq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","To Parisi raaꞌa mentada ka mekakai i laro aroano, ‘Ue Ala, iaku montarimakasi ndi Ikomiu, akono kaku penggena ka mia mesue: heleo mia monako, henu kano mentee pinogauro, ka mia monsosabo. Iaku montarimakasi ndi Ikomiu akono iaku mboꞌu kaku penggena heleo to ponsinga sima raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iaku mepuasa menggoruo i laro aso minggu ka iaku mompowei hopulo persee teꞌembu la hinawenggu.’ ");
INSERT INTO mzq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kanggo to ponsinga sima raaꞌa mentada ola-olai, ka kano taha mensoꞌa i langi. No pede-pedehio radano akono iwono meꞌoꞌole i laro aroano ka mepau, ‘Ue Ala, iaku neea mia tehala. Pehohawaꞌaku.’ ");
INSERT INTO mzq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iaku mepau ndi ikomiu, ‘Tempono mekule i doha, to ponsinga sima raaꞌa henu pinokomenteero Ue Ala, kanggo to Parisi raaꞌa kano pinokomentee. Akono araisia henu melangkaiꞌo koroino, iwono nggale pinetotoako. Araisia henu metotoakeo koroino, iwono nggale pinelangkai.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Popioꞌiro mia mpowawo ana-ana motutu ndi Iworo Iesu, karo ini-iniꞌiro ka barakatiꞌiro. Kanggo kumiteo raaꞌa, ana guruNo raꞌiroa mentekudaꞌakero mia raꞌiroa. ");
INSERT INTO mzq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kanggo Iesu moboiꞌiro ana-ana raꞌiroa ka mepau la ana guruNo raꞌiroa, “Poꞌinengiroto ana-ana raꞌiroa mai ndi Iaku, hooto imeꞌontoiro, akono mia heleo iworoto henu nggale gagi bawaaro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Menteeꞌano Kupauꞌakomiu, araisia henu kano tarimaꞌo Poparentaro Ue Ala heleo ana motutu, iwono kano pototono gagi bawaaro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aso mia puꞌu petewawono to Iahudi mesikeno ndi Iesu, “Guru henu meꞌambo, opio henu asolekono kupowowau kaku pohawe koa tuwuꞌa henu tai hina tampulaano?” ");
INSERT INTO mzq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu mepau ndi iwono, “Tembio kau pongee meꞌambo Iaku? Kano hina teꞌaso mia henu meꞌambo. Butukoa iworo Ue Ala henu meꞌambo. ");
INSERT INTO mzq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Iiko tumoꞌorio lowono parentaro Ue Ala, ‘Hooto ponsosabo, hooto pompepate, hooto ponako, hooto pongkota i arono puꞌu pobitara, pelangkaiꞌiro umamu ka inemu.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mia raaꞌa sumangki, “Lowono raaꞌa kutondaoto teꞌembu ku da monguro.” ");
INSERT INTO mzq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Umarino Iesu humoringo sangkino raaꞌa, No pepau ndi iwono, “Aso rupapo mboꞌu henu asolekono upowowau. Peꞌoliakeo lowono aga-agamu ka doino utia-tiaꞌakero la mia mokokolaro kau pohawe koa aga-aga i suruga. Umari raaꞌa maitoto tonda Aku.” ");
INSERT INTO mzq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kanggo umarino no horingo pio henu pinauNo Iesu, gagi masusa aroano akono iwono sugi takau. ");
INSERT INTO mzq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu kumiteo ka mepau, “Takau mapari mia sugi gagi bawaa i laro Poparentaro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Moruanaopo aso unta mewunso la aano supe sekonopo mia sugi gagi bawaa i laro Poparentaro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iworo henu mehoringo raaꞌa mesikeno ndi Iesu, “Taꞌalu liraꞌa isia henu nggale kinadudui?” ");
INSERT INTO mzq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sumangki Iesu, “Opio henu kano bisa wowauꞌo mia, bisa Ro wowauꞌo Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","I Peturu mepau, “Ehende ikami? Lowoakoano kipobintaoto ka tumonda Komiu.” ");
INSERT INTO mzq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Sumangki Iesu, “Menteeꞌano Kupauꞌakomiu suꞌu, lowono mia henu mobintao dohano, walino, petia-petiano, mia mosuꞌono ka ana-anano akono Poparentaro Ue Ala, ");
INSERT INTO mzq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nggale mohawe mekule lenie neea adioopo ka henu no pobintao. Ka la tempo henu nggale hawe ungga kongkono koa mohawe tuwuꞌa henu tai hina tampulaano.” ");
INSERT INTO mzq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu moboiꞌiro ana guruNo henu hopulo ka oruo mia ka mepau ndi iworo, “Pehoringakeo, ikito neea i laro koleko-lekoꞌa lumeko Ierusale, ka lowono henu inukiro nabi-nabi mongkono Ana Manusia matantu inihii. ");
INSERT INTO mzq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iwono ungga nggale pinewengako la mia kano to Iahudi karo mpepali-palindoꞌakeo, tumataꞌo ka meꞌonuiꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ka iworo teꞌingga nggale mensepiꞌo ka mepateo. Kanggo la oleo koꞌotoluno Iwono nggale tuwu mekule.” ");
INSERT INTO mzq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lowono raaꞌa karo mentoꞌorio ana guruNo. Pengkonoano henu pinauNo tewuni ndi iworo, hoꞌioto puꞌuno karo mentoꞌorio opio henu ngineeNo raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tempono Iesu orambioto hawe Ieriko, hina aso mia morawu metunda i wiwi ansala tekonai momoni-moni. ");
INSERT INTO mzq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tempono mia morawu raaꞌa humoringo mia adio teliu, iwono mesikeno, “Opio henu gagi?” ");
INSERT INTO mzq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Iworo mpepau ndi iwono, “Iesu to Nasare raaꞌa teliu.” ");
INSERT INTO mzq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mia morawu raaꞌa koꞌora-ora no pongee, “Iesu, inuleno mokole Daudi, pehohawaꞌaku!” ");
INSERT INTO mzq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mia henu teleꞌeru koleko-leko i arono umontoo ka tumenaꞌo komino. Kanggo sani komoko-mokorano no koꞌora-ora no pongee, “Iesu, inuleno mokole Daudi pehohawaꞌaku!” ");
INSERT INTO mzq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Humoringo no koꞌora-ora, menao-naoꞌiroto Iesu ka tumenaꞌiro mia waweo mia morawu raaꞌa ndi Iwono. Tempono mia morawu raaꞌa orambioto ndi Iesu, Iesu mesikeno ndi iwono, ");
INSERT INTO mzq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Opio henu inehemu Kupowowau ndi iiko?” Sumangki mia morawu raaꞌa, “Ue, henu inehenggu kaku bisa koa menggito!” ");
INSERT INTO mzq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kanoamba Iesu mepau ndi iwono, “Upenggitoto! Matamu tompaoto akono pompeꞌalo-alomu ndi Iaku.” ");
INSERT INTO mzq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tempo koa raaꞌa mboꞌu mia morawu raaꞌa mokopenggitooto, ka tumondaꞌiro Iesu ka umunde-undeꞌiro Ue Ala. Lowono mia henu mengkiteo raaꞌa umunde-undeꞌiro Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tempono Iesu mendamo i waawute Ieriko, Iwono koleko-leko mpihe lumiungo waawute raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Rahea hina aso mia puꞌu petewawo to ponsinga sima henu sugi ngeeno i Sakeu. ");
INSERT INTO mzq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iwono ineheno takau kumiteo Iesu, kanggo iwono kano pokokiteꞌIro akono iwono owundu ka adio mia pepumpu koleko-leko orambi ndi Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gagi, iwono meripo meleꞌeruiꞌiro mia adio, ka momone la mpuꞌu kau ara, kano kiteokoa Iesu taꞌalu teliu rahea. ");
INSERT INTO mzq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tempono Iesu hawe la mpuꞌu kau pomoneꞌano i Sakeu, Iworo menggito i wawono ka mepau ndi iwono, “Sakeu, kerohoa petii, akono oleo neea Iaku nggale merato i dohamu.” ");
INSERT INTO mzq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Rongaoto metii i Sakeu ka tumarimaꞌiro Iesu i dohano saru aroa sanaa. ");
INSERT INTO mzq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Temporo i dohano, lowono mia henu kumiteo Iesu lumeko i dohano i Sakeu, iworo mpemburuki ka mepau, “Tembio kano leko moturi la dohano mia tehala?” ");
INSERT INTO mzq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kanggo Sakeu mentada ka mepau ndi iworo Ue Iesu, “Ue, aso ntia aga-aganggu nggale kutia-tiaꞌakero la mia mokokolaro. Taꞌalu hina aga-agano mia henu kualongkoraꞌo, kunggale weiꞌakeo mekule meluka ompa adiono.” ");
INSERT INTO mzq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu mepau, “Oleo neea, haweoto tekaduduiꞌa ndi iiko ka peꞌaso dohamu, akono mia neea mboꞌu inuleno i Burahima. ");
INSERT INTO mzq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Akono Ana Manusia hawe mowusu henu tesosaelo ka kumaduduiꞌiro.” ");
INSERT INTO mzq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tekonairo mia da mpehoringakeo Iesu, Iesu lumiuakeo pauNo laꞌaso ande-ande mpau. TinunggaiNo Iesu mompauꞌakero ande-ande mpau raaꞌa, akono Iwono orambioto Ierusale, ka mia ngkolaro-laro, taꞌalu Ue Ala nggale ronga momparenta i wawontolino. ");
INSERT INTO mzq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hoꞌioto puꞌuno Iesu mepau, “Aso mia henu pinelangkai lumeko la inie henu olai, kano pinotoro gagi mokole. Umari raaꞌa mekuleoto momparenta i inieno. ");
INSERT INTO mzq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ambono leko, no poboiꞌiro hopulo atano ka no weiꞌakero sombo mia aso lempe doi wulaa ka no pongee, ‘Pakeꞌo doi neea mebalu-balu ranta kaku pekule. Umari raaꞌa lumekooto mia pinelangkai raaꞌa.’ ");
INSERT INTO mzq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kanggo mia adio la mpeꞌaso inieno meꞌoꞌalieꞌakeo ka iworo montena mia tinena lumeko i inie henu olai raaꞌa kano pepau la mokole langkai lenie, ‘Ikami kaki mempoliꞌo mia neea gagi mokole mami!’ ");
INSERT INTO mzq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Menseno pinotoro gagi mokole, iwono mekule i inieno. No tenaꞌo atano moboiꞌiro atano henu hopulo mia raꞌiroa henu pinoweino doi raaꞌa, kano toꞌorio koa popioto saro henu ro mehaweꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ata henu amba hawe mepau, ‘Ue, aso lempe doi wulaa henu iweiꞌaku kupeꞌusahaꞌakoto ka mpohaweꞌako hopulo lempe.’ ");
INSERT INTO mzq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ueno raaꞌa mepau, ‘Meꞌambo suꞌu winowaumu raaꞌa! Iiko neea ata henu meꞌambo! Upopokiteoto taꞌalu iiko pineꞌalo-alo la urusuꞌa henu motutu. Gagi, kuweiꞌakomuto pompeꞌalo-alo momparenta hopulo inie.’ ");
INSERT INTO mzq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Umari raaꞌa ata henu koꞌoruo hawe ka mepau, ‘Ue, aso lempe doi wulaa henu iweiꞌaku kupeꞌusahaꞌakoto ka mpohaweꞌako olimo lempe.’ ");
INSERT INTO mzq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ueno raaꞌa mepau mboꞌu ndi iwono, ‘Iiko mboꞌu kuweiꞌakomu pompeꞌalo-alo momparenta olimo inie.’ ");
INSERT INTO mzq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Umari raaꞌa, ata henu mesue hawe ka mepau, ‘Ue, kiteo, nototo doi wulaamiu, ku tongoho la lenso. ");
INSERT INTO mzq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Akono kudoitoꞌakomiu. Ikomiu mia masii. Ikomiu moꞌalo opio henu kai hori numaꞌo ka ikomiu moꞌopu opio henu kai hori pahoꞌo.’ ");
INSERT INTO mzq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ueno raaꞌa mepau, ‘Iiko ata henu mosaꞌa gaumu, iaku asolekono humukuko montonda pinaumu. Utoꞌoriokoa mongee iaku neea mia masii. Iaku umaleo opio henu kaku hori numaꞌo ka moꞌopu opio henu kaku hori pahoꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Taꞌalu liraꞌa, tembio doinggu raaꞌa kau tai weiꞌakero la mia henu moꞌangga mompopobunga doi, kano taꞌalu mekuleakuto kutarimaꞌo mekule saru bungano?’ ");
INSERT INTO mzq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Umari raaꞌa uero raaꞌa mepau la atano raꞌiroa henu mpentada rahea, ‘Aleoto mekule doi wulaa henu aso lempe raaꞌa teꞌembu ndi iwono ka weiꞌakeo la ata henu mompeꞌue hopulo lempe doi wulaa raaꞌa.’ ");
INSERT INTO mzq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sumangki ata raꞌiroa, ‘Ue, hinaoto ndi iwono hopulo doi wulaa, tembio kano tinambai mboꞌu?’ ");
INSERT INTO mzq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ueno raaꞌa mepau, ‘Iaku mepau ndi ikomiu, sombo mia henu mompeꞌue arapio, iwono pinoweiꞌako mboꞌu. Ka sombo mia henu butu mompeꞌue teꞌesi, henu teꞌesi raaꞌa inalo mboꞌu teꞌembu ndi iwono. ");
INSERT INTO mzq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kanggo uwelinggu henu karo poliꞌaku gagi mokolero, waweiro nderamai ka pepateiro i aronggu!’ ” ");
INSERT INTO mzq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Umarino Iesu pauꞌo lowono raaꞌa, No liuakeoto koleko-lekoꞌaro lumeko Ierusale. Iwono koleko-leko teleꞌeruꞌakero ka mia henu perongaNo tumondaiꞌiro. ");
INSERT INTO mzq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tempono Iesu orambi i Bepage ka Betania henu moꞌia laꞌaso toruku henu mengeengako tamungku Saitu, Iesu tumenaꞌiro oruo ana guruNo, ");
INSERT INTO mzq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","No pongeeꞌakero, “Lekoto i inie henu i arondo raaꞌa. Tempomiu mewunso i inie, ikomiu teꞌingga mohawe aso anano kalide henu teꞌonggo, kalide raaꞌa ambono hori no pesawikio mia. Potolaho kalide raaꞌa ka waweo nderamai. ");
INSERT INTO mzq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Taꞌalu hina mia mesikeno ndi ikomiu, ‘Tembio kai potolaho kalide raaꞌa?’ Sangkio lenie, ‘Ue Ala paraluꞌo kalide neea.’ ” ");
INSERT INTO mzq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Umari raaꞌa, lumekoiroto oruo ana guruNo raꞌiroa, ro mehaweꞌo lowono menggena heleo opio henu pinauro Iesu ndi iworo. ");
INSERT INTO mzq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Temporo motolaho kalide raaꞌa, ueno kalide raaꞌa mepau ndi iworo, “Tembio kai potolaho kalide raaꞌa?” ");
INSERT INTO mzq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iworo sumangki, “Iworo i Ue paraluꞌo.” ");
INSERT INTO mzq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Umari raaꞌa ro waweo kalide raaꞌa ndi Iesu, ro menaaꞌo lemba mentaa i wawono kalide raaꞌa ka tumulungiiro Iesu mewueꞌako i wawono kalide raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tekonairo Iesu mesawi la kalide raaꞌa, mia raꞌiroa mewolaꞌo lemba mentaaro la ansala. ");
INSERT INTO mzq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tempono Iesu orambi Ierusale, la ansala montindulu teꞌembu i tamungku Saitu, lowono mia henu tumondaꞌIro memawongko ka umunde-undeꞌiro Ue Ala akono lowono henu kombaaꞌakoa henu ro mengkiteo. ");
INSERT INTO mzq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iworo mpongee, “Binarakatiiroto Mokole henu hawe gagi ataro Ue Ala! Mesintuwu karodoaꞌiroto Ue Ala ka mia. Inunde-undeꞌiroto Ue Ala la mpoꞌianga henu i wawono takau!” ");
INSERT INTO mzq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Umari raaꞌa, popioꞌiro to Parisi teꞌembu i oloro mia adio raaꞌa mepau ndi Iesu, “Guru, tenaꞌiro ana guruMiu komino.” ");
INSERT INTO mzq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sumangki Iesu, “Iaku mepau ndi ikomiu, taꞌalu iworo mengkomino, wasu neeroa nggale koꞌora-ora umunde-unde Aku.” ");
INSERT INTO mzq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Menseno Iesu orambiiroto Ierusale, No baꞌieꞌakeo inie langkai raaꞌa, ");
INSERT INTO mzq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","No pongee, “Ikomiu mia Ierusale, meꞌambo takau taꞌalu imentoꞌorio oleo neea pio henu mowei komiu Sintuwu karodoa! Kanggo lowono raaꞌa ikomiu kai mentoꞌorio. ");
INSERT INTO mzq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nggale hawe tempono uwelimiu kumadu komiu ka mowowau pobente bolili komiu. Iworo nggale sumapoi komiu mpihe teꞌembu la sombo siuno. ");
INSERT INTO mzq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Iworo nggale mokoropuꞌo iniemiu ka iworo nggale mepate komiu. Kano hina teꞌaso tokoa wasu pinoꞌinee teꞌapi saru wasu mesue, akono kai mentoꞌorio tempono Ue Ala hawe kumadudui komiu.” ");
INSERT INTO mzq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Umari raaꞌa Iesu mewunso i tompa Doharo Ue Ala, No saariiro mia henu mpebalu-balu rahea. ");
INSERT INTO mzq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","No pongee ndi iworo, “Hina teꞌuki la Wunta Mempori lenie, ‘DohaNggu, doha pekakaiꞌa, kanggo ipokogagio poꞌiangaro mia mponako!’ ” ");
INSERT INTO mzq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sombo oleo Iwono mompaguru i tompa Doharo Ue Ala. Kanggo, kapala petewawo pesomba, mia mpande atora Taura saru mia-mia mosuꞌoro to Iahudi mpowusu ansala araꞌehende ro nggale mepateiRo. ");
INSERT INTO mzq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kanggo kano hina ansalaro mepateiRo, akono adio mpihe mia orambi ndi Iwono minggi mehoringakeo pompaguruNo. ");
INSERT INTO mzq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Aso tempo, tekonairo Iesu mompaguru ka mompalele Kareba Meꞌambo la mia adio i tompa Doharo Ue Ala, kapala petewawo pesomba, mia mpande atora Taura ka mia-mia mosuꞌoro to Iahudi hawe ndi Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Iworo mpesikeno ndi Iwono, “Pauꞌakamito, saru pobawano isia Iiko wowauꞌo lowono raaꞌa? Ka isia henu moweiKo pobawa raaꞌa?” ");
INSERT INTO mzq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sumangki Iesu ndi iworo, “Hina mboꞌu aso mpesikenoNggu ndi ikomiu. Pau Akune, ");
INSERT INTO mzq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","teꞌembu nderio pobawano Iohane mobaho mia? Teꞌembu ndi iworo Ue Ala ara teꞌembu la mia?” ");
INSERT INTO mzq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gagi iworo mpepau-pau mongkono pesikeno raaꞌa. Iworo mepau, “Taꞌalu ikito mongee teꞌembu ndi iworo Ue Ala, No pongee teꞌingga ndi ikito, ‘Tembio kai tai mpeꞌale-aleo Iohane?’ ");
INSERT INTO mzq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kanggo taꞌalu ikito mongee teꞌembu la mia, mia adio neeroa teꞌingga tumumpaiꞌakito wasu, akono ro mpeꞌale-aleo suꞌu taꞌalu Iohane raaꞌa aso nabi.” ");
INSERT INTO mzq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kanoamba iworo mesangki, “Kaki mentoꞌorio teꞌembu nderio pobawano Iohane mobaho mia.” ");
INSERT INTO mzq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iesu mepau mboꞌu ndi iworo, “Taꞌalu lesie, Iaku mboꞌu kakulo pauꞌakomiu saru pobawano isia Kuwowauꞌo lowono raaꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Umari raaꞌa Iesu montutulu la mia adio saru aso ande-ande mpau. No pongee, “Hina aso mia mompaho anggoro i lereno ka lereno raaꞌa no pesewaꞌakeo la puꞌu poꞌangga. Umari raaꞌa iwono lumeko la inie mesue ka moꞌia ndepano epi-epie. ");
INSERT INTO mzq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Menseno haweoto tempono wueno anggoro raaꞌa inopu, no tenaꞌoto aso atano lumeko la puꞌu poꞌangga raꞌiroa, karo weiꞌakeo tiano teꞌembu la lere anggoro raaꞌa. Kanggo puꞌu poꞌangga lere anggoro raꞌiroa mentunduhio ata raaꞌa ka tumenaꞌo mekule saru kae molimbo. ");
INSERT INTO mzq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Umari raaꞌa, iwono montena mboꞌu aso ata mesue lumeko ndi iworo. Kanggo ata raaꞌa ro mentunduhio mboꞌu, ro mpokokoꞌiiꞌo ka ro mentenaꞌo mekule saru kae molimbo. ");
INSERT INTO mzq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","No tenaꞌoto mboꞌu ata henu koꞌotolu, kanggo ata raaꞌa ro mentunduhio mboꞌu ranta kano mobela ka ro mpetadiakeo i bungkuno lere anggoro raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ueno lere anggoro raaꞌa mepau i laro aroano, ‘Opio mboꞌuke henu asolekono kuwowauꞌo? Meꞌamboopo kutenaꞌo ananggu henu kupehohawaꞌo. Taꞌalu iwono kutenaꞌo lumeko ndi iworo matantuoto iwono ro pelangkaiꞌo.’ ");
INSERT INTO mzq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kanggo menseno puꞌu poꞌangga lere anggoro raꞌiroa mengkiteo anano ueno lere raaꞌa, iworo tepopau lenie, ‘Kiteo, toramaiꞌoto anano ueno lere henu nggale meꞌueꞌo lere neea. Meꞌamboopo to mpepateo kano lere neea ikito mpeueꞌo.’ ");
INSERT INTO mzq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Umari raaꞌa, anano ueno lere raaꞌa ro mpetadiakeo i bungkuno lere raaꞌa ka ro mpepateo. Gagi, pio teꞌingga henu nggale winowauno ueno lere raaꞌa la puꞌu poꞌangga lere raꞌiroa? ");
INSERT INTO mzq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ueno lere raaꞌa teꞌingga nggale hawe mepateiro puꞌu poꞌangga lere raꞌiroa ka no pesewaꞌakeo lere raaꞌa la puꞌu poꞌangga mesue.” Umariro mehoringo lowono raaꞌa, mia adio henu hina rahea mpepau, “Hooto suꞌu no gagi hele liraꞌa!” ");
INSERT INTO mzq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu mekaniiro ka mepau, “Taꞌalu liraꞌa, pio pengkonoano henu teꞌuki i laro Wunta Mempori neea? Wasu henu tinadiro tuka mpowangu doha, Wasuto raaꞌa henu gagi takau pinatonga. ");
INSERT INTO mzq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Araisia henu tedontai i wawono wasu raaꞌa, iwono nggale tepuro-puro, ka araisia henu dinunsino wasu raaꞌa iwono nggale tepeꞌawu.” ");
INSERT INTO mzq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mia mpande atora Taura ka kapala petewawo pesomba meꞌusaha merakoꞌo Iesu oleo raaꞌa, akono ro mentoꞌorio taꞌalu ande-ande mpau henu Ro pauꞌo Iesu raaꞌa mongkono iworo, kanggo iworo medoito la mia adio. ");
INSERT INTO mzq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mia mpande atora Taura ka kapala petewawo pesomba poporoꞌo Iesu. Iworo mobara popio mia mompoporoꞌo ka mpelelu heleo mia meꞌambo. Mia raꞌiroa ro tenaꞌiro lumeko mesikeno ndi Iesu saru tinunggairo umakalaꞌo, kano hina koa ansalaro mewengakeo la akele kano hinuku. ");
INSERT INTO mzq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mia henu binara raꞌiroa mpesikeno ndi Iesu lenie, “Guru, kimentoꞌorio taꞌalu pio henu pinauMiu ka pinaguruMiu seea mentee. Ikomiu kai pontimaki mia, kanggo mompaguru henu mentee mongkono poꞌehero Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gagi, pauꞌakami, montonda atora agamando, bisake kimpobara sima la Mokole Langkai Roma ara aio?” ");
INSERT INTO mzq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kanggo Iesu tumoꞌorio tinunggairo meꞌakalaꞌo. Akono raaꞌa Iwono mepau ndi iworo, ");
INSERT INTO mzq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Popokito Akune aso lempe doi pera. Gambara ka ngeeno isia henu inuki la doi neea?” Iworo mesangki, “Gambara ka ngeeno Mokole Langkai Roma.” ");
INSERT INTO mzq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iesu mepau ndi iworo, “Taꞌalu lesie, weiꞌakeoto Mokole Langkai pio henu asolekono wineiꞌako Mokole Langkai, ka ndi iworo Ue Ala pio henu asolekono wineiꞌako ndi iworo Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iworo karo bisa meꞌakalaꞌIro saru pio henu pinauRo i aroro mia adio. Iworo kombaa la sangkiRo, ka pokotompaano iworo mengkomino. ");
INSERT INTO mzq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Popioꞌiro to Saduki hawe ndi Iesu. To Saduki raꞌiroa karo pompeꞌalo-alo taꞌalu hina tuwuꞌa mekule mia henu mate. Iworo mpesikeno ndi Iesu, ");
INSERT INTO mzq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Guru, i Musa moꞌuki la Wunta Mempori ndi ikito lenie: taꞌalu aso tama henu metaoꞌoto mate ka walino da tuwu ka ambono hina anano, petiano tama henu mate raaꞌa asolekono metao saru walino petiano henu mate raaꞌa, kano poweiꞌakeo inule la mpetiano henu mate raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tuduano lenie, hina opisu mia mpetia. Henu kaka moꞌalo ana erowai. Kanggo ambono hina anaro, mateoto tama raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Umari raaꞌa petiano henu koꞌoruo umaleo erowai raaꞌa. Tama raaꞌa mate mboꞌu ka ambono hina anaro. ");
INSERT INTO mzq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Umari raaꞌa, petiano henu koꞌotoluno mboꞌu umaleo erowai raaꞌa. Henu koꞌotoluno mboꞌu mate, liraꞌa koamboꞌu henu gagi la lowono andino hawe la koꞌopisuno. Loworo mate ka kano hina anaro. ");
INSERT INTO mzq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pokotompaano erowai raaꞌa mate mboꞌu. ");
INSERT INTO mzq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gagi, taꞌalu temponoto mia mate pinotuwu mekule, gagi walino isia erowai raaꞌa? Akono opisuiro mpetia, loworo umaleo erowai raaꞌa.” ");
INSERT INTO mzq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu sumangki, “Mia i wawontolino neea metao ka pinopotao. ");
INSERT INTO mzq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kanggo, iworo henu tekono winangu teꞌembu la matea ka tuwu i wawontolino henu nggale hawe, andoro bisa mboꞌu metao ka pinopotao. ");
INSERT INTO mzq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iworo andorolo memate mboꞌu akono iworo menggenairoto saru malaꞌeka-malaꞌeka. Iworoto raaꞌa anaro Ue Ala, akono iworo pinotuwuiroto mekule teꞌembu la matea. ");
INSERT INTO mzq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kanggo, manasaoto pinauno i Musa taꞌalu mia henu mateoto, nggale pinotuwu mekule. La inukino mongkono rui henu melanga henu tai kinaano apui, i Musa mepau taꞌalu i Ue Ala iwonoto ‘Ue Alano i Burahima, Ue Alano Isaki, ka Ue Alano Iako.’ ");
INSERT INTO mzq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gagi, Ue Ala raaꞌa kano Ue Alaro mia mate, kanggo Ue Alaro, mia mentuwu akono i aroRo lowono mia tuwu.” ");
INSERT INTO mzq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Umari raaꞌa, popioꞌiro mia mpande atora Taura mepau, “Guru, mentee henu pinauMiu!” ");
INSERT INTO mzq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Teꞌembu rahea, andono hina mia mentaha mpesikeno pio-pio ndi Iworo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu mesikeno ndi iworo, “Pio puꞌuno Mokole Pongkadudui Henu Dinandiro Ue Ala raaꞌa ro mpongee inuleno mokole Daudi? ");
INSERT INTO mzq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kondepo mokole Daudi liono moꞌuki la Wunta Masmur lenie, Ue Ala mepauꞌiroto la Uenggu, Petundato i koanaNggu ");
INSERT INTO mzq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ranta uweliMu Kuwowauꞌiro medoito ndi Iiko. ");
INSERT INTO mzq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gagi, mokole Daudi mepau Iworo Ue Alano. Ehende mboꞌu Iwono ngineengako inuleno?” ");
INSERT INTO mzq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tekonai lowono mia mehoringo pompaguruNo, Iesu mepau la ana guruNo, ");
INSERT INTO mzq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ikomiu asolekono mpegagai la mia mpande atora Taura, henu inehero koleko-leko mompake lemba mentaa ka pinelangkai i pasa. Inehero mpetunda la mpetundaaro mia henu pinelangkai i laro doha pesombaꞌa to Iahudi ka la rame-rame. ");
INSERT INTO mzq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iworo umalongkoraꞌo doharo tuwu erowai. Ka pekakairo ro pokomentaaꞌo kaindono tinoꞌori winowauro henu mosaꞌa. Iworo raaꞌa teꞌingga asolekono montarima pohuku henu takau mobea.” ");
INSERT INTO mzq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tempono Iesu i Doharo Ue Ala, Iwono mekokaniiro mia sugi pompondamo pesombaro la ntabala pesombaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iwono mboꞌu mekanio aso mia tuwu erowai henu karampini, mompondamo oruo lempe doi mala henu takau motutu rekeno i laro tabala raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Umari raaꞌa Iesu mepau, “Iaku mepau ndi ikomiu, menteeꞌano adiopo doi pompoweino tuwu erowai henu karampini raaꞌa kasikono lowono mia raꞌiroa. ");
INSERT INTO mzq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Akono iworo lowo mompowei teꞌembu la toreano aga-agaro. Kanggo tuwu erowai raaꞌa maupono iwono karampini, iwono mewengakeo lowo henu hina ndi iwono henu menteeꞌano no paraluꞌo la tuwuno sombo oleo.” ");
INSERT INTO mzq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tempo raaꞌa hina popioꞌiro mia mpepau mongkono meꞌambono Doharo Ue Ala henu rinamba-rambaꞌako wasu mangkilo, saru merupa-rupa aga-aga henu pinesombaꞌako ndi iworo Ue Ala. Humoringo raaꞌa Iesu mepau, ");
INSERT INTO mzq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nggale hina tempono, lowono henu imengkiteo neea nggale rinesa. Kano hina teꞌaso wasu henu tepoꞌia teꞌapi saru wasu henu mesueno.” ");
INSERT INTO mzq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Umari raaꞌa ana guru mpesikeno ndi Iworo Iesu, “Guru, teꞌepie Doharo Ue Ala no nggale rinesa? Ka opio tondonino taꞌalu raaꞌa nggale gagi?” ");
INSERT INTO mzq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu sumangki, “Pegagaito, kaindono hina mia henu mosaelo komiu, akono adio mia nggale hawe pakeꞌo ngeeNggu ka mongee, ‘Iakuto Mokole Henu Dinandiro Ue Ala!’ Iworo mboꞌu mepau, ‘Oleo tampulaano wawontolino orambioto!’ Kanggo, hooto imentondaꞌiro. ");
INSERT INTO mzq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ka taꞌalu hina imehoringo mongkono peteaꞌa saru marisua hooto imedoito, akono lowono raaꞌa nggale gagi. Kanggo raaꞌa ambono tempono tampulaano wawontolino.” ");
INSERT INTO mzq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Umari raaꞌa Iesu mepau mboꞌu, “Tongku henu aaso nggale umewaꞌo tongku henu mesueno ka poparenta umewaꞌo poparenta mesueno. ");
INSERT INTO mzq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Adio mpoꞌianga nggale gagi lelu henu takau mokora, mokoninggoa ka haki lele. Nggale hina mboꞌu henu gagi merupa-rupa henu mokokonangga ka tondoni henu mompokodoito i langi. ");
INSERT INTO mzq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kanggo ambono gagi lowoakoano raaꞌa ikomiu nggale merinako ka binobarasa. Ikomiu nggale binitara la doha pesombaꞌaro to Iahudi ka pinondamo laro tarungku. Ikomiu mboꞌu nggale winawo i aroro mokole ka to poparenta akono ikomiu mentonda Aku. ");
INSERT INTO mzq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tempoto raaꞌa tempomiu mompalele Kareba Meꞌambo teꞌembu ndi iworo Ue Ala. ");
INSERT INTO mzq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gagi, pokomorosoꞌo aroamiu kaindono impewowoloꞌo pio henu asolekono upauꞌo kumaduduiꞌo koroimiu. ");
INSERT INTO mzq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Akono Iaku lioNggu nggale moweiꞌakomiu pandeꞌa mepau kano ewamu karo bisa sumangki komiu ka umewa mpau komiu. ");
INSERT INTO mzq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ka ikomiu nggale no pewengakomiu mia mosuꞌomiu, petia-petiamiu, peꞌaso dohamiu, ka poko-pokowalimiu. Ka popio mia teꞌembu i olomiu nggale pinepate. ");
INSERT INTO mzq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ikomiu nggale ro oꞌalieꞌakomiu lowono mia, akono ikomiu mompeꞌalo-alo ndi Iaku. ");
INSERT INTO mzq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kondepo teꞌaso lai wuumiu kanolo tetadi. ");
INSERT INTO mzq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Taꞌalu ikomiu kongko pihe mekorahako mompeꞌalo-alo ndi Iaku, ikomiu nggale mohawe tuwuꞌa henu tai hina tampulaano.” ");
INSERT INTO mzq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Taꞌalu imengkiteo inie langkai Ierusale ro meboliliꞌo sorodadu, ikomiu nggale mentoꞌorio taꞌalu oleo teresano inie langkai raaꞌa orambioto. ");
INSERT INTO mzq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tempo raaꞌa mia henu mpoꞌia i Iudea asolekono mpolao i toru-torukuno. Iworo henu mpoꞌia i Ierusale asolekono ronga-ronga peluarako mobintao inie langkai raaꞌa, ka iworo henu mpoꞌia i bungkuno inie langkai Ierusale, hooto ro mpewunso laro inie langkai raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Akono la oleo raaꞌa, nggale hawe oleo pohukuro Ue Ala. Ranta pinokomengkaaꞌoto henu teꞌuki la Wunta Mempori. ");
INSERT INTO mzq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Masolairoto erowai henu tekonai mentia ara henu da mompoꞌuo anaro, akono hina masusaa langkai henu gagi la lowono waawute raaꞌa ka Ue Ala nggale humukuꞌo tongku raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hina nggale pinepateako ponai, ka hina mboꞌu henu winawo gagi mia tinaha i tongku mesueno. Ka Ierusale nggale linolandapi mia kano to Iahudi takau masii, ranta kano hawe tempono henu pinatanturo Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kanoamba Iesu mepau mboꞌu, “Nggale hina petondoni la mataꞌoleo, la betuꞌe ka la tongkimo. Ka i wawontolino neea lowono mia nggale doito ka medungku humoringo ngorono pueno tahi henu takau mokora. ");
INSERT INTO mzq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mia nggale doito takau moꞌaropi pio henu nggale gagi la lowono wawontolino neea, akono pobawa-pobawa i langi nggale telelu. ");
INSERT INTO mzq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tempo raaꞌa lowono mia nggale kumiteo Ana Manusia hawe laro seru saru pobawa ka marambaaRo henu langkai. ");
INSERT INTO mzq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Taꞌalu lowono raaꞌa mompamulaoto gagi, pentadato ka pokomorosoꞌo aroamu akono andono epie Ue Ala kumadudui komiu.” ");
INSERT INTO mzq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesu tumutuluꞌakero ande-ande mpau neea, “Kiteo kau ara ka lowono kau henu mesue. ");
INSERT INTO mzq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Taꞌalu kau raaꞌa meleweoto monguro, ikomiu nggale mentoꞌorio taꞌalu orambioto tempono meꞌoleo. ");
INSERT INTO mzq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Liraꞌa koamboꞌu, taꞌalu imengkiteo tegagioto henu umarioto Kupauꞌakomiu imentoꞌorioto mongee orambioto tempono Ue Ala momparenta heleo Mokole. ");
INSERT INTO mzq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iaku mepau ndi ikomiu, menteeꞌano mia henu tuwu tempo neea, da hina tuwu taꞌalu lowoakoano raaꞌa gagi. ");
INSERT INTO mzq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langi ka wawontolino nggale moliu, kanggo pauNggu kano hina tompaano.” ");
INSERT INTO mzq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pegagaito, kaindono ikomiu teladeako sanaa i wawontolino neea, molangu ka salalaroakeo tinuwumiu. Akono taꞌalu liraꞌa, ikomiu kailo mpesadia taꞌalu Ana Manusia hawe bingkosako heleo oho, ");
INSERT INTO mzq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","henu nggale kumonoꞌo lowono mia henu tuwu i wawontolino neea. ");
INSERT INTO mzq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hoꞌioto puꞌuno, pegagaito mpihe ka pekakai, kai memoroso koa moꞌaropi lowono henu gagi ka ikomiu bisa mentada i aroro Ana Manusia.” ");
INSERT INTO mzq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Taꞌalu mowanda Iesu mompaguru la Doharo Ue Ala ka wongi Iwono lumeko i tamungku Saitu ka mewongi rahea. ");
INSERT INTO mzq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ka kotewotano mowanda adio mia hawe la Doharo Ue Ala mehoringakeo No pompaguru. ");
INSERT INTO mzq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oleo langkai Roti henu Tai Metape, henu ngineengako Paskaa orambioto. ");
INSERT INTO mzq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kapala petewawo pesomba ka mia mpande atora Taura mpowusu ansala, araꞌehende ro bisa mpokopepateo Iesu kaindoro mentoꞌorio mia adio, akono iworo medoito la mia adio. ");
INSERT INTO mzq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kanoamba Mokole Onisu mewunsokio Iudasi henu mengeengako i Karioti, aso mia teꞌembu la hopulo ka oruo ana gururo Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hoꞌioto puꞌuno Iudasi lumeko tepopauꞌakero kapala petewawo pesomba saru petewaworo henu mpogagai Doharo Ue Ala, mongkono araꞌehende kano bisa koa mewengakero Iesu ndi iworo. ");
INSERT INTO mzq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Iworo mensanaa takau ka mpedandi nggale poweiꞌakeo Iudasi doi. ");
INSERT INTO mzq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iudasi uminduꞌo henu pinauro. Umari raaꞌa mompamulaoto Iudasi mewuni-wuni mowusu tempo henu meꞌambo mewengakero Iesu ndi iworo kanggo karo mentoꞌorio mia adio. ");
INSERT INTO mzq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Haweoto Oleo langkai Roti Tai Metape. Oleoto raaꞌa nggale mpogere bimba Paskaa. ");
INSERT INTO mzq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iesu tumenaꞌiro i Peturu ka Iohane Ro pongee, “Ilekoto, ka pompatindaꞌakito kaanga Paskaa kato mponggaa mperonga-ronga.” ");
INSERT INTO mzq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Iworo mpesikeno ndi Iwono, “Inderio ineheMiu kipompatindaꞌakito kaanga Paskaa?” ");
INSERT INTO mzq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Iesu sumangki, “Taꞌalu mewunso komiuto i laro inie langkai Ierusale, ikomiu nggale tepohaweꞌakeo aso mia tama henu mowawo kusi meꞌihi uwoi. Imentondaꞌoto mia raaꞌa lumeko la doha pewunsoꞌano. ");
INSERT INTO mzq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Umari raaꞌa, imempauꞌakeo ueno doha raaꞌa, Guru, mesikeno ndi iiko, ‘Inderio poꞌianga henu nggale Kupakeꞌo monggaa kaanga Paskaa meronga-ronga saru ana guruNggu?’ ");
INSERT INTO mzq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ueno doha raaꞌa nggale montisoꞌakomiu aso bolongko langkai henu i wawono henu tetindaoto lowo parewa mponggaanga. Ipompasadiaꞌakito lowoakoano rahea.” ");
INSERT INTO mzq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Lumekoiroto i Peturu ka Iohane i Ierusale. Ro mehaweꞌoto ndepano, lowono menggena heleo henu pinauro Iesu ndi iworo. Amba iworo ropatindaꞌoto kaanga Oleo langkai Paskaa. ");
INSERT INTO mzq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Menseno haweoto tempono monggaa kaanga Paskaa raaꞌa, Iesu metunda monggaa meronga saru ataRo. ");
INSERT INTO mzq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","No pongeeꞌakero, “Iaku takau tekewoi monggaa kaanga Paskaa neea meronga-ronga saru ikomiu tekonai amboku pinokomarasai. ");
INSERT INTO mzq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kupauꞌakomiu, Kakulo kumaango mboꞌu kaanga Paskaa neea ranta kano hawe tempono pengkonoano ponggaanga Paskaa neea pinokomengkaa, taꞌalu Ue Ala momparenta heleo Mokole i wawontolino henu woꞌu.” ");
INSERT INTO mzq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kanoamba Iesu umaleo aso tonde henu inihiiꞌako anggoro, ka umunde-undeꞌiro Ue Ala, ka mongee, “Imeꞌaleoto neea ka meꞌenuo meꞌeu-eu. ");
INSERT INTO mzq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kupauꞌakomiu, umari oleo neea andokulo moꞌenu mboꞌu uwoino anggoro neea, ranta Ue Ala momparenta i wawontolino henu woꞌu.” ");
INSERT INTO mzq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Umari raaꞌa No aleo roti, umunde-undeꞌiro Ue Ala ka No siba-sibaho roti raaꞌa ka No weiꞌakero ka No pongee, “Noototo koroiNggu henu pinewengako kai tekadudui koa. Imewowauꞌoto heleo neea gagi rorambeamiu ndi Iaku.” ");
INSERT INTO mzq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Liraꞌa koamboꞌu umariro mponggaa, No aleo tonde henu meꞌihi anggoro raaꞌa, No weiꞌakero ka mongee, “Uwoi anggoro henu i larono tonde neea gagi pedandiꞌa woꞌu Ue Ala henu nopokomorosoꞌo reaNggu henu tesolo gagi tiamiu. ");
INSERT INTO mzq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kanggo, kai mentoꞌorio koa, mia henu mewengakune monggaa meronga-ronga saru Iaku endea. ");
INSERT INTO mzq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Laano Ana Manusia nggale mate heleo henu pinatanturo Ue Ala. Kanggo masolaoto mia henu mewengakeRo.” ");
INSERT INTO mzq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Umari raaꞌa iworo pada mpesike-sikeno, isia i oloro henu nggale mowowau liraꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Umari raaꞌa gagioto pesansaa i oloro rasulRo mongkono isia henu takau pototono ngineengako takau mantudu i oloro. ");
INSERT INTO mzq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu mepau ndi iworo, “Mokole-mokole i wawontolino neea poꞌehearo moparenta palilino. Ka iworo inehero ngineengako, ‘Peneo-neoꞌaro palili,’ ");
INSERT INTO mzq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kanggo ikomiu hooto no heleo iworo. Kanggo takau mantudu teꞌembu ndi ikomiu asolekono melelu heleo mia henu kano mantudu, ka petewawo asolekono melelu heleo ata. ");
INSERT INTO mzq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Isia henu takau mantudu, mia henu metunda monggaa, ara mia henu parakaiꞌiro? Matantu henu takau mantudu mia henu metunda monggaa. Kanggo Iaku kongko i olomiu heleo atamiu. ");
INSERT INTO mzq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Larono lowono masusaa henu pinembasaiNggu, ikomiuto henu kongko meronga-ronga saru Iaku. ");
INSERT INTO mzq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Hoꞌioto puꞌuno, araꞌehende UmaNggu moweiꞌakune pobawa momparenta, liraꞌa koamboꞌu Iaku moweiꞌakomiu pobawa moparenta i laro PoparentaNggu. ");
INSERT INTO mzq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Liraꞌato ikomiu bisa mponggaa ka mpoꞌenu saru Iaku i laro PoparentaNggu, ka ikomiu nggale metunda la hopulo ka oruo petundaano mokole nggale mobitara hopulo ka oruo tongku Isaraeli.” ");
INSERT INTO mzq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Umari raaꞌa Iesu mepau ndi Simo, “Simo, Simo pehoringakeo temeꞌambo. Mokole Onisu ininduoto nggale umara-arahakomiu heleo gandu pinonsia teꞌembu la ngkulino ranta henu meꞌambo pinonsia teꞌembu la henu mosaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kanggo Kupekakaiꞌakomuto kano pompeꞌalo-alomu moroso mpihe ndi Iaku. Ka taꞌalu morosooto mboꞌu mekule pompeꞌalo-alomu ndi Iaku, iiko asolekono pokomorosoꞌo pompeꞌalo-aloro petia-petiamu.” ");
INSERT INTO mzq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","I Peturu mepau, “Ue, iaku mesadia tinarungku ka mate meronga-ronga saru Ikomiu!” ");
INSERT INTO mzq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu sumangki, “Iaku mepau ndi iiko, ambono kumekereaꞌo manu oleo neea, menggotoluto upehapu taꞌalu iiko tumoꞌori Aku.” ");
INSERT INTO mzq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Umari raaꞌa Iwono mepau la ana guruNo, “Tempono Kutena komiu lumeko mompalele Kareba Meꞌambo hooto impowawo doi, pebaku ka sapatu, hinake henu makuramiu?” Sumangki iworo, “Kano hina.” ");
INSERT INTO mzq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iesu mepau, “Kanggo lenie neea, isia hina doino asolekono no waweo, liraꞌa koamboꞌu henu hina pebakuno. Ka isia henu tai hina ponaino, asolekono kano peꞌoliakeo lemba mentaano kano poꞌoli koa ponai. ");
INSERT INTO mzq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iaku mepau liraꞌa ndi ikomiu akono pio henu teꞌuki la Wunta Mempori mongkono Iaku, asolekono inihii. Henu inuki la Wunta Mempori raaꞌa lenie, ‘Iwono nggale pinokomenggena saru mia henu mosaꞌa pinogauro.’ Akono pio henu inuki mongkono Iaku kontongaanoto inihii.” ");
INSERT INTO mzq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iworo mpongee, “Ue, kiteo endea hina oruo ponai.” Sumangki Iesu, “Sombooto.” ");
INSERT INTO mzq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Umari raaꞌa Iesu mobintao inie langkai ka lumeko heleo biasano i tamungku Saitu, ka ana guruNo mboꞌu mentondario. ");
INSERT INTO mzq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mensero mehawe la mpoꞌianga raaꞌa, Iesu mepau la ana guruNo, “Impekakai kaindono itedontai la mpoꞌara-arahakoa.” ");
INSERT INTO mzq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kanoamba Iesu lumeko olai teꞌesi teꞌembu ndi iworo heleo olaino tolo metumpaiꞌako wasu, karoꞌamba menggoluntu mekakai, No pongee, ");
INSERT INTO mzq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O UmaNggu, taꞌalu Ikomiu umehe, aleoto masusaa neea teꞌembu ndi Iaku, kanggo kano poꞌeheNggu henu gagi kanggo poꞌeheMiuto henu gagi.”  ");
INSERT INTO mzq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Umari raaꞌa aso mia malaꞌeka teꞌembu i suruga hawe mokomorosoꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iesu takau masusa aroaNo ranta Iwono komoro-morosono No pekakai. MokoꞌisoRo heleo iꞌitino rea henu teꞌiti la wute. ");
INSERT INTO mzq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Umarino mekakai, Iesu mekule la ana guruNo, No haweꞌiro tekonai mpoturi akoro memasusa. ");
INSERT INTO mzq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iesu mongeeꞌakero, “Tembio kai mpoturi? Impewanguto ka mpekakai, kaindono itedontai la mpoꞌara-arahakoa.” ");
INSERT INTO mzq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tempono Iesu da mepau mehaweiroto mia aso bawaa. Iworo no waweiro Iudasi, aso mia teꞌembu la ana gururo Iesu. Kanoamba Iudasi lumeko ndi Iesu ka wowoongo. ");
INSERT INTO mzq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kanggo Iesu mepau ndi iwono, “Iudasi, nggo pewoo-woomu seeake kau pewengakeo Ana Manusia?” ");
INSERT INTO mzq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tempono ana gururo Iesu henu hina rahea mengkiteo pio henu nggale gagi, mpongeeꞌiroto, “Ue, ehende taꞌalu ikami umewaꞌakero ponai?” ");
INSERT INTO mzq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ka aso mia teꞌembu ndi iworo umimpahio atano petewawo pesomba langkai ranta kano teꞌopui birino henu i koana. ");
INSERT INTO mzq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kanggo Iesu mepau, “Hopoto!” Karoꞌamba umanggaꞌo birino mia raaꞌa ka mokotompaꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Umari raaꞌa Iesu mepau la kapala petewawo pesomba raꞌiroa, puꞌu petetawo henu mpogagai Doharo Ue Ala ka mia mosuꞌoro to Iahudi mesueno henu mehawe merakoꞌIro lenie, “Pongeemiu Iaku neea mia mosaꞌa, ranta kai mehawe merako Aku tangki ponai ka pontunduhi? ");
INSERT INTO mzq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sombo oleo Iaku kongko i tonga-tongamiu laro Doharo Ue Ala, ka ikomiu kai merako Aku. Kanggo iwonoto neea tempomiu mewowauꞌo ka tempono pobawano Mokole Onisu mowowau poꞌeheno.” ");
INSERT INTO mzq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Umari raaꞌa iworo merakoꞌo Iesu ka ro mewaweo la dohano Petewawo Pesomba Langkai. I Peturu tumondaꞌiro teꞌembu olai. ");
INSERT INTO mzq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","I tonga-tongano tompa doha raaꞌa mia mompotuwu apui ka iworo mpetunda meboliliꞌo apui raaꞌa. I Peturu mboꞌu metunda merongairo. ");
INSERT INTO mzq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aso mia ata erowai kumiteo i Peturu orambi la apui raaꞌa, ata erowai raaꞌa no poporoꞌo i Peturu ka mepau, “Mia neea mboꞌu meronga saru Iesu!” ");
INSERT INTO mzq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kanggo i Peturu mehapu ka mongee, “Aio! Iaku kaku toꞌorio mia raaꞌa!” ");
INSERT INTO mzq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kano epie olono, aso mia mesue kumiteo i Peturu ka mepau, “Iiko mboꞌu neea aso mia ana guruno Iesu!” Kanggo i Peturu sumangki, “Aio, iaku kano ana guruNo!” ");
INSERT INTO mzq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Samana aso langku umari raaꞌa aso mia mesue mepau mokora, “Mentee mia neea ana guruno Iesu, akono iwono mboꞌu to Galilea.” ");
INSERT INTO mzq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kanggo i Peturu mepau, “Aio, iaku kaku toꞌorio pio henu pinaumu!” Tempo raaꞌa mboꞌu kontongaano i Peturu da mepau raaꞌa kumekereaꞌoto manu. ");
INSERT INTO mzq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Iesu mewalili ka mekokanio i Peturu. No pokompewowoloꞌo i Peturu taꞌalu i Ue umari mepau ndi iwono lenie, “Ambono kumekereaꞌo manu oleo neea, menggotoluto uhapu Aku.” ");
INSERT INTO mzq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Umari raaꞌa meluarakoꞌoto i Peturu baꞌie tedoa masusa aroano. ");
INSERT INTO mzq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mia henu tekonai megagaiꞌo Iesu, ro mpepalindoꞌakeo ka ro mentunduhio. ");
INSERT INTO mzq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iworo mempupusio mataNo ka mpesikeno ndi Iwono, “Pauꞌoto ndi ikami araisia henu tumunduhiKo?” ");
INSERT INTO mzq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Da adio pau-pau pontetewehi henu ro mempauꞌo ndi Iwono. ");
INSERT INTO mzq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ka menseno mowanda, pepumpuiroto Puꞌu Pobitara Agama to Iahudi. Iworo raaꞌa iwonoto mia mosuꞌoro to Iahudi, kapala petewawo pesomba raꞌiroa ka mia mpande atora Taura. Iworo montena mia kano Iesu winawo i aroro. ");
INSERT INTO mzq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tempono Iesu i aroro, iworo mepau ndi Iwono, “Taꞌalu mentee Iiko Mokole Pongkadudui, pauꞌakamito!” Sumangki Iesu, “Maupo Kupauꞌakomiu, laano kailo mpeꞌalo-alo Aku, ");
INSERT INTO mzq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ka taꞌalu Iaku mesikeno ndi ikomiu, laano kailo mesangkio. ");
INSERT INTO mzq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kanggo mompamula lenie, Ana Manusia nggale metunda i koanaro Ue Ala Henu Pobawa Takau.” ");
INSERT INTO mzq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Umari raaꞌa loworo mpesikeno, “Taꞌalu lesie, Iikoke anaro Ue Ala?” Sumangki Iesu, “Ikomiuto isaꞌa henu mempauꞌo taꞌalu Iakuto anaro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iworo mpongee, “Taꞌalu lesie kato pomparalu sakosii mboꞌu! Ikito neea to mehoringoto teꞌembu la wiwiNo iwonono.” ");
INSERT INTO mzq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lowono mia henu mpepumpu raaꞌa mpentada karoꞌamba mewaweo Iesu i arono akele Pilatu. ");
INSERT INTO mzq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ndepano iworo mompamula mentulurio Iesu. Iworo mpongee, “Mia neea kimehaweꞌo mompoposaelo palili ka pasuuꞌiro mia kaindoro mpobara sima la Mokole Langkai Roma ka No pongee iwonoto Kirisitu aso mia Mokole.” ");
INSERT INTO mzq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu mesikeno ndi Iesu, “Iikoke Mokolero to Iahudi?” Sumangki Iesu, “Iiko liomu pauꞌo.” ");
INSERT INTO mzq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kanoamba i Pilatu mepau la kapala petewawo pesomba ka mia adio rahea, “Iaku kaku pohawe teꞌaso tokoa salaNo mia neea.” ");
INSERT INTO mzq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kanggo iworo sani mokora medadaꞌo, ro mpongee, “Saru pompaguruNo Iwono neea mompasuu palili la lowono waawute Iudea, mompamula teꞌembu i Galilea ka lenie hawe endea.” ");
INSERT INTO mzq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Humoringo raaꞌa, i Pilatu mesikeno, “To Galileake mia neea?” ");
INSERT INTO mzq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tempono Pilatu tumoꞌorio, mongee Iesu teꞌembu la poparentano i Herode, no tenaꞌo mia mewaweo Iesu meꞌaro ndi Herode henu tempo raaꞌa hina i Ierusale. ");
INSERT INTO mzq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sanaa takau Herode kumiteiro Iesu. Epieꞌoto no ineheno kumiteo, akono iwono nohoringoto kareba mongkono Iesu. Iwono momperorohi bisa kumiteo Iesu mowowau henu kombaaꞌakoa. ");
INSERT INTO mzq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Adio pesikeno henu no pauꞌo Herode ndi Iesu. Kanggo kano hina teꞌaso henu sinangkiro Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kapala petewawo pesomba ka mia mpande atora Taura mpentada ka tumuluriiro Iesu takau mokora. ");
INSERT INTO mzq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herode ka sorodaduno mepalindoꞌakeo ka tumetewehio Iesu. Iworo mompakeꞌakeo parewa henu meꞌambo heleo parewano mokole. Umari raaꞌa Herode tumenaꞌiro sorodaduno mewaweo mekule Iesu ndi Pilatu. ");
INSERT INTO mzq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Oleo koa raaꞌa mboꞌu i Herode ka i Pilatu henu leꞌe-leꞌeruno meꞌuweli, iworo tepomeꞌambo mekule. ");
INSERT INTO mzq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatu pumpuiro kapala petewawo pesomba, mia mosuꞌoro to Iahudi ka palili. ");
INSERT INTO mzq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kanoamba i Pilatu mepau ndi iworo, “Ikomiu mewaweo Mia neea ndi iaku ka ikomiu mentulurio momposaelo palili karo meꞌewaꞌo poparenta Roma. Kuparesaꞌoto i aromiu, kanggo kano hina salaNo kupohawe heleo henu imentuluriakeo. ");
INSERT INTO mzq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Liraꞌa mboꞌu i Herode, kano hina salaNo Mia neea henu no haweꞌo. Hoꞌioto puꞌuno no pokuleo mekule ndi ikami. Kano hina salaNo henu winowauno Mia neea henu pototono No hinuku mate. ");
INSERT INTO mzq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hoꞌioto raaꞌa, iaku nggale sumepiꞌo kakuꞌamba motolaho.”  ");
INSERT INTO mzq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatu mepau liraꞌa, akono sombo oleo langkai Paskaa, iwono asolekono mompotola aso mia tinarungku tiaro palili. ");
INSERT INTO mzq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kanggo lowono mia henu tepumpu rahea koꞌora-ora ro mpongee, “Pepateo Mia neea ka potolaha kami Baraba!” ");
INSERT INTO mzq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraba raaꞌa mia henu tinarungku akono porisui henu gagi i laro inie langkai Ierusale ka iwono mompepate mia.) ");
INSERT INTO mzq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatu minggi motolaho Iesu, hoꞌioto raaꞌa pihepo mboꞌu no pepau la mia adio raꞌiroa. ");
INSERT INTO mzq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kanggo mia adio raꞌiroa koꞌora-ora mpihe ka mpepau, “PasoIro la ngkau pinotamba! PasoIro la ngkau pinotamba!” ");
INSERT INTO mzq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Umari raaꞌa i Pilatu mepau mboꞌu ndi iworo komenggotoluno no pongee, “Pio henu mosaꞌa winowauno Mia neea? Kano hina salaNo henu kuhaweꞌo la Mia neea henu pototono No hinuku mate. Gagi iaku nggale sumepiꞌo kakuꞌamba motolaho.” ");
INSERT INTO mzq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kanggo sani mokora ro mengkoꞌora-ora ka mpedada kano Iesu raaꞌa pinaso la ngkau pinotamba. Pokoumariano iworo mponangi la ngkoꞌora-oraro. ");
INSERT INTO mzq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Gagi, Pilatu mokonoakeo hukuma mate ndi Iesu montonda poꞌehero mia adio raꞌiroa. ");
INSERT INTO mzq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iwono motolaho i Baraba henu tinarungku akono porisui henu gagi i laro inie langkai Ierusale ka mompepate, akono hoꞌio raaꞌa henu inehero. Ka Iesu no pewengakeo ndi iworo kano winowau montonda poꞌehero. ");
INSERT INTO mzq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Umari raaꞌa sorodadu Roma mewaweo Iesu. I tonga ansala, iworo mentahaꞌo aso mia teꞌembu i Kirene henu mengeengako i Simo, henu nggale mendamo la inie langkai Ierusale. Iworo medadaꞌo poꞌahao kau pinotamba raaꞌa tumondaꞌiro Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Adio takau mia henu tumondaꞌiro Iesu, i olono erowai henu baꞌieꞌakeo ka morambe-rambeako. ");
INSERT INTO mzq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kanggo Iesu mewalili la erowai raꞌiroa ka mepau, “O erowai-erowai Ierusale, hooto imebaꞌie Akune. Baꞌieꞌakeoto koroimiu ka ana-anamiu. ");
INSERT INTO mzq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Akono nggale hawe tempono ungga mia nggale mpepau, ‘Meꞌuraoto erowai henu bita, henu tai hori meꞌana ka kano hori mompoꞌuo anano!’ ");
INSERT INTO mzq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tempo raaꞌa ungga, mia nggale mepau la toruku, ‘Tewingketo dumunsi kami!’ Ka la tamungku, ‘Howui kamito!’ ");
INSERT INTO mzq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iaku mepau liraꞌa, akono Iaku henu tai hina salaNggu, iworo mowowau heleo neea, laluaꞌopo ikomiu henu adio sala.” ");
INSERT INTO mzq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hina mboꞌu oruo mia henu mosaꞌa winowauro winawo meronga Iesu kano hinuku mate. ");
INSERT INTO mzq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Temporo mehawe laꞌaso mpoꞌianga henu mengeengako “Tamungku Takuꞌulu”, iworo mempasoꞌo Iesu la ngkau pinotamba meronga oruo mia mosaꞌa gauno. Henu aaso i koanaNo ka henu mesue i koseNo. ");
INSERT INTO mzq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Umari raaꞌa Iesu mekakai, “Uma, ampuniꞌiro, akono karo mentoꞌorio pio henu winowauro.” Kanoamba sorodadu raꞌiroa melotreiꞌo karo patantuꞌo isia henu nggale humaweꞌo parewaro Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Adio mia mpentada rahea ka sumakosiiꞌo pio henu gagi raaꞌa. Mia mosuꞌoro to Iahudi mepalindoꞌakeRo ro mpongee, “Mia mesue No kaduduiꞌo, poꞌinengoto lenie No kaduduiꞌo koroiNo, taꞌalu mentee Iwono Mokole Pongkadudui henu tinimakiro Ue Ala.” ");
INSERT INTO mzq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sorodadu raꞌiroa tumetewehiiRo. Iworo mehawe ka popoꞌenuakeo anggoro moꞌolo, ");
INSERT INTO mzq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ka ro mpongee, “Taꞌalu Iiko mokolero to Iahudi, kaduduiꞌo koroiMu!” ");
INSERT INTO mzq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","I wawo uluNo hina inuki lenie, “Iwonoto Neea Mokolero to Iahudi.” ");
INSERT INTO mzq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aso mia henu mosaꞌa gauno henu pinaso meronga Iesu tumetewehio no pongee, “Taꞌalu Iiko mentee Mokole Pongkadudui, kaduduiꞌo koroiMu saru ikami!” ");
INSERT INTO mzq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kanggo henu asono meꞌetahakeo pokowalino raaꞌa, no pongee, “Kau doitoke ndi Iworo Ue Ala? Iiko meronga-ronga hinuku mate saru Iwono. ");
INSERT INTO mzq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ikito neea laano pototono hinuku, montonda winowaundo henu mosaꞌa. Kanggo Iwono neea kano hina salaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kanoamba iwono mepau ndi Iesu, “Iesu, pewowolo aku, tempono Iiko hawe heleo Mokole!” ");
INSERT INTO mzq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu mepau, “Menteeꞌano Kupauꞌakomu, oleo neea koamboꞌu iiko nggale meronga-ronga saru Iaku i laro suruga.” ");
INSERT INTO mzq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tinasere langku hopulo ka oruo tonga oleo, lowono waawute raaꞌa gagi rokoma ntakau hawe langku otolu kiniwie, ");
INSERT INTO mzq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","akono mataꞌoleo kano pewanta. Ka bana porerei i laro Doharo Ue Ala, tebire tepeꞌoruo. ");
INSERT INTO mzq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kanoamba Iesu umoraꞌako mokora, “Uma, la ngkaeMiu Kupewengakeo penaoNggu!” Umari mepau liraꞌa Iesu mate. ");
INSERT INTO mzq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tempono petewawo sorodadu kumiteo henu gagi, iwono umunde-undeꞌiro Ue Ala ka mepau, “Mentee takau Mia neea kano hina salaNo.” ");
INSERT INTO mzq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mia adio henu mpepumpu rahea temporo mengkiteo lowono henu gagi, mpekuleiroto ka mempede-pedehio radaro akono iworo mpeꞌo-ole. ");
INSERT INTO mzq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lowono mia henu tumoꞌori iro Iesu tewunso erowai-erowai henu tumondaꞌIro teꞌembu i Galilea, mentada ola-olai ka kumiteo lowoakoano raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tempo raaꞌa hina aso mia henu mengeengako Iusu. Iwono mia henu meꞌambo ka mentee. Iusu raaꞌa aaso Puꞌu Pobitara Agama to Iahudi, ");
INSERT INTO mzq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kanggo kano peꞌaroaꞌo saru poꞌehero ka pinogau henu winowauro Puꞌu Pobitara Agama to Iahudi henu mesueno. Iwono teꞌembu i inie langkai Arimatea waawute Iudea ka iwono monsikori tempono Ue Ala momparenta i wawontolino heleo Mokole. ");
INSERT INTO mzq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iusu lumeko meꞌaro ndi Pilatu ka momonio nggale kumaburuꞌo koroiro Iesu henu mateiroto. ");
INSERT INTO mzq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","No potiiꞌo koroiro Iesu teꞌembu la ngkau pinotamba kanoamba tumongohakeo bana mompute ka moleroIro i laro kaburu henu kineke la tamungku wasu. Kaburu raaꞌa ambono hori pinake mongkaburu mia mate. ");
INSERT INTO mzq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Oleo raaꞌa iwonoto oleo pepatindaꞌa montotowo oleo penao-naoꞌa to Iahudi henu minggioto pinamula. ");
INSERT INTO mzq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Erowai-erowai henu hawe meronga saru Iesu teꞌembu i Galilea, tumondaꞌo Iusu lumeko la ngkaburu. Iworo mengkiteo kaburu raaꞌa ka araꞌehende koroiro Iesu no pinolero la ngkaburu. ");
INSERT INTO mzq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Umari raaꞌa mpekuleiroto pompasadia rampa-rampa ka boka mana meꞌambo henu nggale pinakero humahiꞌakeo koroiro Iesu. Tempono oleo penao-naoꞌa to Iahudi pinamulaoto, iworo penao-nao mpoꞌangga montonda atora henu inuki la atora Taura. ");
INSERT INTO mzq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kotewotano oleo minggu, melekoiroto erowai raꞌiroa la ngkabururo Iesu. Iworo mpowawo rampa-rampa henu mana meꞌambo henu ro mempasadiaꞌoto laano. ");
INSERT INTO mzq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Temporo mehawe ndepano, ro mehaweꞌo wasu langkai pupusino kabururo Iesu tewalelooto. ");
INSERT INTO mzq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mensero pewunso la kaburu raaꞌa, koroiro Iesu andoro mehaweꞌo. ");
INSERT INTO mzq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kontongaaro mpentada rahea ka medungku pewowoloꞌo arapio henu kinitoro raaꞌa, bingkosako hina oruo mia meparewa mangkilo mentada orambi ndi iworo. ");
INSERT INTO mzq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mengkiteo raaꞌa iworo takau medoito ka mpetutu hawe la wute. Oruo mia raaꞌa mepau ndi iworo, “Tembio kai mewusuꞌo mia henu tuwu i oloro mia mate? ");
INSERT INTO mzq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iwono kano endeaꞌo. Iwono tuwuoto mekule. Pewowoloꞌoto pio henu umari pinauNo ndi ikomiu tempono Iwono da i Galilea, ");
INSERT INTO mzq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","taꞌalu Ana Manusia asolekono pinewengako la mia tehala ka ro mempasoꞌo la ngkau pinotamba. Kanggo koꞌotoluno oleo Iwono nggale tuwu mekule.” ");
INSERT INTO mzq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Umari raaꞌa ro mpokopewowoloꞌoto opio henu umari ngineero Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mensero mpekule teꞌembu i kaburu, iworo mentutuluꞌo lowono henu gagi raaꞌa la hopulo kaꞌaso ana guruno Iesu ka lowono mia mesue henu tumondaꞌiro Iesu. ");
INSERT INTO mzq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Erowai raꞌiroa henu tumutuluꞌo kareba raaꞌa la mia henu tumondaꞌiro Iesu iwonoto: Maria Magdalena, Iohana, Maria ineno Iakobu ka erowai-erowai mesueno henu merongairo. ");
INSERT INTO mzq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kanggo pio henu pinauro erowai raꞌiroa hele nggo kano mendamo la akala, hoꞌioto puꞌuno karo tai peꞌale-aleo. ");
INSERT INTO mzq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Maupono liraꞌa, i Peturu mentada ka mompari-pari lumeko i kaburu. Menseno hawe ndepano, iwono metutu menggito laro ngkaburu. Butu tokoa bana mompute henu no kiteo. Iwono takau kombaa kanoamba mekule ka mesikeno i laro aroano pio menteeꞌano henu gagi. ");
INSERT INTO mzq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","La oleo koamboꞌu raaꞌa oruo mia henu tumondaꞌiro Iesu koleko-leko lumeko laꞌaso inie henu mengeengako Emau, tinasere hopulo ka aaso kilo olaino teꞌembu Ierusale. ");
INSERT INTO mzq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kontongaaro koleko-leko, iworo popauꞌo mongkono lowono henu gagi. ");
INSERT INTO mzq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Temporo tekonai mempopauꞌo, Iesu hawe orambiakero ka koleko-leko merongairo. ");
INSERT INTO mzq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iworo mengkiteo, kanggo hina aso rupa henu wowauꞌiro ranta karo tai mentoꞌorio. ");
INSERT INTO mzq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu mesikeno ndi iworo, “Pio henu imempopauꞌo tekonai koleko-leko?” Humoringo pesikenono Iesu raaꞌa, iworo mpenao-nao koleko-leko saru masusa aroaro. ");
INSERT INTO mzq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aso mia teꞌembu ndi iworo henu mengeengako i Keleopa, mepau ndi Iesu, “Teꞌembu la lowono mia hawe i Ierusale, samana butu Ikomiu henu tai tumoꞌorio lowono henu gagi ndepano popio oleo henu teliu.” ");
INSERT INTO mzq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesu mepau, “Pioke henu gagi?” Iworo mesangki, “Lowono henu gagi ndi Iesu to Nasare raaꞌa. Iwono raaꞌa aso nabi. Henu pinauNo ka winowauNo pobawa takau i aroro Ue Ala ka lowono mia. ");
INSERT INTO mzq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kanggo kapala petewawo pesomba ka mia mosuꞌo mami, mewengakeo nggale mehuku mateꞌo ka ro mempasoꞌo la ngkau pinotamba. ");
INSERT INTO mzq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kaisaꞌa ikami momperorohi mongee Iwonoto henu motolahiro Isaraeli. Ka oleo neea, koꞌotolu oleono tempono lowono raaꞌa gagi. ");
INSERT INTO mzq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kanggo popio erowai henu peronga mami wowau kami tekokoni takau akono da kotewotano iworo lumeko i kaburu, ");
INSERT INTO mzq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","iworo karo mehaweꞌo koroiro Iesu. Iworo hawe pauꞌakami mongee iworo mengkiteo malaꞌeka-malaꞌeka henu pauꞌakero taꞌalu Iesu raaꞌa tuwuoto mekule. ");
INSERT INTO mzq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Umari raaꞌa popioꞌiro pokowali mami lumeko la ngkaburu. Iworo mehaweꞌo ndepano, laano mentee arapio henu pinauro erowai raꞌiroa, kanggo iworo karo mengkiteo Iesu.” ");
INSERT INTO mzq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Umari raaꞌa Iesu mepau ndi iworo, “Ikomiu laano bebe. Mongguu lahi ipompewowolo ranta kai tai pompeꞌalo-alo la lowono henu pinauro nabi-nabi. ");
INSERT INTO mzq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mokole Pongkadudui asolekono tumanggumio lowono masusaa raaꞌa, umari raaꞌa kanoamba pinokomarambaa.” ");
INSERT INTO mzq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Umari raaꞌa Iesu mokomantiiꞌakero pio henu teꞌuki la lowono Wunta Mempori mongkono koroiNo, mompuꞌu la Wunta inukino i Musa ranta henu inukiro nabi-nabi. ");
INSERT INTO mzq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tekonaino raaꞌa iworo orambiiroto i inie lekoꞌaro. Iesu heleo nggale lumiuakeo koleko-lekoꞌaNo. ");
INSERT INTO mzq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kanggo ro medadaꞌo kano poli koa teliu saru iworo, ro mpongee, “Ipoꞌiato ari saru ikami wongi neea, akono lenie nggoto nggale wongi.” Pokoꞌumariano moꞌiato Iesu meronga saru iworo. ");
INSERT INTO mzq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tekonai metunda merongairo, Iwono moꞌalo roti ka umunde-undeꞌiro Ue Ala. Umari raaꞌa No siba-sibaho roti raaꞌa kanoamba weiꞌakero. ");
INSERT INTO mzq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tempo raaꞌa bingkosako ro mentoꞌorioto mongee Iesuto raaꞌa. Kanggo Iwono tampuꞌu moliu teꞌembu i tonga-tongaro. ");
INSERT INTO mzq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iworo mpepau pada iworo, “Tekono koa ikito langkai aroa tempono No pepau ndi ikito i tonga ansala ka tempono mokomantiiꞌo ihino Wunta Mempori ndi ikito.” ");
INSERT INTO mzq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tempo raaꞌa mboꞌu iworo mekule Ierusale. Ndepano iworo tepotowoakero hopulo ka aaso ana guruno Iesu henu mpepumpu meronga saru popio mia henu tumondaꞌIro. ");
INSERT INTO mzq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mia henu mpepumpu raꞌiroa mepau la mia oruo raaꞌa, “Laano mentee. Ue ndo tuwuoto mekule ka nopopokiteoto koroiNo ndi i Simo!” ");
INSERT INTO mzq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Umarino raaꞌa, mia oruo raaꞌa tumutuluꞌakero pio henu gagi tekonairo i tonga ansala ka araꞌehende ro toꞌorio Iesu tempono Iesu sumiba-sibaho roti. ");
INSERT INTO mzq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tekonairo da tumutuluꞌo mongkono lowono henu gagi, bingkosako mentadairoto Iesu i tonga-tongaro ka mepau, “Sintuwu karodoa gagi tiamiu!” ");
INSERT INTO mzq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Iworo lowo tekokoni ka medoito, akono pongeero iworo ponggito onisuno mia mate. ");
INSERT INTO mzq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kanggo Iesu mepau ndi iworo, “Tembio kai medoito? Tembio kai bata-bata? ");
INSERT INTO mzq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kiteo kaeNggu ka kareNggu. Iakuto neea! Angga Akuto ka pekanio temeꞌambo. Akono sumangano mia mate kano peꞌihi ka mewuku, kanggo Iaku neea meꞌihi ka mewuku.” ");
INSERT INTO mzq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tekonai mepau liraꞌa, Iwono mopokiteo kae ka kareNo ndi iworo. ");
INSERT INTO mzq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kanggo amboro pompeꞌalo-alo takau ndi Iesu, akono iworo takau sanaa ka kombaa. Hoꞌioto puꞌuno Iesu mesikeno ndi iworo, “Hinake kaangamiu endea?” ");
INSERT INTO mzq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Iworo moweiꞌakeo aso mpole bou sinunu. ");
INSERT INTO mzq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","No aleo bou raaꞌa ka No kaango i aroro. ");
INSERT INTO mzq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Umari raaꞌa Iwono mepau ndi iworo, “Iwonoto neea henu umarioto Kupauꞌakomiu tempoNggu da meronga-ronga saru ikomiu, iwonoto henu inuki mongkono Iaku la atora Taura henu inukino i Musa, Wuntaro nabi-nabi ka Wunta Masmur nggale inihii.” ");
INSERT INTO mzq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kanoamba Iesu umungkahio pinewowoloro ranta karo mentoꞌorio ihino Wunta Mempori. ");
INSERT INTO mzq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iwono mepau ndi iworo, “Hina teꞌuki la Wunta Mempori taꞌalu Mokole Pongkadudui Henu Dinandiro Ue Ala asolekono tumanggumio masusaa ranta kano mate ka asolekono mewangu mekule teꞌembu la matea koꞌotoluno oleo. ");
INSERT INTO mzq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ka i laro ngeeRo asolekono pinalele la lowono tongku mongkono kareba mongee mia asolekono mosea teꞌembu la halano ka Ue Ala umampunio halaro. Kareba raaꞌa asolekono pinalele mompuꞌu teꞌembu Ierusale. ");
INSERT INTO mzq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ikomiuto sakosii teꞌembu la lowoakoano raaꞌa. ");
INSERT INTO mzq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pehoringakeo neea, Iaku nggale mompotiiꞌakomiu Penao Mempori henu dinandiro UmaNggu. Kanggo ikomiu asolekono mpoꞌia i inie langkai neea, ranta pobawa teꞌembu ndi Iworo Ue Ala metii mokomoroso komiu.” ");
INSERT INTO mzq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Umari raaꞌa Iesu waweiro ana guruNo meluarako teꞌembu Ierusale ranta orambi i inie i Betania. Rahea No tandengo kaeNo ka barakatiꞌiro. ");
INSERT INTO mzq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tekonai No barakatiꞌiro, Iwono tensia teꞌembu ndi iworo ka tewueꞌako i suruga. ");
INSERT INTO mzq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iworo menggoluntu mesombaiꞌiro, umari raaꞌa mpekuleiroto Ierusale saru aroaro takau sanaa. ");
INSERT INTO mzq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iworo pia meleko la Doharo Ue Ala ka umunde-undeꞌiro mpihe Ue Ala.");
ALTER TABLE mzq_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
