﻿USE sofia;
DROP TABLE IF EXISTS sofia.mza_vpl;
CREATE TABLE mza_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mza_vpl WRITE;
INSERT INTO mza_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ña'a kùu sivi ma ndian kūu ñivi Jesucristu, ra kūu ñivi ma racha'nu David, chi'in racha'nu Abraham. ");
INSERT INTO mza_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham kūu tatá ma Isaac, ta Isaac kūu tatá ma Jacob, ta Jacob kūu tatá ma Judá chi'in ma ndra yani ra. ");
INSERT INTO mza_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá kūu tatá ma Fares, chi'in Zara, ta ma ma'á vi kūu Tamar. Fares kūu tatá ma Esrom, ta ma Esrom kūu tatá ma Aram. ");
INSERT INTO mza_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram kūu tatá ma Aminadab, ta ma Aminadab kūu tatá ma Naasón, ta Naasón kūu tatá ma Salmón. ");
INSERT INTO mza_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón kūu tatá ma Booz, ta ma ma'á ra kūu Rahab. Booz kūu tatá ma Obed, ta ma ma'á ra kūu Rut. Ta Obed kūu tatá ma Isaí. ");
INSERT INTO mza_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí kūu tatá ma rey David. Ta ma rey David chi'in ma ña kūu ñasi'i ma Urías, vikan kūu tatá ma Salomón. ");
INSERT INTO mza_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón kūu tatá ma Roboam, ta Roboam kūu tatá ma Abías, ta Abías kūu tatá ma Asa. ");
INSERT INTO mza_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kūu tatá ma Josafat, ta Josafat kūu tatá ma Joram, ta ma Joram kūu tatá ma Uzías. ");
INSERT INTO mza_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías kūu tatá ma Jotam, ta Jotam kūu tatá ma Acaz, ta ra'ya kūu tatá ma Ezequías. ");
INSERT INTO mza_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías kūu tatá ma Manasés, ta Manasés kūu tatá ma Amón, ta Amón kūu tatá ma Josías. ");
INSERT INTO mza_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías kūu tatá ma Jeconías chi'in ma ndra yani ra, ma tiempu ña tīin ma ndra ñu'u' ñuu Babilonia ma ndian israelita, ta kuà'an na chi'in ndra iti' tikan. ");
INSERT INTO mza_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ta ora yā'a, ña tā'an na takan, tajan Jeconías kūu tatá ma Salatiel, ta Salatiel kūu tatá ma Zorobabel. ");
INSERT INTO mza_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel kūu tatá ma Abiud, ta Abiud kūu tatá ma Eliaquim, ta ra'ya kūu tatá ma Azor. ");
INSERT INTO mza_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor kūu tatá ma Sadoc, ta Sadoc kūu tatá ma Aquim, ta Aquim kūu tatá ma Eliud. ");
INSERT INTO mza_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud kūu tatá ma Eleazar, ta Eleazar kūu tatá ma Matán, ta Matán kūu tatá ma Jacob. ");
INSERT INTO mza_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob kūu tatá ma Kusé, ra kùu ii ma Ndiya, ta Ndiya kūu ma'á Jesuu, ra kà'an yo ña kùu Cristu. ");
INSERT INTO mza_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ta takan kūu yi ña, chīyo uchi kumi ta'an ñivi ña kùu tata ma Abraham, nda kati kēta ma tiempu ña chīyo ma racha'nu David. Ta inga uchi kumi ma ndian kùu tata ma David chīyo, nda ora kēta ma kivi ña tīin ma ndra ñu'u' ñuu Babilonia ma ndian israelita, ta kuà'an na chi'in ndra ma iti' tikan. Ta inga uchi kumi ma ndian kùu tata ra chīyo, nda ma tiempu ikan, ta nda ma ora kāku ndio ma Cristu. ");
INSERT INTO mza_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ma ora kāku Jesucristu, te'en kūu yi: ma Ndiya ña kūu ma'á ra, cha chā'a ña tu'un nuu ma Kusé, ña ni tanda'a ña chi'in ra. Va antea ña ndò'iin vi, yakan cha chāku'un se'an jā'a ndatu ma Ra kùu Tati Ií Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ta ma Kusé, ra ni tanda'a chi'in Ndiya, ti iin ra va'a, ta ndaa kùu ra. Cha'a' yakan kùu yi ña, töve kùuni ra ku'va ra ña koto ma ñivi ma ña chànini ra ja'a ra. Vati ma ña kùuni ra ja'a ra, kùu yi ña, kùuni ra ndakoo xe'e ra ña. ");
INSERT INTO mza_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ta ma ora juuni yanga chànini ra te'en, tajan iin ma tati ña jàkuu tiñu nuu ma Racha'nu, kēta yi nuu Kusé tañu ñuma'na ra, ta te'en nāka'an yi chi'in ra: ―Yo'o Kusé, ra kùu ñivi ma racha'nu David, na yü'viun ña ndàki'un ma Ndiya kùu ñasi'un ña, vati ma Tati Ií Ndioo jā'a ña ni koo ma se'an. ");
INSERT INTO mza_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yakan, ni koo se'an, ta ni jakunaniun ra, Jesuu. Takan ni kunani ra, vati ni jakakú ra ma ñivi ñuu ra cha'a' ma kuati jà'a na. ―Takan kàti ma tati tatun Ndioo chi'in Kusé ma tañu ñuma'na ra. ");
INSERT INTO mza_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ndisaa ña'a takan kūu yi, ikan na jachinu ma tu'un kā'an ma Racha'nu nuu iin ra kā'an chi'in tu'un yu'u ra, ti rakan te'en kā'an ra: ");
INSERT INTO mza_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ma ñayoko ña takä'an kì'vi chi'in nï'iin ra'ii, ni kuku'un se'an, ta ni jakakuan yi, ta ma ra kùu pa'a ikan ni jakunani na yi Emanuel, ña kùuni yi ka'an yi: ìyo Ndioo chi'in yo. ");
INSERT INTO mza_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Takan kūu ta ora ndākoo ndio ma Kusé ña kìxi ra, tajan jā'a ndio ra ma takua kā'an ma tati tatun Ndioo nuu ra, ta ndāki'in ndio ra ma Ndiya chūndaka ra. ");
INSERT INTO mza_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Va vaji ndō'iin ra chi'an, va töve nī kixi ra chi'an, nda kati ya'a ji'na kāku ma ra kùu pa'a se'an, ra jākunani ma Kusé, Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ora kāku Jesuu ma ñuu nàni Belén, ña ìyo kuenda ma ñu'u' Judea, ma tiempu ikan ti, ma rey Herode kùu ma ra chā'nda tiñu ma ñu'u' ikan. Tajan iin ma ndra kīchi iti' kàna nikandii, ndra ya'a ga chìto ña kā'an, chāa ndra ma ñuu Jerusalén, ");
INSERT INTO mza_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ta te'en chīkatu'un ndra: ―¿Ndanu kàndii ma ra já kāku, ña kùu rey kuenda ma ñivi judíu? Vati ndē'e ndi ña kēta ma chele ra iti' kàna nikandii, ta cha'a' yakan kùu yi, ña vàchi ndi vàchi jàka'nu ndi ra ma i'ya ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tajan ora chīto ndio ma rey Herode ña takan chàkunuu ndra chìkatu'un ndra, ta ndava yū'vi ra, chi'in tandi'i ma ñivi ìyo ma ñuu Jerusalén ndia. ");
INSERT INTO mza_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tajan kāna ndio ra tandi'i ma ndra sutu cha'nu ña kuxini nuu sutu, ta chi'in tandi'i ma ndra matru ña jàna'a tu'un ley Ndioo nuu ma ñivi, ta chīkatu'un ndio ma rey Herode nuu ndra, ña ndanu kùu ma nuu ni kàku ma Cristu. ");
INSERT INTO mza_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ta ndrakan te'en nāka'an ndra chi'in ra: ―Ni kàku ra ma ñuu Belén ña ìyo kuenda ma ñu'u' Judea, vati te'en kà'an ma tu'un tāa ma ra kā'an chi'in tu'un yu'u Ndioo taji'na: ");
INSERT INTO mza_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yo'o ñuu Belén, vaji ñuu vali kùu̱n, vati ya'a ka'nu kùu̱n tañu tandi'i ñuu ìyo kuenda ñu'u' Judea, va tañu ma ñiviun ìyo ikan, ni keta iin ma ra ni kuxini, ta rakan ni jakuenda ra ma ndian kùu ñivi̱ ñuu Israel. Takan kàti yi nuu ma tutu Ndioo ―kàti ndra nuu rey Herode. ");
INSERT INTO mza_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tajan kāna xe'e ndio ma rey Herode ma ndra chìto ña kā'an, ta chīkatu'un kachin ndio ra nuu ndra, nda kivi kùu yi ña kēta ma chele ña ndē'e ndra. ");
INSERT INTO mza_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ta ora yā'a ndio yi, tajan tāchi ndio ra ndra ma ñuu Belén, ta te'en nāka'an ra chi'in ndra: ―Kuà'an ndo ndakan, ta na nanduku tu'un ndo nuu ndisaa ma ñivi cha'a' ma ravali ikan. Ta ora cha nāta'an ndo ra, na kichi katitu'un ndo nui, vati juuni kùuni̱ kujaka'nui ra ndia ―kàti rey Herode chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tajan ma ndra chìto ña kā'an, kēe ndio ndra kàcha'an ndra chi'in ma tu'un ña kātitu'un ma rey nuu ndra. Takan kūu ta ma chele ña ndē'e ndra ma iti' kàna nikandii, kēta ndiko ri nuu ndra, ta endee yosonuu ri kuà'an ri nuu ndra. Ta ora chāa ndio ri ma nuu kàndii ma pa'a, tajan chūndaa ndio ri. ");
INSERT INTO mza_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ta ma ndra chìto ña kā'an, nduva'a kuii chīsii ndra ña ndē'e ndiko ndra ma chele ikan. ");
INSERT INTO mza_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Takan kūu ta ora kāki'vi ndio ndra ma tichi ve'e, ta ndē'e ndra ma pa'a chi'in ma Ndiya ña kùu ma'á ra. Tajan chūnandi chiti ndio ndra, ta jāka'nu ndra ra. Ta ikan jan, ta'ii'iin ndra nūna ndio ndra ma chatun vali ña nda'a ndra, ta sōkó ndra oro, kutu, chi'in takuii xiko ña nàni mirra nuu ma pa'a. ");
INSERT INTO mza_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Va tava kēta iin tati va'a ña jà'a tiñu nuu Ndioo nuu ndra ma tañu ñuma'na ndra, ña kātitu'un yi nuu ndra, ña na tüva nuva jà'a ndra ña chìkoni'i ndra ku'un ndra ma iti' nuu kīchi ndra nuu ìyo ma rey Herode kàti yi. Tajan kēe ndio ndra kuà'an ndra ñuu ndra, va inga iti'. ");
INSERT INTO mza_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Takan kūu ta ora yā'a ña kēe ndio ma ndra chìto ña kā'an kàcha'an ndra, tajan iin tati va'a ña jà'a tiñu nuu ma Racha'nu Ndioo, kēta yi nuu Kusé tañu ñuma'na ra, ta te'en nāka'an yi chi'in ra: ―Kusé, na ndetaun, ta ki'un ma ravali chi'in ma ma'á ra, ta kee ndo ku'un ndo ta kunu xe'e ndo ku'un ndo chi'in ra iti' ñu'u' Egiptu. Ta ndakan na kindoun koun, ta chikoni'i ndikoun nda kati katitu'un mai nuu̱n. Vati ma rey Herode, ni nanduku ra ma ravali, ta ni ka'ni ra ra. ―Takan kàti ma tati jà'a tiñu nuu Ndioo nuu ma Kusé. ");
INSERT INTO mza_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tajan ndākoo ndio ma Kusé, ta kī'in ra ma ravali chi'in ma ma'á ra, ta kēe ndio vi kàcha'an vi ma iti' ñu'u' Egiptu ma ora chanikuaa. ");
INSERT INTO mza_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ikan chīyo vi, nda kati chī'í rey Herode. Takan kūu yi, ikan na chinu ma tu'un kā'an ma Racha'nu Ndioo, jà'a iin ra kā'an chi'in tu'un yu'u ra, ma nuu kà'an yi te'en: “Ñu'u' Egiptu kānai ma ra se'i.” Takan kàti Ndioo, kàti ma ra kà'an chi'in tu'un yu'u ra. ");
INSERT INTO mza_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Takan kūu ta ora chā'a ndio ma Herode kuenda, ña jānda'viña'a ma ndra chìto ña kā'an ra, nduva'a kāyuni ra. Tajan tāchi ra ña na ka'ni ndra tandi'i ma ndra'ii kuati, ña ìyo uvi kuiya iti' ninuu, ña ìyo ma ñuu Belén, ta chi'in tandi'i kuariya ña ìyo kuenda yi, ma naja kua kùu ma tiempu ña chā'a ma ndra chìto ña kā'an ma nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ta te'en jāchinu ma ra kā'an chi'in tu'un yu'u Ndioo, ña nàni Jeremía ma tu'un tāa ra nuu ma tutu ra: ");
INSERT INTO mza_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Iti' ñuu nàni Ramá chīni ma ñivi tati iin ña'a, ña nduva'a kuii chàku ña jà'a ña ya'a u'vi anima ña, ta nda'vi kùunian. Ta ma tati ikan kùu yi ma tati Raquel, ña chàkuan cha'a' ma ndrakuati se'an. Ta endee töve kuunian ña jàndomani na ña, vati chī'í ma se'an. Takan kàti ma Jeremía. ");
INSERT INTO mza_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Takan kūu ta ora yā'a ña chī'í ndio ma rey Herode, tajan iin tati ña jà'a tiñu nuu ma Racha'nu, kēta yi nuu Kusé tañu ñuma'na ra ma ñuu Egiptu, ta te'en nāka'an yi chi'in ra: ");
INSERT INTO mza_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Na ndetaun, ta ki'un ma ravali chi'in ma ma'á ra, ta chìkoni'i ndikoun chi'in vi ma iti' ñu'u' Israel, ti cha kāchi'í ma ndra kùuni ka'ni ra. ―Takan kàti yi chi'in Kusé. ");
INSERT INTO mza_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tajan ndākoo ndio ma Kusé, ta kī'in ra ma ravali nda'a' ma ma'á ra, ta kēe ndio vi kuà'an vi ma ñuu Israel. ");
INSERT INTO mza_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Va ora chīto ndio ma Kusé ña Arquelao se'e ma ndi Herode, kùu ra ña chà'nda ra tiñu, ma ñu'u' Judea, tiñu chākoo tatá ra niku, ta yū'vi ra ña ku'un ra ma tikan, va tava kātitu'un ndiko ma Racha'nu Ndioo nuu ra ma tañu ñuma'na ra, yakan va tüva nī cha'an ndio ra ma iti' tikan, tajan kēe ndio ra kuà'an ra iti' ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Takan kūu ta ora chāa ndio ra ma ñu'u' ikan, tajan chā'an ndio ra chākoo ra ma iin ñuu nàni Nazaret. Ña'á takan kūu yi, ikan na chinu ma tu'un ña kātitu'un ma ndra kā'an chi'in tu'un yu'u Ndioo niku, vati kà'an ndra ña ni kunani ma Cristu, iin Nazarenu, kāti ndra. ");
INSERT INTO mza_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma tiempu ikan kēta ma Xuva, ra jàkunduta, kàtitu'un ra tu'un Ndioo nuu ma ñivi tichi ku'u ma ñu'u' Judea, ");
INSERT INTO mza_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ta rakan te'en nāka'an ra: ―¡Na jaña ndo ña jà'a ndo ma kuati, vati cha kēta ma kivi ña ni nde'o nuu chà'nda Ndioo tiñu! ―kàti ra chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Cha'a' ma Xuva i'ya kùu yi, ña te'en kā'an ma Isaía, ra kā'an chi'in tu'un yu'u Ndioo niku: Iti' tichi ku'u kīchi tati iin ra'ii, ña te'en kānachaa ni'i yi: “Na jandova'a ndo iin iti' kuenda ma Racha'nu, ta na nuna ndo iin iti' ndoo kuenda ra ndia.” Takan kàti ma tati ikan, kāti ma Isaía. ");
INSERT INTO mza_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ta ma ja'ma ña ñu'u ma Xuva, kūva'a yi chi'in ixi kameyu, ta chi'in pañu ñii, chù'ni ra yi toko ra. Ta chàchi ra tikaa kua'á, ta ña chì'i ra, kùu ma nduxi ñuñu ku'u. ");
INSERT INTO mza_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ta ma ndian chàa ña chìni ma ña kà'an ra, kùu ma ndian ñuu Jerusalén, chi'in tandi'i ma ndian ñu'u' Judea, ta chi'in inga ma ndian ìyo ñu'u' ña kandii yatini ma yuta Jordán. ");
INSERT INTO mza_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ta ora nà'ma na kuati na nuu ma Xuva, ta rakan chājakunduta ra na ma yuta Jordán. ");
INSERT INTO mza_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Va ora ndē'e ma Xuva ña ya'a kua'a' ma ndra fariseu, chi'in ndra saduceu, kācha'an ndra, ña na jakunduta ra ndra, yakan va te'en nāka'an ra chi'in ndra: ―¡Ndyo'o tatá ndian xaan, tava kùu ma koo kaa! ¿Yo kà'an chi'in ndo ña ni kakú ndo nuu ma tundo'o ya'a xaan ña cha vàchi kuyatin? ");
INSERT INTO mza_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tuva ndicha ña cha chīkoni'i ndo iti' ma Racha'nu, na koo va'a ndo ma takua kùuni ra ña koo ndo tuva takan, ");
INSERT INTO mza_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ta koto jätayi ndo ndo chi'in juuni maa ndo, ta ka'an ndo te'en: “Ndyu'u kùu ndi tata ma Abraham”, kati ndo. Vati yu'u kà'in chi'in ndo, ña nda ma yuu ña kàndoyo i'ya, kùu jàndaku ma Racha'nu Ndioo yi, tata ma Abraham ndia. ");
INSERT INTO mza_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Vati cha ìyo tu'va ma hacha kuenda ña ta'nda tandi'i ndava nda yo'ó ma yutun ña töve chà'a chiti va'a, ta ku'un ndrun nuu ñu'ú. ");
INSERT INTO mza_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ndicha va'a, ña yu'u jàkundutai ndo chi'in takuini, kuenda ña na jana'a yi, ña cha jāña ndo ma kuati jà'a ndo. Va inga ma ra ni kichi tia iti' nuu, ni jakunduta ra ndo chi'in sivi ma Tati Ií Ndioo, ta chi'in ñu'ú. Rakan kùu ma ra nduva'a ga ìyo ndatu kua yu'u, ña ni töve ìyo yi ña kuisoi, ni ma ndichan ra. ");
INSERT INTO mza_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ta cha nda'a ra iin kaa ña ìyo uni kumi punta kuenda ña jandati ra ma trigu iti' nuu sukun, ta takan tàvani'i siin ra ma soo vu. Tajan ni taan va'a ndio ra ma trigu ra tichi yaka. Va ma soo vu, va ni ka'mi ra nuu ñu'ú ña endee töve ndà'va. ");
INSERT INTO mza_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Takan kūu tajan Jesuu kīchi ra iti' ñu'u' Galilea, ta chāa ra ma yuta Jordán nuu ndaa ma Xuva, kuenda ña na jakunduta ra ra. ");
INSERT INTO mza_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Va ma Xuva, na küuni ra ja'a ra yi, ti java te'en nāka'an ra chi'in Jesuu: ―Yu'u, kùu ma ra ìyo yi ña jakundutaun, ta yo'o, ¿chïto naja vàchiun nui, ña na jakundutai ñu̱n? ―Takan kàti Xuva chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Va Jesuu te'en nāka'an ra chi'in ra: ―Vä'a' ña kà'un takan, va'a ga ña jakundutaun yu'u vitin, vati takan jàchinu yo tandi'i ma ña kùuni ma Ndioo. ―Takan kàti Jesuu chi'in ra. Tajan ma Xuva kāti ra ña va'a. ");
INSERT INTO mza_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ta ora cha kūnduta ndio Jesuu, ta kēe ndio ra ma tichi takuii, tajan juuni ma ora ikani, nūna ma andivi, ta ikan ndē'e ndio ra, ña ma Tati Ií Ndioo, vàchi nuu yi chata Jesuu tava kàa iin livi, ta chūnandi yi chata ra. ");
INSERT INTO mza_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tajan ma iti' andivi chīni na iin tati ña te'en kà'an: ―Ra'ya kùu ma ra Se'i, ña ya'a kùuni̱ nde'i, ta ya'a chìsii̱ ña kùu ra takan. ―Takan kàti ma tati chīni na. ");
INSERT INTO mza_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ta ora yā'a, tajan chāka ndio ma Tati Ií Ndioo ma Jesuu iti' tichi ku'u, kuenda ña na ki'in ma kui'na ku'va ra. ");
INSERT INTO mza_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ta ma nuu chīyo ra ikan, tüvi nī chachi ra uvi xiko kivi, ta uvi xiko chanikuaa. Ta ora yā'a, tajan chāñu ndio ma soko ra. ");
INSERT INTO mza_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tajan ma kui'na chajāyatin ndioán' ñá' nuu Jesuu kuenda ña ni ki'in ndioán' ku'va ra, ta te'en nāka'an ndioán' chi'in ra: ―Tu ndicha va'a ña ra Se'e Ndioo kùu̱n, na ka'un chi'in ma yuu ña ndoyo chiña, ña na ndakuu yi paan. ―Takan kàti ma kui'na chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Va Jesuu te'en nāka'an ra: ―Nuu ma tutu Ndioo te'en kà'an yi: “Na yöve uvanuu ma ña chàchinio kùu ja'a ña na taku ma ñivi, vati juuni kùu taku na ja'a tandi'i ma tu'un ña kà'an Ndioo ndia” ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tajan chāka ndio ma kui'na ma Jesuu kuà'an ra chi'án' ñuu Jerusalén ií, ta ikan jāndaa ndio ma kui'na ma Jesuu nuu sukun ga xini ma veñu'u ka'nu ikan, ");
INSERT INTO mza_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ta te'en nāka'án' ndioán' chi'in ra: ―Tu ndicha ña ra Se'e Ndioo kùu̱n, na koyoun ma nda ninuu, vati nuu ma tutu Ndioo, te'en kà'an yi: Ndioo, ni tachi ra ma tati ña jà'a tiñu nuu ra, ña na jakuenda yi ñu̱n. Ma tati ikan kùu yi ña ni kani'i na ñu̱n, chi'in nda'a' na, ikan na töve takue'e cha'un jà'a nï'iin yuu ―kàti ma kui'na chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ta Jesuu te'en nāka'an ra chi'án': ―Nda nuu ma tutu Ndioo, juuni te'en kà'an yi ndia: “Töve ìyo yi ña ki'un ku'va ma Racha'nu Ndioo.” Takan kàti yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Takan kūu ta chāndaka tukuán' ra iin xini yuku sukun nduva'a kuii, ta ora kīcha'a ndioán' jàna'án' nuu Jesuu ndisaa ma ñuu ñuñivi nuu chà'ndán' tiñu nuu Jesuu, ta naja kua ya'a ka'nu kùu yi. ");
INSERT INTO mza_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tajan te'en nāka'an ndioán' chi'in ra: ―Tu kunandi chitiun nui, ta jaka'nu̱n yu'u, ni ku'vai tandi'i ma nuu chà'ndai tiñu nuu̱n ―kàti ma kui'na chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tajan Jesuu te'en nāka'an ra chi'án': ―Kuà'an, tikan yo'o kui'na, vati nuu ma tutu Ndioo, te'en kà'an yi: “Na jaka'nu̱n ma Racha'nu Ndiooun, ta uvanuu rakani na ja'un tiñu nuu” ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tajan ma kui'na ndākoo ndioán' Jesuu, ta ikan jan chākoyo ndio ma ndian kùu tati ña jà'a tiñu nuu Ndioo, ta kīcha'a na tìndee na ra. ");
INSERT INTO mza_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Takan kūu ta ora chīto Jesuu ña ma Xuva indii ra tichi vekaa, tajan kēe ndio ra kuà'an ra ma ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Va töve nī kindoo ra koo ra ma ñuu Nazaret, ti yā'a ra kuàkoo ra ma ñuu Capernaum, ña kàndii yu'u tañu'u, yatini nuu kàndii ma ñu'u' Zabulón, chi'in ñu'u' Neftalí. ");
INSERT INTO mza_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tandi'i ña'á kūu yi takan, ikan na chinu ma tu'un ña tāa ma Isaía, ra kā'an chi'in tu'un yu'u Ndioo, nuu kā'an ra te'en: ");
INSERT INTO mza_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Na taso'o ndo ndyo'o ìyo ñu'u' Zabulón, ta ñu'u' Neftalí ña kàndii inga chiyo yu'u yuta Jordán, tichi iti' kuà'an tañu'u ña nàni Galilea, nuu ìyo ndian yüvi judíu. ");
INSERT INTO mza_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Vati ndyo'o ndian chàkunuu nuu naa niku, cha kīcha'a ndè'e ndo iin ñu'ú ya'a ka'nu, iti' chākunuu ndo niku töve iti' va'a kùu yi ti ni naa ndo jà'a yi, va vitin ma Racha'nu cha jāndondichin va'a ra yi kuenda ndo. Takan tāa Isaía. ");
INSERT INTO mza_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nda ma ora ikan kùu yi, ña kīcha'a Jesuu kàtitu'un ra tu'un Ndioo te'en nuu ma ñivi: ―Na jaña ndo ña jà'a ndo ma kuati, vati cha vàchi kuyatin nuu chà'nda ma ra ìyo andivi tiñu ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ta ora chàkunuu Jesuu ma yu'u tañu'u ña kàndii ma ñu'u' Galilea, ikan ndē'e ra uvi ta'an ndra ña kùu ndra yani ndra. Iin ra nàni Simón, ra juuni kà'an na ña nàni Petu', ta inga ra nàni André. Ta ndrakan, ti kàni ndra yu'va tiaka' ka'nu tichi takuii chàkunuu ndra, ti ndra kìin kùu ndra. ");
INSERT INTO mza_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―¡Na tandikun ndo chatai!, ta yu'u ni ja'i ña na nani'i ndo ñivi kuenda Ndioo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma ora ikani ndākoo ndra ma yu'va tiaka' ka'nu, ta tāndiku ndra chata ra. ");
INSERT INTO mza_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ta ita'vi tiá iti' nuu, ikan ndē'e Jesuu inga uvi ta'an ndra ña juuni yani ndra ndia. Iin ra nàni Jandiau, chi'in Xuva, ndra se'e Zebedeu. Ndrakan ka'ìin ndra jàndova'a ndra yu'va tiaka' ka'nu, chi'in tatá ndra, tichi iin varku, ora kāna Jesuu ndra. ");
INSERT INTO mza_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma ora ikani ndākoo ndra ma tatá ndra tichi run, ta tāndikun ndra kuà'an ndra chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesuu chàkunuu ra jàna'a ra tu'un Ndioo ninii ka'nu ma ñu'u' Galilea, nuu kàndii ta'ii'iin ma kuariya nuu ìyo ma veñu'u kuati ñivi judíu. Kàtitu'un ra nuu na, naja kua kùu ma nuu chà'nda Ndioo tiñu iti' andivi, ta juuni jànda'a ra ndian ku'vi, chi'in tandi'i nuu ma kue'e ndo'o na. ");
INSERT INTO mza_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ta takan kūu ña chītakuati ma tu'un cha'a' Jesuu nuu ma ñivi ìyo ninii ka'nu ma ñu'u' Siria. Ta chāndaka na ndian ku'vi jà'a siin siin nuu ma kue'e, takua kùu ma ndian ku'vi jà'a kue'e u'vi na, chi'in ndian ku'vi jà'a tati xaan, ndian chì'i i'i, chi'in ndian endee pe'lu kuñu, ta jānda'a ra na. ");
INSERT INTO mza_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ta kua'a' ñivi ìyo ñu'u' Galilea, chi'in ñuu Decápolis, ña kùuni yi ka'an yi, uchi ñuu, ta ndian ñuu Jerusalén ña ìyo kuenda ma ñu'u' Judea, ta nda ma ñuu ña kàndii inga chiyo yuta Jordán. Tandi'i ndiakan tāndikun na kuà'an na chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ta ora ndē'e Jesuu ña ka'ìin kua'a' ñivi, tajan ndāa ndio ra xini yuku, ta chūnandi ra. Ta ikan jan chājayatin ndio ma ndra jàkua'a chi'in ra nuu nàndi ra, ta chīkonuu ndra ra, ");
INSERT INTO mza_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ta te'en kīcha'a ndio ra jàna'a ra nuu ndra: ");
INSERT INTO mza_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Na sii kuuni ma ndian nda'vi ña chà'a na kuenda ña chìniñu'u na Ndioo, vati kuenda maa na kùu ma nuu chà'nda ra tiñu iti' andivi. ");
INSERT INTO mza_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Na sii kuuni ma ndian chàku ta nda'vi kùuni, vati ma Racha'nu Ndioo ni ndakimani ra na. ");
INSERT INTO mza_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Na sii kuuni ma ndian vita anima, vati tiaga iti' nuu, ni ni'i na ma ñu'u' ña cha chā'a ma Racha'nu Ndioo tu'un ña ni ku'va ra nuu na. ");
INSERT INTO mza_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Na sii kuuni ma ndian ya'a ìyoni jàkuu tiñu va'a takua kùuni Ndioo, ta chi'in ma ndian ya'a nàtii na ña kùuni na nde'e na ra, takua kùuni na ora nàtii na takuii, vati ma Racha'nu Ndioo, ni tindee ra na ña na ja'a na yi. ");
INSERT INTO mza_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Na sii kuuni ma ndian kùnda'vini nde'e inga ñivi, vati Ndioo, ni kunda'vini ra na ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ta na sii kuuni ma ndian ndicha ña kùuni na nde'e na ma Racha'nu Ndioo, vati ndiakan ni nde'e na ra. ");
INSERT INTO mza_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Na sii kuuni ma ndian nànduku naja kua koo va'a na chi'in ta'an na, vati ma Racha'nu Ndioo ni jandakuu ra na se'e ra. ");
INSERT INTO mza_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ta juuni na sii kuuni ma ndian ndè'e tundo'o, cha'a' ña jà'a na ma ña kùuni Ndioo, vati kuenda maa na kùu ma nuu chà'nda ra tiñu andivi. ");
INSERT INTO mza_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Na sii kuuni ndyo'o ora inga ñivi kanduva'a na ndo, ta chi'in ndyo'o ndian jànde'e na tundo'o, ta tisokuati na ndo chi'in tu'un vata cha'i. ");
INSERT INTO mza_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Na sii kuuni ndo, vati ni ni'i ndo iin ya'vi nduva'a ka'nu ma iti' andivi, ti takua jà'a na chi'in ndo, juuni kua ikan jā'a na chi'in ma ndian kā'an chi'in tu'un yu'u Ndioo ña chīyo taji'na ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Ndyo'o kùu ndo takua kùu ma ñií ña ìyo ma ñuñivi i'ya, cha'a' ña kùu ndo ndian chìnuni. Va tu ma ñií ikan jàña yi ña u'vá yi, ¿niyi ìyo yi ña ja'a yo chi'in yi, ta kùu ndo'uva ndiko yi, ta kuàtiñu yo yi inga cha'a'?, kùuni ndo. Va'aga ña na jakuita ndo yi kuenda ña na kuañunia ma ñivi chata yi, ti na tüva nakutiñu yi. ");
INSERT INTO mza_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ndyo'o kùu ndo tava kùu ma ñu'ú ña jàndondichin ma ñuñivi. Ta tu iin ñuu kàndii yi xini yuku, na küu kundii xe'e yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ta na tüvi jàtiin yo iin ñu'ú kandil, ta kasi yo nuu yi chi'in iin cajon, vati ma ña jà'a yo kùu yi ña, va'a jùndii yo yi nuu sukun, ikan na jandondichin yi nuu tandi'i ma ñivi ka'ìin tichi ve'e. ");
INSERT INTO mza_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yakan va ndyo'o juuni kua ikan ìyo yi ña nanduku ndo naja kua koo va'a ndo chi'in tandi'i ñivi, ikan na nde'e na ma tiñu va'a jà'a ndo, ta ndita'an na jàka'nu na ma Racha'nu Tatá ndo ña ìyo andivi ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ta koto näkanini ndo, ña yu'u kùu ra vàchi janaa ma ley Ndioo ña tāa Moisés, ta ña vàchi janai ma tu'un Ndioo ña jàna'a ma ndra kà'an chi'in tu'un yu'u ra ndia, ti na yöve takan kùu yi. Ma tiñu vàchi̱ kùu yi ña, kàtitu'un kachi̱n ma ña kùuni ma ley Ndioo ka'an yi. ");
INSERT INTO mza_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ndicha va'a ña kà'in chi'in ndo ña, ora juuni yanga ìyo ma andivi, chi'in ma ñu'u' ñuñivi, nï'iin tu'un vali ña ìyo nuu ma ley cha'nu, ta nï'iin letra na töve ni kindaa, nda kati kuu ji'na ma ña ìyo yi ña kuu. ");
INSERT INTO mza_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yakan va ma ndian jàchi'in na ma ña kùuni ma ley Ndioo ña jà'a na, va kùmani jàchi'in na uvanuu ña kà'an yi, vaji iin tu'un valini kùu yi, ta ndian töve chà'a na ña na koto inga ñivi yi, ta jà'a na indukuni, ndiakan ni ndakuu na, ndian valiga ma nuu chà'nda Ndioo tiñu andivi. Va ma ndian jàchi'in ña kà'an yi, ta chà'a na ña na koto inga ñivi ma ña kà'an yi, ndiakan kùu ma ndian ni ndakuu ka'nuga, ma nuu chà'nda Ndioo tiñu andivi. ");
INSERT INTO mza_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Vati yu'u kà'in chi'in ndo ña, tu töve kùuni tiaga ndo ja'a ndo ma kua kùuni Ndioo, takua kùu ma ndra matru jàna'a tu'un Ndioo chi'in ma ndra fariseu, ña na küuni ndra jàchinu ndra ma ña kùuni Ndioo, na küu ki'vi ndo koo ndo chi'in ra nuu chà'nda ra tiñu andivi. ");
INSERT INTO mza_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ndyo'o cha chìto va'a ndo ña tatiempu cha chīni ndo tu'un Ndioo ña te'en kà'an yi naja kua ìyo yi ña ja'a ndo: “Na kä'ni ndo, ti ma ndian chà'ni ìyo yi ña ka'nda na kuati na.” ");
INSERT INTO mza_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Va yu'u kà'in chi'in ndo ña nda ndyo'o ni kùuni, tu xàani ndo nde'e ndo ta'an ndo, ìyo yi ña ka'nda ndo kuati ndo ndia. Ta tu kanduva'a ndo ta'an ndo ìyo yi ña ya'a ndo nuu ma ndra kumitiñu, ta jàkutuni ndra ma kuati ndo. Ta tu kàti ndo ña ndian ndava xini kùu na, na ja'a ndo kuenda nuu ndo koto ku'un ndo andaya' nuu tìin ñu'ú. ");
INSERT INTO mza_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ta indukuni kùu yi tuva ma ora sokó ndo iin nakuyi nuu ma chito naá kuenda Ndioo, ta ikan chàku'uni ndo ña ìyo kuati ndo chi'in inga ta'an ndo, ");
INSERT INTO mza_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na ndakoo nuu ndo ma ña ni sokó ndo nuu Ndioo ma ikan, ta ku'un ji'na ndo kundakan ndo nuu ta'an ndo ña na jaka'nuni na ma kuati ndo, tajan na chikoni'i ndio ndo nuu ìyo ma nuu naa, ta na sokó ndio ndo yi kuenda Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tu ìyo iin nda yo kùuni ti'i kuati cha'a' ndo ma vetiñu. Va'a ga ña na ka'an ji'na ndo tichi iti' kuà'an ndo chi'in na, ta ikan na jandakumani ndiko ndo na, ikan na tüvi tì'i na ndo nda'a' ma ra juez ña jàndondaa kuati, ta rakan ku'va ndio ra ndo nda'a' ma ndra jandaru, ta tì'i ndra ndo tichi vekaa. ");
INSERT INTO mza_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta ndicha va'i ña kà'in chi'in ndo ña na töve ni kee ndo ikan, nda kati tia'vi ndi'i ji'na ndo ma xu'un' ña na nandoo kuati ndo. ");
INSERT INTO mza_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Vati ndyo'o cha chīni ndo iin tu'un ña te'en kà'an tatiempu: “Na kï'vi ndo chi'in ñivi ña'a yöve ñasi'i ndo.” ");
INSERT INTO mza_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Va yu'u kà'in chi'in ndo, ña nda ndra'ii nikuuni, jitu chi'in iin ña ndè'eni ndra iin ña'a, ta chàta'ani ndra, ña kùuni yi ka'an yi ña indukuni kùu ma kuati jà'a ndra chi'an chi'in chinituni ndra kua ma ndra cha kī'vi ndra chi'in iin ña'a ma chi'in ma kuñu ndra. ");
INSERT INTO mza_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Ta tu ma tinuu chiyo kua'a' ndo kùu yi ña jàkoyo yi ndo ma tichi kuati, na tava ndo yi, ta jakuita chika ndo yi. Vati va'aga ña na kenaa iin chiyo tinuu ndo, kua ña ku'un ndisaa ma kuñu ndo andaya'. ");
INSERT INTO mza_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ta tu ma nda'a' chiyo kua'a ndo kùu yi ña jàkoyo yi ndo ma tichi kuati, na ka'nda ndo yi, ta jakuita chika ndo yi. Vati va'aga ña na kenaa iin chiyo nda'a' ndo kua ña ku'un ndisaa ma kuñu ndo andaya'. ");
INSERT INTO mza_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ta juuni cha chà'a ndo kuenda ña te'en kà'an ma tu'un Ndioo ndia: “Nda ndra'ii nikuuni tuva ndàkoo ndo ñasi'i ndo, ìyo yi ña ku'va ndo iin tutu nuu kà'an yi ña cha ndākoo ndo ña.” ");
INSERT INTO mza_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Va yu'u kà'in chi'in ndo ña tu iin ra'ii ndàkoo ra ñasi'i ra, iin kuati kùu yi kuenda ra tu töve ndicha ña jànda'viña'a ña ra cha'a' ña kì'vi ña chi'in inga ra'ii. Vati tu takan ndākoo ra ña, rakan jà'a ra ña na ja'a ña kuati tu yakan ki'vian chi'in inga ra'ii. Ta nda ra ni kùuni ña tànda'a chi'in iin ña'a ña ndākoo ii, juuni iin kuati kùu ma ña jà'a ra, ti kì'vi ra chi'in iin ña'a ìyo inga ii ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ta juuni cha chīni ndo ña te'en kà'an ma ndian kūu ñivi yo chīyo taji'na ndia: “Ìyo yi ña jachinu ndo ma tu'un chà'a ndo nuu ma Racha'nu Ndioo”. ");
INSERT INTO mza_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Va yu'u kà'in chi'in ndo ña va'aga ña na kü'va ndo tu'un cha'a' nda ña nikuuni tu töve ña ndicha kùu yi. Na töve ìyo yi ña ku'va ndo tu'un cha'a' ma andivi, ti nuu chà'nda Ndioo tiñu kùu yi. ");
INSERT INTO mza_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ta ni cha'a' ma ñu'u' ñuñivi ndia, vati nuu nìndee cha'a Ndioo kùu yi ti iin ña kuenda ra kùu yi. Ta ni cha'a' ma ñuu Jerusalén, tüvi ìyo yi ña ku'va ndo tu'un, vati ma ñuu ka'nu ña ìyo kuenda Ndioo, ra kùu Rey ka'nu kùu yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ta juuni na tüvi ìyo yi ña ku'va ndo tu'un nuu ñivi cha'a' ma xini ndo, vati na küu jandokuichin ndo nï'iin ma ixi xini ndo, a jàndotuun ndo yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Va'aga ña na ka'an ndo ña: “juu” a “töve”, vati ndisaa inga tu'un ma ña kà'an siki ndo, kùu yi kuenda ma kui'na. ");
INSERT INTO mza_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ta juuni ndyo'o cha chīni ndo ña te'en kà'an ma tu'un ña kēta taji'na ndia: “Tu jàtakue'e na jitu iin ma tinuu ndo a nu'u ndo, indukuni ìyo yi ña ja'a ndo chi'in na ndia.” ");
INSERT INTO mza_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Va yu'u kà'in chi'in ndo ña: tuva ìyo nda yo kùuni kuati chi'in ndo, na jandeeni ndo yi, ta töve jà'a ndo takua jà'a na. Ta tu ìyo iin ndian kàni iin xa'nda iin chiyo cha'a so'o ndo, na ku'va ndo ma inga chiyo yi kàni na ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ta tu ìyo iin yo ti'i kuati cha'a' ndo ma vetiñu, ta kùuni na namaa na kamixa ñu'u ndo, na ku'va ndo ña na kunda'a na, nda ma ja'ma isukun ndo ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tu ìyo nda ndian chìkan ñamani nuu ndo ña na tindee ndo na, ña kuìso ndo iin ndatiñu na iin kilometru, na ku'un ndo chi'in ra nda uvi kilometru, na tindee ndo na. ");
INSERT INTO mza_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ta nda ndian nikuuni ña chìkan iin nakuyi nuu ndo, na ku'va ndo yi nuu na. Ta tu ìyo ndian chìkanuu iin nakuyi nuu ndo, na ku'va ndo yi nuu na, ta yüva kati ndo ña töve. ");
INSERT INTO mza_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ta juuni cha chīni ndo ma tu'un ña kà'an te'en tatiempu ndia: “Na kuuni ndo nde'e ndo ma ndian amigu ndo, ta na kuxaani ndo nde'e ndo ma ndian xaani ndo ndia.” ");
INSERT INTO mza_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Va yu'u kà'in chi'in ndo ña: Na kuuni ndo nde'e ndo ma ndian xaani ndo nde'e ndo, ta na ka'an ndo chi'in Ndioo cha'a' ma ndian kànduva'a ndo. ");
INSERT INTO mza_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Takan ìyo yi ña ja'a ndo, ta kùu ndo se'e ma Tatá ndo ra ìyo andivi. Vati maa ra kùu ra ña jàtuun ra nikandii kuenda ma ndian va'a, ta tüvi va'a. Ta juuni ra kùu ra ña jàkuun ra savi kuenda ma ndian ndaa, ta ndian töve ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Vati tu ma ndian kùuni nde'e ndo, ndiakani kùu ma ndian kùuni ndo nde'e ndo, ¿a chànini ndo ña ni ni'i ndo ya'vi ndo cha'a' ña jà'a ndo takan?, kùuni ndo. Na töve, vati nda ma ndra nàka'an xu'un' kuenda ñuu Roma, takan jà'a na ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ta tu kàña'a ndo chi'in ndian ta'ani ndian chìnuni, ¿nda ña va'a kùu ma ña jà'a ndo?, kùuni ndo. Vati nda ma ndian töve nàkoto Ndioo, takan kà'an na ndia. ");
INSERT INTO mza_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yakan va na kuu ndo ndian ndaa, tava kùu ma Tatá yo ra ìyo andivi. ");
INSERT INTO mza_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ta koto jä'a ndo tiñu va'a kuenda ña na nde'e ma ñivini ndo ña ndian va'a kùu ndo. Ta tu jà'a ndo takan tajan ma Tatá ndo, ra ìyo andivi, töve ni ku'va ra nï'iin ya'vi ndo. ");
INSERT INTO mza_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yakan va ora tìndee ndo ma ndian nda'vi ña kumani yi nuu, na töve ìyo yi ña ku'va ndo koto ndisaa ñivi yi, takua jà'a ma ndian uvi nuu kua chànini ña chàkunuu nàtu'un na chi'in ñivi, nani nuu ìyo ma veñu'u kuati ma ndian judíu, ta tichi kai, kuenda ña na ka'an va'a ma ñivi chatani na. Va yu'u kà'in chi'in ndo ña ndicha va'a ña cha ìyo ma ya'vi na cha'a' ma ña jà'a na. ");
INSERT INTO mza_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Va ndyo'o ora chà'a iin nakuyi nuu ma ndian nda'vi ña chìniñu'u yi, na töve ìyo yi ña natu'un ndo yi nuu nï'iin ma ndian nàkoto ndo, ta ni nuu ma amigu ka'nu ndo ndia. ");
INSERT INTO mza_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Va'aga ña na koto xe'eni ndo yi. Tajan ma Tatá ndo ra ìyo andivi ni ku'va ra ya'vi ndo, ti ndè'e ra ma ña jà'a xe'e ndo. ");
INSERT INTO mza_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ta ora kà'an ndo chi'in Ndioo, koto jä'a ndo takua jà'a ma ndian kini uvi nuu kua chànini ña ndava chàta'ani na kundaa na ora kà'an na chi'in Ndioo ma tichi veñu'u kuati ma ndian judíu, a ora kundaa na ma tutun kai kuenda ña na nde'e ma ñivini na. Ndicha va'a ña kà'in chi'in ndo ña, ndiakan juuni cha ìyo ya'vi na cha'a' ma ña jà'a na ndia. ");
INSERT INTO mza_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Va tu ndyo'o kùuni ndo ka'an ndo chi'in Ndioo, na ki'vi ndo tichi ve'e ndo, ta kasi ndo yuve'e, ta kicha'a ndio ndo ka'an ma'iin ndo chi'in Ndioo Tatá ndo, ti ìyo ra chi'in ndo ma ikan. Tajan ma Tatá ndo, ra ndè'e ma ña jà'a ndo, ni ku'va ra ya'vi ndo. ");
INSERT INTO mza_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ta ora kà'an ndo chi'in Ndioo, na töve ìyo yi ña indita inditani kā'un ma tu'un töve ndakutiñu, tava jà'a ma ndian töve nàkoto Ndioo. Vati ndiakan chànini na, ña tu kua'a' cha'a' kà'an na, juuni juuni ma tu'un, tiaga ni jachi'in Ndioo ma ña kà'an na, kùuni na. ");
INSERT INTO mza_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Koto jä'a ndo tava jà'a ndiakan, vati ma Ndioo Tatá ndo, cha chìto ra nayi kùu ma ña chiniñu'u ndo antea ña ndàkan ndo yi nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yakan va te'en ìyo yi ña ka'an ndo chi'in Ndioo: Yo'o ra kùu Tatá ndi, ra ìyo andivi, na ya'aga ií kùu ma siviun. ");
INSERT INTO mza_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na kichi ma nuu chà'ndaun tiñu. Ta na kuu ma naja kua kùuniun ma nuñu'u', ma takua kùu yi iti' andivi. ");
INSERT INTO mza_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Na ku'vaun ma ña chìniñu'u ndi kachi ndi vitin. ");
INSERT INTO mza_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na jàka'nuniun ma kuati jà'a ndi, takua jàka'nuni ndi kuati ma ndian jà'a ña kini chi'in ndi. ");
INSERT INTO mza_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ta koto kü'vaun ña titunini ndi jà'a ndi ma ña töve va'a. Va na ja'un ña na kaku̱n ndi nuu ma ña kini. Vati maun kùu ma ra chà'nda tiñu, ta maun kùu ma ra ìyo ndatu, ta juuni maun nduva'a ka'nu kùu̱n ndia. Ta takan endeeni na kùu yi. Amén. ");
INSERT INTO mza_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Vati tu ndyo'o jàka'nuni ndo kuati jà'a ma inga na chi'in ndo, nda ma Racha'nu Tatá ndo ra ìyo andivi, ni jaka'nuni ra ma kuati ndo ndia. ");
INSERT INTO mza_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Va tu töve jàka'nuni ndo kuati ma inga na, ni ma Racha'nu Tatá ndo, töve ni jaka'nuni ra kuati ndo ndia. ");
INSERT INTO mza_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ora jàndita ndo yu'u ndo, na töve ìyo yi ña ja'ani ña nda'vi kuuni ndo, tava jà'a ma ndian ìyo uvi nuu kua chànini, kuenda ña na nde'e ma ñivini na ña jàndita na yu'u na. Ndicha va'a ña kà'in chi'in ndo ña, ndiakan cha ìyo ya'vi na ndia. ");
INSERT INTO mza_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Va taku ndyo'o ora jàndita ndo yu'u ndo, na nakata ndo nuu ndo, ta tì'i va'a ndo kuika xini ndo, ");
INSERT INTO mza_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ikan na töve nakuni na ña jandita yu'u ndo. Vati uvanuu ma Tatá ndo ra ìyo ma'iin chi'in ndo ma nuu ka'ìin ndo, rakani kùu ra ña chà'a ra kuenda cha'a' ma ña jà'a ndo, ta rakan ni ku'va ra ya'vi ndo cha'a' yi. ");
INSERT INTO mza_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ta koto jändolocho ndo ma ña kuika ndo ma nuñu'u' ñuñivi i'ya, vati ma i'ya, ndi'i yi jàtivi ma tikixin, ta kì'vi ma ndra su'u, kasu'u ndra ndia. ");
INSERT INTO mza_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Va'aga ña na jandolocho ndo ma ña kuika ndo ma iti' andivi ña kùuni yi ka'an yi ma ña va'a jà'a yo kuenda Ndioo, vati ikan kùu nuu töve jàtivi ma tikixin yi, ta ni töve tìvi inga ma ndatiñu, ta ni töve kì'vi ma ndra su'u ña, kàsu'u ndra ndia. ");
INSERT INTO mza_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Vati ma nuu ìyo ña kuika ndo, juuni ma ikan ìyo ma anima ndo chi'in yi. ");
INSERT INTO mza_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Ma tinuu yo, kùu yi takua kùu ma ñu'ú kandil kuenda ma kuñu yo. Yakan va tu ma tinuu yo va'a yi, kùuni yi ka'an yi ña ndisaa ma kuñu yo ìyo ñu'ú yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Va tu ma tinuu yo, töve chà'a yo ña kutu'va yo takua kùuni Ndioo, kùuni yi ka'an yi ña chàkuu yo nuu naa jà'a yi. Ta tu chànini yo ña kùu ma chinituni yo takua kùu iin ñu'ú, va töve ndicha, kùuni yi ka'an yi ña cha kua naa ka'vi yo jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ta nï'iin ma ndian kùu musu, na küu ja'a na tiñu nuu ninduvi ma ndra kùu chito'o na iin tiempuni, vati iin ra, va ni kuuni na nde'e na ra, ta inga ra ni kuxaani na nde'e na ra, ta ra nunuu ni tiñu'u na ra, ta ma inga ra töve. Yakan va na küu jà'a yo tiñu nuu Ndioo, tu endee nàkanini yo cha'a' ma xu'un' ndia. Takan kūu tajan te'en nāka'an ndio ma Jesuu chi'in ma ndra jàkua'a chi'in ra: ");
INSERT INTO mza_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","―Ta cha'a' yakan kùu yi ña yu'u kà'in chi'in ndo ña na töve na ja'a ndo ña nàkanini ndo cha'a' ma ña chàchi ndo, a cha'a' ma ña ko'o ndo kuenda ña koo ndo, a ña nakanini ndo cha'a' ma ja'ma ña chàku'un ndo. ¿A töve va'aga ma kivi ìyo ndo kua ma ña chàchi ndo?, kùuni ndo. Ta, ¿a töve va'aga ma kuñu ndo, kua ma ja'ma chàku'un ndo?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Na nde'e ndo tava ìyo ma saa ña ndàti ndri kàchika ndri nuu sukun. Ndrikan töve tàchi ndri, ta töve nàkuiso ndri nï'iin nakuyi, ta ni töve tàan va'a ndri yi tichi yaka, ta va'ani chà'a ma Ndioo Tatá ndo ña chàchi ndri. ¿A töve chà'a ndo kuenda ña ma Racha'nu Ndioo kùuniga ra nde'e ra ndo kua ma saa ikan? ");
INSERT INTO mza_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿A ìyo nda ndyo'o ña cha'a' ña ya'a nakanini ndo kùu ndosukun ndo sava metru tiá, jà'a yi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Ta naja ya'a nàkanini ndo cha'a' ma ja'ma chàku'un ndo? Na nde'e ndo tava chà'nu ma ita kàa tichi ku'u. Ma ita ikan töve jàtiñu yi, ta ni töve kunu yi isa ndia, ");
INSERT INTO mza_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ta va'ani nduva'a vii kàa yi, ni ma rey Salomón, chi'in ndisaa ma ja'ma va'a, ta vii ña chàku'un ra, töve nī chaa ra ku'un ra ja'ma vii takua vii kàa iin ma ita ikan. ");
INSERT INTO mza_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ta ndicha ña Ndioo ya'a vii jà'a ra ma ita ku'u ña itaan a isaa ni kayu yi. Ña'á kùuni yi ka'an yi ña nduva'a kuii ja'a ra kuenda tiaga ndo kua ma ita. Ta ndyo'o, ¿ta naja töve chìnuni va'a ndo?, tuva takan. ");
INSERT INTO mza_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yakan va töve na ja'a ndo ña nàkanini ndo ta kà'an ndo te'en: “¿Nayi ni kacho?” a “¿Nayi ìyo yi ña ko'o yo?” ta “¿Naja kua jà'a yo ni'i yo ja'ma ku'un yo?” ");
INSERT INTO mza_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kà'in takan, vati tandi'i ma ndian töve chìnuni tu'un Ndioo, takan chànini na, va takua ndyo'o ìyo iin ra kùu Tatá ndo iti' andivi, ta rakan kùu ra ña cha chà'a ra kuenda ña chìniñu'u ndo ndisaa ma ña chànini ndo. ");
INSERT INTO mza_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yakan va na nanduku ji'na ndo naja kua kùuni Ndioo ña koo ndo chi'in ra ma nuu chà'nda ra tiñu, tajan ndicha ña ni ku'va ra tandi'i ma ña chìniñu'u ndo i'ya. ");
INSERT INTO mza_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Na töve na ja'a ndo ña nàkanini ndo cha'a' ma kivi ña vàchi itaan, ti kuenda ma itaan, siin kùu ma ña ni nakanini ndo kuenda yi. Vati ma ta'ii'iin kivi siin siin naja kua ndàka yi, ña nàkanini ndo cha'a' yi. ");
INSERT INTO mza_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Na tïsokuati ndo inga ñivi, ikan töve tìsokuati ma Ndioo ndo ndia. ");
INSERT INTO mza_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Vati ma Racha'nu Ndioo, ni tisokuati ra ndo ma naja kua tīsokuati ndo ma inga ñivi. Takua jà'a ndo chi'in inga ñivi indukuni takan, ni jande'e ra tundo'o ndo ndia. ");
INSERT INTO mza_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Ta naja jà'a ndo kuenda ma kuati vali, ña jà'a ma yani ndo, ta tüvi jà'a ndo kuenda ma kuati ka'nu, ña jà'a juuni maa ndo? ");
INSERT INTO mza_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Yakan va naja kua kùu ka'an ndo chi'in ta'an ndo ña kùu jandondaa ndo ma kuati na ta kà'an ndo te'en: “Ku'va na tavani'i̱ iin cha'an vali ña indii tichi tinuu̱n”, tuva ni ma cha'an ka'nu ña indii tichi tinuu juuni maa ndo na küu tavani'i ndo. ");
INSERT INTO mza_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ndyo'o ndian kini ta uvi nuu ña chànini ndo!, na tavani'i ji'na ndo ma cha'an ka'nu ña indii tichi tinuu ndo, ikan na kuu nande'e va'a ndo, tajan kuu tindee ndio ndo ma ndian ta'an ndo chi'in ma kuati na. ");
INSERT INTO mza_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ta koto jänini ndo ña kàtitu'un ndo ma tu'un Ndioo nuu ma ñivi ña töve kùuni koto yi, koto ja'a na ña kini chi'in ndo, takua jà'a ma ina xaan ora tìin ndri ndo. Ta koto juuni kani ka'ni ndri ndo ndia. Ta koto jächaa ndo iin ndatiñu ya'vi ndaa nuu ma ndian kini, koto kuañuni na chata yi. ");
INSERT INTO mza_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yakan va te'en nāka'an ma Jesuu: ―Na ndakan ndo ña chìniñu'u ndo nuu Ndioo, ta ku'va ra yi nuu ndo, na nanduku ndo yi nuu ra, ta nì'i ndo yi. Na jakate'e ndo yuve'e, ta nuna ra yi nuu ndo. ");
INSERT INTO mza_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vati ma ndian chìkan iin nakuyi, nì'i na yi, ta ma ndian nànduku iin nakuyi, ta nàta'an na yi, ta ndian jàkate'e yuve'e, ta nùna ra yi nuu na ndia. ");
INSERT INTO mza_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿A ìyo iin nda ndyo'o ña ora chìkan ma se'e ndo ña kachi na nuu ndo, ta chà'a ndo iin yuu nuu na? ");
INSERT INTO mza_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿A ña chà'a ndo iin koo nuu na, ora chìkan na tiaka' nuu ndo?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tu ndyo'o ña kùu ndo ndian kini, ta chìto ndo ku'va ndo ña va'a nuu ma ndiakuati se'e ndo, ta ma Racha'nu Tatá yo ra ìyo andivi ìyo tu'va ra ña tindee ra ndo chi'in ndisaa ma ña chìniñu'u ndo ma ora ña chìkan ndo yi nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Yakan va takua va'a kùuni ndo ña ja'a ma ñivi chi'in ndo, indukuni takan na ja'a ndo ma ña va'a chi'in na ndia. Vati takan kà'an ma tutu ley Ndioo ña tāa Moisés, chi'in ma tutu ña tāa ma ndian kà'an chi'in tu'un yu'u ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Na ki'vi ndo ma yuve'e tuu. Vati ma yuve'e ki'in chi'in ma iti' ya'a ìyo nuna, kùu ma iti' kuà'an ma nuu ni naa na, ta tikan kùu ma nuu ki'vi kua'a' ñivi. ");
INSERT INTO mza_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Va ma yuve'e tuu, chi'in ma iti' ndetiñu, ña kuà'an chi'in na ma nuu ni koo na endeeni, ya'a tiani na kùu ma ndian nàta'an yi. ");
INSERT INTO mza_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Na ja'a ndo kuenda nuu ndo, chi'in ma ndian vata ña jàya'a na na ña kùu na ndian kà'an kuenda Ndioo. Vati ndiakan ora chàa na nuu ìyo ndo, nduva'a vii kà'an na chi'in ndo, va ma tichi anima na nduva'a xaan ndian kùu na. ");
INSERT INTO mza_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Cha'a' ma tiñu jà'a na, kùu nakoto ndo nda ndian kùu na. Vati taku ma iñu ndu'va, tüvi chà'a yi uva, ta ni ma yutun iñu xini, tüvi chà'a run ma chiti higu ndia. ");
INSERT INTO mza_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ta takan kùu yi ña tandi'i ma yutun va'a, chà'a ndrun chiti va'a, ta ma yutun töve va'a, chà'a ndrun chiti töve va'a ndia. ");
INSERT INTO mza_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Vati taku ma yutun va'a, töve chà'a ndrun ma chiti töve va'a, ta ni ma yutun töve va'a, töve chà'a ndrun ma chiti va'a ndia. ");
INSERT INTO mza_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yakan va tandi'i ma yutun ña töve chà'a chiti va'a, ìyo yi ña ka'nda yo ndrun, ta ka'mio ndrun. ");
INSERT INTO mza_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ta takan kùu yi ña ni ku'va maa ndo kuenda, tu kùu na ndian va'a a ndian vä'a' cha'a' ma tiñu jà'a na. ");
INSERT INTO mza_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ta na yöve tandi'i ma ndian kà'an: “Racha'nu, Racha'nu”, ni ki'vi na nuu chà'nda Ndioo tiñu iti' andivi, vati ma ndian ni ki'vi ikan, kùu ma ndian jà'a takua kùuni ma Tatái, ra ìyo andivi. ");
INSERT INTO mza_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ora ni chaa ma kivi ikan, kua'a' ñivi te'en ni ka'an na chi'i̱n: “Racha'nu, Racha'nu, ndyu'u kàtitu'un ndi tu'un cha'un chi'in ma siviun, ta chi'in ma siviun tāvani'i ndi ma tati xaan, ta juuni chi'in ma siviun cha jā'a ndi kua'a' ma ndatu ndia.” Takan ni kati na. ");
INSERT INTO mza_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Va yu'u te'en ni ka'in chi'in na: “Na tükuii nàkotoi ndo. Na kundachiyo ndo xii̱n, ndyo'o ndian jà'a mamaa ña kini.” ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Yakan va ma ndian tàso'o ma ña kà'in, ta jà'a na yi, ndiakan kùu na tava kùu ma ra chānini va'a, ña jāva'a ra ma ve'e ra chata iin ma yuu ka'nu. ");
INSERT INTO mza_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ta ikan jan kōyo ndio ma savi tati nduva'a ka'nu chata ma ve'e, ta chā'nu ndio ma yuta, ta töve nī nduva yi, ti mamaa yuu kùu ma cha'a yi, ta ma nuu ndaa yi. ");
INSERT INTO mza_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Va ma ndian tàso'o ma ña kà'in, ta töve jà'a na yi, ndiakan kùu na, tava kùu ma ra tükuii nī nata'vi chinituni ña jāva'a ra ma ve'e ra chata yuti ndi'i. ");
INSERT INTO mza_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ta ikan jan kōyo ndio ma savi tati nduva'a ka'nu chata ma ve'e, ta chā'nu ndio ma yuta, ta jānduva yi ma ve'e. Ta takan kūu yi ña endee ndī'i yi tāni ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ta ora chīnu kā'an Jesuu takan, ta ma ñivi, ndava kuà'an tati na. ");
INSERT INTO mza_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Vati jàna'a ra takua iin ra ìyo ndatu Ndioo chi'in, ta ma ndra matru ña jàkua'a tutu Ndioo töve jàna'a ndra takan. ");
INSERT INTO mza_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ta ora nūu ndio Jesuu ma yuku ikan, ta nduva'a kuii kua'a' ñivi tāndikun chata ra. ");
INSERT INTO mza_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ta ikan jan iin ra ndo'o kue'e ta'yu, chājayatin ra ra nuu Jesuu, ta chūnandi chiti ra nuu ra, ta te'en nāka'an ra chi'in ra: ―Yo'o Racha'nu, na janda'un yu'u chi'in ma kue'e ña ndo'i, tuva kùuniun ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tajan jānakaa Jesuu nda'a' ra, ta jānani ndio ra nda'a' ra ra, ta te'en nāka'an ra: ―Kùuni̱ janda'i ñu̱n. Na nda'un ―kàti Jesuu chi'in ra. Tajan juuni ma ora ikani, nāa ma kue'e ta'yu ñii ra. ");
INSERT INTO mza_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ta ikan jan te'en nāka'an Jesuu chi'in ra: ―Koto kätitu'u̱n ma ña tā'un nuu nï'iin ñivi, uvanuu nuu sutu, na kujana'un ñu̱n. Ta na kunda'un iin kiti, ta sòkóun ri kuenda Ndioo, ti takan kà'an ma tutu Ndioo tāa Moisés taji'na, ikan na koto tandi'i ñivi ña cha ndā'un ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ta ora kī'vi Jesuu ma ñuu Capernaum, tajan chājayatin iin ra capitán ma ñuu Roma ma nuu ndaa Jesuu. Ta te'en jānini ra ra chi'in ma tu'un i'ya: ");
INSERT INTO mza_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Yo'o Racha'nu, ma ra jà'a tiñu nui, kù'vi ra kàndii ra ve'i jà'a ña pe'lu cha'a' ra chi'in nda'a' ra, ta ya'aga nda'vi kùuni ra ña ya'a ndè'e ra tundo'o ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tajan Jesuu te'en nāka'an ndio ra chi'in ma ra capitán: ―Na ko'o ta jànda'i ra ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tajan ma ra capitán te'en nāka'an ra chi'in Jesuu: ―Yo'o Racha'nu, na töve ìyo yi ña ki'viun ma tichi ve'i cha'a' ña ra nda'vini kùi, va'aga ña na ja'un yi chi'in ma tu'un yu'uniun, ta chi'in yakan nda'a ma musui. ");
INSERT INTO mza_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vati nda mai, juuni ìyo ma ra chà'nda tiñu nui, ta juuni ìyo jandaru ña chà'ndai tiñu nuu ndia. Vati ora kà'in chi'in iin ma ra jandarui ña na ku'un ra, ta kuà'an ra, ta ora kà'in chi'in inga ra ña na kichi ra, ta vàchi ra. Ta ora tàvai tiñu nuu ma musui ña na kuja'a ra iin tiñu nui, ta jà'a ra yi ndia. ―Takan kàti ma ra kùu capitán chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ta ora chīni Jesuu ma ña kā'an ra ta ndava kuà'an anima ra ndaa ra. Tajan te'en nāka'an ndio ra chi'in ma ñivi kuà'an chata ra: ―Ndicha va'a ña kà'in chi'in ndo ña ninii ñuu Israel takä'an nàta'in nï'iin ma ndian chìnuni va'a ma takua chìnuni ra'ya. ");
INSERT INTO mza_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yu'u kà'in chi'in ndo ña nduva'a kua'a' ñivi, ni kichi ninii ka'nu ma nuñu'u' ñuñivi, ña ni koo na chi'in Abraham, Isaac, ta Jacob, ma nuu chà'nda Ndioo tiñu andivi. ");
INSERT INTO mza_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Va ma ndian ìyo yi ña ku'un ma nuu chà'nda Ndioo tiñu niku, ni jaku'un ra na ma nuu naa, ña ndava ni kuaku na ta kari'u nu'u na jà'a ña ni nde'e na tundo'o ma ikan. ");
INSERT INTO mza_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ta ikan jan te'en nāka'an tuku Jesuu chi'in ma ra kùu capitán: ―Na ku'un ve'un ta na kuu yi, ma tava chinuniun ña kùu yi ―kàti Jesuu chi'in ra. Ta takan kūu yi ña ndā'a ma ra ku'vi juuni ma ora ikan. ");
INSERT INTO mza_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Takan kūu tajan kēe ndio Jesuu kuà'an ra ve'e Petu', ta ikan ndē'e ra ña ku'vi ma ñaka'nu Petu' kàndian jà'a ka'ni. ");
INSERT INTO mza_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ta ikan jan jānani ra nda'a' ra, ma nda'a' ña, ta kēe ma ka'ni ña. Tajan ndēta ña, ta kīcha'a ndioan jà'a ña, ña kachi ndra. ");
INSERT INTO mza_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Takan kūu ta ora cha kuaa, tajan chāndaka ndio na kua'a' ma ndian ndiso tati xaan nuu Jesuu, ña na janda'a ra na. Ta chi'in iin tu'uni ña kā'an ra nuu ma tati xaan ikan, ta kēe yi ma tichi kuñu na, ta juuni jānda'a ra kua'a' ma ndian kù'vi jà'a inga tuku nuu kue'e ndia. ");
INSERT INTO mza_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Takan kūu yi, ikan na chinu ma tu'un kā'an ma Isaía, ra kā'an chi'in tu'un yu'u Ndioo niku. Vati rakan te'en kā'an ra: “Ra'ya kùu ra ña jānda'a ra yo, ta ndāki'in ndi'i ra ma kue'e ndo'o yo.” Takan kàti ma tu'un Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ta ora ndē'e Jesuu ña nduva'a kua'a' ñivi chīkonuu na ra, tajan nāka'an ndio ra chi'in ma ndra jàkua'a chi'in ra, ña na ketachiyo ndra inga chiyo ma lakuna. ");
INSERT INTO mza_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ta ikan jan chājayatin iin matru ña jàkua'a tutu Ndioo ma nuu Jesuu, ta te'en nāka'an ra chi'in ra: ―Matru, kùuni̱ ku'in chataun ndanikuni ma nuu kuà'un ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tajan Jesuu te'en nāka'an ra chi'in ra: ―Taku ma yukuii ìyo yavi nuu kìxi ndri, ta ma saa ìyo taka ndri ndia, va yu'u ra Se'e ñivi tāchi Ndioo, na töve ìyo ni nuu kundii ma xini̱ ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tajan iin ma ndra jàkua'a chi'in ra, te'en nāka'an ra chi'in ra: ―Yo'o Racha'nu, na ku'vaun ña na ku'un ji'nai kukuchi̱ ma tatái ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ta Jesuu te'en nāka'an ra chi'in ra: ―Na'a chatai, ta na ku'vaun ña na kuchi ma ndian töve chìnuni ma ta'an na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tajan ndāa ndio Jesuu ma tichi varku, chi'in ma ndra jàkua'a chi'in ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ta ikan kācha'an ndra, ora kōyo ndio ma savi tati nduva'a ka'nu chata ndra ña endee chīkonuu ma ola ma varku ndra. Va ma Jesuu kìxi ndicha ra kàndii ra tichi run. ");
INSERT INTO mza_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tajan chājandakoo ndio ma ndra jàkua'a chi'in ra ra, ta te'en nāka'an ndra chi'in ra: ―¡Yo'o Racha'nu, na jakakun ndi, vati chani sa'vi ndi! ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ta Jesuu te'en nāka'an ra chi'in ndra: ―¿Ta naja ya'a ndasii ndo? ¿A ya'aga tia chìnuni ndo ña jà'a ndo takan? Tajan ndēta ndio ra, ta kīcha'a ra kà'an xaan ra nuu ma savi tati chi'in ma tañu'u, ta ndisaa yi kūtaxin. ");
INSERT INTO mza_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ta ikan jan ndava kuà'an anima ndra kīndoo ndra, ta te'en kīcha'a ndra chìkatu'un ta'an ndra: ―¿Ta nda ra kùu ra'ya ña, nda ma tati chi'in tañu'u, jàchi'in ña kà'an ra? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ta ora cha kētachiyo ndio Jesuu inga chiyo ma tañu'u nuu kandii ma ñu'u' Gadara, ta ikan kēe uvi ta'an ma ndra ndiso tati xaan tañu ma nuu ñaña, ta chājayatin ndra ndra nuu Jesuu. Ta ndrakan ti endee küu ya'a nï'iin ñivi ma nuu ka'ìin ndra ti, ya'a tivi xini ndra jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tajan ndrakan te'en kīcha'a ndio ndra nda'yu ndra jà'a yi: ―¡Koto kï'viun chi'in ndi, yo'o Jesuu, ra Se'e Ndioo! ¿A vàchi jànde'un tundo'o ndi antea ña keta ma kivi ña ni jakutuni ma Racha'nu Ndioo kuati ndi? ―kàti ndra chi'in ra, jà'a ma tati xaan ikan. ");
INSERT INTO mza_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ta chika ma nuu ka'ìin ndra, ikan ndē'e yi ña ka'ìin kua'a' va'a kini, ña chàchi ndri kachika ndri. ");
INSERT INTO mza_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tajan te'en jānini ndio ma tati xaan ña ka'ìin tichi kuñu ndra ma Jesuu chi'in tu'un i'ya: ―Tu kùuniun tavaun ndi tichi kuñu ndra, na ku'vaun ña ki'vi ndi tichi kuñu ma kini ña ka'ìin kachachi ndakan ―kàti yi. ");
INSERT INTO mza_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tajan Jesuu te'en nāka'an ra chi'in yi: ―Va'ani, na ki'vi ndo ―kàti Jesuu. Tajan kēe ndio ma tati xaan tichi kuñu ndra, ta kī'vi yi tichi kuñu ma kini, ta ndisaa ndio ndri kāndakunu ndri kuà'an ndri iti' nuu ìyo iin xa'va nuu kandii ma lakuna, ta ikan kā'a ndri, ta chī'í ndri. ");
INSERT INTO mza_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ta ma ndra jàkuenda ndri, kāchinu ndra ti yū'vi ndra. Ta ora chāa ndra ma ñuu, ta kīcha'a ndra nàtu'un ndra nuu ma ñivi ña tā'an ma kini chi'in tandi'i ña tā'an ma ndra ndiso tati xaan ndia. ");
INSERT INTO mza_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tajan tandi'i ma ñivi ìyo ma ñuu ikan, chānde'e na nuu ndaa Jesuu. Ta ora ndē'e na ra, ta kīcha'a jànini na ra ña na kèe ra ma ñuu ikan. ");
INSERT INTO mza_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Takan kūu tajan ndāa ndio Jesuu tichi iin varku, ta kētachiyo ra inga chiyo lakuna, ta chāa ndio ra ma nuu kùu ñuu ra. ");
INSERT INTO mza_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ta ikan chāndaka ndra iin ra kūyutun nuu ra iin nuu ti'va. Ta ora ndē'e Jesuu ña iin ndra ya'a chìnuni ma ña jà'a ndra kùu ndra, tajan te'en nāka'an ndio ra chi'in ma ra ku'vi: ―Na sii kuuniun yo'o se'yu, ti cha jāka'nuni̱ ma kuatiun, ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tajan iin ma ndra matru jàkua'a tutu Ndioo, te'en chānini ndra ña kā'an Jesuu takan: “Iin kuati kùu ma ña jà'a ra chata Ndioo, cha'a' ña kā'an ra takan.” Takan chānini ndra. ");
INSERT INTO mza_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Va tava Jesuu cha chìto ra naja kua chànini ndra, yakan va te'en chīkatu'un ndio ra nuu ndra: ―¿Ta naja mamaa ña kini indii ma chinituni ndo? ");
INSERT INTO mza_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ta, ¿nda tu'un kùu ma ña töve ndetiñu ña ìyo yi ña kà'in?, kùuni ndo. ¿A va'aga ña ka'an yo: “Cha jaka'nuni̱ ma kuatiun”, a ña kā'an yo: “Ndeta, ta kakaun”?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Va'ani, ni jana'i nuu ndo ña ma ra Se'e ñivi tāchi Ndioo, ìyo ndatu ra ña jaka'nuni ra kuati ma ñivi ìyo nuñu'u' ñuñivi. Tajan te'en nāka'an ndio Jesuu chi'in ma ra kūyutun: ―Na ndetaun, ta tika'nu̱n chitoun, ta ku'u̱n ve'un ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tajan ndēta ndio ma ra kūyutun, ta kuà'an ra ve'e ra. ");
INSERT INTO mza_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ta ora ndē'e ma ñivi ña chūndaa ma ra kūyutun, ta ndava kuà'an anima ndio na, ta kīcha'a na jàka'nu na Ndioo cha'a' ña ìyo ndatu Jesuu kuenda ña jaka'nuni ra kuati ñivi. ");
INSERT INTO mza_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Takan kūu tajan kēe ndio Jesuu ma ikan, ta ndē'e ra iin ra nàni Mate ña nàndi ra nàka'an ra xu'un' kuenda ma ñuu Roma. Ta te'en nāka'an ndio ra chi'in ra: ―Na'a chatai ―kàti Jesuu chi'in ra. Tajan ndēta ndio ma Mate, ta tāndikun ra chata ra. ");
INSERT INTO mza_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Takan kūu tajan chāa ndio iin kivi ña nàndi Jesuu chàchi ra nuu ìyo ve'e Mate chi'in kua'a' ndra nàka'an xu'un' kuenda ñuu Roma, chi'in inga tuku ma ndra jà'a kuati. Ndisaa ndrakan chāa ndra chūnandi ndra mesa xiin Jesuu, ta chi'in ndra jàkua'a chi'in ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ta ora ndē'e ma ndra fariseu ña iin kàchachini ndra chi'in Jesuu, tajan te'en chīkatu'un ndio ndra nuu ma ndra jàkua'a chi'in ra: ―¿Ta naja nàndi ma ra kùu matru ndo chàchi ra chi'in ma ndra nàka'an xu'un' kuenda ma ñuu Roma, ta chi'in ma ndra jà'a kuati? ―kàti ndra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tajan ora chīni Jesuu ña takan kà'an ndra, ta te'en nāka'an ra nuu ndra: ―Taku ma ndian ìyo va'a, na töve chìniñu'u na ndian jà'a tatan, ti ma ndian chìniñu'u yi kùu ma ndian ku'vini. ");
INSERT INTO mza_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na ku'un ndo, ta na kutu'va ndo ma tu'un Ndioo nuu kà'an yi te'en: “Yu'u kùuni̱ ña na kunda'vini ndo ta'an ndo, ta töve kuuni̱ ña ka'ni ndo kiti, ta sòkó ndo nui.” Vati yu'u töve vàchi̱ kuenda ma ndian ìyo va'a, ti yu'u vàchi̱ kuenda ma ndian jà'a kuati, ikan na sama na ma kua ìyo na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Takan kūu tajan ma ndra chàkunuu chi'in Xuva, ra jàkunduta, chajāyatin ndra ndra nuu ndaa Jesuu, ta te'en chīkatu'un ndra nuu ra: ―¿Ta naja ndyu'u chi'in ma ndra fariseu, nduva'a jàndita ndi yu'u ndi? Ta ma ndra jàkua'a chi'un, ¿naja töve? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tajan Jesuu te'en nāka'an ra: ―Ma ñivi jàndakutu'un ma ra tanda'a, ¿a nda'vi kùuni na ora juuni ndaa ra chi'in na ma viko tànda'a?, kùuni ndo. Töve nda'vi kùuni na ma ora ikan. Va ni chaa iin kivi ña ma ra tànda'a ni kundachiyo ra xiin na, tajan kùu jandita ndio na yu'u na. ");
INSERT INTO mza_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ta nï'iin ñivi na küu nataa ta'an na ja'ma cha'nu chi'in ita'vi ma ja'ma chaa, vati ma ja'ma chaa, jandoluxu yi ma ja'ma cha'nu, ta vi'a ka'vi nàkaa ma nuu ta'nda yi ja'a yi. ");
INSERT INTO mza_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ta juuni na küu tàan yo ma vinu chaa tichi ma tia'a ñii cha'nu, vati tu jà'a yo takan, ta ni ka'ndi yi, ta ma ñii cha'nu, chi'in ma vinu chaa tīvi yi. Yakan va ìyo yi ña taan yo ma vinu chaa tichi ma tia'a ñii chaa, ikan ninduvi yi kùu jakuenda yi yi. ");
INSERT INTO mza_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ta ora juuni ndaa Jesuu kà'an ra ma tu'un i'ya nuu ma ñivi, tajan iin ma ra kùxini nuu ma ndian judíu, chāa ra nuu Jesuu, ta chūnandi chiti ra, ta te'en nāka'an ra: ―Já chī'í kuii ma ña se'i, va tu ku'u̱n, ta jundiun nda'un ma xinian, ta ni nataku ndikoan ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tajan ndēta ndio Jesuu, ta kuà'an ra chi'in ra ma ve'e ra chi'in ma ndra jàkua'a chi'in ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ta juuni ma ikan kuà'an iin ña'a, ña cha ìyo uchi uvi kuiya ña kù'vian jà'a ma niian. Yakan chājayatian ña iti' chata Jesuu, ta jānanian nda'a' ña ma cha'a ja'ma ñu'u ra. ");
INSERT INTO mza_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Vati yakan, te'en chānini ña: “Jitu chi'in ña jananinio ma nda'a' yo ja'ma ra, ta ndova'a yo”, kùunian. ");
INSERT INTO mza_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Va ora chīkoni'i Jesuu iti' chata ra, ta ndē'e ra ña, ta te'en nāka'an ra chi'an: ―Na sii kuuniun yo'o se'yu ti cha ndova'un jà'a ña chìnuniun ―kàti Jesuu chi'in ña. Tajan juuni ma ora ikani ndā'a ña. ");
INSERT INTO mza_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ta ora chāa Jesuu ve'e ma ra kùxini nuu ma ñivi judíu, ta ndē'e ra ña cha ìyo tu'va ma ndra musika ña ni tivi ndra ma nuu ni kukuchi ña. Ta ma ñivi nduva'a ni'i kachaku na. ");
INSERT INTO mza_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tajan te'en nāka'an ndio Jesuu chi'in na: ―Na kee ndo ma tichi ve'e, vati ma ña tivaa i'ya, töve chī'í ña, ti kìxinian ―kàti ra. Ta ma ñivi java kāchakú ndaa na ra, ña kā'an ra takan. ");
INSERT INTO mza_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Va ndisaa na kātava ra, tajan kī'vi ndio ra ma tichi ve'e nuu kandii ma ña chī'í, ta tīin ndio ra nda'a' ña, ta ndēta ña. ");
INSERT INTO mza_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Takan kūu tajan ninii kuii ma ñu'u' ikan chìtakuati ma ña jā'a Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ta ora kēe ndio Jesuu ma ikan, tajan uvi ta'an ma ndra kuaá, te'en kīcha'a ndra kanachaa ndra ora tāndikun ndra chata ra: ―¡Na kunda'viniun ndyu'u, yo'o ra kùu se'e racha'nu David! ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ta ora kī'vi ndio Jesuu ma tichi ve'e, ta ikan jan chājayatin ninduvi ma ndra kuaá nuu Jesuu, ta te'en kīcha'a ra chìkatu'un ra nuu ndra: ―¿A chànini ndo ña kùu ja'i ma ña kùuni ndo? ―kàti ra. Ta ndrakan te'en nāka'an ndra: ―Kùu ja'un yi ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tajan jānani ndio Jesuu nda'a' ra ma tinuu ndra, ta te'en nāka'an ra chi'in ndra: ―¡Na kuu yi ma tava chìnuni ndo! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tajan nānde'e ndio ndra. Ta te'en kātitu'un kachin Jesuu nuu ndra ma ña ìyo yi ña ja'a ndra: ―Koto kätitu'un ndo ma ña jā'i chi'in ndo nuu nï'iin ñivi ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Va juuni takä'an kee kua'a' ndra ku'un ndra, ta kīcha'a ndra kàtitu'un ndra nuu ndisaa ñivi ìyo ninii ma ñu'u' ikan, ma ña jā'a Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ta ora juuni yanga kèe na ma tichi ve'e ikan, tajan kēta iin ndian chāndaka na iin ra ñi'i ña ndiso tati xaan nuu Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ta ora cha tāva ndio Jesuu ma tati xaan tichi kuñu ra, ta kīcha'a ndio ra kà'an ra. Ta ma ñivi ndava kuà'an anima na, ta te'en nāka'an ndio na: ―¡Nï'iin cha'a' takä'an nde'o iin ma ra jà'a takan ma ñuu Israel! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Va ma ndian fariseu te'en kà'an na: ―Ra'ya tàva ra ma tati xaan ña indii tichi kuñu ra juuni chi'in ndatu ma kui'na, ña kùu chito'o ma tati xaan ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Takan kūu ta Jesuu chàkunuu ra tandi'i ñuu, chi'in kuariya, ña jàna'a ra nuu na, ta'ii'iin ma tichi veñu'u kuati ña ìyo ma nuu ìyo na. Ikan chàkunuu ra kàtitu'un ra nuu na ma tu'un va'a Ndioo naja kua kuu ma nuu chà'nda ra tiñu. Ta juuni jànda'a ra tandi'i nuu ma ndian ku'vi jà'a ma tundo'o xaan, ta inga tuku kue'e u'vi na ndia. ");
INSERT INTO mza_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ta ora ndē'e ndio ra ña ya'a ga kua'a' ma ñivi ka'ìin, ta kūnda'vini ra na, ti ya'a ga nda'vi kùuni na, ta chitatu na ndia, tava kùuni ma mvechala ña tüvi ìyo pato. ");
INSERT INTO mza_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tajan te'en nāka'an ndio ra chi'in ma ndra jàkua'a chi'in ra: ―Ndicha ña ma ndatiñu cha kēta nuu tachio ya'a ga kua'a' yi, va ma ndra jàtiñu chi'in yi ya'a lichin ndra. ");
INSERT INTO mza_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yakan va na ndakan ndo nuu ma Racha'nu chito'o ma ndatiñu, ña na tachi ra tiá ma ndra kichi jàti'vi yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tajan kāna ndio Jesuu ma ndi uchi uvi ta'an ma ndra jàkua'a chi'in ra, ta jāna'a ra nuu ndra, naja kua ìyo yi ña ja'a ndra, ta tàva ndra ma tati xaan ña ndiso ñivi, ta naja kua ìyo yi ña ja'a ndra, ta jànda'a ndra tandi'i nuu ma kue'e ndo'o na, ta ña u'vi na ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ña'a kùu sivi ma ndi uchi uvi ma ndra kùu tatun Jesuu: Ma ra nunuu, nàni ra Simón, ra juuni jākunani Jesuu Petu' ndia, chi'in ra yani ra André, ta Jandiau chi'in ra yani ra Xuva, ndra kùu se'e, ra nàni Zebedeu. ");
INSERT INTO mza_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ta Lipe chi'in Tolo, Toma, chi'in Mate, ña kùu ra iin ra nàka'an xu'un' kuenda ñuu ka'nu ña nàni Roma. Ta Jandiau, ra kùu se'e Alfeu, chi'in Lebeu, ra juuni nàni Tadeu ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ta Simón, ra kùuni kuati chi'in ñuu Roma, ta Juda Iscariote, ra ni xikoña'a ma Jesuu tiá iti' nuu. ");
INSERT INTO mza_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Takan kūu tajan tāchi ndio Jesuu ma ndi uchi uvi ndra jàkua'a chi'in ra chi'in ma tu'un i'ya: ―Koto kü'un ndo ma ñu'u' nuu ìyo ma ndian töve chìnuni, ta koto kï'vi ndo ma ñu'u' Samaria ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Va'aga ña na ku'un ndo ma ñu'u' Israel, nuu kandoyo ma ndian kùu takua kùu ma mvechala ña kuànaa. ");
INSERT INTO mza_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ikan na ku'un ndo, kukatitu'un ndo nuu na, ña cha vàchi kuyatin ma nuu chà'nda Ndioo tiñu nuu ìyo ma iti' andivi. ");
INSERT INTO mza_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Na janda'a ndo ma ndian ku'vi, ta janda'a ndo ma ndian ndo'o kue'e ta'yu, ta jànataku ndo ma ndian chī'í. Ta juuni na tava ndo ma tati xaan ña ìyo tichi kuñu ñivi ndia. Ta töve ìyo yi ña naka'an ndo xu'un' cha'a' ña jà'a ndo tatan na, ti nì'i saani ndo ma ndatu i'ya. ");
INSERT INTO mza_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ta töve ìyo yi ña kunda'a ndo oro, ni plata, ni cobre, ");
INSERT INTO mza_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ta ni yunu ndo ma tichi iti' kuà'an ndo. Na kunda'a ndo iin chaku'úni ma ja'ma ndo, ta koto künda'a ndo inga ndichan ndo, ni yutun vatun ndo ndia, ti ma ndra jàtiñu, ni ni'i sani ndra jitu ma ña kachini ndra. ");
INSERT INTO mza_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ta ora ni chaa ndo iin nuu kandii iin ñuu a iin kuariya vali, na nanduku ndo iin ndian va'a ña ìyo tundeeni ndo chi'in, ta kìndoo ndo chi'in na ma ve'e na, nda kati keta ma ora ni ku'un ndo. ");
INSERT INTO mza_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ta ora ni ki'vi ndo ma ve'e na, ìyo yi ña kaña'a ndo te'en chi'in na: “Ndioo na koo chi'in ndo”, kati ndo. ");
INSERT INTO mza_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta tu ma ñivi ìyo ma ve'e ikan, tìñu'u na ma ña kà'an ndo, na koo vii na takua ma tu'un kà'an ndo chi'in na. Va tu töve tìñu'u na ndo, na töve ni koo vii na takua kà'an ndo chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ta tu töve ndakimani na ndo, ta ni töve jàchi'in na ma ña kà'an ndo, va'aga ña na kee ndo ma ve'e na, a ma ñuu nuu ìyo na, ta jàkisi ndo ma yuyaka ka'ìin cha'a ndo. ");
INSERT INTO mza_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ndicha va'a ña kà'in chi'in ndo ña ma kivi ni chaa ma ora ni jakutuni Ndioo kuati ñivi ìyo ñuñivi, nduva'aga ni nde'e ma ñivi ìyo ñuu ikan tiá tundo'o, kua ma ñivi chīyo ma ñuu Sodoma chi'in Gomorra. ");
INSERT INTO mza_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Na nde'e ndo! Ndyo'o ndian kùu ndo takua ma mvechala ta yu'u ni tachi̱ ndo tañu ma kiti xaan ña nàni lobo. Na ndakuu ndo ndian yati, takua yati ma koo, ta juuni na kuu ndo ndian ika, takua kùu ma livi. ");
INSERT INTO mza_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Na kumi kuenda ndo ndo, vati ni jaya'a na ndo nda'a ma ndra tiñu, ta ni kani ndra ndo ma tichi veñu'u kuati na. ");
INSERT INTO mza_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta juuni ndava ni jaya'a ndra ndo, nda'a ma ndra kuvienu, chi'in nda'a ma ndra kùu rey, cha'i. Takan ni kuu yi, ikan na kàtitu'un ndo ma tu'in nuu ndra, chi'in nuu ma ndian töve chìnuni ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Va ma ora ni jaya'a ndra ndo nda'a ma ndra tiñu, na näkanini ndo cha'a' ma ña ni ka'an ndo, a cha'a' ña naja kua ìyo yi ña ka'an ndo, ti ora ni chaa ma ora ikan, maa ma Ndioo kùu ra, ña ni ki'vi ra chinituni ndo, ta katitu'un ra naja kua ìyo yi ña ka'an ndo. ");
INSERT INTO mza_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Vati na yöve maa ndo kùu ma ndian ni ka'an, ti ma ra ni ka'an naja kua ka'an ndo. Ma tichi chinituni ndo kùu ma Tati Ií ma Ndioo Tatá ndo. ");
INSERT INTO mza_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ma tiempu ikan ni ku'va ndra juuni ma ndra kùu yani ndra, ña na ka'ni na ndra, ta ma ndra kùu tatá, ni ku'va ndra juuni ma ndra kùu se'e ndra ndia. Ta ma ndra se'e ndra ni chikoni'i ndra nuu ma tatá ndra, ta ka'ni ndra ndra. ");
INSERT INTO mza_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta tandi'i ñivi ìyo ñuñivi, ni kuxaani na nde'e na ndo cha'i. Va ma ndian jandeeni na ña koo va'a na chi'in ma tu'in, nda kati ya'a ma tundo'o ikan, ni kakú na. ");
INSERT INTO mza_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ta ora ndikun na ndo ma iin ñuu, na kunu ndo ku'un ndo inga ñuu, vati ndicha va'a ña kà'in chi'in ndo, ña ma ra Se'e ñivi tāchi Ndioo, ni kichi ra antea ña jachinu ndo katitu'un ndo ma tu'un Ndioo ninii ka'nu ma ñuu Israel. ");
INSERT INTO mza_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ta nï'iin ma ndra jàkua'a chi'in matru, na töve ka'nuga ndra kua ma ra kùu matru ndra, ta nï'iin ma ndra jàtiñu, na töve ka'nuga ndra kua ma chito'o ndra ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vati ma ndra jàkua'a, ìyo yi ña kindoo va'ani ndra, chi'in ña na chaa ndra koto ndra tava chìto ma matru ndra. Ta ma ndra jàtiñu, na kindoo va'ani ndra chi'in ña na chaa ndra koto ndra tava chìto ma ra chito'o ndra ndia. Ta tu yu'u kùi ma ra kuxini nuu ìyo ve'e, ta ma ñivi kà'an na ña ma kui'na Beelzebú kùi. Tu takan kà'an na yu'u, ¿naja kua chànini ndo ña ni ka'an na chata ma ndian ìyo kuendai ndia?, tuva takan. ");
INSERT INTO mza_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Yakan va na yü'vi ndo nde'e ndo ma ñivi. Vati na töve ìyo nï'iin tu'un xe'e, ña kùu kundii xe'e kua'a' tiempu, ti ninii chìto ma ñivi yi. Ta ni inga tuku ma ña indii xe'e na küu kindoo yi takan kua'a' tiempu ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma tu'un ña kàtitu'in nuu ndo ma nuu naa i'ya, na jaketa ndo yi ma nuu ndichin nuu ma ñivi, ta ma tu'un ña nàtu'in, ña chìtoni maa yo, na ndaa ndo ma chata ve'e, ta kanachaa ni'i ndo yi nuu ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Na yü'vi ndo nde'e ndo ma ndian chà'ni ma kuñu yo, vati na küu ka'ni ma tati ma anima yo. Va'aga ña na yu'vi ndo nde'e ndo ma Racha'nu Ndioo, ti rakan kùu ra, ña kùu jandi'i ra nuu ma kuñu ndo, chi'in ma tati ma anima ndo, ta jaku'un ra yi andaya'. ");
INSERT INTO mza_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ta, ¿a kùu jata ma ñivi uvi ta'an saa kuati chi'in iin pesuni?, kùuni ndo. Ta na küu koyo ndri ma nuñu'u' i'ya, tuva na chä'a ma Ndioo ña jà'a ndri yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Vati nda ma ixi xini ndo, cha kā'vi va'a ma Racha'nu Ndioo ta'ii'iin yi. ");
INSERT INTO mza_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Na yüvi ndo, ti vaji kua'a' ma saa kuati ikan, va na tüvi ka'nuga ndaa ndri kua maa ndo. ");
INSERT INTO mza_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ta tu ìyo nda yo kà'an tu'in nuu ka'ìin kua'a' ñivi, nda mai ni ka'in cha'a' na nuu ma Tatái, ra ìyo andivi ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Va ma ndian kà'an ña töve nàkoto na yu'u nuu ka'ìin kua'a' ñivi, nda mai ni ka'in ña töve nàkotoi na nuu ma Tatái, ra ìyo andivi ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Koto näkanini ndo ña yu'u vàchi ja'i ña na koo va'a ma ñivi ìyo ñuñivi, ti na yüvi takan kùu yi. Vati yu'u vàchi ja'i ña na kanita'an ndo chi'in ta'an ndo. ");
INSERT INTO mza_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ti vàchi ja'i ña na kanita'an ma ndra'ii, chi'in juuni ma tatá ndra, ta ma ñivi ña'a, chi'in juuni ma'á vi, ta ma ñivi chanu, ni kanita'an vi, chi'in ña ka'nu vi ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta takan kùu yi ña ta'ii'iin ma ñivi, ni kanita'an na, juuni chi'in ma ñivi na. ");
INSERT INTO mza_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ta tu ìyo ndian kùuniga na nde'e na ma tatá na, chi'in ma'á na, tiá kua mai, na töve ìyo yi ña kuu na ma ndian ìyo kuendai. Ta tu ìyo nda ndian kùuniga na nde'e na ma ndra'ii se'e na, a ñivi ña'a se'e na tiá kua mai, na töve ìyo yi ña kuu na ma ndian ìyo kuendai. ");
INSERT INTO mza_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ta ma ndian töve kùuni na tandikun na chatai chi'in kruu na, ikan na nde'e na tundo'o takua ni nde'i tundo'o nuu kruu, ndiakan na töve ìyo yi ña kuu na ma ndian ìyo kuendai ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ta ma ndian kùuni na jakakú na na nuu ndè'e na tundo'o cha'i, ni kuvi na. Va ma ndian ni kuvi cha'i jà'a ma tundo'o, ni kakú na. ");
INSERT INTO mza_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Ta ma ndian kì'in kuenda ndo, juuni kì'in kuenda na yu'u ndia. Ta ma ndian kì'in kuenda yu'u, juuni kì'in kuenda na ma Racha'nu tāchi yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ta ma ndian kì'in kuenda iin ma ra kà'an chi'in tu'un yu'u Ndioo, cha'a' ña ra vàchi kuenda Ndioo kùu ra, ni ni'i na ya'vi na, indukuni takua nì'i ma ra kà'an chi'in tu'un yu'u Ndioo. Ta ma ndian kì'in kuenda iin ndian ndicha va'a, cha'a' ña ndian ya'a va'a kùu na, ni ni'i na ya'vi na, indukuni takua nì'i ma ra va'a ikan yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta nda ndian nikuuni, ña chà'a na jitu iin yachin takuii vichin ko'o ma ndiakuati i'ya, cha'a' ña ndian chàkunuu chi'i̱n kùu na, ndicha va'a ña kà'in chi'in ndo ña Ndioo ni ku'va ra ya'vi na ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Takan kūu ta ora chīnu kā'an Jesuu takan chi'in ma ndi uchi uvi ma ndra jàkua'a chi'in ra, tajan kēe ndio ra ma ikan, kuàkatitu'un ra tu'un Ndioo, ta kua jàna'a ra yi nuu ma ñivi ìyo ma ñuu, ña kùu nda'a' ma ñu'u' ikan. ");
INSERT INTO mza_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ta ma Xuva, ra jàkunduta ña indii tichi vekaa, chīto ndio ra ndisaa ma ña jà'a Cristu. Tajan tāchi ndio ra uvi uni ma ndra jàkua'a chi'in ra ña na kunde'e ndra Jesuu, ");
INSERT INTO mza_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta ndakatu'un ndra te'en nuu ra: ―¿A ndicha ña yo'o kùu ma Cristu, ra ìyo yi ña kichi, a ìyo yi ña kuatu ndi inga ra? ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Na ku'un ndo, ta katitu'un ndo nuu Xuva, ma ña ndè'e ndo, chi'in ma tu'un chìni ndo. ");
INSERT INTO mza_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na katitu'un ndo nuu ra ña ma ndian kuaá, cha ndè'e na, ta ma ndian koxo cha chìka na, ta ma ndian kù'vi jà'a kue'e ta'yu cha ndā'a na ndia. Ta ma ndian so'o cha chìni na, ta ma ndian cha chī'í nàtaku na, ta ma ndian nda'vi chìni na ma tu'un Ndioo ña jàkakú na. ");
INSERT INTO mza_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na sii kuuni ma ndian endee töve jàña ña chìnuni ma ña kà'in ―kàti Jesuu chi'in ma ndra chàkunuu chi'in Xuva. ");
INSERT INTO mza_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Takan kūu ta ora cha kàcha'an ndio ndra, tajan te'en nāka'an Jesuu cha'a' ma Xuva nuu ma ñivi: ―¿Niyi kùu ma ña chānde'e ndo ma tichi ku'u ora chā'an ndo? ¿A iin ndoó vixi ña jākisi tati kùu yi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ta tu yüvi takan kùu yi, ¿nda ña kùu ma ña chānde'e ndo?, tuva takan. ¿A chānde'e ndo iin ra ya'a va'a ja'ma ñù'u, ta vii yi?, kùuni ndo. ¿A tüvi chà'a ndo kuenda ña ma ndian chàku'un ja'ma takan, ìyo na ve'e ma ndra kùu rey? ");
INSERT INTO mza_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Va na katitu'un ndo, ¿nayi kùu ma ña chānde'e ndo? ¿A iin ra kà'an chi'in tu'un yu'u Ndioo kùu ra?, kùuni ndo. Ndicha va'a ña takan kùu yi. Ta iin ra ka'nuga kùu ra kua inga ma ndra kà'an chi'in tu'un yu'u Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Vati nuu ma tutu Ndioo te'en kà'an yi cha'a' ma Xuva: Yu'u, ni tachi̱ ma ra kùu tatuin iti' nuu̱n, ikan na jandova'a ra ma iti' nuu ni chaun, kàti yi. ");
INSERT INTO mza_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ndicha va'a ña ka'in chi'in ndo, ña nï'iin ma ndra'ii ìyo tañu ma ndra ìyo vitin, töve ka'nuga ndra kua ma Xuva, ra jàkunduta. Ta vaji ndicha ña takan kùu yi, va ma nuu chà'nda Ndioo tiñu andivi, ma ra valiga kùu ma ra ka'nuga kua ma Xuva. ");
INSERT INTO mza_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Nda ma kuiya kēta Xuva, ra jàkunduta, ta nda vitin, ma nuu chà'nda Ndioo tiñu andivi cha ìyo kua'a' ñivi ña cha jākanaa vi ña ki'vi na kuenda yi. Ta ma ndian nànduku na naja kua kì'vi na kuenda yi, ndiakan kùu ma ndian cha kundee na nī'i na yi. ");
INSERT INTO mza_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta ndisaa ma ndra kà'an chi'in tu'un yu'u Ndioo, ta chi'in ña kà'an ma ley Ndioo ña tāa Moisés, kātitu'un ndra naja kua kàa ma nuu chà'nda Ndioo tiñu andivi, nda ora kēta tiempu ña kēta ma Xuva, ra jàkunduta. ");
INSERT INTO mza_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta tu kùuni ndo chinuni ndo ma tu'un i'ya, Xuva ra jàkunduta, kùu ma ra nàni Elía, ra kà'an chi'in tu'un yu'u Ndioo, ti rakan kùu ma ra ìyo yi kichi niku. ");
INSERT INTO mza_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yakan va ma ndian chàta'ani taso'o ma ña kà'in, na taso'o na yi. ");
INSERT INTO mza_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Nda yo chi'in kùu jando indukuni ma ñivi ìyo tiempu i'ya?, kùuni ndo. Ndiakan kùu na tava kùu ma ndiakuati che'e, ña ma ora chūnandi na chàsiki na nuu ya'vi, ta ndiakan te'en kanachaa ni'i na nuu meru na: ");
INSERT INTO mza_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tīvi ndi tuvilu, va tüvi nī tacha'a ndo. Ta chīta ndi yaa nda'vi, ta töve nī chaku ndo.” ");
INSERT INTO mza_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Vati kīchi ma Xuva, ra jakunduta, ña töve nī chachi ta töve nī chi'i, ta kāti ndo ña ra ìyo tati xaan chi'in kùu ra. ");
INSERT INTO mza_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta ikan jan kīchi ndio yu'u ma ra Se'e ñivi tāchi Ndioo, ra chàchi, ta chì'i ndisaa nakuyi. Ta ma ñivi kà'an na chata ra te'en: “Rakan kùu ra chàchi kua'a' ta kùu ra iin ra chìní, ta juuni ndìkita'an ra chi'in ndian jà'a kuati, ta chi'in ma ndian nàka'an xu'un' kuenda ñuu Roma.” Takan kàti na. Va tava ma Ndioo nduva'a ìyo chinituni ra, ta ma ña va'a ña jà'a Ndioo jàna'a yi ña ìyo chinituni ra. ");
INSERT INTO mza_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Takan kūu tajan ndisaa ma ñuu nuu yā'a Jesuu, ma nuu jā'a ra kua'aga ma ndatu ra, kūxaan ra chi'in na ti töve nī sama na ma kua ìyo na, ta te'en kīcha'a ndio ra kà'an ra nuu na: ");
INSERT INTO mza_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Nda'vi ta'an ndyo'o ñivi ñuu Corazín! Ta, ¡nda'vi ta'an ndyo'o ñivi ñuu Betsaida! Vati ndicha ña ndē'e ndo ma ndatu ka'nu ña jà'i ñuu ndo. Ta töve nī sama ndo kua ìyo ndo. Vati tu ja'i ma ndatu ka'nu takan niku nuu ma ñivi ñuu Tiro, ta ñuu Sidón, tatiempu cha sāma na ma kua ìyo na niku, ta cha jāna'a na yi chi'in ña chàku'un na ma ja'ma ya'a cha'nu, ta cha chōso na ma yuyaa chata na ndia niku. ");
INSERT INTO mza_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Va yu'u kà'in chi'in ndo ña ora ni chaa ma kivi ña ni jakutuni ma Ndioo kuati ma ñivi, nduva'aga ni nde'e ndo tundo'o kua ma ñivi ìyo ñuu Tiro, ta Sidón. ");
INSERT INTO mza_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ta ndyo'o ñivi ñuu Capernaum, ¿a chànini ndo ña ni ndaa ndito ndo ku'un ndo andivi?, kùuni ndo. Va töve ti nda andaya' nuu ndè'e ma ndian chī'í tundo'o, ikan ni jakanai ndo. Vati tu nuu ma ndian ñuu Sodoma, jā'i ma ndatu ka'nu niku, ma tava jā'i yi nuu ndo, ma ndian ñuu ikan, cha sāma na vitin ma takua ìyo na niku. ");
INSERT INTO mza_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Va ndicha va'a ña kà'in chi'in ndo, ña ma ora ni chaa ma kivi ña ni jakutuni Ndioo kuati ma ñivi, nduva'aga ka'vi, ni nde'e ndo tundo'o, kua ma ñivi ñuu Sodoma. ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Takan kūu ta ma tiempu ikan, te'en nāka'an Jesuu chi'in Ndioo: ―Ya'a jàka'nui ñu̱n yo'o Tatá, ra chà'nda tiñu andivi chi'in ma nuñu'u' ñuñivi, vati ma tu'un xe'e ña ìyo chi'un, na töve nī jana'un yi nuu ma ndian ìyo chinituni, ta ya'a chìto ña kà'an, vati nuu ma ndian nda'vini jāna'un yi. ");
INSERT INTO mza_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ndicha ña takan kūu yi Tatá, ti kua kūuni maun kùu yi. ");
INSERT INTO mza_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Ta ndisaa ma ña ìyoi, cha nāku'va ma Tatái yi nui. Ta nï'iin ñivi, töve nàkoto va'a na yu'u ra kùu Se'e ra, ti uvanuu ma ra nàkoto va'a yu'u, kùu ma Tatái. Ta nï'iin ñivi töve nàkoto va'a na ma ra kùu Tatái, ti uvanuu ma ra nàkoto va'a ra kùu yu'u, ra kùu Se'e ra chi'in nda ndian ni kùuni ña jana'i ma Tatái nuu na ndia. ");
INSERT INTO mza_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ta ndisaa ndyo'o ndian nduva'a chitatu, cha'a' ña ya'a jàtiñu ndo, ta cha'a' ña ya'a vee ndiso ndo, na kichi ndo nui, ta ku'vai nuu nindee ndo. ");
INSERT INTO mza_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ta tandi'i ndyo'o ndian chàta'ani jàchi'in ma tu'un kà'in, ndyo'o ndian chàta'ani kutu'va ma ña chìtoi, cha'a' ña ya'aga jàndeeni̱ nde'i ndo, ta cha'a' ña kùi iin ra masu anima ndia. Tu ndicha ña takan jà'a ndo yi, tajan ni ni'i ndo nuu nindee anima ndo i'ya. ");
INSERT INTO mza_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Vati ma tiñu chà'i nuu ndo ña jà'a ndo, yöve iin ña vee kùu yi kuenda ndo, ti iin tiñu ya'a ñama kùu yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Takan kūu iin kivi ora nindee ñivi judíu, Jesuu chàkunuu ra chi'in ndra jàkua'a chi'in ra iin nuu kàa trigu. Ta tava ma ndra jàkua'a chi'in ra nduva'a chāñu soko ndra, yakan va kīcha'a ndio ndra chà'nu ndra yoko ma trigu, ta kīcha'a ndra kàchachi ndra ma chiti yi. ");
INSERT INTO mza_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ta ora ndē'e ndio ma ndra fariseu ña kàja'a ndra, ta te'en nāka'an ndra chi'in Jesuu: ―Na nde'un ña ja'a ma ndra jàkua'a chi'un, ti ndrakan kàja'a ndra iin ña töve ìyo yi ña ja'a ndra ma kivi nindeo ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ta Jesuu te'en nāka'an ra chi'in ndra: ―¿A takä'an jàkua'a ndo ma nuu kà'an yi naja kua jā'a ma David chi'in ma ndra meru ra ora chāñu soko ndra niku? ");
INSERT INTO mza_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ra'ya kī'vi ra ma tichi veñu'u Ndioo, ta chāchi ra ma paan ií ña ka'ìin ma ikan. Ta yakan ti töve ìyo yi ña kachi ra yi, ta ni ma ndra kùu meru ra, ti uvanuu ma ndra kùu kachi yi, kùu ma ndra kùu sutu ni. ");
INSERT INTO mza_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿A takä'an jakua'a ndo nuu ma Ley Ndioo ña tāa Moisés, ma nuu kà'an yi ña ma ndra kùu sutu veñu'u, vaji töve nindee ndra ma kivi nindee yo, na yöve iin kuati kùu yi kuenda ndra? ");
INSERT INTO mza_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Va yu'u kà'in iin nakuyi ña ndicha chi'in ndo, i'ya ndaa iin ra ka'nu tiaga kua ma veñu'u ka'nu ndian judíu. ");
INSERT INTO mza_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ta ndyo'o, ¿a juuni takä'an kutunini va'a ndo ma ña kà'an yi nuu ma tutu Ndioo i'ya ña kà'an ndo takan? Vati te'en kà'an yi nuu yi: “Yu'u kùuni̱ ña na kunda'vini ndo nde'e ndo ma ñivi, ta töve kùuni̱ ña ndakimani ndo ma Racha'nu chi'in ma kiti sòkó ndo nuu ra.” Tu ndicha ña cha chìto ndo ña kà'an ma tutu tāa Moisés, na töve ìyo yi ña ka'ni ndo ma ndian töve ìyo nï'iin kuati. ");
INSERT INTO mza_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ndicha va'a ña ma ra Se'e ñivi tāchi Ndioo, ìyo ndatu ra cha'a' ma kivi nindee yo. ");
INSERT INTO mza_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tajan kēe ndio Jesuu kuà'an ra ma nuu ndaa ra ikan, ta chāa ra nuu ndaa iin veñu'u vali ma ndian judíu, ta kī'vi ra tichi yi. ");
INSERT INTO mza_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta ndē'e ra ña ma tichi yi, nandi iin ra nda'a' ití. Va tava nànduku ndra naja kua jà'a ndra, ta kā'an Jesuu iin ña tüvi va'a, ta chi'in yakan kùu nani'i ndra naja kua tisokuati ndra ra. Tajan te'en chīkatu'un ndra nuu ra: ―¿A kùu janda'a yo iin ndian ku'vi ma kivi nindee yo? ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ta Jesuu te'en nāka'an ra chi'in ndra: ―¿Nda ndyo'o nikuuni, tu ìyo iin mvechala jàna ndo, ta nde'e ndo ña koyo ri iin tichi soko kono, ma kivi nìndee ndo, a töve ìyo yi ña ku'un ndo, ta tava ndo ri?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tu tavani'i yo ndrikan ña kùu ndri iin kitini, kùuni yi ka'an yi ña, ¡ìyo ga kuenda yi ña tavani'i yo iin ra'ii kua ma mvechala! Cha'a' yakan kùu yi ña, kùu ja'a yo ma ña va'a ma kivi nindeo. ");
INSERT INTO mza_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tajan te'en nāka'an ndio Jesuu chi'in ma ra nda'a' ití: ―Jànakee nda'un ―kàti Jesuu chi'in ra. Tajan jānakee ndio ra ma nda'a' ra, ta kīndoo va'a va'a yi, kua kàa ma inga chiyo nda'a' ra. ");
INSERT INTO mza_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ta ora kēe ndio ma ndra fariseu ma tichi veñu'u ikan, tajan kīcha'a ndra jando'iin tu'un ndra, naja kua ìyo yi ña jà'a ndra, ta ka'ni ndra Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Takan kūu ta ora chīto Jesuu ña takan chànini ma ndra fariseu, tajan kēe ndio ra ma ikan, ta nduva'a kua'a' ñivi tāndikun na chata ra. Ta jànda'a Jesuu tandi'i ma ndian ku'vi, ");
INSERT INTO mza_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ta kàtitu'un ra nuu na ña koto kätitu'un na nuu ka'ìin kua'a' ñivi nda ra kùu ra. ");
INSERT INTO mza_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Te'en kūu yi, ikan na chinu ma tu'un kā'an ma Isaía, ra kā'an chi'in tu'un yu'u Ndioo, ma ora kā'an ra te'en: ");
INSERT INTO mza_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ra'ya kùu ma ra jà'a tiñu nui, ra kāchi̱n, ta ra ya'a kùuni̱ nde'i, ña ya'a chisii̱ nde'i. Ni jakoyoi ma Tati Ií chata ra. Ta rakan ni katitu'un ra nuu ñivi ìyo ninii ka'nu ñuñivi naja kua kuu ndakuu na ñivi ndaa kuenda Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na töve ni natu'un ra chi'in ma ñivi, ta na töve nda'yu ni'i ra nuu na ndia, ta ni nï'iin ñivi töve ni kuni na ma tati ra ma kai ndia. ");
INSERT INTO mza_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ta juuni na töve ni ka'nu ra ma ndoo ña cha tā'nu, ta ni töve ni nda'va ra ma mecha ña ja kicha'a ndañu'ma yi, nda kati jakanaa ji'na ra ma ñivi kuenda ra, tajan ni jandi'i ra nuu ma kuati. ");
INSERT INTO mza_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta ninii ka'nu ma nuñu'u' ñuñivi ni jandeeni na kuatu na, nda kati ni ja'a ra ña na koo va'a na. ");
INSERT INTO mza_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Takan kūu tajan chāndaka ma ñivi iin ra ndiso tati xaan ña kuaá ta ñi'i nuu ma Jesuu. Ta ma Jesuu jānda'a ra ma tinuu ra chi'in ma yu'u ra, ikan na kuu ndè'e ndiko ra ta juuni kùu ka'an ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tajan ndisaa kuii ma ñivi, ndava kuà'an tati na, ta te'en kīcha'a na chìkatu'un ta'an na: ―¿A yüvi ra se'e David kùu ra'ya?, kùuni ndo ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ta ora chīni ndio ma ndra fariseu ña takan kà'an na, tajan te'en kīcha'a ndra kà'an ndra: ―Ma kui'na nàni Beelzebú ña kuxini nuu ma tati xaan, yakán' kùu ma ña chā'a ma ndatu ikan nuu ra'ya, ikan na kuu tava ra yi kuñu ma ñivi ―kà'an ndra. ");
INSERT INTO mza_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Va tava Jesuu cha chìto ra naja kua chànini ndra, yakan va te'en kīcha'a ndio ra kà'an ra nuu ndra: ―Tu kànita'an ñivi ìyo iin ñuu juuni chi'in maa na, ni ndi'i nuu na. Ta tu ìyo ñivi ìyo iin ve'eni ta kanita'an na juuni chi'in maa na, ni ndi'i nuu na chi'in nda ma ve'e na ndia. ");
INSERT INTO mza_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ta juuni kà'in ña tu kànita'an ñivi Satanaa chi'in juuni maa na, juuni ni ndi'i nuu na, vati na küu kanita'an ma kui'na juuni chi'in ma ñivián'. Ti tu ja'án' takan, numini ni ndi'án' chi'in ñivián'. ");
INSERT INTO mza_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tu chànini ndo, ña chi'in ndatu Beelzebú tàvai ma tati xaan, tajan juuni ma ndian tàva tati xaan ndiso ma ñivi ña ìyo tañu ndo, juuni maa na ni tisokuati na ndo, ti tüvi va'a chànini ndo. ");
INSERT INTO mza_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Vati tu yu'u tàvani'i̱ tati xaan ndiso ñivi chi'in ndatu Ndioo, yakan kùuni yi jana'a yi ña cha ìyo ma nuu chà'nda Ndioo tiñu chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Nayi ìyo yi ña ja'a iin ñivi, ta kùu ki'vi na su'u na ve'e iin ra ya'a ni'i?, kùuni ndo. ¿A töve ìyo yi ña ku'ni ji'na na ra?, kùuni ndo. Ndicha ña kùu ja'a na yi, uvaa ña tu jà'a na takan. ");
INSERT INTO mza_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ma ndian töve ìyo kuendai, ndian xaani nde'e yu'u kùu na. Ta ma ndian töve ndàki'in ma tu'un kà'in, va kàtitu'un na inga tuku tu'un ña jàkanuu yi xini ma ñivi, ndiakan töve ñivi kuendai kùu na ndia. ");
INSERT INTO mza_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Yakan va yu'u kà'in ña ma Ndioo, jàka'nuni ra kuati ma ndra'ii, chi'in tandi'i ma tu'un ti'ini ña kà'an ndra ndia. Va tu kà'an ti'ini ndra chata ma Tati Ií Ndioo, na töve ni jaka'nuni ra ma kuati ndra tuva takan. ");
INSERT INTO mza_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ta tu kà'an ti'ini ma ñivi chata ma ra Se'e ñivi tāchi Ndioo, ma Racha'nu Ndioo ni jaka'nuni ra ma kuati. Va tu kà'an ti'ini na chata ma Ra Tati Ií Ndioo, töve ni jaka'nuni ma Ndioo kuati na, ni ma ñuñivi ña ìyo vitin, ta ni ma ña ni koo iti' nuu töve ni ja'a ra yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Tu tachi ndo iin yutun va'a, ni ku'va run ma chiti va'a kachi ndo. Ta tu töve va'a ma yutun tàchi ndo, ni ku'va run ma chiti vä'a'. Ta takan kùu yi ña chi'in ma chiti run, cha nakoto yo nda yutun kùu run. ");
INSERT INTO mza_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ndyo'o tatá ndian xaan tava xaan ma koo! ¿Naja kua kùu yi ña kà'an ndo ma tu'un vii ta va'a, ta juuni maa ndo kùu ma ndian kini? Ndisaa ma tu'un ña kàya ma anima yo, yakan kùu ma ña kà'an yo. ");
INSERT INTO mza_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vati taku ma ra'ii va'a, mamaa ña va'a kùu ma ña kà'an ra, ti ña va'a kùu ma ña ìyo tichi anima ra. Ta ma ra'ii ña töve va'a, mamaa tu'un kini kùu ma ña kà'an ra, ti ña kini kùu ma ña ìyo tichi anima ra. ");
INSERT INTO mza_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ta yu'u kà'in ña ma kivi ña ni jakutuni ma Ndioo kuati ma ñivi, tandi'i ndo ìyo yi ña ku'va ndo kuenda cha'a' ma nda tu'un kini nikuuni ña kā'an ndo ndia. ");
INSERT INTO mza_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vati juuni cha'a ma tu'un ña kà'an ndo, yakan kùu yi ña ni jandondaa yi ma kuati ndo, tuva ndian ìyo kuati kùu ndo a töve. ");
INSERT INTO mza_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tajan uvi uni ndra fariseu, chi'in ndra kùu matru ña jàkua'a tutu Ndioo, te'en nāka'an ndra chi'in Jesuu: ―Matru, kùuni ndi nde'e ndi ña na ja'un iin ndatu ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Ma ndian kini, chi'in ndian töve ìyo tundeeni Ndioo chi'in kùu ma ndian chìkan na ña na ja'i iin ndatu ndē'e na. Va yu'u kàti̱ ti tüva ga ni jana'a Ndioo ndatu nuu na, vati uvaa ma ndatu ña jā'a Jonás taji'na. Yakani kùu ma ña ni nde'e na. ");
INSERT INTO mza_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vati takua tā'an ma Jonás ña chūndii ra uni kivi, ta uni chanikuaa tichi ma tiaka' ka'nu, juuni takan ni ta'an yu'u ra kùu Se'e ñivi tāchi Ndioo, ti ni kundii ra uni kivi, ta uni chanikuaa tichi ñu'u' ndia. ");
INSERT INTO mza_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yakan va ma ñivi chīyo ñuu Nínive ni jaketa ndiko Ndioo na, tajan ni tachi ra na ña na tisokuati na ñivi ìyo tiempu i'ya ora ni tiku'va ra kuati ñivi. Vati ma ñivi ñuu Nínive ndākoo na kuati jā'a na ta chīkoni'i ndiko na iti' Ndioo ora kātitu'un Jonás tu'un Ndioo nuu na. Yakan va yu'u ra kàtitu'un nuu ndo ka'nugai kua Jonás. ");
INSERT INTO mza_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Vati ora ni chaa tiempu ña ni tiku'va Ndioo ma kuati jà'a ndisaa ñivi, juuni ni jaketa ra iin ña'a kūu reina ña chà'nda tiñu nuu ñivi chīyo iti' xuu. Ta yakan kùu ma ña ni tachi Ndioo ña na tisokuatian ndo ora ni tiku'va ra kuati. Vati yakan kīchian iin ñuu ya'a chika, tajan jāchi'an tu'un Ndioo ña kā'an Rey Salomón taji'na. Va vitin yu'u kùu iin ra ka'nu ga kua Rey Salomón. ");
INSERT INTO mza_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Ora kèe iin ma tati xaan tichi kuñu iin ra'ii, chàkunuu yi ma nuñu'u' ití nànduku yi nuu kùu nindee yi. Ta tu töve nàta'an yi ma nuu nindee yi, ta kīcha'a ndio yi nàkanini yi te'en: ");
INSERT INTO mza_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Va'a ga ña chikoni'i ndikoi ma ve'e nuu chīyoi niku”, kàti yi. Tajan ma ora chīkoni'i ndio yi, ta nàta'an yi ma ra'ii ikan ña kàa ra tava kàa iin ve'e ña tüva ña koo tichi, ña vii va'a nāti'vi yi, ta ndōva'a va'a yi. ");
INSERT INTO mza_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tajan kuà'an ndio yi, ta jàti'vi ta'an yi inga ucha ta'an ma tati xaan ga kua maa yi, ta ndisaa ndio yi kì'vi yi tichi kuñu ma ra'ii ikan, ta ma nuu ndi'i nia ka'vi ga ndè'e ra tundo'o jà'a yi, kua ma ora kīcha'a yi. Ta takan ni ta'an ma ndian kini ña ìyo ma ñuñivi i'ya vitin. ");
INSERT INTO mza_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Juuni ndaa Jesuu jàna'a ra nuu ma ñivi, ora chāa ma ma'á ra, chi'in ndra yani ra, ta ñivi ta'an ra, ña kùuni vi natu'un vi chi'in ra. Va tava kīndoo vi ma nuke'e, ti nī kuu ki'vi vi. ");
INSERT INTO mza_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yakan va ìyo iin yo kēe chākatitu'un nuu Jesuu, ta te'en nāka'an ra chi'in ra: ―Nuke'e ndaa ma'un, chi'in ndra yaniun, ta ñivi ta'un, ña kùuni vi ka'an vi chi'un ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Va Jesuu te'en nāka'an ra chi'in ma ra chākatitu'un nuu ra: ―¿Yo kùu ma'i, ta yo kùu ma ndra yani̱, ta ñivi ta'in?, kùuniun. ");
INSERT INTO mza_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tajan kīcha'a ra jànanda'a ra nuu ka'ìin ma ndra jàkua'a chi'in ra, ta te'en nāka'an ra: ―Ndia'ya kùu ma'i, ndra yani̱, ta ñivi ta'in. ");
INSERT INTO mza_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vati nda ndian nikuuni ña jà'a ña kùuni ma Tatái ra ìyo andivi, ndiakan kùu ma ndra yani̱, ñivi ta'in, ta ma'i ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Takan kūu tajan juuni ma kivi ikan, kēe Jesuu ma ve'e nuu ìyo ra, ta chākunandi ra yu'u lakuna. ");
INSERT INTO mza_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ta tava ya'a kua'a' ñivi kūti'vi ma nuu nàndi ra, yakan va Jesuu ndāa ndio ra tichi iin varku ña ndaa ma ikan, ta chūnandi ra, juuni yanga ndatu ma ñivi ña kùuni na taso'o na ma ña ni ka'an ra ma yu'u lakuna. ");
INSERT INTO mza_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tajan kīcha'a ndio ra kà'an ra kua'a' nakuyi nuu na chi'in mamaa ku'va. Ta te'en nāka'an ndio ra chi'in na: ―Ìyo iin ra tàchi, ña kēe ra kuà'an ra kuàtachi ra. ");
INSERT INTO mza_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta ora tāchi ra ma chiti, ta ita'vi yi kāchita ma tichi iti', ta ndē'e ma saa yi, ta nūu ndri ma nuu kàndoyo yi, ta kāchachi ndi'i ndri yi. ");
INSERT INTO mza_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ta ita'vi yi va kōyo tañu yuu. Ta ikan ti nuuni yoso ma ñu'u', ti mamaa yuu kùu yi. Ma chiti ikan numini nāka'ndi yi, ti na töve kokon kandoyo ma yuti. ");
INSERT INTO mza_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Va ora ñuka'ñu ndií, nduva'a kuii xīi ndio yi, ta nātii yi, ti töve kunu indii ma yo'o yi. ");
INSERT INTO mza_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ta inga ita'vi ma chiti, va kāchita yi tañu ma ku'u iñu, ta ma iñu ikan numini chā'nu yi, ta chāsi yi nuu yi, ta chī'i yi. ");
INSERT INTO mza_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Takan kūu ta inga ita'vi ma chiti, va kāchita yi ma nuu ìyo ñu'u' va'a, ta nduva'a kuii kua'a' ma trigu kākee nuu yi, ìyo yoko ma trigu ña kēe iin cientu chiti nuu, ta ìyo yoko ña kēe uni xiko chiti nuu, ta ìyo inga yi ña kēe oko uchi chiti nuu yi. ");
INSERT INTO mza_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nda ndyo'o chìni ndo ña kà'in, na taso'o ndo yi. ");
INSERT INTO mza_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tajan ma ndra jàkua'a chi'in Jesuu cha jàyatin ndra ndra nuu ndaa ra, ta chīkatu'un ndra nuu ra naja kà'an ra chi'in ku'va nuu ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tajan Jesuu te'en nāka'an ndio ra chi'in ma ndra jàkua'a chi'in ra: ―Nuu ndyo'o va chà'a Ndioo ña na koto ndo ma tu'un xe'e ña ìyo chi'in ra nuu chà'nda ra tiñu, va nuu ma ñivi ikan, töve. ");
INSERT INTO mza_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta tu jàtiñu va'a ndo kuenda Ndioo, ni tindee ra ndo tiá kua'a'. Va tu tüvi jàtiñu va'a ndo takua kùuni ra, vaji tiania ma tiñu jà'a ndo ìyo, va tandi'i yi ni kindaa ndiko ra yi. ");
INSERT INTO mza_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cha'a' yakan kùu yi ña kà'in ma tu'un i'ya nuu na chi'in ku'va. Vati ma ñivi ikan ndè'e na, va töve jàchi'in na ma ña nde'e na, chini na, va töve taso'o na, ta ni töve kutunini na ña kà'in ndia. ");
INSERT INTO mza_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ta takan kūu yi ña jāchinu ma ra kā'an chi'in tu'un yu'u Ndioo, ra nàni Isaía ma ña kā'an ra niku, ti rakan te'en kā'an ra: Vaji chìni na, ma ña kà'in, va töve kutunini na yi. Ta vaji ndè'e na yi, va na küu ku'va na kuenda nayi kùu yi. ");
INSERT INTO mza_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Vati ma ñivi ìyo ñuu i'ya, jàndava na anima na, ta ndasi ma so'o na, ta ndàsi ma tinuu na, ikan na küu nde'e na, ta tàso'o na ma ña kà'in. Ta juuni ndasi ma chinituni na, ikan na küu ga chikoni'i ndiko na chi'i̱n, kuenda ña jànda'i na tuva ku'vi na ndia. ");
INSERT INTO mza_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Va na sii kuuni ndyo'o, ti ìyo tinuu ndo ña ndichin ndè'e, ta ìyo so'o ndo ña chìni. ");
INSERT INTO mza_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ndicha va'a ña kà'in chi'in ndo, ña kua'a' ma ndra kā'an chi'in tu'un yu'u Ndioo, ta inga tuku ma ñivi va'a ña kūuni na nde'e na ma ña ndè'e ndo vitin, va töve nī nde'e na yi. Kūuni na tàso'o na ma ña chìni ndo vitin, va töve nī kuu yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Kùuni̱ ña na taso'o va'a ndo naja kua kùuni ma ku'va ña kà'an cha'a' ma ra tàchi ka'an yi. ");
INSERT INTO mza_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ma ndian tàso'o ma tu'un kà'an cha'a' ma nuu chà'nda Ndioo tiñu, ta töve kùtunini na ma ña kùuni yi ka'an yi, ndiakan kùu na tava kùu ma chiti trigu ña kāchita ma tichi iti', ti ndiakan ora cha yā'a ña chīni ndio na ma tu'un va'a Ndioo, tajan vàchi ndio ma kui'na, ta janaa ndio yi ma tu'un Ndioo ña cha ìyo chi'in na ma tichi anima na. ");
INSERT INTO mza_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ta ma chiti ña tāchi tañu yuu, yakan va kùu yi, tava kùu ma ndian chìni ña kà'an ma tu'un va'a Ndioo, ta ndàki'in na yi chi'in ndisaa anima na, ");
INSERT INTO mza_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","va tava töve ìyo kua'a' yo'o na, tava kùu ma chiti jà'a ma yuu, yakan kùuni yi ka'an yi ña ndiakan chìnuni na tu'un Ndioo va tia tiempuni, ta ndàkoo na yi. Vati cha'a' ma tu'un i'ya, ora kìcha'a na ndè'e na tundo'o cha'a' yi a kànita'an ñivi chi'in na cha'a' yi, numini jàña na ña chìnuni na yi. ");
INSERT INTO mza_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ta ma chiti ña tāchi tañu iñu, yakan, va kùu yi tava kùu ma ndian chìnuni ma tu'un Ndioo, va chìtu'un ga na tiaga cha'a' ma ndatiñu ña ìyo nuu na ma ñuñivi i'ya, ta juuni cha'a' ña ya'a ga kùuni na nde'e na ma xu'un', yakan jànda'viña'a yi na. Ndisaa ña'a kùu yi tava kùu ma chiti trigu ña ora kùuni yi kua'nu yi, ta ma iñu ndu'va jàvati yi nuu yi, ta tüvi chà'a yi kua'nu yi. ");
INSERT INTO mza_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Va chiti ña tāchi nuu ñu'u' va'a, yakan, va kùu yi tava kùu ma ndian chìni va'a ma tu'un Ndioo, ta kùtunini va'a na ma ña kà'an yi, ndiakan va kùu na tava kùu ma chiti ña chā'a kua'a' va'a chiti. Ìyo ma chiti ña chà'a yi iin cientu chiti, ta ìyo inga yi ña chà'a yi uni xiko chiti, ta inga yi chà'a yi nda oko uchi chiti ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Takan kūu tajan Jesuu te'en nāka'an tuku ra inga ku'va nuu ma ñivi: ―Ma nuu chà'nda Ndioo tiñu, kùu yi tava kùu iin ra'ii ña tāchi chiti va'a ma nuu ñu'u' ra, ");
INSERT INTO mza_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","va ora tīin ñuma'na ndra, ta ndisaa ndra kìxi kàndoyo, tajan chāa iin ra xaani ndè'e nuu ndra, ta rakan tāchi ra ku'u ña töve va'a nuu tāchi ndra ma chiti trigu, ta kēe ndiko ra kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Takan kūu ta ora kāna ndio ma chiti trigu, ta chā'nu yi, ta kīcha'a ndio yi ndata yoko yi, tajan ikan kēta ndio ma ku'u ña na töve va'a. ");
INSERT INTO mza_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tajan chā'a ndio ma ndra musu kuenda, ta kēe ndio ndra chākatitu'un ndra te'en nuu ma ra kùu chito'o ndra: “Yo'o racha'nu, ¿na yüvi chiti va'a kùu ma ña tāchiun nuu ma ñu'u̱n? Vati tu takan kùu yi, ¿ndanu kēe ma ku'u ña töve va'a kàa tañu ma trigu tuva takan?” ");
INSERT INTO mza_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tajan ma ra kùu chito'o ndra, te'en nāka'an ra chi'in ndra: “Ìyo iin nda ra xaani ndè'e nui jā'a yi”, kàti ra. Tajan ma ndra musu ra, te'en nāka'an ndra chi'in ma chito'o ndra: “¿A kùuniun ña ku'un ndi, ta tu'un ndi'i ndi ma ku'u ña töve va'a?”, kàti ma ndra kùu musu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Va ma ra kùu chito'o ndra, te'en nāka'an ra chi'in ndra: “Na küu yi, koto ora tù'un ndo ma ku'u ña töve va'a, jà'a ndo tu'un ndo nda ma trigu chi'in yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ma ña ìyo yi ña ja'a yo kùu yi ña va'a ga ña na ku'va yo kua'nu ninduvi yi, nda kati keta ma tiempu ña kàni'i yo ma cosecha, tajan tachi ndioi ma ndra ku'un kujati'vi vu. Ji'na ìyo yi ña kà'nda ndra ma ku'u ña töve va'a, ta ku'ni ndra kuenda sukun yi, ta ka'mi ndra yi, ta ikan jan taan va'a ndio ndra ma trigu tichi yakai.” Takan kàti ma ra chito'o ndra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Takan kūu ta juuni te'en nātu'un Jesuu inga tuku ku'va i'ya nuu ma ñivi ndia: ―Ma nuu chà'nda Ndioo tiñu, indukuni kùu yi tava kùu ma chiti yukú mostaza ña tàchi ma ndra'ii ma nuu ñu'u' ndra. ");
INSERT INTO mza_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndicha va'a ña ma chiti i'ya kùu ma chiti vali ga kua tandi'i inga nuu ma chiti, va ora chà'nu yi, chà'nu sukun ga yi kua inga nuu ma yutun, ña ora chà'nu yi kàa yi takua kàa ma yutun, ña nda ma saa ña kàchika nuu sukun, jàva'a ndri taka ndri ma nuu ìyo sokó yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Takan kūu tajan te'en nāka'an tuku Jesuu inga tuku ku'va nuu ma ñivi: ―Ma nuu chà'nda Ndioo tiñu, indukuni kùu yi tava kùu ma yuchan iya ña kuva'a paan, ña tīku'va iin ña'a chi'in uni ku'va ma yuti paan, ta yakan jàkanuan yi chi'in ma yuchan iya, ta kīcha'a ndioan jàvita ña yi, ta nàndaa ndio yi. ");
INSERT INTO mza_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tandi'i tu'un i'ya jāna'a Jesuu ma tu'un Ndioo nuu ma ñivi chi'in ku'va. Ta nï'iin tu'un töve kà'an ra nuu na tu töve kà'an ra yi chi'in ku'va. ");
INSERT INTO mza_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Te'en kūu yi, ikan na chinu ma tu'un kā'an ma ra kā'an chi'in tu'un yu'u Ndioo niku: Ni nunai yu'i kuenda ña kā'in chi'in ku'vani nuu ma ñivi, ta ni ku'vai ña na koto ndio ma ñivi ma tu'un xe'e, naja kua jātuvi Ndioo ma ñuñivi taji'na. ");
INSERT INTO mza_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Takan kūu ta ora cha yā'a kā'an ndio Jesuu chi'in ma ñivi, tajan kēe ndio ra kuà'an ra iin tichi ve'e nuu ka'ìin ma ndra jàkua'a chi'in ra. Ta ikan jan chājayatin ma ndra jakua'a chi'in ra ndra nuu ra, ta kīcha'a ndra chìkan ndra nuu ra ña na katitu'un kachin ra, nayi kùuni ma ku'va ña kà'an cha'a ma ku'u ña tüvi va'a, ña kāna ma nuñu'u'. ");
INSERT INTO mza_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Ma ra tachi ma chiti trigu, rakan kùu ma ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ta ma nuñu'u' tāchi ra vu, kùu ma ñuñivi. Ta ma chiti trigu kùu ma ndian ìyo nuu chà'nda Ndioo tiñu, ta ma ku'u ña töve va'a yakan kùu ma ndian se'e kui'na. ");
INSERT INTO mza_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ta ma ra xaani ña tāchi ma ku'u töve va'a, rakan kùu ma kui'na. Ta ma cosecha, yakan kùu ma nuu ni ndi'i ñuñivi. Ta ma ndian musu ña nàkuiso ma trigu, ndrakan kùu ma tati jà'a tiñu nuu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ta takan kùu yi, ña tava jā'a ma ra tū'un ma ku'u ña töve va'a, ta chā'mi ra yi nuu ñu'ú, takan ni kùu yi ma nuu ni ndi'i ñuñivi. ");
INSERT INTO mza_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tajan ma ra Se'e ñivi tāchi Ndioo, ni tachi ra ma tati jà'a tiñu nuu ra ma nuu chà'nda ra tiñu, ña na jati'vi ndra ma ndian jà'a ña na ja'a ma ñivi kuati, chi'in inga ma ndian jà'a kuati ndia. ");
INSERT INTO mza_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ta ni ti'i yi na tichi ma yavi nduva'a kuii kunu nuu ìyo ñu'ú, ta ikan kùu ma nuu nduva'a kuii ni nde'e na tundo'o ña ndava ni jakari'yu na nu'u na. ");
INSERT INTO mza_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tajan ndisaa ma yo chìnuni ña kà'an Ndioo, ni ndotacha yo tava tacha ma nikandii, ma nuu chà'nda ma Tatá yo Ndioo tiñu. Ma yo tàso'o ma ña kà'in, na jachi'in ndo yi. ");
INSERT INTO mza_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Ma nuu chà'nda Ndioo tiñu, juuni indukuni kùu yi, tava kùu ma xu'un' ña indii xe'e tichi ñu'u' iin ñivi. Tajan iin ra'ii nàta'an ra nuu indii ma xu'un' ikan, ta rakan tīxe'e ndiko ra yi juuni ma nuñu'u' nāta'an ra yi, ta rakan nduva'a kuii chìsii ra kuà'an ra, ta xìko ra ndisaa kuii ma ña ìyo nuu ra, ta jàta ndio ra ma ñu'u' ikan. ");
INSERT INTO mza_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Ma nuu chà'nda Ndioo tiñu, juuni indukuni kùu yi, tava kùu iin ma ra xiko ña nànduku ra ma yuu tacha ña nduva'a vii kàa. ");
INSERT INTO mza_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta ora nāta'an ndio ra ma yuu tacha ña nduva'a ya'vi ndaa nuu iin ñivi, tajan kēe ndio ra kuà'an ra, ta xīko ra ndisaa kuii ma ña ìyo nuu ra, ta jāta ndio ra yi. ");
INSERT INTO mza_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ma nuu chà'nda Ndioo tiñu, indukuni kùu yi tava kùu ma ndra kìin chi'in yu'va tiaka' ka'nu, ña ora kani ndra yi ma nuu tañu'u, ta tàvani'i ndra ndisaa nuu ma tiaka'. ");
INSERT INTO mza_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tajan ora tuvini ndio ndra ña cha kuvee yi, ta tàva ndio ndra yi ma ñu'u' ití yu'u tañu'u, ta chùnandi ndio ndra kàchin ndra mamaa tiaka' va'a ni, ta tàan ndra ndri tichi tuka, ta ma kiti ña na küu kacho, chàta ndra ndri. ");
INSERT INTO mza_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Takan ni kuu yi ma nuu ni ndi'i ñuñivi, ti ni keta ma tati jà'a tiñu kuenda Ndioo, ta ni tavani'i siin yi ma ndian kini ña ìyo tañu ma ndian va'a. ");
INSERT INTO mza_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ta ma ndian kini, ni kati'i yi na tichi ma yavi nduva'a kuii ka'nu, nuu ìyo ñu'ú, ta ikan kùu ma nuu nduva'a kuii ni nde'e na tundo'o ña ndava jakari'yu ma nu'u na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Takan kūu tajan Jesuu te'en chīkatu'un ra nuu ma ndra jàkua'a chi'in ra: ―¿A kùtunini ndo ndisaa ma ña kà'in chi'in ndo? ―kàti ra chi'in ndra. Ta ndrakan te'en nāka'an ndra: ―Juu, kùtunini ndi yi, yo'o Racha'nu ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tajan te'en nāka'an tuku Jesuu chi'in ndra: ―Cha'a' yakan kùu yi ña tu iin matru jàkua'a tutu Ndioo, kīcha'a ra kà'an ra cha'a' ma nuu chà'nda Ndioo tiñu nuu ma ñivi, rakan kùu ra tava kùu iin ra xuve'e, ti chìto ra tàvani'i ra ma ña ka'nu, ta chaa, ta ma ña cha'nu ña kumi ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Takan kūu ta ora chinu kā'an Jesuu ma ku'va i'ya nuu ma ñivi, tajan kēe ndio ra ma ikan, ta kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ta ora chāa ndio ra ma ñuu ra, ta ikan kīcha'a ra jàna'a ra ma tu'un Ndioo nuu na ma tichi veñu'u vali ña ìyo ma ñuu ikan. Ta ma ñivi ndava kuà'an anima na ndè'e na ña jàna'a ra takan, ta te'en kīcha'a ndio na nàtu'un ta'an na: ―¿Ndanu kūtu'va ma ra'ya ndisaa ma ña chìto ra? ¿Ta nda iti' kīchi ma ndatu ra ña kùu janda'a ra ñivi? ");
INSERT INTO mza_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿A yöve ra'ya kùu ma ra se'e, ra jàtiñu chi'in vitu, ta ma'á ra kùu ma ña nàni Ndiya?, kùuni ndo. Ta, ¿a yöve ra'ya kùu yani ma Jandiau, Kusé, Simón, ta Juda ndia? ");
INSERT INTO mza_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ta a yöve ñivi ta'an ra'ya kùu ma ñivi ìyo tañu yo?, kùuni ndo. ¿Ndanu kūtu'va ra tandi'i ma ña chìto ra i'ya?, kùuni ndo ―kàti ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ta ma ñivi kīcha'a na kùxaan na nde'e na ra cha'a ma ña kà'an Jesuu. Va ma Jesuu te'en nāka'an ra chi'in na: ―Nda nikuuni jàka'nu na iin ra kà'an chi'in tu'un yu'u Ndioo, va juuni ma ñu'u' nuu kāku ra, ta nuu ìyo ra töve kùu jakakú na ra. ");
INSERT INTO mza_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Takan kūu ña töve nī kuu ja'a ma Jesuu kua'a' ndatu nuu ma ñivi ña ìyo ma ñuu ikan cha'a' ña töve nī chinuni va'a na ma tu'un kà'an ra. ");
INSERT INTO mza_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Takan kūu ta ma tiempu ña kùu Herode kuvienu ma ñu'u' Galilea, chīnitu'un ra ma ña va'a jà'a Jesuu, ");
INSERT INTO mza_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","tajan Herode te'en nāka'an ra nuu ma ndian jà'a tiñu nuu ra: ―Rakan kùu ma Xuva ra jàkunduta, ña ja nātaku ndiko. Cha'a' yakan kùu yi ña ìyo ndatu ra kuenda ña jànda'a ra ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Takan kà'an Herode, ti juuni maa ra tāchi ra ma ndra jà'a tiñu nuu ra ña tīin ndra ma Xuva, ta chū'ni ndra ra chi'in kadena, ta tī'i ndra ra vekaa, cha'a' ma ña nàni Herodías ña kūu ñasi'i ma ra yani ra Lipe. ");
INSERT INTO mza_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tī'i Herode Xuva vekaa cha'a' ña kā'an ra te'en chi'in ra: ―Na töve va'a jà'un, ña ndàkaun ña. ―Takan kāti Xuva chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Takan kūu tajan Herode, kūuni ka'ni ra ma Xuva niku, va ndasii ra ndè'e ra ma ñivi, ti ndisaa na cha chìto na ña ma Xuva kùu ra iin ra kà'an chi'in tu'un yu'u Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Va ora jā'a ma Herode viko nuu chīnu ra kuiya ra, ma ña se'e Herodías, kēan chātacha'a ña nuu ma ndian ka'ìin ma viko ra. Va tava ya'a chāta'ani ra ña, ");
INSERT INTO mza_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yakan va chā'a ra tu'un nuan ña kùu ku'va ra tandi'i nda ña kùuni maa ña ndakan ña nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tajan ji'na chākatitu'an nuu ma'á ña nayi ìyo yi ña ndakan ña nuu ra. Ta ma ña yoko ikan, te'en nāka'an ña chi'in ma Herode: ―Kùuni̱ ña na ku'vaun xini ma Xuva, ra jàkunduta nui tichi iin ko'o ―kàtian chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ta ora kā'an ña takan chi'in Herode, nduva'a nda'vi kūuni ra, va tava cha chā'a ra tu'un nuan, nuu chīni tandi'i ma ndian ka'ìin nuu ìyo ma viko ra, ta tāchi ndio ra ña na kichi ndaka ndra xini ma Xuva ra jàkunduta nuan. ");
INSERT INTO mza_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yakan va tāchi ndio ra ndra ña kuka'nda ndra xini ma Xuva nuu indii ra tichi vekaa. ");
INSERT INTO mza_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ta nunuuni, ndà'a ndio ndra xini ra kīchaa ndra nuu ma ña yoko, ta chā'a ndra yi nuan tichi iin ko'o, ta yakan chā'a ndioan yi nuu ma ma'á ña. ");
INSERT INTO mza_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tajan chākoyo ndio ma ndra chàkunuu chi'in Xuva, ta kāni'i ndra ma ñunda'yu ra, ta kuà'an yi chi'in ndra, ta kūchi ndio ndra yi. Ta ora cha yā'a ndio, tajan kēe ndio ndra chākatitu'un ndra nuu Jesuu ña cha chī'í ma Xuva. ");
INSERT INTO mza_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ta ora chīto Jesuu ña chī'í ma Xuva, tajan kēe ndio ra kuà'an ma'iin ra chi'in iin lancha ma iin nuu taxiin. Va tava chīto ma ñivi nda ñuu kuà'an ra, yakan va kēe na ñuu na kuà'an na chata ra chi'in cha'a' na. ");
INSERT INTO mza_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ta ora nūu ndio Jesuu ma tichi lancha, ta ndē'e ra ña ya'a kua'a' ma ñivi chāa ma nuu ra. Yakan va kūnda'vini ra na, ta jānda'a ra ma ndian ku'vi ña ndàka na chāa na nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Va tava chani kuna'a kùu yi, yakan va ma ndra jàkua'a chi'in Jesuu, te'en nāka'an ndra chi'in ra: ―Cha kuà'ini kùu yi, ta ma i'ya iin nuu taxiin kùu yi. Va'a ga ña na ka'un chi'in na, na ku'un na kujata na ma ña kachi na nuu ìyo ma kuariya kuati. ―Takan kàti ma ndra jàkua'a chi'in Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Töve ìyo yi ña ku'un na, ti maa ndo ìyo yi ña ku'va ndo ma ña kachi na ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ta ndrakan te'en nāka'an ndra chi'in Jesuu: ―¿Naja kùuniun ña ku'va ndi ña kachi na, tuva ndà'a ndi u'un paan, ta uvi tiakani? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ta te'en nāka'an tuku Jesuu chi'in ndra: ―Na kichi ndaka ndo yi nui i'ya ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tajan tāchi ndio Jesuu ma ndra jàkua'a chi'in ra ña na ka'an ndra nuu ma ñivi ña na kunandi na nuu ma ita yuta' ña kàa ma ikan. Ta ikan jan kī'in ndio Jesuu ma ndi u'un paan, ta ninduvi ma tiaka', tajan ndē'e ndio ra iti' andivi, ta kā'an ndio ra chi'in Ndioo cha'a' yi, ta chā'nda kuati ra ma paan, chi'in ma tiaka', ta chā'a ndio ra yi nuu ma ndra jàkua'a chi'in ra ña na nata'vi ndra yi nuu ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ta ndisaa na chāchi nda'a va'ani na nda kati chitu tichi na. Ta ora chīnu chāchi na, ta jākutua ndra uchi uvi ga tuka chi'in ma pedazu ña chākoso. ");
INSERT INTO mza_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ta ma ñivi chā'a Jesuu ña chāchi, u'un mii ta'an ndra'ii kùu ndra, ta siin kùu ma ñivi ña'a chi'in ndiakuati ndia. ");
INSERT INTO mza_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ta ora yā'a ña kūu te'en, tajan Jesuu tāchi ra ma ndra jàkua'a chi'in ra ña na ndaa ndra tichi ma lancha, ikan na ji'na ndra ketachiyo ma inga chiyo yu'u lakuna, juuni yanga ndoo ra jànduta ra ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ta ora cha ndī'i ndio ma ñivi ndūta, tajan ndāa ma'iin Jesuu kuàka'an ra chi'in Ndioo iin yuku. Ta ikan ìyo ma'iin ra ma ora kuaa. ");
INSERT INTO mza_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ta ma lancha nuu kàcha'an ndra, cha kēta run java ma lakuna, va endee jàkisi ma lakuna run, ti iti' nuu run vàchi ma tati. ");
INSERT INTO mza_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Takan kūu ta ora juuni naa ga antea ña kundichin, kēe ndio Jesuu chìka ra nuu takuii kuà'an ra chata ndra. ");
INSERT INTO mza_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ta ora ndē'e ma ndra jàkua'a chi'in ra ña chìka ra vàchi ra nuu takuii, iin kuvaani ndra, ta yū'vi ndra, ta te'en nāka'an ndra: ―¡Ni'na kùu ma ñá' vàchi! ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Va Jesuu te'en nāka'an ra chi'in ndra: ―¡Na yü'vi ndo ta taxiin kuii ndo!, ti mai kùi ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tajan ma Petu' te'en nāka'an ra chi'in Jesuu: ―Yo'o Racha'nu, tu ndicha ña maun kùu̱n, na ja'un ña na kakai ku'in nuu takuii, nda kati chai nuu ndaun ―kàti Petu' chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tajan Jesuu te'en nāka'an ra: ―Na'a vii ―kàti Jesuu chi'in ra. Tajan nūu ndio ma Petu' tichi lancha, ta kīcha'a ndio ra chìka ra nuu takuii kuà'an ra nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Va ora chā'a ma Petu' kuenda ña nduva'a ni'i chàkin ma tati, yū'vi ndio ra, ta kīcha'a ra sà'vi ra tichi ra'. Tajan te'en nānda'yu ndio ra: ―¡Yo'o Racha'nu, na jakakun yu'u! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tajan ma ora ikani, Jesuu tīin ra nda'a ma Petu', ta te'en nāka'an ra chi'in ra: ―¡Yo'o, ra ya'a ga tia chìnuni! Ta, ¿naja töve chìnuni va'un? ―kàti Jesuu chi'in Petu'. ");
INSERT INTO mza_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ta ora ndāa ndio ndra ma tichi lancha, ta kūtaxin ndio ma tati ña chàkin yi. ");
INSERT INTO mza_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tajan ma ndra ka'ìin tichi lancha, chūnandi chiti ndra nuu Jesuu, ta te'en nāka'an ndra chi'in ra: ―¡Ndicha kuii ña yo'o kùu ma ra Se'e Ndioo! ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Takan kūu tajan kētachiyo ndio ndra ma lakuna ikan, ta chāa ndra ma ñu'u' Genesaret. ");
INSERT INTO mza_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ta ora chā'a ndio ma ñivi ìyo ikan kuenda ña Jesuu kùu ra, numi kuiini chātakuati na ma tu'un ninii ka'nu ma ñu'u' ikan. Tajan ndà'a ndio na ndisaa ma ndian ku'vi, chàa na nuu ndaa ra. ");
INSERT INTO mza_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ta kīcha'a ndio na jànini na ra, ña na ku'va ra kè'e ma ndian ku'vi jitu ma ja'ma ra. Ta takan kūu yi ña ndisaa ma ndian kē'e ja'ma Jesuu ndā'a na. ");
INSERT INTO mza_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Takan kūu tajan iin ma ndra fariseu, chi'in ndra matru ña jàkua'a tutu Ndioo ña kākichi iti' ñuu Jerusalén, chàjayatin ndra ndra nuu ndaa Jesuu, ta te'en chīkatu'un ndra nuu ra: ");
INSERT INTO mza_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Ta naja töve jàchi'in ma ndra jàkua'a chi'un, ma costumbre jā'a ma ñivio, ndian chīyo taji'na, ña töve nàkata ndra nda'a' ndra antea ña kàchi ndra tava kùu yi? ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Va Jesuu te'en chīkatu'un ra nuu ndra: ―¿Ta naja maa ndo töve kùuni ndo jachi'in ndo ña kà'an ma Racha'nu Ndioo, ña java ma costumbre maa ndo jà'a ndo? ");
INSERT INTO mza_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Vati ma Racha'nu Ndioo te'en kā'an ra: “Na tiñu'u̱n ma tatáun, chi'in ma'un.” “Ta ma ra kànduva'a ma tatá ra, chi'in ma'á ra, ìyo yi ña tiso yo kuati ra, ikan na kuvi ra cha'a' ña kà'an ra takan,” kàti yi. ");
INSERT INTO mza_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Va ndyo'o chànini ndo ña iin ra'ii kùu ka'an ra chi'in tatá ra, a chi'in ma'á ra te'en: “Na küu ga tìndei ñu̱n, ti cha tāva sii̱n ndisaa ndatiñu ìyo nui ña ni sokói yi nuu Ndioo”, ni kati ndo chi'in tatá ndo a ma'á ndo. ");
INSERT INTO mza_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nda ndyo'o nikuuni ña ni ka'an ndo takan, ta na töve tìndee ndo tatá ndo a ma'á ndo chi'in ndatiñu ndo, kùuni yi ka'an yi ña na tüva kuuni ndo tiñu'u ndo ma tatá ndo a ma'á ndo. Ta takan kùu yi ña jàchiyo ndo ña kà'an Ndioo, ta jà'a ndo ma costumbre maa ndo, tuva takan jà'a ndo. ");
INSERT INTO mza_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ndyo'o ndian kini! Ma ra kā'an chi'in tu'un yu'u Ndioo ña nàni Isaía, ña ndicha kùu ma tu'un kā'an ra kuenda ndo ora kā'an ra te'en: ");
INSERT INTO mza_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ma ñivi ñuu i'ya, tìñu'u na yu'u chi'in tu'un ña kà'an ni na, ti ma ña ndicha, kùu yi ña na töve tìñu'u na yu'u chi'in anima na. ");
INSERT INTO mza_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na töve ndakuenda kùu yi ña kùti'vi na kuenda jàka'nu na yu'u, tuva ma tu'un jàna'a na kùu mamaa tu'un ña kèta yi chinituni ñivini ña ka'nda yi tiñu nuu na kàti yi. ");
INSERT INTO mza_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Takan kūu tajan kāna ndio Jesuu ma ñivi ikan, ta te'en nāka'an ra chi'in na: ―Kùuni̱ ña na taso'o va'a ndo, ta kùtunini ndo ma ña ni ka'in chi'in ndo: ");
INSERT INTO mza_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na yöve ña chàchi ma ñivi kùu ma ña jàndokini anima na, vati ma ña jàndokini na kùu ma tu'un ña kèe yu'u na ora kà'an na, yakan kùu ma ña jàndokini na. ―Takan kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Takan kūu tajan chājayatin ma ndra jàkua'a chi'in Jesuu ndra nuu ndaa ra, ta te'en nāka'an ndra chi'in ra: ―¿A chā'un kuenda ña ora chīni ma ndra fariseu ña kā'un takan, tükuii nī chata'ani ndra? ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Va Jesuu te'en nāka'an ra chi'in ndra: ―Nda yutun nikuuni ña töve nī tachi ma Tatái ra ìyo andivi, ni tu'un ra ndrun nda yo'ó ndrun kèe ndrun. ");
INSERT INTO mza_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Na jächi'in ndo ña kà'an ndra, ti kùu ndra, ndra kuaá ña jàna'a iti' ku'un inga ndian kuaá. Tatu iin ra kuaá jàna'a ra iti' ku'un inga ra kuaá, ninduvi ndra ni koyo ndra tichi iin yavi kunu. ―Takan kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tajan Petu' te'en nāka'an ra chi'in Jesuu: ―Kùuni̱ ña na katitu'un kachiun nuu ndi nayi kùuni ma ku'va i'ya ka'an yi ―kàti Petu'. ");
INSERT INTO mza_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ta Jesuu te'en nāka'an ra: ―¿A nda maa ndo töve kùtunini ndo ma ña kà'in ndia? ");
INSERT INTO mza_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A tüvi chìto ndo ña tandi'i ña kì'vi tichi yu'u ñivi, ta chàchi na, chàa yi tichi chití na, ta ikan jan tàva ndio na yi ora kuàkati na? ");
INSERT INTO mza_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Va ma tu'un ña kèe yu'u na, ti vàchi yi nda ma tichi anima na, ña'a kùu ma ña jandakuu kini ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vati ma tichi anima na kèe ma ña töve va'a chànini na, tajan chà'ni ndio na ñivi, ta ma ndra'ii kì'vi ndra chi'in ñivi ña'a ña takä'an tànda'a. Ta juuni chi'in ma ña kini ña kèe tichi anima ndra, kì'vi ndra chi'in ñivi ña'a cha ìyo ii, ta ñivi ña'a chi'in ra'ii cha ìyo ñasi'i ndia. Ta sù'u ndio na, ta kà'an na tu'un vata ta kàti'ini na chata ta'an na ndia. ");
INSERT INTO mza_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tandi'i ña'a kùu ma ña jàndokini ma ñivi. Va taku cha'a' ña töve nàkata na nda'a' na ora chàchi na, yakan töve jàndokini yi na. ");
INSERT INTO mza_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Takan kūu tajan kēe ndio Jesuu ma ikan, ta kuà'an ra iti' ñuu Tiro, ta ñuu Sidón. ");
INSERT INTO mza_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tajan iin ña kīchi ñuu Caná ña ìyo ma ñuu nuu chāa Jesuu, chājayatian ña nuu ndaa ra, ta te'en nāka'an ni'an nuu ra: ―¡Yo'o Racha'nu, ra se'e David, na kunda'viniun yu'u! Ti ma ña se'i ya'a ndè'an tundo'o jà'a iin tati xaan ña indii tichi kuñuan, ―kàtian chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Va Jesuu töve nī ka'an ra ña kà'an ña. Tajan ma ndra jàkua'a chi'in ra chātu'va ndra nuu ra, ta te'en nāka'an ndra chi'in ra ña jànini ndra ra: ―Na ka'un chi'in ma ña'a ikan, ña na ku'an, ti ya'a ni'i nda'yuan vàchian chata ndi, ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tajan Jesuu te'en nāka'an ra chi'in ndra ña jàkuuni ra kà'an ra ña: ―¿A yöve ndicha ña Ndioo tāchi ra yu'u kuenda ña na tindei uvanuu ma ñivi ìyo ñuu Israel ña kùu na tava kùu ma mvechala kuànaa?, kùuni ndo, ―kàti ra chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Va ma ña'a ikan chājatu'va ña ña nuu Jesuu, ta chūnandi chitian nuu ra, ta te'en nāka'an ña chi'in ra: ―¡Yo'o Racha'nu, tindee yu'u! ―kàtian. ");
INSERT INTO mza_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ta Jesuu te'en nāka'an ra chi'an: ―Na töve va'a namaa yo ma ña chàchi se'o nuu na, ta ku'va yo yi nuu ina ―kàti Jesuu chi'an. ");
INSERT INTO mza_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ta yakan, te'en nāka'an ña chi'in ra: ―Ndicha ma ña kà'un yo'o Racha'nu, va nda ma ina chàchi ndri ma che'e yu'u chito'o ndri ña chìtá xuu mesa ―kàtian chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tajan Jesuu te'en nāka'an ra chi'an: ―¡Yo'o se'yu! ¡Ya'a ga ka'nu kùu ma ña chìnuniun! Na kuu yi ma takua kùuniun ―kàti Jesuu chi'an. Tajan juuni ma ora ikani ndā'a ma ña se'an ña ndiso tati xaan. ");
INSERT INTO mza_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Takan kūu tajan kēe ndio Jesuu ma ikan, ta kuà'an ra yatini yu'u lakuna ña kàndii ñu'u' Galilea. Ta ora chāa ra ma ikan, tajan ndāa ndio ra iin xini yuku, ta ikan chūnandi ra. ");
INSERT INTO mza_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta nduva'a kua'a' ñivi kūti'vi nuu ra. Chākoyo ma ndian ndàka ndian koxo, chi'in ndian ndàka ndian kuaá, ta ndian ndàka ndian ñi'i, chi'in ndian kukue'e iin chiyo nda'a' a cha'a, ta inga kua'a' ndian ku'vi ndia. Ta kānindoyo na na cha'a Jesuu, ta jānda'a ra na. ");
INSERT INTO mza_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Takan kūu yi ña ndava kuà'an mania anima ma ñivi ña ndè'e na ña, kà'an ndio ma ndian ñi'i. Ta ndian kukue'e iin chiyo nda'a' a cha'a', ndā'a yi. Ta ndian chìka koxo, cha kùu chika va'a na. Ta ndian kuaá, cha kùu ndè'e na ndia. Takan kūu, tajan kīcha'a ndio na jàka'nu na ma Ndioo, ra chito'o ndian ñuu Israel. ");
INSERT INTO mza_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tajan Jesuu kāna ndio ra ma ndra jàkua'a chi'in ra, ta te'en nāka'an ra chi'in ndra: ―Ya'a nda'vi kùuni̱ nde'i ma ñivi i'ya, ti cha kēta uni kivi kùu yi ña ìyo na chi'i̱n, ta vitin tüva ña kachi na. Ta töve kùuni̱ tachi̱ na ña na ku'un na ve'e na, koto juuni kàani kunaa na ma tichi iti' kuà'an na jà'a ma soko, ti takä'an kachi na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tajan ma ndra jàkua'a chi'in ra, te'en nāka'an ndra chi'in ra: ―Va, ¿naja kua jà'a yo, ta kùu ni'i yo ña kachi na i'ya, ña kua nduva'a kua'a' na, ta iin nuu töve ìyo nï'iin ñivi kùu yi? ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ta Jesuu te'en chīkatu'un ra nuu ndra: ―¿Naja ta'an paan ìyo nuu ndo? ―kàti Jesuu chi'in ndra. Ta ndrakan te'en nāka'an ndra: ―Ucha ta'an yi, ta ita'vi tiaka' ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tajan tāchi ndio Jesuu ña na kunandi na nuñu'u'. ");
INSERT INTO mza_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta tīin ndio ra ndi ucha ta'an ma paan, chi'in ma tiaka', ta chā'a ra ta'vindioo nuu ma Racha'nu Ndioo cha'a' yi, ta chā'nda kuati ndio ra yi, tajan chā'a ra yi nuu ma ndra jàkua'a chi'in ra, ta ndrakan nāta'vi ndra yi nuu tandi'i ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Takan kūu yi ña ndisaa ma ñivi chāchi na, nda kati nda'a va'ani na. Ta ndava jākutuga na ucha ta'an tuka, chi'in ma pedazu ña chākoso. ");
INSERT INTO mza_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ta kumi mii ndra'ii kùu ma ndra chāchi, ta siin kùu ñivi ña'a chi'in ndiakuati ndia. ");
INSERT INTO mza_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ta ora yā'a ña jā'a Jesuu takan, tajan kà'an ndio ra chi'in na ña na ku'un na ve'e na, tajan ndāa ndio ra ma tichi lancha, ta kuà'an ra iti' ñu'u' ñuu nàni Magdala. ");
INSERT INTO mza_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Takan kūu tajan ma ndra fariseu, chi'in ndra saduceu chā'an ndra chānde'e ndra nuu ndaa Jesuu. Ta tava kùuni ndra ki'in ndra ku'va Jesuu, nde'o naja kua ka'an ra, kùuni ndra. Yakan va chīkan ndra nuu ra ña na ja'a ra iin ndatu ka'nu nuu ndra ma iti' andivi, ikan na kuu koto kachin ndra tuva ndicha ña tāchi Ndioo ra. ");
INSERT INTO mza_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Va Jesuu te'en nāka'an ra chi'in ndra: ―Ma ora chani'ini, kàti ndo ña: “Va'a tiempu ni ja'a yi vitin, ti ma andivi kua'á yi”, kàti ndo. ");
INSERT INTO mza_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta ma ora na'ani, kàti ndo ña: “Vitin tüvi va'a tiempu ni ja'a yi, ti ma andivi kua'á yi, ta ka'ìin vikó ndia”, kàti ndo. ¡Ndyo'o ndian kini! Ndyo'o chìto ndo naja kua kùu ma tiempu ma iti' andivi, va töve chìto ndo naja kua kùuni ma ku'va ma tiempu i'ya ka'an yi. ");
INSERT INTO mza_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ma ñivi kini, ña töve chìnuni tu'un va'a ña ìyo tiempu vitin, kùuni na ña na ja'i iin ndatu ka'nu nde'e na, va töve ni ja'i yi takua kùuni na. Uvanuu ndatu ni ja'i kùu ña takua tā'an Jonás niku ―kàti Jesuu chi'in ndra. Tajan ndākoo ndio ra ndra, ta kēe ra kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Takan kūu ta ora cha kētachiyo ma ndra jàkua'a chi'in Jesuu inga chiyo yu'u lakuna, ta nāani ndra kùnda'a ndra paan. ");
INSERT INTO mza_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Kuuni̱, ña na ja'a ndo kuenda nuu ndo, chi'in ma yuchan iya ma ndra fariseu, chi'in ma yuchan iya ña jà'a ma ndian saduceu ndia ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tajan ma ndra jàkua'a chi'in Jesuu te'en kīcha'a ndra chìkatu'un ta'an ndra: ―¿A yöve cha'a' ña töve nda'a yo paan kùu yi, yakan va kà'an ra takan? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ta Jesuu chā'a ra kuenda cha'a' ma ña nàtu'un ndra, ta te'en nāka'an ra chi'in ndra: ―¿Ta naja kà'an ndo ña töve nda'a ndo paan? ¿A takä'an chinuni va'ani ndo ña kà'an ndo takan? ");
INSERT INTO mza_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A juuni takä'an kutunini ndo, ta ni töve chàku'uni ndo, ora nāta'vi̱ u'un ta'an paan kuenda u'un mii ñivi? ¿Naja ta'an tuka yi chākoso chi'in ma ña jāti'vi ndo? ");
INSERT INTO mza_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿A ni töve chàku'uni ndo ora nāta'vi̱ ucha ta'an paan kuenda kumi mii ñivi? ¿Naja ta'an tuka yi chākoso chi'in ma ña jāti'vi ndo? ");
INSERT INTO mza_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","’¿Chïto naja töve nī cha'a ndo kuenda ña ora kā'in na ja'a ndo kuenda nuu ndo, chi'in ma yuchan iya ma ndra fariseu, chi'in ña jà'a ma ndra saduceu, töve nī ka'in yi cha'a' ma paan ndicha ma ora kā'in takan? ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Takan kūu tajan chā'a ndio ma ndra jàkua'a chi'in Jesuu kuenda ña, töve nī ka'an ra ña na jà'a ndra kuenda nuu ndra chi'in ma yuchan iya ña kùva'a ma paan ndicha, vati ma ña kūuni ra katitu'un ra nuu ndra, kùu yi ña, na ja'a ndra kuenda nuu ndra chi'in ma tu'un jàna'a ma ndra fariseu, ta chi'in tu'un jàna'a ma ndra saduceu ndia. ");
INSERT INTO mza_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ta ora chāa Jesuu ma ñuu Cesarea ña ìyo kuenda ma ñu'u' Filipu. Ta te'en chīkatu'un ra nuu ma ndra jàkua'a chi'in ra: ―¿Nda ra kùu yu'u, ra kùu Se'e ñivi, kàti ma ñivi, kùuni ndo? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta ndrakan te'en nāka'an ndra: ―Ìyo ñivi kà'an ña kùu̱n Xuva ra jàkunduta, ta ìyo ndian kà'an ña kùu̱n Elía, ra kā'an chi'in tu'un yu'u Ndioo niku. Ta ìyo inga tuku na ña kà'an na ña kùu̱n Jeremía, a inga tuku ma ra kà'an chi'in tu'un yu'u Ndioo ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tajan Jesuu te'en nāka'an tuku ra chi'in ndra: ―Ta ndyo'o, ¿nda ra kà'an ndo ña kùi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tajan Simón Petu' te'en nāka'an ra chi'in Jesuu: ―Yo'o kùu̱n Cristu, ra Se'e Ndioo ndito ―kàti Petu' chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ta Jesuu te'en nāka'an ra chi'in ra: ―Na sii kuuniun yo'o Simón, ra se'e Jonás, vati nï'iin ñivi töve nī jana'a ma tu'un i'ya nuu̱n, ti ma ra jāna'a yi nuu̱n kùu ma Tatái, ra ìyo andivi. ");
INSERT INTO mza_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yu'u kà'in chi'un ña yo'o nàniun Petu', ta chata ma yuu ka'nu i'ya, ni java'i ma veñu'i, ña ni ma kui'na, na küu janduva ra yi chi'in ma ndatu ra. ");
INSERT INTO mza_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ta nuu yo'o ni ku'vai ma ndatiku nuu chà'ndai tiñu ma andivi. Ta ma ña ni kasiun ma nuñu'u' ñuñivi i'ya, nda ma andivi ni ndasi yi ndia. Ta ma ña ni nunaun ma nuñu'u' ñuñivi i'ya, nda ma andivi ni nuna yi ndia. ―Takan kāti Jesuu chi'in Petu'. ");
INSERT INTO mza_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Takan kūu tajan Jesuu kā'an ndio ra chi'in ma ndra jàkua'a chi'in ra ña koto käti ndra nuu nï'iin ñivi, ña Cristu kùu ra. ");
INSERT INTO mza_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tajan nda ma ora ikan kùu yi ña kīcha'a ndio Jesuu kàtitu'un ra nuu ma ndra jàkua'a chi'in ra ña ìyo yi ña ku'un ra ma ñuu Jerusalén, ti ikan kùu ma nuu nduva'a ni jande'e ma ndracha'nu tundo'o ra, chi'in ma ndra kuxini nuu sutu, ta chi'in ma ndra matru ña jàkua'a ma tutu ley Ndioo ndia. Ta juuni kātitu'un ra nuu ndra ña ni ka'ni ndra ra, va tichi uni kivi, ni nataku ra. ");
INSERT INTO mza_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tajan ma Petu', tāvani'i siin Jesuu, ta te'en nāka'an ra chi'in ra: ―Ndioo ni tindee ñu̱n, ikan töve nayi ta'un, yo'o Racha'nu. ¡Na töve ìyo yi ña ta'un takan ndia! ―kàti Petu' chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Va Jesuu chīkoni'i ra ndē'e ra nuu Petu', ta te'en nāka'an ra chi'in ra: ―¡Kundachiyo xii̱n kui'na!, ti tava jàtañuniun nui. Vati yo'o chàniniun tava chànini ñivi ìyo ñuñivi, ta töve chàniniun tava chànini Ndioo ―kàti Jesuu chi'in Petu'. ");
INSERT INTO mza_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tajan te'en nāka'an tuku Jesuu chi'in ma ndra jàkua'a chi'in ra: ―Tu ìyo nda yo kùuni jakua'a chi'i̱n, ìyo yi ña jaña na ña nakanini na cha'a ma ña kùuni na ja'a na, ta na ki'in na kruu na, ta tandikun na chatai. ");
INSERT INTO mza_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Vati ma ndian ni kuuni jakakú ma'iin na na, ni kuvi na. Va ma ndian ni kuvi cha'a' ña chìnuni na tu'in, ndiakan ni kakú na. ");
INSERT INTO mza_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Nda kuenda kùu yi tuva kùu ni'i yo tandi'i ma ña chiniñu'u yo ña ìyo ma ñuñivi, tu töve ni ni'i yo nuu ni koo yo indeeni chi'in Ndioo? Ta, ¿a kùu jata yo ma kivi koo yo ma ñuñivi i'ya?, kùuni ndo. ¡Na küu yi! ");
INSERT INTO mza_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Vati ma ra Se'e ñivi tāchi Ndioo ni kichi ra chi'in ña tàcha ma Tatá ra, ta chi'in ma tati ña jà'a tiñu nuu ra ndia, tajan ni ku'va ndio ra ya'vi nuu ta'ii'iin ndo cha'a' naja ma kua jā'a ndo. ");
INSERT INTO mza_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ndicha va'a, ña kà'in chi'in ndo, ña uvi uni ndyo'o ña ka'ìin i'ya, na töve ni kuvi ndo, nda kati nde'e ji'na ndo ora ni kichaa yu'u ma ra Se'e ñivi tāchi Ndioo, ta ka'nda ra tiñu ma nuñu'u' i'ya ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Takan kūu ta ora yā'a iñu kivi, tajan Jesuu tāvani'i siin ra ma Petu', Xuva, ta Jandiau, ra yani ma Xuva, ta kuà'an ndio ra chi'in ndra iin xini yuku nduva'a sukun. ");
INSERT INTO mza_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ta ma nuu ndè'e ndra ka'ìin ndra, ikan sāma ma kua kàa Jesuu. Ma nuu ra ndākuu tacha yi, tava kàa ma nikandii, ta ma ja'ma ñù'u ra, ndākuu kuichin ga yi tava kàa ma ñu'ú. ");
INSERT INTO mza_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ta nunuuni, ta ndē'e ndra Moisés, ta Elía, ña nàtu'un ta'an ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tajan Petu' te'en nāka'an ra chi'in Jesuu: ―Matru, ¡ya'a va'a ña ka'ìin yo i'ya! Na kuja'a ndi uni ta'an lomara kuenda ndo: iin yi kùu kuendaun, ta iin yi kuenda Moisés, ta inga yi kuenda Elía ―kàti Petu' chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ta ora juuni yanga ndaa ma Petu' kà'an ra, tajan nūu ndio iin vikonu'u tacha, ta chīkonuu yi ndra, ta tañu ma vikó ikan, chīni ndra iin tati ña te'en kà'an: ―Ra'ya kùu ma Se'i, ra ya'a kùuni̱ nde'i, ta ya'a ga chìsii̱ chi'in ra. ¡Na kuni ndo ma ña kà'an ra! ―kàti Ndioo chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ta ora chīni ma ndra jàkua'a chi'in Jesuu tu'un i'ya, ta chūnandi chiti ndra ndava nàni te'e nuu ndra nuu ñu'u', ña nduva'a kuii yū'vi ndra. ");
INSERT INTO mza_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tajan Jesuu chātu'va ra ma nuu ka'ìin chiti ndra, ta jānani nda'a' ra ndra, ta te'en nāka'an ra chi'in ndra: ―Na yü'vi ndo, na kandeta ndo, ti mai kùi ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ta ora kāndeta ndio ndra, ta kāni'i ndra nuu ndra, ta tüva yo ni nde'e ndra, vati maania ma Jesuu kùu ra ña ndaa ra. ");
INSERT INTO mza_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ta ora kuànuu ndio ndra ma yuku, ta Jesuu te'en nāka'an ndio ra chi'in ndra: ―Koto nätu'un ndo ma ña ndē'e ndo i'ya nuu nï'iin ñivi, nda kati nataku ji'nai yu'u ma ra Se'e ñivi tāchi Ndioo, tañu ndian ndií. ");
INSERT INTO mza_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tajan ma ndra jàkua'a chi'in Jesuu, te'en chīkatu'un ndra nuu ra: ―¿Ta naja kàti ma ndra matru jàkua'a tutu ley Ndioo, ña ji'na Elía, ni kichi? ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Ndicha, ña ji'na Elía kùu ma ra ni kichi, ti ni jandova'a ra ndisaa nakuyi. ");
INSERT INTO mza_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Va yu'u, kà'in chi'in ndo, ña Elía cha kīchi ra, va ma ñivi töve nī nakoto na ra, ta jā'a na chi'in ra tandi'i ma naja kua kūuni maa na. Ta juuni takan ni jande'e na tundo'o ma ra Se'e ñivi tāchi Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Takan kūu tajan chā'a ndio ma ndra jàkua'a chi'in ra kuenda, ña cha'a' Xuva ra jàkunduta kùu ma ña kà'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ta ora chāa ndio Jesuu chi'in ndra jàkua'a chi'in ra nuu ka'ìin ma ñivi, ta chājayatin iin ra ra ma nuu Jesuu, ta chūnandi chiti ra nuu ra, ta nāka'an ra chi'in ra: ");
INSERT INTO mza_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Yo'o Racha'nu, na kunda'viniun ma rayoko se'i, vati rakan ndiso ra kue'e chì'i i'i, ta nduva'a ndè'e ra tundo'o jà'a yi. Ta cha chinu kua'a' cha'a' ndùva ra nuu ñu'ú, a tichi takuii, jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","I'ya ndàkai ra kīchai nuu ma ndra jàkua'a chi'un, va ndrakan, nī kuu janda'a ndra ra ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ta Jesuu te'en nāka'an ra: ―¡Ndyo'o ñivi töve chìnuni, ta kini xini! ¿Naja ga tiempu ìyo yi ña koi chi'in ndo? Ta, ¿naja ga tiempu ìyo yi ña jandeeni̱ ndo tiá ña töve chìnuni ndo? Na kichi ndaka ndo ma ra tivaa nui ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tajan kā'an xaan ndio Jesuu nuu ma tati xaan, ta kēe ndio yi tichi kuñu ma rayoko ikan, ta juuni ma ora ikani ndā'a ra. ");
INSERT INTO mza_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ta ora cha yā'a ndio, tajan chājayatin ma ndra jàkua'a chi'in Jesuu ndra nuu ra, ta te'en chīkatu'un siin ndra nuu ra: ―¿Ta naja ndyu'u, nī kuu tavani'i ndi ma tati xaan kuñu ra? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Vati ndyo'o na töve chìnuni va'a ndo. Ndicha va'a ña ka'ìin chi'in ndo, ti tu chìnuni ndo, jitu ita'vini, takua vali iin chiti yukú ña nàni mostaza, kùu ka'an ndo, te'en chi'in ma yuku ka'nu i'ya: “Na kundachiyoun i'ya, ta ku'u̱n inga chiyo.” Ma yuku ni kundachiyo yi. Nï'iin nakuyi töve ndetiñu tu ndicha ña chìnuni va'a ndo ma tu'un Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Va taku ma tati xaan te'en, na küu kèe yi jà'a ndo tu töve ka'an ji'na ndo chi'in Ndioo, ta jandita ndo yu'u ndo. ");
INSERT INTO mza_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ta ora juuni chàkunuu ga Jesuu ma ñu'u' Galilea, chi'in ma ndra jàkua'a chi'in ra, ta nāka'an tuku ra chi'in ndra, ña ma ra Se'e ñivi tāchi Ndioo, ni tiin na ra, ta ni ku'va na ra nda'a inga ñivi ña na jande'e na tundo'o ra. ");
INSERT INTO mza_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta ni ka'ni na ra ndia, va tichi uni kivi, ni nataku ndiko ra. Ma tu'un kā'an ra i'ya, nduva'a nda'vi kūuni ndra jā'a yi. ");
INSERT INTO mza_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Takan kūu ta ora chāa Jesuu chi'in ndra jàkua'a chi'in ra ma ñuu Capernaum, tajan ma ndra nàka'an xu'un' kuenda ma veñu'u ka'nu chānde'e ndra nuu ndaa Petu', ta te'en chīkatu'un ndra nuu ra: ―¿A töve tìa'vi ma matru ndo ma xu'un' ña nàka'an ndian jàtiñu nuu ma veñu'u ka'nu i'ya? ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ta ma Petu' te'en nāka'an ra: ―Tìa'vi ra ―kàti ra. Tajan ora kī'vi ma Petu' tichi ve'e nuu ndaa Jesuu, ta ji'na ma Jesuu te'en nāka'an ra chi'in Petu': ―¿Yo'o Simón, naja kua chàniniun? ¿Yo nuu nàka'an ma ndra kùu rey ña chà'nda tiñu ma ñuñivi i'ya ma xu'un'?, kùuniun: ¿A nuu ma ndian kùu ñivi ndra, a nuu ma ndian kìchi inga ñuu?, kùuniun ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ta Petu', te'en nāka'an ra chi'in ra: ―Nuu ma ndian vàchi inga ñuu ―kàti Petu'. Ta Jesuu te'en nāka'an ra chi'in ra: ―Takan kùu yi ña ma ndian ìyo ñuu i'ya, töve ìyo yi ña tia'vi na. ");
INSERT INTO mza_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Va tava töve kùuni̱ ña ka'an nï'iin ñivi chatai, na ku'u̱n kujakanaun chi'in ma yo'o jàkanaa nuu kàndii ma lakuna, ta ora kàniun yi, ma tiaka' nunuu ña tiin yi, ta tavani'un ri, ta ndikaun ma tichi yu'u ri, ta ikan nata'un iin xu'un'. Ta chi'in ma xu'un' ikan kùu ja'a yi ña tia'viun kuendai, ta tia'viun kuendaun. Na kunda'un yi, ta tia'viun nuu ndra ―kàti Jesuu chi'in Petu'. ");
INSERT INTO mza_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ma tiempu ikan ma ndra jàkua'a chi'in Jesuu chājatu'va ndra ndra nuu ra, ta te'en chīkatu'un ndra nuu ra: ―¿Nda ra kùu ma ra ka'nu ga ma nuu chà'nda Ndioo tiñu andivi? ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tajan Jesuu kāna ra iin ravali, ta kūtaa ra ra ma'ñu ndra, ");
INSERT INTO mza_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ta te'en nāka'an ra: ―Ndicha va'i ña kà'in chi'in ndo, ña tu töve sama ndo ma kua chànini ndo, ta kùu ndo takua kùu ma ndiakuati, na töve kùu ki'vi ndo ma nuu chà'nda Ndioo tiñu andivi. ");
INSERT INTO mza_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ta takan kùu yi ña ma ra masu anima takua kùu ma ravali i'ya, ta jà'a na takua jà'a ra, rakan kùu ma ra ka'nu ga ma nuu chà'nda Ndioo tiñu andivi. ");
INSERT INTO mza_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ta nda yo ndàkimani ma ravali i'ya chi'in sivi̱, juuni ndakimani na yu'u ndia. ―Takan kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","―Nda ndian nikuuni ña tìyu'u iin ndiakuati te'en, ña chìnuni tu'in, ña na ja'a na kuati, ta jà'a na yi. Va'a ga ña na ku'ni ndo iin yuu yoso ka'nu sukun, ta kujakoyo ndo na tichi tañu'u nuu kunu. ");
INSERT INTO mza_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ya'a ga kini kùu yi kuenda ma ñivi ìyo ñuñivi, ña ìyo ndian tìyu'u inga ñivi, ikan na ja'a na kuati! Yakan ninii ni koo yi, va ¡nda'vi ta'an ma ndian tìyu'u ma inga ñivi ña na ja'a na kuati! ");
INSERT INTO mza_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Yakan va tu ma nda'a' ndo a cha'a ndo, jà'a yi ña na ja'a ndo iin kuati, na ka'nda ndo yi, ta jakuita chika ndo yi, vati va'aga ña ki'vi ndo nuu ni koo ndo endeeni chi'in Ndioo, chi'in iin chiyo nda'a' ndo a cha'a ndo, kua ña chi'in ninduvi yi ni ni'i ndo nuu ni ku'un ndo andaya' jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tatu ma tinuu ndo jà'a yi ña na ja'a ndo iin kuati, na tava ndo yi, ta jakuita chika ndo yi, vati va'aga ña kì'vi ndo nuu ni koo ndo endeeni chi'in Ndioo, chi'in iin chiyo tinuu ndo, kua ña chi'in ninduvi yi ni ni'i ndo nuu ni ku'un ndo andaya' jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Na kuuni ndo nde'e ndo ndisaa ma ndiakuati i'ya. Vati yu'u kà'in chi'in ndo ña ma tati va'a Ndioo ña jakuenda na, endee ìyo na kùmi na na ma nuu ìyo ma Tatái andivi. ");
INSERT INTO mza_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Vati ma ra Se'e ñivi tāchi Ndioo, vàchi ra kuenda ña jakakú ra ma ndian kuànaa ña jà'a kuati. ");
INSERT INTO mza_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Ta ndyo'o, ¿naja kua ndè'e ndo yi? Tu iin ra'ii ìyo iin cientu mvechala jàna ra, ta jàkunaa ra iin ri ma nuu chàkunuu ra jakuenda ra ndri, ¿a töve ni ndakoo nuu ra ma kumi xiko cha'un kumi ndri ma tichi ku'u nuu jàkuenda ra ndri, ta kunanduku ra ma mvechala ña kuànaa?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tatu nàta'an ra ri, yu'u chànini̱ ña tiaga sii ni kuuni ra cha'a' ma kiti ña kuànaa ta nāta'an ndiko ra ri, ña kua cha'a' ma ndi kumi xiko cha'un kumi ma kiti töve chànaa. ");
INSERT INTO mza_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Juuni takan kùuni ma Racha'nu Tatá ndo, ra ìyo andivi, ña na künaa nï'iin ma ndiakuati i'ya jà'a ma kuati. ");
INSERT INTO mza_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tu ma ra yaniun ja'a ra iin kuati chi'un, na kanaun ra, ta natu'un ma'iiun chi'in ra, ta ikan katitu'u̱n nuu ra nayi kùu ma kuati ña jà'a ra. Tatu jachi'in ra ma ña kà'un, cha kūndeun jakanaun ra. ");
INSERT INTO mza_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tatu töve jàchi'in ra ma ña kà'un, na kanaun uvi a uni ñiviun, ikan na koto na nda cha'a' kùu ma ña kà'un nuu ra, ta kùu na testigu, ta kā'an na nuu ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tatu indukuni töve jàchi'in ra ña kà'an ma ñivi ikan, na katitu'u̱n yi nuu ka'ìin ti'vi ma ñivi Ndioo. Tatu töve jàchi'in ra, ni ña kà'an ma ñivi Ndioo, tajan ìyo yi ña koto yo ña kùu ra iin ra töve chìnuni, a ña kùu ra tava kùu ma ndra nàka'an xu'un' kuenda ma ñuu ka'nu Roma. ");
INSERT INTO mza_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ndicha va'i ña kà'in chi'in ndo, ña ma ña ni kasi ndo ma nuñu'u' ñuñivi i'ya, ni ndasi yi ma andivi ndia. Ta ma ña ni nuna jà'a ndo ma nuñu'u' ñuñivi i'ya, juuni ni nuna yi ma andivi ndia. ");
INSERT INTO mza_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ta juuni kà'in chi'in ndo, ña tu uvi ta'an ndo jàndo'iin tu'un ndo ma nuñu'u' ñuñivi i'ya, kuenda ña ndākan ndo iin nakuyi nuu ma Racha'nu Tatái, ra ìyo andivi, ni ku'va ra yi nuu ndo. ");
INSERT INTO mza_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vati nuu ka'ìin ti'vi uvi a uni ndian jàka'nu yu'u, ikan ìyoi tañu na ndia. ");
INSERT INTO mza_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tajan Petu' chājayatin ra ra nuu Jesuu, ta te'en chīkatu'un ra nuu ra: ―Racha'nu, ¿naja cha'a' ìyo yi ña jaka'nuni̱ ma ra yani̱, tuva jà'a ra kuati chi'i̱n? ¿A nda ucha cha'a'?, kùuniun ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ta Jesuu te'en nāka'an ra chi'in ra: ―Na töve kà'in chi'un ña ucha cha'ani, vati nda ucha cha'a' ma uni xiko uchi kàti̱ chi'un ―kàti Jesuu chi'in Petu'. ");
INSERT INTO mza_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ta ma nuu chà'nda Ndioo tiñu, indukuni kùu yi tava kùu iin ma ra kùu rey ña chà'nda tiñu, ña kūuni ra jà'a ra kuenda, naja tàvi ma ndra musu ra nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Rakan, ti já kīcha'a ra tàva ra kuenda, ora chāa iin ra tàvi kua'a' millon nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ti tava ma ra kùu musu ikan, töve nda chi'in kùu tia'vi ra nuu ra, yakan va ma ra kùu chito'o ra tāchi ra musu ña na kutiin ndra ra, chi'in ñasi'i ra, ndian se'e ra, ta chi'in ndisaa ña ìyo nuu ra, ta kūya'vi ra chi'in vi, ta takan ka'nda ra ma kuenda cha'a ña tàvi ra nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tajan ora chāa ma ra musu, ta chūnandi chiti ra nuu ma chito'o ra, ta te'en nāka'an nda'vi ra nuu ra ña jànini ra ra: “Racha'nu, na kuatun yu'u ita'vi tiá, ta tia'vi ndi'i̱ ma ña tavi̱ nuu̱n”, kàti ra chi'in ma ra kùu chito'o ra. ");
INSERT INTO mza_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ta ma ra kùu chito'o ra kūnda'vini ra ra, ta jāka'nuni ra ma kuenda ña tàvi ra nuu ra, ta jāña ra ra. ");
INSERT INTO mza_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Va juuni ora ña kèe ma ra musu ikan nuke'e, ta nāta'an ra iin ma meru ra, ña juuni kùu musu ña tàvi ita'vi nuu ra, ta kāvanda'a ra sukun ra, ta kīcha'a ra tiin kutu ra yi, ta te'en nāka'an ra chi'in ra: “¡Na tia'viun ma ña tàviun nui!”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tajan ma ra kùu meru ra chūnandi chiti ra nuu ra, ta te'en nāka'an nda'vi ra nuu ra ña jànini ra ra: “Na kuatun yu'u ita'vi tiá, ta tia'vi ndi'i̱ ma ña tavi̱ nuu̱n”, kàti ma ra musu chi'in ma inga ra. ");
INSERT INTO mza_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Va ma ra kùu musu ikan, töve nī küuni ra, vati tī'i ra ra vekaa nda kati ka'nda ra ma kuenda nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ta ora ndē'e inga ma ndra musu ña takan jā'a ra chi'in ra, ta nduva'a nda'vi kūuni ndra. Tajan chā'an ndio ndra chākatitu'un ndra nuu ma ra kùu chito'o ra, ndisaa ma ña ndē'e ndra ña jā'a ra. ");
INSERT INTO mza_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tajan ma chito'o ra, ra kùu rey tāchi ra ña na kuki'in ndra ra, ta ora chāa ra ta te'en nāka'an ra chi'in ra: “¡Yo'o musu kini! Yu'u jāka'nuni̱ ndisaa ma kuenda ña tàviun nui, vati jāniniun yu'u. ");
INSERT INTO mza_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yo'o, indukuni kua ikan ìyo yi ña kunda'viniun ma ra merun, takua jā'i ña kūnda'vini̱ ñu̱n niku.” ");
INSERT INTO mza_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ta takan kùu yi ña ma ra kùu chito'o ra nduva'a kuii kāyuni ra, ña tāchi ra ña na jande'e na tundo'o ma ra kùu musu ikan, nda kati tia'vi ndi'i ra ma ña tàvi ra nuu ra, indukuni takua jā'a ra chi'in ma inga ra. ");
INSERT INTO mza_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ta takan kùu yi, ña juuni kua ikan ni ja'a ma Racha'nu Tatái chi'in ndo, tu töve jaka'nuni ta'ii'iin ndo chi'in ndisaa anima ndo kuati ña jà'a ma ndian ta'an ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Takan kūu ta ora chīnu kā'an Jesuu te'en, tajan kēe ra ma ñu'u' Galilea, ta kuà'an ra iti' ñu'u' Judea ña kàndii inga chiyo ma yuta Jordán. ");
INSERT INTO mza_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ta nduva'a kua'a' ñivi tāndikun chata ra, ta ikan jānda'a ra ma ndian ku'vi. ");
INSERT INTO mza_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tajan iin ma ndra fariseu chājayatin ndra ndra nuu ndaa Jesuu, ta tava kùuni ndra ki'in ndra ku'va ra, ndè'o naja kua kā'an ra, yakan va te'en chīkatu'un ndra nuu ra: ―¿A kùu ndakoo ma ra'ii ñasi'i ra vaji cha'a' iin ña ta'ani? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ta Jesuu te'en nāka'an ra chi'in ndra: ―¿A takä'an jàkua'a ndo ma tutu Ndioo nuu kà'an yi ña ma ra jātuvi ndo ma nuu kīcha'a ñuñivi, “Jā'a ra iin ra'ii, ta iin ña'a”? ");
INSERT INTO mza_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ta juuni kà'an yi te'en ndia: “Cha'a' yakan kùu yi ña ma ra'ii, ni ndakoo ra ma tatá ra, chi'in ma'á ra, ta ndo'iin ra chi'in ñasi'i ra, ta ninduvi vi ni kuu vi tava kùu vi iin ñivini.” ");
INSERT INTO mza_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ta takan kùu yi ña yüva uvi ñivi kùu vi, vati iin ñivinia kùu vi. Yakan va ma ra'ii, na küu ndakoo ra chi'in ma ña cha jāndo'iin Ndioo chi'in ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tajan te'en chīkatu'un tuku ndra nuu ra: ―Tu takan kùu yi, ¿ta naja Moisés chā'a ra ña kùu ndakoo ma ra'ii ñasi'i ra tuva jandova'a ra iin tutu, nuu kà'an yi ña ndàkoo ra ña, ta ndākoo ra ña? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Moisés chā'a ra ña kùu ndakoo ndo ñasi'i ndo, ti ya'a ndava xini ndo, yakan va jā'a ra takan. Va na yöve takan kùu yi niku. ");
INSERT INTO mza_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Va yu'u kà'in chi'in ndo, ña tu nda ndyo'o ndàkoo ndo ñasi'i ndo, ta yöve cha'a' ña kì'vian chi'in inga ra'ii kùu yi, ta ndyo'o tànda'a ndo chi'in inga ña'a, iin kuati kùu yi kuenda Ndioo. Tatu kì'vi ndo chi'in inga ña'a, ña ndākoo ii, iin kuati kùu yi ndia ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tajan ma ndra jàkua'a chi'in Jesuu te'en nāka'an ndra chi'in ra: ―Tu takan kùu yi kuenda ma ndra'ii, chi'in ñasi'i ndra, va'a ga ña na köo ñasi'i ndra, tuva takan ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Na yöve tandi'i ndra'ii kùu kutunini ndra ma tu'un i'ya, vati ma ndra kùu kutunini yi, kùu uvanuu ma ndra chā'a Ndioo chinituni ña, kutunini ndra yi, ndrakani. ");
INSERT INTO mza_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ìyo uvi uni nakuyi jà'a ña na küu tanda'a ma ndra'ii: ìyo ndra'ii ña kāku kukue'e ndra, cha'a' yakan kùu yi ña na küu koo ñasi'i ndra. Ta ìyo ndra ña na küu tànda'a ndra, cha'a' ña cha kūu ndra tatan kuenda ña töve tànda'a ndra. Ta ìyo inga ndra ña na küuni ndra tànda'a ndra, cha'a' ña jàtiñu ndra kuenda Ndioo, ta kùuni ndra chaa ndra nuu chà'nda Ndioo tiñu andivi. Tu ìyo nda ndian va'ani kutunini ma ña kà'in, na jachi'in na yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Takan kūu tajan kīcha'a ndio na chàndaka na iin ndiakuati nuu Jesuu kuenda ña na janani nda'a ra na, ta kā'an ra chi'in Ndioo cha'a' na. Va ma ndra jàkua'a chi'in Jesuu, kīcha'a ndra chàsi ndra nuu ma ñivi, ña na tüva cha'a ndra ku'un na chi'in ma ndiakuati nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Na ku'va ndo na kichi ma ndiakuati nui, ta ña käsi ndo ma iti' vàchi na, vati ma ñivi ìyo nuu chà'nda Ndioo tiñu andivi, indukuni kùu na takua kùu ma ndiakuati ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tajan jōndii ndio ra nda'a' ra xini ma ndiakuati, ta ora chīnu, ta kēe ra kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Takan kūu tajan iin rayoko chānde'e ra Jesuu, ta te'en chīkatu'un ra nuu ra: ―Matru va'a, ¿nda ña kùu ma ña va'a ìyo yi ña ja'i, ta kuu ni'i̱ nuu koi endeeni chi'in Ndioo? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ta Jesuu te'en nāka'an ra chi'in ra: ―¿Ta naja kà'un yu'u ra va'a? Ta ma ra va'a, ti uvanuu ra kùu ra ña ìyo ra, ta rakan kùu ra Ndioo. Va tu kùuniun ni'un nuu koo nditoun endeeni chi'in Ndioo, na jachinu̱n ma tu'un tāchi Ndioo ña ìyo yi ña ja'un, ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ta ma ra tivaa, te'en nāka'an ra chi'in Jesuu: ―¿Nda tu'un kùu yi? ―kàti ra. Ta Jesuu te'en nāka'an ra chi'in ra: ―Na kä'niun, na kï'viun chi'in ñivi ña'a yöve ñasi'un, na sü'un, na kä'un tu'un vata chata nï'iin ñivi. ");
INSERT INTO mza_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Na tiñu'u̱n ma tatáun chi'in ma'un, ta na kuuniun nde'un inga ñivi, tava kùuniun nde'un juuni maun ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ta ma rayoko te'en nāka'an ra chi'in ra: ―Ndisaa yakan, cha jāchinui yi, nda ora kùi ravali, ta nda vitin. ¿Nayi kumaniga jà'i? ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta Jesuu te'en nāka'an ra chi'in ra: ―Tu kuuniun kùu̱n ma ra ndaa, na ku'un, ta xiko ndi'un ma ña ìyo nuu̱n, ta tìndeun ma ndian nda'vi. Takan ìyo yi ña ja'un, ta kùu jandolochoun ma ña kuikaun ma iti' andivi ña kùuni yi ka'an yi ña tiñu va'a jà'un kuenda Ndioo. Ta ora cha yā'a, tajan na kichiun, ta tāndikun chatai ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tajan ora chīni ma ra tivaa ña kā'an ra, ta nda'vi kūuni ra, ta kēe ra kuà'an ra, vati ra ya'a kuika kùu ra. ");
INSERT INTO mza_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tajan Jesuu te'en nāka'an ra chi'in ma ndra jàkua'a chi'in ra: ―Ndicha va'a ña kà'in chi'in ndo, ña ndee ga tiñu kùu yi kuenda iin ra kuika ña kùu kì'vi ra nuu chà'nda Ndioo tiñu. ");
INSERT INTO mza_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ta kà'an ndikoi chi'in ndo ña, chakuu tiá ndetiñu yā'a iin camellu xe'e iin kutiku, kua kuenda iin ra kuika kì'vi ra nuu chà'nda Ndioo tiñu ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Takan kūu ta ora chīni ma ndra jàkua'a chi'in Jesuu ña kā'an ra takan, ndavani yū'vi ndra, ta te'en kīcha'a ndra nàtu'un ta'an ndra: ―Tu takan kùu yi, ¿nda ndian kùu ma ndian ni kakú?, tuva takan ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tajan Jesuu ndē'e ra ndra, ta te'en nāka'an ra chi'in ndra: ―Kuenda ma ñivi ndetiñu jà'a na yi, va kuenda Ndioo töve, ti kùu ja'a ra ndisaa yi. ");
INSERT INTO mza_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tajan Petu' te'en nāka'an ra chi'in Jesuu: ―Taku ndyu'u ña ndākoo ndi tāndi'i ma ña ìyo nuu ndi, ta tāndikun ndi chataun. ¿Nayi kùu ma ña ni ni'i ndi? ―Takan kàti Petu' nuu Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Ndicha va'a ña kà'in chi'in ndo ndian cha tāndikun ndo chatai, ña ora ni chaa ma kivi ña Ndioo ni jandochaa ra ndisaa nakuyi, ma ra Se'e ñivi tāchi Ndioo ora ni chaa ra ka'nda ra tiñu ma nuu kunandi ra tayu ka'nu iin nuu ya'a ga tacha. Tajan ndyo'o ndia, ni kunandi ndo uchi uvi tayu ka'nu nuu ta'nda tiñu chi'in ra, ta ikan ni jakutuni ndo kuati ma ndi uchi uvi grupu ma ndian Israel ndia. ");
INSERT INTO mza_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta tandi'i ndyo'o ndian ndākoo ndo ve'e ndo, a ta'an ndo, a ma'á ndo, a tatá ndo, a ñasi'i ndo, a se'e ndo, a ñu'u' ndo, ta ndisaa yakan cha'i jā'a ndo yi. Yakan va ni ni'i ndo iin cientu cha'a tiá ga ma ndatiñu ndākoo ndo. Ta juuni ni ni'i ndo nuu ni koo ndito ndo endeeni ndia. ");
INSERT INTO mza_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Va kua'a' ma ndian yosonuu vitin, ni kuu na ma ndian nuu ndi'inia. Ta kua'a' ma ndian nuu ndi'inia, ni kakunuu na iti' nuu ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","―Ma nuu chà'nda Ndioo tiñu, kùu yi tava kùu iin ra ìyo ñu'u' ka'nu, ña kēe ra kuà'an ra na'a va'a kuànanduku ra ma ndra jàtiñu chi'in ra ña ka'nda ndra uva. ");
INSERT INTO mza_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta kīndoo ra chi'in ndra ña ni tia'vi ra ndra kua kiya'vi ma ñivi iin kivi. Tajan tāchi ndio ra ndra ña na kujatiñu ndra ma nuu ìyo ñu'u' nuu kàa vu. ");
INSERT INTO mza_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ta ora yā'a, tajan kēe ndiko ma ra chito'o ndra ka'íín na'ani ma veto'o, ta ikan ndē'e ra ña ka'ìin inga ma ndra töve tiñu jà'a. ");
INSERT INTO mza_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ta te'en nāka'an ra chi'in ndra: “Ndyo'o juuni na ku'un ndo kujatiñu ndo chi'i̱n ma nuu kàa ndatiñui, ta tia'vi̱ ma ya'vi ndo kuenda iin kivi.” Ta ndrakan kēe ndra kuà'an ndra. ");
INSERT INTO mza_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Takan kūu ta ma ra kùu chito'o ma ñu'u' ikan, kēe ndiko ra kuà'an ra ma veto'o ma kachuvi ndaa. Ta jā'a ndiko ra yi ma kaa uni chani'ini ndia. ");
INSERT INTO mza_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ta ora cha kūu yi kaa u'un chani'ini, kēe tuku ra kuànanduku ra musu ma veto'o, ta nāta'an ra inga tuku ma ndra töve tiñu jà'a, ta te'en nāka'an ra chi'in ndra: “¿Ta naja nduvi ka'ìin ndo i'ya, ta töve jàtiñu ndo?”, kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ta ndrakan te'en nāka'an ndra chi'in ra: “Ka'ìin ndi i'ya, vati nï'iin na takä'an kìchi ka'an chi'in ndi ña jatiñu ndi”, kàti ndra. Tajan ma ra chito'o ikan, te'en nāka'an ra chi'in ndra: “Na ku'un du ndyo'o kujatiñu ndo chi'i̱n ma nuu kàa ndatiñui ndia, ta tia'vi̱ ma ya'vi ndo kuenda iin kivi”, kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ta ora cha kuna'a, tajan ma ra kùu chito'o, te'en nāka'an ra chi'in ma ra kùxini nuu musu: “Na kanaun ma ndra jàtiñu, ta tia'viun ndra, va ji'na, na kicha'un tia'viun ma ndra kī'vi nuu ndi'inia, ta nuu ndi'inia tia'viun ma ndra kī'vi jatiñu ma nunuu”, kàti ra chi'in ma ra kuxini nuu musu. ");
INSERT INTO mza_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tajan chāa ndio ma ndra kāki'vi jātiñu kaa u'un chani'ininia, ta ta'ii'iin ndra kāni'i ndra ma ya'vi ndra kuenda iin kivi. ");
INSERT INTO mza_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ta ora yā'a, tajan chāa ma ndra na'a kāki'vi jātiñu, ta ndrakan chānini ndra ña ni ni'i ndra ma ya'vi ndra tiaga kua iin kivi kūuni ndra niku, va töve, ti indukuni kāni'i ta'ii'iin ndra ma ya'vi ndra kuenda iin kivi, kua ma inga ndra. ");
INSERT INTO mza_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tajan ma ora nāka'an ndra yi, ta kīcha'a ndra kàyuni ndra chi'in ma ra kùu chito'o, ");
INSERT INTO mza_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ta te'en nāka'an ndra chi'in ra: “Ma ndra kāki'vi nuu ndi'inia, ña jātiñu iin orania, indukuni tīa'viun ndra kua maa ndi, vaji maa ndi kùu ma ndra ndē'e ga tundo'o ña jātiñu ndi nduvi nii ma nuu ndií”, kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Va ma chito'o ma ndatiñu, te'en nāka'an ra chi'in iin ra: “Yo'o xaa, yöve nï'iin kuati kùu ma ña jà'i chi'un. ¿A töve nī kindoo va'a yo ña ni tia'vi̱ ñu̱n ma ya'vi kuenda iin kivi?, kùuniun”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Ju'un ma ya'viun, ta kuà'an. Yu'u kùuni̱ tia'vi̱ ma ra kī'vi jàtiñu nuu ndi'inia, indukuni kua maun. ");
INSERT INTO mza_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿A küu jà'i nda ña kùuni mai chi'in ma xu'in?, kùuni ndo. ¿A tixin ndo nde'e ndo yu'u cha'a' ña ra va'ani kùi?” ");
INSERT INTO mza_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ta takan kùu yi ña ma ndian kùu nuu ndi'inia, ni kuu na ma ndian nunuu, ta ma ndian kùu ma ndian nunuu vitin, ni kuu na ma ndian nuu ndi'inia. Vati kua'a' na kānai, va tiani na kāchi̱n ―kàti Jesuu chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ta ora kuà'an Jesuu ma iti' ñuu Jerusalén, ta kāna siin ra ma ndi uchi uvi ndra jàkua'a chi'in ra, ta te'en nāka'an ra chi'in ndra: ");
INSERT INTO mza_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Vitin va ndè'e ndo ña cha kuà'an yo iti' ñuu Jerusalén nuu ni tiin na ma ra Se'e ñivi tāchi Ndioo, ta ni ku'va na ra nda'a' ma ndra kuxini nuu sutu, chi'in nuu ma ndra kùu matru jàkua'a tutu ley Ndioo, ikan na jakutini ndra kuati ra ta ka'ni ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ta ikan jan ni ku'va ndra ra nda'a' ma ndian yüvi judíu, kuenda ña na jati'ini na chi'in ra, ta kàni na ra, ta tàkaa na ra nuu kruu, va tichi uni kivi ni nataku ndiko ra. ");
INSERT INTO mza_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ma ma'á Jandiau chi'in Xuva ndra kùu se'e Zebedeu, chājayatin vi vi nuu Jesuu, ta chūnandi chitian nuu ra, ña chìkan ña iin ñamani nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ta Jesuu te'en nāka'an ra chi'an: ―¿Niyi kùuniun? ―kàti ra chi'an. Va ma ña'a ikan, te'en nāka'an ña chi'in ra: ―Na tachiun ma nuu chà'ndaun tiñu ña ora chāun ndakan, iin ma ra se'i kunandi chiyo kua'un, ta inga ra kunandi chiyo satiun ―kàti ña. ");
INSERT INTO mza_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Va Jesuu te'en nāka'an ra chi'an: ―Töve chìto ndo niyi kùu ma ña chìkan ndo. ¿A kùu ja'a ndo ko'o ndo ma ña uva ni ko'i, ta kùnduta ndo indukuni ma takua ni kundutai ña kà'an ndo takan? ―kàti Jesuu. Ta ndrakan te'en nāka'an ndra: ―Kùu yi ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Ndicha ña ndyo'o kùu ja'a ndo ko'o ndo ma ña uva ni ko'i, ta juuni kùu ja'a ndo kùnduta ndo ma takua ni kundutai ndia, va taku cha'a' ña chìkan ndo kunandi ndo ma chiyo kua'i, ta chiyo sati̱n, ma Tatái kùu ma ra chìto nda yo ni ku'va ra ma chiyo ikan nuu, ta yöve yu'u ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ta ora chīni ma inga uchi ma ndra jàkua'a chi'in Jesuu ma ña kā'an ndra, ta kūxaan ndra chi'in ninduvi ndrakan. ");
INSERT INTO mza_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Va Jesuu kāna ra ndra, ta te'en nāka'an ra chi'in ndra: ―Ndyo'o cha chìto va'a ndo, ña ma ndra kuxini ña chà'nda tiñu nuu ma ñivi ìyo ma nuñu'u' ñuñivi töve jà'a ndra va'a chi'in na, ti ya'a kanduu kini chà'nda ndra tiñu. ");
INSERT INTO mza_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Va tañu ndyo'o ndian chìnuni, na töve ìyo yi ña ja'a ndo takan, vati tu ìyo nda ndyo'o ña kùuni ndo jaka'nu ndo ndo, ji'na ìyo yi ja'a ndo tiñu nuu ma inga na. ");
INSERT INTO mza_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ta nda ndyo'o nikuuni, tu kùuni ndo kuu ndo ma ndian nunuu, ìyo yi ña ja'a ndo tiñu nuu ma inga na, ");
INSERT INTO mza_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","takua jā'a ma ra Se'e ñivi tāchi Ndioo, ña tüvi nī kichi ra kuenda ña jà'a na tiñu nuu ra, vati kīchi ra va kuenda ña jà'a ra tiñu nuu ñivi, ta kuvi ra kuenda ña kùu ra takua kùu iin ya'vi kuenda ña na kakú kua'a' ñivi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Takan kūu ta ora kēe Jesuu ma ñuu Jericó, nduva'a kua'a' ñivi tāndikun kuà'an chata ra. ");
INSERT INTO mza_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta ma yu'u iti' kuà'an ra, ikan nandi uvi ta'an ndra kuaá. Ta ora chīni ndra ña yà'a Jesuu ikan, ta te'en kānachaa ndra: ―¡Yo'o Racha'nu, ra kùu ñivi David, na kunda'viniun ndyu'u! ―kàti ma ndra kuaá chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tajan ma ñivi nāka'an na chi'in ma ndra kuaá ña na taxiin koyu'u ndra, va ndrakan tiá ga kīcha'a ndra kànachaa ndra te'en: ―¡Yo'o Racha'nu, ra kùu ñivi David, na kunda'viniun ndyu'u! ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tajan chūndaa ndio Jesuu, ta kāna ra ma ndra kuaá, ta te'en chīkatu'un ra nuu ndra: ―¿Niyi kùuni ndo ña ja'i chi'in ndo? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta ndra kuaá ikan te'en nāka'an ndra chi'in ra: ―Yo'o Racha'nu, kùuni ndi ña na jandondichiun nuu ndi ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tajan Jesuu kūnda'vini ra ndra, ta jānani ra nda'a' ra chata tinuu ma ndra kuaá, ta ma ora ikani kūu nande'e ndra, ta tāndikun ndra chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ora cha kuàkuyatin Jesuu chi'in ma ndra jàkua'a chi'in ra ma ñuu Jerusalén, ji'na chāa ndra iin ñuu ña nàni Betfagé, ña kandii yatini nuu ndaa ma yuku Olivu. Tajan Jesuu tāchi ra uvi ta'an ma ndra jàkua'a chi'in ra, ");
INSERT INTO mza_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ta te'en nāka'an ra chi'in ndra: ―Kuà'an ndo ma kuariya ña kàndii ikani. Ta ikan nàta'an ndo iin burra ña ndikun ri ndaa ri ikan chi'in iin burru vali se'e ri. Na ndachi ndo ri, ta kundaka ndo ninduvi ndri kichi ndo nui. ");
INSERT INTO mza_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ta tu ìyo iin ndian chìkatu'un, ña naja ndàchi ndo ri, ta kati ndo chi'in na ña nunua vàchi ndaka ndiko ndi ri, ti chìniñu'u ma racha'nu chito'o ndi ri, kati ndo chi'in na ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Takan kūu yi, ikan na chinu ma tu'un kā'an ma ra kà'an chi'in tu'un yu'u Ndioo, ora tāa ra te'en nuu tutu ra: ");
INSERT INTO mza_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Na kukatitu'un ndo te'en nuu ndisaa ma ñivi ìyo ma ñuu Sión: “Na nde'e ndo ña nduva'a nda'vi vàchi ma ra kùu Rey ndo yoso ra iin burru yoko chi'in ma'á ri, se'e ma kiti chìto kuiso karia”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tajan kēe ndio ma ndra jàkua'a chi'in Jesuu kàcha'an ndra, ta jā'a ndra yi ma tava kā'an ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Takan kūu tajan ndàka ndio ndra ma burru, chi'in ma kiti vali se'e ri chāa ndra nuu ra, ta tīsukun ndra ma ja'ma isukun ndra chata ninduvi ndri, tajan chākoso ndio Jesuu ri. ");
INSERT INTO mza_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ta ikan kūti'vi nduva'a kuii kua'a' ñivi. Ta ndiakan kīcha'a ndio na chàkin na ja'ma isukun na ma tichi iti' nuu kuà'an Jesuu. Ta ìyo inga ndian chā'nu soko yutun, ta chākin na yi ma tichi iti' ndia. ");
INSERT INTO mza_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ta ma ñivi yosonuu, chi'in ma ñivi kàkichi iti' chata, te'en kànachaa ni'i na: ―¡Ya'a ga ka'nu kùu ma ra vàchi tata ma rey David! ¡Ya'a ga ií kùu ma ra vàchi chi'in sivi ma Racha'nu! ¡Ta nduva'a na jaka'nu yo Racha'nu Ndioo nuu ìyo ra andivi! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Takan kūu tajan ora kī'vi ndio Jesuu ma ñuu Jerusalén, tajan ndisaa ndio ma ndian ìyo ikan nduva'a nāndiki na jā'a Jesuu ora kī'vi ra ikan. Ta te'en kīcha'a ndio na chìkatu'un ta'an na: ―¿Nda ra kùu ra'ya? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ta ma ñivi kàcha'an chi'in Jesuu te'en nāka'an na chi'in na: ―Ra'ya kùu Jesuu, ra kà'an chi'in tu'un yu'u Ndioo, ra kīchi ñuu Nazaret, ña kàndii iti' ñu'u' Galilea ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Takan kūu tajan kī'vi ndio Jesuu ma tichi veñu'u ka'nu ma Ndioo, ta tāvani'i ndi'i ra ma ndian ka'ìin xiko, ta jata ma tichi veñu'u. Kānindee ra ma mesa nuu ka'ìin ma ndian sàma xu'un' nuu ma ñivi, ta tayu nuu ka'ìin ma ndian xìko livi ndia. ");
INSERT INTO mza_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tajan te'en nāka'an ndio ra chi'in na: ―Nuu ma tutu Ndioo ña tāa ma Moisés te'en kà'an yi: “Ma ve'i kùu yi iin ve'e nuu kà'an ma ñivi chi'i̱n.” Va ndyo'o, jāndakuu ndo yi iin ve'e kuenda ma ndian su'u ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tajan chājayatin ndio ma ndian kuaá ma nuu ndaa Jesuu ma tichi veñu'u ka'nu, chi'in ndian koxo, ta jānda'a ra na. ");
INSERT INTO mza_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Va ora ndē'e ma ndra kuxini nuu sutu, chi'in ma ndra matru jàkua'a tutu Ndioo ma ndatu ña jà'a Jesuu, ta naja kua chìni ndra ña endee nanivaa kùu ma ndiakuati ma tichi veñu'u, ña te'en kànachaa na: “Ya'a ga ka'nu kùu ma ra kīchi tata ma rey David”, kàti na, ta nduva'a kūxaan ndra. ");
INSERT INTO mza_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tajan te'en nāka'an ndra chi'in Jesuu: ―¿A chìniun ña kàka'an ma ñivi ikan? ―kàti ndra. Ta Jesuu te'en nāka'an ra chi'in ndra: ―Juu, chìni̱ ma ña kà'an na, va ¿a takä'an jakua'a ndo nuu ma tutu Ndioo ña tāa Moisés nuu kà'an yi te'en?: Chi'in yaa ña chìta ma ndiakuati, chi'in ma ndian juuni chàxin, chi'in yakan jàna'a ma Ndioo nuu ndo, ña takan ìyo yi ña jaka'nu ndo ra ndia kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tajan ndākoo ra ma ñivi ikan, ta kēe ra kuà'an ra inga ñuu ña nàni Betania, nuu kāva ra iin chanikuaa. ");
INSERT INTO mza_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ta ora chīkoni'i ndiko Jesuu ma ñuu ka'nu, ma ora na'ani, ta chāñu ndio ma soko ra. ");
INSERT INTO mza_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ta ikan ndē'e ra ña ndaa iin yutun higu yatini ma yu'u iti', ta chājayatin ra ra nuu ndaa run, va tükuii nuva koo ma nuu run, ti mamaa nda'ani run ìyo. Tajan kā'an xaan ndio ra run: ―¡Nda vitin, ta iti' nuu, na tüva ni ku'vaun ma chiti! ―kàti Jesuu chi'in run. Ta juuni ma ora ikani nātii run, ta chī'í run. ");
INSERT INTO mza_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ta ora ndē'e ma ndra jàkua'a chi'in ra ma ña kūu, ta ndava kuà'an anima ndra, ta te'en chīkatu'un ndio ndra nuu Jesuu: ―¿Niyi tā'an ma yutun higu ña yā'a ga numi nātii run? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Ndicha va'i ña kà'in chi'in ndo, ña tu chìnu va'ani ndo ma tu'un Ndioo, ta töve ndo'uvini ndo, na yöve uvaa ma ña jā'i chi'in ma yutun higu i'yani kùu ja'a ndo, vati juuni kùu ka'an ndo te'en, chi'in ma yuku i'ya ndia: “¡Na kundachiyoun chiña, ta nduvaun nuu ma tañu'u!”, kati ndo, ta takan ni kuu yi. ");
INSERT INTO mza_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta ndisaa ma ña chìkan ndo ora kà'an ndo chi'in ma Racha'nu, tu ndicha ña chànini ndo ña ni kuu yi, ni ni'i ndo yi ―kàti Jesuu chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Takan kūu tajan kī'vi ndio Jesuu ma tichi veñu'u ka'nu ña kua jana'a ra, ta ora juuni ndaa ra jàna'a ra nuu ma ñivi, ta chājayatin ndio ma ndra kuxini nuu sutu, chi'in ndra cha'nu kuenda ma ndian judíu nuu ra, ta te'en chīkatu'un ndra nuu ra: ―¿Yo chā'a tiñu nuu̱n ña jā'un te'en? ¿Yo kùu ma ndian tīyu'u ñu̱n ña na ja'un yi? ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ta Jesuu te'en nāka'an ra chi'in ndra ndia: ―Juuni kùuni du mai ndakatu'in iin nakuyi nuu ndo ndia, tu katitu'un ndo ma ña chìkatu'in nuu ndo, tajan katitu'in nuu ndo yo chā'a tiñu nui ña jā'i yi. ");
INSERT INTO mza_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Yo kùu ma yo tāchi ma Xuva ña na jakunduta ra?, ¿a Ndioo, a ma ñivi? ―kàti Jesuu. Tajan te'en kīcha'a ndio ndra kànita'an yu'u ndra juuni chi'in maa ndra: ―Tu kati yo: “Ña Ndioo tāchi ra”, ta rakan ni ka'an ra chi'in yo ña: “¿Naja töve nī jachi'in ndo ña kà'an ra tuva takan?” ");
INSERT INTO mza_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ta na küu kà'an yo ña: “ñivi tāchi ra”, ni kuxaan ma ñivi chi'in yo, vati ndisaa na chànini na ña iin ra kà'an chi'in tu'un yu'u Ndioo kùu Xuva ―kūuni ndra. ");
INSERT INTO mza_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yakan va te'en nāka'an ndio ndra chi'in Jesuu: ―Töve chìto ndi, yo tāchi ra ―kàti ndra. Tajan Jesuu te'en nāka'an ndio ra chi'in ndra: ―Ni yu'u, küu katitu'in nuu ndo yo tīyu'u yu'u ña jà'i ma tiñu i'ya ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Takan kūu tajan Jesuu, te'en nāka'an tuku ra nuu ndra: ―¿Naja kua chànini ndo cha'a' ma ña ni ka'in i'ya? Iin ra'ii chīyo uvi ndra se'e ra. Ta rakan, te'en nāka'an ra chi'in iin ra: “Yo'o se'yu, na ku'u̱n kujatiñu̱n nuu kàa ma ndatiñu yo vitin”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ta ma ra se'e ra, te'en nāka'an ra chi'in ra: “¡Na küuni̱!”, kāti ra ma ora ikan. Va ora cha yā'a ndio tajan sāma ma kua chànini ra, ta chā'an ra chājatiñu ra. ");
INSERT INTO mza_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ta ikan jan chānde'e ra inga ma ra se'e ra, ta indukuni takua kā'an ra chi'in ma ra nunuu, kā'an ra chi'in ra. Ta ra'ya te'en nāka'an ra: “Va'a tatá, ku'in”, kāti ra. Va töve nī cha'an ra. ");
INSERT INTO mza_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Nda ra kùu ma ra kāndicha ma tiñu kā'an ma tatá ndra?, kùuni ndo ―kàti Jesuu chi'in ndra. Ta ndrakan te'en nāka'an ndra: ―Ma ra nunuu ―kāti ndra. Takan kūu yakan va te'en nāka'an ma Jesuu: ―Ndicha va'a ña kà'in chi'in ndo, ña ma ndra nàka'an xu'un' kuenda kuvienu ma ñuu ndo, chi'in ma ñivi ña'a tondo, ji'na ga na ni ki'vi nuu chà'nda Ndioo tiñu kua maa ndo. ");
INSERT INTO mza_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Vati ma Xuva ra jàkunduta kīchi jana'a ra nuu ndo naja kuu yi ña koo ndo takua kùuni Ndioo, va ndyo'o töve nī jachi'in ndo ña kà'an ra. Va taku ma ndian nàka'an xu'un' kuenda kuvienu ma ñuu ndo, chi'in ma ñivi ña'a tondo, ndiakan jāchi'in na ña kā'an ra. Va ndyo'o, vaji ndē'e ndo ña takan kūu yi ma i'ya, va töve kùuni ndo sama ndo ma kua kini kua ìyo ndo, ta chinuni ndo ma ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Takan kūu ta te'en nāka'an tuku Jesuu inga ku'va nuu ndra: ―Na taso'o va'a ndo ma inga ku'va ña ni ka'in: Tatiempu chīyo iin ra ìyo iin ñu'u' ka'nu, ta rakan tāchi ra yoku'u uva nuu yi, ta chāsi ra ma nuu kàa yi. Ta juuni jā'a ra iin nuu naku'ni ra ma uva, ta jā'a ra iin torri ka'nu kuenda ña na chaa nuu ra nde'e ra ninii ma nuu kàa vu. ’Ta ikan jan jākilaa ndio ra ma ñu'u nuu iin ma ndra jàtiñu chi'in ra, ta kēe ndio ra kuà'an ra iin tiempu ma nuu chika. ");
INSERT INTO mza_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ta ora chāa ndio ma tiempu ña cha kēta ndio ma ndatiñu ikan, tajan tāchi ndio ma ra chito'o ma ñu'u' iin ma ndra jàtiñu kuenda ra ña na ku'va ma ndra jàtiñu nuu ñu'u' ra ma ña ìyo yi ña ndaki'in ra. ");
INSERT INTO mza_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Va ma ndra jàtiñu ikan, tīin ndra ma ndra jàtiñu kuenda ra, ta iin ra va kāni ndra, inga ra chā'ni ndra, ta inga ra va kāni ndra chi'in yuu. ");
INSERT INTO mza_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tajan ma ra kùu chito'o ma ñu'u' ikan, tāchi ndiko ra tiá kua'a' ma ndra jà'a tiñu nuu ra nuu ndra kua ma cha'a' nunuu, va ma ndra jàtiñu ikan, indukuni takan jā'a ndra chi'in ndisaa ndra ndia. ");
INSERT INTO mza_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ta ma nuu ndi'inia, va tāchi ndio ra ma ra se'e maa ra, ti te'en chānini ra: “Cha chìto yo ña ni tiñu'u ndra, ta jàchi'in ndra ña kà'an ma ra se'o.” Takan kūuni ra. ");
INSERT INTO mza_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Va ora ndē'e ndio ma ndra jàtiñu nuu ñu'u' ra ña vàchi ndio ma ra se'e maa ndio ra, tajan te'en kīcha'a ndra nàtu'un ndra juuni chi'in maa ndra: “Ra'ya kùu ma ra ni kindoo chi'in ma ñu'u' i'ya, na ka'nio ra, ta kindoo yo chi'in ma ñu'u'”, kāti ndra. ");
INSERT INTO mza_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tajan tīin ndio ndra ra, ta tāva ndra ra nuu kàa ma yoku'u uva, ta chā'ni ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Ta vitin ora ni kichaa ndio ma ra kùu chito'o ma ñu'u', ¿nayi ni ja'a ra chi'in ma ndra jàtiñu takan?, kùuni ndo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta ndrakan te'en nāka'an ndra chi'in Jesuu: ―Na töve nī kunda'vini chito'o ma yoku'u uva ndra, ti ni ka'ni ra ma ndra kini ikan, ta ni jakilaa ra ma ñu'u' ra nuu inga tuku ma ndra ña kùuni ku'va ndra ma ndatiñu ra nuu ra ora jàtiñu ndra, ma takua ìyo yi ña ja'a ndra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―¿A takä'an kuii jakua'a ndo nuu ma tutu Ndioo ña tāa Moisés nuu kà'an yi te'en?: Ma yuu ña jāchiyo ma ndra jàva'a ve'e, yakan kùu ma yuu ka'nu ga kua ndisaa yi, takan jā'a ma Racha'nu, Yakan va ña'a kùu yi iin ña ya'a vii kuenda yo, kàti yi. ");
INSERT INTO mza_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Cha'a' yakan kùu yi ña kà'in chi'in ndo ña ma nuu chà'nda Ndioo tiñu, ni namaa ra yi nuu ndo, ta ni ku'va ra yi nuu ma ndian jà'a ma tiñu va'a kuenda ra. ");
INSERT INTO mza_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ta nda ndian nikuuni ña ni nduva chata ma yuu ka'nu ikan, endee ni kuche'e che'e na, tatu ma yuu ikan kòyo yi chata iin ñivi, endee ma yuyaania ni kuu na ja'a yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Takan kūu tajan ora chīni ma ndra kuxini nuu sutu, chi'in ma ndian fariseu ma ku'va ña kā'an Jesuu, ikan chā'a ndio ndra kuenda ña chata ndra kà'an ra. ");
INSERT INTO mza_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tajan kūuni ndra tiin ndra Jesuu, va yū'vi ndra ma ñivi, ti ndiakan cha chànini na ña Jesuu kùu ra iin ra kà'an chi'in tu'un yu'u Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Takan kūu tajan kīcha'a ndiko Jesuu kà'an ra iin ku'va nuu ma ñivi, ta te'en nāka'an ra: ");
INSERT INTO mza_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ma nuu chà'nda Ndioo tiñu kùu yi, takua kùu iin viko tànda'a ña jā'a ma ra kùu rey kuenda ma ra se'e ra. ");
INSERT INTO mza_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tāchi ra ma ndra jàkuu tiñu nuu ra, ña na kukana ndra ma ndian jainvitaa ra, va ma ndiakan nī kuuni na ku'un na. ");
INSERT INTO mza_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tajan tāchi ndiko ma ra kùu rey ma ndra jàkuu tiñu nuu ra inga cha'a', ta te'en nāka'an ra chi'in ndra: “Na katitu'un ndo nuu ma ndian jainvitaa, ña na kichi na, ti cha ìyo va'a ma ña kachi na, vati cha tāchi̱ ña na ka'ni na kua'a' kiti ndu'u janai. Ta na kichi na, ti ndisaa yi cha ìyo va'a”, kati ndo. ");
INSERT INTO mza_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Va ma ndian jainvitaa ra töve nī jachi'in na ña kà'an ma ra kùu rey, ti ìyo ndian kēe kuànde'e ma nuu kàndii ñu'u' na, ta ìyo ndian kēe kuà'an nuu ìyo tiñu jà'a na. ");
INSERT INTO mza_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ta inga na, va tīin na ma ndra jà'a tiñu nuu ma rey, ta nduva'a kāni na ndra, ña ndava ni kuvi ndra jà'a na niku. ");
INSERT INTO mza_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tajan nduva'a kāyuni ma ra kùu rey, ta tāchi ndio ra ma ndra jandaru ra, ña na kuka'ni ndra ma ndian kini chà'ni ndií ikan, ta ka'mi ndra ndisaa ma ve'e ña ìyo ma ñuu ndra ndia. ");
INSERT INTO mza_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tajan te'en nāka'an ndio ma rey chi'in ma ndra jàkuu tiñu nuu ra: “Ndisaa nakuyi cha ìyo va'a jā'i kuenda ma viko tanda'a, va ma ndian jainvitaai, na töva ni ku'vai na kichi na i'ya. ");
INSERT INTO mza_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Na ku'un ndo nuu kùtisi'in ma kai ka'nu, ta na jainvitaa ndo, ma nda ndian nikuuni ña nàta'an ndo, ta kichi na chi'in ndo ma viko tànda'a i'ya”, kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tajan kēe ndio ma ndra jàkuu tiñu nuu ma rey kàcha'an ndra iti' kai, ta jāti'vi ta'an ndra tandi'i ma ndian nāta'an ndra ikan, chïto a kùu na ndian va'a a ndian tüvi va'a. Takan jā'a ra ña nī'i ra ñivi kuenda ma viko tànda'a, ña endee chītu ndio ma tichi ve'e ra. ");
INSERT INTO mza_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Tajan kī'vi ndio ma ra kùu rey ma tichi ve'e, ikan na kuu nde'e ra ma ndian chājati'vi ta'an ndra ma veto'o, ta ikan ndē'e ra iin ra töve ñu'u ja'ma ña chàku'un na ora chà'an na ma viko tànda'a. ");
INSERT INTO mza_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ta te'en nāka'an ra nuu ra: “Yo'o xaa, ¿naja jā'un ña kī'viun ma i'ya, ta töve ñù'u̱n ma ja'ma ña chàku'un na ora kuà'an na nuu ìyo ma viko tànda'a?”, kàti ra chi'in ra. Va ma ra'ii ikan taxiin kīndoo ra. ");
INSERT INTO mza_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tajan ma rey, te'en nāka'an tuku ra chi'in ma ndra jàkukava ma nuu mesa: “Na ku'ni ndo cha'a ra chi'in nda'a' ra, ta jaketa ndo ra nuke'e nuu naa, ikan ni kuaku ra, ta ni kari'u ma nu'u ra, jà'a ma tundo'o ni nde'e ra.” ");
INSERT INTO mza_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Vati nduva'a kua'a' na kànai, va tiani na kùu ma ndian kàchi̱n ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Takan kūu tajan ma ndra fariseu kēe ndio ndra chājando'iin tu'un ndra, naja kua jà'a ndra ña na ka'an Jesuu iin ña tüvi va'a, ta chi'in yakan kùu ni'i ndra naja kua tìsokuati ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tajan tāchi ndio ma ndra fariseu ita'vi ma ndra ìyo kuenda ndra, chi'in ita'vi ma ndra ìyo kuenda Herode. Ta ndrakan te'en nāka'an ndra chi'in Jesuu: ―Matru, cha chìto ndi ña yo'o kùu ma ra kà'an tu'un ndaa, ta juuni jàna'a ndaun naja kua kùuni Ndioo ña koo yo, ta töve kì'in kuendaun ña kà'an ma ñivi, vati indukuni ndè'un ndisaa ñivi. ");
INSERT INTO mza_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na katitu'u̱n nuu ndi: ¿A va'a tìa'vi ndi xu'un' nuu ma ra César, ña chà'nda tiñu ma ñuu Roma kùuniun?, ¿a töve? ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Va Jesuu chā'a ra kuenda, ña na yüvi ña va'a kùu ma ña chànini ndra kuenda ra, ta te'en nāka'an ndio ra nuu ndra: ―Ndyo'o ndra kini, ta, ¿naja kùuni ndo janda'viña'a ndo yu'u? ");
INSERT INTO mza_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Na jana'a ndo nui naja kua kàa ma xu'un' ña tìa'vi ndo ―kàti Jesuu. Tajan chāki'in ndra iin xu'un' denariu chā'a ndra nuu Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ta ora ndē'e ndio Jesuu yi, ta te'en chīkatu'un ra nuu ndra: ―¿Yo nuu kùu ma ña ìyo nuu ma xu'un' i'ya, ta ma sivi ña ìyo nuu yi? ―kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta ndrakan te'en nāka'an ndra chi'in ra: ―Ma ña César, ra chà'nda tiñu ñuu Roma kùu yi ―kàti ndra chi'in Jesuu. Tajan Jesuu te'en nāka'an ra nuu ndra: ―Na ku'va ndo ña kùu ña'a ma racha'nu César nuu ra, ta ña kùu ña'a Racha'nu Ndioo nuu Ndioo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta ora chīni ndra ña kā'an ra takan, ta ndava kuà'an anima ndra, tajan ndākoo ndra ra, ta kuà'an ndra. ");
INSERT INTO mza_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta juuni ma kivi ikan, ìyo ndra saduceu, chānde'e ndra Jesuu. Ta ndrakan kàti ndra, ña tüva nàtaku ma ndian ndií, cha'a' yakan kùu yi ña, te'en chīkatu'un ndra nuu Jesuu: ");
INSERT INTO mza_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Matru, Moisés kā'an ra ña, tu iin ra cha tānda'a kùvi ra, ta töve nī chakoo nï'iin se'e ra, ma ra yani ra, ìyo yi ña tanda'a ra chi'in ma ñasi'i ra ña kīndoo nda'vi, ta takan kùu koo se'e ma ra chī'í jà'a ma ra yani ra. ");
INSERT INTO mza_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Va'ani, tañu ndyu'u chīyo ucha ta'an ndra, ña kùu ndra yani ndra. Ma ra nunuu tānda'a ra, ta chī'í ra. Ta tava töve nī chakoo se'e ra chi'in ma ñasi'i ra, yakan va kīndoo ma ña nda'vi ikan kuenda ma yani ra, ra uvi. ");
INSERT INTO mza_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ta juuni indukuni takan töve nī chiyo se'e ma ra uvi chi'an, ta chī'í ra ndia. Ta takan ya'a ndi ucha yani ndra ña tānda'a ndra chi'an ta ndisaa ndra chī'í ndia. ");
INSERT INTO mza_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ta ma nuu ndi'inia, chī'í ndio ma ña'a ndia. ");
INSERT INTO mza_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Va'ani, ta ma ora ni nataku ndiko ma ndian cha chī'í, ¿nda ndra ni kuu ma iian, tuva ndi ucha ndra ña kùu ndra yani ndra tānda'a ndra chi'an? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ta ma Jesuu te'en nāka'an ra chi'in ndra: ―Na yüvi takan kùu yi, takan chànini ndo, ti töve nàkoto ndo naja kua kà'an ma tutu Ndioo, ta naja kua kùu ma ndatu Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Vati ora ni nataku ma ndian cha chī'í, na tüva ni tanda'a na, ta tüva ni ku'va na se'e na kuenda ña tànda'a na ndia, ti ni kùu na tava kùu ma ndian kùu tati va'a ña ìyo andivi ña jà'a tiñu nuu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Va ndicha kuii ña nàtaku ndiko ma ndian chī'í, ¿a takä'an jàkua'a ndo nuu ma tutu Ndioo, nuu kà'an ra te'en?: ");
INSERT INTO mza_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yu'u kùu Ndioo ta indukuni yu'u kùi ra kùmi Abraham chi'in Isaac chi'in Jacob ndia”, kàti yi. I'ya chà'a yo kuenda ña Ndioo töve kùu ra Ndioo ma ndian ndií, ti kùu ra Ndioo ma ndian ndito. ");
INSERT INTO mza_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ta ora chīni ma ñivi ma tu'un ña kā'an Jesuu, ndava kuà'an anima na chìni na ña jàna'a ra. ");
INSERT INTO mza_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ta ora chīto ma ndra fariseu ña Jesuu jākutaxin ra ma ndra saduceu, tajan kūti'vita'an ndio ndra ma nuu ndaa ra. ");
INSERT INTO mza_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ta iin ma ra meru ndra ña kùu matru jàkua'a tutu ley Ndioo, te'en chīkatu'un ra nuu Jesuu, ña kùuni ra ki'in ra ku'va ra nde'o naja kua kati ra: ");
INSERT INTO mza_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Matru, ¿nda tu'un ìyo nuu ma tutu ley Ndioo ka'nu ga yi kua tandi'i ga ma inga tu'un ìyo nuu yi?, kùuniun ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ta Jesuu te'en nāka'an ra chi'in ra: ―“Na kuuni ndo nde'e ndo ma Racha'nu Ndioo chito'o ndo chi'in ndisaa anima ndo, chi'in ndisaa ñandee ndo, ta chi'in ndisaa chinituni ndo.” ");
INSERT INTO mza_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tu'un i'ya kùu tu'un ka'nuga, ta ma tu'un nunuu ña ìyo nuu ma tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ta ma tu'un uvi, cha yatin indukuni kùu yi, ta te'en kà'an yi: “Na kuuni ndo nde'e ndo ma ñivi ìyo yatini xiin ve'e ndo tava kùuni ndo nde'e ndo juuni maa ndo.” ");
INSERT INTO mza_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ta chi'in uvi tu'un i'ya jàchinu yi tandi'i ma ley Ndioo chi'in ma tu'un kā'an ndra kà'an chi'in tu'un yu'u ra taji'na ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ta ora juuni ka'ìin ti'vi ga ma ndra fariseu ma ikan, ");
INSERT INTO mza_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ta Jesuu te'en chīkatu'un ra nuu ndra: ―¿Naja kua chànini ndo cha'a' ma ra kùu Cristu? ¿Yo tata kùu ra?, kùuni ndo ―kàti ra. Ta ma ndra fariseu te'en nāka'an ndra: ―Tata ma racha'nu David kùu ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Tu takan kùu yi, ¿ta naja chātiñu ma Tati Ií Ndioo ma David ña na ka'an ra ña Racha'nu ra kùu Cristu, tuva takan? Vati ndicha ña ma David, te'en kā'an ra: ");
INSERT INTO mza_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ma Racha'nu Ndioo, te'en kā'an ra chi'in ma Racha'nu chito'i: “Kunandi chiyo kua'i, nda kati kanindoyoi ma ndian xaani ndè'e ñu̱n iti' cha'un.” Takan kāti Ndioo taji'na ña tāa David. ");
INSERT INTO mza_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Va Jesuu te'en nāka'an tuku ra nuu ndra: ―¿Naja kua kùu yi ña, tata David kùu Cristu, tuva juuni ma David kā'an ra ña, Racha'nu chito'o ra kùu ra? ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nï'iin ma ñivi töve nī kuu ka'an na nï'iin ma tu'un yu'u Jesuu. Ta nda ma kivi ikan nï'iin ga ma ñivi tüva ni kuuni na ndakatu'un na tiaga nakuyi nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Takan kūu tajan Jesuu, te'en nāka'an ra nuu ma ñivi, ta nuu ma ndra jàkua'a chi'in ra: ");
INSERT INTO mza_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ma ndra matru ña jàkua'a tutu Ndioo, chi'in ma ndra fariseu jàna'a ndra naja kua kùuni ma ley Ndioo ña tāa Moisés ka'an yi. ");
INSERT INTO mza_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Va'ani, na jachi'in ndo ma ña kà'an ndra, ta na ja'a ndo ndisaa yi ndia, va koto jä'a ndo takua jà'a ndra, vati ndrakan kà'an ndra iin nakuyi, ta jà'a ndra inga nakuyi. ");
INSERT INTO mza_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Jà'a ndra ña na kuiso ma ñivi iin ña nduva'a vee, ña na kündee na kuiso na, ta jà'a ndra ña na kuiso na yi, va juuni maa ndra, ni ita'vi töve kùuni ndra ja'a ndra yi. ");
INSERT INTO mza_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ndisaa ma ña jà'a ndra, jà'a ndra yi ikan na nde'e ma ñivi yi. Ta chàta'ani ndra kundikun iin kaja vali, nuu te'e nuu ndra chi'in ma chiyo nda'a' satin ndra, ta tichi yi indii uvi uni ma tu'un Ndioo ña ka'nu ga. Ta juuni chàta'ani ndra kù'un ndra ja'ma ki'in nuu ka'ìin kua'a' tilachi xiin yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ta chàta'ani ndra kuiin ndra ma tayu ka'nu ga ma nuu chìyo viko, ta ma tichi veñu'u kuati ma ndian judíu ndia. ");
INSERT INTO mza_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ta juuni kùuni ndra ña na iñu'u kaña'a ma ñivi chi'in ndra ndanikuni nuu kèta ndra nuu na ma kai. Ta na ka'an na ndra, “matru.” ");
INSERT INTO mza_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Va ndyo'o, töve ìyo yi ña ku'va ndo ma ñivi ña na ka'an na, matru chi'in ndo, vati ndisaa ndo kùu ndo ta'an ndo. Ta ma ra kùu Matru ndo, uvanuuni ra ìyo, ta rakan kùu ra, Cristu. ");
INSERT INTO mza_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ta töve ìyo yi ña ka'an ndo, tatá, ma nï'iin ñivi ìyo nuñu'u' ñuñivi, vati uvanuuni ma ra ìyo andivi kùu Tatá yo. ");
INSERT INTO mza_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ta juuni töve ìyo yi ña ku'va ndo ña ma ñivi ka'an na, ña ndyo'o kuu ma ndian kuxini, vati uvanuuni Cristu kùu ma ra kuxini. ");
INSERT INTO mza_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma ra jàkuu tiñu nuu inga ñivi, rakan kùu ma ra ka'nu ga ña ìyo ma tañu ndo. ");
INSERT INTO mza_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Vati ma ndra jàka'nu chi'in maa', ndrakan, Ndioo ni jakukanuu ra ndra, va ma ndra jànda'vi ña'a juuni maa', ndrakan ni jaka'nu ma Ndioo ndra. ");
INSERT INTO mza_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Nda'vi ta'an ndyo'o, matru ña jàkua'a tutu Ndioo, chi'in ndyo'o ndra fariseu ndra uvi nuu kua chànini ndo! Vati chàsi ndo nuu kì'vi inga ñivi ma nuu chà'nda Ndioo tiñu andivi, ikan na küu ki'vi na. Ni maa ndo töve kùuni ndo ki'vi ndo, ta ni töve chà'a ndo ki'vi ma ndian kùuni ki'vi ndia. ");
INSERT INTO mza_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Nda'vi ta'an ndyo'o, matru ña jàkua'a tutu Ndioo, chi'in ndyo'o ndra fariseu ndra uvi nuu kua chànini ndo! Vati namaa ndo ve'e ma ñivi ña'a kìndoo nda'vi, ta nàkuatu ndo nuu ka'ìin kua'a' ñivi, ikan na kuuni na ña yüvi ndra su'u kùu ndo. Cha'a' yakan kùu yi ña ni nde'e ndo kua'a' ga tundo'o. ");
INSERT INTO mza_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Nda'vi ta'an ndyo'o, matru ña jàkua'a tutu Ndioo, chi'in ndyo'o ndra fariseu ndra uvi nuu kua chànini ndo! Vati ndyo'o chàkunuu ndo nànduku ndo ñivi ninii ka'nu ma nuñu'u' ñuñivi, kuenda ña na ki'vi na ma iti' chàkunuu ndo. Ta ora cha kī'vi ndio na jā'a ndo, tajan jà'a ndo ña na ndakuu kini ga na kua maa ndo kuenda ña ku'un na andaya'. ");
INSERT INTO mza_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Nda'vi ta'an ndyo'o, ndra kùu takua kùu ma ndian kuaá ña jàna'a nuu ma ñivi!, ti ndyo'o te'en kà'an ndo: “Tu ìyo nda ndyo'o, chà'a ndo tu'un cha'a' ma veñu'u Ndioo ña ni ja'a ndo iin tiñu, töve kùuni yi ka'an yi ña ìyo yi ña ja'a ndicha ndo ma ña kà'an ndo. Va tu chà'a ndo tu'un cha'a' ma oro ña ka'ìin ma tichi veñu'u, va yakan, ìyo yi ña ja'a ndo”, kàti ndo chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ndyo'o ndra tüvi chìto, ña kùu ndo takua kùu ma ndian kuaá! ¿Nda ña kùu ma ña ka'nu ga kùuni ndo: a ma oro, a ma veñu'u jà'a ña na ndakuu ií yi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta juuni kà'an ndo te'en ndia: “Tu ìyo nda ndyo'o, chà'a ndo tu'un nuu ñivi va cha'a' ma chito naá ña ìyo kuenda Ndioo, töve kùuni yi ka'an yi ña ìyo yi ña jàchinu ndicha ndo ma ña kà'an ndo. Va tu chà'a ndo tu'un nuu na cha'a' ma ña soko ñivi chata ma nuu naa, ikan kuuni yi ka'an yi, va ìyo yi ña jachinu ndo yi”, kàti ndo chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ndyo'o ndra tüvi chìto, ña kùu ndo takua kùu ma ndian kuaá! ¿Nda ña kùu ma ña ka'nu ga kùuni ndo: a ña sòkó ma ñivi, a ma chito naá ña jà'a ña na ndakuu ií yi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ma ndian chà'a tu'un cha'a' iin nakuyi nuu ma chito naá, yöve uvaa kuenda maani yi chà'a na tu'un, vati juuni kùu yi kuenda ndisaa ma ña ka'ìin nuu yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ta ma ndian chà'a tu'un cha'a' iin nakuyi kuenda ma veñu'u ka'nu, yöve uvaa kuenda maani yi chà'a na tu'un, vati juuni kùu yi kuenda ma Ndioo ra ìyo ikan ndia. ");
INSERT INTO mza_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ta ma ndian chà'a tu'un cha'a' iin nakuyi kuenda ma andivi, yöve juuni uvaa kuenda maani yi chà'a na tu'un, vati juuni kùu yi kuenda ma tayu ka'nu nuu chà'nda Ndioo tiñu, ta kuenda ma Ndioo ra chàtiñu yi ndia. ");
INSERT INTO mza_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Nda'vi ta'an ndyo'o, ndra kùu matru ña jàkua'a tutu ley Ndioo, chi'in ndyo'o ndra fariseu ndra uvi nuu kua chànini! Vati ndyo'o kùu ndo ña sokó ndo uchi porcientu ma ña vixi chà'an kuenda Ndioo, takua kùu ma xiko ani, chi'in ma cominu, va na töve jàchi'in ndo ña kà'an ma tu'un ka'nu ga ña jàna'a ma ley Ndioo, ña ìyo yi ña ja'a ndo, takua kùu ma ña, ìyo yi ña koo ndaa ndo kuenda Ndioo, ta kunda'vini ndo, ta chinuni va'a ndo ma tu'un ra. Ña'a kùu ma ña ìyo yi ña ja'a ndo, ta töve jàña ndo ña jà'a ndo ma inga tuku ma ña kà'an ma Ley Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ndyo'o ndra kùu takua kùu ndian kuaá ña jàna'a nuu ma ñivi, ndyo'o jàchinu ndo ma ña vali ña töve ndakuenda, ta töve jà'a ndo ma ña ndicha ña ìyo kuenda! ");
INSERT INTO mza_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Nda'vi ta'an ndyo'o matru ña jàkua'a tutu ley Ndioo, chi'in ndyo'o ndra fariseu ndra uvi nuu kua chànini! Vati ndyo'o kùu ndo takua kùu ma yachin, chi'in ko'o ña chàtiñu ndo, ti chàta'ani ndo nakata ndo iti' chatani yi, va ma tichi yi, nduva'a ìyo ma ña kini jà'a ña kasu'u ndo, ta inga tuku ma ña kini jà'a ndo. ");
INSERT INTO mza_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Ndyo'o ndra fariseu ña kùu takua kùu ndian kuaá: ji'na ìyo yi ña nakata ndo iti' tichi ma yachin, chi'in ma ko'o, tajan takan, ni kindoo va'a ndio ndo kuenda Ndioo! ");
INSERT INTO mza_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Nda'vi ta'an ndyo'o matru ña jàkua'a tutu ley Ndioo, chi'in ndyo'o ndra fariseu ndra ìyo uvi nuu! Vati kùu ndo tava kùu ma nuu ñaña, ña vii kàa yi ña kā'yu iti' chata yi chi'in ña kuichin, va iti' tichi yi endee chitu yi chi'in mamaa iki ma ndian ndií, ta chi'in ndisaa inga nuu ma ña kini. ");
INSERT INTO mza_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ndyo'o takan kùu ndo, vati ma iti' chata ndo, kàa yi takua kàa ma ndian va'a kuenda ma ñivi, va ma iti' tichi kuñu ndo endee chìtu yi chi'in ña kini, ta chi'in ña töve va'a. ");
INSERT INTO mza_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Nda'vi ta'an ndyo'o matru ña jàkua'a tutu ley Ndioo, chi'in ndyo'o ndra fariseu ndra uvi nuu! Ndyo'o kùu ndo ña jàva'a ndo nuu ñaña kuenda ma ndra kā'an chi'in tu'un yu'u Ndioo, ta vii jàva'a ndo nuu ñaña ma ndian kūu ndian va'a ta ndaa. ");
INSERT INTO mza_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ta juuni maa ndo kà'an ndo te'en: “Tu ndyu'u chīyo ndi ma ora chīyo ma ndian kūu ñivi ndi niku, töve ni kuta'an ndi chi'in na, ña ka'ni ndi ma ndra kā'an chi'in tu'un yu'u Ndioo niku”, kàti ndo. ");
INSERT INTO mza_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chi'in ña'a jàna'a ndo, ña juuni maa ndo chà'a ndo kuenda, ña ma ñivi ndo kùu ma ndian chà'ni ma ndra kā'an chi'in tu'un yu'u Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Va'ani, na jachinu ndo jà'a ndo ma ña kīcha'a ma ndian kūu ñivi ndo jà'a na niku, tuva takan! ");
INSERT INTO mza_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Ndyo'o tatá ndian xaan, takua xaan ma koo kaa! ¿Chïto naja kua kùu kakú ndo nuu ma tundo'o ña ni nde'e ndo andaya'? ");
INSERT INTO mza_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cha'a' ña'a kùu yi ña ni tachi̱ ma ndra ni ka'an chi'in tu'un yu'u Ndioo nuu ndo, chi'in ndra chìto ña kà'an, ta matru ña jàkua'a tutu Ndioo. Va ndyo'o, ìyo ndra ni ka'ni ndo, ta ni takaa ndo nuu kruu, ta ìyo inga ndra ña ni kani ndo ma tichi ma veñu'u kuati ma ñivi judíu, ta ni kakunuu ndo nànduku ndo ndra, ta ñuu, ta ñuu. ");
INSERT INTO mza_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ta takan kùu yi ña, chata ndo ni koyo ma tundo'o, cha'a' ña chā'ni ndo ndisaa ma ndra va'a, nda ma Abel, ra chīyo ndaa nuu Ndioo, ta nda Zacaría, se'e ma ra chūnani Berequías, ra chā'ni ndo ma tichi veñu'u ka'nu, yati nuu ndaa ma chito naá. ");
INSERT INTO mza_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ndicha va'a ña kà'in chi'in ndo, ña cha'a' ndisaa ma kuati i'ya, ma tundo'o ni koyo yi chata ma ñivi ìyo vitin. ");
INSERT INTO mza_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén, Jerusalén, ndyo'o ña chà'ni ndo ma ndra kà'an chi'in tu'un yu'u Ndioo, ta juuni chà'ni ndo chi'in yuu, ma ndra tàchi Ndioo ña kuàkatitu'un ma tu'un ra nuu ndo! ¡Nduva'a kua'a' cha'a' kūuni̱ jati'vi ta'in ndo, ta jakuendai ndo, tava jà'a ma tiatan' ora kumi ri ma tiun kuati se'e ri ma tichi ndichin ri, va töve nī kuuni ndo! ");
INSERT INTO mza_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na nde'e ndo, ña vitin, cha jāña ndio ma Racha'nu Ndioo ndo ña na ja'a maa ndo nda ña kùuni ndo vitin. ");
INSERT INTO mza_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Vati yu'u kà'in chi'in ndo, ña na tüva ni nde'e ndo yu'u, nda kati ni keta ma tiempu, ña ni ka'an ndo te'en: “Ma ra ya'a ga ií kùu ma ra vàchi, chi'in sivi ma Racha'nu Ndioo”, kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Takan kūu ta ora kēe ndio Jesuu ma tichi veñu'u ka'nu, ña cha kuà'an ra, ora ikan chājayatin ma ndra jàkua'a chi'in ra ndra nuu ndaa ma veñu'u ka'nu, ta kīcha'a ndra kà'an ndra ña ya'a ga vii kūva'a ma veñu'u. ");
INSERT INTO mza_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Va Jesuu te'en nāka'an ra chi'in ndra: ―Ta, ¿a ndè'e ndo ña ya'a vii kūva'a yi? Ndicha va'a ña kà'in chi'in ndo, ña ni chaa iin kivi, ña nï'iin ga ma yuu na tüva ni kindoo yi ma chata ta'an yi, vati kikoyo ndi'i yi ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tajan kēe ndio Jesuu chi'in ma ndra jàkua'a chi'in ra kuà'an ndra ma iti' iin yuku nàni Olivu. Ta ora nàndi Jesuu ma ikan, tajan chājayatin ma ndra jàkua'a chi'in ra nuu nandi ra, ta te'en chīkatu'un xe'e ndra nuu ra: ―Kùuni ndi ña na katitu'u̱n nuu ndi, nda ora ni kuu ma ña kā'un. ¿Nda seña kùu ma ña ni nde'e ndi, ora ni kichi ndikoun, ta nda ora ni naa ma ñuñivi ndia? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Na ja'a ndo kuenda nuu ndo, ta koto kü'va ndo ña kēña'a nï'iin ñivi ndo. ");
INSERT INTO mza_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vati ni keta kua'a' ñivi, ña ni jaya'a na na chi'in sivi̱, ta te'en ni ka'an na: “Yu'u kùu Cristu”, ta takan ni janda'viña'a na kua'a' ñivi. ");
INSERT INTO mza_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ta ndyo'o ni kunitu'un ndo, ña ìyo kuati ma ñuu i'ya ta inga ñuu. Va na yü'vi ndo, vati takan ìyo yi ña kuu yi, va na yöve nuu ni ndi'i ma ñuñivi kùu yi. ");
INSERT INTO mza_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vati ni kanita'an iin ñuu, chi'in inga ñuu, ta inga tuku ñuu chi'in inga tuku yi, ta ni koo tama', chi'in kue'e, ta juuni ni kichi ña ni taan kuàni'i va'a ndisaa ñuñivi ndia. ");
INSERT INTO mza_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tandi'i ma ña ni kuu i'ya, kùu ma nuu já kìcha'a ma ñivi nde'e na tundo'o. ");
INSERT INTO mza_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ta ikan jan, ni ku'va ndio na ndo nda'a' ma ndian ni jande'e tundo'o ndo, ta ndiakan ni ka'ni na ndo, ta ndisaa ma ñivi ìyo ñuñivi i'ya, ni kuxaani na nde'e na ndo cha'i. ");
INSERT INTO mza_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma tiempu ikan, kua'a' ñivi ni jaña na ña chìnuni na ma tu'un Ndioo, ta ni kuxaani na nde'e na juuni ma ta'an na ña chìnuni, ta ni xikoña'a na na ndia. ");
INSERT INTO mza_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta ni keta kua'a' ma ndra vata, ña ni ka'an ndra, ña kùu ndra, ndra kà'an chi'in tu'un yu'u Ndioo, ta takan ni keña'a ndra kua'a' ñivi. ");
INSERT INTO mza_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ta ni koo kua'a' kuati, ta chi'in yakan, kua'a' ñivi ni jaña na ña kùuni na nde'e na ma tiaga na. ");
INSERT INTO mza_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Va ma ndian ni kundeeni koo va'a na chi'in ma ña chìnuni na nda kati ya'a ma kivi ikan, ni jakakú ma Ndioo na. ");
INSERT INTO mza_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta ma tu'un va'a, ña kà'an cha'a' ma nuu chà'nda Ndioo tiñu, ni katitu'un ndian jàkutiñu nuu Ndioo yi ta ni koto tandi'i ma ñivi ìyo nuñu'u' ñuñivi yi, ta ikan jan ni kichi ndio ma ora ni naa ndio ma ñuñivi. ");
INSERT INTO mza_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ma ra kā'an chi'in tu'un yu'u Ndioo, ña nàni Daniel, tāa ra ita'vi cha'a' ma ña jà'a ña na ndokini ndo, ta jativi yi ndo. Ora ni nde'e ndo ña yakan ni chaa yi nda tichi veñu'u nuu ya'a ií ―tu ìyo nda ndyo'o jàkua'a ndo ma tu'un i'ya, na kutunini ndo yi. ");
INSERT INTO mza_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tajan nda ndian ìyo ma ñu'u' Judea, ma ora ikan, na kunu na ku'un na iti' yuku. ");
INSERT INTO mza_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ta ma ndian ka'ìin siki ve'e na, na nüu na ña tàva na nï'iin nakuyi ma tichi ve'e na. ");
INSERT INTO mza_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ta ma ndian ka'ìin jàtiñu tichi ku'u, koto chïkokani na, ña kuki'in na ja'ma na. ");
INSERT INTO mza_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Nda'vi ta'an ma ñivi ña'a, ña ma kivi ikan ñu'u se'e vi, ta juuni ndian ìyo ndiakuati se'e vi ña chàxin! ");
INSERT INTO mza_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Na ndakan ndo nuu Ndioo, ña koto tä'an ndo ña ìyo yi ña kakú ndo ma tiempu vichin jà'a yi, ta ni ma kivi nindeo. ");
INSERT INTO mza_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Vati ma tiempu ikan kùu yi, ña nduva'a ni nde'e ndo tundo'o, takua takä'an nde'e ndo yi nï'iin cha'a' nda ma ora jātuvi Ndioo ma ñuñivi, ta ni tüvi chànini ra jande'e ra tundo'o ndo takan iti' nuu ndia. ");
INSERT INTO mza_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ta tu Ndioo töve ni jandokuiti ra ma kivi ikan, nï'iin ñivi töve ni kakú niku, va ni jandokuiti ra yi cha'a' ña nduva'a kùuni ra nde'e ra ma ndian kāchin ra. ");
INSERT INTO mza_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Tajan tu kèta iin ndian kà'an te'en chi'in ndo: “Nde'e ndo ti, i'ya ndaa ma ra kùu Cristu”, a kà'an na ña: “Nde'e ndo ti, ikan ndaa ra”, na chïnuni ndo. ");
INSERT INTO mza_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vati ni keta ma ndra ni janda'viña'a, ña ni jaya'a ndra ndra ña kùu ndra Cristu, ta ndra kà'an ña kùu ndra, ndra kà'an chi'in tu'un yu'u Ndioo, va töve ndicha. Ndrakan ni ja'a ndra kua'a' ndatu, ta seña nuu ndo, kuenda ña janda'viña'a ndra ndo. Ta nda ma ndian kāchin Ndioo ni janda'viña'a ndra na ndia, tuva kùu ja'a ndra takan. ");
INSERT INTO mza_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yu'u cha kātitu'in yi nuu ndo antea ña kùu yi. ");
INSERT INTO mza_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yakan va, tu kà'an na te'en chi'in ndo: “Nde'e ndo ti, ikan ndaa ra tichi ku'u”, na kü'un ndo. Ta tu kà'an na te'en chi'in ndo: “Nde'e ndo ti, ma tichi ve'e i'ya indii xe'e ra”, koto chïnuni ndo ña kà'an na. ");
INSERT INTO mza_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Vati ma tava jà'a ma ña xi'í, ña ndichin nde'o yi nda iti' kèta nikandii, ta iti' chìso yi, takan ni nde'o ma ra Se'e ñivi ora ni kichi ndiko ra. ");
INSERT INTO mza_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ta ma nuu kàndii kuñu ma ndian chī'í, ikan ni nde'o ña kùti'vi ma chii. ");
INSERT INTO mza_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ta ora cha yā'a ma tiempu ña ni nde'e ndo tundo'o. Tajan ni nda'va ma nikandii chi'in ma yoo. Ta ma chele ña ka'ìin andivi, ni kuita ndri, ta ni taan ninii ka'nu ma andivi jà'a ndri. ");
INSERT INTO mza_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tajan ni nde'e ndo iin seña ña ni ja'a yu'u ra Se'e ñivi iti' andivi, ta ikan jan, tandi'i ma ndian ìyo ninii ka'nu nuñu'u' ñuñivi ni kuaku na jà'a ña yu'vi na ora ni nde'e na ña vàchi nuu ma ra Se'e ñivi tañu vikó, chi'in tacha ra chi'in kua'a' ndatu ra. ");
INSERT INTO mza_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta ni tachi̱ ma tati va'a ña jàkuu tiñu nuu Ndioo, kuenda ña na tivi na ni'i va'a chi'in ma yutun tivi, ikan na kuti'vi ndisaa ma ndian kāchi̱n, ña ìyo ninii ka'nu ma nuñu'u' ñuñivi. ");
INSERT INTO mza_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Na nde'e ndo naja kua ja'a ma yutun higu: Ora kèta ma soko yuta' ndrun, ta nàka'ndi ma nda'a' ndrun, ikan chà'a ndo kuenda ña cha vàchi kuyatin ma tiempu savi. ");
INSERT INTO mza_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ta takan kùu yi chi'in ma ña'a ndia, ora ni nde'e ndo yi, tajan ni ku'va ndio ndo kuenda ña cha vàchi kuyatin ora ni kichaa yu'u, ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ndicha va'a ña kà'in chi'in ndo, ña tandi'i ña kà'in i'ya, ni kuu yi antea ña kùvi ma ñivi ìyo tiempu i'ya. ");
INSERT INTO mza_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ma andivi chi'in ma nuñu'u', ni chaa tiempu ña ni naa yi, va ma tu'un kà'in, töve ni naa yi. ");
INSERT INTO mza_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Va ma kivi ni naa ñuñivi, ta ma ora ni kuu yi, nï'iin yo töve chìto, ni ma ndian kùu tati jàkuu tiñu nuu Ndioo andivi, ta ni yu'u, ra kùu Se'e ra. Uvanuu ma Ndioo Tatá yo kùu ma ra chìto yi. ");
INSERT INTO mza_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Tava kūu yi ma tiempu chīyo Noé, juuni takan ni kuu yi ma ora ni kichi ndiko yu'u ra Se'e ñivi. ");
INSERT INTO mza_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ma tiempu ikan, antea ña kuun ma savi ka'nu, ma ñivi kàchachi na, kàchi'i na, tànda'a na, ta juuni chà'a na ñivi ña'a se'e na ña na tanda'a na, nda kati kēta kivi ña kī'vi Noé ma tichi varku. ");
INSERT INTO mza_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ta takan kūu yi ña jàna'ini na ora koyo ma savi ka'nu chata na, ta nāndaa ma takuii ta tāni na. Takan ni kuu yi, ma ora ni kichi ndiko ma ra Se'e ñivi. ");
INSERT INTO mza_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma kivi ikan, uvi ndra'ii, ña ka'ìin jàtiñu ndra nuu ñu'u' ndra, iin ra ni ku'un chi'i̱n, ta inga ra ni kindoo. ");
INSERT INTO mza_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ta uvi ñivi ña'a, ña ka'ìin katu, iin ña ni ku'un ña chi'i̱n, ta inga ña ni kindoo. ");
INSERT INTO mza_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Yakan va na koo tu'va ndo, vati töve chìto ndo nda ora ni kichaa ma Racha'nu. ");
INSERT INTO mza_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Va kùuni̱ ña na koto ndo iin ña ni kà'in chi'in ndo, tu iin ra xuve'e, chìto ra nda ora kùu yi ña ni koyo ma ndra su'u ve'e ra ma chanikuaa, ni kundito ra, ta töve ku'va ra ña kì'vi ma ndra su'u ve'e ra, ta kàsu'u ndra. ");
INSERT INTO mza_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yakan va ndyo'o, juuni takan ìyo yi ña koo tu'va ndo, vati ma ra Se'e ñivi, ni kichi ra ma ora töve ndàtu ndo ña ni kichi ra. ");
INSERT INTO mza_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Nda ra kùu ma musu va'a ta yati?, kùuni ndo. Ma ra ndākoo chito'o ra tiñu nuu, ña na jàkachi ra ndisaa ma ndian jàtiñu kuenda chito'o ra, ta chà'a ra yi ma ora ìyo yi ña ku'va ra yi. ");
INSERT INTO mza_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Na sii kuuni ma ra musu, ña ora chàa ma ra kùu chito'o ra ve'e ra, ta nàta'an ra ra, ña jàtiñu va'a ra. ");
INSERT INTO mza_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ndicha va'a ña kà'in chi'in ndo, ña ma ra jàtiñu takan, ni ku'va ma ra kùu chito'o ra tiñu nuu ra, ña na kùu ra ma ra kuxini nuu tandi'i ma ña ìyo nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Va tu ma musu ikan kùu ra iin ra kini ta te'en kàti ra chi'in anima ra: “Ma chito'o yo na töve ni chaa numi ra, ti kùyanga ra ma nuu kuà'an ra”, kùuni ra. ");
INSERT INTO mza_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ta rakan kìcha'a ndio ra jànde'e ga ra tundo'o ma ndian kùu musu chi'in ma tiñu jà'a na, ta ndò'iin ndio ra, chàchi ra, ta chì'i ra chi'in ma ndra chì'i ndixi. ");
INSERT INTO mza_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tajan ma ora ikan, ni chaa ndio chito'o ma ra kùu musu, ma kivi töve ndàtu ra ra, ta iin ora ña töve chìto ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ta ikan jan, ni jande'e ndio ra tundo'o ka'nu ra, ta ni jaku'un ra ra iti' kuà'an ma ma ndian kini. Ta ikan kùu ma nuu ni kuaku ndio ra, ta ni kari'u ma nu'u ra, jà'a ma tundo'o ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Tajan ma nuu chà'nda Ndioo tiñu, indukuni kùu yi tava kùu ma uchi ta'an ñivi ña'a yoko, ña kī'in vi ma ñu'ú nda'a, ña chàtiñu cete, ta kēe vi chāta'an vi nuu ma ra ni tanda'a. ");
INSERT INTO mza_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","U'un ta'an ñivi ña'a kùu vi ña töve ìyo tu'va vi, ta u'un ta'an vi ìyo tu'va vi. ");
INSERT INTO mza_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ma ñivi ña'a, ña töve ìyo tu'va, ndà'a vi ma ñu'ú nda'a' kuà'an vi, va töve ndà'a vi cete kuenda ña jàkutu ndiko vi yi. ");
INSERT INTO mza_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Va ma ñivi ña'a ìyo tu'va, ndà'a vi lometa chitu ma cete, chi'in ma ñu'ú nda'a' vi ndia. ");
INSERT INTO mza_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Va tava ma ra ni tanda'a kùyanga ra, yakan va chāñu ndio ñuma'na nuu vi, ta ndisaa vi kākixi. ");
INSERT INTO mza_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tajan ora cha kùu yi ora java ñuu chanikuaa, te'en chīni vi iin tati ña ni'i va'a kanachaa: “¡Cha vàchi ma ra ni tanda'a, na kee ndo kichi ta'an ndo nuu ra!”, kàti ma tati ikan. ");
INSERT INTO mza_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ta ndisaa ndio ma ñivi ña'a ikan ndākoo vi, ta kīcha'a vi jàndova'a vi ma ñu'ú nda'a' vi. ");
INSERT INTO mza_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tajan ndi u'un ma ñivi ña'a, ña töve ìyo tu'va, te'en nāka'an vi chi'in u'un ta'an ma ñivi ìyo tu'va: “Na ku'va ndo ita'vi ma cete ndo nuu ndi, ti ma ñu'ú nda'a' ndi cha kīcha'a yi ndà'va yi”, kàti vi chi'in vi. ");
INSERT INTO mza_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Va ma ñivi ña'a ìyo tu'va, te'en nāka'an vi chi'in vi: “Na küu, ti na këta ra', ni kuenda maa ndi, ta ni kuenda maa ndo. Yakan va va'a ga, ña na ku'un maa ndo ma nuu kùya'vi ra', ta jàta ndo ra' kuenda ndo”, kàti vi chi'in vi. ");
INSERT INTO mza_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Va ora juuni yanga kàcha'an ma ndi u'un vi kuàjata vi ma cete, ta chāa ma ra ni tanda'a. Tajan ma ñivi ña'a, ña ìyo tu'va, kāki'vi vi chi'in ra ma tichi ve'e nuu ìyo ma viko tanda'a, ta chāsi ndio ra yuve'e. ");
INSERT INTO mza_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ta nunuuni, tajan chāa ndio ma inga u'un ñivi ña'a yoko, ta te'en nāka'an vi: “¡Racha'nu, Racha'nu, na nunaun yuve'e nuu ndi!”, kàti vi. ");
INSERT INTO mza_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Va ma ra tànda'a, te'en nāka'an ra chi'in vi: “Ndicha va'a kà'in, ña na töve nàkotoi ndo”, kàti ra chi'in vi. ");
INSERT INTO mza_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tajan Jesuu te'en nāka'an tuku ra chi'in na: ―Na koo tu'va ndo, ti töve chìto ndo, ni ma kivi, ta ni ora ni kichaa ndiko yu'u ma ra Se'e ñivi. ");
INSERT INTO mza_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ma nuu chà'nda Ndioo tiñu andivi, kùu yi tava kùu iin ma ra'ii ña ora ni kee ra ku'un ra inga ñuu, ta kāna ra ma ndra kùu musu ra, ta chā'a ra ma xu'un' ra nuu ta'ii'iin ndra ña na kumi ndra yi. ");
INSERT INTO mza_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Nuu iin ma ra kùu musu ra, chā'a ra u'un mii pesu ma xu'un', ta nuu ma inga ra chā'a ra uvi mii, ta iin mii nuu ma inga tuku ra. Ta'ii'iin ndra, chā'a ra ma xu'un' nuu ndra, naja kua kùndee ndra jàtiñu ndra yi. Tajan kēe ndio ra kuà'an chika ra. ");
INSERT INTO mza_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma musu, ra nī'i u'un mii pesu ma xu'un', jātiñu ra chi'in ma xu'un' ikan, ta jākanaa yi inga u'un mii pesu. ");
INSERT INTO mza_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ta juuni takan jā'a, ma ra nī'i uvi mii pesu ma xu'un', ta jākanaa yi inga uvi mii. ");
INSERT INTO mza_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Va ma ra nī'i iin mii, jā'a ra iin yavi ma nuñu'u', ta tīndixe'e ra ma xu'un' chā'a ma ra chà'nda tiñu nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Takan kūu ta ora yā'a kua'a' tiempu, tajan chīkoni'i ndiko ma ra chà'nda tiñu nuu ndra, ta kīcha'a ndio ra jà'a ra kuenda chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ji'na ma ra nī'i u'un mii pesu ma xu'un' chāa ra nuu ra. Ta ora chā'a ra u'un mii ma xu'un' siki yi nuu ra, ta te'en nāka'an ra chi'in ra: “Yo'o Racha'nu, u'un mii kùu ma ña chā'un nui, ta i'ya ìyo inga u'un mii ña jākanai siki yi”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tajan ma ra kuxini, te'en nāka'an ra chi'in ra: “Ya'a ga va'a jā'un yo'o musu va'a, ta ndaa. Tava kùu̱n ma ra jātiñu ndaa chi'in ita'vi ma ña chā'i nuu̱n, vitin ni ku'va ndioi tiñu nuu̱n, ña na jakuendaun nduva'a ga kua'a' yi. Na ki'viun ma nuu ìyoi, ta sii kuuniun chi'i̱n”, kàti ma racha'nu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ta ora yā'a, tajan chāa ndio inga musu, ra nī'i uvi mii pesu ma xu'un' ma nuu ra, ta rakan te'en nāka'an ra: “Yo'o Racha'nu, uvi mii kùu ma ña chā'un, ta i'ya ìyo inga uvi mii ña jākanai siki yi”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ta ma ra kuxini, te'en nāka'an ra chi'in ma musu ikan: “Ya'a ga va'a jā'un yo'o musu va'a, ta ndaa. Tava kùu̱n ma ra jātiñu ndaa chi'in ita'vi ma ña chā'i nuu̱n, vitin ni ku'va ndioi tiñu nuu̱n, ña na jakuendaun nduva'a ga kua'a' yi. Na ki'viun ma nuu ìyoi, ta sii kuuniun chi'i̱n”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Va ora chāa ndio ma musu, ra nī'i iin mii pesu ma xu'un'. Ta rakan te'en nāka'an ra chi'in ma ra kùu chito'o ra: “Yo'o Racha'nu, cha chìtoi ña iin ra nduva'a ndava kùu̱n, vati chàta'aniun ndaki'un ma nuu töve nī tachiun, ta nàkuisoun ma nuu töve kuii nī jatiñu. ");
INSERT INTO mza_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yakan va yū'vi̱, ta chātixe'i ma xu'un' tichi ñu'u'. Va na näkaniniun, vati i'ya ìyo ma xu'un' ña chā'un nui”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tajan ma ra kùu chito'o, te'en nāka'an ra chi'in ma musu ra: “Yo'o musu kini, ta suchan, tu cha chìtoun ña yu'u ndàki'i̱n ma nuu töve nī tachi̱, ta nàkuisoi ma nuu töve jāndova'i, ");
INSERT INTO mza_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿ta naja töve nī chati'un ma xu'in tichi vanku, ikan ma ora kichai, ta yu'u ndaki'in ndikoi ma xu'in chi'in siki yi niku, tuva takan?” ");
INSERT INTO mza_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","’“Na namaa ndo ma iin mii ikan nuu ra, ta ku'va ndo yi nuu ma ra nda'a uchi mii. ");
INSERT INTO mza_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Vati ma ndian ìyo yi nuu, ni ku'vai tiá ga yi nuu na, ña ndava ni kukoso yi. Va ma ndian töve yi nuu, nda ma ña ita'vi ìyo nuu na, ni namaa yi. ");
INSERT INTO mza_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ta ma ra musu kini i'ya, na tava ndo ra nuke'e, nuu naa, vati ikan kùu ma nuu ni kuaku ra, ña ndava ni kari'u ma nu'u ra.” ―Takan kàti Jesuu chi'in ma ñivi ikan. ");
INSERT INTO mza_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ora ni kichaa yu'u, ra Se'e ñivi, ña ni ka'ndai tiñu, endee ni chikonuu ndisaa ma tati jà'a tiñu nuu Ndioo yu'u, ta ni kunandi̱ ma tayu ka'nu nuu tà'nda tiñu, ta nuu ìyo kua'a' ña tachai. ");
INSERT INTO mza_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ndisaa kuii ma ñivi ìyo ñuu ñuñivi, ni kuti'vi na nuu ra, ta rakan ni tavani'i siin ra na xiin ma inga na, tava jà'a ma ra kùu pato, ña tavani'i siin ra ma mvechala xiin ma tixu'u. ");
INSERT INTO mza_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ta ikan jan ma mvechala, ni taan ra ndri chiyo kua'a ra, ta ma ma tixu'u chiyo satin ra. ");
INSERT INTO mza_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tajan ma ra kùu Rey, te'en ni ka'an ra chi'in ma ndian ka'ìin chiyo kua'a ra: “Na kichi ndyo'o ndian cha jā'ií ma Tatái nui, ikan na ndaki'in ndo ma nuu ta'nda tiñu, ña cha ìyo va'a kuenda ndo jā'a ma Ndioo, nda ora jātuvi ra ma ñuñivi. ");
INSERT INTO mza_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Vati ora chāñu soko yu'u, ta ndyo'o chā'a ndo ña chāchi, ta ora nātii takuii, ta chā'a ndo ra' chī'i̱, ora chākunui tava chàkunuu ma ndian inga ñuu, ta chā'a ndo ve'e nuu kīndoi. ");
INSERT INTO mza_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ora kūmani ja'ma ku'in, ta ndyo'o chā'a ndo yi, ora kū'vi̱, ta chānde'e ndo yu'u, ta ora chūndii̱ vekaa, ta kīchi nde'e ndo yu'u.” ");
INSERT INTO mza_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tajan ma ndian kùu ndian va'a, te'en ni ndakatu'un na nui: “Yo'o Racha'nu, ¿nda ora ndē'e ndi ña chīsokoun, ta chā'a ndi ña chāchun? ¿Nda ora ndē'e ndi ña nātíiun takuii, ta chā'a ndi ra' chī'un? ");
INSERT INTO mza_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿A nda ora ndē'e ndi ñu̱n ña chākunuu̱n tava chàkunuu ma ndian inga ñuu, ta chā'a ndi ve'e nuu kīndoun? ¿A nda ora kūmani ja'maun, ta chā'a ndi yi nuu̱n ndia? ");
INSERT INTO mza_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿A nda ora ndē'e ndi ñu̱n ña ku'viun, a ña indiun vekaa, ta chānde'e ndi ñu̱n?”, ni kati na. ");
INSERT INTO mza_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tajan ma ra kùu Rey, te'en ni ka'an ra chi'in na: “Ndicha va'a ña kà'in chi'in ndo, ña ndisaa ma ña jā'a ndo cha'a' ma ndian yani ya'a nda'vi ña ka'ìin i'ya, kuenda yu'u jā'a ndo yi”, ni kati ra chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Tajan te'en ni ka'an ndio ma ra kùu Rey, chi'in ma ndian ka'ìin chiyo satin ra: “Na kundachiyo ndo xii̱n, ndyo'o ndian kini, ta ku'un ndo indeeni ma andaya', ña cha ìyo va'a kuenda ndo, kuenda ma kui'na, ta kuenda ma tati xaan ña jàkuu tiñu nuu ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Vati ora chāñu sokoi, ta ndyo'o, töve nī cha'a ndo ña kachi, ora nātii takuii niku, ta töve nī cha'a ndo ra' ko'i. ");
INSERT INTO mza_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ora chākunui tava chàkunuu ma ndian inga ñuu, ta ndyo'o, töve nī cha'a ndo ve'e nuu kìndoi. Ora kūmani ja'mai, ta ndyo'o, töve nī cha'a ndo yi, ora kū'vi̱, ta chūndii̱ vekaa, ta töve nī chande'e ndo yu'u”, ni kati̱ chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tajan ndiakan, te'en ni ka'an ndio na: “Yo'o Racha'nu, ¿nda ora ndē'e ndi ñu̱n, ña chìsokoun, a ña nàtiun takuii, a ña chàkunuu̱n tava chàkunuu ra inga ñuu, a ña kùmani ja'maun, a kù'viun, a ña indiun vekaa, ta töve nī tindee ndi ñu̱n?”, ni kati na. ");
INSERT INTO mza_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tajan ma ra kùu Rey, te'en ni ka'an ra chi'in na: “Ndicha va'a ña kà'in chi'in ndo, ña ndisaa ma ña töve nī kuuni ndo ja'a ndo, cha'a' ma ndian yani nda'vi ña ka'ìin i'ya, kùuni yi ka'an yi, ña ni kuenda yu'u nī ja'a ndo yi ndia”, ni kati ma ra kùu Rey chi'in na. ");
INSERT INTO mza_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ta ikan jan ndiakan ni ku'un ndio na ma nuu ni nde'e na tundo'o ndisaa tiempu, ta ma ndian va'a, ni ku'un na, nuu ni koo na indeeni chi'in Ndioo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Takan kūu ta ora chīnu kā'an Jesuu ndisaa ma tu'un i'ya, tajan te'en nāka'an ndio ra chi'in ma ndra chàkunuu chi'in ra: ");
INSERT INTO mza_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ndyo'o, cha chìto ndo ña tichi uvi kivi, kùu ma viko Pakua, ta yu'u ra Se'e ñivi tāchi Ndioo, ni ku'va na yu'u nda'a' ñivi, ña na takaa na yu'u nuu kruu ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma tiempu ikan, ma ndra kùxini nuu sutu, chi'in ma ndra matru ña jàkua'a tutu ley Ndioo, ta chi'in ma ndra cha'nu ña kuxini nuu ma ndian judíu, kūti'vi ndra nuke'e ve'e Caifás, ra kùxini nuu sutu. ");
INSERT INTO mza_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ikan kùu ma nuu nātu'un ta'an ndra naja kua ìyo yi ña janda'viña'a ndra Jesuu, ta tiin ndra ra, ta ka'ni ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Va te'en kīcha'a ndra kà'an ndra: ―Na küu ka'nio ra ma tichi viko, koto ya'a nandiki ma ñivi jà'a yo, ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesuu ìyo ra ñuu Betania, ve'e ra nàni Simón, ra ku'vi jà'a kue'e ta'yu niku. ");
INSERT INTO mza_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tajan chājayatin iin ña'a nda'a iin viru ma takuii xikó, ña ya'a vii chà'an, ta ya'a ya'vi ndaa nuu ma Jesuu, ta jākuti ña ma xini ra nuu nàndi ra mesa. ");
INSERT INTO mza_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ora ndē'e ma ndra chàkunuu chi'in ra ña kūu, ta te'en kīcha'a ndra kà'an ta'an ndra ña kùxaan ndra: ―¿Ta naja jātivi ña ma takuii xikó ikan? ");
INSERT INTO mza_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kùu xiko ya'vi ña ra', ta ni'i ña kua'a' xu'un', kuenda ña tìndean ma ndian nda'vi niku ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Va Jesuu chīni ra ña kà'an ndra, ta te'en nāka'an ra chi'in ndra: ―¿Ta naja kà'an ndo chata ma ña'a i'ya? Ma ña jā'a ña chi'i̱n i'ya, iin ña va'a kùu yi kuendai. ");
INSERT INTO mza_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vati ma ndian nda'vi, endee ni koo na chi'in ndo, va yu'u, töve endee ni koi chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma ña jā'a ma ña'a i'ya, ora jākutian ma takuii xikó i'ya yu'u kùu yi, ña jāndova'a ña ma kuñui kuenda ma ora ni kuchi na yu'u. ");
INSERT INTO mza_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ndicha va'a, ña kà'in chi'in ndo, ña nda nikuuni nuu ni katitu'un na ma tu'un va'a cha'i, ta ninii ka'nu ñuñivi, juuni ni natu'un na, ña jā'a ma ña'a i'ya, kuenda ña na kuku'uni na ña. ");
INSERT INTO mza_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tajan tañu ma ndi uchi uvi, ndra jàkua'a chi'in Jesuu, iin ra nàni Juda Iscariote, kēe ra chāka'an ra chi'in ma ndra kuxini nuu sutu, ");
INSERT INTO mza_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ta te'en nāka'an ra chi'in ndra: ―¿Naja tia'vi ndo yu'u, ta ku'vai ma Jesuu nuu ndo? ―kàti ra chi'in ndra. Tajan ndrakan tīa'vi ndra chi'in oko uchi ma xu'un' plata. ");
INSERT INTO mza_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tajan nda ma ora ikan kīcha'a ma Juda nànduku ra naja kua jà'a ra, ta ku'va ra Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ma kivi nunuu, ora ìyo ma viko ña chàchi na paan ña töve kì'vi yuchan iya tichi, tajan ma ndra chàkunuu chi'in Jesuu chājayatin ndra ndra nuu ra, ta te'en chīkatu'un ndra nuu ra: ―¿Ndanu kùuniun ña kuja'a ndi, ña kùxini yo ma kivi viko Pakua? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Kuà'an ndo ma tichi ñuu ka'nu ikan, nuu ìyo ve'e iin ra'ii, ta te'en ka'an ndo chi'in ra, ña kà'an yu'u ra kùu Matru ndo: “Cha vàchi kuyatin ma orai, ta ma ve'un, ni kuxini ndi ma viko Pakua chi'in ma ndra jàkua'a chi'i̱n.” Takan kà'in, kati ndo ma chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tajan ma ndra jàkua'a chi'in Jesuu, jā'a ndra ma takua kā'an ra chi'in ndra, ta jā'a ndra ma ña ni kuxini ndra ma viko Pakua. ");
INSERT INTO mza_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ta ora kuaa ndio, tajan chūnandi ndio Jesuu mesa chi'in ndi uchi uvi ma ndra chàkunuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ta ora juuni yanga ka'ìin ndra kàchachi ndra, ta Jesuu, te'en nāka'an ra chi'in ndra: ―Ndicha va'a, ña kà'in chi'in ndo, vati iin ndo ni xikoña'a yu'u ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tajan nduva'a kuii nda'vi kūuni ndra, ta te'en kīcha'a ndio ta'ii'iin ndra chìkatu'un ndra nuu Jesuu: ―Racha'nu, ¿a yu'u kùi? ―kàti ndra ma ta'ii'iin ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ta Jesuu te'en nāka'an ra: ―Iin ra chàchi chi'i̱n ma tichi iin ko'oni, rakan kùu ma ra ni xikoña'a yu'u. ");
INSERT INTO mza_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ma ra Se'e ñivi, kuà'an ra ma iti' ìyo yi ña ku'un ra, takua kà'an yi nuu ma tutu Ndioo. Va ¡nda'vi ta'an ma ra ni xiko ña'a cha'a ra! Va'a ga, ña tu töve nī chakoo ni ra niku ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tajan ma Juda, ra ni xikoña'a ra, te'en nāka'an ra chi'in ra: ―Matru, ¿a yu'u kùi? ―kàti ra. Ta Jesuu te'en nāka'an ra chi'in ra: ―¡Maun cha kā'an yi! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ta ora juuni yanga ka'ìin ndra kàchachi ndra, tajan kī'in ndio Jesuu ma paan, ta chā'a ra ta'vindioo nuu Ndioo cha'a' yi, ta chā'nda java ndio ra yi, ta te'en nāka'an ra ora chā'a ra yi nuu ma ndra jàkua'a chi'in ra: ―Na tiin ndo yi ta kàchi ndo yi, ti ña'á kùu ma kuñui ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ta ikan jan, tīin ndio ra iin copa vinu, ta chā'a ra ta'vindioo nuu Ndioo cha'a' yi, ta te'en nāka'an ra chi'in ndra ora chā'a ra' yi nuu ndra: ―Na ko'o ndisaa ndo ma ña ka'ìin tichi copa i'ya, ");
INSERT INTO mza_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","vati ña'á kùu ma nii̱, ña chani kati̱, ña kùuni yi ka'an yi, ña cha ìyo va'a ma tu'un chaa ña chā'a Ndioo nuu ndo, ta juuni kùu yi kuenda ña na jàka'nuni Ndioo kuati kua'a' ñivi. ");
INSERT INTO mza_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Va yu'u kà'in chi'in ndo, ña na tüva ni ko'i ma vinu uva i'ya, nda kati chāa ma kivi ña ni ko'i ma vinu chaa chi'in ndo, nuu chà'nda ma Tatái tiñu. ");
INSERT INTO mza_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Takan kūu ta ora yā'a chīta ndra ma yaa Ndioo, ta kēe ndio ndra kuà'an ndra iti' yuku nàni Olivu. ");
INSERT INTO mza_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Ndisaa ndo, ni kukanuu ndo nde'e ndo yu'u ma chanikuaa vitin. Vati nuu ma tutu Ndioo, te'en kà'an yi: “Ni ka'ni̱ ma ra kùu chito'o ma mvechala, ta ndisaa ndri, ni kuita kuati”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Va ma ora cha nātaku ndikoi, ji'nai ni ku'un iti' ñu'u' Galilea, kua maa ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tajan ma Petu' te'en nāka'an ra chi'in Jesuu: ―Vaji ndisaa ndra ni kukanuu ndra nde'e ñu̱n, va yu'u, töve ―kàti ma Petu'. ");
INSERT INTO mza_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tajan Jesuu te'en nāka'an ra chi'in ra: ―Ndicha va'a ña kà'in chi'un, ña juuni ma chanikuaa i'ya, uni cha'a' ni ka'un ña töve nàkotoun yu'u antea ña nda'yu ma lo'o ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ta ma Petu' te'en nāka'an ra chi'in ra: ―Vaji ìyo yi ña kuvi̱ chi'un, töve ni ka'in ña töve nakotoi ñu̱n ―kàti ma Petu'. Ta juuni takan kā'an ndisaa ma ndra chàkunuu chi'in Jesuu ndia. ");
INSERT INTO mza_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Takan kūu tajan chāa ndio Jesuu, chi'in ma ndra jàkua'a chi'in ra, ma nuu nàni Getsemaní, ta te'en nāka'an ra chi'in ndra: ―Na kunandi ndo kuatu ndo yu'u i'ya, juuni yanga kuàka'in chi'in Ndioo ikan ―kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta chāka ra ma Petu', chi'in ninduvi ma ndra se'e Zebedeu, ta kīchi ndio ña nduva'a kuii nda'vi kūuni ra, ta yā'a nàkanini ra. ");
INSERT INTO mza_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tajan te'en nāka'an ra chi'in ndra: ―Ya'a ga nda'vi kùuni ma animai cha'a' ña ni kuvi̱. Kindoo ndo i'ya, ta na kondito ndo chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tajan Jesuu kēe ra kuà'an ra ita'vi tiá iti' nuu, ta chūnandi chiti ra, ta jānani ra te'e nuu ra nuñu'u', ta te'en nāka'an ra chi'in Ndioo: ―Yo'o ra kùu Tatái, tuva kùu ja'un yi, na jakakun yu'u nuu ma tundo'o ni nde'i. Vati na ja'un chi'i̱n takua kùuni maun ja'un ta töve takua chànini yu'u. ");
INSERT INTO mza_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tajan kēe ndiko Jesuu nuu ka'ìin ma ndra chàkunuu chi'in ra, ta nāta'an ra ndra ña cha kìxi ndra. Ta te'en nāka'an ra chi'in Petu': ―¿Ni küu kuii kundito ndo chi'i̱n, jitu iin ora? ");
INSERT INTO mza_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Na kundito ndo, ta ka'an ndo chi'in Ndioo, koto ku'va ndo anima ndo ña ja'a yi kuati. Ndicha va'a ña ma anima ndo nduva'a ìyoni yi ja'a yi ma ña va'a takua kùuni Ndioo, va ma ña kùuni ma kuñu ndo töve kùndee yi ja'a yi takan ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Cha'a' uvi kēe ndiko Jesuu kuà'an ra, ta te'en nāka'an tuku ra chi'in Ndioo: ―Yo'o ra kùu Tatái, tu küu ja'un tìndeun yu'u, kuenda ña töve nde'i tundo'o, va na kuu yi takua kùuniun ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tajan kēe ndiko ra chānde'e ra ma nuu ka'ìin ndra, ta nāta'an ndiko ra ma ndra jàkua'a chi'in ra, ña kìxi ndra ña endee küu naxi'i ma tinuu ndra jà'a ñuma'na. ");
INSERT INTO mza_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ta ndākoo ra ndra, ta kēe ndiko ra kuàka'an ra chi'in Ndioo, ma cha'a' uni, chi'in juuni ma tu'un ña cha kā'an ra. ");
INSERT INTO mza_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tajan kēe ndiko ra chānde'e ra nuu ka'ìin ma ndra chàkunuu chi'in ra, ta te'en nāka'an ndio ra chi'in ndra: ―Vitin va, na kusu ndo, ta nindee ndo, ti cha chāa ma ora ña ni ku'va ra ma ra Se'e ñivi, nda'a' ma ndra jà'a kuati. ");
INSERT INTO mza_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na ndeta ndo, ta ko'o, ti cha vàchi ma ra ni xikoña'a yu'u ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Juuni ndaa ga Jesuu kà'an ra, ora chāa ndio ma Juda, ra juuni kùu iin ma ndra uchi uvi, ña chàkunuu chi'in Jesuu, chi'in kua'a' va'a, ndra nda'a machiti, chi'in yutun. Ìyo ndra vàchi kuenda ma ndra kuxini nuu sutu, ta ìyo ndra vàchi kuenda ma ndracha'nu ma ndian judíu. ");
INSERT INTO mza_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Juda, ra xìkoña'a Jesuu, te'en chā'a ra iin seña, naja kua ni ja'a ra, ta koto ndra nda ra kùu ra: ―Ra ni tutui sitin kùu ra, ikan na tiin ndo ra ―kàti Juda. ");
INSERT INTO mza_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tajan chātu'va ndio ra nuu ndaa Jesuu, ta te'en nāka'an ra chi'in ra: ―¡Na koo va'un, Matru! ―kàti ra chi'in ra. Ta tūtu ra sitin ra. ");
INSERT INTO mza_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ta Jesuu te'en nāka'an ra chi'in ra: ―Xaa, ¿nda tiñu vàchiun? ―kàti Jesuu chi'in ra. Tajan chājayatin ndra ndra nuu ndaa Jesuu, ta tīin ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ta ma ora ikani, iin ma ndra ka'ìin chi'in Jesuu, tāva ra machiti ra, ta chā'nda ra iin chiyo so'o ma ra kùu musu ma sutu ra kuxini nuu sutu. ");
INSERT INTO mza_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tajan Jesuu te'en nāka'an ra chi'in ra: ―Na ti'i va'un ma machitiun tichi vena yi, vati tandi'i ma ndian kànita'an chi'in machiti, juuni chi'in machiti ni kuvi na ndia. ");
INSERT INTO mza_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A töve chìtoun, ña tu ndakain nuu ma Tatái, ña na tachi ra kua'a' mii ma jandaru, ña kùu tati jà'a tiñu nuu Ndioo, ña na tindee ndra yu'u, ta takan ni ja'a ra yi? ");
INSERT INTO mza_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Va tu jà'i takan, ¿naja kua jà'i, ta chinu tu'un kà'an nuu ma tutu Ndioo, naja kua ìyo yi ña kuu yi, tuva takan? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tajan juuni ma ora ikan, te'en nāka'an tuku ra nuu ma ñivi: ―¿Ta naja vàchi tiin ndo yu'u chi'in machiti, ta chi'in yutun, takua kùu iin ra su'u? Tandi'i kivi chūnandi̱ jāna'i nuu ma ñivi tañu ndo ma tichi veñu'u ka'nu, ta töve nī tiin ndo yu'u. ");
INSERT INTO mza_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Va ndisaa ña'a te'en kùu yi, ikan na chinu tu'un tāa ma ndra kā'an chi'in tu'un yu'u Ndioo nuu ma tutu Ndioo. Tajan ma ora ndisaa ndio ma ndra jàkua'a chi'in Jesuu, numini chīnu ndra kuà'an ndra, ta ndākoo ma'iin ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Takan kūu tajan ma ndra jandaru, ndra tīin ma Jesuu, ndàka ndra ra chāa ndra ve'e ma sutu cha'nu ña kuxini nuu sutu ña nàni Caifás. Ta ikan cha ka'ìin ti'vi ma ndra kùu matru ña jàkua'a tutu ley Ndioo, chi'in ma ndra cha'nu. ");
INSERT INTO mza_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Va ma Petu', tāndikun ra kuà'an ra chata Jesuu, chikani chikani, nda kati chāa ndra nuke'e ve'e ma sutu ña kuxini, ta kī'vi ra chūnandi ra ikan chi'in ma ndra jandaru, nde'o niyi ni ja'a ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tajan ma ndra sutu ña kùxini nuu sutu, chi'in ma ndra cha'nu, ta chi'in tandi'i ma ndra kumitiñu, nànduku ndra naja kua tìsokuati ndra Jesuu, vaji yöve ña ndicha kùu yi. Ta chi'in yakan kùu ka'ni ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Va nī kuu yi, vaji kua'a' ñivi kūti'vi, ta tīsokuati na Jesuu chi'in ma tu'un vata. Ta nunuuni chākoyo uvi ta'an ma ndian tīsokuati Jesuu chi'in tu'un vata. ");
INSERT INTO mza_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ta ndiakan te'en nāka'an na: ―Ra'ya, te'en kā'an ra: “Yu'u kùu ja'i janduvai ma veñu'u ka'nu Ndioo, ta tichi uni kivi kùu kani'i ndikoi yi.” Takan kā'an ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tajan ma sutu ña kùxini nuu sutu, ndēta ra, ta te'en nāka'an ra chi'in Jesuu: ―¿Ta naja töve kà'un nï'iin nakuyi? ¿Niyi kùuni na ka'an na chataun chi'in ma tu'un i'ya? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Va Jesuu tàxiin kīndoo ra. Tajan te'en nāka'an tuku ma sutu ña kuxini nuu sutu chi'in Jesuu: ―Chi'in sivi ma Ndioo ndito, kà'in chi'un, ña na ka'un ma ña ndaa. Na ka'un, tuva ndicha ña kùu̱n ma Cristu, ra Se'e Ndioo ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ta Jesuu te'en nāka'an ra chi'in ra: ―Ma takua kā'un, takan kùu yi. Ta juuni kà'in chi'in ndo, ña ni nde'e ndo ma ra Se'e ñivi, ña nàndi ra chiyo kua'a ma Ndioo ka'nu, ra ìyo ndatu, ta ni kichinuu ra tichi vikó ma iti' andivi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tajan jānakaa ndio ma sutu kuxini juuni ma ja'ma ra, ña chi'in yakan, chā'a ra ma seña, ña ya'a kayuni ra, ta te'en nāka'an ra: ―Ma tu'un ña kā'an ra'ya, iin kuati ya'a ga ka'nu kùu yi kuenda Ndioo. ¿A ìyo ga yi ña nanduku yo tia ga testigu ña kùta'an chi'in yo?, kùuni ndo. Nda maa ndo chīni ndo ma tu'un kini ña kā'an ra. ");
INSERT INTO mza_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Naja kua ndè'e ndo yi? ―kàti ma sutu kuxini. Ta ndrakan te'en nāka'an ndra: ―Ìyo kuati ra, ta ìyo yi ña kuvi ra ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tajan tīvisii ndra nuu ra, ta kāni ndra ra. Ta ìyo inga ndra kāni nuu ra ndia, ");
INSERT INTO mza_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta te'en nāka'an ndra chi'in ra: ―Yo'o, ra kà'an ña kùu Cristu, ¡na ka'un, nde'o nda yo kāni ñu̱n! ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Takan kūu ta ora juuni nàndi ga Petu' ma nuke'e, tajan chājayatin iin ña kùu musu ma sutu nuu nàndi ma Petu', ta te'en nāka'an ña nuu ra: ―Juuni yo'o kùu ma ra chàkunuu chi'in Jesuu, ra kīchi ñu'u' Galilea ―kàtian chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Va ma Petu' te'en nāka'an ra: ―Töve chìtoi nda ra kùu ma ra kà'un ―kàti ra chi'an. ");
INSERT INTO mza_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ta ma Petu', ti cha kuà'an ra ma iti' yuve'e, ña chani kee ra niku, ora ndē'e tukuan ra, ta te'en nāka'an ña chi'in ma ndra ka'ìin ikan: ―Juuni ra chàkunuu chi'in Jesuu, ra kīchi ñuu Nazaret kùu ra'ya ―kàtian chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ta ma Petu' te'en kà'an tuku ra: ―Töve nàkotoi ma ra kà'un chiña ―kàti ra chi'in ña. ");
INSERT INTO mza_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta nunuuni, tajan ma ndra ka'ìin ikan, chājayatin ndra ndra nuu ma Petu', ta te'en nāka'an ndra chi'in ra ndia: ―Ndicha va'a ña yo'o kùu iin ma ra chàkunuu chi'in Jesuu, vati chà'a ndi kuenda ña indukuni kà'un takua kà'an ma inga ndra ndia ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tajan Petu' te'en chā'a ndiko ra tu'un, ña töve nàkoto ra ra: ―Yu'u chà'i tu'un nuu ndo ndava nda nuu Ndioo, ña ndicha kuii, ña töve nàkotoi ma ra kà'an ndo ―kàti ra chi'in ndra. Ta ma ora ikani nānda'yu iin lo'o. ");
INSERT INTO mza_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tajan Petu' te'en chāku'uni ndio ra takua kā'an Jesuu chi'in ra: “Antea ña nda'yu ma lo'o, yo'o uni cha'a' ni ka'un ña töve nàkotoun yu'u.” Tajan kēe ndio ra ma ikan, ta kuà'an ndio ra ña chāku nduva'a kuii ra, ña nda'vi kùuni ra. ");
INSERT INTO mza_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ta ora kūndichin ma inga kivi, tandi'i ma ndra kùxini nuu sutu, chi'in ma ndracha'nu kuxini nuu ma ndian judíu, jāndo'iin tu'un ndra, ña naja kua jà'a ndra, ta ka'ni ndra Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tajan chū'ni ndra nda'a' ra, ta kuà'an ra chi'in ndra nuu ma Ponciu Pilatu, ra kùu kuvienu ma ñuu Roma. ");
INSERT INTO mza_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Takan kūu ta ora ndē'e ma Juda, ra xīkoña'a Jesuu, ña ni ka'ni ndio ndra ra, tajan jāchikoni'i ndiko ra, ndi oko uchi ma xu'un' plata nuu ma ndra sutu ña kuxini nuu sutu, chi'in nuu ma ndracha'nu ña kuxini nuu ma ndian judíu, ti tükuii va'a kūuni ra, ");
INSERT INTO mza_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ta te'en nāka'an ra chi'in ndra: ―Cha chìtoi, ña yu'u jā'i iin kuati ka'nu, cha'a' ña chā'i ña na kuvi iin ra töve kuati ma nuu ndo ―kàti ra chi'in ndra. Va ndrakan te'en nāka'an ndra chi'in ra: ―¡Yüva kuati ndyu'u kùu yi, ti kuati maun kùu yi! ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tajan ma Juda chōso ndio ra ma xu'un' nuu ndra ma tichi veñu'u ka'nu, ta chāka'ni maa ra ra chi'in yo'o. ");
INSERT INTO mza_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ta ikan jan ma ndra kùxini nuu sutu, jāti'vi ndra ma xu'un' ta te'en nāka'an ndra: ―Na küu taan yo ma xu'un' i'ya tichi ma chatun nuu tì'i na ma xu'un' sòkó na, vati ma ya'vi kuenda ña na kuvi iin ñivi kùu yi ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ta ikan jan jāndo'iin tu'un ndio ndra, nayi ìyo yi ña ja'a ndra chi'in ma xu'un' ikan. Tajan jāta ndio ndra iin ñu'u', ña nàni, nuu kèe ñukisi, ña jàva'a na kisi, ma chi'in yi. Ma ñu'u' ikan kùu yi, kuenda ña na koo ma nuu kuchi ndian vàchi inga ñuu. ");
INSERT INTO mza_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ta cha'a yakan kùu yi, ña nda vitin, ma ñu'u' ikan kīndoo sivi yi ña nàni yi: “Ñu'u' jāta chi'in xu'un' ndií.” ");
INSERT INTO mza_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ta takan kūu yi ña chīnu ma tu'un tāa Jeremía, ra kā'an chi'in tu'un yu'u Ndioo, vati rakan te'en tāa ra nuu ma tutu Ndioo: “Ndāki'in ndra, ndi oko uchi ma xu'un' plata, ña chīkan ma ndian ñuu Israel, kuenda ña na kuvi ra. ");
INSERT INTO mza_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ta chi'in yi, kājata ndra ma ñu'u', ña nàni nuu kèe ñukisi ña kùva'a kisi takua kā'an ma Racha'nu nui ña ìyo yi ña ja'i”, kàti ma ra kà'an chi'in tu'un yu'u Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Takan kūu tajan ndàka ndio ndra Jesuu chāa ndra nuu ma Pilatu, ra kùu kuvienu, ta rakan te'en chīkatu'un ra nuu Jesuu: ―¿A ndicha ña yo'o kùu Rey nuu ma ndian judíu? ―kàti ra. Ta Jesuu te'en nāka'an ra chi'in ra: ―Ma takua kà'un, takan kùu yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ta ora tìsokuati ma sutu ña kùxini nuu sutu ma Jesuu, ta chi'in ma ndracha'nu ña kuxini nuu ndian judíu, Jesuu endee töve nī ka'an ra. ");
INSERT INTO mza_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Takan Pilatu te'en chīkatu'un ra nuu ra: ―¿A töve chìniun, ña ya'a tìsokuati ma ñivi ñu̱n? ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Va Jesuu endee töve nī ka'an ra. Ta takan kūu yi, ña Pilatu töve chìto ra nayi jà'a ra chi'in ra, ta ndava kuà'an tati ra. ");
INSERT INTO mza_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Va'ani vitin, ma nani kuiya ora chìyo ma viko Pakua, ma kuvienu tàva ndra yo indii vekaa ma nda ra ni kuuni ma ñivi chìkan na nuu ndra, ikan na kindoo nuna ra. Takua takani jà'a ndra ma kivi viko ikan. ");
INSERT INTO mza_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma kuiya ikan indii iin ra ya'a nàkoto ñivi, ña nàni Barrabás ma tichi vekaa. ");
INSERT INTO mza_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tajan ora cha ka'ìin ti'vi ma ñivi, ta Pilatu te'en chīkatu'un ra nuu na: ―¿Nda yo kùuni ndo ña jañai, a Barrabás, a Jesuu, ra juuni kà'an ndo ña nàni Cristu ndia? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Takan kàti Pilatu, vati chā'a ra kuenda, ña chāndaka ndra ra nuu ra cha'a' ña tìxin ndra nde'e ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ta ora juuni yanga nàndi ga Pilatu ma nuu chà'nda ra tiñu, tajan te'en tāchi ma ñasi'i ra ña na kukatitu'un iin ra ma nuu ra: “Koto kï'viun chi'in ma ra va'a ikan, vati nduva'a kuii nducha chāni̱ jā'a ra.” Takan na katitu'un ra ma nuu ra, kàtian. ");
INSERT INTO mza_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Va ma ndra kùxini nuu sutu, chi'in ma ndracha'nu kuxini nuu ma ndian judíu, kūndee ndra jā'a ndra, ña na ndakan ma ñivi nuu Pilatu, ña na tava ra Barrabás, ta Jesuu, na kuvi ra. ");
INSERT INTO mza_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tajan ma Pilatu ra kùu kuvienu, chīkatu'un tuku ra nuu na: ―I'ya ka'ìin uvi ta'an ndra: ¿nda ra kùuni ndo ña jañai? ―kàti ra. Ta ma ñivi te'en nāka'an na: ―Na jañaun ma Barrabás ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ta Pilatu te'en chīkatu'un ndiko ra nuu na: ―Ta, ¿niyi ìyo yi ña ja'i chi'in Jesuu, ra kà'an ndo ña kùu Cristu?, tuva takan ―kàti ra. Ta ndisaa na, te'en nāka'an na: ―¡Na takaun ra nuu kruu! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tajan te'en nāka'an tuku Pilatu nuu ma ñivi: ―Ta, ¿nda kuati kùu ma ña jā'a ra? ―kàti ra. Va ma ñivi te'en kīcha'a ndiko na ndà'yu na nuu Pilatu: ―¡Na takaun ra nuu kruu! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ta ora ndē'e Pilatu, ña endee kà'an na takan, ta nanivaa kùu na, tajan tāchi ndio ra iin yo chāki'in takuii, ta nākata ra nda'a' ra nuu ndè'e ndisaa ñivi, ta te'en nāka'an ra: ―Yöve kuati yu'u kùu yi, cha'a' ña ìyo yi ña kuvi ra, vati kuenda maa ndo kùu yi ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta tandi'i ma ñivi, te'en nāka'an na chi'in ra: ―¡Kuati maa ndi, chi'in se'e ndi, kùu yi ña ni kuvi ra! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tajan Pilatu tāva ndio ra Barrabás, ta tāchi ra ña na kani ndra Jesuu, ta ikan jan chā'a ndio ra ra nuu ndra, ña na takaa ndra ra nuu kruu. ");
INSERT INTO mza_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Takan kūu ta ora yā'a ndio, tajan ma ndra jandaru ma kuvienu, ndàka ndra Jesuu chāa ndra ma vetiñu. Ta ikan tandi'i ma ndra kùu jandaru, kūti'vi ta'an ndra nuu ndaa Jesuu, ta chīkonuu ndio ndra ra. ");
INSERT INTO mza_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tajan tāva ndio ndra ma ja'ma ra, ta jāku'un ndra iin ja'ma kua'á ra. ");
INSERT INTO mza_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ta ikan jan jūndii ndio ndra iin korona ña kūva'a chi'in mamaa iñu ma xini ra, ta chā'a ndra iin yutun kuiin, ña na kunda'a ra ma chiyo kua'a ra. Tajan chūnandi chiti ndio ndra nuu ra, ta te'en kà'an ndra chi'in ra, ña chàtu'un ndra ra: ―¡Na koo endeeni yo'o ra chà'nda tiñu nuu ma ñivi judíu! ―kàti ma ndra jandaru. ");
INSERT INTO mza_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ta juuni tīvisii na ra, ta juuni chi'in ma yutun nda'a ra kāni ndra ma xini ra. ");
INSERT INTO mza_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Takan kūu ta ora yā'a ña chàtu'un ndra ra, tajan kīndaa ndiko ndra ma ja'ma kua'á ña jāku'un ndra ra, ta jāku'un ndiko ndra ma ja'ma maa ra ra, ta kuà'an ndio ra chi'in ndra ma nuu ni takaa ndra ra nuu kruu. ");
INSERT INTO mza_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ta ora kuà'an ndra, tajan ma tichi iti' ikan, chīkuta'an ndra iin ra ñuu Cirene, ña nàni Simón. Ra'ya kùu ra, ña jā'a ndra ña na kuiso ra ma kruu ndiso Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ta ora chāa ndra iin ñuu nàni Gólgota, ña kùuni yi kà'an yi, nuu kàndoyo kua'a' iki xini ndian chī'í. ");
INSERT INTO mza_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ikan chā'a ndra vinu ña jākanuu ndra chi'in iin ña iya ña na ko'o ra ra'. Va ora tīyaa ma Jesuu ra ra', ta ndē'e ra naja kua chì'i ra', töva ni kuuni ra ko'o ra ra'. ");
INSERT INTO mza_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Takan kūu ta ora cha tākaa ndio ndra ra nuu kruu, tajan kīcha'a ndio ma jandaru chàsiki ndra ja'ma Jesuu juuni chi'in maa ndra, nde'o nda yo chi'in kindoo yi. Ta takan kūu yi, ña chīnu ma tu'un kā'an ma ra kā'an chi'in tu'un yu'u Ndioo taji'na, ti rakan te'en kā'an ra: “Ni kusiki ndra chi'in yuu, ta takan ni nata'vi ndra ma ja'mai juuni chi'in maa ndra”, kāti ra. ");
INSERT INTO mza_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ta ora yā'a, tajan chūnandi ndra jàkuenda ndra ma nuu tàkaa ra. ");
INSERT INTO mza_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta ma iti' xini ra, tātuu ndra ma letra, ña kà'an nda cha'a' kùu yi ña tākaa ra ma ikan. Ta ma tu'un ikan, te'en kà'an yi: “Ra'ya kùu Jesuu, ra kùu Rey nuu ma ndian judíu”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ta juuni tākaa ndra uvi ta'an ma ndra su'u xiin ra, iin ra chiyo kua'a ra, ta inga ra chiyo satin ra. ");
INSERT INTO mza_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ta ma ndian yā'a ma nuu tàkaa Jesuu, chàtu'un na ra, ta kàva na xini na, ");
INSERT INTO mza_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ta te'en kà'an na: ―Yo'o, ra kàtiun ña ni janduva ma veñu'u ka'nu, ta tichi uni kivi, ni kutaa ndikoun yi niku, na jakakun ñu̱n, juuni chi'in maun, ta nuu̱n ma nuu takaun nuu kruu, tuva ndicha ña ra Se'e Ndioo kùu̱n ―kàti na chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ta juuni takan chàtu'un ma ndra kuxini nuu sutu ra, chi'in ma ndra jàkua'a tutu Ndioo, ta ndra fariseu, chi'in ma ndracha'nu ña kuxini nuu ma ndian judíu ra ndia. Ta ndrakan te'en kā'an ndra chata ra: ");
INSERT INTO mza_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Jākakú ra inga na, va juuni maa ra, na küu jakakú ra ra. Tu ndicha ña Rey ra chà'nda tiñu nuu ma ñivi Israel kùu ra, na nuu ra ma nuu takaa ra nuu kruu, ta takan chinunio ma tu'un ra. ");
INSERT INTO mza_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Vati tu ìyo tundeeni Ndioo chi'in ra, ña jakakú ma Ndioo ra, na jakakú ra ra vitin, tuva ndicha ña Ndioo kùuni ra nde'e ra ra. Ti juuni maa ra kā'an ra nuu yo, ña ra Se'e Ndioo kùu ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta nda ma ndra su'u, ña tàkaa nuu kruu chi'in ra, ndita'an ndra chàtu'un ndra ra ndia. ");
INSERT INTO mza_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tajan ora kēta ma kachuvi ndaa, ta nda ma kaa uni chani'ini, ninii ka'nu ma nuñu'u' ñuñivi, endee ndōnaa yi. ");
INSERT INTO mza_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tajan juuni ma ora ikan, te'en kānachaa ni'i Jesuu: ―Elí, Elí ¿lama sabactani? ―ma tu'un ikan, te'en kùuni yi ka'an yi: Tatá Ndioo, Tatá Ndioo, ¿ta naja ndākoo ma'iiun yu'u? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tajan ìyo ma ndra ka'ìin ikan, ña ora chīni ndra ma ña kā'an ra, ta te'en nāka'an ndra: ―Ma ra'ii i'ya kànachaa ra ma Elía, ra kā'an chi'in tu'un yu'u Ndioo ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tajan juuni ma ora ikani, chāki'in iin ma ndra ka'ìin ma ikan, iin ña xa'ma, ta cha jākuti ra ma vinu iya yi, ta chū'ni ndio ra yi xini iin yutun kani, ta jānani ra yi yu'u Jesuu, ña na ti'vi ra yi, ta ko'o ra ra'. ");
INSERT INTO mza_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Va ma inga ndra te'en nāka'an ndra: ―Ndakoo yo'o ra, nde'o a vàchi ma Elía, ta jàkakú ra ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tajan ni'i va'a nānda'yu ndiko ma Jesuu, ta chī'í ndio ra. ");
INSERT INTO mza_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ta ma ora ikani, ma ja'ma ña tàkaa tichi veñu'u ka'nu, ndāta javandaa yi, nda siki, ta nda ninuu. Ta tāan ndio ma nuñu'u', ña ndava ndāta java ndaa ma yuu na'nu jā'a yi. ");
INSERT INTO mza_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ta nda ma nuu ñaña ma ndian ndií, ndāta yi, ta kua'a' ma ndian chī'í, ña chìnuni tu'un Ndioo, nātaku na ma ora ikan. ");
INSERT INTO mza_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Va ma ñivi i'ya, kēe na ma nuu ñaña na, ma ora yā'a ña nātaku Jesuu, ta ikan jan kī'vi ndio na ma ñuu ií Jerusalén, ma nuu nduva'a kua'a' ñivi ndē'e na na. ");
INSERT INTO mza_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Takan kūu tajan ora ndē'e ma ra kùu capitán, chi'in ma ndra ka'ìin jàkuenda nuu tàkaa Jesuu, ña nduva'a ni'i tāan, ta inga tuku ma ña kūu, ta nduva'a yū'vi ndra, ta te'en nāka'an ndra: ―¡Ndicha kuii, ña ra Se'e Ndioo kūu ra'ya niku! ―kāti ndra. ");
INSERT INTO mza_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ta ìyo kua'a' ñivi ña'a, ña tāndikun chata Jesuu, ña kīchi nda ma ñu'u' Galilea kuenda ña tìndee vi ra, ka'ìin chikani vi kànde'e vi, naja kua tā'an ra. ");
INSERT INTO mza_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ta tañu ma ñivi ña'a ikan, ndaa ma Ndiya Magdalena, chi'in Ndiya ma'á Jandiau, ta Kusé, ta chi'in ma'á ma ndra se'e Zebedeu ndia. ");
INSERT INTO mza_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Takan kūu, ta ora chani kuna'a, tajan chāa iin ra kuika, ra ñuu Arimatea, ña nàni Kusé. Ta rakan ti, juuni iin ra chākunuu chi'in Jesuu kùu ra niku. ");
INSERT INTO mza_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tajan rakan chānde'e ra Pilatu, ta chīkan ra kuñu Jesuu nuu ra. Ta Pilatu kà'an ra ña na ku'va ndra yi nuu ra. ");
INSERT INTO mza_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ta ora nī'i ndio Kusé ma kuñu ra, ta kāva ra iin ja'ma ndōo yi. ");
INSERT INTO mza_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tajan kūchi ndio ra yi ma tichi iin yavi chaa, ña ja tāchi ra ña na jandova'a ndra ma tichi yuu, ta kùu yi nuu ñaña Jesuu. Ta ora yā'a chāsi ndio ra yu'u ma nuu kì'vi yo ma nuu ñaña, chi'in iin yuu ka'nu, tajan kēe ndio ra kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ta ma Ndiya Magdalena, chi'in ma inga tuku Ndiya, kīndoo vi nàndi vi jàkuenda vi, yatini ma nuu kūchi Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Takan kūu ta ora tuvi inga kivi, ña kùu yi ma kivi nindeo, ma ndra sutu, ña kuxini nuu sutu, chi'in ma ndra fariseu, chā'an ndra chānde'e ndra ma Pilatu, ");
INSERT INTO mza_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ta te'en nāka'an ndra chi'in ra: ―Yo'o racha'nu, chāku'uni ndi, ña ora juuni ndito ga ma ra nduva'a vata ikan, rakan kā'an ra, ña ora cha yā'a uni kivi, ta ni nataku ndiko ra. ");
INSERT INTO mza_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yakan va na tachiun ma ndra jandaru̱n, ña na kujakuenda ndra ma nuu ñaña nuu kūchi ra, nda ma kivi uni, koto ja'a ma ndra chàkunuu chi'in ra, kūtavani'i xe'e ndra ma kuñu ra ora chanikuaa, ta ndrakan, te'en ni ka'an ndio ndra nuu ma ñivi: “Cha nātaku ndiko ra tañu na ndian ndií”, ni ka'an ndra. Ta tu takan kùu yi, tajan kùuni ndio yi ka'an yi, ña ma tu'un vata nuu ndi'inia i'ya, ka'nuga yi kua ma tu'un vata nunuu, tuva takan ―kàti ndra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tajan Pilatu te'en nāka'an ra chi'in ndra: ―I'ya ìyo ma ndra jandaru ña ni kujakuenda chi'in ndo ma ndakan. Na ku'un ndra chi'in ndo, ta na jakuenda va'a ndra ma nuu kūchi Jesuu jà'a ndo. ");
INSERT INTO mza_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tajan kēe ndio ndra kuàkumi va'a ndra ma ikan. Ta kāni ndra iin tuni chata ma yuu ka'nu ña ndàsi ma ikan. Tajan ndākoo ndio ndra ma jandaru, ña na kumi va'a ndra ma ikan. ");
INSERT INTO mza_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Takan kūu ta ora yā'a ndio ma kivi sabadu, ma kivi nindeo, ta kūndichin ndio ma kivi nunuu, nuu kìcha'a ma jamana. Ma Ndiya Magdalena, chi'in ma inga Ndiya, kēe vi kūa nde'e vi ma nuu ñaña nuu kūchi Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ta nunuuni, ta kīcha'a nduva'a ni'i tàan ma nuñu'u'. Takan jā'a yi, vati nūu iin ma ra tati ña jàkuu tiñu nuu Ndioo ma iti' andivi. Ta ora cha ìyo ndio ra ma nuu kūchi Jesuu, tajan tāchiyo ra ma yuu ña ndasi yu'u yi, ta chūnandi ra chata yi. ");
INSERT INTO mza_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ma ra kùu tati ikan, nduva'a tacha ra takua iin tacha andivi, ta ma ja'ma ra nduva'a vii kuichin yi, takua kùu ma nieve. ");
INSERT INTO mza_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ta ora ndē'e ma ndra jandaru yi, ta yū'vi ndra, ta ndāyu ndra, ña ndava kūnaa ndra jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tajan ma tati ikan, te'en nāka'an yi chi'in ma ñivi ña'a: ―Na yü'vi ndo, ti cha chìtoi, ña Jesuu, ra chī'í nuu kruu kùu ma ra nànduku ndo. ");
INSERT INTO mza_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Na töva ra ma i'ya, vati cha nātaku ra ma takua kā'an ra chi'in ndo niku. Na kichi nde'e ndo ma nuu chūndii ra niku. ");
INSERT INTO mza_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na numini ku'un ndo, kukatitu'un ndo nuu ma ndra chàkunuu chi'in ra, ña ma Jesuu, ra chī'í, cha nātaku ndiko ra, ta ji'na ga ra ni ku'un ma ñu'u' Galilea kua maa ndra, ta ndakan ni nde'e ra ndra inga cha'a'. Tu'un i'ya kùu ma ña ìyo yi ña katitu'in nuu ndo. ―Takan kāti ma tati ña jàkuu tiñu nuu Ndioo chi'in vi. ");
INSERT INTO mza_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tajan numini kēe ndio vi ma nuu kūchi Jesuu, ña ni töva chìto vi, a cha'a' ña ndasii vi kùu yi, a cha'a' ña chìsii vi kùu yi. Ta endee chìnu ndio vi kuàkatitu'un vi nuu ma ndra jàkua'a chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ta ma nuu kàcha'an vi kēta ma Jesuu nuu vi, ta kāña'a ra chi'in vi. Tajan vikan, chājayatin vi vi nuu ra, ta chūnumindaa vi cha'a ra, ta jāka'nu vi ra. ");
INSERT INTO mza_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ta Jesuu te'en nāka'an ndio ra chi'in vi: ―Na yü'vi ndo. Na kukatitu'un ndo nuu ma ndra jàkua'a chi'i̱n, ña ìyo yi ña ku'un ndra ma ñu'u' Galilea, vati ndakan ni nde'e ndra yu'u ―kàti Jesuu chi'in vi. ");
INSERT INTO mza_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ta ora juuni yanga kàcha'an vi ma tichi iti', ta ikan chīkuta'an vi uvi uni ma ndra jandaru, ña kūmi ma ikan, ña chā'an ndra ma ñu'u' Galilea, chākatitu'un ndra ndisaa ma ña tā'an ndra nuu ma ndra sutu ña kuxini nuu sutu. ");
INSERT INTO mza_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tajan ma ndra sutu kuxini i'ya, chānatu'un ta'an ndra chi'in ma ndracha'nu ña kuxini nuu ndian judíu, ikan na jando'iin ndra tu'un chi'in ta'an ndra. Ta ikan chā'a ndra kua'a' xu'un' nuu ma ndra jandaru. ");
INSERT INTO mza_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ta ma ndracha'nu te'en nāka'an ndra chi'in ma jandaru: ―Tu ìyo ndian chìkatu'un nuu ndo cha'a' ma ña kūu, na katitu'un ndo nuu na, ña ma ora chanikuaa ña kàndoyo ndo kìxi ndo, chā'an ma ndra jàkua'a chi'in Jesuu, ta sū'u ndra ma kuñu ra, kati ndo. ");
INSERT INTO mza_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ta tu ma kalecha'nu koto ra yi, na näkanini ndo ti ni jandomani maa ndi ra, ikan töve nakuyi ta'an ndo jà'a ra ―kati ndra. ");
INSERT INTO mza_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tajan tīin ndio ma ndra jandaru ma xu'un', ta jā'a ndra ma takua kā'an ndra chi'in ndra. Ta ma tu'un i'ya juuni kà'an ga ma ndian judíu yi nda vitin. ");
INSERT INTO mza_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ta takan kūu yi, ña ndi uchi iin ma ndra chàkunuu chi'in Jesuu, chā'an ndra ma ñu'u' Galilea, ta chāa ndra ma yuku nuu kāti Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ta ora ndē'e ndra Jesuu, ta jāka'nu ndra ra, vaji ìyo ma ndra tüvi nī ja'a yi cha'a' ña tüvi chìnuni ndra. ");
INSERT INTO mza_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tajan chājayatin ndio ma Jesuu ra nuu ndra, ta te'en nāka'an ra chi'in ndra: ―Ma Ra chā'a tiñu nui, ña na ka'ndai tiñu ninii ka'nu ma nuñu'u' i'ya, ta ma andivi, kùu ma Ndioo ka'nu. ");
INSERT INTO mza_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ta na ku'un ndo kukatitu'un ndo nuu ma ñivi ìyo ninii ka'nu ma nuñu'u', ta na jandaku ndo na, ña na kuu na ndian jàkua'a chi'i̱n. Ta na jakunduta ndo na, chi'in sivi ma ra kùu Tatá yo, ta ma ra kùu Se'e, ta chi'in sivi ma Tati Ií Ndioo. ");
INSERT INTO mza_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ta na jana'a ndo nuu na, naja kua ìyo yi ña jachi'in na ndisaa ma ña kātitu'in nuu ndo. Ta kùuni̱ ña na koto ndo, ña ni koi chi'in ndo nani kivi, nda kati chàa ma ora nàa ma ñuñivi. Ta takan na kùu yi. Amén. ―Takan kāti Jesuu.");
INSERT INTO mza_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","I'ya kìcha'a tu'un va'a cha'a' Jesucristu, ra Se'e Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ra kā'an chi'in tu'un yu'u Ndioo tatiempu, ta rakan nàni ra Isaía. Ta tāa ra iin tu'un cha'a' Racha'nu Jesuu, ra ni kichi iti' nuu. Ta te'en kà'an yi: “Ni tachi̱ iin ra jàkuu tiñu nui iti' nuu̱n, na jandova'a ra ma itiun.” Takan kāti Ndioo chi'in ra Se'e ra. ");
INSERT INTO mza_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yakan va Xuva ra jàkunduta kùu ra ña tāchi Ndioo ra, na jakuu ra tiñu nuu Jesuu. Ta te'en kà'an Xuva ora nānda'yu ra tichi ku'u: “¡Na jandova'a ndo iti' ni kichi Racha'nu! ¡Ta juuni na nuna ndo iin iti' ndaa kuenda ra ndia!” ");
INSERT INTO mza_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Takan kūu ta kēta ndio ma Xuva ra jàkunduta nda tichi ku'u. Ta kàtitu'un ra nuu ma ñivi na ndikoni'i na chi'in Ndioo, ta na kunduta na, ikan na janaa Ndioo kuati na. ");
INSERT INTO mza_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Takan kūu ta kēta kua'a' ma ñivi ñuu Jerusalén ta inga tuku ñivi ìyo tichi ñu'u' Judea ña tàso'o na ña kà'an Xuva. Ta ora chīni na ña kà'an ra te'en, ta kīcha'a na nà'ma na kuati na. Tajan ma Xuva jākunduta ndio ra na ma yuta Jordán tichi ku'u ikan. ");
INSERT INTO mza_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Takan kūu ta ma ja'ma chàku'un Xuva, kūva'a yi chi'in ixi kameyu. Ta chi'in pañu ñii chù'ni ra yi toko ra, ta chàchi ra mamaa tikaa kua'á chi'in nduxi ku'u. ");
INSERT INTO mza_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Takan kūu ta te'en jàkoto ndio ra ma ñivi, ña kā'an Ndioo chi'in ra: ―Tiá iti' chatai, ni kichi iin ra ka'nu ga ta ndatu ra tiaga kua yu'u. Ta yu'u, ti ra nda'vini kùi, ña ni ñii ndikun ndichan ra ni yakan tüvi ìyo yi ña ndachi̱. ");
INSERT INTO mza_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taku yu'u, jàkundutai ndyo'o chi'in takuini, va rakan ni jakunduta ra ndo chi'in Tati Ií Ndioo. ―Takan kàti Xuva chi'in na ikan. ");
INSERT INTO mza_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Takan kūu ta kēta iin kivi ña kēe Jesuu ñuu Nazaret, ña ìyo iti' ñu'u' Galilea. Ta ikan chāa ra nuu ndaa Xuva. Ta jākunduta ra Jesuu ma yuta Jordán. ");
INSERT INTO mza_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ora kèe Jesuu tichi takuii, ndē'e ra ña nùna ma andivi. Ta ikan kōyo Tati Ií Ndioo chata ra, ña kàa yi takua kàa iin livi. ");
INSERT INTO mza_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Takan kūu ta chīni Jesuu ña nāka'an Ndioo nda andivi: ―Ndicha kuii, ña yo'o kùu se'i, ra kāchi̱n ña jàkuu tiñu nui, ti ya'a kùuni nde'i ñu̱n. ―Takan kāti Ndioo chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ora chīnu kā'an Ndioo ña'a, ta ma Tati Ií Ndioo chāndaka yi Jesuu iti' tichi ku'u. ");
INSERT INTO mza_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ikan chīyo ra uvi xiko kivi chi'in kua'a' kiti ku'u. Ta ikan kùu nuu kùuni ma kui'na kuxini ka'ndán' tiñu nuu Jesuu niku. Va tüvi nī ja'a Jesuu ma ña kā'án' chi'in ra, vati kuati kùuni ma kui'na ña na ja'a ra niku. Ta ora kuà'an ndio ma kui'na, tajan kīcha'a ndio ma kua'a' tati jàkuu tiñu nuu Ndioo tìndee yi Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ta ora yā'a ña tī'i ndra Xuva vekaa, ta Jesuu ti chàkunuu ra jàna'a ra tu'un va'a Ndioo iti' ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ta te'en kà'an ra nuu ma ñivi ikan: ―Vitin va cha kūyatin ora ña ni nde'o nuu chà'nda Ndioo tiñu. ¡Yakan va na chikoni'i ndiko ndo iti' Ndioo! Ti vitin va cha kēta ora ni tava Ndioo tiñu nuu yo. ¡Yakan va na ndakoo ndo ma kuati jà'a ndo! ¡Ta na chinuni ndo ma tu'un Ndioo chi'in ndisaa anima ndo! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Takan kūu ta Jesuu chàkunuu ra yu'u lakuna ìyo ñu'u' Galilea. Ta ikan ndē'e ra iin ra nàni Simón chi'in ra yani ra, André. Ta ndrakan ti ndra kìin kùu ndra. Ta ikan jākanaa ndra ma yu'va tiaka' ka'nu nuu takuii. Takan jà'a ndra, ");
INSERT INTO mza_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ta kēta Jesuu ña te'en nāka'an ra chi'in ndra: ―¡Na'a ndo chatai! Vitin cha chìto ndo naja kua kìin ndo tiaka', va vitin yu'u kùu ra ni jana'i nuu ndo naja kua nàni'i ndo ñivi kuenda Ndioo. ―Takan kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ora chīni ndra ña kā'an ra takan, numini ndākoo ndra yu'va tiaka' ikan, ta tāndikun ndra kuà'an ndra chata ra. ");
INSERT INTO mza_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ta tiá iti' nuu ndē'e Jesuu inga ndra ka'ìin tichi lancha. Ta ikan indii Jandiau chi'in ra yani ra Xuva ña jàndova'a ndra yu'va tiaka' chi'in tatá ndra Zebedeu, ta chi'in ndra musu ndra ndia. ");
INSERT INTO mza_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ta ikan kāna Jesuu ndra. Tajan ndākoo ndio ndra tatá ndra chi'in musu ndra tichi lancha. Ta tāndikun ndra kuà'an ndra chata Jesuu ndia. ");
INSERT INTO mza_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Takan kūu ta iin kivi nìndee ñivi judíu kùu yi, ora chāa ndra ñuu Capernaum. Tajan Jesuu chi'in ñivi kī'vi ra tichi veñu'u ñivi judíu. Ta ikan kīcha'a ra jàna'a ra tu'un va'a Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ta ma ñivi ndava yu'vi maania na ña ndē'e na kua jàna'a va'a ra chi'in chinituni ra. Vati tiaga va'a jàna'a ra kua jàna'a ndra matru jàkua'a tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Va tichi veñu'u ikan ndaa Jesuu jàna'a ra ora chīni ra ña ndā'yu iin ra ndiso tati xaan indii tichi veñu'u ikan. Ta kīcha'a kà'an ma tati xaan te'en: ");
INSERT INTO mza_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Ta naja kùuniun kanita'un chi'in ndi, yo'o Jesuu, ra ñuu Nazaret? Ta ndyu'u, cha chìto ndi ña vàchi jandi'un nuu ndi. Vati ndyu'u cha nākoto va'a ndi ti ma ra ií Se'e Ndioo kùu̱n. ―Takan kāti tati xaan chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ta te'en kīcha'a kà'an xaan Jesuu chi'in tati xaan ikan: ―¡Taxiin kuu yu'u ndo, ta na kee ndo tichi kuñu ra'ya! ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Takan kūu ta kīcha'a chì'i i'i ma ra ndiso tati xaan jā'a yi. Ta jànivaania kùu na ora kēe na tichi kuñu ra. ");
INSERT INTO mza_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Takan kūu ta ndisaa ma ndian ka'ìin ikan yū'vi na ña kūu takan, ta te'en kīcha'a chìkatu'un ta'an na nuu na: ―¿Nda iti' kīchi ra ña jàna'a ra te'en chi'in chinituni ra ta ya'a ndatu ra, ña nda tati xaan jàchi'in ña kà'an ra? ―Takan nàtu'un ta'an ma ñivi ikan. ");
INSERT INTO mza_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Takan kūu ta numini chīto ndisaa ñivi ñu'u' Galilea ña jà'a Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ta ora kēe Jesuu veñu'u ñivi judíu, numini kuà'an ra chi'in Jandiau chi'in Xuva, nda ve'e Simón chi'in André. ");
INSERT INTO mza_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ta ora chāa Jesuu ve'e ndra ta kāti ma Simón nuu ra ña ku'vi ma ñaka'nu ra kàndian nuu chito jà'a ka'ni. ");
INSERT INTO mza_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ta numini chāa Jesuu nuu kàndian ta tīin ra nda'a' ña ta ndākoan chūnandian jā'a ra. Ta ma ora ikani ndā'a ña. Ta kīcha'a ña jà'a ña ña kachi ndra. ");
INSERT INTO mza_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ora ni kuna'a ora chīso nikandii, ma ora ikan chāndaka na kua'a' ndian ku'vi chi'in ndian ndiso tati xaan nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Takan kūu ta ndisaa ma ñivi kūti'vi na yuve'e nuu ndaa ra. ");
INSERT INTO mza_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tajan jàndova'a Jesuu tanuu kue'e ndo'o na. Ta juuni tāva ra ma tati xaan ña ndiso na ndia. Ta tüvi nī cha'a ra ka'an ma tati ikan ti cha nàkoto na ra. ");
INSERT INTO mza_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Takan kūu ta ora tuvi inga kivi ora juuni takä'an kundichin, tajan ndēta ndio Jesuu, ta kēe ra kuà'an ra iin tichi ku'u nuu taxiin ña kuàka'an ra chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Takan kūu ta chānuu kuà'an ra, tajan kuànanduku ndio Simón chi'in ndra mañeru ra ra. ");
INSERT INTO mza_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ta ora nāta'an ndra ra ta te'en kīcha'a ndra kà'an ndra chi'in ra: ―¡Ndisaa ñivi kàchika na nànduku na ñu̱n! ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ta te'en nāka'an Jesuu chi'in ndra: ―Va'a, va ji'na ìyo yi ña kujana'i tu'un Ndioo nuu tandi'i ñivi ìyo nda'a' ñuu i'ya. Vati tiñu ikan tāchi Tatái yu'u ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Takan kūu ña chàkuu Jesuu ndi'i ñu'u' Galilea kàtitu'un ra tu'un Ndioo nani veñu'u ñivi judíu. Ta juuni jànda'a ra ma ñivi ndiso tati xaan ndia. ");
INSERT INTO mza_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Iin kivi chāa iin ma ra ndo'o kue'e tà'yu nuu ndaa Jesuu. Ta ikan chūnandi chiti ra nuu ra. Ta rakan te'en nāka'an ra chi'in Jesuu: ―¡Jandova'a ma kue'e ndo'i tuva kùuniun! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tajan kūnda'vini Jesuu ra ta te'en nāka'an ra chi'in ra: ―Kùuni janda'i ñu̱n ―kàti Jesuu. Tajan jānani ra nda'a' ra ra. Ta ndā'a ra. ");
INSERT INTO mza_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yakan va ma ora ikani ndā'a ra. Ta nāa ma kue'e ikan ñii ra. ");
INSERT INTO mza_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tajan nduva'a kuii chūndayu'u Jesuu ra. Takan kūu tajan tāchi ndio ra ra na ku'un ra, va ji'na te'en nāka'an ra chi'in ra: ");
INSERT INTO mza_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―¡Nuu nï'iin na, na kätitu'u̱n naja kua jā'un ña ndā'un! Ji'na kuii nuu sutu ìyo veñu'u ka'nu ñuu Jerusalén, jana'un ñu̱n, ikan nakoto ra ti cha ndā'un. Ta ikan jan sokóun iin kiti nuu sutu kuenda Ndioo, ti kua ikan kàti tutu Ndioo ña tāa Moisés taji'na. Ti takan ìyo yi ña ja'a yo, ikan na koto tandi'i ñivi ña cha ndā'un ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tajan kēe ndio ra kuà'an ra, va tüvi nī jachi'in ra ña kā'an Jesuu. Ti kātitu'un ra yi nuu tandi'i ñivi ña kua janda'a ra ra. Yakan va na küa koo Jesuu tichi ñuu, ti kīndoo ra tichi ku'u taxiin nuu tüvi ndoyo ñivi. Va vaji takan jā'a ra ninii nānduku na ra. ");
INSERT INTO mza_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Takan kūu ta ora cha yā'a yatin kivi, tajan chāa ndiko Jesuu ñuu Capernaum. Ta ora chīto ma ñivi ña chāa ndiko ra tichi iin ve'e ndaa ma ñuu ikan, ta ikan kūti'vi kua'a' ñivi ma tichi ve'e nuu ndaa ra, ña ni yuve'e küta'an ga na kuiin na. Ta ikan kīcha'a ra jàna'a ra tu'un Ndioo nuu na. ");
INSERT INTO mza_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Takan kūu ta chāa kumi ta'an ndra ndiso iin ra kūyutun chi'in ti'va. ");
INSERT INTO mza_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ta tava küu ki'vi ndra yuve'e nuu ndaa Jesuu, jà'a ña ya'a kua'a' ñivi ka'ìin tichi yi. Yakan va ndāa ndra chata ve'e, ta nūna ndra ita'vini kua kùu januu ndra ma ra ku'vi nuu ndaa Jesuu tichi ve'e. Yakan va ora cha nūna ndra yi, tajan jānuu ndra ma ra kūyutun tichi ti'va, nda nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ta ora ndē'e Jesuu ña ya'a chìnuni ndra ña jà'a ra. Yakan va te'en kīcha'a kà'an ra chi'in ra kūyutun: ―Yo'o se'yu vitin cha jānai kuatiun. ―Takan kàti Jesuu chi'in ra kūyutun. ");
INSERT INTO mza_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Takan kūu ta ma ndra matru jàkua'a tutu Ndioo ka'ìin ikan, te'en nàkanini ndra cha'a' ña kā'an Jesuu te'en: ");
INSERT INTO mza_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ta naja jà'a ra'ya ña kà'an ra takan? Ma tu'un kā'an ra iin ña kini kùu yi kuenda Ndioo. ¿A tüvi chìto ra, ti uvaa Ndioo kùu ra kùu janaa kuati ñivi? Ta tüvi kùu ja'a inga nda ndian nikuuni yi.” Takan chànini ndra. ");
INSERT INTO mza_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Va Jesuu numini chīto ra ña chànini ndra takan. Yakan va te'en chīkatu'un Jesuu nuu ndra: ―¿Ta naja vä'a' chànini ndo? ");
INSERT INTO mza_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tu ka'in chi'in ra ku'vi, cha jānai ma kuati ra, ta töve nde'e ndo tuva ndicha ña ni kuu ña kà'in. Va tu ka'in chi'in ra: “¡Ndeta, ta natuviun ti'vaun, ta ku'un ve'un!” Ta nde'e ndisaa ndo ti ndicha ìyo ndatui. ");
INSERT INTO mza_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Va vitin ni jana'i nuu ndo, ti kùu janai kuati ñivi ñuñivi i'ya. Yakan va ni koto ndo, ti yu'u kùu ra Se'e ñivi tāchi Ndioo, ta ìyo ndatui. ―Takan kàti ra chi'in ma ndra jàkua'a tutu Ndioo. Ta te'en nāka'an tuku Jesuu chi'in ma ra kūyutun: ");
INSERT INTO mza_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Chi'in yo'o kà'in ña ndetaun ta natuviun ti'vaun ta ku'un ve'un ―kàti Jesuu chi'in ra kūyutun. ");
INSERT INTO mza_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ora kā'an Jesuu te'en, ta ma ra ku'vi niku, numini ndēta ra, ta nātuvi ra ti'va ra, ta kēe ra ma tichi ve'e, ta kuà'an ra. Yakan va ndē'e chi'in tinuu na, kēe ra kuà'an ra. Takan kūu ta ora ndē'e na ña jā'a Jesuu te'en, ta ndava kuà'an tati na. Ta kīcha'a na jàka'nu na Ndioo. Ta te'en kīcha'a na kà'an ndio na: ―¡Nï'iin cha'a' takä'an nde'e ndi iin ra ya'a ìyo ndatu ña jà'a te'en! ");
INSERT INTO mza_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ta ora yā'a ña kūu takan ta kēe ndiko Jesuu kuà'an ra yu'u lakuna. Ta ikan kūti'vi na nuu ndaa ra, ta ikan kīcha'a ra jàna'a ra tu'un Ndioo nuu na. ");
INSERT INTO mza_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Takan kūu ta ora yā'a ra chi'in na, ta ndē'e ra Leví, ra kùu se'e Alfeu ña nàndi ra nàka'an ra xu'un' nuu ñivi kuenda ma ñu'u' ñuu ka'nu Roma. Tajan kīcha'a kà'an Jesuu chi'in ra: ―¡Ndakoo tiñu jà'un chiña ta kichiun chatai! ―kàti ra. Ta ikan Leví numini ndākoo ra ma tiñu jà'a ra ta tāndikun ra kuà'an ra chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Takan kūu ta Jesuu chā'an ra chi'in ndra jàkua'a chi'in ra, chākujama ndra ve'e Leví. Ta ikan juuni ka'ìin inga ndra nàka'an xu'un' kuenda ñuu Roma, ta inga ndra kini xini chàchi ndra chi'in Jesuu ndia. Takan kūu ña nduva'a kuii kua'a' ñivi ndìkun chata Jesuu chi'in ndra tatun ra. ");
INSERT INTO mza_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ta ora ndē'e ndra jàkua'a tutu Ndioo chi'in ndra fariseu ña chàchi Jesuu chi'in ndisaa ma ñivi jà'a kuati ikan, ta te'en kīcha'a ndra chìkatu'un ndra nuu ndra jàkua'a chi'in Jesuu: ―¿Ta naja chàchi ma matru ndo chi'in ma ndian nàka'an xu'un' ta chi'in ndian jà'a kuati? ―Takan kàti ndra nuu ndra. ");
INSERT INTO mza_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ta ikan Jesuu chīni ra ma ña kà'an ndra. Ta te'en nāka'an ndio ra nuu ndra: ―¿A tüvi chìto ndo ti ma ndian ìyo va'a, tüvi chìniñu'u na ma ndra chìto tatan? Ndian ku'vini kùu ndian chìniñu'u yi. Ta yu'u ti tüvi vàchi̱ kuenda ma ndian tüvi chìniñu'u yu'u takua kùu ndian ìyo va'a. Yu'u vàchi̱, va kuenda ndian chìniñu'u yu'u takua kùu ndian ìyo kuati ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Iin ora ndīta yu'u ma ndra chàkunuu chata Xuva ra jàkunduta, chi'in ma ndra jàkua'a chi'in ndra fariseu. Ta ikan ndē'e inga ñivi ña ndìta yu'u ndisaa ndrakan. Tajan kēe ndra kuàndakatu'un ndra nuu Jesuu. Ta te'en chīkatu'un ndra nuu ra: ―¿Ta naja ndìta yu'u ma ndra chàkuu chata Xuva chi'in ndra chàkuu chata ndra fariseu? ¿Ta ma ndra jàkua'a chi'un, naja töve ndìta yu'u ndra ndia? ―Takan kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta te'en nāka'an Jesuu nuu na: ―Chi'in ma tu'un i'ya ni jana'i nuu ndo naja töve ndìta yu'u ndra vitin. ¿A kùu ndita yu'u iin ra ni tanda'a chi'in ñivi ra ora juuni ndaa ra chi'in vi? ¡Na küu yi! Ti tu juuni ndaa ma ra tànda'a, na küu ja'a na kundaa na ña ndìta yu'u na. Ti tandi'i na chìsii na ora ikan. ");
INSERT INTO mza_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Va ora cha kuà'an ra, tajan kùu kundita yu'u na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ta te'en nāka'an tuku Jesuu: ―Nï'iin na küu nataa na iin ja'ma cha'nu chi'in ita'vi ja'ma chaa, ti ma ja'ma chaa nàndii yi ta jànakaa yi ma ja'ma cha'nu. Yakan va kà'vi ga nàkaa yi jā'a ma ja'ma chaa. ");
INSERT INTO mza_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ta juuni küu kuiin ma takuii vinu, ña jākuiya na tichi tia'a ñii cha'nu, tuva vinu chaa kùu ra'. Ti ma vinu ikan, jàka'ndi ra' ma tia'a ñii cha'nu, ta chàti ra', ta nàkaa ma ñii ikan ndia. Yakan va va'a ga ti'o ma takuii vinu chaa tichi iin tia'a ñii chaa ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iin kivi ña nindee ñivi judíu chàkunuu Jesuu chi'in ndra jàkua'a chi'in ra nuu kàa kua'a' trigu. Takan kūu ta ikan kīcha'a ndra jàkuun nda'a' ndra ma trigu. ");
INSERT INTO mza_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ta te'en kīcha'a chìkatu'un ma ndra fariseu nuu Jesuu, ti kùuni ndra tisokuati ndra Jesuu: ―¡Yo'o xaa! ¿Ta naja jà'a ma ndra jàkua'a chi'un iin ña tüvi ìyo yi ña jà'a yo ma kivi nindeo? ");
INSERT INTO mza_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ta te'en nāka'an Jesuu chi'in ndra: ―¿A tüvi chàku'uni ndo ña jā'a ma racha'nu David, ora ya'a chāñu soko ra chi'in ndra meru ra? ");
INSERT INTO mza_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ta ma tiempu ikan ti ma ra sutu nàni Abiatar kūu ma ra chà'nda tiñu veñu'u ikan. Tajan kī'vi ndio David tichi veñu'u ikan, ta ikan jan chāchi ndio ra ma paan ií kuenda Ndioo. Ta rakan juuni chā'a ra ma paan ikan nuu tandi'i ma ndra chàkuu chata ra. Ta ma paan ikan, ti na vä'a kachi nda ndian nikuuni yi, ti kuenda ma ndra sutuni kùu yi. ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Takan kūu ta te'en nāka'an tuku Jesuu: ―Racha'nu Ndioo ji'na jā'a ra ma ñivi. Tajan jā'a ra ma kivi nindeo. Yakan va kuenda Ndioo, tiaga ka'nu ma ñivi kua ma kivi nindeo. ");
INSERT INTO mza_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ta nda yu'u ra se'e ñivi tāchi Ndioo, juuni ìyo ndatui ma kivi nindeo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iin ora kī'vi tuku Jesuu tichi veñu'u ñivi judíu. Ta ikan ndaa iin ra kūyutun nda'a'. ");
INSERT INTO mza_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ta ma ñivi ikan jà'a na kuenda tu jànda'a Jesuu ñivi ku'vi vaji ma kivi nindeo kùu yi. Takan ìyo yi ña kumi na Jesuu ta kùu ni'i na nda cha'a' tìso kuati na ra. ");
INSERT INTO mza_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ta te'en kà'an ndio ma Jesuu chi'in ma ra kūyutun nda'a': ―¡Ndeta ta kundaun ma'ñu i'ya! ");
INSERT INTO mza_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tajan te'en chīkatu'un ndio ra nuu ma ndian ka'ìin ikan: ―¿Nayi kùu ja'a yo ma kivi nindeo, kùuni ndo? ¿A jà'a yo ña va'a, a ña vä'a'? ¿A tiá va'a ña jàkakú yo na, a nde'enio ña kuvi na? ―kàti Jesuu. Va ma ñivi ka'ìin tichi veñu'u ikan, tüvi nī ka'an na ña kā'an ra. ");
INSERT INTO mza_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Takan kūu ta Jesuu iin ndē'e xaani ra nuu na ña ya'a nda'vi kùuni ra ti tüvi tàso'o na ña kà'an ra. Ta tüvi kùnda'vini ma ndian chìniñu'u ra ndè'e na ra. Tajan te'en nāka'an ndio Jesuu chi'in ma ra kūyutun nda'a': ―¡Janakee nda'un! ―kàti ra. Tajan jānakee ndio ma ra ku'vi nda'a' ra. Ta ora ikani ndā'a yi. ");
INSERT INTO mza_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ta kēe ndio ma ndra fariseu tichi veñu'u ñivi judíu, ta kuà'an ndio ndra nuu ka'ìin ndra chàkuu chata racha'nu Herode, ña ni natu'un ta'an ndra naja kua ja'a ndra ta kùu ni'i ndra kua ka'ni ndra Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ta Jesuu kuà'an ra chi'in ndra jàkua'a chi'in ra nda yu'u lakuna chi'in kua'a' ñivi ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ta ikan juuni kua'a' ñivi kēe ndio na kuànde'e na nuu ndaa Jesuu ora chìto na ña jà'a ra ña va'a. Takan kūu ta chāa ma ndian ñu'u' Judea chi'in ndian ñuu Jerusalén, chi'in ndian ñuu Idumea, ndian ìyo iti' kàna nikandii yuta Jordán, ndian ñu'u' ñuu Tiro, chi'in ndian ñu'u' ñuu Sidón ndia. Ndicha ña chāa nduva'a kuii kua'a' ñivi nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yakan va ndākoo Jesuu tiñu nuu ma ndra jàkua'a chi'in ra na yati koo ndra chi'in iin lancha ta jàyatin ndra run yu'u lakuna, ikan na jachika ra ra nuu na. ");
INSERT INTO mza_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Takan ìyo yi ña ja'a ndra koto chakoyo kua'a' na nuu ndaa ra. Ti tandi'i ndian ku'vi kùuni na ke'e na ra, ti chìto na ti ya'a kua'a' ñivi ku'vi jānda'a ra. ");
INSERT INTO mza_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta ma tati xaan ora ndē'e na ra, ta chūnandi chiti na nuu ra, ta kīcha'a na kànachaa na te'en: ―¡Yo'o kùu ma ra Se'e Ndioo! ―kàti ma tati xaan ikan chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Va xaan va'a kīcha'a kà'an Jesuu nuu na, ña na kä'an na takan chi'in ra nuu ka'ìin ñivi. ");
INSERT INTO mza_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Takan kūu ta ora yā'a ña kūu takan, tajan ndāa Jesuu iin yuku. Ta ikan kāna ra ma ndian va'a tiá kùuni ra. Ora kūti'vi ndra nuu ndaa ra ");
INSERT INTO mza_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ta ikan kāchin ra uchi uvi ta'an ndra kuenda ña kakuu ndra chi'in ra ña kà'an ndra ma tu'un va'a Ndioo. Ti ndra'ya kùu ndra ni kuu tatun ra. ");
INSERT INTO mza_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ta chā'a Jesuu ndatu ndra kuenda ña tàva ndra tati xaan ndiso ñivi ku'vi. ");
INSERT INTO mza_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ta ma ndi uchi uvi ma ndra kāchin ra nàni ndra te'en: Simón, ra jākunani Jesuu, Petu'. ");
INSERT INTO mza_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ta uvi ndra se'e Zebedeu, iin ra nàni Jandiau chi'in ra yani ra, Xuva. Ndrakan jākunani Jesuu ndra Boanerges ña kùuni yi ka'an yi ndra xaan takua xaan nda'yu savi ora kùun ra. ");
INSERT INTO mza_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ta inga tuku ra nàni André chi'in Lipe chi'in Tolo chi'in Mate chi'in Tomá, ta Jandiau ra se'e Alfeu. Ta juuni kāchin Jesuu Tadeu chi'in Simón, ra kùuni kuati chi'in ñivi ñuu ka'nu Roma. ");
INSERT INTO mza_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ta ra nuu ndi'i nia, va kùu Juda Iscariote, ra ni xikoña'a Jesuu tiá iti' nuu. ");
INSERT INTO mza_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Takan kūu ta kēta iin kivi, ña kī'vi tuku Jesuu iin ve'e. Ta ikan inga cha'a' juuni kūti'vi kua'a' ñivi. Ña nī kuu kachi ra ni chi'in ndra jàkua'a chi'in ra jà'a na. ");
INSERT INTO mza_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ta ora chīto ma ñivi Jesuu ña jà'a ra ta chàki'in na ra ti xini ra tivi ña jà'a ra takan, kùuni na. ");
INSERT INTO mza_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Takan kūu ta juuni ma ndra jàkua'a tutu Ndioo ndra kēe ñuu Jerusalén, chāa ndra nuu ndaa Jesuu. Ta te'en kà'an ndra chi'in ma ñivi ikan: ―Juu, ma kui'na kùxini chā'a ndatu nuu ra'ya, ti chi'in ndatu yakán', tàva ra ma tati xaan ndiso ñivi. ―Takan kà'an ndra chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ta ikan numini kāna Jesuu ndra. Ta kīcha'a kà'an ra iin ku'va chi'in ndra. ―¡Na küu tava ma kui'na juuni maa yi! ");
INSERT INTO mza_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tatu iin ñuu kànita'an chi'in juuni maa yi, na kündee yi kua'a' tiempu. ");
INSERT INTO mza_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tatu ìyo iin yo kànita'an chi'in juuni ñivi na, na kündee na kua'a' tiempu ndia. ");
INSERT INTO mza_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yakan va tu ma kui'na kànita'an yi chi'in juuni maa yi, juuni kündee na ndia. Ta ikan kùu nuu ndi'i nuu na. ");
INSERT INTO mza_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Yakan va nï'iin yo küu ki'vi iin ve'e ra ya'a ìyo ñandee ta kuika, ta sù'u yo ña ìyo nuu ra. Na küu ja'a yo yi tu tüvi ku'ni ji'na yo ra. Yakan va tu ku'ni ji'na yo ra, tajan kùu su'u yo ma ña ìyo ra. ");
INSERT INTO mza_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Va yu'u kàti ndicha kuii nuu ndo ti ma Ndioo ya'a ka'nu ra. Ta jànaa ra kuati ma ñivi ta ndisaa ña kini kà'an na. ");
INSERT INTO mza_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Va ndian kàti'ini chata Tati Ií Ndioo ndiakan tüva janaa Ndioo kuati na. Yakan va endee koo kuati ikan chi'in na ndisaa tiempu. ");
INSERT INTO mza_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ña'a kātitu'un Jesuu nuu ndra, ti tìsokuati ndra ra ña jànda'a ra ndian ku'vi chi'in ndatu kui'na. ");
INSERT INTO mza_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Takan kūu tajan chāa ma'á Jesuu chi'in ndra yani ra chi'in ña ta'an ra ve'e nuu ndaa ra. Va kìndoo vi nuke'eni. Ta ikan kà'an vi chi'in iin ra ndaa ma nuu ka'ìin kua'a' ñivi yuve'eni, na kuka'an ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ta ikan jan chāa ma ra kuàka'an chi'in Jesuu nuu ndaa ra chi'in kua'a' ñivi. Ta te'en kīcha'a kà'an ra chi'in Jesuu: ―Nuke'e ndaa ma'un chi'in ndra yaniun ta ñivi ta'un, ña nànduku vi ñu̱n. ");
INSERT INTO mza_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Va te'en nāka'an ra ña chìkatu'un ra nuu na: ―¿Yo kùu ma'i chi'in ma yani̱ ta ndian ta'in?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta ikan jan kīcha'a ndè'e ndicha ndio ra ma ndian ka'ìin xiin ra. Ta te'en nāka'an tuku ra chi'in na: ―¡Na kuni va'a ndo ña ni ka'in chi'in ndo! ");
INSERT INTO mza_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yakan va ma ndian jà'a ña kùuni Ndioo, ndiakan kùu ma yani̱ chi'in ta'in chi'in ma ma'i ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Takan kūu ta kīcha'a jàna'a tuku Jesuu inga cha'a' ma yu'u lakuna. Ta tava nduva'a kuii kua'a' ñivi kūti'vi nuu ndaa ra, yakan va ndāa Jesuu tichi iin lancha ña ndaa yatini ma yu'u lakuna ikan. Tajan nda tichi run chūnandi ndio ra kà'an ra chi'in na. Ta ma ñivi ikan ti yu'u lakunani kìndoo na chìni na ma ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ta ikan jan kīcha'a ra jàna'a ra kua'a' nakuyi nuu na chi'in ku'va, ikan na kutunini na ña kùuni ra ka'an ra. Yakan va te'en kīcha'a ra kà'an ra ma ku'va nuu na: ");
INSERT INTO mza_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―¡Taso'o ndo ña ni ka'in! ―kàti Jesuu. ―Ìyo iin ra tàchi. Ta rakan ti ora chāa ra nuu ñu'u' ra, ");
INSERT INTO mza_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ta kīcha'a ra tàchi ra. Ta tia ma chiti kōyo yi tichi iti'. Ta ndē'e ma saa yi. Ta nūu ndri nuu kàndoyo yi. Ta chāchi ndi'i ndri yi. ");
INSERT INTO mza_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ta inga ita'vi yi kōyo yi tañu yuu. Ta ikan, ti nuuni yoso ma ñu'u', ti mamaa yuu ndòyo nda ninuu. Yakan va ma chiti kōyo tañu yuu numini kāna yi, ti tüvi kunu indii ma chiti. ");
INSERT INTO mza_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Takan kūu ta ora ñuka'ñu ndií, nduva'a kuii xìi yi, ti tüvi nì'i yi ndanu ki'vi yo'o yi. Yakan va nātii yi. ");
INSERT INTO mza_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ta inga ita'vi ma chiti chīta yi tañu ku'u. Ta ma ku'u ikan numini chā'nu yi, ta jāvati yi nuu yi. Ta nī küa kua'nu yi. Yakan va tüva nī kuu jatiñu yi. ");
INSERT INTO mza_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ta tia yi, va kōyo nuu va'a ñu'u'. Yakan va kāna yi, ta chā'nu va'a yi. Ta kēta kua'a' va'a chiti nuu yi. Ìyo yoko ña kēta oko uchi chiti nuu ii'iin yi. Ta ìyo ña kēta uni xiko chiti nuu. Ta inga yoko ña chā'a iin cientu chiti. Yakan kūu ma ku'va kàti Jesuu nuu na. ");
INSERT INTO mza_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta te'en nāka'an tuku Jesuu chi'in na: ―¡Yakan va na taso'o ndisaa ndo ma ña ni ka'in chi'in ndo! ");
INSERT INTO mza_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Takan kūu ta ora kīndoo ma'iin Jesuu chi'in ndi uchi uvi ndra jàkua'a chi'in ra, ta inga ndra ka'ìin xiin ra. Ta te'en kīcha'a chìkatu'un ndra nuu Jesuu: ―¡Na katitu'u̱n nuu ndi, nayi kùuni ma ku'va ikan ka'an yi! Vati töve kùtunini ndi ma tu'un kā'un ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta te'en nāka'an Jesuu chi'in ndra: ―Nuu ndyo'o, chā'a Ndioo ña koto ndo tu'un xe'e ña ìyo chi'in ra nuu chà'nda ra tiñu. Yakan va chà'a ra ña nàkoto ma ndian jàkuu tiñu nuu ra ma tu'un xe'e ikan. Va ma ndian tüvi chìnuni ña kà'in, nuu ndiakan va chi'in mamaa ku'vani ni ka'in yi chi'in na. ");
INSERT INTO mza_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ta ma ñivi ikan ti vaji ndè'e na, va tüvi ndichin nuu na. Ta vaji chìni na, va tüvi kùtunini na ma tu'un kà'in. Yakan va küu ndikoni'i ndiko na chi'in Ndioo. Ta töve ni janaa ra kuati na ndia. ―Takan kàtitu'un Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Takan kūu ta te'en nāka'an tuku Jesuu chi'in ndra: ―¿Tu tüvi kùtunini ndo ma ku'va i'ya, naja kua kùu kutunini ndo inga ku'va ni ka'in, tuva takan? ");
INSERT INTO mza_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ti ma ra tàchi chiti, indukuni kùu ra takua kùu ma ra jàna'a tu'un Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vati ìyo ma ndian kàa takua kàa ma chiti kōyo tichi iti'. Chìni va'a na ma tu'un Ndioo, va ora ña cha chīni na yi, tajan vàchi ndio ma kui'na ka'nu. Ta yakán' jànaa ma tu'un va'a Ndioo ña cha ìyo anima ii'iin ma ñivi ikan. ");
INSERT INTO mza_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ta inga na kàa na takua kàa ma chiti ña kōyo tañu yuu. Ta ndiakan kùu ma ndian chìnuni tu'un Ndioo. Yakan va ora ndāki'in na yi, ndava chìsii na ti ndāki'in na yi chi'in ndisaa anima na. ");
INSERT INTO mza_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yakan va ndiakan kàa na takua kàa ma chiti tàchio ña tüvi kunu indii yo'o jà'a ma yuu. Ta ndiakan kùu na takua kùu ma chiti ikan. Ti töve nì'i yi nuu ku'un yo'o yi. Yakan va ma ñivi ikan, tüvi chùndaa va'a na. Ta chìnuni na ma tu'un Ndioo tia kivini. Ta vàchi ndio ma ndian jàndoto kuati nuu na, cha'a' ma tu'un Ndioo. Tajan ndè'e ndio na tundo'o. Ta na küa koo va'a na chi'in ma tu'un Ndioo. Yakan va ndàkoo ndio na yi. ");
INSERT INTO mza_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ta inga na kàa na takua kàa chiti ña kōyo tañu ku'u. Ndiakan kùu ma ndian chìnuni tu'un Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Va chìtu'un na tiá cha'a' ma ndatiñu ña nì'i na ñuñivi i'ya. Ta juuni ya'a kùuni na nde'e na ma xu'un' ña na jandakuu kuika yi na. Ta yakan kùu yi ña jànda'viña'a yi na. Ta yüvi yakan ni kuu yi, ti kùuni na inga nakuyi koo nuu na. Ta takan kùu yi chi'in ma chiti tàchio, ora kàna yi nuu vati. Töve kùu jatiñu yi. Yakan va takan kùu ma ñivi ikan, ti tüvi chàa ma tu'un Ndioo nda anima na. ");
INSERT INTO mza_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ìyo inga ma ñivi ña chìni na ma tu'un va'a Ndioo. Ta chìnuni na ña kà'an yi chi'in ndisaa anima na. Ndiakan kùu na takua kùu ma chiti ña tāchi iin nuu ñu'u' va'a. Ta iin ñivi ikan kùu na takua kùu ma trigu ña chā'a oko uchi ta'an chiti. Ta inga tuku yi chā'a uni xiko chiti. Ta inga na kùu na takua kùu ma ña chā'a iin cientu chiti ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Takan kūu ta te'en nāka'an tuku Jesuu inga ku'va nuu ma ñivi: ―¿A va'a tu kutaa xe'o iin kandil tichi iin kisi ñu'u', a iin xuu chito, kùuni ndo? ¡Na küu yi! Ti tu tüvi tàkaa sukun yo yi, na küu ndo ndichin nuu yo jā'a yi. ");
INSERT INTO mza_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Vati na küu tixe'o nï'iin ña jà'a yo, ti tiá kivi ni koto ndisaa ñivi ma ña tīxe'o. Ta juuni na küu ka'an yo nï'iin tu'un xe'e kua'a' tiempu, ti ni chaa iin kivi ña ni koto kachin ndisaa ñivi yi ndia. ");
INSERT INTO mza_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yakan va te'en nāka'an tuku Jesuu chi'in na: ―¡Na taso'o va'a ndo ña ni ka'in chi'in ndo, tuva ìyo chinituni ndo! ");
INSERT INTO mza_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tajan te'en nāka'an ndio ra chi'in na: ―¡Na ja'a ndo kuenda nuu ndo ma tu'un ña kà'in nuu ndo! ¡Na kuni va'a ndo yi ta jachi'in ndo yi ora tìndee ndo inga ñivi, ta takan Ndioo ni ja'a ra chi'in ndo, ta ni ku'va ra ña kutuni ndo tiá kua'a' yi! ");
INSERT INTO mza_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yakan va tu ja'a va'a ndo ma tiñu Ndioo, ni tindee ra ndo tiá kua'a'. Va tu tüvi jatiñu ndo kuenda Ndioo, ni kindaa ra ma tiñu jà'a ndo, vaji töva kua'a' yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Takan kūu ta te'en nāka'an tuku Jesuu: ―Indukuni kùu ma nuu chà'nda Ndioo tiñu kua iin chiti tāchi iin ratàchi. ");
INSERT INTO mza_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ti ma chiti ikan kàna yi ta chà'nu yi, vaji kìxi ra a ndìto ra. Yakan va rakan tüvi chìto ra naja kua jā'a yi ña chà'nu yi. ");
INSERT INTO mza_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ti ma chiti ikan, juuni ma ñu'u' jā'a ña kàna yi. Va ji'na kēta ma punta yi, tajan kēta ma yoko yi. ");
INSERT INTO mza_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ta ora cha nātii ndio ma yoko yi, tajan kìndaa ndio yo ma chiti ikan. Ta chàchi ndio yo yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Takan kūu ta te'en nāka'an tuku Jesuu ndia: ―¿Nda chi'in induku ma nuu chà'nda Ndioo tiñu?, kùuni ndo. ¿A nda chi'in kùu jando induku yo yi? ");
INSERT INTO mza_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Ti ma nuu chà'nda Ndioo tiñu, indukuni yi chi'in ma chiti mostaza ña tàchi yo. Ti vali yi va chà'nu yi tiá kua inga tuku yukú. Ña chi'in soko na'nu yi, nda saa kùu ja'a ri taka ri nuu vati soko run ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yakan va chi'in tu'un i'ya jàna'a Jesuu ma tu'un Ndioo chi'in kua'a' ku'va, ña cha kā'an ra i'ya. Yakan va Jesuu jàna'a ra nuu na, nda kati kutunini na tu'un kà'an ra. ");
INSERT INTO mza_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Va nï'iin tu'un tüvi kà'an ra, tu tüvi kà'an ra yi chi'in ku'va. Va ma ndra jàkua'a chi'in ra jàna'a ra naja kua kùuni ma ku'va ikan kà'an kachin yi nuu ndra inga ora. ");
INSERT INTO mza_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Takan kūu ta ora kuaa ma kivi ikan, tajan te'en nāka'an Jesuu chi'in ndra jàkua'a chi'in ra: ―¡Na ko'o inga chiyo lakuna! ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tajan ndàkoo ndio ndra ma ñivi ikan yu'u lakuna, ta kuà'an ndio ndra chi'in Jesuu juuni tichi lancha nuu indii ndra chi'in ra. Ta ikan juuni tāndikun inga lancha ndàka ta'an chi'in ndra kuà'an run chata ma lancha ndra ndia. ");
INSERT INTO mza_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ta ora cha kàcha'an ndio ndra nuu lakuna, ta kōyo ndio savi tati chata ndra. Ta ikan kīcha'a kì'vi ndio takuii ikan tichi ma lancha. ");
INSERT INTO mza_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Takan kūu ta tīin ñuma'na Jesuu, ta nduva'a kuii kìxi ra kàndii ra iti' xuu lancha chi'in chala ra. Tajan jāndakoo ndio ndra ra, ta te'en kīcha'a kà'an ndra chi'in ra: ―Matru, ¿a tüvi ndè'un, ti chani ka'a yo? ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ta ikan jan ndēta ndio Jesuu, ta te'en kīcha'a kà'an ndio ra chi'in ma savi tati. ―¡Na kutaxin ndo! ―kàti ra. Tajan kūtaxin ndio ma savi tati chi'in ma takuii lakuna. ");
INSERT INTO mza_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tajan te'en nāka'an ndio ma Jesuu chi'in ma ndra jàkua'a chi'in ra: ―¿Ta naja ya'a ndasii ndo? ¿A takä'an chinuni ndo tu'un Ndioo ña jā'a ndo takan? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Takan kūu ta ndrakan nduva'a kuii yū'vi ndra, ta kīcha'a ndra chìkatu'un ta'an ndra: ―¿Nda ra kùu ra'ya, ña nda savi tati ta lakuna jàchi'in ña kà'an ra? ―kàti ndra ña nàtu'un ta'an maa ndra. ");
INSERT INTO mza_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Takan kūu tajan kēta chiyo ndio Jesuu chi'in ndra jàkua'a chi'in ra inga chiyo yu'u lakuna. Ta ikan kàndii iin ñu'u' nàni Gerasa. ");
INSERT INTO mza_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ta ora nūu ndio Jesuu tichi lancha, ta ikan tū'va iin ra ndiso tati xaan nuu ra. Ta rakan ti já kēe ra nuu ìyo ra kamajandu, ");
INSERT INTO mza_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ti ikan ìyo ra. Ta nï'iin na küu tiin na ra, ni chi'in kadena küu ku'ni na ra. ");
INSERT INTO mza_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yakan va jin kua'a' cha'a' cha chū'ni na nda'a' ra chi'in cha'a ra chi'in kadena, va endee ndì'i yi jàche'e ra. Yakan va nï'iin na kündee na ra. ");
INSERT INTO mza_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ta ndisaa tiempu chàkunuu ra ora ndichin ta ora naa, iti' yuku taxiin nuu tüvi ñivi. Ta juuni chàkunuu ra iti' kamajandu, ña endee ndà'yu ra chàkuu ra ikan. Ta endee kàni maa ra ra chata yuu. ");
INSERT INTO mza_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Takan kūu ta ora ndē'e ndio ra ña chika ga vàchi Jesuu, ta endee kàndakunu ra kuàta'an ndio ra nuu vàchi ra. Ta ora chāa ndio ra nuu ndaa Jesuu, ta chūnandi chiti ra nuu ra. ");
INSERT INTO mza_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ta te'en kīcha'a ndio ra kànachaa ra nuu Jesuu: ―¿Nayi kùuniun ja'un chi'i̱n, yo'o Jesuu, Se'e Ndioo ra ìyo andivi? ¡Chi'in sivi Ndioo, chìkain ñamani nuu̱n ña na kï'viun chi'i̱n! ―Takan kàti yi chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kà'an yi takan chi'in Jesuu, vati ji'na ra nāka'an te'en nuu yi: ―¡Yo'o tati xaan, na keun tichi kuñu ra'ya! ―kàti Jesuu chi'in yi. ");
INSERT INTO mza_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Takan kūu ta te'en chīkatu'un ndiko Jesuu nuu yi: ―¿Naja nàniun? ―kàti Jesuu. Ta te'en nāka'an yi: ―Nàni ndi Legion, ti kua'a' tati xaan kùu ndi ña ìyo ndi tichi kuñu ra'ya ―kàti yi. ");
INSERT INTO mza_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Takan kūu ta ma tati ikan chīkan yi nuu Jesuu ña na täva ra yi ma tichi ñuu ikan. ");
INSERT INTO mza_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ta tava ndē'e yi ña yatini xiin ma yuku ndaa ikan, ka'ìin kua'a' kini ña kàchika ndri chàchi ndri ku'u kàa ikan. ");
INSERT INTO mza_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yakan va ma tati xaan te'en chìkan yi nuu Jesuu: ―¡Na ja'un tia ñamani nuu ndi, ña tachiun ndi na ki'vi ndi tichi kuñu ma kini kàchika ikan! ―kàti yi. ");
INSERT INTO mza_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","―Va'ani tuva takan kùuni ndo ―kàti Jesuu chi'in yi. Tajan kēe ndio yi kuñu ma ra'ii ikan, ta kuà'an yi. Tajan kī'vi yi ma kuñu ndri. Takan kūu ta ma kini kàchika ikan, ti uvi mii ta'an ndri kùu ndri. Ta ora kī'vi ndio na tichi kuñu ndri, tajan kāndakunu ndio ndri kuà'an ndri. Ta kāchita ndri iin xa'va ña ìyo yu'u lakuna. Ta ikan kā'a ndri tichi lakuna ta chī'í ndri. ");
INSERT INTO mza_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ta ma ndra kùmi ma kini endee chīnu ndra kuà'an ndra ora ndē'e ndra ma ña jā'a chi'in ndri. Yakan va ora chāa ndra ma ñuu ta kīcha'a ndra nàtu'un ndra ña tā'an ma kini chi'in tandi'i ñivi ìyo kuariya ta chi'in ñivi ìyo ñuu ndia. Takan kūu ta kēe ndio na kuànde'e na nuu kāchita ndri. Ta ora ndē'e na ndri, tajan ndīkoni'i ndiko na nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ta ora kūyatin ndio na nuu ndaa Jesuu, ta ikan ndē'e ndio na ma ra tìvi xini niku. Ña cha ñù'u ndio ra ja'ma nàndi ra. Va tüva jà'a ra takua jā'a ra ora ndiso ra tati xaan niku. Ta ndava kuà'an tati na ora ndē'e na ña cha ndòva'a ra. ");
INSERT INTO mza_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Takan kūu ta ma ñivi ña ndē'e kua tā'an ma ra ndiso tati xaan chi'in ña tā'an ma kini, kīcha'a na nàtu'un na yi chi'in inga ñivi ña kūu. ");
INSERT INTO mza_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Takan kūu tajan kīcha'a ma ñivi ñuu kà'an na nuu Jesuu na kee ra ku'un ra ma ñu'u' ikan. ");
INSERT INTO mza_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Takan kūu ta ora ndāa ndiko Jesuu tichi lancha, ta nduva'a kuii jānini ma ra ndiso tati xaan niku Jesuu, ña kùuni ra ku'un ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Va Jesuu tüvi nī cha'a ra ku'un ra chi'in ra. Ta te'en kīcha'a kà'an ra chi'in ra: ―¡Kindoo yo'o, xaa! ¡Ta kuà'an ve'un nuu ìyo ñiviun! ¡Ta katitu'un nuu vi, ndisaa ña jā'a Racha'nu Ndioo chito'un chi'un, ta naja kua kūnda'vini ra ñu̱n ña jānda'a ra ñu̱n! ―kàti Jesuu. ―Va'ani tuva takan ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tajan kuà'an ndio ra. Ta kīcha'a kàtitu'un ra nuu ndisaa ñivi ñuu Decápolis ña jāndova'a Jesuu ra. Ta ndisaa ñivi ikan ndava yu'vi na, ña kà'an ra takan chi'in na. ");
INSERT INTO mza_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Takan kūu ta ora ndīkoni'i ndiko Jesuu ma inga chiyo lakuna chi'in lancha. Tajan ma ora ikani kua'a' ñivi kūti'vi nuu ndaa ra yu'u lakuna. ");
INSERT INTO mza_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Takan kūu tajan chāa ndio iin ra vika ndiso tiñu veñu'u ñivi judíu ña nàni Jairo. Ta ora ndē'e ra Jesuu numini chūnandi chiti ra nuu ra. ");
INSERT INTO mza_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ta ikan nduva'a kuii chīkan ra ñamani nuu Jesuu. Ta te'en nāka'an ra chi'in Jesuu: ―¡Chani kuvi ma ñavali se'i! ¡Yakan va ko'o ta jananiun nda'un chata ña! ¡Ikan na nda'a va'a ña ta koo ndikoan! ―Takan kàti ra chi'in Jesuu. Ta te'en nāka'an Jesuu chi'in ra: ―¡Na ko'o, tuva takan! ―kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ta ikan jan kēe ndio Jesuu kuà'an ra chi'in ra. Ta ikan juuni tāndikun kua'a' ñivi kuà'an na chata ndra ña ndava tituu ta'an na. ");
INSERT INTO mza_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta tañu ma ñivi kàcha'an ikan, kuà'an iin ña cha ìyo uchi uvi kuiya ña ku'vian jà'a niian. ");
INSERT INTO mza_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ta nduva'a kuii cha ndē'an tundo'o nda'a' ndra chìto jà'a tatan. Ta tüvi ndòva'a ña, vaji jānaa ña ndisaa xu'un' kumian. Java vi'aga ka'vi kùunian jā'a yi. ");
INSERT INTO mza_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yakan va ora chīnian ña kà'an Jesuu, ta tāndikun ndioan kuà'an ña. Ta ikan jāyatin ndioan ña iti' chata ra. Tajan jānanian nda'a' ña ja'ma ra. ");
INSERT INTO mza_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta te'en kīcha'a ña chàninian: “Jitu ja'mani ra na ke'o, ta chi'in yakani kuu nda'a yo,” kùunian, ña chàninian. ");
INSERT INTO mza_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ta ikan jan kē'e ndioan ma ja'ma ra, ta ma ora ikani kūtaxin ma niian. Ta ndā'a ña. ");
INSERT INTO mza_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Takan kūu ta ikan tūvini Jesuu ña kēe ita'vi ndatu ndiso ra. Tajan ndīkoni'i ra nde'e ra nuu ma ñivi. Ta te'en chīkatu'un ra nuu na: ―¿Yo kē'e ja'mai nda che'e? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta te'en nāka'an ndio ma ndra jàkua'a chi'in ra: ―Matru, ¿a tüvi nde'un, ti ya'a kua'a' ñivi tìtu ta'an xiun? ¿Ta chìkatu'un gaun ña yo kē'e ñu̱n? ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tajan chīkonuu ndio Jesuu ndè'e ra ma ndian ka'ìin xiin ra, va ti kùuni ra nde'e ra yo kùu ma ña kē'e ja'ma ra. ");
INSERT INTO mza_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yakan va ma yakan ndava yù'vian ña kā'an ra, ti cha chìtoan ña tā'an ña ora kē'an ma ja'ma ra. Ta ikan jan chāa ndioan nuu ra, ta chūnandi chitian. Ta kàtian ndisaa ña tā'an ña nuu ra. ");
INSERT INTO mza_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ta te'en nāka'an ndio Jesuu chi'an: ―Yo'o se'yu, ¡cha kuu ku'un vitin! Ti cha ndā'un jā'a ña chìnuniun. ");
INSERT INTO mza_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Takan kūu ta juuni takä'an chinu kà'an Jesuu nuan, ora chāa inga ma ndra ìyo ve'e ma ra vika ndiso tiñu veñu'u ñivi judíu. Ta te'en kīcha'a kà'an ndra nuu tatá ñavali ikan: ―Cha chī'í ma ña se'un. ¿Yakan va nda kuenda ña jàkenaa ka'un tiempu ra? ―Takan kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Takan kūu ta ora chīni Jesuu ña kà'an ndra takan chi'in Jairo, tajan te'en kīcha'a nàka'an Jesuu chi'in ra: ―¡Na yü'viun! ¡Na chinuniun ma ña jà'i! ―kàti Jesuu chi'in ma ra vika veñu'u ñivi judíu. ");
INSERT INTO mza_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta ikan jan kēe Jesuu kuà'an ra chi'in Petu', Jandiau ta Xuva, ra yani Jandiau. Ta tiá ma ñivi tüvi nī cha'a ra ña ku'un na chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Takan kūu ta ora chāa ndra ve'e ma ra vika veñu'u ñivi judíu. Ta ikan ndē'e Jesuu ña ya'a kuvaa ñivi ka'ìin ikan, ña kàchaku na. ");
INSERT INTO mza_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ta ikan jan kī'vi Jesuu tichi ve'e chi'in ndra kuà'an chi'in ra. Ta te'en nāka'an ndio Jesuu: ―¿Ta naja ya'a kàchaku ndo? Ta ma ñavali ikan tüvi nī chi'an, ti kìxinian ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ta ma ñivi ikan java chakú ndaani na ña kà'an ra. Va te'en nāka'an tuku Jesuu chi'in ma ñivi, na kee na nuke'e. Tajan kī'vi ndio ra chi'in ma ndi uni ndra chāa chi'in ra, chi'in tatá ña ta ma'á ña nuu kàndian. ");
INSERT INTO mza_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tajan tīin ndio Jesuu nda'a' ña ta te'en nāka'an ra chi'an: ―¡Talita kum! ―Tu'un i'ya te'en kùuni yi ka'an yi: Chi'un kà'in yo'o, xi'i. ¡Na ndetaun! ―kàti ra chi'an. ");
INSERT INTO mza_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ta ma ora ikani ndēta ña, ta numini kīcha'a ña chàkunuan. Ta yakan ti já uchi uvi kuiya ña. Ta ora ndē'e ma ñivi ña nāndoto ndikoan, ndava yū'vi na. ");
INSERT INTO mza_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ta te'en nāka'an ndio Jesuu chi'in na: ―¡Na kä'an ndo ña jā'i nuu nï'iin ñivi! ―kàti Jesuu. Tajan kīcha'a kà'an ndio ra chi'in ma ñivi ikan na ku'va vi ña kachian. ");
INSERT INTO mza_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Takan kūu tajan kēe ndio Jesuu kuà'an ra chi'in ndra jàkua'a chi'in ra nda ñuu ra. ");
INSERT INTO mza_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ta ora chāa ndio ma kivi nindeo, tajan kīcha'a Jesuu jàna'a ra tichi veñu'u ñivi judíu. Ta ma ñivi ikan, ti ya'a ndē'e ndaa na Jesuu ora chīni na ña kà'an ra. Yakan va te'en kīcha'a na chìkatu'un ta'an na: ―¿Ndanu kūtu'va ra ña kà'an ra? ¿Ta ndanu tāva ra ma ña chìto ra chi'in ma ndatu ra? ");
INSERT INTO mza_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿A yüvi rakan kùu ra se'e Ndiya, ra jàtiñu chi'in vitu, niku? Chìto yo ti yani ra kùu Jandiau, ta Kusé, ta Juda chi'in Simón. Ta juuni i'ya ìyo ma ñivi ta'an ra ndia. ―Takan kàti na ña nàtu'un ta'an na. Yakan va nī jachi'in na ña kà'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ta te'en nāka'an ndiko Jesuu chi'in na: ―Taku ra kà'an kuenda Ndioo nda ni kùuni jaka'nu na ra, va juuni ma ñuu nuu chā'nu ra, tüvi yo kùuni nde'e ra, ni ma ñivi ra ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yakan va nī kuu ja'a Jesuu kua'a' tiñu ndatu ikan, ti ya'a xaani na ndè'e na ra. Ma ña jā'a ra, kūu ña jundii ra nda'a' ra chata tia ma ndian ku'vi, ta ndā'a na jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Takan kūu ta ya'a nàkanini ra ña tüvi chìnuni ma ñivi ñuu ra ña jà'a ra. Ta ikan jan kēe ndio ra kuàjana'a ra ñuu ìyo yatini ma ikan. Takan kūu ta Jesuu chākunuu ndio ra jàna'a ra nuu ìyo ñuu kuati ìyo yatini. ");
INSERT INTO mza_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ta ikan jan kāna ndio Jesuu ndi uchi uvi ndra jàkua'a chi'in ra. Ti ni tachi ra ndra kuenda uvi ndra, ti ni ku'va ra ndatu ra nuu ndra. Ta ni tachi ra ndra ña kujanda'a ndra ñivi ndiso tati xaan. ");
INSERT INTO mza_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Va ji'na te'en nāka'an ra chi'in ndra: ―Tüvi kunaa ndo nï'iin nakuyi tichi iti' kuà'an ndo, ni yunu, ni xita', ni xu'un'. Kùu kunaa ndo, va iin yutun vatuni, ");
INSERT INTO mza_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ta kundii cha'a ndo ndichan ni. Ta juuni na küu ku'un toto ndo ja'ma ndia. ");
INSERT INTO mza_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ta ora kì'vi ndo ve'e iin ñivi, na koo ndo ma ikan nda kati keta ora ku'un ndo inga ñuu. ");
INSERT INTO mza_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Vatu chaa ndo ve'e iin ñivi, ta tüvi jàchi'in na ma ña kà'an ndo, ta tüvi taso'o na yi, tiá va'a tu numini kee ndo ma ñuu ikan, ta ku'un ndo inga ñuu. Ta na jakisi ndo yuyaka ka'ìin ndichan ndo, ikan nakoto na, ti töve ni ni'i na ñamani Ndioo, ti töve nī jachi'in na ma tu'un Ndioo ña kàtitu'un ndo nuu na. ―Takan kāti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Takan kūu tajan kēe ndio ndra jàkua'a chi'in Jesuu kàcha'an ndra ña kuàkatitu'un ndra nuu ma ñivi na ndikoni'i ndiko na chi'in ma Racha'nu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ta juuni tāva ndra kua'a' tati xaan ndiso ñivi. Ta chi'in cete jā'ií ndra xini ma ndian ku'vi, ta ndōva'a na. ");
INSERT INTO mza_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Takan kūu tajan chīto ndio ma Rey Herode ña jà'a Jesuu. Ta ndisaa ña jà'a ra chītakuati ndio yi ma ñuu ikan. Yakan va te'en nāka'an ndio Rey Herode: ―¡Ndicha kuii ña rakan kùu Xuva Tita! Ta nāndoto ndiko ra tañu ñivi ndií. Yakan jànda'a kua'a' ñivi chi'in ndatu ra. ―Takan kāti ma Rey Herode. ");
INSERT INTO mza_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ta ìyo inga tuku ndian kà'an te'en: ―¡Rakan kùu Elía, ra kā'an chi'in tu'un yu'u Ndioo taji'na! ―kàti na. Ta ìyo inga ndian kà'an te'en: ―¡Rakan kùu ra kà'an chi'in tu'un yu'u Ndioo, takua kā'an ndra chīyo taji'na! ");
INSERT INTO mza_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yakan va ora chīni Rey Herode ña kà'an na takan, ta te'en kīcha'a kà'an ra: ―¡Ndicha kuii ña rakan kùu Xuva, ña tāchi̱ ña chāka'nda ndra xini ra! ¡Va vitin juu ra kùu ra ña nāndoto ndiko ra! ―Takan kàti Rey Herode. ");
INSERT INTO mza_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ti cha'a' ña nàni Herodías tī'i ma Rey Herode Xuva Tita tichi vekaa. Takan kūu ta ora cha tī'i ndra ra tichi vekaa, tajan chū'ni ndio ndra ra chi'in kadena. Ta ma ña nàni Herodías juuan chūndaka ra nàni Lipe niku, ra yani Rey Herode. Ta vitin cha sū'u Rey Herode ña nuu ra yani ra, ta tānda'a ndiko ra chi'an. ");
INSERT INTO mza_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ti te'en kā'an Xuva chi'in Herode ora takä'an ti'i ra ra tichi vekaa: ―Iin kuati kùu yi tu ndakaun ñasi'i ma ra yaniun. ―Takan kàti Xuva. ");
INSERT INTO mza_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yakan va cha'a' yakan kùu yi, ña xaani Herodías ndè'an Xuva. Yakan va kùunian ka'nian ra. Va nī kuu yi. ");
INSERT INTO mza_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ti Rey Herode yū'vi ra nde'e ra Xuva, ti chìto ra ti iin ra ndaa ta va'a kùu ra nuu Ndioo. Yakan va kùmi va'a Herode ma Xuva, ti koto ki'vi Herodías nuu indii ra, ta ka'nian ra. Yakan va ora kàtitu'un Xuva ma tu'un Ndioo nuu Rey Herode, chàta'ani ra ma ña kà'an yi, va tüvi jàchi'in ra yi. ");
INSERT INTO mza_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Takan kūu ta chāa iin kivi ña ndè'e ndio ma Herodías naja kua ja'a ña, ña ni ka'nian Xuva. Ti ma kivi ikan kùu yi ña chīnu Rey Herode kuiya ra. Tajan jā'a ndio ra iin viko ka'nu. Tajan jāinvitaa ra tandi'i ndra vetiñu ìyo ñuu ra, chi'in ndra capitán chà'nda tiñu nuu jandaru, ta inga ndra cha'nu ìyo ñu'u' Galilea ndia. ");
INSERT INTO mza_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Takan kūu ña kī'vi ña se'e Herodías nuu jà'a ndra viko. Ta kīcha'a ña tàcha'a ña nde'e ndra. Ta ma Rey Herode chi'in ndra ka'ìin chi'in ra nduva'a kuii chàta'ani ndra kua tàcha'a ña. Ta te'en kīcha'a kà'an ndio Rey Herode chi'an: ―Ku'vai tu'un nuu̱n, ña na ndakaun nayi kùuni maun nui, ta ku'vai yi nuu̱n ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Takan kūu ta nda uvi cha'a' chā'a tuku ra tu'un nuan ña na ndakan ña nayi kùuni maa ña nuu ra, vaji java ma ñu'u' ñuu nuu chà'nda ra tiñu, ku'va ra yi nuan, kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Va yakan tüvi nī ka'an ña ma ña kā'an ra chi'an. Takan kūu tajan kēan chàndakatu'an nuu ma'á ña. Ta te'en nāka'an ña nuu ma ma'á ña: ―¿Nayi ndakai nuu ra vitin?, kùuniun, yo'o ma'á ―kàtian. Ta te'en nāka'an ndio ma ma'á ña chi'an: ―¡Na ndakaun xini Xuva ra jàkunduta nuu ra! ―kàtian. ");
INSERT INTO mza_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tajan numini kēan kuà'an ña nuu nàndi Rey Herode. Ta te'en kīcha'a kà'an ña chi'in ra: ―Kùuni̱ ña ni vitini ku'vaun xini Xuva ra jàkunduta iin tichi ko'o nui ―kàtian chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ta ora chīni ra ña kà'an ña takan, nduva'a kuii nda'vi kùuni ra. Va tava cha chīni ma ndra ka'ìin xiin ra ña chā'a ra tu'un nuan, yakan va ìyo yi ña ja'a ra ma ña chìkan ña nuu ra. ");
INSERT INTO mza_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yakan va tāchi ndio ra iin jandaru ña kuka'nda ra sukun Xuva nuu indii ra tichi vekaa. ");
INSERT INTO mza_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Takan kūu tajan kēe ndio ma jandaru kuà'an ra nuu indii Xuva vekaa. Ta ora chāa ndio ra nuu indii ra, ta chā'nda ra sukun ra chi'in machiti. Tajan chāndaka ndio ra yi iin nuu ko'o nuu ña tivaa ikan. Ta yakan chāndaka ña yi nuu ma'á ña. ");
INSERT INTO mza_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Takan kūu ta ora chīto ma ndra jàkua'a chi'in Xuva ña chī'í ra, tajan chāki'in ndra ma ñunda'yu ra. Ta chākuchi ndra yi. Takan tā'an Xuva ra jàkunduta. ");
INSERT INTO mza_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Takan kūu ta ora yā'a ña kūu takan, tajan kūti'vi ma ndra tatun Jesuu chi'in ra. Ta kātitu'un ndra nuu ra ndisaa ña jā'a ndra, ta ña jāna'a ndra nuu ra ndia. ");
INSERT INTO mza_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―¡Na'a ndo! ¡Nako'o iin nuu taxiin nuu tüvi ñivi! Ta ikan nindeo ita'vi ―kàti Jesuu chi'in ndra. Takan kàti Jesuu chi'in ndra, ti nduva'a kuii chàkoyo kua'a' ñivi nuu ndaa ra chi'in ndra tatun ra, ña nī kuyati ra kachi ra chi'in ndra jà'a na. ");
INSERT INTO mza_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yakan va kēe ndio Jesuu kuà'an ra chi'in ndra tatun ra tichi lancha iin nuu tàxiin. ");
INSERT INTO mza_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Va tava kua'a' na ndē'e na nuu kuà'an ndra. Ta nàkoto na ti Jesuu kùu ra ña kuà'an ra chi'in ndra tatun ra tichi lancha. Tajan ndisaa ndio ma ñivi kandakunu na kuà'an na nuu ni chaa ndra. Ta ji'na ga na chāa, tajan chāa ndra. ");
INSERT INTO mza_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Takan kūu ta ora nūu Jesuu ma lancha, ta ndē'e ra ña ka'ìin kua'a' ñivi. Ta kūnda'vini ra na, ti ka'ìin na takua ka'ìin iin mvechala ña tüvi chito'o. Tajan kīcha'a jàna'a ra kua'a' tu'un Ndioo nuu na. ");
INSERT INTO mza_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ta ora cha kua ini, tajan chāa ndio ndra jàkua'a chi'in ra nuu ra. Ta te'en nāka'an ndra chi'in ra: ―Cha ini kùu yi vitin. Ta i'ya ti iin nuu tàxiin kùu yi. ");
INSERT INTO mza_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yakan va, ¿a va'a tu jandutáun ma ñivi, ta na ku'un na nuu nì'i na jàta na ña kachi na? ―Takan kàti ndra jàkua'a chi'in ra nuu ra. ");
INSERT INTO mza_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ta te'en nāka'an Jesuu chi'in ndra: ―¡Maa ndo na ku'va ndo ña kachi na! ―kàti Jesuu. Ta te'en nāka'an ndra nuu ra: ―¿Ta naja ja'a ndi, ta ni'i ndi xu'un' ña jata ndi ma paan, tu tüvi yi? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ta te'en nāka'an tuku Jesuu chi'in ndra: ―¡Kuànde'e ndo, nde'o naja ta'an paan ìyo nuu ndo! ―kàti Jesuu. Ta ora chānde'e ndio ndra nuu ka'ìin yi, ta te'en nāka'an ndra chi'in Jesuu: ―U'un paan, ta uvini tiaka' indii ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Takan kūu tajan tāchi Jesuu ma ndra jàkua'a chi'in ra na ka'an ndra chi'in na, na kuiin ta tia ta tia na nuu ita yuta' ikan. ");
INSERT INTO mza_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tajan chākuiin na kuenda iin cientu ta kuenda uvi xiko uchi na. ");
INSERT INTO mza_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ta ikan jan kī'in ndio Jesuu ma ndi u'un paan ta ndi uvi ta'an tiaka'. Tajan ndē'e ra iti' andivi, ta te'en kà'an ra chi'in Ndioo: ―Ta'vindioun Ndioo. Ti chā'un ma paan ta tiaka' nuu ndi ―kàti Jesuu. Tajan jākuati ra ma paan chi'in tiaka'. Ta chā'a ra yi nuu ma ndra jàkua'a chi'in ra na nata'vi ndra yi nuu na. ");
INSERT INTO mza_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Takan kūu ta chāchi ndisaa na nda kati chitu va'a tichi na. ");
INSERT INTO mza_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ta uchi uvi ga tuka kùu yi ña chàkoso yi ora chīnu chàchi na. ");
INSERT INTO mza_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yakan va ma ndra chā'a Jesuu ña chàchi, u'un mii ta'an ndra kùu ndra. ");
INSERT INTO mza_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Takan kūu ta ora yā'a ña kūu takan, tajan tāchi ndio Jesuu ma ndra jàkua'a chi'in ra, na ndaa ndra tichi lancha. Ta ji'na ndra na keta chiyo ndra ñuu Betsaida. Ta rakan, juuni yanga ndōo ga ra kà'an ra chi'in ñivi ña ni ku'un ra. ");
INSERT INTO mza_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta ora cha ndī'i na ndùta, tajan ndāa ndio Jesuu iin yuku ña kuàka'an ra chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Takan kūu ta ora cha kuna'a, ma lancha ikan cha kēta run nda java lakuna chi'in ndra. Ta Jesuu ti juuni ndaa ra yu'u lakuna nuu ndākoo ndra ra. ");
INSERT INTO mza_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ikan ndaa Jesuu ora ndē'e ra ña nduva'a kuii cha chìtatu ndra ña jàkunu ndra run chi'in yutun xa'nda nuu. Ti vaji ni'i jà'a ndra ña nakunu run, va töve chìka nda'a' ndra ti ya'a ni'i chàkin ma tati. Yakan va ìyo yi a kaa uni na'ani ora kēe Jesuu ña chika ra kuà'an ra nuu takuii iti' kuà'an ndra. ");
INSERT INTO mza_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Takan kūu ta ora ndē'e ndra ña chìka Jesuu vàchi ra nuu takuii xiin lancha ndra, ta kùuni ndra ña iin ni'na kùu yi ña chìka yi vàchi yi niku. Ta iin kuvaani ndra ña nduva'a kuii yū'vi ndra. ");
INSERT INTO mza_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Vati tandi'i ndra ndē'e ndra yi, yakan va yū'vi ndra. Ta ikan te'en nāka'an ndio Jesuu chi'in ndra: ―¡Na yü'vi ndo!, ti mai kùi. ―Takan kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ta ikan jan jāyatin ndio ra ra nuu ka'ìin ndra tichi lancha. Tajan ndāa ndio ra tichi run. Ta ma ora ikani kūtaxin ma tati ña chàkin yi. Ta ndrakan ndava kuà'an anima ndra ña jā'a yi takan ora chāa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Vati takä'an kuu kutunini ndra ma ndatu jā'a Jesuu chi'in paan. Ta ni takä'an nakoto va'a ndra nda chi'in ndatu kùu yi ña jā'a ra yi. ");
INSERT INTO mza_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Takan kūu ta ora cha kēta chiyo ndio ndra ma ñu'u' Genesaret. Ta ikan chū'ni ndio ndra ma lancha ndra yu'u lakuna. ");
INSERT INTO mza_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ta ikan jan nùu ndio ndra run. Ta numini nākoto ma ñivi ra, ti Jesuu kùu ra. ");
INSERT INTO mza_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Takan kūu ta ora ndē'e ndio ma ñivi ña chāa ndio Jesuu ikan, ta numini kàtitu'un na nuu tandi'i ma ñivi ìyo ñu'u' ikan. Tajan kīcha'a ndio na chàndaka na ndian ku'vi chi'in ti'va nuu chìto na nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yakan va nda nikuuni nuu chà'an Jesuu, a ñuu kuati a ñuu na'nu a tichi ku'u, ikan jātu'va na ma ndian ku'vi yu'u kai a nuya'vi nuu chàkunuu ra. Ta chìkan na ñamani nuu Jesuu na ku'va ra ke'e ma ndian ku'vi, jin tu ja'mani ra. Ta ndisaa ma ndian kē'e ja'ma ra, ndà'a na jà'a ndatu ra. ");
INSERT INTO mza_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Iti' ñuu Jerusalén kīchi ndra fariseu chi'in ndra jàkua'a tutu Ndioo. Ta ikan jan jākuyatin ndio ndra ndra nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ta ndrakan ora ndē'e ndra ña jà'a ndra jàkua'a chi'in Jesuu ña kàchachi ndra, va tüvi nàkata ji'na ndra nda'a' ndra. Yakan va kā'an ndra chata ndra jàkua'a chi'in Jesuu, ti tüvi ndoo nda'a' ndra takua ìyo ma costumbre ñivi judíu. ");
INSERT INTO mza_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ti ndian fariseu chi'in ndian judíu, jà'a na ma ña jà'a ma ndian chīyo taji'na. Ta ndiakan ti tüvi kuu kachi na tu takä'an ndoo nda'a' na. ");
INSERT INTO mza_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ta ora kìchaa na ña chā'an na nuya'vi, na küu kachi na, tu takä'an nakata na nda'a' na ndia. Ta juuni ìyo inga costumbre ña jà'a na ndia, takua jà'a na, ña nàkata na yachin, kasitu, kisi, chi'in yuvi. ");
INSERT INTO mza_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yakan va te'en kīcha'a chìkatu'un ndra fariseu chi'in inga ndra jàkua'a tutu Ndioo nuu Jesuu: ―¿Naja tüvi jà'a ndra jàkua'a chi'un ma costumbre jà'a ndian chīyo taji'na? Ña tüvi nàkata ji'na ndra nda'a' ndra ta kachi ndra ―kàti ndra nuu Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tajan te'en nāka'an Jesuu chi'in ndra: ―Ña ndicha kùu ña kā'an ra kà'an chi'in tu'un yu'u Ndioo nàni Isaía kuenda ndo. Ti tüvi jà'a ndo ma ña kà'an ndo. Ta Isaía ti te'en kā'an ra, niku: Ma ñivi jàka'nu Ndioo jàka'nu na ra chi'in tu'un kà'ani na, va tüvi jàka'nu na ra chi'in anima na. ");
INSERT INTO mza_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ta tüvi nda kuenda kùu yi ña jàka'nu na Ndioo. Ti ma tu'un ña jàka'nu na Ndioo, tu'un kà'an ñivini kùu yi. Ta ma ñivi ikan kà'an na, ti tu'un Ndioo kùu yi. Takan kā'an ra Isaía chīyo taji'na. ");
INSERT INTO mza_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ti ndyo'o, ndàkoo ndo ma ña kà'an Ndioo ña jà'a ndo, ta jà'a ndo ma tu'un jàna'a ñivini. ");
INSERT INTO mza_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Takan kūu ta te'en nāka'an tuku Jesuu nuu ndra ndia: ―Ya'a ga chìnuni ndo ma costumbre ña jà'a juuni maa ndo. Va ma tu'un Ndioo töve jàchi'in ndo yi, ");
INSERT INTO mza_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ti te'en kāti Moisés taji'na: “¡Na jaka'nu ma tatáun chi'in ma'un!” “Tatu kanduva'un tatáun, a ma'un, ta ka'ndaun kuenda ña kuviun jà'a inga ñivi”, kāti Moisés. ");
INSERT INTO mza_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Va ndyo'o ti te'en kà'an ndo: “Na vä'a tu iin ra'ii küuni ra tindee ra tatá ra chi'in ma'á ra.” Ta rakan ti te'en kà'an ra nuu vi: “¡Na küu ga tindei ndo! Ti cha tāva siin ndisaa ña ìyo nui ña ni sokói yi nuu Ndioo.” Takan kàti ra nuu tatá ra chi'in ma'á ra. ");
INSERT INTO mza_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ta juuni kà'an ndo, ti yo kà'an te'en vitin, tüva ìyoni na tindee na tatá na chi'in ma'á na. Takan kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Va yu'u kà'in chi'in ndo, ti kua ikan jà'a ndo ña jàchiyo ndo tu'un Ndioo. Ti kùuni ndo ja'a ndo ma costumbre maa ndo. Ta juuni ma yakan jàya'a ndo yi nda nuu ñivi ndo ndia. Ta juuni ìyo inga tuku ña jà'a ndo ndia. ―Takan kàti Jesuu chi'in ndra fariseu ta ndra jàkua'a tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Takan kūu tajan kāna tuku Jesuu ñivi nuu ndaa ra. Ta te'en nāka'an ra chi'in na: ―¡Taso'o va'a ndisaa ndo ña ni ka'in chi'in ndo! ¡Ta na kutunini ndo yi ndia! ");
INSERT INTO mza_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nï'iin ña chàchi ñivi tüvi jàkini yi anima na chi'in chinituni na. Va ña kèe chinituni na kùu ma ña jàkini na. ");
INSERT INTO mza_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Yakan va tuva ìyo chinituni ndo na kuni ndo! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Takan kūu ta ora chīnu kà'an Jesuu takan, ta kēe ndio ra kuà'an ra nuu ìyo ve'e ña kìndoo ra. Tajan kī'vi ra ma tichi ve'e chi'in ndra jàkua'a chi'in ra. Tajan te'en kīcha'a ndio ndra chìkatu'un ndra nuu ra: ―¿Nayi kùuni ma ña jàna'un nuu ma ñivi kà'an yi? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ta te'en nāka'an Jesuu chi'in ndra: ―¿A juuni ya'a ndava xini ndo ña tüvi kùtunini ndo ña kā'in? ¿A tüvi chìto ndo, ti ndisaa ña chàchi ñivi tüvi jàkini yi chinituni na? ");
INSERT INTO mza_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ti tüvi chàa yi nda chinituni na. Chàa yi va nda nuu chitini na. Tajan tàva na yi ora chàti na ―kàti ra. Yakan va chi'in tu'un i'ya kùuni ra ka'an ra, ña ndisaa ma ña chàchio, va'a yi. ");
INSERT INTO mza_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ta te'en nāka'an tuku Jesuu chi'in na: ―Ndicha ti ña jàkini chinituni na, va kùu yi ma ña kèe chinituni na. ");
INSERT INTO mza_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ti tichi chinituni na kèe ma ña kini chànini na. Ti kùuni na ki'vi na chi'in ñivi ña'a' takä'an tanda'a. Ta juuni chi'in chinituni na, kùuni na su'u na, ta kùuni na ka'ni na ñivi. ");
INSERT INTO mza_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ta juuni kùuni na ki'vi na chi'in iin ña'a cha ìyo ii, ta ña'a chi'in ra'ii cha ìyo ñasi'i ndia. Ta ya'a kùuni na kukuika na. Ta kùuni na jati'ini na, ta kùuni na janda'viña'a na, ta chàta'ani na ja'a na kuati nuu nde'e tandi'i ñivi. Ta ndiakan, na tüva jaña na ña jà'a na yi. Ta xaani na ndè'e na inga ñivi cha'a' ña ìyo nuu na. Tajan kà'an ndio na chata ñivi. Ta jàka'nu na juuni maa na. Ta jà'a na ma ña kùuni maa na jà'a na. ");
INSERT INTO mza_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ndisaa yakan ña kini kēe chinituni na kùu yi. Ta yakan kùu yi ña jàkinini yi anima na. ");
INSERT INTO mza_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Takan kūu ta ora chīnu kà'an Jesuu takan, tajan kēe ndio ra kuà'an ra iti' ñuu Tiro ta Sidón. Ta ora chāa ra ñuu ikan, tajan kī'vi ra iin tichi ve'e. Ti küuni ra ña koto nï'iin na ña chāa ra. Va nī kuu kundii xe'e ra, ");
INSERT INTO mza_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","ti numini chìto iin ña'a kīchi iti' ñu'u' Sirofenicia ña cha chāa Jesuu. Ta yakan ti yüvi ña judíu kùan. Ta ìyo iin ña se'an ña ndiso tati xaan kīndoo ve'an. Yakan va, ma'á yakan chà'an ña nuu indii Jesuu. Ta chūnandi chitian nuu ra. Ta kīcha'a chìkan ña ñamani nuu Jesuu na tava ra tati xaan ndiso ñase'an kìndoo ve'an. ");
INSERT INTO mza_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ta te'en nāka'an ndio Jesuu ña jàkuuni ra kà'an ra nuan: ―¡Ji'na kuatun, na tindee ji'nai ñivi se'e Ndioo ìyo ñuu Israel! Ti na küu namaa yo ña chàchi na nuu na, ta ku'va yo yi kachi ina. ―Takan kàti Jesuu ti yüvi ñivi ñuu Israel kùan. ");
INSERT INTO mza_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ta te'en nāka'an ña chi'in ra: ―Ndicha ña kà'un yo'o Racha'nu, va nda ma ina chàchi ri che'e chìtá xuu mesa jā'a ma ndiakuati ―kàtian. ");
INSERT INTO mza_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ta ora chīnu kà'an ña takan, ta te'en nāka'an ndio Jesuu chi'an: ―Ya'a va'a nāka'un. Cha kùu ku'un ve'un, ti cha kēe tati xaan ndiso ma ña se'un. ―Takan kāti Jesuu chi'an. Tajan kēe ndioan kuà'an ña ve'an. ");
INSERT INTO mza_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Takan kūu ta ora chāa ña ve'an, ta ikan nāta'an ña ñase'an, ña kàndian nuu chito, ña cha kēe ma tati xaan kuñuan. ");
INSERT INTO mza_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Takan kūu tajan kēe ndiko Jesuu ma ñuu Tiro. Ta ikan yā'a ra ñuu Sidón. Ta juuni yā'a ra kua'a' ñuu kuati ìyo ñu'u' Decápolis. Ta ikan jan chāa ndio ra ma lakuna nàni Galilea. ");
INSERT INTO mza_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Takan kūu ta ora chāa ra yu'u lakuna ikan, ta chāndaka na iin ra so'o ta ñi'i nuu ndaa Jesuu. Tajan chīkan na iin ñamani nuu Jesuu na janani ra nda'a' ra chata ma ra so'o, ikan na nda'a ra. ");
INSERT INTO mza_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tajan tīin Jesuu nda'a' ra, ta kuà'an ra chi'in ra iin nuu tüvi nde'e ñivi. Ta ikan tī'i ra xini nda'a' ra tichi so'o ma ra so'o. Tajan tīvisii Jesuu xini nda'a' ra ta jānani ra yi nuu yaa ma ra so'o. ");
INSERT INTO mza_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tajan ndē'e Jesuu iti' andivi. Ta tāxini ra. Ta te'en nāka'an ra chi'in ma ra so'o: ―¡Efata! ―ña kùuni yi kà'an yi: ¡Na nuna yi!, chi'in tu'un kà'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Takan kūu ta juuni ora ikani, nūna so'o ma raso'o. Ta ndā'a yaa ra ndia. Ta kùu naka'an ra. ");
INSERT INTO mza_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ta te'en nāka'an ndio Jesuu chi'in ma ñivi ikan: ―¡Na kätitu'un ndo ña jā'i nuu inga ñivi! ―kàti ra. Va ma ñivi ikan, ti tüvi nī jachi'in na ña kà'an ra. Ti vi'a kàtitu'un na ña jā'a ra nuu inga ñivi. ");
INSERT INTO mza_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Takan kūu ta ndava yū'vi maania na ña jà'a ra takan. Ta te'en kīcha'a na kà'an na: ―Ndisaa ña jà'a ra'ya, va'a yi. Ti nda ndian so'o chìni jà'a ra, ta nda ndian ñi'i, kùu naka'an na jà'a ra ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Takan kūu ta inga kivi kūti'vi kua'a' tuku ñivi. Ta tükuia nda'a na ña kachi na. Ta yakan va kāna Jesuu ma ndra jàkua'a chi'in ra. Ta te'en kīcha'a ra kà'an ra chi'in ndra: ");
INSERT INTO mza_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ndava u'vi animai kùuni ña nde'i ñivi i'ya, ti cha kēta uni kivi ìyo na chi'i̱n. Ta vitin tüva ña kachi na. ");
INSERT INTO mza_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tatu tachi̱ na ña na ku'un na ve'e na, ña kua takä'an kachi na, kunaa na tichi iti', najaka. Ti ìyo ñivi kīchi chika. ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta ma ndra jàkua'a chi'in ra te'en nāka'an ndra: ―¿Naja kua ja'a yo ta kùu ni'o ña kachi na iin nuu taxiin tüvi ñivi? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ta te'en kīcha'a chìkatu'un tuku Jesuu nuu ndra: ―¿Naja paan nda'a ndo? ―¡Uchani yi! ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tajan kīcha'a nàka'an Jesuu: ―¡Na ka'an ndo chi'in na na kunandi na nuu ñu'u'! Tajan kī'in ndio ra ndi ucha ta'an ma paan. Ta kā'an ra chi'in Ndioo chi'in yi na ja'ií ra yi. Tajan chā'nda java ra ndisaa yi. Tajan chā'a ra yi nuu ndra jàkua'a chi'in ra na ku'va ndra yi kachi ñivi. ");
INSERT INTO mza_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ta juuni ndā'a ndra uvi uni tia tiaka' ndia. Ta juuni kī'in Jesuu ndri, ta kà'an ra chi'in Ndioo na ja'ií ra ndri. Tajan chā'a ra ndri nuu ndra jàkua'a chi'in ra na nata'vi ndra ndri nuu ma ñivi. ");
INSERT INTO mza_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Takan kūu ta ma ñivi ikan chāchi na nda kati chitu va'a tichi na. Ta jākutua na ucha ga tuka chi'in ña chàkoso. ");
INSERT INTO mza_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yakan va ma ndian chāchi cha yatin kumi mii ta'an ñivi kùu na. Tajan tāchi ndio Jesuu na, na ku'un na ve'e na. ");
INSERT INTO mza_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Takan kūu tajan ndāa ndio Jesuu tichi lancha chi'in ndra jàkua'a chi'in ra ña kàcha'an ndra iti' ñu'u' Dalmanuta. ");
INSERT INTO mza_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Takan kūu tajan chāa ndra fariseu nuu ndaa Jesuu. Ta kīcha'a ndra nàtu'un ta'an ndra chi'in ra, nde'o tu takan kùu ni'i ndra kua tisokuati ndra ra. Yakan va chīkan ndra na ja'a Jesuu iin ndatu nuu ndra, nde'o tu ndicha ña vàchi ra kuenda Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Takan kūu ta ora kā'an ndra takan tajan tàxiin kīndoo Jesuu, ta te'en kīcha'a kà'an ra chi'in ndra: ―¿Naja chìkan ma ñivi ìyo vitin ña jà'i iin ndatu, na nde'e na? Va yu'u kà'in ña nï'iin cha'a' tüvi ni nde'e na nï'iin ndatu ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Takan kūu tajan ndākoo Jesuu ma ñivi ikan yu'u lakuna, ta ndāa ra tichi lancha chi'in ndra jàkua'a chi'in ra ña kuà'an ndra inga chiyo lakuna. ");
INSERT INTO mza_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Takan kūu ta ora cha kācha'an ndra inga chiyo lakuna, ta nāani ma ndra jàkua'a chi'in Jesuu kùnda'a ndra ña kachi ndra. Ta uvanuu ni ma paan indii tichi lancha. ");
INSERT INTO mza_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ta te'en nāka'an Jesuu chi'in ndra: ―¡Ja'a va'a ndo kuenda ma yuchan iya ndra fariseu, ta yuchan iya Herode ndia! ―Takan kāti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ta ma ndra jàkua'a chi'in ra nàtu'un ta'an ndra, ti tüvi naa ndra tiá paan. ");
INSERT INTO mza_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Takan kūu ta numini nakùuni Jesuu ña nàtu'un ndra. Ta te'en kīcha'a kà'an ra chi'in ndra: ―¿Ta naja kà'an ndo ña tüvi nàa ndo paan? ¿A takä'an kuii kutunini ndo ña tüvi chà'a ndo kuenda? ¿A ya'a ndasii chinituni ndo ña kà'an ndo takan? ");
INSERT INTO mza_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ndicha kuii ti ìyo tinuu ndo. Va tüvi ndè'e ndo ña kūu. Ta juuni ìyo so'o ndo, va tüvi chìni va'a ndo. ¿A tüvi chàku'uni ndo? ");
INSERT INTO mza_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ora nāta'vi̱ u'un ta'ani paan kuenda u'un mii ñivi, ¿ta naja ta'an tuka chitu chàkoso ndāki'in ndo? ―kàti Jesuu. Ta te'en nāka'an ndra: ―Uchi uvi ta'an yi. ");
INSERT INTO mza_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Ta ora nāta'vi̱ ucha ta'an paan kuenda kumi mii ñivi, ¿ta naja ta'an tuka chitu chàkoso ndāki'in ndo? Ta te'en nāka'an ndra: ―Ucha ta'an yi. ");
INSERT INTO mza_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ta te'en nāka'an tuku Jesuu chi'in ndra: ―¿Ta naja takä'an kutunini ndo ña Ndioo tāchi yu'u? Ti ma tu'un kātitu'in nuu ndo töve kùuni yi ka'an yi cha'a' paan ña chàcho. ―Takan kāti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Takan kūu tajan chāa ndio ndra ma ñuu Betsaida. Ta ikan ndàka na iin ra kuaá. Chāa na nuu ndaa Jesuu na janda'a ra ra. ");
INSERT INTO mza_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Takan kūu tajan tīin ndio Jesuu nda'a' ma ra kuaá, ta ndàka ra ra kuà'an ra nda yu'u ñuu. Ta ikan jātii Jesuu tinuu ma ra kuaá chi'in takuii yu'u ra. Ta jùndii Jesuu nda'a' ra chata tinuu ra. Ta chīkatu'un ra nuu ra tu kùu nde'e ra iin nakuyi. ");
INSERT INTO mza_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ta kīcha'a kà'an ma ra kuaá te'en: ―Ndè'i, ña ma ñivi kàa na takua kàa iin yutun kàndani ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yakan va ma Jesuu jūndii ndiko ra nda'a' ra chata tinuu ma ra kuaá. Tajan nānde'e kachin va'a ndio ra. Takan kūu ña ndā'a ma tinuu ra, ña kùu nde'e kachin va'a ra ndisaa nakuyi. ");
INSERT INTO mza_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yakan va ora chīnu jànda'a Jesuu ra, tajan tāchi ndio ra ra, na ku'un ra ve'e ra. Tajan te'en nāka'an ndio Jesuu chi'in ra: ―¡Na kïchi gaun ma ñuu i'ya! ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Takan kūu ta ora chīnu jà'a Jesuu ña'a, ta kuà'an ra chi'in ma ndra jàkua'a chi'in ra iti' ndu'va ña ìyo yu'u ñuu nàni Cesarea Filipu. Ta tichi iti' kuà'an ndra te'en kīcha'a chìkatu'un Jesuu nuu ndra jàkua'a chi'in ra: ―¡Ndyo'o xaa! ¿Nda ra kùu yu'u, kàti ma ñivi? ");
INSERT INTO mza_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ta te'en nāka'an ndra: ―Ìyo ñivi kà'an, ti yo'o kùu Xuva ra jàkunduta. Ta ìyo inga ndian kà'an, ti kùu̱n ma ra kà'an chi'in tu'un yu'u Ndioo, nàni Elía. Ta inga na kà'an, ti kùu̱n iin ra kā'an chi'in tu'un yu'u Ndioo niku ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tajan te'en kīcha'a chìkatu'un tuku Jesuu nuu ndra: ―¡Ta ndyo'o! ¿Nda ra kùi?, kùuni ndo ―kàti ra. Tajan te'en nāka'an Petu' nuu Jesuu: ―¡Yo'o kùu̱n ra Cristu, ti nuu yo'o tàva Ndioo tiñu̱n! ―Takan kàti Petu' chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tajan te'en nāka'an tuku Jesuu chi'in ma ndra jàkua'a chi'in ra: ―¡Na kä'an ndo ña'a chi'in nï'iin ñivi! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Takan kūu ta te'en kīcha'a jàna'a Jesuu nuu ma ndra jàkua'a chi'in ra: ―Yu'u ra Se'e ñivi tāchi Ndioo, kua'a' tundo'o ni nde'i. Ti ma ndian cha'nu chi'in ma ndra sutu, ta ma ndra jàkua'a tutu Ndioo, tüvi chìnuni ndra ma ña kà'in. Yakan va yu'u ra Se'e ñivi tāchi Ndioo, ni nde'i kua'a' tundo'o. Ta ni ka'ni ndra yu'u. Ta tichi uni kivi ni nataku ndikoi. ");
INSERT INTO mza_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","―Te'en kàti kachin va'a Jesuu nuu ma ndra jàkua'a chi'in ra. Takan kūu tajan tāva ni'i siin Petu' Jesuu, ta te'en kīcha'a kà'an ra chi'in Jesuu: ―¡Na vä'a' jà'un takan! ―kàti Petu' chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tajan ndīkoni'i Jesuu ndē'e ra tiá ma ndra jàkua'a chi'in ra, ta te'en nāka'an xaan ra nuu Petu': ―¡Na jañaun ña kà'un, yo'o Petu'! ¡Ta na kundachiyo ma kui'na jàtiñu chi'un! Ti ma ña chàniniun töve induku yi chi'in ma ña chànini Ndioo. Ti chàniniun takua chànini ma ñivi ìyo ñuñivini. ―Takan kāti Jesuu chi'in Petu'. ");
INSERT INTO mza_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Takan kūu ta numini kāna Jesuu tiá ma ndra jàkua'a chi'in ra, chi'in ma ñivi ka'ìin chi'in ndra ndia. Ta te'en nāka'an Jesuu chi'in ndra: ―Tu ìyo iin yo kùuni jakua'a chi'i̱n na jaña na ma ña chànini na jà'a na, ta na ku'un na chatai, ta kuiso na kruu. Yakan va ña'a kùuni yi ka'an yi ña na nde'e na tundo'o takua ni nde'i tundo'o. ");
INSERT INTO mza_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ti ma ndian kùuni koo ñuñivi kuenda juuni maa na töve ni kakú na. Va ma ndian kuvi cha'a' ña chìnuni na ma tu'un kà'in, ndiakan kùu ma ndian ni kakú. Ta ni koo na chi'i̱n endeeni. ");
INSERT INTO mza_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ta juuni tükuii nda kuenda yi tu iin ra'ii nì'i ra tandi'i ña ìyo ñuñivi, tuva töve nì'i ra nuu koo ra endeeni chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yakan va nï'iin ma ñivi ìyo ñuñivi i'ya küu jata na ma kivi ni koo na endeeni. ");
INSERT INTO mza_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yakan va tu ìyo ndian kukanuu chatai, ta chata ma tu'un kà'in nuu ma ñivi töve chìnuni, ta ìyo kuati ka'ìin i'ya, nda yu'u ra Se'e ñivi tāchi Ndioo, ni kukanui ora ni kichaa ndikoi chi'in tati jà'a tiñu nuu Ndioo. Ti ma ora ikan ni tachi tatái yu'u chi'in ndatu ra. ");
INSERT INTO mza_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ta juuni te'en nāka'an tuku Jesuu chi'in na: ―Ndicha va'a ña kà'in chi'in ndo, ti ìyo ndian ka'ìin i'ya tüvi ni kuvi na nda kati nde'e ji'na na ña kichaa nuu chà'nda Ndioo tiñu chi'in ndatu ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Takan kūu ta ora yā'a iñu kivi, tajan kēe ndio Jesuu kuà'an ra iin yuku sukun. Ta ndàka ra Petu', Jandiau chi'in Xuvani ndia. Ta juuni nuu ma ndra kuà'an chi'in ra jāma kua kàa ra, ");
INSERT INTO mza_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ti ma ja'ma ñù'u ra, nduva'a kuii kīndoo tacha yi ta kuichin ga yi ña nï'iin ñivi ìyo ñuñivi küu nakata na yi takua kàa ja'ma Jesuu ikan. ");
INSERT INTO mza_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta juuni ndē'e ndra Elía chi'in Moisés ña nàtu'un ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tajan te'en nāka'an ndio Petu' chi'in Jesuu: ―¡Matru! ¡Ya'a va'a ña ka'ìin yo i'ya! ¡Na ku'un ndi kuja'a ndi uni lomara, iin yi kuendaun ta inga yi kuenda Moisés, ta inga yi kuenda Elía! ");
INSERT INTO mza_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Takan nāka'an Petu', ti ni tüvi chìto ra nayi kà'an ra ti ya'a yù'vi ra chi'in nduvi ndra ka'ìin chi'in ra ora ndē'e ndra ña kàa Jesuu takan. ");
INSERT INTO mza_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Takan kūu tajan nūu iin viko nu'u. Ta chāsi yi Jesuu. Ta te'en nāka'an iin tati kēe tañu viko ikan: ―Ra'ya kùu se'e mai. ¡Na jachi'in ndo ña kà'an ra! ―kàti Ndioo chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta nunuuni ora ndē'e ndra xiin ndra nï'iin ga ndra tüva ndè'e ndra ndra. Ma'iin nia ma Jesuu ndè'e ndra ña ndaa. ");
INSERT INTO mza_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Takan kūu ta ora nūu ndra ma yuku ikan, tajan kàtitu'un Jesuu nuu ndra ña na kätitu'un ndra nuu nï'iin ñivi ma ña ndē'e ndra nda kati nataku ma ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yakan va ndīkiva'a xe'eni ndra yi tichi chinitunini ndra, vaji chīkatu'un ta'an ndra juuni nuu ma ndra nayi kùuni ma tu'un nàtaku kà'an yi. ");
INSERT INTO mza_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Takan kūu ta te'en kīcha'a ndra chìkatu'un ndra nuu Jesuu: ―¿Ta naja kà'an ma ndra matru jàkua'a tutu Ndioo ña ji'na Elía ni kichi? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ta Jesuu te'en nāka'an ra chi'in ndra: ―Ndicha ti Elía ji'na ra ni kichi, ti ni jandova'a ra ndisaa nakuyi. Vati ma tutu Ndioo kàti yi, ti yu'u ra Se'e ñivi ña tāchi Ndioo, ni nde'i kua'a' tundo'o. Ta tüvi ni jachi'in na ña ni kà'in. ");
INSERT INTO mza_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Va yu'u kàtitu'in nuu ndo, ti Elía cha kīchi ra. Va java jāti'ini na chi'in ra. Ta takan jāchinu ma tutu Ndioo ma ña kà'an yi ña ni kūu niku ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Takan kūu ta ora chāa ndiko Jesuu chi'in ndra chà'an chi'in ra nuu ndàkoo ra inga ndra jàkua'a chi'in ra, ta ikan nāta'an ndra ndra ña ka'ìin locho kua'a' ñivi nuu ka'ìin ndra. Ta juuni ka'ìin ndra matru jàkua'a tutu Ndioo ndia, ña kànita'an yu'u ndra chi'in ndra jàkua'a chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Takan kūu ta ora ndē'e na Jesuu, ta ndisaa na chā'an na chākaña'a na chi'in ra, ti ya'a chìsii na ña ndē'e na ra. ");
INSERT INTO mza_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ta te'en kīcha'a chìkatu'un Jesuu nuu na: ―¿Nda cha'a' kànita'an yu'u ndo chi'in ndra? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ta te'en nāka'an iin ma ra ndaa ikan: ―Matru, nda che'e kīchai i'ya, ta ndākai iin rase'i, ti ndiso ra tati xaan. Ta endee kìndoo ñi'i ra jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ta nda nikuuni kèta ra ta tìin ma tati xaan ikan ra. Ta jànduva yi ra nuu ñu'u'. Ta endee kèe xikiñu iti' yu'u ra jà'a yi. Ta endee kari'u nu'u ra ta kìndoo yutun ra jà'a yi. Yakan va cha chīkain ñamani nuu ndra jàkua'a chi'un na tava ndra ma tati xaan ndiso ra. Va juuni küu ja'a ndra yi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Takan kūu ta te'en nāka'an tuku Jesuu: ―Ndyo'o ñivi tüvi chìnuni. ¿A ndisaa tiempu koi chi'in ndo?, kùuni ndo. ¿Ta naja ga tiempu kùndei ndo tiá, ña tükuii chìni ndo ña kà'in? ¡Na kichi ndaka ndo ma ra ku'vi nui i'ya! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tajan chāndaka ndio ma tatá ra ra nuu ndaa Jesuu. Ta ora ndē'e tati xaan Jesuu, ta jā'a yi ña nàtiin ndiko ña chì'i i'i ra. Ta ikan jan ndūva ra nuu ñu'u' jà'a yi, ta endee chìkotuvi ra. Ta kēe xikiñu yu'u ra jà'a yi. ");
INSERT INTO mza_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ta chīkatu'un ndio Jesuu nuu tatá ma rayoko ikan: ―¿Naja tiempu ìyo ña cha kīcha'a yi tìin yi ra? Ta te'en nāka'an ma tatá ma ra ku'vi: ―Nda ora kùu ra ravali. ");
INSERT INTO mza_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ta cha kua'a' cha'a' jānduva ma tati xaan ikan ra nuu ñu'ú, a tichi takuii ña kùuni yi ka'ni yi ra. Yakan va tu kùu ja'un iin ñamani ña na kunda'viniun ndi, ta janda'un ra. ―Takan kāti tatá ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ta te'en nāka'an Jesuu chi'in ra: ―¿Ta naja kà'un ña tu kùu ja'i yi? Nda ña nikuuni kùu ja'a yo, tuva chìnunio ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Takan kūu ta ma tatá ma rayoko ikan kīcha'a ra kà'an ni'i ra: ―Yu'u va cha chìnuni̱. ¡Na tindeun yu'u, na chinuni̱ tiaga! ");
INSERT INTO mza_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ta ora ndē'e Jesuu ña nduva'a kuii chākoyo kua'a' ñivi nuu ka'ìin ndra, ta te'en kīcha'a kà'an xaan ra nuu tati so'o ta ñi'i ndiso ma rayoko ikan: ―Yo'o tati xaan ta so'o, na keun kuñu ra'ya. Ti yu'u kà'an chi'un. ¡Ta na kï'vigaun kuñu ra inga cha'a'! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Takan kūu ta iin nànda'yuni ma tati xaan ikan, ta jā'a yi ña na tiin ndiko ma ña chì'i i'i ra. Tajan kēe ndio yi ra. Ta ndōo ra kàndii ra takua kàndii iin ña chī'í jā'a yi. Yakan va kua'a' ma ñivi kà'an ña chī'í ra. ");
INSERT INTO mza_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tajan tīin ndio Jesuu nda'a' ma rayoko ikan. Ta kāni'i ra ra. Tajan ndēta ndio ra chūndaa ra. ");
INSERT INTO mza_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Takan kūu ta nunuuni kī'vi Jesuu chi'in ndra jàkua'a chi'in ra iin tichi ve'e nuu tüvi ñivi. Ta te'en kīcha'a chìkatu'un ndio ma ndra jàkua'a chi'in ra nuu ra: ―¿Ta ndyu'u, naja nī kuu tava ndi ma tati xaan ikan? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tajan te'en nāka'an ndio Jesuu chi'in ma ndra jàkua'a chi'in ra: ―Na küu ja'a ndo tava ndo tati te'en tu tüvi kà'an ji'na ndo chi'in Ndioo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Takan kūu tajan kēe Jesuu kuà'an ra chi'in ndra jàkua'a chi'in ra iti' ñu'u' Galilea. Ta tüvi kùuni ra ña koto inga ñivi ma iti' kuà'an ndra, ");
INSERT INTO mza_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ti kùuni ra jana'a ra nuu ma ndra jàkua'a chi'in ra. Ta te'en nāka'an ra chi'in ndra: ―Yu'u ra Se'e ñivi tāchi Ndioo, ni tiin ñivi yu'u. Ta yu'u ni ku'va na ña ka'ni na. Ta ora keta uni kivi ña chì'i̱. Ta ni nataku ndikoi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Va töve nī chini va'a ndra ma ña kà'an ra. Ta ya'a ndasii ndra ndakatu'un ndra nuu ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chāa ndra ma ñuu Capernaum. Ta ora kī'vi ndra tichi ve'e, ta kīcha'a chìkatu'un Jesuu nuu ndra: ―¿Nayi nàtu'un ta'an ndo iti' vàchi ndo? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Va tàxiin kìndoo ndra, ti ndicha ña nàtu'un ndra takan ma tichi iti' ña nda ndra kùxini tiá kua ndisaa ndra. Vaji töve nī ka'an ndra ña chìkatu'un ra, va chìto ra nayi nàtu'un ta'an ndra tichi iti'. ");
INSERT INTO mza_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tajan chūnandi Jesuu. Ta kāna ra ndi uchi uvi ma ndra jàkua'a chi'in ra na kichi ndra nuu ra. Ta kīcha'a kà'an ra chi'in ndra: ―Tu ìyo iin yo kùuni kuxini, ndiakan kùu ndian nuu ndi'i nia. Ta juuni ndiakan kùu tindee ta'an na, tandi'i ñivi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tajan jūndii ra iin ravali ma'ñu ndra. Ta jākunandi ra ra nuu si'in ra. Ta nàka'an tuku Jesuu nuu ndra: ");
INSERT INTO mza_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nda yo kì'in kuenda ravali kàa takua kàa ra'ya kuendai, juuni kì'in na yi kuenda yu'u. Ta nda yo kì'in kuenda yu'u, ta yüvi ma'ii̱n ni kì'in na kuenda, ti juuni kì'in na kuenda tatái ra tāchi yu'u. ");
INSERT INTO mza_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ta te'en nāka'an Xuva: ―Matru, nda che'e ndē'e ndi iin ra jànda'a ñivi, va kà'an ra chi'in siviun. Ta takan tāva ra tati xaan ndiso ma ñivi. Va tava töve chàkunuu ra chi'in yo, yakan va nī cha'a ndi ña jà'a ra yi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ta nāka'an Jesuu nuu ndra: ―Na vä'a' jà'a ndo, ña nī cha'a ndo ja'a ra yi, ti nï'iin ndian kùu ja'a iin ndatu kuendai, na küu ka'an na chatai. ");
INSERT INTO mza_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndian tüvi kùuni kuati chi'in yo, juuni na ìyo na ja'a na ñamani nuu yo. ");
INSERT INTO mza_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nda ndian nikuuni ku'va na nuu ndo, vaji iin yachini takuii ko'o ndo, tava chàkuu ndo chi'i̱n, ta ndicha ña kà'in ña ma Ndioo ni ku'va ya'vi na. ");
INSERT INTO mza_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Tu ìyo iin ndiakuati ña chìnuni ña kà'in, va kēta iin racha'nu nuu na ta jàna'a ra kuati nuu na, ta juuni jā'a ma ndiakuati kuati ndia. Va'a ga tuva jaku'un na ma racha'nu tichi takuii tañu'u chi'in iin yoso ndikun sukun ra, ta takan kuvi ra. ");
INSERT INTO mza_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tu ja'un kuati chi'in iin chiyo nda'un, na ka'ndaun yi, ikan na kindaa kuati jà'un. Va'a ga chi'in iin chiyo nda'aniun, ña ku'un andivi nuu koo nditoun ndisaa kivi, kua chi'in ni nduvi yi ku'un andaya' nuu küu nda'va ñu'ú. ");
INSERT INTO mza_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ta ndakan kùu nuu töve chì'í tindaku, ta küu nda'va ñu'ú. ");
INSERT INTO mza_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tu ja'un kuati chi'in iin chiyo cha'un, na ka'ndaun yi, ikan na kindaa kuati jà'un. Va'a ga chi'in iin chiyo cha'un ña ku'un andivi nuu koo nditoun ndisaa kivi kua chi'in ni nduvi yi ku'un andaya' nuu küu nda'va ñu'ú. ");
INSERT INTO mza_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ta ndakan kùu nuu töve chì'í tindaku, ta küu nda'va ñu'ú. ");
INSERT INTO mza_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tu ja'un kuati chi'in iin chiyo tinuu̱n, na tavaun yi, ikan na kindaa kuati jà'un. Va'a ga chi'in iin chiyo tinuu̱n ki'viun nuu chà'nda Ndioo tiñu, kua chi'in ni nduvi yi ku'un andaya' ");
INSERT INTO mza_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nuu töve chì'í tindaku ta küu nda'va ñu'ú. ");
INSERT INTO mza_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Vati ndisaa yo ni nde'e tundo'o, ti takan kùuni ma Ndioo ña kùva'a yo takua kùva'a ndayu jà'a ñií. ");
INSERT INTO mza_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Va'a ma ñií. Vatu naa ña u'vá yi, ta küu jàva'a yo yi inga cha'a'. Yakan va na koo va'a ndo chi'in ta'an ndo ta chi'in inga ñivi takua asin ndayu jà'a ñií. ");
INSERT INTO mza_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Takan kūu ta kēe Jesuu ñuu Capernaum. Ta kuà'an ra iti' ñu'u' Judea, ña kàndii nda inga chiyo yuta Jordán. Ta ora chāa ra ndakan, ta ikan kīcha'a kùti'vi ndiko kua'a' ñivi. Ta ikan kīcha'a ndiko ra jàna'a ra nuu na kua takani jàna'a ra. ");
INSERT INTO mza_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ta yakan va ora kīcha'a Jesuu jàna'a ra, ta nunuuni chākoyo ndra fariseu nuu ndaa ra. Ta te'en kīcha'a ndra chìkatu'un ndra nuu ra, ti kùuni ndra ki'in ndra ku'va ra: ―¿A va'a ña ndàkoo yo ñasi'o? ―kàti ndra. Te'en chīkatu'un ndra nuu ra, ti kūuni ndra tisokuati ndra ra. ");
INSERT INTO mza_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ta te'en nāka'an Jesuu nuu ndra: ―¿Naja kua kà'an ma tutu Ndioo tāa Moisés taji'na? ―kàti Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ta te'en nāka'an ndra: ―Aan, va chā'a Moisés ña kuu ndakoo yo ñasi'o tuva jàndova'a ji'na yo iin tutu ña kà'an ña ndàkoo yo ñasi'o ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ta te'en nāka'an tuku Jesuu nuu ndra: ―Takan tāa Moisés, ti ya'a ndava xini ndo. ");
INSERT INTO mza_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ti ora jātuvi Ndioo ma ñuñivi, juuni jā'a ra ra'ii ta ña'a. ");
INSERT INTO mza_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yakan va va'ani tuva ndàkoo ra tatá ra chi'in ma'á ra, ta tànda'a ra chi'in ñasi'i ra. ");
INSERT INTO mza_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ta ni nduvi vi kùu vi iin ñivini. Yakan va yüvi uvi vi kùu vi, ti ni ndo'iin vi ta kùu vi iin ñivini. ");
INSERT INTO mza_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yakan va na vä'a', ña ndàkoo yo vi tuva cha jāndo'iin Ndioo yo chi'in vi. ");
INSERT INTO mza_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Takan kūu ta ora kī'vi ndra tichi iin ve'e, tajan kīcha'a chìkatu'un ndra jàkua'a chi'in Jesuu nuu ra cha'a' ma tu'un nàtu'un ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ta te'en nàka'an Jesuu chi'in ndra: ―Nda ra nikuuni tu ndàkoo ra ñasi'i nunuu ra ta kì'vi ra chi'in inga ña, iin kuati jà'a ra chata ñasi'i nunuu ra. ");
INSERT INTO mza_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ta nda ña'a' nikuuni tu ndàkoan iian ta kì'vian chi'in inga ra, juuni jà'a ña kuati chata ra nunuu chūndaka ña ndia. ");
INSERT INTO mza_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Takan kūu ta chāndaka na ndiakuati nuu Jesuu, na ke'e ra na. Ora ndē'e ndra jàkua'a chi'in ra ña jà'a na, ta kīcha'a ndra kà'an ndra: ―¡Na jä'a ndo te'en! ―kàti ndra chi'in ma ñivi ndà'a ma ndiakuati. ");
INSERT INTO mza_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yakan va ora ndē'e Jesuu ña jà'a ndra, ta kùxaan ra chi'in ndra. Ta kīcha'a kà'an ra nuu ndra jàkua'a chi'in ra te'en: ―¡Ku'va ndyo'o, na kichi ma ndiakuati nui! ¡Ta na käsi ga ndo iti' vàchi na! Ti ma ñivi ìyo nuu chà'nda Ndioo tiñu indukuni kàa na kua kàa ma ndiakuati. ");
INSERT INTO mza_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ta yu'u kà'in chi'in ndo, ti ma ndiakuati jà'a tiñu chà'nda tatá na nuu na, ta juuni takan ìyo yi ña ku'va yo ka'nda Ndioo tiñu nuu yo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tajan chīso ndio ra ma ndiakuati, ta jā'ií ra xini na chi'in nda'a' ra. ");
INSERT INTO mza_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Takan kūu ta ora ni ku'un tuku Jesuu, ta endee chìnu iin ra'ii chāa ra nuu ra. Ta chūnandi chiti ra nuu kuà'an Jesuu. Ta te'en kīcha'a chìkatu'un ra nuu Jesuu: ―¡Yo'o matru va'a! ¿Nayi kuu jà'i ta chài nuu koo nditoi ndisaa kivi? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ta te'en nāka'an Jesuu nuu ra: ―¿Ta naja kà'un ña kùi ra va'a, ta uvani ra va'a ìyo? Ta ma ra va'a kùu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿A cha chìtoun ma tu'un kà'an Ndioo nuu tutu tāa Moisés tatiempu? Te'en kà'an yi nuu ma tutu ikan: “¡Na kä'niun ñivi! ¡Na kï'viun chi'in ña'a' yüvi ñasi'un! ¡Na sü'un ndatiñu ñivi! ¡Na kä'un tu'un vata chata ñivi! ¡Na jända'viña'un ñivi! ¡Ta na tiñu'u̱n tatáun chi'in ma'un!” ―Takan kāti Jesuu nuu ra. ");
INSERT INTO mza_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ta te'en nāka'an tuku ra chi'in Jesuu: ―Matru, cha jā'i tandi'i yi nda ora kūi rayoko ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ta ora kā'an ra takan ta kīcha'a ndè'e Jesuu nuu ra, ta nduva'a kuii kùnda'vini ra ra. Ta kīcha'a Jesuu kà'an ra te'en chi'in ra: ―Ìyo iin nakuyi takäaga ja'un. ¡Na ku'u̱n kuxiko ndi'un ndatiñu̱n! ¡Ta ku'vaun ma xu'un' nuu ñivi nda'vi! Takan ìyo yi ña jà'un, ikan koo ña kuikaun andivi. ¡Ta kichiun ta ku'u̱n chatai iti' kuà'in! ―Takan kāti ra. ");
INSERT INTO mza_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ta ora chīni ra ña kà'an Jesuu, ta nduva'a kuii nda'vi kùuni ra ti küu ja'a ra yi, ti ya'a kuika ra. Yakan va kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tajan kīcha'a Jesuu nànduku nuu ra iti' xiin ra. Ta te'en kīcha'a ra kà'an ra chi'in ndra jàkua'a chi'in ra: ―Ya'a ndetiñu ta kùu ki'vi ndra kuika nuu chà'nda Ndioo tiñu ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ta ndava yù'vi ndra jā'a ma tu'un kà'an ra. Yakan va te'en nāka'an ndiko Jesuu chi'in ndra: ―Ndyo'o xaa, ya'a ndetiñu ta kùu chaa yo nuu chà'nda Ndioo tiñu. ");
INSERT INTO mza_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chakùu tiá ndetiñu yà'a iin kameyu xe'e iin kutiku, kua iin ra kuika ña chàa ra nuu chà'nda Ndioo tiñu ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Takan kūu ta ora chīni tuku ndra ña kà'an Jesuu takan tiaga yù'vi ndra, ta te'en kīcha'a chìkatu'un ta'an ndra: ―¿Tu takan kùu yi, yo kùu kakú tuva takan? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ta kīcha'a ndè'e ma Jesuu ndra, ta te'en kīcha'a nāka'an ra: ―Küu kakú ñivi, jà'a juuni ma na, va Ndioo kùu jakakú ra na. Ti ndisaa nakuyi kùu ja'a ra ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ta te'en kīcha'a nāka'an Petu': ―Va ndyu'u cha ndākoo ndi ndisaa ña ìyo nuu ndi. Ta tāndikun ndi chataun ―kàti ma Petu'. ");
INSERT INTO mza_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ta te'en nāka'an Jesuu: ―Ndichai ña kà'in chi'in ndo. Nda ndian nikuuni tuva ndakoo na tandi'i ndatiñu na jà'i, ña kùuni na ku'un na chatai, ti kùuni na katitu'un na ma tu'un va'a kà'in ña naja jàkakú Ndioo ma ñivi ñuñivi. Titu cha'a' yu'u ndākoo na ve'e na, ñivi ta'an na, ma'á na, tatá na, se'e na, ta ñu'u' na, ");
INSERT INTO mza_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ndiakan ni ni'i na kua'a' ga ve'e na, ñivi ta'an na, ma'á na, tatá na, se'e na, ta ñu'u' na ñuñivi i'ya inga cha'a', vaji ya'a ndè'e na tundo'o. Ta ma ñuñivi vàchi ni koo ndito na ndisaa tiempu jà'a Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma ñivi yoso nuu vitin ni kakuu iti' chata. Ta ñivi chàkuu iti' chata vitin, ni kakuu iti' nuu. ");
INSERT INTO mza_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Takan kūu tajan kēe ndio ndra kàcha'an ndra iti' ñuu Jerusalén. Ta yoso nuu Jesuu kuà'an ra iti' nuu ma ndra jàkua'a chi'in ra. Va ma ndrakan ndava yù'vi ndra ña kuà'an ndra iti' chata ra. Ta juuni ndasii ma inga ñivi kuà'an iti' chata ndra ndia. Takan kūu tajan ndē'e Jesuu iti' chata ra, ta kāna ra ma ndi uchi uvi ndra jàkua'a chi'in ra na kee siin ndra chi'in ra, ti kùuni ra katitu'un ra nuu ndra niyi ni ta'an ra. Takan kūu tajan te'en kīcha'a kà'an ra chi'in ndra: ");
INSERT INTO mza_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Cha chìto ndo ti iti' i'ya kùu iti' kuà'an ñuu Jerusalén. Ta yu'u ra kùu Se'e ñivi tāchi Ndioo, ni ku'va ñivi yu'u nuu ndra chà'nda tiñu nuu sutu chi'in ma ndra kùu matru jàkua'a tutu Ndioo. Ta ndrakan kà'an ndra ña na ka'ni ndra yu'u, ta ni ku'va ndra yu'u nuu ñivi kīchi inga ñuu. ");
INSERT INTO mza_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ta ni kuàtu'un na yu'u. Ta ni tivi sii na yu'u. Ta ni kani na yu'u chi'in yo'o. Ta ni ka'ni na yu'u ndia. Ta tichi uni kivi nataku ndikoi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ta jāyatin Jandiau ta Xuva, ndra se'e Zebedeu nuu Jesuu. Ta kīcha'a kà'an ndra nuu ra: ―Matru, kùuni ndi ña ja'un iin ñamani nuu ndi ña ni ndakan ndi nuu̱n ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ta kīcha'a kàti Jesuu: ―¿Nayi kùuni ndo ña jà'i cha'a' ndo? ");
INSERT INTO mza_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ta kà'an ndra: ―Ora chaun nuu ni'un ndatu̱n, na ku'vaun ndatu̱n nuu ndi. Ta iin ndi, kunandi chiyo kua'un, ta inga ndi kunandi chiyo satiun ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ta kīcha'a kà'an Jesuu: ―Tüvi chìto ndo nayi chìkan ndo. ¿A kundee ndo ko'o ndo ña uva ni ko'i? ¿A kuu kunduta ndo indukuni kua ni kundutai? Takan chīkatu'un ra nuu ndra ti kà'an ra ti tundo'o ni nde'e ra. ");
INSERT INTO mza_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta nāka'an ndra: ―¡Kùu yi! ―kàti ndra. Ta kà'an tuku Jesuu: ―Ndicha kuii, ti ndyo'o ko'o ndo ña uva ni ko'i. Ta juuni kunduta ndo indukuni kua kundutai. ");
INSERT INTO mza_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Va na küu ku'vai kunandi ndo chiyo kua'i a chiyo sati̱n, ti cha kāchin ra Ndioo tatái ndian kunandi yi. ");
INSERT INTO mza_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ta ora chīni ndi uchi ta'an ma ndra jàkua'a chi'in ra ña kà'an ndra, ta kūxaan ndra chi'in Jandiau ta chi'in Xuva ndia. ");
INSERT INTO mza_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Va kāna ma Jesuu ndra ta kīcha'a ra kà'an ra nuu ndra: ―Cha chìto ndo ña ìyo ndra chà'nda tiñu nuu ñivi yüvi judíu. Ta ndrakan ya'a kini jà'a ndra nuu ñivi chà'nda ndra tiñu, ti kùuni ndra jaka'nu ndra ndra tiá. ");
INSERT INTO mza_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Va chi'in maa ndo na jä'a ndo takan. Ma ra kùuni jaka'nu ra ra tiá, ta kùu ra, ra nuu ndi'inia kua ndisaa ndo. Ta jà'a ra tiñu nuu ndo. ");
INSERT INTO mza_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ta ma ra kùuni kuxini ndo na kumusu ndo ra. ");
INSERT INTO mza_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ti ni yu'u ra Se'e ñivi tāchi Ndioo töve vàchi̱ ña na ja'a ñivi tiñu nui, ti vàchi̱ tìndei ñivi. Ta ni kuvi̱ ti yakan kùu ya'vi̱ ña na kakú kua'a' ñivi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tajan chāa Jesuu chi'in ndra jàkua'a chi'in ra ñuu Jericó. Ta ora kēe ndra ma ñuu ikan chi'in kua'a' ñivi, ta ikan chìkan iin ra kuaá xu'un' nuu nàndi ra yu'u iti'. Ta rakan nàni ra Bartimeo, se'e Timeo. ");
INSERT INTO mza_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ta ora chīni ra ña juu Jesuu ra ñuu Nazaret vàchi, ta kīcha'a ma ra kuaá kànachaa ra. Ta kàti ra: ―¡Yo'o tata racha'nu David na kunda'viniun yu'u! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ta kua'a' na kà'an nuu ra: ―¡Taxiin koo yu'u̱n! Va töve jāchi'in ra ña kà'an na. Ta kānachaa ra tiá ni'i: ―¡Yo'o tata racha'nu David na kunda'viniun yu'u! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tajan chūndaa Jesuu. Ta kīcha'a ra kà'an ra: ―¡Na kana ndo ra! Tajan cha kāna ndio ndra ra ta kà'an ndra: ―¡Xaa, ndeta! Ti kàna ra ñu̱n ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tajan ra kuaá, jāxiin ra ja'ma ìyo chata ra, ta uvaa ndāva ra, ta chāa ra nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ta chīkatu'un Jesuu nuu ra: ―¿Nayi kùuniun ña ja'i chi'un? ―kàti ra. Ta nāka'an ma ra kuaá: ―Matru, kùuni̱ ña jandova'un tinui, ikan na kuu nde'i ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta kà'an ndiko Jesuu: ―¡Na ku'un, ti chìnuniun ña kà'in! Yakan va cha ndā'un ―kàti ra. Ta ora ikani kùu nande'e ma ra kuaá. Ta kuà'an ra chata Jesuu iti' kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ora chani kuyatin ndra ñuu Jerusalén, ji'na yā'a ndra ñuu Betania chi'in ñuu Betfagé nuu ìyo yuku Olivu. Ta ni tachi Jesuu uvi ta'an ndra jàkua'a chi'in ra iti' nuu. ");
INSERT INTO mza_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ta kà'an ra chi'in ndra: ―¡Kua'an ndo ma kuariya ikani! Ta ora ki'vi ndo tichi kuariya ikan, ta nde'e ndo iin burru ndikun ña nï'iin na takä'an koso ri. ¡Ndachi ndo ri! ¡Ta keñu'u ndo ri kichi ndo! ");
INSERT INTO mza_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tatu ìyo ndian chikatu'un naja ndàchi ndo ri ta kati ndo: “Ti chìniñu'u racha'nu chito'o ndi ri. Ta nunua vàchi ndaka ndiko ndi ri”, kati ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta takan kūu ta kēe ndio ndra kuà'an ndra. Ta nāta'an ndra ma burru ndikun ri iin cha'a' yutun veto'o yatini iin yuve'e. Tajan ndāchi ndra yi. ");
INSERT INTO mza_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ta chīkatu'un iin ma ndra ka'ìin ikan: ―¿Nayi jà'a ndo? ¿Ta naja ndàchi ndo ma burru? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ta nduvi ta'an ndra jàkua'a chi'in Jesuu, kāti ndra naja kua kā'an Jesuu chi'in ndra. Ta nāka'an ndra ìyo ikan: ―¡Va'ani! ¡Kuà'an ndo, tuva takan! ");
INSERT INTO mza_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tajan jūndii ndra ja'ma ndra chata ma burru. Ta kēñu'u ndra ri kuà'an ndra nuu Jesuu. Ta chākoso ma Jesuu ri kuà'an ra iti' ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta kua'a' ñivi chākin ja'ma isukun na tichi iti' kuà'an Jesuu. Ta inga na kāni ndoyo soko yutun ña chā'nda na tichi ku'u iti' kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ta takua kà'an ma ndian kuà'an iti' nuu ra, ta takan kà'an ma ndian kuà'an iti' chata ra: ―¡Ya'a jàka'nu yo Ndioo! ¡Ya'a jàka'nu yo ndè'o, ra vàchi kuenda Racha'nu chito'o yo! ");
INSERT INTO mza_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ya'a jàka'nu yo ra vàchi! Ti ni ka'nda ra tiñu takua chā'nda racha'nu David tiñu, tatiempu. David kùu ñivi yo. ¡Na jaka'nu yo ra Ndioo nàndi andivi! ―nàtu'un na cha'a' Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ta chāa Jesuu ñuu Jerusalén. Ta kī'vi ra tichi kora veñu'u ka'nu ikan. Ta ndè'e ra te'en, tikan. Tajan kēe ra kuà'an ndiko ra chi'in ndi uchi uvi ndra jàkua'a chi'in ra ñuu Betania, ti cha kuaa kùu yi. ");
INSERT INTO mza_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta ora kūndichin inga kivi ta kēe ndra ñuu Betania. Ta kuà'an ndra iti' ñuu Jerusalén. Ta Jesuu kōyo soko ra. ");
INSERT INTO mza_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ta chika ndē'e ra iin nuu ndaa yutun higu ña cha nūma. Ta chānde'e yatin ra nuu ndaa run a ka'ìin chiti higu nuu run. Va tüvi vu. Ka'ìin va mamaa nda'ani run, ti takäaga kuta'an tiempu koo chiti run. ");
INSERT INTO mza_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yakan va kà'an ra chi'in ma yutun ikan: ―Tiá iti' nuu, nï'iin ga ñivi na kächi ga chitiun ―kàti ra. Ta ma ndra jàkua'a chi'in ra, chīni ndra ña kā'an ra. ");
INSERT INTO mza_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ta ora cha chāa ndra ñuu Jerusalén ta kī'vi ndra tichi kora veñu'u ka'nu. Ta kīcha'a Jesuu jàkunu ra ma ñivi xìko chi'in ñivi jàta. Ta jānduva ra ma mesa ma ndian sàma xu'un' nuu ñivi. Ta jānduva ra mesa ma ndian xìko livi ndia. ");
INSERT INTO mza_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta tüvi chà'a ra ña ya'a ñivi ndiso ndatiñu tichi kora veñu'u ikan. ");
INSERT INTO mza_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ta te'en kīcha'a ra jàna'a ra nuu ñivi ikan: ―Te'en kà'an ma tutu Ndioo ―kàti ra― “Ve'e i'ya kùu ve'e Ndioo. Ñivi ìyo ndisaa ñuu ñuñivi, i'ya kùu kà'an na chi'in Ndioo”, kàti tutu Ndioo. Ta ndyo'o jà'a ndo yi iin ve'e ndra su'u ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Takan kūu ta chīni ndra sutu cha'nu chi'in ndra jàkua'a tutu Ndioo ña jàna'a ra. Ta nànduku ndra naja kua jà'a ndra ña ka'ni ndra ra, va ya'a yu'vi ndra ndè'e ndra ra. Ti nduva'a kuii kua'a' ñivi chìsii na ña jàna'a ra nuu na. ");
INSERT INTO mza_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ta ora kī'vi ña kuaa ta kēe ndiko Jesuu ñuu chi'in ndra jàkua'a chi'in ra. Ta kuà'an ndra inga ñuu. ");
INSERT INTO mza_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ta ora na'ani inga kivi kuà'an ndiko ndra iti' ñuu Jerusalén. Ta ora yā'a ndra yatini xiin ma yutun higu. Ta ndē'e ndra ña nàtii run. ");
INSERT INTO mza_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tajan chāku'uni ma ra nàni Petu' ña kā'an Jesuu chi'in run. Ta kà'an ra nuu Jesuu: ―¡Matru! ¡Nde'e yutun higu ña kānduva'un, ti cha nàtii run! ");
INSERT INTO mza_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tajan nāka'an Jesuu nuu ndra: ―¡Na chinuni ndo ña kà'an Ndioo! ");
INSERT INTO mza_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ndicha ña kà'in ti tu ìyo ndian kà'an chi'in yuku chiña: “¡Na kundachiyoun chiña, ta kuà'an tichi tañu'u!” Ta na jäxiin ndo anima ndo, ti na chinuni ndo ti ña ta'an yi va kà'an ndo, ta takan ni ta'an yi. ");
INSERT INTO mza_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ta yakan va kà'in chi'in ndo, ti ndisaa ña ndàkan ndo nuu Ndioo, ta na chinuni ndo ti cha nī'i ndo yi, tajan nì'i ndio ndo yi. ");
INSERT INTO mza_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ta ora kà'an ndo chi'in Ndioo tu jànaa ndo kuati jà'a inga ñivi cha'a' ndo, ta juuni jànaa Ndioo ma kuati jà'a ndo ndia. ");
INSERT INTO mza_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Va tu töve jànaa ndo kuati jà'a inga ñivi chi'in ndo, juuni töve ni janaa Ndioo ma kuati ndo ndia ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ta ora chīnu kà'an ra ta kàcha'an ndiko ndra iti' ñuu Jerusalén. Ta juuni chàkunuu Jesuu tichi kora veñu'u ka'nu. Ta chājayatin ndra sutu chà'nda tiñu chi'in ndra jàkua'a tutu Ndioo ta chi'in inga ndra cha'nu nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ta te'en chīkatu'un ndra nuu ra: ―¿Ta yo tāchi ñu̱n ña jà'un te'en? ¿Ta yo chā'a ndatu nuu̱n? ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Ta kīcha'a Jesuu kà'an ra: ―Ta ji'na kùuni ndakatu'in iin nakuyi nuu ndo ndia. ¿Yo tāchi Xuva ña jàkunduta ra? ¿A Ndioo, a ñivi? ¡Na kati ndo nui! Tu ji'na kati ndo ña chìkatu'in nuu ndo, tajan kati̱ yo chā'a ndatu ña jā'i te'en ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ta kīcha'a ndra natu'un xe'e ta'an ndra: ―Tu katio ña Ndioo tāchi ra, ta kati ra: “¿Ta naja nī chinuni ndo ña kà'an ra, tuva takan?” ");
INSERT INTO mza_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tatu katio ña ñivi tāchi ra, ta kuxaan ñivi yo, ti ndisaa na kà'an na ti ndicha Xuva kùu iin ra kà'an chi'in tu'un yu'u Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yakan va kà'an ndra nuu Jesuu: ―Töve chìto ndi yo tāchi ra. Ta nāka'an Jesuu: ―Ta ni yu'u na käti̱ yo chā'a ndatu ña jā'i te'en ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Takan kūu ta te'en kīcha'a Jesuu kà'an ra iin ku'va nuu ndra: ―Chīyo iin ra tāchi kua'a' yoku'u uva. Ta jā'a ra iin kora nuu tāchi ra ma yoku'u uva, ikan na kï'vi kiti, ni ñivi nuu kàa yi. Ta jā'a ra iin yavi nuu ni taan ra takuii ma uva, ti ikan ni ja'a ra vinu. Ta juuni jā'a ra iin lomara sukun, ikan na kuu nde'e ra ndisaa yu'u ma uva tāchi ra. Takan kūu ta jākilaa ra yi nuu ndra jàtiñu chi'in ra. Ta kēe ra kuà'an ra iin nuu chika. ");
INSERT INTO mza_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ta ora kēta ma tiempu ña chītí ma uva, ta tāchi ra iin ra musu ra ña kuàki'in sava ma ña'a ra. ");
INSERT INTO mza_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Va nī ni'i ra yi, ti java kāni ndra ra. Ta tāchi ndiko ndra ra kuà'an ra nuu ma ra chà'nda tiñu nuu ra. ");
INSERT INTO mza_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ta ikan tāchi tuku ra inga ra. Ta juuni kāni ndra ra. Ta tākue'e xini ra jā'a ndra. ");
INSERT INTO mza_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta ikan jan tāchi ra inga ra, ta rakan va chā'ni ndra. Tajan tāchi ra tiá kua'a' ndra. Ta juuni kua'a' ndra tākue'e ta kua'a' ndra chā'ni ndra ndia. ");
INSERT INTO mza_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ta ikan kīndoo uvania ra ya'a kùuni ra nde'e ra. Ta rakan ti se'e ra kùu ra. Tajan tāchi ndio ra ra nuu ndi'i nia ti kùuni ra: “Ti töve nayi ja'a ndra chi'in se'o, ti se'e maa yo kùu ra. Yakan va ni tiñu'u ndra ra.” Takan kùuni ma tatá ra niku. ");
INSERT INTO mza_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","’Ta ora chāa ra ma nuu ka'ìin ma ndra jàtiñu. Ta te'en kīcha'a ndra nàtu'un ta'an ndra: “Ra vàchi ikan kùu ma ra ni kindoo chi'in ndisaa ma ñu'u'. Yakan va na ka'nio ra ta kindoo yo chi'in ndisaa ña'a ra”, kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tajan tīin ndra ra. Ta chā'ni ndra ra. Ta jākuita ndra ñunda'yu ra chata kora nuu kàa ma uva ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Takan kūu ta te'en nāka'an tuku Jesuu: ―¿Ta nayi ni ja'a ma ra chito'o ma yoku'u uva chi'in ma ndra jà'a kuenda vu?, kùuni ndo. ¿A ni ku'un ra ta ka'ni ra ndra jàtiñu chi'in ra, ta ni jakilaa ra yi nuu inga ndra?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿A takä'an jakua'a ndo tutu Ndioo ña kà'an te'en: Yuu jāchiyo ma ndra jàndova'a ve'e kùu ma yuu tiá ka'nu kua ndisaa yi? ");
INSERT INTO mza_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ta yakan jā'a ma ra chito'o yo. Yakan va ya'a chisio vitin, kà'an tutu Ndioo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ta ndrakan ikan kūuni ndra tiin ndra ra, ti chìto ndra ti kà'an ra ku'va ikan chata ndra. Va tava yū'vi ndra ma ñivi ka'ìin ikan. Ta yakan va töve nani jā'a ndra chi'in ra. Ta kuà'an ndra. ");
INSERT INTO mza_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tajan tāchi na ndra fariseu chi'in ndra chàkunuu chi'in Herode nuu Jesuu, tajan na ja'a ndra ña na kà'an ra iin tu'un vä'a', ta ni'i ndra kua kuu tiso ndra kuati chata ra. ");
INSERT INTO mza_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tajan chàa ndra ta chīkatu'un ndra nuu ra: ―Matru, chìto ndi ti yo'o va kà'an tu'un ndaa, ta töve yu'viun nde'un ña kà'an inga ñivi. Ti tüvi sàma nde'un ndian kuika, a ndian nda'vi, ti indukuni ndè'un na. Ti jàna'un iti' va'a ña ku'un ma ñivi nuu Ndioo. ¿Ta yakan va naja kua kàtiun? ¿A va'a ña ka'nda ndi kuenda nuu ra kùu kalecha'nu ñuu Roma? ¿A va'a, a vä'a'? ―kàti ndra nuu Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Va tava cha nākoto ma Jesuu ti vata ndra, yakan va te'en nāka'an ra: ―¿Ta naja jànda'viña'a ndo yu'u? ¡Kuàki'in ndo iin xu'un' ta jana'a ndo yi nui! ―kà'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ta nda'a ndio ndra yi chāa ndra nuu Jesuu. Ta te'en nāka'an ndio Jesuu nuu ndra: ―¿Ta yo na'na ndaa chata ma xu'un' i'ya? ¿Ta yo sivi ndiso yi? Ta nāka'an ndra: ―Na'na kalecha'nu ñuu Roma kùu yi. ");
INSERT INTO mza_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tajan te'en nāka'an ndio Jesuu nuu ndra: ―¡Na ku'va ndo ña kùu ña'a ma ra kalecha'nu nuu ra, ta ku'va ndo ña kùu ña'a Ndioo nuu Ndioo! ―kàti ra. Ta ndava yu'vi ma ñivi jā'a ma ña kà'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Takan kūu tajan kuànde'e ma ñivi Saduceu ma Jesuu, ti ma ñivi ikan tüvi chìnuni na ña nàndoto ndiko ñivi ndií. Yakan va te'en chìkatu'un ndra nuu ra: ");
INSERT INTO mza_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―¡Yo'o Matru! Racha'nu Moisés tāa ra iin tutu tatiempu. Ta ma tutu ikan te'en kà'an yi: “Tu iin ra'ii chī'í ra, ta tüvi nī chïyo nï'iin se'e ra chi'in ñasi'i ra. Tajan ndàki'in ra yani ma ra chī'í juuni ma ña nda'vi ikan. Ta tànda'a ra chi'an. Ta takan ni koo se'e ma ra chī'í, jā'a ma ra yani ra.” Takan kāti Moisés. ");
INSERT INTO mza_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ta takan chīyo ucha ta'an ndra ña juuni yani ndra. Ta ma ra nunuu ji'na ra tānda'a, ta nï'iin se'e ra nī chiyo. Ta chī'í ra. ");
INSERT INTO mza_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ta ikan ndāki'in inga yani ra ña. Ta indukuni nī chiyo nï'iin se'e ra chi'an. Ta chī'í ra ndia. Ta juuni tānda'a ña chi'in ra uni. ");
INSERT INTO mza_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ta indukuni tā'an ra takua tā'an ndi ucha ta'an ndra. Yakan va nï'iin ndra nī chiyo se'e chi'an, ta chī'í ndra. Ta kēta iin kivi ña chī'í ma ña'a ndia. ");
INSERT INTO mza_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Ta ora kèta ma kivi nàtaku ndiko ma ñivi chì'í, nda ndra kùu iian ndakan?, kùuniun, ti cha tānda'a ndi ucha ndra chi'an ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tajan te'en nāka'an Jesuu chi'in ndra: ―¿Ta ndyo'o naja tüvi chìnuni ndo ña va'a kà'an tutu Ndioo? Ta töve chìto ndo ña ìyo ndatu Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yakan va ora nàtaku ndiko ma ndian ndií, ni ndra'ii ta ni ña'a' na tända'a vi. Ta vii koo na takua ìyo ma tati va'a jà'a tiñu nuu Ndioo andivi. ");
INSERT INTO mza_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ta vitin kùuni̱ jana'i nuu ndo ña nàtaku ndicha ma ndian ndií. ¿A tüvi chàku'uni ndo naja kua kà'an ma tutu tāa Moisés taji'na? Rakan te'en tāa ra yi, ora chānde'e ra nuu kàyu iñu ndu'va. Ta ikan kīcha'a kàtitu'un Ndioo nuu ma Moisés te'en: “Yu'u kùu Ndioo ña kùmi Abraham, ta juuni kùmi̱ Isaac, ta Jacob”, kàti Ndioo. Takan kāti ra ti vaji cha ìyo kua'a' kuiya chī'í ndra, va jānataku ndiko ra ndra. ");
INSERT INTO mza_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yakan va Ndioo kùu ma Ndioo ma ndian ndìtoni, ti cha nātaku ndiko ndra. Yakan va Ndioo kùu ra kuenda ndian ndìto, ta yüvi kuenda ndian ndií. Ta yakan va tüvi chànini ndo tu'un ndaa ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Takan kūu ta ikan kēta iin ra jàkua'a tutu Ndioo. Ta jà'a ra kuenda ña va'a nàtu'un Jesuu chi'in ma ñivi ikan. Yakan va ora chīni ra ña nàtu'un ma ñivi ikan, ta jāyatin ra ra. Ta kīcha'a chìkatu'un ra nuu ma Jesuu: ―¿Nda ley kùu ña ka'nu tiá kua ndisaa ma ley tutu Ndioo? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta kīcha'a nàka'an Jesuu: ―Ma tu'un ka'nu tiá ña chā'a Ndioo nuu yo kà'an yi te'en: “¡Ndyo'o ñivi Israel! ¡Na kuuni ndo ma Ndioo chito'o yo, ti uvani ra kùu ra! ");
INSERT INTO mza_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","¡Kùuni ndo nde'e ndo Ndioo chi'in ndisaa anima ndo! ¡Ta kùuni ndo nde'e ndo ra chi'in ndisaa chinituni ndo, ta chi'in ndisaa ña ndee ndo ndia!” Takan kà'an ma ña nunuu. ");
INSERT INTO mza_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ta ma ley uvi ña chā'a Ndioo nuu yo va kà'an te'en: “¡Kùuni ndo nde'e ndo ndian ìyo xiin ve'e ndo takua kùuni ndo juuni maa ndo!” Yakan va nda tu'un nikuuni tüvi ka'nu yi tiá kua ndi uvi tu'un já kā'in i'ya ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Takan kūu ta nāka'an tuku ma ra jàkua'a tutu Ndioo: ―¡Yo'o matru! Ya'a va'a kā'un ña ndicha kùu ma ña kā'un, ti uvani ma ra kùu Ndioo. Ta tüvi ìyo inga ra indukuni kua maa ra. ");
INSERT INTO mza_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ta kùunio nde'o Ndioo chi'in ndisaa anima yo, ta chi'in ndisaa chinitunio, ta chi'in ndisaa ma ña ndeo ndia. Ta juuni kùunio nde'o ñivi ìyo xiin ve'o takua kùunio juuni maa yo. Ta yakan va tiá va'a ña te'en kùunio nde'o Ndioo kua ku'va yo kiti jàna yo, ta ka'mio ndri nuu ndaa chito naá ―kàti ma ra matru jàkua'a tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ta ora chīni ma Jesuu ña chi'in chinituni ra kā'an ra. Yakan va te'en nāka'an Jesuu nuu ra: ―Chani kuyatin ki'viun nuu chà'nda Ndioo tiñu ―kàti ra. Ta ora chīnu nātu'un ra chi'in Jesuu ta nï'iin ga na, tüva nī chikatu'un inga nakuyi nuu Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ta ora ndaa Jesuu jàna'a ra nuu ñivi tichi kora veñu'u ka'nu, ta te'en chìkatu'un ra nuu na: ―¿Ta naja kà'an ma ndra matru jàkua'a tutu Ndioo, ña tata ma racha'nu David kùu Cristu? ");
INSERT INTO mza_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yakan va ma ra kùu Tati Ií Ndioo, chā'a ra ndatu ra nuu ma racha'nu David ora kà'an ra. Takan kūu ta te'en kīcha'a David kà'an ra chi'in ma ndatu ikan: Ma Racha'nu Ndioo te'en nāka'an ra chi'in ma ra chito'i Cristu: “¡Na'a! ¡Kunandi chiyo kua'i! Ti i'ya ni ku'vai ma ndatui nuu̱n, nda kati kani ndoyoi ma ndian kànita'an chi'un iti' cha'un”, kàti Racha'nu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yakan va kùuni yi ka'an yi ti, vaji tata David kùu Cristu, va juuni chito'o David kùu ra ndia ―kàti Jesuu nuu ma ñivi ikan. Yakan va ndisaa ma ñivi ka'ìin tichi kora veñu'u, ya'a chìsii na ña kà'an Jesuu takan. ");
INSERT INTO mza_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Takan kūu ta te'en nāka'an Jesuu nuu ma ñivi ikan: ―¡Ja'a ndo kuenda nuu ndo chi'in ma ndra matru jàkua'a tutu Ndioo! Ti chàta'ani ndra kakunuu ndra chi'in ja'ma tacha, na tiñu'u ma ñivi ndra nuya'vi. ");
INSERT INTO mza_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ta juuni nànduku ndra tayu ka'nu tiá kunandi ndra nuu chìyo viko ta tichi veñu'u ñivi judíu ndia. ");
INSERT INTO mza_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ta ndrakan, sù'u ndra ndatiñu ma ñivi kìndoo nda'vi. Ta nàkuatu ndra nuu ka'ìin kua'a' ñivi, ikan na kuuni na ña yüvi ndra su'u kùu ndra. Yakan va ndrakan ni nde'e ndra kua'a' tundo'o ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Takan kūu ta inga kivi chūnandi Jesuu yatini nuu ndaa chatun nuu tì'i na xu'un' ña jà'a ra kuenda naja kua tī'i na yi. Ta ora nàndi ra nde'e ra ikan, ta chākoyo kua'a' ma ndian kuika. Ta tī'i na kua'a' xu'un' tichi yi. ");
INSERT INTO mza_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ta nunuuni chāa iin ña kìndoo nda'vi. Ta tī'an uvi ta'an xu'un' kuati tichi yi. ");
INSERT INTO mza_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yakan va ora ndē'e Jesuu ña tī'an yi, ta kāna ra ma ndra jàkua'a chi'in ra, na kichi ndra nuu ra. Ta te'en kīcha'a kà'an ra chi'in ndra: ―Ndicha va'a ti ña nda'vi ikan, vaji tī'an tiani ma xu'un', va kuenda Ndioo kua'a' xu'un' kùu yi. Ti chā'a ña ndisaa ma xu'un' kùmian chi'in anima ña. ");
INSERT INTO mza_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta ma ndian kuika ti vaji kua'a' xu'un' tī'i na, va ña chàkoso nia kùu yi. Ta tiani xu'un' kùu yi kuenda Ndioo. Ta yakan va ma ña nda'vi ikan, tī'an tiaga xu'un' tichi chatun kua ndisaa ma ndian kuika ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Takan kūu ta ora kēe Jesuu tichi veñu'u ka'nu, ta nāka'an iin ra jàkua'a chi'in ra nuu ra: ―¡Yo'o, matru! ¡Nde'e veñu'u ka'nu ndaa ikan! Ti ya'a vii kàa yi. Ta ya'a ka'nu yuu kandii cha'a yi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ta nāka'an Jesuu nuu ra: ―Ndicha ti takan kàa yi vitin, va ni keta iin kivi ña nï'iin yuu kïndoo chata ta'an yi, ti ni kekoyo ndisaa yi. ");
INSERT INTO mza_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ta ikan kēe ndra ta kàcha'an ndra nda xini yuku nàni Olivu, ña ìyo yatini yu'u ñuu Jerusalén. Ta ora kēta ra ma xini yuku ta chūnandi ra ta te'en kīcha'a kà'an xe'e Petu', Jandiau, Xuva chi'in André nuu ra: ");
INSERT INTO mza_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―¿Ta nda ora ni kicha'a yi? ¿Ta nda ña kuu yi nde'o ora chani kicha'a yi? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ta kīcha'a nàka'an Jesuu nuu ndra: ―¡Ja'a ndo kuenda nuu ndo koto janda'viña'a ñivi ndo! ");
INSERT INTO mza_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ti ni kichaa koyo ndian ni ka'an te'en: “Yu'u kùu ra Cristu”, ni kati na. Ta ni janda'viña'a na kua'a' ñivi. ");
INSERT INTO mza_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’¡Na yü'vi ndo ora koto ndo ña kà'an ñivi ña ìyo kuati iti' tikan a nda nikuuni! Ti takan ni kuu yi, vaji vitin tüvi ni ndi'i ma kuati nde'o, va tiá iti' nuu, ni nde'o tiá yi. ");
INSERT INTO mza_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ti ni kanita'an iin ñuu chi'in inga ñuu. Ta inga ñuu, ni ja'a yi kuati chi'in inga tuku ñuu. Ta ni kichi ña taan kua'a' ñuu. Ta ni nde'o soko ndia. Ta nuu, já ni kicha'a tundo'o kùu yakan. ");
INSERT INTO mza_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’¡Ta yakan va ja'a ndo kuenda nuu juuni maa ndo! Ti ni tiin na ndo ta ni ku'va na ndo nuu ndra kumi tiñu. Ta ndra kumi tiñu, ni ku'va ndio ndra ndo na kani na ndo tichi veñu'u. Ta ni kundaka ndra ndo nuu ndra kalecha'nu. Ta juuni ku'un ndo nuu inga ndra chà'nda tiñu, ikan na kuu katitu'un ndo tu'in nuu ndra, cha'a' ña chìnuni ndo ña jà'i. ");
INSERT INTO mza_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Va ji'na ìyo yi ña katitu'un ndo ma tu'un va'a Ndioo nuu ndisaa ñuu ñuñivi. ");
INSERT INTO mza_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","¡Ta na näkanini ndo nda tu'un ni ka'an ndo ora ku'va na ndo nda'a' ndra kumi tiñu! Ti ora ka'ìin ndo ikan, na ka'an ndo tu'un ni jana'a Ndioo. Ti Tati Ií Ndioo ni jana'a ma tu'un ni ka'an ndo. ");
INSERT INTO mza_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ta juuni ma kivi ikan, ni tiin ndra ndra yani ndra. Ta ni ku'va ndra ndra nuu inga ñivi, na ka'ni na ndra. Ta juuni takan ni ja'a tatá ndra chi'in juuni se'e ndra. Ta juuni ni kanita'an ñivi chi'in tatá na ta ma'a na. Ta juuni ni ka'ni na vi ndia. ");
INSERT INTO mza_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ta ni kuxaan ñivi nde'e na ndo, ti chàkuu ndo chi'i̱n. Va ra kundeeni nda kati ya'a ma kivi ikan ni jakakú Ndioo ra. ");
INSERT INTO mza_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ta tichi veñu'u ií ni ki'vi iin ña kini. Ta yakán' ti ya'a xaani Ndioo nde'e ra yi ña ni kee ra veñu'u ka'nu ti ya'a kini ni ja'a yi tichi veñu'u. Ta ndisaa ñivi ìyo ñuu Judea ora kunián' ja'án' te'en, na kekunu na ku'un na iti' yuku, ikan na kakú na. Ta ndian chìto jàkua'a tu'un te'en, ya'a va'a tuva kutunini na naja kua kà'an yi. ");
INSERT INTO mza_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ta ndian ka'ìin siki ve'e, na kï'vi na, ni ña täva na ndatiñu na tichi ve'e na. ");
INSERT INTO mza_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ta ndian jàtiñu tichi ku'u na kï'vi na ñuu, ni ña küki'in na ja'ma na ndia. ");
INSERT INTO mza_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nda'vi ta'an ñivi ña'a ña kivi ikan ñù'u se'e vi, ta ìyo ndiakuati se'e vi ña chàxin ndika vi ndia. ");
INSERT INTO mza_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","¡Na ndakan ndo ñamani nuu Ndioo, ikan na tä'an ndo takan tiempu ya'a vichin jà'a yi! ");
INSERT INTO mza_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta ma kivi ikan ni nde'o tiá tundo'o kua nï'iin kivi. Takä'an nde'o yi jà'a Ndioo, nda ora jātuvi ra ma ñuñivi. Ta ni tüvi chànini ra ña jànde'e ra tundo'o yo tiá iti' nuu, takua ni jande'e ra yi yo kivi ikan. ");
INSERT INTO mza_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tatu ma Ndioo töve nī jandokuiti ra ma kivi ikan, na käkú nï'iin na niku. Va ma ra chito'o yo, jākuiti ra yi, ti kùuni ra nde'e ra ndian kāchin ra. ");
INSERT INTO mza_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Yakan va tu keta iin ndian te'en kà'an nuu ndo: “¡Nde'e ndo, i'ya ndaa ra kùu Cristu!” A tu keta inga ndian kà'an: “¡Juu ra ndaa ikan!” ¡Ta na chïnuni ndo ña kà'an na! ");
INSERT INTO mza_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ti ni kichi kua'a' ndian ni ka'an te'en ndia: “¡Yu'u kùu Cristu!” Va tüvi ndicha ti janda'viña'a ndra ña Cristu kùu ndra. Ta juuni ni kichi ndian ni ka'an chi'in tu'un yu'u Ndioo, va tüvi ndicha ti ndra vata kùu ndra. Yakan va ta ndi'i ndrakan ni ja'a ndra kua'a' ndatu ndra ta seña, ikan na chinuni na ña ndra kà'an chi'in tu'un yu'u Ndioo kùu ndra. Ta juuni kùuni ndra janda'viña'a ndra ma ñivi kāchin Ndioo tuva kùu yi. ");
INSERT INTO mza_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yakan va ja'a ndo kuenda juuni maa ndo. Ti cha kātitu'in nuu ndo naja kua ni koo yi. ");
INSERT INTO mza_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ta ora cha ndi'i ma tiempu ña ni nde'o kua'a' tundo'o. Tajan ni nda'va ma nikandii, ta ni nda'va yoo ndia. Ta tüva ni ndondichin jà'a ndra. ");
INSERT INTO mza_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ta ma chele ka'ìin andivi ni ke'ne ndri. Ti ni taan ma andivi jà'a ndri. ");
INSERT INTO mza_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tajan ni nde'e kua'a' ñivi ti vachi̱ tichi viko. Ti yu'u ra Se'e ñivi tāchi Ndioo ìyo kua'a' ndatui, ta kua'a' ña tachai ndia. ");
INSERT INTO mza_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tajan ni tachi̱ ma ndian kùu tati jà'a tiñu nuu Ndioo, na kuu jati'vi ta'an na ndisaa ñivi cha kāchi̱n. Ta kunanduku ma tati na nda nikuuni nuu ndi'i ñuñivi, a iti' ninuu, a iti' siki. ");
INSERT INTO mza_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Na kuu ku'uni ndo ña jàna'a yutun higu, ti ora kēta nda'a' yuta' run cha chìto ndo ti chani keta ma tiempu ni koo chiti run. ");
INSERT INTO mza_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ta yakan va ora ndè'e ndo ma tundo'o kàtitu'in nuu ndo, ta cha chìto ndo, ti chani kuta'an ora ni kichai. Ti yu'u kùu ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ndicha ña kà'in chi'in ndo. Ti ora takäaga kuvi ndisaa ma ñivi ìyo kuiya i'ya ji'na nde'e na tundo'o ña kā'in chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ta ni keta iin kivi ña ni naa andivi chi'in ñuñivi. Va tu'un ka'in tüvi ni naa yi. ");
INSERT INTO mza_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ta nï'iin ñivi tüvi chìto nda ora ni keta ma ña kà'in, ni tati jà'a tiñu nuu Ndioo, ta ni yu'u, ra kùu Se'e Ndioo tüvi chìtoi ndia. Chìto va ma Tatái, ti rakan kùu ma Ndioo ka'nu ìyo andivi. ");
INSERT INTO mza_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’¡Yakan va kumi ndo ndo! ¡Ta ja'a ndo kuenda ndo! ¡Ta ka'an ndo chi'in Ndioo! Ti töve chìto ndo nda ora ni kuu yi. ");
INSERT INTO mza_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yakan va ña'a kùu yi takua jā'a iin ra'ii ora kēe ra, ta kuà'an chika ra. Ta tāva ra tiñu nuu ndra kùu musu ra na kumi ndra ve'e ra. Ta ta'ii'iin ndra tāva ra tiñu nuu nayi jà'a ndra. Ta tāva ra tiñu nuu iin ra na ja'a va'a ra kuenda yuve'e ra. ");
INSERT INTO mza_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","¡Ta yakan va na koo ndito ndo! Ti töve chìto ndo nda ora kichaa ndiko ma ra xuve'e, a kichaa ra ora chanikuaa, a ora javañuu, a ora ni tuvi, a ora ni kundichin. ");
INSERT INTO mza_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","¡Ta yakan va na ja'a va'a ndo kuenda koto kichaa ra numini! Ta koto näta'an ra ndo ña kìxi ndo. ");
INSERT INTO mza_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yakan va ña kàtitu'in nuu ndo. Ta kàtitu'in nuu ndisaa ñivi na koo ndito na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Takan kūu ta ora takäaga uvi kivi, ta kūta'an viko Pakua, ora chàchi na paan ña töve kì'vi yuchan iya tichi. Tajan nànduku ma ndra sutu chà'nda tiñu chi'in ma ndra matru jàkua'a tutu Ndioo, naja kua ja'a ndra ta tiin xe'e ndra ma Jesuu ta ka'ni ndra ra. ");
INSERT INTO mza_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Va te'en kà'an ma ndra ka'ìin ikan: ―¡Na tïin yo ra kivi ìyo viko, ti koto kuxaan ma ñivi cha'a' ra! ");
INSERT INTO mza_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ìyo Jesuu ñuu Betania ve'e Simón, ra kà'an na ña ku'vi, jà'a kue'e ta'yu niku. Ta ora juuni nàndi Jesuu chàchi ra tichi ve'e ma ra Simón, ta ikan chāa iin ña'a, ta ndà'a ña iin viru takuii xiko, ña ya'a ya'vi ndaa. Ta nduva'a kuii va'a ra'. Ta nūna ña yu'u ma viru, ta chōsoan ra' xini Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ta iin ma ndra nàndi chi'in ma Jesuu kùxaan ndra ña jà'a ña takan. Ta te'en kīcha'a kà'an ta'an ndra: ―¿Ta naja chàtian ma takuii xiko? ");
INSERT INTO mza_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ti kùu jata na ra' nuan chi'in ndisaa xu'un' jàkanaa na iin kuiya, ta ku'va ña yi nuu ma ndian nda'vi. ―Takan kà'an ndra chata ña. ");
INSERT INTO mza_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ta te'en kīcha'a kà'an Jesuu nuu ndra: ―¡Jaña ndo ña kà'an ndo chata ña! Ti ña va'a jà'a ña chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ti ma ñivi nda'vi endeeni ni koo na chi'in ndo. Ta kùu ja'a ndo ña va'a chi'in na ora kùuni ndo. Vati yu'u töve ni koi chi'in ndo endeeni. ");
INSERT INTO mza_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ta ma ña'a i'ya, jà'a ña ma ña kùu ja'a ña kuendai, ti chōsoan takuii xiko ñii̱, ti chani keta ora ni kuchi̱. ");
INSERT INTO mza_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yakan va ndichai ña kà'in, ti nda nikuuni ma ñuñivi, nuu ni ka'an na tu'un Ndioo. Ta juuni ni ka'an na ña jā'a ña chi'i̱n, ta kuku'uni ma ñivi ña. ");
INSERT INTO mza_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Juda Iscariote kùu iin ra indii tichi ndi uchi uvi ma ndra jàkua'a chi'in Jesuu. Takan kūu tajan kēe Juda kuà'an ra kuànde'e ra nuu ìyo ma ndra sutu chà'nda tiñu, ti kùuni ra jandova'a ra naja kua ja'a ra ta ku'va ra ma Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ta ora chīni ndra sutu ña kā'an ra te'en, ta nduva'a kuii chìsii ndra, ta kīcha'a kà'an ndra chi'in ra: ―¡Ndicha ndi ña ni ku'va ndi xu'un' nuu̱n, ora jana'un ra nuu ndi! Ta kīcha'a ra nànduku ra naja kua kuu ku'va ra Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ma kivi nunuu ma viko Pakua, ora chàchi na paan ña tüvi kì'vi yuchan iya tichi. Ma kivi ikan chà'ni na iin mvechala kuati kivi viko Pakua, ti sòkó na ri nuu Ndioo, ikan na ndakimani ra na. Takan kūu tajan kīcha'a chìkatu'un ma ndra jàkua'a chi'in Jesuu nuu ra: ―¿Ta ndanu kùuniun ña kùu ja'a ndi ma ña kacho viko Pakua? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tajan tāchi ra uvi ta'an ma ndra jàkua'a chi'in ra, ta kà'an ra te'en chi'in ndra: ―¡Kua'an ndo tichi ñuu! Ta ikan nata'an ndo iin ra ndiso iin kii takuii ta tandiku ndo chata ra. ");
INSERT INTO mza_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ta kàtitu'un ndo nuu ma ra xuve'e nuu kì'vi ra, ti nànduku matru ndo iin ve'e nuu ni kachi ra ma viko Pakua chi'in ndra jàkua'a chi'in ra, kati ndo. ");
INSERT INTO mza_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta ikan jana'a ra iin ve'e ka'nu ndaa siki inga ve'e. Ta ma ve'e ikan, cha ìyo va'a yi kuenda yo. Ta ikan kùu ja'a ndo ma ña kacho ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tajan kēe ndio ndra kuà'an ndra tichi ñuu, ta nī'i ndio ndra ndisaa yi kua kā'an Jesuu nuu ndra. Ta ikan jā'a ndra ma ña kachi ndra kivi Pakua. ");
INSERT INTO mza_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ta ora chanikuaa chāa Jesuu chi'in ndisaa ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ta ora nàndi ndra chàchi ndra ma nuu tayu, ta kīcha'a kà'an Jesuu chi'in ndra: ―Ndichai ña kà'in, ti iin ra nàndi chàchi chi'i̱n ni xikoña'a ra yu'u ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ta ora chīni ndra ña kā'an ma Jesuu te'en, ta nduva'a kuii nàkanini ndra. Ta kīcha'a ii'iin ndra chìkatu'un ndra nuu Jesuu: ―¿A yu'u kùi? ");
INSERT INTO mza_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ta nāka'an Jesuu: ―Iin ra jàkua'a chi'i̱n kùu ra. Iin ra chàchi paan chi'i̱n vitin kùu ra. ");
INSERT INTO mza_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ta yu'u ra Se'e ñivi tāchi Ndioo, ni kuvi̱. Ti takan kà'an ma tutu Ndioo ña ni ta'in. Nda'vi ta'an ma ra xìkoña'a cha'i. Va'a ga tu tüvi nī kàku ra niku ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ta já ma'ñu chàchi ndra, ta kī'in ma Jesuu iin paan ta jā'ií ra yi nuu Ndioo. Ta chā'nda kuati ra yi. Ta chā'a ra ita'vi yi nuu ndisaa ndra. Ta te'en kà'an ra nuu ndra jàkua'a chi'in ra: ―¡Kachi ndo! Ti ña'a kùu ma kuñui ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ta takan kūu tajan kī'in ra iin kopa vinu. Ta nāka'an ndiko ra Ndioo cha'a' ra'. Tajan chā'a ra ra' nuu ndisaa ndra na ko'o ndra ra'. ");
INSERT INTO mza_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ta te'en nāka'an Jesuu chi'in ndra: ―¡Ko'o ndo ra'! Ti nii̱ kùu ra'. Ti cha ndòva'a ndisaa tiñu nuu Ndioo jà'a nii̱, ti chani kati̱ ra' cha'a' kua'a' ñivi, ikan na ni'i na ñamani Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ndichai ña kà'in chi'in ndo, ti tüva ni ko'i ma vinu i'ya chi'in ndo, nda kati koo ndikoi nuu chà'nda Ndioo tiñu. Tajan ko'i vinu chaa ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Takan kūu ta ora chīnu chìta ndra iin yaa Ndioo, tajan kuà'an ndra iti' yuku nàni Olivu. ");
INSERT INTO mza_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ta te'en nāka'an Jesuu chi'in ndra ma ikan: ―Ndisaa ndo kukanuu ndo ndè'e ndo yu'u ora naa vitin. Takan kà'an ma tutu Ndioo: “Tu ka'ni̱ ma ra chito'o ma mvechala, ta ndisaa ndri kuita kuati”, kà'an ma tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ta ora natuku ndikoi, ta ji'nai ku'un ñu'u' Galilea, tajan ku'un ndio ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tajan te'en nāka'an Petu' chi'in ra: ―Jin ndisaa ndra kùkanuu cha'un, va yu'u töve ―kà'an Petu'. ");
INSERT INTO mza_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tajan te'en nāka'an Jesuu: ―Ndichai ti chanikuaa vitin, ora takä'an nda'yu lo'o uvi cha'a', uni cha'a' ni ka'un ña tüvi nakotoun yu'u ―kà'an Jesuu chi'in Petu'. ");
INSERT INTO mza_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ta te'en kà'an ndiko Petu': ―Vaji kuvi̱ chi'un, ta tüvi ni ka'in ña tüvi nakotoi ñu̱n ―kà'an Petu'. Ta indukuni kà'an ndisaa ma ndra ka'ìin chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Takan kūu ta numini kēe ndra kuà'an ndra iin jardin nàni Getsemaní. Ta te'en nāka'an Jesuu chi'in ndra jàkua'a chi'in ra: ―¡Kunandi ndo kuatu ndo yu'u i'ya! Ti kuà'in kuàka'in chi'in Ndioo ikani. ");
INSERT INTO mza_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tajan kuà'an uni ta'an ndra chi'in Jesuu: Petu', Xuva chi'in Jandiau. Ta kīcha'a nda'vi kùuni Jesuu, ");
INSERT INTO mza_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ta te'en nāka'an ra chi'in ndra: ―Ya'a nda'vi kùuni animai kua ni kuvi̱. ¡Kindoo ndo i'ya, va koto kusu ndo! ―Takan kàti ra chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tajan kēe Jesuu kuà'an ra tiá iti' nuu. Ta chūnandi chiti ra nda nani te'e nuu ra ma nuu ñu'u'. Yakan va te'en kīcha'a kà'an ra chi'in Ndioo ña na tava ra ma tundo'o ni nde'e ra tuva kùuni ra. ");
INSERT INTO mza_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","―¡Yo'o Tatá! Yo'o va kùu ja'un nda ña nikuuni. Kùuni̱ ña nakaniun ma tundo'o ni nde'i. Va tüvi kùuni̱ ña kuu ma ña kà'in, ti naja kua kùuni maun kuu yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ta numini kēe ndiko Jesuu kuà'an ra nuu ka'ìin ma ndi uni ma ndra jàkua'a chi'in ra. Ta nāta'an ra ndra ña kìxi ndra. Ta kīcha'a kà'an ra chi'in Petu': ―Simón, ¿a kìxiun? ¿Ni küu kuii koo nditoun iin ora chi'i̱n? ");
INSERT INTO mza_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","¡Ndakoo ndo ta ka'an ndo chi'in Ndioo! Ikan tüvi kuà'an ndo anima ndo jà'a yi kuati, jin kùuni ndo kundito ndo chi'in anima ndo, va kündee ndo ―kà'an Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Takan kūu tajan kēe ndiko Jesuu kuàka'an ra chi'in Ndioo takua kā'an ra ma nunuu. ");
INSERT INTO mza_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ta ora chāa ndiko ra ma nuu ka'ìin ma ndi uni ma ndra jàkua'a chi'in ra. Ta juuni nāta'an ra ndra ña kìxi ndiko ndra inga cha'a', ña endee ndàsi tinuu ndra, jà'a ma ñuma'na. Ta tüvi chìto ndra ña kà'an ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tajan kēe ndiko Jesuu kuà'an ra cha'a' uni. Tajan chāa ndiko ra, ta kà'an ra chi'in ndra: ―¿A juuni kìxi ndo ta nìndee ndo tiá? ¡Na küsu ndo tiá! Ti cha kēta ma ora ña ni ku'va ñivi yu'u ra Se'e ñivi tāchi Ndioo. Ti ni tiin ma ndra jà'a kuati yu'u. ");
INSERT INTO mza_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Ndakoo ndo, ta ko'o! Ti cha vàchi ra cha xīkoña'a cha'i ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Juuni, takä'an chinu kà'an Jesuu, ta chāa Juda, iin ra indii tichi uchi uvi ndra jàkua'a chi'in ra. Chāa ra chi'in kua'a' jandaru. Ta ndrakan naa ndra machiti chi'in yutun. Vàchi ndra chata Jesuu jā'a ma sutu chà'nda tiñu chi'in iin ndra matru jàkua'a tutu Ndioo, ta inga tuku ndracha'nu. ");
INSERT INTO mza_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Juda ra xìkoña'a cha'a' Jesuu, chā'a ra iin tu'un kua ni ja'a ra nuu ma jandaru, ta kā'an ra te'en: ―Ma ra ni kaña'i chi'in, rakan tiin ndo. Ta ku'ni ndo ra, tajan kundaka ndo ra, ku'un ra chi'in ndo ―kàti Juda. ");
INSERT INTO mza_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Takan kūu ta jāyatin ra ra nuu Jesuu ta kà'an ra: ―¡Matru! Ta kāña'a ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ora ndē'e ndra yo kùu ra ta tīin ndra Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ta iin ra ndaa ma ikan tāva ra machiti ra, ta chā'nda ra so'o ma musu ma sutu cha'nu. ");
INSERT INTO mza_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ta chīkatu'un Jesuu nuu ñivi ikan: ―¿Naja vàchi ndo chi'in machiti chi'in yutun, ña vàchi tiin ndo yu'u? ¿A ra su'u kùi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","¿Naja tüvi nī tiin ndo yu'u tichi veñu'u? Ta kua'a' kivi chīyoi jàna'i nuu ndo ikan. Te'en ni ta'in, ti takan kà'an ma tutu Ndioo ña ni ta'in. ");
INSERT INTO mza_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ta ndisaa ma ndra jàkua'a chi'in Jesuu chīnu ndra kuà'an ndra, ta ndākoo ma'iin ndra ra. ");
INSERT INTO mza_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Takan kūu va iin rayoko ña isukun iin ja'ma ka'nuni. Uvaa rakan tāndikun ra kuà'an ra chata Jesuu. Ta ra'ya ti tīin ndra ra. Va tava jāña ra ma ja'ma isukun ra, yakan va jānda kakú kaviti ra. ");
INSERT INTO mza_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ta ndàka ma jandaru Jesuu nuu ndaa sutu cha'nu. Ta ikan kūti'vi ndisaa ma sutu cha'nu, ma ra jàkua'a tutu Ndioo chi'in inga ndracha'nu. ");
INSERT INTO mza_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ta chikani, chikani kuà'an Petu' chata ndra nda kati keta ndra ma ve'e sutu cha'nu. Ta kīndoo ra nuke'e. Ta ikan chūnandi ra javixin ra nda'a' ra nuu ñu'ú xiin ndra jandaru jà'a kuenda veñu'u. ");
INSERT INTO mza_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ta ma sutu chà'nda tiñu chi'in ndisaa ma ndra tiñu veñu'u, nànduku ndra iin tu'un ña kuu tiso ndra kuati Jesuu, ikan na ka'ni ndra ra nuu kruu. Va tüvi nī nata'an ndra nï'iin tu'un ndaa chata ra. ");
INSERT INTO mza_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vaji kēta kua'a' ñivi ña kà'an ndra tu'un vata chata Jesuu. Ta nï'iin ma ñivi, tüvi induku kà'an na chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Takan kūu ta ìyo ma ndian ndēta, ta te'en kīcha'a na kà'an na mamaa tu'un vata chata Jesuu: ");
INSERT INTO mza_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ndyu'u chīni ndi ña kà'an ra: “Ni janduvai ma veñu'u ka'nu ña jā'a ñivi, tajan tichi iin uni kivi kutai inga tuku yi ña tüvi jà'a ñivi”, ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ta vaji takan kà'an ndra, va siin siin ña kà'an ndra. ");
INSERT INTO mza_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tajan ndēta ndio ma sutu cha'nu ma'ñu ndisaa na, ta chīkatu'un ra nuu Jesuu: ―¿Naja tüvi kà'un ña kà'an na chataun? ―kàti ma sutu. ");
INSERT INTO mza_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Va ma Jesuu tàxiin kīndoo ra. Ta nï'iin tu'un nī ka'an ra. Yakan va te'en chīkatu'un tuku sutu cha'nu: ―¿A juu yo'o kùu ra Cristu ra Se'e Ndioo ií? ");
INSERT INTO mza_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ta nāka'an Jesuu: ―Juu yu'u kùu ra. Ta ni nde'e ndo ra ña nàndi ra chiyo kua'a ma Ndioo ka'nu ìyo nuu sukun. Ta ni keta iin kivi ña kichi̱ ndikoi. Va yu'u ra Se'e ñivi ni kichi̱ tichi viko ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Takan kūu tajan juuni ma sutu cha'nu, jānakaa ra juuni ma ja'ma ra, ti takan jàna'a ra nuu ma ñivi ti kùxaan ra jà'a ma tu'un kà'an Jesuu. Ta te'en kà'an ra: ―¡Na tüva chiniñu'u ga yo tiá ndra kuta'an chi'o! ");
INSERT INTO mza_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ndisaa ndo já, chīni ndo ña kā'an ti'ini ra chata Ndioo. ¿Naja kua chànini ndo? ―kàti ra. Ta ndisaa ndra ndō'iin tu'un ndra ña kuvi Jesuu, ti cha ìyo kuati ra, kuuni ndra. ");
INSERT INTO mza_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ìyo ndian cha kīcha'a tìvisii na ra. Ta chāsi na ma tinuu ra, ta kāni ndra ra chi'in chiki, ta te'en kà'an ndra: ―¡Ka'an! ¡Nde'o yo kāni ñu̱n! ―kàti ndra. Ta juuni ma jandaru kāni ndra nuu ra ndia. ");
INSERT INTO mza_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Takan kūu ta kīndoo ma Petu' nuke'e ikan. Ta ikan chāa iin ña musu ma sutu cha'nu. ");
INSERT INTO mza_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ta ora ndē'an Petu', ña tùmi ra ñu'ú, ta kīndoan nde'an ra, ta kīcha'a kà'an ña chi'in ra: ―¿A yo'o chàkuu chi'in Jesuu ra ñuu Nazaret? ―kàtian. ");
INSERT INTO mza_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ta kà'an Petu': ―¡Yüvi yu'u kùi! Ta tüvi nàkotoi ra, ni tüvi chìtoi nda ra kùu ra kà'un ―kàti Petu'. Tajan kēe ra kuà'an ra nuu nda yuve'e iti' nuke'e. Ta ora ikan ndā'yu iin lo'o. ");
INSERT INTO mza_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ta ndē'e ndiko ña musu sutu ikan ma Petu', ta kà'an ña chi'in inga na: ―¡Ra'ya kùu iin ra chàkuu chi'in Jesuu! ");
INSERT INTO mza_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Va kà'an ndiko ra: ―¡Yüvi yu'u kùi! Ta nunuuni ma ndian ka'ìin ikan, kà'an ndiko na chi'in Petu': ―¡Ndicha kuii ti yo'o kùu iin ra chàkuu chi'in Jesuu! Ti indukuni kà'un kua kà'an ndian ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","―¡Yüvi yu'u kùi, nde'e Ndioo ña kà'in! Ti tüvi kuii nàkotoi ma ra chìkatu'un ndo nui ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ta ma ora ikani, ndā'yu ndiko ma lo'o iti' uvi. Ta chāku'uni Petu' ña kā'an Jesuu chi'in ra: “Ora takä'an nda'yu ma lo'o uvi cha'a', uni cha'a' ni ka'un ña tüvi nàkotoun yu'u”, kàti Jesuu. Ta kīcha'a chàku Petu' ora chāku'uni ra ña kā'an Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ora kundichin inga kivi kūti'vi ma ndra sutu cha'nu, chi'in inga ndracha'nu, chi'in ndra matru jàkua'a tutu Ndioo, ta chi'in ndra jà'a kuenda ma ñivi judíu. Ti kùuni ndra natu'un ta'an ndra naja kua ja'a ndra chi'in Jesuu, tajan chū'ni ndra ma Jesuu ta kuà'an ndra chi'in ra nuu ra kùu Pilatu. ");
INSERT INTO mza_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ta ora ndē'e ma ra kùu Pilatu ma Jesuu. Ta kīcha'a ra chìkatu'un ra nuu ra: ―¿A yo'o kùu ra chà'nda tiñu nuu ñivi judíu? Ta kīcha'a nàka'an Jesuu: ―Maun kà'an yi. ");
INSERT INTO mza_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tajan kīcha'a ma ndra sutu cha'nu, tìso ndra kua'a' kuati chata Jesuu, va tükuii nani kà'an ra. ");
INSERT INTO mza_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yakan va chīkatu'un ndiko ma ra Pilatu nuu ra: ―¿Ta naja tükuii ka'un? ¿A tüvi chìniun ña ya'a ga tìso ndra kuati chataun? ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ta endee tükuii kà'an Jesuu. Ta ma ra Pilatu, ya'a nàkanini ra, ti tükuii nani kà'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yakan va ndisaa kuiya ora chīyo ma viko ikan, chìkan ma ñivi na kee iin ra indii vekaa nuu ma Pilatu. Ta jàña ra ra. ");
INSERT INTO mza_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iin ra nàni Barrabás indii tichi vekaa ma kuiya ikan. Ta juuni indii inga ndra meru ra, ti kānita'an ndra chi'in ma ndra vetiñu. Ta chā'ni Barrabás ñivi chi'in meru ra. Yakan va indukuni ka'ìin ndra vekaa ndia. ");
INSERT INTO mza_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ta ka'ìin locho kua'a' ñivi nuu Pilatu. Ta te'en kà'an na chi'in ra: ―¡Na jañaun iin ra indii vekaa takua jà'un nani kuiya! ");
INSERT INTO mza_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ta nāka'an ma Pilatu: ―¿A kùuni ndo ña jañai ma ra chà'nda tiñu nuu ñivi judíu? ");
INSERT INTO mza_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Te'en kā'an ra, ti cha chìto ra nda cha'a' kùu yi ña tixin ma ndra sutu cha'nu nde'e ndra ma Jesuu. Ta yakan va chāndaka ndra ra nuu ra. ");
INSERT INTO mza_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Va ma ndra sutu chà'nda tiñu kā'an xe'e ndra chi'in ma ñivi, na ndaka na ña, na tava ra Barrabás, ora chikatu'un ma Pilatu nda ra kùu ra kùuni na ña jaña ra. ");
INSERT INTO mza_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ta takan kūu ta te'en chīkatu'un ndio ra nuu na: ―¿Ta nayi kùuni ndo ña ja'i chi'in ma ra kà'an ndo ña chà'nda tiñu nuu ñivi judíu? ");
INSERT INTO mza_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ta te'en kīcha'a na kànachaa na: ―¡Takaa ra nuu kruu! ");
INSERT INTO mza_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta kà'an tuku Pilatu: ―¿Ta nda kuati jā'a ra, tuva takan? Ta te'en kīcha'a tuku na kanachaa na tiá ni'i. ―¡Takaa ra nuu kruu! ");
INSERT INTO mza_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ta tava kùuni ra kindoo va'a ra chi'in ma ñivi. Yakan va jā'a ra ma ña kā'an na. Ta jāña ra Barrabás. Takan kūu ta ji'na tāchi Pilatu ña na kani ji'na ndra Jesuu chi'in yo'o. Tajan chā'a ndio ra ra nda'a' jandaru na kutakaa ndra ra nuu kruu. ");
INSERT INTO mza_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tajan kuà'an ndio Jesuu chi'in jandaru nda nuke'e vetiñu. Tajan kūti'vi kua'a' jandaru. ");
INSERT INTO mza_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ta tākaa ndra iin ja'ma color ndaa takua kàa ja'ma ra kùu rey chata ra. Ta jā'a ndra iin korona iñu, ta jūndii ndra xini Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tajan kīcha'a ndra kà'an ni'i ndra nuu ra: ―¡Na koo endeeni yo'o ra chà'nda tiñu nuu ñivi judíu! ");
INSERT INTO mza_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ta kāni ndra xini ra chi'in yutun kuiin. Ta tīvisii ndra ra. Ta chūnandi chiti ndra nuu ra ña jāka'nu ndra ra. ");
INSERT INTO mza_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Takan kūu ta ndisaa ma ña jā'a ndra chi'in ra, mamaa ña chàtu'uni ndra ra kūu yi. Ta tāva ndra ma ja'ma color ndaa ña tàkaa chata ra, ta jāku'un ndiko ndra ja'ma maa ra ra. Ta tāva ndra ra ña ni takaa ndra ra nuu kruu. ");
INSERT INTO mza_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Takan kūu ta ikan ndaa iin ra ñuu Serene nàni Simón. Ta ndra se'e rakan kùu Alejandru chi'in Rufu. Ta rakan ti iti' ku'u kīchi ra. Ta ora kēta ra iti' kuà'an Jesuu, ta ndē'e iin jandaru ra, ta kāna ra ra na kichi ra kuiso ra kruu ndiso Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yakan va Jesuu ndàka ndra ra kuà'an ndra iin nuu nàni Gólgota. Ta ma tu'un Gólgota kùuni yi ka'an yi chi'in tu'un va'a: Yuku nuu Ndòyo kua'a' Iki Kini ndian Chī'í. ");
INSERT INTO mza_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ta jākanuu ndra iin yukú nàni mirra tichi takuii chiti uva, ta chā'a ndra ra' nuu Jesuu, na ko'o ra ra'. Va nī kuuni ra. ");
INSERT INTO mza_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ta ikan tākaa ndra ra nuu kruu. Tajan kīcha'a ma ndra jandaru chàsiki ndra yuu kuati, nde'o nda ndra kùu ndra jakanaa ja'ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kaa iín na'ani kùu yi, ora tākaa ndra ra nuu kruu. ");
INSERT INTO mza_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta ikan tāa ndra ma ña kùu kuati ra iin nuu vitu. Ta tātuu ndra yi xini kruu ra. Ta kà'an yi te'en: “Ra'ya kùu ra chà'nda tiñu nuu ñivi judíu.” ");
INSERT INTO mza_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ta te'en, tikan xiin ra tàkaa ma ndra jandaru ii'iin ndra su'u. ");
INSERT INTO mza_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ta takan chīnu ma tiñu kà'an tutu Ndioo: “Ti ni nde'e na ra takua ndè'e na ma ndra jà'a kuati”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Takan kūu ta ndian kēta ma nuu tàkaa ra, nduva'a kuii kànduva'a na ra. Ta kàva na xini na, ta kà'an na te'en: ―¡Yo'o, xaa! ¿Ta naja takaun chiña? Ta ma ra matru kùu̱n. Tanu, va'ani janduvaun veñu'u iin kivini, ta tichi uni kivi cha ndaa ndiko inga yi jà'un. ");
INSERT INTO mza_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Ta yakan va tuva ndichaun ña ndatun, na jakakú ñu̱n, juuni chi'in maun! ¡Ta na nuu maun nuu kruu! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ta ma ndra sutu cha'nu chi'in ma ndra matru jàkua'a tutu Ndioo, te'en kīcha'a ndra kànduva'a ndra ra ndia: ―Jākakú ra inga ñivi, va juuni chi'in ma ra, küu ja'a ra yi. ");
INSERT INTO mza_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Na nuu ra ma nuu kruu, tuva ndicha ña Cristu, ra chà'nda tiñu nuu ñivi Israel kùu ra! Ikan na nde'o ma tiñu jà'a ra, ta chìnunio ma tu'un kà'an ra ―kàti ndra. Ta juuni kà'an ma ndra ka'ìin xiin ra chata ra ndia. ");
INSERT INTO mza_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Takan kūu ta tandi'i ñuñivi iin kuaani ora chāa ora sama, ta indeeni nda kaa uni chani'ini. ");
INSERT INTO mza_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta ma ora ikani, te'en kīcha'a Jesuu kànachaa ra: ―¡Eloi! ¡Eloi! ¡Lama sabactani! Ma tu'un ikan te'en kùuni yi kà'an yi: ¡Tatá Ndioo! ¡Tatá Ndioo! ¿Ta naja ndākoo ma'iun yu'u? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ta iin ndian ka'ìin ma ikan chīni na ña kā'an ra. Ta kīcha'a na kà'an na: ―¡Taso'o ndo! Ti kànachaa ra Elía, ra kā'an chi'in tu'un yu'u Ndioo tatiempu ―kàti na. ");
INSERT INTO mza_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tajan iin ra ndaa ma ikan, chīnu ra kuàki'in ra iin ña xa'ma. Ta jātii ra yi tichi takuii iya, ta jūndii ra yi xini iin yutun kani. Ta chā'a ra yi nuu Jesuu na ti'vi ra. Ta ora chā'a ra yi nuu ra, te'en kà'an ra: ―¡Nde'e ndo! Nde'o a vàchi ra Elía januu ra ra nuu kruu ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ta ma ora ikan ndā'yu ni'i ma Jesuu, ta chī'í ra. ");
INSERT INTO mza_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ta ma ja'ma ndāsi tichi veñu'u ndāta java yi, nda siki ta nda ninuu. ");
INSERT INTO mza_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ta iti' nuu Jesuu, ndaa iin ra chà'nda tiñu nuu jandaru. Ta ndē'e ra naja kua chī'í Jesuu, ta te'en kà'an ra: ―¡Ndicha kuii ti ra'ya kūu ra Se'e Ndioo! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ta nda chika ka'ìin iin ñivi ña'a ndè'e naja kua tā'an ra. Ta tañu ma ñivi ka'ìin ikan, ndaa Ndiya Magdalena chi'in Salomé ta Ndiya ma'á Kusé chi'in Jandiau ra yani rayoko tiá. ");
INSERT INTO mza_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ta ma ñivi ña'a i'ya, tīndee vi Jesuu ora chākunuu ra ñu'u' Galilea. Ta juuni ka'ìin tiá vi ña kīchi chi'in ra ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Takan kūu ta chani'ini ora jàndova'a yo ma ndatiñu kuenda inga kivi nindeo. ");
INSERT INTO mza_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tajan kēta iin ra nàni Kusé, ra kīchi iti' ñuu Arimatea. Ta rakan iin ra kumitiñu ñu'u' Judea kùu ra. Ta juuni ya'a tìñu'u ma ñivi ra ndia. Ta juuni ndàtu ra ku'un ra nuu chà'nda Ndioo tiñu. Yakan va tüvi nī yu'vi ra chàndakan ra ñunda'yu Jesuu nuu ma Pilatu. ");
INSERT INTO mza_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ta Pilatu ti ya'a nàkanini ra ti ya'a numi chī'í Jesuu. Ta yakan va kāna ra ma ra chà'nda tiñu nuu jandaru. Ta kīcha'a chìkatu'un ma Pilatu nuu ra, naja ora kūu yi ña cha chī'í Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ta ora kātitu'un ma ra kuxini ma ndra jandaru nuu ra, tajan chā'a ma Pilatu ma ñunda'yu Jesuu nuu Kusé. ");
INSERT INTO mza_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ta ma Kusé jāta ra iin ja'ma, ta jānuu ra ma ñunda'yu Jesuu nuu kruu, ta tīsukun ra ja'ma yi. Ta ikan tī'i ra yi iin tichi yavi yuu. Ta nānduku ra iin yuu ka'nu, ta chāsi ra yu'u ma yavi. ");
INSERT INTO mza_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ta Ndiya Magdalena chi'in Ndiya ma'á Kusé ndē'e vi nuu tī'i ra ñunda'yu Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ta ora cha yā'a ma kivi nindeo, ta kuà'an Ndiya Magdalena, chi'in Salomé, ta Ndiya ma'á Jandiau, kuàjata vi takuii xiko jakuti vi ñunda'yu Jesuu. ");
INSERT INTO mza_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta ora na'ani kivi ndomingu, ma kivi kìcha'a jamana, kuà'an vi kuànde'e vi nuu kūchi Jesuu ora já kēta nikandii. ");
INSERT INTO mza_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta kīcha'a vi chìkatu'un ta'an vi: ―¿Ta yo jachiyo yuu nuu kuu ki'vio yu'u ma yavi? ―kàti vi. ");
INSERT INTO mza_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ta ora ndē'e vi iti' nuu, ta cha tüva ndàsi ma yuu ka'nu yu'u yavi nuu ndàsi yi niku. ");
INSERT INTO mza_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tajan kī'vi vi tichi yi, ta ndē'e vi iin rayoko nàndi chiyo kua'a. Ta ñù'u ra iin ja'ma kani, ña ya'a kuichin. Yū'vi vi ora ndē'e vi ra. ");
INSERT INTO mza_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ta kīcha'a kà'an ra chi'in vi: ―¡Na yü'vi ndo! ¿A juu ndyo'o nànduku Jesuu, ra kīchi ñuu Nazaret, ra chī'í nuu kruu? Va rakan cha nātaku ndiko ra vitin. Ta tüva ga ra i'ya vitin. ¡Na nde'e ndo nuu chūndii ra! ");
INSERT INTO mza_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","¡Kua'an ndo, ta katitu'un ndo nuu Petu' chi'in ndisaa ndra jàkua'a chi'in Jesuu! Ti ji'na ga Jesuu ni ku'un ñu'u' Galilea kua ndrakan. Ta ikan ni nde'e ndio ndra ra takua kā'an ra chi'in ndra niku. ");
INSERT INTO mza_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tajan kēe ndio vi ma tichi yavi. Ta chīnu vi kàcha'an vi, ti nduva'a kuii ndàyu vi jà'a ña yu'vi vi. Ta nī katitu'un vi nuu nï'iin na, ti ya'a ndasii vi. ");
INSERT INTO mza_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ta takan kūu ta nātuku ndiko Jesuu kivi ndomingu ora na'ani. Ji'na kēta ra nuu Ndiya Magdalena. Ta yakan ti cha tāva ni'i ra ucha tati xaan ña ndisoan niku. ");
INSERT INTO mza_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta ora ndē'an Jesuu, ta endee chīnuan chā'an ña chākatitu'an nuu ma ndra jàkua'a chi'in ra niku. Ta ndrakan ya'a chàku ndra, ti ya'a nda'vi kùuni ndra. ");
INSERT INTO mza_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ta ora kātitu'an ña ndē'an ña nātaku ndiko Jesuu. Ta ndrakan tüvi nī chinuni ndra ña kà'an ña. ");
INSERT INTO mza_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ta inga ora kēta ndiko Jesuu nuu kàcha'an uvi ta'an ndra jàkua'a chi'in ra iti' ku'u. ");
INSERT INTO mza_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ta ndrakan ti tüvi nī nakoto ndra nda ra kùu ra, ti jāma ra kua ndè'e ra. Ta ora nākoto ndra ña Jesuu kùu ra, ta chīkokani ndiko ndra kuàkatitu'un ndra nuu tiá ndra jàkua'a chi'in ra. Ta juuni tüvi nī chinuni ndra ña kà'an ndra. ");
INSERT INTO mza_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Takan kūu ta tiá iti' nuu kēta Jesuu nuu kaa chàchi ndi uchi iin ndra jàkua'a chi'in ra. Ta kùxaan ra nuu ndra naja tüvi nī chinuni ndra ña kà'an ma ñivi ña nātaku ndiko ra. ");
INSERT INTO mza_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tajan te'en nāka'an Jesuu chi'in ndra: ―¡Kua'an ndo ndisaa ñuñivi, ta katitu'un ndo tu'un va'a kuenda Ndioo nuu tandi'i ñivi! ");
INSERT INTO mza_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ta ndian chìnuni ña kà'in ta kunduta na, ta jakakú Ndioo na. Va ndian tüvi chìnuni ña kà'in, na jäkakú Ndioo na. ");
INSERT INTO mza_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ta ndian chinuni ña kà'in koo ndatu na. Ta chi'in ndatui kùu tava ni'i na tati xaan ndiso inga ñivi. Ta juuni chi'in ndatui kùu ka'an na tu'un tüvi chìto na. ");
INSERT INTO mza_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ta juuni kùu tiin na koo xaan chi'in nda'a' na. Ta kùu ko'o na takuii xaan, ta töve na ja'a ra' chi'in na. Ta kùu jundii na nda'a' na xini ndian ku'vi, ta nda'a na jà'a ndatui ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ta ora chīnu kà'an ma Racha'nu Jesuu chi'in ndra jàkua'a chi'in ra, ta ndāa ra kuà'an ra iti' andivi. Ta chūnandi ra chiyo kua'a Ndioo. Ti ndakan kùu nuu ni ka'nda ra tiñu chi'in Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ta takan kūu ta kēe ndra kuàkatitu'un ndra tu'un kà'an Jesuu chi'in ndra nda nikuuni. Ta ma Racha'nu Jesuu tìndee ra ndra ma iti' kuà'an ndra. Ti Ndioo chā'a ma ndatu ikan nuu ndra, ikan na ja'a ndra yi nuu ma ñivi, ikan na chinuni na ña tu'un ndicha kuu ma ña kà'an ndra.");
INSERT INTO mza_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yo'o racha'nu Teófilo, nduva'a kuii cha kua'a' ñivi nànduku na tàa kachin na tandi'i ma ña ndaa ña jā'a Ndioo tañu yo tatiempu. ");
INSERT INTO mza_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ta ndiakan tāa na yi indukuni takua kātitu'un ma ndian ndē'e kachin nuu kīcha'a yi chi'in tinuu na, vati ma tiñu nī'i na kùu ma tiñu ña kàtitu'un na tu'un Ndioo nuu ñivi i'ya. ");
INSERT INTO mza_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ta juuni yu'u ora cha nānduku tu'in cha'a' yi nda ora kīcha'a tu'un kà'an yi, tajan chànini̱ ti, ña va'a kùu yi tuva vii tài yi, ta tàchi̱ yi nuu̱n, yo'o racha'nu Teófilo, ");
INSERT INTO mza_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ikan na koto kachin gaun ma ña ndaa ña jāna'a na nuu̱n. ");
INSERT INTO mza_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Takan kūu ta ma tiempu kūu Herode rey ñu'u' Judea, ma tiempu ikan ti, chīyo iin sutu ra nàni Zacaría chi'in ñasi'i ra Elisabet. Ta sutu ikan ti, ra chàkuu chi'in grupu Abías kùu ra. Ta ninduvi vi ti, tata ñivi Aarón kùu vi. ");
INSERT INTO mza_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ta juuni chìnuni vi tu'un Ndioo, ta takan jàchi'in vi ma ña kà'an ma tutu ma Racha'nu. Yakan va nï'iin na küu tisokuati na vi cha'a' nï'iin nakuyi. ");
INSERT INTO mza_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ta ma sutu ikan chi'in ñasi'i ra tüvi nī chiyo nï'iin se'e vi, vati na küu koo se'e Elisabet. Ta vitin nduva'a kuii cha chà'nu vi ndia. ");
INSERT INTO mza_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Takan kūu ta chāa iin kivi ña kà'an Zacaría chi'in ma tandi'i sutu ña ìyo grupu ra nuu Ndioo ma tichi veñu'u ka'nu ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Vati takan ìyo costumbre ma ndra sutu, yakan va ma kivi ikan chāsiki ndra ta jākanaa ma Zacaría ña ni ki'vi ra nuu ií ga ma tichi veñu'u ta kuka'mi ra kutu kuenda Ndioo ikan. ");
INSERT INTO mza_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Takan kūu ta ora juuni chà'miga ra ma kutu, ndisaa ma ñivi ñuu ña ka'ìin nuke'e kà'an na chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Takan kūu ta ña'a jà'a ra ora kēta iin tati va'a jà'a tiñu nuu Ndioo nuu Zacaría ma iti' chiyo kua'a' ma nuu chito naá nuu kàyu ma kutu. ");
INSERT INTO mza_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Yakan va ora ndē'e Zacaría ma tati ikan, ndava kuà'an tati ra, ta nduva'a kuii yū'vi ra. ");
INSERT INTO mza_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ta te'en nāka'an ma tati ikan nuu ra: ―Yo'o Zacaría, na yü'viun, vati Ndioo chīni ra ndisaa ma ña kà'un chi'in ra ora jàka'nu̱n ra, ta vitin ma ñasi'un Elisabet ni koo iin se'an chi'un. Ta rakan ni jakunaniun ra Xuva. ");
INSERT INTO mza_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ta yo'o ti nduva'a kuii sii ni kuuniun ora ni nde'un ña ni kuu yi takan, nda ma ñivi, juuni sii ni kuuni na ora nde'e na ña ni kàku ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Vati ma ra se'un iin ra ya'a ka'nu ni kuu ra kuenda Ndioo, ti tüvi ni ko'o ra nï'iin nuu ma ndixi, ta ni vinu, ta juuni ni koo ma Tati Ií Ndioo chi'in ra antea ña kàku ra. ");
INSERT INTO mza_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta rakan ni ja'a ra ña na chinuni kua'a' ñivi ñuu Israel ma tu'un Ndioo, ikan na jaña na kuati jà'a na ta chikoni'i ndiko na iti' Racha'nu Ndioo, ra chito'o na. ");
INSERT INTO mza_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ti ma Xuva ra ni kuu se'un ikan, ni jatiñu ra indukuni kua jātiñu ra nàni Elía, ra kà'an chi'in tu'un yu'u Ndioo tatiempu. Ni ku'un ra kujandomani ra tatá na chi'in se'e na, ikan ma ndian tüvi chìnuni, na kicha'a na chinuni na. Yakan va takan ni jandova'a ra ma ndian ìyo ñuu Ndioo, ikan na koo tu'va na ma ora ni kichi ra. ―Takan kàti ma tati jà'a tiñu nuu Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Takan kūu tajan te'en kīcha'a chìkatu'un Zacaría nuu ma tati ikan: ―¿Ta naja kua jà'i ta chinuni̱ tuva ña ndicha kùu ma ña kà'un, vati yu'u cha ya'aga cha'nui, ta takan ma ñasi'i̱ ndia? ―kàti ra chi'in tati ikan. ");
INSERT INTO mza_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yakan va te'en nāka'an tuku ma tati jà'a tiñu nuu Ndioo chi'in ra: ―Yu'u nàni Gabriel, ta ìyoi kuenda ña ja'i tiñu nuu Ndioo. Ta juu ra tāchi yu'u ña vàchi katitu'in tu'un va'a i'ya nuu̱n. ");
INSERT INTO mza_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Va tava töve nī chinuniun ma ña kātitu'in nuu̱n, cha'a' yakan kùu yi ña ni kindoo ñi'un. Ta töve ni kuu ka'un nda kati chinu ji'na ma tu'un ña kàtitu'in nuu̱n. ―Takan kàti ma tati ikan nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Takan kūu ta ma ñivi ka'ìin ikan ndàtu na Zacaría nuke'e, ta ndiakan te'en kīcha'a na chìkatu'un ta'an na: ―¿Ta naja ya'a kùyanga ra ma tichi veñu'u ka'nu? ―chànini na. ");
INSERT INTO mza_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Takan kūu ta chanuu va'a tajan kēe ndio ra, va na küuga ka'an ndio ra chi'in na. Tajan ikan nākuni ndio na ña ìyo iin ña ndē'e ra ma tichi veñu'u nuu ií ikan, vati kà'an ra chi'in mamaa señani, ti kīndoo ñi'i ra. ");
INSERT INTO mza_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ta ora jāchinu Zacaría ma tiñu ikan, tajan kēe ndio ra kuà'an ra ve'e ra. ");
INSERT INTO mza_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Takan kūu ta ora yā'a ña'a, tajan ma ñasi'i ra Elisabet, chāku'un se'an. Ta u'un yoo kùu yi ña endee nī kean ve'an. Tajan te'en kīcha'a ña chàninian: ");
INSERT INTO mza_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Maa ma Racha'nu cha'a' iin ndatu, jā'a ña'a' chi'o, ikan na tüva ka'an ma ñivi chata yo”, kūunian. ");
INSERT INTO mza_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Takan kūu ta tichi iñu yoo, tajan tāva ndio ma Racha'nu Ndioo tiñu nuu ma tati jà'a tiñu nuu ra ña nàni Gabriel, ña na ku'un yi ma ñuu Nazaret, ña kàndii kuenda ñu'u' Galilea, ");
INSERT INTO mza_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ña na kunde'e yi iin ña'a yoko ña nàni Ndiya. Ta yakan ti, cha chā'a ña tu'un nuu iin ra nàni Kusé ña ni tanda'a ña chi'in ra. Ta rakan ti, tata ma ra rey David kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Takan kūu ta ora chāa ndio ma tati, tajan kī'vi yi tichi ve'e nuu ìyoan. Ta te'en nāka'an yi chi'an: ―¡Na sii kuuniun, yo'o Ndiya ña ìyo ñamani Ndioo chi'in, ti ma Racha'nu ìyo ra chi'un, ta maun kùu ma ña ya'a ií ña ìyo tañu ma ñivi ña'a! ―Takan kàti yi chi'an. ");
INSERT INTO mza_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ta ora ndē'an ma tati ikan, ndava kuà'an anima ña, ña kà'an yi takan chi'an. Yakan va te'en chīkatu'an chi'in juuni maa ña: “¿Ta naja kàña'a yi takan chi'i̱n?”, kùunian. ");
INSERT INTO mza_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Takan kūu tajan te'en nāka'an ndio ma tati jà'a tiñu nuu Ndioo chi'an: ―¡Na yü'viun yo'o Ndiya, ti na sii kuuniun cha'a' ña ìyo ma ñamani Ndioo chi'un! ");
INSERT INTO mza_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ta vitin, ni kuku'u̱n iin ravali se'un, ta rakan ni jakunaniun ra Jesuu ma ora ni kàku ra. ");
INSERT INTO mza_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta rakan, ti iin ra nduva'a kuii ka'nu ni kuu ra, ta ni kati ñivi ti Se'e Ndioo ka'nu ìyo andivi kùu ra. Ta juuni ma Racha'nu Ndioo ni ku'va ra ña na ka'nda ra tiñu takua chā'nda ma ra kūu ñivi ra, ra kùu rey David tiñu niku, ");
INSERT INTO mza_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ikan na ka'nda ra tiñu nuu ma ñivi ñuu Israel endeeni. Yakan va ma nuu ni ka'nda ra tiñu tüva ni chaa iin kivi ña ni ndi'i yi. ―Takan kāti ma tati ikan chi'an. ");
INSERT INTO mza_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Takan kūu ta te'en chīkatu'un ndioan nuu ma tati ikan: ―¿Ta naja kua kùu yi ña kà'un ña ni koo se'i, tu tüvi ìyoi chi'in nï'iin ra'ii? ―kàtian. ");
INSERT INTO mza_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ta te'en nāka'an tuku ma tati ikan chi'an: ―Ma Tati Ií Ndioo, ni kichi yi nuu̱n, ta ma ndatu ma ra ìyo andivi ni koyo yi chataun takua kùu iin vati. Ta tava ya'a ií ma ra ni kàku ja'un, yakan va ni ka'an ma ñivi ña iin ra ya'a ií Se'e Ndioo kùu ra, ni kati na. ");
INSERT INTO mza_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ta juuni ma ña kùu ñiviun Elisabet, ni koo iin se'an vaji cha cha'nuan. Yakan va ma ña'a kà'an na ña na küu koo se'e, cha iñu yoo kùu yi ña cha ñù'u se'an vitin. ");
INSERT INTO mza_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Vati kuenda Ndioo nï'iin nakuyi tüvi ndetiñu kuenda ra. ―Takan kàti yi chi'an. ");
INSERT INTO mza_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Takan kūu, ta te'en nāka'an tuku Ndiya: ―Yu'u kùu ña musu ma Racha'nu. Yakan va na ja'a ra ma kua kàtitu'u̱n ña ni ja'a ra chi'i̱n ―kàtian. Tajan ma tati, kēe yi ta kuà'an yi. ");
INSERT INTO mza_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ta ma kivi ikan numini kēe Ndiya chānde'an Elisabet iin ñuu kàndii iti' yuku ma ñu'u' Judea. ");
INSERT INTO mza_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ta ora chāa ña ñuu ikan, tajan kī'vi ndioan tichi ve'e Zacaría, ta kāña'a ña chi'in Elisabet. ");
INSERT INTO mza_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ta ora chīni Elisabet ña kāña'a Ndiya chi'an, ta juuni ma ora ikan tūñu ma pa'a tichian, ta kōyo ma Tati Ií Ndioo chata ña. ");
INSERT INTO mza_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tajan te'en nāka'an ni'i nduva'a kuii ma Elisabet: ―Ma maa Ndioo cha jà'ií ra ñu̱n tañu ñivi ña'a, ta cha jà'ií ra ma ravali se'un ña ni kaku. ");
INSERT INTO mza_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ta nda ña kùu yu'u ña vàchi nde'e ma ña kùu ma'á ma Racha'nu chito'i yu'u? ");
INSERT INTO mza_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ora chīni̱ ña kāña'un chi'i̱n, juuni ma ora ikan, tūñu ma se'i tichi̱ ña ya'a chìsii yi. ");
INSERT INTO mza_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Na ya'a sii kuuni animaun ña chīnuniun ña ni ja'a ma Racha'nu ña kātitu'un ra nuu̱n! ―Takan kàti Elisabet chi'in Ndiya. ");
INSERT INTO mza_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ta Ndiya te'en nāka'an ña: Ya'a jàka'nui ma Racha'nu Ndioo chi'in ndisaa animai. ");
INSERT INTO mza_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yakan va ya'a chìsii ma animai chi'in Ndioo, ti maa ra kùu ma ra jàkakú yu'u nuu ma kuati̱. ");
INSERT INTO mza_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Vati vaji iin ñanda'vini kùi, va kāchin Ndioo yu'u kuenda ña na ja'a ra ma ñamani ra chi'i̱n. Yakan va nda vitin ta iti' nuu, ni kati na ti iin ña'a ìyo ñamani Ndioo chi'in kùi. ");
INSERT INTO mza_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Vati ma ra ya'a ndatu, nduva'a kua'a' tiñu ka'nu jà'a ra chi'i̱n. Ta rakan ti iin ra ya'a ií kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Va Ndioo vitin ta iti' nuu kùnda'vini ra ma ndian jàka'nu ra. ");
INSERT INTO mza_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ta juuni ìyo kua'a' ndatu ra. Ta chi'in ndatu ikan jàndi'i ra nuu tandi'i tiñu jà'a ma ndian jàtayi juuni maa. ");
INSERT INTO mza_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ta tāvani'i ma Racha'nu ma ndian kùu rey nuu chà'nda na tiñu, ta tī'i ra ndian nda'vi na ka'nda na tiñu ma ikan. ");
INSERT INTO mza_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ta ma ndian kùmani nakuyi nuu, nduva'a jà'a ra kua'a' ña va'a chi'in na, ta ma ndian kuika, kìndonda'vi na jā'a ra. ");
INSERT INTO mza_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ta tìndee ra ndisaa ma ndian ìyo ñuu Israel, vati ndian jà'a tiñu nuu ra kùu na, ta endee tüvi nī jaña ra ña kùnda'vini ra na. ");
INSERT INTO mza_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Vati takan chā'a ma Racha'nu Ndioo tu'un nuu ma ra kūu ñivio ra chūnani Abraham taji'na, chi'in ma ndian ni kuu ñivi ra ña ni koo iti' nuu. ");
INSERT INTO mza_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Takan kūu tajan ma Ndiya kīndoan chi'in Elisabet iin uni yoo, tajan chīkoni'i ndiko ña ma ve'an. ");
INSERT INTO mza_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ta ora chāa tiempu ña ni kàku ravali se'e Elisabet, ta kāku yi. ");
INSERT INTO mza_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tajan ora chīto ndio ma ñivi Elisabet, chi'in ma ñivi ìyo yatini ve'an, numi kuiini chānde'e na nuu kàndian ña kāku se'an, ti ya'a chìsii na ña kūnda'vini ma Racha'nu ña. ");
INSERT INTO mza_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta ora chīnu ra una kivi ra, tajan chāndaka vi ra na ta'nda ñii nuu ika ra takua ìyo costumbre ma ñivi judíu. Ta ma ñivi kuà'an chi'in vi kùuni na ña na kunani ra sivi tatá ra Zacaría. ");
INSERT INTO mza_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Va ma Elisabet te'en nāka'an ña: ―¡Na küu yi! Ti ìyo yi ña kunani ra Xuva ―kàtian. ");
INSERT INTO mza_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tajan te'en nāka'an tuku na chi'an: ―Va na tüvi ìyo nï'iin ñivi ndo ña nàni takan ―kàti na chi'an. ");
INSERT INTO mza_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tajan chi'in mamaa señani kà'an na chi'in tatá ma ravali, nde'o tuva kùu koto na nda sivi kùuni ra jakunani ra ra. ");
INSERT INTO mza_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tajan tatá ma ravali chīkan ra iin vitu ña kùuni ra taa ra. Ta nuu ma vitu ikan te'en tāa ra: “Xuva, ni kunani ra.” Takan kāti ra chi'in ma ña tāa ra. Yakan va ora ndē'e na ña takan tāa ra, ndava kuà'an anima na. ");
INSERT INTO mza_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta juuni ma ora ikan kūu naka'an ndiko Zacaría. Tajan kīcha'a ra jàka'nu ra Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yakan va tandi'i ma ñivi nàkoto vi, ndava kuà'an anima na ña kūu takan chi'in Zacaría. Ta ndisaa ma ñuu kuati ña kàndii kuenda ma ñu'u' Judea, chìtakuati ma tu'un yu'u na cha'a' ña kūu. ");
INSERT INTO mza_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yakan va tandi'i ma ndian chīni yi, te'en chīkatu'un na chi'in juuni maa na: ―¿Nda tiñu ni kuu ra'ya ora ni kuchandee ra? Vati ndicha va'a ña jā'a ma Racha'nu kua'a' ndatu kuenda ma ravali i'ya. ―Takan chànini na. ");
INSERT INTO mza_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yakan va chi'in Tati Ií Ndioo, te'en nāka'an Zacaría ña jàka'nu ra Ndioo cha'a' ña ja'a ma ravali se'e ra: ");
INSERT INTO mza_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Ya'a ga ií kùu ma Racha'nu Ndioo ma ñivi ñuu Israel, vati cha kīchaa ra ña vàchi jakakú ra ndyu'u ndian kùu ñivi ra! ");
INSERT INTO mza_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vati cha tāchi ra iin ra ya'aga ìyo ndatu, kuenda ña na jakakú ra ñivi ra. Ta rakan kùu ra tata racha'nu David, ra kūu musu Ndioo taji'na. ");
INSERT INTO mza_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ta ma tu'un i'ya kùu ma tutu chā'a Ndioo nuu ma ndra ií, ndra kā'an chi'in tu'un yu'u ra ña chīyo taji'na, ");
INSERT INTO mza_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ta kā'an ndra ña ni jakakú ra yo nda'a' ma ndian xaani nde'o, ta nuu ndisaa inga tuku ma ndian küu koto nde'o ndia. ");
INSERT INTO mza_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ti kùnda'vini Ndioo ma ñivio chīyo taji'na niku, ta ñù'uni ra ma tu'un ií ña jāndo'iin tu'un ra chi'in Abraham, ra kūu tatá yo ndia. ");
INSERT INTO mza_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ta ma tu'un i'ya kùu ma tu'un ña chā'a ra nuu ra kūu tatá yo Abraham taji'na, ");
INSERT INTO mza_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ña ni jakakú ra yo nuu ndian xaani nde'e yo, ikan na tüva yu'vio ja'a yo tiñu nuu Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ta takan chi'in ña ndaa, ta ña ií, ikan ni koo yo chi'in ra ndisaa tiempu. ");
INSERT INTO mza_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yakan va yo'o se'yu, cha kāchin ma Ndioo ñu̱n, ña na kùu̱n ma ra kà'an tu'un yu'u Ndioo ìyo nuu sukun, ti ji'naun ni ku'un iti' nuu ma Racha'nu chito'o yo, ña ni jandova'un iti' ku'un ra ora ni kichaa ra, ");
INSERT INTO mza_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ikan na koto ma ñivi ñuu ra, ti Ndioo jànaa ra ma kuati jà'a na, ta jàkakú ra na nuu yi ndia. ");
INSERT INTO mza_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Vati ma Racha'nu Ndioo yo, nduva'a kùnda'vini ra yo, ta kùuni ra nde'e ra yo, ta ni keta iin kivi, ña ni tindee Racha'nu Ndioo yo kakú yo ma nuu naa, takua jà'a ma nikandii ña na nde'o ora kèta ra. ");
INSERT INTO mza_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ta chi'in ma tu'un jàna'a Ndioo, jàndondichin yi nuu ndian chàkunuu jà'a kuati ora naa, ta tìndee yi yo ña na koo vii yo chi'in ra ndia. Takan kāti Zacaría. ");
INSERT INTO mza_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Takan kūu ta ma ravali Xuva kuàkua'nu va'a ra chi'in tundeeni ña chà'a Racha'nu Ndioo nuu ra. Yakan va ma ravali ikan endee chīyo ra tichi ku'u, nda kati kēta iin kivi ña kīcha'a jàna'a ra nuu ñivi ñuu Israel. ");
INSERT INTO mza_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ra nàni Augustu kùu ra ña chà'nda ra tiñu tandi'i ñuu ka'nu Roma ma tiempu ikan. Ta tāchi ra ña na nakuiso na sivi, ña naja ta'an ñivi kùu na ña ìyo na ndisaa ñuu nuu chà'nda ra tiñu. ");
INSERT INTO mza_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma cha'a' nunuu ña yā'a na nākuiso na sivi i'ya, kūu yi ma tiempu kūu ma ra nàni Cirenio kuvienu ma ñu'u' Siria. ");
INSERT INTO mza_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ta ndisaa na ìyo yi ña kunu'u na kutaa na sivi na ta'ii'iin ñuu nuu kāku na. ");
INSERT INTO mza_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Cha'a' ña'a kùu yi ña kēe Kusé ma ñuu Nazaret, ña kàndii kuenda ñu'u' Galilea, ta kēe ra kuà'an ra ñuu Belén ña kàndii kuenda ñu'u' Judea, vati ikan kāku ma ra rey David, ra kūu ñivi ma Kusé taji'na. ");
INSERT INTO mza_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tajan chā'an ndio ra chātaa ra sivi ra ma ñuu Belén chi'in Ndiya ñasi'i ra, ña cha ñù'u se'e. ");
INSERT INTO mza_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ta takan kūu yi ña ma ora juuni yanga ìyo vi ma ñuu Belén, chāa ndio ma kivi ña ni kàku se'an. ");
INSERT INTO mza_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ta ikan kāku ma ra se'e nunuan. Tajan kāva ndioan ja'ma ra, ta kānindian ra tichi kanuva nuu chàchi kiti, vati tüvi nī ni'an ve'e nuu kàku ra. ");
INSERT INTO mza_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yatin ma ñuu Belén, ìyo ma ndra pato ña ndōo ndra kāva ndra iin chanikuaa tichi ku'u chi'in mvechala jàna ndra ña kùmi ndra. ");
INSERT INTO mza_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ta nunuuni kēta iin tati jà'a tiñu nuu Ndioo ña iin jātachani yi nuu ka'ìin ndra, ta chīkonuu nduva yi ndra. Ta nduva'a kuii yū'vi ndra jà'a yi. ");
INSERT INTO mza_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Takan kuu tajan te'en nāka'an yi chi'in ndra: ―¡Na yü'vi ndo! Vati ma ña vàchi katitu'in nuu ndo iin ña va'a kùu yi kuenda ndo, ta kuenda ña na sii kuuni kua'a' ñivi ndia, ");
INSERT INTO mza_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ti vitin cha kāku iin ra ni jakakú kua'a' ñivi ñuu David. Ta rakan ti, Cristu ra chito'o yo kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ta kuenda ña na koto ndo ti ña ndicha kùu ma ña kà'in, ni nata'an ndo ra ña kàndii ra isukun ra ja'ma tichi iin kanuva ña kàndii tichi ve'e nuu chàkuiin kiti. ―Takan kàti yi nuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Takan kūu ta juuni ma ora ikan, kàtiun ña chākoyo nduva'a kuii kua'aga ma tati jà'a tiñu Ndioo nuu ndaa ma inga yi. Ta te'en kīcha'a na chìta na ña jàka'nu na Ndioo: ");
INSERT INTO mza_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Na jaka'nu yo Ndioo ra ìyo andivi! ¡Ta na koo vii tandi'i ñivi ìyo ñuñivi i'ya chi'in ma ñamani ña chà'a ra nuu na ndia! Takan chìta tati ikan ña jàka'nu yi Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tajan kēe ndiko yi kuà'an yi tichi andivi, ta te'en kīcha'a ndio ma ndra pato chìkatu'un ta'an ndra juuni nuu maa ndra: ―Na ko'o kunde'o ra ma ñuu Belén, nde'o nayi kūu iti' tikan ña kà'an yi te'en ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tajan juuni ma ora ikan, numi kuiini kēe ndra kàcha'an ndra. Ta ikan nāta'an ndra ma Ndiya, chi'in Kusé ta ma pa'a ña kàndii ra ma tichi ve'e nuu kìxi kiti. ");
INSERT INTO mza_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yakan va ora nāta'an ndra ra ña kàndii ra takua kātitu'un yi nuu ndra, tajan kīcha'a ndra kàtitu'un ndra nuu vi naja kua kāti ma tati jà'a tiñu nuu Ndioo ora kēta yi nuu ndra cha'a' ma pa'a se'e vi. ");
INSERT INTO mza_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Takan kūu ta ndisaa ma ndian ka'ìin ikan, ndava kuà'an tati na ora chīni na ña kà'an ma ndra pato ña kùmi mvechala. ");
INSERT INTO mza_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ta ndisaa ma ña kà'an ndra ndākiva'a Ndiya yi tichi chinitunian. Yakan va endee ñù'uni ña ndisaa ma ña kà'an ndra nani kivi. ");
INSERT INTO mza_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ta ma ndra pato endee jàka'nu ndra Ndioo kuà'an ndiko ndra nuu ka'ìin mvechala jàna ndra, ti ya'a chìsii ndra ña nāta'an ndra ma pa'a ikan takua kātitu'un ma tati jà'a tiñu Ndioo nuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Takan kūu ta ora chīnu ma pa'a una kivi ra, tajan chāndaka vi ra na ta'nda ñii nuu ika ra takua kùu ma costumbre ma ñivi judíu. Yakan va ma pa'a se'e vi jākunani vi ra Jesuu, takua kātitu'un ma tati jà'a tiñu nuu Ndioo nuu Ndiya ma ora takä'an kuku'un se'an niku. ");
INSERT INTO mza_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta ora chīnu ma kivi takua kà'an ma tutu Ndioo ña tāa Moisés, ña ìyo yi ña kuatu vi kuenda ña na nandoo vi, tajan kēe ndio vi kàcha'an vi iti' ñuu Jerusalén ña kuàjana'a vi ra nuu Ndioo ndakan. ");
INSERT INTO mza_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Takan jā'a vi ti, nuu tutu ma Racha'nu Ndioo te'en kà'an yi: “Tandi'i ndrakuati se'e ndo ña kàku ma nunuu, ìyo yi ña kundaka ndo ra nuu ma Racha'nu Ndioo na ja'ií ra ra.” ");
INSERT INTO mza_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tajan kī'vi ndio vi chāsoko vi uvi livi a uvi pichon, takua kà'an ma tutu Ndioo ña ìyo yi ña jà'a yo. ");
INSERT INTO mza_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Takan kūu ta ma tiempu ikan chīyo iin ra'ii chūnani Simeón ma ñuu Jerusalén. Ta rakan ti iin ra ya'a jàka'nu Ndioo kùu ra, ta chìnuni ra. Ta juuni ndàtu ra ma tiempu ña ni jakakú Ndioo ma ñivi ñuu Israel. Yakan va ma Tati Ií Ndioo ìyo yi chi'in Simeón, ");
INSERT INTO mza_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","vati cha kātitu'un yi nuu ra ña na küvi ra tuva takä'an nde'e ji'na ra Cristu, ra ni tachi ma Racha'nu ña ni kichi. ");
INSERT INTO mza_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Takan kūu tajan chāa ma Simeón tichi veñu'u ka'nu ikan jā'a ma Tati Ií Ndioo. Ta ndē'e ra ma ravali Jesuu chi'in ma'á ra ta tatá ra ora sōkó vi ma kiti nuu Ndioo takua kàti ma tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ta ora ndē'e Simeón ma ravali, tajan kī'in ra ra sukun nda'a' ma ma'á ra ta chīso ra ra. Tajan te'en kīcha'a ra kà'an ra ña jàka'nu ra Ndioo: ");
INSERT INTO mza_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Yo'o Racha'nu chito'i, vitin va cha kùu ku'vaun ña na kuvi va'a yu'u, ra kùu musu̱n, ti cha jāchinu̱n ma tu'un chā'un nui. ");
INSERT INTO mza_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Vati cha ndè'i ma ra vàchi jakakú ndi. ");
INSERT INTO mza_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ta chi'in ra'ya, cha kīcha'un jàna'un nuu tandi'i ñivi ìyo ñuñivi, ña vàchi jakakú ra na. ");
INSERT INTO mza_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yakan va ra'ya kùu ra iin ra vàchi jandondichin nuu ñivi yüvi judíu takua kùu iin ñu'ú ña jàndondichin yi iti' chàkunuu yo. Ta juuni ma yo kùu ndian judíu, ni kindoo yo iin ñuu ka'nu jà'a ra ndia. Takan kàti ma Simeón cha'a' ma ravali. ");
INSERT INTO mza_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Takan kūu ta ora chīni ma tatá Jesuu chi'in ma ma'á ra, ta endee kuà'an tati vi. ");
INSERT INTO mza_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ta ora chinu kā'an Simeón takan, tajan jā'ií ndio ra vi, ta te'en nāka'an ra chi'in Ndiya ma'á Jesuu: ―Yo'o Ndiya, ndicha va'a ti ma ravali se'un cha tāchi ra ña na ja'a ra iin tiñu ka'nu iti' nuu. Ta chi'in ma tiñu ni ja'a ra, kua'a' ñivi ni chinuni yi, ta ni kakú na. Ta inga na töve, ti ni xitakaa na ra, ta ni kanita'an na chi'in ra cha'a' ma ña tāchi Ndioo ña jàna'a ra. Yakan va ma ñivi ikan töve ni kakú na, ");
INSERT INTO mza_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ta ma ña xe'e chànini na chi'in chinituni na vitin, ni koto tandi'i ñivi yi iti' nuu. Ta yo'o Ndiya, nduva'a kuii nda'vi ni kuuniun cha'a' ña ni ta'an ra se'un ja'a na. ―Takan kàti Simeón chi'an. ");
INSERT INTO mza_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ta juuni ma ikan ndaa iin ña nàni Ana, ñivi ra chūnani Aser. Ta tatá ña kùu ra nàni Fanuel. Ta yakan ti, iin ña kà'an chi'in tu'un yu'u Ndioo kùan, ta ya'aga cha cha'nuan ndia. Ta juuni ya'a yokoan ora chīyo ma iian, ta ucha kuiyani chīyoan chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ta vitin cha ya'a kumixiko kumi kuiya ña kīndoo nda'vian. Ta endee tükuii jàña ña ña chàkunuan veñu'u ña kà'an ña chi'in Ndioo nduvi ta niñuu. Ta ìyo ora ndìta yu'an ña jàka'nuan Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Takan kūu tajan ma Ana, cha jāyatian ña ma ora ikani, ta kīcha'a ña jàka'nuan Ndioo cha'a' ra, ta kātitu'an nuu ma ndian ñuu Jerusalén ti ni jakakú ra na. ");
INSERT INTO mza_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ta ora cha jāchinu vi jà'a vi ndisaa ña kà'an ma tutu Ndioo, tajan kuànu'u ndiko vi ñuu vi Nazaret ña kàndii ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ta ma ravali kuàkua'nu va'a ra, ta kuànindee va'a ra, ta kua koto va'a ra. Ta ya'a chìsii ra ña ìyo ma ñamani Ndioo chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Takan kūu ta ma tatá Jesuu chi'in ma'á ra, ndisaa kuiya chà'an vi chàjaya'a vi viko pakua ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ta ora chīnu Jesuu uchi uvi kuiya ra, ndisaa vi chā'an ndiko vi ma viko pakua ndakan, takua takani jà'a vi. ");
INSERT INTO mza_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Va ora yā'a ma kivi viko, tajan kēe ndiko vi kuànu'u vi ve'e vi, va nī cha'a vi kuenda ña kīndoo ma ravali Jesuu ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ta vikan chānini vi ña kuà'an ra chi'in inga ñivi vi iti' ve'e vi. Chākuu vi iin kivi ma ti iti' ta kīcha'a ndio vi nànduku vi ra tañu ma ñivi vi, ña kuà'an chi'in vi, ");
INSERT INTO mza_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","va töve nī nata'an vi ra. Yakan va chīkoni'i ndiko vi kuànanduku vi ra ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ta nda tichi uni kivi, tajan nāta'an vi ra ña nàndi ra tañu ma ndra matru jàna'a tu'un Ndioo tichi veñu'u ka'nu ikan, ña chìni ra ña kà'an ndra, ta chìkatu'un ra nuu ndra ndia. ");
INSERT INTO mza_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ta ndisaa ma ndian chīni ña kà'an ra, ndava kuà'an anima na, ña ya'a ìyo chinituni ra chi'in ma ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ta ora ndē'e ma tatá ra chi'in ma'á ra ra, ndava kuà'an tati vi, ta te'en nāka'an ma ma'á ra chi'in ra: ―Yo'o se'yu, ¿ta naja jà'un te'en chi'in ndi? Ta yu'u chi'in tatáun, ndanikuni kāchika ndi nànduku ndi ñu̱n, ta ya'a nàkanini ndi cha'un ―kàtian. ");
INSERT INTO mza_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tajan te'en nāka'an Jesuu chi'in vi: ―¿Ta naja nànduku ndo yu'u? ¿A tüvi chìto ndo ti ìyo yi ña koi ve'e Racha'nu Tatái? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Va töve nī kutunini vi ma ña kà'an ra chi'in vi. ");
INSERT INTO mza_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yakan va chīkoni'i ndiko ra kuànu'u ra chi'in vi iti' ñuu Nazaret, ikan chīyo ra ña jā'a ra ndisaa ma tiñu tāchi vi nuu ra. Ta ma ma'á ra ndākiva'a ña ndisaa ña'a tichi anima ña. ");
INSERT INTO mza_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Takan kūu ta Jesuu kuàkua'nu va'a ra chi'in kuñu ra ta chi'in chinituni ra. Ta chìsii ra ti ìyo ñamani Ndioo chi'in ra, ta juuni ìyo ñamani ma ñivi chi'in ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kuiya cha'un kùu yi ña nda ora kīcha'a Rey Tiberio César chà'nda ra tiñu ñuu ka'nu Roma. Ta ma kuiya ikan ti Ponciu Pilatu, kūu ma ra kuvienu chà'nda tiñu ñu'u' Judea. Ta ma Herode kùu ma ra chà'nda tiñu ñu'u' Galilea. Ta ma yani ra Lipe chà'nda tiñu ñu'u' Iturea chi'in ñu'u' Traconite, ta ndaa ra nàni Lisinia chà'nda ra tiñu ñu'u' Abilinia ma tiempu ikan ndia. ");
INSERT INTO mza_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ta Anás chi'in Caifás, kùu ndra ma ndra sutu chà'nda tiñu. Takan kūu ta ma tiempu ikan, Ndioo nāka'an ra tichi ku'u chi'in Xuva, ra se'e Zacaría. ");
INSERT INTO mza_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Takan kūu Xuva, yā'a ra te'en tikan kàndii yu'u yuta Jordán. Ta ikan kàtitu'un ra nuu ma ñivi na kunduta na ta chikoni'i ndiko na chi'in Ndioo, ikan na janaa ra ma kuati na. ");
INSERT INTO mza_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tandi'i ña'a' kūu yi indukuni takua tāa ma ra kā'an chi'in tu'un yu'u Ndioo, ra chūnani Isaía. Ta yakan, ti te'en kà'an yi: Iin tati kānachaa yi tichi ku'u ta te'en kà'an yi: “Na jandova'a ndo iti' ni kichi ma Racha'nu, ta na nuna ndo iin iti' ndaa kuenda ra. ");
INSERT INTO mza_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ta tandi'i nuu ìyo ndu'va, na ndutu yi, ta tandi'i nuu ìyo yuku na kekoyo yi, ikan na ndondaa nuu ìyo xa'va, vati tandi'i ma iti' yakua ni ndondoo yi. Ta ni ndondaa ma iti' tüvi ndaa ndia. ");
INSERT INTO mza_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Vati tandi'i ñivi ìyo ñuñivi ni nde'e na naja kua ni ja'a Ndioo ña ni jakakú ra na nuu tundo'o”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Takan kūu ta ora chākoyo ndio ma ñivi nuu ma Xuva ña, na jakunduta ra na, tajan te'en nāka'an ra chi'in na: ―Ndyo'o ndian jànda'viña'a takua jà'a ma koo ora kùuni ri ndava ri yo, ¿yo kà'an chi'in ndo ña ni kakú ndo nuu ma tundo'o ka'nu ña ni nde'e ndo iti' nuu?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Va na yüvi takan kùu yi. Kua'an ndo, ta kuàjana'a ndo ndo nuu ma ñivi, ikan na ku'va na kuenda ti ndyo'o cha chīkoni'i ndiko ndo chi'in Ndioo, va koto nätu'un ndo juuni chi'in maa ndo ña ni kakú ndo cha'a' ña kùu ndo ndian kùu ñivi ma racha'nu Abraham ni, ¡ti yüvi yakani kùu yi! Vati ndicha ña kà'in chi'in ndo, ti Ndioo kùu jandaku ra yuu kàndoyo ikan, ña na kuu yi ndian kùu ñivi ma racha'nu Abraham. ");
INSERT INTO mza_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yakan va indukuni kùu yi takua kùu ma yutun tata ña töve chà'a chiti va'a, vati cha ìyo tu'va iin hacha ña ni ta'nda run, ta ka'mio run. Takan ni ja'a Ndioo chi'in ma ñivi ña tüvi jà'a ña va'a. ―Takan kāti Xuva. ");
INSERT INTO mza_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Takan kūu tajan te'en chīkatu'un ndio ma ñivi nuu ma Xuva: ―¿Ta nayi ìyo yi ña ja'a ndi tuva takan? ―kàti na chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ta te'en nāka'an ma Xuva chi'in na: ―Taku ndian ìyo uvi chàku'un ja'ma, na jaya'a na iin chàku'un yi nuu ndian tüvi ìyo nï'iin yi nuu. Ta taku ndian ìyo ña chàchi, na nata'vi na yi chi'in ndian tüvi ìyo ña kachi. ");
INSERT INTO mza_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takan kūu tajan jāyatin ndio iin ma ndra nàka'an xu'un' kuenda ma kuvienu ñuu ka'nu Roma, ña ni jakunduta Xuva ndra. Tajan ndrakan te'en chīkatu'un ndra nuu ma Xuva: ―Yo'o Matru, ¿ta ndyu'u, nayi ìyo yi ña ja'a ndi kuenda ña na jana'a yi ña cha kēsiin ndi ma iti' kini? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tajan te'en nāka'an Xuva chi'in ndra: ―Na näka'an ndo tiá xu'un' ña kua ìyo yi ña naka'an ndo. ");
INSERT INTO mza_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Takan kūu tajan te'en chīkatu'un iin ndra jandaru ka'ìin ikan nuu Xuva ndia: ―Ta ndyu'u, ¿nayi ìyo yi ña ja'a ndi ndia? ―kàti ndra. Ta te'en nāka'an Xuva chi'in ndra: ―Na nämaa ndo nï'iin nakuyi nuu nï'iin ñivi, ta na jäyu'vi ndo na chi'in ma ña tisokuati ndo na cha'a' iin nakuyi ña tüvi nī ja'a na. Ta na sii kuuni ndo chi'in ma xu'un' ña kìya'vini ndo. ");
INSERT INTO mza_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Takan kūu ta tava ma ñivi ndàtu na nde'o nda ora ni kìchaa ma ra kùu Cristu, yakan va chànini na ti Xuva kùu ma ra Cristu, kùuni na. ");
INSERT INTO mza_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Va Xuva te'en nāka'an ra chi'in tandi'i ma ñivi ka'ìin ma ikan: ―Taku yu'u ndicha va'a ña jàkundutai ndo chi'in takuini, va ni kichaa inga ra ña ni jakunduta ndo chi'in Tati Ií Ndioo, ta chi'in ñu'ú. Ta rakan ìyoga ndatu ra kua yu'u, ña ni korrea ndikun ndichan ra tüvi ìyo yi ña ndachi yi. ");
INSERT INTO mza_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ta ni ja'a ra chi'in ma ñivi takua jà'a ndian ndàti nduti. Vati ñivi va'a kùu na takua kùu ma chiti nduti, ta ma ndian töve chìnuni kùu na takua kùu ma soo vu. Ta ra'ya ni tavani'i siin ra ma ndian töve chìnuni ta ni ti'i ra na andaya' nuu tìin ñu'ú ña tüvi nda'va, va ma ñivi va'a ni taan va'a ra na. ―Takan kàti Xuva chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yakan va chi'in tu'un i'ya, ta chi'in inga tuku tu'un jàna'a Xuva ma tu'un va'a Ndioo nuu ma ñivi. ");
INSERT INTO mza_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Takan kūu ta tiá iti' nuu nāka'an Xuva chi'in ra kùu rey Herode ña na vä'a jà'a ra ña ndāki'in ra ña nàni Herodías ña kùu ñasi'i ma ra yani ra Lipe, kàti ra. Yakan va tandi'i yakan, ta ndisaa ma ña kini jā'a ra kātitu'un ra yi nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Takan kūu ta Herode vä'a kūuni ra ora nāka'an ra takan chi'in ra, yakan va kà'an ra chi'in ndra jandaru, na tiin ndra ma Xuva ta ti'i ndra ra vekaa, ta kī'vi ra. ");
INSERT INTO mza_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Va juuni yanga takä'an kì'vi ma Xuva vekaa, ta jākunduta ra tandi'i ma ñivi, juuni jākunduta ra Jesuu ndia. Ta ora kà'an ra chi'in Ndioo, ta iin nūnani ma andivi. ");
INSERT INTO mza_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tajan kōyo ma Tati Ií Ndioo chata Jesuu, ña kàa yi takua kàa iin livi, tajan chīni Jesuu iin tati ma Racha'nu Ndioo ña te'en kà'an yi chi'in ra nda iti' andivi: ―Yo'o kùu ma ra ya'a kùuni̱ nde'i, ti ra se'e mai kùu̱n. Ta ya'a sii kùuni̱ cha'a' yi. ");
INSERT INTO mza_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuu, ra kàti ma ñivi ña kùu se'e Kusé ìyo ra iin oko uchi kuiya ra ora kīcha'a ra jà'a ra tiñu Ndioo. Ta Kusé ti, se'e ra nàni Elí kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ta Elí kùu ra se'e ra nàni Matat. Ta Matat kùu ra se'e ra nàni Leví. Ta Leví kùu ra se'e ra nàni Melquí. Ta Melquí kùu ra se'e ra nàni Jana. Ta Jana kùu ra se'e ra nàni Kusé. ");
INSERT INTO mza_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ta Kusé kùu ra se'e ra nàni Matatías. Ta Matatías, kùu ra se'e ra nàni Amós. Ta Amós kùu ra se'e ra nàni Nahúm. Ta Nahúm kùu ra se'e ra nàni Esli. Ta Esli, kùu ra se'e ra nàni Nagai. ");
INSERT INTO mza_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ta Nagai, kùu ra se'e ra nàni Maat. Ta Maat kùu ra se'e ra nàni Matatías. Ta Matatías, kùu ra se'e ra nàni Semei. Ta Semei, kùu ra se'e ra nàni Kusé. Ta Kusé, kùu ra se'e ra nàni Judá. ");
INSERT INTO mza_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ta Judá, kùu ra se'e ra nàni Joana. Ta Joana, kùu ra se'e ra nàni Resa. Ta Resa, kùu ra se'e ra nàni Zorobabel. Ta Zorobabel, kùu ra se'e ra nàni Salatiel. Ta Salatiel, kùu ra se'e ra nàni Neri. ");
INSERT INTO mza_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ta Neri, kùu ra se'e ra nàni Melquí. Ta Melquí, kùu ra se'e ra nàni Adi. Ta Adi, kùu ra se'e ra nàni Cosam. Ta Cosam, kùu ra se'e ra nàni Elmodam. Ta Elmodam, kùu ra se'e ra nàni Er. ");
INSERT INTO mza_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ta Er, kùu ra se'e ra nàni Josué. Ta Josué, kùu ra se'e ra nàni Eliezer. Ta Eliezer, kùu ra se'e ra nàni Jorim. Ta Jorim, kùu ra se'e ra nàni Matat. ");
INSERT INTO mza_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ta Matat, kùu ra se'e ra nàni Leví. Ta Leví, kùu ra se'e ra nàni Simeón. Ta Simeón, kùu ra se'e ra nàni Judá. Ta Judá, kùu ra se'e ra nàni Kusé. Ta Kusé, kùu ra se'e ra nàni Jonán. Ta Jonán, kùu ra se'e ra nàni Eliaquim. ");
INSERT INTO mza_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ta Eliaquim, kùu ra se'e ra nàni Melea. Ta Melea, kùu ra se'e ra nàni Mainán. Ta Mainán, kùu ra se'e ra nàni Matata. Ta Matata kùu ra se'e ra nàni Natán. ");
INSERT INTO mza_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ta Natán, kùu ra se'e ra nàni David. Ta David, kùu ra se'e ra nàni Isaí. Ta Isaí, kùu ra se'e ra nàni Obed. Ta Obed, kùu ra se'e ra nàni Booz. Ta Booz, kùu ra se'e ra nàni Sélah. Ta Sélah kùu ra se'e ra nàni Naasón. ");
INSERT INTO mza_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ta Naasón, kùu ra se'e ra nàni Aminadab. Ta Aminadab, kùu ra se'e ra nàni Aram. Ta Aram, kùu ra se'e ra nàni Esrom. Ta Esrom, kùu ra se'e ra nàni Fares. Ta Fares, kùu ra se'e ra nàni Judá. ");
INSERT INTO mza_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ta Judá, kùu ra se'e ra nàni Jacob. Ta Jacob, kùu ra se'e ra nàni Isaac. Ta Isaac, kùu ra se'e ra nàni Abraham. Ta Abraham, kùu ra se'e ra nàni Taré. Ta Taré, kùu ra se'e ra nàni Nacor. ");
INSERT INTO mza_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ta Nacor, kùu ra se'e ra nàni Serug. Ta Serug, kùu ra se'e ra nàni Ragau. Ta Ragau, kùu ra se'e ra nàni Peleg. Ta Peleg, kùu ra se'e ra nàni Heber. Ta Heber, kùu ra se'e ra nàni Sala. ");
INSERT INTO mza_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ta Sala, kùu ra se'e ra nàni Cainán. Ta Cainán, kùu ra se'e ra nàni Arfaxad. Ta Arfaxad, kùu ra se'e ra nàni Sem. Ta Sem, kùu ra se'e ra nàni Noé. Ta Noé, kùu ra se'e ra nàni Lamec. ");
INSERT INTO mza_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ta Lamec, kùu ra se'e ra nàni Matusalén. Ta Matusalén, kùu ra se'e ra nàni Enoc. Ta Enoc, kùu ra se'e ra nàni Jared. Ta Jared kùu ra se'e ra nàni Mahalaleel. Ta Mahalaleel kùu ra se'e ra nàni Cainán. ");
INSERT INTO mza_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ta Cainán kùu ra se'e ra nàni Enós. Ta Enós, kùu ra se'e ra nàni Set. Ta Set, kùu ra se'e ra nàni Adán. Ta Adán kùu ra, ra se'e Racha'nu Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ta takua ya'a ìyo ma Tati Ií Ndioo chi'in Jesuu, ma ora cha yā'a kūnduta ra, tajan chīkoni'i ndiko ra ma yu'u yuta Jordán, ta ma Tati Ií Ndioo chāka ndio yi ra na ku'un ra chi'in ra iti' tichi ku'u. ");
INSERT INTO mza_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ta ma tichi ku'u ikan chīyo ra uvi xiko kivi. Ta ikan kī'in ma kui'na ku'va ra nde'o tu koyo ra tichi kuati. Takan kūu tajan ndisaa ma tiempu ña chīyo ra tichi ku'u, endee tüvi nī chachi ra, yakan va chāa ndio iin kivi ña chāñu soko ra. ");
INSERT INTO mza_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Takan kūu tajan te'en nāka'an ndio ma kui'na chi'in Jesuu: ―Tuva ndicha ña ra Se'e Ndioo kùu̱n, na jandakuu̱n ma yuu kàndii chiña paan ―kàti ma kui'na. ");
INSERT INTO mza_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Va Jesuu te'en nāka'an ra chi'in ma kui'na: ―“Yüvi uvaa paani chìniñu'u kachi ma ñivi, ti juuni tu'un yu'u Ndioo ndia”, takan kàti ma tutu Ndioo ―kàti Jesuu chi'in ma kui'na. ");
INSERT INTO mza_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Takan kūu tajan chāka ndio ma kui'na ma Jesuu ña na ku'un ra chi'in ra nda siki iin yuku ña nduva'a kuii sukun. Ta nunuuni jāna'a ma kui'na tandi'i ñuu ñuñivi nuu chà'ndán' tiñu nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tajan te'en nāka'an ndio ma kui'na chi'in ra: ―Tandi'i ma ñuu ñuñivi ña ndè'un ninuu ndakan, mai kùu ma ra chà'nda tiñu ikan, ti mai nī'i yi. Va tuva kùuni̱, kùu ku'vai yi nuu nda ndian kùuni mai. ");
INSERT INTO mza_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yakan va tuva kunandi chitiun nui, ta jaka'nu̱n yu'u, ta tandi'i ña ndè'un ninuu ndakan, ni ku'vai yi nuu̱n. ―Takan kàti ma kui'na chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tajan te'en nāka'an tuku Jesuu chi'in ma kui'na: ―Na kundachiyoun xii̱n, yo'o kui'na kini, ti ma tutu Ndioo te'en kà'an yi: “Uvanuu Racha'nu Ndioo ìyo yi ña jaka'nu yo, ta uvanuu Rakan ìyo yi ña ja'a yo tiñu nuu.” ―Takan kàti Jesuu chi'in ma kui'na. ");
INSERT INTO mza_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Takan kūu tajan kēe ndio ma kui'na kuà'án' chi'in Jesuu iti' ñuu Jerusalén. Ta ikan ndāa ma kui'na chi'in Jesuu nda nuu sukun xini veñu'u ka'nu ndaa ikan. Ta te'en nāka'an ndioán' chi'in Jesuu: ―Tuva ndicha ña ra Se'e Ndioo kùu̱n, nda nde've na keun, ta koyoun nda ninuu ndakan, ");
INSERT INTO mza_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ti ma tutu Ndioo te'en kà'an yi: Ndioo ni tachi ra kua'a' tati jà'a tiñu nuu ra ña na jakuenda yi ñu̱n, ");
INSERT INTO mza_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","vati ni kani'i yi ñu̱n chi'in nda'a' yi, koto kati'un yuu. ―Takan kàti ma kui'na chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Va Jesuu te'en nāka'an ra chi'in ma kui'na: ―Ma tutu Ndioo juuni te'en kà'an yi ndia: “Na kï'un ku'va ma Racha'nu Ndioo yo.” ―Takan kàti Jesuu chi'in ma kui'na. ");
INSERT INTO mza_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Takan kūu tajan jāchika ndio ma kui'na ñá' nuu Jesuu kua'a' tiempu, ti tüvi nī kuu nani'án' inga tuku naja kua kì'án' ku'va Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tajan chīkoni'i ndiko Jesuu kuà'an ra iti' ñu'u' Galilea chi'in kua'a' ndatu ma Tati Ií Ndioo. Ta chītakuati tu'un cha'a' ra ninii ñuu kàndii ikan. ");
INSERT INTO mza_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ta ikan kīcha'a jàna'a Jesuu tu'un Ndioo nuu ñivi tichi ndisaa veñu'u kuati ña ìyo ta'ii'iin ñuu ikan. Yakan va tandi'i ma ñivi ikan jàka'nu na Jesuu, ora jàna'a ra tu'un Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ta ikan jan chāa ndio Jesuu ma ñuu Nazaret nuu chā'nu ra ora kūu ra ravali. Tajan kī'vi ndio ra ma tichi veñu'u ndian judíu iin kivi nindeo ma takua takani jà'a ra. Ta chūndaa ndio ra ña ni jàkua'a ra ma tutu Ndioo nuu ma ñivi ikan. ");
INSERT INTO mza_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ta ndiakan chā'a na ma tutu Ndioo tāa racha'nu Isaía, ra kā'an chi'in tu'un yu'u Ndioo ña chīyo tatiempu nuu ra. Ta ora nūna ra yi, ta ikan nāta'an ra iin nuu kà'an yi te'en, ta jākua'a ra yi nuu na: ");
INSERT INTO mza_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Taku yu'u, ti ìyo ma Tati Ií Ndioo chi'i̱n, vati cha jā'ií yi yu'u, ña na katitu'in tu'un va'a Ndioo nuu ñivi nda'vi. Ta juuni tāchi yi yu'u ña na janda'i ma ndian ya'a nda'vi kuuni anima. Ta na katitu'in naja kua kùu kakú ma ndian indii tichi vekaa jà'a kuati, ta nda ma ndian kuaá ni janda'i na, ta kùu nande'e ndiko na. Ta ni ja'i kuenda ndian ndè'e tundo'o ña na kakú na. ");
INSERT INTO mza_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta juuni chà'i kuenda nuu ñivi ña ni keta ma kivi va'a tiá iti' nuu kuenda yo jà'a ma Racha'nu. ");
INSERT INTO mza_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Takan kūu tajan chāsi ndio Jesuu ma tutu, ta chā'a ndio ra yi nuu ma ra jàkuenda veñu'u, tajan chūnandi ndio ra. Ta tandi'i ma ñivi ka'ìin ikan, endee tüvi nī jaña na ña ndè'e na ra. ");
INSERT INTO mza_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tajan te'en nāka'an ndio Jesuu chi'in na: ―Juuni ma kivi i'ya kētai ña jàchinui ma tiñu kà'an ma tu'un Ndioo i'ya nuu ndo. ");
INSERT INTO mza_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Takan kūu ta ndisaa na ndava kuà'an anima na ora chīni na ña ya'aga vii ma tu'un kā'an Jesuu. Tajan te'en kīcha'a na chìkatu'un na chi'in juuni maa na: ―¿A yüvi ra'ya kùu ra se'e Kusé? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tajan te'en nāka'an ndio Jesuu chi'in na: ―Taku ndyo'o ti te'en chànini ndo takua kà'an iin tu'un i'ya: “Yo'o ra kùu ndotor, na janda'un ñu̱n chi'in juuni maun.” Takua jānda'un ma ñivi ñuu Capernaum niku, yakan va ìyo yi ña janda'un ma ñivi ñuu maun vitin. Takan kùuni ndo ka'an ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Takan kūu ta Jesuu ti te'en nāka'an tuku ra chi'in na: ―Ndicha va'i ña kà'in chi'in ndo, ti nï'iin ma ndra kà'an chi'in tu'un yu'u Ndioo töve kùuni ñivi ñuu maa ra nde'e na ra. ");
INSERT INTO mza_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yakan va ndicha va'i ña kà'in, ti nduva'a kuii chīyo kua'a' ñivi ña'a kīndoo nda'vi ñuu Israel ma tiempu chīyo ma ra kā'an tu'un yu'u Ndioo ña nàni Elía. Ta juuni ma tiempu ikan, uni kuiya java kùu yi ña tüvi nī kuun ma savi, ta chīyo kua'a' tama' tandi'i ma ñu'u' ñuñivi ndia. ");
INSERT INTO mza_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Va Elía, töve nī kichi ra kuenda ña tìndee ra ñivi ña'a nda'vi ìyo ñuu Israel, ti kīchi ra ña kuenda ña tìndee ra iini ña'a nda'vi ña kīchi iti' ñuu Sarepta, ña kàndii yatin ñuu Sidón. ");
INSERT INTO mza_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Takan kūu ta ma tiempu chīyo ma ra kā'an tu'un yu'u Ndioo ña nàni Eliseu. Tiempu ikan, nduva'a kuii chīyo ndian ndiso kue'e ta'yu ma ñuu Israel, va nï'iin ma ndian ndiso kue'e ikan tüvi nī nda'a. Uvanuu ra nàni Naamán ña kīchi iti' ñu'u' Siria, jānda'a Eliseu. ―Takan kàti Jesuu chi'in ma ñivi ikan. ");
INSERT INTO mza_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Takan kūu ta ora chīni ma ndian ka'ìin veñu'u ña kā'an ra takan nduva'a kuii kūxaan na chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tajan ndēta ndio na, ta jākunu na Jesuu, ma ñuu ikan, ta chāndaka na ra iin tichi ku'u nuu ìyo iin xa'va ña nduva'a kuii sukun yu'u ñuu ikan, ti tichi xa'va ikan, ni jake'ne na ra. ");
INSERT INTO mza_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Va Jesuu kākú ra tañu na, ta kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Takan kūu ta kēe ndio Jesuu kuà'an ra iti' ñuu Capernaum, ña kàndii ñu'u' Galilea. Yakan va nani kivi nìndee na kùu yi, ña kēe ra kuà'an ra kuàjana'a ra nuu ñivi tichi veñu'u ndian judíu ikan. ");
INSERT INTO mza_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Takan kūu ta ma ñivi ikan ndava kuà'an tati na ña ndè'e na naja kua jàna'a ra, vati kà'an ra yi chi'in tandi'i ndatu ra. ");
INSERT INTO mza_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Takan kūu ta ma tichi veñu'u ikan, ndaa iin ra ndiso tati xaan. Ta rakan ti te'en nāka'an ni'i ra ña kànachaa ra: ");
INSERT INTO mza_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Yo'o Jesuu ra ñuu Nazaret, na jañaun ña ya'a ndiku̱n ndi, ti ndyu'u cha chìto ndi ña vàchiun vàchi jandi'un nuu ndi. Ta juuni chìto ndi, ti yo'o kùu iin ra ya'a ií ña tāchi Ndioo jà'a tiñu nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Takan kūu tajan te'en nāka'an xaan Jesuu nuu ma tati xaan ikan: ―¡Taxiin koo yu'u̱n, ta na keun tichi kuñu ra'ya! ―kàti Jesuu chi'in yi. Tajan jānduva ma tati xaan ikan ra, nuu ndè'e ndisaa ñivi. Tajan kēe ndio yi ma tichi kuñu ra, va tüva nani ja'a yi chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Takan kūu ta ndisaa na ya'aga yù'vi na, ta te'en kīcha'a na nàtu'un ta'an na: ―¿A ya'aga ìyo ndatu ra chi'in ma tu'un kà'an ra, ña ndava nda tati kui'na jà'a yi ña kà'an ra, ta kèe yi tichi kuñu ndian ku'vi jà'a ra? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Takan kūu ta ninii ñu'u' ikan chītakuati tu'un Jesuu chi'in ma ña jà'a ra. ");
INSERT INTO mza_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Takan kūu tajan kēe Jesuu ma tichi veñu'u ñivi judíu, ta kuà'an ra ve'e Simón Petu'. Ta ma ñaka'nu Simón Petu', ti ku'vian kàndian jà'a ka'ni ora chāa Jesuu. Tajan jānini ndio ma ñivi ikan Jesuu, na tindee ra ña chi'in ma kue'e ndò'an. ");
INSERT INTO mza_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Takan kūu tajan chāa ndio Jesuu ma nuu kàndian, ta chūndandee ra nuan. Tajan kēe ndio ma ka'ni ña, ta ndā'a ña. Ta juuni ma ora ikan ndēta ña ta kīcha'a ña jà'a ña ma ña kachi ndra. ");
INSERT INTO mza_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ora cha chīso nikandii, ma ora ikan tandi'i ma ndian ìyo ndian ku'vi nuu, jà'a nda kue'e nikuuni, chāndaka na na nuu Jesuu. Ta ikan jūndii ra nda'a' ra xini ta'ii'iin na, ta ndā'a na jā'a ra. ");
INSERT INTO mza_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Takan kūu ta tava yà'a kua'a' na, yakan va ìyo ma ndian ndiso tati xaan ña te'en kà'an yi ora kèe yi: ―¡Yo'o kùu ra Se'e Ndioo! ―kàti yi. Va Jesuu endee töve chà'a ra kà'an yi, ti ora kà'an yi takan nundaa kuxaan ra nuu yi, vati cha chīto yi ti ra Cristu kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Takan kūu ta ora tuvi inga kivi, tajan kēe Jesuu ma ñuu ikan, ta kuà'an ra iin nuu taxiin nuu tüvi ñivi. Va vaji takan jā'a ra ninii nāta'an ma ñivi ra, tajan chāa ndio na ma nuu ndaa ra. Ta kīcha'a na kà'an na chi'in ra na kü'un ra. ");
INSERT INTO mza_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tajan te'en nāka'an ndio Jesuu chi'in na: ―Na küuga kindoi chi'in ndo nde've, ti juuni ìyo yi ña ku'in kukatitu'in nuu ñivi inga ñuu, ikan na koto na naja kuu yi nuu chà'nda Ndioo tiñu. Vati tiñu ikan tāchi Tatái yu'u. ");
INSERT INTO mza_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Takan kūu ta takan kuà'an Jesuu jàna'a ra tu'un Ndioo nuu ñivi nani veñu'u ndian judíu ìyo ñu'u' ñuu Judea. ");
INSERT INTO mza_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Takan kūu ta kēta iin kivi ña ndaa Jesuu ma yu'u lakuna nàni Genesaret, nuu kùuni ma ñivi taso'o na ma tu'un Ndioo ña jàna'a Jesuu. Ta chākoyo kua'a' ñivi ña ndava tituta'an na ma nuu ndaa ra. ");
INSERT INTO mza_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Takan kūu tajan ndē'e Jesuu uvi ta'an varku ña ndaa ndrun yu'u lakuna. Ta ninduvi ta'an ndrun töva ñivi tichi ndrun, ti ma ndra xuña'a run ka'ìin ndra yu'u ma lakuna nàkata ndra ma yu'va tiaka' ka'nu ndra. ");
INSERT INTO mza_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tajan ndāa ndio Jesuu tichi varku xuña'a ma ra nàni Simón, ta nāka'an ra chi'in ra ña na jaku'un ra run tiá iti' tichi lakuna. Ta nda ndakan chūnandi ndio ra jàna'a ra nuu ma ñivi ka'ìin yu'u lakuna. ");
INSERT INTO mza_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tajan ora chīnu jàna'a ra nuu ma ñivi, ta te'en nāka'an ndio ra chi'in Simón: ―Na kundaka ndo ma varku i'ya ku'un ndo kukiin ndo nuu kunu ma lakuna, ta kani ndo yu'va tiaka' ka'nu tichi ra' ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tajan te'en nāka'an Simón chi'in ra: ―Yo'o Matru, niñuu kuii chākunuu ndi kīin ndi, va tükuii nani nī'i ndi. Va tava maun kà'an ña na ku'un ndi, yakan va ni kukani ndi yi tuva takan ―kàti Simón. ");
INSERT INTO mza_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Takan kūu tajan kēe ndio ndra kuàkiin ndra, ta nduva'a kuii kua'a' ma tiaka' nī'i ndra ña nda ma yu'va tiaka' ndra kīcha'a yi nakaa yi ma ora kīcha'a ndra tàvani'i ndio ndra yi. ");
INSERT INTO mza_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tajan kāna nda'a' ndio ndra nuu ma ndra meru ndra, ndra kìndoo chi'in inga varku, ña na ku'un ndra tìndee ndra ndra. Tajan kēe ndio ndra kuà'an ndra chi'in run. Ta ora chāa ndio ndra, ta tāvani'i ndio ndra ma yu'va tiaka' ikan chi'in kua'a' tiaka' ña ndava ni sa'vi ndrun, ti ya'a kua'a' ndri nī'i ndra. ");
INSERT INTO mza_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yakan va ora ndē'e Simón Petu' ña jā'a Jesuu chi'in ma ndatu ra, tajan chūnandi chiti ra nuu Jesuu, ta te'en nāka'an ra chi'in ra: ―¡Kundachiyo xii̱n yo'o Racha'nu, vati yu'u kùi iin ra jà'a kuati! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Takan kā'an Simón, ti ya'aga yū'vi ra chi'in ma ndra meru ra, vati kua'a' tiaka' tīin ndra ma ora tāchi Jesuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ta nda ma Jandiau, ta Xuva, ndra se'e Zebedeu, ña kùu meru ma Simón, juuni yū'vi ndra ndia. Tajan te'en nāka'an ndio Jesuu chi'in Simón: ―¡Na yü'viun! Vati nda vitin, ta iti' nuu, ni jandakui ñu̱n, ña na nani'un ñivi kuenda Ndioo, takua jā'un chi'in ma tiaka'. ―Takan kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Takan kūu ta ora jātu'va ndra varku ndra yu'u ma lakuna, tajan ndākiva'a ndra ndatiñu ndra tichi ndrun, ta tāndikun ndio ndra kuà'an ndra chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iin kivi yā'a Jesuu iin ñuu, ta ikan chāa iin raku'vi jà'a kue'e ta'yu nuu ndaa ra. Ta rakan ti ora ndē'e ra Jesuu, ta chūnandi chiti ra nuu ra, ta te'en nāka'an ra chi'in ra ña chīkan ra ñamani nuu ra ña na janda'a ra ra: ―¡Yo'o Racha'nu, chìtoi ña ìyo ndatun ta kùu janda'un yu'u tuva kùuniun! ―Takan kāti ma raku'vi chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tajan jūndii ndio Jesuu nda'a' ra xini ra, ta te'en nāka'an ra chi'in ra: ―Juu, ndicha ña kùuni̱ janda'i ñu̱n ―kàti Jesuu. Tajan juuni ma ora ikan, ndā'a ma ra ndo'o kue'e ta'yu. ");
INSERT INTO mza_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Takan kūu tajan te'en nāka'an ndio Jesuu ña chūndayu'u ra ra: ―Na kätitu'un nuu nï'iin na naja kua jā'un ña ndā'un. Ji'na kuii nuu sutu ña ìyo ma veñu'u ka'nu ñuu Jerusalén, ìyo yi ña jana'un ñu̱n, ikan na koto ra ti cha ndā'un. Tajan na sokóun iin kiti nuu sutu kuenda Ndioo, ti takan kàti ma tutu Ndioo ña tāa Moisés ña ìyo yi ña ja'a yo, ikan na koto ñivi ña cha ndā'un ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yakan va tandi'i ña jà'a Jesuu, vi'a chītakuati yi tandi'i ñuu, ta vi'a kua'a' ma ñivi kūti'vi nuu ndaa ra, ti ìyo ndian kùuni na ña na janda'a ra na chi'in ma kue'e ndo'o na, ta ìyo ndian chàta'ani taso'o na ma ña jàna'a ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tajan kēe ndio Jesuu kuà'an ra iin tichi ku'u nuu tüvi ñivi, ña kuàka'an ra chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kēta iin kivi ña ndaa Jesuu jàna'a ra nuu ñivi. Ta juuni ma ora ikan chàkuiin kua'a' ndra fariseu chi'in ndra matru jàkua'a tutu Ndioo ma ikan. Ta tandi'i ndrakan kīchi ndra iti' ñuu Jerusalén chi'in ñuu kàndii ñu'u' Judea chi'in ñu'u' Galilea ndia. Takan kūu ta ìyo ndatu Ndioo chi'in Jesuu, vati chi'in ndatu ikan jànda'a ra ma ndian ku'vi. ");
INSERT INTO mza_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ta chanuu ña ndaa ra ikan, tajan chāa uvi uni ta'an ndra ña ndiso ndra, ra kūyutun chi'in ti'va. Ta ndrakan ti kùuni ndra ki'vi ndra chi'in ra ma tichi ve'e nuu ndaa Jesuu, kuenda ña kanindii ndra ra nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Va nī kuu yi, ti ya'aga kua'a' ñivi ka'ìin ma yuve'e, yakan va ndāa ndra nduku iti' chata ma ve'e, ta tāchiyo ndra ita'vi ma teja ña ka'ìin chata yi, ta chi'in ti'va ra jānuu ndio ndra ra tañu ñivi, tajan chāa ra nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Takan kūu ta ora ndē'e Jesuu ña ndicha kuii ña chìnuni ndra ma ña jà'a ra, tajan te'en nāka'an ndio Jesuu chi'in ma ra kūyutun: ―Yo'o se'yu, vitin va cha jānai kuatiun. ―Takan kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Takan kūu ta ora kā'an Jesuu takan, tajan te'en kīcha'a ma ndra fariseu chi'in ma ndra matru jàkua'a tutu Ndioo chànini ndra: “¿Nda ra kùu ra'ya ña kà'an ti'ini ra chata Ndioo? ¿A tüvi chìto ra ña uvanuu Ndioo ìyo, ta rakan kùu ma ra kùu janaa kuatio?” Takan chànini ndra. ");
INSERT INTO mza_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tajan numini nākuni Jesuu ma ña chànini ndra, ta te'en kīcha'a ndio ra chìkatu'un ra nuu ndra: ―¿Ta naja chànini ndo takan? ");
INSERT INTO mza_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Nda va kùu ma ña ndetiñu tiaga ña ka'an yo chi'in ma ñivi?, kùuni ndo. ¿A tiaga ndetiñu kà'an yo ña: “Cha jānai kuatiun”, kua ña kà'an yo: “Ndeta, ta kakaun ku'un”?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tatu töve chìnuni ndo ma ña kà'in, vitin ni jana'i nuu ndo ti ndicha ña ra Se'e ñivi tàchi Ndioo kùi, vati juuni ìyo ndatui ña jànai kuati ñivi ìyo ñu'u' ñuñivi i'ya ndia ―kàti Jesuu. Tajan te'en nāka'an ndio ra chi'in ma ra kūyutun: ―¡Chi'in yo'o kà'in ña na ndetaun, ta natuviun ti'vaun ta ku'u̱n ve'un! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Takan kūu tajan juuni ma ora ikani, ndē'e ma ñivi ña ndēta ma ra kūyutun, ta nātuvi ra ti'va ra, ta endee jàka'nu ndio ra Ndioo kuà'an ra ve'e ra. ");
INSERT INTO mza_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ta ora ndē'e na ña takan kūu, tajan tandi'i ndio na ndava kuà'an anima na, ta te'en kīcha'a ndio na jàka'nu ndio na Ndioo ña yā'a yū'vi na chi'in ma tu'un i'ya: ―Kivi i'ya, va nduva'a kuii vii ña ndē'o ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Takan kūu ta ora yā'a ña kūu takan, tajan kēe ndiko Jesuu kuà'an ra, ta ikan ndē'e ra iin ra nàni Leví ña nàndi ra nàka'an ra xu'un' kuenda Roma. Tajan te'en nāka'an Jesuu chi'in ra: ―¡Na'a, na ko'o chi'i̱n! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ta juuni ma ora ikani, ndākoo ma Leví ndisaa tiñu jà'a ra, ta tāndikun ra kuà'an ra chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Takan kūu ta ora yā'a yatin kivi, tajan jā'a Leví iin viko ka'nu ma nuu ìyo ve'e ra kuenda Jesuu. Ta tañu ndian nàndi mesa chi'in Leví ta Jesuu, ka'ìin kua'a' ma ndra nàka'an xu'un' ña ndàkata'an chi'in Leví. ");
INSERT INTO mza_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Va ma ndra fariseu chi'in ma ndra matru, ndra jàkua'a tutu Ndioo, te'en kīcha'a ndra kà'an ti'ini ndra chata ma ndra jàkua'a chi'in Jesuu: ―¿Ta naja chàchi ndo ta chì'i ndo chi'in ndra nàka'an xu'un' kuenda ñuu ka'nu Roma, ta chi'in ndian ìyo kuati? ―Takan kàti ndra chata ndra jàkua'a chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Taku ma ndian ìyo va'a, tüvi chìniñu'u na ma ndra ndotor, ti ndian ku'vini kùu ma ndian chìniñu'u yi. ");
INSERT INTO mza_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ta yu'u ti tüvi vàchi̱ kuenda ma ndian tüvi chìniñu'u yu'u, vati vàchi̱ kuenda ma ndian ìyo kuati, ikan na ndakoo na kuati na, ta chìkoni'i ndiko na chi'in Ndioo. Ndiakan kùu ma ndian chìniñu'u yu'u ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tajan te'en nāka'an ndra chi'in Jesuu: ―¿Ta naja ma ndra chàkunuu chata Xuva ra jàkunduta, ta chi'in ndra chàkunuu chata ndra fariseu, nduva'a jàndita yu'u ndra kuenda Ndioo ma ora kà'an ndra chi'in Ndioo? Va ma ndra jàkua'a chi'un, ¿ta naja endee chàchi ndra, ta chì'i ndra, ta töve jàndita ndra yu'u ndra? ―Takan kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ta te'en nāka'an ndio Jesuu nuu ndra: ―¿A kùu jandita ndo yu'u ma ndian ka'ìin nuu ìyo viko tànda'a ora juuni ndaaga ma ra tànda'a chi'in na?, kùuni ndo. Na küu yi. ");
INSERT INTO mza_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Va ni chaa iin kivi ña ni tava ni'i na ma ra tànda'a, ta ora ni keta ma kivi ikan, tajan kùu jandita ndio na yu'u na. ―Takan kàti Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Takan kūu tajan te'en nàka'an tuku Jesuu iin ku'va nuu ndra: ―Na küu ka'nda yo ita'vi ma ja'ma chaa, ta nataa yo yi chi'in ja'ma cha'nu, ti tu jà'a yo takan, tajan ni jativio ma ja'ma chaa. Ta yüvi yakani kùu yi, ti ma pedazu ma ja'ma chaa na tüvi va'a kìndoo yi chi'in ma ja'ma cha'nu ndia. ");
INSERT INTO mza_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta juuni na küu taan yo vinu chaa tichi tia'a ñii cha'nu, ti ma vinu chaa, ni jaka'ndi ra ma tia'a ñii cha'nu, ta ma takuii vinu chaa tìvi ra' chi'in ma tia'a ñii cha'nu ndia. ");
INSERT INTO mza_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yakan va ìyo yi ña taan yo ma vinu chaa tichi ma tia'a ñii chaa, ta ninduvi yi kùu kumi yi yi. ");
INSERT INTO mza_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ta nï'iin ma ndian chì'i ma vinu cha'nu, na küuni na jaña na ña chì'i na ra', ta ko'o na ma vinu chaa, vati kà'an na ña va'aga chì'i ma vinu cha'nu. ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Takan kūu ta iin kivi nindeo, chàkunuu Jesuu iin nuu kàa kua'a' trigu. Ta ma ndra jàkua'a chi'in ra, kīcha'a ndra kìndaa ndra trigu, ta kùnda'a ndra vu, ta chàchi ndra ma chiti vu. ");
INSERT INTO mza_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tajan te'en kīcha'a chìkatu'un ma ndra fariseu nuu ndra: ―¿Ta naja jà'a ndo iin ña tüvi ìyo yi ña ja'a ndo ma kivi nindeo? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tajan te'en kīcha'a nàka'an ndio Jesuu nuu ndra: ―¿A tüvi chàku'uni ndo ña jā'a ma racha'nu David, ora ya'aga chāñu soko ra chi'in ndra meru ra? ");
INSERT INTO mza_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ma racha'nu David kī'vi ra ma tichi veñu'u Ndioo, ta kī'in ra ma paan ií kuenda Ndioo, ta chāchi ra yi chi'in ndra meru ra, vaji ma paan ikan na küu kachi nda ndian nikuuni yi, ti kuenda ma ndra sutuni kùu yi. ");
INSERT INTO mza_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","’Yakan va kà'in chi'in ndo ña ma ra Se'e ñivi tāchi Ndioo, juuni ìyo ndatu ra jin ma kivi nindeo kùu yi. ―Takan kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Takan kūu ta inga kivi nindeo, kī'vi tuku Jesuu ma tichi veñu'u, ta ikan kīcha'a tuku ra jàna'a ra nuu na. Ta juuni ma tichi veñu'u ikan, ndaa iin ra ití ma nda'a' chiyo kua'a. ");
INSERT INTO mza_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ta ma ndra matru jàkua'a tutu Ndioo chi'in ndra fariseu, jà'a ndra kuenda nde'o tu janda'a Jesuu ma ra nda'a' ití ma kivi nindeo, tajan kùu ni'i ndio ndra naja kua tisokuati ndra ra, kùuni ndra. ");
INSERT INTO mza_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Va tava cha chìto Jesuu naja kua chànini ndra, yakan va te'en nāka'an ra chi'in ma ra nda'a' ití: ―Ndeta, ta kundaun ma'ñu chiña ―kàti Jesuu. Tajan ndēta ndio ra, ta chūndaa ra ma'ñu ikan. ");
INSERT INTO mza_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tajan te'en nāka'an ndio Jesuu chi'in ma ndra fariseu: ―Ni ndakatu'in iin nakuyi nuu ndo ―kàti Jesuu chi'in ndra. ―¿Nda ña kùu yi va'a ja'a yo ma kivi nindeo?, kùuni ndo. ¿A jà'a yo ña va'a a ña vä'a? ¿A tiá va'a ña jàkakú yo na a ndè'e nio ña kuvi na? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Takan kūu tajan chīkonuu ra nde'e ra ma ndian ka'ìin xiin ra, ta te'en nāka'an ndio ra chi'in ma ra kukue'e nda'a': ―¡Jànakee nda'un! ―kàti ra. Tajan jānakee ra nda'a' ra, ta ora ikani, ndā'a yi. ");
INSERT INTO mza_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Va inga ma ndra fariseu, nduva'a kuii kūxaan ndra ña jā'a Jesuu takan. Tajan kīcha'a ndra nàtu'un ta'an ndra naja kua ja'a ndra, ta kuu nani'i ndra naja kua tisokuati ndra Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Takan kūu ta iin ma kivi ikan, ndāa Jesuu iti' yuku ña kuàka'an ra chi'in Ndioo. Ta ndakan niñuu kuii jāya'a ra chanikuaa ña kà'an ra chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ta ora kūndichin inga kivi, tajan kāna ra, ndra jàkua'a chi'in ra, ta kāchin ra ndi uchi uvi ta'an ndra ni kakuu chi'in ra. Ta ndrakan jākunani ra ndra tatun. ");
INSERT INTO mza_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ta ndra'ya kùu ma ndra kāchin ra: Simón, ra jākunani Jesuu, Petu', ta André, ra yani Simón, chi'in Jandiau, Xuva, Lipe, Tolo, ");
INSERT INTO mza_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mate, Tomá, chi'in Jandiau, ra se'e Alfeu. Simón, ra juuni kà'an na ña nàni Zelote, ");
INSERT INTO mza_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","chi'in Juda, ra se'e Jandiau, ta Juda Iscariote, ra ni xikoña'a Jesuu tiá iti' nuu. ");
INSERT INTO mza_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Takan kūu tajan nūu ndio Jesuu ma yuku ikan chi'in ndra jàkua'a chi'in ra. Ta ora kēta ndio ra iin nuu ndaa, ta chūndaa ra chi'in ndra, ta chi'in kua'a' ma ñivi kīchi inga ñuu ndia. Ìyo ndian kīchi tandi'i ñuu ña ìyo ma ñu'u' Judea, ta ìyo inga ndian kīchi iti' ñuu Jerusalén. Ta ìyo inga ndian kīchi iti' yu'u tañu'u nuu kàndii ma ñuu Tiro, ta ñuu Sidón. Tandi'i ndiakan tāndikun na chata Jesuu, ti kùuni na taso'o na ña kà'an ra. Ta juuni kùuni na ña na janda'a ra na chi'in ma kue'e ndo'o na ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ta ma ndian ndè'e tundo'o jà'a ma tati xaan, juuni ndà'a na jà'a Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ta tandi'i ma ñivi kùuni na janani na nda'a' na ra, ti cha chìto na ña ora kè'e na ra, ta ndà'a na jà'a ma ndatu Ndioo ña ìyo chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tajan ndē'e ndio Jesuu ma ndra jàkua'a chi'in ra, ta te'en nāka'an ndio ra chi'in ndra: ―Ndyo'o ndra nda'vi, na sii kuuni ndo, vati kuenda maa ndo kùu ma nuu chà'nda Ndioo tiñu. ");
INSERT INTO mza_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ta juuni na sii kuuni ndyo'o ndian ndo'o tama' vitin, ti tiá iti' nuu ni keta iin kivi ña ni koo va'a ndo ti tüva ni nde'e ndo tama'. ’Ta na sii kuuni ndyo'o ndian kàchaku vitin, ti tiá iti' nuu ni keta iin kivi ña ni kuakú ndo. ");
INSERT INTO mza_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ta juuni na sii kuuni ndo ora xaani ñivi ndè'e na ndo, ta tavani'i siin na ndo, ta ora kà'an ti'ini na chata ndo, ta ora kà'an na ña yüvi ndian va'a kùu ndo, cha'a' ña chìnuni ndo ña kà'an yu'u ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Na nduva'a kuii sii kuuni ndo ma kivi ikan, ti ma iti' andivi nduva'a kua'a' ta'vi ni ni'i ndo, vati juuni takan jāti'ini ma ndian kūu ñivi na ma ndra kā'an chi'in tu'un yu'u Ndioo taji'na niku ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’¡Nda'vi ta'an ndyo'o ndian kuika, vati ma ña chìsii ndo va'a yi, va kuenda nde'veni! ");
INSERT INTO mza_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Nda'vi ta'an ndyo'o ndian chànini ndo ña ìyo va'a ndo, ti tükuii nayi kumani nuu ndo vitin!, kùuni ndo. Vati ni chaa iin kivi ña ni ndo'o ndo tama'. ’¡Nda'vi ta'an ndyo'o ma vitin, ti ni chaa iin kivi ña ni kuaku ndo jà'a ña ya'a nda'vi ni kuuni ndo! ");
INSERT INTO mza_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡Nda'vi ta'an ndyo'o ora ni ka'an va'a ndisaa ma ñivi ìyo ñuñivi chata ndo, vati ma tatiempu juuni chīyo ma ndra jā'ani ña kà'an tu'un yu'u Ndioo, ta ma ñivi na ña chīyo taji'na, juuni jāka'nu na ndra, vaji ndra vatani kūu ndra ndia! ");
INSERT INTO mza_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Va ndyo'o ndian chìni ña kà'in, yu'u kà'in chi'in ndo ña, na kuuni ndo nde'e ndo ma ndian xaani nde'e ndo, ta jà'a ndo tiñu va'a kuenda na. ");
INSERT INTO mza_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ta na ja'ií ndo ma ndian kànduva'a chata ndo, ta na ka'an ndo chi'in Ndioo cha'a' ma ndian kà'an ti'ini chata ndo. ");
INSERT INTO mza_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta tu ìyo iin yo kàni xa'nda iin chiyo cha'a so'o ndo, na ku'va ndo inga chiyo yi na kani na ndia. Ta tu ìyo iin yo nàmaa ma ja'ma isukun ndo, na jaya'a ndo nda ma kamixa nuu na ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ta nda ndian nikuuni ña chìkan iin nakuyi nuu ndo, na ku'va ndo yi nuu na. Ta juuni tu ìyo iin yo kì'in iin ña ìyo nuu ndo, na ndäkan ga ndo yi nuu na. ");
INSERT INTO mza_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na ja'a ndo chi'in ma inga na, ma naja kua kùuni ndo ña ja'a na chi'in ndo ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ta tu ndyo'o kùuni ndo nde'e ndo ma ndian kùuni nde'eni ndo, ¿nda tiñu ka'nu kùu ma ña jà'a ndo, tuva nda ma ndian ìyo kuati, juuni jà'a na yi ndia? ");
INSERT INTO mza_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ta tu jà'a ndo iin ña va'a kuenda ma ndian kùuni nde'eni ndo, ¿nda tiñu ka'nu kùu ma ña jà'a ndo, tuva nda ma ndian ìyo kuati jà'a na yi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ta tu jaya'a nuu iin nakuyi nuu na va tu chìto ndo ña ni ku'va ndiko na yi nuu ndo, ¿nda tiñu ka'nu kùu ma ña jà'a ndo, tuva nda ma ndian ìyo kuati juuni takan chà'a nuu na yi nuu ma ñivi na ña indukuni kùu takua kùu na, vati chìto na ña ni ni'i ndiko na yi ndia?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Va ndyo'o ìyo yi ña kuuni ndo nde'e ndo ma ndian xaani nde'e ndo, ta jà'a ndo ña va'a kuenda na, ta ku'va nuu ndo ndatiñu ndo nuu na. Ta tüvi ìyo yi ña kuatu ndo ña jachikoni'i ndiko na yi nuu ndo. Tu jà'a ndo takan, tajan ni ni'i ndo iin ya'vi ka'nu, ta ni kuu ndo ndian se'e ma Ndioo ka'nu, ña ìyo nuu sukun. Vati rakan juuni jà'a ra ña va'a kuenda ndian kini, ta kuenda ma ndian tüvi jàchi'in ña kà'an ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yakan va na kunda'vini ndo ñivi, takua kùnda'vini ma Racha'nu Tatá yo yo. ");
INSERT INTO mza_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Na kä'an ndaa ndo chata inga ñivi, ikan na töve ka'an ndaa Racha'nu Ndioo chata ndo. Ta na tïsokuati ndo inga ñivi, ikan töve tisokuati Ndioo ndo ndia. Ta na jaka'nuni ndo kuati ma ñivi, ikan na jaka'nuni Ndioo kuati ndo ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ta na ku'va ndo ña ìyo nuu ndo nuu inga ñivi, ta Ndioo ni ku'va ra ña ìyo nuu ra nuu ndo ndia. Vati kua tìndee ndo ma ñivi, kua ikan ni tindee ma Ndioo ndo ndia. Ta takua jà'a ndo ña chà'a ndo ña chiniñu'u ñivi, juuni takan ni ku'va ra ña chiniñu'u ndo ndia. Va ma ña ni ku'va Ndioo nuu ndo nduva'a kuii va'a yi. ");
INSERT INTO mza_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Takan kūu ta ora chīnu kā'an Jesuu takan, tajan te'en nāka'an tuku ra iin ku'va nuu na: ―¿A kùu jana'a iin ra kuaá iti' ku'un inga ra kuaá tuva ninduvi ta'an ndra kuaá? ¿A tüvi ni kakuita ninduvi ndra tichi iin yavi kunu?, kuuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yakan va nï'iin ndian jàkua'a chi'in iin matru, na küu chaa na kùu na ndian ka'nuga kua maa ra. Kùu chaa na kùu na ma kua ikan, va ji'na ìyo yi ña jachinu na ma ña kùuni ra, tajan kùu, kùu na takua kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Ta naja jà'un kuenda ma iin kuati vali ña jà'a ma inga ñivi, ta töve jà'un kuenda ña ìyo kuati ka'nugaun kua ndiakan? ");
INSERT INTO mza_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ta tu töve chà'un kuenda ma kuati ìyo juuni chi'in maun, ¿ta naja kà'un chi'in inga ñivi te'en: “Yo'o yani, jaya'a ña na tavai ma kuati vali ña ìyo chi'un”?, tuva takan. ¡Ndyo'o ndian ìyo uvi nuu! Tüvi nda kuenda ma ña kà'un tuva juuni maun ìyoga kuatiun ta tüvi chà'un kuenda. Yakan va na ja'a ji'naun kuenda ma kuati ña ìyoun, ta takan kùu ja'un kuenda ma kuati vali ña jà'a inga ñivi ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Nï'iin ma yutun va'a, na küu ku'va ndrun ma chiti ña tüvi va'a. Ta ni ma yutun ña tüvi va'a, na küu ku'va ndrun ma chiti va'a ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vati ta'ii'iin ma yutun, nàkoto yo ndrun cha'a' ma chiti ña chà'a ndrun. Ta juuni na küu ku'va iin yutun iñu ma chiti yutun higu. Ta ni ma iñu ndu'va na küu ku'va yi chiti yutun ña nàni uva ndia. ");
INSERT INTO mza_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ta ma ra'ii va'a, kà'an ra tu'un va'a, ti ña va'a kùu ma ña ìyo tichi anima ra. Ta ma ra kini, kà'an mamaa tu'un kini, ti ña kini kùu ma ña ìyo tichi anima ra. Vati ma ña ìyo tichi anima ra kùu yi ña va'a a ña kini chà'a yi kà'an ra yi iti' yu'u ra. ");
INSERT INTO mza_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Takan kūu tajan te'en chīkatu'un tuku ma Jesuu nuu na: ―¿Ta naja “Racha'nu, Racha'nu” kà'an ndo yu'u, ta töve jà'a ndo ma ña kà'in chi'in ndo? ");
INSERT INTO mza_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nda ndian nikuuni ña tàndikun chatai, ta tàso'o na ña kà'in, ta jà'a na yi, ndiakan kùu na indukuni takua kùu ma ra ni jana'i nuu ndo vitin: ");
INSERT INTO mza_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ndiakan indukuni kùu na takua kùu iin ra labañi ña jà'a ve'e, ña ji'na chāta kunu ra nuu ni ja'a ra yi, tajan jā'a ndio ra ma cha'a yi chata ma yuu. Ta ora kūun kua'a' savi, ta nduva'a kuii chā'nu ndio ma yuta, ta vaji chàñu ni'i ra ma cha'a ve'e, va töve ni nduva yi, ti va'a jā'a ra cha'a yi ma chata yuu. ");
INSERT INTO mza_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Va ma ndian chìni ña kà'in, ta töve jàchi'in na yi, indukuni kùu na takua kùu ma ra labañi ña jā'a ra ve'e ra nuñu'uni, ña tüvi nī chata ra nuu jā'a ra cha'a yi. Tajan ora nduva'a kuii chā'nu ndio ma yuta, ta chāñu ni'i ra cha'a yi, ta endee ndī'i yi kèkoyo jā'a ra'. ―Takan kà'an Jesuu chi'in ma ñivi, ikan na ku'va na kuenda, ta jachi'in na ma ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Takan kūu ta ora chīnu kā'an ra nuu ma ñivi, tajan kēe ndio ra kuà'an ra ñuu Capernaum. ");
INSERT INTO mza_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ta ma ñuu ikan, ìyo iin ra capitán chà'nda tiñu nuu ndra jandaru ñuu Roma. Ta rakan ti, ìyo iin ra kùu musu ra ña ya'a kùuni ra nde'e ra, ña chani kuvi ra jà'a ña nduva'a ku'vi ra. ");
INSERT INTO mza_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tajan ora chīto ndio ma ra capitán ña jà'a Jesuu, ta tāchi ra uvi uni ma ndracha'nu kuxini nuu ñivi judíu, na ku'un ndra kundakan ndra ñamani nuu Jesuu, ña na kichi janda'a ra ma musu ra. ");
INSERT INTO mza_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tajan ora chāa ndio ndra nuu ndaa Jesuu, ta te'en kīcha'a kà'an ndra chi'in ra ña jànini ndra ra: ―Chìkan ndi ñamani nuu̱n, ña na ku'u̱n kutindeun ma ra capitán ñuu ndi, ti iin ra ya'a iñu'u kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Vati ya'a kùuni ra nde'e ra yo chi'in tandi'i ñivi yo ña ìyo ñuu yo. Ta juu ra jā'a ña kūva'a ma veñu'u ñuu ndi vitin ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tajan kēe ndio Jesuu kuà'an ra chi'in ndra, va ora chani kuyatin ndra nuu ndaa ma ve'e ra, ta tāchi ndio ma capitán iin ndra meru ra, ña na kukatitu'un ndra te'en nuu Jesuu: ―Yo'o Racha'nu, na küxaun cha'a' ña tāchi ma capitán ndi, ña na kichi katitu'un ndi nuu̱n, ña na kü'u̱n ma ve'e ra, vati tüvi ìyo yi ña ki'viun, ni ma ve'e ra, ti iin ra nda'vini kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yakan va cha'a' yakan kùu yi, ña nī kuuni ra kichi maa ra ka'an ra chi'un, ti ndyu'uni tāchi ra ña na ka'an ndi chi'un ña na janda'un ma musu ra chi'in tu'un yu'uniun nda ma nuu ndaun nde'veni. ");
INSERT INTO mza_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Vati rakan kùu ra capitán, ta juuni ìyo iin ra chà'nda tiñu nuu ra, ta juuni ìyo jandaru ra ña chà'nda ra tiñu nuu ndia. Yakan va tu ka'an ra chi'in iin ra chà'nda ra tiñu nuu, “kua'an”, ta ku'un ra. Ta ora kà'an ra chi'in inga ra, “na'a”, ta vàchi ra. Ta ora tàchi ra ma ra musu ra ña na ja'a ra iin nakuyi, ta jà'a ra yi. ―Takan kāti ma ndra meru ma ra capitán nuu Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ta ndava kuà'an anima Jesuu ora chīni ra ña kā'an ndra takan, tajan chīkonuu Jesuu ndē'e ra ndian chàkunuu chata ra, ta te'en nāka'an ra chi'in na: ―Ndicha va'a ña kà'in chi'in ndo ña, ni ma ñuu Israel takä'an nata'in iin ndian ya'a chìnuni takua chìnuni rakan ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ta ora kēe ndiko ma ndra meru ma capitán kuà'an ndra ve'e ra, ta nāta'an ndra ma ra kùu musu ña cha ndā'a ra. ");
INSERT INTO mza_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ta ora yā'a ña kūu te'en, tajan kēe Jesuu kuà'an ra iin ñuu nàni Naín, chi'in ndra jàkua'a chi'in ra, ta chi'in inga kua'a' ñivi ña chàkunuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Takan kūu ta ora cha kūyatin Jesuu ma yu'u ñuu, ta ikan ndē'e ra ña kuàkuchi na iin ra chì'í. Ta rakan ti, iin ra se'e ña kìndonda'vi kùu ra. Ta uvanuu ra kùu ra ña kùu ra se'an. Ta nduva'a kua'a' ñivi ìyo ma ñuu ikan kuà'an chi'an ndia. ");
INSERT INTO mza_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ta ora ndē'e Jesuu ña, ta kūnda'vini ra ña, ta te'en nāka'an ra chi'an: ―¡Na kuäku̱n! ―kàti ra chi'an. ");
INSERT INTO mza_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tajan chājayatin ndio ra ra nuu kuà'an ma ñunda'yu, ta kē'e ra ma chatun ikan. Ta chūndaa ndio ma ndra ndiso yi. Ta te'en nāka'an ndio ma Jesuu chi'in ma ra chì'í: ―Yo'o xaa, yu'u kà'an chi'un ña na nandotoun ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tajan ma ora ikani nāndoto ndio ma ra chī'í, ta chūnandi ra, ta kīcha'a ra kà'an ra. Tajan chā'a ndio Jesuu ra nuu ma ma'á ra. ");
INSERT INTO mza_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ta ora ndē'e na ña jā'a Jesuu, ta ndisaa na yū'vi na, ta te'en kīcha'a ndio na kà'an na ña jàka'nu na Ndioo: ―Ndicha kuii, ña ra'ya kùu iin ra ya'a ka'nu ña kà'an chi'in tu'un yu'u Ndioo. Ta vitin cha kēta ra tañu yo. Ta ìyo inga ndian kà'an te'en ndia: ―Ndioo cha kīchaa ra kuenda ña tìndee ra ñivi ra ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Takan kūu ta ninii ñu'u' Judea, ta inga tuku ñuu kuati ña kàndii yatini xiin yi chīto na ña jā'a Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ta numini chīto Xuva ra jàkunduta ña jā'a Jesuu, vati ma ndra chàkunuu chi'in ra kātitu'un nuu ra. Tajan kāna ndio ra uvi ndra, ");
INSERT INTO mza_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ta tāchi ra ndra, ña na kundakatu'un ndra nuu Jesuu, nde'o tu ndicha ña juu ra kùu ma Cristu, ra ìyo yi ña ni kichi kuenda Ndioo, a ìyo yi ña kuatu ndra inga ra, kàti Xuva chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tajan ma ndra tāchi Xuva, chājayatin ndra ndra nuu Jesuu, ta te'en chīkatu'un ndra nuu ra: ―Xuva ra jàkunduta, tāchi ra ndi, na kichi ndakatu'un ndi nuu̱n, nde'o tu juu̱n kùu ma ra Cristu ña ìyo yi ña ni kichi kuenda Ndioo, a ìyo yi ña kuatu ndi inga ra, kàti Xuva chi'in ndi ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tajan juuni ma ora chīkatu'un ndra takan nuu Jesuu, nduva'a kuii kua'a' ñivi jānda'a ra chi'in tundo'o ndo'o na. Jānda'a ra ndian ku'vi ndiso tati xaan, ta juuni jānda'a ra kua'a' ndian kuaá ndia. ");
INSERT INTO mza_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Takan kūu tajan te'en nāka'an ndio Jesuu chi'in ma ndra jàkua'a chi'in Xuva: ―Kua'an ndo, ta katitu'un ndo nuu Xuva ma ña ndē'e ndo, ta chīni ndo. Na kati ndo nuu ra ña ma ndian kuaá, kùu nànde'e na, ta ma ndian koxo kùu chìka va'a na, ta juuni ndà'a ndian ndo'o kue'e ta'yu, ta nda ma ndian so'o, chìni na, ta ndian cha chī'í nātaku na, ta ma ndian nda'vi chìni na ma tu'un ña jàna'a naja kua ni jakakú Ndioo na. ");
INSERT INTO mza_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ta juuni na sii kuuni ma ndian töve jàchiyo na na ma iti' kuà'in ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Takan kūu ta ora kēe ndio ma ndra jàkua'a chi'in Xuva kuà'an ndra, tajan te'en kīcha'a ndio Jesuu kà'an ra cha'a' Xuva nuu ma ñivi: ―¿Yo chā'an ndo chānde'e ndo tichi ku'u ora chā'an ndo?, kùuni ndo. ¿A chānde'e ndo iin ra kàa takua kàa ma tuyoo, ña ora chàkin ni'i tati, ta ndùva yi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tu yüvi takan kùu yi, ¿yo chānde'e ndo tuva takan? ¿A chānde'e ndo iin ra ñù'u iin ja'ma va'a ña ya'a vii kàa?, kùuni ndo. Na yüvi takan kùu yi, ti ma ndian chāku'un ja'ma kàa takan, ta ìyo kuika na, ndiakan ìyo na ve'e ra kùu rey ta yüvi tichi ku'u. ");
INSERT INTO mza_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yakan va, ¿nda ra kùu ma ra chānde'e ndo tuva takan? ¿A iin ra kà'an chi'in tu'un yu'u Ndioo kùu ra?, kùuni ndo. Juu ndicha kuii ña, rakan kùu iin ra ka'nuga kua inga ma ndra kà'an chi'in tu'un yu'u Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta juu ma Xuva kùu ma ra ña te'en kà'an ma tutu Ndioo cha'a': Yu'u, ni tachi̱ iin ra jà'a tiñu nui iti' nuu̱n, ikan na jandova'a ra ma itiun, kàti yi. ");
INSERT INTO mza_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yakan va yu'u kà'in chi'in ndo, ti tañu ma ñivi ìyo ñuñivi, takä'an keta iin ra kà'an chi'in tu'un yu'u Ndioo ña ka'nuga kua Xuva. Va taku ma ra ìyo nuu chà'nda Ndioo tiñu, rakan ka'nuga ra kua Xuva, vaji ma ra nuu ndi'inia kùu ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Takan kūu ta ndisaa ma ñivi, ta chi'in ndra nàka'an xu'un' kuenda ñuu Roma, ora chīni na ña kā'an Jesuu, ta kūtunini na ña Ndioo kùu ra iin ra ndaa. Ta ndiakan cha jāña na ña jākunduta Xuva na niku. ");
INSERT INTO mza_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Va ma ndra fariseu, chi'in ndra matru jàkua'a tutu Ndioo, java jāchiyo ndra ndra nuu ma ña kùuni Ndioo ña jà'a ndra, ta töve nī cha'a ndra ña jàkunduta ma Xuva ndra. ");
INSERT INTO mza_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ta te'en chīkatu'un Jesuu: ―¿Yo chi'in kùu jando indukui ma ñivi ìyo ma tiempu i'ya? ¿A yo indukuni kàa takua kàa na?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kùu na indukuni kua ma ndiakuati, ña ora chūnandi na chìta na nuu ya'vi, ta kànachaa na meru na chi'in tu'un i'ya: “Tīvi ndi chi'in tuvilu nuu ndo, ta tüvi nī kuuni ndo tacha'a ndo, ta chīta ndi yaa nda'vi nuu ndo, ta tüvi nī kuuni ndo kuaku ndo.” ");
INSERT INTO mza_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Takan kùu ndo, ta ora kīchaa ndio Xuva ra jàkunduta, ra tüvi chàchi, ta tüvi chì'i vinu, ta kà'an ndio ndo ña ra ndiso tati xaan kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ta ikan jan, kīchi ndio ma ra Se'e ñivi tāchi Ndioo, ta rakan ti ra chàchi, ta chì'i kùu ra. Ta cha'a' yakan kùu yi ña kàti ndo ña iin ra jà'a kuati kùu ra, ta iin ra ya'a chàta'ani ko'o kùu ra, ta meru ra kùu ma ndian tivi xini chi'in ma ndian ña nàka'an xu'un' kuenda ñuu Roma, kàti ndo. ");
INSERT INTO mza_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Va ma ndian cha chìto ki'vi iti' va'a, numini cha'a' yo kuenda ña chìnituni Ndioo kùu ma ña ìyo chi'in na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tajan iin ra fariseu jāinvitaa ra Jesuu ña na ku'un ra kukachi ra ve'e ra. Ta ora cha nàndi ra chàchi ra nuu mesa, ");
INSERT INTO mza_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ta iin ña tondo ìyo ma ñuu ikan, ora chītoan ña Jesuu kuàkachi ra ve'e ma ra fariseu, juuni ma ora ikani kāvanda'a ña iin viru takuii xiko, ña ya'a ya'vi ndaa, ta kuà'an ña ve'e ma ra fariseu nuu ndaa Jesuu. Ta ora chāa ña ikan nuu ndaa Jesuu, ");
INSERT INTO mza_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ta ndaa ña chàkuan yatini nuu ndaa ra, ta kīcha'a too ma takuii tinuan cha'a ra, tajan chūnandi chitian cha'a ra, ta kīcha'a ndioan jànatian yi chi'in ixi xinian. Ta tūtuan yi, ta jākuti ndioan takuii xiko yi. ");
INSERT INTO mza_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Takan kūu ta ma ra fariseu, ra jāinvitaa Jesuu, te'en kīcha'a ra chànini ra ña jà'a ña takan chi'in Jesuu: “Tuva ndicha ña ra kà'an tu'un Ndioo kùu ra, ¿ta naja tüvi chà'a ra kuenda ña ña tondo kùu ma ña kè'e ra?” Takan chànini ra. ");
INSERT INTO mza_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tajan te'en nāka'an ndio Jesuu chi'in ma ra fariseu: ―Yo'o Simón, ìyo iin ña kùuni ka'in chi'un ―kàti ra. Tajan te'en nāka'an ma ra fariseu: ―Yo'o Matru, ka'an yi nui tuva takan ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tajan te'en nāka'an ndiko Jesuu chi'in ra: ―Chīyo uvi ra'ii, ndra tàvi xu'un' nuu iin ra chà'a nuu xu'un'. Iin ra tàvi xu'un' ña jàkanaa ra iin kuiya java, ta inga ra tàvi xu'un' ña jàkanaa ra uvi yoo. ");
INSERT INTO mza_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ta takua küu ka'nda ndra kuenda nuu ma ra chā'a nuu xu'un' nuu ndra, yakan va jāka'nuni ra ndra cha'a' ma xu'un' tàvi ndra nuu ra. Ta vitin kùuni̱ ña katitu'u̱n nui, ¿nda ra kùu ma ra kùuni ga ra nde'e ra cha'a' ma ña jā'a ra?, kùuniun. ");
INSERT INTO mza_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tajan te'en nāka'an ndio Simón chi'in Jesuu: ―Yu'u chànini ti ma ra tàvi tiá xu'un' nuu ra, rakan kùu ma ra kùuniga ra nde'e ra ―kàti ra. Tajan te'en nāka'an Jesuu chi'in ra: ―Ña ndicha kùu ma ña kā'un ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tajan iin cha'ani nuu Jesuu ndē'e ra nuan, tajan te'en nāka'an ndio ra chi'in Simón: ―¿A ndè'un ña ndaa i'ya? Nda che'e kī'vi̱ tichi ve'un ta tüvi nī cha'un takuii ña nàkatai cha'i, ta ña ndaa i'ya ti nākata ña cha'i chi'in takuii tinuan ta jānatian yi chi'in ixi xinian. ");
INSERT INTO mza_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Taku yo'o tüvi nī tutu̱n yu'u ora kīchai ña kàña'i chi'un, va ña ndaa i'ya endee tüvi jàña ña ña tùtuan cha'i nda ora kīchai ve'un. ");
INSERT INTO mza_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tüvi nī taun cete xini̱ ora kīchai, va ña ndaa i'ya, jākutian takuii xiko chata cha'i. ");
INSERT INTO mza_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yakan va cha'a' ña'a, va kà'in chi'un ti vaji ìyo kua'a' kuatian, va jànaa Ndioo yi cha'a' ña kùunian nde'an ra, va ma ndian chànini ña töve kua'a' kuati na, ta juuni töve chà'a na ña janaa Ndioo ndisaa yi, ndiakan töve kùuni va'a na nde'e na ra. ");
INSERT INTO mza_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Takan kūu tajan te'en nāka'an Jesuu chi'in ma ña'a: ―Cha nàa ma kuatiun vitin ―kàti ra chi'an. ");
INSERT INTO mza_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Takan kūu ta inga ma ndra kàchachi ka'ìin chi'in Jesuu te'en kīcha'a ndra nàtu'un ta'an ndra: ―¿Nda ra kùu ra'ya ña nda kuati ñivi kùu janaa ra? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Takan kūu tajan te'en nāka'an tuku Jesuu chi'in ma ña'a: ―Na ku'un va'un ve'un ti cha'a' ña chìnuniun, yakan va cha kākún. ―Takan kàti Jesuu chi'an. ");
INSERT INTO mza_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Takan kūu ta ora yā'a ña kūu takan, tajan kēe ndio Jesuu kuàkakunuu ra kua'a' ñuu chi'in kuariya ña kuàkatitu'un ra naja kua kàa nuu chà'nda Ndioo tiñu, chi'in ndi uchi uvi ndra tatun ra. ");
INSERT INTO mza_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ta juuni kàcha'an uvi uni ñivi ña'a ña tàvani'i Jesuu tati xaan chi'in inga tuku kue'e ña ndo'o vi. Ta tañu ma ñivi ikan, kuà'an Ndiya, ña nàni Magdalena, ña tāvani'i Jesuu ucha tati xaan, ");
INSERT INTO mza_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ta juuni ikan kuà'an Juana ñasi'i ra nàni Chuza, ra jā'a tiñu nuu Herode niku, ta Susana chi'in inga tuku ñivi ña'a ña tìndee Jesuu chi'in ndatiñu ña ìyo nuu vi ndia. ");
INSERT INTO mza_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Takan kūu ta nduva'a kuii kua'a' ñivi kīchi nani ñuu kūti'vi na nde'e na Jesuu. Ta ikan jan te'en kīcha'a ra kà'an ra iin ku'va nuu na: ");
INSERT INTO mza_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Ìyo iin ratàchi. Ta rakan ti kēe ra kuàtachi ra chiti trigu. Ta ma nuu chōso ra yi ìyo chiti kōyo tichi iti'. Ta chiti ikan chāñu na yi, tajan nūu ndio ma saa ta chāchi ndi'i ndri yi. ");
INSERT INTO mza_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ta inga ita'vi yi kāchita yi tañu yuu. Ta ora kāna yi ta ndī'i yi nàtii ti tüvi kàchin ma nuu ndaa yi. ");
INSERT INTO mza_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ta inga ita'vi ma chiti kāchita yi tañu iñu, ta ora kāna yi, jāvati ma iñu ndu'va nuu yi, yakan va nī kuu kua'nu yi ta chī'í yi. ");
INSERT INTO mza_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Va inga ita'vi yi kāchita yi iin nuu va'a ñu'u' ta chiti ikan va chā'nu va'a yi ta nduva'a kuii kua'a' chiti chā'a yi. Ndisaa yakan kātitu'un Jesuu nuu na. Takan kūu tajan te'en nāka'an ni'i ra nuu ma ñivi inga cha'a': ―¡Ma ndian chìni ña kà'in na taso'o na! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Takan kūu tajan te'en chīkatu'un ndio ma ndra tatun Jesuu nuu ra nayi kùuni ma ku'va ikan ka'an yi. ");
INSERT INTO mza_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Nuu ndyo'o, chà'a Ndioo ña na koto ndo tu'un xe'e ña ìyo chi'in ra nuu chà'nda ra tiñu, va chi'in inga ñivi kà'in yi chi'in mamaa ku'vani, ikan vaji najaga nande'e na va tüvi ndichin nuu na, ta vaji najaga kuni na ma ña kà'in, va na küu kutunini na yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Takan kūu tajan te'en nāka'an ndio Jesuu nayi kùuni ma ku'va ikan ka'an yi nuu ndra: ―Ma chiti ikan kùuni yi ka'an yi ña kùu yi takua kùu ma tu'un Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ta ma chiti kōyo tichi iti', yakan kùuni yi ka'an yi ma ndian chìni tu'un Ndioo. Ta ikan jan vàchi ndio ma kui'na ta jànaa ma tu'un Ndioo ña cha ìyo anima na, ikan na töve chìnuni na ta töve kàkú na. ");
INSERT INTO mza_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ta ma chiti kōyo tañu yuu kùuni yi ka'an yi ña ma ndian chìni tu'un kà'in ya'a sii kùuni na ora nì'i na yi. Ndiakan kùu na takua kùu ma chiti ña kōyo tañu yuu ña töve nì'i va'a yi nuu kunu ma yo'o yi jà'a ma yuu. Yakan va ndiakan chìnuni na ma tu'un Ndioo tia tiempuni. Tajan kēta ndio iin kivi ña na kündeega na jachi'in na ma ña kà'an yi, ta ndākoo ndiko na yi. ");
INSERT INTO mza_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ta ma chiti kōyo tañu iñu, kùuni yi ka'an yi ña ndiakan kùu ma ndian chìnuni tu'un Ndioo. Va kueeni kueeni jàña na ña chìnuni na tiá cha'a' ma ndatiñu ña ìyo ma ñuñivi i'ya, ta juuni ya'a chìtu'un na cha'a' ma xu'un' ta naja kua kuu kakusii na chi'in ña töve va'a, ti kùuni na ndokuika na. Yakan va takan kùu ma chiti ikan, ti töve chā'a yi chiti jā'a ma ña vati. ");
INSERT INTO mza_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Va ma chiti kōyo iin nuu ñu'u' va'a, kùuni yi kà'an yi ña ndiakan kùu ma ndian chìnuni tu'un Ndioo chi'in ndisaa anima na, ta jàchi'in na ma ña kà'an yi. Yakan va ndiakan kùu na takua kùu ma chiti ña chā'a kua'a' va'a chiti, ta töve jàxiin na na ma iti' Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Nï'iin ñivi tüvi taa na ñu'ú kandil ta kasi na nuu yi chi'in iin kisi ñu'u' a kutaa xe'e na yi xuu iin chito, ti ndisaa ñivi kùtaa na yi iin nuu sukun, ikan na ndondichin nuu na ndian kuànde'e nuu ìyo na. ");
INSERT INTO mza_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yakan va nï'iin nakuyi ña töve kìndoo xe'e, ti ni keta yi nuu nuna, ta ni chaa iin kivi ña ni koto kachin ndi'i na yi ndia. ");
INSERT INTO mza_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Yakan va na taso'o va'a ndo ña kà'in chi'in ndo. Vati ndian ìyo yi nuu, tiá kua'a' yi ni koo nuu na. Va ndian tükuii nakoo nuu, a ña chànini na koo nuu na, ni kindaa Ndioo yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Takan kūu tajan chāa ma'á Jesuu chi'in ndra yani ra ta ñivi ta'an ra ma ve'e nuu ndaa ra jàna'a ra. Va takua nī kuu jayatin vi vi nuu ndaa ra, ti ya'a kua'a' ñivi ka'ìin. ");
INSERT INTO mza_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yakan va kà'an vi chi'in iin ra ndaa ma ikan, na kuka'an ra chi'in Jesuu. Tajan te'en chā'an ra chāka'an ra chi'in Jesuu: ―Nuke'e ndaa ma'un chi'in ndra yaniun ta ñivi ta'un ña nànduku vi ñu̱n ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tajan te'en nāka'an ndio Jesuu: ―Ma ndian chìni tu'un Ndioo ta jàchi'in na ña kà'an yi, ndiakan kùu ma ma'i chi'in ndra yani̱ ta ñivi ta'in ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iin kivi kī'vi Jesuu chi'in ndra jàkua'a chi'in ra tichi iin lancha. Ta ora cha ka'ìin ndio ndra tichi run, tajan te'en nāka'an ra chi'in ndra: ―Na ko'o inga chiyo lakuna ―kàti ra. Tajan kēe ndio ndra kuà'an ndra. ");
INSERT INTO mza_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Takan kūu ta ora cha kàcha'an ndio ndra nuu lakuna tajan tīin ndio ñuma'na Jesuu, ta kīxi ra. Ta juuni ma ora ikan nduva'a kuii kōyo savi tati chata ndra nuu ma lakuna. Ta ikan jan kīcha'a ndio ma takuii kì'vi ra tichi lancha ndra. Yakan va yū'vi ndra ti koto sa'vi run chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Takan kūu tajan jāndakoo ndra Jesuu chi'in tu'un i'ya: ―¡Matru! ¡Matru! Chani ka'a yo ―kàti ndra chi'in ra. Tajan ndākoo ndio Jesuu ta ndōxaan ra nuu ma savi tati chi'in lakuna, tajan kūtaxin ndio yi. ");
INSERT INTO mza_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Takan kūu tajan te'en nāka'an ndio ra chi'in ma ndra jàkua'a chi'in ra: ―¿Ta naja takä'an chinuni ndo ña yu'u kùu tindei ndo? ―kàti ra chi'in ndra. Takan kūu ta ndrakan ti ndava kuà'an anima ndra ña ya'a ndasii ndra. Tajan kīcha'a ndra chìkatu'un ta'an ndra chi'in juuni maa ndra: ―¿Nda ra kùu ra'ya ña nda savi tati chi'in lakuna jàchi'in ña kà'an ra? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Takan kūu tajan kētachiyo ndra inga chiyo yu'u lakuna, ta chāa ndra ñu'u' Gerasa ña kàndii iti' nuu ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tajan ora nūu ndio Jesuu ma tichi lancha, ta ikan cha jāyatin iin ra ndiso tati xaan nuu Jesuu ña kēe ra ma tichi ñuu ikan. Ta rakan ti cha ìyo kua'a' tiempu ña tüvi ìyo ra iin tichi ve'e ta ni tüvi chàku'un ra ja'ma. Ta ìyo ra kamajandu. ");
INSERT INTO mza_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tajan chājayatin ndio ra ra nuu vàchi Jesuu, ti cha nākoto ra ra, tajan iin nanda'yu ni'i ni ra, ta te'en nāka'an ra ora chūnandi chiti ra nuu Jesuu: ―¡Na kï'viun chi'i̱n, yo'o Jesuu ra Se'e Ndioo ra ìyo nuu sukun! Ta juuni kà'in chi'un ña na jände'un tundo'o yu'u ―kàti yi chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Takan kāti yi chi'in Jesuu ti kāti ra chi'in yi ña na kee yi tichi kuñu ra. Vati nduva'a kuii cha kua'a' kivi kùu yi ña ìyo yi tichi kuñu ra, ta vaji chi'in karena chù'ni na nda'a' ra ta cha'a ra, ikan na küu ku'un ra, kùuni na, va na küu yi ti ndì'i yi chà'nda ra ta jà'a ndio yi ña na kunu ra ku'un ra tichi ku'u. ");
INSERT INTO mza_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Takan kūu, tajan te'en chìkatu'un ndio Jesuu nuu ma ra ndiso tati xaan: ―¿Naja kuànaniun? ―kàti ra. Tajan te'en nāka'an yi: ―Nàni ndi Legion, vati kua'a' tati xaan kùu ndi ña ìyo ndi tichi kuñu ra'ya ―kàti yi. ");
INSERT INTO mza_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tajan chīkan ndio yi ñamani nuu Jesuu ña na ja'a ra ñamani ña na tächi ra yi ñuñivi nuu ìyo ndian ndií. ");
INSERT INTO mza_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Takan kūu ta takua ka'ìin kua'a' kini ña kàchachi ndri yatini ma yuku ikan, tajan chīkan ndio yi ñamani nuu Jesuu na ku'va ra ki'vi yi tichi kuñu ndri. Tajan kāti ndio Jesuu ña va'a. ");
INSERT INTO mza_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tajan kēe ndio ma tati xaan tichi kuñu ra, ta kī'vi yi tichi kuñu ma kini. Ta ndrikan kāndakunu ndri kàcha'an ndri ta kàchita ndri iin xa'va ña ìyo yu'u lakuna. Ta ikan kā'a ndri tichi ma takuii, ta chī'í ndri. ");
INSERT INTO mza_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ta ma ndra kùmi ma kini, yū'vi ndra ora ndē'e ndra ña kūu takan, tajan kāndakunu ndio ndra kuàkatitu'un ndra nuu ma ñivi ìyo ñuu chi'in ndian ìyo kuariya. ");
INSERT INTO mza_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Takan kūu tajan kēe ndio ma ñivi chānde'e na ma ña tā'an ma kini. Ta ora chāa ndio na nuu ndaa Jesuu, ta ikan ndē'e na ña nàndi ma ra ndiso tati xaan niku nduku iti' cha'a Jesuu ña isukun ra ja'ma. Yakan va nduva'a kuii yū'vi na ora ndē'e na ra. ");
INSERT INTO mza_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ta ma ndian ndē'e ma ña kūu, ndiakan kātitu'un na naja kua ndā'a ma ra ndiso tati xaan nuu inga ñivi. ");
INSERT INTO mza_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Takan kūu ta tandi'i ma ñivi ìyo ñu'u' Gerasa, kīcha'a na jànini na Jesuu ña na kee ra ma ñu'u' ikan, vati ya'a yū'vi na ña ndè'e na ma ña jā'a ra. Yakan va ndāa ndio Jesuu ma tichi lancha ta kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ta ma ra kēe ma tati xaan chīkan ra ñamani nuu Jesuu, na ku'va ra ña ku'un ra chi'in ra. Va Jesuu tüvi nī cha'a ra ña ku'un ra chi'in ra. Tajan te'en nāka'an ndio ra chi'in ra: ");
INSERT INTO mza_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Na ku'u̱n ve'un, ta katitu'u̱n ma ña jā'a Ndioo chi'un nuu ma ñiviun. Takan kūu tajan kēe ndio ra kuà'an ra, ta kātitu'un ra nuu ma ñivi ñuu ndisaa ma ña jā'a Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Takan kūu ta ora ndīkoni'i ndiko Jesuu ma inga chiyo yu'u lakuna, ta maani cha ka'ìin kua'a' ñivi ndàtu na ra. Ti ndiakan ya'a chìsii na ña vàchi ra. ");
INSERT INTO mza_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ta juuni ma ora ikan, chāa iin ra nàni Jairo. Ta rakan ti iin ra kùu vika ma veñu'u ñivi judíu kùu ra. Tajan rakan chūnandi chiti ra cha'a Jesuu ña chìkan ra ñamani nuu ra, ña na ku'un ra chi'in ra nuu ìyo ve'e ra, ");
INSERT INTO mza_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ti ikan kàndii ñase'e ra ña uchi uvi kuiya, ña ya'a kùuni ra nde'e ra, ti uvaa nuan kùan se'e ra, ña chani kuvian jà'a ma kue'e ndò'an. Yakan va ora kēe Jesuu kuà'an ra chi'in ra, tajan nduva'a kua'a' ñivi tāndikun na chata ra ña ndava tìtuu ta'an na. ");
INSERT INTO mza_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Takan kūu ta tañu ma ñivi ikan, kuà'an iin ña cha ìyo uchi uvi kuiya ña ku'vian jà'a niian. Ta yakan ti cha jānaa ña ndisaa xu'un' kùmian chi'in ma ndra jà'a tatan. Ta nï'iin ndra nī kuu janda'a ña. ");
INSERT INTO mza_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Takan kūu tajan ma ña'a i'ya chājayatian ña iti' chata Jesuu, ta kē'an ja'ma ra, ta juuni ma ora ikani chākuita ña ta'an ña nii, ta ndā'a ña. ");
INSERT INTO mza_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Takan kūu tajan te'en kīcha'a ndio Jesuu chìkatu'un ra: ―¿Yo kē'e ja'mai? ―kàti ra. Ta kàti na ti töve yo kē'e yi. Tajan te'en nāka'an ndio ma Petu' chi'in Jesuu ora nāka'an ma ñivi takan: ―Yo'o Matru, ¿a tüvi ndè'un ti ya'a kua'a' ñivi tìtuu ta'an kàcha'an na xiun? ¿Ta chīkatu'un gaun ña yo kē'e ñu̱n? ―kàti Petu'. ");
INSERT INTO mza_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tajan te'en nāka'an tuku Jesuu: ―Ìyo iin yo kē'e ja'mai ti chā'i kuenda ña kēe ndatui ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tajan ora ndē'an ña na küu kundii xe'an nuu ra kùunian, tajan kīcha'a ña ndayuan ta chāa ña chūnandi chitian cha'a ra. Tajan kīcha'a ña kà'an ña nuu ndè'e ndisaa ma ñivi nda cha'a' kùu yi ña kē'an ma ja'ma ra ta naja kua ndā'a ña jā'a yi ora kē'an ra. ");
INSERT INTO mza_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Takan kūu tajan te'en nāka'an ndio Jesuu chi'an: ―Yo'o se'yu, cha kùu ku'un va'un ti cha ndā'un jā'a ma ña chìnuniun ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ta ni yakan takä'an chinu kà'an ra ora chāa iin ra tatun ña kīchi ma ve'e Jairo, ña te'en kà'an ra chi'in ma ra vika veñu'u: ―Cha chī'í ma ñavali se'un, yakan va nda kuenda ña jàkenaun tiempu ma ra kùu matru. ―Takan kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Va ora chīni Jesuu ma ña kā'an ma ra kùu tatun chi'in ma Jairo, tajan te'en nāka'an ndio Jesuu chi'in ma ra kùu vika: ―¡Na yü'viun! Na chinuniun ma ña jà'i ta nde'un ti ndà'a ma ñase'un ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ta ora chāa Jesuu ve'e ma Jairo, ta kī'vi ra ma tichi ve'e nuu kàndii ma ñachī'í ta kī'vi ra chi'in Petu', Jandiau, Xuva, ta tatá ña ta ma'á ña ndia, ti tüvi nī cha'a ra ña ki'vi inga ñivi chi'in ra nuu kàndian. ");
INSERT INTO mza_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ta ora ndē'e ra ña tandi'i ma ñivi ka'ìin ikan kàchaku na ta nda'vi kùuni na. Takan kūu tajan te'en nāka'an ndio Jesuu chi'in na: ―Na kuäku ndo ti ma ñavali i'ya tüvi nī chi'an ti kìxinian kàndian ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Takan kūu ta ma ñivi ikan java kīcha'a na chàkú ndaani na ña kà'an ra takan, ti ndisaa na cha chìto na ti cha chī'an. ");
INSERT INTO mza_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tajan tīin ndio Jesuu ma nda'a' ña, ta te'en nāka'an ni'i ra chi'an: ―¡Chi'un kà'in yo'o xi'i ña na ndetaun! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tajan ma ora ikani nāndoto ndikoan ta ndēta ña. Ta ikan jan kà'an ndio Jesuu ña na ku'va na ña kachian. ");
INSERT INTO mza_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Takan kūu ta ma tatá ña chi'in ma'á ña ndava yū'vi vi ña jā'a ra takan, tajan kīcha'a kà'an ndio ra chi'in vi ña na kätitu'un vi ma ña jā'a ra nuu nï'iin ñivi. ");
INSERT INTO mza_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iin kivi jākuti'vi Jesuu ma ndi uchi uvi ndra jàkua'a chi'in ra. Ta ikan chā'a ra ndatu ra nuu ndra ña na janda'a ndra tandi'i ndian ndiso tati xaan chi'in tanuu kue'e ndo'o na. ");
INSERT INTO mza_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Takan kūu tajan tāchi ndio ra ndra ña na janda'a ndra ndian ku'vi ta kàtitu'un ndra nuu ma ñivi naja kua kàa nuu chà'nda Ndioo tiñu. ");
INSERT INTO mza_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta ora juuni takäaga kee ndra ku'un ndra, ji'na te'en nāka'an Jesuu chi'in ndra: ―Na künaa ndo nï'iin nakuyi ma iti' kuà'an ndo: ni itin, ni xu'un', ni ña kachi ndo, ni yutun vatun ndo, ta ni ja'ma ña kùsukun ndo. ");
INSERT INTO mza_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yakan va ora chaa ndo ve'e iin ñivi na kindoo ndo ikan nda kati keta ora ku'un ndo inga ñuu. ");
INSERT INTO mza_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tatu ìyo iin ñuu ña töve jàchi'in na ña kà'an ndo, ta töve chà'a na ña kìndoo ndo ve'e na, tiá va'a na kee ndo ma ve'e ikan ta jakisi ndo yuyaka ña ka'ìin ndichan ndo, ikan na koto na ti xaani Ndioo ndè'e ra na chà'a ña töve jàchi'in na ña kàtitu'un ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Takan kūu tajan kēe ndio ndra kuà'an ndra kuàjanda'a ndra ñivi nani kuariya ta kàtitu'un ndra naja kua kuu jakakú Ndioo na. ");
INSERT INTO mza_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tajan chīto ndio rey Herode tandi'i ña jà'a Jesuu. Yakan va ni töva chìto ra nayi chànini ra jà'a ra vati ìyo ndian kà'an ña Xuva, ra jàkunduta, nātaku ndiko ra, ");
INSERT INTO mza_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ta ìyo inga ndian kà'an ña Elía ra kà'an chi'in tu'un yu'u Ndioo taji'na kùu ra, ta tuku na kà'an na ña cha nātaku ndiko inga ra kà'an chi'in tu'un yu'u Ndioo taji'na, kàti na. ");
INSERT INTO mza_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tajan te'en nāka'an ndio Herode: ―¿Nda ra kùu rakan ña kà'an na ña ya'a ìyo ndatu ra, vati Xuva ra jàkunduta, mai tāchi ña na ka'nda ndra sukun ra? ―chànini ra. Yakan va Herode nànduku ra naja kua ja'a ra ta kuu nde'e ra Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Takan kūu ta ora kēta kivi ña chāa ndiko ma ndra tatun Jesuu, ta ikan jan kātitu'un ndra tandi'i ña jā'a ndra nuu ra. Tajan tāvani'i siin ndio Jesuu ndra ña na ku'un ndra chi'in ra iin ñuu nàni Betsaida. ");
INSERT INTO mza_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Va ora chā'a ndio ma ñivi kuenda ña kàcha'an ndra, tajan tāndikun ndio na kācha'an na chata ndra, ta ikan jan ndàkimani ndiko ra na. Ta kīcha'a ndio ra kàtitu'un ra nuu na naja kua kàa nuu chà'nda Ndioo tiñu, ta jānda'a ra ma ndian ku'vi ndia. ");
INSERT INTO mza_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Takan kūu ta ora chani kuna'a tajan chājayatin ndio ma ndi uchi uvi ndra jàkua'a chi'in Jesuu ndra nuu ndaa ra. Ta ndrakan te'en nāka'an ndra chi'in ra: ―Na jandutáun ma ñivi, ikan na ku'un na kunindee na ta kunanduku na ña kachi na iti' kuariya a iin tichi ku'u nuu ìyo ñivi, vati i'ya tükuii na koo kacho ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Maa ndo na ku'va ndo ña kachi na ―kàti ra. Ta te'en nāka'an ndra nuu ra: ―¿Ta naja kua kuu ku'va ndi ma ña kachi na tuva u'un ta'ani paan indii, ta uvi tiaka' ni? ―kàti ndra―. Kùu yi va tuva ndoun kuatun ndi nde've chi'in ma ñivi ta ku'un ndi kujata ndi ña kachi na ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Takan kàti ndra vati ìyo iin u'un mii ndra kùu ndra ña mamaa ndra'ii ni. Takan kūu tajan te'en nāka'an ndio Jesuu chi'in ma ndra jàkua'a chi'in ra: ―Na jakunandi ndo na kuenda uvi xiko uchi na ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yakan va kua ikan jā'a ndra ña chūnandi ndisaa na. ");
INSERT INTO mza_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tajan tīin ndio Jesuu ndi u'un paan ta uvi tiaka', ta nānde'e ra iti' andivi, ta chīkan ra ta'vi Ndioo cha'a' yi, tajan chā'a ndio ra yi nuu ma ndra jàkua'a chi'in ra na nata'vi ndra yi nuu na. ");
INSERT INTO mza_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Takan kūu ña ndisaa na chāchi na nda kati chitu va'a tichi na, ta jākutua na uchi uvi ga tuka chi'in ma ña chàkoso. ");
INSERT INTO mza_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Iin kivi kēsiin Jesuu chi'in ndra jàkua'a chi'in ra ña kuàka'an ra chi'in Ndioo. Ta ikan jan te'en kīcha'a chìkatu'un Jesuu nuu ndra: ―¿Nda ra kùu yu'u kàti ma ñivi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tajan te'en nāka'an ndra chi'in ra: ―Ìyo ndian kà'an ña kùu̱n Xuva ra jàkunduta, ta ìyo ndian kà'an ña kùu̱n Elía, ra kà'an tu'un yu'u Ndioo taji'na, ta juuni ìyo ndian kà'an ña kùu̱n iin ndra kà'an tu'un yu'u Ndioo ña chīyo taji'na, ta iin ndrakan kùu ndra ña nātaku ndiko ndra kàti na. ―Takan kàti ma ndra jàkua'a chi'in Jesuu nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","―Ta ndyo'o, ¿nda ra kùu yu'u?, kùuni ndo ―kàti Jesuu. Ta te'en nāka'an ndio Petu' chi'in ra: ―Yo'o kùu̱n ma ra Cristu ra tāchi Ndioo ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ta ikan jan kātitu'un Jesuu nuu ndra ña na kätitu'un ndra yi nuu nï'iin ñivi. ");
INSERT INTO mza_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tajan te'en kà'an ra: ―Taku yu'u ma ra Se'e ñivi tāchi Ndioo, nduva'a kuii ni nde'e ra tundo'o, ti ni kati ma ndian cha'nu ña ra jà'a kuati kùu ra, chi'in ndra chà'nda tiñu nuu sutu, ta ma ndra matru jàkua'a tutu Ndioo ndia. Ta ndrakan ni ka'ni ndra ra, va tichi uni kivi ni nataku ndiko ra. ");
INSERT INTO mza_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tajan te'en nāka'an tuku Jesuu chi'in ndisaa ma ndian ka'ìin ikan: ―Tu ìyo iin yo kùuni jakua'a chi'i̱n, na jaña na ma ña chànini na ja'a na, ta na tandikun na chatai nani kivi chi'in kruu na, ikan na nde'e na tundo'o takua ni nde'i tundo'o nuu kruu ndia. ");
INSERT INTO mza_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ti ma ndian kùuni koo ñuñivi, töve ni kakú na, va ma ndian kuvi cha'a' tu'un kà'in, ndiakan kùu ma ndian ni kakú ta ni koo na chi'i̱n endeeni. ");
INSERT INTO mza_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ta juuni tüvi nda kuenda yi tu iin ra'ii nì'i ra tandi'i ña ìyo ñuñivi, ta ora kuvi ra, ni ku'un ra endeeni iti' andaya'. ");
INSERT INTO mza_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ta tu ìyo ndian kùkanuu na nde'e na yu'u ta chata tu'un kà'in, nda yu'u ra Se'e ñivi tāchi Ndioo, ni kukanui nde'i ma ñivi ikan ora ni kichaa ndikoi. Ti ma ora ikan ni ndotachai jà'a ndatui chi'in ndatu ma Tatái ta chi'in ndatu tati va'a jà'a tiñu nuu Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yakan va kùuni̱ ña taso'o va'a ndo ma ña ni ka'in chi'in ndo vitin. Ndicha va'a ña kà'in ti ìyo ndian ka'ìin i'ya tüvi ni kuvi na nda kati nde'e ji'na na ña kichaa nuu chà'nda Ndioo tiñu ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Takan kūu ora ya'a una kivi ña kā'an Jesuu takan, tajan kēe ndio ra kuà'an ra iti' yuku chi'in Petu', Xuva ta Jandiau ña kuàka'an ra chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tajan juuni ma ora kà'an ra chi'in Ndioo, jāma ma kua kàa ma nuu ra chi'in ma ja'ma ra, ti ma ja'ma ra nduva'a kuii ndōkuichin yi ta ndōtacha yi. ");
INSERT INTO mza_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tajan kēta uvi ta'an ndra ña nàtu'un ndra chi'in ra. Ta ndrakan te'en nàni ndra: iin ra nàni Moisés ta inga ra nàni Elía. ");
INSERT INTO mza_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ndrakan kùu ndra ña kāvanuu iin ña nduva'a kuii tàcha ndra. Ta ikan jan kīcha'a ndra kà'an ta'an ndra naja kua ni kuvi Jesuu ta ni nde'e ra tundo'o ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ta vaji nduva'a kuii ni kusu Petu' chi'in ndra meru ra, va jāndeeni ndra ma ñuma'na. Yakan va ndē'e ndra ma ña tàcha Jesuu chi'in ninduvi ma ndra ka'ìin chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ta ora cha chūndachiyo Moisés chi'in Elía xiin Jesuu, tajan te'en nāka'an ndio Petu' chi'in ra: ―Matru, ya'aga va'a ña ka'ìin yo i'ya. Na ja'a ndi uni ta'an lomara kuenda ndo: iin yi kùu kuendaun ta inga yi kuenda Moisés ta inga yi kuenda Elía. ―Takan kà'an Petu' ti ni tüvi chìto ra nayi kà'an ra jà'a ña ya'a yū'vi ra. ");
INSERT INTO mza_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Takan kūu ta ora juuni kà'an ra ndaa ra tajan nūu ndio iin vikonu'u ta kāvanuu yi ma ndi uni ta'an ndra jàkua'a chi'in Jesuu. Ta ora chā'a ndra kuenda ña indii ndra tichi ma vikonu'u, nduva'a kuii yū'vi ndra jā'a yi. ");
INSERT INTO mza_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tajan ma tichi vikonu'u chīni ndra tati Racha'nu Ndioo ña kà'an yi te'en: ―Ra'ya kùu Se'i ña tāchi̱. ¡Na jachi'in ndo ña kà'an ra! ―kàti Ndioo chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ta ora yā'a ña chìni ndra ma tati ikan, tajan ndē'e ndio ndra ña ma'iin nia Jesuu ndaa. Va ndrakan tüvi nī katitu'un ndra ma ña ndē'e ndra nuu nï'iin ñivi. ");
INSERT INTO mza_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta ora tuvi inga kivi, tajan vàchi nuu ndio Jesuu ma yuku chi'in ndi uni ta'an ndra jàkua'a chi'in ra. Ta ma tichi iti' ikan nduva'a kuii kua'a' ñivi chāta'an nuu ndra nuu vàchi ndra. ");
INSERT INTO mza_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tajan iin ma ra vàchi tañu ma ñivi ikan, te'en nāka'an ni'i ra chi'in Jesuu: ―Matru, chìkain ñamani nuu̱n ña na nde'un nayi jà'a chi'in ra se'i, ti uvanuuni ra ña kùu ra se'i. ");
INSERT INTO mza_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vati iin tati xaan kùu yi ña tìin yi ra ta jà'a yi ña na nda'yu ra, ta chì'i i'i ra, ta kèe xikiñu yu'u ra jà'a yi ta endee töve jàña numi yi ra. ");
INSERT INTO mza_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ta nda che'e kā'in chi'in ma ndra jàkua'a chi'un ña na tava ndra ma tati xaan ikan ra, va nī kuu ja'a ndra yi ―kàti tatá ma rayoko chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tajan te'en nāka'an ndio Jesuu chi'in ma ñivi ikan: ―¡Ndyo'o ñivi kini ña tüvi chìnuni! ¿A takä'an koto ndo ña töve ni koi endeeni chi'in ndo ña jà'a ndo takan? ¿A naja ga kivi kùndeeni gai ma ña jà'a ndo?, kùuni ndo. ¡Nandaka ma ra se'un nui! ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ta ora kūyatin ndio ra nuu ndaa Jesuu, tajan ikan jānduva ndiko ma tati ikan ra, ta tīin ndiko yi ra. Ta Jesuu kā'an xaan ra chi'in tati xaan ikan, tajan kēe ndio yi ra, ta ndā'a ra jā'a Jesuu. Ta ikan jan chā'a ndiko ra ra nuu ma ra kùu tatá ra. ");
INSERT INTO mza_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Takan kūu ta ndisaa ma ndian ka'ìin ikan, ndava kuà'an anima na ña ndè'e na ma ña jā'a Ndioo ka'nu. Ta ora juuni yanga ndè'e na ma ña jā'a Jesuu, tajan te'en nāka'an ra chi'in ma ndra jàkua'a chi'in ra: ");
INSERT INTO mza_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Na taso'o va'a ndo ña ni ka'in chi'in ndo: taku ra Se'e ñivi tāchi Ndioo ni tiin na ra, ta ni ku'va na ra nda'a' inga ñivi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Takan kūu va ndrakan tüvi nī kutunini ndra ña kā'an ra, vati tüvi chà'a Ndioo ña na koto ndra tu'un ikan. Ta ndasii ndra ndakatu'un ndra naja kua kùuni yi ka'an yi nuu Jesuu ndia. ");
INSERT INTO mza_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ta ikan jan kīcha'a ndio ma ndra jàkua'a chi'in Jesuu kànita'an yu'u ndra ña nda ra kùu ma ra ka'nuga nuu ndisaa ndra. ");
INSERT INTO mza_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Takan kūu ta ora chā'a Jesuu kuenda cha'a' ma ña chànini ndra chi'in chinituni ndra, tajan tīin ndio ra iin ravali ta kūtaa ra ra iin chiyo xiin ra, ");
INSERT INTO mza_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","tajan te'en nāka'an ndio ra chi'in ma ndra jàkua'a chi'in ra: ―Nda yo kì'in kuenda ravali i'ya cha'a' ña nakoto na yu'u, kùuni yi ka'an yi ña juuni kì'in na kuenda na yu'u ndia. Ta nda yo kì'in kuenda yu'u juuni kì'in na kuenda ma ra tāchi yu'u ndia. Yakan va tu ìyo iin yo kùuni ndoka'nuga, ji'na ìyo yi ña kuu ra musu inga ñivi ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Takan kūu tajan te'en nāka'an ndio Xuva chi'in Jesuu: ―Matru, nda che'e ndē'e ndi iin ra kùatavani'i tati xaan ndiso ma ñivi chi'in siviun, va tava töve chàkunuu ra chi'o, yakan va nī cha'a ga ndi ña jà'a ra yi ―kàti Xuva. ");
INSERT INTO mza_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Na vä'a jà'a ndo ña nī cha'a ndo jà'a ra yi ti ndian tüvi kùuni kuati chi'o, juuni ìyo na kuenda yo ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Takan kūu ta ora cha kēta kivi ña ni ndaa Jesuu ku'un ra iti' andivi, ta chi'in ndisaa anima ra kēe ndio ra kuà'an ra iti' ñuu Jerusalén takua chànini ra niku. ");
INSERT INTO mza_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tajan tāchi ndio ra ma ndra kùu tatun ra na ku'un ndra iti' nuu ta kunanduku ndra nuu kusu ndra iin ñuu ña kàndii ñu'u' Samaria. ");
INSERT INTO mza_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Va ma ndian ñu'u' Samaria tüvi nī cha'a na ve'e nuu ndoo ndra kava ndra chi'in Jesuu, ti cha chā'a na kuenda ña kuà'an Jesuu iti' ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Takan kūu ta ora ndē'e Jandiau chi'in Xuva ña jā'a na takan, tajan te'en nāka'an ndio ndra chi'in Jesuu: ―Yo'o Racha'nu, ¿a kùuniun ña ka'an ndi chi'in Ndioo na jakoyo ra ñu'ú chata na, ikan na kayu ndi'i na ta kuvi na takua jā'a Elía taji'na? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tajan iin nde'e xaani Jesuu nuu ndra, ta te'en nāka'an ndio ra chi'in ndra: ―Ta ndyo'o, ¿a tüvi chìto ndo ña chi'in ndatu kui'na kùu ma ña chàkuu ndo ña kā'an ndo takan? ");
INSERT INTO mza_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Vati taku yu'u ra Se'e ñivi tāchi Ndioo, töve vàchi̱ kuenda ña jànai ñivi ti vàchi̱ jakakúi na ―kàti ra. Ta ora yā'a ña kā'an ra takan, tajan kēe ndio ndra kuà'an ndra inga ñuu. ");
INSERT INTO mza_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Takan kūu ta ora kàcha'an ndra ma tichi iti' ikan, ndē'e Jesuu iin ra chìkatu'un te'en nuu ra: ―Yo'o Racha'nu, kùuni̱ ku'in chataun nda nikuuni nuu chàniniun ku'u̱n ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","―Va'a, va ji'na kùuni̱ katitu'in iin nakuyi nuu̱n ―kàti Jesuu chi'in ra―. Taku ma yukuii ìyo yavi nuu kìxi ri ta nda saa ìyo taka ri ndia, va yu'u ra Se'e ñivi tāchi Ndioo töve ìyo iin nuu kusui ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Takan kūu tajan te'en nāka'an tuku ra chi'in inga ma ra ndaa ma ikan: ―¡Na'a chatai! ―kàti Jesuu chi'in ra. Ta te'en nāka'an ndio ra: ―Yo'o Racha'nu, va'a va tuva ku'va ji'naun ña kukuchi̱ ma tatái ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Na ku'vaun ña na kuchi ma ndian töve chìnuni juuni ñivi maa na ndian cha chī'í, va yo'o na ku'u̱n kukatitu'u̱n naja kua kàa nuu chà'nda Ndioo tiñu nuu ma ñivi ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Takan kūu tajan te'en nāka'an inga tuku ra chi'in Jesuu: ―Yo'o Racha'nu kùuni ku'in chataun va tu ku'va ji'naun ña kuka'in chi'in ñivi̱ ma nuu ìyo ve'i ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Na jä'un yi, ti taku ma ndra tìin su'ma yutun yata, ta ndè'e ndra iti' chata ndra, töve nda kuenda ndra. Yakan va ma tu'un ikan te'en kùuni yi ka'an yi ña ma ndian kīcha'a jà'a tiñu Ndioo, töve jà'a na yi chi'in ndisaa anima na, ti chàku'uni na ma ña jā'a na niku. Yakan va ndiakan na küu ku'un na nuu chà'nda Ndioo tiñu. ―Takan kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Takan kūu tajan Jesuu kāchin ndiko ra inga uni xiko uchi ndra, ta ikan jan tāchi ra ndra, ta uvi ta uvi ndra ña na ku'un kuee ndra iti' nuu ra ña kukatitu'un ndra tu'un Ndioo ta ñuu ta ñuu nuu ìyo yi ña ku'un ra. ");
INSERT INTO mza_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tajan te'en nāka'an ndio ra chi'in ndra: ―Ndicha kuii ti vitin cha ìyo kua'a' ndian kùuni chinuni tu'un Ndioo, va töve kua'a' ndian kukatitu'un yi nuu na. Yakan va na ka'an ndo chi'in Ndioo na tachi ra kua'a' ndian kukatitu'un tu'un Ndioo nuu na. ");
INSERT INTO mza_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yakan va kua'an ndo, ti yu'u tàva tiñu nuu ndo ña na ku'un ndo tañu ñivi ña kùu na takua kùu lobo. Ti kua ikan tà'an mvechala iin tuxa'ini ora kùuni ma lobo kachi ri ndri. ");
INSERT INTO mza_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ta na künda'a ndo yunu ni xu'un' ni inga ndichan ndo ndia. Ta tu keta ñivi nuu ndo ma tichi iti' na kündaa ndo ka'an ndo chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ta tu chaa ndo ve'e iin ñivi, ji'na te'en ìyo yi ña ka'an ndo chi'in na: “Na koo vii ndo ma ve'e i'ya”, kàti ndo. ");
INSERT INTO mza_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta tu ma ve'e ikan ìyo ñivi va'a, ma ña va'a ka'an ndo ni kuu yi jà'a Ndioo, va tu töve, töve ni kuu yi. ");
INSERT INTO mza_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na kindoo ndo juuni ma ve'e ikan. Ta tu chà'a na ña kachi ndo ta kachi ndo. Ta tu chà'a na takuii ko'o ndo, ta ko'o ndo ra'. Vati ma ndian jàtiñu ìyo yi ña ni'i na ya'vi na cha'a' ma tiñu jà'a na. Ta na käkunuu ndo tave'e tave'e na. ");
INSERT INTO mza_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yakan va ora chàa ndo iin ñuu ta ki'in na kuenda ndo, ta kachi ndo ndisaa ma ña chà'a na nuu ndo. ");
INSERT INTO mza_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ta na janda'a ndo ma ndian ku'vi ìyo ñuu ikan chi'in tu'un i'ya: “Cha vàchi kuyatin nuu chà'nda Ndioo tiñu nuu ndo”, kàti ndo chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Va tu chàa ndo iin ñuu, ta tüvi ki'in na kuenda ndo, na kee ndo iti' kai ta ka'an ndo te'en chi'in na: ");
INSERT INTO mza_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nda yuyaka ñuu ndo jà'a ña tìin cha'a ndi ta i'ya jàkisi ndi yi, ikan na koto ndo ti kuenda Ndioo kàchika ndi ta kùxaan ra nde'e ra ndo. Va kùuni ndi ña koto ndo ti cha vàchi kuyatin nuu chà'nda Ndioo tiñu nuu ndo.” Takan kàti ndo chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yakan va kàtitu'in nuu ndo ti Ndioo ora ni keta ra ña jàndondaa ra kuati ñuñivi, nduva'a ga ni jande'e ra tundo'o ma ñivi ñuu ikan kua ma ñivi ñuu Sodoma, ti töve nī ki'in na kuenda ndo chi'in ma tu'un kà'an ndo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Takan kūu tajan te'en nāka'an Jesuu chi'in ma ñivi ikan: ―¡Nda'vi ta'an ndyo'o ñivi ñuu Corazín chi'in ñivi ñuu Betsaida! Vati jā'i kua'a' ndatu ka'nu ñuu ndo ta töve nī jachi'in ndo ma ña kā'in. Ta tu takan jā'i yi kuenda ma ñivi ñuu Tiro ta ñuu Sidón niku, ta ndiakan numini ni ndakoo na ma kuati jà'a na ta ki'vi na ma iti' Ndioo niku. Ta juuni ni kuku'un na ja'ma tuun ta ni kuiin yuyaa xini na takua kùu ma costumbre ña jàna'a yi ña ya'a nda'vi kùuni na cha'a' ma kuati jà'a na. ");
INSERT INTO mza_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yakan va ora ni chaa tiempu ña ni jande'e Ndioo tundo'o ma ñivi, tiaga kua'a' tundo'o ni nde'e ndyo'o kua ma ñivi chīyo ñuu Tiro ta Sidón niku. ");
INSERT INTO mza_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ta kuenda ndyo'o ñivi ìyo ñuu Capernaum, ¿a ni ndaa ndito ndo ku'un ndo iti' andivi?, kùuni ndo. Va na yüvi takan kùu yi ti ndisaa ndo ni ku'un ndo nuu ñu'u' ñuñivi nuu ni kuvi ndo iti' andaya'. ");
INSERT INTO mza_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yakan va ma ndian jàchi'in ña kà'an ndo juuni jàchi'in na ña kà'in, ta ma ndian tìsokuati ndo juuni takan tìsokuati na chatai ndia. Ta ma ndian tìsokuati chatai juuni tìsokuati na ma ra tāchi yu'u ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Takan kūu tajan nduva'a kuii chìsii ma ndi uni xiko uchi ndra kìchaa ndra nuu Jesuu, ña te'en kà'an ndra chi'in ra: ―Yo'o Racha'nu, nda ma tati xaan jāchi'in yi ña kā'an ndi chi'in ma siviun ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Ndicha ña takan kūu yi vati ndē'i ña iti' andivi kīchi ma kui'na Satanaa ña kōyo ra takua kòyo iin tacha. ");
INSERT INTO mza_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yakan va yu'u chā'a ndatu nuu ndo ña na kuañu ndo chata koo tati ta chata tisu'ma, ta juuni kuenda ña na jandi'i ndo ma ndatu ma kui'na chi'in tandi'i nuu tati xaan, ikan töve nàja'a yi chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Va tüvi nuva jà'a ndo ña sii kùuni ndo cha'a' ña jàchi'in ma tati xaan ma ña kà'an ndo, vati na sii kùuni ndo cha'a' ña cha tāa ma Racha'nu Ndioo sivi ndo ma nuu tutu ra ma iti' andivi, ti nda ndakan ni koo ndo chi'in ra endeeni ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Takan kūu ta ma ora ikani nduva'a kuii sii kūuni Jesuu, jā'a ma Tati Ií Ndioo. Yakan va te'en nāka'an ndio ra chi'in Ndioo: ―Yo'o Tatá, ya'a jàka'nui ñu̱n ti maun kùu ma ra chà'nda tiñu andivi, chi'in ñu'u' ñuñivi, vati ma tu'un xe'e ña ìyo chi'un, töve nī jana'un yi nuu ma ndian ìyo chinituni ta nuu ma ndian chìto ña kà'an, ti jāna'un yi nuu ma ndian kùu takua kùu ma ndiakuati. Yakan va ndisaa yakan takan kūu yi, ta takan kūu cha'a' ña jā'un yi. ");
INSERT INTO mza_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Vati ma Tatái chā'a ra ndatu ra nui ña na ka'ndai tiñu cha'a' tandi'i ma ña ìyo ñuñivi i'ya. Yakan va nï'iin ñivi töve nàkoto va'a na yu'u takua nàkoto ma Tatái yu'u, ta juuni töve nàkoto na ma Tatái va yu'u nàkoto va'i ra. Ta kùu jana'i naja kàa ma Tatái nuu ma ñivi ña kùuni mai, ña na nakoto na ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Takan kūu tajan te'en nāka'an ndio ra chi'in ma ndra jàkua'a chi'in ra: ―Na sii kuuni ndian kùu nde'e ña ndè'e ndo. ");
INSERT INTO mza_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Vati yu'u kàtitu'in nuu ndo ti kua'a' ma ndra kà'an chi'in tu'un yu'u Ndioo chi'in ndra kùu Rey, kūuni ndra nde'e ndra ma ña ndè'e ndo vitin, va nī kuu yi. Ta juuni kūuni ndra kuni ndra tu'un chìni ndo va nī kuu yi ndia ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Iin matru jàkua'a tutu Ndioo te'en chīkatu'un ra nuu Jesuu ña kùuni ra ki'in ra ku'va ra: ―Matru, ¿nayi ìyo yi ña ja'i ta kùu ni'i̱ nuu koi indeeni chi'in Ndioo? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―¿Naja kua kà'an nuu ma tutu Ndioo ña jàkua'un? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tajan te'en nāka'an ndio ma matru ña jàkua'a tu'un Ndioo chi'in Jesuu: ―Na kuuni yo nde'o ma Racha'nu Ndioo yo chi'in ndisaa anima yo ta chi'in ndisaa ñandeo ta chi'in ndisaa chinitunio. Ta juuni na kuunio nde'o ma ndian kùu ta'an yo takua kùunio nde'o juuni maa yo ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Ya'a ga va'a kā'un. Tu ja'un ndisaa yakan ni ni'un nuu koun indeeni chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Takan kūu ta tava kùuni ra jana'a ra nuu Jesuu ña iin ra ndaa kùu ra, kùuni ra, yakan va te'en nāka'an ndiko ra chi'in ra: ―¿Ta nda ndian kùu ma ndian kùu ta'in tuva takan? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tajan te'en nāka'an Jesuu chi'in ra chi'in iin ku'va: ―Iin ra judíu kuà'an ra iti' ñuu Jerusalén ña kuà'an iti' ñuu Jericó. Ta ma tichi iti' ikan, kēta ndra su'u nuu ra, ta nāmaa ndra xu'un' ra chi'in ndava nda ja'ma ra ndia. Tajan nduva'a kuii kāni ndra ra ña ndava chī'í nuu ra. Ta kēe ndio ndra kàcha'an ndra. ");
INSERT INTO mza_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Takan kūu ta juuni ma ora ikan chìka iin sutu kuà'an ra ma tichi iti' ikan ndia. Ta ora ndē'e ra nuu kàndii ra, tajan chīkonuuni ra ra ta kēe ndiko ra kuà'an ra iti' nuu. ");
INSERT INTO mza_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta juuni ndē'e iin ra jàtiñu veñu'u ra ndia. Ta rakan juuni chīkonuu ra ndè'e ra ra, ta kuà'an ndiko ra. ");
INSERT INTO mza_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ta juuni ma ora ikan yā'a iin ra ñu'u' Samaria nuu kàndii ra, ta rakan ora ndē'e ra ra, nduva'a kuii kūnda'vini ra ra. ");
INSERT INTO mza_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tajan chājayatin ndio ra ra nuu kàndii ra, ta kīcha'a ra nàkata ra ma nuu takue'e ra chi'in cete ta vinu, kāva ra iin ja'ma ma nuu takue'e ra, tajan jāndaa ra ra chata burru jàna ra, ta kuà'an ra chi'in ra iin ve'e nuu ni nindee ra. ");
INSERT INTO mza_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Takan kūu ta ora tuvi inga kivi, tajan te'en nāka'an ra chi'in ma ra xuve'e ma ora chā'a ra uvi ta'an xu'un' nuu ra: “Na kumiun ra'ya, ta tu janaun tiá xu'u̱n' chi'in ra, ni tia'vi ndikoi nuu̱n ora vàchi̱”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yakan va ndi uni ma ndra ndē'e nuu kàndii ra. ¿Nda ra kùu ma ra ta'an ra ña kūuni ga nde'e ra kùuniun? ―kàti Jesuu chi'in ma matru jàkua'a tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tajan te'en nāka'an ndio ma ra matru jàkua'a tu'un Ndioo chi'in ra: ―Ma ra kūnda'vini, rakan kùu ma ra kùu ta'an ra ―kàti ra. Tajan te'en nāka'an tuku Jesuu chi'in ra: ―¡Kua'an ta ja'un takua jā'a ra! ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Takan kūu ta chīka Jesuu kuà'an ra chi'in ndra jàkua'a chi'in ra nda kati chaa ra iin ñuu. Ta iin ña'a nàni Mata ìyo ikan, chāka ña ndra ve'an. ");
INSERT INTO mza_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tajan ma Mata ìyo iin ña ta'an ña ña nàni Ndiya. Ta yakan chāa ña chūnandian nuu nàndi Jesuu ña tàso'an ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Va tava ma Mata ya'a kūtañuan chi'in ma tiñu jà'a ña, yakan va cha jāyatian ña nuu nàndi Jesuu, ta te'en nāka'an ña chi'in ra: ―Ka'nu kooniun yo'o Racha'nu. ¿A töve chà'un kuenda ña chìniñu'i ña tindee Ndiya yu'u ti ya'a ìyo tiñu jà'i? Na ka'un chi'an na tindean yu'u, ti ya'a kutañui chi'in yi ―kàtian chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tajan te'en nāka'an ndio Jesuu chi'an: ―Yo'o Mata, ¿a ya'a nda'vi kùuniun ña nàkaniniun cha'a' yi takan? ");
INSERT INTO mza_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Vati taku ñata'un Ndiya nàndian tàso'an tu'un kà'in. Ta yakan va'a ga yi kua tandi'i ma tiñu jà'un. Yakan va ma ña jà'a ña, nï'iin ñivi küu ga namaa na yi nuan ―kàti Jesuu chi'an. ");
INSERT INTO mza_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iin ora ndaa Jesuu kà'an ra chi'in Ndioo, tajan ma ora cha chīnu kā'an ra, ta te'en chīkatu'un ndio iin ra jàkua'a chi'in ra nuu ra: ―Yo'o Racha'nu, kùuni ndi ña jana'un nuu ndi naja kua ka'an ndi chi'in Ndioo takua jāna'a Xuva ra jàkunduta nuu ma ndra jàkua'a chi'in ra ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Ora kà'an ndo chi'in Ndioo, te'en ìyo yi ña ka'an ndo: Yo'o ra kùu Tatá ndi, ra ìyo andivi, ma siviun ya'a ga ií yi. Na kichi ma nuu chà'ndaun tiñu nuu ndi. Ta na ja'un takua kùuniun ma nuñu'u' ñuñivi takua jà'un yi ma andivi. ");
INSERT INTO mza_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ta na ku'vaun kua'a' ma paan ña chiniñu'u ndi ta'ii'iin kivi. ");
INSERT INTO mza_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na jaka'nuniun ma kuati ndi, takua jàka'nuni ndi ma kuati jà'a kua'a' ñivi chata ndi. Ta koto kü'vagaun ña titunini ndi ja'a ndi ma kuati ta na jakaku̱n ndi nuu yi. ");
INSERT INTO mza_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Takan kūu ta ora chinu kā'an Jesuu takan, tajan te'en nāka'an tuku ra chi'in ndra: ―Ta tu iin yo'o ìyo iin ra nàkotoun, ta chāa iin ora ña ku'u̱n kujakate'un yuve'e ra ora java ñuu chanikuaa chi'in tu'un i'ya: “Yo'o xaa, na jaya'a nuu̱n uni ta'an paan nui, ");
INSERT INTO mza_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","vati já chāa iin ra nàkotoi, ña kīchi nuu chika ma ve'i, ta tükuii nayi ku'vai kachi ra.” Takan kàtiun chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Va tu ma ra nàkotoun te'en nàka'an ra chi'un nda nuu kàndii ra ma tichi ve'e: “Na kä'an kuatigaun nui ti cha ndāsi yuve'i ta kìxi̱ kàndii̱ nuu chito chi'in ndiakuati se'i. Yakan va na küu ndetai ku'vai nï'iin nakuyi nuu̱n”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Va yu'u kàti̱, ti vaji küuni ra ndakoo ra ña ku'va ra nï'iin nakuyi nuu̱n cha'a' ña kùu̱n ma ra nàkoto ra, ìyo yi ña ja'a ra yi tuva ya'a kua'a' yu'u̱n. Tajan ndēta ndio ra ta chā'a ra tandi'i ma ña chìniñu'u̱n. ");
INSERT INTO mza_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yakan va yu'u kà'in chi'in ndo: ña na ndakan ndo ña chìniñu'u ndo nuu Ndioo, ta ku'va ra yi nuu ndo. Ta tu nànduku ndo ra, ta nàta'an ndo ra. Ta tu jàkate'e ndo yuve'e ra, ta nuna ra yi nuu ndo. ");
INSERT INTO mza_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vati tu chìkan ndo iin nakuyi, ni ni'i ndo yi, ta tu nànduku ndo iin nakuyi, ta nàta'an ndo yi, ta tu jàkate'e ndo yuve'e ra, ni nuna ra yi nuu ndo ndia. ");
INSERT INTO mza_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Yakan va tu ìyo nda ndyo'o ìyo se'e ndo, ta chìkan na ña kachi na nuu ndo, ta, ¿a ku'va ndo yuu ña kachi na yunuu paan? ¿A ku'va ndo koo kachi na yunuu tiaka'? ");
INSERT INTO mza_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ta juuni, ¿a ku'va ndo tisu'ma kachi na tuva chìkan na ndivi nuu ndo?, kùuni ndo. ¡Na küu ja'a ndo takan chi'in se'e ndo! ");
INSERT INTO mza_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ta tuva ndyo'o ndian ìyo kuati chìto ndo ku'va ndo ña va'a nuu ma se'e ndo, nda ma Racha'nu Tatá yo, ra ìyo andivi kua'a' ga ña va'ani ja'a ra chi'in ndo, ta juuni kùu ku'va ra ña koo ma Tati Ií Ra nuu nda ndian chìkan yi nuu ra ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iin kivi ndaa Jesuu jànda'a ra iin ra kīndoo ñi'i jā'a ma tati xaan. Ta ora kēe yi jā'a Jesuu, ma ora ikani kīcha'a ra kà'an ra. Ta ma ñivi ka'ìin ikan ndava kuà'an anima na ña ndē'e na ña jā'a ra. ");
INSERT INTO mza_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ta ìyo ndian kà'an ña ma kui'na Beelzebú ña chà'nda tiñu nuu tati xaan, yakán' kùán' ña chà'án' ndatuán' nuu ra'ya ña na tavani'i ra tati xaan ndiso ñivi, kàti na. ");
INSERT INTO mza_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ta ìyo inga ndian chìkan ña na ja'a ra iin ndatu chi'in sivi Ndioo, ra ìyo andivi, ti nànduku na naja kua kùu tisokuati na ra. ");
INSERT INTO mza_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Va tava cha chìto Jesuu ti töve va'a chànini na, yakan va te'en nāka'an ndio ra chi'in na: ―Tu kànita'an ñivi ìyo iin ñuu juuni chi'in maa na, ni ndi'i nuu na. Ta tu ìyo ñivi ìyo iin ve'eni ta kanita'an na juuni chi'in maa na, ni ndi'i nuu na chi'in nda ma ve'e na ndia. ");
INSERT INTO mza_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ta juuni kà'in ña tu kànita'an ñivi Satanaa chi'in juuni maa na, juuni ni ndi'i nuu na, vati na küu kanita'an ma kui'na juuni chi'in ma ñivián'. Takan kàti̱ chi'in ndo vati kàti ndo ña chi'in ndatu ma kui'na nàni Beelzebú jànda'i ñivi ku'vi ña ndiso tati xaan. ");
INSERT INTO mza_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tu chànini ndo, ña chi'in ndatu Beelzebú tàvai ma tati xaan. Tajan juuni ma ndian tàva tati xaan ndiso ma ñivi ña ìyo tañu ndo, juuni maa na ni tisokuati na ndo ti tüvi va'a chànini ndo. ");
INSERT INTO mza_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Vati tu yu'u tàvani'i̱ tati xaan ndiso ñivi chi'in ndatu Ndioo, yakan kùuni yi jana'a yi ña cha ìyo ma nuu chà'nda Ndioo tiñu chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Taku iin ra'ii ña ya'a ga ìyo ñandee, ña kùmi ra ve'e ra chi'in ña xaan, ma ña va'a ña ka'ìin tichi ve'e ra töve nani ta'an yi. ");
INSERT INTO mza_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Va tu chaa inga ra ña ìyo ga ñandee, rakan ni janaa ra ra ta nāmaa ra ma ña xaan ña kùndeeni ra, ta kùu ndonuu ra nuu ma ña xuña'a ra, ta nata'vi ra yi nuu inga na. ");
INSERT INTO mza_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Vati ma ndian tüvi chàkunuu chi'i̱n, xaani na nde'e na yu'u, ta ndian tüvi tìndee yu'u ña kàtitu'un na tu'un Ndioo, ndiakan töve chà'a na ña koto ñivi ma tu'in. ");
INSERT INTO mza_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ora kèe tati xaan tichi kuñu iin ñivi, ta chàkunuu yi nuu ñu'u' ití ña nànduku yi nuu koo yi. Va takua töve nàta'an yi nuu koo yi tajan te'en chànini ndio yi: “Na chikoni'i ndikoi tichi ve'e nuu kēi”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Takan kūu ta ora chīkoni'i ndiko ndio yi tichi kuñu na, ta ndē'e yi ña nduva'a kuii va'a kàa na takua kàa iin ve'e ma ora nàti'vi yi. ");
INSERT INTO mza_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tajan kèe ndio yi kuà'an yi kuàjati'vi ta'an yi inga ucha ma tati xaan ña ìyoga ñàndee. Tajan induku kì'vi ndio yi tichi kuñu na, ta vi'a jànde'e yi tundo'o na ma takua ndè'e na yi ma nunuu niku. ");
INSERT INTO mza_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Takan kūu ta ora juuni takä'an chinu kà'an Jesuu, tajan iin ña ndaa tañu ma ñivi ikan te'en nāka'an ni'an chi'in Jesuu: ―¡Ya'a ga sii kùu ma ña'a jākaku ñu̱n, ta jākua'nu ñu̱n! ―kàtian. ");
INSERT INTO mza_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tajan te'en nāka'an ndio Jesuu chi'an: ―¡Na siiga kùuni ma ndian chìni ta jàchi'in na ña kà'an Ndioo! ―kàti Jesuu chi'an. ");
INSERT INTO mza_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Takan kūu ta ma ñivi tiaga kua'a' na kīcha'a kùti'vi na nuu ndaa Jesuu, tajan te'en kīcha'a kà'an ra chi'in na: ―Ma ñivi jà'a kuati ìyo ñuñivi i'ya chìkan na ña na ja'i iin ndatu nuu na. Va yu'u kàti̱ ti tüva ga ni jana'a Ndioo ndatu nuu na, vati uvaa ma ndatu ña jā'a Jonás taji'na. Yakani kùu ma ña ni nde'e na. ");
INSERT INTO mza_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Vati takua Jonás, kūu ra iin seña kuenda ñivi ñuu Nínive ña chīyo taji'na, takua ikan ni kuu yu'u ra Se'e ñivi iin seña kuenda ñivi ìyo tiempu i'ya ndia. ");
INSERT INTO mza_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Vati ora ni chaa tiempu ña ni tiku'va Ndioo ma kuati jà'a ndisaa ñivi, juuni ni jaketa ra iin ña'a kūu reina ña chà'nda tiñu nuu ñivi chīyo iti' xuu. Ta yakan kùu ma ña ni tachi Ndioo ña na tisokuatian ndo ora ni tiku'va ra kuati. Vati yakan kīchian iin ñuu ya'a chika, tajan jāchi'an tu'un Ndioo ña kā'an Rey Salomón taji'na. Va vitin yu'u kùu iin ra ka'nu ga kua Rey Salomón. ");
INSERT INTO mza_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yakan va ma ñivi chīyo ñuu Nínive ni jaketa ndiko Ndioo na, tajan ni tachi ra na ña na tisokuati na ñivi ìyo tiempu i'ya ora ni tiku'va ra kuati ñivi. Vati ma ñivi ñuu Nínive ndākoo na kuati jā'a na ta chīkoni'i ndiko na iti' Ndioo ora kātitu'un Jonás tu'un Ndioo nuu na. Yakan va yu'u ra kàtitu'un nuu ndo ka'nugai kua Jonás ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Vati taku ma ndian tàa ñu'ú kandil ta tìxe'e na yi a chàsi na iin nakuyi nuu yi, töve nda kuenda yi, vati ìyo yi ña kutaa na yi iin nuu sukun, ikan na ndondichin nuu ma ndian kì'vi tichi ve'e na. ");
INSERT INTO mza_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ti ma tinuu yo kùu yi takua kùu iin ma ñu'ú ña ìyo tichi kuñu yo. Ta tu va'a ìyo yi ma tichi tinuu yo, ni ndondichin iti' va'a ña kùuni Ndioo ña ku'un yo, vatu töve ìyo ña va'a ma tichi tinuu yo ni ndonaa nuu yo. ");
INSERT INTO mza_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yakan va na ki'in yo kuenda nuu yo juuni chi'in maa yo, nde'o tu ma ñu'ú ìyo chi'o jàndondichin yi nuu yo a ndonaa nuu yo jà'a yi. ");
INSERT INTO mza_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Vati tu ndichin va'a nde'e ndo ta töve naa tichi tinuu ndo, ni nde'e kachin va'a ndo takua nde'e ñu'ú kandil ora jandondichin yi iti' kuà'an yo ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Takan kūu ta ikan jan jāinvitaa iin ra fariseu Jesuu ña na ku'un ra kukachi ra chi'in ra nuu ìyo ve'e ra. Ta ora chāa ndio Jesuu ma ve'e ra, tajan kī'vi ndio ra, ta chūnandi ra yu'u mesa. ");
INSERT INTO mza_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Va ma ra fariseu kīcha'a ra nàkanini ra ña naja töve nī nakata ji'na ra nda'a' ra, ta kachi ra takua ìyo costumbre ma ndra fariseu. ");
INSERT INTO mza_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Takan kūu ta Jesuu tava numi nākuni ra takua chànini ra, yakan va te'en nāka'an ndio ra chi'in ra: ―Taku ndyo'o ndra fariseu, chìto va'a ndo tava ndo ña meku nuu ndatiñu ndo ora nàkata ndo yi, ta kuñu ndo ora chìti ndo ndia, va töve ndakuenda yi ti nàani ndo nàkata va'a ndo ma ña kini kìndoo tichi anima ndo chi'in ma ña su'u ndo ndia. ");
INSERT INTO mza_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¿Ta naja ya'a tondo xini ndo ña chànini ndo takan? ¿A tüvi chìto ndo ti Ndioo kùu ma ra ña jātuvi tandi'i ña ìyo yo, nda ma iti' chata kuñu yo ta nda ma iti' tichi yi ndia? ");
INSERT INTO mza_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ta na tindee ndo ñivi chi'in ma ña ìyo nuu ndo, ikan na nandoo anima ndo ta takan kindoo vii yi. ");
INSERT INTO mza_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Nda'vi ta'an ndyo'o ndra fariseu, ti vaji sòkó ndo uchi porcientu ma xu'un' kuenda Ndioo, takua kùu ma ruda chi'in minutila ta inga tuku ma yuku tàchi ndo ndia, ta tüvi jà'a ndo ma ña ndaa kuenda ñivi takua kùuni Ndioo ña jà'a ndo, ti tüvi kùuni ndo nde'e ndo ra! Yakan va ìyo yi ña ja'a ndo ninduvi yi takua kùuni Ndioo ña koo ndo. ");
INSERT INTO mza_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Nda'vi ta'an ndyo'o ndra fariseu! Ti kùuni ndo kunandi ndo ma tayu ka'nu ga ña ìyo tichi veñu'u ñivi judíu, ta juuni chàta'ani ndo tu ya'a tìñu'u ma ñivi ndo ora chàkunuu ndo nuya'vi. ");
INSERT INTO mza_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Nda'vi ta'an ndo chi'in ma ndra matru jàkua'a tutu ley Ndioo! ¡Vati ña va'a jà'a ndo kùuni ndo, va ma ñivi cha chà'a na kuenda ti ndra vata kùu ndo! Yakan va kùu ndo takua kùu ma nuu ñaña ña ìyo kamajandu, ti ma ñivi chàñu na chata ndo ta tüvi chà'a ndo kuenda. ");
INSERT INTO mza_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Takan kūu tajan iin ma ra matru jàkua'a tutu Ndioo ndaa ikan te'en nāka'an ra chi'in Jesuu: ―Matru, ma ña kà'un, kùuni yi ka'an yi ña kà'un chata ndi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―¡Nda'vi ta'an ndyo'o ndra matru jàkua'a tutu ley Ndioo! Vati ni nde'e ndo tundo'o ti tàchi ndo ña na jachinu ñivi tiñu ya'a ndetiñu ña na kündee na jà'a na. Ta na töve kùuni ndo tindee ndo na chi'in yi ndia. ");
INSERT INTO mza_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Nda'vi ta'an ndo ndyo'o matru jàkua'a tutu Ndioo, ña jàva'a ndo nuu ñaña nuu cha kūchi ma ndra kà'an chi'in tu'un yu'u Ndioo ña chīyo taji'na ndra chī'í jā'a juuni ma ñivi ndo! ");
INSERT INTO mza_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ta chi'in ña jà'a ndo i'ya jàna'a ndo ti induku kùuni ndo chi'in ma ñivi ndo ña chīyo taji'na, ti chìto ndo ña chā'ni ndra na ta juuni maa ndo jà'a ndo nuu ñaña nuu kùchi ndra. ");
INSERT INTO mza_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Yakan va Ndioo te'en nāka'an ra chi'in ma chinituni ra: “Ni tachi̱ ma ndra kùu tatuin chi'in ndra kà'an chi'in tu'un yu'u Ndioo nuu ndo, va ma ñivi ìyo tiempu i'ya ìyo ndian ni ka'ni ndra ta ìyo inga ndian ni jande'e ndra tundo'o.” ");
INSERT INTO mza_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Vati ma ndian ìyo tiempu i'ya ni ndakan Ndioo kuenda nuu na cha'a' ña chā'ni na tandi'i ma ndra kà'an chi'in tu'un yu'u Ndioo ña chīyo nda ora jātuvi ra ñuñivi i'ya. ");
INSERT INTO mza_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ta juuni kà'an yi nuu ndo cha'a' ma nda tiempu chī'í Abel chi'in ma Zacaría, ra chā'ni na nuu jàka'nu na Ndioo yu'u nuu ndaa ma chito naá ií ma tichi veñu'u. Yakan va ni ndakan ma Ndioo kuenda nuu ma ñivi ìyo vitin cha'a' ña jā'a ma ñivi na, ndian chīyo taji'na. ");
INSERT INTO mza_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Nda'vi ta'an ndyo'o ndra matru ña jàkua'a tutu ley Ndioo, ti ni nde'e ndo tundo'o cha'a' ña chä'a ndo koto ma ñivi ikan ma tu'un Ndioo, ta ni maa ndo küuni ndo ki'vi ndo ma iti' ra, ta ni töve chà'a ndo ña ki'vi inga ñivi ña kùuni ki'vi na ndia. ");
INSERT INTO mza_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Takan kūu tajan ma ndra matru jàkua'a tutu ley Ndioo chi'in ma ndra fariseu nduva'a kuii kùxaan ndra ña kā'an Jesuu takan. Ta ikan jan kīcha'a ndra chìkatu'un ndra kua'a' nakuyi nuu ra, ");
INSERT INTO mza_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nde'o tu kà'an ra iin tu'un ña tüvi va'a, ta takan kùu ni'i ndra kua tìsokuati ndra ra. ");
INSERT INTO mza_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Takan kūu tajan nduva'a kuii kua'a' mii ñivi kūti'vi nuu ndaa Jesuu ña ndava tìtuta'an na. Tajan te'en nāka'an ndio ra ji'na chi'in ma ndra jàkua'a chi'in ra: ―Na ja'a va'a ndo kuenda nuu ndo chi'in ma tu'un ña jàna'a ma ndra fariseu, ti töve jàchinu ndra ma ña jàna'a ndra, ti ndra jànda'viña'a ñivini kùu ndra, takua kùu ma yuchan iya ña kuva'a ma paan. ");
INSERT INTO mza_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vati na küu tixe'o ña jà'a yo kua'a' kivi, ta ni ma ña indii xe'e nuu yo chaa iin kivi ña ni koto kachin tandi'i ma ñivi yi. ");
INSERT INTO mza_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yakan va tandi'i ma tu'un ña kā'an xe'e ndo, vitin ni koto tandi'i ma ñivi yi. Ta vaji chāsi va'a ndo yuve'e ndo ta kā'an xe'e ndo, juuni ni chaa iin kivi ña ni koto ñivi yi ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Takan kūu tajan te'en nāka'an tuku Jesuu chi'in na: ―Taku ndyo'o ndian kùu amigui kàtitu'in nuu ndo ña töve na ja'a ndo ña yù'vi ndo ma ndian chà'ni ma kuñu ndo, vati ora cha yā'a ña jà'a na takan, na tüva inga ña kùu ja'a na chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Vitin ni katitu'in nuu ndo nda ra kùu ma ra ìyo yi ña yu'vi ndo: na yu'vi ndo nde'e ndo ma Racha'nu Ndioo, ti rakan ora cha yā'a chā'ni ra ndo juuni ìyo ndatu ra ña tachi ra ndo andaya' ndia. Yakan va rakan kùu ma ra ìyo yi ña yu'vi ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ta juuni kùu jata yo u'un ta'an saa kuati chi'in uvi pesuni, ta vaji ndicha ña takan ndaa ndri, va Ndioo tüvi nàani ra ndri ti kùuni ra nde'e ra ndri. ");
INSERT INTO mza_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Va taku ndyo'o ti nda ixi xini ndo cha kā'vi va'a Ndioo yi, yakan va na tüvi na ja'a ndo ña yù'vi ndo, ti Ndioo kùuniga ra nde'e ra ndo kua saa kuati ikan. ");
INSERT INTO mza_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Yakan va yu'u kàti̱ chi'in ndo ti tu kàtitu'un ndo ña chìnuni ndo tu'un kà'in nuu kua'a' ñivi, nda yu'u ra kùu Se'e ñivi tāchi Ndioo ni katitu'in ña nàkotoi ndo nuu tati ña jàtiñu kuenda Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Va tu kàtitu'un ndo ña töve nàkoto ndo yu'u nuu ma ñivi, nda yu'u ra kùu Se'e ñivi tāchi Ndioo, ni kukatitu'in nuu ma tati jàtiñu kuenda Ndioo ña töve nàkotoi ndo ndia. ");
INSERT INTO mza_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Vati taku Ndioo ni jaka'nuni ra kuati ndo vaji kà'an ti'ini ndo chata ra Se'e ñivi ña tāchi ra, va tu kàti'ini ndo chata ma Tati Ií Ndioo, töve ni jaka'nuni Ndioo ma kuati ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ta ora tìin ñivi ndo ta kundaka na ndo tichi veñu'u a nuu iin ra kùu juez ña jàndondaa tiñu, a nuu ndra kùvetiñu, na töve na ja'a ndo ña nàkanini ndo cha'a' ña naja kua kuu ka'an ndo cha'a' ndo, ");
INSERT INTO mza_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","vati ma ora ni chaa ma ora ña ni ka'an ndo cha'a' ndo, maa ma Tati Ií Ndioo, ni jana'a yi nuu ndo naja kua ìyo yi ña ka'an ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Takan kūu tajan iin ra nda tañu ma ñivi ikan te'en nāka'an ra chi'in Jesuu: ―Matru, na ka'un chi'in ma ra yani̱ ña na nata'vi ra ma ndatiñu ndākoo nditatá ndi chi'i̱n ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Yo'o xaa, ¿a chàniniun ña yu'u kùu ma juez ña ìyo yi ña ka'in naja kua ìyo yi ña nata'vi ndo ma ñu'u' ña kā'un takan? ¿Ta naja chìkatu'u̱n nui naja kua nata'vi ndo ma ndatiñu ndo? Yöve tiñu jà'i kùu yi ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tajan te'en nāka'an ndiko ra chi'in ma ñivi ikan: ―Na ja'a ndo kuenda nuu ndo chi'in ma ña kùuni ndo kukuika ndo, vati töve nda ña kukuika yo tajan kùu koo va'a yo vaji tüvi kua'a' ndatiñu yo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Takan kūu tajan te'en nāka'an ndio ma Jesuu iin ku'va nuu na: ―Taji'na chīyo iin ra ya'a kuika, va keta iin kuiya ña nduva'a kuii kua'a' ndatiñu ra kēe nuu ma ñu'u' ra. ");
INSERT INTO mza_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tajan te'en kīcha'a ndio ra chànini ra: “¿Nayi ìyo yi ña ja'a yo ña tüvi ni chata'an yaka ña tàan va'a yo ndatiñu yo?”, chànini ra. ");
INSERT INTO mza_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tajan te'en chānini ra: “An cha chìto yo nayi ìyo yi ña ja'a yo. Ni janatani yo ma yaka ìyo vitin ta java'a ndiko yo inga ña ka'nu ga, ta ikan ndakiva'a yo tandi'i ndatiñu yo ña tavani'i yo ta ndisaa kuii inga tuku ma ndatiñu ña ìyo nuu yo.” ");
INSERT INTO mza_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ta ora cha jā'a yo yi, tajan te'en ni ka'an ndio yo chi'in juuni maa yo: “Yo'o xaa vitin cha ìyo kua'a' ña kachiun kuenda kua'a' kuiya, yakan va na sii kuuniun ta nindeun ta kachiun ta ko'un vitin.” Takan kà'an ra juuni chi'in maa ra. ");
INSERT INTO mza_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Takan kūu tajan Ndioo te'en nāka'an ndio ra chi'in ra: “¿A ya'a tondo xiniun ña chàniniun takan? Yakan va yu'u kàti̱ chi'un ña juuni ma chanikuaa vitin ni kuviun, ta tandi'i ma ña tāan va'un na töve chìtoun yo kuenda ni kuu yi.” Takan kāti Ndioo chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Takan tā'an ma ndian ndàkiva'a kua'a' ma ña kuika kuenda na, va taku kuenda Ndioo ndian nda'vini kùu na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Takan kūu tajan te'en nāka'an ndio Jesuu chi'in ndra jàkua'a chi'in ra: ―Yu'u kàti̱ chi'in ndo ti töve na ja'a ndo ña nàkanini ndo cha'a' ña kachi ndo ta ni cha'a' ja'ma chàku'un ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vati ma kivi ìyo ndo ña chā'a Ndioo nuu ndo, va'aga yi kua ma ña kachi ndo, ta ma kuñu ndo va'aga yi kua ma ja'ma chàku'un ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Na nde'e ndo takua ìyo ma saa ña nàni tikaka. Vati taku ndrikan tüvi tàchi ndri ta tüvi tavani'i ndri nï'iin nuu ma ndatiñu ndri, ta va'ani chà'a Ndioo ña kachi ndri vaji töve ndakuenda ndri. Tu takan jà'a ra chi'in ma saa ikan tajan kùuni yi ka'an yi ña kua'a' ga ma ña va'a ni ja'a ra chi'in maa ndo. Ndyo'o ìyo ga kuenda ndo kua saa ikan ndè'e Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na küu nakanini ndo kua'a' nakuyi tuva ni küu ja'a ndo ni ma ña valiga ña chànini ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yakan va, ¿tu küu ja'a ndo ma ña valiga ña chànini ndo, nda kuenda ña chànini ndo cha'a' kua'a' nakuyi tuva takan? ");
INSERT INTO mza_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Na nde'e ndo takua chà'nu ma ita vii ña kàa tichi ku'u. Vati ita ikan tüvi jàtiñu yi ta ni tüvi kùnu yi isa, ta va'ani vii ga kàa yi kua kàa ma ja'ma ña chāku'un ma Rey Salomón, ra ya'a ka'nu. ");
INSERT INTO mza_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yakan va tu takan jàku'un Ndioo tanuu color ma ita kàa tichi ku'u vaji ni chaa iin kivi ña kàyu yi, va chi'in ndyo'o ndicha kuii ni ku'va ra ja'ma ni ku'un ndo. Yakan va, ¿ta naja töve chìnuni ndo ña tìndee Ndioo ndo tuva takan? ");
INSERT INTO mza_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yakan va na tüvi na ja'a ndo ña nàkanini ndo cha'a' ña kachi ndo ta ña ko'o ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vati cha'a' ndatiñu ikan kùu yi ña nàkanini ma ñivi ìyo ñuñivi i'ya. Va taku ndyo'o na tüvi na ja'a ndo ña nàkanini ndo cha'a' yi, ti ìyo iin Racha'nu ña kùu Tatá ndo ña chà'a ra ma ña chìniñu'u ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yakan va na nanduku ndo naja kua kùu koo ndo chi'in Ndioo nuu chà'nda ra tiñu, tajan kuu ku'va ra tandi'i ma ña chìniñu'u ndo. ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Takan kūu tajan te'en nāka'an tuku Jesuu chi'in na: ―Va ndyo'o ndian kùu mvechala jànai, na yü'vi ndo vaji tiani ndo, vati Ndioo yo cha chā'a ra ña na koo ndo chi'in ra ma nuu chà'nda ra tiñu ti kùnda'vini ra ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yakan va na xiko ndi'i ndo ma ndatiñu ña ìyo nuu ndo, ta tìndee ndo ma ndian nda'vi, ikan na ni'i ndo ya'vi ndo ma iti' andivi. Ta na jändolocho ndo ma ña kuika ndo ma nuñu'u' ñuñivi i'ya, vati ndòcha'nu yi ta kùtikixin yi. Ta ma andivi ti na küu ki'vi ma ndian su'u ta ni ma tikixin. ");
INSERT INTO mza_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vati ma ña kuika ña kàya ndo ma iti' andivi a ma ñuñivi i'ya, ikan nuu kàya ndo yi kùu ma nuu indii anima ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Yakan va na koo tu'va ndo ora ni kichi̱ inga cha'a'. ");
INSERT INTO mza_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Na koo tu'va ndo takua ìyo ma ndian kùu musu ña ndàtu na ma ra kùu chito'o na, nde'o nda ora ni kichaa ra ña kuà'an ra nuu ìyo viko tanda'a, ta jakate'e ra yuve'e, ta numini nuna na yi nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Na sii kuuni ma ndra kùu musu ña ndàtu va'a ndra, ra kùu chito'o ndra nde'o nda ora ni kichaa ra, ta nàta'an ra ndra ña ndito ndra. Yu'u cha chìto va'i ti juuni ma ra kùu chito'o ndra ni ka'an ra chi'in ndra ña na kunandi ndra yu'u mesa, ta kuti'i ra ña kachi ndra. ");
INSERT INTO mza_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yakan va na sii kuuni ma ndian kùu musu ña nàta'an ndito ma ndian kùu chito'o na na, vaji ora java ñuu a ora ni tuvi. ");
INSERT INTO mza_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yakan va na taso'o va'a ndo ma ña ni ka'in chi'in ndo, ti tu iin ma ra chito'o ma ve'e chà'a ra kuenda nda ora ni ki'vi ma ndra su'u ve'e ra, na kü'va ra ña ki'vi ndra ve'e ra, ta su'u ndra ndatiñu ra. ");
INSERT INTO mza_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ta nda maa ndo ìyo yi ña koo tu'va ndo ti töve chìto ndo nda ora ni kichaa ndikoi yu'u ma ra Se'e ñivi tāchi Ndioo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Takan kūu tajan te'en chīkatu'un ndio Petu' nuu Jesuu: ―Yo'o Racha'nu, ¿a kà'un ma tu'un i'ya kuenda ndyu'uni a kuenda ndisaa ñivi ndia? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tajan te'en nāka'an ndio ma Jesuu chi'in ra: ―¿Nda ra kùu ma musu ña ndàkoo ma chito'o ña jàtiñu va'a?, kùuni ndo, ¿a ma ra ìyo tu'va chi'in ma tiñu jà'a ña chà'a ra ña kachi ma ndian kùu ñivi ma ra kùu chito'o ra?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Na sii kuuni ma ra kùu musu ña ìyo tu'va ra chi'in ma tiñu jà'a ra ora chàa ma ra kùu chito'o ra. ");
INSERT INTO mza_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ndicha va'a ña kà'in chi'in ndo, ña nuu ma musu ikan ni ku'va ma chito'o ra tiñu nuu ra ña na kuxini ra nuu ndisaa ma ndatiñu ra. ");
INSERT INTO mza_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Va tu ma musu ikan kīcha'a ra ndòxaan ra nuu inga ma ndra musu ta nuu ma ñivi ña'a ndia. Ta kīcha'a ndio ra chàchi ra ta chì'i ra nda kati chìní ra ti chànini ra ña ni kuyanga ma chito'o ra, kùuni ra. ");
INSERT INTO mza_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Va töve chā'a ra kuenda ña ma kivi a ma ora ña töve ìyo tu'va ra ni kichaa ma chito'o ra, ta ni jande'e ra tundo'o ra, takua jà'a ma Racha'nu chi'in inga ma ndian töve jàtiñu va'a. ");
INSERT INTO mza_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Va ma ra musu ña cha chìto ra nayi kùuni ma chito'o ra ña jà'a ra ta töve jà'a ra yi, rakan nduva'a kuii ni jande'e ra tundo'o ra. ");
INSERT INTO mza_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Va ma ra musu ña jà'a ra kuati ti tüvi chìto ra nayi kùu ma tiñu va'a ña kùuni ma chito'o ra ña jà'a ra, ta jà'a ra iin ña tüvi va'a, rakan ni nde'e ra tiani tundo'o. Ta ma ra musu ña chà'a ma chito'o ra kua'a' tiñu nuu ra ni ndakan ra nuu ra ña na ja'a va'a ra yi ndia. Ta ma ra musu ña ya'a kūndeeni ma chito'o ra ndè'e ra, tiaga kua'a' tiñu ni ndakan ma chito'o ra ña na ja'a ra. ");
INSERT INTO mza_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Vati yu'u vàchi jande'i tundo'o ma ñivi ìyo ñuñivi i'ya, ta nduva'a kùuni̱ ña na kicha'a yi chi'in na ma vitini. ");
INSERT INTO mza_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Va ji'na ìyo yi ña nde'e ji'nai tundo'o ta nduva'a nàkanini̱ cha'a' yi ña nda ora kùu yi ña na chaa ma kivi ikan. ");
INSERT INTO mza_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A vàchi jandomani̱ ma ñivi ìyo ñuñivi i'ya?, kùuni ndo. Na yüvi takan kùu yi, vati vàchi tavani'i̱ siin ndo. ");
INSERT INTO mza_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yakan va nda vitin ta iti' nuu, takan ni koo yi: vati tu ìyo u'un ta'an ñivi iin ve'e, ndiakan ni kee siin na ti ni kanita'an uni na chi'in uvi na, ta uvi na chi'in uni na. ");
INSERT INTO mza_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ta ma tatá na ni kanita'an ndra chi'in juuni se'e ndra, ta se'e ndra ni kanita'an na juuni chi'in tatá na. Ta ma ñivi kùu ma'á na ni kanita'an vi juuni chi'in se'e vi ta ñivi se'e vi ni kanita'an vi juuni chi'in ma'á vi. Ta ña ka'nu vi kanita'an vi chi'in chanu vi, ta chanu vi chi'in ña ka'nu vi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ta te'en kīcha'a tuku Jesuu kà'an ra chi'in ñivi ikan: ―Tu nde'e ndo ña ya'a ka'vi kàa ma viko andivi, ta kati ndo ti ni kuun ma savi, ta ndicha ti takan ni kuu yi. ");
INSERT INTO mza_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ta ora chàkin tati chiyo iti' sur, ta kàti ndo ti ya'a ni'ni ni ja'a yi, ta ndicha ti takan ni ja'a yi. ");
INSERT INTO mza_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ndyo'o ñivi kini, tuva chìto va'a ndo naja kua jà'a ma tiempu andivi chi'in nuu ñu'u' ñuñivi i'ya, ¿ta naja töve chìto ndo kì'in ndo ku'va ma kivi ìyo ma tiempu i'ya? ");
INSERT INTO mza_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Yakan va, ¿ta naja tüvi kùu ja'a juuni maa ndo ma ña chànini ndo ña kùu ña va'a? ");
INSERT INTO mza_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Vati tuva ìyo iin yo tìsokuati ndo, ta ku'un na chi'in ndo nuu ndra kùu vetiñu, na kunumi ndo jandondaa ndo kuati ikan chi'in ndra kùu vetiñu ji'na, ña ti'i na ndo nda'a' ra kùu juez, vati tu tüvi ja'a ndo takan, ni ku'va ma ra kùu juez ndo nda'a' ndra jandaru ña kùmi ra, ta ndrakan tì'i ndra ndo vekaa. ");
INSERT INTO mza_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yakan va yu'u kàti̱ chi'in ndo ti na këe ndo ma vekaa ikan, nda kati tia'vi ndi'i ji'na ndo ma kuati jā'a ndo. ―Takan kàti Jesuu chi'in ma ñivi ikan. ");
INSERT INTO mza_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Takan kūu ta juuni ma ora ikan chāa iin ndra judíu nuu ndaa Jesuu. Ta ndrakan kātitu'un ndra nuu ra naja kua jā'a Pilatu ña chā'ni ra ñivi judíu kīchi iti' ñu'u' Galilea ma nuu sòkó na kiti jàna na kuenda Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tajan te'en nāka'an ndio Jesuu chi'in ñivi ka'ìin ikan: ―¿Naja kua chànini ndo? ¿A chànini ndo ña chā'ni ra na ti ìyo ga kuati na kua inga ñivi ìyo ñu'u' Galilea?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Va na yüvi takan kùu yi. Ta tu ndyo'o töve kùuni ndo ndakoo ndo kuati jà'a ndo ta ki'vi ndo ku'un ndo iti' Ndioo, ni naa ndo indukuni takua nāa ndiakan. ");
INSERT INTO mza_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿A chàku'uni ndo naja kua kēkoyo ma torri ña nàni Siloé ma ora ña kāchi'í cha'un uni ta'an ñivi jā'a yi? Ta, ¿a ndē'e na tundo'o cha'a' ña chīyo ga kuati na kua ma ñivi chīyo ma ñuu Jerusalén?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na yüvi takan kùu yi. Ta tu ndyo'o töve kùuni ndo ndakoo ndo ma kuati jà'a ndo ta chìkoni'i ndo chi'in Ndioo indukuni ni naa ndo takua nāa na ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Takan kūu tajan te'en nāka'an tuku Jesuu chi'in na: ―Tatiempu chīyo iin ra tāchi iin yutun higu ma ñu'u' ra. Tajan rakan chā'an ra chānde'e ra tuva cha chà'a run chiti, va tüvi nī nata'an ra nï'iin vu nuu run. ");
INSERT INTO mza_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yakan va te'en nāka'an ndio ra chi'in ma ra musu ña jàkuenda ma ñu'u' ra: “Cha uni kuiya kùu yi ña kīchi̱ nde'i run ta tükuii nde'i nï'iin chiti run. Va'a ga na ka'ndaun run ti jàtañu ka'a ni run nuñu'u' ta töve na chà'a run”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tajan te'en nāka'an ndio ma ra musu ra chi'in ra: “Yo'o racha'nu, na ndakoun run jin tu iin kuiya i'yania, vati ni jalanguai ñu'u' cha'a run ta ni tain abono, ");
INSERT INTO mza_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","nde'o tu takan ku'va run chiti. Ta tu küuni run tajan ni ka'nda ndioi run”, kàti ra chi'in ma ra chà'nda tiñu nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iin kivi nindeo ndaa Jesuu jàna'a ra nuu ñivi tichi veñu'u ñivi judíu. ");
INSERT INTO mza_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta ma tichi veñu'u ikan ndaa iin ña cha ìyo cha'un uni kuiya ña ku'vian jà'a ña ti'i chata ña, vati iin tati xaan kùu yi ña jàti'i yi ña ña endee küu kundaa va'a ña jà'a yi. ");
INSERT INTO mza_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Takan kūu ta ora ndē'e ma Jesuu ña, tajan kāna ra ña ta te'en kīcha'a ra kà'an ra chi'an: ―Vitin va cha ndā'un ―kàti ra chi'an. ");
INSERT INTO mza_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tajan jūndii ra nda'a' ra chata ña, ta ma ora ikani chūndaa va'a ña ta ndā'a ña jà'a ra, tajan kīcha'a ña jàka'nuan Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Va ma ra chà'nda tiñu ma veñu'u ikan, nduva'a kūxaan ra ña jānda'a ma Jesuu ña iin kivi nindeo. Tajan rakan te'en nāka'an ra chi'in ma ñivi ka'ìin ikan: ―Ìyo iñu kivi ña jàtiñu yo ta'ii'iin jamana, na kichi nda'a ndo ma kivi ikan, ta töve na ja'a ndo ña kichi ndo nduku ndo ña nda'a ndo ma kivi nindeo ―kàti ra chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Ndyo'o ndian uvi nuu, ¿a tüvi nàsama ndo ma burru jàna ndo a jundiki jàna ndo ta chàndaka ndo ndri nuu ko'o ndri takuii ma kivi nindeo? ");
INSERT INTO mza_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Va ma ña'a i'ya kùan ñivi Abraham, ìyo yi ña nda'a ña vaji kivi nindeo kùu yi ti ma kui'na kuxini ña nàni Satanaa ña cha ìyo cha'un uni kuiya kùu yi ña jànde'e yi tundo'o ña chi'in ma kue'e ikan ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tajan ma ora kā'an Jesuu takan, ta nduva'a kuii kūkanuu ma ndian xaani ndè'e ra, va tandi'i ma ñivi ña ka'ìin ma ikan, nduva'a kuii chìsii na nde'e na ma tiñu ka'nu ña jà'a Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ta te'en nāka'an ma Jesuu: ―¿Nda chi'in induku ma nuu chà'nda Ndioo tiñu ta nda chi'in kùu jando indukui yi?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Taku ma nuu chà'nda Ndioo tiñu indukuni yi chi'in ma chiti yukú mostaza ña tàchi yo, vati chà'nu sukun yi takua kàa inga yutun na'nu ña nda saa kùu ja'a ri taka ri nuu vati soko run ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tajan te'en nāka'an ndiko ma Jesuu: ―¿Nda chi'in jàndo indukui nuu chà'nda ma Ndioo tiñu?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ma nuu chà'nda Ndioo tiñu indukuni yi chi'in ma yuchan iya ña jàkanuu ñivi ña'a chi'in kua'a' yuti ora ni ja'a vi paan, ikan na nandaa ma yuchan. ");
INSERT INTO mza_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tajan kēe ndio Jesuu kuàjana'a ra tu'un Ndioo nani ñuu ta nani kuariya ña ìyo iti' kuà'an ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tajan iin ma ra ndaa ma ikan te'en kīcha'a chìkatu'un ra nuu Jesuu: ―Yo'o Racha'nu, ¿a tiani ma ñivi kùu ma ndian jàkakú Ndioo?, kùuniun ―kàti ra. Tajan te'en nāka'an Jesuu: ");
INSERT INTO mza_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Jani'i ndo ta kùu ki'vi ndo ma yuve'e tuu, vati yu'u kàti chi'in ndo ti kua'a' na ni kuuni na ki'vi na, va na küu yi ti ya'a tuu yi. ");
INSERT INTO mza_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tajan ora ndòto ndio ma ra chito'o ma ve'e ta chāsi ndio ra yi, ta ndyo'o ndian ni ndoo iti' chata ve'e, te'en ni ka'an ndo chi'in ra: “Yo'o racha'nu na nunaun yuve'e nuu ndi”, ni kati ndo. Ta rakan ni kati ra: “Na töve nàkotoi ndo ta ni töve chìtoi ndanu kīchi ndo”, ni kati ra. ");
INSERT INTO mza_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ta ikan jan te'en ni kicha'a ndio ndo ka'an ndo: “Cha chāchi ndi ta chī'i ndi chi'un, ta jāna'un nuu ndi ma kai nuu ìyo ndi”, ni kati ndo. ");
INSERT INTO mza_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ta rakan te'en ni naka'an ra chi'in ndo: “Na tüvi chìtoi ndanu kīchi ndo, yakan va na kesiin ndo xii̱n ta na ku'un ndo ti mamaa ndian kini kùu ndo”, ni kati ra. ");
INSERT INTO mza_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tajan ikan ni kuaku ndo ña ndava nda nu'u ndo ni kari'u ora ni nde'e ndo ma Abraham, Isaac ta Jacob chi'in tandi'i inga ndra kà'an chi'in tu'un yu'u Ndioo ña ka'ìin ndra nuu chà'nda Ndioo tiñu. Ta ndyo'o ti java chata ve'e ni kindoo ndo. ");
INSERT INTO mza_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vati ora ikan ni kichi kua'a' ñivi ìyo ninii ka'nu ñu'u ñuñivi, ña ni kuiin na kachi na chi'in Ndioo nuu chà'nda ra tiñu. ");
INSERT INTO mza_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yakan va kua'a' ndian kùu ma ndian nuu ndi'inia vitin, ni kuu na ndian nunuu. Ta kua'a' ndian kùu ma ndian nunuu vitin, ni kuu na ndian nuu ndi'inia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Takan kūu tajan juuni ma ora ikan, chāa iin ndra fariseu nuu ndaa Jesuu. Ta ndrakan te'en nāka'an ndra chi'in ra: ―Na ku'u̱n inga chiyo ti Herode kùuni ra ka'ni ra ñu̱n ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tajan Jesuu te'en nāka'an ndio ra chi'in ndra: ―Na ku'un ndiko ndo nuu ndaa ma rakan ña ya'a vata ta katitu'un ndo nuu ra, ti vitin ta itaan kùu yi ña ni tavani'i̱ tati xaan ndiso ñivi ta ni janda'i ñivi ku'vi ndia, ta nda isaa kùu yi ña ni chinu jà'i yi, kàti ndo chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yakan va ìyo yi ña ku'in ma iti' i'ya vitin, itaan ta isaa, vati na vä'a kuvi iin ra kà'an chi'in tu'un yu'u Ndioo inga ñuu tuva yüvi ñuu Jerusalén kùu yi. ");
INSERT INTO mza_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nda'vi ta'an ndyo'o ñivi ìyo ñuu Jerusalén, ña endee chà'ni ndo ndra kà'an chi'in tu'un yu'u Ndioo, ta juuni endee jàndikun ndo ta chà'ni ndo chi'in yuu tandi'i ndra tāchi Ndioo ña kàtitu'un ndra tu'un ra nuu ndo. Vati yu'u nduva'a kua'a' cha'a' kūuni̱ tindei ndo nuu ma tundo'o takua jà'a tiatan' chi'in tiun kuati se'e ri ña tìxe'e ri ndri tichi ndichin ri. Takan kūuni̱ ja'i chi'in ndo niku va nī kuuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yakan va yu'u kàti̱ chi'in ndo vitin ti na tüva ni koo Ndioo chi'in ndo ñuu ndo, ta tüva ni nde'e ndo yu'u ndia, nda kati keta ma kivi ña ìyo yi ña ka'an ndo te'en nui: “Ya'a ií ra vàchi chi'in sivi Racha'nu Ndioo”, ni kati ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Takan kūu tajan iin kivi nindeo, chā'an Jesuu chākachi ra ve'e iin ra chà'nda tiñu nuu ñivi fariseu. Va inga ma ndian fariseu ka'ìin ma ikan jàkuenda na Jesuu, ");
INSERT INTO mza_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","nde'o tu janda'a ra iin raku'vi jà'a kuiñu ña ndaa yatini nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tajan te'en kīcha'a chìkatu'un ndio Jesuu nuu ma ndra matru jàkua'a tutu Ndioo chi'in nuu ndra fariseu: ―¿Naja kua kati ma tutu ley Ndioo, a va'a ña jànda'a yo ndian ku'vi ma kivi nindeo, a vä'a? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Va taxiin kìndoo ndra. Ta ikan jan jūndii ndio Jesuu nda'a' ra chata ma ra kù'vi, tajan ndā'a ndio ra jā'a ra. Ta kà'an ndio Jesuu chi'in ra ña na ku'un ra ve'e ra. ");
INSERT INTO mza_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Takan kūu tajan te'en nāka'an ndio Jesuu chi'in ma ndra fariseu: ―Taku ndyo'o ndra fariseu, ¿a tüvi tàva ndo jundiki a burru jàna ndo ma tichi soko ka'nu ma ora kòyo ndri ma tichi yi ma kivi nindeo?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Va ora kā'an Jesuu takan chi'in ndra, endee tükuii nani kà'an ndra. ");
INSERT INTO mza_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ta ora ndē'e Jesuu ña kàchin na tayu ka'nu tiá ña kùnandi na yu'u mesa nuu ìyo viko tanda'a, tajan te'en jākuninaa ra na chi'in tu'un i'ya: ");
INSERT INTO mza_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ora ìyo iin ndian jàmvitaa ndo nuu ìyo viko tanda'a, na künandi ndo tayu ka'nu tiá ña ndaa ikan, ti koto chaa iin ra jàmvitaa na ña ka'nuga kua ndyo'o, ");
INSERT INTO mza_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ta ora ni nde'e ma ra jainvitaa ndo ra, ta rakan te'en ni ka'an ndio ra chi'in ndo: “Na kundachiyo ndo nuu tayu chiña ti ni kunandi inga ra'ya”, kàti ra chi'in ndo. Ta ndyo'o ìyo yi ña kundachiyo ndo ikan, vaji kanuu ndo. Ta ku'un ndio ndo kukunandi ndo tayu ka'ìin nuu ndi'inia. ");
INSERT INTO mza_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yakan va ora jàmvitaa na ndo, na kunandi ndo ma tayu ka'ìin nuu ndi'inia, tajan ora ni nde'e ndio ma ra jāinvitaa ndo ndo, tajan te'en ni ka'an ndio ra chi'in ndo: “Ndyo'o meru, na ku'un ndo kukunandi ndo ma tayu ka'nuga ña ndaa ndakan.” Tajan ora ni kuni ma ndian ka'ìin xiin ndo ña kà'an ra chi'in ndo, ta ni tiñu'u ndio na ndo. ");
INSERT INTO mza_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Vati ma ndian chàta'ani jaka'nu juuni maa', ndiakan Ndioo ni jakukanuu ra na. Va ma ndian jànda'vi juuni maa', ndiakan ni jaka'nu Ndioo na. ");
INSERT INTO mza_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Takan kūu tajan te'en nāka'an Jesuu chi'in ma ra jā'a viko ikan: ―Ora ni ja'un iin viko ka'nu, na jämvitaun ni merun ni ñiviun ni ndra yaniun, ta ni ndian kuika ndia. Vati tu takani jà'un, ni ka'nda ndiko na kuenda nuu̱n, ora ni jainvitaa na ñu̱n ña ku'un iin viko ña ni ja'a na tiá iti' nuu. ");
INSERT INTO mza_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yakan va ora ni ja'un iin viko, va'a ga ña jainvitaaun ma ndian nda'vi chi'in ndian ku'vi ndian kuaá ta chi'in ndian koxo. ");
INSERT INTO mza_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tu takani jà'un nduva'a kuii sii ni kuuniun cha'a' ma ña jā'un chi'in na, ti vaji na küu ku'va ndiko na ma ña chā'un nuu na, va ora ni nataku ndiko ma ndian va'a, Ndioo ni ku'va ra ña ka'nu nuu̱n cha'a' ma ña jā'un kuenda na. ");
INSERT INTO mza_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Takan kūu ta iin ma ra nàndi yu'u mesa, te'en nāka'an ra chi'in Jesuu: ―Na sii kuuni ndian ni ku'un kachi chi'in Ndioo nuu chà'nda ra tiñu ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tajan Jesuu te'en nāka'an ra iin ku'va nuu ra: ―Iin ra chīyo taji'na, jà'a ra iin viko ka'nu. Ta rakan ti tāchi ra ma ra musu ra ña na ku'un ra kujainvitaa ra kua'a' ñivi. ");
INSERT INTO mza_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Takan kūu ta ora cha ìyo va'a tandi'i ma ña ni kachi na, tajan tāchi ndiko ra ma ra musu ra ña na ku'un ra kujandakutu'un ra ma ñivi jāinvitaa ra ña na kichi na ti cha ìyo va'a yi. ");
INSERT INTO mza_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Va ta'ii'iin ndiakan kātitu'un na ña ìyo inga tuku tiñu ni ja'a na. Taku ora chāa ndio ra nuu ìyo ma ra nunuu, te'en nāka'an ra chi'in ma ra musu ikan: “Na küu ku'in ti já jātai iin ñu'u', ta ìyo yi ña ku'in kunde'i yi. Yakan va chìkain ñamani nuu̱n ña na ka'nu kooniun ti na küu ku'in”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta inga tuku ra va te'en nāka'an ra chi'in ma musu: “Já jātai u'un ta'an yunta, ta ìyo yi ña ku'in kuki'in ku'va ndri nde'o tu va'a jàtiñu ndri. Yakan va chìkain ñamani nuu̱n ña na ka'nu kooniun ti na küu ku'in”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta ma inga ra te'en nāka'an ra chi'in ra: “Já tānda'i, yakan va ka'nu kooniun ti na küu ku'in”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Takan kūu tajan chīkoni'i ndiko ma musu kuà'an ra nuu ìyo ma ra chà'nda tiñu nuu ra. Ta kātitu'un ndi'i ra yi nuu ra. Va nduva'a kuii kūxaan ra, tajan te'en nāka'an ndio ra chi'in ra: “Na ku'u̱n kunanduku̱n vaji ndian nda'vi chi'in ndian cha'a pe'lu chi'in ndian kuaá a ndian kukue'e nda ni kuuni ma iti' kai, ta nda yu'u ñuu ndia. Ta kundakaun na kichi na nde've chi'un”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Takan kūu ta nunuuni te'en nāka'an ndiko ra chi'in ma ra chito'o ra: “Yo'o racha'nu, cha jā'i ma ña kātitu'u̱n nui, ta juuni takä'an kutu ma tichi ve'e”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tajan te'en nāka'an tuku ma ra chito'o ra chi'in ra: “Na ku'un ndikoun kunanduku̱n tiá ma ndian nda'vi ña jàtiñu iti' tichi ku'u ta na janiniun inga ñivi ña na kichi na chi'un ma ve'i, ikan na kutu yi”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yakan va yu'u, kàti nuu ndo ti nï'iin ma ndian jāinvitai ma nunuu na küu ga kachi na ma ña jā'i ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Takan kūu tajan nduva'a kuii kua'a' ñivi chàkunuu chi'in Jesuu. Ta ikan jan te'en nāka'an ndio ra chi'in na: ");
INSERT INTO mza_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tu ìyo iin ndian kùuni ki'vi iti' kuà'in, ìyo yi ña kuuniga na nde'e na yu'u kua kùuni na nde'e na tatá na, ma'á na, ñasi'i na, se'e na, yani na ñivi ta'an na, ta naani na ña kùuni na nde'e na juuni maa na. Takan ìyo yi ña ja'a na ta kùu kuu na ndian jàkua'a chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tu ìyo iin ma ndian töve va'a ña ku'un na iti' kuà'in vaji ndava ìyo yi ña kuvi na cha'i, na küu kuu na ndian jàkua'a chi'i̱n ndia. ");
INSERT INTO mza_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ta tu ìyo iin yo kùuni ja'a iin ve'e, ji'na ìyo yi ña tavani'i ji'na ndo kuenda ta ikan nde'e ndio ndo tu keta ma xu'un' ndo, tajan ja'a ndio ndo yi. ");
INSERT INTO mza_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta indukuni kùu yi tu cha kīcha'a ndo jà'a ndo ma cha'a ve'e, ta na këtaga ma xu'un' ndo ña jàchinu ndo yi, ni kuakú ndaa ma ñivi ndo chi'in tu'un i'ya: ");
INSERT INTO mza_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Nde'e ndo naja kua kàa ve'e kundu ña jàva'a rakan, ti nī chinu jà'a ra yi”, kàti na. ");
INSERT INTO mza_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ta juuni tu ìyo iin ra kùu rey ña kùuni ra kanita'an ra chi'in inga rey ña chà'nda tiñu inga ñuu, va iin rey ìyo uchi mii jandaru ra ta inga ra ìyo oko mii jandaru ra, ¿a tüvi ìyo yi ña kunandi ra ja'a ji'na ra kuenda, nde'o tu kùu kanita'an ra chi'in ma ra kùu rey ña vachi chi'in oko mii jandaru?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta tu küu ja'a ma ra kùu rey ña ìyo uchi mii jandaru kanita'an ra chi'in ra, kuuni ra, tajan ni tachi ndio ra uvi uni ma ndra tatun ra na kujandondaa ndra tiñu nuu inga ma ra kùu rey ora juuni vàchi chikaga ra chi'in ma jandaru ra ña na tüva kanita'an ndra. ");
INSERT INTO mza_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yakan va tu küu ndakoo ndo ndisaa ma ña ìyo nuu ndo, ta küu kuu ndo ma ndra jàkua'a chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Yakan va taku ma ñií va'a yi, va tu naa ña u'vá yi, ta na küuga kuu u'vá yi inga cha'a'. ");
INSERT INTO mza_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma ñií ikan tüva nda kuenda yi ni kuenda ñu'u' ta ni kuenda abono tajan chàta yo yi. Yakan va ndyo'o ndian ìyo chinituni, na taso'o ndo ña kà'in ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tajan ndisaa ma ndian nàka'an xu'un' kuenda ñuu ka'nu Roma, ta inga ndian jà'a kuati cha jāyatin na na nuu nda Jesuu ña kùuni na taso'o na ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Takan kūu tajan ma ndra fariseu chi'in ndra matru jàkua'a tutu Ndioo, te'en kīcha'a ndra kà'an ndra chata Jesuu chi'in tu'un i'ya: ―Ra'ya ya'a ga chàta'ani ra ndikita'an ra kachi ra chi'in ma ndian jà'a kuati ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tajan Jesuu te'en nāka'an ndio ra iin ku'va nuu ndra: ");
INSERT INTO mza_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tu ìyo nda ndyo'o ìyo iin cientu mvechala jàna, ta jàkuanaa ndo iin ri tichi ku'u nuu chàkunuu ndo kùmi ndo ri, ¿a tüvi ndakoo ndo ndi kumi xiko cha'un kumi ndri ta ku'un ndio ndo kunanduku ndo ma kiti kuànaa nda kati nata'an ndo ri?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta ora cha nāta'an ndio ndo ri, tajan nduva'a kuii chìsii ndio ndo ña ndava chìso chata ndo ri. ");
INSERT INTO mza_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ta ora chàa ndio ndo ve'e ndo, tajan jàti'vi ta'an ndo ndian nàkoto ndo ta ndian ìyo yatin xiin ve'e ndo, ta te'en nàka'an ndio ndo chi'in na: “Na sii kuunio ti ma mvechala jànai ña kuànaa jā'i cha nāta'an ndikoi ri”, kàti ndo chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yu'u kàti ti indukuni kua ikan kùu yi chi'in iin ndian jà'a kuati tuva ndàkoo na ma ña jà'a na ta ki'vi na iti' Ndioo. Nduva'a kuii sii ni kuuni Ndioo ìyo andivi cha'a' ra kua cha'a' inga kumi xiko cha'un kumi ñivi ña tüva chiniñu'u na ki'vi na iti' Ndioo, ti ñivi va'a kùu na kùuni na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Takan kūu tajan te'en nāka'an tuku Jesuu chi'in na: ―Taji'na chīyo iin ña ìyo uchi ta'an xu'un' kaa nuu, ta jākuanaa ña iin yi. Yakan va ma ña jā'a ña kùu ña tāa ña iin ñu'ú kandil ma tichi ve'an, ta kīcha'a ña nàti'vian nda kati nata'an ña yi. ");
INSERT INTO mza_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tajan ora cha nāta'an ña yi, tajan jāti'vi ta'an ña ndisaa ma ndian nàkotoan chi'in ndian ìyo xiin ve'an, tajan te'en kīcha'a ndioan kà'an ña chi'in na: “Na sii kuunio ti cha nāta'in ma xu'un' ña kuànaa jā'i”, kàtian. ");
INSERT INTO mza_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yakan va yu'u kàti̱ chi'in ndo ti juuni nduva'a kuii sii ni kuuni ndian tati jà'a tiñu nuu Ndioo ora ndakoo iin ra kuati jà'a ra ta chìkoni'i ra iti' Ndioo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Takan kūu tajan te'en nāka'an tuku Jesuu iin ku'va nuu na: ―Taji'na chīyo iin ra ìyo uvi ta'an ndra se'e ra. ");
INSERT INTO mza_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tajan ma rayoko tiá te'en nāka'an ra chi'in ma tatá ra: “Yo'o tatá, kùuni̱ ña ku'vaun ma ndatiñu ña ìyo yi ña ndaki'i̱n”, kàti ra. Tajan ma tatá ndra nāta'vi ra ma ndatiñu ra nuu ninduvi ndra. ");
INSERT INTO mza_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tajan chāa ndio iin kivi ña xìko ndio ma ra tivaa tiá ma ndatiñu ra. Ta chi'in ma xu'un' nī'i ra ña xīko ra yi kēe ra kuà'an ra iin ñuu nuu chika ña endee ndī'i ma xu'un' ra jānaa ra ti tüvi nī chito ra kumi ra yi. ");
INSERT INTO mza_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ta ora cha ndī'i ndio ma xu'un' jānaa ra, tajan nduva'a kuii chīyo iin tama' nuu ñuu ikan ta yā'a ndio ra soko. ");
INSERT INTO mza_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tajan kuà'an ndio ra kuànanduku ra tiñu jà'a ra nuu iin ma ra ìyo ikan. Ta ikan jan rakan tāchi ndio ra ra na ku'un ra kujakuenda ra kini jàna ra ña ka'ìin iti' tichi ku'u. ");
INSERT INTO mza_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta rakan ti ya'a chìsoko ra ña ndava kùuni ra kachi ra ña kini chàchi ndri ta tüvi nda yo chà'a yi nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tajan chā'a ndio ra kuenda ña te'en kīcha'a ra chànini ra chi'in juuni maa ra: “Ta ndisaa ndra musu jàtiñu chi'in tatá yo, ndava chàkoso ndayu chàchi ndra, ta maa yo i'ya ndava chì'o soko ña tüvi ni'o ña kacho.” ");
INSERT INTO mza_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yakan va chānini ra: “Va'a ga chikoni'i ndiko yo ve'e ma tatá yo ta te'en kà'an yo nuu ra: Yo'o tatá, cha chìtoi ti iin kuati ka'nu kùu ma ña jā'i chi'un ta chi'in Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yakan va na kuàtiñun yu'u takua chàtiñu ma ndra kùu musu̱n ta tüva ìyo yi ña ka'un ña ra se'un kùi.” Takan chānini ra ña ni ka'an ra chi'in ma tatá ra. ");
INSERT INTO mza_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tajan chīkoni'i ndio ra kuà'an ra iti' ve'e ma tatá ra. ’Tajan ora ndē'e ma tatá ra ña yatinia vàchi ra, tajan nduva'a kuii kūnda'vini ra se'e ra ta kāndakunu ndio ra chāta'an ra nuu ra, ta ikan kāña'a ra chi'in ma se'e ra ta chūnumi ndaa ra ra. ");
INSERT INTO mza_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Takan kūu tajan te'en nāka'an ndio ma ra se'e ra chi'in ra: “Yo'o tatá, cha chìtoi ti iin kuati ka'nu kuu ma ña jā'i chi'un ta chi'in Ndioo ndia. Yakan va tüva ìyo yi ña ka'un ña ra se'un kùi”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Va ma tatá ra te'en nāka'an ra chi'in ma ndra kùu musu ra: “¡Numini kuki'in ndo ma ja'ma va'a ga ta na jaku'un ndo yi ra! Ta juuni na kunda'a ndo iin xe'e ta ti'i ndo yi nda'a' ra chi'in ndichan ña kundii cha'a ra. ");
INSERT INTO mza_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ta juuni na kuki'in ndo iin jundiki vali ta ndu'u ga ta ka'ni ndo ri, ti ni ja'i iin viko ka'nu ta ni kacho, ");
INSERT INTO mza_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","vati ma ra se'i ña kīchaa vitin kùu ra takua kùu iin ra cha chī'í kuendai va vitin cha nātaku ndiko ra, cha jākunai ra ta vitin cha nāta'an ndikoi ra.” Takan kūu ta ora chīnu kà'an ndio ra takan tajan kīcha'a ndio ndra jà'a ndra viko kuenda ra. ");
INSERT INTO mza_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ta ora chāa ma ra chava'a se'e ra ña jàtiñu tichi ku'u yatini ma nuu ìyo ve'e, tajan ikan chīni ra ña chìta ma yaa ta tàcha'a na, ");
INSERT INTO mza_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ta ikan jan kāna ra iin ma ra musu ma tatá ra, tajan chīkatu'un ndio ra nuu ra ña nayi kuu ma nuu ìyo ve'e. ");
INSERT INTO mza_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tajan te'en nāka'an ndio ma ra musu ikan chi'in ra. “Ma ra yaniun cha kīchaa ndiko ra. Yakan va ma tatáun tāchi ra ña na kutiin ndra ma jundiki vali ta ndu'uga ta chā'ni ndra ri ti ma ra yaniun kīchaa ndito ra”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Va ma ra yani ra chava'a nī kuuni ra ki'vi ra ma tichi ve'e ti ya'a kàyuni ra. Yakan va ma tatá ra kēe ra ma tichi ve'e ta chājanini ra ra ña na ki'vi ra ma tichi ve'e nuu ìyo ma viko. ");
INSERT INTO mza_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tajan te'en nāka'an ndio ra chi'in ma tatá ra: “Yo'o tatá, cha chìto va'un ti cha ya'a kua'a' kuiya kùu yi ña jàtiñui chi'un, ta ndisaa ma ña kà'un chi'i̱n jà'i yi, ta tükuii nda ora kuva'un vaji iin tixu'u vali nui ña jà'i iin viko chi'in ma ndra amigui. ");
INSERT INTO mza_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ta vitin kīchaa ma ra se'un ña chājanaa ka'ani xu'u̱n' chi'in ñivi ña'a tondo, ta cha'a' rakan chā'niun ma jundiki vali ña ndu'uga ña ìyo nuu̱n.” Takan kàti ra chi'in ma tatá ra. ");
INSERT INTO mza_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Tajan ma tatá ra te'en nāka'an ndio ra chi'in ra: “Yo'o se'yu, cha chìtoi ti ndisaa tiempu ìyoun chi'i̱n, yakan va tandi'i ma ña ìyo nui juuni ña'un kùu yi ndia. ");
INSERT INTO mza_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Va vitin iin ña va'a kùu yi tu ja'a yo iin viko. Ta sii kuunio ti ma ra yaniun kùu ra takua kùu iin ra cha chī'í kuenda yo va vitin cha nātaku ndiko ra. Cha jākunaa yo ra niku va vitin cha nāta'an ndiko yo ra.” Takan kàti ma tatá ra chi'in ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Takan kūu tajan te'en nāka'an Jesuu chi'in ma ndra jàkua'a chi'in ra: ―Taji'na chīyo iin ra kuika, ta rakan ti juuni chīyo iin ra chà'nda tiñu nuu ma ndra kùu musu ra ndia. Ta ikan jan ìyo iin yo chākatitu'un nuu ma ra kùu chito'o ma ra kùu musu ña chà'nda tiñu, janaa ka'ani ra xu'un' ra. ");
INSERT INTO mza_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ta ikan jan kāna ndio ma ra chito'o ra ra ta te'en nāka'an ra chi'in ra: “Cha chìtoi ti yöve tiñu ndaa kùu ma ña jà'un kuendai. Yakan va na ja'a yo kuenda cha'a' ma tiñu jā'un ti tüva ni jatiñu̱n kuendai”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tajan te'en kīcha'a ndio ma ra musu ra chànini ra ora kā'an ra takan chi'in ra: “¿Naja kua ja'a yo ña ma ra kùu chito'o yo tāva ra yo tichi tiñu jà'a yo i'ya, ta tüvi ñàndeo ña jàtiñu yo nuu ma ñu'u', ta kànuu yo ndakan yo tunda'vi ve'e ñivi? ");
INSERT INTO mza_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aan, cha chìto yo nayi ni ja'a yo ora ni kindaa ma ra chito'o yo tiñu jà'a yo, ikan na ku'va ñivi na koo yo ve'e na”, kùuni ra. ");
INSERT INTO mza_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tajan kāna ndio ra ta'ii'iin ma ndian tàvi nuu ma chito'o ra. Ta ora chāa ndio na nuu ra, tajan te'en chīkatu'un ndio ra nuu iin ma ra tàvi nuu ma chito'o ra: “¿Naja tàviun nuu ma chito'i?”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tajan te'en nāka'an ra chi'in ra: “Tàvi̱ iin cientu litru cete nuu ra”, kàti ra. Tajan te'en nāka'an tuku ma ra musu kuxini ikan chi'in ra: “I'ya ìyo ma tutu cha'a' ma ña tàviun, na kunandiun ta taun nuu yi ña tàviun uvi xiko uchi nia. Ta takan ta'nda ma kuendaun”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tajan te'en chīkatu'un tuku ra nuu inga ma ra tàvi: “¿Ta yo'o, naja tàviun nuu ra?”, kàti ra. Tajan te'en nāka'an ra chi'in ra: “Tàvi̱ iin cientu karia trigu nuu ra”, kàti ra. Tajan te'en nāka'an ndio ma ra musu kuxini chi'in ra: “I'ya ìyo ma tutu cha'a' ma ña tàviun. Na kunandiun ta taun ña tàviun kumi xikonia nuu ra, ta takan ta'nda kuendaun”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tajan ma ra kùu chito'o ma musu kuxini ña töve va'a jàtiñu, chā'a ra kuenda ña ya'a yati jàtiñu ma ra musu ikan kuenda juuni maa ra, vati tiá yati ma ndian ñuñivi nde've jàtiñu na kuenda juuni maa na kua ma ñivi chìnuni tu'un Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Yakan va yu'u Jesuu, kàtitu'in nuu ndo ña na kuàtiñu ndo ma ña kuika ndo ña töve va'a ña ìyo ma ñuñivi i'ya, ikan na kùu ni'i ndo amigu ndo. Ta ora ndi'i ma ña kuika ndo kuu ni'i ndo inga ra kùu tindee ndo nuu ni koo ndo endeeni iti' andivi. ");
INSERT INTO mza_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yakan va tu jàtiñu va'a yo ma tiñu ta'ani ña chà'a ma chito'o yo nuu yo indukuni ni jatiñu va'a yo kuenda ra ora ni ku'va ra ma tiñu ka'nuga nuu yo. Va tu töve jàtiñu va'a yo ora chà'a ra ma tiñu ta'ani nuu yo, indukuni töve ni jatiñu va'a yo tu ku'va ra iin tiñu ka'nuga nuu yo ndia. ");
INSERT INTO mza_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yakan va tu töve jàtiñu va'a ndo chi'in ma ña kuika ndo ña ìyo chi'in ndo ma ñuñivi i'ya, juuni töve ni ku'va Ndioo ma ya'vi ka'nu nuu ndo iti' andivi, ti töve ìyo tundeeni ra chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ta tu töve jàtiñu va'a ndo chi'in ma tiñu tatu chā'a na nuu ndo ma ñuñivi i'ya, indukuni töve ni ku'va Ndioo ña koo ña'a maa ndo ndia. ");
INSERT INTO mza_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ta juuni na küu ja'a iin ra musu tiñu nuu uvi ndra kùu chito'o ra, ti ni kuuni ra nde'e ra iin ra ta ni kuxaani ra nde'e ra inga ra. Yakan va na küu jachi'in ra ña kà'an iin ra ta ja'a ra ña kà'an inga ra, ti töve indukuni chànini ndra. Ta juuni na küu kuunio nde'o Ndioo tuva kùunio nde'o ma xu'un' ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ta takua ma ndra fariseu ya'a kùuni ndra nde'e ndra ma xu'un', yakan va ora chīni ndra ña kā'an Jesuu ndisaa ma tu'un i'ya, tajan kīcha'a ndra chàtu'un ndra Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Va Jesuu te'en nāka'an ra chi'in ndra: ―Ndyo'o kùu ma ndian jà'ani ndo ña kùu ñivi va'a nuu nde'e tandi'i ñivi, va Ndioo takua cha chà'a ra kuenda naja kua chànini ndo, ña jàka'nu ndo ma ña ìyo nuu ndo, yakan va Ndioo ya'a xaani ra ndè'e ra ma kuàja'a ndo. ");
INSERT INTO mza_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Nda tiempu kēta Xuva takani cha ìyo ma Ley tāa Moisés chi'in ma tutu Ndioo ña kàti yi naja kua kùuni Ndioo ña jà'a yo. Nda ora ikan, kàtitu'un ndi tu'un va'a Ndioo ña jàna'a yi ña cha chāta'an nuu chà'nda ra tiñu. Ta vitin ya'a ga kua'a' ñivi nànduku na naja kua kuu ki'vi na nuu ìyo ra. ");
INSERT INTO mza_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yakan va yu'u kàti chi'in ndo ti taku andivi ta ñu'u' ñuñivi ni naa yi, va ma tu'un kà'an nuu ma tutu Ndioo töve ni naa yi, nda kati jachinu ji'na yi ma ña kà'an yi. ");
INSERT INTO mza_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Taku tu iin ra'ii ndàkoo ra ñasi'i ra ta tànda'a ra chi'in inga ña'a, iin kuati jà'a ra kuenda Ndioo. Ta ma ra tànda'a chi'in iin ña'a ña cha ndākoo ii, juuni iin kuati kùu yi ndia. ");
INSERT INTO mza_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Taji'na chīyo iin ra kuika ña chāku'un ra ja'ma ya'a va'a ta ya'vi. Ta rakan ti tandi'i kivi jà'a ra viko ta nduva'a vii jàkutu ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta juuni chūnandi iin ra nda'vi ña nàni Lázaru ma nuu ñu'u' yuve'e ra. Ta rakan iin ra ya'a kua'a' ndi'i lakua ìyo kuñu ra. ");
INSERT INTO mza_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ta ma ra ndà'vi i'ya chùnandi ra ikan ti kùuni ra kachi ra ma che'e yu'u ma ra kuika ña chìta xuu mesa. Ta nda ma ina cha jàyatin ndri ndri nuu nàndi ra ña yùvi ndri nuu ma ndi'i kàa ra. ");
INSERT INTO mza_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Va kēta iin kivi ña chī'í ma ra nda'vi ikan. Ta ma ndra kùu tati jà'a tiñu nuu Ndioo ndàka ndio ndra ra kuà'an ndra nuu ni koo ra chi'in racha'nu Abraham ma andivi. Takan kūu ta chāa iin kivi ña juuni chī'í ma ra kuika, ta kūchi na ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Ta ora ndè'e ndio ma ra kuika tundo'o ma andaya', ta ikan jan ndōni'i ra nuu ra ta chika ndē'e ra ña ndaa Lázaru chi'in Abraham ma andivi. ");
INSERT INTO mza_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ta ikan jan te'en kānachaa ni'i ra: “Yo'o tatá Abraham, na kunda'viniun yu'u, ta tachiun ma Lázaru na jatii ra xini nda'a' ra chi'in takuii ta kichi janani ra yi nuu yai, ikan na ndovichin yi, vati ya'a ndè'i tundo'o tichi ñu'ú i'ya”, kàti ma ra kuika. ");
INSERT INTO mza_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tajan te'en nāka'an ndio ma Abraham chi'in ra: “Yo'o se'yu, na kuku'uniun ña ma nuu ñu'u' ñuñivi nuu kīchiun, nduva'a kuii va'a chīyoun, ta Lázaru ti mamaa tunda'vini chākunuu ra. Ta vitin chìsii ra ìyo ra i'ya, ta yo'o ndè'un tundo'o. ");
INSERT INTO mza_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ta juuni ìyo iin xa'va ka'nu ma'ñu yo, ña ni ma ndian ka'ìin i'ya na küu keta chiyo na iti' chiña, ta ni ndian ka'ìin chiña na küu keta chiyo na iti' te'en ndia”, kàti Abraham. ");
INSERT INTO mza_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Tajan te'en nāka'an tuku ma ra kuika chi'in ra: “Tu takan kùu yi chìkain inga ñamani nuu̱n, yo'o tatá Abraham, ña na tachiun ma Lázaru na ku'un ra ñuñivi nuu ìyo ma tatái, ");
INSERT INTO mza_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","vati ma ikan ìyo u'un ta'an ndra yani̱, na katitu'un ra nuu ndra na chikoni'i ndiko ndra chi'in Ndioo, koto nde'e ndra tundo'o takua ndè'i tundo'o i'ya”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tajan te'en nāka'an Abraham chi'in ma ra kuika: “Cha ìyo tutu Ndioo tāa Moisés chi'in ndra ta juuni ìyo tu'un tāa ma ndra kà'an chi'in tu'un yu'u Ndioo ndia, ndisaa ña kà'an nuu tutu ikan, na jakua'a ndra yi ta jachi'in ndra ña kà'an yi”, kàti Abraham. ");
INSERT INTO mza_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tajan te'en nāka'an ndio ma ra kuika chi'in ra: “Ndicha ña takan kùu yi yo'o tatá Abraham, va tu nataku ndiko iin ra ndií, ta keta ra ka'an ra nuu ndra, ni chinuni ndra ta jaña ndra ma kuati jà'a ndra”, kàti ma ra kuika chi'in ma Abraham. ");
INSERT INTO mza_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Va ma Abraham te'en nāka'an ra chi'in ra: “Tu töve jàchi'in ndra ma tu'un tāa ma Moisés chi'in tu'un tāa ndra kā'an chi'in tu'un yu'u Ndioo chīyo taji'na, indukuni töve ni jachi'in ndra ma ña kà'an iin ra ndií tuva nataku ndiko ra ta keta ra nuu ndra.” Takan kàti ma Abraham chi'in ma ra kuika ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Takan kūu tajan te'en nāka'an Jesuu chi'in ma ndra jàkua'a chi'in ra: ―Taku ma nuu ñu'u' i'ya ya'a ga ìyo kua'a' ma ndian jà'a kuati, va nda'vi ta'an ma ra jàna'a ma kuati nuu inga na vati ni nde'e ra tundo'o. ");
INSERT INTO mza_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Va'a ga tuva ku'ni na iin yuu mulinu sukun ra ta jaku'un na ra tichi tañu'u, koto jana'a ra kuati nuu ma ndiakuati i'ya. ");
INSERT INTO mza_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yakan va na ja'a ndo kuenda nuu ndo. Tu iin ndian ta'an ndo ja'a na kuati chata ndo, na ka'an ndo chi'in na ti yüvi ña va'a ma ña jà'a na. Ta tu jachi'in na ma ña kà'an ndo, ta ìyo yi ña jaka'nuni ndo ma kuati na. ");
INSERT INTO mza_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ta tu ucha cha'a' jà'a na kuati chata ndo iin kivi ta ucha cha'a' kuàka'an na nuu ndo ña na jaka'nuni ndo ma kuati na ti tüva ja'a na yi, ta ìyo yi ña jaka'nuni ndo na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Takan kūu tajan te'en kīcha'a kà'an ndio ma ndra tatun Jesuu nuu ra: ―Na tindeun ndi, ikan na chinuni ndi tiá ma tu'un Ndioo ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tajan te'en nāka'an ndio ma Jesuu iin ku'va chi'in ndra: ―Tu chìnuni ndo vaji ita'vi takua ndi'i ma chiti yuku mostaza, kuu ka'an ndo chi'in yutun morera nda ikan: “Ña kundachiyoun chiña ta ku'u̱n kundaun tichi tañu'u ikan”, kàti ndo chi'in run. Ta ndicha ña ni jachi'in run ña kà'an ndo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tajan te'en nāka'an Jesuu chi'in na: ―Tu ìyo nda ndyo'o ìyo iin ra kùu musu ndo ña já kīchaa ra ña chā'an ra chāta'vi ra ñu'u' a chākumi ra mvechala jàna ndo, ¿a ni ka'an ndo chi'in ra ña na ya'a ra ta kunandi ra kachi ra?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Na töve ndicha ña ni ja'a ndo takan ti java te'en ni ka'an ndo chi'in ra: “Na ja'un ña kuxini ndi ta taun yi nuu mesa, ta nda ora chinu kachi ndi tajan kunandiun kachiun ta ko'un ndia”, ni kati ndo chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma ña ni ja'a ndo chi'in ra kùu yi ña tüvi ni ku'va ndo ta'vindioo nuu ra cha'a' ma ña jā'a ra, vati ma tiñu tāva ndo nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Taku ndyo'o ora cha jàchinu ndo ma tiñu tāchi Ndioo ña jà'a ndo, te'en ìyo yi ña ka'an ndo: “Na tüvi ìyo yi ña tiñu'u̱n ndi, ti ma tiñu jā'a ndi kùu ma ña ìyo yi ña ja'a ndi”, kàti ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ta ma tichi iti' nuu kuà'an Jesuu ma ñuu Jerusalén, yā'a ji'na ra ñu'u' Samaria chi'in ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ta chā'an ndio ra nuu kàndii iin kuariya ta ikan ndē'e ra uchi ta'an ndra ndo'o kue'e ta'yu ña ndē'e chika ndra ra. Yakan va nuu ka'ìin ndra chika, te'en kānachaa ndra ra: ");
INSERT INTO mza_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","―Yo'o Tatá Jesuu, na ja'un ñamani nuu ndi ta kunda'viniun ndyu'u ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tajan ora ndē'e Jesuu nuu ka'ìin ndra ta te'en nāka'an ra chi'in ndra: ―Na ku'un ndo kujana'a ndo ndo nuu ma ndra sutu ti cha ndā'a ndo ―kàti Jesuu chi'in ndra. Tajan kēe ndio ndra kuà'an ndra ta chi'in ña chìkani ndra kuà'an ndra ta chā'a ndra kuenda ña cha ndā'a ndra. ");
INSERT INTO mza_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tajan iin ma raku'vi ña ìyo tañu ndra ora chā'a ra kuenda ña cha ndā'a ra, ta chīkokani ndiko ra kuà'an ra nuu ndaa Jesuu, ña nduva'a kuii ni'i kānachaa ra ña jàka'nu ra Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tajan ora chāa ndio ra nuu ndaa Jesuu ta chūnandi chiti ra nuu ra nda kati nani te'e nuu ra nuu ñu'u'. Ta te'en kīcha'a kà'an ra chi'in Jesuu: ―Na ta'vindioun cha'a' ña jānda'un yu'u ―kàti ra chi'in Jesuu. Ta rakan yüvi ra judíu kùu ra ti ra ñu'u' Samariani kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tajan te'en nāka'an ndio Jesuu chi'in ma ñivi ka'ìin ikan: ―Cha chìto va'i ti uchi ta'an ndra jānda'i. ¿Ndanu ìyo ma inga iín ta'an ndra? ");
INSERT INTO mza_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Naja tüvi vàchi inga ma ndra judíu ta jaka'nu ndra Ndioo ña uvanuu ma ra ñu'u' Samaria kīchaa?, kùuni ndo ―kàti Jesuu chi'in ma ñivi. ");
INSERT INTO mza_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Ndeta ta ku'un ve'un, ti cha'a' ña chìnuniun kùu yi ña cha ndā'un ―kàti Jesuu chi'in ma ra Samaria. ");
INSERT INTO mza_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tajan te'en kīcha'a chìkatu'un ma ndra fariseu nuu Jesuu: ―¿Nda ora ni kichaa nuu chà'nda Ndioo tiñu? ―kàti ndra. Ta te'en nāka'an ndio Jesuu chi'in ndra: ―Taku ma nuu chà'nda Ndioo tiñu na küu nde'o yi ma ora ni kichaa yi. ");
INSERT INTO mza_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yakan va ma ora ikan na küu ka'an ñivi ña i'ya kùu nuu ìyo Ndioo ra chà'nda tiñu a ikan, vati ndicha kuii ña cha ìyo yi tañu ndo ―kàti Jesuu chi'in ndra. Tajan te'en nāka'an tuku Jesuu chi'in ma ndra jàkua'a chi'in ra: ");
INSERT INTO mza_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","―Ni chaa iin kivi ña ni kuuni ndo nde'e ndiko ndo yu'u ra Se'e ñivi tāchi Ndioo ma ora ni kichi̱ inga cha'a'. Va kumaniga kèta yi. ");
INSERT INTO mza_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Vati ìyo ñivi ni ka'an: “I'ya ndaa ra”, a “Ndakan vàchi ra”, ni kati na. Va koto tändikun ndo ku'un ndo chata na. ");
INSERT INTO mza_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vati ma kivi ni kichi ndiko yu'u, ra Se'e ñivi tāchi Ndioo jandondichi̱n ma ora ni koyoi takua jà'a ma tacha ora kòyo yi ña jandondichini yi iti' andivi a nda nikuuni. Takan ni ndotacha jà'a yu'u, ra Se'e ñivi tāchi Ndioo ora ni kichi ndikoi inga cha'a'. ");
INSERT INTO mza_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Va ìyo yi ña nde'e ji'nai tundo'o, ta tüvi kùuni ma ñivi ìyo ma tiempu i'ya nde'e na yu'u. ");
INSERT INTO mza_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Vati ma tiempu ni kichi ndiko yu'u ra Se'e ñivi tāchi Ndioo, indukuni ni ja'a ma ñivi takua jā'a na tiempu chīyo Noé. ");
INSERT INTO mza_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Va ma tiempu ikan, chàchi na ta chì'i na ta tànda'a na. Tajan nunuu ni chāa ndio ma kivi ña kī'vi ndio Noé ma tichi varku ra ta kūun ndio ma savi ta tandi'i ñivi töve kī'vi ma tichi varku chī'í ndi'i kuii na. ");
INSERT INTO mza_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ta indukuni jā'a na tiempu chīyo Lot ndia, ti ma ñivi chàchi na, chì'i na, ta jàta na ndatiñu ta xìko na yi, ta tàchi na ta jàva'a na ve'e na, ");
INSERT INTO mza_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","va ora kēe ndio ma Lot ma ñuu Sodoma, tajan Ndioo nunuu ni jākoyo ndio ra ñu'ú chi'in azufre ma iti' andivi chata na, ta takan jā'a ra ña chā'ni ndi'i ra na. ");
INSERT INTO mza_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Takan ni kuu ma ora ni keta kivi ña ni kichi ndiko ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Vati ma kivi ikan tu ìyo nda ndyo'o ka'ìin ndo siki ve'e ndo, na kï'vi ndo ni ña tävani'i ndo ndatiñu ndo ña ka'ìin tichi yi. Ta nda ndyo'o kàchika tichi ku'u ma ora ikan, tiá va'a ña na kü'un ndo ve'e ndo ndia. ");
INSERT INTO mza_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Na kuku'uni ndo naja kua tā'an ñasi'i Lot ña chī'an. ");
INSERT INTO mza_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ma ora ikan tu nanduku ndo naja kua kakú ndo, ni kuvi ndo, va tuva kuvi ndo cha'a' ma Racha'nu Ndioo, ni koo ndo chi'in ra endeeni. ");
INSERT INTO mza_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Yakan va yu'u kàti chi'in ndo ti ma chanikuaa ora ikan tu uvi ta'an ndra kàndoyo ndra kìxi ndra tichi iin ve'eni, iin ra va ni kani'i ma Racha'nu Ndioo ña ku'un ra chi'in ra, ta inga ra töve. ");
INSERT INTO mza_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ta tu uvi ta'an ñivi ña'a iin ndikoni vi, iin ña va ni kàni'i ma Racha'nu Ndioo kuà'an ña chi'in ra, ta inga ña töve. ");
INSERT INTO mza_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ta indukuni kùu yi tu uvi ta'an ndra'ii jàtiñu ndra ku'u, iin ra va ni kàni'i ma Racha'nu Ndioo ku'un ra chi'in ra, ta inga ra töve ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tajan te'en chīkatu'un ndio ma ndra jàkua'a chi'in ra nuu ra: ―Yo'o Racha'nu, ¿ta ndanu ni kuu yi takan? ―kàti ndra. Tajan te'en nāka'an ra chi'in ndra: ―Taku nuu kàndii ma ña chì'í, ikan kuti'vi ma chii chàchi ndri ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Takan kūu tajan te'en kīcha'a Jesuu jàna'a ra iin ku'va nuu na, cha'a' naja kua ìyo yi ña ka'an na chi'in Ndioo ndisaa tiempu koto jàña na ña jà'a na yi: ");
INSERT INTO mza_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","―Taji'na chīyo iin ra kùu vesi ña jàndondaa tiñu. Ta rakan ti tükuii jàka'nu ra Ndioo, ta tüvi tìñu'u ra ñivi ndia. ");
INSERT INTO mza_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ta juuni ma ñuu ikan ìyo iin ña'a kīndoo nda'vi. Ta yakan ti ìyo iin kuati chi'an, yakan va nani kivi chà'an ña chàti'an kuati nuu ma ra vesi, ta yakan te'en kà'an ña: “Yo'o racha'nu, na tindeun yu'u ta jàndondaun ma kuati jà'a inga ñivi chi'i̱n”, kàtian. ");
INSERT INTO mza_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ta cha kua'a' tiempu kùu yi ña chāti'an kuati nuu ra ta tükuii kùuni ra jachi'in ra ma ña kà'an ña. Va juuni maa ra te'en chànini ra: “Vaji töve jàka'nui Ndioo ta töve tìñu'i ñivi, ");
INSERT INTO mza_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","va tava ma ña'a kìndonda'vi i'ya endee töve jàña ña ña kìchi ti'an kuati nui, yakan va va'a ga ña na jandondai ma kuatian koto jasananian xini̱ chi'in ma tiñu jà'i, ta jakayunian yu'u.” Takan chànini ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tajan te'en nāka'an ndio ma Racha'nu Jesuu chi'in na: ―Ndisaa ña'a kùu ma ña chànini ma ra vesi kini ña jàndondaa kuati. ");
INSERT INTO mza_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yakan va tu ma ra kùu vesi ña jàndondaa tiñu jà'a ra yi vaji yüvi ra va'a kùu ra, kùuni yi ka'an yi ña nduva'a ga va'a ni ja'a ma Racha'nu Ndioo yi chi'in yo tuva chìkan yo yi nuu ra nàni kivi ndia. Ta Ndioo, ¿a ni kuyanga ra ku'va ra ma ña chìkan ndo nuu ra?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta cha'a' yakan kùu yi ña yu'u kà'in chi'in ndo juuni numini ni ka'an Ndioo cha'a' ndo tuva takan ja'a ndo. Va ma ora ni kichaa ndiko ma ra Se'e ñivi tāchi Ndioo ma nuu ñu'u' ñuñivi i'ya, nde'o tuva juuni nata'an ga ra ma ndian chìnuni tu'un ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tajan te'en nāka'an tuku Jesuu iin ku'va nuu ma ñivi inga cha'a', vati ìyo ndian kàti ña kùu na ndian va'a, va tüvi ndicha, ti tüvi kùuni na nde'e na ta'an na: ");
INSERT INTO mza_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Ìyo uvi ta'an ndra'ii ña chā'an ndra chāka'an ndra chi'in Ndioo tichi veñu'u ka'nu. Va iin ra kùu ra fariseu ta inga ra kùu ra, ra nàka'an xu'un' kuenda ñuu ka'nu Roma. ");
INSERT INTO mza_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tajan ma ra fariseu chūndaa ra ta te'en kīcha'a ra kà'an ra chi'in Ndioo cha'a' ra tichi ma veñu'u ka'nu: “Yo'o Racha'nu chà'i ta'vindioo nuu̱n, vati tüvi jà'i takua jà'a inga na ña su'u na ta kini na ta kì'vi na chi'in ña'a yüvi ñasi'i na. Ta juuni chà'i ta'vindioo nuu̱n, ti tüvi jà'i takua jà'a ma ra nàka'an xu'un' kuenda ñuu Roma ña ndaa ikan ndia. ");
INSERT INTO mza_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Vati yu'u jànditai yu'i uvi cha'a' iin jamana ta chà'i uchi porcientu ma xu'un' jàkanai nuu̱n ndia.” Takan kàti ma ra fariseu ña kà'an ra chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Takan kūu ta ma ra nàka'an xu'un' kīndoo ra ndaa ra yatini ma ikan ta ni tüvi kàni'i ra ma nuu ra ña nde'e ra iti' andivi, ta kāni ra pechu ra ti ya'a nda'vi kùuni ra tajan te'en kīcha'a ra kà'an ra chi'in Ndioo: “Yo'o Racha'nu Ndioo na kunda'viniun nde'un yu'u, vati chìtoi ti iin ra jà'a kuatini kùi”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Takan kūu yakan va yu'u kàti chi'in ndo ti ma ra nàka'an xu'un' ora kēe ra kuà'an ra ve'e ra cha jānaa Ndioo kuati ra, va ma ra fariseu töve. Vati ma ndian jàka'nu juuni maa, ni jakukanuu Ndioo na, ta ma ndian kà'an nda'vi cha'a' nuu Ndioo, ni jaka'nu Ndioo na. ");
INSERT INTO mza_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ta juuni ka'ìin ñivi ikan ña chàndaka na ndiakuati se'e na, na jundii Jesuu nda'a' ra xini na, va ora ndē'e ma ndra jàkua'a chi'in Jesuu ña takan jā'a na, tajan te'en kīcha'a ndio ndra kà'an xaan ndra nuu ma ndian chàndaka ma ndiakuati nuu Jesuu: ―Na kündaka ndo se'e ndo nuu ndaa Jesuu ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tajan kāna ndio Jesuu ndra jàkua'a chi'in ra, ta te'en nāka'an ra chi'in ndra: ―¡Na jä'a ndo takan! Ku'va ndyo'o ña na kichi ma ndiakuati nui, ta na käsi ndo nuu na, ti ma ñivi ìyo nuu chà'nda Ndioo tiñu, indukuni kàa na kua kàa ma ndiakuati. ");
INSERT INTO mza_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yakan va ndicha va'i ña kà'in chi'in ndo ti tu töve chìnuni ndo tu'un Ndioo takua chìnuni ndiakuati ka'ìin i'ya, na küu ki'vi ndo koo ndo chi'in Ndioo nuu chà'nda ra tiñu ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Takan kūu ta iin ra chà'nda tiñu nuu ñivi judíu te'en chīkatu'un ra nuu Jesuu: ―Yo'o Matru va'a, ¿nayi ìyo yi ña ja'i ta kùu ni'i̱ nuu koo nditoi endeeni chi'in Ndioo? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―¿Ta naja kà'un ña kùi Matru va'a? Ta uvanuuni ra va'a kùu ra ña ìyo ra, ta rakan kùu ra Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","¿A cha chìtoun naja kua kà'an ma tu'un Ndioo? Ma tu'un Ndioo te'en kà'an yi ―kàti Jesuu chi'in ra. ―Na kï'viun chi'in ña'a yüvi ñasi'un, na kä'niun, na sü'un na kä'un tu'un vata chata inga ñivi, ta na tiñu'u̱n tatáun chi'in ma'un ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tajan rakan te'en nāka'an ndio ra chi'in Jesuu: ―Ndisaa yakan cha jā'i yi nda ora kūi ravali ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ta ora chīni Jesuu ma ña kā'an ra, tajan te'en nāka'an ndio ra chi'in ra: ―Uvanuunia nakuyi kumani ña jà'un: na xiko ndi'un ma ña ìyo nuu̱n ta jachaun ma xu'un' nuu ndian nda'vi. Takan ìyo yi ña ja'un ta kuu ni'un ña kuikaun iti' andivi. Ta ora cha jā'un yi, tajan na kichiun ta ku'u̱n chatai ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Takan kūu ta ora chīni ndio ra ma ña kā'an Jesuu, tajan nduva'a kuii nda'vi kùuni ra, ti ya'a kuika ra. ");
INSERT INTO mza_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ta ora ndē'e Jesuu ña nda'vi kùuni ra, tajan te'en nāka'an ra chi'in ñivi ka'ìin ikan: ―Ya'aga ndetiñu kuenda ndian kuika ña kì'vi na nuu chà'nda Ndioo tiñu. ");
INSERT INTO mza_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","¿A nde'un iin cha'a' ña kì'vi iin camellu xe'e iin kutiku? Ta takua iin ra kuika na küu ki'vi ra nuu chà'nda Ndioo tiñu ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ta ma ndian chīni ña kā'an Jesuu te'en kīcha'a na chìkatu'un na nuu ra: ―Aan, ¿ta nda ndian kùu ma ndian ni kakú tuva takan?, kùuniun ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tajan te'en nāka'an Jesuu chi'in na: ―Ma ña ndetiñu kuenda ma ñivi, kuenda ma Ndioo töve ndetiñu kùu yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Takan kūu tajan te'en nāka'an Petu' chi'in ra: ―Yo'o Racha'nu taku ndyu'u ndākoo ndi ndisaa ña ìyo nuu ndi, ta tāndikun ndi chataun ―kàti Petu' chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tajan te'en nāka'an ndio Jesuu: ―Ndicha va'i ña kà'in chi'in ndo, ti nda ndian nikuuni ña ndākoo na ve'e na ñasi'i na yani na tatá na ta se'e na cha'a' ña kuàkatitu'un na naja kua koo ñivi chi'in Ndioo nuu chà'nda ra tiñu, ");
INSERT INTO mza_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ni ni'i na tiá kua'a' ya'vi na ñuñivi i'ya ta juuni ni ni'i na ya'vi na tiá iti' nuu ndia, ti ni ni'i na nuu koo ndito na endeeni chi'in Ndioo nuu chà'nda ra tiñu ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Takan kūu tajan kāna ndio Jesuu ndi uchi uvi ma ndra jàkua'a chi'in ra, ta te'en nāka'an ra chi'in ndra: ―Vitin ni ko'o ñuu Jerusalén, vati ikan ni chinu ma ña kā'an ma ndra kà'an chi'in tu'un yu'u Ndioo, ndisaa ña tāa ndra cha'a' ña ni ta'an ma ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Vati ma ñivi judíu ni ku'va na ra nda'a' ñivi vàchi inga ñuu. Ta ndiakan ni kuàtu'un na ra, ta ni ka'an ti'ini na chata ra, ta ni tivisii na ra, ");
INSERT INTO mza_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","tajan kani na ra ta ka'ni na ra, va tichi uni kivi ni nataku ndiko ra tañu ñivi ndií ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Va ma ndra jàkua'a chi'in ra tükuii nī kutunini ndra ma ña kā'an ra, ta ni tüvi chìto ndra nda kuenda kùu ma ña kā'an ra chi'in ndra, vati na chä'a Ndioo ña kutunini ndra ma ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ora cha kuàkuyatin Jesuu ma ñuu Jericó, ta ikan ndē'e ra ña nàndi iin ra kuaá yu'u iti' nuu kuà'an ra ña chìkan ra tunda'vi. ");
INSERT INTO mza_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yakan va ora chīni ra ña ya'a kua'a' ñivi, tajan chīkatu'un ndio ra nuu ma ñivi ña nayi kùu ma ikan. ");
INSERT INTO mza_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tajan kātitu'un na nuu ra ña Jesuu ra ñuu Nazaret kùu ra ña yà'a ra ma ikan. ");
INSERT INTO mza_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tajan te'en kīcha'a ra kànachaa ra: ―Yo'o Jesuu tata racha'nu David, na kunda'viniun yu'u ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ta ma ndian kuà'an iti' nuu kà'an xaan na chi'in ra ña na taxiin koo yu'u ra, va vi'a kànachaa ra te'en kà'an ndiko ra: ―Yo'o Jesuu tata racha'nu David, na kunda'viniun yu'u ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tajan chūndaa ndio Jesuu ta tāchi ra na ña na kuki'in na ra. Tajan ora chāa na chi'in ra yatin ma nuu ndaa ra, tajan te'en kīcha'a Jesuu chìkatu'un ra nuu ra: ");
INSERT INTO mza_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Nayi kùuniun ña ja'i chi'un? ―kàti Jesuu. Tajan te'en nāka'an ma ra kuaá chi'in ra: ―Yo'o Racha'nu, kùuni̱ ña na janda'un tinui ikan na kuu nde'i ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tajan te'en nāka'an Jesuu chi'in ra: ―Na ndondichin nde'un ti cha'a' ña chìnuniun kùu yi, ña cha ndā'a ma tinuu̱n ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tajan ña juuni ma ora ikani kùu nande'e ra, tajan kīcha'a ndio ra jàka'nu ra Ndioo, ta tāndikun ra kuà'an ra chata Jesuu. Ta ndisaa ma ñivi ndè'e ña kūu chi'in ra juuni kìcha'a na jàka'nu na Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tajan kī'vi ndio Jesuu ma tichi ñuu Jericó. Ta chàkunuu ra ikan. ");
INSERT INTO mza_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta ma ñuu ikan ti ìyo iin ra kuika nàni Zaqueo. Ta rakan ti ra kùxini nuu ndra nàka'an xu'un' kuenda ñuu ka'nu Roma kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta rakan ti kùuni ra nakoto ra Jesuu, va na küu nde'e ra ra, ti ya'a kua'a' ñivi ta ya'a ndiki ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yakan va yā'a nduu ra kuà'an ra iti' nuu, ta ikan ndāa ra nuu iin yutun nàni sicómoro ña ndaa yatini nuu ni ya'a Jesuu, ikan ti na kuu nde'e ra ra. ");
INSERT INTO mza_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ta ora yā'a ndio Jesuu ma ikan, tajan ndē'e ndaa ra nuu yutun nuu nàndi ra, tajan te'en nāka'an Jesuu chi'in ra: ―Yo'o Zaqueo, na nuu̱n, vati kivi i'ya ni ndoi nuu ìyo ve'un ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tajan numini nūu ndio ra ma nuu yutun, ta chūnumi ra ra ti ya'a chìsii ra ña kā'an Jesuu takan. Tajan chāka ndio ra ra kuà'an ra ve'e ra. ");
INSERT INTO mza_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ta ora ndē'e ma ñivi ña kuà'an Jesuu chi'in ra, tajan tükuii va'a kūuni na, ta kīcha'a na kà'an ndaa na chata Jesuu ña naja kuàkindoo ra ve'e iin ra jà'a kuati, kàti na. ");
INSERT INTO mza_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tajan ndēta ndio ma Zaqueo ta te'en kīcha'a ra kà'an ra chi'in ma Racha'nu: ―Yo'o Racha'nu, java ma ndatiñu ña ìyo nui, ni ku'vai yi nuu ma ndian nda'vi, ta tu ìyo nda ndian jānda'viña'i, nda kumi cha'a' ni jachikoni'i ndikoi yi nuu na inga cha'a' ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tajan te'en nāka'an Jesuu: ―Vitin va cha kīchaa ña ni kakú ñivi ìyo ve'e i'ya ti juuni ñivi Abraham ra chīyo taji'na kùu ra'ya ndia. ");
INSERT INTO mza_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Vati ma ra Se'e ñivi tāchi Ndioo, vàchi nanduku ra ñivi ìyo ñuñivi i'ya, ta vàchi jakakú ra ndian cha ìyo tiempu ña kuànaa ndia. ");
INSERT INTO mza_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ta ndava tàso'o ma ñivi ña kà'an Jesuu, yakan va kīcha'a tuku ra nàtu'un ra iin ku'va nuu na, vati cha chìto ra ña chani chaa ra ma ñuu Jerusalén. Ta cha'a' yakan kùu yi ña chànini na ña chani kuyatin kichaa nuu chà'nda Ndioo tiñu nuu na. ");
INSERT INTO mza_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yakan va te'en kīcha'a nāka'an Jesuu yi nuu na: ―Taji'na, chīyo iin ra ya'a ìñu'u. Ta rakan ti kēe ra kuà'an ra inga ñuu nuu chika, vati ikan ni ku'va na tiñu nuu ra ña ni kuu ra Rey ta ka'nda ra tiñu, tajan kichaa ndiko ra. ");
INSERT INTO mza_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ta antea ña ni kee ra ku'un ra, tajan kāna ra uchi ta'an ma ndra musu ra, ta ta'ii'iin ndra chā'a ra iin ma xu'un' oro ña ya'a ya'vi ndaa. Tajan te'en nāka'an ra chi'in ndra: “Na jatiñu va'a ndo chi'in ma xu'un' ña chā'i nuu ndo, ta nda ora ni kichaa ndikoi, tajan ku'va ndiko ndo yi chi'in ña jàkanaa yi nui”, kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Va tava ma ñivi ñuu ra, ti ya'a tixin na nde'e na ra, yakan va tāchi na iin ndra kùu tatun ña kuàkatitu'un ndra nuu ma rey, ta te'en kà'an na nuu ma tatun: “Na tüvi kùuni ndi ña kùu ra Rey ndi, ta ka'nda ra tiñu nuu ndi.” Takan kàti na chi'in ma tatun. ");
INSERT INTO mza_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Va nī kuu yi takua chànini na ja'a na, vati nì'i ra tiñu ña kùu ra Rey nuu na, tajan ora cha kùu ra rey ta chīkoni'i ndiko ra ñuu ra. Ta ora chāa ndio ra ma ñuu ra, tajan tāchi ndio ra tiñu chata ma ndra musu ña chā'a ra xu'un' nuu ña na kichi ndra vati kùuni ra koto ra naja jākanaa ii'iin ndra chi'in ma xu'un' chā'a ra nuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tajan chāa ma ra nunuu, ta rakan te'en nāka'an ra chi'in ma rey ikan: “Yo'o racha'nu, ma xu'un' ña chā'a nuu̱n nui ña jātiñui chi'in yi ta jākanaa yi nda uchi cha'a' tiá”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tajan te'en nāka'an ndio ma ra kùu Rey chi'in ra: “Cha chìtoi ti ya'a ga va'a ra musu kùu̱n, ta cha'a' yakan kùu yi ña ìyo tundeeni̱ chi'un. Yakan va vitin ni ku'vai tiñu ka'nu ga nuu̱n ña na ka'ndaun tiñu nuu uchi ta'an ñuu”, kàti ma ra kùu Rey chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tajan inga tuku ra chāa nuu ra. Ta rakan te'en nāka'an ra chi'in ra: “Yo'o racha'nu, ma xu'un' ña chā'a nuu̱n nui ña jàtiñui chi'in yi ta jākanaa yi nda u'un cha'a' tiá”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tajan te'en nāka'an ndio ma ra kùu Rey chi'in ra: “Nuu yo'o ni ku'vai tiñu ña na ka'ndaun tiñu nuu u'un ta'an ñuu”, kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Ta inga tuku ra chāa nuu ra, ta rakan te'en nāka'an ra chi'in ra: “Yo'o racha'nu, ma xu'un' ña chā'a nuu̱n nui, ndākiva'i yi tichi iin pañitu, i'ya ìyo ma xu'u̱n'. ");
INSERT INTO mza_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nī kuuni̱ jatiñui chi'in yi vati ndasii̱ nde'i ñu̱n, ti cha chìtoi ña ya'a xaun, vati nàmaun ndatiñu ña tāchi inga ñivi ta jàti'viun ña tüvi nī tachiun”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tajan te'en nāka'an ndio ma ra kùu Rey chi'in ra: “Yo'o ra musu ña tüvi va'a chànini. Cha'a' ma tu'un kā'un chiña, ni tiso kuati̱ ñu̱n. Vati juuni maun kà'un ña yu'u kùu iin ra tüvi va'a jà'a, ta ña nàmai xu'un' nuu ma ñivi ta tüvi jàtiñui, ta cha'a' ña kà'un ña nakuisoi ndatiñu nuu tüvi jàtiñui. ");
INSERT INTO mza_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yakan va tu chìtoun ña takan kùu yi, ¿ta naja tüvi nī chati'un yi tichi vanku niku, ta ora kichaa ndikoi nuu ìyo ve'i, ikan na jachikoni'i ndikoun yi nui chi'in ma xu'un' siki yi niku? Va tüvi nī ja'un takan”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tajan te'en nāka'an tuku ma ra kùu Rey chi'in ndian ka'ìin ikan: “Na namaa ndo ma xu'un' ikan nuu ra, ta ku'va ndo yi nuu ma ra jākanaa uchi cha'a' tiá”, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tajan te'en nāka'an ma ñivi ikan chi'in ra: “Yo'o racha'nu, na tüvi va'a ma ña kā'un, vati rakan cha jākanaa ra kua'a' xu'un' chi'in ma xu'un' chā'un nuu ra”, kàti na. ");
INSERT INTO mza_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tajan te'en nāka'an ma ra kùu Rey: “I'ya kà'in chi'in ndo ti ma ñivi jàtiñu va'a tiaga kua'a' ma ndatiñu na ni koo, va ma ñivi töve jàtiñu va'a, ni kindaa Ndioo ma tiñu jà'a na vaji töve kua'a' yi. ");
INSERT INTO mza_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ta ma ndian töve kùuni ña kui Rey niku, kuàki'in ndo na ta kundaka ndo na kichi na i'ya, ta ka'ni ndo na nui.” Takan kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ta ora chinu kā'an Jesuu tu'un ikan, tajan kēe ndiko ra kuà'an ra ma iti' ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tajan ora cha kùyatin ra nuu kàndii ma ñuu Betfagé chi'in ñuu Betania nuu ìyo yuku Olivu, tajan tāchi ndio ra uvi ta'an ma ndra jàkua'a chi'in ra ñuu ikan, va ji'na te'en kā'an ra chi'in ndra: ");
INSERT INTO mza_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","―Na ku'un ndo kuariya ña kàndii ikan ta ora chaa ndo ma ikan, ikan nata'an ndo iin burru ndikun ña nï'iin na takä'an koso. Na ndachi ndo ri ta kundaka ndo ri kichi ndo nui nde've. ");
INSERT INTO mza_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta tu ìyo ndian chìkatu'un nuu ndo ña naja ndàchi ndo ri, ta kati ndo ti ma racha'nu chito'o ndo chiniñu'u ri kàti ndo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tajan kēe ndio ndra kuà'an ndra ta nāta'an ndra ndisaa yi takua kātitu'un Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tajan kīcha'a ndra ndàchi ndra ma burru, ta ora ndē'e ma ra chito'o ri ndra, ta te'en kīcha'a chìkatu'un ra nuu ndra: ―¿Ta naja ndàchi ndo ma burru jànai? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tajan te'en nāka'an ndio ndra chi'in ra: ―Ndàchi ndi ri ti ma racha'nu chiniñu'u ri ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tajan jūndii ndio ndra ja'ma ndra chata ri ta kēñu'u ndra ri chāa ndra nuu ndaa Jesuu. Ta ikan jāndaa ndra ra chata ri. ");
INSERT INTO mza_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tajan kuàkua'an Jesuu, ta kua ikan chàkin ma ñivi ikan ja'ma na ma iti' kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tajan ora cha kūyatin ra iti' nuu inuu ma yuku Olivu, tajan ndisaa ma ndian chìnuni ña kuà'an chata ra, te'en kīcha'a na kànachaa na ña chìsii na. Ta jàka'nu na Ndioo cha'a' ndisaa ndatu ña ndè'e na jā'a ra: ");
INSERT INTO mza_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","―¡Ya'a ga ií kùu ma ra kùu Rey ña kīchaa chi'in ndatu ma Racha'nu Ndioo! ¡Ta na koo vii ma Racha'nu ìyo iti' andivi! ¡Ta na jaka'nu yo ra cha'a' ma ña jā'a ra! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ta iin ma ndra fariseu, ña kuà'an tañu ma ñivi ikan, te'en kīcha'a ndra kà'an ndra nuu Jesuu: ―Matru, ¡na ka'un nuu ma ndian kàkichi chataun, na taxiin kuu yu'u na! ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Yu'u kàtitu'in nuu ndo ti tu jakutaxi̱n ma ñivi vàchi chatai, nda ma yuu kàndoyo chiña ni jaka'nu yi yu'u ndia ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ta ora cha kūyatin ndio Jesuu ma ñuu Jerusalén, ta te'en kīcha'a ra chàku ra cha'a' ma ñivi ñuu ikan, ora ndē'e ra yi: ");
INSERT INTO mza_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","―Ndyo'o ñivi ìyo ñuu Jerusalén tu kutunini ndo ña na nani'i ndo naja kua koo vii ndo chi'in Ndioo cha'a' ña ìyo ra i'ya chi'in ndo jitu ma kivi vitin, va na küu ga yi ni vitin, ta ni iti' nuu, ti cha tīndixe'e Ndioo yi nuu ndo. ");
INSERT INTO mza_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Vati ni keta iin kivi ña ni koo kuati chi'in ndo ti ma ndian xaani nde'e ndo ni ja'a na iin muru naja kua kandii ñuu ndo, ta ni kuikonuu ndio na ndo ta kanita'an na chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yakan va ni ka'ni ndi'i na ndo, ta takan ni janaa na ma ñuu ndo ña nï'iin ga yuu ìyo cha'a' ve'e ndo tüva ni kindoo yi, vati töve kì'in ndo kuenda ma Racha'nu Ndioo ora cha kīchaa ra ña kùuni ra jakakú ra ndo ―kàti Jesuu chi'in ma ñivi ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ta ora yā'a ña kā'an Jesuu takan, tajan kī'vi ndio ra ma tichi kora veñu'u ka'nu ndian judíu, ta kīcha'a ndio ra jàkunu ra ma ndian xìko chi'in ndian jàta ña ka'ìin ma ikan chi'in tu'un i'ya: ");
INSERT INTO mza_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","―Nuu ma tutu Ndioo kà'an yi ti ve'e i'ya kùu ve'e Ndioo, nuu kà'an na chi'in ra kàti yi. Va ndyo'o, jāndaku ndo yi iin ve'e ndrasu'u ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ta tandi'i kivi jàna'a Jesuu nuu ma ñivi ma tichi veñu'u ka'nu ikan, ta ma ndra sutu cha'nu chi'in ndra jàkua'a tutu Ndioo, ta chi'in tandi'i ndracha'nu ña ìyo ma ñuu ikan nànduku ndra naja kua ja'a ndra ta kuu ni'i ndra kua ka'ni ndra Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Va nī kuu ni'i ndra naja kua ja'a ndra ti ndisaa ma ñivi tàso'o na ña kà'an Jesuu, ta chìsii na ña jàna'a ra nuu na. ");
INSERT INTO mza_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iin kivi ndaa Jesuu tichi kora veñu'u ka'nu ñuu Jerusalén ña jàna'a ra nuu ma ñivi naja kua kuu yi ña jàkakú Ndioo ñivi. Ta ora ikan chāa ma ndra sutu cha'nu chi'in ndra matru jàkua'a tutu Ndioo, ta chi'in inga ndra cha'nu ma ñuu. ");
INSERT INTO mza_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ta te'en kīcha'a chìkatu'un ndra nuu ra: ―¿Yo tāchi ñu̱n ña jà'un te'en? Ta, ¿yo chā'a ndatu nuu̱n? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ta te'en nāka'an ndio Jesuu chi'in ndra: ―Ji'na kùuni̱ ña katitu'un ndo nui iin ña ni ndakatu'in nuu ndo ndia: ");
INSERT INTO mza_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Yo tāchi Xuva ña jàkunduta ra, a Ndioo, a ñivi? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tajan te'en kīcha'a ndio ndra nàtu'un xe'e ta'an ndra: ―Tu katio ña Ndioo tāchi ra, ta kati ra ña, ¿ta naja nī chinunio ma ña kà'an ra tuva takan? ");
INSERT INTO mza_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ta tu kàtio ña ñivi tāchi ra ni ka'ni ma ñivi yo chi'in yuu najaka, vati ndisaa na cha chàndatu na ña Xuva kà'an ra chi'in tu'un yu'u Ndioo ―kàti ndra ña nātu'un ta'an ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tajan nāka'an ndio ndra chi'in Jesuu ña na töve chìto ndra yo tāchi ra ña jàkunduta ra ñivi. ");
INSERT INTO mza_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Ta ni yu'u na käti̱ nuu ndo yo chā'a ndatu nui ña jā'i te'en ―kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tajan te'en kīcha'a Jesuu kà'an ra iin ku'va nuu ma ñivi: ―Taji'na chīyo iin ra tāchi kua'a' yoku'u uva. Ta rakan ti jakilaa ra yi nuu ndra jàtiñu chi'in ra. Ta kēe ndio ra kuà'an ra iin nuu chika kua'a' tiempu. ");
INSERT INTO mza_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tajan ora cha kēta ma tiempu ña chìti ma uva, tajan tāchi ndio ra iin ra kùu musu ra ña na ku'un ra kuki'in ra java ma ña xuña'a ra nuu ndra. Va nī ni'i ra yi ti java kāni ndra ra, ta tāchi ndiko ndra ra nuu ma ra kùu chito'o ra. ");
INSERT INTO mza_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ta ikan jan tāchi ndiko ra inga ma ra kùu musu ra nuu ndra, va juuni tüvi nani nï'iin ra, ti java kāni ndra ra, ta tāchi ndiko ndra ra nuu ma ra kùu chito'o ra. ");
INSERT INTO mza_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ta tāchi ndiko tuku ra inga ra nuu ndra, ta rakan va jātakue'e ndra ta jākunu ndra ra. ");
INSERT INTO mza_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tajan te'en nāka'an ndio ma ra chito'o ma ñu'u' chi'in juuni maa ra: “Aan cha chìto yo ma ña ni ja'a yo. Ni tachi yo ma ra kùu se'o, vati rakan kùu ma ra ni tiñu'u ndra najaka, ti ra se'e maa yo kùu ra.” Takan chānini ra. ");
INSERT INTO mza_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tajan tāchi ndio ra se'e ra kuà'an ra. Ta ora ndē'e ma ndra jàtiñu ña vàchi ra, ta te'en kīcha'a ndra nàtu'un ta'an ndra: “Ra vàchi ikan kùu ma ra ni kindoo chi'in ndisaa ma ñu'u' i'ya, yakan va na ka'nio ra ta kindoo yo chi'in ndisaa ña'a ra”, kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tajan tīin ndio ndra ra, ta tāvani'i ndra ra iti' yu'u ma yoku'u uva. Ta ikan chā'ni ndra ra. Ta ikan te'en chīkatu'un tuku Jesuu nuu ndra: ―¿Ta nayi ni ja'a ma ra kùu chito'o ma yoku'u uva chi'in ma ndra jàkuenda vu?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","¿A ni ku'un ra ta ka'ni ra ma ndra jàtiñu chi'in ra, ta jakilaa ra yi nuu inga ndra?, kùuni ndo ―kàti Jesuu. Tajan ora chīni na ña kā'an ra takan tajan te'en nāka'an na: ―¡Ndioo na kü'va ra ña na kuu yi takan! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tajan nānde'e ndio Jesuu nuu na ta te'en nāka'an ra: ―Ndicha ña ni kuu yi takan ti nuu ma tutu Ndioo te'en kà'an yi: Ma yuu ña jāchiyo ma ndra labañi ña kùva'a ve'e, yakan kùu ma yuu ka'nuga kuenda Ndioo kua ndisaa yi. ");
INSERT INTO mza_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yakan va tu koyo ma ñivi chata ma yuu ikan, ni kuche'e na takua ta'an chi'in iin ko'o ora kè'ne yi. Ta juuni tu koyo ma yuu ikan chata ma ñivi, ni kuche'e ndi'i na, ta ni ndakuu na yuyaka. ");
INSERT INTO mza_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tajan juuni ma ora ikani kūuni ma ndra jàkua'a tutu Ndioo chi'in ndra sutu cha'nu tiin ndra Jesuu, vati cha chā'a ndra kuenda ña kā'an ra ma ku'va ikan chata ndra. Va nī kuuni ndra ja'a ndra yi ti ndasii ndra nde'e ndra ma ñivi chàkuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tajan tāchi ndio ma ndra sutu cha'nu iin ndra na kuja'a ndra kuenda nuu chàkuu Jesuu ta na taso'o ndra ma ña kà'an ra. Tajan ora chāa ndra nuu ndaa Jesuu, ta jā'ani ndra ña ndra ndicha kùu ndra. Ta kīcha'a ndra kà'an ndra chi'in Jesuu ña na ka'an ra iin tu'un ña tüvi va'a, ikan na kuu ni'i ndra kua tisokuati ndra ra nuu ma ndra kumitiñu. ");
INSERT INTO mza_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tajan te'en chīkatu'un ndio ndra nuu ra: ―Yo'o Matru, cha chìto ndi ti ma ña kà'un chi'in ma ña jàna'un ña ndaa kùu yi, ta indukuni kì'un kuenda ndisaa ma ñivi, vati ndicha ña jàna'un iti' va'a Ndioo nuu na. ");
INSERT INTO mza_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yakan va, ¿a va'a ña tia'vi ndi xu'un' nuu ma ra kuvienu ñuu ka'nu Roma, a vä'a? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Va ma Jesuu cha chā'a ra kuenda ña kùuni ndra janda'viña'a ndra ra chi'in ma tu'un kà'an ndra, yakan va te'en nāka'an ra chi'in ndra: ―¿Ta naja kì'in ndo ku'va yu'u? ");
INSERT INTO mza_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Na jaya'a ndo iin xu'un' nui nde'o yo na'na, ta yo sivi kùu ma ña ìyo nuu yi ―kàti ra. Tajan te'en nāka'an ndra: ―Na'na ta sivi ma ra kuvienu ra ìyo ñuu ka'nu Roma kùu yi ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tajan te'en nāka'an Jesuu: ―Na ku'va ndo ña kùu ña'a ma ra kùu kuvienu ìyo ñuu ka'nu Roma nuu ra, ta na ku'va ndo ma ña kùu ña'a Ndioo nuu Ndioo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ta nī ni'i ndra naja kua ja'a ndra ta tiin ndra Jesuu, vati tüvi nī ka'an ra nï'iin tu'un vata. Yakan va taxiin kīndoo ndra ña ndava yū'vi ndra jā'a ma ña kā'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ta iin ndra Saduceu chānde'e ndra nuu ndaa Jesuu, vati töve chìnuni ndra ña nàtaku ndiko ma ndian ndií. Ta te'en kīcha'a chìkatu'un ndra nuu Jesuu: ");
INSERT INTO mza_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Yo'o Matru, racha'nu Moisés tāa ra iin tutu taji'na ña kà'an yi ña tu iin ra'ii chī'í ra ta tüvi nī chiyo nï'iin se'e ra chi'in ñasi'i ra, tajan ìyo yi ña ndaki'in ma ra yani ma ra chī'í ma ña kìndonda'vi ta tanda'a ra chi'an. Ta takan ni koo se'e ma ra chī'í jà'a ma ra yani ra, kàti yi. ");
INSERT INTO mza_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ta chīyo ucha ta'an ndra ña kùu ndra yani ndra. Ta ma ra nunuu ji'na ra tānda'a chi'an, ta tüvi nī chiyo se'e ra chi'an. Ta chī'í ra. ");
INSERT INTO mza_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ta ikan jan tānda'a inga ma ra uvi ña kùu yani ra chi'an. Ta indukuni chī'í ra ta nī chiyo nï'iin se'e ra chi'an ndia. ");
INSERT INTO mza_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tajan tānda'a ma ra uni chi'an, ta indukuni tüvi nī chiyo se'e ra chi'an, ta chī'í ra ndia. Ta juuni kua ikan tüvi nī chiyo nï'iin se'e ma ndi ucha ta'an ndra chi'an ta chī'í ndra ndia. ");
INSERT INTO mza_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tajan kēta ndio iin kivi ña nda maa ña chī'í ndia. ");
INSERT INTO mza_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tajan ora ni keta ma kivi ña nàtaku ndiko ma ñivi chī'í, ¿nda ndra ni kuu iian ndakan, tuva ndi ucha ndra tānda'a chi'an?, kùuniun ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Taku ma nuu ñu'u' ñuñivi i'ya ma ndra'ii chi'in ma ñivi ña'a tànda'a na, ");
INSERT INTO mza_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","va ma ñivi kāchin Ndioo ña koo chi'in ra andivi ni janataku ndiko ra na tañu ñivi ndií. Yakan va ma ndian ni chaa ikan a ña'a' a ra'ii, töva ni tanda'a vi ta töva ni ku'va na ndian kuu se'e na ña koo ii na ndia, ");
INSERT INTO mza_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","vati ikan tüva ni kuvi na ti ni kuu vii na takua kùu ma tati va'a jà'a tiñu nuu Ndioo. Ta juuni ni kuu na se'e ra ti cha nātaku ndiko na kuenda ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Vati maa ma Moisés jàna'a ra nuu yo ña nàtaku ndiko ma ñivi ndií. Ora chā'an ra chānde'e ra nuu kàyu ma iñu ndu'va yati ikan kā'an ra nuu ma Racha'nu Ndioo te'en: “Yo'o Racha'nu Ndioo, ra kùu ra jakuenda Abraham, ta Isaac chi'in Jacob.” ");
INSERT INTO mza_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Vati ma Racha'nu Ndioo kùu ra jàkuenda ma ndian nditoni, ta yüvi kuenda ndian ndií, vati kuenda Ndioo ndisaa ma ñivi kùu ndito na ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tajan iin ndra matru jàkua'a tutu Ndioo ña ka'ìin ma ikan, te'en nāka'an ndra chi'in Jesuu: ―Ya'a ga va'a kā'un yo'o matru ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yakan va nï'iin ga ndra tüva nī kuuni ndra ndakatu'un ndra nï'iin nakuyi nuu Jesuu ora kā'an ra takan. ");
INSERT INTO mza_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tajan te'en chīkatu'un ndio Jesuu nuu ndra: ―¿Ta naja kà'an ma ñivi ña tata racha'nu David kùu ma Cristu? ");
INSERT INTO mza_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Vati taku nuu ma tutu Salmu juuni maa ma racha'nu David te'en kà'an ra: Ma Racha'nu Ndioo te'en nāka'an ra chi'in ma ra kùu chito'i Cristu: “¡Na'a ta kunandiun chiyo kua'i ti i'ya ni ku'vai ma ndatui nuu̱n, ");
INSERT INTO mza_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nda kati kanindoyoi ma ndian xaani nde'e ñu̱n iti' cha'un!”, kàti Racha'nu Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yakan va kùuni yi ka'an yi, ti vaji tata David kùu Cristu, va juuni chito'o David kùu ra ndia ―kàti Jesuu chi'in ma ñivi ikan. ");
INSERT INTO mza_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tajan te'en nāka'an Jesuu chi'in ma ndra jàkua'a chi'in ra nuu ndè'e ndisaa ñivi: ");
INSERT INTO mza_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―¡Na ja'a ndo kuenda nuu ndo chi'in ma ndra matru jàkua'a tutu Ndioo! Ti chàta'ani ndra kakunuu ndra chi'in ja'ma kani ma nuya'vi, ikan na tiñu'u ma ñivi ndra. Ta juuni nànduku ndra ma tayu ka'nuga kunandi ndra ma tichi veñu'u ñivi judíu a nuu ìyo viko ndia. ");
INSERT INTO mza_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ta juuni ndrakan kùu ndra ña sù'u ndra ndatiñu ma ñivi kìndonda'vi, ta jà'ani ndra ña jakani ndra ma ña nàkuatu ndra nuu ka'ìin kua'a' ñivi, ikan na kuuni na ña yüvi ndrasu'u kùu ndra. Ndisaa ndrakan ni nde'e ndra kua'a' ga tundo'o. ―Takan kàti Jesuu chi'in ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tajan nàndi Jesuu ndè'e ra naja kua ti'i ma ndian kuika xu'un' tichi chatun nuu sòkó na yi kuenda Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ta nunuuni ndē'e ra ña chàa iin ña kīndoo nda'vi, ta tī'an uvi ta'an xu'un' kuati tichi yi. ");
INSERT INTO mza_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yakan va ora ndē'e Jesuu ña tī'an uvi ta'an xu'un' kuati tichi yi, tajan te'en nāka'an ndio ra chi'in ndra: ―Ndicha va'a ña kà'in chi'in ndo, ti ma ña nda'vi ikan kua'a' ga xu'un' sōkóan kua tandi'i na. ");
INSERT INTO mza_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Va ma ndian kuika ti vaji ndicha va'a ña kua'a' xu'un' tī'i na, va ña chàkosonia kùu yi. Yakan va kua'a' ga sōkóan ti chā'a ña tandi'i ma xu'un' kùmian ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tajan iin ndra jàkua'a chi'in Jesuu kà'an ndra ña ya'a vii kàa ma veñu'u jà'a ma yuu ka'nu ña ndaa cha'a yi ta chi'in ma ña kūkutu yi chi'in ña sōkó na ndia, kàti ndra. Tajan te'en nāka'an ndio Jesuu chi'in ndra ora chīni ra ña kà'an ndra: ");
INSERT INTO mza_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ndicha ña takan kàa yi vitin va ni keta iin kivi ña ndisaa ma ña ndè'e ndo ña ìyo vitin, nï'iin ga yuu tüva ni kindoo chata ta'an yi, ti ni kekoyo ndi'i yi ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tajan te'en kīcha'a tuku ma ndra jàkua'a chi'in ra chìkatu'un ndra nuu ra: ―Yo'o Matru, ¿ta nda ora ni kicha'a yi? ¿Ta nda seña kùu ma ña ni nde'o ora chani kicha'a yi? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tajan te'en nāka'an Jesuu chi'in ndra: ―Na ja'a ndo kuenda nuu ndo koto janda'viña'a ma ñivi ndo. Vati ni kichi kua'a' ñivi ña ni kuàtiñu na ma sivi̱ chi'in tu'un i'ya: “Yu'u kùu Cristu, ta vàchi katitu'in nuu ndo ña chani kuta'an ora ña ni naa ñuñivi”, ni kati na. Va koto kü'un ndo chata na ti ndian vata kùu na. ");
INSERT INTO mza_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ta na yü'vi ndo ora ña ni ka'an ñivi ña ìyo kuati ndanikuni ma nuu ñu'u' ñuñivi, vati ji'na kuii yakan kùu ma ña ni kuu. Ti ma kivi ikan kùmaniga chaa ma tiempu ña ni naa yi. ");
INSERT INTO mza_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Vati Jesuu te'en nāka'an ndiko tuku ra nuu ndra: ―Ni kanita'an iin ñivi ìyo ñuu chi'in inga ñivi ìyo inga ñuu. Ta inga tuku ñu'u' iin ñuu chi'in inga tuku yi. ");
INSERT INTO mza_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ta juuni ni kichi ña ya'a ni'i ni taan nuñu'u' ñuñivi ndia. Ta ni koo kua'a' tama' chi'in tundo'o ndanikuni. Ta iti' andivi ni nde'o kua'a' ña ni kuu chi'in kua'a' seña ña ni jayu'vi yo ndia. ");
INSERT INTO mza_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ta antea ña ni kuu yakan takan, ni tiin na ndo ta tisokuati na ndo, ta ni ku'va na ndo nuu ndra kumitiñu, ikan na kundaka na ndo ña nde'e ndo tundo'o tichi veñu'u, ta ni ti'i na ndo tichi vekaa, ta juuni ni ku'va na ndo nuu inga ndra chà'nda tiñu cha'a' ña chìnuni ndo tu'in ndia. ");
INSERT INTO mza_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ta ora ni ta'an ndo ña'a tajan ni ni'i ndio ndo naja kua kuu katitu'un ndo tu'in nuu ma ñivi. ");
INSERT INTO mza_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yakan va na näkanini ji'na ndo cha'a' ma ña ni ka'an ndo cha'a' maa ndo ma ora ikan, ");
INSERT INTO mza_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vati yu'u ni ku'vai ma tu'un ka'an ndo chi'in na ma ora ikan, ti ni ka'an ndo iin tu'un ndaa ña na küuga ka'an ma ñivi xaani ndo chata ndo ma ora ikan. ");
INSERT INTO mza_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ta juuni ma tatá ndo chi'in ma'á ndo ni xikoña'a vi ndo nuu ma ndra kumitiñu. Ta indukuni ni ja'a ma ndra yani ndo, chi'in amigu ndo ndia. Ìyo iin nda ndyo'o ni ka'ni na ndia. ");
INSERT INTO mza_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ikan jan ndisaa ñivi ni kuxaani na nde'e na ndo cha'a' ña chìnuni ndo tu'in. ");
INSERT INTO mza_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Va vaji takan ni ta'an ndo, va Ndioo tüvi ni ku'va ra ña kunaa nï'iin ma ixi xini ndo. ");
INSERT INTO mza_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ta ma ndian ni kundeeni nda kati ya'a ma kivi ikan, ni jakakú Ndioo na. ");
INSERT INTO mza_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ta ora ni nde'e ndo ña chīkonuu jandaru ma ñuu Jerusalén, ikan va ni ku'va ndio ndo kuenda ña chani kuyatin kivi ña ni naa yi. ");
INSERT INTO mza_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yakan va ndisaa ndyo'o ta ndian ìyo ñu'u' Judea ma ora ikan, na kunu ndo kukakú ndo iti' yuku. Ta ndian ìyo ñuu Jerusalén, na kee na tichi yi ma ora ikani, ta ndian jàtiñu tichi ku'u, na chïkokani na ma ñuu na ma ora ikan. ");
INSERT INTO mza_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vati ma kivi ikan kùu ma kivi ña ni jande'e ma Racha'nu Ndioo tundo'o kuenda ma ñuu Jerusalén. Ta takan ni jachinu ma tutu Ndioo ma ña kà'an yi. ");
INSERT INTO mza_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Nda'vi ta'an ma ñivi ña'a ña kivi ikan tu ñù'u se'e vi, ta ìyo ndiakuati ña chàxin ndika vi! Vati ma ñuu Jerusalén i'ya ni nde'e yi kua'a' tundo'o chi'in ndisaa ñivi ìyo tichi yi ndia, ti xaani Ndioo nde'e ra na. ");
INSERT INTO mza_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ta ìyo ñivi ni kuvi ma ora kùu kuati jà'a ma ndra jandaru ta ìyo ndian ni tiin ma jandaru, ta kundaka ndra na ku'un ndra tandi'i nuu ñu'u' ñuñivi i'ya. Ta ma ndian yüvi judíu, ni janaa na ndian ìyo ñuu Jerusalén. Ta takan ni ja'a na, nda kati keta kivi ña ni kati Ndioo ña cha kūuni, tajan ni jaña ndio na ña ja'a na yi. ");
INSERT INTO mza_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Tajan ma iti' andivi ni nde'e na kua'a' nakuyi ña ni jayu'vi na, ti ni sama ma nikandii kua kàa yi chi'in yoo ta chele ndia. Ta ma ñivi ìyo ma tiempu ikan, ya'a ni jakanuu chinituni jà'a ña ya'a kàyu jà'a ma tañu'u ora chàsiki ra. ");
INSERT INTO mza_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yakan va ma ora ikan ndava ni kunaa ma ñivi ja'a ña yu'vi na ora ni nde'e na ña takan ni kuu ma nuu ñu'u' ñuñivi i'ya. Vati nda ma nikandii chi'in yoo ta chi'in ma chele ni kanda yi ma tiempu ikan. ");
INSERT INTO mza_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ta ora cha yā'a ndio ña kūu ndisaa yakan, tajan ni nde'e ndio ndo ma ra Se'e ñivi tāchi Ndioo, ña ni kichi ra tichi viko chi'in kua'a' ndatu ra chi'in ña tàcha ra. ");
INSERT INTO mza_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yakan va ora ni nde'e ndo ña takan ni kuu, na ndoni'i ndo nuu ndo ta sii kuuni ndo, ti chani keta ora ni kakú ndo jà'a Ndioo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ta ora chīnu kā'an Jesuu takan, ta te'en kāti tuku ra iin ku'va nuu na: ―Na nde'e ndo naja tà'an ma yutun higu chi'in inga tuku yutun. ");
INSERT INTO mza_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Vati ora ndè'e ndo ña kèta nda'a' yuta' run, ta cha chìto ndo ti chani kuta'an ma tiempu ni'ni. ");
INSERT INTO mza_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yakan va ora ndè'e ndo ma tundo'o ña kàtitu'in nuu ndo, ta cha chìto ndo ti chani kuyatin ma ora ña ni kichi ka'nda ndiko Ndioo tiñu nuu ñuñivi i'ya. ");
INSERT INTO mza_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ndicha va'a ña kà'in chi'in ndo ti antea ña kuvi ma ñivi ìyo tiempu i'ya, ji'na ni nde'e na tundo'o takua kà'in chi'in ndo i'ya. ");
INSERT INTO mza_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ta ni keta iin kivi ña ni naa andivi chi'in ñuñivi ndia, va ma tu'un kà'in tüvi ni naa yi. ");
INSERT INTO mza_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ta yakan va na ja'a ndo kuenda nuu ndo, ti koto kü'va ndo anima ndo ña na ndondava yi ja'a ña kàan yo ko'o yo kua'a' ndixi, a chànini yo cha'a' ndatiñu ña nì'o ñuñivi i'ya a nda kuati ni kuuni ña tiin yo. Takan ìyo yi ña ja'a ndo kuenda nuu ndo ");
INSERT INTO mza_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","koto iin ketani ma kivi ña ni kichaa ndiko ma Racha'nu takua kùu iin trampa. Vati ni kichi ra kuenda tandi'i ñivi ìyo nuu ñu'u' ñuñivi i'ya. Ti ma kivi ikan ni kuu yi takua kùu iin trampa ña ora jàna'ini na jà'a yi. ");
INSERT INTO mza_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ta yakan va na jakuenda va'a ndo ndo ta na ka'an ndo chi'in Ndioo ndisaa kivi, ikan na kuu kakú ndo nuu tundo'o ña ni nde'e ndo, ta kuu jana'a ndo ndo nuu ra Se'e ñivi tāchi Ndioo ora ni kichaa ndiko ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yakan va Jesuu jàna'a ra ora ndichin ma tichi veñu'u, ta ora chanikuaa chà'an ra chàkusu ra iin yuku ña nàni Olivu. ");
INSERT INTO mza_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ta nani na'a chà'an ma ñivi cha tàso'o na ña kà'an ra ma tichi veñu'u ka'nu ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ora cha kuàta'an viko ña chàchi na paan ña töve kì'vi yuchan iya tichi yi, ña kùu ma kivi viko pakua, ");
INSERT INTO mza_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","tajan nànduku ndio ma ndra sutu chà'nda tiñu chi'in ma ndra matru jàkua'a tutu Ndioo naja kua ja'a ndra ta tiin ndra Jesuu ta ka'ni ndra ra. Va nī küu yi ti ndasii ndra ndè'e ndra ma ñivi. ");
INSERT INTO mza_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Takan kūu, tajan ma kui'na chà'nda tiñu ñá' nàni Satanaa, kī'vi ndioán' anima Juda Iscariote. Ta rakan ti iin ra kùu iin ndi uchi uvi ndra jàkua'a chi'in Jesuu kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ta ikan jan rakan chā'an ra chānde'e ra nuu ìyo ma ndra sutu chà'nda tiñu chi'in ndra jandaru kùmi veñu'u ka'nu ikan. Tajan kīcha'a ndio ra nàtu'un ra chi'in ndra naja kua ni ja'a ra ta ku'va ra Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tajan ora kā'an ra takan ta nduva'a kuii chìsii ndra ta chā'a ndio ndra tu'un ña ni ku'va ndra xu'un' nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tajan ma Juda kāti ndio ra chi'in ndra ti va'a, ta ikan jan kīcha'a ndio ra nànduku ra naja kua ja'a ra ta ku'va ra Jesuu nuu ndra ora tüvi nde'e ñivi. ");
INSERT INTO mza_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ta ora cha kēta kivi viko ña chàchi na paan ña tüvi kì'vi yuchan iya tichi. Ma kivi ikan, chà'ni na iin mvechala kuenda ma viko pakua ti sòkó na ri nuu Ndioo, ikan na jaka'nuni ra kuati na. ");
INSERT INTO mza_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tajan Jesuu te'en nāka'an ndio ra chi'in Petu' ta Xuva: ―Kua'an ndo kuàjandova'a ndo ña kuxinio kivi viko pakua ―kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tajan te'en chīkatu'un ndio ndra nuu ra: ―¿Ndanu kùuniun ña kuja'a ndi ma ña kacho? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tajan te'en nāka'an Jesuu: ―Ora ki'vi ndo ma tichi ñuu ikan, ta ikan nata'an ndo iin ra ndiso iin kii takuii. Ta tandikun ndo ku'un ndo chata ra, nda kati chaa ra ve'e nuu ni ki'vi ra. ");
INSERT INTO mza_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ta ikan na ka'an ndo chi'in ma ra chito'o ve'e ña ma matru ndi chìkatu'un ra ña ndanu ndaa ma ve'e nuu ni kuxini ra chi'in ma ndra jàkua'a chi'in ra, kàti ndo. ");
INSERT INTO mza_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tajan juuni maa ra ni jana'a ra nuu ndo iin ve'e ìyo nda siki inga ve'e ña cha ìyo va'a yi, ikan na ku'un ndo kuja'a ndo ma ña kuxinio ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Takan kūu tajan kēe ndio ndra kuà'an ndra ta nī'i ndra ndisaa yi takua kātitu'un Jesuu nuu ndra, ta ikan jā'a ndio ndra ma ña ni kuxini ndra ma kivi viko Pakua. ");
INSERT INTO mza_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ta ora cha kēta ma ora ña ni kachi ndra, tajan chūnandi ndio Jesuu chi'in ndra kùu tatun ra mesa, ");
INSERT INTO mza_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","tajan te'en nāka'an ra chi'in ndra: ―¡Ya'a ga kùuni̱ jaka'nui viko i'ya chi'in ndo antea ña chàa ora ni nde'i tundo'o ta kuvi̱! ");
INSERT INTO mza_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Vati yu'u kàti̱ chi'in ndo ti töva ni jaka'nui viko i'ya chi'in ndo, nda kati chaa ji'nai nuu chà'nda Ndioo tiñu ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ta ora chinu kā'an ndio ra takan, tajan kī'in ndio ra iin kopa ma vinu, ta nāka'an ra Ndioo cha'a' ra', ta te'en nāka'an ra: ―Na ki'in ndo ma kopa i'ya ta ndisaa ndo nako'o ra', ");
INSERT INTO mza_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","vati yu'u kà'in chi'in ndo ña tüva ni ko'i ma vinu i'ya chi'in ndo inga cha'a', nda kati chaa ndikoi ko'i chi'in ndo nuu chà'nda Ndioo tiñu ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ta ora cha yā'a ña jā'a ra takan, tajan kī'in tuku ra iin paan, ta nāka'an tuku ra Ndioo cha'a' yi, ta chā'nda kuati ra yi ta chā'a ra yi nuu ta'ii'iin ndra, ta te'en nāka'an ra chi'in ma ndra jàkua'a chi'in ra: ―Na kachi ndo paan i'ya ti ña'a kùu ma kuñui ña ni ku'vai kùu yi cha'a' ma kuati ndo. Takan ìyo yi ña ja'a ndo koto naani ndo yu'u ―kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ta ora chinu chāchi ndra, tajan indukuni jā'a ra chi'in ma kopa vinu ndia. Ta te'en nāka'an ra chi'in ndra: ―Na ko'o ndo ma vinu i'ya ti nii̱ kùu ra', vati cha ndòva'a iin tu'un chaa nuu Ndioo jā'a ra' ti chani kati̱ nii̱ cha'a' kuati ndo ta ni kuvi̱ ndia. ");
INSERT INTO mza_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Va ma ra ni xikoña'a yu'u nàndi ra chi'i̱n ma mesa i'ya ndia, ");
INSERT INTO mza_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","vati taku ma ra Se'e ñivi tāchi Ndioo vàchi ra vàchi nde'e ra tundo'o takua kā'an Ndioo chi'in ra. ¡Va nda'vi ta'an ma ra ni xikoña'a yu'u, vati ni nde'e ra tundo'o! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ta ikan jan chìkatu'un ta'an ndra ña nda ra kùu ma ra ni xikoña'a Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iin ora kīcha'a ma ndra jàkua'a chi'in ra kànita'an yu'u ndra ña nda ra kùu ra ni kuu ma ra ka'nuga. ");
INSERT INTO mza_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Takan kūu ta ora chīni Jesuu ma ña kà'an ndra, tajan te'en nāka'an ndio ra chi'in ndra: ―Cha chìto ndo ti ìyo ndra kùu rey chà'nda tiñu nuu ñivi yüvi judíu. Ta vaji ya'a jànde'e ndra tundo'o ma ñivi ora chà'nda ndra ma tiñu, va chàta'ani ndra ora kà'an ma ñivi ti mamaa tiñu va'a kùu ña ja'a ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Va ndyo'o, na tüvi ìyo yi ña ja'a ndo takan, vati taku ma ra kuxini ma nuu ndo ìyo yi ña kuu ra nuu ndi'inia. Ta juuni ìyo yi ña jakuu ra tiñu nuu ndo ndia. ");
INSERT INTO mza_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tava kùu iin ra nàndi chàchi nuu mesa ta ìyo iin ra kùu musu ra, cha chìto va'a ndo ti ma ra nàndi chàchi nuu mesa kùu ma ra kuxini. Va taku yu'u vaji ra kuxini kùi, va juuni ra kùu musu ndo kùi ndia. ");
INSERT INTO mza_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Va taku ndyo'o ti endee ìyo ndo chi'i̱n vaji ndè'i tundo'o va töve nī jaña ndo yu'u. ");
INSERT INTO mza_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ta cha'a' yakan kùu yi ña yu'u ni ku'vai ña na ka'nda ndo tiñu takua chā'a ma tatái ña na ka'ndai tiñu ndia. ");
INSERT INTO mza_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ti ndyo'o ni kachi ndo ta ko'o ndo chi'i̱n nuu mesa nuu ni ka'ndai tiñu, ta juuni ni ndaa ndo tayu, ta ikan jàkutuni ndo kuati ma uchi uvi grupu ma ndian judíu. ");
INSERT INTO mza_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tajan te'en kīcha'a nāka'an ma Racha'nu chi'in Petu': ―Yo'o Petu' na taso'o va'un ña ni ka'in chi'un. Ma Satanaa ma kui'na kuxini, cha jāchikán' ndo nuu ma Racha'nu Ndioo, ti kùunián' ki'án' ku'va ndo nde'o tu ndicha ña jàchi'un ma ña kà'an ma Racha'nu Ndioo, ");
INSERT INTO mza_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","va yu'u chīkain ñamani nuu Ndioo cha'un, ikan na tüvi jañaun ña chīnuniun ja'a ma kui'na. Tajan ora cha chīkoni'i ndikoun ña cha jà'un kuati, na tindeun inga tuku na takua kùu yaniun chi'in ñata'un, na kundee na chinuni va'a na ña kà'in ndia ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tajan te'en nāka'an ndio ma Petu' chi'in Jesuu: ―Yo'o Racha'nu, yu'u ìyo va'i ña ku'in chi'un tichi vekaa a nda kuvi̱ chi'un ndia ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Yo'o Petu', yu'u kà'in chi'un tu juuni ma chanikuaa vitin antea ña nda'yu ma lo'o uni cha'a' ni ka'un ña tüvi nakotoun yu'u ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Takan kūu tajan te'en chīkatu'un tuku Jesuu nuu ma ndra jàkua'a chi'in ra: ―¿A chàku'uni ndo ora tāchi̱ ndo ña sòkaa ndà'a ndo ña ni yunu ni xu'un' ta ni ndichan tüvi cha'a ndo? ¿A kūmani iin nakuyi nuu ndo ma ora ikan? ―kàti Jesuu chi'in ndra. Tajan te'en nāka'an ndra: ―Töve ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tajan te'en nāka'an tuku Jesuu chi'in ndra: ―Vitin va nda ndyo'o ìyo yunu ndo, na kunda'a ndo yi, ta nda ndyo'o ìyo xu'un' ndo na kunda'a ndo yi, ta nda ndyo'o tüvi ìyo machiti ndo na xiko ndo ma ja'ma isukun ndo ta jata ndo iin yi. ");
INSERT INTO mza_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yakan va yu'u kà'in chi'in ndo ti takan ìyo yi ña ta'in. Vati ma tutu Ndioo kà'an yi ña ni nde'e ma ñivi yu'u takua ndè'e na ma ndian jà'a kuatini. Yakan va ndisaa ma ña kà'an ma tutu Ndioo cha'i, takan ni kuu yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tajan te'en nāka'an ndio ma ndra jàkua'a chi'in ra: ―Yo'o Racha'nu, i'ya ìyo uvi ta'an machiti ―kàti ndra chi'in ra. Tajan te'en nāka'an ra: ―Cha küuni̱ ña ka'an ga ndo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tajan kēe ndio Jesuu ma ñuu ta kuà'an ra kuàka'an ra chi'in Ndioo ma yuku nàni Olivu, takua takani jà'a ra. Ta ndīta'an ma ndra jàkua'a chi'in ra kuà'an ndra chata ra ndia. ");
INSERT INTO mza_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ta ora chāa ndio Jesuu ma ikan tajan te'en nāka'an ra chi'in ma ndra jàkua'a chi'in ra: ―Na ka'an ndo chi'in Ndioo ikan tüvi ku'va ndo anima ndo ña jà'a yi kuati ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tajan jāchika ndio ra ma nuu ka'ìin ndra ta chūnandi chiti ra, ta te'en nāka'an ra chi'in Ndioo: ");
INSERT INTO mza_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Yo'o Tatá, kùuni̱ ña na jakaku̱n yu'u nuu ma tundo'o ña ni nde'i. Va tüvi kùuni̱ ña ja'un ma ña kùuni̱, vati na kuu yi tava kùuni maun ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ta ora kā'an Jesuu takan, tajan ma ora ikani kīchi iin tati va'a jà'a tiñu nuu Ndioo iti' andivi ña chā'a yi ñandee ra. ");
INSERT INTO mza_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tajan tañu ma ña tana ku'vi ra jà'a ña ya'a u'vi anima ra, tajan tiá ni'i kīcha'a tuku ra kà'an ra chi'in Ndioo ña ndava chàti ma takuii tiin ra nuñu'u' takua chàti ma nio ora ya'a kua'a' ra' chìta ra'. ");
INSERT INTO mza_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Takan kūu ta ora ndēta ndio ra ña kà'an ra chi'in Ndioo, tajan kēe ndio ra kuànde'e ra nuu ka'ìin ma ndra jàkua'a chi'in ra. Ta ora chāa ndio ra ikan, ta nāta'an ra ndra ña kìxi ndra kàndoyo ndra, ti nī kundee ndra ma ñuma'na jà'a ña ya'a nda'vi kùuni ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tajan te'en nāka'an ndio ra chi'in ndra: ―¿Ta naja ya'a kìxi ndo kàndoyo ndo? ¡Na ndakoo ndo ta ka'an ndo chi'in Ndioo, koto ku'va ndo anima ndo ña ja'a yi kuati! ―Takan kàti Jesuu chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ta juuni kà'anga Jesuu ndaa ra ora ndē'e ra ña chākoyo kua'a' ñivi nuu ndaa ra. Ta Juda, iin ra indii tañu ndi uchi uvi ndra jàkua'a chi'in ra kùu ma ra yosonuu nuu ma ndra jandaru chi'in ma ñivi. Tajan, rakan chājayatin ra ra nuu ndaa Jesuu ta chūnumi ndaa ra ra, ta tūtu ra sitin ra. ");
INSERT INTO mza_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Yo'o Juda, ¿a chi'in ña tùtu̱n siti̱n, chi'in yakan xìkoña'un ma Se'e ñivi tāchi Ndioo? ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tajan ora chīni ma ndra ka'ìin chi'in ra ma ña kā'an ra, tajan te'en kīcha'a ndra chìkatu'un ndra nuu ra: ―Yo'o Racha'nu, ¿a kanita'an ndi chi'in ndra chi'in machiti? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tajan iin ma ra jàkua'a chi'in Jesuu tāvani'i ra machiti ra ta chā'nda ra iin so'o chiyo kua'a ma ra kùu musu ma sutu chà'nda tiñu. ");
INSERT INTO mza_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ta ora ndē'e Jesuu ña takan jā'a ra ta te'en nāka'an ra: ―¡Na jaña ndo ña kànita'an ndo! ―kàti ra. Tajan jānani ndio Jesuu ma nda'a' ra so'o ma ra kùu musu ma sutu ta jānda'a ra yi. ");
INSERT INTO mza_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ta ikan jan te'en nāka'an ndio Jesuu chi'in ma ndra sutu chà'nda tiñu ta chi'in ma ndra jandaru jàkuenda veñu'u ka'nu ta chi'in inga tuku ndracha'nu ña vàchi tiin Jesuu: ―¿A rasu'u kùi ña vàchi tiin ndo yu'u chi'in machiti ta chi'in yutun?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ti tu ndicha ña rasu'u kùi, ta, ¿naja tüvi nī tiin ndo yu'u ma tichi veñu'u ka'nu ora jāna'i nuu ndo nani kivi ma ikan? Ndicha kuii ña takan jà'a ndo ma ora naa, ti vitin kùu ma ora ña chā'a Racha'nu Ndioo ña kuu ndo'iin anima ndo chi'in ma kui'na ña jà'a ndo takua kùuni maa ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tajan tīin ndio ndra Jesuu ta ndāka ndra ra kuà'an ra chi'in ndra nuu ìyo ve'e ma sutu chà'nda tiñu. Ta ikan jan, tāndikun ndio Petu' kuà'an ra chata ra chikani chikani. ");
INSERT INTO mza_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ta ma nuke'e nuu ìyo ve'e ma sutu chà'nda tiñu ikan, jāta'an ma ndra jandaru ñu'ú jàvandaa ma nuke'e chūnandi ndra tùmi ndra yi. Tajan ora ndē'e ma Petu' ña tùmi ndra ma ñu'ú, ta ndīta'an ra chāa ra chūnandi ra tañu ndra tùmi ra yi ndia. ");
INSERT INTO mza_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ta nunuuni chāa iin ña kùu musu ma sutu cha'nu, tajan ora ndē'an ma Petu' ña nàndi ra tùmi ra ma ñu'ú, tajan chūndaa ña ndè'e ndicha ña ra, ta te'en nāka'an ña chi'in ndian ka'ìin ikan: ―Juuni ra'ya kùu iin ra chàkunuu chi'in Jesuu ndia ―kàtian. ");
INSERT INTO mza_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Va Petu' te'en nāka'an ra: ―Ka'nu kooniun yo'o ma'á, va ma ra kà'un chiña na tüvi nàkotoi ra ―kàti ra chi'an. ");
INSERT INTO mza_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ta nunuuni ndē'e iin ra'ii ra, ta rakan te'en nāka'an ra chi'in ra: ―Yo'o kùu iin ra jàkua'a chi'in Jesuu ―kàti ra. Tajan Petu' te'en nāka'an ra chi'in ra: ―¡Yüvi yu'u kùi! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Takan kūu ta nunuuni ora cha yā'a iin ora tajan chāa inga tuku ra, ta rakan te'en nāka'an ra chi'in ndian ka'ìin ikan: ―Ndicha kuii ña ra'ya kùu iin ra chàkunuu chi'in Jesuu vati juuni ra ñu'u' Galilea kùu ra ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tajan te'en nāka'an ma Petu' chi'in ra: ―Yo'o tatá, na tüvi nàkotoi nda ra kùu ma ra kà'un ―kàti ra. Tajan juuni kà'anga Petu' nàndi ra ora nānda'yu iin lo'o. ");
INSERT INTO mza_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ta ikan jan chīkoni'i Jesuu xini ra ndē'e ra nuu ma Petu', tajan chāku'uni ra ma ña kā'an ma Racha'nu chi'in ra ña: “Antea ña nda'yu lo'o ma vitin uni cha'a' ni ka'un ña tüvi nàkotoun yu'u.” Takan chāku'uni ra ma ña kā'an Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tajan kēe ndio Petu' ma ikan, ta nduva'a kīcha'a ra chàku ra ti ya'a nda'vi kùuni ra. ");
INSERT INTO mza_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Takan kūu ta ma ndra jàkuenda Jesuu chàtu'un ndra ra ta kàni ndra ra. ");
INSERT INTO mza_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ta chàsi ndio ndra tinuu ra chi'in ja'ma ta kāni ndra ra, ta te'en chìkatu'un ndra nuu ra: ―¡Ka'an, nde'o yo kàni ñu̱n! ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ta juuni kànduva'a ndra ra chi'in inga tuku tu'un kini ndia. ");
INSERT INTO mza_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta ora kūndichin inga kivi tajan kūti'vi ndio ma ndracha'nu ña chà'nda tiñu nuu ñivi judíu chi'in ndra sutu cha'nu ña chà'nda tiñu nuu sutu ta chi'in inga ndra jàkua'a tutu Ndioo. Tajan tīin ndio ndra Jesuu, ta ndāka ndra ra kuà'an ra chi'in ndra nuu ndra kumitiñu. Ta ora chāa ndio ndra ma ikan chi'in ra tajan te'en kīcha'a ndra chìkatu'un ndra nuu ra: ");
INSERT INTO mza_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―¿A ndicha ña yo'o kùu ma ra Cristu? ―kàti ndra. Tajan te'en nāka'an ndio ra chi'in ndra: ―Tu kati̱ nuu ndo ña ndicha ña takan kùu yi ta na töve ni chinuni ndo ma ña kà'in. ");
INSERT INTO mza_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta tu ndakatu'in iin tu'un nuu ndo, chìtoi ña na töve ni naka'an ndiko ndo yi nui, ta ni tüvi ni jaña ndo yu'u ndia, ");
INSERT INTO mza_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","va nda vitin ta nda iti' nuu, ni kunandi ma ra Se'e ñivi chiyo kua'a Racha'nu Ndioo, ra ìyo kua'a' ndatu ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tajan te'en kīcha'a ndisaa ndio ndra chìkatu'un ndra nuu ra: ―¿A ndicha va'a ña yo'o kùu ma ra se'e Ndioo? ―kàti ndra. Tajan te'en nāka'an Jesuu chi'in ndra: ―Ndicha kùu yi ña ma kua kà'an ndo chiña takan kùi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ta ikan jan te'en nāka'an ndra chi'in ma ndra meru ndra: ―¿Nda kuenda ña chìniñu'u yo tiá ma ndian kùta'an chi'o tuva ndisaa yo cha chīni yo ña kā'an ra chata Racha'nu Ndioo? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tajan ndēta ndio ndisaa ndra ta chā'an ndra chi'in Jesuu nuu chà'nda Pilatu tiñu. ");
INSERT INTO mza_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ta ora chāa ndio ndra ma nuu chà'nda ra tiñu, tajan te'en kīcha'a ndra tìsokuati ndra Jesuu nuu ra: ―Nāta'an ndi ra'ya ña jànda'viña'a ra ñivi ma ñuu ndi. Ta kàti ra ti na tüvi ìyo yi ña tia'vi ndi ma xu'un' nuu ma ra kuvienu ma ñuu ka'nu Roma. Ta juuni kàti ra ña Cristu, ra chà'nda tiñu nuu ndi kùu ra. Takan kàti ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tajan te'en chīkatu'un ndio ma Pilatu nuu ra: ―¿A ndicha ña yo'o kùu ma ra chà'nda tiñu nuu ñivi judíu? ―kàti ra. Tajan te'en nāka'an Jesuu: ―Maun kà'an ña takan kùu yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ta ikan jan te'en nāka'an ndio ma Pilatu chi'in ma ndra sutu cha'nu ña chà'nda tiñu nuu sutu ta nuu ma ñivi ndia: ―Tükuii nàta'in nï'iin kuati ña jā'a ra, ta küu ni'i̱ kua tisokuati̱ ra ―kàti Pilatu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ta ikan jan te'en kīcha'a na kànachaa na tiá ni'i: ―Ninii ka'nu ñu'u' Judea jàkanuu ra xini ñivi chi'in ma tu'un kà'an ra. Kīcha'a ra jà'a ra yi chi'in ñivi ìyo ñu'u' Galilea, ta vitin juuni takan vàchi jakanuu ra xini ñivi ìyo ñu'u' Judea i'ya ndia. ―Takan kàti na chi'in Pilatu. ");
INSERT INTO mza_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ta ora chīni ndio Pilatu ña kā'an na ma tu'un Galilea, ta ikan jan chīkatu'un ndio ra nuu ma ñivi tuva ra ñu'u' Galilea kùu Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ta ora kāti ndio na ña ndicha ña takan kùu yi, tajan tāchi ndio ra ra nuu Herode, ra chà'nda tiñu ma ñu'u' Galilea. Ta ma tiempu ikan ti juuni ìyo Herode ma ñuu Jerusalén ndia. ");
INSERT INTO mza_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Takan kūu ta ora ndē'e ndio Herode ma Jesuu ta nduva'a kuii chìsii ra, ti cha ìyo kua'a' tiempu ña kùuni ra nde'e ra ra ña na ja'a ra iin ndatu nuu ra, vati iin ra ña ya'a va'a kà'an ma ñivi chata, kùu ra. ");
INSERT INTO mza_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tajan kīcha'a ndio Herode chìkatu'un ra kua'a' tu'un nuu ra, va tükuii nani kā'an ra. ");
INSERT INTO mza_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ta ma ndra sutu chà'nda tiñu nuu sutu chi'in ma ndra matru jàkua'a tutu Ndioo vi'a ni'i kīcha'a ndra tìsokuati ndra ra. ");
INSERT INTO mza_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ta ikan jan, Herode chi'in ndra jandaru ra kīcha'a ndra chàkundaa ndra Jesuu. Ta jāku'un ndio ndra iin ja'ma vii ña kàa takua kàa ja'ma ra kùu rey ma Jesuu kuenda ña na kuàtu'uni ndra ra. Ta ora chīnu jā'a ndra takan, tajan tāchi ndiko ma Herode ra nuu Pilatu. ");
INSERT INTO mza_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ta ma Pilatu chi'in Herode, ña na küu nde'e ndra ta'an ndra ma tiempu ikan, juuni ma kivi ikan jaamigu ndra. ");
INSERT INTO mza_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ta ikan jan jāti'vi ta'an ndio ma Pilatu ma ndra sutu cha'nu ña chà'nda tiñu nuu sutu chi'in ndra kumitiñu ta chi'in tandi'i ñivi ñuu, ");
INSERT INTO mza_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ta te'en nāka'an ra chi'in na: ―Maa ndo kīchi ndaka ndo ra'ya nui, ta kàti ndo ti jàkanuu ra xini ma ñivi ñuu. Ta ndè'e chi'in tinuu ndo ña chìkatu'un xain nuu ra, va tükuii nī nata'in nï'iin kuati ña kùu tisokuati̱ ra ma takua kà'an ndo nui nda che'e. ");
INSERT INTO mza_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta ni Herode töve nī nata'an ra nï'iin kuati chata ra ndia, ti tu ndicha ña ìyo kuati ra na tüva ìyo yi ña tachi ndiko ra ra nui. Yakan va cha chìto ndo ti töve ìyo nï'iin kuati ra ña kùu ka'nio ra cha'a' yi. ");
INSERT INTO mza_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yakan va tundo'oni ni jande'i ra. Jaña ndikoi ra na ku'un ra ―kàti Pilatu chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Vati ta'ii'iin kuiya ora ìyo ma viko ikan, ìyo yi ña jachi'in ma Pilatu ña kà'an ma ñivi, ta tàva ra iin ra indii vekaa takua takani ìyo ma costumbre. ");
INSERT INTO mza_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ta ikan jan te'en kīcha'a tuku na kànachaa na: ―¡Na ka'niun Jesuu nuu kruu, ta na jañaun Barrabás! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Takan kūu ta ma Barrabás ti cha'a' ña jàkanuu ra xini ñivi ta cha'a' ña chà'ni ra kùu yi ña indii ra ma tichi vekaa. ");
INSERT INTO mza_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Va tava Pilatu kùuni ra jaña ra Jesuu, yakan va nāka'an ndiko ra chi'in na ña va'a ga ña na jaña ra Jesuu, kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Va ma ñivi te'en kīcha'a na kànachaa ni'i ga na: ―¡Na kuvi ra nuu kruu! ¡Na kuvi ra nuu kruu! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ta ikan jan cha'a' uni te'en nāka'an tuku Pilatu chi'in na: ―¿Ta nda cha'a' kùu yi ña tìsokuati ndo ra tuva takan? Vati yu'u tükuii nī nata'in nï'iin kuati ra ña ìyo yi ña kuvi ra cha'a', yakan va tundo'oni ni jande'i ra ta jañai ra ―kàti Pilatu chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Va ora chīni na ña kā'an ra te'en, ta vi'a ni'i kīcha'a na kànachaa na, ta kà'an na ña na kuvi ra nuu kruu. Ta takan endee kà'an na nuu ra nda kati kundee na ña jà'a ra ma ña kùuni na. ");
INSERT INTO mza_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ta ikan jā'a ndio Pilatu ma ña chìkan na nuu ra, ");
INSERT INTO mza_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","tajan tāvani'i ndio ra Barrabás, ra indii tichi vekaa jà'a ña jàkanuu ra xini ñivi ta ra chà'ni kùu ra. Ta tī'i ra Jesuu nda'a' ma ndra jandaru ma takua kùuni na. ");
INSERT INTO mza_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Takan kūu ta ora cha kuàtakaa ndra ra nuu kruu, tajan ma tichi iti' kuà'an ndra chi'in Jesuu, ikan ndē'e ma ndra jandaru iin ra ñuu Cirene ra nàni Simón ña cha vàchi ra ña chā'an ra ku'u. Tajan tīin ndra ra ta jā'a ndra ña na kuiso ra kruu ña ndiso Jesuu. Ta tāndikun ra kuà'an ra chata ra. ");
INSERT INTO mza_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ta nduva'a kuii kua'a' na kàcha'an chata Jesuu. Ta ikan kàcha'an ñivi ña'a ña kàchaku cha'a' ra, ti ya'a u'vi anima vi jà'a ña ya'a nda'vi kùuni vi ña ndè'e ra tundo'o. ");
INSERT INTO mza_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Va ora ndē'e ndio ma Jesuu vi, ta te'en nāka'an ra chi'in vi: ―Ndyo'o ñivi ña'a ñuu Jerusalén, na kuäku ndo cha'i. Na kuaku ndo cha'a' juuni maa ndo ta cha'a' se'e ndo, ");
INSERT INTO mza_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","vati ni chaa iin kivi ña ni nde'e ndo tundo'o, ta ikan jan te'en ni ka'an ndio ndo chi'in ma ñivi: “Na sii kuuni ma ñivi ña'a ña tüvi nī chiyo nï'iin se'e ta ña tüvi nī jakaxin se'e ndia, vati vitin cha kīcha'a yo ndè'o tundo'o, ta tiaga ndetiñu kuenda yo tuva ìyo ma se'o”, ni kati ndo chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tajan ma kivi ikan ni kati ndio ma ñivi ña va'a ga ña na kekoyo ma yuku, ta ikan na kuvi na ta tüva nde'e na tundo'o, kùuni na. ");
INSERT INTO mza_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Takan kàti̱ chi'in ndo ti yu'u kùu takua iin yutun i'ii ta ndè'i tundo'o vitin, va ndyo'o kùu ndo takua kùu iin yutun ití vi'a ga ni nde'e ndo tundo'o iti' nuu. ―Takan kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta juuni ndāka ma ndra jandaru uvi ta'an ma ndra kini ña chā'ni ñivi ña kuàka'ni ndra ndra chi'in Jesuu ndia. ");
INSERT INTO mza_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tajan ora chāa ndio ndra ma yuku ña nàni nuu ndòyo iki xini ndian chī'í, tajan tākaa ndio ndra Jesuu nuu kruu chi'in ma uvi ta'an ma ndra su'u: iin ra chūtaka chiyo kua'a ra, ta inga ra chiyo satin ra. ");
INSERT INTO mza_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ta ikan jan te'en nāka'an ndio ma Jesuu chi'in ma Racha'nu Ndioo ora cha tàkaa ra nuu kruu: ―Yo'o Tatá, na jaka'nuniun ma kuati jà'a na, vati töve chìto na ña jà'a na ―kàti Jesuu. Tajan kīcha'a ndio ma ndra jandaru chàsiki ndra yuu kuati, nde'o nda ndra kùu ndra jàkanaa ma ja'ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tajan ndisaa ma ñivi ka'ìin ikan ndē'e na ña tā'an Jesuu, ta juuni ma tañu na ka'ìin ma ndracha'nu chà'nda tiñu nuu ñivi judíu. Ta ndrakan te'en kīcha'a ndra chàtu'un ndra Jesuu: ―Tu kūu jakakú ra inga ñivi, vitin na jakakú ra juuni maa ra tu ndicha ña Cristu ra kāchin Ndioo kùu ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Takan kūu ta nda ma ndra jandaru chàkú ndaa ndra Jesuu, ta chājayatin ndra ndra ma nuu tàkaa ra, ta chà'a ndra vinu iya chì'i ra, ");
INSERT INTO mza_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ta ndrakan te'en nāka'an ndra chi'in ra: ―¡Tu ndicha ña yo'o kùu ma rey ña chà'nda tiñu nuu ñivi judíu, na jakakú maun ñu̱n tuva takan! ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta juuni tātuu ndra iin vitu iti' xini kruu ña te'en kà'an yi chi'in ma tu'un griegu, chi'in tu'un latinu, ta chi'in tu'un hebreu: “Ra'ya kùu ma rey ña chà'nda tiñu nuu ñivi judíu”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tajan iin ma ra sù'u ta chà'ni ña tàkaa xiin Jesuu, te'en kīcha'a ra kà'an ra chi'in Jesuu ña chàtu'un ra ra: ―¡Tu ndicha ña yo'o kùu ma Cristu, na jakakú maun ñu̱n ta na jakaku̱n ndyu'u ndia! ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Va ma ra tàkaa inga chiyo Jesuu, te'en nāka'an ra chi'in ma meru ra: ―Yo'o xaa, ¿ta naja töve tìñu'u̱n Ndioo ta juuni ndè'un tundo'o takua ndè'e ra yi ndia? ");
INSERT INTO mza_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Vati taku maa yo ndè'o tundo'o ti ndicha ña jā'a yo kuati. Yakan va vitin takan ìyo yi na tia'vio cha'a' yi. Vati ndicha ña jā'a yo yi, va taku ra'ya, tükuii nani jà'a ra ta ndè'e ra tundo'o ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tajan te'en nāka'an tuku ra chi'in Jesuu: ―Yo'o Racha'nu Jesuu, na kuku'uniun yu'u ora ni chaun nuu ni ka'ndaun tiñu ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tajan te'en nāka'an ndio Jesuu chi'in ra: ―Ndicha va'i ña ka'in chi'un, vati juuni ma kivi i'ya ni koun chi'i̱n iti' andivi ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Takan kūu ta ora kēta ma kachuvi ndaa, ta iin kuaani ma nuu ñu'u' ñuñivi nda kaa uni chani'ini. ");
INSERT INTO mza_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tajan ndā'va nuu ma nikandii ta ma ja'ma ña tàkaa ma tichi veñu'u ka'nu, endee ndāta java ndaa yi ma ora ikan. ");
INSERT INTO mza_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ta ikan jan nānda'yu ni'i Jesuu ta te'en nāka'an ra: ―Yo'o Tatá, na jàkuendaun animai, vati vitin tì'i̱ yi nda'un ―kàti ra. Ta ora chīnu ña kā'an ra takan, ta chī'í ra. ");
INSERT INTO mza_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ta ora ndē'e iin ra capitán, ra chà'nda tiñu nuu jandaru naja kua chī'í Jesuu, tajan kīcha'a ra jàka'nu ra Ndioo chi'in tu'un i'ya: ―Ndicha kuii ti ra'ya tüvi ìyo kuati ra ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ta ndisaa ñivi ka'ìin ma ikan ora ndē'e na ña takan kūu, tajan chītakuati ndio na kuà'an na ve'e na. Ta kàni na pechu na ti ya'a u'vi anima na ña ndè'e na naja kua chī'í Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Takan kūu ta tandi'i ndra nàkoto Jesuu ta chi'in ñivi ña'a ña chākunuu chata ra nda iti' Galilea, kīndoo na nde'e chikani na naja kua tā'an Jesuu ora chī'í ra. ");
INSERT INTO mza_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ma tiempu ikan ìyo iin ra va'a ña nàni Kusé, ta rakan ti ra kīchi ñuu Arimatea ña ìyo kuenda ñu'u' Judea kùu ra. Va juuni ndiso ra tiñu chi'in ma ndian judíu. Va tüvi nī chata'ani ra ma ña jā'a ma ndra tiñu chi'in Jesuu, vati juuni ndàtu ra ku'un ra nuu chà'nda Ndioo tiñu ndia. ");
INSERT INTO mza_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yakan va kēe ra kuà'an ra nuu ìyo Pilatu, ta chīkan ra ñunda'yu Jesuu nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Takan kūu ta ora cha jānuu ndio ra ñunda'yu Jesuu ma nuu kruu, tajan kāva ndio ra iin ja'ma savana ña ya'a va'a ta vii ma ñunda'yu Jesuu, ta kūchi ra yi iin tichi yavi yuu nuu takä'an kuchi na nï'iin ñivi. ");
INSERT INTO mza_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ikan kūchi ndio na Jesuu vati ma kivi ikan kùu ma kivi jandova'a ma ñivi judíu ma ña kachi na kuenda inga kivi, ma kivi nindeo. ");
INSERT INTO mza_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Takan kūu ta ndisaa ma ñivi ña'a chākunuu chata Jesuu nda ora chākunuu ra ñu'u' Galilea, chā'an vi chānde'e vi ma nuu kūchi ndra yi. Ta juuni ndē'e vi nuu jundii ndra yi ndia. ");
INSERT INTO mza_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ta ikan jan kēe ndio vi kuà'an vi ve'e vi. Ta ora chāa ndio vi tajan jāndova'a vi takuii xiko, vati ni ku'un vi kujakuti vi ñunda'yu Jesuu ti koto ku'ini yi. Takan kūu tajan ndisaa ma ñivi ña'a ikan nīndee vi ma kivi ikan takua kà'an ma tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tajan ma kivi nunuu nuu kìcha'a ma jamana, na'a va'a kēe ndio vi kuà'an vi kuànde'e vi nuu kūchi ma ñunda'yu Jesuu. Ta juuni ndà'a vi ma takuii xiko ña koso vi chata ma ñunda'yu Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ta ora chāa ndio vi ta ndē'e vi ña cha tüva ndàsi ma yuu ikan yu'u ma yavi nuu kàndii ma ñunda'yu Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tajan kī'vi ndio vi tichi yi va nī nata'an ga vi ma ñunda'yu ra ma ikan. ");
INSERT INTO mza_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ta ikan jan nduva'a kuii yū'vi vi ña nī tuvi chìto vi nayi jà'a vi. Ta nunuuni ndē'e vi ña kēta uvi ta'an ndra'ii yatin xiin vi ña ñù'u ndra ja'ma tacha. ");
INSERT INTO mza_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tajan ndava yū'vi maania vi chūnandi chiti vi nuu ndra nda kati nani te'e nuu vi nuu ñu'u'. Tajan ndrakan te'en kātitu'un ndio ndra nuu vi chi'in tu'un i'ya: ―¿Ta naja nànduku ndo ma ra ndito ma nuu kùchi ndian chì'í? ");
INSERT INTO mza_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Rakan cha tüva ra i'ya, ti cha nātaku ndiko ra. Na kuku'uni ndo ma ña kātitu'un Jesuu nuu ndo ora juuni chākunuu ga ra ma ñu'u' Galilea: ");
INSERT INTO mza_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ma ra Se'e ñivi tāchi Ndioo, ìyo yi ña tiin na ra ta ti'i na ra nda'a' ma ndian jà'a kuati. Ta ndiakan ni takaa na ra nuu kruu, ta tichi uni kivi ni nataku ndiko ra.” Takan kàti ma ndra kēta ikan nuu vi. ");
INSERT INTO mza_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tajan ma ora ikan ta chāku'uni vi ma tu'un ña kātitu'un Jesuu nuu vi niku. ");
INSERT INTO mza_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Takan kūu tajan kēe ndio vi ma ikan, ta kuà'an ndio vi ma nuu ka'ìin ti'vi ma ndi uchi iin ma ndra kùu tatun Jesuu, ta ikan kātitu'un vi nuu ndra ma ña ndē'e vi ta nuu inga ñivi ña ka'ìin chi'in ndra ndia. ");
INSERT INTO mza_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ta ma ñivi ña'a ña chā'an chākatitu'un nuu ma ndra tatun ra kùu ma Ndiya Magdalena chi'in Juana, ta Ndiya ma'á Jandiau, ta chi'in inga tuku ñivi ña'a ndia. ");
INSERT INTO mza_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Va ma ndra tatun Jesuu chànini ndra ti tìvi xini vi ña kā'an vi takan, kùuni ndra. Yakan va tüvi nī jachi'in ndra ma ña kà'an vi. ");
INSERT INTO mza_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Takan kūu tajan kāndakunu ndio Petu' kuà'an ra nuu kūchi Jesuu. Ta ora chāa ra ta ndē'e ra ña jāndaa ma ja'ma kuichin ña chūsukunia ra kàndii, tajan yū'vi maania ra kāndakunu ra kuà'an ndiko ra nuu ka'ìin ti'vi ma ndian meru ra, ti töva nī nata'an ra ñunda'yu Jesuu. ");
INSERT INTO mza_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tajan juuni ma kivi ikan, kēe ndio uvi ta'an ma ndra jàkua'a chi'in Jesuu kuà'an ndra iti' ñuu nàni Emaús ña ìyo uchi iin kilometru ña chika kàndii yi ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tajan ndrakan, nàtu'un ta'an ndra cha'a' ndisaa ña tā'an Jesuu ma nuu kuà'an ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ta ora juuni nàtu'un ta'an ndra ta kànita'an yu'u ndra, ta kēta ndio Jesuu nuu ndra ta ndīta'an ra tiin chata ndra ndia. ");
INSERT INTO mza_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ta vaji ndè'e ndra ña kuà'an ra chi'in ndra, va tüvi nàkoto ndra ra, ti Ndioo tüvi chà'a ra ña na nakoto ndra ra. ");
INSERT INTO mza_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ta ikan jan te'en kīcha'a ndio Jesuu chìkatu'un ra nuu ndra: ―¿Nayi nàtu'un ndo ma tichi iti' kàcha'an ndo? ¿Ta naja nda'vi kùuni ndo? ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tajan iin ma ra kuà'an chi'in ndra ña nàni Cleofas, te'en chīkatu'un ra nuu Jesuu: ―Tandi'i ñivi ìyo ñuu Jerusalén chìto na ma ña kūu ikan. ¿A uvaa yo'o kùu ma ra tüvi chìto ma ña kūu? ―kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tajan te'en nāka'an Jesuu: ―¿Nayi kūu ma ikan? ―kàti ra. Tajan te'en nāka'an ndra: ―Nàtu'un ndi cha'a' ndisaa ña tā'an Jesuu ra ñuu Nazaret, vati rakan iin ra kà'an chi'in tu'un yu'u Ndioo kùu ra. Ta ya'a ìyo ndatu ra chi'in ma ña jà'a ra, ta chi'in tu'un kà'an ra nuu Ndioo, ta chi'in ndisaa ma ña jà'a ra chi'in ma ñivi ndia. ");
INSERT INTO mza_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ta juuni chāku'uni ndi naja kua jā'a ndra sutu chà'nu ña chà'nda tiñu nuu sutu chi'in ndra kumitiñu ña tīin ndra ra ta tīsokuati ndra ra ta chā'ni ndra ra nuu kruu. ");
INSERT INTO mza_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ta ndyu'u chànini ndi ti rakan kūu ma ra kùndeeni ndi ña vàchi jakakú ndi nuu tundo'o chi'in tandi'i ñivi Israel niku, va vitin cha kēta uni kivi kùu yi ña kūu takan. ");
INSERT INTO mza_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ta juuni ya'a nda'vi kùuni ndi, vati ìyo uvi uni ñivi ña'a ña ìyo tañu ndi jāyu'vi vi ndyu'u vati ora chā'an vi chānde'e vi nuu kūchi Jesuu, ta töva ni nāta'an vi ma ñunda'yu ra. ");
INSERT INTO mza_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yakan va kēe ndiko vi kīchi katitu'un vi nuu ndi ta kàti vi ti kēta uvi ta'an tati ña jà'a tiñu nuu Ndioo nuu vi, ta kāti yi chi'in vi ti Jesuu cha nātaku ndiko ra. ");
INSERT INTO mza_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ta ìyo iin ndra chàkunuu chi'in ndi, juuni chā'a ndra chānde'e ndra nuu kàndii ñunda'yu ra ora cha yā'a cha'an vi. Va indukuni tüvi nī nata'an ndra ñunda'yu Jesuu, takua kātitu'un vi nuu ndra ndia. ");
INSERT INTO mza_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Takan kūu ta ikan jan te'en nāka'an ndio Jesuu chi'in ndra: ―¿A ya'a ndava xini ndo ña tüvi chìnuni ndo ma ña kātitu'un ma ndra kà'an chi'in tu'un yu'u Ndioo ña chīyo taji'na? ");
INSERT INTO mza_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A yüvi cha'a' yakan kùu yi ña ìyo yi ña ndè'e ji'na ma ra Cristu tundo'o, tajan ni ki'vi ndio ra koo ra nuu ni jaka'nu Ndioo ra?, kùuni ndo ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Takan kūu ta ikan jan kīcha'a ndio Jesuu kàtitu'un kachin ra nuu ndra tandi'i ma tu'un ìyo nuu ma tutu Ndioo ña ìyo kuenda ra, ta kīcha'a ra nda nuu kìcha'a ma tutu ña tāa Moisés, ta nda kati jandi'i ra tandi'i ma ña tāa ma ndra kà'an chi'in tu'un yu'u Ndioo naja kua ni kuu yi ma tiempu i'ya. ");
INSERT INTO mza_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ta ora cha chāa ndra ma ñuu ikan kuà'an ndra, tajan jā'ani Jesuu ña ni yā'a nduu ra ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tajan chi'in tu'un i'ya jānini ndra ra na kindoo ra chi'in ndra: ―¡Na kindoun kavaun chi'in ndi ma chanikuaa i'ya, vati cha chìso nikandii! ―kàti ndra chi'in Jesuu. Tajan kī'vi ndio Jesuu chi'in ndra ma tichi ve'e nuu ni kava ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Takan kūu ta ora cha ka'ìin ndra yu'u mesa ña ni kachi ndra, tajan kī'in ndio Jesuu iin paan ta jā'ií ra yi nuu Ndioo, ta chā'nda kuati ra yi ta chā'a ra yi nuu ndra na kachi ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tajan ma ora ikani nānde'e va'a ndra ta nākoto ndra ti Jesuu kùu ra, va tükuii nàni ni'i ndra ja'a ndra vati numi kuii naa ndiko ra. ");
INSERT INTO mza_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tajan te'en kīcha'a ndio ndra nàtu'un ta'an ndra: ―Ma ninduvi yo chā'a va'a yo kuenda ña ya'a chìsii kuuni anima yo ora kātitu'un kachin ra naja kua kà'an ma tutu Ndioo nuu yo cha'a' ra ―kàti ndra ña nātu'un ta'an maa ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Takan kūu tajan nī kuunia ndra ndoo ndra kuatu ndra tiá ma ikan, ti ma ora ikani chīkoni'i ndiko ndra kuà'an ndra ma ñuu Jerusalén nuu nāta'an ndra ña ka'ìin ti'vi ndi uchi iin ndra tatun Jesuu chi'in inga tuku ndra meru ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ta ikan jan te'en kīcha'a ndio ndra tatun Jesuu kàtitu'un ndra nuu ma ndra kīchi: ―Ndicha kuii ña takan kùu yi ña juuni kātitu'un ra nuu ndi ña ndē'e ma Petu' ra ndia. ―Takan kàti ndra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tajan ninduvi ndio ndra kātitu'un ndra nuu ndra tandi'i naja kua tā'an ndra ma tichi iti', ta naja kua nākoto ndra Jesuu ora chā'nda kuati ra paan chā'a ra nuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ta juuni kà'an ga ndra ka'ìin ndra ora tūvi Jesuu ma'ñu ndra, ta te'en kāña'a ra chi'in ndra: ―Na koo va'a ndo chi'in ta'an ndo ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tajan ma ora kā'an ra takan ta nduva'a kuii yū'vi ndra, ti kūuni ndra ña ni'na Jesuu kùu yi ña kēta yi. ");
INSERT INTO mza_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ta ikan jan te'en kīcha'a ndio Jesuu kà'an ra nuu ndra: ―¡Na yü'vi ndo! Ta na tüvi na ja'a ndo ña nàkanini ndo takan, vati ndicha ña mai kùi. ");
INSERT INTO mza_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ta tu töve chìnuni ndo, na nde'e ndo ma nda'i chi'in cha'i. Ta na ke'e ndo yu'u ndia, ta taku ma ni'na tüvi sa'an yi ta ni iki yi, takua ndè'e ndo ña ìyo yi yu'u ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta ora chīnu kā'an ra takan tajan jāna'a ndio ra ma nda'a' ra chi'in cha'a ra nuu ndra, na nde'e ndra yi. ");
INSERT INTO mza_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Va tava ya'a chìsii ndra jà'a ma ña kà'an ra, yakan va ni töva chìto ndra nayi jà'a ndra ta nayi chànini ndra. Ta ikan jan te'en kīcha'a Jesuu chìkatu'un ra nuu ndra: ―¿A ìyo ña kacho nuu ndo? ―kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ta ikan jan chā'a ndio ndra java ma tiaka' tàvi chi'in nduxi ñuñu nuu ra. ");
INSERT INTO mza_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ta tīin ra yi ta chāchi ndio ra yi nuu ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ta ora chīnu chāchi ra tajan te'en nāka'an ndio ra chi'in ndra: ―Ndisaa ma ña tā'in i'ya kùu ma ña kātitu'in nuu ndo ora juuni ìyo gai chi'in ndo. Vati takan ìyo yi ña ta'in ta jachinu ma tutu Ndioo ña tāa Moisés ma ña kà'an yi kuendai chi'in ma tutu tāa ma ndra kà'an chi'in tu'un yu'u Ndioo chīyo taji'na, ta chi'in ña kà'an ma tutu Salmu ndia. ");
INSERT INTO mza_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ta ikan jan te'en nāka'an tuku Jesuu nuu ndra, ikan na nuna va'a ma chìnituni ndra ta taso'o ndra ma ña kà'an ma tutu Ndioo: ");
INSERT INTO mza_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","―Nuu ma tutu Ndioo kà'an yi ti ìyo yi ña nde'e ji'nai tundo'o, va tichi uni kivi ni nataku ndikoi tañu ndian ndií. ");
INSERT INTO mza_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ta ji'na kuii iti' ñuu Jerusalén ìyo yi ña kicha'a na katitu'un na tu'in, ti yu'u kùu ma ra kùu Cristu. Ta ikan jan ku'un ndio na kukatitu'un na tu'in nuu tandi'i ñivi ñuu ñuñivi, ikan na chikoni'i na chi'in Ndioo ta jaka'nuni ra kuati na. ");
INSERT INTO mza_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yakan va ndisaa ndyo'o ndian ka'ìin i'ya cha chìto va'a ndo naja kua tā'in. Ta takan ìyo yi ña ku'va ndo kuenda chi'in ma ñivi cha'a' yi. ");
INSERT INTO mza_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ta ikan jan ni tachi ndioi ma Tati Ií Ndioo chi'in ndo takua kā'an ma Racha'nu Tatái nui niku. Va ndyo'o na kuatu ndo ma ñuu Jerusalén i'ya, nda kati ni'i ji'na ndo ndatu Tati Ií ña ni tachi ra nuu ndo iti' andivi ―kàti Jesuu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Takan jan tāvani'i siin Jesuu tandi'i ma ndra jàkua'a chi'in ra ñuu Jerusalén, ta kuà'an ndio ra chi'in ndra ma ñuu Betania. Ta ikan kāni'i ra nda'a' ra nuu sukun ta jā'ií ra ndra. ");
INSERT INTO mza_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Takan kūu ta ora juuni jà'ií ga ra ndra, ta kueeni kueeni jāchika ra ra xiin ndra, ta ndāa ndio ra kuà'an ra iti' andivi. ");
INSERT INTO mza_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ta ikan jan chūnandi chiti ndio ndra ta kīcha'a ndio ndra jàka'nu ndra ra. Ta ora cha yā'a ña jā'a ndra takan, tajan nduva'a kuii chìsii ndra chìkoni'i ndra ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tajan nani kivi chà'an ndio ndra chàjaka'nu ndra Ndioo ma tichi veñu'u ka'nu ña ndaa ma ñuu Jerusalén. Ta takan na kuu yi. Amén.");
INSERT INTO mza_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ma taji'na ora tūvi ma ñuñivi, takani cha ìyo ma ra kùu ma tu'un. Ta ma ra kùu ma tu'un ikan ìyo ra chi'in Ndioo, ta juuni kùu ra Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ta rakan kùu ra ña takani cha ìyo ra chi'in Ndioo nda ora tūvi ma ñuñivi taji'na. ");
INSERT INTO mza_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta chi'in rakan kùu yi ña jātuvi Ndioo ndisaa nakuyi, ti nï'iin ma ña ìyo nuu yi yöve ma'iin ma Racha'nu Ndioo jātuvi yi, vati kūta'an ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ta juuni rakan kùu ra ña chà'a ra kivi koo ndito ndisaa yo ndian ìyo ma ñuñivi. Ta cha'a' yakan kùu yi ña jàna'a ra nuu yo iti' ndaa ña kùu yi takua kùu iin ñu'ú ña jàndondichin yi nuu yo. ");
INSERT INTO mza_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yakan va ma ra kùu ñu'ú ikan kùu ra ña jàndondichin ra ma nuu naa. Ta ma nuu naa ikan kūuni yi nda'va yi ra, va nī kuu yi. ");
INSERT INTO mza_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Takan kūu yi ña chīyo iin ra chūnani Xuva, ra tāchi ma Racha'nu Ndioo ña, ");
INSERT INTO mza_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","na kùu ra iin ra testigu ña na katitu'un ra cha'a' ma ra kùu ñu'ú i'ya nuu ma ñivi, ikan na chinuni na ma ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Vati ma Xuva, yüvi ma ra kùu ñu'ú kùu ra, vati ra kùu iin testiguni, ra kīchi katitu'un cha'a' ma ra kùu ñu'ú kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Vati ma ra kùu ñu'ú ndicha, ora kīchaa ra ñuñivi i'ya, kīcha'a ra jàtuun ra nuu tandi'i na. ");
INSERT INTO mza_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ta juuni rakan kùu ra ña cha ìyo ra ma ñuñivi i'ya. Uvaa ña ma ndian ìyo ma ñuñivi i'ya, na töve nī ki'in kuenda na ma tu'un kà'an ra, vaji cha'a' maa ra kùu yi ña Ndioo jātuvi ra ma ñuñivi ndia. ");
INSERT INTO mza_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Vati kīchaa ra nuu ìyo ñivi ñuu ra, va ndiakan töve nī ki'in kuenda na ra. ");
INSERT INTO mza_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Va ma ndian kī'in kuenda ma ña kà'an ra, ta chīnuni na ma ña kà'an ra, nuu ndiakan chā'a ra ña na ndakuu na se'e Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ta ndicha ña se'e Ndioo kùu na, va ma ña ndākuu yo se'e Ndioo töve indukuni kùu yi kua ora ña kāku yo jà'a tatá yo chi'in ma'á yo. Vati ndākuu yo se'e Ndioo cha'a' ña takan kùuni ra ña kùu yo, ta töve takua kùuni ma ñivini ña kùu yo. ");
INSERT INTO mza_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Takan kūu ña ma ra kùu tu'un ikan, ndākuu ndicha ra ma ñivi. Ta chīyo ra ñuñivi chi'o, ta kùu ra ma ra chà'a nduva'a kuii kua'a' ñamani Ndioo nuu yo, ta endee jàna'a ra ma ña ndaa ndia. Ta cha'a' ndisaa ña'a maa ndi cha ndē'e ndi ña ra nduva'a kuii ka'nu kùu ra takua ka'nu ma Tatá ra, Ndioo, vati uvaa ra kùu Se'e ra. ");
INSERT INTO mza_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Tajan te'en kātitu'un ndio ma Xuva nuu ma ñivi cha'a' ra: ―Ra'ya kùu ma ra kā'in ña ni kichi tiá iti' nuu, ma ora kātitu'in nuu ndo ña ni kichi iin ra ka'nuga kua yu'u. Vati takani cha ìyo ra ora kētai ma ñuñivi i'ya ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yakan va chi'in ndisaa ma ña ìyo nuu ra, sōkó ra yi nuu yo, ikan na ni'o yi. Ta juuni cha nī'o nduva'a kuii kua'a' ma ñamani ña chā'a ra nuu yo ndia. ");
INSERT INTO mza_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Cha'a' Moisés kùu yi ña nàkoto yo ma ley Ndioo, ta juuni cha'a' Racha'nu Jesucristu kùu yi ña nàkoto yo ma ñamani Ndioo chi'in ma tu'un ndaa ña kà'an ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ta nï'iin ñivi takä'an nde'e na ma Ndioo, ti uvanuuni ma ra Se'e Ndioo, ra endee ìyo chi'in ma Tatá ra, rakan kùu ra ña chà'a ra kuenda nuu yo naja kua kùu ma Tatá ra. ");
INSERT INTO mza_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tajan tāchi ma ndra chà'nda tiñu nuu ndian judíu ña ìyo ñuu Jerusalén ma sutu chi'in ndra levita, ña na kundakatu'un ndra iin nakuyi nuu Xuva. Ta te'en chīkatu'un ndio ndra nuu ra, ora chāa ndra nuu ra: ―¿Ta yo'o nda ra kùu̱n, ta nda tiñu jà'un? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ta ma Xuva te'en kātitu'un kachin ra nuu ndra: ―Yüvi ra Cristu kùu yu'u ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ta ndrakan te'en chīkatu'un ndiko ndra nuu ra: ―¿Ta nda ra kùu̱n tuva takan? ¿A yo'o kùu Elía, ra kà'an chi'in tu'un yu'u Ndioo? ―kàti ndra. Ta ma Xuva te'en nāka'an ra: ―Yöve rakan kùi. Tajan te'en kīcha'a ndiko ndra chìkatu'un ndra nuu Xuva: ―¿A yo'o kùu ma ra kà'an chi'in tu'un yu'u Ndioo, ra ni kichi? ―kàti ndra. Ta ma Xuva te'en nāka'an ra: ―Yöve rakan kùi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ta ndrakan te'en nāka'an ndiko ndra: ―Ta, ¿nda ra kùu̱n tuva takan? Takan chìkatu'un ndi, vati ma tu'un ni ka'un nuu ndi ìyo yi ña kukatitu'un ndi yi nuu ma ndra tāchi ndi. Yakan va, ¿niyi kùuniun kàtitu'u̱n nuu ndi cha'un? ");
INSERT INTO mza_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ta ma Xuva te'en nāka'an ra: ―Yu'u kùu ma ra endee ndà'yu nda java tichi ku'u chi'in tu'un i'ya: “Na nuna ndo iin iti' ndaa, kuenda ma Racha'nu”, takua kā'an Isaía, ra kā'an chi'in tu'un yu'u Ndioo taji'na. ");
INSERT INTO mza_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tajan ndra tāvani'i ma ndra fariseu tiñu nuu, ña kuka'an chi'in Xuva, ");
INSERT INTO mza_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","te'en kīcha'a ndra chìkatu'un ndra nuu ra: ―¿Ta yo chā'a tiñu nuu̱n ña jàkundutaun ñivi tuva yöve ma Cristu kùu̱n, ni Elía, ni ma ra kà'an chi'in tu'un yu'u Ndioo ndia?, tuva takan. ");
INSERT INTO mza_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ta ma Xuva te'en nāka'an ra chi'in ndra: ―Yu'u jàkundutai ñivi chi'in takuii, va tañu ndo cha ìyo iin ra töve nàkoto ndo, ");
INSERT INTO mza_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ta rakan vàchi ra tiaga iti' nuu. Ta kuendai ti iin ra tüvi iñu'u kùi vaji na ndachi̱ ma ndichan indii cha'a ra, ti nduva'a kuii ka'nu ga ra ta ìyo ga ndatu ra kua yu'u ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ndisaa ña'a kūu yi ma ñuu Betábara, ña kàndii iti' kàna nikandii inga chiyo yuta Jordán, nuu ndaa Xuva jàkunduta ra. ");
INSERT INTO mza_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Takan kūu ta inga kivi ndē'e Xuva ma Jesuu, ña kuàjayatin ra ra ma nuu ndaa ra. Ta ikan te'en kīcha'a Xuva kà'an ra: ―¡Nde'e ndo, ti ikan vàchi ma ra kùu mvechala vali ña tāchi ma Racha'nu Ndioo kuenda ña na naa ma kuati yo ndian ìyo ñuñivi i'ya! ");
INSERT INTO mza_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ta cha'a' rakan kùu yi ña kā'in ora nātu'in chi'in ndo te'en: “Tiaga iti' nuu vàchi inga ra ka'nu ga kua yu'u, vati takani ìyo ra ora kēta yu'u.” ");
INSERT INTO mza_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ni yu'u töve nàkotoi nda ra kùu ra niku. Va cha chìtoi ña cha'a' rakan kùu yi ña vàchi jakundutai ñivi chi'in takuii, ikan na ndisaa yo ndian ìyo ñuu Israel nakoto yo ra ―kàti Xuva. ");
INSERT INTO mza_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ta juuni te'en nāka'an tuku ra ndia: ―Ndē'i ma Tati Ií Ndioo ora kīchi nuu yi ma iti' andivi, ña kàa yi takua kàa iin livi ora kōyo yi chata Jesuu nuu kīndoo yi endeeni chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ta ni yu'u, töve nàkotoi nda ra kùu ra niku, va ma ra tāchi yu'u ña na jakundutai chi'in takuii, rakan kātitu'un ra nui te'en: “Ma ra ni nde'un ña ni koyo ma Tati Ií Ndioo chata ma nuu ni kindoo yi, rakan kùu ma ra ni jakunduta ñivi chi'in ma Tati Ií Ndioo.” ");
INSERT INTO mza_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yu'u cha ndē'i ña takan kūu yi chi'in ra, ta kàtitu'in nuu ndo ña ndicha kuii ña ra Se'e Ndioo kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Takan kūu ta ma inga kivi, ndaa ndiko Xuva ikan chi'in uvi ta'an ma ndra chàkunuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ta ora ndē'e ra ña yà'a Jesuu ma ikan, te'en nāka'an ra chi'in ndra: ―¡Nde'e ndo, ti rakan kùu ma ra tāchi Ndioo ña kùu takua kùu iin mvechala vali! ");
INSERT INTO mza_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tajan ora chīni ninduvi ma ndra chàkunuu chi'in Xuva ña kā'an ra takan, ta tāndikun ndra chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ta ndē'e chata ma Jesuu, ta chā'a ra kuenda ña ndikun ndrakan kuà'an ndra chata ra. Tajan te'en chīkatu'un ndio ra nuu ndra: ―¿Niyi nànduku ndo? ―kàti ra. Ta ndrakan te'en nāka'an ndra: ―Yo'o Rabí ―ña kùuni ka'an yi Matru― ¿ndanu ìyoun? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ta ma Jesuu te'en nāka'an ra chi'in ndra: ―¡Na'a ndo chatai!, ta koto ndo ma nuu ìyoi ―kàti ra. Yakan va kēe ndio ndra kuà'an ndra chi'in ra ma nuu ìyo ra, tajan kīndoo ndra chi'in ra nda kati ini ña cha kùu yi a kaa kumi chani'ini. ");
INSERT INTO mza_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","André ra yani Simón Petu', kùu iin ra indii tañu ma uvi ndra ña chīni ña kā'an Xuva, tàndikun ndra chata Jesuu ma ora ikan. ");
INSERT INTO mza_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ta ma ra ji'na kuii ña chīkuta'an ma André kùu ma ra yani ra Simón. Ta te'en kātitu'un ra nuu ra: ―Yo'o yani, cha nāta'an ndi ma ra kùu Mesías (ña chi'in inga tu'un kùuni yi ka'an yi Cristu). ");
INSERT INTO mza_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tajan kēe ndio ma André kuà'an ra chi'in ma yani ra Simón nuu ndaa ma Racha'nu Jesuu. Ta ora ndē'e ma Jesuu ña kīchaa ndra, ta te'en kīcha'a ra kà'an ra chi'in ra: ―Yo'o, Simón se'e Jonás, vitin va ni kunaniun Cefas ―ña chi'in inga tu'un kùuni yi ka'an yi Petu'. ");
INSERT INTO mza_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ta ma inga kivi, kēe ndio Jesuu kuà'an ra ma iti' ñu'u' Galilea takua chànini ra. Ta ikan chīkuta'an ra ma ra nàni Lipe ta te'en nāka'an ra chi'in ra: ―¡Na'a chatai! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ta ma Lipe, ti ra ñuu Betsaida kùu ra, ta iini ñuu ndra chi'in André ta Petu'. ");
INSERT INTO mza_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tajan ma Lipe chā'an ra chānanduku ra, ra nàni Natanael, ta ikan te'en nāka'an ra chi'in ra: ―Cha nāta'an ndi ma ra tāa ma Moisés cha'a' nuu ma tutu ley Ndioo. Rakan nàni ra Jesuu, ra ñuu Nazaret, ra se'e Kusé. Ra juuni tāa ma ndra kà'an chi'in tu'un yu'u Ndioo cha'a' ña ni kichi ndia. ");
INSERT INTO mza_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ta ma Natanael nāka'an ra te'en: ―¿A kùu keta iin ma ra va'a ma ñuu Nazaret?, kùuniun ―kàti ra. Ta ma Lipe te'en nāka'an ra: ―Na kichiun ta nde'un ti ña ndicha kùu yi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ta ora ndē'e Jesuu ña cha vàchi kuyatin Natanael nuu ra, ta te'en nāka'an ra: ―¡I'ya vàchi ma iin ra israelita va'a, ña töve jànda'viña'a! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ta ma Natanael te'en chīkatu'un ra: ―¿Ta naja kà'un ña nàkotoun yu'u? ―kàti ra. Ta ma Jesuu te'en nāka'an ra: ―Takani cha ndē'i ñu̱n antea ña nàta'an ma Lipe ñu̱n ma nuu ndàun vati ma yutun higu ―kàti ra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tajan ma Natanael te'en nāka'an tuku ra: ―Matru, ndicha kuii ña yo'o kùu ma ra Se'e Ndioo, ta juuniun kùu ma ra kùu Rey ra chà'nda tiñu ñuu Israel ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tajan ma Racha'nu Jesuu te'en nāka'an tuku ra: ―¿A cha'a' ña ndē'eni̱ ñu̱n cha'a' ma yutun higuni kùu yi ña chìnuniun ma tu'un kà'in?, kùuniun. ¡Yu'u kà'in chi'un ña nda vitin ta iti' nuu, kua'a' ga tiñu ka'nu ni nde'un! ");
INSERT INTO mza_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Va ma Jesuu te'en nāka'an ndiko tuku ra: ―Ndicha va'a ña kàtitu'in nuu ndo ña ni nde'e ndo ma andivi ña iin nùna kani yi, ta juuni ni nde'e ndo kua'a' tati ña jà'a tiñu nuu Ndioo ña ndàa yi nùu yi chata yu'u, ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Takan kūu ta ora yā'a uni kivi, tajan chīyo iin viko tànda'a ma ñuu Caná, ña ìyo kuenda ma ñu'u' Galilea. Ta ikan ndaa ma'á Jesuu ndia. ");
INSERT INTO mza_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta ma nuu ìyo ma viko tànda'a, juuni jāinvitaa na Jesuu chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tajan ma ma'á Jesuu, te'en nāka'an ña chi'in ra ora ndi'i ma vinu chì'i na nuu viko: ―Se'yu, cha ndī'i ma vinu ―kàti ña chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ta ma Jesuu te'en nāka'an ra: ―Ma'á, ¿ta naja kà'un takan chi'i̱n? Ta juuni takä'an chaa ma ora ña koto ma ñivi nda ra kùi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tajan ma ma'á Jesuu te'en nāka'an ña chi'in ma ndra jàkuu tiñu ma viko ikan: ―Na ja'a ndo ndisaa ma ña ni ka'an ra nuu ndo ―kàti ña. ");
INSERT INTO mza_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ta ma ikan ka'ìin iñu ta'an ma kii na'nu ña kūva'a chi'in yuu ka'nu nuu chàkuiin takuii ña chàtiñu ma ndian judíu ma ora jànandoo na na kuenda Ndioo, takua takani jà'a na. Ta ta'ii'iin ma kii ikan chàta'an uvi xiko uchi a uni xiko uchi litru takuii tichi yi. ");
INSERT INTO mza_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tajan te'en nāka'an ndio ma Jesuu: ―Na jakutu ndo ma kii chiña chi'in takuii. Tajan jākutu ndio ndra yi. ");
INSERT INTO mza_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ta te'en nāka'an ndio ma Jesuu chi'in ndra: ―Ta vitin na tava ndo ita'vi ma takuii, ta kundaka ndo ra' nuu ma ra ndiso tiñu cha'a' ma viko i'ya ―kàti ra. Ta takan jā'a ndra. ");
INSERT INTO mza_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tajan ma ra ndiso tiñu ikan chī'i ra ma takuii ña cha ndākuu ma vinu, nde'o naja kua chì'i ra', vaji nī töve chìto ra ndanu kīchi ra'. Uvanuu ma ndra chìto kùu ma ndra jākutu yi chi'in takuii. Tajan ma ra ndiso tiñu ikan kāna ndio ra ma ra tànda'a, ");
INSERT INTO mza_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ta te'en nāka'an ndio ra chi'in ra: ―Tandi'i ma ñivi jà'a viko, tì'i ji'na na ma vinu va'aga ko'o ma ñivi, ta ora cha chī'i kua'a' ndio na ra', tajan chà'a ndio na ma vinu ta'ania ko'o na. Va yo'o tüvi nī ja'un takan, vati ndākiva'un ma vinu va'aga ma nuu ndi'i nia ―kàti ma ra ndiso tiñu chi'in ma ra tànda'a. ");
INSERT INTO mza_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ña'a kùu ma ndatu nunuu ña jāna'a Jesuu nuu ma ñivi. Ta takan jā'a ra ñuu Caná, ña kàndii kuenda ñu'u' Galilea. Chi'in yakan jāna'a ra ña iin ra ya'a ka'nu kùu ra. Ta ikan kùu nuu kīcha'a chīnuni ma ndra jàkua'a chi'in ra tu'un ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Takan kūu ta ora yā'a ña jā'a ra te'en, ta kēe ndio ra kuà'an ra iti' ñuu Capernaum chi'in ma'á ra, ta chi'in ndra yani ra, ta ndra jàkua'a chi'in ra. Ta ikan kīndoo vi uvi uni kivi. ");
INSERT INTO mza_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ta tava cha kua kuyatin ma kivi viko Pakua ña jàka'nu ma ndian judíu, yakan va kēe ndio Jesuu kuà'an ra ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ta ora chāa ra ma ikan, ta nāta'an ra ña ka'ìin kua'a' ma ndian kàxiko jundiki, mvechala, livi, ta chi'in ma ndian nàndi sàma xu'un' nuu ma ñivi ma tichi kora veñu'u ka'nu ikan. ");
INSERT INTO mza_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ta ora ndē'e Jesuu ña jà'a na, tajan nānduku ra iin yo'o, ta jā'a ra iin kuata, ta jākunu ra ndisaa na chi'in yi, kutu chi'in jundiki xìko na chi'in ma mvechala ndia. Ta ma ndian sàma ma xu'un' chāta ra yi ma nuu ñu'u', ta jānduva ra ma mesa nuu nàndi na ndia. ");
INSERT INTO mza_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ta nuu ma ndian xìko ma livi, va te'en nāka'an ra: ―Na tavani'i ndo tandi'i ña xìko ndo i'ya, ti ma ve'e Tatái, yöve nuu kuya'vi kùu yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tajan ma ndra jàkua'a chi'in Jesuu, chàku'uni ndra ña te'en kà'an yi nuu ma tutu Ndioo: “Ya'aga kàyuni̱ cha'a' ña töve tìñu'u na ma ve'un”, kàti yi nuu yi. ");
INSERT INTO mza_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ta ma ndian kùxini nuu ndian judíu, te'en kīcha'a na chìkatu'un na nuu Jesuu: ―Na jana'un iin ndatu nuu ndi, ikan na koto ndi tuva ndicha ña Ndioo chā'a tiñu nuu̱n ña jà'un te'en. ");
INSERT INTO mza_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tajan Jesuu te'en nāka'an ra chi'in na: ―Na janatani ndi'i ndo ma veñu'u i'ya, ta tichi uni kivi, cha kūtaa ndikoi yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tajan ma ndian judíu te'en nāka'an na: ―Uvi xiko iñu kuiya kùu yi ña jātiñu na, ta kūndee na kūtaa na ma veñu'u ka'nu i'ya, ta vitin yo'o tuku, ¿a kùu kani'un yi tichi uni kivini ña kà'un takan? ―Takan kàti na chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Va ma veñu'u ña kà'an Jesuu nuu na, kùu yi iin ku'va, ti kà'an ra yi cha'a' juuni ma kuñu ra. ");
INSERT INTO mza_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yakan va ora nātaku ndiko Jesuu tañu ñivi ndií, ikan chàku'uni ma ndra jàkua'a chi'in ra ma takua kā'an ra. Tajan ikan kùu ma nuu chīnuni ndio ndra ña kà'an ma tutu Ndioo, ta ña kà'an Jesuu ndia. ");
INSERT INTO mza_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ta ora ìyo Jesuu ma ñuu Jerusalén ma viko Pakua, kua'a' ñivi kīcha'a na chìnuni na tu'un ra, ora ndē'e na kua'a' ndatu ña jà'a ra. ");
INSERT INTO mza_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Va cha nākuni Jesuu naja kua chànini na, yakan va tüvi kùndeeni ra na. ");
INSERT INTO mza_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ta töve chìniñu'u ra, ña ndava kàti na naja kua chànini ma inga ñivi ndè'e na nuu ra, ti juuni maa ra cha chìto va'a ra naja kua chànini na ndia. ");
INSERT INTO mza_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ìyo iin ra fariseu, ña nàni Nicodemo. Ta ra'ya ti iin ra ka'nu kùu ra tañu ma ndian judíu. ");
INSERT INTO mza_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tajan chānde'e ra Jesuu, ma nuu ìyo ra iin chanikuaa. Ta ikan te'en kà'an ra chi'in ra: ―Matru, chìto ndi ña ma Racha'nu Ndioo tāchi ñu̱n kuenda ña jàna'un nuu ndi, ti nï'iin ñivi na küu jà'a na ma ndatu ña jà'un, tu töve kùta'an Ndioo chi'in na ―kati ra. ");
INSERT INTO mza_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tajan Jesuu te'en nāka'an ra chi'in ra: ―Ndicha va'a ma ña kà'in chi'un, ña nda ndian nikuuni na küu koo na nuu chà'nda Ndioo tiñu, tuva juuni takä'an kàku chaa ndiko na kuenda Ndioo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tajan Nicodemo te'en chīkatu'un ra nuu Jesuu: ―¿Ta naja kua jà'a yo, ta kùu kàku yo inga cha'a' tuva cha cha'nu yo? ¿A kùu ki'vi ndiko yo tichi ma'á yo ta kàku ndiko yo inga cha'a'?, kùuniun ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tajan Jesuu te'en nāka'an ra: ―Kàti̱ kachi̱n nuu̱n ña nï'iin na, tu töve kàku ji'na na jà'a ma takuii ta jà'a ma Tati Ií Ndioo ndia, na küu ki'vi na ma nuu chà'nda Ndioo tiñu. ");
INSERT INTO mza_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Vati ndian kàku ñuñivi i'ya, ñivi kuenda ñuñivini kùu na, va ndian kàku inga cha'a', jà'a Tati Ií Ndioo, ñivi kuenda Ndioo kùu na. ");
INSERT INTO mza_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ta na näkaniniun cha'a' ña kà'in ña ndisaa na ìyo yi ña kàku chaa ndiko na inga cha'a'. ");
INSERT INTO mza_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vati taku ma ora chàkin tati, chàkin yi nda iti' nikuuni, ta vaji chìni yo ña jàkayu yi, va tüvi chìto yo nda iti' kuà'an yi, a nda iti' vàchi yi ndia, takan kùu ma ndian kàku chaa jà'a ma Tati Ií Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tajan ma Nicodemo te'en chīkatu'un ndiko ra nuu Jesuu: ―¿Ta nayi kùuni yi ka'an yi ña kà'un takan? ―kàti ra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ta Jesuu te'en nāka'an ra: ―Yo'o ra kùu matru ka'nu nuu ñivi ñuu Israel, ¿ta naja töve chìtoun ma ña kùuni yi ka'an yi? ");
INSERT INTO mza_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ndicha va'a ma ña kà'an ndi chi'un, ti ma ña chìto ndi kùu ma ña kà'an ndi, ta ma ña cha ndē'e ndi, kùu ma ña jàna'a ndi, va ndyo'o na töve chìnuni ndo ma ña kà'an ndi. ");
INSERT INTO mza_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ta tu töve chìnuni ndo ma ña kà'in cha'a' ña kùu ma ñuñivi i'ya, ¿naja kua kuu chinuni ndo ña kà'in cha'a' ma ña kùu ma andivi?, kùuniun, tuva takan. ");
INSERT INTO mza_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nï'iin ñivi takä'an ndaa na ku'un na ma iti' andivi, uvanuu yu'u ra takani ìyoi chi'in Ndioo nàkotoi naja kàa yi, ti ra kīchi iti' andivi kùi. ");
INSERT INTO mza_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Vati takua jā'a Moisés ña kāni'i ra ma koo tichi ku'u ña kùva'a chi'in kaa, indukuni kua ikan ni kani'i na yu'u, ra Se'e ñivi tāchi Ndioo, ");
INSERT INTO mza_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ikan ndisaa ma ndian chìnuni tu'un kà'in, kùu koo ndito na chi'in Ndioo endeeni. ");
INSERT INTO mza_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Takan kūu ta cha'a' ña ya'a ga kùuni Ndioo nde'e ra ma ñivi ñuñivi, yakan va chā'a ra ma ra uvanuu ña kùu Se'e ra nuu na, ikan nda ndian nikuuni tu chinuni na ma tu'un ra, tüvi ni naa na, vati ni ni'i na nuu koo ndito na endeeni chi'in Ndioo jà'a ra. ");
INSERT INTO mza_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Vati Ndioo tāchi ra ma ra Se'e ra kuenda ña na jakakú ra ma ñivi ìyo ñuñivi, ta yöve kuenda ña na tiso ra kuati na ta kuvi na. ");
INSERT INTO mza_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Ta ma ndian chìnuni ña kà'an ma ra Se'e Ndioo, tüvi ni jande'e ra tundo'o endeeni na. Va ma ndian tüvi chìnuni ña kà'an ra, ndiakan va cha kà'an Ndioo ña ni nde'e na tundo'o endeeni cha'a' ña töve chìnuni na ña kà'an ma ra uvanuu ña kùu Se'e ra. ");
INSERT INTO mza_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ta ndicha kuii ña cha kīchaa ma ñu'ú nuu ma ñu'u' ñuñivi, va ma ñivi ìyo ma ñu'u' ñuñivi chàta'ani tiá na nuu naa kua nuu tìin ma ñu'ú ikan, cha'a' ña mamaa ña kini kùu ma ña jà'a na. ");
INSERT INTO mza_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ta ndisaa ma ndian jà'a ma ña kini, töve chàta'ani na ku'un na iti' Ndioo a ma iti' ndichin, koto ku'va ma inga ñivi kuenda cha'a' tandi'i ma tiñu kini ña jà'a na. ");
INSERT INTO mza_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Va ma ndian ìyo indaani, kì'vi na ma iti' ndichin, ta ña'a jàna'a nuu inga ñivi ña na kuu na ñivi ña jà'a mamaa tiñu va'a ti chà'a Ndioo ndatu ra nuu na. ");
INSERT INTO mza_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Takan kūu ta ora yā'a ña kūu te'en, tajan kēe ndio Jesuu kuà'an ra chi'in ma ndra jàkua'a chi'in ra iti' ñu'u' Judea, nuu chīyo ndra yatin kivi ta jākunduta ndra ñivi. ");
INSERT INTO mza_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ta ma tiempu ikan juuni jākunduta ma Xuva ma ñivi iin nuu nàni Enón, ña kàndii yatini ma ñuu Salim, vati ikan kùu nuu kàna kua'a' takuii, ta ma ndian chàa ma ikan, kūnduta na jà'a ra. ");
INSERT INTO mza_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ndisaa ña'a kūu antea ña tī'i ndra ma Xuva tichi vekaa. ");
INSERT INTO mza_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Takan kūu ta iin ma ndra chàkunuu chi'in Xuva kīcha'a ndra kànita'an yu'u ndra chi'in iin ma inga ndra judíu cha'a' ma naja kua kùu yi ña nàndoo na takua takani jà'a ma ndian judíu. ");
INSERT INTO mza_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ta ma ndrakan te'en kātitu'un ndra nuu Xuva: ―Yo'o Matru, ma ra ndaa chi'un inga chiyo yu'u yuta Jordán niku, ma ra kātitu'u̱n iin cha'a' nuu ndi, vitin ndaa ra jàkunduta ra kua'a' ñivi, ta ndisaa na ndikun na ra. ");
INSERT INTO mza_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ta Xuva nāka'an ra te'en: ―Nï'iin yo na küu ni'o a jà'a yo nï'iin nakuyi tu yöve Ndioo kùu ma ra tindee yo. ");
INSERT INTO mza_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Juuni maa ndo cha chīni va'a ndo ma ña kā'in niku, ña na yöve ma ra Cristu kùi, vati yu'u kùu iin ma ra tāchi Ndioo iti' nuu ra. ");
INSERT INTO mza_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Taku ma nuu ìyo iin viko tànda'a, ma ra ndàka ma ña tànda'a, rakan kùu ma iian, va ma ra kùu amigu ma ra tànda'a ña ndaa xiin ra ta chìni ra ma ña kà'an ra, nduva'a chìsii ra ora chìni ra yi. Ta cha'a' yakan kùu yi ña nda yu'u ya'aga ka'nu kùu ma ña chìsii̱ vitin. ");
INSERT INTO mza_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Rakan kùu ra ña ìyo yi ña ndoka'nu ra tiá cha'a' ma ña jà'a ra, ta yu'u ìyo yi ña ndota'ani gai tiá chi'in ma tiñu jà'i ta'ii'iin kivi ―kàti Xuva. ");
INSERT INTO mza_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Takan kūu ta ma ra vàchi iti' andivi, ka'nuga ra kua ndisaa na. Ta ma ndian ìyo nuñu'u' ñuñivi kùu na kuenda ma nuñu'u' ñuñivini, ta kà'an na cha'a' ma ña kùu ñuñivini ndia. Va ma ra ña vàchi iti' andivi, ka'nuga ra kua ndisaa ma ñivi ìyo ñuñivi. ");
INSERT INTO mza_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ta rakan kùu ra ña kàtitu'un ra ma ña ndē'e ra ta ña chīni ra iti' andivi, va nï'iin na töve nī jachi'in na ma ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Va tu ìyo ndian chìnuni ña kà'an ra, ndiakan chà'a na kuenda ta kàtitu'un na ti ma Racha'nu Ndioo kà'an ra ma tu'un ndicha. ");
INSERT INTO mza_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Vati ma ra tāchi ma Racha'nu Ndioo, rakan kà'an ra ma tu'un Ndioo, ti Ndioo jà'a ra ña na endeeni ni koo ma Tati Ií ra nuu ra. ");
INSERT INTO mza_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ti ma Tatá Ndioo ya'a ga kùuni ra nde'e ra ma ra Se'e ra, yakan va chā'a ra kua'a' ndatu ra nuu ra kuenda ña na kuàtiñu ra yi chi'in ndisaa ma ña jà'a ra. ");
INSERT INTO mza_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ta nda ndian chìnuni ma ña kà'an ma Se'e ma Racha'nu, ni koo na endeeni chi'in ra, va ma ndian töve jàchi'in ña kà'an ma ra Se'e ra, tüvi ni ni'i na ma nuu koo na endeeni chi'in Ndioo, ti ni jande'e ra tundo'o ka'nu na endeeni. ");
INSERT INTO mza_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Takan kūu ta chīto ma Racha'nu Jesuu ña ma ndra fariseu chā'a ndra kuenda ña cha chàkunuu kua'a' ñivi chata ra ta jàkunduta ra tiaga ñivi kua Xuva; ");
INSERT INTO mza_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","vaji ndicha ña yöve Jesuu kùu ma ra jàkunduta ñivi, ti ma ndra jàkunduta kùu ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yakan va ora chīto Jesuu ña takan chà'a ndra fariseu kuenda, tajan kēe ndio ra ma iti' ñu'u' Judea, ta kuà'an ndiko ra ma iti' ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta iti' kuà'an ra ìyo yi ña ya'a ji'na Jesuu ma ñu'u' Samaria. ");
INSERT INTO mza_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tajan chāa ndio ra ma iin ñuu ña nàni Sicar ña ìyo kuenda ma ñu'u' Samaria. Ta yatini ma xiin ñuu ikan kàndii iin ti'yo ña chā'a ma racha'nu Jacob nuu rase'e ra, Kusé taji'na. ");
INSERT INTO mza_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ta nuu ma ti'yo ikan ìyo iin soko ya'a kunu ña jā'a Jacob niku. Ta ora chāa Jesuu ikan ya'a chitatu ra ña chākunuu ra, yakan va chūnandi ra yu'u ma soko ikan, ña nìndee ra ma ora ñuka'ñu. ");
INSERT INTO mza_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Takan kūu ta chāa ndio iin ña'a ñu'u' Samaria ña kuàki'an takuii ma tichi soko, tajan te'en nāka'an Jesuu chi'an: ―Na ku'vaun ita'vi takuii ko'i, yo'o ma'á ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ta ma ndra jàkua'a chi'in Jesuu, ti kuà'an ndra kuàjata ndra ña kachi ndra ma ñuu ikan. ");
INSERT INTO mza_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tajan ma ña'a ñu'u' Samaria, te'en nāka'an ña chi'in Jesuu: ―¿Ta nava jà'a yo'o ra judíu ña chìkaun takuii ko'un nui, ta yu'u ña ñu'u' Samaria kùi? ―Takan kàti ma ña'a ikan chi'in Jesuu ti ma ndian judíu tüvi induku kùuni na chi'in ma ndian samaritanu. ");
INSERT INTO mza_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tajan te'en nāka'an ndio Jesuu chi'in ma ña'a ikan: ―Tu chìtoun niyi kùu ma ña va'a ña kùuni Ndioo ku'va ra kuenda ma ñivi ra, ta tu chìtoun nda ra kùu yu'u ra kā'an te'en chi'un “ña na ku'vaun takuii ko'i”, ta yo'o, ni ndakaun takuii nui, ta ni ku'vai ra' nuu̱n kuenda ña na koo nditoun. ");
INSERT INTO mza_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tajan ma ña'a ikan te'en nāka'an ña chi'in ra: ―Yo'o racha'nu tüvi nda'un nï'iin nakuyi ña tàva yo ma takuii, ta ma soko ya'a ga kunu yi. ¿Ta ndanu ìyo ma takuii ña jà'a ña koo ndito yo ña ni ku'vaun ko'i? ");
INSERT INTO mza_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿A ra ka'nu tiaga kùu̱n kua ma ra kūu tatá ndi ra chūnani Jacob, ra ndākoo ma soko i'ya kuenda ndi? Ta rakan ti i'ya kūu ma nuu kī'in ra ma takuii chī'i ra chi'in se'e ra ta ma kiti jàna ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tajan ma Jesuu te'en nāka'an ra: ―Taku ndisaa ndian chì'i ma takuii ña ka'ìin tichi soko i'ya, ni natii ndiko na ra'. ");
INSERT INTO mza_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ta ma ndian ni ko'o ma takuii ña ni ku'vai, na tüva ni natii na ra' inga cha'a, vati endeeni ni koo ra' tichi anima na jà'a ra' ma takua kùu iin nuu kàna ra' jà'i, ikan na koo na endeeni chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tajan ma ña'a ikan te'en nāka'an ña chi'in Jesuu: ―Yo'o racha'nu, na ku'vaun ma takuii ikan ko'i, ikan na tüva ni natii̱ ndikoi ma takuii, ta na kïchi gai tava gai ra' tichi ma soko i'ya ―kàti ña. ");
INSERT INTO mza_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ta Jesuu te'en nāka'an ra: ―Kuàki'in ma ra kùu iiun, ta kichi ndikoun nui chi'in ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ta ma ña'a ikan te'en nāka'an ña: ―Na töve ìyo ii̱ ―kàti ña. Ta Jesuu te'en nāka'an ndiko ra chi'in ña: ―Ndicha va'a ña kà'un ña töve ìyo iiun, ");
INSERT INTO mza_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ti cha u'un cha'a' ña tānda'un niku, ta ma ra ndàkaun vitin na yöve iiun kùu ra. Yakan va ña ndicha kùu ma ña kà'un ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tajan ma ña'a ikan te'en nāka'an ña chi'in ra ora chīnian ña kà'an Jesuu takan: ―Yo'o racha'nu, yu'u chànini̱ ti iin ra kà'an chi'in tu'un yu'u Ndioo kùu̱n. ");
INSERT INTO mza_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ti ma ndian kūu tatá ndi taji'na jāka'nu na ma Ndioo ma yuku tikan niku, va ndyo'o ndian judíu, kàti ndo ña ma ñuu nuu ìyo yi ña jaka'nu yo ra kùu ma ñuu Jerusalén ―kàti ña. ");
INSERT INTO mza_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ta Jesuu nāka'an ra te'en: ―Na chinuniun ña kà'in, vati chani chaa ma ora ña ni jaka'nu ndo ma Racha'nu Tatá yo, ta na tüva ìyo yi ña kichi ndo ma tichi ku'u yuku i'ya, ta ni ma ñuu Jerusalén ña jàka'nu yo ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ta ndyo'o ndian ñu'u' Samaria töve nàkoto va'a ndo nda ra kùu ma ra jàka'nu ndo, va ndyu'u ndian judíu, nàkoto ndi nda ra kùu ma ra jàka'nu ndi, ti ma tu'un kà'an naja kua jàkakú Ndioo ñivi, ìyo yi chi'in ma ndian judíu. ");
INSERT INTO mza_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Va vitin chani chaa ma ora, ña ndisaa ma ndian kùu ñivi ña jàka'nu ndicha kuii ma Tatá yo, ni jaka'nu na ra takua kùu ra, chi'in ndisaa anima na, jà'a ma Tati Ií Ndioo, ti takan kùuni Ndioo ña jà'a ma ndian jàka'nu ra. ");
INSERT INTO mza_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Vati tati kùu Ndioo, yakan va ma ndian jàka'nu ra ndicha, ìyo yi ña ja'a na yi chi'in ndisaa anima na, jà'a ma Tati Ií Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ta ma ña'a ikan te'en nāka'an ña: ―Yu'u chìtoi ña ni kichi ma ra Mesías ña (kùuni yi ka'an yi Cristu,) ra tāchi Ndioo, ta ora ni kichaa ra ni katitu'un ra tandi'i ma naja kua kùu yi nuu yo ―kàti ña. ");
INSERT INTO mza_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ta Jesuu nāka'an ra te'en: ―¡Yu'u ra kà'an chi'un kùi ma ra Cristu! ");
INSERT INTO mza_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ta juuni ma ora ikan chākoyo ma ndra jàkua'a chi'in Jesuu, ta ndava yū'vi ndra ña nàtu'un Jesuu chi'in ma ña'a ikan. Ta nï'iin ndra na töve nī chikatu'un ndra nuu ra, nayi chìkatu'un ra nuu ña, ta naja nàtu'un ra chi'an. ");
INSERT INTO mza_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ta ma ña'a ikan ndākoan ma kii ña nda'a' ña, tajan endee chīnuan kuà'an ña ma ñuu ña, ta ma ikan te'en nāka'an ña chi'in ma ñivi ñuan: ");
INSERT INTO mza_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―¡Na'a ndo na ko'o kunde'o ma ra kātitu'un nui cha'a' tandi'i ma ña jà'i! ¿A yöve rakan kùu Cristu?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Takan kūu ta kēe ndio ma ñivi kuà'an na chi'an ta ora chani chaa ndio na nuu ndaa ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ta kīcha'a kà'an ma ndra jàkua'a chi'in ra, jànini ndra ra chi'in tu'un i'ya: ―Yo'o Matru, kachi ita'vi ma ña chàchi ndi ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Va rakan nāka'an ra te'en: ―Cha ìyo ma ña ni kachi̱ va ndyo'o na töve nàkoto ndo yi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Takan kūu, yakan va ma ndra jàkua'a chi'in ra kīcha'a ndra nàtu'un ta'an ndra te'en: ―¿A ìyo ndian kīchi ndàka ma ña kachi ma Jesuu?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Va ma Jesuu te'en nāka'an ra: ―Ma ña chàchi̱ kùu yi ña na ja'i ndisaa tiñu chà'a ra tāchi yu'u ta jàchinui yi takua kùuni ra. ");
INSERT INTO mza_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Vitin ndyo'o kà'an ndo ña kùmani kumi ga yoo ta kuta'an ma ora ña ndàki'in ndo ma ndatiñu ña tāchi ndo, va yu'u kà'in chi'in ndo ña na ja'a ndo kuenda ma nuu kàa ma ndatiñu ndo, vati cha kēta ora va'a ña ndàki'o yi vitin. ");
INSERT INTO mza_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Taku ma ra ndàki'in ndatiñu nì'i ra ma ya'vi ra ta ma ndatiñu nī'i ra, kùu yi ña na koo endeeni ma ñivi. Yakan va ma ra tàchi chi'in ma ra ndàki'in indukuni sii kùuni ndra cha'a' ma ndatiñu nì'i ndra. ");
INSERT INTO mza_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ndicha kuii kùu ma tu'un ña kà'an te'en: “Ti ma ra tàchi, siin kùu ra kua ma ra ndàki'in ma ndatiñu.” ");
INSERT INTO mza_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yu'u kùu ma ra tāchi̱ ndo ña kùu ndaki'in ndo ma ndatiñu, ña tüvi nī nde'e ndo tundo'o chi'in yi, ti ma ndian ndē'e tundo'o chi'in yi kùu inga na, va ndyo'o kùu ndo ma ndian kìndoo va'a chi'in ndatiñu ikan, vaji ni'i jātiñu inga na cha'a' yi. ");
INSERT INTO mza_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Takan kūu ta kua'a' va'a ma ñivi ndòyo ma ñuu ikan ña ìyo kuenda ñu'u' Samaria, kīcha'a na chìnuni na ma ña kà'an ma Jesuu, ta cha'a' ma ña kà'an ma ña'a ikan chi'in ma ñivi, vati kà'an ña ña kātitu'un Jesuu nuu ña tandi'i ma ña jā'a ña. ");
INSERT INTO mza_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Takan kūu ta ora chāa ma ndian ñu'u' Samaria ma nuu ndaa Jesuu, chīkan na nuu ra ña na kindoo ra chi'in na ma ñuu ikan. Yakan va Jesuu, kīndoo ra chi'in na uvi kivi. ");
INSERT INTO mza_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ta nduva'a kuii ga kua'a' ma ñivi kīcha'a na chìnuni na tu'un Jesuu ora chīni na ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ta kīcha'a na kà'an na chi'in ma ña'a ikan te'en: ―Ji'na chìnuni ndi tu'un Jesuu cha'a' tu'un kà'an yo'oni niku, va vitin nda maa ndi cha chīni ndi ma ña kà'an ra'ya, ta chìto kachin ndi ña ra'ya kùu ma Cristu, ra vàchi jakakú ma ñivi ma ñuñivi i'ya. ");
INSERT INTO mza_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ta ora cha yā'a ndio uvi kivi, tajan kēe ndio ra ma ñu'u' Samaria ta kuà'an ra ma iti' ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Vati juuni maa ma Jesuu kātitu'un ra ña ma ra kà'an chi'in tu'un yu'u Ndioo, na töve tìñu'u na ra ma ñuu maa ra. ");
INSERT INTO mza_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ta ora chāa ra ma ñu'u' Galilea, chā'a ñivi ikan ña na ndoo ra chi'in na, ti ma ndian ñu'u' Galilea chā'an na ma ñuu Jerusalén ora chìyo viko Pakua ma ikan niku, ta takan kūu yi ña ndē'e na tandi'i ma ña va'a ña jā'a Jesuu ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tajan kēe ndiko Jesuu kuà'an ra iti' nuu, nda kati chāa ra ñuu Caná ña ìyo kuenda ma ñu'u' Galilea, nuu jāndaku ra ma takuii ña na kùu ra' vinu. Ta yatini ñuu ikan ìyo iin ra jàkuu tiñu nuu ma ra kùu rey, ña ku'vi se'e ra kàndii ra ma ñuu Capernaum. ");
INSERT INTO mza_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tajan ora chīto ra ña kēe Jesuu ma ñu'u' Judea, ta chāa ra ma ñu'u' Galilea, ikan chāa ra ma nuu ndaa Jesuu, ta kīcha'a ra jànini ra ra ña na ku'un ra chi'in ra ñuu ra, ta janda'a ra ma ra se'e ra ña chani kuvi, ña kàndii ve'e ra. ");
INSERT INTO mza_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tajan Jesuu te'en nāka'an ra chi'in ra: ―Yo'o chi'in ñivi ñuu̱n, tu töve ndè'e ndo ku'va chi'in ma ndatu jà'i, na töve chìnuni ndo ña kà'in. ");
INSERT INTO mza_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Va ma ra jàtiñu kuenda ma ra kùu rey te'en nāka'an tuku ra chi'in Jesuu: ―Yo'o racha'nu na ja'un ñamani ta ku'u̱n chi'i̱n ve'i, antea ña kuvi ma ra se'i ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ta ma Jesuu te'en nāka'an ra chi'in ra: ―Na ku'u̱n ve'un, ti ma ra se'un cha ndā'a ra ―kàti Jesuu. Tajan rakan chīnuni ra ma ña kā'an Jesuu, ta kēe ndio ra kuà'an ra ve'e ra. ");
INSERT INTO mza_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ta ma tichi iti' kuà'an ra chīkuta'an ra ma ndra kùu musu ra, ta kīcha'a ndra kà'an ndra te'en chi'in ra: ―Ma ra se'un cha ndā'a ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tajan te'en kīcha'a ra chìkatu'un ra nuu ma ndra kùu musu ra, ña nda ora kùu yi ña kīchi va'a kùuni ma ra se'e ra. Ta ndrakan te'en nāka'an ndra chi'in ra: ―Iku kaa iin chani'ini kēe ma kà'ni ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tajan chā'a ndio tatá ma ra ku'vi kuenda ña juuni ma ora ikan, kùu ma ora ña kā'an ma Jesuu te'en chi'in ra: “Ma ra se'un cha ndā'a ra.” Yakan va kīcha'a ndio ra chìnuni ra ma ña kà'an Jesuu chi'in ndisaa kuii ma ñivi ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ña'a kùu ma ndatu uvi ña jā'a Jesuu ora kēe ra ma ñu'u' Judea ta chāa ndiko ra ma ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ta ora ya'a ña kūu takan, chīyo iin viko jā'a ma ndian judíu, ta Jesuu kēe ra kuà'an ra ma ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ta ma tichi ma ñuu Jerusalén, yatin ma nuu ìyo ma yuve'e ma nuu yà'a ma mvechala, ìyo iin mini nuu ka'ìin takuii, ña chi'in tu'un hebreu nàni yi Betesda, ta ìyo u'un corredor yi. ");
INSERT INTO mza_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta ma ikan kàndoyo kua'a' va'a ma ndian kùkue'e, tava kùu ma ndian kuaá, ndian cha'a yutun chi'in ndian cha'a pe'lu, ña ndàtu na na kandaa ma takuii. ");
INSERT INTO mza_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Vati iin ma tati va'a jà'a tiñu nuu Ndioo chàa yi ma nuu ìyo ma soko ikan, ta jàkanda yi ra', ta ma ndian nunuu ña kì'vi ma tichi ra', ma ora kandaa ra', ta numini ndà'a na jà'a ra' chi'in nda nuu kue'e nikuuni ña ndo'o na. ");
INSERT INTO mza_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta tañu ma ndian kùkue'e kàndoyo ikan, ìyo iin ra ña ku'vi ra cha ìyo iin oko cha'un uni kuiya ña ku'vi ra. ");
INSERT INTO mza_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ta ora ndē'e Jesuu ña kàndii ra ma ikan, tajan chā'a ndio ra kuenda ña cha ìyo kua'a' kuiya ña ku'vi ra, ta te'en chīkatu'un ra nuu ma ra kù'vi: ―¿A kùuniun nda'un? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ta ma raku'vi te'en nāka'an ra chi'in Jesuu: ―Yo'o racha'nu, na töve ìyo yo kuu tindee yu'u ña tì'i na yu'u tichi soko ikan ora jàkanda ma tati ra'. Ta nàni ora kùuni̱ ki'vi tichi ra' ora kandaa ra', ta java tuku na ji'na kì'vi kua mai ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yakan va te'en nāka'an ndio ma Jesuu chi'in ra: ―Na ndetaun ta kani'un yuvi kìxiun ta ku'u̱n ve'un ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tajan ma ora ikani ndā'a ma ra kùkue'e ikan, ta kāni'i ra ma yuvi ra, ta ndēta ra ta kīcha'a ra chìka ra. Va tava kivi nindeo kùu yi ma ora ndā'a ra jà'a Jesuu, ");
INSERT INTO mza_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","yakan va ma ndian judíu, te'en nāka'an na chi'in ma ra ndā'a ikan: ―Yo'o xaa, kivi nindeo kùu yi, ta cha'a' yakan kùu yi ña na töve va'a jà'un ña ndisoun yuviun chàkunuu̱n ―kàti na chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tajan ma ra kùkue'e ikan, te'en nāka'an ra chi'in ma ndian judíu: ―Ma ra jānda'a yu'u te'en kā'an ra chi'i̱n: “Na kani'un ma yuvi kìxiun ta na ku'u̱n ve'un”, kāti ra chi'i̱n ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tajan ma ndian judíu te'en kīcha'a na chìkatu'un na nuu ma ra ndā'a. ―¿Yo kùu ma ra kā'an ña na kani'un ma yuviun, ta ndètaun ta kù'u̱n chi'in yi? ―kàti na chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Va ma ra chìkatu'un nuu ma ra ndā'a, na töve chìto ra nda yo kùu ma ra jānda'a ra, vati Jesuu cha jāchika ra ra tañu ma ñivi kua'a' ka'ìin ma ikan. ");
INSERT INTO mza_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Takan kūu ta ora cha ya'a ña kūu takan, tajan chīkuta'an ndio Jesuu ma ra jānda'a ra tichi kora veñu'u ka'nu, ta te'en nāka'an ra chi'in ra: ―Vitin ña cha ndā'un, na jä'a gaun ma kuati, koto nde'un tundo'o ka'nu ga ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ta ora chīnu kā'an ma Jesuu takan chi'in ma ra ndā'a, tajan kēe ndio ra kuà'an ra, ta kātitu'un ndio ra nuu ma ndian judíu ña Jesuu kùu ma ra jānda'a ra, kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ta cha'a' ña jānda'a ma Jesuu ma ra ku'vi ikan, yakan va ndīkun ma ndian judíu ka'ni na ra, ti naja jā'a ra ma tiñu ikan ma kivi ña nindeo. ");
INSERT INTO mza_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ta ma Jesuu te'en nāka'an ra chi'in na: ―Taku ma Tatái nda kivi nindeo endeeni jàtiñu ra, yakan va yu'u takan jàtiñui ndia ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yakan va ma ndian judíu numiga kùuni na ka'ni na ma Jesuu, vati na yöve uvaa ma kivi ña nindeni yo jànda'a ra ma ñivi, ti juuni kà'an ra ña Ndioo kùu ma Tatá maani ra, ta takan jando induku ra ra chi'in ma Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tajan nāka'an ma Jesuu te'en: ―Ndicha va'a ña kà'in, ña na küu ja'a yu'u ra kùu Se'e Ndioo nï'iin tiñu ña ma'iin ni, tuva töve ndē'i naja kua jà'a ma Tatái. Vati ndisaa tiñu jà'a Tatái, indukuni kua ikan jà'a yu'u ra kùu Se'e ra yi ndia. ");
INSERT INTO mza_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Vati ma ra kùu Tatái kùuni ra nde'e ra yu'u ra kùu Se'e ra, ta tandi'i ma ña jà'a ra jàna'a ra nui. Ta iti' nuu, ni jana'a ra tiñu ka'nuga nui, ta ma ora ni nde'e ndo yi ndava ni ku'un tati ndo. ");
INSERT INTO mza_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vati takua ma ra kùu Tatái jànataku ra ndian ndií, ta chà'a ra ña na koo ndito ndiko na, juuni takan jà'a yu'u ra kùu Se'e ra, ti chà'i ña na koo ndito ma nda ndian kùuni mai ndia. ");
INSERT INTO mza_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Vati ma ra kùu Tatái töve jàkutuni ra kuati ma ñivi, ti chā'a ra ma ndatu ikan nuu yu'u ra kùu Se'e ra ña na jakutuni̱ kuati na, ");
INSERT INTO mza_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ikan na tiñu'u tandi'i na yu'u takua tìñu'u na ma ra kùu Tatái. Vati ma ndian töve tìñu'u yu'u, kùuni yi kà'an yi ña juuni töve tìñu'u na ma ra kùu Tatái, ra tāchi yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ndicha va'a, ma ña kà'in chi'in ndo, ña ma ndian tàso'o ma tu'un kà'in, ta chìnuni na ña jà'a ma ra tāchi yu'u, cha ìyo ndito na endeeni, ta töva ni ku'un na andaya' cha'a' ma kuati na, ti vaji cha chī'í na jà'a ma kuati na niku, va vitin cha nātaku ndiko na. ");
INSERT INTO mza_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ndicha va'a, ma ña kà'in chi'in ndo ña cha kēta ma ora, ta vitin kùu yi ña ma ndian cha chī'í na jà'a ma kuati jā'a na, ni kuni na tati yu'u, ra Se'e Ndioo, ta tu jachi'in na yi, ni ni'i na nuu koo ndito ndiko na. ");
INSERT INTO mza_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Vati takua ma ra kùu Tatái ìyo ndito maa ra takani, juuni takan chā'a ra ndatu nuu yu'u ra kùu Se'e ra ña kùu koo ndito mai takani ndia. ");
INSERT INTO mza_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta juuni chā'a Tatái ndatu nui ña kùu jakutuni̱ kuati na, cha'a' ña kùi ra Se'e ñivi tāchi Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ta koto yü'vi ndo cha'a' ma ña kà'in i'ya, vati ni keta iin kivi ña ni kuni ma ndian ndií nda ma nuu ñaña na ma tu'un ña ni ka'in. ");
INSERT INTO mza_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ta tandi'i ma ndian jā'a ma ña va'a, ni nataku ndiko na, ta koo ndito ndiko na endeeni chi'in Ndioo, va ma ndian jā'a ña töve va'a, ni nataku na, va kuenda ña ku'un na andaya'. ");
INSERT INTO mza_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Ta yu'u na küu ja'i ma ña kùuni mai tuva Ndioo töve kùuni ra ña jà'i yi, ti ma takua kà'an ra chi'i̱n, ta takan jàkutuni̱. Ta iin ña ndaa kùu yi ora jàkutuni̱, vati na töve jà'i ma ña kùuni mai, ti ma ña jà'i kùu ma ña kùuni ma Tatái ra tāchi yu'u. ");
INSERT INTO mza_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tu yu'u kà'in cha'a' juuni mai, na töve kùu ka'an yo ña ndicha kùu yi ora ki'o ku'va yi. ");
INSERT INTO mza_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Va ìyo inga ra kàtitu'un nuu ma ñivi cha'i, ta chìtoi ti ña ndicha kùu ma tu'un kà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ndyo'o tāchi ndo iin ra kùu tatun ña na kundakatu'un ra nuu Xuva cha'i. Ta rakan kātitu'un ra ma tu'un ndaa. ");
INSERT INTO mza_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Va yu'u na töve chìniñu'i ña kà'an nï'iin ñivi ìyo ñuñivi cha'i. Vati tu kà'in takan chà'a ra kùu yi kuenda ña na chinuni ndo tu'in, ikan na jakakú Ndioo ndo. ");
INSERT INTO mza_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ta ndicha ña Xuva kùu ra takua kùu iin ñu'ú ña ndu'vania tìin yi ta jàndondichin yi. Ta ndyo'o chàta'ani ndo yi ma tiani tiempu ña ndē'e ndo yi. ");
INSERT INTO mza_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Va ka'nuga kùu ma tu'un ña kà'an yu'u kua ma tu'un ña kā'an Xuva. Vati ndisaa ma tiñu ka'nu chā'a ma Tatái ña jàchinui, yakan kùu ma ña jà'i. Ta cha'a' yakan kùu yi ña kùuni yi ka'an yi, ña ndicha kuii ña ma Tatái tāchi yu'u. ");
INSERT INTO mza_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ta juuni ma Tatái ra tāchi yu'u, kā'an ra cha'i, vaji ndyo'o takä'an kuni ndo ma tati ra, ta ni küu nde'e ndo ra. ");
INSERT INTO mza_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Va ma tu'un ra na tüvi chà'a ndo ña koo yi tichi anima ndo, ti tüvi chìnuni ndo nī cha'a ña kà'an ma ra tāchi ma Tatái ndia. ");
INSERT INTO mza_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Taku ndyo'o, ya'a jàkua'a ndo ma tutu Ndioo, ti chànini ndo ña tu jà'a ndo takan, ta ni ni'i ndo nuu koo ndito ndo endeeni kùuni ndo, va tüvi chìto ndo ña ma tu'un ìyo nuu yi kùu ma tu'un kà'an cha'i. ");
INSERT INTO mza_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Va ndyo'o na töve kùuni ndo chinuni ndo ma tu'in, ta tu chīnuni ndo yu'u niku, kùu ni'i ndo nuu koo ndito ndo endeeni chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Taku yu'u na töve chìniñu'i ña na jàka'nu ma ñivi yu'u. ");
INSERT INTO mza_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ta juuni cha nàkoto va'i ndo, ña na töve kùuni ndo nde'e ndo Ndioo ndia. ");
INSERT INTO mza_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yu'u vàchi̱ tiñu nuu ma ra kùu Tatái, ta ndyo'o na töve kì'in kuenda ndo yu'u. Va tu kìchaa inga na ña kà'an na juuni chi'in sivi maa na, ña kà'an ndiakan, va ni jachi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ta ndyo'o töve ndicha ña chìnuni ndo tu'in, ti ma ña jà'a ndo kùu yi, ña jàka'nu ndo juuni ma ta'an ndo, ta töve nànduku ndo a jà'a ndo ma ña kùuni ma uvanuu Ndioo ña na ja'a ndo, ta ikan kùu ni'i ndo nuu ra ña na tìñu'u ra ndo. ");
INSERT INTO mza_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ta koto näkanini ndo ña yu'u ni tisokuati̱ ndo nuu ma ra kùu Tatái, vati ma ra tìsokuati ndo nuu Ndioo kùu juuni ma Moisés, nuu ndàtu ndo ña ni jakakú Ndioo ndo cha'a' ña chìnuni ndo ma tu'un tāa ra. ");
INSERT INTO mza_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Vati tu ndicha ña chìnuni ndo ma tu'un tāa ma Moisés, kùuni yi ka'an yi ña juuni ìyo yi ña chinuni ndo ma tu'in ndia, vati cha'i kùu ma ña tāa ra. ");
INSERT INTO mza_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Va tu töve chìnuni ndo ma tu'un tāa Moisés, ikan chà'i kuenda ña töve chìnuni ndo tu'un kà'in ndia ―kàti Jesuu chi'in ndian judíu ikan. ");
INSERT INTO mza_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Takan kūu tajan kēe ndio Jesuu kuà'an ra inga chiyo yu'u tañu'u Galilea, ña juuni kà'an na ña nàni yi tañu'u Tiberias ndia. ");
INSERT INTO mza_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ta nduva'a kuii kua'a' ñivi kuà'an chata Jesuu, vati ndè'e na ma ndatu chi'in seña ña jà'a ra, ña jànda'a ra ma ndian ku'vi. ");
INSERT INTO mza_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tajan ndāa ndio Jesuu kuà'an ra iin nuu chiki, ta ora chāa ndio ra ikan, tajan chūnandi ndio ra chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ta ma viko Pakua ña jàka'nu ma ndian judíu ti cha vàchi kùyatin yi. ");
INSERT INTO mza_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ta ora kāni'i Jesuu nuu ra te'en tikan, ta ndē'e ra ña ya'a ga kua'a' ñivi vàchi chata ra, tajan te'en nāka'an ndio ra chi'in Lipe: ―¿Ndanu ko'o kujata yo paan ña kachi tandi'i ma ñivi i'ya? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Va chìkatu'un maani ma Jesuu takan nuu ma Lipe nde'o naja kua kati ra cha'a' yi, kùuni Jesuu, vati cha chìto va'a Jesuu nayi kùu ma ña ni ja'a ra. ");
INSERT INTO mza_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tajan ma Lipe te'en nāka'an ra: ―Ni ma xu'un' ña jàkanaa yo uvi cientu kivi ña jàtiñu yo, na këta yi ña jàta yo kua'a' ma paan, ta nàta'vi yo ita'vi ita'vi yi nuu ta'ii'iin ma ñivi ikan ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tajan inga ra jàkua'a chi'in Jesuu, ra nàni André, ra kùu yani Simón Petu', te'en nāka'an ra chi'in Jesuu: ");
INSERT INTO mza_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―I'ya ndaa iin ravali, ña ndà'a ra u'un ta'an paan, ña kūva'a chi'in cebada, ta chi'in uvi tiaka'; ¿va ndakutiñu ña'a kuenda na, ña ya'a kua'a' ñivi kùu na? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tajan te'en nāka'an ndio Jesuu: ―Na ka'un chi'in ma ñivi, ña na kunandi na ma ikan ―kàti ra. Ta ma ikan ti ya'aga kua'a' ma ita kuati kàa, tajan chūnandi ndio na. Ta ìyo iin u'un mii ndra'ii kùu ndra. Ta siin kùu ma ñivi ña'a. ");
INSERT INTO mza_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tajan kī'in ndio Jesuu ma paan, ta kīcha'a ra chìkan ra ta'vindioo, nuu ma Racha'nu Ndioo cha'a' yi iti' andivi, ta chā'a ndio ra yi nuu ma ndra jàkua'a chi'in ra, ña na nata'vi ndra yi nuu ma ñivi. Ta indukuni takan jā'a ra chi'in ma tiaka' ndia. Tajan chāchi na naja kua kùuni maa na. ");
INSERT INTO mza_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ta ora chītu tichi na, tajan te'en nāka'an ndio Jesuu chi'in ma ndra jàkua'a chi'in ra: ―Na jati'vi ndo ma ña chākoso, ikan na töve tivi nï'iin nakuyi, ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tajan jāti'vi ndio ndra ma ña chākoso, ta jākutu ndra uchi uvi ga ta'an tuka ma paan chi'in ma ña chākoso jā'a ma ndi u'un paan ña kūva'a chi'in cebada. ");
INSERT INTO mza_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Takan kūu ta ora ndē'e ma ñivi ma ndatu ka'nu ña jā'a Jesuu, ta te'en nāka'an na: ―Ndicha kuii ña ra'ya kùu ma ra kà'an chi'in tu'un yu'u Ndioo, ra ni kichi ma ñuñivi i'ya ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Va tava Jesuu chā'a ra kuenda ña tani'i kùuni na kundaka na ra ku'un ra, kuenda ña kùu ra rey, ra ka'nda tiñu nuu na. Yakan va kēe ma'iin ra kuà'an ra ma siki iin yuku sukun, ti kùuni ra koo ma'iin ra. ");
INSERT INTO mza_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Takan kūu ta ora cha kuaa, tajan ma ndra jàkua'a chi'in Jesuu kēe ndra kuà'an ndra yu'u tañu'u. ");
INSERT INTO mza_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ta ikan kī'vi ndio ndra tichi iin varku, ta kīcha'a ndio ndra kèta chiyo ndra ma tañu'u, ña kuà'an ndra iti' ñuu Capernaum. Ta cha ya'a naa kùu yi. Ta ma Jesuu juuni töve ra chàa ma nuu ka'ìin ndra. ");
INSERT INTO mza_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tajan ma tañu'u, nduva'a sukun ndàkoo nditi ra' jà'a ña ya'a ni'i chàkin ma tati. ");
INSERT INTO mza_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ta ora cha yā'a nduu ndra iin u'un a iñu kilometru chi'in ma varku, tajan ndē'e ndra ña chìka Jesuu vàchi ra nuu takuii, ña kuàjayatin ra ra nuu kuà'an ma varku. Tajan ndrakan kīcha'a ndio ndra yù'vi ndra. ");
INSERT INTO mza_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ta Jesuu te'en nāka'an ra chi'in ndra: ―¡Na yü'vi ndo, ti mai kùi! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tajan nduva'a kuii chìsii ndra ña cha ìyo Jesuu chi'in ndra ma tichi varku. Ta nunuu ni, ta cha chàani ndra ma ñuu nuu kuà'an ndra. ");
INSERT INTO mza_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Takan kūu ta ma inga kivi, ma ñivi kīndoo yu'u tañu'u nuu kēe ma ndra jàkua'a chi'in ra chi'in ma varku, ikan chā'a na kuenda ña tüvi ndāa Jesuu chi'in ndra ma tichi varku uvanuu nia, ña ndaa ma ikan. ");
INSERT INTO mza_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ta ora cha yā'a ña kūu takan, tajan chāa ndio tiá kua'a' varku, ña kīchi iti' ñuu Tiberias, yatini ma nuu chā'a Jesuu ña chàchi ma ñivi ora chā'a ra ta'vindioo cha'a' yi nuu ma Racha'nu. ");
INSERT INTO mza_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ta ora ndē'e na ña töve ndaa Jesuu ma ikan, ta ni ma ndra jàkua'a chi'in ra, tajan ndāa ndio na tichi ndrun, ta kēe na kuà'an na kuànanduku na Jesuu iti' ñuu Capernaum. ");
INSERT INTO mza_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ta ora nāta'an na Jesuu ma inga chiyo yu'u tañu'u, ta te'en nāka'an na chi'in ra: ―Yo'o matru, ¿nda ora kīchaun nde've? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tajan Jesuu te'en nāka'an ra: ―Ndicha va'a ña kà'in chi'in ndo, ña ndyo'o nànduku ndo yu'u, cha'a' ña chāchi ndo nda kati chitu tichi ndo jā'i, ta yöve cha'a' ña kì'in kuenda ndo, ta kùtunini ndo nda kuenda kùu ma ndatu ña chā'a Ndioo nui ña jà'i. ");
INSERT INTO mza_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Na jätiñu ndo cha'a' ma ña kachini ndo, ma ñuñivi i'ya, vati yakan numini ndi'i yi. Na jatiñu ndo va cha'a' ma ña kachi ndo, ña ku'va nuu koo ndo endeeni chi'in Ndioo. Ti ma ndayu ikan kùu ma ña ni ku'va ma ra Se'e ñivi tāchi Ndioo kachi ndo, vati rakan kùu ra kāchin ma Ndioo, ña jà'a ra yi. ");
INSERT INTO mza_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ta te'en kīcha'a ndio ma ñivi chìkatu'un na nuu Jesuu: ―¿Nayi ìyo yi ña ja'a ndi, ta kùu jachinu ndi ma tiñu kùuni Ndioo ña ja'a ndi? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tajan te'en nāka'an ndio Jesuu chi'in na: ―Uvanuu ma tiñu ka'nu ña kùuni Ndioo ña jà'a ndo, kùu yi ña na chinuni ndo ma tu'un kà'an yu'u, ra tāchi ra ―takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tajan ma ñivi te'en nāka'an na chi'in ra: ―Tuva takan kùu yi, ¿nda ndatu ka'nu kùu jana'un nuu ndi, ikan ora nde'e ndi yi, ta chininu ndi ma tu'un kà'un? ¿Ta nda tiñu kùu ma ña jà'un? ");
INSERT INTO mza_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ma ndian kūu ñivi ndi ña chīyo taji'na, chāchi na ma ña kuichin ña nàni maná, ma tichi ku'u niku, vati nuu ma tutu Ndioo te'en kà'an yi: “Iti' andivi jākoyo ra ma paan chàchi na” ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tajan ma Jesuu te'en nāka'an ra chi'in na: ―Ndicha va'a ña kà'in chi'in ndo: ña na yöve Moisés kùu ra ña chā'a ra ma paan kāchita iti' andivi chāchi ndo taji'na, ti ma Tatái kùu ra chā'a yi ta nda vitin chà'a ra yi ndia. Ta ma paan chà'a ra kùu ma ña ndicha ña vàchi iti' andivi. ");
INSERT INTO mza_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Vati ma paan ña chà'a ma Ndioo nuu yo vàchi yi iti' andivi, ta jà'a yi ña endee koo ndito ma ñivi ìyo ñuñivi. ");
INSERT INTO mza_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tajan te'en chīkan na nuu Jesuu: ―Yo'o Racha'nu, na ku'vaun ma paan i'ya kachi ndi nani kivi ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ta Jesuu te'en nāka'an ra chi'in na: ―Yu'u kùu ma paan ña chà'a ña koo ndito ndo endeeni. Ta ma ndian vàchi nui, na tüva ni kusoko na, ta ma ndian chìnuni ña kà'in, na tüva ni natii na takuii ndia. ");
INSERT INTO mza_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Va tava cha kā'in chi'in ndo, ña vaji cha ndè'e ndo yu'u, na töve chìnuni ndicha ndo ma tu'in. ");
INSERT INTO mza_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta tandi'i ma ndian chā'a ma Tatái nui, ndiakan kùu ma ndian vàchi nui. Ta ma ndian vàchi nui ni ku'vai ña ki'vi na iti' kuà'in. ");
INSERT INTO mza_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Vati yu'u töve kīchi̱ iti' andivi, kuenda ña jà'i ma ña kùuni mai, ti yu'u kīchai va kuenda ña jà'i tandi'i ña kùuni ma Tatái, ra tāchi yu'u. ");
INSERT INTO mza_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ta ma tiñu ña töve kùuni ma Tatái, ra tāchi yu'u ña jà'i, kùu yi ña, koto jäkunai nï'iin ma ñivi ña chā'a ra nui, vati ma ña kùuni ra ña jà'i, kùu yi ña na janatakui na ma kivi nuu ndi'i nia. ");
INSERT INTO mza_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta juuni kùuni ma ra tāchi yu'u ña tandi'i ma ndian nde'e yu'u ra kùu Se'e ra, ta chinuni na ma tu'un kà'in, ni koo ndito na endeeni jà'i, ta juuni yu'u, ni janatakui na ma kivi nuu ndi'i nia ndia. ");
INSERT INTO mza_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Cha'a' ña'a kùu yi ña ma ndian judíu kīcha'a na chàtu'un na ra, cha'a' ña kā'an ra tu'un i'ya: “Yu'u kùu ma paan ña kīchi iti' andivi.” ");
INSERT INTO mza_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ta ma ndian judíu te'en nāka'an na: ―¿A yöve Jesuu i'ya, kùu ra se'e Kusé? Ndicha ña juu ra kùu ra, ti nàkoto va'a yo ma tatá ra chi'in ma'á ra. ¿Ta chïto naja kà'an ra ña kīchi ra iti' andivi? ");
INSERT INTO mza_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tajan ma Jesuu te'en nāka'an ra chi'in na: ―Na jaña ndo ña chàtu'un ndo. ");
INSERT INTO mza_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nï'iin ñivi, na küu kichi na nui, tu yöve Tatái ra tāchi yu'u kùu ra ña chàki'in ra na. Ta yu'u kùi ña ni janatakui ndiakan ma kivi nuu ndi'i nia. ");
INSERT INTO mza_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Vati nuu ma tutu Ndioo ña tāa ndra kà'an chi'in tu'un yu'u Ndioo te'en kà'an yi: “Ndioo ni jana'a ra nuu tandi'i ma ñivi”, kàti yi. Cha'a' yakan kùu yi ña tandi'i ma ndian chìni tu'un kà'an ma Racha'nu Ndioo, ta jàchi'in na ma ña kà'an ra. Ndiakan kùu ndian vàchi nui. ");
INSERT INTO mza_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ma tu'un kà'in töve kùuni yi ka'an yi ña ìyo ñivi ña cha ndē'e na ma Tatái, ti uvanuu ma ra cha ndē'e ra, kùu yu'u, ra chīyo chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ndicha va'a ña kà'in, ña ma ndian chìnuni ma tu'in, endee ìyo ndito na. ");
INSERT INTO mza_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ta yu'u kùu ma paan ña jà'a, ña na koo ndito yo endeeni. ");
INSERT INTO mza_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ma ndian kūu ñivi ndo ña chīyo taji'na, chī'í na vaji chāchi na ma ña kuichin ña nàni maná, ma tichi ku'u. ");
INSERT INTO mza_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Va yu'u kà'in chi'in ndo, cha'a' inga tuku ma paan ña vàchi iti' andivi, ta yakan, ti tu ìyo nda ndian chàchi yi, na töve chì'í na. ");
INSERT INTO mza_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Va yu'u kà'in chi'in ndo ña yu'u kùu ma paan ndito ña kīchi iti' andivi, ta nda ndian nikuuni ña chàchi ma paan i'ya, ni koo ndito na endeeni chi'in Ndioo. Ta ma paan ña ni ku'vai nuu na kùu ma kuñui, ikan na kuu koo ndito tandi'i ma ndian ìyo ñuñivi. ");
INSERT INTO mza_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tajan ma ndian judíu te'en kīcha'a na kànita'an yu'u na chi'in juuni maa na: ―¿Naja kua kùu yi, ña kùuni ra ku'va ra ma kuñu ra kacho?, kùuni ndo ―kà'an na. ");
INSERT INTO mza_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tajan Jesuu te'en nāka'an ra chi'in na: ―Ndicha va'a ña kà'in chi'in ndo, ña tu töve chàchi ndo kuñu ma ra Se'e ñivi tāchi Ndioo, ta töve chì'i ndo ma nií ra, na töve ni ni'i ndo nuu koo ndito ndo chi'in ma Racha'nu Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yakan va ma ndian chàchi ma kuñui, ta chì'i na ma nii̱, ndiakan endee ìyo ndito na, ta yu'u ni janatakui na ma kivi nuu ndi'i nia. ");
INSERT INTO mza_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Vati ma kuñui kùu ma ndayu va'a, kuenda ña kacho, ta ma nii̱ kùu ra' iin ña va'a ko'o yo ndia. ");
INSERT INTO mza_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ti ma ndian chàchi ma kuñui, ta chì'i na ma nii̱, induku ìyo na chi'i̱n, ta yu'u, induku ìyoi chi'in na ndia. ");
INSERT INTO mza_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Vati tava ma Tatái, ra tāchi yu'u, ra takani ìyo kùu ra, yakan va juuni ra ndito kùi takua kùu ra, cha'a' yakan kùu yi ña ìyo ndatui ña kùu ja'i ña na koo ndito tandi'i ndian chàchi ma kuñui ndia. ");
INSERT INTO mza_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Va yu'u kà'in cha'a' ma paan nūu iti' andivi. Vati ma paan ikan töve indukuni kùu yi takua kùu ma ña nàni maná, ña chāchi ma ndian kūu ñivi ndo ndian chīyo taji'na, ti ndiakan chī'í na vaji chāchi na yi. Va ma ndian chàchi ma paan ña kīchi iti' andivi, ni koo na indeeni. ");
INSERT INTO mza_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Takan kā'an Jesuu nuu ma ñivi ma ora jāna'a ra tichi veñu'u ñivi judíu, ña ndaa ma ñuu Capernaum. ");
INSERT INTO mza_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Takan kūu ta ora chīni ma ndian chàkunuu chata Jesuu ma tu'un i'ya, tajan te'en nāka'an na: ―Ya'a ga ndetiñu jàchi'o ma tu'un kà'an ra'ya. ¿Nda ndian kùu ma ndian ni jachi'in ma ña kà'an ra, ña kua kà'an ra takan?, kùuni ndo ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ta ora chā'a ndio Jesuu kuenda ña chàtu'un na ra, tajan te'en nāka'an ra chi'in na: ―Ta, ¿naja töve chàta'ani ndo ma ña kà'in? ");
INSERT INTO mza_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nayi ja'a ndo, tuva nde'e ndo yu'u ra Se'e ñivi tāchi Ndioo, ña ndàa ndiko ra ku'un ra ma nuu chīyo ra niku? ");
INSERT INTO mza_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ma Tati Ií Ndioo jà'a ña kùu koo ndito ndo endeeni, ta ndisaa ña kùu ja'a ndo chi'in ma kuñu ndo, töve nda kuenda yi. Vati ma tu'un kàtitu'in nuu ndo jà'i yi chi'in ma Tati Ií Ndioo. Ta tu'un ikan chà'a yi, ña na koo ndito ndo endeeni chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Va ìyo uvi uni ndo ña töve chìnuni tu'in ―kàti Jesuu. Takan kà'an Jesuu, ti takani cha chìto ra nda ndian kùu ma ndian töve chìnuni tu'un ra, ta nda ra kùu ma ra ni xikoña'a cha'a' ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tajan Jesuu te'en nāka'an ra: ―Cha'a' yakan kùu yi ña, cha kā'in chi'in ndo, ña nï'iin na, na küu kichi na nui, tuva yöve ma Tatái kùu ma ra ji'na ña chā'a ra yi nuu na. ");
INSERT INTO mza_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Takan kūu ta nda ma ora ikan, kua'a' ma ndian chàkunuu chi'in Jesuu niku, jāña na ña chàkunuu na chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tajan te'en chīkatu'un ndio Jesuu nuu ma ndi uchi uvi ma ndra jàkua'a chi'in ra: ―¿A ndita'an ndo kùuni ndo ku'un ndo, takua jā'a ndiakan? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tajan ma ra nàni Simón Petu' te'en nāka'an ra chi'in Jesuu: ―Yo'o Racha'nu, cha chìto va'a ndi ña töve ìyo inga yo nuu ku'un ndi. Vati uvanuu maun kùu ra kà'an naja kua kùu ni'o nuu koo ndito yo endeeni. ");
INSERT INTO mza_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ta ndyu'u kīcha'a ndi chìnuni ndi, ta nàkoto ndi, ña yo'o kùu ma ra kùu Cristu, ra Se'e Ndioo ndito. ");
INSERT INTO mza_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tajan Jesuu te'en nāka'an ra chi'in ma ndra jàkua'a chi'in ra: ―¿A chàku'uni ndo ña yu'u kùu ma ra kāchin ma ndi uchi uvi ta'an ndo? Va vaji takan kùu yi, ìyo iin ra tañu ndo ña kùu kui'na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ma ora kā'an Jesuu ma tu'un i'ya, chànini ra cha'a' ma Juda, ra kùu se'e Simón Iscariote, ti chìto Jesuu ña ni xikoña'a ra cha'a' ra nuu ñivi, vaji iin ra ìyo tañu ma ndi uchi uvi ndra jàkua'a chi'in Jesuu kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Takan kūu ta ora yā'a ña kūu takan, tajan kēe ndio Jesuu chàkunuu ra, ta ñuu, ta ñuu, ma iti' ñu'u' Galilea. Vati na küuni ga ra chìkoni'i ra ma ñu'u' Judea, ti ndikun ma ndian judíu ka'ni na ra. ");
INSERT INTO mza_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ta tava cha vàchi kuyatin ma kivi ña ni kuu ma viko lomara, ña jàka'nu ma ndian judíu nani kuiya. ");
INSERT INTO mza_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tajan ma ndra yani Jesuu, te'en nāka'an ndra chi'in ra: ―Na keun ma ñu'u' Galilea, ta ku'u̱n ma iti' ñu'u' Judea, ikan ma ndian jàkua'a chi'un ña ìyo ndakan, na nde'e na ma tiñu jà'un ndia. ");
INSERT INTO mza_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vati nï'iin yo kùuni yo ña nakoto ma ñivi yo, cha'a' ma ña va'a jà'a yo, tüvi ìyo yi ña ja'a xe'o yi. Yakan va tu ndicha ña ra jà'a tiñu va'a kùu̱n, na ja'un yi nuu ndè'e tandi'i ma ñivi ìyo ñuñivi. ―Takan kàti ma ndra yani ra. ");
INSERT INTO mza_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Takan kàti ndra, ti ni ma ndra yani Jesuu, na töve chìnuni ndra ma ña kà'an ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Takä'an chaa ma ora ña kùu ku'vai ña na nakoto na yu'u, va kuenda ndyo'o, nda ora nikuuni, va'a yi kuenda ndo. ");
INSERT INTO mza_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Vati ma ndian ìyo kuenda ma ñuñivini, na töve nda cha'a' kùxaani na nde'e na ndo, va yu'u, ndicha ña ìyo nda cha'a' kùxaani na nde'e na yu'u, ti jàna'a kachi̱n nuu na, ña töve va'a ma ña jà'a na. ");
INSERT INTO mza_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kua'an ndyo'o ma viko, vati yu'u na töve ku'in, ti takä'an chaa ma ora ña jàna'i yu'u nuu ma ñivi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ta ora chīnu kā'an Jesuu takan, ta kīndoo ra ma ñu'u' Galilea. ");
INSERT INTO mza_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ta ora cha kuà'an ndio ma ndra yani ra, tajan nda ma Jesuu kēe ndio ra kuà'an ra chata ndra nuu ìyo ma viko ndia. Ta chāa ndio ra ma ikan va xe'eni. ");
INSERT INTO mza_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Va ma ndian judíu kīcha'a na nànduku na Jesuu ma nuu ìyo viko, ta te'en kīcha'a na chìkatu'un ta'an na: ―¿Ndanu chàkunuu ma ra'ii ikan? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta tañu ma ñivi ka'ìin ikan, ìyo uvi uni ma ndian chàtu'un Jesuu, ta ìyo ndian kà'an te'en: “Iin ra va'a kùu ra”, kàti na. Ta ìyo inga na ña kà'an te'en: “Na yöve ra va'a kùu ra, ti ra jànda'viña'a kùu ra”, kàti na. ");
INSERT INTO mza_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ta vaji takan kà'an na, va nï'iin ñivi töve kà'an na tu'un i'ya nuu ka'ìin ti'vi kua'a' ñivi, koto nde'e na tundo'o jà'a ma ndian kuxini nuu ma ndian judíu. ");
INSERT INTO mza_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ta ma viko ikan cha kua kùu java yi, ora kī'vi Jesuu ma tichi kora veñu'u ka'nu, ta ikan kīcha'a ra jàna'a ra nuu ma ñivi. ");
INSERT INTO mza_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ta ma ndian judíu ndava kuà'an anima na ña kīndoo na nde'e na ra, ta te'en kīcha'a na chìkatu'un ta'an na: ―¿Naja ya'a ga chìto ra'ya, ta töve nī jakua'a ra? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tajan Jesuu te'en nāka'an ra: ―Ma ña jàna'i i'ya, yöve iin tu'un ña jāndakuu maani̱ kùu yi, ti ma tu'un kà'an ma ra tāchi yu'u ña jà'i kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tu ìyo nda ndian kùuni ja'a ma tiñu kùuni ma Racha'nu Ndioo, kùu ku'va na kuenda, tuva ma tu'un jàna'i, kùu yi ma tu'un Ndioo, a ma tu'un jàndakuu maani̱ kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Vati ma ndian jàna'a nuu ma ñivi chi'in ma tu'un ña jàndakuu maani na, kùuni yi ka'an yi ña jàka'nu na juuni maa na. Va ma ndian jàna'a nuu ma ñivi, ta nànduku na naja kua jàka'nu na ma ndian tāchi na. Ndiakan kùu ma ndian kà'an ma ña ndaa, ta nï'iin ñivi küu ni'i na naja kua tisokuati na cha'a' ña jà'a na. ");
INSERT INTO mza_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿A töve ndicha ña ma racha'nu Moisés chā'a ra tutu ley Ndioo nuu ndo taji'na? Va nï'iin ndo töve jàchi'in ndo ma ña kà'an yi. ¿A yöve cha'a' yakan kùu yi ña kùuni ndo ka'ni ndo yu'u? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tajan ma ñivi te'en nāka'an na chi'in ra: ―¿A tati xaan kī'vi xiniun ña kà'un takan? ¿Yo kùu ma ndian kùuni ka'ni ñu̱n? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tajan Jesuu te'en nāka'an ra. ―Cha'a' uvaa ma ña jā'i ma kivi nindeo, ndisaa ndo nī chata'ani ndo yi. ");
INSERT INTO mza_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Vati ndicha va'a ña ma Moisés kùu ra ña tāchi ra ña na nakua'a ndo ka'nda ndo ñii nuu ika ma ndrakuati se'e ndo, (vaji yöve chi'in Moisés kīcha'a yi, ti takani cha vàchi ma ñivi ndo ndian chīyo tatiempu jà'a na yi) vaji ma kivi nindeo kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ta vitin tu cha'a' ña kùuni ndo jachi'in ndo ña kà'an ma ley Ndioo ña tāa ma Moisés kùu yi ña chà'nda ndo ñii nuu ika ma ndrakuati se'e ndo vaji kivi nindeo kùu yi, ¿ta naja kùxaan ndo yu'u cha'a' ña jānda'i ninii ma ra ku'vi ma kivi nindeo? ");
INSERT INTO mza_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ta koto tïsokuati ndo ma ñivi, tuva tüvi chìto ndaa ndo nda cha'a' kùu yi. Na ja'a ndo yi, va tuva ma ña ndaa kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Takan kūu tajan iin ma ndian ìyo ma ñuu Jerusalén te'en kīcha'a na chìkatu'un ta'an na: ―¿A yüvi ra nànduku na ka'ni na kùu ra'ya? ");
INSERT INTO mza_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na nde'e va'a yo, ti ikan ndaa ra kà'an ra nuu tuvi ñivi, ta nï'iin ma ndra kùxini töve kà'an ndra chata ra. ¿A töve chànini ndra, ña ndicha va'a, ña ra'ya kùu ma Cristu, ra tāchi Ndioo?, kùuni ndra. ");
INSERT INTO mza_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Va maa yo cha chìto yo ndanu kīchi ra'ya. Va taku ma Cristu, ti nï'iin ñivi töve chìto na nda iti' ni kichi ra ma ora ni kichaa ra ―Takan nàtu'un ta'an na. ");
INSERT INTO mza_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ta ora chīni Jesuu ña takan kà'an ma ñivi, ma ora jàna'a ra nuu na ma tichi kora veñu'u ka'nu, tajan te'en nāka'an ni'i ra chi'in na: ―¿A ndicha ña nàkoto ndo nda ra kùi, ta juuni chìto ndo ndanu kīchi̱? Va yu'u kùuni̱ ña na koto va'a ndo, ña yu'u töve vàchi̱ i'ya cha'a' ña kùuni mai. Vàchi̱ ti ìyo iin ra tāchi yu'u ña töve nàkoto ndo. Ta rakan ti iin ra ndaa kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Va yu'u nàkoto va'i ra, ti kuenda ra vàchi̱, ta maa ra tāchi yu'u ndia ―kàti Jesuu chi'in na. ");
INSERT INTO mza_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Takan kūu ta ora chīni ma ñivi tu'un ikan, ta kūuni na tiin na ra, ta tì'i na ra tichi vekaa niku, va nï'iin na nī ti'i na nda'a' na ña tìin na ra, ti takä'an chaa ma ora ra. ");
INSERT INTO mza_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ta ma ora ikan kua'a' na chīnuni ma ña kà'an Jesuu, ta te'en kīcha'a ndio na nàtu'un ta'an na: ―Ma ora ni kichi ma ra kùu Cristu, ¿a ni ja'aga ra tiá ndatu ka'nu kua ra'ya?, kùuni ndo ―kàti na ña nàtu'un ta'an na. ");
INSERT INTO mza_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Takan kūu ta chīni ma ndra fariseu ña kà'an xe'e na chata Jesuu, tajan jāndikita'an tu'un ndra chi'in ma ndra chà'nda tiñu nuu sutu, ta tāchi ndra ma ndra jandaru ña kùmi ma veñu'u, ña na kutiin ndra Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tajan Jesuu te'en nāka'an ra: ―Tia tiempuni, ni koi chi'in ndo ma nde've, ti ni chikoni'i ndikoi ku'in nuu ma ra tāchi yu'u. ");
INSERT INTO mza_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tajan ndyo'o, ni nanduku ndio ndo yu'u, va na töva ni nata'an ndo yu'u, vati na töve kùu ku'un ndo ma nuu ni chai. ");
INSERT INTO mza_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Takan kūu tajan ma ndian judíu, te'en kīcha'a na chìkatu'un ta'an na: ―¿Ta ndanu ni ku'un ra'ya, ña na küu nata'an yo ra? ¿A ni ku'un ra ñuu chika nuu ndoyo ma ndian kùu ñivi yo te'en tikan tañu ma ndian griegu, ta ni jana'a ra nuu ma ñivi ìyo ikan?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nayi kùuni ra kà'an ra, cha'a' ña kā'an ra te'en chi'in yo ña: “Ni nanduku ndo yu'u, va na töve ni nata'an ndo yu'u, vati na töve nuu kùu ku'un ndo, kùu ma nuu ni chai”?, kàti ra ―Takan kàti na ña nàtu'un ta'an na. ");
INSERT INTO mza_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ma kivi nuu ndi'i nia, ña ìyo ma viko ka'nu ikan, ma Jesuu chūndaa ndio ra, ta te'en nāka'an ni'i ra chi'in ma ñivi: ―Tu ìyo nda ndyo'o nàtii ndo takuii, na kichi ndo nui, ta ku'vai ra' ko'o ndo. ");
INSERT INTO mza_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Vati nuu ma tutu Ndioo, kà'an yi ña tichi anima ma ndian chìnuni ña kà'in, ni kana iin ña kàa takua kàa iin yuta ña tüvi ni ndoko, ta yakan kùu yi ña ni ja'a yi ña koo ndito ndo. ");
INSERT INTO mza_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chi'in ma tu'un i'ya, kùuni Jesuu ka'an ra ña ma ndian chìnuni ma tu'un ra, ni koo ma Tati Ií Ndioo chi'in na, vaji ma Tati Ií Ndioo takä'an kichaa yi, vati takä'an ku'un ndiko Jesuu nuu ni jaka'nu ma Ndioo Tatá ra ra. ");
INSERT INTO mza_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ta ìyo iin ma ndian ka'ìin tañu ma ñivi, ña ora chīni na ma tu'un i'ya, ta te'en nāka'an na: ―Ndicha va'a ña ra'ya kùu ma ra kà'an chi'in tu'un yu'u Ndioo ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ta inga tuku na kà'an te'en: ―Ra'ya kùu ma Cristu ―kàti na. Va juuni ìyo inga ndian kà'an te'en: ―¿A iti' ñu'u' Galilea ìyo yi ña kichi ma ra kùu Cristu, kùuni ndo, ña kà'an ndo takan? ¡Jun! ");
INSERT INTO mza_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na yöve takan kùu yi ti nuu ma tutu Ndioo kà'an yi ña, ma ra kùu Cristu ìyo yi ña kuu ra ñivi ma rey David, ta juuni ìyo yi ña kuu ra ma ra ñuu Belén, juuni ma ñuu nuu kāku ma rey David niku ndia ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ta takan kūu ña ma ñivi kēsiin na jā'a ma tu'un Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ta ìyo ma ñivi kūuni na tiin na ra, ta ku'un ra vekaa, va nï'iin na töve nī ja'a yi. ");
INSERT INTO mza_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Takan kūu tajan ma ndra jandaru ña kùmi ma veñu'u, chīkoni'i ndiko ndra nuu ka'ìin ma ndra fariseu, chi'in ma ndra sutu ña kùxini nuu sutu, ta ndrakan te'en chīkatu'un ndra nuu ma ndra jandaru: ―¿Ta naja töve ndàka ndo ra? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tajan ma ndra jandaru te'en nāka'an ndra: ―¡Nï'iin ndra'ii töve kà'an ma takua kà'an rakan! ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tajan ma ndra fariseu, te'en nāka'an ndiko ndra: ―¿A ndita'an ndo chā'a ndo ña kēña'a ra ndo ndia? ");
INSERT INTO mza_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿A cha chīnuni iin ma ndra kùxini nuu yo a ma ndra fariseu ma tu'un kà'an ra, ña kà'an ndo takan? Cha chìto va'a ndo ña yöve takan kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Uvanuu ma ndian chìnuni ña kà'an ra, kùu ma ndian töve nàkoto ña kà'an ma tutu ley Ndioo. Ta ndiakan ti ndian kini kùu na ―kàti ndra chi'in ma jandaru. ");
INSERT INTO mza_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tajan ma ra nàni Nicodemo, ra juuni kùu fariseu, ra chānde'e Jesuu ma ora chanikuaa, ndēta ndio ra, ta te'en nāka'an ra chi'in ndra kùxini ka'ìin ikan: ");
INSERT INTO mza_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ma ley Ndioo ña jàka'nu yo kà'an yi ña, na küu ka'ni yo nï'iin ñivi, tuva takä'an ndakatu'un yo nuu na nayi kùu ma ña jà'a na ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tajan ndrakan te'en nāka'an ndra chi'in ma Nicodemo: ―¿A juuni ra ñu'u' Galilea kùu̱n ña kà'un takan? Na jakua'a ji'naun naja kua kà'an yi nuu ma tutu Ndioo, ta nde'un ti nï'iin ma ra kà'an chi'in tu'un yu'u Ndioo na töve nī keta ra iti' ñu'u' Galilea ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tajan ora yā'a ña kūu takan, ta ta'ii'iin ndio na kēe na kuà'an na ve'e na. ");
INSERT INTO mza_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Takan kūu tajan Jesuu kēe ra kuà'an ra iti' yuku nàni Olivu. ");
INSERT INTO mza_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ta ma inga kivi ora kūndichin, kēe ndiko ra kuà'an ra ma veñu'u ka'nu, ta ndisaa ma ñivi chājayatin na na nuu ra, ta rakan chūnandi ndio ra, ta kīcha'a ra jàna'a ra nuu na. ");
INSERT INTO mza_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tajan ma ndra matru ña jàkua'a ma ley Ndioo, chi'in ma ndra fariseu nāta'an ndra iin ña'a tondo ña kì'vi ña chi'in ra'ii, ta tīin ndra ña, ta ndàka ndra ña kuà'an ndra nuu Jesuu. Ta ikan kūtaa ndra ña ma'ñu ma nuu ka'ìin ti'vi ma ñivi, ");
INSERT INTO mza_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ta te'en nāka'an ndra chi'in Jesuu: ―Matru, ma ña'a i'ya nātiin ndi ña, juuni ma ora ña kì'vi ña chi'in iin ra'ii yüvi iian. ");
INSERT INTO mza_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ta ma nuu ley ña tāa Moisés, kàti yi ña na ka'ni yo ma ñivi ña'a ña jà'a takan chi'in yuu. Ta yo'o, ¿naja kua kàtiun? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Takan chīkatu'un ndra nuu ra, ikan na ka'an ra iin ña tüvi va'a, ta chi'in yakan kùu ni'i ndra naja kua kùu tisokuati ndra ra. Tajan Jesuu chūnandi chiti ra, ta kīcha'a ra tàa ra ma nuu ñu'u' chi'in xini nda'a' ra. ");
INSERT INTO mza_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Va tava ma ndra fariseu na töve jàña ndra ña chìkatu'un ndra nuu Jesuu, yakan va ndēta ndio ra, ta te'en nāka'an ra chi'in ndra: ―Nda ndyo'o nikuuni, tuva töve ìyo nï'iin kuati ndo, ji'na ndo na kani ma yuu chata ña ―kàti ra chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tajan Jesuu chūnandi chiti ndiko ra ma nuu ñu'u', ta kīcha'a ndiko ra tàa ra. ");
INSERT INTO mza_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ta ora chīni ndra ña kā'an Jesuu takan, ta chā'a ndra kuenda ña maa ndra kùu ma ndra ìyo kuati, tajan iini iini ndra kīcha'a ndra kàcha'an ndra, va ma ndra ji'na kīcha'a jà'a yi kùu ma ndra cha'nuga, ta ikan jan, ma ndra yoko ndia. Tajan ma'iin nia ndio Jesuu kīndoo chi'in ma ña'a ikan ma'ñu ñivi. ");
INSERT INTO mza_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ta ikan jan, chūndaa ndio Jesuu, ta tava ndē'e ra ña nï'iin ga ndra tüva, ti uvaa nia ma ña'a kīndoo, tajan te'en nāka'an ndio ra chi'in ña: ―Yo'o xi'i, ¿ndanu ka'ìin ma ndra tīsokuati ñu̱n? Ta, ¿naja nï'iin ndra, töve nī kuuni ndra ka'ni ndra ñu̱n? ―kàti Jesuu chi'an. ");
INSERT INTO mza_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tajan ma ña'a ikan te'en nāka'an ña: ―Nï'iin ndra nī ja'a yi racha'nu ―kàti ña. Tajan Jesuu te'en nāka'an ndiko ra chi'in ña: ―Ni yu'u na küuni̱ ka'ni̱ ñu̱n ndia. Ta vitin kuà'an yo'o, ta koto jä'a gaun ma kuati ―kàti ra chi'an. ");
INSERT INTO mza_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Takan kūu tajan Jesuu te'en nāka'an tuku ra chi'in ma ñivi: ―Yu'u kùi tava kùu iin ñu'ú ña jàndondichin nuu ndè'e ma ñivi ñuñivi, ta ma ndian tàndikun chatai, na töva ni kakunuu na nuu naa, vati ni ni'i na ma ñu'ú ña ni ku'va nuu koo na endeeni ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tajan ma ndra fariseu te'en nāka'an ndra chi'in ra: ―Yo'o, kà'un ma tu'un chiña cha'a' juuni maun, ta yakan töve nda kuenda yi ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tajan Jesuu te'en nāka'an ra: ―Ndicha ña vaji kà'in cha'a juuni mai, va ndicha va'a ti ña ndaa kùu yi. Vati yu'u chìtoi ndanu kīchi̱, ta chìtoi ndanu kuà'in. Va taku ndyo'o, na töve chìto ndo ndanu kīchi̱, ta töve chìto ndo ndanu kuà'in ndia. ");
INSERT INTO mza_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ta ndyo'o jàkutuni ndo ma tiñu, tava kùuni ma ñivi ìyo ñuñivini, va yu'u töve jàkutuni̱ nï'iin ñivi. ");
INSERT INTO mza_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ta tu yu'u jàkutuni̱ iin nakuyi chi'in ma ñivi, va ndicha ti ma ña jà'i, iin ña ndaa kùu yi, vati na yöve ma'iin ni kùu ma ra jàkutuni yi, ti jàkutuni̱ yi nda chi'in ma Tatái, ra tāchi yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Vati nuu ma tutu ley Ndioo ña ìyo nuu ndo kà'an yi, ña tu uvi ta'an ma testigu kà'an na iin nuu ni, ìyo yi ña chinuni yo yi, ti tu'un ndaa kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Va'ani tuva takan, yu'u kà'in ma ña ndaa cha'a' juuni mai, ta nda ma Tatái, ra tāchi yu'u, juuni kà'an ra cha'i ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tajan ndrakan te'en chīkatu'un ndra nuu Jesuu: ―Ta, ¿ndanu ìyo ma tatáun? ―kàti ndra. Ta Jesuu te'en nāka'an ra: ―Ndyo'o, töve nàkoto ndo yu'u, ta töve nàkoto ndo ma Tatái ndia. Vati tuva ndicha ña nàkoto ndo yu'u, juuni takan ìyo yi ña nakoto ndo ma Tatái ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ta Jesuu kātitu'un ra ma tu'un i'ya, ma ora ndaa ra jàna'a ra ma tichi kora veñu'u ka'nu, nuu ndaa ma chatun, nuu sòkó na xu'un' kuenda Ndioo. Va nï'iin na nī tiin na ra, ti takä'an chaa ma ora ra. ");
INSERT INTO mza_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Takan kūu ta Jesuu te'en nāka'an tuku ra chi'in ma ñivi: ―Yu'u ni ku'in, ta ndyo'o ni kunanduku ndo yu'u, va ni kuvi ndo cha'a' ma kuati jà'a ndo, vati ma nuu kuà'in, na küu chaa ndo. ");
INSERT INTO mza_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tajan ma ndian judíu te'en kīcha'a na nàtu'un ta'an na: ―¿A chànini ra ka'ni maa ra ra, yakan va kà'an ra, ña na küu chaa yo ma nuu kuà'an ra? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tajan Jesuu te'en nāka'an ra: ―Ndyo'o kùu ndo ndian ìyo ninuu nde've, va yu'u kùi, ra ìyo nuu sukun. Ta juuni ndyo'o kùu ndo ndian ìyo kuenda ma nuu ñu'u' ñuñivi i'yani, va yu'u yöve ra ìyo kuenda nuu ñu'u' ñuñivi i'ya kùi. ");
INSERT INTO mza_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yakan va kātitu'in ña ndyo'o ni kuvi ndo cha'a' ma kuati ndo, ti tu töve chìnuni ndo ña yu'u kùu ra takani ìyo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tajan te'en chīkatu'un tuku ndra nuu ra: ―Ta yo'o, ¿nda ra kùu̱n? ―kàti ndra. Ta Jesuu te'en nāka'an ra: ―Cha kātitu'in nuu ndo nda ra kùi, nda ma kivi nunuu. ");
INSERT INTO mza_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ìyo kua'a' ña kàtitu'in naja kua ìyo ndo, ta juuni ìyo kua'a' naja kua jàkutuni̱ ndo ndia, uvaa ña ma ra tāchi yu'u nuu ndo, kà'an ra ma ña ndaa, ta ma ña kàtitu'in nuu ndyo'o ñivi ñuñivi, yakan kùu ma tu'un ndaa ña chīni̱ ña kā'an ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Va Jesuu kà'an ra nuu na cha'a' ma Tatá Ndioo, uvaa ña na töve nī kutunini na yi. ");
INSERT INTO mza_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yakan va Jesuu te'en nāka'an ra chi'in ndra: ―Ta ora cha chā'ni ndo yu'u, ra kùu Se'e ñivi tāchi Ndioo, tajan ni ku'va ndo kuenda, ña yu'u kùu Ndioo, ra takani ìyo, ti taku yu'u töve vàchi̱ kuenda ña jà'i ma ña kùuni mai, vati vàchi̱, kuenda ña kàtitu'in nuu ndo ma ña jāna'a ma Tatáini nui. ");
INSERT INTO mza_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Vati Tatái ra tāchi yu'u, ìyo ra chi'i̱n, ta töve ndàkoo ma'iin ra yu'u, vati tandi'i ora jà'i ma ña chàta'ani ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ta ora chīnu kā'an Jesuu takan, ta kua'a' ñivi kīcha'a chìnuni ma tu'un ra. ");
INSERT INTO mza_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Takan kūu tajan Jesuu te'en nāka'an ra chi'in ma ndian judíu, ña chīnuni ma tu'un ra: ―Tu ndicha ña ndyo'o, ña endee chìnuni va'a ndo ma ña kà'in chi'in ndo, ndicha va'a ña kùu ndo ma ndian jàkua'a chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ta takan koto ndo ma ña ndicha, ta chi'in ma ña ndicha ikan ni ja'a yi ña na koo nuna ndo. ");
INSERT INTO mza_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tajan ma ndian judíu te'en nāka'an na chi'in Jesuu: ―Ndyu'u kùu ndi ñivi tata Abraham, ta nï'iin cha'a' takä'an kùu ndi musu ña jà'a tiñu nuu nï'iin ñivi. Ta, ¿naja kua kùu yi ña kà'un, ña ni koo nuna ndi? ―kàti na chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ta Jesuu te'en nāka'an ra: ―Ndicha va'a ña kà'in chi'in ndo, ña tandi'i ma ndian jà'a kuati, ndiakan kùu na musu ma kuati. ");
INSERT INTO mza_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Vati taku ma ra kùu musu, na yöve ndisaa ora ndoo ra ve'e ma ra kùu chito'o ra, va taku ma ra kùu se'e ma chito'o ma ve'e ikan, endee ìyo ra ve'e ma tatá ra. ");
INSERT INTO mza_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yakan va tu yu'u ma ra kùu se'e Ndioo jà'i ña na kee ndo nda'a' ma ña kini, ndicha va'a ña ndyo'o, ni ndoo nuna ndo. ");
INSERT INTO mza_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Cha chìtoi ti ñivi tata Abraham kùu ndo, va ndyo'o kùuni ndo ka'ni ndo yu'u, ti töve kùuni ndo jachi'in ndo ma ña kà'in. ");
INSERT INTO mza_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yu'u kàtitu'in nuu ndo ma ña jàna'a ma Tatái nui, ta ndyo'o jà'a ndo ma ña jàna'a ma tatá ndo nuu ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tajan ma ndian judíu te'en nāka'an na chi'in Jesuu: ―Ma ra kùu tatá ndi, kùu ma racha'nu Abraham ―kàti na. Va Jesuu te'en nāka'an ra chi'in na: ―Tuva ndicha ña ndyo'o kùu ndo se'e Abraham, ìyo yi ña ja'a ndo ma takua jā'a ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Va vitin kùuni ndo ka'ni ndo yu'u cha'a' ña kà'in ma ña ndaa ña jàna'a Ndioo nui. Ta Abraham ti töve nī ja'a ra takan. ");
INSERT INTO mza_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Va ndyo'o indukuni jà'a ndo, ma tava jà'a ma tatá ndicha ndo ―kàti ra. Tajan ndiakan te'en nāka'an na chi'in ra: ―Ndyu'u, na yüvi ndian se'e saká kùu ndi, ti uvanuu tatá ndi ìyo, ta rakan kùu Racha'nu Ndioo ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tajan Jesuu te'en nāka'an ra chi'in na: ―Tu ndicha ña Ndioo kùu Tatá ndo, ìyo yi ña kuuni ndo nde'e ndo yu'u, ti iti' nuu ìyo ra kīchi̱, ta i'ya ìyoi chi'in ndo. Vati na yöve cha'a' ña kùuni mai kùu yi ña vàchi̱, ti yu'u vàchi̱ ña Ndioo tāchi yu'u. ");
INSERT INTO mza_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ta naja töve kùu kutunini ndo ma tu'un kà'in? Takan jà'a ndo, ti töve kùuni ndo taso'o ndo ña kà'in. ");
INSERT INTO mza_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kui'na kùu ma tatá ndo, cha'a' ña kùuni ndo ja'a ndo tava kùunián'. Ma kui'na ikan, ti ñá' chà'ni ñivi kùán'. Ta yakán' ti, nï'iin cha'a' töve kà'án' ma ña ndaa, ti töve ìyo ma ña ndaa kuendán'. Ta ma ora kà'án' tu'un vata, takan jà'án' yi, ti yakán' kùán', vati vatán', ta ñá' kuxini ma tu'un vata kùán'. ");
INSERT INTO mza_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Va tava yu'u, kà'in ma ña ndaa, yakan va ndyo'o töve chìnuni ndo ma ña kà'in. ");
INSERT INTO mza_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nda ndyo'o kùu ka'an ndo, ña yu'u ìyo iin kuati̱? Nï'iin ndo. Ta tu chìto ndo ña iin ra kà'an ña ndaa kùi, ¿ta naja töve chìnuni ndo ma ña kà'in? ");
INSERT INTO mza_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ma ndian kùu ñivi Ndioo, jàchi'in na ma tu'un kà'an ra. Va tava ndyo'o, na yöve ñivi Ndioo kùu ndo, yakan va töve jàchi'in ndo ma ña kà'an ra. ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tajan ma ndian judíu te'en nāka'an na chi'in Jesuu: ―Ndicha ndi ña kà'an ndi, ña ra ñuu Samaria kùu̱n, ta ndisoun tati xaan ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tajan Jesuu te'en nāka'an ra: ―Töve ndisoi nï'iin tati xaan. Ma ña jà'i kùu yi ña tìñu'i ma Tatái, va ndyo'o töve tìñu'u ndo yu'u. ");
INSERT INTO mza_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yu'u, na töve nàndukui ña na jaka'nu ndo yu'u, vaji ndicha ña ìyo inga ma ra kùuni ña na jaka'nu ndo yu'u, ta rakan kùu ra ña ni jakutuni ra chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ndicha va'a ña kà'in chi'in ndo, ña ma ndian jàchi'in ma tu'in, endee töve ni kuvi na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tajan ma ndian judíu te'en nāka'an na chi'in ra: ―Vitin va ndicha va'a ndi, ña ndisoun tati xaan. Vati ma Abraham, chi'in ndisaa inga ma ndra kà'an chi'in tu'un yu'u Ndioo, kāchi'í ndra, ta yo'o kà'un ña, ma ndian jàchi'in ña kà'un, na töve ni kuvi na, kàtiun. ");
INSERT INTO mza_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿A chàniniun ña yo'o ka'nugaun kua ma tatá ndi Abraham? Vati rakan chī'í ra, ta juuni chī'í ma ndra kà'an chi'in tu'un yu'u Ndioo ndia. ¿Nda ra kùu̱n kùuniun, ña kà'un takan? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tajan Jesuu te'en nāka'an ra: ―Tu yu'u jàka'nui juuni mai, na töve nda kuenda yi. Ma ra kà'an ndo ña kùu Ndioo ndo, rakan kùu ma Tatái, ra jàka'nu yu'u. ");
INSERT INTO mza_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ta rakan, ndyo'o töve nàkoto ndo ra. Ta yu'u, ndicha ña nàkotoi ra. Ta tu yu'u kà'in ña töve nàkotoi ra, indukuni ya'a vatai takua vata ndo ndia. Va yu'u, ndicha va'a ña nàkotoi ra, ta jàchi'i̱n ma ña kà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ma tatá ndo Abraham, ra chīyo taji'na, nduva'a kuii chīsii ra, ña ni nde'e ra ma kivi ni kichai ma nuñu'u' ñuñivi, ta ndē'e ra yi. Yakan va nduva'a kuii chīsii ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tajan ma ndian judíu te'en nāka'an na chi'in ra: ―Ni takä'an ketaun, ni uvi xiko uchi kuiyaun, ta kàtiun ña ndē'egaun Abraham ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ta Jesuu te'en nāka'an ra chi'in na: ―Ndicha va'i ña kà'in chi'in ndo, ña takani cha ìyoi, antea ña koo Abraham. ");
INSERT INTO mza_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tajan ma ndian judíu ti, kī'in na yuu ña kūuni na kani na Jesuu niku. Va nī kuu yi, ti Jesuu chūndii xe'e ra, ta kēe ra ma tichi kora veñu'u, chā'nda java ra tañu na, ta kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Takan kūu ta ma nuu chìka Jesuu kuà'an ra, ikan ndē'e ra iin ra kuaá ña takan kāku. ");
INSERT INTO mza_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tajan ma ndra jàkua'a chi'in ra, te'en chīkatu'un ndra nuu ra: ―Matru, ¿ta naja kāku kuaá ma ra'ya? ¿A cha'a' kuati ma ndian kùu tatá ra kùu yi, a cha'a kuati juuni maa ra kùu yi? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Na yöve cha'a' kuati maa ra kùu yi, ta ni yöve cha'a' kuati ma ndian kùu tatá ra kùu yi. Takan kāku ra, ti chi'in rakan kùuni ma Racha'nu Ndioo jana'a ra ma ndatu ra, ikan na nde'e ma ñivi, ña kùu ja'a ra yi. ");
INSERT INTO mza_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vitin ña juuni kùu yi ora ndichin, ìyo yi ña ja'i ma tiñu ña tāchi ma Tatái yu'u ña jà'i. Vati cha vàchi ma ora chanikuaa, ta ma ora ikan nï'iin ga ñivi, na küa jatiñu. ");
INSERT INTO mza_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ma ora juuni yanga ìyoi ma ñuñivi i'ya, yu'u kùi takua kùu ma ñu'ú, ña jàtuun ñuñivi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ta ora chīnu kā'an Jesuu takan, ta tīvisii ra nuu ñu'u', ta jā'a ra ita'vi nda'yu chi'in ra', ta kū'vi ndio ra yi chata tinuu ma ra kuaá. ");
INSERT INTO mza_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ta te'en nāka'an ndio ra chi'in ra: ―¡Kua'an, kuànakata tinuu̱n, nuu ndaa ma soko ña nàni Siloé! ―kàti Jesuu. Ma tu'un Siloé, kùuni yi ka'an yi: Yu'u tàchi ñu̱n. Tajan ma ra kuaá ikan cha nākata ra tinuu ra, ta ora chāa ra nuu ndaa Jesuu, ta cha ndè'e ndio ra. ");
INSERT INTO mza_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tajan ma ndian ìyo yatini ma ve'e ra, chi'in ndian takani ndè'e ña kuaá ra niku, te'en kīcha'a na nàtu'un ta'an na: ―¿A yöve ra'ya kùu ma ra chùnandi chìkan tunda'vi?, kùuni ndo ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ta ìyo inga na ña kà'an te'en: ―Juu ra kùu ra ―kàti na. Ta inga tuku na va kà'an te'en: ―Yöve ra kùu ra, va takani ndè'e ra ―kàti na. Tajan juuni maa ndio ra, te'en nāka'an ra: ―Ndicha ña yu'u kùi ―kàti ra chi'in na. ");
INSERT INTO mza_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tajan te'en kīcha'a na chìkatu'un na nuu ra: ―¿Ta naja kua jā'un ña kūu nande'un? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ta rakan te'en nāka'an ra chi'in na: ―Ma ra nàni Jesuu, jā'a ra nda'yu chi'in ma takuii yu'u ra, ta kū'vi ra yi chata tinui, ta te'en nāka'an ra chi'i̱n: “Kua'an nuu ndaa ma soko ña nàni Siloé, ta nakataun ma tinuu̱n”, kāti ra chi'i̱n. Tajan chā'an ndioi cha nākatai yi. Ta takan kūu yi, ña kūu nande'i ―Takan kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tajan ma ñivi ikan, te'en chīkatu'un na nuu ra: ―¿Ta ndanu chàkunuu ma ra'ii ikan? ―kàti na. Ta ma ra kuaá niku, te'en nāka'an ra: ―Töve chìtoi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tajan ma ra kuaá niku, tīin ndio na ra, ta chāndaka na ra nuu ma ndra fariseu. ");
INSERT INTO mza_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Va tava ma kivi nindeo kùu yi ña jā'a Jesuu ma nda'yu, ta kū'vi ra yi tinuu ma ra kuaá ikan, ta ndā'a ra. ");
INSERT INTO mza_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yakan va ma ndra fariseu kīcha'a ndiko ndra chìkatu'un ndra nuu ra ma naja kua jā'a ra ña kūu nande'e ra. Ta ma ra kuaá ikan te'en nāka'an ra chi'in ndra: ―Kū'vi ra ma nda'yu tinui, ta nākatai yi, ta vitin cha ndè'i ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ta ìyo iin ma ndra fariseu ña kà'an te'en: ―Ma ra jà'a takan, na yöve ra tāchi Ndioo kùu ra, vati töve tìñu'u ra ma kivi nìndee yo ―kàti ndra. Ta ìyo inga na ña te'en kà'an: ―Ta tu ra jà'a kuatini kùu ra, ¿ta naja kùu jà'a ra ma ndatu ka'nu tuva takan? ―kàti na. Ta cha'a' yakan kùu yi ña kēsiin na ti, siin siin chànini na. ");
INSERT INTO mza_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tajan te'en kīcha'a ndiko ma ndra fariseu chìkatu'un ndra nuu ma ra kuaá niku: ―Ta yo'o, ¿naja kua kàtiun nuu ndi, cha'a' ma ra jānda'a ma tinuu̱n? ―kàti ndra. Ta rakan te'en nāka'an ra: ―Yu'u kà'in, ña iin ra kà'an chi'in tu'un yu'u Ndioo kùu ra ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Va tava ma ndra judíu, töve kùuni ndra chinuni ndra ña iin ra kuaá kūu ra niku, ta vitin cha kùu nde'e ra, yakan va kāna ndio ndra ma ndian kùu tatá ma ra kuaá, ");
INSERT INTO mza_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ta te'en chīkatu'un ndra nuu vi: ―¿A se'e ndo kùu ra'ya? ¿A ndicha ña kāku kuaá ra? ¿Ta naja kua kùu yi ña ndè'e ra vitin tuva takan? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tajan ma ndian kùu tatá ra, te'en nāka'an vi chi'in ma ndra fariseu: ―Cha chìto ndi, ña ra'ya kùu se'e ndi, ta kāku kuaá ra, ");
INSERT INTO mza_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","va töve chìto ndi nayi jā'a chi'in ra ña kūu nande'e ra vitin, ta ni töve chìto ndi, nda ra kùu ma ra jānda'a tinuu ra. Va'aga, ña na ndakatu'un ndo nuu ra, vati ra cha chicha kùu ra, ta kàtitu'un maa ra nuu ndo nayi jā'a chi'in ra ña ndā'a ra ―kàti vi. ");
INSERT INTO mza_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Takan kā'an ma ndian kùu tatá ra, ti yu'vi vi ndè'e vi ma ndra judíu ikan, vati ma ndra judíu cha natu'un ta'an ndra, ña tuva ìyo ma ndian kà'an ña Jesuu kùu ma Cristu, ni tavani'i ndra na indeeni ma veñu'u, ta tüva kùu na kuenda yi. ");
INSERT INTO mza_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ta cha'a' yakan kùu yi ña nāka'an vi: “Na ndakatu'un ndo nuu maa ra, vati iin ra cha chicha kùu ra”, kāti vi. ");
INSERT INTO mza_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tajan ma ndra judíu, te'en kīcha'a ndiko na chìkatu'un na nuu ma ra kuaá niku: ―Na ka'un ma ña ndaa nuu ndi, ndava nda nuu Ndioo, vati ndyu'u cha chìto ndi ña, ra jà'a kuati kùu ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ta ma ra kuaá ikan, te'en nāka'an ra chi'in ndra: ―Töve chìtoi tuva ra jà'a kuati kùu ra, a töve. Uvanuu ma ña chìtoi kùu yi ña, ra kuaá kūi, ta vitin, cha kùu nde'i ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ta ndrakan te'en chīkatu'un ndiko ndra nuu ra: ―¿Nayi jā'a ra chi'un? ¿Ta naja kua jā'a ra chi'un ña kūu nande'un? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ta rakan te'en nāka'an ra chi'in ndra: ―Cha kātitu'in yi nuu ndo, va töve kùuni ndo jachi'in ndo yi. ¿Ta naja kùuni ndo ña kàtitu'un ndikoi yi nuu ndo inga cha'a'? ¿A ndita'an ndo kùuni ndo tandikun ndo chata ra? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tajan te'en kīcha'a ndio ndra chàtu'un ndra chata ma ra kuaá ikan: ―Maun kùu ma ra ìyo kuenda ra, va ndyu'u, ìyo kuenda ma racha'nu Moisés. ");
INSERT INTO mza_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ta ndyu'u cha chìto ndi, ti Ndioo kā'an ra chi'in Moisés, va rakan, töve chìto ndi ndanu kīchi ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tajan ma ra kuaá niku, te'en nāka'an ra: ―Na töve chìnuni̱ ña kà'an ndo ña töve chìto ndo ndanu kīchi ra, ta rakan kùu ra ña jānda'a ra tinui. ");
INSERT INTO mza_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cha chìto va'a yo ña Ndioo, tàso'o ra ña kà'an ma ndian jàka'nu ra, chi'in ma ndian jà'a ña kùuni ra, va ma ndian jà'a kuati, töve. ");
INSERT INTO mza_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nda kati tūvi ma ñuñivi nï'iin ñivi takä'an koto na ña ìyo iin ra kùu janda'a tinuu ma iin ra kāku kuaá. ");
INSERT INTO mza_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tu yöve ra vàchi kuenda Ndioo kùu ra'ya, na küu ja'a ra nï'iin nakuyi chi'i̱n niku ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tajan te'en nāka'an ma ndra judíu chi'in ra: ―Yo'o, kùu̱n ra kāku chi'in kuati, ¿ta vitin kùuniun jana'un nuu ndi nayi ìyo yi ña ja'a ndi? ―kàti ndra. Tajan jākunu ndra ra veñu'u ma ndian judíu. ");
INSERT INTO mza_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ta ora chīto Jesuu ña jākunu ndra ra nda'vi ikan ma tichi ma veñu'u, ta ora chīkuta'an ra ra, ta te'en chīkatu'un ra nuu ra: ―¿A chìnuni yo'o ña kà'an ma ra Se'e Ndioo? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ta ma ra nda'vi te'en nāka'an ra: ―Yo'o racha'nu, na katitu'u̱n nui nda ra kùu ra, ta chinuni̱ ma ña kà'an ra ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ta Jesuu te'en nāka'an ra: ―Cha ndē'un ra, ta juu ra kùu ma ra nàtu'un chi'un ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tajan chūnandi chiti ndio ma ra nda'vi ikan nuu Jesuu, ta te'en nāka'an ra chi'in ra: ―Chìnuni̱ ña kà'un Racha'nu ―kàti ma ra nda'vi chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ta Jesuu te'en nāka'an ra: ―Ma tiñu vàchi ja'a yu'u ma ñuñivi i'ya, kùu yi ña vàchi jakutuni̱ kuati ma ñivi. Ta vàchi ja'i ña nande'e ma ndian kuaá. Ta vàchi ja'i ña na ndokuaá ma ndian chànini na ña ñivi ndichin nde'e kùu na. Ndiakan ni ndakuu na takua ma ndian kuaá. ");
INSERT INTO mza_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tajan iin ma ndra fariseu, ña ka'ìin chi'in ra, ora chīni ndra ña kā'an ra takan, tajan te'en kīcha'a ndra chìkatu'un ndra nuu ra: ―¿A nda ndyu'u kùu ndi ndian kuaá?, kùuniun ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ta Jesuu te'en nāka'an ra: ―Tu ndyo'o kùu ndo ndian kuaá niku, na töve ìyo kuati ndo cha'a' ma ña kini jà'a ndo, vati na töve chìto ndo ma ña jà'a ndo. Va tava kà'an ndo ña kùu nde'e ndo, yakan va juuni ìyo ga ma kuati ndo. ");
INSERT INTO mza_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tajan Jesuu te'en nāka'an ra: ―Ndicha va'a ña kà'in chi'in ndo, ña tu kèta iin ra'ii nuu ka'ìin mvechala jàna ndo, ta töve kì'vi ra ma iti' yu'u kora ma nuu ka'ìin ndri, rasu'u kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Va ma ra kì'vi iti' yu'u kora ma nuu ka'ìin ma mvechala, rakan kùu ma pato ndri. ");
INSERT INTO mza_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ta ma ra kùmi ma yu'u kora nuu ka'ìin ndri, nùna ra yi nuu ra, ta ma ra kùu pato ma mvechala, kàna ra ta'ii'iin ndri chi'in sivi ndri. Ta ndrikan nàkoto ndri ma tati ra, ta tàvani'i ndio ra ndri tichi kora. ");
INSERT INTO mza_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ta ora cha kākee ndisaa ndri jà'a ra, tajan chākoso nuu ndio ra nuu ndri, ta ma mvechala tāndikun ndri chata ra, ti nàkoto ndri ma tati ra. ");
INSERT INTO mza_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Va taku chata iin nda ra ni kuuni ña töve nàkoto ndri, na töve tàndikun ndri ra, ti java vi'a chìnu ndri nuu ra, vati töve nàkoto ndri ma tati ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Takan kà'an Jesuu ma ku'va i'ya nuu na, va na töve nī kutunini na ma ña kùuni ra ka'an ra. ");
INSERT INTO mza_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tajan Jesuu te'en kīcha'a ndiko ra kà'an ra chi'in ma ñivi: ―Ndicha va'a ña kà'in chi'in ndo ña yu'u kùi takua kùu ma yu'u kora nuu yà'a ma mvechala. ");
INSERT INTO mza_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tandi'i ma ndra pato ma mvechala ña chīyo antea kua yu'u, ndrakan kùu ndra ndra su'u, va ndrikan töve nī jachi'in ndri ma ña jā'a ndra. ");
INSERT INTO mza_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yu'u kùi takua kùu ma yu'u kora, ta ma ndian kì'vi ma tichi yi cha'a' yu'u, ni kakú na. Ta ndiakan ni kuu na takua kùu ma iin mvechala ña kì'vi, ta kèe ma tichi kora, ta nì'i ndri ma ita kachi ndri. ");
INSERT INTO mza_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Vati taku ndra su'u, ma tiñu jà'a ndra kùu yi ña mamaa chàkunuu su'uni ndra, ta vàchi ka'ni ndra, ta vàchi janaa ndra ñivi ndia, va yu'u vàchi̱ kuenda ña jà'i ña na koo ndito ñivi kuenda Ndioo, ta va'ani koo na takua kùuni̱ ña na koo va'a na. ");
INSERT INTO mza_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yu'u kùi takua kùu iin ma pato ra ya'a va'a, vati taku rakan, tu ya'a kùuni ra nde'e ra ndri, kùu nda ku'va ra ra ña kuvi ra cha'a' ndri. ");
INSERT INTO mza_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Va ma ra jàtiñu cha'a' ma ya'vini, ora vàchi ma lobo ña kùuni ri kachi ri ma mvechala, ndàkoo ma'iin ra ndri, ta chìnu ra kuà'an ra, ti yöve pato va'a kùu ra, ta ni yöve jàna ra kùu ndri ndia. Tajan ma lobo, chìnu ndio ri chata ma mvechala, ta tìin ri ndri, ta ndrikan chìtakuati ndri jà'a ri. ");
INSERT INTO mza_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ma ra'ii i'ya chìnu ra, ti jàkuenda ra ndri, va cha'a' ma ya'vini ra, ta yöve cha'a' ña kùuni ra nde'e ra ma mvechala kùu yi ña kùmi ra ndri. ");
INSERT INTO mza_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Yu'u kùu ma pato ya'a va'a, ti tava nàkotoi ma mvechala jànai, ta takan nàkoto ndri yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ta indukuni kua ikan nàkoto ma Tatái yu'u, ta takan nàkotoi ra ndia. Ta takan kùu yi ña, ndava kùu ku'vai yu'u ña kùvi̱ cha'a' ma mvechala jànai. ");
INSERT INTO mza_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ta juuni kùmi̱ inga mvechala ña töve kùu kuenda ma kora i'ya, juuni ìyo yi ña kuki'i̱n ndri ta tàin ndri i'ya ndia. Vati ndrikan kùu ndri ña ni jachi'in ndri ma ña kà'in. Ta ikan jan iin patonia ni kuu chito'o ndri, ti iin korani ni kuiin ndisaa ndri ndia. ");
INSERT INTO mza_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Ta cha'a' yakan kùu yi ña, ya'a ga kùuni ma Tatái nde'e ra yu'u, vati chà'i ma kuñui cha'a' ma ndian kùu ñivi̱, ta rakan chà'a ndiko ra yi nui. ");
INSERT INTO mza_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nï'iin na, na küu ka'ni na yu'u cha'a' ña kùuni maani na, vati juuni mai kùi ña chà'i ña na ja'a na yi. Vati ìyo ndatui ña ku'vai ma kuñui nuu na, ta juuni ìyo ndatui ña kùu nataku ndikoi ndia. Takan kāti ma ra kùu Tatái nui. ―Takan kà'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ta ora chīni ma ndian judíu ña kā'an Jesuu takan, ta vi'a kīcha'a ndiko na kèsiin na. ");
INSERT INTO mza_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ta ìyo kua'a' ma ndian judíu ña kà'an te'en: ―¿Ta naja jàchi'in ndo ña kà'an ra, ta iin ra tivi xini kùu ra, ti ndiso ra tati xaan? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ta ìyo inga tuku na ña kà'an te'en: ―Nï'iin ma ndian ndiso tati xaan, na küu ka'an na takan. ¿A kùu janda'a ma tati xaan tinuu iin ma ra kuaá?, kùuni ndo. Na küu yi ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ma tiempu vichin kùu yi ña, ma ndian judíu ndian ñuu Jerusalén, jà'a na ma viko kuenda ña jàka'nu na ma veñu'u ka'nu, ti chàku'uni na ma kuiya ña jāchinu ma ndian kūu ñivi na yi. ");
INSERT INTO mza_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ta Jesuu ti ndaa ra ma veñu'u ma ora ikan, va uvaa ña chàkunuu ra ma nuu ìyo ma corredor ña nàni Salomón. ");
INSERT INTO mza_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tajan chīkonuu ndio ma ndian judíu ma Jesuu, ta te'en kīcha'a na chìkatu'un na nuu ra: ―¿Nda ora chàniniun kàtitu'u̱n ma ña ndaa nuu ndi? Tu ndicha ña maun kùu ma Cristu, na katitu'un yi nuu ndi taka'anio ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tajan Jesuu te'en nāka'an ra: ―Cha kātitu'in yi nuu ndo, ta töve nī chinuni ndo yi. Vati ma tiñu tāchi ma Tatái yu'u ña ja'i, yakan jàna'a kachin yi nda ra kùi. ");
INSERT INTO mza_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Va ndyo'o, töve chìnuni ndo ma ña kà'in, ti na yöve mvechala jànai kùu ndo, ma takua cha kā'in nuu ndo niku. ");
INSERT INTO mza_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Vati ma mvechala jànai, cha nàkoto ndri ma tati̱, ta tàndikun ndri chatai. ");
INSERT INTO mza_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ti yu'u chà'i nuu koo ndri endeeni chi'i̱n, ta töva ni naa ndri. Ta nï'iin ga ma ñivi na küu namaa na ndri nui. ");
INSERT INTO mza_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Vati ma ña chā'a ma Tatái nui, ka'nuga yi kua ndisaa nakuyi. Ta nï'iin ga na, na küu namaa na ndri nda'a' ma Tatái. ");
INSERT INTO mza_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Vati ma Tatái, chi'in yu'u, iini ndra kùu ndi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tajan ma ndian judíu, kīcha'a ndiko na kàtiin na yuu ña ni kani na chata Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Va rakan te'en nāka'an ra chi'in na: ―Nduva'a kua'a' tiñu va'a jā'i chi'in ndatu ma Tatái, kuenda na nande'e ndo yi. Ta vitin, ¿nda cha'a' ma tiñu va'a ikan kùu yi, ña kùuni ndo kani ndo yuu yu'u? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ta ma ndian judíu te'en nāka'an na chi'in ra: ―Na yöve cha'a' ma ña va'a jā'un kùu yi ña ni kani ndi yuu ñu̱n, ti ni kani ndi ñu̱n, va cha'a' ña kà'an ti'iniun chata Ndioo chi'in ma tu'un kà'un. Ta juuni kùu yi cha'a' ña jàndaku̱n ñu̱n Ndioo, ta yo'o iin ra'ii ni kùu̱n ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tajan Jesuu te'en nāka'an ra chi'in na: ―Nuu ma tutu ley Ndioo ña kùmi ndo, Ndioo te'en kà'an ra: “Ndyo'o kùu ndo ndioo”, kāti ra nuu yi. ");
INSERT INTO mza_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yakan va tu chìto yo ña ndioo jākunani ma Racha'nu, ma ndian chìnuni ma tu'un ra, na küu ka'an yo ña tu'un vata kùu ña kà'an ma tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ta tu Ndioo kāchin ra yu'u kuenda ma tiñu ra, ta tāchi ra yu'u ma ñuñivi i'ya, töve chìtoi naja kà'an ndo ña kà'an ti'ini̱ chata ra, cha'a' ña kà'in ña Se'e Ndioo kùi, tuva takan. ");
INSERT INTO mza_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ta tu yu'u töve jà'i ma takua kùuni ma Tatái, na töve ìyo yi ña chinuni ndo ma ña kà'in. ");
INSERT INTO mza_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Va tu yu'u jà'i takua kùuni ma Tatái, ta ndyo'o vaji töve chìnuni ndo ma ña kà'in, va na chinuni ndo cha'a' ma tiñu jà'i, ikan na koto kachin ndio ndo ma ña ndaa, ña ma Tatái ìyo ra chi'i̱n, ta yu'u ìyoi chi'in ra ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Takan kūu ta inga cha'a' kūuni tuku ma ndian judíu tiin na Jesuu, va rakan kākú ra kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tajan chīkoni'i ndiko Jesuu kuà'an ra inga chiyo ma yuta Jordán, ta chāa ra ma nuu jākunduta Xuva tatiempu niku, ta ikan kīndoo ra. ");
INSERT INTO mza_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ta kua'a' ñivi, ña chā'an chānde'e ra ma ikan, te'en kīcha'a na kà'an na: ―Ndicha va'a ña vaji ma Xuva, töve nī ja'a ra nï'iin ndatu ka'nu, va tandi'i ma ña kā'an ra cha'a' ra'ya, ña ndicha kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tajan kua'a' ñivi ka'ìin ma ikan, kīcha'a chìnuni na ma tu'un Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ìyo iin ma ra ku'vi, ña nàni Lázaru. Ta rakan ti, ra ñuu Betania kùu ra, juuni ma ñuu nuu ìyo ma ñivi ta'an ra Ndiya chi'in Mata. ");
INSERT INTO mza_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ndiya ña ta'an Lázaru i'ya, kùan ña chōsoan takuii xiko cha'a Jesuu, ta jānatian yi chi'in ma ixi xinia. ");
INSERT INTO mza_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yakan va ma Ndiya chi'in ma ña ta'an ña Mata, te'en tāchi vi iin yo chāka'an chi'in Jesuu: ―Yo'o racha'nu, ma ra ya'a kùuniun nde'un, kù'vi ra, ri ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tajan ora chīni Jesuu ma ña kā'an na, ta te'en nāka'an ra: ―Ma kue'e ña ndo'o ma Lázaru, na töve ni kuvi ra ja'a yi, vati yakan kùu yi kuenda ña chi'in ra kùu jana'a yi naja kua ya'a ka'nu kùu ma Racha'nu Ndioo, ta juuni kuenda ña na jana'a yi naja kua ka'nu kùu ma ra Se'e ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ta vaji ya'a ga kùuni Jesuu nde'e ra Lázaru, chi'in ma ninduvi ñivi ta'an ra: Mata chi'in Ndiya, ");
INSERT INTO mza_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","va ma ora chīni ra ña kā'an na ña ku'vi ma Lázaru, ta java vi'a ga kīndoo ra uvi kivi ga ma nuu ìyo ra. ");
INSERT INTO mza_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ta ora yā'a ndio ña kūu te'en, tajan Jesuu te'en nāka'an ra chi'in ma ndra jàkua'a chi'in ra: ―Na ku'un ndiko yo ma iti' ñu'u' Judea ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tajan ma ndra jàkua'a chi'in Jesuu te'en nāka'an ndra chi'in ra: ―Matru, já kūuni kuii ma ndian judíu ka'ni na ñu̱n chi'in yuu niku. ¿Ta chïto naja kùuni ndikoun ku'u̱n ma ndakan? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ta Jesuu te'en nāka'an ra chi'in ndra: ―¿A töve chìto ndo ña ma kivi, ìyo uchi uvi ora yi?, kùuni ndo. Taku ma yo chàkunuu ora nduvi, na töve kàti'i yo, vati ndichin nuu yo jà'a ma ñu'ú. ");
INSERT INTO mza_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Va tu chàkunuu yo ora naa, kàti'i yo ti kumani ma ñu'ú nuu yo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Takan kūu tajan Jesuu te'en nāka'an tuku ra: ―Ma ra yani yo Lázaru kìxi ra, va ni ku'in kujandakoi ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tajan ma ndra jàkua'a chi'in ra, te'en nāka'an ndra chi'in ra: ―Yo'o Racha'nu, tu kìxi ra, kùuni yi ka'an yi ña ni ndova'a ra tuva takan ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Va ma ña kūuni Jesuu ka'an ra chi'in ndra, kùu yi ña chī'í ndicha ma Lázaru, va ma ndra jàkua'a chi'in ra chānini ndra ña kà'an ra ña kìxini ra niku. ");
INSERT INTO mza_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tajan Jesuu te'en kātitu'un kachin ndio ra nuu ndra: ―Ma Lázaru cha chī'í ra. ");
INSERT INTO mza_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ta ya'a chisii̱ ña töve ka'ìin yo ma ikan, vati va'aga ña takan kūu yi kuenda ndo, ikan na chinuni ndo. Va na ko'o kunde'o ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tajan ma ra nàni Tomá, ra juuni kà'an chi'in sivi yu'u ña nàni Tilipan, te'en nāka'an ra chi'in inga ma ndra jàkua'a chi'in Jesuu: ―Na ku'un yo chi'in Jesuu, nde'o tu kuvi yo chi'in ra ndia ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Takan kūu ta ora chāa Jesuu ma ñuu Betania ña kàndii ñu'u' Judea, ta ikan chīto ra ña cha ìyo kumi kivi kùu yi ña cha kūchi ma Lázaru. ");
INSERT INTO mza_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ta ma ñuu Betania ti yatini kàndii yi chi'in ma ñuu Jerusalén, ìyo iin uni kilometru, ta chaa yo ma ikan. ");
INSERT INTO mza_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ta kua'a' ma ndian judíu chānde'e na nuu ìyo ma Mata chi'in Ndiya, ña jàndomani na vi cha'a' ña chī'í ma ra ta'an vi Lázaru. ");
INSERT INTO mza_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ta ora chīto ma Mata ña Jesuu cha kuàkuyatin ra ma ñuu Betania, tajan kēe ndioan kuàta'an ña nuu ra, va ma Ndiya kīndoan ma nuu ìyo ve'e. ");
INSERT INTO mza_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tajan ma Mata te'en nāka'an ña chi'in Jesuu: ―Yo'o Racha'nu, na töve kuvi ma ra ta'in tu ndaun ma i'ya niku. ");
INSERT INTO mza_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Va yu'u chìtoi ña Ndioo ni ku'va ra tandi'i ma ña ni ndakaun nuu ra ―kàtian. ");
INSERT INTO mza_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ta Jesuu te'en nāka'an ra: ―Ma ra ta'un, ni nataku ndiko ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ta ma Mata te'en nāka'an ña chi'in Jesuu: ―Ndicha va'a ña cha chìtoi ña ni nataku ndiko ra, ma ora ni nataku ma ndian ndií, ma kivi nuu ndi'i nia ―kàtian. ");
INSERT INTO mza_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tajan Jesuu te'en nāka'an ra chi'an: ―Yu'u kùu ma ra kùu janataku ndiko ma ndian ndií, ta juuni yu'u kùu ja'a ña kùu koo ndito ma ñivi. Ta ma ndian chìnuni ma ña kà'in, vaji na kuvi na, ni nataku ndiko na. ");
INSERT INTO mza_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta ndisaa ma ndian juuni ndito ta chìnuni na ma ña kà'in, na töve ni kuvi na, vati ni koo na endeeni. Ta Jesuu kīcha'a ndiko ra chìkatu'un ra te'en nuu ma Mata: ―¿A chìnuniun ma ña kà'in i'ya? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ta yakan te'en nāka'an ña: ―Juu yo'o Racha'nu, yu'u chìnuni ña yo'o kuu ma Cristu ra Se'e Ndioo, ra kīchaa ma ñuñivi i'ya ―kàtian. ");
INSERT INTO mza_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ta ora ya'a ña kā'an ma ña nàni Mata takan, tajan chāka'an ma ña ta'an ña ña nàni Ndiya, ta te'en kīcha'a kà'an xe'e ña chi'in ña: ―Ma matru cha kīchaa ra, ta kàna ra ñu̱n ―kàtian. ");
INSERT INTO mza_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ta ora chīni ma Ndiya ña kà'an ña takan, ta numini ndēta ña, ta chāka'an ña chi'in ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma Jesuu takä'an chaa ra ma ñuu ikan, vati juuni ka'ìin vi ma nuu chāta'an ma Mata nuu ra. ");
INSERT INTO mza_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yakan va ma ndian judíu ndian ka'ìin chi'an ma ve'an, ña jàndomani na ña, ta ora ndē'e na ña numi va'a ndēta ma Ndiya, ta kēan ma tichi ve'an, ta ma ñivi tāndikun na kuà'an na chata ña, ta kīcha'a na nàtu'un ta'an na te'en: ―¡Kuà'an ña kuàkuakuan nuu kūchi ma ra ta'an ña Lázaru! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ta ma Ndiya ora chāa ña ma nuu ndaa ma Jesuu, chūnandi chitian nuu ra, ta kīcha'a ña kà'an ña te'en chi'in ra: ―Yo'o Racha'nu, tu ndaun ma i'ya chi'in ndi niku, ma ra ta'in na töve kuvi ra niku ―kàtian. ");
INSERT INTO mza_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ta ma Jesuu ora ndē'e ra ña chàku ma Ndiya, ta takani ma ndian judíu, ndian chāa chi'an ma ikan, yakan va ma Jesuu nduva'a kuii kīchi ma ña sutini ra. ");
INSERT INTO mza_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yakan va kīcha'a ra chìkatu'un ra te'en nuu ma Ndiya: ―¿Ndanu kūchi ma Lázaru? ―kàti ra. Ta te'en nāka'an vi chi'in Jesuu: ―Na kichiun ta kujana'a ndi ma nuu kūchi ra ―kàti vi. ");
INSERT INTO mza_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ta ma Jesuu juuni chāku ra. ");
INSERT INTO mza_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yakan va ma ndian judíu kīcha'a na nàtu'un ta'an na te'en: ―¡Na nde'e ndo vati ya'a ga kùuni ma Jesuu ma Lázaru, yakan va chàku ra! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ta ìyo ma ndian judíu kà'an te'en: ―Ma ra jā'a ña ndā'a ma tinuu ma ra takani kuaá ora kāku, ¿naja na töve nī kuu ja'a ra nï'iin nakuyi, ikan na töve kuvi ma Lázaru niku? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesuu inga ndiko, nduva'a kuii kīchi ña sutini ra, tajan chājayatin ra ra ma nuu ìyo ma nuu ñaña ma Lázaru. Ta ma ikan kùu yi iin tichi yavi yuu, ta ma nuu kì'vi yo ndàsi yi chi'in yuu. ");
INSERT INTO mza_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ta Jesuu te'en nāka'an ra: ―Na tachiyo ndo ma yuu ma yu'u yavi ikan ―kàti ra. Ta ma ña nàni Mata ña ta'an ma Lázaru ra chī'í te'en nāka'an ña: ―Yo'o Racha'nu, cha ya'a ga kini cha'an, vati cha ìyo kumi kivi ña chī'í ra ―kàti ña. ");
INSERT INTO mza_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yakan va ma Jesuu te'en nāka'an ra: ―¿A töve cha kā'in chi'un, tuva chìnuniun, ni nde'un ti nduva'a kuii ka'nu kùu ma Ndioo? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yakan va tāchi yo ndio ma ñivi ma yuu ña ndàsi ma nuu ñaña ma Lázaru, tajan ma Jesuu kīcha'a ra ndè'e ra ma iti' andivi ta nāka'an ra te'en: ―Yo'o Tatá, ta'vindioun cha'a' ma ña tàso'un ma ña kà'in. ");
INSERT INTO mza_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yu'u chìtoi ti nani ora kà'in chi'un, chìniun ma ña kà'in, ta tàso'un yi, va kà'in yi ti ña va'a ma ñivi ka'ìin ma i'ya kùu yi, ikan na chinuni na ti maun kùu ma ra tāchi yu'u ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ta ora chīnu kā'an ma Jesuu takan, tajan te'en ni'i va'a nānda'yu ra: ―Yo'o Lázaru, ¡na keun ma nuu ñañaun! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tajan ora chīnu kā'an ra takan, tajan kēe ndio ma ra chī'í niku ma nuu ñaña, ta ma nda'a' ra chi'in cha'a ra ndikun yi chi'in ja'ma kuichin, ta nuu ra ndasi yi chi'in ja'ma ndia. Yakan va ma Jesuu te'en nāka'an ra chi'in ma ñivi: ―Na ndachi ndo ma ja'ma ña kàva ra, ta na ku'un maa ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yakan va kua'a' va'a ma ndian judíu ndian chā'an chi'in ma Ndiya ma nuu jānataku ndiko ma Jesuu ma Lázaru, kīcha'a na chìnuni na, ma ora ndē'e na ma ña jā'a ra. ");
INSERT INTO mza_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ta ìyo ma ndian judíu kēe na chàkatitu'un na nuu ma ndra fariseu ma ña jā'a ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yakan va ma ndra fariseu chi'in ma ndian kuxini nuu ma ndra kùu sutu, jā'a ndra iin junta ka'nu, ta ikan nāka'an ndra te'en chi'in ma ñivi: ―¿Niyi ìyo yi ña ja'a yo? Vati ma ra'ii i'ya, ya'a ga kua'a' ndatu jà'a ra. ");
INSERT INTO mza_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tu ndakoo yo ra ña na ja'a maa ra ma ña kùuni ra, tandi'i ma ñivi ni chinuni na ma ña jà'a ra, ta ma ndra chà'nda tiñu ma ñuu Roma ni kichi ndra ta janaa ndra ma veñu'u yo chi'in ma ñuu yo ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ta iin ma ndra fariseu, ra nàni Caifás, ra kuxini nuu ma ndra kuu sutu ma kuiya ikan, te'en nāka'an ra chi'in ndra: ―Ndyo'o, ni ita'vi nayi töve chìto ndo ―kàti ra―. ");
INSERT INTO mza_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ta ni töve chà'a ndo kuenda ña va'aga kùu yi kuenda ndo ña na kuvi iin ra'iini cha'a' ma kuati ma ñuu, kua ña na kuvi ndisaa ma ñivi ìyo ma ñuu ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Va ma Caifás na töve nī ka'an ra ma takan, vati kùuni maa ra ja'a ra yi, vati tava kùu ra ma ra kuxini nuu ma ndra kùu sutu ma tiempu ikan, yakan va tu'un yu'u Ndioo kā'an ra ña Jesuu ni kuvi ra cha'a' ma ñuu judíu. ");
INSERT INTO mza_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Va na töve uvaa cha'a' ma ñuu i'yani ni kuvi ra, vati juuni cha'a' ña na kuti'vi ta ndo'iin tandi'i ma ndian kùu se'e ma Ndioo, ma ndian ndòyo te'en, tikan. ");
INSERT INTO mza_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yakan va nda ma kivi ikan, kīcha'a ma ndian judíu kùuni na ka'ni na ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yakan va ma Jesuu na tüva chàkunuu ra tañu ma ndian judíu, vati kēe ra ma ñu'u' Judea, ta chàa ra yatini ma iin tichi ku'u nuu chiki iti' ñuu ña nàni Efraín. Ma ñuu ikan kīndoo ra chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ta ora ni kuyatin ma viko pakua ña jàka'nu ma ndian judíu, ta kua'a' va'a ma ñivi chàa ma ñuu Jerusalén antea ña kuta'an koo ma viko ikan, ña kuàjanandoo na takua takani jà'a na. ");
INSERT INTO mza_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ta ma ndian judíu kīcha'a na nànduku na ma Jesuu, ta kīcha'a na chìkatu'un na te'en nuu ma ta'an na ma tichi ma veñu'u: ―¿Naja kua chànini ndo, a vàchi ra ma viko a töve? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ma ndra fariseu chi'in ma ndra kùxini nuu ma ndra kuu sutu kā'an ndra ña, tu ìyo ma ndian chìto ma nuu chàkunuu ma Jesuu, na katitu'un na, ikan na kuu kutiin ma jandaru ra, kàti na. ");
INSERT INTO mza_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iñu kivi antea ña kuta'an ma viko Pakua, tajan kēe ndio Jesuu kuà'an ra ma ñu'u' Betania, nuu ìyo ma Lázaru, ra chī'í, ña jānataku ma Jesuu, niku. ");
INSERT INTO mza_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ta ikan chā'a vi ña chāchi Jesuu. Ta ma ña nàni Mata kùu ma ña tī'i ña chāchi na, ta Lázaru kùu ma ra nàndi yu'u mesa tañu ma ñivi chi'in ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tajan ma Ndiya chāki'an uni cientu gramu ma takuii xiko ña nàni nardu, ña ya'a ya'vi ndaa. Ta tāan ña ra' cha'a Jesuu, ta ora chīnu, ta jānatii ña yi chi'in ixi xinian. Ta ndisaa kuii ma tichi ve'e nuu ka'ìin vi endee chìtakuati ma xiko ra'. ");
INSERT INTO mza_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Takan kūu tajan ma Judá, ra nàni Iscariote, ra kùu iin ra jàkua'a chi'in Jesuu ña ni xikoña'a cha'a ra, te'en nāka'an ra: ");
INSERT INTO mza_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Ta naja töve nī kuya'vi ma takuii xiko i'ya cha'a' uni cientu xu'un' plata denariu, kuenda ña tìndee yo ma ndian nda'vi niku? ―kàti ma Juda. ");
INSERT INTO mza_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Va na töve kā'an ra takan cha'a' ña ndicha ña kùuni ra nde'e ra ma ndian nda'vi, vati kā'an ra yi cha'a' ña kùu ra iin rasu'u. Vati tava maa ra kùu ma ra ndiso tiñu cha'a' chatun nuu tì'i ñivi xu'un' tichi yi, ta sù'u ra ita'vi yi. ");
INSERT INTO mza_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Takan kūu tajan Jesuu, te'en nāka'an ndio ra chi'in ra: ―Na ja'a maa ña yi, vati ndākiva'a ña ma takuii xiko i'ya kuenda ña ku'vian ra' yu'u ma ora ni kuchi̱. ");
INSERT INTO mza_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vati taku ma ndian nda'vi endee ìyo na chi'in ndo, va yu'u, na töve endeeni ni koi chi'in ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Takan kūu tajan kua'a' va'a ma ndian judíu chā'a na kuenda ña Jesuu ìyo ra ma ñuu Betania, yakan va chā'an ndio na, va na yöve ivaa cha'a' Jesuuni kùu yi ña chā'an na, vati juuni kuànde'e na ma Lázaru, ra jānataku ma Jesuu niku, ndia. ");
INSERT INTO mza_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tajan ma ndra kuxini nuu ma sutu, nātu'un ta'an ndio ndra ña juuni kùuni ndra ka'ni ndra ma Lázaru ndia. ");
INSERT INTO mza_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Vati cha'a' ra kùu yi ña kua'a' va'a ma ndian judíu kīcha'a na kèsiin na, ta chìnuni ndio na ma tu'un Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Takan kūu ta kua'a' va'a ma ndian kēe kuà'an ma ñuu Jerusalén cha'a' ma viko Pakua, ma inga kivi chīto ndio na ña ni chaa Jesuu ma ñuu ikan. ");
INSERT INTO mza_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tajan kīcha'a ndio ma ñivi chà'nda na nda'a' tika'a, ta kēe ndio na kuàta'an na nuu vàchi Jesuu, ta te'en kīcha'a ndio na kànachaa na: ―¡Ya'a ga ka'nu ma Racha'nu Ndioo! ¡Ta ya'a ga ií kùu ma ra vàchi chi'in sivi Ndioo! ¡Ta ya'a ga ií kùu ma ra kuu rey ña chà'nda tiñu nuu ma ndian ìyo ñuu Israel! ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Takan kūu tajan Jesuu nāta'an ra iin burru vali, ta chākoso ra ri, ma takua kà'an yi nuu ma tutu Ndioo: ");
INSERT INTO mza_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Na yü'vi ndo ndyo'o ndian ìyo ñu'u' Sión, ti cha vàchi ma ra kùu rey ndo ña chà'nda tiñu nuu ndo yòso ra iin burru, kàti yi. ");
INSERT INTO mza_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma cha'a' nunuu, töve nī kutunini ma ndra jàkua'a chi'in Jesuu ma ña'a niku, nda ora cha nātaku ndiko ma Jesuu, tajan chāku'uni ndra ña ndisaa ma ña tā'an ra i'ya, kūu yi tava kà'an yi nuu ma tutu Ndioo ña kà'an cha'a' ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ta ma ñivi ka'ìin chi'in Jesuu ma ora kāna ra ma Lázaru ma nuu indii ra nuu ñaña ra ta jānataku ra ra, ma ñivi ikan nātu'un ta'an na ma ña ndē'e na. ");
INSERT INTO mza_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Cha'a' yakan kùu yi ña kēe ma ñivi chàta'an na nuu Jesuu, vati chīto na ma ndatu ka'nu ña jā'a ra. ");
INSERT INTO mza_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Takan kūu tajan ma ndra fariseu te'en kīcha'a ndra nàtu'un ta'an ndra: ―Cha ndē'e ndo ña na küu ja'a yo nï'iin nakuyi, vati tandi'i ma ñivi tāndikun na ra ―kàti ma ndra fariseu. ");
INSERT INTO mza_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ta tañu ma ndian chā'an chājaka'nu Ndioo ma ñuu Jerusalén ma viko Pakua kùu na ndian griegu. ");
INSERT INTO mza_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ma ndian griegu i'ya chājayatin na na ma nuu ndaa Lipe, ra kīchi ñuu Betsaida, ña ìyo kuenda ma ñu'u' Galilea. Ndrakan te'en kīcha'a ndra jànini ndra ma Lipe chi'in tu'un i'ya: ―Yo'o tatá, kùuni ndi ka'an ndi chi'in Jesuu ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tajan ma Lipe kēe ra chākatitu'un ra yi nuu ma ra nàni André. Ta ninduvi ndio ndra chākatitu'un ndra yi nuu Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Cha kēta ma ora ña ni kuvi ma ra Se'e Ndioo nuu kruu, ikan na koto ma ñivi ña ya'a ka'nu ra kùi. ");
INSERT INTO mza_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ndicha va'i ña kà'in chi'in ndo ña tu töve koyo ji'na ma chiti trigu nuu ñu'u', ta chì'í yi, ni kindoo ma'iin yi; ta tu kuvi yi, nduva'a kua'a' ma tata yi ni koo. ");
INSERT INTO mza_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ta ma ra ya'a ga kùuni ndoka'nu juuni maa ra ñuñivi i'ya, ni naa anima ra nuu Ndioo endeeni, ta ma ra töve kùuni ra nde'e ra ma ñuñivi i'ya, ni ni'i ra nuu koo ra endeeni chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ta tu ìyo ma ndian kùuni ja'a tiñu nui, na tandikun na chatai, vati ma nuu ni koi, ikan ni koo ma ra jà'a tiñu nui ndia. Ta tu ìyo nda yo ja'a tiñu nui, nda ma Tatái ni tiñu'u ra na ndia. ");
INSERT INTO mza_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’¡Ya'a nduva'a nàkanini̱! ¿Ta nayi ìyo yi ña ka'in?, kùuni ndo. ¿A ìyo yi ña ka'in chi'in Ndioo: “Tatá na jakaku̱n yu'u nuu ma tundo'o ni nde'i”?, kùuni ndo. Na küu ka'in takan, ti kuenda ikan vàchi̱, ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Takan kūu tajan ma Jesuu te'en nāka'an ra chi'in Ndioo: ―Yo'o Tatá, na tiñu'u̱n ta na jaka'nu̱n ma siviun ―kàti ra. Tajan te'en nāka'an ma tati yu'u Ndioo ma iti' andivi: ―Cha jāka'nui ma sivi̱, ta cha tīñu'i yi, va ni ja'a ndikoi yi ―kàti yi. ");
INSERT INTO mza_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ta ma ñivi ka'ìin ma ikan ña chīni ma ña kūu, ta ka'an na ti, tacha kùu ma ña chīnu, ta ìyo inga na ña, te'en kà'an na: ―Iin tati ña jà'a tiñu nuu Ndioo kùu yi ña kā'an ra chi'in ra ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tajan te'en nāka'an ra chi'in na: ―Na yöve cha'a' yu'u kùu yi ña chīni ndo ma tati ikan kā'an ma Ndioo chi'i̱n, vati cha'a' maa ndo kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vitin va cha kēta ma tiempu ña ni jakutuni Ndioo kuati ma ñivi, ta juuni ma vitin kùu yi ña ni tavani'i Ndioo ma ñá' chà'nda tiñu nuu ñu'u' ñuñivi i'ya. ");
INSERT INTO mza_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Vati ora ni jandeta ma ñivi yu'u ma nuu ñu'u' i'ya, ni ja'i ña na kua'a' ñivi chaa na nuu koi. ");
INSERT INTO mza_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chi'in tu'un i'ya kūuni Jesuu ka'an ra naja kua ni kuvi ra. ");
INSERT INTO mza_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tajan te'en nāka'an na chi'in ra: ―Ndyu'u chīni ndi ña kà'an yi nuu ma tutu Ndioo ña ma Cristu ni koo ra indeeni. ¿Ta chïto naja kā'un ña ma ra Se'e Ñivi tāchi Ndioo ìyo yi ña kuvi ra? ¿Nda ra kùu ma ra Se'e Ñivi tuva takan? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tajan Jesuu te'en nāka'an ra chi'in na: ―Ni koo ga ma ñu'ú ña jàtuun nuu ndo ma ñuñivi i'ya, va tia tiempunia. Yakan va na nanduku ndo naja kua koo va'a ndo ora juuni ìyo ga ma ña jandondichin nuu ndo. Koto jäna'ini ndo ma ora ni ndonaa. Vati taku ma ndian chàkunuu ma nuu naa, na töve chìto na nda iti' kuà'an na. ");
INSERT INTO mza_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yakan va na chinuni ndo tu'un kà'an ma ra kùu tava kùu ma ñu'ú ña jàndondichin nuu ndo, ta kuu ndo takua kùu ma ra se'e ra ―kàti Jesuu. Ta ora chīnu kā'an ra ma tu'un i'ya, tajan kēe ndio ra kuà'an ra, ta chūndii xe'e ra nuu na. ");
INSERT INTO mza_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ta vaji ya'aga kua'a' ma ndatu ka'nu jā'a ma Jesuu ña nànde'e ma ndian judíu, va töve nī chinuni na yi. ");
INSERT INTO mza_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Takan ìyo yi ña kuu, ikan na chinu ma tu'un kà'an ma ra kā'an chi'in tu'un yu'u Ndioo, ra chūnani Isaía, vati rakan te'en kā'an ra: Yo'o Racha'nu, ¿yo kùu ma ndian cha chìnuni ma tu'un kà'an yo? Ta, ¿Yo nuu jā'a ma Ndioo ma ndatu ra? kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Takan kūu yi ña töve nī kuuni na chinuni na, va juuni tāa tuku ma Isaía ra kà'an chi'in tu'un yu'u Ndioo te'en ndia: ");
INSERT INTO mza_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Jāndokuaá ra ma ñivi ta jāndava ra ma anima na, ikan na küu kutunini na ma ña jà'a ra, ta küu nde'e na, ti töve nī kuuni na chikoni'i na chi'in Ndioo ta ki'vi na iti' ra kuenda ña na kuu janda'a ra na ndia, kāti tutu tāa Isaía. ");
INSERT INTO mza_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Takan kā'an ma Isaía vati ndē'e ra ña ya'a ka'nu kùu ma Cristu, ta cha'a' ña kā'an ra cha'a' ra kùu yi ndia. ");
INSERT INTO mza_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ta ndicha va'a ña kua'a' ma ndian judíu kīcha'a na chìnuni na ña kà'an Jesuu, ta nda uvi uni ma ndian kuxini nuu ma ndian judíu, kīcha'a chìnuni na ndia. Uvaa ña na töve kà'an na yi nuu tùvi ñivi, ti ndasii na nde'e na ma ndra fariseu, koto tavani'i ndra na endeeni tichi ma veñu'u na. ");
INSERT INTO mza_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Takan jā'a na vati chàta'ani ga na ña tiñu'u ñivi na chi'in tu'un kà'an na, takua ma ña kà'an Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Takan kūu tajan te'en nāka'an ni'i ndio Jesuu chi'in na: ―Taku ma ndian chìnuni ña kà'in, kùuni yi ka'an yi ña na töve uvaa ña kà'an yu'uni chinuni na vati juuni chinuni na ña kà'an ma Tatái, ra tāchi yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta ma ndian ndè'e yu'u, juuni ndè'e na ma ra tāchi yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Vati yu'u kùi tava kùu ma ñu'ú ña jàtuun nuu ndo, ta yu'u kīchai ma ñuñivi i'ya kuenda ma ndian chìnuni ña kà'in, ikan na töve kindoo na ma nuu naa. ");
INSERT INTO mza_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta tu ìyo ma ndian chìni ma ña kà'in ta töve jàchi'in na yi, na yöve yu'u kùu ma ra ni tisokuati na, vati yu'u vàchi̱ kuenda ña jàkakúi ma ñivi, ta yöve kuenda ña tìsokuati̱ na. ");
INSERT INTO mza_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ta ma ndian töve kùuni nde'e yu'u, ta töve jàchi'in na ma ña kà'in, cha ìyo ma ña ni tisokuati na, ta ma tu'un ikan te'en kà'an yi: juuni ma tu'un kà'in nuu na ña ni tisokuati yi na ma kivi nuu ndi'inia, yakan kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Vati yu'u töve kà'in yi kuenda juuni mai, ti kà'in yi naja kua kùuni ma Tatái, ra tāchi yu'u ña jà'i. Ta naja kua kùuni ra ña jana'i ndia. ");
INSERT INTO mza_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Vati yu'u chìtoi ti ma tiñu ña tāchi ma Tatái yu'u ña na ka'in, ni ja'a yi ña na koo ndo endeeni. Va ma ña kà'in, kà'in yi ma takua kātitu'un ma Tatái ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Antea ña kuta'an ma viko Pakua, Jesuu cha chìto ra ña cha chāa ma ora ña ni ndakoo ra ma ñuñivi i'ya, ta ku'un ndiko ra nuu ìyo ma Tatá ra. Vati ma Jesuu ndisaa tiempu ya'a kùuni ra nde'e ra ma ndian chìnuni ma ña kà'an ra ña ìyo ma ñuñivi i'ya. Ta takan kùuni ra nde'e ra na, nda ma kivi nuu ndi'inia. ");
INSERT INTO mza_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ta ma kui'na cha kī'vián' ma tichi anima ma Judá Iscariote, ra se'e ra nàni Simón, ña ni xikoña'a cha'a' Jesuu ora ka'ìin ndra kuxini ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Va ma Jesuu cha chìto ra ña cha chà'a ma Ndioo tiñu nuu ra ña na ka'nda ra tiñu nuu ma ñivi, vati ma Ndioo tāchi ra, ta nuu Ndioo ìyo yi ña chaa ndiko ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yakan va Jesuu ndēta ra ma nuu nàndi ra kuxini ra nuu mesa, ta tāva ra ma ja'ma isukun ra, ta kī'in ra inga ja'ma ta chū'ni ra yi toko ra. ");
INSERT INTO mza_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tajan Jesuu tāan ra takuii tichi iin tako'o ta kīcha'a ndio ra nàkata ra cha'a ma ndra jàkua'a chi'in ra. Ta ora chīnu, tajan kīcha'a ndio ra jànatii ra cha'a ndra chi'in ma ja'ma ña ndìkun toko ra. ");
INSERT INTO mza_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ta ora chaa ra nuu nàndi ma Simón Petu', ra'ya te'en nāka'an ra chi'in ra: ―Yo'o Racha'nu, ¿ta naja yo'o ni nakataun cha'i? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tajan Jesuu te'en nāka'an ra: ―Ma ña jà'i takä'an kutuniniun yi, nda tiá iti' nuu tajan ni kutuniniun yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ta Petu' te'en nāka'an ra: ―Nï'iin cha'a' na töve ku'vai ña nakataun cha'i ―kàti ra. Ta ma Jesuu te'en nāka'an ra: ―Tu töve ku'vaun ña na nakatai ñu̱n, na küu koun kakunuu̱n chi'i̱n ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ta Simón Petu' te'en nāka'an ra: ―Yo'o Racha'nu, na töve kùuni̱ ña na nakataun uvaa ma cha'ani, vati juuni kùuni̱ ña na nakataun ma nda'i chi'in xini̱ ndia ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ta Jesuu te'en nāka'an ra: ―Taku ma ra já chīti, na tüva ìyo yi ña kuti ndiko ra inga cha'a', vati ìyo yi ña ndoo cha'a ni ra. Ta ndyo'o cha ndōo ndo vaji na yöve ndisaa ndo kàa takan ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Takan kā'an ra ti cha chìto ra nda ra kùu ma ra ni xikoña'a cha'a ra, yakan va kà'an ra ña, na yöve ndisaa ndo cha ndōo ndo. ");
INSERT INTO mza_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ta ora chīnu nākata Jesuu cha'a ndra, ta chāku'un ndiko ra ma ja'ma ña isukun ra, ta chūnandi ndiko ra yu'u mesa chi'in ndra, ta te'en nāka'an ra: ―¿A kùtunini ndo ma ña jà'i chi'in ndo? ―kàti Jesuu―. ");
INSERT INTO mza_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ndyo'o kà'an ndo ña kùi matru, ta Racha'nu, ta ña ndicha kùu ma ña kà'an ndo, ti takan kùi. ");
INSERT INTO mza_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Va tu yu'u ña kùi matru, ta Racha'nu, ta nākatai cha'a ndo. Juuni takan ìyo yi ña ja'a ndo chi'in ma ndian kùu ta'an ndo ndia. ");
INSERT INTO mza_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yu'u cha jāna'i naja kua ìyo yi ña ja'a ndo, ta takan kùuni̱ ña nakata ndo ma cha'a ta'an ndo ma takua jā'i chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ndicha va'a ña kà'in chi'in ndo, ña ma ra jà'a tiñu nuu ma ra kùu chito'o ra, töve ka'nuga ra kua ma ra kùu chito'o ra. Ta ma ra kēe kuà'an iin tiñu, töve ka'nuga ra kua ma ra tāchi ra ndia. ");
INSERT INTO mza_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tu kutuni ndo ma ña kà'in chi'in ndo, ta kicha'a ndo ja'a ndo yi, ya'aga siini ni kuuni ndo tuva takan. ");
INSERT INTO mza_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Na töve kà'in ma tu'un i'ya cha'a' ndisaa ndyo'o ndra kāchi̱n, vati cha chìto mai nda ra kùu ma ra kà'in cha'a'. Takan kùu yi ikan na chinu ma ña kà'an yi nuu ma tutu Ndioo, ta te'en kà'an yi: “Ma ra nàndi chàchi chi'i̱n, ni xikoña'a ra cha'i.” ");
INSERT INTO mza_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Takan kà'in yi chi'in ndo vitini, ikan ma ora kuta'an ña ni kuu takan, chinuni ndo ti yu'u kùu ra takani ìyo. ");
INSERT INTO mza_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ndicha va'a ña kà'in chi'in ndo, ña ma ndian kì'in kuenda ma ra tàchi̱, nda yu'u kì'in na kuenda ndia. Ta ma ndian kì'in kuenda yu'u, juuni kì'in na kuenda ma ra tāchi yu'u ndia ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ta ora chīnu kā'an Jesuu takan, ta nduva'a nda'vi kūuni ra, ta te'en nāka'an kachin ra chi'in ndra: ―Ndicha va'a ña kà'in chi'in ndo, ti iin ndo ni xikoña'a ndo cha'i ―kàti ra chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tajan ma ndra jàkua'a chi'in ra kīcha'a ndra kànde'e nuu ta'an ndra, ti töve chìto kachin ndra nda ra kùu ma ra kà'an Jesuu cha'a'. ");
INSERT INTO mza_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tajan iin ra tañu ndra ña ya'aga kùuni ra nde'e ra, nàndi ra chàchi ra xiin Jesuu ma nuu ka'ìin ndra kuxini ndra. ");
INSERT INTO mza_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nuu rakan jānda'a ndio ma Simón Petu' ña na ndakatu'un ra nuu Jesuu, ña nda ra kùu ma ra kà'an ra cha'a'. ");
INSERT INTO mza_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yakan va chājayatin ra ra tiá xiin Jesuu, ta kīcha'a ra chìkatu'un ra te'en nuu ra: ―Yo'o Racha'nu, ¿nda ra kùu ma ra kà'un? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tajan ma Jesuu te'en nāka'an ra: ―Ni jatii̱ ita'vi ma paan, ta nuu ma ra ni ku'vai yi, rakan kùu ra. Ta ora chīnu kā'an ma Jesuu takan, tajan jātii ndio ra ita'vi ma paan, ta chā'a ra yi nuu ma Juda Iscariote, ra se'e Simón. ");
INSERT INTO mza_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ta juuni ma ora chāchi ma Juda ma paan ikan, ma ora ikani kī'vi ma kui'na tichi anima ra. Tajan ma Jesuu te'en nāka'an ra chi'in ra: ―Ma ña ni ja'un, na ja'un yi numini ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Va nï'iin ma ndra nàndi chi'in Jesuu ña ka'ìin kuxini chi'in ra ma yu'u mesa, nī kutunini ndra naja kà'an Jesuu takan chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Va tava ma Juda kùu ma ra ndiso tiñu cha'a' ma xu'un', yakan va ìyo ma ndra chānini ña Jesuu kà'an ra ña na jata ma Juda iin nakuyi kuenda ma viko, ta inga ma ndra chānini ña kūuni ra ka'an ra ña na ku'va ra xu'un' nuu ma ndian nda'vi. Takan kūuni ndra. ");
INSERT INTO mza_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Takan kūu ta ora cha yā'a chāchi ma Juda ma paan ikan, tajan kēe ndio ra kuà'an ra, va cha kuaa kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ta ora cha kēe ndio ma Juda kuà'an ra, tajan te'en nāka'an ma Jesuu: ―Vitin ndicha kuii va nde'o ña ya'aga ka'nu kùu ma ra Se'e Ñivi tāchi Ndioo, ta nda ma Ndioo cha ndē'o ña iin ra ka'nu kùu ra, jà'a ña jàna'i ña na takani kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ta tu yu'u ma ra Se'e Ñivi tāchi Ndioo jàna'a ra naja kua ka'nu kùu ma Racha'nu Ndioo, nda ma Ndioo juuni ni jana'a ra naja kua takani ka'nu kùu ma ra Se'e ra chi'in juuni maa', ta ni ja'a ra yi numini. ");
INSERT INTO mza_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","’Ndyo'o se'yu, na tüva ni koi kua'a' tiempu chi'in ndo, ti ma nuu kuà'in, ndyo'o na küu ku'un ndo, vati tava cha kā'in chi'in ma ndian judíu juuni kua ikan kà'in chi'in ndo ndia. Ta juuni na küu ku'un ndo ma nuu kuà'in ndia. ");
INSERT INTO mza_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yu'u ni ku'vai ma tu'un chaa i'ya nuu ndo ma naja kua ìyo yi ña ja'a ndo, ta te'en kà'an yi: Na kuuni ndo nde'e ndo ta'an ndo. Ta takua kùuni yu'u nde'i ndo ìyo yi ña kuuni ndo nde'e ndo ta'an ndo. ");
INSERT INTO mza_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta tu ndicha ña kuuni ndo nde'e ndo ta'an ndo, tandi'i ma ñivi ìyo ñuñivi, ni ku'va na kuenda ña ndyo'o kùu ndo ma ndian jàkua'a chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Takan kūu tajan Simón Petu', te'en kīcha'a chìkatu'un ra nuu ma Jesuu: ―Yo'o Racha'nu, ¿ndanu kuà'un? ―kàti ra. Ta Jesuu te'en nāka'an ra: ―Ma nuu kuà'in, na küu ku'u̱n vitin, va nuu ni ku'u̱n kùu yi tiá iti' nuu ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tajan ma Petu' te'en nāka'an ra chi'in ra: ―Yo'o Racha'nu, ¿ta naja küu ku'in chataun ma nuu kuà'un vitin? ¡Yu'u ìyoni ku'in chi'un, vaji na kuvi̱ cha'un! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ta Jesuu te'en nāka'an ra chi'in ra: ―¿A ndichaun ña ìyoniun ku'u̱n chi'i̱n vaji na kuviun cha'i? Ndicha va'a ña kà'in chi'un ña antea ña nda'yu ma lo'o, uni cha'a' ni ka'un ña töve nàkotoun yu'u ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Na töve nuva jà'a ndo ña nda'vi kūuni ndo. Na chinuni ndo ma ña kà'an Ndioo, ta na chinuni ndo ma ña kà'in ndia. ");
INSERT INTO mza_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ma nuu ìyo ve'e ma Tatái, ìyo kua'a' ma nuu koo yo, vati tu töve yi, cha kātitu'in nuu ndo niku. Ta takan kùu yi ña ni kujandova'i ma nuu koo ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ta ora cha kuà'an ndioi ña kuàjandova'i ma nuu koo ndo, ni kichi ndikoi inga cha'a', ta ni ku'un ndo chi'i̱n, ikan indukuni koo ndo chi'i̱n ma nuu ni koi. ");
INSERT INTO mza_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ta ndyo'o cha chìto ndo ndanu kùu ma nuu kuà'in, ta chìto ndo ma iti' kuà'in ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tajan ma ra nàni Tomá te'en chīkatu'un ra nuu Jesuu: ―Yo'o Racha'nu, töve chìto ndi ma nuu kuà'un, ta, ¿chïto naja kà'un ña cha chìto ndi ma iti' kuà'un? ");
INSERT INTO mza_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tajan Jesuu te'en nāka'an ra chi'in ra: ―Yu'u kùu ma iti' ndaa, chi'in ma iti' ndicha, ta ma ña chà'a nuu koo ndìto yo. Ta uvaa chi'in yu'uni, kùu chaa yo nuu ìyo ma Racha'nu Tatái. ");
INSERT INTO mza_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tu ndyo'o cha nākoto ndo yu'u, kùuni yi ka'an yi ña juuni cha nàkoto ndo ma Tatái, ta vitin cha nàkoto ndo ra, vati cha ndè'e ndo ra. ");
INSERT INTO mza_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tajan ma Lipe te'en nāka'an ra chi'in Jesuu: ―Yo'o Racha'nu, na ku'vaun ña na nde'e ndi ma Racha'nu, ra kùu Tatáun, ta chi'in yakan, cha kùu kìndoo va'ani ndi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tajan ma Jesuu te'en nāka'an ra: ―Yo'o Lipe, cha kua'a' tiempu kùu yi ña ìyoi chi'in ndo, ¿a takä'an nakoto va'un yu'u ña kà'un takan? Ma ndian ndè'e yu'u, juuni ndè'e na Tatái. Ta, ¿naja chìkaun ña na ku'vai nde'e ndo ma Tatái tuva takan? ");
INSERT INTO mza_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A töve chìnuniun ña yu'u ìyoi chi'in ma Tatái, ta rakan ìyo ra chi'i̱n? Ma tu'un ña kàtitu'in nuu ndo, yöve tu'un ña jàndakuu maani̱ kùu yi, ti ma Tatái, ra ìyo chi'i̱n, kùu ra ña jà'a ra ma ña ndè'e ndo nui. ");
INSERT INTO mza_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na chinuni ndo ña yu'u ìyoi chi'in ma Tatái, ta ma Tatái ìyo ra chi'i̱n ndia. Ta tu töve chìnuni ndo ña takan kùu yi, na chinuni ndo ji tu ma tiñu ka'nu ña ndè'e ndo ña jà'i. ");
INSERT INTO mza_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ndicha va'a ña kà'in chi'in ndo ti ma ndian chìnuni ma tu'in, indukuni ni ja'a na ma tiñu ka'nu, tava jà'i yi. Ta ni ja'a na inga tiñu ka'nuga cha'a' ña ni ku'in nuu ìyo ma Tatái. ");
INSERT INTO mza_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta ndisaa ma ña chìkan ndo chi'in sivi̱, ni ku'vai yi nuu ndo, ikan yu'u ra kùu Se'e ra, ni jana'i naja kua ya'a ka'nu kùu ma Tatái nuu ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yakan va tu chìkan ndo iin nakuyi chi'in sivi̱, ni ja'i yi. ");
INSERT INTO mza_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tu ndyo'o kùuni ndo nde'e ndo yu'u, na jachi'in ndo ndisaa ma tu'un ña kàtitu'in nuu ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ta yu'u ni ndakain nuu ma Tatái ña na tachi ra inga ma ra tìndee ndo, ta rakan, na jamani ra ndo, ta ni koo ra chi'in ndo endeeni. ");
INSERT INTO mza_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ta ra'ya kùu ma Tati Ií Ndioo, ra jàna'a ma ña ndaa cha'a' ma Ndioo. Ta ma ndian ìyo ma ñuñivi i'ya, ña töve chà'a na ña kì'vi ra tichi anima na. Na küu jà'a na yi, ti töve ndè'e na ra, ta töve nàkoto na ra ndia. Va ndyo'o nàkoto ndo ra, ti ìyo ra chi'in ndo, ta ni koo ra chi'in ndo endeeni. ");
INSERT INTO mza_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ta na töve ni ndakoo ma'ii̱n ndo, ti ni chikoni'i ndikoi koi chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ta tichi tia kivinia, ma ndian töve chìnuni na tüva ni nde'e na yu'u; va ndyo'o ni nde'e ndo yu'u, ti cha'a' ña ìyo nditoi kùu yi ña ni koo ndito ndo endeeni. ");
INSERT INTO mza_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ma kivi ikan, ndyo'o ni ku'va ndo kuenda, ña yu'u ìyoi chi'in ma Tatái, ta ndyo'o ìyo ndo chi'i̱n, ta yu'u chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ta ma ndian chìni ma ña kà'in, ta jàchi'in na yi, ndiakan jàna'a na ña ndicha va'a ña kùuni na nde'e na yu'u. Ta ma Tatái nduva'a kuii ni kuuni ra nde'e ra ma ndian kùuni nde'e yu'u, ta yu'u nduva'a kuii ni kuuni̱ nde'i na, ta ni jana'i yu'u nuu na. ");
INSERT INTO mza_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ta ma Juda (na yöve ra nàni Iscariote), te'en kīcha'a ra chìkatu'un ra nuu Jesuu: ―¿Ta naja chani jana'un ñu̱n nuu ndyu'u, ta töve ni jana'un ñu̱n nuu ma ñivi ìyo ñuñivi? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tajan Jesuu te'en nāka'an ra chi'in ra: ―Ma ndian kùuni nde'e yu'u, jàchi'in na ma ña kà'in, ta ma Tatái ni kuuni ra nde'e ra na ndia. Tajan yu'u chi'in Tatái ni kichi koo ndio ndi chi'in na. ");
INSERT INTO mza_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ta ma ndian töve kùuni nde'e yu'u, töve jàchi'in na ma ña kà'in. Ta ma tu'un ña chìni ndo, yöve tu'un ña jàndakuu maani̱ kùu yi, ti tu'un ma Tatái, ra tāchi yu'u kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Tandi'i ma tu'un ña kà'in chi'in ndo, kà'in yi juuni yanga ìyoi chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Va ma Tati Ií Ndioo, ña ni tachi ma Tatái chi'in sivi̱, kuenda ña tìndee ra ndo, ta jàndomani ra ndo, ni jana'a ra tandi'i nakuyi nuu ndo, ta tandi'i ma tu'un ña kā'in chi'in ndo niku, rakan ni jakuku'uni ra yi ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ni ku'in, va ni ndakoi ndo ña na koo taxiin ndo. Ta ma ña chà'i nuu ndo ña na koo taxiin ndo, töve indukuni kùu yi, tava kùu ma ña chà'a ma ndian ìyo ñuñivi. Yakan va na näkanini ndo, ta na yü'vi ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Cha chīni ndo ña kà'in, ña ni ku'in, ta ni kichi ndikoi koi chi'in ndo. Tu ndicha ña kùuni ndo nde'e ndo yu'u, nduva'a sii ni kuuni ndo ma ora chīto ndo niku, ña kà'in ña ni ku'in nuu ìyo ma ra kùu Tatái, vati rakan ka'nuga ra kua yu'u. ");
INSERT INTO mza_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Antea ña kùu takan, cha kàtitu'un kuei nuu ndo, ikan ma ora ni kuta'an ña ni kuu ma ña kà'in: na chinuni ndo. ");
INSERT INTO mza_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na küuga ka'an kuà'i chi'in ndo, ti cha vàchi ma ñá' chà'nda tiñu nuu ñu'u' ñuñivi i'ya, vaji töve ìyo nï'iin ndatu ña kùu ja'án' chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Takan ìyo yi ña kùu yi, ikan na ku'va ma ñivi ñuñivi kuenda ña yu'u kùuni̱ nde'i ma Tatái, ta jà'i ma tiñu ña tāchi ra yu'u ña jà'i. ¡Na ko'o vitin! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Takan kūu tajan Jesuu te'en nāka'an ndiko ra: ―Yu'u kùi takua kùu ma yoku'u uva ndicha, ta ma Tatái kùu ra takua kùu ma ra jàkuenda ma yoku'u ikan. ");
INSERT INTO mza_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta tu ìyo iin soko ma yoku'u ña töve chà'a ma uva, chà'nda ra yi endeeni. Va tu chà'a yi ma uva, vii ga chà'nda ra soko yi, ikan na ku'va yi tiaga vu. ");
INSERT INTO mza_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta ndyo'o, cha'a' ña chìnuni ndo ma ña kà'in, cha ndākuu ndo ndian vii takua ma soko yoku'u chaa ikan. ");
INSERT INTO mza_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yakan va na induku koo ndo chi'i̱n, takua induku ìyoi chi'in ndo. Vati ma soko ma yoku'u uva, na küu ku'va maa yi ma uva, tuva töve tàtuu yi chata ma yoku'u. Ta indukuni, ndyo'o na küu ja'a ndo ma tiñu va'a, tuva töve induku chàkunuu ndo chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yu'u kùu ma yoku'u uva, ta ndyo'o kùu ndo takua kùu ma soko run. Ta ma ndian induku ìyo chi'i̱n, ta induku ìyoi chi'in na; kùu ja'a na kua'a' ma tiñu va'a, vati tu töve ìyoi chi'in ndo, nï'iin nakuyi küu ja'a ndo. ");
INSERT INTO mza_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma ndian töve induku ìyo chi'i̱n, ni jakuitai na ma nuu ni natii na, ta ikan ni kayu na takua tà'an ma soko yutun ití. ");
INSERT INTO mza_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ta tu ndyo'o induku ìyo ndo chi'i̱n, ta jàchi'in ndo ma ña jàna'i nuu ndo, ta töve nàani ndo, kùu ndakan ndo ma ña kùuni maa ndo, ta ni'i ndo yi. ");
INSERT INTO mza_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kuenda ma Tatái, ya'aga ka'nu kùu yi, tuva chìto ra ña ndyo'o iin locho ndo takua ka'ìin kua'a' chiti uva ma yoku'u vu. Tu jà'a ndo takan, ndicha kuii ña ni chaa ndo kùu ndo ndian jàkua'a chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yu'u ya'aga kùuni̱ nde'i ndo, indukuni takua kùuni ma Tatái nde'e ra yu'u. Yakan va koto jäña ndo ña jà'a ndo yi, ti kùuni̱ nde'i ndo. ");
INSERT INTO mza_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tu jàchi'in ndo ma tu'un ña kùuni̱ ja'a ndo, töve ni jañai ña kùuni̱ nde'i ndo, ti yu'u takua jàchi'i̱n ma tu'un kà'an ma Tatái. Yakan va töve jàña ra ña kùuni ra nde'e ra yu'u. ");
INSERT INTO mza_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Takan kà'in chi'in ndo, ikan na ku'vai ña sii ìyo nui ña na koo yi chi'in ndo. Ta takan na kindoo ndo ña nduva'a kuii sii kuuni ndo. ");
INSERT INTO mza_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma tu'un ña kùuni̱ ja'a ndo, te'en kà'an yi: na kuuni ndo nde'e ndo ma ta'an ndo, tava kùuni yu'u nde'i ndo. ");
INSERT INTO mza_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ma ña ka'nuga ña jà'a yo kùu yi ña ku'va yo ma kuñu yo ña kuvi yo cha'a' ma ndian meru yo. ");
INSERT INTO mza_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ndyo'o kùu ndo ndian merui, tuva jà'a ndo ma tiñu tāchi̱ nuu ndo. ");
INSERT INTO mza_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tüva ni ka'in ña kùu ndo musui, ti ma ndian kùu musu, na töve chìto na nda ña kùu ma ña jà'a ma chito'o na. Kà'in chi'in ndo ña kùu ndo ma ndian amigui, vati chà'i ña koto kachin ndo tandi'i ma ña jāna'a ma Tatái nui. ");
INSERT INTO mza_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ta na yöve ndyo'o kùu ndo ña kāchin ndo yu'u, ti yu'u kùu ma ra kāchi̱n ndo, ta chā'i ma tiñu ndo ña na kùu ndo tatuin, ta jà'a ndo kua'a' ma tiñu va'a. Ta endee ni koo yi, ikan ndisaa ma ña ni ndakan ndo nuu ma Tatái chi'in sivi̱, ni ni'i ndo yi. ");
INSERT INTO mza_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ña'a kùu ma tu'un ña tāchi̱ nuu ndo: na kuuni ndo nde'e ndo ma ta'an ndo. ");
INSERT INTO mza_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tuva ma ñivi ìyo ñuñivi xaani na ndè'e na ndo, na koto ndo ña ji'na yu'u kùu ma ra kīcha'a na xàani na kua maa ndo. ");
INSERT INTO mza_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Vati tu ndyo'o kùu ndo takua kùu ma ñivi ìyo ñuñivi, nduva'a ni kuuni na nde'e na ndo, takua kùuni na nde'e na ma ñivi na. Va tava yu'u kāchi̱n ndo tañu ma ndian ìyo ñuñivi, cha'a' yakan kùu yi ña ya'a ga xaani na ndè'e na ndo, ti tüva kuu ndo takua kùu ma ndian ìyo ñuñivi. ");
INSERT INTO mza_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na kuku'uni ndo ma ña kā'in te'en chi'in ndo niku: “Nï'iin ma ndian kùu musu, töve ka'nuga na kua ma ra kùu chito'o na.” Tu yu'u chāndikun na ña ka'ni na niku, juuni takan ni ja'a na chi'in ndo ndia. Ta tu jàchi'in na ma tu'un kà'in, juuni ni jachi'in na ma tu'un kà'an ndo ndia. ");
INSERT INTO mza_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ndisaa ma ña kà'in i'ya ni ja'a na yi chi'in ndo cha'a' ña nàkoto ndo yu'u, ti töve nàkoto na ma ra tāchi yu'u. ");
INSERT INTO mza_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tu yu'u töve nī kichi ka'in chi'in na ma tu'un i'ya, na töve kuati na niku. Va vitin na küa ka'an na ña tüva kuati na. ");
INSERT INTO mza_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Vati taku ma ndian xaani ndè'e yu'u, juuni xaani na ndè'e na ma Tatái ndia. ");
INSERT INTO mza_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tu yu'u töve nī ja'i ma tiñu ka'nu tañu na, ña nï'iin ñivi na küu ja'a yi, nï'iin kuati na töve niku. Va cha ndē'e na ma ña va'a jā'i, ta juuni xàani na nde'e na yu'u, chi'in ma ra kùu Tatái ndia. ");
INSERT INTO mza_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Takan kūu yi, ikan na chinu ma tu'un kà'an nuu ma tutu ley Ndioo ña kùmi na. Ta yakan te'en kà'an yi: “Xaani na ndè'e na yu'u cha'a' nï'iin nakuyi.” ");
INSERT INTO mza_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Va ora ni kichi ma Tati Ií Ndioo ña ni jandomani ndo, ña vàchi nuu ìyo ma Tatái jà'i, rakan kùu ra ña jàna'a ra ma ña ndaa, ta ora ni kichi ra ni katitu'un ra nuu ndo cha'i. ");
INSERT INTO mza_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ta nda ndyo'o, ni katitu'un ndo cha'i nuu ma ñivi, ti ndyo'o kùu ma ndian chàkunuu chi'i̱n, nda ma ora kīcha'i jà'i ma tiñu i'ya. ");
INSERT INTO mza_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Takan kà'in chi'in ndo, ikan na töve jaña ndo ña chìnuni ndo ma ña kà'in. ");
INSERT INTO mza_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tajan ma ndian judíu, ni jakunu na ndo ta'ii'iin nuu ìyo ma veñu'u na. Ta ni chaa iin kivi ña nda ndian ni kuuni ña chà'ni na ndo, ndiakan ni kuuni na ña iin tiñu va'a kùu ma ña jà'a na kuenda Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Takan ni ja'a na, ti takä'an nakoto na ma Tatái, ta ni yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Takan kà'in chi'in ndo vitin, ikan ma ora ni kuta'an ña ni kuu takan, na kuku'uni ndo ña cha kātitu'in nuu ndo cha'a' yi niku. ’Töve nī katitu'in ña'a chi'in ndo ora kīcha'a koi chi'in ndo ti endee chīyoi chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","’Va vitin chani ku'in nuu ìyo ma ra tāchi yu'u, ta ndyo'o nï'iin ndo töve chìkatu'un ndo nui ndanu kuà'in. ");
INSERT INTO mza_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Java tiaga kīcha'a nda'vi kùuni ndo ña kà'in takan chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ndicha va'a ña kà'in chi'in ndo, ti va'a ga kùu yi kuenda ndo ña na ku'in, vati tu töve ku'in, na küu kichi ma Tati Ií ña ni jandomani ña kòo ra chi'in ndo. Ta tu ku'in nuu ìyo ma Tatái, tajan ni tachi ndioi ma Tati ni tindee ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ta ora cha kīchaa ra ìyo ra chi'in ndo, tajan ni katitu'un kachin ra nuu ma ñivi ñuñivi nda yo kùu ndian jà'a kuati, ta nda yo kuà'an iti' ndaa nuu Ndioo, ta nda yo ni jakutuni ma Ndioo nuu. ");
INSERT INTO mza_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Takua ni ka'an ra nda yo jà'a kuati, cha'a' ña töve chìnuni na ma ña kà'in. ");
INSERT INTO mza_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ta ni ka'an ra nda yo kuà'an iti' ndaa, ti yu'u ni ku'in nuu ìyo ma Tatái, ta ndyo'o tüva ni nde'e ndo yu'u. ");
INSERT INTO mza_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ta ni ka'an ra nda yo ni jakutuni Ndioo kuati jà'a na, ti cha tüva ndakutiñu ma kui'na chà'nda tiñu ma ñuñivi i'ya. Cha jā'a ra kua kuu kùtunini ra yi. ");
INSERT INTO mza_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ìyo kua'a' ga ma ña kùuni̱ ka'in chi'in ndo, va ma vitin, ndyo'o na küu kundeeni anima ndo tu taso'o ndo yi. ");
INSERT INTO mza_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ta ora ni kichaa ma Tati Ií ndicha, maa ra kùu ra ña ni jana'a ra ma ña ndaa nuu ndo, ti töve ni ka'an ra chi'in ma tu'un ña jàndakuu maani yi; vati ma Tati Ií ikan ni ka'an ra ma ña kā'an Ndioo chi'in ra, ta ni ku'va ra ña koto na ma ña ni kuu. ");
INSERT INTO mza_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ta juuni ni jaka'nu ma Tati Ií Ndioo yu'u, vati ni ndaki'in ra ma tu'un kà'in, ta ni ku'va ra koto ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tandi'i ña ìyo nuu ma ra kùu Tatái, ña'i kùu yi ndia. Cha'a' yakan kùu yi ña kā'in ña tandi'i ña ìyo nui, ma Tati Ií, ni ndaki'in ra yi, ta ni ku'va ra yi koto ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Tiania tiempu kùmani, ta tüva ni nde'e ndo yu'u, va tiaga iti' nuu ni nde'e ndiko ndo yu'u, ti ni ku'in nuu ìyo ma Tatái ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Takan kūu, tajan ma ndra jàkua'a chi'in Jesuu, te'en kīcha'a ndra chìkatu'un ta'an ndra: ―¿Nayi kùuni ra ka'an ra ña kà'an ra takan? Kà'an ra chi'o ña tia tiempunia ni nde'o ra, ta tiaga iti' nuu, ni nde'e ndiko yo ra. Ta juuni kà'an ra ña cha'a' ña ni ku'un ra nuu ìyo ma Tatá ra kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Chïto nayi kùuni ra ka'an ra ña, “tia tiempunia, ta tüva ni nde'o ra”? Töve kùtuninio nayi kùuni ra ka'an ra ña kà'an ra takan ―kàti ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tajan Jesuu chā'a ndio ra kuenda ña kùuni ndra ndakatu'un ndra nuu ra, yakan va te'en nāka'an ra chi'in ndra: ―Yu'u kā'in, ña tichi tia kivinia, tüva ni nde'e ndo yu'u, ta tia iti' nuu, ni nde'e ndiko ndo yu'u. ¿A tu'un ikan kùu ma ña chìkatu'un ta'an ndo? ");
INSERT INTO mza_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ndicha va'a ña kà'in chi'in ndo ña, ndyo'o ni kuaku ndo, ta nda'vi ni kuuni ndo, va ma ñivi ñuñivi, sii ni kuuni na. Va vaji ndyo'o nda'vi ni kuuni ndo, ni sama ma kua kùuni ndo, ta ni kichi sii kuuni ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ma ora kàku se'e iin ña'a, chà'nda yi tichian, ti cha keta ma ora ni kàku yi. Va ora cha yā'a kāku ndio yi, jàña ndioan ña nda'vi kuunian, ti chisian, ña jākakuan se'an ma ñuñivi i'ya. ");
INSERT INTO mza_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ndyo'o, juuni takan nda'vi kùuni ndo vitin, va yu'u ni nde'e ndikoi ndo, ta ma ora ikan nduva'a ni kichi sii kuuni ndo chi'in anima ndo. Ta ma ña sii ikan, nï'iin na na küu namaa na yi nuu ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ma kivi ikan, nï'iin ndo na ndäkatu'un ga ndo nï'iin nakuyi nui. Ndicha va'a ña kà'in chi'in ndo, ña tandi'i ma ña chìkan ndo chi'in sivi̱ nuu ma Tatái, ni ku'va ra yi nuu ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nda vitin nï'iin ndyo'o takä'an ndakan ndo nï'iin nakuyi chi'in sivi̱ nuu ma Tatái. Na ndakan ndo yi, ta ni'i ndo yi, ikan na kichi sii kuuni ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ma tu'un ña kā'in chi'in ndo i'ya, kà'in yi chi'in ku'va. Va ni keta iin kivi ña tüva ni ka'in yi chi'in ku'va chi'in ndo. Vati ni ka'an kachin ndioi cha'a' ma Tatái nuu ndo. ");
INSERT INTO mza_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ma kivi ikan ni ndakan ndo iin nakuyi nuu ma Tatái chi'in sivi̱. Va yu'u töve ni janini̱ ma Tatái ña na ku'va ra ma ña chìkan ndo nuu ra. ");
INSERT INTO mza_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Vati ma Tatái kùuni ra nde'e ra ndo, cha'a' ña kùuni ndo nde'e ndo yu'u, ta cha'a' ña chìnuni ndo ña ra vàchi nuu ìyo Ndioo kùi ndia. ");
INSERT INTO mza_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kēi nuu ìyo ma Tatái, ta kīchai ma ñuñivi i'ya. Va vitin ni ndakoo ndikoi ma ñuñivi i'ya, ta ni ku'un ndikoi nuu ìyo ma Tatái ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tajan ma ndra jàkua'a chi'in Jesuu, te'en nāka'an ndra chi'in ra: ―Vitin ndicha, va tüva kà'un yi chi'in ku'va, ti kà'an kachiun yi. ");
INSERT INTO mza_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vitin va cha chà'a ndi kuenda ña cha chìtoun tandi'i nakuyi, ta töve chìniñu'u̱n yo ndakatu'un nuu̱n. Ta cha'a' yakan kùu yi ña cha chìnuni ndi ña ra vàchi nuu ìyo Ndioo kùu̱n ―kàti ndra chi'in Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―¿A cha chìnuni ndo vitin? ");
INSERT INTO mza_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Vitin va cha kēta ma ora, ta ndyo'o ni kuita kuati ndo, ta ni ndakoo ma'iin ndo yu'u. Va yöve ma'iini̱, kìndoo, ti ìyo ma Racha'nu Tatái chi'i̱n. ");
INSERT INTO mza_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Takan kà'in chi'in ndo, ikan na ni'i ndo naja kua koo vii ndo cha'a' ña ndò'iin ndo chi'i̱n. Ma ñuñivi i'ya, ndyo'o ni nde'e ndo tundo'o jà'a ma ñivi, va yu'u kà'in chi'in ndo ña na jandotayi va'a ndo ndo, vati yu'u cha jākanai ma ndian kànita'an chi'i̱n ma ñuñivi i'ya. ");
INSERT INTO mza_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Takan kūu ta ora chīnu kā'an Jesuu takan, tajan kāni'i ra nuu ra iti' andivi, ta kīcha'a ndio ra kà'an ra te'en: ―Yo'o Tatá, cha kēta ma kivi. Ta vitin na jaka'nu̱n yu'u ra kùu Se'un, ikan na jaka'nui ñu̱n ndia. ");
INSERT INTO mza_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Vati nuu yu'u ra kùu Se'un, chā'un ña na ka'ndai tiñu nuu tandi'i ma ñivi ìyo ñuñivi, ta juuni chā'un ña na kuu ja'i ña koo ndito ma tandi'i ma ñivi chā'un nui endeeni. ");
INSERT INTO mza_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ta ndisaa ma ndian nàkoto ñu̱n, yo'o ra uvanuu ña kùu Ndioo ndicha, chi'in yu'u ra kùu Jesucristu ra tāchiun, ni ni'i na nuu koo na endeeni chi'o. ");
INSERT INTO mza_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Endee jàka'nui ñu̱n nda ni kùuni chàkunui ma nuu ñu'u' ñuñivi i'ya, ti cha jāchinui tandi'i ma tiñu ña chā'un nui ña na ja'i. ");
INSERT INTO mza_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ta vitin yo'o Tatá, na jaka'nu̱n yu'u, ta na ku'vaun ña na koo ndikoi chi'un ma andivi, takua chīyoi chi'un antea ña tūvi ma ñuñivi niku. ");
INSERT INTO mza_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ma ndian chā'un nui, tañu ma ñivi ñuñivi, cha jāna'i nda ra kùu̱n nuu na. Ta ndiakan, ti ndian ìyo kuendaun kùu na niku, va yo'o chā'un na nui, ta vitin jàchi'in na ma tu'u̱n. ");
INSERT INTO mza_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ta juuni ma vitin cha chìto va'a na, ña tandi'i ma ña chā'un nui, maun kùu ma ra tāchi yi nui ña na ja'i yi. ");
INSERT INTO mza_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ta ma tu'un ña chā'un nui ña jàna'i nuu na, cha jāchi'in na yi. Ta juuni cha chā'a na kuenda ña maun kùu ma ra tāchi yu'u, ta vitin cha chìnuni na ña takan kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Yu'u chìkain ñamani nuu̱n ña na kumiun na, va töve chìkain ñamani nuu̱n cha'a' ma ndian töve chìnuni ìyo ma ñuñivi, vati yu'u chìkain ñamani nuu̱n ña na kumiun ma ndian chā'un nui, ti ñivi maun kùu na. ");
INSERT INTO mza_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tandi'i ma ña kùu ña'i, ña'un kùu yi, ta ma ña kùu ña'un, juuni ña'i kùu yi ndia. Ta ndiakan, jàna'a na nuu inga ñivi ña iin ra ya'a ka'nu kùi. ");
INSERT INTO mza_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Vati yu'u, töva ni koi ma ñuñivi i'ya, va ma ndra jàkua'a chi'i̱n, ni kindoo ndra koo ndra tiá ma ñuñivi i'ya, ta yu'u ni chai koi chi'un. Yo'o Tatá ra ya'a ií, na kumiun ndra chi'in ndatun, ikan na induku kuuni ndra chi'in ta'an ndra, takua induku kùuni̱ chi'un. ");
INSERT INTO mza_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta ora chīyoi chi'in ma ndra chā'un nui ma ñuñivi i'ya, ya'a ga kumi kuendai ndra chi'in ndatu ma siviun, ta nï'iin ndra nī jaña ndra ma iti' kuà'in. Uvanuu ma ra jāña ma iti̱', kùu ma ra kà'an ma tutu Ndioo ña ni naa niku. Ta takan kūu yi. ");
INSERT INTO mza_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Vitin va cha kuà'an ndikoi ma nuu ìyoun. Kà'in ma tu'un i'ya ora juuni yanga ìyoi ma ñuñivi i'ya, ikan na kichi sii va'a kuuni na, takua sii kùuni̱. ");
INSERT INTO mza_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yu'u jàna'i ma tu'u̱n nuu ndra, ta cha'a' yakan kùu yi ña ma ñivi ñuñivi ya'aga xaani na ndè'e na ndra, ti töve kùu ndra takua kùu ma ñivi ñuñivi, indukuni takua kùu yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Töve chìkain nuu̱n ña na tavani'un ndra ma ñuñivi i'ya, ti ma ña chìkain nuu̱n, kùu yi ña na kumiun ndra nuu ma kui'na. ");
INSERT INTO mza_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Vati takua yu'u, yöve ra ñuñivi kùi, ni ndrakan yöve ndra ñuñivi kùu ndra ndia. ");
INSERT INTO mza_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na ja'iíun ndra kuendaun cha'a' ma ña ndaa. Ta ma ña ndaa kùu ma tu'un ña kà'un. ");
INSERT INTO mza_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ma takua jā'un ña tāchiun yu'u tañu ma ñivi ñuñivi, juuni takan tāchi̱ ndra tañu ma ñivi ñuñivi ndia. ");
INSERT INTO mza_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ta cha'a' ndrakan kùu yi ña jā'íi̱ juuni mai, ikan ndrakan, na ku'ií ndra jà'a ma tu'un ndaa. ");
INSERT INTO mza_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Va yöve uvaa cha'a' ndrakan ni kùu yi ña chìkain ñamani nuu̱n, vati juuni chìkain ñamani nuu̱n cha'a' ma ndian ni chinuni ma tu'in iti' nuu jà'a ndra. ");
INSERT INTO mza_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta juuni chìkain ñamani nuu̱n ña na ndo'iin na chi'in ta'an na, yo'o Tatá, takua ndō'iun chi'i̱n, ta yu'u chi'un, ikan na koto kachin ma ndian ìyo ñuñivi i'ya, ña maun kùu ma ra tāchi yu'u. ");
INSERT INTO mza_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yu'u chā'i tandi'i ma ña ka'nui, ña chā'un nui, nuu na, ikan na ndo'iin na, ta kùu na iin ñivini chi'in ta'an na, indukuni ma takua kùu̱n chi'i̱n ña kùu na iin ñivini ndia. ");
INSERT INTO mza_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yu'u ìyoi chi'in na, ta yo'o chi'i̱n, ikan na kuu ndicha na iin ñivini, ta takan ku'va ma ñivi ñuñivi kuenda, ña maun kùu ma ra tāchi yu'u. Vati juuni ya'a kùuniun nde'un na takua kùuniun nde'un yu'u. ");
INSERT INTO mza_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Yo'o Tatá, maun kùu ma ra chā'a na nui, ta kùuni̱ ña na koo na chi'i̱n ma nuu ni ku'in koi, ikan na nde'e na ña ra ka'nu kùi jā'un, vati takani kùuniun nde'un yu'u ma antea ña jātuviun ma ñuñivi niku. ");
INSERT INTO mza_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yo'o Tatá, ra ya'a ndaa, ma inga ndian ìyo ñuñivi i'ya, töve nàkoto na ñu̱n, va yu'u nàkotoi ñu̱n, ta juuni ñivi i'ya cha chìto na ña maun kùu ma ra tāchi yu'u ndia. ");
INSERT INTO mza_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ta yu'u chà'i ña na nakoto na nda ra kùu̱n, ta takan ni ja'i yi iti' nuu ndia, ikan indukuni tava kùuniun nde'un yu'u, ta takan kuuni na nde'e na ta'an na. Takan jā'i, ikan na kuu koi chi'in na endeeni ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Takan kūu ta ora chinu kā'an Jesuu takan, tajan kēe ndio ra kuà'an ra chi'in ma ndra jàkua'a chi'in ra inga chiyo ma yuvi ña nàni Cedrón. Ta ora chāa ndra nuu tāchi yutun tata, ta ikan kī'vi ndra kuà'an ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ta nda ma Juda, ra xìkoña'a cha'a' Jesuu, juuni nàkoto ra ma ikan ndia, ti kua'a' cha'a' cha kūti'vi Jesuu ikan chi'in ma ndra jàkua'a chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ta takan kūu yi ña chāa ma Juda chi'in kua'a' va'a jandaru, ta uvi uni ma ndra jandaru ña kùmi ma veñu'u, ña tāchi ma ndra kuxini nuu sutu, chi'in ma ndra fariseu. Tandi'i ndrakan nda'a ndra ñu'ú nda'a', chi'in machiti, ta nduva. ");
INSERT INTO mza_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Va takua Jesuu cha chìto ra tandi'i ma ña ni ta'an ra, yakan va kēta ra, ta te'en chīkatu'un ra nuu ndra: ―¿Yo nànduku ndo? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ta ndrakan te'en nāka'an ndra chi'in ra: ―Nànduku ndi Jesuu ra ñuu Nazaret ―kàti ndra. Ta Jesuu te'en naka'an ra: ―Yu'u kùi ―kàti ra. Ta ma Juda ra xìkoña'a cha'a' Jesuu juuni ndaa ra ma ikan chi'in ndra ndia. ");
INSERT INTO mza_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ta ora nāka'an Jesuu ña; “Yu'u kùi”, ta chīkachata ndra iti' chata, ta ndūva ndra nuu ñu'u'. ");
INSERT INTO mza_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tajan Jesuu te'en chīkatu'un tuku ra nuu ndra: ―¿Yo nànduku ndo? ―kàti ra. Ta ndrakan te'en nāka'an ndra: ―Nànduku ndi Jesuu ra ñuu Nazaret ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tajan Jesuu te'en nāka'an ra: ―Cha kā'in chi'in ndo, ña yu'u kùi. Tu yu'u kùu ma ra nànduku ndo, na jaña ndo ma ndra jàkua'a chi'i̱n, ta tìin ndo yu'u ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Takan kūu yi, ikan na chinu ma tu'un kā'an Jesuu ña te'en kà'an: “Ma ndian chā'a ma Tatái nui, töve nī kenaa nï'iin na.” ");
INSERT INTO mza_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tajan ma Simón Petu', ti ndà'a ra iin machiti, ta tāva ra yi ma tichi vena ra, ta chā'nda ra iin chiyo so'o ma ra nàni Malco, ma chiyo kua'a ra. Ta ra'ya ti ra kùu musu ma ra kuxini nuu sutu kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tajan Jesuu te'en nāka'an ra chi'in ma Petu': ―Na ti'i va'un ma machitiun ma tichi venaun. Vati tu Tatái chā'a ra ña na nde'i tundo'o, ¿a töve ìyo tu'vai ña nde'i tundo'o i'ya?, kùuni ndo ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tajan ma ndra jandaru, chi'in ma ra kuxini nuu ndra, ta chi'in ma ndra kùu jandaru ma ndian judíu, tīin ndra Jesuu, ta chū'ni ndra nda'a' ra. ");
INSERT INTO mza_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ta chāndaka ji'na ndra ra nuu ma ra nàni Anás, raka'nu ma ra nàni Caifás. Ma kuiya ikan, Caifás kùu ra ma ra kuxini nuu sutu. ");
INSERT INTO mza_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ta juuni ma Caifás i'ya, kùu ra ña kātitu'un nuu ma ndian judíu, ña va'aga ña na kuvi iin ra'iini cha'a' ma ñuu na, kāti ra. ");
INSERT INTO mza_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ma ra nàni Simón Petu', tāndikun ra kuà'an ra chata Jesuu, chi'in inga, ra takani nàkoto ma ra kuxini nuu sutu ra, kī'vi ra chi'in Jesuu, ma nuke'e ve'e ma ra kuxini nuu sutu, ");
INSERT INTO mza_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","va ma Petu', kīndoo ra ma chata kora. Cha'a' yakan kùu yi ña kēe ma ra nàkoto ma ra kuxini nuu sutu. Ta chāka'an ra chi'in ma ña kùmi ma yu'u kora, ña na ku'va ña kì'vi ma Petu', kàti ra. Ta jāya'a ña ra iti' tichi. ");
INSERT INTO mza_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tajan ma ña kùmi ma yu'u kora, te'en kīcha'a chìkatu'an nuu Petu': ―¿A yöve iin ra chàkunuu chi'in ra tīin ndra ikan kùu̱n? ―kàtian chi'in ra. Ta Petu' te'en nāka'an ra: ―Yöve yu'u kùi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Va takua ya'a ga vichin jà'a yi, yakan va ma ndra kùu musu, chi'in ma ndra jandaru, jāta'an ndra ñu'ú, ta tùmi ndra yi, ti ya'a vichin jà'a yi. Ta nda ma Petu', juuni ndaa ra tùmi ra yi chi'in ndra ndia. ");
INSERT INTO mza_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Takan kūu tajan ma ra kuxini nuu sutu, chīkatu'un ra nuu Jesuu, nda ndra kùu ma ndra chàkunuu chi'in ra, ta nda va kùu ma ña jàna'a ra. ");
INSERT INTO mza_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tajan Jesuu te'en nāka'an ra chi'in ra: ―Yu'u chàkunui jàna'i ma nuu tuvi ñivi, ta juuni jàna'i nuu ma ndian judíu ma tichi veñu'u kuati na, ta ma tichi veñu'u ka'nu na nuu kùti'vi ndisaa na ndia. Yakan va, yu'u töve chàta'ani̱ jana'a xe'i nuu ma ñivi. ");
INSERT INTO mza_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ta chïto naja chìkatu'u̱n nui? Na ndakatu'u̱n nuu ma ndian chīni ma ña jāna'i, ta ndiakan na katitu'un na nuu̱n ma ña jāna'i nuu na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ta ora chīnu kā'an Jesuu takan, ta iin ma ndra jandaru ña kùmi ma veñu'u, kāni ra nuu ra, ta te'en nāka'an ra chi'in Jesuu: ―¿Ta naja kà'un takan chi'in ma ra kuxini nuu sutu? ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ta Jesuu te'en nāka'an ra chi'in ra: ―Tu yu'u kā'in iin tu'un ña töve va'a, na ka'un nui nda cha'a' kùu yi. Va tu ma ña kā'in, ña va'a kùu yi, ¿nda cha'a' kāniun yu'u tuva takan? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tajan ma ra nàni Anás tāchi ra, ña na ku'ni ndra Jesuu, ta tāchi ndio ra ra kuà'an ra nuu ma ra kuxini nuu sutu ña nàni Caifás. ");
INSERT INTO mza_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Takan kūu ta tava ma Petu' juuni ndaa ra tùmi ra ñu'ú ma ikan, yakan va te'en kīcha'a ndiko ndra chìkatu'un ndra nuu ra: ―¿A yöve yo'o, kùu ma ra chàkunuu chi'in Jesuu? ―kàti ra chi'in ra. Ta ma Petu' te'en nāka'an ra: ―Yöve yu'u kùi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tajan iin ma ndra jà'a tiñu nuu ma ra kuxini nuu sutu, ra nàkoto ma ra chā'nda ma Petu' so'o, te'en kīcha'a ra chìkatu'un ra nuu ra: ―¿A yöve yo'o kùu ma ra ndē'i chi'in ra ma nuu kàa yutun tata? ―kàti ra chi'in Petu'. ");
INSERT INTO mza_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ta ma Petu' nāka'an ndiko ra ña töve nàkoto ra ra, ta ma ora ikani nānda'yu ma lo'o. ");
INSERT INTO mza_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Takan kūu tajan kēe ndio ndra chi'in Jesuu ma ve'e Caifás, ta chāndaka ndra ra ma vetiñu nuu tà'nda tiñu. Va takua ma ora cha kūndichin kùu yi, yakan va ma ndra judíu, nī kuuni ndra kì'vi ndra tichi ma vetiñu, koto ndokini ndra, ta na küa kuxini ndra ma ora ìyo ma viko Pakua, kùuni ndra. ");
INSERT INTO mza_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tajan Pilatu kēe ra ma tichi vetiñu, ta te'en nāka'an ra chi'in ndra: ―¿Nda cha'a' kùu yi ña tìsokuati ndo ra'ya? ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ta ndrakan te'en nāka'an ndra chi'in ra: ―Töve na ja'a ndi ña kichi ndaka ndi ra nuu̱n, tu yöve ra jà'a kuati kùu ra ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tajan Pilatu te'en nāka'an ra chi'in ndra: ―Na kundaka ndo ra ku'un ndo, ta na jakutuni ndo ma kuati ra, takua kà'an ma tutu ley maa ndo ―kàti Pilatu. Tajan ma ndra judíu te'en nāka'an ndra chi'in ra: ―Va taku ndyu'u ndian judíu, nï'iin ñivi na küu ka'ni ndi na ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Takan kūu yi ña jāchinu Jesuu ma ña kā'an ra, cha'a' ma naja kua ìyo yi ña kuvi ra. ");
INSERT INTO mza_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Takan kūu tajan Pilatu kī'vi ndiko ra ma tichi vetiñu nuu chà'nda ra tiñu, ta kāna ndio ra ma Jesuu, ta te'en kīcha'a ra chìkatu'un ra nuu ra: ―¿A yo'o kùu ma rey ra chà'nda tiñu nuu ma ñivi judíu? ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ta Jesuu te'en kīcha'a chìkatu'un ra nuu Pilatu: ―¿A ña chànini maun kùu ma ña chìkatu'u̱n nui, a kà'an na takan cha'i nuu̱n, yakan va chìkatu'u̱n yi nui? ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ta ma Pilatu te'en nāka'an ra chi'in Jesuu: ―¿A chàniniun ña ra judíu kùi, yakan va kà'un takan? Ma ndian ñuu̱n, chi'in ma ndra kuxini nuu sutu, ndrakan kùu ma ndra kīchi ndaka ñu̱n nui. ¿Nayi jā'un? ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ta Jesuu te'en nāka'an ra: ―Ma nuu ni koi, yöve ma ñuñivi i'ya kùu yi. Ti tu ma nuu ni koi kùu yi ma ñuñivi i'ya, ni kanita'an ma ndra chàkunuu chi'i̱n cha'i, chi'in ma ndian judíu, ta na kü'va ndra yu'u nuu na. Va ma nuu ni ka'ndai tiñu yöve ma ñuñivi i'ya kùu yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tajan ma Pilatu te'en nāka'an ra chi'in Jesuu: ―¿A yo'o kùu ma rey tuva takan? ―kàti Pilatu. Tajan Jesuu te'en nāka'an ra chi'in ra: ―Ndicha ña kùi rey, ma takua kà'un. Vati yu'u kākui ma nuu ñu'u' ñuñivi i'ya kuenda ña katitu'in ma tu'un ndaa. Ta tandi'i ma ndian jàchi'in ma tu'un ndaa i'ya, juuni tàso'o na ma ña kà'in ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tajan Pilatu te'en chīkatu'un ra nuu ra: ―¿Ta nayi kùu ma ña ndaa? ―kàti Pilatu. Ta ora cha ya'a ña chīkatu'un Pilatu nuu Jesuu, ta kēe ndiko ra ma nuu chà'nda ra tiñu, ta te'en chāka'an ndiko ra nuu ma ndian judíu: ―Yu'u töve nàta'in nï'iin kuati ra'ya. ");
INSERT INTO mza_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Va tava ndyo'o, cha iin chìkan ndo nàni kuiya ña na jañai iin ra indii vekaa, ma ora ìyo ma viko Pakua. Yakan va, ¿a kùuni ndo ña na jañai ma rey ma ndian judíu? ―kàti Pilatu chi'in na. ");
INSERT INTO mza_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tajan tandi'i ndio ma ndian judíu, te'en kīcha'a ndiko na kanachaa ni'i na: ―¡Na küuni ndi ña jañaun rakan! ¡Na jañaun ma Barrabás! ―kàti na. Ta ma Barrabás, ti iin ra su'u kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Takan kūu tajan tāchi ndio Pilatu ma ndra jandaru ra, ña na tiin ndra Jesuu, ta kani ndra ra. ");
INSERT INTO mza_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tajan ma ndra jandaru jāva'a ndra iin korona iñu, ta jūndii ndra yi xini Jesuu, ta jāku'un ndra iin ja'ma color ndaa ra. ");
INSERT INTO mza_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tajan chājayatin ndio ndra ndra nuu ndaa Jesuu, ta te'en nāka'an ndra chi'in ra: ―¡Na koo endeeni ma rey chà'nda tiñu nuu ma ndian judíu! ―kàti ndra. Ta kāni ndra ma nuu ra. ");
INSERT INTO mza_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tajan ma Pilatu kēe ndiko ra ma nuu chà'nda ra tiñu, ta te'en nāka'an ra chi'in ndra: ―Na nde'e ndo, ña töve nī nata'in nï'iin ma kuati ra, yakan va tāvai ra nuu ndo, ikan na ku'va ndo kuenda ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tajan kēta ndio Jesuu, ña jùndii xini ra ma korona iñu, ta ñù'u ra iin ja'ma color ndaa. Ta Pilatu te'en nāka'an ra chi'in ndra: ―¡I'ya ndaa ra! ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ta ora ndē'e ma ndra kuxini nuu sutu ra, chi'in ma ndra jandaru ña kùmi ma veñu'u ra, ta te'en kīcha'a ndra kànachaa ni'i ndra: ¡Na kuvi ra nuu kruu! ¡Na kuvi ra nuu kruu! ―kàti ndra. Ta Pilatu te'en nāka'an ra chi'in ndra: ―Va'ani, na kundaka ndo ra, ta ka'ni maa ndo ra nuu kruu, ti yu'u töve nī nata'in nï'iin kuati ra ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Va ma ndian judíu te'en nāka'an na chi'in ra: ―Ndyu'u, ìyo iin tutu ley nuu ndi, ña kà'an yi, ña ìyo yi ña kuvi ra cha'a' ña jàndaku ra ra Se'e Ndioo. ");
INSERT INTO mza_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ta ora chīni Pilatu ña kā'an ma ndra judíu takan, ta tiaga yū'vi ra. ");
INSERT INTO mza_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tajan chāka ndiko ra ma Jesuu ma tichi vetiñu nuu chà'nda ra tiñu, ta te'en chīkatu'un ra nuu Jesuu: ―¿Ta yo'o ndanu kīchiun? ―kàti Pilatu. Va Jesuu töve nī ka'an ra nï'iin yu'u ra chi'in Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tajan Pilatu te'en nāka'an ra chi'in Jesuu: ―¿Ta naja töve kà'un yu'i? ¿A töve chìtoun ña cha'a' ma tiñu ndisoi, kùu tachi̱ ñu̱n ña na ka'ni na ñu̱n nuu kruu, ta juuni kùu ka'in ña na jaña na ñu̱n ndia? ―kàti Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ta Jesuu te'en nāka'an ra chi'in ra: ―Na küu jakutuniun nï'iin nakuyi chi'i̱n cha'a' ma tiñu ndisoun, tu yöve ma Ndioo ra ìyo nuu sukun, kùu ma ra chà'a yi nuu̱n. Ta cha'a' yakan kùu yi ña ka'nuga kuati ma ndra chāndaka yu'u nuu̱n, kua maun ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Takan kūu ta nda ma ora ikan, kīcha'a Pilatu, nànduku ra naja kua jà'a ra, ta jàña ra Jesuu, va ma ndian judíu, te'en kānachaa ni'i ndiko ndra nuu ra: ―¡Tu jàñaun ra, na yöve amigu̱n kùu ma rey chà'nda tiñu ñuu Roma tuva takan, ti nda ndra nikuuni ña jàndaku ndra ndra ña kùu ndra rey, nduva'a xaani ma rey ikan ndè'e ra ndra! ―kàti ndra chi'in Pilatu. ");
INSERT INTO mza_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ta ora chīni ma Pilatu ña kā'an ndra takan, tajan tāchi ndio ra ma ndra jandaru ña na tava ndra Jesuu ma nuke'e, tajan chākunandi ndio ra ma tayu nuu jàndondaa ra kuati, ña chi'in tu'un hebreu nàni yi, Gabata, ta ma tu'un i'ya kùuni yi ka'an yi, Nuu Tà'nda Tiñu. ");
INSERT INTO mza_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ta iin kivi antea ña kuta'an ma viko Pakua, ìyo yi a kachuvi ndaa najaka. Tajan Pilatu te'en nāka'an ra chi'in ma ndra judíu: ―¡I'ya ndaa ma ra kùu rey ndo! ―kàti Pilatu chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Va ma ndra judíu te'en kānachaa ni'i ndra: ―¡Na kuvi ra! ¡Na kuvi ra! ¡Na takaun ra nuu kruu! ―kàti ndra. Ta Pilatu te'en chīkatu'un ra nuu ndra: ―¿A ìyo yi ña ka'ni̱ ma ra kùu rey ndo nuu kruu ña kà'an ndo takan? ―kàti Pilatu. Va ma ndra kùxini nuu sutu, te'en nāka'an ndra chi'in ra: ―¡Uvanuu ni rey ndyu'u ìyo, ta rakan kùu ra ma ra chà'nda tiñu ma ñuu Roma! ―kàti ma ndra kùxini nuu sutu. ");
INSERT INTO mza_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ta takan kūu yi ña jāya'a ndio Pilatu, ma Jesuu nda'a' ndra, ña na takaa ndra ra nuu kruu, ta ndàka ndio ndra ra kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tajan ndiso ndio Jesuu ma kruu, kēe ra kuà'an ra chi'in ndra, ma nuu kà'an na ña nàni Yuku Iki Xini Ndian Chī'í. Ta chi'in tu'un hebreu nàni yi, Gólgota. ");
INSERT INTO mza_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ikan tākaa ndra ma Jesuu nuu kruu, chi'in inga uvi ndra, iin ndra te'en tikan xiin ra, ta maa ra, va kìndoo ma'ñu. ");
INSERT INTO mza_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tajan Pilatu tāa ra iin tu'un ma nuu vitu, ta tāchi ra ña na kutatuu ma jandaru yi xini kruu ma Jesuu, ta ma tu'un ikan te'en kà'an yi: “Ra'ya kùu Jesuu ra ñuu Nazaret, ta rey, ra chà'nda tiñu nuu ma ndian judíu”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kua'a' ma ndian judíu jākua'a na ma tu'un ikan, ti ma kruu nuu tākaa ma Jesuu kìndoo yi iti' yu'u ñuu, ta ma tu'un ikan ndiso yi chi'in tu'un hebreu, latinu ta griegu. ");
INSERT INTO mza_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yakan va ma ndra kuxini nuu sutu, ña ìyo kuenda ma ndian judíu, te'en nāka'an ndra chi'in Pilatu: ―Töve va'a jā'un ña taun: “Rey ra chà'nda tiñu nuu ndian judíu.” Va'a ga ña na taun: “Ra'ya kùu ma ra kà'an ña kùu ra rey ra chà'nda tiñu nuu ma ndian judíu.” Takan taun ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ta ma Pilatu te'en nāka'an ra chi'in ndra: ―Ma ña cha tāi, tüva ni samai yi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ta ora cha yā'a ña tākaa ma ndra jandaru ma Jesuu nuu kruu, ta ndāki'in ndra ma ja'ma ra, ta jāchaa ndra yi nuu kumi grupu, iin yi kuenda ii'iin ndra. Ta juuni ndāki'in ndra ma ja'ma ìsukun Jesuu, va takua töve nuu ñùta'an yi, ti iin kuuni yi yakan va nī kuu nakaa yi. ");
INSERT INTO mza_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tajan te'en kīcha'a ma ndra jandaru nàtu'un ta'an ndra: ―Na jänakaa yo yi, va'a ga ña na kusiki yo yuu kuati, ta nda yo jakanaa, ta rakan ndàki'in yi ―kàti ndra. Takan kūu yi, ikan na jachinu ma tutu Ndioo nuu kà'an yi te'en: Juuni maa ni ndra kùu ndra ña nāta'vi ndra ma ja'mai, ta chāsiki ndra yuu kuati nde'o yo jakanaa ma ja'ma isukuin. Takan jā'a ma ndra jandaru. ");
INSERT INTO mza_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yatini xiin ma kruu nuu tàkaa Jesuu, ikan ndaa ma ma'á ra, chi'in ña ta'an ña, ta Ndiya ñasi'i ra nàni Cleofas, chi'in ma Ndiya Magdalena. ");
INSERT INTO mza_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ta ora ndē'e ndio Jesuu ma ma'á ra, chi'in iin ra chàkunuu chi'in ra, ña ya'a kùuni ra nde'e ra, ta Jesuu te'en nāka'an ra chi'in ma ma'á ra: ―Yo'o ma'á, chiña ndaa ma ra ni kuu se'un ―kàti ra chi'in ña. ");
INSERT INTO mza_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ta Jesuu te'en nāka'an ra chi'in ma ra chàkunuu chi'in ra: ―Chiña ndaa ma ña kuu ma'un ―kàti ra chi'in ma ra ndaa chi'in ma'á ra. Ta nda ma ora ikan, ndāki'in ra ña, ña kùu ma'á ra ña. Ta kuà'an ña chi'in ra ma ve'e ra. ");
INSERT INTO mza_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Takan kūu va tava cha chìto Jesuu ña chīnu ma tiñu vàchi ra, yakan va ora yā'a ña kūu takan, ta te'en nāka'an ra, ikan na chinu ña kà'an ma tutu Ndioo: ―Ya'a natii̱ takuii ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ta takua ma ikan ndaa iin kasitu ña chitu yi chi'in ma vinu iya, tajan nānduku ndra iin ña xa'ma, ta jākuti ndra yi chi'in ma vinu ikan, ta chū'ni ndra yi punta ma iin yutun kani ña nàni hisopo, ta jāyatin ndra yi yu'u Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ta ora cha yā'a chī'i Jesuu ma vinu uva iya, ta te'en nāka'an ndio ra: ―Cha chìnu ndisaa ma ña kà'an nuu tutu Ndioo vitin ―kàti ra. Ta ora chīnu kā'an ndio ra takan, tajan chūtakandee ndio ma xini ra, ta chī'í ra. ");
INSERT INTO mza_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iin kivi antea ña kūta'an ma viko Pakua, kūu yi ma takan. Yakan va ma ndian judíu töve kùuni na ña kindoo ma kuñu ma ndian ndií nuu kruu ma kivi ña nindee na, ti ma kivi ikan, iin kivi ya'a ka'nu kùu yi kuenda na. Tajan ndiakan chīkan na ñamani nuu Pilatu ña na tachi ra iin ma ndra jandaru ra, ña kuka'nu ndra si'in ma ndra ka'ìin nuu kruu, ta jànuu ndra ma ñunda'yu ndra. ");
INSERT INTO mza_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tajan ma jandaru, chā'an ndra, ta chā'nu ndra si'in ma ra nunuu, ta ikan jan chāka'nu ndra si'in inga ma ra tàkaa xiin Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Va ora cha jāyatin ma ndra jandaru ndra nuu tàkaa Jesuu, ta ndē'e ndra ña cha chī'í ra. Yakan va tüva nī kuuni ndra ka'nu ndra ma si'in ra. ");
INSERT INTO mza_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Va iin ma ra jandaru kūchi ra ma kaa xaan nda'a' ra iin chiyo xiin ma Jesuu, ta ma ora ikani kēe kua'a' nií ra chi'in takuii. ");
INSERT INTO mza_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ma ra nātu'un ma tu'un i'ya, kùu ma ra ndē'e ma ña kūu, ta ña ndicha kùu ma ña kà'an ra. Ta tu ndicha ña takan kùu yi, na chinuni ndo yi ndia. ");
INSERT INTO mza_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Takan kūu yi, ikan na chinu ma tu'un ña te'en kà'an nuu ma tutu Ndioo: “Töve ni ta'nu nï'iin iki ra”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ta ìyo inga tuku nuu ma tutu Ndioo ña kà'an yi te'en: “Ni nde'e na ma ra kūchi na kaa xiin”, kàti yi. ");
INSERT INTO mza_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Takan kūu ta ora yā'a ndisaa ma ña'a, tajan ma ra ñuu Arimatea ña nàni Kusé, ra chìnuni tu'un Jesuu, va chìto maani ra yi, jà'a ña ndasii ra nde'e ra ma ndian judíu. Rakan chìkan ra ñamani nuu Pilatu ña na ku'va ra ñunda'yu ma Jesuu nuu ra. Ta ma Pilatu chā'a ra ña na kuki'in ra yi. Yakan va ma Kusé kēe ra kuàki'in ra ma ñunda'yu Jesuu, ta ndiso ra yi kuà'an ra. ");
INSERT INTO mza_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ta juuni chāa ma ra nàni Nicodemo, ra chā'an chāka'an chi'in Jesuu ma chanikuaa niku, ña nda'a ra iin oko uchi kilu ma yukú ya'a xiko cha'an ña cha jàkanuu ra. Ta yuku ikan nàni vu mirra chi'in áloes. ");
INSERT INTO mza_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Takan kūu ña ma Kusé chi'in Nicodemo, kī'in ndio ndra ma ñunda'yu Jesuu, ta kāva ndra yi chi'in ma ja'ma kuichin ña jākuti ndra ma yukú xiko ña cha jākanuu, ma takua ìyo ma costumbre ma ndian judíu, ma ora kùchi na ma ndian chī'í. ");
INSERT INTO mza_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ta yatini ma nuu chī'í ma Jesuu nuu kruu, ìyo iin kora nuu kàa kua'a' yutun chà'a chiti kacho, ta ma ikan ti ìyo iin nuu ñaña ña já kūva'a, nuu takä'an kuchi na nï'iin ñivi. ");
INSERT INTO mza_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ikan kūchi ndra ma ñunda'yu Jesuu, vati ma nuu ñaña ikan, yatin tiaga kìndoo yi, ta cha ni keta ma kivi nindee ma ndian judíu ndia. ");
INSERT INTO mza_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ma kivi nunuu nuu kìcha'a ma jamana, ma Ndiya Magdalena, na'a va'a kēe ña chānde'an nuu ñaña ma Jesuu ma ora juuni naa ga. Ta ikan ndē'an ña tüva ndàsi ma yuu ka'nu yu'u ma yavi nuu ìyo ma nuu ñaña. ");
INSERT INTO mza_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tajan endee chīnu ña kuà'an ña nuu ndaa ma Simón Petu', chi'in inga ma ra jàkua'a chi'in Jesuu, ra ya'a ga kùuni ra nde'e ra, ta te'en nāka'an ña chi'in ndra: ―Cha ndāki'in na ma ñunda'yu ma Racha'nu Jesuu ma nuu ñaña nuu kùchi ra, ta töve chìto ndi ndanu chāndaka na yi ―kàti ña chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tajan ma Petu' chi'in inga ma ra jàkua'a chi'in Jesuu, kēe ndra kuànde'e ndra ma nuu ñaña ma Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ta ninduvi ndra induku va'a kēe ndra kàcha'an ndra, uvaa ña ma inga ra ni'i ga chīnu ra, yakan va ji'naga ra chāa ma nuu ñaña kua ma Petu'. ");
INSERT INTO mza_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tajan ndē'e nuu ra ma tichi yavi nuu kūchi ma Jesuu, ta ikan ndē'e ra ma ja'ma kuichin ña kāva ma Jesuu, va töve nī kuuni ra ki'vi ra tichi yi. ");
INSERT INTO mza_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ta nunuuni tajan chāa ndio ma Simón Petu', ta kī'vi ra ma nuu kūchi ma Jesuu, ta juuni ndē'e ra ña kàndoyo ma ja'ma kuichin ña kāva ma Jesuu ma ikan ndia. ");
INSERT INTO mza_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ta juuni ndē'e ra ña kàndoyo ma ja'ma ña kāva xini ra, va töve iin kandoyoni yi chi'in ma ja'ma ña kāva ma Jesuu, vati kàndoyo locho siin yi. ");
INSERT INTO mza_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tajan inga ma ra chàkunuu chi'in Jesuu, ra chāa ma nunuu, kī'vi ndio ra tichi yi, ta ikan ndē'e ra ma ña kūu, ta chīnuni ra. ");
INSERT INTO mza_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Takan jā'a ndra ti takä'an kutunini ndra ña kà'an ma tutu Ndioo, ña Jesuu ìyo yi ña nataku ra tañu ma ndian ndií. ");
INSERT INTO mza_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Takan kūu tajan ninduvi ma ndra chàkunuu chi'in Jesuu kuànu'u ndiko ndra ma nuu ìyo ve'e. ");
INSERT INTO mza_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Va ma Ndiya kīndoan iti' chata ma nuu ñaña, ña chàkuan ma xiin yi. Ta ma ora chàkuan ndaa ña, ta chūtaka ndee ña, ta ndē'e ni'ni' ña tichi ma yavi nuu ñaña. ");
INSERT INTO mza_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ta ikan ndē'an uvi ta'an ma tati ña jàtiñu kuenda Ndioo, ña ñù'u yi ja'ma kuichin, nàndi yi ma nuu chūndii ma ñunda'yu Jesuu: iin yi nàndi ma iti' chiyo xini ra, ta inga yi nàndi ma iti' chiyo cha'a ra. ");
INSERT INTO mza_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Takan kūu, tajan ma tati ikan, te'en kīcha'a yi chìkatu'un yi nuu ma Ndiya: ―Yo'o ñacha'nu, ¿ta naja chàku̱n? ―kàti yi chi'an. Ta ma Ndiya te'en nāka'an ña: ―Chàkui ti ma Racha'nu chito'i, töve chìtoi ndanu chāndaka na ra ―kàti ña. ");
INSERT INTO mza_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ta ora chīnu kā'an ña takan, ta chīkokanian ndē'an inga iti', ta ikan ndē'an ma Jesuu, va töve nī cha'a' ña kuenda ña Jesuu kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tajan ma Jesuu te'en kīcha'a ra chìkatu'un ra nuan: ―Yo'o ma'á, ¿ta naja chàku̱n?, ¿Ta yo nànduku̱n? ―kàti ra chi'an. Va takua yakan chānini ña, ña ra jàkuenda ma nuu kàa yutun ikan kùu ra, yakan va te'en nāka'an ña chi'in ra: ―Yo'o racha'nu, tu yo'o ndāki'in ma kuñu Jesuu, na katitu'u̱n nui ndanu chāndakaun yi, ta kuki'i̱n yi ―kàtian. ");
INSERT INTO mza_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tajan Jesuu te'en nāka'an ra chi'an: ―¡Ndiya! ―kàti ra chi'an. Ta ora nākotoan ña tati Jesuu kùu yi, ta cha jāyatian ña nuu ra, ta te'en nāka'an ña chi'in ra: ―¡Raboni! ―ña kùuni yi ka'an yi Matru chi'in tu'un hebreu. ");
INSERT INTO mza_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tajan Jesuu te'en nāka'an ra chi'an: ―¡Na jañaun yu'u! Vati juuni takä'an kundai nuu ìyo ma Tatái. Va kùuni̱ ña na kukatitu'u̱n nuu ma ndian chìnuni tu'in, ña yu'u, ni kundai nuu ìyo ma ra kùu Tatái, ta ma Ndioi, ra juuni kùu Tatá ndo, ta Ndioo ndo ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tajan ma Ndiya Magdalena kēe ndioan kuàkatitu'an nuu ma ndian chìnuni tu'un ra, ña ndē'an ma Jesuu. Ta juuni kātitu'an nuu na ma tu'un ña kāti ra nuan ndia. ");
INSERT INTO mza_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ta ora chanikuaa, ma kivi nunuu nuu kìcha'a ma jamana; juuni ma kivi ikan, ma ndra jàkua'a chi'in Jesuu kūti'vi ndra iin tichi ve'e, ta chāsi kutu ndra yi cha'a' ña ndasii ndra ma ndian judíu. Ma ora ikan chāa Jesuu ma nuu ka'ìin ma ndra jàkua'a chi'in ra, ta chākundaa ra ma'ñu ndra, ta te'en kāña'a ra chi'in ndra: ―¡Na vii koo ndo! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ta ora chīnu kā'an ra takan, tajan jāna'a ra ma nda'a' ra nuu ndra, chi'in ma xiin ra. Ta nduva'a chīsii ndra ña ndē'e ndiko ndra ma Racha'nu. ");
INSERT INTO mza_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tajan Jesuu te'en nāka'an ndiko ra chi'in ndra: ―¡Na vii koo ndo! Vati takua jā'a ma ra kùu Tatái ña tāva ra tiñu nui, juuni takani tàvai tiñu nuu ndo, ikan na jana'a ndo takua jāna'i nuu ndo. ");
INSERT INTO mza_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ta ora chīnu kā'an Jesuu takan, ta tīvi ndio ra tati chata ndra, ta te'en nāka'an ra chi'in ndra: ―Na koo ma Tati Ií Ndioo chi'in ndo. ");
INSERT INTO mza_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nda ndyo'o jàka'nuni ndo kuati jà'a ma ñivi, ni jaka'nuni Ndioo ma kuati na ndia. Ta ma ndian töve ni jaka'nuni ndo ma kuati, nda ma Racha'nu Ndioo, töve ni jaka'nuni ra ma kuati na ndia ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma ra nàni Tomá, kùu ra iin ma ra indii tañu ma ndi uchi uvi ma ndra jàkua'a chi'in Jesuu, ra juuni kà'an na ña nàni Tili'ma. Rakan töve ìyo ra chi'in ndra ma ora kēta Jesuu nuu ka'ìin ndra. ");
INSERT INTO mza_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Takan kūu tajan inga ma ndra jàkua'a chi'in Jesuu, te'en nāka'an ndra chi'in ra: ―¡Cha ndē'e ndi ma Racha'nu! ―kàti ndra. Va ma Tomá te'en nāka'an ra chi'in ndra: ―Tu töve jàna'a ji'na ra ma nuu tākue'e nda'a' ra jā'a ma nduyu kàa, ta töve ku'va ra ña ti'i̱ xini nda'i yi, chi'in ma nuu tākue'e xiin ra, töve ni chinuni̱ ña cha nātaku ndiko ra ―kàti ma Tomá. ");
INSERT INTO mza_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ta ora yā'a una kivi, tajan kūti'vi ndiko ma ndra jàkua'a chi'in Jesuu iin tichi ve'e. Ta ma ora ikan, va ndaa ndio ma Tomá, chi'in ndra. Ta vaji ndisaa ma yuve'e ndasi yi, va Jesuu kī'vi ra ma nuu ka'ìin ndra, ta chūndaa ra ma'ñu ndra, ta te'en kāña'a ra chi'in ndra: ―¡Na vii koo ndo! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ta ikan jan te'en nāka'an ndio ra chi'in ma Tomá: ―Na ti'un xini nda'un ma nuu takue'e nda'i i'ya, ta nde'un yi, ta juuni na ti'un ma xini nda'un ma nuu tākue'e ma xii̱n niku ndia. Na töve nuva ja'un ña ndo'uviniun ti, na chinuniun ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tajan ma Tomá te'en nāka'an ra chi'in ra: ―¡Yo'o kùu ma Racha'nui, ta ma ra kùu Ndioi! ―kàti ma Tomá. ");
INSERT INTO mza_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ta Jesuu te'en nāka'an ra chi'in ra: ―Yo'o Tomá, vitin cha chìnuniun ti, cha ndē'un yu'u. Ya'aga ka'nu kùu ma ndian töve nī nde'e yu'u, ta chīnuni na ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Takan kūu ta Jesuu jā'a ra kua'a' ga ndatu ka'nu nuu ma ndra jàkua'a chi'in ra, ta yakan tüva yo ni taa yi nuu ma tutu i'ya. ");
INSERT INTO mza_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Takan tāi nuu ma tutu i'ya, ikan na chinuni ndo ña Cristu kùu ma ra Se'e Ndioo. Ta tu chìnuni ndo ma ña kà'an ra, ni ni'i ndo nuu koo ndito ndo endeeni chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ora ya'a ña kūu takan, tajan kēta ndiko Jesuu nuu ma ndra jàkua'a chi'in ra, yatini yu'u ma tañu'u ña kàndii ma ñuu nàni Tiberias. Ta te'en kūu yi ma ora ikan: ");
INSERT INTO mza_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nuu ka'ìin ti'vi ma ra nani Simón Petu', chi'in Tomá, ra juuni kà'an na ña nàni Tili'ma, chi'in ra nàni Natanael, ra ñuu Caná, ña ìyo kuenda ma ñu'u' Galilea, ta juuni ka'ìin ma ndra se'e Zebedeu, chi'in inga uvi ma ndra jàkua'a chi'in Jesuu ndia. ");
INSERT INTO mza_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tajan Simón Petu', te'en nāka'an ra chi'in ndra: ―Ni kukii̱n ―kàti ra. Ta ndrakan te'en nāka'an ndra chi'in ra: ―Juuni kùuni ndyu'u ku'un ndi chi'un ―kàti ndra. Tajan ndāa ndio ndra ma tichi varku, ta kēe ndra kàcha'an ndra, va tükuii nī ni'i ndra ri ma chanikuaa ikan. ");
INSERT INTO mza_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ta ma ora cha kīcha'a kundichin, tajan kēta ndio Jesuu ma yu'u tañu'u, va ma ndra jàkua'a chi'in ra, töve nī nakoto ndra ra. ");
INSERT INTO mza_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tajan Jesuu te'en chīkatu'un ra nuu ndra: ―Ndyo'o se'yu, ¿a takä'an kuii ni'i ndo ndri? ―kàti ra chi'in ndra. Ta ndrakan te'en nāka'an ndra chi'in ra: ―Takä'an ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Na jakana ndo ma yu'va tiaka' ka'nu ndo ma iti' chiyo kua'a ma varku, ta ni ni'i ndo ndri ―kàti ra chi'in ndra. Tajan takan kāni ndio ndra yi, ta nduva'a kua'a' ndri tīin yi ña ndava kündeega ndra tava ndra yi chi'in ndri. ");
INSERT INTO mza_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tajan iin ma ra jàkua'a chi'in Jesuu, ra ya'a kùuni ra nde'e ra, te'en nāka'an ra chi'in Petu': ―¡Maa ma Racha'nu kùu ra! ―kàti ra. Ta ora chīni ndio ma Simón Petu', ña juu ma Racha'nu Jesuu kùu ra, tajan numini chāku'un ra ma ja'ma ra, ti tāva ra yi, ma ora kìin ra, ta ndāva ra ma tichi takuii, ta kīcha'a ra suta ra nda kati chaa ra ma nuu ndaa Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ta ma inga ma ndra jàkua'a chi'in Jesuu chāa ndra ma yu'u tañu'u chi'in ma varku ndia, ña endee kèñu'u ndra ma yu'va tiaka' ndra, ti nduva'a kuii chitu yi. Ta ìyo a uvi cientu iki kùu yi, ña chika kēe ndra ma tichi tañu'u, ta chāa ndra ma ñu'u' ití. ");
INSERT INTO mza_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ta ora kānuu ndra ma nuu ñu'u', ta nāta'an ndra iin vinu'u ña ka'ìin nditiu'un, ña jùndii iin tiaka' nuu yi, ta iin paan. ");
INSERT INTO mza_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―Na kichi ndaka ndo uvi uni tiaka' ña já tīin ndo nui ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tajan ma Simón Petu' ndāa ndio ra tichi ma varku, ta endee kēñu'u ra ma yu'va tiaka' jānuu ra yi ma yu'u tañu'u, ña endee chitu yi chi'in iin cientu uvi xiko uchi uni ta'an tiaka' na'nu. Ta vaji ya'aga kua'a' ndri, va töve nī nakaa ma yu'va tiaka'. ");
INSERT INTO mza_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tajan Jesuu te'en nāka'an ra chi'in ndra: ―¡Na'a ndo kasi'ini ndo! ―kàti ra. Nï'iin ma ndra jàkua'a chi'in ra, töve nī kanani ndra ndàkatu'un ndra nuu ra ña nda ra kùu ra, ti cha chìto ndra, ña Racha'nu Jesuu kùu ra. ");
INSERT INTO mza_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ta ikan jan Jesuu chājayatin ra ra ma yu'u nu'u, ta kī'in ra ma paan ta chā'a ra yi nuu ndra, ta juuni takan jā'a ra chi'in ma tiaka' ndia. ");
INSERT INTO mza_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ña'a kùu ma cha'a' uni, ña jāna'a Jesuu ra nuu ma ndra jàkua'a chi'in ra, ma ora cha yā'a ña nātaku ndiko ra tañu ma ndian ndií. ");
INSERT INTO mza_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ta ora chinu chāchi ndra, ta te'en kīcha'a ma Jesuu chìkatu'un ra nuu ma Simón Petu': ―Yo'o Simón Petu', ra se'e Jonás, ¿a kùunigaun nde'un yu'u, kua ma ndra ka'ìin i'ya? ―kàti Jesuu chi'in Petu'. Ta Petu' te'en nāka'an ra: ―Ndicha yo'o Racha'nu, cha chìtoun ña kùuni̱ nde'i ñu̱n ―kàti Petu'. Ta Jesuu te'en nāka'an ra chi'in ra: ―Na jakuendaun ma ndian chìnuni ña kà'in, takua jà'a ma iin pato chi'in ma mvechala jàna ra ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ta te'en chīkatu'un tuku ra nuu ra: ―Yo'o Simón, ra se'e Jonás, ¿a ndichaun ña kùuniun nde'un yu'u? ―kàti Jesuu. Ta Petu' te'en nāka'an ra chi'in ra: ―Ndicha, yo'o Racha'nu, cha chìtoun ña kùuni̱ nde'i ñu̱n ―kàti ma Petu'. Tajan Jesuu te'en nāka'an ra chi'in ra: ―Na kumiun ma ndian chinuni ña kà'in, takua jà'a iin pato chi'in mvechala jàna ra kùu chito'o ra ―kàti Jesuu chi'in ra. ");
INSERT INTO mza_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Takan kūu tajan cha'a' uni kùu yi ña, te'en kīcha'a ndiko Jesuu chìkatu'un ra nuu ra: ―Yo'o Simón, ra se'e Jonás, ¿a ndichaun ña kùuniun nde'un yu'u? ―kàti Jesuu. Tajan ma Petu' nda'vi kūuni ndio ra cha'a' ña, cha'a' uni chìkatu'un Jesuu nuu ra, ña tu kùuni ra nde'e ra ra, tajan te'en nāka'an ra chi'in ra: ―Yo'o Racha'nu, cha chìto va'un ndisaa ma kua chànini̱, ta juuni cha chìtoun ña kùuni̱ nde'i ñu̱n ndia ―kàti Simón. Tajan Jesuu te'en nāka'an ra chi'in ra: ―Na jakuendaun ndisaa ma ndian chìnuni ña kà'in takua jà'a iin pato chi'in mvechala kùmi ra. ");
INSERT INTO mza_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ndicha va'a ña kà'in chi'un, ti ora kùu̱n ma rayoko tiaga, ìyo ga ñandeun ña jà'un ma ña kùuni maun, va ora ni ndakuu cha'nu̱n, ma inga ñivi ni tiin na ñu̱n, ta ni ku'ni na nda'un, ta tüva kùu ku'u̱n ma nuu kùuni maun, ti inga ñivi kùu na ña ni ka'nda na tiñu nuu̱n, ta ku'un na chi'un ma nuu töve kùuniun ku'u̱n. ");
INSERT INTO mza_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chi'in ma tu'un i'ya, chā'a Jesuu ña na kutunini ndra ma naja kua ni kuvi Petu', ta takan jàna'a yi ña ma Racha'nu Ndioo, iin ra ya'aga ka'nu kùu ra. Ta ora yā'a ña kā'an Jesuu takan, tajan nāka'an ra te'en chi'in Petu': ―¡Na tandikun chatai! ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Takan kūu ta ora chīkoni'i ma Petu' ndē'e ra iti' chata ra, ta ndē'e ra ña vàchi iin ma ra jàkua'a chi'in Jesuu. Ta rakan ti iin ra ya'a ga kùuni Jesuu nde'e ra kùu ra, ti juuni ra kùu ma ra chūnandi xiin Jesuu ma nuu kūxini ndra, ma ra chīkatu'un te'en nuu ra: “Yo'o Racha'nu, ¿nda ra kùu ma ra ni xikoña'a cha'un?” kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tajan ora ndē'e ma Petu' ma ra vàchi chata ndra, ta te'en chīkatu'un ra nuu Jesuu: ―Yo'o Racha'nu, ta rakan, ¿niyi ni ta'an ra? ―kàti Petu'. ");
INSERT INTO mza_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ta Jesuu te'en nāka'an ra: ―Tu yu'u kùuni̱ ña na koo ra ma ñuñivi i'ya, nda ma ora ni kichaa ndikoi, yöve kuenda maun kùu yi. Ma ña ìyo yi ña ja'un kùu yi ña na tandiku̱n chatai ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Takan kūu ña ma tu'un ña kà'an ña töve ni kuvi ra, chītakuati yi nuu kua'a' ma ndian chìnuni tu'un Jesuu, ta chīto na yi. Va ma tu'un ndaa kùu yi ña Jesuu töve nī ka'an ra nuu ndra ña rakan töve ni kuvi ra, ti ma ña kā'an Jesuu kùu yi ña: tu kùuni ra ña koo rakan ma ñuñivi i'ya, nda ma ora ni kichaa ndiko ra, yöve kuenda ma Petu' kùu yi, kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ta rakan kùu ma ra jàkua'a chi'in Jesuu, ra kàtitu'un cha'a' ma tu'un i'ya ta juuni ra tāa yi i'ya. Ta chìto va'a yo, ti tu'un ndaa kùu yi. ");
INSERT INTO mza_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ta juuni jā'a Jesuu kua'a' ga tiñu ma ora chākunuu ra ma ñuñivi i'ya. Ta yu'u chànini̱, ña tu taa ndi'i yo ta'ii'iin ma tiñu jā'a Jesuu nuu kua'a' tutu, töve ni kuta'an yi ma ñuñivi i'ya niku. Ta takan na kuu yi. Amén.");
INSERT INTO mza_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ma tutu nunuu ña tāi nuu̱n, yo'o Teófilo, tāi yi ikan na kutu'vaun ndisaa tiñu jā'a Jesuu chi'in ma tu'un jāna'a ra nda ora kīcha'a ra jà'a ra yi, ");
INSERT INTO mza_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ta nda ora kēta ma kivi ña ndāa ndiko ra andivi. Ta ora takäaga ku'un Jesuu andivi, ji'naga kātitu'un ra nuu ndra kùu tatun ra, nda tiñu ìyo yi ña ja'a ndra, va jā'a ra yi chi'in Tati Ií Ndioo, ikan na koto kachin maa ndra yi, nda tiñu ìyo yi ña ja'a ndra. ");
INSERT INTO mza_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Takan kūu ta ora cha yā'a ña chī'í ra, tajan kēta ndito ndiko ra nuu ma ndra kùu tatun ra, ta jāna'a ra kua'a' nakuyi nuu ndra. Ta ikan ndē'e ndra, ti ndicha ña nātaku ndiko ra. Ta uvi xiko kivi kùu yi ña chīyo Jesuu chi'in ndra ña jàna'a ra nuu ndra, naja kua kàa nuu chà'nda Ndioo tiñu. ");
INSERT INTO mza_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Takan kūu ta ora juuni ìyo ga ra chi'in ma ndra tatun ra, tajan te'en nāka'an Jesuu chi'in ndra: ―¡Na këe ndo ma ñuu Jerusalén! ¡Na kindoo ndo ikan, nda kati chinu ma tu'un chā'a ma Tatái nuu ndo! Ta ma tu'un ikan, ti juuni cha kātitu'in yi nuu ndo ndia. ");
INSERT INTO mza_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ndicha kuii ti chi'in takuini jākunduta ma Xuva ma ñivi, va tiá iti' nuu, Ndioo ni jakunduta ndo chi'in ndatu ma Tati Ií Ra. ―Takan kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tajan ma ndra ka'ìin ti'vi chi'in Jesuu, te'en kīcha'a ndra chìkatu'un ndra nuu ra: ―Yo'o, Racha'nu, ¿a vitin ni jakaku̱n ñuu Israel, ikan na kuu ka'nda yo tiñu juuni nuu maa yo? ―kàti ndra chi'in ra. ");
INSERT INTO mza_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tajan te'en nāka'an ndio Jesuu chi'in ndra: ―Tüvi ìyo yi ña koto ndo nda kivi, ta nda kuiya kùu yi ña ni ja'a Tatái yi, ti uvanuu rakan kùu ra ña chìto ra nda kivi ni ja'a ra yi, ti ìyo ndatu ra. ");
INSERT INTO mza_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ta ndyo'o ti ni ni'i ndo ndatu ma Tati Ií Ndioo ora ni kichi yi koo yi chi'in ndo. Ta ikan jan ku'un ndo kujana'a ndo tu'un cha'i ñuu Jerusalén, ta ninii ñu'u' Judea, ta ñu'u' Samaria chi'in ninii ka'nu ñu'u' ñuñivi, ikan na koto ndisaa ma ñivi ìyo ñuñivi yi ―kàti Jesuu. ");
INSERT INTO mza_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ta ora chīnu kà'an ra te'en, tajan ndē'e ma ndra kùu tatun ra ña ndāa ra kuà'an ra iti' andivi. Ta ikan chāsi iin viko ra, ta tüva nī nde'e ndra ra. ");
INSERT INTO mza_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Takan kūu, ta ora juuni ka'ìin ndra ndè'e ndra naja kua kuàndaa Jesuu iti' andivi, tajan kēta uvi ndra ñù'u ja'ma kuichin yatin xiin ndra, ");
INSERT INTO mza_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ta te'en kīcha'a ndio yi kà'an yi chi'in ma ndra kùu tatun Jesuu: ―Ndyo'o ndra kīchi ñu'u' Galilea, ¡na ndë'ega ndo iti' andivi! Ti ma ra ndē'e ndo ña kuà'an, juuni ma ra chīyo chi'in ndo kùu ra, va vitin cha ndāa ra andivi. Ta ni kichi ndiko ra inga cha'a', takua ndē'e ndo ra ña kuà'an ra. ―Takan kàti ma tati jà'a tiñu nuu Ndioo nuu ndra. ");
INSERT INTO mza_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tajan kēe ndra tatun Jesuu nda yuku nàni Olivu. Ta kuà'an ndra iti' ñuu Jerusalén vati iin ñuu kàndii yatini kùu yi, ti na küu kee chika na kakunuu na ma kivi nindeo, takan kà'an ma ley ma ndian judíu. ");
INSERT INTO mza_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ta ora chāa ndra ma ñuu Jerusalén, ta ndāa ndra iin ve'e ìyo nda siki nuu takani ndòo ndra. Ta ndisaa ndrakan, nàni ndra te'en: Petu', Xuva, Jandiau, André, Lipe, Tomá, Tolo, Mate, chi'in Jandiau se'e ra nàni Alfeu, ta Juda se'e Jandiau, ta ra nàni Simón, iin ra kùuni kanita'an chi'in ñuu Roma kùu ra. ");
INSERT INTO mza_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yakan va ndisaa ndrakan kùti'vi ma ikan ta kà'an ndra chi'in Ndioo nani kivi ti inuuni ma ña chànini ndra. Ta chi'in ndra juuni kùti'vi ndra yani Jesuu chi'in Ndiya ña kùu ma'á ra, ta inga tuku ñivi ña'a ndia. ");
INSERT INTO mza_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tañu ma kivi ikan, kūti'vi kua'a' ma ndian chìnuni tu'un Jesuu. Ta ìyo iin iin cientu oko ta'an na kūti'vi ma ikan. Ta ikan chūndaa ndio ma Petu', ta te'en kīcha'a kàtitu'un ra nuu na: ");
INSERT INTO mza_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Ndyo'o ndian yani, cha chīnu ma tu'un kā'an ma Tati Ií Ndioo nuu ma racha'nu David taji'na. Ti David, cha tāa ra yi nuu ma tutu Ndioo naja kua kūu yi chi'in Juda, ra xīkoña'a cha'a' Jesuu. Ti rakan jāna'a ra nuu ndra ma nuu ìyo yi ña kùu nata'an ndra Jesuu ta tiin ndra ra, ");
INSERT INTO mza_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","vaji juuni iin ra jàkua'a chi'in Jesuu kùu ra niku. Vati jā'a ra ma tiñu takua jà'a yo ndia. ");
INSERT INTO mza_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Va kēta iin kivi ña chā'an Juda, ta jāta ra iin ñu'u' chi'in ma xu'un' tīa'vi ndra ra cha'a' ma tu'un vata ña tāva ra cha'a' Jesuu. Ta ikan kōyo Juda iti' xini ra, ta ndāta tichi ra. Ta kēe chiti ra, ta chī'í ra. ");
INSERT INTO mza_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Takan kūu ta ora chīto ñivi ìyo ñuu Jerusalén ña tā'an Juda, ta jākunani na ma ñu'u' ikan, Ñu'u' Acéldama, vati ma tu'un ikan kùuni yi ka'an yi: Ñu'u' Nií chi'in ma tu'un kà'an na. ");
INSERT INTO mza_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ti nuu tutu Salmu te'en kà'an yi cha'a' Juda: Ma nuu chīyo ra, na ndakuu yi iin tichi ku'u taxiin, nuu nï'iin na na köo. Ta juuni kà'an yi te'en ndia: Inga ra, na ndaki'in tiñu chīyo ra, kàti yi. ");
INSERT INTO mza_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Ìyo ndra takani chàkunuu chi'o ndisaa tiempu, nda ora chīyo Racha'nu Jesuu tañu yo. ");
INSERT INTO mza_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Vati ndrakan ìyo ndra chi'in yo, nda ora jākunduta Xuva ma Jesuu, ta nda ora ndāa ra kuà'an ndiko ra iti' andivi. Ta vitin ìyo yi ña kachin yo iin ra ìyo tañu ma ndra chàkunuu chi'o, ta ndaki'in ra tiñu jà'a yo. Ta indukuni kakunuu ra chi'o ña kàtitu'un ra naja kua nātaku Jesuu. ―Takan kàti Petu'. ");
INSERT INTO mza_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yakan va kāchin ndra uvi ta'an ma ndra chàkunuu chi'in ndra: Kusé Barsabás, ra juuni nàni Justo ndia, ta inga ra nàni Matías. ");
INSERT INTO mza_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ta ikan kīcha'a ndra kà'an ndra chi'in Ndioo te'en: ―Yo'o Racha'nu ña nàkoto naja kua chànini ndisaa ndi. Na nde'un ninduvi ndra'ya, ta na jana'un nuu ndi nda ra kùu ra kàchíun, ");
INSERT INTO mza_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ña ndaki'in tiñu chīyo Juda, ikan na ndoo ra kùu ra tatun chi'in ndi. Vati Juda jānaa ra ma tiñu chīyo ra jà'a ma kuati jā'a ra ora kuà'an ra ma nuu ìyo yi ña ku'un ra. ―Takan kà'an ndra chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tajan kīcha'a ndio ndra chàsiki ndra chi'in yuu kuati, ta jākanaa Matías, ti ma yuu ikan kōyo yi kuenda ra. Ta nda ma ora ikan kīcha'a ra kùu ra tatun chi'in ndi uchi iin tatun Jesuu. ");
INSERT INTO mza_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ora kēta iin viko ña jàka'nu ñivi judíu ña nàni Pentecosté, ma kivi ikan kūti'vi tandi'i ñivi chìnuni tu'un Jesuu ma ikan. ");
INSERT INTO mza_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ta ikan numini chīni na ña ni'i jà'a yi iti' andivi, takua jà'a iin tati ña ya'a ni'i chàkin ninii ma tichi ve'e nuu ka'ìin na. ");
INSERT INTO mza_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ta kēta iin ña kàa takua kàa yaa ñu'ú, ta chītakuati yi xini ii'iin na. ");
INSERT INTO mza_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ta ndisaa na kī'vi ma Tati Ií Ndioo tichi anima na. Ta ikan jan kīcha'a kà'an na siin siin tu'un ña tüvi chìto na kà'an na, ti ma Tati Ií Ndioo jā'a ña na kutu'va na kà'an na ma tu'un ikan. ");
INSERT INTO mza_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ta ma kivi ikan ìyo kua'a' ñivi judíu ñuu Jerusalén, ndian kīchi nuu chika, ninii ka'nu ñuñivi. Ta ndiakan ti ndian ya'a jàchi'in ma ña kà'an ma ley Ndioo kùu na. ");
INSERT INTO mza_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tajan kūti'vi ndio ma ñivi ora chīni na ña ni'i jà'a ndio ma tati ikan. Ta ikan ndē'e na ma ndian chìnuni tu'un Jesuu, ña ni tüva chìto na naja kua chànini na. Ti ma ndian chìnuni ikan kà'an na tu'un kà'an inga ñivi. Va kùtunini ma inga na yi, ti tu'un kà'an na kùu yi. ");
INSERT INTO mza_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ta ndava kuà'an tati na ndè'e na ma ña jà'a inga na. Tajan kīcha'a na chìkatu'un ta'an na: ―¿Ta naja kùu ja'a na kà'an na tu'un kà'an yo tuva ñivi kīchi ñu'u' Galilea kùu na? ");
INSERT INTO mza_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ta naja kua kùu yi ña ii'iin yo chìni yo ña kà'an na tu'un kà'an yo, ta siin siin ñuu yo? ");
INSERT INTO mza_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vati ma tañu yo ìyo ndian kīchi ñu'u' Partia, ñu'u' Media, ñu'u' Elam, ñu'u' Mesopotamia, ñu'u' Judea, ñu'u' Capadocia, ñu'u' Ponto, ta nda ñu'u' Asia ndia. ");
INSERT INTO mza_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ta juuni ìyo ndian kīchi ñu'u' Frigia, ñu'u' Panfilia, ñu'u' Egiptu, ta ñu'u' Libia, ña kàndii yatini ñu'u' Cirene, ta ndian kīchi ñuu Roma ndia. ");
INSERT INTO mza_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ìyo ndian kùu ñivi judíu nda ora kāku na, ti tatá na kùu ñivi judíu. Ta inga na, jākua'a na, ta ikan kī'vi na kuenda ñivi judíu. Ta juuni ìyo ndian kīchi ñu'u' Creta chi'in ñu'u' Arabia ndia. Yakan va vaji siin siin kà'an ta'ii'iin yo, va chi'in ma tu'un kà'an ta'ii'iin yo kùtunini yo tu'un kà'an ndian kùu ñivi Ndioo cha'a' ma tiñu ka'nu ña jà'a ra ―kàti na. ");
INSERT INTO mza_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ta ikan ndisaa ndio na ndava kuà'an tati na, ti nī töve chìto na nayi chànini na. Ta ikan jan te'en kīcha'a na chìkatu'un ta'an na: ―¿Ta nayi kùuni yi ka'an yi ña jà'a na te'en? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Va ìyo inga ndian kà'an ti'ini te'en: ―Jà'a na takan ti ndian chìní kùu na ―kàti na. ");
INSERT INTO mza_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yakan va, Petu' chūndaa ra chi'in ma ndi uchi iin tatun Jesuu, ta te'en kīcha'a ra kà'an ni'i ra chi'in na: ―Ndyo'o ñivi judíu, ta ndisaa ñivi ìyo ñuu Jerusalén, ¡na koto ndo tu'un i'ya, ta na taso'o va'a ndo ña ni ka'in! ");
INSERT INTO mza_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ma ndian ka'ìin chi'in ndi i'ya, yüvi ndian chīní kùu na takua chànini ndo, vati já kaa iín na'ani kùu yi. ");
INSERT INTO mza_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yakan va yüvi takan kùu yi, ti ña'a kùu ña tà'an ndra takua kātitu'un racha'nu Joel, ra kà'an chi'in tu'un yu'u Ndioo taji'na. Ti rakan te'en kā'an ra ma ña kātitu'un Ndioo nuu ra: ");
INSERT INTO mza_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Te'en ni kuu nuu ni kicha'a ndi'i ñuñivi, kàti Ndioo. Ni tachi̱ Tati Ii̱ nuu ndisaa ñivi ñuñivi, ta ikan ni koo yi chi'in na. Ta ma se'e ndo, ra'ii a ña'a', ni ka'an na tu'un yu'i. Ta ma ndian yoko, ni nde'e na ña ya'a ka'nu ña ni jana'i nuu na. Ta ma ndian cha'nu, ni ja'i ña na koyo ma chani nuu na. ");
INSERT INTO mza_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ta juuni ni tachi̱ ma Tati Ii̱ nuu ma ndian kùu musui, ra'ii a ña'a', na koo yi chi'in na ma kivi ikan, ta na ka'an na tu'un yu'i ja'a yi. ");
INSERT INTO mza_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ta iti' andivi ni jana'i nuu ndo kua'a' ndatu ka'nu. Ta ñivi ñuñivi ni nde'e na tundo'o. Ni kati' kua'a' nií na, ta ni kayu kua'a' nakuyi jà'a ma ñu'ú. Ta ni kutu kua'a' ñu'ma ma ñuñivi ndia. ");
INSERT INTO mza_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ta ma tatá nikandii ni nda'va ra. Ta tatá yoo ni ndakuu kua'á ri takua kàa nií, antea ña keta kivi ya'a ga ka'nu ta ií, ña ni kichi Racha'nu chito'o yo. ");
INSERT INTO mza_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Va ndisaa ndian chìkan nuu Racha'nu Ndioo ña na jaka'nuni ra ma kuati na, ni kakú na nuu ma tundo'o ikan. Takan kàti Ndioo, kāti ma tutu ña tāa ma racha'nu Joel taji'na. ");
INSERT INTO mza_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’¡Taso'o va'a ndo ndyo'o ñivi ñuu Israel ña ni ka'in chi'in ndo! Ti takua ndyo'o cha chìto va'a ndo, cha'a' ma tiñu jā'a Racha'nu Jesuu, ra kīchi ñuu Nazaret. Rakan kùu ra kāchin Ndioo ta jāna'a ra ra nuu ndisaa ndo. Ti Ndioo chā'a ra ña na ja'a Jesuu kua'a' ndatu ka'nu ra nuu ndo, ta juuni jā'a ra ña na jana'a ra kua'a' seña kuenda ma kuiya ni kichi. Ta juuni jāva'a ra kua'a' nakuyi chi'in ndatu ra ndia. ");
INSERT INTO mza_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Vati ora takä'an koo Jesuu chi'in ndo, cha chìto Ndioo nayi ni ja'a ndo chi'in ra. Yakan va takan kūu yi. Ta ora cha ìyo Jesuu chi'in ndo tajan chā'a ndo ra nuu ma ndra kini, ta tākaa ndra ra nuu kruu, ta ikan na kuvi maa ra. ");
INSERT INTO mza_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Va Ndioo jānataku ndiko ra ra, ta tāva ra ra tañu ñivi ndií, ti na küu kindoo ra chi'in ndian ndií ndisaa tiempu jà'a ma ndatu Ndioo. ");
INSERT INTO mza_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ta ma racha'nu Rey David, ra chīyo tatiempu, te'en kā'an ra cha'a' Jesuu: Chìtoi, ti ìyo ma Racha'nu Ndioo chi'i̱n, ndisaa kivi ti jàkuenda ra yu'u. Yakan va tüvi yu'vi̱ vaji ni nde'i tundo'o. ");
INSERT INTO mza_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ta cha'a' yakan kùu yi ña chìsii animai, ta chìtai, ti ya'a sii kùuni̱. Vati chìtoi ti ndicha ña ni nataku ndikoi endeeni. ");
INSERT INTO mza_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ta töve ndàkoun yu'u tañu ñivi ndií. Ta töve ku'vaun ña na ta'yu ñunda'yui, ti yu'u kùu ma ra ií ña kùu musu̱n. ");
INSERT INTO mza_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ti maun jàna'a nui ma iti' nuu koi chi'un. Ta juuni ya'a chìsii̱ ora ni koi chi'un nuu ìyoun. Takan kāti David ―kàti Petu'. ");
INSERT INTO mza_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tajan te'en nàka'an tuku Petu' chi'in na: ―Ndyo'o xaa, kùuni ka'in iin tu'un ndaa nuu ndo cha'a' ma Rey David, ra kūu ñivi yo, ra chīyo taji'na. Ta rakan, ti kēta iin kivi ña chī'í ra. Ta ikan kūchi ra. Ta ma nuu ñaña ra, juuni ìyoga yi nda vitin yatini nuu ìyo yo. ");
INSERT INTO mza_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yakan va ma racha'nu David, kūu ra iin ra kā'an chi'in tu'un yu'u Ndioo taji'na. Ta juuni chīto ra ti Ndioo chā'a ra ma tu'un nuu ra ña ni koo iin ñivi ra ña ni ka'nda tiñu ma kuiya vàchi. ");
INSERT INTO mza_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ta kā'an ra yi ta iin ma ña chākuu yi, vaji takä'an kuu yi. Yakan va ma kivi kā'an David ma tu'un ikan, juuni kā'an ra kuenda ra Cristu naja kua ni nataku ndiko ra. Ta kāti ra ti ma ra kùu Cristu, töve ni ndoo ra nuu ñaña ra. Ta ma ñunda'yu ra na tüvi nī ta'yu yi ndia. ");
INSERT INTO mza_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yakan va cha chìto yo ti Ndioo jānataku ndiko ra juuni ma Jesuu, ra chī'í nuu kruu. Ta kuenda ña'a, ndisaa ndi kùu ndi testigu, ti ndē'e ndi ña ndicha ña ndìto Jesuu vitin. ");
INSERT INTO mza_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ta Jesuu ndāa ra kuà'an ra kuàkunandi ra chiyo kua'a Ndioo nuu ìyo ndatu ra. Ta ikan chā'a Tatá Ndioo, Tati Ií ra nuu ra, vati kua ikan cha chā'a ra tu'un nuu ra. Ta ikan juuni Jesuu, tāchi Tati Ií Ndioo nuu yo nde've. Ta ña'a kùu ña ndē'e ndo ta chīni ndo nda che'e. ");
INSERT INTO mza_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ti yüvi David kùu ra ña ndāa ra andivi ta chūnandi ra chiyo kua'a Ndioo, vati juuni maa ma David te'en nāka'an ra: Ma Racha'nu Ndioo te'en kā'an ra chi'in ma ra chito'i: “Na kunandiun chiyo kua'i, ti i'ya ni ku'vai ma ndatui nuu̱n, ");
INSERT INTO mza_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nda kati kanindoyoi ma ndian kànita'an chi'un iti' cha'un.” Takan kāti Ndioo chi'in Jesuu, kāti racha'nu David taji'na. ");
INSERT INTO mza_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Na koto tandi'i ndyo'o ñivi ñuu Israel, ma tu'un ndaa. Ti juuni ma Jesuu ra chā'ni ndo nuu kruu, juuni kùu ra Cristu ta chito'o yo, jà'a Racha'nu Ndioo ―kàti Petu'. ");
INSERT INTO mza_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ta ora chīni ma ñivi ka'ìin ikan ma tu'un kà'an Petu', nda'vi kùuni na, ta kīcha'a na chìkatu'un na nuu Petu' chi'in nuu inga ndian kùu tatun Jesuu te'en: ―¡Ndyo'o xaa! ¿Nayi ìyo yi ña jà'a ndi? ―kàti na. ");
INSERT INTO mza_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tajan te'en nāka'an Petu' chi'in na: ―¡Na chikoni'i anima ndo chi'in Ndioo! ¡Ta na kunduta ndo chi'in sivi Jesucristu, ikan na janaa Ndioo kuati ndo, ta takan na ku'va ra ña na koo ma Tati Ií Ndioo chi'in ndo! ");
INSERT INTO mza_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ma tu'un i'ya Ndioo chā'a yi kuenda ndo ta juuni kuenda se'e ndo. Ta juuni chā'a ra tu'un ra kuenda ndian ìyo chika a ndian ìyo yatini, vati kùu yi kuenda tandi'i ndyo'o ndian kāchin Racha'nu Ndioo ña kuu ndo ma ñivi ra. ―Takan kàti Petu'. ");
INSERT INTO mza_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Takan kūu ta juuni kà'an Petu' tiá kua'a' tu'un kuenda Jesuu, ta te'en kātitu'un ra nuu ñivi ikan ña chùndayu'u ra na chi'in tu'un i'ya: ―¡Na kundachiyo ndo xiin ñivi jà'a ña kini ìyo ñuñivi i'ya koto ndakuu kini ndo ndia! ―Takan kàti ra. ");
INSERT INTO mza_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yakan va ndian chīnuni ma ña kà'an ra, ndiakan kùu ndian kūnduta. Ta ma kivi ikan ti kī'vi iin uni mii ñivi, ndian chìnuni ma iti' kuà'an Jesuu. ");
INSERT INTO mza_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ta ndisaa na jàchi'in na ma tu'un jàna'a ma ndra tatun Jesuu. Ta ikan indukuni jāchaa na ma ndatiñu na chi'in meru na, ti inuuni chànini na. Ta ikan endee kà'an na chi'in Ndioo ora kùti'vi na nuu chà'nda kuati na paan chàchi na. ");
INSERT INTO mza_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Takan kūu ta ndisaa na, ndava yù'vi na ta ndava kuà'an anima na ña ndè'e na kua'a' tiñu ka'nu jà'a ma ndra tatun Jesuu, ti jànda'a ndra kua'a' ñivi ta jà'a ndra inga tiñu ka'nu chi'in ndatu ña chà'a Jesuu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ta ma ndian chìnuni ma tu'un Jesuu, endee ìyo ti'vi na chi'in ndisaa ta'an na ndisaa kivi ti inuuni chànini na. Ta induku jàchaa na ndisaa ña ìyo nuu na chi'in ta'an na. ");
INSERT INTO mza_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta xìko na ti'yo na, ta tandi'i inga ndatiñu na. Ta ikan chà'a na xu'un' nuu ta'an na tuva ìyo nayi kùmani nuu na. ");
INSERT INTO mza_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ta ndisaa kivi kùti'vi na ma veñu'u ka'nu ñivi judíu ña ndaa ñuu Jerusalén chi'in tave'e tave'e ndian meru na ña chìnuni, ña chà'nda java na paan. Ta ikan jan kīcha'a na kùsama na ma nuu ìyo ti'vi na, vati ya'a chìsii anima na ti ya'a va'ani na chi'in ta'an na. ");
INSERT INTO mza_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ta jàka'nu na Ndioo, ta tandi'i ma ñivi ìyo ma ñuu tìñu'u na na ndia. Ta tandi'i kivi ìyo tiá ga kua'a' ndian cha kī'vi iti' Jesuu, ta ndiakan kùu ma ndian kāchin ra ña ni kakú jà'a ra. ");
INSERT INTO mza_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Iin kivi kuà'an Petu' chi'in Xuva veñu'u ka'nu ñuu Jerusalén kaa uni chani'ini, vati ma ora ikan kùu ora kà'an ñivi judíu chi'in Ndioo veñu'u ikan. ");
INSERT INTO mza_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ta ma yukora veñu'u ikan nàndi iin ra kùkue'e cha'a pe'lu, ña takani kùkue'e ra nda ora kāku ra. Ta rakan ti nani kivi chàndaka na ra ma ikan, ta chàjakunandi na ra yatin ma yukora veñu'u ña nàni Yukora Vii. Ikan na ndakan ra xu'un' nuu ma ndian yà'a ikan. ");
INSERT INTO mza_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ta ma kivi ikan ora ndē'e ma ra kùkue'e ma Petu' chi'in Xuva ña chani ki'vi ndra ma yukora ikan, ta kīcha'a ra chìkan ra xu'un' nuu ndra. ");
INSERT INTO mza_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yakan va ora ndē'e ndra ma ra kùkue'e ña nàndi ra ikan, tajan te'en kīcha'a kà'an Petu' chi'in ra: ―¡Nde'e nuu ndi! ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tajan ma ra kùkue'e, ndē'e ra nuu ndra, ti chànini ra ña ni ku'va ndra xu'un' nuu ra, kùuni ra niku. ");
INSERT INTO mza_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Va ma Petu' te'en nāka'an ra chi'in ra: ―Töve xu'un' plata nuu ndi ta ni oro ndia, ña ku'va ndi nuu̱n, va ndava ni kùuni ìyo nuu ndi kùu ku'va ndi yi nuu̱n. ―Takan kàti Petu' chi'in ra. Ta ikan nāka'an ndiko Petu' inga cha'a' te'en: ―Chi'in ndatu Jesucristu, ra ñuu Nazaret, kà'in chi'un ña na ndetaun ta kakaun ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tajan ora chīnu kà'an Petu' te'en, ta tīin ra chiyo nda'a' kua'a ma ra kùkue'e, ta jāndeta ra ra. Ta ma ora ikani numini ndākuu ni'i ma cha'a ra chi'in iki cha'a chondo ra. ");
INSERT INTO mza_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tajan ma ra kùkue'e ikan, iin ndāvani ra, ta kīcha'a ra chìka ra. Ta ikan kī'vi ra yukora veñu'u chi'in ndra, va juuni chi'in cha'a maa ndio ra chìka ra. Ta endee ndàva ra ña jàka'nu ra Ndioo ti ya'a chìsii ra. ");
INSERT INTO mza_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Takan kūu tajan ma ndian ka'ìin tichi veñu'u ikan, ora ndē'e na ra ña jàka'nu ra Ndioo, ta chìka ra, ta ndava kuà'an tati ndio na, ta yū'vi na ndè'e na ma ña jā'a chi'in ra ña ndā'a ra. Ta nākoto na ra ti juuni ma ra chùnandi yukora veñu'u vii chìkan xu'un' kùu ra. ");
INSERT INTO mza_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Takan kūu ta ma ra cha'a pe'lu ña cha ndā'a, endee tüvi jaña ra ma Petu' chi'in Xuva. Ta ndisaa ñivi ndava kuà'an tati na ndè'e na ma ra kùkue'e. Ta kāndakunu na kuà'an na iti' Corredor Salomón nuu ka'ìin ndra. ");
INSERT INTO mza_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ta ora ndē'e Petu' ña chākoyo kua'a' ñivi nuu ra, ta kīcha'a ra kà'an ra te'en chi'in na: ―Ndyo'o ñivi israelita, ndè'i ndo ña ndava kuà'an tati ndo ndè'e ndo ña ndā'a ma ra kùkue'e i'ya. ¿A chànini ndo ña jānda'a ndi ra chi'in ndatu maa ndi?, kùuni ndo. ¿A chànini ndo ña chìka ra'ya vitin jà'a ndi ti ñivi ií kùu ndi?, kùuni ndo. ¡Va yüvi takan kùu yi! ");
INSERT INTO mza_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ti ndā'a ra'ya chi'in ndatu Ndioo jà'a Jesuu. Ti ñivio cha'nu chīyo taji'na, ra nani Abraham, ta Isaac, ta Jacob, ndrakan kùu ndra jāka'nu Ndioo taji'na ora chīyo ndra. Juuni Ndioo ikan kùu ra ña jāka'nu ra Se'e ra Jesuu, ra kùu musu ra. Va ndyo'o tīin ndo Jesuu ma i'ya ta chāndaka ndo ra nuu Pilatu. Ta ora kūuni Pilatu jaña ra ra ta tüvi nī cha'a ndo ña na ja'a ra yi, ");
INSERT INTO mza_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","vaji ma Cristu kùu ra iin ra ií ta ndaa. Va ndyo'o java chīkan ndo ña na jaña ra iin ra chà'ni ñivi. ");
INSERT INTO mza_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ta takan chā'ni ndo ma ra chà'a kivi koo yo chi'in Ndioo. Va Ndioo jānataku ndiko ra ra. Ta cha'a' ña'a kùu yi ña ndyu'u kùu testigu, yakan va chà'a ndi kuenda nuu ndo. ");
INSERT INTO mza_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Vati yakan va ma ra kùkue'e i'ya ndisaa ndo nàkoto ndo ra, ta vitin ndè'e ndo ra ña cha ndā'a ra. Ta yüvi ndyu'u jā'a yi, vati ma ndatu Jesuu kùu yi ña jā'a yi takan cha'a' ña chìnuni ndi ma ña kà'an ra. Ta ndicha kuii ti chìnuni ndi ña ìyo ndatu Jesuu, ti juu yi jānda'a ndisaa ma kue'e ña ndo'o ma ra kùkue'e ikan. Ta yakan kùu ma ña ndè'e ndisaa ndo vitin. ");
INSERT INTO mza_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Yakan va ndyo'o xaa, cha chìtoi ti maa ndo chi'in ndra kuxini nuu ndo chā'ni ndo Jesuu ma i'ya. Va jā'a ndo yi ti töve chīto ndo ña ra jà'a tiñu Ndioo kùu ra. ");
INSERT INTO mza_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Takan kūu va te'en jāchinu Ndioo ma ña kā'an ndisaa ma ndra kà'an chi'in tu'un yu'u Ndioo taji'na: ti ma ra kùu Cristu ni nde'e ra tundo'o, ta ni kuvi ra, kāti ndra. ");
INSERT INTO mza_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yakan va na ndakoo ndo iti' kini kuà'an ndo, ta chikoni'i ndo iti' kuà'an Ndioo, ikan na janaa ra ma kuati ndo. Ta takan kùu ku'va Ndioo iin tiempu vii ña koo ndo. ");
INSERT INTO mza_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Vati ni keta ora ña ni tachi ndiko Ndioo ma Jesucristu nuu ñivi ñuñivi, ti rakan kùu ra kāchin ra ña na kuu ra Cristu, ora takä'an koo ñivi ñuñivi i'ya. ");
INSERT INTO mza_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yakan va vitin ìyo yi ña kindoo ndio Jesucristu andivi, nda kati keta ora ña jàndova'a ji'na Ndioo ndisaa nakuyi. Tajan ni kichi ndiko Jesucristu ma takua kā'an Ndioo chi'in ma ndra ií ña kā'an chi'in tu'un yu'u ra, ndra chīyo taji'na, ña ni kuu yi. ");
INSERT INTO mza_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ti ma Moisés te'en kā'an ra chi'in ma ndra kūu ñivio chīyo taji'na: “Ni jaketa ma Ndioo iin ra ñivio ña ni ka'an chi'in tu'un yu'u Ndioo indukuni takua kà'in chi'in tu'un yu'u ra nuu ndo ndia. ¡Yakan va na jachi'in ndo ndisaa ma ña ni ka'an ra! ");
INSERT INTO mza_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ta ndisaa ma ndian tüvi ni jachi'in ma ña kà'an ra, tüva ni kuu na ñivi Ndioo.” Takan kāti Moisés taji'na. ");
INSERT INTO mza_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ta te'en nāka'an ndiko Petu': ―Ta ndisaa ma ndra kā'an chi'in tu'un yu'u Ndioo, nda tiempu chīyo Samuel ta iti' nuu, juuni kā'an ndra kuenda ma kivi vitin. ");
INSERT INTO mza_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ma ndra kà'an chi'in tu'un Ndioo kà'an ndra ña ni ku'va Ndioo ma ña va'a nuu ma ñivi ra. Ta ndyo'o kùu ndian ni ni'i ndo yi. Ta juuni ni ni'i ndo ma tu'un ña jāndo'iin ra chi'in ma ñivio chīyo taji'na. Ti Ndioo te'en kā'an ra yi chi'in Abraham taji'na: “Ndisaa ñivi ìyo ñuñivi ni ja'ii̱ na cha'a' ma ra kùu ñiviun ña ni koo tiá iti' nuu.” Takan kāti Ndioo. ");
INSERT INTO mza_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ti ora jānataku Ndioo ma ra Se'e ra, ji'na tāchi ra ra nuu ndyo'o ndian ñivi judíu ña na ja'ií ra ndo, ikan na ndakoo ta'ii'iin ndo ma iti' kini kuà'an ndo ta na tandikun ndo ku'un ndo ma iti' ra. ―Takan kà'an Petu'. ");
INSERT INTO mza_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petu' chi'in Xuva juuni kà'anga ndra nuu ma ñivi, ora chāa ma ndra sutu cha'nu chi'in ma ra chà'nda tiñu nuu jandaru veñu'u, chi'in ndracha'nu saduceu ña ");
INSERT INTO mza_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ya'a kùxaan ndra, ti jàna'a Petu' chi'in Xuva nuu ñivi ña nātaku ndiko Jesuu tañu ñivi ndií. Ta ña'a jàna'a yi ti ndicha ña nàtaku ndiko ma ñivi ndia. ");
INSERT INTO mza_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ta cha'a' yakan tīin ndra ndra. Ta tava cha ini kùu yi, yakan va, tī'i ndra ndra vekaa. Ta nda inga kivi ora kundichin tāva ndra ndra. ");
INSERT INTO mza_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Va kua'a' ñivi tàso'o na tu'un kàtitu'un Petu' chi'in Xuva. Ta ora ikani kīcha'a na chìnuni na tu'un Jesuu nda kati kī'vi iin u'un mii ndra'ii, iti' kuà'an Jesuu. Ta siin kùu ma ñivi ña'a' ndia. ");
INSERT INTO mza_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ta ora tuvi inga kivi, tajan kūti'vi ma ndra chà'nda tiñu nuu ñivi judíu ñuu Jerusalén, ta juuni kūti'vi ndracha'nu chi'in ndra matru jàkua'a tutu Ndioo. ");
INSERT INTO mza_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ta juuni ikan ndaa sutu Anás. Ta rakan ti, iin sutu kuxini kùu ra, chi'in Caifás, Xuva, Jandu, ta tandi'i ndra kùu ñivi sutu cha'nu ikan. ");
INSERT INTO mza_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tajan tāchi ndra tiñu nuu ma jandaru veñu'u ña na kutava ndra Petu' chi'in Xuva vekaa. Tajan chātava ndra ndra ta kūtaa ndra ndra ma'ñu ma ndra cha'nu ikan. Ta ikan jan te'en kīcha'a chìkatu'un ndra nuu Petu' chi'in Xuva: ―Ndyo'o xaa, ¿yo tāva tiñu nuu ndo a yo sivi nàka'an ndo ña jà'a ndo takan? ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Va taku ma Petu', ti ìyo ma Tati Ií Ndioo chi'in ra, ta te'en kīcha'a kà'an ra chi'in chinituni ra jā'a yi: ―Tandi'i ndyo'o ndracha'nu chi'in ndra chà'nda tiñu ma ñuu. ");
INSERT INTO mza_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿A ndyo'o, chìkatu'un ndo nuu ndi naja kua kùu yi ña ndōva'a ma ra kùkue'e i'ya? ");
INSERT INTO mza_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Va'ani. Na katitu'un ndi nuu ndo, ikan na koto ndyo'o, ta tandi'i ñivi ñuu Israel, ti ra kùkue'e i'ya, ra ndè'e ndisaa yo vitin, cha ndā'a ra jā'a juuni ma ndatu Jesucristu, ra kīchi ñuu Nazaret, ra tākaa ndo nuu kruu kùu ra. Va Ndioo jānataku ndiko ra ra. ");
INSERT INTO mza_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yakan va Jesuu kùu ma yuu ña jāchiyo ndyo'o ndra kùu labañi ña jàva'a ve'e. Ta vitin juuni yuu ikan kùu yi ña ndākuu ka'nuga yi kua tandi'i yuu ña jà'a ndo ve'e vitin. ");
INSERT INTO mza_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yakan va nï'iin inga ñivi, küu jàkakú na yo, ti töve nī cha'a Ndioo ndatu ra nuu nï'iin ñivi ñuñivi, ti nuu Jesucristuni, chā'a ra yi, ikan na jakakú ra yo. ―Takan kàti Petu' chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Yakan va ndē'e ma ndracha'nu ka'ìin ikan ña tüvi yu'vi Petu' chi'in Xuva ora kà'an ndra. Tajan ma ora ikani, numini nākuni ndra ña ndra tüvi nī cha'an jakuela kùu ndra, ti ndra nda'vini kùu ndra. Ta ndava kuà'an tati ndra ora chīni ndra ma tu'un kà'an ndra. Ta juuni nākuni ndra, ti ndra jàkua'a chi'in Jesuu kùu ndra ndia. ");
INSERT INTO mza_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yakan va ndē'e ma ndra kuxini ti, ndicha ña ndā'a ma ra kùkue'e. Ta ndaa ra chi'in ndra ndia, yakan va, na küu tisokuati ndra ma Petu' chi'in Xuva. ");
INSERT INTO mza_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ta ikan jan, ma ndra matru jàkua'a tutu Ndioo, te'en nāka'an ndra nuu ndra: ―¡Na kee ndo ma nuke'e nundani! ―kàti ndra. Ta ikan jan, kēe ndio ndra ma nuke'e nundani. ");
INSERT INTO mza_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tajan te'en kīcha'a nàtu'un ta'an ma ndra kuxini: ―¿Ta vitin, nayi ìyo yi ña ja'a yo chi'in ndra'ya? Ti ndisaa ma ñivi ñuu Jerusalén cha chìto na, ti jānda'a ndra ma ra kùkue'e. Ta küu ka'an yo nï'iin nakuyi chata ma ña va'a jā'a ndra. ");
INSERT INTO mza_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yakan va na ka'an xaan yo nuu ndra, ikan na kä'an ga ndra tiá tu'un Jesuu nuu ma ñivi, koto koto tiá ñivi ma tu'un Jesuu, ta ki'vi na iti' kuà'an Jesuu ndia. ―Takan kàti ndra ña nàtu'un ta'an ndra. ");
INSERT INTO mza_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ta takan kūu tajan chāki'in ndra Petu' chi'in Xuva inga cha'a', tajan te'en kīcha'a kà'an ma ndra kuxini chi'in ndra: ―¡Tuva kùuni ndi ña jana'aga ndo, nï'iin ga tu'un kà'an cha'a' Jesuu nuu nï'iin ñivi ma tiá iti' nuu! ―Takan kàti ma ndra kuxini chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Va Petu' chi'in Xuva, te'en nāka'an ndra chi'in ndra: ―¿Naja kua chànini ndo, a tiá va'a kuenda Ndioo tu jà'a ndi tiñu kà'an ndo a tiñu kà'an Ndioo?, kùuni ndo. ");
INSERT INTO mza_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Va taku ndyu'u, ti küu ndakoo ndi ña kàtitu'un ndi nuu ma ñivi ndisaa ma ña ndē'e ndi ta chīni ndi cha'a' Racha'nu Jesuu ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yakan va ma ndra chà'nda tiñu veñu'u jāyu'vi ndiko ndra ndra, va jāña ndiko ndra ndra. Ti tüvi nī ni'i ndra naja kua jande'e ndra tundo'o ndra, ti ndisaa ma ñivi jàka'nu na Ndioo cha'a' ma ña va'a ña jā'a ndra. ");
INSERT INTO mza_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ta ma ra ndā'a jā'a ma ndatu Jesuu, cha yā'a nduu ra uvi xiko kuiya ra. ");
INSERT INTO mza_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Takan kūu ta ora jāña ndra ma Petu' chi'in Xuva, ta kīchaa ndra nuu ka'ìin inga ma ndian chìnuni. Ta kīcha'a ndra kàtitu'un ndra nuu na ndisaa tu'un ña kā'an ma ndra sutu cha'nu chi'in ndracha'nu ndia. ");
INSERT INTO mza_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ta ora chīni na ma tu'un kātitu'un ndra, tajan iin nuuni te'en kīcha'a ndio na kà'an na chi'in Ndioo: ―Yo'o, Ndioo chito'o yo, ña jā'a ña tūvi ma andivi ta ñuñivi ta tañu'u ta ndisaa ña ìyo nuu yi ndia. ");
INSERT INTO mza_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Juuni maun, kā'an nuu ma Tati Iíun ña na ka'an yi nuu ma ra kūu ñivio, racha'nu David, ra kūu musu̱n taji'na chi'in tu'un i'ya: ¡Na tüvi va'a jà'a ma ñivi ña xaani na nde'e na Ndioo, ta juuni tüvi va'a jà'a na, ña chànini na iin tiñu ña töve va'a! ");
INSERT INTO mza_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Va ma ndra kùu rey chi'in inga ndra chà'nda tiñu nuu ñu'u' ñuñivi, kūti'vi ta'an ndra ña kùuni ndra kanita'an ndra chi'in Racha'nu Ndioo, ta chi'in ra kùu Cristu, ra kāchiun. Takan kà'an ma tutu̱n, yo'o Racha'nu. ");
INSERT INTO mza_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ta ndicha ña takan kūu ma kua kà'an yi, yo'o Racha'nu. Vati kūti'vi ta'an ma Rey Herode chi'in Ponciu Pilatu ñuu i'ya, chi'in ñivi judíu ta ñivi yüvi judíu, ña kūuni ndra ka'ni ndra se'un Jesuu, ta rakan ti iin ra ií, ra kāchiun ña na kùu ra Cristu, kùu ra. ");
INSERT INTO mza_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yakan va takan jāchinu ndra ma tiñu ña kāchiun ña ni ja'a ndra niku, yo'o Racha'nu Ndioo, ti maun, cha chìto va'un, ti takan ni kuu yi, ora takä'an ja'a ndra yi. ");
INSERT INTO mza_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ta vitin, yo'o Racha'nu Ndioo chito'o yo, ¡na ki'in kuendaun ma tu'un xaan ña kā'an ndra sutu cha'nu chata ndi! ¡Ta na ku'vaun, ma tundeeniun nuu ndyu'u ndian kùu musu̱n, ikan na yü'vi ndi ora kàtitu'un ndi ma tu'u̱n! ");
INSERT INTO mza_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ta na nda'a ma ndian ku'vi jà'a ma ndatun, ikan na kuu nde'e ma ñivi kua'a' tiñu ka'nu ta seña ña jà'un chi'in sivi ma se'un Jesuu, ra ya'a ga ií. ―Takan kà'an ndra chi'in Ndioo. ");
INSERT INTO mza_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tajan ora chīnu ña kā'an ndra chi'in Ndioo, tajan kīcha'a tàan ma nuu ka'ìin ti'vi ndra. Ta juuni ma ora ikan, nī'i na ndatu, jā'a ma Tati Ií Ndioo. Ta ikan jan, kēe ndio ma ña ndasii na, ta na tüva yu'vi ndio na, ña kàtitu'un na tu'un Ndioo nuu ñivi. ");
INSERT INTO mza_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Takan kūu ta ndisaa ma ndian chìnuni inuuni chànini na, vaji ya'a kua'a' na. Ta juuni kàti na ti ma ndatiñu ñà'a na juuni ñà'a ndisaa na kùu yi ndia. Tüvi kàti na ña ñà'a ma'iin na kùu yi. ");
INSERT INTO mza_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Chi'in ndatu ka'nu Ndioo, jàna'a ma ndra tatun Jesuu, nuu ma ñivi ña ndicha kuii ña nātaku ndiko Racha'nu Jesuu. Ta juuni chà'a Ndioo ma ñamani ra nuu ndisaa na. ");
INSERT INTO mza_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yakan va nï'iin ma ndian chàkunuu chi'in ndra, tüvi kùmani nï'iin nakuyi nuu na. Ti ndian ìyo ñu'u' a ve'e, xìko na yi, ta takan nì'i na xu'un', ");
INSERT INTO mza_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tajan chà'a ndio na yi nuu ma ndra kùu tatun Jesuu, na nata'vi ndra yi nuu ma ndian chìniñu'u yi. ");
INSERT INTO mza_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Takan kūu tajan ña'a kùu yi takua jā'a iin ra nàni Kusé, ra kùu ñivi Leví, ra kīchi ñuu nàni Chipre. Ra'ya, jākunani ma ndra tatun Jesuu ra, Bernabé, ti ma sivi ikan kùuni yi kà'an yi: Ra ya'a jàndomani inga ñivi. ");
INSERT INTO mza_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tajan ra'ya kùu ra ña ìyo iin ñu'u' ra, ta xīko ra yi, ta chā'a ra ma xu'un' nuu ma ndra kùu tatun Jesuu. ");
INSERT INTO mza_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ìyo iin ra nàni Ananía chi'in ñasi'i ra Safira. Ta vikan, ti ni nduvi vi xīko vi iin ñu'u' vi, ta nī'i vi xu'un'. ");
INSERT INTO mza_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ta ma ra'ya, ti ndāki'in xe'e ra java ma xu'un' xīko ra ñu'u' ra chi'in ma ñasi'i ra, vati nda maa ña chìto va'a ña ma ña jā'a ra ndia. Ta inga java yi, chāndaka ra yi nuu ndra tatun Jesuu, ta kàti ra ti ña'a kùu tandi'i ma xu'un' nī'i ra. ");
INSERT INTO mza_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ta nāka'an Petu' chi'in ra: ―Yo'o Ananía, ¿ta naja chā'un ña kī'vi ma kui'na tichi animaun? Ta vitin ti cha kī'viun iti' kini, ta kùuniun tavaun iin tu'un vata nuu Tati Ií Ndioo, vati tīndixe'un java ma xu'un' kuendaun cha'a' ma ñu'u' xīkoun. ");
INSERT INTO mza_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndicha ti ñu'u' maun kùu yi, ta ndicha kuii ti kùu xikoun yi ta ni'un xu'un' cha'a' yi, tuva kùuniun. ¿Va naja chāniniun ka'un tu'un vata ora nī'un ma xu'un' cha'a' yi, tuva yöve takan kùu yi? Yakan va ma tu'un vata ña já kā'un, tüvi nī ka'un yi nuu ndyu'uni, vati juuni kà'un yi nuu Ndioo ndia. ―Takan kàti Petu' chi'in ra. ");
INSERT INTO mza_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tajan ora chīni Ananía ma tu'un kā'an Petu' nuu ra, tajan ma ora ikani ndūva ra ta chī'í ra. Ta ma ñivi ka'ìin ikan, ora chīto na ña chī'í ra, ta kīcha'a na yù'vi ndio na. ");
INSERT INTO mza_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tajan ma ora ikani kīchaa iin ndra yoko tīsukun ndra ja'ma ma ñunda'yu ra. Ta kuà'an yi chi'in ndra nuu ni kuchi yi. ");
INSERT INTO mza_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ta tichi iin uni ora, tajan chāa ma ñasi'i Ananía, ta kī'vian ma nuu ka'ìin ndra. Va tüvi chìtoan ña cha chī'í ma iian. ");
INSERT INTO mza_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tajan te'en kīcha'a chìkatu'un Petu' nuan: ―Kùuni̱ ña na ka'un ma tu'un ndaa nui. ¿A ndicha ña ma xu'un' i'ya kùu ndisaa ma xu'un' nī'i ndo cha'a' ma ñu'u' xīko ndo? ―kàti ra. Ta te'en nāka'an ña: ―¡Juu! Ndicha kuii ña takan xīko ndi yi. ");
INSERT INTO mza_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tajan te'en nāka'an ndiko Petu' nuan: ―¿A kuu janda'viña'a ndo ma Tati Ií Ndioo, kùuni ndo ña kà'an ndo takan? ¡Na küu yi! Ti chiña cha vàchi ma ndra chākuchi ma iiun. ¡Ta nda maun, ni kukuchi ndra vitin ndia! ―kàti ra chi'an. ");
INSERT INTO mza_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ta ora nāka'an ra te'en, ta juuni ma ora ikani ndūva ma Safira yatin nuu ndaa ra, ta chī'an ndia. Ta ora kī'vi ndiko ma ndra yoko ma tichi ve'e ikan, ta ndē'e ndra ña cha chī'an. Tajan ndāki'in ndio ndra ma ñunda'yuan ta kuàndaka ndra yi ña na kuchi yi iti' xiin ma iian. ");
INSERT INTO mza_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ta ora chīto ndisaa ma ñivi veñu'u ña te'en kūu, tajan ndisaa na yū'vi na. ");
INSERT INTO mza_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Takan kūu ta Ndioo jàna'a ra kua'a' ndatu ta seña nuu ma ñivi, jà'a ma ndra tatun Jesuu. Ta ndisaa ma ndian chìnuni, inuuni chànini na ta kùti'vi na tichi kora veñu'u ka'nu nuu ìyo corredor nàni Salomón. ");
INSERT INTO mza_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ta ndisaa inga ñivi ñuu, töve kànani na ña tìta'an na chi'in na ma nuu ka'ìin tì'vi na, vaji ya'a ga tìñu'u na na. ");
INSERT INTO mza_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Va endee kì'vi tiá kua'a' ñivi iti' kuà'an Jesuu, ñivi ña'a ta ra'ii ndia, vati chìnuni na tu'un ra. ");
INSERT INTO mza_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Takan kūu tajan tāvani'i ma ñivi ma ndian ku'vi ma yu'u kai kùtu chi'in chito na ta yuvi na. Ikan ora ni ya'a Petu', vaji tu vatini ra, na ya'a chata na, ikan na nda'a na, kùuni na. ");
INSERT INTO mza_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ta juuni, kīchakoyo ñivi ìyo ñuu yatin xiin ñuu Jerusalén, kùtu ndiso na ndian ku'vi chàa na. Ta juuni kīchakoyo na chi'in ndian ndiso tati xaan ndia. Ta ndisaa na ndā'a na ma ora ikan. ");
INSERT INTO mza_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tajan kūti'vi ta'an tuku ma ra sutu chà'nda tiñu chi'in sutu meru ra ta ndra saduceu, ña nàtu'un ta'an ndra, ti ya'a tixin ndra ndè'e ndra ña jà'a ma ndra tatun Jesuu. ");
INSERT INTO mza_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tajan ma ora ikan tāchi ndra ma jandaru, ta tīin ndra ma ndra tatun Jesuu, ta tī'i ndra ndra vekaa. ");
INSERT INTO mza_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Va ora chanikuaa ora ka'ìin ndra tichi vekaa, chāa iin tati va'a ña jà'a tiñu nuu Ndioo. Ta nūna yi ma yuve'e nuu ka'ìin ndra, ta tāva yi ndra. Tajan te'en nāka'an yi chi'in ndra: ");
INSERT INTO mza_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―¡Kua'an ndo tichi kora veñu'u ka'nu! ¡Ta na katitu'un ndo nuu ñivi ka'ìin ikan naja kua kuu kakú na, ikan na ni'i na ña na koo va'a na chi'in Ndioo! ―kàti yi chi'in ndra. ");
INSERT INTO mza_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ta ora kā'an yi te'en nuu ndra, ta inga kivi ora tuvi tajan kēe ndio ndra kuà'an ndra tichi kora veñu'u ka'nu. Ta ikan kīcha'a ndra jàna'a ndra nuu ma ñivi. Tajan juuni ma ora ikan, kūti'vi ndiko ma sutu chà'nda tiñu chi'in inga ndracha'nu ìyo ñuu Israel ña jà'a ndra iin junta ka'nu cha'a' ma ndra tatun Jesuu ña ka'ìin tichi ma vekaa. Tajan tāchi ndra ma ndra jandaru ma vekaa ña na kuki'in ndra ndra. ");
INSERT INTO mza_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ta ora chāa ma ndra jandaru ma vekaa, ta nānduku ndra ndra. Ta töva nī nata'an ndra ndra. Ta yakan va chīkoni'i ndiko ndra nuu ka'ìin ma ndracha'nu jà'a junta. ");
INSERT INTO mza_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ta te'en nāka'an ndra chi'in ndra: ―Ora chāa ndi ma vekaa, ta ndē'e ndi ma yuve'e ña ndàsi va'a yi. Ta juuni ndē'e ndi ña ka'ìin ma ndra kùmi ma yuvekaa. Va ora nūna ndi ta kī'vi ndi tichi yi, ta ndē'e ndi ña töva ma ndra ka'ìin tichi yi. ―Takan kàti ma ndra jandaru chi'in ma ndracha'nu ikan. ");
INSERT INTO mza_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Takan kūu ta ora chīni ma ndra sutu cha'nu kuxini chi'in ra capitán jandaru ma veñu'u ña kà'an ndra, tajan te'en kīcha'a ndra nàkanini ndra: ―¿Nayi ni kuu tiá iti' nuu cha'a' ña kūu takan? ―kùuni ndra. ");
INSERT INTO mza_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ta ora juuni kà'anga ndra te'en, ta juuni ma ora ikani chāa iin ra nuu ka'ìin ndra ta te'en kàti ra chi'in ndra: ―Ma ndra, tī'i ndo tichi vekaa, ndakan ka'ìin ndra tichi kora veñu'u ka'nu jàna'a ndra nuu kua'a' ñivi ―kàti ra. ");
INSERT INTO mza_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yakan va, kuà'an ma ra capitán chi'in jandaru ra, kuàtiin ndiko ndra ma ndra tatun Jesuu. Va tüva nī jati'ini ndra chi'in ndra, ti ndasii ndra ña jàtindikun ma ñivi ndra chi'in yuu. ");
INSERT INTO mza_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tajan ora chāa ndiko ma ndra jandaru ma nuu kùu junta jà'a ma ndracha'nu, tajan chāndaka ndra ndra nuu ka'ìin ma ndracha'nu chà'nda tiñu. Ta te'en kīcha'a chìkatu'un ma sutu chà'nda tiñu nuu ma ndra tatun Jesuu: ");
INSERT INTO mza_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Ta naja tüvi jà'a ndo ma ña kātitu'un ndi nuu ndo? ¿A tüvi chàku'uni ndo ora kā'an xaan ndi ña na tüva ìyo yi ña ja'a ndo ña jàna'a ndo tu'un Jesuu nuu ma ñivi? Va ndyo'o ti tüvi nī jachi'in ndo ma ña kā'an ndi nuu ndo. Ta vitin tandi'i ñivi ñuu Jerusalén i'ya, cha chìto na ndisaa ma ña jàna'a ndo. Ta juuni kà'an ndo ña maa ndi kùu ma ndra chā'ni Jesuu. ―Takan kàti ma ndra sutu cha'nu nuu ndra. ");
INSERT INTO mza_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tajan nāka'an Petu' chi'in inga ma ndra tatun Jesuu te'en nuu ma ndra sutu cha'nu: ―Ìyo ga yi ña jà'a ndi ma tiñu kà'an Ndioo, kua ma tiñu kà'an ndyo'o ndian kùu ñivini. ");
INSERT INTO mza_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Vati Ndioo, ra kùmi ñivio ndian chīyo taji'na, juuni rakan kùu ra ña jānataku ndiko ra Jesuu. Ta Jesuu ikan kùu ra ña chā'ni ndo nuu kruu ndia. ");
INSERT INTO mza_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ta vitin Ndioo kāni'i ra ra ta jākunandi ra ra chiyo kua'a ra nuu ìyo ndatu ra. Ta juuni Ndioo ikan, kùu ra ña chā'a ra ndatu ra nuu Jesuu ña na jakakú ra yo, ta ka'nda ra tiñu nuu yo ndia, ikan na ndikoni'i yo iti' Ndioo, ta ndakuu yo ndian cha jānaa Ndioo kuati. ");
INSERT INTO mza_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ta cha'a' ña'a ndyu'u chìto ndi ti ña ndicha kùu yi. Ta nda ma Tati Ií Ndioo, chā'a yi kuenda naja kua kūu yi ndia, vati induku ìyo yi chi'in ndi, ti chà'a Ndioo yi ña na koo yi chi'in ndisaa ndian jàchi'in ña kà'an ra. ―Takan kàti Petu' chi'in ma ndra sutu cha'nu. ");
INSERT INTO mza_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ta ora chīni ma ndracha'nu ka'ìin ti'vi, ma tu'un kà'an ma ndra tatun Jesuu, tajan nduva'a kuii kāyuni ndra, ta kūuni ndra ka'ni ndra ndra. ");
INSERT INTO mza_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Va tañu ma ndracha'nu ikan ndaa iin ra fariseu, ra nàni Gamaliel. Ta rakan ti kùu ra iin matru jàkua'a tutu Ndioo. Ta tìñu'u ma ñivi ra ti matru va'a kùu ra. Ta ma ora ikani, ndēta ra ta kīcha'a ra kà'an ra nuu ma ndra jandaru, ña na tava ndra ma ndra tatun Jesuu iti' nuke'e nundani ma ora ikan, vati kùuni ra natu'un xe'e ra chi'in ma meru ra. ");
INSERT INTO mza_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tajan te'en kīcha'a ra kà'an ra nuu tandi'i ma ndracha'nu ka'ìin ikan: ―Ndyo'o ndracha'nu ñuu Israel, ¡na ja'a ndo kuenda nuu ndo cha'a' ña ni ja'a ndo chi'in ndra'ya! ");
INSERT INTO mza_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","¡Na kuku'uni ndo ti taji'na chīyo iin ra chūnani Teudas! Ta rakan ti chānini ra ti iin ra ka'nu ndicha kuii kùu ra. Tajan nī'i ra iin kumi cientu ndra'ii ña chàkunuu ndra chi'in ra. Va kēta iin kivi ña chā'ni inga ñivi ma Teudas. Ta ma ndian chàkunuu chata ra, chīnu ndra kuà'an ndra. Ta ikan ndī'i ndisaa ma tiñu jà'a ra vati tüvi nda kuenda ma ña jā'a ra. ");
INSERT INTO mza_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ta iti' nuuga chīyo inga ra chūnani Juda, ra ñuu Galilea. Ta ma tiempu ikan kùu ma kivi nākuiso na sivi ñivi. Ta rakan ti juuni nī'i ra kua'a' ñivi ña kàkunuu chi'in ra. Va indukuni tā'an ra vati juuni chā'ni ma ñivi ra. Ta juuni chīnu ma ndian chàkunuu chi'in ra kuà'an na ndia. ");
INSERT INTO mza_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yakan va yu'u, kùuni katitu'in iin ma ña ndaa nuu ndo. ¡Na jaña ndo ña kànita'an ndo chi'in ma ndra tatun Jesuu i'ya! Ti tu tu'un ñivini kùu ma ña kàtitu'un ndra, kùu ya'a yi numini. ");
INSERT INTO mza_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Va tu tiñu Ndioo kùu ma ña jà'a ndra, na küu jakutaxin ndo ndra. ¡Yakan va na ja'a ndo kuenda nuu ndo, ta koto känita'an ndo chi'in Ndioo! ―Takan kàti racha'nu Gamaliel chi'in ma ndra jà'a junta. ");
INSERT INTO mza_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ta ikan jan, jāchi'in ndio ndra ma ña kà'an ra. Yakan va chāki'in ndiko ndra ma ndra tatun Jesuu, ta kāni ma ndra jandaru ndra chi'in yo'o. Tajan te'en nāka'an ma ndracha'nu nuu ndra: ―¡Na jaña ndo ña kàtitu'un ndo tu'un Jesuu nuu ñivi! ―kàti ndra. Tajan ma ora ikani jāña ndra ma ndra tatun Jesuu na ku'un ndra. ");
INSERT INTO mza_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Takan kūu ta ora kēe ndio ndra kuà'an ndra, tajan nduva'a kuii chìsii ndio ndra, ti Ndioo chā'a ña na nde'e ndra tundo'o cha'a' ma tu'un Jesuu ña kàtitu'un ndra. ");
INSERT INTO mza_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ta ndisaa kivi kàtitu'un ndra, ta jàna'a ndra tu'un va'a Jesuu, ra kùu Cristu, nda nikuuni ve'e ñivi a veñu'u ka'nu ñuu Jerusalén. ");
INSERT INTO mza_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Takan kūu yakan va ma tiempu ikan, tiá ndōkua'a' ma ñivi chìnuni tu'un Jesuu. Ta tañu na, juuni ìyo ndian kà'an tu'un griegu, ta juuni ìyo ndian kà'an tu'un hebreu. Ta kīcha'a ma ñivi ña'a, ndian kà'an tu'un griegu kànita'an yu'u vi chi'in ma ñivi kà'an hebreu, ti kàti vi ti ñivi ña'a griegu ña ndōo nda'vi, töve nì'i induku vi ma ndatiñu ña chìniñu'u vi kua inga vi ña kīndoo nda'vi. Vati ma ndian chìnuni jàchaa na ña kachi vi nani kivi. ");
INSERT INTO mza_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yakan va ndi uchi uvi ma ndra tatun Jesuu, jākuti'vi ta'an ndra chi'in ndisaa ma ndian chìnuni tu'un Jesuu, tajan te'en nāka'an ndio ndra chi'in na: ―Töve va'a ña jàña ndi ña kàtitu'un ndi tu'un Ndioo, kua ña jacha ndi ña kachi ñivi ti na küyati ndi ja'a ndi nduvi tiñu. ");
INSERT INTO mza_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yakan va ndyo'o yani, ¡va'aga ña ku'un ndo kachin ndo ucha ta'an ma ndra iñu'u ña ìyo tañu ndo! Va nanduku ndo ma ndra ìyo chinituni, ta ìyo Tati Ií Ndioo chi'in ndia. Ta nuu ndrakan ìyo yi ña ku'va yo ma tiñu i'ya, ikan na jacha ndra ña kachi ma ñivi ña'a nda'vi. ");
INSERT INTO mza_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yakan va ndyu'u, endeeni kà'an ndi chi'in Ndioo, ta juuni endeeni kàtitu'un ndi ma tu'un Jesuu chi'in inga ñivi ndia. ");
INSERT INTO mza_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yakan va iin tu'uni ndōo ndisaa na. Ta kāchin na iin ra nàni Esteban. Ta rakan ti iin ra ya'a ga chìnuni ma tu'un Jesuu ta jàchi'in va'a ra ña kà'an ma Tati Ií Ndioo. Takan kūu ta juuni kāchin ndra ra nàni Lipe, Prócoro, Nicanor, Timón, Parmenas chi'in iin ra nàni Kula ndia. Ta rakan ti iin ra judíu ña kīchi ñuu Antioquía kùu ra. Vati yüvi ra judíu kùu ra niku. ");
INSERT INTO mza_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ta ora cha kāchin ndra ndra, tajan chājana'a ndra ndra nuu ka'ìin ma ndra tatun Jesuu. Ta ikan ndra tatun Jesuu jūndii ndra nda'a' ndra xini ndra, ta kīcha'a kà'an ndra chi'in Ndioo kuenda ndra cha'a' ma tiñu ni ki'vi ndra. ");
INSERT INTO mza_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yakan va kuàndokua'aga ma ndian chìnuni ñuu Jerusalén jà'a ma tu'un Ndioo ña kàtitu'un ma ndra tatun Jesuu. Ta juuni ìyo iin ndra sutu veñu'u judíu ña cha kīcha'a jàchi'in ndra tu'un Jesuu ndia. ");
INSERT INTO mza_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Va tava ìyo ñamani, ta ndatu Ndioo chi'in Esteban, yakan va chi'in ma ndatu ikan, jàna'a ra kua'a' seña ta tiñu ka'nu nuu ñivi ñuu ikan. ");
INSERT INTO mza_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Va chāa iin kivi ña chīkuta'an ndra judíu chi'in Esteban. Ta ndrakan ti ndra kīchi iti' veñu'u ndian judíu ña nàni: Veñu'u Ñivi Cha Kākú Nuu Tundo'o. Ta tañu ndra ìyo ndra kīchi ñu'u' Cirene, ta ñu'u' Alejandría. Juuni ìyo ndra kīchi ñu'u' Cilicia ta ñu'u' Asia. Ta ikan jan kīcha'a ndra kànita'an yu'u ndra chi'in Esteban. ");
INSERT INTO mza_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Va nï'iin ma tu'un kà'an ndra, tüvi nī tandaa yi ma tu'un kà'an ra. Ti ma tu'un ikan chi'in chinituni ma Tati Ií Ndioo kà'an ra yi. ");
INSERT INTO mza_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yakan va ma ndrakan, tīa'vi ndra inga ndra ña na tisokuati ndra Esteban. Tajan ndrakan te'en nāka'an ndio ndra chata ra: ―Ra'ya kùu ra ña chīni ndi ña endee kà'an ti'ini chata Moisés ta chata Racha'nu Ndioo ndia ―kàti ndra. ");
INSERT INTO mza_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Takan kūu yakan va, te'en jā'a ndra ña jākayuni ndra ma ñivi ñuu ikan, chi'in ndracha'nu, ta ndra matru jàkua'a tutu Ndioo ndia. Tajan tīin ndio ndra Esteban, ta chāndaka ndra ra nuu kùti'vi sutu cha'nu chi'in ndracha'nu judíu. ");
INSERT INTO mza_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ta juuni nānduku ndra ma ndra tìsokuati ndra chata chi'in tu'un vata. Tajan te'en nāka'an ndio ndra chata ra: ―Ra'ya kùu iin ra endee küuni jaña ra ña kà'an ti'ini chata veñu'u ka'nu yo ta chata tu'un Ndioo tāa Moisés taji'na ndia. ");
INSERT INTO mza_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ta juuni chīni ndi ña kà'an ra ti Jesuu, ra ñuu Nazaret, ni janduva ra veñu'u ka'nu i'ya, ta ni sama ra ndisaa ma costumbre ña kā'an ma racha'nu Moisés, ña ìyo yi ña ja'a yo. ―Takan kà'an ndra. ");
INSERT INTO mza_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yakan va ma ndra sutu cha'nu, ta ndisaa ma ndian ka'ìin ikan, ora ndē'e ndra nuu Esteban ña kàa yi takua kàa nuu iin tati va'a jà'a tiñu nuu Ndioo. ");
INSERT INTO mza_vpl VALUES ("AC7_1","074_7_1","