﻿USE sofia;
DROP TABLE IF EXISTS sofia.myy_vpl;
CREATE TABLE myy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES myy_vpl WRITE;
INSERT INTO myy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraham ñayorʉ ito yicõri David ñayorʉ janerãbatia janami ñayijʉ Jesús. Jesús ñicʉsabatia wame mʉare gotigʉ ya yʉ. Ado bajiro wame cʉtiyoyijarã ĩna: ");
INSERT INTO myy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ñayorʉ macʉ ñayijʉ Isaac. Ito bero Isaac macʉ ñayijʉ Jacob. Jacob macʉ ñayijʉ Judá. Ito yicõri gãjerã ĩ ocabaji mesa cʉni ñayijarã. ");
INSERT INTO myy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá rĩa ñayijarã Fares ito yicõri Zara wame cʉtirã. Ĩna jaco ñayijo Tamar. Ito bero Fares macʉ ñayijʉ Esrom. Esrom macʉ ñayijʉ Aram. ");
INSERT INTO myy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram macʉ ñayijʉ Aminadab. Aminadab macʉ ñayijʉ Naasón. Naasón macʉ ñayijʉ Salmón. ");
INSERT INTO myy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón macʉ ñayijʉ Booz. Ĩ jaco ñayoyijo Rahab. Ito bero Booz macʉ ñayijʉ Obed. Ĩ jaco ñayoyijo Rut. Obed macʉ ñayijʉ Isaí. ");
INSERT INTO myy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí macʉ ñayijʉ Ʉjʉ David wame cʉtigʉ. David macʉ ñayijʉ Salomón. Ĩ jaco ñayijo Urías ñayorʉ manojo godogo. ");
INSERT INTO myy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ito bero Salomón macʉ ñayijʉ Roboam. Roboam macʉ ñayijʉ Abías. ");
INSERT INTO myy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Abías macʉ ñayijʉ Asa. Asa macʉ ñayijʉ Josafat. Josafat macʉ ñayijʉ Joram. Joram macʉ ñayijʉ Uzías. ");
INSERT INTO myy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías macʉ ñayijʉ Jotam. Jotam macʉ ñayijʉ Acaz. Acaz macʉ ñayijʉ Ezequías. ");
INSERT INTO myy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías macʉ ñayijʉ Manasés. Manasés macʉ ñayijʉ Amón. Amón macʉ ñayijʉ Josías. ");
INSERT INTO myy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías macʉ ñayijʉ Jeconías. Ito yicõri ĩ ocabaji mesa cʉni ñayijarã. Ito bajiro ĩna baji ñarijʉ Babilonia gãna Israel sita gãnare ñia ãmi wacõri ĩnare moari masa cʉtiyijarã ĩna ya cʉtojʉ. ");
INSERT INTO myy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ito bero mʉcana Jeconías macʉ ñayijʉ Salatiel. Salatiel macʉ ñayijʉ Zorobabel. ");
INSERT INTO myy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel macʉ ñayijʉ Abiud. Abiud macʉ ñayijʉ Eliaquim. Eliaquim macʉ ñayijʉ Azor. ");
INSERT INTO myy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor macʉ ñayijʉ Sadoc. Sadoc macʉ ñayijʉ Aquim. Aquim macʉ ñayijʉ Eliud. ");
INSERT INTO myy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud macʉ ñayijʉ Eleazar. Eleazar macʉ ñayijʉ Matán. Matán macʉ ñayijʉ Jacob. ");
INSERT INTO myy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob macʉ ñayijʉ José. Ĩ ñayijʉ María manʉjʉ. Iso ñayijo Dios ĩ cõarʉ Jesucristo jaco. ");
INSERT INTO myy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham rĩa janerãbatia David ĩ ñayorajʉna catorce masa ñasʉoyijarã. Abraham macʉ ñayijʉ Isaac. Isaac macʉ ñayijʉ Jacob. Ito bajiro mani cõĩa ruji waja David ĩ ñarajʉna catorce ñarã ñayijarã ĩna. Ito bero mʉcana David macʉ ñayijʉ Salomón. Salomón macʉ ñayijʉ Roboam. Ito bajiro mani cõĩa ruji waja, Babiloniajʉ Israel sita gãnare ĩna ãmi warajʉna mʉcana catorce ñayijarã ĩna. Jeconías macʉ ñayijʉ Salatiel. Salatiel macʉ ñayijʉ Zorobabel. Ito bajiro mani cõĩa ruji waja Cristo ĩ rujearajʉna catorce ñayijarã mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesús ĩ rujeare gaye ado bajiro bajiyijʉ: José manojo ñaroco ñayijo María. José rãca iso ñaroto riojʉajʉ Espíritu Santo ĩ masirisena ĩ queo sãjare macʉ sãñagõ ñayijo iso. ");
INSERT INTO myy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José iso manʉjʉ ñarocʉ queno yigʉ ñayijʉ. Ito bajiri masa ĩna tiro riojo bojoro iso tõbʉjaroca yi ãmobisijʉ José. Ito bajiri masa ĩna masibeto, “Mʉre ãmobea yʉ”, yi ãmobojayijʉ José isore. ");
INSERT INTO myy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ito bajiro ĩ tʉoĩa cani waroca, ĩ cãirojʉ Dios ñaro gagʉ ángel goaĩoyijʉ ĩre. Goacõri ado bajiro gotiyijʉ ángel ĩre: —Tʉoya José David ñayorʉ janami mʉ. Maríare manojo cʉti güibesa mʉ. Espíritu Santo ĩ masirise, ĩ queo sãjare macʉ sãñagõ ñamo iso. ");
INSERT INTO myy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Macʉ rʉcogo yigõji iso. Jesús wame wõgʉ̃ yigʉja mʉ ĩre. Masare ĩna ñeñaro yirise waja yicõri masogʉ̃ yiguĩji ĩ. Ito bajiri Jesús wame cʉtigʉ yiguĩji ĩ, yiyijʉ ángel Josére. ");
INSERT INTO myy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Diore goti ĩsiri masʉ, “Ado bajiro rẽtaro yiroja”, ĩ yiado bajiroti rẽtayijʉ. Dios ĩ bʉsire gotigʉ ado bajiro yiyijʉ Diore goti ĩsiri masʉ: ");
INSERT INTO myy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Romio ʉ̃mʉgʉ̃ rãca ajeĩabeco macʉ sãñagõ ñagõ yigõji iso. Ito bajiri macʉ cʉtigo yigõji iso. Emanuel yirã yirãji masa ĩre, yiyijʉ Diore goti ĩsiri masʉ. “Dios ñami mani rãca”, yireoni ña iti Emanuel yire. ");
INSERT INTO myy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ito bajiri yujigʉti ángel ĩ gotiado bajiroti yiyijʉ ĩ. Maríare manojo cʉtiyijʉ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Iso macʉ ñasʉogʉ rʉcoroto riojʉa, manojo macʉ bajiro bajiyijʉ José maji. Iso rʉcoja bero Jesús wame yiyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea sitajʉ Belén wame cʉtiri cʉtojʉ rujeayijʉ Jesús. Iti rodori ĩ rujearoca iti sita ʉjʉ ñayijʉ Herodes wame cʉtigʉ. Iti rodori Jerusalénjʉ ejayijarã ũmacañi joeja wadiro gãna ñocõare riasotiri masa. ");
INSERT INTO myy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Iti cʉto ejacõri seniĩayijarã ĩna: —¿No ñati judio masa ʉjʉ ñarocʉ, rujearʉ? Ũmacañi joeja wadiro ñocõare ticõri, “Rujeañi ĩ”, yi masimʉ gʉa. Ito bajiri ĩre rʉ̃cʉbʉorona wadia gʉa, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ito bajiro ĩna seniĩa ucuja tʉocõri, ito gagʉ ʉjʉ Herodes bʉto tʉoĩa güiyijʉ. Ĩre bajiro riti tʉoĩayijarã iti cʉto Jerusalén gãna cʉni. ");
INSERT INTO myy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ito bajiro tʉoĩacõri paia ʉjarã, judio masa rotirise riasori masare cʉni ji ñucayijʉ Herodes. Ĩna ejaja ticõri, ado bajiro seniĩayijʉ ĩ: “¿Nojʉ rujeagʉ yiguĩjida Cristo?” yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ĩnajʉa ado bajiro yiyijarã ĩre: —Judea sita Belén wame cʉtiri cʉtojʉ rujeagʉ yiguĩji, yi ucañi sĩgʉ̃ Diore goti ĩsiri masʉ. Ado bajiro bajia ĩ ucare: ");
INSERT INTO myy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Judea sitajʉ Belén wame cʉtiri cʉto, jaibiti cʉto ñabojarocati ñasari cʉto ñaro yiroja iti cʉto. Iti cʉto gagʉ ʉjʉ ñasagʉ rujeagʉ yiguĩji. Ĩ ñagʉ̃ yiguĩji yʉ ñarã Israel sita gãna ʉjʉ. Ĩnare tirʉ̃nʉgʉ̃ yiguĩji ĩ, yiyijʉ Dios”, yi ucare ña adi, yiyijarã judio masa rotirise riasori masa. ");
INSERT INTO myy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ĩna ito yija tʉocõri, mʉcana ñocõare riasotiri masare yeyoroacã ji ñucayijʉ Herodes. Ĩna ejaja ticõri, ado bajiro seniĩayijʉ ĩ: “¿Nocãta ñocõa goasʉocati?” yi seniĩayijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ito yija Belénjʉ ĩnare wa rotiyijʉ ĩ: —Wasa ĩ macʉacãre ãmatẽña. Mʉa ĩre ti bʉjaja yʉre gotirã wadiba. Yʉ cʉni ĩre rʉ̃cʉbʉogʉ warocʉ ya, yiyijʉ ĩnare rʉogʉ. ");
INSERT INTO myy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ĩ ito bajiro rotija tʉocõri, ĩ yiro bajiroti wayijarã ĩna. Ũmacañi joeja wadirojʉ ñocõa ĩna tirʉ ĩna riojʉa wayijʉ mʉcana. Ĩ wajasaroti tuja rʉ̃gʉ̃yijʉ macʉacã ĩ ñaro weca. ");
INSERT INTO myy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ñocõagã wacõri ĩ tuja rʉ̃gʉ̃ja ticõri, bʉto wanʉyijarã ĩna, ñocõare riasotiri masa. ");
INSERT INTO myy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ñocõagã ĩ ñaro roca ñari wi sãja wacõri ĩna tija ito ñayijʉ macʉacã ĩ jaco María rãca. Ĩre ticõri ĩ riojo rijomunigãna ñini rũjũyijarã ĩna. Ito yicõri ĩre rʉ̃cʉbʉoyijarã ĩna. Ito bajiro ĩna yija bero ĩna rʉcori jedori janayijarã ĩna. Janacõri orore, ʉco queno sʉtirise, ito yicõri mirra wame cʉtirise iti ãmicõri ĩre ĩsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ito yija bero ĩna cãirojʉ, “Herodes tʉ tʉdi wabesa. Ito ñaguĩji macʉacã”, ĩ yi masime yirona, yiyijʉ Dios ĩnare. Ito bajiri iti masicõri Jerusalénjʉ rẽta wa ãmomena gaje majʉ tʉdi wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ñocõare riasotiri masa ĩna tʉdija bero ángel goayijʉ Josére ĩ cãirojʉ. Ado bajiro yiyijʉ ĩ ĩre: —Yujiya, macʉacãre, ĩ jacore cʉni Egiptojʉ ãmi rudi wasa mʉ. Itojʉ riti ñama maji yʉ mʉre gotirocõjʉti. Herodes macʉacãre sĩarocʉ ĩre ãmagʉ̃ yiguĩji, yiyijʉ ángel Josére. ");
INSERT INTO myy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ĩ ito yija bero yujiyijʉ José. Yujicõri macʉacãre, ĩ jacore cʉni Egiptojʉ ĩnare ãmi wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ito ĩna ñaroca riti godacoayijʉ Herodes. “Egiptojʉ yʉ Macʉre ji ñucagʉ̃ yigʉja yʉ”, ĩre goti ĩsiri masʉna sʉoriti Dios ĩ yija, ĩ gotiado bajiroti bajiyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ñocõare riasotiri masa ĩre goti ãmomena gaje majʉ ĩna tʉdi waja tʉocõri, bʉto junisiniyijʉ Herodes. Ito bajiri junisinigʉ̃ Belén gãna rĩaca ʉ̃mʉare ito yicõri, iti cʉto tʉ gãna rĩacare cʉni sĩa roti jeocõyijʉ Herodes ĩ ya moari masare. Jʉa rodo tʉjarãre ĩna bero rujeanare cʉni sĩa roti jeocõyijʉ Herodes. “Jʉa rodo tʉja ñocõa ĩ rujeaja bero”, ñocõare riasotiri masa ĩna yija tʉocõri, jʉa rodo tʉjarãre ito yicõri ĩna bero rujeanare cʉni sĩa roti jeocõyijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ito bajiro Herodes rĩacare ĩ sĩa rotija Diore goti ĩsiri masʉ Jeremías wame cʉtigʉ ĩ ucado robo bajiroti rẽtayijʉ. Ado bajiro ucañi ĩ: ");
INSERT INTO myy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá sita gago iso rĩare iso tʉoĩa otija ruyuyijʉ. Ito bajiro oti ñagõti ñayijo iso, Raquel rĩare otigo. Gãjerã ĩna sobojarocati yisi ãmobisijo Raquel iso rĩa godajare, yi ucayijʉ Jeremías. ");
INSERT INTO myy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Egiptojʉ José ĩ ñaroca godayijʉ Herodes. Ĩ godaja bero Egiptojʉ José ĩ ñaroca ĩ cãirojʉ sĩgʉ̃ ángel ĩre goaĩoyijʉ. Ado bajiro yiyijʉ ĩ ĩre: ");
INSERT INTO myy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Yujiya, macʉacãre ĩ jacore cʉni Israel sitajʉ ãmi tʉdi wasa. Macʉacãre sĩa ãmoana goda jedicoama ĩna, yiyijʉ ĩ Josére. ");
INSERT INTO myy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ito yija yujicõri, macʉacãre ĩ jacore cʉni Israel sitajʉ ãmi wayijʉ José. ");
INSERT INTO myy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma wacʉjʉ tʉoyijʉ José, “Herodes ñajacʉ macʉ Arquelao wame cʉtigʉ ĩ jacʉre wasoagʉ Judea sitajʉ ñayijʉ”, yija tʉoyijʉ José. Iti tʉocõri wa ãmobisijʉ ĩ itojʉ. Mʉcana itojʉ cãiyijʉ ĩ. Ito bajiro cãicõri, “Galilea sitajʉ yʉ waja quena”, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea sitajʉ ejacõri, Nazaret wame cʉtiri cʉtojʉ ñagʉ̃ wayijʉ ĩ. Diore goti ĩsiri masa, “Nazaret cʉto gagʉ ñagʉ̃ yiguĩji Jesús”, ĩna yi ucare ñajare ito bajiroti bajiyijʉ iti. ");
INSERT INTO myy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Iti rodori ito bajija bero Juan masare idé guri masʉ Judea sitajʉ yucʉ manojʉ wayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Itojʉ ejacõri masare riasogʉ, ado bajiro yiyijʉ ĩ: —Nocõ mejeti ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios. Ito bajiri mʉa ñeñaro yirise tʉoĩa bojori bʉjacõri jidicãña mʉa, yiyijʉ Juan masare. ");
INSERT INTO myy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Diore goti ĩsiri masʉ Isaías wame cʉtigʉ ĩ ucado bajiroti yiyijʉ Juan. “Ado bajiro yigʉ yiguĩji”, yirocʉ ucañi Isaías Juanre tʉoĩa yugʉ: Sĩgʉ̃ yucʉ manojʉ mʉare ado bajiro oca sẽoro gotigʉ yiguĩji: “Ñeñaro mʉa yirise jidicãña mani Ʉjʉ ĩ ejaroto riojʉa, mʉa ya ʉsijʉ ĩ queno ña masitoni. Ñeñaro yirise jidicãcõri quenarisejʉa tʉoĩaña mʉa”, yigʉ yiguĩji sĩgʉ̃, yi ucañi Isaías, Juanre tʉoĩa yugʉ. ");
INSERT INTO myy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan ĩ sãñaro yutabuju, camello joana suado ñayijʉ. Waibʉcʉ wiro ñayijʉ ĩ ya wecʉ wiro. Rujiro ñimia bayijʉ ĩ. Ito yicõri joa gaye beroa ide idiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ĩre tʉorã masa jãjarã ejayijarã. Jerusalén gãna, Judea sita gãna ito yicõri Jordán wame cʉtirisa gãna cʉni ejayijarã ĩre tʉorã. ");
INSERT INTO myy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ĩna ñeñaro yirise ĩna goti rẽtobuja, Jordán wame cʉtirisajʉ ĩnare idé guyijʉ Juan. ");
INSERT INTO myy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jãjarã fariseo gaye tʉoĩarã, ito yicõri saduceo gaye tʉoĩarã cʉni ĩna ejaja ticõri, ado bajiro yiyijʉ Juan: —Mʉare yʉ idé gure ãmoboja mʉa. Ãña rima juniro bajiro ñeñaro yirã ña mʉa. Ado bajiro tʉoĩaboja mʉa: “Dios waja ĩ seniri rʉmʉ iti ejaroca manire waja senibiquĩji Dios. Ñeñaro yirã mani ñabojarocati manire ti maicõri manire waja senibiquĩji Dios”, yi tʉoĩaboja mʉa. Ñeñaro mʉa yirise mʉa jidicãbeja mʉa tõbʉjaroca yigʉ yiguĩji Dios, yiyijʉ Juan ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mʉcana ado bajiro gotiyijʉ Juan: —Ñeñaro mʉa yirise jidicãcõri quenarise riti tʉoĩa ñaña mʉa. Ito bajiro riti yisotiba, “Quenarisejʉa tʉoĩarã ñama ĩja”, masa mʉare yi ti masitoni. ");
INSERT INTO myy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ado bajiro yi tʉoĩabesa mʉa: “Abraham ñayorʉ janerãbatia gʉa ñare waja gʉare masogʉ̃ yiguĩji Dios”, yi tʉoĩabesa mʉa. Ado bajiro bajia. Adi gʉ̃tana Abraham janerãbatia robo bajiro ĩ godo weo ãmoja, godo weo masiguĩji Dios, yiyijʉ Juan ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ito yicõri ado bajiro goti masiore ocana gotiyijʉ Juan: —Comeana yucʉre quẽarocʉ ñacãmi sĩgʉ̃. Ito bajiri yucʉ queno rica manigʉ̃re ti bʉjacõri quẽagʉ̃ yiguĩji ĩ. Ito yicõri jeana soegʉ yiguĩji ĩ. Ado bajiro yireoni ña iti: “Masa ĩna ñeñaro yirisere waja senirocʉ ñacãmi Dios. Ito bajiri ĩna ñeñaro yirise jidicãbeja ticõri, ĩnare ruyuriogʉ yiguĩji ĩ. Ito yicõri jeame ʉ̃jʉrojʉ cõagʉ̃ yiguĩji Dios ĩnare”, yiyijʉ Juan masare. ");
INSERT INTO myy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Gaje ado bajiro gotiyijʉ Juan: —“Ãna ñama ĩna ñeñaro yirise jidicãrã”, yi ĩorocʉ idenati masare idé gua yʉ. Yʉ bero rẽtoro ñasagʉ ejagʉ yiguĩji. Yʉ rẽtoro ñasagʉ ĩ ñajare ĩre bajiro rẽtoro ñasagʉ meje ña yʉ. Ĩama mʉare Espíritu Santo queo sãgʉ̃ yiguĩji ĩja. Ito bajiro mʉare queo sãcõri queno mʉare mʉa tʉoĩaroti ejabʉagʉ yiguĩji ĩ, yiyijʉ Juan masare. ");
INSERT INTO myy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gaje ado bajiro gotiyijʉ Juan ĩnare: —Yʉ bero ejagʉ trigo besegʉ bajiro yigʉ yiguĩji masare. Sĩgʉ̃ trigo otegʉ iti wirori coda batecõri ajeri riti seo masiguĩji ĩ. Ito bajiro ĩ codaja bero iti wirorire jeamejʉ soeguĩji ĩ. Yatirime meje ñaroja itime jeame. Wirori ĩ soegori ajeriama trigo ĩ seorojʉ seogʉ yiguĩji ĩ. Ito bajiro yigʉ yiguĩji mani Ʉjʉ adojʉ ejagʉ. Trigo beseado bajiroti besegʉ yiguĩji manire, yi gotiyijʉ Juan masare. ");
INSERT INTO myy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iti rʉmʉri Galilea sitana wacõri Jordán wame cʉtirisa ejayijʉ Jesús. Juan tʉjʉ ejacõri: “Yʉre idé guya mʉ”, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ito bajiro ĩ yibojarocati ĩre idé gu ãmobisijʉ Juan. Ito bajiri ado bajiro yiyijʉ ĩ Jesure: —Meje, mʉáma yʉre mʉ idé guja quena. Yʉre idé gu rotibitirʉja mʉ. Yʉ rẽtoro ñasagʉ ña mʉ. Ito bajiri mʉre idé gu masibea yʉ, yiyijʉ Juan Jesure. ");
INSERT INTO myy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ĩ ito yija tʉocõri, ado bajiro yiyijʉ Jesús ĩre: —Yʉre mʉ idé gure ãmoa yʉ. Yʉre mʉ idé guja ñajediro Dios ĩ rotiro bajiro cʉdiana mani, yiyijʉ Jesús Juanre. —Baʉ ãmoa yʉ, yicõri Jesure idé guyijʉ Juan ĩja. ");
INSERT INTO myy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús ĩ majaroca riti ũmacʉ̃jʉ macãrʉcʉ̃ro soje janayijʉ. Ũmacʉ̃jʉ Jesús ĩ ti mʉorocati bujare bajiro bajigʉna quedi sãja wadicõri Jesús joe quedi jeayijʉ Espíritu Santo. ");
INSERT INTO myy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ito bajiro ĩ quedi jeaja bero ado bajiro oca ruyuyijʉ ũmacʉ̃jʉ: —Ãni yʉ Macʉ ñami, yʉ maigʉ̃. Ĩre bʉto wanʉa yʉ, yi ruyuyijʉ oca ũmacʉ̃jʉ. ");
INSERT INTO myy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jesús ĩ idé gu rotija bero yucʉ manojʉ ĩre ãmi wayijʉ Espíritu Santo. Itojʉ Jesús ĩ ejaroca, “¿Diore riti cʉdigʉ yiguĩjida Jesús?” yirocʉ ĩre ʉsirio codeyijʉ rʉ̃mʉ́a ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jʉ̃arã masacõ rʉmʉri bare babicʉti ñayijʉ Jesús yucʉ manojʉ. Itocõ bero ñiocõyijʉ mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ĩ ito bajijare, ĩre rʉogʉ ejayijʉ rʉ̃mʉ́a ʉjʉ: —Riti Dios Macʉ mʉ ñaja adi gʉ̃tanati naju godo weogʉ yigʉja mʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ito bajiro rʉ̃mʉ́ ĩre yibojarocati: —Yibesa. Dios oca ado bajiro gotia: “Najuna riti meje catirã yirãji masa. Jeyaro Dios ocana queno wanʉ quena ñarã yirãji masa”, yi gotia Dios oca, yiyijʉ Jesús rʉ̃mʉ́re. ");
INSERT INTO myy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ĩ ito yiroca riti Jerusalénjʉ Jesure ãmi wayijʉ rʉ̃mʉ́a ʉjʉ. Ito ejacõri mʉcana Dios ya wi joejʉ Jesure ãmi mʉja wayijʉ rʉ̃mʉ́. ");
INSERT INTO myy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ito ĩre ãmi mʉja ejacõri ado bajiro yiyijʉ: —Tʉoya Jesús mʉ. Ado bajiro gotia Dios oca: Ĩ ñaro gãna ángel mesare mʉre code rotigʉ yiguĩji Dios. Mʉ quedi waja gʉ̃tagã joejʉ quedi jeacõri mʉ ya gʉbo jeabe yirona mʉre boca ãmirã yirãji ĩna, yi gotia Dios oca, yiyijʉ rʉ̃mʉ́ Jesure. Gaje ado bajiro yiyijʉ ĩ: —Riti Dios Macʉ mʉ ñaja adojʉna bubu quedi wacʉ yigʉja mʉ, yi tobʉayijʉ rʉ̃mʉ́a ʉjʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ĩ ito bajiro yibojarocati ado robojʉa yiyijʉ Jesús ĩre: —Mʉ ito bajiro yirisere cʉdibicʉja yʉ. Gaje ado bajiro gotia Dios oca tuti. Tite mʉ: “ ‘No bajiro Dios ĩ yija ticʉja yʉ’, yirocʉ ĩre ʉsirio codebesa”, yi gotia Dios oca, yiyijʉ Jesús rʉ̃mʉ́re. ");
INSERT INTO myy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ĩ ito yija tʉocõri, cogʉ gʉ̃tagʉ̃ ũmaricʉ joejʉ ãmi wayijʉ rʉ̃mʉ́ Jesure. Itojʉ ãmi ejacõri adi sita gaye quenari cʉtorire ĩo jeocõyijʉ rʉ̃mʉ́ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ito yicõri ado bajiro gotiyijʉ rʉ̃mʉ́: —Yʉre rʉ̃cʉbʉogʉ mʉ yʉ riojo rijomunigãna ñini rũjũja, adi sita ñarocõti ñarise mʉre ĩsicʉja yʉ, yi rʉoyijʉ rʉ̃mʉ́a ʉjʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ito bajiro ĩ gotibojarocati: —Wasa Satanás mʉ. Ado bajiro gotia Dios oca: “Mani Ʉjʉ Diore riti rʉ̃cʉbʉocõri cʉdija quena”, yi gotia Dios oca, yiyijʉ Jesús rʉ̃mʉ́re. ");
INSERT INTO myy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jesús ito ĩ yija tʉocõri, wacoayijʉ rʉ̃mʉ́ ĩja. Ito yija bero ángel mesa Jesure ejabʉarona ejayijarã ĩja. ");
INSERT INTO myy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","“Tubiara wijʉ ñami Juan”, yire oca tʉocõri Galilea sitajʉ tʉdi wayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Itojʉ ejacõri ĩ ñaro Nazaret wame cʉtiri cʉtojʉ tujabisijʉ Jesús. Galilea wame cʉtirita tʉnima tʉ Capernaum wame cʉtiri cʉtojʉ ñarocʉ wayijʉ Jesús. Sõjʉ meje ñayijʉ Zabulón sita ito yicõri Neftalí sita cʉni. ");
INSERT INTO myy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iti cʉtojʉ Jesús ĩ ñaja Diore goti ĩsiri masʉ Isaías wame cʉtigʉ ĩ ucayore rẽtayijʉ ĩja. Jesure tʉoĩa yugʉ ado bajiro ucayoñi Isaías: ");
INSERT INTO myy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Jordán jodejʉ Galilea wame cʉtirita ñacʉ. Itira tʉnima tʉ ñacʉ Zabulón sita ito yicõri Neftalí sita. Iti sitajʉ ñarã judio masa meje ñarãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Diore masibiticõri rãitĩaro bajiro ñarãji ĩna. Ito bajicõri sĩgʉ̃ queno busugʉre ti wanʉrã yirãji ĩna. Diore masimena ñari godanare bajiro bajirãji ĩna. Ito bajiri busugʉ ĩ ejaja ticõri, wanʉrã yirãji ĩna. Ĩna tʉo masiroca yigʉ yiguĩji ĩ. Ito bajiri mama rʉmʉ bajiro ejaro yiroja ĩnare, yi ucayoñi Isaías. Ĩ ucare bajiroti iti sitajʉ ejayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Iti sitajʉ ejacõri masare Dios oca riaso ucusʉoyijʉ Jesús. Ado bajiro gotiyijʉ: —Yoari mejeti ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios. Ito bajiri mʉa ñeñaro yirisere jidicãcõri mama ʉsi wasoaya mʉa, yi masare riaso ucuyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Itajura Galilea wame cʉtirita tʉnima wa ucugʉ wayijʉ Jesús. Ito wacʉjʉ tiyijʉ Jesús, Simón Pedro ito yicõri ĩ ocabaji Andrésre cʉni. Wai jori masa ñayijarã ĩna. Yori yucʉrina wai waya ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ĩna tʉ ejacõri ado bajiro yiyijʉ Jesús: —Yʉ rãca waya. Masare jirã yirãji mʉa, Diore ĩna masitoni, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ĩ ito yirocati yori yucʉri cũcõri, ĩ rãca sʉya wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ito yija ito sõjʉa bʉsa wa remoyijʉ Jesús. Jabeto wa remocõri tiyijʉ Jesús, Santiago, ĩ ocabaji Juanre cʉni. Zebedeo rĩa ñayijarã ĩna. Ĩna jacʉ rãca cumajʉ yori yucʉri sia queno ñayijarã ĩna. Ĩnare ticõri ĩnare jiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ĩ ito yija tʉocõri, cumajʉti ĩna jacʉre wagoyijarã ĩna. Ito bajiri Zebedeo rĩa Jesús rãca wacoayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galilea sitajʉ riaso ucu jeoyijʉ Jesús. Co cʉto rʉyabeto judio masa minijuara wi sãjacõri oca quenarise, “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca gotiyijʉ Jesús masare. Ñajediro cõrãre ĩna cõrise bajiroti ĩnare yisioyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ito bajiro cõrãre Jesús ĩ yisioja Siria sita gãna cʉni tʉo jediyijarã ĩna. Ito bajiri ñajediro cõrãre ãmi ejayijarã Jesús ĩ yisiotoni. Jeyaro ñarise cʉtirãre ãmi ejayijarã ĩna. Rʉ̃mʉ́ sãjagoana, ʉsi jedi quediana, ruduanare cʉni ãmi ejayijarã Jesús ĩ yisiotoni. Ĩna cõrise bajiroti ĩnare yisioyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","No Jesús ĩ waro jãjarã masa ĩre sʉya wayijarã. Tite. Galilea sita gãna, Decápolis cʉto gãna, Jerusalén cʉto gãna, Judea sita gãna ito yicõri Jordán wame cʉtirisa sidʉja gãna cʉni Jesure sʉya wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jãjarã masare ticõri tʉria maja wayijʉ Jesús. Itojʉ maja wacõri rujiyijʉ Jesús. Ito yija ĩ rãca riasotirã ĩ tʉ minijuayijarã. ");
INSERT INTO myy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ĩna ejaja ticõri, ado bajiro ĩnare riasoyijʉ Jesús: ");
INSERT INTO myy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—“Jaje rʉya Dios oca queno yʉ masi jeoroti”, mʉa yi tʉoĩaja, wanʉ quenarã yirãji mʉa. Ijajʉ Dios ĩ rotirojʉ ejacõri ĩ rãca rotirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Adocãta tʉoĩa riorã mʉa ñaja, wanʉ quenarã yirãji mʉa. Ijajʉ mʉa tʉoĩa riorise rẽtogʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’“Gãjerã rẽtoro ñasagʉ meje ña yʉ”, mʉa yi tʉoĩaja, wanʉ quenarã yirãji mʉa. Ijajʉ Dios ĩ goticãdo bajiroti queno bʉjarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Adocãta Diore cʉdi jeo ãmorã mʉa ñaja, wanʉ quenarã yirãji mʉa. Mʉare ejabʉagʉ yiguĩji Dios, ĩre mʉa cʉdi jeo masitoni. ");
INSERT INTO myy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Gãjerãre ti maicõri mʉa queno yija, wanʉ quenarã yirãji mʉa. Dios cʉni mʉare ti maicõri mʉare queno yigʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Dios ĩ ãmoro bajiro riti quenarise mʉa tʉoĩaja, wanʉ quenarã yirãji mʉa. Ijajʉ Diore tirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Adocãta oca quenori masa mʉa ñaja, wanʉ quenarã yirãji mʉa. Ijajʉ, “Yʉ rĩa ña mʉa”, yigʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Diore mʉa cʉdire ticõri, gãjerã mʉa tõbʉjaroca ĩna yija, wanʉ quenarã yirãji mʉa. Ijajʉ Dios ĩ rotirojʉ ejacõri, ĩ rãca rotirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Yʉre mʉa cʉdire ticõri, gãjerã mʉare aja tudija, mʉa tõbʉjaroca ĩna yija, ito yicõri mʉare ĩna bʉsitubojaja cʉni, wanʉ quenarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Diore goti ĩsiri masare cʉni ito bajiroti ñeñaro yiyijarã masa jane mejejʉ cʉni. Itire masicõri queno wanʉ quenaña mʉa. Ijajʉ Dios tʉ ejacõri ñajediro ĩ seo ĩsirisere queno bʉjarã yirãji mʉa, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mʉcana ado bajiro gotiyijʉ Jesús ĩ rãca riasotirãre: —Moa ba ãmoama masa. Ito bajibojarocati iti ocabeja ñe waja ma moa. Jʉaji iti ocarise ejabeto yiroja. Iti ocarise jedija ticõri, itire cõacõrãji masa. Ito yicõri itire cʉdarã yirãji ĩna. Moa bajiro bajirã ña mani cʉni. Mani queno yija ticõri, mani bajiro queno yi ãmorãji gãjerã cʉni. Ito bajibojarocati mani queno yibeja, “Diore tʉorʉ̃nʉña mʉa cʉni”, mani yi riasobojaja manire tʉo ãmomenaji gãjerã, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mʉcana ado bajiro gotiyijʉ Jesús: —Ñami bʉto rãitĩari ñami iti ñaja sõjʉ jea iti busuja queno ruyuroja. Tʉria joe mani cʉto menija masa jeyaro tirã yirãji jea iti busurise. Ito bajiroti mani queno yija masa jeyaro tirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sĩabusuorise mani sĩaja sotʉ rocajʉ cũmenaji mani. Sĩabusuorise sĩacõri ũmacʉ̃jʉ cũrã yirãji mani ñajediro iti wi gãna ĩna titoni. ");
INSERT INTO myy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ito bajiroti queno yiya mʉa “Queno yirã ñama Diore tʉorʉ̃nʉrã”, yi ti masirã yirãji masa jeyaro. Mʉa queno yirise ticõri mani Jacʉ ũmacʉ̃jʉ gagʉre wanʉ rʉ̃cʉbʉorã yirãji masa, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’“Moisés ñayorʉ ĩ rotirise ito yicõri Diore goti ĩsiri masa ĩna riasorisere cõarocʉ wadiñi Jesús”, yi tʉoĩabesa mʉa. Itire cõarocʉ meje wadia yʉ. Ĩna riasorisere mʉa queno tʉoĩatoni wadibʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Riti mʉare gotia yʉ. Dios ĩ rotirise ñajediro ñatĩñaro yiroja. Adi macãrʉcʉ̃ro jediroto riojʉa co wame godo cʉtibeto yiroja. Ñajediro Dios ĩ gotiado bajiroti rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","No Dios rotirisere jabeto cʉdibicʉ, “No yibea mani cʉdi jeobeja cʉni”, yi riasogʉ quenabeami. Dios rotirojʉ ejacõri ñasagʉ meje bajiro ñagʉ̃ yiguĩji ĩocʉ̃. No Dios rotirise cʉdicõri, “Jeyaro ĩ rotirise mani cʉdi jeoja quena”, yi riasogʉ ĩ ñami quenagʉ̃. Ito bajiri Dios rotirojʉ ejacõri ñasagʉ ñagʉ̃ yiguĩji ĩama. ");
INSERT INTO myy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Riti mʉare gotia yʉ. Judio masa rotirise riasori masa ito yicõri fariseo gaye tʉoĩarã ĩna queno yibojado rẽtoro mʉa queno yibeja Dios rotirojʉ ejamenaji mʉa, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mʉcana gaje ado bajiro gotiyijʉ Jesús: —Jane mejejʉ gãna ĩna rotigore tʉogoana ña mʉa. Ado bajiro bajia iti: “Gãjire sĩabesa. No gãjire sĩagʉ̃ti ĩre waja senigʉ̃ yiguĩji Dios”, yi rotiyijʉ Moisés ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yʉama ado bajiro mʉare goti remoa: No gãjire junisini tigʉre waja senigʉ̃ yiguĩji oca quenori masʉ. No gãjire bʉsitugʉre waja senirã yirãji oca quenori masa. No, “Rocati mecʉri masʉ ña mʉ. Jeame ʉ̃jʉrojʉ warʉja mʉ”, yigʉti ĩjʉare waja senirocʉ ĩre cõagʉ̃ yiguĩji Dios jeame ʉ̃jʉrojʉ, ya yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Itire masicõri, gaje ocare cʉni tʉoĩaña mʉa. Diore rʉ̃cʉbʉorã ĩna soe ĩsira casabojʉ ejacõri, “Gãji rãca oca cʉtia yʉ”, mʉa yi tʉoĩa bʉjaja Diore rʉ̃cʉbʉorona ecarʉre sĩacõri soebeja maji. ");
INSERT INTO myy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Itire cũña maji. Itire cũcõri oca quenorona mʉa baba tʉ wasa. Ĩ rãca oca quenocõri Diore soe ĩsirona tʉdi waja quena, ya yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Gaje ado bajiro bajia. Gãji mʉare ĩ seti yija oca quenori masʉ tʉjʉ mʉa ejaroto riojʉa oca quenoña mʉa. Oca quenori masʉ tʉ ejamenati mʉa oca quenobeja ĩ mʉare poreciare ĩsigʉ̃ yiguĩji. Ĩna poreciajʉ mʉare tubiarã yirãji. ");
INSERT INTO myy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Riti mʉare gotia yʉ. Ñeñaro mʉa yigore mʉa waja yi jeobeto riojʉa budimena yirãji mʉa. Iti robo bajiroti bajia Dios waja seniri rʉmʉ ejaroto riojʉa ĩ rãca mʉa oca quenobeja, ya yʉ mʉare, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mʉcana gaje ado bajiro gotiyijʉ Jesús: —Jane mejejʉ gãna ĩna rotigore tʉogoana ña mʉa. Ado bajiro bajia: “Gãji manojo rãca ajebesa”, yi rotiyijʉ Moisés ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yʉama ado bajiro mʉare goti remoa: No romiore ãmotigʉ ĩ tʉoĩarisena isore ajegʉ bajiro yami ĩocʉ̃, ya yʉ mʉare, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Mʉa ya riojocadʉja cajeana ticõri ñeñaro mʉa yi ãmoja iti cajeare ruacõña. Itire ruacõri cõatẽña. Manire co dʉja cajea manija quenabetoja. Ito bajibojarocati jʉa cajea, cajea cʉtirã ñabojarãti jeame ʉ̃jʉrojʉ mani waja, rẽto bʉsaro quenabeto yiroja. ");
INSERT INTO myy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mʉa ya ãmona ñeñarise mʉa yija, itire jatacõña. Itire jatacõri cõatẽña. Manire co dʉja ãmo manija quenabetoja. Ito bajibojarocati jʉa ãmo, ãmo cʉtirã ñabojarãti jeame ʉ̃jʉrojʉ mani waja, rẽto bʉsaro quenabeto yiroja. “Mʉa ñeñaro yirise jidicãña mʉa”, yirocʉ ito bajiro yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mʉcana ado bajiro gotiyijʉ Jesús: —Gaje ado bajiro gotia jane mejejʉ yigore: “Ʉ̃mʉgʉ̃ ĩ manojore ĩ cõa ãmoja papera ucarʉja ĩre: Adio rãca manojo cʉtibojagʉti isore cõagʉ̃ ya yʉ. Yʉ manojo meje ñamo ĩja, yi ucarʉja ĩre”, yi gotia jane mejejʉ yigore. ");
INSERT INTO myy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yʉama ado bajiro mʉare gotia: Sĩgʉ̃ ĩ manojo gãji rãca ajebitigoro ñabojarocati isore ĩ cõaja, isore bʉto ñeñaro yami ĩocʉ̃. Gãji rãca iso manʉjʉ cʉtibojaja ĩre ajego yigõji iso. Ito yicõri no iso rãca manojo cʉtija isore ajegʉ yiguĩji ĩ, yi gotiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mʉcana gaje gotiyijʉ Jesús: —Jane mejejʉ gãna ĩna rotigore tʉogoana ña mʉa. Ado bajiro bajia iti: “Riti ado bajiro yicʉja yʉ”, Diore mʉa gotija mʉa goticãdo bajiroti yiba, yi rotiyijʉ Moisés ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yʉama ado bajiro mʉare gotia: “Ado bajiro yicʉja yʉ”, yicõri, riojo yiba. “Yʉ goticãdo bajiroti yicʉja yʉ”, yirocʉ “Riti gotia yʉ Dios ĩ ñaro riojo”, yibesa itioni. Ĩ ñaro ña ĩ rotirojʉ. Ito bajiri, “Riojo gotia yʉ”, yibesa iti wame rãca. “Adi macãrʉcʉ̃ro riojo cʉni, riti gotia yʉ”, yibesa itioni. ");
INSERT INTO myy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Adi macãrʉcʉ̃ro ña Dios yaro. Ito bajiri, “Riojo gotia yʉ”, yibesa iti wame rãca. “Jerusalén wame cʉtiri cʉto riojo cʉni riti gotia yʉ”, yibesa itioni. Mani Ʉjʉ ñasagʉ cʉto ña Jerusalén. Ito bajiri iti cʉto wame rãca “Ado bajiro yicʉja yʉ”, yibesa. ");
INSERT INTO myy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Yʉ ya rijoganati riojo gotia yʉ”, yibesa itioni. Ñirise, botirise mani ya rijoga joa godo weo masibea mani. Dios sĩgʉ̃ti ñami itioni godo weo masigʉ̃. Ito bajiri iti wame rãca, “Ado bajiro yicʉja yʉ”, yibesa mʉa. ");
INSERT INTO myy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mani riojo gotija quena. Mani cʉdibeja cʉni riojo gotija quena. “Riti gotia yʉ”, yirona gaje mani goti remoja rʉ̃mʉ́a ʉjʉ ejabʉarisena goti remoa mani, yi gotiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mʉcana gaje ado bajiro gotiyijʉ Jesús: —Jane mejejʉ gãna ĩna rotigore tʉogoana ña mʉa. Ado bajiro bajia iti: “Sĩgʉ̃ ĩ cajea jioja gãjire cʉni cajea jioja quena. Sĩgʉ̃ ĩ guji jabejasãja gãjire cʉni guji jabejasãja quena”, yiyijarã masa jane mejejʉ gãna. ");
INSERT INTO myy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yʉama ado bajiro mʉare gotia. Sĩgʉ̃ ñeñaro mʉare ĩ yija ĩre gãmebeja. Ado bajirojʉa yiba. Sĩgʉ̃ rio mʉare ĩ jaja gaje dʉja cʉni rotiba. ");
INSERT INTO myy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sĩgʉ̃ mʉ ya camisa ĩ ẽma ãmoja, rẽobeja ĩre. Ĩ ãmoro ãmicõto. Ito yicõri ĩre jai bʉsaro ĩsi remoña. ");
INSERT INTO myy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sĩgʉ̃ ĩ ya gajeoni coji cõrecõ ĩ ũma rotija jʉaji cõrecõ ĩre ũma ĩsima. “Ado bajiro yʉre moa ĩsiña”, gãji mʉare ĩ rotija, ĩ rotiro rẽto bʉsaro ĩre moa ĩsija quena. ");
INSERT INTO myy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Noa mʉare gajeoni senirãreti ĩsicõaja quena. Sĩgʉ̃ mʉare wasoa ãmoja wasoaja quena. Ito yicõri “Mʉre ĩsicʉjʉ yʉ”, yija quena, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Jane mejejʉ gãna ĩna bʉsigore tʉogoana ña mʉa cʉni. Ado bajiro bajia iti: “Mʉa babare queno ti maiña. Ito yicõri mʉa wajacʉre ti teya”, yiyijarã masa jane mejejʉ gãna. ");
INSERT INTO myy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yʉama mʉare ado bajiro gotia: “Mʉa wajanare ti maiña. Ĩnare queno yiya. Mʉa tõbʉjaroca yirãre yiari Diore bʉsi ĩsiña”, ya yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ito bajiro mʉa yija mani Jacʉ ũmacʉ̃jʉ gagʉ rĩa ñarã yirãji mʉa, ĩ ãmoro bajiro riti mʉa yisotija. Masa ñajedirore queno ejabʉami Dios. Ĩre cʉdimenare cʉni ejabʉami ĩ. Ĩ ñami quenarã, ñeñarãre cʉni ũmacañi busuroca yigʉ. Ĩ ñami riojo cʉdirã, riojo cʉdimenare cʉni ide queo ĩsigʉ̃. ");
INSERT INTO myy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉare ti mairãre riti mʉa ti maija ñe waja ma iti. Ito bajiro mʉa yija ticõri, mʉare waja yibiquĩji Dios. Ʉjarãre yiari waja seni ĩsiri masa ĩnare mairãre riti ti mairãji ĩna cʉni. Ĩnare bajiro yibesa mʉa. Mʉare ti terãre cʉni maija quena. ");
INSERT INTO myy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉa ñarãre riti mʉa seniĩaja, ñe waja ma. Diore masimena cʉni ito bajiroti yirãji ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mani Jacʉ ũmacʉ̃jʉ gagʉ, coji ñeñaro yiĩabicʉ ñami ĩ. Ĩre bajiroti yiya mʉa cʉni, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Queno mʉa yija, “Queno yama ĩna”, yijaro gãjerã yirona meje, queno yiba mʉa. Masa tiro riojo riti, “Ãni ñami queno Diore cʉdigʉ”, mʉa yi ĩobojaja ñe waja bʉjamenaji mʉa, ũmacʉ̃jʉ mani Jacʉ Dios tʉjʉ mʉa ejaja. ");
INSERT INTO myy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ito bajiri bojoro bʉjarãre mʉa ejabʉaja masa jeyarore goti batobeja. Ito bajiro yama minijuara wijʉ, marijʉ cʉni, “Yiro robo yirã ña gʉa”, yibojarãti yiro robo yimena. Bojoro bʉjarãre ĩna ejabʉaja, “Queno yirã ñama”, masa ĩna yitoni yama ĩnaõna. Riti mʉare gotia yʉ. Ito bajiro ĩna yirisenati waja bʉjacãma ĩna. Ñe gaje bʉja remomenaji Dios tʉjʉ. Ĩnare masa rʉ̃cʉbʉobojarocati Dioama ĩnare rʉ̃cʉbʉobicʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mʉama bojoro bʉjarãre mʉa ejabʉaja, masa ĩna masibeto ito yicõri mʉa baba ñasagʉ ĩ masibeto masare ejabʉaja quena. ");
INSERT INTO myy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Reco meje masa ĩna tibeto bojoro bʉjarãre ejabʉaba mʉa. Masa ĩna tibeto bojoro bʉjarãre mani queno yija, ti masiguĩji Dios manire. Ito bajiri waja yigʉ yiguĩji manire, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Diore mʉa bʉsija, “Yiro robo yirã ña gʉa”, yibojarãti yiro robo yimena bajiro Diore bʉsibeja mʉa. Ĩnama minijuara wijʉ Diore ĩna bʉsija rʉ̃gõcõri bʉsirãji. Ito yicõri ma tʉnima masa ĩna titoni Diore bʉsirã yirãji ĩna. Ito bajiro ĩna yirisenati waja bʉjacãma ĩna. Ñe gaje bʉja remomenaji ĩna Dios tʉjʉ. Ĩnare masa rʉ̃cʉbʉobojarocati Dioama ĩnare rʉ̃cʉbʉobicʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉama Diore mʉa bʉsija, mʉa ya sõa sãjacõri soje biaya maji. Ito bajiro yicõri mani Jacʉ rãca riti bʉsiba mʉa. Ito bajiro masa mano mʉa yija ticõri, mani Jacʉ mʉare waja yigʉ yiguĩji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Diore masimena ĩre ĩna bʉsija, coji gayeti bʉsimʉcʉtiama ĩna. “Bʉto mani bʉsimʉcʉtija Dios manire tʉogʉ yiguĩji”, yi tʉoĩa bʉsibojarãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ĩnare bajiro yibeja mʉama. Ñe manire rʉyarise mani seniroto riojʉajʉ masicãguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ito bajiri Diore mʉa bʉsija, ado bajiro bʉsiba: Gʉa Jacʉ, ũmacʉ̃jʉ gagʉ ña mʉ. Mʉ wame masicõri masa ñajediro rʉ̃cʉbʉojaro ĩna. ");
INSERT INTO myy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Masa jeyaro Ʉjʉ mʉ ñaroti rʉmʉ ejare ãmoa gʉa. Ũmacʉ̃jʉga tuti cʉni mʉ ãmoro bajiroti ñayija. Ito bajiri adi tutijʉ cʉni mʉ ãmoro bajiro riti ñare ãmoa gʉa. ");
INSERT INTO myy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Co rʉmʉ rʉyabeto gʉa baroticõti gʉare naju ĩsiña. ");
INSERT INTO myy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gʉa ñeñaro yirisere ãcabojoya. Gʉa cʉni ito bajiroti gʉare ñeñaro yirãre ãcabojoa. ");
INSERT INTO myy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","¿No bajiro yʉre cʉdirã yirãjida ĩna? yi tʉoĩabesa gʉare. Gʉa ñeñaro yibititoni gʉare ejabʉaya. Mʉ ña ʉjʉ ñatĩñarocʉ. Mʉ ña bʉto masitĩñare gaye rʉcotĩñarocʉ. Mʉ ña masa jeyaro ĩna rʉ̃cʉbʉotĩñarocʉ. Itocõ ña. Amén. Ito bajiro Diore mʉa bʉsija quena, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Mʉare ñeñaro yirãre ĩna ñeñaro yirisere mʉa ãcabojoja, mani Jacʉ ũmacʉ̃jʉ gagʉ mʉa ñeñaro yirise ãcabojogʉ yiguĩji ĩ cʉni. ");
INSERT INTO myy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gãjerã ĩna ñeñaro yirisere mʉa ãcabojobeja mani Jacʉ ũmacʉ̃jʉ gagʉ cʉni mʉa ñeñaro yirisere ãcabojobicʉ yiguĩji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Diore tʉoĩa ãmorã bamena riti ĩre mʉa bʉsija, masa ĩna tiro riojo bojori bʉjabeja mʉa. “Yiro robo yirã ña gʉa”, yibojarãti yiro robo yimena bamena riti Diore ĩna senija, masa ĩna tiro riojo bojori bʉjacã ĩna. Masa ĩna ti masitoni bojori bʉjabojacã ĩna. Riti mʉare gotia yʉ. Itinati waja bʉjacãma ĩna. Ñe gaje bʉja remomenaji ĩna Dios tʉjʉ. Ĩnare masa rʉ̃cʉbʉobojarocati Dioama ĩnare rʉ̃cʉbʉobicʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bamena riti Diore mʉa bʉsija, joa cʉni queno siro, rio cʉni queno coe yiba mʉare masa ti masime yirona. ");
INSERT INTO myy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","“Bamena riti Diore bʉsirã ñama ĩna”, masa yibe yirona wanʉ quenama. Mani Jacʉ mani rãca ñagʉ̃ ĩ sĩgʉ̃ti masitĩñagʉ̃ yiguĩji. Gãjerã masibeto ĩ sĩgʉ̃ti masigʉ̃ yiguĩji. Ito bajiri manire waja yigʉ yiguĩji ĩ, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Adi sitajʉ gajeoni jairo mio cũbesa. Adojʉ gajeoni mʉa mio cũbojarisere mʉtarãcã barã yirãji gajeoni bari masa. Gajeoni jogaro yiroja, ito yicõri riniri masa rinirã yirãji. ");
INSERT INTO myy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yʉ tija ũmacʉ̃jʉ mani Jacʉ tʉjʉ quenarise miojuja quena. Itojʉ gajeoni bari masa manaji. Gajeoni jogabetoja. Ito yicõri riniri masa cʉni ejamenaji. Ũmacʉ̃jʉ manire yiari queno yisotitĩñagʉ̃ yiguĩji Dios. Manire ĩ queno yirise jedibetoja. ");
INSERT INTO myy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gajeoni mani rʉcorojʉ mani tʉoĩarise ñaro yiroja manire. Ito bajiri ũmacʉ̃jʉ mani Jacʉ tʉjʉ quenarise mani miojuja quena, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Mani ya cajea queno iti ruyuja, mani tʉoĩarise queno sosaroja manire. Ticõri queno mani tʉoĩaja mani ya ʉsi cʉni quenaroja manire. ");
INSERT INTO myy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ito bajibojarocati tibojarãti queno mani tʉoĩabeja, mani ya ʉsi cʉni quenabetoja manire. Rãitĩarojʉ mani rʉ̃gõro robo bajiro bajiroja manire. “Ado bajiro ãmoami Dios”, yi masibojarãti Diore mani cʉdibeja, ĩre masirã meje ña mani. Ito bajiri bʉto bʉsa rãitĩarojʉ mani rʉ̃gõro robo bajiro bajiroja manire, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Cocati mani ʉjarã jʉ̃arãre cʉdi masibea mani. Jʉ̃arã ĩna ñaja sĩgʉ̃re queno ti maicõri, gãjire ti tudirã yirãji mani. Sĩgʉ̃re queno cʉdirã yirãji mani. Gãjire queno cʉdimena yirãji mani. Iti robo bajiroti Diore mani cʉdija, niyerujʉare bʉto tʉoĩamenaji mani. Niyerure riti mani bʉto tʉoĩaja Diore queno cʉdisabea mani, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Gaje mʉare ado bajiro gotia yʉ: “¿Ñe bacõri catigʉti yʉ?” ito yicõri, “¿Ñe idicõri catigʉti yʉ?” yi tʉoĩabesa. “¿Ñejʉa sãñacõri ñagʉ̃ti yʉ?” yi tʉoĩabesa. Manire rujeorʉ ñacõri mani baroti, mani idiroti cʉni ĩsi masiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Minia ũmacʉ̃jʉ wʉtirãre tʉoĩate mʉa. No õno otemenaji ĩna. Ito yicõri no õno bare miojumenaji ĩna. Ĩna baroti seomenaji ĩna. Ito bajiro ĩna bajibojarocati mani Jacʉ ũmacʉ̃jʉ gagʉ ĩnare bare ecaguĩji. “Minoa rẽtoro ñasarã ña mani Dios ĩ tija”, ¿yi masibeati mʉa? Minoare ĩ tirʉ̃nʉja bʉto bʉsa manire tirʉ̃nʉgʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Yoa bʉsari cati ãmoa yʉ”, yi mʉa oca jaija, ¿yoa bʉsaro catirã yirãjida mʉa? Meje, yoa bʉsari catimenaji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’“¿Ñe sãñagʉ̃ yigʉjada yʉa?” yi tʉoĩa oca jaibesa mʉa. Joa gaye gore tʉoĩate mʉa. Iti go moabetoja. Ito yicõri iti sãñaroti suabetoja iti. ");
INSERT INTO myy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ito bajibojarocati gore seyorise iti ñaroca yami Dios. Ʉjʉ Salomón ñayorʉ gajeoni jaigʉ ñabojagʉti go robo sãña jeobitiyoñi ĩ. ");
INSERT INTO myy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gore seyorise iti ñaroca yami Dios. Goama seyorise ñabojaroti yoari mejeti siniaroja ũmacañi jeana. Iti siniaja ticõri, itire soerã yirãji masa. “Manire yutabuju ĩsiguĩji Dios”, ¿yi masibeati mʉa? Ĩre queno tʉorʉ̃nʉsabea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ito bajiri, “¿Ñe barãti mani? ¿Ñe idirãti mani? ¿Ñe sãñarãti mani?” yi tʉoĩabitirʉja manire. ");
INSERT INTO myy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diore masimena itire tʉoĩa oca jaicãbojama ĩna. Manireama mani Jacʉ ũmacʉ̃jʉ gagʉ ñacãmi, “Iti rʉya ĩnare”, yiri masʉ. ");
INSERT INTO myy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","“Dios ñami yʉ Ʉjʉ. Ĩ yagʉ ña yʉ”, mani yi tʉoĩaja quena. Iti ña ñasarise. “Ĩre bajiro quenarise riti yi ãmoa yʉ”, mani yi tʉoĩaja quena. Ito bajiro mani yija, iti jeyaro manire rʉyarise boca ãmirã yirãji mani. ");
INSERT INTO myy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“¿Jane busuri gaye ñe yigʉ yigʉjada yʉ?” yi tʉoĩa oca jaibesa. Co rʉmʉ rʉyabeto ricati riti bajiroja. Jane busuri oca ñaja mani rãca ñagʉ̃ yiguĩji Dios. Ito bajiri, “¿ñe yigʉ yigʉjada yʉ?” yi tʉoĩa oca jaibesa, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Gãjerãre seti yibesa, Dios mʉare ĩ seti yibe yirona. ");
INSERT INTO myy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gãjerãre mʉa seti yiro bajiroti mʉare cʉni seti yigʉ yiguĩji Dios. “Itocõ seti ña ĩnare”, gãjerãre mʉa yiro bajiroti mʉare cʉni, “Itocõ ña seti”, yi masigʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ãnire jabeto seti ña”, yibojarãti, “Gʉare jai bʉsaro seti ña”, yi masibea mʉa. Seti cʉtirã ña mʉa cʉni. Ado bajiro bajirã ña mʉa. Tʉote. Mʉa babare cajeajʉ sũjuriacã iti ñaja ti masia mʉa. Ito bajibojarocati mʉa ya cajeajʉ sita jaje iti sãña biaja, ti masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mʉa ya cajeajʉ sita iti ñabojarocati mʉa babare cajeajʉ sũjuriacã ãmicãto yiboja mʉa. Mʉamasireti bajirisereama ti masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","“Yiro robo yirã ña gʉa”, yirã ñaboja mʉa. Mʉa ya cajeajʉ sita sãñarisere ãmicãña maji cajero. Iti sita mʉa ãmicãja berojʉa queno ti masirã yirãji mʉa. Ito yicõri mʉa babare cajeajʉ sũjuri ñarisere ãmicã masirã yirãji mʉa. Ado bajirojʉa bajia. Bʉto ñeñaro yirise mʉa jidicãja berojʉa, “Mʉ ñeñaro yirise jidicãña mʉ”, yi masirã yirãji mʉa babare, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Bʉto quenarise ña Dios oca. Ĩre ti terãre riaso josabeja. Yaiare quenarise ĩsibea mani. Ĩnare mani ĩsibojaja, manire curutirã yirãji ĩna. Mʉa ya ñaque perla wame cʉtirisere yesea wato cõacũbeja. Mʉa cõacũja itire cʉda aborã yirãji ĩna. Ito bajiroti Dios oca quenarise ĩre ti terãre riaso josabeja ĩna tʉo ãmobeja ticõri, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Diore mani senija ĩsigʉ̃ yiguĩji. Ĩre mani ãmaja bʉjarã yirãji. “Mʉre bʉsi ãmoa yʉ”, mani yija, bʉsi rotigʉ yiguĩji manire. ");
INSERT INTO myy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","No senigʉ̃ti boca ãmiguĩji. No ãmagʉ̃ti bʉjagʉ yiguĩji. “Bʉsi ãmoa yʉ”, yigʉreti bʉsi rotigʉ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’“Naju ãmoa yʉ”, yi mʉa macʉ ĩ senija, ¿gʉ̃tagã ĩsirã yirãjida mʉa? Meje gʉ̃tagã ĩsimenaji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","“Wai ãmoa yʉ”, mʉa macʉ ĩ yija, ¿ãña ĩsirãjida mʉa? Meje ãña ĩsimenaji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʉa ñeñaro yirã ñabojarãti mʉa rĩare queno yirãji mʉa. Ito bajiri itire masicõri mani Jacʉ ũmacʉ̃jʉ gagʉ quenarise mani senija, “Manire ĩsi masiguĩji ĩ”, yi tʉoĩa mani, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Gãjerã mʉare queno yire mʉa ãmoja ĩnare cʉni queno yiya mʉa. Ito bajiroti rotiyijʉ Moisés ñayorʉ, ito yicõri Diore goti ĩsiri masa ĩna ucayore cʉni, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Dios tʉjʉ mani eja ãmoja suari soje bajiri soje sãjarãji mani. Jeame ʉ̃jʉrojʉ wara ma jaja ma ñaroja, ito yicõri soje sãjarajʉ eyarijʉ ñaroja. Ito bajiri jãjarã warãji itijʉre. ");
INSERT INTO myy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Catitĩñarã wara ma eyabiti ma ñaroja. Ito yicõri iti soje sãjarajʉ jaibiti soje ñaroja. Ito bajiri coriarãti sãjarãji itojʉre, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’“Dios oca goti ĩsiri masa ña gʉa”, yibojarãre masiña mʉa. Rʉori masa ñama coriarã. Mʉa tʉ ĩna ejaja, oveja guamenare bajiro ejarãji ĩna. Ito bajibojarãti bʉto yaia guarãre bajiro ñarãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ĩna yirisejʉ ticõri masirã yirãji mʉa. Jota yucʉrijʉ rica manoja ʉyé. Jota marijʉ rica manoja higos wame cʉtirise. ");
INSERT INTO myy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ito bajiroti yucʉ quenarise, quenarise rica cʉtiroja. Ito yicõri yucʉ quenabitigʉ quenabiti rica cʉtiroja. ");
INSERT INTO myy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yucʉ quenabitigʉ quenarise rica cʉtibetoja. Ito yicõri yucʉ quenaricʉ ñeñarise rica cʉtibetoja. ");
INSERT INTO myy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yucʉgʉ queno rica manigʉ̃re itigʉre quẽacõri jeamejʉ soerã yirãji mani. ");
INSERT INTO myy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ito bajiroti masare cʉni ĩna yirise ticõri ĩnare ti masirã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Jãjarã, “Gʉa Ʉjʉ ña mʉ”, yibojarãti coriarãti ũmacʉ̃jʉ yʉ Jacʉ ĩ rotirojʉ ejarã yirãji ĩna. Yʉ Jacʉ ĩ ãmoro robo bajiro yirã riti ejarã yirãji. ");
INSERT INTO myy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Iti rʉmʉ iti ejaroca jãjarã ado bajiro yibojarã yirãji: “Gʉa Ʉjʉ mʉ rotire rãca riti Dios oca bʉsisoticʉ gʉa. Mʉ rotire rãca rʉ̃mʉ́a sãñarãre bucõacʉ gʉa. Ito yicõri mʉ wame rãca jaje tiyamani ĩocʉ gʉa”, yibojarã yirãji ĩna yʉre. ");
INSERT INTO myy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ito bajiro ĩna yibojarocati ado bajiro ĩnare yigʉ yigʉja yʉ: “Yʉ ñarã meje ña mʉa. Mʉare masibea yʉ. Yʉre wa camotadicoasa mʉa. Ñeñaro yiana ña mʉa”, yigʉ yigʉja yʉ ĩnare, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Yʉre tʉocõri yʉ rotiro bajiro yigʉ, ĩocʉ̃ ñami queno tʉoĩagʉ̃. Ĩ ñami sita bʉtirojʉ wi menirʉõcʉ̃ robo bajiro bajigʉ. ");
INSERT INTO myy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sita bʉtirojʉ wi ĩ menija bero ide quediyijʉ. Riari jue jaiyijʉ. Ito yicõri bʉto mino wẽayijʉ. Ito bajibojarocati sita bʉtirojʉ ñacõri cadabisijʉ iti wi. ");
INSERT INTO myy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yʉre tʉobojagʉti yʉ rotiro bajiro yibicʉ, tʉoĩa masibicʉ ñami ĩocʉ̃. Ĩ ñami sita jujurojʉ wi menibojarʉ robo bajiro bajigʉ. ");
INSERT INTO myy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iti wi ĩ menija bero ide quediyijʉ. Riari jue jaiyijʉ. Ito yicõri mino wẽayijʉ. Ito bajiri sita jujurojʉ ñacõri wi jujayijʉ, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ito bajiro Jesús masare ĩ bʉsija bero rujʉ ʉcayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Judio masa rotirise riasori masare bajiro meje queno bʉsa riasoyijʉ Jesús. Dios ĩ cũre rãca ñasarise ĩ riasojare rujʉ ʉcayijarã ĩna masa. ");
INSERT INTO myy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús ĩ tʉria roja ejaroca jãjarã masa sʉyayijarã ĩre. ");
INSERT INTO myy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ito ĩ waroca sĩgʉ̃ ĩ ya rujʉ cami jogagʉ Jesure canamʉoyijʉ. Jesús riojo rijomunigãna ñini rũjũyijʉ. Ito yicõri ado bajiro yiyijʉ ĩ Jesure: —Yʉ Ʉjʉ, yʉ ya cami mʉ ya ãmoja, yagʉja mʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ĩ ito yija tʉocõri, ĩ ya ãmona moa jeoyijʉ Jesús. —Ãmoa yʉ. Mʉ ya cami yacʉja yʉ, yiyijʉ Jesús ĩ ya rujʉ cami jogagʉre: Ito bajiro Jesús ĩ yirocati ĩ ya cami yaticoayijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ito yicõri ado bajiro rotiyijʉ Jesús ĩre: —Tʉoya, gãjerãre goti batobeja. Riojo wacõri paire ĩotẽña. Moisés ĩ rotiyoado bajiroti ecarʉre sĩacõri Diore yiari soe ĩsima. Ito mʉ yija ticõri, “Cami yaticoañi”, yirã yirãji masa, yiyijʉ Jesús ĩ ya rujʉ cami jogagogʉre. ");
INSERT INTO myy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capernaum wame cʉtiri cʉto Jesús ĩ ejaroca sĩgʉ̃ surara ʉjʉ ĩ tʉjʉa wayijʉ. Romano masʉ ñayijʉ ĩ. Jesús tʉ ejacõri ado bajiro ĩre josayijʉ: ");
INSERT INTO myy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Tʉoya yʉ Ʉjʉ mʉ. Yʉ ya wijʉ yʉ ya moari masʉ cõ yosami. Bʉto juni wisi yosami, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ĩ ito yija tʉocõri, ado bajiro cʉdiyijʉ Jesús ĩre: —Ĩre yisiogʉ wacʉ yigʉja yʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ito bajiro ĩ yiroca ado bajiro cʉdiyijʉ surara ʉjʉ, Jesure: —Yʉ Ʉjʉ, ñasagʉ meje ña yʉ, yʉ ya wi mʉ sãjabojaja cʉni. Adojʉnati goti ñucaña mʉ. Ito yirocati yʉ ya moari masʉ caticoagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gãjerã yʉ ʉjarã roca gagʉ ña yʉ. Ĩna rotirise cʉdigʉ ña yʉ. Ito bajiri yʉ roca gãna yʉ ya surara yʉ rotirã ñama yʉre cʉni. Sĩgʉ̃re, “Wasa”, yʉ yija waguĩji ĩ. Gãjire, “Waya”, yʉ yija wadiguĩji ĩ. Ito yicõri yʉre ejabʉari masʉ ĩre yʉ rotija, ĩre yʉ rotiro bajiroti yiguĩji ĩ. Adojʉnati mʉ goti ñucaja yʉ ya moari masʉ caticoagʉ yiguĩji, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ito bajiro ĩ yija tʉo ʉcacõri, “Yʉre tʉorʉ̃nʉsacõami ãni”, yi ti masiyijʉ Jesús ĩre. Ito bajiri ado bajiro yiyijʉ Jesús ĩ rãca riasotirãre: —Riti mʉare gotia yʉ. Israel sita gãna wato ĩre bajiro yʉre tʉorʉ̃nʉgʉ̃ tiĩabiticʉ yʉ, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Riti mʉare gotia yʉ. Jãjarã ũmacañi ĩ quedi sãjaro gãna ĩ joejearo gãna cʉni ũmacʉ̃jʉ Dios ĩ rotirojʉ ejacõri ba rujirã yirãji ĩna. Abraham, Isaac, ito yicõri, Jacob ñayoana rãca ba rujirã yirãji. ");
INSERT INTO myy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israel sita gãna Dios rotirojʉ ejaboanare rãitĩarojʉ ĩnare cõagʉ̃ yiguĩji ĩ. Itojʉ ejacõri ñeñaro tõbʉjarã yirãji. Ito bajiri oticõri bʉto tʉoĩa oca jairã yirãji, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ito yija surara ʉjʉre ado bajiro yiyijʉ Jesús: —Mʉ ya wijʉ tʉdi wasa. Yʉre mʉ tʉorʉ̃nʉro bajiroti mʉre moa ĩsiri masʉ caticoagʉ yiguĩji, yiyijʉ Jesús ĩre. Ito ĩ yirijʉti surara ʉjʉ ya moari masʉ ĩ ya wijʉ caticoayijʉ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pedro ya wijʉ wayijʉ Jesús. Iti wi ejacõri, Pedro mañicõre tiyijʉ Jesús. Cama joejʉ iso cõ jesaja tiyijʉ Jesús. Bʉto rujʉ yayijʉ isore. ");
INSERT INTO myy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Isore ticõri ãmo ĩ moaĩarocati rujʉ yarise jedicoayijʉ isore. Ito bajiri wʉmʉcõri masare eca bocasʉoyijo iso. ");
INSERT INTO myy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iti rãioroca jãjarã rʉ̃mʉ́ sãñarãre Jesús tʉjʉ ãmi ejayijarã masa. Ito ĩna bajija ticõri, coji ĩ bʉsirisenati rʉ̃mʉ́are bucõacõyijʉ Jesús. Ito yicõri ñarise cʉtirãre yisioyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ito bajiro rẽtayijʉ Isaías Diore goti ĩsiri masʉ ñayorʉ ĩ goticãdo bajiroti. Ado bajiro yiyijʉ Isaías ñayorʉ: “Manire rujʉ gajajuarise ito yicõri mani rujʉ ñarise cʉtirise yisiogʉ yiguĩji”, yiyijʉ Isaías ñayorʉ yʉre tʉoĩa yugʉ, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jãjarã masa ĩ tʉjʉ ĩna gãni biaja ticõri, “Gaje dʉjajʉ jẽa wato mani”, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ĩna waroto riojʉa sĩgʉ̃ Moisés rotirise riasori masʉ, Jesús tʉ ejayijʉ: —Riasori masʉ, no mʉ waroti mʉre sʉya ãmoa yʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ado bajiro cʉdiyijʉ Jesús ĩre: —Buyairoare ĩna caniri goje ñacʉ. Wʉtirãre cʉni ĩna ya jibʉ ñacʉ. Ito bajibojarocati Masa Rĩjorʉreama no cũñarajʉ ma ĩreama. Ĩti ña yʉ Masa Rĩjorʉ. Ito bajiri yʉre mʉ sʉyaja josari ñaroja mʉre, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ito yija gãji Jesús rãca riasotiri masʉ ado bajiro yiyijʉ ĩre: —Yʉ jacʉre codegʉ ña yʉ maji. Ĩ godaja bero mʉre sʉyacʉja yʉ maji, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Adocãtati yʉre sʉyaja quena. Godarãma godarãmasiti gãmeri yujejaro. Jeyaro mʉ tʉoĩa oca jairisere jidicãcõri yʉre sʉyaja quena, yiyijʉ Jesús ĩre. Yʉre tʉorʉ̃nʉmena godacãnare bajiro bajirã ñama. Ĩnamasiti godarãre yujerã yirãji. ");
INSERT INTO myy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ĩ ito yija bero cumajʉ ĩ rãca riasotirã rãca sãjayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Itajura gʉdareco ĩna tʉjaroca mino bʉto wẽayijʉ. Ito bajicõri cumajʉ jacũsãyijʉ. Ito iti bajibojarocati canigʉ̃ yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ito iti bajija ticõri, ĩ rãca riasotirã ĩre yujioyijarã. Ĩre yujiocõri ado bajiro yiyijarã ĩna ĩre: —Gʉa Ʉjʉ rujarã ya mani. Ito bajiri gʉare masoña, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—¿No yija bʉto güiati mʉa? Yʉre queno tʉorʉ̃nʉbea mʉa, yiyijʉ ĩ ĩnare. Ito yija wʉmʉ rʉ̃gʉ̃yijʉ ĩ. Ito yicõri minore, “Wẽabesa”, ito yicõri jacũrise, “Jacũbesa”, yiyijʉ Jesús. Ĩ ito yija bero ñe godo manoti tujacoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ĩ rãca riasotiri masa itire ticõri rujʉ ʉcayijarã: —¿Ñimʉõcʉ̃ masʉ ñatibe ãni? Mino wẽarise, ide jacũrise cʉni ĩ rotija tʉoa ĩre, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Itajura gaje dʉjajʉ Gadara wame cʉtiri sita ejayijarã ĩna. Ito ĩna ejaroca jʉ̃arã ʉ̃mʉa masari cumajʉ budi wadiyijarã. Ito yicõri Jesús tʉ eja rʉ̃gʉ̃yijarã ĩna. Jʉ̃arãjʉti rʉ̃mʉ́a sãñarã ñayijarã ĩna. Bʉto guarã ñayijarã ĩna. Ito bajiri ĩna tʉ rẽta masia mañijʉ. ");
INSERT INTO myy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesure ticõri ado bajiro awasãyijarã ĩnare sãñarã rʉ̃mʉ́a: —Jesús, Dios Macʉ ña mʉ. ¿No yija gʉa tʉ wadiati mʉ? ¿Adocãta jeame ʉ̃jʉrojʉ gʉare cõacõri gʉa tõbʉjaroca yigʉ wadiri mʉ? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ito sõjʉa nocõ mejeti jãjarã ecana yesea ãma ba ñayijarã. ");
INSERT INTO myy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yeseare ticõri ado bajiro Jesure josayijarã rʉ̃mʉ́a: —Gʉare mʉ bucõaja, õa yeseare gʉare sãja rotiya, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Mʉare roticã yʉ. Wasa, yiyijʉ Jesús rʉ̃mʉ́are. Ito ĩ yirocati ʉ̃mʉa jʉ̃arãjʉreti rʉ̃mʉ́a budicoayijarã ĩja. Ito yicõri yeseajʉare sãja wayijarã ĩna mʉcana. Yeseare ĩna sãjarocati tʉria ũmaquedi roja wacõri itajurajʉ quedi roacoayijarã ĩna. Ito bajiri ñarocõti ruja godacoayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yeseare tirʉ̃nʉbojana ito iti bajija ticõri, güirã ũmaquedi wayijarã ĩna. Cʉtojʉ ejacõri, “Ado bajiro rẽtamʉ”, yirona goti jeoyijarã ĩna. Rʉ̃mʉ́a sãñabojarãre ĩna rʉ̃mʉ́a budigore gaye goti jeoyijarã ĩna iti cʉto gãnare. ");
INSERT INTO myy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ĩna ito bajiro gotija tʉocõri, Jesús tʉjʉare minijua wayijarã masa, iti cʉto gãna. Jesure güirã ĩ ware ãmorã ĩre josayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ito yija mʉcana cumajʉ sãjayijʉ Jesús. Ito bajiri itajura gaje dʉja jẽa wacõri ĩ ya cʉtojʉ ejayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ito ĩ ejaroca rudurʉre cõrãre ĩna jeorona ĩre ãmi ejayijarã Jesús tʉ. “Yʉre queno tʉorʉ̃nʉrã ñama ĩna”, yi ti masicõri ado bajiro yiyijʉ Jesús rudurʉre: —Oca sẽoña yʉ macʉ. Mʉ ñeñaro yirise ma mʉre ĩja, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ito ĩ yija tʉocõri, ito gãna coriarã judio masa rotirise riasori masa ado bajiro tʉoĩayijarã: “Ito bajiro ĩ bʉsija, Diore rʉ̃cʉbʉobicʉ yami ĩ”, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ito bajiro ĩna tʉoĩarise ti masicõri ado bajiro yiyijʉ Jesús ĩnare: —¿No yija ito bajiro ñeñaro tʉoĩati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Disejʉa ñati josasabiti mʉa tija? “Mʉ ñeñaro yirise coecoajʉ”, yʉ yija, ¿quena ñarojada mʉa tʉoĩaja? “Wʉmʉña, wasa”, yʉ yija, ¿quena ñarojada? ¿Disejʉa ñati josasabiti mʉa tija? ");
INSERT INTO myy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yʉ ña Masa Rĩjorʉ. Adi sitajʉ Dios ĩ cũre rãca ña yʉ. Ito bajiri masa ñeñaro ĩna yirisere ãcabojo masia yʉ. “Riti Dios ĩ cũrʉ ña mʉ”, yʉre mʉa yi ti masitoni ado bajiro ya yʉ rudurʉre: —Wʉmʉña. Mʉ ya cama ãmiña. Mʉ ya wijʉ tʉdi wasa, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ito ĩ yirocati rudurʉ ñabojarʉ wʉmʉyijʉ. Ito yicõri ĩ ya wijʉ wacoayijʉ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ĩ ito bajiro bajija ticõri, güiyijarã masa. “Adi sita gagʉre ĩ masirise jidicãñi Dios”, yi tʉoĩacõri, Diore rʉ̃cʉbʉoyijarã masa. ");
INSERT INTO myy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Itona wacõri yʉ Mateo tʉre ejaquĩ Jesús. Cʉto ñari masare moa ĩsigʉ̃ ĩnare niyeru boca ãmirijʉ ñacʉ yʉ. Yʉre ti bʉjacõri ado bajiro yiquĩ Jesús yʉre: —Yʉ rãca waya, yiquĩ Jesús yʉre. Jesús yʉre ito bajiro yija tʉocõri, ĩre sʉya wacʉ yʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yʉ ya wijʉ ejacʉ gʉa. Ito ejacõri basʉocʉ gʉa. Niyeru boca ãmi ĩsiri masa, ñeñaro yiri masa ñacã ĩna cʉni gʉa rãca barona. Jesús rãca riasotirã cʉni ñacã gʉa rãca barona. ");
INSERT INTO myy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ito bajiro iti bajija ticõri, fariseo gaye tʉoĩarã gʉa rãca riasotirãre ado bajiro seniĩacã: —¿No yija mʉare riasori masʉ niyeru boca ãmi ĩsiri masa ito yicõri ñeñaro yiri masa rãca bati? yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ito bajiro ĩna yija tʉoquĩ Jesús: —Ñarise mana, cõmena cʉni ʉco masare ãmomenaji ĩna. Cõrã riti ʉco masare ãmarãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dios oca tuti gaye ticõri tʉoĩaña mʉa. Ado bajiro gotia iti. “Gãjerãre mʉa tʉo maire ãmoa yʉ. Gãjerãre tʉo maibitibojarãti ecarʉre sĩacõri yʉre mʉa soe ĩsibojaja ñe waja ma iti”, yi gotia Dios oca tuti, yiyijʉ Jesús ĩnare. Queno yirãre jirocʉ meje adi sita wadicʉ yʉ. Ñeñaro yirãre ñeñaro ĩna yirise jidicãtoni gaje adi sitajʉ wadicʉ yʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ito ñana Juan idé guri masʉ rãca riasotirã Jesure seniĩarona ĩ tʉ ejacã ĩna: —Gʉa ito yicõri fariseo gaye tʉoĩarã cʉni coji rʉyabeto Diore rʉ̃cʉbʉorã bamenati ĩre rʉ̃cʉbʉocʉ gʉa. ¿No yija mʉ rãca riasotirãma bare bamenati ĩre rʉ̃cʉbʉobeati ĩna? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ĩna ito yija tʉocõri, ado bajiro ĩnare goti masioquĩ Jesús: —¿Sĩgʉ̃ ĩ ãmo siari rʉmʉ ĩ rãca wanʉrona ĩ ji ñucana ĩ rãca ñabojarocati bojori bʉjarã yirãjida ĩna? Bojori bʉjamenaji. Yʉ baba mesa cʉni bojori bʉjamenaji ĩna rãca yʉ ñarocama. Co rʉmʉ yʉre ĩna ñiaroti rʉmʉ ejaro yiroja. Yʉre ĩna ñiaja ticõri, bamenati yʉre yiari Diore senirã yirãji yʉ baba mesa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Saya bʉcʉro iti tadija, mamarona sere wõmenaji mani. Mamarona mani sere wõja tʉ̃atu wato bʉcʉro tadiroja. Ito bajicõri jaja goje bʉsa tadi waroja ĩja. Mame oca yʉ riasorise cʉni bʉcʉrã oca rãca tʉoĩa wisabesa. ");
INSERT INTO myy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ʉyé mame ide wecʉ wiro bʉcʉ baju jiomenaji mani. Bʉcʉ baju mani jiojama wiro cuducoaroja. Ito yicõri idire wiro cʉni jʉajijʉ godaroja. Ito bajiro ʉyé mame ide wecʉ wiro mama bajuna jiore ñaroja. Ito yicõri ʉyé ide, wecʉ wiro cʉni corocõ ñaro yiroja, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ito bajiro Jesús ĩ gotiroca riti sĩgʉ̃ judio masa ʉjʉ ejaquĩ Jesús tʉ. Jesús riojo ĩre rʉ̃cʉbʉogʉ ñini rũjũquĩ ĩ. Ito yicõri ado bajiro yiquĩ ĩ Jesure: —Janeti yʉ maco ʉsi jedicoamo. Iso tʉ ejacõri isore mʉ moaĩaja tʉdi caticoago yigõji iso, yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ito ĩ yija tʉocõri, ĩre sʉya waquĩ Jesús. Ito bajiri gʉa ĩ rãca riasotirã cʉni wacʉ. ");
INSERT INTO myy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ito bajiro gʉa waroca sĩgõ romio cõgõ Jesús jʉdojʉa eja rʉ̃gʉ̃cõ. Iso ñacõ romia ñarise cõgõ. Itire jʉa gʉbojeno rodori cõ ñayijo iso. Jesús jʉdojʉa ejacõri ĩ ya yutabuju gaja moaĩacõ iso. ");
INSERT INTO myy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Ĩ ya yutabuju gaja yʉ moaĩajati caticoago yigoja yʉ”, yi tʉoĩari seyocõ iso. ");
INSERT INTO myy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ito bajiro iso yija tʉo masicõri, jʉda rʉ̃gʉ̃quĩ Jesús. Ito yicõri ado bajiro isore gotiquĩ: —Oca sẽoña yʉ maco. Yʉre tʉorʉ̃nʉgõ ñacõri caticoajʉ mʉ ĩja, yiquĩ Jesús isore. Ito bajiro ĩ yirocati tujacoacõ iso ĩja. ");
INSERT INTO myy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ito yija bero yoa bʉsari wacõri ʉjʉ ya wijʉ ejacʉ gʉa. Yujerona basa ĩna menija ticʉ gʉa. Ito yicõri ruje masa ĩna oca cʉtirise ruyucʉ. ");
INSERT INTO myy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús ado bajiro gotiquĩ ĩnare: —Adijʉre budigoya mʉa maji. Adio macoacã cõgõ meje yamo. Canigõ yamo, yiquĩ Jesús ĩnare. Ĩ ito yija tʉocõri, ĩre ajacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Masa ĩna budigoja bero macoacã tʉ sãja wacõri isore ãmo tʉ̃a ñiaquĩ Jesús. Ĩ ito yirocati jaja rũjũcõ iso. ");
INSERT INTO myy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ito bajiro Jesús ĩ yija ticõri, iti sita ñarocõti oca batacʉ. ");
INSERT INTO myy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Itojʉ gʉa waroca cajea timena jʉ̃arã awasã sʉyacã Jesure: —Gʉare ti maiña David ñayorʉ janerãbatia janami mʉ, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wijʉ gʉa sãja ejaroca ĩna jʉ̃arã cajea mana cʉni sãja ejacã. Ito bajiri ĩnare ado bajiro seniĩaquĩ Jesús: —“Gʉa ya cajea tiroca yigʉ yiguĩji Jesús”, ¿yi tʉoĩati mʉa? yiquĩ Jesús ĩnare. —Ito bajiroti tʉoĩa yʉ Ʉjʉ gʉa, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ĩna ito yijare, ĩna ya cajeajʉ moa jeoquĩ Jesús: —Yʉre mʉa tʉorʉ̃nʉro bajiroti mʉa ya cajea tiroca ya yʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ito ĩ yirocati ĩna ya cajeari ticoacã ĩna. Ito yicõri sẽoro ado bajiro gotiquĩ Jesús: —Queno tʉoĩama. Gãjerãre goti batobeja, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ito bajiro ĩ yibojarocati yoari mejeti wacõri goti batoyijarã ĩna iti sita gãnare Jesús ĩ yigorere. ");
INSERT INTO myy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Itijʉna ĩna wasʉoroca coriarã ejacã masa bʉsibicʉre ãmi ejarã. Rʉ̃mʉ́ sãñagʉ̃ ñaquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús rʉ̃mʉ́re ĩ bucõaja bero bʉsibicʉ ñabojarʉ bʉsisʉoquĩ ĩja. Itire ticõri rujʉ ʉcacã masa. Ito bajicõri ado bajiro yicã ĩna: —Israel sitajʉ ado bajirise tiĩabiticʉ gʉa maji, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo gaye tʉoĩarãma ado bajiro yicã: —Ãniõcʉ̃ rʉ̃mʉ́a ʉjʉ ĩ masirisena rʉ̃mʉ́are bucõami ãni, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Co cʉto rʉyabeto gʉa ejarocõ cʉri cʉtori, mʉtari cʉtori cʉni minijuara wijʉ masare riasoquĩ Jesús. “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire gaye masare riasoquĩ Jesús. Masa jeyaro ĩna ñarise cʉtirisere yisioquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Masa ĩna cõja, ĩna bojori bʉjaja ticõri, ĩnare ti maiquĩ Jesús. Jesús ĩ tija oveja ʉjʉ mana robo bajiro bajirã ñacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ito yija gʉare ado bajiro yiquĩ Jesús: —Riti mʉare gotia yʉ. Jaje ote bʉcʉa. Ito bajibojarocati coriarãti ñama itire ãmiri masa. ");
INSERT INTO myy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ito bajiri ote ʉjʉre seniña, moari masare ĩ cõatoni, yiquĩ Jesús gʉare. Ito bajiro ĩ gotija ado bajiro yireoni yiri seyoquĩ Jesús: Jãjarã ñama maji coji Dios ocare tʉoĩa yimena. Ito bajibojarocati coriarãti ñama ĩnare ĩ oca gotirona. Ito bajiri Diore seniña jãjarã bʉsa gotiri masare ĩ cõatoni. ");
INSERT INTO myy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ito yicõri gʉa jʉa gʉbojeno ñarãre jimiojuquĩ Jesús. Ito bajiro gʉare jimiojucõri rʉ̃mʉ́a sãñarãre bucõa rotiquĩ ĩ. Ito yicõri masa jeyaro ĩna ñarise cõrisere gʉare yisio rotiquĩ ĩ. Ito bajiro yicõri cõrãre gʉa yisio masiroca yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Adocõ ña gʉa jʉa gʉbojeno ñarã Jesús oca riaso ucutoni ĩ cũana. Tite mʉa. Cajero Simón Pedro wame cʉtigʉ ito yicõri ĩ ocabaji Andrés, ito bero Santiago, ito bero ĩ ocabaji Juan, Zebedeo rĩa ñama ĩna. ");
INSERT INTO myy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Bero Felipe, bero Bartolomé, bero Tomás, ito bero yʉ Mateo ʉjarãre yiari waja seni ĩsibojacacʉ, ito bero Santiago, Alfeo macʉ ñami. Ito bero Tadeo. ");
INSERT INTO myy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ito bero Simón, celote gaye tʉoĩagorʉ ñami ĩ, ito bero sʉsari Judas Iscariote. Ĩ ñami Jesure ĩna ñiatoni gotirʉ. ");
INSERT INTO myy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ado bajiro gʉa jʉa gʉbojeno ñarãre riaso ucu rotiquĩ Jesús: —Judio masa meje ĩna ñari cʉtori riaso ucubeja mʉa. Samaria sita cʉtori cʉni wabeja mʉa. ");
INSERT INTO myy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Quenogoroama Israel sita gãna tʉ wasa. Ĩna ñama oveja wisana robo bajiro bajirã. ");
INSERT INTO myy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Yoari mejeti ĩre tʉorʉ̃nʉrãre miojugʉ yiguĩji Dios”, yi riaso ucuba mʉa. ");
INSERT INTO myy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Rujʉ jogarãre mʉa ti bʉjaja ĩnare yisioba mʉa. Gãjerã gaje ñarise cʉtirãre cʉni yisioba mʉa. Godanare cʉni ĩna catiroca yiba. Rʉ̃mʉ́a sãñarãre cʉni ĩnare bucõama mʉa. Ito bajiro mʉa yi masitoni waja manoti mʉare jidicã yʉ. Ito bajiro mʉare yʉ jidicãjare mʉa yirise waja, waja senibeja mʉa cʉni, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mʉa waja niyeru cujiri, oro cujiri, cobre cujiri ãmi wabeja mʉa. ");
INSERT INTO myy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ito yicõri gajeoni sãra bajuri ãmi wabeja mʉa. Coro mʉa sãñaro riti ãmi waja. Gaje gʉboco mʉa wasoaroti ãmi wabeja. Gajegʉ turigʉ ãmi wabeja. Diore moa ĩsirã mʉa ñajare mʉa riasorãjʉa mʉare bare ĩna ecaja quena, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Jaja cʉto jaibiti cʉto cʉni mʉa ejaja, yiro bajiro tʉoĩagʉ̃re ãmama. Ĩocʉ̃ mʉa bʉjaja ĩ tʉ canima mʉa. Iti cʉto gãnare mʉa riasoja ĩ tʉ riti ñama maji, mʉa waroto riojʉa. ");
INSERT INTO myy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wijʉ mʉa ejaja, ¿ñati mʉa? yi seniĩacõri, “Queno ñaña mʉa”, yiba. ");
INSERT INTO myy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Masa queno mʉare ĩna boca ãmija, ito bajiroti, “Queno ñaña mʉa”, yi jidicãma ĩnare. Mʉare ĩna queno boca ãmibeja, “Queno ñaña mʉa”, yi jidicãbeja ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mʉare ĩna boca ãmi ãmobeja, ito yicõri mʉare ĩna tʉo ãmobeja, iti wire ñabeja mʉa. Ito yicõri iti cʉtore ñabeja mʉa. Iti cʉtore jidicã warã mʉa ya gʉbori sũjuri wãrisere ja batecãma mʉa. Ito bajiro mʉa yija ticõri, “Ĩnare queno boca ãmibea mani”, yi tʉoĩa masirã yirãji ĩna iti cʉto gãna. ");
INSERT INTO myy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Riti mʉare gotia yʉ. Sodoma ito yicõri Gomorra gãna rẽto bʉsaro ñeñaro tõbʉjarã yirãji ĩna masa ĩna ñeñaro yirise waja Dios ĩ seniri rʉmʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Yʉ mʉare riaso ucu rotija, oveja robo bajiro yaia wato guijorojʉ mʉare cõa yʉ. Queno ãñare bajiro ñacãña mʉa. Ito bajibojarocati bujare bajiro queno yirã ñama mʉa. Itojʉ mʉa waroto riojʉa, “Ado bajiro mani yija quena”, yirona queno tʉoĩama maji. Ito bajiri ito gãna mʉa ejaroca ñeñaro ĩna yibojarocati queno yiba mʉama ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Queno tʉoĩama mʉa. Mʉare ñiacõri ʉjarã riojo ãmi warã yirãji ĩna. Ito yicõri minijuara wi cʉni mʉare bajerã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yʉ ocare mʉa riasojare gobierno masa ito yicõri cʉto gãna ʉjarã riojo mʉare ãmi warã yirãji ĩna. Ito bajibojarocati ĩna riojo yʉ gaye bʉsirã yirãji mʉa. Ito yicõri judio masa meje ñarãre cʉni gotirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Oca quenori masʉ riojo mʉare ĩna ãmi ejaja. “¿No bajiro tʉoĩa bʉsigʉtibe yʉ, yigʉ yigʉjada yʉ?” yi tʉoĩa oca jaibeja mʉa. Mʉa bʉsirijʉ iti ejaja, mʉa bʉsiroti mʉare gotigʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mʉa bʉsija mʉario meje bʉsirãji mʉa. Mani Jacʉ ĩ ya ʉsi mʉa rãca ñajare bʉsirã yirãji mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Guijorise iti rẽtaja tirã yirãji mʉa. Masa ĩna ñarãreti gãjerã ĩna sĩatoni ñia rotirã yirãji ĩna. Ito yicõri jacʉ mesa gãjerã ĩna sĩatoni ĩna rĩare ñia rotirã yirãji. Ito yicõri ĩna rĩajʉ ĩnare ti junisinicõri gãjerãre sĩa rotirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yʉ ocare mʉa goti ucujare, masa jeyaro mʉare ti tudirã yirãji. Noa yʉre jidicãmenati jeame ʉ̃jʉrojʉ ĩna waborere ĩnare, masogʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cʉtojʉ mʉa tõbʉjaroca ĩna yija, gaje cʉtojʉ rudi waja. Riti mʉare gotia yʉ. Jeyaro Israel sita gãna cʉtori mʉa wa ucu jeoroto riojʉajʉ, yʉ Masa Rĩjorʉ ejagʉ yigʉja yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Sĩgʉ̃ riasotiri masʉ ĩre riasorʉ rẽto bʉsaro masigʉ̃ mami. Ito yicõri sĩgʉ̃ moari masʉ ĩ ʉjʉ rẽtogʉ̃ mami. ");
INSERT INTO myy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sĩgʉ̃ riasotiri masʉ ĩre riasorʉre bajiroti yija quena. Ito yicõri moa ĩsiri masʉ ĩ ʉjʉre bajiroti yija quena. Yʉ mʉa ʉjʉre Beelzebú ĩna wame yi tudija, yʉ ñarã mʉa ñajare bʉto bʉsa mʉare bʉsiturã yirãji ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ito bajiro ĩna bʉsitubojarocati ĩnare güibeja mʉa. Ñejʉa yeyo bʉsire ma Dios ĩ tiro riojo. Ñejʉa masa ĩna yeyo masirise ma. Jeyaro ti masiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Masa jeyaro tʉobeto yʉ mʉare gotirise jeyaro masa ĩna tʉotoni goti batoba mʉa. Mʉare yʉ yeyo gotirisere masare jimiojucõri ĩnare gotiba. ");
INSERT INTO myy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉa ya rujʉre sĩarãre güibeja mʉa. Mʉa ya ʉsijʉre sĩa masimenaji ĩna. Diore mʉa güija quena. Ĩ ñami mʉa ya rujʉre sĩacõri mʉa ya ʉsire jeame ʉ̃jʉrojʉ cõa masigʉ̃. Ĩre mʉa güija quena, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Minia jʉ̃arãcã waja niyeru cotiacã senirãji ĩna. Waja mana ĩna ñabojarocati ĩna quedi godaja ti masiguĩji mani Jacʉ. ");
INSERT INTO myy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Manire cʉni queno tirʉ̃nʉami Dios. Mani ya rijoga joa co joa rʉyabeto cõĩa masiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ito bajiri tʉoĩa oca jaibitirʉja manire. Minia rẽtoro ñasarã ña mani Dios ĩ tija, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Masa tiro riojo, “Jesure tʉorʉ̃nʉrã ña gʉa”, yirãreama yʉ cʉni yʉ Jacʉ ũmacʉ̃jʉ gagʉre, “Ĩna ñama yʉ ñarã”, yi masigʉ̃ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ito bajibojarocati masa tiro riojo, “Jesure masibea yʉ”, ĩna yija, yʉ cʉni yʉ Jacʉ ũmacʉ̃jʉ gagʉre, “Yʉ ñarã meje ñama ĩna”, yi masigʉ̃ yigʉja yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’“Sĩgʉ̃re bajiro tʉoĩacõri masa ĩna queno wanʉ quenatoni wadiñi Jesús”, yi tʉoĩabesa mʉa. Ñeñaro yi ãmorã yʉ oca tʉomenati junisinirã yirãji masa. ");
INSERT INTO myy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sĩgʉ̃ yʉre ĩ tʉorʉ̃nʉja ĩ jacʉjʉa ĩre tudigʉ yiguĩji. Ito yicõri sĩgõ yʉre iso tʉorʉ̃nʉja iso jacojʉa isore tudigo yigõji. Ito yicõri sĩgõ yʉre iso tʉorʉ̃nʉja iso mañicõ isore tudigo yigõji. ");
INSERT INTO myy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ito bajiri sĩgʉ̃ yʉre tʉorʉ̃nʉgʉ̃ ĩ ñajare, ĩ ñarã ñabojarãti ĩre ti tudirã yirãji ĩna. Ito yicõri ĩna ñarã yirãji ĩ wajana, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’No ĩ jacore ĩ jacʉre yʉre rẽto bʉsaro maigʉ̃, yʉ yagʉ ñado mami ĩocʉ̃. No ĩ macore ĩ macʉre yʉre rẽto bʉsaro maigʉ̃ yʉ yagʉ ñado mami ĩocʉ̃. ");
INSERT INTO myy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","“Jesure yʉ sʉyaja yucʉtẽojʉ yʉre jaju sĩarã yirãji”, yi tʉoĩa güigʉ, yʉ yagʉ ñado mami ĩocʉ̃. ");
INSERT INTO myy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","No ĩ catirise maibojagʉti godagʉ yiguĩji. Ito bajibojarocati yʉre tʉorʉ̃nʉgʉ̃, yʉ oca ĩ gotija tʉo junisinicõri ĩna sĩagʉ̃ama catitĩñare gaye bʉjagʉ yiguĩji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’No mʉare boca ãmirãti yʉre cʉni boca ãmirã yirãji ĩna. Ito yicõri no yʉre boca ãmirãti yʉre cõarʉre cʉni boca ãmirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","No, “Diore goti ĩsiri masʉ ñami”, yi masicõri ĩre boca ãmirã Dios tʉ ĩ bʉjado bajiroti waja bʉjarã yirãji ĩna cʉni. No, “Queno yigʉ ñami”, yi masicõri ĩre boca ãmirã, Dios tʉ ĩ bʉjado bajiroti waja bʉjarã yirãji ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Riti mʉare gotia yʉ. No yʉre sʉyarãre ñasarã meje ĩna ñabojarocati ĩnare boca ãmicõri ĩnare ĩna ide ioja, waja bʉjarã yirãji ĩnaõna. “Jesure sʉyagʉ ñami”, yi masicõri ĩre ĩna boca ãmija, waja bʉjarã yirãji ĩnaõna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Gʉa ĩ rãca riasotirã jʉa gʉbojeno ñarãre ito bajiro riaso rotiquĩ Jesús. Ito bajiro ĩ goti tĩoja bero iti sita cʉtori masare riaso ucurã wacʉ gʉa, Jesure sʉyarã. ");
INSERT INTO myy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Iti rʉmʉ masare idé guri masʉ Juan tubiara wijʉ ñañi. Itojʉ ĩ ñaroca Jesús ĩ masare riaso ucure, ito yicõri tiyamani ĩ ĩore gaye oca ejayijʉ ĩre. Ito bajiri Jesure ĩna seniĩatoni ĩ rãca riasotirã jʉ̃arãre cõañi Juan. ");
INSERT INTO myy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Gʉa tʉ ejacõri ado bajiro Jesure seniĩacã ĩna: —¿Mʉti ñati Cristo Dios ĩ cõarʉ? Gãji mʉ ñajama, ¿gãjijʉare bocatirãtite gʉa? yi seniĩacã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ĩna ito yija tʉocõri: —Wasa, Juan tʉ tʉdi wasa. Ĩ tʉ ejacõri mʉa tigore, mʉa tʉogore cʉni gotiba ĩre. ");
INSERT INTO myy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ado bajiro ĩre mʉa gotire ãmoa yʉ: “Timena cʉni ticoa. Wamena cʉni wacoa. Rujʉ cami jogarã cʉni cami yaticoa. Tʉomena cʉni tʉocoama. Godana cʉni tʉdi caticoama. Ito yicõri bojoro bʉjarã cʉni Dios oca quenarise gaye tʉo, baji ñañi ĩna Jesús ĩ masirise ĩ ĩojare”, yi gotiba, Juan tʉ mʉa ejaja. ");
INSERT INTO myy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","No yʉre tʉorʉ̃nʉgʉ̃ ĩ jidicãbeja wanʉ quenagʉ̃ yiguĩji, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ĩna waja bero Juan idé guri masʉ gaye masare gotisʉoquĩ Jesús: —¿Yucʉ manojʉ warã ñimʉre tʉoĩa wacati mʉa? ¿Sĩgʉ̃ ʉ̃mʉgʉ̃ mino iti waja, ʉe rʉ̃gõgʉ̃re tʉoĩa wacatite mʉa? ");
INSERT INTO myy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ĩocʉ̃re mʉa tʉoĩa wabeja, ¿ñari masa ya yutabujuri sãñagʉ̃re tʉoĩa wacatite mʉa? “Quenarise yutabujuri sãñarã ñacã ĩna ʉjarã tʉ ñarã”, yi masia mani. ");
INSERT INTO myy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ñimʉjʉare tʉoĩa wasacati mʉa? ¿Diore goti ĩsiri masʉre tʉoĩa wacatite mʉa? Riti mʉare gotia yʉ. Gãjerã Diore goti ĩsiri masa rẽtoro ñagʉ̃re tiyija mʉa. ");
INSERT INTO myy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dios oca tutijʉ Juan idé guri masʉ gaye ado bajiro gotia: Mʉ riojʉa oca goti yuri masʉ cõagʉ̃ yigʉja yʉ. Ĩti ñami mʉ ejaroto riojʉa queno yuri masʉ, yi gotia Dios oca tuti. ");
INSERT INTO myy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Riti mʉare gotia yʉ. Nijʉa gãji masʉ, masa jeyaro wato Juan idé guri masʉre bajiro ñasagʉ maquĩji. Ito bajibojarocati Dios ĩ rotirojʉ ñasarã meje ñabojarocati ĩna ejaja Juan rẽto bʉsaro ñasari masa ñarã yirãji ĩna, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Cajero Juan ĩ riasosʉorocajʉ, ito yicõri adi rʉmʉrijʉ cʉni jãjarã ñama Dios ĩ rotirojʉ sãja ãmorã. Jãjarã ñabojama ĩna ñeñaro yirise jidicãmenati jore sãja ãmobojarã. ");
INSERT INTO myy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan ĩ ejaroto riojʉa, “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yi tʉoĩa yurã bʉsiñi Diore goti ĩsiri masa. Dios rotirise ucari masʉ Moisés ñayorʉ cʉni ito bajiroti bʉsiñi. ");
INSERT INTO myy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Diore goti ĩsiri masʉ Elías wame cʉtigʉ goaĩogʉ̃ yiguĩji”, yi goti yuyijarã ĩna. “Juana sʉoriti goaĩoami ĩna tʉoĩa yurʉ”, mʉa yi tʉoĩaja quena. ");
INSERT INTO myy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","“Gãmo goje cʉtirã tʉoya mʉa”, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Ñena cõĩacõri no bajiro bajiatibe adi rʉmʉri gãna masa, yi cõĩagʉ̃tibe yʉ? Rĩaca cʉto gʉdareco ĩna baba rãca aje rujicõri bʉsi rujirãre bajiro bajiama ĩna. ");
INSERT INTO myy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Seru jutia gʉa. Ito bajibojarocati borobea mʉa. Bojori bʉjare basa gʉa sẽabojaja otibea mʉa”, rĩaca yi ajerã robo bajiro bajirã ñama adi rʉmʉri gãna. ");
INSERT INTO myy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ito bajiro ya mʉa cʉni. Mʉa ãmoro bajiro gãji ĩ yibeja, junisinia mʉa. Juan ĩ ejaja ticõri, jeyaro ĩ babeja, ʉyé ide ĩ idibeja ticõri, “Rʉ̃mʉ́ sãñarʉ ñami ãni”, yicʉ mʉa. ");
INSERT INTO myy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ĩ bero ejacʉ yʉ, Masa Rĩjorʉ. Yʉ baja, yʉ idija ticõri, “Jairo bagʉ ñami ĩ. Ito yicõri idiri masʉ ñami. Ñeñaro yiri masa baba ñami ãni. Ʉjarãre yiari waja seni ĩsiri masa baba ñami ĩ”, yicʉ mʉa yʉre. Ito bajiro mʉa yibojarocati Dios masirise mʉa tʉo masi ãmoja, ĩre masirãre ĩna yigore ticõri tʉo masirã yirãji mʉa, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ito bajiro ĩ yija bero tiyamani ĩ ĩora cʉtori gãnare tʉoĩacõri ĩnare tudisʉoquĩ Jesús. Ñeñaro yirisere ĩna jidicãbejare ito bajiro ĩnare tudiquĩ Jesús: ");
INSERT INTO myy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Bʉjato bʉjarã yirãji mʉa Corazín gãna. Bʉjato bʉjarã yirãji mʉa Betsaida gãna cʉni. Tiro cʉto gãna ito yicõri Sidón cʉto gãnare cʉni mʉare tiyamani yʉ ĩocato bajiro ĩnare yʉ ĩoja iti rʉmʉjʉ ĩna ñeñaro yirisere tʉoĩa bojori bʉjacõri jidicãboana ĩna. “Gʉa ñeñaro yirise jidicã gʉa”, yirona yutabuju bojori baju sãñaboana ĩna. Ito yicõri, “Bojori bʉja gʉa”, yirona ĩna ya rijogajʉ õja jeoboana ĩna. ");
INSERT INTO myy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Riti mʉare gotia yʉ. Ñeñaro yirisere mʉa jidicãbeja, Dios ĩ waja seniri rʉmʉ Sidón gãna, Tiro gãna rẽto bʉsaro ñeñaro tõbʉjarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mʉa Capernaum gãna, “Ũmacʉ̃jʉ Dios ĩ ñarojʉ ejacoana mani”, yi tʉoĩaboja mʉa. Ejamenaji mʉa. Jubejʉ godana tʉjʉ jeame ʉ̃jʉrojʉ ejarã yirãji mʉa. Sodoma gãnare tiyamani yʉ mʉare ĩocato robo bajiro yʉ ĩnare ĩoja, ĩna ñeñaro yirisere jidicãboana ĩna. Ito bajiri adi rʉmʉrijʉ cʉni ñaboadoja ĩna cʉto maji. Tiyamani yʉ mʉare ĩobojarocati ñeñaro mʉa yirise jidicã ãmobea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Riti mʉare gotia yʉ, Dios ĩ waja seniri rʉmʉ Sodoma gãna rẽto bʉsaro ñeñaro tõbʉjarã yirãji mʉa, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iti rʉmʉri Diore ado bajiro bʉsiquĩ Jesús: —Cʉna, ũmacʉ̃jʉ gagʉ Ʉjʉ ña mʉ. Adi tuti gagʉ cʉni Ʉjʉ ña mʉ. Mʉre rʉ̃cʉbʉoa yʉ. Yʉ riasorise ñasari masa, bʉto tʉo masirãre cʉni ĩna masibitiroca ya mʉ. Ito yicõri yʉ riasorise bʉto ñasari masa meje, bʉto tʉo masimenare cʉni ĩna tʉo masiroca ya mʉ. Ito bajiri mʉre rʉ̃cʉbʉoa yʉ. ");
INSERT INTO myy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ito bajiro ya Cʉna mʉ, mʉ ãmoro robo bajiro yigʉ, yiquĩ Jesús Diore. ");
INSERT INTO myy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Jeyaro yʉ yirise, yʉ ĩogorise cʉni yʉ yi masiroca yami yʉ Jacʉ. Yʉ Jacʉ sĩgʉ̃ti yʉre masiami. Gãjerãma yʉre masibeama. Yʉ sĩgʉ̃ti yʉ Jacʉre ti masia. Gãjerãma ĩre ti masimenaji. Ĩre masitoni yʉ gotirã riti yʉ Jacʉre masirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Moare bogarã, rʉ̃cʉrise ãmiboja bogarãre bajiro bajirã ña mʉa yʉ tija. Ito bajiri yʉre tʉorã waya. Mʉare tujacã rotigʉ yigʉja yʉ. Ito yicõri yʉre mʉa tʉorʉ̃nʉja mʉa tʉoĩa oca sẽoroca yigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yʉ rotiro robo bajiro cʉdiya mʉa. Ito yicõri yʉ gaye riasoya. Masare ti maigʉ̃ ñari sẽoro mʉare rotibicʉja yʉ. Ʉsirioro yigʉ meje ña yʉ. Ito bajiri yʉ rotiro robo bajiro mʉa cʉdija ticõri, mʉa tujacãroca yigʉ yigʉja yʉ. Ito yicõri mʉa ya ʉsijʉ sajari oca cʉtiro yiroja mʉare. ");
INSERT INTO myy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yʉ mʉare rotirise josari meje ña. Ito bajiri yʉ gaye mʉa cʉdija bojori bʉjamenati queno wanʉ quenarã yirãji mʉa. Rʉ̃cʉbiti ũmarã bajiro wanʉ quenarã yirãji mʉa, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iti rʉmʉri tujacãra rʉmʉ ñaroca ote wato wacʉ gʉa Jesús rãca. Gʉa ĩ rãca riasotirã ñiocõcʉ. Ito bajiri trigo ajeri beja ãmicõri bacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iti gʉa baja ticõri, fariseo gaye tʉoĩarã ado bajiro yicã Jesure: —Tite. Mʉ rãca riasotirã tujacãra rʉmʉ moare gaye mejeti moama ĩna, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ito bajiro ĩna yija tʉocõri, ado bajiro cʉdiquĩ Jesús: —Co rʉmʉ David ñayorʉ ĩ rãca gãna ñiocõ wana ĩna yigore, ¿Dios oca tuti tiĩabiticati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ñiocõ wana ñari Dios ya wijʉ sãjacõri, ĩre rʉ̃cʉbʉorã gãjerã ĩna cũre naju bayijarã ĩna. Paia mesa riti ĩna baroti ñabojayijʉ iti. David mesa ĩna baroti meje ñabojayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Paia mesa tujacãra rʉmʉ Dios ya wijʉ ĩna tujacãbeja ñeñaro yirã meje yiana ĩna”, yi Moisés ñayorʉ ĩ ucare gaye, ¿tiĩabiticati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Riti mʉare gotia yʉ. Dios ya wi rẽto bʉsaro ñasagʉ ña yʉ. ");
INSERT INTO myy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dios oca tuti gaye queno tʉoĩa masibea mʉa. Ado bajiro gotia iti: “Masa gãjerãre queno ti maija quena yʉre. No yibea ecarʉ sĩacõri yʉre ĩna soe ĩsija”, yi gotia Dios oca. Itire mʉa tʉoĩa masija, gãjerãre ti maicõri, “Ĩnare seti ña”, yibitiboana mʉa. ");
INSERT INTO myy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Masa Rĩjorʉ, Dios ĩ cũrʉ ña yʉ. Ito bajiri tujacãra rʉmʉ gaye yʉ rotiroti cʉni cũquĩ Dios yʉre, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ito yija bero judio masa minijuari wijʉ wacõri sãjacʉ gʉa Jesús rãca. ");
INSERT INTO myy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iti wijʉ ñaquĩ sĩgʉ̃ co dʉja ãmo digarʉ. “Jesure seti ña”, yirona fariseo gaye tʉoĩarã ado bajiro Jesure seniĩacã ĩna: —¿Moisés ñayorʉ rẽobisijari tujacãra rʉmʉ cõrãre yisiore gaye? yi seniĩacã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ĩna ito yija tʉocõri: —¿Sĩgʉ̃ mʉa ya ecarʉ ĩ rujarajʉ ĩ quedi roaja ãmirã wamenajida mʉa? Tujacãra rʉmʉ ñabojarocati mʉa ya ecarʉ ĩ quedi roaja ĩre ãmirã warãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ecarʉ rẽto bʉsaro ñasagʉ ñami masʉ. Ito bajiri tujacãra rʉmʉre cʉni gãjire mani ejabʉaja quena, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ito yija ãmo digagʉre ado bajiro yiquĩ Jesús: —Mʉ ya ãmo ñujoya ĩja. Ĩ ñucõarocati jajacoacʉ ĩja, gaje dʉja ricare bajiroti. ");
INSERT INTO myy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ito ĩ yija ticõri, budi wacã fariseo gaye tʉoĩarã. “¿No bajiro yicõri Jesure sĩarʉjati mani?” yi tʉoĩa bʉsiri seyocã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ito bajiro ĩna tʉoĩaja, tʉo masicõri gajerojʉa waquĩ Jesús mʉcana. Gʉa cʉni ĩ rãca wacʉ. Jesús ĩ waja ticõri, jãjarã masa sʉya wacã gʉa rãca. Ito ĩ warojʉ ñajediro masa cõrãre yisioquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ito yicõri, “Ãniti gʉare yisioquĩ”, yibeja mʉa, yiquĩ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Isaías ñayorʉ Diore goti ĩsiri masʉ ĩ goticãdo bajiroti rẽtacʉ iti. Ado bajiro goti ucayoñi Isaías ñayorʉ: ");
INSERT INTO myy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ãni ñami yʉre moa ĩsiri masʉ yʉre cʉdigʉ. Ĩre besecʉ yʉ. Ĩre maia yʉ, ito yicõri ĩre wanʉa yʉ. Yʉ ya ʉsi ĩre queo sãgʉ̃ yigʉja yʉ. “Masa ĩna ñeñaro yirise waja senigʉ̃ yiguĩji Dios”, yi masare goti batogʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Masare oca josabicʉ yiguĩji ĩ. Ito yicõri masare ma gʉdareco eja rʉ̃gʉ̃cõri awasã gotibicʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yʉre queno tʉorʉ̃nʉsamenare cʉni ĩnare cõabicʉ yiguĩji. Yʉre queno tʉorʉ̃nʉsamenare ĩnare ejabʉagʉ yiguĩji ĩ, yʉre ĩna queno tʉorʉ̃nʉtoni. Ito bajiro ñagʉ̃ yiguĩji ĩ, masa jeyarore yʉ ti beseri rʉmʉ iti ejarocajʉ. ");
INSERT INTO myy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","“Ĩti ñami masare masorocʉ Dios ĩ cõarʉ”, yi tʉoĩa wanʉ yurã yirãji masa jeyaro, yi gotia Dios oca tuti, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ito yija bero sĩgʉ̃re Jesús tʉ ãmi ejacã ĩna. Ĩ ñaquĩ tibicʉ, bʉsibicʉ cʉni. Rʉ̃mʉ́ sãñagʉ̃ ñari ito bajiro ñabojaquĩ ĩ. Ĩre yisioquĩ Jesús. Ito bajiri tibicʉ ñabojarʉ tiquĩ ĩja. Ito yicõri bʉsibicʉ ñabojarʉ bʉsicoaquĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Itire ticõri masa jeyaro ʉcacã: —¿David ñayorʉ janerãbatia janamiti ñati ãni? yi tʉoĩacã masa. ");
INSERT INTO myy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ito bajiro masa ĩna yija tʉocõri, ado bajiro yicã fariseo gaye tʉoĩarã: —Rʉ̃mʉ́are ĩ bucõaja rʉ̃mʉ́a ʉjʉ Beelzebú wame cʉtigʉ ĩ masirisena rʉ̃mʉ́are bucõami ĩ, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ito bajiro ĩna yi tʉoĩarise ti masicõri ado bajiro yiquĩ Jesús ĩnare: —Cʉtori gãna ʉjarã gãmeri ĩna junisinija queno cʉto ña rujeabetoja. Co cʉto gãna, co wi gãna cʉni ĩna gãmeri junisinija, queno ña masimenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ito bajiroti rʉ̃mʉ́a ʉjʉ rʉ̃mʉ́are ĩ bucõaja queno ña masibiquĩji ĩ. Ito bajiro ĩ yija queno roti masibiquĩji ĩja. ");
INSERT INTO myy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Beelzebú wame cʉtigʉ ĩ ejabʉarisena rʉ̃mʉ́are bucõami ĩ”, yiboja mʉa yʉre. Ito bajiro mʉa yʉre yi tʉoĩabojaja, “Rʉ̃mʉ́ ĩ ejabʉarise rãca bucõama gʉa rãca gãna”, yirãre bajiro ya mʉa. “Tʉoĩa wisarã ya gʉa”, yi tʉoĩarʉja mʉare. ");
INSERT INTO myy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Rʉ̃mʉ́re yʉ bucõaja Espíritu Santona sʉoriti bucõa yʉ. Ito bajiro yʉ yija, “Diore tʉorʉ̃nʉrãre ĩ miojuri rʉmʉ eja wajʉ ĩja”, yi masirã yirãji mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Sĩgʉ̃ gãji sẽogʉ̃ ya wi sãjacõri ĩre siabicʉti gajeoni ẽma masibiquĩji ĩ. Ĩre ĩ siaja berojʉ gajeoni ẽma masiguĩji ĩ. Rʉ̃mʉ́a ʉjʉ rẽtoro masigʉ̃ ña yʉ. Ito bajiri rʉ̃mʉ́are bucõa yʉ, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Yʉ robo bajiro tʉoĩamena yʉre tʉo terã ñama ĩnaõna. Yʉre ejabʉabicʉ yʉre ñeñaro yami ĩocʉ̃, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Riti mʉare gotia yʉ. Masa ĩna ñeñaro yija, ito yicõri ñeñaro ĩna bʉsija cʉni, ĩnare ãcabojo masiguĩji Dios. Espíritu Santore ĩna bʉsituja, itireama ĩnare ãcabojo masibiquĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yʉ ña Masa Rĩjorʉ. No yʉre ĩ bʉsituja, ĩocʉ̃re ãcabojo masiguĩji Dios. Ito bajibojarocati, no Espíritu Santore ĩ bʉsituja itireama ĩre ãcabojo masibicʉ yiguĩji Dios. Adi tutire ũmacʉ̃jʉ Dios ĩ ñarojʉ cʉni ãcabojo masibicʉ yiguĩji Dios, Espíritu Santore masa ĩna bʉsituja, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Yucʉgʉ quenaricʉ iti ñaja, quenarise rica cʉtiro yiroja. Yucʉgʉ ñeñaricʉ iti ñaja, ñeñarise rica cʉtiroja. Ricajʉ ticõri, “Adigʉ ña quenarise rica cʉtiricʉ, adigʉ ña ñeñarise rica cʉtiricʉ”, yi ti masia mani. ");
INSERT INTO myy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ñeñaro bʉsirã mʉa ñajare ãña juniro bajiro bajia mʉa ya rise. Ñeñaro riti yirã ñari quenarise bʉsi masimenaji mʉa. Mani ya ʉsi iti tʉoĩaro bajiroti bʉsia mani. ");
INSERT INTO myy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sĩgʉ̃ queno yigʉ quenarise bʉsigʉ yiguĩji, ĩ ya ʉsi iti tʉoĩaro bajiroti. Ito yicõri ñeñaro yigʉ, ĩ ya ʉsi ñeñaro iti tʉoĩaro bajiroti ñeñarise bʉsigʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Riti mʉare gotia yʉ. Dios ĩ waja seniri rʉmʉ rocati mani bʉsiado bajiroti manire waja senigʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mani bʉsi wado bajiroti waja senigʉ̃ yiguĩji Dios. Queno yirã mani ñaja, “Queno yirã ñama ĩna”, yigʉ yiguĩji Dios manire. Ito yicõri ñeñaro yirãreama, “Seti cʉtirã ñama”, yigʉ yiguĩji Dios, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ito ĩ yija bero, ado bajiro seniĩacã fariseo gaye tʉoĩarã, ito yicõri judio masa rotirise riasori masa cʉni: —Riasori masʉ, tiyamani mʉ ĩore ãmoa gʉa, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ito yija ado bajiro ĩnare cʉdiquĩ Jesús: —Ñeñaro yirã ito yicõri yʉre tʉorʉ̃nʉmena cʉni, tiyamani yʉ ĩore ãmoama ĩna. Ito ĩna yibojarocati ĩnare ĩoado ma yʉ. Jonás ñayorʉ Diore goti ĩsiri masʉ ĩre rẽtare gaye riti ĩnare goticʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ado bajiro rẽtayijʉ Jonásre: Ʉdia rʉmʉ, ʉdia ñami wai jaigʉ totijʉ ñabojayijʉ. Ito bajiroti yʉ cʉni Masa Rĩjorʉ ñami ʉdia ñami ʉ̃mʉa ʉdia rʉmʉ ñagʉ̃ yigʉja yʉ sita watojʉ. ");
INSERT INTO myy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive cʉto ñayoana Dios ĩ waja seniri rʉmʉ mʉcana tʉdi catirã yirãji. Tʉdi caticõri, “Mʉare seti ña”, yirã yirãji adi rʉmʉri gãnare. Nínive cʉto gãna ñayoana Jonás ñayorʉ Dios oca ĩ gotija tʉocõri, ñeñaro ĩna yirisere jidicãyijarã ĩna. Ito yicõri mama ʉsi wasoayijarã ĩna. Jonás ñayorʉre ĩna tʉorʉ̃nʉjare, tʉdi caticõri, “Mʉare seti ña”, yirã yirãji ĩna adi rʉmʉri gãnare. Yʉ ado mʉa rãca ñagʉ̃ Jonás ñayorʉ rẽto bʉsaro ñasagʉ ña yʉ. Ito bajibojarocati yʉre tʉorʉ̃nʉbea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Rocajʉ gago ʉjo ñayoro Dios ĩ waja seniri rʉmʉ mʉcana tʉdi caticoago yigõji iso. Mʉcana tʉdi caticõri adi rʉmʉri gãnare, “Mʉare seti ña”, yigo yigõji iso. “Salomón queno masigʉ̃ ñayijʉ”, yija tʉocõri, sõjʉ gago wadicõri ĩ tʉ ejayijo iso. Ito bajiri adi rʉmʉri gãnare, “Mʉare seti ña”, yigo yigõji iso. Yʉ ado mʉa rãca ñagʉ̃ Salomón rẽto bʉsaro ñasagʉ ña yʉ. Ito bajibojarocati yʉre tʉorʉ̃nʉbea mʉa, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Rʉ̃mʉ́ sĩgʉ̃re ĩ budija, ide manojʉ tuja ãmogʉ̃ ãma ucuguĩji. Ĩ bʉjabeja ado bajiro tʉoĩagʉ̃ yiguĩji: ");
INSERT INTO myy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Yʉ budigoadojʉ tʉdi warʉja yʉre”, yi tʉoĩaguĩji. Ĩ budigorʉre mʉcana tʉdi ĩ ejaja, queno wi ʉeri mani wi, queno carari wi robo bajiro ti ejagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ito bajiro ĩre ti ejacõri jʉa ãmojeno rʉ̃mʉ́a ĩ rẽto bʉsaro ñeñaro yirãre ãmi ejagʉ yiguĩji ĩ. Ito yicõri ĩna ñarocõti ʉ̃mʉgʉ̃re sãjarã yirãji ĩna. Ito bajiro ĩna sãjajare bʉto bʉsa ñeñaro yigʉ ñagʉ̃ yiguĩji ʉ̃mʉgʉ̃ ĩja. Ito bajiroti rẽtaro yiroja adi rʉmʉri gãna ñeñaro yirãre cʉni, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús masare ĩ bʉsiroca riti ĩ jaco ĩ ocabaji mesa rãca macʉ̃jʉ eja rʉ̃gʉ̃cã ĩna. Jesure bʉsirona ĩre ji bucõabojacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sĩgʉ̃ ĩre jigʉ ado bajiro yiquĩ ĩ Jesure: —Mʉ jaco, mʉ ocabaji mesa rãca ado macʉ̃jʉ ñama. Mʉ rãca bʉsi ãmoama ĩna, yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ito ĩ yijare ado bajiro cʉdiquĩ Jesús: —¿Ñimo ñati yʉ jaco, ito yicõri noa ñati yʉ ocabajirã? yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ito yija gʉa ĩ rãca riasotirãre ticõri: —Ãna ñama yʉ ñarã, ito yicõri yʉ jacore bajiro bajirã. ");
INSERT INTO myy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Noa yʉ Jacʉ ũmacʉ̃jʉ gagʉ ĩ rotiro bajiro yirã, ĩna ñama yʉ ocabajirãre bajiro bajirã, ito yicõri yʉ jacore bajiro bajirã, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iti rʉmʉti wire budi wacõri, itajura tʉnima rujicʉ gʉa Jesús rãca. Ito bajiro yicõri masare riasoquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Masa jãjarã bʉsa ĩna minijua wadija ticõri, cumajʉ sãjacõri rujiquĩ Jesús. Masa minijuacãna jajʉjʉ riti tujacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ito yija goti masiore ocana masare riasoquĩ Jesús. Ado bajiro riasoquĩ ĩ: —Sĩgʉ̃ wesecajʉ ĩ ya ote ajeri otegʉ wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Weseca ejacõri iti ajerire ĩ wẽjabateroca, gaje ajeri majʉ quedi queayijʉ. Ito bajiri minia ejacõri itire ba batecõyijarã. ");
INSERT INTO myy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Ito yicõri gaje ajeri gʉ̃ta watojʉ quedi queayijʉ. Queno sita mañijʉ. Ito bajiri judiboja, yoari mejeti siniacoayijʉ iti ũmacañi jeana, sita jõrecõri. Ito yicõri ñemari iti manijare siniacoayijʉ iti. ");
INSERT INTO myy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ito yicõri gaje ajeri jota watojʉ quediyijʉ. Ito bajiri jota mari itire dʉrea sĩacõyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gaje ajeriama sita quenaro quedi queayijʉ. Iti judi mʉjacõri queno rica cʉtiyijʉ. Coria sarari cien ñari ajeri rica cʉtiyijʉ. Gaje sarari setenta ñaricari, gaje sarari treinta ñaricari rica cʉtiyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mʉa gãmo goje cʉtija, yʉ bʉsirisere tʉo masiña mʉa, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ito bajiro Jesús ĩ yija tʉocõri, ado bajiro seniĩacʉ gʉa ĩ rãca riasotirã: —¿No yija goti masiore ocana masare riasoati mʉ? yicʉ gʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ado bajiro gʉare cʉdiquĩ ĩ: —“Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yi gãjerã ĩna tʉoĩabitire mʉa masiroca yami ĩ. Gãjerãreama ĩna masiroca yibeami Dios. ");
INSERT INTO myy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","No ĩre tʉorʉ̃nʉgʉ̃re jai bʉsaro tʉo masire gaye jidicãgʉ̃ yiguĩji Dios ĩre. Ito bajiri jai bʉsaro masigʉ̃ yiguĩji ĩ. No ĩre tʉorʉ̃nʉbicʉre jabetacã ĩ tʉoĩabojarisere ẽmacõgʉ̃ yiguĩji Dios ĩre. Ito bajiri ñe tʉoĩare mano tujagʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ito bajiri masare tʉo masire ocana ĩnare riasoa yʉ. Tibojarãti timenare bajiro ñama ĩna. Ito yicõri tʉobojarãti tʉomenare bajiro ñama ĩna. Ito bajiri Dios ocare tʉobojarãti, “Ito bajiro yireoni ñaroja iti”, yi tʉoĩa masibeama ĩna. ");
INSERT INTO myy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ito bajiro ĩna bajija Diore goti ĩsiri masʉ Isaías ñayorʉ ĩ gotiado bajiroti rẽta. Dios oca gotigʉ ado bajiro ucayoñi Isaías ñayorʉ: Yʉre tʉobojarãti itire tʉo masimena yirãji mʉa. Tibojarãti, “Ito bajia”, yi masimena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Adocãta gãna yʉ tʉoĩaro bajiro ĩna ya ʉsina yʉre tʉoĩa ãmobeama ĩna. Tʉobojarãti ñeñaro tʉo godo weorãji. Ito yicõri tibojarãti bibicãna bajiro bajiama ĩna. Yʉ ĩobojarise ti ãmobeama. Ĩna ya gãmo gojena tʉo ãmobeama ĩna. Ĩna ya ʉsina tʉo masi ãmobeama ĩna. Ito yicõri yʉre yisio rotirã ejamena yirãji ĩna, yi gotiami Dios, yi ucayoñi Isaías ñayorʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Queno wanʉrã ña mʉa. Yʉre ticõri ti masia mʉa. Ito yicõri yʉre tʉocõri tʉo masia mʉa. ");
INSERT INTO myy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Riti mʉare gotia yʉ. Jãjarã Diore goti ĩsiri masa ñayoana, queno yirã ñagoana cʉni mʉa tirisere ti ãmobojayijarã ĩna. Ito bajibojarocati tibisijarã ĩna. Mʉa tʉorise cʉni tʉo ãmobojayijarã. Ito bajibojarocati itire tʉobisijarã ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’“Oteri masʉ sĩgʉ̃ ado bajiro bajiyijʉ”, yirocʉ mʉare gotibʉ yʉ. Ito bajiri adocãta mʉare goti rẽtobugʉ ya yʉ, mʉa queno tʉo masitoni. Queno tʉoya mʉa. ");
INSERT INTO myy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire gaye oca tʉobojarãti, itire queno tʉo masimenaji gãjerã. Ĩna ñama ĩ otegʉ waroca majʉ quedira ajeri robo bajiro bajirã. Dios oca tʉobojarocati ĩna ãcabojaroca yami rʉ̃mʉ́. ");
INSERT INTO myy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Coriarã Dios oca tʉocõri queno wanʉre rãca boca ãmibojarãti yoari mejeti jidicãrãji ĩnaõna. Ĩna ñama gʉ̃ta watojʉ sita jõreroacã quedira ajeri robo bajiro bajirã. ");
INSERT INTO myy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Queno Dios oca tʉo ñiabiticõri, yoari mejeti jidicãrã yirãji ĩna. “Dios ocare yʉ tʉorʉ̃nʉja ticõri, yʉ tõbʉjaroca yama gãjerã. ¿No yija Dios ocare tʉorʉ̃nʉatibe yʉ?” yi tʉoĩa bojori bʉjarã yirãji ĩna. Ito bajiri ĩ ocare jidicãrã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Gãjerãma Dios oca tʉo ñiabojarãti bʉto adi sita gaye tʉoĩa ʉsirioama ĩnaõna. Ĩna ñama jota wato quedira ajeri robo bajiro bajirã. Bʉto gajeonire tʉoĩa ãmosacõri queno Dios ocare tʉo sʉyabeama ĩnaõna. Ito bajiri Dios ĩ ãmoro bajiro queno yi masimena yirãji ĩna, ito yicõri ĩre queno moa ĩsimenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Gãjerãma Dios oca tʉocõri queno tʉo ñiarã yirãji. Ĩna ñama sita quenarisejʉ quedira ajeri robo bajiro bajirã. Ito bajiri Dios ĩ ãmoro bajiro yirã yirãji ĩna. Ĩna ñarã yirãji cien rica cʉtiri sara robo bajiro bajirã. Ito yicõri gãjerã sesenta rica cʉtiri sara robo bajiro bajirã, gãjerãma treinta rica cʉtiri sara robo bajiro bajirã yirãji ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mʉcana gaje goti masiore ocana masare gotiquĩ Jesús: —“Ĩre tʉorʉ̃nʉmenare ruyuriogʉ yiguĩji Dios. Ĩre tʉorʉ̃nʉrãre riti ĩ rotirojʉ miojugʉ yiguĩji”, yirocʉ goti masiore ocana masare gotiquĩ Jesús: “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca masare mani riasoja, ado bajiro bajia iti. Tʉote mʉa. Sĩgʉ̃ ĩ ya wesecajʉ ĩ ya ote ajeri quenarise oteyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ĩ oteja bero ĩ caniroca ĩ ya weseca ejacõri ta widirise oteyijʉ ĩ wajacʉ. Ito yicõri wacoayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ito bajiri ote bʉcʉa mʉja wato ta widirise cʉni goayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ito bajija ticõri, ĩ ya moari masa ĩre gotirã wayijarã. Ĩ tʉ ejacõri ado bajiro yiyijarã ĩna: “¿Gʉa ʉjʉ ote quenarise riti otebojacati mʉ? ¿No yija ito bajibojarocati ta widirise wʉsari?” yiyijarã ĩna ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ito ĩna yijare: “Sĩgʉ̃ yʉ wajacʉ oterʉ”, yiyijʉ ĩ ĩnare. Ito ĩ yijare: “¿Adocãta ta widirise gʉa wãjagore ãmoati mʉ?” yi seniĩayijarã ĩna ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Wãjabeja. Mʉa wãjaja, ote rãcati wãjarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Adocãta ote rãca cocati bʉcʉacõjaro maji. Iti rica cʉtiroca mʉare wãja roticʉja yʉ maji. Ito yicõri itire soeja quenaroja. Ito bero rica ãmicõri rica cũadojʉ mʉare seo roticʉja yʉ”, yiyijʉ oteri masʉ ĩ ya moari masare, yi riasoquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mʉcana gaje goti masiore ocana ado bajiro masare gotiquĩ Jesús: —“Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca masare mani riasoja, ado bajiro bajia iti. Tʉote mʉa. Sĩgʉ̃ ĩ ya weseca mostaza ajeri oteyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gaje ote ajeri rẽtoro mʉtacã bʉsa ña iti mostaza ajeri. Ito bajiro mʉtacã ñabojaroti bʉcʉa wato gaje ote yucʉri rẽto bʉsaro jajocʉ ñaroja itigʉ. Jajocʉ itigʉ ñajare itigʉ rʉjʉrijʉ minia jibʉ menirãji ĩna. Itire bajiroti Dios mani Ʉjʉ ĩ ñaja, gãjerãre goti ãmorãji mani, jãjarã bʉsa ĩre masirã ĩna ñatoni, yi riasoquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mʉcana gaje ado bajiro goti masiore ocana riasoquĩ Jesús: —“Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca masare mani riasoja, ado bajiro bajia iti. Tʉote mʉa. Romio pan menigõ waco ʉdia coacõ pan menire gaye ãmiyijo iso. Ito yicõri wadarise ʉco wʉoyijo iso. Ito bajiri iso wʉoja jairo wadayijʉ iti. Itire bajiroti bajiro yiroja, “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, masare mani yi riaso ucuja. Ito bajiri jãjarã bʉsa ĩre tʉorʉ̃nʉ warã yirãji ĩja, yi riasoquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Masare riasogʉ goti masiore ocana riti ĩnare riasoquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ito bajiro masare ĩ riasoja Diore goti ĩsiri masʉ ĩ goticãdo bajiroti rẽtacʉ. Ado bajiro gotiyoñi ĩ: Goti masiore ocana riti masare gotigʉ yiguĩji ĩ. Ito yicõri adi macãrʉcʉ̃ro rujeoroto riojʉa gaye masa ĩna masibitire gotigʉ yiguĩji, yi ucañi Diore goti ĩsiri masʉ ñayorʉ yʉre tʉoĩa yugʉ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ito bajiro masare yi goti tĩocõri, “Wajʉ”, yiquĩ Jesús. Ito bajiro yicõri wijʉ maja ejacõri sãja waquĩ Jesús. Wijʉ sãja ejacõri ado bajiro seniĩacʉ gʉa ĩ rãca riasotirã: —Ta widirise gaye mʉ goti quenore ãmoa gʉa, yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ito bajiro gʉa yija, ado bajiro gʉare gotiquĩ Jesús: —Ote quenarise otegʉ yʉti ña Masa Rĩjorʉ. ");
INSERT INTO myy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ĩ otero ĩ ya weseca bajiro bajia ado mani ñarojʉ. Ote quenarisere bajiro bajirã ñama masa Diore tʉorʉ̃nʉrã. Ta ñeñarisere bajiro bajirã ñama masa rʉ̃mʉ́ ñarã. ");
INSERT INTO myy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ta widirise ote rudirʉ ĩti ñami rʉ̃mʉ́. Ote bʉcʉarijʉ ĩna ãmireoniti ña adi macãrʉcʉ̃ro iti jedirijʉ. Ote bʉcʉaroca miorãõnati ñama ángel mesa. ");
INSERT INTO myy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ta widirise ãmicõri ĩna soeado bajiro bajia macãrʉcʉ̃ro iti jedirijʉ. ");
INSERT INTO myy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yʉ ña Masa Rĩjorʉ. Ángel mesare cõagʉ̃ yigʉja yʉ, ñajediro ñeñarisere ĩna besecõatoni. Ñeñaro yirãre cʉni besecõarã yirãji ĩna, Dios ĩ rotirojʉ ĩna ejabe yirona. ");
INSERT INTO myy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ĩnare besecõri jeame ʉ̃jʉrojʉ ĩnare cõarã yirãji ĩna. Ito jeame ʉ̃jʉrojʉ ejacõri ñeñaro tõbʉjarã yirãji. Ito bajiri oticõri bʉto tʉoĩa oca jairã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dios ĩ rotiro bajiro yirã mani Jacʉ ĩ rotirojʉ ejacõri, ũmacañi busuro bajiro busu ñarã yirãji ĩna. Mʉa gãmo goje cʉtija, yʉ bʉsirisere tʉo masiña mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’“Dios ĩ rotirojʉ mʉa eja ãmoja, ñeñaro yirise jidicãcõri ĩre riti tʉorʉ̃nʉrã yirãji mʉa”, yirocʉ ado bajiro riasoquĩ Jesús gʉare: Sĩgʉ̃ gãji ye bʉto waja cʉtirise sita watojʉ ĩ yeyobojare bʉjayijʉ. Itire bʉjacõri mʉcana itijʉti tʉdi yeyocũ remoyijʉ ĩ. Ito bajiri itire wanʉgʉ̃, ĩ gajeoni cʉtirise ñarocõti gãjerãre ĩsi jeocõyijʉ ĩ niyeru bʉjarocʉ. Iti niyeru bʉjacõri iti sita ʉjʉre waja yirocʉ yiyijʉ ĩ. “Sita bʉjacõri sita wato yeyore cʉni bʉjagʉ yigʉja yʉ”, yirocʉ iti sita ʉjʉre waja yiyijʉ ĩ. Dios gaye quenarise mʉa bʉja ãmosaja, ĩre riti tʉorʉ̃nʉrã yirãji mʉa, yi riasoquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’“Dios ĩ rotirojʉ mʉa eja ãmoja, ñeñaro yirise jidicãcõri ĩre riti tʉorʉ̃nʉrã yirãji mʉa”, yirocʉ ado bajiro riasoquĩ Jesús gʉare: Sĩgʉ̃ ñaque bʉto waja cʉtirisere ãmagʉ̃ ñayijʉ. Iti ñaque perla wame cʉtirise ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iti ñaquere bʉto ãmoyijʉ ĩ. Ito bajiri, ĩ gajeoni cʉtirise ñarocõti ĩsi jeocõyijʉ ĩ, gãjerãre niyeru bʉjarocʉ. Ito yicõri iti ñaquere ãmosacõri waja yirocʉ yiyijʉ ĩ. Dios gaye quenarise mʉa bʉja ãmoja, ĩre riti tʉorʉ̃nʉ sʉyaja quena, yi riasoquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’“Ado bajiro bajia Dios rotirojʉ ĩre tʉorʉ̃nʉrãre ĩ miojuri rʉmʉ”, yirocʉ gʉare riasoquĩ Jesús: Gãjerã wai wayari masa yorigʉ cõacõri wai jeyarore ãmiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jãjarã wai bʉjacõri jajʉjʉ ĩnare mocũyijarã ĩna. Jajʉjʉ ĩnare mocũcõri ĩnare beseyijarã ĩna. Quenarãre jibʉjʉ miosãyijarã ĩna. Gãjerã ñeñarãreama cõa roacõyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ito bajiroti bajiro yiroja macãrʉcʉ̃ro iti jediri rʉmʉ. Ángel mesa quenarãre beserã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Besecõri ñeñarãreama jeame ʉ̃jʉrojʉ cõarã yirãji ĩna. Ito jeame ʉ̃jʉrojʉ ejacõri ñeñaro tõbʉjarã yirãji. Ito bajiri bʉto tʉoĩa oticõri oca jairã yirãji ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ito yija ado bajiro seniĩaquĩ Jesús gʉare: —¿Iti jeyaro mʉare yʉ gotirise tʉo masicʉati mʉa? yiquĩ Jesús. —Tʉo masia, yicʉ gʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gʉa ito bajiro yija, ado bajiro cʉdiquĩ ĩ gʉare: —Mʉa coriarã iti rʉmʉjʉ maji, bʉcʉrã oca riasori masa ñayijarã. Adocãtama yʉ rãca riasotirã ña mʉa. “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca yʉ rãca riasoticõri jʉaji masire gaye ña mʉare. Dios oca, bʉcʉ mʉa tʉogore cʉni ña mʉare. Bʉcʉ oca, Dios oca mame cʉni masia mʉa. Ito bajiri gajeoni seorajʉ bʉcʉ gaye mame gaye cʉni bese masirã bajiro bajirã ña mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ito bajiro gʉare goti masiore ocana ĩ gotija bero Jesús rãca wacʉ gʉa mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wacõri ĩ ya sita ejacʉ gʉa. Minijuara wijʉ ejacõri masare riasoquĩ Jesús. Queno ĩ riasoja tʉocõri, ʉcacã masa. Ĩre tʉocõri ado bajiro yicã ĩna: —¿Iti ĩ riasorise nojʉ riasotiyijaribe ãni? ¿Ito yicõri no bajiro tiyamani gaye ĩoati? ");
INSERT INTO myy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Adi sita gagʉ cumu jãi moari masʉ macʉ ñami ãni. Ito yicõri María macʉti ñami ãni. Santiago, José, Simón, Judas rĩjorʉti ñami ãni. ");
INSERT INTO myy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ito yicõri ĩ ñarã romia ado mani wato ñama ĩna. ¿No bajiro iti gaye masiati ãni? yicã ĩna ĩ ya cʉto gãna. ");
INSERT INTO myy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ĩna ya sita gagʉti ĩ ñajare queno ĩre tʉorʉ̃nʉbiticã ĩna. Ado bajiro ĩnare gotiquĩ Jesús: —Dios oca goti ĩsiri masʉre rʉ̃cʉbʉorã yirãji masa. Ito bajibojarocati ĩ ya sita gãna, ĩ ya wi gãna cʉni ĩre rʉ̃cʉbʉomena yirãji, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ĩ ya sita gãna ĩre ĩna queno tʉorʉ̃nʉbejare, jaje tiyamani ĩo jeobitiquĩ iti cʉtore. ");
INSERT INTO myy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Iti rʉmʉriti Galilea gagʉ ʉjʉ, Herodes wame cʉtigʉ Jesús gaye oca tʉoyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ĩ rãca ñarãre ado bajiro yiyijʉ Herodes, Jesure tʉoĩa wacʉ: —Juan idé guri masʉti ñaguĩji mʉcana. Godabojagʉti tʉdi catiguĩji. Ito bajiri tiyamani gaye ĩoguĩji ĩ, yi tʉoĩabojayijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ĩ Herodes ĩ ocabaji Felipe manojore ẽmayijʉ. Iso ñayijo Herodías wame cʉtigo. Ado bajiro yiyijʉ Juan Herodesre: —Isore manojo cʉtibitirʉja mʉre, yibojayijʉ Juan Herodesre. Ĩre tʉo ãmobisijʉ ĩ. Ito bajiri Juanre tubia rotiyijʉ Herodes. Ito yicõri come misina ĩre sia rotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Juanre sĩa ãmobojayijʉ Herodes. “Diore goti ĩsiri masʉ ñami Juan”, masa ĩna yi rʉ̃cʉbʉoja tʉocõri, güiyijʉ ĩ. Ito bajiri Juanre sĩa rotibisijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodes ĩ joeara rodo gãni bia ejayijʉ. Ito bajiri masare oca cõayijʉ ĩ, ĩna basa titoni. Iti rʉmʉ rujarʉmʉ Herodías maco masa riojo basayijo. Iso basaja ticõri, bʉto wanʉyijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ito bajiri: “No ãmorise mʉ senija, yiro roboti mʉre jidicãcʉja yʉ”, yiyijʉ Herodes isore. ");
INSERT INTO myy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ito bajiro ĩ yija tʉocõri, “¿No bajiro ãmoati cana mʉ?” yigo wayijo iso jacore. Jaco iso gotija tʉocõri, ado bajiro yiyijo iso Herodesre: —Juan idé guri masʉ ya rijoga jatacõri somotẽrojʉ jeocõri ĩsiña yʉre, yiyijo iso Herodesre. ");
INSERT INTO myy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ito bajiro iso yija tʉocõri, bojori bʉjayijʉ Herodes. Masa ĩna tʉoro riojo, “Yiro bajiroti mʉre ĩsicʉja yʉ”, ĩ yire ñajare, ito bajiroti rotiyijʉ ĩ ya moari masare. ");
INSERT INTO myy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","“Tubiara wijʉ Juanre rijoga jata ãmitẽña”, yiyijʉ Herodes ĩ ya moari masare. ");
INSERT INTO myy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ĩ ya rijoga jata ãmicõri somotẽrojʉ jeocõri mamore ĩsiyijarã ĩna. Ito yicõri isojʉ jacore rẽto ĩsiyijo ĩja. ");
INSERT INTO myy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Iti oca tʉocõri Juan rãca riasotiana masa ejayijarã. Ito yicõri ĩ ya rujʉ ãmi wacõri yujeyijarã. Ito bajiro ĩna yija bero Jesure gotirã gʉa tʉ ejacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan idé guri masʉre ĩna sĩare tʉocõri bojori bʉjaquĩ Jesús. Ito bajiri cuma sãjacõri ricati waquĩ ĩ. Ito bajiro Jesús ĩ waja masicã masa. Gãjerã boejʉna Jesure sʉya wacã. ");
INSERT INTO myy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Majado ejacõri Jesús ĩ tija masa jãjarã ñayijarã. Ito bajiri ĩnare ti maiyijʉ ĩ. Cõrãre ĩna ãmi ejaro bajiroti ĩnare yisio ĩsiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Iti rãioja ticõri, gʉa ĩ rãca riasotirã ĩ tʉjʉa wacʉ. Ĩ tʉ ejacõri ado bajiro yicʉ gʉa: —Ñamijʉ ña ĩja. Queno masa mama adojʉ. “Wasa”, yiya masare cʉtorijʉ bare ĩna waja yi masitoni, yibojacʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Itojʉ ware ma ĩnare. Mʉati bare ecaya ĩnare, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Bare ma gʉare. Naju riti co dʉjamocõacã ña gʉare. Ito yicõri wai jʉ̃arãti ñama gʉare, yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Adojʉa yʉre ãmi waya maji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Itire boca ãmicõri ta quenarise joe masare ruji rotiquĩ Jesús. Ito yicõri naju co dʉjamocõ ñarisere ito yicõri wai jʉ̃arã ñarãre ãmi rʉcoquĩ Jesús. Itire rʉcocõri ũmacʉ̃jʉ ti mʉoquĩ Jesús. Ito ti mʉocõri, “Queno ya Cʉna mʉ”, yiquĩ ĩ. Itire igajea batocõri gʉare ĩsiquĩ Jesús. Ito ĩ yija bero gʉajʉ masare batocʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Masa ñarocõti ba jedicã itire. Ito yicõri sĩgʉ̃ rʉyabeto yaji quenaro riti tujacã ĩna. Ĩna ba rʉarise jʉa gʉbojeno jibʉri dajacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gʉa itire bagoana cinco mil ʉ̃mʉa ñacʉ gʉa. Romiare ito yicõri rĩacare cʉni cõĩabiticʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Cumajʉ gʉare sãja rotiquĩ Jesús ĩ riojʉa gʉa jẽa watoni. Gʉa waroca riti masare ware gotiñi Jesús. ");
INSERT INTO myy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Masare ware goti tĩogʉ̃ tʉriajʉ mʉja wañi Jesús. Itojʉ sĩgʉ̃ti mʉja ejacõri ĩ Jacʉre bʉsiñi ĩ. Rãio jedija bero itojʉ ĩ sĩgʉ̃ti ñañi Jesús maji. ");
INSERT INTO myy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Itajura gʉdareco tʉjacʉ gʉa. Ito gʉa tʉjaroca jacũtucʉ gʉare, mino bʉto iti wẽajare. ");
INSERT INTO myy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Busu mʉja wadiroca Jesús gʉa tʉ ejaquĩ ide joena wadicõri. ");
INSERT INTO myy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ide joe ĩ wadija ʉcacʉ gʉa. Ito bajija ticõri: —Wʉjo cʉtiro ya, yi awasãcʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","—Oca sẽoña, güibesa yʉti ña, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ito ĩ yija tʉocõri, gʉa rãca gagʉ Pedro ado bajiro bʉsiquĩ ĩre: —Yʉ Ʉjʉ, mʉti mʉ ñajama, ide joe yʉ mʉ tʉ waroca yiya yʉre, yiquĩ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ĩ ito yijare: —Wadite mʉ, yiquĩ Jesús ĩre. Ito ĩ yija tʉo, wãgãcõri ide joe wasʉoquĩ Pedro Jesús tʉ ejagʉ wacʉ. ");
INSERT INTO myy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bʉto mino iti wẽaja tʉocõri, itire güiquĩ Pedro. Ito bajiri jacũrisena ruja wasʉoquĩ Pedro: —Yʉ Ʉjʉ yʉre masoña mʉ, yi awasãquĩ Pedro. ");
INSERT INTO myy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ito ĩ yirocati Pedro ya ãmojʉ ñiacõri ado bajiro yiquĩ Jesús ĩre: —Queno yʉre tʉorʉ̃nʉsabea mʉ. “Ide joe yʉ waroca yami Jesús”, ¿yi tʉoĩa jidicãri mʉ? yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cumajʉ Jesús rãca ĩna mʉja sãjarocati mino wẽata rojocoacʉ. ");
INSERT INTO myy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gʉa cumajʉ ñacãnama Jesús riojo rijomunigãna ñini rũjũcʉ, ĩre rʉ̃cʉbʉorã: —Riti Dios Macʉ ña mʉ, yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ito jẽa wacõri Genesaret wame cʉtiri sitajʉ ejacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iti cʉto gãna Jesús ĩ ejaja tʉo masicõri, masa jeyarore oca batoñi. Ito bajiri masa ñarise cʉtirãre ãmi ejacã Jesús tʉ. ");
INSERT INTO myy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“Mʉ ya yutabuju tʉnima gʉare moaĩa rotiya”, yicã masa Jesure. No moaĩarãcõti cati quenarã tujacã mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ito ĩna yiroca fariseo gaye tʉoĩarã ito yicõri judio masa rotirise riasori masa cʉni ejacã Jesús tʉ. Jerusaléna wadiana ñacã ĩna. Jesús tʉ ejacõri ado bajiro seniĩacã ĩna: ");
INSERT INTO myy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿No yija bʉcʉrã ĩna yisotire bajiro yiro robo cʉdibeati mʉ rãca riasotirã? Mʉ rãca riasotirã ĩna baroto riojʉa ãmo coebeama ĩna. Bʉcʉrã ĩna rotiado bajiro yiro robo yibeama ĩna, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ito bajiro ĩna yijare, ado bajiro ĩnare cʉdiquĩ Jesús: —Bʉcʉrã masa ĩna rotirejʉa cʉdirona Dios ĩ rotirisejʉare cʉdibea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ado bajiro rotia Dios oca: “Mʉ jacʉ, mʉ jacore cʉni queno rʉ̃cʉbʉoya mʉ. No ĩ jaco, ĩ jacʉre cʉni ñeñaro bʉsitugʉ godacoajaro”, yi rotia Dios oca. ");
INSERT INTO myy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mʉama ricati bajiro rotia. Ado bajirojʉa rotia mʉa: “No, ‘Jeyaro gajeoni yʉ rʉcorise Diore yʉ ĩsiroti riti ña. Ito bajiri yʉ jacʉsabatiare ejabʉa masibea yʉ’, ĩ yija, ĩ jacʉsabatiare ejabʉabeja quena”, yi tʉoĩa rotiboja mʉa. ");
INSERT INTO myy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ito bajiro mʉa yija, bʉcʉrã masa ĩna rotirisejʉa cʉdirona, Dios ĩ rotirisejʉare cʉdibea mʉa. Ito bajiro mʉa yija, “Ñe waja ma Dios oca”, yirã bajiro ya mʉa. Ĩ ocare jidicãrã ña mʉa. ");
INSERT INTO myy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mʉa yiro bajiro yirã meje ña mʉa. Diore goti ĩsiri masʉ Isaías ñayorʉ mʉare tʉoĩa wacʉ queno ucañi ĩ. Ado bajiro ucañi ĩ: ");
INSERT INTO myy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Mʉa ya risena riti yʉre rʉ̃cʉbʉoboja mʉa. Ito bajibojarocati mʉa ya ʉsina sõjʉ bajiro tʉoĩa mʉa. Yʉre rʉ̃cʉbʉobea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Minijuacõri yʉre mʉa rʉ̃cʉbʉobojaja, bʉrãti ya mʉa. Mʉa riasorise masa ĩna tʉoĩa rujeore ña iti. Itireti, “Dios ĩ rotire ña”, yiboja mʉa. Dios ĩ gotirise tʉoĩa wacʉ ito bajiro ucañi Isaías ñayorʉ, yi gotiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ito ĩ yija bero masare jicõri ado bajiro yiquĩ Jesús ĩnare: —Yʉre tʉocõri queno tʉo masiña mʉa. ");
INSERT INTO myy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mani ba sãrise meje mani ñeñaro yiroca yiroja iti. Ñeñaro tʉoĩacõri mani bʉsirise, iti ña mani ñeñaro yiroca yirise, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ito yija gʉa ĩ rãca riasotirã ĩ tʉ minijuacõri ado bajiro yicʉ gʉa ĩre: —Ito bajiro masare mʉ gotija tʉocõri, fariseo gaye tʉoĩarã tʉo bʉjatomenaji ĩna, yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ito bajiro gʉa yija, ado bajiro yiquĩ Jesús gʉare: —Dise rocati judire ĩ otere meje iti ñaja, ñe rãcati wãjacõagʉ̃ yiguĩji iti ote wese ʉjʉ. Ito bajiroti yigʉ yiguĩji yʉ Jacʉ cʉni. Gaje oca ñasarise mejeti ricati bajiro ĩna riasobojaja iti jedi waroca yigʉ yiguĩji yʉ Jacʉ. ");
INSERT INTO myy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dios ocare riasomena ĩna ñajare, ĩnare tʉorʉ̃nʉbeja. Ĩna ñama cajea mana gãjerã cajea manare tʉ̃a wabojarã robo bajiro bajirã. Sĩgʉ̃ cajea macʉ gãji cajea macʉre ĩ tʉ̃a wabojaja, goje ñaro ĩna ejaja, jʉ̃arãjʉti quedi sãjacoarã yirãji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ĩ ito yija ado bajiro seniĩaquĩ Pedro Jesure: —Iti riasore oca gaye queno gʉare goti rẽtobuya, yiquĩ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—¿Tʉo masibeati mʉa cʉni? ");
INSERT INTO myy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mani ba sãrise jeragajʉ waro yiroja iti. Ito bero rẽta budiro yiroja iti. ¿Itire queno tʉo masibeati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mani ya ʉsina tʉoĩacõri risena bʉsia mani. Iti ña mani ñeñaro yiroca yirise. ");
INSERT INTO myy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ĩna ya ʉsina tʉoĩacõri ñeñaro yama masa. Tite mʉa. Gãjerãre sĩama ĩna. Manojo cʉtirã ñabojarãti gãjerã romiare ajeama. Jeyaro ĩna tʉoĩaro bajiroti romia rãca ñeñaro ajeama ĩna. Riniama ĩna. Socama ĩna. Rocati oca gotiama ĩna. Ito bajiro yama masa. ");
INSERT INTO myy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ito bajiro ñeñarise tʉoĩacõri iti ña masa ĩna ñeñaro yiroca yirise. Mani baroto riojʉa mani ãmo coebeja, bʉcʉrã ĩna rotiro bajiro mani yibeja iti gaye meje ña mani ñeñaro yiroca yirise. Ñeñaro tʉoĩacõri ñeñaro ya mani. Iti ña mani ñeñaro yiroca yirise, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ito bajiro ĩ yija bero itijʉna, wacʉ gʉa Jesús rãca. Ito wacõri Tiro ito yicõri Sidón wame cʉtiri cʉtorijʉ ejacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ito gʉa ejaja bero sĩgõ Canaán gago itijʉ ñaro Jesús tʉjʉa awasã wadicõ: —Yʉ Ʉjʉ David ñayorʉ janami ña mʉ. Yʉre ti maiña. Yʉ maco rʉ̃mʉ́ sãñagõ ñamo. Ito bajiri bʉto ñeñaro tõbʉjamo iso, yi goticõ iso Jesure. ");
INSERT INTO myy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ito bajiro iso yibojarocati isore cʉdibitiquĩ Jesús. Ito bajiri ĩ rãca riasotirã gʉa ado bajiro roticʉ Jesure: —Isore wa rotiya. Ʉsirioro gʉare awasã sʉyamo, yibojacʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ito bajiro gʉa yija ado bajiro yiquĩ gʉare: —Oveja wisanare bajiro bajirã ñama judio masa. Ito bajiri ĩnare yʉre cũquĩ Dios, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ito bajiro ĩ yiroca ĩ riojo wacõri rijomunigãna ñini rũjũcõ romio: —Yʉ Ʉjʉ yʉre ejabʉaya, yicõ iso Jesure. ");
INSERT INTO myy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ito bajiro iso yibojarocati ado bajiro yiquĩ Jesús isore: —Judio masa riojʉajʉ gãjerãre yʉ ejabʉaja, no masia ma yʉre. Ito bajiro yʉ yija, rĩacare naju ẽmacõri yaiare ecado bajiro bajia, yiquĩ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Riti ya yʉ Ʉjʉ. Ĩna ʉjarã ba bate queorise bacã yaia. Yʉ gaje maso ñabojarocati mʉ ñarã bero yʉre jabeto mʉ ejabʉaja quena ñaro yiroja yʉre, yicõ iso Jesure. ");
INSERT INTO myy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ito bajiro iso yija tʉocõri, ado bajiro yiquĩ Jesús isore: —Mʉ romio queno yʉre tʉorʉ̃nʉgõ ña mʉ. Ito bajiri mʉ ãmoro bajiroti bajiro yiroja iti, yiquĩ Jesús. Ito bajiro ĩ yirocati iso maco tujacoacõ. ");
INSERT INTO myy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ito yija bero Galilea wame cʉtirita tʉnima wacʉ gʉa. Itojʉ ejacõri tʉriajʉ mʉja wacʉ gʉa. Itojʉ gʉa joejearoca rujiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jãjarã masa ejacã Jesús ĩ rujirojʉ. Wa masimena, cajea mana, bʉsimena, ruduana, ito yicõri jãjarã cõrãre ãmi ejacã ĩna Jesús tʉjʉ. Ĩ tʉ ĩna ãmi ejaroca ĩnare yisioquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bʉsimena bʉsicã. Ruduana wacã. Cajea mana ticã. Rujʉ ñeñarã quenari rujʉ, rujʉ cʉticã. Ito bajija ticõri, ti ʉcacã masa. Ito bajiri Diore wanʉ rʉ̃cʉbʉosʉocã ĩna. “Judio masa ĩna rʉ̃cʉbʉorʉ Dios ĩ ñami quenagʉ̃”, yi rʉ̃cʉbʉocã masa. ");
INSERT INTO myy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ito yija gʉa ĩ rãca riasotirãre ado bajiro yiquĩ ĩ: —Ado gãnare ti bʉjatobea yʉ. Ʉdia rʉmʉ tʉja ĩja, adocãta yʉ rãca ĩna ñaroca. Ito bajiri queno bare ma ĩnare. Ĩna babetoti ĩna ya wirijʉ wa roti ãmobea yʉ. Ĩnare yʉ wa rotija majʉ boga quedirã yirãji ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gʉajʉa ado bajiro yicʉ ĩre: —Ado masa manojʉ no bajiro masa tĩjaro bare bʉja masia ma, yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Nocõ jaje naju rʉcoati mʉa? yiquĩ Jesús gʉare. —Jʉa ãmojeno naju ña gʉare, ito yicõri wai jabetacã ña, yicʉ gʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ito yija masare jacajʉ ruji rotiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ĩ ya ãmona naju jʉa ãmojeno ñarisere ito yicõri wai rãca ãmi rʉcocõri, “Queno ya Cʉna mʉ”, yiquĩ ĩ Diore. Ito ĩ yija bero gʉa ĩ rãca riasotirãre ĩsiquĩ masare gʉa batotoni. ");
INSERT INTO myy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Masare batocʉ gʉa. Ĩna jeyaro bacã. Ito bajiri sĩgʉ̃ rʉyabeto yaji quenaro ñacã ĩna. Ĩna baja bero jʉa ãmojeno jibʉri gʉa ba rʉarise dajocʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gʉa itire bagoana cuatro mil ʉ̃mʉa ñacʉ gʉa. Romiare ito yicõri rĩacare cʉni cõĩabiticʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ito bero masare ware gotiquĩ Jesús. Ito bajiri cumana Magadán wame cʉtiri sitajʉ wacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo gaye tʉoĩarã ito yicõri saduceo gaye tʉoĩarã cʉni Jesure tirona ejacã ĩna. “ ‘Riti Dios ĩ cõarʉ ña mʉ’, gʉa yi masitoni ũmacʉ̃jʉ gaye tiyamani ĩoña gʉare”, yi ejabojacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ito ĩna yibojarocati ado bajiro cʉdiquĩ Jesús: —Rãiocũro ũmacʉ̃jʉ iti sũaja ticõri, “Quenari rʉmʉ ñari seyoa”, ya mʉa. ");
INSERT INTO myy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Busuri jĩjʉ iti sũaja mʉa tija, wajʉ bueri rãca iti ñaja. “Adi rʉmʉ quenado ma”, ya mʉa. Ũmacʉ̃jʉ ticõri, “Ito bajiro rẽtaro ya adi rʉmʉ”, yi masia mʉa. Ito bajibojarocati adi rʉmʉ rẽtarise gaye, “Ito bajiro bajiro wado ya”, yi masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ñeñaro yirã ña mʉa ito yicõri yʉre tʉorʉ̃nʉmena. Tiyamani ĩore yʉre seniboja mʉa. Ito bajiro mʉa yibojarocati jʉaji tiyamani mʉare ĩobicʉja yʉ. Jonás ñayorʉre tiyamani rẽtare gaye riti mʉare goticʉja yʉ, yiquĩ Jesús fariseo gaye tʉoĩarãre. Ito bajiro Jesús ĩ yija bero ĩnare wagocʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Itajura gaje dʉjajʉ jẽa ejacõri, “Mani baroti naju ãcabojacoayija mani”, yicʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ito yija Jesús ado bajiro gʉare gotiquĩ: —Fariseo gaye tʉoĩarã, saduceo gaye tʉoĩarã ĩna ya naju wadarise ʉco gaye queno tʉo masiña mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jesús ito bajiro ĩ yija gʉamasiti gãmeri tʉoĩa bʉsicʉ gʉa: —Mani naju ãcabojajare ito bajiro bʉsiami Jesús, yi tʉoĩabojacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ito bajiro gʉa tʉoĩabojaja tʉo masicõri, ado bajiro yiquĩ Jesús gʉare: —¿No yija, “Naju ma manire”, yati mʉa? Queno yʉre tʉorʉ̃nʉbea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Queno tʉo masibea maji mʉa. Canʉ bʉsati co dʉjamocõ naju ñarisere co dʉjamocõ mil masa ñarãre eca jeocʉ yʉ. Ĩnare yʉ eca jeoja bero jaje jibʉri dajocʉ mʉa. ¿Itire ãcabojati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ito bero canʉ bʉsati mʉcana jʉa ãmojeno naju ñarisere jʉaria mil masa ñarãre eca jeocʉ yʉ. Ĩna masare yʉ eca jeoja bero jaje jibʉri dajocʉ mʉa rʉyarise. ¿Itire ãcabojacoati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿No yija queno tʉoĩa masibeati mʉa maji? Jĩjʉ, “Fariseo gaye tʉoĩarã, saduceo gaye tʉoĩarã ĩna ya naju wadarise ʉco gaye queno tʉo masiña”, yʉ yija, naju gayere meje bʉsibʉ yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ito ĩ yijare tʉo masicʉ gʉa. “ ‘Fariseo gaye tʉoĩarã, saduceo gaye tʉoĩarã naju wadarise ʉco gayere tʉoĩarã ya mʉa’, gʉare ĩ yija, ‘Ĩna riasorisere queno tʉoĩa masiña mʉa’, yireonire gʉare gotiyijari Jesús”, yi tʉoĩacʉ gʉa ĩja. ");
INSERT INTO myy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mʉcana ito sõjʉa wacõri, Cesarea Filipo wame cʉtiri cʉto tʉ ejacʉ gʉa Jesús rãca. Itojʉ ejacõri ado bajiro gʉare seniĩaquĩ Jesús: —Yʉ ña Masa Rĩjorʉ. ¿Yʉre masa ĩna bʉsija, no bajiro yati ĩna? yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ado bajiro cʉdicʉ gʉa ĩre: —Coriarã ĩna bʉsija, “Juan idé guri masʉ ñami”, yama ĩna mʉre. Gãjerãma, “Elías ñami”, yama ĩna. Gãjerãma, “Jeremías ñami”, yama ĩna. Gãjerãma, “Diore goti ĩsiri masʉ ñaguĩji gajea”, yama ĩna mʉre, yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Mʉama ñimʉ ñami yati mʉa yʉre? yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ito ĩ yija tʉocõri, ado bajiro yiquĩ Simón Pedro: —Mʉti ña Cristo Dios ĩ cõarʉ. Dios catitĩñagʉ̃ Macʉ ña mʉ, ya yʉ mʉre, yiquĩ Simón Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Riti ya Simón, Jonás macʉ mʉ. Ito bajiro mʉ bʉsija wanʉ quenagʉ̃ ña mʉ. Itire mʉ bʉsija, masare tʉocõri meje bʉsia mʉ. Itire mʉ bʉsija, ũmacʉ̃jʉ gagʉ yʉ Jacʉre tʉocõri bʉsia mʉ. ");
INSERT INTO myy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ado bajiro mʉre gotia yʉ. Iti mʉ wame ña Pedro, “gʉ̃tagã”, yireoni ña iti Pedro. Riti ña mʉ bʉsirise. Iti oca mʉ bʉsirise jedibetoja. Gʉ̃tagã bʉtirica robo bajiro bajirise ña iti mʉ bʉsirise. Iti oca tʉocõri yʉre tʉorʉ̃nʉrã yirãji mʉ bero gãna. Ito bajiri yʉ ñarã, ñarã yirãji ĩna. Yʉre ĩna tʉorʉ̃nʉjare godana ʉjʉ ĩnare rẽtocũbicʉ yiguĩji. Godabojarãti mʉcana tʉdi catirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ado bajiro mʉre gotia Pedro yʉ. Soje janado rʉcogʉre bajiro mʉre cũgʉ̃ yigʉja yʉ. Ito bajiri, “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca masa ĩna tʉo masiroca yigʉ yigʉja mʉ. Ito bajiro mʉre cũgʉ̃ yigʉja yʉ. Adi sitajʉ mʉ rẽorise, ũmacʉ̃jʉ itojʉ cʉni rẽore ñaro yiroja. Adi sitajʉ, “Ito bajiroti yiya”, mʉ yija, ũmacʉ̃jʉ cʉni ito bajiroti yire ñaro yiroja, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ito bajiro Pedrore ĩ yija bero ado bajiro yiquĩ Jesús gʉare: “Ĩti ñami Cristo Dios ĩ cõarʉ, yi masare goti batobesa mʉa”, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ito ĩ yija bero itijʉnati gʉare goti rẽtobuquĩ Jesús: —Jerusalénjʉ ware ña yʉre. Itojʉ yʉ ejaroca bʉcʉrã, paia ʉjarã ito yicõri judio masa rotirise riasori masa cʉni quenabeto yʉ tõbʉjaroca yirã yirãji ĩna. Itojʉ yʉre sĩarã yirãji ĩna. Ito bajibojarocati ʉdia rʉmʉ beroti yʉ catiroca yigʉ yiguĩji Dios mʉcana, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ĩ ito yija tʉocõri, ricati bʉsa camotadi rʉ̃gʉ̃cõri, oca sẽoro ĩre bʉsisʉobojaquĩ Pedro: —Yʉ Ʉjʉ ito bajiro mʉre rẽtare ãmobiquĩji Dios. Ito bajiro mʉre rẽtabeto yiroja, yiquĩ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ito ĩ yija tʉocõri, jʉda rʉ̃gʉ̃cõri, ado bajiro bʉsiquĩ Jesús Pedrore: —Rʉ̃mʉ́a ʉjʉ Satanásre moa ĩsia mʉ. Yʉre camotadiya mʉ. Dios ĩ ãmoro bajiro yʉ yija, yʉre camota codea mʉ. Dios bajiro meje tʉoĩa mʉ. Masa ĩna tʉoĩaro bajiro tʉoĩa mʉ cʉni, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ito ĩ yija bero ado bajiro yiquĩ Jesús gʉare ĩ rãca riasotirãre: —Sĩgʉ̃ yʉre ĩ sʉya ãmoja, ĩ ye ñaroti tʉoĩabiticõri yʉjʉare tʉo mai sʉyagʉ yiguĩji. Yucʉtẽo gajagʉre bajiro tõbʉjabojagʉti yʉre riti sʉyagʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","No ĩ catirise maibojagʉti godagʉ yiguĩji. Ito bajibojarocati yʉre tʉorʉ̃nʉgʉ̃, yʉ oca ĩ gotija tʉo junisinicõri ĩna sĩagʉ̃ama catitĩñare gaye bʉjagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sĩgʉ̃ adi macãrʉcʉ̃rojʉ gajeoni jeyaro ĩ bʉjabojaja, ĩ ya ʉsi jeame ʉ̃jʉrojʉ iti waja, ĩ ya gajeoni ĩ bʉjabojare ñe waja ma. Ñe mani ya ʉsi rẽto bʉsaro waja cʉtirise manoja. Catirãjʉti Dios rãca mani oca quenobeja, mani godaja bero ĩ rãca oca queno masimenaji ĩja. ");
INSERT INTO myy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉ Masa Rĩjorʉ ñacõri, yʉ Jacʉ Dios ĩ busurisena tʉdi ejagʉ yigʉja yʉ. Ito yicõri ĩ tʉ gãna ángel mesa rãca ejagʉ yigʉja yʉ. Tʉdi ejacõri masa ĩna yigoado bajiroti waja senigʉ̃ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Riti mʉare gotia yʉ. Mʉa coriarã adijʉ ñarã mʉa godaroto riojʉa, ĩre tʉorʉ̃nʉrãre Masa Rĩjorʉ ĩ mioju ejaroca tirã yirãji mʉa. Ĩti ña yʉ Masa Rĩjorʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Co ãmojeno ʉ̃mʉari bero Pedro, Santiago, ĩ ocabaji Juanre cʉni ũmari tʉria joejʉ ĩnare ãmi waquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Itojʉ ĩna ejaroca ĩna riojo Jesús ĩ ya rio gajero bajiro godo wediyijʉ. Ʉ̃mʉa gagʉ ũmacañire bajiro yoyijʉ ĩ ya rio. Ito yicõri ĩ ya yutabuju bʉto boticõri yoyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ĩna tiroca Moisés ñayorʉ, Elías ñayorʉ rãca Jesús tʉ goaĩoyijarã. Ito bajicõri Jesús rãca ĩna gãmeri bʉsija, tiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ito bajija ticõri, ado bajiro yiyijʉ Pedro Jesure: —Yʉ Ʉjʉ adojʉ mani ñaja quenasacõa. Mʉa ãmoja mʉare yiari wi meni ĩsirʉja gʉa. Mʉre co wi, Elíasre co wi, Moisésre co wi meni ĩsirʉja gʉa, yiyijʉ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ito bajiro Pedro ĩ bʉsibojaroca riti ide bueri bʉto yorise ĩnare gũma rʉ̃gʉ̃yijʉ. Iti ide bueri watonati oca ruyuyijʉ: —Ãniti ñami yʉ Macʉ, yʉ maigʉ̃. Ĩre bʉto wanʉa yʉ. Ĩre queno tʉoya mʉa, yire oca ruyuyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iti oca tʉocõri bʉto güiyijarã ĩna. Ito bajiri bʉto güirã ĩna ya rio sitajʉ muqueayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ito bajiro ĩna bajija ticõri, ĩna tʉ wacõri ĩnare moaĩayijʉ Jesús. Ĩnare moaĩacõri ado bajiro yiyijʉ ĩ: —Wʉmʉña. Güibesa mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ito ĩna ti mʉoja, gãjerãre tibisijarã ĩna. Jesús sĩgʉ̃ti ĩ ñaja tiyijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iti tʉria ĩna roja waroca ado bajiro ĩnare gotiyijʉ Jesús: —Janeti mʉa tirise masare goti batobeja maji. Yʉ ña Masa Rĩjorʉ. Yʉre sĩarã yirãji masa. Yʉre ĩna sĩabojarocati tʉdi catigʉ yigʉja yʉ. Yʉ mʉcana tʉdi catiroto riojʉa, jĩjʉ mʉa tigorise gãjerãre goti batobeja mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ito yija ado bajiro Jesure seniĩayijarã ĩna: —¿No yija judio masa rotirise riasori masa, “Elíasjʉa ejasʉogʉ yiguĩji”, yicati ĩna? yi seniĩayijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ito yija ado bajiro ĩnare cʉdiyijʉ Jesús: —Riti yiñi judio masa rotirise riasori masa. “Elíasjʉa ejasʉogʉ yiguĩji. Ejacõri jeyaro quenogʉ̃ yiguĩji ĩ”, ĩna yija riti gotiñi. ");
INSERT INTO myy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ito bajiro ĩna gotibojarocati Elías ĩ ejaja ĩre ti masibisĩ masa. Riti mʉare gotia yʉ. Elías ejacãñi. Ĩ ejaja ĩre ti masibisĩ masa. Ĩna ãmoro bajiroti yiñi masa ĩre. Ito bajiroti yʉ Masa Rĩjorʉre, tõbʉjaroca yirã yirãji masa yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ito bajiro ĩ yija tʉocõri, “Juan idé guri masʉre bʉsiami ãni”, yi tʉo masiyijarã ĩna Pedro mesa. ");
INSERT INTO myy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Roja wadicõri gʉa tʉ ejacã ĩna mʉcana. Jãjarã masa ñacã gʉa rãca. Jesús ĩ tʉdi ejaja ticõri, ĩ riojo rijomunigãna ñini rũjũquĩ sĩgʉ̃. Ito yicõri ado bajiro yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Yʉ Ʉjʉ yʉ macʉre ti maiña mʉ. Ñama cõre cõsotiami ĩ. Ito bajiri ruje tõbʉjasotiami ĩ. Biyaro ʉsi jedi quedisotiami yʉ macʉ. Coji rʉyabeto jeame ʉ̃jʉrojʉ ʉsi jedi quedisotiami ĩ. Ito yicõri riacajʉ cʉni ʉsi jedi quedisotiami. ");
INSERT INTO myy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mʉ rãca riasotirã tʉjʉ ĩre ãmi ejabojabʉ yʉ. Ĩre yisio masibeama ĩna, yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ito ĩ yija ado bajiro yiquĩ Jesús masare: —Queno yʉre tʉorʉ̃nʉbea mʉa maji. Masa ñeñaro yirãre bajiro bajia mʉa maji. ¿Nocõ yoari mʉa rãca ñagʉ̃ yigʉjada yʉ maji? ¿Nocõ yoari yugʉ yigʉjada yʉ, mʉa masitoni? Adojʉa ãmi waya, ʉsi jedi quedisotigʉre, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ʉsi jedi quedisotigʉ ĩ ejaja ticõri, rʉ̃mʉ́re budi rotiquĩ Jesús. Rʉ̃mʉ́ ĩ budirocati, cati quenagʉ̃ ñacõaquĩ macʉacã mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ito yija bero ricati Jesús rãca bʉsicʉ gʉa mʉcana: —¿No yija rʉ̃mʉ́re bucõa masibiti gʉa? yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Yʉre queno tʉorʉ̃nʉbiticõri rʉ̃mʉ́re bucõa masibea mʉa maji. Riti mʉare gotia yʉ. Jabetacã yʉre mʉa tʉorʉ̃nʉja, jaibiti aje mostaza aje robo bajiro yʉre mʉa tʉorʉ̃nʉja, mʉa rotiro bajiroti bajiroja. I tʉriare, “Gajerojʉ cʉní rʉ̃gʉ̃ña”, mʉa yija, mʉa rotiro bajiroti bajiroja iti. Ñejʉa mʉa yi masibiti mano yiroja, queno yʉre mʉa tʉorʉ̃nʉja. ");
INSERT INTO myy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ito bajiro masare ĩna rʉ̃mʉ́a sãñaja, bamena riti Diore mʉa senija, rʉ̃mʉ́are bucõa masirãji mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea sitajʉ cojʉ gʉa waroca ado bajiro yiquĩ Jesús gʉare: —Masa Rĩjorʉ ña yʉ. Yʉre ĩna ñiatoni gotigʉ yiguĩji sĩgʉ̃. ");
INSERT INTO myy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yʉre ñiacõri sĩarã yirãji ĩna. Ito bajibojarocati ʉdia rʉmʉ beroti yʉ catiroca yigʉ yiguĩji Dios, yiquĩ Jesús gʉare. Ito bajiri iti tʉocõri bʉto bojori bʉjacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ito yija bero Capernaum wame cʉtiri cʉto ejacʉ gʉa Jesús rãca. Itojʉ gʉa ñaroca minijuara wi coderã waja seniri masa Pedrore oca seniĩarona ejayijarã. Ĩ tʉ ejacõri ado bajiro ĩre seniĩayijarã ĩna: —¿Mʉre riasogʉ Dios ya wi waja yibeati ĩ? yi seniĩayijarã ĩna Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Waja yigʉ yiguĩji, yi cʉdiyijʉ Pedro. Jesure bʉsirocʉ wijʉ ĩ sãjaroca, Jesujʉa ado bajiro ĩre bʉsigoquĩ: —¿No bajiro tʉoĩati Simón mʉ? ¿Adi sita gãna ʉjarã noare waja seniati? ¿Ĩna ñarãre seniatite? ¿Gãjerãjʉare seniatite? yi seniĩaquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Gãjerãre waja seniama ĩna, yi cʉdiquĩ Pedro. Ĩ ito yija, ado bajiro yiquĩ Jesús: —Riti ya mʉ. Dios Macʉ yʉ ñajare yʉre waja seniado mama ĩna. ");
INSERT INTO myy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ito bajibojarocati ñeñaro manire ĩna bʉsitube yirona waja yija quena. Itajurajʉ wasa. Itojʉ wai joba. Cajero basʉogʉti ĩre sĩacõri ĩ ya risejʉ niyeru cuji bʉjagʉ yigʉja mʉ. Iti niyeru cujina manire ĩna waja senija, ñarocõti tĩjacoaro yiroja iti. Iti cuji ãmicõri ĩnare waja yiya, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iti rʉmʉriti, gʉa Jesús rãca riasotirã ĩre seniĩacʉ: —¿Ũmacʉ̃jʉ Dios ĩ rotirojʉ ñimʉ ñati ñasagʉ ñarocʉ? yi seniĩacʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ito bajiro gʉa yija tʉocõri, sĩgʉ̃ macʉacãre ãmicõri gʉa wato cũquĩ. ");
INSERT INTO myy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ado bajiro yiquĩ Jesús gʉare: —Riti mʉare gotia yʉ. Mʉa ñeñaro yirise mʉa jidicãbeja, ito yicõri bʉcʉrãre rĩaca ĩna tʉorʉ̃nʉro bajiro yʉre mʉa tʉorʉ̃nʉbeja, ũmacʉ̃jʉ Dios ĩ rotirojʉ ejamena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ado bajiro bajigʉ yiguĩji ũmacʉ̃jʉ Dios ĩ rotirojʉ ñasagʉ ñarocʉ. Ãni macʉacãre bajiro, “Ñasagʉ ña yʉ”, yi tʉoĩabicʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Noa yʉre tʉorʉ̃nʉcõri ãni macʉacãre ĩna boca ãmiro bajiro yʉre cʉni boca ãmirã yirãji ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mʉcana ado bajiro gotiquĩ Jesús gʉare: —No macʉacã yʉre tʉorʉ̃nʉsʉogʉre ñeñaro yiroca gãji ĩ yija, ĩre bʉto waja senigʉ̃ yiguĩji Dios. Quenogoroama ito bajiro yigʉre ĩ ya ãmʉmajʉ gʉ̃tagã jajoca sia yocõri riaca ʉ̃carojʉ rucõaja quenaroja. ");
INSERT INTO myy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bʉjato bʉjarã yirãji adi macãrʉcʉ̃ro gãna ñeñaro yiri masa. Masare ñeñaro ĩna yiroca yirise ito bajiro riti bajitĩñaro yiroja. Ito bajibojarocati, gãjerã ĩna ñeñaro yiroca ĩnare yigʉre bʉjato bajia ĩre, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Mʉa ya ãmo, mʉa ya gʉbo, mʉa ñeñaro yiroca mʉare iti yija, itire jatacõri sõjʉ cõacõña. Manire co dʉja ãmo manija quenabetoja. Ito bajibojarocati jʉa ãmo, ãmo cʉtirã ñabojarãti jeame ʉ̃jʉrojʉ manire Dios ĩ cõaja, rẽto bʉsaro quenabeto yiroja. ");
INSERT INTO myy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mʉa ya cajea mʉa ñeñaro yiroca iti yija, ruacõri sõjʉ cõacõña. Manire co dʉja cajea manija quenabetoja. Ito bajibojarocati jʉa cajea, cajea cʉtirã ñabojarãti jeame ʉ̃jʉrojʉ manire Dios ĩ cõaja, rẽto bʉsaro quenabeto yiroja. Dios ĩ ñarojʉ mani ejaja, bʉto bʉsa wanʉ quenarã yirãji mani. “Mʉa ñeñaro yirise jidicãña”, yirocʉ ito bajiro yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mʉcana ado bajiro gotiquĩ Jesús gʉare: —Mʉtarã yʉre masisʉorãre sĩgʉ̃jʉare tibo yibesa. Ũmacʉ̃jʉ ángel mesa ñarãji ĩnare tirʉ̃nʉrã. Co rʉmʉ rʉyabeto yʉ jacʉ tʉ ñacãma ĩna. ");
INSERT INTO myy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yʉ ña Masa Rĩjorʉ. Jeame Ʉ̃jʉrojʉ waboanare masorocʉ wadicʉ yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Gʉare riasorocʉ ado bajiro yiquĩ Jesús mʉcana: —Adocãta yʉ mʉare riasorisere queno tʉoĩaña mʉa. Sĩgʉ̃ ñayijʉ cien oveja rʉcogʉ. Co rʉmʉ gãjerãre wagocõri sĩgʉ̃ wisayijʉ oveja. ¿No bajiro tʉoĩati mʉa? ¿Gãjerã rʉyarã, ta wesejʉ noventa y nueve ñarã wisarʉre ãmagʉ̃ waguĩjida ĩ? ");
INSERT INTO myy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ĩre ãmagʉ̃ wacʉ yiguĩji ĩ. Wisarʉre ĩ bʉjaja, bʉto wanʉgʉ̃ yiguĩji ĩ. Riti ña. Gãjerã wisamena noventa y nueve ñarã rẽtoro wisarʉre ĩ bʉjaja wanʉgʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mani Jacʉ ũmacʉ̃jʉ gagʉ ito bajiroti bajiami ĩ cʉni. Sĩgʉ̃ yʉre masisʉogʉ ĩ wisare ãmobiquĩji Dios, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mʉcana gʉare ado bajiro riasoquĩ Jesús: —Sĩgʉ̃ mʉa yagʉ mʉare ĩ ñeñaro ĩ yija, ĩ rioti oca quenoma, “Riti ya mʉa, mʉare ñeñaro yicʉ yʉ”, ĩ yi masitoni. “Riti ya mʉa”, ĩ yija oca quenocãna ña mʉa. Ito bajiri mʉa yagʉ rãca queno baba cʉtirã yirãji mʉa mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","“Bajibea bʉrãti ya mʉa”, ĩ yija, gãjerã jʉ̃arãre ji ñucama. Ito bajiri mʉa bʉsirise ĩna tʉoja. “Riti bajia iti”, yi masirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ĩnare riojo ĩ tʉorʉ̃nʉbeja, jãjarã Diore masirã riojo gotiba mʉa. Ĩna jãjarãre ĩ tʉorʉ̃nʉ ãmobeja, Diore masibicʉ robo bajiro ĩre mʉa rʉcoja quena. Sĩgʉ̃ ñeñaro yigʉ, ʉjarãre yiari waja seni ĩsiri masʉre bajiro rʉcoja quena mʉa ĩre, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Riti mʉare gotia yʉ. Ũmacʉ̃jʉ gagʉ Dios ĩ cũana ña mʉa. Adi macãrʉcʉ̃rojʉ mʉa rẽoja, ũmacʉ̃jʉ Dios tʉjʉ cʉni rẽore ñaro yiroja. Gajere cʉni, “Ito bajiroti bajiya mʉ”, mʉa yiro bajiroti ũmacʉ̃jʉ cʉni bajiro yiroja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Gaje ado bajiro mʉare gotia yʉ. Mʉa jʉ̃arã sĩgʉ̃re bajiro tʉoĩacõri Diore mʉa seni ãmoja, mʉa ãmoro bajiroti ĩsigʉ̃ yiguĩji yʉ Jacʉ ũmacʉ̃jʉ gagʉ. ");
INSERT INTO myy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","No jʉ̃arã ʉdiarã yʉre tʉorʉ̃nʉrã ĩna minijuaja, ĩna rãca ñagʉ̃ yigʉja yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ito ĩ yija bero Pedro ado bajiro seniĩaquĩ Jesure: —Yʉ Ʉjʉ sĩgʉ̃ yʉ yagʉ yʉre ñeñaro ĩ yija, ¿nocõjiri ĩre yʉ ãcabojoja quenati? ¿Jʉa ãmojeno ĩre yʉ ãcabojoja quenati? yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ĩ ito yija tʉocõri, ado bajiro cʉdiquĩ Jesús ĩre: —Jʉa ãmojeno rẽtoro, coji rʉyabeto mʉre ĩ senirocõ ĩre mʉ ãcabojoja quena, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mʉcana Jesús gʉare ado bajiro riasoquĩ: —“¿Dios ũmacʉ̃jʉ rotigʉ no bajiro bajiati ĩ?” mʉa yi masi ãmoja, sĩgʉ̃ ʉjʉre tʉoĩate mʉa. Ado bajiro yiyijʉ ĩ. Ĩ ya moari masare ji ñucacõri, ĩre ĩna waja ruyuriorisere cõĩayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ĩ cõĩasʉoroca sĩgʉ̃ ĩre jairo niyeru waja ruyuriogʉre ĩre ãmi ejabojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ĩ ʉjʉre waja yi masibisijʉ ĩ. Ito bajiri, “Gãjerãre yʉre ĩsi ĩsitẽña”, yiyijʉ ʉjʉ. Ĩre, ĩ rĩare, ĩ manojore, ĩ ya gajeoni jeyaro gãjerãre yʉre ĩsi ĩsitẽña. Ĩna waja mʉa bʉjarise yʉre mʉa ĩsija, ĩ yʉre waja ruyuriorise tĩjaro yiroja, yiyijʉ ʉjʉ ĩre ãmi ejanare. ");
INSERT INTO myy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ito ĩ yija tʉocõri, ĩre waja ruyuriogʉ ĩ riojo rijomunigãna ñini rũjũyijʉ. Ito yicõri ĩre josayijʉ ĩ: “Yʉ ʉjʉ jabeto yuya maji. Mʉre yʉ waja ruyuriorise waja tĩogʉ̃ yigʉja yʉ maji”, yiyijʉ ĩ, ĩ ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ito ĩ yija tʉocõri, ĩre ti maiyijʉ ĩ: “Baʉ, no yibeati”, yi ĩre jidicãyijʉ ĩ, ĩ ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Ito bajiro ĩ ʉjʉ yija tʉocõri, budi wayijʉ ĩ. Budi wacõri ĩ baba ĩre waja ruyuriogʉre ti bʉjayijʉ ĩ cʉni. Ito bajiri ĩ babare ĩ ya ãmʉma ñia rʉ̃gʉ̃cõri, “Yʉre mʉ waja ruyuriorise cojiti waja tĩoña mʉ”, yiyijʉ ĩ ĩre. ");
INSERT INTO myy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ito ĩ yija tʉocõri, ĩ ya rijomunigãna ñini rũjũyijʉ ĩ: “Jabeto yʉre yuya maji. Mʉre yʉ waja ruyuriorise mʉre waja tĩogʉ̃ yigʉja yʉ maji”, yibojayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ito ĩ yibojarocati tʉobisijʉ ĩ. Ito bajiri tubiara wijʉ ãmi wacõri ĩre cũyijʉ ĩ. “Yʉre mʉ waja ruyuriorise mʉ tĩobeja, budibicʉ yigʉja mʉ”, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Gãjerã moari masa ito bajiro ĩ yija ticõri, bʉjatobisijarã ĩna. Ito bajiri ʉjʉ tʉ wacõri ñarocõti gotiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ito bajiri ĩre ĩna gotija tʉocõri, “Ĩre yʉre ji ĩsitẽña”, yiyijʉ ʉjʉ. Ĩ ejaja ticõri, ado bajiro ĩre yiyijʉ ĩ: “Yʉre moa ĩsiri masʉ quenabisija mʉ. ‘Yʉre mʉ waja ruyuriorisere ito bajicõato mʉre’, yibojacʉ yʉ, yʉre mʉ josajare. ");
INSERT INTO myy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mʉre yʉ ti maicato bajiroti gãji mʉ babare ti mairʉjaboyija mʉ”, yiyijʉ ʉjʉ ĩre moa ĩsiri masʉre. ");
INSERT INTO myy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bʉto junisinicõri ĩre ĩ waja ruyuriorise ĩ waja tĩotoni ĩre tubia rotiyijʉ ĩ ʉjʉ: “Yʉre ĩ waja ruyuriorise ĩ tĩobeja budibicʉ yiguĩji ĩ”, yiyijʉ ʉjʉ, yi gotiquĩ Jesús gʉare, gʉa tʉo masitoni. ");
INSERT INTO myy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Bajiroti gaye gʉare riasoquĩ Jesús. Ado bajiro gʉare gotisʉsaquĩ Jesús: —Ito bajiro riti yigʉ yiguĩji yʉ Jacʉ ũmacʉ̃jʉ ñagʉ̃ cʉni, gãjerã mʉa ñarãre ñeñaro ĩna yirisere mʉa ãcabojobeja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ito bajiro Jesús ĩ yija bero Galilea sitana wacõri, Judea sitajʉ ejacʉ gʉa. Jordán wame cʉtirisa tʉ ũmacañi ĩ joejea mʉja wadiri sitajʉa ñacʉ iti sita. ");
INSERT INTO myy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jãjarã masa Jesure sʉya wacã. Cõrã ĩna ñaja ĩnare yisioquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Itojʉ gʉa ñaroca fariseo gaye tʉoĩarã ejacã Jesús tʉ. “Mani seniĩaja, queno cʉdi masibicʉ yiguĩji ĩ”, yirona seniĩabojacã ĩna Jesure: —¿Sĩgʉ̃ ĩ manojore ĩ cõaja, ĩ ãmoro bajiroti ĩ manojore ĩ cõaja quenati? yi seniĩacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","—¿Dios oca tuti tiĩabiticati mʉa? Ĩ oca gotia, “Cajero rujeoñi ʉ̃mʉgʉ̃re ito yicõri romiore cʉni”, yi gotia ĩ oca. ");
INSERT INTO myy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gaje ado bajiro gotia ĩ oca: “Ĩ manojo rãca ñarocʉ ĩ jacʉre ĩ jacore jidicãgʉ̃ yiguĩji ĩ. Manojo cʉticõri jʉ̃arã ñabojarãti sĩgʉ̃re bajiroti bajirã yirãji ĩna”, yi gotia Dios oca. ");
INSERT INTO myy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ito bajiroti bajia iti gaye. Jʉ̃arã ñabojarãti sĩgʉ̃re bajiro ñarãji ĩna ĩja. Ito bajiri Dios ĩ babocãre ñajare manojore jidicã masia ma, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ito ĩ yija tʉocõri, ado bajiro seniĩacã ĩna: —Riti mʉ gotija, ¿no yija ricati rotiyijari Moisés ñayorʉ? Ado bajiro rotiyoñi ĩ: “Isore mʉ jidicã ãmoja, jidicãre papera isore ĩsiña”, yiyoñi Moisés ñayorʉ, yicã ĩna Jesure fariseo gaye tʉoĩarã. ");
INSERT INTO myy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ito bajiro ĩna yija tʉocõri, ado bajiro cʉdiquĩ Jesús: —Diore ĩna cʉdi ãmobejare, manojore jidicãre gaye rẽobisĩ Moisés ñayorʉ. Ito bajibojarocati cajeroama ito bajiro meje bajiyija. ");
INSERT INTO myy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Riti mʉare ado bajiro gotia yʉ. Sĩgʉ̃ ĩ manojore gãjire iso ajebitibojarocati ĩ jidicãja, ñeñaro yigʉ yami ĩocʉ̃. Isore jidicãcõri gajeore ĩ manojo cʉtija, ajegʉ yami ĩocʉ̃. Gãji cõaro rãca ĩ manojo cʉtija, ajegʉ yami ĩocʉ̃ cʉni, yiquĩ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ito ĩ yija tʉocõri, gʉa ĩ rãca riasotirã ado bajiro yicʉ ĩre: —Riti ito bajiro iti bajijama manojo cʉtire ma, yicʉ gʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ado bajiro yiquĩ Jesús gʉare: —Ñarocõgoroama tʉo masi jedi yimenaji adire. Ĩna tʉo masiroca Dios ĩ yiana riti tʉo masirã yirãji. ");
INSERT INTO myy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Coriarã ĩna manojo cʉti masibeja, ricati riti bajia ĩna ya rujʉri. Coriarã ito bajironati rujeana ĩna. Gãjerãma, gãjerã ʉ̃mʉa ĩnare ñeñoja bero manojo cʉti masimenaji ĩnaõna. Gãjerãma ũmacʉ̃jʉ gagʉ Diore riti rʉ̃cʉbʉorona manojo manaji ĩnaõna. No itioni gaye cʉdi ãmogʉ̃ti cʉdiguĩji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ito yija bero gãjerã rĩacare Jesús tʉ ãmi ejacã. Ĩna joe ãmo jeocõri Diore ĩnare bʉsi ĩsitoni, ĩnare ãmi ejacã ĩna. Ĩna ãmi ejaja ticõri. “Ãmi wadibesa maji. Ʉsirioro ya mʉa”, yicʉ gʉa ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ito bajiro gʉa yibojarocati Jesuama ado bajiro yiquĩ: —Rĩacare rẽobesa, yʉ tʉ wadijaro ĩna. Rĩaca ñama yʉre queno tʉorʉ̃nʉrã. Ĩna robo yʉre queno tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ito ĩ yija bero ĩnare yiari Diore bʉsi ĩsirocʉ ãmo moa jeoquĩ Jesús. Ito ĩ yija bero gajerojʉa wacʉ gʉa Jesús rãca mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Co rʉmʉ sĩgʉ̃ mamʉ Jesure seniĩagʉ̃ ejaquĩ: —¿Queno riasogʉ catitĩñare gaye yʉ bʉja ãmoja, no bajiro yigʉjada yʉ? ¿Ñe quenarise gaye yigʉ yigʉjada yʉ? yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿No yija quenagʉ̃ yʉre yati mʉ? Sĩgʉ̃ ñami queno yigʉ. Ĩti ñami Dios. Catitĩñare gaye mʉ ãmoja, Dios ĩ rotirisere cʉdija quena, yiquĩ Jesús mamʉre. ");
INSERT INTO myy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Ñe rotire gaye yigʉjada yʉ? yiquĩ ĩ Jesure. —Gãjire sĩabeja. Gãji manojore ajebeja. Romia cʉni gajeo manʉjʉre ajebeja. Rinibeja. Gãjerãre rʉo gotibeja. ");
INSERT INTO myy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉ jacʉre, mʉ jacore cʉni rʉ̃cʉbʉoba. Ito yicõri mʉ ya rujʉre mʉ mairo bajiroti, mʉ ñarãre cʉni maima, yiquĩ Jesús mamʉre. ");
INSERT INTO myy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Macʉacã ñagʉ̃jʉti itire ito bajiro yisʉocʉ yʉ. ¿Ñe gaje rʉyati yʉre queno yʉ yiroti? yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ito ĩ yija, ado bajiro cʉdiquĩ Jesús: —Ñarocõti mʉ cʉdi jeo ãmoja, ado bajiro yiya. Jeyaro mʉ rʉcorise gãjerãre ĩsi jeocõña. Ito yicõri iti waja bʉjacõri bojoro bʉjarãre ĩsima. Ito bajiro mʉ yija, ũmacʉ̃jʉ queno bʉjagʉ yigʉja mʉ. Ito bajiro mʉ yi jeoja bero yʉ rãca waya, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jesús ito bajiro ĩ yija tʉocõri, bʉto bojori bʉja tʉdi waquĩ ĩ, ĩ ya gajeonire maigʉ̃. Bʉto gajeoni jaigʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ito yija bero gʉa ĩ rãca riasotirãre ado bajiro yiquĩ Jesús: —Riti mʉare ado bajiro gotia yʉ. Sĩgʉ̃ gajeoni jaigʉ Dios rotirojʉ ĩ eja ãmoja josari ña. ");
INSERT INTO myy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mʉcana mʉare goti quenoa yʉ. Sĩgʉ̃ camello gawa jota susurijʉ ĩ rẽta budi ãmoja, josari ña. Ito bajiroti bʉto bʉsa josari ña Dios ĩ rotirojʉ niyeru jaigʉ ĩ eja ãmoja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ito ĩ yija tʉocõri, bʉto ʉcacʉ gʉa. Ito yicõri gʉamasiti gãmeri seniĩacʉ gʉa: —¿Ito yija noajʉa Dios ĩ ñarojʉ ejagʉ yiguĩjida? Sĩgʉ̃ ejabiquĩji gajea, yi gãmeri bʉsicʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Gʉare ticõri ado bajiro yiquĩ Jesús: —Masamasiti yiado ma itire. Dios sĩgʉ̃ti jeyaro yi masiguĩji. Ñejʉa josarise manoja ĩre, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ito ĩ yija tʉocõri, Pedro ado bajiro yiquĩ: —Yʉ Ʉjʉ jeyaro gʉa rʉcorisere jidicãcʉ gʉa. Iti jeyaro jidicãcõri mʉ rãca sʉya gʉa. ¿Ito gʉa yijama ñe bʉjarã yirãjida gʉa? yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ito ĩ yija tʉocõri, ado bajiro gotiquĩ Jesús ĩnare: —Riti mʉare gotia yʉ. Co rʉmʉ mʉcana mame menigʉ̃ yiguĩji Dios. Ito bajiro ĩ yiri rʉmʉ yʉ Masa Rĩjorʉ rotirojʉ yori cumurojʉ rujigʉ yigʉja yʉ. Mʉa cʉni yʉre sʉyarã, jʉa gʉbojeno ñari cumurori rotirojʉ rujirã yirãji mʉa cʉni. Israel sita gãna jʉa gʉbojeno masa buturi gãnare rotirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Noa yʉre cʉdi ãmorã ĩna ya wiri, ĩna ñarã, ĩna jacʉsabatia, ĩna manojosãromia, ĩna rĩa, ito yicõri ĩna ya wesecare cʉni ĩna cũ waja, ĩna rʉcobojarise rẽto bʉsaro queno bʉjarã yirãji ĩna mʉcana. Ito yicõri catitĩñare bʉjarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jãjarã adojʉ ñasari masa ñarã, itojʉ ũmacʉ̃jʉ ñasarã meje ñarã yirãji. Ito bajicõri adojʉ ñasamena ñarã, itojʉ ũmacʉ̃jʉ ñasarã ñarã yirãji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, gʉa yi masitoni ado bajiro goti masioquĩ Jesús gʉare: —Sĩgʉ̃ ʉyé wese co wese rʉcogʉ ñayijʉ. Busuri jĩjʉ ĩre moa ĩsironare ãmagʉ̃ wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ĩnare bʉjacõri ĩnare bʉsi quenoyijʉ ĩ. “Co rʉmʉ ʉ̃mʉasaro yʉre mʉa moa ĩsija, coji denario niyeru cuji mʉare waja yicʉja yʉ”, yiyijʉ ĩ ĩnare. Ĩna cʉdija tʉocõri, “Yʉ ya sita moa ĩsitẽña yʉre”, yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ito bero yoa bʉsari nueve tʉjaroca, gãjerã moa ãmorã cʉto gʉdareco ĩna rʉ̃gõja ti bʉjayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Wasa, mʉa cʉni. Yʉ ya ote wese moa ĩsitẽña. Yiro robo queno mʉare waja yigʉ yigʉja yʉ”, yiyijʉ ĩ ĩnare. Ito bajiri ĩna cʉni ĩre moa ĩsirã wayijarã. ");
INSERT INTO myy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mʉcana ito bajiroti ʉ̃mʉa gʉdareco ñaroca, tres ñaroca cʉni moari masa bʉjayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mʉcana cinco ñaroca cʉto gʉdareco ejacõri gãjerã moa ãmorã ĩna rʉ̃gõja ti bʉjayijʉ ĩ. Ito yicõri ĩnare ado bajiro yiyijʉ ĩ: “¿No yija adi rʉmʉ moamenati ʉ̃mʉasaro rʉ̃gõ ucuati mʉa?” yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ñimʉjʉa gʉare, ‘Moa ĩsiña mʉa’, yibeama. Ito bajiri ñacõa gʉa”, yiyijarã ĩna ĩre. “Wasa mʉa cʉni. Yʉ ya ote wese moa ĩsitẽña. Yiro robo queno mʉare waja yigʉ yigʉja yʉ”, yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Rãiocũro ñaroca ĩ ya moari masare coderi masʉre ji ñucayijʉ ĩ, ĩ ya moari masare ĩ waja yitoni. “Bero moare sãjacãnajʉare waja yisʉoya. Ito yicõri moare sãjasʉocãnajʉare waja yi gajanoaña”, yiyijʉ ĩ, ĩ ya moari masare coderi masʉre. ");
INSERT INTO myy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ito yija bero moare sãjasʉsana ejasʉoyijarã. Ito bajiri ĩna jeyarore coji denario niyeru cuji ĩnare waja yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Itocõacã ĩna bʉjaja ticõri, cajero moare sãjasʉoana: “Maniama jai bʉsaro bʉjarã yirãji”, yi tʉoĩabojayijarã ĩna. Ito bajiro ĩna tʉoĩare ñabojarocati. Co cujiti niyeru cuji boca ãmiyijarã ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ito bajiri itocõacã bʉjacõri ʉjʉre tudisʉoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Gʉa berojʉ moasʉorã coji cõreti moama ĩna. Ito bajibojarocati ĩnare mʉ waja yirocõacãti gʉare waja yia mʉ. Gʉama ũmacañi asiro bʉjaĩabojabʉ gʉa”, yi tudiyijarã ĩna ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ito bajiro ĩna yibojarocati sĩgʉ̃re ado bajiro cʉdiyijʉ ʉjʉ: “Yʉ baba mʉre rinibea yʉ. ‘Yicʉja’, yʉ yiado bajiroti ya yʉ. Jĩjʉ oca quenocãmʉ mani. ‘Co rʉmʉ moare waja co cuji niyeru cuji waja cʉtia’, yiari mʉre bʉsicãmʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mʉ moare waja ãmicõri wasa. Mʉre yʉ waja yiro bajiroti bero moasʉsagʉre cʉni itocõti ĩsi ãmoa yʉ. ");
INSERT INTO myy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yʉ ya niyeru ña. Ito bajiri yʉ ãmoro bajiroti ya yʉ itire. ¿Ĩnare queno yʉ waja yija, itire ti junisiniati mʉ?” yiyijʉ ĩ cajero moare sãjasʉorʉre, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Gaje ado bajiro yiquĩ Jesús gʉare: —Ito bajiroti adojʉ jãjarã ñasarã ñarã, itojʉ ũmacʉ̃jʉ Dios ĩ ñarojʉ ñasamena ñarã yirãji ĩna. Gãjerã adojʉ ñasamena ñarã, itojʉ Dios ĩ ñarojʉ ñasarã ñarã yirãji. Masa jeyarore jibojagʉti coriarãreti bese ãmigʉ̃ yiguĩji Dios, yisʉsaquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalénjʉ gʉa wasʉoroca, gʉa jʉa gʉbojeno ñarãre bʉsirocʉ ricati ji ñucaquĩ Jesús: ");
INSERT INTO myy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jerusalénjʉ ejarã warã, mʉja wasʉoa mani. Jerusalénjʉ mani ejaroca Masa Rĩjorʉre ñiarã yirãji masa. Ito yicõri paia ʉjarãre, judio masa rotirise riasori masare cʉni ĩre ĩsirã yirãji ĩna. Ĩnajʉ ĩre sĩa rotirã yirãji. Ĩti ña yʉ Masa Rĩjorʉ. ");
INSERT INTO myy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ito yicõri gaje masa yʉre ĩna aja tuditoni, yʉre ĩna bajetoni, ito yicõri yucʉtẽojʉ yʉre ĩna jaju sĩatoni ĩnare yʉre ĩsirã yirãji ĩna. Yʉre sĩacõri godana wato yʉre yujebojarã yirãji ĩna. Ito ĩna yibojarocati ʉdia rʉmʉ bero yʉ catiroca yigʉ yiguĩji Dios yʉre, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ito yija bero Zebedeo rĩa jaco ejacõ Jesús rãca bʉsiroco. Iso rĩa Santiago, Juan rãca ejacõ. “Yʉre queno yiya mʉ”, yiroco Jesús riojo rijomunigãna ñini rũjũcõ iso. ");
INSERT INTO myy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ito bajiro iso yija ticõri: —¿No bajiro yʉ yire ãmoati mʉ? yiquĩ Jesús isore. Ito ĩ yijare ado bajiro cʉdicõ iso: —Mʉ rotirojʉ mʉ ejaja, yʉ rĩare sĩgʉ̃ mʉ ya riojocadʉja, gãjire mʉ ya gãcodʉja rojoba ĩnare, yicõ iso Jesure. ");
INSERT INTO myy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ito bajiri iso rĩare ado bajiro yiquĩ Jesús: —Mʉa yʉre senibojarisere queno tʉo masibea mʉa. Quenabeto yʉ tʉoĩaroca yirã yirãji masa yʉre. ¿Yʉre bajiroti quenabeto tʉoĩa ñemecʉti masirã yirãjida mʉa cʉni? yiquĩ Jesús ĩnare. —Ñemecʉticõrãji gʉa, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ĩna ito yija tʉocõri, ado bajiro cʉdiquĩ Jesús: —Riti mʉare gotia yʉ. Mʉa cʉni yʉre bajiroti tõbʉjarã yirãji. Ito bajibojarocati yʉ ya riojocadʉja, yʉ ya gãcodʉja mʉare rojo masibea yʉ. “Ãna yʉ Macʉ tʉ rujirã yirãji”, yʉ Jacʉ ĩ yicãdo bajiroti, ĩnare rojogʉ yiguĩji, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Gʉa Jesús rãca riasotirã jʉa dʉjamocõ ñarã, “Ito bajiro ãmoa gʉa”, ĩna yija tʉocõri, tʉo junisinicʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ito bajiro gʉa bajija ti masicõri, ado bajiro yiquĩ Jesús gʉare: —Sita ʉjarã ñasari masa ĩna roca gãnare rotirã yirãji. Ito yicõri mʉcana ĩnare moa ĩsiri masa, ĩna roca gãnare bʉto bʉsa sẽoro rotirã yirãji ĩna. “Ito bajiro yicã masa”, yi tʉo masia mʉa. ");
INSERT INTO myy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉama ito bajiro bajimena yirãji. Gajero bajirojʉa bajia. No ñasagʉ ña ãmogʉ̃, gãjerãre ejabʉagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ito yicõri cajero gagʉ ñasʉo ãmogʉ̃, gãjerãre moa ĩsigʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yʉ cʉni ito bajiroti ya. Gãjerã yʉre moa ĩsijaro yigʉ meje wadicʉ yʉ. Ĩnajʉare ejabʉagʉ wadicʉ yʉ. Jãjarãre masorocʉ wadicʉ yʉ. Ĩna ñeñaro yirisere waja yi ĩsirocʉ goda ĩsigʉ̃ wadicʉ yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó wame cʉtiri cʉto gʉa budi waroca, jãjarã masa sʉyacã, Jesure ti ãmorã. ");
INSERT INTO myy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Itojʉ gʉa waroca jʉ̃arã cajea timena rujicã ma tʉjʉ. Jesús ĩ rẽtaja tʉocõri, ado bajiro ĩre ji awasãcã ĩna: —Gʉa ʉjʉ, David ñayorʉ janerãbatia janamiti ña mʉ. Gʉare ti maiña mʉ, yi awasãcã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ito bajiro ĩna yibojarocati, “Awasãbesa maji”, yicã masa. Ito bajiro ĩna yibojaroca riti, bʉto bʉsa awasãcã ĩna mʉcana: —Gʉa ʉjʉ, David ñayorʉ janerãbatia janami ña mʉ. Gʉare ti maiña, yi awasãcã ĩna bʉto bʉsa. ");
INSERT INTO myy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ito ĩna yija tʉocõri, tuja rʉ̃gʉ̃quĩ Jesús. Ito yicõri cajea manare ji ñucaquĩ ĩ: —¿No bajiro yʉ yire ãmoati mʉa? yiquĩ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Gʉa Ʉjʉ, cajea ti ãmoa gʉa, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ito ĩna yija tʉocõri, ĩnare ti maiquĩ Jesús. Ito yicõri ĩna ya cajeari moaĩaquĩ ĩ. Ito bajiro ĩ yirocati timena ñabojana ticoacã ĩna ĩja. Ito ĩ yija bero ĩna cʉni Jesure sʉyacã. ");
INSERT INTO myy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén cõña warã Betfagé wame cʉtiri cʉto ejacʉ gʉa. Jabeto cõñasʉocʉ Jerusalén ĩja. Olivos wame cʉtiri tʉria jʉdo ñacʉ iti cʉto. Jʉ̃arã gʉa rãca gãnare ĩ rãca riasotirãre, ");
INSERT INTO myy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ado bajiro rotiquĩ Jesús: —Mani waroto riojo ñari cʉtore wasa maji. Itojʉ ejacõri burro sia rʉ̃gõrʉre bʉjarã yirãji mʉa. Ito yicõri ĩ macʉ cʉni ñagʉ̃ yiguĩji ĩ rãca. Ĩnare õjacõri ãmi wadi ĩsima yʉre. ");
INSERT INTO myy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sĩgʉ̃ mʉare ĩ bʉsija. “Mani Ʉjʉ ĩnare ãmoami”, yiba. “Yoari mejeti mʉcana mʉre jʉdacõarã yirãji gʉa”, yiba. Ito bajiro mʉa yija tʉocõri, “Baʉ wasa”, yigʉ yiguĩji mʉare, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ito bajiro yiquĩ Jesús, sĩgʉ̃ Diore goti ĩsiri masʉ ĩ ucado bajiroti yigʉ. Ado bajiro ucayoñi Diore goti ĩsiri masʉ: ");
INSERT INTO myy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén gãnare ado bajiro yiba: “Tiya mʉa. Mʉa Ʉjʉ wadiami. ‘Ñasagʉ ña yʉ’, yirocʉ meje ejami ĩ. Burro gajeoni ũmari masʉ macʉ ĩ joe jesacõri wadiami ĩ”, yiba, yi ucañi Diore goti ĩsiri masʉ ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesús ĩ rotija tʉocõri, ĩ rotiro bajiroti yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burro ĩ macʉ rãcati ãmi wadiñi ĩna. Ĩna ya yutabujurire ruacõri burro joere jeocã ĩna. Ito ĩna yija bero mʉja jeaquĩ Jesús ĩja. ");
INSERT INTO myy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ito iti bajiroca masa jãjarã ñacã. Ĩna ya yutabujuri ruacõri mare eyocũ yucã ĩna. “Gʉa Ʉjʉ ña mʉ”, yirona ito bajiro yiyijarã masa Jesure rʉ̃cʉbʉorã. Gãjerã yucʉgʉri jatacõri mare cũ yucã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ĩ riojʉa gãna, ĩ berojʉa gãna cʉni ĩre wanʉrã ado bajiro awasã wacã ĩna: —Mʉ ña David ñayorʉ janerãbatia janami. Mʉ ña gʉa Ʉjʉ. Rẽtoro masigʉ̃ ña mʉ. Dios ĩ cõarʉ ña mʉ. Queno yijaro Dios mʉre. Quenasacõa Dios ĩ ito bajiro ĩ cõaja, yi awasã wacã masa. ");
INSERT INTO myy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ito bajiro Jesús masa rãca ĩ ejaja, tʉo batocõri tʉoĩa oca jaicã masa. Jãjarã ĩnamasi gãmeri seniĩacã ĩna: —¿Ñimʉõcʉ̃ ñati ãni? yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Gãjerã ado bajiro yicã: —Ĩti ñami Jesús Diore goti ĩsiri masʉ. Galilea sita Nazaret wame cʉtiri cʉto gagʉ ñami ĩ, yicã masa. ");
INSERT INTO myy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ito ĩ yija bero Dios ya wi minijuara wijʉ sãja wacʉ gʉa Jesús rãca. Iti wijʉ waja gãme ñari masare ticõri ĩnare bucõaquĩ Jesús. Masare ĩna niyeru wasoa ñari casabore tujʉda queoquĩ Jesús. Ito yicõri bujare ĩna ĩsi rujiri cumurori tujʉda cõaquĩ. ");
INSERT INTO myy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ado bajiro gotia Dios oca tuti yiquĩ Jesús: —Yʉ ya wiama yʉre rʉ̃cʉbʉorona ĩna minijuara wi ñaro yiroja. Ito bajibojarocati mʉama riniri masa ĩna rudiri wi robo bajiro meniyija mʉama, yi gotia Dios oca tuti, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iti wijʉ minijuara wijʉ gʉa ñaroca, cajea mana ito yicõri wa masimena ejacã Jesús tʉ. Ĩna ejaja ticõri, ĩnare yisioquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ito bajiro Jesús tiyamani ĩ ĩoja ticõri, paia ʉjarã ito yicõri judio masa rotirise riasori masa cʉni Jesure tʉo junisinicã ĩna. “Rẽtoro masigʉ̃ ña mʉ. David ʉjʉ ñayorʉ janerãbatia janamiti ña mʉ”, minijuara wijʉ rĩaca ĩna awasãja tʉocõri, Jesure tʉo junisinicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ito bajiri Jesure ado bajiro yicã ĩna: —¿Ito bajiro ĩna bʉsija tʉocʉati mʉ? yicã ĩna Jesure. —Tʉoa yʉ ĩnare. Dios oca tutijʉ ito bajiro iti gotija. ¿Tiĩabeati mʉa? Ado bajiro gotia iti: Rĩaca ito yicõri ũjurãcã cʉni mʉre ĩna wanʉ rʉ̃cʉbʉoroca ya mʉ, yi gotia Dios oca, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ito yija bero ĩnare wagocʉ gʉa. Ĩnare wagocõri Betania wame cʉtiri cʉtojʉ ejacʉ gʉa. Itojʉ canicʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mʉcana busuri Jerusalénjʉ tʉdi wacʉ gʉa. Ma gʉdareco gʉa tʉjaroca, “Ñiocõa yʉ”, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma tʉ higuera wame cʉtiricʉ ñacʉ. Itigʉ ricare ba ãmogʉ̃ ojabojaquĩ Jesús. Rica manicʉ itigʉjʉama. Jũgoti ñacʉ. Ito bajiri itigʉre ado bajiro yiquĩ Jesús: —Jʉaji rica cʉtibitiatoja mʉgo, yiquĩ Jesús itigʉre. Ito bajiro ĩ yirocati sinia godacoacʉ itigʉ. ");
INSERT INTO myy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ito bajiro iti rẽtaja ticõri, ʉcacʉ gʉa Jesús rãca riasotirã: —¿No bajijare yoari mejeti sinia godati itigʉ? yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ado bajiro gʉare cʉdiquĩ ĩ: —Riti mʉare gotia yʉ. Yʉre tʉorʉ̃nʉcõri, “Yʉre ejabʉabiquĩji Jesús”, mʉa yi tʉoĩabeja, janeti higueragʉre yʉ yiro bajiro meje riti yi masirãji mʉa. Gaje sẽo bʉsarise yi masirãji mʉa. I tʉriare, “Cʉní rʉ̃gõcõri riaca jajosajʉ quedi roaya”, mʉa yija, ito bajiroti rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Diore bʉsirã mʉa senija, ĩre mʉa tʉorʉ̃nʉjama mʉa seniro bajiroti bajiro yiroja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ito rẽta wacõri Jerusalénjʉ ejacʉ gʉa mʉcana. Ito yicõri minijuara wijʉ sãjacʉ gʉa Jesús rãca. Ito gʉa ñaroca riti paia ʉjarã, ito yicõri judio masa bʉcʉrã ejacã Jesure seniĩarona: —¿Ñimʉ ĩ rotijare ito bajiro yati mʉ? ¿Ñimʉ mʉre, “Ito bajiro yiba”, yicati? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Ito bajiro ĩna yija tʉocõri: —Yʉ cʉni mʉare ado bajiro seniĩagʉ̃ ya. Yʉre mʉa cʉdija berojʉa, “Ĩ rotirena ya yʉ”, mʉare yicʉja maji. ¿Ñimʉ cõayijari Juanre masare ĩ idé gutoni? ¿Dios cõayijarite? ¿Masajʉa cõayijarite? yi seniĩaquĩ Jesús ĩnare. Ito ĩ yija tʉocõri, ĩnamasiti gãmeri tʉoĩa bʉsicã ĩna: “ ‘Dioti Juanre idé gu rotiñi’, mani yija, mʉcana manire seniĩagʉ̃ yiguĩji Jesús: ‘¿No yija ĩre tʉorʉ̃nʉbiticati mʉa?’ yi seniĩagʉ̃ yiguĩji Jesús manire. ");
INSERT INTO myy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘Masati Juanre idé gu rotiñi’, mani yijama, masa bʉto ti tudirã yirãji manire. ‘Diore goti ĩsiri masʉ ñami Juan’, yi tʉoĩarãji masa”, yi gãmeri tʉoĩa bʉsicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ito bajiro tʉoĩacõri: —“Ĩti Juanre idé gu rotiñi”, yi masibea gʉa, yicã ĩna Jesure. Ito ĩna yija tʉocõri, ado bajiro cʉdiquĩ Jesús ĩnare: —Ito bajijama ĩ rotirenati adi jeyaro tiyamani ya yʉ, yi masibea yʉ cʉni mʉare, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mʉcana judio masa bʉcʉrãre ado bajiro seniĩaquĩ Jesús: —Mʉare oca gotigʉ ya yʉ. ¿Itire no bajiro tʉoĩarã yirãjida mʉa? Sĩgʉ̃ ñayijʉ jʉ̃arã rĩa cʉtigʉ. Ĩ macʉ ñasʉogʉre ado bajiro yiyijʉ ĩ: “Macʉ jane yʉ ya ote ʉyére moagʉ̃ wacʉ ya mʉ”, yiyijʉ ĩ, ĩ macʉre. ");
INSERT INTO myy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ãmobea yʉ, wabicʉja yʉ”, yiyijʉ ĩ ĩre. Ito bero gaje tʉoĩa quenocõri moagʉ̃ wayijʉ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ito yija ĩ macʉ gãjire cʉni ito bajiroti moa rotiyijʉ. “Baʉ, moagʉ̃ wacʉja cʉna yʉ”, yiyijʉ ĩ ĩja ĩ jacʉre. Ito yibojagʉti moagʉ̃ wabisijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mʉa tʉoĩaja, ¿ñimʉjʉa ñayijari ĩ jacʉ ãmoro bajiro yigʉ? yi seniĩaquĩ Jesús ĩnare. Ito ĩ yija tʉocõri: —Cajero ĩ moa rotisʉorʉ quenañi, yicã ĩna Jesure. Ito ĩna yija tʉocõri, ado bajiro yiquĩ Jesús: —Riti mʉare gotia yʉ. Ʉjarãre yiari waja seni ĩsiri masa ito yicõri wedi masa romia mʉa riojʉajʉ Dios ĩ rotirojʉ ejarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan idé guri masʉ, “Ado bajirojʉa mʉa ñaja quena”, yi mʉare ĩ riasobojaja, ĩre tʉorʉ̃nʉbisija mʉa. Ito bajibojarocati ʉjarãre yiari waja seni ĩsiri masa, ito yicõri wedi masa romia cʉni ĩre tʉorʉ̃nʉñi ĩna. Ĩna ito bajiro Juan idé guri masʉre ĩna tʉorʉ̃nʉja, tibojarãti mʉa ñeñaro yirise jidicã ãmobisija mʉa. Ito yicõri Juan idé guri masʉre tʉorʉ̃nʉbisija mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Gaje goti masiore ocana mʉare gotigʉ ya yʉ: Sĩgʉ̃ weseca cʉtigʉ ĩ ya wesejʉ ʉyé oteyijʉ. Iti wesere ote tĩocõri iti wesere camotayijʉ ĩ. Ito yicõri ʉyé ide bijerotijʉ cojʉ meniyijʉ ĩ. Iti wese ñacõri tirʉ̃nʉrocʉ ũmacʉ̃jʉ casabo meniyijʉ ĩ. Ito yija bero co rʉmʉ gãjerãre tirʉ̃nʉ wasoa rotiyijʉ. Ito yicõri gajerojʉ wacoayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ito bajiri co rʉmʉ ʉyé iti rica cʉtiroca, “Yʉ ye ñaroti jabeto ʉyé ãmitẽña”, yirocʉ ĩ ya moari masare cõayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Iti wesejʉ ĩna ejaja ticõri, ito coderi masa ĩnare ñiayijarã. Sĩgʉ̃re jayijarã, ito yicõri gãjire sĩayijarã, ito yicõri gãjire gʉ̃tana reayijarã. ");
INSERT INTO myy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Iti oca tʉocõri jãjarã bʉsa ĩ ya moari masa cõayijʉ ĩ, ĩ ya wesecajʉ ĩ ye ñaroti ĩna ãmitoni. Iti wesejʉ ĩna ejaroca, iti wese code ñana ito riojʉa ejanare ĩna yiado bajiroti yiyijarã mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ito bajiro ĩna yija tʉocõri, “Yʉ macʉjʉare rʉ̃cʉbʉorãji”, yi tʉoĩacõri ĩ macʉre wa rotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ĩ macʉ ejaja ticõri, ado bajiro tʉoĩa bʉsiyijarã ĩna: “Adi sita ʉjʉ godagoja ãni macʉti ñami wasoarocʉ, ito bajiri ĩre mani sĩaja, mani ya sita ñaro yiroja ĩja”, yi gãmeri tʉoĩa bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ĩna tʉoĩado bajiroti ĩre sõjʉ ñia ãmi wacõri sĩayijarã ĩna, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ito bero mʉcana ado bajiro ĩnare seniĩaquĩ Jesús: —¿Ĩ tʉdi ejaja no bajiro yigʉ yiguĩjida ĩnare, iti wese codeanare? yi seniĩaquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ito ĩ yija tʉocõri, ado bajiro cʉdicã ĩna Jesure: —Ĩnare ti maiari meje ĩnare sĩagʉ̃ yiguĩji ĩ iti sita ʉjʉ. Ito ĩ yija bero gãjerãre tirʉ̃nʉ wasoa rotigʉ yiguĩji ĩ. Ʉyé iti bʉcʉaroca iti wese ʉjʉre ĩsironare ĩnare wasoagʉ yiguĩji ĩ, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesujʉa ado bajiro yiquĩ ĩnare: —¿Dios oca tuti tiĩabeati mʉa? Ado bajiro gotia iti tuti: Gʉ̃ta wi meniri masa coga gʉ̃tagãre cõayijarã ĩna. Ito bajibojarocati gaje gʉ̃ta rẽtoro quenarica ñayijʉ itiga ĩna cõabojaraga. Itiga gʉ̃tagãna sʉoriti quenari wi menigʉ̃ yiguĩji Dios. Itiga gʉ̃tagã manija, menire ma. Ito bajiro ãmoñi Dios mani Ʉjʉ. Ito bajiri itire masicõri bʉto tʉoĩa wanʉa mani, yi gotia Dios oca. Ito bajiro yiñi Dios, yʉre rẽtaroti tʉoĩa yugʉ. ");
INSERT INTO myy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ito bajiri mʉare ado bajiro gotia yʉ: “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, mʉare gãjerã gotibojarocati tʉorʉ̃nʉbisija mʉa. Ito mʉa yija ticõri, gãjerã masa ĩ oca ĩna masiroca yiñi Dios. Ito bajiri ĩre ĩna queno cʉdija ticõri, ĩnareama miojugʉ yiguĩji Dios, ĩ rotirojʉ. Mʉa judio masare ĩ rotirojʉ mʉare cũ yubojañi Dios. Mʉare yubojacõri gãjerãre cũgʉ̃ yiguĩji Dios ĩ rotirojʉ. Ĩ ya weseca ejabʉa ãmorãre bajiro bajirã cũgʉ̃ yiguĩji Dios ĩ rotirojʉ. ");
INSERT INTO myy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jĩjʉ gʉ̃ta gaye mʉare yʉ bʉsirise ado bajiro bajia: No gʉ̃tagã joe quedi jeagʉre ĩ ya gõari jearo yiroja ĩre. Ito yicõri itiga gʉ̃tagã sĩgʉ̃re iti quedi jeaja, mano abocõro yiroja. No yʉre tʉorʉ̃nʉbicʉ, catitĩñabicʉ yiguĩji. Ito yicõri noa jeame ʉ̃jʉrojʉ cõa ãmorãre yʉ cõaja, ruyuriorocʉ cõagʉ̃ yigʉja yʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Goti masiore oca Jesús ĩnare gotija tʉocõri, “Manireti bʉsiami”, yire masiri seyocã fariseo gaye tʉoĩarã, paia ʉjarã cʉni. ");
INSERT INTO myy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ito bajiri Jesure ñia ãmori seyobojacã ĩna. Ito bajiro tʉoĩabojarãti masare güirã Jesure ñiabiticã ĩna. “Diore goti ĩsiri masʉ ñami Jesús”, masa ĩna yi tʉoĩajare, masare tʉo güicã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mʉcana masare goti masiore ocana gotisʉoquĩ Jesús: ");
INSERT INTO myy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—“Ado bajiro bajia, ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ Dios ĩ miojuri rʉmʉ”, yirocʉ ado bajiro gotiquĩ Jesús: Sĩgʉ̃ ʉjʉ ĩ macʉ ãmo siare basa meniyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“Ti ejabʉaronare jitẽña”, yirocʉ ĩ ya moari masare cõayijʉ ʉjʉ. Ito ĩ yija tʉocõri, jirã wabojayijarã ĩna. Ĩna jibojarocati wadi ãmobisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ito bajija ticõri, gãjerã ĩ ya moari masare cõayijʉ ʉjʉ. “Gʉa ʉjʉ mʉare bocatimi. Ĩ ya wecʉa ri cʉtirãre sĩa rotimi ĩ. Mʉare bocati ñami ĩ. Ito bajiri ĩ macʉ ãmo siari rʉmʉ tirã waya mʉa cʉni, yiba ĩnare”, yi oca cõayijʉ ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ito yija tʉocõri, jirã wabojayijarã ĩna mʉcana. Ito bajibojarocati ĩre cʉdi ãmobisijarã ĩ oca cõana. Ito bajiri ĩna gotibojaroca riti, gãjiama ĩ ya wesecajʉ wayijʉ. Gãji ĩ gajeoni ĩ ĩsirojʉ wayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Gãjerãma ʉjʉ ĩ cõanare boca ñiayijarã. Ito yicõri ĩnare jayijarã. Ito yirã riti ĩnare sĩacõyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Itire tʉocõri bʉto junisiniyijʉ ʉjʉ. Ito bajiri ĩ ya surarare ĩnare sĩa rotiyijʉ, ito yicõri ĩna ya wirire soe rotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ito yija bero gãjerã ĩre moa ĩsiri masare ado bajiro yiyijʉ ĩ: “Yʉ macʉ ĩ ãmo siaroti gaye ñajediro ñacã. Jĩjʉ yʉ oca cõabojanama wadire ma ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cʉto gʉdareco wasa. Itojʉ mari mʉa ti bʉjaro bajiroti baba cʉtiba”, yiyijʉ ʉjʉ ĩre moa ĩsiri masare. ");
INSERT INTO myy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ĩ rotiro bajiroti masa miojuyijarã ĩna marijʉ. Quenarã, ñeñarã, ĩna bʉjaro bajiroti miojuyijarã ĩna. Ito bajiri ʉjʉ ya wi dajacoayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ito yija ĩ oca cõanare tigʉ sãjayijʉ ʉjʉ. Sĩgʉ̃ ĩ ãmo siara rʉmʉ sãñare gaye yutabuju ĩ sãñabeja tiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ito bajiri ado bajiro yiyijʉ ĩ ĩre: “Yʉ baba, ¿no yija ãmo siare gaye yutabuju sãñabeati mʉ?” yiyijʉ ĩ ĩre. Ito ĩ yija cʉdibisijʉ yutabuju sãñabicʉ. ");
INSERT INTO myy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ito yija bare jeori masare ado bajiro yiyijʉ ʉjʉ. “Ĩ ya gʉbori, ĩ ya ãmori rãca siaya ãnire. Ito yicõri rãitĩarojʉ cõaña ĩre. Itojʉ ejacõri ñeñaro tõbʉjagʉ yiguĩji. Ito bajiri oticõri bʉto tʉoĩa oca jaigʉ yiguĩji ĩ”, yiyijʉ ʉjʉ ĩ ya bare jeori masare. Ito bajiroti bajiroja ũmacʉ̃jʉ Dios ĩ rotirojʉ cʉni. ");
INSERT INTO myy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jãjarãre jibojami Dios, ĩ ñarojʉ ĩna ejatoni. Ito bajibojarocati coriarãti ĩ beseana goti ejarã yirãji ĩ ñarojʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ito ĩ yija tʉocõri, fariseo gaye tʉoĩarã wacoacã. Sĩgʉ̃re bajiro tʉoĩacõri, “Josari oca ĩre mani seniĩaja, cʉdi masibicʉ yiguĩji ĩ. Ito bajiro ĩ cʉdi masibeja tʉocõri, ‘Ĩre seti ña’, yirã yirãji mani”, yi tʉoĩari seyobojacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ito bajiro tʉoĩacõri ĩna ñarãre ito yicõri Herodes ñarã rãca, “Ado bajiro Jesure seniĩatẽña mʉa”, yi ñucayijarã ĩna. Ĩna cõana Jesús tʉ ejacõri ado bajiro seniĩacã ĩna Jesure: —Tʉoya riasori masʉ mʉ. “Riojo gotigʉ ña mʉ”, yi masia gʉa. “Ado bajiro ãmoami Dios”, yi riasogʉ ñaro bajiroti masare riasoa mʉ. Masa bʉsirise tʉorʉ̃nʉbicʉti quenarise riasogʉ ña mʉ. Gãjerã ñasari masa gajero bajiro ĩna riasobojarocati, ĩnare tʉorʉ̃nʉbicʉti, ñasarise riasoa mʉ. ");
INSERT INTO myy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ito bajiro mʉ yija, no bajiro mʉ tʉoĩare gaye tʉo ãmoa gʉa. ¿Roma cʉto gagʉ ʉjʉ gʉare ĩ waja senija, waja yirãjida gʉa, waja yibeatite gajerea? yi seniĩabojacã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","“Yʉ wisatoni ito bajiro yʉre seniĩama ĩna”, yi masiri seyoquĩ Jesús. Ito bajiri ado bajiro yiquĩ ĩ ĩnare: —“Queno yirã ña gʉama”, yirã ñabojarãti queno yirã meje ña mʉa. ¿No yija yʉ tʉo wisatoni ito bajiro seniĩati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","“Sita waja, waja yiroti cuji niyeru cuji yʉre ĩoña”, yiquĩ Jesús ĩnare. Ito yija niyeru cuji ĩre ĩocã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iti cuji niyeru cuji ticõri, ado bajiro ĩnare seniĩaquĩ Jesús: —¿Ñimʉ ya rio ñati adi rio? ¿Ñimʉ wame, wame cʉtiati iti? yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Gobierno masa ʉjʉ César wame cʉtigʉ ya rio ña. Ito yicõri ĩ wameti ña iti, yicã ĩna Jesure. —Gobierno masare mani waja ruyurioja ñaro bajiroti waja yija quena. Ito bajiroti manire Dios ĩ rotija ñaro bajiroti ĩre cʉdija quena, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ĩ queno cʉdi masija tʉocõri, rujʉ ʉcacã ĩna. Ito bajiri mʉcana tʉdi seniĩa ʉyabiticã ĩna ĩja. Seniĩamenati wacoacã ĩja. ");
INSERT INTO myy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iti rʉmʉti saduceo gaye tʉoĩarã Jesure tirã ejacã. “Masa ĩna godaja bero mʉcana tʉdi catire ma”, yirã ñama saduceo gaye tʉoĩarã. Ito bajiro tʉoĩarã ñari, Jesure seniĩarã ejacã ĩna: ");
INSERT INTO myy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Tʉoya riasori masʉ mʉ. Moisés ñayorʉ ĩ yire gaye mʉre seniĩarã wadibʉ gʉa. Ado bajiro yiñi Moisés ñayorʉ: “Sĩgʉ̃ manojo cʉtigʉ rĩa macʉti ĩ godagoja, ĩ bero gagʉ ĩ rĩjorʉ manojo godore manojo cʉtija quena. Ito bajiri iso rãca ñacõri, rĩjorʉ ñajacʉre wasoagʉ rĩa cʉti wasoagʉ yiguĩji ĩ”, yi ucañi Moisés ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Gʉa wato sĩgʉ̃ rĩa jʉa ãmojeno ñabojañi. Sĩgõreti manojo cʉtibojañi ĩna. Ñasʉogʉ isore manojo cʉtisʉobojañi. Rĩa macʉti godañi ĩ. Ĩ godaja bero gãji ĩ ocabaji wasoabojañi. Rĩa macʉti godañi ĩ cʉni. ");
INSERT INTO myy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ĩ bero gãna cʉni ito bajiroti manojo cʉtibojañi. Rĩa manati godañi ĩna cʉni. Ito bero sʉsagʉ cʉni ito bajiroti bajiyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iso manʉjʉsabatia ĩna goda jedija bero iso cʉni godacoañi ĩja. ");
INSERT INTO myy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Godabojarãti mʉcana tʉdi ĩna catija bero, ¿ñimʉjʉa ñaguĩjida iso manʉjʉ ñasarocʉ ĩna ñarocõti isore ĩna manojo cʉtija bero? yi seniĩacã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ito ĩna yija, ado bajiro cʉdiquĩ Jesús: —Dios oca tuti gaye queno tʉoĩa masimena ña mʉa. Dios ĩ masirise masirã meje ña mʉa. Ito bajiro yʉre mʉa seniĩabojaja, queno tʉoĩacõri meje seniĩa mʉa. ");
INSERT INTO myy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ado robojʉa bajia. Godana mʉcana tʉdi caticõri manojo cʉtire ma. Ito yicõri ĩna rĩa romiare manʉjʉ cʉti rotimenaji ĩna. Ũmacʉ̃jʉ ángel mesa robo bajiro bajirã ñarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Masa ĩna godaja bero mʉcana tʉdi catirã yirãjida ĩna mʉcana? yija, Dios oca tuti tiya. Dios oca tuti gaye ti jeorã meje ña mʉa. Ĩmasiti ado bajiro gotiami ĩ oca tutina: ");
INSERT INTO myy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abraham, Isaac, Jacob ñayoana Ʉjʉti ñasotia yʉ”, yi gotiami Dios ĩ ocana. Ito bajiri godana ʉjʉ meje ñami Dios, catirã Ʉjʉjʉa ñami, yi tʉoĩa mani, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ito bajiro Jesús ĩ riasore gaye ĩ gotija tʉocõri, ʉcacã masa. ");
INSERT INTO myy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ito bajiro saduceo gaye tʉoĩarã Jesús ĩ oca taja tʉoyijarã fariseo gaye tʉoĩarã. Ito bajiri iti tʉocõri minijuayijarã fariseo gaye tʉoĩarã. ");
INSERT INTO myy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sĩgʉ̃ ĩna wato judio masa rotirise riasori masʉ ñañi. “No bajiro Jesús yʉre ĩ cʉdija tʉocʉja”, yirocʉ ado bajiro Jesure seniĩagʉ̃ ejaquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Riasogʉ, ¿dise ñati Dios ĩ rotirise ñasarise mʉ tija? yi seniĩaquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ito ĩ yija tʉocõri, ado bajiro cʉdiquĩ Jesús: —Mani Ʉjʉ Diore bʉto maija quena. Mani tʉoĩarisena, ito yicõri mani ya ʉsina Diore mani maija quena. Ĩ sĩgʉ̃reti tʉorʉ̃nʉcõri, bʉto ĩre mani maija quena. ");
INSERT INTO myy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iti ña ñasarise Dios ĩ rotire. ");
INSERT INTO myy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iti bero rotire gaye itire bajiro bajiriseti ña. Ado bajiro bajia iti: “Mʉ ya rujʉre mʉ mairo bajiroti gãjerã mʉ ñarãre maija quena”, yi rotiami Dios. ");
INSERT INTO myy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iti jʉajiti ña Dios ĩ rotirise ñasarise. Iti jʉaji gaye Dios ĩ rotire gaye mʉa cʉdija, Moisés ñayorʉ ĩ rotire gaye, Diore goti ĩsiri masa ĩna riasorise gaye cʉni yiro bajiro cʉdirã ñarã yirãji mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo gaye tʉoĩarã gʉa tʉti ĩna minijuaroca maji, ");
INSERT INTO myy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ado bajiro seniĩaquĩ Jesús ĩnare: —¿Ñimʉ ñati Cristo, Dios ĩ cõarʉ mʉa tija? Ito yicõri, ¿ñimʉ janami ñati ĩ? yiquĩ Jesús ĩnare. —David ñayorʉ janerãbatia janamiti ñami ĩ, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ĩna ito yija tʉocõri, ado bajiro yiquĩ Jesús ĩnare: —Riti mʉa tʉoĩaja, ¿no yija David ñayorʉ ĩre tʉoĩagʉ̃, “Yʉ Ʉjʉ”, yiyijari? Tite mʉa. Ado bajiro ucañi David ñayorʉ. Espíritu Santo ĩ rãca ĩ ñajare ado bajiro ucañi ĩ: ");
INSERT INTO myy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yʉ Ʉjʉre ado bajiro yiñi Dios: “Yʉ ya riojocadʉja rujiya, mʉ wajanare mʉ rotiroca yigʉ yigʉja yʉ”, yiñi Dios yʉ Ʉjʉre, yi ucayoñi David. ");
INSERT INTO myy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David ñayorʉ janerãbatia janami ĩ ñaja, “Yʉ Ʉjʉ”, yibitiborʉ David ñayorʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ito bajiro ĩ gotija tʉocõri, sĩgʉ̃jʉa cʉdi masibiticã Jesús ĩ gotirisere. “Masi yucãguĩji ĩ”, yi tʉoĩacõri itocõti ĩre seniĩa jidicãcã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ito yija bero ado bajiro yiquĩ Jesús masare, gʉa ĩ rãca riasotirãre cʉni: ");
INSERT INTO myy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—“Moisés ñayorʉ ĩ rotire gaye tʉo masirã ñama fariseo gaye tʉoĩarã, judio masa rotirise riasori masa cʉni”, yama masa. ");
INSERT INTO myy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ito bajiri ĩna rotiro bajiroti cʉdiba. Jeyaro ĩna rotiro bajiroti cʉdiba. Ito bajibojarocati ñeñaro ĩna yirisere yibeja itireama. “Ado bajiro ya gʉa”, yibojarãti ricati yama ĩna. ");
INSERT INTO myy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Cʉdi masia mani”, masare rotiama ĩna. Ito bajibojarocati ito bajiro riti ĩnare roti ʉyama ĩna. “Ito bajiro yiya mʉa”, yibojarãti ĩnamasiti ito bajiro yibeama ĩna. ");
INSERT INTO myy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jeyaro ĩna yirise, “Queno yirã ñama ĩna”, masa ĩna yi tijaro yirona ito bajiro yibojama ĩna. Masa ĩna tiro riojo ĩna ya rioweca, ĩna ya ricajʉdori cʉni Dios oca jũ wõbojama ĩna, “Gãjerã gʉare ti seyojaro”, yirona ito bajiro yibojama ĩna. Ito yicõri yutabujuri yoarise gãjerã rẽto bʉsaro rore gaye sãñabojama ĩna. “Gãjerã gʉare ti seyojaro”, yirona ito bajirise sãñabojama ĩna. ");
INSERT INTO myy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ĩna ba ruji ãmoja, quenari cumuro ba ruji ãmoama ĩna. Minijuara wirijʉ ĩna ruji ãmoja, rʉ̃cʉbʉorajʉ riti ruji ãmoama ĩna. ");
INSERT INTO myy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Marijʉ masare ĩna bocaja, queno rʉ̃cʉbʉore rãca seniĩare ãmoama ĩna. Ito yicõri, “Yʉre riasogʉ”, masa ĩna yire ãmoama ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Mʉama ricati yija quena. “Yʉre riasogʉ”, masa ĩna mʉare yiroca yibeja. Mani jeyaro sĩgʉ̃ rĩare bajiro bajirã ña mani. Yʉ Cristo, Dios ĩ cõarʉ yʉ sĩgʉ̃ti ña mʉare riasori masʉ. ");
INSERT INTO myy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sĩgʉ̃ti ñami mani Jacʉ. Ĩti ñami Dios ũmacʉ̃jʉ gagʉ. Ito bajiri adi sita gãnare, gãjerã ʉ̃mʉare, “Cʉna”, yibeja mʉa. ");
INSERT INTO myy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Yʉ ʉjʉ”, yi rotibeja gãjerãre. Yʉ Cristo, Dios ĩ cõarʉ sĩgʉ̃ti ña mʉa Ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sĩgʉ̃ mʉa rãca gagʉ mʉare ĩ ejabʉaja, ĩ ñagʉ̃ yiguĩji ñasagʉ. ");
INSERT INTO myy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","No gãjerã riojʉa gagʉ ña ãmobojagʉti ñabicʉ yiguĩji ĩ. Ito bajiri berojʉa gagʉ tujagʉ yiguĩji ĩ. Sĩgʉ̃, “Gãjerã rẽtoro ñasagʉ ña yʉ”, yibicʉ ĩ ñagʉ̃ yiguĩji ñasagʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Fariseo gaye tʉoĩarãre, judio masa rotirise riasori masare cʉni bʉsigʉ ado bajiro bʉsiquĩ Jesús: —Bʉjato bʉjarã wãna ya mʉa. “Queno yirã ña gʉa”, yibojarãti mʉa yiro bajiro yirã meje ña mʉa. Dios ĩ rotirojʉ gãjerã ĩna sãjabititoni itire camota mʉa. Gãjerã ĩna sãja ãmobojarocati ĩnare camota mʉa. Ito bajiri mʉa cʉni sãjamena yirãji, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Bʉjato bʉjarã wãna ya mʉa fariseo gaye tʉoĩarã, judio masa rotirise riasori masa mʉa cʉni. “Queno yirã ña gʉa”, yibojarãti mʉa yiro robo yirã meje ña mʉa. Manʉjʉ godagoana romiare rʉocõri jairoguti ĩnare waja senia mʉa. Ito bajiro yicõri ĩna rʉcobojarisere ñarocõti ẽma jeoa mʉa. Queno yimena ñabojarãti masa mʉare tʉo wanʉtoni yoari ĩna tiro riojo Diore bʉsitobʉaboja mʉa. Ito bajiri bʉto bʉsa mʉare waja senigʉ̃ yiguĩji Dios. Ito bajiri gãjerã rẽtoro tõbʉjarã yirãji mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Bʉjato bʉjarã wãna ya mʉa fariseo gaye tʉoĩarã, judio masa rotirise riasori masa mʉa cʉni. “Queno yirã ña gʉa”, yibojarãti mʉa yiro robo yirã meje ña mʉa. “Mani robo gãji ĩ tʉoĩaja quena”, yi tʉoĩabojacõri jeyaro masare riaso ucua mʉa. Sĩgʉ̃ mʉare bajiro tʉoĩaroca mʉa yigʉre bʉto bʉsa ñeñaro ĩ tʉoĩaroca ya mʉa. Ito bajiri mʉa rẽto bʉsaro ñeñaro yicõri jeame ʉ̃jʉrojʉ warʉjami ĩ cʉni, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Bʉjato bʉjarã wãna ya mʉa. Cajea mana gãjerã cajea manare tʉ̃a wabojarãre bajiro bajirã ña mʉa. Ado bajiro gãjerãre yiboja mʉa: “ ‘Dios ya wi wamenati ado bajiro yicʉja yʉ’, yibojarãti mʉa yiro robo yibeja cʉni no yibea iti. ‘Dios ya wijʉ oro wamena ado bajiro yicʉja yʉ’, mʉa yija, yiro bajiroti yiba itireama”, yiboja mʉa gãjerãre. ");
INSERT INTO myy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tʉo masimena, cajea manare bajiro bajirã ña mʉa. ¿Disejʉa ñati ñasarise mʉa tija? ¿Orojʉa ñasatite mʉa tija? ¿Dios ya wijʉ oro cuji ñarijʉ masa ĩna rʉ̃cʉbʉorijʉ ñatite ñasarijʉ? yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gaje ado bajiro masare yiboja mʉa: “ ‘Diore ĩna soe ĩsisotira casabo wamena ado bajiro yicʉja yʉ’, yibojarãti mʉa yiro robo yibeja cʉni, no yibea iti. ‘Diore ĩna soe ĩsisotira casabojʉ ĩre ĩsiroti wame rãca ado bajiro yicʉja yʉ’, mʉa yija, mʉa yiro bajiroti mʉa yija quena itireama”, yiboja mʉa masare. ");
INSERT INTO myy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tʉo masimena, cajea manare bajiro bajirã ña mʉa. ¿Mʉa tija disejʉa ñati ñasarise? ¿Diore ĩsiroti iti ñati ñasarise, gaje Diore ĩna soe ĩsisotira casabojʉ ĩre ĩsiroti ñarijʉjʉa ñasatite? yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","’Ado bajiro bajia. Tʉote mʉa. No, “Diore ĩna soe ĩsisotira casabo wamena ado bajiro yicʉja yʉ”, yigʉ iti casabo wamena meje riti, “Ado bajiro yicʉja yʉ”, yiguĩji. Diore soe ĩsira casabojʉ jesarise rãca, “Ado bajiro yicʉja yʉ”, yigʉre bajiro bajiami ĩocʉ̃. ");
INSERT INTO myy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","No, “Dios ya wi wame rãca, ado bajiro yicʉja yʉ”, yigʉ iti wi wame rãca riti meje yiguĩji. Dios iti wi ʉjʉ wame rãca, “Ado bajiro yicʉja yʉ”, yigʉre bajiro yiguĩji ĩocʉ̃. ");
INSERT INTO myy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","“Ũmacʉ̃jʉ Dios ĩ ñaro wame rãca ado bajiro yicʉja”, yigʉ Dios itojʉ rotigʉ wame rãcati yigʉre bajiro yami ĩocʉ̃, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Bʉjato bʉjarã wãna ya mʉa fariseo gaye tʉoĩarã, judio masa rotirise riasori masa mʉa cʉni. “Queno yirã ña gʉa”, yibojarãti mʉa yiro robo yirã meje ña mʉa. Jũ queno sʉtirise, anís, menta, comino waja rʉ̃cʉbiti gaye mʉa rʉcoja, Moisés ñayorʉ ĩ rotiado bajiroti Diore jabeto ĩsia mʉa. Ito bajibojarocati rotire ñasarisere tʉorʉ̃nʉbea mʉa. Ado bajiro bajia ñasarise, queno yire, gãjerãre ti maire, Diore tʉorʉ̃nʉre, itocõti ña ñasarise. Iti gaye yitĩñama mʉa, Diore jabeto ĩsire gaye cʉni jidicãbeja mʉa. ");
INSERT INTO myy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cajea mana gãjerã cajea manare tʉ̃a wabojarã bajiro bajirã ña mʉa. Ado bajiro bajirã ña mʉa. Ide wato mʉtarãcã ñarãre ĩna idiroto riojʉa queno besecãbojacõri camello jaigʉ bʉcʉre idi yucõarã bajiro bajirã ña mʉa. Rotire ñasabiti gayeama queno tirʉ̃nʉa mʉa. Ito bajibojarocati ñasarisereama queno tirʉ̃nʉbea mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Bʉjato bʉjarã wãna ya mʉa fariseo gaye tʉoĩarã, judio masa rotirise riasori masa mʉa cʉni. “Queno yirã ña gʉa”, yibojarãti mʉa yiro robo yirã meje ña mʉa. Somotẽro idira tẽrori cʉni joejʉa riti coea mʉa. Totijʉama ñarocõti ʉeri cʉtia maji. Mʉa guaja, joe rujʉ riti coea mʉa. Jubejʉama ñeñaro tʉoĩa maji. Gãjerã ĩna rʉcorise ti ʉorã ĩnare rʉoa mʉa. Ito bajiri bʉjato bʉjarã wãna ya mʉa. ");
INSERT INTO myy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mʉa fariseo gaye tʉoĩarã cajea manare bajiro bajirã ña mʉa. Somotẽro, idira tẽro cʉni totijʉa mʉ coesʉoja joejʉa cʉni ʉeri mano yiroja. Ito bajiroti ñeñaro mʉa tʉoĩarise cʉni mʉa jidicãja, jeyaro queno yirã ñarã yirãji mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Mʉa fariseo gaye tʉoĩarã, judio masa rotirise riasori masa cʉni bʉjato bʉjarã wãna ya mʉa. “Queno yirã ña gʉa”, yibojarãti mʉa yiro robo yirã meje ña mʉa. Masari cuma bajiro bajirã ña mʉa. Ado bajiro bajia masari cuma, joeti mani tija queno boti quena. Ito bajibojarocati jubejʉama gõarigoti ñaroja, ito yicõri jogare bʉorise ñaroja. ");
INSERT INTO myy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ito bajiro bajirã ña mʉa. Masa ĩna tija, queno yirã bajiro bajia mʉa. Ito bajibojarãti jubejʉama ñeñaro tʉoĩarã ña mʉa. “Queno yirã ña gʉa”, yibojarãti ñeñaro yirã ña mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Mʉa fariseo gaye tʉoĩarã, judio masa rotirise riasori masa cʉni bʉjato bʉjarã wãna ya mʉa. “Queno yirã ña gʉa”, yibojarãti mʉa yiro robo yirã meje ña mʉa. Diore goti ĩsiri masa ĩna godaja bero masari cuma menia mʉa. Queno yirãre masari cuma queno tirʉ̃nʉa mʉa, ito yicõri tija seyorise iti joere jeoa mʉa. ");
INSERT INTO myy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ito yicõri ado bajiro ya mʉa: “Gʉa ñicʉsabatia ĩna catijama, Diore goti ĩsiri masare ĩna sĩaroca ĩnare ejabʉabitiboana gʉa”, yi tʉoĩa mʉa. ");
INSERT INTO myy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ito bajiro mʉa yija, “Diore goti ĩsiri masare sĩayoana janerãbatia ña gʉa”, yi tʉoĩa mʉa. ");
INSERT INTO myy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mʉa ñicʉsabatia ĩna yiyore bajiroti ya mʉa cʉni adi rʉmʉri gãna, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Ãña bajiro bajicõri ĩ robo junirã ña mʉa. Jeame ʉ̃jʉrojʉ mʉa tõbʉjaroti rẽtare ma mʉare. ");
INSERT INTO myy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Queno tʉo masijaro ĩna yirocʉ, Diore goti ĩsiri masa, riasori masa gãjerã queno tʉoĩarãre cʉni cõabojagʉ yigʉja yʉ mʉa tʉ. Ĩnare cʉdi ãmomena ĩnare sĩarã yirãji mʉa. Gãjerãreama yucʉtẽojʉ jaju sĩarã yirãji mʉa. Gãjerãre minijuara wijʉ ĩnare jarã yirãji mʉa. Ĩnare ñeñaro yirona co cʉto rʉyabeto ĩnare sʉyarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Abel queno yigʉ ñayorʉre sĩasʉoyijarã mʉa ñicʉsabatia ito yicõri Berequiás macʉ Zacaríasjʉre sĩasʉsayijarã. Dios ya wijʉ Diore ĩna soe ĩsisotira casabo tʉ Zacaríasre sĩayija mʉa. Mʉa ñicʉsabatiare bajiroti ya mʉa cʉni. Ito bajiri queno yirãre ĩna sĩagore ñajare seti ña mʉare cʉni. ");
INSERT INTO myy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Riti mʉare gotia yʉ. Mʉa adi rʉmʉ gãnare ititi seti ña ejaro yiroja mʉare, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Jerusalén gãna mʉare cõañi Dios ĩre goti ĩsiri masa, ito yicõri ĩ oca riasori masare. Ĩre goti ĩsiri masa, ĩ oca riasori masa cʉni mʉare gotirona cõañi Dios. Ito bajibojarocati ĩnare sĩayija mʉa. Coji meje mʉare mioju ãmobojacʉ yʉ. Cara iso rĩare caero rocajʉ iso miojuro robo bajiro, mʉare yi ãmobojacʉ yʉ. Ito bajiro yʉ yi ãmobojarocati ãmobiticʉ mʉa. ");
INSERT INTO myy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Queno tʉoĩaña mʉa. Mʉa wiri wagora wiri bajiro tujaro yiroja. Ito yicõri mʉare jidicãgʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Riti ado bajiro mʉare gotia yʉ: “Gʉare yiari Dios ĩ cõarʉ ña mʉ. Mʉre queno yiñi Dios”, mʉa yiroto riojʉa mʉcana jʉaji yʉre timena yirãji mʉa, ya yʉ mʉare, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ito bajiro ĩ yija bero, Dios ya wi budi wasʉoquĩ Jesús. Ĩre sʉacõri ado bajiro yibojacʉ gʉa ĩre: “Adi wiri ti ucuto mani”, yibojacʉ gʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ito bajiro gʉa yibojarocati ado bajiro yiquĩ Jesús gʉare: —¿Adi wirire tiati mʉa? Riti mʉare gotia yʉ. Adi wiri ñarocõti õjea bate quedicoaro yiroja. Ito bajiri adi wi gaye gʉ̃tagã gajega joe jesabeto yiroja. Ñarocõti godacoaro yiroja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ito yija bero Olivos wame cʉtiri tʉria joejʉ wacʉ gʉa ĩja. Ito ejacõri Jesuama eja rũjũquĩ. Ito ĩ rujiroca gãjerã ĩna manija ticõri, ado bajiro ĩre seniĩacʉ gʉa: —“Iti rʉmʉ wi quediro yiroja”, mʉ yi gotire ãmoa gʉa. ¿No bajiro iti bajija ticõri, “Jesús ejagʉ wagʉ yami”, yi masirã yirãjida gʉa? ¿Ito yicõri no bajija ticõri, “Adi macãrʉcʉ̃ro jediro ya”, yi masirã yirãjida gʉa? yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ito bajiro gʉa yija tʉocõri, ado bajiro cʉdiquĩ Jesús gʉare: —Queno masima mʉa gãjerã mʉare rʉobe yirona. ");
INSERT INTO myy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Jãjarã rʉori masa ejarã yirãji. “Yʉti ña Cristo, Dios ĩ cõarʉ”, yirã masa ejarã yirãji. Jãjarãre rʉorã yirãji ĩna. “Diore bʉsi ĩsirã ña gʉa”, ĩna yija jãjarã masa tʉobojarã yirãji ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Masa gãmeri sĩarã yiyijarã”, yire oca tʉorã yirãji mʉa. “Gaje cʉto gãna jane gãmeri sĩasʉoyijarã”, yire gaye guijorise oca tʉorã yirãji mʉa. Iti ocare mʉa tʉoja güibeja mʉa. Ito bajiroti bajiro yiroja bajirea. Ito bajibojarocati jabeto rʉya adi macãrʉcʉ̃ro iti jediroto. ");
INSERT INTO myy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Co masa gaje masa rãca gãmeri sĩarã yirãji. Ito yicõri co sita gãna gaje sita gãna rãca gãmeri sĩarã yirãji. Jaje cʉtori ñio ñaro yiroja. Ito yicõri jaje ñarise ñaro yiroja. Ito yicõri jaje cʉtorire sita ʉero yiroja. ");
INSERT INTO myy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jeyaro iti rẽtaja bero bʉto bʉsa tõbʉjare gaye ñaro wado yiroja. ");
INSERT INTO myy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Mʉare ñiacõri gãjerã mʉare ja ajetoni mʉare ĩsirã yirãji ĩna. Aje tĩocõri mʉare sĩarã yirãji ĩna. Yʉ ñarã mʉa ñajare mʉare ti tudirã yirãji adi sita gãna jeyaro. ");
INSERT INTO myy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Iti rʉmʉ jãjarã yʉre tʉorʉ̃nʉbojana tʉoĩa jidicãrã yirãji ĩna. Gãmeri ti junisinirã yirãji ĩna. Gãmeri oca menicõri gãjerãre ñiaroca yirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jãjarã rʉori masa ñarã yirãji. “Diore bʉsi ĩsirã ña gʉa”, ĩna yija jãjarã masa tʉobojarã yirãji. ");
INSERT INTO myy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jeyaro ñeñarise yirã yirãji masa. Ito bajicõri gãmeri ĩna ti mairisere gãmeri jidicãrã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","No yʉre tʉorʉ̃nʉgʉ̃ ĩ jidicãbeja adi macãrʉcʉ̃ro jedi wari rʉmʉ ĩre masogʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca adi sita ñarocõreti ejaro yiroja. Ito bajiri masa jeyaro iti oca masirã yirãji. Ĩna masi jediroca adi macãrʉcʉ̃ro jediro yiroja. ");
INSERT INTO myy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Diore goti ĩsiri masʉ Daniel ñayorʉ ado bajiro ucañi: “Adi macãrʉcʉ̃ro jedi wari rʉmʉri sĩgʉ̃ masare ñeñaro ĩna yiroca yigʉ goagʉ yiguĩji. Ĩ ñami masare ruyuriogʉ wadirʉ. Dios ya wi rʉ̃cʉbʉorajʉ ĩ rʉ̃gõja tirã yirãji mʉa”, yi ucañi Daniel ñayorʉ. Mʉa adi papera ticõri, itire queno tʉoĩaña. “Jabeto rʉya adi macãrʉcʉ̃ro iti jediroto”, yi masiña mʉa. ");
INSERT INTO myy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ito bajiro bajiri rʉmʉ no Judea sitajʉ ñarã gʉ̃tagʉ̃jʉ rudi warʉjarãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","No ĩ ya wi queno jesagʉ ĩ ya wi totijʉ gajeoni ñarisere rujicõri ãmibitirʉjaguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","No ĩ ya wesecajʉ moagʉ̃ tʉdi wacõri ĩ ya yutabujuri ãmibitirʉjaguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ito bajiro bajiri rʉmʉ romia macʉ sãñarã, gãjerã rʉcorã cʉni quenabeto tõbʉjarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bʉto ʉsari rʉmʉ, tujacãra rʉmʉ cʉni iti ito bajija, rudi ãmomena Diore senima mʉa. ");
INSERT INTO myy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ito bajiro bajiri rʉmʉri bʉto tõbʉjarã yirãji masa. Adi macãrʉcʉ̃ro ñasʉora rʉmʉri masa ĩna tõbʉjaĩabiti rẽto bʉsaro tõbʉjarã yirãji ĩna. Iti ĩna tõbʉjaja bero mʉcana iti robo bajiro bajirise tõbʉjamena yirãji masa. ");
INSERT INTO myy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yoari masa tõbʉjaroca Dios ĩ yiro bajija sĩgʉ̃ cati rʉyagʉ maniborʉ. Ĩ beseanare ti maicõri yoari mejeti iti jediroca yigʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Iti rʉmʉri, “Tiya ado ñami Cristo”, ito yicõri “Titẽña õ ñami Cristo”, sĩgʉ̃ mʉare ĩ yija, ĩre tʉorʉ̃nʉbeja mʉa. ");
INSERT INTO myy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Jãjarã rʉori masa, “Yʉ ña Cristo”, yi ejarã yirãji ĩna. “Diore bʉsi ĩsiri masa ña gʉa”, yi rʉo ejarã yirãji gãjerã. Tiyamani jaje ĩorã yirãji ĩna masare rʉorona. Dios ĩ beseanare cʉni rʉo ãmobojarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tʉoya mʉa. Jeyaro iti rẽtaroto riojʉa mʉare goticã yʉ. ");
INSERT INTO myy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ito bajiri, “Yucʉ manojʉ ñami Cristo”, mʉare ĩna yi rʉoja, tirã wamenaji mʉa. Ito yicõri, “Ruyubetojʉ ñami Cristo”, ĩna yi rʉoja ĩnare tʉorʉ̃nʉbeja mʉa. ");
INSERT INTO myy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bʉjo ĩ borea borea yirise ʉsitutujʉ ĩ borea yirise cojisiti iti sojejʉ quedituaja tia mani. Itire bajiroti ejagʉ yigʉja yʉ cʉni. Yʉ ña Masa Rĩjorʉ. ");
INSERT INTO myy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","No rujʉ jogarise ñaro itojʉ barã rujirã yirãji yuca. Itire bajiro masa ĩna bʉto ñeñaro yiroca waja senigʉ̃ ejagʉ yiguĩji Dios, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ito bajiro masa ĩna tõbʉjari rʉmʉ iti jedija bero ũmacañi ʉ̃mʉa gagʉ rãitĩacoagʉ yiguĩji. Ñami gagʉ cʉni busubicʉ yiguĩji. Ñocõa cʉni quedi jedicoarã yirãji. Ũmacʉ̃jʉ macãrʉcʉ̃ro cʉni ʉero yiroja. ");
INSERT INTO myy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ito bajiro ũmacʉ̃jʉ macãrʉcʉ̃rojʉ iti bajija ticõri, “Masa Rĩjorʉ ejagʉ wagʉ yami”, yirã yirãji masa. Yʉ ña Masa Rĩjorʉ. Yʉ ruji wadija ticõri, adi sita gãna otirã yirãji ĩna. Masirise rãca, yorise rãca, ide bueri rãca yʉ ruji wadija tirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ũmacʉ̃jʉ trompeta jutiado bajiro oca sẽoro oca ruyuro yiroja. Yʉ beseanare minijuatoni ángel mesare mioju rotigʉ yigʉja yʉ. Jʉaria sojeri gãna yʉ beseana ñarocõreti miojurã yirãji ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Goti masiore ocana mʉare gotigʉ ya yʉ. Higuera wame cʉtiricʉre tʉoĩate mʉa. Higueragʉ iti ñasãtuja, ito yicõri iti jũ wasoaja, “Jabeto rʉya cʉma iti ejaroto”, yi masia mani. ");
INSERT INTO myy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iti bajiroti mʉare yʉ gotire iti rẽtaja ticõri, “Jabeto rʉya ʉ̃mʉari iti jediroto”, yi masirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Riti mʉre gotia yʉ. Adi rʉmʉri gãna ĩna goda jediroto riojʉajʉ ito bajiro rẽtaro yiroja iti. ");
INSERT INTO myy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Adi macãrʉcʉ̃ro ñarocõti jediro yiroja. Ito bajibojarocati yʉ ya ocama yʉ yiro bajiroti rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’“Iti rʉmʉ itocõ tʉjaroca ejagʉ yiguĩji Jesús”, yirã mama. Ángel mesa cʉni masimenaji ĩna. Dios Macʉ ñabojagʉti, “Itocõ ejagʉ yigʉja yʉ”, yi masibea yʉ cʉni. Yʉ Jacʉ Dios ĩ sĩgʉ̃ti masiguĩji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Noé ñayorʉ ĩ catiroca Diore rʉ̃cʉbʉobitiyoñi masa. Ito bajiroti bajirã yirãji masa, yʉ tʉdi ejari rʉmʉ. Yʉ ña Masa Rĩjorʉ. ");
INSERT INTO myy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jane mejejʉ adi sita iti rujaroto riojʉa ñacõayijarã masa maji. Idi mecʉrãtibe, ba yajirãtibe, manojo cʉtirãtibe, ito yicõri ĩna rĩa romiare ĩsirãtibe yi ñayijarã masa. Ito bajiro ĩna baji ñabojaroca riti cuma bʉcʉajʉ sãjayijʉ Noé ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","“Ito bajiro wado ya”, yi masibisijarã masa. Ito bajiri ñajasaroti ĩnare rubatecãcõyijʉ. Iti bajiado robo bajiroti ejagʉ yigʉja yʉ cʉni. Masa Rĩjorʉ ñari, “Itocõ ejagʉ yiguĩji”, masa ĩna yi masibeto tʉdi ejagʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yʉ ejari rʉmʉ jʉ̃arã ʉ̃mʉa ĩna ya wesecajʉ moa ñarã yirãji. Sĩgʉ̃ ãmi wa ecogʉ yiguĩji. Gãji ãmi wa ecobicʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Romia jʉ̃arã quĩbo tuabo ñarã yirãji. Sĩgõ ãmi wa ecogo yigõji. Gajeo ãmi wa ecobeco yigõji. ");
INSERT INTO myy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Bocatiari ñacãña mʉa. Yʉ mʉa Ʉjʉ yʉ tʉdi ejaroti rʉmʉ masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sĩgʉ̃ wi ʉjʉ. “Adi ñami riniri masʉ ejagʉ yiguĩji”, ĩ yi masija, ña yucãgʉ̃ yiguĩji iti wi ʉjʉ. Riniri masʉ ĩ sãjare ãmobicʉ camotagʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ito bajiri yʉ ejaroto riojʉa ña yucãña mʉa. “Itocõ ejagʉ yiguĩji Masa Rĩjorʉ”, yi mʉa tʉoĩabeto ejagʉ yigʉja yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Mʉa tʉoĩaja, ¿no bajiro bajiguĩjida queno cʉdicõri queno tʉoĩagʉ̃? Ado bajiro bajiguĩji ĩocʉ̃. Gãjerã ĩ ya moari masare tirʉ̃nʉtoni ito yicõri ĩnare ĩ ecatoni cũgʉ̃ yiguĩji ĩ ʉjʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sĩgʉ̃ ĩ rotiro bajiroti ĩ moa yuroca ĩ ʉjʉ ĩ tʉdi ejaja wanʉ quenagʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Riti mʉare gotia yʉ. Ito bajiro yiro robo ĩ yigʉ ñaja ticõri, ĩ rʉcorise ñaroti ĩ ya masare cʉni tirʉ̃nʉ rotigʉ yiguĩji ĩre. ");
INSERT INTO myy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ĩ ʉjʉ ĩre ĩ tirʉ̃nʉ rotija bero ricati ĩ tʉoĩaja, queno moa ĩsigʉ̃ meje ñaguĩji ĩocʉ̃. “Coji ejabiquĩji yʉ ʉjʉ”, yi tʉoĩagʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ito bajiro tʉoĩacõri, gãjerã moari masare ñeñaro yisʉogʉ yiguĩji ĩ. Ito yicõri mecʉri masa rãca baba cʉticõri ĩna rãca idigʉ yiguĩji ĩ cʉni. ");
INSERT INTO myy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ito bajiro ĩ yi ñaroca ĩ masia mani ĩ ʉjʉ tʉdi ejagʉ yiguĩji. “Janere ejabicʉ yiguĩji yʉ ʉjʉ”, yi ĩ tʉoĩari rʉmʉti ejagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ito ĩ yija ticõri, bʉto bʉsa ñeñaro ĩ tõbʉjaroca yigʉ yiguĩji ĩ ʉjʉ. “Queno yirã ña gʉa”, yibojarãti ĩna tõbʉjaro bajiroti ĩ tõbʉjaroca yigʉ yiguĩji ĩ ʉjʉ ĩre. Ito bajiri ñeñaro tõbʉjacõri otigʉ yiguĩji. Ito yicõri bʉto tʉoĩa oca jaigʉ yiguĩji ĩ ĩja, yi oca gotiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ado bajiro bajia, ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ Dios ĩ miojuri rʉmʉ”, yirocʉ ado bajiro gotiquĩ Jesús: —Jʉa dʉjamocõ mamarã romia ñayijarã. Ãmo siare basare tirã wayijarã ĩna. Mame manojo cʉtirocʉre bocarã wayijarã ĩna. Ito bajiri ito warã ĩna ya sĩabusuore ãmi wayijarã. ");
INSERT INTO myy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ĩna co dʉjamocõ ñarã ñayijarã queno tʉoĩarã. Gãjerã ĩna rãca gãna co dʉjamocõ ñarã queno tʉoĩamena ñayijarã. ");
INSERT INTO myy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Queno tʉoĩamena ĩna ya sĩabusuoragari ãmibojarãti jio wasoarona ʉ́ye ãmibisijarã. ");
INSERT INTO myy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Gãjerã queno tʉoĩarãma ĩna ya sĩabusuore jio wasoaroti ʉ́ye ãmi wayijarã. ");
INSERT INTO myy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Manojo cʉtirocʉ yoari ĩ sejaja, wʉjo jujayijarã ĩna. Ito bajiri canicoayijarã ĩja. ");
INSERT INTO myy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ñami gʉdarecocõ oca ruyuyijʉ ĩja. “Manojo cʉtirocʉ wadicoami ĩja. Ĩre bocarã waya”, sẽoro oca ruyuyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ĩna jʉa dʉjamocõ romia ñarã yujicõri ĩna ya sĩabusuoragari sĩayijarã. ");
INSERT INTO myy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Co dʉjamocõ ñarã queno tʉoĩamena ado bajiro yiyijarã queno tʉoĩarãjʉare: “Gʉa ya sĩabusuoraga ʉ́ye jedicoajʉ gʉare. Ito bajiri mʉa ya ʉ́ye jabeto ĩsiña gʉare”, yibojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ito bajiro ĩna yibojarocati ado bajiro cʉdiyijarã queno tʉoĩarã: “Ĩsibea mʉare. Gʉa ĩsija ñejʉa tujabetoja gʉare cʉni. Mʉare cʉni, gʉare cʉni tĩjado ma iti. Mʉamasiti ʉ́ye ĩna ĩsirojʉ wacõri waja yitẽña mʉa”, yiyijarã queno tʉoĩarã romia queno tʉoĩamenajʉare. ");
INSERT INTO myy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ito bajiro ĩna yija tʉocõri, ʉ́ye waja yirã wayijarã queno tʉoĩamena. Ĩna wagoja bero manojo cʉtirocʉ ejayijʉ. Queno ña yucãna romiama ĩ ejarocati ĩ rãcati sãjacoayijarã ĩna. Ãmo siare basa tirã warã sãjayijarã ĩna. Ito yicõri soje biacõyijʉ manojo cʉtirocʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Soje ĩ bia sãja waja berojʉ ejabojayijarã gãjerã romia. Manojo cʉtirocʉre ado bajiro yibojayijarã ĩna: “Gʉa ʉjʉ soje jãnaña maji”, yibojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Yʉ ñarã meje ña mʉa, ito bajiri mʉare masibea yʉ”, yiyijʉ manojo cʉtirocʉ ĩnare, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Ito bajiri ña yucãña mʉa. “Jane busuri itocõ ñaroca ejagʉ yiguĩji Jesús”, yi masibea mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ado bajiro bajia, ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ Dios ĩ miojuri rʉmʉ”, yirocʉ ado bajiro gotiquĩ Jesús: —Sĩgʉ̃ ñayijʉ gaje sitajʉ warocʉ. Ito bajiri ĩ waroto riojʉa ĩ ya moari masare ji ñucayijʉ ĩ. “Yʉ ya niyeruna moacõri jai bʉsaro bʉjarã yirãji”, yi tʉoĩa wacʉ ĩ ya niyerure tirʉ̃nʉ rotiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Sĩgʉ̃re co dʉjamocõ mil niyeru cujiri ĩsiyijʉ. Gãjire jʉaji mil ĩsiyijʉ. Gãjire mil ñari cujiriacã ĩsiyijʉ. “Ado bajiroti moari seyoama ĩna”, yi tʉoĩa wacʉ ito bajiro ĩnare batoyijʉ ĩ. Ito bajiro yicõri wacoayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Co dʉjamocõ mil niyeru cujiri boca ãmirʉ mʉcana itina moacõri gaje co dʉjamocõ mil ñariseti bʉja remoyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Gãji jʉaji mil boca ãmirʉ mʉcana itina moacõri jʉa mil bʉja remoyijʉ ĩ cʉni. ");
INSERT INTO myy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Coji mil boca ãmirʉama ĩ ʉjʉ ya niyeru gojejʉ yujecõyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Yoari ĩna ʉjʉ tʉdi ejayijʉ mʉcana. “¿No bajiro yʉre moa ĩsiati ĩna?” yirocʉ ĩnare ji ñucayijʉ ĩ mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cajero co dʉjamocõ mil boca ãmirʉ ejasʉoyijʉ. Ejacõri ĩre co dʉjamocõ mil niyeru ĩ ĩsire jʉdacõayijʉ mʉcana, ito yicõri gaje itocõ ĩ bʉja remore rãcati ĩre ĩsiyijʉ. “Co dʉjamocõ mil yʉre ĩsicʉ mʉ. Ito bajiri itina moacõri mʉcana co dʉjamocõ milti mʉre bʉja remo ĩsimʉ yʉ”, yiyijʉ ĩ ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Yʉre queno moa ĩsiyija mʉ. Yiro robo yʉre cʉdigʉ ña mʉ. Jabetacã yʉ wasoarena mʉcana itocõti mʉ remore ñajare, jai bʉsaro mʉ moatoni jai bʉsaro mʉre cũcʉja yʉ. Sãjaña, queno wanʉña yʉ rãca”, yiyijʉ ʉjʉ ĩ ya moari masʉre. ");
INSERT INTO myy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ito yija bero gãji jʉaji mil boca ãmirʉ ejayijʉ. “Yʉ ʉjʉ jʉaji mil yʉre ĩsicʉ mʉ. Itina moacõri mʉcana jʉaji milti mʉre bʉja remo ĩsimʉ yʉ”, yiyijʉ ĩ, ĩ ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Yʉre queno moa ĩsiyija mʉ. Yiro robo yʉre cʉdigʉ ña mʉ. Jabetacãna moacõri mʉcana itocõti mʉ yʉre bʉja ĩsire ñajare jai bʉsaro mʉcana moaroti cũcʉja yʉ. Sãjaña, queno wanʉña yʉ rãca”, yiyijʉ ĩ, ĩ ya moari masʉre. ");
INSERT INTO myy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Ito yija bero gãji mil cujiri boca ãmirʉ ejayijʉ. Ĩ ʉjʉre ado bajiro yiyijʉ ĩ: “Yʉ ʉjʉ sẽoro rotigʉ ñaquĩ ĩ. Ĩ otebeto cʉni, ĩ biabeto cʉni bare bʉja quena ñaquĩ ĩ, yi tʉoĩa wacʉ, güicʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ito bajiri mʉ ya niyerure yuje cũcʉ yʉ. Adi ña ñarocõti yʉre mʉ ĩsicati”, yiyijʉ ĩ, ĩ ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ito bajiro ĩ yibojarocati ado bajiro cʉdiyijʉ ĩ ʉjʉ ĩre: “Moa ĩsiri masʉ quenabicʉ, rojogʉ ña mʉ. Ĩ otebeto cʉni, ĩ biabeto cʉni bare bʉja quena ñaquĩ ĩ, yi masibojagʉti yʉre queno moa ĩsibisija mʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ĩna niyeru cũri wijʉ mʉ niyeru cũja, mʉcana jai bʉsaro bʉjaboyija mʉ”, yiyijʉ ĩ ʉjʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ito yija gãjerãre ado bajiro rotiyijʉ ʉjʉ: “Coji mil ñarise niyeru tiri ĩre ẽmacõña, ito yicõri gãji jʉa dʉjamocõ mil rʉcogʉjʉare ĩsiña”, yiyijʉ ĩna ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“No queno yʉre moa ĩsigʉ̃reama jai bʉsaro ĩre ĩsi remogʉ̃ yigʉja yʉ. Ito bajiri ñejʉa rʉyabeto yiroja ĩre. No queno yʉre moa ĩsibicʉreama ĩ rʉcoriseacãti ñarocõti ẽma jeocõcʉja yʉ. Ĩre ẽmacõri gãji yʉre queno moa ĩsigʉ̃re ĩsigʉ̃ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ãni yʉre moa ĩsiri masʉ ñe waja macʉre rãitĩarojʉ cõaña mʉa. Itojʉ ñeñaro tõbʉjacõri bʉto otigʉ yiguĩji. Ito yicõri bʉto tʉoĩa oca jaigʉ yiguĩji ĩ”, yiyijʉ ʉjʉ, yi oca gotiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Yʉ ña Masa Rĩjorʉ. Ʉjʉ yʉ ñari rʉmʉ, tʉdi ejagʉ yigʉja yʉ mʉcana. Ũmacʉ̃jʉ gãna ángel mesa rãca gãni bia ejagʉ yigʉja yʉ. Ʉjʉ ĩ rotiri cumuro yori cumurojʉ rujigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jeyaro gãna masa yʉ riojʉa minijuarã yirãji ĩna. Ĩnare besecõri ricati cũgʉ̃ yigʉja yʉ. Oveja coderi masʉ ovejare ricati, cabrare ricati ĩ cũado bajiro yigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Queno yirãre yʉ ya riojocadʉja cũgʉ̃ yigʉja yʉ. Queno yimenare yʉ ya gãcodʉja cũgʉ̃ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ito bajiri yʉ riojocadʉja gãnare ado bajiro yigʉ yigʉja yʉ: “Yʉ Jacʉ queno yirocʉ mʉare beseñi ĩ rotirojʉ mʉa ejatoni. Ĩre tʉorʉ̃nʉrãre tʉoĩa yugʉ ĩ rotirojʉ quenocãñi Dios adi macãrʉcʉ̃ro meni wacʉjʉti. Ito bajiri itojʉ ñarã yirãji mʉa ĩja. ");
INSERT INTO myy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉ ñiocõja yʉre bare ecacʉ mʉa. Yʉ idi ãmoja yʉre iocʉ mʉa. Yʉ wa ucurojʉ canirajʉ bʉja ĩsicʉ mʉa. ");
INSERT INTO myy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yʉre yutabuju manija yʉre ĩsicʉ mʉa. Yʉ cõja cʉni yʉre tirã ejasoticʉ mʉa. Tubiara wi yʉ ñaroca yʉre tirã ejasoticʉ mʉa”, yigʉ yigʉja yʉ Dios ĩ beseanare. ");
INSERT INTO myy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ito bajiro yʉ yija tʉocõri, ado bajiro yʉre seniĩarã yirãji ĩna: “Gʉa Ʉjʉ, ¿nocãta mʉ ñiocõja ticõri, mʉre bare ecacati gʉa? ¿Nocãta mʉ idi ãmoroca mʉre iocati gʉa? ");
INSERT INTO myy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Nocãta mʉ wa ucurojʉ canirajʉ mʉre bʉja ĩsicati gʉa? Ito yicõri, ¿nojʉ mʉ yutabuju maniroca mʉre yutabuju bʉja ĩsicati gʉa? ");
INSERT INTO myy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ito yicõri, ¿nocãta mʉ tubia ecoroca, mʉ cõja cʉni, nocãta mʉre tirã ejacati gʉa?” yi yʉre seniĩarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ado bajiro ĩnare cʉdigʉ yigʉja yʉ: “Riti mʉare gotia yʉ. Yʉ ñarã ñasamenare queno mʉa yija, yʉre queno yirãti yicʉ mʉa”, yigʉ yigʉja yʉ Dios ĩ beseanare. ");
INSERT INTO myy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ito yicõri yʉ ya gãcodʉja ñarãre ado bajiro yigʉ yigʉja yʉ: “Yʉre camotadiya mʉa. Dios ĩ beseana meje ña mʉa. Jeame yatibitimejʉ wasa mʉa. Iti jeamere rʉ̃mʉ́re yiari rioñi Dios, ito yicõri ĩ ñarãre yiari cʉni. ");
INSERT INTO myy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉ ñiocõja yʉre ecabiticʉ mʉa. Yʉ idi ãmoja iobiticʉ mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yʉ wa ucurojʉ yʉre canirajʉ bʉja ĩsibiticʉ mʉa. Yʉre yutabuju manija yʉre ĩsibiticʉ mʉa. Yʉ cõroca cʉni, tubiara wi yʉ ñaroca cʉni yʉre tirã ejabiticʉ mʉa”, yigʉ yigʉja yʉ queno yimenare. ");
INSERT INTO myy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ito yija ado bajiro yʉre seniĩarã yirãji ĩna: “¿Nocãta mʉ ñiocõroca mʉre ecabiticati gʉa? Ito yicõri, ¿nocãta mʉ idi ãmoja, mʉ cani ãmoja, mʉre yutabuju manija, mʉ cõja cʉni, tubiara wi mʉ ñaja cʉni, mʉre ejabʉabiticati gʉa?” yi yʉre seniĩarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ito bajiro ĩna yija tʉocõri, ado bajiro ĩnare cʉdigʉ yigʉja yʉ: “Riti mʉare gotia yʉ. Yʉ ñarã ñasamenare queno mʉa yibeja, yʉre cʉni ito bajiroti queno yibiticʉ mʉa”, yigʉ yigʉja yʉ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ito bajiri tõbʉjare sʉsabetojʉ ĩnare cõagʉ̃ yigʉja yʉ. Dios ĩ beseanama catitĩñadojʉ warã yirãji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ito bajiro ĩ goti jeoja bero gʉa ĩ rãca riasotirãre ado bajiro yiquĩ Jesús: ");
INSERT INTO myy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mʉa masia jʉa rʉmʉ beroti ñaro wado ya Pascua basa. Ito bajiro basa ĩna meniri rʉmʉ Masa Rĩjorʉre ñiatoni ĩ wajanare gotigʉ yiguĩji sĩgʉ̃. Ito bajiri ĩre ñiacõri yucʉtẽojʉ jaju sĩarã yirãji ĩna. Ĩti ña yʉ Masa Rĩjorʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iti rʉmʉri paia mesa ʉjʉ Caifás wame cʉtigʉ ya wijʉ minijuacõri tʉoĩa ñayijarã paia ʉjarã, ito yicõri judio masa bʉcʉrã cʉni. ");
INSERT INTO myy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","“¿No bajiro rʉocõri Jesure sĩarã yirãjida mani?” yi gãmeri bʉsi ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ado bajiro bʉsiyijarã ĩna: —Basa rujarʉmʉ Jesure sĩamenaji mani. Rujarʉmʉ mani sĩaja, bʉto manire masa oca jaicõri gãmeri oca menirã yirãji ĩna, yi gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betaniajʉ Simón cami jogagorʉ ya wijʉ ñacʉ gʉa Jesús rãca. ");
INSERT INTO myy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iti cʉto gʉa ñaroca sĩgõ gʉ̃tagã toti cʉtiricajʉ sʉtirise jiocõri ãmi ejacõ. Sʉtirise iso jioraga alabastro wame cʉticʉ. Bʉto waja cʉtirise ñacʉ iti sʉtirise. Jesús ĩ ba rujiroca ĩ ya rijogajʉ sʉtirise jiojeocõ iso. ");
INSERT INTO myy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ito bajiro iso yija ticõri, bʉjatobiticʉ gʉa ĩ rãca riasotirã. Ado bajiro gãmeri bʉsicʉ gʉa: —¿No yija rocati itire ruyurioati? ");
INSERT INTO myy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iti sʉtirise ĩsicõri jairo niyeru bʉjacõri bojoro bʉjarãre ejabʉaroti ñabojayija iti, yi gãmeri tʉoĩa bʉsicʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ito bajiro gʉa tʉoĩa bʉsija tʉocõri, ado bajiro yiquĩ Jesús gʉare: —Adiore ʉsirio code yibesa mʉa. Iti yʉre iso jiojeoja, queno yʉre yigo yamo iso. ");
INSERT INTO myy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mʉa rãca riti ñatĩñarã yirãji bojoro bʉjarã. Ito bajiri ĩnare ejabʉatĩñarã yirãji mʉa. Yʉama mʉa rãca ñatĩñabicʉ yigʉja. Ito bajiri mʉa rãca yʉ ñaroca maji yʉjʉare ejabʉaja quena. ");
INSERT INTO myy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Adio yʉre iso sʉtirise jiojeoja yʉre ĩna yujeroto riojʉa jiojeo yugo yamo iso. ");
INSERT INTO myy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Riti mʉare gotia yʉ. Adiore ãcabojamena yirãji masa. Ito bajiro sʉtirise yʉre iso jiojeoja bero masa jeyaro tʉorã yirãji iti gaye. “Masare masogʉ̃ yiguĩji Dios”, yire oca ĩna gotiroti iso oca cʉni tʉorã yirãji masa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ito yija bero gʉa Jesús rãca riasotirã jʉa gʉbojeno ñarã gʉa rãca gagʉ Judas Iscariote wame cʉtigʉ paia ʉjarãre bʉsigʉ waquĩ. ");
INSERT INTO myy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ito bajiri ado bajiro gotiyijʉ ĩ ĩnare: —Jesure mʉa ñia masitoni mʉare yʉ gotija, ¿nocõ jairo yʉre waja yirãjida mʉa? yi bʉsiñi Judas ĩnare. Ito ĩ yija tʉocõri, sĩgʉ̃ masʉcõ gãji ye jʉa dʉjamocõ ñarise niyeru tiri ĩsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Iti niyeru boca ãmicõri: “¿No bajiro yicõri Jesure rʉorʉjatibe yʉ ĩre ĩna ñiatoni?” yi tʉoĩa ñayijʉ Judas iti rʉmʉre. ");
INSERT INTO myy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ito yija naju wadarise ʉco wʉoya mani bara rʉmʉ cõña wacʉ gʉare. Gʉa Jesús rãca riasotirã ado bajiro ĩre seniĩacʉ: —Pascua basa ñaroca baroti gaye, ¿nojʉ menirʉjati mʉca? yi seniĩacʉ gʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Cʉtojʉ wasa mʉa. Ito mʉa ejaja sĩgʉ̃re bʉjarã yirãji mʉa. Ado bajiro ĩre yiba: “Ado bajiro roti ñucami gʉa ʉjʉ gʉare. Jabetoti rʉya yʉ wẽjoroto. Ĩ ya wijʉ Pascua basa meniana mani, yi ñucami gʉare riasogʉ”, yiba mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","“Ito bajiro yiba mʉa”, Jesús ĩ gʉare yicato bajiroti yicʉ gʉa. Ito bajiroti Pascua basa ĩre meni ĩsisʉocʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iti ñami gʉa ĩ rãca riasotirã jʉa gʉbojeno ñarã ba rujicʉ ĩ rãca. ");
INSERT INTO myy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Gʉa baroca ado bajiro yiquĩ Jesús gʉare: —Riti mʉare gotia yʉ. Sĩgʉ̃ mʉa rãca gagʉ yʉre ñiatoni gãjerãre gotigʉ yiguĩji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ito ĩ yija tʉocõri, bʉto bojori bʉjacʉ gʉa. Ito bajiri sĩgʉ̃ rʉyabeto Jesure seniĩacʉ gʉa: —¿Yʉ Ʉjʉ yʉti ñabeati yʉ mʉre oca menirocʉ? yi seniĩacʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ado bajiro cʉdiquĩ Jesús gʉare: —Yʉ bari tẽro ba ijagʉ ĩ ñagʉ̃ yiguĩji yʉre ñiatoni gãjerãre gotirocʉ. ");
INSERT INTO myy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dios oca iti gotiro bajiroti rẽtaro yiroja yʉre. Yʉ ña Masa Rĩjorʉ. Yʉre sĩarã yirãji masa. Bʉjato yiguĩji yʉre ñiatoni gãjerãre gotirocʉ. Rujeabiticõ rʉjabojañi ĩama, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ito yija bero Judas Jesure ñiatoni gãjerãre gotirocʉ bʉsiquĩ. Ado bajiro yiquĩ ĩ: —Yʉre riasogʉ, ¿yʉti ñati mʉre ñiatoni gãjerãre gotirocʉ mʉ tija? yiquĩ ĩ Jesure: —Mʉti ña, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ito yija bero gʉa ba rujiroca ĩ ya ãmojʉ naju ãmi rʉcoquĩ Jesús. “Queno ya Dios mʉ”, yicõri gʉa ĩ rãca riasotirãre batoquĩ. —Baya, iti ña yʉ ya rujʉ robo bajiro bajirise, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Iti gʉa ba tĩoroca rujatẽro ãmi rʉcocõri, “Queno ya yʉ Dios mʉ”, yiquĩ Jesús. Ito yicõri gʉare io batoquĩ. —Mʉa jeyaro itire idiya. ");
INSERT INTO myy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iti ña yʉ ya rí robo bajiro bajirise. Jãjarã ĩna ñeñaro yirise ĩna waja yi ĩsitoni, yʉ ya rí budiro yiroja. Itire ticõri, “Oca mame Dios ĩ goticãdo bajiroti bajia”, yi tʉoĩa masirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Riti mʉare gotia yʉ. Adi sitajʉ mʉcana jʉaji mʉa rãca ʉyé ide idibicʉ yigʉja yʉ. Ũmacʉ̃jʉ yʉ Jacʉ ĩ rotirojʉ mʉcana tʉdi mʉa rãca idigʉ yigʉja yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ito ĩ yija bero Diore basacʉ gʉa. Basa tĩocõri Olivos wame cʉtiri tʉriajʉ wacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ito gʉa waroca ado bajiro yiquĩ Jesús gʉare: —Adi ñamiti yʉre jidicãcõri wagorã yirãji mʉa ñarocõti. Yʉre mʉa wagoja cʉni, Dios oca tutijʉ iti gotiado bajiroti rẽtaro yiroja. Ado bajiro gotia iti. Tʉote mʉa: “Oveja coderi masʉre sĩagʉ̃ yigʉja yʉ. Ito bajiri ĩ ya oveja rudi batecoarã yirãji”, yi gotiami Dios ĩ oca tutina. ");
INSERT INTO myy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yʉre ĩna ñiaja ticõri, rudi batecoarã yirãji mʉa. Ito bajibojarocati yʉre ĩna sĩaja bero mʉcana tʉdi catigʉ yigʉja yʉ. Tʉdi caticõri mʉa riojʉa bʉsa Galilea sitajʉ wacʉ yigʉja yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ito ĩ yija tʉocõri, ado bajiro yiquĩ Pedro ĩre: —Ĩnama mʉre wagobojarocati yʉama wagobicʉ yigʉja yʉ, yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ito ĩ yija tʉocõri, ado bajiro cʉdiquĩ Jesús ĩre: —Riti mʉre gotia yʉ. Adi ñamiti busurijʉa cara ĩ yujiroto riojʉa ʉdiaji, “Jesure masigʉ̃ meje ña yʉ”, yigʉ yigʉja mʉ, yiquĩ ĩ Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Yʉre ĩna sĩa ãmoja cʉni, “Jesure masibea yʉ”, yibicʉ yigʉja yʉ, yiquĩ Pedro Jesure. Ito bajiro Pedro ĩ yija tʉocõri, gʉa Jesús rãca riasotirã ito bajiro riti yi jedicʉ gʉa cʉni ĩja. ");
INSERT INTO myy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Warãjʉ Getsemaní wame cʉtiri wesejʉ ejacʉ gʉa Jesús rãca. Itojʉ ejacõri ado bajiro gotiquĩ Jesús gʉare: —Õ Diore bʉsigʉ yʉ waroca riti, ado rujiya maji, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedrore, Zebedeo rĩa jʉ̃arãre ji waquĩ Jesús. Wacʉti bʉto tʉoĩa bojori bʉjaquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ito yija ado bajiro yiyijʉ Jesús ĩ rãca wacãnare: —Yʉ ya ʉsijʉ bʉto tʉoĩa bojori bʉja yʉ. Ito bajiro yʉ bojori bʉjaja, ʉsi jediri guijoro bajia yʉre. Ado yʉre yu ñaña maji. Canibeja. Yʉ rãcati tiba maji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ito yicõri ito sõjʉa bʉsa wa remoyijʉ Jesús. Sitajʉ ĩ ya rio cʉ̃oro muqueacõri Diore bʉsiyijʉ ĩ: —Cʉna ñejʉa mʉ yi masibiti manoja. Yʉ tõbʉjaroti gaye mʉ camota ãmoja, camota masigʉ̃ja mʉ. Ito bajibojarocati yʉ ãmoro bajiro meje yigʉja mʉ. Mʉ ãmoro bajiro mʉ yija quena, yi bʉsiyijʉ Jesús Diore. Itocõ ĩ bʉsi tʉjarocati canigocõcʉ gʉama ĩja. ");
INSERT INTO myy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ito ĩ yija bero Pedro mesa tʉ tʉdi ejayijʉ ĩna caniroca. Ado bajiro bʉsiyijʉ Jesús Pedro mesare: —¿Coji cõrecõ canimenati yʉ rãca ti sẽobeati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Canibesa mʉa maji. Yʉ rãcati tiya. Rʉ̃mʉ́re cʉdibe yirona Diore seniña mʉa maji. Riti mʉare masia yʉ. Mʉa ya ʉsijʉama queno tʉoĩarã ñabojarãti mʉa ya rujʉna queno yi masibea mʉa. Yʉre queno cʉdi ãmobojarãti queno cʉdimenaji mʉa, yiyijʉ Jesús Pedro mesare. ");
INSERT INTO myy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ito yicõri mʉcana tʉdi wacʉjʉ ado bajiro Diore bʉsiyijʉ Jesús: —Yʉ Jacʉ yʉ tõbʉjarotire mʉ camota ãmobeja quena ñaroja. Mʉ ãmoro bajiroti bajijaro, yiyijʉ Jesús Diore bʉsigʉ. Ito bajiro Jesús ĩ Diore bʉsiroca canicoayijarã Pedro mesa mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tʉdi wacʉ ĩna caniroca tʉdi ejayijʉ Jesús mʉcana. Bʉto wʉjo ĩnare jeobʉaja caniyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ito bajiro ĩnare bʉsicãriti mʉcana Diore bʉsigʉ wayijʉ Jesús. Ito yicõri Diore ĩ bʉsiado bajiroti tʉdi bʉsiyijʉ mʉcana. ");
INSERT INTO myy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ito yija bero gʉa tʉ ejacõri gʉare yujioquĩ Jesús: —¿Tujacã canirã yati mʉa maji? Itocõti eja wajʉ Masa Rĩjorʉre ñiacõri ñeñaro yirãre ĩna ĩsirotijʉ eja wajʉ ĩja. Ĩti ña yʉ Masa Rĩjorʉ. ");
INSERT INTO myy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ito bajiri yujiya mʉa. Wato. Yʉre ĩna ñiatoni gotiri masʉ wadicoami ĩja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ito bajiro Jesús gʉare ĩ bʉsi ñaroca riti, jʉa gʉbojeno ñagʉ̃ Judas ejaquĩ. Jãjarã ĩ rãca wadicã sarera jãiri rʉcorã, gãjerã yucʉ rʉcorã. Paia ʉjarã, judio masa bʉcʉrã ĩna cõajare wadiñi ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","“Ado bajiro mʉare goticʉja yʉ”, yi ĩnare bʉsi wadicãri seyoñi Judas: —Recoti yʉ usugʉ ĩti ñagʉ̃ yiguĩji Jesús. Ĩre ñiama mʉa, yi ĩnare bʉsi wadiri seyoñi ĩ. ");
INSERT INTO myy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gʉa tʉ ejacõri ado bajiro yiquĩ Judas Jesure: —¿Ñati yʉre Riasogʉ mʉ? yi ejaquĩ ĩre. Ito yigʉti wayugajʉ muwãcõri Jesure usuquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—¿No yigʉ wadiri yʉ baba mʉ? yiquĩ Jesús ĩre. Ito ĩ yiroca ĩre ñiacã Judas rãca wadiana. ");
INSERT INTO myy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ito bajiro Jesure ĩna ñiaja ticõri, sĩgʉ̃ gʉa rãca gagʉ ĩ ya sarera jãi ãmiquĩ, ito yicõri paia ʉjʉ ya moari masʉre gãmoro jataquĩ. ");
INSERT INTO myy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ito ĩ yija ticõri, ado bajiro yiquĩ Jesús ĩre: —Mʉ ya sarera jãi mʉcana iti wirojʉ ñusacõña. Sarera jãina gãmeri jarã itinati godarã yirãji. ");
INSERT INTO myy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Adocãta yʉ Jacʉre yʉ seni ñucaja, ángel mesa jãjarãguti jʉa gʉbojeno masa buturi cõagʉ̃ yiguĩji ĩ. ¿Itire masibeati mʉa? ");
INSERT INTO myy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ito bajibojarocati ĩre senibicʉ yigʉja yʉ. Yʉre ĩna ñiajare ito bajiro gotia Dios oca. “Ito bajiroti rẽtaro yiroja”, Dios ĩ yicãre ñari, ito bajiroti bajiro ya yʉre, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ito yicõri ĩre ñiarã ejarãre ado bajiro yiquĩ Jesús: —¿Riniri masʉre ñiarona bajiro sarera jãiri rãca, yucʉ rãca yʉre ñiarã wadiri mʉa? Co rʉmʉ rʉyabeto mʉa wato riaso rujisotibojacʉ yʉ minijuara wijʉ. Ito bajibojarocati yʉre ñiabiticʉ mʉa maji. ");
INSERT INTO myy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Jeyaro yʉre rẽtaroti Diore goti ĩsiri masa ĩna ucado bajiroti rẽtaro ya, yiquĩ Jesús ĩre ñiacãnare. Jesure ĩna ñiaja ticõri, rudicoacʉ gʉa. Jesús sĩgʉ̃ti ĩna rãca tujaquĩ. ");
INSERT INTO myy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesure ñiacõri paia ʉjʉ Caifás wame cʉtigʉ tʉ ĩre ãmi wayijarã. Itojʉ minijua ñayijarã judio masa rotirise riasori masa ito yicõri ĩna masa bʉcʉrã cʉni minijua ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesure ĩna ãmi waroca sõbʉsa yeyo ti sʉya wayijʉ Pedro. Paia ʉjʉ ya wi soje riojo sãjacõri rujiyijʉ Pedro. Iti wi coderi masa rãca rujiyijʉ ĩ. “No bajiro Jesure ĩna yi gajanoaja ticʉja yʉ”, yirocʉ ito bocati rujiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paia ʉjarã, ʉjarã ñasari masa cʉni Jesure sĩa ãmoyijarã ĩna. Ito bajiri, “Ado bajiro ñeñaro yiquĩ Jesús”, yi rʉo gotironare ãmabojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jãjarã socari masa ĩna oca menibojarocati, “Riti bajia ĩna gotirise”, yi masibisijarã ĩna. Sʉsari jʉ̃arã rʉo gotiri masa ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ado bajiro gotiyijarã: —“Dios ya wi minijuara wi iti wire yʉ ruyuriocõja, ʉdia rʉmʉ beroti mʉcana iti wire jõrojocõgʉ̃ja yʉ”, yiquĩ ãni, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ito ĩna yija tʉocõri, paia ʉjʉ wʉmʉ rʉ̃gʉ̃cõri ado bajiro yiyijʉ Jesure: —¿Cʉdibicʉti yati mʉ? Ito bajiro mʉre ĩna bʉsituja, ¿no yireoni yirã yati ĩna? yibojayijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ito ĩ yibojarocati Jesuama cʉdibisijʉ ĩre. Ĩ cʉdibeja ticõri, ado bajiro yiyijʉ paia ʉjʉ Jesure mʉcana: —Dios catigʉ ĩ tiro riojo riojo gotiya mʉ. ¿Mʉti ñati Cristo Dios ĩ cõarʉ? ¿Ĩ macʉti ñati mʉ? Gʉare gotiya maji, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Mʉ seniĩaro bajiroti, ĩti ña yʉ. Gaje ado bajiro mʉare gotia yʉ: Dios jeyaro masigʉ̃ ya riojocadʉja Masa Rĩjorʉ ĩ rujija tirã yirãji mʉa. Ito yicõri ũmacʉ̃jʉ ide buerina ĩ ruji wadija tirã yirãji mʉa. Ĩti ña yʉ Masa Rĩjorʉ, yiyijʉ Jesús paia ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ito bajiro Jesús ĩ yija tʉocõri, bʉto junisinigʉ̃ ĩ ya yutabuju tʉ̃a ñigãyijʉ: —Ãni ʉ̃mʉgʉ̃ ñeñaro Diore bʉsituami. Gãjerã, “Ĩre seti ña”, yironare ãmare ma ĩja. Mʉa cʉni Diore ĩ bʉsituja tʉoa mʉa. ");
INSERT INTO myy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿No bajiati mʉaca? ¿No bajiro ĩre yirʉjati mani? yiyijʉ paia ʉjʉ masare. —Seti ñasacõa ĩre. Sĩarʉjami, yi cʉdiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ito yija Jesús ya riore go ide eobate guyijarã ĩna. Ito yicõri ĩre jayijarã. Gãjerã ĩ ya riojʉ jayijarã. ");
INSERT INTO myy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ĩ ya cajea moabiacõri, ĩre jayijarã ĩna. Ito yicõri ado bajiro ĩre seniĩa tudiyijarã: —Riti Cristo Dios Macʉ mʉ ñaja, “Ĩ yʉre jami”, yi masigʉ̃ja mʉ, yi tudiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wi totijʉ ito bajiro rẽtaroca, macʉ̃jʉ soje riojo rujicõayijʉ Pedro. Sĩgõ moa ĩsiri maso Pedro tʉ ejacõri ado bajiro yiyijo ĩre: —Jesús Galilea sita gagʉ rãca wa ucuyijʉ mʉ cʉni, yiyijo iso ĩre. ");
INSERT INTO myy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ito bajiro iso yija tʉocõri, masa jeyaro ĩna tʉoro riojo ado bajiro yiyijʉ Pedro: —“Riti ya mʉ”, yi masibea yʉ mʉre, yi rʉoyijʉ Pedro isore. ");
INSERT INTO myy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sãjasʉora soje tʉ Pedro ĩ ejagʉ wagʉ yiroca tiyijo gajeo mʉcana: —Jesús Nazaret cʉto gagʉ rãca wa ucuñi ĩ cʉni, yiyijo gãjerãre gotigo. ");
INSERT INTO myy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—“Dios ĩ tiro riojo ĩre masibea yʉ”, ya yʉ, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ito bero yoa bʉsari Pedrore ado bajiro yiyijarã gãjerã: —Riti ña. Jesús rãca wa ucugʉti ña mʉ cʉni. Ĩnare bajiroti bʉsia mʉ cʉni, yiyijarã ĩna Pedrore. ");
INSERT INTO myy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—Ito bajiro mʉa bʉsigʉre tiĩabea yʉ. Rʉore oca yʉ gotija, Dios yʉre sĩajaro, yi oca sẽoro bʉsiyijʉ Pedro. Ito bajiro ĩ yiroca riti cara yujicoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Cara ĩ yujija tʉocõri, Jesús ĩre bʉsigorere tʉoĩa bʉjayijʉ Pedro: “Cara ĩ yujiroto riojʉa ʉdiaji, ‘Jesure masibea yʉ’, yigʉ yigʉja mʉ”, Jesús ĩ yire tʉoĩa bʉjayijʉ Pedro. Ito budi wacõri bʉto otiyijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Busuri gaje rʉmʉ paia ʉjarã, judio masa bʉcʉrã minijua ñayijarã. Sĩgʉ̃re bajiro riti tʉoĩacõri, “Ado bajiro Jesure sĩarʉja mani”, yi tʉoĩa ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ito bajiro ĩna yija bero Jesure ãmojʉ siacõri ãmi wayijarã ĩna. Ito yicõri ĩre ãmi wacõri Pilatore ĩsiyijarã ĩna. Romano masa ʉjʉ ñayijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas Jesure ĩna ñiatoni gotirʉ, “Jesure sĩarã go yirʉ ãna”, yi tʉoĩayijʉ Judas. Iti tʉoĩacõri, “Queno yibiticʉ yʉ”, yi tʉoĩa bojori bʉjayijʉ Judas. Ito bajiri paia ʉjarãre, judio masa bʉcʉrãre cʉni ĩna tʉ wacõri niyeru treinta tiri ĩ bʉjabojare jʉdacõayijʉ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ado bajiro ĩnare yiyijʉ ĩ: —Queno yibiticʉ yʉ. Ñe seti macʉreti mʉare oca menibojacʉ yʉ, ĩre mʉa ñiatoni, yiyijʉ ĩ paia ʉjarãre. Ito bajiro ĩ yibojarocati ado bajiro ĩre cʉdiyijarã ĩna: —Ito bajiro mʉ gʉare yibojaja, no yibea gʉare. Mʉreti seti ñaroja, yiyijarã ĩna Judasre. ");
INSERT INTO myy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ito ĩna yija tʉocõri, Dios ya wijʉ niyeru cujiri rea bateyijʉ Judas. Ito yi, budicoayijʉ. Budi wacõri yucʉgʉjʉ mʉjayijʉ. Mʉjacõri ĩmasiti ĩ ya ãmʉmajʉ jũgʉbo cano yicõri quedi yoja godayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dios ya wijʉ niyeru cujiri ĩ rea batere mioyijarã paia ʉjarã. Itire ãmicõri ado bajiro yiyijarã: —Adi niyeru mani sĩarocʉre ĩ goticati waja ñacãre ñacʉ adiama. Sĩare waja mani waja yire ña. Ito bajiri Diore yiari masa ĩna niyeru sãri jedojʉ sãdo ma, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sĩgʉ̃re bajiro tʉoĩacõri, “Riri goje ñari sitajʉ waja yiana mani”, yi tʉoĩayijarã ĩna. “Iti sita ñaro yiroja gaje masare mani yujeroti sita”, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ito bajiri adi sita adi rʉmʉri cʉni, sĩare wajana ĩna waja yira sita wame cʉtia maji. ");
INSERT INTO myy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ito bajiro ĩna yija jane mejejʉ Diore goti ĩsiri masʉ Jeremías ñayorʉ ĩ ucare ado bajiro bajiadoja: “Treinta niyeru cujiri ñarise ãmicõri riri goje ñari sita waja yiyijarã ĩna, Dios ĩ ãmocãdo bajiroti. ‘Itocõti waja cʉtiami sĩgʉ̃ ʉ̃mʉgʉ̃’, yi tʉoĩayijarã Israel sita gãna”, yi ucañi Jeremías ñayorʉ. Ĩ ucado bajiroti rẽta adi. ");
INSERT INTO myy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesure ãmi wacõri Romano masa ʉjʉ Pilato wame cʉtigʉ tʉ ãmi ejayijarã ĩna. Ito bajiri ĩ riojo rʉ̃gõyijʉ Jesús. Ĩ Jesure ado bajiro seniĩayijʉ: —¿Mʉti ñati judio masa ʉjʉ? yiyijʉ ĩ Jesure. —Mʉ yiro bajiroti bajia, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ito ĩ yija tʉocõri, paia ʉjarã, judio masa bʉcʉrã cʉni, “Ĩti ñami ñeñaro yigʉ. Queno yigʉ meje ñami ĩ”, ĩna yibojaja, ĩnare cʉdi ñuca yibisijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ito bajiro Jesure ĩna bʉsituja tʉocõri, ado bajiro seniĩayijʉ Pilato Jesure: —Ito bajiro mʉre ĩna seti yija, ¿tʉobeati mʉ? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ito ĩ yibojarocati cʉdibisijʉ Jesús ĩre. Ĩ cʉdibeja tʉocõri, tʉoĩa oca jai rʉ̃gõyijʉ Pilato. Ito bajicõri ñe tʉoĩare mañijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pascua basa ñari rʉmʉre ado bajiro yisotiyijʉ romano masa ʉjʉ. Tubiara wijʉ ñarãre “Ĩre bure ãmoa gʉa”, ĩna yi besegʉre bucõasotiyijʉ ĩ, basa ñari rʉmʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Iti rʉmʉri tubiara wijʉ ñayijʉ sĩgʉ̃, masa jeyaro ĩna masi jedigʉ Barrabás wame cʉtigʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Masa ĩna minijua ñaroca ado bajiro seniĩayijʉ Pilato: —¿Ñimʉjʉare yʉ bucõare ãmoati mʉa? ¿Barrabásre, Jesucristo mʉa yigʉre bucõagʉ̃tite? yi seniĩayijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","“Jesure tʉo junisinicõri yʉre ĩsicã no cʉni”, yi tʉoĩa wacʉ ito bajiro yiyijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gãjerã ʉjarã rãca Pilato ĩ rujiroca ĩ manojo ĩre oca cõayijo: “Ñeñaro yibesa ĩre. Ñe seti macʉ ñami. Guijoro cãimʉ yʉ ĩ gaye. Ito bajiri bʉto oca jaia yʉ”, yi oca cõayijo iso, iso manʉjʉre. ");
INSERT INTO myy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Paia ʉjarã, judio masa bʉcʉrã cʉni, “Barrabásjʉare bucõa rotiya mʉa”, yiyijarã ĩna masare. “Ito yicõri Jesure sĩa rotiya mʉa”, yiyijarã ĩna masare. Ito bajiro ĩna yijare ito bajiroti tʉoĩayijarã masa cʉni. ");
INSERT INTO myy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ito ĩna yija bero masare mʉcana ado bajiro seniĩayijʉ ʉjʉ Pilato: —¿Nijʉare yʉ bucõare ãmoati mʉa? yi seniĩayijʉ Pilato ĩnare: —Barrabásjʉare mʉ bucõare ãmoa gʉa, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ito ĩna yija tʉocõri, ado bajiro ĩnare seniĩayijʉ ĩ: —¿No bajiro yigʉti yʉ Jesure, Cristo mʉa yigʉreama? yi seniĩayijʉ ĩ masare. Ito ĩ yija ĩna ñarocõti ado bajiro ĩre awasã cʉdiyijarã: —Yucʉtẽojʉ ĩre jaju sĩacõña mʉ, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ito ĩna yija tʉocõri: —¿Ñeonire ñeñaro yicati ãni? yiyijʉ Pilato ĩnare. Ito ĩ yibojarocati mʉcana tʉdi awasãyijarã ĩna: —Yucʉtẽojʉ jaju sĩacõña ĩre, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ito ĩna yija tʉocõri, “No robojʉa yi masibicʉja yʉ”, yi tʉoĩayijʉ Pilato. “Ĩna ãmoro bajiro yʉ yibeja, ĩnamasiti gãmeri birarã yirãji”, yi tʉoĩayijʉ Pilato. Ito bajiro tʉoĩacõri ide ãmi rotiyijʉ ĩ. Ito yicõri masa ĩna tiro riojo ãmo coecõri ado bajiro gotiyijʉ ĩ masare: —Ãni ñeñaro yibicʉre mʉa sĩaja, yʉre seti ma. Mʉareti seti ña, yiyijʉ ĩ masare. ");
INSERT INTO myy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ito ĩ yija tʉocõri, masa ñajediro ado bajiro ĩre cʉdi jediyijarã: —Gʉa, gʉa rĩare cʉni seti ñaro yiroja ĩre gʉa sĩaja, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ito yija bero Barrabásre bucõayijʉ Pilato. Ĩre bucõacõri ĩ ya surarare ĩsiyijʉ Pilato Jesure ĩna bajetoni, ito yicõri yucʉtẽojʉ ĩna jaju sĩatoni. ");
INSERT INTO myy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jesure ãmi wacõri ʉjʉ ya wijʉ ãmi ejayijarã ĩna. Surara jeyaro Jesure gãni bia rʉ̃gʉ̃yijarã. ");
INSERT INTO myy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ĩ sãñarise yutabuju ruacõri, ʉjʉ ĩ sãñarise sũari buju ĩre sãyijarã. ");
INSERT INTO myy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ito yicõri jota bedo ĩna menira bedo Jesure rijogajʉ jeoyijarã ĩna. Ito yicõri riojocadʉja ãmo jota jãi ĩsiyijarã. Ʉjʉ ĩ rʉcori jãi bajiri jãi ĩre ĩsiyijarã ĩna. Iti ĩre ĩsi tĩocõri ĩ riojo rijomunigãna ñini rũjũyijarã ĩna. Gaje ado bajiro ĩre aja tudiyijarã: —Judio masa ʉjʉ yoari catiba mʉ, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ito yicõri go ide ĩre eobate guyijarã ĩna. Ĩ rʉcori jãi ẽmacõri ĩ ya rijogajʉ jayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ito bajiro ĩre ja tudi tĩocõri ĩ ya yutabuju sũaro ruayijarã ĩna mʉcana. Ito yicõri ĩ yaro ñasʉoadojʉare sãyijarã. Yutabuju sã tĩocõri yucʉtẽojʉ jaju sĩarona ĩre ãmi wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cʉto sõjʉa ĩre ãmi warãjʉ sĩgʉ̃ Cirene gagʉ Simón wame cʉtigʉre bocayijarã ĩna. Ĩre bocacõri Jesús gajari tẽo gaja rotiyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ito baji warãjʉ Gólgota wame cʉtirijʉ ejayijarã ĩna. “Rijoga gõa iti ñarijʉ”, yireoni ña Gólgota yire. ");
INSERT INTO myy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ito ejacõri Jesure ʉyé ide jiarise wʉocõri ioyijarã ĩna. Itire idiĩacõri itocõ idi jidicãyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jesure yucʉtẽojʉ ĩna jaju tĩoja bero, “Ñimʉjʉa ĩ ya yutabuju bʉjaja tiana mani”, yirona gʉ̃ta ajerina rea ajeyijarã ĩna. Ito bajiro ĩna yija Diore goti ĩsiri masʉ ñayorʉ ĩ ucado bajiroti rẽtayijʉ. Ado bajiro ucayoñi ĩ. Tʉote: “Yʉ ya yutabujure ĩnamasi gãmeri batorona gʉ̃ta ajerina gãmeri rea ajecã ĩna”, yi ucayoñi Diore goti ĩsiri masʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ito bajiro aje tĩocõri ĩre code rujiyijarã surara. ");
INSERT INTO myy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesús ya rijoga weca rujajãi uca wõyijarã ĩna. “Adi seti ña ĩre”, yira jãi uca wõyijarã ĩna. “Ãniti ñami Jesús judio masa ʉjʉ”, yi wãñayijʉ iti jãijʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesús rãca jʉ̃arã riniri masa jaju ecoyijarã. Sĩgʉ̃re ĩ ya riojocadʉja, gãjire ĩ ya gãcodʉja jaju rʉ̃gõyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Masa ĩna rẽtaja, rijogari yureyure yi rẽtayijarã ĩna Jesure bʉsiturã. ");
INSERT INTO myy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ado bajiro yi aja tudiyijarã ĩna Jesure: —“Dios ya wire jore batecãcõri mʉcana ʉdia rʉmʉ beroti menicõgʉ̃ yigʉja yʉ”, mʉ yigʉ ñaja mʉmasiti mʉ ya rujʉre masogʉ̃ yigʉja mʉ. “Riti Dios Macʉ ña yʉ”, mʉ yijama, mʉmasiti yucʉtẽore rujigogʉ yigʉja mʉ, yi aja tudiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Paia ʉjarã, judio masa rotirise riasori masa, ĩna masa bʉcʉrã cʉni ito bajiroti Jesure aja tudi ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Gãjerãreama masobojañi. Ĩ ito bajibojagʉti ĩ ya rujʉreama maso masibeami ĩ. Judio masa ʉjʉ mʉ ñaja yucʉtẽore rujigogʉ yigʉja mʉ. Ito bajiro mʉ yija ticõri, mʉre tʉorʉ̃nʉrã yirãji gʉa. ");
INSERT INTO myy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Dios Macʉ ña yʉ. Ĩre tʉorʉ̃nʉa yʉ”, yicʉ mʉ. Ito bajiri mʉre ĩ maija ĩmasiti mʉre masogʉ̃ yiguĩji, yi aja tudiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jʉ̃arã ĩ rãca yucʉtẽojʉ jaju ecoana rãcati bʉsituyijarã Jesure. ");
INSERT INTO myy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ito yija ũmacañi riojo ñabojarocati rãitĩacoayijʉ ĩja. Ʉdiaji cõrecõ rãitĩa ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ito yija ñamica tres ñaroca sẽoro ado bajiro awasãyijʉ Jesús: —Elí Elí, ¿lama sabactani? yiyijʉ Jesús. “Dios yʉ Jacʉ, ¿no yija yʉre jidicãti mʉ?” yireoni ñayijʉ iti ĩ awasãrise. ");
INSERT INTO myy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Coriarã itijʉ ñana ĩ awasãja tʉocõri, ado bajiro yiyijarã ĩna: —Diore goti ĩsiri masʉ Elías ñayorʉre jigʉ yirʉ ĩ, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sĩgʉ̃ ĩre aja tudigʉ ũmaquedi wacõri ide udi ãmirisena ʉyé ide jiare weoyijʉ. Yucʉna sia wõcõri Jesús ya rise tʉ ñutubojayijʉ. Idibisijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ito bajiro ĩ yibojarocati ado bajiro yiyijarã gãjerã: —Yibesa mʉ ito bajicõato. Elías ñayorʉ ĩre masogʉ̃ ejaja tiana mani, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mʉcana sʉsari oca sẽoro awasãcõri ʉsi jediyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Itijʉ Dios ya wi yobiado saya webʉtiro ũmacʉ̃jʉana ñigã ruji wadicõri jacajʉ ñigã ruji ejacoayijʉ. Ito yicõri sita ʉeyijʉ. Gʉ̃tagãri cʉni wadicoayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Masari cumari cʉni janacoayijʉ. Ito bajicõri jãjarã Diore tʉorʉ̃nʉrã tʉdi catiyijarã. ");
INSERT INTO myy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ito bajiri masari cumajʉ ñana budiyijarã ĩna. Budicõri Jesús ĩ tudi catija bero Jerusalénjʉ Dios ĩ mairi cʉtojʉ wa ucuyijarã ĩna. Masa jãjarã tiyijarã ĩnare, ĩna wa ucuja. ");
INSERT INTO myy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesús yucʉtẽo ĩ yosaroca maji, surara ĩna ʉjʉ cʉni code ñayijarã maji. Sita iti ʉeja, ito yicõri gaje iti rẽtaja ticõri, bʉto güiyijarã ĩna. Ito bajiri ado bajiro yiyijarã: —Riti bajia, Dios Macʉti ñabojañi ãni, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jãjarã romia cʉni sõjʉ ti rʉ̃gõyijarã. Galilea sita Jesús ĩ ñaroca maji ĩre sʉyasʉoyijarã ĩna. Ito yicõri ĩre ejabʉasotiyijarã. ");
INSERT INTO myy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ĩna wato ñayijo María Magdalena, ito yicõri María Santiago, José jaco. Zebedeo rĩa jaco cʉni ñayijo. ");
INSERT INTO myy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iti rãio wadiroca sĩgʉ̃ José wame cʉtigʉ Arimatea gagʉ ejayijʉ. Niyeru jaigʉ ñayijʉ ĩ, ito yicõri Jesús rãca riasotigorʉ ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jesure yujerocʉ Pilatore senigʉ̃ wayijʉ José. Pilato tʉ ĩ ejaja ĩ seni ejaro bajiroti rotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ito ĩ yija tʉocõri, Jesús ya rujʉre rujiogʉ wayijʉ ĩ. Ĩre rujiocõri saya ʉeri manona ĩre gũmayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ito yicõri masari cuma mamajʉ gʉ̃ta toti ĩ menirajaʉjʉ ĩre cũyijʉ. Ito yicõri masari cuma soje gʉ̃tagã jajocana biacũ, wacoayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ito bajiro ĩ yiroca masari cuma riojo María Magdalena, ito yicõri gajeo María ruji codeyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gaje rʉmʉti ñayijʉ tujacãra rʉmʉ. Iti rʉmʉti paia ʉjarã, fariseo gaye tʉoĩarã cʉni Pilatore bʉsirã wayijarã. ");
INSERT INTO myy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ado bajiro ĩre gotiyijarã ĩna: —Gʉa ʉjʉ tʉoya: Jesús socari masʉ ĩ yicati gaye masi bʉjabʉ gʉa. “Ʉdia rʉmʉ bero mʉcana tʉdi caticʉja yʉ”, yiquĩ ĩ godaroto riojʉa. ");
INSERT INTO myy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ito bajiri ĩ ya masari cuma soje tʉ surara code roticõaña ĩ rãca riasotigoana ñami ĩ ya rujʉ rinime yirocʉ. Ĩ ya rujʉre ĩna ãmija, “Godarʉ ñabojagʉti mʉcana tʉdi caticoami”, yirã yirãji ĩna. Ito bajiro ĩna yija cajero rʉocato rẽto bʉsaro socarã yirãji ĩna, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ito ĩna yija tʉocõri, ado bajiro yiyijʉ Pilato: —Mʉare cʉni coderi masa ñacãma. Ĩnareti tirʉ̃nʉ rotiba. Queno ĩna tirʉ̃nʉja quena ñaro yiroja, yiyijʉ Pilato fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ito ĩ yija tʉocõri, Jesús ya masari cumare, coderi masare code roti cũyijarã ĩna. Ito yicõri, “Adi masari cumare jana yibesa mʉa”, yire gaye wame wõyijarã ĩna masari cumajʉ. ");
INSERT INTO myy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tujacãra rʉmʉ iti jediroca mʉcana moasʉora rʉmʉ iti busu mʉja wadiroca María Magdalena ito yicõri gajeo María, Jesús ya masari cumajʉ tirã wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ito ĩna waroca ñajasaroti sita ʉeyijʉ. Sĩgʉ̃ ángel ruji ejayijʉ. Ruji ejacõri masari cuma gʉ̃ta ĩna biabojaragare janayijʉ ĩ, ito yicõri itiga joere rujiyijʉ. ");
INSERT INTO myy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bʉjo ĩ borea yirisere bajiro yogʉ ñayijʉ ĩ, ito yicõri ĩ ya yutabuju cʉni bʉto botirise ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ĩre ticõri güirã ĩna ya rujʉri nʉrʉoyijarã coderi masa. Godacãna robo bajiro ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ito yija ángel ado bajiro yiyijʉ romiare: —Güibesa mʉa Jesús yucʉtẽojʉ ĩna jaju sĩarʉre ãmarã ya mʉa, yʉ tija. ");
INSERT INTO myy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mami ado. Ĩ goticãdo bajiroti tʉdi caticoañi. Ĩre cũgorajʉ tirã wadite mʉa. ");
INSERT INTO myy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Coji wasa ĩ rãca riasotigoanare gotitẽña. “Ĩ gotiado bajiroti mʉcana tʉdi caticoañi”, yiba. “Mani riojʉ bʉsa Galileajʉ warocʉ ñayijʉ ĩ. Itojʉ ĩre tirã yirãji mani”, yi gotiba mʉa Jesús rãca riasotigoanare, ya yʉ mʉare, yiyijʉ ángel. ");
INSERT INTO myy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ito ĩ yija tʉocõri, masari cuma budicõri güi ũmaquedi wayijarã ĩna. Güibojarãti bʉto wanʉre rãca Jesús rãca riasotigoanare gotirã wayijarã romia. ");
INSERT INTO myy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ĩna wabojaroca riti ĩnare seniĩa ejayijʉ Jesús. “¿Ñati mʉa?” ĩ yija tʉocõri, bʉto wanʉyijarã ĩna. Ito bajiri ĩre rʉ̃cʉbʉorã ĩ ya gʉbo wana cʉníyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ado bajiro yiyijʉ ĩ ĩnare: —Güibesa mʉa. Yʉ rãca riasoticãnare oca gotitẽña. “Galileajʉ wajaro. Itojʉ ĩre tirã yirãji mani”, yiba ĩnare, yiyijʉ Jesús romiare. ");
INSERT INTO myy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Romia ĩna wagoja bero masari cuma code ñana cʉtojʉ ejacõri paia ʉjarãre gotiyijarã iti rẽtado bajiroti. ");
INSERT INTO myy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Iti oca tʉocõri judio masa bʉcʉrã rãca bʉsirã wayijarã paia ʉjarã. Sĩgʉ̃re bajiro tʉoĩacõri coderi masa rʉori oca ĩna gotitoni ĩnare jairo niyeru ĩsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ado bajiro ĩnare rʉo rotiyijarã ĩna: —“Ñami gʉa canigoja bero Jesús rãca riasotigoana ĩ ya rujʉre ãmirã ejañi ĩna”, yi goti batoba mʉa masa jeyarore, yiyijarã paia ʉjarã ito yicõri judio masa bʉcʉrã cʉni. ");
INSERT INTO myy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mʉa rʉo gotirise ʉjʉ ĩ tʉo masija gʉamasiti mʉare bʉsi queno ĩsirã warã yirãji, yiyijarã ĩna coderi masare. ");
INSERT INTO myy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iti niyeru boca ãmi tĩocõri, ĩnare ĩna rotiro bajiroti rʉo goti ucurã wayijarã ĩna. Ito bajiri adi rʉmʉri cʉni, “Tʉdi catigʉ meje yiñi Jesús. Ĩ rãca riasotiri masa rinirã yiñi ĩna”, yire gaye bʉsiama judio masa adi rʉmʉri cʉni. ");
INSERT INTO myy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesús tʉdi catire, romia ĩna gotija tʉocõri, Galileajʉ wacʉ gʉa. “Ito gʉ̃tagʉ̃ joejʉ bocatiba mʉa”, gʉare ĩ yiadojʉ wacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Itojʉ ejacõri Jesure ticʉ gʉa. Ito bajiri ĩre rʉ̃cʉbʉorã wanʉcʉ gʉa. Coriarã, “Ĩ meje ñaguĩji”, yi tʉoĩacã ĩna. ");
INSERT INTO myy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ito yija ado bajiro gʉare yiquĩ Jesús: —Ũmacʉ̃jʉ adi tutijʉ cʉni yʉ rotire gaye jeyaro jidicãmi yʉ Jacʉ Dios yʉre. ");
INSERT INTO myy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Masa jeyarore oca goti ucurã, oca goti ucutẽña mʉa. Yʉ ya oca tʉorʉ̃nʉroca yiba ĩnare. Yʉre ĩna tʉorʉ̃nʉja ticõri, yʉ Jacʉ wame, Espíritu Santo wame, yʉ wame rãca ĩnare idé guba mʉa. ");
INSERT INTO myy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jeyaro yʉ rotirise ñarocõti ĩna cʉditoni ĩnare riasoba. “Co rʉmʉ rʉyabeto mani rãca ñasotigʉ yiguĩji Jesús. Adi macãrʉcʉ̃ro iti jediroto riojʉajʉ mani rãca ñasotigʉ yiguĩji ĩ”, yi tʉoĩama mʉa, yiquĩ Jesús gʉare. Itocõ ña.");
INSERT INTO myy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo oca mʉare gotigʉ ya yʉ. Ĩti ñami Dios Macʉ. Ito yicõri ado bajiro ñasʉoa ĩ oca quenarise gotire gaye. ");
INSERT INTO myy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jane mejejʉ sĩgʉ̃ Diore goti ĩsiri masʉ ñayijʉ. Isaías wame cʉtiyijʉ ĩ. Dios ĩ Macʉre ĩ bʉsigore ucañi Isaías ñayorʉ. Ado bajiro ucayoñi ĩ: Tʉoya yʉ Macʉ mʉ. Mʉ riojʉa gãjire cõagʉ̃ yigʉja yʉ. Juan wame cʉtigʉ yiguĩji ĩ, yʉ oca gotiri masʉ. Mʉ ejaroto riojʉa masare gotigʉ yiguĩji, mʉ ejaroti gaye ĩna bocatitoni, yiyijʉ Dios ĩ Macʉre. ");
INSERT INTO myy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yucʉ manojʉ masare jigʉ yiguĩji Juan. Ito yicõri sẽoro ado bajiro ĩnare gotigʉ yiguĩji: “Ña yucãña mʉa. Nocõ mejeti mani Ʉjʉ ejagʉ yiguĩji. Ñeñarise yimenati quenarise riti tʉoĩaña mʉa”, yigʉ yiguĩji Juan, yiyijʉ Dios ĩ Macʉre, yi ucañi Isaías ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Ado bajiroti rẽtayijʉ ĩ ucare. Yoari ĩ ucaja bero yucʉ manojʉ ñasotiyijʉ Juan. Ĩ sãñari buju camello joa ñayijʉ. Ito yicõri ĩ wẽñuri wiro wecʉ wiro ñayijʉ. Rujiro ñimia ñayijarã ĩ bana. Ito yicõri searã beroa ide ñayijʉ ĩ ya bare. Ĩre tʉorã wadiyijarã masa Judea sita gãna. Jerusalén wame cʉtiri cʉto gãna cʉni ĩre tʉorã wadiyijarã ĩna yucʉ manojʉre: “Mʉa ñeñaro yirise jidicãcõri mʉcana tʉdi ʉyabesa. Tʉdi tʉoĩa ʉya yibesa. Mʉa ito yija ticõri, ñeñaro mʉa yirise ãcabojogʉ yiguĩji Dios. Ito mʉa yija bero idé gu rotiba mʉa”, yiyijʉ Juan masare. Ito yija masa ñeñaro ĩna yirise Diore ĩna gotija bero Jordán wame cʉtirisajʉ ĩnare idé guyijʉ Juan. ");
INSERT INTO myy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ito yicõri ado bajiro masare riaso bʉsiyijʉ ĩ: —Yʉ bero gãji wadigʉ yiguĩji. Yʉ rẽto bʉsaro masigʉ̃ ñami ĩ. Ĩre bajiro bajigʉ meje ña yʉama. Yʉ rẽtoro quenagʉ̃ ĩ ñajare ĩ rãca corocõ ñado ma yʉ. Ito bajiro quenagʉ̃ meje ñacõri ĩ ya gʉboco õja masibea yʉ. ");
INSERT INTO myy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Diore mʉa tʉorʉ̃nʉja ticõri, idena mʉare gubʉ yʉ. Yʉ bero ejagʉ ĩama Dios ya ʉsi mʉare queo sãgʉ̃ yiguĩji, yiyijʉ Juan masare. ");
INSERT INTO myy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Iti rʉmʉriti Galilea sita Nazaret wame cʉtiri cʉtore wacoayijʉ Jesús. Wacõri Juan tʉ ejayijʉ Jesús. Ĩ ejaroca Jordán wame cʉtirisajʉ ĩre idé guyijʉ Juan. ");
INSERT INTO myy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús riaca maja rʉ̃gʉ̃cõri ĩ ti mʉoja, macãrʉcʉ̃ro soje janayijʉ. Ũmacʉ̃jʉ ĩ ti mʉorocati bujare bajiro bajigʉna quedi sãja wadicõri, Jesús joe quedi jeayijʉ Espíritu Santo. ");
INSERT INTO myy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ito bajija bero macãrʉcʉ̃rojʉ oca ruyuyijʉ. Ado bajiro gotiyijʉ iti: —Yʉ Macʉ ña mʉ, yʉ maigʉ̃. Bʉto wanʉa yʉ mʉre, yi ruyuyijʉ oca. ");
INSERT INTO myy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Itijʉti yucʉ manojʉ Jesure ãmi wayijʉ Espíritu Santo. ");
INSERT INTO myy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Itojʉ ñayijʉ Jesús jʉ̃arã masacõ rʉmʉri. Itojʉ Jesús ĩ ñaroca, “¿Diore riti cʉdigʉ yiguĩjida Jesús?” yirocʉ ĩre ʉsirio codegʉ ejayijʉ Satanás wame cʉtigʉ. Ito ĩ yibojarocati Diore cʉdibiticõ yibisijʉ Jesús. Gãjerona jeyaro wato ñayijʉ Jesús. Ito yicõri Dios ñaro gãna ángel mesa ĩre codeyijarã. ");
INSERT INTO myy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Iti rʉmʉri Juanre ĩna tubiaja bero Galileajʉ wacoayijʉ Jesús. Galileajʉ ejacõri masare Dios oca quenarise riasoyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ado bajiro yiyijʉ Jesús masare: —Itocõ ña wajʉ ĩja. Jabeto rʉya ĩre tʉorʉ̃nʉrãre Dios ĩ miojuroto. Ito bajiri ñeñaro mʉa yirisere tʉoĩa bojori bʉjacõri itire jidicãña mʉa. Dios oca quenarisejʉa riti tʉorʉ̃nʉña mʉa, yi riasoyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Itajura Galilea wame cʉtirita tʉnima rʉ̃ja wayijʉ Jesús. Ito rʉ̃ja wacʉjʉ Simón ito yicõri ĩ ocabaji Andrésre cʉni ti bʉjayijʉ Jesús. Wai jori masa ñayijarã ĩna. Yori yucʉrina wai waya ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ito yija ado bajiro yiyijʉ Jesús ĩnare: —Yʉ rãca waya. Masare jirã yirãji mʉa, Diore ĩna masitoni, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ito ĩ yirocati yori yucʉri cũcõri ĩ rãca sʉya wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ito yija ito sõjʉa bʉsa wa remoyijʉ Jesús. Jabeto wa remocõri Santiago, ĩ ocabaji Juanre cʉni ti bʉjayijʉ Jesús. Zebedeo rĩa ñayijarã ĩna. Cumajʉ ĩna ya yori yucʉri sia queno sãñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ĩnare ticõri ĩnare jiyijʉ Jesús. Cumajʉti ĩna jacʉ Zebedeore cũ wayijarã ĩre ejabʉari masare cʉni. Ito bajiri Zebedeo rĩa Jesús rãca wacoayijarã ĩja. ");
INSERT INTO myy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wacõri Capernaum cʉtojʉ ejayijarã ĩna. Co rʉmʉ judio masa ĩna tujacãri rʉmʉ minijuara wijʉ sãjayijʉ Jesús. Ito sãjacõri masare riasosʉoyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ʉjʉ ñasagʉ robo bajiro masare riasoyijʉ Jesús. Judio masa rotirise riasori masare bajiro meje riasoyijʉ Jesús. Ĩna rẽto bʉsaro queno riaso masiyijʉ ĩ. Ito bajiri Jesús ĩ riasorise tʉocõri ʉcayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Minijuara wijʉ ʉ̃mʉgʉ̃ sĩgʉ̃ ñayijʉ ĩ ya ʉsijʉ rʉ̃mʉ́ sãñagʉ̃. Ado bajiro awasãyijʉ ĩ: ");
INSERT INTO myy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Mʉre ti masia gʉa. Jesús ña mʉ, Nazaret wame cʉtiri cʉto gagʉ ña mʉ, yiyijʉ rʉ̃mʉ́ sãja ecorʉ. ¿No yigʉ yigʉjada mʉ gʉare? ¿Gʉare bucõarocʉ ejari mʉ? Mʉre ti masia gʉa. Dios queno ĩ cõarʉ ña mʉ. Dios ĩ maigʉ̃ ña mʉ, yi awasãyijʉ rʉ̃mʉ́ sãja ecorʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ito yija Jesús rʉ̃mʉ́re bʉsi rotibisijʉ: —Bʉsibesa mʉ, ito yicõri budigoya mʉ ĩ ʉ̃mʉgʉ̃re, yi tudiyijʉ Jesús rʉ̃mʉ́re. ");
INSERT INTO myy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ʉ̃mʉgʉ̃re ʉsi jedi quedicõri ĩ tunuroca yiyijʉ rʉ̃mʉ́. Ito yicõri rʉ̃mʉ́ bʉto awasãcõri masʉre budigoyijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ito bajija ticõri, masa ñarocõti ʉcayijarã. Ito yicõri ĩnamasiti gãmeri seniĩayijarã: —¿Ñe ñatibeti? yiyijarã ĩna. ¿Ñe ñatibeti mame ĩ riasorise? Ãni ʉ̃mʉgʉ̃ rʉ̃mʉ́are bucõare bʉto masiami. Ito bajiri yiro robo cʉdiama rʉ̃mʉ́a ĩre, yiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nocõ mejeti Jesús ito ĩ yija bero Galilea sita gãna ñarocõti masi jedicoayijarã. ");
INSERT INTO myy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ito yija Jesús budi wayijʉ minijuara wijʉ. Santiago ĩ ocabaji Juan rãca cʉni wayijʉ Jesús. Minijuara wijʉ budi wacõri Simón ya wijʉ ejayijarã ĩna. Ĩ ocabaji Andrés rãca ĩna jʉ̃arã ya wi ñayijʉ iti wi. ");
INSERT INTO myy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wijʉ ĩna sãja ejaroca Jesure gotiyijarã ĩna: “Simón mañicõ cõgõ yamo. Rujʉ yarise cõ yosamo iso”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ito yija Jesús iso tʉ eja rʉ̃gʉ̃cõri ĩ ya ãmona tʉ̃a jõrojoyijʉ. Ito ĩ yirijʉti iso rujʉ yarise jedicoayijʉ. Ito bajiri iti jediroca masare eca bocasʉoyijo iso. ");
INSERT INTO myy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Iti ñamica rãiocũroti cõrãre, ĩna ya ʉsijʉ rʉ̃mʉ́ sãñarãre cʉni Jesús tʉ ãmi ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iti cʉto gãna ñarocõti soje tʉ minijuayijarã. ");
INSERT INTO myy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jeyaro ñarise cõrãre yisioyijʉ Jesús. Ito yicõri ĩna ya ʉsijʉ rʉ̃mʉ́ sãñarãre rʉ̃mʉ́a bucõayijʉ Jesús. Rʉ̃mʉ́a ĩre ĩna ti masija ticõri, ĩnare bʉsi rotibisijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Busucũro iti rãitĩaroca riti masa manojʉa wayijʉ Jesús. Ĩ Jacʉ Dios rãca bʉsirocʉ wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ito yija Simón ĩ baba mesa rãca Jesús manija ticõri, ĩre ãmarã wayijarã. ");
INSERT INTO myy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ĩre ti bʉjacõri ĩre bʉsiyijarã ĩna: —Masa jeyaro mʉre ãmama, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ito ĩna yibojarocati ado bajiro cʉdiyijʉ Jesús ĩnare: —Ita, gaje cʉtojʉ wato mani. Itojʉ Dios oca quenarise gotito mani. Itire yiari wadicʉ yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ito bajiri Galilea sitajʉa wayijʉ Jesús. Galilea sitajʉ ejacõri Galilea sita ñari cʉtorijʉ minijuara wirijʉ riaso ucuyijʉ Jesús. Ito yicõri ĩna ya ʉsijʉ rʉ̃mʉ́a sãjanare rʉ̃mʉ́are bucõayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Rujʉ cami jogagʉ ejayijʉ Jesús tʉjʉ. Ĩ tʉjʉ ejacõri ĩ ya rijomunigãna Jesús riojo ñini rũjũyijʉ. Ito bajiro rujicõri ado bajiro josayijʉ Jesure: —Mʉ yʉre yisio ãmojama, yʉre yisiogʉ ya mʉ, yiyijʉ rujʉ cami jogagʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ito ĩ yija tʉocõri, ĩre ti maiyijʉ Jesús. Ito bajiri ĩre moaĩacõri ado bajiro yiyijʉ Jesús ĩre: —Ãmoa yʉ. Ito bajiri mʉre yisiogʉ ya yʉ, yiyijʉ Jesús cami jogagʉre. ");
INSERT INTO myy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ito ĩ yirocati ĩ ya rujʉ cami jogarise yati jedicoayijʉ ĩja. Quenari rujʉ, rujʉ cʉticoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iti yatija ticõri, bʉto ĩre goticõri wa rotiyijʉ Jesús cami jogagʉre: ");
INSERT INTO myy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Tʉoya mʉ. Yʉ mʉre yisiorisere goti batobesa gãjerãre. Coji wasa. Mʉ ya rujʉre ĩoña paire. Ĩo tĩocõri Moisés ñayorʉ rotiado bajiroti waja yiya. Ito bajiro mʉ yija ticõri, “Ĩ ya rujʉ cami jogarise yati jedicoajʉ”, yi masirã yirãji masa mʉre, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ito bajiro, “Goti batobeja”, ĩ yibojarocati jeyaro masare goti batoyijʉ ĩ: “Yʉ ya rujʉ cami jogarisere yisioquĩ Jesús”, yiyijʉ. Ito bajiro ĩ yija tʉocõri, Jesús tʉ jãjarã masa minijuayijarã, ĩre ti ãmorã. Ito bajiri reco wa ucubisijʉ Jesús masa ĩna tiro riojo. Masa manojʉ ña ucuyijʉ Jesús ĩja. Ito ĩ yibojarocati jãjarã masa ejayijarã mʉcana ĩ tʉ, ĩre tʉo ãmorã. ");
INSERT INTO myy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yoa bʉsarijʉ Capernaumjʉ tʉdi ejayijʉ Jesús mʉcana. “Wijʉ ñaguĩji Jesús”, masa ĩna yija tʉocõri, ĩ tʉ jãjarã masa minijuayijarã. ");
INSERT INTO myy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ito bajiri wi daja rẽtacoayijʉ. Dijʉ rʉ̃gõrajaʉ mañijʉ. Soje cʉni daja rẽtacoayijʉ. Dios oca masare riasoyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ito bajiro masare ĩ riasoroca ʉ̃mʉa jʉariarã ejayijarã rudurʉre ãmi ejarã. ");
INSERT INTO myy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Masa jãjarã ñarojʉ rudurʉre ãmi ejabojayijarã ĩna Jesús tʉjʉ. Ito bajiri wi tutu joejʉ ĩre ãmi mʉja wayijarã ĩna. Ito yi, Jesús rʉ̃gõro weca soje cudayijarã ĩna. Ito yicõri rudurʉre ĩ ya camana jidi rujioyijarã ĩna Jesús tʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","“Yʉre queno tʉorʉ̃nʉama ĩna”, yi ti masiyijʉ Jesús ĩnare. Ito bajiri rudurʉre ado bajiro yiyijʉ Jesús: —Macʉ, mʉ ñeñaro yirise coecoajʉ mʉre, yiyijʉ Jesús rudurʉre. ");
INSERT INTO myy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ito ĩ yirocati, judio masa rotirise riasori masa tʉoĩa rujiyijarã. Ĩnamasijʉa ado bajiro tʉoĩayijarã: ");
INSERT INTO myy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿No yija ito bajiro bʉsiati ãni ʉ̃mʉgʉ̃? Diore ñeñaro bʉsiami. Gãjerã ñeñaro yirisere coe masimenaji. Dios sĩgʉ̃ti ñaguĩji itioni ñeñaro yirisere coe masigʉ̃”, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ito ĩna tʉoĩaroca Jesumasiti ĩnare tʉoĩa masicõyijʉ. Ito bajiri ado bajiro ĩnare seniĩayijʉ ĩ: —¿No yirã ito bajiro mʉa ya ʉsijʉ tʉoĩati mʉa? ");
INSERT INTO myy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿No bajiro rudurʉre yʉ yija quenati mʉare? “Mʉ ñeñaro yirise coecoajʉ”, ¿yʉ yija quena ñarojada mʉa tʉoĩaja? “Wʉmʉña. Mʉ ya cama ãmi wasa”, ¿yʉ yija quena ñarojada? ¿Disejʉa ñati josasabiti mʉa tija? ");
INSERT INTO myy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Masa Rĩjorʉ ña yʉ. Yʉ masirise mʉare ĩogʉ̃ ya yʉ. “Adi sitajʉ masa ĩna ñeñaro yirisere coe masigʉ̃ ñami Masa Rĩjorʉ”, mʉa yi masitoni, yʉ masirise mʉare ĩogʉ̃ ya yʉ, yiyijʉ Jesús ĩnare. Ito yicõri ado bajiro rudurʉre yiyijʉ Jesús: ");
INSERT INTO myy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Wʉmʉña. Mʉ ya cama ãmiña. Mʉ ya wijʉ tʉdi wasa, yibʉ yʉ mʉre, yiyijʉ Jesús rudurʉre. ");
INSERT INTO myy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ito bajicõri rudurʉ wʉmʉyijʉ ĩ ya cama ãmigʉ̃. Masa jãjarã tiro riojo wʉmʉ rʉ̃gʉ̃, budi wayijʉ macʉ̃jʉ. Ito bajiri masa ñajediro tʉo ʉcayijarã ĩja. Ito bajiri Diore rʉ̃cʉbʉorã ado bajiro bʉsiyijarã masa: —Quenagʉ̃guti ñami Dios ĩja. Ado bajirisere tiĩabiticʉ mani, yiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mʉcana tʉdi wayijʉ Jesús itajura tʉnimajʉ. Jãjarã masa minijuayijarã ĩ tʉ. Ĩna ejaja ticõri, Dios oca ĩnare riasoyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ito rẽta wacʉjʉ Leví wame cʉtigʉre ti bʉjayijʉ Jesús. Alfeo macʉ ñayijʉ ĩ. Romano masa ʉjarã ye niyeru senirijʉ rujiyijʉ Leví. Ĩnare yiari waja seni ĩsigʉ̃ yiyijʉ Leví. Ĩre ti bʉjacõri ado bajiro bʉsiyijʉ Jesús ĩre: —Yʉ rãca waya mʉ, yiyijʉ Jesús ĩre. Ito ĩ yija tʉocõri, wʉmʉ rʉ̃gʉ̃yijʉ Leví. Ito yicõri Jesure sʉya wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Barajʉ ejaroca Leví ya wijʉ bayijʉ Jesús. Gãjerã jãjarã Jesús rãca rujiyijarã. Ʉjarãre yiari waja seni ĩsiri masa, ñeñaro yiri masa cʉni, ito yicõri Jesús rãca riasotirã jãjarã rujiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesús gãjerã rãca ĩ ba rujiroca fariseo gaye tʉoĩarã, judio masa rotirise riasori masa cʉni ĩnare tiyijarã. Judio masa ñayijarã ĩna. Ñeñaro yirã rãca Jesús ĩ ba rujija ticõri, Jesús rãca riasotirãre ado bajiro seniĩayijarã fariseo gaye tʉoĩarã: —¿No yija ʉjarãre yiari waja seni ĩsiri masa rãca, ñeñaro yirã rãca bati mʉare riasogʉ? yiyijarã ĩna ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ĩna ito bajiro bʉsija tʉocõri, ado bajiro cʉdiyijʉ Jesús ĩnare: —Queno cati quenarãma ʉco masʉre ãmado ma. Cõri masajʉa ñama ʉco masʉre ãmorã. Queno ñari masare jigʉ meje wadibʉ yʉ. Ñeñaro yirãre jigʉ wadibʉ yʉ, yiyijʉ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Co rʉmʉ Juan idé guri masʉ rãca riasotirã, fariseo gaye tʉoĩarã cʉni Diore tʉoĩa ãmorã babisijarã ĩna. Ito bajiro ĩna babeja ticõri, ado bajiro Jesure seniĩayijarã gãjerã: —Juan rãca sʉyarã Diore tʉoĩa ãmorã babeama ĩna. Fariseo gaye tʉoĩarã rãca sʉyarã cʉni babeama ĩna. ¿No yija mʉ rãca riasotirãma batĩñati ĩna? yiyijarã ĩna Jesure tudirã. ");
INSERT INTO myy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ĩna ito yijare cʉdiyijʉ Jesús: —Queno tʉo masibea mʉa. Queno tʉo masiña mʉa itire. Ado bajiro bajia iti. Ãmo siare gaye tijaro yirona ĩna ji ñucana manojo cʉtirocʉ ĩ ñajare ĩ rãca barã yirãji maji. ");
INSERT INTO myy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Co rʉmʉ ejaro yiroja ĩre ĩna ñia wari rʉmʉ. Iti rʉmʉ ñaro yiroja ĩja ĩna babiti rʉmʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Saya bʉcʉro iti tadija, mamarona sere wõmenaji mani. Mamarona mani sere wõja tʉ̃atu wato bʉcʉro tadiroja. Ito bajicõri jaja goje bʉsa tadi waroja ĩja. Mame oca yʉ riasorise cʉni bʉcʉrã oca rãca tʉoĩa wisabesa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mʉcana ado bajiro gotiyijʉ Jesús: —Ʉyé mame ide wecʉ wiro baju bʉcʉ baju jiomenaji mani. Bʉcʉ baju mani jiojama wiro cuducoaro yiroja. Ito yicõri idire, wiro cʉni jʉajijʉ godaroja. Ito bajiro ʉyé mame ide wecʉ wiro mama bajuna jiore ñaroja. Ito yicõri ʉyé ide, wecʉ wiro cʉni corocõ ñaro yiroja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Judio masa ya tujacãra rʉmʉ wesecajʉ wayijʉ Jesús ĩre sʉyarã rãca. Ito ĩna waroca riti Jesús rãca sʉyarã weseca gaye ote beja ãmiyijarã. Itire wirori sĩguẽ batecõri bayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ito ĩna yija ticõri, fariseo gaye tʉoĩarã ado bajiro seniĩayijarã Jesure: —Tujacãra rʉmʉ moare ma. Tite mʉ. Mʉ rãca riasotirã weseca gaye ote ĩna beja baja, moado bajiro yama ĩna. Ito bajiro ĩna yija bʉcʉrã oca tʉorʉ̃nʉbeama ĩna, yiyijarã fariseo gaye tʉoĩarã. ");
INSERT INTO myy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ito bajiro ĩna yibojarocati ado bajiro cʉdiyijʉ Jesús: —Co rʉmʉ David ñayorʉ ĩ rãca gãna ñiocõ wana ĩna yigore, ¿Dios oca tuti tiĩabiticati mʉa? Ado bajiro bajiyijʉ iti oca: ");
INSERT INTO myy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David Dios ya wi wayijʉ, paia ʉjʉ Abiatar wame cʉtigʉ ĩ ñaroca. Ñiocõcõri Dios ya wi sãjacõri naju ñasarise bayijʉ David. Diore naju cũ ĩsire ñayijʉ iti. Ito yija Diore ĩsiado bajiro bajiyijʉ iti. Paia ʉjarã riti ĩna barise ñayijʉ iti naju. David itire bacõri ĩ rãca gãnare cʉni ecayijʉ, yiyijʉ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ito yicõri gaje ado bajiro gotiyijʉ Jesús ĩnare: —Dios cũyijʉ tujacãra rʉmʉ masa yeroti yiari. Masare ĩ rujeoroto riojʉa tujacãra rʉmʉ menibisijʉ Dios. Masa rujeoja berojʉare tujacãra rʉmʉ meniyijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ito bajiri yʉ ña tujacãra rʉmʉ roti masigʉ̃. Yʉ ña Masa Rĩjorʉ. Ito yicõri tujacãra rʉmʉ tirʉ̃nʉgʉ̃ ña yʉ, yiyijʉ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mʉcana minijuara wijʉ sãjayijʉ Jesús. Itojʉ ñayijʉ ʉ̃mʉgʉ̃ ĩ ya ãmo digarʉ. ");
INSERT INTO myy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseo gaye tʉoĩarã ado bajiro Jesure ti tʉoĩayijarã ĩna: “Jane tujacãra rʉmʉ ñabojarocati, ¿ãni ãmo digarʉre yisiogʉ yiguĩjida Jesús?” yi tiyijarã ĩna. “Ito bajiro ĩ yija, ‘Seti ña ĩre. Ñeñaro yami’, yirã yirãji mani”, yi tʉoĩa rujiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ito bajiro ĩna tʉoĩa rujirocati ado bajiro yiyijʉ Jesús ãmo digarʉre: —Wʉmʉña. Yʉ tʉ eja rʉ̃gʉ̃ña, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ito yicõri ito tʉ ñarãre ado bajiro seniĩayijʉ Jesús: —¿No bajiro manire cũyijari Dios tujacãra rʉmʉ mani yiroti? ¿Quenarise, ñeñarise ito yicõri cõrãre mani yisioroti, gaje mani yisiobeja, disejʉa quenati? yiyijʉ Jesús ĩnare. Ito ĩ yija cʉdire meje tʉoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ito bajiri ãmo digarʉre ĩna ti maibeja ticõri, ĩnare junisini bʉjatobiti tiyijʉ Jesús. Ito yija ãmo digarʉre ado bajiro bʉsiyijʉ Jesús: —Mʉ ya ãmo ñu joya mʉ, yiyijʉ Jesús ĩre. Ito ĩ yija tʉocõri, ĩ ya ãmo ñu joyijʉ ĩ. Ito yijare ĩ ya ãmo quenacoayijʉ mʉcana. ");
INSERT INTO myy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ito yija fariseo gaye tʉoĩarã budi wayijarã Herodes ĩ ñarã rãca bʉsirona. “¿No bajiro Jesure sĩarʉjati?” yi gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ito yija bero Jesuama wacoayijʉ ĩ rãca riasotirã rãca itajura tʉnimajʉ. Galilea gãna masa jãjarã sʉya wayijarã ĩre. ");
INSERT INTO myy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","“Tiyamani jaje ĩoami Jesús”, masa ĩna yija tʉocõri, jãjarã masa Jesús tʉ ejayijarã. Ĩna ñayijarã Judea gãna, Jerusalén gãna, Idumea gãna, Jordán sidʉja gãna, Tiro gãna ito yicõri Sidón gãna. Ĩre tirona ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jãjarã cõrãre Jesús ĩ yisioja tʉocõri, masa jeyaro ĩre moaĩa ãmoyijarã ĩna. Ito bajiri ĩ rãca riasotirãre ado bajiro rotiyijʉ Jesús: “Cuma rʉco yucãma mʉa. Masa jãjarã yʉre ĩna gãni biaja, cumajʉ sãjarocʉ ya yʉ”, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ĩna ya ʉsijʉ rʉ̃mʉ́ sãñarã Jesure ticõri ĩ riojo rijomunigãna ñini rũjũcõri awasãyijarã ĩna: —Mʉti ña Dios Macʉ, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ito bajiro ĩna yija tʉocõri: “Ito bajiro masare goti batobesa mʉa”, yiyijʉ Jesús ĩna ya ʉsijʉ rʉ̃mʉ́ sãñarãre. ");
INSERT INTO myy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ito bero tʉriajʉ maja wacõri, ĩ ãmorãre bese jiyijʉ Jesús. Ito bajiri ĩ tʉ ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jʉa gʉbojeno ñarãre riti jiyijʉ ĩ. Ĩ rãca ñaronare riti jiyijʉ ĩ. Ado bajiro ĩnare gotiyijʉ Jesús: “Yʉ ya oca goti ucurã ñarã yirãji mʉa. Ito yicõri masare riaso ucurã ñarã yirãji mʉa”, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","“Yʉ masirise mʉare ĩsigʉ̃ ya yʉ, rʉ̃mʉ́a sãñanare rʉ̃mʉ́are mʉa bucõatoni”, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ãna ñama jʉa gʉbojeno ñarã Jesús ĩ beseana: Simón wame cʉtigʉre gaje wame wõyijʉ Jesús. Ito bajiri Simón Pedro wame cʉtiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Gãjerã ñayijarã Santiago, ĩ ocabaji Juan, Zebedeo rĩa ñayijarã ĩna. Ĩna jʉ̃arãre Boanerges wame yiyijʉ Jesús. Ĩna ocana yijama, “Bʉjo Rĩa”, yireoni ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Gãjerã ñayijarã: Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago, Alfeo macʉ ñayijʉ ĩ Santiago, ito yicõri ñayijarã Tadeo, Simón celote gaye tʉoĩagorʉ cʉni. ");
INSERT INTO myy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ito yicõri gãji Judas Iscariote ñayijʉ. Gãjerã Jesure ĩna ñiatoni gotiri masʉ ñayijʉ ĩ. Itocõ ñayijarã ĩ oca goti ucujaro yirocʉ Jesús ĩ cũana. ");
INSERT INTO myy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ĩnare bese tĩocõri, ĩ rãca riasotirã rãca wijʉ tʉdi wayijʉ Jesús. Mʉcana masa jãjarã minijuayijarã ĩna tʉ. Ito bajiri ba masia mano yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ado bajiro yiyijarã masa Jesure: “Jesús queno tʉoĩabeami ĩja. Mecʉri masʉ ñami ĩja”, yiyijarã ĩna. Itire tʉocõri Jesús ñarã ĩre jirã ejayijarã. ");
INSERT INTO myy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Judio masa rotirise riasori masa Jerusalén gãna ado bajiro yiyijarã ĩna cʉni: —Ĩ ya ʉsijʉ Beelzebú rʉ̃mʉ́a ʉjʉ sãñagʉ̃ ñami ĩ. Ito bajiri Beelzebú ĩ masirisena rʉ̃mʉ́a sãñanare rʉ̃mʉ́are bucõami Jesús, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ito ĩna yija tʉocõri, ĩnare jiyijʉ Jesús. Goti masiore ocana ĩnare gotirocʉ jiyijʉ: —Gãji ya ʉsijʉ rʉ̃mʉ́ ĩ sãñaja, ¿no bajiro ĩmasiti ĩre budigoguĩjida? Budigobiquĩji ĩ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","’Co cʉto gãna masa ĩna gãmeri jaja, yoari ñamenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Masa co wi gãna, sĩgʉ̃re bajiro ĩna tʉoĩabeja, yoari ñamenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Rʉ̃mʉ́a ʉjʉ Satanás wame cʉtigʉ ricati ĩ gotija, ito yicõri ĩmasiti ricati ĩ tʉoĩaja ña masibiquĩji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ñimʉjʉa guamʉ ya wi sãjacõri ĩ ya gajeoni ẽmabiquĩji. Cajero ĩre siacõri, ito berojʉa ĩ ya gajeoni ẽmaroja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Gaje ado bajiro yiyijʉ Jesús: —Riti mʉare gotia yʉ. Masare ñeñaro ĩna yirise, ñeñarise ĩna bʉsija cʉni, ãcabojo masiami Dios. ");
INSERT INTO myy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ito bajibojarocati Espíritu Santore masa ĩna bʉsituja, iti ñeñaro ĩna yirise ãcabojobiquĩji Dios. Iti seti sʉsabetoja ĩnare, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Ĩ ya ʉsijʉ rʉ̃mʉ́ sãñagʉ̃ ñami”, ĩre ĩna yijare, ito bajiro yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ito yija ejayijo Jesús jaco, ĩ ocabajirã rãca. Ejabojarãti macʉ̃jʉ tujayijarã ĩna. Macʉ̃jʉ ñacõri Jesure ji ñucayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesús tʉ ruji gãnirã ĩre gotiyijarã, “Mʉ jaco ejamo”, yirona: —Mʉ jaco, mʉ ocabajirã cʉni macʉ̃jʉ ñama ĩna. Mʉre ti ãmoama ĩna, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ito ĩna yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —¿Ñimo ñati yʉ jaco? ¿Noa ñati yʉ ocabajirã? yiyijʉ Jesús ĩ tʉ rujirãre. ");
INSERT INTO myy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ĩ tʉ rujirãre ticõri ado bajiro gotiyijʉ Jesús ĩnare: —Mʉati ña yʉ ocabajirã. Ito yicõri mʉati ña yʉ jaco, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","No Dios rotirise cʉdigʉti ĩ ñami yʉ ocabaji, yʉ ocabajio, ito yicõri yʉ jaco cʉni, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mʉcana tʉdi riasoyijʉ Jesús itajura tʉnimajʉ. Masa jãjarã ejayijarã ĩna itojʉ Jesús tʉjʉre. Masa jãjarã ñajare cumajʉ sãjacõri itojʉ rujiyijʉ Jesús. Masama ñarocõti tujayijarã jajʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ito yija goti masiore ocana ĩnare riasoyijʉ Jesús. Ĩnare riasogʉti ado bajiro gotiyijʉ Jesús: ");
INSERT INTO myy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Tʉoya mʉa adire: Sĩgʉ̃ weseca ĩ ya ote ajeri otegʉ wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wesecajʉ ejacõri iti ajerire ĩ wẽjabateroca gaje ajeri majʉ quedi queayijʉ. Ito yija wadiyijarã minia. Wadicõri itire bacõyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gaje ajeri gʉ̃ta wato quedi queayijʉ. Queno sita mañijʉ ito. Iti ajeri nocõ mejeti judibojayijʉ, sita iti queno manijare. ");
INSERT INTO myy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ũmacañi mʉja wadigʉti itire asi sĩacõyijʉ. Ñe mari manicõri siniacoayijʉ iti. ");
INSERT INTO myy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gaje ajeri jota watojʉ quedi queayijʉ. Ito bajiri jota mari itire dʉrea sĩacõyijʉ. Ito bajiri queno bʉcʉa masibisijʉ iti. Ito yicõri queno rica mañijʉ. ");
INSERT INTO myy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gaje ajeriama sita quenaro quedi queayijʉ. Ito yicõri judiyijʉ iti. Queno wanʉyijʉ iti. Ito bajicõri queno rica cʉtiyijʉ. Coria sarari treinta ñari ajeri rica cʉtiyijʉ. Gaje sarari sesenta ñaricari, gaje sarari cien ñaricari rica cʉtiyijʉ, yi gotiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ito yija ado bajiro yiyijʉ Jesús ĩnare: —Itocõ ña. Gãmo goje cʉtirã mʉa ñaja, tʉoya, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ito bero Jesús sĩgʉ̃ti ĩ ñaroca ĩ tʉ ñarã ĩ rãca riasotirã rãca minijuacõri ado bajiro ĩre seniĩayijarã ĩna: “¿No yireoni ñati? ‘Sĩgʉ̃ oteri masʉ ñayijʉ’, mʉ yirise”, yiyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ito ĩna yija tʉocõri, cʉdiyijʉ Jesús: —“Ado bajiro ĩre tʉorʉ̃nʉrãre miojugʉ yiguĩji Dios”, yi gãjerã ĩna masibitire mʉajʉa masiroca yami ĩ. Gãjerãma Diore tʉorʉ̃nʉmena goti masiore oca tʉobojarãti tʉo masimenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ĩna tibojaja bero timenare bajiro bajirã yirãji ĩna. Ito yicõri ĩna tʉobojaja cʉni tʉomenare bajiro bajirã yirãji ĩna. Ito bajiri tʉo masibiticõri Diore tʉorʉ̃nʉ sʉyamenaji ĩna. Ito yicõri ñeñaro ĩna yirise Diore ĩna goti rẽtobubeja ñeñaro ĩna yirisere coebiquĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mʉcana tʉdi bʉsiyijʉ Jesús ĩnare: —“Oteri masʉ sĩgʉ̃ ado bajiro bajiyijʉ”, yirocʉ jĩjʉ mʉare yʉ gotija, ¿tʉo masibeati mʉa? Iti oca gotire mʉa tʉo masibeja, gaje yʉ gotiroti cʉni tʉo masimena yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Gaje ado bajiro ĩnare goti rẽtobuyijʉ Jesús: —Oteri masʉ Dios oca goti ucuri masʉ robo bajiro bajigʉ ñami. ");
INSERT INTO myy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Coriarã masa ñama, ma gʉdareco ote ajeri quediana robo bajirã. Dios oca tʉorãji ĩna tʉorea. Ito bajibojarocati ĩna tʉoja bero rʉ̃mʉ́ ejacõri ĩna ãcabojaroca yigʉ yiguĩji ĩnare. Ĩna ya ʉsijʉ ĩna tʉo ãmisãre ĩna ãcabojaroca yigʉ yiguĩji rʉ̃mʉ́. ");
INSERT INTO myy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Gãjerã masa ñama, gʉ̃ta wato ote ajeri quediana robo bajirã. Dios oca tʉocõri wanʉ quenaro boca ãmiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ito bajibojarocati Dios oca queno quedi sãjabea ĩnare, queno ñe mari manore bajiro. Ito bajiri ĩnare oca ñaja, gãjerã ĩna ti teja, nocõ mejeti Dios oca ĩna tʉobojare ãcabojarãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gãjerã masa ñama jota wato ote ajeri quediana robo bajirã. Dios oca tʉorãji ĩna tʉorea. ");
INSERT INTO myy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Itire tʉocõri ruje tʉoĩarã yirãji ĩna. Adi sita gaye, adi macãrʉcʉ̃ro gaye ruje gajeoni tʉoĩarãji ĩna. Ito bajicõri gajeoni jai bʉsaro ãmorã yirãji ĩna. Gajeonijʉare bʉto tʉoĩacõri Dios ocare ãcabojarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Gãjerãma Dios oca tʉocõri, queno tʉo sʉyarãji ĩna. Ĩna ñama sita quenarijʉ quediana robo bajirã. Rica jairo rica cʉtiricʉ robo bajiro bajirã ñama ĩna. Corocõ meje ñarãji ĩna. Coriarã Dios oca tʉocõri Dios ĩ ãmorise jabetoti yirãji. Gãjerã Dios ĩ ãmorise jai bʉsaro yirãji. Gãjerã Dios ĩ ãmorise bʉto tʉoĩarãji ĩna. Ito bajiri queno ĩre moa ĩsirã yirãji ĩna. Ĩnaõna ñarãji jairo rica cʉtiricʉ robo bajiro bajirã, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mʉcana gaje oca goti remoyijʉ Jesús ĩnare: —Mujura jãi mani sĩasuaja, sotʉ rocajʉ sĩasuamenaji mani. Ito yicõri canira casabo rocajʉare mujura jãi sĩasuamenaji mani. Mujura jãi mani sĩasuaja ũmacʉ̃jʉ sĩasuarã yirãji mani, jeyaro iti busutoni. ");
INSERT INTO myy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yeyo cũre ñabojaroti, co rʉmʉ goaro yiroja. Ĩna yeyo gotibojarise cʉni yoari yeyomenaji ĩna. Co rʉmʉ masa tʉo bʉja jedirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Queno tʉoya mʉa gãmo goje cʉtirãma, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mʉcana tʉdi goti quenoyijʉ Jesús ĩnare: —No ĩre tʉorʉ̃nʉgʉ̃re jai bʉsaro tʉo masire gaye jidicãgʉ̃ yiguĩji Dios. Ito bajiri jai bʉsaro masigʉ̃ yiguĩji ĩ. No ĩre tʉorʉ̃nʉbicʉre jabetacã ĩ tʉoĩabojarisere ẽmacõgʉ̃ yiguĩji Dios ĩre. Ito bajiri ñe tʉoĩare mano tujagʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tʉo masigʉ̃ bʉto bʉsa tʉo masigʉ̃ yiguĩji. Tʉo masibicʉama ãcabojagʉ yiguĩji ĩ tʉobojare, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mʉcana gaje goti masiore ocana masare riasoyijʉ Jesús: —“Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca ado bajiro bajia iti. Oteri masʉ ote ajeri ĩ oteado bajiroti bajia iti. Tʉote mʉa. ");
INSERT INTO myy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Co ñami rʉyabeto canigʉ̃ yiguĩji oteri masʉ. Ito yicõri co ʉ̃mʉa rʉyabeto yujiguĩji ĩ. Ito yicõri ote ajeri judiroja. Judicõri bʉcʉaroja. Iti bʉcʉa mʉjarisere, ¿no bajiro bʉcʉati iti? yi masibiquĩji oteri masʉ. ");
INSERT INTO myy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sitareti judiroja iti ajeri. Cajero judiroja rujagʉ, jaibitigʉacã. Ito bero bʉcʉa mʉjacõri jũ cʉtiroja. Ito bajicõri rica cʉtiroja. ");
INSERT INTO myy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iti ote botija ticõri, “Ãmirʉja yʉ”, yi tʉoĩacõri itire ãmigʉ̃ wacʉ yiguĩji ĩ. Ĩre tʉorʉ̃nʉrãre Dios ĩ miojuja ito bajiroti bajia. “Yʉre queno tʉorʉ̃nʉama ĩna”, yi tʉoĩacõri ĩre tʉorʉ̃nʉrãre miojugʉ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mʉcana ado bajiro gotiyijʉ Jesús: —¿No bajiro bajiati, “Ĩre tʉorʉ̃nʉrãre miojugʉ yiguĩji Dios”, yire oca? ¿Ñe gaje ocana itire cõĩarãjida mani? ");
INSERT INTO myy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza ajeri sitajʉ oteado bajiro bajia, “Ĩre tʉorʉ̃nʉrãre miojugʉ yiguĩji Dios”, yire oca. Rica jeyaro ajeri rʉja bʉsarise ña mostaza ajeri. ");
INSERT INTO myy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ito bajibojarocati iti aje judi bʉcʉacõri gaje ote gaye rẽto bʉsaro ũmaricʉ ña. Rʉjʉri yoarise ña itigʉre. Ito bajicõri jesarãji minia ũmacañi ĩ asirise rudirã, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Masare Dios oca riasogʉ, goti masiore ocana riasoyijʉ Jesús. “Queno tʉo masibeama”, yi masicõri itocõ goti tarojoyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Goti masiore ocana riti masare riasoyijʉ Jesús. Ĩ sĩgʉ̃ti ĩ rãca riasotirã rãca ñagʉ̃, goti masiore oca gaye queno goti rẽtobuyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iti rʉmʉti rãiocũro ñaroca ado bajiro yiyijʉ Jesús: —Sidʉja jẽa wato mani, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ito ĩ yija tʉocõri: “Wajʉ”, masare yicõri, Jesús ĩ sãñari cumajʉ eja sãjayijarã ĩna. Ito bajiri itiganati Jesure ãmi wayijarã ĩna. Gaje cumari gãna cʉni ĩnare baba cʉti wayijarã. ");
INSERT INTO myy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ito ĩna jẽa waroca mino bʉto wẽayijʉ. Jacũrise cʉni bʉto jacũ sãjayijʉ cumajʉ. Ito bajiri ide dajacoayijʉ cuma ĩja. ");
INSERT INTO myy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ito bajibojarocati Jesús ĩ ya rijoga jeoadona cani sãñayijʉ, cuma ʉsi tutujʉ. Ito bajiro ĩ canija ticõri, ĩre yujioyijarã ĩ rãca riasotirã: —Tʉoya gʉare Riasogʉ mʉ. Rujarã ya mani. ¿Gʉare mai codebeati mʉ? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ito ĩna yija tʉocõri, yujiyijʉ Jesús ĩja. Yujicõri ado bajiro yiyijʉ ĩ: —Wẽabesa, yiyijʉ Jesús minore. Jacũ jidicãña, yiyijʉ Jesús ide jacũrisere. Ito ĩ yirocati mino rẽtacoayijʉ ĩja. Ide cʉni jacũbiticoayijʉ ĩja. Quenaro tʉjacoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ito bajirocati: —¿No yirã güiati mʉa? Güibesa. ¿Yʉre tʉorʉ̃nʉbeati mʉa? ¿Yʉ masirisere tʉoĩabeati mʉa? yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ito bajiro ĩ yibojarocati bʉto tʉo ʉcayijarã ĩna: —¿Ñimʉ ñati ãniama? Minore rẽta rotiami. Mino cʉni, ide cʉni ĩre tʉoa, yiyijarã Jesús rãca riasotirã. ");
INSERT INTO myy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús ĩre sʉyarã rãca sidʉja Gerasa sitajʉ jẽa ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús eja ĩ maja waroca ĩre bocayijʉ gãji. Ĩ ya ʉsijʉ rʉ̃mʉ́ sãja ecorʉ ñayijʉ. Masa yujeadojʉ ñacõri Jesús tʉ ejayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Masa godana ĩna yujeadojʉ ñayijʉ ĩ ñaro. Ĩre sia sẽobisijarã gãjerã come mana. ");
INSERT INTO myy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ĩ ya gʉbo tĩgã ĩ ya ãmore cʉni siabojayijarã ĩna. Ĩre ĩna siabojarocati coji meje tunu ruacõsotiyijʉ ĩ. Ĩre tua yi masibisijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ʉ̃mʉa, ñami cʉni wa ucuyijʉ ĩ. Tʉria joejʉ cʉni, masa yujeadojʉ cʉni wa ucuyijʉ ĩ. Ĩ wa ucurojʉ bʉto awasã ucuyijʉ ĩ. Ito yigʉ gʉ̃tana yijeyijʉ ĩmasiti. ");
INSERT INTO myy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ito ĩ bajiroca Jesure ti ñucacõri ũmaquedi wayijʉ ĩ Jesús tʉjʉ. Jesús tʉ ejacõri ĩ riojo rijomunigãna ñini rũjũyijʉ ĩ, ĩre rʉ̃cʉbʉogʉ. ");
INSERT INTO myy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ĩ ejaja ticõri, ado bajiro yiyijʉ Jesús: —Tʉoya rʉ̃mʉ́ mʉ. Ãnire ĩ ya ʉsijʉ ñagʉ̃ budiya mʉ, yiyijʉ Jesús rʉ̃mʉ́re. Ito ĩ yijare: —Jesús, Dios Macʉ ña mʉáma. ¿Yʉre no bajiro yigʉ yigʉjada mʉ? Dios yʉre tiro riojo bʉsia yʉ. Yʉre juniro yibesa mʉ, yi josayijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ito ĩ yiroca ado bajiro yiyijʉ Jesús ĩre: —¿Ñe wame cʉtiati mʉ? yiyijʉ Jesús. Ito ĩ yija: —Jãjarã wame cʉtia yʉ, jãjarã rʉ̃mʉ́a gʉa ñajare. ");
INSERT INTO myy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","“Adi sita sõjʉa wasa”, gʉare yibesa mʉ, yi josayijʉ rʉ̃mʉ́ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ito bajiroca tʉriajʉ jãjarã ba rʉ̃gõ ucuyijarã ecana yesea. ");
INSERT INTO myy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ĩnare ticõri ado bajiro yiyijarã rʉ̃mʉ́a Jesure: —“Ecana yesea ĩna ya ʉsijʉ sãjaña mʉa”, gʉare yiya mʉ, yi josayijarã ĩna Jesure, yeseare sãja ãmorã. ");
INSERT INTO myy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ito ĩna yija ticõri: “Itojʉ wasa mʉa”, yiyijʉ Jesús ĩnare. Ito ĩ yija ʉ̃mʉgʉ̃re sãñabojana rʉ̃mʉ́a budicoayijarã ĩja, yesea ya ʉsijʉ sãja ãmorã. Ecana yesea dos milcõ ñayijarã ĩna. Ito ĩna ya ʉsijʉ rʉ̃mʉ́a sãja ecocõri bʉto ũmaquedi wayijarã yesea. Gʉ̃tagãri joejʉ mʉja wacõri quedi sãja wayijarã rujarajʉ. Ito bajiri ĩna ñarocõti ruja jedicoayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ito bajiri yeseare codebojarã ũmaquedi wacoayijarã ĩna. Iti bajirisere gotiyijarã ĩna gãjerãre. Jaja cʉto cʉni, jaibiti cʉto cʉni masare itire gotiyijarã ĩna. Ito bajiri, “¿Ñe rẽtati?” yirona tirã wayijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús tʉ ejacõri, rʉ̃mʉ́a sãja ecobojarʉre tiyijarã ĩna. “Jãjarã rʉ̃mʉ́a sãñarʉ ñabojagʉti, ĩ ya ʉsijʉ rʉ̃mʉ́a budigorʉ ñami ĩja”, yi ti masiyijarã masa. Jesús tʉ rujigʉ yutabuju ĩ sãñarocajʉ tiyijarã ĩna. Rʉ̃mʉ́a ĩna sãñaja tʉo masigʉ̃ meje ñayijʉ maji. Quenari ʉsi, ʉsi cʉtigʉ ĩ tʉoĩarise queno tʉo masigʉ̃ ñayijʉ ĩja. Ito ĩ bajija ticõri, bʉto güiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ito bajiro iti rẽtaja ticõri, rʉ̃mʉ́a budigorʉ ĩ bajirise, ecana yesea ĩna bajirise cʉni gãjerãre gotiyijarã ito gãna. ");
INSERT INTO myy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ito bajiri Jesure güicõri ĩna cʉtore ĩ budigotoni ĩre josayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ito Jesús cumajʉ ĩ sãñaroca rʉ̃mʉ́a budigorʉ ado bajiro yiyijʉ ĩre: “Mʉ rãca wa ãmoa yʉ cʉni”, yi josayijʉ ĩ Jesure, ĩ rãca warocʉ. ");
INSERT INTO myy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ito bajiro ĩ yibojarocati ado bajiro yiyijʉ Jesús ĩre: —Yʉ rãca wabesa. Mʉ ya wijʉ tʉdi wasa. “Yʉre ti maicõri, yʉre queno yimi Dios”, yi gotiba mʉ ñarãre, yiyijʉ Jesús ĩ ya ʉsijʉ rʉ̃mʉ́a budigorʉre. ");
INSERT INTO myy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ito Jesús ĩ yiroca rʉ̃mʉ́a budigorʉ tʉdicoayijʉ. Jʉa dʉjamocõ cʉtorijʉ goti ucuyijʉ ĩ. Rʉ̃mʉ́a ĩ ya ʉsijʉ sãñanare Jesús ĩ bucõare gaye goti ucuyijʉ ĩ. Ito bajiri iti bajirisere tʉocõri ʉca jedicoayijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ito yija bero Jesús tʉdi jẽa wayijʉ cuma jajocana. Itajura tʉnima Jesús ĩ rʉ̃gõrojʉ jãjarã masa minijuayijarã ĩ tʉ. ");
INSERT INTO myy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ito bajirocati minijuara wi ʉjʉ ejayijʉ Jesús tʉ. Jairo wame cʉtiyijʉ ĩ. Jesure ticõri ĩ riojo rijomunigãna ñini rũjũyijʉ Jairo. ");
INSERT INTO myy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ito bajiro rujicõri ado bajiro Jesure josayijʉ ĩ: —Yʉ maco cõgõ yamo. Iso catire ãmoa yʉ. Ito bajiri isore moaĩagʉ̃ waya mʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ito bajiro Jairo ĩ yija tʉocõri, ĩ rãca wayijʉ Jesús. Jãjarã masa ĩre sʉya wacõri bidiro ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ĩna wato romio ñayijo. Iso ñayijo romia ñarise cõgõ. Jʉa gʉbojeno rodori tʉjayijʉ iso cõroca riti. ");
INSERT INTO myy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jãjarã ʉco masa ʉco yibojayijarã isore. Ʉco waja niyeru iso rʉcorise ĩsi jeocõyijo ʉco masare. Ĩna ʉco yibojarocati bʉto bʉsa cõ wayijo iso ĩja. ");
INSERT INTO myy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Gãjerãre Jesús ĩ yisiore gaye tʉo bʉjayijo iso. Ito bajiri jãjarã masa rãca ñayijo iso Jesús jʉdojʉa. ");
INSERT INTO myy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Jesús ya yutabujure yʉ moaĩajama catigoja yʉ”, yi tʉoĩayijo isomasijʉama. Ito bajiri ĩ ya yutabujure moaĩayijo iso. ");
INSERT INTO myy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ĩ ya yutabujure iso moaĩarocati rí tadicoayijʉ isore ĩja. Iso rujʉ ñarise iti rẽtaja tʉoĩa masiyijo. ");
INSERT INTO myy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesure iso moaĩaja bero, “Yʉ masirisena yisicoajʉ isore”, yi tʉoĩayijʉ Jesús. Ito bajiri jʉda ticõri ado bajiro masare seniĩayijʉ ĩ: —¿Ñimo yʉ ya yutabujure moaĩari? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ito ĩ yija ĩ rãca riasotirã ado bajiro yiyijarã: —Mʉ tʉjʉ jãjarã ñama mʉre moaĩarã. ¿No yigʉ seniĩati mʉ? “Ñimo yʉ ya yutabujure moaĩari”, ¿yi seniĩati mʉ? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ito ĩna yibojarocati ĩre moaĩagõre ti ãmayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","“Yʉ ña ĩre moaĩagoro”, yiroco bʉto nʉrʉoyijo iso Jesure güigo. Güibojagoti rijomunigãna ñini rũjũyijo iso Jesús riojo. Ito bajicõri ñajediro bajirisere gotiyijo iso Jesure. ");
INSERT INTO myy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iso ito yija tʉocõri, ado bajiro yiyijʉ Jesús: —Maco, tʉoya mʉ. Yʉre mʉ tʉorʉ̃nʉjare mʉre yisiobʉ yʉ. “Jesure yʉ moaĩajama catigo yigoja yʉ”, mʉ yi tʉoĩajare mʉre yisiobʉ yʉ. Ito bajiri mʉre rí tadicoajʉ. Wanʉ quenagõ, cati quenagõ wasa mʉ, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ito bajiro isore ĩ yirocati minijuara wi ʉjʉ Jairo wame cʉtigʉ ya wi gãna ejayijarã. Ado bajiro Jairore gotiyijarã ĩna: —Mʉ maco godacoamo. “Yʉ macore yisiogʉ waya”, yi josabesa Riasori masʉre ĩja, yiyijarã ĩna Jairore. ");
INSERT INTO myy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ito ĩna yibojarocati: —Güibesa. Itoti yʉ masirisere tʉoĩaña, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Gãjerãre sʉya rotibisijʉ Jesús. Pedro, Santiago, Juan cʉni Santiago ocabaji, ĩna ʉdiarãreti sʉya rotiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Minijuara wi ʉjʉ, ya wi tʉ ejacõri, bʉto ĩna otija tʉoyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ito bajiri wi sãjacõri ado bajiro yiyijʉ ĩ: —¿No yirã otiati mʉa? Macoacã cõgõ meje yamo iso. Canigõ yamo, yiyijʉ Jesús otirãre. ");
INSERT INTO myy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","“Ʉsi jedicoañi iso”, yi masicõri Jesure ajayijarã ĩna. Ito bajiro ĩna yija ticõri, budi rotiyijʉ Jesús ĩnare. Ito yicõri macoacã ya sõa sãjayijʉ Jesús. Iso jacʉsabatia rãca, ĩre sʉyarã ʉdiarã rãca sãjayijʉ Jesús. Ĩna rãca sãjacõri macoacãre bʉsiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iso ya ãmore ñia tʉ̃a wʉmʉocõri ado bajiro yiyijʉ Jesús: —Talita cumi, yiyijʉ Jesús isore. Masa oca yireoni bajiro: “ ‘Macoacã, wʉmʉña’, mʉre yibʉ yʉ”, yireoni ña iti. ");
INSERT INTO myy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ito ĩ yirocati wʉmʉ wayijo iso. Jʉa gʉbojeno rodoricõ tʉjago ñayijo iso. Tʉdi iso catija ticõri, bʉto ʉcayijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ito bajiri ado bajiro ĩnare rotiyijʉ ĩ: “Gãjerãre iti bajirisere gotibesa. Isore ecaya mʉa”, yi rotiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iti cʉtore budi wayijʉ Jesús. Budi wacõri ĩ ya cʉto ñasarijʉ ejayijʉ Nazaret wame cʉtirojʉ. Ĩ rãca riasotirã cʉni wayijarã ĩ rãca. ");
INSERT INTO myy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ito bajiri tujacãra rʉmʉ ñaroca masare riasosʉoyijʉ Jesús minijuara wijʉ. Ĩre tʉocõri, “Bʉto masigʉ̃ ñami ĩ”, yirona ʉcayijarã ĩna. Ito bajiri ado bajiro yiyijarã masa Jesure tʉocõri: —¿No bajicõri bʉto tʉo masiati ãni? ¿Ñimʉ ĩre riasoyijari? ¿No bajicõri ĩ bʉto tʉo masirise ñati ĩre? Ĩmasiti guijoro bajiami. Cõrãre ĩ moaĩarocati ñarise rẽtacoajʉ, yiyijarã ĩna Jesús ya cʉto gãna. ");
INSERT INTO myy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Gaje ado bajiro yiyijarã ĩna: Ĩti ñami adojʉ yucʉ yijeri masʉ. María macʉ ñami ĩ. Ito yicõri Santiago, José, Judas, Simón mesa rĩjorʉ ñami ĩ. Ĩ ocabajirã romia cʉni ado gãna ñama ĩna, yiyijarã Jesús ya cʉto gãna. Ito bajiro ĩna yija tʉocõri, Jesure boca ãmibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ito ĩna yibojarocati ĩnare bʉsiyijʉ Jesús: —Diore goti ĩsiri masʉre rʉ̃cʉbʉorã yirãji masa jeyaro. Ito bajibojarocati ĩ ya cʉto gãna, ĩ ñarã, ĩ ya wi gãna cʉni rʉ̃cʉbʉomenaji ĩna. Ĩ ñarã ĩre tʉomenaji ĩna, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ito bajiri Jesure ĩna tʉobejare tiyamani yi ĩoado mañijʉ Jesús. Ito bajibojarocati coriarãre ãmo moa jeocõri ĩna ñarise rẽtoyijʉ Jesús, jãjarãre meje. ");
INSERT INTO myy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ĩ ñarã ĩre ĩna tʉorʉ̃nʉbeja ticõri, “Ayu, ¿no yirã tʉorʉ̃nʉbeati ĩna?” yi tʉoĩayijʉ Jesús. Ito yija gaje cʉtorijʉ wayijʉ Jesús masare riaso ucugʉ wacʉ. ");
INSERT INTO myy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ĩ rãca riasotirãre ji wayijʉ Jesús. Jʉa gʉbojeno ʉ̃mʉa ñayijarã ĩna. Gãjerãre riasojaro yirocʉ, ĩnare cõayijʉ Jesús. Co cʉto rʉyabeto jʉ̃arã riti cõayijʉ Jesús ĩnare. Ito yicõri ĩ masirise jidicãyijʉ Jesús ĩnare, “Rʉ̃mʉ́are bucõama mʉa cʉni”, yirocʉ. ");
INSERT INTO myy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ito yicõri ĩ rãca riasotirãre ado bajiro rotiyijʉ Jesús: “Mʉa goti ucurã waja mʉa ya gajeoni ãmi wa yibesa. Najuro, tura baju, niyerure cʉni ãmi wa yibesa. Tueragʉ riti ãmi wasa, mʉa bogaja itigʉna tue waja. ");
INSERT INTO myy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Gʉboco sãñacõri, yutabuju co bujuti sãña wasa. Mʉa sãñarise riti ãmi wasa”, yi rotiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gaje ado bajiro ĩnare rotiyijʉ Jesús: —Cʉtori mʉa goti ucurã waja, mʉa ejari wi co witi ñacõama. Gaje wi, gaje wi wabeja. Gaje cʉtojʉ warã riti warã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Gaje cʉtori mʉa waja, masa mʉare cʉdibeja, Dios oca ĩna tʉo ãmobeja, itocõti ĩnare jidicãma. Ĩnare jidicãcõri ado bajiro yiba. Mʉa ya gʉbojʉ sita wãrisere ja bateba ĩna ñarijʉre warã. Ito bajiro mʉa yija ticõri: “Bʉjato ya mani ĩnare. Queno yibea mani ĩnare”, yi tʉoĩarã yirãji ĩna, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesús ĩ gotirere tʉocõri masare gotirona wayijarã ĩna: “Ñeñaro mʉa yirise jidicãcõri Diore tʉorʉ̃nʉña”, yiyijarã ĩna masare. ");
INSERT INTO myy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Masare ĩna ya ʉsijʉ rʉ̃mʉ́a sãñanare, rʉ̃mʉ́are bucõayijarã ĩna. Ñarise cõrã jãjarãre ʉ́ye jio guyijarã ĩna. Ito bajiro yicõri ĩna ñarisere rẽtoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Masa jeyaro bʉsiyijarã Jesús ĩ masiro robo ĩ yire gaye. Masa ĩna bʉsire tʉocõri iti cʉto gagʉ ʉjʉ Herodes cʉni, masiyijʉ Jesús ĩ masiro robo ĩ yire gaye. Itire oca tʉocõri ado bajiro bʉsiyijʉ Herodes: —Juan masare idé guri masʉ ñaguĩji mʉcana, yiyijʉ ĩ. Mʉcana tujacõri ĩ masiro robo ĩ yirisere yiguĩji, yiyijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gãjerãma ado bajiro yiyijarã: —Diore goti ĩsiri masʉ Elías ñayorʉ ñaguĩji mʉcana, yiyijarã ĩna. Ito ĩna yibojarocati gãjerã ado bajiro yiyijarã mʉcana: —Diore goti ĩsiri masʉ jane mejejʉ ñayorʉ ñaguĩji gajea, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ito bajiro masa ĩna bʉsija tʉocõri, ado bajiro cʉdiyijʉ Herodes: —Juan ñaguĩji gajea. “Iti rʉmʉjʉ ĩ ya rijoga jatatẽña ĩre”, yicʉ yʉ. Iti rʉmʉ yʉ sĩa rotija bero mʉcana tʉdi tujacõaguĩji gajea, yiyijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Juan ĩ sĩa ecoroto riojʉa, ado bajiro Herodesre bʉsi tudiyijʉ ĩ: —Mʉ ocabaji Felipe manojore rʉcobesa mʉ. Ito bajiro yibitirʉja mʉ, yiyijʉ Juan Herodesre. Felipe manojo ñabojaro Herodías wame cʉtiyijo iso. Herodes bʉto ãmoyijʉ isore. Ito bajiri Juan ito bajiro ĩ yija tʉocõri, ĩre ñia rotiyijʉ Herodes ĩ ya surarare, ĩre ĩna tubiatoni. ");
INSERT INTO myy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ito bajiro Juan ĩ bʉsija tʉocõri, Herodías bʉto tʉo tudiyijo ĩre. Ĩre sĩa ãmobojayijo iso. No bajiro ĩre sĩa masia mañijʉ isore. ");
INSERT INTO myy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Quenarise riti tʉoĩagʉ̃ ñayijʉ Juan. Ito yicõri queno ʉsi cʉtigʉ ñayijʉ ĩ, Dios ĩ tija. Itire ticõri Juanre queno rʉ̃cʉbʉoyijʉ Herodes. Ito bajiri Juanre camotayijʉ ĩ, Herodías sĩame yirocʉ. Juan ĩ bʉsirisere tʉo oca jaibojagʉti ĩre bʉto tʉo wanʉyijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Co rʉmʉ ĩ ñara rodo gãni biajare basa meni rotiyijʉ Herodes. Ĩ ya moari masa ʉjarã rãca, ito yicõri surara ʉjarã rãca, Galilea ñari masa rãca cʉni ĩna rãca basa meniyijʉ Herodes. Ĩna basa wijari rʉmʉ Juanre sĩaroco tʉoĩacõyijo Herodías. ");
INSERT INTO myy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Iso maco ĩnare basa ĩoyijo ĩna wanʉtoni. “Quenoguti yʉre basa ĩoamo iso”, yi tʉoĩayijʉ Herodes. Ito bajiri ado bajiro yiyijʉ isore: —¿Ñe mʉre ĩsigʉ̃ti yʉ mʉ basare waja? Mʉ ãmorise yʉre seniña. ");
INSERT INTO myy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mʉ senija yʉ gajeoni rʉcorise gʉdarecona mʉre ĩsicʉja yʉ. Adi cʉto gagʉ ʉjʉ ñacõri, mʉ senija gʉdarecona ĩsicʉja yʉ. Bʉgʉ meje ya yʉ adire. Ri ya yʉ, yiyijʉ Herodes Herodías macore. ");
INSERT INTO myy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ito ĩ yija tʉocõri, iso jacore seniĩagõ wayijo iso: —¿Ñe gajeoni ĩre senigõti yʉ, cana? yiyijo iso. Ito yija: —“Juan masare idé guri masʉ ya rijogare ãmoa yʉ”, yiba Herodesre, yiyijo Herodías iso macore. ");
INSERT INTO myy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ito bajiro jaco gotija tʉocõri, ʉsirio wayijo iso ʉjʉ Herodes tʉjʉ. Ĩre ado bajiro gotiyijo iso: —Adocãtati Juan ya rijoga ãmoa yʉ. Somotẽrona jeocõri yʉre ĩsiña, yiyijo iso ĩre. ");
INSERT INTO myy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ito yija Herodes bʉto bojori bʉjayijʉ itire tʉocõri. Juanre sĩa ãmobitibojayijʉ ĩ. Ito yicõri isore maño ãmobisijʉ ĩ. Masa ĩna tiro riojo, “Mʉ ãmoriseti mʉre ĩsicʉja”, ĩ yicãre ñajare, iso seniro bajiroti ĩsiyijʉ ĩ isore. ");
INSERT INTO myy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ito bajiri Juanre sĩa ãmobitibojagʉti, ejori oca ĩ ya moari masʉre Juanre rijoga jata rotiyijʉ Herodes. Ito bajiro ĩ rotija tʉocõri, tubiara wi wayijʉ Juan ya rijoga jatagʉ wacʉ. ");
INSERT INTO myy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ito ejacõri Juan ya rijoga jata, somotẽrojʉ jeocõri ãmi wayijʉ ĩ. Ãmi wacõri basari masore ĩsiyijʉ ĩ. Isojʉ ĩja iso jacore ĩsiyijo. ");
INSERT INTO myy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juanre sĩare gaye tʉocõri, ĩ rãca riasotiana ĩ ya rujʉre ãmirã ejayijarã. Ito yicõri ĩre yujeyijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mʉcana tʉdi ejacõri Jesús rãca minijuayijarã ĩ oca goti ucurã ejana. Ito bajiri ĩna riaso ucure gotiyijarã ĩna Jesure. Ĩna tiado bajiroti ñarocõti goti jeoyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jãjarã masa warãtibe, tʉdi warãtibe, yi ñayijarã masa. Ito bajiri Jesús ĩre sʉyarã cʉni ba ãmobojayijarã. Dijʉ barajaʉ mañijʉ ĩnare. Ado bajiro yiyijʉ Jesús ĩ cũanare: —Ita, wato. Õ, masa ĩna manojʉ tujacãto mani, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ito yija jajocana wayijʉ Jesús masa manojʉ. Ĩ cũana cʉni wayijarã ĩ rãca. ");
INSERT INTO myy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Masa jãjarã tiyijarã ĩna waja. Jesús, ĩ cũanare cʉni ti masiyijarã masa. Ito bajiri ĩna wagoja ticõri, boejʉ ũmaquedi wayijarã masa. Jesús ĩ cũana rãca ĩna ejaroto riojʉajʉ ejayijarã masa, bʉto wacõri. ");
INSERT INTO myy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cumana ejacõri maja wacʉti jãjarã masare ti bʉjayijʉ Jesús. Oveja codegʉ mano bajiro bajiyijarã masa ĩ tija. Ito bajiri ĩnare ti maiyijʉ ĩ. Ito bajiri masare ti maicõri ĩnare riasosʉoyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ñamicajʉ ñaroca Jesure bʉsirona ĩ tʉ ejayijarã ĩ rãca riasotirã. Ado bajiro yiyijarã ĩna: —Ñamicajʉ ñacoajʉ ĩja. Queno masa mama adore. ");
INSERT INTO myy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ito bajiri masa ĩna cʉtojʉ tʉdi wajaro. Õjʉ ĩna ñarojʉ bare gãme barã wajaro. Bare ma ado. Ito ñaroja, naju gãme barajʉ, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ito yija ado bajiro yiyijʉ Jesús ĩnare: —Masare ecaya mʉa, yiyijʉ ĩ. Ito yija ĩja, ĩ rãca riasotirã ado bajiro ĩre seniĩayijarã ĩna: —¿Gʉa bare gãmerã warãjida, jairo waja rʉ̃cʉrisere? Masa jaijare najuro waja tĩjabea, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ĩna ito yija tʉocõri, ado bajiro ĩnare seniĩayijʉ Jesús: —¿Nocõ naju rʉcoati mʉa? Titẽña maji, yiyijʉ Jesús ĩ rãca riasotirãre. Itire ticõri ĩre gotiyijarã: —Co dʉjamocõ ña iti naju. Ito yicõri wai cʉni jʉ̃arã ñama, yiyijarã Jesure. ");
INSERT INTO myy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ito yija ado bajiro masare yiyijʉ Jesús: “Rujaria buri ruji wasa ta quenarise joejʉ”, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ito bajiro ĩ yija tʉocõri, rujaria buri ruji wayijarã masa. Co bure ñayijarã cincuenta ñarã, gãjerã cien ñarã rujisosa wayijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ito yija naju co dʉjamocõ ñarisere, wai jʉ̃arãre cʉni ãmi rʉcoyijʉ Jesús ĩ ya ãmona. Iti rʉcocõri macãrʉcʉ̃rojʉ ti mʉoyijʉ ĩ: “Queno ya Cʉna mʉ”, yiyijʉ Jesús Diore. Ito yicõri najuro wẽ jea batoyijʉ ĩja. Ito yicõri ĩ rãca riasotirãre ĩsiyijʉ Jesús. “Masare batoya”, yirocʉ ĩsiyijʉ Jesús. Wai jʉ̃arãre batoyijʉ Jesús masa ñarocõti ĩna batoni. ");
INSERT INTO myy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ito bajiri masa jeyaro bayijarã. Yaji quenaro ñayijarã masa ĩja iti bacõri. ");
INSERT INTO myy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ĩna yaji rẽtarisere jʉa gʉbojeno jiburijʉ miosã dajoyijarã ĩna ba rʉarisere. ");
INSERT INTO myy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jãjarã ñayijarã masa, najuro waire cʉni barã. Cinco milcõ ñayijarã ĩna ʉ̃mʉa. ");
INSERT INTO myy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ito yija ĩ rãca riasotirãre ado bajiro yiyijʉ Jesús: —Cuma sãjacõri sidʉja jẽa wasa. Itojʉ Betsaidajʉ yʉre yuba, yiyijʉ Jesús ĩnare. Ĩna jẽa waroca masare ware goti ñayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ĩnare ware goticõri tʉriajʉ maja wayijʉ Jesús, Diore bʉsirocʉ. ");
INSERT INTO myy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Rãiocũro itajura gʉdarecoti tʉjayijʉ cuma maji. Ito bajiri Jesuama itajura tʉnima rʉ̃gõcõri ti ñucayijʉ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús ĩ tija bʉto weabojayijarã ĩna. Mino bʉto iti wẽa tuojare josari wea wabojayijarã ĩna. Ito bajiri busucũro ide joena wacõri ĩna tʉ eja wayijʉ Jesús. Ito bajibojarocati ĩnare rẽta wacʉ bajiro eja wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ide joe ĩ waja ticõri, bʉto awasãyijarã ĩna ʉcarã. “Masʉ wʉjo ñaguĩji”, yi tʉoĩayijarã ĩna. Ĩna ʉcaja ticõri, ado bajiro yiyijʉ Jesús: —Oca sẽoña mʉa. Güibesa mʉa. Yʉti ña, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Itocõti ĩna rãca cumajʉ sãja ejacoayijʉ Jesús ĩja. Ĩ sãjarocati mino rẽtacoayijʉ. Ito bajiri bʉto ti ʉcayijarã ĩna itire. ");
INSERT INTO myy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bare jabetacãna jãjarã masare Jesús ĩ ecaja tibojarãti, “Dioti ñami ĩ”, yi masibisijarã ĩna maji. “Tiyamani ĩo masigʉ̃ ñami Jesús”, yi ãmobisijarã ĩna. Queno tʉo masibisijarã maji. ");
INSERT INTO myy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Itajura jẽacõri Genesaret wame cʉtiri sitajʉ ejayijarã ĩna. Itojʉ cumare sia cũyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cuma ĩna sia majaroca Jesure ti masiyijarã masa itijʉ gãna. ");
INSERT INTO myy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jesure ticõri ʉsirio wayijarã gãjerãre gotirona. Ito yija cõrãre ĩna ya camana ãmi wayijarã Jesús tʉjʉa. ");
INSERT INTO myy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","No ĩ waro bajiroti jaibiti cʉto, jaja cʉtojʉ, wi manojʉ, majʉ cʉni cõrãre cũ yuyijarã ĩna, Jesús ĩ yisiotoni. Ĩ ya yutabuju gaja moaĩa ãmorã, ĩre josayijarã ĩna. Jesús ya yutabuju gaja moaĩanare riti ĩna ñarise cʉtirise rẽtacoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ito yija fariseo gaye tʉoĩarã, judio masa rotirise riasori masa rãca Jesús tʉ eja rʉ̃gʉ̃yijarã ĩna. Jerusaléna wadiana ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesús tʉ ejacõri ĩ rãca riasotirã coriarã ãmo coemenati ĩna baja tiyijarã ĩna. Ito bajiri bʉcʉrã ĩna rotiado bajiro ĩna yibeja ticõri, ĩnare bʉsituyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Judio masa ñajediro, fariseo gaye tʉoĩarã cʉni bʉcʉrã ocare queno tʉo sʉyayijarã ĩna. Bʉcʉrã ĩna rotiado bajiroti ruje ãmo coesotiyijarã ĩna baroto riojʉa. ");
INSERT INTO myy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bare waja yiadojʉ bare gãme tʉdi ejacõri bʉcʉrã ĩna rotirise ĩna cʉdiroto riojʉa babisijarã ĩna. Bʉcʉrã ĩna rotiado bajiroti idira coa, ide gõnaradʉ, ito yicõri come sotʉ cʉni coecõyijarã ĩna. Bʉcʉrã rotirise cʉdirona ĩna ya caniado cʉni queno coecõyijarã fariseo gaye tʉoĩarã, judio masa rotirise riasori masa cʉni. ");
INSERT INTO myy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ito bajiri Jesús rãca riasotirã ĩna ãmo coemenati baja ticõri, ado bajiro ĩre seniĩayijarã ĩna: —¿No yija mʉ rãca riasotirã bʉcʉrã oca tʉorʉ̃nʉbeati? yiyijarã ĩna. Tite. Coji rʉyabeto ãmo coemenati bama ĩna, yiyijarã fariseo gaye tʉoĩarã. ");
INSERT INTO myy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ito ĩna yijare cʉdiyijʉ Jesús ĩnare: —“Queno yirã ña gʉa”, yibojarãti mʉa tʉoĩaro bajiro yibea mʉa. Jane mejejʉ mʉare tʉoĩa yugʉ ado bajiro ucañi Diore goti ĩsiri masʉ Isaías ñayorʉ: “Diore bʉto rʉ̃cʉbʉoa gʉa”, yirã ñabojarãti mʉa ya ʉsijʉama queno ĩre rʉ̃cʉbʉobea mʉa. ");
INSERT INTO myy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Minijuacõri, “Diore queno rʉ̃cʉbʉoa gʉa”, yirã ñabojarãti rocati ya mʉa. Ito yicõri rocati oca bʉsi ajea mʉa itire. Mʉa gotijama, “Bʉcʉrã oca, Dios oca bajiroti bajia”, yi gotiboja mʉa, yi ucañi Isaías ñayorʉ mʉare tʉoĩa yugʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dios ĩ rotirisejʉa queno tʉorʉ̃nʉbiticõri, bʉcʉrã ocajʉare queno tʉorʉ̃nʉa mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mʉcana gaje ado bajiro ĩnare goti remoyijʉ Jesús: —Bʉcʉrã ocajʉare tʉo sʉyarona Dios ĩ rotirisereama cʉdibea mʉa. ");
INSERT INTO myy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ado bajiro gotiyijʉ Moisés ñayorʉ: “Mʉ jacʉre, mʉ jacore cʉni rʉ̃cʉbʉoya”, yiyijʉ ĩ. “No ĩ jacʉre bʉsitugʉ, ĩ jacore cʉni bʉsitugʉ sĩacõrʉja ĩocʉ̃re”, yi ucañi Moisés ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mʉama ricati bajiro rotia. Ado bajirojʉa rotia mʉa: “Yʉ jacʉsabatiare ejabʉado ma yʉ. Ñarocõti yʉ gajeoni cʉtirise Dios ye riti ña. Ĩ sĩgʉ̃reti ejabʉacʉja yʉ”, sĩgʉ̃ ĩ yija, “Queno yami”, ya mʉa. ");
INSERT INTO myy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“Ito bajiro ĩ tʉoĩaja, no yibea ĩ jacʉsabatiare ĩ ejabʉabeja”, ya mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","’Ito bajiro mʉa bʉsija, bʉcʉrã ocajʉa tʉorʉ̃nʉcõri, “Dios oca waja ma”, yi tʉoĩado bajiro ya mʉa. Iti oca mʉa tʉorʉ̃nʉrise gãjire, gãjire goti mʉja wajʉ mʉa. Gaje jaje ñaroja mʉa ito yirise. Dios ocare tʉorʉ̃nʉrã meje ña mʉa, yiyijʉ Jesús fariseo gaye tʉoĩarã, ito yicõri judio masa rotirise riasori masare cʉni. ");
INSERT INTO myy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ito bero masare jicõri ado bajiro gotiyijʉ Jesús: —Mʉa ñarocõti tʉoya yʉre. Ito yicõri tʉo masiña mʉa. ");
INSERT INTO myy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mani ba sãrise meje ñaroja ñeñaro mani yiroca yirise. Mani ya ʉsijʉ iti ñeñaro tʉoĩajare itina sʉoriti ñeñaro ya mani. ");
INSERT INTO myy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mʉa gãmo goje cʉtijama tʉoya, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ito yicõri masare ware goticõri wijʉ sãjayijʉ Jesús. Wijʉ ĩ sãjaroca ĩre seniĩayijarã ĩ rãca riasotirã: —Jĩjʉ mʉ masare riasorise gayere queno gotiya gʉare cʉni, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ito ĩna yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —¿Yʉ riasorise gaye queno tʉobiti mʉa cʉni? “Masa ĩna ba sãrise meje ñaroja ñeñaro ĩna yiroca yirise”, yʉ yija, ¿tʉo masibeati mʉa? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Masa ĩna ba sãrise jeragajʉ riti waroja. Ĩna ya ʉsijʉ meje waroja iti. Ito yicõri ĩna ba sãrise rẽta budicoaro yiroja, yiyijʉ Jesús ĩnare. “Bare jeyaro quenarise riti ña”, yirocʉ yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mʉcana tʉdi goti quenoyijʉ Jesús ĩnare: —Masa ĩna ya ʉsijʉ iti ñeñaro tʉoĩajare itina sʉoriti ñeñaro yama ĩna. ");
INSERT INTO myy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ĩna ya ʉsijʉ ñeñaro tʉoĩacõri ado bajiro ñeñarise yama masa. Manʉjʉ macore rocati yama ĩna. Riniama. Sĩama. ");
INSERT INTO myy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Manojo cʉtirã ñabojarãti rocati yama ĩna. Gãjire gajeoni ʉoama. Ñeñarise ñajediro yama ĩna. Rʉoama. Dios ĩ rotirisere cʉdibeama ĩna. Gãjerãre ti tudiama. Gãjerãre bʉsituama ĩna. Ĩna gajeoni rãca, “No yiya mana ña gʉa”, yama ĩna. “Gãjerã rẽtoro masirã ña gʉa”, yama ĩna. Ito yicõri queno tʉoĩabiticõri rocati yama ĩnaõna. ");
INSERT INTO myy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Adi ñeñarise ñajediro yama ĩna, ĩna ya ʉsijʉ ñeñaro iti tʉoĩajare, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Itijʉna wacõri Tiro wame cʉtiri cʉto tʉ ejayijʉ Jesús. Ito ejacõri wi sãjayijʉ ĩ. Masa ĩna masibeto eja ãmoyijʉ Jesús. Ito bajibojarocati masicõyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ito bajiri sĩgõ Jesús ĩ ejare gaye masiyijo. Iso ñayijo rʉ̃mʉ́ sãñagõ jaco. Ito bajiri Jesús tʉ wadicõri iso ya rijomunigãna ñini rũjũyijo iso, Jesús riojo. ");
INSERT INTO myy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Judio masagõ meje ñayijo iso. Sirofenicia gago ñayijo iso. Jesús tʉ ejacõri ĩre josayijo: “Yʉ maco iso ya ʉsijʉ rʉ̃mʉ́ sãñagõ ñamo. Ito bajiri iso ya ʉsijʉ rʉ̃mʉ́ sãñagʉ̃re bucõaña mʉ”, yiyijo iso Jesure. ");
INSERT INTO myy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ito yija ado bajiro gotiyijʉ Jesús isore: —Cajero judio masare ejabʉasʉocʉja yʉ, yiyijʉ Jesús. Gʉa masa riojʉajʉ yʉ mʉre ejabʉaja, rĩacare najuro ẽmacõri yaire ecado bajiro bajia, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijo iso: —Ri ya, yʉ Ʉjʉ mʉ. Ito bajibojarocati yaia bare jeoado roca ñarã boca barã yirãji rĩaca ĩna queorisere, yiyijo iso. ");
INSERT INTO myy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ito iso yija ado bajiro cʉdiyijʉ Jesús isore: —Queno tʉoĩa mʉ. Ito bajiri mʉ ya wijʉ tʉdi wasa. Rʉ̃mʉ́ budigocõami mʉ macore ĩja, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iso ya wi tʉdi ejacõri caniado joejʉ maso iso jesaroca tiyijo iso. Rʉ̃mʉ́ budigorojʉ ñayijo iso ĩja. ");
INSERT INTO myy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro cʉtona wayijʉ Jesús. Ito wa rẽtayijʉ Sidón wame cʉtiri cʉto. Ito rẽta wacʉti Decápolis wame cʉtiri cʉtori cʉni rẽtayijʉ. Ito rẽta wacʉ ejayijʉ Galilea wame cʉtiritajʉ. ");
INSERT INTO myy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ito ĩ ñaroca tʉobiti bʉsibiti yigʉre ãmi ejayijarã masa. Ĩre ãmi ejacõri Jesure seniyijarã ĩna, tʉobicʉre ĩ ya ãmo moa jeotoni. ");
INSERT INTO myy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ito bajiri tʉobicʉre gajerojʉa ãmi wayijʉ Jesús. Ito yicõri tʉobicʉ ya gãmo gojerijʉ ãmo wãsoa sõcõayijʉ Jesús. Ito yicõri ãmona ĩ ya go ide ãmicõri ĩ ya ñemerojʉ moaĩayijʉ bʉsibicʉre. ");
INSERT INTO myy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ito yicõri macãrʉcʉ̃rojʉ ti mʉocõri ʉsi ãmiyijʉ Jesús. Ito yicõri ado bajiro yiyijʉ ĩre: —Efata, yiyijʉ Jesús. “Gãmoro tʉoya ĩja”, yireoni ñayijʉ iti griego ocana. ");
INSERT INTO myy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ito ĩ yirocati tʉobicʉ ñabojarʉti tʉocoayijʉ ĩja. Ito yicõri ĩ ya ñemero cʉni quenacoayijʉ ĩre ĩja. Ito bajiri bʉsicoayijʉ ĩ bʉsibicʉ ñabojarʉ. ");
INSERT INTO myy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ito yija ado bajiro masare gotiyijʉ Jesús: “Gãjerãre goti bato yibesa mʉa”, yiyijʉ Jesús ĩnare. Ito ĩ yibojarocati masa jãjarãre goti batoyijarã Jesús ĩ masiro robo ĩ yirisere. “Gotibesa”, ĩ yibojarocati bʉto bʉsa masare goti bato wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ito bajiro Jesús ĩ yija ti wanʉcõri, ado bajiro yiyijarã ĩna: —Jeyaro ĩ yirise quenasacõa, yiyijarã masa. Tʉomenare cʉni ĩna tʉoroca, bʉsimenare cʉni ĩna bʉsiroca yami Jesús, yiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Iti rʉmʉri mʉcana tʉdi jãjarã masa minijuayijarã Jesús tʉjʉ. Jesús tʉ ĩna ñaroca riti bare jedicoayijʉ ĩnare. Ito bajiri ĩ rãca riasotirãre jicõri ado bajiro yiyijʉ Jesús: ");
INSERT INTO myy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ãna masare ti maia yʉ. Ʉdia rʉmʉ tʉja yʉ rãca ĩna ñaroca. Ito bajiri bare ma ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","“Bamenati wasa”, ĩnare yʉ yija, ma gʉdarecoti boga quedirãji ĩna. Coriarã sõjʉ wadiana ñarãji, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijarã ĩ rãca riasotirã: —Masa ñaro meje ñajare no bajiro masare bare eca masiado ma, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ito ĩna yija seniĩayijʉ Jesús ĩnare: —¿Nocõ jaje naju rʉcoati mʉa? yiyijʉ Jesús ĩnare. —Jʉa ãmojeno najurori ña, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ito yija jacajʉ masare ruji rotiyijʉ Jesús. Ito yicõri jʉa ãmojeno naju ñarisere ãmi rʉcoyijʉ Jesús. Itire rʉcocõri ado bajiro yiyijʉ Jesús: “Queno ya mʉ”, yiyijʉ Jesús Diore. Ito yicõri naju igata batocõri ĩ rãca riasotirãre ĩsiyijʉ Jesús. Ĩnajʉa masa jeyarore batoyijarã ĩja. ");
INSERT INTO myy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ito yicõri wai cʉni jabeto rʉcoyijarã ĩna. Waire rʉcocõri, “Queno ya Dios mʉ”, yiyijʉ Jesús mʉcana. Ito yicõri ĩ rãca riasotirãre bato rotiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Masa ñarocõti ba jediyijarã. Sĩgʉ̃ rʉyabeto yaji quenaro ñayijarã ĩna. Ĩna ba rʉarise ãmicõri jʉa ãmojeno jibʉri dajoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Itijʉ Jesús rãca bana cuatro milcõ ñayijarã masa. Ĩna ba tĩoja bero ĩnare ware gotiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ito bero cumajʉ sãjayijʉ Jesús ĩ rãca riasotirã rãca. Cuma sãjacõri Dalmanuta sitajʉ wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ito Jesús ĩ ejaja tʉocõri, ĩ rãca bʉsirona ĩ tʉ ejayijarã fariseo gaye tʉoĩarã. Ĩ wisajaro yirona ĩre seniĩayijarã ĩna. “ ‘Dios cõarʉ ñami ĩ’, gʉa yitoni, tiyamani mʉ ĩore ãmoa gʉa”, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ito bajiro ĩna yija tʉocõri, bʉto ʉsi ãmiyijʉ Jesús. “Teoro yama yʉre”, yirocʉ ito bajiro ʉsi ãmiyijʉ ĩ: —¿No yija ãna masa tiyamani yi ĩo rotiati ĩna yʉre? yiyijʉ Jesús. Riti mʉare gotia yʉ. Tiyamani yi ĩobicʉja yʉ masare, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ito yicõri masare cũ wayijʉ Jesús. Mʉcana tʉdi cumajʉ sãjacõri, itajura gaje dʉjajʉa jẽa wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús rãca riasotirã bare ãmi ware ãcabojayijarã. Ito bajiri ĩna ya cumajʉ naju jabetacã ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ito yija ado bajiro gotiyijʉ Jesús ĩnare: —Fariseo gaye tʉoĩarã ya naju wadarise ʉco gaye queno tʉo masiña mʉa. Herodes ĩ gaye cʉni queno tʉo masiña, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ito bajiro Jesús ĩ yija tʉocõri, ĩnamasi gãmeri bʉsiyijarã: —Mani naju rʉcobejare ito bajiro bʉsiami Jesús, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ĩna bʉsirise masicõyijʉ Jesús. Ito bajiri ado bajiro yiyijʉ ĩ ĩnare: —¿No yija, “Naju ma”, yati mʉa? yiyijʉ Jesús ĩnare. ¿Yʉre masibeati mʉa maji? ¿Mʉa ya ʉsijʉ tʉo masimena ña mʉa? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mʉare cajea ñabojarocati ti masibea mʉa. Ito yicõri gãmoro ñabojarocati tʉo masibea mʉa. ¿Yʉ masiro robo yʉ yirisere masibeati mʉa? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Co dʉjamocõ najurori cinco mil masa ñarãre yʉ bare ecaja bero rʉyarise nocõ jibʉri dajocati mʉa? yiyijʉ Jesús ĩnare. Ito ĩ yija tʉocõri, ado bajiro cʉdiyijarã ĩna: —Doce jibʉri dajocʉ gʉa, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Siete najurori cuatro mil masa ñarãre yʉ batoja, ĩna ba rʉare, ¿nocõ jibʉri dajocati mʉa? yiyijʉ Jesús ĩ rãca riasotirãre. —Siete jibʉri dajocʉ gʉa, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ito yija ado bajiro yiyijʉ Jesús ĩnare: —¿Tʉo masibeati mʉa maji? yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ito bero Jesús ĩre sʉyarã rãca Betsaidajʉ ejayijʉ. Ito ĩna ejaroca cajea macʉre ãmi ejayijarã masa Jesús tʉ. Ĩre josayijarã ĩna cajea macʉre ĩ moaĩatoni. ");
INSERT INTO myy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ito yija cajea macʉ ya ãmo ñiacõri ĩre tʉ̃a wayijʉ Jesús iti cʉto sõjʉa bʉsacã. Ito yicõri ĩ ya go idena cajea macʉre ĩ ya cajea moaĩayijʉ Jesús. Ito yicõri ado bajiro ĩre seniĩayijʉ: “¿Ruyuati jabeto?” yiyijʉ Jesús cajea macʉre. ");
INSERT INTO myy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ito bajiro ĩ yija cajea tibicʉ tisʉoyijʉ jabeto. Ito bajiri ado bajiro cʉdiyijʉ ĩ: —Tia yʉ jabeto. Ito bajibojarocati masare yʉ tija, yucʉ wãrero bajiro bajia, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ito yija Jesús mʉcana tʉdi moaĩa quenoyijʉ ĩ ya cajeare. Ito ĩ yija bero queno ticoayijʉ ĩja. Ñajediro queno ruyuyijʉ ĩre ĩja. ");
INSERT INTO myy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ito yija Jesús ado bajiro gotiyijʉ ĩre: —Mʉ ya wijʉ tʉdi wasa. Cʉtojʉ cʉni sãja wa yibeja. Ito yicõri gãjerãre cʉni goti bato yibeja, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ito ĩ yija bero ĩ rãca riasotirã rãca wayijʉ Jesús, Cesarea Filipo wame cʉtiri cʉto tʉ. Ma ĩna warojʉ ĩ rãca riasotirãre ado bajiro seniĩayijʉ Jesús: —¿No bajiro yati masa yʉre ĩna tija? “¿Ñimʉ ñati ĩ?” ĩna seniĩaja, ¿no bajiro cʉdiati gãjerã? yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ito ĩ yija: —Ado bajiro yama masa mʉre: “Juan masare idé guri masʉ ñami”, yima. Gãjerã ĩna yijama, “Elías ñami”, yima ĩna. Gãjerã ĩna yijama, “Diore goti ĩsiri masʉ ñami”, yima ĩna, yiyijarã ĩna Jesure. Ito yija ado bajiro ĩnare seniĩayijʉ Jesús: ");
INSERT INTO myy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—¿Mʉama, ñimʉ ñami, yati mʉa yʉre? yiyijʉ Jesús. Ito ĩ yija ado bajiro cʉdiyijʉ Pedro ĩre: —Mʉti ña Cristo, Dios ĩ cõarʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ito bajiro ĩ yija tʉocõri: —Gãjerãre goti batobesa mʉa, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ito yija Jesús ado bajiro ĩnare riasosʉoyijʉ: —Yʉti ña Masa Rĩjorʉ. Bʉjato tõbʉjagʉ yigʉja yʉ. Paia ʉjarã, judio masa rotirise riasori masa, ito yicõri bʉcʉrã cʉni, “Dios Macʉ meje ña mʉ”, yirã yirãji ĩna yʉre. Ito yicõri yʉre sĩarã yirãji. Ĩna sĩaja, godacoagʉ yigʉja yʉ maji. Godabojagʉti ʉdia rʉmʉ bero mʉcana tʉdi catigʉ yigʉja yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ito bajiro ĩnare gotigʉ quenaro gotiyijʉ Jesús. Itire ĩ bʉsija tʉocõri, ricati ãmi wayijʉ Pedro Jesure. Ito yicõri, “Yibesa mʉ itire”, yi tudiyijʉ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ito ĩ yija tʉocõri, jʉda rʉ̃gʉ̃yijʉ Jesús. Ito bajiro yicõri ĩ rãca riasotirãre tiyijʉ Jesús. Ito yicõri ado bajiro oca sẽorise rãca gotiyijʉ Jesús Pedrore: —Rʉ̃mʉ́a ʉjʉ Satanás wame cʉtigʉ bajiro bʉsia mʉ, yiyijʉ Jesús ĩre. Yʉ rãca ñabesa mʉ. Wasa mʉ. Dios ĩ tʉoĩaro bajiro meje tʉoĩa mʉ. Masa ĩna tʉoĩabojaro bajirojʉa tʉoĩa mʉ, yiyijʉ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ito yija ĩ rãca riasotirã, gãjerãre cʉni jimioyijʉ Jesús. Ito yicõri ado bajiro gotiyijʉ ĩ: —Sĩgʉ̃ yʉre ĩ sʉya ãmoja, ĩ ye ñaroti tʉoĩabiticõri yʉjʉare tʉo mai sʉyagʉ yiguĩji. Yucʉ gajagʉ robo bajiro tõbʉjabojagʉti yʉre riti sʉyagʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","No ĩ catirise maibojagʉti godagʉ yiguĩji. Ito bajibojarocati yʉre tʉorʉ̃nʉgʉ̃, yʉ oca ĩ gotija tʉo junisinicõri ĩna sĩagʉ̃ama catitĩñare gaye bʉjagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sĩgʉ̃ adi macãrʉcʉ̃rojʉ gajeoni jeyaro ĩ bʉjabojaja, ĩ ya ʉsi jeame ʉ̃jʉrojʉ iti waja, ĩ ya gajeoni ĩ bʉjabojare ñe waja ma. ");
INSERT INTO myy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ñe mani ya ʉsi rẽto bʉsaro waja cʉtirise manoja. Catirãti Dios rãca mani oca quenoja quena. Mani godaja bero ĩ rãca oca quenore manoja ĩja. ");
INSERT INTO myy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Adi rʉmʉri gãna ñeñaro yiri masa ñama. Ito yicõri Diore tʉorʉ̃nʉrã meje ñama ĩna. Ito bajiri, “Jesure rʉ̃cʉbʉogʉ ña yʉ”, yi tʉoĩa bojobesa ĩna tiro riojo. Ito yicõri ñe bojore mano yʉ oca gotija quena. No yʉre masigʉ̃ ñabojagʉti yʉre ĩ bojoja, ito yicõri yʉ oca masibojagʉti ĩ bojoja, yʉ tʉdi ejari rʉmʉ ito bajiroti ĩre bojogʉ yigʉja yʉ cʉni. Yʉ Masa Rĩjorʉ ñacõri yʉ Jacʉ Dios ĩ busurisena tʉdi ejagʉ yigʉja yʉ. Ito yicõri ĩ ñaro gãna ángel mesa rãca ejagʉ yigʉja yʉ, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ito yija gaje goti remoyijʉ Jesús ĩnare: —Ĩre tʉorʉ̃nʉrãre Dios ĩ miojuja, ĩ masirisena miojugʉ yiguĩji. Riti mʉare gotia yʉ. Mʉa coriarã adijʉ ñarã mʉa godaroto riojʉa ito bajiro ĩ yisʉoja tirã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Co ãmojeno ʉ̃mʉari bero Pedro, Santiago ito yicõri Juanre cʉni ãmi wayijʉ Jesús ũmari tʉria joejʉ. Itojʉ ĩna ejaroca ĩna tiro riojo Jesús ĩ ya rio gajero bajiro godo wediyijʉ. ");
INSERT INTO myy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ĩ ya yutabuju bʉto bʉsa botiyijʉ. Ito yicõri yoyijʉ ĩ ya yutabuju. Ʉ̃mʉa bueri botiro bajiro botiyijʉ. Saya coere rẽto bʉsaro botiyijʉ ĩ ya yutabuju. ");
INSERT INTO myy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ito ĩna tiroca Elías ñayorʉ, ito yicõri Moisés ñayorʉ cʉni goaĩoyijarã Jesús tʉ. Ito bajiri Jesús rãca ĩna bʉsija tiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Itire ticõri bʉto güiyijarã Pedro mesa. Bʉto güicõri queno tʉoĩa masibisijʉ Pedro. Ito bajiri ado bajiro yiyijʉ ĩ: —Tʉoya yʉ Ʉjʉ mʉ. Gʉa adojʉ ñaja quenasacõa. Mʉare wi meni ĩsirʉja gʉa. Mʉre co wi, Moisésre gaje wi, ito yicõri Elíasre gaje wi meni ĩsirʉja gʉa, yiyijʉ Pedro Jesure, queno tʉoĩabiticõri. ");
INSERT INTO myy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ito yija ide buere ruji ejacõri Jesús, Moisés ito yicõri Elíasre cʉni gũmayijʉ. Ito yicõri bueri watojʉ oca ruyuyijʉ: —Ãni, yʉ Macʉti ñami. Ĩre maisacõa yʉ. Ĩre queno tʉoya mʉa, yi ruyuyijʉ oca. ");
INSERT INTO myy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ñajasaroti, ti batocõri Jesure riti tiyijarã ĩna. Gãjerãma ruyubisijarã ĩja. Jesús sĩgʉ̃ti ñayijʉ ĩna rãca. ");
INSERT INTO myy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ito yija tʉria joe ñana roja wayijarã ĩna ʉdiarãti Jesús rãca. Ĩna roja waroca ado bajiro rotiyijʉ Jesús ĩnare: —Jĩjʉ mʉa tigore gãjerãre gotibeja. Yʉ ña Masa Rĩjorʉ. Godacõri mʉcana tʉdi catigʉ yigʉja yʉ. Yʉ tʉdi catiroto riojʉa mʉa tigore gãjerãre gotibeja maji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ĩre queno tʉocõri gãjerãre gotibisijarã ĩna. Ito bajibojarocati ĩnamasiti gãmeri seniĩayijarã: —¿Ñe yireoni ñati? “Godacõri mʉcana tʉdi catigʉ yigʉja yʉ”, yire, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ito bajiri Jesure seniĩayijarã ĩna: —¿No yija, “Cristo ejaroto riojʉa ejagʉ yiguĩji Elías”, yati judio masa rotirise riasori masa? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ito ĩna yija tʉocõri: —Riti ña. Elías ñayorʉ robo bajigʉ cajero ejasʉogʉ yiguĩji. Jeyaro quenorocʉ ejagʉ yiguĩji ĩ. Ito bajibojarocati yʉ Masa Rĩjorʉ ñagʉ̃ quenabeto junirise bʉjagʉ yigʉja. Ito yicõri masa yʉre rʉ̃cʉbʉomenaji. Dios oca tuti ucagore bajiroti yʉre rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Riti mʉare gotia yʉ. Elías ñayorʉ robo bajigʉ iti rʉmʉti ejacoaquĩ ĩja. Ito bajibojarocati masa ĩna ãmoro bajiroti ñeñarise yicã ĩna ĩre. Dios oca tutijʉ ucagore bajiroti rẽtacʉ Elías robo bajigʉre, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ito yija gãjerã ĩ rãca riasotiri masa tʉ tʉdi ejayijʉ Jesús. Itojʉ ejacõri ĩ rãca riasotirã tʉ masa jãjarã ĩna ñaja tiyijʉ Jesús. Ito yicõri judio masa rotirise riasori masa ĩ rãca riasotiri masa rãca ĩna gãmeri bʉsija ti ejayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús ĩ ejaja ticõri, bʉto wanʉyijarã ĩna. Ito bajiri ĩ tʉ ũmaquedi wayijarã senirã warã. ");
INSERT INTO myy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ĩ tʉ ĩna ejarocati seniĩayijʉ Jesús ĩnare: —¿Ĩna rãca ñeonire gãmeri bʉsiri mʉa? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ito ĩ yija tʉocõri, masa watojʉ sĩgʉ̃ ado bajiro cʉdiyijʉ Jesure: —Tʉoya riasogʉ mʉ. Yʉ macʉ ĩ ya ʉsijʉ rʉ̃mʉ́ sãñagʉ̃ ñami ĩ. Ito yicõri bʉsibicʉ ñami ĩ yʉ macʉ. Ito bajiri ĩre mʉ tʉjʉ ãmi wadibʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yʉ macʉ ya ʉsijʉ sãjacõri ĩ quedi quearoca yami rʉ̃mʉ́. Ito yicõri yʉ macʉ ya risere somo jairo budia. Guji cʉni canamʉocõri rujʉ cʉni tutua jedicoami ĩ. Nocõ mejeti rʉ̃mʉ́ ĩ ejajare ito bajiroti baji ñami yʉ macʉ. “Yʉ macʉ ya ʉsijʉ rʉ̃mʉ́ sãñagʉ̃re bucõaña”, yibojabʉ yʉ mʉ rãca riasotirãre. Rʉ̃mʉ́re bucõa masibeama ĩna, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Yʉre tʉorʉ̃nʉmena ña mʉa maji. Yoari mʉa rãca ñaboja yʉ. Ito bajibojarocati yʉre tʉobea mʉa maji, yiyijʉ Jesús ĩ rãca riasotirãre. Yʉ tʉ ãmi waya macʉacãre, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ito ĩ yija tʉocõri, Jesús tʉjʉ ãmi wayijarã ĩre. Jesure ticõri macʉacã ĩ cõ quediroca yiyijʉ rʉ̃mʉ́. Ito bajiri jacajʉ quedi queacõri tunu cũñayijʉ macʉacã. Ito yicõri ĩ ya rise somo budiyijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ito yija Jesús seniĩayijʉ macʉacã jacʉre: —¿Nocõ rodori tʉjati mʉ macʉ ito ĩ bajiroca? yiyijʉ Jesús ĩre. Jesús ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ ĩ: —Jaibicʉacã ñagʉ̃jʉti ito bajisʉoquĩ yʉ macʉ. ");
INSERT INTO myy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Coji meje jeamejʉ ĩre queo tĩayijʉ rʉ̃mʉ́. Ito yicõri ide ñarijʉ cʉni ĩre queo roayijʉ rʉ̃mʉ́ yʉ macʉre sĩarocʉ. Mʉ gʉare ejabʉa ãmojama, gʉare ti maicõri gʉare ejabʉaya mʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ito ĩ yija tʉocõri, ado bajiro yiyijʉ Jesús ĩre: —Mʉ yʉre tʉojama, ñejʉa bʉto josarise manoja, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ ĩ: —“Yʉ macʉre yisio masiguĩji Jesús”, yi tʉoĩa yʉ. Ito bajiri bʉto bʉsa yʉ tʉotoni, yʉre ejabʉaya mʉ, yi bʉsiyijʉ ĩ awasãre rãca Jesure. ");
INSERT INTO myy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ĩ awasãja tʉocõri, jãjarã bʉsa minijuayijarã masa Jesús tʉjʉ. Ito bajija ticõri, ado bajiro rʉ̃mʉ́re oca sẽoro bʉsiyijʉ Jesús: —Tʉoya rʉ̃mʉ́ mʉ. Masa ĩna bʉsibitiroca, ĩna tʉobitiroca cʉni ya mʉ. Ito bajiri macʉacã ya ʉsire budigo rotia yʉ mʉare. Ito yicõri mʉcana tʉdi ĩre sãjabesa mʉ, yiyijʉ Jesús rʉ̃mʉ́re. ");
INSERT INTO myy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ito ĩ yiroca rʉ̃mʉ́ awasãcõri macʉacã ĩ cõ quediroca yiyijʉ ĩ. Ito yicõri ĩ ya ʉsijʉ sãñabojarʉ budigocoayijʉ ĩja. Ĩ budigorocati cõgʉ̃ bajiro bajicoayijʉ macʉacã. Ito bajija ticõri: “Cõcoami”, yiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ito ĩna yibojarocati Jesús macʉacã ya ãmona tʉ̃a wʉmʉoyijʉ ĩre. Ito ĩ yirocati rʉ̃gõcoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ito yija bero wi sãjayijʉ Jesús. Ito ĩ sãja waroca ĩre seniĩayijarã ĩna ĩ rãca riasotiri masa: —¿No yija bucõa masibiti gʉa rʉ̃mʉ́re? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ado bajiro ĩnare cʉdiyijʉ Jesús: —Bamena riti Diore senicõri, ãni rʉ̃mʉ́ robo bajigʉre bucõa masirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Itijʉna wayijarã ĩna Jesús ito yicõri ĩ rãca riasotirã cʉni. Galilea sita ĩna wa rẽtaroca ĩ rãca riasotirãre riasoyijʉ Jesús. Ito bajiro ĩnare ĩ riaso ñarijʉ masa ĩna masire ãmobisijʉ Jesús. —Yʉ ña Masa Rĩjorʉ. Yʉre ñiacõri sĩarã yirãji masa. Godacoagʉ yigʉja yʉ. Ito bajibojagʉti ʉdia rʉmʉ bero tʉdi catigʉ yigʉja yʉ mʉcana, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ĩ gotirisere queno tʉo masibisijarã ĩna. Ito yicõri bʉto Jesure seniĩa güiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Itijʉna wana Capernaumjʉ ejayijarã ĩna. Itojʉ ejacõri wi sãjayijarã ĩna. Iti wijʉ sãjacõri, ado bajiro ĩnare seniĩayijʉ Jesús: —¿Ma wadirã ñeonire gãmeri bʉsiri mʉa? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jesús ĩ seniĩaja tʉobojarãti cʉdibisijarã ĩna. “¿Ñimʉ ñaguĩjida ñasagʉ mani wato?” yi gãmeri bʉsiyijarã ĩna majʉ wadirã. Ito bajiri Jesús ĩ seniĩaja cʉdibisijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ĩna cʉdibejare rujiyijʉ Jesús. Ito bajiro yicõri ĩ rãca riasotirãre jimio jeocõyijʉ Jesús: —Sĩgʉ̃ ñasagʉ ĩ ña ãmoja, “Ñasabicʉ ña yʉ”, yi tʉoĩagʉ̃ yiguĩji ĩ. Ito yicõri masa jeyarore moa ĩsigʉ̃ yiguĩji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ito yija ĩna watojʉ macʉacãre cũyijʉ Jesús. Ito yicõri macʉacãre ãmi jeoyijʉ Jesús. Ito bajiro yicõri ĩnare ado bajiro gotiyijʉ: ");
INSERT INTO myy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—No yʉre rʉ̃cʉbʉogʉ ãni macʉacãre boca ãmigʉ̃ti, yʉre boca ãmigʉ̃re bajiro yami ĩ. No yʉre boca ãmigʉ̃ti yʉ sĩgʉ̃re meje boca ãmiguĩji. Yʉre cõarʉre cʉni boca ãmiami, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ito yija ado bajiro gotiyijʉ Juan Jesure: —Gʉare riasogʉ, tʉoya mʉ. Mʉ wamena sʉoriti rʉ̃mʉ́re bucõagʉ̃re ticʉ gʉa. Ĩ mani rãca ñagʉ̃ meje ñajare, “Yibesa”, yicʉ gʉa ĩre, yiyijʉ Juan Jesure. ");
INSERT INTO myy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Queno yami ĩ. Ito bajiri ĩre rẽobesa, yiyijʉ Jesús. Sĩgʉ̃ yʉre rʉ̃cʉbʉocõri tiyamani ĩ yi ĩoja bero ñeñarise bʉsitubiquĩji yʉre. ");
INSERT INTO myy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ito bajiri manire tʉo tudibicʉ ĩ ñaguĩji mani baba. ");
INSERT INTO myy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Riti mʉare gotia yʉ. Dios ĩ cõarʉ Cristo ña yʉ. Ito bajiri yʉ ñarã mʉa ñajare gãji mʉare ide ĩ ioja ticõri, wanʉgʉ̃ yiguĩji Dios. Ito bajiri mʉare queno ĩ yijare ĩre waja yigʉ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ito yija ĩ rãca riasotirãre ado bajiro gotiyijʉ Jesús: —No macʉacã yʉre tʉorʉ̃nʉsʉogʉre ñeñaro yiroca gãji ĩ yija, ĩre bʉto waja senigʉ̃ yiguĩji Dios. Quenogorama ito bajiro yigʉre ĩ ya ãmʉmajʉ gʉ̃tagã jajoca sia yocõri riaca ʉ̃carojʉ rucõaja quenaroja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Mʉa ñeñaro yirise jidicãña mʉa”, yirocʉ ado bajiro gotiyijʉ Jesús ĩnare: Mʉa ya ãmona ñeñarise mʉa yija itire jatacõña. Manire co dʉja ãmo manija quenabetoja. Ito bajibojarocati jʉa ãmo, ãmo cʉtirã ñabojarãti jeame ʉ̃jʉrojʉ mani waja rẽto bʉsaro quenabeto yiroja. ");
INSERT INTO myy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Itojʉ jeame yatirime meje ñaro yiroja. Ito yicõri co rʉmʉ rʉyabeto rujʉre barã yirãji becoa. ");
INSERT INTO myy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mʉa ya gʉbona ñeñarise mʉa yija itire cʉni jatacõña. Manire co dʉja gʉbo manija quenabetoja. Ito bajibojarocati jʉa gʉbo, gʉbo cʉtirã ñabojarãti jeame ʉ̃jʉrojʉ mani waja rẽto bʉsaro quenabeto yiroja. ");
INSERT INTO myy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Itojʉ jeame yatirime meje ñaro yiroja. Ito yicõri co rʉmʉ rʉyabeto rujʉre barã yirãji becoa. ");
INSERT INTO myy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mʉa ya cajeana ñeñarise mʉa yija itire ruacõña. Manire co dʉja cajea manija quenabetoja. Ito bajibojarocati jʉa cajea, cajea cʉtirã ñabojarãti jeame ʉ̃jʉrojʉ mani waja rẽto bʉsaro quenabeto yiroja manire. ");
INSERT INTO myy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Itojʉ jeame yatirime meje ñaro yiroja. Ito yicõri co rʉmʉ rʉyabeto rujʉre barã yirãji becoa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Mani jea ʉaja, iti juniro bajiro tõbʉjarã yirãji Diore tʉorʉ̃nʉmena. ");
INSERT INTO myy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Quenarise ña moa. Ito bajibojarocati moa ocarise iti jedija mʉcana tʉdi ocabetoja ĩja. Ito bajiri waja mano bajiroti ñaroja moa ĩja. Ito bajiri moa queno ocarise bajiro bajirã ñaña mʉa. Ñe oca manoti ñaña mʉa. Ito yicõri sĩgʉ̃ robo bajiro tʉoĩa ñaña mʉa, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaumjʉ ñacõri Judea sitajʉ wayijʉ Jesús. Ito ejacõri Jordán wame cʉtirisa boejʉajʉ wayijʉ Jesús. Itojʉ masa jãjarã minijuayijarã mʉcana Jesús rãca. Ĩna ejaja ticõri, ĩnare riasoyijʉ Jesús ĩ yisotiro bajiroti. ");
INSERT INTO myy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jesús masare ĩ riaso ñaroca ĩ tʉ ejayijarã fariseo gaye tʉoĩarã. Jesús ĩ tʉo wisajaro yirona ado bajiro ĩre seniĩayijarã ĩna: —¿Ʉ̃mʉgʉ̃ ĩ manojore cõaja, ñeñarise ñati iti? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ito ĩna yija ado bajiro cʉdiyijʉ Jesús: —¿No bajiro mʉare rotiyijari Moisés ñayorʉ? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijarã ĩna: —Ado bajiro gotiyijʉ Moisés ñayorʉ: “Sĩgʉ̃ manojore ĩ cõa ãmoja papera ucarʉja. ‘Yʉ manojo te ñamo. Ito bajiri isore cõagʉ̃ ya yʉ’, yire papera uca tĩocõri, isore cõagʉ̃ yiguĩji ĩ”, yiyijʉ Moisés ñayorʉ, yiyijarã fariseo gaye tʉoĩarã Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ito ĩna yija tʉocõri, ado bajiro yiyijʉ Jesús: —Mʉa ya ʉsijʉ tʉo terã mʉa ñajare manojore cõare gaye rẽobisijʉ Moisés. ");
INSERT INTO myy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jane mejejʉ cajero masare rujeosʉogʉ ʉ̃mʉgʉ̃ ito yicõri romiore cʉni rujeoyijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ito bajiri manojo bʉjacõri ricati ñagʉ̃ yiguĩji ʉ̃mʉgʉ̃ ĩ manojo rãca. Ito bajiri jacʉsabatia tʉ bʉtogoroama ñasabiquĩji ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ito yicõri manojo rãca jʉ̃arã ñabojarãti sĩgʉ̃re bajiroti ñarãji ĩna. Ito bajiri jʉ̃arã meje ñarãji. Sĩgʉ̃ bajiroti ñacõrãji ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Manojore ãmo siaja bero sĩgʉ̃re bajiroti ñama ĩna, Dios ĩ tiro riojo. Ito bajiri manojore cõare ma ĩja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wijʉ sãja wacõri Jesure ĩ gotirisere seniĩayijarã ĩna ĩ rãca riasotiri masa. ");
INSERT INTO myy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ito ĩna yijare ado bajiro cʉdiyijʉ Jesús: —No manojore cõagʉ̃ quenabeami. Ito yicõri gajeo ĩ manojo cʉtija rocati yigʉ bajiro yami ĩ. Cajero ĩ manojo cʉtisʉogore ñeñaro yigʉ yami ĩocʉ̃. ");
INSERT INTO myy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ito bajiroti romio cʉni, iso manʉjʉre cõagõ quenabeamo. Ito yicõri gãji iso manʉjʉ cʉtija rocati ajego bajiro yamo iso. Cajero iso manʉjʉ cʉtisʉogʉre ñeñaro yigo yamo iso, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Rĩacare tʉ̃a wadiyijarã masa Jesús tʉjʉa. Rĩacare ĩ moaĩare ãmoyijarã masa. Ito bajiro ĩna yija ticõri, ado bajiro yiyijarã Jesús rãca riasotiri masa: —Jesure ʉsirioro yibesa mʉa, yiyijarã ĩna masare. ");
INSERT INTO myy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Itire ticõri junisiniyijʉ Jesús. Ito bajiri ĩ rãca riasotirãre ado bajiro gotiyijʉ Jesús: —Rĩacare rẽobesa, yʉ tʉ wadijaro ĩna. Rĩaca ñama yʉre queno tʉorʉ̃nʉrã. Ĩna robo yʉre queno tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Riti mʉare gotia yʉ. Rĩaca queno cʉdi ãmoama Dios ĩ rotirisere. No rĩaca ĩna cʉdiro bajiro cʉdibicʉ Dios ĩ rotirojʉ ejabiquĩji, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ito yicõri rĩacare ãmi jeoyijʉ Jesús. Ito bajiro yicõri ĩ ya ãmona ĩnare moa jeoyijʉ. Ito yicõri: “Queno yijaro Dios mʉare”, yiyijʉ Jesús rĩacare. ");
INSERT INTO myy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Itijʉna Jesús ĩ wasʉorocati ĩ tʉjʉ ũmaquedi ejayijʉ ʉ̃mʉgʉ̃. Jesús riojo ejacõri rijomunigãna ñini rũjũyijʉ ĩ: —Tʉoya Riasogʉ mʉ. Quenagʉ̃ ña mʉ. Dios rãca catitĩña ãmoa yʉ. ¿No bajiro yigʉti yʉ Dios rãca catitĩñarocʉ? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —¿No yija, “Quenagʉ̃ ña mʉ”, yati mʉ yʉre? Dios sĩgʉ̃ti ñami quenagʉ̃. ");
INSERT INTO myy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dios ĩ rotirisere masia mʉ. Ado bajiro gotia iti: “Masare sĩabesa. Manojo cʉtigʉ gajeo rãca ajebesa. Rinibesa. Gãjire bʉsitubesa. Gãjerãre rʉobesa. Mʉ jacʉ, mʉ jacore cʉni queno rʉ̃cʉbʉoya”, yi gotia Dios oca. Itire masia mʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ito ĩ yija tʉocõri, ado bajiro yiyijʉ: —Tʉoya Riasogʉ mʉ. Dios ĩ rotirisere masicõri mamʉ ñagʉ̃jʉti queno cʉdicʉ yʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ito ĩ yija tʉocõri, ĩre ti maiyijʉ Jesús: —Coji gaye mʉ yiroti rʉya maji. Mʉ ya gajeoni gãjerãre ĩsi jeocõña. Iti waja bʉjacõri bojoro bʉjarãre ĩsiña. Mʉ ito yija ũmacʉ̃jʉ Dios tʉ ejacõri jairo waja bʉjagʉ yigʉja mʉ. Ito bajiri yʉ gotirisere cʉdiya. Ito yicõri yʉ rãca waya, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ito bajiro Jesús bʉsija tʉocõri, bojori bʉjayijʉ ĩ. Gajeoni jaigʉ ñacõri itire bʉto maiyijʉ ĩ. Ito bajiri Jesús bʉsire tʉocõri bojori bʉjagʉti wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ito yija Jesús ĩ rãca riasotirãre ti batocõri ado bajiro bʉsiyijʉ: —Gajeoni jairãre josari ñaro yiroja Dios ĩ rotirojʉ ĩna ejaroto, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ito bajiro ĩ yija tʉocõri, ʉcayijarã ĩ rãca riasotiri masa. Ito bajiri mʉcana ĩnare goti remoyijʉ Jesús: —Tʉoya yʉ rĩa mʉa. Gajeonire riti tʉoĩarãre josari ñaroja ĩnare Dios ĩ rotirojʉ ĩna ejaroto. ");
INSERT INTO myy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gawa jota gojere camello ĩ rẽta wa ãmobojaja josari ñaroja ĩre. Ito bajibojarocati gajeoni jaigʉ Dios ĩ rotirojʉ ĩ wa ãmobojaja josari bʉsa ñaroja ĩre, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ito bajiro ĩ bʉsija tʉocõri, bʉto oca jaiyijarã ĩna. Ito bajiri ĩnamasiti gãmeri seniĩasʉoyijarã: —Riti ĩ yijama, sĩgʉ̃ Dios tʉ ejabiquĩji, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ito yija Jesús ĩnare ti maicõri, ado bajiro ĩnare gotiyijʉ: —Masa eja masiado manoja. Josari ñaroja ĩnare. Dios sĩgʉ̃ti jeyaro masigʉ̃ ñami. Ñejʉa josarise manoja ĩre, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jesús ito yija tʉocõri, Pedro cʉdiyijʉ ĩre: —Queno tʉoya mʉ. Gʉa ya gajeonire jidicãcõri mʉre sʉya gʉa, yiyijʉ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ito ĩ yija ado bajiro cʉdiyijʉ Jesús: —Riti mʉare gotia yʉ. Gãjerãre Dios oca gotirona yʉre sʉyacõri ĩna ñarãre cũ warã yirãji coriarã. Ĩna ocabajirã, ĩna jacʉ, ĩna jaco, ĩna rĩa ito yicõri ĩna ya wesecare cʉni cũ warã yirãji ĩna yʉre sʉyarona. Ito bajiro yirãji ĩna gãjerãre Dios oca goti ãmorã. No yʉre sʉya ãmocõri ĩ ñarãre cũ wacʉre, queno yigʉ yiguĩji Dios ĩre. Jaje wiri, wesecari, ocabajirã, jacosaromia ito yicõri rĩa jãjarã ĩsigʉ̃ yiguĩji Dios ĩre. Ito bajibojarocati yʉre sʉyacõri quenabeto tõbʉjagʉ yiguĩji ĩ. Ito bajicõri ija catitĩñare ĩsigʉ̃ yiguĩji Dios ĩre. ");
INSERT INTO myy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Coriarã adocãta ñasari masa ñabojarãti, ija Dios tʉ ejacõri ñasari masa meje ñarã yirãji ĩna. Gãjerãma adocãta ñasarã meje ñabojarãti ija Dios tʉ ejacõri ñasari masa ñarã yirãji ĩna, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalénjʉ wara mana wayijarã ĩna. Ĩ rãca riasotirã riojʉa wayijʉ Jesús. Ito ĩre ĩna sʉya waroca tʉoĩa oca jaiyijarã ĩna. “¿No yija Jerusalénjʉ ĩ waja güibeati Jesús?” yi tʉoĩayijarã ĩna. Ĩna bero sʉyarãma bʉto güiyijarã. Masa ĩna güija ticõri, ricati ĩ rãca riasotirãre goti remosʉsayijʉ Jesús ĩ godaroti gaye: ");
INSERT INTO myy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Queno tʉoya mʉa. Jerusalénjʉ warã ya mani. Itojʉ Masa Rĩjorʉ yʉ ñajare yʉre ñiarã yirãji masa. Paia ʉjarã ito yicõri judio masa rotirise riasori masare cʉni ĩsirona yʉre ñiarã yirãji ĩna. Ito bajiri yʉre boca ãmicõri sĩa rotirã yirãji ĩna. “Ĩmo ĩre sĩaña”, yirã yirãji ĩna gawa masare. ");
INSERT INTO myy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ito yicõri yʉre aja tudirã yirãji ĩna. Yʉre go ide eobate gurã yirãji ĩna. Yʉre bajerã yirãji ĩna. Ito yicõri yʉre sĩarã yirãji ĩna. Ito bajibojarocati ʉdia rʉmʉ bero tʉdi catigʉ yigʉja yʉ mʉcana, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ito yija Zebedeo rĩa Juan, Santiago cʉni eja rʉ̃gʉ̃yijarã ĩna Jesús tʉ: —Tʉoya Riasogʉ mʉ. “Ado bajiro gʉare queno yiya”, mʉre gʉa senija mʉ cʉdire ãmoa gʉa, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ito ĩna yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —¿No bajiro yʉ yire ãmoati mʉa? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Mʉ rotirojʉ gʉa ejaroca mʉ rãca gʉare ruji rotiba mʉ. Sĩgʉ̃re mʉ riojocadʉjajʉ ito yicõri gãjire mʉ gãcodʉjajʉ mʉ ruji rotire ãmoa gʉa, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ito ĩna yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Mʉa yʉre senibojarisere queno tʉo masibea mʉa. Quenabeto yʉ tʉoĩaroca yirã yirãji masa yʉre. ¿Yʉre bajiroti quenabeto tʉoĩa ñemecʉti masirã yirãjida mʉa cʉni? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Ñemecʉticõrãji gʉa, yiyijarã ĩna Jesure. Ito ĩna yija ado bajiro yiyijʉ Jesús: —Riti mʉare gotia yʉ. Quenabeto yʉ tʉoĩaro bajiroti quenabeto tʉoĩarã yirãji mʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ito bajibojarocati yʉ rãca mʉare ruji roti masibea yʉ. Yʉ riojocadʉja, gãcodʉja cʉni Dios sĩgʉ̃ti yʉ tʉ rujironare rotigʉ yiguĩji. Itojʉ rujiado ĩnare queno ĩsigʉ̃ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ito bajiro ĩna bʉsija, gãjerã Jesús rãca riasotirã jʉa dʉjamocõ ñarã tʉoyijarã. Ito bajiri ĩnare tʉocõri Juan, Santiagore cʉni junisini tiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ito bajija ticõri, ĩnare jimioyijʉ Jesús: —Wi ʉjʉ sĩgʉ̃ ĩ ñaja iti wi gãnare roti masiguĩji. Ito bajiroti masa ʉjʉ sĩgʉ̃ ĩ ñaja wi ʉjarãre roti masiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ĩnare bajiro bajibitirʉja mʉare. Ado robojʉa bajia. Mʉa wato no ʉjʉ ña ãmogʉ̃ti gãjerãre moa ĩsija quena. ");
INSERT INTO myy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","No ñasagʉ ña ãmogʉ̃ti gãjerãre ejabʉaja quena. Ĩnare moa ĩsiri masʉ robo bajiroti ĩ moa ĩsija quena. ");
INSERT INTO myy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yʉ ña Masa Rĩjorʉ. Masa yʉre moa ĩsijaro yirocʉ meje wadicʉ yʉ adi sitajʉ. Masare ejabʉarocʉ wadicʉ yʉ. Masare goda ĩsirocʉ wadicʉ yʉ. Ito yicõri ĩna ñeñaro yirise waja, waja yi ĩsirocʉ wadicʉ yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mʉcana wacõri Jericó wame cʉtiri cʉtojʉ ejayijʉ Jesús ĩre sʉyarã rãca. Iti cʉtojʉ Jesús ĩ budiroca ĩ rãca riasotirã rãca, masa gãjerã sʉyayijarã ĩre. Ĩna wari ma tʉ rujiyijʉ tibicʉ, Bartimeo wame cʉtigʉ. Timeo macʉ ñayijʉ ĩ. Gajeoni macʉ ñari gãjerã ĩre queno yitoni bʉto josayijʉ Bartimeo. ");
INSERT INTO myy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesús Nazaret gagʉ ĩ rẽta waja tʉocõri, bʉto awasãre rãca ĩre jiyijʉ tibicʉ: —Tʉoya Jesús mʉ. David ñayorʉ janerãbatia janami ña mʉ. Yʉre ti maiña mʉ, yiyijʉ tibicʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ito bajiro ĩ yija tʉocõri, jãjarã ĩre tudiyijarã tibicʉre: “Bʉsibesa mʉ”, yiyijarã masa ĩre. Ito bajiro ĩna yibojarocati bʉto bʉsa awasãyijʉ mʉcana: —Tʉoya David janami mʉ. Yʉre ti maiña mʉ, yiyijʉ tibicʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ito bajiro tibicʉ ĩ yija tʉocõri, tuja rʉ̃gʉ̃coayijʉ Jesús ĩja. —Ĩre jiya mʉa, yiyijʉ Jesús masare. Ito ĩ yija tibicʉre jiyijarã ĩna: —Wanʉ oca sẽoña. Ito yicõri wʉmʉ rʉ̃gʉ̃ña. Jesús mʉre jiami, yiyijarã masa tibicʉre. ");
INSERT INTO myy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ito bajiro ĩna yija tʉocõri, Jesús tʉjʉ warocʉ yutabuju joegadore ruacõri bubu quedi rʉ̃gʉ̃ wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ĩ ejaja ticõri, ado bajiro yiyijʉ Jesús ĩre: —¿No bajiro yʉ yire ãmoati mʉ? yiyijʉ Jesús ĩre. —Tʉoya Riasogʉ mʉ. Yʉ ya cajea ruyubea yʉre. Ti ãmoa yʉ, yiyijʉ tibicʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ito yija ado bajiro ĩre cʉdiyijʉ Jesús: —Wasa mʉ. “Jesús yʉre yisiocõgʉ̃ yiguĩji”, mʉ yi tʉoĩajare mʉre yisioa yʉ, yiyijʉ Jesús tibicʉre. Ito bajiro Jesús ĩ yirocati ticoayijʉ tibitibojarʉ ĩja. Ito bajiri Jesure sʉya wayijʉ ĩ tibitija bero ticõri. ");
INSERT INTO myy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalén sõjʉa bʉsa Olivos wame cʉtiri tʉria tʉ ejayijarã. Itojʉ jʉa cʉto ñayijʉ. Betfagé, Betania wame cʉtiri cʉtori ñayijʉ iti tʉria tʉ. Ito tʉ bʉsa ejacõri ĩ rãca riasotiri masa jʉ̃arãre cõayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ado bajiro gotiyijʉ Jesús ĩnare: —Mani riojo ñari cʉtojʉ wasa. Itojʉ burro macʉ sia rʉ̃gõrʉre bʉjarã yirãji mʉa. Noa masa mʉja jeaĩa yiya macʉ ñaguĩji maji. Ĩre õjama. Ito yicõri ĩre ãmi wadiba. ");
INSERT INTO myy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Gãjerã mʉare seniĩaja: “¿No yirã ĩre ãmi wati mʉa?” ĩna yija, ado bajiro cʉdiba mʉa: “Mani Ʉjʉ ãmoami ĩre. Ito bajiri ãmi wajʉ gʉa. Nocõ mejeti jʉda cõagʉ̃ yiguĩji mʉcana”, yi gotiba, yiyijʉ Jesús ĩna jʉ̃arãre. ");
INSERT INTO myy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ito ĩ yija tʉocõri, wayijarã ĩna. Ito ejacõri majʉ ĩna sia rʉ̃gõrʉre ti bʉjayijarã ĩna. Soje tʉti rʉ̃gõyijʉ ĩ. Ĩre bʉjacõri õjayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Itojʉ ñarã ĩnare ado bajiro seniĩayijarã: —¿No yirona yati mʉa? ¿No yija burro macʉre õjati mʉa? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ito ĩna yija tʉocõri, Jesús ĩ rotiado bajiroti cʉdiyijarã ĩna. Ito bajiri itijʉ gãna Jesús rãca riasotirãre wa rotiyijarã. ");
INSERT INTO myy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ito yija burro macʉre ãmi wayijarã Jesús tʉjʉ. Ito yicõri ĩna ya yutabujuri burro macʉ joejʉ jeoyijarã. Ĩ tʉ ĩna ãmi ejarocati burro joejʉ mʉja jeayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jãjarã masa ĩna ya yutabujuri ruacõri ĩ riojʉa yutabujuri eyocũ yuyijarã ĩna. “Gʉa Ʉjʉ ña mʉ”, yirona ito bajiro yiyijarã masa Jesure rʉ̃cʉbʉorã. Gãjerã mimi caeri jatacõri jidicũ yuyijarã ĩ cʉdatoni. ");
INSERT INTO myy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesús riojʉa ũmatʉ̃arã cʉni ĩ berojʉa sʉyarã cʉni ruje awasãyijarã masa wanʉ quenarã: —Dios sĩgʉ̃ti ñami quena bʉsagʉ. Dios Macʉ ĩ cõarʉ Ʉjʉ quenagʉ̃ ñami ĩ. ");
INSERT INTO myy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mani ñicʉ David ñayorʉ ĩ rotija quena ñayijʉ. Ito bajiroti quenari rodo ñaro yiroja mʉcana. Dios sĩgʉ̃ti ñami quena bʉsagʉ, yiyijarã ĩna wanʉ quenarã. ");
INSERT INTO myy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ito bajiro ĩna yiroca riti Jerusalénjʉ ejayijʉ Jesús. Ito ejacõri Dios ya wi sãjayijʉ ĩ. Jeyaro ti batoyijʉ Jesús. Ito bero iti rãioja ticõri, Betaniajʉ tʉdi wayijʉ Jesús ĩ rãca riasotirã rãca. Jʉa gʉbojeno ñayijarã ĩna, ĩ rãca riasotirã. ");
INSERT INTO myy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gaje rʉmʉ Betaniana wayijarã ĩna. Ĩna waroca Jesús ñiocõyijʉ. ");
INSERT INTO myy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sõjʉna higuera wame cʉtiricʉ tiyijʉ Jesús. Rãjagʉ̃ robo bajiricʉ ñacʉ higuera wame cʉtiricʉ. Queno jũ cʉtiyijʉ. Ito bajiri tigʉ wayijʉ Jesús higueragʉ ricare barocʉ. Ito bajibojarocati higueragʉ tʉ ejacõri jũ riti bʉjayijʉ Jesús. Rica mañijʉ cʉma meje ñajare. ");
INSERT INTO myy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Itigʉ rica manija ticõri, ado bajiro yiyijʉ Jesús itigʉre: —Mʉ ya ricare tʉdi bamenaji masa. Rica mano yiroja ĩja, yiyijʉ Jesús itigʉre. Ito bajiro ĩ bʉsija tʉoyijarã ĩ rãca riasotirã. ");
INSERT INTO myy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalén tʉdi ejacõri Dios ya wi sãjayijʉ Jesús ĩ rãca riasotirã cʉni. Ito sãja ejacõri ito waja gãme ñarãre bucõayijʉ Jesús. Niyeru wasoarãre ĩna ya niyeru jeoado tujʉda queoyijʉ Jesús. Ito yicõri buja waja gãmerã ye ĩna ya cumurori tujʉda cõayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ito bajiri Dios ya wijʉ gajeoni ãmi wa rotibisijʉ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ito yicõri ado bajiro masare riasoyijʉ: —Ĩ oca tutina ado bajiro gotiami Dios: “Yʉre rʉ̃cʉbʉora wi ñaro yiroja yʉ ya wi. Masa jeyaro yʉre bʉsirã yirãji iti wijʉ sãjacõri”, yi gotia Dios oca. Ito bajiro mʉa yija riniri masa ĩna rudiri wi bajiro godo weoa mʉa Dios ya wire, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ito bajiro Jesús ĩ yija tʉocõri, “¿No bajiro ĩre sĩarʉjati mani?” yi tʉoĩayijarã paia ʉjarã, judio masa rotirise riasori masa cʉni. Masa jeyaro ĩre riti ĩna tʉorʉ̃nʉjare, ito bajiro tʉoĩayijarã ĩna, Jesure güirã. ");
INSERT INTO myy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Rãiocũro ñaroca iti cʉtore wayijʉ Jesús ĩ rãca riasotirã rãca. ");
INSERT INTO myy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gaje rʉmʉ busuri jĩjʉ mʉcana mana warã higuera wame cʉtiricʉ tʉ ejayijarã ĩna. Ito ejacõri higueragʉ iti siniaja tiyijarã ĩna. Ñe mari cʉni siniacoayijʉ itigʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Itocõti Jesús ĩ bʉsigore tʉoĩa bʉjayijʉ Pedro: —Tiya gʉare Riasogʉ mʉ. Itigʉre mʉ rojaja bero sinicoayija itigʉ ĩja, yiyijʉ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ito ĩ yija tʉocõri, ado bajiro gotiyijʉ Jesús ĩ rãca riasotirãre: —Diore mʉa tʉorʉ̃nʉja quena. “Diore gʉa senija cʉdigʉ yiguĩji”, mʉa yi tʉoĩaja quena, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Riti mʉare gotia yʉ. Diore tʉorʉ̃nʉcõri, i tʉriare, “Cʉní rʉ̃gʉ̃cõri riaca jajosajʉ quedi roaya”, mʉa yija ito bajiroti rẽtaro yiroja. Diore senicõri, “Yʉ senirise cʉdibiquĩji Dios”, yi tʉoĩabesa mʉa. Diore senicõri, “Yʉ senirise cʉdigʉ yiguĩji Dios”, yi tʉoĩaña mʉa. Mʉa ito yijati ito bajiroti rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ito bajiri Diore senicõri: “Yʉre cʉdicãñi ĩ”, yi tʉoĩaña mʉa ya ʉsina. Mʉa ito yijati mʉare cʉdigʉ yiguĩji Dios. Ito yicõri mʉa ãmorise mʉare ĩsigʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Diore bʉsirãti, gãjerã ñeñaro ĩna yirise ãcabojoja quena. Ito bajiro mʉa yijati, mani Jacʉ ũmacʉ̃jʉ gagʉ mʉa ñeñaro yirisere ãcabojogʉ yiguĩji ĩ cʉni. ");
INSERT INTO myy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ito bajibojarocati mʉare gãjerã ĩna ñeñaro yirisere mʉa ãcabojobeja, mani Jacʉ ũmacʉ̃jʉ gagʉ mʉa ñeñaro yirise ãcabojobiquĩji ĩ cʉni, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ito yija bero Jerusalénjʉ tʉdi wayijʉ Jesús ĩ rãca riasotirã rãca. Itojʉ ejacõri Dios ya wi wayijʉ Jesús. Ito ĩ ña ucurocati ĩ tʉ eja rʉ̃gʉ̃yijarã paia ʉjarã, judio masa rotirise riasori masa ito yicõri judio masa bʉcʉrã cʉni. ");
INSERT INTO myy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ito ejacõri ado bajiro Jesure seniĩayijarã ĩna: —¿Dios ya wijʉ masare mʉ bucõaja, ñimʉ roticati mʉre? ¿Ito yicõri ñimʉ ĩ rotirise rãca ito bajiro yicati mʉ? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ito ĩna yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Yʉ cʉni coji gaye mʉare seniĩa ãmoa. Mʉa yʉre cʉdija tʉocõri, yʉre rotigʉ wame gotigʉ yigʉja yʉ mʉare. Ado bajiro mʉare seniĩa yʉ: ");
INSERT INTO myy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Juan masare idé gutoni, ñimʉ rotiyijari ĩre? ¿Dios rotiyijarite ĩre? ¿Masajʉa rotiyijarite? Yʉre cʉdiya mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ito ĩ yija tʉocõri, ĩnamasiti gãmeri tʉoĩa bʉsiyijarã: —¿No bajiro ĩre cʉdirãti mani? “Juan masare idé gutoni cõayijʉ Dios”, mani yija, “¿No yija Juanre tʉobiticati mʉa?” manire yigʉ yiguĩji Jesús. ");
INSERT INTO myy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ito bajibojarocati, “Masa rotiyijarã Juanre”, mani yija, manire junisinirã yirãji masa. “Juanre cõayijʉ Dios”, masa ĩna yi tʉoĩajama, ¿no bajiro Jesure cʉdirã yirãjida mani? yi tʉoĩayijarã paia ʉjarã. ");
INSERT INTO myy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ito bajiri: —Masibea gʉa, yiyijarã ĩna Jesure. Ito ĩna yijare: —Baʉ, yʉre rotirʉ wame gotibicʉja yʉ cʉni mʉare, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Goti masiore ocana ado bajiro masare riasoyijʉ Jesús: —Sĩgʉ̃ ʉyé wese oteyijʉ ĩ. Ito yicõri masa ĩna rinime yirocʉ camotayijʉ ĩ wesecare. Ito yicõri ʉyére wañiaroti goje meniyijʉ ʉyé idere ñurocʉ. Ito yicõri ũmari wi meniyijʉ ĩ ya wesecare, tirʉ̃nʉcʉja, yiroca. Ito yija bero gãjerãre ado bajiro gotiyijʉ ĩ: “Yʉ ya wesecare mʉa codeja mʉare waja yigʉ yigʉja yʉ”, yiyijʉ ĩ ĩnare. Ito yicõri wa ucugʉ wacoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yoa bʉsarijʉ ʉyé rica bʉcʉaroca ĩ ya moari masʉre cõayijʉ ʉyé ĩre ãmi ĩsitoni. ");
INSERT INTO myy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ʉyé wesejʉ ĩ ejaroca ĩre ñiacõri jayijarã weseca coderi masa. Ĩre ʉyé ĩsimenati, “Wasa”, yiyijarã ĩna. Ito bajiri ñe manoti tʉdi ejayijʉ ĩre roti ñucarʉ tʉ. ");
INSERT INTO myy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ʉyé ĩ ãmibeja ticõri, gãji moari masʉre cõayijʉ weseca ʉjʉ, ʉyé ĩre ãmi ĩsitoni. Ʉyé wesejʉ ĩ ejaja ticõri, ĩre cʉni jayijarã ĩna. Ito bajiri ĩ ya rijogajʉ cami cʉtiyijʉ ĩ. Ito bajiro ĩre yicõri ñeñaro bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ito bajiro ĩre ĩna yija ticõri, mʉcana gãjire cõayijʉ iti wese ʉjʉ. Ĩ ejaja ticõri, ĩre sĩayijarã weseca coderi masa. Ito bajiri jãjarã bʉsa cõayijʉ iti wese ʉjʉ ĩja. Ĩnare cʉni ito bajiroti yiyijarã weseca coderi masa. Coriarãre bʉto jayijarã. Gãjerãre sĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Sĩgʉ̃ macʉ cʉtiyijʉ iti wese ʉjʉ. Ĩre bʉto maiyijʉ ĩ. “Yʉ macʉre rʉ̃cʉbʉorã ĩre tʉorã yirãji ĩna”, yi tʉoĩayijʉ ĩ. Ito bajiri ĩ macʉre cʉni cõasʉsayijʉ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ito bajiri weseca ʉjʉ macʉ ĩ ejaja ticõri, ado bajiro gãmeri bʉsiyijarã weseca coderi masa: “Adi wese ʉjʉ macʉ ñami ãni. Ĩ jacʉ godaja bero adi wese ĩ ya wese ñaro yiroja. Ĩre sĩato mani adi wese ʉjarã ñarona. Ito bajiri mani ĩre sĩaja bero mani ya wese ñaro yiroja ĩja”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ito bajiri ĩre ñiacõri sĩayijarã ĩna. Ito yicõri ĩ ya rujʉre weseca tʉnimajʉ cõayijarã ĩna. Itocõti ña adi oca, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ito bajiro ĩnare goti tĩocõri, ado bajiro seniĩayijʉ Jesús masare: —¿No yigʉ yiguĩjida weseca ʉjʉ ĩnare? Ado bajiro yigʉ yiguĩji ĩ. Weseca coderãre sĩagʉ̃ wacʉ yiguĩji ĩ. Ito yicõri gãjerãre weseca code rotigʉ yiguĩji ĩ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gaje ado bajiro gotiyijʉ Jesús: —¿Dios oca tutire tiĩabeati mʉa? Tʉoya mʉa ado bajiro gotia: Gʉ̃ta wi meniri masa coga gʉ̃tagã cõayijarã ĩna. Ito bajibojarocati gaje gʉ̃ta rẽto bʉsaro quenarica ñayijʉ ĩna cõabojaraga. Itiga gʉ̃tagãna sʉoriti quenari wi menigʉ̃ yiguĩji Dios. Itiga gʉ̃tagã manija, ñe menire manoja ĩja. ");
INSERT INTO myy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ito bajiro ãmoñi Dios mani Ʉjʉ. Ito bajiri itire masicõri bʉto tʉoĩa wanʉa mani, yi gotia Dios oca. Ito bajiro yiñi Dios yʉre rẽtaroti tʉoĩa yugʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ito bajiro Jesús ĩ yija tʉocõri, ĩre ñia ãmobojayijarã iti cʉto ñari masa. “ ‘Ito bajirã ñama ĩna’, manire yirocʉ iti ocare gotimi Jesús”, yi tʉoĩayijarã ĩna. Ito bajibojarocati masare güirã Jesure ñiabisijarã ĩna. Ito bajicõri itijʉna wacoayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fariseo gaye tʉoĩarã, Herodes ĩ baba mesa cʉni ejayijarã ĩna Jesús tʉjʉ. Ĩna ʉjarã rotija tʉocõri, Jesús tʉ wayijarã ĩna. “Jesús ĩ cʉdi masibeja, ĩre oca meni masirã yirãji mani”, yi tʉoĩacõri ĩ tʉ ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ĩ tʉ ejacõri ado bajiro yiyijarã ĩna: —Tʉoya Riasogʉ mʉ. Riojo gotigʉ ña mʉ. Masa mʉre bʉsituja guijobea mʉre. “Masa jeyaro coro bajiroti ñama”, yi tʉoĩa mʉ. Dios ĩ gotirisere riojo riasogʉ ña mʉ. Riojo gotigʉ mʉ ñajare mʉre seniĩa gʉa: “¿Roma cʉto gagʉ ʉjʉre ĩ rotiado bajiroti ĩre gʉa waja yija quenati? ¿Ĩre gʉa waja yibeja cʉni quenatite?” yi seniĩayijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ĩna tʉoĩarise masiyijʉ Jesús. Ito bajiri ado bajiro ĩnare cʉdiyijʉ ĩ: —¿No yija yʉre rʉo ãmoati mʉa? Niyeru cuji yʉre ãmi ĩsitẽña. Tirocʉ ya yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ito ĩ yija tʉocõri, niyeru cuji ĩre ãmi ĩsiyijarã ĩna. Iti cujire ticõri ado bajiro ĩnare seniĩayijʉ Jesús: —¿Ñimʉ ya rio ñati mʉa tija? Ito yicõri, ¿ñimʉ wame ucare wãñati ado? yiyijʉ Jesús ĩnare. Ito yija ado bajiro Jesure cʉdiyijarã ĩna: —Ʉjʉ César ya rio bajiro bajia, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ĩna ito yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —César ye iti ñajama ĩre ĩsija quena. Ito yicõri Dios ye iti ñaja cʉni ĩre ĩsija quena, yiyijʉ Jesús ĩnare. Ito bajiro Jesús ĩ yija tʉo ʉcayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ito yija saduceo gaye tʉoĩarã coriarã Jesure tirona ejayijarã ĩna. “Masa ĩna godaja tʉdi catire ma”, yi tʉoĩarã ñayijarã saduceo gaye tʉoĩarã. Ito bajiri Jesure seniĩarona ejayijarã ĩna ĩ tʉ: ");
INSERT INTO myy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tʉoya Riasogʉ mʉ. Ado bajiro manire ucañi Moisés ñayorʉ: “Rĩjorʉ ñasʉogʉ rĩa macʉti ĩ manojore ĩ godagoja ĩ ocabaji manojo cʉti wasoaja quena. Ito bajiro yigʉti ĩ rĩjorʉ ñabojarʉre rĩa cʉti ĩsigʉ̃ yiguĩji”, yi ucañi Moisés ñayorʉ, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ito bajiri mʉcana gaje oca goti remoyijarã ĩna Jesure: —Jane mejejʉ sĩgʉ̃ ñayijʉ. Co ãmojeno ñarã ocabajirã cʉtiyijʉ ĩ. Cajero manojo cʉtisʉoyijʉ ñasʉogʉ. Rĩa macʉti ĩ manojore godagocoayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ito bajiri manʉjʉ godagorore manojo cʉtiyijʉ ĩ bero gagʉ mʉcana. Ito yicõri ĩ cʉni rĩa macʉti cõcoayijʉ. Ito bajiri ĩ bero gagʉ iso rãcati manojo cʉtiyijʉ mʉcana. ");
INSERT INTO myy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ito bajiroti ñasʉogʉ ñajacʉ ĩ ocabaji mesa ĩna jeyaro isore manojo cʉtibojayijarã ĩna. Iso rãca rĩa cʉtimena riti goda jedicoayijarã ĩna. Ĩna goda jedija berojʉ godayijo ĩna manojo ñabojaro ĩja. ");
INSERT INTO myy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Masa ĩna godaja mʉcana tʉdi catirã yirãji”, ya mʉ. Riti mʉ gotija, ¿ñimʉ rãca manʉjʉ cʉtigo yigõjida iso mʉcana tʉdi caticõri? Ĩna jeyaro manojo ñañi iso, yiyijarã saduceo gaye tʉoĩarã Jesure. ");
INSERT INTO myy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ito ĩna yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Dios oca tutire masibea mʉa. Ĩ masirisere cʉni masibea mʉa. Ito bajiri masibiticõri, wisa mʉa. ");
INSERT INTO myy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tʉdi catirã yirãji masa Dios tʉ cati ñarona. Itojʉ manojo cʉtimenaji masa. Ũmacʉ̃jʉ Dios ñaro gãna ángel mesa robo bajirã ñarã yirãji masa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ito yija gaje goti remoyijʉ Jesús ĩnare: “Godabojarãti mʉcana tʉdi catirã yirãji masa. ¿Moisés ñayorʉ ĩ ucare tiĩabeati mʉa? Yucʉ ʉ̃jʉricʉ watojʉ Dios ĩ bʉsire ruyuyijʉ Moisésre. Ado bajiro Moisésre bʉsiyijʉ Dios: ‘Abraham ñayorʉ yʉre rʉ̃cʉbʉogʉ yami. Isaac ñayorʉ ito yicõri Jacob ñayorʉ cʉni yʉre rʉ̃cʉbʉorã yama ĩna’, yiyijʉ Dios Moisés ñayorʉre. ");
INSERT INTO myy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","‘Ĩna ʉdiarã yʉre rʉ̃cʉbʉorã yama’, Dios ĩ yija, catiri seyoama ĩna. Dios tʉjʉ ñarãji ĩna. Godarã meje ñama ĩna. Bʉto tʉoĩa wisa mʉa”, yiyijʉ Jesús saduceo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Judio masa rotirise riasori masʉ Jesús rãca ĩna bʉsiroca tʉo ñayijʉ ĩ. Ito bajiri, “Queno cʉdiami Jesús”, yi tʉo ñayijʉ ĩ. Ito bajiri Jesús tʉjʉa wayijʉ ĩ ĩja ĩre seniĩarocʉ: —¿Disejʉa ñati Dios rotirise ñasarise? yi seniĩayijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ito yija ado bajiro cʉdiyijʉ Jesús ĩre: —Dios ĩ rotirise ñasarise ado bajiro gotia: “Tʉoya Israel sita gãna mʉa. Dios sĩgʉ̃ti ñami mani Ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dios mani Ʉjʉre bʉto mani maija quena. Mani ya ʉsijʉna, mani tʉoĩarisena, ito yicõri mani sẽorisena cʉni Diore bʉto mani maija quena”, yi gotia Dios ĩ rotirise ñasarise. ");
INSERT INTO myy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iti bero gaye ito bajiroti gotia: “Manimasiti mani mairo bajiroti gãjerãre cʉni maija quena”. Disejʉa gaje Dios ĩ rotirise rẽtoro ñasarise manoja, yiyijʉ Jesús judio masa rotirise riasori masʉre. ");
INSERT INTO myy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ito yija ado bajiro yiyijʉ judio masa rotirise riasori masʉ Jesure: —Queno ya riasogʉ mʉ. Ri ya mʉ. Dios sĩgʉ̃ti ñami. Nijʉa gãji mami. Ito mʉ yirise riti ña. ");
INSERT INTO myy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mani Diore maija quena. Mani ya ʉsijʉna, mani tʉoĩarisena ito yicõri mani sẽorisena cʉni Diore maija quena. Manimasiti mani mairo bajiroti gãjerãre cʉni maija quena. Diore mani maija, masare cʉni mani maija, iti ña ñasarise. Diore waibʉcʉrã soe ĩsiado rẽto bʉsaro quena ñaroja Diore ito yicõri masare cʉni mani maija, yiyijʉ judio masa rotirise riasori masʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ĩ queno cʉdija tʉocõri, ado bajiro yiyijʉ Jesús ĩre: —Yʉ tija jabeto rʉya, “Yʉ Ʉjʉ ñami Dios”, mʉ yi tʉoĩaroto, yiyijʉ Jesús ĩre. Ito bajiro Jesús ĩ yija tʉocõri, sĩgʉ̃jʉa seniĩa remo yibisijarã ĩja. “Mani rẽtoro masigʉ̃ ñaguĩji Jesús”, yi tʉoĩayijarã ĩna. Ito bajiri ĩre seniĩa remobisijarã ĩja. ");
INSERT INTO myy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Co rʉmʉ Dios ya wijʉ masare riaso ñagʉ̃ ado bajiro seniĩayijʉ Jesús ĩnare: —“David ñayorʉ janerãbatia janami ñaguĩji Cristo”, yicã Dios ĩ rotirise riasori masa. ¿No yija itire yicati ĩna? ");
INSERT INTO myy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Jane mejejʉ Espíritu Santo ĩ ejabʉarisena ado bajiro ucañi David ñayorʉ: Cristo, Dios cõarʉ yʉ Ʉjʉ ñami ĩ. Ĩ ñicʉjʉ yʉ ñabojarocati yʉ Ʉjʉ ñami Cristo, yi ucañi David ñayorʉ. Gaje uca remoñi David: Yʉ Ʉjʉ Cristore ado bajiro gotiñi Dios: “Yʉ ya riojocadʉja rujiya. Mʉ wajanare mʉ rotiroca yigʉ yigʉja yʉ”, yiñi Dios yʉ Ʉjʉre, yi ucayoñi David. ");
INSERT INTO myy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿No yija, “Yʉ Ʉjʉ ñami Cristo”, yiyijari David ñayorʉ? Cristo David janerãbatia janami ñacõri, ¿no bajiro David ʉjʉ bajiyijari Cristo? David ñayorʉ janerãbatia janami ĩ ñaja, “Yʉ Ʉjʉ”, yibitiborʉ David, yiyijʉ Jesús ĩnare. Jesús queno bʉsija tʉocõri, wanʉ quenayijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Masare ado bajiro riasoyijʉ Jesús: —Judio masa rotirise riasori masa robo mʉa yibe yirona queno tʉoĩaña mʉa. Tite. Ado bajiro yama ĩna. Yutabujuri quenarise yoarise sãñacõri masa ĩna tiro riojo wa ucu ãmorãji ĩna. Ito yicõri cʉto gʉdareco gãjire ĩna canamʉoja, rʉ̃cʉbʉore rãca seniĩare ãmorãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Minijuara wijʉ sãjacõri rʉ̃cʉbʉora cumuro riti ruji ãmorãji ĩna. Ito yicõri basari rʉmʉ cʉni ñasari masa tʉ riti ba ruji ãmorãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Manʉjʉ godagoana romiare cʉni ĩna ya wiri ẽmarãji ĩna. Ito yicõri masa ĩna tiro riojo yoari Diore bʉsirãji ĩna. “Queno yirã ñama ĩna”, masa yi tʉoĩajaro yirona yoari Diore bʉsirãji ĩna. Ito bajiro ĩna yija quenabetoja. Ito bajiri ñeñaro ĩna yirise waja, waja yirã bʉto bʉsa quenabeto tõbʉjarã yirãji ĩna. Ĩna robo mʉa yibe yirona queno tʉoĩaña mʉa, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Co rʉmʉ Dios ya wi sãjacõri niyeru cũra jedo tʉ rujiyijʉ Jesús. Iti jedojʉ masa ĩna niyeru Diore cũ ĩsija tiyijʉ Jesús. Gajeoni jairã jaje niyeru Diore cũ ĩsiyijarã iti jedojʉ. ");
INSERT INTO myy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ito yija bojoro bʉjago ejayijo. Manʉjʉ godagoro ñayijo iso. Jʉa cuji niyeru cujiri sãyijo iso. Cobre ñayijʉ iti cujiri. Jabetacã waja cʉtirise ñayijʉ iso sãrise. ");
INSERT INTO myy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ito yija ĩ rãca riasotiri masare jimioyijʉ Jesús: —Riti mʉare gotia yʉ. Adio bojoro bʉjago ñabojagoti queno Diore ĩsimo iso. Gajeoni jairã rẽto bʉsaro ĩsimo iso. ");
INSERT INTO myy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gajeoni jairãre jaje ña niyeru. Ĩna ĩsibojarocati jairo rʉya ĩnare maji. Isoama bojoro bʉjago ñabojagoti ĩsi jeomo iso. Iso bare waja yiroti Diore ĩsi jeocõmo iso, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dios ya wijʉ ñarʉ Jesús ĩ budirocati ado bajiro yiyijʉ ĩ rãca riasotigʉ: —Tiya Riasogʉ mʉ. Quenari wi ña iti wi. Gʉ̃ta quenarisena queno wi meniñi ĩna, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús ĩre: —Iti wire queno tiya mʉ. Jana batecõrã yirãji masa iti wire. Ito yicõri ñajediro gʉ̃tagãrire rea baterã yirãji masa. Ito bajiri adi wi gaye gʉ̃tagã gajega joe jesabeto yiroja. Ñarocõti godacoaro yiroja, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ito yija bero Olivos wame cʉtiri tʉria majacõri rujiyijʉ Jesús. Iti tʉria riojo sõjʉ bʉsa ñayijʉ Dios ya wi. Jesure ricati oca seniĩarona ĩ tʉ eja rʉ̃gʉ̃yijarã Pedro, Santiago, Juan, ito yicõri Andrés cʉni: ");
INSERT INTO myy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Nocãta rẽtaro yirojada mʉ yirise? ¿No bajiro ti masirã yirãjida gʉa? Mʉ yirise rẽtaroto riojʉa, ¿ñere tisʉorã yirãjida gʉa? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ĩna ito yija tʉocõri, ado bajiro gotiyijʉ Jesús ĩnare: —Queno tʉoĩaña gãjerã mʉare rʉobe yirona. ");
INSERT INTO myy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","“Dios ĩ cũana ña gʉa”, yi rʉorã yirãji ĩna mʉare. Ito bajiroti masa jãjarãre rʉorã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Masa gãmeri jarise ocare mʉa tʉoja, güibeja. Ito yicõri masa gãmeri sĩarise ocare mʉa tʉoja cʉni, güibeja. Ito bajiroti rẽtaro yiroja. Ito bajibojarocati sʉsari rʉmʉ meje ñaroja maji. Jaje ñeñarise rẽtaro yiroja sʉsari rʉmʉ ejaroto riojʉa. ");
INSERT INTO myy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Co butu gãna gãmeri sĩarã yirãji gaje butu gãna rãca. Ito yicõri co sita gãna gãmeri sĩarã yirãji gaje sita gãna rãca. Co cʉto rʉyabeto sita ʉero yiroja. Ito yicõri bare jediro yiroja. Ito bajiri ñiocõrã yirãji masa. Quenabeto tõbʉjasʉorã yirãji ĩna. Ito bajibojarocati bʉto bʉsa rẽtaro yiroja maji. ");
INSERT INTO myy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Queno masima gãjerã mʉare ñiame yirona. Mʉare ñiacõri ñasari masa tʉ ãmi warã yirãji ĩna. Ito yicõri minijuara wijʉ mʉare bajerã yirãji ĩna. Yʉre tʉorʉ̃nʉrã mʉa ñajare ʉjarã riojo mʉare jidi rʉ̃gõrã yirãji. Ĩna tiro riojo, “Jesure tʉorʉ̃nʉrã ña gʉa”, yirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sʉsari rʉmʉ riojʉa Dios oca quenarisere masa jeyaro masi jedirã yirãji ĩja. ");
INSERT INTO myy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mʉare ñiacõri ʉjarã riojo mʉare ãmi cũrã yirãji ĩna. Ito bajiro mʉare ĩna yibojarocati güibeja. Ʉjarãre mʉa cʉdiroti bʉto tʉoĩa oca jaibeja. Ĩnare mʉa queno cʉditoni gotigʉ yiguĩji Espíritu Santo. Mʉa meje bʉsirã yirãji. Espíritu Santo mʉare quedi sãjacõri bʉsigʉ yiguĩji ĩ, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mʉcana ĩnare gaje goti remoyijʉ Jesús: —Sĩgʉ̃ rĩa ñabojarãti ĩna ñarãre sĩa rotirã yirãji. Ito yicõri ĩna jacʉ ĩ rĩare sĩa rotigʉ yiguĩji ĩ. Ĩ rĩa cʉni ito bajiroti ĩna jacʉre sĩa rotirã yirãji. ");
INSERT INTO myy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yʉre mʉa tʉorʉ̃nʉja ticõri, bʉto junisirã yirãji ĩna. Ito bajibojarocati no yʉre tʉorʉ̃nʉgʉ̃reti masogʉ̃ yiguĩji Dios. Ĩre catitĩñare ĩsigʉ̃ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Diore goti ĩsiri masʉ ñayorʉ ĩ ucagore ticõri queno tʉoĩaña mʉa: “Co rʉmʉ, rʉ̃mʉ́ bʉto bʉogʉ cũrã yirãji masa Dios ya wijʉ. Quenabetoja iti”, yi ucañi Diore goti ĩsiri masʉ. Ĩre mʉa tija ejori rudi waja. Judea sitajʉ mʉa ñajama, gʉ̃tagʉ̃jʉ rudi waja. ");
INSERT INTO myy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mʉa ya wi rijogodojʉ mʉa ñaja, gajeoni ãmirã ruji wabeja. Mʉa ruji waborijʉ manoja mʉare. ");
INSERT INTO myy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Weseca moarã mʉa ñaja cʉni, yutabujure ãmirã wijʉ tʉdi wabeja. Mʉa tʉdi waborijʉ manoja mʉare. ");
INSERT INTO myy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Romia rĩa sãñarã ĩna ñaja bʉto guijoro yiroja sʉsari rʉmʉri. Ũjurã rʉcorãre cʉni ito bajiroti guijoro yiroja. ");
INSERT INTO myy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sʉsari rʉmʉ juebʉcʉ ñaroca iti rẽtame yirona Diore seniña mʉa. ");
INSERT INTO myy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sʉsari rʉmʉri riojʉa ñeñaro tõbʉjarã yirãji masa. Dios adi macãrʉcʉ̃ro ĩ rujeoja bero ĩna tõbʉjado rẽto bʉsaro tõbʉjarã yirãji masa ĩja. Ito bajiro mʉcana tʉdi rẽtabeto yiroja ĩja. ");
INSERT INTO myy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yoari quenabiti rʉmʉri iti ñaja sĩgʉ̃ rʉyabeto goda jedirã yirãji masa. Ito bajibojarocati ĩ ñarã ĩ beseanare maicõri, yoari meje bʉsati cũgʉ̃ yiguĩji quenabiti rʉmʉri. ");
INSERT INTO myy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Sĩgʉ̃ ĩ mʉare gotija: “Tiya adojʉ ñami Cristo”, ĩ yija, tʉobeja ĩre. Gãji mʉare ĩ gotija, “Titẽña õjʉ ñami, Dios ĩ cõarʉ”, ĩ yija, cʉdibeja ĩre cʉni. ");
INSERT INTO myy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rʉori masa jãjarã wadirã yirãji. “Yʉti ña Cristo”, “Yʉti ña Diore goti ĩsiri masʉ”, yirã yirãji ĩna. Ito yicõri masare rʉo ãmorã ĩna masiro bajiro guijoro tiyamani ĩnare ĩorã yirãji ĩna. Dios ĩ beseanare cʉni rʉo ãmobojarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Queno tʉoĩa masiña mʉa. Iti rẽtaroto riojʉa mʉare goticã yʉ. Ito bajiri queno bajiya mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Quenabeto masa ĩna tõbʉjari rʉmʉri bero ũmacañi ĩ busurise jediro yiroja. Ñami gagʉ ito bajiroti bajigʉ yiguĩji. Ito bajiri busumenaji ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ñocõa cʉni nʉrʉorã yirãji. Ito yicõri quedirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ito baji ñaroca yʉ Masa Rĩjorʉ ñajare yʉre tirã yirãji masa. Ide bueri watojʉ bʉto masirise rãca wadigʉ yigʉja yʉ. Ito yicõri busurise rʉcogʉ wadigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ũmacʉ̃jʉ Dios ĩ ñaro gãna ángel mesare cõagʉ̃ yigʉja yʉ masare ĩna ãmitoni. Ito bajiri macãrʉcʉ̃ro ñarocõti bata warã yirãji ĩna, Dios ĩ beseanare miojurona. ");
INSERT INTO myy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Higuera wame cʉtiricʉ ocare tʉo masiña mʉare yʉ gotija. Ito bajiri itigʉ jũ buja ticõri, “Jabeto rʉya cʉma ejaroto”, yi masia mani. ");
INSERT INTO myy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ito bajiroti yʉ gotiado bajiroti iti rẽtasʉoja ticõri, “Jabeto rʉya Masa Rĩjorʉ ĩ tʉdi wadiroto”, yi masirã yirãji mʉa. Sõjʉ meje ñagʉ̃ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Riti mʉare gotia yʉ. Adi rʉmʉri gãna ĩna goda jediroto riojʉa, yʉ bʉsiro bajiroti rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Adi sita, macãrʉcʉ̃ro cʉni jedicoaro yiroja. Ito bajibojarocati yʉ ocama jedibetoja. Yʉ gotiado bajiroti rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’No yicõri yʉ tʉdi wadiri rʉmʉ masire ma masare. Ũmacʉ̃jʉ gãna ángel mesa cʉni masimenaji. Yʉ Dios Macʉ ñabojagʉti masibea yʉ cʉni. Mani Jacʉ Dios sĩgʉ̃ti masiami yʉ tʉdi wadiroti rʉmʉ. ");
INSERT INTO myy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ito bajiri queno tirʉ̃nʉma mʉa. Yʉ wadiri rʉmʉ mʉa masibeja queno tirʉ̃nʉma mʉa. ");
INSERT INTO myy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mʉare oca gotia yʉ. Queno tʉoya. Wi ʉjʉ ñayijʉ sĩgʉ̃. Wa ucugʉ warocʉ ĩ ya moari masare wi code rotiyijʉ ĩ. Ĩ waroto riojʉajʉ ĩna moaroti gotiyijʉ ĩnare. Ito yicõri soje coderi masʉre tirʉ̃nʉ rotiyijʉ wi ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ĩ robo bajiro wacʉ yigʉja yʉ cʉni. Ito bajiri queno tirʉ̃nʉña mʉa. Yʉ wadiroti masibea mʉa. Rãiocũro, ñami gʉdareco, cara yujirocati, busuri yʉ wadiroti masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Itocõti yʉ ejaja canibeja. Masimena bajiro bajibeja. ");
INSERT INTO myy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mʉare yʉ gotirise masa jeyarore goti jeocõa yʉ. Queno tirʉ̃nʉña mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jʉa rʉmʉ rʉyayijʉ basa ĩna meniroto. Naju wadarise ʉco wʉoya mani bare basa ñayijʉ. Iti wame ñayijʉ Pascua. Iti rʉmʉri Jesure sĩa ãmoyijarã paia ʉjarã, judio masa rotirise riasori masa cʉni. Jesure ñia ãmorã, “¿No bajiro ĩre oca menirʉjati mani?” yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ado bajiro yiyijarã coriarã: —Pascua basa ñaroca Jesure mani ñiaja, masa junisinirã yirãji manire. Ito bajiri ĩre ñiabitirʉja mani Pascua basa iti ñaroca maji, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betaniajʉ Jesús ĩ ña ucurocati Simón rujʉ cami cʉtigorʉ ya wijʉ ñayijʉ ĩ. Ito ĩna ba rujirocati romio ejayijo ĩna tʉ. Gʉ̃ta alabastro wame cʉtirisena ĩna meniraga rʉcoyijo iso. Itigajʉ nardo ʉ́ye jiocõri ãmi ejayijo iso. Queno sʉti quenarise ñayijʉ iti. Godana rujʉre turoti ñayijʉ nardo ʉ́ye. Iti ñayijʉ bʉto waja rʉ̃cʉrise. Itiga ãmʉmare wẽjeacõri Jesús ya rijoga joejʉ ʉ́ye jio guyijo iso. ");
INSERT INTO myy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ito bajiro iso yija ticõri, itijʉ ñarã coriarã junisiniyijarã: —¿No yija ʉ́yere rocati cõati iso? ");
INSERT INTO myy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iti ʉ́ye trescientos waja cʉtibojabʉ. Iti waja niyeru bʉjacõri bojoro bʉjarãre ĩsirʉjaboyija isore, yiyijarã coriarã ĩnamasiti tʉoĩa bʉsirã. Ito bajiro tʉoĩacõri isore tudiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ito ĩna yija tʉocõri, ado bajiro yiyijʉ Jesús ĩnare: —Isore tudibesa mʉa. ¿No yija isore rʉ̃cʉbʉobeati mʉa? Iso yirise quenasacõa yʉre. ");
INSERT INTO myy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mʉa rãca riti ñatĩñarã yirãji bojoro bʉjarã. Ito bajiri ĩnare ejabʉatĩñarã yirãji mʉa. Yʉama mʉa rãca ñatĩñabicʉ yigʉja. Ito bajiri mʉa rãca yʉ ñaroca maji yʉjʉare ejabʉaja quena. ");
INSERT INTO myy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Adio iso tʉoĩaro bajiro queno yʉre yimo iso. Yʉ godaroto riojʉa yʉ ya rujʉre ʉ́ye queno sʉti quenarise tumo iso. ");
INSERT INTO myy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Riti mʉare gotia yʉ. Dijʉ Dios oca quenarise ĩna riasoja yʉre queno iso yigore gaye tʉorã yirãji masa. Ito bajiri iso queno yirise tʉoĩacõri, isore ãcabojamenaji ĩna, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ito yija paia ʉjarã rãca bʉsirocʉ wayijʉ Judas Iscariote. Jesús rãca riasotirã jʉa gʉbojeno ñagʉ̃ ñayijʉ ĩ. Jesure ñiatoni paia ʉjarãre gotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ĩ gotija tʉocõri, wanʉyijarã ĩna: —Niyeru mʉre ĩsiana gʉa, yiyijarã ĩna Judasre. Ito bajiri, “Jesure ĩna ñia masitoni, ¿no bajiro ĩnare ĩorʉjati yʉ?” yi tʉoĩasʉoyijʉ Judas. ");
INSERT INTO myy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Naju wadarise ʉco wʉoya mani bare basa ejayijʉ, Pascua basa ñasʉori rʉmʉ. Oveja macʉ Diore soe ĩsiri rʉmʉ ñayijʉ iti rʉmʉ. Iti rʉmʉti Jesús rãca riasotiri masa ado bajiro seniĩayijarã ĩre: —¿Nojʉ gʉa ware ãmoati mʉ, bare meni yurã Pascua basa baroti? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ito yija jʉ̃arã ĩ rãca riasotirãre goti ñucayijʉ Jesús: —Cʉto wasa. Itojʉ ʉ̃mʉgʉ̃ ide gõnaradʉna ide gõnagʉ̃re ti bʉjarã yirãji mʉa. Ĩre Sʉya waja. ");
INSERT INTO myy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sʉya sãjacõri wi ʉjʉre seniĩama: “Manire riasogʉ ado bajiro yimi: ‘¿Nojʉ ñati yʉ rãca riasotirã rãca Pascua basa menirã gʉa baroti sõa?’ yimi mani Ʉjʉ gʉare”, yiba mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ito bajiro mʉa yija tʉocõri, co sãnimʉ weca ñari sõa jajo sõa mʉare gotigʉ yiguĩji. Ĩna quenocãra sõa ñaroja. Ito bajiri iti sõajʉ bare menima mani baroti, yiyijʉ Jesús ĩna jʉ̃arãre. ");
INSERT INTO myy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ito ĩ yija tʉocõri, ĩna jʉ̃arã wayijarã. Wacõri cʉtojʉ ejayijarã. Itojʉ Jesús ĩ gotiado bajiroti ti ejayijarã ĩna. Itojʉ Pascua bare meniyijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iti rãiosʉorijʉ ejayijʉ Jesús ĩ rãca riasotirã rãca. Jʉa gʉbojeno ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ĩna baroca ado bajiro gotiyijʉ Jesús ĩnare: —Riti mʉare gotia yʉ. Mani wato sĩgʉ̃ ñami yʉ rãca bagʉ. Yʉre ñiajaro yirocʉ gãjerãre gotigʉ yiguĩji ĩ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ito bajiro ĩ yija tʉocõri, bʉto bojori bʉjayijarã ĩna. Ito yicõri ĩnacõti Jesure ado bajiro seniĩasʉoyijarã: —¿Yʉjʉa ñati? yi jedi wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ito yija Jesús cʉdiyijʉ ĩnare: —Jʉa gʉbojeno ñagʉ̃ yʉ ya tẽroti yʉ rãca najuro weo bagʉ ñami ĩ. ");
INSERT INTO myy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dios oca tuti iti gotiro bajiroti rẽtaro yiroja yʉre. Yʉ ña Masa Rĩjorʉ. Yʉre ñiacõri sĩarã yirãji masa. Ãni, gãjerã yʉre ñiajaro yirocʉ gotigʉ, bʉjato bʉjagʉ yiguĩji. Ito bajiri ĩ rujeabeja quenaboyija ĩre, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ĩna baroca riti ĩ ya ãmojʉ najuro ãmi rʉcoyijʉ Jesús. “Queno ya Dios mʉ”, yiyijʉ Jesús. Najuro igata batocõri ĩsiyijʉ ĩnare. Ito yicõri ado bajiro ĩnare gotiyijʉ Jesús: —Ĩmo baya. Adi ña yʉ ya rujʉ robo bajiro bajirise. ");
INSERT INTO myy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ito yija Jesús ĩ ya ãmona rujatẽro ãmiyijʉ. Iti tẽro rʉcocõri, “Queno ya Dios mʉ”, yiyijʉ ĩ. Ito bajiro yicõri ĩnare ĩsi ñucayijʉ Jesús. Ito bajiri ĩna ñarocõti idi jediyijarã. ");
INSERT INTO myy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ito yicõri ado bajiro ĩnare gotiyijʉ Jesús: —Adi ña yʉ ya rí robo bajiro bajirise. Yʉ ya rí iti budija jãjarã masa ñeñaro ĩna yirisere coero yiroja. Yʉ ya rí yʉre iti budija ticõri, “Dios ĩ gotiado bajiroti yami ĩ”, yi masirã yirãji masa. ");
INSERT INTO myy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Riti mʉare gotia yʉ, jʉaji ʉyé ide idibicʉja yʉ maji. Dios ĩ rotirojʉ ejacõri gajero bajirise idigʉ yigʉja yʉ mʉcana, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ito yija Diore basa tĩocõri Olivos wame cʉtiri tʉriajʉ wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ito ĩna waroca ado bajiro yiyijʉ Jesús ĩnare: —Yʉre tʉorʉ̃nʉrã ñabojarãti tʉoĩa jidicãrã yirãji mʉa. Ito bajiri yʉre jidicãcõri wagorã yirãji mʉa ñarocõti, yiyijʉ Jesús. Ito bajiroti gotia Dios oca tuti cʉni. Tite mʉa: “Oveja coderi masʉre sĩagʉ̃ yigʉja yʉ. Ito bajiri ĩ ya oveja rudi batecoarã yirãji”, yi gotiami Dios ĩ oca tutina. ");
INSERT INTO myy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yʉre ĩna ñiaja ticõri, rudi batecoarã yirãji mʉa. Ito bajibojarocati yʉre ĩna sĩaja bero mʉcana tʉdi catigʉ yigʉja yʉ. Tʉdi caticõri mʉa riojʉa bʉsa Galilea sitajʉ wacʉ yigʉja yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ito ĩ yija tʉocõri, ado bajiro yiyijʉ Pedro: —Ĩnama mʉre jidicãrã yirãji. Yʉama bajibicʉja, yiyijʉ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús ĩre: —Riti mʉre gotia yʉ. Adi ñamiti cara jʉaji yujiroto riojʉa ʉdiaji, “Jesure masibea yʉ”, yigʉ yigʉja mʉ, yiyijʉ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ito ĩ yija tʉocõri, ado bajiro yiyijʉ Pedro: —Meje, “Jesure masibea yʉ”, yibicʉja yʉ. Yʉre ĩna sĩa ãmoja cʉni, “Jesure masibea yʉ”, yibicʉja yʉ, yiyijʉ Pedro Jesure. Pedro ĩ yiro bajiro riti yi jediyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ito yija Getsemaní wame cʉtiri wesejʉ wayijarã ĩna. Itojʉ ejacõri ĩ rãca riasotirãre ado bajiro gotiyijʉ Jesús: —Õ Diore bʉsigʉ yʉ waroca riti, ado rujiya maji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ito bajiri ʉdiarãre ãmi wayijʉ Jesús. Pedro, Santiago ito yicõri Juanre cʉni ãmi wayijʉ ĩ. Ĩna waroca riti bʉto tʉoĩa bojori bʉjasʉoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ito bajiri ado bajiro yiyijʉ Jesús ĩnare: —Yʉ ya ʉsijʉ bʉto tʉoĩa bojori bʉja yʉ. Ito bajiri goda wacʉ ya yʉ yiado bajia yʉre yʉ ya ʉsijʉ. Ado tujaya mʉa maji. Canimenati yʉre bocati ñama mʉa, yiyijʉ Jesús ĩna ʉdiarãre. ");
INSERT INTO myy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ito yicõri ĩna riojʉa sõjʉa bʉsacã wayijʉ Jesús. Ito wacõri ĩ ya rio sitajʉ muqueacõri Diore bʉsi ñayijʉ ĩ. Quenabeto junirise ĩre rẽtabititoni Diore seniyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Diore bʉsigʉ ado bajiro yiyijʉ Jesús: —Cʉna, ñejʉa mʉ yi masibiti manoja. Ito bajiri yʉ tõbʉjabe yirocʉ, mʉ yʉre ejabʉare ãmoa yʉ. Ito bajibojarocati yʉ ãmoro bajiro meje mʉ yija quena. Mʉ ãmoro bajirojʉa mʉ yija quena, yiyijʉ Jesús Diore. ");
INSERT INTO myy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Diore bʉsi tĩocõri tʉdi wayijʉ Jesús ĩna ʉdiarã tʉjʉ. Ĩna caniroca ejayijʉ Jesús. Ito ĩna bajija ticõri, ado bajiro yiyijʉ Jesús Pedrore: —Simón, ¿canigʉ̃ yati mʉ? Coji cõrecõ, ¿tirʉ̃nʉ sẽobeati mʉa? ");
INSERT INTO myy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Canibesa. Queno ti ñaña mʉa. Ito yicõri Diore seniña, mʉa ñeñaro yibe yirona. Mʉa ya ʉsijʉama queno tʉoĩarã ñabojarãti, mʉa ya rujʉna queno yi masibea mʉa, yiyijʉ Jesús Pedro mesare. ");
INSERT INTO myy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ito yija Diore bʉsirocʉ wayijʉ Jesús mʉcana. Ĩ senisʉoado bajiroti gotiyijʉ Jesús Diore mʉcana. ");
INSERT INTO myy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Diore bʉsi tĩocõri tʉdi wayijʉ Jesús ĩna tʉjʉ mʉcana. Ĩnare wʉjo bʉto jeobʉajare canicoayijarã ĩna. Ito bajiri ĩna caniroca ti bʉjayijʉ Jesús ĩnare. Yujicõri bʉto Jesure bojo tiyijarã ĩna. Ito bajiri ĩre cʉdi masibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jʉaji Diore bʉsicõri mʉcana Diore bʉsigʉ wayijʉ Jesús. Ito yija bero tʉdi wayijʉ ĩna tʉ mʉcana: —¿Cani tujarã yati mʉa maji? Itocõ caniña mʉa. Yʉre ĩna ñiaroti rʉmʉ ejacoajʉ ĩja. Yʉ ña Masa Rĩjorʉ. Ñeñara masa yʉre ñiajaro yirocʉ gotiri masʉ ejacoami ĩja. ");
INSERT INTO myy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ita. Wʉmʉña. Wato. Gãjerã yʉre ñiatoni gotiri masʉ ejacoami, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús ĩ bʉsiroca riti ejayijʉ Judas. Jesús rãca riasotigʉ ñayijʉ Judas, jʉa gʉbojeno ñagʉ̃. Judas rãca masa jãjarã wadiyijarã. Sarera jãi rʉcocõri, yucʉ rʉcocõri wadiyijarã ĩna. Ĩnare cõayijarã paia ʉjarã, judio masa rotirise riasori masa, ito yicõri bʉcʉrã cʉni. ");
INSERT INTO myy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas Jesure ĩna ñiarotire gotiyijʉ ĩnare: —Ado bajiro Jesure ĩogʉ̃ yigʉja yʉ mʉare. Recoti yʉ usugʉ ĩ ñagʉ̃ yiguĩji. Ĩre yʉ ĩoja bero queno ñiama mʉa, mʉare ĩ rudibe yirona, yiyijʉ Judas. ");
INSERT INTO myy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ito ejacõri Jesús tʉ eja rʉ̃gʉ̃yijʉ Judas. Ito yicõri Jesure ado bajiro yiyijʉ ĩ: —¿Ñati yʉre Riasogʉ mʉ? yi ejayijʉ Judas. Ito yicõri Jesure usuyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ito ĩ yija ticõri, ĩna ya ãmona Jesure ãmi wayijarã ĩna, ĩ rudibe yirona. ");
INSERT INTO myy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ito tʉ rʉ̃gõgʉ̃ ĩ ya sarera jãi tʉ̃awea ãmiyijʉ. Ito yicõri paia ʉjʉre moa ĩsiri masʉre ĩ ya gãmoro jatayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ito bajiro ĩ yija ticõri, ado bajiro yiyijʉ Jesús masare: —¿Sarera jãi rʉcocõri, yucʉ rʉcocõri yʉre ñiarã wadiri mʉa? ¿Yʉ riniri masʉ meje ñabojarocati, “Riniri masʉ ñaguĩji”, yirona yʉre ñiarã wadiri mʉa? ");
INSERT INTO myy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Co rʉmʉ rʉyabeto Dios ya wijʉ mʉa wato ñasotibʉ yʉ, mʉare riasogʉ. Ito yʉ ñabojarocati yʉre ñiabiticʉ mʉa maji. Mʉa yʉre ñiaja, Dios oca tuti gotiado bajiro rẽta yʉre, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ito yija Jesure ĩna ñiaja ticõri, ĩ rãca riasotiri masa ñarocõti rudi batecoayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sĩgʉ̃ mamʉ ĩna Jesure ãmi warocati sʉya wayijʉ ĩnare. Saya jãina riti gũmayijʉ ĩ. Ito ĩ ñaroca ĩre ñiabojayijarã itijʉ ñarã. ");
INSERT INTO myy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ito bajibojarocati saya jidi queocõri ñe macʉti ũmaquedi wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ito yija paia ʉjʉ ñasagʉ ya wijʉ Jesure ãmi wayijarã ĩna. Ito bajiro yicõri minijuayijarã paia ʉjarã ñarocõti. Judio masa rotirise riasori masa, bʉcʉrã cʉni minijuayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro sõjʉ bʉsajʉ sʉyayijʉ ĩnare güigʉ. Paia ʉjʉ ñasagʉ ya wi ñari tũcũro ejayijʉ ĩ. Itojʉ ejacõri tujacoayijʉ Pedro ĩja Dios ya wi coderi masa rãca. Ito yicõri ĩna rãca jea sumayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ito bero paia ʉjarã ito yicõri ʉjarã ñasarã cʉni Jesure sĩa ãmoyijarã ĩna. Ito bajiri, “Ado bajiro ñeñaro yami Jesús”, yi rʉo gotironare ãmabojayijarã ĩna. No yi bʉja masibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","“Adi seti ña Jesure”, jãjarã ĩna yi rʉobojarocati sĩgʉ̃ tʉoĩaro bajiro meje tʉoĩa bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Coriarã wʉmʉ rʉ̃gõcõri bʉsi tudiyijarã Jesure: ");
INSERT INTO myy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ĩ bʉsija tʉobʉ gʉa: “Dios ya wi masa menira wi jana batecõcʉja yʉ. Ito bajibojarocati ʉdia rʉmʉ beroti mʉcana iti wire jõrojocʉja yʉ, masa menire gaye meje”, yimi Jesús, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ito bajibojarãti sĩgʉ̃re bajiro meje tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ito yija paia ʉjʉ wʉmʉ rʉ̃gʉ̃yijʉ ĩna wato. Ito yicõri Jesure seniĩayijʉ ĩ: —¿Cʉdibeati mʉ? ¿Ñeonire mʉre bʉsituati ĩna? yiyijʉ paia ʉjʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ito bajiro ĩ yibojarocati itire cʉdibisijʉ Jesús. Cʉdibicʉti tujayijʉ ĩ. Ito bajiri mʉcana tʉdi seniĩayijʉ paia ʉjʉ ĩre: —¿Mʉti ñati Cristo, Dios Macʉ? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ito ĩ yija tʉocõri, ĩre cʉdiyijʉ Jesús ĩja: —Aʉ, ĩti ña yʉ, yiyijʉ Jesús. Yʉ ña Masa Rĩjorʉ. Ija Dios rãca ĩ ya riojocadʉja yʉ rujija tirã yirãji mʉa. Yʉ Jacʉ Dios rãca ũmacʉ̃jʉ ide bueri rãca gʉa ruji wadija tirã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jesús ito ĩ yija tʉocõri, ĩmasiti ĩ ya yutabuju ñigãyijʉ paia ʉjʉ. Ĩ junisinirisere ĩorocʉ ito bajiro yiyijʉ ĩ. Ito yicõri ado bajiro yiyijʉ ĩ: —Gãjerã Jesure tore tʉo ãmobea yʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mʉa cʉni tʉobʉ Diore Jesús ñeñaro ĩ yirise. Ito bajiri, ¿no bajiro ãmoati mʉa? yiyijʉ paia ʉjʉ masare. Ito bajiro ĩ yija tʉocõri: “Ĩre sĩarʉja mani”, yi jediyijarã masa. ");
INSERT INTO myy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ito yija coriarã Jesure go ide eobate guyijarã ĩna. Ito yicõri Jesús ya cajea moabiacõri ĩre jayijarã ĩna. Ĩre jacõri ado bajiro seniĩayijarã ĩna: —¿Ñimʉ mʉre jari? Recoti mʉ tʉo masijama, “Ĩ yʉre jami”, yigʉ yigʉja mʉ, yi ajeyijarã ĩna Jesure. Dios ya wi coderi masa cʉni ĩ ya riojʉ jayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ito ĩna yiroca iti wi tʉ ñari tũcũrojʉ ñayijʉ Pedro. Ito ĩ ñaroca paia ʉjʉre moa ĩsiri maso ejayijo ĩ tʉ. ");
INSERT INTO myy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro jeame tʉ ĩ rujija ticõri, ĩre ti rʉ̃gõcoayijo iso. Ito bajiri ado bajiro yiyijo iso ĩre: —Mʉ cʉni Jesús Nazaret gagʉ rãca wa ucuyija mʉ, yiyijo iso Pedrore. ");
INSERT INTO myy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Iso ito yija tʉocõri, ado bajiro cʉdiyijʉ ĩ: —Jesús rãca wa ucubiticʉ yʉ. Ĩre masibea yʉ. Mʉ bʉsirisere tʉo masibea yʉ, yiyijʉ Pedro isore. Ito yicõri sãjasʉora soje tʉjʉa budi wayijʉ ĩ. Ito ĩ bajiroca riti cara yujiyijʉ. ");
INSERT INTO myy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Paia ʉjʉre moa ĩsiri maso mʉcana Pedrore ti bʉjacõri ado bajiro yiyijo itijʉ ñarãre: —Ãni ñami Jesús rãca riasotiri masʉ, yiyijʉ iso. ");
INSERT INTO myy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Iso ito yija tʉocõri: “Ĩre masibea yʉ”, yiyijʉ Pedro mʉcana. Ito yija itijʉ ñari masa ado bajiro yiyijarã Pedrore: —Mʉti ña ĩna rãca gagʉ. Mʉ ña Galilea gagʉ. Ĩna bajiroti bʉsia mʉ cʉni, yiyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ito yija ado bajiro cʉdiyijʉ Pedro: —Jesure masibesacõa yʉ. Bʉgʉti yʉ yija yʉ ñeñaro tõbʉroca yijaro Dios, yiyijʉ ĩ. Ito mʉa bʉsigʉre masibea yʉ, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ito ĩ yirocati mʉcana tʉdi yujiyijʉ cara. Ĩ yujija tʉocõri, Jesús ĩ gotire tʉoĩa bʉjayijʉ Pedro: “Cara jʉaji ĩ yujiroto riojʉa ʉdiaji, ‘Jesure masibea yʉ’, yigʉ yigʉja mʉ”, Jesús ĩ gotire tʉoĩacõri bʉto otiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Iti bususʉoroca paia ʉjarã, bʉcʉrã cʉni minijuayijarã. Ito yicõri judio masa rotirise riasori masa, ʉjarã ñasarã cʉni ñajediro minijuayijarã. Minijuacõri Jesure ãmo siacõri ĩre ãmi wayijarã Pilato tʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ĩ tʉ Jesure ĩna ãmi ejaroca ado bajiro seniĩayijʉ Pilato ĩre: —¿Mʉti ñati judio masa ʉjʉ? yiyijʉ Pilato Jesure. Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús ĩre: —Mʉ yiro roboti ña, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ito yija paia ʉjarã jaje oca meniyijarã Jesure. ");
INSERT INTO myy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ito bajiri mʉcana tʉdi seniĩayijʉ Pilato Jesure: —¿Cʉdibesacõati mʉ? ¿Masibeati mʉ, jeyaro mʉre oca menirã yama ĩna? yiyijʉ Pilato ĩre. ");
INSERT INTO myy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ĩ ito yibojarocati ĩre cʉdibisijʉ Jesús. Ĩ cʉdibeja ticõri, bʉto tʉoĩa ʉcayijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Masa ĩna basa ñaroca riti ado bajiro yisotiyijʉ Pilato. Sĩgʉ̃ tubiara wijʉ ñagʉ̃re masa ĩna bucõa rotija, ĩre bucõayijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ito bajiro ĩna yi ñari rʉmʉ tubiara wijʉ sĩgʉ̃ ñayijʉ Barrabás wame cʉtigʉ. Masa sĩagoana rãca tubiara wijʉ ñayijʉ Barrabás. Oca riawʉsacõri masa sĩana ñayijarã Barrabás mesa. ");
INSERT INTO myy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ito yija judio masa ejacõri Pilatore ado bajiro yiyijarã ĩna: —Mʉ yisotiro bajiro, sĩgʉ̃re mʉ bucõare ãmoa gʉa, yiyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ito yija Pilato cʉdiyijʉ ĩnare: —¿Ñimʉre yʉ bucõare ãmoati mʉa? ¿Judio masa ʉjʉre yʉ bucõare ãmoati mʉa? yiyijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jesure riti masa jãjarã ĩna tʉo sʉyaja ticõri, bʉto junisiniyijarã paia ʉjarã. “Gʉajʉare riti ĩna tʉo sʉyaja quena”, yirona bʉto junisiniyijarã ĩna Jesure. Ito bajiri ĩre ti terã Pilatore ĩsiyijarã ĩna. Ito bajiro ĩna yija tʉo masicõyijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Paia ʉjarã oca sẽoro masare bʉsiyijarã. Ito yicõri ado bajiro ĩnare gotiyijarã: “Pilatore seniteña, Barrabásre ĩ bucõatoni”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ito yija Pilato seniĩayijʉ masare: —¿Ñe yʉ yire ãmoati mʉa, “Judio masa ʉjʉ ñami”, mʉa yigʉre? yiyijʉ Pilato masare. ");
INSERT INTO myy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ito ĩ yija tʉocõri, awasã cʉdiyijarã ĩna: —Yucʉtẽojʉ ĩre jaju sĩaña, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ĩna ito yija tʉocõri: —¿Ñe ñeñarise yicati ãni? yiyijʉ Pilato masare. Ito bajiro ĩ yija tʉocõri, mʉcana tʉdi awasã cʉdiyijarã masa: —Yucʉtẽojʉ ĩre jaju sĩaña, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ito yija masa rãca queno ña ãmogʉ̃ Barrabásre bucõacõyijʉ Pilato ĩja. Ito yicõri, “Jesure bajeya mʉa”, yi rotiyijʉ ĩ ya moari masare. Ĩna baje tĩoroca masare ĩsiyijʉ Pilato, Jesure ĩna jaju sĩatoni. ");
INSERT INTO myy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ito bajiri surara ãmi wayijarã Jesure iti sita gagʉ ʉjʉ ya wi totijʉ. Ito yicõri surara ʉjarã ñarocõti minijuayijarã iti wijʉ. ");
INSERT INTO myy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iti wi totijʉ ñacõri Jesure saya sũa ñiro sãyijarã ĩna, ʉjʉ ĩ sãñaro bajiro. Ito yicõri jota bedo seara bedo ĩre jeoyijarã ĩre. ");
INSERT INTO myy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ito yicõri ado bajiro Jesure tudi ajeyijarã ĩna: —Judio masa ʉjʉ ña mʉ. Gʉa bero catiba, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ito yicõri ĩ ya rijogajʉ yucʉna ĩre jayijarã. Ito yicõri ĩre go ide eobate guyijarã. Ĩ riojo rijomunigãna ñini rũjũcõri ado bajiro ĩre aja tudiyijarã ĩna: “Mʉ ña ʉjʉ ñasagʉ”, yi aja tudiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ĩre aja tudi tĩocõri ĩ ya yutabuju sũaro ruayijarã ĩna. Ruagocõri mʉcana ĩ sãñasʉoadoti tʉdi sãyijarã ĩna mʉcana. Ito yicõri Jesure yucʉtẽojʉ jajʉ sĩarona ĩre tʉ̃a wayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesure ĩna tʉ̃a waroca ĩna tʉ ejayijʉ Simón wame cʉtigʉ. Cirene cʉto gagʉ ñayijʉ ĩ. Alejandro, ito yicõri Rufo jacʉ ñayijʉ ĩ. Jesús tʉ Simón ĩ rẽta waroca ĩ ya yucʉtẽore gaja rotiyijarã surara ĩre. ");
INSERT INTO myy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ito yija Jesure ãmi wayijarã Gólgota wame cʉtiri tʉriajʉ. “Rijoga gõa”, yireoni ña iti Gólgota yire. ");
INSERT INTO myy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Itojʉ ejacõri Jesure ʉyé ide, mirra ʉco wʉsaro ĩre iobojayijarã ĩna. Itire idibisijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ito yija Jesure yucʉtẽojʉ jaju wõyijarã ĩna. Ĩ ya ãmo ito yicõri ĩ ya gʉbore cʉni jajuyijarã come wacana. Jesús ya yutabujure ãmorã ado bajiro yiyijarã ĩna: “Ñimʉjʉa Jesús ya yutabuju ĩ bʉjaja tiana mani”, yirona gʉ̃ta ajerina rea ajeyijarã surara. Ito bajiro yi ajecõri, ĩ ya yutabujuri gãmeri batoyijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Busuri bʉsa nueve tujarocacõ Jesure jajuyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesús ya rijoga weca cumu jãi ucara jãi wõyijarã ĩna. “Ãni ñami judio masa ʉjʉ”, yi ucare ñayijʉ iti jãijʉ. “Iti waja seti ña ĩre”, yireoni ñayijʉ ito uca wõre. ");
INSERT INTO myy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesús rãca cocati jʉ̃arã riniri masare jajuyijarã ĩna. Sĩgʉ̃ Jesús ya riojocadʉja ñayijʉ, gãji ĩ ya gãcodʉjajʉa. ");
INSERT INTO myy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ito iti bajija Dios oca tuti iti gotiro bajiroti rẽtacoayijʉ: “Ñeñaro yirã rãca ñacõri, ĩ cʉni ñeñaro yigʉ ñaguĩji”, yirã yirãji masa, yi ucare ñayijʉ Dios oca tutijʉ. ");
INSERT INTO myy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Itijʉ gãna Jesús tʉ rẽta warãti ĩre aja tudiyijarã ĩna: —“Dios ya wire jana batecõcʉja yʉ. Ito yicõri ʉdia rʉmʉ bero mʉcana jõrojocʉja yʉ”, yibojacʉ mʉ, yiyijarã masa Jesure. ");
INSERT INTO myy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mʉmasiti masoña. Ito yicõri yucʉtẽojʉ wãñagʉ̃ ruji waya mʉ, yiyijarã ĩna Jesure, ĩre aja tudirã. ");
INSERT INTO myy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Paia ʉjarã, judio masa rotirise riasori masa cʉni ito bajiroti aja tudiyijarã ĩna Jesure: —Gãjerãre masobojagʉti ĩmasiti maso masibeami ĩ, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristo, Israel sita gãna ʉjʉ mʉ ñaja, ruji masigʉ̃ yigʉja mʉ. Yucʉtẽojʉ mʉ rujija ti ãmoa gʉa. Mʉ rujija ticõri, “Cristo ña mʉ”, yiana gʉa, yiyijarã ĩna Jesure. Jesús rãca cocati yucʉtẽojʉ jaju ecoana cʉni aja tudiyijarã ĩre. ");
INSERT INTO myy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ʉ̃mʉa gʉdareco ñaroca macãrʉcʉ̃ro ñarocõti rãitĩacoayijʉ ĩja. Yoari rãitĩayijʉ iti. Ñamicajʉa bʉsa tres ñaroca itocõ busuyijʉ mʉcana. ");
INSERT INTO myy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Itocõ tʉjarocati bʉto awasãyijʉ Jesús ĩ ocana: —Eloi, Eloi, ¿lama sabactani? yiyijʉ Jesús. “Dios yʉ Jacʉ, ¿no yija yʉre wagoati mʉ?” yireoni ñayijʉ iti ĩ ocana. ");
INSERT INTO myy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Coriarã ito ña coderã ĩ awasãja tʉocõri, ado bajiro yiyijarã ĩna: —Tʉoya mʉa. Diore goti ĩsiri masʉ Elías wame cʉtigʉre jigʉ yirʉ ĩ, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ito yija sĩgʉ̃ ito ñagʉ̃ ũmaquedi wayijʉ Jesús tʉjʉa. Ito yicõri ide udi ãmirisena ʉyé ide jiare weoyijʉ. Ito yicõri ĩre itojʉ ñutubojayijʉ yucʉgʉna, Jesús ya rise tʉjʉ ĩ mimitoni. Idibisijʉ Jesús. Ito yija Jesure ado bajiro yiyijʉ ĩ: —Yuya maji. Diore goti ĩsiri masʉ Elías mʉre ĩ rujioja tiana gʉa, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ito ĩ yija bero oca sẽoro awasãyijʉ Jesús. Ito awasãcõri ʉsi jedicoayijʉ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ĩ ʉsi jedirocati Dios ya wi saya webʉtiro, wi gʉdareco yobiado ũmacʉ̃jʉana ñigã ruji wadicõri jacajʉ ñigã ruji ejacoayijʉ. ");
INSERT INTO myy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Co dʉjamocõ masacõ surara ʉjʉ Jesús riojo ñagʉ̃ ĩ ʉsi jedija ticõri, ado bajiro yiyijʉ ĩ: —Dios Macʉguti ñabojañi ãni, yiyijʉ surara ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sõjʉ bʉsa ti ñayijarã romia cʉni, Jesús ĩ godaja. Ĩna wato ñayijarã María Magdalena, María Santiago mesa jaco, ito yicõri Salomé wame cʉtigo cʉni. Sõjʉ bʉsa ti ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galilea wame cʉtiri cʉtojʉ Jesús ĩ ña ucuroca ĩre ejabʉagoana ñayijarã ĩna. Gãjerã romia Jerusalénjʉ Jesure sʉya ejagoana ĩ godaja ti ñayijarã ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ito yija judio masa moasʉsari rʉmʉ rãiocoayijʉ. Iti rʉmʉ ñayijʉ tujacãra rʉmʉ riojʉa ĩna queno yuri rʉmʉ. ");
INSERT INTO myy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ito yiroca ejayijʉ José Arimatea gagʉ. Ĩ José ñayijʉ ñasarã rãca ñagʉ̃. Diore tʉorʉ̃nʉrãre ĩ miojuroti rʉmʉ bocati ñayijʉ ĩ cʉni. Ito yija oca sẽoro sãja wacõri Pilatore Jesús ya rujʉre seniyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ito ĩ yija tʉocõri, “Agʉ, ¿no yija yoari mejeti ʉsi jediati ĩ?” yi tʉoĩayijʉ Pilato. Ito bajiri surara ʉjʉre jiyijʉ Pilato: “¿Riti bajiati?” yirocʉ. ");
INSERT INTO myy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Riti ña”, surara ʉjʉ ĩ yija tʉocõri, Jesús ya rujʉre ãmi rotiyijʉ ĩ Josére. ");
INSERT INTO myy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ito bajiro ĩ yija tʉocõri, Jesús ya rujʉre gũmarocʉ saya coro waja yiyijʉ José. Ito yicõri Jesús ya rujʉre rujiogʉ wayijʉ ĩja. Ĩre rujio tĩocõri ĩre gũmayijʉ José. Ito yicõri gʉ̃ta totijʉ masari cumajʉ Jesús ya rujʉre yujeyijʉ José. Ito yicõri gʉ̃ta jãi jaja jãina tubiayijʉ masari cuma sojere. ");
INSERT INTO myy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, María José jaco cʉni tiyijarã Jesure ĩna yujerajʉ. ");
INSERT INTO myy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tujacãra rʉmʉ rãiocũro ñaroca María Magdalena, María Santiago jaco ito yicõri Salomé wame cʉtigo cʉni ĩna ʉdiarã sʉtirise queno sʉti quenarise waja gãmeyijarã ĩna Jesús ya rujʉre turona. ");
INSERT INTO myy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tujacãra rʉmʉ busuri jĩjʉ wayijarã ĩna Jesús ya masari cumajʉ. Ũmacañi joejearijʉ ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ito yicõri ĩnamasiti bʉsiyijarã: —Jesús ya masiri cuma gʉ̃tagã tubiado, ¿Ñimʉ manire ãmigo ĩsigʉ̃ yiguĩjida? yi bʉsi wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ito ejacõri ĩna tija gʉ̃tagã jajoca ĩna biabojaraga mañijʉ ĩja. Iti ñarajʉ meje ñayijʉ itiga ĩja. ");
INSERT INTO myy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gʉ̃tagã manija ticõri, sãjayijarã ĩna. Ito sãja wacõri ĩna ti ñucaja riojocadʉja sĩgʉ̃ mamʉ yutabuju botiro sãñacõri rujiyijʉ. Ĩre ticõri ʉcayijarã ĩna romia. ");
INSERT INTO myy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ĩna ʉcaja ticõri, ado bajiro ĩnare gotiyijʉ ĩ: —Ʉcabesa mʉa. Jesús Nazaret gagʉ mʉa ãmagʉ̃ yucʉtẽojʉ ĩna jajurʉ mami. Ĩ godaja bero tʉdi caticoami. Ito bajiri mami ado. Tiya mʉa ado ĩre ĩna cũgorajʉ, yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wasa. Ĩ rãca riasotigoanare gotitẽña. Pedrore cʉni gotiba, yiyijʉ ĩ. Ado bajiro mʉa gotija quena: “Jesús mʉa riojʉajʉ Galileajʉ ejagʉ yiguĩji. Itojʉ ĩre tirã yirãji mʉa. Ĩ gotiado bajiroti itojʉ ĩre ti bʉjarã yirãji mʉa”, yi gotiba mʉa ĩnare, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ito ĩ yija tʉocõri, rudi budi wayijarã romia. Queno budi yire mejeti, nʉrʉo budi wayijarã ĩna, ʉcarã. Ito bajija ticõri, güirã gãjerãre goti bato yibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Semana gaye ñasʉori rʉmʉ busuri jĩjʉ mʉcana tʉdi caticõri María Magdalenare cajero goaĩoyijʉ Jesús. Jʉa ãmojeno rʉ̃mʉ́a budigoro ñayijʉ iso. ");
INSERT INTO myy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesús ĩ tʉdi catija ticõri, ĩ rãca riasotigoanare gotigo wayijo iso, ĩna oti bojori bʉjabe yiroco. ");
INSERT INTO myy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ĩna tʉ ejacõri ado bajiro yiyijo iso: “Mʉcana catiami Jesús. Ĩre tibʉ yʉ”, yibojayijo iso ĩnare. Iso gotija tʉobojarãti, “Riti gotiamo”, yi tʉorʉ̃nʉbisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ito yija bero weseca ĩna wa ucuroca ĩ rãca riasotigoana jʉ̃arãre goaĩoyijʉ Jesús. Gajero bajigʉ ñacõri, ĩnare goaĩoyijʉ Jesús. Ito bajiri cajero ĩre ti masibisijarã ĩna maji. ");
INSERT INTO myy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yoa bʉsari, “Ĩti ñami Jesús”, yi ti masicõri, tʉdi wayijarã ĩna gãjerã Jesús rãca riasotigoanare gotirã warã. Ĩna gotibojarocati ĩnare tʉorʉ̃nʉbisijarã ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ito yija bero co rʉmʉ ĩ rãca riasotigoana once ñarã ĩna ba rujiroca ĩnare goaĩayijʉ Jesús: “¿No yija gãjerã yʉre tigoanare tʉobeati mʉa? Mʉa ya ʉsijʉ tʉo ãmobea mʉa”, yi tudiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","—Wasa, masa jeyarore Dios oca goti ucuba. “Ĩre tʉorʉ̃nʉrãre masogʉ̃ yiguĩji Dios”, yire gaye riaso ucuba mʉa. ");
INSERT INTO myy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","No Diore tʉorʉ̃nʉcõri, idé gu ecorʉti godabiquĩji. Catitĩñagʉ̃ yiguĩji. Ito bajibojarocati no yʉre tʉorʉ̃nʉbicʉama ĩ ñeñaro yirise waja ñaro ya ĩre. Ito bajiri jeame ʉ̃jʉrojʉ ĩre cõagʉ̃ yiguĩji Dios, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yʉre tʉorʉ̃nʉrãre ti masirã yirãji mʉa. Ado bajiro yirã yirãji ĩna. Yʉre tʉorʉ̃nʉcõri yʉ masirisena sʉoriti rʉ̃mʉ́are bucõarã yirãji ĩna. Ĩna masibiti oca ñabojareti bʉsirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ãñare ĩna ñiabojaja, ito yicõri ide junirisere ĩna idibojaja cʉni ĩnare junibetoja. Diore bʉsicõri cõrãre ãmo moa jeorã yirãji. Ito ĩna yirocati tujarã yirãji masa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iti ĩ bʉsija bero macãrʉcʉ̃rojʉ mani Ʉjʉ Jesure ãmi mʉja wayijʉ Dios. Ito bajiri Dios ĩ riojocadʉjajʉ rujiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ito ĩ mʉjaja bero masa ñajedirore Dios oca goti ucurã wayijarã ĩna ĩja. Ito bajiro ĩna goti ucuja ticõri, Jesumasiti ĩnare ejabʉayijʉ ĩ. Masa ĩnare queno tʉorʉ̃nʉjaro yirocʉ, ĩ rãca riasotigoanare ejabʉayijʉ Jesús. Ito bajiri ĩ ejabʉarisena tiyamani masare ĩoyijarã ĩna cʉni. Itocõti ña.");
INSERT INTO myy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ñati mʉ yʉ baba Teófilo. Adi mʉre papera cõa yʉ. Adi rʉmʉri Jesure rẽtagore oca ucari masa jãjarã ñama ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mani robo bajiroti cajero Jesús rãca riasotigoana ĩna gotija, tʉogoanati ñama ĩna cʉni. Ito bajiri ĩna ucarise ticõri, “Jesús rãca riasotigoana ĩna gotiro bajiroti ucama ĩna cʉni”, yi tʉoĩa mani. ");
INSERT INTO myy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ito bajiro yi masibojagʉti jeyaro Jesure rẽtare oca queno riasoticõri, “Yʉ baba Teófilore yiari, yʉmasiti itire ucacʉja yʉ”, yi tʉoĩacʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ito bajiro tʉoĩacõri, “Jeyaro yʉ tʉogore bajiroti bajiyija Jesure cʉni”, mʉ yi tʉo masitoni adi mʉre uca yʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes, Judea sita ʉjʉ ĩ ñaroca, sĩgʉ̃ ñayijʉ pai Zacarías wame cʉtigʉ. Pai Abías gãna rãca gagʉ ñayijʉ Zacarías. Ĩ manojo Elisabet wame cʉtigo ñayijo iso. Pai Aarón ñajacʉ janeño ñayijo iso. ");
INSERT INTO myy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dios ĩ tija queno yirã ñayijarã ĩna jʉ̃arã, Zacarías ĩ manojo rãca. Ito yicõri Dios ĩ rotirise queno cʉdirã ñayijarã ĩna. Ito bajiri, “Ĩnare seti ña”, yi masibisijarã gãjerã. ");
INSERT INTO myy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ito bajibojarocati rĩa mañijarã ĩna. No yicõri rĩa cʉti masibisijo Elisabet. Ĩna jʉ̃arã bʉcʉrã riti ñayijarã ĩja. ");
INSERT INTO myy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Co rʉmʉ Zacarías rãca gãnare pai ye moare ñayijʉ Dios ya wijʉ. Paia ĩna yisotire yicõri Zacaríasre bese masiyijarã gãjerã paia. “Mʉti ña Dios ya sõa sãjarocʉ, Diore queno sʉtirise soe ĩsirocʉ”, yi ti masiyijarã ĩna Zacaríasre. ");
INSERT INTO myy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ito ĩna yija tʉocõri, Diore queno sʉti quenarise soe ĩsirocʉ, Dios ya sõa sãjayijʉ Zacarías. Ito ĩ soe ñaroca riti macʉ̃jʉa Diore bʉsi ñayijarã masa jeyaro. ");
INSERT INTO myy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Iti ĩ soeroca riti Dios ñaro gagʉ ángel goaĩoyijʉ Zacaríasre. Diore soe ĩsirajʉ riojocadʉjajʉa goa rʉ̃gʉ̃yijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ángelre ti bʉjacõri, no yi masibisijʉ Zacarías. Bʉto güiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ito bajiro ĩ güija ticõri, ado bajiro ĩre gotiyijʉ ángel: —Güibesa Zacarías mʉ. Mʉ bʉsirisere tʉoami Dios. Ito bajiri mʉ manojo Elisabet macʉ cʉtigo yigõji. Ito yicõri Juan ĩre wame wõgʉ̃ yigʉja mʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Mʉ macʉ Dios ĩ tiro riojo queno yigʉ ñagʉ̃ yiguĩji ĩ. Ito bajiri queno wanʉgʉ̃ yigʉja mʉ. Ito yicõri ĩ rujeaja tʉocõri, masa jãjarã wanʉrã yirãji ĩna. Mʉ macʉ ʉyé ide idibiquĩji, sibiore cʉni. Ito yicõri ĩ rujearoto riojʉa Espíritu Santo quedi sãjagʉ̃ yiguĩji ĩre. ");
INSERT INTO myy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mʉ macʉ ĩ riasorise tʉocõri Israel sita gãna jãjarã mani Ʉjʉ Dios rãca tʉdi ʉsi cʉtirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jane mejejʉ Elías wame cʉtigʉ, Diore goti ĩsiri masʉ ñayijʉ. Ĩre bajiro queno oca sẽoro masare riasogʉ yiguĩji mʉ macʉ. Dios ĩ cõarʉ Cristo ĩ ejaroto riojʉa, Dios oca queno masare riasogʉ yiguĩji mʉ macʉ. Ito bajiri Espíritu Santo ĩ ejabʉarisena jacʉsabatia ĩna rĩa rãca corocõ ʉsi cʉtiroca yigʉ yiguĩji ĩ. Ito yicõri Diore cʉdimena ĩna cʉdiroca yigʉ yiguĩji ĩ. Ito bajiro yigʉ, Cristore masa ĩna boca ãmi ñacãroca yigʉ yiguĩji mʉ macʉ, yiyijʉ ángel Zacaríasre. ");
INSERT INTO myy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ito ĩ yija tʉocõri, ado bajiro ĩre seniĩayijʉ Zacarías: —¿Mʉ yirise rẽtaro yiroja, no bajiro yi tʉoĩa ñagʉ̃ yigʉjada yʉ? Bʉcʉgʉ ña yʉ. Ito yicõri yʉ manojo cʉni bʉco ñamo, yiyijʉ Zacarías. ");
INSERT INTO myy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ito ĩ yija ĩre cʉdiyijʉ ángel: —Gabriel ña yʉ. Ito yicõri Diore moa ĩsigʉ̃ ña yʉ. Mʉre iti oca quenarise yʉ gotitoni yʉre cõami Dios. ");
INSERT INTO myy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ito bajibojarocati yʉ bʉsirise mʉ tʉorʉ̃nʉbejare bʉsi masibiticõri, bʉsibicʉ ñagʉ̃ yigʉja mʉ. Ito bajiri mʉ macʉ ĩ rujearoto riojʉa bʉsibicʉ riti ñagʉ̃ yigʉja mʉ maji. Ito bajiroti rẽtaro yiroja, Dios ĩ ãmori rʉmʉjʉ, yiyijʉ ángel Zacaríasre. ");
INSERT INTO myy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ito ĩ yiroca macʉ̃jʉ ñarã ruje tʉoĩayijarã masa Zacaríasre yurã. ¿No yija Dios ya wijʉ yoari sejati Zacarías? yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ĩ budija bero no yi bʉsi masia mañijʉ Zacaríasre. Ĩ ito bajija ticõri, “Dios ya sõajʉ ñasarise tiñi ĩ”, yiyijarã masa. Ĩjʉa bʉsibicʉ ñacõri no bajiro yi bʉsi masibisijʉ ĩnare. Ito bajiri bʉsigʉõcʉ̃ti ĩ ya ãmona sõju quesoĩayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dios ya wijʉ ĩ moa tĩoja bero ĩ ya wijʉ tʉdi wayijʉ Zacarías. ");
INSERT INTO myy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ĩ ya wijʉ ĩ tʉdi ejaja bero ĩ manojo Elisabet macʉ sãñagõ ñayijo iso ĩja. Ito yicõri wijʉ ñagõ, budibisijo iso co dʉjamocõ ũmacañicõ. ");
INSERT INTO myy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ado bajiro tʉoĩayijo iso. “Ito bajiro yʉ macʉ sãñaroca yiñi Dios yʉre. Gãjerã yʉre ĩna ti tudibe yigʉ, ito bajiro queno yiñi Dios yʉre”, yi tʉoĩayijo iso. ");
INSERT INTO myy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Co ãmojeno ũmacañi macʉ sãña tʉjago Elisabet iso ñaroca, Dios ñaro gagʉ ángel Gabriel wame cʉtigʉre cõayijʉ Dios, Nazaret wame cʉtiri cʉtojʉ. Galilea sitajʉ ñayijʉ iti cʉto. ");
INSERT INTO myy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Itojʉ sĩgõ María wame cʉtigore oca gotirocʉre cõayijʉ Dios Gabrielre. Manʉjʉ maco ʉ̃mʉgʉ̃ rãca ajeĩabeco ñayijo iso. Ito yicõri José manojo ñaroco ñayijo iso. Masa ʉjʉ ñayorʉ janami macʉ ñayijʉ José. Ĩ ñicʉjʉ David wame cʉtiyoyijʉ, jane mejejʉ masa ʉjʉ ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","María tʉjʉ ejacõri ado bajiro isore gotiyijʉ ángel: —¿Ñati mʉ? Mʉre oca gotigʉ wadibʉ yʉ. Dios ĩ tija, queno ʉsi cʉtigo ñayijʉ mʉ. Ito bajiri mʉ rãca ñami Dios. Gãjerã romia rẽto bʉsaro queno yiñi Dios mʉre, yiyijʉ ángel Maríare. ");
INSERT INTO myy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ito ĩ yija tʉocõri, bʉto tʉoĩa jaiyijo iso ĩja. “¿No yija ito bajiro yʉre seniĩati ĩ?” yi tʉoĩayijo iso. ");
INSERT INTO myy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ito yija mʉcana isore bʉsiyijʉ ángel: —Güibesa María mʉ. Mʉre wanʉami Dios. Ito bajiri mʉre queno yiñi ĩ. ");
INSERT INTO myy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Macʉ sãñagõ ñasʉogo yigoja mʉ, ito yicõri macʉ cʉtigo yigoja mʉ. Ĩre macʉ cʉticõri, Jesús wame yigo yigoja mʉ, mʉ macʉre. ");
INSERT INTO myy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Masa rẽtoro masi rẽtocũgʉ̃ ñagʉ̃ yiguĩji ĩ. Ito yicõri, “Dios Macʉ”, wame cʉtigʉ yiguĩji ĩ. Dios ũmacʉ̃jʉ gagʉ Macʉ ñari ito bajiro wame cʉtigʉ yiguĩji ĩ. Ĩ ñicʉjʉ David ñayorʉ robo bajiro Ʉjʉ ñagʉ̃ yiguĩji ĩ cʉni. Ito bajiro ĩ ñaroca yigʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel sita gãna jeyaro ʉjʉ ñagʉ̃ yiguĩji mʉ macʉ. Ito yicõri ĩ rotirise sʉsabeto yiroja ĩja, yiyijʉ ángel Maríare. ");
INSERT INTO myy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ito ĩ yija tʉocõri, ĩre seniĩayijo María: —¿Ʉ̃mʉgʉ̃ rãca yʉ ñabitibojarocati yʉre macʉ rujeagʉ yiguĩjida? yiyijo iso ĩre. ");
INSERT INTO myy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Iso ito yija tʉocõri, ado bajiro isore cʉdiyijʉ ĩ: —Ĩ ya ʉsiti mʉre queo sãgʉ̃ yiguĩji Dios. Ito yicõri ĩ masirise mʉ rãca ñaro yiroja. Ito bajiro Dios ĩ yija ĩ ya ʉsiti mʉ macʉ sãñarise bajiro yiroja mʉre. Ito bajiri macʉacã mʉ rʉcorocʉ Dios ĩ ãmorise riti yigʉ yiguĩji ĩ. “Dios Macʉ ñami ĩ”, yirã yirãji masa. Gaje ado bajiro mʉre gotia yʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mʉ gajego Elisabet bʉco ñabojagoti macʉ cʉtigo yigõji iso. “Rĩa cʉtiado mamo iso”, yibojacã masa. Ito ĩna yibojarocati co ãmojeno ũmacañi tʉja iso macʉ sãñaja bero. ");
INSERT INTO myy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","“Diore disejʉa bʉto josarise manoja”, yiyijʉ ĩ Maríare. ");
INSERT INTO myy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijo iso: —Dios ĩ rotirise moa ĩsiri maso ña yʉ. Ito bajiri mʉ yiro bajiroti yire ãmoa yʉ, yiyijo María. Iso ito yija tʉocõri, ũmacʉ̃jʉ tʉdi mʉjacoayijʉ ángel mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ito bajiro ĩ yira rʉmʉri bero ʉsirio wayijo María, Judea sitajʉ gʉ̃ta yucʉri ñari cʉtojʉ Elisabetre tigo waco. ");
INSERT INTO myy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ito ejacõri Zacarías ya wijʉ sãjayijo iso. Ito sãja ejacõri, “¿Ñati mʉ?” yi seniĩayijo iso Elisabetre. ");
INSERT INTO myy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","María iso seniĩaja tʉocõri, Elisabet jeraga totijʉ macʉ sãñagʉ̃ wãreyijʉ. Ito yicõri Espíritu Santo isore quedi sãjayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ito bajicõri oca sẽoro ado bajiro yi gotiyijo Elisabet Maríare: —Gãjerã romia rẽtoro queno yiñi Dios mʉre. Ito yicõri mʉ macʉ rʉcorocʉre cʉni queno yiñi Dios. ");
INSERT INTO myy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ñasari maso meje yʉ ñabojarocati yʉ Ʉjʉ jaco ñaroco yʉre tigo wadiri mʉ? ");
INSERT INTO myy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yʉre mʉ seniĩaja tʉocõri, yʉ ya jeraga totijʉ sãñagʉ̃, yʉ macʉ wanʉgʉ̃ wãremi ĩ. ");
INSERT INTO myy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","“Dios ĩ bʉsiado bajiroti itire yicõgʉ̃ yiguĩji”, yiroco bʉto wanʉa mʉ, yiyijo Elisabet Maríare. ");
INSERT INTO myy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ito yija ado bajiro yiyijo María: Yʉ ya ʉsina mani Ʉjʉre bʉto rʉ̃cʉbʉoa yʉ. Ito bajiri, “Queno ya mʉ”, ya yʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Dios ñami yʉre masorʉ. Ito bajiri ĩre queno wanʉa yʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ĩre moa ĩsiri maso ñasago meje yʉ ñabojarocati yʉre ãcabojabiticõri queno yiquĩ Dios yʉre. Ito bajiri ĩre bʉto wanʉa yʉ. Ado bajiro bʉsirã yirãji yʉ bero gãna. “Isore queno yiñi Dios”, yirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ito bajiro tʉoĩarã yirãji ĩna, rẽtoro masigʉ̃ Dios yʉre queno ĩ yija ticõri. Queno yigʉ ñami Dios. Ñeñarise yiĩabicʉ ñami ĩ. ");
INSERT INTO myy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ĩre rʉ̃cʉbʉorãre ĩnare ti maitĩñagʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bʉto sẽogʉ̃ ñami Dios. Ito bajiri jaje tiyamani ĩocãyijʉ ĩ. Ito yicõri, “Rẽtoro masirã ña gʉa”, yi tʉoĩabojarãre, rẽtocũyijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ʉjarã ñasabojarã ĩna ñasabitiroca yiyijʉ Dios. Ito yicõri, “Gãjerã rẽtoro masigʉ̃ ña yʉ”, yi tʉoĩamenare ĩna ñasarã ñaroca yiyijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ñio jogarãre quenarise ecayijʉ Dios. Ito yicõri gajeoni jairã ñabojarãre cʉni ñe manoti ĩnare bucõayijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Mani ñicʉsabatia Abraham ñayorʉ mesare ado bajiro gotiyijʉ Dios. “Mʉare cʉni, mʉa janerãbatiare cʉni ti maicõri queno yi ñacʉja yʉ”, yiyijʉ Dios. Itire ãcabojabeami Dios. Ito bajiri ĩ gotiado bajiroti, mani Israel sita gãna ĩ rĩa mani ñajare, queno yi ñami Dios manire. Ito bajiri ĩ Macʉ yʉ rʉcoroca yigʉ yiguĩji Dios, yiyijo María Elisabetre. ");
INSERT INTO myy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ito yi, Elisabet ya wijʉ ʉdiarã ũmacañi ñacõayijo María ĩja. Ito iso ñaja bero tʉdi wayijo mʉcana iso ya wijʉa ĩja. ");
INSERT INTO myy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet iso macʉ rʉcori rʉmʉ ejaroca macʉ rʉcoyijo iso ĩja. ");
INSERT INTO myy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Dios isore queno yija, tʉoyijarã iso ñarã ito yicõri iso tʉ ñarã cʉni. Ito bajiri isore wanʉrã ejayijarã ĩna, iso tʉjʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Macʉacã ĩ joeaja bero ʉdia ãmojeno rʉmʉri tʉjaroca ejayijarã ĩna mʉcana. Macʉacãre ĩna yisotire bajiro ĩre wiro tarona ejayijarã ĩna. Ito yicõri ĩ jacʉ Zacarías wamere wõ ãmobojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ito yibojarocati ĩ jaco ãmobisijo: —Juan wame cʉtigʉ yiguĩji, yiyijo iso. ");
INSERT INTO myy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iso ito yija tʉocõri, ado bajiro seniĩayijarã ĩna isore: —¿No yija ito bajiro ĩre wame wõ ãmoati mʉ? Mani ñarã sĩgʉ̃ ito bajiro wame cʉtirã mama, yiyijarã ĩna isore. ");
INSERT INTO myy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ito yicõri macʉacã jacʉre seniĩarona ãmona ĩre sõju quesoĩayijarã ĩna, “¿Dise wame ãmoati mʉ?” yirona. ");
INSERT INTO myy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ito bajiro ĩna yija ticõri, macʉacã wame uca wõrocʉ ucara jãi ĩnare seniyijʉ Zacarías. Ito yija, “Juan wame cʉtigʉ yiguĩji”, yi uca wõyijʉ ĩ. Ito bajiro ĩ yija ticõri, “¿Ito bajiro wame ãmoati ĩ?” yirã, ruje tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ito bajiro ĩna yiroca riti bʉsi masibitirʉ ñabojagʉti bʉsisʉoyijʉ Zacarías mʉcana. “Queno ya Dios mʉ. Rẽtoro quenagʉ̃ ña mʉ”, yi bʉsisʉoyijʉ Zacarías Diore rʉ̃cʉbʉogʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ito ĩ yija tʉocõri, ĩ tʉjʉ ñarã ti ʉcayijarã ĩna. Ito Judea sitajʉ, gʉ̃ta yucʉrijʉ ñarã cʉni iti oca rẽtagore tʉoyijarã ĩna. Ito bajiri iti oca goti batoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Masa iti oca tʉocõri ruje tʉoĩayijarã ĩna. Ito yicõri gãmeri seniĩayijarã ĩna: “¿Ñimʉ ñasagʉ yiguĩjida ĩ bʉcʉaja? Mani Ʉjʉ Dios queno yiyijʉ ĩre”, yi masi jediyijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ito bajiro ĩna yi ñaroca Espíritu Santo quedi sãjayijʉ macʉacã jacʉ, Zacaríasre. Ĩre Espíritu Santo quedi sãjaja ticõri, ado bajiro Dios oca gotiyijʉ Zacarías: ");
INSERT INTO myy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Mani Israel gãna, mani Ʉjʉ Diore rʉ̃cʉbʉorʉja manire. Ĩti ñami rẽtoro masigʉ̃. Ito yicõri ĩ ñarã ña mani. Mani ñari tutijʉ ejacõri manire masorʉ ñami Dios. ");
INSERT INTO myy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Manire masorocʉ, sĩgʉ̃ rẽtoro masigʉ̃re cõagʉ̃ yiguĩji Dios. Mani ñicʉ David ñayorʉ Diore queno cʉdigʉ janami ñagʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jane mejejʉ ĩre goti ĩsiri masana sʉoriti ado bajiro goticãñi Dios manire: ");
INSERT INTO myy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Mʉa wajanare rẽtocũcʉja yʉ. Ito yicõri mʉare ti terãre cʉni camotacʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mʉare ti maicõri yʉ goticato bajiroti yicʉja yʉ”, yiñi Dios, yi gotiyijʉ Zacarías masare. ");
INSERT INTO myy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mani ñicʉ Abraham ñayorʉre ado bajiro goticãyijʉ Dios: ");
INSERT INTO myy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Mʉare masocʉja yʉ, mʉa wajana ĩna mʉare ruyuriobe yirocʉ. Ito bajiro yicʉja yʉ, güimenati yʉre mʉa cʉditoni. ");
INSERT INTO myy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mʉa catirocõ mʉa queno yi ñatoni, ito yicõri yiro robo yʉre mʉa cʉdi ñatoni, ito bajiro mʉare masocʉja yʉ”, yiñi Dios, mani ñicʉ Abraham ñayorʉre, yi gotiyijʉ Zacarías masare. ");
INSERT INTO myy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Ito ĩ yija bero ado bajiro yiyijʉ Zacarías macʉacãre gotigʉ: “Cristo, Dios ĩ cõarʉre masa ĩre boca ãmi ñacãtoni Dios oca ĩnare gotigʉ yigʉja mʉ. ‘Mʉa ñeñaro yirise mʉa jidicãja bero, itire ãcabojocõri mʉare masogʉ̃ yiguĩji Dios’, yi gotigʉ yigʉja mʉ masare. Ito bajiro mʉ gotija tʉocõri, ‘Dios ũmacʉ̃jʉ gagʉre goti ĩsiri masʉ ñami’, yirã yirãji masa mʉre”, yiyijʉ Zacarías, ĩ macʉacãre gotigʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Manire ti maicõri sẽoro yibeami Dios. Ito bajiri manire masorocʉ, Cristore cõagʉ̃ yiguĩji Dios mani ñari sitajʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ado ejacõri Diore masimenare ĩ oca gotigʉ yiguĩji jeame ʉ̃jʉrojʉ ĩna wabe yirocʉ. Ito yicõri ĩ rãca mani queno ʉsi cʉtitoni, Cristore cõagʉ̃ yiguĩji Dios, yiyijʉ Zacarías masare gotigʉ. ");
INSERT INTO myy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bʉcʉa mʉja wacʉti bʉto Diore tʉorʉ̃nʉ mʉja wayijʉ Zacarías macʉ, Juan wame cʉtigʉ. Dios gayere queno tʉoĩacõri ĩre bajiro ʉsi cʉtigʉ ñayijʉ Juan. Jai tujacõri yucʉ manojʉ ña ucuyijʉ ĩ. Israel sita gãnare Dios oca ĩ goti ucuroto riojʉa, itojʉ riti ña ucuyijʉ Juan maji. ");
INSERT INTO myy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Iti rʉmʉriti masa ʉjʉ Augusto wame cʉtigʉ, “Adocõ ñama yʉ ya masa”, yirocʉ ĩna wame wõ jeo ãmoyijʉ ĩ. Ito bajiri masa jeyarore wadi rotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Siria sitajʉ Cirenio ĩ ʉjʉ ñaroca ito bajiro bajiyijʉ iti cajero masare cõĩare gaye. ");
INSERT INTO myy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ito bajicõri masa jeyaro ĩna rujeara cʉtojʉ wame ucarona wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ito bajiri iti oca tʉocõri wayijʉ José cʉni. Galilea sita Nazaret wame cʉtiri cʉtojʉ ñacõri Judea sita Belén wame cʉtiri cʉtojʉ wayijʉ José ĩ wame wõrocʉ. Jane mejejʉ Belénjʉ rujeayijʉ David, masa ʉjʉ ñayorʉ. David ñayorʉ janerãbatia macʉ ñari Belénjʉ wayijʉ José. ");
INSERT INTO myy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Itojʉ wayijʉ José ĩ manojo ñaroco María rãca. Ĩ rãca ajebitibojagoti macʉ sãñagõ ñayijo iso. ");
INSERT INTO myy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belénjʉ ĩna ejaja bero macʉ iso rʉcoroti rʉmʉ ejayijʉ isore. ");
INSERT INTO myy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ito bajiri iso macʉ ñasʉogʉ rʉcoyijo iso ĩja. Ĩre saya werorina gũmacõri ecana ĩna baricorojʉ ĩre sãyijo iso. Canira wiri daja rẽtajare ecana wijʉ ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén tʉ bʉsa ñayijarã oveja coderi masa. Ta wesejʉ ñami rẽta wayijarã oveja coderã. ");
INSERT INTO myy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ñajasaroti Dios ñaro gagʉ ángel goayijʉ ĩnare. Ito yicõri Dios ĩ sĩatirise busuĩoyijʉ ĩna wato. Itire ticõri bʉto güiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ĩna güija ticõri, ado bajiro yiyijʉ ĩ: —Güibesa mʉa. Oca quenarise mʉare gotigʉ wadibʉ yʉ. Iti oca tʉocõri masa jeyaro wanʉrã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Adi ñamiti David ñayorʉ ya cʉtojʉ rujeami mʉare masorocʉ. Ĩ ñami mani Ʉjʉ ñarocʉ Cristo, Dios ĩ cõarʉ. ");
INSERT INTO myy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ĩre mʉa ti bʉjaja ado bajiro bajigʉ bʉjarã yirãji mʉa. Saya werorina gũmarʉre bʉjarã yirãji mʉa macʉacãre. Ito yicõri ecana ĩna baricorojʉ cani sãñagʉ̃ yiguĩji ĩ, yiyijʉ ángel oveja coderi masare. ");
INSERT INTO myy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ito bajiro ĩ yija beroti ĩre bajiro bajirã ángel mesa jãjarã goayijarã. Ito yicõri ado bajiro bʉsiyijarã ĩna, Diore rʉ̃cʉbʉorã: ");
INSERT INTO myy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Rẽtoro masigʉ̃ ñami Dios ũmacʉ̃jʉ gagʉ. Adi sita gãna, Dios rãca queno ʉsi cʉtirã queno wanʉ quena ñajaro ĩna, yiyijarã ángel mesa. ");
INSERT INTO myy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ito yicõri tʉdi mʉjacoayijarã ĩna. Ito ĩna mʉjagoja bero oveja coderi masa gãmeri bʉsiyijarã ĩja: —Ita, Belénjʉ wato mani. Iti rẽtagore tiĩato mani. Ito yicõri mani Ʉjʉ Dios ĩ gotirise tito mani, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ito yicõri ʉsirio wayijarã ĩna. Belénjʉ ejacõri María, Josére cʉni ti bʉjayijarã ĩna. Ito yicõri macʉacãre ecana ĩna baricorojʉ sãñagʉ̃re ti bʉjayijarã ĩja. ");
INSERT INTO myy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ĩre ti bʉjacõri, “Ado bajiro bajigʉ macʉacãre ti bʉjarã yirãji mʉa”, yi ángel ĩ gotigorere goti jeoyijarã ĩna, itijʉ ñarãre. ");
INSERT INTO myy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Itire tʉo wanʉcõri, “¿No yireoni ñati iti?” yi tʉoĩa jediyijarã itijʉ ñarã. ");
INSERT INTO myy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ito bajibojarocati Maríajʉama iti oca tʉocõri iso ya ʉsijʉ tʉoĩa wanʉ ñayijo iso. ");
INSERT INTO myy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ito bajiro iso tʉoĩa ñaroca ĩna cʉtojʉ tʉdi wayijarã oveja coderi masa. Warãti Diore rʉ̃cʉbʉorã ĩre wanʉ quenare oca bʉsiyijarã ĩna. Ángel ĩ gotigore ñaro bajiroti iti rẽtaja ticõri, Diore rʉ̃cʉbʉorã wanʉ quenare oca bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ʉdia ãmojeno rʉmʉri Jesús ĩ tʉjaroca judio masa ĩna yisotiado robo bajiro ĩre wiro tayijarã ĩna. Macʉacãre wiro ĩna taja bero Jesús ĩre wame wõyijarã ĩna. “Ito bajiro wame wõma”, yiyijʉ ángel, María iso macʉ sãñaroto riojʉa. ");
INSERT INTO myy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Jane mejejʉ ado bajiro rotiyijʉ Moisés ñayorʉ: “Romio iso rʉcoja bero jʉ̃arã masacõ rʉmʉri bero iso ñarise cʉtirise coerona Diore oveja macʉ soe ĩsima. Oveja ĩ manija, buja robo bajirã jʉ̃arã ĩre soe ĩsima. Ito yicõri buja rĩa cʉni quena ñarãji”, yi rotiyijʉ Moisés ñayorʉ. Ito bajiri ĩ rotigore cʉdirona Dios ya wi Jerusalénjʉ Jesure ãmi wayijarã ĩ jacʉsabatia. Gaje ucare ado bajiro gotia Dios oca tuti: “Macʉ ñasʉogʉ Dios yagʉ ñagʉ̃ yiguĩji. Ito yicõri ĩre moa ĩsigʉ̃ yiguĩji ĩ”, yi gotia Dios oca. Ito bajiri, “Ãni macʉacã mʉre riti ĩ moa ĩsitoni mʉre ĩsia gʉa”, yi Diore bʉsirona Jerusalénjʉ Jesure ãmi wayijarã ĩ jacʉsabatia. ");
INSERT INTO myy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iti rʉmʉri Simeón wame cʉtigʉ Jerusalénjʉ ñayijʉ. Queno Diore cʉdigʉ ñayijʉ ĩ. Israel sita gãnare masorocʉre bocati ñayijʉ Simeón. Ito yicõri Espíritu Santo quedi sãjacãrʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu Santo ado bajiro goticãyijʉ Simeónre: “Cristo, Dios ĩ cõarʉre tigʉ yigʉja mʉ, mʉ godaroto riojʉa”, yiyijʉ Espíritu Santo Simeónre. ");
INSERT INTO myy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","José, María rãca ĩna wari rʉmʉti Simeónre cʉni Dios ya wijʉ wa rotiyijʉ Espíritu Santo. Judio masa ĩna yisotiado bajiro yirona Dios ya wijʉ Jesure ãmi sãja wayijarã ĩna. Ĩna iti wijʉ sãjaroca ĩna tʉ eja rʉ̃gʉ̃yijʉ Simeón. “Dios Macʉ ñaguĩji”, yi tʉoĩacõri Jesure ãmi gajayijʉ ĩ. Jesure ãmi gajacõri, “Queno ya mʉ”, yiyijʉ Simeón Diore wanʉgʉ̃. Ado bajiro yiyijʉ Simeón, Diore: ");
INSERT INTO myy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Yʉ Ʉjʉ mʉ goticato bajiroti yʉre iti rẽtaja tia yʉ. Cristore ti bʉja yʉ, mʉ cõarʉre. Ito bajiri wanʉ quenare rãca godagʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Yʉmasiti tia yʉ, masa ĩna ñeñaro yirise coerocʉre. Jesús gʉare cõayija mʉ masa jeyaro ñeñaro ĩna yirise coerocʉre. ");
INSERT INTO myy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mʉ cõarʉ ñami, Israel sita gãna mejere cʉni ĩna tʉo masiroca yirocʉ. Ito yicõri mʉ ñarã Israel sita gãnare rʉ̃cʉbʉorã yirãji masa jeyaro, yi wanʉyijʉ Simeón, Diore queno cʉdigʉ ñari. ");
INSERT INTO myy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ĩna macʉ jaibecʉacãre ĩ ito bajiro bʉsija tʉo ʉcayijarã ĩna José, María cʉni. ");
INSERT INTO myy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ito yija ĩnare yiari Diore bʉsiyijʉ Simeón ĩna queno ñatoni. Ado bajiro yi gotiyijʉ Simeón, ĩnare. “Quenaro ñarã yirãji mʉa”, yiyijʉ Simeón, Maríare, Josére cʉni. Ito yicõri Jesús jaco Maríare ado bajiro gotiyijʉ ĩ: —Ãni macʉacã Dios ĩ beserʉ ñami. Ĩ bʉcʉacõri Israel sita gãna jãjarã Dios oca cʉdimenare ruyuriogʉ yiguĩji ĩ. Ĩre cʉdirãre ñeñaro ĩna yirisere ãcabojogʉ yiguĩji. “Dios ĩ cõarʉ ñaguĩji”, yi masibojarãti jãjarã ĩre bʉsiturã yirãji. ");
INSERT INTO myy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Masa jeyaro ĩna ya ʉsijʉ ĩna tʉoĩabojarisere ti masicõgʉ̃ yiguĩji ĩ. Ito bajibojarocati mʉ macʉre ĩna rʉ̃cʉbʉobeja ticõri, bojori bʉjago yigoja mʉ, mʉ ya ʉsijʉ, yiyijʉ Simeón macʉacã jaco Maríare. ");
INSERT INTO myy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ito bajiro ĩna bʉsi ñaroca, sĩgõ Ana wame cʉtigo Dios ya wijʉ ñayijo iso cʉni. Iso ñayijo Diore goti ĩsiri maso. Ito yicõri Fanuel maco ñari, Aser masa butu gago ñayijo iso. Bʉco ñayijo iso ĩja wajeago. Ochenta y cuatro rodori tʉjayijʉ iso manʉjʉ ĩ godagoja bero. Ado bajiro bajiyijʉ. Ĩna ãmo siaja bero jʉa ãmojeno rodori ñabojayijʉ iso manʉjʉ maji. Ito bero godacoayijʉ ĩ ĩja. Ito bajiri ĩ godagoja bero Dios ya wijʉ riti ñasotiyijo iso. Iti wijʉ ñagõ ʉ̃mʉa cʉni, ñami cʉni Diore moa ĩsisotiyijo iso. Gajereama ba yujibecoti Diore rʉ̃cʉbʉosago babeco riti ĩre bʉsiyijo iso. ");
INSERT INTO myy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jesús jacʉsabatia rãca Simeón ĩ bʉsi rʉ̃gõroca, Ana cʉni Diore bʉsiroco eja rʉ̃gʉ̃yijo iso. Ito bajiro Simeón ĩ bʉsija tʉocõri, “Queno ya Dios mʉ”, yiyijo iso. Ito bajiro Diore, “Queno ya mʉ”, yi tĩocõri, ado bajiro yi gotiyijo iso Jerusalén gãnare: “Ãni ñami mani bocaticacʉ ñeñaro mani yirisere coerocʉ”, yiyijo iso masare. ");
INSERT INTO myy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José, María rãca Dios rotirise ñarocõti cʉdirã ejagoana, Galilea sitajʉ tʉdi wayijarã ĩna mʉcana, ĩna cʉto Nazaretjʉ warã. ");
INSERT INTO myy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ito bajicõri ĩna cʉtojʉ macʉacã Jesús sẽoro bʉcʉa mʉjayijʉ. Queno tʉoĩare rãca bʉcʉayijʉ ĩ. Dios ĩ Jacʉ queno ejabʉayijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Co rodo rʉyabeto Jerusalénjʉ Pascua basa ĩna menija tirã wasotiyijarã ĩ jacʉsabatia. ");
INSERT INTO myy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús jʉa gʉbojeno rodori ĩ tʉjaroca Jerusalénjʉ Pascua basa tirã wayijarã ĩna. Co rodo rʉyabeto basa rʉmʉ ĩna tisotiado bajiro iti Pascua basa tirã wayijarã ĩna mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ito ejacõri, iti basare tiyijarã ĩna. Ito bajiri iti jedija ticõri, tʉdi wayijarã ĩna mʉcana. Ito bajiro ĩna tʉdi waroca Jesuama tujacoayijʉ Dios ya wijʉ ĩja. Ĩ jacʉsabatia, “Tujacoaguĩji”, yi tʉoĩabisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Ado mani rãca warã wato ñaguĩji”, yi tʉoĩayijarã ĩna. Ito bajiro tʉoĩa warã riti, co rʉmʉ ʉ̃mʉasaro wayijarã ĩna. Ito bajiro ĩna wajasaroti ĩre ãmabojayijarã ĩna, ĩja. “Mani rãca warã wato ñaguĩji”, yirona ãmabojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ito bajibojarocati ĩre bʉjabisijarã ĩna. Ito bajiri ĩre bʉjarona Jerusalénjʉ ĩre ãmarã wayijarã ĩna mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ʉdia rʉmʉ bero Jesure bʉjayijarã ĩna, Dios ya wijʉ ĩ ñaroca. Judio masa rotirise riasori masa wato ĩre bʉjayijarã ĩna. Riasori masa ĩna bʉsirisere tʉocõri ĩnare seniĩayijʉ Jesús. Ĩnajʉa cʉni seniĩayijarã ĩre. ");
INSERT INTO myy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Queno masigʉ̃ ñari, queno ĩ cʉdi masija ticõri, tʉo ʉcayijarã ĩna jeyaro. ");
INSERT INTO myy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ito bajiroca ĩ jacʉsabatia ĩre ti bʉjacõri, tʉo ʉcayijarã, ito ĩ yija tʉocõri. Ito bajiri ĩ jaco ado bajiro yiyijo ĩre: —¿No yija gʉa waroca gʉare gotibicʉti, tujacati macʉ mʉ? Mʉ manija ticõri, bʉto tʉoĩa oca jaicʉ yʉ, mʉ jacʉ cʉni, yiyijo ĩ jaco ĩre. ");
INSERT INTO myy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iso ito bajiro yija tʉocõri, ado bajiro isore cʉdiyijʉ Jesús: —¿No yija yʉre ãmacati mʉa? “Ĩ Jacʉ ya wijʉ ñaguĩji”, ¿yi masibiticati mʉa? yi cʉdiyijʉ Jesús, ĩ jacʉsabatiare. ");
INSERT INTO myy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ito bajiro ĩ yibojarocati ĩ bʉsirisere queno tʉo masibisijarã ĩ jacʉsabatia. ");
INSERT INTO myy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ito ĩna yija bero ĩna rãca tʉdicoayijʉ ĩ ĩja, Nazaretjʉ. Nazaretjʉ tʉdi ejacõri ĩ jacʉsabatia rotiro bajiroti cʉdisotiyijʉ ĩ. Ito yicõri iso macʉ Jerusalénjʉ ĩ yigorere tʉoĩa ñasotiyijo Jesús jaco. ");
INSERT INTO myy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ĩ tʉoĩarise rãcati bʉcʉa mʉja wayijʉ Jesús. Dios cʉni, masa cʉni ĩre ti mai rʉ̃cʉbʉoyijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio wame cʉtigʉ ʉjʉ ĩ sãjaja bero, quince rodori ĩ ña tujaroca Poncio Pilato wame cʉtigʉ Judea sita ʉjʉ ñayijʉ ĩ. Gãji Galilea sita gagʉ ʉjʉ ñayijʉ Herodes wame cʉtigʉ. Ito yicõri ĩ ocabaji Felipe wame cʉtigʉ jʉa sita ʉjʉ ñayijʉ. Iti ĩ sita rʉcorise wame cʉtiyijʉ Iturea, ito yicõri Traconite. Ito bero gãji Lisanias wame cʉtigʉ Abilinia sita ʉjʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Masa ito bajiro sita ĩna rʉco ñaroca Anás ito yicõri Caifás wame cʉtirã, ĩna ñayijarã paia ʉjarã. Ito bajiro ʉjarã ĩna ñaroca, Zacarías macʉ Juan wame cʉtigʉ yucʉ manojʉ ña ucuyijʉ. Ito ĩ ñaroca oca goti rotiyijʉ Dios ĩre. ");
INSERT INTO myy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ito bajiro Dios ĩ gotija tʉocõri, riaca Jordán wame cʉtirisa tʉjʉ Dios oca goti ucugʉ wayijʉ Juan. Ado bajiro yi goti ucuyijʉ ĩ: —Mʉa ñeñaro yirise jidicãcõri quenarise mʉa ya ʉsijʉ tʉoĩa wasoaya ĩja. Ito bajiro mʉa tʉoĩaja, mʉa ñeñaro yirise ãcabojagʉ yiguĩji Dios. Dios oca yʉ gotirise mʉa tʉorʉ̃nʉja, idé gu roti masirãji mʉa, yiyijʉ Juan masare gotigʉ. ");
INSERT INTO myy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sĩgʉ̃ Diore goti ĩsiri masʉ Isaías wame cʉtigʉ ĩ ucado bajiroti yiyijʉ Juan. “Ado bajiro yigʉ yiguĩji”, yirocʉ uca yuyijʉ Isaías, Juanre tʉoĩa yugʉ: Sĩgʉ̃ yucʉ manojʉ ado bajiro yi sẽria gotigʉ yiguĩji: “Mʉa ya ʉsijʉ queno tʉoĩa ñaña mʉa, mani Ʉjʉ ĩ ejaroto riojʉa, mʉa ya ʉsijʉ ĩ queno ña masitoni. ");
INSERT INTO myy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mʉare ñeñaro tʉoĩare gaye ñaja itire jidicãña. Mʉa ñeñaro yirise iti rʉyaja, itire jidicãcõri, quenarisejʉare tʉoĩaña. Mʉa tʉoĩarise rocati iti wisaja quenarisejʉare tʉoĩa ñaña. Ito yicõri jeyaro mʉa ñeñaro tʉoĩarisere jidicãña. ");
INSERT INTO myy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ito bajiro mʉa yija bero masare masorocʉ, Dios ĩ cõarʉre ti jedirã yirãji masa jeyaro”, yigʉ yiguĩji sĩgʉ̃ yucʉ manojʉ, yi ucayijʉ Isaías, Juanre tʉoĩa yugʉ. ");
INSERT INTO myy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jãjarã masa Juanre ĩna idé gu rotirã ejaja, ado bajiro yiyijʉ Juan ĩnare: —Ãña rima iti juniro bajiro ñeñaro yirã ña mʉa. Ado bajiro tʉoĩaboja mʉa: “Dios ĩ waja seniri rʉmʉ iti ejaroca manire waja senibiquĩji Dios. Mani ñeñaro yirã ñabojarocati manire ti maicõri manire waja senibiquĩji ĩ”, yi tʉoĩaboja mʉa, yiyijʉ Juan masare. ");
INSERT INTO myy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","’Ñeñaro mʉa yirise jidicãcõri quenarise riti tʉoĩa ñaña mʉa. Ito bajiro riti yisotiba, “Quenarisejʉa tʉoĩarã ñama ĩja”, masa mʉare yi ti masitoni. Ado bajiro yi tʉoĩabesa mʉa. “Abraham ñayorʉ janerãbatia ña gʉama. Ito bajiri Dios ĩ beseana ña gʉa cʉni”, yi tʉoĩabesa mʉa. Ado bajiro bajia. Adi gʉ̃tana Abraham janerãbatia robo bajiro ĩ godo weo ãmoja, godo weo masiguĩji Dios, yiyijʉ Juan ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ito yicõri ado bajiro goti masiore ocana gotiyijʉ Juan: —Comeana yucʉre quẽarocʉ ñacãmi Dios. Ito bajiri yucʉ queno rica manigʉ̃re ti bʉjacõri quẽagʉ̃ yiguĩji Dios. Ito yicõri jeana soegʉ yiguĩji ĩ. Ado bajiro yireoni ña iti. Masa ĩna ñeñaro yirise waja senirocʉ ñacãmi Dios. Ito bajiri ĩna ñeñaro yirisere jidicãbeja ticõri ĩnare ruyuriogʉ yiguĩji Dios. Ito yicõri jeame ʉ̃jʉrojʉ cõagʉ̃ yiguĩji Dios ĩnare, yiyijʉ Juan masare. ");
INSERT INTO myy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ito bajiro ĩ yija tʉocõri, masajʉa ĩre ado bajiro seniĩayijarã: —¿No bajiro gʉa yire ãmoati Dios? yi seniĩayijarã ĩna Juanre. ");
INSERT INTO myy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ĩna ito bajiro yija cʉdiyijʉ Juan: —No camisa jʉaro rʉcogʉ, gãji rʉcobicʉre coro ĩsija quena. Ito yicõri no bare rʉcogʉ, bojoro bʉjarãre ĩsija quena, yiyijʉ Juan ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ʉjarãre yiari waja seni ĩsiri masa cʉni, Juanre idé gu rotirã ejayijarã. Ĩre ado bajiro seniĩayijarã ĩna: —Gʉare riasogʉ, ¿no bajiro gʉa yire ãmoati Dios? yi seniĩayijarã ĩna Juanre. ");
INSERT INTO myy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Baʉ, ʉjarã mʉare niyeru ãmi rotirocõti ãmiña. Ito yicõri, ʉjarã ĩna rotiro rẽto bʉsaro ãmibesa, yiyijʉ Juan ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Surara cʉni ado bajiro ĩre seniĩayijarã: —¿No bajiro gʉa yire ãmoguĩjida Dios? yiyijarã ĩna Juanre. Ĩna ito yija: —Baʉ, masare ĩna rʉcorise ẽmabesa. Ĩnare rʉocõri ĩna rʉcorisere jeyaro ẽmabesa. Ĩnare sẽoro yicõri ĩna rʉcorisere ẽmabesa. Ito yicõri, mʉa moare waja, ʉjarã mʉare ĩna waja yirocõti boca ãmiña. Mʉcana tʉdi ĩnare seni ʉyabesa, yiyijʉ Juan ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ito bajiro ĩ yija tʉocõri, ado bajiro tʉoĩa ʉsirioyijarã ĩna: “Cristo, ¿Dios ĩ cõarʉti ñati ãni?” yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ito bajiro ĩna yibojarocati ado bajiro yiyijʉ Juan ĩnare: —Cristo meje ña yʉ. Idenati masare idé gua yʉama. Yʉ bero rẽtoro ñasagʉ ejagʉ yiguĩji. Yʉ rẽtoro ñasagʉ ĩ ñajare ĩre bajiro rẽtoro ñasagʉ meje ña yʉ. Ĩre mʉa tʉorʉ̃nʉjama Espíritu Santo mʉare queo sãgʉ̃ yiguĩji ĩja. Ito bajiro mʉare Espíritu Santo queo sãcõri queno mʉare mʉa tʉoĩaroti ejabʉagʉ yiguĩji ĩ, yiyijʉ Juan ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ito yicõri gaje ado bajiro gotiyijʉ Juan ĩnare: —Yʉ bero ejagʉ trigo ajeri besegʉ bajiro yigʉ yiguĩji masare. Sĩgʉ̃ trigo otegʉ iti wirori coda batecõri ajeri riti seo masiguĩji ĩ. Ito bajiro ĩ codaja bero iti wirorire jeamejʉ soeguĩji ĩ. Jedirime meje ñaroja itime jeame. Wirori ĩ soegori ajeriama ĩ cũrojʉ seo cũgʉ̃ yiguĩji ĩ. Ito bajiro yigʉ yiguĩji mani Ʉjʉ adojʉ ejagʉ. Trigo ajeri beseado bajiroti besegʉ yiguĩji manire, yi gotiyijʉ Juan masare. ");
INSERT INTO myy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ito bajiro ĩ gotiro watoti Dios oca quenarise masare gotiyijʉ Juan, Diore ĩna cʉditoni. ");
INSERT INTO myy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gajerea, Herodes ʉjʉre goti tudiyijʉ Juan. Ĩ ocabaji Felipe manojo Herodías wame cʉtigore Herodes ĩ manojo cʉtija, ito bajiro ĩre goti tudiyijʉ Juan. Gaje ĩ ñeñaro yirise masicõri ĩre goti tudiyijʉ Juan. ");
INSERT INTO myy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ito bajiro ĩ bʉsija tʉobojagʉti ĩre tʉorʉ̃nʉbisijʉ Herodes. Ito yicõri bʉto bʉsa ñeñaro yi ʉyagʉ Juanre tubia rotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Co rʉmʉ tubiara wijʉ ĩre ĩna tubiaroto riojʉa, jãjarã masare idé guyijʉ Juan. Ito yicõri Jesure cʉni idé guyijʉ Juan. Ĩ idé guja bero Diore bʉsiyijʉ Jesús. Ito bajiro ĩ bʉsi rʉ̃gõroca ũmacʉ̃jʉ macãrʉcʉ̃rojʉ janayijʉ. Ito yicõri bujare bajiro bajigʉna quedi sãja wadicõri Jesús joe quedi jeayijʉ Espíritu Santo. Ito bajiro ĩ quedi jeaja bero ado bajiro oca ruyuyijʉ ũmacʉ̃jʉ: —Yʉ macʉ ña mʉ, yʉ maigʉ̃. Mʉre bʉto wanʉa yʉ, yi bʉsiyijʉ Dios, Jesure bʉsigʉ. ");
INSERT INTO myy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sĩgʉ̃ masʉcõ gãji ye jʉa dʉjamocõ rodori tʉjagʉ, masare riasosʉoyijʉ Jesús. “José macʉ ñami Jesús”, yi tʉoĩayijarã masa. Iti riojʉa ado bajiro wame cʉtirã ñasʉoyijarã masa. José jacʉ ñayijʉ Elí. ");
INSERT INTO myy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí jacʉ ñayijʉ Matat. Matat jacʉ ñayijʉ Leví. Leví jacʉ ñayijʉ Melqui. Melqui jacʉ ñayijʉ Jana. Jana jacʉ ñayijʉ José. ");
INSERT INTO myy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José jacʉ ñayijʉ Matatías. Matatías jacʉ ñayijʉ Amós. Amós jacʉ ñayijʉ Nahúm. Nahúm jacʉ ñayijʉ Esli. Esli jacʉ ñayijʉ Nagai. ");
INSERT INTO myy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai jacʉ ñayijʉ Maat. Maat jacʉ ñayijʉ Matatías. Matatías jacʉ ñayijʉ Semei. Semei jacʉ ñayijʉ Josec. Josec jacʉ ñayijʉ Judá. ");
INSERT INTO myy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá jacʉ ñayijʉ Joanán. Joanán jacʉ ñayijʉ Resa. Resa jacʉ ñayijʉ Zorobabel. Zorobabel jacʉ ñayijʉ Salatiel. Salatiel jacʉ ñayijʉ Neri. ");
INSERT INTO myy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri jacʉ ñayijʉ Melqui. Melqui jacʉ ñayijʉ Adi. Adi jacʉ ñayijʉ Cosam. Cosam jacʉ ñayijʉ Elmadam. Elmadam jacʉ ñayijʉ Er. ");
INSERT INTO myy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er jacʉ ñayijʉ Josué. Josué jacʉ ñayijʉ Eliezer. Eliezer jacʉ ñayijʉ Jorim. Jorim jacʉ ñayijʉ Matat. ");
INSERT INTO myy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat jacʉ ñayijʉ Leví. Leví jacʉ ñayijʉ Simeón. Simeón jacʉ ñayijʉ Judá. Judá jacʉ ñayijʉ José. José jacʉ ñayijʉ Jonam. Jonam jacʉ ñayijʉ Eliaquim. ");
INSERT INTO myy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim jacʉ ñayijʉ Melea. Melea jacʉ ñayijʉ Mena. Mena jacʉ ñayijʉ Matata. Matata jacʉ ñayijʉ Natán. ");
INSERT INTO myy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán jacʉ ñayijʉ David. David jacʉ ñayijʉ Isaí. Isaí jacʉ ñayijʉ Obed. Obed jacʉ ñayijʉ Booz. Booz jacʉ ñayijʉ Salmón. Salmón jacʉ ñayijʉ Naasón. ");
INSERT INTO myy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón jacʉ ñayijʉ Aminadab. Aminadab jacʉ ñayijʉ Admin. Admin jacʉ ñayijʉ Arni. Arni jacʉ ñayijʉ Esrom. Esrom jacʉ ñayijʉ Fares. Fares jacʉ ñayijʉ Judá. ");
INSERT INTO myy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá jacʉ ñayijʉ Jacob. Jacob jacʉ ñayijʉ Isaac. Isaac jacʉ ñayijʉ Abraham. Abraham jacʉ ñayijʉ Taré. Taré jacʉ ñayijʉ Nacor. ");
INSERT INTO myy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor jacʉ ñayijʉ Serug. Serug jacʉ ñayijʉ Ragau. Ragau jacʉ ñayijʉ Peleg. Peleg jacʉ ñayijʉ Heber. Heber jacʉ ñayijʉ Sala. ");
INSERT INTO myy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala jacʉ ñayijʉ Cainán. Cainán jacʉ ñayijʉ Arfaxad. Arfaxad jacʉ ñayijʉ Sem. Sem jacʉ ñayijʉ Noé. Noé jacʉ ñayijʉ Lamec. ");
INSERT INTO myy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec jacʉ ñayijʉ Matusalén. Matusalén jacʉ ñayijʉ Enoc. Enoc jacʉ ñayijʉ Jared. Jared jacʉ ñayijʉ Mahalaleel. Mahalaleel jacʉ ñayijʉ Cainán. ");
INSERT INTO myy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán jacʉ ñayijʉ Enós. Enós jacʉ ñayijʉ Set. Set jacʉ ñayijʉ Adán. Adánti ñayijʉ ĩja Dios rujeorʉ. Ito bajiri Dios macʉ ñayijʉ Adán. ");
INSERT INTO myy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús ĩ idé gu ecoja bero Espíritu Santo ĩ rãca bʉto ñayijʉ. Ito yicõri riaca Jordán wame cʉtirisa tʉ ĩ ñaroca, yucʉ manojʉ ĩre ãmi wayijʉ Espíritu Santo. ");
INSERT INTO myy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yucʉ manojʉ ejacõri jʉ̃arã masacõ rʉmʉri ñayijʉ Jesús itojʉ. Itojʉ ĩ ñari rʉmʉri cõti, bare babicʉti ñayijʉ Jesús. Itocõ bero ñiocõyijʉ mʉcana. Ĩ ito bajiro ñiocõ ñaroca, ñeñaro ĩ yitoni ʉsirioro yi codeyijʉ rʉ̃mʉ́a ʉjʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ado bajiro rʉoyijʉ rʉ̃mʉ́ ĩre: —Riti Dios Macʉ mʉ ñaja, adi gʉ̃tanati naju godo weogʉ yigʉja mʉ, yiyijʉ rʉ̃mʉ́ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ito bajiro rʉ̃mʉ́ ĩre yibojarocati: —Yibea. Dios oca tuti ado bajiro gotia: “Najuna riti meje catirã yirãji masa. Jeyaro Dios ocana sʉoriti queno wanʉ quena ñarã yirãji masa”, yi gotia Dios oca tuti, yiyijʉ Jesús rʉ̃mʉ́re. ");
INSERT INTO myy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ito bero cogʉ gʉ̃tagʉ̃ ũmaricʉ joejʉ ãmi wayijʉ rʉ̃mʉ́ Jesure. Itojʉ ãmi ejacõri yoari mejeti adi macãrʉcʉ̃ro ñajediro ñari cʉtorire ĩo jeocõyijʉ rʉ̃mʉ́ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Ado bajiro goti rʉoyijʉ rʉ̃mʉ́ itigʉ gʉ̃tagʉ̃ joejʉ ñacõri: —Yʉre rʉ̃cʉbʉogʉ yʉ riojo rijomunigãna mʉ ñini rũjũja adocõ mʉre ĩsicʉja yʉ. Adi macãrʉcʉ̃ro jeyaro ñarise, ito yicõri adi macãrʉcʉ̃ro ñarã masa ñarocõti mʉre ĩsicʉja yʉ. Ito yicõri adi macãrʉcʉ̃ro ñajediro ʉjʉ ñagʉ̃ yigʉja mʉ, yʉre mʉ rʉ̃cʉbʉoja, yiyijʉ rʉ̃mʉ́ Jesure rʉogʉ. ");
INSERT INTO myy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ito bajiro ĩ gotibojarocati: —Wasa Satanás mʉ, yiyijʉ Jesús rʉ̃mʉ́re. Ado bajiro gotia Dios oca tuti: “Mani Ʉjʉ Diore riti rʉ̃cʉbʉocõri cʉdija quena”, yi gotia Dios oca tuti, yiyijʉ Jesús rʉ̃mʉ́re. ");
INSERT INTO myy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Ĩ ito yibojaroca riti Jerusalénjʉ Jesure ãmi wayijʉ rʉ̃mʉ́ mʉcana. Ito ejacõri mʉcana Dios ya wi joejʉa ãmi mʉja wayijʉ rʉ̃mʉ́. Ito ĩre ãmi mʉja ejacõri ado bajiro yiyijʉ: —Tʉoya Jesús. Ado bajiro gotia Dios oca tuti: Ángel mesare mʉre code rotigʉ yiguĩji Dios. Mʉ quedi waja gʉ̃tagã joejʉ quedi jeacõri mʉ ya gʉbo jeabe yirona mʉre boca ãmirã yirãji, yi gotia Dios oca tuti. Riti Dios Macʉ mʉ ñaja adojʉna bubu quedi wacʉ yigʉja mʉ, yi rʉoyijʉ rʉ̃mʉ́ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ito bajiro ĩ yibojarocati ado bajirojʉa yiyijʉ Jesús ĩre: —Mʉ ito bajiro yirisere cʉdibicʉja yʉ. Gaje ado bajiro gotia Dios oca. Tite mʉ: “ ‘No bajiro Dios ĩ yija ticʉja yʉ’, yirocʉ ĩre ʉsirio codebesa”, yi gotia Dios oca tuti, yiyijʉ Jesús rʉ̃mʉ́re. ");
INSERT INTO myy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ito ĩ yija bero ʉsirioro yire oca bʉjabisijʉ rʉ̃mʉ́ ĩja. Ito bajiri Jesure jabeto cʉnígoyijʉ rʉ̃mʉ́. ");
INSERT INTO myy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Galileajʉ tʉdi wayijʉ Jesús mʉcana, yucʉ manojʉ ña ucugorʉ. Ito yicõri Espíritu Santo Jesús rãca ĩ ñajare bʉto ĩ tʉoĩa masirise ñayijʉ Jesure ĩja. Galilea ĩ tʉdi ejaroca masa jeyaro ĩ rẽtagorere bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ito bajiro wa ucu ĩ tʉdi ejaja bero judio masa ĩna minijuari wirijʉre riaso ucuyijʉ Jesús. Ito bajiro ĩ goti ucuja tʉocõri, “Queno gotiami ãni”, yi rʉ̃cʉbʉoyijarã masa jeyaro. ");
INSERT INTO myy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Ito yicõri ĩ bʉcʉara cʉto Nazaret wame cʉtiri cʉtojʉ wayijʉ Jesús. Ito ejacõri judio masa ĩna tujacãri rʉmʉ ñaroca ĩna minijuari wirijʉ sãja ucuyijʉ Jesús, ĩ yisotiado bajiroti. Ito ĩ sãja ejaroca Isaías ĩ ucagora jũ ĩsiyijarã gãjerã ĩre, ĩ ti gotitoni. Iti jũ boca ãmicõri ĩ gotiroti ãmayijʉ Jesús. Ito bajiro ãmacõri bʉjayijʉ. Ado bajiro gotiyijʉ iti: ");
INSERT INTO myy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu Santo yʉ rãca ñami. Bojoro bʉjarãre oca quenarise yʉ gotitoni yʉre cũñi Espíritu Santo. Ito yicõri ĩna ya ʉsijʉ bojori bʉjarãre ĩna wanʉ quenaroca yʉ yitoni yʉre cũñi ĩ. Tubia ecoanare yʉ bucõatoni yʉre cũñi Espíritu Santo. Ñeñaro yirise jidicãjaro ĩna yirocʉ, yʉre cũñi Espíritu Santo. Ito bajiri cajea timenare cʉni mʉcana ĩna tʉdi tiroca yirocʉre yʉre cũñi Espíritu Santo. Ito yicõri gãjerã ñeñaro yi ecoana ĩna jidicãroca yirocʉre yʉre cũñi Espíritu Santo. ");
INSERT INTO myy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ito yicõri, “No ĩre tʉorʉ̃nʉgʉ̃re queno yirocʉ ñacãmi Dios”, yʉ yi gotitoni yʉre cũñi Espíritu Santo, yi gotia iti oca, yi gotiyijʉ Jesús ĩna minijuari wijʉ. ");
INSERT INTO myy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ito bajiro goti tĩocõri papera tutire biayijʉ ĩ. Ito yicõri iti wi ejabʉari masʉre iti tutire jʉdacõayijʉ Jesús. Ito yicõri eja rũjũyijʉ. Ito bajiro ĩ yirise ticõri bʉto tiju wa rũjũcoayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ito bajiro ĩna ti rujiroca mʉcana ado bajiro bʉsiyijʉ Jesús: —Jane mejejʉ Isaías ĩ yʉre uca yure, adi rʉmʉ mʉa tiro riojo rẽta yʉre, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ito bajiro Jesús oca quenarise ĩ gotija tʉocõri, tʉo ʉcayijarã ĩna. Ito yicõri masa jeyaro quenarise oca ĩre bʉsiyijarã ĩna. Ito bajiri ĩnamasiti ado bajiro gãmeri seniĩayijarã ĩna: —¿José macʉ meje ñati ãni? yi gãmeri seniĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ito bajiro ĩna yija tʉo masicõri ado bajiro yi cʉdiyijʉ Jesús: —Masa oca gotire robo bajiro yʉre yirã yirãji mʉa: “Sĩgʉ̃ ʉco masʉ ĩ ñaja, ĩmasiti yisio masiguĩji”, yirã yirãji mʉa yʉre. Ito yicõri gaje ado bajiro yʉre yirã yirãji mʉa: “ ‘Capernaumjʉ tiyamani ĩoyijʉ Jesús’, yire oca tʉocʉ gʉa. Ito bajiri ado mʉ cʉtojʉ cʉni ito bajiroti mʉ ĩore ti ãmoa gʉa”, yʉre yirã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ito bajiro yicõri ado bajirojʉa yiyijʉ mʉcana: —Riti mʉare gotia yʉ. Sĩgʉ̃ Diore goti ĩsiri masʉ ĩ cʉtoti ĩ gotija ĩ ñarã ĩre queno tʉorʉ̃nʉmenaji ĩna. Ito bajiri adi cʉto gagʉ yʉ ñajare yʉre queno tʉorʉ̃nʉmenaji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Jane mejejʉ gãna Diore ĩna tʉorʉ̃nʉbitiado bajiroti queno tʉorʉ̃nʉbea mʉa cʉni. Tite. Sĩgʉ̃ Elías wame cʉtigʉ Diore goti ĩsiri masʉ ĩ ñaroca ʉdia rodo gaje rodo gʉdarecocõ ide quedibisijʉ. Ito bajiri iti cʉtorijʉ bare mañijʉ. Ito bajicõri bʉto ñiojogayijarã masa. Ito bajiro iti baji ñaroca Israel sitajʉ manʉjʉ godagoana romia jãjarã ñayijarã. Ito bajibojarocati Diore masa ĩna tʉorʉ̃nʉbitire waja, ĩnare ejabʉatoni wa rotibisijʉ Dios Elíasre. Ado bajirojʉa yiyijʉ Dios. Sidón wame cʉtiri cʉto tʉ Sarepta gago ĩre tʉorʉ̃nʉgõre ejabʉatoni wa rotiyijʉ Dios Elíasre, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ito bero Eliseo wame cʉtigʉ Diore goti ĩsiri masʉ ĩ ñaroca Israel sita gãna jãjarã cami jogarã ñayijarã. Ito bajibojarocati Diore masa ĩna tʉorʉ̃nʉbitire waja, ĩnare yisio rotibisijʉ Dios Eliseore. Ado bajirojʉa yiyijʉ Dios. Sĩgʉ̃ Siria sita gagʉ Naamán wame cʉtigʉre, yisio rotiyijʉ Dios, Eliseore, yi gotiyijʉ Jesús iti wi minijua ñarãre. ");
INSERT INTO myy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ito bajiro ĩ yija tʉocõri, iti wi minijua ñarã bʉto junisiniyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tʉria gʉdareco ñayijʉ iti cʉto. Ito bajiro ĩre junisinicõri tʉria joejʉ Jesure ãmi wayijarã ĩna. Ito ejacõri ĩre tumicã queorona yibojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ito yibojaroca riti ĩna wato ñabojagʉti wa godacoayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ito bajiro ĩnare rudigocõri Capernaumjʉ wayijʉ Jesús. Galilea sitajʉ ñayijʉ Capernaum wame cʉtiri cʉto. Itojʉ ejacõri tujacãra rʉmʉ ñaroca masa ĩna minijuari wijʉ sãjayijʉ Jesús. Ito sãjacõri masare riasoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dios cũrʉ ñari, queno masare riaso masiyijʉ Jesús. Ito bajiri ĩ bʉsija tʉocõri, tʉo ʉcayijarã masa. ");
INSERT INTO myy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ito bajiro ĩ bʉsi ñaroca, iti wijʉ sĩgʉ̃ ĩ ya ʉsijʉ rʉ̃mʉ́ sãja ecorʉ ñayijʉ. Ado bajiro Jesure sẽoro sẽria bʉsiyijʉ ĩ: ");
INSERT INTO myy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Wasa, Jesús Nazaret gagʉ mʉ. ¿No yija gʉare ʉsirioro yati mʉ? Gʉare ruyuriorocʉ eja mʉ, yiyijʉ rʉ̃mʉ́ sãja ecorʉ Jesure. Mʉre ti masia yʉ. Dios Macʉ quenagʉ̃guti ñacõa mʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ito ĩ yija ado bajiro yi tudiyijʉ Jesús ĩre: —Bʉsibesa ĩja, yiyijʉ Jesús ĩre. Ito yicõri, Ãni ya ʉsijʉ sãñagʉ̃, budiya mʉ, yiyijʉ Jesús rʉ̃mʉ́re. Ito bajiro ĩ yirocati, masa jãjarã tiro riojo ĩre tumicãcũ, budicoayijʉ rʉ̃mʉ́ ĩja. Ĩ ito bajiro budigoja bero queno cati quenagʉ̃ tujayijʉ masʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jesús ĩ ito bajiro rʉ̃mʉ́re ĩ budi rotija ticõri, mano ti ʉcayijarã ito ñarã. Iti ticõri ĩnamasiti gãmeri bʉsiyijarã ĩna ĩja: —¿Ñe gaye ñarojada ĩ ito bajiro bʉsija? Bʉto ĩ tʉo masirisena rʉ̃mʉ́re budi rotiami ãni. Rʉ̃mʉ́are ĩ budi rotija cojisiti budicoama, yi gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ito bajiro Jesús ĩ yirere tʉocõri iti cʉto tʉ ñarã ĩna ñarocõti itire gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús judio masa ĩna minijuari wijʉ ñarʉ budi wayijʉ ĩ. Ito yicõri Simón Pedro wame cʉtigʉ ya wijʉ wayijʉ. Ĩ ya wi sãja ejacõri Simón mañicõ rujʉ yarise iso cõja tiyijʉ Jesús. Iso ito bajija ticõri, ito gãna isore yisioroti ãmorã josayijarã Jesure. ");
INSERT INTO myy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iso tʉjʉ eja rʉ̃gʉ̃cõri rujʉ yarise rẽta rotiyijʉ Jesús. Ito ĩ yirocati rujʉ yarise rẽtacoayijʉ isore ĩja. Ito bajiro iti rẽtarocati masare eca bocasʉoyijo iso. ");
INSERT INTO myy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ito bajiro ĩ rẽtaja tʉocõri, ũmacañi ĩ quedi sãgʉ̃ wagʉ yiroca cõrãre ãmi minijuayijarã ĩna Jesús tʉjʉ ĩnare ĩ yisiotoni. Ricati riti cõrã ñayijarã ĩna. Ĩna ito bajija ticõri, ĩ ya ãmona moa jeoyijʉ Jesús. Ito bajiro ĩ yirocati rẽtacoayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ito yicõri jãjarã rʉ̃mʉ́a sãja ecoanare cʉni rʉ̃mʉ́are budi rotiyijʉ Jesús. Ito bajiro ĩ yirocati budirãti awasãyijarã rʉ̃mʉ́a ĩja. —Dios Macʉguti ña mʉ, yi awasãyijarã rʉ̃mʉ́a, budi warã. “Cristo Dios ĩ cõarʉ ñami”, ĩna yija ti masicõri, “Bʉsibesa”, yi tudiyijʉ Jesús rʉ̃mʉ́are. ");
INSERT INTO myy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gaje rʉmʉ busuri cʉto tʉnima sõjʉajʉ wayijʉ Jesús. Ito bajiro ĩ wagoja bero ĩre ãmayijarã masa ĩja. Ito bajiro ĩre ãmarã riti ĩ ñarojʉ ĩre bʉjacõyijarã ĩna. Ĩre bʉjacõri gaje cʉtojʉ ĩre wa rotibitibojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ito bajiro ĩna wa rotibitibojarocati ado bajiro yiyijʉ Jesús ĩnare: —Gaje cʉtori gãnare cʉni, “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca goti ucurʉja yʉre. Ito bajiro yʉ goti ucutoni yʉre cũñi Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ito ĩ yija bero Galilea sitajʉ judio masa ĩna minijuari wirijʉ Dios oca goti ucuyijʉ Jesús ĩja. ");
INSERT INTO myy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Co rʉmʉ Genesaret wame cʉtirita tʉnima Jesús ĩ ñaroca jãjarã masa ejayijarã. Dios oca ĩ gotija bʉto tʉo ãmocõri ĩ tʉjʉ ejayijarã ĩna. Jãjarã ñacõri bʉto bidiro ñayijarã. Ito bajiri rʉ̃gõrajʉ mañijʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ito bajiro ĩre rʉ̃gõrajʉ maniroca itajura tʉnima jʉaga cuma iti jayaja tiyijʉ Jesús. Iti cuma ʉjarã wai jori masa ñayijarã. Ito tʉ ĩna ya yori yucʉri coerã yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iti cuma jayaja ticõri, itiga cumajʉ sãjayijʉ Jesús. Ito yicõri ñuro rotiyijʉ Jesús itiga cumare. Itiga cuma Simón yaga ñayijʉ. Iti cumajʉ rujicõri masare Dios oca riasoyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Riaso tĩocõri ado bajiro gotiyijʉ Jesús Simónre: —Ʉ̃carojʉ wija wato mani. Itojʉ mʉa ya yori yucʉrina wai ñuma mʉa, yiyijʉ Jesús Simónre. ");
INSERT INTO myy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ ĩ: —Gʉare riasogʉ, ñamiasaro wai jobojabʉ gʉa, sĩabijʉ. Ito bajibojarocati mʉ rotiro bajiroti, yorigʉ ñucʉja yʉ, yiyijʉ Simón Jesure. ");
INSERT INTO myy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ito yicõri ĩna yorigʉ ñuroca, jãjarã wai sãjayijarã ĩja. Ito bajiri ĩna ya yorigʉ cudusʉoyijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ito bajiro ĩna wai ñaja ticõri, gaje cuma ĩna baba mesa ñari cumare ãmo bʉye ñucayijarã, ĩna ejabʉatoni. Ito bajiro ĩna jija ticõri, ejayijarã ĩna. Ito ejacõri jãjarã wai bʉjayijarã ĩna. Iti cuma jʉa cumari cʉrisere dajocõyijarã. Jabeto rʉyabojayijʉ iti rujaroto. ");
INSERT INTO myy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ito bajiro wai jãjarã bʉjacõri Jesús riojo rijomunigãna ñini rũjũyijʉ Simón Pedro. Ito yicõri ado bajiro yiyijʉ: —Yʉ Ʉjʉ bʉto ñeñaro yi jaigʉ ña yʉ. Queno yigʉ ña mʉáma. Ito bajiri yʉ tʉ mʉ ñaja quenbetoja, yiyijʉ Simón Jesure. ");
INSERT INTO myy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón ito yicõri ĩ rãca gãna cʉni wai jãjarã ĩna ñaja ticõri, ti ʉcayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gaje cuma ñarã cʉni ti ʉcacoayijarã ĩna. Ĩna ñayijarã Zebedeo rĩa. Santiago, Juan wame cʉtirã ñayijarã ĩna. Ĩna ti ʉcaja ticõri, Simónre ado bajiro yiyijʉ Jesús: —Güibesa. Wai joreti ña mʉa ya moare. Ito bajibojarocati jane gaje mʉare moare cũa yʉ. Masa Diore ĩna masitoni oca riaso ucuri masa mʉare cũa yʉ adocãta, yiyijʉ Jesús, Simón mesare. ");
INSERT INTO myy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ito ĩ yija bero tʉnimajʉ jãja wayijarã mʉcana. Ito yicõri jeyaro ĩna moabojarisere jidicãcõri Jesús rãca wayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Co rʉmʉ Jesús gaje cʉto ĩ ña ucuroca sĩgʉ̃ ĩ ya rujʉ cami jogagʉ ñayijʉ. Jesure ti bʉjacõri ĩ riojo ñini rũjũcõri ĩre josayijʉ: —Yʉ Ʉjʉ, yʉre mʉ yisio ãmoja, yisiogʉja mʉ, yiyijʉ cami jogagʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ito ĩ yija tʉocõri, ĩ ya ãmona moa jeoyijʉ Jesús ĩre. Ito yicõri ado bajiro yiyijʉ ĩre: —Ãmoa yʉ. Mʉre yisioa yʉ, yiyijʉ Jesús. Ito ĩ yirocati ĩ ya cami yaticoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ito bajiro ĩre yisiocõri, gãjerãre goti bato rotibisijʉ Jesús. Ito yicõri ado bajiro yiyijʉ ĩre: —Riojoti pai tʉjʉ wasa mʉ. Ĩ tʉjʉ ejacõri mʉ ya rujʉ cami yatirise gaye ĩoma. Ito yicõri Moisés ñayorʉ ĩ rotiado bajiroti Diore waibʉcʉ soe ĩsi rotiba. Ito mʉ yija ticõri, “Ĩ ya cami yati jedicoajʉ ĩja”, yi masirã yirãji masa mʉre, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ito bajiro, “Goti batobeja”, ĩ yibojarocati cojisiti oca tĩjacoayijʉ cami jogagʉre Jesús ĩ yisiore gaye. Ito bajija tʉocõri, jãjarã Jesús tʉjʉ minijuayijarã, ĩ bʉsija tʉo ãmorã. Ito yicõri ĩna cõrisere yisio roti ãmorã ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Masa jãjarã ĩna ñajare coji meje masa manojʉ ĩ Jacʉ Diore bʉsirocʉ wayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Co rʉmʉ Jesús ĩ riasoroca fariseo gaye tʉoĩarã ito yicõri judio masa rotirise riasori masa cʉni tʉo rujiyijarã ĩna. Ado bajiro wame cʉtiri cʉtori wadiana ñayijarã ĩna. Galilea sita gãna, Judea sita gãna ito yicõri Jerusalén wame cʉtiri cʉto gãna wadiana ñayijarã ĩna. Masa tiro riojo cõrãre Jesús ĩ yisiotoni ĩ masirise jidicãyijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ito bajiro ĩ yi ñaroca jʉariarã ʉ̃mʉa rudurʉre ãmi ejayijarã ĩna, ĩ ya camana. Ito ejacõri Jesús tʉjʉ sãja wacõri ĩre cũ ãmobojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ito bajibojarocati masa jãjarã ĩna ñajare no bajiro sãja masia mañijʉ ĩnare. Ito bajija ticõri, wi tutu joejʉ rudurʉre ãmi mʉja wayijarã ĩna. Ãmi mʉja ejacõri Jesús rʉ̃gõro weca soje cudayijarã ĩna. Ito yicõri rudurʉre ĩ ya camana jidi rujioyijarã ĩna Jesús tʉ. ");
INSERT INTO myy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ito bajiro ĩna yija ticõri, ado bajiro tʉoĩayijʉ Jesús: “Yʉre tʉorʉ̃nʉsacõama ĩna”, yi tʉoĩayijʉ Jesús. Ito bajiro tʉoĩacõri: —Mʉ ñeñaro yirisere ãcabojocõa yʉ, yiyijʉ Jesús rudurʉre. ");
INSERT INTO myy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ito bajiro ĩ yija tʉocõri, fariseo gaye tʉoĩarã ito yicõri judio masa rotirise riasori masa cʉni ado bajiro tʉoĩayijarã ĩna: “Ãni ito bajiro ĩ bʉsija, Diore ñeñaro yigʉ yami ĩ. Dios meje ñami ĩ. Dios sĩgʉ̃ti ñami masa ĩna ñeñaro yirisere ãcaboja masigʉ̃”, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ito bajiro ĩna tʉoĩarisere ĩmasiti tʉoĩa masicõyijʉ Jesús. Ito bajiri ado bajiro yiyijʉ ĩ ĩnare: —¿No yija ito bajiro tʉoĩati mʉa? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mʉa tija, ¿No bajiro rudurʉre yʉ yija quenati? Ito yicõri, ¿disejʉa ñati josasabiti mʉa tija? “Mʉ ñeñaro yirisere coecoajʉ”, ¿yʉ yija quena ñarojada? “Wʉmʉña, wasa”, ¿yʉ yija quena ñarojada, mʉa tʉoĩaja? ¿Disejʉa ñati josasabiti, mʉa tija? ");
INSERT INTO myy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Masa Rĩjorʉ, Dios ĩ cõarʉ ña yʉ. Ito bajiri, “Masa ĩna ñeñaro yirise coe masiami Jesús”, mʉa yi masitoni mʉa tiro riojo ãnire yisiogʉ ya yʉ, yiyijʉ ĩ ĩnare. Ito yicõri rudurʉjʉare ado bajiro yiyijʉ: —Wʉmʉña, ya yʉ mʉre. Mʉ ya cama ãmiña, ito yicõri mʉ ya wijʉ tʉdi wasa, yiyijʉ Jesús rudurʉre. ");
INSERT INTO myy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ito bajiro ĩ yirocati masa jãjarã ĩna tiro riojo wʉmʉyijʉ rudurʉ. Ito yi, ĩ ya cama ãmi, budi wayijʉ ĩ. Ito yicõri Diore rʉ̃cʉbʉo bʉsi wayijʉ ĩ, ĩ ya wijʉ tʉdi wacʉ. ");
INSERT INTO myy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ito ĩ yija ticõri, ti ʉcayijarã masa. Ito bajiri Diore rʉ̃cʉbʉo bʉsiyijarã ĩna. Güire rãca ado bajiro yiyijarã ĩna: —Adi rʉmʉ tiyamani tia mani, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ito bajiro masare ĩ yi ĩo ñaja bero budiyijʉ Jesús mʉcana. Ito bajiro budi wacõri ʉjarãre yiari waja seni ĩsiri masʉre tiyijʉ Jesús. Ĩ ñayijʉ Leví wame cʉtigʉ. Waja ĩ seni ñarijʉ rujiyijʉ ĩ. Ĩre ti bʉjacõri: —Yʉ rãca waya, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ito ĩ yija tʉocõri, ĩ moabojarisere jidicãyijʉ Leví, Jesús rãca wa ãmogʉ̃. ");
INSERT INTO myy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ito bero ĩ rãca wa, Leví ya wi ejayijarã ĩna. Itojʉ ejacõri Jesure basa jeo bʉarocʉ basa meniyijʉ Leví. Ito bajiro ĩna basa meni ñaroca jãjarã ʉjarãre yiari waja seni ĩsiri masa ñayijarã ĩna. Ito yicõri gãjerã cʉni, jãjarã ĩna rãca ba rujiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ito bajiro ĩna ba rujija ticõri, judio masa rotirise riasori masa ito yicõri fariseo gaye tʉoĩarã cʉni, Jesús rãca riasotirãre ado bajiro busituyijarã: —¿No yija ʉjarãre yiari waja seni ĩsiri masa rãca, ito yicõri ñeñaro yi jairã rãca baba cʉti bati mʉa? yi bʉsituyijarã ĩna Jesús rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ito bajiro ĩna yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Ado bajirojʉa bajia. Queno cati quenarã, cõmena ʉco yiri masʉre jimenaji. Ito yicõri bʉto cõrãjʉa ʉco yiri masʉre jirãji. ");
INSERT INTO myy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Queno yirãre yiari meje wadibʉ yʉ. Ñeñaro yi jairãjʉare yiari wadibʉ yʉ. Ito yicõri quenarise ĩna tʉoĩa wasoatoni wadibʉ yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ito ĩ yija ado bajiro seniĩayijarã ĩna Jesure: —Juan rãca riasotirã coji meje bamena riti Diore rʉ̃cʉbʉorã ĩre senisotiama ĩna. Ito bajiroti bajiama fariseo gaye tʉoĩarã rãca riasotirã cʉni. Mʉ rãca riasotirãma ĩnare bajiro yibeama ĩna. Bʉcʉrã rotire queno cʉdibeama ĩna. Ito yicõri, “Diore bʉsiana”, yirona bare jidicãbeama ĩna, yi tudiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ĩna ito yija tʉocõri, ĩnare ado bajiro cʉdiyijʉ Jesús: —Sĩgʉ̃, ĩ ãmo siari rʉmʉ ĩ baba mesa ĩ rãca ĩna wanʉ baroca, “Babesa”, yi masimenaji gãjerã. ");
INSERT INTO myy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ito bajibojarocati co rʉmʉ gãjerã ĩre ñiagoja ticõri, bojori bʉjarã yirãji ĩ baba mesa. Ito bajiri ĩre tʉoĩarã bamenaji ĩna, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ito yicõri gaje ado bajiro goti masiore ocana ĩnare gotiyijʉ Jesús: —Sĩgõ saya bʉcʉro sere wõroco mamarore tabecõji. Ito bajiro mamaro tagoja mamaro cʉni ñeñacoaroja. Ito yicõri bʉcʉrore mamaro iso sere wõbojaja bʉcʉro bajiro corocõ ejabetoja. ");
INSERT INTO myy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ʉyé ide mani menija mama bajujʉ jiosãrã yirãji mani. Bʉcʉ baju mani jiosãjama, ñigãcoaro yiroja. Ito yicõri iti baju cʉni goda, ʉyé ide cʉni goda bajiro yiroja. ");
INSERT INTO myy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ito bajiri ʉyé ide menicõri mama bajuri jiosãrã yirãji mani. Ito yicõri iti baju cʉni, ʉyé ide cʉni godabetoja. ");
INSERT INTO myy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mani ʉyé ide bʉcʉ idiĩacõri mame idi ãmomenaji mani. “Bʉcʉjʉa queno sʉti quena”, yicõri mamere idi ãmomenaji mani. Ito bajiroti bajia mame oca yʉ riasoja cʉni. Bʉcʉrã oca tʉorʉ̃nʉrã ñacõri mame oca yʉ riasoja tʉo ãmobea mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Co rʉmʉ tujacãra rʉmʉ ñaroca, ĩ rãca riasotirã rãca trigo wesejʉ eja wayijʉ Jesús. Itojʉ ejacõri itire beja ãmiyijarã ĩ rãca riasotirã. Ito yicõri wirorire sĩguẽ bategocõri bayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ito bajiro ĩna baja tiyijarã fariseo gaye tʉoĩarã coriarã. Ito bajiro ĩna baja ticõri, ĩnare seniĩayijarã fariseo gaye tʉoĩarã: —¿No yija tujacãra rʉmʉ ñabojarocati moati mʉa? Tujacãra rʉmʉ moare ma, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ĩna ito yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Co rʉmʉ David ñayorʉ ĩ baba mesa rãca ñiojogacõri ĩna yigore, ¿Dios oca tutijʉ tibiticati mʉa? ");
INSERT INTO myy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ado bajiro yiyijʉ David ñayorʉ. Dios ya wijʉ sãjacõri, Diore paia naju ĩna cũ ĩsirere ãmicõri bayijʉ David. Ito yicõri ĩ baba mesare cʉni ecayijʉ ĩ. Paia riti ĩna baroti ñabojayijʉ iti naju. Ito bajibojarocati bʉto ñiojogacõri bayijʉ David ĩ baba mesa rãca. Itire ĩna baja tibojagʉti, “Ñeñaro yama ĩna”, yibisijʉ Dios ĩnare, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Gaje ado bajiro gotiyijʉ Jesús ĩnare: —Masa Rĩjorʉ, Dios ĩ cũrʉ ña yʉ. Ito bajiri tujacãra rʉmʉ gaye yʉ rotiroti cʉni cũquĩ Dios yʉre, yiyijʉ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gaje tujacãra rʉmʉ ñaroca judio masa ĩna minijuari wijʉ sãjayijʉ Jesús. Ito yicõri ĩnare riasoyijʉ ĩ. Ito bajiro ĩ riaso ñaroca sĩgʉ̃ ĩ ya ãmo riojocadʉja digarʉ ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ito yicõri fariseo gaye tʉoĩarã, judio masa rotirise riasori masa cʉni ti rujiyijarã ĩna. Jesure ticõri ado bajiro tʉoĩa rujiyijarã ĩna: “Jane tujacãra rʉmʉ ñabojarocati, ¿ãni ãmo digarʉre yisiogʉ yiguĩjida Jesús?” yi ti rujiyijarã ĩna. “Ito bajiro ĩ yija, ‘Seti ña ĩre. Ñeñaro yami’, yirã yirãji mani”, yi tʉoĩa rujiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ito bajiro ĩnamasi ĩna tʉoĩabojarocati tʉoĩa masicõyijʉ Jesús, ĩ masirisena. Ito yicõri ãmo digarʉre ado bajiro yiyijʉ Jesús: —Wʉmʉña, waya ado yʉ tʉjʉ, yiyijʉ Jesús ãmo digarʉre. Ĩ ito yija ãmo digarʉ Jesús tʉjʉ wacõri eja rʉ̃gʉ̃yijʉ. ");
INSERT INTO myy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ito bajiro ĩ eja rʉ̃gʉ̃roca ado bajiro yiyijʉ Jesús, ito ñarãre: —Mʉare seniĩagʉ̃ ya yʉ. ¿No bajiro manire cũyijari Dios tujacãra rʉmʉ mani yiroti? ¿Quenarise, ñeñarise ito yicõri cõrãre mani yisioroti, gaje mani yisiobeja, disejʉa quenati? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ito bajiro bʉsi tĩogʉ̃ iti wi ñarãre ti jeocõyijʉ Jesús. Ito yicõri ãmo digarʉre ado bajiro yiyijʉ ĩ: —Mʉ ya ãmo ñu joya, yiyijʉ Jesús ĩre. Ito bajiro Jesús ĩ yirocati, ĩ ya ãmo ñu joyijʉ ĩ. Ito bajiro ĩ yirocati ĩ ya ãmo quenacoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ito bajiro ĩ yija ticõri, fariseo gaye tʉoĩarã ito yicõri judio masa rotirise riasori masa cʉni bʉto ti junisiniyijarã ĩna Jesure. Ito yicõri ĩnamasiti gãmeri seniĩayijarã: “¿No bajiro yirʉjati mani Jesure?” yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Iti rʉmʉriti tʉria joejʉ maja wayijʉ Jesús, Diore bʉsirocʉ. Itojʉ ñacõri ñamiasaro Diore bʉsisotiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ito yicõri ũmacañi joejea mʉja wadiroca ĩ rãca riasotirãre jiyijʉ Jesús. Ito yicõri ĩna ejaroca jʉa gʉbojeno ñarã ʉ̃mʉare beseyijʉ ĩ. Ito yicõri ĩ oca ĩna goti ucutoni ĩnare cũyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ado bajiro wame cʉtirã ñayijarã ĩna: Sĩgʉ̃ ñayijʉ jʉa wame, wame cʉtigʉ, Simón Pedro. Ĩ ocabaji ñayijʉ Andrés wame cʉtigʉ. Ito yicõri gãjerã ñayijarã Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO myy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeo macʉ Santiago gãji ñayijʉ Simón celote gaye tʉoĩagorʉ. ");
INSERT INTO myy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ito yicõri Santiago macʉ ñayijʉ Judas wame cʉtigʉ. Gãji Judas Iscariote wame cʉtigʉ ñayijʉ. Ĩ ñayijʉ Jesure gãjerã ĩna ñiatoni gotirocʉ. Ito bajiro wame cʉtirã ñayijarã ĩna, Jesús ĩ oca ĩna goti ucutoni ĩ cũana. ");
INSERT INTO myy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ito bajiro ĩnare bese tĩocõri ĩna rãca roja wayijʉ Jesús. Roja wa, tʉria jʉdojʉ tujayijarã ĩna. Itojʉ jãjarã ñayijarã Judea sita gãna, Jerusalén gãna, ito yicõri itajura tʉ ñari cʉtori Tiro, Sidón wame cʉtiri cʉtori gãna cʉni ñayijarã. Iti cʉtori gãna ejayijarã Jesure tʉo ãmorã. Ito yicõri jãjarã cõrã yisio roti ãmorã ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Rʉ̃mʉ́a sãja ecoanare cʉni rʉ̃mʉ́are budi rotiyijʉ Jesús, ito bajiro ĩna ejaja ticõri. ");
INSERT INTO myy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Cõrãre cʉni ĩ masirisena rẽtoyijʉ Jesús. Ito bajiro masare ĩ rẽtoja ticõri, masa jeyaro ĩre moaĩa ãmoyijarã, ĩna cõrise rẽtatoni. ");
INSERT INTO myy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ito ĩna yi ñaroca, ĩ rãca riasotirãre bʉsi ãmogʉ̃ ĩnare tiyijʉ Jesús: —Adocãta bojoro bʉjarã ña mʉa maji. Bojoro bʉjarã ñabojarãti, ija Dios ĩ rotirojʉ ejacõri, ĩ rʉcorise bʉjarã yirãji mʉa. Ito yicõri wanʉ quenarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Adocãta ñiojogarã ña mʉa maji. Ñiojogarã ñabojarãti ija queno yaji quenaro wanʉ ñarã yirãji mʉa. ’Adocãta bojori bʉja, oti ñarã ya mʉa. Ito bajibojarocati ija queno wanʉcõri aja quenarã ñarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Yʉ Masa Rĩjorʉre, mʉa queno cʉdija ticõri, gãjerã mʉare ti tudirã yirãji ĩna. Ito yicõri mʉare cõa ãmorã yirãji ĩna. “Ñeñaro yirã ñama”, yirã yirãji mʉare bʉsiturã. Ito bajiro mʉare ĩna bʉsitubojarocati, ija wanʉ quenarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jane mejejʉ cʉni ĩna ñicʉsabatiajʉ cʉni ito bajiroti Diore goti ĩsiri masare ñeñaro yiyijarã ĩna. Ito bajiro mʉare ĩna ñeñaro yibojarocati queno wanʉ quenaña mʉa. Ija ũmacʉ̃jʉ ejacõri Dios tʉjʉ quenarise bʉjarã yirãji mʉa. Ĩre tʉorʉ̃nʉ jidicãbitiana mʉa ñajare, ito bajiro yigʉ yiguĩji Dios mʉare. ");
INSERT INTO myy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Mʉa gajeoni jairã, ado mʉa ñajama queno wanʉ quena ñaboja mʉa. Diore tʉorʉ̃nʉmena ñari ija bojoro bʉjarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Mʉa queno yaji quenarã, ñaja wanʉ quenare rãca ñaboja mʉa. Diore tʉorʉ̃nʉmena ñari ija ñiojogarã yirãji mʉa. ’Mʉa ajare jairã, adocãta mʉa ajaja queno wanʉ quenaboja mʉa. Diore tʉorʉ̃nʉmena ñari ija bʉto tʉoĩa bojori bʉjacõri, otirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Adocãta “Queno yirã ña mʉa”, yi masa mʉare ĩna rʉ̃cʉbʉoja tʉocõri, queno wanʉ quenaboja mʉa. Ito bajiroti jane mejejʉ cʉni rʉore oca riasori masare queno rʉ̃cʉbʉo bʉsibojayijarã ĩna. Diore tʉorʉ̃nʉmena ñari ija bʉto tʉoĩa bojori bʉjarã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ito yicõri mʉcana ĩnare bʉsi remoyijʉ Jesús: —Mʉa yʉre tʉorʉ̃nʉrãreama, ado bajiro gotia yʉ: Mʉa wajanare queno ti maiña. Ito yicõri mʉare ti tudirãre queno yiya. ");
INSERT INTO myy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mʉare bʉsiturãre cʉni, quenaro bʉsiya mʉa. Ito yicõri mʉare ñeñaro yirãre yiari Diore seni ĩsisotiya. ");
INSERT INTO myy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sĩgʉ̃ riojocadʉja wayugajʉ ĩ jaja, mʉcana gaje dʉja ĩ ja ãmoja rẽobeja. Ito yicõri gãji camisa jʉaro mʉa sãñaroca, joegadore ĩ ruaja, ito roca gadore ĩ rua ãmoja, cʉni rẽobeja. Ĩ seniro rẽto bʉsaro ĩsija quena. ");
INSERT INTO myy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ito yicõri no mʉa rʉcorise ĩna senija, ĩna seniro bajiroti ĩsima. Ito yicõri sĩgʉ̃ mʉa rʉcorise ĩ ẽmaja, “Itire jʉdacõaña”, yi josabeja. ");
INSERT INTO myy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gãjerã mʉare queno yire mʉa ãmoja, ito bajiroti ĩnare queno yiba mʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Manire mairãre riti mani maija, mani rãca queno wanʉbiquĩji Dios. Ñeñaro yirã cʉni ito bajiroti ĩnare mairãre mairãji. Manire maimena ñabojarocati maniama ĩnare maija quena. ");
INSERT INTO myy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Manire queno yirãre riti mani queno yija, mani rãca queno wanʉbiquĩji Dios. Ñeñaro yirã cʉni ito bajiroti ĩnare queno yirãre queno yirã yirãji. Manire queno yimena ñabojarocati maniama ĩnare queno yija quena. ");
INSERT INTO myy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Gãjire wasoagʉ, “Ija mʉcana jai bʉsaro bʉjagʉ yigʉja yʉ”, mani yi tʉoĩaja, mani rãca queno wanʉbiquĩji Dios. Ñeñaro yirã cʉni ito bajiro tʉoĩacõri wasoarã yirãji. Manire wasoamena ñabojarocati maniama ĩnare wasoaja quena. ");
INSERT INTO myy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ito bajibojarocati mʉama, mʉa wajanare mairʉja. Ito yicõri ĩnare queno yiya. Ito yicõri gãjire wasoagʉ, “Ija jai bʉsaro bʉjagʉ yigʉja yʉ”, yi tʉoĩabicʉti wasoaja quena. Ito bajiro mʉa queno yija, Dios tʉjʉ mʉa ejaroca mʉare queno waja yigʉ yiguĩji. Ito bajiro mʉa queno yirã ñaja, Dios rĩa ña mʉa. Dios cʉni masa jeyarore queno yigʉ ñami. “Queno ya mʉ”, yimenare cʉni, ñeñaro yi jairãre cʉni queno yigʉ ñami Dios. ");
INSERT INTO myy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mani Jacʉ masare ĩ ti mairo bajiroti mʉa cʉni masare ti maija quena, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Gaje ado bajiro gotiyijʉ Jesús ĩnare: —Gãjerãre, “Ĩna ñama ñeñarise yi jairã”, mʉa yibeja mʉare cʉni, “Ĩna ñama ñeñarise yi jairã”, yibiquĩji Dios mʉare. Ito yicõri gãjerãre, “Ĩnare seti ña. Ito bajiri ĩnare ruyuriogʉ yiguĩji Dios”, mʉa yibeja mʉare cʉni, “Ĩnare seti ña. Ĩnare ruyuriocʉja yʉ”, yibiquĩji Dios mʉare. Gãjerã ñeñaro yirise mʉa ãcabojoja, mʉa ñeñaro yirisere cʉni ãcabojogʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gãjerãre mʉa ĩsija, mʉare cʉni queno ĩsigʉ̃ yiguĩji Dios. Gãjerãre mʉa ĩsiro bajiroti, mʉare cʉni ĩsigʉ̃ yiguĩji Dios. Ito yicõri gãjerãre mʉa ĩsiro bajiroti rẽto bʉsaro mʉa boca ãmi masirocõ ĩsigʉ̃ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ito yicõri ado bajiro goti masiore ocana gotiyijʉ Jesús: —¿Sĩgʉ̃ cajea macʉre ito yicõri gãji cajea macʉ mʉcana, cajea macʉre tʉ̃a wa masiguĩjida? Meje, ito bajirojʉa meje bajia. Cajea tibicʉ ñari ĩre tʉ̃a wabojagʉ rãcati gojejʉ quedi sãjacõarãji ĩna. Dios oca riojo ñasarisere mani tʉo sʉyabeja cajea mana robo bajiro bajirãji mani, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","’Ĩnare riasori masʉ rẽto bʉsaro masirã meje ñama ĩ riasorã. Ito bajibojarocati ĩna queno riasoti jeocõja, ĩnare riasori masʉ bajiroti masirãji ĩna cʉni, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Iti oca goti tĩocõri mʉcana ado bajiro gaje oca gotiyijʉ Jesús: —Mʉa babare cajeajʉ sũjuriacã iti ñaja, ti bʉja masia mʉa. Ito bajibojarocati mʉa ya cajeajʉ sita jaje iti sãña biaja ti bʉja masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ado bajiro mʉa babare yiboja mʉa: “Yʉ baba mʉ ya cajeajʉ sita aje ña. Yʉ iti ajere ãmicãcʉja yʉ”, yibojarãti mʉa ya cajeajʉ sita jaje iti sãñajama, ãmicã masibea mʉa. “Queno yirã ña gʉama”, yirã ñabojarãti, ñeñaro yirã ña mʉa cʉni. Mʉa ya cajeajʉ sãñarisere ãmicãña. Itire ãmicãcõri queno ti masirã yirãji mʉa. Ito yicõri mʉa babare cajeajʉ sita ajere ãmicã masirã yirãji mʉa, yiyijʉ Jesús. ’Iti yireoni ña, mani baba ĩ ñeñaro yija ti masibojarãti, manimasiti ñeñaro yirisereama ti masibea mani, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ito yicõri mʉcana ĩnare goti masiore ocana gotiyijʉ Jesús: —Yucʉgʉ queno wanʉricʉ, ñeñarise rica cʉtibetoja. Ito yicõri yucʉgʉ ñeñaricʉ, quenarise rica cʉtibetoja. ");
INSERT INTO myy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Iti yucʉ ricare ticõri, “Itigʉ rica ña adi”, yi ti masia mani. Jotagʉjʉ higos rica mani ãmaja bʉjamenaji mani. Ito yicõri yusigʉre ʉyé mani ãmabojaja, bʉjamenaji mani. ");
INSERT INTO myy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ito bajiro queno ʉsi cʉtigʉ, gãjerãre cʉni queno yiguĩji ĩ. Ito yicõri ñeñaro ʉsi cʉtigʉ, gãjerãre cʉni ñeñaro yigʉ yiguĩji ĩ. Mani ya ʉsijʉ mani tʉoĩaro bajiroti bʉsibua mani, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Gaje ado bajiro yiyijʉ Jesús ĩ rãca riasotirãre: —“Gʉa Ʉjʉ ña mʉ”, yibojarãti, yʉ rotirisere cʉdibea mʉa. ");
INSERT INTO myy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","No yʉ tʉjʉ ejarã yʉ rotirisere ĩna cʉdija, sĩgʉ̃ queno bʉtirojʉ wi menigʉ̃ bajiro bajirã ñama ĩna. Tite. Sĩgʉ̃ bʉtirojʉ jubejʉ ĩ botari juja, jue iti bʉto sẽoro ejaja jujabetoja iti wi. Ito bajiro bajirã ñama yʉre queno cʉdirã. Gãjerã ĩnare ñeñaro yi josabojarocati yʉre tʉorʉ̃nʉ jidicãmenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ito bajibojarocati, no yʉ rotirise queno cʉdimena, ĩnare bajiro bajibeama ĩna. Sĩgʉ̃ sita jidirojʉ wi menigʉ̃ bajiro bajirã ñama ĩnama. Tite. Sĩgʉ̃ sita jidirojʉ ĩ botari juja, jue iti bʉto sẽoro ejaja iti wi jujacoaro yiroja. Ito bajiri tʉdi ruyubetoja ĩ ya wi ĩja. Ito bajiro bajirã ñama yʉre queno cʉdimena. Gãjerã ĩnare ñeñaro yija ticõri, yʉre jidicãrã yirãji, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Masare ĩ riaso ãmorise riaso tĩocõri Capernaumjʉ wayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iti cʉto ñayijʉ surara ʉjʉ. Ĩre moa ĩsiri masʉ bʉto cõyijʉ. Ito bajiri ʉsi jedi warʉti ñayijʉ ĩ. Ito ĩ bajija ticõri, bʉto ĩre ti maiyijʉ surara ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ito bajiri Jesús cõrãre ĩ yisiore gaye tʉocõri, judio masa bʉcʉrãre, Jesure ji rotiyijʉ ĩ. Ĩ ya moari masʉre Jesús ĩ yisiore ãmoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ito ĩ yija tʉocõri, Jesure jirã wayijarã ĩna. Jesús tʉjʉ ejacõri ado bajiro ĩre seniĩa josayijarã: —“Ĩre jitẽña”, gʉare yi ñucagʉ̃, queno yigʉ ñami ĩ. Ito bajiri ĩre ejabʉarʉja mʉ. ");
INSERT INTO myy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Romano masʉ ñabojagʉti mani ñarãre queno rʉ̃cʉbʉoami ĩ. Ito yicõri minijuara wi gʉa meni masitoni gʉare niyeru ĩsiquĩ ĩ. Ito bajiri ĩre ejabʉarʉja mʉ, yi josayijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ĩna ito yija tʉocõri, ĩna rãca sʉya wayijʉ Jesús. Ito wi ejarã wana ĩna yiroca surara ʉjʉ ĩ baba mesare Jesure oca goti boca rotiyijʉ. “Ado bajiro Jesure gotiba”, yi roticõayijʉ ĩ: —Yʉ Ʉjʉ mʉre ʉsirioro yi remo ãmobea yʉ. Rẽtoro quenagʉ̃ ña mʉ. Yʉjʉa quenagʉ̃ meje ña. Ito bajiri, yʉ ñeñaro yirisere bojogʉ, “Yʉ ya wijʉ sãja waya, yi masibea yʉ mʉre”, yi gotiba ĩre, yi roticõayijʉ surara ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Gaje ado bajiro yi roticõayijʉ ĩ: —Ñeñaro yigʉ ñari, mʉ tʉjʉ wa masibea yʉ. Mʉ masirisena mʉ yisio ñucaja, yʉ ya moari masʉ caticoagʉ yiguĩji mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gãji ʉjʉ bero gagʉ ña yʉ. Ito yicõri yʉ berojʉa ñama gãjerã surara. Ĩnare roti masia yʉ. Ito bajiri sĩgʉ̃re, “Wasa”, yʉ yija, wami. Ito yicõri gãjire, “Waya”, yʉ yija, wadiami. Ito yicõri yʉre moa ĩsiri masʉre yʉ moa rotija, moami. Ito bajiri rẽtoro queno roti masigʉ̃ mʉ ñajare, “Mʉ yisio ñucaja, yʉ ya moari masʉ tujacoagʉ yiguĩji mʉcana”, yi tʉoĩa yʉ, yi gotiba Jesure, yi roticõayijʉ surara ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ito ĩ yi ñucare tʉocõri, tʉo ʉcayijʉ Jesús. Ito yicõri jʉda rʉ̃gʉ̃cõri ĩre sʉyarãre ado bajiro yiyijʉ Jesús: —Ĩ surara ʉjʉ yʉre queno tʉorʉ̃nʉñi. Mani masa wato ĩre bajiro tʉorʉ̃nʉrã mama, yi gotiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ito ĩ yija tʉocõri, tʉdi wasʉoyijarã oca goti bocari masa. Tʉdi ejacõri ĩna tija ñarise cõbojarʉ tujarʉ ñayijʉ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ito bajiro ĩ yija bero Naín wame cʉtiri cʉtojʉ wayijʉ Jesús, ĩ rãca riasotirã rãca. Ito yicõri masa jãjarã wayijarã ĩ rãca. ");
INSERT INTO myy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iti cʉtojʉ ĩna ejaroca sĩgʉ̃ godarʉre ĩna yujerã waja tiyijʉ Jesús. Wajeago macʉ ñayijʉ ĩ, ĩna yujerocʉ. Ito yicõri ĩ sĩgʉ̃ti ñabojayijʉ iso macʉ. Jãjarã iti cʉto gãna ĩre yujerona wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wajeago iso bojori bʉjaja ticõri, bʉto ti maiyijʉ Jesús isore. Ito bajiro ti maicõri ado bajiro yiyijʉ Jesús isore: —Otibesa, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ito bajiro ĩ yija bero ĩ ya masari cumajʉ moaĩayijʉ Jesús. Ito bajiro ĩ yija ticõri, ĩre yujerã wabojarã tuja rʉ̃gʉ̃coayijarã ĩna ĩja. Ito bajiro ĩna tuja rʉ̃gʉ̃roca godarʉre ado bajiro yiyijʉ Jesús: —Wʉmʉña mamʉ mʉ, yiyijʉ Jesús godarʉre. ");
INSERT INTO myy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ito bajiro ĩ yirocati, jãja rũjũyijʉ godarʉ ñabojagʉti. Ito bajiro bajirʉ ñabojagʉti bʉsiyijʉ mʉcana. Ito ĩ bajija ticõri, ado bajiro yiyijʉ Jesús ĩ jacore: “Ĩmo, ãni ñami mʉ macʉ”, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ito bajiro ĩ yi masoja ticõri, ti güiyijarã ĩna, ito ñarã. Ito yicõri ado bajiro Diore rʉ̃cʉbʉo bʉsiyijarã ĩna: —Sĩgʉ̃ Diore goti ĩsiri masʉ mani tʉjʉ ejami ĩja, yiyijarã ĩna. Gaje ado bajiro bʉsiyijarã ĩna: —Dios ñarã mani ñajare manire ejabʉarocʉ ejami adojʉ, yi wanʉrã rʉ̃cʉbʉoyijarã ĩna Diore. ");
INSERT INTO myy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ito yicõri Jesús godarʉre ĩ masore gaye tʉo jedicoayijarã Judea sita gãna. Ito yicõri iti sita tʉ gãna cʉni tʉo jedicoayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan rãca riasotiri masa, Jesús ĩ yigore ticõri goti jeocõyijarã ĩna Juanre. Ĩna ito yija tʉocõri, jʉ̃arãre jiyijʉ Juan. ");
INSERT INTO myy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ito bajiri ĩna jʉ̃arãre, “Ado bajiro Jesure seniĩama mʉa”, yi ñucayijʉ Juan ĩnare: “¿Riti Dios ĩ cõarʉ, Cristo ñati mʉ? Ĩ meje mʉ ñajama, ¿gãjire bocatirã yirãjida gʉa maji? yiba”, yi roti ñucayijʉ Juan ĩna jʉ̃arãre. ");
INSERT INTO myy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ito ĩ yija tʉocõri, wayijarã ĩna. Jesús tʉjʉ ejacõri ado bajiro ĩre yi gotiyijarã ĩna: —Juan, masare idé guri masʉ, gʉare seniĩa roti ñucami mʉre. ¿Riti, Dios ĩ cõarʉ, Cristo ñati mʉ? Ĩ meje mʉ ñajama, ¿gãjire bocatirã yirãjida gʉa maji? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ito bajiro ĩna seniĩa ñaroca, jãjarã masa cõrãre yisioyijʉ Jesús. Ito yicõri ĩna ya ʉsijʉ rʉ̃mʉ́a sãja ecoana, cajea mana, ito yicõri gãjerã jeyaro ñarise cõrãre cʉni masoyijʉ Jesús. Ito bajiro ĩ yija Juan oca ĩ seniĩa roti ñucana cʉni tiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ito yicõri ado bajiro Juan ĩ cõanare gotiyijʉ Jesús: —Wasa. Mʉa tirise ito yicõri mʉa tʉogorise cʉni Juanre gotiba. Cajea mana ĩna tiroca yʉ yirise, ruduana ĩna waroca yʉ yirise, wiro joganare yʉ yisiorise gaye, gãmo goje tʉomena ĩna tʉoroca yʉ yirise, godana ñabojarocati ĩna catiroca yʉ yirise, ito yicõri bojoro bʉjarãre Dios ĩ masoroti oca yʉ goti masiorisere cʉni, gotiba Juanre. ");
INSERT INTO myy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ito yicõri, no yʉre tʉorʉ̃nʉsotigʉti, queno wanʉgʉ̃ yiguĩji ĩ, yiyijʉ Jesús, Juan ĩ oca seniĩa roti ñucanare. ");
INSERT INTO myy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ito ĩ yija tʉocõri, tʉdi wayijarã ĩna. Ito bajiro ĩna tʉdi waja bero, Juan ĩ bajigore gaye masare gotiyijʉ Jesús: —¿Yucʉ manojʉ warã, ñimʉre tʉoĩa wacati mʉa? ¿Sĩgʉ̃ ʉ̃mʉgʉ̃ mino iti waja, ʉe rʉ̃gõgʉ̃re tʉoĩa wacatite mʉa? yi seniĩayijʉ Jesús masare. Yucʉgʉ cogʉ mino wẽaja wãrericʉ bajiro meje ñami Juan. Queno tʉoĩagʉ̃ ñami ĩ. ");
INSERT INTO myy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ĩre mʉa ti bʉjaja yutabuju quenarise sãñagʉ̃ ñacati ĩ? Yutabuju quenarise sãñarã bajiro bajigʉ meje ñami ĩ. Yutabuju quenarise sãñarã ʉjarã ya wijʉ ñarãona ñarãji ĩna. Ĩna robo bajigʉ meje ñaguĩji Juan. ");
INSERT INTO myy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yucʉ manojʉ warã, ¿Diore goti ĩsiri masʉre tirã wasotiri mʉa? Itojʉ ejacõri, “Diore goti ĩsiri masʉ ñami”, yi masiyija mʉa. Riti ña, gãjerã Diore goti ĩsiri masa rẽtoro ñasagʉ ñami Juan. ");
INSERT INTO myy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jane mejejʉ Juanre ado bajiro yi goti yucãyijʉ Dios oca: Mʉ waroto riojʉa sĩgʉ̃ masʉ cõa yʉ. Masa mʉre bocati ñaroca, yirocʉre cõa yʉ, yi gotia Dios oca tuti, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Sĩgʉ̃ adi tutijʉ, Juan masare idé guri masʉ rẽtoro ñasagʉ mami. Ito bajibojarocati Dios ĩ rotirojʉ ñarã Juan ĩ ñasado bajiro rẽto bʉsaro ñasarã yirãji ĩna, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juan Dios oca ĩ gotija tʉogoana, “Riti, Dios rotirise quenarise ña. Itire cʉdi ãmoa gʉa”, yicõri, Juanre idé gu rotiyijarã ĩna. Ito yicõri ʉjarãre yiari waja seni ĩsiri masa cʉni, ito bajiroti yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ito bajibojarocati fariseo gaye tʉoĩarãma ito yicõri judio masa rotirise riasori masama, Dios rotirisere te ñayijarã. Ito bajiri Juanre idé gu rotibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Gaje ado bajiro gotiyijʉ Jesús: —Adi rʉmʉri gãna Juanre teama, ito yicõri yʉre cʉni teama ĩna. Rĩaca minijuacõri ĩna awasã aje cũñaro bajiro bajirã ñama ĩnaõna. Tite. Ado bajiro awasã ajeama rĩaca: “Gʉa seru juti ajeroca, mʉama juti ãmobijʉ. Ito yicõri masa godaroca ĩna otirise gʉa oti queso aje ãmoja, mʉama gʉa rãca oti queso aje ãmobijʉ”, yi awasã ajeama rĩaca. Ito bajiro bajiama Juanre terã ito yicõri yʉre terã cʉni. Tite. ");
INSERT INTO myy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Babicʉti Diore rʉ̃cʉbʉogʉ seniquĩ Juan. Ito yicõri ʉyé ide idibitiquĩ ĩ. Ito bajiro ĩ yija ticõri, “Rʉ̃mʉ́ sãja ecorʉ ñami”, yicʉ mʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ĩ bero yʉ, Masa Rĩjorʉ, ejacʉ. Ba, idi yigʉ ña yʉama. Yʉ ito bajiro yija ticõri, ado bajiro ya mʉa yʉre: “Jairo bagʉ ña mʉ. Idire cʉgʉ ña mʉ. Ñeñaro yi jairã rãca baba cʉtigʉ ña mʉ. Ito yicõri ʉjarãre yiari waja seni ĩsiri masa rãca baba cʉtigʉ ña mʉ”, ya mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sĩgʉ̃ Dios robo bajiro queno tʉoĩare cʉtigʉ ĩ ñaja, jeyaro ĩ yirisere ticõri, “Ĩ ñami Dios robo bajiro tʉoĩare cʉtigʉ”, yi tʉoĩa mani. Ito bajiri yʉ yirise ticõri, “Dios robo bajiro tʉoĩare cʉtigʉ ñami”, yi masi ñarã yirãji mʉa yʉre, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ito ĩ yija bero sĩgʉ̃ fariseo gaye tʉoĩagʉ̃ Jesure jiyijʉ ĩ ya wijʉ, bagʉ watoni. Ito ĩ yija tʉocõri, ĩ ya wijʉ wayijʉ Jesús. Iti wijʉ sãjacõri bara mesa tʉjʉ eja rũjũyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ito bajiro ĩ bagʉ waja tʉocõri, iti cʉto gago sĩgõ wedi maso ĩ tʉjʉ wayijo iso. Itojʉ waco queno sʉtirise ʉ́ye, coga dajaro ãmi wayijo iso. Itiga ñayijʉ gʉ̃ta alabastro wame cʉtirisena ĩna meniraga. ");
INSERT INTO myy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ito Jesús tʉjʉ sãja ejacõri ĩ ya gʉbo tʉjʉ eja rũjũyijo iso. Ito yicõri iso ya yago idena Jesús ya gʉbore coesʉoyijo iso. Ĩ ya gʉbore coe tĩocõri iso ya joanati Jesús ya gʉbore weja caroyijo iso. Ito yicõri ĩre wanʉgõ ĩ ya gʉbore usuyijo iso. Gajanoa ito bero ʉ́ye queno sʉtirise ĩ ya gʉbojʉ tuyijo iso. ");
INSERT INTO myy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iso ito yija ticõri, Jesure jigorʉ fariseo gaye tʉoĩagʉ̃ ado bajiro tʉoĩayijʉ: “Riti Diore goti ĩsiri masʉ ĩ ñajama, adio ĩ ya gʉbo coegore ti masiborʉ. Ito yicõri, ‘Wedi maso ñamo’, yi masiborʉ ĩ”, yi tʉoĩayijʉ fariseo gaye tʉoĩagʉ̃ Jesure jirʉ. ");
INSERT INTO myy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Fariseo gaye tʉoĩagʉ̃ ĩ tʉoĩarisere tʉo masicõri, ado bajiro yiyijʉ Jesús ĩre: —Simón, mʉre jabeto goti ãmoa yʉ, yiyijʉ Jesús ĩre. —Baʉ, gotiya yʉre riasogʉ mʉ, yiyijʉ Simón Jesure. ");
INSERT INTO myy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ito ĩ yija tʉocõri, ado bajiro goti masiore ocana gotiyijʉ Jesús ĩre: —Jʉ̃arã ʉ̃mʉa ñayijarã, niyeru wasoari masʉre waja ruyuriorã. Sĩgʉ̃ quinientos niyeru cujiri waja ruyurioyijʉ. Ito yicõri gãji cincuenta niyeru cujiri waja ruyurioyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ito bajibojarocati ĩna waja ruyuriogʉre waja yi masibisijarã ĩna. Ito bajiro ĩna waja ruyuriobojarocati ĩnare niyeru wasoagorʉ tʉdi seni ʉyabisijʉ ĩja, yi gotiyijʉ Jesús Simónre. Gaje ado bajiro Simónre seniĩayijʉ Jesús: —¿Nijʉa bʉto bʉsa ĩnare niyeru wasoagorʉre mairãjida ĩna? yi seniĩayijʉ Jesús Simónre. ");
INSERT INTO myy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ito bajiro ĩ seniĩaja, tʉocõri: —Yʉ tija, jai bʉsaro waja ruyuriogʉjʉa ĩre bʉto maiguĩji, yiyijʉ Simón. Ito ĩ yija tʉocõri: —Riti ya mʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ito yicõri ĩre gʉbo coegojʉare ticõri, bʉsiyijʉ Jesús Simónre: —Adiore tiya. Mʉ ya wijʉ yʉ sãjaroca yʉre ide ĩsibijʉ mʉ, yʉ ya gʉbo coeroti. Ito bajibojarocati adiojʉama iso ya yago idenati yʉ ya gʉbore coemo iso. Ito yicõri iso ya joanati yʉre weja caromo iso. ");
INSERT INTO myy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yʉre wanʉgʉ̃, yʉre usubijʉ mʉ. Ito bajibojarocati adioama, yʉre wanʉgõ queno gʉbojʉ usumo iso. ");
INSERT INTO myy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ito yicõri yʉ ya rijogajʉ ʉ́ye tubijʉ mʉ. Ito bajibojarocati adioama ʉ́ye queno sʉtirise yʉ ya gʉbojʉ tumo iso. ");
INSERT INTO myy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ito bajiri ado bajiro mʉre gotia Simón yʉ: Ñeñaro yi jaigo ñabojarocati, yʉre bʉto iso maija ticõri, iso ñeñaro yirisere ãcabojoa yʉ. Sĩgʉ̃ jabetacã bʉsa ñeñaro yigʉre, ĩre yʉ ãcabojaja, jabetacã bʉsa yʉre maigʉ̃ yiguĩji ĩ. Ito yicõri bʉto ñeñaro yigʉre yʉ ĩ ñeñaro yirisere ãcabojaja bʉto bʉsa yʉre ti maigʉ̃ yiguĩji ĩ. Iti tʉo masiña, yiyijʉ Jesús Simónre. ");
INSERT INTO myy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ito yicõri romiore ado bajiro yiyijʉ Jesús: —Mʉ ñeñaro yirisere ãcabojacõa yʉ, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ito ĩ yija tʉocõri, gãjerã iti wijʉ ĩna rãca bari masa, ĩnamasiti gãmeri seniĩayijarã ĩna: —¿Ñimʉ ñati ãni, masa ĩna ñeñaro yirisere ãcabojagʉ? yi gãmeri seniĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ito bajiro ĩna yiroca, romiore ado bajiro gotiyijʉ Jesús: —Yʉre queno tʉorʉ̃nʉa mʉ. Ito bajiri mʉre masorocʉ mʉ ñeñaro yirisere ãcabojocõa yʉ. Ʉsirioro yibecoti wasa mʉ, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ito yija bero gaje cʉtorijʉ Dios oca goti ucugʉ wayijʉ Jesús. “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire gaye goti ucugʉ wayijʉ ĩ. Ito yicõri ĩ rãca riasotirã, jʉa gʉbojeno ñarã rãca wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Romia cʉni ĩna rãca wayijarã. Ĩna ñayijarã ĩna ya ʉsijʉ rʉ̃mʉ́a sãja ecoanare Jesús ĩ bucõagoana. Ito yicõri ñarise cõana ĩ masogoana cʉni wayijarã ĩna rãca. Sĩgõ María Magdalena wame cʉtigo ĩna rãca wayijo. Iso ñayijo jʉa ãmojeno rʉ̃mʉ́a ñarãre Jesús ĩ bucõagoro. ");
INSERT INTO myy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ito yicõri gajeo Juana wame cʉtigo ñayijo. Iso ñayijo Cuza manojo. Herodes ya moari masa ʉjʉ ñayijʉ Cuza. Ito yicõri gajeo Susana wame cʉtigo ñayijo. Ito yicõri gãjerã cʉni jãjarã Jesús rãca romia wayijarã ĩna. Ĩna ejabʉa masiro bajiro ejabʉayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ito bajiro Jesús ĩ wa ucuroca co cʉto gãna meje ĩ tʉ minijuayijarã, ĩre ti ãmorã. Ito bajiro ĩna ejaja ticõri, goti masiore ocana gotiyijʉ Jesús ĩnare: ");
INSERT INTO myy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Sĩgʉ̃ weseca ĩ ya ote ajeri otegʉ wayijʉ ĩ. Wesecajʉ ejacõri, iti ajerire ĩ wẽjabateroca gaje ajeri majʉ quedi queayijʉ. Ito bajiro quedi quearisere gãjerã itire cʉdabia rojocõyijarã. Ito yicõri minia cʉni bayijarã, iti ajerire. ");
INSERT INTO myy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gaje ajeri gʉ̃ta watojʉ quedi queayijʉ. Iti gʉ̃ta wato quedi queara ajeri nocõ mejeti judibojayijʉ. Ito bajibojarocati yoari mejeti siniacoayijʉ sita iti ide manijare. ");
INSERT INTO myy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gaje ajeri jota watojʉ quedi sãja wayijʉ. Ito quedi sãjacõri, iti judi mʉja waroca jota mari dʉrea sĩacõyijʉ itire. ");
INSERT INTO myy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ito yicõri gaje ajeri sita quenarise joejʉ quedi queayijʉ. Ito bajiri iti ajeri judi bʉcʉacõri quenarise rica cʉtiyijʉ. Ito yicõri coria sarari cien ñari ajeri rica cʉtiyijʉ, yiyijʉ Jesús ĩnare. Ito bajiro iti goti tĩocõri mʉcana ado bajiro yiyijʉ Jesús ĩnare: —No gãmo goje cʉtirã tʉoya, yiyijʉ Jesús oca sẽoro ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ito ĩ yija tʉocõri, ado bajiro ĩre seniĩayijarã ĩ rãca riasotiri masa: —¿Ñe yireoni ñati iti goti masiore oca? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ĩna ito yija: —“No ĩre tʉorʉ̃nʉrã ĩ rotirojʉ miojugʉ yiguĩji Dios”, yi gãjerã ĩna tʉo masibiti gaye mʉa tʉo masiroca yami Dios mʉareama. Gãjerãma iti oca tʉobojarãti queno tʉo masimenaji ĩna. Ito bajiroti yi gotiyijarã Diore goti ĩsiri masa. Tite mʉa. “Tʉobojarãti, tʉo masimenaji ĩna. Ito yicõri tibojarãti, ti masimenaji ĩna”, yi goticãyijarã jane mejejʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ito yicõri mʉcana tʉdi riasoyijʉ Jesús ĩnare: —“Oteri masʉ sĩgʉ̃ ado bajiro bajiyijʉ”, yirocʉ mʉare gotibʉ yʉ. Ito bajiri adocãta mʉare goti rẽtobugʉ ya yʉ, mʉa queno tʉo masitoni. Oteri masʉ, Dios oca goti ucuri masʉ robo bajigʉ ñami ĩ. Ito yicõri ĩ oteri ajerioniti ña Dios oca mani tʉorise. Tite mʉa. Ado bajirojʉa bajia iti oca. ");
INSERT INTO myy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Coriarã masa Dios ocare tʉorãji tʉorea. Ito bajibojarocati ĩna ãcabojaroca yigʉ yiguĩji rʉ̃mʉ́. Ito bajiri Diore tʉorʉ̃nʉmenaji ĩna. Ito bajiri ĩre ĩna tʉorʉ̃nʉbejare ĩnare masobiquĩji Dios. Dios ocare ĩna ãcabojaja, majʉ ote ajeri quedi queado bajiro bajirã yirãji ĩnaõna. ");
INSERT INTO myy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Gãjerãma Dios ocare tʉocõri queno wanʉ quenare rãca boca ãmirãji ĩna. Ito bajibojarocati ĩnare oca ñaja, ito yicõri gãjerã ĩnare ti teja, Diore tʉorʉ̃nʉmenaji ĩna. Ito yicõri nocõ mejeti ĩ oca ĩna tʉobojarere jidicãrã yirãji ĩna. Ito bajiro ĩna yija, gʉ̃ta wato quedi queara ajeri bajiro queno ñe mari mana robo bajirã yirãji ĩnaõna. ");
INSERT INTO myy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Gãjerãma Dios ocare tʉobojarãti adi macãrʉcʉ̃ro gayere bʉto tʉoĩarã yirãji ĩna. Ito bajiro tʉoĩacõri adi macãrʉcʉ̃ro ñeñarise gajeonire cʉni jidicã ãmomenaji ĩna. Ito bajiro ĩna jidicã ãmobeja jota mari wato ote ajeri quedi queado bajiro bajirã yirãji ĩnaõna. Ĩna ñama Diore queno moa ĩsimena. ");
INSERT INTO myy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Gãjerãma Dios oca tʉocõri, ĩre queno tʉorʉ̃nʉrã yirãji ĩna. Ito bajiro ĩre queno tʉorʉ̃nʉrã ñari ĩre jidicãmenaji ĩna. Ito yicõri ĩ ãmoro bajiro yirã yirãji ĩna. Ito bajiro ĩna yija sita quenarise joejʉ ote ajeri quedi queado bajiro bajirã yirãji ĩnaõna. Ĩna ñama Diore queno moa ĩsirã, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mʉcana tʉdi goti masiore ocana gotiyijʉ Jesús: —Mujura jãi sĩacõri riri sotʉ rocajʉ mucũmenaji mani. Ito yicõri gaje mujura jãi sĩacõri canira casabo rocajʉare sĩa cũmenaji mani. Ado bajirojʉa yirãji mani. Mujura jãi sĩasuara tutujʉ sĩasuarã yirãji mani. Ito bajiro mani sĩasuaja, masa sãja wadirã ti masirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ado bajirojʉa bajia iti yireoni. Masa ĩna tʉo masibitire ija tʉo masicoarã yirãji ĩna. Ito yicõri yeyoro masa ĩna tʉoĩabojarisere masa jeyaro masicõrã yirãji ĩna, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Queno tʉoya mʉa, yʉ gotirisere. Sĩgʉ̃ Diore queno tʉorʉ̃nʉgʉ̃re bʉto bʉsa Dios oca ĩ tʉo masiroca yigʉ yiguĩji Dios. Ito bajibojarocati gãjiama Diore queno tʉorʉ̃nʉbicʉ ĩ ñajare Dios oca ĩ masibojarisere ĩ ãcabojaroca yigʉ yiguĩji Dios, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ito ĩ yija bero ĩ jaco, ĩ ocabajirã ĩre ti ãmorã ejabojayijarã ĩna. Jãjarã masa ĩna ñajare ĩ tʉjʉ eja masia mañijʉ ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ito bajiro ĩna bajija ticõri, sĩgʉ̃ ado bajiro Jesure gotiyijʉ: —Mʉ jaco, mʉ ocabajirã mʉre tirã wadiana macʉ̃jʉ ñama, yi gotiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ito ĩ yija tʉocõri, ado bajiro ĩre cʉdiyijʉ Jesús: —No Dios oca tʉorãti, ito yicõri itire cʉdirãti, ĩna ñama yʉ jaco robo, yʉ ocabajirã robo bajiro bajirã, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Co rʉmʉ Jesús ĩ rãca riasotirã rãca cumajʉ sãjayijʉ. Ito yicõri ado bajiro yiyijʉ: —Ita, sidʉjajʉ wea jẽa wato, yiyijʉ Jesús ĩ rãca riasotirãre. Ito ĩ yija tʉocõri, gaje dʉjajʉ jẽa wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ito bajiro jẽa wacʉjʉ, canicoayijʉ Jesús. Ĩ canigoja bero bʉto mino wẽayijʉ. Ito yicõri itira itajura bʉto jacũyijʉ. Iti jacũrise cumajʉ jairo ruja sãjayijʉ. Ito bajiri jabeto rʉyabojayijʉ cuma iti rujaroto. ");
INSERT INTO myy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ito bajija ticõri, bʉto güiyijarã ĩ rãca riasotiri masa. Ito bajiri Jesure yujioyijarã ĩna. Ado bajiro yi yujioyijarã ĩna Jesure: —Jesús, gʉare riasogʉ, yujiya mʉ. Canibesa. Rujarã ya mani, yiyijarã ĩna Jesure. Ĩna ito yija tʉocõri, yujiyijʉ Jesús. Ito yicõri jacũrisere ado bajiro yiyijʉ Jesús: “Itocõti jacũña. Mino cʉni itocõti wẽaña”, ĩ yirocati, rẽtacoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mino iti rẽtaja bero ado bajiro ĩnare seniĩayijʉ ĩ ĩja: —¿Ñe rẽtati, yʉre tʉorʉ̃nʉbeati mʉa? yiyijʉ Jesús ĩnare. Ito bajiro iti rẽtaja, mano ti ʉcayijarã ĩna, ĩ rãca riasotiri masa. Ito yicõri ĩnamasiti ado bajiro gãmeri bʉsiyijarã ĩna: —¿Ñimʉõcʉ̃ ñati ãni? Ĩ bʉsirocati mino cʉni rẽtacoajʉ. Jacũrise cʉni tʉjacoajʉ, yi gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gaje dʉja Galilea wame cʉtiri dʉjajʉ ñana jẽa wa, Gerasa wame cʉtiri sitajʉ ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Cumana jẽa warʉ jẽa ejacõri maja wayijʉ Jesús. Ito bajiro waroca sĩgʉ̃ iti cʉto gagʉ rʉ̃mʉ́a sãja ecorʉ bocayijʉ Jesure. Ĩ ʉ̃mʉgʉ̃ yoari yutabuju sãñare mejeti ña ucuyijʉ ĩ. Ito yicõri wijʉ ña masibisijʉ ĩ. Ito bajiri gʉ̃ta gojerijʉ ñayijʉ ĩ ñaro. Iti gʉ̃ta gojeri ñayijʉ masa ĩna yujerise. Itojʉ ñasotiyijʉ rʉ̃mʉ́a sãja ecorʉ, ĩ ñaro. Ito ĩ ñaroca coji meje rʉ̃mʉ́a sãjayijarã ĩre. Ito yicõri gãjerã ito gãna coji meje ĩ ya ãmori ĩ ya gʉbori cʉni come mana ĩre siasotibojayijarã ĩna. Ito bajiro ĩna siabojarocati, bʉto tunu ruacõsotiyijʉ ĩ. Ito yicõri ĩ ya ʉsijʉ ñarã rʉ̃mʉ́a yucʉ manojʉ wa rotiyijarã ĩre. Ito bajiro yucʉ manojʉ waca yigʉjʉ Jesure bocayijʉ ĩ. Ĩre bocacõri Jesús riojo ñini rũjũyijʉ rʉ̃mʉ́a sãja ecorʉ. Ito yicõri bʉto awasãyijʉ ĩ. Ito bajiro ĩ yija ticõri, ĩ ya ʉsijʉ ñarã rʉ̃mʉ́are budi rotiyijʉ Jesús. Ĩ budi rotija tʉocõri, ado bajiro Jesure seniĩayijarã ĩna rʉ̃mʉ́a: —¿Mʉ ũmacʉ̃jʉ gagʉ Dios Macʉ, gʉare no bajiro yigʉ yigʉjada mʉ? Bʉto ñeñaro gʉa tõbʉjaroca yibesa, yiyijarã rʉ̃mʉ́a Jesure. ");
INSERT INTO myy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ĩna ito bajiro josaja tʉocõri, ado bajiro seniĩayijʉ Jesús ĩnare: —¿Ñimʉ wame cʉtiati mʉ? yiyijʉ Jesús. Ito bajiro ĩ seniĩaja tʉocõri: —Legión wame cʉtigʉ ña yʉ, yiyijʉ rʉ̃mʉ́. Jãjarã yireoni ña Legión. Ito bajiri ito bajiro wame cʉtiyijʉ ĩ rʉ̃mʉ́. Jãjarã rʉ̃mʉ́a ñayijarã ĩ ʉ̃mʉgʉ̃re. ");
INSERT INTO myy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ĩna rʉ̃mʉ́a Jesure ado bajiro yi seniyijarã: —“Sõjʉ wasa”, yibesa gʉare, yiyijarã rʉ̃mʉ́a Jesure. ");
INSERT INTO myy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ito yiroca tʉria joejʉ jãjarã ecana yesea ba rʉ̃gõ ucuyijarã. Ito bajiro bajija ticõri, Jesure bʉto seni josayijarã ĩna: —Yeseare gʉa sãjatoni gʉare sãja rotiya mʉ, yiyijarã rʉ̃mʉ́a Jesure. Ĩna ito yija tʉocõri: —Baʉ, yeseare sãjaña mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ito ĩ yija tʉocõri, masʉ ya ʉsijʉ sãñabojana budi jedicoayijarã, yeseare sãjarona. Ito yicõri yesea rʉ̃mʉ́a sãja ecocõri bʉto sẽoro ũmaquedi wayijarã ĩna. Ito bajiro bʉto ũmaquedi jati wacõri, tʉria joejʉna bubu jati waca yirãjʉ, itajurajʉ quedi roa goda jedicoayijarã yesea. ");
INSERT INTO myy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Iti ito bajiro rẽtaja ticõri, yeseare coderi masa ũmaquedi wayijarã cʉtorijʉ goti ucurona. Iti ito bajiro rẽtagorere jaibiti cʉto cʉni, jaja cʉto cʉni goti ucuyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ito bajiro ĩna gotija tʉocõri, “Ita mani cʉni. Tito”, yiyijarã gãjerã. Ito yicõri Jesús tʉjʉ ejacõri rʉ̃mʉ́a sãja ecogorʉre ti bʉjayijarã ĩna. Queno ʉsi cʉtigʉ rujiyijʉ ĩ ĩja, Jesús tʉjʉ. Ito yicõri yutabuju sãñarʉ ñayijʉ ĩ ĩja. Ito bajiro ĩ bajija ticõri, ti ʉcacoayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ĩ ito bajija ticõri: —Rʉ̃mʉ́a sãja ecorʉ ñabojarʉ rʉ̃mʉ́are budi rotiñi Jesús, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Itire tʉocõri Gerasa gãna, ito yicõri ito tʉ gãna cʉni bʉto güicõri Jesure wa rotiyijarã ĩna. Ĩna ito yija tʉocõri, cumajʉ sãjayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ito bajiro cumajʉ ĩ sãjaroca rʉ̃mʉ́a ĩ bucõagorʉ, ado bajiro seni josayijʉ Jesure: —Yʉ cʉni mʉ rãca wa ãmoa yʉ, yi seniyijʉ ĩ. Ito bajiro ĩ yija tʉocõri: ");
INSERT INTO myy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mʉ ya wijʉ tʉdi wasa. Ito yicõri ado bajiro yi gotiba, “Jesús yʉ ya ʉsijʉ rʉ̃mʉ́a sãñabojanare bucõacõquĩ”, yi gotiba mʉ, yiyijʉ Jesús rʉ̃mʉ́a ĩ bucõagorʉre. Ito ĩ yija tʉocõri, cʉtorijʉ wayijʉ rʉ̃mʉ́a budigorʉ. Ito yicõri jeyaro ĩre rẽtagorere goti ucuyijʉ, Jesús ĩ rotiado bajiroti. ");
INSERT INTO myy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ito bajiro ĩ yi ucuja bero, tʉdi jẽa wayijʉ Jesús mʉcana. Ito bajiro ĩ jẽa ejaroca wanʉ quenare rãca ĩre boca ãmiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ito bajiro ĩ jẽa ejaroca, ĩna masa jãjarã wato sĩgʉ̃ judio masa ĩna minijuari wi ʉjʉ Jairo wame cʉtigʉ wadiyijʉ. Wadicõri Jesús riojo rijomunigãna ñini rũjũyijʉ Ĩ. Ĩ maco jʉa gʉbojeno rodori tʉjago ñayijo iso. Sĩgõti ñayijo ĩ maco, ito yicõri bʉto cõyijo iso. Goda waroti ñayijo iso. Ito bajija ticõri, Jesure ĩ ya wijʉ ĩ watoni ĩre jigʉ ejayijʉ Jairo. Ito bajiro ĩ senija tʉocõri, Jairo ya wijʉ wayijʉ Jesús. Ito Jairo ya wi ĩ waroca masa jãjarã ñayijarã. Ito bajiri masa jãjarã gãni bia wayijarã ĩre. ");
INSERT INTO myy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ito yicõri ĩna masa rãca sĩgõ romia ñarise cõgõ ñayijo. Jʉa gʉbojeno rodori cõ tʉjayijo iso. Ito yicõri isore ʉco yigoanare iso rʉcorise ñarocõti waja yi jeocõyijo iso. Ĩna ito bajiro ʉco yibojarocati rẽta masibisijʉ isore. ");
INSERT INTO myy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ito bajiro masa jãjarã wato Jesús ya yutabuju gaja moaĩayijo iso. Iso ito bajiro ĩ ya yutabujure moaĩarocati iso ñarise cʉtibojarise rẽtacoayijʉ isore ĩja. ");
INSERT INTO myy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ito bajiro ĩ ya yutabujure iso moaĩaja tʉo masicõri ado bajiro seniĩayijʉ Jesús: —¿Noa yʉ ya yutabujure moaĩari? yi seniĩayijʉ ĩ. Ito bajiro ĩ seniĩaja tʉocõri: “Moaĩabijʉ gʉa cʉni”, yiyijarã ĩna ñarocõti Jesure. Ito bajiro ĩnare ĩ seniĩaja bero, ado bajiro cʉdiyijʉ Pedro: —Gʉare riasogʉ, mʉ tʉjʉ masa jãjarã ñama. Jãjarã mʉre gãni bia wama. Ito yicõri jãjarã mʉ ya yutabujure cʉ̃oama. No yigʉ ito yiri mʉ, “¿Ñimo yʉ ya yutabujure moaĩari?” yibʉ mʉ, yiyijʉ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ito yija Jesús ado bajiro yiyijʉ ĩnare: —Sĩgõ yʉre moaĩamo. Ito bajiro iso moaĩaja, yʉ masirise rãca isore ñarise rẽtomʉ yʉ, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ĩre yutabuju moaĩare ĩ masija tʉocõri, bʉto güiyijo iso. Ito yicõri iso ya rujʉ nʉrʉogõti Jesús riojo iso ya rijomunigãna ñini rũjũyijo iso. Ito yicõri masa jãjarã ĩna tʉoroca Jesure iso moaĩagorere gotiyijo iso: “ ‘Ĩ ya yutabujure yʉ moaĩajama, yʉ cõrise rẽtacoaro yiroja’, yi tʉoĩacõri, mʉ ya yutabujure moaĩamʉ yʉ. Ito yicõri yʉ moaĩarocati yʉ rujʉ ñarise rẽtacoajʉ ĩja”, yi gotiyijo iso, masa ĩna tʉoro riojo. ");
INSERT INTO myy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iso ito yija tʉocõri: —Maco, tʉoya mʉ. Yʉre mʉ tʉorʉ̃nʉrise mʉre yisiocõa. Ito bajiri wanʉ quenagõ, cati quenagõ wasa mʉ, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ito bajiro isore ĩ goti ñaroca Jairo ya wi ñarã ejayijarã Jairore gotirã: —Mʉ maco godacoamo. Ito bajiri mʉcana tʉdi ʉsirioro yibesa ãni riasogʉre, yiyijarã ĩna Jairore. ");
INSERT INTO myy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ĩna ito yija tʉocõri, Jairore ado bajiro yiyijʉ Jesús: —Güibesa. Diore mʉ rʉ̃cʉbʉoja, mʉ maco mʉcana tujacoago yigõji iso, yiyijʉ Jesús ĩre. Ito yicõri Jairo ya wijʉ wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ĩ ya wijʉ ejacõri Pedro, Santiago ito yicõri Juanre cʉni sãja rotiyijʉ Jesús. Ito yicõri cõgõ jacʉsabatiare cʉni sãja rotiyijʉ ĩ. Gãjerãre sãja rotibisijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iti wi ñarã masa, macoacã iso godaja ticõri, bʉto otiyijarã ĩna. Ĩna ito bajiro otija ticõri, ado bajiro yiyijʉ Jesús ĩnare: —Otibesa, Adio macoacã cõgõ meje yamo iso. Canigõ yamo, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ito ĩ yija, ito oti ñarã bʉto ĩre aja tudiyijarã ĩna. “Godasacoamo iso”, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ito bajiro ĩna yibojarocati godaro iso ñari sãnimʉjʉ sãjacõri iso ya ãmore ñiayijʉ Jesús. Ito yicõri ado bajiro yiyijʉ Jesús isore: —Macoacã, wʉmʉ rʉ̃gʉ̃ña, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ito ĩ yirocati cojisiti tujacoayijo iso, godaro ñabojagoti. Ito yicõri godaro ñabojagoti wʉmʉ rʉ̃gʉ̃yijo iso. Ito iso bajija ticõri, “Bare ecaya isore”, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ito bajiro iso tujaja ticõri, ti ʉcacoayijarã iso jacʉsabatia. Ito bajibojarocati iso jacʉsabatiare oca goti bato rotibisijʉ Jesús, iso tujarise gayere. ");
INSERT INTO myy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Co rʉmʉ ĩ rãca riasotirã, jʉa gʉbojeno ñarãre miojuyijʉ Jesús. Ito bajiro ĩna minijuaja ticõri, ĩ masirise ĩsiyijʉ Jesús ĩnare, rʉ̃mʉ́a sãja ecoanare rʉ̃mʉ́are ĩna bucõa masitoni. Ito yicõri cõrãre cʉni ĩna maso masitoni, ĩ masirise ĩsiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ito yicõri, “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca goti ucu rotiyijʉ Jesús ĩnare. Ito yicõri, “Cõrãre cʉni yisiorã yirãji mʉa”, yi roti ñucayijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Gaje ado bajiro ĩnare gotiyijʉ Jesús: —Iti mʉa oca goti ucurã waja gajeoni ãmimenati waja. Ito yicõri mʉa ya turigʉ cʉni ãmi wabeja. Ito yicõri tura baju, naju, niyeru cʉni ãmi wabeja. Ito yicõri yutabuju mʉa sãñarise rãca riti waja. Wasoa sãñado ãmimenati waja, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ito yicõri cʉto mʉa ejaja mʉa sãja ejari witi ñacõama. Iti wi ñarãti mʉcana gaje cʉtojʉ warã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gaje cʉtojʉ mʉa ejaroca iti cʉto gãna mʉare ĩna boca ãmibeja riojoti rẽtacoaja. Ito yicõri iti cʉto rẽta warãti mʉa ya gʉbojʉ sita wãrisere ja bateba. Ito bajiro mʉa yija ticõri, “Ĩnare queno boca ãmibijʉ mani”, yi tʉoĩarã yirãji iti cʉto gãna, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ito bajiro ĩ yija tʉocõri, jeyaro cʉtorijʉ Dios oca goti ucurã wayijarã ĩna. Ito yicõri cõrãre cʉni maso ucurã wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ito bajiro ĩna yi ucuroca, Herodes Galilea sita ʉjʉ, jeyaro Jesús ĩ yigore tʉoyijʉ ĩ. Gãjerã Herodesre ado bajiro yi gotiyijarã ĩna: “Godarʉ ñabojagʉti mʉcana catiami Juan”, yiyijarã gãjerã ĩre. Ĩna ito yija tʉocõri, no bajiro yi tʉoĩa masibisijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gãjerãma, Herodesre ado bajiro yiyijarã ĩna: “Elías goaĩorʉ”, yiyijarã gãjerã. Ito yicõri gãjerãma, “Jane mejejʉ Diore goti ĩsiri masʉ godacõri mʉcana catirʉ”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ĩna ito bajiro gotirise tʉocõri, ado bajiro yiyijʉ Herodes: —Yʉmasiti Juanre ĩna rijoga jatatoni roti ñucacʉ yʉ. ¿Ñimʉõcʉ̃ ñati ito bajiro jaje oca ruyugʉ? yiyijʉ Herodes. Ito bajiro iti bʉto oca ruyuja tʉocõri, bʉto ti ãmoyijʉ Herodes Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús ĩ oca ĩna goti ucutoni ĩ cũana tʉdi ejarã ĩnare rẽtagore Jesure goti jeocõyijarã ĩna. Ito bajiro ĩna gotija bero ricati bʉsa Betsaida wame cʉtiri cʉto tʉjʉ ĩnare ãmi wayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ito bajibojarocati “Ito warãji ĩna”, yi masicõri ĩnare sʉya wayijarã masa jãjarã. Ito bajiro ĩna sʉya ejaja ticõri, wanʉre rãca ĩnare boca ãmiyijʉ Jesús. Ito yicõri, “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca gotiyijʉ Jesús ĩnare. Ito yicõri cõrãre cʉni masoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Rãiocũro ña wadiroca ĩ oca goti ucutoni ĩ cũana ĩ tʉjʉ minijuacõri ado bajiro yiyijarã ĩna ĩre: —Bʉto cʉto meje ña ado. Ito bajiri queno bare bʉja masiña ma ado. Ito bajiri masare cʉtojʉ wa rotiya, bare ĩna bʉja masitoni, ito yicõri ĩna cani masitoni, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ito ĩna bajiro yibojarocati: —Mʉati ĩnare bare ecaya, yiyijʉ Jesús. Ito ĩ yija tʉocõri, ado bajiro yiyijarã ĩna Jesure: —Najuro co dʉjamocõ, ito yicõri wai jʉ̃arãti ñama gʉare. ¿Ĩna ñarocõti masa ĩna barotire gʉa waja yirã ware ãmoati mʉ? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cinco milcõ ñayijarã ĩna ʉ̃mʉa. Romia ito yicõri rĩaca cʉni ñayijarã ĩna wato. Ito bajiro jãjarã ĩna ñaja ticõri, ĩ rãca riasotirãre ado bajiro yiyijʉ Jesús: —Rujariaburi ruji rotiya masare. Cobu rujirãre jʉ̃arã masacõ gãji ye jʉa dʉjamocõ ruji rotiya, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ito bajiro ĩ yija tʉocõri, ito bajiro masare ruji rotiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ito bajiro ĩna rujija ticõri, co dʉjamocõ naju ñarisere, wai jʉ̃arãre cʉni ãmi rʉcoyijʉ ĩ ya ãmona. Ito yicõri macãrʉcʉ̃rojʉ ti mʉocõri Diore, “Queno ya mʉ”, yiyijʉ Jesús. Ito yicõri iti najurore igata batoyijʉ, waire cʉni. Ito yicõri ĩ rãca riasotirãre ĩsiyijʉ, masare ĩna batotoni. ");
INSERT INTO myy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ito bajiro ĩna batoja boca ãmicõri masa ñarocõti jediyijarã ĩna. Ito yicõri yaji quenaro ñayijarã ĩna. Ito bero ĩna yaji rẽtagore jʉa gʉbojeno jibʉri miosã dajoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Co rʉmʉ Diore bʉsirocʉ gajejʉ bʉsa wayijʉ Jesús. Ito ĩ Jacʉre bʉsi ñaroca, ĩ rãca riasotirã ejayijarã ĩna. Ĩna ejaja ticõri, ado bajiro ĩnare seniĩayijʉ Jesús: —¿No bajiro yi bʉsiri masa yʉre? yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ito ĩ yija ado bajiro cʉdiyijarã ĩna: —Gãjerãma mʉre, “Masare idé guri masʉ, Juanti ñami”, yama ĩna mʉre. Gãjerãma, “Elías ñami”, yama ĩna mʉre. Ito yicõri gãjerãma, “Jane mejejʉ Diore goti ĩsiri masʉ godacõri mʉcana catirʉ ñami”, yama ĩna mʉre, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ĩna ito yija tʉocõri, ado bajiro seniĩayijʉ Jesús: —Mʉama, “Ñimʉ ñaguĩji”, ¿yi tʉoĩati yʉre? yiyijʉ Jesús. Ito ĩ yija ado bajiro cʉdiyijʉ Pedro: —Cristo Dios ĩ cõarʉ ña mʉ, ya yʉ mʉre, yiyijʉ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ito ĩ yija tʉocõri, gãjerãre goti bato yibesa, yiyijʉ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ito yicõri ĩnare ado bajiro yiyijʉ Jesús: —Yʉ Masa Rĩjorʉ ñeñaro tõbʉjagʉ yigʉja yʉ. Ito bajiri judio masa bʉcʉrã, paia ʉjarã, ito yicõri judio masa rotirise riasori masa cʉni yʉre ti tudirã yirãji ĩna. Ito bajiri yʉre sĩarã yirãji masa. Ito bajiro yʉre ĩna yibojarocati yʉ godaja bero, ʉdia rʉmʉ bero mʉcana tʉdi yʉ catiroca yigʉ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ito bero ĩna ñajedirore ado bajiro gotiyijʉ Jesús: —Sĩgʉ̃ yʉre ĩ sʉya ãmoja, ĩ ye ñaroti tʉoĩabiticõri yʉjʉare tʉo mai sʉyagʉ yiguĩji. Yucʉtẽo gajagʉ robo bajiro tõbʉjabojagʉti yʉre riti sʉyagʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","No ĩ catirise maibojagʉti godagʉ yiguĩji. Ito bajibojarocati yʉre tʉorʉ̃nʉgʉ̃, yʉ oca ĩ gotija tʉo junisinicõri ĩna sĩagʉ̃ama catitĩñare gaye bʉjagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sĩgʉ̃ adi macãrʉcʉ̃ro gaye gajeoni jeyaro ĩ bʉjabojarocati ĩ godari rʉmʉ, catitĩñare ĩ bʉjabeja, ito yicõri Dios ĩre ruyurioja ñejʉa waja mano yiroja ĩre. ");
INSERT INTO myy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yʉ Masa Rĩjorʉ ʉjʉ ñacõri tʉdi ejagʉ yigʉja yʉ mʉcana. Rẽtoro ñasarise yʉ Jacʉ yʉre ĩ ĩsijare ito yicõri ángel mesa ĩna ñasaro bajiro yʉre ĩ jidicãjare, co rʉmʉ ñasari masʉ ʉjʉ tʉdi ejagʉ yigʉja yʉ. No yʉre masigʉ̃ ñabojagʉti, yʉre ĩ bojoja ito yicõri yʉ oca masibojagʉti ĩ bojoja yʉ tʉdi ejari rʉmʉ ito bajiroti ĩre bojogʉ yigʉja yʉ cʉni. ");
INSERT INTO myy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Riti ya yʉ mʉare. Mʉa wato coriarã, ado ñarã ĩna godaroto riojʉa, “Ĩre tʉorʉ̃nʉrãre miojusʉogʉ yami Dios”, yi ti masirã yirãji ĩna, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ito bajiro ĩ yija bero, ʉdia ãmojeno rʉmʉri berocõ, gʉ̃tagʉ̃jʉ mʉja wayijʉ Jesús ĩ Jacʉ Diore bʉsirocʉ. Ito yicõri Pedro, Santiago, Juanre cʉni ãmi wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Gʉ̃tagʉ̃ joejʉ ejacõri Diore bʉsiyijʉ Jesús. Ito bajiro Diore ĩ bʉsiroca ĩ ya rio gajero bajiro godo wediyijʉ. Ito yicõri ĩ ya yutabuju cʉni bʉto boticõri yoro ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ito ĩ yi ñaroca, ʉ̃mʉa jʉ̃arã ĩ rãca bʉsirã goaĩoyijarã. Ĩna jʉ̃arã ñayijarã Elías, Moisés ñayoana. ");
INSERT INTO myy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ito bajicõri Dios ĩ yorise watojʉ ñayijarã ĩna. Ito bajiro Jesure bʉsirã, Jerusalénjʉ ñeñaro tõbʉjacõri ĩ godaroti gayere ĩre bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ito bajiro ĩna yiroca, Pedro mesa bʉto canibojarãti, ito bajijare yujiyijarã. Yujicõri Jesús ĩ yorise, ito yicõri ĩ rãca ñarã yorisere tiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ĩna jʉ̃arã Jesús rãca bʉsiana, ĩna ĩre wagoja ticõri, ado bajiro yiyijʉ Pedro: —Gʉare riasogʉ, iti rẽtaroca gʉa ti ñaja quena ña gʉare. Mʉare yiari ʉdia wi meni ĩsirʉja gʉa. Mʉre co wi, Moisésre gaje wi, ito yicõri Elíasre gaje wi, yiyijʉ Pedro Jesure. Ito bajiro bʉsibojagʉti, ĩ bʉsirisere tʉo masibisijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ito bajiro ĩ bʉsiroca, ide bueri ruji wadiyijʉ. Ide bueri ĩnare quedi jea biajare güiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ito yicõri ide bueri wato ado bajiro oca ruyuyijʉ ĩnare: —Ãni ñami yʉ Macʉ yʉ maigʉ̃. Ĩre queno tʉorʉ̃nʉña mʉa, yi ruyuyijʉ oca ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ito bajiro oca ĩna tʉoja bero Jesús sĩgʉ̃ti ĩ ñaja tiyijarã ĩna. Iti rẽtaja ticõri, ito bajia yibisijarã ĩna. Ito yicõri gãjerãre cʉni goti bato yibisijarã. ");
INSERT INTO myy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ito bajiri gaje rʉmʉ gʉ̃tagʉ̃ joejʉ ñana ruji wayijarã ĩna. Ĩna ruji ejaja ticõri, masa jãjarã Jesure bocatiyijarã. ");
INSERT INTO myy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Masa jãjarã wato sĩgʉ̃ oca seoro Jesure bʉsiyijʉ: —Yʉre riasogʉ mʉre josa yʉ, yʉ macʉre mʉ ti maitoni. Ĩ sĩgʉ̃ti ñami yʉ macʉ. ");
INSERT INTO myy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Biyaro rʉ̃mʉ́ ĩre sãjacõri, ĩ ʉsi jediroca yami. Ĩ awasãroca ito yicõri ĩ ya rise somo budiroca yami. Ito bajiro ñeñaro ĩre yicõri ĩre budigo ãmobeami rʉ̃mʉ́. ");
INSERT INTO myy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉ rãca riasotirãre rʉ̃mʉ́ bucõa rotibojacʉ yʉ. Ito yʉ yibojarocati, rʉ̃mʉ́re bucõa masibiticã ĩna, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ito ĩ yija tʉocõri, Jesús ado bajiro cʉdiyijʉ: —Ba, ya yʉa. Queno yʉre tʉorʉ̃nʉrã meje ña mʉa. Ito yicõri yʉre rʉ̃cʉbʉorã meje ña mʉa. Yoari mʉare yʉ riasobojarocati yʉre tʉorʉ̃nʉbea mʉa maji, yiyijʉ Jesús ĩnare. Ito yi tĩocõri rʉ̃mʉ́ sãja ecorʉ jacʉre: —Adojʉa mʉ macʉre ãmi wadite maji mʉ, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ito bajiro macʉacãre ĩ ãmi waroca mʉcana tʉdi rʉ̃mʉ́ quedi sãjayijʉ ĩre. Ito yicõri jacajʉ ĩ quedi quearoca yicõri ĩ ʉsi jediroca yiyijʉ rʉ̃mʉ́ ĩre. Ito bajiro ĩ yija ticõri, rʉ̃mʉ́re budi rotiyijʉ Jesús. Rʉ̃mʉ́re Jesús ĩ bucõaja bero queno cati quenayijʉ macʉacã mʉcana. Ito yicõri macʉacãre ĩ jacʉre jʉdacõayijʉ Jesús mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Dios ĩ masirisena ito bajiro Jesús ĩ yija ticõri, ito ñana ti ʉcayijarã masa. Ito bajiro ĩ yirise masa ĩna ti wanʉroca, ado bajiro yiyijʉ Jesús ĩ rãca riasotirãre: ");
INSERT INTO myy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ado yʉ gotirise queno tʉoya mʉa. Ito yicõri ãcabojabeja. Yʉ ña Masa Rĩjorʉ Dios ĩ cõarʉ. Yʉre ñiacõri gãjerãre ĩsirã yirãji ĩna, yʉre ĩna sĩatoni, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ito bajiro ĩ yibojarocati, ĩnare tʉo masi rotibisijʉ Dios maji. Ito bajiro ĩ yijare Jesús ĩ gotirisere tʉo masibisijarã ĩna. “Mʉ gotirisere mʉcana gʉare goti quenoña”, yi güi ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ito bajiro ĩna baji ñaroca: —¿Ñimʉjʉa ñagʉ̃ yiguĩjida ñasagʉ? yi gãmeri bʉsiyijarã ĩna Jesús rãca riasotiri masa. ");
INSERT INTO myy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ito bajiro ĩna gãmeri bʉsirisere, tʉo masicõyijʉ Jesús. Ito yicõri sĩgʉ̃ macʉacãre ĩ tʉ tʉ̃ami rʉ̃gõyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ito yicõri ĩ rãca riasotirãre ado bajiro yiyijʉ Jesús: —No yʉre rʉ̃cʉbʉocõri ãni macʉacãre boca ãmiro bajiro, yʉre cʉni boca ãmigʉ̃ ñami ĩocʉ̃. Ito yicõri yʉre boca ãmigʉ̃, yʉre cõarʉre boca ãmigʉ̃ ñami ĩ. No mʉa rãca gagʉ, “Gãjerã rẽto bʉsaro tʉoĩagʉ̃ ña yʉ”, yibicʉ ĩ ñagʉ̃ yiguĩji ñasagʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ito ĩ yija bero ado bajiro yiyijʉ Juan ĩre: —Gʉare riasogʉ, sĩgʉ̃ mʉ wamena rʉ̃mʉ́are bucõagʉ̃ ticʉ gʉa. Gʉa rãca gagʉ meje ĩ ñajare rẽocʉ gʉa ĩre, yiyijʉ Juan Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ito ĩ yija tʉocõri: —Rẽobeja mʉa. No manire tʉo tudibicʉ ĩ ñaguĩji mani baba, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ũmacʉ̃jʉ Jesús ĩ waroto iti cõñajare, “Yʉre ĩna sĩa ãmobojarocati Jerusalénjʉa wasagʉ yigʉja yʉ”, yi oca sẽoyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ito bajiro tʉoĩacõri ĩ riojʉa queno yuronare cõayijʉ Jesús. Samaria sita cʉtojʉ canirajʉri ãmarã wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jerusalénjʉ warã yama yi ti masicõri, boca ãmi ãmobisijarã Samaria sita gãna ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ito bajiro ĩna yija ticõri, Jesús rãca riasotirã Santiago, Juan ado bajiro yiyijarã Jesure: —¿Gʉa ĩnare ruyuriorona Diore jea queo rotire ãmoati mʉ? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ĩna ito yija tʉocõri, oca sẽoro ĩnare ticõri ado bajiro ĩnare tudiyijʉ Jesús: —Ito bajiro mʉa tʉoĩaja, rʉ̃mʉ́ bajiro tʉoĩarã ña mʉa. ");
INSERT INTO myy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yʉ ña Masa Rĩjorʉ. Masare ruyuriorocʉ meje wadicʉ yʉ. Ĩnare masorocʉ wadicʉ yʉ, yiyijʉ Jesús ĩnare. Ĩ ito yija bero gaje cʉtojʉ wayijarã ĩna mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ito ma ĩna waroca sĩgʉ̃ ʉ̃mʉgʉ̃ ado bajiro yiyijʉ Jesure: —Yʉ Ʉjʉ, no mʉ waroti mʉ rãca wa ãmoa yʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ito bajiro ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús ĩre: —Buyairo mesa totijʉ canicã ĩna. Ito yicõri minia ĩna ya jibʉrijʉ canicã ĩna. Ito bajibojarocati yʉ Masa Rĩjorʉ, dijʉ yʉ canirijʉ ma yʉre. Ito bajiri yʉre mʉ sʉyaja josari ñaroja mʉre, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ito yicõri gãjire ado bajiro yiyijʉ Jesús: —Yʉ rãca waya, yiyijʉ Jesús. Ito ĩ yijare: —Yʉ Ʉjʉ, yʉ jacʉ rãca ñagʉ̃ ya maji. Ĩ godaja bero mʉ rãca wacʉja yʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ito bajiro ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Yʉre masimena moajaro itirea. Mʉáma, “Ĩre tʉorʉ̃nʉrãre miojugʉ yiguĩji Dios”, yire oca goti ucuya mʉáma, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ito yija ado bajiro yiyijʉ gãji Jesure: —Yʉ Ʉjʉ, mʉ rãcati wa ãmoa yʉ. Cajero maji yʉ ya wi gãnare ware gotigʉ wacʉ ya yʉ maji, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Sĩgʉ̃ yʉ rãca wasʉogʉ, iti rʉmʉjʉ ĩ yigore mʉcana tʉdi ĩ tʉoĩaja, Dios masa jeyaro ʉjʉre queno moa ĩsi masibeami ĩocʉ̃, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ito ĩ yija bero setenta y dos ñarã beseyijʉ mʉcana. Ito yicõri ĩ waroti cʉtoricõti jʉ̃arã, jʉ̃arã, jʉ̃arã ĩ riojʉa wa yu rotiyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ĩnare wa yu rotigʉ ado bajiro yiyijʉ ĩ ĩnare: —Riti ya yʉ. Ote jaje iti bʉcʉabojarocati moari masajʉa jaibeama. Ito bajiri ote ʉjʉre ĩ ya moari masare ote ãmi rotija quena. Riti ya yʉ. Jãjarã ñama yʉ oca masimena. Ito bajibojarocati coriarã ñama yʉ oca ĩnare goti ucurona. Ito bajiri Diore seniña ĩ oca goti ucuronare ĩ cõatoni. ");
INSERT INTO myy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wasa mʉa. Guijorojʉ mʉare cõa yʉ. Ito bajiri queno tʉoĩaña. Oveja yaia tʉ ĩna ejarã waro bajiro mʉare cõa yʉ. ");
INSERT INTO myy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gajeoni sãra buju ãmi wabeja. Niyeru sãra buju cʉni ãmibesa. Ito yicõri gaje gʉboco mʉa wasoaroti ãmi wabeja. Ma masa mʉa bocaja yoari bʉsi rʉ̃gõ yibeja mʉa. ");
INSERT INTO myy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cʉto ejacõri co wi mʉa sãjaja, iti wi gãnare ado bajiro yiba: “Dios queno yijaro mʉare ito yicõri queno ñaña mʉa”, yiba mʉa. ");
INSERT INTO myy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ĩna mʉare queno ĩna cʉdija, quena ñaro yiroja ĩnare. Ito bajibojarocati queno mʉare ĩna cʉdibeja quenabeto yiroja ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ĩna cʉdija ticõri, iti wi tujacõri, ĩna ecaro bajiroti baba mʉa. Diore moa ĩsirã mʉa ñajare mʉa riasorãjʉa mʉare bare ecarã yirãji ĩna. Gaje wi, gaje wi, sãja ucu yibeja mʉa. ");
INSERT INTO myy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cʉto mʉa ejaja ĩna mʉare boca ãmija ĩna ecaro bajiroti baba. ");
INSERT INTO myy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ito gãna cõrã ĩna ñaja, ĩnare yisioba. Ito yicõri ado bajiro ĩnare gotiba: “Yoari mejeti ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios. Ito bajiri ĩre mani tʉorʉ̃nʉja quena”, yi gotiba. ");
INSERT INTO myy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gaje cʉto mʉare ĩna boca ãmibeja, majʉ wija rʉ̃gʉ̃cõri ado bajiro ĩnare gotiba: ");
INSERT INTO myy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mʉ ya cʉto gaye sita gʉa ya gʉboco wãrisere jacãcõa gʉa mʉa gʉare boca ãmibejare. Masiña mʉa. ‘Ĩre tʉorʉ̃nʉrãre miojugʉ yiguĩji Dios’, yire gaye mʉare gotirona ejaboja gʉa”, yiba ĩnare, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","’Gaje ado bajiro mʉare gotia yʉ. Iti cʉto gãna mʉare boca ãmimena, Sodoma cʉto gãna rẽto bʉsaro ñeñaro tõbʉjarã, yirãji ĩna, Dios ĩ waja seniri rʉmʉ, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gaje ado bajiro gotiyijʉ Jesús ĩnare: —Bʉjato bajia ĩnare. Bʉto ñeñaro tõbʉjarã yirãji Corazín gãna, ito yicõri Betsaida gãna cʉni. Ito bajiroti tõbʉjarã yirãji. Jaje tiyamani ĩnare ĩobojacʉ yʉ. Ito yʉ yibojarocati ĩna ñeñaro yirise jidicã ãmobiticã ĩna. Ĩnare yʉ ĩocato bajiroti Sidón, ito yicõri Tiro gãna yʉ ĩoja, ĩna ñeñaro yirise iti rʉmʉjʉ jidicãboana. Ito yicõri ĩna ñeñaro yirise tʉoĩa bojori bʉjarã, saya wanʉre gaye meje sãñaboana ĩna. Ito yicõri “Bʉto bojori bʉja gʉa”, yirona õja tuboana ĩna ya riojʉ. ");
INSERT INTO myy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dios ĩ waja seniri rʉmʉ Tiro, Sidón gãna rẽtoro ñeñaro tõbʉjarã yirãji Betsaida gãna, Corazín gãna cʉni. ");
INSERT INTO myy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ito yicõri, “Ũmacʉ̃jʉ Dios tʉjʉ ejarã yirãji mani”, yi tʉoĩabojarãji Capernaum gãna. Ito bajiro tʉoĩabojarãti jeame ʉ̃jʉrojʉ warã yirãji ĩna, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’No mʉare tʉogʉti, yʉre cʉni tʉogʉ ñami. No mʉare ãmobea yirã, yʉre cʉni ãmorã meje ñama ĩna. No yʉre ãmobea yigʉ, yʉre cõarʉre cʉni ãmogʉ̃ meje ñami ĩocʉ̃, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mʉcana ĩ tʉ tʉdi ejarã bʉto wanʉ tʉdi ejayijarã Jesús ĩ cũana setenta y dos ñarã. Ito yicõri Jesure ado bajiro yiyijarã ĩna: —Gʉa Ʉjʉ, rʉ̃mʉ́a sãja ecoana rʉ̃mʉ́are gʉa budi rotija, ñaro bajiroti gʉare cʉdicã ĩna, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ĩna ito yija tʉocõri, ado bajiro yiyijʉ Jesús ĩnare: —Rʉ̃mʉ́a ʉjʉ Satanás rẽtoro masigʉ̃ ña yʉ. Ũmacʉ̃jʉ bʉjo ĩ jarise robo bajiro Satanás ĩ quedi wadija ticʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Cotiwãja, ãñare cʉni cʉdabojarãti mʉa cuni ecobe yirocʉ, yʉ masirise mʉare jidicãcʉ yʉ. Ito yicõri mʉa wajacʉre rẽtocũma yirocʉ, cũcʉ yʉ mʉare. Yʉ masirise mʉare yʉ jidicãjare ñejʉa mʉare junibetoja. ");
INSERT INTO myy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Rʉ̃mʉ́re gʉa budi rotija ñaro bajiroti cʉdiquĩ gʉare”, yi masibojarãti bʉto wanʉ quenasaroti meje ña itiama. “Ũmacʉ̃jʉ yʉ warotojʉ yʉ wame wõre ñacãroja”, mʉa yi masija, iti ña bʉto wanʉ quenare gaye, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ito ĩ yirocati Jesús ĩ wanʉ quenaroca yiyijʉ Espíritu Santo. Ito bajiri ado bajiro yiyijʉ Jesús Diore: —Cʉna mʉre bʉto rʉ̃cʉbʉoa yʉ. Mʉ ña adi tuti gagʉ Ʉjʉ, macãrʉcʉ̃ro jeyaro Ʉjʉ. Ado gãna bʉto riasotiana, ito yicõri bʉto masirã, mʉ oca ĩna tʉo masibitire oca, ñasari masa mejejʉare mʉ oca ĩna tʉo masiroca yicʉ mʉ. Mʉ ãmoro bajiroti bajicʉ. Iti ya yʉ Cʉna mʉre, yiyijʉ Jesús Diore. ");
INSERT INTO myy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Jeyaro ʉjʉ yʉ ñatoni yʉre cũquĩ yʉ Jacʉ. Yʉ Jacʉ sĩgʉ̃ti queno yʉre masiguĩji. Ito yicõri yʉ sĩgʉ̃ti yʉ Jacʉre queno masia. Gãjerã cʉni yʉ Jacʉre masiroca, yʉ yi ãmoja, yʉ jacʉre masirã yirãji ĩna cʉni, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ito yicõri ĩ rãca riasotirãre riti ado bajiro yiyijʉ Jesús: —Yʉ ĩorise ticõri bʉto wanʉ quenare ña mʉare. ");
INSERT INTO myy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ado bajiro mʉare ya yʉ. Jane meje gãna Dios oca goti ĩsiri masa, ito yicõri ʉjarã masa cʉni adocãta mʉa tirise bʉto ti ãmobojayijarã ĩna. Ito bajibojarãti itire ti bʉjabisijarã ĩna. Ito yicõri adocãta mʉa tʉorise bʉto tʉo ãmobojayijarã. Ito bajibojarãti itire tʉobisijarã ĩna, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ito bajiro yi ñaroca sĩgʉ̃ judio masa rotirise riasori masʉ, wadiyijʉ Jesús rãca bʉsirocʉ: “Riti masiati Jesús”, yi tʉoĩacõri seniĩagʉ̃ ejayijʉ ĩ. Ado bajiro ĩre seniĩayijʉ: —¿Yʉ Ʉjʉ, catitĩñare gaye yʉ bʉja ãmoja no bajiro yigʉjada yʉ? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ito ĩ yija tʉocõri: —¿No bajiro wãñati ucare, Dios ĩ rotire gaye? Ito yicõri, ¿itire mʉ tija no bajiro tʉoĩati mʉ? yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ito bajiro ĩ yija tʉocõri, ado bajiro cʉdiyijʉ judio masa rotirise riasori masʉ: —“Mani Ʉjʉ Diore bʉto maija quena. Mani tʉoĩa oca sẽorisena, ito yicõri mani ya ʉsina cʉni bʉto Diore mani maija quena. Ito yicõri manimasi mani mairo bajiroti mani ñarãre cʉni mani maija quena”, yi gotia Dios oca, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ito ĩ yija tʉocõri: —Ñaro bajiroti cʉdia mʉ. Ito bajiroti ya Dios oca. Ito bajiro mʉ yija, catitĩñagʉ̃ yigʉja mʉ, yiyijʉ Jesús judio masa rotirise riasori masʉre. ");
INSERT INTO myy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","—“Yʉ ñarãre queno yigʉ meje ña yʉ”, yi tʉo masicõri, “¿Noajʉa ñati yʉ ñarã?” yi seniĩayijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ito bajiro ĩ yija tʉocõri, ado bajiro gotiyijʉ Jesús ĩre: —Sĩgʉ̃ Jerusalénjʉ ñagʉ̃ Jericójʉ roja wayijʉ. Ma ĩ waroca riniri masa ĩre ñiacõri jeyaro ĩ gajeoni cʉtirise ĩre ẽmayijarã. Ĩ ya yutabujuri cʉni ĩre ẽma jeocõyijarã ĩna. Ito yicõri ĩre bʉto janugã cũcõri, ĩre wagoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ito ĩ baji cũñaroca pai cʉni iti mati wayijʉ. Ĩre ti bʉjabojagʉti riojoti rẽtacoayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ĩ bero gãji Levita masʉ ejayijʉ ĩ tʉ. Ĩre ti bʉja wacʉti riojo rẽtacoayijʉ ĩ cʉni. ");
INSERT INTO myy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ito bajiro ĩre ĩna ti rẽtaja bero sĩgʉ̃ Samaria sita gagʉ iti ma wacʉjʉ ti bʉjayijʉ ĩre. Ito yicõri ĩre ti maiyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ito bajiri ĩ tʉ ejacõri ĩre cami ʉco yiyijʉ ĩ. Iti cami ʉco yigʉ ʉ́yena ito yicõri ʉyé idena ʉco yiyijʉ ĩre. Ito yicõri ĩ ya camire wõbiayijʉ. Ito bajiro ĩre yicõri ĩ ya burro joejʉ ĩre mʉojeoyijʉ. Ito yi tĩogʉ̃, canira wijʉ ĩre ãmi wacõri ñamiasaro ĩre tirʉ̃nʉyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Samaria sita gagʉ busuri wacʉ canira wi ʉjʉre jʉati niyeruti ĩsiyijʉ. Iti ĩsi wacʉ ado bajiro yiyijʉ ĩ ĩre: “Ãni cõgʉ̃re tirʉ̃nʉña. Jairo waja mʉre iti godaja, tʉdi ejagʉ mʉre wa yicʉja yʉ mʉcana”, yiyijʉ ĩ canira wi ʉjʉre, yi oca gotiyijʉ Jesús judio masa rotirise riasori masʉre. Iti oca goti tĩogʉ̃ ado bajiro ĩre seniĩayijʉ mʉcana Jesús: ");
INSERT INTO myy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“¿Ĩna ʉdiarã wato ñimʉjʉa ñarʉda riniri masa ĩna jasĩa cũrʉre, ti mairʉ?” Yi seniĩayijʉ Jesús judio masa rotirise riasori masʉre. ");
INSERT INTO myy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ito ĩ yija tʉocõri: —Samaria sita gagʉ ĩre ti mairʉ. Ĩ ñarʉ ĩ yagʉ, yiyijʉ ĩ Jesure. Ito bajiro ĩ yija ado bajiro yiyijʉ Jesús ĩre: —Wasa, ĩ yiado bajiroti yiba mʉ cʉni, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ito ma wacʉjʉ cʉto ejayijʉ Jesús. Iti cʉto ejacõri Marta wame cʉtigo, ya wi wayijʉ ĩ. Ĩ ejaja ticõri, queno boca ãmiyijo iso ĩre. ");
INSERT INTO myy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iso ocabajio María wame cʉtigo ñayijo. Iso Jesús ya gʉbo tʉ rujicõri, ĩ gotirisere tʉo rujiyijo. ");
INSERT INTO myy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martama iso moarise gaye tʉoĩagõ ʉsirioro tõbʉjayijo. Ito bajiri Jesús tʉ eja rʉ̃gʉ̃cõri, ado bajiro bʉsiyijo iso: —¿Yʉ Ʉjʉ, no yibeati mʉre yʉ ocabajio yʉre ejabʉabecoti mʉ tʉ iso rujija? “Mʉ rĩjorore ejabʉaya maji”, yiya isore, yiyijo Marta Jesure. ");
INSERT INTO myy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ito bajiro Marta iso yibojarocati ado bajiro cʉdiyijʉ Jesús isore: —Marta mʉ moare cʉtirise ʉsirioro bajia mʉre. Ito bajiri ʉsirioro tõbʉja mʉ. ");
INSERT INTO myy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bʉto ñasarise gaye cojiti ña. Yʉ bʉsirise tʉocõri, mʉ ocabajio María, ñasarisere bʉjamo. Nijʉa iso tʉo ãmisãrise isore ãmicãbiquĩji yiyijʉ Jesús Martare. ");
INSERT INTO myy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Co rʉmʉ Diore bʉsiyijʉ Jesús. Ĩ bʉsi tĩoroca ĩ rãca riasotigʉ sĩgʉ̃ ado bajiro bʉsiyijʉ: —Yʉ Ʉjʉ, Juan rãca riasotiana ĩ riasoado bajiro gʉare cʉni riasoya, Diore gʉa bʉsi masitoni, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ito ĩ yija tʉocõri: —Diore mʉ bʉsija ado bajiro yiba: Gʉa Jacʉ, ũmacʉ̃jʉ gagʉ ña mʉ. Mʉ wame masicõri masa jeyaro rʉ̃cʉbʉojaro ĩna. Masa jeyaro Ʉjʉ mʉ ñaroti rʉmʉ ejare ãmoa gʉa. Ũmacʉ̃jʉga tuti cʉni mʉ ãmoro bajiroti ñayija. Ito bajiri adi sitajʉ cʉni mʉ ãmoro bajiro riti ñare ãmoa gʉa. ");
INSERT INTO myy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Co rʉmʉ rʉyabeto gʉa baroticõti gʉare naju ĩsiña. ");
INSERT INTO myy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gʉa ñeñaro yirisere ãcabojoya. Gʉa cʉni gʉare ñeñaro yirãre ãcabojoa. “¿No bajiro yʉre cʉdirã yirãjida ĩna?” yi tʉoĩabesa gʉare. Gʉa ñeñaro yibititoni gʉare ejabʉaya. Itocõ ña. Amén, yiba. Ito bajiro Diore mʉa bʉsija quena, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","7","Gaje ado bajiro ĩnare gotiyijʉ Jesús: —Sĩgʉ̃ mʉa baba ñami gʉdareco mʉa ya wi ejacõri ado bajiro ĩ yija, “Yʉ baba, gãji yʉ baba wa ucuri masʉ yʉ ya wijʉ ejami. Ñe ecare ma yʉre. Ito bajiri yʉre naju wasoaya mʉ”, ĩ yija, mʉa wi toti ado bajiro cʉdirã yirãji mʉa: “Ʉsirioro yibesa yʉre. Soje cʉni biado ña. Ito yicõri yʉ rĩa rãca canigʉ̃ ya yʉ. Ito bajiri ñejʉa ĩsirocʉ wagãdo ma yʉ”, yi cʉdirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ito bajiro mʉa babare mʉa ĩsi ãmobitibojaja cʉni, ĩre ĩsirã yirãji mʉa, mʉcana ĩ ʉsirioro seni ʉyabe yirona. Ito yicõri ĩ ãmorocõ ĩsirã yirãji mʉa, ya yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ado bajiroti yire ña Diore mani senija. Mani Diore senija manire ĩsigʉ̃ yiguĩji. Ĩre mani ãmaja bʉjarã yirãji mani. “Mʉre bʉsi ãmoa yʉ”, mani yija, bʉsi rotigʉ yiguĩji manire. ");
INSERT INTO myy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","No senigʉ̃ti boca ãmiguĩji. No ãmagʉ̃ti bʉjagʉ yiguĩji. “Bʉsi ãmoa yʉ”, yigʉreti bʉsi rotigʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Adocãta mʉa rĩa ĩna naju senija, ¿Gʉ̃tagã ĩsire ñarojada mʉaca? Ito yicõri wai ĩna senija, ¿Ãña ĩsire ñarojada mʉaca? ");
INSERT INTO myy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ito yicõri cara ria ĩna senija, ¿cotiwãja ĩsire ñarojada mʉaca? Ĩsimenaji mʉa, yi tʉoĩa yʉ. ");
INSERT INTO myy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ñeñaro yirã ñabojarãti, mʉa rĩa ĩna senija quenarise yirã yirãji mʉa. Mani rĩare quenarise riti mani ĩsija, Dioama mani Jacʉ ũmacʉ̃jʉ gagʉ, ĩre mani senija, yiro bajiroti Espíritu Santo manire queo sãguĩji, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sĩgʉ̃re rʉ̃mʉ́ quedi sãjacõri, ĩ bʉsibeto yiyijʉ. Ito ĩ baji ñaroca rʉ̃mʉ́re bucõayijʉ Jesús. Rʉ̃mʉ́re ĩ bucõaja beroti bʉsicoayijʉ ĩ bʉsibicʉ ñabojarʉ. Ito bajiro iti rẽtaja ticõri, ʉcayijarã masa. ");
INSERT INTO myy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ito bajibojarocati coriarã ado bajiro tʉoĩayijarã: —Ãni ʉ̃mʉgʉ̃ rʉ̃mʉ́are ĩ bucõarise, rʉ̃mʉ́a ʉjʉ Beelzebú wame cʉtigʉ masirisenati bucõami, yi tʉoĩayijarã coriarã. ");
INSERT INTO myy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gãjerãma, “Dios cõarʉ ñami ĩ”, gʉa yi tʉoĩatoni, ũmacʉ̃jʉ gaye tiyamani gʉare ĩogʉ̃ yiguĩji ĩ, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ito bajiro ĩna tʉoĩarisere masicõyijʉ Jesús. Ito bajiri ado bajiro gotiyijʉ ĩ ĩnare: —Co sita gãna ñabojarãti ricati riti ĩna tʉoĩaja, ito yicõri ĩna gãmeri jaja, queno ña masimenaji ĩna. Co wi gãna ñabojarãti ricati riti ĩna tʉoĩaja queno corocõ ña masimenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ito bajiroti rʉ̃mʉ́a ʉjʉ Satanás, ĩ ñarãre ricati riti tʉoĩaroca ĩ yija, ĩna ʉjʉ queno ña masibiquĩji. Ado bajiro mʉare gotia yʉ. “Rʉ̃mʉ́a ʉjʉ Beelzebú ĩ masirisena rʉ̃mʉ́are bucõami”, yiboja mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Rʉ̃mʉ́a ʉjʉ masirisena yʉ rʉ̃mʉ́are bucõaja, ¿mʉa rãca gãnama ñimʉ masirisena rʉ̃mʉ́are bucõati ĩna? “Gʉa rãca gãnama rʉ̃mʉ́ masirise gayena meje rʉ̃mʉ́are bucõama ĩna”, yi tʉoĩa mʉa. Ito bajiri itire ti masicõri, “Rʉ̃mʉ́ masirisena meje rʉ̃mʉ́are bucõami ĩ cʉni”, yi tʉoĩa masia mʉa yʉre cʉni. ");
INSERT INTO myy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ado robojʉa bajia. Dios ĩ masirisena rʉ̃mʉ́are bucõa yʉ. Ito bajiro yʉ yija ticõri, “Mani wato ñacãguĩji Dios. Ĩre tʉorʉ̃nʉrãre miojusʉogʉ yami Dios”, yi masirʉja mʉare. ");
INSERT INTO myy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ʉ̃mʉgʉ̃ sẽogʉ̃, ito yicõri queno bisu cʉtigʉ, ĩ ya wijʉ ĩ tirʉ̃nʉja, iti wijʉ gaye quenoti ñacõaroja. ");
INSERT INTO myy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ito yibojarocati gãji ĩ rẽto bʉsaro sẽocõri rẽtocũgʉ̃ yiguĩji ĩre. “Adi yʉ bisu cʉtija ñimʉjʉa yʉre rẽtocũbiquĩji”, yi ĩ tʉoĩabojarocati ĩre rẽtocũgʉ̃ yiguĩji. Ito yicõri ĩ gajeoni cʉtibojarise ĩre ẽmagʉ̃ yiguĩji. Rʉ̃mʉ́a ʉjʉ rẽtoro masigʉ̃ ña yʉ. Ito bajiri rʉ̃mʉ́are bucõa masia yʉ, yi oca gotiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’No yʉ rãcajʉa ñabicʉ, yʉ rãca gagʉ meje ñami ĩocʉ̃. No yʉre ejabʉabicʉ, gãjerãre Diore masiroca yʉ yi ãmobojarocati yʉre ñeñaro yi codegʉ ñami ĩ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Sĩgʉ̃ masʉre rʉ̃mʉ́ ĩ budigoja, yucʉ manojʉ wa ucuguĩji tujarajʉ ãma ucugʉ. Ĩ bʉjabeja ado bajiro tʉoĩagʉ̃ yiguĩji ĩ: “Yʉ budigorʉre mʉcana tʉdi sãjacʉja yʉ”, yi tʉoĩagʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mʉcana tʉdi ejagʉ ĩ budigorʉre quenora wi, ʉeri mani wi robo bajiro, ti ejagʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ito bajiro ti ejacõri gãjerã rʉ̃mʉ́a jʉa ãmojeno ñarã ĩ rẽtoro ñeña bʉsarã jigʉ yiguĩji ĩ, ĩ rãca ñatoni. Ito yicõri ĩna ñarocõti ĩ ʉ̃mʉgʉ̃re sãjarã yirãji. Ito bajicõri ĩ ʉ̃mʉgʉ̃, cajero ĩ bajiado rẽto bʉsaro bajigʉ yiguĩji. Ito bajiri, rʉ̃mʉ́ mʉcana tʉdi sãjame yirocʉ, Diore ĩ tʉorʉ̃nʉ sʉyaja quena, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ito bajiro Jesús ĩ bʉsiro toto ĩre tʉorã wato sĩgõ oca sẽoro ado bajiro bʉsiyijo: —Mʉ jaco mʉre rʉcocõri, mʉre ũjugõ bʉto wanʉyijo iso, yiyijo iso Jesure. ");
INSERT INTO myy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ito bajiro iso yija tʉocõri, ado bajiro yiyijʉ Jesús isore: —Yʉ jaco rẽtoro wanʉrã yirãji, Dios rotirise tʉocõri ĩna cʉdija, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ito bajiro Jesús ĩ bʉsiroca jãjarã bʉsa masa ĩ tʉ minijua wayijarã. Ito yicõri ado bajiro ĩnare gotiyijʉ ĩ: —Adi rʉmʉri gãna ñeñaro yi jairã ña mʉa. Ado bajiro ya mʉa yʉre: “Tiyamani mʉ ĩoja ticõri, ‘Dios ĩ cõarʉti ñami ãni’, yiana gʉa”, ya mʉa yʉre. Ito mʉa yibojarocati tʉdi mʉare ĩobicʉja yʉ. Diore goti ĩsiri masʉ, Jonás ñayorʉ, ĩre rẽtagore riti mʉare goticʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonásre rẽtare ticõri, “Ãniti ñami Dios ĩ cõarʉ”, yiyijarã Nínive cʉto gãna. Yʉre cʉni ito bajiroti yirã yirãji mʉa. Yʉ ña Masa Rĩjorʉ. Yʉre rẽtare masicõri, “Ĩ ñami Dios ĩ cõarʉ”, yirã yirãji mʉa cʉni yʉre. ");
INSERT INTO myy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dios masare ñeñaro ĩna yirise waja ĩ waja seniri rʉmʉ ado bajiro rẽtaro yiroja. Sheba cʉto gago ʉjo ñayoro, mʉa adi rʉmʉri gãnare, “Mʉare seti ña”, yigo yigõji iso. Jane mejejʉ sõjʉ wayoyijo iso, queno tʉoĩagʉ̃ rãca Salomón wame cʉtigʉ rãca riasotiroco. Adocãta sĩgʉ̃ mʉa rãca ñami Salomón ñajacʉ rẽtoro tʉo masigʉ̃. Ito ĩ bajibojarocati queno ĩre tʉorʉ̃nʉbea mʉa. ");
INSERT INTO myy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nínive cʉto gãna cʉni ado bajiro yirã yirãji mʉare Dios ĩ waja seniri rʉmʉ: “Jaje seti ña mʉare”, yirã yirãji ĩna. Jane mejejʉ Nínive cʉto gãnare Dios oca gotiyoyijʉ Jonás ñayorʉ. Jonás ĩ gotija tʉocõri, ñeñaro ĩna yirise jidicãñi ĩna. Ito bajiri quenarise riti tʉoĩañi ĩna. Adocãta sĩgʉ̃ ñami mʉa rãca Jonás ñayorʉ rẽtoro ñasagʉ. Ito ĩ bajibojarocati queno ĩre tʉorʉ̃nʉbea mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Noajʉa sĩabusuoraga sĩayocõri ruyubetojʉ, jacajʉ cʉni cũmenaji mani. Ito yicõri rujajedo totijʉ cʉni cũmenaji mani. Ruyubeto cũrãonati gʉje tutujʉ jeobusuorãji mani, ejari masa queno tijaro yirona. ");
INSERT INTO myy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Rãitĩarise iti godaroca ya busurica. Mani ya cajea cʉni busurica robo bajiro bajia. Ito bajiri cajeana sʉoriti mani ya ʉsi queno tʉo masiro yiroja. Tite mʉa. Quenarise mani tija queno tʉoĩarã yirãji mani, mani ya ʉsijʉ. Ito bajibojarocati ñeñarise mani tija ñeñaro tʉoĩarã yirãji mani, mani ya ʉsijʉ. Ito bajiro mani yija busurojʉ meje ñarã yirãji mani. Rãitĩarojʉ ñarã bajiro ñarã yirãji mani ñeñarise mani tʉoĩa ʉyaja. ");
INSERT INTO myy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ito bajiri quenarise riti tʉoĩarʉja manire, ñeñarise riti mani tʉoĩa ʉyabe yirona. ");
INSERT INTO myy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mare sĩaticõri, “Adi majʉa ña quenari ma. Adi majʉa ña ñeñari ma”, yi ti masia mani. Ito bajiroti bajia mani ya ʉsijʉ cʉni. Mani ya ʉsijʉ quenarise riti mani tʉoĩa ñaja, “Iti ña quenarise. Iti ña ñeñarise”, yi ti masia mani, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús ĩ bʉsi tĩoroca sĩgʉ̃ fariseo gaye tʉoĩagʉ̃, “Yʉ ya wijʉ bato mani”, yirocʉ Jesure baba cʉtiyijʉ. Ito ĩ yija tʉocõri, ĩ ya wijʉ sãja wacõri badojʉ eja rũjũyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ĩna baroto riojʉa judio masa ĩna ãmo coesotiro bajiro Jesús ĩ ãmo coebeja ticõri, ti ʉcayijʉ fariseo gaye tʉoĩagʉ̃. ");
INSERT INTO myy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ĩ ti ʉcaja ticõri, ado bajiro yiyijʉ mani Ʉjʉ Jesús ĩre: —Mʉa fariseo gaye tʉoĩarã, joeti coeboja mʉa. Somotẽro idira tẽrori cʉni joejʉa riti coea mʉa. Totijʉama ñarocõti ʉeri cʉticõa. Mʉa guaja cʉni, joe rujʉ riti coea mʉa. Jubejʉama ñeñaro tʉoĩa mʉa maji. Ito bajiri gãjerã ĩna rʉcorise ti ʉorã ĩnare rʉoa mʉa. ");
INSERT INTO myy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Queno tʉoĩarã meje ña mʉa. Dios mʉa ya rujʉ rujeorʉ, mʉa ya ʉsi cʉni meniñi. ¿Itire masibeati mʉa? ");
INSERT INTO myy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mʉa ya ʉsijʉ queno tʉoĩacõri bojoro bʉjarãre ejabʉarʉja mʉare. Ito bajiro mʉa yija queno ʉsi cʉti ñarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Bʉjato bʉjarã yirãji mʉa, fariseo gaye tʉoĩarã. Dios ĩ rotiado bajiroti jeyaro mʉa bʉjarise ĩre jabeto jʉdacõa mʉa. Ito bajiro mʉa yiriseama quena ña. Ito bajiro queno yirã ñabojarãti gãjerãre queno yibea mʉa. Ito yicõri Diore maibea. Ito bajiro yibitirʉja mʉare. ");
INSERT INTO myy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Bʉjato bʉjarã yirãji mʉa, fariseo gaye tʉoĩarã. Minijuara wijʉ sãja wacõri rʉ̃cʉbʉorajʉ riti ruji ãmoboja mʉa. Ma warã cʉni gãjire mʉa bocaja, rʉ̃cʉbʉore rãca ĩ seniĩare ãmoa mʉa. Mʉa ñaroti gaye riti tʉoĩa mʉa. ");
INSERT INTO myy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Bʉjato bʉjarã yirãji mʉa. Gãjerã ĩna tiro riojo queno yirã ña mʉa. Ito bajibojarocati ĩna tibetojʉ ñeñaro yirã ña. Ito bajiro mʉa yija ticõri, “Queno yirã ñama ĩna”, yibojama gãjerã. Ito bajiro ĩna tʉoĩabojarocati queno yirã meje ña mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ito bajiro ĩ bʉsija tʉocõri, sĩgʉ̃ judio masa rotirise riasori masʉ ado bajiro cʉdiyijʉ ĩre: —Yʉre riasogʉ, ito bajiro mʉ bʉsija queno ejabea gʉare, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ito ĩ yija tʉocõri, Jesujʉa ado bajiro yiyijʉ ĩre: —Bʉjato bʉjarã yirãji mʉa judio masa rotirise riasori masa cʉni. Gãjerãre jaje ũma rotia mʉa. Ñimʉjʉa mʉo yiado ma itire. Ito bajiro yicõri ĩnare ũma ejabʉa ãmobea mʉa. Jaje rotia mʉa. Jaje mʉa rotibojaja ñimʉjʉa mʉare cʉdi masibiquĩji. Ito bajiro rotirã ñabojarãti mʉa rotiro bajiroti yibea mʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Bʉjato bʉjarã yirãji mʉa. Mʉa ñicʉsabatia Diore goti ĩsiri masare sĩañi. Ĩnare bajiroti bajia mʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ito bajiro mʉa bajija ti masicõri, “Ĩna ñicʉsabatia robo bajiro tʉoĩarã ñama ĩna cʉni”, yi tʉoĩama masa mʉare. ");
INSERT INTO myy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ito bajiro ĩna yiroto riojʉa masi yucãyijʉ Dios. Jane mejejʉ queno tʉoĩagʉ̃ ñari, ado bajiro yiyijʉ Dios mʉare tʉoĩa yugʉ: “Yʉre goti ĩsiri masa, ito yicõri yʉ oca goti ucuri masare cʉni, ĩna tʉ yʉ cõaja, coriarãre sĩarã yirãji ĩna. Ito yicõri gãjerãre ĩna tõbʉjaroca yirã yirãji ĩna”, yi gotiyijʉ Dios jane mejejʉ. ");
INSERT INTO myy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Jane mejejʉ adi macãrʉcʉ̃ro ĩ rujeoja bero ĩre goti ĩsiri masare sĩasʉoñi mʉa ñicʉsabatia. Tite mʉa. Abel ñayorʉre sĩañi ĩna. Ĩ bero gãnare cʉni jãjarãre sĩañi ĩna. Ito yicõri Zacarías wame cʉtigʉre Dios ya wi gʉdareco rʉ̃gõgʉ̃re ĩre sĩasʉsañi mʉa ñicʉsabatia. Ito bajiri ĩna sĩare waja, waja senigʉ̃ yiguĩji Dios, ya yʉ mʉare adi rʉmʉri gãnare cʉni, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Bʉjato bʉjarã yirãji mʉa judio masa rotirise riasori masa. Dios oca riasotirã ñabojarãti, ĩ ocare queno tʉorʉ̃nʉbea mʉa. Ito yicõri Dios ocare gãjerã ĩna tʉorʉ̃nʉ ãmobojarocati rẽoa mʉa ĩnare, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ito bajiro Jesús ĩ bʉsi waja tʉocõri, judio masa rotirise riasori masa, ito yicõri fariseo gaye tʉoĩarã bʉto junisiniyijarã ĩna Jesure. Ito bajiro junisinicõri ʉsirioro ĩre jeyaro seniĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ito bajiro ʉsirioro seniĩa codeyijarã ĩna, ĩ queno cʉdi masibeja ticõri, “Ĩre seti ña”, yirona. ");
INSERT INTO myy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ito baji ñaroca jãjarã bʉsa masa minijuarã, bidi warã gãmeri cʉdayijarã ĩna. Ito bajiro ĩna baji ñaroca ĩ rãca riasotirãre ado bajiro gotisʉoyijʉ Jesús: —Fariseo gaye tʉoĩarãre queno tʉoĩa masima. Mʉa tiro riojo queno yirãji ĩna. Ito bajibojarãti mʉa tibetojʉ ñeñaro yirãji ĩna. “Queno yirã ña gʉa”, yirã ñabojarãti ñeñaro yama ĩna. ");
INSERT INTO myy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jeyaro mani yeyo bʉsibojarise gayere masi jeorã yirãji masa. Ito yicõri no mani yeyobojarise cʉni bʉjacõrã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mʉa yeyo bʉsibojarisere masa jeyaro tʉorã yirãji ĩna. Ito yicõri sojere biatucõri mʉa yeyo bʉsibojarisere cʉni masa jeyaro ĩna tʉo jeditoni ũmacʉ̃jʉ oca ruyuro yiroja, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mʉcana ado bajiro gotiyijʉ Jesús ĩnare: —Yʉ baba mesa ado bajiro mʉare gotia yʉ. Rujʉre sĩarãre güibitirʉja manire. Ĩna sĩaja bero ñejʉa gaje ñeñaro manire yi masimenaji ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","“¿Ñimʉjʉare mani güija quenati?” yirocʉ mʉare gotigʉ ya yʉ. Diore mani güija quena. Dios ĩ sĩaja bero jeame ʉ̃jʉrojʉ mani ya ʉsire ĩ cõa ãmoja, cõagʉ̃ yiguĩji ĩ. Ito bajiri ĩjʉare mani güija quena. ");
INSERT INTO myy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Co dʉjamocõ minia mani ĩsija niyeru jʉatiacã senirã yirãji mani. Queno waja mama ĩnaõna. Queno waja mana ĩna ñabojarocati sĩgʉ̃ ĩnare ãcaboja yibiquĩji Dios. Ĩnare queno tirʉ̃nʉgʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Manire cʉni queno tirʉ̃nʉami Dios. Mani ya joare cʉni, “Itocõ joa cʉtiami ĩ”, yi masiami manire. Ito bajiri tʉoĩa oca jaibitirʉja manire. Minia rẽtoro ñasarã ña mani, Dios ĩ tija, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ado bajiro mʉare gotia yʉ: No masa riojo, “Jesure masia yʉ, ito yicõri ĩre rʉ̃cʉbʉoa yʉ”, yigʉre, yʉ Masa Rĩjorʉ cʉni, “Masia yʉ ĩre”, yigʉ yigʉja yʉ ángel mesa ĩna tiro riojo. ");
INSERT INTO myy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","No “Jesure masibea yʉ”, ĩ yija, “Masibea yʉ cʉni ĩre”, yigʉ yigʉja yʉ ángel mesa tiro riojo. ");
INSERT INTO myy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’No yʉ Masa Rĩjorʉre, bʉsitugʉ ñabojagʉti, “Ñeñaro yʉ yirise yʉre ãcabojoya”, ĩ yija tʉocõri, ĩre ãcabojogʉ yiguĩji Dios. Ito bajibojarocati no Espíritu Santore bʉsitugʉreama ĩ ñeñaro yirisere ãcabojo masibiquĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Minijuara wijʉ mʉare ãmi warã yirãji, ʉjarã riojo, “Ãnare seti ña”, yirona. Ito bajiro ĩna yibojarocati, “Ado bajiro cʉdicʉja yʉ”, yi tʉoĩa ʉsirio yibeja. ");
INSERT INTO myy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mʉa bʉsiroti iti eja waja, Espíritu Santo mʉare ejabʉagʉ yiguĩji mʉa queno bʉsi masitoni, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ito bajiro ĩna baji ñaroca masa wato gagʉ sĩgʉ̃ ado bajiro yiyijʉ Jesure: —Yʉre riasogʉ, gʉa jacʉ ĩ rʉcogore gʉdarecona jidicãjaro yʉ rĩjorʉ yʉre, ĩre gotiya yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ito bajiro ĩ yija Jesujʉama ado bajiro cʉdiyijʉ ĩre: —Ito bajiro yirocʉre meje ado yʉre cũñi yʉ jacʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ito yicõri gaje ado bajiro gotiyijʉ Jesús ĩnare: —Queno tʉoĩaña mʉa gãjerã ya gajeoni ʉobe yirona. Gajeoni jairo mani rʉcoja, jabetacã mani rʉcoja cʉni no yibea. Bʉto ñasarise meje ña gajeoni, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ito bajiro ĩnare goticõri ado bajiro ĩnare oca goti masioyijʉ Jesús: —Sĩgʉ̃ gajeoni jaigʉ ñayijʉ. Ĩ ñari sita gaye ote queno rica cʉtiyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ito bajiro ĩ ya ote rica cʉtija ticõri, ado bajiro tʉoĩayijʉ ĩ: “¿Yʉ ya ote jaje bʉcʉarisere no bajiro cũgʉ̃ yigʉjada yʉ?” yi tʉoĩayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gajereama ado bajiro tʉoĩayijʉ ĩ: “Mʉtari wiri seora wiri jana batecʉja yʉ. Ito yicõri cʉri wiri menicʉja. Ito bajiro cʉri wiri menicõri yʉ ya ote seocʉja yʉ, ito yicõri yʉ gajeoni cʉtirise cʉni. ");
INSERT INTO myy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Iti gajeoni yʉ seorise jaje rodori ñagʉ̃ yigʉja yʉ itina. Ito yicõri queno ñacõagʉ̃ yigʉja yʉ ĩja. Yʉmasiti queno bacʉja yʉ. Idicʉja yʉ”, yi tʉoĩayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ito bajiro yi ĩ tʉoĩabojarocati, ado bajiro yiyijʉ Dios ĩre: “Queno tʉoĩabicʉ ña mʉ. Adi ñamiti godagʉ ya mʉ. Ito bajiri jeyaro mʉ seobojarise gãji ye ñaro yiroja”, yiyijʉ Dios ĩre, yi gotiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ito bajiro rẽtaro yiroja sĩgʉ̃ ĩ gajeoni cʉtirise ĩ seomʉcʉtija. Ito bajiro ĩ yija Dios tʉjʉ ñe bʉjabiquĩji ĩocʉ̃. Dios ĩ tija waja mami, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mʉcana tʉdi ado bajiro yiyijʉ Jesús ĩ rãca riasotirãre: —“¿Mani catirã baroti, no bajiro bʉjarãti mani?” yi tʉoĩa ʉsirio yibesa. Ito yicõri, “¿No mani sãñaroti bʉjarãti mani?” yi tʉoĩa ʉsiriobesa. ");
INSERT INTO myy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bare rẽto bʉsaro ñasarise ña mani catirise. Ito yicõri yutabujuri rẽto bʉsaro ñasarise ña mani ya rujʉ. Ito bajiri manire rujeorʉ ñari mani ña masitoni bare, yutabujuri cʉni ĩsigʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ãiriare tʉoĩate mʉa. Weseca menicõri ote otecõri babiticã ĩna. Ito yicõri ote rica bʉjacõri ĩna seoroto manoja ĩnare. Ito bajibojarocati Dioama queno ecaguĩji ĩnare. Dios ĩ tija wʉtirã rẽto bʉsaro ñasarã ña mani. ");
INSERT INTO myy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Yoari cati ãmoa yʉ”, yi mani tʉoĩabojaja cʉni, “Itocõ catigʉ yigʉja yʉ”, yi masibea mani. ");
INSERT INTO myy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Itocõ catigʉ yigʉja yʉ”, mani yi masibeja gaje gaye cʉni tʉoĩa ʉsiriobiticõrʉja manire, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Gaje, go iti judi mʉjarise tʉoĩate mʉa. Judi mʉjacõri moabetoja iti. Ito yicõri iti sãñaroti cʉni ãmabetoja. Ito bajibojarocati ʉjʉ Salomón ñayorʉ seyorise ĩ sãñare rẽtoro seyorise ña go. ");
INSERT INTO myy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nocõ mejeti ñacʉ go. Gaje rʉmʉti ũmacañi ĩ asirisenati siniacoacʉ. Ito bajibojarocati seyorise cũñi Dios itire. Go rẽtoro ñasarã ña mani. Ito bajiri ĩre queno tʉorʉ̃nʉrã meje ñabojarocati queno tirʉ̃nʉgʉ̃ ñari mʉa sãñarotire mʉare jidicãgʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ito bajiri, “¿Gʉa sãñaroti, gʉa baroti no bajiro bʉjarʉjati?” yi tʉoĩa ʉsiriobiticõrʉja mʉare. ");
INSERT INTO myy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ito bajiro tʉoĩa ʉsirio ñama adi macãrʉcʉ̃ro gãna. Manireama mani jacʉ sĩgʉ̃ti ñami. “Adi ma ĩnare. Adire ãmoama ĩna”, yi masiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","“Dios masa jeyaro Ʉjʉ ĩ rotiro bajiro yicʉja yʉ”, mani yija, iti ña ñasarise gaye. Ito bajiro mani yija mani ãmorise ĩsigʉ̃ yiguĩji Dios manire. ");
INSERT INTO myy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Güibesa yʉ coderã mʉa. Coriarãti ña mʉa. Ito bajibojarocati ĩ rotirojʉ mʉa ejare bʉto ãmoami ĩ mani Jacʉ. ");
INSERT INTO myy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mʉa rʉcorise gãjerãre ĩsima. Iti waja bʉjacõri bojoro bʉjarãre ĩsima mʉa. Ito bajiro mʉa yija jai bʉsaro Dios tʉ bʉjarã yirãji mʉa. Itojʉ mʉa bʉjaroti jogarise meje ñaroja. Ito yicõri itojʉ mʉa bʉjarise ñimʉjʉa rinibiquĩji. Ito yicõri mʉa bʉjarisere butua bamenaji. ");
INSERT INTO myy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","No mani gajeoni cʉtirojʉ iti tʉ ñarona bʉto tʉoĩarã yirãji mani, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Quenaro ña yucãña mʉa, jeyaro mʉa rẽtaroti gaye yiari. ");
INSERT INTO myy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ĩna ʉjʉ ãmo siare basa ti tĩo, budi wadicõri ĩna bocati ñado robo bajiro ña yucaña mʉa. Soje tʉ ĩ ejaroca jana yucãdo bajiro ñacãña mʉa. ");
INSERT INTO myy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Queno ña yucõri ĩna ʉjʉ ĩ ejaja ticõri, queno wanʉrã yirãji ĩna. Ito bajiro ĩna bajija ticõri, “Rujiya mʉare ecagʉ ya yʉ”, yigʉ yiguĩji ĩ, ĩnare wanʉgʉ̃. ");
INSERT INTO myy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ñami gʉdareco, busurijʉa cʉni, ĩ ejaroto riojʉa ĩna ña yucãja wanʉrã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Adi yʉ gotirisere ãcabojabeja mʉa. Sĩgʉ̃ wi gagʉ, “Itocõ tʉjaroca ejagʉ yiguĩji riniri masʉ”, ĩ yi masija, ña yucãborʉ ĩocʉ̃, riniri masʉ sãjacõri rinime yirocʉ. ");
INSERT INTO myy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Itioni bajiroti queno ña yucaña mʉa cʉni. “Adocõ ejagʉ yiguĩji Masa Rĩjorʉ”, mʉa yi masibiti rʉmʉ ejagʉ yiguĩji. Ĩti ña yʉ Masa Rĩjorʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ito ĩ yija tʉocõri, Pedro ado bajiro ĩre seniĩayijʉ: —Yʉ Ʉjʉ, ¿ito bajiro oca mʉ goti masiorise, gʉa ye riti ñati? ¿Masa jeyaro ye ñatite? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Ito bajiro ĩ yija tʉocõri, ado bajiro cʉdiyijʉ mani ʉjʉ ĩre: —¿No bajigʉ ñati tʉo masicõri ĩ ʉjʉre queno moa ĩsigʉ̃? Tite mʉ. Ado bajirojʉa bajiami ĩocʉ̃. Ĩ ʉjʉ ĩre wijʉ cũgʉ̃ yiguĩji ĩ codetoni, ito yicõri gãjerã ĩre moa ĩsiri masare bare ĩ ecatoni. Sĩgʉ̃ moa ĩsiri masʉ, ĩ rotiado bajiroti ĩ moagore ti ejacõri wanʉgʉ̃ yiguĩji Ʉjʉ ĩre. Ʉjʉ ĩ rotiado bajiroti ĩ moaja ticõri, jeyaro tirʉ̃nʉri masʉ cũgʉ̃ yiguĩji ĩ ito bero. ");
INSERT INTO myy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ito bajibojarocati, “Coji ejabiquĩji yʉ ʉjʉ maji”, yi tʉoĩacõri ĩre queno moa ĩsibiquĩji. Ado bajiro yigʉ yiguĩji. Gãjerã ĩ rãca moari masare sẽoro ĩnare rotigʉ yiguĩji. Ʉ̃mʉare romiare cʉni, ito bajiro yigʉ yiguĩji ĩ. Ito yicõri bare ba, idi mecʉ yigʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ito bajiri, “Jane ejagʉ yiguĩji yʉ ʉjʉ”, ĩ yibiti rʉmʉ ĩre ejabiagʉ yiguĩji ĩ ʉjʉ. Ĩ ito yire waja bʉto waja senigʉ̃ yiguĩji ĩre. Ito yicõri queno cʉdimenare ĩ moa rotiado bajiro ĩre cʉni moa rotigʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ĩ ʉjʉ rotirise yiro robo yi masibojagʉti ĩ ña yucãbeja, ito yicõri yiro robo ĩ yibeja ĩ ʉjʉ bʉto bajegʉ yiguĩji ĩre. ");
INSERT INTO myy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Ado bajiro ãmoami yʉ ʉjʉ”, yi masibicʉ ñari, ĩ ʉjʉre queno ĩ cʉdi masibeja, ito yicõri yiro robo ĩ yibeja bʉto bajebiquĩji ĩ ʉjʉ ĩre. No Diore ĩ cʉdiroca yigʉ bʉto bʉsa ĩ cʉdire ãmogʉ̃ yiguĩji Dios. No ĩre tʉorʉ̃nʉroca ĩ yigʉ bʉto bʉsa ĩ tʉorʉ̃nʉre ãmogʉ̃ yiguĩji Dios, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Masa yʉre ĩna tʉorʉ̃nʉtoni adi macãrʉcʉ̃rojʉ wadirʉ ña yʉ. Coriarã yʉre tʉorʉ̃nʉrã yirãji. Gãjerã tʉorʉ̃nʉmena yirãji. Sĩgʉ̃re bajiro tʉoĩamena ñarã yirãji ĩna. Yʉre rẽtaroti ñabojarocati iti rẽtaja quena yʉre. ");
INSERT INTO myy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Jaje quenabeto tõbʉjagʉ yigʉja yʉ. Iti rẽtaroto riojʉa bʉto tʉoĩa ʉsirioa yʉ. ");
INSERT INTO myy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Masa jeyaro, sĩgʉ̃ rʉyabeto oca mano ĩna ñatoni wadirʉ ñami ĩ”, yi tʉoĩaboja mʉa yʉre. Bajibea. Yʉ oca tʉocõri sĩgʉ̃re bajiro tʉoĩamena yirãji masa. ");
INSERT INTO myy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jane adi rʉmʉna ado bajirojʉa ñarã yirãji masa. Co dʉjamocõ ñarã ʉdiarã yʉre tʉorʉ̃nʉrã yirãji. Gãjerã tʉorʉ̃nʉmena yirãji. Yibeja, ʉdiarã yʉre tʉorʉ̃nʉbiticõri jʉ̃arã yʉre tʉorʉ̃nʉrã yirãji gajea. ");
INSERT INTO myy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jacʉ yʉre ĩ tʉorʉ̃nʉja, macʉ tʉorʉ̃nʉbicʉ yiguĩji. Macʉ ĩ tʉorʉ̃nʉja, jacʉ tʉorʉ̃nʉbicʉ yiguĩji. Jaco iso tʉorʉ̃nʉja, maco tʉorʉ̃nʉbeco yigõji. Maco iso tʉorʉ̃nʉja jaco tʉorʉ̃nʉbeco yigõji. Mañicõ iso tʉorʉ̃nʉja, jẽjo tʉorʉ̃nʉbeco yigõji. Jẽjo iso tʉorʉ̃nʉja, mañicõ tʉorʉ̃nʉbeco yigõji. Yʉ oca tʉocõri sĩgʉ̃re bajiro tʉoĩamena yirãji masa, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Gaje ado bajiro goti remoyijʉ Jesús masare: —Ũmacañi ruji waro ide bueri iti mʉja wadija ticõri, “Ide quediro wadia”, yi masia mʉa. Mʉa yiro bajiroti quedia iti. ");
INSERT INTO myy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wesicajʉare mino iti wẽa mʉocõaja ticõri, “Asiro wado ya”, yi masia mʉa. Mʉa yiro bajiroti bajia iti. ");
INSERT INTO myy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Macãrʉcʉ̃ro gaye ticõri, “Ado bajiro rẽtaro yiroja”, yi masia mʉa. ¿No yija ito bajiro ti masirã ñabojarãti, “Gʉa ñeñaro yirise gʉa jidicãbeja quenabeto tõbʉjarã yirãji gʉa”, yi masibeati mʉa? “Queno yirã ña gʉa”, yibojarãti mʉa tʉoĩaro bajiro yibea mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’“Ado bajiro yija quena manire”, yi tʉoĩa mʉa. Ito bajibojarocati “Quenarise riti yirʉja mani”, yibea mʉa. ");
INSERT INTO myy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gãji mʉare ĩ seti yija, oca quenori masʉ tʉjʉ mʉa waroto riojʉa oca quenoña. Oca quenori masʉ tʉ ejamenati mʉa oca queno masibeja porecia tʉ mʉare ãmi wacʉ yiguĩji. Ĩna poreciajʉ mʉare tubiarã yirãji. ");
INSERT INTO myy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ñeñaro mʉa yigore mʉa waja yibeja, budimena yirãji mʉa. Ito bajiroti bajia. Ito bajiri Dios ĩ waja seniri rʉmʉ ejaroto riojʉa ĩ rãca oca quenoña. Mʉa quenobeja ĩ waja seniri rʉmʉ mʉare jeame ʉ̃jʉrojʉ cõagʉ̃ yiguĩji. Ito yicõri ĩ cõaja bero mʉcana tʉdi budire ma, ya yʉ mʉare, yi gotiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Iti rʉmʉriti ado bajiro Jesure gotirã ejayijarã masa: —Galilea gãna Diore rʉ̃cʉbʉorona waibʉcʉrã sĩacã ĩna. Ito bajiro waibʉcʉrãre ĩna sĩaja bero Pilatojʉama ĩnareti sĩa rotiquĩ ĩ ĩja. Ito bajiro yicõri waibʉcʉrã ya rí rãca ĩna ya ríre wʉoquĩ ĩ ija, yi goti ejayijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ĩna ito yija tʉocõri, ado bajiro yiyijʉ Jesús: —¿No bajiro tʉoĩati mʉa? “Gãjerã Galilea gãna rẽtoro ñeñaro yirã ñacã ĩna. Ito bajiri goda jediyijarã ĩna”, ¿yire masiati mʉa? ");
INSERT INTO myy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Meje ito bajiro meje bajia. Ado bajiro ya yʉ mʉare: Mʉare cʉni mʉa ñeñaro mʉa yirise mʉa jidicãbeja, ito bajiroti godarã yirãji mʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Jerusalénjʉ ũmari wi Siloé wame cʉtiri wi dieciocho ñarã ĩna juja quedi godaja, gãjerã Jerusalén gãna rẽtoro seti ñadoja ĩnare”, ¿yi tʉoĩati mʉa? ");
INSERT INTO myy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Meje, ito bajiro meje ya yʉ. Mʉa ñeñaro yirise mʉa jidicãbeja, ito bajiro rẽtaro yiroja mʉare cʉni, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ito bero masare goti masiore ocana ado bajiro gotiyijʉ Jesús: —Sĩgʉ̃ higuera wame cʉtiricʉ ĩ oteragʉ tigʉ wayijʉ, “¿Rica cʉticʉati?” yirocʉ. Rica manigʉ̃ti ti ejayijʉ ĩ itigʉre. ");
INSERT INTO myy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ito bajija ticõri, ĩ ya wese coderi masʉre ado bajiro yiyijʉ: “Tite. Ʉdia rodojʉ coji rʉyabeto rica ãmigʉ̃ ejasotiboja yʉ. Rica ma itigʉ. Quẽacãcõña. Rica cʉtia yiro meje ña ajea itigʉ”, yiyijʉ ĩ, ĩ ya wese coderi masʉre. ");
INSERT INTO myy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ito bajiro ĩ yija tʉocõri: “Yʉ ʉjʉ, ito ñacõato maji. Sita seacũgʉ̃ ya maji. Ito yicõri quenarise itigʉre tucʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ito yija rica cʉtiro yiroja gajea. Iti rica manija, quẽacõre ñaro yiroja”, yiyijʉ ĩ, ĩ ʉjʉre. Ito bajiroti bajia. Sĩgʉ̃, “Diore tʉorʉ̃nʉgʉ̃ ña yʉ”, yibojagʉti ĩ ñeñaro yirise ĩ jidicãbeja ticõri, ĩre waja senigʉ̃ yiguĩji Dios, yi gotiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Co rʉmʉ tujacãra rʉmʉ judio masa ĩna minijuasotiri wijʉ riaso ñayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ito ĩ yiroca sĩgõ ñayijo dieciocho rodori cõ tʉjago. Ito bajiri isore ruja mutĩgʉ̃ ñaroca yiyijʉ rʉ̃mʉ́. Ito bajicõri riojo rʉ̃gõ masibisijo iso. ");
INSERT INTO myy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Isore ticõri isore bʉsirocʉ ji ñucayijʉ Jesús: —Romio mʉre quenoa yʉ. Mʉ ñarise cʉtirise ma mʉre ĩja, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ito yicõri isore ãmo moa jeoyijʉ Jesús. Ito ĩ yirocati riojo rʉ̃gʉ̃coayijo iso ĩja. Ito bajiri Diore rʉ̃cʉbʉogo wanʉre ocana ĩre bʉsisʉoyijo iso. ");
INSERT INTO myy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tujacãra rʉmʉ Jesús isore yisioja ticõri, iti wi minijuara wi ʉjʉ Jesure junisiniyijʉ. Ito bajiri ado bajiro yiyijʉ ĩ masare: —Co ãmojeno rʉmʉri ña moaroti rʉmʉri. Mʉa yisio roti ãmoja iti rʉmʉri wadija quena, tujacãra rʉmʉ meje, yiyijʉ ĩ masare. ");
INSERT INTO myy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ito bajiro ĩ yija tʉocõri, ado bajiro cʉdiyijʉ mani Ʉjʉ ĩre: —“Tujacãra rʉmʉ moare ma”, yi bojarãti moarãji mʉa. Tite. Tujacãra rʉmʉ ñabojarocati mʉa ya wecʉ mʉa ya burro ide iditoni õja mʉa. ");
INSERT INTO myy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Adio ñamo mani ñicʉ Abraham janerãbatia janeño. Dieciocho rodori iso cõ ñaroca yiñi rʉ̃mʉ́a ʉjʉ Satanás. ¿Tujacãra rʉmʉ ñabojarocati isore yʉ yisioja quenabetojada? yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ito bajiro Jesús ĩ bʉsija tʉocõri, ĩ wajana ĩre bojo tiyijarã ĩna. Masama jeyaro tiyamani Jesús ĩ ĩoja ticõri, bʉto wanʉ quenayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ito yija mʉcana ado bajiro gotiyijʉ Jesús masare: —Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ Dios ĩ miojuja, ¿no bajirojada? ¿Ñe goti masiore ocana mʉare goti rẽtobugʉjada yʉ? Baʉ, ado bajirojʉa mʉare goticʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostaza ajerire tʉoĩate mʉa. Sĩgʉ̃ ĩ ya weseca mostaza ajeri oteyijʉ. Gaje ote ajeri rẽtoro mʉtacã bʉsa ña iti mostaza ajeri. Ito bajiro mʉtacã ñabojaroti bʉcʉa wato gaje ote yucʉri rẽto bʉsaro jajocʉ ñaroja itigʉ. Jajocʉ itigʉ ñajare itigʉ rʉjʉrijʉ minia jibʉ menirãji ĩna. Itire bajiroti Dios mani Ʉjʉ ĩ ñaja, gãjerãre goti ãmorãji mani, jãjarã bʉsa ĩre masirã ĩna ñatoni, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gajereama ado bajiro yiyijʉ Jesús ĩnare: —Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ Dios ĩ miojuja, ¿no bajirojada? Ado bajiro goti masiorena mʉare gotia yʉ. ");
INSERT INTO myy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Romio pan menigõ waco ʉdia coacõ pan menire gaye ãmiyijo iso. Ito yicõri wadarise ʉco wʉoyijo iso. Ito bajiri iso wʉoja jairo wadayijʉ iti. Itire bajiroti bajiro yiroja, “Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, masare mani yi riaso ucuja. Ito bajiri jãjarã bʉsa ĩre tʉorʉ̃nʉ warã yirãji ĩja, yi riasoyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ito yija Jesús Jerusalénjʉ wasʉoyijʉ mʉcana mana. Wacʉ riti cʉtori ĩ ejaja masare riaso rẽta wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ito bajiro ĩ riaso rẽta waroca sĩgʉ̃ ĩre seniĩayijʉ: —Yʉ Ʉjʉ, ¿coriarãreti, masogʉ̃ yiguĩjida Dios? yiyijʉ ĩ Jesure. Ito bajiro ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: ");
INSERT INTO myy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Masa jeyaro meje Dios ĩ ñarojʉ sãjarã yirãji ĩna. Ito bajiri ñeñaro mʉa yirise jidicãña mʉa, “Dios ñarojʉ sãjana gʉa”, yirona. Jãjarã sãja ãmobojarã yirãji ĩna. Ito bajibojarocati coriarãti sãjarã yirãji. ");
INSERT INTO myy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ado robojʉa bajia. Dios ĩ ñarojʉ ĩ biaja, macʉ̃jʉjʉ mʉa ñaja, sãja masimena yirãji mʉa. “Gʉa Ʉjʉ, gʉare soje jana ĩsiña”, yibojarã yirãji mʉa. “Meje yʉ ñarã meje ña mʉa. Mʉare masibea yʉ”, yigʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ito bajiro ĩ yija tʉocõri, ado bajiro cʉdibojarã yirãji mʉa: “Mʉ rãca bacʉ gʉa. Mʉ rãca ñacʉ gʉa. Ito yicõri gʉa ya cʉtorijʉ masare riaso ucucʉ mʉ”, yibojarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ito bajiro mʉa yibojarocati ado bajiro mʉare cʉdigʉ yiguĩji ĩ: “Mʉare masibea yʉ. Yʉ tʉ ñabesa mʉa. Ñeñaro yi jairã ña mʉa”, yigʉ yiguĩji ĩ, ya yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dios ĩ rotirojʉ sãja masimena yirãji mʉa. Abraham, Isaac, Jacob, ito yicõri Diore goti ĩsiri masa ñayoana ĩ tʉ ĩna ñaja tibojarã yirãji mʉa. Ito bajibojarocati ĩna tʉjʉ eja masimena yirãji mʉa. Mʉare cõacõgʉ̃ yiguĩji Dios. Ito bajiri sãja masibiticõri ruje otirã yirãji mʉa. Ito yicõri bʉto tõbʉjarã ñari mʉa ya guji cuni canamʉorã yirãji. ");
INSERT INTO myy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Co sita gãna rʉyabeto Dios ĩ rotirojʉ ejacõri minijua barã yirãji. Ĩna rãca sãja masibiticõri ti bʉjatomena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Adojʉ coriarã ñasari masa ñarã, itojʉ ñasari masa meje ñarã yirãji ĩna. Ito yicõri adojʉ coriarã ñasari masa meje ñarã itojʉ ñasari masa ñarã yirãji ĩna, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iti rʉmʉti Jesure oca gotirã ejayijarã fariseo gaye tʉoĩarã: —Rudi wasa adijʉre. Herodes mʉre sĩa ãmoami, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ĩna ito bajiro yija tʉocõri: —Ĩ ñeñaro yi jaigʉre ado bajiro gotitẽña mʉa: “Tʉoya jane, jane busuri cʉni cõrãre yisiocʉja yʉ. Rʉ̃mʉ́ sãñarãre cʉni rʉ̃mʉ́are bucõacʉja yʉ. Ito yicõri, ija sõjʉa moa tĩogʉ̃ yigʉja yʉ, yimi”, yi gotitẽña mʉa Herodesre, yiyijʉ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jane, jane busuri, gaje rʉmʉ cʉni Jerusalénjʉ ware ña yʉre. Jerusalénjʉ godagʉ yigʉja, jãjarã Diore goti ĩsiri masa ĩna godado bajiroti, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén gãnare tʉoĩagʉ̃, ado bajiro bʉsiyijʉ Jesús: —Diore goti ĩsiri masare sĩayija mʉa. Mʉare oca gotitoni Dios ĩ cõanare cʉni gʉ̃ta reayija mʉa. Coji meje mʉare mioju ãmobojacʉ yʉ. Cara iso rĩare caero rocajʉ iso miojuro bajiro, mʉare yi ãmobojacʉ yʉ. Ito bajiro yʉ yi ãmobojarocati ãmobiticʉ mʉa. ");
INSERT INTO myy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Queno tʉoĩaña mʉa. Mʉa wiri wagora wiri bajiro tujaro yiroja. Ito yicõri mʉare jidicãgʉ̃ yiguĩji Dios. Riti ado bajiro mʉare gotia yʉ. “Gʉare yiari Dios ĩ cõarʉ ña mʉ. Mʉre queno yiñi Dios”, mʉa yiroto riojʉa mʉcana jʉaji yʉre timena yirãji mʉa, ya yʉ mʉare, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Co rʉmʉ tujacãra rʉmʉ fariseo gaye tʉoĩarã ʉjʉ tʉ bagʉ wayijʉ Jesús. Gãjerã fariseo gaye tʉoĩarã, “¿No bajiro yigʉ yiguĩjida Jesús?” yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ito bajiro Jesús ĩ baji ñaroca, sĩgʉ̃ rujʉri mijigʉ̃ ejayijʉ ĩ tʉ. ");
INSERT INTO myy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ĩ ejaja ticõri, judio masa rotirise riasori masa, ito yicõri fariseo gaye tʉoĩarãre ado bajiro seniĩayijʉ Jesús ĩnare: —¿Cõgʉ̃re tujacãra rʉmʉ ñaroca mani yisioja quenati? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ĩnama cʉdibisijarã. Ĩna cʉdibeja ticõri, cõgʉ̃re moaĩacõri ĩre yisioyijʉ. Ito yicõri, “Wasa mʉ”, yiyijʉ ĩ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ito yicõri fariseo gaye tʉoĩarãre, ado bajiro yiyijʉ Jesús: —“Tujacãra rʉmʉ moare ma”, yibojarãti moarãji mʉa. Tite. Sĩgʉ̃ mʉa macʉ, ito yicõri ecarʉ wecʉ ide gojejʉ ĩ quedi sãjaja, yoari mejeti ãmimorãji mʉa ĩre, tujacãra rʉmʉ ñabojarocati, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ito ĩ yija tʉocõri, no bajiro cʉdi masibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Barã ejari masa cumurori rʉ̃cʉbʉorajʉ riti ĩna ruji ãmoja ticõri, ado bajiro goti masioyijʉ Jesús ĩnare: ");
INSERT INTO myy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—Sĩgʉ̃ ãmo siare basa titoni ĩ jija, bʉto rʉ̃cʉbʉorajʉ meje rujiba mʉa. Bʉto rʉ̃cʉorajʉ mʉa rujija, gãji mʉa bero ñasari masʉ ĩ ejaja ticõri, mʉare oca cõari masʉ, ado bajiro yigʉ yiguĩji: “Baʉ wʉmʉña, ãnijʉa ñami ñasari masʉ, ĩjʉa mʉa godo rujijaro”, yigʉ yiguĩji. Ito bajiro ĩ yija tʉocõri, masa tiro riojo bojo bʉjarã yirãji mʉa, ĩ ito yija. Ito yicõri sʉsari cumurojʉ rʉ̃cʉbʉorajʉ meje masa tʉ rujirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ado bajirojʉa mʉa yija quena. Gãji mʉare oca cõaja bʉto rʉ̃cʉbʉorajʉ meje rujiba. Ito bajiro mʉa yija mʉare oca cõari masʉ, ado bajiro yigʉ yiguĩji: “Yʉ baba rʉ̃cʉbʉorajʉ bʉsa rujiya mʉ”, yigʉ yiguĩji ĩ mʉare. Ito bajiro mʉare ĩ yija, mʉa rãca gãna ti rʉ̃cʉbʉorã yirãji ĩna mʉare. ");
INSERT INTO myy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Masa rẽtoro ñasagʉ ña yʉ”, yigʉ, ñasari masʉ meje ĩ ñaroca yigʉ yiguĩji Dios ĩre. Gãjiama, “Gãjerã rẽtoro ñasagʉ ña yʉa”, yibicʉ, Ĩ ñasari masʉ ñaroca yigʉ yiguĩji Dios ĩre. Ito bajiri, “Gãjerã rẽtoro ñasagʉ ña yʉ”, yi tʉoĩabitirʉja manire, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ito yicõri ado bajiro yiyijʉ Jesús ĩre oca cõarʉre: —Gãjerãre mʉ ba roti ãmoja, mʉ baba mesa, mʉ ocabajirã, mʉ tʉ gãna, ito yicõri gajeoni jairãre, “Barã waya”, yibeja. Ĩnare riti mʉ jija, “Yʉre cʉni bare eca gãmejaro ĩna”, yigʉ bajiro ya mʉ. ");
INSERT INTO myy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ito bajiri ito bajiro tʉoĩabesa itire. Ado bajirojʉa mʉ yija quena. Gãjerãre, “Barã waya mʉa”, mʉ yi ãmoja bojoro bʉjarãjʉare mʉ jija quena. Ruduana, queno wa masimena, ito yicõri cajea timenare cʉni mʉ jija quena. ");
INSERT INTO myy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ito bajiro ĩnare yicõri queno wanʉ quenagʉ̃ yigʉja mʉ, “Yʉre waja yiado mama ĩna”, yirocʉ. “Diojʉa yʉre waja yigʉ yiguĩji ĩre tʉorʉ̃nʉrã tʉdi catiroca ĩ yiri rʉmʉ”, yi tʉoĩacõri wanʉgʉ̃ yigʉja mʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iti tʉocõri sĩgʉ̃ Jesús rãca ba rujigʉ, ado bajiro yiyijʉ: —No Dios rotirojʉ ba ejagʉ, wanʉ quenagʉ̃ yiguĩji, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mʉcana gaje goti masiore ocana ado bajiro gotiyijʉ Jesús ĩnare: —Co rʉmʉ sĩgʉ̃ basa bʉcʉ menigʉ̃ jãjarã masare, ji ñucayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Basa ñasʉoroca ĩre moa ĩsiri masʉre, “Masare jitẽña. Itocõ ña wajʉ ĩja”, yiyijʉ ĩ, ĩ ya moari masʉre. ");
INSERT INTO myy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ĩnare ĩ gotibojarocati, “Bʉjato bajia no masia ma gʉare. Wado ma gʉare, moare jaje ña”, yiyijarã ĩna. Sĩgʉ̃ ado bajiro yiyijʉ: “Canʉti sita cojʉ waja yibʉ yʉ. Ito bajiri itire tigʉ wacʉ ya yʉ”, yiyijʉ sĩgʉ̃ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gãji ado bajiro yiyijʉ: “Co dʉjamocõ babari wecʉa waja yibʉ yʉ. Ito bajiri ĩnana moaĩasʉogʉ wacʉ ya yʉ. Ito bajiri josabesa yʉre. Wado ma yʉ”, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gãjiama ado bajiro yiyijʉ: “Canʉti manojo bʉjabʉ yʉ. Ito bajiri wa masia ma yʉre”, yiyijʉ ĩ, ĩnare jigʉ ejabojarʉre. ");
INSERT INTO myy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ito bajiro ĩna yija tʉo tʉdi wacõri, ĩ ʉjʉre ñarocõti gotiyijʉ ĩ. Ito ĩ yija tʉocõri, ĩ ʉjʉ junisiniyijʉ. Ito bajiri gãjerãjʉare ji roti ñucayijʉ ĩ mʉcana ĩre. “Coji wasa cʉtojʉ, cʉri mari mʉtari mari cʉni warã mʉ ti bʉjaro bajiroti ãmi wadiba. Bojoro bʉjarã, ruduana, cajea mana, wa masimenare cʉni ãmi wadiba mʉ”, yiyijʉ ĩ ĩre moa ĩsiri masʉre. ");
INSERT INTO myy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ĩ ʉjʉ rotiro bajiroti yiyijʉ ĩ. Ito yi, ĩnare ãmi tʉdi ejacõri ĩ ʉjʉre gotiyijʉ: “Yʉ ʉjʉ mʉ rotiado bajiroti ya yʉ. Ito bajibojarocati mʉ ya wi masa dajabea maji”, yiyijʉ ĩ, ĩ ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ito yija ĩ ʉjʉ ado bajiro gotiyijʉ ĩre: “Cʉto tʉnima gãnare, masa mʉ bocaja bʉto adojʉ wadi rotiba, yʉ ya wi iti dajatoni. ");
INSERT INTO myy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cajero yʉ oca cõabojana, yʉ ya wi sãjacõri bamena yirãji ĩna, ya yʉ mʉre”, yiyijʉ ĩ ya moari masʉre. Ito bajiri Dios ñarojʉ mʉa eja ãmoja, mʉa ñaroti gaye riti tʉoĩabiticõri Diore riti mʉa tʉorʉ̃nʉ sʉyaja quena, yi oca goti masioyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Co rʉmʉ jãjarã masa Jesure sʉa wayijarã. Ito bajiro ĩna baji ñaroca ĩnare jʉda ticõri, ado bajiro yiyijʉ ĩnare: ");
INSERT INTO myy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Sĩgʉ̃ yʉ rãca ĩ riasoti ãmoja, ĩ jacʉsabatia, ĩ manojo, ĩ ria, ĩ ñarã rẽto bʉsaro maigʉ̃ yiguĩji yʉre. Ĩ queno catija, ĩ cõja cʉni yʉre maigʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ñeñaro tõbʉjagʉ yʉre ĩ tʉorʉ̃nʉbeja yʉ rãca riasotigʉ ñabiquĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ado bajirojʉa bajia. Ũmari wi mʉa meni ãmoja, mʉa meniroto riojʉa, “¿Waja tĩjacʉri seyoati?” yirona cõĩarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ito bajiro mʉa yibeja menisʉobojarãti mʉa tĩobeja, gãjerã mʉare ticõri ajarã yirãji. ");
INSERT INTO myy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ado bajiro yi ajarã yirãji ĩna mʉare: “Ãni ʉ̃mʉgʉ̃ ũmari wi menisʉobojagʉti tĩo masibeami”, yi ajarã yirãji ĩna mʉare. ");
INSERT INTO myy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Sĩgʉ̃ sita ʉjʉ, gaje sita gagʉ rãca ĩ gãmeri sĩa ãmoja, ĩna gãmeri cana mʉoroto riojʉa, ado bajiro tʉoĩagʉ̃ yiguĩji ĩ: “¿Yʉ ya surara diez mil ñarã, ĩ ñarã veinte mil ñarãre rẽtocũrã yirãjida ĩna?” yi tʉoĩagʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“Ĩnare rẽtocũado ma yʉ”, ĩ yija, gaje sita gagʉ sõjʉ ĩ tʉjaroca oca quenori masa cõagʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iti bajiroti, mʉa rʉcorise maicõri mʉa jidicã ãmobeja yʉ rãca riasoti masimenaji mʉa. Ito bajiri yʉre mʉa sʉyaroto riojʉa mʉa queno tʉoĩaja quena, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Moa iti ocaja quenarise ña. Iti ocabeja ñe waja manoja iti. ");
INSERT INTO myy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ocabitireama ñe yiya manoja. Ito bajiri itire cõacõrã yirãji masa, iti ocabejare. Ñe waja manoja itioni. Mʉa gãmo goje cʉtirã tʉo masiña. Yʉ sĩgʉ̃re mʉa tʉorʉ̃nʉbeja moa ocabiti waja mani robo bajiro ñarã yirãji mʉa. Ito bajiri yʉre mʉa sʉya ãmoja yʉre riti tʉorʉ̃nʉja quena, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jãjarã ʉjarãre yiari waja seni ĩsiri masa, ito yicõri ñeñaro yi jairã cʉni, Jesús tʉ minijua wayijarã ĩ bʉsija tʉorona. ");
INSERT INTO myy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ĩna rãca Jesús ĩ baba cʉtija ticõri, fariseo gaye tʉoĩarã, ito yicõri judio masa rotirise riasori masa cʉni Jesure bʉsituyijarã ĩna: —Ãni Jesús ñeñaro yirãre boca ãmiami. Ito yicõri ĩna rãca bami ĩ, yi bʉsituyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ĩna ito yija tʉocõri, ado bajiro oca goti masioyijʉ Jesús: ");
INSERT INTO myy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Mʉa wato sĩgʉ̃ cien oveja rʉcogʉ, sĩgʉ̃ ĩ wisaja, gãjerã noventa y nueve ñarãre wago cũgʉ̃ yiguĩji ĩ, gãji wisarʉre ãmagʉ̃ wacʉ. Ĩre ãma bʉjacõrijʉ sʉsagʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ĩre bʉjacõri wanʉgʉ̃, gãcojoejʉ gajagʉ yiguĩji ĩre. ");
INSERT INTO myy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ĩre bʉja tʉdi ejacõri ĩ baba mesare jicõri, ado bajiro yigʉ yiguĩji ĩ ĩnare: “Yʉ rãca wanʉña mʉa. Oveja godarʉre bʉjacõmʉ yʉ”, yigʉ yiguĩji ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sĩgʉ̃ ĩ ñeñaro yirise ĩ jidicãja ticõri, bʉto bʉsa wanʉrã yirãji ángel mesa. Jãjarã queno yirãre wanʉrã ñabojarãti sĩgʉ̃ ĩ ñeñaro yirise ĩ jidicãja ticõri, bʉto bʉsa wanʉrã yirãji ĩna, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Gaje ado bajiro ĩnare goti masioyijʉ Jesús: —Sĩgõ jʉa dʉjamocõ niyeru tiri rʉcocõri coti iso ruyurioja, sĩabusuoragʉ sĩagõ yigõji. Roariti iso ya wi tucãgõ yigõji. Iti cuji bʉjacõrijʉ ãmasʉsago yigõji iso. ");
INSERT INTO myy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iti cuji bʉjacõri iso baba mesare jigo yigõji iso. Ito yicõri ado bajiro yigo yigõji: “Yʉ rãca wanʉña. Niyeruti godarati bʉjacõmʉ yʉ”, yigo yigõji iso ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ito bajiroti ángel mesa cʉni bʉto wanʉrã yirãji, sĩgʉ̃ ĩ ñeñaro yirise ĩ jidicãja ticõri, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mʉcana ado bajiro ĩnare goti masioyijʉ Jesús: —Sĩgʉ̃ ñayijʉ jʉ̃arã rĩa cʉtigʉ. ");
INSERT INTO myy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ĩ macʉ, bero gagʉ ado bajiro yiyijʉ ĩ jacʉre: “Cʉna ija yʉ rʉcoroti gaye adocãtati ĩsiña yʉre”, yiyijʉ ĩ. Ito ĩ yija tʉocõri, ĩ rĩare, ĩna rʉcorotire ĩnare batoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ĩ batoja bero co rʉmʉ ĩ macʉ, bero gagʉ ĩ ya gajeoni miojuyijʉ. Ito yicõri sõjʉ gaje sitajʉ wayijʉ. Itojʉ ejacõri ñeñaro yicõri ĩ ya niyerure jeoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ito ĩ baji ñaroca iti sitajʉ bare queno mañijʉ. Ito bajijare ruje ñiocõsotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ito bajiri sĩgʉ̃ iti sita gagʉ tʉ moare ãmagʉ̃ wayijʉ. Moare ĩ bʉjaja bero, iti sita gagʉ ĩ ya yeseare code rotiyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ñiocõ wacʉ ĩna cõareti yesea ĩna bariseti ba ãmobojayijʉ. Ito ĩ bajibojarocati sĩgʉ̃jʉama ecabisijarã ĩre. ");
INSERT INTO myy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ito baji ñagʉ̃jʉ tʉoĩayijʉ ĩ ĩja: “Yʉ jacʉ ya moari masa jãjarã ñabojarocati ĩna ba rʉarise rʉyaroja ĩnare. Ito ĩna bajiroca yʉjʉama adojʉ ñiojoga godagʉ ya yʉ. ");
INSERT INTO myy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yʉ jacʉ tʉjʉ tʉdi wacʉ yigʉja yʉ. Ĩ tʉ ejacõri, ado bajiro ĩre yicʉja yʉ: ‘Cʉna ñeñaro mʉre yicʉ yʉ. Ito yicõri Dios ĩ tiro riojo cʉni ñeñaro yicʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ito bajiri, “yʉ macʉ”, mʉ yigʉõcʉ̃ meje ña yʉ. Mʉre moa ĩsiri masʉ bajiroti ñacʉja yʉ’, yigʉ yigʉja yʉ, yʉ jacʉre”, yi tʉoĩayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ito bajiro tʉoĩacõri ĩ jacʉ tʉ tʉdi wasʉoyijʉ ĩ. ’Sõjʉ ĩ tʉjaroca ĩ jacʉ ĩre ti bʉjacõri ĩre ti maiyijʉ. Ito bajiri ũmaquedi wacõri ĩre jababayijʉ ĩ. Ito yicõri ĩre wanʉgʉ̃ usuyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ĩ ito yijare ĩ macʉ ado bajiro yiyijʉ ĩre: “Cʉna ñeñaro mʉre yicʉ yʉ. Ito yicõri Dios ĩ tiro riojo cʉni ñeñaro yicʉ yʉ. Mʉ macʉ bajiro meje bajia yʉ ĩja”, yiyijʉ ĩ, ĩ jacʉre. ");
INSERT INTO myy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ito ĩ yibojarocati ĩre moa ĩsiri masare ji ñucacõri ado bajiro yiyijʉ ĩ: “Yutabuju quenarise ãmi wadicõri, sãña mʉa ĩre. Ito yicõri ãmo sãñara bedo, sãña. Ito yicõri gʉboco cʉni ĩre sãña. ");
INSERT INTO myy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wecʉ macʉ ri jaigʉre sĩaña mʉa. Ĩre bacõri basa meni, wanʉ quena yiana mani. ");
INSERT INTO myy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ãni yʉ macʉre ‘Godacoaguĩji’, yibojacʉ yʉ. Catiñi maji. ‘Wisa godacoañi’, yibojacʉ mani. Ĩre bʉjacõa mani”, yiyijʉ ĩ ĩre moa ĩsiri masare. Ito bajiro ĩ rotija tʉo wanʉcõri, basa gaye menisʉoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ito bajiro iti baji ñaroca wesecajʉ moagʉ̃ yiyijʉ ĩ macʉ ñasʉogʉ. Tʉdi wacʉ wi tʉ ĩna basaja tʉoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ito bajiro ĩna basa ñaja tʉocõri, sĩgʉ̃ moa ĩsiri masʉre ji ñucayijʉ, “¿No bajiati?” yirocʉ. ");
INSERT INTO myy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ĩ seniĩajare ado bajiro gotiyijʉ ĩ: “Mʉ ocabaji tʉdi ejacoami queno cati quenagʉ̃. Ĩ tʉdi ejajare wecʉ macʉ ri jaigʉre sĩa rotimi mʉ jacʉ”, yiyijʉ ĩ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ito bajiro ĩ gotija tʉocõri, junisiniyijʉ ĩ. Ĩ sãja ãmobeja ticõri, “Sãjaña mʉ”, yirocʉ ĩre jigʉ budi wayijʉ jacʉ. ");
INSERT INTO myy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ito bajiro jacʉ ĩ josaja ticõri, ado bajiro yiyijʉ ĩ, ĩ jacʉre: “Mʉ masia co rodo meje queno cʉdicõri moa ĩsibojacʉ yʉ. Ito yʉ yibojarocati sĩgʉ̃ cabra macʉ yʉre ĩsibiticʉ mʉ, yʉ baba mesa rãca basa yʉ menitoni. ");
INSERT INTO myy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ãni mʉ macʉ romia rãca niyeru aje baterʉreama ĩ ejaja ticõri, wecʉ macʉ jaigʉ sĩayija mʉa”, yiyijʉ ĩ, ĩ jacʉre. ");
INSERT INTO myy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ito ĩ yija tʉocõri, ĩ jacʉ ado bajiro yiyijʉ: “Yʉ macʉ, yʉ rãca riti ñacʉ mʉ. Ito bajiri yʉ rʉcorise jeyaro mʉ ye riti ña. ");
INSERT INTO myy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Adi rʉmʉri mʉ ocabaji ĩ tʉdi ejaja ticõri, basa menirʉja manire. Ito yicõri wanʉrʉja manire. ‘Godacoañi’, yi tʉoĩabojacʉ yʉ. Ito yʉ yibojarocati catiñi ĩ. Ito yicõri, ‘Wisa godacoañi’, yi tʉoĩabojacʉ mani. Ito mani yibojarʉreti bʉjacõa mani”, yiyijʉ ĩ, ĩ macʉ ñasʉorʉre. Ito bajiroti manire cʉni boca ãmigʉ̃ yiguĩji Dios. Sĩgʉ̃ ĩ ñeñaro yirise jidicãja ticõri, bʉto wanʉre rãca ĩre boca ãmigʉ̃ yiguĩji Dios, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mʉcana ĩ rãca riasotirãre ado bajiro yiyijʉ Jesús: —Sĩgʉ̃ ñayijʉ niyeru jaigʉ. Ito bajiri sĩgʉ̃re ĩ ya niyeru, ito yicõri ĩ ya moari masare cʉni tirʉ̃nʉ rotiyijʉ. Co rʉmʉ, “Mʉ ya niyeru mʉ tirʉ̃nʉ rotibojarʉ mʉ ya niyeru aje bategʉ yami”, yire gaye oca ejayijʉ ĩ ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ito bajiri, “¿Riti bajiati iti oca?” yirocʉ, ji ñucayijʉ ĩ ʉjʉ ĩre. Ĩ ejaja ticõri, ado bajiro yiyijʉ ĩre: “Mʉ moagore, ‘Ado bajiro moacʉ yʉ’, yiari gotiya mʉ yʉre. Ito bero yʉ rãca moabicʉ yigʉja mʉ ĩja. Ito bajiri yʉ rʉcorisere tirʉ̃nʉbicʉ yigʉja mʉ ĩja”, yiyijʉ ĩ ʉjʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ito ĩ yija tʉocõri, ado bajiro tʉoĩayijʉ ĩ, ĩre roti ĩsiri masʉ: “Yʉ ʉjʉ yʉre ĩ bucõaja, ¿no yicʉja yʉa? Weseri moare queno sẽobea yʉ. Gãjerãre bare yʉ seni ruji ucurotire bojo ña yʉ”, yi tʉoĩayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Yʉ ʉjʉ yʉre ĩ bucõaja, ado bajiro yʉ yijare ãmirã yirãji gãjerã yʉre”, yi tʉoĩayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ito bajiro tʉoĩacõri ĩ ʉjʉre waja ruyuriorãre jiyijʉ ĩ. Ĩna ejaja ticõri, ĩnare seniĩayijʉ: “¿Nocõ yʉ ʉjʉre waja ruyurioati mʉa?” yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Cien ʉ́yegari roa bare gaye waja ruyurioa yʉ ĩre”, yi cʉdiyijʉ sĩgʉ̃. Ito ĩ yija tʉocõri, ĩna ʉjʉre roti ĩsiri masʉre ado bajiro yiyijʉ: “Adocãta yoari mejeti cincuenta ʉ́yegari mʉre waja yigʉ ya yʉ”, yi wõña mʉ, yi rotiyijʉ ĩ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gãji ĩ ʉjʉre waja ruyuriogʉre, “¿Nocõ waja ruyurioati mʉ?” yi seniĩayijʉ. “Cien jibʉri trigo ajeri ĩre waja ruyurioa yʉ”, yiyijʉ ĩ. “Yoari mejeti ochenta jibʉri mʉre waja yicʉja yʉ”, yi wõña, yi rotiyijʉ ĩ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ito bajiro ĩ yija tʉocõri, “Queno yigʉ meje ñabojagʉti tʉoĩa masigʉ̃ ñami ĩ”, yi tʉoĩayijʉ ĩ ʉjʉ ĩre, yi oca gotiyijʉ Jesús ĩ rãca riasotirãre. Ito bajiro tʉoĩama adi macãrʉcʉ̃ro gaye bʉto tʉoĩarã. Adi macãrʉcʉ̃ro gaye bʉto tʉoĩarã, masare rʉocõri waja bʉja masiama ĩnaõna. Yʉre tʉorʉ̃nʉrãma ito bajiro yibeama ĩna. “Waja bʉja masiana mani”, yi tʉoĩacõri bʉto rʉo masirã ñama adi macãrʉcʉ̃ro gaye tʉoĩarã, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ado bajirojʉa mʉa yija quena yʉ tija. Adi macãrʉcʉ̃ro gaye mʉa rʉcorisena gãjerãre ejabʉaya, queno mʉare ĩna baba cʉtitoni. Ito bajiro ĩnare mʉa yija, ũmacʉ̃jʉ catitĩñadojʉ mʉa ejaroca mʉare boca ãmirã yirãji ĩna, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’No jabetacã rʉcogʉ yiro robo ĩ yija, jairo ĩ rʉcobojaja cʉni ito bajiroti queno yigʉ ñatĩñagʉ̃ yiguĩji ĩocʉ̃. No jabetacã rʉcogʉ yiro robo yibicʉ, ĩ jairo rʉcobojaja cʉni, yiro robo yigʉ meje ñagʉ̃ yiguĩji ĩocʉ̃ama. ");
INSERT INTO myy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Adi macãrʉcʉ̃ro gaye gajeoni jaje rʉcobojarãti yiro robo mʉa yibeja, ũmacʉ̃jʉ gaye quenarise Dios ĩ cõarise cʉni boca ãmimena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Gãjerã ye gajeoni queno mʉa tirʉ̃nʉbeja mʉa ye ñarotire cʉni queno tirʉ̃nʉmena yirãji mʉa. Ito bajiri queno mʉare ĩsibicʉ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Cocati mani ʉjarã jʉ̃arãre cʉdi masibea mani. Jʉ̃arã ĩna ñaja sĩgʉ̃re queno ti maicõri, gãjire ti tudirã yirãji mani. Sĩgʉ̃re queno cʉdirã yirãji mani. Gãjire queno cʉdimena yirãji mani. Iti robo bajiroti Diore mani cʉdija, niyerujʉare bʉto tʉoĩamenaji mani. Niyerure riti mani bʉto tʉoĩaja Diore queno cʉdisabea mani, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ito bajiro Jesús ĩ bʉsija, fariseo gaye tʉoĩarã tʉo rujiyijarã. Ĩna ñayijarã niyerure bʉto mairã. Ito bajiri Jesure aja tudiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ito bajiro ĩna aja tudi rujija ticõri, ado bajiro yiyijʉ Jesús ĩnare: —Masa ĩna tiro riojo riti, “Queno yirã ña gʉa”, yiboja mʉa. Ito bajiro mʉa tʉoĩabojarise masicõguĩji Diojʉama. “Ñasarise ña”, masa ĩna yi tʉoĩabojarise, ñasarise meje ña, Dios ĩ tija, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Juan masare ĩ riasoroto riojʉa, Dios ĩ rotirise, ito yicõri ĩre goti ĩsiri masa ĩna ucare gaye riti ñayijʉ maji masa ĩna tʉoroti. Ito bero adi rʉmʉriama, “No ĩre tʉorʉ̃nʉrãreti ĩ rotirojʉ miojugʉ yiguĩji Dios”, yi riasore gaye ña ĩja. Jãjarã ado bajiro tʉoĩabojarãji mʉa: “Yʉrioti ado bajiro yʉ yija Dios ĩ rotirojʉ ejagʉ yigʉja yʉ”, yi tʉoĩabojarã jãjarã ñama, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Adi tuti adi macãrʉcʉ̃ro cʉni coji jedibetoja. Ito yicõri Dios ĩ rotirise cʉni jedibeto yiroja. Ñatĩñaroti ña Dios ĩ rotirise, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Sĩgʉ̃ ĩ manojo ñasʉogo rãca isore jidicãcõri gajeo rãca ĩ manojo cʉtibojaja isore ajegʉ yiguĩji ĩocʉ̃. Ito yicõri ĩ cõarore gãji ĩ manojo cʉtija, iso rãca ajegʉ yiguĩji ĩocʉ̃ cʉni, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mʉcana gaje ado bajiro gotiyijʉ Jesús ĩnare: —Sĩgʉ̃ niyeru jaigʉ quenarise yutabujuri sãñagʉ̃ ñayijʉ. Co rʉmʉ rʉyabeto ĩ ãmoro bajiro ĩ ya niyerure aje batesotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ito ĩ baji ñaroca sĩgʉ̃ Lázaro wame cʉtigʉ ñayijʉ bojoro bʉjagʉ. Bʉto rujʉri cami cʉtigʉ ñayijʉ ĩ. Ito bajicõri niyeru jaigʉ ya, soje tʉ macʉ̃jʉ rujiyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Niyeru jaigʉ ĩ bagorise barocʉ, ito rujibojayijʉ Lázaro. Ito ĩ rujiroca yaia ejacõri, ĩ ya camire weroyijarã. ");
INSERT INTO myy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Co rʉmʉ bojoro bʉjagʉ godayijʉ. Ĩ godarocati, ángel mesa ãmi wayijarã ĩre Abraham tʉ Diore tʉorʉ̃nʉrã ĩna ñarojʉ. Ito bero niyeru jaigʉ cʉni godacoayijʉ ĩja. Ito bajiri ĩre yujeyijarã masa. ");
INSERT INTO myy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Diore tʉorʉ̃nʉbicʉ ñari ñeñaro yigoana ĩna ñarojʉ ejacõri bʉto tõbʉjayijʉ niyeru jaigʉ ñabojarʉ. Ito bajiro tõbʉja ñagʉ̃ sõjʉ Abraham ñayorʉre ti bʉjayijʉ ĩ. Ito bajiri Lázaro ĩ rãcajʉ ĩ ñaja ti bʉjayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ito bajiri ado bajiro oca sẽoro bʉsibojayijʉ ĩ: “Ñicʉ Abraham yʉre ti maiña mʉ. Adojʉ jeame ʉ̃jʉrojʉ ñeñaro tõbʉja yʉ. Ito bajiri Lázarore cõaña, ĩ ya ãmo wãsoa ide yicõri yʉ ya ñemero ide weogʉ wadijaro. Ito yija jabeto tujari seyoa yʉ”, yibojayijʉ ĩ Abrahamre. ");
INSERT INTO myy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ito ĩ yibojarocati ado bajiro cʉdiyijʉ Abraham ĩre: “Tʉoya yʉ janami mʉ. Catigʉ queno ñacãcʉ mʉáma. Lázaroreama ĩ catibojaja queno ejabiticʉ. Ito bajiri adojʉ queno ñagʉ̃ yami ĩ. Mʉáma ñeñaro tõbʉjagʉ ya mʉ itojʉ. ");
INSERT INTO myy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mani watojoe ũmari goje eyari goje ña. Ito bajiri no yi masia ma manire”, yiyijʉ ĩ, niyeru jaigʉ ñabojarʉre. ");
INSERT INTO myy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ito bajiro ĩ yija tʉocõri, ado bajiro cʉdiyijʉ ĩ: “Tʉoya yʉ ñicʉ mʉ. Lázaro ado ĩ eja masibeja, cʉna tʉjʉ wajaro. ");
INSERT INTO myy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Itojʉ ñarãji yʉ ñarã, yʉ ocabaji mesa. Co dʉjamocõ ñarãji ĩna. Ĩnare gotigʉ wajaro ĩ, ado ñeñaro tõbʉjarajʉjʉ ĩna ejabe yirocʉ”, yiyijʉ ĩ Abrahamre. ");
INSERT INTO myy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ito ĩ yija tʉocõri, ado bajiro yiyijʉ Abraham: “Moisés ñayorʉ ĩ ucayore, ito yicõri Diore goti ĩsiri masa ĩna ucare ñacã ĩnare. Itijʉa tʉorʉ̃nʉrʉja ĩnare”, yiyijʉ Abraham ĩre. ");
INSERT INTO myy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Meje ñicʉ, sĩgʉ̃ godana wato gagʉ wacõri ĩ gotija tʉocõri, ñeñaro ĩna yirise jidicãrã yirãji ĩna”, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ito ĩ yija tʉocõri: “Moisés ñayorʉ ĩ gotire gaye ito yicõri Diore goti ĩsiri masa ĩna ucare gaye ĩna tʉorʉ̃nʉbeja, godarã wato ñagʉ̃ mʉcana caticõri ĩ gotibojaja, tʉorʉ̃nʉmena yirãji ĩna ĩre cʉni”, yiyijʉ Abraham niyeru jaigʉ ñabojarʉre. Ito bajiri Dios ñaro mʉa eja ãmoja catirãti ñeñaro mʉa yirise jidicãcõri Diore tʉorʉ̃nʉña, yi gotiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Mʉcana tʉdi bʉsigʉ ado bajiro yiyijʉ Jesús ĩ rãca riasotirãre: —Co rʉmʉ rʉyabeto mani ñeñaro yitoni ʉsirioro yi codeami rʉ̃mʉ́. Mani ñeñaro yitoni ʉsirioro yigʉ ñeñaro tõbʉjagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jane yʉre tʉorʉ̃nʉsʉorã ñeñaro ĩna yiroca yigʉ, ñeñaro tõbʉjagʉ yiguĩji ĩ. Ito bajiri ĩ ya ãmʉmajʉ gʉ̃tagã rʉ̃cʉricã sia yocõri riaca jajosajʉ rucõaja quena ĩre. ");
INSERT INTO myy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Itire queno tʉoĩa masiña mʉa. ’Sĩgʉ̃ mʉa yagʉ ñeñaro ĩ yija, “Dios tiro riojo queno yibea mʉ”, yiba ĩre. Ito bajiro mʉa yija tʉocõri, ĩ ñeñaro yirise ĩ jidicãja, “Mʉ ñeñaro yirisere ãcabojoa gʉa”, yiba ĩre. ");
INSERT INTO myy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Co rʉmʉre jʉa ãmojenocõ mʉare ñeñaro sĩgʉ̃ ĩ yija, “Mʉare ñeñaro yibʉ yʉ”, ĩ yija tʉocõri, “Mʉ ñeñaro yirisere ãcabojoa gʉa”, yiba ĩre, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Co rʉmʉ ado bajiro yiyijarã Jesús rãca riasotirã ĩre: —Mʉre tʉorʉ̃nʉa gʉa. Ito bajibojarocati bʉto bʉsa gʉa mʉre tʉorʉ̃nʉroca yiya, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ĩna ito yija: —Jabetacã yʉre mʉa tʉorʉ̃nʉja, jaibiti aje mostaza aje robo bajiro yʉre mʉa tʉorʉ̃nʉja, mʉa rotiro bajiroti bajiroja. Ito bajiri, yucʉgʉ Sicómoro wame cʉtiricʉre ado bajiro roti masirãji mʉa: “Mʉmasiti rudu wacõri itajura gʉdarecojʉ rʉ̃gõña”, yi rotirãji mʉa. Ito bajiro mʉa rotiro bajiroti yiroja itigʉ yucʉgʉ, yʉre mʉa tʉorʉ̃nʉja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","9","Gaje ado bajiro gotiyijʉ Jesús ĩnare: —Sĩgʉ̃ mʉare moa ĩsiri masʉ ovejare tirʉ̃nʉcõri ĩ tʉdi ejaja, mʉa riojʉajʉa basʉobiquĩji. Ado bajiro ĩre rotirã yirãji mʉa: “Bare meni ĩsiña gʉare. Ito yicõri gʉa ba rujiroca gʉare codeya mʉ. Gʉa ba tĩoja berojʉa mʉ baja quena”, yi rotirã yirãji mʉa. “Iti ña yʉ ya moare”, yi tʉoĩacõri mʉa rotiro bajiroti yigʉ yiguĩji. Ito bajibojarocati biyaro goroama, “Queno ya mʉ”, yimena yirãji mʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ito bajiroti mʉa cʉni Dios ĩ rotirisere cʉdibojarãti, “Ñasarã meje ña mani. Mani ʉjʉ ĩ ñaja cʉdirʉja manire. Ititi ña, mani ya moare”, yirʉja mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalénjʉ wacʉ Galilea sita rẽtacõri, Samaria sitajʉ ejayijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Iti sita, cʉto ĩ ejaroca jʉa dʉjamocõ ʉ̃mʉa wadicõri sõ bʉsajʉ tujayijarã. Rujʉ cami jogarã ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ado bajiro yi awasãyijarã ĩna Jesure: —Jesús gʉa Ʉjʉ, gʉare ti maiña, yi awasãyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ĩnare ticõri ado bajiro yiyijʉ Jesús: —Wasa paiare, mʉa ya rujʉri ĩotẽña, yiyijʉ ĩ ĩnare. Ito ĩ yijare wayijarã ĩna. Ĩna wasʉorocati ĩna ya cami yaticoayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sĩgʉ̃ ĩna rãca gagʉ ĩ ya cami yatija ticõri: “Yʉre queno yami Dios. Rẽtoro masigʉ̃ ñami Dios”, yi tʉdi wayijʉ ĩ Jesús tʉjʉare. ");
INSERT INTO myy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesús tʉ ejacõri rijomunigãna ñini rũjũyijʉ ĩ. Ito yicõri ĩ ya rio sitajʉ muquea ruji wayijʉ, “Queno ya mʉ”, yirocʉ. Judio masʉ meje ñayijʉ ĩ. Samaria sita gagʉjʉa ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ĩ ejaja ticõri, ado bajiro yiyijʉ Jesús ĩre: —Jʉa dʉjamocõ cami cʉtirãre yisiobʉ yʉ. ¿Nojʉ ñati gãjerã mʉ rãca gãna? ");
INSERT INTO myy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Mʉ Samaria sita gagʉ sĩgʉ̃ti, “Queno yami Dios”, yirocʉ gotigʉ wadiri mʉ? yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ito yicõri gaje ado bajiro yiyijʉ ĩ: —Wʉmʉña, wasa. “Jesús yʉre yisiogʉ yiguĩji”, yi mʉ tʉoĩajare, mʉ ya cami yaticoajʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Co rʉmʉ fariseo gaye tʉoĩarã, ado bajiro yi seniĩayijarã Jesure: —Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ Dios ĩ miojuri rʉmʉ, ¿nocãta ejaro yirojada? yi seniĩayijarã ĩna Jesure. Ĩna ito yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Ĩre tʉorʉ̃nʉrãre Dios ĩ miojuja, masa jeyaro recoti mani tiriseoni meje ñaroja. ");
INSERT INTO myy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Diore tʉorʉ̃nʉrã mʉa ñaja, mʉa ya ʉsijʉ ñacãguĩji ĩja. Ito bajiri, “Recoti ado ña. Õjʉ ña ĩ rotiro”, yi masiña ma, mani ya ʉsijʉ ĩ ñajare, yiyijʉ Jesús fariseo gaye tʉoĩarãre. ");
INSERT INTO myy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ĩnare ĩ bʉsija bero ĩ rãca riasotirãre, ado bajiro yiyijʉ Jesús: —Yʉ ña Dios Macʉ, Masa Rĩjorʉ. Co rʉmʉ yʉre ti ãmobojarã yirãji mʉa. Ito bajibojarãti yʉre ti bʉjamena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Ado ñami Jesús”, ĩna yija, “Õ ñaguĩji gajea Jesús”, yibojarã yirãji masa mʉare. Ito bajiro ĩna yija ĩna rãca sʉya wabeja. Macʉ yigʉja yʉ itojʉ. ");
INSERT INTO myy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ũmacʉ̃jʉ gaye bʉjo borea yirise iti busu bataja masa jeyaro tirã yirãji. Ito bajiroti bajiro yiroja Masa Rĩjorʉ ñacõri, yʉ tʉdi ejari rʉmʉ. Masa jeyaro tirã yirãji ĩna, yʉ ito bajija. ");
INSERT INTO myy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Iti riojʉa adojʉ ñagʉ̃, bʉto ñeñaro tõbʉjagʉ yigʉja yʉ. Iti rʉmʉri masa tirã yirãji yʉre. ");
INSERT INTO myy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé ñayorʉ ĩ catiroca masa Diore rʉ̃cʉbʉobitiyoñi. Ito bajiro bajirã yirãji masa, yʉ Masa Rĩjorʉ yʉ tʉdi ejari rʉmʉ. ");
INSERT INTO myy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé ñayorʉ ĩ ñaroca masa idirãtibe, barãtibe, manojo cʉtirãtibe ito yicõri ĩna rĩa romiare manʉjʉ bosarãtibe yi ñayijarã ĩna. “Manire ruyuriobiquĩji Dios”, yi tʉoĩa ñayijarã ĩna. Ito bajiro ĩna baji ñabojaroca riti, cumajʉ sãjayijʉ Noé ñayorʉ. Cumajʉ ĩ sãjaja bero rujayijʉ. Ito bajiri ñarocõti goda jedicoayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ito bajiroti rẽtayijʉ Lot ñayorʉ ĩ ñaroca cʉni. Ĩ ñajacʉ ĩ ñaroca ado bajiro bajiyijarã ĩna. Barã, idirã, waja gãmerã, gãjerãre ĩsirã, ito yicõri wiri meni ñacõayijarã ĩna. “Manire ruyuriobiquĩji Dios”, yi tʉoĩa ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ito bajiro ĩna baji ñaroca ĩna ñari cʉto Sodoma wame cʉtiri cʉtore budigoyijʉ Lot. Lot iti cʉto ĩ budigoja bero ũmacʉ̃jʉ gaye jea azufre wame cʉtirise queoyijʉ Dios. Ito yicõri gʉ̃ta ʉ̃jʉrise cʉni queoyijʉ. Ito bajiri ñarocõti ʉa jedicoayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ito bajiroti bajiro yiroja, yʉ Masa Rĩjorʉ yʉ goaĩori rʉmʉ cʉni. Ito bajiro yʉ goaĩori rʉmʉ Diore rʉ̃cʉbʉorã meje ñarã yirãji masa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Yʉ tʉdi ejari rʉmʉ sĩgʉ̃ wi rijogodo ĩ bʉa ñaja, ĩ ya gajeoni ãmigʉ̃ ruji wabitirʉjaguĩji ĩ. Ito yicõri sĩgʉ̃ ĩ ya weseca ĩ moaroca yʉ tʉdi ejaja, ĩ ya gajeoni ãmigʉ̃ wacʉ tʉdi wabitirʉjaguĩji ĩ cʉni. ");
INSERT INTO myy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot manojo ñayorore bajire gaye tʉoĩaña mʉa. Iso ya gajeonire tʉoĩa jidicã ãmobisijo iso. Ito bajiri godayijo iso. ");
INSERT INTO myy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","No ĩ catirise maibojagʉti godagʉ yiguĩji. Ito bajibojarocati yʉre tʉorʉ̃nʉgʉ̃, yʉ oca ĩ gotija tʉo junisinicõri, ĩna sĩagʉ̃ama catitĩñare gaye bʉjagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Co rʉmʉ yʉ ejari rʉmʉ jʉ̃arã ĩna caniroca ejagʉ yigʉja yʉ. Jʉ̃arã ĩna canibojarocati sĩgʉ̃re ãmigʉ̃ yiguĩji Dios. Ito yicõri gãjire rʉacõgʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Romia jʉ̃arã coro tʉ oe rujirã yirãji. Ĩna ito bajibojarocati sĩgõre ãmigʉ̃ yiguĩji Dios. Ito yicõri gajeore rʉacõgʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jʉ̃arã ʉ̃mʉa wesecajʉ moa ñarã yirãji. Ito bajibojarocati sĩgʉ̃re ãmigʉ̃ yiguĩji Dios. Gãjire rʉacõgʉ̃ yiguĩji, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ito bajiro ĩ yija tʉocõri, ado bajiro ĩre seniĩayijarã ĩna: —¿Nojʉ rẽtaro yirojada iti? yi seniĩayijarã ĩna mani Ʉjʉre. Ado bajiro goti masiore ocana cʉdiyijʉ Jesús ĩnare: —Rujʉ jogarise iti ñaro itojʉ minijuarã yirãji yuca. No masa ĩna ñeñaro yirojʉ, ito bajiro rẽtaro yiroja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Diore bʉsi jidicãmenati bʉto bʉsa oca sẽojaro yirocʉ, ado bajiro goti masiore ocana gotiyijʉ Jesús ĩnare: ");
INSERT INTO myy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Cʉtojʉ ñayijʉ sĩgʉ̃ oca quenori masʉ. Diore güibisijʉ, ito yicõri masare cʉni rʉ̃cʉbʉobisijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Iti cʉtojʉ sĩgõ ñayijo manʉjʉ godagoro. Coji meje oca quenori masʉ tʉ ejasotibojayijo iso, “Mʉ rãca oca cʉtigʉjʉare seti ña”, ĩ yitoni. ");
INSERT INTO myy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Biyaro iso ejasotibojarocati, isore boca ãmibisijʉ oca quenori masʉ. Biyaro iso ejaja ticõri, ado bajiro tʉoĩayijʉ ĩ. “Yʉ isore tirʉ̃nʉbeja biyaro ejasotigo yigõji iso. Ito yicõri bogagʉ yigʉja yʉ. Ito bajiri Diore güibitibojagʉti, masare cʉni rʉ̃cʉbʉobitibojagʉti isore ejabʉacʉja yʉ, yʉre iso ʉsirioro yi rẽtocũme yirocʉ”, yi tʉoĩayijʉ oca quenori masʉ, yi oca gotiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ito yicõri mʉcana mani Ʉjʉ ado bajiro gotiyijʉ: —Ñeñaro yigʉ ñabojagʉti isore bogagʉ ejabʉayijʉ oca quenori masʉ. ");
INSERT INTO myy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Dios ñarãre ʉ̃mʉa, ñami cʉni ĩna josaja, ĩnare tirʉ̃nʉbiquĩjida? ¿Ito yicõri yoari ĩnare ejabʉabiquĩjida? ");
INSERT INTO myy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ado bajirojʉa mʉare ya yʉ. Yoari mejeti ĩnare ejabʉagʉ yiguĩji. Yʉ Masa Rĩjorʉ adi sitajʉ tʉdi ejagʉ yigʉja mʉcana. ¿Adojʉ yʉ tʉdi ejaroca yʉre tʉorʉ̃nʉrã ñarã yirãjida maji? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","“Gãjerã rẽtoro queno yirã ña gʉa”, yi tʉoĩacõri, gãjerãre ti tudirãre ado bajiro oca goti masioyijʉ Jesús ĩnare: ");
INSERT INTO myy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Co rʉmʉ ʉ̃mʉa jʉ̃arã Dios ya wijʉ Diore bʉsirã wayijarã. Sĩgʉ̃ ĩ rãca gagʉ fariseo gaye tʉoĩagʉ̃ ñayijʉ. Gãji ʉjarãre yiari waja seni ĩsisotiri masʉ ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo gaye tʉoĩagʉ̃ rʉ̃gõcõri, ado bajiro Diore bʉsiyijʉ: “Gãjerã bajiro bajigʉ meje ña yʉ. Riniri masʉ meje ña yʉ. Ñeñaro yiri masʉ meje ña yʉ. Gãji manojo rãca ajegʉ meje ña yʉ. Ito yicõri ãni bajiro bajigʉ meje ña yʉ. Ĩ ñami ʉjarãre yiari waja seni ĩsiri masʉ. Ĩre bajiro bajigʉ meje ñacõri, ‘Queno ya Dios mʉ’, ya yʉ. ");
INSERT INTO myy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Co semana rʉyabeto jʉa rʉmʉ mʉre rʉ̃cʉbʉogʉ babicʉ riti bʉsisotia yʉ mʉre. Ito yicõri jeyaro yʉ bʉjarise jabeto mʉre ĩsisotia yʉ”, yi bʉsiyijʉ ĩ Diore. ");
INSERT INTO myy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ito bajiro ĩ yiroca ʉjarãre yiari waja seni ĩsiri masʉama bojori bʉjagʉ jacajʉa riti ti wa rʉ̃gʉ̃coayijʉ. Bʉto bojori bʉjacõri soje tʉjʉ tujayijʉ ĩ. Diore ado bajiro bʉsiyijʉ ĩ: “Dios yʉre ti maiña. Ñeñaro yi jaigʉ ña yʉ”, yiyijʉ ĩ, yi gotiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Ado bajiro mʉare gotia yʉ. Ʉjarãre yiari waja seni ĩsiri masʉ, ito bajiro Diore ĩ bʉsija, ñeñaro ĩ yirisere ãcabojoyijʉ Dios. Ito bajibojarocati fariseo gaye tʉoĩagʉ̃reama ĩ ñeñaro yirise ãcabojobisijʉ Dios. No, “Gãjerã rẽtoro ñasarã ña gʉa”, yibojarãre ĩna ñasamena ñaroca yigʉ yiguĩji Dios. Ito yicõri, “Ñasarã meje ña gʉa”, yirãreama, ñasarã ĩna ñaroca yigʉ yiguĩji Dios, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ĩna rĩare Jesús ĩ moaĩatoni ãmi ejayijarã masa ĩ tʉjʉ. Ito bajiro rĩacare ĩna ãmi ejaja ticõri, “Ãmi wadibesa”, yiyijarã Jesús rãca riasotirã. ");
INSERT INTO myy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ito bajiro ĩna yija tʉocõri, ado bajiro yiyijʉ Jesús: —Rĩacare rẽobesa, yʉ tʉ wadijaro ĩna. Rĩaca ñama yʉre queno tʉorʉ̃nʉrã. Ĩna robo yʉre queno tʉorʉ̃nʉrãre riti ĩ rotirojʉ miojugʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Riti mʉare gotia yʉ. Rĩaca queno cʉdi ãmoama Dios ĩ rotirisere. No rĩaca ĩna cʉdiro bajiro cʉdi ãmobicʉti Dios ĩ rotirojʉ ejabiquĩji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sĩgʉ̃ judio masa ʉjʉ Jesure ado bajiro seniĩayijʉ: —Yʉ Ʉjʉ queno yigʉ, ¿no bajiro yicõri catitĩñare gayere bʉjagʉ yigʉjada yʉ? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ito bajiro ĩ yija tʉocõri: —¿No yija queno yigʉ yati mʉ yʉre? Sĩgʉ̃ ñami queno yigʉ. Ĩti ñami Dios. ");
INSERT INTO myy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dios ĩ rotirise masigʉ̃ ña mʉ: “Gãji manojo rãca ajebitirʉja mʉ. Gãjire sĩabitirʉja mʉ, rinibitirʉja, gãjerãre rʉo gotibitirʉja, ito yicõri mʉ jacʉsabatiare rʉ̃cʉbʉorʉja mʉ”, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ito bajiro ĩ yija ado bajiro cʉdiyijʉ ĩ Jesure: —Ñarocõti itire macʉacã ñagʉ̃jʉ cʉdisʉocʉ yʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ito ĩ yija ado bajiro cʉdiyijʉ Jesús: —Jabeto rʉya maji queno Diore mʉ cʉdi jeoroti. Ñarocõti mʉ cʉdi jeo ãmoja, ado bajiro yiya. Jeyaro mʉ rʉcorise gãjerãre ĩsi jeocõña. Ito yicõri iti waja bʉjacõri bojoro bʉjarãre ĩsiña. Ito bajiro mʉ yija, ũmacʉ̃jʉ queno bʉjagʉ yigʉja mʉ. Ito bajiri yʉ gotirise cʉdiya. Ito yicõri yʉ rãca waya, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ito bajiro Jesús bʉsija tʉocõri, bʉto bojori bʉjayijʉ ĩ. Gajeoni jaigʉ ñacõri itire bʉto maiyijʉ. Ito bajiri Jesús bʉsire tʉocõri bojori bʉjagʉti wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ĩ bojori bʉjaja ticõri, ado bajiro yiyijʉ Jesús ĩ rãca riasotirãre: —Niyeru jairã Dios ĩ rotirojʉ josari bero ejarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gawa jotaga yuta jiosõrajʉre, camello queno sãja masibiquĩji. Iti robo bajiroti Dios ĩ rotirojʉ queno eja masisabiquĩji niyeru jaigʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ito bajiro ĩ yija tʉocõri, ado bajiro yiyijarã ĩna: —¿Ito yija noajʉa Dios ĩ ñarojʉ ejarã yirãjida? Riti mʉ yijama sĩgʉ̃ ejabiquĩji gajea, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ĩna ito yija tʉocõri, ado bajiro yiyijʉ Jesús mʉcana: —Masamasiti yiado ma itire. Dios sĩgʉ̃ti jeyaro yi masiguĩji. Ñejʉa josarise manoja ĩre, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ito bajiro ĩ yija tʉocõri, ado bajiro yiyijʉ Pedro Jesure: —Gʉa Ʉjʉ, mʉ rãca warona jeyaro gʉa rʉcorisere jidicãcʉ gʉa, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Ito yija Jesujʉama ado bajiro cʉdiyijʉ: —Riti ya yʉ mʉare. “Dios ñami mani Ʉjʉ”, yi goti ucurona, ĩna ya wi, ĩna jacʉsabatia, ĩna manojosãromia, ito yicõri ĩna rĩare cʉni ĩna cũ waja, queno waja bʉjarã yirãji ĩna. Ito yicõri ũmacʉ̃jʉ Dios tʉjʉ catitĩñarã yirãji ĩna, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ito ĩ yija bero jʉa gʉbojeno ñarã, ĩ rãca riasotirãre ricati bʉsa ji wayijʉ Jesús ĩnare bʉsirocʉ. Ito yicõri ado bajiro yiyijʉ ĩ ĩnare: —Adocãta Jerusalénjʉ warã ya mani. Itojʉ mani ejaroca jane mejejʉ Diore goti ĩsiri masa ĩna ucado bajiroti rẽtaro yiroja Masa Rĩjorʉre. ");
INSERT INTO myy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gaje masa ĩre ĩna ñiatoni, mani masati ĩre oca menirã yirãji. Ĩre ñiacõri aja tudirã yirãji ĩna. Ito yicõri ĩre tiborã yirãji ĩna. Ĩre go ide eobate gurã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ĩre jarã yirãji ĩna. Ito yicõri ĩre sĩarã yirãji. Ĩre ĩna sĩabojarocati ʉdia rʉmʉ bero godana wato ñabojagʉti mʉcana tʉdi catigʉ yiguĩji ĩ, yiyijʉ Jesús ĩnare, ĩre rẽtaroti gaye tʉoĩa yugʉ. ");
INSERT INTO myy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ito bajiro ĩ gotibojarocati tʉo masibisijarã ĩna. “Iti gayere bʉsiguĩji”, yi masibisijarã ĩna. Ito bajiri ĩ bʉsirise queno tʉo masibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó ejagʉ wagʉ ĩ yiroca ma tʉ sĩgʉ̃ cajea macʉ rujiyijʉ. Ito ma tʉ rujicõri masa ĩre ti maitoni masare josayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jãjarã masa ĩna rẽtaja tʉocõri, “¿No bajiati?” yirocʉ seniĩayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ito ĩ yija: —Jesús Nazaret gagʉ rẽtagʉ̃ wagʉ yami, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ĩna ito yija tʉocõri, awasãyijʉ ĩ: —Jesús, David ñayorʉ janerãbatia janami, yʉre ti maiña mʉ, yi awasãyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ĩre rẽtasʉorã, “Awasãbesa mʉ”, yibojayijarã ĩna ĩre. Ito yibojarocati bʉto bʉsa awasãyijʉ ĩ: —David ñayorʉ janerãbatia janami yʉre ti maiña mʉ, yi awasãyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iti tʉocõri tuja rʉ̃gʉ̃yijʉ Jesús. Ito yicõri, “Cajea tibicʉre ãmitẽña”, yi ñucayijʉ. Ĩ tʉ ĩ ejagʉ wagʉ yiroca, ado bajiro seniĩayijʉ Jesús cajea macʉre. ");
INSERT INTO myy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿No bajiro mʉre yʉ yire ãmoati mʉ? yiyijʉ ĩ ĩre. —Yʉ Ʉjʉ mʉcana tʉdi cajea ti ãmoa yʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ito ĩ yija tʉocõri: —Mʉcana tiya mʉ. “Jesús yʉre yisiogʉ yiguĩji”, mʉ yi tʉoĩajare, tʉdi mʉ cajea tiroca ya yʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ito ĩ yirocati cajea macʉ ñabojarʉ ticoayijʉ ĩja. Ito yicõri Jesús rãca wacʉ, “Bʉto rẽtoro masigʉ̃ ñami Dios”, yi wanʉ quena wayijʉ ĩ. Jãjarã masa ito bajiro iti rẽtaja ticõri, “Queno yigʉ ñami Dios”, yi wanʉ quena wayijarã ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ito yija bero Jericójʉ ejayijʉ Jesús ĩja. Ito yicõri iti cʉtojʉ wa ucuyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Iti cʉto gagʉ sĩgʉ̃ niyeru jaigʉ ñayijʉ, Zaqueo wame cʉtigʉ. Ʉjarãre yiari waja seni ĩsiri masa ʉjʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ĩ Zaqueo Jesure bʉto ti ãmoyijʉ. Ito bajibojarocati ũmabicʉ ñari, masa ĩna jãjarã ñajare Jesure ti bʉjabisijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ito bajiri masa riojʉa ũmaquedi wacõri, ma tʉ rʉ̃gõricʉre Sicómoro wame cʉtiricʉre mʉja jeayijʉ Zaqueo Jesús ĩ rẽtaja tirocʉ. ");
INSERT INTO myy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ito rẽta wacʉ ti mʉocõri ado bajiro yiyijʉ Jesús Zaqueore: —Zaqueo coji ruji waya mʉ. Jane mʉ ya wi tuja ãmoa yʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jesús ito bajiro ĩ yija tʉocõri, ejoriti ruji wayijʉ ĩ. Ito yicõri wanʉre rãca Jesure boca ãmicõri, ĩ ya wijʉ ãmi wayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Zaqueo rãca Jesús ĩ waja ticõri, ĩre bʉsituyijarã masa. “Ñeñaro yi jaigʉ ya wi tujagʉ wami”, yirona bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ĩ ya wijʉ Jesús ĩ ñaroca, ado bajiro yiyijʉ Zaqueo Jesure: —Yʉ Ʉjʉ, tite mʉ. Bojoro bʉjarãre gʉdarecona yʉ rʉcorisere ĩnare ĩsi batogʉ yigʉja yʉ. Yʉ rʉo ãmigoanare jʉariajiricõ ĩnare jʉdacõagʉ̃ yigʉja yʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ito ĩ yija tʉocõri, ado bajiro yiyijʉ Jesús: —Mʉ ñeñaro yirise mʉ jidicãja ticõri, mʉ ñarãre, mʉre cʉni masogʉ̃ yiguĩji Dios, ya yʉ mʉre. Ñeñaro yigʉ ñari mʉ ñicʉ Abraham ñayorʉ Diore ĩ rʉ̃cʉbʉoado bajiro yibiticʉ mʉ maji. ");
INSERT INTO myy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mʉre bajiro jeame ʉ̃jʉrojʉ waboanare masori masʉ wadia yʉ. Yʉ ña Masa Rĩjorʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ito bajiro Jesús ĩ yi ñaroca ĩ bʉsirise tʉo ñayijarã masa. “Yoari mejeti Jerusalénjʉ mani ejaja beroti, ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojusʉogʉ yiguĩji Dios”, yi ĩna tʉoĩabojarisere masicõyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ito bajiri goti masiore ocana ado bajiro yiyijʉ Jesús ĩnare: —Sĩgʉ̃ ñasari masa rãca gagʉ ñayijʉ. Sõjʉ gaje sitajʉ wayijʉ ĩ, “Mʉ ya sita ʉjʉ ñama mʉ”, gãji ĩre yitoni. ");
INSERT INTO myy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ĩ waroto riojʉa jʉa dʉjamocõ ĩre moa ĩsiri masare jiyijʉ ĩ. Sĩgʉ̃ rʉyabeto ĩnare niyeru tiri bʉto waja cʉtirise ĩsiyijʉ ĩ. Ito yicõri ado bajiro rotiyijʉ ĩ ĩnare: “Ito yʉ waroca riti adi niyeruna moacõri jai bʉsaro niyeru bʉja ĩsiña mʉa yʉre”, yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ĩ ya sita gãna ti teyijarã ĩre. Ito bajiri ĩ beroti masa cõayijarã ĩna. “Ãni gʉa ʉjʉ ñare ãmobea gʉa”, ĩna yi gotitoni ĩnare cõayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ito bajiro ĩna yibojarocati gaje sita gagʉ ʉjʉ ĩre wame yiyijʉ. “Mʉ ya sita ʉjʉ ñama”, ĩ yija bero, ĩ ya sitajʉ tʉdi wayijʉ ĩ mʉcana. Itojʉ tʉdi ejacõri, ĩ ya moari masare jiyijʉ ĩ. “¿Yʉ niyeru cũ warena, nocõ jairo niyeru bʉja remoyijari ĩna?” yirocʉ, ĩnare jiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ĩna ejaja ticõri, cajero gagʉre seniĩasʉoyijʉ ĩ: “¿Nocõ jairo niyeru bʉja remori mʉ?” yiyijʉ ĩ ĩre. Ito ĩ yija tʉocõri: “Yʉ ʉjʉ mʉ ya niyeruna jʉa dʉjamocõti mʉcana tʉdi bʉja remomʉ yʉ”, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ito yija tʉocõri, ado bajiro cʉdiyijʉ ĩ ʉjʉ ĩre: “Queno yiyija mʉ. Queno yʉre moa ĩsigʉ̃ ña mʉ. Jabetacã yʉ mʉre rotija, ñaro bajiroti yʉre cʉdiyija mʉ. Ito bajiri jʉa dʉjamocõ cʉtori tirʉ̃nʉrocʉre cũa yʉ mʉre”, yiyijʉ ĩ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ĩ bero gãji ado bajiro yiyijʉ ĩ ʉjʉre: “Yʉ ʉjʉ, mʉ ya niyeruna co dʉjamocõti bʉja remomʉ yʉ”, yiyijʉ ĩ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ito ĩ yija tʉocõri, ado bajiro yiyijʉ ĩ ʉjʉ: “Mʉ yʉre queno cʉdire waja co dʉjamocõ cʉtori tirʉ̃nʉgʉ̃ ya mʉ”, yiyijʉ ĩ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ĩ bero gãji mʉcana ĩ tʉ ejayijʉ. “Yʉ ʉjʉ, ado ña mʉ ya niyeru. Resurona gũmacõri seocʉ yʉ itire. ");
INSERT INTO myy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉre tʉo güicʉ yʉ. Oca sẽogʉ̃ ña mʉ. Gãjerã ĩna otebojareti ẽmagʉ̃ ña mʉ. Ito yicõri gãjerã ĩna bʉjaboreti ẽmagʉ̃ ña mʉ. Ito bajiri mʉre masicõri mʉre tʉo güicʉ yʉ”, yiyijʉ ĩ, ĩ ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ito bajiro ĩ yija tʉocõri, ado bajiro yiyijʉ ĩ ʉjʉ: “Yʉre queno moa ĩsigʉ̃ meje ña mʉ. Janeti yʉre mʉ bʉsigorisenati, mʉre sẽoro yigʉ ya yʉ. ‘Sẽoro yigʉ ña mʉ. Ito yicõri gãjerã ya otere ẽmagʉ̃ ña mʉ. Ito yicõri gãjerã ye ñaboreti ẽmagʉ̃ ña mʉ’, yiyija mʉgo yʉre. ");
INSERT INTO myy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ito bajiro yi masibojagʉti, ¿no yija yʉ ya niyerure jai bʉsaro bʉja remora wijʉ cũbiticati mʉ? Mʉcana yʉ ya wijʉ tʉdi ejacõri jai bʉsaro niyeru ti tʉdi eja ãmobojacʉ yʉ”, yiyijʉ ĩ ʉjʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ito yicõri gãjerã itijʉ ñanare ado bajiro rotiyijʉ ĩ: “Ĩ rʉcoriti niyerutire ẽmaña mʉa. Ito yicõri jʉa dʉjamocõ rʉcogʉre ĩsiña mʉa”, yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ĩ ito yija tʉocõri: “Tite gʉa ʉjʉ. Jʉa dʉjamocõ niyeru ñacã ĩre”, yiyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ito yija ĩna ʉjʉ ado bajiro cʉdiyijʉ: “Tite. Ado bajiro mʉare gotia yʉ. No yʉre queno moa ĩsigʉ̃re jai bʉsaro ĩre ĩsi remogʉ̃ yigʉja yʉ. Ito bajibojarocati no queno yʉre moa ĩsibicʉreama ĩ rʉcoriseacãti ẽma jeocõcʉja yʉ. Ĩre ẽmacõri gãji yʉre queno moa ĩsigʉ̃re ĩsigʉ̃ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ito yicõri ʉjʉ yʉ ñare ãmobitianare, adojʉa ãmi waya ĩnare. Ito yicõri, yʉ tiro riojo ĩnare sĩaña”, yiyijʉ ʉjʉ ĩ ya moari masare. Ito bajiri iti oca tʉocõri Diore mani queno moa ĩsija quena, yi oca goti masioyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ito ĩ yija bero, Jerusalénjʉ wayijʉ Jesús mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ĩ waro riojo Olivos wame cʉtiri tʉria ñayijʉ. Iti tʉria jʉdo jʉa cʉto ñayijʉ. Betfagé, ito yicõri Betania wame cʉtiri cʉtori ñayijʉ iti. Ĩ ejaroto riojʉa jʉ̃arã ĩ rãca riasotirãre cõayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ado bajiro yiyijʉ ĩ ĩnare: —I cʉtojʉ wasa. Ito ejacõri burro, ĩna sia rʉ̃gõgʉ̃re bʉjarã yirãji mʉa. Sĩgʉ̃ masʉ mʉja jeaĩaña macʉ ñaguĩji maji. Ĩre õjacõri ãmi wadiba. ");
INSERT INTO myy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sĩgʉ̃ mʉare ĩ seniĩaja: “¿No yirã ĩre õjati mʉa?” ĩ yija, ado bajiro gotiba ĩre: “Mani Ʉjʉ ĩre ãmoami”, yiba ĩre, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ito ĩ yija tʉocõri, wayijarã ĩna. Ito ejacõri Jesús ĩ gotiado bajiroti bʉjayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burrore ti bʉjacõri õjayijarã ĩna. Ĩre ĩna õjaroca ado bajiro seniĩayijarã ĩ ʉjarã: —¿No yija ĩre õjati mʉa? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ĩna ito yija tʉocõri: —Mani Ʉjʉ ĩre ãmoami. Ito bajiri ĩre õja gʉa, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ito yicõri Jesús tʉjʉ ĩre ãmi wayijarã ĩna ĩja. Jesús tʉ ejacõri ĩna ya yutabuju ruacõri burro joe jidi jeoyijarã ĩna. Ito yicõri Jesús ĩ mʉja jeatoni ĩre ejabʉayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ĩ joe jesa wayijʉ Jesús ĩja. Ito bajiro ĩ jesa waroca jãjarã ĩna ya yutabujuri ruacõri ĩ waro riojo eyocũ yuyijarã ĩna. “Gʉa Ʉjʉ ña mʉ”, yirona ito bajiro yiyijarã masa, ĩre rʉ̃cʉbʉorã. ");
INSERT INTO myy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ito bajiro wacʉjʉ tʉria jʉdo ejayijʉ, Jerusalén roja wara majʉ. Ito ĩ ejaroca ĩre rʉ̃cʉbʉorã ado bajiro yi awasã wanʉyijarã masa: “Rẽtoro quenagʉ̃ ñami Dios. Jaje tiyamani manire ĩoami”, yi awasã wanʉyijarã ĩna, Diore rʉ̃cʉbʉorã: ");
INSERT INTO myy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Quenarise ñajaro mani Ʉjʉre. Ĩ ñami Dios ĩ cũrʉ. Ũmacʉ̃jʉ gãna cʉni wanʉ quenare rãca ñajaro ĩna. Masa jeyaro Diore queno rʉ̃cʉbʉojaro, yiyijarã ĩna Jesure wanʉrã. ");
INSERT INTO myy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jesure sʉyarã ĩna rãca ñabojayijarã fariseo gaye tʉoĩarã cʉni. Masa ĩna ito bajiro wanʉ bʉsija tʉocõri, Jesure ado bajiro yiyijarã ĩna: —Gʉare riasogʉ, ito bajiro mʉre bʉsi sʉyarãre, “Bʉsibesa mʉa”, yiya, yiyijarã fariseo gaye tʉoĩarã Jesure. ");
INSERT INTO myy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ito bajiro ĩna yibojarocati: —Riti ado bajiro mʉare gotia yʉ. Yʉre ĩna awasã wanʉbeja, masa ĩna awasã wanʉro bajiro gʉ̃ta cʉni awasã wanʉro yiroja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ito bajiro wacʉti Jerusalénjʉ ticõyijʉ ĩ. Iti cʉto gãnare tʉoĩacõri otiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tʉoĩa oticõri ado bajiro yiyijʉ Jesús: —Wanʉ quenatĩñare bʉja masibojarãti ãmobisijarã ĩna. Ito bajiri adocãta bʉja masiña ma ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Quenabiti rʉmʉri ejaro yiroja ĩnare. Ito bajiri ĩna wajana rujabedo ĩnare camotarã yirãji. Ito yicõri cojʉ rʉyabeto camotarã yirãji ĩnare sĩarona. ");
INSERT INTO myy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ito bajiro yicõri ĩnare ruyurio jeorã yirãji. Ito yicõri ĩnare sĩarã yirãji. Ĩnare sĩacõri ĩna cʉto Jerusalénre dara baterã yirãji ĩna. Ito bajiri ĩna camotabojare gʉ̃ta ñarocõti quedicoaro yiroja. Ito bajiro rẽtaro yiroja, ĩnare Dios boca ãmi ãmobojarocati ĩna ãmobitire waja, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ito bajiro Jerusalénjʉ ejacõayijʉ Jesús ĩja. Ito bajiro ejacõri Dios ya wijʉ sãjayijʉ ĩ. Ito sãjacõri waja gãmeri masare ti bʉjayijʉ Jesús. Ĩnare ti bʉjacõri ĩnare bucõayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ito yicõri ado bajiro yiyijʉ ĩ: —Dios oca tuti ado bajiro gotia: “Yʉre rʉ̃cʉbʉorona yʉ ya wi sãjarã yirãji masa”, yi gotia Dios oca tuti. Mʉa ito bajiro niyeru gãmeri waja yija, riniri masa ĩna rudirijʉ robo bajiro ya mʉa, yi tudiyijʉ Jesús waja gãmeri masare. ");
INSERT INTO myy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jerusalén ñagʉ̃ co rʉmʉ rʉyabeto Dios ya wijʉ masare riasosotiyijʉ Jesús. Ito bajibojarocati paia ʉjarã, judio masa rotirise riasori masa, ito yicõri cʉto ʉjarã cʉni ti tujabisijarã ĩna. Ito bajiri ado bajiro yi tʉoĩayijarã ĩna: “ ‘Ĩre seti ña’, mani yija, ĩre sĩarã yirãji mani”, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ito bajibojarocati masama Jesure wanʉcõri bʉto bʉsa ĩre tʉorʉ̃nʉyijarã ĩnama. Ito bajiri, “Seti ña ĩre”, yi masibisijarã ʉjarã mesa. ");
INSERT INTO myy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Co rʉmʉ Dios ya wijʉ masare riaso ñayijʉ Jesús. Masare Dios ĩ masore gayere ĩnare riaso ñayijʉ Jesús. Ito bajiro ĩ riaso ñaroca paia ʉjarã ejayijarã. Ito yicõri judio masa rotirise riasori masa, judio masa bʉcʉrã cʉni ejayijarã. ");
INSERT INTO myy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jesús tʉ ejacõri ado bajiro seniĩayijarã ĩna: —¿Waja gãmeri masare mʉ bucõaja ñimʉ rotirisena ĩnare bucõati mʉ? Ito yicõri, ¿ñimʉ mʉre cũcati ito bajiro mʉ yitoni? yi seniĩayijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ĩna ito yija tʉocõri: —Yʉ cʉni mʉare ado bajiro seniĩa yʉ. Cʉdiya mʉa cʉni yʉre. ");
INSERT INTO myy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ñimʉ masare Juan ĩ idé gutoni cõayijari? ¿Dios ĩre cõayijarite? ¿Masa ĩre cõayijarite? yi seniĩayijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ito bajiro ĩ yija tʉocõri, ĩnamasiti gãmeri tʉoĩa bʉsiyijarã ĩna: —¿No bajiro ĩre cʉdirʉjati mani? “Dios cõayijʉ ĩre”, mani yija, “¿No yija ito bajibojarocati ĩre tʉorʉ̃nʉbiticati mʉa?” yigʉ yiguĩji ĩ manire, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“ ‘Masa cõarʉ ñami Juan’, mani yija, masa manire junisinicõri gʉ̃tagãna manire rea sĩarã yirãji. ‘Diore yiari bʉsiñi Juan’, yi tʉoĩacõri gʉ̃tagãna rea sĩarã yirãji ĩna manire”, yi tʉoĩa gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ito bajiro tʉoĩacõri ado bajiro cʉdiyijarã ĩna Jesure: —“Ĩ ñañi masare idé gutoni cõarʉ”, yi masibea gʉa, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ĩna ito yija tʉocõri: —“Ĩ rotirisena ya yʉ”, yi gotibicʉja yʉ cʉni, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ito yicõri masare bʉsisʉoyijʉ Jesús mʉcana. Ado bajiro goti masiore ocana gotiyijʉ Jesús ĩnare: —Sĩgʉ̃ ñayijʉ ʉyé wese, rʉcogʉ. Gaje sita yoari warocʉ ĩ ya ʉyé wesere gãjerã moari masare wasoayijʉ ĩ. Ito yicõri yoari gaje sitajʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ʉyé iti rica cʉtiroca sĩgʉ̃ ĩ ya moari masʉre cõayijʉ ĩ, ĩ ya ote ãmitoni. Iti ote coderi masa ĩ wadija ticõri, ĩre jaĩosãcõyijarã ĩna. Ito bajiri ñe macʉti tʉdi wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ito bajiro ñe macʉti ĩ ejaja ticõri, gãji ĩre moa ĩsiri masʉre cõayijʉ ĩ. Iti ote coderi masa ĩ ejaja ticõri, ĩre tiboyijarã ĩna. Ito yicõri jaĩosãcõyijarã ĩna. Ito bajiri ĩ cʉni ñe macʉti tʉdi wayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ĩ ito bajija ticõri, gãjire cõayijʉ mʉcana. Ĩ ejaja ticõri, ito bajiroti ĩre cʉni jaĩosãcõyijarã ĩna mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Iti jeyaro bajija ticõri, ado bajiro tʉoĩayijʉ iti sita ʉjʉ: “¿No bajiro yirʉjati yʉ? Ado bajiro yicʉja yʉ. Yʉ macʉ, yʉ maigʉ̃re cõagʉ̃ ya yʉ. Ĩre ĩna tija rʉ̃cʉbʉorã yirãji gajea”, yi tʉoĩabojayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ĩ macʉ ejaja ticõri, ado bajiro ĩnamasi gãmeri tʉoĩa bʉsiyijarã ĩna, ote coderi masa: “Ãni ñami adi sita ʉjʉ ĩ godaja bero boca ãmirocʉ. Ĩre sĩacãcõrʉja, manijʉa bʉjana yirona”, yi tʉoĩa gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ito bajiri ĩre tucõa wacõri sĩayijarã ĩna, yi oca goti masioyijʉ Jesús masare. Ito yicõri ado bajiro ĩnare seniĩayijʉ Jesús: —Ĩna ito bajiro yija, ¿no bajiro yigʉ yiguĩjida iti sita ʉjʉ? ");
INSERT INTO myy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ado bajirojʉa yigʉ yiguĩji. Ote coderi masa tʉ ejacõri ĩnare sĩagʉ̃ yiguĩji. Ito yicõri ĩ ya sita gãjerãre wasoagʉ yiguĩji. Dios cʉni ito bajiroti yigʉ yiguĩji. No ĩ cõarʉre boca ãmimenareti ruyuriogʉ yiguĩji Dios, yiyijʉ Jesús ĩnare. Ito bajiro ĩ yija tʉocõri, ado bajiro yiyijarã ĩna: —Iti ito bajiro rẽtame yirocʉ camotajaro Dios, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ĩnajʉare ticõri ado bajiro yiyijʉ Jesús: —¿Ñe yireoni ñati adi Dios oca tuti gaye mʉa tʉoĩaja? Gʉ̃ta wi meniri masa coga gʉ̃tagã cõayijarã ĩna. Ito bajibojarocati gaje gʉ̃ta rẽto bʉsaro quenarica ñayijʉ itiga ĩna cõabojaraga. Itiga gʉ̃tagãna sʉoriti quenari wi menigʉ̃ yiguĩji Dios. Itiga gʉ̃tagã manija, ñe menire manoja ĩja, yi gotia Dios oca tuti. ");
INSERT INTO myy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","No gʉ̃tagã joe quedi jeagʉre ĩ ya gõari jearo yiroja. Ito yicõri itiga gʉ̃tagã sĩgʉ̃re iti quedi jeaja mano abocõro yiroja. Ado bajiro bajia iti oca. No Dios ĩ cõarʉre tʉorʉ̃nʉbicʉ catitĩñabicʉ yiguĩji ĩocʉ̃. Ito yicõri jeame ʉ̃jʉrojʉ ĩ cõa ãmorãre ruyuriorocʉ cõagʉ̃ yiguĩji ĩ, yi gotiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ito bajiro Jesús ĩ oca goti masioja tʉocõri, “Manireti bʉsiami”, yi tʉo masiyijarã paia ʉjarã, judio masa rotirise riasori masa cʉni. Ito bajiri Jesure ñia ãmoyijarã ĩna. Ito bajibojarocati masare güirã ñia masibisijarã ĩna maji. ");
INSERT INTO myy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ĩre ñia masibiticõri coriarã Jesús rãca baba cʉti rʉoronare cõayijarã ĩna: “Titẽña. Sita ʉjarãre ĩ bʉsituja tʉoba. Ĩ bʉsituja tʉocõri, ‘Ĩre seti ña’, yirã yirãji mani. Ito yicõri adi sita ʉjʉ tʉjʉ ĩre ãmi warã yirãji mani”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jesús rãca baba cʉti rʉoana ĩ tʉ ejacõri, ado bajiro ĩre gotiyijarã ĩna: —Gʉare riasogʉ, jeyaro mʉ riasorise, mʉ bʉsirise riti ñasarise ña, yi tʉoĩa gʉa. Masa ñasari masa, ñasamenare cʉni corocõti ti maia mʉ. Dios ĩ ãmoro bajiro masa ĩna yitoni, queno riasoa mʉ. ");
INSERT INTO myy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ito bajiri ado bajiro mʉre seniĩa gʉa: “¿Roma cʉto gagʉ ʉjʉre ĩ rotiado bajiroti ĩre gʉa waja yija quenati? ¿Ĩre gʉa waja yibeja cʉni quenatite?” yi seniĩayijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ito bajiro ĩna yibojarocati ĩna ñeñaro tʉoĩarisere tʉo masicõyijʉ Jesús. Ito bajiri ado bajiro yiyijʉ ĩ ĩnare: ");
INSERT INTO myy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Adi sita gaye niyeru cuji ĩsiña yʉre, yiyijʉ Jesús. Iti cuji niyeru cuji boca ãmicõri ado bajiro seniĩayijʉ Jesús ĩnare: —¿Ñimʉ ya rio ito yicõri ñimʉ wame wãñati adi cujijʉ? yi seniĩayijʉ Jesús ĩnare. Ito ĩ yija tʉocõri: —Adi sita ʉjʉ rioti ña, ito yicõri ĩ wame cʉni, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ĩna ito yija ado bajiro cʉdiyijʉ Jesús ĩnare: —Sita ʉjʉ gaye iti ñajama ĩreti ĩsija quena. Ito yicõri Dios ye iti ñaja Diore ĩsija quena, yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ito bajiro queno Jesús ĩ cʉdija tʉocõri, masa tʉoro riojo oca meni masibisijarã ĩna. Ĩ queno cʉdi masija ticõri, mano ʉcayijarã ĩna. Ito bajiri ĩre oca meni ãmobojarãti bʉsibisijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ito ĩ baji ñaroca coriarã saduceo gaye tʉoĩarã, Jesure ti ãmorã ejayijarã. Saduceo gaye tʉoĩarã, “Godabojarãti mʉcana tʉdi catire manoja”, yi tʉoĩarã ñayijarã ĩna. Ito bajiri ado bajiro Jesure seniĩayijarã ĩna: ");
INSERT INTO myy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Gʉare riasogʉ, Moisés ñayorʉ ado bajiro ucayoñi: “Rĩjorʉ ñasʉogʉ rĩa macʉti manojore ĩ godagoja ĩ ocabaji manojo cʉti wasoaja quena. Ito bajiro yigʉti ĩ rĩjorʉ ñabojarʉre rĩa cʉti ĩsigʉ̃ yiguĩji”, yi ucañi Moisés ñayorʉ, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gaje ado bajiro gotiyijarã ĩna Jesure: —Mʉre oca gotia gʉa. Sĩgʉ̃ rĩa ado bajiro rẽtayijarã. Jʉa ãmojeno ñayijarã ĩna. Ñasʉogʉ manojo cʉtibojagʉti rĩa macʉti godagoyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ĩ bero gagʉ manʉjʉ godagoro rãca manojo cʉtibojayijʉ. Ĩ cʉni rĩa macʉti godagoyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ito yicõri ĩna bero gagʉ cʉni manʉjʉ godagoro rãca manojo cʉtibojayijʉ. Ĩ cʉni rĩa macʉti godacoayijʉ. Ĩ bero gãna cʉni isore manojo cʉticõri, rĩa manati goda jediyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ĩna goda jedija berojʉ goda sʉyayijo ĩna manojo ñabojaro cʉni. ");
INSERT INTO myy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Ũmacʉ̃jʉ mʉcana tʉdi ĩna catija ñimʉ manojojʉa ñasagõjida ĩna jeyaro manojo iso ñaja bero? yi seniĩayijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ito yija Jesús ado bajiro cʉdiyijʉ ĩnare: —Adi tutijʉ masa ĩna ñaja, manojo cʉti, manʉjʉ cʉti yama ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Adi tutijʉ ito bajiro ĩna yi ñabojarocati mʉcana tʉdi caticõri, Dios tʉjʉ ĩna ejaja manojo cʉtire manoja itojʉama. Ito yicõri ĩna rĩa romiare manojo cʉti rotimenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dios rĩa ñari mʉcana tʉdi catirã yirãji ĩna. Ito yicõri jʉaji godamenaji ĩna. Ángel mesa robo bajiro bajirã yirãji ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gaje Moisés ñayorʉ ĩ ucare ticõri, “Godana mʉcana tʉdi catirã yirãji”, yi tʉoĩa mani. Yucʉ tutu ʉ̃jʉrise wato Dios oca ruyurisere ucayoyijʉ Moisés. Ado bajiro gotiyijʉ Dios Moisésre: “Yʉ ña Abraham ʉjʉ, Isaac ʉjʉ, ito yicõri Jacob ʉjʉ cʉni”, yiquĩ Dios yʉre, yi ucayijʉ Moisés ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Iti oca tʉocõri, “Godana Ʉjʉ meje ñami Dios. Catirã Ʉjʉjʉa ñami”, yi tʉoĩa mani. Godana ñabojarãti Dios ĩ tija catirã riti ñarãji masa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ito ĩ yija tʉocõri, judio masa rotirise riasori masa, ado bajiro yiyijarã ĩna: —Queno ñaro bajiroti tʉo masia, gʉa Ʉjʉ mʉ, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ito yicõri queno masigʉ̃ ĩ ñajare ñejʉa gaje seniĩa ʉya masibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ito bero ado bajiro ĩnare seniĩayijʉ Jesús: —¿No yija, “David ñayorʉ janerãbatia janami ñami Cristo”, yati masa? ");
INSERT INTO myy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David ñayorʉ ĩmasiti, Salmos wame cʉtiri tutijʉ ucagʉ ado bajiro yiñi: Yʉ Ʉjʉre ado bajiro yiñi Dios: “Yʉ ya riojocadʉja rʉ̃cʉbʉorajʉ, rujiya mʉ. ");
INSERT INTO myy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mʉ wajanare mʉ rẽtocũroca yigʉ yigʉja yʉ”, yiñi Dios yʉ Ʉjʉre, yi ucayoñi David. ");
INSERT INTO myy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿No yija, “Yʉ Ʉjʉ ñami Cristo”, yiyijari David ñayorʉ? Cristo David janerãbatia janami ñacõri, ¿no bajiro David ʉjʉ bajiyijari Cristo? Ĩ janerãbatia janami ĩ ñaja, “Yʉ Ʉjʉ”, yibitiborʉ David ñayorʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ĩ rãca riasotirãre, Jesús ĩ bʉsi ñaroca jãjarã masa tʉo ñayijarã. Ado bajiro yiyijʉ Jesús ĩnare: ");
INSERT INTO myy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Judio masa rotirise riasori masa bajiro mʉa yibe yirona queno tʉoĩaña mʉa. Tite. Ado bajiro yama ĩna. Yutabujuri quenarise yoarise sãñacõri masa ĩna tiro riojo wa ucu ãmorãji ĩna. Ito yicõri cʉto gʉdareco gãjire ĩna canamʉoja, rʉ̃cʉbʉore rãca seniĩare ãmorãji ĩna. Minijuara wijʉ sãjacõri rʉ̃cʉbʉora cumuro ruji ãmorãji ĩna. Ito yicõri basari rʉmʉ cʉni ñasari masa tʉ riti ba ruji ãmorãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Manʉjʉ godagoana romiare cʉni ĩna ya wiri ẽmarãji ĩna. Ito yicõri masa ĩna tiro riojo yoari Diore bʉsirãji ĩna. “Queno yirã ñama ĩna”, masa yi tʉoĩajaro yirona yoari Diore bʉsirãji ĩna. Ito bajiro ĩna yija quenabetoja. Ito bajiri ñeñaro ĩna yirise waja, waja yirã bʉto bʉsa quenabeto tõbʉjarã yirãji ĩna. Ĩnare bajiro mʉa yibe yirona queno tʉoĩaña mʉa, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dios ya wijʉ Jesús ĩ ñaroca masa Diore yiari niyeru ĩna sãri jedore ĩna niyeru sãja ti codeyijʉ ĩ. Ito bajiri niyeru jairãre cʉni ĩna sãja tiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ito yicõri manʉjʉ godagoro bojoro bʉjago ñabojagoti jʉati niyeruti waja mani iso sãja tiyijʉ Jesús. Cobre ñayijʉ iso sãrise. ");
INSERT INTO myy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ito bajiro iso yija ticõri, ado bajiro yiyijʉ Jesús: —Riti mʉare gotia yʉ. Niyeru jairã rẽto bʉsaro ĩsiamo adio bojoro bʉjago. ");
INSERT INTO myy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ĩna niyeru jairã jaje rʉcocõri rẽtarisere ĩsiama ĩna. Iso bojoro bʉjagoama ñarocõti, iso rʉcobojariseti ĩsiamo, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ado bajiro bʉsiyijarã coriarã, Dios ya wire ti tʉoĩacõri: —Queno seyo quenari wi ña adi wi. Adi wi gʉ̃ta quenarisena ĩna menira wi ña. Ito yicõri jãjarã Diore yiari iti wire rʉ̃cʉbʉorã, iti wi ñarotire ĩsiñi ĩna, yiyijarã ĩna. Ĩna ito yija tʉocõri, ado bajiro yiyijʉ Jesús: ");
INSERT INTO myy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Co rʉmʉ ado jeyaro mʉa ti ñabojarise gãjerã ruyuriorã yirãji. Ito bajiri adi wi gaye gʉ̃tagã gajega joe jesabeto yiroja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ito ĩ yija ado bajiro seniĩayijarã ĩna ĩre: —Gʉare riasogʉ, ¿nocãta rẽtaro yirojada iti gʉare mʉ bʉsirise? ¿no bajiro ti masicõri, “Ito bajiro rẽtaro ya”, yi masirã yirãjida gʉa? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ito bajiri Jesús ado bajiro yiyijʉ: —Queno tʉoĩaña mʉa, gãjerã ĩna mʉare rʉobe yirona. Jãjarã mʉare rʉorona ejarã yirãji ĩna. “Yʉti ña Cristo”, yirã yirãji ĩna. Ito yicõri, “Adi rʉmʉriti ña, sʉsari rʉmʉri”, yi rʉorã yirãji ĩna. Ito bajiri ĩnare tʉorʉ̃nʉbeja mʉa. ");
INSERT INTO myy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Masa ĩna gãmeri sĩarise gaye mʉa tʉoja, ito yicõri ʉjarãre, masa ĩna queno tʉo ãmobeja, ĩna oca meni ãmoja cʉni güibeja mʉa. Ito bajiro rẽtaro yiroja cajero sʉsari rʉmʉ iti ejaroto riojʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ito yicõri mʉcana ado bajiro goti remoyijʉ: —Co masa ñabojarãti gãmeri sĩarã yirãji ĩna. Ito yicõri co sita gãna gaje sita gãna rãca gãmeri sĩarã yirãji. ");
INSERT INTO myy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Co cʉto meje sita bʉto ʉero yiroja. Ñiocõrã yirãji masa. Ñarise ñaro yiroja. Ito yicõri ũmacʉ̃jʉ gaye guijorise tiyamani goaĩoro yiroja. ");
INSERT INTO myy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Iti jeyaro rẽtaroto riojʉa, yʉre tʉorʉ̃nʉrã mʉa ñajare mʉare ñiarã yirãji. Ito yicõri mʉa tõbʉjaroca yirã yirãji ĩna. Minijuara wijʉ ʉjarã riojo, “Ãnare seti ña”, yirona mʉare ãmi warã yirãji ĩna. Yʉre tʉorʉ̃nʉrã mʉa ñajare tubiara wijʉ mʉare cũrã yirãji ĩna. Masa ʉjarã, sita ʉjarã riojo cʉni, “Ĩnare seti ña”, yirona ãmi warã yirãji ĩna mʉare. ");
INSERT INTO myy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ito bajiro mʉare ĩna yija, “Jesure rʉ̃cʉbʉorã ña gʉa”, yi gotirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Mʉare seti ña”, ĩna yija, “Ado bajiro cʉdiana mani”, yi tʉoĩa ʉsiriobeja. ");
INSERT INTO myy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mʉa queno cʉdi masitoni tʉo masire gaye mʉare jidicãgʉ̃ yigʉja yʉ. Ito bajiri queno mʉa bʉsi masijare, mʉa wajana sĩgʉ̃jʉa mʉare bʉsi rẽtocũ yimena yirãji. ");
INSERT INTO myy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mʉa jacʉsabatia, mʉa baba mesa, mʉa ñarã, ito yicõri mʉa co masi, mʉare gãjerã ñiatoni gotirã yirãji. Ito yicõri mʉa coriarãre sĩarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ito yicõri yʉre tʉorʉ̃nʉrã mʉa ñajare masa jeyaro mʉare ti tudirã yirãji. ");
INSERT INTO myy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Queno mʉare tirʉ̃nʉgʉ̃ yigʉja yʉ. Ito bajiri cora joara godabeto yiroja mʉare. ");
INSERT INTO myy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yʉre mʉa tʉorʉ̃nʉrise mʉa jidicãbeja catitĩñarã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mʉcana ado bajiro goti remoyijʉ Jesús: —Jerusalénjʉ surara ĩna gãni biaja tʉocõri, “Nocõ mejeti adi cʉtore ruyuriorã wana yama”, yi tʉoĩarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ito bajiri Judea sita gãna, gʉ̃ta yucʉrijʉ rudirʉjarãji ĩna. Ito yicõri Jerusalén cʉtojʉ ñarã, iti cʉtore budigorʉjarãji ĩna. Ito yicõri joajʉ ñarã cʉtojʉare wija wadibitirʉjarãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iti rʉmʉri bʉto ñeñaro tõbʉjarã yirãji masa. Dios oca tuti iti gotiro bajiroti, rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bʉjato bʉjarã yirãji iti rʉmʉri macʉ sãñarã ñarã. Ito yicõri macʉacãre ũjurã cʉni bʉjato bʉjarã yirãji. Iti rʉmʉri iti sitare ñarise jaje ñaro yiroja. Ito yicõri ñeñaro tõbʉjarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Masa jãjarã godarã yirãji ĩna gãmeri sĩaroca. Ito yicõri gãjerãre ñiacõri jaje cʉtorijʉ tubiarã yirãji ĩna. Ito yicõri gaje sita gãna gãjerã ñabojarãti Jerusalén cʉtojʉ ejacõri ñarã yirãji ĩna. Dios ĩ ãmorocõti iti sitare ñarã yirãji ĩna, yiyijʉ Jesús ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Mʉcana ado bajiro goti remoyijʉ Jesús: —Sʉsari rʉmʉri ejaroto riojʉa ũmacañi ʉ̃mʉa gagʉ, ñami gagʉ, ito yicõri ñocõare cʉni, tiyamani jaje goaro yiroja. Ito yicõri adi tutijʉ ñarã, sĩgʉ̃ bajiro riti tʉoĩacõri ña masimena yirãji ĩna. Ide jacũrise bʉto iti ruyuja tʉocõri, bʉto tʉoĩa oca jairã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Adi macãrʉcʉ̃ro gaye rẽtaroti tʉoĩa güirã, ʉsi jedirã yirãji masa. Ñocõa cʉni quedicoarã yirãji. ");
INSERT INTO myy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ito yicõri yʉ Masa Rĩjorʉre tirã yirãji masa. Ide buerina wadigʉ yigʉja yʉ. Dios ĩ rotirisena queno ruyugʉ yigʉja yʉ, masa ĩna tija. ");
INSERT INTO myy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Iti ito bajiro rẽtaro wado yiroca wanʉ oca sẽocõri ti mʉorã yirãji mʉa. Yoari mejeti masogʉ̃ yiguĩji Dios mʉare, yiyijʉ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Gaje goti masiore ocana ado bajiro gotiyijʉ Jesús ĩnare: —Higueragʉre tʉoĩate mʉa. ");
INSERT INTO myy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Itigʉ jũ buja ticõri, “Jabeto rʉya cʉma ejaroto”, yi ti masia mʉa. ");
INSERT INTO myy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iti bajiroti, jĩjʉ yʉ gotirise bajiro iti rẽtaja ticõri, “Jabeto rʉya ĩre tʉorʉ̃nʉrãre Dios ĩ miojuroto”, yi masirã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Riti mʉare gotia yʉ. Adi macãrʉcʉ̃ro gãna ĩna goda jediroto riojʉa, yʉ bʉsiro bajiroti rẽtaro yiroja. ");
INSERT INTO myy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Adi sita macãrʉcʉ̃ro cʉni jedicoaro yiroja. Ito bajibojarocati yʉ ya ocama jedibeto yiroja. Yʉ gotiado bajiroti rẽtaro yiroja, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Queno tʉoĩaña mʉa. Basa gaye riti tʉoĩa rẽtocũ yibeja. Ito yicõri mecʉbeja. Ito yicõri adi macãrʉcʉ̃ro gaye riti tʉoĩabeja. Iti gaye riti mʉa tʉoĩaja, yʉ tʉdi ejari rʉmʉ mano ʉcarã yirãji mʉa. Ñacãmena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Adi macãrʉcʉ̃ro gãna jeyaro yʉ tʉdi ejari rʉmʉ mano ʉcarã yirãji. Yʉ tʉdi ejari rʉmʉ yʉre bocati ñamena yirãji ĩna. Ito bajiri mano ʉcarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ĩnare bajiro bajibeja mʉama. Queno ña yucãña mʉa, yʉ ejaroto riojʉa. Ija iti rẽtaroti gayere mʉare rẽtame yirona Diore bʉsitĩñasotiba mʉa. Ito yicõri yʉ Masa Rĩjorʉ riojo mʉa ña masitoni Diore bʉsitĩñasotiba mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Co rʉmʉ rʉyabeto minijuara wijʉ masare Dios oca gotisotiyijʉ Jesús. Ito yicõri ñamijʉa Olivos wame cʉtiri tʉriajʉ canigʉ̃ wasotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Co rʉmʉ rʉyabeto busuri jĩjʉ ejasotiyijarã masa ĩ bʉsirisere tʉorona. ");
INSERT INTO myy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Iti rʉmʉriti cõña wayijʉ naju wadarise ʉco wʉoya mani bare basa. Gaje Pascua wame cʉtiyijʉ iti basa. ");
INSERT INTO myy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jesure siarona, ¿no bajiro yicõri sĩarʉjati mani? yi tʉoĩayijarã paia ʉjarã, ito yicõri judio masa rotirise riasori masa. Ĩre sĩa ãmobojarãti masajʉare tʉo güiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iti rʉmʉriti Judas Iscariotere rʉ̃mʉ́a ʉjʉ Satanás wame cʉtigʉ quedi sãjayijʉ. Judas ñayijʉ jʉa gʉbojeno ñagʉ̃ Jesús rãca riasotigʉ. ");
INSERT INTO myy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paia ʉjarã ito yicõri minijuara wi ʉjarãre cʉni bʉsigʉ wayijʉ ĩ. ¿No bajiro mʉare Jesure gotigʉti yʉ? yirocʉ, ĩnare bʉsigʉ wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ito ĩ yija tʉocõri, wanʉyijarã ĩna. Ito bajiri, “Mʉre niyeru ĩsiana gʉa”, yiyijarã ĩna Judasre. ");
INSERT INTO myy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ĩna ito yija tʉocõri, ñaro bajiroti cʉdiyijʉ ĩ. “¿Nocãta masa mano ĩnare ĩogʉ̃ yigʉjada yʉ?” yi tʉoĩa ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ito yija naju wadarise ʉco wʉoya mani bare basa ejayijʉ. Iti rʉmʉ Pascua ñaroca Diore rʉ̃cʉbʉorã oveja macʉ sĩacõri ĩna soera rʉmʉ ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ito bajiri Pedro, Juanre ado bajiro gotiyijʉ Jesús ĩnare: —Mani Pascua basa mani baroti quenotẽña, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ito ĩ yija tʉocõri, ĩre seniĩayijarã ĩna: —¿Nojʉ gʉa quenore ãmoati mʉ? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ado bajiro ĩnare cʉdiyijʉ Jesús: —Cʉtojʉ mʉa ejaja ide gõna wacʉre ti bʉjarã yirãji mʉa. Ito bajiri ĩre sʉya warã yirãji mʉa. Ĩ bero wacõri ĩ sãjari wijʉ ejaba mʉa. ");
INSERT INTO myy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Iti wi ʉjʉre ado bajiro gotiba mʉa. “¿Di sõa ñati yʉ riasorã rãca Pascua basa baroti sõa?” yimi mani Ʉjʉ, yi gotiba ĩre. ");
INSERT INTO myy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ito bajiro mʉa yija tʉocõri, co tuti weca ñari sõa, jaja sõa, quenocãra sõa mʉare gotigʉ yiguĩji. Mʉare ĩ gotija bero iti sõajʉ bare menima mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ito ĩ yija tʉocõri, wayijarã ĩna. Itojʉ ejacõri ĩ gotiado bajiroti bʉjayijarã ĩna. Ito yicõri bare meniyijarã Pascua basa ñaroca ĩna baroti. ");
INSERT INTO myy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bare tĩjaroca Jesús ĩ rãca riasotirã rãca bare jeoado tʉ rujiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ito yija ado bajiro ĩnare gotiyijʉ Jesús: —Yʉre ĩna sĩaroto riojʉa adi Pascua basa mʉa rãca basʉsarocʉ ruje tʉoĩacʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Itire mʉcana tʉdi mʉa rãca babicʉ yigʉja yʉ, Dios rotirojʉ ĩre tʉorʉ̃nʉrãre ĩ miojuroto riojʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ĩ ito yija bero rujatẽro ãmi rʉcocõri, “Queno ya Dios mʉ”, yiyijʉ ĩ. Ito yicõri ĩnare ado bajiro yiyijʉ Jesús: —Ĩmo adi mʉamasiti bato idiya. ");
INSERT INTO myy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Dios rotirojʉ ĩre tʉorʉ̃nʉrãre ĩ miojuroto riojʉa, mʉa rãca jʉaji ʉyé ide idibicʉja yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ito bero ĩ ya ãmona naju ãmi rʉcocõri, “Queno ya Dios mʉ”, yiyijʉ. Ito bero igata batocõri ado bajiro yiyijʉ ĩnare: —Adi ña yʉ ya rujʉ robo bajiro bajirise. Mʉare yiari goda ĩsigʉ̃ yigʉja yʉ. Ito bajiri iti bacõri yʉre tʉoĩama mʉa, yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ĩna baja bero ito bajiroti yiyijʉ ʉyé ide tẽrona. Ado bajiro yiyijʉ ĩnare: —Yʉ ya rí mʉare yiari iti budija ticõri, “Riti ña Dios ĩ gotire. Bʉcʉ oca jidicãcõri mame oca wasoañi Dios”, yirã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mʉcana bʉsigʉ ado bajiro yiyijʉ Jesús: —Gãjerã yʉre ĩna ñiatoni gotirocʉ ado mani rãca ñaguĩji. ");
INSERT INTO myy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yʉ ña Masa Rĩjorʉ. Dios ĩ ãmoro bajiroti rẽtaro yiroja yʉre. Ito bajibojarocati masa yʉre ñiatoni gotirocʉ bʉjato bʉjagʉ yiguĩji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ito ĩ yija tʉocõri, ĩnamasiti gãmeri seniĩayijarã ĩna: —¿Ñimʉ ñaguĩjida ñiatoni gotirocʉ? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ito yija ado bajiro gãmeri tʉoĩa bʉsiyijarã ĩna: —¿Ñimʉ ñaguĩjida mani wato rẽtoro ñasagʉ ñarocʉ? yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ito bajiro ĩna tʉoĩaja ticõri, ado bajiro yiyijʉ Jesús ĩnare: —Adi macãrʉcʉ̃ro gãna ʉjarã ñasarã ĩna ya moari masare rotirãji. Ito bajiri ĩna moa ĩsiri masajʉa ñe gaje yire manijare, riojoti “Baʉ, quena ña”, yicõrãji ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉama ito bajiro meje bajirʉja. Ñasari masa mʉa ña ãmoja, “Ñasarã meje ña gʉa”, yi tʉoĩarã yirãji mʉa. Ito yicõri no rotiri masʉ ña ãmogʉ̃, mʉare ĩ moa ĩsija quena. ");
INSERT INTO myy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mʉa tija ¿ñimʉjʉa ñati ñasari masʉ ba rujigʉjʉa, ecari masʉjʉa? Yʉ tʉoĩaja, ba rujigʉjʉa ñami ñasagʉ. Ito bajiri mʉa Ʉjʉ ñabojagʉti, mʉare moa ĩsiri masʉ robo bajiro ado mʉa watojʉ ña yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Coji rʉyabeto yʉ tõbʉjaja yʉ rãca ñatĩñacʉ mʉa. Gãjerã yʉre ti tudibojarocati mʉama yʉre jidicãbiticʉ. ");
INSERT INTO myy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yʉ rotirotojʉ yʉre cũgʉ̃ yiguĩji Dios. Ito bajiri mʉa cʉni yʉ rotirojʉ yʉ rãca ñarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yʉ rãca barã yirãji mʉa. Itojʉ yʉ rãca ñarã ʉjarã ĩna rujiri cumurojʉ rujirã yirãji mʉa cʉni. Ito yicõri Israel sita gãna jʉa gʉbojeno masa buturi gãnare yʉ rãca beserã yirãji mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Gaje ado bajiro gotiyijʉ mani Ʉjʉ: —Simón tʉoya mʉ. Trigo ajeri ĩna sĩguẽ bateado bajiro mʉare yi ãmoami rʉ̃mʉ́a ʉjʉ. Mʉre rʉcocõri mʉ ʉjʉ ña ãmoguĩji Satanás wame cʉtigʉ. ");
INSERT INTO myy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ito ĩ yi ãmobojarocati mʉre yiari Diore bʉsisotia yʉ, Diore mʉ tʉoĩa jidicãbititoni. Mʉcana yʉre mʉ tʉorʉ̃nʉ quenoja mʉ ñarã yʉre ĩna tʉorʉ̃nʉ oca sẽotoni ĩnare ejabʉaba, yiyijʉ Jesús Simón Pedrore. ");
INSERT INTO myy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ito bajiro ĩ yija tʉocõri, ado bajiro yiyijʉ Simón Pedro: —Yʉ Ʉjʉ mʉre ĩna tubiaja, mʉre ĩna sĩaja cʉni mʉ rãca warocʉ ñacã yʉ. Mʉre jidicãbicʉja yʉ, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesujʉa ado bajiro yiyijʉ Pedrore: —Riti mʉre gotia yʉ. Adi ñamiti busurijʉa cara ĩ yujiroto riojʉa ʉdiaji, “Jesure masibea yʉ”, yigʉ yigʉja mʉ, yiyijʉ Jesús Simón Pedrore. ");
INSERT INTO myy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ito ĩ yija bero ado bajiro yiyijʉ Jesús ĩ rãca riasotirãre: —Yʉ oca goti ucurona cõacʉ yʉ mʉare. “Niyeru sãra buju, gʉboco cʉni ãmima”, yibiticʉ yʉ mʉare. Ito bajiro yʉ yibojarocati disejʉa mʉare rʉyabiticʉ, yiyijʉ Jesús ĩnare: —Ri ya mʉ, rʉyabitibojacʉ gʉare, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ĩna ito yija ado bajiro cʉdiyijʉ Jesús ĩnare: —Adocãtamʉri ĩja mʉare rotia yʉ. No niyeru rʉcogʉ, niyeru sãra buju rʉcogʉ cʉni ãmi waja quena. Sarera jãi rʉcobicʉ ĩ ya camisa ĩsicõri wasoa ãmija quena. ");
INSERT INTO myy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Ñeñaro yirãre ĩna sĩado bajiro sĩarã yirãji ĩre”, yi gotia Dios oca yʉre rẽtaroti gaye. Ito bajiroti rẽtaro yiroja iti, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ito ĩ yija tʉocõri: —Gʉa Ʉjʉ ado ña jʉa jãi sarera jãiri, yiyijarã ĩre. —Itocõ ñajaro maji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ito ĩ yija bero ĩ yisotiro bajiro yigʉ Olivos wame cʉtiri tʉriajʉ wayijʉ ĩ. Ito bajiri ĩ rãca riasotirã ĩre sʉya wayijarã. ");
INSERT INTO myy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Diore ĩ bʉsisotirojʉ ejacõri ado bajiro gotiyijʉ Jesús ĩnare: —Diore seniña mʉa ñeñaro yibe yirona, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ito yicõri ĩnare cũcõri gʉ̃tagã rea ñucaja quedirocõ wayijʉ Jesús. Ito yicõri ñini rũjũcõri Diore bʉsiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ado bajiro yiyijʉ ĩ Diore: —Cʉna mʉ ãmoja ija yʉ tõbʉjaroti gaye camotaya. Ito bajibojarocati yʉ ãmoro bajiro meje mʉ yija quena. Mʉ ãmoro bajirojʉa mʉ yija quena, yiyijʉ Jesús Diore. ");
INSERT INTO myy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ito ĩ yija bero sĩgʉ̃ ángel ĩre goaĩocõri ĩ oca sẽoroca yiyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Bʉto tʉoĩa oca jaicõri tõbʉjayijʉ ĩ. Ito yicõri bʉto oca sẽocõri Diore bʉsiyijʉ. Bʉto oca sẽocõri ĩ bʉsiroca riti asi budirise bajiro rí budiyijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Diore bʉsi tĩogʉ̃ wʉmʉ rʉ̃gʉ̃cõri mʉcana ĩ rãca riasotirã tʉ wayijʉ ĩ. Ĩna tʉ ejacõri tiyijʉ ĩ. Bʉto tʉoĩa oca jaicõri caniana ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ito yija ado bajiro yiyijʉ ĩ: —¿No yija caniati mʉa? Diore seniña mʉa ñeñaro yibe yirona, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ĩ bʉsiroca riti, masa jãjarã ejayijarã. Ĩnare ũmatã wacʉ Jesús tʉ eja rʉ̃gʉ̃yijʉ Judas wame cʉtigʉ. Ĩ ñayijʉ Jesús rãca riasotigorʉ jʉa gʉbojeno ñarã rãca ñagorʉ. Jesús tʉ ejacõri wayugajʉ muwãcõri usuyijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ĩ ito yija ado bajiro yiyijʉ Jesús ĩre: —Judas, yʉ ña Masa Rĩjorʉ. ¿Gãjerã yʉre ñiatoni yʉre usu ĩoati mʉ? yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ito gãna Jesús rãca ñarã, iti ito bajija ticõri, ado bajiro seniĩayijarã Jesure: —¿Gʉa Ʉjʉ sarera jãina ĩnare gãmeri jarʉjabeati mani? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ĩna rãca gagʉ sĩgʉ̃ paia ʉjʉre moa ĩsiri masʉre riojocadʉja gãmoro jatayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ito bajiro ĩ yija ticõri, ado bajiro yiyijʉ Jesús: —Ito mʉa yirise itocõ jidicãña, yiyijʉ Jesús. Ito bajiri gãmoro moaĩacõri ĩre yisioyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ito yicõri ĩre ãmi warona paia ʉjarã, minijuara wi ʉjarã ito yicõri judio masa bʉcʉrãre cʉni, ado bajiro yiyijʉ Jesús: —Riniri masʉ meje ña yʉ. ¿No yirã yʉre ãmirona sarera jãiri rʉcocõri, yucʉ rʉcocõri ejati mʉa? ");
INSERT INTO myy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Co rʉmʉ rʉyabeto minijuara wijʉ yʉ ñaja yʉre ñiabiticʉ mʉa. Adocãta rʉ̃mʉ́a ʉjʉ ĩ ãmoro bajiro, bajiro yiroja. Ito bajiri ĩre cʉdirã mʉa ãmoro bajiro ya mʉa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ito ĩ yija bero paia ʉjʉ ya wijʉ ĩre ãmi wayijarã ĩna. Pedro sõ bʉsajʉ sʉyayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Paia ʉjʉ ya wi soje riojo jea riocõri sũma rujiyijarã ito gãna. Pedro ĩna tʉ ejacõri ĩna wato jea sũma rujiyijʉ ĩ cʉni. ");
INSERT INTO myy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sĩgõ iti wi moari maso ĩ sũma rujija ticõri, ĩre riti tiyijo. Ito yicõri ado bajiro yiyijo iso: —Ãni cʉni Jesús rãca gagʉ ñami, yiyijo iso. ");
INSERT INTO myy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ito bajiro iso yija tʉocõri, goti ãmobisijʉ Pedro. —Ĩre masibea yʉ, yiyijʉ ĩ isore. ");
INSERT INTO myy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ito bero yoa bʉsari gãji ĩre ticõri ado bajiro yiyijʉ: —Jesús rãca gagʉti ña mʉ cʉni yiyijʉ ĩ Pedrore. Ito ĩ yija tʉocõri: —Bʉgʉti ya mʉ. Meje ña yʉama, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Coji cõre berocõ gãji, ado bajiro ĩre yisayijʉ: —Riti ya yʉ, Jesús rãca gagʉti ñami ãni. Galilea gagʉti ñami ĩ. Ito bajiroti bʉsiami, yiyijʉ ĩ gãjerãre. ");
INSERT INTO myy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ito bajiro ĩ yija tʉocõri, ado bajiro yiyijʉ Pedro: —Mʉ bʉsirisere masibea yʉ, yiyijʉ Pedro. Ito bajiro ĩ bʉsiroca riti cara yujicoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ito ĩ bajiroca riti mani Ʉjʉ jʉda tiyijʉ Pedrore. Ito ĩ yija ticõri, mani Ʉjʉ ĩ gotire tʉoĩa bʉjayijʉ Pedro. Cara ĩ yujiroto riojʉa ʉdiaji, “Jesure masibea yʉ”, yigʉ yigʉja mʉ, Jesús ĩ yire gaye tʉoĩa bʉjayijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ito bajiri gajero bʉsa wacõri bʉto tʉoĩa otiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesure ñiacõri ĩre coderi masa aja tudiyijarã. Ito yicõri ĩre jayijarã. ");
INSERT INTO myy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ĩ ya cajea moabiacõri ĩ ya riojʉ jayijarã ĩna. Ito yicõri ado bajiro seniĩayijarã ĩna ĩre. —Queno tʉoĩagʉ̃ mʉ ñaja, “Ĩ yʉre jami”, yi masigʉ̃ja mʉ, yiyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Gaje jaje ĩre aja tudiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Gaje rʉmʉ busuri, judio masa bʉcʉrã, paia ʉjarã, ito yicõri judio masa rotirise riasori masa cʉni, minijuayijarã. Minijuacõri Jesure ʉjarã ñasarã riojo ãmi wayijarã ĩna. Ito ejacõri ĩre seniĩayijarã ĩna: ");
INSERT INTO myy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Mʉti ñati Cristo Dios ĩ cõarʉ? yiyijarã ĩna Jesure. —“Ĩti ña yʉ”, yʉ yibojaja cʉni tʉomena yirãji mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mʉare yʉ seniĩabojaja cʉni cʉdimena yirãji mʉa. Ito yicõri yʉre jidicãmena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Jane adi rʉmʉna rẽtoro masigʉ̃ Dios ya riojocadʉja rʉ̃cʉbʉorajʉ rujigʉ yigʉja yʉ. Yʉ ña Masa Rĩjorʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ito bajiro ĩ yija tʉocõri, ado bajiro seniĩa jediyijarã ĩna: —¿Dios Macʉ mʉ ñarise riti ñati? yiyijarã. —Ĩti ña yʉ. Mʉa yiro bajiroti bajia, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ito bajiro ĩ yija tʉocõri: —“Ĩti ñami ñeñaro bʉsigʉ”, gãjerã ĩna yire ãmobea ĩja. Manimasiti ĩ bʉsija tʉoa mani, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ito yija Pilato riojo Jesure ãmi wa jediyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ʉjʉ riojo ãmi ejacõri, “Ãni ñami seti cʉtigʉ”, yirona bʉsisʉoyijarã ĩna: —Ãni ñami gʉa masa ricati riti tʉoĩaroca yigʉ. Ito bajiri ado bajiro yiquĩ ĩ gʉa masare. “Roma gagʉ ʉjʉre ĩ rotiro bajiro niyeru ĩsibitirʉja mʉare”, yiquĩ ãni. Ito yicõri, “Yʉti ña Cristo Dios ĩ cõarʉ mʉa ʉjʉ”, yiquĩ ĩ, yiyijarã ĩna Pilatore gotirã. ");
INSERT INTO myy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ĩna ito yijare ado bajiro seniĩayijʉ Pilato Jesure: —¿Judio masa ʉjʉ ñati mʉ? yiyijʉ ĩ Jesure. —Aʉ ĩti ña yʉ. Mʉ yiro bajiroti bajia, yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ito ĩ yija tʉocõri, paia ʉjarã, masare cʉni ado bajiro yiyijʉ Pilato. —Yʉ tija ñejʉa seti ma ãnire, yiyijʉ Pilato ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ito ĩ yibojarocati ĩre seti ñasameti, yi bʉsiyijarã ĩna: —Ĩ riasorise tʉocõri, sĩgʉ̃ bajiro meje tʉoĩama Judea sita gãna ĩja. Galileajʉ cajero riasosʉoñi ĩ. Ito bajiro riaso wadicõri adojʉ ejami ĩ, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ĩna ito yija tʉocõri: —¿Galilea gagʉ ñati ãni? yi seniĩayijʉ Pilato ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Galilea gagʉti ñami ĩ, yiyijarã ĩna. Ĩna ito yija tʉocõri: —Adi rʉmʉriti ejami Galilea gagʉ ʉjʉ Herodes wame cʉtigʉ. Ito bajiri ĩ tʉ ãmi wasa mʉa, yiyijʉ Pilato ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesús rãca ĩna ejaja ticõri, bʉto wanʉyijʉ Herodes. Yoari ĩ oca tʉocõri ruje ĩre ti ãmoyijʉ Herodes. Tiyamani Jesús ĩ yija ti ãmoyijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jesure ticõri jaje ĩre seniĩabojayijʉ ĩ. Ito bajibojarocati Jesús coji cʉdibisijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Paia ʉjarã, judio masa rotirise riasori masa cʉni ito ñayijarã. “Seti ñasacõa ĩre”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ito yija bero, Herodes ĩ ya surara rãca Jesure aja tudiyijarã ĩna. Ĩre tudisarã ñarã ʉjarã mesa ĩna sãñarise ĩre sãyijarã ĩna, ĩre aja tudirã. Ito bajiro ĩna yija bero mʉcana tʉdi Jesure Pilato tʉjʉ cõayijʉ Herodes. ");
INSERT INTO myy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ito bajiro ĩna yira rʉmʉti Herodes Pilato rãca queno gãmeri baba cʉtiyijarã ĩna ĩja. Ito bajiro ĩna bajiroto riojʉa bʉto gãmeri ti tudirã ñayijarã ĩna maji. ");
INSERT INTO myy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mʉcana Jesure ĩna ãmi ejaja ticõri, paia ʉjarã ñasarã ʉjarã, ito yicõri masare cʉni miojuyijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ado bajiro yiyijʉ ĩ: —“Gʉa masare sĩgʉ̃re bajiro gʉa tʉoĩaroca yibeami ãni”, yirona yʉre ãmi ejacʉ mʉa. Ãnire, “¿Riti mʉre seti ñati?” yirocʉ seniĩabojacʉ yʉ, mʉa tiro riojo. Ito bajibojarocati, “Ĩre seti ña”, mʉa yibojarocati disejʉa seti ma ĩre yʉ tija. ");
INSERT INTO myy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ito yicõri, Herodes cʉni, “Iti seti ña ĩre”, yi masibisĩ ĩ cʉni. Ito bajiri, “Iti seti ña ĩre”, yi masibiti wacʉ gʉajʉare jʉdacõañi ĩ. “Ito bajiro seti cʉtiami ãni”, yi masibea mani. Ito bajiri ĩre sĩado ma mani. ");
INSERT INTO myy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ĩre baje rotigʉ ya yʉ. Ito yicõri ĩre bucõacʉja yʉ, yiyijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pascua basa ñaroca, “Ãnire mʉ bucõare ãmoa gʉa”, masa ĩna yigʉreti bucõasotiyijʉ Pilato. Ito bajiri ado bajiro ĩnare seniĩayijʉ ĩ: ");
INSERT INTO myy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","“¿Ñimʉjʉare yʉ bucõare ãmoati mʉa?” ĩ yiroca masajʉa ado bajiro awasã bʉsiyijarã: —Sĩacõña ãni ʉ̃mʉgʉ̃re. Ito yicõri, Barrabás wame cʉtigʉre jidicãña, yi awasãyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Cʉto gãnare oca menicõri sĩari masʉ ĩ ñajare ĩna tubiarʉ ñayijʉ Barrabás. ");
INSERT INTO myy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jesujʉare jidicã ãmobojayijʉ Pilato. Ito bajiri mʉcana masare bʉsibojayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ito bajiro ĩ bʉsibojarocati bʉto bʉsa awasãyijarã ĩna: —Sĩacõrʉja ĩre. Sĩacõrʉja ĩre, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mʉcana tʉdi ʉdiaji bʉsigʉ ado bajiro yiyijʉ Pilato ĩnare: —¿Ñeoni ñeñaro yicati ãni? Yʉ tija, “Itina godarʉjami ĩ”, yi masibea yʉ ĩre. Ito bajiri ĩre bajecõri jidicãcʉja yʉ, yibojayijʉ ĩ masare. ");
INSERT INTO myy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bʉto awasã bʉsirã, “Yucʉtẽojʉ ĩre jaju sĩaña”, yiyijarã ĩna. Bʉto masa ĩna awasãja, paia ʉjarã ĩna awasãja tʉocõri, “Ĩna ãmoro bajiroti yijaro no cʉni”, yi tʉoĩayijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ito bajiri, “Ĩna ãmoro bajiroti yicʉja no cʉni”, yi tʉoĩayijʉ Pilato ĩja. ");
INSERT INTO myy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ito bajiro tʉoĩacõri, masare oca menicõri sĩari masʉre bucõayijʉ Pilato. Ito yicõri Jesure ĩnare ĩsiyijʉ Pilato, ĩna ãmoro bajiro ĩna yitoni. ");
INSERT INTO myy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ito bajiri Jesure yucʉtẽojʉ jaju sĩarona ĩre ãmi wayijarã ĩna. Ito bajiro ĩna waroca Cirene gagʉ Simón wame cʉtigʉ joajʉ wadicõri ejayijʉ. Ĩre ti bʉjacõri yucʉtẽo ĩre gaja rotiyijarã surara. Ito bajiri Jesús bero yucʉtẽo gaja sʉyayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Masa jãjarã ĩ bero sʉya wayijarã. Ito yicõri romia jãjarã awasã otiyijarã ĩre tʉo mairã. ");
INSERT INTO myy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ito bajiro ĩna otiroca ĩnare jʉda ticõri ado bajiro yiyijʉ Jesús: —Jerusalén gãna romia yʉre otibesa mʉa. Mʉamasiti, ito yicõri mʉa rĩare rẽtarotire tʉoĩa otiya mʉa. ");
INSERT INTO myy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ado bajiro yirã yirãji masa bʉto ĩna tõbʉjari rʉmʉ: “Romia rĩa mana queno wanʉ quenama ĩna. Ito yicõri rĩa rʉcomena, ũjumena cʉni wanʉama ĩna”, yirã yirãji masa. ");
INSERT INTO myy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Gʉare Dios tibe yirona ado bajiro yirã yirãji masa: “Gʉa joe juja biaya”, yirã yirãji gʉ̃ta yucʉrire. Ito yicõri, “Gʉare õjea biaya”, yirã yirãji tʉriare. ");
INSERT INTO myy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yʉjʉare tõbʉjaroca ĩna yija, yʉ rẽto bʉsaro mʉa tõbʉjaroca yirã yirãji ĩna, yiyijʉ Jesús romiare jʉda ticõri. ");
INSERT INTO myy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ñeñaro yi jairã jʉ̃arãre ãmi wayijarã Jesús rãcati ĩnare jaju sĩarona. ");
INSERT INTO myy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Calavera wame cʉtirijʉ ejacõri Jesure jajuyijarã ĩna. Ito yicõri ĩ rãca gãna jʉ̃arãre cʉni, sĩgʉ̃ Jesús ya riojocadʉja, ito yicõri gãji ĩ ya gãcodʉjare jajuyijarã ĩna cõtoni. ");
INSERT INTO myy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ĩre ĩna jajuroca ado bajiro yiyijʉ Jesús Diore: —Cʉna, yʉre ĩna ñeñaro yirisere ĩnare ãcabojoya, “Bʉto ñeñaro ya mani”, yi masibeama surara, yiyijʉ Jesús Diore. “¿Jesús ĩ sãñagorere ñimʉjʉa bʉjagʉ yiguĩjida?” yirona gʉ̃ta ajeri rea ajeyijarã surara. ");
INSERT INTO myy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ito bajiro yi ajecõri ĩ ya yutabujuri gãmeri batoyijarã ĩna ĩja. Ĩ godaroca jãjarã masa ti ñayijarã ĩre. Ito ñarã ʉjarã Jesure aja tudiyijarã. Ado bajiro aja tudiyijarã ĩna: —Gãjerãreama masoñi ĩ. Riti Cristo Dios cõarʉ ĩ ñaja ĩmasiti masogʉ̃ yiguĩji, yi aja tudiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Surara cʉni ito ñarã, ito bajiroti ĩre aja tudiyijarã. Ĩ tʉ eja rʉ̃gʉ̃cõri ʉyé ide sʉ̃erise ĩre iobojayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ito yicõri ado bajiro yiyijarã ĩna: —Riti judio masa ʉjʉ mʉ ñaja, mʉmasiti masogʉ̃ yigʉja mʉ, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesús ya rijoga weca ʉdiaji gaye oca ucare wãñayijʉ. Griego, Latín, Hebreo ocana cʉni ucare ado bajiro ñayijʉ: “Ãni ñami judio masa ʉjʉ”, yi bʉsiyijʉ iti ĩna ucare. ");
INSERT INTO myy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sĩgʉ̃ ñeñaro yi jaigʉ ĩ rãca godarocʉ ado bajiro yiyijʉ: —Riti Cristo mʉ ñaja mʉmasiti masoña. Ito yicõri gʉare cʉni masoña mʉ, yi aja tudiyijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gãji gaje dʉja gagʉ Jesús rãca godarocʉ, ado bajiro yiyijʉ Jesure aja tudigʉjʉare: —¿Diore güire mati mʉre? Mani ñeñaro yirise waja godarã ya mani. ");
INSERT INTO myy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ñeñaro yicʉ mani. Ito bajiri iti waja quenabeto tõbʉjarã ya mani. Mani ñeñaro yiado bajiroti itire waja yirã ya mani. Ito bajibojarocati ãniama ñeñaro yibicʉ ñabojagʉti mani rãca godagʉ yiguĩji, yiyijʉ ĩ Jesure aja tudigʉre. ");
INSERT INTO myy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ito yija Jesure ado bajiro yiyijʉ ĩ: —Mʉ rotirojʉ ejacõri mʉre tʉorʉ̃nʉrãre mʉ miojusʉoja yʉre ãcabojabeja, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ito bajiro ĩ yija tʉocõri: —Jane adi rʉmʉti ñe ñeñarise manojʉ yʉ rãca ñagʉ̃ yigʉja mʉ, ado yʉ yirise riti mʉre gotia yʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ito bajiro iti baji ñaroca ʉ̃mʉa gʉdarecocõ tʉjayijʉ. Ito yija bero macãrʉcʉ̃ro ñarocõti rãiocoayijʉ. Yucʉ weca ũmacañi tʉjarocacõ rãitĩayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ũmacañi ʉ̃mʉa gagʉ cʉni busubisijʉ. Ito yicõri minijuara wi yobiado saya webʉtiro gʉdarecona ñigãyijʉ. ");
INSERT INTO myy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ito bajiroca Jesús ado bajiro awasãyijʉ: —Cʉna, yʉ ya Ʉsi ãmiña mʉ ĩja, yiyijʉ Jesús Diore. Ito yi tĩogʉ̃ti ʉsi jedicoayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Surara ʉjʉ Roma gagʉ ito bajiro iti rẽtaja ticõri, Diore rʉ̃cʉbʉo bʉsiyijʉ: —Riti seti manibojañi ãni, yiyijʉ surara ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Masa ito ti ñana ito bajiro iti rẽtaja ticõri, bojori bʉjarã ĩna ya ʉsi riojo jatu wayijarã. ");
INSERT INTO myy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesús rãca baba cʉtigoana Galilea gãna romia ĩre sʉya wana cʉni sõ bʉsajʉ ti rʉ̃gõyijarã ĩna, ito iti bajijare. ");
INSERT INTO myy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Sĩgʉ̃ ñayijʉ ĩ yiro bajiroti queno yigʉ. José wame cʉtigʉ ñayijʉ ĩ. Judea sitajʉ Arimatea wame cʉtiri cʉtojʉ gagʉ ñayijʉ ĩ. Judio masa ʉjarã ñasari masa rãca gagʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","“Ĩre tʉorʉ̃nʉrãre ĩ rotirojʉ miojugʉ yiguĩji Dios”, yi tʉoĩa yugʉ ñayijʉ ĩ. Ito bajiri ʉjarã ñasarã ĩna yirisere queno ĩna robo tʉoĩabisijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ito bajiri Pilatore bʉsirocʉ wayijʉ ĩ. Itojʉ ejacõri Jesús ya rujʉre seniyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","“Baʉ”, ĩ yija tʉocõri, Jesús ya rujʉre yucʉtẽojʉ ñagʉ̃re rujiogʉ wayijʉ ĩ. Ĩre rujiocõri saya botirona ĩre gũmayijʉ. Ito yicõri gʉ̃ta tʉriajʉ ĩna goje meniadojʉ Jesús ya rujʉre cũyijʉ ĩ. Yujeĩaña mani goje ñayijʉ iti goje. ");
INSERT INTO myy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tujacãra rʉmʉ riojʉa ĩna queno yuri rʉmʉ ñayijʉ José Jesure ĩ yujera rʉmʉ. Ito bajiri jabetoti rʉyayijʉ tujacãra rʉmʉ iti busuroto. ");
INSERT INTO myy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Cajero Galilea gãna romia Jesure sʉya wadiana gʉ̃ta gojejʉ ĩre ĩna cũja, “¿Ado bajiro cũati ĩna?” yi tiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ĩna cũja bero wijʉ tʉdi wayijarã ĩna. Wijʉ tʉdi ejacõri queno sʉtirise, ito yicõri rujʉ ture gaye quenoyijarã ĩna. Ito yija judio masa ĩna rotiado bajiroti tujacãra rʉmʉ ñacõayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tujacãra rʉmʉ bero busuri jĩjʉ tʉdi tirã wayijarã ĩna. Sʉtirise rujʉ ĩna turotire ĩna moa quenorere ãmi wayijarã ĩna. Gãjerã romia cʉni ĩna rãca wayijarã. ");
INSERT INTO myy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Itojʉ ejacõri ĩna tija gʉ̃ta goje biado gajerojʉ iti cũ ñaja tiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ito bajija ticõri, sãjayijarã ĩna. Sãjacõri mani Ʉjʉ ya rujʉre ti bʉjabisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ito bajija ticõri, ʉcayijarã ĩna. Ito yicõri, “Ito yirʉja manire”, yi masibisijarã ĩna. Ito bajiro ĩna baji ñaroca ʉ̃mʉa jʉ̃arã ĩna tʉ rʉ̃gõja tiyijarã. Saya yorise sãñarã ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ĩnare güirã jacajʉ muqueayijarã ĩna. Ito bajiro ĩna güija ticõri, ado bajiro yiyijarã ĩna ʉ̃mʉa: —¿No yija ĩ catibojaroti godanare ĩna yujerojʉ ãmati mʉa? ");
INSERT INTO myy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mami ĩ adojʉ. Catigʉ ñami ĩ. Mʉcana tʉdi catirʉ ñami ĩ. Galilea ñagʉ̃ mʉare ĩ bʉsire tʉoĩate mʉa. Ado bajiro mʉare gotiñi ĩ: ");
INSERT INTO myy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Yʉ Masa Rĩjorʉre ñeñaro yirã yʉre ñiacõri yʉ tõbʉjaroca yirã yirãji ĩna. Ito yicõri yʉre yucʉtẽojʉ sĩarã yirãji ĩna. Ito bajiro ĩna yibojarocati mʉcana ʉdia rʉmʉ bero catigʉ yigʉja yʉ”, yi gotiñi Jesús mʉare, yiyijarã ĩna romiare. ");
INSERT INTO myy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ito bajiro ĩna yija tʉocõri, Jesús ĩ bʉsire gaye tʉoĩa bʉjayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ito yija bero iti tʉo tʉdi wacõri Jesús rãca riasotigoana coga gʉbojeno ñarã, ito yicõri ito ñarãre cʉni jeyaro ĩna tigorere gotiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ĩna romia Jesús rãca riasotigoanare oca ãmi wana ñayijarã María Magdalena, Juana, María Santiago jaco cʉni. Ito yicõri gãjerã romia cʉni ñayijarã iti oca gotiana. ");
INSERT INTO myy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ito bajiro romia gotija tʉocõri, “Bʉrãti yama”, yi tʉoĩayijarã Jesús rãca riasotigoana. Ito bajiri ĩnare tʉorʉ̃nʉbisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ito bajibojarocati Pedroama ũmaquedi wacõri masari cuma tigʉ wayijʉ. Ito totijʉ ĩ tija gũmado riti gajerojʉ iti cũ ñaja tiyijʉ ĩ. Ito bajija ti ʉcacõri ĩ ya wijʉ tʉdi wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Iti rʉmʉ riti jʉ̃arã Jesús rãca riasotigoana Emaús wame cʉtiri cʉtojʉ wasʉoyijarã. Jerusalén sõjʉa once kilómetrocõ ñayijʉ Emaús cʉto. ");
INSERT INTO myy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jeyaro ĩna tigore gaye warãti bʉsi wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ito bajiro ĩna tʉoĩa bʉsi waroca Jesuti mʉcana ĩna tʉ ejacõri ĩna rãca wayijʉ. ");
INSERT INTO myy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ĩre tigoana ñabojarãti “Jesuti ñami ĩ”, yi masibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ito bajiro ĩna waroca Jesús ado bajiro ĩnare seniĩayijʉ: —¿Ma warã ñe gaye tʉoĩa bʉsiati mʉa? Ito yicõri, ¿no yija bojori bʉjati mʉa? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ito ĩ yija tʉocõri, Cleofas wame cʉtigʉ, ado bajiro cʉdiyijʉ: —Masa jeyaro Jerusalénjʉ rẽtare gayere masiama ĩna. ¿No yija Jerusalénjʉ ñarʉ ñabojagʉti itire masibeati mʉ? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ito bajiro ĩ yija tʉocõri: —¿Ñe rẽtacati? yiyijʉ Jesús. Ito ĩ yija ado bajiro yiyijarã ĩna Jesure: —¿Jesús Nazaret gagʉre rẽtare masibeati mʉ? Ado bajiro bajia iti. Diore goti ĩsiri masʉ ñaquĩ ĩ. Jaje tiyamani yiquĩ ĩ. Ito yicõri Dios ĩ masirisena masare riasoquĩ ĩ. Dios cʉni ĩre rʉ̃cʉbʉoñi. ");
INSERT INTO myy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paia ʉjarã, gʉa ʉjarã cʉni ĩre sĩa rotirã gãjerãre ĩsicã ĩna. Ito yicõri yucʉtẽojʉ ĩre sĩa roticã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Ĩ ñagʉ̃ yiguĩji gʉa masa Israel gãna ʉjʉ. Gʉare masorocʉ ñaguĩji ĩ”, yi tʉoĩabojacʉ gʉa. Ito bajibojarocati ʉdia rʉmʉ tʉja ĩre ĩna sĩaja bero. ");
INSERT INTO myy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jĩjʉ gʉa rãca gãna romia masari cuma tirã wabojana. Ñe manoti ti ejayijarã ĩna. Ito bajiri gʉare ĩna goti tʉdi ejajare ʉcabʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Gʉa tʉ ejacõri ado bajiro goticã ĩna: “Dios ñaro gãna ángel mesare jʉ̃arã tibʉ gʉa. ‘Mami Jesús. Catigʉ ñami’, yi gotima ĩna gʉare”, yi goti tʉdi ejacã gʉare romia. ");
INSERT INTO myy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Gʉa rãca gãna coriarã wacõri masari cuma tirã ejañi. Ito bajiri romia ĩna gotiado bajiroti ti ejayijarã ĩna. Itojʉ Jesure ti bʉjabisijarã ĩna cʉni, yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ĩna ito yija tʉocõri, ado bajiro yiyijʉ Jesús ĩnare: —Queno tʉoĩa masimena ña mʉa maji. Ito bajicõri, Diore goti ĩsiri masa ĩna gotija tʉorã ñabojarãti ĩ ocare tʉorʉ̃nʉ jeobea mʉa maji. ");
INSERT INTO myy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yʉre tʉoĩa yurã ado bajiro yi ucayoñi Diore goti ĩsiri masa: “Dios ĩ ñarojʉ ĩ ejaroto riojʉa tõbʉjagʉ yiguĩji Cristo Dios ĩ cõarʉ”, yi ucayoñi Diore goti ĩsiri masa, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ito ĩ yija bero Dios oca tuti ĩ oca gaye iti bʉsija ĩnare goti rẽtobuyijʉ Jesús. Cajero Moisés ĩ ucara tuti gaye ĩnare goti rẽtobuyijʉ ĩ. Ito yicõri Diore goti ĩsiri masa ĩna ucare cʉni goti rẽtobuyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ĩna wara cʉtojʉ ejacõri gaje majʉ riojoti rẽta wacʉ bajiro yiyijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ĩ rẽta wabe yirona ado bajiro yiyijarã ĩna: —Ado gʉa rãca tujaya mʉ. Ũmacañi quedi sãjacoami. Rãio wato ya ĩja, yiyijarã ĩna Jesure. Ĩna ito yija tʉocõri, ĩna rãca wijʉ sãjayijʉ Jesús ito canirocʉ. ");
INSERT INTO myy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bara casabo tʉ ĩna rujiroca naju ãmi rʉcoyijʉ Jesús. Ito yicõri, “Queno ya Dios mʉ”, yiyijʉ ĩ. Ito ĩ yija bero igata batocõri ĩnare ĩsiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ito bajiro ĩ yirocati ĩna ya cajeari titãcãdo robo bajiro ejayijʉ ĩnare. Ito bajiri Jesure ti masiyijarã ĩna ĩja. “Jesuti ñami ãni”, ĩna yirijʉti godacoayijʉ Jesús mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ĩna jʉ̃arã ado bajiro gãmeri bʉsiyijarã ĩna: —Ma manire ĩ bʉsi wadija queno ʉsi quedi sãjamʉ manire. Ito yicõri Dios oca tuti gaye manire ĩ goti rẽtobuja queno ʉsi quedi sãjamʉ manire, yi gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ito bajija bero yumenati riojoti Jerusalénjʉ tʉdicoayijarã ĩna ĩja. Jerusalénjʉ ĩna ejaroca coga gʉbojeno Jesús rãca riasotigoana, ito yicõri ĩna rãca gãna cʉni minijua ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ĩna jʉ̃arã tʉdi ejaja ticõri, ado bajiro goti bocayijarã ĩna. —Riti mʉcana mani Ʉjʉ caticoañi. Simón ĩmasiti ĩre tiñi, yi goti bocayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ito yija ĩnajʉa cʉni ĩna ma waroca ĩnare bajire gayere gotiyijarã ĩnajʉa cʉni mʉcana: “Ma gʉa waroca sĩgʉ̃ sʉaquĩ gʉare. Wijʉ ejacõri naju ĩ bato ĩsija ticõri, ‘Jesuti ñami ãni’, yi ti masicʉ gʉa cʉni”, yi gotiyijarã ĩna, ito minijua ñanare. ");
INSERT INTO myy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ito bajiro ĩna bʉsi ñarocati ĩna wato goaĩoyijʉ Jesús mʉcana. —Ñati mʉa. Ñe mano queno ñaña mʉa, yi ejayijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ito bajija ti ʉcacõri güiyijarã ĩna, “Wʉjo ñaroja”, yirona. ");
INSERT INTO myy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ĩna güijare ado bajiro yiyijʉ Jesús: —¿No yija ti ʉcati mʉa? ¿No yija, “Jesuti ñami. Jesuti ñaguĩji gajea”, yi tʉoĩati mʉa? ");
INSERT INTO myy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yʉ ya ãmo tiya mʉa. Ito yicõri yʉ ya gʉbori cʉni tiya mʉa. Yʉti ña yʉ. Yʉre queno ticõri moaĩaña mʉa. Wʉjo ñajama yʉ robo bajiro gõa cʉti, ri cʉti yibetoja, mʉa tija, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ito yicõri ĩ ya ãmori ĩ ya gʉbori cʉni ĩnare ĩoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wanʉbojarãti, “Ĩ meje ñaguĩji”, yirona ʉcayijarã ĩna. Ito bajija ticõri, ado bajiro yiyijʉ Jesús ĩnare: —¿Bareoni jabeto ñacʉati mʉare? yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ito yija wai jʉ̃ora cuji co cuji ĩre ĩsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Itire boca ãmicõri ĩna tiro riojo bayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iti bacõri ado bajiro yiyijʉ Jesús ĩnare: —Canʉti yʉre rẽtacati gayere mʉa rãca ñagʉ̃jʉ, “Ado bajiro rẽtaro yiroja yʉre”, yi goticãcʉ yʉ mʉare. Ado bajiro mʉare yicʉ yʉ: Moisés ĩ ucare, Diore goti ĩsiri masa ĩna ucare, David ñayorʉ ĩ ucarena cʉni, “Ado bajiro rẽtaro yiroja Dios ĩ cõarʉre”, yi ucañi ĩna. “Ĩna ucado bajiroti yʉre rẽtaro yiroja”, yi mʉare goticãcʉ yʉ, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ito ĩ yija bero Dios oca tuti gaye ĩna tʉo masitoni ĩnare goti rẽtobuyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ado bajiro yiyijʉ ĩ ĩnare: —Cristo Dios ĩ cõarʉ quenabeto tõbʉjacõri godagʉ yiguĩji. Ito yicõri mʉcana godana wato ñabojacõri tʉdi catigʉ yiguĩji mʉcana. ");
INSERT INTO myy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iti oca masa jeyarore goti ucure ñaro wado yiroja. “Mʉa ñeñaro yirisere jidicãña. Ito yicõri Jesucristore tʉorʉ̃nʉña ñeñaro mʉa yirise Dios ĩ ãcabojotoni”, yi goti ucure ñaro wado yiroja. Jerusalén gãnare goti tĩocõri masa jeyarore goti ucure ñaro wado yiroja, yi gotia Dios oca. ");
INSERT INTO myy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ito bajiro iti rẽtaja tigoana ña mʉa. ");
INSERT INTO myy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yʉ Jacʉ ĩ rotiado bajiroti mʉare Espíritu Santo queo sãgʉ̃ yigʉja yʉ. Espíritu Santona sʉoriti Dios ĩ masirise mʉare ĩ queo sãroto riojʉa ado Jerusalénjʉti ñacõaña maji, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ito bajiro ĩ yija bero Betaniajʉ ĩnare ãmi wayijʉ. Ĩ ya ãmori ñu mʉocõri, “Mʉare queno yijaro Dios”, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ito bajiro ĩnare ĩ yija bero ũmacʉ̃jʉ ãmi wayijʉ Dios ĩre. ");
INSERT INTO myy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bʉto ĩre rʉ̃cʉbʉo wanʉ quenacõri Jerusalénjʉ tʉdi wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ito yicõri co rʉmʉ rʉyabeto rʉ̃cʉbʉorã Dios ya wijʉ minijuasotiyijarã ĩna. Itocõ ña.");
INSERT INTO myy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cajero ñe manirajʉti Cristo, Dios oca goti rẽtoburocʉ ñacãyijʉ. Ĩ Dios rãcati ñayijʉ. Ito yicõri ĩti ñayijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Adi macãrʉcʉ̃ro ĩ rujeoroto riojʉajʉ Dios rãca ñacãyijʉ Cristo. ");
INSERT INTO myy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ĩ́na sʉoriti macãrʉcʉ̃ro gaye jeyaro rujeoyijʉ Dios. Ñejʉa gaje Cristo manoti rujeobisijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ĩti ñami catitĩñare rʉcogʉ. Ito yicõri ĩti ñami busurise rʉcogʉ. Ito bajigʉ ñari masa ĩna tʉo masiroca yi masiami ĩ. ");
INSERT INTO myy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Rãitĩarojʉ masa ĩna ñeñaro yibojaja cʉni busu masiguĩji Cristo. “Ñeñaro yirã ña mani”, ĩna yi masiroca, yigʉ yiguĩji Cristo. Ito bajiri ĩre rẽtocũ masibicʉ yiguĩji rãitĩaro ñagʉ̃ rʉ̃mʉ́a ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sĩgʉ̃ ʉ̃mʉgʉ̃ ñaquĩ gʉa masare ĩ riasotoni Dios ĩ cũrʉ. Ĩ wame cʉtiquĩ Juan idé guri masʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","“Cristo ñami busurise rʉcogʉ”, masare yi riasorocʉ wadiñi Juan idé guri masʉ. Cristore masa ĩna tʉorʉ̃nʉtoni Dios ocare gotigʉ wadiñi Juan idé guri masʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ĩ meje ñañi busurise rʉcogʉ. Cristo, busurise rʉcogʉre bʉsi ĩsigʉ̃ wadirʉ ñañi Juan. ");
INSERT INTO myy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Busurise rʉcosagʉ ĩ ñaquĩ Cristo. Jeyaro masa ĩna tʉo masitoni wadirʉ ñaquĩ Cristo. Ito bajigʉ ñari ñajediro masa ĩna tʉo masitoni wadiñi ĩ. ");
INSERT INTO myy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Adi macãrʉcʉ̃ro rujearoto riojʉajʉ ñacãyijʉ ĩ Dios oca gotiri masʉ. Ĩ́na sʉoriti adi macãrʉcʉ̃rojʉ Dios ĩ menire ñabojarocati adi macãrʉcʉ̃ro gãna masa ĩre ti masibisijarã maji. ");
INSERT INTO myy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Adi macãrʉcʉ̃ro ĩ rujeore ñabojarocati ĩ ñarãjʉa ĩre boca ãmibisijarã. ");
INSERT INTO myy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gãjerã coriarãma ĩre queno boca ãmiyijarã. Ito yicõri ĩre tʉorʉ̃nʉyijarã ĩna. Ito bajiri ĩre ĩna tʉorʉ̃nʉjare Dios rĩa ĩna ñaroca yiyijʉ Cristo. “Yʉre masogʉ̃ yiguĩji Cristo”, yi tʉorʉ̃nʉrãre Dios rĩa ĩna ñaroca yiyijʉ Cristo. ");
INSERT INTO myy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ito bajiri Dios rĩati ñama ĩna ĩja. Ĩre boca ãmicõri ĩ rĩa ñama ĩja. Masa ĩna rĩa cʉtirona ĩna yiro bajiro meje ña. Dios rĩati ĩna ñaroca Cristo ĩ yiana ñama ĩna. Ito bajiri Dios rĩati ñama ĩna ĩja. Ito yicõri Dioti ñami ĩna Jacʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Dios oca gotiri masʉ manire bajiroti rujʉ cʉticõri, mani wato ña ucuquĩ. Ĩti ñami masare ti maigʉ̃, ito yicõri riojo gotigʉ. Ĩ, Dios Macʉ sĩgʉ̃ ñagʉ̃re ticõri, “Ĩti ñami busurise rʉcogʉ. Ĩ Jacʉre bajiroti rẽtoro ñasagʉ ñami ĩ cʉni”, yi tʉoĩa mani. ");
INSERT INTO myy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan idé guri masʉ, Cristore bʉsi ĩsigʉ̃ ado bajiro masare gotiquĩ ĩ ejaroca: —Ãni gaye gotisʉogʉ, ado bajiro mʉare goticʉ yʉ. “Yʉ berojʉa sĩgʉ̃ ejagʉ yiguĩji. Yʉ berojʉa ejagʉ ñabojagʉti, yʉ rẽtoro ñasagʉ ñagʉ̃ yiguĩji ĩ. Yʉ riojʉajʉ ñacãñi ĩ”, yi goticʉ yʉ, yiquĩ Juan idé guri masʉ, masare gotigʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mani jeyaro queno ĩ yirise boca ãmisotia mani. Manire ĩ queno yiado bajiroti manire queno yitĩñami maji. ");
INSERT INTO myy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés ñayorʉna sʉoriti bʉcʉrã ĩna rotire gaye manire ejayija. Dios manire ĩ ti mairise gayeama, ĩ oca riojo ñasarise cʉni, Cristona sʉoriti manire ejayija. ");
INSERT INTO myy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sĩgʉ̃jʉa Diore tigʉ maquĩji. Ĩ Macʉ sĩgʉ̃ti ĩre tiguĩji. Ĩ ñaguĩji ĩ Jacʉ robo bajiroti corocõ tʉoĩagʉ̃. “Ito bajiro bajigʉ ñami Dios”, mani yi masitoni, manire riasogʉ ñami Cristo. ");
INSERT INTO myy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Paia mesare ito yicõri levita masare cʉni cõañi judio masa Jerusalén gãna. “¿Ñimʉ ñati mʉ?” Juan idé guri masʉre ĩna yi seniĩatoni ĩnare cõañi ĩna. ");
INSERT INTO myy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ito bajiro ĩre ĩna seniĩaja tʉocõri, riojo ĩnare cʉdiquĩ Juan idé guri masʉ: —Yʉ, Cristo Dios ĩ cõarʉ meje ña yʉ, yiquĩ Juan ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mʉcana tʉdi ĩre seniĩa quenocã ĩna: —¿Ito yijama ñimʉjʉa ñasati mʉ? ¿Elías, Diore goti ĩsiri masʉjʉa ñatite mʉ? yi seniĩacã ĩna ĩre. —Ĩ meje ña yʉ, yiquĩ ĩ ĩnare. Ito yija mʉcana tʉdi ĩre seniĩacã ĩna: —¿Mʉti ñati Diore goti ĩsiri masʉ, “Ejagʉ yiguĩji”, ĩna yicacʉ? yi seniĩacã ĩna Juan idé guri masʉre. —Ĩ meje ña yʉ, yiquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ito ĩ yija tʉocõri, ado bajiro yicã ĩna: —¿Ñimʉjʉa ñasati mʉ? yicã ĩna. Gʉare roticõarãre oca ãmi tʉdi wa ãmoa gʉa. Mʉmasiti mʉ gaye, ¿no bajiro gʉare gotiati mʉ? yi seniĩacã ĩna Juan idé guri masʉre. ");
INSERT INTO myy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ĩna ito yija tʉocõri, ado bajiro cʉdiquĩ ĩ ĩnare: —Yʉti ña, yucʉ manojʉ masare oca sẽoro goti ucugʉ: “Mani Ʉjʉ ĩ ejaroto riojʉa, mʉa ñeñaro yirise jidicãcõri ĩre ña yucãña”, yi goti yuri masʉ ña yʉ. Isaías ñayorʉ, Diore goti ĩsiri masʉ, ĩ yiado bajiroti yi gotia yʉ cʉni, yiquĩ Juan idé guri masʉ ĩre oca seniĩacãnare. ");
INSERT INTO myy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juan idé guri masʉ tʉ oca seniĩarã ejacãna, ĩna ñañi fariseo gaye tʉoĩarã ĩna cõana. ");
INSERT INTO myy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Mʉcana tʉdi ĩre seniĩacã ĩna: —Ito yija, Cristo meje ñabojagʉti, Elías meje ñabojagʉti, Diore goti ĩsiri masʉ meje ñabojagʉti, ¿no yija masare idé guati mʉ? yi seniĩacã ĩna Juan idé guri masʉre. ");
INSERT INTO myy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ĩna ito yija tʉocõri, ado bajiro cʉdiquĩ ĩ: —Yʉ masare idé guja, idenagoti idé gua yʉ. Sĩgʉ̃ ñami ado mani wato mʉa masibicʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yʉ rẽtoro ñasagʉ ñami ĩ. Yʉ bero ejarʉ ñabojagʉti, yʉ rẽtoro ñasagʉ ñami ĩ. Ĩre bajiro bajigʉ meje ña yʉama. Yʉ rẽtoro quenagʉ̃ ĩ ñajare ĩ rãca corocõ ñado ma yʉ. Ito bajiro quenagʉ̃ meje ñacõri ĩ ya gʉboco õja masibea yʉ, yiquĩ Juan idé guri masʉ ĩre seniĩacãnare. ");
INSERT INTO myy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jordán wame cʉtirisa tʉjʉ masare Juan idé guroca ito bajiro rẽtacʉ. Betania wame cʉtirijʉ ñacʉ itijʉ, Jordán tʉnima. ");
INSERT INTO myy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ito bero gaje rʉmʉ, Jesús gʉa tʉjʉ ĩ wadija tiquĩ Juan idé guri masʉ. Ito bajiri masare ado bajiro gotiquĩ ĩ: —Tiya mʉa, ãniti ñami Dios yagʉ, Oveja Macʉ robo bajigʉ. Masa ĩna ñeñaro yirise waja yi ĩsirocʉ ñari Oveja Macʉ robo bajiro bajigʉ ñami ĩ. Ĩti ñami adi macãrʉcʉ̃ro gãnare ĩna ñeñaro yirisere waja yi ĩsiri masʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ĩ gaye gotisʉogʉ, ado bajiro mʉare goticʉ yʉ: “Yʉ berojʉa sĩgʉ̃ ejagʉ yiguĩji. Yʉ berojʉa ejagʉ ñabojagʉti yʉ rẽtoro ñasagʉ ñagʉ̃ yiguĩji ĩ. Yʉ riojʉajʉ ñacãñi ĩ”, yi goticʉ yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yʉ cʉni, “Ĩ ñaguĩji”, yi masibiticʉ maji. Ado ña yʉ masare idé gugʉ. “Ãni ñami Dios ĩ cõarʉ”, mani ñarã cʉni ĩna yi masitoni, yi gotia yʉ, yiquĩ Juan idé guri masʉ Israel sita gãnare. ");
INSERT INTO myy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Gaje ado bajiro masare gotiquĩ ĩ: —Espíritu Santo bujare bajigʉ ruji wadicõri, ĩ joejʉre ĩ quedi jeaja ticʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ĩre tibojagʉti, “Ĩti ñaguĩji Cristo”, yi masibiticʉ yʉ maji. Yʉre masare idé gu roticacʉ, yʉre ĩ gotigore tʉoĩa bʉjacõri, “Ãniti ñami Cristo”, yi masicʉ yʉ ĩja. Ado bajiro yʉre gotiquĩ ĩ yʉre idé gu roticacʉ: “Sĩgʉ̃re Espíritu Santo ĩ quedi jeaja, mʉ tija, Ĩti ñami masare Espíritu Santo queo sãgʉ̃”, yiquĩ yʉre idé gu roticacʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ĩre tigorʉ ña yʉ. Ito bajiri, “Dios Macʉ ñami ĩ”, yi masia yʉ, yi gotiquĩ Juan idé guri masʉ, masare gotigʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ito bero gaje rʉmʉ ito ñacʉ gʉa mʉcana. Jʉ̃arã ñacʉ gʉa Juan idé guri masʉ rãca riasotirã. ");
INSERT INTO myy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús ĩ rẽta waja ticõri, ado bajiro gʉare gotiquĩ Juan idé guri masʉ: —Tiya, ãniti ñami Dios yagʉ Oveja Macʉ robo bajiro bajigʉ, mani ñeñaro yirise waja yi ĩsiri masʉ, yiquĩ Juan gʉare. ");
INSERT INTO myy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ito bajiro ĩ yija tʉocõri, Jesure sʉya wacʉ gʉa ĩja. ");
INSERT INTO myy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ito bajiro gʉa ĩre sʉya waja jʉda ticõri, ado bajiro yiquĩ Jesús: —¿Ñere ãmarã yati mʉa? yiquĩ Jesús gʉare. —Riasori masʉ, ¿nojʉ ñati mʉ ñaro? yi seniĩacʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Adojʉ tirã waya maji, yi cʉdiquĩ Jesús gʉare. Ito ĩ yijare ĩre sʉya wacõri, ĩ ñarojʉ ticʉ gʉa ĩja. Ito bajiri iti rʉmʉ ĩ rãcati ñarã rãiocoacʉ gʉa. Yucʉ wecacõ tʉjaquĩ ũmacañi. ");
INSERT INTO myy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan idé guri masʉre tʉocõri, yʉ rãca Jesure sʉya wacʉ ñaquĩ Andrés. Ĩ ñaquĩ Simón Pedro ocabaji. ");
INSERT INTO myy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jesure ti masicõri, ĩ rĩjorʉ Simónre gotirocʉ ãmagʉ̃ waquĩ ĩ. Ĩ rĩjorʉ tʉ ejacõri, ado bajiro gotiyijʉ Andrés: —Dios ĩ cõarʉ Cristore bʉjacõa yʉ, yi ejayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ito yija, Simónre gʉa tʉjʉ ãmi wadiquĩ Andrés. Simónre ticõri, ado bajiro yiquĩ Jesús: —Mʉ ña Simón, Jonás macʉ. Ito bajibojarocati Pedro wame cʉtigʉ yigʉja mʉ ĩja. Gʉ̃tagã yireoni ña iti, yiquĩ Jesús Simónre. ");
INSERT INTO myy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ito bero gaje rʉmʉ, Galilea wame cʉtirita tʉjʉ waquĩ Jesús. Itojʉ ejacõri, Felipe wame cʉtigʉre bʉjaquĩ. Ito yicõri ado bajiro ĩre yiquĩ Jesús: —Yʉ rãca waya, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida wame cʉtiri cʉto gagʉ ñaquĩ Felipe. Pedro ocabaji Andrés cʉni ĩna ñaro ñacʉ ito. ");
INSERT INTO myy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesure tʉocõri, Natanaelre ãmagʉ̃ waquĩ Felipe. Ĩre bʉjacõri, ado bajiro ĩre gotiyijʉ ĩ: —Moisés ñayorʉ Dios ĩ rotire ucagʉ, ĩ uca gotirʉre bʉjacõmʉ yʉ ĩja. Diore goti ĩsiri masa ĩna ucarʉre bʉjacõmʉ yʉ ĩja. Ĩ ñami Jesús, Nazaret gagʉ, José wame cʉtigʉ ĩ masorʉ, yiyijʉ ĩ Natanaelre gotigʉ. ");
INSERT INTO myy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ĩ ito yija tʉocõri, ado bajiro seniĩayijʉ Natanael: —¿Nazaret gagʉ ĩ ñaja quenagʉ̃ ñaguĩjida mʉca? yi seniĩayijʉ ĩ Felipere. —Waya tito, yiyijʉ Felipe Natanaelre. Ito bajiro yicõri gʉa tʉjʉ ejacã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael ĩ ejaja ticõri, ado bajiro yiquĩ Jesús: —Sĩgʉ̃ Israel sita gagʉgoro ejaquĩ ado. Ĩre rʉore ma, yiquĩ Jesús, Natanaelre ticõri. ");
INSERT INTO myy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ito ĩ yijare: —¿No bajiro yʉre ti masiati mʉ? yi seniĩaquĩ ĩ Jesure. —Felipe mʉre ĩ jiroto riojʉa, higuera wame cʉtiricʉ roca mʉ rʉ̃gõroca tibʉ yʉ mʉre, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ito ĩ yija tʉocõri: —Yʉre Riasogʉ, mʉti ña Dios Macʉ, ito yicõri gʉa Israel sita gãna Ʉjʉ ña mʉ, yiquĩ Natanael Jesure. ");
INSERT INTO myy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ito ĩ yija tʉocõri, ado bajiro cʉdiquĩ Jesús ĩre: —Higuera wame cʉtiricʉ roca mʉ rʉ̃gõroca mʉre tibʉ yʉ, ¿mʉre yʉ yija, yʉre tʉorʉ̃nʉati mʉ? Gaje iti rẽto bʉsaro bajirise tigʉ yigʉja mʉ, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gaje ado bajiro gotiquĩ Jesús gʉare: —Riti mʉare gotia yʉ. Macãrʉcʉ̃ro soje iti janaroca, Yʉ Masa Rĩjorʉ tʉjʉ, ángel mesa yʉ tʉjʉ ĩna rujija, ĩna mʉjaja cʉni tirã yirãji mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jʉa rʉmʉ bero Galilea sita Caná wame cʉtiri cʉtojʉ ãmo siare ñaro wado yicʉ. Jesús jaco cʉni ñacõ itojʉ. ");
INSERT INTO myy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Gʉa Jesús rãca riasotirãre cʉni basa gʉare goticã ĩna. Ito bajiri gʉa cʉni Jesús rãca ñacʉ itojʉ. ");
INSERT INTO myy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ito bajiro gʉa idi ñaroca, ʉyé ide jedicoacʉ. Ito bajija ticõri, Jesús jaco ado bajiro yicõ ĩre: —Ʉyé ide jedicoajʉ ĩja, yicõ iso Jesure. ");
INSERT INTO myy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iso ito yija tʉocõri: —¿Cana, no yija yʉre iti gotiati mʉ? Tiyamani yʉ ĩoroti ejabea maji, yiquĩ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ito bajiro ĩ yija tʉocõri, iori masare ado bajiro yicõ iso: —Jeyaro ĩ rotiro bajiroti cʉdiya, yicõ iso ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Itojʉ ñacʉ ide gõnaradʉri, gʉ̃tana ĩna menira sotʉri. Coga ãmojeno sotʉri ñacʉ. Ide gõnacõri bʉcʉrã ĩna rotiado robo bajiro ĩna coesotiri sotʉri ñacʉ iti sotʉri. Cincuenta, setenta cʉni ide coari dajarise ñacʉ iti sotʉri. ");
INSERT INTO myy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iori masare ado bajiro rotiquĩ Jesús: —Adi sotʉrire ide jio dajoya, yiquĩ Jesús ĩnare. Ito ĩ yija tʉocõri, iti sotʉri ñarocõti jio dajocã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ĩna cʉdija ticõri, ado bajiro rotiquĩ Jesús ĩnare: —Jabeto gõnacõri, basa ʉjʉre ĩsitẽña mʉa, yiquĩ ĩ ĩnare. Ĩ rotiro bajiroti yicã ĩna. Basa ʉjʉre ide iocã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Iti ide ĩ boca idija, ʉyé ideti ñacoacʉ iti ĩja. “Ito gaye ñaroja”, yi masibitiquĩ ĩ. Iori masa riti masicã ĩna ãmiadore. Iti idicõri, mame manojo cʉtigʉre ji ñucaquĩ basa ʉjʉ. ");
INSERT INTO myy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ĩ ejaroca ado bajiro ĩre yiquĩ ĩ: —Gãjerãma, basa ĩna menisʉoja, quenarise iosʉocã. Jairo masa ĩna idija bero quenasabiti ide iocã ĩna. Mʉáma gaje idire rẽtoro quenarise seoyija mʉ. Adocãta mʉ iorise quenarise ña, yiquĩ basa ʉjʉ mame manojo cʉtigʉre. ");
INSERT INTO myy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iti ñacʉ tiyamani Jesús ĩ ĩosʉore Galilea sita, Caná wame cʉtiri cʉtojʉ. Iti ticõri, rẽtoro ĩ masirise ĩ ĩoja, ticʉ gʉa, ĩ rãca riasotirã. Ito bajiri ĩre tʉorʉ̃nʉcʉ gʉa ĩja. ");
INSERT INTO myy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Iti basa rẽtaja bero Capernaum wame cʉtiri cʉtojʉ wacʉ gʉa Jesús rãca. Ĩ jaco, gʉa ĩ rãca riasotirã, ĩ ñarã cʉni ĩ rãca wacʉ gʉa. Itojʉ yoa bʉsari ña ucucʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judio masa pascua basa ĩna meniroti rʉmʉ riojʉaca rʉmʉ Jerusalénjʉ wacʉ gʉa Jesús rãca. ");
INSERT INTO myy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Itojʉ Dios ya wi ejacõri, ta wecʉa, oveja, buja ĩsiri masare ti bʉjaquĩ Jesús. Ito yicõri niyeru wasoari masa ĩna rujiadojʉ, ĩna rujija ti bʉjaquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ito bajiro ĩna yi ñaja ticõri, bajera ma meniquĩ Jesús. Ito bajiro yicõri, ĩna ya wecʉa rãca, ĩna ya oveja rãca Dios ya wi ñarãre bucõaquĩ Jesús. Niyeru wasoari masa ya niyeru cujirire ware batecõquĩ ĩ. Ĩna ya casabori gaye tujʉda queoquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ito yicõri, buja ĩsiri masare ado bajiro yiquĩ Jesús: —Ãna mʉa ĩsironare ãmi budi wasa mʉa. Yʉ Jacʉ ya wire gajeoni ĩsira wi godo weobesa mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ito bajiro ĩ yija tʉocõri, Dios oca tuti gotire tʉoĩa bʉjacʉ gʉa ĩ rãca riasotirã: “Bʉto mʉ ya wire tʉoĩa rʉ̃cʉbʉoa yʉ”, yi Dios oca tuti gotire gaye tʉoĩa bʉjacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ito yija ito ñarã judio masa Jesure seniĩacã: —¿No bajiro ĩogʉ̃ yigʉjada mʉ, “Dios ĩ rotirena waibʉcʉrã ĩsiri masare bucõa mʉ”, gʉa yitoni? yi seniĩacã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ĩna ito yija tʉocõri, ado bajiro cʉdiquĩ Jesús ĩnare: —Adi Dios ya wire mʉa ruyurioja, ʉdia rʉmʉ beroti mʉcana tʉdi iti wire jõrojogʉ yigʉja yʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ito ĩ yija tʉocõri: —Cuarenta y seis rodori sejayijarã ĩna adi wi menirã. Mʉáma, “Ʉdia rʉmʉ beroti jõrojogʉja”, ¿yire masiati mʉ? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ito bajiro Dios ya wire Jesús ĩ tʉoĩa bʉsija, ĩ ya rujʉ gayere bʉsigʉ yiñi Jesús. ");
INSERT INTO myy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iti Jesús ĩ bʉsigore mʉcana tʉdi Jesús ĩ catirocajʉ, ĩ bʉsigore tʉoĩa bʉjacʉ gʉa, ĩ rãca riasotigoana. Ito bajiri Dios oca ĩ bʉsigore cʉni tʉorʉ̃nʉcʉ gʉa ĩja. ");
INSERT INTO myy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusalén ñacõri, pascua basa ĩna meniroca jaje tiyamani masare ĩoquĩ Jesús. Ito bajiro ĩ yijare, jãjarã masa ĩre tʉorʉ̃nʉcã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","“Masa jeyaro ñeñaro yirã ñama”, yi ti masicõri, ĩnare queno tʉorʉ̃nʉsabitiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Masa jeyaro ĩna ya ʉsijʉ ĩna tʉoĩarise ti masigʉ̃ ñaquĩ Jesús. “Ito bajiro bajirã ñama masa”, yi tʉoĩa masicãñi Jesús. ");
INSERT INTO myy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Sĩgʉ̃ fariseo gaye tʉoĩagʉ̃, Nicodemo wame cʉtigʉ ñayijʉ. Judio masa rãca ñasagʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ĩ Nicodemo, ñamijʉ Jesure tigʉ ejayijʉ. Ĩ tʉ ejacõri, ado bajiro yiyijʉ ĩ Jesure: —Riasori masʉ, “Gʉare riasotoni mʉre cõañi Dios”, yi tʉoĩa gʉa mʉre. Mʉ rãca Dios ĩ ñajare tiyamani ĩo masia mʉ. Ñimʉjʉa gãji tiyamani mʉ ĩoro bajiro yibiquĩji, Dios ĩ rãca ñabeja, yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","—Riti mʉre ado bajiro gotia yʉ. No mʉcana tʉdi rujea quenobicʉ Dios ĩ rotirojʉ tibiquĩji, yiyijʉ Jesús Nicodemore. ");
INSERT INTO myy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ito ĩ yija tʉocõri, ado bajiro Jesure seniĩayijʉ Nicodemo: —¿No bajiro ʉ̃mʉgʉ̃ jaigʉ ñacãbojagʉti mʉcana tʉdi rujea quenoguĩjida? ¿Jacore sãjacõri, mʉcana tʉdi rujea quenoguĩjida? yi seniĩayijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","—Riti mʉre gotia yʉ. Masa jeyaro jacona rujearãji. Ito bajibojarocati Espíritu Santona rujeabicʉ Dios ĩ rotirojʉ ejabiquĩji. ");
INSERT INTO myy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Masana rujeana, masati ñarãji. Espíritu Santona rujeana ĩ ya ʉsina catitĩñarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“No Dios tʉjʉ eja ãmoja, mʉcana tʉdi rujea quenoja quena”, ya yʉ mʉre. Ito bajiro yʉ yija, tʉo ʉcabesa mʉ. ");
INSERT INTO myy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mino iti ãmoro bajiroti wẽa ñucaro yiroja. Mino iti udija tʉoa mani. Ito bajibojarocati, “Ito gaye wadiroja, ito waroja”, yi masibea mani. Ito bajiroti bajigʉ ñami Espíritu Santo cʉni. “Ñimʉjʉare itocõ rujea quenogʉ̃ yiguĩji Espíritu Santo”, yi masibea mani, yiyijʉ Jesús Nicodemore. ");
INSERT INTO myy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ito yija mʉcana tʉdi seniĩa quenoyijʉ Nicodemo: —¿No bajiro bajirojada iti? yi seniĩayijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ado bajiro ĩre cʉdiyijʉ Jesús: —Israel sita gãnare riasori masʉ ñasagʉ ña mʉ. ¿Ito bajibojagʉti adi gayeama masibeati mʉ? ");
INSERT INTO myy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Riti mʉre gotia yʉ. Yʉ masirisere bʉsia yʉ. Ito yicõri yʉ tigore mʉre gotia yʉ. Ito bajibojarocati yʉ gotirisere queno tʉorʉ̃nʉbea mʉ. ");
INSERT INTO myy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Adi sitajʉ gaye yʉ bʉsirise mʉ tʉorʉ̃nʉbeja, Dios ĩ ñarojʉ gaye yʉ bʉsija cʉni, tʉorʉ̃nʉbicʉ yigʉja mʉ, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gaje ado bajiro gotiyijʉ Jesús: —Sĩgʉ̃ ũmacʉ̃jʉ mʉjagorʉ maquĩji. Yʉ sĩgʉ̃ti ña ũmacʉ̃jʉna ruji wadicõri mʉcana tʉdi itojʉ mʉja warocʉ. Yʉ ña Masa Rĩjorʉ. Yʉti ña itojʉ mʉja warocʉ. ");
INSERT INTO myy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jane mejejʉ Moisés ñayorʉ yucʉ manojʉ ĩna ña ucuroca yucʉ joe ãñare jeoyijʉ, masa ĩna ti mʉotoni. Ãñare ti mʉocõri ãña cuni ecoana ñabojarãti godabisijarã ĩna. Ito bajiroti yʉ cʉni Masa Rĩjorʉ, yucʉna mʉo ecogʉ yigʉja. ");
INSERT INTO myy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","No yʉre tʉorʉ̃nʉgʉ̃ti godabicʉ yiguĩji catitĩñagʉ̃ yiguĩji, yiyijʉ Jesús Nicodemore gotigʉ. ");
INSERT INTO myy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Ñajediro masare bʉto maiyijʉ Dios. Ito bajiri ĩ Macʉ sĩgʉ̃ ñagʉ̃re cõayijʉ, masare ĩ goda ĩsitoni. No Jesure tʉorʉ̃nʉgʉ̃ti godabiquĩji, catitĩñagʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Adi macãrʉcʉ̃ro gãnare ĩ ruyuriotoni meje ĩ Macʉre cõayijʉ Dios. Ado robojʉa bajiyijʉ. Masare masojaro yirocʉ ĩ Macʉre cõayijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’No ĩ Macʉre tʉorʉ̃nʉgʉ̃re waja senibicʉ yiguĩji Dios. No Dios Macʉ sĩgʉ̃ ñagʉ̃re tʉorʉ̃nʉbicʉ, ĩ tʉorʉ̃nʉbitire waja ĩre ruyuriogʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Yʉ Macʉre tʉorʉ̃nʉmenare ĩnare ruyuriogʉ yigʉja yʉ”, yicãñi Dios. Ado bajiro bajia: Busurise rʉcogʉ ñari masa ĩna tʉo masiroca yi masiami Jesús. Ito bajiri adi tuti ejacõri, “Ñeñaro yirã ña mani”, masa ĩna yi masiroca yiñi Jesús. Bʉto ñeñaro yi jairã ñari busurise rẽtoro rãitĩarisere ãmoyijarã ĩna. Quenarise yi ãmobiticõri ñeñarisejʉare riti bʉto yi ãmoyijarã ĩna. Ito bajiri Jesure ĩna tʉorʉ̃nʉbitire waja jeame ʉ̃jʉrojʉ ĩnare cõagʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ñeñaro yirã ñarocõti busurise ti teama ĩna. Ito bajiri busurise rʉcogʉ yʉ ñajare, yʉre boca ãmimenaji ĩna. Ĩna ñeñaro yirise goabe yirona yʉre boca ãmimenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Oca riojo gotire cʉdirãma, yʉ busurise rʉcogʉre boca ãmirã yirãji ĩnama. Ito bajiri ĩna queno cʉdija ticõri, “Ĩna queno yiroca yami Dios”, yi ti masirã yirãji gãjerã, yiyijʉ Jesús Nicodemore. ");
INSERT INTO myy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ito yija bero, gʉa Jesús rãca riasotirã ĩ rãca Judea sitajʉ wacʉ. Itojʉ yoa bʉsari ĩ rãca masare idé gu ñacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan idé guri masʉ cʉni Salim cʉto sõjʉa Enón wame cʉtiri cʉtojʉ masare idé gu ñayijʉ ĩ cʉni. Itojʉ ide jairo iti ñajare, masa jãjarã idé gu rotirã ejayijarã. Ito bajiri ĩnare idé guyijʉ Juan. ");
INSERT INTO myy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ito bajiro rẽtayijʉ, Juan idé guri masʉre ĩna tubiaroto riojʉa. ");
INSERT INTO myy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ito baji ñaroca coriarã Juan idé guri masʉ rãca riasotirã, sĩgʉ̃ judio masʉ rãca gãmeri bʉsi ñayijarã ĩna. “Bʉcʉrã ĩna rotiado bajiro mani cʉdija ticõri, mani ñeñaro yirisere coegʉ yiguĩji Dios”, yi gãmeri bʉsi ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ĩna gãmeri bʉsija bero Juan tʉ ejacõri ado bajiro seniĩayijarã ĩna: —Gʉare riasogʉ, ¿Jordán wame cʉtirisa sidʉja mʉ tigorʉre masiati mʉ? Ĩ gayere gʉare bʉsibʉ mʉ. Adi rʉmʉri bʉto masare idé guguĩji. Ito bajiri masa ĩre riti sʉyarãji ĩna, yi gotiyijarã ĩna Juan idé guri masʉre. ");
INSERT INTO myy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ĩna ito yija tʉocõri: —Ñe manoti ñarãji masa, Dios ĩ ĩsibeja. Dioti ñami masa ĩna moaroti cũri masʉ. ");
INSERT INTO myy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Yʉ meje ña Cristo. Ĩ ejaroto riojʉa Dios ĩ cõa yurʉ ña yʉ”, yiari mʉare goticãcʉ yʉ. “Ito bajiro gotiquĩ Juan gʉare”, yi masirã ña mʉa, yiyijʉ Juan ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Goti masiore ocana ado bajiro gotiyijʉ Juan: “Ãmo siari rʉmʉ isore ñiagʉ̃, iso manʉjʉ ñarocʉ ñaguĩji ĩ. Ĩ, ãmo siagʉ baba, ĩ ãmo siare gaye ĩ tʉoja bʉto wanʉ quenagʉ̃ yiguĩji ĩ. ‘Masare idé gugʉ yiguĩji’, mʉa yija tʉocõri, itire bajiroti wanʉ quena yʉ cʉni. ");
INSERT INTO myy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yʉ rẽtoro ñasagʉ ĩ ñare ãmoa yʉ. Yʉre ĩna rʉ̃cʉbʉoro rẽto bʉsaro masa ĩre rʉ̃cʉbʉore ãmoa yʉ”, yiyijʉ Juan ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ũmacʉ̃jʉ gagʉ wadirʉ, ĩ ñami ñasagʉ. Ñimʉ gãji ĩ rẽtoro ñasagʉ maquĩji. Adi macãrʉcʉ̃rojʉ rujearʉ ĩ ñami adi macãrʉcʉ̃ro gagʉ. Ito bajiri adi macãrʉcʉ̃ro gaye bʉsiami ĩ. Ũmacʉ̃jʉ gagʉ wadirʉama ĩ ñami ñasagʉ. ");
INSERT INTO myy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ĩ tigore, ĩ tʉogore cʉni bʉsiami ĩocʉ̃. Ito bajibojarocati, noajʉa queno tʉorʉ̃nʉbeama ĩ bʉsirisere. ");
INSERT INTO myy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","No ĩre tʉorʉ̃nʉgʉ̃ti, “Queno riojo yigʉ ñami Dios”, yi masiguĩji ĩocʉ̃. ");
INSERT INTO myy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dios ĩ cõarʉama Dios ocareti gotiguĩji. Jabetacã meje ĩ ya ʉsi queo sãgʉ̃ yiguĩji Dios ĩre. ");
INSERT INTO myy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ĩ Macʉre maigʉ̃, “Jeyaro rotijaro ĩ”, yirocʉ Cristore cũñi mani Jacʉ Dios. ");
INSERT INTO myy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","No Dios Macʉre tʉorʉ̃nʉgʉ̃ti catitĩñagʉ̃ yiguĩji. Ĩ Macʉre tʉorʉ̃nʉbicʉama catitĩñare bʉjabicʉ yiguĩji. Ĩocʉ̃reama bʉto ñeñaro ĩ tõbʉjaroca yigʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","“Juan rẽto bʉsaro masare idé guami Jesús, ito yicõri ĩre jãjarã bʉsa sʉyama ĩna”, yire gaye masiñi fariseo gaye tʉoĩarã. ");
INSERT INTO myy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Quenogoroama Jesús meje masare idé guquĩ. Gʉa Jesús rãca riasotirãjʉ masare idé gucʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo gaye tʉoĩarã ĩna masija tʉocõri, Judea sitare wacoacʉ gʉa Jesús rãca. Ito yicõri Galilea sitajʉ wacʉ gʉa mʉcana. ");
INSERT INTO myy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ito warã riti Samaria sitajʉ ejacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ito rẽta wacõri, Sicar wame cʉtiri cʉtojʉ ejacʉ gʉa. Iti cʉto Jacob ñayorʉ ĩ macʉ Josére ĩsira sita tʉ ñacʉ iti cʉto. ");
INSERT INTO myy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Itojʉ ñacʉ Jacob ñayorʉ ya ide goje. Boga wadirʉ ñari iti goje tʉ eja rũjũquĩ Jesús. Ʉ̃mʉa gʉdareco ejarecõro ñacʉ. ");
INSERT INTO myy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Gʉama ĩ rãca riasotirã cʉtojʉ wacʉ bare waja yirã warã. Itojʉ Jesús ĩ rujiroca, sĩgõ Samaria sita gago ide gõnagõ ejayijo. Iso ejaja ticõri, isore ado bajiro ide seniyijʉ Jesús: —Ide ioya yʉre, yiyijʉ ĩ isore. ");
INSERT INTO myy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ide ĩ senija tʉocõri, ado bajiro yiyijo Samaria sita gago: —¿Mʉ no yija judio masʉ ñabojagʉti, yʉ Samaria sita gagore ide seniati mʉ? yiyijo iso Jesure. Samaria sita gãna rãca judio masa rãca queno baba cʉtibiticõri, ito bajiro yiyijo iso. ");
INSERT INTO myy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iso ito bajiro yija tʉocõri: —Dios ĩ ĩsiroti mʉ masija, ito yicõri, “Ĩ ñami yʉre ide senigʉ̃”, mʉ yi masija, yʉjʉare ide seniboroja mʉ. Ito bajiro mʉ yija, ide catitĩñare gaye mʉre ĩsiborʉja yʉ, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ito ĩ yijare: —Ñena ide gõnare ma mʉre. Jubejʉ ña ide goje. ¿Nojʉ gaye yʉre ide catitĩñare gaye ĩsigʉ̃ yigʉjada mʉ? ");
INSERT INTO myy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mani riojʉa gagʉ Jacob ñayorʉ adi goje ide gojere cũñi ĩ. Ĩ cʉni idiñi iti goje gaye. Ĩ rĩa cʉni idiñi. Ĩ ya ecana cʉni idiñi. ¿Ĩ rẽto bʉsaro ñasagʉ ñati mʉ? yiyijo iso Jesure. ");
INSERT INTO myy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ito bajiro iso yija tʉocõri, ado bajiro cʉdiyijʉ Jesús isore: —No adi goje gaye ide idibojarãti, mʉcana tʉdi idi ãmocoarã yirãji. ");
INSERT INTO myy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","No ide catitĩñare gaye yʉ ioana, mʉcana tʉdi idi ãmomena yirãji. Yʉ ĩnare ide iorise ide ũmaburi goje robo bajiro ũmabato ñaro yiroja, ĩna catitĩñatoni, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ito ĩ yija tʉocõri: —Yʉ Ʉjʉ, iti gaye ide ãmoa yʉ cʉni, mʉcana tʉdi ide yʉ idibe yiroco. Ito yicõri mʉcana tʉdi adi goje gõnagõ wadibe yiroco, yiyijo iso Jesure. ");
INSERT INTO myy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ito yija, ado bajiro yiyijʉ Jesús isore: —Wasa, mʉ manʉjʉre jitẽña, ito yicõri adojʉ waya, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ito ĩ yija ado bajiro cʉdiyijo iso: —Manʉjʉ maco ña yʉ, yi cʉdiyijo iso. —“Manʉjʉ maco ña yʉ”, mʉ yirise riti ya mʉ. ");
INSERT INTO myy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Co dʉjamocõ ʉ̃mʉa rãca ñagoro ña mʉ. Ito bajicõri adocãta mʉ rãca ñagʉ̃, mʉ manʉjʉ meje ñami ĩ. Ito bajiri, “Manʉjʉ maco ña yʉ”, mʉ yiriseama riti ya mʉ, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ito ĩ yija tʉocõri, ado bajiro yiyijo iso ĩre: —Yʉ Ʉjʉ, jeyaro masigʉ̃ocʉ̃ ña mʉ. “Diore goti ĩsiri masʉ ñami ãni”, ya yʉ mʉre. ");
INSERT INTO myy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Gʉa Samaria sita gãna ñicʉsabatia, adi burojʉ Diore rʉ̃cʉbʉoñi. Mʉa judio masama, “Jerusalénjʉ Diore rʉ̃cʉbʉoja quena”, ya mʉáma, yiyijo iso Jesure. ");
INSERT INTO myy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iso ito yijare: —Yʉre tʉorʉ̃nʉña romio mʉ. Co rʉmʉ Diore mʉa rʉ̃cʉbʉoroti rʉmʉ ejaro yiroja. Adi buro meje, ito yicõri Jerusalénjʉ wamenati Diore rʉ̃cʉbʉo ñarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉa Samaria sita gãna, mʉa rʉ̃cʉbʉorocʉre queno masibea mʉa maji. Gʉama, gʉa rʉ̃cʉbʉorocʉre queno masia. Gʉa judio masana sʉoriti masare masogʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ija ñaro yiroja, ito yicõri adocãta cʉni ña, riojo Diore masa ĩna rʉ̃cʉbʉo ãmosaja, ĩna ya ʉsijʉ ĩre rʉ̃cʉbʉorã yirãji ĩna. Ito bajiro ĩre rʉ̃cʉbʉore ãmoami mani Jacʉ. ");
INSERT INTO myy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Rujʉ meje ñami Dios. Ʉsiti ñami ĩ. Ito bajiri Dios ĩ ãmoro bajiro riti Espíritu Santo ĩ ejabʉarisena Diore mani rʉ̃cʉbʉoja quena, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ito ĩ yija tʉocõri, ado bajiro yiyijo iso: —Dios ĩ cõarʉ, Mesías ejagʉ yiguĩji, yi tʉoĩa yʉ. Ĩ ñaguĩji Cristo ĩna yigʉ. Ĩ ejagʉjʉ, gʉare queno goti rẽtobugʉ yiguĩji, yiyijo iso Jesure. ");
INSERT INTO myy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iso ito yija: —Yʉ adocãta mʉre bʉsigʉ, ĩti ña, yiyijʉ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ito bajiro ĩ yi ñaroca, tʉdi ejacʉ gʉa ĩ rãca riasotirã. Romio rãca ĩ bʉsija ticõri, jabeto ti ʉcacʉ gʉa. Ito bajibojarocati, “¿Ñe gaye ĩre ãmoati mʉ? ¿Ñe gaye isore seniĩati mʉ?” yi seniĩabiticʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ito yirocati ide gõnaradʉ jidi rojocõri cʉtojʉ wacõ iso. Cʉtojʉ ejacõri, masare ado bajiro gotiyijo iso: ");
INSERT INTO myy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jeyaro yʉ yigore, “Ado bajiro yicʉ mʉ”, yi gotigʉre tirã waya mʉa cʉni. ¿Cristo meje ñaguĩjida mʉaca? yiyijo iso masare. ");
INSERT INTO myy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ito bajiro iso yija tʉocõri, Jesure ti ãmorã gʉa tʉ ejacã iti cʉto gãna. ");
INSERT INTO myy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ito bajiroca riti: —Gʉare riasogʉ, jabeto baya maji, yi josa ñacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ito gʉa yibojarocati, ado bajiro cʉdiquĩ Jesús: —Mʉa masibiti, yʉ baroti ñacã yʉre, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ito bajiro ĩ yija tʉocõri: —¿Sĩgʉ̃ ĩre bare cũgʉ̃ ejarʉda? yi gãmeri seniĩasʉocʉ gʉamasiti. ");
INSERT INTO myy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ito bajiro gʉa gãmeri bʉsija tʉo masicõri, ado bajiro yiquĩ Jesús gʉare: —Yʉre cõarʉ ĩ ãmoro bajiro yʉ yija, ito yicõri iti moare yʉ gajanoaja, iti ña yʉ ya bare bajiro bajirise. Masama bare ba wanʉsotiama. Yʉama yʉre cõarʉ ĩ ãmoro bajiro yicõri wanʉa yʉ. ");
INSERT INTO myy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Jʉariarã ũmacañi rʉya maji, ote iti bʉcʉaroto”, ote wese ʉjʉ ĩ yiado bajiro yi tʉoĩabesa mʉa. “Masare Dios oca mani riasorijʉ ejabea maji”, yi tʉoĩabesa mʉa. Yʉama ado bajiro ya: Ote bʉcʉacoajʉ ĩja, adocãta ãmija quena. Tiya, masa jãjarã yʉre tʉorʉ̃nʉrona ñacãma ĩja. Adocãta ĩnare riasoja quena. ");
INSERT INTO myy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","No ote miojugʉti, waja boca ãmigʉ̃ yiguĩji. Itire bajiroti, no yʉre masa ĩna tʉorʉ̃nʉroca yigʉre ĩre queno waja yigʉ yigʉja yʉ. Ĩ ñami catitĩñare gaye masa ĩna bʉja masiroca yigʉ. Ito bajiri yʉ oca masare riasogʉ cʉni, yʉre masa ĩna tʉorʉ̃nʉroca yigʉ cʉni corocõti wanʉrã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Riti bajia bʉcʉrã ĩna bʉsigore: “Sĩgʉ̃ ñaguĩji otegʉ. Gãji ñaguĩji itire miojugʉ”, yiyijarã bʉcʉrã. Riti bajia iti. Tʉote. Coriarã ñama yʉ oca masare riasorã. Gãjerã ñama yʉre masa ĩna tʉorʉ̃nʉroca yirã. ");
INSERT INTO myy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ote wese ʉjʉ ricare mioju rotigʉ yiguĩji ĩ ya moari masare, otegoana meje ĩna ñabojarocati. Yʉ cʉni ito bajiroti mʉare cõa, yʉre masa ĩna tʉorʉ̃nʉroca mʉa yi masitoni. Yʉ oca ĩnare riasosʉoana meje ñabojarocati mʉare cõa yʉ. Mʉa riojʉa gãjerã ĩnare riasosʉoñi. Ito bajiri josari mejeti yʉre ĩna tʉorʉ̃nʉroca yi masirã yirãji mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“Jeyaro yʉ yigore yʉre gotiquĩ ĩ”, romio iso yi gotija tʉocõri, jãjarã iti cʉto gãna Samaria sita gãna Jesure tʉorʉ̃nʉcã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ito bajiri iti cʉto gãna Jesure ti wanʉcõri gʉare tuja roticã ĩna. Ito bajiri ĩna rãca jʉa rʉmʉ ñacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesumasiti ĩ riasoja tʉocõri, jãjarã bʉsa ĩre tʉorʉ̃nʉcã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jesure tʉorʉ̃nʉcõri, ado bajiro bʉsicã ĩna romiore: —Mʉre gʉa tʉogore gaye riti meje, ĩre tʉorʉ̃nʉa gʉa. Adocãta gʉamasiti ĩre tʉocõri, tʉorʉ̃nʉa gʉa ĩja. “Ĩti ñami Cristo, adi macãrʉcʉ̃ro gãnare masorocʉ”, yi ti masia gʉa ĩja, yicã iti cʉto gãna romiore. ");
INSERT INTO myy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ito yija bero, jʉa rʉmʉ beroti Samaria sitana ñacõri, Galilea sitajʉ wasʉocʉ gʉa mʉcana Jesús rãca. ");
INSERT INTO myy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Riti bajia Jesús ĩ bʉsigore: “Diore goti ĩsiri masʉre ĩ ya sita gãna ĩre queno rʉ̃cʉbʉomenaji”, yi gotiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea sitajʉ Jesús rãca gʉa ejaroca, queno boca ãmicã ito gãna. Ĩna cʉni Jerusalénjʉ pascua basa ti tʉdi ejana ñañi. Ito yicõri iti basa rʉmʉri jeyaro Jesús ĩ yigore tiana ñari seyoñi ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ito yija bero, Galilea sitajʉ Caná wame cʉtiri cʉtojʉ tʉdi wacʉ gʉa Jesús rãca. Ito ñacʉ idena ʉyé ide ĩ godo weogorajʉ. Itojʉ ñaquĩ sĩgʉ̃ ʉjʉre moa ĩsiri masʉ ñasagʉ. Ĩ macʉ Capernaum wame cʉtiri cʉtojʉ cõ ñañi. ");
INSERT INTO myy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","“Judea sitana wacõri, Galilea sitajʉ ejayijʉ Jesús”, yija tʉocõri, ĩre tigʉ ejaquĩ ʉjʉ ya moari masʉ ñasagʉ. Jesús tʉ ejacõri ado bajiro josaquĩ ĩ ĩre: —Yʉ ya wijʉ waya. Yʉ macʉ cõ wacʉ yiguĩji. Yʉ macʉre yisiogʉ waya, yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ito ĩ yija tʉocõri, ado bajiro yiquĩ Jesús: —Tiyamani mʉa tibeja, yʉre queno tʉorʉ̃nʉbea mʉa, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ito bajiro ĩ yibojarocati: —Yʉ Ʉjʉ coji waya, yʉ macʉ ĩ godare ãmobea yʉ, yiquĩ moa ĩsiri masʉ ñasagʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ito ĩ yija tʉocõri: —Mʉ ya wijʉ tʉdi wasa. Mʉ macʉ catiguĩji, yiquĩ Jesús ĩre. Ito bajiro Jesús ĩ yija tʉocõri, “Riti gotiami Jesús”, yi tʉorʉ̃nʉquĩ ĩ. Ito bajiri ĩ ya wijʉ tʉdi wasʉoquĩ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ĩ ya wijʉ ejagʉ wagʉ ĩ yiroca ĩre ejabʉari masa ado bajiro ĩre goti bocayijarã ĩna: —Mʉ macʉ caticoami ĩja, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ĩna ito yija tʉocõri: —¿Nocãta catisʉori yʉ macʉ? yi seniĩayijʉ ĩ ĩnare. —Ñamica, ũmacañi ĩ juja rʉ̃gʉ̃rijʉ, ĩre ñiotarojobʉ, yiyijarã ĩna, ĩna ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ito bajiro ĩna yija tʉocõri, tʉoĩa bʉjayijʉ ĩ. “Itocõ ũmacañi ĩ juja rʉ̃gʉ̃rijʉti, ‘Mʉ macʉ catiguĩji’, yi gotimida Jesús yʉre”, yi tʉoĩa bʉjayijʉ ĩ. Ito bajiri ĩ, ĩ ñarã cʉni Jesure tʉorʉ̃nʉyijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iti ñacʉ bero gaye tiyamani Jesús ĩ ĩore, Judea sitana, Galileajʉ tʉdi ejacõri, ĩ ĩore gaye. ");
INSERT INTO myy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ito bajija bero mʉcana tʉdi basa menicã judio masa. Ito bajiri itire tigʉ waquĩ Jesús mʉcana Jerusalénjʉ. Ĩ rãca wacʉ gʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iti cʉto Oveja wame cʉtiri soje tʉ ñacʉ masa ĩna guarita. Hebreo ocana Betzata wame cʉticʉ itira. Itira tʉ co dʉjamocõ jʉri ñacʉ ide ñura jʉri. ");
INSERT INTO myy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Iti roca cõrã jãjarã jacajʉ cũñacã. Cajea mana, queno wa masimena cʉni, ito yicõri ruduana cʉni ñacã itojʉ. “¿Nocãta iti jacũja tiana?” yirona bocati cũñacã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Co rʉmʉrea ángel ruji ejacõri, ide jacũroca yiñi. Ito ĩ yija bero, no itira cajero quedi roasʉogʉreti ĩ ñarise cʉtirise rẽtacoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Itojʉ cõrã wato sĩgʉ̃ ñaquĩ treinta y ocho rodori cõ ñarʉ. ");
INSERT INTO myy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ĩ cũñaja ticõri, “Yoariguti cõri seyoñi ãni”, yi tiquĩ Jesús ĩre. Ito bajiri ado bajiro ĩre seniĩaquĩ Jesús: —¿Mʉcana tʉdi cati quenagʉ̃ ña ãmoati mʉ? yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ito bajiro ĩ yija tʉocõri: —Yʉ Ʉjʉ, sĩgʉ̃jʉa yʉre idejʉ queo roagʉ mami, iti jacũroca. Coji rʉyabeto yʉ ide cʉ̃o ãmobojarocati, gãjerã riti yʉ riojʉa ide cʉ̃osotiama, yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ito ĩ yija: —Wʉmʉña, mʉ ya cama ãmi wasa, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ito ĩ yirocariti, queno cati quenagʉ̃ ñacõaquĩ ĩ mʉcana. Ĩ ya cama ãmicõri, wasʉoquĩ ĩ. Iti rʉmʉti gʉa judio masa ya tujacãra rʉmʉ ñacʉ. ");
INSERT INTO myy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ito bajiri ĩ ya camare ĩ gajaja ticõri, ado bajiro yicã judio masa ĩre: —Jane tujacãra rʉmʉ ña. Ito bajiri mʉ ya camare gajare ma mʉre, yicã judio masa. ");
INSERT INTO myy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ado bajiro cʉdiquĩ ĩ cõgorʉ: —Mʉcana tʉdi cati quenaroca yʉre yigʉ, ado bajiro yimi yʉre: “Mʉ ya camare ãmi wasa”, yimi ĩ yʉre, yiquĩ ĩ judio masare. ");
INSERT INTO myy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ito ĩ yija tʉocõri: —¿Ñimʉ ñari, “Mʉ ya camare ãmi wasa”, mʉre yigʉ? yi seniĩacã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ito bajiro ĩna seniĩabojarocati, “Ĩ ñami”, yi masibitiquĩ ĩ. Itojʉ masa jãjarã ñacã. Ito bajicõri Jesuama masa jãjarã watojʉ wa godacoaquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mʉcana ito bero Dios ya wijʉ gʉa ñaroca, ti bʉjaquĩ Jesús mʉcana ĩ yisiorʉre. Ĩre ti bʉjacõri, ado bajiro yiquĩ Jesús ĩre: —Tʉoya, queno tʉdi mʉcana catia mʉ. Mʉcana tʉdi ñeñaro yibeja, bʉto bʉsa mʉ tõbʉjabe, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ito ĩ yibojarocati mʉcana tʉdi judio masa tʉ wacõri, “Jesuti ñami, mʉcana tʉdi yʉ cati quenaroca yigʉ”, yi judio masare gotiñi ĩ. ");
INSERT INTO myy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ito bajiro ĩ yija tʉocõri, Jesure sĩa ãmorã ʉsirio codecã ĩna. Tujacãra rʉmʉ ñabojarocati cõgʉ̃re ĩ yisioja ticõri, ĩre sĩa ãmocã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Gʉa tʉjʉ ĩna ejaja ticõri, ado bajiro yiquĩ Jesús ĩnare: —Moatĩñagʉ̃ ñami yʉ Jacʉ. Ito bajiri yʉ cʉni moatĩña, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ito bajiro ĩ yija tʉocõri, bʉto bʉsa ĩre sĩa ãmocã ĩna. Tujacãra rʉmʉ ñaroca cõgʉ̃re ĩ yisiorena sʉori meje, ĩre junisinicã ĩna. “Dios ñami yʉ Jacʉ”, Jesús ĩ yija tʉocõri, “Dios robo bajiro ñasagʉ ña yʉ”, yirocʉ yami ĩ, yi tʉoĩacã ĩna. Ito bajiri bʉto bʉsa ĩre sĩa ãmocã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ito bajiro ĩna tʉoĩaja ti masicõri, ado bajiro yiquĩ Jesús, ĩnare: —Riti mʉare gotia yʉ. Yʉ, Dios Macʉ, yʉ ãmoro bajiro riti meje ya yʉ. Yʉ Jacʉ ĩ yirise ticõri, ito bajiro ya yʉ. Jeyaro yʉ Jacʉ ĩ yiro bajiroti yʉ ĩ Macʉ cʉni ito bajiroti ya. ");
INSERT INTO myy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉ Jacʉ yʉre maicõri, jeyaro ĩ yirise yʉre ĩoami ĩ. Ito yicõri bʉto bʉsa ñasarise yʉre ĩogʉ̃ yiguĩji maji. Ito bajiro yʉre ĩ ĩoja ticõri, ti ʉcarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Godarãre mʉcana ĩna tʉdi catiroca yami yʉ Jacʉ. Ito bajiri yʉ, ĩ Macʉ cʉni ĩna catiroca yʉ yi ãmoja, ĩna catiroca yigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Masa ĩna ñeñaro yirise cõĩagʉ̃ meje ñami yʉ Jacʉ. Yʉjʉare cũñi ĩ, masa ĩna ñeñaro yirise yʉ cõĩatoni. ");
INSERT INTO myy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ito bajiro yiñi yʉ Jacʉ, ĩre ĩna rʉ̃cʉbʉoro bajiroti yʉre cʉni ĩna rʉ̃cʉbʉotoni. Yʉre rʉ̃cʉbʉobicʉ, yʉ Jacʉ, yʉre cõarʉre cʉni rʉ̃cʉbʉobiquĩji, yiquĩ Jesús judio masare. ");
INSERT INTO myy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Gaje ado bajiro gotiquĩ Jesús: —Riti mʉare gotia yʉ. No yʉ bʉsirisere tʉorʉ̃nʉgʉ̃, yʉre cõarʉre cʉni tʉorʉ̃nʉgʉ̃ti catitĩñagʉ̃ yiguĩji ĩ. Ĩocʉ̃re ruyuriobicʉ yiguĩji Dios. Godabojagʉti catitĩñagʉ̃ yiguĩji ĩocʉ̃. Ito bajiri catitĩñagʉ̃ yiguĩji ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Riti mʉare gotia yʉ. Yʉre tʉorʉ̃nʉmena godacãna robo bajiro bajirã ñama ĩna. Ija ñaro yiroja, adocãta cʉni ña, yʉ Dios Macʉ bʉsirisere tʉorã yirãji ĩna. Yʉre ĩna tʉorʉ̃nʉja, catitĩñarã yirãji. ");
INSERT INTO myy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Catitĩñare gaye rʉcogʉ ñami yʉ Jacʉ. Ito bajiri masa ĩna catiroca yi masiami ĩ. Masa ĩna catitĩñaroca yʉ yitoni, yʉre cũquĩ Cʉna. ");
INSERT INTO myy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Masa Rĩjorʉ, yʉ ñajare masare ĩna ñeñaro yirise yʉ waja senitoni, yʉre cũquĩ Cʉna, ya yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ito bajiro yʉ yija tʉocõri, tʉo ʉcabesa mʉa. Ija yʉ bʉsirise godana jeyaro tʉo jedirã yirãji. ");
INSERT INTO myy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Yʉ oca tʉocõri, masari cuma ñana budirã yirãji ĩna. Queno yigoana, tʉdi caticõri, Dios rãca catitĩñarã yirãji ĩna. Ñeñaro yigoanama, tʉdi ĩna catiroca ĩnare waja senigʉ̃ yiguĩji Dios. Ito yicõri jeame ʉ̃jʉrojʉ ĩnare cõagʉ̃ yiguĩji ĩ, yiquĩ Jesús judio masare. ");
INSERT INTO myy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Gaje ado bajiro gotiquĩ Jesús ĩnare: —Yʉ ãmoro bajiro riti yirocʉ meje wadicʉ yʉ. Masare ĩna ñeñaro yirise waja yʉ senija, Dios ĩ rotiro bajiroti ya yʉ. Masare ĩna ñeñaro yirise yʉ waja senija, ñeñaro ĩna yiadocõti senia yʉ. Yʉ ãmoro bajiro meje ya yʉ. Yʉre cõarʉ ĩ ãmoro bajirojʉa ya yʉ. ");
INSERT INTO myy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Yʉti ña Dios ĩ cõarʉ”, yʉ yibojaja, “Ĩti ñami”, yi masimenaji gãjerã. ");
INSERT INTO myy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","“Ĩti ñami Dios ĩ cõarʉ”, yʉre yi ĩsigʉ̃ ñami gãji. Yʉre ĩ bʉsi ĩsirise, oca riojo ñasarise ña. Ito bajiri ĩre tʉorã yirãji masa. ");
INSERT INTO myy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“¿Ĩti ñati Dios ĩ cõarʉ?” yi Juan idé guri masʉre seniĩa rotiyija mʉa. Mʉare ĩ cʉdire, riti ña. ");
INSERT INTO myy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Riti, Dios ĩ cõarʉ ñami Jesús”, Juan idé guri masʉ yʉre ĩ bʉsi ĩsija, ĩ bʉsi ĩsibeja cʉni no yibea, Dios ĩ cõarʉti ña yʉ. Juan idé guri masʉ gaye mʉare gotia yʉ, Dios ĩ masoana mʉa ñatoni. ");
INSERT INTO myy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Mʉa tʉo masijaro yirocʉ, busurica yocõri yigʉre bajiro yiñi Juan. Ito bajiri ĩre tʉocõri, wanʉyija mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan yʉre ĩ bʉsi ĩsigore rẽto bʉsaro ñasarise ña yʉre. Tiyamani yʉ ĩorise, iti ña yʉ Jacʉ ĩ rotire. Itire ticõri, “Riti Dios ĩ cõarʉ ñami”, yi masirãji mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yʉ Jacʉ yʉre cõarʉ cʉni, “Riti ãni ñami yʉ cõarʉ”, yi yʉre bʉsi ĩsiquĩ. Ĩreama tʉogoana meje, tigoana meje ña mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ĩ ocare tʉo ãmorã meje ña mʉa. Yʉre ĩ cõarʉre cʉni tʉorʉ̃nʉbea mʉa. Ito bajiri mʉa ya ʉsijʉ ĩ ocare queno tʉo masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Dios oca tutire queno ticõri rẽoariti riasotia mʉa. Catitĩñare gaye bʉja ãmorã, itire riasotia mʉa. Yʉ gayereti gotia Dios oca. ");
INSERT INTO myy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ito bajibojarocati yʉre boca ãmi ãmobea mʉa. Yʉre mʉa boca ãmija, catitĩñare gaye bʉjarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Masa yʉre ĩna rʉ̃cʉbʉotoni meje wadicʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mʉare ti masia yʉ. Ito bajiri, “Diore mairã meje ña mʉa”, yi ti masia yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yʉ Jacʉ ĩ rotirisena wadirʉ ña yʉ. Ito bajibojarocati yʉre boca ãmibea mʉa. Sĩgʉ̃ ĩ ãmoro bajiro ĩ wadija, ĩreama boca ãmirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mʉamasi gãmeri rʉ̃cʉbʉorejʉa ãmoboja mʉa. Dios sĩgʉ̃ti ñami mani Ʉjʉ. Ito bajibojarocati ĩre cʉdibiticõri mʉare ĩ wanʉroca yibea mʉa. Ito bajiro bajirã ñari yʉre cʉni tʉorʉ̃nʉbea mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yʉ Jacʉ riojo, “Ĩnare seti ña”, yibicʉja yʉ mʉare. Moisés ñayorʉti ñaguĩji, “Mʉare seti ña”, yigʉ. Moisés ñayorʉ ĩ rotirisena sʉoriti, “Dios tʉ ejarã ya mani”, yi tʉoĩaboja mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yʉ gaye ucayoñi Moisés ñayorʉ. Ĩ ucarisere mʉa tʉorʉ̃nʉja, yʉre cʉni tʉorʉ̃nʉboana mʉa. ");
INSERT INTO myy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ĩ ucagore gaye mʉa tʉorʉ̃nʉbeja, yʉre cʉni tʉorʉ̃nʉmena yirãji mʉa, yiquĩ Jesús judio masare. ");
INSERT INTO myy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ito bajiro ĩ yija bero, itajura Galilea wame cʉtirita sidʉja jẽa wacʉ gʉa Jesús rãca. Tiberias wame cʉticʉ gaje itira wame. ");
INSERT INTO myy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cõrãre Jesús ĩ yisioja ticõri, ito yicõri tiyamani ĩ ĩoja ticõri, jãjarã masa sʉyacã gʉare. ");
INSERT INTO myy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Gaje dʉjajʉ ejacõri, gaje buro maja wacʉ gʉa Jesús rãca. Itojʉ Jesús rãca rujicʉ gʉa ĩ rãca riasotirã. ");
INSERT INTO myy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pascua basa judio masa ĩna meniroti nocõ mejeti rʉyacʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jãjarã masa Jesure ĩna sʉyaja ticõri, ado bajiro yiquĩ ĩ Felipere: —Ãna masa jeyarore yiari, ¿no bare waja yirã yirãjida mani? yiquĩ Jesús Felipere. ");
INSERT INTO myy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","“Ado bajiro yigʉ yigʉja yʉ”, yi masibojagʉti, “No bajiro Felipe ĩ cʉdija, tʉocʉja”, yirocʉ seniĩari seyoquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ito yijare Felipe ado bajiro cʉdiquĩ: —Doscientos niyeru cujirina naju yʉ waja yibojaja cʉni, masa jeyarore tĩjabetoja, yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ito ĩ yija tʉocõri, ado bajiro cʉdiquĩ gʉa rãca gagʉ, Andrés wame cʉdigʉ. Ĩ cʉni Jesús rãca riasotigʉti ñaquĩ. Ĩti ñaquĩ Simón Pedro ocabaji. Ado bajiro yiquĩ ĩ: ");
INSERT INTO myy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ado ñami sĩgʉ̃ macʉacã, co dʉjamocõ cebada wame cʉtirise naju rʉcogʉ ito yicõri wai jʉ̃arã rʉcogʉ. Masa jãjarã ĩna ñajare tĩjado ma adi, yiquĩ Andrés. ");
INSERT INTO myy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ito ĩ yija: —Masa jeyarore ruji rotiya, yiquĩ Jesús. Ta quenarise jaje ñacʉ itojʉ. Ito bajiri cinco milcõ ʉ̃mʉa rujicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ĩna rujija ticõri, ĩ ya ãmona naju ãmiquĩ Jesús. “Queno ya Dios mʉ”, yicõri, gʉa ĩ rãca riasotirãre ĩsiquĩ ĩ. Gʉajʉa ito rujirãre batocʉ ĩja. Waire cʉni ito bajiroti batocʉ gʉa. Masa ĩna ãmorocõti ĩsicʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Masa ĩna yajija ticõri, ado bajiro yiquĩ Jesús gʉare: —Rʉyarise miojuya, iti godabe yirona, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Cebada wame cʉtirise naju rʉyarise jʉa gʉbojeno jibʉri dajacʉ, gʉa bato rʉarise. ");
INSERT INTO myy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ito bajiro tiyamani Jesús ĩ ĩoja ticõri, ado bajiro yicã masa: —Riti, Diore bʉsi ĩsiri masʉ ñami ãni, adi macãrʉcʉ̃rojʉre mani bocatirʉ, yicã masa. ");
INSERT INTO myy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","“Yʉ ãmobitibojarocati yʉre ãmi wacõri, cʉto ʉjʉ yʉre cũ ãmoama ãna”, yi tʉoĩacõri, sĩgʉ̃ti tʉria joejʉ maja waquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iti rãioja ticõri, gʉa Jesús rãca riasotirã itajurajʉ roja wacʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Iti rãitĩaja tibojagʉti gʉa tʉ tʉdi ejabitiquĩ Jesús maji. Ito bajiri cumajʉ sãjacõri jẽa wasʉocʉ gʉa, Capernaum wame cʉtiri cʉtojʉ ejarã warã. ");
INSERT INTO myy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ito bajiro gʉa jẽa waroca bʉto mino wẽasʉocʉ. Ito yicõri jacũrise bʉcʉ, cʉrise jacũcʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cinco, seis kilómetrocõ gʉa wa tʉjaroca, ide joe cʉda wadicõri cuma tʉjʉ Jesús ĩ wadija ticʉ gʉa. Ito bajijare ti ʉcacʉ gʉa ĩja. ");
INSERT INTO myy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Gʉa ti ʉcaja ticõri, ado bajiro yiquĩ Jesús: —Yʉti ña. Güibesa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ito ĩ yija tʉocõri, wanʉre rãca boca ãmicʉ gʉa ĩre ĩja. Ito yija bero yoari mejeti gaje dʉja jẽa ejacʉ gʉa, gʉa tʉoĩa warojʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ito bero gaje rʉmʉ itajura gaje dʉja tujana, “Ñari cumanati wañi ĩna. Ito bajibojarocati Jesuama wabisĩ ĩna rãca”, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ito bajiro ĩna baji ñaroca Tiberias cʉto gãna gaje cumarina ejayijarã ĩna tʉ. “Queno ya Dios mʉ”, yi Jesús ĩ gotirajʉ tʉ, ito yicõri masa ĩna bagorajʉ tʉ ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Itijʉ Jesús ĩ manija ticõri, gʉa ĩ rãca riasotirã gʉa manija ticõri, iti cumarina Capernaumjʉ ĩre ãmarã wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Itajura sidʉjajʉ ejacõri gʉare ti bʉjacã ĩna ĩja. Jesure ti bʉjacõri ado bajiro ĩre seniĩacã ĩna: —Gʉare riasogʉ, ¿nocãta ado ejari mʉ? yi seniĩacã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ito bajiro ĩna yija tʉocõri: —Riti mʉare gotia yʉ. Yaji quenaro babʉ mʉa, ito bajiri yʉre ãma mʉa. Tiyamani yʉ ĩorise gaye ti masicõri meje yʉre ãma mʉa. ");
INSERT INTO myy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bare jedirise gaye bʉjarona meje moaña mʉa. Bare jogarise gaye meje, catitĩñare gaye bʉjarona moaña mʉa. Yʉ ña Masa Rĩjorʉ, bare jogabiti gaye mʉare ĩsirocʉ. “Ito bajiro ĩ yitoni ĩre cũñi Dios”, yʉre mʉa yi masiroca yami Dios, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ito ĩ yija ĩre seniĩacã ĩna: —¿No bajiro Dios ĩ ãmoro bajiro yirãjida gʉa? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ĩna ito yija tʉocõri, ado bajiro cʉdiquĩ Jesús: —Dios ĩ cõarʉre mʉa tʉorʉ̃nʉre ãmoami Dios, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ito ĩ yijare: —¿Ñe tiyamani gʉare ĩogʉ̃ yigʉjada mʉ, itire ticõri mʉre gʉa tʉorʉ̃nʉtoni? ¿Ñe gaye gʉare ĩogʉ̃ yigʉjada mʉ? ");
INSERT INTO myy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mani ñicʉsabatia ñayoana yucʉ manojʉ ña ucurã, maná wame cʉtirise bayijarã ĩna maji. Itire gotia Dios oca cʉni. Tʉote: “Ũmacʉ̃jʉ gaye naju ĩnare ecarocʉ queoñi Dios”, yi gotia Dios oca, yicã masa Jesure. ");
INSERT INTO myy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ĩna ito yija tʉocõri, cʉdiquĩ Jesús: —Riti mʉare gotia yʉ. Moisés ñayorʉ meje ũmacʉ̃jʉ gaye naju ĩnare ecañi. Yʉ Jacʉti ñañi ũmacʉ̃jʉ gaye naju ñasarise ĩnare ecarʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Naju ũmacʉ̃jʉ gaye ñasarise rʉcogʉ ñaguĩji Dios ĩ cõarʉ. Naju ñasarise rʉcocõri, masare catitĩñare ĩsigʉ̃ yiguĩji ĩ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ito ĩ yija: —Gʉa Ʉjʉ, iti naju catitĩñare gaye riti gʉare ecasotiya, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ito ĩna yija tʉocõri, ado bajiro yiquĩ Jesús ĩnare: —Yʉti ña naju ñasarise rʉcogʉ, ito yicõri catitĩñare ĩsigʉ̃. No yʉre boca ãmigʉ̃ti jʉaji ñiocõbicʉ yiguĩji ĩ. Najuro babojarãti mʉcana tʉdi ñiocõrã yirãji mʉa. Ide idibojarãti mʉcana tʉdi idi ãmorã yirãji mʉa. No yʉre boca ãmigʉ̃ti ñe gaje ãmobicʉ yiguĩji. No yʉre tʉorʉ̃nʉgʉ̃ti ñe gaje ãmobiticõri queno wanʉ quenagʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Yʉre tibojarãti, yʉre tʉorʉ̃nʉbea mʉa”, yiari mʉare goticʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","No yʉre boca ãmirãti, ĩna ñama yʉ Jacʉ yʉre ĩ ĩsiana. No yʉre boca ãmi ãmogʉ̃re, ĩre rẽobicʉja yʉ. “Yʉre boca ãmibesa mʉ”, yibicʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ũmacʉ̃jʉna wadicõri, yʉ ãmoro bajiro yigʉ meje wadicʉ yʉ. Yʉre cõarʉ ĩ ãmoro bajiro yirocʉ wadicʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ado bajiro ãmoami yʉ Jacʉ yʉre cõarʉ. Yʉre ĩ ĩsiana, sĩgʉ̃ ĩ godare ãmobeami ĩ. Sʉsari rʉmʉ ĩna tʉdi catiroca yʉ yire ãmoami ĩ. ");
INSERT INTO myy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","No yʉre boca ãmicõri, yʉre tʉorʉ̃nʉgʉ̃ ĩ catitĩñare ãmoami yʉ Jacʉ Dios. Ito bajiri yʉre tʉorʉ̃nʉrãre ĩna tʉdi catiroca yigʉ yigʉja yʉ sʉsari rʉmʉ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ito ĩ yija bero, ĩre bʉsitusʉocã judio masa. “Yʉ ña naju ñasarise rʉcocõri, ũmacʉ̃jʉna wadirʉ”, Jesús ĩ yija tʉocõri, ĩre bʉsitusʉocã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ito yicõri, ado bajiro gãmeri bʉsicã ĩna: —¿Ãni Jesús, José macʉ meje ñati? Ĩ jacʉre, ĩ jacore cʉni ticʉ mani. ¿No yija ito bajibojagʉti, “Ũmacʉ̃jʉ gagʉ wadirʉ ña yʉ”, yati ĩ? yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ito bajiro ĩna yija masicõri: —Itocõ bʉsitu jidicãña mʉa. ");
INSERT INTO myy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Noa yʉre boca ãmimenaji, Yʉ Jacʉ yʉre cõarʉ yʉre ĩna boca ãmiroca ĩ yibeja. No yʉre boca ãmirãre sʉsari rʉmʉ ĩna tʉdi catiroca yigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Diore goti ĩsiri masa ĩna ucare ado bajiro gotia: “Masa jeyarore riasogʉ yiguĩji Dios”, yi gotia iti. Ito bajiri no yʉ Jacʉ riasorise gaye tʉorʉ̃nʉrã, yʉre cʉni boca ãmirã yirãji, yiquĩ Jesús judio masare. ");
INSERT INTO myy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gaje ado bajiro gotiquĩ Jesús: —No yʉ Jacʉre tigʉ maquĩji. Yʉ sĩgʉ̃ti ĩ tʉ wadirʉ ñari, ĩre tigorʉ ña yʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Riti mʉare gotia yʉ. No yʉre tʉorʉ̃nʉgʉ̃ti catitĩñagʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉ ña naju ñasarise rʉcogʉ, ito yicõri catitĩñare gaye rʉcogʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mani ñicʉsabatia yucʉ manojʉ maná wame cʉtirise naju babojarãti goda jediñi ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mʉare yʉ bʉsiriseama, naju ũmacʉ̃jʉ gaye ruji wadirise gaye, mʉare bʉsia yʉ. Yʉ rʉcorise najure bacõri, godamena yirãji. ");
INSERT INTO myy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉti ña, naju catitĩñare gaye rʉcocõri, ũmacʉ̃jʉna ruji wadirʉ. No iti gaye naju bagʉ catitĩñagʉ̃ yiguĩji. Mʉare yʉ naju ĩsirise, yʉ ya rujʉti ña. Masa jeyarore yiari yʉ ya rujʉ ĩsigʉ̃ yigʉja yʉ, yiquĩ Jesús judio masare. ");
INSERT INTO myy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ito ĩ yija tʉocõri, ĩnamasiti gãmeri bʉsisʉocã judio masa: —¿No bajiro ĩ ya rujʉre manire ecagʉ yiguĩjida ĩ? yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ado bajiro cʉdiquĩ Jesús ĩnare: —Riti mʉare gotia yʉ. Yʉ Masa Rĩjorʉre yʉ ya rujʉ mʉa babeja, ito yicõri yʉ ya rí mʉa idibeja, catimena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","No yʉ ya rujʉre bacõri, ito yicõri yʉ ya ríre idigʉ catitĩñagʉ̃ yiguĩji. Sʉsari rʉmʉ tʉdi ĩ catiroca yigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yʉ ya rujʉ iti ña bare ñasarise. Ito yicõri yʉ ya rí iti ña idire ñasarise. ");
INSERT INTO myy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yʉ ya rujʉre bagʉ, ito yicõri yʉ ya ríre idigʉ, ĩ ya ʉsijʉre ñagʉ̃ yigʉja yʉ. Ito bajiri yʉre bajiroti ʉsi cʉtigʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉ Jacʉ yʉre cõarʉ, catire rʉcogʉ ñami ĩ. Ito bajiri ĩ́na sʉoriti catia yʉ. Ito bajiroti, no yʉre boca ãmigʉ̃, yʉna sʉoriti catigʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ũmacʉ̃jʉ gaye naju wadire gaye bʉsia yʉ. Iti gaye naju maná wame cʉtirise robo bajirise meje ña. Mani ñicʉsabatia maná wame cʉtirisere babojarãti goda jediñi ĩna. No naju ñasarisere bagʉama catitĩñagʉ̃ yiguĩji ĩocʉ̃, yiquĩ Jesús judio masare. ");
INSERT INTO myy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaum wame cʉtiri cʉto minijuara wijʉ ito bajiro riasoquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ito bajiro riasore gaye Jesús ĩ bʉsija tʉocõri, jãjarã ĩre sʉyarã ado bajiro gãmeri bʉsicã ĩna: —Ito bajiro ĩ riasorise josari ña. Itire queno tʉo masibea mani. Sĩgʉ̃jʉa itire boca ãmigʉ̃ mami, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","“Yʉ riasorise tʉocõri, tʉoĩa bʉjatobeama ĩna”, yi masiri seyoquĩ Jesús. Ito bajiri ado bajiro ĩnare yiquĩ ĩ: —¿Ito bajiro mʉare yʉ riasorise tʉoĩa bʉjatobeati mʉa? yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yʉ Masa Rĩjorʉ, ũmacʉ̃jʉ yʉ ñagoado mʉcana yʉ tʉdi mʉja waja, ¿no bajiro tʉoĩarã yirãjida mʉa? ");
INSERT INTO myy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu Santo ñami masa ĩna catitĩñaroca yigʉ. Masama gãjerã ĩna catitĩñaroca yi masimenaji ĩna. Jĩjʉ mʉare yʉ gotirise Espíritu Santo riojo ĩ goticãrise ña. Itire mʉa tʉorʉ̃nʉja, mʉa catitĩñaroca yigʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mʉa coriarã, yʉre tʉorʉ̃nʉmena ñarãji maji, yiquĩ Jesús ĩnare. Cajerojʉti, “Ĩna ñarã yirãji yʉre tʉorʉ̃nʉmena. Ito yicõri ĩ ñagʉ̃ yiguĩji, yʉ wajanare yʉre ĩna ñiatoni gotiri masʉ”, yi masi yucãri seyoñi Jesús cajerojʉti. ");
INSERT INTO myy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ado bajiro masare goti quenoquĩ Jesús: —Espíritu Santo ñami masa ĩna catitĩñaroca yigʉ. Itire masicõri jĩjʉ ado bajiro mʉare gotibʉ yʉ: Noa yʉre boca ãmimenaji, yʉ Jacʉ yʉre ĩna boca ãmiroca ĩ yibeja, yibʉ yʉ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ito ĩ yija tʉocõri, jãjarã ĩre sʉyabojarã ĩre jidicãcã ĩna. Ito bajiri gʉa rãca wa ucubiticã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ito bajiro ĩna bajija ticõri, gʉa ĩ rãca riasotirã jʉa gʉbojeno ñarãre seniĩaquĩ Jesús: —¿Mʉa cʉni yʉre jidicã ãmoati? yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ito ĩ yija tʉocõri, ado bajiro cʉdiquĩ Simón Pedro: —Gʉa Ʉjʉ, mʉre gʉa jidicãja, ¿ñimʉ tʉ warã yirãjida gʉa? Mʉ ya oca ña catitĩñare oca. ");
INSERT INTO myy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mʉre tʉorʉ̃nʉcãcʉ gʉa. “Mʉ ña Cristo, Dios catitĩñagʉ̃ Macʉ”, yi masia gʉa mʉre, yiquĩ Simón Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ito ĩ yija tʉocõri, ado bajiro yiquĩ Jesús gʉare: —Mʉa jʉa gʉbojeno ñarãre besecãcʉ yʉ. Ito bajibojarocati mʉa wato sĩgʉ̃ ñami rʉ̃mʉ́ yagʉ, yiquĩ Jesús, gʉare. ");
INSERT INTO myy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ito bajiro ĩ bʉsija, Judas Iscariote Simón macʉre, yi tʉoĩa bʉsiquĩ Jesús. Jesús rãca riasotigʉ ñabojagʉti Judas ñaquĩ Jesús wajana ĩre ñiatoni gotiri masʉ. Gʉa jʉa gʉbojeno ñarã rãca gagʉ ñabojaquĩ Judas. ");
INSERT INTO myy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ito yija bero mʉcana Galilea sitajʉ wa ucucʉ gʉa Jesús rãca. Judea sitajʉ ña ãmobitiquĩ Jesús, iti sita gãna judio masa ĩre ĩna sĩa ãmojare. ");
INSERT INTO myy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chozas basa, judio masa ĩna meniroti jabeto rʉyacʉ. ");
INSERT INTO myy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ito bajiri Jesús ocabaji mesa ado bajiro yicã ĩre: —Judea sitajʉ mʉre sʉyarã jãjarã bʉsa ñarãji. Ito bajiri ado tujabesa. Itojʉ wasa. Itojʉ tiyamani gaye mʉ ĩoja, tirã yirãji ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","No masa ĩre ti masire ĩ ãmoja, yeyorojʉ tiyamani yi ĩobiquĩji ĩ. Masa tiro riojo ĩogʉ̃ yiguĩji ĩ. Tiyamani gaye mʉ yiado bajiroti masa jeyaro tiro riojo ĩoja quena, yicã Jesús ocabaji mesa ĩre. ");
INSERT INTO myy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ĩ ocabaji mesa cʉni queno ĩre tʉorʉ̃nʉbiticã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ito bajiri ado bajiro yiquĩ Jesús ĩnare: —Judea sitajʉ yʉ waroto ejabea yʉre maji. Adocãta cʉni mʉa waja quenacõa mʉareama. ");
INSERT INTO myy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Adi macãrʉcʉ̃ro gãna mʉare ti tudimenaji. Yʉreama ti tudirã yirãji. “Ñeñaro yirã ña mʉa”, yʉ yijare, yʉre ti terã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Basa titẽña mʉama. Yʉreama yʉ waroto ejabea maji, yiquĩ Jesús ĩ ocabajirãre. ");
INSERT INTO myy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ito bajiro Jesús ĩ yija bero Galilea sitajʉ jabeto tujacʉ gʉa ĩ rãca maji. ");
INSERT INTO myy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ĩ ocabajirã waja bero Jesús cʉni basa tigʉ waquĩ. Ĩre baba cʉti wacʉ gʉa cʉni. Bʉto masa ĩna tiro riojo meje ña ucuquĩ Jesús, basa tigʉ. ");
INSERT INTO myy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Basa rʉmʉ ñaroca Jesure ãmabojacã judio masa. Ado bajiro yicã ĩna: —¿Nojʉ ñaguĩjida ĩ? yi bʉsicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Basa rʉmʉ ñaroca, jãjarã masa Jesús gaye bʉsicã ĩna. Coriarã ado bajiro yicã: “Queno yigʉ ñaguĩji ĩ”, yicã coriarã. Gãjerãma ado bajiro yicã: “Queno yigʉ meje ñaguĩji ĩ. Masare rʉogʉ ñaguĩji ĩ”, yicã gãjerã. ");
INSERT INTO myy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Judio masa ʉjarãre güirã, recoti ĩ gaye bʉsi joeobiticã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Basa gʉdareco iti tʉjaroca Dios ya wi sãjacʉ gʉa Jesús rãca. Iti wijʉ sãjacõri, masare riasosʉoquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ĩ riasoja tʉo ʉcacõri, ado bajiro yicã judio masa ʉjarã: —Riasotibitigorʉ ñabojagʉti, ¿no yija queno masiati ãni? yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ito bajiro ĩna tʉoĩaja ticõri, ado bajiro yiquĩ Jesús ĩnare: —Yʉ riasorise yʉ ye meje ña. Yʉre cõarʉ gaye ña iti. ");
INSERT INTO myy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dios ĩ ãmoro bajiro mʉa yi ãmoja, “Dios gaye riasoami ĩ, ĩ gayeti riasoami ĩ”, yi masirã yirãji mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","No ĩ gayeti ĩ bʉsija, masa ĩna ĩre rʉ̃cʉbʉore ãmoguĩji. No ĩre cõarʉ gaye ĩ bʉsija, ĩre cõarʉjʉare masa ĩna rʉ̃cʉbʉore ãmoguĩji ĩ. Ĩ bʉsirise riti ñaroja. Ñejʉa rʉore oca manoja ĩre, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moisés ñayorʉ ĩ rotire gaye mʉare cũñi. Ito bajibojarocati mʉa sĩgʉ̃jʉa iti rotire gaye cʉdi jeobea mʉa. ¿No yija yʉre sĩa ãmoati mʉa?” yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ito ĩ yija tʉocõri, ado bajiro cʉdicã masa ĩre: —Rʉ̃mʉ́ sãñagʉ̃ ña mʉ. Ñimʉjʉa mʉre sĩa ãmogʉ̃ maquĩji, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ĩna ito yijare: —Tujacãra rʉmʉ ñaroca sĩgʉ̃ cõgʉ̃re yʉ yisioja ticõri, itire ti ʉcabʉ mʉa. ");
INSERT INTO myy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés ñayorʉ rĩacare wiro tare gaye mʉare rotiñi ĩ. Ĩ́na sʉori meje iti rotire ñasʉoyija. Ĩ riojʉa gãna cʉni ito bajiroti yiyijarã ĩna. Iti rotire mʉare ñajare, tujacãra rʉmʉ ñabojarocati rĩacare wiro ta mʉa. ");
INSERT INTO myy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisés ñayorʉ ĩ rotirise cʉdirona tujacãra rʉmʉ ñabojarocati rĩacare wiro ta mʉa. Ito bajiri tujacãra rʉmʉ ñabojarocati sĩgʉ̃ cõgʉ̃re yʉ yisioja, ¿no yija yʉre junisiniati mʉa? ");
INSERT INTO myy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Rocati queno tʉoĩa jeobitibojarãti, “Ĩre seti ña”, yibesa mʉa. “Ĩre seti ña”, mʉa yi ãmoja, cajero queno tʉoĩa jeocõri, “Ĩre seti ña”, yija quena, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ito ĩ yija tʉocõri, Jerusalén gãna ĩnamasiti gãmeri seniĩasʉocã: —¿Ãni meje ñati sĩarona ĩna ãmagʉ̃? ");
INSERT INTO myy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ado mani jeyaro tiro riojo bʉsi ñami ĩ. Ito bajibojarocati sĩgʉ̃ ĩre rẽogʉ̃ mami. Ado gãna ʉjarã mesa, “Cristo Dios ĩ cõarʉ ñaguĩji ãni”, ¿yi tʉoĩarãjida ĩna? ");
INSERT INTO myy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“Iti cʉto gagʉ wadiñi ĩ”, yi masia mani. Cristoreama, ĩ ejaja, “Ito gagʉ wadiñi ĩ”, yi masimena yirãji mani. ");
INSERT INTO myy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ĩna ito yija tʉocõri, Dios ya wijʉ riaso ñabojarʉ, oca sẽoro ado bajiro bʉsiquĩ Jesús: —¿Yʉre ti masiati mʉa? “Ito gagʉ wadirʉ ñami ĩ”, ¿yʉre yi masiati mʉa? Yʉmasi meje wadicʉ. Dios yʉre ĩ cõajare wadicʉ yʉ. Riojo gotigʉ ñami yʉre cõarʉ. Ĩre ti masirã meje ña mʉa maji. ");
INSERT INTO myy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yʉama, ĩre masia. Ĩ cõarʉ ña yʉ. Ito yicõri, ĩ tʉ wadirʉ ña yʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ito ĩ yija tʉocõri, ĩre bʉto ñia ãmocã judio masa ʉjarã. Ito bajibojarocati sĩgʉ̃ ĩre ñiagʉ̃ maniquĩ. Dios ĩ ñiarotirajʉ ejabiticʉ maji. Ito bajiri ñia masibiticã ĩna maji. ");
INSERT INTO myy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gãjerãma jãjarã ĩre tʉorʉ̃nʉcã ĩna. Ito bajiri ado bajiro yicã ĩna: —Cristo Dios ĩ cõarʉ ñaguĩji ãni. Ĩ rẽtoro tiyamani yigʉ maquĩji, yicã ĩna ĩre tʉorʉ̃nʉrã. ");
INSERT INTO myy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jesús gaye masa ĩna bʉsija, tʉoñi fariseo gaye tʉoĩarã. Ito bajiri porecia masare, Jesure ñia rotiñi fariseo gaye tʉoĩarã, ito yicõri paia ʉjarã cʉni. ");
INSERT INTO myy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ĩna ejaja ticõri, ado bajiro yiquĩ Jesús: —Yʉre cõarʉ tʉ tʉdi wacʉ yigʉja yʉ. Ito bajiri yoari mejeti masa tʉ ñagʉ̃ yigʉja yʉ maji. ");
INSERT INTO myy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉre ãmabojarãti tʉdi yʉre bʉjamena yirãji mʉa. Yʉ ñarojʉ wa masimena yirãji mʉa, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jesús ito ĩ yija tʉocõri, judio masa ĩnamasiti gãmeri seniĩacã ĩna: —¿Nojʉ wacʉ yiguĩjida ãni, ĩre mani ti bʉjabetojʉ? Mani masa sõjʉ wacõri griego masa rãca wʉsarã tʉ, wacʉ yiguĩji gajea. Ito yicõri, ĩnare riasogʉ wacʉ yiguĩji gajea. ");
INSERT INTO myy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Yʉre ãmabojarãti yʉre bʉjamena yirãji mʉa. Ito yicõri yʉ ñarojʉ wa masimena yirãji mʉa”, ito bajiro ĩ yija, ¿no yireoni ñati iti? yi gãmeri bʉsicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Basa ñasʉsari rʉmʉ, iti rʉmʉ ñacʉ ñasari rʉmʉ. Iti rʉmʉ wʉmʉ rʉ̃gʉ̃cõri, oca sẽoro bʉsiquĩ Jesús: —Sĩgʉ̃ ĩ idi ãmoja, ide senigʉ̃ yiguĩji. Iti bajiroti, no catitĩñare gaye ĩ bʉja ãmoja, yʉ tʉ wadicõri seni ejagʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ado bajiro gotia Dios oca. Tʉote mʉa: “Sĩgʉ̃ yʉre ĩ tʉorʉ̃nʉja, ĩ ya ʉsijʉ ide catitĩñare gaye ide goje robo bajiro ĩ ya ʉsijʉ ũmabato ñaro yiroja”, yi gotia Dios oca, yi gotiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iti gaye Jesús ĩ bʉsija, “Yʉre tʉorʉ̃nʉrãre ĩna ya ʉsijʉ, Espíritu Santo quedi sãjagʉ̃ yiguĩji ĩnare”, yigʉ yiquĩ Jesús, ito bajiro ĩ bʉsija. Jesús ũmacʉ̃jʉ rʉ̃cʉbʉorajʉ ĩ tʉdi ejabeja, Espíritu Santore adi sitajʉ cõabisĩ Dios maji. ");
INSERT INTO myy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús ĩ bʉsija tʉocõri, ado bajiro yicã coriarã: —Riti Diore goti ĩsiri masʉ wadirʉ ñami ãni, yicã coriarã. ");
INSERT INTO myy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gãjerãma ado bajiro yicã ĩna: —Cristo Dios ĩ cõarʉ ñami ãni, yicã ĩna. Gãjerãma ado bajiro yicã: —¿Galilea gagʉ Cristo no bajiro ñaguĩjida? ");
INSERT INTO myy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios oca iti gotija, “David ʉjʉ ñayorʉ, janerãbatia janami, ñagʉ̃ yiguĩji Cristo. Ito yicõri David ñayorʉ robo bajiro Belén gagʉti ñagʉ̃ yiguĩji ĩ cʉni”, yi gotia Dios oca, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ito bajiro Jesús gaye ĩna bʉsija tʉocõri, ricati riti tʉoĩacã masa. ");
INSERT INTO myy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Coriarã ĩre ñia ãmobojacã. Ito bajibojarocati sĩgʉ̃ ĩre ñiagʉ̃ maniquĩ. ");
INSERT INTO myy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jesure ñia masibiticõri, fariseo gaye tʉoĩarã ito yicõri paia ʉjarã tʉ cʉni tʉdi wacã porecia. Ñe manati ĩna ejaja ticõri, ado bajiro ĩnare seniĩayijarã ĩna: —¿No yija ĩre ãmi wadibiti mʉa? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ado bajiro cʉdiyijarã porecia: —Sĩgʉ̃jʉa ĩ robo bajiro bʉsirã masa manicã, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ito yijare, fariseo gaye tʉoĩarã ado bajiro yiyijarã: —¿Ĩ rʉorisere ĩre tʉori mʉa? ");
INSERT INTO myy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mʉa ʉjarã ña gʉa. Gʉama sĩgʉ̃ ĩre tʉorʉ̃nʉgʉ̃ ma. ");
INSERT INTO myy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ado gãna masa Moisés ñayorʉ ĩ rotire gaye masibiticõri Jesure tʉorʉ̃nʉrãji ĩnaõna. Ito bajiro ĩna bajijare ĩnare ruyuriogʉ yiguĩji Dios, yiyijarã fariseo gaye tʉoĩarã. ");
INSERT INTO myy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo ñamijʉ Jesure tigʉ ejarʉ, fariseo gaye tʉoĩagʉ̃ ñayijʉ ĩ cʉni. Ĩ baba mesare ado bajiro yiyijʉ ĩ: ");
INSERT INTO myy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Ado bajiro bajia mani rotirise: Cajero seti cʉtigʉre mani seniĩa tʉobeja, “Ĩre seti ña”, yi masibea mani, yi gotia mani rotirise, yiyijʉ Nicodemo ĩ baba mesare. ");
INSERT INTO myy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ito ĩ yijare: —¿Galilea sita gagʉ ñati mʉ cʉni? Dios oca tutire riasotiĩate mʉ. Itire mʉ riasotija bero, “Diore goti ĩsiri masʉ Galilea wadirʉ macʉ yiguĩji”, yire gaye masigʉ̃ yigʉja mʉ cʉni, yiyijarã ĩna, Nicodemore tudirã. ");
INSERT INTO myy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ito yija bero batacõri ĩna ya wirijʉ wasosayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Cʉtojʉ gʉa tujaroca Jesuama Olivos wame cʉtiri burojʉ maja waquĩ. ");
INSERT INTO myy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gaje rʉmʉ busuri, Dios ya wijʉ gʉa ñaroca tʉdi ejaquĩ Jesús mʉcana. Ĩ ejaja ticõri, jãjarã masa ĩ tʉ minijuacã. Ĩna minijuaja ticõri, eja rũjũquĩ ĩ ĩnare riasorocʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ito bajiro ĩ yiroca fariseo gaye tʉoĩarã, bʉcʉrã rotirise riasori masa cʉni ejacã. Sĩgõ romio gajeo manʉjʉ rãca ajegorore ĩna bʉjarore ãmi ejacã ĩna. Isore ãmi ejacõri, gʉa riojo isore rojocã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ito yicõri, ado bajiro Jesure yicã ĩna: —Riasogʉ, adio romiore gajeo manʉjʉ rãca iso ajeroca ti bʉjabʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés ñayorʉ ĩ rotire, ado bajiro rotia: Ito bajiro yigore gʉ̃tana rea sĩaña, ya iti. ¿Mʉáma no bajiro tʉoĩati? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","“No bajiro manire ĩ cʉdija tʉona” yirona ito bajiro seniĩari seyocã ĩna. “Manire ĩ cʉdi masibeja, ĩre seti ña”, yi masirã yirãji mani, yi tʉoĩari seyocã ĩna. Ĩna ito yija masicõri, jacajʉ ñini rũjũcõri, ĩ ya ãmo wãsoana ucasʉoquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ĩre ĩna seniĩa ʉyamʉcʉtija tʉocõri, wʉmʉ rʉ̃gʉ̃quĩ Jesús ĩja. Ito yicõri ado bajiro ĩnare yiquĩ: —Mʉa sĩgʉ̃ ñeñaro yiĩamena ñajama, isore cajero gʉ̃tana reaja quena, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ito bajiro yi tĩogʉ̃ ñini rũjũquĩ Jesús mʉcana. Ito yicõri, mʉcana jacajʉ ucaquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ito ĩ yija tʉocõri, “Mani sĩgʉ̃ rʉyabeto ñeñaro yirã riti ña mani”, yi tʉoĩa masicã ĩna. Ito bajiri bʉcʉrã budi wasʉocã ĩna. Ito yicõri, ĩna ñarocõti budi jedicoacã ĩna ĩja. Ĩna budi jedija bero, romio riti ito tujacõ Jesús tʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ito yija Jesús wʉmʉ rʉ̃gʉ̃quĩ mʉcana. Romio sĩgõreti ticõri, ado bajiro yiquĩ Jesús isore: —Nomi, ¿nojʉ ñati, “Isore seti ña”, mʉre yirã? ¿Sĩgʉ̃jʉa, “Mʉre seti ña”, yigʉ mati? yiquĩ ĩ isore. ");
INSERT INTO myy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ito ĩ yija bero cʉdicõ iso: —Yʉ Ʉjʉ, sĩgʉ̃ mami, “Mʉre seti ña”, yʉre yigʉ, yicõ iso Jesure. Iso ito yija tʉocõri, ado bajiro yiquĩ Jesús: —Yʉ cʉni, “Mʉre seti ña”, yibea. Wasa, mʉcana tʉdi ñeñaro yibeja ĩja, yiquĩ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mʉcana masare gotigʉ, ado bajiro bʉsiquĩ Jesús: —Yʉ ña busurise rʉcogʉ, ito yicõri, adi macãrʉcʉ̃rore busugʉ. Busurise rʉcogʉ ñari adi macãrʉcʉ̃ro gãna ĩna tʉo masiroca ya yʉ. No yʉre sʉyagʉti rãitĩarojʉ wa ucubicʉ yiguĩji. Ĩre sĩatitĩñagʉ̃ yigʉja yʉ, ĩ queno tʉo masitoni. Ito bajiri yʉre boca ãmicõri catitĩñagʉ̃ yiguĩji ĩ, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ito bajiro ĩ yija tʉocõri, ado bajiro yicã fariseo gaye tʉoĩarã: —“Riti gotia yʉ”, ya mʉ, masa mʉre ĩna rʉ̃cʉbʉotoni. Ito bajiro mʉ yibojaja, ñe waja ma iti. Rʉogʉ ya mʉ, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ĩna ito yijare ado bajiro cʉdiquĩ Jesús: —Yʉmasiti yʉ gotirise ñabojarocati, riti ña yʉ gotirise. Iti ña oca riojo ñasarise. Yʉ masia yʉ wadigoadojʉ. Ito yicõri yʉ warotojʉ masia yʉ. Mʉama yʉ wadigoadojʉ masibea. Ito yicõri, yʉ warotojʉ cʉni masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","“Mʉre seti ña”, yʉre mʉa yija, adi macãrʉcʉ̃ro gãna ĩna tʉoĩado robo bajiro ya mʉa. Yʉama, “Mʉare seti ña”, yibea yʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","“Mʉare seti ña”, yʉ yija, riojo mʉare gotibogʉja yʉ. Masare ĩna ñeñaro yirise yʉ waja senija, yʉ sĩgʉ̃ meje senia yʉ. Yʉ Jacʉ yʉre seni rotigʉ, yʉ rãcati senigʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉa bʉcʉrã rotirise ado bajiro ucare ña: “Ĩre seti ña”, jʉ̃arã ĩna yija, ĩnare tʉorʉ̃nʉja quena, ya mʉa bʉcʉrã rotirise. ");
INSERT INTO myy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","“Riti gotia yʉ”, ya yʉ yʉmasi cʉni. Yʉ Jacʉ yʉre cõarʉ cʉni, “Riti gotiami ãni”, yi goti ejabʉami ĩ yʉre yiari, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ito ĩ yija tʉocõri, ado bajiro ĩre seniĩacã ĩna: —¿Nojʉ ñati mʉ Jacʉ? yicã ĩna Jesure. Ito yijare cʉdiquĩ Jesús: —Yʉre ti masibea mʉa. Ito yicõri yʉ Jacʉre cʉni ti masibea mʉa. Yʉre mʉa ti masija, yʉ Jacʉre cʉni ti masiboana mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dios ya wijʉ ñacõri ito bajiro masare riasoquĩ Jesús. Masa ĩna niyeru sãra jedori tʉjʉ rʉ̃gõcõri ito bajiro masare riasoquĩ Jesús. Ĩre ĩna ñiarotijʉ ejabiticʉ maji, ito bajiri sĩgʉ̃jʉa ĩre ñiagʉ̃ maniquĩ. ");
INSERT INTO myy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mʉcana masare gotigʉ, ado bajiro bʉsiquĩ Jesús: —Wacʉ ya yʉ. Yʉre ãmabojarã yirãji mʉa. Mʉa ñeñaro yirise jidicãmenati godarã yirãji mʉama. Ito bajiri yʉ warojʉ wa masimena yirãji mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ito ĩ yija tʉocõri, ado bajiro yicã judio masa: —¿Ĩmasiti sĩa godagʉ yati ãni? Ito bajiri, “Yʉ warotojʉ wamena yirãji mʉa”, yami ĩ, yi gãmeri seniĩari seyocã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ĩna ito yija tʉocõri: —Mʉa ado jaca gãna ña. Yʉama ũmacʉ̃jʉ gagʉ ña. Adi sita gãna ña mʉa. Yʉama adi sita gagʉ meje ña. ");
INSERT INTO myy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ito bajiri, “Mʉa ñeñaro yirise jidicãmenati godarã yirãji mʉa”, yibʉ yʉ mʉare. “Ĩti ña yʉ”, yʉ yiro bajiro yʉre mʉa tʉorʉ̃nʉbeja, mʉa ñeñaro yirise jidicãmenati godarã yirãji mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ito ĩ yija tʉocõri, ado bajiro ĩre seniĩacã ĩna: —Ito yijama, ¿ñimʉjʉa ñasati mʉ? yicã ĩna Jesure. Ĩna ito yija: —“Ĩti ña yʉ”, yiari mʉare goticãbojabʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jaje mʉare gotiroti ñaboja yʉre. Ito yicõri, “Mʉare seti ña”, yʉ yi ãmoja, jaje gotiroti ñaboja yʉre. Yʉre cõarʉ ĩti ñami riojo gotigʉ. Adi sita gãna masare yʉ gotirise, ĩre tʉocõri gotia yʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ito bajiro ĩnare ĩ bʉsibojarocati, “Mani Jacʉ Dios gaye bʉsiami ĩ”, yi masibiticã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ito bajiri ado bajiro ĩnare gotiquĩ ĩ: —Yʉ ña Masa Rĩjorʉ. Yucʉtẽona yʉre mʉa mʉoja, “Dios Macʉ ña yʉ”, yʉ yiado bajiroti yʉre ti masirã yirãji mʉa. “Ĩmasirio tʉoĩacõri meje bʉsiñi. Ĩ Jacʉ ĩ riasoado bajiro riti bʉsiñi”, yi masirã yirãji mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yʉre cõarʉ yʉ rãcati ñami. Yʉ Jacʉ ĩ wanʉrise gaye riti ya yʉ. Ito bajiri yʉre wagobitisotiami ĩ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ito bajiro Jesús ĩ yija tʉocõri, jãjarã masa ĩre tʉorʉ̃nʉcã. ");
INSERT INTO myy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ito bajiri, ado bajiro gotiquĩ Jesús, judio masare ĩre tʉorʉ̃nʉrãre: —Yʉ bʉsirise mʉa jidicãbeja, riti yʉ rãca riasotirã ñarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ito bajiro yicõri, oca riojo ñasarise masirã yirãji mʉa. Oca riojo ñasarise tʉocõri, mʉa ñeñaro yirisere jidicãrã yirãji mʉa. Ito bajiri rʉ̃mʉ́re moa ĩsiri masa meje ñarã yirãji mʉa ĩja, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ito ĩ yija tʉocõri: —Abraham ñayorʉ janerãbatia ña gʉa. Rʉ̃mʉ́re moa ĩsiri masa ñabiti wadicʉ gʉa. ¿No yija, “Rʉ̃mʉ́re moa ĩsiri masa meje ñarã yirãji mʉa”, yati mʉ gʉare? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ĩna ito yija tʉocõri: —Riti mʉare gotia yʉ. No ñeñaro yirã rʉ̃mʉ́a ʉjʉre moa ĩsiri masa ñama ĩnaõna. ");
INSERT INTO myy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sĩgʉ̃ macʉacã ĩ jacʉsabatia rãca ñaguĩji. Sĩgʉ̃ ĩre moa ĩsiri masʉama, ĩ rĩa rãca ñagʉ̃ meje ñaguĩji. Sĩgʉ̃ macʉ ĩ jacʉ robo bajiro roti masigʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dios Macʉ ñari roti masigʉ̃ ña yʉ. Ito bajiri rʉ̃mʉ́a ʉjʉre moa ĩsiri masa ñabitiroca mʉare yʉ yija, riti ĩre moa ĩsiri masa meje ñarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Abraham ñayorʉ janerãbatia ña mʉa”, yi masia yʉ mʉare. Ĩ janerãbatia ñabojarãti yʉ bʉsirise tʉorʉ̃nʉbiticõri, yʉre sĩa ãmoa mʉa. ");
INSERT INTO myy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Cʉna yʉre ĩ ĩogore mʉare bʉsia yʉ. Mʉa jacʉ ĩ rotiado bajiro riti ya mʉama, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ito ĩ yija tʉocõri, ado bajiro cʉdicã ĩna: —Gʉa ñicʉsabatia ñicʉ ñayoñi Abraham, yicã ĩna, Jesure. Ĩna ito yija: —Riti Abraham janerãbatia mʉa ñajama, ĩ yiado bajiro yiboana mʉa. ");
INSERT INTO myy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Oca riojo ñasarise, Dios yʉre ĩ riasoado bajiroti mʉare yʉ riasobojarocati, yʉre sĩa ãmoa mʉa. Abraham ñayorʉama ito bajiro yibitiyoñi. ");
INSERT INTO myy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yʉre mʉa sĩa ãmoja, mʉa jacʉ ĩ rotiado bajiroti ya mʉa, yiquĩ Jesús ĩnare. Ito ĩ yija tʉocõri: —Jacʉ manoti gʉa jacosaromia bʉjana meje ña gʉa. Sĩgʉ̃ ñami gʉa jacʉ. Ĩ ñami Dios, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ĩna ito yija tʉocõri, ado bajiro cʉdiquĩ Jesús: —Dios tʉ wadicõri ado ña yʉ. Riti mʉa jacʉ Dios ĩ ñaja, yʉre maiboana mʉa. Yʉmasi meje wadicʉ yʉ. Dios yʉre ĩ cõajare wadicʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿No yija yʉ bʉsirise tʉo masibeati mʉa? Yʉ bʉsirise tʉo ãmobea mʉa. Ito bajiri itire tʉo masibea mʉa. ");
INSERT INTO myy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉa jacʉ rʉ̃mʉ́a ʉjʉ ñami ĩ. Ito yicõri ĩ rĩa ña mʉa. Ito bajiri ĩ ãmoro bajiroti yi ãmoa mʉa. Cajerojʉti masare sĩari masʉ ñañi rʉ̃mʉ́. Oca riojo gotire wanʉgʉ̃ meje ñami ĩ. Ito yicõri, cojirea riojo gotigʉ meje ñami ĩ. Rʉore oca ĩ gotija socagʉ ñari, ito bajiroti rʉo gotiguĩji ĩ. Ĩ ñami rʉore jaigʉ, ito yicõri rʉore jacʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mʉa jacʉ ĩ ñajare, oca riojo ñasarise yʉ mʉare gotibojaja, yʉre tʉorʉ̃nʉbea mʉa. ");
INSERT INTO myy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Ado bajiro ñeñaro yicʉ mʉ”, yʉre yigʉ sĩgʉ̃ mami mʉa rãca. Oca riojo ñasarise mʉare yʉ gotibojaja, ¿no yija yʉre tʉorʉ̃nʉbeati mʉa? ");
INSERT INTO myy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios ñarã mʉa ñaja, recoti Dios ocare tʉorʉ̃nʉrã yirãji mʉa. Dios ñarã meje ñari, yʉre tʉo ãmobea mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ito yija ado bajiro cʉdicã judio masa: —“Samaria sita gagʉ, rʉ̃mʉ́ sãñagʉ̃ ña mʉ”, mʉre gʉa yija, riti ya gʉa, yicã judio masa Jesure. ");
INSERT INTO myy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ĩna ito yija tʉocõri: —Ñejʉa rʉ̃mʉ́ sãñagʉ̃ meje ña yʉ. Yʉ Jacʉ Diore rʉ̃cʉbʉoa yʉ. Mʉama yʉre rʉ̃cʉbʉobea. ");
INSERT INTO myy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Masa ĩna yʉre rʉ̃cʉbʉotoni wadirʉ meje ña yʉ. Sĩgʉ̃ ñami masa ĩna yʉre rʉ̃cʉbʉore ãmogʉ̃. Ĩ ñami yʉre rʉ̃cʉbʉomenare ti masigʉ̃, ito yicõri ĩna ñeñaro yirise waja senigʉ̃. ");
INSERT INTO myy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Riti mʉare gotia yʉ. No yʉ bʉsirise tʉorʉ̃nʉgʉ̃ godabicʉ yiguĩji. Dios rãca catitĩñagʉ̃ yiguĩji, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ito ĩ yija tʉocõri, ado bajiro yicã judio masa: —Iti mʉre gʉa tʉoja, “Riti rʉ̃mʉ́ sãñagʉ̃ ñami”, yi masia gʉa, mʉre ĩja. Abraham ñayorʉ, Diore goti ĩsiri masa ñayoana cʉni goda jediñi ĩna. “Yʉre tʉorʉ̃nʉrã godamenaji”, yiboja mʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Gʉa ñicʉsabatia ñicʉ, Abraham ñayorʉ rẽtoro ñasagʉ ñati mʉ? Ĩ cʉni, Diore goti ĩsiri masa cʉni goda jedicoañi ĩna. ¿Ñimʉ ña yʉ yati mʉáma? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ĩna ito yija tʉocõri: —Yʉmasiti, “Masa ĩna rʉ̃cʉbʉogʉ ña yʉ”, yʉ yibojaja, ñe waja ma iti. Yʉ Jacʉ ñami yʉre rʉ̃cʉbʉogʉ, “Ĩti ñami gʉa yagʉ Dios”, mʉa yibojagʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ĩre queno masibea mʉa. Yʉama ĩre queno masia. “Ĩre masibea yʉ”, yʉ yibojaja, mʉa robo bajiroti socagʉ ñaborʉja yʉ cʉni. Yʉama, queno masisacõa ĩre. Ĩ yiro bajiroti cʉdia yʉ. ");
INSERT INTO myy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mʉa ñicʉsabatia ñicʉ Abraham ñayorʉ, “Co rʉmʉ ejagʉ yiguĩji Cristo”, yirocʉ wanʉ yuñi. Adi sitajʉ yʉ ejaja ticõri, wanʉsacõquĩ ĩ, yiquĩ Jesús judio masare. ");
INSERT INTO myy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ito ĩ yija tʉocõri, ado bajiro yicã ĩna Jesure: —Bʉcʉgʉ meje ña mʉ maji. Cincuenta rodori tʉjabea mʉ maji. Ito bajibojarocati, ¿no yija, “Abraham ñayorʉre ticʉ yʉ”, yati mʉ? yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ĩna ito yijare: —Riti mʉare gotia yʉ. Abraham ñayorʉ ĩ ñaroto riojʉajʉ, ñacãcʉ yʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ito ĩ yija tʉocõri, gʉ̃ta ãmicã ĩre rearona. Ĩna ito yijare, “Ito bajia”, yi masia manoti ĩna watoti budicoaquĩ Jesús, Dios ya wire budigo wacʉ. ");
INSERT INTO myy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ito yija bero bʉsa Jesús rãca gʉa rʉ̃gõ ucuroca sĩgʉ̃ cajea macʉ rujearʉre ti bʉjaquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gʉa Jesús rãca riasotirã ado bajiro seniĩacʉ Jesure: —Gʉare riasogʉ, ¿no yija cajea macʉ rujeayijari ãni? ¿Ĩ jacʉsabatia ĩna ñeñaro yire waja ito bajiro rujeayijari ĩ? ¿Ĩmasi ñeñaro yire wajati bajiyijarite? yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ito bajiro gʉa yijare: —Ĩmasi ñeñaro yire waja meje, ito yicõri ĩ jacʉsabatia ĩna ñeñaro yire waja meje ito bajiro rujeañi ãni. Dios ĩ masirise masa ĩna titoni, ito bajiro rujeañi ãni. ");
INSERT INTO myy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ʉ̃mʉa ña maji. Ito bajiri yʉre cõarʉ ĩ rotiado bajiroti moagʉ̃ ya yʉ. Yoari mejeti rãioro yiroja. Noajʉa moa masimena yirãji itocõ. ");
INSERT INTO myy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Busurise rʉcogʉ ña yʉ. Ito bajiri adi macãrʉcʉ̃ro yʉ ñaroca, masa ĩna tʉo masiroca ya yʉ maji, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ito bajiro yi tĩocõri, jacajʉ go eocũquĩ ĩ. Sitare jabeto ide yiquĩ ĩ itina. Ito yicõri, cajea macʉre itina tuquĩ ĩ, ĩ ya cajeare. ");
INSERT INTO myy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ito bajiro yi tĩocõri, ado bajiro rotiquĩ cajea macʉre: —Siloé wame cʉtirita masa ĩna guaritajʉ wasa. Itojʉ ejacõri, mʉ ya cajeare gõna coeba, yiquĩ Jesús cajea macʉre. “Cõarʉ”, yireoni ña Siloé wame. Jesús ĩ gotija tʉocõri, ĩ gotiro bajiroti coegʉ waquĩ cajea macʉ. Ĩ coe tĩoja bero tʉdi ejagʉ ticoaquĩ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ĩ ñarã, ĩre tigoana cʉni ado bajiro yicã ĩna: —“Yʉre ti maicõri, yʉre jabeto ĩsiña”, ¿yi rujicacʉ meje ñati ãni? yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Ĩti ñami, yicã coriarã. —Ĩ meje ñami. Ĩ robo bajigʉti ñami ñarea, yicã gãjerã. Ĩna ito yija tʉocõri, ĩmasiti ado bajiro yiquĩ: —Ĩti ña yʉ, yiquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ito ĩ yijare, ado bajiro ĩre seniĩacã masa: —¿No bajiro yicõri, cajea tiati mʉ? yicã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ĩna ito yijare: —Sĩgʉ̃ Jesús wame cʉtigʉ ĩ ya go idena sita ide yicõri, yʉre cajea tumi ĩ. Iti tucõri, ado bajiro rotimi yʉre: “Siloé wame cʉtirita wacõri, coeba”, yimi yʉre. Itira ejacõri yʉ ya cajea gõna coebʉ yʉ. Ito bajiro yʉ yirocati ruyucoajʉ yʉre, yiquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ito ĩ yija tʉocõri, ado bajiro ĩre seniĩacã masa: —¿Nojʉ ñaguĩjida mʉre ito bajiro yirʉ? yicã ĩna. Ĩna ito yija tʉocõri: —Ba, masibea yʉ, yiquĩ cajea macʉ ñagorʉ. ");
INSERT INTO myy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ito ĩ yija tʉocõri, fariseo gaye tʉoĩarã tʉre cajea macʉ ñabojarʉre ãmi wacã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ĩ ya go idena cajea macʉre Jesús ĩ yisiora rʉmʉ, tujacãra rʉmʉ ñacʉ. ");
INSERT INTO myy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Cajea macʉ ñabojarʉre ĩna ãmi ejaja ticõri, ado bajiro ĩre seniĩayijarã fariseo gaye tʉoĩarã: —¿No yicõri cajea tiati mʉ mʉcana? yiyijarã fariseo gaye tʉoĩarã. Ito bajiro ĩna seniĩaja tʉocõri: —Go idena sitare ide yicõri, yʉ ya cajeare tuquĩ ĩ. Iti yʉ coeja bero tia yʉ ĩja, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ito ĩ yija: —Mʉre ito bajiro yirʉ, Dios yagʉ meje ñañi. Tujacãra rʉmʉre rʉ̃cʉbʉobisĩ ĩ, yiyijarã ĩna. Gãjerãma ado bajiro yiyijarã: —Ñeñaro yigʉ ĩ ñaja, tiyamani yibitiborʉ ĩ, yiyijarã gãjerã. Ito bajiri ricati riti tʉoĩayijarã ĩna fariseo gaye tʉoĩarã. ");
INSERT INTO myy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ito yijare mʉcana tʉdi seniĩayijarã ĩna, cajea macʉ ñagorʉre: —¿Mʉáma no bajiro tʉoĩati, mʉ cajea tiroca yirʉre? yiyijarã ĩna. Ĩna ito yija tʉocõri: —Diore goti ĩsiri masʉ ñaguĩji, ya yʉama, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","“Cajea macʉ rujearʉ mʉcana tʉdi cajea tirʉ ñami”, yi ãmobisijarã ĩna judio masa ʉjarã. Ito bajiri cajea macʉ jacʉsabatiare ji ñucayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ĩna ejaja ticõri, ado bajiro ĩnare seniĩayijarã ĩna: —¿Mʉ macʉti ñati ãni, cajea macʉ rujearʉ? ¿No yija cajea macʉ ñabojarʉti adocãta tiati? yiyijarã ĩna, ĩ jacʉsabatiare. ");
INSERT INTO myy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ĩna ito yija tʉocõri, ado bajiro cʉdiyijarã ĩna: —Gʉa macʉ, cajea macʉ rujearʉti ñami ãni. ");
INSERT INTO myy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ito bajiro ĩ tija, ito yicõri ĩre cajea tiroca yirʉre masibea gʉa. Ĩre seniĩaite mʉa. Bʉcʉgʉ ñami ĩja, ĩmasiti gotigʉõcʉ̃ ñami, yiyijarã ĩ jacʉsabatia. ");
INSERT INTO myy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judio masa ʉjarãre güirã, ito bajiro yiyijarã ĩ jacʉsabatia. “Jesús ñami Cristo, Dios ĩ cõarʉ”, yirãre rẽorã ya mani mʉcana minijuara wijʉ ĩna sãjame yirona, yi tʉoĩa yucãyijarã judio masa. ");
INSERT INTO myy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ito bajiri ĩnare güirã, “Bʉcʉgʉ ñami, mʉamasiti ĩre seniĩaña”, yiyijarã cajea macʉ ñabojarʉ jacʉsabatia. ");
INSERT INTO myy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ĩna ito yija tʉocõri, cajea macʉ ñabojarʉre ji ñucayijarã judio masa ʉjarã mʉcana: —Dios ĩ tiro riojo, riojo gʉare gotiya. “Mʉre yisiorʉ, ñeñaro yi jaigʉ ñañi”, yi masia gʉa, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ĩna ito yija tʉocõri: —“Ñeñaro yigʉ, ñeñaro yigʉ meje ñaguĩji”, yi masibea yʉ. Adi riti masia yʉ, cajea macʉ ñacʉ yʉ maji. Adocãtama yʉ cajea tia ĩja, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ito ĩ yija tʉobojarãti mʉcana tʉdi seniĩayijarã ĩna: —¿No bajiro mʉre yicati ĩ, mʉ titoni? yiyijarã ĩna ĩre. ");
INSERT INTO myy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ĩna ito yijare: —Mʉare goticãbojabʉ yʉ. Yʉre tʉorʉ̃nʉbea mʉa. ¿No yija mʉcana tʉdi gotire ãmoati mʉa? ¿Mʉa cʉni ĩre oca tʉo sʉya ãmoati? yiyijʉ ĩ judio masa ʉjarãre. ");
INSERT INTO myy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ito bajiro ĩ yija tʉocõri, ĩre bʉsi tudiyijarã ĩna: —Ĩre oca sʉyagʉ ya mʉ. Moisés ñayorʉ ocare sʉya gʉama. ");
INSERT INTO myy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Moisés ñayorʉre bʉsiñi Dios”, yi tʉoĩa gʉa. Mʉre yisiorʉreama masibea gʉa. “Ito gagʉ ñaguĩji ĩ”, yi masibea gʉa ĩreama, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ĩna ito yija tʉocõri, cʉdiyijʉ ĩ: —Yʉ ya cajea ĩ yisiore ñabojarocati, “Ito wadirʉ ñaguĩji ĩ”, yi masibea mʉa. Mʉa ĩre ti masibeja bʉjatobea yʉ. ¿No yija ĩre ti masibeati mʉa? Mʉa ĩre ti masibeja queno tʉo masire ma yʉre. ");
INSERT INTO myy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","“Ñeñaro yirãre tʉobiquĩji Dios. Ĩre rʉ̃cʉbʉocõri, ĩ ãmoro bajiro yirãre riti tʉogʉ yiguĩji Dios”, yi tʉoĩa mani. ");
INSERT INTO myy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","“Cajea macʉ rujearʉre ĩ tiroca yiñi sĩgʉ̃”, yire gaye tʉoya manicʉ. ");
INSERT INTO myy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ãni yʉre yisiorʉ, Dios tʉ wadirʉ meje ĩ ñaja, yʉre no yibitiborʉ, yiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ito ĩ yijare: —Ñeñaro yi jaigʉ rujearʉ ña mʉ. “Ĩnare riasocʉja yʉ”, ¿yi tʉoĩati mʉ, gʉare? yiyijarã ĩna cajea macʉ ñabojarʉre. Ito yicõri, ĩre bucõayijarã ĩna, ĩna minijuari wijʉ ñagʉ̃re. ");
INSERT INTO myy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Cajea macʉ ñabojarʉre ĩna bucõare gaye tʉo bʉjacʉ gʉa Jesús rãca. Ito bajiri ĩre ti bʉjacõri, ado bajiro ĩre yiquĩ Jesús: —¿Dios Macʉre tʉorʉ̃nʉati mʉ? yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ito ĩ yija: —Yʉ Ʉjʉ, yʉre gotiya. “Ĩ ñami”, yiya yʉre, ĩre tʉorʉ̃nʉrocʉ ya, yiquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ito ĩ yija, ado bajiro ĩre cʉdiquĩ Jesús: —Ĩre ticãcʉ mʉ. Adocãta mʉ rãca bʉsigʉ, ĩti ña yʉ, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ito ĩ yija tʉocõri, Jesús riojo rijomunigãna ñini rũjũquĩ ĩ, ĩre rʉ̃cʉbʉogʉ. Ito bajiro yicõri: —Mʉre tʉorʉ̃nʉa yʉ Ʉjʉ yʉ, yiquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ito yija bero, ado bajiro yiquĩ Jesús masare: —“Ãna ñama yʉre cʉdirã. Ãna ñama yʉre cʉdimena”, yi bʉsirocʉ wadirʉ ña yʉ. Cajea mana robo bajirã ñama Dios oca tʉo masimena. Ito bajiri ĩnare ĩna tʉo masiroca yigʉ yigʉja yʉ. “Queno masirã ña gʉa”, yibojarãreama, ĩna tʉo masibitiroca yigʉ yigʉja yʉ. Ito bajiri tʉo masibiticõri, cajea manare bajiro bajirã ñarã yirãji ĩna, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ito ĩ yija tʉocõri, ito ñarã coriarã fariseo gaye tʉoĩarã seniĩacã ĩna Jesure: —“Tʉo masibiticõri, cajea manare bajiro bajirã ña mʉa”, ¿yati mʉ gʉare? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ĩna ito yija: —Tʉo masimena mʉa ñaja, seti cʉtirã meje ñaboana mʉa. “Queno masirã ña gʉa”, mʉa yire waja, seti cʉtirã ña mʉa, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Mʉcana masare riasosʉogʉ ado bajiro yiquĩ Jesús: —Riti mʉare gotia yʉ. No oveja ĩna ñari sãnimʉ ĩna ya soje sãjabicʉ, gaje dʉja jore sãjagʉ̃ rʉocõri rinigʉ̃ ñami ĩocʉ̃. ");
INSERT INTO myy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ĩna ya soje sãjagʉ̃ama, ĩnare tirʉ̃nʉcõri codegʉ ñami. ");
INSERT INTO myy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ovejare tirʉ̃nʉri masʉ ĩ sãjatoni ĩre soje jana ĩsigʉ̃ yiguĩji soje coderi masʉ. Ĩ sãjaroca ĩ ya ocare tʉo masirã yirãji ĩ ya oveja. Ĩ ya ovejajʉare ti masicõri, wamena ĩnare ji bucõagʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ĩnare bucõa jeocõri, ĩna riojʉa ĩnare tʉ̃a ũmatãgʉ̃ yiguĩji ĩ. Ĩ ya ocare tʉo masicõri, ĩre sʉyarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ĩ oca ĩna tʉo godo weobejama ĩre sʉyamena yirãji ĩna. Ĩ ya ocare tʉo masibiticõri, ĩre rudirã yirãji ĩna, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Riasore oca ĩnare goti masioquĩ Jesús. Ito bajibojarocati itire tʉo masibiticã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ito yija mʉcana tʉdi gotiquĩ Jesús ĩnare: —Riti mʉare gotia yʉ. Yʉ ña soje, oveja ĩna sãjari soje bajiro bajigʉ. ");
INSERT INTO myy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yʉ riojʉa wadiana ñarocõti, rʉori masa ito yicõri riniri masa cʉni ñañi ĩna. Ito bajiri yʉ ya oveja mesare tʉorʉ̃nʉbisijarã. ");
INSERT INTO myy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉ ña soje bajiro bajigʉ. No yʉna sʉoriti sãjagʉ̃, ĩre masogʉ̃ yigʉja yʉ. Ado bajiro bajigʉ yiguĩji ĩocʉ̃: Oveja ĩna ñari sãnimʉjʉ sãjacõri, mʉcana tʉdi, budi, yi ñagʉ̃, ñagʉ̃ yiguĩji ĩocʉ̃. Queno wanʉ quenagʉ̃ yiguĩji ĩ. Ito yicõri, quenari wese ĩ baroti bʉjagʉ yiguĩji ĩ. Ito bajiro bajirã ñarã yirãji yʉre boca ãmirã. Ĩnare tirʉ̃nʉgʉ̃ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Riniri masʉ ĩ ejaja, rinicõri sĩagʉ̃ti ejagʉ yiguĩji ĩ. Ito yicõri, ruyuriogʉti ejagʉ yiguĩji ĩocʉ̃. Yʉama masa ĩna catitĩñaroca yigʉ wadirʉ ña yʉ. Ito yicõri, ñe rʉyabeto queno ĩna ñaroca yigʉ wadirʉ ña yʉ. ");
INSERT INTO myy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yʉ ña ovejare queno coderi masʉ. Yʉre tʉorʉ̃nʉrãma yʉ ya oveja bajiro bajirã ñarã yirãji. Yʉ ya oveja bajiro bajirãre goda ĩsirocʉ ñacã yʉ. ");
INSERT INTO myy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sĩgʉ̃ waja bʉjarocʉ ĩ moaja, queno oveja coderi masʉ meje ñaguĩji ĩocʉ̃. Buyairo ĩ ejaja ticõri, ovejare wagogʉ yiguĩji ĩ. Ĩ ya oveja meje ĩna ñajare, ĩnare wagogʉ yiguĩji ĩ. Ito bajiri buyairo ejacõri, ovejare ñiagʉ̃ yiguĩji, ito yicõri ĩnare ĩo bategʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Waja bʉjarocʉ riti sĩgʉ̃ ĩ moaja, ovejare wagogʉ yiguĩji ĩ, ĩ ñarã meje ĩna ñajare. Ĩnare maigʉ̃ meje ñari ĩnare ĩ wagoja no yimenaji ĩre, yi riasoquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Yʉ ña ovejare queno coderi masʉ. Yʉ Jacʉ yʉre ĩ masiro bajiroti, yʉ cʉni ito bajiroti ĩre masia. Ito bajiroti yʉ ya ovejare ti masia yʉ. Ĩnajʉa cʉni ito bajiroti yʉre ti masiama ĩna. Yʉ ya ovejare goda ĩsirocʉ ñacã yʉ. ");
INSERT INTO myy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Adi sãnimʉ gãna meje ñama gãjerã yʉ ya oveja. Ĩna ñama gãjerã masa. Ĩnare cʉni ãmigʉ̃ yigʉja yʉ. Ĩna cʉni yʉre cʉdirã ñama ĩna. Co rʉmʉ co sãnimʉti ñarã yirãji ĩna. Ito yicõri, yʉ sĩgʉ̃ti ñagʉ̃ yigʉja ĩnare coderi masʉ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Godagʉ yigʉja yʉ, mʉcana tʉdi catirocʉ. Ito bajiro yʉ yijare yʉ ñarã catitĩñarã yirãji Dios rãca. Ito bajiri yʉ Jacʉ bʉto yʉre maiami. ");
INSERT INTO myy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Masama yʉre sĩamena yirãji. Yʉmasiti yʉ ãmoro bajiroti masare yiari goda ĩsigʉ̃ yigʉja yʉ. Masare yiari yʉ goda ĩsi ãmoja, iti ña yʉ ãmoro bajiro yʉ yiroti. Ito yicõri, mʉcana tʉdi yʉ cati ãmoja cati masigʉ̃ ña yʉ. Ito bajiro yʉ yi masitoni yʉre cũquĩ yʉ Jacʉ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ito bajiro ĩ yija tʉocõri, judio masa ʉjarã ricati riti tʉoĩacã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Coriarã jãjarã ado bajiro yicã: —Rʉ̃mʉ́ sãñagʉ̃, mecʉri masʉ ĩ ñabojarocati, ¿no yija masa ĩre tʉorʉ̃nʉati? yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gãjerãma ado bajiro yicã ĩna: —Rʉ̃mʉ́ sãñagʉ̃ ĩ ñaja, ito bajiro bʉsibitiborʉ ĩ. Ito yicõri, rʉ̃mʉ́ sãñagʉ̃ ĩ ñaja, cajea mana ĩna tiroca yibitiborʉ, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iti rʉmʉri juebʉcʉ ñacʉ. Jerusalénjʉ Dios ya wi cajero ĩna cʉdabiare basa, mʉcana tʉdi tʉoĩarã basa menicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ide ñurajʉ roca, Salomón wame cʉtiri dʉjajʉare Dios ya wijʉ sãja wacʉ gʉa Jesús rãca. ");
INSERT INTO myy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ito bajiro gʉa baji ñaroca Jesure gãni biacõri, ĩre seniĩacã judio masa: —¿Nocãta, “Ĩ meje ñami ĩ. Ĩti ñami”, mʉre yi masirã yirãjida gʉa? Cristo Dios ĩ cõarʉ mʉ ñaja, adocãtati riojo gʉare gotiya, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ĩna ito yija tʉocõri, ado bajiro cʉdiquĩ Jesús: —Mʉare goticãbojacʉ yʉ. Ito bajibojarocati yʉre tʉorʉ̃nʉbiticʉ mʉa. Yʉ Jacʉ ĩ rotirisena jaje mʉare ĩobojacʉ yʉ. Itire ticõri, “Ĩti ñami”, yi masirʉjabojacʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yʉ ya oveja meje ñari, yʉre tʉorʉ̃nʉbea mʉa. Canʉ mʉare yʉ goticato bajiroti bajia. Yʉ ñarã meje ñari, yʉre tʉorʉ̃nʉbea mʉa, ya yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Oveja ĩna ʉjʉ ocare ĩna tʉo masiro robo bajiro, yʉ ñarã yʉre tʉo masiama ĩna. Yʉ cʉni ĩnare ti masia. Ito yicõri yʉre sʉyarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ĩna catitĩñaroca ya yʉ. Ito bajiri coji godacoa yimenaji ĩna. Sĩgʉ̃jʉa yʉ rʉcorãre ẽmabicʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ĩnare yʉ rʉcotoni yʉre cũquĩ Cʉna. Nijʉa ĩ rẽtoro sẽogʉ̃ maquĩji. Ito bajiri sĩgʉ̃jʉa yʉ rʉcorãre ẽma masigʉ̃ maquĩji ĩja. ");
INSERT INTO myy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉ, ito yicõri yʉ Jacʉ rãca riti ña gʉa, yiquĩ Jesús judio masare. ");
INSERT INTO myy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ito yija mʉcana ĩre rearona gʉ̃ta ãmicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ĩna ito yija ticõri, ado bajiro yiquĩ Jesús ĩnare: —Yʉ Jacʉ ĩ masirisena sʉoriti jaje mʉa tiro riojo quenarise yibojacʉ yʉ. ¿Disejʉa queno yʉ yire waja yʉre gʉ̃ta rearã yirãjida mʉa? yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ĩ ito yijare ado bajiro cʉdicã judio masa: —Mʉ queno yire wajare meje mʉre gʉ̃ta rearã yirãji gʉa. Mʉ ya ocana Diore mʉ bʉsiture waja mʉre rearã yirãji gʉa. Gʉa robo ʉ̃mʉgʉ̃ ñabojagʉti, “Dios ña yʉ”, yiboja mʉ, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ĩna ito yijare Jesús ado bajiro yiquĩ: —“Yʉ bajiroti bajirã ña mʉa cʉni”, yiñi Dios, yi ucare ña mʉa ñicʉsabatia ĩna rotire. ");
INSERT INTO myy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Dios oca riojo ñasarise ña”, yi tʉoĩa mani. Ĩ oca tʉorʉ̃nʉanare, “Yʉ bajiroti bajirã ña mʉa cʉni”, yiñi Dios ĩ oca tutina. ");
INSERT INTO myy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yʉre besecõri adi sitajʉ yʉre cõaquĩ Dios. Ito bajiri, “Dios Macʉ ña yʉ”, yʉ yijare, ¿no yija, “Diore bʉsitua mʉ”, yati mʉa yʉre? ");
INSERT INTO myy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉ Jacʉ ĩ yiro bajiro yʉ yibeja, yʉre tʉobesa. ");
INSERT INTO myy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yʉ Jacʉ ĩ yiro bajiro yʉ yija, yʉre tʉorʉ̃nʉbitibojarãti, yʉ yigore ticõri, “Riti gotiami”, yi tʉoĩarʉja mʉare. Ito bajiri, “Yʉre bajiroti ʉsi cʉtigʉ ñami yʉ Jacʉ. Yʉ cʉni ĩre bajiroti ʉsi cʉtia”, yʉ yija, “Riti gotiami”, yi masirʉja mʉare coji bʉsati, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ito ĩ yija tʉocõri, mʉcana ĩre ñia ãmobojacã ĩna. Jesujʉama rudicoaquĩ. ");
INSERT INTO myy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Rudi wacõri, Jordán wame cʉtirisa sidʉja waquĩ Jesús mʉcana. Ĩre baba cʉti wacʉ gʉa cʉni. Itojʉ ejacõri, Juan ĩ idé gu ñacatijʉ tujaquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jãjarã masa ĩre tirã ejacã. Ĩre ticõri, ado bajiro yicã ĩna: —Tiyamani ĩobitibojagʉti, ãni gaye ĩ gotire gaye, riti gotiñi Juan, yicã masa. ");
INSERT INTO myy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Itojʉ Jesús ñaroca jãjarã ĩre tʉorʉ̃nʉcã masa. ");
INSERT INTO myy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Sĩgʉ̃ ñañi ñarise cõgʉ̃. Ĩ wame cʉtiquĩ Lázaro. Ĩ ñarã romia ñacã María, gajeo Marta. Ĩna ñacã Betania gãna. ");
INSERT INTO myy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Iso María ñacõ Jesús ya gʉbore queno sʉti quenarise jio gugoro. Jiocõri iso ya joana weja carogoro ñacõ iso, Lázaro ocabajio. ");
INSERT INTO myy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro ĩ cõja ticõri, ĩ ñarã romia Jesure oca cõañi ĩna: —Gʉa Ʉjʉ, mʉ baba Lázaro cõ ñami, yi oca cõañi ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iti oca tʉocõri ado bajiro yiquĩ Jesús gʉare: —Adi ñarise ĩre ruyuriobetoja. Godarocʉ meje cõ ñaguĩji ĩ. Ado robojʉa bajia. “Rẽtoro ñasagʉ ñami Dios, ito bajiroti rẽtoro ñasagʉ ñami Dios Macʉ cʉni”, masa ĩna yi rʉ̃cʉbʉotoni, cõ ñaguĩji Lázaro, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Lázaro, ĩ ocabajirã romia María, Martare cʉni tʉo maiñi Jesús. ");
INSERT INTO myy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","“Cõ ñami Lázaro”, yire oca tʉobojagʉti wabitiquĩ Jesús maji. Gʉa ñarijʉ jʉa rʉmʉ ñacõacʉ gʉa Jesús rãca maji. ");
INSERT INTO myy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jʉa rʉmʉ bero gʉa ĩ rãca riasotirãre ado bajiro yiquĩ Jesús: —Ita mʉcana Judea sitajʉ. Lázaro ĩ ñarojʉ wato mani, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ito ĩ yija tʉocõri: —Canʉ bʉsati itojʉ gãna judio masa mʉre gʉ̃tana rea sĩa ãmobojañi ĩna. ¿Itojʉ tʉdi ware tʉoĩati, gʉare riasogʉ mʉ? yi seniĩacʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","“Yʉre ĩna sĩarotijʉ ejabea maji”, yirocʉ ado bajiro cʉdiquĩ Jesús gʉare: —Ʉ̃mʉa co ʉ̃mʉa doce hora busurise ña. Ito bajiri sĩgʉ̃ ĩ wa ucuja jʉatabiquĩji iti busujare. Macãrʉcʉ̃ro busurise iti ñajare ti masigʉ̃ yiguĩji. Ito bajiri jʉatabiquĩji ĩ ʉ̃mʉa ñajare. ");
INSERT INTO myy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ñami ĩ wa ucuja jʉatagʉ yiguĩji, busurise iti manijare, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Itire goticõri mʉcana gaje gotiquĩ Jesús gʉare: —Mani baba Lázaro canicoaguĩji. Ito bajiri ĩre yujiogʉ wajʉ yʉ, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ito ĩ yija tʉocõri: —Gʉa Ʉjʉ, ĩ canija quena ña ĩre. Tujacoagʉ yiguĩji ĩ, yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","“Canigʉ̃ yiguĩji”, Jesús ĩ yija, “Wʉjore, yiguĩji Jesús”, yire masicʉ gʉa. Ito bajiro gʉa tʉoĩabojarocati, Jesuama, “Godacoami”, yireoni yigʉ yiñi ĩ. ");
INSERT INTO myy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","“Yʉre queno tʉo masibeama ĩna”, yi tʉoĩacõri, riojo gʉare gotiquĩ Jesús ĩja: —Lázaro godacoami ĩja. ");
INSERT INTO myy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Queno yigʉti ĩ tʉjʉ ñabisija yʉ. Ito bajicõri yʉre tʉorʉ̃nʉrã yirãji mʉa. “Riti Dios Macʉ ña mʉ”, yʉre yi rʉ̃cʉbʉorã yirãji mʉa. Ĩ tʉ ita ĩja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sĩgʉ̃ Jesús rãca riasotigʉ, gʉa rãca gagʉ Tomás wame cʉtiquĩ. “Sʉ̃rʉ̃arʉ”, yicʉ gʉa ĩre. Ado bajiro yiquĩ ĩ, gʉajʉare: —Ita mani cʉni. Jesús rãcati godana mani cʉni, yiquĩ Tomás gʉa ĩ baba mesare. ");
INSERT INTO myy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betaniajʉ gʉa ejaroca, “Jʉaria rʉmʉri tʉja Lázarore ĩna yujeja bero”, yicã masa, gʉare gotirã. ");
INSERT INTO myy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalén rocajʉa bʉsa ñacʉ Betania. Coji cõre gʉdarecocõ ñacʉ Betania. ");
INSERT INTO myy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ito bajiri jãjarã Jerusalén gãna judio masa ejacã Lázaro ĩ godaja otirã. “Bʉjato bajia, mʉa rĩjorʉ ĩ godaja”, yi María, Martare cʉni guañagõ otirã ejacã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","“Wadiami Jesús”, yire oca tʉocõri, ĩre bocago ejacõ Marta. Maríama ejabiticõ. Wijʉ ñacõañi iso. ");
INSERT INTO myy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesús tʉjʉ ejacõri ado bajiro yicõ Marta: —Yʉ Ʉjʉ, mʉ iti rʉmʉ bʉsa ado mʉ ñajama, bai godabitiborʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","“Ĩ godaja bero ñabojarocati, no Diore mʉ senija, ito bajiroti mʉre ĩsigʉ̃ yiguĩji Dios”, yi tʉoĩa yʉ, yicõ Marta Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iso ito yija tʉocõri: —Mʉ rĩjorʉ tʉdi catigʉ yiguĩji, yiquĩ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ito ĩ yija: —Riti gotia mʉ. Sʉsari rʉmʉ masare tʉdi ĩna catiroca Dios ĩ yiri rʉmʉ, tʉdi catigʉ yiguĩji bai, yi tʉoĩa yʉ, yicõ Marta Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iso ito yija tʉocõri, ado bajiro yiquĩ Jesús: —Yʉ ña tʉdi masa ĩna catiroca yigʉ. Ito yicõri yʉti ña catitĩñare rʉcogʉ. No yʉre tʉorʉ̃nʉgʉ̃ti catitĩñagʉ̃ yiguĩji. Godabojagʉti tʉdi catigʉ yiguĩji ĩocʉ̃ ĩja, yiquĩ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mʉcana tʉdi yʉ ejari rʉmʉ, yʉre tʉorʉ̃nʉ ña yucãrã catitĩñarã yirãji ĩna. Godamenaji ĩna. ¿Itire tʉorʉ̃nʉati mʉ cʉni? yi seniĩaquĩ Jesús Martare. ");
INSERT INTO myy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ito ĩ yija tʉocõri: —Yʉ Ʉjʉ, mʉ yiro bajiroti bajia. Mʉti ña Cristo, Dios ĩ cõarʉ. Mʉti ña Dios Macʉ, adi macãrʉcʉ̃rojʉ wadirʉ. Itire tʉorʉ̃nʉa yʉ, yicõ iso Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Iso ito yija bero iso rĩjoro Maríare jigo wacõ Marta. Iso tʉ ejacõri, ado bajiro Maríare goti rudiyijo iso: —Manire riasori masʉ ito ñami. “Wadijaro”, yimi mʉre, yiyijo Marta iso rĩjorore. ");
INSERT INTO myy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Iso ito yiroca riti wʉmʉcõri, Jesure tigo wadiñi María. ");
INSERT INTO myy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Cʉtojʉ ejabiticʉ gʉa Jesús rãca maji. Marta iso bocacatojʉti ñacʉ gʉa maji. ");
INSERT INTO myy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","María rãca ñañi judio masa, iso yagʉ godajare otirã. Ejori iso wʉmʉ waja ticõri, isore sʉya wadiñi ĩna cʉni. “Masari cumajʉ otigo wagõji”, yi tʉoĩari seyoñi ĩna. ");
INSERT INTO myy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Gʉa tʉ ejacõri Jesús riojo rijomunigãna ñini rũjũcõ María. Ito yicõri ado bajiro ĩre bʉsicõ iso: —Yʉ Ʉjʉ, mʉ iti rʉmʉ bʉsa mʉ ado ñajama, bai godabitiborʉ, yicõ iso Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María iso otija ticõri, iso rãca wadiana judio masa ĩna otija ticõri, bojori bʉjaquĩ Jesús cʉni. Ito bajiri ĩ ya ʉsijʉ bʉto bojori bʉja ñaquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ado bajiro ĩnare seniĩaquĩ Jesús: —¿Nojʉ ĩre yujeri mʉa? yi seniĩaquĩ Jesús. Ito ĩ yija tʉocõri: —Adojʉa tigʉ waya mʉ, yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ĩna ito yija tʉocõri, otiquĩ Jesús ĩja. ");
INSERT INTO myy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jesús ĩ otija ticõri, ado bajiro yicã judio masa: —Tite mʉa. Lázarore bʉto tʉo mairi seyoami ĩ, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gãjerã coriarãma ado bajiro yicã ĩna: —Cajea tibicʉre yisiogʉ ñabojagʉti, ¿no yija Lázaro ĩ godabitiroca yibisijari ĩ? yicã ĩna coriarã. ");
INSERT INTO myy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mʉcana Jesús bojori bʉjagʉti eja rʉ̃gʉ̃quĩ, masari cuma tʉjʉ. Gʉ̃ta toti ñacʉ godarʉre ĩna cũrajʉ. Iti soje gʉ̃tana biare cʉticʉ. ");
INSERT INTO myy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ito yija ado bajiro rotiquĩ Jesús: —Itiga gʉ̃tagã ãmigoya, yiquĩ Jesús. Ito ĩ yija tʉocõri, ado bajiro yicõ Marta, godarʉ ocabajio: —Jʉaria rʉmʉri tʉja ĩ godaja bero. Bʉoro ʉ̃niguĩji ĩja, yicõ iso Jesure. ");
INSERT INTO myy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iso ito yibojarocati: —Yʉre mʉ tʉorʉ̃nʉja, rẽtoro ñasarise Dios gaye tigo yigoja mʉ, mʉre gotibʉ yʉ, yiquĩ Jesús isore. ");
INSERT INTO myy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","“Gʉ̃tagã ãmicãña”, Jesús ĩ yija tʉocõri, gʉ̃tagãre ãmigocã masa. Ito yija macãrʉcʉ̃rojʉare ti mʉocõri, ado bajiro yiquĩ Jesús: —Cʉna, queno ya mʉ. Yʉre tʉoa mʉ. ");
INSERT INTO myy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yʉ masia, coji rʉyabeto yʉre tʉosotia mʉ. Ito bajibojarocati adi sita gãna mʉre ĩna tʉorʉ̃nʉtoni, ĩna tiro riojo mʉ rãca bʉsia yʉ. “Dios ĩ cõarʉ ñami ãni”, ĩna yitoni, mʉ rãca bʉsia yʉ, yiquĩ Jesús, Diore bʉsigʉ. ");
INSERT INTO myy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iti goti tĩogʉ̃ti awasãquĩ Jesús ĩja: —Lázaro, budi waya adojʉa, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ĩna yujebojarʉti budiquĩ Lázaro ĩja. Ĩ ya ricari, ito yicõri ĩ ya rujʉre cʉni sayana dʉrea biarʉ ñaquĩ ĩ. Gʉbori cʉni, ĩ ya rijoga cʉni saya werona biarʉ ñaquĩ. Ruyubicʉ ñaquĩ ĩ. Ito bajiri ado bajiro masare rotiquĩ Jesús: —Ĩre õjaña, ĩ watoni, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ito bajiro Jesús ĩ yija ticõri, jãjarã judio masa Maríare baba cʉtiana Jesure tʉorʉ̃nʉcã ĩna ĩja. “Riti Dios ĩ cõarʉ ñami ãni”, yi tʉorʉ̃nʉcã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gãjerãma fariseo gaye tʉoĩarãre tirã wacã ĩna. Ĩna tʉjʉ ejacõri, Jesús ĩ ĩogore ĩnare gotiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ĩna ito yijare, fariseo gaye tʉoĩarã, paia ʉjarã rãca, ʉjarã ñasarã rãca minijuayijarã. Ito yicõri ado bajiro bʉsiyijarã ĩna: —¿No bajiro yirʉjati mani? Jaje tiyamani ĩogʉ̃ ñami ãni. ");
INSERT INTO myy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ĩre mani camotabeja, masa jeyaro ĩre tʉorʉ̃nʉrã yirãji. Ĩna ito yija ticõri, mani ya minijuara wire ruyuriorã wadirã yirãji romano masa. Ito yicõri manire cʉni ruyuriorã wadirã yirãji ĩna, yi gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Iti rodore paia ʉjʉ Caifás wame cʉtigʉ ñaquĩ. Ĩnare ado bajiro gotiyijʉ ĩ: —Masirã meje ña mʉa. ");
INSERT INTO myy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sĩgʉ̃ mani jeyarore yiari ĩ goda ĩsija quena. Mani jeyarore ĩna ruyurioja quenabetoja, yiyijʉ Caifás. ");
INSERT INTO myy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Paia ʉjʉ ñari, ĩmasirio tʉoĩacõri meje yiyijʉ Caifás. Ĩ masia mani ito bajiro ĩ bʉsiroca yiyijʉ Dios ĩre. Ito bajiro ĩ bʉsija, ijajʉ bajiroti gaye bʉsiyijʉ ĩ. “Judio masa ñajedirore goda ĩsigʉ̃ yiguĩji Jesús. ");
INSERT INTO myy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ĩnare riti meje goda ĩsigʉ̃ yiguĩji ĩ. Dios ĩ beseana di sita gãna rʉyabeto manire goda ĩsigʉ̃ yiguĩji ĩ. Sĩgʉ̃ rĩare bajiro mani ñatoni manire goda ĩsigʉ̃ yiguĩji Jesús”, yigʉ bajiro yiyijʉ ĩ Caifás. ");
INSERT INTO myy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Iti rʉmʉrinati, “¿No bajiro Jesure sĩarʉjati mani?” yi bʉsi ñayijarã judio masa ʉjarã. ");
INSERT INTO myy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ito bajiri masa ĩna tiro riojo wa ucubitiquĩ Jesús ĩja. Judea sita Jesús ĩ wagoja, ĩre sʉya wacʉ gʉa cʉni. Efraín wame cʉtiri cʉto wacʉ gʉa. Yucʉ mano tʉjʉ ñacʉ iti cʉto. Itojʉ tujacʉ gʉa Jesús rãca. ");
INSERT INTO myy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yʉ ñarã judio masa pascua basa ĩna meniroto jabeto rʉyayijʉ. Ito bajiri masa jãjarã wayijarã Jerusalénjʉ. Pascua basa riojʉa ĩna ñeñaro yirise coe rotirã ejayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Itojʉ ejacõri, Jesure ãmabojayijarã ĩna. Dios ya wijʉ ejacõri ado bajiro gãmeri seniĩayijarã ĩna: —¿No bajiro tʉoĩati mʉa? ¿Basa tigʉ ejagʉ yiguĩjida mʉaca? Ejabicʉ yiguĩji gajea, yi gãmeri bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo gaye tʉoĩarã, paia ʉjarã cʉni, “Jesure mʉa ti bʉjaja, gʉare gotiba. Ĩre ñiarona ya gʉa”, yi gotiyijarã ĩna masare. ");
INSERT INTO myy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Coga ãmojeno rʉmʉri pascua basa ĩna meniroto riojʉa Betania wame cʉtiri cʉtojʉ wacʉ gʉa Jesús rãca. Iti cʉto ñacʉ Lázaro ĩ ñaro. Ito ñacʉ Lázarore mʉcana tʉdi ĩ catiroca Jesús ĩ yirajʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesús ĩ ejaja ticõri, ĩre rʉ̃cʉbʉorã ĩre bare meni ĩsicã Lázaro ĩ ocabajirã romia. Marta ñacõ gʉare bare jeogo. Lázaro cʉni gʉa rãca ba rujiquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Gʉa baroca ʉ́ye queno sʉti quenarise nardo wame cʉtirise ãmi ejacõ María. Co coacõ ñacʉ iti. Bʉto waja cʉtirise ñacʉ. Itina Jesús ya gʉbore jio gucõ iso. Ito yicõri iso ya joana weja carocõ iso. Wi dajaroti sʉti dajacoacʉ iti sʉtirise. ");
INSERT INTO myy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Itojʉ ñaquĩ Judas Iscariote. Ĩ cʉni gʉare bajiroti Jesús rãca riasotigʉ ñabojaquĩ. Ĩ ñaquĩ Jesús wajana ĩre ñiatoni gotiri masʉ. Jesús ya gʉbore iso jio guja ticõri, ado bajiro yiquĩ Judas: ");
INSERT INTO myy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Iti ʉ́ye queno sʉti quenarise ĩsicõri, trescientos niyeru cujiri ãmirʉjaboyija mʉ. Iti waja bʉjacõri bojoro bʉjarãre ejabʉarʉjaboyija mʉ, yiquĩ Judas. ");
INSERT INTO myy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Bojoro bʉjarãre tʉo maigʉ̃ meje yiquĩ ĩ, ito ĩ yirise. Riniri masʉ ñari ito bajiro yiquĩ ĩ. Ĩ ñaquĩ gʉa ya niyeru awiruca seori masʉ. Iti awiruca gʉa sãrisere ãmisotiñi ĩ. ");
INSERT INTO myy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ito yija ado bajiro yiquĩ Jesús ĩre: —Ʉsirio codebesa isore. Yʉre ĩna yujerotire tʉoĩa yugo ito bajiro yamo iso. ");
INSERT INTO myy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mʉa rãca riti ñatĩñarã yirãji bojoro bʉjarã. Ito bajiri ĩnare ejabʉatĩñarã yirãji mʉa. Yʉama mʉa rãca ñatĩñabicʉ yigʉja. Ito bajiri mʉa rãca yʉ ñaroca maji yʉjʉare ejabʉaja quena, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","“Betaniajʉ ñaguĩji Jesús”, yire oca, jãjarã tʉoñi judio masa. Jesure riti tirã meje ejacã ĩna. Lázarore tʉdi ĩ catiroca Jesús ĩ yirʉre tirã rãcati wadiñi ĩna. ");
INSERT INTO myy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ito bajiro masa ĩna yija ticõri, Lázarore cʉni sĩare cʉnícã paia ʉjarã. ");
INSERT INTO myy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro ĩ tʉdi catija ticõri, paia ʉjarãre jidicã wacã masa. Ito yicõri Jesure tʉorʉ̃nʉcã ĩna ĩja. Ito bajijare Lázarore cʉni sĩa ãmoñi paia ʉjarã. ");
INSERT INTO myy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ito bero gaje rʉmʉ, “Ado ejagʉ yiguĩji Jesús”, yire oca tʉo jedicã masa. Ĩna ñacã Jerusalénjʉ pascua basa tirã ejana. ");
INSERT INTO myy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ito bajiri Jesure boca ãmirona rujaño caeri ãmicã ĩna. Ito yicõri ado bajiro awasãcã ĩna, ĩre wanʉrã: —Rẽtoro ñasagʉ ñami Dios. Ĩ cõarʉre queno yijaro Dios. Gʉa Israel gãna Ʉjʉ ñarocʉre queno yijaro Dios, yi awasãcã ĩna, ĩre wanʉrã. ");
INSERT INTO myy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Burro wame cʉtigʉre bʉjacõri, mʉja jeaquĩ Jesús. Ito bajiroti yi gotia Dios oca cʉni. Tʉote mʉa: ");
INSERT INTO myy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mʉa Sión cʉto gãna, güibesa. Mʉa Ʉjʉ ñarocʉ burro joe jesa wadiami, yi gotia Dios oca. ");
INSERT INTO myy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Cajero queno tʉo masibiticʉ gʉa Jesús rãca riasotirã maji. Ũmacʉ̃jʉ Jesure rʉ̃cʉbʉorajʉ ĩ mʉjaja bero, “Riti gotia Dios oca. Jeyaro iti gotiado bajiroti rẽtacʉ”, yi masicʉ gʉa ĩja. ");
INSERT INTO myy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Masa jãjarã ticã masari cumajʉ ñagʉ̃ Lázarore tʉdi ĩ catiroca Jesús ĩ yija. Ĩ catija tigoana ñari masa jeyarore goti batoñi ĩna. ");
INSERT INTO myy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ito bajiri, “Tiyamani gaye, ĩoami Jesús”, yire oca tʉocõri, Jesure tirã masa jãjarã ejacã. ");
INSERT INTO myy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ito bajiro masa ĩna yija ticõri, fariseo gaye tʉoĩarã ĩnamasiti gãmeri bʉsiyijarã: —Tiya, masa jeyaro ĩ ocare tʉo sʉya wama ĩja. No yiado ma manire, yiyijarã fariseo gaye tʉoĩarã. ");
INSERT INTO myy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Basa ñaroca Jerusalénjʉ Diore rʉ̃cʉbʉorã wana rãca wʉsayijarã coriarã griego masa. ");
INSERT INTO myy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Felipere oca seniĩarã wayijarã ĩna. Galilea sita Betsaida wame cʉtiri cʉto gagʉ ñaquĩ Felipe. Ado bajiro Felipere yiyijarã ĩna: —Jesure ti ãmosacõa gʉa, yi josayijarã ĩna Felipere. ");
INSERT INTO myy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ĩna ito yija tʉocõri, Andrésre gotigʉ wayijʉ Felipe. Ito bajiri ĩna jʉ̃arã Jesure gotirã ejacã gʉa tʉjʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ĩna oca gotija tʉocõri, ado bajiro yiquĩ Jesús ĩnare: —Yʉ ña Masa Rĩjorʉ. Ũmacʉ̃jʉ rʉ̃cʉbʉorajʉ yʉ tʉdi mʉjarotijʉ ejacoajʉ ĩja. Yʉre ĩna sĩarotijʉ ejacoajʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Riti mʉare gotia yʉ. Trigo aje queno carabetoti jacajʉ iti quedija, judibetoja. Queno caracõri iti quedija, jaje judiro yiroja mʉcana. Godacõri mʉcana tʉdi catiado bajiro bajia iti. ");
INSERT INTO myy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","No ĩ catirise maibojagʉti godagʉ yiguĩji. Ito yicõri Dios tʉ ejabiquĩji ĩ. No adi macãrʉcʉ̃rojʉ ĩ ñarise maibicʉama godabicʉ yiguĩji. Catitĩñare gaye bʉjagʉ yiguĩji ĩocʉ̃ama. ");
INSERT INTO myy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","No yʉre moa ĩsi ãmogʉ̃, yʉre sʉyaja quena. No yʉ ñaroti, ito ñagʉ̃ yiguĩji yʉre moa ĩsigʉ̃ cʉni. No yʉre moa ĩsigʉ̃re rʉ̃cʉbʉogʉ yiguĩji yʉ Jacʉ, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ĩ Jacʉre bʉsigʉ ado bajiro yiquĩ Jesús: —Bʉto tʉoĩa oca jaia yʉ. “Cʉna adocãta yʉre rẽtaroti gaye, iti yʉre rẽtame yirocʉ yʉre masoña”, ¿yirʉjati yʉ? Meje ito bajiro yibicʉja yʉ. Itire tõbʉjarocʉ wadirʉ ña yʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Cʉna, mʉ ãmoro bajiroti rẽtajaro, masa mʉre ĩna rʉ̃cʉbʉotoni, yiquĩ Jesús, Diore bʉsigʉ. Ito ĩ yirocati, ũmacʉ̃jʉ oca ruyucʉ: —Masa yʉre ĩna rʉ̃cʉbʉoroca yicãcʉ yʉ. Mʉcana tʉdi ĩna rʉ̃cʉbʉoroca yigʉ ya yʉ, yire oca ruyucʉ ũmacʉ̃jʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gʉa iti oca tʉocõri: —Bʉjo ñarʉ, yicʉ gʉa coriarã. Gãjerãma: —Ángel bʉsirʉ, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ito bajiro masa ĩna yija tʉocõri, ado bajiro yiquĩ Jesús: —Yʉre yiari meje oca ruyubʉ. Mʉare yiari, mʉa tʉotoni oca ruyubʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Adocãta adi macãrʉcʉ̃ro gãnare Dios ĩ beserotijʉ ejacoajʉ ĩja. Ito yicõri, adi macãrʉcʉ̃ro gãnare ñeñaro yi rotigʉre, ĩre bucõagʉ̃ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Masa yucʉtẽojʉ yʉre ĩna mʉo rʉ̃gõja, jãjarã yʉre ĩna boca ãmiroca yigʉ yigʉja yʉ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","“Ito bajiro godagʉ yiguĩji”, masa ĩna yi tʉo masitoni, ito bajiro gotiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ito ĩ yijare, ado bajiro cʉdicã masa: —Gʉa masa bʉcʉrã papera tuti iti gotija, “Catitĩñagʉ̃ yiguĩji Cristo”, yi gotia iti. ¿No yija, “Masa Rĩjorʉre mʉorã yirãji ĩna”, yati mʉ? ¿Ñimʉ ñati Masa Rĩjorʉ? yicã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ĩna ito yijare ado bajiro cʉdiquĩ Jesús: —Yʉ ña busurise rʉcogʉ, mʉa tʉo masiroca, mʉa ti masiroca cʉni yigʉ. Yoari mejeti mʉare wagogʉ yigʉja yʉ. Yʉ waroto riojʉa mʉare riasogʉ ya yʉ maji. Ito bajiri mʉa rãca yʉ ñaroca riti queno riasotiya mʉa. Ito bajiro mʉa yija queno tʉo masirã yirãji mʉa. Ito yicõri ñeñaro yimenaji mʉa. No rãitĩarojʉ wacʉ, “Ito wagʉja yʉ”, yi masibicʉ yiguĩji. Ito bajiro yibojama ñeñaro yirã. ");
INSERT INTO myy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yʉ ña busurise rʉcogʉ. Yʉre tʉorʉ̃nʉña mʉa, mʉa rãca yʉ ñaroca riti maji. Yʉre mʉa tʉorʉ̃nʉja, queno tʉo masirã yirãji. Ito yicõri yʉ ñarã ñatĩñarã yirãji, yiquĩ Jesús masare. Ito bajiro masare ĩ gotija bero, gʉa masibetojʉ wa godacoaquĩ Jesús ĩja. ");
INSERT INTO myy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jaje tiyamani masa ĩna tiro riojo ĩ ĩobojarocati, ĩre tʉorʉ̃nʉbiticã masa. ");
INSERT INTO myy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ĩna Jesure tʉorʉ̃nʉbeja, Isaías ñayorʉ ĩ ucado bajiroti rẽtacʉ. Ado bajiro ucayoñi ĩ: Gʉa Ʉjʉ, gʉa gotirise sĩgʉ̃ tʉorʉ̃nʉgʉ̃ mami. Ito yicõri, mʉ ĩorisere sĩgʉ̃ tʉorʉ̃nʉgʉ̃ mami, yi ucañi Isaías ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","“Dios ĩ cõarʉre tʉorʉ̃nʉmena yirãji masa”, yirocʉ ado bajiro ucañi Isaías ñayorʉ: ");
INSERT INTO myy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ĩna tibitiroca yigʉ yiguĩji Dios. Ito yicõri ĩna ya ʉsijʉ ĩna tʉo masibitiroca yigʉ yiguĩji Dios. Ito bajiri ĩna ya cajeana ti masimena yirãji ĩna. Ĩna ya ʉsina queno tʉo masimena yirãji ĩna. Ito yicõri, Dios ĩ cõarʉre tʉdi yisio rotimena yirãji ĩna, yi ucañi Isaías ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías ĩ cãirojʉ, bʉto Cristo ĩ ñasarise tiyijʉ ĩ. Ito bajiri iti gaye ucayoñi ĩ. ");
INSERT INTO myy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","“Ito bajiro bajirã yirãji”, Isaías ĩ yire ñabojarocati jãjarã judio masa Jesure tʉorʉ̃nʉcã. Ĩna ʉjarã cʉni coriarã Jesure tʉorʉ̃nʉcã. Masa ĩna tʉoro riojo, “Jesure tʉorʉ̃nʉgʉ̃ ña yʉ cʉni”, yibiticã ĩna. “Fariseo gaye tʉoĩarã manire bucõarã yirãji ĩna”, yirona gotibiticã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Dios gaye rẽto bʉsaro, masa gaye rʉ̃cʉbʉore ãmocã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Gʉa tʉ tʉdi ejacõri, ado bajiro masare oca sẽoro bʉsiquĩ Jesús: —Yʉre tʉorʉ̃nʉrã, yʉre riti meje tʉorʉ̃nʉrã yirãji. Yʉ Jacʉ yʉre cõarʉre cʉni tʉorʉ̃nʉrã yirãji. ");
INSERT INTO myy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yʉre mʉa tija, yʉre cõarʉre cʉni tia mʉa. ");
INSERT INTO myy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yʉ ña busurise rʉcogʉ. Yʉre tʉorʉ̃nʉrã rãitĩarojʉ ĩna ñame yirocʉ, adi macãrʉcʉ̃rojʉre wadicʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yʉ ocare tʉobojagʉti, yʉre ĩ tʉorʉ̃nʉbeja, yʉ meje ña ĩre ruyuriorocʉ. Adi macãrʉcʉ̃ro gãnare ruyuriorocʉ meje wadicʉ yʉ. Masare masorocʉjʉa wadicʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yʉre rʉ̃cʉbʉobiticõri, yʉ ocare tʉorʉ̃nʉbicʉre, ruyuriorocʉ sĩgʉ̃ ñacãguĩji. Yʉ ocare ĩ tʉorʉ̃nʉbiti waja sʉsari rʉmʉ ĩre ruyuriogʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉmasirio meje bʉsia yʉ. Yʉ Jacʉ yʉre cõarʉ, yʉ bʉsiroti, yʉ riasoroti cʉni yʉre cũcãquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","“Yʉ Jacʉ ĩ rotirise gaye ĩna tʉorʉ̃nʉja, catitĩñarã yirãji ĩna”, yi tʉoĩa yʉ. Yʉ bʉsija, yʉ Jacʉ ĩ rotiado bajiroti bʉsia yʉ, yiquĩ Jesús masare. ");
INSERT INTO myy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua basa ñaroto riojʉa, “Yʉ adi macãrʉcʉ̃rore wagocõri yʉ Jacʉ tʉ yʉ waroto ejacoajʉ ĩja”, yi tʉoĩari seyoñi Jesús. Adi macãrʉcʉ̃ro gãnare ĩ ñarãre maisotiquĩ Jesús. “Riti mʉare bʉto maisacõa yʉ”, yi ĩorocʉ, goda ĩsirocʉ ñacãñi Jesús. ");
INSERT INTO myy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Gʉa basʉsaroca Judas Iscariote Simón macʉre ĩ ya ʉsijʉ ñacãri seyoñi rʉ̃mʉ́. Judas ya ʉsijʉ ñacõri, “Jesús wajana ĩre ĩna ñiatoni gotiba”, yi ñari seyoñi rʉ̃mʉ́ Judasre. ");
INSERT INTO myy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ado bajiro yi tʉoĩari seyoñi Jesús, “Dios yagʉ wadirʉ ña yʉ, ito yicõri ĩ tʉ tʉdi wacʉ yigʉja yʉ. Yʉ roti masitoni yʉ Jacʉ ĩ cũrʉ ña yʉ”, yi tʉoĩari seyoñi Jesús. ");
INSERT INTO myy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Gʉa basʉsa ñaroca bare jeoado tʉ rujigʉ wʉmʉ rʉ̃gʉ̃quĩ Jesús. Joegado ĩ sãñaro ruacõri, toallana ĩ ya jeragajʉ wẽo taquĩ. ");
INSERT INTO myy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ito yicõri rujatẽrojʉ ide jioquĩ. Ito yicõri gʉa ya gʉbori coesʉoquĩ Jesús. Coe tĩocõri toalla ĩ wẽo tarona gʉa ya gʉbori caroquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedrore gʉbo ĩ coegʉ wagʉ yiroca ado bajiro yiquĩ Simón Pedro ĩre: —¿Yʉ Ʉjʉ, yʉ ya gʉbore coegʉ yati mʉ? yiquĩ Pedro. ");
INSERT INTO myy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ito ĩ yijare cʉdiquĩ Jesús: —Adocãta mʉa ya gʉbori yʉ coerise queno tʉo masibea mʉa maji. Ija co rʉmʉ masirã yirãji mʉa itire, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ito ĩ yibojarocati: —Yʉ ya gʉbore coebicʉ yigʉja mʉ, yiquĩ Pedro Jesure. Ito ĩ yijare: —Mʉ ya gʉbori yʉ coebeja yʉ rãca gagʉ meje ñagʉ̃ yigʉja mʉ, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ito ĩ yija tʉocõri, cʉdiquĩ Pedro: —Mʉ ito yija, yʉ ya gʉbori riti meje coeya. Yʉ ya ãmo cʉni, yʉ ya rijoga cʉni coeya, yiquĩ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ito ĩ yija tʉocõri, ado bajiro cʉdiquĩ Jesús: —Gua tĩocãrʉre jeyaro rujʉri coere ma. Gʉbori riti coeja quena. Ʉeri mana bajiro bajirã ña mʉa. Ito bajibojarocati sĩgʉ̃ ñami mʉa rãca gagʉ ʉeri jaigʉ bajiro bajigʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","“Ĩ ñami yʉre ĩna ñiatoni gotiri masʉ”, yi masicõri, “Mʉa jeyaro meje ʉeri mana ña mʉa”, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gʉa ya gʉbori coe tĩogʉ̃ joe ĩ sãñaro sãñaquĩ Jesús mʉcana. Bare jeoado tʉ rujicõri ado bajiro yiquĩ ĩ mʉcana gʉare: —¿Mʉare gʉbori yʉ coerise tʉo masiati mʉa? ");
INSERT INTO myy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Gʉare riasogʉ, gʉa Ʉjʉ”, ya mʉa yʉre. Ĩti ña yʉ. Ito bajiro yʉre mʉa yija quena ña. Riojo ya mʉa. ");
INSERT INTO myy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yʉ mʉa Ʉjʉ, mʉare riasogʉ ñabojagʉti mʉa ya gʉbori yʉ coeja, mʉamasi cʉni gãmeri gʉbori coeja quena. ");
INSERT INTO myy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yʉ yiro bajiro mʉa yitoni mʉare ĩocãmʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Riti mʉare gotia yʉ. Sĩgʉ̃ moa ĩsiri masʉ ĩ ʉjʉ rẽtoro ñasabiquĩji ĩ. Sĩgʉ̃ gãji cõarʉ ĩ ñaja ĩre cõarʉ rẽtoro ñasabiquĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Iti yʉ bʉsirise tʉocõri, ito yicõri itire mʉa queno cʉdija, wanʉ quenarã yirãji mʉa, yiquĩ Jesús, gʉare. ");
INSERT INTO myy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mʉcana gaje ado bajiro gotiquĩ Jesús gʉare: —Mʉa jeyarore tʉoĩagʉ̃ meje bʉsia yʉ. “Ĩna ñama yʉ beseana”, yi masia yʉ. Dios ĩ bʉsigore rẽtaro ya. Ado bajiro gotia iti ĩ oca tutina: “Yʉ rãca bagʉ ñabojagʉti yʉre jidicãgʉ̃ yiguĩji”, yi gotia Dios oca. ");
INSERT INTO myy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iti rẽtaroto riojʉa mʉare gotia yʉ. Ito bajiri iti rẽtaja ticõri, “Dios cõarʉ ña yʉ”, yʉ yiro bajiroti yʉre tʉorʉ̃nʉrã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Riti mʉare gotia yʉ, Yʉ cõanare boca ãmirã yʉre cʉni boca ãmirã yirãji. Noa yʉre boca ãmirã yʉre cõarʉre cʉni boca ãmirã ñama ĩnaõna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ito bajiro ĩ yija bero, ĩ ya ʉsijʉ bʉto tʉoĩa bojori bʉjaquĩ Jesús. Queno riojo gʉare gotigʉ ado bajiro yiquĩ ĩ: —Riti mʉare gotia yʉ. Yʉre ĩna ñiatoni yʉ wajanare gotigʉ yiguĩji mʉa rãca gagʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ito ĩ yija tʉocõri, gʉa ĩ rãca riasotirã gʉamasiti gãmeri ticʉ. “Ĩre bʉsiguĩji”, yi masibiticʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yʉ ĩ rãca riasotigʉre bʉto maiquĩ Jesús. Ito bajiri gʉa basʉsacati rʉmʉ ĩ tʉ ba rujicʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","¿Ñimʉre tʉoĩagʉ̃ bʉsiati mʉ? yi Jesure yʉ seniĩatoni yʉre ti ñucaquĩ Simón Pedro. ");
INSERT INTO myy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ito ĩ yija ticõri, Jesús tʉ bʉsa eja rũjũcõri, ĩre seniĩacʉ yʉ: —Yʉ Ʉjʉ, ¿ñimʉjʉa ñati mʉre oca menirocʉ? yicʉ yʉ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ado bajiro cʉdiquĩ Jesús yʉre: —Najuro yosecõri, yʉ ĩsigʉ̃, ĩ ñagʉ̃ yiguĩji, yiquĩ Jesús yʉre. Ito bajiro ĩ yija bero, Judas Iscariote Simón macʉre ĩsiquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Iti naju ĩ boca ãmirocati rʉ̃mʉ́a ʉjʉ Satanás sãjacoari seyoquĩ Judas ya ʉsijʉ. Ito bajijare ado bajiro yiquĩ Jesús ĩre: —Yʉre mʉ oca meni ãmorise cojisiti wacõri oca meniña, yiquĩ Jesús Judasre. ");
INSERT INTO myy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ĩ rãca ba rujicãna gʉa sĩgʉ̃jʉa ito bajiro ĩ bʉsirisere tʉo masibiticʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gʉa ya niyeru awirucare tirʉ̃nʉgʉ̃ ñaquĩ Judas. Ito bajiri, “Basa rʉmʉ ñaroca mani baroti waja yitẽña”, yiguĩji Jesús, yire masicʉ gʉa. “Bojoro bʉjarãre niyeru ĩsitẽña”, yiguĩji gajea, yire masicʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Naju Jesús ĩ ĩsirise boca bacõri, wacoaquĩ ĩ ĩja. Ito bajiro ĩ yiroca ñamijʉ ñacoacʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ĩ wagoja bero ado bajiro yiquĩ Jesús gʉare: —Ũmacʉ̃jʉ, yʉ Masa Rĩjorʉ, yʉre rʉ̃cʉbʉorojʉ ware ejacoajʉ ĩja. Yʉre rẽtaroti gaye ticõri, Diore rʉ̃cʉbʉorã yirãji masa. ");
INSERT INTO myy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Diore masa ĩna rʉ̃cʉbʉoroca yʉ yija, yʉre cʉni ĩna rʉ̃cʉbʉoroca yigʉ yiguĩji Dios. Yoari mejeti ito bajiro yigʉ yiguĩji Dios. ");
INSERT INTO myy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉ rĩa robo bajirã ña mʉa. Mʉa rãca yoari ñabicʉja yʉ ĩja. Yʉre ãmabojarã yirãji mʉa. Canʉ gãjerã judio masare yʉ goticato bajiroti adocãta mʉare cʉni gotia yʉ. “Yʉ waroto wa masimenaji mʉa”, ya yʉ mʉare cʉni. ");
INSERT INTO myy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Adocãta mame rotire gaye mʉare gotigʉ ya yʉ. Ado bajiro bajia iti. Gãmeri ti maima mʉa. Mʉare yʉ ti mairo bajiroti mʉa cʉni gãmeri ti maija quena. ");
INSERT INTO myy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mʉa gãmeri ti maija ticõri, “Jesús rãca riasotirã ñama ĩna”, yirã yirãji masa jeyaro. ");
INSERT INTO myy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ito ĩ yija tʉocõri, Jesure seniĩaquĩ Simón Pedro: —Yʉ Ʉjʉ, ¿nojʉ wacʉ yati mʉ? yiquĩ Pedro ĩre. Ito bajiro ĩ yijare: —Adocãta yʉ warotojʉ wa masibicʉja mʉáma maji. Ija yʉre sʉyagʉ yigʉja mʉcana, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ito ĩ yija tʉocõri: —Yʉ Ʉjʉ, ¿no yija adocãta mʉ rãca wa masibicʉjada yʉ? Gãjerã yʉre ĩna sĩabojarocati mʉre jidicãbicʉja yʉ. Mʉre goda ĩsirocʉ ñacã yʉ, yiquĩ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ito ĩ yijare cʉdiquĩ Jesús: —¿Riti yʉre goda ĩsirocʉ ñacãti mʉ? Riti mʉre gotia yʉ. Cara ĩ yujiroto riojʉa ʉdiaji, “Jesure masibea yʉ”, yigʉ yigʉja mʉ, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mʉcana gaje ado bajiro gotiquĩ Jesús gʉare: —Bʉto tʉoĩa ʉsirio yibeja mʉa. Diore tʉorʉ̃nʉcõri, yʉre cʉni tʉorʉ̃nʉña. ");
INSERT INTO myy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cʉna ya wi mʉa ñarotijʉri jaje ñaroja. Ito bajiro iti bajibeja mʉare gotibitiboa yʉ. Itojʉ mʉa ñarotijʉ queno yugʉ wajʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ito wacõri mʉa ñarotijʉri queno tĩogʉ̃ mʉcana tʉdi wadigʉ yigʉja yʉ. Ito yicõri yʉ ñarojʉ mʉa ñatoni mʉare ãmigʉ̃ ejagʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yʉ warotijʉ masia mʉa. Ito yicõri itojʉ wara mare masia mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ito ĩ yibojarocati ado bajiro yiquĩ Tomás: —Gʉa Ʉjʉ, mʉ warotore masibea gʉa. ¿No bajiro ito wara mare masirã yirãjida gʉa? yiquĩ Tomás Jesure. ");
INSERT INTO myy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ito ĩ yijare ado bajiro cʉdiquĩ Jesús: —Yʉ ña ito wara ma bajiro bajigʉ. Yʉti ña riojo gotigʉ. Yʉti ña catitĩñare rʉcogʉ. Yʉ sĩgʉ̃na sʉoriti yʉ Jacʉ tʉ ejare ñaro yiroja. ");
INSERT INTO myy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yʉre mʉa ti masija yʉ Jacʉre cʉni ti masirã yirãji mʉa. Yʉre ticõri ĩre ticã mʉa. Ito bajiri ĩre ti masirã ña mʉa ĩja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ito ĩ yijare ado bajiro yiquĩ Felipe ĩre: —Gʉa Ʉjʉ, mʉ Jacʉre gʉa tiroca yiya. Ito bajiro mʉ yija quena ñaroja gʉare. “Riti gotia mʉ”, yi masirã yirãji gʉa ĩja, yiquĩ Felipe Jesure. ");
INSERT INTO myy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ito ĩ yijare: —Iti rʉmʉjʉ mʉa rãca ñasʉocʉ Felipe yʉ. ¿No yija ito bajibojarocati yʉre ti masibeati mʉ maji? Noa yʉre tigoana yʉ Jacʉre cʉni tirã ñama. Ito bajiri, ¿no yija ĩre tigoana ñabojarãti, “Mʉ Jacʉre gʉa tiroca yiya”, yati mʉa yʉre? ");
INSERT INTO myy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","“Yʉ Jacʉ rãca ña yʉ. Ĩ cʉni yʉ rãca ñami”, yʉ yija, ¿yʉre tʉorʉ̃nʉbeati mʉa? Yʉ mʉare bʉsirise yʉmasi tʉoĩa rujeocõri meje bʉsia yʉ. Yʉ Jacʉ yʉ rãca ñagʉ̃, yʉna sʉoriti ĩ moarise yami ĩ. ");
INSERT INTO myy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Yʉ Jacʉ rãca ña yʉ. Ĩ cʉni yʉ rãca ñami”, yʉ yija yʉre tʉorʉ̃nʉña. Yʉ bʉsirise mʉa tʉorʉ̃nʉ ãmobeja, tiyamani yʉ ĩorise ticõri, yʉre tʉorʉ̃nʉña. ");
INSERT INTO myy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Riti mʉare gotia yʉ. No yʉre tʉorʉ̃nʉgʉ̃, yʉ yiro bajiroti yigʉ yiguĩji. Yʉ Jacʉ tʉ wacʉ ya yʉ. Dios tʉ yʉ tʉdi wajare, tiyamani yʉ ĩogore rẽto bʉsaro tiyamani ĩorãji mʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yʉre mʉa tʉorʉ̃nʉja, no mʉa seniro bajiroti mʉare ĩsigʉ̃ yigʉja yʉ. Ito bajiro yʉ yijare, yʉ Jacʉre rʉ̃cʉbʉorã yirãji masa. ");
INSERT INTO myy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yʉre mʉa tʉorʉ̃nʉja, no mʉa seniro bajiroti cʉdigʉ yigʉja yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Yʉre mʉa maija yʉ rotirisere cʉdirã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ito bajiro mʉa yija yʉ Jacʉre senigʉ̃ yigʉja yʉ, yʉre wasoarocʉ ĩ cõatoni. Ĩ cõarocʉ ĩ ñagʉ̃ yiguĩji Espíritu Santo riojo gotigʉ. Mʉa rãca ñatĩñagʉ̃ yiguĩji mʉare ejabʉarocʉ. Ito yicõri mʉa bojori bʉjaja mʉare baba cʉtigʉ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Adi macãrʉcʉ̃ro gãna ĩre ti masibeama ĩna. Ito bajiri ĩre boca ãmi masimenaji ĩna. Mʉa rãca ĩ ñajare, ĩre masirã ña mʉama. Mʉa ya ʉsijʉ ñatĩñagʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mʉare jidicãbicʉ yigʉja yʉ. Mʉcana mʉa rãca ñarocʉ ejagʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yoari mejeti wacʉ ya yʉ ĩja. Ito bajiri yʉre tʉorʉ̃nʉmenama yʉre timenaji ĩja. Mʉama tʉdi yʉre tirã yirãji. Tʉdi catigʉ yigʉja yʉ. Ito bajiri mʉa cʉni catirã yirãji. ");
INSERT INTO myy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","“Yʉ Jacʉ rãca ña yʉ. Ito yicõri mʉa rãca ña yʉ, mʉajʉa cʉni yʉ rãca ña”, yʉ yicato bajiro, tʉdi yʉ catiri rʉmʉ, “Riti gotiñi Jesús”, yi tʉoĩarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉ rotirise masicõri cʉdigʉ ĩocʉ̃ti ñami yʉre maigʉ̃. Yʉre maigʉ̃re maigʉ̃ yiguĩji yʉ Jacʉ cʉni. Yʉ cʉni ĩre maigʉ̃ yigʉja. Ito yicõri yʉre ĩ ti masiroca yigʉ yigʉja yʉ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ito ĩ yija tʉocõri, Judas Iscariote meje, gãji Judas wame cʉtigʉ ado bajiro ĩre cʉdiquĩ: —Gʉa Ʉjʉ, ¿no yija adi macãrʉcʉ̃ro gãnare ĩobicʉti, gʉare riti goaĩogʉ̃ yigʉjada mʉ? yi seniĩaquĩ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ito ĩ yijare: —No yʉre mairã, yʉ bʉsirise tʉorʉ̃nʉrã yirãji. Ito bajiri yʉ Jacʉ ĩnare maigʉ̃ yiguĩji. Ito bajiri yʉ cʉni yʉ Jacʉ rãca ĩna tʉ ñarã wadirã yirãji gʉa. ");
INSERT INTO myy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","No yʉre ti maibicʉ yʉ bʉsirise tʉorʉ̃nʉbiquĩji. Yʉ bʉsija mʉa tʉorise yʉmasi tʉoĩa rujeocõri bʉsire meje ña. ");
INSERT INTO myy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Mʉa rãca yʉ ñarijʉgoti itire mʉare gotia yʉ. ");
INSERT INTO myy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yʉre wasoarocʉre Espíritu Santo cõagʉ̃ yiguĩji yʉ Jacʉ. Mʉare ejabʉagʉ yiguĩji ĩ. Ito yicõri mʉa bojori bʉjaja mʉare baba cʉtigʉ yiguĩji ĩ. Jeyaro mʉare riasogʉ yiguĩji ĩ. Jeyaro mʉare yʉ gotirise mʉa tʉoĩa bʉjaroca yigʉ yiguĩji ĩ, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Gaje ado bajiro gotiquĩ Jesús gʉare: —Mʉare ware gotigʉ, “Ñe oca mano queno ñama mʉa”, ya yʉ mʉare. Mʉa queno ñaroca ya yʉ. Adi macãrʉcʉ̃ro gãnama queno mʉa ñaroca yi masimenaji. Yʉ ña mʉa tʉoĩa ʉsiriobeto ñaroca yigʉ. Ito bajiri tʉoĩa ʉsirio yibesa. Ito yicõri güibesa. ");
INSERT INTO myy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Wacʉ ya yʉ, ito bajibojarocati mʉa rãca ñagʉ̃ ejagʉ yigʉja mʉcana”, yʉ yija tʉobʉ mʉa. Riti yʉre mʉa maija, “Yʉ Jacʉ tʉ wacʉ ya yʉ”, yʉ yija, queno wanʉ quenaboa mʉa. Ĩ ñami yʉ rẽto bʉsaro ñagʉ̃. ");
INSERT INTO myy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jeyaro iti rẽtaroto riojʉa iti mʉare gotia yʉ. Ito bajiri iti rẽtaja ticõri, yʉre tʉorʉ̃nʉrã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Yoari mejeti mʉare bʉsigʉ ya yʉ. Adi macãrʉcʉ̃ro gãnare ñeñaro yi rotigʉ wadicõaguĩji rʉ̃mʉ́a ʉjʉ. Yʉre roti masigʉ̃ meje ñami ĩ. ");
INSERT INTO myy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yʉ Jacʉ ĩ rotiado bajiroti ya yʉ. Ito bajiro yʉ yija ticõri, “Ĩ Jacʉre maigʉ̃ ñami ĩ”, yi yirãji adi macãrʉcʉ̃ro gãna, yiquĩ Jesús gʉare. Ito bajiro ĩ yija bero: —Ita, adijʉre wagoto mani, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mʉcana gaje ado bajiro gotiquĩ Jesús gʉare: —Ʉyégʉ ñasaricʉ robo bajigʉ ña yʉ. Ʉyégʉre tirʉ̃nʉgʉ̃ robo bajiro bajigʉ ñami yʉ Jacʉ. ");
INSERT INTO myy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yʉ ya rʉjʉri iti rica manija jatagʉ yiguĩji ĩ. Yʉ ya rʉjʉri iti rica cʉtija, queno tirʉ̃nʉgʉ̃ yiguĩji, jai bʉsaro iti rica cʉtitoni. Yʉ ya rʉjʉri gaja iti siniaja itire bejagʉ yiguĩji ĩ. Ito yicõri gajeoni iti judija itire ãmicãgʉ̃ yiguĩji, jai bʉsaro iti rica cʉtitoni. ");
INSERT INTO myy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yʉ riasorise tʉorʉ̃nʉcõri queno ña mʉa. Ʉeri mana bajiro bajia mʉa. ");
INSERT INTO myy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yʉre bajiroti ʉsi cʉtisotiya mʉa cʉni. Ito bajiro mʉa yija, mʉa rãca ñatĩñagʉ̃ yigʉja yʉ. Yucʉ rʉjʉ rujagʉre iti wãñabeja rica mano yiroja. Iti bajiroti yʉre mʉa tʉorʉ̃nʉbeja yʉre queno moa ĩsimenaji mʉa. Yʉre moa ĩsibiticõri, ʉyégʉ rica manigʉ̃ bajiro bajirã yirãji mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Gaje gʉare ado bajiro riasoquĩ ĩ: —Yʉ ña rujagʉ robo bajigʉ. Yʉ ya rʉjʉri robo bajirã ña mʉa. No yʉre bajiro ʉsi cʉtirã ĩna rãca yʉ ñajare, yʉre queno moa ĩsirã yirãji ĩna. Ito yicõri rica cʉtirã bajiro bajirã yirãji ĩna. Yʉ manija no yi masimenaji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","No yʉ rãca sĩgʉ̃re bajiro ʉsi cʉtibicʉre ĩre cõagʉ̃ yiguĩji yʉ Jacʉ. Siniara rʉjʉrire ãmicõri, jeamejʉ soeado bajiro yigʉ yiguĩji yʉ Jacʉ ĩocʉ̃re. ");
INSERT INTO myy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Yʉre bajiro ʉsi cʉtisoticõri yʉ riasorise ãcabojabiticõri mʉa ãmoro bajiro mʉa senija, mʉa ãmoro bajiroti cʉdigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yʉre mʉa queno moa ĩsija ticõri, yʉ Jacʉre queno rʉ̃cʉbʉorã yirãji masa. Ito yicõri, “Riti Jesús rãca queno riasotiana ñama ãna”, yi masirã yirãji masa mʉare. ");
INSERT INTO myy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉ Jacʉ yʉre ĩ mairo bajiroti mʉare maia yʉ. Yʉ mairã ña mʉa. Ito bajiri ito bajiroti ñaña mʉa. ");
INSERT INTO myy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉ rotirise mʉa cʉdi ñasotija, yʉ mairã ñatĩñarã yirãji mʉa. Ito bajiroti yʉ Jacʉ ĩ rotirise cʉdisotia yʉ cʉni. Ito bajiri yʉre maisotiami Cʉna. ");
INSERT INTO myy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Yʉ rãca mʉa wanʉ quenatoni itire mʉare gotia yʉ. Ito yicõri mʉa ya ʉsijʉ queno mʉa wanʉ quenatoni, itire mʉare gotia yʉ. ");
INSERT INTO myy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ado bajiro bajia yʉ rotirise: Yʉ mʉare mairo bajiroti, mʉa gãmeri ti maija quena. ");
INSERT INTO myy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sĩgʉ̃ ĩ baba mesare maigʉ̃, ĩnare ĩ goda ĩsija iti ña bʉto maire gaye. ");
INSERT INTO myy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yʉ rotiro bajiroti mʉa cʉdija, yʉ baba mesa ñarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ito bajiri, “Yʉre moa ĩsirã ña mʉa”, yibea yʉ ĩja mʉare. Moa ĩsiri masama ĩna ʉjʉ yirisere masimenaji ĩna. “Yʉ baba mesa ña mʉa”, ya yʉ mʉare adocãta. Jeyaro yʉ Jacʉ yʉre ĩ gotire mʉa masiroca yicãcʉ yʉ. Ito bajiri yʉ baba mesa ña mʉa. ");
INSERT INTO myy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉa meje ña yʉre beseana. Yʉjʉa mʉare besecʉ. Mʉare cũa yʉ, yʉ ocare gãjerãre mʉa riasotoni. Ito bajiro mʉa yija coriarã queno yʉre tʉorʉ̃nʉsotirã yirãji ĩna. Iti ña rica jogabiti robo bajirise. Ito bajiro masare mʉa riasoja ticõri, yʉre mʉa seniro bajiroti ĩsigʉ̃ yiguĩji yʉ Jacʉ. ");
INSERT INTO myy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ado robojʉa ña mʉare yʉ rotirise: “Gãmeri ti maiña mʉa”, yi rotia yʉ mʉare, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Gaje gʉare ado bajiro riasoquĩ Jesús: —Adi macãrʉcʉ̃ro gãna mʉare ĩna ti tudija, “Manire ĩna ti tudiroto riojʉa Jesure ti tudisʉoñi ĩna”, yi tʉoĩarã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Adi macãrʉcʉ̃ro gãna ĩna ñarãre mairãji. Adi macãrʉcʉ̃ro gãna ĩna tʉoĩaro bajiro mʉa tʉoĩaja, mʉare cʉni maiboana ĩna. Adi macãrʉcʉ̃ro gãna wato ñarãre mʉare besecʉ yʉ. Adocãta ĩna bajiro tʉoĩarã meje ña mʉa. Ito bajiri mʉare ti tudiama ĩna. ");
INSERT INTO myy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yʉ bʉsirise tʉote mʉa: “Moa ĩsiri masa ĩna ʉjʉ rẽto bʉsaro ñasarã meje ñama ĩna”, yiari mʉare gotibʉ yʉ. Adi macãrʉcʉ̃ro gãna yʉre ʉsirio codeama. Ito bajiri mʉare cʉni ʉsirio coderã yirãji ĩna. Yʉ riasorisere cʉdibiticã ĩna. Ito bajiri mʉare cʉni cʉdimena yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yʉre cõarʉre masibeama adi macãrʉcʉ̃ro gãna. Ito bajiri yʉ ñarã mʉa ñajare, mʉare ʉsirio coderã yirãji ĩna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Gaje gʉare ado bajiro riasoquĩ Jesús: —Adi macãrʉcʉ̃ro gãnare bʉsirocʉ yʉ wadibeja ĩnare seti maniboadoja. Yʉ ĩnare gotija bero ñajare, “Gʉare seti ma”, yi masibeama ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","No yʉre ti tudirã yʉ Jacʉre cʉni ti tudirã ñama ĩna. ");
INSERT INTO myy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ĩna tiro riojo tiyamani yʉ ĩobeja seti maniboadoja ĩnare. Tiyamani yʉ ĩoja tigoana ñama ĩna. Tigoana ñabojarãti yʉre ti tudiama ĩna. Ito yicõri yʉ Jacʉre cʉni ti tudiama ĩna. ");
INSERT INTO myy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ĩna ya papera tuti ucare gaye iti gotiado bajiroti rẽta adocãta. Ado bajiro gotia iti: “Ñe manoti yʉre ti tudiama ĩna”, yi gotia iti oca. ");
INSERT INTO myy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Espíritu Santo riojo gotigʉre mʉa tʉ cõagʉ̃ yigʉja yʉ. Mʉare ejabʉagʉ yiguĩji ĩ. Ito yicõri mʉa bojori bʉjaja mʉare baba cʉtigʉ yiguĩji. Yʉ Jacʉ tʉ wadirʉ ñagʉ̃ yiguĩji ĩ. Yʉ gaye mʉare gotigʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Cajerojʉti yʉ riasosʉorocajʉti yʉ rãca ñasʉocʉ mʉa. Ito bajiri masare mʉa riasoja mʉa cʉni yʉ gaye bʉsirã yirãji mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Gaje gʉare ado bajiro gotiquĩ Jesús: —Adi oca mʉare gotia yʉ, ija iti rẽtaroca yʉre mʉa jidicãme yirocʉ. ");
INSERT INTO myy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ija ĩna ya minijuara wijʉ mʉa ñaroca mʉare bucõarã yirãji ĩna. Ito yicõri mʉare ĩna sĩaja, “Diore cʉdirã sĩa mani”, yi tʉoĩabojarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ito bajiro yirã yirãji ĩna, yʉre cʉni yʉ Jacʉre cʉni masimena ñari. ");
INSERT INTO myy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iti oca mʉare gotia yʉ. Ija ito bajiro iti rẽtaroca, “Ito bajirogo yiquĩda Jesús”, yi mʉa tʉoĩa bʉjatoni, mʉare gotia yʉ. ’Cajero mʉare riasogʉ iti oca gotibiticʉ yʉ maji. “Ĩna rãca ñagʉ̃ yigʉja yʉ maji”, yi tʉoĩagʉ̃ iti oca mʉare gotibiticʉ yʉ maji. ");
INSERT INTO myy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yʉre cõarʉ tʉ ñagʉ̃ wacʉ ya yʉ adocãta. Ito bajibojarocati, “¿No wati mʉ?” yi seniĩabea mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Iti oca mʉare yʉ gotijare mʉa ya ʉsijʉ bojori bʉja mʉa. ");
INSERT INTO myy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Riti mʉare gotia yʉ. Yʉ waja quena ñaro yiroja mʉare. Yʉ wabeja, mʉare ejabʉarocʉ, mʉa bojori bʉjaja mʉare baba cʉtirocʉ mʉa rãca ñagʉ̃ wadibiquĩji Espíritu Santo. Yʉ wajama ĩre cõagʉ̃ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ĩ wadija, “Ñeñaro yirã ña mani”, adi macãrʉcʉ̃ro gãna yi ĩna tʉoĩaroca yigʉ yiguĩji ĩ. “Quenarise mani yija, Diore cʉdirãji mani”, ĩna yi masiroca yigʉ yiguĩji Espíritu Santo. “Diore mani cʉdibeja manire waja senigʉ̃ yiguĩji”, ĩna yi masiroca yigʉ yiguĩji Espíritu Santo. ");
INSERT INTO myy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Adi macãrʉcʉ̃ro gãna yʉre tʉorʉ̃nʉbitiana ñari seti cʉtirã ñama ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yʉ Jacʉ ĩ ñarojʉ yʉ wajare, “Quenarise mani yija, Diore cʉdirãji mani”, yi masirã yirãji masa. Yʉ Jacʉ tʉ yʉ wajare, yʉre timena yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Adi macãrʉcʉ̃ro gãnare ñeñaro yi rotigʉ Satanásre ruyuriogʉ yiguĩji Dios. Ito bajiri, “Diore mani tʉorʉ̃nʉja ĩ yiro bajiroti jeame ʉ̃jʉrojʉ cõabicʉ yiguĩji Dios, manire”, masa ĩna yi masiroca yigʉ yiguĩji Espíritu Santo. ");
INSERT INTO myy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Jaje gotiroti ñaboja yʉre maji. Ito bajibojarocati adocãta yʉ goti jeoja itire tʉo masimenaji mʉa maji. ");
INSERT INTO myy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Espíritu Santo riojo gotigʉ ĩ ejaroca riojo oca ñasarise mʉare riasogʉ yiguĩji ĩ. Ĩmasirio meje bʉsigʉ yiguĩji. Ĩ tʉogore mʉare gotigʉ yiguĩji. Ija rẽtaroti gaye mʉa masiroca yigʉ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yʉ riasorise gaye boca ãmicõri mʉa masiroca yigʉ yiguĩji Espíritu Santo. Ito bajiro yicõri masa yʉre ĩna rʉ̃cʉbʉoroca yigʉ yiguĩji Espíritu Santo. ");
INSERT INTO myy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ñarocõti yʉ Jacʉ ĩ gotiro bajiroti gotia yʉ cʉni. Ito bajiri, “Yʉ riasorise boca ãmicõri, mʉa masiroca yigʉ yiguĩji Espíritu Santo”, yibʉ yʉ mʉare, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Gaje gʉare ado bajiro gotiquĩ Jesús: —Yʉ Jacʉ tʉ wacʉ ya yʉ. Ito bajiri nocõ mejeti yʉre timena wana ya mʉa. Ito bajibojarocati mʉcana yoari mejeti tʉdi yʉre tirã yirãji mʉa, yiquĩ Jesús gʉa ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ito ĩ yija tʉocõri, gʉa coriarã ado bajiro gãmeri seniĩacʉ gʉa: —¿No yireoni ñati iti? yicʉ gʉa. “Yʉ Jacʉ tʉ wacʉ ya yʉ, ito bajiri yʉre timena wana ya mʉa. Ito bajibojarocati mʉcana yoari mejeti yʉre tirã wana ya mʉa”, yami manire. ¿No yireoni ñati iti? yicʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Yoari mejeti”, manire ĩ yija, ¿no yireoni ñarojada? “Iti gaye bʉsiguĩji, yi masibea mani”, yi gãmeri bʉsicʉ gʉa Jesús rãca riasotirã. ");
INSERT INTO myy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","“Yʉre seniĩa ãmoama ãna”, yi tʉoĩari seyoquĩ Jesús. Ito bajiri ado bajiro yiquĩ ĩ gʉare: —Yoari mejeti yʉre timena wana ya mʉa. Ito bajibojarocati mʉcana nocõ mejeti yʉre tirã wana ya mʉa, yibʉ yʉ mʉare. Ito bajiro yʉ yirise, ¿mʉamasiti gãmeri seniĩati mʉa? ");
INSERT INTO myy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Riti mʉare gotia yʉ. Oticõri, bʉto bojori bʉjarã yirãji mʉa. Adi macãrʉcʉ̃ro gãnama wanʉrã yirãji ĩna. Bojori bʉjarã ñabojarãti yoari mejeti mʉcana tʉdi wanʉrã yirãji mʉa. ");
INSERT INTO myy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ado bajiro bajia: Sĩgõ romio macʉ rʉcogo wago iso yija, tʉoĩa oca jaigo yigõji, “Yʉre juniro yiroja”, yiroco. Iso macʉ rʉcoja bero junirise gaye tʉdi tʉoĩabeco yigõji iso. Adi macãrʉcʉ̃rojʉre macʉacã ĩ rujeajare bʉto wanʉ quenagõ yigõji iso. ");
INSERT INTO myy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ito bajiroti mʉa cʉni adocãta tʉoĩa oca jaia. Mʉcana mʉare tigʉ ejagʉ yigʉja yʉ. Yʉre mʉa tija mʉa ya ʉsijʉ bʉto wanʉrã yirãji mʉa. Ito bajiro mʉa wanʉja, ñimʉjʉa mʉare camota masibiquĩji. ");
INSERT INTO myy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Iti rʉmʉ iti ejaja ñejʉa yʉre senimena yirãji mʉa. Riti mʉare gotia yʉ. Yʉre tʉorʉ̃nʉcõri, yʉ wamena yʉ Jacʉre mʉa senija, mʉa seniro bajiroti ĩsigʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Adi riojʉa yʉ wamena senibiticʉ mʉa maji. Adi rʉmʉna yʉ wamena senisʉorã ya mʉa. Ito bajiri queno mʉa wanʉ quenatoni mʉa boca ãmiroca yigʉ yiguĩji Dios, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Gaje gʉare ado bajiro gotiquĩ Jesús: —Iti mʉare yʉ gotirise goti masiore ocana gotibʉ yʉ. Ija ñaro yiroja goti masiore ocana meje mʉare yʉ bʉsiri rʉmʉ. Recoti mʉa tʉoro riojo yʉ Jacʉ gaye mʉare bʉsigʉ yigʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Iti rʉmʉri yʉ wamena yʉ Jacʉre senirã yirãji mʉa. Ito bajiri mʉare yiari yʉ Jacʉre bʉsi ĩsire mano yiroja. Mʉamasiti bʉsirã yirãji ĩja. ");
INSERT INTO myy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mʉare yiari yʉ Jacʉre bʉsi ĩsibicʉja yʉ ĩja. Yʉ Jacʉmasiti mʉare maicãmi. Yʉre mʉa maijare yʉ Jacʉ mʉare maicãmi. “Dios yagʉ wadirʉ ñami Jesús”, mʉa yijare mʉare maicãmi ĩ. ");
INSERT INTO myy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉ Jacʉ tʉ wadicõri, adi macãrʉcʉ̃rojʉ ejacʉ yʉ. Adi macãrʉcʉ̃ro gãnare wagocõri, yʉ Jacʉ tʉ wacʉ ya yʉ mʉcana, yiquĩ Jesús gʉa ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ito ĩ yija tʉocõri, cʉdicʉ gʉa: —Goti masiore ocana meje, queno riojo gotia mʉ adocãta. ");
INSERT INTO myy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","“Jeyaro masigʉ̃ ña mʉ”, yi ti masia gʉa ĩja. “¿Riti gotiati mʉ?” yi seniĩare ma ĩja. “Dios tʉ wadirʉ ña mʉ”, yi tʉorʉ̃nʉa gʉa mʉre ĩja, yicʉ gʉa Jesure. ");
INSERT INTO myy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Gʉa ito yijare, ado bajiro cʉdiquĩ Jesús: —¿Riti adocãta yʉre tʉorʉ̃nʉati mʉa? ");
INSERT INTO myy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Batacõri, yʉre mʉa wagoroto ejacoajʉ. Riti gotia yʉ. Yʉre mʉa wagoroto ejacoajʉ ĩja. Ito bajibojarocati sĩgʉ̃ meje ña yʉ. Yʉ Jacʉ yʉ rãcati ñami. ");
INSERT INTO myy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iti jeyaro mʉare gotia yʉ, yʉre tʉorʉ̃nʉcõri, mʉa ya ʉsijʉ ʉsiriore mano mʉa ñatoni. Adi macãrʉcʉ̃rojʉ mʉa ñaja, jeyaro tõbʉjarã yirãji mʉa. Oca sẽoña mʉa, adi macãrʉcʉ̃ro gãnare ñeñaro yi rotigʉre rẽtocũcʉ yʉ, yiquĩ Jesús gʉa ĩ rãca riasotirãre. ");
INSERT INTO myy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ito bajiro ĩ yija bero macãrʉcʉ̃rojʉ ti mʉocõri, ado bajiro yiquĩ Jesús: —Cʉna mʉ tʉ yʉ tʉdi ejaroti ejacoajʉ ĩja. Yʉ ña mʉ Macʉ. Masa yʉre ĩna rʉ̃cʉbʉoroca yiya. Ito bajiroti yʉ cʉni mʉre ĩna rʉ̃cʉbʉoroca yigʉ yigʉja. ");
INSERT INTO myy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yʉ ña mʉ Macʉ. Masare yʉ roti masitoni yʉre cũyija mʉ. Yʉre mʉ ĩsiana ĩna catitĩñaroca yʉ yi masitoni yʉre cũyija mʉ. ");
INSERT INTO myy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ado bajiro bajia catitĩñare gaye: Mʉ sĩgʉ̃ti riojo oca ñasarise gotigʉre masicõri, ito yicõri yʉ Jesucristo mʉ cõarʉre tʉorʉ̃nʉcõri, catitĩñarã yirãji masa. Ito bajiro bajia catitĩñare gaye. ");
INSERT INTO myy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Adi macãrʉcʉ̃ro yʉ ñaja mʉre masa ĩna rʉ̃cʉbʉoroca yicʉ yʉ. Yʉre mʉ roti ñucacato bajiroti itire gajanoa yʉ. ");
INSERT INTO myy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Adi macãrʉcʉ̃ro iti ñaroto riojʉajʉ mʉ rãca rʉ̃cʉbʉogʉ ñacʉ yʉ. Cʉna, ito bajiroti adocãta mʉ tiro riojo masa yʉre ĩna rʉ̃cʉbʉoroca yiya. ");
INSERT INTO myy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Yʉ rãca riasotirã adi macãrʉcʉ̃ro gãna wato mʉ beseana ñama. Ĩnare besecõri, yʉre ĩsiyija mʉ. Mʉre ĩna masiroca yicʉ yʉ. Mʉ ñarã ñañi ĩna. Ĩnare yʉre ĩsiyija mʉ. Mʉ ocare cʉdisotirã ñama ĩna. ");
INSERT INTO myy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","No yʉre mʉ ĩsirise, “Dios ye wadire ña”, yi tʉo masiama ĩna. ");
INSERT INTO myy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mʉ ocare yʉre mʉ goticato bajiroti ĩnare goticʉ yʉ. Iti ocare tʉocõri, boca ãmicã ĩna. “Dios tʉ wadirʉ ñami ãni”, yi masiama ĩna, yʉre ĩja. “Dios ĩ cõarʉ ñami ãni”, yi yʉre tʉorʉ̃nʉama ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ĩnare yiari mʉre bʉsia yʉ. Adi macãrʉcʉ̃ro gãnare yiari meje mʉre bʉsia yʉ. Yʉre mʉ ĩsiana, mʉ ñarã ĩna ñajare, ĩnare yiari bʉsia yʉ. ");
INSERT INTO myy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yʉ ñarã jeyaro mʉ ñarãti ñama ĩna. Ito yicõri mʉ ñarã yʉ ñarãti ñama ĩna. Yʉ rãca riasotirã mʉ ñarã ñama. Ĩna queno yirise ticõri, yʉre rʉ̃cʉbʉorã yirãji masa. ");
INSERT INTO myy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Mʉ rãca ñagʉ̃ wacʉ ya yʉ. Ito bajiri adi macãrʉcʉ̃rore wagogʉ ya yʉ ĩja. Yʉ rãca riasotirãma adi macãrʉcʉ̃rojʉ tujarã yama. Cʉna, ñeñarise yiĩabicʉ ña mʉ. Ãna yʉre mʉ ĩsianare mʉ masirisena ĩnare tirʉ̃nʉma. Mani sĩgʉ̃re bajiro tʉoĩarã ña. Manire bajiroti ĩna cʉni sĩgʉ̃re bajiro ĩna tʉoĩatoni ĩnare tirʉ̃nʉña. ");
INSERT INTO myy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Adi macãrʉcʉ̃rojʉ yʉre mʉ ĩsiana rãca yʉ ñaroca mʉ masirisena queno ĩnare tirʉ̃nʉcʉ yʉ. Sĩgʉ̃ yʉre godagobe yirocʉ queno ĩnare tirʉ̃nʉcʉ yʉ. Ito bajibojarocati sĩgʉ̃ ñaquĩ yʉre godagocacʉ. Ĩ ñaquĩ jeame ʉ̃jʉrojʉ warocʉ. Mʉ oca iti gotiro bajiroti iti rẽtatoni yʉre godagoquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Adocãta mʉ tʉ wacʉ ya yʉ. Adi macãrʉcʉ̃rojʉ ñagʉ̃ maji adi oca ĩnare gotia yʉ. Yʉ wanʉro bajiroti ĩna cʉni wanʉ quena jeditoni iti oca ĩnare gotia yʉ. ");
INSERT INTO myy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʉ ocare ĩnare goticʉ yʉ. Adi macãrʉcʉ̃ro gãna bajiro meje tʉoĩa yʉ. Yʉ rãca riasotirã cʉni adi macãrʉcʉ̃ro gãna bajiro tʉoĩarã meje ñama ĩna. Ito bajiri adi macãrʉcʉ̃ro gãna ĩnare ti tudiama. ");
INSERT INTO myy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Adi macãrʉcʉ̃rojʉre ĩnare mʉre ãmigo rotibea yʉ. Ado bajirojʉa mʉre senia yʉ: “Ĩnare camotaya rʉ̃mʉ́ ʉsirioro ĩnare yibe yirocʉ”, ya yʉ mʉre. ");
INSERT INTO myy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Adi macãrʉcʉ̃ro gãna bajiro tʉoĩagʉ̃ meje ña yʉ. Ito bajiri yʉ rãca riasotirã cʉni adi macãrʉcʉ̃ro gãna bajiro tʉoĩarã meje ñama ĩna. ");
INSERT INTO myy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mʉ oca ña oca riojo ñasarise. Mʉ ñarã queno yirã riti ĩna ñatĩñatoni mʉ oca ñasarisere ĩna masiroca yiya. ");
INSERT INTO myy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Adi macãrʉcʉ̃ro gãna wato yʉre cõayija mʉ. Yʉ cʉni ito bajiroti adi macãrʉcʉ̃ro gãna wato yʉ rãca riasotirãre cõa yʉ. ");
INSERT INTO myy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ĩnare yiari, mʉre riti cʉdigʉ yigʉja yʉ. Ito yicõri mʉ yagʉ riti ñagʉ̃ yigʉja yʉ. Ito bajiro yʉ yija ticõri, mʉ oca riojo ñasarise cʉdicõri, mʉ ñarã riti ñarã yirãji ĩna cʉni, yiquĩ Jesús Diore bʉsigʉ. ");
INSERT INTO myy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Gaje Diore ado bajiro gotiquĩ Jesús: —Ĩnare riti yiari meje mʉre bʉsia yʉ. Ĩna riasorise tʉocõri, yʉre tʉorʉ̃nʉrã yirãji gãjerã. Ĩnare yiari cʉni mʉre bʉsia yʉ. ");
INSERT INTO myy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ĩna jeyaro sĩgʉ̃re bajiro ĩna ʉsi cʉtitoni mʉre bʉsia yʉ. Manire bajiroti ĩna ʉsi cʉtire ãmoa yʉ. Cʉna yʉre bajiroti ʉsi cʉtigʉ ña mʉ. Yʉ cʉni mʉre bajiro ʉsi cʉtia. Ito bajiro manire bajiro sĩgʉ̃ bajiro riti ĩna ʉsi cʉtire ãmoa yʉ. Ito bajiro ĩna bajija ticõri, “Riti Dios ĩ cõarʉ ñañi Jesús”, yirã yirãji adi macãrʉcʉ̃ro gãna. ");
INSERT INTO myy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yʉre masa ĩna rʉ̃cʉbʉoroca mʉ yiado bajiroti ĩnare masa rʉ̃cʉbʉoroca yicʉ yʉ cʉni. Sĩgʉ̃re bajiro ʉsi cʉtirã ĩna ñatoni ito bajiro ĩnare yicʉ yʉ. Mani cʉni ito bajiroti sĩgʉ̃re bajiro bajia mani. ");
INSERT INTO myy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yʉ bajiroti ʉsi cʉtirã ñama ĩna. Yʉ cʉni mʉ bajiroti ʉsi cʉtigʉ ña yʉ. Ito bajiri sĩgʉ̃ bajiro riti tʉoĩa jedirã yirãji ĩna. Ito bajiro ĩna bajija ticõri, “Dios ĩ cõarʉti ñañi Jesús”, yi masirã yirãji adi macãrʉcʉ̃ro gãna. “Ĩ Macʉre ĩ mairo bajiroti ĩnare cʉni maiami Dios”, yi masirã yirãji adi macãrʉcʉ̃ro gãna. ");
INSERT INTO myy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Cʉna, yʉ rãca riasotirã yʉre mʉ ĩsiana ñama ĩna. No yʉ ñarojʉ yʉ rãca ĩna ñare ãmoa yʉ. Ito bajicõri, masa ĩna yʉre rʉ̃cʉbʉoroca mʉ yire ti masirã yirãji ĩna. Ito yicõri, “Adi macãrʉcʉ̃ro iti ñaroto riojʉajʉ Jesure maiñi Dios”, ĩna yi masire ãmoa yʉ. ");
INSERT INTO myy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Cʉna ñeñarise macʉ ña mʉ. Adi macãrʉcʉ̃ro gãna mʉre ti masibeama ĩna. Yʉama mʉre ti masia. Ãna yʉ rãca riasotirã, “Dios ĩ cõarʉ ña mʉ”, yi masiama ĩna, yʉre. ");
INSERT INTO myy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉre ĩna ti masiroca yicʉ yʉ. Ito bajicõri, mʉre ĩna masitĩñaroca yigʉ yigʉja yʉ. Ito bajiro yigʉ yigʉja yʉ, yʉre mʉ mairo bajiro ĩna gãmeri maitoni. Ito yicõri ĩna rãca ñatĩñagʉ̃ yigʉja yʉ, yiquĩ Jesús Diore bʉsigʉ. ");
INSERT INTO myy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ito bajiro Jesús ĩ bʉsija bero Cedrón wame cʉtiri jaribʉ sidʉjajʉ wacʉ gʉa ĩ rãca. Ito wacõri ote wese wijacʉ gʉa, Jesús rãca. ");
INSERT INTO myy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Coji meje iti ote wesejʉ minijuasoticʉ gʉa. Ito bajiri Judas, Jesure oca menirocʉ cʉni tisotiquĩ iti wesere. ");
INSERT INTO myy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ito bajiri iti wesere masicõri, surarare, porecia masare cʉni ãmi ejaquĩ Judas. Paia ʉjarã, fariseo gaye tʉoĩarã cʉni ĩna cõana ñañi ĩna. Sarera jãirina bisu cʉticã ĩna. Sĩabusuoragari, ito yicõri mujura jãiri cʉni rʉcocã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","“Ado bajiro yʉre rẽtaro yiroja”, yigʉ ĩnare boca ãmigʉ̃ waquĩ Jesús. Ĩnare boca ãmicõri, ado bajiro ĩnare seniĩaquĩ ĩ: —¿Ñimʉre ãmati mʉa? yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ito ĩ yijare: —Jesús Nazaret gagʉre ãma gʉa, yicã ĩna. Ĩna ito yija tʉocõri: —Ĩti ña yʉ, yi cʉdiquĩ Jesús. Ĩna rãca ñaquĩ Judas, Jesure oca menirʉ cʉni. ");
INSERT INTO myy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Ĩti ña yʉ”, Jesús ĩ yirocati jʉdojʉana juja quedicoacã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ito yi mʉcana tʉdi ĩnare seniĩaquĩ Jesús: —¿Ñimʉre ãmasati mʉa? yiquĩ ĩ ĩnare. Ito ĩ yija tʉocõri: —Jesús Nazaret gagʉre ãma gʉa, yicã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ĩna ito yija tʉocõri: —“Ĩti ña yʉ”, yicãmʉ yʉ, mʉare. Yʉre riti mʉa ãmajama, yʉ rãca gãnama wacoajaro, yiquĩ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ito bajiro yiquĩ Jesús, iti rʉmʉjʉ ĩ gotigoado bajiro iti rẽtatoni. Iti rʉmʉjʉ ado bajiro gotiquĩ ĩ: “Yʉ Jacʉ yʉre ĩ ĩsicãna sĩgʉ̃jʉa yʉre godabiticã”, yiquĩ Jesús iti rʉmʉjʉ. ");
INSERT INTO myy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ito bajiro Jesure ĩna ñia ãmoja ticõri, ĩ ya sarera jãi ãmiquĩ Simón Pedro. Iti jãina paia ʉjʉre moa ĩsiri masʉ, Malco wame cʉtigʉre ĩ ya gãmoro riojocadʉjare jataquĩ Pedro. ");
INSERT INTO myy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ito ĩ yijare: —Mʉ ya sarera jãire seoya mʉcana. Yʉ tõbʉjaroti Dios ĩ ãmoja, camotabicʉja yʉ. “Itire camotagʉ yiguĩji”, ¿yire masiati mʉ? yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ito yija surara ĩna ʉjʉ rãca, judio masa porecia cʉni Jesure ñiacã ĩna. Ĩre ñiacõri, ĩ ya ãmori siacã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ito yicõri Anás ya wijʉ ãmicoacã ĩna, ĩre ĩja. Caifás mañicʉ ñayijʉ Anás. Iti rodori paia ʉjʉ ñayijʉ Caifás. ");
INSERT INTO myy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ĩ Caifás ñayijʉ, “Mani ñarocõti godaja quenabetoja. Manire yiari sĩgʉ̃ ĩ goda ĩsija quena”, yi ĩ ñarã judio masare gotigorʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro, gãji gʉa rãca gagʉ, Jesure ĩna ãmi waja sʉya wacã ĩna. Simón Pedro rãca wacacʉ paia ʉjʉre baba cʉtigʉ ñasotiyijʉ ĩ. Ito bajiri josari mejeti paia ʉjʉ ya wi sabiara cʉní rẽta sãjacoayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedroama sabiara cʉní jʉdojʉa sãjabicʉti tujacoayijʉ. Ito bajiri gãji Jesús rãca riasotirʉ paia ʉjʉ baba sabiara cʉní coderi maso rãca bʉsigʉ wayijʉ. Ito yicõri Pedrore jisõyijʉ ĩ baba. ");
INSERT INTO myy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Iti cʉní coderi maso ado bajiro seniĩayijo Pedrore: —¿Jesús rãca riasotigorʉ meje ñati mʉ cʉni? yiyijo iso Pedrore. Iso ito yijare: —Meje ña yʉ, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iti ʉsajare moa ĩsiri masa, porecia masa cʉni jea riocõri, suma ñayijarã ĩna. Pedro cʉni ĩna rãca suma ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jesure ĩna ãmi ejaja ticõri, paia ʉjʉ Anás wame cʉtigʉ Jesure ado bajiro seniĩasʉoyijʉ: —¿Noa ñati mʉ rãca riasotiana? Ito yicõri, ¿ñe gaye ĩnare riasocati mʉ? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Jesús: —Masa jeyaro tiro riojo bʉsisoticʉ yʉ. Dios ya wijʉ, mani masa judio masa minijuara wijʉ cʉni masare riasocʉ yʉ. Ito bajiri yʉ goti rudire ma. ");
INSERT INTO myy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿No yija yʉre itire seniĩati mʉ? Yʉre tʉogoanare seniĩate mʉ. Yʉ bʉsigore gaye mʉre gotirã yirãji ĩna. Yʉ bʉsigore masirãji ĩna, yiquĩ Jesús paia ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús ito bajiro ĩ yija tʉocõri, sĩgʉ̃ porecia masʉ, Jesús ya riojʉ jayijʉ. —¿Paia ʉjʉre, no yija ito bajiro cʉdiati mʉ? yiyijʉ ĩ Jesure. ");
INSERT INTO myy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ito ĩ yija cʉdiyijʉ Jesús: —Riojo meje yʉ gotija, “Ado bajiro rʉo gotia mʉ”, yiya yʉre. Yʉ gotirise riojo gotia yʉ. Ito yibojarocati, ¿no yija yʉre jati mʉ? yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ito ĩ yija bero paia ʉjʉ Caifás wame cʉtigʉ tʉ Jesure siarʉreti cõayijʉ Anás maji. ");
INSERT INTO myy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ito baji ñaroca jea suma ñayijʉ Pedro maji. Ĩ rãca jea suma ñarã ado bajiro ĩre seniĩayijarã: —¿Ĩ rãca riasotigorʉ meje ñati mʉ cʉni? yiyijarã ĩna Pedrore. Ĩna ito yijare: —Meje, ĩ rãca riasotigorʉ meje ña yʉ, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ito ĩ yija, sĩgʉ̃ paia ʉjʉ moa ĩsiri masʉ ado bajiro seniĩayijʉ Pedrore: —Ote wese ĩ rãca mʉ ñaroca, ¿tibiticati yʉ mʉre? yiyijʉ ĩ Pedrore. Pedro gãmoro ĩ jatarʉ oca bʉsigʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ito bajiro ĩ seniĩaja tʉocõri: “Jesure masibea yʉ”, yiyijʉ Pedro mʉcana. Ito bajiro ĩ yirocati, cara yujicoayijʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ito yija bero Caifás ya wina romano masa ʉjʉ ya wijʉ Jesure ãmi wayijarã ĩre ñiana. Ito ĩna yiroca riti busu mʉja wadicoayijʉ ĩja. Ĩna judio masa romano masa ʉjʉ ya wijʉ sãjabisijarã ĩna. “Gaje masa ya wi mani sãjaja pascua basa bare bamenaji mani”, yi tʉoĩarã sãjabisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ito bajiri Pilato ĩmasiti ĩnare bʉsirocʉ budi wayijʉ: —¿Ñe seti cʉtiati ãni, mʉa tija? yiyijʉ Pilato judio masare. ");
INSERT INTO myy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ito ĩ yijare cʉdiyijarã ĩna: —Ĩ seti macʉ ñaja, mʉ tʉ ĩre ãmi ejabitiboana gʉa, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ĩna ito yijare: —Ĩre ãmi wasa mʉa. Mʉa masa bʉcʉrã rotirena, “Ado bajiro seti cʉtia mʉ”, yiba mʉa ĩre, yiyijʉ Pilato judio masare. Ito ĩ yija tʉocõri, ado bajiro cʉdiyijarã ĩna: —Ĩre sĩa ãmoboja gʉa. Ito bajibojarocati gʉa judio masa bʉcʉrã rotirena ĩre sĩa masibea gʉa, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","“Yucʉtẽojʉ yʉre jaju sĩarã yirãji masa”, Jesús ĩ yicãdo bajiroti rẽtayijʉ ito bajiro ĩna yija. ");
INSERT INTO myy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mʉcana ĩ ya wi tʉdi sãjacõri, ado bajiro Jesure seniĩayijʉ Pilato: —¿Judio masa ʉjʉ ñati mʉ? yiyijʉ Pilato Jesure. ");
INSERT INTO myy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ito ĩ yijare, ado bajiro cʉdiyijʉ Jesús: —¿Mʉmasi tʉoĩacõri, ito bajiro yi seniĩati mʉ? ¿Gãjerã mʉre ĩna gotijare ito bajiro yʉre seniĩati mʉ? yiyijʉ Jesús Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ito ĩ yijare: —¿Judio masʉ ñati yʉ, mʉ tija? Mʉ ñarãti, paia ʉjarã cʉni yʉ tʉ ãmi ejama ĩna mʉre. ¿No bajiro yicati mʉ? yiyijʉ Pilato Jesure. ");
INSERT INTO myy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ito ĩ yija cʉdiyijʉ Jesús: —Adi macãrʉcʉ̃ro ʉjʉ meje ña yʉ. Adi macãrʉcʉ̃ro ʉjʉ yʉ ñaja yʉre sʉyari masa gãmeri jaboana judio masa yʉre ñiame yirona. Adi macãrʉcʉ̃ro ʉjʉ meje ña yʉ. Adi macãrʉcʉ̃rojʉ meje ña yʉ rotiroto, yiyijʉ Jesús Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ito ĩ yijare: —¿Ito yicõri, ʉjʉ ñati mʉ? yiyijʉ Pilato. Ito ĩ yija cʉdiyijʉ Jesús: —Mʉ yiro bajiroti ʉjʉ ña yʉ cʉni. Adi macãrʉcʉ̃rojʉ wadicõri, rujeacʉ yʉ, riojo oca ñasarise gotirocʉ. Riojo oca ñasarise cʉdirã ĩna ñama yʉre tʉorʉ̃nʉrã, yiyijʉ Jesús Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ito ĩ yija: —¿Ñe ñati oca riojo ñasarise? yiyijʉ Pilato Jesure. Ito bajiro Jesure seniĩacõri, ĩ ya wi budi wacõri, judio masare bʉsigʉ wayijʉ Pilato mʉcana: —Yʉ tija ñe seti macʉ ñami ãni. ");
INSERT INTO myy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Co rodo rʉyabeto pascua basa mʉa menija sĩgʉ̃ tubiarʉre bucõasotia yʉ mʉare yiari. ¿Mʉa judio masa ʉjʉre yʉ bucõare ãmoati mʉa? yiyijʉ Pilato judio masare. ");
INSERT INTO myy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ito ĩ yijare, ado bajiro awasã cʉdiyijarã ĩna: —Ĩre meje bucõaña mʉ. Barrabásjʉare bucõaña, yiyijarã ĩna Pilatore. Riniri masʉ ñayijʉ Barrabás. ");
INSERT INTO myy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ĩna ito yija tʉocõri, Jesure baje rotiyijʉ Pilato ĩja. ");
INSERT INTO myy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jesús ya rijoga joe jota bedo seara bedo jeoyijarã surara. Ito yicõri ʉjarã ĩna sãñaro bajiro sũaro sãyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ito yija bero ĩ tʉ bʉsa eja rʉ̃gʉ̃cõri, ado bajiro yiyijarã ĩna: —Judio masa ʉjʉ catijaro, yi aja tudiyijarã ĩna Jesure. Ito yicõri riojʉ ĩre jayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mʉcana budi wacõri, judio masare gotigʉ ejayijʉ Pilato: —Tiya mʉa. Ĩ seti manijare ĩre bucõagʉ̃ ya yʉ, yiyijʉ Pilato judio masare. ");
INSERT INTO myy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ito ĩ yija, jota bedo jesarʉ, sũaro sãñarʉ budiyijʉ Jesús. Ito yija ado bajiro yiyijʉ Pilato masare: —Tiya, ãni ñami ʉ̃mʉgʉ̃, yiyijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jesús ĩ budija ticõri, ado bajiro awasãsʉoyijarã paia ʉjarã, porecia cʉni: —Yucʉtẽojʉ ĩre jaju sĩaña, ĩre sĩaña, yi awasãyijarã ĩna. Ĩna ito yija tʉocõri: —Mʉamasi ĩre ãmi wacõri, yucʉtẽojʉ jaju sĩatẽña mʉa. Yʉ tijama, ñe seti ma ĩre, yiyijʉ Pilato judio masare. ");
INSERT INTO myy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ito ĩ yijare ado bajiro cʉdiyijarã judio masa: —Gʉa bʉcʉrã masa ĩna rotirena ĩ godaja quena. “Dios Macʉ ña yʉ”, ĩ yire waja ĩ godaja quena, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ito bajiro ĩna yija tʉocõri, bʉto bʉsa güiyijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tʉdi wi toti Jesure ãmi sãcõri, ado bajiro seniĩayijʉ Pilato ĩre: —¿Nojʉ gagʉ ñati mʉ? yiyijʉ Pilato ĩre. Ito bajiro ĩ yibojarocati ĩre cʉdibisijʉ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mʉcana tʉdi ĩre seniĩayijʉ Pilato: —¿Yʉre cʉdibeati mʉ? Gãjerã mʉre yucʉtẽojʉ yʉ jaju roti ãmoja jaju roti masia yʉ. Mʉre yʉ bucõa ãmoja, bucõa masia yʉ. ¿Itire masibeati mʉ? yiyijʉ Pilato Jesure. ");
INSERT INTO myy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ito ĩ yijare: —Mʉ rotiroca Dios ĩ mʉre yibeja, yʉre roti masibitiboa mʉ. Mʉ rẽto bʉsaro seti cʉtigʉ ñami yʉre ĩna ñiatoni gotirʉ, yiyijʉ Jesús Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ito ĩ yija tʉocõri, “¿No bajiro yicõri Jesure bucõarʉjati yʉ?” yi tʉoĩayijʉ Pilato. Ito bajiro ĩ tʉoĩabojarocati judio masa ado bajiro awasãyijarã: —Ĩre mʉ bucõaja mʉa romano masa ʉjʉ ñasagʉ baba meje ñagʉ̃ yigʉja mʉ. No, “Ʉjʉ ñagʉ̃ yigʉja yʉ”, yigʉ, ĩ ñami masa ʉjʉ wajacʉ, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ĩna ito yija tʉocõri, Jesure ãmi rotiyijʉ Pilato ĩja. Ito yicõri ʉjarã ĩna rujirijʉ rujiyijʉ Pilato ĩja. Itijʉ Gabata wame cʉtiyijʉ hebreo ocana. “Gʉ̃tana bʉorajʉ”, yireoni ñayijʉ itijʉ. ");
INSERT INTO myy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascua basa riojʉa ʉ̃mʉa gʉdareco ñayijʉ iti rʉmʉ. Ito yija Pilato ado bajiro yiyijʉ judio masare: —Ãni ñami mʉa ʉjʉ, yiyijʉ Pilato. ");
INSERT INTO myy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ito bajiro ĩ yibojarocati bʉto awasãyijarã ĩna: —Sĩacõrʉja ĩre. Sĩacõrʉja ĩre. Yucʉtẽojʉ ĩre jaju sĩaña, yiyijarã ĩna Pilatore. Ĩna ito yijare: —¿Mʉa ʉjʉre jaju sĩagʉ̃ yigʉjada yʉ? yiyijʉ Pilato ĩnare. Ito ĩ yijare, ado bajiro cʉdiyijarã paia ʉjarã: —Romano masa ʉjʉ riti ñami gʉa ʉjʉ. Ñimʉjʉa gãji mami, yiyijarã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ito bajiro ĩna yija tʉocõri, yucʉtẽojʉ Jesure ĩna jaju sĩatoni ĩnare ĩsiyijʉ Pilato. Ito bajiri Jesure ãmicoayijarã ĩna ĩja. ");
INSERT INTO myy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ĩre ĩna ãmi waja, sʉya wacʉ gʉa cʉni. Ĩre ãmi wacõri, yucʉtẽo ĩre gaja roticã ĩna. Hebreo ocana Gólgota wame cʉtiri burojʉ ĩre ãmi wacã ĩna. “Rijoga gõari ñaro”, yireoni ñacʉ itijʉ. ");
INSERT INTO myy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Itojʉ ãmi ejacõri, Jesure yucʉtẽojʉ jajucã ĩna. Gãjerã jʉ̃arã jʉa dʉja gãna yucʉtẽojʉ yosacã ĩna. Ĩna gʉdareco ñaquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jesús ĩ wãñaritẽojʉ ĩ ya rijoga weca wame wõ rotiquĩ Pilato. Ado bajiro goticʉ iti: “Jesús Nazaret gagʉ, judio masa ʉjʉ”, yi wãñacʉ iti. ");
INSERT INTO myy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Judio masa jãjarã ticã iti ucarere. Jesure yucʉtẽojʉ ĩna jajucati cʉto tʉti ñacʉ. Ĩ ya rijoga weca wame wãñarise griego oca, hebreo oca, latín oca cʉni ñacʉ iti. ");
INSERT INTO myy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ito bajiri judio masa paia ʉjarã ado bajiro yicã Pilatore: —“Judio masa ʉjʉ ñami”, yi ucabesa. “Judio masa ʉjʉ ña yʉ”, yibojarʉ, yi ucaja quena, yicã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ito bajiro ĩna yibojarocati ado bajiro cʉdiquĩ Pilato: —Yʉ ucare ito bajiroti tujaro ya, yiquĩ Pilato ĩnare. ");
INSERT INTO myy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Surara yucʉtẽojʉ Jesure jaju tĩorã ĩ ya yutabujurire ãmicã ĩna. Itire ãmicõri, jʉariarori batocã ĩna. Ito yicõri ĩnacõti gãji coro, gãji coro ãmicã ĩna. Jesús ĩ sãñado joegadoama jioya mano ñacʉ. Riojoti sua mʉja, gajanoado ñacʉ. ");
INSERT INTO myy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ito bajiri ado bajiro yicã surara: —Itore ñigãmena mani. Ñimʉjʉa itore ĩ bʉjaja tiana yirona, gʉ̃tana rea ajecã ĩna. Ito bajiro ĩna yija Dios oca tuti iti gotiado bajiroti rẽtacʉ. Ado bajiro gotia ĩ oca: “Yʉ ya yutabujurire batocã ĩna. Ñimʉjʉa adore ĩ bʉjaja tiana yirona, gʉ̃ta ajerã yirãji”, yi gotia Dios oca. Ito bajiroti yicã surara. ");
INSERT INTO myy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús ĩ yucʉtẽojʉ wãñaro roca adocõ jãjarã ñacʉ gʉa. Ĩ jaco, Cleofas manojo María, María Magdalena, ito yicõri yʉ cʉni ñacʉ ĩna rãca. ");
INSERT INTO myy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús ĩ jacore, ito yicõri yʉ ĩ maigʉ̃re ticõri, ado bajiro yiquĩ Jesús ĩ jacore: —Cana ĩ ñagʉ̃ yiguĩji mʉ macʉ, yiquĩ Jesús ĩ jacore. ");
INSERT INTO myy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ito yicõri yʉjʉare ado bajiro yiquĩ: —Iso ñagõ yigõji mʉ jaco, yiquĩ Jesús yʉre. Ito ĩ yija bero isore boca ãmicõri, yʉ ya wijʉ isore codecʉ yʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ito ĩ yija bero, “Dios ĩ ãmoro bajiroti yʉre rẽta jedicoajʉ ĩja”, yi tʉoĩaquĩ Jesús. Dios oca tuti iti gotiro bajiroti iti rẽtatoni: —Idi ãmoa yʉ, yiquĩ Jesús. ");
INSERT INTO myy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ito ñacʉ ʉyé ide jiaradʉ. Ide udi ãmirisena itire udi ãmicã ĩna surara. Ito yicõri hisopo wame cʉtiricʉ rʉjʉ gaja siacã ĩna itire. Ito yicõri Jesús ya rise tʉ ñutucã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ʉyé ide jiare weroĩacõri, ado bajiro yiquĩ Jesús: —Dios ĩ goticãdo bajiroti rẽta jedicoajʉ ĩja. Itocõ ña, yiquĩ Jesús. Ito yija ĩ ya rijoga queo yocõri, ʉsi jedicoaquĩ Jesús ĩja. ");
INSERT INTO myy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iti rʉmʉ pascua basa riojʉa ñacʉ. Busuri gʉa judio masa ya tujacãra rʉmʉ ñaro yicʉ. Ito bajiri yucʉtẽojʉ godana ya rujʉ wãñare ãmobiticã ĩna tujacãri rʉmʉ ñajare. Tujacãra rʉmʉ guijori rʉmʉ ñacʉ gʉa judio masare. Ito bajiri Pilatore ado bajiro senicã ĩna: “Yucʉtẽojʉ wãñarãre sagaro gõare jajea rotiya. Ito yicõri ĩna ya rujʉri rujio rotiya”, yicã ĩna Pilatore. ");
INSERT INTO myy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilato ĩ rotija tʉocõri, ĩ ya surara wacõri, yucʉtẽojʉ wãñarãre ĩna ya sagaro gõarire jajeacã ĩna. Jesús tʉ jʉ̃arã yucʉtẽojʉ wãñarãre ĩna ya gõarire jajeacã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesús tʉjʉ eja rʉ̃gʉ̃cõri, “Ʉsi jedicoañi ãni”, yi ti masicã ĩna. Ito bajiri ĩ ya sagaro gõare jajeabiticã ĩna. ");
INSERT INTO myy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ito bajibojarocati Jesús ya warubʉ sare cudaquĩ sĩgʉ̃ surara masʉ. Ito ĩ yirocati rí ide wʉsarise budicʉ. ");
INSERT INTO myy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yʉ itire gotigʉ, itire tigorʉ ña yʉ. “Riti gotia yʉ itire”, ya yʉ. Mʉa cʉni itire tʉorʉ̃nʉtoni, riojo itire gotia yʉ. ");
INSERT INTO myy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iti jeyaro rẽtacʉ Dios oca tuti iti goticato bajiroti. Tʉote. Ado bajiro gotia Dios oca: “Ĩre co gõa jajeamena yirãji ĩna”, yi gotia Dios oca. ");
INSERT INTO myy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Gajejʉ Dios oca iti gotija ado bajiro gotia: “Sare cuda ecorʉre tirã yirãji masa”, yi gotia Dios oca. ");
INSERT INTO myy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ito bajija bero José Arimatea gagʉ Jesús ya rujʉre ãmirocʉ Pilatore seniyijʉ ĩ. Jesús ocare tʉo sʉyagorʉ ñayijʉ ĩ, ito bajibojagʉti gãjerãre goti batobisijʉ ĩ, judio masare güigʉ. “Ãmiña”, Pilato ĩ yija tʉocõri, Jesús ya rujʉre rujiogʉ wayijʉ José. ");
INSERT INTO myy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo ñamijʉ Jesús rãca bʉsigʉ ejagorʉ cʉni ejayijʉ. Treinta kilos rʉ̃cʉrisecõ queno sʉti quenarise ãmi ejayijʉ ĩ. Mirra wame cʉtirise, áloes wame cʉtirise wʉore ñayijʉ iti sʉtirise. ");
INSERT INTO myy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ito bajiri José, Nicodemo rãca Jesús ya rujʉ ãmicõri saya botirona sʉtirise tucõri, ĩre gũmayijarã ĩna. Judio masa, masa yujerã ĩna yisotirise ñayijʉ iti. ");
INSERT INTO myy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesure yucʉtẽojʉ ĩna jaju sĩarajʉ ote wese tʉ ñayijʉ. Iti wesejʉ masari cuma mama goje ñayijʉ. Gãjerãre yujeĩaña mani goje ñayijʉ iti goje. ");
INSERT INTO myy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jabeto rʉyayijʉ tujacãra rʉmʉ iti busuroto. Ito bajiri iti gojejʉ Jesús ya rujʉre sãyijarã ĩna, sõjʉ meje iti goje ñajare. ");
INSERT INTO myy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gʉa masa ya moasʉora rʉmʉ busuri jĩjʉ rãitĩa bʉsaroca wayijo María Magdalena. Jesús ya masari cuma tʉ ejacõri, iso tija gʉ̃ta biaraga mañijʉ. ");
INSERT INTO myy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ito iti bajija ticõri, ũmaquedi wacõri, gʉa tʉ ejacõ iso. Simón Pedro, ito yicõri yʉ Juan Jesús ĩ bʉto maicana ñacʉ gʉa. Gʉa tʉ ejacõri, ado bajiro yicõ iso: —Mani Ʉjʉ ya rujʉre ãmicoañi ĩna. “Itojʉ ĩ ya rujʉre cũana ĩna”, yi masibea yʉ, yicõ iso gʉare. ");
INSERT INTO myy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Iso ito yija tʉocõri, yʉ Pedro rãca masari cumajʉ tirã wacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Gʉa jʉ̃arã cocati ũmaquedi wacʉ. Pedro rẽto bʉsaro ũmaquedicʉ yʉ. Ito bajiri yʉjʉa cajero masari cuma ejasʉocʉ. ");
INSERT INTO myy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Muqueacõri, ito tisõcʉ yʉ. Ĩre ĩna gũmagore riti ticʉ yʉ. Itojʉ sãjabiticʉ yʉ maji. ");
INSERT INTO myy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yʉ bero ejaquĩ Simón Pedro. Ĩama masari cumajʉ sãjacoaquĩ ĩja. Ĩ cʉni Jesure ĩna gũmagore riti tiquĩ. ");
INSERT INTO myy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesús ya rijoga gũmado gajerojʉ iti jesaja tiquĩ. Dʉreare rujajucu gajerojʉ iti jesaja tiquĩ ĩ. ");
INSERT INTO myy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ito yija yʉ cajero ejacacʉ cʉni sãjacoacʉ. Iti rẽtare ticõri, “Tʉdi caticoañi Jesús”, yi tʉoĩacʉ yʉ ĩja. ");
INSERT INTO myy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Iti riojʉa, “Godabojagʉti tʉdi catigʉ yiguĩji Jesús”, Dios oca iti yire gaye tʉo masibiticʉ gʉa maji. ");
INSERT INTO myy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ito yija bero gʉa ya wijʉ tʉdi wacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalenama masari cuma tʉ oti tujacõ. Otigoti masari cumajʉ tisõyijo iso. ");
INSERT INTO myy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ito iso tisõja jʉ̃arã ángel mesa botirise sãñarã rujiyijarã. Sĩgʉ̃ Jesús ya rijoga ñagoadojʉa rujiyijʉ. Gãji ĩ ya gʉbori ñagoadojʉa rujiyijʉ. ");
INSERT INTO myy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ito yija ado bajiro seniĩayijarã ĩna María Magdalenare: —¿No yija otiati mʉ? yiyijarã ángel mesa isore. Ĩna ito yija: —Yʉ Ʉjʉ ya rujʉre ãmicoañi ĩna. “Itojʉ ĩ ya rujʉre cũana ĩna”, yi masibea yʉ, yiyijo iso ángel mesare. ");
INSERT INTO myy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ito bajiro yigoti, Jesure jʉda ti bʉjayijo iso. Ito bajibojarocati, “Jesuti ñami ãni”, yi masibisijo iso. ");
INSERT INTO myy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ito yija ado bajiro seniĩayijʉ ĩjʉa isore: —¿No yija otiati romio mʉ? ¿Ñimʉre ãmati mʉ? yiyijʉ Jesús isore. “Adi wese coderi masʉ ñaguĩji”, yire masiyijo iso. Ito bajiri ado bajiro ĩre yiyijo iso: —Ĩ ya rujʉre mʉ cũja, “Ito cũmʉ yʉ”, yiya yʉre. Ãmigõ waroco ya yʉ, yiyijo ĩre. ");
INSERT INTO myy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iso ito bajiro yija tʉocõri, ado bajiro yiyijʉ Jesús isore: —María, yiyijʉ Jesús isore. Ito ĩ yija tʉocõri, ado bajiro yiyijo iso hebreo ocana: —Rabuni, yiyijo iso. “Yʉre riasogʉ”, yireoni ñayijʉ iti. ");
INSERT INTO myy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ito yija ado bajiro cʉdiyijʉ Jesús: —Yʉre moaĩabesa maji. Yʉ Jacʉ tʉ mʉjabea yʉ maji. Wasa yʉ ñarãre ado bajiro gotitẽña: “Dios sĩgʉ̃ti ñami mani Jacʉ. Ito yicõri ĩ sĩgʉ̃ti ñami mani Ʉjʉ. Ĩ ñarojʉ wacʉ wagʉ ya yʉ”, yi gotitẽña, yimi Jesús yʉre, yi rotiyijʉ Jesús María Magdalenare. ");
INSERT INTO myy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ito yija gʉare gotigo ejacõ iso. “Mani Ʉjʉre tibʉ yʉ”, yicõ iso. Ito yicõri Jesús ĩ gotiado bajiro gʉare goticõ iso. ");
INSERT INTO myy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Gʉa masa ya moasʉora rʉmʉ ñacʉ iti rʉmʉ. Iti ñami gʉa Jesús rãca riasotigoana wijʉ minijua ñacʉ. Gʉa ñarã judio masare güirã soje biacõri, ñacʉ gʉa. Ñajasaroti gʉa wato goa rʉ̃gʉ̃quĩ Jesús. —Ñati mʉa, ñe oca mano queno ñaña mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ito ĩ yija bero ĩ ya ãmori, ito yicõri ĩ ya warubʉ ĩoquĩ gʉare. Gʉa ĩ rãca riasotigoana gʉa Ʉjʉre ticõri, bʉto wanʉcʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mʉcana tʉdi ado bajiro gotiquĩ Jesús gʉare: —Ñe oca manoti queno ñaña mʉa. Yʉ Jacʉ yʉre ĩ cõado bajiroti yʉ cʉni mʉare cõa yʉ ĩja, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ito yija gʉare juti jeocõri, ado bajiro yiquĩ ĩ: —Mʉa ya ʉsijʉ Espíritu Santo ĩ quedi sãjaroca ya yʉ. ");
INSERT INTO myy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ĩre boca ãmicõri, gãjerã ĩna ñeñaro yirise mʉa ãcabojaja, ĩnare seti mano yiroja. Ĩna ñeñaro yirise mʉa ãcabojabeja, seti cʉtirãti ñarã yirãji ĩnaõna, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ito bajiro gʉare Jesús ĩ goaĩoroca Tomás gʉa rãca gagʉ maniquĩ. Ĩ ñaquĩ “Sʉ̃rʉ̃arʉ”, gʉa yicacʉ. ");
INSERT INTO myy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomásre ti bʉjacõri: —Mani Ʉjʉre tibʉ gʉa, yibojacʉ gʉa ĩre. Ito bajiro gʉa yibojarocati Tomás ado bajiro yiquĩ: —Ĩ ya ãmo ĩna ja cudarajʉ yʉ tibeja, ito yicõri ĩre ĩna ja cudarajʉ yʉ ya ãmo wãsoana yʉ ñusõĩabeja, ito yicõri ĩ ya warubʉ ĩre ĩna sare cudadojʉ yʉ ya ãmona yʉ moaĩabeja, “Ĩti ñami”, yi masibicʉja yʉ, yiquĩ Tomás gʉare. ");
INSERT INTO myy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ʉdia ãmojeno rʉmʉri bero mʉcana tʉdi minijuacʉ gʉa. Iti rʉmʉ gʉa minijuacati rʉmʉ Tomás cʉni ñaquĩ ĩja. Soje biado ñabojarocati gʉa wato goa rʉ̃gʉ̃quĩ Jesús. —Ñati mʉa, ñe oca mano queno ñaña mʉa, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ito yicõri Tomásre ado bajiro yiquĩ ĩ: —Yʉ ya ãmore ticõri, mʉ ya ãmo wãsoana yʉre ñusõĩaña. Mʉ ya ãmona yʉ ya warubʉ susuro yʉre moaĩaña. “Ĩ meje ñaguĩji”, yibeja ĩja. “Ĩti ñami”, yi masiña mʉ ĩja, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ito ĩ yijare: —Yʉ Ʉjʉ, Dioti ña mʉ, yiquĩ Tomás Jesure. ");
INSERT INTO myy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ito ĩ yijare Jesús cʉdiquĩ: —Tomás yʉre ticõri, yʉre tʉorʉ̃nʉa mʉ. Gãjerãma yʉre tibitibojarãti yʉre ĩna tʉorʉ̃nʉja, queno wanʉ quenarã yirãji ĩna, yiquĩ Jesús Tomásre. ");
INSERT INTO myy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Gaje jaje tiyamani ĩoquĩ Jesús gʉa ĩ rãca riasotirã tiro riojo. Iti ñarocõti ña jedibea adi papera tutijʉ. ");
INSERT INTO myy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Adi yʉ ucarise, “Jesuti ñañi Cristo, ito yicõri Dios Macʉ ñañi”, yi mʉa tʉorʉ̃nʉtoni uca yʉ. Ĩre tʉorʉ̃nʉcõri, catitĩñare mʉa bʉjatoni itire uca yʉ. ");
INSERT INTO myy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ito bajija bero mʉcana tʉdi goaĩoquĩ Jesús, gʉare ĩ rãca riasotigoanare. Tiberias wame cʉtirita tʉnimajʉ gʉare goaĩoquĩ Jesús. Ado bajiro bajicʉ ĩ goaĩoja. ");
INSERT INTO myy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Adocõ jãjarã ñacʉ gʉa minijuacana, Simón Pedro, Tomás “Sʉ̃rʉ̃arʉ”, gʉa yigʉ, Natanael Galilea sita Caná wame cʉtiri cʉto gagʉ, gʉa Zebedeo rĩa, ito yicõri gãjerã jʉ̃arã Jesús rãca riasotigoana ñacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Gʉa ito baji ñaroca ado bajiro yiquĩ Simón Pedro: —Wai jogʉ wacʉ ya yʉ, yiquĩ Pedro. Ito ĩ yijare: —Gʉa cʉni mʉ rãca wajʉ, yicʉ gʉa. Ito yicõri wacʉ ĩja. Cumajʉ sãjacõri, ñamiasaro wai jobojacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Iti busu mʉja wadiroca itajura tʉnima gʉare goaĩoquĩ Jesús. Ito bajibojarocati, “Ĩti ñaguĩji”, yi masibiticʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ado bajiro gʉare yi ruyuquĩ ĩ: —¿Wai sĩabeati mʉa? yiquĩ Jesús gʉare. Ito ĩ yijare: —Sĩabea, joboja gʉa, yicʉ gʉa ĩre. ");
INSERT INTO myy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Gʉa ito yijare: —Cuma riojocadʉjare yorigʉ cõa roaya mʉa. Ito bajiro mʉa yija wai sĩarã yirãji mʉa, yiquĩ Jesús gʉare. Ĩ roticato bajiroti yicʉ gʉa. Wai jãjarã ĩna ñajare, yorigʉre mosã masibiticʉ gʉa, wai jãjarã ĩna ñajare. ");
INSERT INTO myy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ito baji ñaroca, yʉ Jesús ĩ maigʉ̃ ado bajiro yicʉ yʉ Pedrore: —Mani Ʉjʉti ñami ĩ, yicʉ yʉ Pedrore. “Mani Ʉjʉ ñami”, yʉ yija tʉocõri, wasoro yosagʉ ñari joegado sãñaquĩ ĩ. Ito yicõri itajurajʉ quedi roacoaquĩ ĩ. Ito yicõri Jesús tʉjʉ bati waquĩ. ");
INSERT INTO myy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Cien metrocõ tʉnima sõjʉa jayacʉ gʉa. Ito warãti jajʉ tʉnima ejacʉ gʉa. Wai yorigʉ rãca weja jãjã ejacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cuma majacõri, jeame weca wai jʉ̃oana ti ejacʉ gʉa. Ito yicõri naju cʉni iti ñaja ti ejacʉ gʉa. ");
INSERT INTO myy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Gʉa ejaja ticõri, ado bajiro yiquĩ Jesús, gʉare: —Wai jane mʉa sĩana ʉdiarãcõ ãmi waya, yiquĩ Jesús gʉare. ");
INSERT INTO myy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ito ĩ yija tʉocõri, cumajʉ mʉja sãjaquĩ Simón Pedro, ito yicõri wai cʉrã yorigʉjʉ ñarã jajʉjʉ waire weja mocũquĩ ĩ. Ciento cincuenta y tres ñarã ñacã wai jeyaro. Jãjarã ĩna ñabojarocati cudubiticʉ yorigʉ. ");
INSERT INTO myy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ito yija Jesús ado bajiro yiquĩ gʉare: —Ba yujirã waya maji, yiquĩ Jesús gʉare. “¿Ñimʉ ñati mʉ?” yi seniĩabiticʉ gʉa, “Mani Ʉjʉti ñami”, yi masicõri. ");
INSERT INTO myy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ito yicõri gʉa tʉjʉ eja rʉ̃gʉ̃cõri, naju gʉare batoquĩ ĩ. Waire cʉni ito bajiroti yiquĩ. ");
INSERT INTO myy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Itina ʉdiaji goaĩoquĩ Jesús gʉare, godacõri tʉdi ĩ catija bero. ");
INSERT INTO myy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gʉa ba yuji tĩoja bero ado bajiro seniĩaquĩ Jesús Simón Pedrore: —¿Mʉ rãca gãna rẽtoro yʉre maiati Simón, Jonás macʉ mʉ? yiquĩ Jesús Simón Pedrore. Ito ĩ yijare: —Mʉre maia yʉ Ʉjʉ yʉ. “Yʉre maiami”, yi masia mʉ, yiquĩ Pedro Jesure. Ito ĩ yijare: —Oveja rĩare ĩna ecasotiado bajiro yʉre yiari yʉ ñarãre riaso ĩsima mʉ, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mʉcana tʉdi jʉaji seniĩaquĩ Jesús Simón Pedrore: —¿Yʉre maiati Simón, Jonás macʉ mʉ? yiquĩ Jesús Pedrore. —Mʉre maia yʉ Ʉjʉ yʉ. “Yʉre maiami”, yi masia mʉ yiquĩ Pedro Jesure. Ito ĩ yijare: —Ovejare ĩna codeado bajiro yʉre yiari yʉ ñarãre code ĩsima mʉ, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ito yija mʉcana tʉdi ʉdiaji seniĩa quenoquĩ Jesús ĩre: —¿Yʉre maiati Simón, Jonás macʉ mʉ? yiquĩ Jesús Pedrore. Ʉdiajijʉ, “¿Yʉre maiati mʉ?” Jesús ĩ yija tʉocõri, bojori bʉjaquĩ Pedro. Ito bajiri ado bajiro yiquĩ ĩ Jesure: —Jeyaro masigʉ̃ ña, yʉ Ʉjʉ mʉ. Yʉ mʉre mairise masia mʉ, yiquĩ Pedro Jesure. Ito ĩ yijare: —Ovejare ĩna ecasotiado bajiro yʉre yiari yʉ ñarãre riaso ĩsima mʉ. ");
INSERT INTO myy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Riti mʉre gotia yʉ. Iti rʉmʉjʉ mamʉ mʉ ñaja yutabuju sãñacõri, mʉ ãmoro bajiroti wa ucusotiyija mʉ maji. Mʉ bʉcʉgʉ ñaja mʉ ya ãmo siacõri, mʉ wa ãmobetojʉ mʉre ãmi warã yirãji ĩna, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","“Ito bajiro mʉ godaja ticõri, Diore rʉ̃cʉbʉorã yirãji masa”, yirocʉ ito bajiro gotiquĩ Jesús Pedrore. Ito ĩ yija bero: —Waya yʉ rãca. Yʉ oca tʉo sʉyagʉ waya, yiquĩ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jʉda ticõri, ĩnare yʉ sʉyaja tiquĩ Pedro. Yʉ ña Jesús rãca riasotigorʉ bʉto ĩ maicacʉ. Yʉ ña Jesús rãca basʉsacati rʉmʉ ĩ tʉ rujicacʉ. Yʉ ña Jesure seniĩacacʉ, “¿Ñimʉ ñati mʉre ĩna ñiatoni gotiri masʉ?” yi seniĩacacʉ ña yʉ. ");
INSERT INTO myy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yʉre ticõri, ado bajiro Jesure seniĩaquĩ Pedro: —Yʉ Ʉjʉ, ¿ãniama no bajiro godagʉ yiguĩjida? yiquĩ Pedro Jesure. ");
INSERT INTO myy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ito ĩ yija ado bajiro cʉdiquĩ Jesús: —Mʉcana tʉdi yʉ ejarijʉjʉ ĩ catire yʉ ãmoja, catigʉ yiguĩji maji. Iti mʉ masibeja, no yibea mʉre. Mʉáma yʉre sʉyaba, yiquĩ Jesús Pedrore. ");
INSERT INTO myy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ito ĩ yija tʉocõri: “Juan godabicʉ yiguĩji”, yire masicã ĩna. Jesuama, “Godabicʉ yiguĩji”, yibitiquĩ. Ado bajirojʉa yiquĩ ĩ: “Yʉ tʉdi ejarijʉjʉ ĩ catire yʉ ãmoja, catigʉ yiguĩji maji. Iti mʉ masibeja, no yibea mʉre”, yigʉ yiquĩ Jesús. Iti oca queno tʉo masibiticõri, “Godabicʉ yiguĩji Juan”, yire oca batobojañi ĩna. ");
INSERT INTO myy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yʉ ña Juan, Jesús rãca riasotigorʉ. Yʉti ña adi paperare ucarʉ. “Riojo gotiami”, yi masia mʉa yʉre. ");
INSERT INTO myy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gaje jaje ña Jesús ĩ yigore. Jeyaro Jesús ĩ yigore mani uca jeobojaja cʉni, adi macãrʉcʉ̃rore daja rẽtacoabodoja papera tutiri. Itocõ ña.");
INSERT INTO myy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yʉ baba Teófilo, ñati mʉ. Iti rʉmʉjʉ mʉre papera yʉ cõasʉocati Jesús ĩ yigore, ito yicõri ĩ riasore gaye mʉre papera cõacʉ yʉ. ");
INSERT INTO myy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ñajediro ĩ yigore mʉre gotigʉ macãrʉcʉ̃ro ĩ mʉja warajʉna ucasʉsacʉ yʉ. Ũmacʉ̃jʉ ĩ mʉjaroto riojʉa ĩ oca goti ucuronare beseyijʉ Jesús. Apóstoles wame cʉtiyijarã ĩna. Espíritu Santore tʉocõri, “Adi ña mʉa moaroti”, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús ĩ godaja bero mʉcana tʉdi caticõri ĩ oca goti ucutoni ĩ cũanare goaĩoyijʉ Jesús. Jʉ̃arã masacõ rʉmʉri goa ñayijʉ Jesús, coji meje. Ĩ tʉdi catire gaye queno ĩna masisatoni biyaro goaĩoyijʉ Jesús, ĩ cũanare. Ĩnare goaĩocõri, “No ĩre tʉorʉ̃nʉrãreti ĩ rotirojʉ miojugʉ yiguĩji Dios”, yire oca riasoyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ĩna rãca ñagʉ̃jʉ, ado bajiro gotiyijʉ Jesús ĩnare maji: —Ado Jerusalénre wagobeja mʉa. Mani Jacʉ Dios ĩ gotiado bajiroti Espíritu Santo ĩ ejarotire bocatiya mʉa, yiyijʉ Jesús ĩnare. Ito yicõri, coji meje mʉare goticʉ yʉ itire, yiyijʉ Jesús ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Iti rʉmʉjʉ ñeñaro mʉa yirise jidicãja bero mʉare idé guñi Juan. Ito bajiri nocõ mejeti Espíritu Santo queo sãgʉ̃ yiguĩji Dios mʉare, yiyijʉ Jesús ĩ cũanare. ");
INSERT INTO myy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesús rãca minijuacõri ado bajiro seniĩayijarã ĩna ĩre: —Jane mejejʉ romano masa gʉa ya sita ẽmacõri gʉare moa rotiyoñi ĩna. ¿Adocãta ĩnare bucõagʉ̃ yigʉjada mʉ? Ito yicõri, ¿ado gʉa rotigorajʉ mʉcana gʉare jʉdacõa rotigʉ yigʉjada mʉ? yiyijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ĩna ito yija tʉocõri, ado bajiro cʉdiyijʉ Jesús ĩnare: —No yicõri masire ma mʉare. Mani Jacʉ Dios, ĩ masirisena ĩ yirotire, ĩ sĩgʉ̃ti masiami itire. Masibea mʉa. Di rʉmʉ, di rodo, di ʉ̃mʉa, yi masibea mʉa. Dios sĩgʉ̃ti masiami ĩ yirotire. ");
INSERT INTO myy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Adijʉa ña mʉa masiriseoni. Espíritu Santo ĩ wadiroca, oca sẽorise ejaro yiroja mʉare. Ito yicõri gãjerã cʉtorijʉ wacõri, ĩnare yʉre bʉsirã yirãji mʉa. Jerusalénjʉ, Judea sitajʉ cʉni, Samaria sitajʉ cʉni, macãrʉcʉ̃ro ñarocõjʉti, yʉre bʉsirã yirãji mʉa, yiyijʉ Jesús apóstol mesare. ");
INSERT INTO myy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iti ĩnare goti tĩocõri, ĩre ĩna tibojaroca riti ũmacʉ̃jʉ mʉja wasʉoyijʉ Jesús. Ito bero ide bueri iti ejarocati, ruyubiticoayijʉ Jesús ĩja. Ito bajiri tʉdi tibisijarã ĩna Jesure. ");
INSERT INTO myy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ĩ mʉjagorajʉ macãrʉcʉ̃rojʉ ti mʉo ñayijarã ĩna. Ito bajiro ĩna ti mʉo ñaroca ñajasaroti Dios ñaro gãna jʉ̃arã ángel mesa goa rʉ̃gʉ̃yijarã ĩna tʉ. Yutabuju bʉto yorise sãñarã ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ado bajiro gotiyijarã ĩna: —Mʉa Galilea gãna, macãrʉcʉ̃rojʉ ti mʉo rʉ̃gõbesa. Ãni Jesuti, macãrʉcʉ̃rojʉ mʉja wacʉ, mʉcana ĩ mʉja waja, mʉa tiado bajiroti mʉcana tʉdi ejagʉ yiguĩji ĩja, yiyijarã ángel mesa Jesús ĩ cũanare. ");
INSERT INTO myy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olivos wame cʉtiri tʉriajʉ ñayijarã Jesús ĩ cũana. Ito bero Jerusalénjʉ tʉdicoayijarã ĩna ĩja. Sõjʉ meje ñayijʉ iti cʉto. Coji cõrecõ ñayijʉ iti cʉto. ");
INSERT INTO myy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cʉtojʉ ejacõri ĩna ñari wijʉ mʉja wacõri, co sãnimʉ weca sãjayijarã ĩna. Ĩna ñayijarã ado bajiro wame cʉtirã: Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, ito yicõri Alfeo macʉ Santiago. Ito bero gãjerã ñayijarã Simón celote gaye tʉoĩagorʉ, ito yicõri Santiago macʉ Judas. Itocõ ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sĩgʉ̃re bajiro ʉsi cʉticõri minijuasotiyijarã ĩna Diore bʉsirona. Jesús ocabajirã, ito yicõri Jesús jaco María, gãjerã romia cʉni cojʉti minijuacõri Diore bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Iti rʉmʉriti Jesure masirã minijuayijarã. Co ãmojeno masa ñayijarã ĩna. Ĩna wato wʉmʉ rʉ̃gʉ̃cõri, ado bajiro gotiyijʉ Pedro ĩnare: ");
INSERT INTO myy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Tʉoya yʉ ñarã mʉa. Jane mejejʉ mani ñicʉ David ñayorʉ, Espíritu Santo ĩ rotija ucayoñi, Judas ĩ ñarotire. “Jesure ĩna ñiatoni gotigʉ yiguĩji Judas wame cʉtigʉ”, yi tʉoĩa yugʉ ito bajiro ucañi David ñayorʉ. Iti ĩ ucayore bajiroti rẽtacʉ. Ado bajiro rujeayijʉ Dios ĩ bʉsire. Tʉote mʉa, yiyijʉ Pedro ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","’Judas cʉni mani rãca cocati Jesús rãca riasotiquĩ. Ito yicõri mani rãca moaquĩ. ");
INSERT INTO myy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mani rãca moacacʉ ñabojagʉti Jesure ĩna ñiatoni oca meniñi ĩ. Ito bajiro ñeñaro ĩ yija bero yucʉgʉ ũmacʉ̃jʉ mʉja wacõri ĩ ya ãmʉmajʉ jũgʉbo siayijʉ. Ito bajiro yicõri bubu quedi yojayijʉ. Ito bajicõri godacoayijʉ ĩja. Ito bero ũmacʉ̃jʉ wada yojacõri ĩ ya jeraga joto watojʉ ĩ ya gʉdamisi budi yojayijʉ. Ĩ ñajacʉ ñeñaro yire wajana sʉori ĩ ñajacʉ ya niyeru ãmicõri cojʉ sita waja yiyijarã gãjerã. ");
INSERT INTO myy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalén gãna itire tʉobʉjacõri, “Acéldama”, wame yiyijarã iti sitare. Ĩna ocanama, “Sĩare waja ĩna waja yira sita ña”, yireoni ñayijʉ. ");
INSERT INTO myy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jane mejejʉ David ñayorʉ ado bajiro ucañi: Wagoado ñaro yiroja ĩ ya wi. Masa ñamenaji ĩ ya wire. Ito yicõri gãji moa wasoagʉ yiguĩji ĩ ya moare, yi ucañi David ñayorʉ, yiyijʉ Pedro ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Ito bajiri Judasre wasoato mani. “Jesús ĩ godaja bero mʉcana tʉdi catiami”, yi masigʉ̃re mani beseja quena. Ito yicõri Juan Jesure ĩ idé guroca tirʉ, ito yicõri Jesús ĩ mʉjaja tigorʉre mani beseja quena. Gãjire beserʉja manire, mani rãca ñacacʉre. Ito yicõri Jesús ĩ wa ucuroca wa ucurʉre beserʉjarãji mani. Ito bajigʉre ãmarʉjarãji mani, yiyijʉ Pedro ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pedro ĩ bʉsija bero, ito ñarã jʉ̃arã ʉ̃mʉare beseyijarã ĩna. “José Justo Barsabás wame cʉtigʉ quenami”, yiyijarã ĩna. “Matías ĩ cʉni quenami”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ito bajiro yicõri, Diore ado bajiro seniyijarã ĩna: —Dios gʉa Ʉjʉ, mʉ masia masa jeyaro ĩna tʉoĩarise gaye. Ito bajiri gʉare ĩoña mʉ beserʉre. ");
INSERT INTO myy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judasre wasoarocʉ ito yicõri gʉa rãca riasotirocʉre ĩoña gʉare. Judas gʉare wagoquĩ ñeñaro yi ãmogʉ̃. Ito bajiri adocãta ñeñaro yirise waja, waja yiadojʉ ñaguĩji ĩ, yiyijarã ĩna Diore senirã. ");
INSERT INTO myy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ito yija José Justo wame gʉ̃tagãjʉ uca wõyijarã ĩna, ito yicõri Matías wame gajegajʉ. Itigari gʉ̃tagãri queocõri, “Tito maji, ñimʉ ñati Dios ĩ beserʉ”, yiyijarã ĩna. Gʉ̃tagã iti quedija ticõri, “Matías ñami Dios ĩ beserʉ”, yi masiyijarã ĩna. Ito bajiro bajicõri ĩna rãca ñasʉoyijʉ Matías coga gʉbojeno ñarã tʉ. Jʉa gʉbojeno ñarocʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés ñari rʉmʉ ejaroca Diore masirã ñarocõti cojʉti minijua ñayijarã. ");
INSERT INTO myy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ñajasaroti oca sẽoro ruyuyijʉ ũmacʉ̃jʉ. Bʉto mino iti wẽaro bajiro bajiyijʉ. Ĩna ñari wijʉ sãjacõri bʉto bʉsiyijʉ iti. ");
INSERT INTO myy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ito yicõri jea ʉ̃jʉ mʉjarise bajirise goayijʉ. Ito yicõri sĩgʉ̃ rʉyabeto quedi jeayijʉ iti. ");
INSERT INTO myy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ito yija, Diore riti tʉorʉ̃nʉjaro ĩna yirocʉ, Espíritu Santo quedi sãjayijʉ ĩnare. Itijʉnati ricati riti ĩna masibiti oca ñabojareti bʉsisʉoyijarã ĩna, Espíritu Santo ĩ rotiro bajiroti. ");
INSERT INTO myy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Iti rʉmʉriti Jerusalénjʉ judio masa gaje cʉtori gãna wadiana ñayijarã ĩna. Diore rʉ̃cʉbʉorona wadiana ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ĩna bʉsirise iti ruyuja tʉocõri, minijuayijarã masa. Sĩgʉ̃ rʉyabeto ĩnarioti ĩna oca tʉoyijarã ĩna. Ito bajiri, no yi masia mañijʉ ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ito bajicõri mano ʉcayijarã ĩna. Ito yicõri ado bajiro ĩnamasiti gãmeri bʉsiyijarã ĩna: —¿Galilea sita gãna meje ñati, mʉa tija? ");
INSERT INTO myy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Jeyaro ricati ĩna bʉsija, ¿no yija mʉa oca, yʉ oca cʉni jeyaro oca ĩna bʉsija tʉoati mani? Gaje cʉtori gãna ña mani. ");
INSERT INTO myy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Jeyaro gãna ña mani. Tite mʉa. Ado ñama Partia gãna, Media gãna, Elam gãna, Mesopotamia gãna, Judea gãna, Capadocia gãna, Ponto gãna, Asia gãna, ");
INSERT INTO myy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia gãna, Panfilia gãna, Egipto gãna, ito yicõri Cirene cʉto sõjʉa Africa gãna, ito yicõri adijʉ gãna Roma gãna. Adijʉ rujeanati ñama judio masa coriarã. Gãjerãma judio masa ĩna tʉoĩare gayere boca ãmigoana ñama ĩna. ");
INSERT INTO myy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ito yicõri Creta gãna, ito yicõri Arabia gãna, adocõ jãjarã ña mani. ¿No yija mani jeyaro gãna ñabojarãti, Dios ĩ queno yirise ĩna bʉsija tʉoati mani? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mano ĩna rujʉ ʉcaja, no yi masia mañijʉ ĩnare. Ĩnamasiti gãmeri seniĩayijarã: —¿No yireoni ñati adi? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Coriarã ado bajiro bʉsiyijarã: —Mecʉrã yama, yi aja tudiyijarã ĩna, Espíritu Santo sãjagoanare. ");
INSERT INTO myy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ĩna aja tudija tʉocõri, ĩ baba mesa apóstol mesa rãca wʉmʉ rʉ̃gʉ̃yijʉ Pedro. Ĩna ito yija ticõri, oca sẽoro bʉsiyijʉ Pedro, minijua ñarã jeyaro ĩna tʉotoni: —Queno tʉoya yʉ ñarã mʉa, yʉ bʉsirise. Adijʉ Jerusalén gãna mʉa, queno tʉoya mʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Mecʉrã ya mʉa”, yibojarãji mʉa gʉare. Mecʉrã meje ya gʉa. Busuri jĩjʉ ña maji. Mecʉrajʉ meje ña maji. ");
INSERT INTO myy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ado robojʉa bajia. Gʉare mʉa tirise, “Ito bajiro rẽtaro yiroja”, yiyijʉ Dios oca goti ĩsiri masʉ, Joel wame cʉtigʉ. Jane mejejʉ ado bajiro ucayoñi Joel, Diore yiari: ");
INSERT INTO myy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Sʉsari rʉmʉri Espíritu Santo masa jãjarãre queo sãgʉ̃ yigʉja yʉ. Yʉ yerioti bʉsirã yirãji mʉa rĩa masa. Yʉ ye gaye tireti goaro yiroja mamarãre cʉni. Bʉcʉrãreama cãirijʉ ĩnare bʉsicʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sʉsari rʉmʉri Espíritu Santo sãcʉja yʉ, yʉre ejabʉari masare. Ito bajiri yʉ yerio bʉsirã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ũmacʉ̃jʉ macãrʉcʉ̃rojʉ tiyamani mʉare ĩogʉ̃ yigʉja yʉ. Mʉa ñari tuti, adi sita cʉni, tiyamani ĩogʉ̃ yigʉja yʉ. Rí ñaro yiroja, ito yicõri jea ʉ̃jʉrise, ito yicõri bueri bue dajaro yiroja. ");
INSERT INTO myy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ũmacañi cʉni yaticoagʉ yiguĩji. Ũmacañi ñami gagʉ cʉni, rí robo bajiro sũagʉ̃ yiguĩji. Iti jeyaro baji jediroca, Jesús ñeñaro yiri masare waja seniri rʉmʉ ejaro yiroja. Ñasari rʉmʉ ñaro yiroja Jesús ĩ ito bajiro ĩ ĩori rʉmʉ. Guijori rʉmʉ ñaro yiroja. ");
INSERT INTO myy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","“Yʉ Ʉjʉ, ñeñaro yigʉ ña yʉ. Yʉ ñeñaro yirisere ãcabojoya mʉ”, yʉre yirãreama jeame ʉ̃jʉrojʉ ĩna wabore ñaroca ĩnare masogʉ̃ yigʉja yʉ, yiyijʉ Dios, Joelre gotigʉ, yiyijʉ Pedro masare. ");
INSERT INTO myy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ito yija mʉcana tʉdi bʉsi remoyijʉ ĩ: —Tʉoya yʉ ñarã ado yʉ gotiroti. Nazaret gagʉ Jesús ĩ masiro robo yicõri mʉare ĩoñi. “Dios ĩ rotiro bajiroti yiñi Jesús”, yi masiarãji mʉa itire tigoana ñari. ");
INSERT INTO myy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ito bajibojarocati, Jesure ñiacõri, masa quenamenare ĩsiyija mʉa yucʉtẽojʉ ĩna jajutoni. Iti mʉa yiroto riojʉajʉ masi yucãrʉ Dios. Ito bajibojarocati mʉare camotabitirʉ Dios. Jesure sĩatoni gãjerãre mʉa ĩsire waja mʉareti seti ña. ");
INSERT INTO myy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dioama Jesús ĩ godaja bero mʉcana tʉdi ĩ catiroca yicõñi. Ito bajiri godagoana ʉjʉ Satanás, Jesure ñiacũ masibisijʉ. Ito bajiri mʉcana tʉdi caticoañi ĩ. ");
INSERT INTO myy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jane mejejʉ mani ñicʉ David ñayorʉ Jesús ĩ Jacʉre ĩ bʉsigore ucañi. Tite mʉa. Ado bajiro bʉsiyijʉ Jesús Diore: Cʉna yʉ rãcati ña mʉ. Ito bajiri ñejʉa güire ma yʉre. ");
INSERT INTO myy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yʉ tʉoĩaja queno sosa yʉre. Ito bajiri bʉto wanʉcõri mʉre bʉsia yʉ. Ito bajiri yʉ ya rujʉ godaja bʉjatobiti yibicʉja yʉ. ");
INSERT INTO myy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Cʉna yʉ masia godarã watojʉ yʉre wagobicʉja mʉ. Mʉ Macʉ ña yʉ. Mʉre rʉ̃cʉbʉoa yʉ. Ito bajiri yʉ ya rujʉ jogaroca yibicʉja mʉ. ");
INSERT INTO myy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ito bajiri mʉcana tʉdi yʉ catiroca yigʉ yigʉja mʉ. Bʉto wanʉ quenagʉ̃ yigʉja yʉ, mʉ rãca yʉ ñaja mʉcana, yiyijʉ Jesús Diore, yi ucañi David ñayorʉ, yiyijʉ Pedro masare. ");
INSERT INTO myy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Ito yicõri gaje ña. Tʉoya yʉ ñarã mʉa. Mani ñicʉ David ñayorʉ ĩ cõja adoti yuje ecoñi. “Ado ña ĩre yujeado”, ya mani. Ito bajiri ĩ tʉoĩarise gaye meje bʉsiyorʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David catigʉjʉ, ija bajirotire goti yuri masʉ ñayoyijʉ. “Ija yʉ janerãbatia Dios ĩ cõarʉ sĩgʉ̃ ñagʉ̃ yiguĩji. Yʉ robo Ʉjʉ ñagʉ̃ yiguĩji ĩ”, yi tʉoĩayijʉ David, Dios ĩ gotija tʉocõri. Tite mʉa. ");
INSERT INTO myy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ado bajiro ucañi David: “Cristo mʉcana tʉdi catigʉ yiguĩji. Ito yicõri ĩ ya rujʉ godana watojʉ jogabeto yiroja”, yiñi David. Ito ĩ yirisere, ija bajirotire gotigʉ yiñi ĩ, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mʉcana tʉdi bʉsi remoyijʉ Pedro: —Jesús ĩ godaja bero, mʉcana tʉdi ticʉ gʉa. Ito bajiri, “Ĩre tʉdi catioñi Dios”, ya gʉa. ");
INSERT INTO myy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dios ũmacʉ̃jʉna ñacõri Jesure jiyijʉ. Dios tʉ ejacõri ĩ ya riojocadʉja, rʉ̃cʉbʉorajʉ, rujiguĩji Jesús. Dios ĩ goticãdo bajiroti Jesure cũñi, Espíritu Santore gʉare ĩ queo sãtoni. Jĩjʉ mʉa tirise, ito yicõri mʉa tʉorise, Espíritu Santo ĩ ejaja ito bajiro rẽtamʉ. Ititi ña ĩ wadire gaye. ");
INSERT INTO myy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David ñayorʉ ĩmasire rẽtaroti meje ucayoñi ĩ. Jesús ĩ mʉjado bajirogoroama, ĩ ya rujʉ rãca ñarocõti ũmacʉ̃jʉ mʉjabitiyoyijʉ David. Ito bajiri ado bajiro ucayoñi David: Mani Ʉjʉ Cristore ado bajiro yiñi Dios: “Yʉ tʉ riojocadʉja rujiya, rʉ̃cʉbʉorajʉ. ");
INSERT INTO myy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mʉ wajana queno mʉre ĩna cʉdiroca yigʉ yigʉja yʉ”, yiyijʉ Dios mani Ʉjʉre. Ito bajiro ucayoñi David, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Yʉ ñarã, ito bajiri ĩja, “Riti ña”, yi masitoni mʉare bʉsia yʉ. Cristore, yucʉtẽojʉ mʉa sĩarʉreti, mani Ʉjʉ ñarocʉre, manire masorocʉre cũñi Dios. Ĩti ñami mʉcana, yiyijʉ Pedro masare. ");
INSERT INTO myy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ito bajiro ĩ yija tʉocõri, bʉto tʉoĩa ʉsi bata bʉjatobisijarã ĩna. Ito bajiri Pedro mesare seniĩayijarã ĩna: —¿No yirʉjati gʉa ĩja? yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ĩna ito yija tʉocõri, Pedro ado bajiro cʉdiyijʉ ĩnare: —Ñeñaro mʉa yirise jidicãña, mʉa ñeñaro yirisere Dios ĩ ãcabojotoni. Ito yicõri, “Jesucristore masirã ñama”, gãjerã ĩna yi masitoni, idé gu rotiya mʉa. Ito yija Espíritu Santo queo sãgʉ̃ yiguĩji Dios mʉare. ");
INSERT INTO myy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dios, Espíritu Santo sã ãmoguĩji mʉare, ito yicõri mʉa rĩare, mʉa janerãbatiare, ito yicõri sõjʉ gãnare cʉni. Ĩ beserã ñajedirore Espíritu Santo sã ãmoguĩji Dios, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Iti riti bʉsigʉ meje yiyijʉ Pedro. Ito yicõri masare riaso bʉsiyijʉ ĩ. Gaje ado bajiro ĩnare riaso bʉsiyijʉ Pedro: —Masa ñeñarã rãca wʉsabesa mʉa. Camotadiya mʉa, ĩna rãca jeame ʉ̃jʉrojʉ mʉa wabe yirona, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ito bajiro Pedro ĩ gotija tʉo wanʉcõri, ʉdiaji mil masa ñarã Jesure boca ãmiyijarã. Ito yicõri yoari mejeti idé gu rotiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ito bajiro yicõri apóstol mesa rãca ĩna riasorise tʉorona ĩna tʉ minijuasotiyijarã. Ĩna riasorisere tʉo ñiacõri itire tʉorʉ̃nʉ jidicãbisijarã ĩna. Ito bajiri sĩgʉ̃ bajiro riti ʉsi cʉtiyijarã ĩna ĩja. Ito bajiro tʉoĩacõri ĩna rʉcorisere maimenati bojoro bʉjarãre ĩsiyijarã ĩna. Coji rʉyabeto minijuacõri Diore bʉsiyijarã ĩna. Ito yicõri, “Iti ña Jesús ya rujʉ robo bajirise”, yi tʉoĩacõri naju bato bayijarã ĩna. Manire yiari Jesús ĩ goda ĩsire tʉoĩarã ĩ rotiro bajiro najure bato bayijarã. ");
INSERT INTO myy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apóstol mesa jaje tiyamani ĩoyijarã, Dios ĩna rãca ĩ ñajare. Itire ticõri mano ʉcayijarã masa ito gãna. ");
INSERT INTO myy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Sĩgʉ̃ rʉyabeto Jesure masirãma sĩgʉ̃ bajiro riti ʉsi cʉtiyijarã ĩna. Gãjerã bojoro bʉjaja ticõri, ĩna ya gajeoni ĩsicõri waja ãmiyijarã ĩna, bojoro bʉjarãre niyeru ĩsirona. ");
INSERT INTO myy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Co rʉmʉ rʉyabeto, sĩgʉ̃ bajiro riti tʉoĩarã ñari, Dios ya wijʉ minijuasotiyijarã ĩna Diore bʉsirona. “Ñasagʉ ña Dios mʉ”, yi bʉsiyijarã ĩna, Diore rʉ̃cʉbʉorã. Ito yi tʉdi wacõri ĩna ya wirijʉ naju bato bayijarã ĩna. Bʉto wanʉ quenayijarã ĩna, ĩna baba mesa rãca bare bato barona. “Gãjerã rẽtoro tʉoĩa masirã ña mani”, yi tʉoĩabisijarã ĩna. Queno ĩna yirise ti masicõri, “Queno yirã ñama”, yiyijarã cʉto gãna. Co rʉmʉ rʉyabeto iti cʉto gãna coriarã Jesure boca ãmiyijarã. Jesure boca ãmicõri Jesure masirã tʉ minijuayijarã ĩna. Ito bajiri jãjarã bʉsa Jesure masirã bʉjʉ wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Co rʉmʉ rʉyabeto tres ñaroca riti Diore bʉsisotiyijarã ĩna. Ito bajiri itocõ tʉjaroca Dios ya wijʉ mʉja wayijarã ĩna, Pedro, Juan rãca jʉ̃arã, Diore bʉsirona. ");
INSERT INTO myy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Soje tʉ sĩgʉ̃ masʉ rujiyijʉ. Cajerojʉti wa masibicʉ rujearʉ ñayijʉ ĩ. Ito bajiri wa masibisijʉ ĩ. Co rʉmʉ rʉyabeto ĩ baba mesa ĩre ãmi wasotiyijarã. Ito yicõri soje tʉ ĩre jidi rojosotiyijarã ĩna. Iti soje ado bajiro wame cʉtiyijʉ. Seyori soje ñayijʉ iti soje. Iti soje tʉ rujicõri ito ejarãre, “Yʉre ti maiñame, jabeto niyeru yʉre ĩsiña mʉa”, yi rujiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro mesare sãjarã wana yiroca: —Yʉre jabeto ti maiñame mʉa, yiyijʉ rudurʉ. ");
INSERT INTO myy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ito ĩ yija tʉocõri, queno tisayijarã ĩna ĩre. Ado bajiro yiyijʉ Pedro ĩre: —Adojʉa tiya mʉ, yiyijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","“Yʉre jabeto ĩsirã yirãji”, yirocʉ queno tʉoĩabojayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ito yija Pedro ado bajiro yiyijʉ ĩre: —Niyeru ma yʉre, manirea. Gaje ñasarisejʉa mʉre ejabʉacʉja yʉ. Jesucristo Nazaret gagʉre tʉorʉ̃nʉcõri, “Wʉmʉña mʉ, wasa”, ya yʉ mʉre yiyijʉ Pedro rudurʉre. ");
INSERT INTO myy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ito bajiro yicõri ĩ ya riojocadʉja ñiacõri tʉ̃a wʉmʉo rʉ̃gõyijʉ Pedro. Ito ĩ yirocati, ĩ ya ñicʉri sẽocoayijʉ ĩre, rudurʉ ñabojarʉre. ");
INSERT INTO myy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ito bajiri bubu quedi rʉ̃gʉ̃cõri, wasʉoyijʉ ĩ. Pedro mesa rãca sãja wayijʉ rudurʉ ĩja, Dios ya wijʉre. “Dios queno yami yʉre. Yʉ ñarise cʉtirise yʉre yisioami ĩ”, yi wanʉ quena wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Iti wijʉ Dios ya wijʉ ñarã ĩ waja tiyijarã ĩna. “Queno yami Dios yʉre”, ĩ yi bʉsija tʉoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ito bajiri ĩre ti masicõri ʉcayijarã ĩna. “Soje tʉ rujigʉ, rudurʉ, niyeru seni rujigʉ, ¿meje ñati ĩ?” yiyijarã ĩna ʉcare rãca. ");
INSERT INTO myy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Rudurʉ ñabojarʉ, Pedro mesa watoje ñayijʉ ĩ. Ĩnare jidicãbisijʉ ĩ. Dios ya wi tʉ, Pórtico de Salomón wame cʉtirijʉ rʉ̃gõyijarã ĩna Pedro mesa. Iti ito bajiro rẽtaja ti ʉcacõri, masa jãjarã ũma minijuayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Masa ĩna minijuaja ticõri, ado bajiro bʉsiyijʉ Pedro ĩnare: —¿No yija ti ʉcati, yʉ ñarã mʉa? Sõco bʉsa tiya gʉare. Ãni rudurʉre gʉamasiti yisiobijʉ. Gʉa masiro robo yija meje, Diore queno gʉa cʉdija meje wami ãni rudurʉ. ");
INSERT INTO myy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ado robojʉa bajia. Jesús ũmacʉ̃jʉ gagʉ ĩre yisioñi. Mani ñicʉsabatia Abraham, Isaac, ito yicõri Jacob cʉni Diore riti rʉ̃cʉbʉoyijarã ĩna. Dios ĩna rʉ̃cʉbʉorʉ mʉcana ĩti ñami ĩja. Godarʉre tʉdi catiocõri, masa ĩna rʉ̃cʉbʉoroti gayere jidicãyijʉ Dios ĩ Macʉ Jesure. Ĩ Jesureti ñiacõri ĩsiyija mʉa, ñari masa ʉjarãre, ĩre ĩna sĩatoni. Ʉjʉ Pilato, Jesure ĩ bucõa ãmobojarocati, mʉajʉa bucõare ãmobisija. ");
INSERT INTO myy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pilatore, Jesús quenagʉ̃re bucõa rotiado õno yirã, sĩari masʉre bucõa rotiyija mʉa Pilatore. ");
INSERT INTO myy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ito yirã riti masare catire gaye ĩsigʉ̃re sĩa rotiyija mʉa. Ito bajibojarocati, Dioama godarʉre tʉdi catiocõñi. Ĩre ticõri, “Mʉcana tʉdi catiami”, yi masia gʉa, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ito yicõri mʉcana ado bajiro bʉsi remoyijʉ Pedro: —Ãni rudurʉ ñabojacacʉre ti masia mʉa. “Jesús yʉre yisio masiami”, ĩ yi tʉoĩajare, yoari mejeti ĩ ya ñicʉri sẽocoayijʉ ĩre. Ñaro bajiroti ĩre yisioñi Jesús. Itire ti masia mani, yiyijʉ Pedro. ");
INSERT INTO myy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Masia yʉ ñarã yʉ ĩja. Mani ʉjarã rãca Jesure sĩa rotiyija mʉa. “Bʉto ñeñaro ya gʉa”, yi tʉoĩa masibitibojarãti ito bajiro yiyijari yʉ ñarã, ya yʉ mʉare. ");
INSERT INTO myy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jesure mʉa sĩacatijʉ, “Ito bajiro yiroja”, Dios ĩ yire ñaro bajiroti bajicʉ iti. Dios ĩ oca gotiri masa ĩre yiari ado bajiro gotiyijarã jane mejejʉ: “Cristo quenabeto tõbʉjacõri, godagʉ yiguĩji”, yiyijarã Dios oca gotiri masa. ");
INSERT INTO myy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ito bajiri iti oca tʉocõri ñeñaro mʉa yirisere jidicãña mʉa. Ito yicõri Dios ĩ ʉsi cʉtiro bajiro tʉoĩaña mʉa, ñeñaro mʉa yirise ĩ ãcabojotoni. Ito yija Dios mʉa ya ʉsijʉ ʉsirioya mani mʉare jidicãguĩji. ");
INSERT INTO myy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ito yija mʉcana tʉdi cõagʉ̃ yiguĩji Dios, Cristore. Jane mejejʉ besecãñi Dios, Cristore mani Ʉjʉ ñarocʉre. ");
INSERT INTO myy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Adocãta ũmacʉ̃jʉ ñaguĩji Cristo. Co rʉmʉ adi macãrʉcʉ̃rore mʉcana quenogʉ̃ yiguĩji Dios, ĩ goticãdo bajiroti. Dios ĩ queno tĩori rʉmʉ bocatigʉ yiguĩji Jesucristo. Adi ña Dios oca goti ĩsiri masa, Diore rʉ̃cʉbʉorã ĩna ucare. ");
INSERT INTO myy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sĩgʉ̃ Dios oca goti ĩsiri masʉ, Moisés wame cʉtigʉ, ado bajiro gotiyoñi mani ñicʉsabatiare: “Dios mani Ʉjʉ yʉre ĩ cõado bajiroti, gãji ĩ oca gotirocʉ cõagʉ̃ yiguĩji. Dios ĩ cõarocʉ mani comasiti ñagʉ̃ yiguĩji. ");
INSERT INTO myy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jeyaro ĩ yirise yiro bajiroti cʉdiba mʉa. Yiro robo cʉdimenare, mani Israel gãnare gajerojʉ ãmicõa ruyuriocõgʉ̃ yiguĩji”, yiyijʉ Moisés ñayorʉ. Adi ña mani ñicʉsabatiare, ĩ gotire, yiyijʉ Pedro masare. ");
INSERT INTO myy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Mʉcana tʉdi bʉsi remoyijʉ Pedro: —Samuel bero gãna cʉni Dios oca goti ĩsiri masa, adi rʉmʉri bajiroti gayere, ñaro bajiroti gotiyoyijarã ĩna cʉni. ");
INSERT INTO myy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jane mejejʉ, mani ñicʉsabatiajʉare Dios ĩ goticãrere gotiyijarã ĩna Dios oca gotiri masa. Dios mani ñicʉsabatiajʉare, ĩ goticãre ñajare quenarise ejaro yiroja manire. Ado bajiro mani ñicʉ Abraham ñayorʉre goticãyijʉ Dios: “Queno masa jeyaro wanʉ quenare gaye ejaro yiroja, mʉ rĩa janerãbatiana sʉoriti ĩ rujeajare”, yiyijʉ Dios mani ñicʉ ñayorʉre gotigʉ. ");
INSERT INTO myy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ĩ Macʉre tʉdi catiocõri, cajero mani rãca ñarocʉre ĩre cõañi Dios, mani queno wanʉ quenatoni. Ito yicõri mani ñeñaro yirisere jidicãtoni, ĩ Macʉre cõañi Dios, yiyijʉ Pedro masare gotigʉ. ");
INSERT INTO myy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro, Juan rãca jʉ̃arã masare ĩna riaso ñaroca paia ejayijarã, saduceo gaye tʉoĩarã, ito yicõri Dios ya wi coderi masa ʉjʉ cʉni. ");
INSERT INTO myy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro ito bajiro masare ĩ riasoja tʉocõri, bʉto junisini ejayijarã ĩna. Ado bajiro riasoyijʉ Pedro ĩnare: “Jesús ĩ godaja bero mʉcana tʉdi catiñi. Ito bajiri mani cʉni tʉdi catirã yirãji, yi tʉoĩa mani”, yiyijarã Pedro mesa masare. ");
INSERT INTO myy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","4","Coriarã jãjarã Jesús oca tʉo ãmisãcõri Jesure boca ãmiyijarã ĩna. Ito bajirã riti jãjarã ʉ̃mʉa co dʉjamocõ mil masacõ ñarã, bʉjʉ wayijarã ĩna, Jesure masirã. Ito bajiri paia, saduceo gaye tʉoĩarã, Dios ya wi coderi masa ʉjʉ cʉni bʉto junisiniyijarã iti tʉocõri. Ito bajiri Pedro mesare ãmi wacõri tubiayijarã ĩna, ñamicajʉ iti ñajare. ");
INSERT INTO myy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Busuri itijʉ, Jerusalénti, mʉcana minijuayijarã judio masa ʉjarã, gãjerã bʉcʉrã, ito yicõri bʉcʉrã rotirise riasori masa cʉni minijuayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Paia ʉjʉ Anás wame cʉtigʉ cʉni ito ñayijʉ. Ito yicõri Caifás, Juan, Alejandro, gãjerã paia ʉjarã ñajediro minijua ñayijarã itojʉ. ");
INSERT INTO myy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ito bero Pedro mesa tubiara wijʉ ñarãre, ãmi wadi rotiyijʉ Anás. Pedro mesa ĩ tʉ ĩna ejaroca, ado bajiro seniĩayijʉ Anás: —¿Ñimʉ mʉare masare riaso roticati? Ito yicõri, ¿ñimʉ ĩ rotija rudurʉre yisiocati mʉa? yiyijʉ Anás Pedro mesare. ");
INSERT INTO myy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ĩ seniĩaja tʉocõri, ado bajiro cʉdiyijʉ Pedro, Espíritu Santo ĩ masirisena: ");
INSERT INTO myy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—Tʉoya mʉa. Rudurʉre gʉa queno yire, ito yicõri ĩre gʉa yisiore, ¿itire gʉare tʉo tudiati mʉa? yiyijʉ Pedro, masa ʉjarãre ito yicõri bʉcʉrãre cʉni. ");
INSERT INTO myy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mʉa queno masitoni, ito yicõri Israel sita gãna ñarocõti ĩna masitoni, mʉare ñasarise gotia yʉ. Ãni rudurʉ ñabojarʉ mʉa riojo rʉ̃gõgʉ̃re yisioñi Jesús Nazaret gagʉ. Jesús, yucʉtẽojʉ mʉa sĩarʉti, Dios tʉdi catiorʉti, ĩti rudurʉre yisioñi. ");
INSERT INTO myy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jane mejejʉ David ñayorʉ ado bajiro ucayoñi: “Mʉa wi meniri masa gʉ̃tagãre cõabojayija mʉa. Ito bajibojarocati mʉa cõaraga ñasarica ñaroja gʉ̃tagã”, yi ucañi David ñayorʉ, Jesure tʉoĩa yugʉ. Ado bajiro bajia yireoni ña adi. Mʉa judio masa ʉjarã, Jesure ãmomena yirãji. Ito bajibojarocati ñasagʉ ñagʉ̃ yiguĩji ĩ. ");
INSERT INTO myy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jesucristo sĩgʉ̃ti ñami adi macãrʉcʉ̃rojʉ masare masorocʉ Dios ĩ cõarʉ. Jesús sĩgʉ̃ti manire maso masiguĩji. Ñimʉjʉa gãji ĩ robo bajigʉ maquĩji, yiyijʉ Pedro ʉjarãre. ");
INSERT INTO myy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pedro, Juan rãca ĩna oca sẽoro bʉsija tʉocõri, bʉto tʉoĩa oca jaiyijarã ʉjarã. “Bʉto papera riasotibitiana ñabojarãti queno bʉsiama ĩna. Jesús rãca ñagoanati ñari seyoama ãna. Ito bajiri ĩre bajiroti riasoama”, yi tʉoĩayijarã ʉjarã. ");
INSERT INTO myy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Rudurʉ ñabojarʉ, Pedro mesa rãca ĩ ñajare, “Rudurʉre yisiobisija mʉa”, yi masibisijarã ʉjarã ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ito bajiri macʉ̃jʉ budi wa rotiyijarã ʉjarã, Pedro mesare. Ito yicõri ĩnamasiti gãmeri bʉsi ñayijarã ĩna ĩja: ");
INSERT INTO myy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿No yiana mania Pedrore, Juanre cʉni? Jerusalén gãna ñarocõti masiama rudurʉre ĩna yisiore. Ito bajiri, “Bʉrãti yama ĩna”, yi masia ma. ");
INSERT INTO myy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ado bajiro ĩnare gotirʉja mani: “Jesús gaye tʉdi mʉa bʉsi remoja, quenabeto tõbʉjarã wana ya mʉa. Ito bajiro mani ĩnare gotija, gãjerãre Jesús oca gotimena yirãji ĩna”, yi tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ito yija mʉcana tʉdi jisõyijarã ĩna Pedro mesare. Ĩna sãja ejaroca, “Masare riasobesa mʉa, ito yicõri Jesús gayere bʉsi ʉyabesa mʉa”, yibojayijarã ʉjarã Pedro mesare. ");
INSERT INTO myy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ito bajiro ʉjarã ĩna bʉsija tʉocõri, ado bajiro cʉdiyijarã Pedro mesa: —Mʉare gʉa cʉdijama, Diore cʉdimena robo bajiro bajia gʉa. Diore cʉdiado õno yirã, ¿mʉare cʉdirʉjati gʉa? yiyijarã ĩna. Dios ĩ tiro riojo, ¿no bajiro quenaroja, yire masiati mʉa? Diore cʉdirã yirãji, ya gʉa mʉare. ");
INSERT INTO myy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Jesure gʉa tʉogore, gʉa tigore cʉni, itire bʉsi jidicãdo ma gʉa, yiyijarã Pedro mesa. ");
INSERT INTO myy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Itire tʉocõri: —Tʉdi bʉsi ʉyabesa Jesús gayere. Jesús gayere mʉa riasoja, quenabeto tõbʉjarã yirãji mʉa, yiyijarã ʉjarã mʉcana. Rudurʉ ñabojarʉ ĩ waja ticõri, Diore rʉ̃cʉbʉoyijarã masa. “Quenoguti yigʉ ñami Dios”, yiyijarã masa. Ito ĩna yija masicõri, masare bʉto güiyijarã ʉjarã. Ito bajiri Pedro mesare quenabeto tõbʉjaroca yibisijarã ĩna. Ito bajiri riojoti bucõacõyijarã ʉjarã Pedro mesare. ");
INSERT INTO myy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Rudurʉ ñabojarʉ, ĩna yisiorʉ, jʉ̃arã masacõ rẽto bʉsaro rodori tʉjagʉ ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Budi warãjʉama ĩna baba mesa tʉjʉ wacoayijarã Pedro mesa. Ĩna baba mesa tʉ ejacõri jeyaro ʉjarã ĩna bʉsigore gotiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Itire tʉocõri sĩgʉ̃ bajiro riti ʉsi cʉtirã ñari Diore bʉsiyijarã ĩna: —Dios gʉa Jacʉ, mʉ sĩgʉ̃ti ña bʉto masigʉ̃. Macãrʉcʉ̃rore meniyija mʉ, sita cʉni, ito yicõri riari. Macãrʉcʉ̃ro gaye jeyaro meniyija mʉ. Ito yicõri adi macãrʉcʉ̃ro jeyaro ñarotire rujeoyija mʉ. ");
INSERT INTO myy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jane mejejʉ, Espíritu Santore cõayija mʉ gʉa ñicʉ David ñayorʉ, mʉ oca ĩ bʉsitoni. Ado bajiro ucayoñi David, mʉre queno moa ĩsigʉ̃ ñari: ¿No yija Cristore junisiniati judio masa meje ñarã cʉni? ¿No yija judio masa rocati ñasarise meje tʉoĩati? ");
INSERT INTO myy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Adi macãrʉcʉ̃ro gãna ʉjarã minijuacõri ña yucãma, mʉre ñeñaro yirona, ito yicõri Cristore cʉni ñeñaro yirona, yi ucañi David ñayorʉ. ");
INSERT INTO myy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Riti yiñi David. Ĩ gotiado bajiroti bajicʉ gʉa ya cʉto. Ʉjʉ Herodes, ito yicõri Poncio Pilato, judio masa meje cʉni, ito yicõri Israel sita gãna cʉni cojʉti minijua ñañi ĩna. Mʉ Macʉ, ñeñarise yibicʉre ñeñaro yirona minijuañi ĩna, masare masotoni mʉ cõarʉre. ");
INSERT INTO myy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mʉ Macʉre sĩañi ĩna. Jane mejejʉ, ado bajiro rẽtaro yiroja, yiyija mʉ, mʉ masirisena. ");
INSERT INTO myy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dios gʉa Jacʉ, gʉare tʉoya. “Quenabeto tõbʉjarã yirãji mʉa”, gʉare ĩna yirise ãcabojabesa mʉ. Gʉare ejabʉaya mʉ. Ñaro bajiroti mʉre cʉdi ãmoa gʉa. Ñe guijobeto, Jesús oca quenarise gʉa bʉsitoni gʉare ejabʉaya mʉ. ");
INSERT INTO myy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mʉ masirisena masa cõrãre masoña mʉ. Ito yicõri tiyamani cʉni yiya mʉ, “Jesuna sʉoriti bajia adi”, masa ĩna yitoni, yiyijarã ĩna Diore bʉsirã. ");
INSERT INTO myy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Diore ĩna bʉsi tĩoroca, ĩna minijua ñarijʉ sita ʉeyijʉ. Sita ʉerijʉ tototi, Espíritu Santo quedi sãjayijʉ ĩnare. Espíritu Santore queno cʉdicõri, ñe güire mejeti Dios oca masare gotisʉoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesure masirã sĩgʉ̃ bajiro riti tʉoĩa ñayijarã ĩna. Ĩna rʉcorise, “Yʉ sĩgʉ̃ ye ña”, yibisijarã ĩna. Ĩna baba mesare sĩgʉ̃ rʉyabeto batoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","35","Sita rʉcorã, ito yicõri wiri rʉcorã, gãjerãre ĩsiyijarã ĩna. Iti ĩsicõri niyeru bʉjayijarã ĩna. Niyeru bʉjacõri apóstol mesare ĩsiyijarã ĩna, bojoro bʉjarãre ĩna ĩsitoni. Ito bajiri ĩna rãca gãna sĩgʉ̃jʉa bojoro bʉjarã mañijarã ĩja. Jesús oca quenarise riaso jidicãbisijarã apóstol mesa. “Jesús ĩ godaja bero, mʉcana tʉdi caticõri, ñami mʉcana”, yi queno sẽo quenaro gotiyijarã ĩna masare. Ito bajiroca Jesure masirã ñarocõreti queno ĩna wanʉ quenatoni, ĩnare ejabʉayijʉ Dios. ");
INSERT INTO myy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jesure masirã wato ñayijʉ sĩgʉ̃ levita masʉ. José wame cʉtigʉ ñayijʉ ĩ. Chipre wame cʉtiri yogajʉ rujearʉ ñayijʉ ĩ. Apóstol mesa, Josére gaje wame wõyijarã, Bernabé. Griego ocama, “Wanʉ quenare gaye riasogʉ”, yireoni ñayijʉ iti wame. ");
INSERT INTO myy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Josére sita ñayijʉ. Itire gãjire ĩsiyijʉ ĩ. Iti waja niyeru bʉjacõri apóstol mesare ĩsiyijʉ, bojoro bʉjarãre ĩna batotoni. Queno yigʉ ñayijʉ José. ");
INSERT INTO myy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gãjijʉama, Ananías wame cʉtigʉ ĩ manojo Safira rãca, queno yirã meje ñayijarã ĩna. Ananías ĩ manojo rãca ĩna ya weseca gãjerãre ĩsiyijarã. Ito yicõri niyeru bʉjayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananías ĩ manojo rãca coro bajiro tʉoĩayijarã ĩna. Ito bajiri niyeru jabeto yeyoyijarã ĩna. Ito yicõri apóstol mesare ĩsigʉ̃ wayijʉ rʉyarise. Ĩnare ĩsi wacʉ, “Adi riti bʉjabʉ yʉ”, yiyijʉ Ananías ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ito ĩ yija tʉocõri, ado bajiro bʉsiyijʉ Pedro ĩre: —Ananías, ¿no yija rʉ̃mʉ́a ʉjʉre cʉdiati mʉ? Mʉ ya ʉsijʉ rʉ̃mʉ́a ʉjʉ sãjañi mʉre. “Adi riti bʉjabʉ yʉ”, mʉ yija, Espíritu Santore rʉo ãmogʉ̃ ya mʉ. ");
INSERT INTO myy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Weseca mʉ ya weseti ñabojadoja, mʉ ĩsi ãmoja, mʉ ĩsi ãmobeja cʉni. Mʉ ãmoro bajiro yirʉjaboyija mʉre. Weseca waja mʉ bʉjarise cʉni mʉ yeti ñabojadoja. Mʉ ĩsirotocõti, “Adocõti ĩsicʉja yʉ”, yirʉjabojayija mʉre. ¿No yija ñeñaro tʉoĩacõri rʉori mʉ? Mʉ rʉobojaja cʉni, gʉare riti meje rʉogʉ ya mʉ. Diore cʉni rʉogʉ ya mʉ, yiyijʉ Pedro Ananíasre. ");
INSERT INTO myy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ito bajiro ĩ yiroca cojisiti cõ quedicoayijʉ Ananías. Ito bajija tʉocõri, ito gãna ruje güiyijarã. ");
INSERT INTO myy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ito yija coriarã mamarã Ananías ya rujʉre gũmacõri ĩre yujerã wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ito bero ʉdiaji cõrecõ ejayijo Ananías ñabojarʉ manojo. “Ito bajiroja”, yibisijo iso. ");
INSERT INTO myy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","—¿Adi ñarocõti ñati weseca waja, mʉa bʉjare? yiyijʉ Pedro isore. —Ñarocõti ña, yi rʉoyija iso. ");
INSERT INTO myy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ito iso yija tʉocõri, ado bajiro yiyijʉ Pedro isore: —¿No yija mʉ manʉjʉ rãca sĩgʉ̃re bajiro ʉsi cʉticõri, Espíritu Santore rʉo ãmori mʉa? Macʉ̃jʉ tʉjama mʉ manʉjʉre yujerã ejana. Mʉcana mʉre ãmi warã yirãji, mʉre yujerona, yiyijʉ Pedro isore. ");
INSERT INTO myy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ito ĩ yirijʉti, cojisiti cõ quedicoayijo iso cʉni. Sãja wacõri cõrore ti bʉjayijarã mamarã. Ito bajiri isore ãmi budi wacõri manʉjʉ ñabojarʉ tʉjʉ yujeyijarã ĩna mʉcana. ");
INSERT INTO myy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jesure masirã ñarocõti, ito yicõri masa jeyaro, “Ito bajiyijʉ”, yija tʉocõri, bʉto güiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iti rʉmʉri Jesure masirã sĩgʉ̃ rʉyabeto sĩgʉ̃ bajiro riti ʉsi cʉticõri, Dios ya wi tʉ, Pórtico de Salomón wame cʉtirijʉ minijuasotiyijarã ĩna. Jerusalén gãna ĩna tiro riojo Dios ĩ masiro bajiro ĩ ejabʉarisena jaje tiyamani ĩoyijarã apóstol mesa. ");
INSERT INTO myy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jesure masirãre queno rʉ̃cʉbʉoyijarã Jerusalén gãna. Ito bajibojarocati Jesure masirã tʉ ware güiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Coriarã bʉto güiyijarã, ito bajibojarocati jãjarã Jesús oca tʉo ãmisãyijarã. Romia cʉni, ʉ̃mʉa cʉni Jesús oca tʉo ãmisãyijarã ĩna. Ito bajiri jãjarã bʉsa bʉjʉ wayijarã Jesure masirã. ");
INSERT INTO myy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tiyamani Pedro ĩ ĩogore tʉocõri, cõrãre ma tʉ ĩna cani jesari cumuro rãcati cũyijarã masa. Pedro ĩ rẽtaja tiana yirona, bocatiyijarã cõrã. Manire moaĩajaro yirona, bocatiyijarã ĩna ĩre. Manire ĩ moaĩabeja cʉni, ĩ rʉ̃mʉ́goti mani joe rẽtajaro yirona, bocatiyijarã. Tʉdi cati ãmorã ĩre bocatiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jãjarã masa, Jerusalén tʉ gãna wija wayijarã Jerusalénjʉ cõrãre ãmi warã. Ĩna ya ʉsijʉ rʉ̃mʉ́a sãñarãre cʉni ãmi wayijarã. Cõbojana ñajediro tuja jedicoayijarã ĩna. Ito yicõri rʉ̃mʉ́a sãñabojana cʉni rʉ̃mʉ́a budicoayijarã ĩja. ");
INSERT INTO myy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Iti tʉocõri paia ʉjʉ ito yicõri ĩ baba mesa saduceo gaye tʉoĩarã bʉto ti tudiyijarã apóstol mesare. ");
INSERT INTO myy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ito bajiri ñia roticõri Jerusalén ga wijʉ, tubiara wijʉ tubia rotiyijarã ĩna, apóstol mesare. ");
INSERT INTO myy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tubia ecoana ĩna ñabojarocati iti ñamiti iti wijʉ ángel goayijʉ ĩnare. Ito bajiri sojeri janacõri ĩnare tʉ̃a ãmi wayijʉ ĩ: ");
INSERT INTO myy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Dios ya wijʉ wasa mʉa. Ito ejacõri masare gotiba, ĩna cʉni catitĩñare gaye ĩna bʉjatoni, yiyijʉ ángel ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ito bajiri busuri jĩjʉ, Dios ya wi sãjacõri masare riasoyijarã ĩja. Ito bajiro ĩna riasoroca ricati paia ʉjʉ ĩ baba mesa rãca Israel sita gãna ʉjarãre jiyijarã, minijuatoni. Ito yicõri, “Tubiara wijʉ ñarãji”, yirona apóstol mesare ĩna ãmitoni surarare cõayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tubiara wijʉ ĩna ejaja, mañijarã ĩna. Ito tiboja, tʉdi wacõri, ʉjarãre gotirã wayijarã surara: ");
INSERT INTO myy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Tubiara wi queno soje biara wi ñaroca ejabojabʉ gʉa. Coderi masa cʉni itoti ñabojama. Ito bajibojarocati soje janacõri, gʉa tija, apóstol mesa mama, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Iti oca tʉocõri, paia ʉjʉ ito yicõri Dios ya wi coderi masa ʉjʉ, no yimena bʉjayijarã ĩna. Iti tʉocõri, “¿No bajiro yirojada ĩja?” yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ĩna bʉjatobiti ñaroca sĩgʉ̃ ejayijʉ ĩna tʉ. Ado bajiro gotiyijʉ ĩ ĩnare: —Tubiara wijʉ mʉa bia cũbojana, Dios ya wijʉ masare riasorã yama ĩna, yiyijʉ ĩ ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ito yija Dios ya wi coderi masa ʉjʉ, ito yicõri ĩ ya moari masa rãca apóstol mesare ãmirã wayijarã ĩna. Bʉto sẽoro yimenati ãmi wayijarã ĩnare. “Masa jãjarã gʉ̃ta reaborãji manire, mani sẽoro yija”, yi tʉo güirã sẽoro yibisijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ĩnare ãmi wacõri, ʉjarã riojo ĩnare jidi rʉ̃gõyijarã ĩna. Ito yija paia ʉjʉ ĩnare ticõri ado bajiro yiyijʉ ĩnare: ");
INSERT INTO myy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Jesús gayere mʉa riasorisere, mʉare rẽobojacʉ gʉa. Ito yibojarocati Jerusalén gãna ñarocõreti masare riaso ucuyija mʉa. Ito bajiri sĩgʉ̃ rʉyabeto masiama mʉa riaso ucurisere. “Jesús ĩ godare gaye ĩnare seti ña”, yiyija mʉa gʉare, yiyijʉ paia ʉjʉ apóstol mesare. ");
INSERT INTO myy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ito ĩ yija tʉocõri, ado bajiro ĩre cʉdiyijarã apóstol mesa. —Diojʉare cʉdisʉorʉja mani, masare mani cʉdiroto riojʉa. Dios rotirisejʉa ñasa masa rotirise rẽtoro, yiyijʉ Pedro ĩ baba mesa rãca. ");
INSERT INTO myy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesús yucʉtẽojʉ mʉa sĩa rotirʉreti, Dios mʉcana tʉdi ĩ catiroca yiñi. Ĩ Dioti ñami, jane mejejʉ mani ñicʉsabatia ĩna rʉ̃cʉbʉogorʉ. ");
INSERT INTO myy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios ũmacʉ̃jʉna ñacõri, Jesure jiñi. Ito bajiri ĩ ya riojocadʉja, rʉ̃cʉbʉorajʉ rujiguĩji Jesús adocãta. Jesús mani Ʉjʉ ñarocʉ, ito yicõri ñeñaro mani yirise waja yi ĩsirocʉre cũñi Dios. Mani Israel gãna ñeñaro mani yirise jidicãtoni, ito yicõri, “Jesús ñeñaro yʉ yirise itire ãcabojoya”, mani yi senitoni cũñi Dios Jesure. ");
INSERT INTO myy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Espíritu Santo sãñagoana gʉa ñajare, ĩ́na sʉoriti Dios ĩ jeyaro yigorere gotia gʉa. No Dios ĩ yiro bajiro cʉdigʉ, Espíritu Santo ĩre sãgʉ̃ yiguĩji Dios, yiyijʉ Pedro ʉjarãre. ");
INSERT INTO myy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pedro ito ĩ yija tʉocõri, bʉto junisiniyijarã ĩna. Ito yicõri Pedro mesare sĩa ãmoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ʉjarã rãca sĩgʉ̃ fariseo gaye tʉoĩagʉ̃ ñayijʉ ĩ. Gamaliel wame cʉtigʉ, judio masa ĩna rotirise riasori masʉ ñayijʉ ĩ. Masa ruje rʉ̃cʉbʉoyijarã ĩre. Gãjerã ʉjarã rãca bʉsirocʉ wʉmʉ rʉ̃gʉ̃cõri, Pedro mesare bucõa rotiyijʉ Gamaliel. ");
INSERT INTO myy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ito yija ado bajiro bʉsiyijʉ ĩ baba mesa ʉjarãre: —Queno tʉoya yʉ ñarã mʉa. Ãna masare mʉa yi ãmorisere, queno tʉoĩaña mʉa. ");
INSERT INTO myy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","¿Teudas ĩ yigorere ãcabojati mʉa? Nocõ rodori mejeti rẽta, “Ñasagʉ ña yʉ”, ĩ yija bero. Iti oca tʉocõri, “Riti bajiroja”, yirona cuatro cientocõ ʉ̃mʉa sʉyabojayijarã Teudas ñabojarʉre. Ito bero yoa bʉsari gãjerã ĩre sĩacõyijarã. Ito bajiri ĩre sʉyabojana ĩna ãmoroti batacoayijarã. Ĩ riasobojare cʉni jedicoayijʉ. ");
INSERT INTO myy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ito bero mʉcana masare ĩna cõĩari rʉmʉri Galilea gagʉ, Judas wame cʉtigʉ ñayijʉ. Ĩre cʉni ĩ bʉsirise tʉocõri masa jãjarã sʉyabojayijarã. Ito bero ĩre sĩacõyijarã gãjerã. Ito yija ĩre sʉyabojana ĩna ãmoroti batacoayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ito bajiri mʉare gotia yʉ. Ʉsirioro yibesa ãnare. Ĩna ãmoro wacõato. Ĩna riasorise gaye masa ye iti ñaja jedicoaro yiroja. ");
INSERT INTO myy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dios ye ĩna riasojama, no yicõri camota masimenaji mʉa. Queno tʉoĩaña mʉa Dios rãca mʉa ñeñame yirona, yiyijʉ Gamaliel, ĩ baba mesa ʉjarãre. Ito bajiro ĩ yija tʉocõri, “Ri ya mʉ”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ito yija Pedro mesare jisõyijarã ĩna mʉcana. Ito yicõri ĩnare baje rotiyijarã ĩna. Ito yicõri Jesús gaye bʉsirere ĩnare rẽoyijarã ĩna. Ito yija ĩnare jidicãyijarã. ");
INSERT INTO myy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Godoti wanʉ budiyijarã Pedro mesa ʉjarã tʉ ñabojana. “Jesús oca gotitoni Dios ĩ manire cũja quenasacõa, quenabeto mani tõbʉjabojarocati”, yiyijarã Pedro mesa. ");
INSERT INTO myy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ʉjarã ĩna Jesús gaye ĩna rẽobojarocati masare riaso jidicãbisijarã ĩna Pedro mesa. Dios ya wijʉ Jesucristo gaye masare riasoyijarã ĩna. Ito yicõri masa ya wirijʉ cʉni riasoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Iti rodoriti Jesure masirã jãjarã bʉsa bʉjʉ wayijarã. Griego oca bʉsirãjʉa, Hebreo oca bʉsirãre bʉsitusʉoyijarã. Griego oca bʉsirãjʉa, ado bajiro bʉsituyijarã Hebreo oca bʉsirãre: “Co rʉmʉ rʉyabeto mʉa bare batobojaja, corocõ batobea mʉa. Mʉa rãca gãna wajeagoana romiare riti jairo ĩsia mʉa. Gʉa rãca gãna wajeagoanareama queno ĩsibea mʉa”, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ito bajiro ĩna gãmeri bʉsituja tʉocõri, Jesure masirã ñarocõreti miojuyijarã apóstol mesa: —Dios oca gʉa riasorise jidicã masibea gʉa. Gʉareama gʉa riasorisejʉa ña, naju batore gaye rẽtoro ñasarise. ");
INSERT INTO myy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ito bajiri jʉa ãmojeno masa cũrʉjarãji mʉa gʉare ejabʉarona. Ado bajirãre ʉ̃mʉare beserʉjarãji mʉa. Queno tʉoĩarã, queno rʉ̃cʉbʉoana, ito yicõri Espíritu Santore queno cʉdirã, mʉa beseja quena. Ito bajirãre gʉare ejabʉarona cũrʉjarãji mʉa. ");
INSERT INTO myy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Gʉama ado bajiro yisotirã yirãji. Diore riti bʉsisotirã yirãji, ito yicõri masare riasorã yirãji gʉama, yiyijarã apóstol mesa ito ñarãre. ");
INSERT INTO myy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ito bajiro apóstol mesa ĩna bʉsija tʉocõri, sĩgʉ̃ bajiro riti tʉoĩa jediyijarã ĩna, Jesure masirã. Ito yicõri sĩgʉ̃re beseyijarã ĩna. “Esteban ĩ ñami Jesure queno tʉorʉ̃nʉcõri Espíritu Santore queno cʉdigʉ”, yi tʉoĩacõri ĩre beseyijarã ĩna. Ito yicõri Esteban bajiro tʉoĩarãre cʉni beseyijarã ĩna. Adocõ ñayijarã ĩna Esteban baba mesa: Felipe, Prócoro, Nicanor, Timón, Parmenas, ito yicõri Antioquía gagʉ Nicolás. Judio masʉ meje ñabojagʉti ĩna queti ocare rʉ̃cʉbʉogʉ ñayijʉ ĩ. Itocõ ñayijarã bare batotoni ĩna cũana. ");
INSERT INTO myy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ito bajiro ĩnare bese tĩocõri, “Ãna ñama iti masa, gʉa cũrona”, yiyijarã Jesure masirã, apóstol mesare. Ito yicõri ĩna joe ãmo moa jeocõri Diore bʉsiyijarã apóstol mesa, quenaro Dios ĩnare ejabʉatoni. ");
INSERT INTO myy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Masa jãjarã bʉsa tʉo wayijarã Dios ocare. Ito yiroca riti Jerusalénjʉ Jesure masirã jãjarã bʉsa bʉjʉ wayijarã. Ito yija Paia masa cʉni jãjarã Jesús ocare queno tʉorʉ̃nʉyijarã. ");
INSERT INTO myy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebanre queno yiyijʉ Dios. Ito yicõri ĩ masirisere Estebanre jidicãyijʉ. Ito bajiri Esteban tiyamani ruje ĩoyijʉ masa tiro riojo. ");
INSERT INTO myy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ito yija co rʉmʉ Esteban rãca gãmeri tʉoĩa bʉsiyijarã coriarã. Minijuara wijʉ wasotirã ñayijarã ĩna. Moa ĩsiri masa ñagoana ya wi wame cʉtiyijʉ iti wi. Moa ĩsiri masa ñagoana co cʉto gãna meje ñayijarã ĩna. Cirene gãna, Alejandría gãna, ito yicõri Cilicia sita gãna, ito yicõri Asia sita gãna ñayijarã ĩna. Ĩna ruje tʉoĩa bʉsiyijarã Esteban rãca. ");
INSERT INTO myy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ito bajibojarocati Estebanjʉama queno bʉsi masiyijʉ, Espíritu Santo queno ĩre ĩ ejabʉajare. Ito bajiri bʉsi rẽtocũ masibisijarã ĩna, ĩre bʉsibojana. ");
INSERT INTO myy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ito bajiri bʉsi masibiticõri, gãjerãre niyeru ĩsiyijarã ĩna, Estebanre ĩna oca menitoni. “Diore cʉni, Moisésre cʉni quenabeto bʉsituami Esteban”, yi rʉo gotiyijarã ĩna gãjerãre, niyeru boca ãmianajʉa. ");
INSERT INTO myy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ĩna rʉore ocare tʉorʉ̃nʉcõri, cʉto gãna Estebanre ruje junisiniyijarã. Iti tʉo junisinicõri bʉcʉrã ito yicõri judio masa rotirise riasori masa cʉni Estebanre ñiayijarã, ʉjʉ tʉ ãmi warona. ");
INSERT INTO myy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Estebanre ʉjʉ tʉ ĩna ãmi ejaroca niyeru boca ãmigoana ado bajiro rʉo gotiyijarã: —Coji meje Esteban Dios ya wire ĩ bʉsituja, ito yicõri Moisés ĩ rotirisere ĩ bʉsituja tʉocʉ gʉa, yiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ito yicõri Esteban ado bajiro ĩ bʉsija tʉocʉ gʉa. “Jesús Nazaret gagʉ Dios ya wire jana batecõgʉ̃ yiguĩji, ito yicõri Moisés ĩ rotire mani ʉsi cʉtibojarise, itire cʉni cõacõgʉ̃ yiguĩji”, ito bajiro Esteban ĩ yija tʉocʉ gʉa, yi rʉo gotiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ito yija ʉjarã tisayijarã Estebanre. Ĩre ĩna tija, rio yori rio ñayijʉ. Dios ñaro gagʉ ángel rio robo bajiro bajiyijʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ito yija paia ʉjʉ ado bajiro seniĩayijʉ Estebanre: —¿Riti ñati mʉ ito yire? yiyijʉ Estebanre. ");
INSERT INTO myy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ito ĩ yija tʉocõri, cʉdiyijʉ Esteban: —Yʉ ñarã tʉoya mʉa. Jane mejejʉ Dios oca goayijʉ mani ñicʉ Abraham ñayorʉre. Mesopotamia ĩ ñarocajʉ rẽtoro masigʉ̃ Dios oca ruyuyijʉ, Haránjʉ ĩ waroto riojʉajʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ado bajiro ruyuyijʉ Dios oca: “Mʉ ya sitare wagoya, ito yicõri mʉ ñarãre cʉni wagoya, gaje sitajʉ yʉ mʉre cũrotojʉ”, yiyijʉ Dios mani ñicʉ ñayorʉre. ");
INSERT INTO myy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ito yija, Dios ito bajiro ĩ yija tʉocõri, Caldea sitare wagoyijʉ ĩ. Ito yicõri Haránjʉ ñagʉ̃ wayijʉ. Itojʉ Haránjʉ ĩna ñaroca mani ñicʉ jacʉ ñayorʉ itojʉ godagoyijʉ ĩre. Ito bero adojʉ mani ya sitajʉ Abraham ĩ ñatoni ĩre cõañi Dios. ");
INSERT INTO myy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Adi sitajʉ ñaña”, yibojagʉti, “Jabeto adi ña mʉ ya sita”, yibisĩ Dios ĩre. Ito bajiri, “Adi ña yʉ ya sita”, yi masibisijʉ Abraham. Cojisiti ado robo, bajiro yiroja yiari goticãñi Dios Abrahamre. “Iti sita mʉre ĩsicʉja yʉ. Mʉ godagoja bero mʉ janerãbatia ya sita ñaro yiroja iti”, yiyijʉ Dios Abrahamre, rĩa macʉ ĩ ñarocajʉ maji. ");
INSERT INTO myy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iti wato gaje gotiyijʉ Dios Abrahamre. “Ija co rʉmʉ adi sitare wagorã yirãji mʉ janerãbatia. Ito bajiri adi sitare wagocõri gãjerã ya sitajʉ ñabojarã yirãji mʉ janerãbatia. Gãjerãre moa ĩsiri masa ñarã yirãji ĩna. Gãjerã quenabeto ĩna tõbʉjaroca yirã yirãji. Yoari sĩgʉ̃ masʉcõ masacõ rodori itire tʉoĩarã yirãji ĩna. ");
INSERT INTO myy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ito bajibojarocati mʉ janerãbatiare ñeñaro yirãre quenabeto ĩna tõbʉjaroca yigʉ yigʉja yʉ cʉni. Iti cʉtore wagocõri adi sitajʉ tʉdi ejarã yirãji mʉcana. Adojʉ ñacõri yʉre rʉ̃cʉbʉorã yirãji”, yiyijʉ Dios, mani ñicʉ Abraham ñayorʉre. ");
INSERT INTO myy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ado bajiro rotiyijʉ Dios Abrahamre: “Yʉ mʉre gotire mʉ tʉo masija, ‘Dios yagʉ ñagʉ̃ yiguĩji ãni’, yirocʉ mʉ macʉ ñarocʉre pĩ gaja wiro tagʉ yigʉja mʉ”, yiyijʉ Dios Abrahamre. Ito bajiri ĩ macʉ Isaac ĩ rujearoca ʉdia ãmojeno rʉmʉri bero ĩre wiro tayijʉ. Ito bajiri Isaac, Jacobre ĩ macʉ cʉtija wiro tayijʉ. Jacob cʉni ito bajiroti yiyijʉ ĩ rĩare mani ñicʉsabatia ñayoanare. Jʉa dʉjamocõ jʉa gʉbojeno ñarã ñayijarã ĩna. Ado bajiro yiñi mani ñicʉsabatia ñayoana, yiyijʉ Esteban ʉjarãre. ");
INSERT INTO myy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Mani ñicʉsabatia ñayoana, Jacob rĩa rãca José wame cʉtigʉ ñayijʉ. Josére ruje ti tudiyijarã ĩ rĩjorʉ mesa. Ito bajiri ĩna ocabaji ñabojarʉreti gãjerã masare ĩsicõri waja seniyijarã ĩna. Ito bero ĩre bʉjacõri, Egiptojʉ ĩre ãmi wayijarã ĩna. Ito ĩna yibojarocati Dios queno tirʉ̃nʉyijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","José quenabeto ĩ tõbʉjabojarocati Dios queno ejabʉayijʉ ĩre. Egipto gagʉ ʉjʉ, Faraón wame cʉtigʉ Josére jiyijʉ. Ʉjʉ Faraón ĩ tiro riojo queno tʉoĩare gaye jidicãyijʉ Dios Josére. Faraón Josére ĩ baba bʉjatoni queno ejabʉayijʉ Dios. Ito bajiri Faraón ado bajiro gotiyijʉ Josére: “Yʉre ejabʉari masʉ ñasagʉ ñagʉ̃ ya mʉ. Egipto gãna ñarocõreti mʉ rotire ãmoa yʉ. Ito yicõri yʉ ya wi gãnare cʉni mʉ rotire ãmoa yʉ”, yiyijʉ Faraón Josére. ");
INSERT INTO myy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Iti rodoriti Egipto sitajʉ bare jedicoayijʉ. Ito yicõri Canaán sita cʉni jedicoayijʉ. Masa ruje ñio jogayijarã. Ito yicõri quenabeto tõbʉjayijarã ĩna. Mani ñicʉsabatia no õno bare bʉja masibisĩ ĩna. ");
INSERT INTO myy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ito bajiri mani ñicʉ ñayorʉ Jacob, “Egiptojʉ bare seore ñayijʉ”, yija tʉocõri, ĩ rĩare cõayijʉ ĩna bare waja yirã watoni. ");
INSERT INTO myy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Egiptojʉ bare ãmirã ejayijarã ĩna maji. Bare iti jedija itojʉti mʉcana ãmirã wayijarã ĩna. Mʉcana tʉdi ĩna ejaroca ado bajiro gotiyijʉ José ĩnare: “Yʉre ti masibea mʉa. Mʉa ocabajiti ña yʉ”, yiyijʉ José ĩnare. Ito bajiro José ĩ yija tʉocõri, gãjerã ĩ ñarã ñare gayere tʉo bʉjayijʉ Faraón. ");
INSERT INTO myy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ito yija José ĩ ñarã ñarocõreti ito yicõri ĩ jacʉre cʉni ji rotiyijʉ Egiptojʉ ĩna ñatoni. Ʉdiarã masacõ gãji ye co dʉja gʉbocõ ñarã ñayijarã ĩna, ĩ ñarã. ");
INSERT INTO myy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ito bajiro bajijare Egiptojʉ ñagʉ̃ wayijʉ Jacob. Egiptojʉ yoari ñacõri itojʉ godacoayijʉ Jacob. Ito yicõri ĩ rĩa ñana, mani ñicʉsabatia ñayoana godañi itojʉti. ");
INSERT INTO myy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Egiptojʉ ĩna cõbojarocati ito gãna Siquemjʉ yujerã wayijarã. Siquemjʉ ãmi ejacõri, mani ñicʉ Abraham ñayorʉ, Hamor rĩare masari cuma goje ĩ gãmecarajʉre yujeyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Mani ñicʉsabatia ñayoana, Egipto sitajʉ jãjarã masa bʉjʉri cʉti ñayijarã. Ito ĩna baji ñaroca riti jabeto rʉyayijʉ ĩnare Dios Canaán wame cʉtiri sita ĩsiroto, “Mʉ janerãbatiare sita ĩsigʉ̃ yigʉja yʉ”, yi Abraham ñayorʉre Dios ĩ goticãdo bajiroti. ");
INSERT INTO myy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Iti rodoriti gãji ʉjʉ Egiptojʉ rotisʉoyijʉ. José mesa mani ñicʉsabatia ñayoanare rʉ̃cʉbʉogʉ meje ñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ĩ ʉjʉti mani ñicʉsabatia ñayoanare rʉoñi. Ito yicõri quenabeto yiyijʉ. Mame joearã rĩacare cõa rotiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Iti rodoti rujeayijʉ Moisés cʉni. Dios ĩ tija quenagʉ̃ ñayijʉ ĩ macʉacã. Iti sita ʉjʉ ĩ rotire masibojagoti Moisés jaco ʉdiarã ũmacañicõti rʉco ñayijo ĩre. ");
INSERT INTO myy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Macʉacãre yeyo masibiti wacoti, iso macʉre maibojagoti, ʉjʉ ĩ rotiado bajiroti ĩre cõabojayijo iso. Ito iso yija bero ʉjʉ Egipto gagʉ maco ĩre ti bʉjacõri, ĩre masoyijo iso macʉ robo bajiro. ");
INSERT INTO myy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ito bajiri ʉjʉ maco rãca ñagʉ̃ riti Egipto gãna ĩna masirisere queno riasotiyijʉ ĩ, Moisés. Ĩ bʉsija, tʉo masire rãca bʉsiyijʉ ĩ. Ito yicõri ñasarisere moa quenoyijʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Moisés jʉ̃arã masacõ rodori tʉjagʉ, “Ado bajiro bajicʉja yʉ”, yi tʉoĩayijʉ ĩ. “Yʉ ñarãre tigʉ wacʉja yʉ, no bajiro ĩna ñaja”, yi tʉoĩayijʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ĩna tʉ ĩ ejaroca, mani yagʉre, Egipto gagʉ ĩ bajeja tiyijʉ, Moisés ñayorʉ. Ito bajija ticõri, ĩre gãme ĩsiyijʉ. Ito yicõri ĩre sĩa ruyuriocõyijʉ Moisésjʉa. ");
INSERT INTO myy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“Egipto sitajʉ gʉare bucõa ejabʉarocʉ cũyijari Dios, yʉre yi masirãji yʉ ñarã”, yi tʉoĩabojayijʉ Moisés. Ito bajiro ĩ tʉoĩabojarocati, ĩre bajiro meje tʉoĩayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Gaje rʉmʉ mʉcana mani ñarãre ti quenogʉ̃ wayijʉ Moisés. Ito ejacõri ĩna comasiti ĩna gãmeri jaroca ejayijʉ ĩ. Ĩnare oca queno ãmoyijʉ ĩ. Ito bajiri ado bajiro ĩnare bʉsibojayijʉ ĩ maji: “Adojʉa tʉoya. ¿No yija comasi ñabojarãti gãmeri jati mʉa?” yiyijʉ Moisés ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sĩgʉ̃ ĩ babare jagʉ, ito bajiro Moisés ĩ bʉsija tʉocõri, junisinigʉ̃ Moisésre tucõayijʉ. “¿Ñimʉ gʉa ʉjʉ ñarocʉre cũcati mʉre? ");
INSERT INTO myy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ñamica mʉ Egipto gagʉre mʉ sĩado bajiro yʉre sĩarocʉ yati mʉ?” yiyijʉ ĩ Moisésre. ");
INSERT INTO myy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Iti tʉo ʉcacõri, güigʉ rudi wayijʉ Moisés. “Yʉ sĩare gaye Egipto gãnare gotirã yirãji”, yi tʉoĩayijʉ Moisés. Ito bajiri Madián wame cʉtiri sitajʉ rudi wayijʉ ĩ, gaje masa ya sitajʉ. Itojʉ manojo bʉjacõri jʉ̃arã rĩa cʉtiyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Jʉ̃arã masacõ rodori bero, co rʉmʉ wa ucugʉ wayijʉ Moisés. Sinaí wame cʉtiricʉ gʉ̃tagʉ̃ jʉdojʉ, yucʉ manojʉ wa ucugʉ wayijʉ Moisés. Ito yija ĩ tʉ rujatutu jea ʉ̃jʉ rʉ̃gõri tutu robo bajiro wato Dios ñaro gagʉ ángel goayijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Itire ticõri ʉcayijʉ Moisés. Queno tisarocʉ ito tʉ ĩ waroca Dios oca ruyuyijʉ: ");
INSERT INTO myy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yʉ ña Dios. Mʉ ñicʉsabatia Abraham, Isaac, Jacob cʉni yʉre rʉ̃cʉbʉocã”, yiyijʉ Dios Moisésre. Iti oca tʉocõri güigʉ nʉrʉoyijʉ Moisés. Ito bajiri iti tuture ti queotu ãmobisijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ito yija mʉcana tʉdi bʉsi remoyijʉ Dios: “Ado jacajʉti ña yʉ. Mʉ tʉti ña yʉ. Ito bajiri mʉ ya gʉboco ruacõña mʉ. Ito bajiro yicõri yʉre rʉ̃cʉbʉogʉ yigʉja mʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yʉ ya masa Egiptojʉ quenabeto ĩna tõbʉjaja ticʉ yʉ. Ito yicõri ĩna awasãja tʉocʉ yʉ. Ito bajiri Egipto gãnare ĩna camotaditoni ĩnare ejabʉagʉ wadibʉ yʉ. Wasa Egiptojʉ, yʉ mʉre tʉdi wa rotia yʉ”, yiñi Dios Moisésre gotigʉ, yiyijʉ Esteban ʉjarãre. ");
INSERT INTO myy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ĩ Moisésti ñami, mani ñicʉsabatia ĩna tʉo ãmobitirʉ. “¿Ñimʉ gʉa ʉjʉ ñarocʉre cũcati mʉre?” yiyijarã mani ñicʉsabatia Moisésre. Ito bajibojarocati Dioti ĩre jʉdacõañi ĩna masa tʉjʉ ĩna ʉjʉ robo bajiro ñarocʉre. Mani ñicʉsabatia Egiptojʉre ĩna budigotoni ejabʉarocʉre cũñi Dios Moisésre. Ángelna sʉoriti ito bajiro gotiyijʉ Dios Moisésre, rujatutujʉna ĩre goaĩocõri. ");
INSERT INTO myy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisésti mani ñicʉsabatia ñayoanare Egipto sitajʉ ĩnare ũmatã wayijʉ ĩ. Egiptojʉ tiyamani yi ĩoyijʉ Moisés, ito yicõri riaca jajosa Ide Sũarise wame cʉtirisa tʉnimajʉ cʉni ĩoyijʉ ĩ. Ito bajiri yucʉ manojʉ ñagʉ̃ cʉni, jʉ̃arã masacõ rodori ñagʉ̃ tiyamani ĩoyijʉ Moisés. ");
INSERT INTO myy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisésti ñami mani ñicʉsabatia ñayoanare gotirʉ: “Mani Jacʉ Dios yʉre ĩ cõado bajiroti, gãji ĩ oca gotirocʉre cõagʉ̃ yiguĩji. Dios ĩ cõarocʉ mani comasiti ñagʉ̃ yiguĩji. Yiro bajiroti cʉdiba mʉa ĩre”, yiyijʉ Moisés mani ñicʉsabatia ñayoanare. ");
INSERT INTO myy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ĩ Moisésti mani ñarã rãca gʉ̃tagʉ̃ jʉdojʉ Sinaí wame cʉtiricʉ jʉdojʉ minijuañi yucʉ manojʉ. Ito yija ĩ sĩgʉ̃ti gʉ̃tagʉ̃jʉ mʉja wayijʉ. Itojʉ ĩ mʉja ejaroca Dios ñaro gagʉ, ángel ĩre bʉsiyijʉ. Ito yicõri Moisés mani ñicʉsabatia ñayoanare oca jedibitirotire gotiyijʉ. Ito bajiri ĩ gotiado bajiroti ejayija manire cʉni. ");
INSERT INTO myy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Mani ñicʉsabatia ñayoana, Moisésre ñaro bajiroti cʉdibitiyoñi. Ĩre tujamena Egiptojʉ tʉdi wa ãmoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ito yicõri Moisés gʉ̃tagʉ̃ joejʉ ĩ ñaroca riti, ĩ rĩjorʉ Aarón wame cʉtigʉre ado bajiro gotiyijarã ĩna: “¿Nojʉ ñati mʉ ocabaji? Egipto sitajʉ gʉa ñaroca gʉare bubojacacʉre mʉ ocabajire masibea gʉa ĩja. Ito bajiri gʉare gʉa ʉjʉ ñaroti, gʉa rʉ̃cʉbʉoroti gʉare meni ĩsiña. Iti gʉa rʉcoja, gʉa wa ãmoro riojo ĩo waroja iti”, yiyijarã ĩna Aarón ñayorʉre. ");
INSERT INTO myy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ito yija wecʉ macʉacã robo bajigʉ meni rujeoyijarã ĩna. Ito yicõri waibʉcʉrã sĩa ĩsiyijarã ĩna, ĩna meni rujeorʉre yiari. Ito yicõri basa meni jeobʉayijarã ĩna, ĩna menirʉ wecʉ macʉ bajigʉre rʉ̃cʉbʉorã. ");
INSERT INTO myy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ito bajiro ĩna yija ticõri, ĩnare jidicãcõyijʉ Dios. Ĩna ãmoro robo ĩna yi ãmojare ĩnare camotabisijʉ Dios. Ito bajiri ñocõa, ũmacañi, ñami gagʉre cʉni rʉ̃cʉbʉoyijarã ĩna. Diore goti ĩsiri masʉ Amós ñayorʉ ĩ ucare ado bajiro gotia: Israel sita gãna tʉoya mʉa. Mʉa waibʉcʉrã, mʉa sĩare yʉre rʉ̃cʉbʉorã meje sĩacʉ mʉa, jʉ̃arã masacõ rodori yucʉ manojʉ mʉa ñare. ");
INSERT INTO myy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yʉre rʉ̃cʉbʉomenati mʉa ya ãmonati mʉa meni rujeorʉreti rʉ̃cʉbʉocʉ mʉa. Jaibiti wiacã menicõri, iti wi totijʉ Moloc wame cʉtigʉ sãcõri gajasoticʉ mʉa. Ito yicõri ñocõa robo bajigʉ mʉa meni rujeorʉre, Refán wame cʉtigʉre rʉ̃cʉbʉocʉ mʉa. “Ãna ñama mani rʉ̃cʉbʉorã ito yicõri mani ʉjarã”, yibojacʉ mʉa. “Ito bajiri Babilonia sõjʉajʉ mʉare cõagʉ̃ ya yʉ”, yiyijʉ Dios ĩnare. Ado bajiro bajiatoja iti, Dios ĩ yirere ucañi Amós ñayorʉ, yiyijʉ Esteban ʉjarãre gotigʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mʉcana tʉdi bʉsi remoyijʉ Esteban ʉjarãre: —Mani ñicʉsabatia yucʉ manojʉ ĩna waja Dios ya wire menirotire saya webʉtirise ãmi wayijarã ĩna. Iti wijʉ Dios ĩ rotirise ucaraga gʉ̃tagãri seoyijarã ĩna. Moisésna sʉoriti wiri rujeayijʉ iti. Moisés ĩ cãirojʉ Dios ĩ gotiado bajiroti, iti wire moa rujeoyijarã ĩna. No ĩna warojʉ iti wire ãmi wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Moisés ĩ godaja bero Josué wame cʉtigʉ ĩre wasoayijʉ. Iti wire ãmicõri Canaán wame cʉtiri sitajʉ wayijarã ĩna. Canaán wame cʉtiri sitajʉ gaje masa ñayijarã. Ito bajiri Dios ejabʉayijʉ mani ñicʉsabatiare. Iti cʉto ñanare bucõa jeocõyijʉ Dios. Mani ñicʉ ñayorʉ David, ĩ catija ñayijʉ iti wi maji, saya webʉtirisena ĩna menira wi. ");
INSERT INTO myy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Queno yiyijʉ Dios, mani ñicʉsabatia ʉjʉ David ñayorʉre. Ĩre bʉto wanʉyijʉ Dios. Ito bajiri ado bajiro yiyijʉ David ñayorʉ Diore: “Yʉ ñicʉ Jacob ñayorʉ queno mʉre rʉ̃cʉbʉoñi. Yʉ cʉni queno mʉre rʉ̃cʉbʉoa. Ito bajiri wi queno bʉti quenari wi meni ĩsi ãmoa yʉ. Yʉre meni rotiya mʉ”, yiyijʉ David, Diore bʉsigʉ. Ito ĩ yibojarocati wi meni rotibisijʉ Dios ĩre. ");
INSERT INTO myy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","“David ĩ macʉ Salomónjʉa Diore wi meni ĩsiyijʉ ĩja”, yiyijʉ Esteban, ʉjarãre gotigʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ito bajibojarocati rẽtoro ñasagʉ Dios, masa ĩna menira wi meje ñaguĩji Dios. Jane mejejʉ sĩgʉ̃ Diore goti ĩsiri masʉ, Dios oca tʉocõri ado bajiro ucañi: ");
INSERT INTO myy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ũmacʉ̃jʉ ñabojagʉti macãrʉcʉ̃ro jeyaro ʉjʉ ña yʉ. Wi mʉa meni ĩsibojaja ña masibicʉja yʉ. Wi ñagʉ̃ meje ña yʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yʉti ña jeyaro rujeocacʉ. Ito bajiro gotiñi Dios, yiyijʉ Esteban ʉjarãre gotigʉ. ");
INSERT INTO myy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Dios oca queno cʉdibea mʉa. Dios oca tʉo ãmobea mʉa. Jesure masimena robo bajiro ʉsi cʉtia mʉa. Mani ñicʉsabatia bajiroti Espíritu Santore cʉdi ãmobea mʉa cʉni. ");
INSERT INTO myy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mani ñicʉsabatia ñayoana queno yibisĩ Diore goti ĩsiri masare. Ito yicõri Cristo ñeñaro yibicʉ, ĩ ejaroti gayere gotirãre sĩayoñi mani ñicʉsabatia. Ito yija canʉ bʉsati ĩ ejaroca ĩre ĩna sĩatoni gãjerãre ĩsiyija mʉa. ");
INSERT INTO myy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dios ĩ rotirise queno cʉdibea mʉa, ángel mesa queno cʉdire gaye mʉare ĩna jidicãbojarocati, yiyijʉ Esteban ʉjarãre. ");
INSERT INTO myy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iti tʉocõri, yaire bajiro guji ĩoyijarã ĩna, Estebanre bʉto junisinirã ñari. ");
INSERT INTO myy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ito bajiro ĩna yibojarocati Espíritu Santo ñayijʉ Esteban rãca. Esteban ĩ ti mʉoja Dios ĩ yorise ruyuyijʉ. Dios ya riojocadʉja rʉ̃cʉbʉorajʉ, Jesús ĩ rʉ̃gõja tiyijʉ Esteban. ");
INSERT INTO myy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ito yija ado bajiro bʉsiyijʉ Esteban ʉjarãre: —Tite mʉa cʉni. Macãrʉcʉ̃ro soje janacoajʉ. Masa Rĩjorʉ, Dios ya riojocadʉja ñami, yiyijʉ Esteban. ");
INSERT INTO myy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mʉcana tʉdi ĩ bʉsija, tʉo ãmomena ĩna ya gãmo gojeri biayijarã ĩna. Ĩna ñarocõti bʉto awasãcõri ĩre quedi wãyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ito yicõri cʉto sõjʉajʉ ãmi wacõri, ĩre gʉ̃ta reasʉoyijarã ĩna. Ito yicõri ĩna ya yutabujuri ruacũcõri, Saulo wame cʉtigʉ ĩ tirʉ̃nʉroca riti, Estebanre reayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ĩna gʉ̃ta rearotototi, Jesure ado bajiro bʉsiyijʉ Esteban: —Jesús, yʉ Ʉjʉ yʉ ya ʉsire boca ãmiña mʉ, yiyijʉ Esteban. ");
INSERT INTO myy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ito bero rijomunigãna ñini rũjũcõri, bʉto awasãyijʉ Esteban: —Yʉre ĩna ñeñaro yirisere waja senibesa ĩnare, yiyijʉ Esteban Jesure. Ito bajiro bʉsi tĩocõri ʉsi jedicoayijʉ Esteban ĩja. ");
INSERT INTO myy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Saulo ĩna ya yutabujuri coderʉ, “queno Estebanre sĩajaro”, yi tʉoĩayijʉ ĩ cʉni. Coriarã judio masa Diore queno rʉ̃cʉbʉorã Estebanre yujeyijarã ĩna. Ito yicõri ruje otiyijarã ĩna Estebanre. Iti rʉmʉriti Jesure masirãre Jerusalénjʉ ñeñaro yisʉoyijarã iti cʉto gãna. Gãjerã rẽto bʉsaro ñeñaro yiyijʉ Saulo, Jesure masirãre. Co wi rʉyabeto ĩnare ãma wayijʉ ĩ. Ĩ bʉjaro bajiroti ʉ̃mʉa, romiare cʉni ĩnare ñia ãmi budi wacõri tubiayijʉ ĩ. Ito bajiri ñarocõti Jesure masirã apóstol mesa rãca ñabojarã rudi wayijarã Judea sitajʉ, ito yicõri Samaria sitajʉ cʉni. Apóstol mesama Jerusalénti ñacõayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalén gãna rudi wana ñabojarãti gajerojʉ ejacõri Jesús oca quenarise gaye riasoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Sĩgʉ̃ Jerusalén gagʉ rudi warʉ Felipe wame cʉtiyijʉ. Ĩ Samaria sita cʉtojʉ wayijʉ. Ito ejacõri: “Jesús ñami Cristo Dios ĩ cõarʉ”, yiyijʉ Felipe masare. ");
INSERT INTO myy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Masa jãjarã minijuayijarã Felipe tʉjʉ ĩre tʉorona. Ito yicõri, tiyamani ĩ ĩoja tiyijarã ĩna. Ito bajiri ĩ bʉsirisere queno tʉoyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Jãjarãre ĩna ya ʉsijʉ rʉ̃mʉ́a sãñarãre bucõayijʉ Felipe. Ĩ ito yija masa ʉsijʉ rʉ̃mʉ́a sãñabojarã awasã budiyijarã ĩna. Jãjarã ruduanare yisioyijʉ ĩ. Ito yicõri rujayuriri warãre cʉni quenoyijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ito bajiri iti cʉto gãna masa queno wanʉ quena ñayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Iti cʉtojʉ sĩgʉ̃ Simón wame cʉtigʉ ñayijʉ. Co rodo meje ĩ masirise ĩoyijʉ ĩ cumu ñari. Tiyamani ĩ ĩojare ti ʉcayijarã iti cʉto gãna. “Yʉ ña ʉ̃mʉgʉ̃ ñasagʉ”, yiyijʉ ĩ ĩnare. Masa sĩgʉ̃ rʉyabeto ĩre tʉorʉ̃nʉyijarã. Bʉcʉrã, rĩaca cʉni queno tʉorʉ̃nʉyijarã ĩre: —Dios robo bajiroti masiami ãni. Dios ĩ cõarʉ ñaguĩji ãni, yiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ito ĩna yibojarocati Felipeama Jesucristo oca quenarise gaye masare gotiyijʉ. “Masa jeyaro Ʉjʉ ñami Dios”, yire oca masare gotiyijʉ Felipe. Ito bajiro ĩ gotija tʉorʉ̃nʉcõri, idé gu rotiyijarã ʉ̃mʉa, romia cʉni. ");
INSERT INTO myy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón cʉni, cumu ñabojagʉti, Jesús oca quenarise gayere tʉorʉ̃nʉyijʉ. Ito yicõri idé gu rotiyijʉ ĩ cʉni. Ito yija Felipe rãca baba cʉtisʉoyijʉ ĩ. Ito yicõri Felipe ĩ tiyamani ĩ ĩojare ti ʉcayijʉ Simón. ");
INSERT INTO myy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apóstol mesa Jerusalénjʉ ñacõri, “Samaria sita gãna jãjarã Dios oca tʉorʉ̃nʉyijarã ĩna”, yire gaye tʉoyijarã ĩna. Ito bajiri Samariajʉ jʉ̃arã cõayijarã ĩna, Pedro ito yicõri Juanre. ");
INSERT INTO myy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Samariajʉ ejacõri Diore bʉsiyijarã ĩna, mame Jesure boca ãmirãre Espíritu Santo ĩ quedi sãjatoni. ");
INSERT INTO myy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Idé guana ñabojarocati ĩna ya ʉsijʉ Espíritu Santo mañijʉ maji. Ito bajiri, ĩnare Espíritu Santo queo sãjaro yirona, Diore bʉsiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ito yicõri mame Jesure masirãre Pedro mesa ĩna ya ãmona moa jeoyijarã Diore bʉsirã. Ĩna ito yirocajʉti Espíritu Santo quedi sãjayijʉ ĩnare. ");
INSERT INTO myy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pedro mesa Jesure masirãre ĩna ya ãmo moa jeorocati Espíritu Santo quedi sãjaja tiyijʉ Simón, cumu ñagorʉ. Ito bajiri iti ticõri ĩnare niyeru ĩsi ãmogʉ̃, ");
INSERT INTO myy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ado bajiro yiyijʉ Simón: —Ĩmo. Gãjerãre yʉ moa jeoroca Espíritu Santo sãjare ãmoa yʉ cʉni, yiyijʉ Simón, Pedro mesare. ");
INSERT INTO myy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Pedro ĩre: —Dios ĩ waja mano ĩsirisere, waja gãmere ñaroja, ¿yire masiati mʉ? Ito bajiro mʉ tʉoĩare waja, mʉ ya niyeru rãca godacoagʉ yigʉja mʉ, yiyijʉ Pedro Simónre. ");
INSERT INTO myy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Dios ĩ tiro riojo queno tʉoĩagʉ̃ meje ña mʉ. Ito bajiri gʉa rãca mʉ moariseoni meje ña iti. ");
INSERT INTO myy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Mʉ tʉoĩarisere ti masia yʉ. Bʉto ʉoa mʉ, yʉ tija. Ñeñaro yi jaigʉ ña mʉ. Ito bajiri mʉ ñeñaro yirisere jidicã masibea mʉ. Ñeñaro mʉ tʉoĩarisere, itocõ jidicãña mʉ. Ito yicõri mani Ʉjʉre seniña mʉ ñeñaro tʉoĩarisere ĩ ãcabojotoni, yiyijʉ Pedro Simónre. ");
INSERT INTO myy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ito ĩ yija tʉocõri, ado bajiro cʉdiyijʉ Simón: —Mani Ʉjʉre bʉsiya mʉa yʉre yiari. “Ito bajiro bajigʉ yigʉja mʉ”, mʉ yirise yʉre rẽtare ãmobea yʉ, yiyijʉ Simón, Pedro mesare. ");
INSERT INTO myy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ito yija bero Pedro mesa Jesure ĩna tigore gaye iti cʉto gãnare gotiyijarã. Ito yicõri Jesús oca quenarise riasoyijarã ĩna. Masare riaso tĩocõri, “Jerusalénjʉ tʉdi wana mani”, yi tʉoĩayijarã ĩna. Tʉdi warã, Samaria sita cʉtori gãnare Jesús oca quenarise riaso rẽta wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Felipereama ado bajiro gotiyijʉ Dios ñaro gagʉ ángel: —Jerusalénjʉ wasa. Ito ejacõri Gaza wame cʉtiri cʉto ña wari ma roja waja mʉ. Yucʉ mano rẽtari ma ña iti ma, yiyijʉ Felipere. ");
INSERT INTO myy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ito bajiri Felipe josari mejeti wacoayijʉ, ángel ĩ gotiado bajiroti. Ma wacʉjʉ Etiopía gago ʉjore ejabʉari masʉ ñasagʉre ti bʉjayijʉ Felipe. Ĩ ʉjo ya niyeru coderi masʉ ñayijʉ ĩ, Etiopía gagʉ. Iti ñayijʉ ĩ moarise. Jerusalénjʉ Diore rʉ̃cʉbʉo tĩocõri tʉdi wacʉ ito tʉjayijʉ ĩ, Etiopía gagʉ. ");
INSERT INTO myy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Cabaru ĩ tʉ̃a waroca ĩ ya tunuricorojʉ Dios ocare ti sãñayijʉ ĩ. Diore goti ĩsiri masʉ, Isaías ñayorʉ ĩ ucara tutire ti sãñayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ito yija ĩre ti bʉjaroca ado bajiro gotiyijʉ Espíritu Santo Felipere: —Ĩre sʉacõri, mʉa corocõ wasa mʉa, yiyijʉ Espíritu Santo Felipere. ");
INSERT INTO myy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ito bajiri Felipe ũmaquedi wacõri Etiopía gagʉre sʉayijʉ. Sʉacõri, Isaías Diore goti ĩsiri masʉ ĩ ucare ĩ ti bʉsija, tʉoyijʉ Felipe: —¿Ito mʉ ti bʉsirisere tʉo masiati mʉ? yiyijʉ Felipe Etiopía gagʉre. ");
INSERT INTO myy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—Sĩgʉ̃ yʉre gotigʉ manija, ¿no bajiro tʉo masigʉ̃jada yʉ? yiyijʉ ĩ Felipere. Ito yija, yʉ tʉ mʉja wadicõri, ado rujigʉ waya mʉ, yiyijʉ Etiopía gagʉ. ");
INSERT INTO myy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Dios oca ĩ tirijʉ ado bajiro bajiyijʉ: Ovejare sĩarona ĩna ãmi waro bajiro ãmi warãji ĩna sĩgʉ̃ ʉ̃mʉgʉ̃re. Ovejare joa suaroca ĩ oca mano robo bajiro oca maquĩji ĩ cʉni ĩre ĩna ja ajebojarocati. ");
INSERT INTO myy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Masa jãjarã riojo quenabeto bojorise tõbʉjaguĩji ĩ. Ñeñaro ĩ yibitibojarocati ĩre yiari bʉsi ĩsirocʉ maquĩji. Ĩ ñarã ĩnamasiti ĩre ĩna sĩaja, “Ĩna ñama ĩ janerãbatia”, yi masia manoja, yi wãñayijʉ Etiopía gagʉ ĩ tira tuti. ");
INSERT INTO myy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ito yija ĩ tʉ mʉja sãjacõri rujiyijʉ Felipe. —Isaías ĩ ucare gaye yʉre ti gotiya mʉ. ¿Ĩmasi gayeti ucayijari ĩ? ¿Gãji gayere tʉoĩagʉ̃ ito bajiro ucayijarite ĩ? yiyijʉ Etiopía gagʉ Felipere. ");
INSERT INTO myy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ito yija iti tuti Isaías ĩ ucare gayere ĩre ti gotiyijʉ Felipe. “Jesús oca quenarise ña”, yirocʉ Jesús ocare goti jeoyijʉ Felipe Etiopía gagʉre. ");
INSERT INTO myy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Warã riti ma tʉ itajura ñarojʉ ejayijarã ĩna: —Tite, ado ña ide. ¿Adocãta yʉ mʉre idé gu rotija quena ñati? yiyijʉ Etiopía gagʉ Felipere. ");
INSERT INTO myy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Dios Macʉ ñami Jesús, mʉ yi tʉoĩaja mʉre idé gucʉja yʉ, yiyijʉ Felipe ĩre. —Dios Macʉti ñami Jesucristo, ya yʉ, yiyijʉ Etiopía gagʉ. ");
INSERT INTO myy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ito yija tunuricoro tuja quea roticõri, itajurajʉ roja rʉ̃gʉ̃yijarã ĩna. Ito yicõri idé guyijʉ Felipe Etiopía gagʉre. ");
INSERT INTO myy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Itajurajʉ ĩna maja rʉ̃gʉ̃ waroca, ñajasaroti Espíritu Santo ãmicoayijʉ Felipere. Ito bajiri jʉaji tibisijʉ Etiopía gagʉ ĩre. Ito bajibojarocati queno wanʉ quena wayijʉ Etiopía gagʉ ĩ warojʉ. ");
INSERT INTO myy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipere ãmicõri Azoto wame cʉtiri cʉtojʉ ĩ goaroca yiyijʉ Espíritu Santo. “¿Azotojʉ ñati yʉ?” yi tʉoĩayijʉ Felipe. Azotojʉ ñacõri wayijʉ ĩ. Co cʉto rʉyabeto Jesús oca quenarise masare riaso ucuyijʉ ĩ. Sʉsari ĩja Cesarea wame cʉtiri cʉtojʉ ejayijʉ Felipe. ");
INSERT INTO myy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jesure masirãre sĩa ãmogʉ̃jʉ ĩnare bʉto junisini tiyijʉ Saulo. Ito bajiri paia ʉjʉre bʉsigʉ wayijʉ ĩ. ");
INSERT INTO myy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damasco cʉtojʉ minijuara wirijʉ Jesure masirãre ãmagʉ̃ sãjarocʉ papera seniyijʉ Saulo paia ʉjʉre: “Ĩnare yʉ ti bʉjaro bajiroti ʉ̃mʉa, romiare cʉni ĩnare Jerusalénjʉ tubiarocʉ ãmi wacʉja yʉ”, yiyijʉ Saulo, ʉjʉre. ");
INSERT INTO myy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ma ĩ waroca riti Damasco cʉtojʉ ĩ ejagʉ wagʉ yiroca, ñajasaroti macãrʉcʉ̃ro gaye busurise sĩatiyijʉ ĩre. ");
INSERT INTO myy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ĩre ito bajiro sĩatirocati jacajʉ quedi queacoayijʉ Saulo. Ito yicõri ado bajiro oca ruyuyijʉ ĩre: —Saulo, Saulo, ¿no yija yʉre ñeñaro yi ãmoati mʉ? yi oca ruyuyijʉ ũmacʉ̃jʉ. ");
INSERT INTO myy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Iti oca tʉocõri ado bajiro seniĩayijʉ Saulo: —¿Nojʉ gagʉ yʉre bʉsiati mʉ? yiyijʉ Saulo. —Yʉti ña Jesús, yʉre ñeñaro yirocʉ mʉ sʉyagʉti. Ito mʉ yirise mʉmasi ñeña bajigʉti ya mʉ. Adocãta mʉmasiti jota mʉ jajuja, juniroja mʉre. Iti gaye bajiro ya mʉ yʉre ñeñaro mʉ yi ãmoja, yiyijʉ Jesús ĩre. ");
INSERT INTO myy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ito yija Saulo ĩ ya rujʉ nʉrʉogʉ̃ti: —¿Ñe yʉ yire ãmoati mʉ? yiyijʉ ĩ Jesure. —Wasa Damascojʉ. Ito mʉ ejaroca sĩgʉ̃ mʉre: “Adi ña mʉ moaroti”, yigʉ yiguĩji mʉre, yiyijʉ Jesús Saulore. ");
INSERT INTO myy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo rãca wana oca iti ruyubojarocati rujʉre tibiticõri mano ʉcayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ito bero yoa bʉsari wʉmʉ rʉ̃gʉ̃cõri tirocʉ yibojayijʉ Saulo. Itocõti cajea macʉ ñacoayijʉ ĩ. Ito bajigʉre ĩ baba mesa Damascojʉ ĩre tʉ̃a wayijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Damascojʉ ejacõri ʉdia rʉmʉcõ ñayijʉ Saulo cajea tire meje, bare meje, ito yicõri idire mejeti. ");
INSERT INTO myy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco wame cʉtiri cʉtojʉ Jesure masigʉ̃ sĩgʉ̃ ñayijʉ, Ananías wame cʉtigʉ. Ĩ cãirojʉ ejacõri: —¿Ñati Ananías mʉ? yiyijʉ Jesús ĩre. —Ado ña yʉ, yiyijʉ Ananías. ");
INSERT INTO myy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ito ĩ yija tʉocõri, ado bajiro yiyijʉ mani Ʉjʉ: —Coji wasa riojo wame cʉtiri majʉ. Itojʉ Judas wame cʉtigʉ ya wi ejagʉ yigʉja mʉ. ¿Ado ñati Saulo, Tarso gagʉ? yiba mʉ ĩre. Adocãta yʉre bʉsigʉ yami ĩ. ");
INSERT INTO myy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ĩ cãirojʉ mʉ ya rio ĩomʉ yʉ ĩre. Ito bajiri ĩ tʉ sãja ejacõri ĩre moaĩagʉ̃ yigʉja mʉ, mʉcana tʉdi ĩ cajea titoni. Ito bajirotire ĩ cãirojʉ ĩomʉ yʉ Saulore. Ito bajiri coji ĩ tʉ wasa mʉ, yiyijʉ Jesús Ananíasre ĩ cãirojʉ. ");
INSERT INTO myy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Iti tʉocõri ado bajiro yiyijʉ Ananías, Jesure bʉsigʉ: —Jaje oca tʉoa yʉ ĩ ye. Mʉre masiarãre, Jerusalénjʉ ñeñaro ĩ yigore, jaje oca ña ĩre. ");
INSERT INTO myy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ito yicõri paia ʉjarã ĩna roti ñucaja ado ejañi Saulo. Ito bajiri mʉre rʉ̃cʉbʉorã gʉa ñajare, gʉare tubiarocʉ ado ejañi Saulo, yiyijʉ Ananías Jesure. ");
INSERT INTO myy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ito yija Jesujʉa ado bajiro gotiyijʉ Ananíasre: —Yʉ oca masare riasorocʉre ĩre cũmʉ yʉ. Ʉjarã, judio masa, ito yicõri judio masa meje ñarãre cʉni riasogʉ yiguĩji Saulo. ");
INSERT INTO myy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yʉre cʉdigʉ ñari jaje ĩ tõbʉjaroca yirã yirãji gãjerã. Ĩ tʉ coji wasa mʉ, yiyijʉ Jesús Ananíasre. ");
INSERT INTO myy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ito ĩ yija tʉocõri, wayijʉ ĩ ĩja, Saulo tʉ wacʉ. Wijʉ sãja ejacõri ĩ ya ãmona moaĩayijʉ Ananías Saulore: —Yʉre tʉoya yʉ ocabaji mʉ. Mʉ wadiroca mʉre goaĩorʉti yʉre cõami. Jesús mani Ʉjʉ, ĩti cõami yʉre, mʉcana tʉdi mʉ cajea titoni, ito yicõri Espíritu Santo mʉ ya ʉsijʉ ĩ sãjatoni, yiyijʉ Ananías Saulore. ");
INSERT INTO myy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ito ĩ yirocati, wai rʉ̃tʉ̃ robo bajirise ĩ ya cajeajʉ codo quediyijʉ Saulore. Ito bajijare mʉcana tʉdi tiyijʉ Saulo. Ito bajija ticõri, “Yʉre idé guya mʉ”, yiyijʉ Saulo Ananíasre. ");
INSERT INTO myy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ito yija berojʉ bayijʉ Saulo mʉcana. Ito bajicõrijʉ sẽoyijʉ ĩ mʉcana. Ito bajiri Damascojʉ yoa bʉsari ñayijʉ Saulo, Jesure masirã rãca. ");
INSERT INTO myy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Judio masa ĩna minijuari wijʉ sãja wacõri, Jesús oca ĩnare riasoyijʉ Saulo. “Dios Macʉ ñami Jesús”, yiyijʉ Saulo. ");
INSERT INTO myy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ito ĩ yija tʉocõri, tʉo ʉcayijarã masa: —¿Ãni Saulo Jerusalénjʉ, Jesure masirãre sĩari masʉ meje ñati ãni? Ito yicõri, ¿Jesure masirãre ñiarocʉ meje adojʉ wadiyijari ĩ? ¿Ĩnare ñiacõri paia ʉjarãre ĩsibiquĩjida ĩ? yiyijarã masa. ");
INSERT INTO myy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ito bajiro ĩna tʉoĩabojarocati bʉto oca sẽocõri, Dios oca gotiyijʉ Saulo. “Riti ya yʉ, Cristo ĩti ñami Dios ĩ cõarʉ”, yiyijʉ Saulo. Queno tʉo masire rãca ĩ gotija, no bajiro cʉdi masibisijarã ĩna, judio masa Damasco gãna. ");
INSERT INTO myy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Damascojʉ, Saulo ĩ ñaroca riti, “Ĩre sĩarʉja mani”, yi tʉoĩayijarã judio masa. ");
INSERT INTO myy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ito bajiro ĩna sĩa ãmorã ĩna cʉníja, itire masicõyijʉ Saulo. Ñamiri cʉni, ʉ̃mʉari cʉni codeyijarã ĩna cʉto sojeri budirajʉri. Judio masa sojeri codeyijarã Saulore sĩarona. ");
INSERT INTO myy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ito bajiri Jesure tʉorʉ̃nʉrã ĩre ejabʉayijarã ĩna, ĩ rudi watoni. Cʉto camotara cʉní rijogodona jaja jibʉna ĩre sãcõri iti cʉní gaje dʉjajʉ ĩre rujiocõayijarã ĩna. Ñami ito bajiro ĩna yi sẽoja rudiyijʉ ĩ ĩja. ");
INSERT INTO myy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ito bajijare Jerusalénjʉ rudi wayijʉ ĩ. Jerusalénjʉ ejacõri, Jesure masirã rãca minijua ãmobojayijʉ ĩ. “Jesure masigʉ̃ meje ñaguĩji Saulo”, yi tʉoĩarã ĩre güiyijarã ĩna. ");
INSERT INTO myy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ito bajibojarocati, sĩgʉ̃ Bernabé wame cʉtigʉ, Saulore ejabʉayijʉ. “Waya, apóstol mesare bʉsito mani”, yiyijʉ Bernabé Saulore. Ĩna tʉ ejacõri ado bajiro bʉsiyijʉ Bernabé: “Ãni Saulore ĩ ma waroca Jesús goaĩoyijʉ ĩre. Ito yicõri ĩre bʉsiyijʉ Jesús. Damascojʉ masare güiari meje Jesús oca riasoñi Saulo”, yiyijʉ Bernabé apóstol mesare. ");
INSERT INTO myy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ito ĩ yija tʉocõri, Saulore boca ãmiyijarã ĩna. Ito yija Jerusalénjʉ tujacõri ĩna rãca wa ucuyijʉ Saulo. Güiari mejeti Jerusalén gãnare Jesús oca got